﻿USE sofia;
DROP TABLE IF EXISTS sofia.hrv_vpl;
CREATE TABLE hrv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hrv_vpl WRITE;
INSERT INTO hrv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","U početku stvori Bog nebo i zemlju. ");
INSERT INTO hrv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Zemlja bijaše pusta i prazna; tama se prostirala nad bezdanom i Duh Božji lebdio je nad vodama. ");
INSERT INTO hrv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","I reče Bog: “Neka bude svjetlost!” I bi svjetlost. ");
INSERT INTO hrv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","I vidje Bog da je svjetlost dobra; i rastavi Bog svjetlost od tame. ");
INSERT INTO hrv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Svjetlost prozva Bog dan, a tamu prozva noć. Tako bude večer, pa jutro - dan prvi. ");
INSERT INTO hrv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","I reče Bog: “Neka bude svod posred voda da dijeli vode od voda!” I bi tako. ");
INSERT INTO hrv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bog načini svod i vode pod svodom odijeli od voda nad svodom. ");
INSERT INTO hrv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","A svod prozva Bog nebo. Tako bude večer, pa jutro - dan drugi. ");
INSERT INTO hrv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","I reče Bog: “Vode pod nebom neka se skupe na jedno mjesto i neka se pokaže kopno!” I bi tako. ");
INSERT INTO hrv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kopno prozva Bog zemlja, a skupljene vode mora. I vidje Bog da je dobro. ");
INSERT INTO hrv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","I reče Bog: “Neka proklija zemlja zelenilom - travom sjemenitom, stablima plodonosnim, koja, svako prema svojoj vrsti, na zemlji donose plod što u sebi nosi svoje sjeme. I bi tako. ");
INSERT INTO hrv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","I nikne iz zemlje zelena trava što se sjemeni, svaka prema svojoj vrsti, i stabla koja rode plodovima što u sebi nose svoje sjeme, svako prema svojoj vrsti. I vidje Bog da je dobro. ");
INSERT INTO hrv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Tako bude večer, pa jutro - dan treći. ");
INSERT INTO hrv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","I reče Bog: “Neka budu svjetlila na svodu nebeskom da luče dan od noći, da budu znaci blagdanima, danima i godinama, ");
INSERT INTO hrv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","i neka svijetle na svodu nebeskom i rasvjetljuju zemlju!” I bi tako. ");
INSERT INTO hrv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","I načini Bog dva velika svjetlila - veće da vlada danom, manje da vlada noću - i zvijezde. ");
INSERT INTO hrv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","I Bog ih postavi na svod nebeski da rasvjetljuju zemlju, ");
INSERT INTO hrv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","da vladaju danom i noću i da rastavljaju svjetlost od tame. I vidje Bog da je dobro. ");
INSERT INTO hrv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Tako bude večer, pa jutro - dan četvrti. ");
INSERT INTO hrv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","I reče Bog: “Nek' povrvi vodom vreva živih stvorova, i ptice nek' polete nad zemljom, svodom nebeskim!” I bi tako. ");
INSERT INTO hrv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Stvori Bog morske grdosije i svakovrsne žive stvorove što mile i vrve vodom i ptice krilate svake vrste. I vidje Bog da je dobro. ");
INSERT INTO hrv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","I blagoslovi ih govoreći: “Plodite se i množite i napunite vode morske! I ptice neka se namnože na zemlji!” ");
INSERT INTO hrv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Tako bude večer, pa jutro - dan peti. ");
INSERT INTO hrv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","I reče Bog: “Neka zemlja izvede živa bića, svako prema svojoj vrsti: stoku, gmizavce i zvjerad svake vrste!” I bi tako. ");
INSERT INTO hrv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","I stvori Bog svakovrsnu zvjerad, stoku i gmizavce svake vrste. I vidje Bog da je dobro. ");
INSERT INTO hrv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","I reče Bog: “Načinimo čovjeka na svoju sliku, sebi slična, da bude gospodar ribama morskim, pticama nebeskim i stoci - svoj zemlji - i svim gmizavcima što puze po zemlji!” ");
INSERT INTO hrv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Na svoju sliku stvori Bog čovjeka, na sliku Božju on ga stvori, muško i žensko stvori ih. ");
INSERT INTO hrv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","I blagoslovi ih Bog i reče im: “Plodite se, i množite, i napunite zemlju, i sebi je podložite! Vladajte ribama u moru i pticama u zraku i svim živim stvorovima što puze po zemlji!” ");
INSERT INTO hrv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","I doda Bog: “Evo, dajem vam sve bilje što se sjemeni, po svoj zemlji, i sva stabla plodonosna što u sebi nose svoje sjeme: neka vam budu za hranu! ");
INSERT INTO hrv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","A zvijerima na zemlji i pticama u zraku i gmizavcima što puze po zemlji u kojima je dah života - neka je za hranu sve zeleno bilje!” I bi tako. ");
INSERT INTO hrv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","I vidje Bog sve što je učinio, i bijaše veoma dobro. Tako bude večer, pa jutro - dan šesti. ");
INSERT INTO hrv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tako bude dovršeno nebo i zemlja sa svom svojom vojskom. ");
INSERT INTO hrv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","I sedmoga dana Bog dovrši svoje djelo koje učini. I počinu u sedmi dan od svega djela koje učini. ");
INSERT INTO hrv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","I blagoslovi Bog sedmi dan i posveti, jer u taj dan počinu od svega djela svoga koje učini. ");
INSERT INTO hrv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","To je postanak neba i zemlje, tako su stvarani. Kad je Jahve, Bog, sazdao nebo i zemlju, ");
INSERT INTO hrv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","još nije bilo nikakva poljskoga grmlja po zemlji, još ne bijaše niklo nikakvo poljsko bilje, jer Jahve, Bog, još ne pusti dažda na zemlju i nije bilo čovjeka da zemlju obrađuje. ");
INSERT INTO hrv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ipak, voda je izvirala iz zemlje i natapala svu površinu zemaljsku. ");
INSERT INTO hrv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Jahve, Bog, napravi čovjeka od praha zemaljskog i u nosnice mu udahne dah života. Tako postane čovjek živa duša. ");
INSERT INTO hrv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","I Jahve, Bog, zasadi vrt na istoku, u Edenu, i u nj smjesti čovjeka koga je napravio. ");
INSERT INTO hrv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tada Jahve, Bog, učini te iz zemlje nikoše svakovrsna stabla - pogledu zamamljiva a dobra za hranu - i stablo života, nasred vrta, i stablo spoznaje dobra i zla. ");
INSERT INTO hrv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Rijeka je izvirala iz Edena da bi natapala vrt; odatle se granala u četiri kraka. ");
INSERT INTO hrv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Prvom je ime Pišon, a optječe svom zemljom havilskom, u kojoj ima zlata. ");
INSERT INTO hrv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Zlato je te zemlje dobro, a ima ondje i bdelija i oniksa. ");
INSERT INTO hrv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Drugoj je rijeci ime Gihon, a optječe svu zemlju Kuš. ");
INSERT INTO hrv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Treća je rijeka Tigris, a teče na istok od Ašura; četvrta je Eufrat. ");
INSERT INTO hrv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Jahve, Bog, uzme čovjeka i postavi ga u edenski vrt da ga obrađuje i čuva. ");
INSERT INTO hrv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Jahve, Bog, zapovjedi čovjeku: “Sa svakoga stabla u vrtu slobodno jedi, ");
INSERT INTO hrv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ali sa stabla spoznaje dobra i zla da nisi jeo! U onaj dan u koji s njega okusiš, zacijelo ćeš umrijeti!” ");
INSERT INTO hrv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","I reče Jahve, Bog: “Nije dobro da čovjek bude sam: načinit ću mu pomoć kao što je on.” ");
INSERT INTO hrv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tada Jahve, Bog, načini od zemlje sve životinje u polju i sve ptice u zraku i predvede ih čovjeku da vidi kako će koju nazvati, pa kako koje stvorenje čovjek prozove, da mu tako bude ime. ");
INSERT INTO hrv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Čovjek nadjene imena svoj stoci, svim pticama u zraku i životinjama u polju. No čovjeku se ne nađe pomoć kao što je on. ");
INSERT INTO hrv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tada Jahve, Bog, pusti tvrd san na čovjeka te on zaspa, pa mu izvadi jedno rebro, a mjesto zatvori mesom. ");
INSERT INTO hrv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Od rebra što ga je uzeo čovjeku napravi Jahve, Bog, ženu pa je dovede čovjeku. ");
INSERT INTO hrv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nato čovjek reče: “Gle, evo kosti od mojih kostiju, mesa od mesa mojega! Ženom neka se zove, od čovjeka kad je uzeta!” ");
INSERT INTO hrv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Stoga će čovjek ostaviti oca i majku da prione uza svoju ženu i bit će njih dvoje jedno tijelo. ");
INSERT INTO hrv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","A bijahu oboje goli - čovjek i njegova žena - ali ne osjećahu stida. ");
INSERT INTO hrv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Zmija bijaše lukavija od sve zvjeradi što je stvori Jahve, Bog. Ona reče ženi: “Zar vam je Bog rekao da ne smijete jesti ni s jednog drveta u vrtu?” ");
INSERT INTO hrv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Žena odgovori zmiji: “Plodove sa stabala u vrtu smijemo jesti. ");
INSERT INTO hrv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Samo za plod stabla što je nasred vrta rekao je Bog: 'Da ga niste jeli! I ne dirajte u nj, da ne umrete!'” ");
INSERT INTO hrv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nato će zmija ženi: “Ne, nećete umrijeti! ");
INSERT INTO hrv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nego, zna Bog: onog dana kad budete s njega jeli, otvorit će vam se oči, i vi ćete biti kao bogovi koji razlučuju dobro i zlo.” ");
INSERT INTO hrv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Vidje žena da je stablo dobro za jelo, za oči zamamljivo, a za mudrost poželjno: ubere ploda njegova i pojede. Dade i svom mužu, koji bijaše s njom, pa je i on jeo. ");
INSERT INTO hrv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tada se obadvoma otvore oči i upoznaju da su goli. Spletu smokova lišća i naprave sebi pregače. ");
INSERT INTO hrv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Uto čuju korak Jahve, Boga, koji je šetao vrtom za dnevnog povjetarca. I sakriju se - čovjek i njegova žena - pred Jahvom, Bogom, među stabla u vrtu. ");
INSERT INTO hrv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Jahve, Bog, zovne čovjeka: “Gdje si?” - reče mu. ");
INSERT INTO hrv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","On odgovori: “Čuo sam tvoj korak po vrtu; pobojah se jer sam go, pa se sakrih.” ");
INSERT INTO hrv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nato mu reče: “Tko ti kaza da si go? Ti si, dakle, jeo sa stabla s kojega sam ti zabranio jesti?” ");
INSERT INTO hrv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Čovjek odgovori: “Žena koju si stavio uza me - ona mi je dala sa stabla pa sam jeo.” ");
INSERT INTO hrv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Jahve, Bog, reče ženi: “Što si to učinila?” “Zmija me prevarila pa sam jela”, odgovori žena. ");
INSERT INTO hrv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Nato Jahve, Bog, reče zmiji: “Kad si to učinila, prokleta bila među svim životinjama i svom zvjeradi divljom! Po trbuhu svome puzat ćeš i zemlju jesti sveg života svog! ");
INSERT INTO hrv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Neprijateljstvo ja zamećem između tebe i žene, između roda tvojeg i roda njezina: on će ti glavu satirati, a ti ćeš mu vrebati petu.” ");
INSERT INTO hrv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A ženi reče: “Trudnoći tvojoj muke ću umnožit, u mukama djecu ćeš rađati. Žudnja će te mužu tjerati, a on će gospodariti nad tobom.” ");
INSERT INTO hrv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","A čovjeku reče: “Jer si poslušao glas svoje žene te jeo sa stabla s kojega sam ti zabranio jesti rekavši: S njega da nisi jeo! - evo: Zemlja neka je zbog tebe prokleta: s trudom ćeš se od nje hraniti svega vijeka svog! ");
INSERT INTO hrv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Rađat će ti trnjem i korovom, a hranit ćeš se poljskim raslinjem. ");
INSERT INTO hrv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","U znoju lica svoga kruh svoj ćeš jesti dokle se u zemlju ne vratiš: tÓa iz zemlje uzet si bio - prah si, u prah ćeš se i vratiti.” ");
INSERT INTO hrv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Svojoj ženi čovjek nadjene ime Eva, jer je majka svima živima. ");
INSERT INTO hrv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","I načini Jahve, Bog, čovjeku i njegovoj ženi odjeću od krzna pa ih odjenu. ");
INSERT INTO hrv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Zatim reče Bog: “Evo, čovjek postade kao jedan od nas - znajući dobro i zlo! Da ne bi sada pružio ruku, ubrao sa stabla života pa pojeo i živio navijeke!” ");
INSERT INTO hrv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Zato ga Jahve, Bog, istjera iz vrta edenskoga da obrađuje zemlju iz koje je i uzet. ");
INSERT INTO hrv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Istjera, dakle, čovjeka i nastani ga istočno od vrta edenskog, pa postavi kerubine i plameni mač koji se svjetlucao - da straže nad stazom koja vodi k stablu života. ");
INSERT INTO hrv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Čovjek pozna svoju ženu Evu, a ona zače i rodi Kajina, pa reče: “Muško sam čedo stekla pomoću Jahve!” ");
INSERT INTO hrv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Poslije rodi Abela, brata Kajinova; Abel postane stočar, a Kajin zemljoradnik. ");
INSERT INTO hrv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","I jednoga dana Kajin prinese Jahvi žrtvu od zemaljskih plodova. ");
INSERT INTO hrv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","A prinese i Abel od prvine svoje stoke, sve po izbor pretilinu. Jahve milostivo pogleda na Abela i njegovu žrtvu, ");
INSERT INTO hrv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","a na Kajina i žrtvu njegovu ni pogleda ne svrati. Stoga se Kajin veoma razljuti i lice mu se namrgodi. ");
INSERT INTO hrv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","I Jahve reče Kajinu: “Zašto si ljut? Zašto ti je lice namrgođeno? ");
INSERT INTO hrv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Jer ako pravo radiš, vedrinom odsijevaš. A ne radiš li pravo, grijeh ti je kao zvijer na pragu što na te vreba; još mu se možeš oduprijeti.” ");
INSERT INTO hrv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kajin pak reče svome bratu Abelu: “Hajdemo van!” I našavši se na polju, Kajin skoči na brata Abela te ga ubi. ");
INSERT INTO hrv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Potom Jahve zapita Kajina: “Gdje ti je brat Abel?” “Ne znam”, odgovori. “Zar sam ja čuvar brata svoga?” ");
INSERT INTO hrv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Jahve nastavi: “Što si učinio? Slušaj! Krv brata tvoga iz zemlje k meni viče. ");
INSERT INTO hrv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Stoga budi proklet na zemlji koja je rastvorila usta da proguta s ruke tvoje krv brata tvoga! ");
INSERT INTO hrv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Obrađivat ćeš zemlju, ali ti više neće davati svoga roda. Vječni ćeš skitalica na zemlji biti!” ");
INSERT INTO hrv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","A Kajin reče Jahvi: “Kazna je moja odviše teška da se snosi. ");
INSERT INTO hrv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Evo me tjeraš danas s plodnoga tla; moram se skrivati od tvoga lica i biti vječni lutalac na zemlji - tko me god nađe, može me ubiti.” ");
INSERT INTO hrv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","A Jahve mu reče: “Ne! Nego tko ubije Kajina, sedmerostruka osveta na njemu će se izvršiti!” I Jahve stavi znak na Kajina, da ga tko, našavši ga, ne ubije. ");
INSERT INTO hrv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kajin ode ispred lica Jahvina u zemlju Nod, istočno od Edena, i ondje se nastani. ");
INSERT INTO hrv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kajin pozna svoju ženu te ona zače i rodi Henoka. Podigao je grad i grad prozvao imenom svoga sina - Henok. ");
INSERT INTO hrv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henoku se rodio Irad, a od Irada potekao Mehujael; od Mehujaela poteče Metušael, od Metušaela Lamek. ");
INSERT INTO hrv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek uzme dvije žene. Jedna se zvala Ada, a druga Sila. ");
INSERT INTO hrv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada rodi Jabala, koji je postao praocem onih što pod šatorima žive sa stokom. ");
INSERT INTO hrv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Bratu mu bijaše ime Jubal. On je praotac svih koji sviraju na liru i sviralu. ");
INSERT INTO hrv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila rodi Tubal-Kajina, praoca onih koji kuju bakar i željezo. Tubal-Kajinovoj sestri bijaše ime Naama. ");
INSERT INTO hrv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek prozbori svojim ženama: “Ada i Sila, glas moj poslušajte! Žene Lamekove, čujte mi besjedu: Čovjeka sam ubio jer me ranio i dijete jer me udarilo. ");
INSERT INTO hrv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ako će Kajin biti osvećen sedmerostruko, Lamek će sedamdeset i sedam puta!” ");
INSERT INTO hrv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam pozna svoju ženu te ona rodi sina i nadjenu mu ime Šet. Reče ona: “Bog mi dade drugo dijete mjesto Abela, koga ubi Kajin.” ");
INSERT INTO hrv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Šetu se rodi sin, komu on nadjenu ime Enoš. Tada se počelo zazivati ime Jahvino. ");
INSERT INTO hrv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ovo je povijest Adamova roda. Kad je Bog stvorio čovjeka, napravio ga je na priliku svoju; ");
INSERT INTO hrv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","stvorio je muško i žensko. A kad ih je stvorio, blagoslovi ih i nazva - čovjek. ");
INSERT INTO hrv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Kad je Adamu bilo sto i trideset godina, rodi mu se sin njemu sličan, na njegovu sliku; nadjenu mu ime Šet. ");
INSERT INTO hrv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Po rođenju Šetovu Adam je živio osam stotina godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam poživje u svemu devet stotina i trideset godina. Potom umrije. ");
INSERT INTO hrv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Kad je Šetu bilo sto i pet godina, rodi mu se Enoš. ");
INSERT INTO hrv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Po rođenju Enoševu Šet je živio osam stotina i sedam godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Šet poživje u svemu devet stotina i dvanaest godina. Potom umrije. ");
INSERT INTO hrv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Kad je Enošu bilo devedeset godina, rodi mu se Kenan. ");
INSERT INTO hrv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Po rođenju Kenanovu Enoš je živio osam stotina i petnaest godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoš poživje u svemu devet stotina i pet godina. Potom umrije. ");
INSERT INTO hrv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kad je Kenanu bilo sedamdeset godina, rodi mu se Mahalalel. ");
INSERT INTO hrv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Po rođenju Mahalalelovu Kenan je živio osam stotina i četrdeset godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan poživje u svemu devet stotina i deset godina. Potom umrije. ");
INSERT INTO hrv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Kad je Mahalalelu bilo šezdeset i pet godina, rodi mu se Jered. ");
INSERT INTO hrv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Po rođenju Jeredovu Mahalalel je živio osam stotina i trideset godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel poživje u svemu osam stotina devedeset i pet godina. Potom umrije. ");
INSERT INTO hrv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Kad je Jeredu bilo sto šezdeset i dvije godine, rodi mu se Henok. ");
INSERT INTO hrv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Po rođenju Henokovu Jered je živio osam stotina godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jered poživje u svemu devet stotina šezdeset i dvije godine. Potom umrije. ");
INSERT INTO hrv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Kad je Henoku bilo šezdeset i pet godina, rodi mu se Metušalah. ");
INSERT INTO hrv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henok je hodio s Bogom. Po rođenju Metušalahovu Henok je živio trista godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henok poživje u svemu trista šezdeset i pet godina. ");
INSERT INTO hrv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henok je hodio s Bogom, potom iščeznu; Bog ga uze. ");
INSERT INTO hrv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Kad je Metušalahu bilo sto osamdeset i sedam godina, rodi mu se Lamek. ");
INSERT INTO hrv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Po rođenju Lamekovu Metušalah je živio sedam stotina osamdeset i dvije godine te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metušalah poživje u svemu devet stotina šezdeset i devet godina. Potom umrije. ");
INSERT INTO hrv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Kad su Lameku bile sto osamdeset i dvije godine, rodi mu se sin. ");
INSERT INTO hrv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nadjene mu ime Noa, govoreći: “Ovaj će nam pribavljati, u trudu i naporu naših ruku, utjehu iz zemlje koju je Bog prokleo.” ");
INSERT INTO hrv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Po rođenju Noinu Lamek je živio pet stotina devedeset i pet godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek poživje u svemu sedam stotina sedamdeset i sedam godina. Potom umrije. ");
INSERT INTO hrv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Pošto je Noa proživio pet stotina godina, rode mu se Šem, Ham i Jafet. ");
INSERT INTO hrv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kad su se ljudi počeli širiti po zemlji i kćeri im se narodile, ");
INSERT INTO hrv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","opaze sinovi Božji da su kćeri ljudske pristale, pa ih uzimahu sebi za žene koje su god htjeli. ");
INSERT INTO hrv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Onda Jahve reče: “Neće moj duh u čovjeku ostati dovijeka; čovjek je tjelesan, pa neka mu vijek bude stotinu dvadeset godina.” ");
INSERT INTO hrv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","U ona su vremena - a i kasnije - na zemlji bili Nefili, kad su Božji sinovi općili s ljudskim kćerima pa im one rađale djecu. To su oni od starine po snazi glasoviti ljudi. ");
INSERT INTO hrv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Vidje Jahve kako je čovjekova pokvarenost na zemlji velika i kako je svaka pomisao u njegovoj pameti uvijek samo zloća. ");
INSERT INTO hrv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Jahve se pokaja i u svom srcu ražalosti što je načinio čovjeka na zemlji. ");
INSERT INTO hrv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Reče Jahve: “Ljude koje sam stvorio izbrisat ću s lica zemlje - od čovjeka do zvijeri, puzavce i ptice u zraku - jer sam se pokajao što sam ih napravio.” ");
INSERT INTO hrv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ali je Noa našao milost u očima Jahvinim. ");
INSERT INTO hrv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ovo je povijest Noina: Noa je bio čovjek pravedan i neporočan u svom vremenu. S Bogom je Noa hodio. ");
INSERT INTO hrv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Tri su se sina rodila Noi: Šem, Ham i Jafet. ");
INSERT INTO hrv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","U očima Božjim zemlja se bila iskvarila; nepravdom se napunila. ");
INSERT INTO hrv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","I kad je Bog vidio kako se zemlja iskvarila - tÓa svako se biće na zemlji izopačilo - ");
INSERT INTO hrv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","reče Bog Noi: “Odlučio sam da bude kraj svim bićima jer se zemlja napunila opačinom; i, evo, uništit ću ih zajedno sa zemljom. ");
INSERT INTO hrv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Napravi sebi korablju od smolastoga drveta; korablju načini s prijekletima i obloži je iznutra i izvana paklinom. ");
INSERT INTO hrv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","A pravit ćeš je ovako: neka korablja bude trista lakata u duljinu, pedeset u širinu, a trideset lakata u visinu. ");
INSERT INTO hrv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Na korablji načini otvor za svjetlo, završi ga jedan lakat od vrha. Vrata na korablji načini sa strane; neka ima donji, srednji i gornji kat. ");
INSERT INTO hrv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ja ću, evo, pustiti potop - vode na zemlju - da izgine svako biće pod nebom, sve u čemu ima dah života: sve na zemlji mora poginuti. ");
INSERT INTO hrv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","A s tobom ću učiniti Savez; ti ćeš ući u korablju - ti i s tobom tvoji sinovi, tvoja žena i žene tvojih sinova. ");
INSERT INTO hrv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","A od svega što je živo - od svih bića - uvedi u korablju od svakoga po dvoje da s tobom preživi, i neka budu muško i žensko. ");
INSERT INTO hrv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Od ptica prema njihovim vrstama, od životinja prema njihovim vrstama i od svih stvorova što po tlu puze prema njihovim vrstama: po dvoje od svega neka uđe k tebi da preživi. ");
INSERT INTO hrv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Sa sobom uzmi svega za jelo pa čuvaj da bude hrane tebi i njima.” ");
INSERT INTO hrv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa učini tako. Sve kako mu je Bog naredio, tako je izvršio. ");
INSERT INTO hrv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Onda Jahve reče Noi: “Uđi ti i sva tvoja obitelj u korablju, jer sam uvidio da si ti jedini preda mnom pravedan u ovom vremenu. ");
INSERT INTO hrv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Uzmi sa sobom od svih čistih životinja po sedam parova: mužjaka i njegovu ženku. ");
INSERT INTO hrv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Isto tako od ptica nebeskih po sedam parova - mužjaka i ženku - da im se sjeme sačuva na zemlji. ");
INSERT INTO hrv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Jer ću do sedam dana pustiti dažd po zemlji četrdeset dana i četrdeset noći te ću istrijebiti s lica zemlje svako živo biće što sam ga načinio.” ");
INSERT INTO hrv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa učini sve kako mu je Jahve naredio. ");
INSERT INTO hrv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noi bijaše šest stotina godina kad je potop došao na zemlju. ");
INSERT INTO hrv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","I pred vodama potopnim uđu s Noom u korablju njegovi sinovi, njegova žena i žene sinova njegovih. ");
INSERT INTO hrv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Od čistih životinja i od životinja koje nisu čiste, od ptica, od svega što zemljom puzi, ");
INSERT INTO hrv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","uđe po dvoje - mužjak i ženka - u korablju s Noom, kako je Bog naredio Noi. ");
INSERT INTO hrv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","A sedmoga dana zapljušte potopne vode po zemlji. ");
INSERT INTO hrv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","U dan onaj - šestote godine Noina života, mjeseca drugog, dana u mjesecu sedamnaestog - navale svi izvori bezdana, rastvore se ustave nebeske. ");
INSERT INTO hrv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","I udari dažd na zemlju da pljušti četrdeset dana i četrdeset noći. ");
INSERT INTO hrv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Onog dana uđe u korablju Noa i njegovi sinovi: Šem, Ham i Jafet, Noina žena i tri žene Noinih sinova s njima; ");
INSERT INTO hrv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","oni, pa sve vrste životinja: stoka, gmizavci što po tlu gmižu, ptice i svakovrsna krilata stvorenja, ");
INSERT INTO hrv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","uđu u korablju s Noom, po dvoje od svih bića što u sebi imaju dah života. ");
INSERT INTO hrv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Što uđe, sve bijaše par, mužjak i ženka od svih bića, kako je Bog naredio Noi. Onda Jahve zatvori za njim vrata. ");
INSERT INTO hrv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Pljusak je na zemlju padao četrdeset dana; vode sveudilj rasle i korablju nosile: digla se visoko iznad zemlje. ");
INSERT INTO hrv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Vode su nad zemljom bujale i visoko rasle, a korablja plovila površinom. ");
INSERT INTO hrv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Vode su sve silnije navaljivale i rasle nad zemljom, tako te prekriše sva najviša brda pod nebom. ");
INSERT INTO hrv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Petnaest lakata dizale se vode povrh potonulih brda. ");
INSERT INTO hrv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Izgiboše sva bića što se po zemlji kreću: ptice, stoka, zvijeri, svi gmizavci i svi ljudi. ");
INSERT INTO hrv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Sve što u svojim nosnicama imaše dah života - sve što bijaše na kopnu - izgibe. ");
INSERT INTO hrv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Istrijebi se svako biće s površja zemaljskog: čovjek, životinje, gmizavci i ptice nebeske, sve se izbrisa sa zemlje. Samo Noa ostade i oni što bijahu s njim u korablji. ");
INSERT INTO hrv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Stotinu pedeset dana vladahu vode zemljom. ");
INSERT INTO hrv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Onda se Bog sjeti Noe, svih zvijeri i sve stoke što bijaše s njim u korablji, pa pokrenu vjetar nad zemljom da uzbije vodu. ");
INSERT INTO hrv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Zatvoriše se izvori bezdanu i ustave nebeske, i dažd s neba prestade. ");
INSERT INTO hrv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Polako se povlačile vode sa zemlje. Nakon stotinu pedeset dana vode su jenjale, ");
INSERT INTO hrv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","a sedmoga mjeseca, sedamnaestog dana u mjesecu korablja se zaustavi na brdima Ararata. ");
INSERT INTO hrv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Vode su neprestano opadale do desetog mjeseca, a prvoga dana desetog mjeseca pokažu se brdski vrhunci. ");
INSERT INTO hrv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kad je izminulo četrdeset dana, Noa otvori prozor što ga je načinio na korablji; ");
INSERT INTO hrv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ispusti gavrana, a gavran svejednako odlijetaše i dolijetaše dok se vode sa zemlje nisu isušile. ");
INSERT INTO hrv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Zatim ispusti golubicu da vidi je li voda nestala sa zemlje. ");
INSERT INTO hrv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ali golubica ne nađe uporišta nogama te se vrati k njemu u korablju, jer voda još pokrivaše svu površinu; on pruži ruku, uhvati golubicu te je unese k sebi u korablju. ");
INSERT INTO hrv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Počeka još sedam dana pa opet pusti golubicu iz korablje. ");
INSERT INTO hrv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Prema večeri golubica se vrati k njemu, i gle! u kljunu joj svjež maslinov list; tako je Noa doznao da su opale vode sa zemlje. ");
INSERT INTO hrv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Još počeka sedam dana pa opet pusti golubicu: više mu se nije vratila. ");
INSERT INTO hrv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Šest stotina prve godine Noina života, prvoga mjeseca, prvog dana u mjesecu uzmakoše vode sa zemlje. Noa skine pokrov s korablje i pogleda: površina okopnjela. ");
INSERT INTO hrv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","A drugoga mjeseca, sedamnaestog dana u mjesecu, zemlja bijaše suha. ");
INSERT INTO hrv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tada Bog reče Noi: ");
INSERT INTO hrv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Iziđi iz korablje, ti, tvoja žena, tvoji sinovi i žene tvojih sinova s tobom. ");
INSERT INTO hrv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Sa sobom izvedi sva živa bića, sva stvorenja što su s tobom: ptice, stoku i sve gmizavce što zemljom puze; neka zemljom vrve, plode se i na zemlji množe!” ");
INSERT INTO hrv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","I Noa iziđe, a s njime sinovi njegovi, žena njegova i žene sinova njegovih. ");
INSERT INTO hrv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sve životinje, svi gmizavci, sve ptice - svi stvorovi što se zemljom miču - iziđu iz korablje, vrsta za vrstom. ");
INSERT INTO hrv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","I podiže Noa žrtvenik Jahvi; uze od svih čistih životinja i od svih čistih ptica i prinese na žrtveniku žrtve paljenice. ");
INSERT INTO hrv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Jahve omirisa miris ugodni pa reče u sebi: “Nikad više neću zemlju u propast strovaliti zbog čovjeka, tÓa čovječje su misli opake od njegova početka; niti ću ikad više uništiti sva živa stvorenja, kako sam učinio. ");
INSERT INTO hrv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Sve dok zemlje bude, sjetve, žetve, studeni, vrućine, ljeta, zime, dani, noći nikada prestati neće.” ");
INSERT INTO hrv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Tada Bog blagoslovi Nou i njegove sinove i reče im: “Plodite se i množite i zemlju napunite. ");
INSERT INTO hrv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Neka vas se boje i od vas strahuju sve životinje na zemlji, sve ptice u zraku, sve što se po zemlji kreće i sve ribe u moru: u vaše su ruke predane. ");
INSERT INTO hrv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Sve što se kreće i živi neka vam bude za hranu: sve vam dajem, kao što vam dadoh zeleno bilje. ");
INSERT INTO hrv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Samo ne smijete jesti mesa u kojem je još duša, to jest njegova krv. ");
INSERT INTO hrv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","A za vašu krv, za vaš život, tražit ću obračun: tražit ću ga od svake životinje; i od čovjeka za njegova druga tražit ću obračun za ljudski život. ");
INSERT INTO hrv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tko prolije krv čovjekovu, njegovu će krv čovjek proliti! Jer na sliku Božju stvoren je čovjek! ");
INSERT INTO hrv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","A vi, plodite se, i množite i zemlju napunite, i podložite je sebi!” ");
INSERT INTO hrv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Još reče Bog Noi i njegovim sinovima s njim: ");
INSERT INTO hrv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“A ja, evo, sklapam svoj Savez s vama i s vašim potomstvom poslije vas ");
INSERT INTO hrv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","i sa svim živim stvorovima što su s vama: s pticama, sa stokom, sa zvijerima - sa svime što je s vama izišlo iz korablje - sa svim živim stvorovima na zemlji. ");
INSERT INTO hrv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Držat ću se ja svog Saveza s vama te nikada više vode potopne neće uništiti živa bića niti će ikad više potop zemlju opustošiti.” ");
INSERT INTO hrv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","I reče Bog: “A ovo znamen je Saveza koji stavljam između sebe i vas i svih živih bića što su s vama, za naraštaje buduće: ");
INSERT INTO hrv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Dugu svoju u oblak stavljam, da zalogom bude Savezu između mene i zemlje. ");
INSERT INTO hrv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kad oblake nad zemlju navučem i duga se u oblaku pokaže, ");
INSERT INTO hrv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","spomenut ću se Saveza svoga, Saveza između mene i vas i stvorenja svakoga živog: potopa više neće biti da uništi svako biće. ");
INSERT INTO hrv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","U oblaku kad se pojavi duga, ja ću je vidjeti i vjekovnog ću se sjećati Saveza između Boga i svake žive duše, svakog tijela na zemlji.” ");
INSERT INTO hrv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","I reče Bog Noi: “To neka je znak Saveza koji sam postavio između sebe i svih živih bića što su na zemlji.” ");
INSERT INTO hrv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Sinovi Noini, koji su iz korablje izišli, bijahu: Šem, Ham i Jafet. Ham je praotac Kanaanaca. ");
INSERT INTO hrv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ovo su trojica Noinih sinova i od njih se sav svijet razgranao. ");
INSERT INTO hrv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa, zemljoradnik, zasadio vinograd. ");
INSERT INTO hrv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Napio se vina i opio, pa se otkrio nasred šatora. ");
INSERT INTO hrv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, praotac Kanaanaca, opazi oca gola pa to kaza dvojici svoje braće vani. ");
INSERT INTO hrv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Šem i Jafet uzmu ogrtač, obojica ga prebace sebi preko ramena pa njime, idući natraške, pokriju očevu golotinju. Lica im bijahu okrenuta na drugu stranu, tako te ne vidješe oca gola. ");
INSERT INTO hrv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kad se Noa otrijeznio od vina i saznao što mu je učinio najmlađi sin, reče: ");
INSERT INTO hrv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“Neka je proklet Kanaanac, braći svojoj najniži sluga nek' bude!” ");
INSERT INTO hrv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Onda nastavi: “Blagoslovljen Jahve, Šemov Bog, Kanaanac nek' mu je sluga! ");
INSERT INTO hrv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nek Bog raširi Jafeta da prebiva pod šatorima Šemovim, Kanaanac nek' mu je sluga!” ");
INSERT INTO hrv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Poslije Potopa Noa poživje trista pedeset godina. ");
INSERT INTO hrv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","U svemu poživje Noa devet stotina pedeset godina; potom umrije. ");
INSERT INTO hrv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ovo je povijest Noinih sinova: Šema, Hama i Jafeta, kojima su se rodili sinovi poslije Potopa. ");
INSERT INTO hrv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Sinovi su Jafetovi: Gomer, Magog, Madaj, Javan, Tubal, Mešak, Tiras. ");
INSERT INTO hrv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","A sinovi su Gomerovi: Aškenaz, Rifat i Togarma. ");
INSERT INTO hrv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javanovi su opet sinovi: Eliša, Taršiš, Kitijci i Dodanci. ");
INSERT INTO hrv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Od njih su se razgranali narodi po otocima. To su Jafetovi sinovi prema svojim zemljama - svaki s vlastitim jezikom - prema svojim plemenima i narodima. ");
INSERT INTO hrv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Sinovi su Hamovi: Kuš i Misrajim, Put i Kanaan. ");
INSERT INTO hrv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuševi su: Seba, Havila, Sabta, Rama i Sabteka. Ramini su: Šeba i Dedan. ");
INSERT INTO hrv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Od Kuša se rodio Nimrod, koji je postao prvi velmoža na zemlji. ");
INSERT INTO hrv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Voljom Jahve bio je silan lovac. Zato se veli: “Kao Nimrod, silan lovac voljom Jahve.” ");
INSERT INTO hrv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Glavno uporište njegova kraljevstva bili su: Babilon, Erek, Akad i Kalne, svi u zemlji Šinearu. ");
INSERT INTO hrv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Iz ove je zemlje došao Ašur. On je podigao Ninivu, Rehobot Ir, Kalah ");
INSERT INTO hrv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","i Resen između Ninive i Kalaha (to je glavni grad). ");
INSERT INTO hrv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Od Misrajima potekli su Ludijci, Anamijci, Lehabijci, Naftuhijci, ");
INSERT INTO hrv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","pa Patrušani, Kasluhijci i Kaftorci, od kojih su potekli Filistejci. ");
INSERT INTO hrv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Od Kanaana potječe Sidon, njegov prvenac, i Het. ");
INSERT INTO hrv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Dalje: Jebusejci, Amorejci, Girgašani, ");
INSERT INTO hrv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivijci, Arkijci, Sinijci, ");
INSERT INTO hrv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvađani, Semarjani i Hamaćani. Poslije se kanaanska plemena razgranaše, ");
INSERT INTO hrv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","tako da se granica Kanaanaca protezala od Sidona prema Geraru sve do Gaze pa prema Sodomi, Gomori, Admi i Sebojimu sve do Leše. ");
INSERT INTO hrv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","To su sinovi Hamovi prema svojim plemenima i jezicima, po svojim zemljama i narodima. ");
INSERT INTO hrv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","A i Šemu - praocu svih sinova Eberovih i starijem bratu Jafetovu - rodili se sinovi. ");
INSERT INTO hrv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Šemovi su sinovi: Elam, Ašur, Arpakšad, Lud i Aram. ");
INSERT INTO hrv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","A Aramovi su sinovi: Us, Hul, Geter i Maš. ");
INSERT INTO hrv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakšad rodi Šelaha, Šelah rodi Ebera. ");
INSERT INTO hrv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberu su se rodila dva sina: jednomu bješe ime Peleg, jer se za njegova vijeka zemlja razdijelila. Njegovu je bratu bilo ime Joktan. ");
INSERT INTO hrv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Od Joktana se rodiše: Almodad, Šelef, Hasarmavet, Jerah, ");
INSERT INTO hrv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO hrv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Šeba, ");
INSERT INTO hrv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila i Jobab. Sve su to sinovi Joktanovi. ");
INSERT INTO hrv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Njihova se naselja protezahu od Meše sve do Sefara, brdovitih krajeva na istoku. ");
INSERT INTO hrv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","To su sinovi Šemovi prema svojim plemenima, jezicima i zemljama, po svojim narodima. ");
INSERT INTO hrv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","To su rodovi Noinih sinova prema svojim lozama i narodima. Od njih su se razgranali narodi po zemlji poslije Potopa. ");
INSERT INTO hrv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sva je zemlja imala jedan jezik i riječi iste. ");
INSERT INTO hrv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ali kako su se ljudi selili s istoka, naiđu na jednu dolinu u zemlji Šinearu i tu se nastane. ");
INSERT INTO hrv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Jedan drugome reče: “Hajdemo praviti opeke te ih peći da otvrdnu!” Opeke im bile mjesto kamena, a paklina im služila za žbuku. ");
INSERT INTO hrv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Onda rekoše: “Hajde da sebi podignemo grad i toranj s vrhom do neba! Pribavimo sebi ime, da se ne raspršimo po svoj zemlji!” ");
INSERT INTO hrv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Jahve se spusti da vidi grad i toranj što su ga gradili sinovi čovječji. ");
INSERT INTO hrv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Jahve reče. “Zbilja su jedan narod, s jednim jezikom za sve! Ovo je tek početak njihovih nastojanja. Sad im ništa neće biti neostvarivo što god naume izvesti. ");
INSERT INTO hrv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Hajde da siđemo i jezik im pobrkamo, da jedan drugome govora ne razumije.” ");
INSERT INTO hrv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tako ih Jahve rasu odande po svoj zemlji te ne sazidaše grada. ");
INSERT INTO hrv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Stoga mu je ime Babel, jer je ondje Jahve pobrkao govor svima u onom kraju i odande ih je Jahve raspršio po svoj zemlji. ");
INSERT INTO hrv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ovo su potomci Šemovi: Kad je Šemu bilo sto godina - dvije godine poslije Potopa - rodi mu se Arpakšad. ");
INSERT INTO hrv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Po rođenju Arpakšadovu Šem je živio petsto godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Kad je Arpakšadu bilo trideset i pet godina, rodi mu se Šelah. ");
INSERT INTO hrv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Po rođenju Šelahovu Arpakšad je živio četiri stotine i tri godine te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Kad je Šelahu bilo trideset godina, rodi mu se Eber. ");
INSERT INTO hrv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Po rođenju Eberovu Šelah je živio četiri stotine i tri godine te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kad su Eberu bile trideset i četiri godine, rodi mu se Peleg. ");
INSERT INTO hrv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Po rođenju Pelegovu Eber je živio četiri stotine i trideset godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Kad je Pelegu bilo trideset godina, rodi mu se Reu. ");
INSERT INTO hrv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Po rođenju Reuovu Peleg je živio dvjesta i devet godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kad su Reuu bile trideset i dvije godine, rodi mu se Serug. ");
INSERT INTO hrv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Po rođenju Serugovu Reu je živio dvjesta i sedam godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Kad je Serugu bilo trideset godina, rodi mu se Nahor. ");
INSERT INTO hrv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Po rođenju Nahorovu Serug je živio dvjesta godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Kad je Nahoru bilo dvadeset i devet godina, rodi mu se Terah. ");
INSERT INTO hrv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Po rođenju Terahovu Nahor je živio sto i devetnaest godina te mu se rodilo još sinova i kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kad je Terahu bilo sedamdeset godina, rode mu se: Abram, Nahor i Haran. ");
INSERT INTO hrv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ovo je povijest Terahova. Terahu se rodio Abram, Nahor i Haran; a Haranu se rodio Lot. ");
INSERT INTO hrv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran umrije za života svoga oca Teraha, u svome rodnom kraju, u Uru Kaldejskom. ");
INSERT INTO hrv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram se i Nahor ožene. Abramovoj ženi bijaše ime Saraja, a Nahorovoj Milka; ova je bila kći Harana, oca Milke i Jiske. ");
INSERT INTO hrv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraja bijaše nerotkinja - nije imala poroda. ");
INSERT INTO hrv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah povede svoga sina Abrama, svog unuka Lota, sina Haranova, svoju snahu Saraju, ženu svoga sina Abrama, pa se zaputi s njima iz Ura Kaldejskoga u zemlju kanaansku. Kad stignu do Harana, ondje se nastane. ");
INSERT INTO hrv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Dob Terahova dosegnu dvjesta i pet godina; a onda Terah umrije u Haranu. ");
INSERT INTO hrv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Jahve reče Abramu: “Idi iz zemlje svoje, iz zavičaja i doma očinskog, u krajeve koje ću ti pokazati. ");
INSERT INTO hrv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Velik ću narod od tebe učiniti, blagoslovit ću te, ime ću ti uzveličati, i sam ćeš biti blagoslov. ");
INSERT INTO hrv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Blagoslivljat ću one koji te blagoslivljali budu, koji te budu kleli, njih ću proklinjati; sva plemena na zemlji tobom će se blagoslivljati.” ");
INSERT INTO hrv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abram se zaputi kako mu je Jahve rekao. S njime krenu i Lot. Abramu je bilo sedamdeset i pet godina kad je otišao iz Harana. ");
INSERT INTO hrv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram uze sa sobom svoju ženu Saraju, svoga bratića Lota, svu imovinu što su je namakli i svu čeljad koju su stekli u Haranu te svi pođu u zemlju kanaansku. Kad su stigli u Kanaan, ");
INSERT INTO hrv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram prođe zemljom do mjesta Šekema - do hrasta More. Kanaanci su onda bili u zemlji. ");
INSERT INTO hrv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Jahve se javi Abramu pa mu reče: “Tvome ću potomstvu dati ovu zemlju.” Abram tu podigne žrtvenik Jahvi koji mu se objavio. ");
INSERT INTO hrv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Odatle prijeđe u brdoviti kraj, na istok od Betela. Svoj šator postavi između Betela na zapadu i Aja na istoku. Ondje podigne žrtvenik Jahvi i zazva ime Jahvino. ");
INSERT INTO hrv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Od postaje do postaje Abram se pomicao prema Negebu. ");
INSERT INTO hrv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ali kad je zemljom zavladala glad, Abram se spusti u Egipat da ondje proboravi, jer je velika glad harala zemljom. ");
INSERT INTO hrv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kad je bio na ulazu u Egipat, reče svojoj ženi Saraji: “Znam da si lijepa žena. ");
INSERT INTO hrv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kad te Egipćani vide, reći će: 'To je njegova žena', i mene će ubiti, a tebe na životu ostaviti. ");
INSERT INTO hrv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nego reci da si mi sestra, tako da i meni bude zbog tebe dobro i da, iz obzira prema tebi, poštede moj život.” ");
INSERT INTO hrv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Zbilja, kad je Abram ušao u Egipat, Egipćani vide da je žena veoma lijepa. ");
INSERT INTO hrv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Vide je faraonovi dvorani pa je pohvale faraonu i odvedu ženu na faraonov dvor. ");
INSERT INTO hrv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Abramu pođe dobro zbog nje; steče on stoke i goveda, magaraca, slugu i sluškinja, magarica i deva. ");
INSERT INTO hrv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ali Jahve udari faraona i njegov dom velikim nevoljama zbog Abramove žene Saraje. ");
INSERT INTO hrv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","I faraon pozva Abrama pa reče: “Što si mi to učinio? Zašto mi nisi kazao da je ona tvoja žena? ");
INSERT INTO hrv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Zašto si rekao: 'Ona mi je sestra', pa je ja uzeh sebi za ženu? A sad, evo ti žene; uzmi je i hajde!” ");
INSERT INTO hrv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Faraon ga onda preda momcima, a oni ga otprave s njegovom ženom i sa svime što bijaše njegovo. ");
INSERT INTO hrv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Iz Egipta Abram ode gore u Negeb sa svojom ženom i sa svime što je imao. I Lot bješe s njim. ");
INSERT INTO hrv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram je bio veoma bogat stokom, srebrom i zlatom. ");
INSERT INTO hrv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Od postaje do postaje iz Negeba išao je do Betela, ");
INSERT INTO hrv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","do mjesta na kojem je bio postavio šator, između Betela i Aja, gdje je prije podigao žrtvenik. Tu je Abram zazivao ime Jahvino. ");
INSERT INTO hrv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","I Lot, koji iđaše s Abramom, imaše ovaca, goveda i šatora, ");
INSERT INTO hrv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","tako da ih kraj ne bi izdržavao kad bi zajedno ostali. Njihovo je blago bilo veliko, te zajedno nisu mogli boraviti. ");
INSERT INTO hrv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Svađa je nastajala između pastira stoke Abramove i pastira stoke Lotove. Tada su zemlju nastavali Kanaanci i Perižani. ");
INSERT INTO hrv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Zato Abram reče Lotu: “Neka ne bude svađe između mene i tebe, između pastira mojih i tvojih - tÓa mi smo braća! ");
INSERT INTO hrv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nije li sva zemlja pred tobom? Odvoji se od mene! Kreneš li ti nalijevo, ja ću nadesno; ako ćeš ti nadesno, ja ću nalijevo.” ");
INSERT INTO hrv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot podiže oči i vidje kako je dobro posvuda natapana sva Jordanska dolina, kao kakav vrt Jahvin, kao zemlja egipatska prema Soaru. - Bilo je to prije nego što je Jahve uništio Sodomu i Gomoru. - ");
INSERT INTO hrv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot izabere za se svu Jordansku dolinu i ode na istok. Tako se odijele jedan od drugoga. ");
INSERT INTO hrv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram ostade u kanaanskoj zemlji, dok je Lot živio po mjestima u dolini i razapeo svoje šatore do Sodome. ");
INSERT INTO hrv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","A žitelji Sodome bijahu veoma opaki, sami grešnici protiv Jahve. ");
INSERT INTO hrv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Jahve reče Abramu, pošto se Lot od njega rastao: “Oči svoje podigni i s mjesta na kojem si pogledaj prema sjeveru, jugu, istoku i zapadu; ");
INSERT INTO hrv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","jer svu zemlju što je možeš vidjeti dat ću tebi i tvome potomstvu zauvijek. ");
INSERT INTO hrv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Potomstvo ću tvoje učiniti kao prah na zemlji. Ako tko mogne prebrojiti prah zemlje, i tvoje će potomstvo moći prebrojiti. ");
INSERT INTO hrv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Na noge! Prođi zemljom uzduž i poprijeko jer ću je tebi predati.” ");
INSERT INTO hrv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram digne šatore i dođe pa se naseli kod hrasta Mamre, što je u Hebronu. Ondje podigne žrtvenik Jahvi. ");
INSERT INTO hrv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kad Amrafel bijaše kralj Šineara, Ariok kralj Elasara, Kedor-Laomer kralj Elama, Tidal kralj Gojima, ");
INSERT INTO hrv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","povedoše oni rat protiv Bere, kralja Sodome, Birše, kralja Gomore, Šinaba, kralja Adme, Šemebera, kralja Sebojima, i protiv kralja u Beli, to jest Soaru. ");
INSERT INTO hrv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","I vojske se sliju u dolinu Sidim, gdje je danas Slano more. ");
INSERT INTO hrv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dvanaest su godina služili Kedor-Laomera, ali trinaeste godine dignu se na ustanak. ");
INSERT INTO hrv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","U četrnaestoj godini digne se Kedor-Laomer i kraljevi koji su bili s njim te potuku Refaimce u Ašterot Karnajimu, Zuzijce u Hamu, Emijce na ravnici Kirjatajimu, ");
INSERT INTO hrv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Horijce u brdskom kraju Seiru, blizu El Parana, koji je uz pustinju. ");
INSERT INTO hrv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Onda se povuku natrag i stignu u En Mišpat, to jest Kadeš, i pokore sve krajeve Amalečana i Amorejaca, koji su nastavali Haseson Tamar. ");
INSERT INTO hrv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Zatim istupi kralj Sodome, kralj Gomore, kralj Adme, kralj Sebojima i kralj Bele, odnosno Soara, te zapodjenu borbu protiv onih u dolini Sidimu: ");
INSERT INTO hrv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedor-Laomera, kralja Elama, Tidala, kralja Gojima, Amrafela, kralja Šineara, Arioka, kralja Elasara - četiri kralja protiv pet. ");
INSERT INTO hrv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Dolina Sidim bila je puna provalija s paklinom, pa kraljevi Sodome i Gomore, na bijegu, u njih poskaču, a ostali izmaknu u planine. ");
INSERT INTO hrv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Pobjednici pokupe sve blago po Sodomi i Gomori i svu hranu pa odu. ");
INSERT INTO hrv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Pograbe i Lota, Abramova bratića - i on je živio u Sodomi - i njegovo blago pa otiđu. ");
INSERT INTO hrv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","A bjegunac neki - rođak Eškola i Anera, Abramovih saveznika - donese vijest Abramu Hebrejcu dok je boravio kod hrasta Amorejske Mamre. ");
INSERT INTO hrv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kad je Abram čuo da mu je bratić zarobljen, skupi svoju momčad - rođenu u njegovu domu - njih trista osamnaest, pa pođe u potjeru do Dana. ");
INSERT INTO hrv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Podijeli svoje momke u dvije čete, napadne noću te one potuče. Progonio ih je do Hobe, sjeverno od Damaska. ");
INSERT INTO hrv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Povrati sve blago, svoga bratića Lota i njegovo blago, žene i ostali svijet. ");
INSERT INTO hrv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Pošto se vratio, porazivši Kedor-Laomera i kraljeve koji su bili s njim, u susret mu, u dolinu Šave, to jest u Kraljev dol, iziđe kralj Sodome. ");
INSERT INTO hrv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","A Melkisedek, kralj Šalema, iznese kruha i vina. On je bio svećenik Boga Svevišnjega. ");
INSERT INTO hrv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Blagoslovi ga govoreći: “Od Boga Svevišnjega, Stvoritelja neba i zemlje, neka je Abramu blagoslov! ");
INSERT INTO hrv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","I Svevišnji Bog, što ti u ruke preda neprijatelje, hvaljen bio!” Abram mu dade desetinu od svega. ");
INSERT INTO hrv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tada kralj Sodome reče Abramu: “Meni daj ljude, a dobra uzmi sebi!” ");
INSERT INTO hrv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram odgovori kralju Sodome: “Ruku uzdižem pred Jahvom, Svevišnjim Stvoriteljem neba i zemlje, ");
INSERT INTO hrv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","da neću uzeti ni končića, ni remena od obuće, niti išta što je tvoje da ne kažeš: na meni se Abram obogatio. ");
INSERT INTO hrv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ne, meni ništa, osim što su moji momci upotrijebili; i dio za momčad što je sa mnom išla: Aner, Eškol i Mamre, oni neka uzmu svoj dio.” ");
INSERT INTO hrv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Poslije tih događaja Jahve uputi Abramu riječ u ukazanju: “Ne boj se, Abrame, ja sam ti zaštita; a nagrada tvoja bit će vrlo velika!” ");
INSERT INTO hrv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram odgovori: “Gospodine moj, Jahve, čemu mi tvoji darovi kad ostajem bez poroda; kad je mojoj kući nasljednik Eliezer Damaščanin? ");
INSERT INTO hrv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kako mi nisi dao potomstva - nastavi Abram - jedan će, eto, od mojih ukućana postati moj baštinik.” ");
INSERT INTO hrv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ali mu Jahve opet uputi riječ: “Taj neće biti tvoj baštinik, nego će ti baštinik biti tvoj potomak.” ");
INSERT INTO hrv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Izvede ga van i reče: “Pogledaj na nebo i zvijezde prebroj ako ih možeš prebrojiti.” A onda doda: “Toliko će biti tvoje potomstvo.” ");
INSERT INTO hrv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram povjerova Jahvi, i on mu to uračuna u pravednost. ");
INSERT INTO hrv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Tada mu on reče: “Ja sam Jahve koji sam te odveo iz Ura Kaldejskoga da ti predam ovu zemlju u posjed.” ");
INSERT INTO hrv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","A on odvrati: “Gospodine moj, Jahve, kako ću ja doznati da ću je zaposjesti?” ");
INSERT INTO hrv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Odgovori mu: “Prinesi mi junicu od tri godine, kozu od tri godine, ovna od tri godine, jednu grlicu i jednog golubića.” ");
INSERT INTO hrv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Sve mu to donese, rasiječe na pole i metnu sve pole jednu prema drugoj; ptica nije rasijecao. ");
INSERT INTO hrv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ptice grabežljivice obarale se na leševe, ali ih je Abram rastjerivao. ");
INSERT INTO hrv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kad je sunce bilo pri zalazu, dubok san obuzme Abrama, a onda se na nj spusti gust mrak pun jeze. ");
INSERT INTO hrv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tada Bog reče Abramu: “Dobro znaj da će tvoji potomci biti stranci u tuđoj zemlji; robovat će i biti tlačeni četiri stotine godina, ");
INSERT INTO hrv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ali narodu kojem budu služili ja ću suditi; i konačno će izići s velikim blagom. ");
INSERT INTO hrv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","A ti ćeš k ocima svojim u miru poći, u sretnoj starosti bit ćeš sahranjen. ");
INSERT INTO hrv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Oni će se ovamo vratiti za četvrtog naraštaja, jer mjera se zlodjela amorejskih još nije navršila.” ");
INSERT INTO hrv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kad je sunce zašlo i pao gust mrak, pojavi se zadimljen žeravnjak i goruća zublja te prođu između onih dijelova. ");
INSERT INTO hrv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Toga je dana Jahve sklopio Savez s Abramom rekavši: “Potomstvu tvojemu dajem zemlju ovu od Rijeke u Egiptu do Velike rijeke, rijeke Eufrata: ");
INSERT INTO hrv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kenijce, Kenižane, Kadmonce, ");
INSERT INTO hrv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hetite, Perižane, Refaimce, ");
INSERT INTO hrv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorejce, Kanaance, Girgašane, Jebusejce.” ");
INSERT INTO hrv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abramova žena Saraja nije mu rađala djece. A imaše ona sluškinju Egipćanku - zvala se Hagara. ");
INSERT INTO hrv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","I reče Saraja Abramu: “Vidiš, Jahve me učinio nerotkinjom. Hajde k mojoj sluškinji, možda ću imati djece.” Abram posluša riječ Sarajinu. ");
INSERT INTO hrv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tako, pošto je Abram proboravio deset godina u zemlji kanaanskoj, njegova žena Saraja uzme Hagaru, Egipćanku, sluškinju svoju, pa je dade svome mužu Abramu za ženu. ");
INSERT INTO hrv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Uđe on k Hagari te ona zače. A kad je vidjela da je začela, s prezirom je gledala na svoju gospodaricu. ");
INSERT INTO hrv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tada reče Saraja Abramu: “Nepravda što se meni nanosi tvoja je krivnja! Prepustila sam svoju sluškinju tvome zagrljaju, ali otkako opazi da je zanijela, s prezirom na me gleda. Jahve sudio i meni i tebi!” ");
INSERT INTO hrv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Nato Abram odvrati Saraji: “Tvoja je sluškinja u tvojoj ruci: kako ti se čini da je dobro, tako prema njoj postupi!” Saraja postupi prema njoj tako loše da ona od nje pobježe. ");
INSERT INTO hrv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Anđeo Jahvin nađe je kod izvora u pustinji - uz vrelo što je na putu prema Šuru - ");
INSERT INTO hrv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","pa je zapita: “Hagaro, sluškinjo Sarajina, odakle dolaziš i kamo ideš?” “Bježim, evo, od svoje gospodarice Saraje”, odgovori ona. ");
INSERT INTO hrv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Nato joj anđeo Jahvin reče: “Vrati se svojoj gospodarici i pokori joj se!” ");
INSERT INTO hrv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Još joj reče anđeo Jahvin: “Tvoje ću potomstvo silno umnožiti; od mnoštva se neće moći ni prebrojiti.” ");
INSERT INTO hrv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Dalje joj je anđeo Jahvin rekao: “Gle, zanijela si i rodit ćeš sina. Nadjeni mu ime Jišmael, jer Jahve ču jad tvoj. ");
INSERT INTO hrv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","On će biti kao divlje magare: ruka će se njegova dizati na svakoga i svačija ruka na njega; i pred licem sve mu braće on će stan sebi podići.” ");
INSERT INTO hrv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","A Jahvu koji joj govoraše nazva: “Ti si El Roi - Svevid Bog”, jer - reče ona - “vidjeh Boga i nakon viđenja - još živim!” ");
INSERT INTO hrv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Stoga se taj zdenac zove Beer Lahaj Roi - Zdenac životvornog Svevida, a eno ga između Kadeša i Bereda. ");
INSERT INTO hrv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Rodi Hagara Abramu sina, a Abram sinu što mu ga rodi Hagara nadjene ime Jišmael. ");
INSERT INTO hrv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramu je bilo osamdeset i šest godina kad mu je Hagara rodila Jišmaela. ");
INSERT INTO hrv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kad je Abramu bilo devedeset i devet godina, ukaza mu se Jahve pa mu reče: “Ja sam El Šadaj - Bog Svesilni, Mojim hodi putem i neporočan budi. ");
INSERT INTO hrv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","A Savez svoj ja sklapam s tobom i silno ću te razmnožiti.” ");
INSERT INTO hrv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram pade ničice dok mu Bog govoraše dalje: ");
INSERT INTO hrv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“A ovo je Savez moj s tobom: postat ćeš ocem mnogim narodima; ");
INSERT INTO hrv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","i nećeš se više zvati Abram - već Abraham će ti ime biti, jer naroda mnogih ocem ja te postavljam. ");
INSERT INTO hrv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Silno ću te rodnim učiniti; narode ću iz tebe izvesti; i kraljevi će od tebe izaći. ");
INSERT INTO hrv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Savez svoj sklapam između sebe i tebe i tvoga potomstva poslije tebe - Savez svoj za vjekove: ja ću biti Bogom tvojim i tvoga potomstva poslije tebe. ");
INSERT INTO hrv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Tebi i tvome potomstvu poslije tebe dajem zemlju u kojoj boraviš kao pridošlica - svu zemlju kanaansku - u vjekovni posjed; a ja ću biti njihov Bog.” ");
INSERT INTO hrv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Još reče Bog Abrahamu: “A ti Savez čuvaj moj - ti i tvoje potomstvo poslije tebe u sve vijeke. ");
INSERT INTO hrv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","A ovo je Savez moj s tobom i tvojim potomstvom poslije tebe koji ćeš vršiti: svako muško među vama neka bude obrezano. ");
INSERT INTO hrv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Obrezujte se, i to neka bude znak Saveza između mene i vas. ");
INSERT INTO hrv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Svako muško među vama, kroz vaša pokoljenja, kad mu se navrši osam dana, neka bude obrezano; i rob, rođen u vašem domu, i onaj što bude kupljen od stranca, koji ne bude od vaše krvi. ");
INSERT INTO hrv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Da, i rob rođen u tvome domu ili za novac kupljen mora se obrezati! Tako će moj Savez na vašem tijelu ostati vječnim Savezom. ");
INSERT INTO hrv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Muško koje se ne bi obrezalo neka se odstrani od svoga roda: takav je prekršio moj Savez.” ");
INSERT INTO hrv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Još reče Bog Abrahamu: “Tvojoj ženi Saraji nije više ime Saraja: Sara će joj ime biti. ");
INSERT INTO hrv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nju ću ja blagosloviti i od nje ti dati sina; blagoslov ću na nju izliti te će se narodi od nje razviti; kraljevi će narodima od nje poteći.” ");
INSERT INTO hrv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham pade ničice pa se nasmija i reče u sebi: “Onome komu je stotinu godina, zar se može roditi dijete? Zar će Sara u devedesetoj rod rađati!” ");
INSERT INTO hrv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham reče Bogu: “Neka tvojom milošću Jišmael poživi!” ");
INSERT INTO hrv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","A Bog reče: “Ipak će ti tvoja žena Sara roditi sina; nadjeni mu ime Izak. Savez svoj s njime ću sklopiti, Savez vječni s njime i s njegovim potomstvom poslije njega. ");
INSERT INTO hrv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","I za Jišmaela uslišah te. Evo ga blagoslivljam: rodnim ću ga učiniti i silno ga razmnožiti; dvanaest će knezova od njega postati i u velik će narod izrasti. ");
INSERT INTO hrv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ali ću držati svoj Savez s Izakom, koga će ti roditi Sara dogodine u ovo doba.” ");
INSERT INTO hrv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kad je završio razgovor s njim, od Abrahama Bog se podiže. ");
INSERT INTO hrv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Uzme zatim Abraham svoga sina Jišmaela i sve robove koji su bili rođeni u njegovu domu i sve koje je kupio novcem - sve muške ukućane - pa ih toga istog dana obreže, kako mu je Bog rekao. ");
INSERT INTO hrv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamu bijaše devedeset i devet godina kad se obrezao, ");
INSERT INTO hrv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","a njegovu sinu Jišmaelu bijaše trinaest godina kad ga obreza. ");
INSERT INTO hrv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tako su toga istog dana bili obrezani Abraham i njegov sin Jišmael; ");
INSERT INTO hrv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","i svi muškarci njegova doma, rođeni u njegovoj kući ili za novac kupljeni od stranca - svi s njim bijahu obrezani. ");
INSERT INTO hrv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Jahve mu se ukaza kod hrasta Mamre dok je on sjedio na ulazu u šator za dnevne žege. ");
INSERT INTO hrv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Podigavši oči, opazi tri čovjeka gdje stoje nedaleko od njega. Čim ih spazi, potrča s ulaza šatora njima u susret. Pade ničice na zemlju ");
INSERT INTO hrv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","pa reče: “Gospodine moj, ako sam stekao milost u tvojim očima, nemoj mimoići svoga sluge! ");
INSERT INTO hrv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nek' se donese malo vode: operite noge i pod stablom otpočinite. ");
INSERT INTO hrv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Donijet ću kruha da se okrijepite prije nego pođete dalje. TÓa k svome ste sluzi navratili.” Oni odgovore: “Dobro, učini kako si rekao!” ");
INSERT INTO hrv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham se požuri u šator k Sari pa joj reče: “Brzo! Tri mjerice najboljeg brašna! Zamijesi i prevrtu ispeci!” ");
INSERT INTO hrv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Zatim Abraham otrča govedima, uhvati tele, mlado i debelo, i dade ga momku da ga brže zgotovi. ");
INSERT INTO hrv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Poslije uzme masla, mlijeka i zgotovljeno tele pa stavi pred njih, a sam stajaše pred njima, pod stablom, dok su blagovali. ");
INSERT INTO hrv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“Gdje ti je žena Sara?” - zapitaju ga. “Eno je pod šatorom”, odgovori. ");
INSERT INTO hrv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Onda on reče: “Vratit ću se k tebi kad isteče vrijeme trudnoće; a tvoja žena Sara imat će sina.” Iza njega, na ulazu u šator, Sara je prisluškivala. ");
INSERT INTO hrv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham i Sara bijahu u odmakloj dobi, ostarjeli. U Sare bijaše prestalo što biva u žena. ");
INSERT INTO hrv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Zato se u sebi Sara smijala i govorila: “Pošto sam uvenula, sad da spoznam nasladu? A još mi je i gospodar star!” ");
INSERT INTO hrv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Onda Jahve upita Abrahama: “A zašto se Sara smijala i govorila: 'Kako ću rod roditi ja starica?' ");
INSERT INTO hrv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Zar je Jahvi išta nemoguće? Navratit ću se k tebi kad isteče vrijeme trudnoće: Sara će imati sina.” ");
INSERT INTO hrv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara se napravi nevještom govoreći: “Nisam se smijala.” Jer se prestrašila. Ali on reče: “Jesi, smijala si se!” ");
INSERT INTO hrv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ljudi ustanu i krenu put Sodome. Abraham pođe s njima da ih isprati. ");
INSERT INTO hrv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Jahve pomisli: “Zar da sakrivam od Abrahama što ću učiniti ");
INSERT INTO hrv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","kad će od Abrahama nastati velik i brojan narod te će se svi narodi zemlje njim blagoslivljati? ");
INSERT INTO hrv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Njega sam izlučio zato da pouči svoju djecu i svoju buduću obitelj kako će hoditi putem Jahvinim, radeći što je dobro i pravedno, tako da Jahve mogne ostvariti što je Abrahamu obećao.” ");
INSERT INTO hrv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Onda Jahve nastavi: “Velika je vika na Sodomu i Gomoru da je njihov grijeh pretežak. ");
INSERT INTO hrv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Idem dolje da vidim rade li zaista kako veli tužba što je do mene stigla. Želim razvidjeti.” ");
INSERT INTO hrv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Odande ljudi krenu prema Sodomi, dok je Abraham još stajao pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Nato se Abraham primače bliže i reče: “Hoćeš li iskorijeniti i nevinoga s krivim? ");
INSERT INTO hrv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Možda ima pedeset nevinih u gradu. Zar ćeš uništiti mjesto radije nego ga poštedjeti zbog pedeset nevinih koji budu ondje? ");
INSERT INTO hrv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Daleko to bilo od tebe da ubijaš nevinoga kao i krivoga, tako da i nevini i krivi prođu jednako! Daleko bilo od tebe! Zar da ni Sudac svega svijeta ne radi pravo?” ");
INSERT INTO hrv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","“Ako nađem u gradu Sodomi pedeset nevinih”, odvrati Jahve, “zbog njih ću poštedjeti cijelo mjesto.” ");
INSERT INTO hrv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","“Ja se, evo, usuđujem govoriti Gospodinu”, opet progovori Abraham. - “Ja, prah i pepeo! ");
INSERT INTO hrv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Da slučajno bude nevinih pet manje od pedeset, bi li uništio sav grad zbog tih pet?” “Neću ga uništiti ako ih ondje nađem četrdeset i pet”, odgovori. ");
INSERT INTO hrv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","“Ako ih se ondje možda nađe samo četrdeset?” - opet će Abraham. “Neću to učiniti zbog četrdesetorice”, odgovori. ");
INSERT INTO hrv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","“Neka se Gospodin ne ljuti ako nastavim. Ako ih se ondje nađe možda samo trideset?” - opet će on. “Neću to učiniti”, odgovori, “ako ih ondje nađem samo trideset.” ");
INSERT INTO hrv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","“Evo se opet usuđujem govoriti Gospodinu”, nastavi dalje. “Ako ih se slučajno ondje nađe samo dvadeset?” “Neću ga uništiti”, odgovori, “zbog dvadesetorice.” ");
INSERT INTO hrv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","“Neka se Gospodin ne ljuti”, on će opet, “ako rečem još samo jednom: Ako ih je slučajno ondje samo deset?” “Neću ga uništiti zbog njih deset”, odgovori. ");
INSERT INTO hrv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kad je Jahve završio razgovor s Abrahamom, ode, a Abraham se vrati u svoje mjesto. ");
INSERT INTO hrv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ona dva anđela stignu navečer u Sodomu dok je Lot sjedio na vratima Sodome. Kad ih Lot ugleda, ustade i pođe im u susret. Nakloni se licem do zemlje, ");
INSERT INTO hrv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","a onda im reče: “Molim, gospodo, svrnite u kuću svoga sluge da noć provedete i noge operete; a onda možete na put rano.” A oni rekoše: “Ne, noć ćemo provesti na trgu.” ");
INSERT INTO hrv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ali ih on uporno navraćaše, i oni se uvratiše k njemu i uđoše u njegovu kuću. On ih ugosti, ispeče pogaču te blagovaše. ");
INSERT INTO hrv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Još ne bijahu legli na počinak, kad građani Sodome, mladi i stari, sav narod do posljednjeg čovjeka, opkole kuću. ");
INSERT INTO hrv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Zovnu Lota pa mu reknu: “Gdje su ljudi što su noćas došli k tebi? Izvedi nam ih da ih se namilujemo?” ");
INSERT INTO hrv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot iziđe k njima na ulaz, a za sobom zatvori vrata. ");
INSERT INTO hrv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Braćo moja,” reče on, “molim vas, ne činite toga zla! ");
INSERT INTO hrv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Imam, evo, dvije kćeri s kojima još čovjek nije imao dodira: njih ću vam izvesti pa činite s njima što želite; samo ovim ljudima nemojte ništa učiniti jer su došli pod sjenu moga krova.” ");
INSERT INTO hrv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“Odstupi odatle!” - rekoše. - “Došao kao dotepenac, a za suca se već postavlja. Sad ćemo mi s tobom gore nego s njima.” I nasrnuše na jadnika Lota i navališe na vrata da ih razbiju. ");
INSERT INTO hrv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ali ona dvojica pruže ruke van, povukoše Lota k sebi u kuću i zatvore vrata; ");
INSERT INTO hrv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","a ljude pred vratima, mlade i stare, zabliješte tako da nisu mogli naći vrata. ");
INSERT INTO hrv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Onda ona dvojica upitaju Lota: “Koga još ovdje imaš: sinove i kćeri, sve koje imaš u gradu iz mjesta izvedi! ");
INSERT INTO hrv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Jer mi ćemo zatrti ovo mjesto: vika je na njih pred Jahvom postala tolika te nas Jahve posla da ga uništimo.” ");
INSERT INTO hrv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Iziđe Lot da to kaže svojima budućim zetovima koji namjeravahu uzeti njegove kćeri te reče: “Na noge! Odlazite iz ovog mjesta jer će Jahve uništiti grad!” Ali je u očima svojih budućih zetova ispao kao da zbija šalu. ");
INSERT INTO hrv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kako zora puče, anđeli navale na Lota govoreći: “Na noge! Uzmi svoju ženu i svoje dvije kćeri koje su ovdje da ne budeš zatrt kaznom grada!” ");
INSERT INTO hrv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ali on oklijevaše. Zato ga oni uzeše za ruku, a tako i njegovu ženu i njegove dvije kćeri i - po smilovanju Jahvinu nad njim - odvedoše ih i ostaviše izvan grada. ");
INSERT INTO hrv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kad ih izvedoše u polje, jedan progovori: “Bježi da život spasiš! Ne obaziri se niti se igdje u ravnici zaustavljaj! Bježi u brdo da ne budeš zatrt!” ");
INSERT INTO hrv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ali Lot odvrati: “Nemoj, gospodine! ");
INSERT INTO hrv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nego ako je tvoj sluga našao milost u tvojim očima - a toliko milosrđe već si mi iskazao spasivši mi život - ja ne mogu pobjeći u brdo a da me nesreća ne snađe i ne poginem. ");
INSERT INTO hrv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Eno onamo grada; dosta je blizu da u nj pobjegnem, a mjesto je tako malo. Daj da onamo bježim - mjesto je zbilja maleno - daj da život spasim!” ");
INSERT INTO hrv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Odgovori mu: “Uslišat ću ti i tu molbu i neću zatrti grada o kojemu govoriš. ");
INSERT INTO hrv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Brzo! Bježi onamo, jer ne mogu ništa činiti dok ti onamo ne stigneš.” Zato se onaj grad zove Soar. ");
INSERT INTO hrv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kako je sunce na zemlju izlazilo i Lot ulazio u Soar, ");
INSERT INTO hrv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Jahve zapljušti s neba na Sodomu i Gomoru sumpornim ognjem ");
INSERT INTO hrv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","i uništi one gradove i svu onu ravnicu, sve žitelje gradske i sve raslinstvo na zemlji. ");
INSERT INTO hrv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","A Lotova se žena obazre i pretvori se u stup soli. ");
INSERT INTO hrv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Sutradan u rano jutro Abraham se požuri na mjesto gdje je stajao pred Jahvom, ");
INSERT INTO hrv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","upravi pogled prema Sodomi i Gomori i svoj ravnici u daljini: i vidje kako se diže dim nad zemljom kao dim kakve klačine. ");
INSERT INTO hrv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tako se Bog, dok je zatirao gradove u ravnici u kojima je Lot boravio, sjetio Abrahama i uklonio Lota ispred propasti. ");
INSERT INTO hrv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot se bojao boraviti u Soaru, pa sa svoje dvije kćeri ode gore iz Soara i nastani se u brdu. On i njegove dvije kćeri živjeli su u pećini. ");
INSERT INTO hrv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Starija reče mlađoj: “Otac nam ostarje, a muža na zemlji nema da bude s nama, kako je običaj po svem svijetu. ");
INSERT INTO hrv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hajdemo oca opiti vinom, pa s njime leći: tako ćemo s ocem sačuvati potomstvo.” ");
INSERT INTO hrv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","One noći opiju oca vinom, i starija ode te legne sa svojim ocem, a on nije znao kad je legla ni kad je ustala. ");
INSERT INTO hrv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Sutradan starija reče mlađoj: “Sinoć sam, eto, ležala ja s našim ocem; napojimo ga vinom i noćas, pa idi ti i s njim lezi: tako ćemo ocu sačuvati potomstvo.” ");
INSERT INTO hrv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Opiju oca vinom i one noći te mlađa ode i s njim legne, a on nije znao kad je legla ni kad je ustala. ");
INSERT INTO hrv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tako obje Lotove kćeri zanesu s ocem. ");
INSERT INTO hrv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Starija rodi sina i nadjenu mu ime Moab. On je praotac današnjih Moabaca. ");
INSERT INTO hrv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","I mlađa rodi sina i nadjene mu ime Ben-Ami. On je praotac današnjih Amonaca. ");
INSERT INTO hrv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Odande Abraham krene u krajeve Negeba i nastani se između Kadeša i Šura. Dok je boravio kao pridošlica u Geraru, ");
INSERT INTO hrv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","rekao je Abraham za svoju ženu Saru da mu je sestra. I Abimelek, kralj gerarski, uze Saru sebi. ");
INSERT INTO hrv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ali Bog dođe Abimeleku noću u snu te mu reče: “Zbog žene koju si uzeo moraš umrijeti, jer je ona žena udata.” ");
INSERT INTO hrv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","A nije se Abimelek k njoj približavao. Zato reče: “Gospodine, zar ćeš pravednika pogubiti? ");
INSERT INTO hrv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Zar mi on nije rekao: 'Ona mi je sestra.' A ona mi je sama rekla: 'On je moj brat.' Čiste sam savjesti i neokaljanih ruku ovo učinio.” ");
INSERT INTO hrv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Bog mu odvrati u snu: “Znam da si to učinio čiste savjesti; i ja sam te zadržavao da protiv mene ne griješiš; i nisam dopuštao da je dotakneš. ");
INSERT INTO hrv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sada vrati čovjeku ženu njegovu; prorok je on; molit će se za tebe da ostaneš na životu. Ako je ne vratiš, znaj da ćeš umrijeti, ti i svi tvoji.” ");
INSERT INTO hrv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Rano ujutro Abimelek ustane, sazove sve svoje sluge i kaže im sve što je bilo, a ljudi se veoma uplaše. ");
INSERT INTO hrv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Potom Abimelek dozva Abrahama te mu reče: “Što si nam učinio! Čime sam se ja ogriješio prema tebi da izložiš mene i moje kraljevstvo velikoj grehoti? Ponio si se prema meni kako ne valja. ");
INSERT INTO hrv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Što si, dakle na umu imao”, upita dalje Abimelek, “kad si tako radio?” ");
INSERT INTO hrv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham uzvrati: “Zbilja sam držao da nema Božjeg straha u ovome mjestu, pa će me ljudi ubiti zbog moje žene. ");
INSERT INTO hrv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","A onda, ona je uistinu moja sestra: kći je moga oca, iako ne i moje majke, pa je pošla za me. ");
INSERT INTO hrv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","A kad me Bog udaljio od doma očeva, rekoh joj: Ovu mi uslugu učini: kamo god dođemo, reci o meni da sam ti brat.” ");
INSERT INTO hrv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelek uzme ovaca i goveda, sluga i sluškinja pa ih dade Abrahamu; vrati mu i njegovu ženu Saru. ");
INSERT INTO hrv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek zatim reče: “Evo, moja ti je zemlja otvorena. Nastani se gdje ti se svidi!” ");
INSERT INTO hrv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A Sari reče: “Evo tisuću srebrnika što ih dajem tvome bratu: neka ti budu koprenom pred očima sviju što su s tobom. Ti si svakako opravdana.” ");
INSERT INTO hrv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham se pomoli Bogu, i Bog ozdravi Abimeleka, njegovu ženu i njegove sluškinje, tako te opet mogahu rađati. ");
INSERT INTO hrv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Jer Jahve bijaše zbog Sare, Abrahamove žene, zatvorio svaku utrobu u domu Abimelekovu. ");
INSERT INTO hrv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Jahve se sjeti Sare kako je rekao i učini joj kako je obećao: ");
INSERT INTO hrv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara zače i rodi Abrahamu sina u njegovoj starosti - u vrijeme koje je Bog označio. ");
INSERT INTO hrv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham nadjene ime Izak svome sinu što mu ga Sara rodi. ");
INSERT INTO hrv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","I poslije osam dana obreza Abraham svoga sina Izaka, kako mu je Bog naredio. ");
INSERT INTO hrv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahamu bijaše stotinu godina kad mu se rodio sin Izak. ");
INSERT INTO hrv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara reče: “Dade mi Bog da se nasmijem, i tko god to čuje nasmijat će mi se.” ");
INSERT INTO hrv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Još doda: “Tko bi ikad rekao Abrahamu: djecu će ti Sara dojiti! Ipak sina mu rodih u starosti”. ");
INSERT INTO hrv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Dijete je raslo i bilo od sise odbijeno. A u dan u koji Izak bijaše od sise odbijen Abraham priredi veliku gozbu. ");
INSERT INTO hrv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Jednom opazi Sara gdje se sin koga je Egipćanka Hagara Abrahamu rodila igra s njezinim sinom Izakom, ");
INSERT INTO hrv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","pa reče Abrahamu: “Otjeraj tu sluškinju i njezina sina, jer sin sluškinje ne smije biti baštinik s mojim sinom - s Izakom!” ");
INSERT INTO hrv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","To je Abrahamu bilo nemilo, jer je i Jišmael bio njegov sin. ");
INSERT INTO hrv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ali Bog reče Abrahamu: “Nemoj se uznemirivati zbog dječaka i zbog svoje sluškinje; sve što ti kaže Sara poslušaj, jer će Izakovo potomstvo tebi ovjekovječiti ime. ");
INSERT INTO hrv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","I od sina tvoje sluškinje podići ću velik narod, jer je tvoj potomak.” ");
INSERT INTO hrv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Rano ujutro Abraham uze kruha i mješinicu vode pa dade Hagari; stavi to na njezina ramena, zajedno s dječakom, te je otpusti. Vrludala je amo-tamo po pustinji Beer Šebe. ");
INSERT INTO hrv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Potrošivši vodu iz mješinice, ostavi dijete pod jednim grmom, ");
INSERT INTO hrv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","a sama ode i sjede nasuprot, daleko koliko luk može dobaciti. Govorila je u sebi: “Neću da vidim kako dijete umire.” Sjedeći tako, udari u jecanje. ");
INSERT INTO hrv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Bog ču plač dječaka te anđeo Božji zovne s neba Hagaru i reče joj: “Što ti je, Hagaro? Ne boj se! Jer je Bog čuo plač dječaka u njegovoj nevolji. ");
INSERT INTO hrv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Na noge! Digni dječaka i utješi ga, jer od njega ću podići velik narod.” ");
INSERT INTO hrv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Tada joj Bog otvori oči pa ona opazi studenac. Ode i napuni vodom mješinicu pa napoji dječaka. ");
INSERT INTO hrv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Bog je bio s dječakom te je rastao i odrastao. Živio je u pustinji te postao vješt u strijeljanju iz luka. ");
INSERT INTO hrv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Dom mu bijaše u pustinji Paranu; a njegova mu majka dobavi ženu iz zemlje egipatske. ");
INSERT INTO hrv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","U to vrijeme Abimelek - koga je pratio Fikol, zapovjednik njegove vojske - reče Abrahamu: “Bog je s tobom u svemu što radiš. ");
INSERT INTO hrv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Stoga mi se ovdje i sada zakuni Bogom da nećeš varati ni mene ni moju rodbinu i prijatelje nego da ćeš se prema meni i prema zemlji u kojoj sad boraviš ponašati pošteno, kao što sam se ja prema tebi ponio.” ");
INSERT INTO hrv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","“Kunem se”, odgovori Abraham. ");
INSERT INTO hrv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Onda Abraham prekori Abimeleka zbog zdenca vode što su ga Abimelekove sluge bile prisvojile. ");
INSERT INTO hrv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","A Abimelek reče: “Ne znam tko je to učinio; ni ti me nisi o tome obavijestio, niti sam ja o tome čuo, osim danas.” ");
INSERT INTO hrv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham uzme ovaca i goveda pa ih dade Abimeleku te njih dvojica sklope savez. ");
INSERT INTO hrv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Potom Abraham razluči napose sedam janjaca od stada. ");
INSERT INTO hrv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Nato Abimelek zapita Abrahama: “Što znači ovih sedam janjaca koje si na stranu stavio?” ");
INSERT INTO hrv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","A on odgovori: “Primi ovih sedam janjaca iz moje ruke da mi bude dokazom da sam ja iskopao ovaj zdenac.” ");
INSERT INTO hrv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Zato se ono mjesto nazvalo Beer Šeba; jer se njih dvojica ondje zakleše. ");
INSERT INTO hrv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Pošto su sklopili savez kod Beer Šebe, Abimelek i zapovjednik njegove vojske Fikol odu i vrate se u zemlju Filistejaca. ");
INSERT INTO hrv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham zasadi kod Beer Šebe tamarisku i ondje zazove ime Jahve - Boga Vječnoga. ");
INSERT INTO hrv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Dugo je vremena Abraham proveo u zemlji filistejskoj kao pridošlica. ");
INSERT INTO hrv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Poslije tih događaja Bog stavi Abrahama na kušnju. Zovnu ga: “Abrahame!” On odgovori: “Evo me!” ");
INSERT INTO hrv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Bog nastavi: “Uzmi svoga sina, jedinca svoga Izaka koga ljubiš, i pođi u krajinu Moriju pa ga ondje prinesi kao žrtvu paljenicu na brdu koje ću ti pokazati.” ");
INSERT INTO hrv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ujutro Abraham podrani, osamari magarca, sa sobom povede dvojicu svojih slugu i svog sina Izaka, pošto je prije nacijepao drva za žrtvu paljenicu, i uputi se na mjesto koje mu je Bog označio. ");
INSERT INTO hrv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Treći dan Abraham podigne oči i opazi mjesto izdaleka. ");
INSERT INTO hrv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham onda reče slugama: “Vi ostanite ovdje uz magarca, a ja i dječak odosmo gore da se poklonimo, pa ćemo se vratiti k vama”. ");
INSERT INTO hrv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham uzme drva za žrtvu paljenicu, stavi ih na sina Izaka, a u svoju ruku uzme kremen i nož. Tako pođu obojica zajedno. ");
INSERT INTO hrv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Onda Izak reče svome ocu Abrahamu: “Oče!” “Evo me, sine!” - javi se on. “Evo kremena i drva,” opet će sin, “ali gdje je janje za žrtvu paljenicu?” ");
INSERT INTO hrv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","“Bog će već providjeti janje za žrtvu paljenicu, sine moj!” - odgovori Abraham. I nastave put. ");
INSERT INTO hrv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Stignu na mjesto o kojemu je Bog govorio. Ondje Abraham podigne žrtvenik, naslaže drva, sveže svog sina Izaka i položi ga po drvima na žrtvenik. ");
INSERT INTO hrv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Pruži sad Abraham ruku i uzme nož da zakolje svog sina. ");
INSERT INTO hrv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Uto ga zovne s neba anđeo Jahvin i poviče: “Abrahame! Abrahame!” “Evo me!” - odgovori on. ");
INSERT INTO hrv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Ne spuštaj ruku na dječaka”, reče, “niti mu što čini! Sad, evo, znam da se Boga bojiš, jer nisi uskratio ni svog sina, jedinca svoga.” ");
INSERT INTO hrv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Podiže Abraham oči i pogleda, i gle - za njim ovan, rogovima se zapleo u grmu. Tako Abraham ode, uzme ovna i prinese ga za žrtvu paljenicu mjesto svoga sina. ");
INSERT INTO hrv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Onome mjestu Abraham dade ime “Jahve proviđa”. Zato se danas veli: “Na brdu Jahvina proviđanja.” ");
INSERT INTO hrv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Anđeo Jahvin zovne Abrahama s neba drugi put ");
INSERT INTO hrv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","i reče: “Kunem se samim sobom, izjavljuje Jahve: Kad si to učinio i nisi mi uskratio svog jedinca sina, ");
INSERT INTO hrv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","svoj ću blagoslov na te izliti i učiniti tvoje potomstvo brojnim poput zvijezda na nebu i pijeska na obali morskoj! A tvoji će potomci osvajati vrata svojih neprijatelja. ");
INSERT INTO hrv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Budući da si poslušao moju zapovijed, svi će se narodi zemlje blagoslivljati tvojim potomstvom.” ");
INSERT INTO hrv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Zatim se Abraham vrati k svojim slugama pa se zajedno upute u Beer Šebu. U Beer Šebi se Abraham nastani. ");
INSERT INTO hrv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Poslije tih događaja obavijeste Abrahama: “I tvome bratu Nahoru Milka je porodila djecu: ");
INSERT INTO hrv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","njegova prvorođenca Usa, brata mu Buza i Kemuela - oca Aramova, ");
INSERT INTO hrv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keseda, Haza, Pildaša, Jidlafa i Betuela.” ");
INSERT INTO hrv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel je bio otac Rebekin. Njih je osam rodila Milka Nahoru, Abrahamovu bratu. ");
INSERT INTO hrv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","A i njegova suložnica, kojoj bijaše ime Reuma, rodila je Tebaha, Gahama, Tahaša i Maaku. ");
INSERT INTO hrv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Duljina Sarina života bila je stotinu dvadeset i sedam godina. ");
INSERT INTO hrv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara umrije u Kirjat Arbi, to jest u Hebronu, u zemlji kanaanskoj; i Abraham uđe u žalost za Sarom i naricaše za njom. ");
INSERT INTO hrv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Potom se Abraham digne ispred svoje pokojnice te prozbori sinovima Hetovim: ");
INSERT INTO hrv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Premda sam ja među vama doseljeni stranac, prodajte mi zemljište za grob među vama, tako da mogu iznijeti svoju pokojnicu i sahraniti je.” ");
INSERT INTO hrv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","A sinovi Hetovi odgovore Abrahamu: ");
INSERT INTO hrv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Gospodine, saslušaj nas! Ti si izabranik Božji u našoj sredini. Pokopaj svoju pokojnicu u našem najbiranijem grobu. Nitko ti od nas neće odbiti svoga groba da mogneš sahraniti svoju pokojnicu.” ");
INSERT INTO hrv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Nato se Abraham diže pa se mještanima, sinovima Hetovim, duboko pokloni ");
INSERT INTO hrv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","te im reče: “Ako se slažete da svoju pokojnicu uklonim i sahranim, čujte me: zauzmite se za me kod Efrona, sina Soharova, ");
INSERT INTO hrv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","da mi proda spilju Makpelu što njemu pripada a nalazi se na kraju njegova posjeda; neka mi je za punu cijenu, u vašoj nazočnosti, proda u vlasništvo za sahranjivanje.” ");
INSERT INTO hrv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","A Efron je sjedio sa sinovima Hetovim. Potom Efron, Hetit, odgovori Abrahamu da ga čuju sinovi Hetovi svojim ušima - svi koji su sjedili u vijeću onoga grada: ");
INSERT INTO hrv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ne, moj gospodine! Saslušaj mene! Ja tebi dajem poljanu i spilju što je na njoj; darujem ti to pred sinovima svoga naroda. Sahrani svoju pokojnicu.” ");
INSERT INTO hrv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham se duboko nakloni mještanima, ");
INSERT INTO hrv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","a onda progovori Efronu da mještani čuju na svoje uši: “Ded me samo poslušaj! Dajem ti cijenu za poljanu; primi je od mene da ondje mogu sahraniti svoju pokojnicu!” ");
INSERT INTO hrv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron odgovori Abrahamu: ");
INSERT INTO hrv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Čuj me, moj gospodine: zemljište u vrijednosti od četiri stotine srebrnika, što je to tebi i meni! Sahrani, dakle, svoju pokojnicu!” ");
INSERT INTO hrv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham se složi s Efronom; isplati Abraham Efronu novac što ga je spomenuo tako da su na svoje uši čuli sinovi Hetovi - četiri stotine srebrnika trgovačke mjere. ");
INSERT INTO hrv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","I tako Efronova poljana u Makpeli nasuprot Mamri - poljana, spilja i sva stabla što su bila na poljani - ");
INSERT INTO hrv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","prijeđe u vlasništvo Abrahamovo u nazočnosti sinova Hetovih, sviju koji su sjedili u vijeću svoga grada. ");
INSERT INTO hrv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","A onda Abraham sahrani svoju ženu Saru u spilji na poljani Makpeli nasuprot Mamri - danas Hebronu - u zemlji kanaanskoj. ");
INSERT INTO hrv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tako je poljana i spilja na njoj prešla od sinova Hetovih u vlasništvo Abrahamovo za sahranjivanje. ");
INSERT INTO hrv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham bijaše već ostario, zašao u godine, Jahve je Abrahama blagoslovio u svemu. ");
INSERT INTO hrv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham prozbori svome najstarijem sluzi u kući, pod čijom je upravom bilo sve njegovo: “Stavi svoju ruku pod moje stegno ");
INSERT INTO hrv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","da te zakunem Jahvom, Bogom neba i Bogom zemlje, da mome sinu nećeš nabaviti za ženu ni jednu od kćeri Kanaanaca, među kojima boravim, ");
INSERT INTO hrv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","nego ćeš otići u moj rodni kraj i dobaviti ženu mom sinu Izaku.” ");
INSERT INTO hrv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A sluga mu reče: “A što ako žena ne htjedne za mnom ići u ovu zemlju? Hoću li ja onda odvesti tvoga sina u zemlju iz koje si ti došao?” ");
INSERT INTO hrv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham mu odgovori: “Dobro pripazi da onamo ne vodiš moga sina! ");
INSERT INTO hrv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jahve, Bog nebesa, koji me odveo iz kuće moga oca i rodnog kraja i koji mi je pod zakletvom obećao: 'Tvome ću potomstvu dati ovu zemlju', pred tobom će poslati svog anđela, i odande ćeš ti dovesti ženu mome sinu. ");
INSERT INTO hrv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","A ako žena ne bude htjela za tobom poći, ti ćeš biti oslobođen od ove moje zakletve; ali moga sina onamo ne vodi!” ");
INSERT INTO hrv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tako sluga stavi svoju ruku pod stegno Abrahamu, svom gospodaru, te mu se zakune. ");
INSERT INTO hrv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Sluga opremi deset gospodarevih deva, ponese sa sobom svakog blaga svoga gospodara pa se zaputi u Aram Naharajim, u Nahorov grad. ");
INSERT INTO hrv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pusti deve da poliježu izvan grada, pokraj studenca. Bijaše večer, kad žene izlaze da crpu vodu. ");
INSERT INTO hrv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Onda reče: “Oh, Jahve, Bože moga gospodara Abrahama, molim te, iziđi mi danas u susret i mome gospodaru Abrahamu milost iskaži! ");
INSERT INTO hrv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Evo me kraj studenca, a kćeri onih iz grada dolaze crpsti vodu; ");
INSERT INTO hrv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","pa neka djevojka kojoj ja rečem: 'Molim te, spusti svoj vrč da se napijem', a ona odgovori: 'Pij! I deve ću ti napojiti', bude ona koju si odredio za svoga slugu Izaka. Tako ću saznati da si iskazao milost mome gospodaru.” ");
INSERT INTO hrv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tek što on izreče svoje, gle, dođe Rebeka, kći Betuelova; taj Betuel bijaše sin Milke, žene Abrahamova brata Nahora. Dođe ona s krčagom na ramenu. ");
INSERT INTO hrv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Djevojka je bila krasna, djevica koju muškarac nije dirnuo. Siđe ona k vrelu, napuni krčag i eto je opet gore. ");
INSERT INTO hrv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Sluga joj potrča u susret i reče: “Daj mi malo vode iz svog vrča!” ");
INSERT INTO hrv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Pij, gospodine!” - odgovori ona. Brzo spusti krčag na ruku i dade mu piti. ");
INSERT INTO hrv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kad je njega napojila, reče: “Nalit ću i tvojim devama da se napoje.” ");
INSERT INTO hrv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Izlivši brzo krčag u korito, otrča natrag zdencu da ponovo zahvaća, i tako nali svim njegovim devama. ");
INSERT INTO hrv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Čovjek ju je šutke motrio ne bi li saznao je li Jahve njegov put uspješno priveo kraju ili nije. ");
INSERT INTO hrv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kad su deve prestale piti, čovjek izvadi viticu od zlata, tešku pol šekela, i stavi je na njezine nosnice, a na ruke joj stavi dvije zlatne narukvice, teške deset šekela. ");
INSERT INTO hrv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Zatim reče: “Kaži mi čija si kći. Ima li u kući tvoga oca mjesta za nas da prenoćimo?” ");
INSERT INTO hrv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ona mu odgovori: “Ja sam kći Betuela, koga je Milka rodila Nahoru.” ");
INSERT INTO hrv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Još mu doda: “Ima slame i p§iće kod nas u obilju, a i mjesta za prenoćište.” ");
INSERT INTO hrv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Čovjek se onda duboko nakloni te iskaže poštovanje Jahvi ");
INSERT INTO hrv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","i progovori: “Neka je blagoslovljen Jahve, Bog moga gospodara Abrahama, što nije uskratio svoju ljubav i svoju vjernost mome gospodaru. Mene je Jahve vodio pravim putem, u kuću brata moga gospodara.” ");
INSERT INTO hrv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Djevojka otrča i sve ovo ispripovjedi u kući svoje majke. ");
INSERT INTO hrv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","A Rebeka imala brata komu bijaše ime Laban. Laban se požuri van, k čovjeku kod studenca. ");
INSERT INTO hrv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Čim je vidio nosnu viticu i narukvice na rukama svoje sestre te čuo kako je njegova sestra Rebeka rekla: “Ovako mi je čovjek govorio”, on pođe onome koji je još stajao kod deva na studencu. ");
INSERT INTO hrv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Reče on: “Hajde unutra, blagoslovljeni od Jahve! Što stojiš vani kad sam ja spremio kuću i mjesto za deve.” ");
INSERT INTO hrv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tako čovjek uđe u kuću. Rastovare deve i dadu im slame i p§iće, a njemu i ljudima koji su ga pratili donesu vode da operu noge. ");
INSERT INTO hrv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ali kad su preda nj stavili hranu, reče: “Neću jesti dok ne kažem što imam kazati.” A Laban mu reče: “Onda kazuj!” ");
INSERT INTO hrv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","“Ja sam sluga Abrahamov”, poče on. ");
INSERT INTO hrv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","“Jahve je uvelike blagoslovio moga gospodara te je postao bogat. Nadavao mu je ovaca i goveda, srebra i zlata, sluga i sluškinja, deva i magaradi. ");
INSERT INTO hrv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, žena moga gospodara, rodi mu sina pošto je ostarjela, i on mu ustupi sve svoje. ");
INSERT INTO hrv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Potom mene moj gospodar zakune rekavši: 'Nemoj uzeti za ženu mome sinu djevojku Kanaanku, u zemlji u kojoj boravim kao stranac, ");
INSERT INTO hrv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","nego otiđi k obitelji moga oca, k mojoj rodbini, da nađeš ženu mome sinu.' ");
INSERT INTO hrv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","A ja rekoh svome gospodaru: 'A što ako žena za mnom ne pođe?' ");
INSERT INTO hrv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","On mi odgovori: 'Jahve, pred čijim sam licem hodio, poslat će s tobom svog anđela i tvoje će putovanje dovesti k cilju, a ti ćeš naći ženu mome sinu od moje rodbine, od obitelji moga oca. ");
INSERT INTO hrv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Jedino ćeš ovako biti oslobođen moje zakletve: ako dođeš k mojoj rodbini, i oni te odbiju, od moje si zakletve oslobođen.' ");
INSERT INTO hrv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Danas dođoh na studenac i rekoh: 'Jahve, Bože moga gospodara Abrahama, ako si voljan da uspješno završim putovanje što sam ga poduzeo, ");
INSERT INTO hrv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ja, evo, stojim kraj studenca, a djevojka koja dođe vodu crpsti i ja joj rečem: Daj mi da se napijem malo vode iz tvog vrča! - ");
INSERT INTO hrv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","i koja mi kaže: Pij ti, a i tvojim ću devama zahvatiti! - ona neka bude žena koju je Jahve odredio sinu moga gospodara.' ");
INSERT INTO hrv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Tek što sam ja završio govor u sebi, kad se, evo, pojavi Rebeka s vrčem na ramenu; siđe k izvoru i zahvati. Ja joj rekoh: 'Daj mi da se napijem!' ");
INSERT INTO hrv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ona brzo spusti vrč i odvrati: 'Pij! A napojit ću i tvoje deve.' Tako sam se ja napio, a ona napoji i moje deve. ");
INSERT INTO hrv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Pitao sam je: 'Čija si kći?' Odgovorila je: 'Kći sam Betuela, koga je Nahoru rodila Milka.' Tada joj stavim viticu na nos a narukvice na ruke. ");
INSERT INTO hrv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Duboko se naklonim i štovanje Jahvi iskažem te blagoslovim Jahvu, Boga gospodara moga, koji me vodio pravim putem da uzmem kćer brata moga gospodara njegovu sinu. ");
INSERT INTO hrv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","A sad, ako kanite iskazati ljubav i vjernost mome gospodaru, recite mi; ako li ne, to mi kažite, tako da mogu krenuti bilo desno bilo lijevo.” ");
INSERT INTO hrv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Tada odgovore Laban i Betuel: “Od Jahve to dolazi; mi tu ne možemo reći ni da ni ne. ");
INSERT INTO hrv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka je, eto, pred tobom: uzmi je pa idi, neka bude ženom sinu tvoga gospodara, kako je Jahve rekao.” ");
INSERT INTO hrv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kad Abrahamov sluga ču njihov pristanak, do zemlje se nakloni Jahvi. ");
INSERT INTO hrv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Sluga zatim izvadi srebrnih i zlatnih predmeta te haljina i dade ih Rebeki, a dade darova i njezinu bratu i majci. ");
INSERT INTO hrv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Tada jedoše i piše on i ljudi koji su bili s njim i provedoše noć. Kad su ujutro ustali, on reče: “Pustite me da se vratim svome gospodaru!” ");
INSERT INTO hrv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","A njezin brat i majka odgovore: “Neka djevojka ostane s nama još desetak dana, pa poslije toga pođi!” ");
INSERT INTO hrv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","On im reče: “Ne zadržavajte me kad je Jahve moje putovanje uspješno kraju priveo. Pustite me da se vratim svome gospodaru!” ");
INSERT INTO hrv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Oni odgovore: “Pozovimo djevojku i upitajmo što ona misli!” ");
INSERT INTO hrv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Dozovu Rebeku pa je upitaju: “Hoćeš li poći s ovim čovjekom?” Ona odgovori: “Hoću.” ");
INSERT INTO hrv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","I tako otpreme svoju sestru Rebeku i njezinu dojilju s Abrahamovim slugom i njegovim ljudima. ");
INSERT INTO hrv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Blagoslove Rebeku i reknu joj: “Sejo naša, budi mati nebrojenim tisućama, a dušmana svojih vrata potomci ti zaposjeli!” ");
INSERT INTO hrv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Onda se diže Rebeka i njezine dvorkinje, zajahaše deve te pođoše za čovjekom. Tako sluga preuze Rebeku i ode. ");
INSERT INTO hrv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Izak se vratio iz blizine Beer Lahaj Roja; živio je, naime, u kraju Negeba. ");
INSERT INTO hrv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","U predvečerje iziđe Izak da se poljem prošeta; diže oči i ugleda deve gdje dolaze. ");
INSERT INTO hrv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Kad Rebeka, podigavši svoje oči, opazi Izaka, sjaha s deve ");
INSERT INTO hrv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","pa zapita slugu: “Tko je onaj čovjek što poljem ide nama u susret?” A sluga odgovori: “Ono je moj gospodar.” Nato ona uze koprenu te se pokri. ");
INSERT INTO hrv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Sluga ispriča Izaku sve što je učinio. ");
INSERT INTO hrv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Tada Izak uvede Rebeku u svoj šator i uze je sebi za ženu. U ljubavi prema njoj Izak je nalazio utjehu nakon smrti svoje majke. ");
INSERT INTO hrv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham je sebi uzeo još jednu ženu; zvala se Ketura. ");
INSERT INTO hrv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ona mu je rodila Zimrana, Jokšana, Medana, Midjana, Jišbaka i Šuaha. ");
INSERT INTO hrv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","A od Jokšana rodili se Šeba i Dedan. Dedanovi su potomci: Ašurci, Letušci i Leumci. ");
INSERT INTO hrv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Sinovi su Midjanovi: Efa, Efer, Hanok, Abida i Eldaa. Sve su to potomci Keturini. ");
INSERT INTO hrv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham prenese sav svoj imutak na Izaka; ");
INSERT INTO hrv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","a sinovima od svojih suložnica dade Abraham samo darove i još ih za svoga života razašalje po istoku - daleko od svog sina Izaka - u Istočni kraj. ");
INSERT INTO hrv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ovo je duljina Abrahamova života što ga je proživio: stotinu sedamdeset i pet godina. ");
INSERT INTO hrv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Zatim Abraham preminu, umrije u sretnoj dobi - star i pun godina - te bi pridružen svojim precima. ");
INSERT INTO hrv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Njegovi sinovi, Izak i Jišmael, sahrane ga u spilji Makpeli, na poljani Efrona, sina Hetita Sohara, nasuprot Mamri: ");
INSERT INTO hrv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","to je poljana što ju je Abraham kupio od Hetovih sinova. Ondje je sahranjen Abraham i njegova žena Sara. ");
INSERT INTO hrv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Poslije Abrahamove smrti Bog je blagoslivljao njegova sina Izaka. Izak je živio blizu Beer Lahaj Roja. ");
INSERT INTO hrv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ovo je povijest Abrahamova sina Jišmaela, koga je Abrahamu rodila Sarina sluškinja, Egipćanka Hagara. ");
INSERT INTO hrv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","A ovo su sinovi Jišmaelovi, svaki po svom imenu i po svom rođenju: Jišmaelov prvenac Nebajot, Kedar, Adbeel, Mibsam, ");
INSERT INTO hrv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mišma, Duma, Masa, ");
INSERT INTO hrv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafiš i Kedma. ");
INSERT INTO hrv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","To su Jišmaelovi sinovi i to su njihova imena prema njihovim naseljima i taborištima: dvanaest poglavica od isto toliko plemena. ");
INSERT INTO hrv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","A ovo je duljina Jišmaelova života: stotinu trideset i sedam godina. Zatim izdahnu; umrije i bi pridružen svojim precima. ");
INSERT INTO hrv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Potomstvo mu se naselilo od Havile do Šura, koji je na istok Egiptu idući prema Ašuru. Nastaniše se nasuprot svojoj braći. ");
INSERT INTO hrv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ovo je povijest Abrahamova sina Izaka: Izak se rodio od Abrahama. ");
INSERT INTO hrv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Izaku je bilo četrdeset godina kad se oženio Rebekom, kćerkom Aramejca Betuela iz Padan Arama, a sestrom Aramejca Labana. ");
INSERT INTO hrv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Izak se obrati Jahvi za svoju ženu jer je bila nerotkinja. Jahve ga usliša te njegova žena Rebeka zače. ");
INSERT INTO hrv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","No djeca se u njezinoj utrobi tako sudarala te ona uzviknu: “Ako je tako, zašto ću živjeti!” Ode, dakle, da se posavjetuje s Jahvom. ");
INSERT INTO hrv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","I Jahve joj reče: “Dva su svijeta u utrobi tvojoj; dva će se naroda iz tvog krila odijeliti. Narod će nad narodom gospodovati, stariji će služiti mlađemu.” ");
INSERT INTO hrv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Došlo vrijeme da rodi, kad gle - blizanci u njezinoj utrobi. ");
INSERT INTO hrv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Pojavi se prvi. Bio je crven; sav runjav kao ogrtač. Stoga mu nadjenuše ime Ezav. ");
INSERT INTO hrv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Potom se pojavi njegov brat. Rukom se držao Ezavu za petu. Zato mu nadjenuše ime Jakov. Izaku je bilo šezdeset godina kad su oni rođeni. ");
INSERT INTO hrv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kad su dječaci odrasli, Ezav postane vješt lovac, čovjek pustare. Jakov je bio čovjek krotak i boravio je u šatorima. ");
INSERT INTO hrv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Izaku je Ezav bio draži jer je volio divljač, a Rebeka je više voljela Jakova. ");
INSERT INTO hrv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jednom Jakov kuhaše jelo. Ezav stigne s polja, gladan. ");
INSERT INTO hrv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Reče Ezav Jakovu: “Daj mi toga crvenog variva da pojedem jer sam izgladnio.” Stoga mu je ime Edom. ");
INSERT INTO hrv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","A Jakov odgovori: “Ustupi mi prije svoje prvorodstvo!” ");
INSERT INTO hrv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ezav reče: “Evo me skoro na smrti; što će mi prvorodstvo!” ");
INSERT INTO hrv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakov nastavi: “Prije mi se zakuni!” On mu se zakune, i tako proda Jakovu svoje prvorodstvo. ");
INSERT INTO hrv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Tada Jakov dade Ezavu kruha i čorbe od sočivice. Jeo je i pio, onda se digao i otišao. Tako Ezav pogazi svoje prvorodstvo. ");
INSERT INTO hrv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","U zemlji zavlada glad, različita od prijašnje što je bila za vrijeme Abrahama, pa Izak ode Abimeleku, kralju Filistejaca, u Geraru. ");
INSERT INTO hrv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Jahve mu se ukaza i reče: “Ne silazi u Egipat: boravi u zemlji koju ću ti označiti. ");
INSERT INTO hrv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","U ovoj se zemlji nastani, ja ću s tobom biti i blagoslivljati te; tebi i tvome potomstvu dat ću sve ove krajeve, da izvršim zakletvu kojom sam se zakleo tvome ocu Abrahamu. ");
INSERT INTO hrv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Tvoje ću potomstvo umnožiti kao zvijezde na nebesima i tvome ću potomstvu predati sve ove krajeve, tako da će se tvojim potomstvom blagoslivljati svi narodi zemlje; ");
INSERT INTO hrv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","a to zato što je Abraham slušao moj glas i pokoravao se mojim zapovijedima, mojim zakonima i odredbama!” ");
INSERT INTO hrv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tako Izak ostane u Geraru. ");
INSERT INTO hrv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kad su ga mještani pitali o njegovoj ženi, reče: “Ona mi je sestra.” Bojao se reći: “Ona mi je žena”, misleći: “Mještani bi me mogli ubiti zbog Rebeke jer je lijepa.” ");
INSERT INTO hrv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kako su se ondje duže zadržali, kralj Filistejaca Abimelek jednom pogleda kroz prozor i opazi kako Izak miluje svoju ženu Rebeku. ");
INSERT INTO hrv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Nato Abimelek pozove Izaka te reče: “Tako, ona ti je žena! Kako si mogao reći da ti je sestra?” Izak mu odgovori: “Jer sam mislio da bih zbog nje mogao poginuti.” ");
INSERT INTO hrv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek reče: “Zašto si nam to učinio? Umalo netko od ljudi nije legao s tvojom ženom. Tako bi na nas svalio krivnju.” ");
INSERT INTO hrv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Onda Abimelek izda naredbu svemu narodu: “Tko se god dotakne ovog čovjeka i njegove žene, glavu će izgubiti.” ");
INSERT INTO hrv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Izak je sijao u onom kraju i one godine urodilo mu stostruko. Jahve ga blagoslivljao ");
INSERT INTO hrv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","te je čovjek bivao sve bogatiji, dok nije postao vrlo bogat. ");
INSERT INTO hrv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Stekao je stada ovaca i goveda i mnogu služinčad, tako da su mu Filistejci zavidjeli. ");
INSERT INTO hrv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Zato Filistejci zasuše sve bunare što su ih sluge njegova oca bile iskopale - u vrijeme njegova oca Abrahama - i napuniše ih zemljom. ");
INSERT INTO hrv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Onda Abimelek reče Izaku: “Idi od nas jer si postao mnogo moćniji od nas!” ");
INSERT INTO hrv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tako Izak ode odande, postavi svoj šator u gerarskoj dolini i nastani se ondje. ");
INSERT INTO hrv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Izak opet iskopa bunare za vodu što su bili iskopani u vrijeme njegova oca Abrahama, a Filistejci ih bili zasuli poslije Abrahamove smrti. On ih je nazvao istim imenima kojima ih je zvao i njegov otac. ");
INSERT INTO hrv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ali kad su Izakove sluge, dok su u dolini kopale, ondje našle bunar sa živom vodom, ");
INSERT INTO hrv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","pastiri iz Gerara posvade se s Izakovim pastirima govoreći: “Naša je voda!” Bunaru je dao ime Esek, jer su se oni s njim svadili. ");
INSERT INTO hrv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","A kad su iskopali drugi bunar te se i zbog njega svađali, nazva ga imenom Sitna. ");
INSERT INTO hrv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Odatle se preseli pa iskopa drugi bunar. Zbog njega se nisu svađali, pa ga nazove imenom Rehobot i protumači: “Jer nam je Jahve dao prostor da se na zemlji umnožimo.” ");
INSERT INTO hrv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Odande se popne u Beer Šebu. ");
INSERT INTO hrv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Iste mu se noći ukaže Jahve i reče: “Ja sam Bog oca tvoga Abrahama. Ne boj se, ja sam s tobom! Blagoslovit ću te, potomke ti umnožit, zbog Abrahama, sluge svojega.” ");
INSERT INTO hrv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Izak tu podigne žrtvenik i zazove Jahvu po imenu; postavi ondje svoj šator, a njegove sluge počnu kopati bunar. ");
INSERT INTO hrv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Uto mu dođe Abimelek iz Gerara sa svojim savjetnikom Ahuzatom i s Fikolom, zapovjednikom vojske. ");
INSERT INTO hrv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Izak ih upita: “Zašto ste došli k meni kad me mrzite i kad ste me otjerali od sebe?” ");
INSERT INTO hrv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Oni odgovore: “Jasno vidimo da je Jahve s tobom. Stoga pomislismo: neka zakletva bude veza između nas i tebe. Daj da s tobom sklopimo savez: ");
INSERT INTO hrv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ti nama nećeš zla nanositi, kao što mi tebe nismo zlostavljali, nego uvijek prema tebi lijepo postupali i s mirom te otpustili. A blagoslov Jahvin bio nad tobom.” ");
INSERT INTO hrv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","On im priredi gozbu te su jeli i pili. ");
INSERT INTO hrv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Rano ujutro jedni se drugima zakunu. Potom ih Izak otpusti i oni od njega odu u miru. ");
INSERT INTO hrv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Toga istog dana dođu Izakove sluge i obavijeste ga o bunaru što su ga iskopali te mu reknu: “Našli smo vodu.” ");
INSERT INTO hrv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","On ga prozva Šiba. Zato je ime onom gradu do danas - Beer Šeba. ");
INSERT INTO hrv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kad je Ezavu bilo četrdeset godina, uzme za ženu Juditu, kćer Hetita Beerija, i Basematu, kćer Hetita Elona. ");
INSERT INTO hrv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","One postadoše izvor ogorčenja Izaku i Rebeki. ");
INSERT INTO hrv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ostarje Izak, vid mu se očinji gasio. Zato zovne svoga starijeg sina Ezava i reče mu: “Sine!” On mu odgovori: “Evo me!” ");
INSERT INTO hrv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","A on nastavi: “Vidiš, ostario sam, a ne znam dana svoje smrti. ");
INSERT INTO hrv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Zato uzmi svoju opremu, svoj tobolac i luk, pa idi u pustaru i ulovi mi divljači. ");
INSERT INTO hrv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Onda mi pripremi ukusan obrok, kako volim, te mi ga donesi da blagujem, pa da te mognem blagosloviti prije nego umrem.” ");
INSERT INTO hrv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka je slušala dok je Izak govorio svome sinu Ezavu, i kad je Ezav otišao u pustaru da ulovi divljači svome ocu, ");
INSERT INTO hrv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka reče svome sinu Jakovu: “Upravo sam čula kako tvoj otac govori tvome bratu Ezavu: ");
INSERT INTO hrv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Donesi mi divljači te mi priredi ukusan obrok da blagujem pa da te pred licem Jahvinim blagoslovim prije nego umrem.' ");
INSERT INTO hrv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","A sad, sine moj, poslušaj me i učini kako ti naredim. ");
INSERT INTO hrv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Otiđi k stadu i odande mi donesi dva lijepa kozleta, a ja ću od njih prirediti ukusan obrok tvome ocu, kako on voli. ");
INSERT INTO hrv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Onda ti donesi svome ocu da jede te tebe mogne blagosloviti prije nego umre.” ");
INSERT INTO hrv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ali Jakov odgovori svojoj majci Rebeki: “E, ali moj je brat Ezav runjav, a ja sam bez dlaka! ");
INSERT INTO hrv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Možda me se moj otac dotakne te ću u njegovim očima ispasti varalicom i na se svaliti prokletstvo, a ne blagoslov.” ");
INSERT INTO hrv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ali njegova mu majka odgovori: “Sine moj, tvoje prokletstvo neka padne na mene! Samo ti mene poslušaj, otiđi i donesi!” ");
INSERT INTO hrv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ode on, nađe i donese svojoj majci, a njegova majka priredi ukusan obrok, kako je njegov otac volio. ");
INSERT INTO hrv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Potom Rebeka uzme najljepše odijelo svoga starijeg sina Ezava što je u kući imala, pa u nj odjene svoga mlađeg sina Jakova. ");
INSERT INTO hrv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","U kožu kozleta zamota mu ruke i goli dio vrata. ");
INSERT INTO hrv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Stavi zatim ukusan obrok i kruh što ga je pripravila na ruke svoga sina Jakova. ");
INSERT INTO hrv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ode on k ocu i reče: “Oče!” On odgovori: “Evo me. Koji si ti moj sin?” ");
INSERT INTO hrv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","A Jakov odgovori svome ocu: “Ja sam Ezav, tvoj prvorođenac; učinio sam kako si mi rekao. Sad ustaj, sjedi pa jedi moje lovine, da me onda mogneš blagosloviti.” ");
INSERT INTO hrv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Izak upita svoga sina: “Kako si tako brzo uspio, sine moj?” On odgovori: “Jer mi je Jahve, Bog tvoj, bio milostiv.” ");
INSERT INTO hrv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Potom Izak reče Jakovu: “Primakni se, sine moj, da opipam jesi li ti zbilja moj sin Ezav ili nisi.” ");
INSERT INTO hrv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakov se primakne k svome ocu Izaku, koji ga opipa i reče: “Glas je Jakovljev, ali su ruke Ezavove.” ");
INSERT INTO hrv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nije ga prepoznao jer su mu ruke bile runjave kao i ruke njegova brata Ezava. Kad ga je htio blagosloviti, ");
INSERT INTO hrv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","upita još jednom: “Jesi li ti zaista moj sin Ezav?” Odgovori on: “Jesam.” ");
INSERT INTO hrv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Potom reče Izak: “Stavi preda me da blagujem lovine svoga sina pa da te blagoslovi duša moja.” Jakov ga posluži pa je jeo. Zatim mu donese i vina, pa je pio. ");
INSERT INTO hrv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Poslije toga reče mu njegov otac Izak: “Primakni se, sine moj, i poljubi me!” ");
INSERT INTO hrv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kad se primače i poljubi ga, Izak osjeti miris njegove odjeće pa ga blagoslovi: “Gle, miris sina mog nalik je mirisu polja koje Jahve blagoslovi. ");
INSERT INTO hrv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Neka ti Bog daje rosu s neba i rodnost zemlje: izobilje žita i mladoga vina. ");
INSERT INTO hrv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Narodi ti služili, plemena ti se klanjala! Braćom svojom gospodari, nek sinci majke tvoje pred tobom padaju! Proklet bio tko tebe proklinje; blagoslovljen tko te blagoslivlje!” ");
INSERT INTO hrv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Tek što se Jakov udaljio od svoga oca Izaka - pošto je Izak podijelio blagoslov Jakovu - njegov brat Ezav dođe iz lova. ");
INSERT INTO hrv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","I on priredi ukusan obrok i donese ga svome ocu. I reče svome ocu: “Ustani, oče moj, i blaguj od lovine svoga sina da me onda mogneš blagosloviti!” ");
INSERT INTO hrv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","A njegov ga otac Izak zapita: “Tko si ti?” On odgovori: “Ja sam tvoj prvorođenac Ezav!” ");
INSERT INTO hrv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Izak se silno prepadne: “Pa tko je onda bio onaj što je divljači ulovio i meni već donio? Blagovao sam je prije nego si ti došao; onoga sam blagoslovio i blagoslovljen će ostati.” ");
INSERT INTO hrv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kad je Ezav čuo riječi svoga oca, kriknu glasno i gorko zaplaka pa reče svome ocu: “I mene blagoslovi, oče!” ");
INSERT INTO hrv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","A on odvrati: “Brat tvoj dođe na prijevaru i odnese tvoj blagoslov.” ");
INSERT INTO hrv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","“Zato valjda što mu je ime Jakov, dvaput me već prevario”, reče Ezav. “Oduzeo mi prvorodstvo, a sad mi evo oduze i blagoslov.” Onda doda: “Zar za me nisi sačuvao nikakva blagoslova?” ");
INSERT INTO hrv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Izak odgovori Ezavu: “Njega sam već postavio za tvoga gospodara; njemu sam svu njegovu braću predao za sluge; žitom sam ga i vinom opskrbio. A što sad za te mogu učiniti, sine moj?” ");
INSERT INTO hrv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ezav odgovori svome ocu: “Zar ti, oče, raspolažeš samo jednim blagoslovom? Blagoslovi i mene, oče moj!” Ezav jecaše na sav glas. ");
INSERT INTO hrv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tada otac njegov Izak progovori i reče: “Daleko od plodna tla dom tvoj će biti, daleko od rose s neba. ");
INSERT INTO hrv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Od mača svoga ćeš živjeti, brata svoga ćeš služiti. Ali jednom, kada se pobuniš, jaram ćeš njegov stresti sa svog vrata.” ");
INSERT INTO hrv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ezav zamrzi Jakova zbog blagoslova kojim ga je otac njegov blagoslovio pa reče u sebi: “Čim dođu dani žalosti za mojim ocem, ubit ću ja svoga brata Jakova.” ");
INSERT INTO hrv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kada su Rebeki javili te riječi što ih je izrekao njezin stariji sin Ezav, zovne ona svoga mlađeg sina Jakova te mu reče: “Pazi! Brat ti se Ezav nosi mišlju kako će te ubiti. ");
INSERT INTO hrv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ali ti, sine moj, poslušaj mene: odmah bježi mome bratu Labanu u Haran. ");
INSERT INTO hrv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ostani kod njega neko vrijeme, dok bijes brata tvoga na te jenja, ");
INSERT INTO hrv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","dok se srdžba brata tvoga odvrati od tebe te on zaboravi što si mu učinio. Ja ću onda po te poslati i odande te dovesti. Zašto da vas obojicu izgubim u jedan dan!” ");
INSERT INTO hrv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Potom Rebeka reče Izaku: “Moj mi je život dosadio zbog ovih žena Hetitkinja. Ako se i Jakov oženi kojom kao što su ove urođenice, Hetitkinjom, što će mi onda život!” ");
INSERT INTO hrv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Stoga Izak pozove Jakova, blagoslovi ga te mu naloži: “Nemoj uzimati ženu od kanaanskih djevojaka. ");
INSERT INTO hrv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Odmah se zaputi u Padan Aram, u dom Betuela, oca svoje majke, pa odande sebi uzmi ženu, od kćeri Labana, brata svoje majke. ");
INSERT INTO hrv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","A Bog Svemožni, El-Šadaj, neka te blagoslovi i neka te učini rodnim i brojnim, tako da postaneš mnoštvo naroda. ");
INSERT INTO hrv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Neka protegne na te blagoslov Abrahamov, na te i na tvoje potomstvo, tako da zaposjedneš zemlju u kojoj boraviš kao pridošlica, a koju je Bog predao Abrahamu!” ");
INSERT INTO hrv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Tako Izak otpremi Jakova, i on ode u Padan Aram Labanu, sinu Aramejca Betuela, bratu Rebeke, majke Jakova i Ezava. ");
INSERT INTO hrv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Kad je Ezav vidio kako je Izak blagoslovio Jakova kad ga je otpremao u Padan Aram da odande sebi uzme ženu, naređujući mu kad ga je blagoslivljao: “Ne smiješ uzeti ženu od kanaanskih djevojaka”, ");
INSERT INTO hrv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","i da je Jakov poslušao svoga oca i svoju majku te otišao u Padan Aram, ");
INSERT INTO hrv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ezav shvati koliko su djevojke kanaanske mrske njegovu ocu Izaku. ");
INSERT INTO hrv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Stoga ode k Jišmaelu te se, uza žene koje već imaše, oženi Mahalatom, kćerju Jišmaela, sina Abrahamova, a sestrom Nebajotovom. ");
INSERT INTO hrv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakov ostavi Beer Šebu i zaputi se u Haran. ");
INSERT INTO hrv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Stigne u neko mjesto i tu prenoći, jer sunce bijaše već zašlo. Uzme jedan kamen s onog mjesta, stavi ga pod glavu i na tom mjestu legne. ");
INSERT INTO hrv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I usne san: ljestve stoje na zemlji, a vrhom do neba dopiru, i anđeli Božji po njima se penju i silaze. ");
INSERT INTO hrv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Uza nj je Jahve te mu govori: “Ja sam Jahve, Bog tvoga praoca Abrahama i Bog Izakov. Zemlju na kojoj ležiš dat ću tebi i tvome potomstvu. ");
INSERT INTO hrv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tvojih će potomaka biti kao i praha na zemlji; raširit ćete se na zapad, istok, sjever i jug; tobom će se i tvojim potomstvom blagoslivljati svi narodi zemlje. ");
INSERT INTO hrv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Dobro znaj: ja sam s tobom; čuvat ću te kamo god pođeš te ću te dovesti natrag u ovu zemlju; i neću te ostaviti dok ne izvršim što sam ti obećao.” ");
INSERT INTO hrv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakov se probudi od sna te reče: “Zaista se Jahve nalazi na ovome mjestu, ali ja nisam znao!” ");
INSERT INTO hrv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Potresen, uzviknu: “Kako je strašno ovo mjesto! Zaista, ovo je kuća Božja, ovo su vrata nebeska!” ");
INSERT INTO hrv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Rano ujutro Jakov uzme onaj kamen što ga bijaše stavio pod glavu, uspravi ga kao stup i po vrhu mu izlije ulja. ");
INSERT INTO hrv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ono mjesto on nazva Betel, dok je ime tome gradu prije bilo Luz. ");
INSERT INTO hrv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Tada učini zavjet: “Ako Bog ostane sa mnom i uščuva me na ovom putu kojim idem, dade mi kruha da jedem i odijela da se oblačim, ");
INSERT INTO hrv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","te se zdravo vratim kući svoga oca, Jahve će biti moj Bog. ");
INSERT INTO hrv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","A ovaj kamen koji sam uspravio kao stup bit će kuća Božja. A od svega što mi budeš davao za te ću odlagati desetinu.” ");
INSERT INTO hrv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jakov nastavi put i dođe u zemlju istočnu. ");
INSERT INTO hrv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Najednom opazi studenac u polju. Tri su stada ovaca oko njega plandovala, jer se na tome studencu napajahu. Velik se kamen nalazio studencu na otvoru. ");
INSERT INTO hrv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Jedino kad bi se svi pastiri ondje skupili, mogli bi odvaliti kamen s otvora i ovce napojiti; tada bi opet prevalili kamen na njegovo mjesto, na otvor studenca. ");
INSERT INTO hrv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","“Odakle ste, braćo moja?” - zapita ih Jakov. “Iz Harana”, odgovore. ");
INSERT INTO hrv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","“Poznajete li”, pitaše ih dalje, “Nahorova sina Labana?” “Poznajemo”, odgovore. ");
INSERT INTO hrv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Je li zdravo?” - opet ih upita. “Zdravo je; a evo mu dolazi kći Rahela sa stadom”, odgovore. ");
INSERT INTO hrv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","“Još ima mnogo dana”, nastavi on, “nije vrijeme spraćati blago. Zašto ga ne napojite i ne otjerate na pašu?” ");
INSERT INTO hrv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“Ne možemo dok se ne skupe svi pastiri”, odgovoriše, “da odvale kamen s otvora studenca, tako da mognemo napojiti ovce.” ");
INSERT INTO hrv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Dok je on još s njima govorio, dođe Rahela s ovcama svoga oca. Bila je, naime, pastirica. ");
INSERT INTO hrv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kako Jakov ugleda Rahelu, kćer Labana, brata svoje majke, sa stadom svoga ujaka Labana, Jakov se primače i odvali kamen s otvora studenca te napoji stado svoga ujaka Labana. ");
INSERT INTO hrv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Zatim Jakov poljubi Rahelu, a onda briznu u plač. ");
INSERT INTO hrv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Potom Jakov kaza Raheli da je on sestrić njezina oca, sin Rebekin. Nato ona otrča i obavijesti oca. ");
INSERT INTO hrv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kad je Laban čuo vijest o Jakovu, sinu svoje sestre, potrča mu u susret. Zagrli ga i poljubi te dovede u svoju kuću. Ispriča Labanu sve što mu se dogodilo. ");
INSERT INTO hrv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","A onda Laban reče. “Zbilja si ti moja kost i moje meso!” Pošto je Jakov proboravio s Labanom mjesec dana, ");
INSERT INTO hrv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban reče Jakovu: “Zar ćeš me zato što si mi sestrić badava služiti! Kaži mi koliko ćeš tražiti za najam?” ");
INSERT INTO hrv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","A Laban imaše dvije kćeri. Starijoj bijaše ime Lea, a mlađoj Rahela. ");
INSERT INTO hrv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea imala slabe oči, a Rahela bila stasita i lijepa. ");
INSERT INTO hrv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Kako je Jakov volio Rahelu, reče: “Služit ću ti sedam godina za tvoju mlađu kćer Rahelu.” ");
INSERT INTO hrv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban odvrati: “Bolje je da je tebi dam nego kakvu strancu. Ostani sa mnom!” ");
INSERT INTO hrv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tako je Jakov služio za Rahelu sedam godina, ali mu se učinile, zbog ljubavi prema njoj, kao nekoliko dana. ");
INSERT INTO hrv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Poslije toga Jakov reče Labanu: “Daj mi moju ženu, jer se moje vrijeme navršilo pa bih htio k njoj.” ");
INSERT INTO hrv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban sabra sav svijet onog mjesta i priredi gozbu. ");
INSERT INTO hrv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ali navečer uzme svoju kćer Leu pa nju uvede k Jakovu, i on priđe k njoj. ");
INSERT INTO hrv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban dade svoju sluškinju Zilpu svojoj kćeri Lei za sluškinju. ");
INSERT INTO hrv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kad bi ujutro, a to, gle, Lea! Tada Jakov reče Labanu: “Zašto si mi to učinio! Zar te ja nisam služio za Rahelu? Zašto si me prevario?” ");
INSERT INTO hrv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban odgovori: “U našem mjestu nije običaj da se mlađa udaje prije starije. ");
INSERT INTO hrv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Završi s njom ovu ženidbenu sedmicu, a onda ću ti dati i drugu, za drugih sedam godina službe kod mene.” Jakov pristane: navrši onu ženidbenu sedmicu. ");
INSERT INTO hrv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Onda mu Laban dade i svoju kćer Rahelu za ženu. ");
INSERT INTO hrv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban dade svoju sluškinju Bilhu svojoj kćeri Raheli za sluškinju. ");
INSERT INTO hrv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakov nato priđe Raheli. Rahelu je više volio nego Leu. I tako je služio Labana još sedam godina. ");
INSERT INTO hrv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jahve je vidio da Lea nije voljena, te je učini plodnom, dok Rahela ostade nerotkinja. ");
INSERT INTO hrv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea zače i rodi sina; nadjenu mu ime Ruben, a to znači, kako je ona protumačila: “Jahve je vidio moju nevolju i stoga će me sada muž moj ljubiti.” ");
INSERT INTO hrv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Opet zače i rodi sina te izjavi: “Jahve je čuo da nisam voljena, stoga mi je dao i ovoga.” Zato mu nadjenu ime Šimun. ");
INSERT INTO hrv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Opet zače i rodi sina te izjavi: “Sad će se moj muž meni prikloniti: tri sam mu sina rodila.” Zato mu nadjenu ime Levi. ");
INSERT INTO hrv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A kad je još jednom začela i sina rodila, izjavi: “Ovaj put hvalit ću Jahvu.” Stoga sinu nadjenu ime Juda. Potom prestade rađati. ");
INSERT INTO hrv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Vidjevši Rahela da Jakovu ne rađa djece, postade zavidna svojoj sestri pa reče Jakovu: “Daj mi djecu! Inače ću svisnuti!” ");
INSERT INTO hrv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakov se razljuti na Rahelu te reče. “Zar sam ja namjesto Boga koji ti je uskratio plod utrobe?” ");
INSERT INTO hrv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","A ona odgovori: “Evo moje sluškinje Bilhe: uđi k njoj, pa neka rodi na mojim koljenima, da tako i ja steknem djecu po njoj.” ");
INSERT INTO hrv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Dade mu dakle svoju sluškinju Bilhu za ženu, i Jakov priđe k njoj. ");
INSERT INTO hrv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha zače te Jakovu rodi sina. ");
INSERT INTO hrv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Tada Rahela reče: “Jahve mi je dosudio pravo. Uslišao je moj glas i dao mi sina.” Stoga mu nadjenu ime Dan. ");
INSERT INTO hrv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahelina sluškinja Bilha opet zače i rodi Jakovu drugoga sina. ");
INSERT INTO hrv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Tada Rahela reče: “Žestoko sam se borila sa sestrom, ali sam pobijedila.” Tako mu nadjenu ime Naftali. ");
INSERT INTO hrv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","A vidjevši Lea da je prestala rađati, uzme svoju sluškinju Zilpu pa je dade Jakovu za ženu. ");
INSERT INTO hrv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","I kad je Leina sluškinja Zilpa rodila Jakovu sina, ");
INSERT INTO hrv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea uskliknu: “Koje sreće!” Tako mu nadjenu ime Gad. ");
INSERT INTO hrv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leina sluškinja Zilpa rodi Jakovu i drugog sina, ");
INSERT INTO hrv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","i Lea opet uskliknu: “Blago meni! Žene će me zvati blaženom!” Tako mu nadjenu ime Ašer. ");
INSERT INTO hrv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Jednoga dana, u vrijeme pšenične žetve, namjeri se Ruben u polju na ljubavčice te ih donese svojoj majci Lei. I Rahela reče Lei: “Daj mi od ljubavčica svoga sina!” ");
INSERT INTO hrv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","A Lea odgovori: “Zar ti nije dosta što si mi oduzela muža pa još hoćeš da od mene uzmeš i ljubavčice moga sina?” Rahela odgovori: “Pa dobro, neka s tobom noćas leži u zamjenu za ljubavčice tvog sina.” ");
INSERT INTO hrv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kad je Jakov navečer stigao iz polja, Lea mu iziđe u susret pa reče: “Treba da dođeš k meni, jer sam te unajmila za ljubavčice moga sina.” One je noći on s njom ležao. ");
INSERT INTO hrv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Bog usliša Leu; ona zače te Jakovu rodi petog sina. ");
INSERT INTO hrv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Onda Lea reče: “Bog mi je uzvratio nagradom što sam ustupila svoju sluškinju svome mužu.” Stoga sinu nadjenu ime Jisakar. ");
INSERT INTO hrv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea opet zače i rodi Jakovu šestoga sina. ");
INSERT INTO hrv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Onda Lea reče: “Bog me obdari dragocjenim darom; sada će mi moj muž dati darove: tÓa rodila sam mu šest sinova.” Tako mu nadjenu ime Zebulun. ");
INSERT INTO hrv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Zatim rodi kćer te joj nadjenu ime Dina. ");
INSERT INTO hrv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Uto se Bog sjeti Rahele: Bog je usliša i otvori njezinu utrobu. ");
INSERT INTO hrv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ona zače i rodi sina te reče: “Ukloni Bog moju sramotu!” ");
INSERT INTO hrv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Nadjene mu ime Josip, rekavši: “Neka mi Jahve pridoda drugog sina!” ");
INSERT INTO hrv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Pošto je Rahela rodila Josipa, Jakov reče Labanu: “Pusti me da idem u svoj zavičaj! ");
INSERT INTO hrv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Daj mi moje žene za koje sam te služio i moju djecu da mogu otići: tÓa dobro znaš kako sam te služio.” ");
INSERT INTO hrv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","A Laban mu odgovori: “Ne idi, ako si mi prijatelj. Znam da me Jahve blagoslivljao zbog tebe.” ");
INSERT INTO hrv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","I nadoda: “Odredi plaću koju želiš od mene, i dat ću ti.” ");
INSERT INTO hrv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","On mu odgovori: “Ti dobro znaš što je moja služba značila za te i kako je tvome blagu bilo sa mnom. ");
INSERT INTO hrv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Malenkost što si je imao prije nego sam ja došao povećala se vrlo mnogo, jer kuda god sam prolazio Jahve te blagoslivljao na mojim koracima. A sad je vrijeme da poradim i za svoj dom.” ");
INSERT INTO hrv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","On upita: “Koliko da ti platim?” Jakov odgovori: “Nemoj mi platiti ništa! Ako mi učiniš ovo, opet ću na pašu goniti i čuvati tvoje stado. ");
INSERT INTO hrv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Daj da prođem danas kroz tvoje stado i od njega izlučim svaku garavu ovcu i svaku šarenu ili napruganu kozu! Neka to bude moja plaća! ");
INSERT INTO hrv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","A ubuduće kad budeš svojim očima provjeravao moju naplatu, moje će poštenje biti svjedok za mene: nađe li se među mojim kozama ijedna koja ne bude šarena ili naprugana, ili među ovcama koja ne bi bila garava, neka se smatra ukradenom!” ");
INSERT INTO hrv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban reče: “Dobro, neka bude kako si kazao.” ");
INSERT INTO hrv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ali toga dana Laban izluči naprugane i šarene jarce i sve riđaste i šarene koze - svaku koja je na sebi imala bijelo - i sve garave ovce pa ih preda svojim sinovima. ");
INSERT INTO hrv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","I odande gdje je Jakov pasao ostatak Labanova stada udalji se za koja tri dana hoda. ");
INSERT INTO hrv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","A Jakov uzme zelenih mladica od topola, badema i platana; na njima izreza bijele pruge, otkrivši bjeliku na mladicama. ");
INSERT INTO hrv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Pruće tako isprugano postavi u korita, u pojila iz kojih se stoka napajala. A kako se stoka parila kad je na vodu dolazila, ");
INSERT INTO hrv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","to su se jarci parili uz pruće, pa su koze kozile prugaste, riđaste i šarene kozliće. ");
INSERT INTO hrv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Tako je i ovce Jakov bio izlučio i glave im okrenuo prema prugastima ili posve garavima što su bile u Labanovu stadu. Tako je za se namicao posebna stada koja nije miješao s Labanovim stadima. ");
INSERT INTO hrv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Osim toga, kad bi se god dobro uzrasla stoka parila, Jakov bi stavio pruće u korita, baš pred oči živine, tako da se pari pred prućem. ");
INSERT INTO hrv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ali ga pred kržljavu marvu nije stavljao. Tako je kržljava zapadala Labana, a dobro razvijena Jakova. ");
INSERT INTO hrv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Čovjek se tako silno obogatio, stekao mnogu stoku, sluge i sluškinje, deve i magarad. ");
INSERT INTO hrv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Uto Jakov dozna kako Labanovi sinovi govore: “Sve dobro našega oca uze Jakov; i od onoga što bi moralo pripasti našem ocu namaknuo je sve ono bogatstvo.” ");
INSERT INTO hrv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","A opazi Jakov i na Labanovu licu da se on ne drži prema njemu kao prije. ");
INSERT INTO hrv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tada Jahve reče Jakovu: “Vrati se u zemlju svojih otaca, u svoj zavičaj, i ja ću biti s tobom!” ");
INSERT INTO hrv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jakov onda pozove Rahelu i Leu u polje, k svome stadu, ");
INSERT INTO hrv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","pa im reče: “Ja vidim na licu vašega oca da se on ne drži prema meni kao prije; ali Bog oca moga sa mnom je bio. ");
INSERT INTO hrv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","I same znate da sam vašega oca služio koliko sam god mogao; ");
INSERT INTO hrv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","pa ipak je vaš otac mene varao, deset mi je puta plaću mijenjao. Ali Bog nije dopuštao da mi nanese štetu. ");
INSERT INTO hrv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ako bi on rekao: 'Svaka šarena neka bude tebi za naplatu', onda bi cijelo stado mladilo šarene; ako bi opet rekao: 'Prugasti neka budu tebi za plaću', onda bi cijelo stado mladilo prugaste. ");
INSERT INTO hrv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tako je Bog uzimao blago od vašeg oca pa ga meni davao. ");
INSERT INTO hrv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Jednom, kad se stado oplođivalo, nenadano vidjeh u snu da su jarci u stadu, dok su se parili, bili prugasti, mjestimično bijeli i šareni. ");
INSERT INTO hrv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Još u snu anđeo Božji mene zovne: 'Jakove!' 'Evo me!' rekoh. ");
INSERT INTO hrv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A on nastavi: 'Primijeti dobro da su jarci u stadu što se pare prugasti, mjestimično bijeli i šareni. Ja sam, naime, vidio sve što ti je Laban činio. ");
INSERT INTO hrv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ja sam Bog koji ti se ukazao u Betelu, gdje si uljem pomazao stup i gdje si mi učinio zavjet. Sad ustaj i idi iz ove zemlje; vrati se u svoj zavičaj!'” ");
INSERT INTO hrv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Nato mu Rahela i Lea odgovore: “Zar još imamo baštinskog dijela u svome očinskom domu? ");
INSERT INTO hrv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Zar nas otac nije smatrao tuđinkama? TÓa on je nas prodao, a onda je pojeo novac što ga je za nas dobio! ");
INSERT INTO hrv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Sve bogatstvo što je Bog oduzeo našem ocu zbilja je naše i djece naše. Zato izvrši sve što ti je Bog rekao!” ");
INSERT INTO hrv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Nato Jakov naprti na deve svoju djecu i svoje žene; ");
INSERT INTO hrv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","pred sobom potjera sve svoje blago, sva svoja dobra što ih je stekao, stoku što ju je namaknuo u Padan Aramu: krenu u zemlju kanaansku, k svome ocu Izaku. ");
INSERT INTO hrv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban bijaše otišao da striže svoje ovce, pa Rahela prisvoji kućne kumire koji su pripadali njezinu ocu. ");
INSERT INTO hrv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakov zavara Aramejca Labana tako da nije ni slutio da će bježati. ");
INSERT INTO hrv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","I pobjegne sa svim što je bilo njegovo. Ubrzo prijeđe Eufrat i upravi put prema brdu Gileadu. ");
INSERT INTO hrv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Trećeg dana obavijeste Labana da je Jakov pobjegao. ");
INSERT INTO hrv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","On povede sa sobom svoje rođake te je za Jakovom išao u potjeru sedam dana hoda; stiže ga na brdu Gileadu. ");
INSERT INTO hrv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ali se Bog ukaza Aramejcu Labanu, noću u snu, te mu reče. “Pazi da protiv Jakova ne poduzimlješ ništa, ni dobro ni zlo!” ");
INSERT INTO hrv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Uto Laban stigne Jakova. Jakov bijaše postavio svoj šator na Glavici, a Laban se utabori na brdu Gileadu. ");
INSERT INTO hrv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Onda Laban reče Jakovu: “Što si to htio zavaravajući me i odvodeći mi kćeri kao zarobljenice na maču? ");
INSERT INTO hrv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Zašto si potajno pobjegao, u bludnju me zaveo i nisi me obavijestio? Otpratio bih te s veseljem i pjesmom, uz bubnje i lire. ");
INSERT INTO hrv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nisi mi dopustio ni da izljubim svoje kćeri i svoju unučad! Zbilja si ludo postupio. ");
INSERT INTO hrv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","U mojoj je ruci da s tobom loše postupim. Ali Bog tvoga oca noćas mi reče: 'Pazi da protiv Jakova ne poduzmeš ništa, ni dobro ni zlo!' ");
INSERT INTO hrv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Sada dobro, otišao si jer si čeznuo za svojim očinskim domom; ali zašto si mi kumire pokrao?” ");
INSERT INTO hrv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakov odgovori Labanu: “Strepio sam od pomisli da bi mi mogao silom oteti svoje kćeri. ");
INSERT INTO hrv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","A kumire svoje u koga nađeš, onaj neka pogine! Ovdje pred našom braćom kaži što je tvoga pri meni i nosi!” Jakov nije znao da ih je Rahela prisvojila. ");
INSERT INTO hrv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tako Laban uđe u šator Jakovljev, pa u šator Lein, onda u šator dviju sluškinja, ali ništa ne nađe. Izišavši iz Leina šatora, uđe u šator Rahelin. ");
INSERT INTO hrv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","A Rahela bijaše uzela kumire i stavila ih u sjedalo svoje deve, a onda na njih sjela. Laban je premetao po svemu šatoru, ali ih ne nađe. ");
INSERT INTO hrv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ona je, naime, rekla svome ocu: “Neka se moj gospodar ne ljuti što ne mogu pred njim ustati jer imam ono što je red kod žena.” I tako je pretraživao, ali kumira nije našao. ");
INSERT INTO hrv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Sad se Jakov ražesti i zađe u prepirku s Labanom. Otvoreno Jakov reče Labanu: “Kakvo je moje zlodjelo, koja li je moja krivnja da me progoniš? ");
INSERT INTO hrv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Eto si premetnuo sve moje stvari, pa kakav si predmet našao od svega svog kućanstva? Položi ga tu pred moj i svoj rod pa neka oni budu suci među nama dvojicom. ");
INSERT INTO hrv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Za ovih dvadeset godina što sam ih s tobom proveo ni tvoje ovce ni tvoje koze nisu se jalovile niti sam ja jeo ovnova iz tvoga stada. ");
INSERT INTO hrv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ono što bi zvijer razdrla, tebi nisam donosio, nego bih od svoga gubitak nadoknadio. Ti si to od mene tražio, bilo da je nestalo danju ili da je nestalo noću. ");
INSERT INTO hrv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Često sam danju skapavao od žeđi, a obnoć od studeni. San je bježao od mojih očiju. ");
INSERT INTO hrv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Od ovih dvadeset godina što sam ih proveo u tvojoj kući četrnaest sam ti godina služio za tvoje dvije kćeri, a šest godina za tvoju stoku, jer si mi mijenjao zaradu deset puta. ");
INSERT INTO hrv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Da sa mnom nije bio Bog moga oca, Bog Abrahamov, Strah Izakov, otpravio bi me praznih ruku. Ali je Bog gledao moju nevolju i trud mojih ruku te je sinoć dosudio.” ");
INSERT INTO hrv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Nato Laban odgovori Jakovu: “Kćeri su moje kćeri; djeca su moja djeca; stada su moja stada, sve što gledaš moje je. Ali što danas mogu učiniti ovim svojim kćerima ili djeci koju su rodile? ");
INSERT INTO hrv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Pa dobro, hajde da ti i ja napravimo ugovor, tako da bude svjedok između mene i tebe.” ");
INSERT INTO hrv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Nato Jakov uzme jedan kamen pa ga uspravi kao stup, ");
INSERT INTO hrv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","a onda reče svojim ljudima: “Skupite kamenja!” Tako oni nakupe kamenja i nabace gomilu. Tu su na gomili blagovali. ");
INSERT INTO hrv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban je nazva “Jegar sahaduta”, a Jakov je nazva “Gal-ed”. ");
INSERT INTO hrv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Onda Laban izjavi: “Neka ova gomila danas bude svjedok između mene i tebe!” Stoga je nazvana Gal-ed, ");
INSERT INTO hrv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ali i Mispa, jer je rekao. “Neka Jahve bude na vidu i tebi i meni kad jedan drugog ne budemo gledali. ");
INSERT INTO hrv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ako budeš loše postupao prema mojim kćerima, ili ako uzmeš druge žene uz moje kćeri, sve da nitko drugi ne bude s nama, znaj da će Bog biti svjedok između mene i tebe.” ");
INSERT INTO hrv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Potom Laban reče Jakovu: “Ovdje je, evo, gomila; ovdje je stup koji sam uspravio između sebe i tebe: ");
INSERT INTO hrv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ova gomila i ovaj stup neka budu jamac da ja u zloj namjeri neću ići na te iza ove gomile i da ti nećeš ići na me iza ove gomile i ovog stupa. ");
INSERT INTO hrv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Neka Bog Abrahamov i Bog Nahorov budu naši suci!” Jakov se zakune Bogom - Strahom svoga oca Izaka. ");
INSERT INTO hrv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Poslije toga Jakov prinese žrtvu na Glavici i pozva svoje ljude da blaguju. Poslije objeda proveli su noć na Glavici. ");
INSERT INTO hrv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ranim se jutrom Laban digne, izljubi svoje sinove i svoje kćeri te ih blagoslovi; onda se zaputi natrag u svoje mjesto. ");
INSERT INTO hrv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jakov je putovao svojim putem, kad mu u susret izađu anđeli Božji. ");
INSERT INTO hrv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Kad ih Jakov opazi, reče: “Ovo je Božje taborište!” Zato nazva ono mjesto Mahanajim. ");
INSERT INTO hrv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jakov pošalje pred sobom glasnike svome bratu Ezavu u zemlju Seir, u Edomsku pustaru, ");
INSERT INTO hrv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","i naloži im: “Ovako ćete reći mome gospodaru Ezavu: 'Sluga tvoj Jakov poručuje ti: Boravio sam kod Labana i dosad se ondje zadržao. ");
INSERT INTO hrv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Stekao sam goveda, magaradi, ovaca, sluga i sluškinja. Javljam to svome gospodaru, ne bih li našao naklonost u njegovim očima.'” ");
INSERT INTO hrv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Glasnici se vrate Jakovu te mu reknu: “Bili smo kod tvoga brata Ezava; on sam dolazi ti u susret sa četiri stotine momaka.” ");
INSERT INTO hrv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Jakov se silno uplaši. U zabrinutosti rastavi na dva tabora ljude, stada, krda i deve što ih je sa sobom imao. ");
INSERT INTO hrv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Računao je: ako Ezav naiđe na jedan tabor i napadne ga, drugi bi se tabor mogao spasiti. ");
INSERT INTO hrv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Onda se Jakov pomoli: “O Bože oca moga Abrahama! Bože oca moga Izaka! O Jahve, koji si mi naredio: 'Vrati se u svoj rodni kraj, i ja ću ti biti dobrostiv!' ");
INSERT INTO hrv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nisam vrijedan sve dobrote koju si tako postojano iskazivao svome sluzi. TÓa samo sam sa svojim štapom nekoć prešao ovaj Jordan, a sad sam narastao u dva tabora. ");
INSERT INTO hrv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Izbavi me od šaka moga brata, od šaka Ezavovih! Inače se bojim da bi mogao doći i umlatiti i mene, i majke, i djecu. ");
INSERT INTO hrv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ti si rekao: 'Obilnim ću te dobrima obasipati i tvoje potomstvo umnožiti poput pijeska u moru koji se ne da prebrojiti zbog množine.'” ");
INSERT INTO hrv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ondje provede onu noć; a onda, od onog što je imao pri ruci, pripravi dar svome bratu Ezavu: ");
INSERT INTO hrv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","dvjesta koza i dvadeset jaraca, dvjesta ovaca i dvadeset ovnova; ");
INSERT INTO hrv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","trideset deva dojilica s njihovim mladima; četrdeset krava i deset junaca; dvadeset magarica i deset magaraca. ");
INSERT INTO hrv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Stado po stado preda svojim slugama. Onda reče svojim slugama: “Idite preda mnom, ali držite razmak među stadima!” ");
INSERT INTO hrv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A prvom izda naredbu rekavši: “Kad te sretne moj brat Ezav pa te upita: 'Čiji si ti? Kamo ideš? Čije je ovo pred tobom?' ");
INSERT INTO hrv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","odgovori: 'Tvoga sluge Jakova; ovo je dar koji šalje svome gospodaru Ezavu; on je tamo za nama.'” ");
INSERT INTO hrv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tako je naredio i drugome, pa trećemu i svima drugima koji su išli za stadima: “Ovo i ovako reci Ezavu kad ga sretneš. ");
INSERT INTO hrv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Još mu dodaj: 'A sluga tvoj Jakov i sam je za nama.'” Mislio je naime: “Ako ga unaprijed udobrostivim darovima, a onda se s njim suočim, možda će mi oprostiti.” ");
INSERT INTO hrv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Tako darovi krenu naprijed, dok je on ostao one noći u taborištu. ");
INSERT INTO hrv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","One noći on ustane, uzme svoje obje žene, obje svoje sluškinje i svoje jedanaestero djece te prijeđe Jabok preko gaza. ");
INSERT INTO hrv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Prebacivši njih na drugu stranu toka, prebaci zatim i ostalo što bijaše njegovo. ");
INSERT INTO hrv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jakov ostane sam. I neki se čovjek rvao s njim dok nije zora svanula. ");
INSERT INTO hrv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Videći da ga ne može svladati, ugane mu bedro pri zglobu, tako da se Jakovu kuk iščašio dok su se rvali. ");
INSERT INTO hrv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Potom reče: “Pusti me jer zora sviće!” Ali on odgovori: “Neću te pustiti dok me ne blagosloviš.” ");
INSERT INTO hrv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nato ga onaj zapita: “Kako ti je ime?” Odgovori: “Jakov.” ");
INSERT INTO hrv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Onaj reče. “Više se nećeš zvati Jakov nego Izrael, jer si se hrabro borio i s Bogom i s ljudima i nadvladao si.” ");
INSERT INTO hrv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Onda zapita Jakov: “Reci mi svoje ime!” Odgovori onaj: “Za moje me ime ne smiješ pitati!” I tu ga blagoslovi. ");
INSERT INTO hrv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Onom mjestu Jakov nadjene ime Penuel jer - reče - “Vidjeh Boga licem u lice, i na životu ostadoh.” ");
INSERT INTO hrv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Sunce je nad njim bilo ogranulo kad je prošao Penuel. Hramao je zbog kuka. ");
INSERT INTO hrv_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Zato Izraelci do današnjeg dana ne jedu kukovnu tetivu što se nalazi na bedrenom zglobu, budući da je Jakovljev bedreni zglob bio iščašen u kukovnoj tetivi. ");
INSERT INTO hrv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakov podiže oči i opazi gdje dolazi Ezav i s njime četiri stotine ljudi. Onda on podijeli svoju djecu među Leu, Rahelu i dvije sluškinje; ");
INSERT INTO hrv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","postavi sluškinje i njihovu djecu na čelo; iza njih Leu i njezinu djecu; a Rahelu i Josipa straga. ");
INSERT INTO hrv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Sam prođe naprijed, nakloni se do zemlje sedam puta dok se ne primače svome bratu. ");
INSERT INTO hrv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ezav mu potrča u susret. Zagrli ga padnuvši mu oko vrata, poljubi ga i zaplaka. ");
INSERT INTO hrv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Onda podiže oči i vidje žene i djecu. “Tko su ovi s tobom?” - zapita. On odgovori: “Djeca kojom je Bog obdario tvoga slugu.” ");
INSERT INTO hrv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Potom naprijed stupe sluškinje sa svojom djecom te se duboko naklone. ");
INSERT INTO hrv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Naprijed stupi i Lea sa svojom djecom te se duboko nakloni. Najposlije stupe naprijed Josip i Rahela te se duboko naklone. ");
INSERT INTO hrv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ezav upita: “Što kaniš sa svom ovom povorkom što sam je sreo?” Odgovori: “Naći naklonost svoga gospodara.” ");
INSERT INTO hrv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ezav odgovori: “Ja imam dosta, brate moj. Neka ostane tebi što je tvoje.” ");
INSERT INTO hrv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","A Jakov reče: “Nemoj tako! Ako sam našao naklonost u tvojim očima, primi dar iz moje ruke; jer meni je, što si me ljubezno primio, kao da gledam lice Božje. ");
INSERT INTO hrv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Zato prihvati moj dar što sam ti ga donio; Bog mi je bio sklon te imam svega.” Kako ga je uporno nagovarao, Ezav prihvati. ");
INSERT INTO hrv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","“Pođimo na put”, reče Ezav, “i ja ću s tobom putovati.” ");
INSERT INTO hrv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ali mu on odvrati: “Zna moj gospodar da su djeca nejaka. Osim toga, valja mi se brinuti o ovcama i kravama koje doje: ako bi se tjerale prebrzo samo jednog dana, sve bi pocrkale. ");
INSERT INTO hrv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Neka moj gospodar ide ispred svoga sluge, a ja ću ići polako, uz korak marve pred sobom i uz korak djece, dok ne stignem k svome gospodaru u Seir.” ");
INSERT INTO hrv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Onda reče Ezav: “Da ti barem ostavim nekoliko ljudi koji se sa mnom nalaze.” Ali on odgovori: “Čemu to? Neka ja samo nađem milost u očima svoga gospodara!” ");
INSERT INTO hrv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tako se Ezav onog dana zaputi natrag u Seir, ");
INSERT INTO hrv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","dok je Jakov otišao u Sukot, gdje sebi sagradi kuću, a svom blagu podigne staje. Stoga je onom mjestu dano ime Sukot. ");
INSERT INTO hrv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Došavši tako iz Padan Arama, Jakov sretno stigne u grad Šekem, koji se nalazi u zemlji kanaanskoj, i postavi svoj šator pred gradom. ");
INSERT INTO hrv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A komad zemlje na kojoj je postavio svoj šator kupi od sinova Hamora, Šekemova oca, za stotinu kesita. ");
INSERT INTO hrv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Tu podiže žrtvenik i nazva ga “El, Bog Izraelov”. ");
INSERT INTO hrv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, kći koju je Lea rodila Jakovu, iziđe da posjeti neke žene onoga kraja. ");
INSERT INTO hrv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Opazi je Hivijac Šekem, sin Hamora, poglavice kraja, pa je pograbi i na silu s njom leže. ");
INSERT INTO hrv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Njegovo srce prione za Dinu, Jakovljevu kćer, i on se u djevojku zaljubi. Nastojao je pridobiti djevojčino srce. ");
INSERT INTO hrv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Šekem je govorio i svom ocu Hamoru: “Onu mi djevojku uzmi za ženu!” ");
INSERT INTO hrv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakov sazna da je Šekem obeščastio njegovu kćer Dinu. Ali kako su njegovi sinovi bili uz blago na polju, Jakov nije poduzimao ništa dok oni ne dođu. ");
INSERT INTO hrv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Uto dođe k Jakovu Šekemov otac Hamor da se s njim sporazumije, ");
INSERT INTO hrv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","upravo kad su se Jakovljevi sinovi vraćali iz polja. Kad su čuli vijest, ljudi su bili ojađeni i vrlo ljuti. Što je Šekem učinio - legavši s Jakovljevom kćeri - u Izraelu je bila sramota. To se nije smjelo trpjeti. ");
INSERT INTO hrv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor im reče. “Moj se sin Šekem svom dušom zaljubio u vašu kćer. Dajte mu je za ženu! ");
INSERT INTO hrv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Oprijateljite se s nama: dajite nam svoje kćeri, a naše kćeri uzimajte sebi! ");
INSERT INTO hrv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Tako možete živjeti među nama; zemlja je pred vama da se naselite, u njoj se slobodno krećete i stječete imovinu!” ");
INSERT INTO hrv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Potom Šekem reče njezinu ocu i njezinoj braći: “Da nađem milost u vašim očima, dat ću vam što zatražite. ");
INSERT INTO hrv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tražite od mene koliko hoćete: sve što god zapitate dat ću, samo mi dajte djevojku za ženu.” ");
INSERT INTO hrv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jakovljevi sinovi odgovore Šekemu i njegovu ocu Hamoru - govorili su s prijevarom jer je obeščastio njihovu sestru Dinu - ");
INSERT INTO hrv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","te im rekoše: “Ne možemo pristati da svoju sestru damo čovjeku koji nije obrezan, jer bi to za nas bila sramota. ");
INSERT INTO hrv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Jedino ćemo je dati ako postanete kao i mi, ako obrežete sve svoje muškarce. ");
INSERT INTO hrv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Onda vam možemo davati svoje kćeri i uzimati vaše sebi, s vama se naseliti i biti jedan rod. ");
INSERT INTO hrv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","A ako ne pristajete na obrezanje, uzet ćemo svoju kćer i otići.” ");
INSERT INTO hrv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamoru i Šekemu, Hamorovu sinu, njihov se zahtjev učini povoljan. ");
INSERT INTO hrv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mladić nije časio da zahtjev izvrši, jer je čeznuo za Jakovljevom kćeri; a bio je najuvaženiji od svih u očevu domu. ");
INSERT INTO hrv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Tako Hamor i njegov sin Šekem dođu u svoje gradsko vijeće i obrate se svojim sugrađanima ovako: ");
INSERT INTO hrv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ovaj je svijet prijazan; neka se među nama u zemlji nasele; neka se po njoj slobodno kreću; ima dosta prostora u zemlji za njih; možemo uzimati njihove kćeri sebi za žene, a njima davati svoje. ");
INSERT INTO hrv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","No ljudi će pristati da među nama žive i s nama budu jedan rod samo ako se svi naši muškarci obrežu kao što su oni obrezani. ");
INSERT INTO hrv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Zar tako ne bi stoka koju su stekli, sve njihovo blago - bilo naše? Pristanimo, pa neka se među nama nasele!” ");
INSERT INTO hrv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Svi odrasli muškarci koji imaju pravo izaći na gradska vrata poslušaše Hamora i njegova sina Šekema, pa bude obrezan svaki muškarac - svaki koji ima pravo izaći na gradska vrata. ");
INSERT INTO hrv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","A trećega dana, dok su oni još bili u bolovima, dva Jakovljeva sina, Šimun i Levi, Dinina braća, pograbe svaki svoj mač i nesmetano dođu u grad te poubijaju sve muškarce. ");
INSERT INTO hrv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Sasijeku mačem Hamora i njegova sina Šekema, uzmu Dinu iz Šekemove kuće i odu. ");
INSERT INTO hrv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ostali Jakovljevi sinovi dođu na ubijene i opustoše grad što je njihova sestra bila obeščašćena. ");
INSERT INTO hrv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Što je bilo krupne i sitne stoke i magaradi, u gradu i u polju, otjeraju; ");
INSERT INTO hrv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","opljačkaju sva njihova dobra, a svu im djecu i žene - sve što je bilo po kućama - odvedu u roblje. ");
INSERT INTO hrv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jakov reče Šimunu i Leviju: “Uveli ste me u nepriliku omrazivši me stanovnicima zemlje, Kanaancima i Perižanima. Ako se ujedine protiv mene i napadnu me, dok je nas ovako malo na broj, istrijebit će me s mojim domom.” ");
INSERT INTO hrv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Oni odgovore: “Zar da prema našoj sestri postupaju kao prema kakvoj bludnici?” ");
INSERT INTO hrv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Bog reče Jakovu: “Ustani, idi gore u Betel te ondje ostani! Načini ondje žrtvenik Bogu koji ti se objavio kad si bježao od svoga brata Ezava!” ");
INSERT INTO hrv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","I Jakov reče svojoj obitelji i svima koji bijahu s njime: “Odbacite tuđe kumire koji se nalaze u vašoj sredini; očistite se i preobucite. ");
INSERT INTO hrv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Idemo gore u Betel; ondje ću načiniti žrtvenik Bogu, koji me uslišao kad sam bio u nevolji i sa mnom bio na putu kojim sam hodio.” ");
INSERT INTO hrv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Oni predaju Jakovu sve tuđe kumire što su ih imali i naušnice što su bile o njihovim ušima, pa ih Jakov zakopa pod hrast kod Šekema. ");
INSERT INTO hrv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kad su se zaputili, strah od Boga spopadne okolišna mjesta, tako da nisu išli u potjeru za Jakovljevim sinovima. ");
INSERT INTO hrv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakov stigne u Luz, to jest Betel, u zemlji kanaanskoj, i sav puk što je bio s njim. ");
INSERT INTO hrv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ondje sagradi žrtvenik i mjesto nazva El Betel, jer mu se ondje Bog objavio kad on bježaše pred svojim bratom Ezavom. ");
INSERT INTO hrv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tada umre Rebekina dojilja Debora te je sahraniše pod Betelom, pod hrastom, koji se otad zove “Tužni hrast”. ");
INSERT INTO hrv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Bog se opet objavi Jakovu kad je stigao iz Padan Arama, te ga blagoslovi. ");
INSERT INTO hrv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Bog mu reče: “Ime ti je Jakov, ali se odsad nećeš zvati Jakov nego će Izrael biti tvoje ime.” Tako ga prozva Izraelom. ");
INSERT INTO hrv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Onda mu Bog reče: “Ja sam El Šadaj - Bog Svesilni! Budi rodan i množi se! Od tebe poteći će narod, mnoštvo naroda, i kraljevi iz tvog će izaći krila. ");
INSERT INTO hrv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Zemlju što je dadoh Abrahamu i Izaku tebi predajem; i potomstvu tvojem poslije tebe zemlju ću ovu dati.” ");
INSERT INTO hrv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","A onda Bog ode od njega gore. ");
INSERT INTO hrv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Na mjestu gdje je Bog s njim govorio Jakov uspravi stup, stup od kamena; na njemu prinese žrtvu i izli ulja. ");
INSERT INTO hrv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","A mjesto gdje mu je Bog govorio Jakov nazva Betel. ");
INSERT INTO hrv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Potom odu iz Betela. Još bijaše malo puta do Efrate, a Rahela se nađe pri porođaju. Napali je teški trudovi. ");
INSERT INTO hrv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Kad su joj porođajni bolovi bili najteži, reče joj babica: “Ne boj se jer ti je i ovo sin!” ");
INSERT INTO hrv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kad se rastavljala s dušom - jer umiraše Rahela - nadjenu sinu ime Ben Oni; ali ga otac prozva Benjamin. ");
INSERT INTO hrv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Tako umrije Rahela. Sahrane je na putu u Efratu, to jest Betlehem. ");
INSERT INTO hrv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","A na njezinu grobu Jakov podigne spomenik - onaj što je na Rahelinu grobu do danas. ");
INSERT INTO hrv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Izrael krenu dalje te razape svoj šator s onu stranu Migdal-Edera. ");
INSERT INTO hrv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Dok je Izrael boravio u onom kraju, ode Ruben i legne s Bilhom, priležnicom svoga oca. Sazna za to Izrael. Izrael je imao dvanaest sinova. ");
INSERT INTO hrv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","S Leom: Rubena, koji je Jakovljev prvorođenac, Šimuna, Levija, Judu, Jisakara i Zebuluna; ");
INSERT INTO hrv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","s Rahelom: Josipa i Benjamina; ");
INSERT INTO hrv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","s Bilhom, Rahelinom sluškinjom: Dana i Naftalija; ");
INSERT INTO hrv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","sa Zilpom, sluškinjom Leinom: Gada i Ašera. To su Jakovljevi sinovi što su mu se rodili u Padan Aramu. ");
INSERT INTO hrv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakov dođe k svome ocu Izaku u Mamru u Kirjat Arbu, to je Hebron - gdje su boravili Abraham i Izak kao pridošlice. ");
INSERT INTO hrv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Kad je Izaku bilo sto i osamdeset godina, umrije. ");
INSERT INTO hrv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Izak izdahne i umre, starac i godinama zasićen, te bude pridružen svojim precima. Sahrane ga njegovi sinovi, Ezav i Jakov. ");
INSERT INTO hrv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ovo su potomci Ezava, koji se zvao i Edom. ");
INSERT INTO hrv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezav je uzeo sebi žene od kanaanskih djevojaka: Adu, kćer Hetita Elona; Oholibamu, kćer Ane, unuku Sibeona Horijca; ");
INSERT INTO hrv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","i Basematu, kćer Jišmaelovu, sestru Nebajotovu. ");
INSERT INTO hrv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada Ezavu rodi Elifaza, a Basemata rodi Reuela, ");
INSERT INTO hrv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama rodi Jeuša, Jalama i Koraha. To su Ezavovi sinovi koji se rodiše u zemlji kanaanskoj. ");
INSERT INTO hrv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ezav uzme svoje žene, svoje sinove, svoje kćeri, svu čeljad svoga doma; svoju stoku - krupnu i sitnu; svu imovinu što ju je namakao u zemlji kanaanskoj, pa ode u zemlju seirsku, daleko od svog brata Jakova. ");
INSERT INTO hrv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Njihov se, naime, posjed jako uvećao te nisu mogli ostati zajedno: kraj u kojem su boravili nije ih mogao izdržavati zbog njihova blaga. ");
INSERT INTO hrv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tako se Ezav - Edom nazvani - naseli u brdskom kraju Seiru. ");
INSERT INTO hrv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ovo je, dakle, potomstvo Ezava, praoca Edomaca, u brdskom kraju Seiru. ");
INSERT INTO hrv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ovo su imena Ezavovih sinova: Elifaz, sin Ezavove žene Ade; Reuel, sin Ezavove žene Basemate. ");
INSERT INTO hrv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazovi su sinovi bili: Teman, Omar, Sefo, Gatam i Kenaz. ");
INSERT INTO hrv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna je bila inoča Ezavova sina Elifaza; ona je Elifazu rodila Amaleka. To su potomci Ezavove žene Ade. ");
INSERT INTO hrv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","A ovo su sinovi Reuelovi: Nahat, Zerah, Šama i Miza. Oni su bili sinovi Ezavove žene Basemate. ");
INSERT INTO hrv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","A ovo su opet sinovi Ezavove žene Oholibame, Anine kćeri, unuke Sibeonove; ona je Ezavu rodila Jeuša, Jalama i Koraha. ");
INSERT INTO hrv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ovo su rodovske glave Ezavovih potomaka. Potomci Ezavova prvorođenca Elifaza: knez Teman, knez Omar, knez Sefo, knez Kenaz, ");
INSERT INTO hrv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","knez Korah, knez Gatam i knez Amalek. To su rodovski glavari Elifazovi u zemlji edomskoj; to su potomci Adini. ");
INSERT INTO hrv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","A ovo su potomci Ezavova sina Reuela: knez Nahat, knez Zerah, knez Šama i knez Miza. To su rodovski glavari Reuelovi u zemlji edomskoj; to su potomci Ezavove žene Basemate. ");
INSERT INTO hrv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","A ovo su potomci Ezavove žene Oholibame: knez Jeuš, knez Jalam i knez Korah. To su rodovski glavari Ezavove žene Oholibame, kćeri Anine. ");
INSERT INTO hrv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","To su bili sinovi Ezava-Edoma, njihovi knezovi. ");
INSERT INTO hrv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","A ovo su sinovi Seira Horijca, žitelji one zemlje: Lotan, Šobal, Sibeon, Ana, ");
INSERT INTO hrv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dišon, Eser i Dišan. To su koljenovići Horijci, sinovi Seirovi, u zemlji edomskoj. ");
INSERT INTO hrv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotanovi sinovi bili su: Hori i Hemam; a sestra Lotanova bila je Timna. ");
INSERT INTO hrv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ovo su bili sinovi Šobalovi: Alvan, Manahat, Ebal, Šefo i Onam. ");
INSERT INTO hrv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sinovi Sibeonovi bijahu Aja i Ana. Ana je onaj koji je našao vruća vrela u pustari dok je čuvao magarad svoga oca Sibeona. ");
INSERT INTO hrv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ovo su bila djeca Ane: sin Dišon i Anina kći Oholibama. ");
INSERT INTO hrv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ovo su bili sinovi Dišonovi: Hemdan, Ešban, Jitran i Keran. ");
INSERT INTO hrv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ovo su bili sinovi Eserovi: Bilhan, Zaavan i Akan. ");
INSERT INTO hrv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","A sinovi Dišanovi bili su: Uz i Aran. ");
INSERT INTO hrv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ovo su knezovi Horijaca: knez Lotan, knez Šobal, knez Sibeon, knez Ana, ");
INSERT INTO hrv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","knez Dišon, knez Eser i knez Dišan. To su bili knezovi Horijaca, glavar za glavarom, u zemlji seirskoj. ");
INSERT INTO hrv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Evo kraljeva koji su kraljevali u edomskoj zemlji prije nego je zavladao kralj sinova Izraelovih. ");
INSERT INTO hrv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beorov sin Bela vladao je u Edomu; njegov se grad zvao Dinhaba. ");
INSERT INTO hrv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kad je umro Bela, na njegovo se mjesto zakraljio Jobab, sin Zeraha iz Bosre. ");
INSERT INTO hrv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kad je umro Jobab, zakraljio se na njegovo mjesto Hušam iz temanske zemlje. ");
INSERT INTO hrv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kad je umro Hušam, zakraljio se na njegovo mjesto Bedadov sin Hadad, koji je potukao Midjance na Moapskom polju. Ime je njegovu gradu bilo Avit. ");
INSERT INTO hrv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kad je umro Hadad, zakraljio se na njegovo mjesto Samla iz Masreke. ");
INSERT INTO hrv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kad je umro Samla, zakraljio se na njegovo mjesto Šaul iz Rehobota na Rijeci. ");
INSERT INTO hrv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kad umrije Šaul, zavlada Baal Hanan, Akborov sin. ");
INSERT INTO hrv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kad je umro Baal Hanan, Akborov sin, vladaše Hadad. Ime je njegovu gradu bilo Pai. Žena mu se zvala Mehetabela. Bila je kći Matredova, iz Me Zahaba. ");
INSERT INTO hrv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ovo su imena Ezavovih knezova s njihovim nazivima po rodovima i smještaju: knez Timna, knez Alva, knez Jetet, ");
INSERT INTO hrv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","knez Oholibama, knez Ela, knez Pinon, ");
INSERT INTO hrv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","knez Kenaz, knez Teman, knez Mibzar, ");
INSERT INTO hrv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","knez Magdiel i knez Iram. To su bili knezovi edomski, prema njihovim naseljima u zemlji koju su zaposjeli. To je Ezav, praotac Edomaca. ");
INSERT INTO hrv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","A Jakov se bijaše nastanio u zemlji gdje je njegov otac boravio kao pridošlica - u zemlji kanaanskoj. ");
INSERT INTO hrv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Evo nasljedstva Jakovljeva. Kao mladić, u dobi od sedamnaest godina, Josip je čuvao stada sa svojom braćom, sinovima Bilhe i Zilpe, koje bijahu žene njegova oca. Josip je ocu svome donosio zle glasove o njima. ");
INSERT INTO hrv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Izrael je volio Josipa više nego ijednog svoga sina jer je bio dijete njegove staračke dobi; i on mu napravi kićenu haljinu. ");
INSERT INTO hrv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kako njegova braća opaze da ga njihov otac voli više od svih drugih svojih sinova, zamrze ga toliko da mu nisu mogli ni prijaznu riječ progovoriti. ");
INSERT INTO hrv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Jednom Josip usni san i kaza ga svojoj braći, a oni ga zbog toga još više zamrze. ");
INSERT INTO hrv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","“Poslušajte”, reče im, “san što sam ga usnio! ");
INSERT INTO hrv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Pomislite! Vezali smo nasred polja snopove, kadli se najednom moj snop uspravi i stade uzgor. Uto se vaši snopovi okupe okolo i duboko se poklone mom snopu.” ");
INSERT INTO hrv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Njegova ga braća upitaše: “Kaniš li nad nama zakraljevati? Hoćeš li nam biti gospodar?” I još ga više zamrze zbog njegova pričanja o snovima. ");
INSERT INTO hrv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Usni on još jedan san te ga ispriča svojoj braći: “Još sam jedan san usnuo. Pazite! Sunce, mjesec i jedanaest zvijezda duboko mi se klanjahu!” ");
INSERT INTO hrv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kad je to ispričao svome ocu, ukori ga otac i reče mu: “Što znači taj san što si ga usnuo? Zar ćemo doći ja, tvoja majka i tvoja braća pa ti se do zemlje klanjati?” ");
INSERT INTO hrv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","I dok su braća od zavisti bila ljuta na nj, njegov je otac razmišljao o svemu. ");
INSERT INTO hrv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Jednom njegova braća odu čuvati očeva stada blizu Šekema. ");
INSERT INTO hrv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Izrael reče Josipu: “Tvoja braća čuvaju stada kod Šekema, pa hajde da te pošaljem k njima.” On mu odgovori: “Dobro, idem.” ");
INSERT INTO hrv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Potom će mu otac: “Hajde i vidi kako su ti braća i stoka pa mi javi.” Tako ga otpremi iz doline Hebrona, i on stigne u Šekem. ");
INSERT INTO hrv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Neki čovjek nađe ga gdje luta poljem pa ga upita: “Što tražiš?” ");
INSERT INTO hrv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“Tražim braću”, odgovori. “Možeš li mi kazati gdje čuvaju stada?” ");
INSERT INTO hrv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","A čovjek reče: “Odavde su otišli. Čuo sam ih gdje govore: 'Hajdemo u Dotan.'” Tako Josip ode za svojom braćom i nađe ih u Dotanu. ");
INSERT INTO hrv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Oni ga opaze izdaleka; prije nego im se približio, počnu se dogovarati da ga ubiju. ");
INSERT INTO hrv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","I jedan drugom reče: “Eno stiže onaj sanjar! ");
INSERT INTO hrv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Hajde da ga sad ubijemo i bacimo u kakvu čatrnju! Možemo kazati da ga je proždrla divlja zvijer. Vidjet ćemo što će biti od njegovih snova!” ");
INSERT INTO hrv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ali kad je to čuo Ruben, pokuša da ga izbavi iz njihovih šaka. I reče: “Nemojmo oduzimati njegova života! ");
INSERT INTO hrv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ne prolijevajte krvi” - dalje je govorio Ruben. “Bacite ga u čatrnju u pustari; ali ne dižite na nj ruke!” Htio ga je tako izbaviti iz njihovih šaka i odvesti ocu. ");
INSERT INTO hrv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ali kad je Josip stigao braći, oni s Josipa svuku njegovu haljinu, haljinu kićenu što je bila na njemu; ");
INSERT INTO hrv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","pograbe ga i bace u čatrnju. Čatrnja je bila prazna; nije bilo u njoj vode. ");
INSERT INTO hrv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Potom sjednu da ručaju. Kako podignu svoje oči, opaze povorku Jišmaelaca gdje dolazi iz Gileada. Deve su im nosile mirodije, balzam i mirisavu smolu da ih preprodaju u Egipat. ");
INSERT INTO hrv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tada reče Juda svojoj braći: “Što ćemo postići ako ubijemo svog brata a krv njegovu sakrijemo? ");
INSERT INTO hrv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Hajde da ga prodamo Jišmaelcima; ali ne dižimo na nj ruke. TÓa on je naš brat, naše meso.” Braća ga poslušaju. ");
INSERT INTO hrv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Uto naiđu ljudi, midjanski trgovci. Braća izvuku Josipa iz čatrnje i prodaju ga za dvadeset srebrnika Jišmaelcima, a oni Josipa dovedu u Egipat. ");
INSERT INTO hrv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kad se Ruben vratio k čatrnji i vidio da Josipa nema u čatrnji, razdere svoju odjeću. ");
INSERT INTO hrv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","A kad se vratio svojoj braći, povika: “Dječaka nema! Kamo ću ja sad?” ");
INSERT INTO hrv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","A oni uzmu Josipovu haljinu, zakolju jedno kozle i haljinu zamoče u krv. ");
INSERT INTO hrv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kićenu haljinu otpreme ocu i poruče: “Ovo smo našli; gledaj je li ovo haljina tvoga sina ili nije.” ");
INSERT INTO hrv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Prepozna je on pa reče: “Haljina je moga sina! Divlja ga je zvijer rastrgla! Na komade je Josip rastrgan!” ");
INSERT INTO hrv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","I razdere Jakov svoje haljine, stavi pokorničku kostrijet oko bokova i dugo vremena oplakivaše svoga sina. ");
INSERT INTO hrv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Svi su ga njegovi sinovi i sve njegove kćeri nastojali utješiti, ali se on ne mogaše utješiti. Govorio je: “Ne, sići ću k svome sinu u Šeol tugujući!” Tako ga je oplakivao njegov otac. ");
INSERT INTO hrv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","A Midjanci ga prodaju u Egipat Potifaru, dvoraninu faraonovu, zapovjedniku straže. ");
INSERT INTO hrv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Otprilike u to vrijeme Juda ode od svoje braće te okrenu nekom Adulamcu komu ime bijaše Hira. ");
INSERT INTO hrv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Tu Juda zapazi kćer jednog Kanaanca - zvao se Šua - i njome se oženi. Priđe njoj ");
INSERT INTO hrv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","te ona zače i rodi sina, komu dade ime Er. ");
INSERT INTO hrv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Opet ona zače, rodi sina i dade mu ime Onan. ");
INSERT INTO hrv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Još jednog sina rodi te mu nadjene ime Šela. Nalazila se u Kezibu kad je njega rodila. ");
INSERT INTO hrv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda oženi svoga prvorođenca Era djevojkom kojoj bijaše ime Tamara. ");
INSERT INTO hrv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ali Judin prvorođenac Er uvrijedi Jahvu i Jahve ga pogubi. ");
INSERT INTO hrv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Tada reče Juda Onanu: “Priđi k udovici svoga brata, izvrši prema njoj djeversku dužnost i tako očuvaj lozu svome bratu!” ");
INSERT INTO hrv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ali Onan, znajući da se sjeme neće računati kao njegovo, ispuštaše ga na zemlju kad god bi prišao bratovoj udovici, tako da ne dade potomstva svome bratu. ");
INSERT INTO hrv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","To što je činio uvrijedilo je Jahvu, pa i njega pogubi. ");
INSERT INTO hrv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Onda Juda reče svojoj nevjesti Tamari: “Ostani kao udovica u domu svoga oca dok poodraste moj sin Šela.” Bojao se, naime, da bi i on mogao umrijeti kao i njegova braća. I tako Tamara ode da živi u očevu domu. ");
INSERT INTO hrv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Dugo vremena poslije toga umre Šuina kći, Judina žena. Kad je prošlo vrijeme žalosti, Juda ode, zajedno sa svojim prijateljem Adulamcem Hirom, u Timnu da striže svoje ovce. ");
INSERT INTO hrv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Obavijeste Tamaru: “Eno ti je svekar”, rekoše joj, “na putu u Timnu da striže ovce.” ");
INSERT INTO hrv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ona svuče udovičko ruho, navuče koprenu i zamota se pa sjede na ulazu u Enajim, što je na putu k Timni. Vidjela je, naime, da je Šela odrastao, ali nju još ne udaše za nj. ");
INSERT INTO hrv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kad je Juda opazi, pomisli da je bludnica, jer je bila pokrila lice. ");
INSERT INTO hrv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Svrati se on k njoj i reče: “Daj da ti priđem!” Nije znao da mu je nevjesta. A ona odgovori: “Što ćeš mi dati da uđeš k meni?” ");
INSERT INTO hrv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“Spremit ću ti jedno kozle od svoga stada”, odgovori. “Treba da ostaviš jamčevinu dok ga ne pošalješ.” ");
INSERT INTO hrv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","A on zapita: “Kakvu jamčevinu da ti ostavim?” Ona odgovori: “Svoj pečatnjak o vrpci i štap što ti je u ruci.” Dade joj jedno i drugo, a onda priđe k njoj i ona po njem zače. ");
INSERT INTO hrv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Potom ona ustade i ode; skide sa sebe koprenu i opet se odjenu u svoje udovičko ruho. ");
INSERT INTO hrv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Uto Juda pošalje kozle po svom prijatelju Adulamcu da iskupi jamčevinu iz ruku žene, ali je nije mogao naći. ");
INSERT INTO hrv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Upita ljude u mjestu: “Gdje je bludnica što se nalazila uz put u Enajim?” Oni mu odgovore: “Ovdje nije nikad bilo bludnice.” ");
INSERT INTO hrv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tako se on vrati k Judi pa reče: “Nisam je mogao naći. Osim toga, ljudi mi u mjestu rekoše da ondje nije nikad bilo bludnice.” ");
INSERT INTO hrv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Onda reče Juda: “Da ne ostanemo za ruglo, neka ih drži! Slao sam joj, eto, ovo kozle, ali je ti nisi našao.” ");
INSERT INTO hrv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Otprilike poslije tri mjeseca donesoše vijest Judi: “Tvoja nevjesta Tamara odala se bludništvu; čak je u bludničenju i začela.” “Izvedite je”, naredi Juda, “pa neka se spali!” ");
INSERT INTO hrv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Dok su je izvodili, ona poruči svekru: “Začela sam po čovjeku čije je ovo.” Još doda: “Vidi čiji je ovaj pečatnjak o vrpci i ovaj štap!” ");
INSERT INTO hrv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda ih prepozna pa reče: “Ona je pravednija nego ja, koji joj nisam dao svoga sina Šelu.” Ali više s njom nije imao posla. ");
INSERT INTO hrv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kad joj je došlo vrijeme da rodi, pokaže se da nosi blizance. ");
INSERT INTO hrv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Dok je rađala, jedan od njih pruži ruku van. Nato babica priveže za njegovu ruku crven konac govoreći: “Ovaj je izišao prvi.” ");
INSERT INTO hrv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ali baš tada on uvuče ruku te iziđe njegov brat. A ona reče: “Kakav li proder napravi!” Stoga mu nadjenu ime Peres. ");
INSERT INTO hrv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Poslije iziđe njegov brat koji je oko ruke imao crveni konac. Njemu dadoše ime Zerah. ");
INSERT INTO hrv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josipa dovedoše u Egipat. Tu ga od Jišmaelaca koji su ga onamo doveli kupi Egipćanin Potifar, dvoranin faraonov i zapovjednik njegove tjelesne straže. ");
INSERT INTO hrv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Jahve je bio s Josipom, zato je u svemu imao sreću: Egipćanin ga uzme k sebi u kuću. ");
INSERT INTO hrv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Vidje njegov gospodar da je Jahve s njim i da svemu što mu ruka poduzme Jahve daje uspjeh; ");
INSERT INTO hrv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","zavolje on Josipa, uze ga za dvoranina i postavi ga za upravitelja svoga doma i povjeri mu sav svoj imetak. ");
INSERT INTO hrv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","I otkad mu je povjerio upravu svoga doma i svega svog imetka, blagoslovi Jahve dom Egipćaninov zbog Josipa: blagoslov Jahvin bijaše na svemu što je imao - u kući i u polju. ");
INSERT INTO hrv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","I tako sve svoje prepusti brizi Josipovoj te se više ni za što nije brinuo, osim za jelo što je jeo. A Josip je bio mladić stasit i naočit. ");
INSERT INTO hrv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Poslije nekog vremena žena njegova gospodara zagleda se u Josipa i reče mu: “Legni sa mnom!” ");
INSERT INTO hrv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","On se oprije i reče ženi svoga gospodara: “Gledaj! Otkako sam ja ovdje, moj se gospodar ne brine ni za što u kući; sve što ima meni je povjerio. ");
INSERT INTO hrv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","On u ovoj kući nema više vlasti negoli ja i ništa mi ne krati, osim tebe, jer si njegova žena. Pa kako bih ja mogao učiniti tako veliku opačinu i sagriješiti protiv Boga!” ");
INSERT INTO hrv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Iako je Josipa salijetala iz dana u dan, on nije pristajao da uz nju legne; nije joj prilazio. ");
INSERT INTO hrv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Jednog dana Josip uđe u kuću na posao. Kako nikog od služinčadi nije bilo u kući, ");
INSERT INTO hrv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ona ga uhvati za ogrtač i reče: “Legni sa mnom!” Ali on ostavi svoj ogrtač u njezinoj ruci, otrže se i pobježe van. ");
INSERT INTO hrv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Vidjevši ona da je u njezinoj ruci ostavio ogrtač i pobjegao van, ");
INSERT INTO hrv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","zovne svoje sluge te im reče: “Gledajte! Trebalo je da nam dovede jednog Hebrejca da se s nama poigrava. Taj k meni dođe da sa mnom legne, ali sam ja na sav glas zaviknula. ");
INSERT INTO hrv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","A čim je čuo kako vičem, ostavi svoj ogrtač pokraj mene i pobježe van.” ");
INSERT INTO hrv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Uza se je držala njegov ogrtač dok mu je gospodar došao kući. ");
INSERT INTO hrv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Onda i njemu kaza istu priču: “Onaj sluga Hebrejac koga si nam doveo dođe k meni da sa mnom ljubaka! ");
INSERT INTO hrv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ali čim je čuo kako vičem, ostavi svoj ogrtač pokraj mene i pobježe van.” ");
INSERT INTO hrv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kad je njegov gospodar čuo pripovijest svoje žene koja reče: “Eto, tako sa mnom tvoj sluga”, razgnjevi se. ");
INSERT INTO hrv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Gospodar pograbi Josipa i baci ga u tamnicu - tamo gdje su bili zatvoreni kraljevi utamničenici. I osta u tamnici. ");
INSERT INTO hrv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ali je Jahve bio s njim, iskaza naklonost Josipu te on nađe milost u očima upravitelja tamnice. ");
INSERT INTO hrv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Tako upravitelj tamnice preda u Josipove ruke sve utamničenike koji su se nalazili u tamnici; i ondje se ništa nije radilo bez njega. ");
INSERT INTO hrv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Budući da je Jahve bio s njim, upravitelj tamnice nije nadgledao ništa što je Josipu bilo povjereno: Jahve bijaše s njim, i što god bi poduzeo, Jahve bi to okrunio uspjehom. ");
INSERT INTO hrv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Poslije toga peharnik se i pekar egipatskog kralja ogriješe o svoga gospodara, kralja egipatskog. ");
INSERT INTO hrv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraon se razljuti na svoja dva dvoranina, glavnog peharnika i glavnog pekara, ");
INSERT INTO hrv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","te ih stavi u zatvor, u zgradu zapovjednika tjelesne straže - u istu tamnicu gdje je i Josip bio zatvoren. ");
INSERT INTO hrv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Zapovjednik tjelesne straže odredi Josipa da ih poslužuje. Pošto su proveli u zatvoru neko vrijeme, ");
INSERT INTO hrv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","obojica njih - peharnik i pekar egipatskog kralja, utamničenici - usnu san jedne te iste noći. Svaki je usnuo svoj san; i svaki je san imao svoje značenje. ");
INSERT INTO hrv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kad je Josip ujutro došao k njima, opazi da su neraspoloženi. ");
INSERT INTO hrv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Upita faraonove dvorane koji su bili s njim u zatvoru u zgradi njegova gospodara: “Zašto ste danas tako potišteni?” ");
INSERT INTO hrv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Odgovore mu: “Sne smo usnuli, ali nikog nema da nam ih protumači.” Josip im reče: “Zar tumačenje ne spada na Boga? Dajte, pričajte mi!” ");
INSERT INTO hrv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Onda je glavni peharnik ispripovjedio Josipu svoj san: “Sanjao sam da je preda mnom lozov trs. ");
INSERT INTO hrv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Na trsu bile tri mladice. I tek što je propupao, procvjeta i na njegovim grozdovima sazru bobe. ");
INSERT INTO hrv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kako sam u ruci držao faraonov pehar, uzmem grožđa, istiještim ga u faraonov pehar, a onda stavim pehar u faraonovu ruku.” ");
INSERT INTO hrv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josip mu reče: “Ovo ti je značenje: tri mladice tri su dana. ");
INSERT INTO hrv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Poslije tri dana faraon će te pomilovati i vratiti na tvoje mjesto; opet ćeš stavljati pehar faraonu u ruku, kao i prije, dok si mu bio peharnik. ");
INSERT INTO hrv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kada ti bude opet dobro, sjeti se da sam i ja bio s tobom, pa mi učini ovu uslugu: spomeni me faraonu i pokušaj me izvesti iz ove kuće. ");
INSERT INTO hrv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Jer, zbilja, bio sam silom odveden iz zemlje Hebreja; ni ovdje nisam ništa skrivio, a baciše me u tamnicu.” ");
INSERT INTO hrv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kad je glavni pekar vidio kako je Josip dao dobro tumačenje, reče mu: “Usnuh da su mi na glavi tri bijele košare. ");
INSERT INTO hrv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","U najgornjoj bilo svakovrsna peciva što ga pekar pripravlja faraonu, ali su ptice jele iz košare povrh moje glave.” ");
INSERT INTO hrv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josip odgovori: “Ovo je značenje: tri košare tri su dana. ");
INSERT INTO hrv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Poslije tri dana faraon će uzdići tvoju glavu i o drvo te objesiti te će ptice jesti meso s tebe.” ");
INSERT INTO hrv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","I zaista, trećega dana, kad je faraon priredio gozbu za sve svoje službenike - bio mu je rođendan - iz sredine svojih službenika izluči glavnog peharnika i glavnog pekara. ");
INSERT INTO hrv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Vrati glavnog peharnika u peharničku službu te je i dalje stavljao pehar u faraonovu ruku, ");
INSERT INTO hrv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","a glavnog pekara objesi, kako je Josip protumačio. ");
INSERT INTO hrv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ipak se glavni peharnik nije sjetio Josipa - zaboravio je na nj. ");
INSERT INTO hrv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Poslije dvije godine usnu faraon da stoji pokraj Nila. ");
INSERT INTO hrv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Iz Nila iziđe sedam krava, lijepih i debelih; pasle su po šašu. ");
INSERT INTO hrv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ali odmah poslije njih iz Nila iziđe sedam drugih krava, ružnih i mršavih, te stanu uz one krave na obali Nila. ");
INSERT INTO hrv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ružne i mršave krave požderu ono sedam lijepih i pretilih, i uto se faraon probudi. ");
INSERT INTO hrv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Opet zaspi te usnu drugi san: sedam punih i jedrih klasova izraste na jednoj stabljici. ");
INSERT INTO hrv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ali, eto, poslije njih uzraste sedam klasova šturih, istočnjakom opaljenih. ");
INSERT INTO hrv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Šturi klasovi proždru sedam jedrih i punih klasova. I faraon se probudi, i gle: bio je to san. ");
INSERT INTO hrv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ujutro faraon bijaše uznemiren u duši, pa pozva sve čarobnjake i sve mudrace egipatske: ispriča im faraon svoje sne, ali mu ih nitko nije mogao protumačiti. ");
INSERT INTO hrv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Onda progovori faraonov glavni peharnik: “Moram danas spomenuti jedan svoj propust. ");
INSERT INTO hrv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Jednom, kad se faraon razljutio na svoje službenike, mene i glavnog pekara stavio je u zatvor u zgradi glavnog upravitelja. ");
INSERT INTO hrv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Usnusmo san iste noći, i ja i on, ali je svaki od nas usnuo san drugog značenja. ");
INSERT INTO hrv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Onda je s nama bio neki mladi Hebrej, sluga zapovjednika straže. Ispričasmo njemu svoje sne, a on nam ih protumači: kaza svakom značenje njegova sna. ");
INSERT INTO hrv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kako nam ih je protumačio, tako nam se i dogodilo: mene vratiše na moje mjesto, a onoga objesiše.” ");
INSERT INTO hrv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Faraon odmah pošalje po Josipa; izvuku ga brže-bolje iz tamnice; ošišaju mu kosu, obuku novo odijelo i on stupi pred faraona. ");
INSERT INTO hrv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Onda faraon reče Josipu: “Usnuo sam san, a nitko ga ne može protumačiti. Čuo sam o tebi da možeš protumačiti san čim ga čuješ.” ");
INSERT INTO hrv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","“Ništa ja ne mogu”, odgovori Josip faraonu, “nego će Bog dati pravi odgovor faraonu.” ");
INSERT INTO hrv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Onda je faraon pripovjedao Josipu: “U svom snu stojim na obali Nila. ");
INSERT INTO hrv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","I gle! Iz Nila iziđe sedam debelih i lijepih krava. Pasle su po šašu. ");
INSERT INTO hrv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Poslije njih izađe drugih sedam krava. Bile su mršave, vrlo ružne i koštunjave. Još nikad ne vidjeh onako ružnih krava u svoj zemlji egipatskoj! ");
INSERT INTO hrv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","I sedam mršavih i ružnih krava proždru prvih sedam debelih krava. ");
INSERT INTO hrv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pa iako su ih progutale, nije se vidjelo da im je što u trbuhu: bile su ružne kao i prije. Uto se probudim. ");
INSERT INTO hrv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Zatim sam u snu vidio kako na jednoj stabljici uzraste sedam punih i lijepih klasova. ");
INSERT INTO hrv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ali poslije njih uzraste sedam klasova zgrčenih, šturih, istočnjakom opaljenih. ");
INSERT INTO hrv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","I šturi klasovi proždru sedam jedrih klasova. Kazao sam ovo i vračarima, ali nema nikoga da mi razjasni.” ");
INSERT INTO hrv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Onda Josip reče faraonu: “Faraonov je san samo jedan: Bog javlja faraonu što kani učiniti. ");
INSERT INTO hrv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sedam lijepih krava, to je sedam godina; sedam lijepih klasova opet je sedam godina. Tako je samo jedan san. ");
INSERT INTO hrv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sedam mršavih i ružnih krava poslije njih, a tako i sedam praznih, istočnjakom opaljenih klasova, označuje sedam gladnih godina. ");
INSERT INTO hrv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","To je ono što sam već faraonu rekao: Bog objavljuje faraonu što kani učiniti. ");
INSERT INTO hrv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Dolazi, evo, sedam godina velikog obilja svoj zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","A poslije njih nastat će sedam gladnih godina, kada će se zaboraviti sve obilje u zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kako glad bude harala zemljom, neće se ni znati da je u zemlji bilo obilje - zbog gladi koja će doći - jer će biti vrlo velika. ");
INSERT INTO hrv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","A što se faraonov san ponovio, znači da se Bog na to zaista odlučio i da će to uskoro provesti. ");
INSERT INTO hrv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Zato neka faraon izabere sposobna i mudra čovjeka te ga postavi nad zemljom egipatskom. ");
INSERT INTO hrv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Nadalje, neka se faraon pobrine da postavi nadglednika u zemlji koji će kÓupiti petinu sve žetve u zemlji egipatskoj za sedam godina obilja. ");
INSERT INTO hrv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Neka skupljaju od svakog žita za sedam dobrih godina što dolaze; neka s ovlaštenjem faraonovim sabiru žito za hranu i pohranjuju ga po gradovima. ");
INSERT INTO hrv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Neka zalihe služe za hranu u zemlji za sedam godina gladi što će snaći zemlju egipatsku, tako da za gladi zemlja ne propadne.” ");
INSERT INTO hrv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Svidje se odgovor faraonu i svim njegovim službenicima. ");
INSERT INTO hrv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Zato faraon reče svojim službenicima: “Zar bismo mogli naći drugoga kao što je on, čovjeka koji bi bio tako obdaren duhom Božjim?” ");
INSERT INTO hrv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","A onda faraon reče Josipu: “Otkako je sve to Bog tebi otkrio, nikoga nema sposobna i mudra kao što si ti. ");
INSERT INTO hrv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ti ćeš biti upravitelj moga dvora: sav će se moj narod pokoravati tvojim naredbama. Jedino prijestoljem ja ću biti veći od tebe. ");
INSERT INTO hrv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Postavljam te, evo,” reče faraon Josipu, “nad svom zemljom egipatskom.” ");
INSERT INTO hrv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Poslije toga skine faraon sa svoje ruke pečatni prsten i stavi ga Josipu na ruku. Zatim zaodjene Josipa odjećom od najljepše tkanine, a o vrat mu objesi zlatan lanac. ");
INSERT INTO hrv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Vozio se on u kolima kao njegov zamjenik, a pred njim klicahu: “Abrek! Na koljena!” Tako ga postavi nad svu zemlju egipatsku. ");
INSERT INTO hrv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Još faraon reče Josipu: “Premda sam ja faraon, neće nitko dići svoje ruke ni noge bez tvog odobrenja u svoj zemlji egipatskoj.” ");
INSERT INTO hrv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faraon nazva Josipa “Safenat Paneah”, a za ženu mu dade Asenatu, kćer Poti-Fere, svećenika u Onu. I Josip postade poznat po zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josipu je bilo trideset godina kad je stupio u službu faraona, kralja egipatskog. A otišavši Josip ispred faraona, putovao je po svoj zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Za sedam rodnih godina zemlja je rađala u obilju; ");
INSERT INTO hrv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","on je - u tih sedam godina što ih je egipatska zemlja uživala - kÓupio od različite ljetine i hranu pohranjivao u gradove, smještajući u svakom gradu urod iz okolnih polja. ");
INSERT INTO hrv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tako Josip nagomila mnogo žita, kao pijeska u moru, pa ga prestade i mjeriti jer mu mjere ne bijaše. ");
INSERT INTO hrv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Dok još ne nasta gladna godina, Josip imade dva sina koje mu rodi Asenata, kći Poti-Fere, svećenika u Onu. ");
INSERT INTO hrv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Prvorođencu Josip nadjenu ime Manaše, “jer Bog je”, reče, “dao te sam zaboravio svoje teškoće i svoj očinski dom.” ");
INSERT INTO hrv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Drugomu nadjenu ime Efrajim, “jer Bog me”, reče, “učinio rodnim u zemlji moje nevolje.” ");
INSERT INTO hrv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Sedam godina obilja koje je uživala zemlja egipatska dođe kraju, ");
INSERT INTO hrv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","a primače se sedam gladnih godina, kako je Josip prorekao. U svim zemljama bijaše glad, a u svoj zemlji egipatskoj bijaše kruha. ");
INSERT INTO hrv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","A kad je i sva zemlja egipatska osjetila glad, puk zavapi faraonu za kruh; a faraon reče Egipćanima: “Idite k Josipu i što god vam rekne, činite!” ");
INSERT INTO hrv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kad se glad proširi po svoj zemlji, Josip rastvori skladišta te je Egipćane opskrbljivao žitom, jer je glad postala žestoka i u zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Sav je svijet išao u Egipat k Josipu da kupuje žita, jer je strašna glad vladala po svem svijetu. ");
INSERT INTO hrv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kad je Jakov čuo da u Egiptu ima žita, reče svojim sinovima: “Što tu zurite jedan u drugoga? ");
INSERT INTO hrv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Čujem da ima žita u Egiptu. Otiđite dolje te nam ga odande nabavite da ostanemo na životu i ne pomremo.” ");
INSERT INTO hrv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tako desetero Josipove braće siđe da nabavi žita iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Benjamina, Josipova pravog brata, Jakov ne posla s ostalima. “Da ga ne bi zadesila kakva nesreća”, govorio je. ");
INSERT INTO hrv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Među onima koji su išli nabavljati žito, jer u zemlji kanaanskoj vladaše glad, bijahu i sinovi Izraelovi. ");
INSERT INTO hrv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Josip je bio namjesnik u zemlji; on je dijelio žito svemu svijetu. Dođu tako i Josipova braća i poklone mu se licem do zemlje. ");
INSERT INTO hrv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Josip prepozna braću čim ih ugleda, ali se prema njima vladao kao stranac i oštro im govorio. Zapita ih: “Odakle dolazite?” Odgovore: “Iz zemlje kanaanske došli smo da kupimo hrane.” ");
INSERT INTO hrv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iako je Josip prepoznao svoju braću, oni njega nisu prepoznali. ");
INSERT INTO hrv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Josip se sjeti snova što ih je o njima sanjao. I reče im: “Vi ste uhode! Došli ste da izvidite slaba mjesta ove zemlje.” ");
INSERT INTO hrv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Oni mu odgovore: “Ne, gospodaru! Tvoje su sluge došle da nabave hrane. ");
INSERT INTO hrv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Svi smo sinovi jednog oca; pošteni smo ljudi; sluge tvoje nikad nisu bile uhode.” ");
INSERT INTO hrv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","On će im opet: “Ne, nego ste došli da izvidite slaba mjesta ove zemlje.” ");
INSERT INTO hrv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nato oni uzvrate: “Nas, tvojih slugu, bijaše dvanaestero braće - sinovi jednog oca, u zemlji kanaanskoj; najmlađi je sad s ocem, a jednoga više nema.” ");
INSERT INTO hrv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","No Josip im dobaci: “Onako kako sam vam već rekao: vi ste uhode! ");
INSERT INTO hrv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ovako ću vas iskušati: odavde, tako mi faraona, nećete izići ako vaš najmlađi brat ne dođe ovamo! ");
INSERT INTO hrv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Pošaljite jednoga između sebe da vam dovede brata, a vi ostali u zatvor! Tako ću iskušati vaše riječi i vidjeti je li u vas istina ili nije. Inače, tako mi faraona, vi ste uhode!” ");
INSERT INTO hrv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Potom ih baci u zatvor na tri dana. ");
INSERT INTO hrv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Treći im dan reče Josip: “Izvršite to, i ostat ćete na životu, jer sam ja čovjek bogobojazan. ");
INSERT INTO hrv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ako ste pošteni, neka jedan od vas ostane u zatvoru, a vi ostali idite i nosite žito svojim izgladnjelim domovima. ");
INSERT INTO hrv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Poslije toga dovedite mi svoga najmlađeg brata, tako da se obistine vaše riječi te da ne izginete.” Oni pristanu. ");
INSERT INTO hrv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Zatim je jedan drugom govorio : “Jao nama! Stiže nas kazna zbog našega brata; gledali smo njegovu muku dok nas je molio za milost, ali ga nismo uslišali. Stoga nas je ova nevolja snašla.” ");
INSERT INTO hrv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben im odvrati: “Zar vam nisam govorio: Ne ogrešujte se o mladića! Ali vi niste slušali. Sad se traži račun za njegovu krv.” ");
INSERT INTO hrv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nisu znali da ih Josip razumije, jer su se s njim razgovarali preko tumača. ");
INSERT INTO hrv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","On se od njih udalji te zaplaka. Opet se vrati i razgovaraše s njima. Onda izdvoji Šimuna između njih i naredi da bude svezan na njihove oči. ");
INSERT INTO hrv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Potom Josip zapovjedi da im vreće napune žitom; da svakome njegov novac metnu u vreću i da im daju poputninu. Tako im učine. ");
INSERT INTO hrv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Tada oni natovare žito na svoje magarce i krenu odande. ");
INSERT INTO hrv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kad na prenoćištu jedan od njih otvori svoju vreću da nahrani magarca, opazi svoj novac ozgo u vreći. ");
INSERT INTO hrv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“Moj je novac vraćen!” - povika braći. - “Evo ga u mojoj vreći!” Zadrhta srce u njima. Zgledaše se, uplašeni, i rekoše: “Što nam ovo Bog uradi!” ");
INSERT INTO hrv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Došavši k svome ocu Jakovu u zemlju kanaansku, kazaše mu sve što ih je snašlo. ");
INSERT INTO hrv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Čovjek koji je gospodar one zemlje”, rekoše, “oštro nam je govorio i optužio nas kao uhode. ");
INSERT INTO hrv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pošteni smo ljudi, kazasmo mu, i nikad nismo bili uhode. ");
INSERT INTO hrv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Bilo nas je dvanaestero braće, sinovi istog oca, ali jednoga više nema, dok se najmlađi sad nalazi s našim ocem u zemlji kanaanskoj. ");
INSERT INTO hrv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ali čovjek koji je gospodar one zemlje reče nam: 'Ovim ću doznati da ste pošteni ljudi: ostavite jednoga brata kod mene, a vi ostali uzmite što vam treba za izgladnjele domove, pa idite. ");
INSERT INTO hrv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Onda mi dovedite svoga najmlađeg brata, tako da znam da niste uhode, nego pošteni ljudi. Poslije toga vratit ću vam vašeg brata, i vi ćete se moći slobodno kretati u ovoj zemlji.'” ");
INSERT INTO hrv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kako su praznili svoje vreće, svaki nađe u vreći svoju kesu. Opazivši to, zapadoše u strah - i oni i njihov otac. ");
INSERT INTO hrv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","“Mene vi ostavljate bez djece!” - reče im njihov otac. - “Josipa je nestalo, Šimuna nema, a sad biste odveli i Benjamina. Sve se to na me svaljuje!” ");
INSERT INTO hrv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Onda Ruben reče svome ocu: “Ubij moja dva sina ako ti ga ja natrag ne dovedem! Predaj ga u moje ruke, i ja ću ti ga vratiti!” ");
INSERT INTO hrv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","“Moj sin neće s vama!” - uzvrati on. - “Njegov je pravi brat već mrtav, a on je ostao sam. Ako bi ga na putu na koji ćete poći snašla nesreća, u tuzi biste otpravili moju sijedu glavu dolje u Šeol.” ");
INSERT INTO hrv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Strašna glad pritisla zemlju. ");
INSERT INTO hrv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kad su pojeli hranu koju bijahu donijeli iz Egipta, njihov im otac reče: “Idite opet i nabavite nam malo hrane.” ");
INSERT INTO hrv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Nato će mu Juda: “Onaj nam je čovjek jasno rekao: 'Ne smijete preda me ako vaš brat ne bude s vama.' ");
INSERT INTO hrv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ako si, dakle, voljan s nama poslati našega brata, mi ćemo otići dolje i kupit ćemo ti žita. ");
INSERT INTO hrv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ali ako njega ne pustiš s nama, onda mi tamo i ne idemo, jer nam je onaj zaprijetio: 'Ne smijete preda me ako vaš brat ne bude s vama.'” ");
INSERT INTO hrv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","“Zašto ste mi”, zapita Izrael, “nanijeli jad rekavši onom čovjeku da imate još jednoga brata?” ");
INSERT INTO hrv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Oni odgovore: “Čovjek nas je neprestano zapitkivao o nama i o našoj obitelji: 'Je li vam još živ otac? Imate li još kojega brata?' Mi smo mu odgovarali na pitanja. Kako smo mogli znati da će reći : 'Dovedite svoga brata!'” ");
INSERT INTO hrv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Potom Juda reče svome ocu Izraelu: “Pusti dječaka sa mnom pa da se dignemo i krenemo; tako ćemo preživjeti, a ne pomrijeti, i mi, i ti, i naša djeca. ");
INSERT INTO hrv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ja za nj jamčim; mene drži odgovornim za nj. Ako ga tebi ne vratim i preda te ga ne dovedem, bit ću ti kriv svega vijeka. ");
INSERT INTO hrv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","TÓa da nismo toliko oklijevali, mogli smo se već i dvaput vratiti.” ");
INSERT INTO hrv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Njihov otac Izrael reče im: “Kad je tako, neka bude, ali učinite ovo: metnite u torbe najbiranijih proizvoda ove zemlje i ponesite na dar onom čovjeku: nešto balzama, nešto meda i mirodija, mirisne smole, pa lješnjaka i badema. ");
INSERT INTO hrv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Sa sobom uzmite dvostruko novaca, jer treba vratiti novac koji ste našli u grlima svojih vreća. Možda je ono bila zabuna. ");
INSERT INTO hrv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Uzmite svoga brata pa se opet zaputite onom čovjeku. ");
INSERT INTO hrv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Neka Bog Svemogući, El Šadaj, potakne onog čovjeka na milosrđe prema nama te vam pusti i drugoga brata i Benjamina. A ja, moram li bez djece ostati, neka ostanem.” ");
INSERT INTO hrv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Uzmu ljudi darove; uzmu sa sobom dvostruko novaca, povedu Benjamina te siđu u Egipat i stupe pred Josipa. ");
INSERT INTO hrv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kad Josip ugleda s njima Benjamina, reče upravitelju svoga kućanstva: “Odvedi ljude u kuću, zakolji jedno živinče i pripremi, jer će ovi ljudi blagovati sa mnom o podne!” ");
INSERT INTO hrv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Čovjek učini kako je Josip rekao i povede ljude u Josipov dom. ");
INSERT INTO hrv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ljudi se pobojaše kad su bili povedeni u dom Josipov te rekoše: “Zbog novca koji se našao u našim vrećama prvi put vode nas unutra tako da nas napadnu i zajedno s našom magaradi uzmu za robove.” ");
INSERT INTO hrv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Stoga se primaknu upravitelju Josipova doma te mu, na ulazu u kuću, reknu: ");
INSERT INTO hrv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Oprosti, gospodaru! Mi smo i prije jednom dolazili da nabavimo hrane; ");
INSERT INTO hrv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","i kad smo stigli na prenoćište i otvorili svoje vreće, a to novac svakoga od nas ozgo u njegovoj vreći, naš novac, ista svota. Sad smo ga donijeli sa sobom. ");
INSERT INTO hrv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","A ponijeli smo i drugog novca da kupimo hrane. Mi ne znamo tko nam je stavio novac u naše vreće.” ");
INSERT INTO hrv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“Budite mirni”, reče im on. “Ne bojte se! Bog vaš i Bog vašega oca stavio je blago u vaše vreće. Vaš je novac k meni stigao.” Potom im izvede Šimuna. ");
INSERT INTO hrv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Čovjek zatim uvede ljude u Josipovu kuću; dade im vode da operu noge, a njihovoj magaradi baci p§iće. ");
INSERT INTO hrv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Potom priprave oni svoje darove za dolazak Josipov o podne, jer su čuli da će ondje ručati. ");
INSERT INTO hrv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kad je Josip došao u kuću, dadu mu darove koje su sa sobom donijeli i do zemlje mu se poklone. ");
INSERT INTO hrv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Upita ih on za zdravlje te će dalje: “A je li dobro vaš stari otac o kome ste mi govorili? Je li još dobra zdravlja?” ");
INSERT INTO hrv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“Sluga tvoj, otac naš, dobro je i još je dobra zdravlja”, odgovore i duboko se naklone iskazujući poštovanje. ");
INSERT INTO hrv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Podigavši svoje oči, Josip opazi svoga brata Benjamina - sina svoje majke - te upita: “Je li ovo vaš najmlađi brat o kome ste mi govorili?” Onda nastavi: “Bog ti bio milostiv, sine moj!” ");
INSERT INTO hrv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Josip se poslije toga požuri van jer mu se srce uzbudilo zbog brata; bilo mu je da zaplače. Uđe u jednu sobu i tu se isplaka. ");
INSERT INTO hrv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Onda opere lice, ponovo se javi i, svladavajući se, naredi: “Poslužite ručak!” ");
INSERT INTO hrv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Staviše njemu napose, njima napose, a napose opet Egipćanima koji su s njim jeli. Egipćani ne bi mogli jesti s Hebrejima, jer bi to Egipćanima bilo odvratno. ");
INSERT INTO hrv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","I kad posjedaše pred njim, najstariji prema starosti svojoj, a najmlađi prema mladosti svojoj, samo se zgledahu. ");
INSERT INTO hrv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","I naređivaše on da jela ispred njega nose njima, a obrok Benjaminov bijaše pet puta veći od svih ostalih. I pili su i gostili se s njim. ");
INSERT INTO hrv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Onda Josip naredi upravitelju svoga kućanstva: “Napuni vreće ovih ljudi hranom koliko mogu ponijeti, a novac svakog stavi u grlo njegove vreće. ");
INSERT INTO hrv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","A moj pehar - onaj od srebra - stavi u grlo vreće najmlađega, zajedno s njegovim novcem za žito.” On učini kako mu je Josip naredio. ");
INSERT INTO hrv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kad je svanulo, otpreme ljude i njihove magarce. ");
INSERT INTO hrv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Tek što su izišli iz grada - nisu bili odmakli daleko - kad Josip reče upravitelju svoga kućanstva: “Na noge! Pođi za onim ljudima! Kad ih stigneš, kaži im: 'Zašto uzvraćate zlo za dobro? ");
INSERT INTO hrv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Zar iz onog pehara ne pije moj gospodar i ne čita iz njega proricanje? Zlo ste učinili!'” ");
INSERT INTO hrv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Stigavši ih, ponovi im te riječi. ");
INSERT INTO hrv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Oni odgovore: “Zašto nam gospodar govori tako? Daleko bilo od slugu tvojih da učine takvo što! ");
INSERT INTO hrv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Čak i novac koji smo našli u svojim vrećama donijeli smo ti natrag iz zemlje kanaanske. Kako bismo onda mogli ukrasti srebra ili zlata iz kuće tvoga gospodara! ");
INSERT INTO hrv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Onaj u koga se od tvojih slugu nađe, neka se usmrti, a mi drugi postat ćemo robovi tvome gospodaru.” ");
INSERT INTO hrv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“Premda je ono što predlažeš pravo”, preuzme on, “ipak će samo onaj u koga se ukradeno pronađe biti moj rob, a ostali bit ćete slobodni.” ");
INSERT INTO hrv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Brže spustiše vreće na zemlju i svaki svoju otvori. ");
INSERT INTO hrv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","On je pretraživao, počevši s najstarijim i završivši s najmlađim. Pehar se nađe u Benjaminovoj vreći. ");
INSERT INTO hrv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Nato oni razdru svoje haljine; svaki ponovo natovari svoga magarca i vrate se u grad. ");
INSERT INTO hrv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Kad su Juda i njegova braća ponovo stupili u Josipov dom, još je on bio ondje. Bace se preda nj na zemlju. ");
INSERT INTO hrv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Onda im Josip reče: “Kakvo je to djelo što ste ga učinili? Zar ne znate da se čovjek kao što sam ja bavi proricanjem?” ");
INSERT INTO hrv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Nato Juda odgovori: “Što bismo mogli reći svome gospodaru? Što možemo kazati, čime li se opravdati? Bog je otkrio zlodjelo tvojih slugu. Evo nas za robove svome gospodaru - jednako nas kao i onog u koga se našao pehar.” ");
INSERT INTO hrv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","“Daleko od mene da učinim tako!” - odgovori. “Nego, onaj u koga se našao pehar bit će moj rob, a vi drugi pođite mirno k svome ocu!” ");
INSERT INTO hrv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Onda mu se Juda primače i reče: “Gospodaru moj, molim te, dopusti sluzi svojem da rekne riječ ušima gospodara svojega i neka se tvoja srdžba ne razlijeva na tvog slugu. TÓa ti si ravan faraonu. ");
INSERT INTO hrv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Pitao je moj gospodar svoje sluge: 'Imate li oca ili još kojega brata?' ");
INSERT INTO hrv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Svome smo gospodaru odgovorili: 'Imamo stara oca; on još ima jednog sina, rođena u njegovoj staračkoj dobi. Taj je najmlađi. Njegov je pravi brat umro, tako da je on jedini ostao od svoje majke. Njegov ga otac osobito voli.' ");
INSERT INTO hrv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Potom si rekao svojim slugama: 'Dovedite mi ga ovamo da ga vide moje oči?' ");
INSERT INTO hrv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","A mi smo odgovorili svome gospodaru: 'Dječak ne može ostaviti oca; kad bi ga ostavio, njegov bi otac umro.' ");
INSERT INTO hrv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Nato si rekao svojim slugama: 'Ako vaš najmlađi brat s vama ne dođe ovamo, više ne smijete preda me.' ");
INSERT INTO hrv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kad smo se vratili tvome sluzi, ocu mome, kazali smo mu riječi moga gospodara. ");
INSERT INTO hrv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Naš nam je otac rekao: 'Idite opet i nabavite nam malo hrane!' ");
INSERT INTO hrv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Odgovorili smo: 'Ne možemo onamo. Samo ako s nama pođe naš najmlađi brat, sići ćemo, jer ne smijemo pred onoga čovjeka ako ne bude s nama naš najmlađi brat.' ");
INSERT INTO hrv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tvoj sluga, otac moj, odvrati nam: 'Kako znate, žena mi je rodila dva sina. ");
INSERT INTO hrv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Jedan je nestao, te sam zaključio: sigurno je rastrgan! Odonda ga više nisam vidio. ");
INSERT INTO hrv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ako i ovoga od mene odvedete pa ga kakva nesreća snađe, moju ćete sijedu glavu s tugom strovaliti dolje u Šeol.' ");
INSERT INTO hrv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ako sad dođem k tvome sluzi, ocu svome, a mladić - čiji je život tako povezan s njegovim - ne bude s nama, ");
INSERT INTO hrv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","on će svisnuti kad vidi da dječaka nema s nama; tako će tvoje sluge strovaliti u tuzi sijedu glavu tvoga sluge, oca našega, dolje u Šeol. ");
INSERT INTO hrv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Jer tvoj je sluga zajamčio ocu svome za dječaka, rekavši: 'Ako ti ga ne vratim, bit ću kriv svome ocu svega vijeka.' ");
INSERT INTO hrv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Zato, molim te, neka tvoj sluga ostane kao rob mome gospodaru, a dječak neka ide natrag s braćom. ");
INSERT INTO hrv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Jer, kako mogu k svome ocu ako dječaka nema sa mnom! Ne bih mogao gledati jad što bi snašao moga oca.” ");
INSERT INTO hrv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Josip se više nije mogo svladavati pred onima koji su ga okruživali pa povika: “Neka svi odstupe!” Tako nitko nije ostao s Josipom kad se očitovao svojoj braći. ");
INSERT INTO hrv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Briznuo je u glasan plač, da su ga i Egipćani mogli čuti. Doznalo se za to i na faraonovu dvoru. ");
INSERT INTO hrv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","“Ja sam Josip”, reče Josip svojoj braći. “Otac mi je, dakle, još na životu!” Ali mu braća nisu mogla odgovoriti, toliko se zapanjiše pred njim. ");
INSERT INTO hrv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Onda će opet Josip svojoj braći: “Primaknite se k meni!” Kad su se primakli, nastavi: “Ja sam Josip, vaš brat; onaj koga ste prodali u Egipat. ");
INSERT INTO hrv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ali se nemojte uznemirivati i prekoravati što ste me ovamo prodali; jer Bog je onaj koji me pred vama poslao da vas održi u životu. ");
INSERT INTO hrv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Dvije su već godine što je glad došla na zemlju, a još pet godina neće biti ni oranja ni žetve u zemlji. ");
INSERT INTO hrv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Zato me Bog poslao pred vama da vam se sačuva ostatak na zemlji te da vam život spasi velikim izbavljenjem. ");
INSERT INTO hrv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tako niste vi mene poslali ovamo nego Bog; on me postavio faraonu za oca, gospodara nad svim njegovim domom i vladaocem nad svom zemljom egipatskom. ");
INSERT INTO hrv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Žurite se k mome ocu te mu recite: 'Ovo ti poručuje tvoj sin Josip: Bog me postavio gospodarem nad svim Egiptom; siđi k meni bez oklijevanja. ");
INSERT INTO hrv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nastanit ćeš se u kraju Gošenu. Tako ćeš biti blizu mene: ti, tvoja djeca, tvoja unučad, tvoje ovce i goveda i sve što je tvoje. ");
INSERT INTO hrv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ondje ću se za te brinuti, jer će glad potrajati još pet godina. Tako nećeš oskudijevati ni ti, ni tvoja obitelj, niti itko tvoj.' ");
INSERT INTO hrv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ta svojim očima možete vidjeti, kao što vidi i moj brat Benjamin, da vam to moja usta govore. ");
INSERT INTO hrv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Pripovjedite ocu o mome visokom položaju u Egiptu i sve što ste vidjeli; i brzo mi ovamo oca dovedite!” ");
INSERT INTO hrv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Potom zagrli brata Benjamina te zaplaka; a plakao je i Benjamin obisnuvši mu oko vrata. ");
INSERT INTO hrv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Izljubi zatim svu svoju braću, u naručju im se rasplaka. Poslije toga njegova braća zađu s njim u razgovor. ");
INSERT INTO hrv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Glas se pročuje u faraonovu dvoru: “Stigla Josipova braća!” Bilo je to drago faraonu i njegovim dvoranima. ");
INSERT INTO hrv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Onda faraon reče Josipu: “Kaži svojoj braći neka učine ovo: 'Natovarite svoje živine i odmah se uputite u zemlju kanaansku. ");
INSERT INTO hrv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Uzmite svoga oca i svoje obitelji i k meni dođite! Ja ću vam dati najbolju zemlju u Egiptu te ćete uživati od obilja ove zemlje.' ");
INSERT INTO hrv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","A naredi i ovo: 'Ovako učinite: Iz zemlje egipatske potjerajte kola za svoju djecu i svoje žene, uzmite oca i dođite. ");
INSERT INTO hrv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Neka vam se oči ne rastužuju za vašim stvarima, jer sve što je u Egiptu najbolje bit će vaše.'” ");
INSERT INTO hrv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Sinovi Izraelovi tako učine. Po faraonovoj zapovijedi Josip im dade kola i popudbinu. ");
INSERT INTO hrv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Svakom od njih dade nove haljine, a Benjaminu dade tri stotine srebrnika i petore haljine. ");
INSERT INTO hrv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Isto tako pošalje svome ocu: deset magaraca natovarenih najboljim plodovima egipatskim i deset magarica natovarenih žitom, kruhom i namirnicama ocu za put. ");
INSERT INTO hrv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Isprativši svoju braću na put, reče im: “Nemojte se putem svađati!” ");
INSERT INTO hrv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","I tako oni odoše iz Egipta i stigoše u zemlju kanaansku, k svome ocu Jakovu. ");
INSERT INTO hrv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Kad mu rekoše: “Josip je živ i čak vlada nad svom zemljom egipatskom!”, njegovo se srce skameni jer im nije mogao vjerovati. ");
INSERT INTO hrv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ali kad mu ispripovjediše sve što im je Josip rekao i kad vidje kola što ih je Josip poslao da ga prevezu, duh njihova oca Jakova oživje. ");
INSERT INTO hrv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","“Dosta”, reče Izrael. “Sin moj Josip još je živ! Moram poći i vidjeti ga prije nego umrem.” ");
INSERT INTO hrv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tako Izrael krene na put sa svim što bijaše njegovo i stigne u Beer Šebu te prinese žrtvu Bogu svoga oca Izaka. ");
INSERT INTO hrv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","U noćnom viđenju zovne Bog Izraela: “Jakove! Jakove!” On odgovori: “Evo me!” ");
INSERT INTO hrv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Ja sam Bog, Bog tvoga oca. Ne boj se sići u Egipat, jer ću ondje od tebe proizvesti velik narod. ");
INSERT INTO hrv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ja ću sići u Egipat s tobom i sam ću te vratiti ovamo; a Josip će ti svojom rukom oči zaklopiti.” ");
INSERT INTO hrv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","I Jakov krene iz Beer Šebe. Sinovi Izraelovi postave svoga oca Jakova, svoju djecu i svoje žene u kola što ih je faraon poslao da ga prevezu. ");
INSERT INTO hrv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Uzmu sa sobom svoje blago i dobra što ih bijahu stekli u zemlji kanaanskoj te stignu Jakov i sve njegovo potomstvo u Egipat. ");
INSERT INTO hrv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Sa sobom je u Egipat poveo svoje sinove i unuke, svoje kćeri i kćeri svojih sinova, sve svoje potomstvo. ");
INSERT INTO hrv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ovo su imena Izraelaca - Jakova i njegovih potomaka - koji su stigli u Egipat: Jakovljev prvorođenac Ruben. ");
INSERT INTO hrv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubenovi sinovi: Henok, Falu, Hesron i Karmi. ");
INSERT INTO hrv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Sinovi Šimunovi: Jemuel, Jamin, Ohad, Jakin, Sohar i Šaul, sin Kanaanke. ");
INSERT INTO hrv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Sinovi Levijevi: Geršon, Kehat i Merari. ");
INSERT INTO hrv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Sinovi Judini: Er, Onan, Šela, Peres i Zerah. Er i Onan umrli su u zemlji kanaanskoj. Peresovi sinovi bili su Hesron i Hamul. ");
INSERT INTO hrv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Sinovi Jisakarovi: Tola, Fuva, Jašub i Šimron. ");
INSERT INTO hrv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sinovi Zebulunovi: Sered, Elon i Jahleel. ");
INSERT INTO hrv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","To su sinovi koje je Lea imala s Jakovom u Padan Aramu i još kćerka Dina. U svemu je, dakle, imao sinova i kćeri trideset i troje. ");
INSERT INTO hrv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Sinovi Gadovi: Sifjon, Hagi, Šuni, Esbon, Eri, Arodi i Areli. ");
INSERT INTO hrv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Sinovi Ašerovi: Jimna, Jišva, Jišvi, Berija i sestra im Serah. Sinovi Berijini: Heber i Malkiel. ");
INSERT INTO hrv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","To su bili potomci Zilpe, koju je Laban darovao svojoj kćeri Lei. Ona je tako rodila Jakovu šesnaest duša. ");
INSERT INTO hrv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Sinovi Jakovljeve žene Rahele: Josip i Benjamin. ");
INSERT INTO hrv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Josipu su se u egipatskoj zemlji rodili Manaše i Efrajim. Rodila mu ih je kći onskog svećenika Poti-Fere. ");
INSERT INTO hrv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Sinovi Benjaminovi: Bela, Beker, Ašbel, Gera, Naaman, Ehi, Roš, Mupim, Hupim i Ard. ");
INSERT INTO hrv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","To su bili potomci Rahelini koje je rodila Jakovu - u svemu njih četrnaest. ");
INSERT INTO hrv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danov je sin Hušim. ");
INSERT INTO hrv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Sinovi Naftalijevi: Jahseel, Guni, Jeser i Šilem. ");
INSERT INTO hrv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","To su bili potomci Bilhe, koju je Laban dao svojoj kćeri Raheli. Ona je Jakovu rodila sedam potomaka. ");
INSERT INTO hrv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tako je sve Jakovljeve čeljadi što je od njega poteklo i u Egipat doselilo - ne uključujući žena Jakovljevih sinova - u svemu šezdeset i šest osoba. ");
INSERT INTO hrv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","I k tome dva sina Josipova što su mu se rodila u Egiptu. Prema tome, sve čeljadi Jakovljeva doma što se naseli u Egiptu bijaše sedamdeset duša. ");
INSERT INTO hrv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Izrael posla Judu naprijed k Josipu da se pred njim pojavi u Gošenu. Kad stignu u gošenski kraj, ");
INSERT INTO hrv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josip upregne svoja kola i zaputi se u Gošen - u susret svome ocu Izraelu. Stupivši preda nj, pade mu oko vrata i dugo je tako plakao. ");
INSERT INTO hrv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Onda Izrael reče Josipu: “Sada, pošto sam rođenim očima vidio da si još živ, mogu umrijeti.” ");
INSERT INTO hrv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Zatim Josip reče svojoj braći i očevoj obitelji: “Otići ću i obavijestiti faraona; reći ću mu: 'Moja braća i obitelj moga oca, koji su bili u zemlji kanaanskoj, došli su k meni. ");
INSERT INTO hrv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Oni su ljudi pastiri, uvijek su se bavili stočarstvom; dotjerali su sa sobom svoja stada i sve što im pripada.' ");
INSERT INTO hrv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tako, kad vas faraon pozove i zapita: 'Čime se bavite?' ");
INSERT INTO hrv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","odgovorite: 'Ljudi smo, sluge tvoje, koji se od početka do sad bavimo stočarstvom; i mi i naši preci', tako da se možete naseliti u gošenskom kraju. Svi su, naime, pastiri Egipćanima mrski.” ");
INSERT INTO hrv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ode, dakle, Josip te obavijesti faraona: “Moj otac i moja braća stigoše sa svojim ovcama i govedima i sa svime što imaju iz zemlje kanaanske, i eno ih u gošenskom kraju.” ");
INSERT INTO hrv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","I uzevši petoricu između svoje braće, uvede ih faraonu. ");
INSERT INTO hrv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Onda faraon zapita njegovu braću: “Čime se bavite?” Odgovore faraonu: “Tvoje su sluge stočari, baš kao što su bili naši preci. ");
INSERT INTO hrv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Došli smo da potražimo kratak boravak u ovoj zemlji”, rekoše faraonu, “jer je nestalo paše za stada tvojih slugu, strašna glad pritište kanaansku zemlju. Dopusti da se tvoje sluge nastane u gošenskom kraju.” ");
INSERT INTO hrv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","5a Faraon reče Josipu: 6b “Neka se, dakle, nastane u gošenskom kraju. A ako znaš da među njima ima prikladnih, postavi ih za nadglednike moga osobnog blaga.” 5b Tako, kad Jakov i njegovi sinovi stigoše u Egipat i kad faraon, kralj egipatski, to ču, reče Josipu: “Budući da su tvoj otac i tvoja braća došli k tebi, ");
INSERT INTO hrv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","6a egipatska ti je zemlja na raspolaganju: smjesti svoga oca i svoju braću u najboljem kraju.” ");
INSERT INTO hrv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Josip onda dovede svoga oca Jakova faraonu. Jakov blagoslovi faraona. ");
INSERT INTO hrv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","A faraon upita Jakova: “Koliko ti je godina?” ");
INSERT INTO hrv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakov odgovori faraonu: “Godina moga lutalačkog življenja ima stotina i trideset. Malo ih je i nesretne su bile godine moga života; ne dostižu brojem godine življenja na zemlji mojih otaca.” ");
INSERT INTO hrv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Poslije toga Jakov se oprosti s faraonom i ode od njega. ");
INSERT INTO hrv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Tako Josip nastani svoga oca i svoju braću davši im u vlasništvo najljepši kraj egipatske zemlje, u kraju Ramsesovu, kako je faraon naredio. ");
INSERT INTO hrv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","A Josip opskrbi hranom svoga oca, svoju braću i svu očevu obitelj sve do najmanjega. ");
INSERT INTO hrv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nigdje nije bilo hrane jer je pritisla strašna glad: izmuči ona i zemlju egipatsku i zemlju kanaansku. ");
INSERT INTO hrv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josip pobra sav novac što se nalazio u zemlji egipatskoj i zemlji kanaanskoj u zamjenu za žito koje se prodavalo i odnese novac u faraonov dvor. ");
INSERT INTO hrv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kad je nestalo novca u zemlji egipatskoj i zemlji kanaanskoj, svi Egipćani dođu k Josipu te mu reknu: “Daj nam kruha! Zašto da pomremo pred tvojim očima? Novca više nema.” ");
INSERT INTO hrv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josip odgovori: “Predajte svoju stoku pa ću vam dati žita u zamjenu za stoku kad je novca nestalo.” ");
INSERT INTO hrv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tako su oni dovodili svoju stoku Josipu, a Josip im davaše kruh u zamjenu za konje, za sitnu i krupnu stoku i za magarad. Tako ih je one godine opskrbljivao kruhom u zamjenu za sve njihovo blago. ");
INSERT INTO hrv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kad je ona godina prošla, dođu k njemu i druge godine te mu reknu: “Ne možemo sakriti od svoga gospodara: novca je nestalo, blaga su već ustupljena gospodaru; drugo ništa ne preostaje da gospodaru ustupimo nego sebe i svoje oranice. ");
INSERT INTO hrv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Zašto da uništimo na tvoje oči i sebe i svoje zemlje? Uzmi i nas i naše zemlje u zakup za kruh, i tako ćemo zajedno sa svojom zemljom postati faraonovi kmetovi; daj sjemena da preživimo: da ne izginemo i da nam oranice ne postanu pustoš!” ");
INSERT INTO hrv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tako Josip steče faraonu u posjed sve egipatske oranice, jer je svaki Egipćanin, kako ih pritisnu glad, prodao svoje njive. Tako je zemlja postala faraonovo vlasništvo, ");
INSERT INTO hrv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","a narod od jednog kraja Egipta do drugoga njegovim robljem. ");
INSERT INTO hrv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Jedino nije preuzeo svećeničkih imanja, jer je faraon davao svećenicima određeni dio, i tako su živjeli od prihoda što im ga je faraon davao. Stoga nisu prodali svojih imanja. ");
INSERT INTO hrv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Onda Josip reče svijetu: “Budući da sam danas za faraona prekupio i vas i vašu zemlju, evo vam sjeme pa zasijte zemlju. ");
INSERT INTO hrv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","A kad bude pobiranje ljetine, faraonu ćete davati jednu petinu, dok će četiri petine ostajati vama: za zasijavanje polja, za hranu vama i onima koji su u vašim domovima i za hranu vašoj djeci.” ");
INSERT INTO hrv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Oni odgovore: “Život si nam spasio! Mi smo zahvalni svome gospodaru što možemo biti faraonovi robovi.” ");
INSERT INTO hrv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tako Josip napravi za Egipat zemljišni zakon koji i danas vrijedi: petina pripada faraonu; jedino svećenička imanja nisu prešla faraonu. ");
INSERT INTO hrv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Izraelci se nastaniše u zemlji egipatskoj, u kraju gošenskom; u njem stekoše vlasništvo; bijahu rodni i broj im se veoma umnoži. ");
INSERT INTO hrv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","U zemlji egipatskoj poživje Jakov sedamnaest godina. Tako je duljina Jakovljeva života iznosila sto četrdeset i sedam godina. ");
INSERT INTO hrv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","A kad se približi vrijeme Izraelu da umre, pozva svoga sina Josipa te mu reče: “Ako mi želiš ugoditi, stavi svoju ruku pod moje stegno kao jamstvo svoje odanosti meni: nemoj me sahraniti u Egiptu! ");
INSERT INTO hrv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kad legnem dolje sa svojim ocima, prenesi me iz Egipta gore i sahrani me u njihovu grobnicu!” “Učinit ću kako si rekao”, odgovori. ");
INSERT INTO hrv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","“Zakuni mi se!” - reče. I on mu se zakle. Tada se Izrael duboko prignu na uzglavlju. ");
INSERT INTO hrv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Poslije nekog vremena jave Josipu: “Eno ti je otac obolio.” Nato on uzme sa sobom svoja dva sina, Manašea i Efrajima. ");
INSERT INTO hrv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kad Jakovu rekoše: “Evo ti je došao sin Josip”, Izrael skupi svoje snage i sjede na postelju. ");
INSERT INTO hrv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Reče Jakov Josipu: “Bog Svemožni, El Šadaj, objavi mi se u Luzu, u zemlji kanaanskoj; blagoslov mi dade, ");
INSERT INTO hrv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","a potom mi reče: 'Učinit ću te rodnim i mnogobrojnim, učinit ću da postaneš skup naroda, a tvome potomstvu poslije tebe dat ću ovu zemlju u posjed zauvijek.' ");
INSERT INTO hrv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Sad, oba tvoja sina što su ti se rodila u zemlji egipatskoj, prije nego sam ja stigao k tebi u Egipat, neka budu moji - Efrajim i Manaše neka budu moji kao i Ruben i Šimun! ");
INSERT INTO hrv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","A djeca što su ti se rodila poslije njih neka ostanu tvoja; a u svom nasljedstvu neka se zovu po imenu svoje braće. ");
INSERT INTO hrv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kad sam se, naime, vraćao iz Padana, na moju žalost, tvoja majka Rahela umrije na putovanju u kanaansku zemlju, tek u maloj udaljenosti od Efrate. Sahranio sam je ondje uz put u Efratu, sadašnji Betlehem.” ");
INSERT INTO hrv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Opazivši Izrael Josipove sinove, zapita: “Tko su ovi?” ");
INSERT INTO hrv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josip odgovori svome ocu: “Sinovi su to moji koje mi je Bog dao ovdje.” “Dovedi mi ih da ih blagoslovim”, reče. ");
INSERT INTO hrv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Izraelu oči oslabile od starosti, nije vidio. Zato mu privede sinove, a on ih poljubi i zagrli. ");
INSERT INTO hrv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Potom Izrael reče Josipu: “Nisam očekivao da ću još ikada vidjeti tvoje lice; kad, evo, Bog mi dade da vidim i tvoje potomke.” ");
INSERT INTO hrv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Josip ih tada skine s njegovih koljena i duboko se, sve do zemlje, nakloni. ");
INSERT INTO hrv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Nato ih uze Josip obojicu - Efrajima svojom desnicom, Izraelu nalijevo, a Manašea svojom ljevicom, Izraelu nadesno - te ih k njemu primače. ");
INSERT INTO hrv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ali Izrael ispruži svoju desnicu i stavi je na Efrajimovu glavu, premda je bio mlađi, a svoju ljevicu na glavu Manašeovu - tako je držao ruke unakrst - iako je Manaše bio prvorođenac. ");
INSERT INTO hrv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Tako je davao svoj blagoslov Josipu govoreći: “Bog, čijim su putovima hodili oci moji Abraham i Izak, Bog, koji mi je pastir bio otkako postah pa do danas, ");
INSERT INTO hrv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","anđeo koji me od svakog zla izbavljao - djecu ovu neka blagoslovi! Neka se ime moje i mojih pređa Abrahama i Izaka po njima spominje! U mnoštva se mnogobrojna po zemlji razmnožili!” ");
INSERT INTO hrv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kad je Josip vidio da je njegov otac položio desnicu na Efrajimovu glavu, njegovim se očima to učini krivo; zato posegne za rukom svoga oca da je pomakne s Efrajimove glave na glavu Manašeovu. ");
INSERT INTO hrv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“Ne tako, oče moj,” reče Josip svome ocu, “jer ovo je prvorođenac; zato stavi desnicu na njegovu glavu!” ");
INSERT INTO hrv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ali njegov otac to odbije rekavši: “Znam ja, sine moj, znam; i od njega će postati narod i bit će velik. Ali njegov mlađi brat bit će veći od njega, a njegovo će potomstvo biti mnoštvo.” ");
INSERT INTO hrv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Onoga ih, dakle, dana blagoslovi rekavši: “Vama nek' se Izrael blagoslivlja govoreći: Kao što je Efrajimu i Manašeu, nek' i tebi Bog učini!” Tako stavi Efrajima pred Manašea. ");
INSERT INTO hrv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Poslije Izrael reče Josipu: “Ja ću, evo, naskoro umrijeti; no Bog će biti s vama i opet vas dovesti u zemlju vaših otaca. ");
INSERT INTO hrv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","A tebi ostavljam Šekem, nešto više nego tvojoj braći, što sam ga svojim mačem i lukom osvojio od Amorejaca.” ");
INSERT INTO hrv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jakov zatim sazva svoje sinove te reče: “Skupite se da vam kažem što će vas snaći u kasnije vrijeme: ");
INSERT INTO hrv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Okupite se, čujte, sinovi Jakovljevi, čujte oca svoga Izraela! ");
INSERT INTO hrv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ti Rubene, moj prvorođenče, snaga ti si moja, prvenac moje muškosti. Ističeš, se ponosom, snagom se ističeš, ");
INSERT INTO hrv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","no, poput vode nabujao, nećeš više imati prvenstva, jer na ležaj oca svog se pope, moj tad oskvrnu krevet. ");
INSERT INTO hrv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Šimun i Levi braća su prava! Mačevi im oruđe nasilja. ");
INSERT INTO hrv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Na njihova vijećanja ja ne silazio, u njihovim zborovima udjela ne imao! U srdžbi su svojoj ljude ubijali; u obijesti bikove sakatili. ");
INSERT INTO hrv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Prokleta im srdžba, jer je prežestoka! Prokleta im obijest, jer je preokrutna! Razdijelit ću ih po Jakovu, Izraelom raspršiti. ");
INSERT INTO hrv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judo! Tvoja braća slavit će te; svagda ti je šaka na šiji dušmana, sinci oca tvoga tebi će se klanjat. ");
INSERT INTO hrv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judo, laviću mali! Plijenom si se, sine, udebljao; poput lava, poput lavice legao potrbuške! Tko bi ga dražiti smio? ");
INSERT INTO hrv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Od Jude žezlo se kraljevsko, ni palica vladalačka od nogu njegovih udaljiti neće dok ne dođe onaj kome pripada - kome će se narodi pokoriti. ");
INSERT INTO hrv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Svog magarca za lozu privezuje, mlado magarice svoje za čokot. U vinu on kupa svoju odjeću svoju halju u krvi od grožđa. ");
INSERT INTO hrv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Oči su mu od vina mutne, zubi bjelji od mlijeka. ");
INSERT INTO hrv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun će stanovati uz obalu morsku, luka spasa bit će brodarima, uz bok njegov Sidon će ležati. ");
INSERT INTO hrv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Jisakar je koščat magarac polegao među ogradama. ");
INSERT INTO hrv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Vidje da je odmor ugodan, a zemlja lijepa, te leđa svoja pod teret podmetnu i na tlaku pristade. ");
INSERT INTO hrv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan će narod svoj suditi kao svako pleme Izraelovo. ");
INSERT INTO hrv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Nek' Dan zmija bude na putu, guja pokraj staze što će konja za zglob ujesti, i njegov konjik nauznak će pasti. ");
INSERT INTO hrv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","U spas tvoj se, Jahve, uzdam! ");
INSERT INTO hrv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada će pljačkat razbojnici, pljačkom će im za petama biti. ");
INSERT INTO hrv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","U Ašera bit će hrane, poslastica za kraljeve. ");
INSERT INTO hrv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali je košuta lakonoga koja krasnu lanad mladi. ");
INSERT INTO hrv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josip je stablo plodno, plodno stablo kraj izvora, grane svoje grana preko zida. ");
INSERT INTO hrv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Strijelci njega saletjeli, strijeljali ga, opljačkali. ");
INSERT INTO hrv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ali luk mu čvrst ostaje, mišice mu ojačale, rukom Jakog Jakovljeva, imenom Pastira, Stijene Izraela, ");
INSERT INTO hrv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Bogom, Ocem tvojim, koji ti pomaže, Svesilnim koji te blagoslivlje blagoslovom ozgo sa nebesa, blagoslovom ozdo iz dubina, blagoslovom iz svih prsa, iz svih utroba! ");
INSERT INTO hrv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Blagoslovom klasja i cvjetova, blagoslovom drevnih brda, želja vječnih brežuljaka - nek' se oni spuste na Josipa, između braće posvećenog! ");
INSERT INTO hrv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin je vuk grabežljivi, lovinu on jutrom jede, a navečer plijen dijeli.” ");
INSERT INTO hrv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Sve su to Izraelova plemena - dvanaest ih na broj - i to im je otac rekao kad ih je blagoslivljao; svakoga je od njih blagoslovio njegovim blagoslovom. ");
INSERT INTO hrv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Poslije toga im dade ovu naredbu: “Naskoro ću se pridružiti svojim precima. Sahranite me kraj mojih otaca, ");
INSERT INTO hrv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","u spilji što se nalazi na polju Efrona, Hetita, u spilji na polju Makpeli, nasuprot Mamri, u zemlji kanaanskoj. To je ona koju je Abraham kupio s poljem od Hetita Efrona za mjesto sahranjivanja. ");
INSERT INTO hrv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ondje je sahranjen Abraham i njegova žena Sara; sahranjeni su ondje Izak i njegova žena Rebeka; ondje sam ja sahranio Leu. ");
INSERT INTO hrv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Polje i spilja na njemu kupljeni su od Hetita.” ");
INSERT INTO hrv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kad je Jakov tako naputio svoje sinove, povuče noge natrag na postelju te izdahnu - pridruži se svojim precima. ");
INSERT INTO hrv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josip se baci na oca, suzama mu oblije lice, izljubi ga. ");
INSERT INTO hrv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Poslije toga Josip naredi liječnicima koji su se nalazili u njegovoj službi da mu oca balzamiraju, i oni balzamiraše Izraela. ");
INSERT INTO hrv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Trebalo je četrdeset dana: toliko, naime, traje balzamiranje. Sedamdeset su ga dana Egipćani oplakivali. ");
INSERT INTO hrv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","A kad je prošlo vrijeme oplakivanja, Josip reče onima u dvoru faraonovu: “Učinite mi milost i prenesite faraonu ovo: ");
INSERT INTO hrv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Moj me otac zakleo govoreći: 'Kad umrem, sahrani me u grob koji sam sebi pripravio u zemlji kanaanskoj!' Dopusti mi da odem gore i sahranim oca, a onda ću se vratiti.” ");
INSERT INTO hrv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraon odgovori: “Otiđi gore i sahrani svoga oca kako si mu se zakleo.” ");
INSERT INTO hrv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tako Josip ode da sahrani oca. S njim su pošli i svi faraonovi službenici - odličnici njegova dvora i svi dostojanstvenici egipatske zemlje; ");
INSERT INTO hrv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","sva Josipova obitelj, njegova braća i očeva porodica. Jedino su u gošenskom kraju ostala njihova djeca, njihove ovce i goveda. ");
INSERT INTO hrv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","S njim su išla i kola i konjanici: bila je to vrlo duga povorka. ");
INSERT INTO hrv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Stigavši u Goren Haatad, s onu stranu Jordana, održaše ondje veliko i svečano naricanje. Josip održa sedmodnevnu žalost za ocem. ");
INSERT INTO hrv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kad su stanovnici te zemlje, Kanaanci, vidjeli tugovanje u Goren Haatadu, rekoše: “To ti je svečano naricanje Egipćana!” Zato nazovu to mjesto Abel-Misrajim. Nalazi se s onu stranu Jordana. ");
INSERT INTO hrv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jakovljevi sinovi učine kako im je naredio otac: ");
INSERT INTO hrv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","odnesu ga u zemlju kanaansku te ga sahrane u spilji na polju Makpeli kod Mamre, polju što ga je Abraham kupio od Hetita Efrona za sahranjivanje. ");
INSERT INTO hrv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Pošto je sahranio svoga oca, Josip se vrati u Egipat - on, njegova braća i svi koji su s njim išli da mu oca pokopaju. ");
INSERT INTO hrv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kad su Josipova braća vidjela da im je otac umro, rekoše: “Što ako je Josip na nas ljut i pokuša uzvratiti nam za sve zlo koje smo mi njemu nanijeli?” ");
INSERT INTO hrv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Stoga poruče Josipu ovako: “Pred svoju smrt tvoj je otac naredio: ");
INSERT INTO hrv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Ovako recite Josipu: Oprosti braći svojoj zlo i grijeh što su onako okrutno prema tebi postupili.' Oprosti, dakle, uvredu slugama Boga svoga oca!” Na te riječi Josip brizne u plač. ");
INSERT INTO hrv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Tada sama njegova braća dođu k njemu, bace se preda nj te mu reknu: “Evo nas k tebi da budemo tvoji robovi!” ");
INSERT INTO hrv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Josip im odvrati: “Ne bojte se! TÓa zar sam ja namjesto Boga! ");
INSERT INTO hrv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Osim toga, iako ste vi namjeravali da meni naudite, Bog je bio ono okrenuo na dobro: da učini što se danas zbiva - da spasi život velikom narodu. ");
INSERT INTO hrv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Zato se ne bojte! Ja ću se brinuti za vas i za vašu djecu.” Tako ih je smirio ljubeznim riječima. ");
INSERT INTO hrv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josip ostane u Egiptu zajedno s rodom svojim i očevim. Poživje Josip stotinu i deset godina. ");
INSERT INTO hrv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Tako je Josip gledao Efrajimovu djecu do trećeg koljena; a rađala se djeca i Makiru, Manašeovu sinu, na Josipovim koljenima. ");
INSERT INTO hrv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Napokon reče Josip svojoj braći: “Ja ću, evo, naskoro umrijeti. Ali će se Bog, zacijelo, sjetiti vas i odvesti vas iz ove zemlje u zemlju što ju je pod zakletvom obećao Abrahamu, Izaku i Jakovu.” ");
INSERT INTO hrv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Tada Josip zakune Izraelove sinove: “Bog će se vas doista sjetiti, i tada ponesite moje kosti odavde!” ");
INSERT INTO hrv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Josip umrije kad mu bijaše sto i deset godina; balzamiraše ga i u Egiptu položiše u lijes. ");
INSERT INTO hrv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ovo su imena Izraelovih sinova koji su s Jakovom sišli u Egipat, svaki sa svojim domom: ");
INSERT INTO hrv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Šimun, Levi i Juda; ");
INSERT INTO hrv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Jisakar, Zebulun i Benjamin; ");
INSERT INTO hrv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan i Naftali; Gad i Ašer. ");
INSERT INTO hrv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","U svemu Jakovljevih potomaka bijaše sedamdeset duša. A Josip je već bio u Egiptu. ");
INSERT INTO hrv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","I umre Josip, a pomru i sva njegova braća i sav onaj naraštaj. ");
INSERT INTO hrv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ali su Izraelci bili rodni, namnožili se i silno ojačali, tako da su napučili zemlju. ");
INSERT INTO hrv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Uto u Egiptu zavlada novi kralj koji nije poznavao Josipa. ");
INSERT INTO hrv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","I reče on svome puku: “Eto, sinovi su Izraelovi postali narod brojan i moćniji od nas. ");
INSERT INTO hrv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Hajde, postupimo mudro s njima: spriječimo im porast, da se u slučaju rata ne pridruže našim neprijateljima, da ne udare na nas i napokon ne odu iz zemlje.” ");
INSERT INTO hrv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","I postaviše nad njima nadglednike da ih tlače teškim radovima. Tako su faraonu sagradili gradove-skladišta: Pitom i Ramses. ");
INSERT INTO hrv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ali što su ih više tlačili, oni se još više množili, napredovali i širili se, tako da su Egipćani strahovali od Izraelaca. ");
INSERT INTO hrv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","I Egipćani se okrutno obore na Izraelce. ");
INSERT INTO hrv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ogorčavali su im život teškim radovima: pravljenjem meljte i opeke, različitim poljskim poslovima i svakovrsnim naporima koje im nemilosrdno nametahu. ");
INSERT INTO hrv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Egipatski se kralj obrati i na hebrejske babice, od kojih jednoj bijaše ime Šifra, a drugoj Pua, pa im naredi: ");
INSERT INTO hrv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Kad u porodu pomažete Hebrejkama, dobro pogledajte oba kamena sjedala: ako je muško dijete, ubijte ga; ako je žensko, neka živi. ");
INSERT INTO hrv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ali su se babice bojale Boga i nisu činile kako im je naredio egipatski kralj, nego su ostavljale na životu mušku djecu. ");
INSERT INTO hrv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Stoga egipatski kralj pozove babice pa im rekne: “Zašto ste tako radile i na životu ostavljale mušku djecu?” ");
INSERT INTO hrv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Nato babice odgovore faraonu: “Hebrejke nisu kao egipatske žene. One su životne. Prije nego babica dođe k njima, one već rode.” ");
INSERT INTO hrv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Bog je to babicama za dobro primio. Narod se množio i silno porastao. ");
INSERT INTO hrv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","A kako su se babice bojale Boga, on ih obdari potomstvom. ");
INSERT INTO hrv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Onda faraon izda naredbu svemu svome narodu: “Svako muško dijete koje se rodi Hebrejima bacite u Rijeku! Na životu ostavite samo žensku djecu.” ");
INSERT INTO hrv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Neki čovjek od Levijeva koljena ode i oženi se djevojkom Levijkom. ");
INSERT INTO hrv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Žena zače i rodi sina. Vidjevši kako je krasan, krila ga je tri mjeseca. ");
INSERT INTO hrv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kad ga nije mogla više sakrivati, nabavi košaricu od papirusove trstike, oblijepi je smolom i paklinom, u nju stavi dijete i položi ga u trstiku na obali Rijeke. ");
INSERT INTO hrv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Njegova sestra stane podalje da vidi što će s njime biti. ");
INSERT INTO hrv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Faraonova kći siđe k Rijeci da se kupa, dok su njezine sluškinje šetale uz obalu Rijeke. Opazi ona košaricu u trstici, pa pošalje sluškinju da je donese. ");
INSERT INTO hrv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Otvori je i pogleda, a to u njoj dijete! Muško čedo. Plakalo je. Njoj se sažali na nj. “Bit će to hebrejsko dijete”, reče. ");
INSERT INTO hrv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Onda njegova sestra rekne faraonovoj kćeri: “Hoćeš li da ti potražim dojilju među Hebrejkama da ti dijete doji?” ");
INSERT INTO hrv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“Idi!” - odgovori joj faraonova kći. Tako djevojka ode i pozove djetetovu majku. ");
INSERT INTO hrv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","“Uzmi ovo dijete”, rekne joj faraonova kći, “i odgoji mi ga, a ja ću te plaćati.” Tako žena uzme dijete i othrani ga. ");
INSERT INTO hrv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Kad je dijete odraslo, ona ga odvede faraonovoj kćeri, koja ga posini. Nadjene mu ime Mojsije, “jer sam ga”, reče, “iz vode izvadila”. ");
INSERT INTO hrv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Jednog dana, kad je Mojsije već odrastao, dođe među svoj narod i vidje njegove muke. Spazi tada kako neki Egipćanin tuče jednoga Hebrejca - brata njegova. ");
INSERT INTO hrv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Okrene se tamo-amo i, vidjevši da nikoga nema, ubije Egipćanina i zatrpa ga u pijesak. ");
INSERT INTO hrv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Izađe on i sutradan te zateče dva Hebrejca kako se tuku. “Zašto tučeš svoga druga?” - rekne napadaču. ");
INSERT INTO hrv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ovaj odvrati: “Tko te postavi za starješinu i suca našega? Kaniš li ubiti i mene kako si ubio onog Egipćanina?” Mojsije se uplaši pa će u sebi: “Tako! Ipak se saznalo.” ");
INSERT INTO hrv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kad je faraon to dočuo, htjede Mojsija pogubiti. Zato Mojsije pobjegne od faraona i skloni se u midjansku zemlju. Ondje sjedne kraj nekog studenca. ");
INSERT INTO hrv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midjanski je svećenik imao sedam kćeri. Dođu one da zahvate vode i naliju pojila, da napoje stado svoga oca. ");
INSERT INTO hrv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ali dođu i pastiri te ih potjeraju. Mojsije ustane, obrani ih i stado im napoji. ");
INSERT INTO hrv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kad su se vratile svome ocu Reuelu, on ih zapita: “Kako ste se danas tako brzo vratile?” ");
INSERT INTO hrv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","One odgovore: “Neki Egipćanin obrani nas od pastira i još nam zahvati vode i stado nam napoji.” ");
INSERT INTO hrv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","“Gdje je?” - zapita on svoje kćeri. “Zašto ste ostavile toga čovjeka? Pozovite ga na objed.” ");
INSERT INTO hrv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mojsije pristane da ostane kod toga čovjeka. On oženi Mojsija svojom kćeri Siporom. ");
INSERT INTO hrv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","A kad ona rodi sina, on mu nadjene ime Geršon, “jer sam”, reče, “stranac u tuđoj zemlji”. ");
INSERT INTO hrv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Poslije mnogo vremena umre egipatski kralj. Izraelci su još stenjali u ropstvu. Vapili su, a njihov vapaj za pomoć sred ropstva uzlazio je k Bogu. ");
INSERT INTO hrv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Bog je čuo njihovo zapomaganje i sjetio se svoga Saveza s Abrahamom, Izakom i Jakovom. ");
INSERT INTO hrv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","I pogleda Bog na Izraelce i zauze se za njih. ");
INSERT INTO hrv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mojsije pasao ovce svoga tasta Jitra, midjanskoga svećenika. Goneći tako stado po pustari, dođe do Horeba, brda Božjega. ");
INSERT INTO hrv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Anđeo mu se Jahvin ukaže u rasplamtjeloj vatri iz jednog grma. On se zagleda: grm sav u plamenu, a ipak ne izgara. ");
INSERT INTO hrv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","“Hajde da priđem, “ reče Mojsije, “i promotrim ovaj čudni prizor: zašto grm ne sagorijeva.” ");
INSERT INTO hrv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kad je Jahve vidio kako prilazi da razmotri, iz grma ga Bog zovne: “Mojsije! Mojsije!” “Evo me!” - javi se. ");
INSERT INTO hrv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","“Ne prilazi ovamo!” - reče. “Izuj obuću s nogu! Jer mjesto na kojem stojiš sveto je tlo. ");
INSERT INTO hrv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ja sam”, nastavi, “Bog tvoga oca; Bog Abrahamov, Bog Izakov, Bog Jakovljev.” Mojsije zakloni lice: bojao se u Boga gledati. ");
INSERT INTO hrv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","“Vidio sam jade svoga naroda u Egiptu”, nastavi Jahve, “i čuo mu tužbu na tlačitelje njegove. Znane su mi muke njegove. ");
INSERT INTO hrv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Zato sam sišao da ga izbavim iz šaka egipatskih i odvedem ga iz te zemlje u dobru i prostranu zemlju - u zemlju kojom teče med i mlijeko: u postojbinu Kanaanaca, Hetita, Amorejaca, Perižana, Hivijaca i Jebusejaca. ");
INSERT INTO hrv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Vapaji sinova Izraelovih dopriješe do mene. I sam vidjeh kako ih Egipćani tlače. ");
INSERT INTO hrv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Zato, hajde! Ja te šaljem faraonu da izbaviš narod moj, Izraelce, iz Egipta.” ");
INSERT INTO hrv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","“Tko sam ja da se uputim faraonu”, odgovori Mojsije Bogu, “i izvedem Izraelce iz Egipta!” ");
INSERT INTO hrv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","“Ja ću biti s tobom”, nastavi. “I ovo će ti biti znak da sam te ja poslao: kad izvedeš narod iz Egipta, Bogu ćete iskazati štovanje na ovome brdu.” ");
INSERT INTO hrv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Nato Mojsije reče Bogu: “Ako dođem k Izraelcima pa im kažem: 'Bog otaca vaših poslao me k vama', i oni me zapitaju: 'Kako mu je ime?' - što ću im odgovoriti?” ");
INSERT INTO hrv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","“Ja sam koji jesam”, reče Bog Mojsiju. Onda nastavi: “Ovako kaži Izraelcima: 'Ja jesam' posla me k vama.” ");
INSERT INTO hrv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Dalje je Bog Mojsiju rekao: “Kaži Izraelcima ovako: 'Jahve, Bog vaših otaca, Bog Abrahamov, Bog Izakov i Bog Jakovljev, poslao me k vama.' To mi je ime dovijeka, tako će me zvati od koljena do koljena.” ");
INSERT INTO hrv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Idi, skupi starješine Izraelaca pa im kaži: 'Jahve, Bog otaca - Bog Abrahamov, Izakov i Jakovljev - objavio mi se i rekao mi: Pohodio sam vas i razabrao što vam se čini u Egiptu. ");
INSERT INTO hrv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Odlučio sam vas izvesti iz egipatske bijede u zemlju Kanaanaca, Hetita, Amorejaca, Perižana, Hivijaca i Jebusejaca - u zemlju kojom teče med i mlijeko!' ");
INSERT INTO hrv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Oni će te poslušati. Onda pođi sa starješinama Izraelaca k egipatskom kralju i reci mu: 'Objavio nam se Jahve, Bog Hebreja. Pusti nas da odemo tri dana hoda u pustinju, da ondje prinesemo žrtvu Jahvi, Bogu svojemu.' ");
INSERT INTO hrv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Znam ja da vas egipatski kralj neće pustiti ako ne bude natjeran teškom šakom. ");
INSERT INTO hrv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Zato ću ja pružiti svoju šaku i pritisnuti Egipat svakovrsnim čudesima što ću ih u njemu izvesti. Poslije će vas pustiti. ");
INSERT INTO hrv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Dobro ću raspoložiti Egipćane prema ovome narodu, pa kad pođete, nećete poći praznih ruku. ");
INSERT INTO hrv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Svaka će žena zatražiti od svoje susjede i stanarke u svojoj kući nakita srebrnog i zlatnog i odjeće. To stavite na svoje sinove i kćeri. Tako ćete oplijeniti Egipćane.” ");
INSERT INTO hrv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mojsije uzvrati: “Ali ako mi ne povjeruju i ne poslušaju me, nego mi reknu: 'Jahve ti se nije objavio?'” ");
INSERT INTO hrv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","“Što ti je to u ruci?” - zapita ga Jahve. “Štap”, odgovori. ");
INSERT INTO hrv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","“Baci ga na zemlju!” - naredi mu Jahve. On ga baci na zemlju, a štap se pretvori u zmiju. Mojsije pred njom uzmače. ");
INSERT INTO hrv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Onda Jahve reče Mojsiju: “Pruži ruku i uhvati je za rep.” I on seže rukom i uhvati je za rep, a ona opet postade štap u njegovoj ruci. ");
INSERT INTO hrv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Tako moraju vjerovati da se Jahve, Bog njihovih otaca, Bog Abrahamov, Bog Izakov i Bog Jakovljev, tebi objavio.” ");
INSERT INTO hrv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Još mu Jahve rekne: “Uvuci ruku u njedra.” On uvuče ruku u njedra. Kad ju je izvukao, gle - ruka mu gubava, bijela kao snijeg. ");
INSERT INTO hrv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“Stavi opet ruku u njedra!” - naredi mu Jahve. On opet ruku u njedra. Kad ju je iz njedara izvukao, gle - opet je bila kao i ostali dio tijela. ");
INSERT INTO hrv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Ako ti ne povjeruju i ne prihvate poruku prvoga znamenja, povjerovat će poruci drugoga znamenja. ");
INSERT INTO hrv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","A ako ih oba ova znamenja ne uvjere pa ti ne povjeruju, zahvati vode iz Rijeke i prolij je po suhu. Voda što je budeš iz Rijeke uzeo na suhu će se u krv pretvoriti.” ");
INSERT INTO hrv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","“Oprosti, Gospodine!” - nastavi Mojsije Jahvi. “Ja nikad nisam bio čovjek rječit; ni prije ni sada kad govoriš svome sluzi. Ja sam u govoru spor, a na jeziku težak.” ");
INSERT INTO hrv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","“Tko je dao čovjeku usta?” - reče mu Jahve. “Tko ga čini nijemim i gluhim; tko li mu vid daje ili ga osljepljuje? Zar to nisam ja, Jahve! ");
INSERT INTO hrv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Idi, dakle! Ja ću biti s tobom kad budeš govorio i kazivat ću ti što ćeš govoriti.” ");
INSERT INTO hrv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","“Oprosti, Gospodine”, opet će Mojsije, “ne bi li poslao koga drugoga!” ");
INSERT INTO hrv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Razljuti se Jahve na Mojsija i reče: “Zar Aron, Levijevac, nije tvoj brat? Znam da je on vrlo rječit. Evo, baš ti izlazi u susret. Kad te vidi, obradovat će se u srcu. ");
INSERT INTO hrv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ti govori njemu i u njegova usta stavljaj riječi. Ja ću biti i s tobom i s njime dok budete govorili; kazivat ću obojici što ćete raditi. ");
INSERT INTO hrv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Neka on mjesto tebe govori narodu. Tako, on će tebi biti mjesto usta, a ti ćeš njemu biti mjesto Boga. ");
INSERT INTO hrv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Uzmi ovaj štap u ruku. Njim izvodi znamenja.” ");
INSERT INTO hrv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Zatim se Mojsije vrati svome tastu Jitru te mu reče: “Pusti me da se vratim braći u Egipat da vidim jesu li još na životu.” “Pođi u miru!” - reče Jitro Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","I Jahve reče Mojsiju u Midjanu: “Vrati se u Egipat, jer su pomrli svi ljudi koji su tražili tvoj život.” ");
INSERT INTO hrv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tako Mojsije posadi na magarca svoju ženu i sinove i ode u zemlju egipatsku. A u ruku Mojsije uze Božji štap. ");
INSERT INTO hrv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Jahve opet reče Mojsiju: “Kad se vratiš u Egipat, pobrini se da pred faraonom izvedeš sva čudesa za koja sam ti dao moć, premda ću ja tvrdim učiniti njegovo srce, tako te neće pustiti narod da ode. ");
INSERT INTO hrv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Tada reci faraonu: 'Ovako kaže Jahve: Izrael je moj prvorođenac. ");
INSERT INTO hrv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Tražim od tebe da mi pustiš sina da mi iskaže štovanje. Ako odbiješ da ga pustiš, ja ću ubiti tvoga prvorođenca.'” ");
INSERT INTO hrv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Kad se na putu Mojsije zaustavi da prenoći, navali na nj Jahve da ga ubije. ");
INSERT INTO hrv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ali Sipora pograbi oštar kremen, obreza svoga sina i kožicom se dotakne Mojsijevih nogu: “Zaista si mi ti krvav muž”, reče. ");
INSERT INTO hrv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","I Jahve ga pusti. Ona je to zbog obrezanja rekla “krvav muž”. ");
INSERT INTO hrv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Onda rekne Jahve Aronu: “Zaputi se prema pustinji, u susret Mojsiju!” On ode i s njim se sastane na Božjem brdu. Poljubi ga. ");
INSERT INTO hrv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mojsije pripovjedi Aronu sve što mu je Jahve povjerio i sva znamenja koja mu je naredio da ih učini. ");
INSERT INTO hrv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Sad odu Mojsije i Aron i skupe sve starješine Izraelaca. ");
INSERT INTO hrv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aron izloži sve što je Jahve govorio Mojsiju, a Mojsije izvede znamenja naočigled naroda. ");
INSERT INTO hrv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Narod je bio uvjeren, i pošto čuše da je Jahve pohodio Izraelce i pogledao na njihove jade, popadaše ničice i pokloniše se. ");
INSERT INTO hrv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Poslije toga odu Mojsije i Aron pa reknu faraonu: “Ovako veli Jahve, Bog Izraelov: 'Pusti narod moj da ode i u moju čast slavi svetkovinu.'” ");
INSERT INTO hrv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","“Tko je taj Jahve da ga ja poslušam”, odvrati faraon, “i pustim Izraelce? Ja toga Jahvu ne znam niti ću pustiti Izraelce.” ");
INSERT INTO hrv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","“Bog Hebreja objavio nam se”, rekoše. “Zato nas pusti da odemo tri dana hoda u pustinju i prinesemo žrtvu Jahvi, Bogu svome, da se na nas ne obori pomorom ili mačem.” ");
INSERT INTO hrv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Nato im odvrati egipatski kralj: “Mojsije i Arone, zašto odvraćate svijet od njegovih dužnosti? Idite na svoj posao. ");
INSERT INTO hrv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Sad kad se svjetina tako umnožila”, nastavi faraon, “vi biste ih od posla odvratili?” ");
INSERT INTO hrv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Istoga dana izda faraon naredbu nadglednicima i bilježnicima: ");
INSERT INTO hrv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Ne pribavljajte više ovome narodu slame kao do sada. Neka idu sami i sebi je skupljaju. ");
INSERT INTO hrv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","A zahtijevajte od njih istu količinu opeke koju su pravili i dosad. Ne smanjujte je! Lijenčine su. Zato viču: 'Hajdemo prinijeti žrtvu Bogu svome!' ");
INSERT INTO hrv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Navalite poslove na taj svijet: neka rade, da ne obraćaju pažnje klevetama!” ");
INSERT INTO hrv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Sad dođu nadglednici naroda i njegovi bilježnici te svijetu objave: “Ovako poručuje faraon: 'Neću vam više nabavljati slame. ");
INSERT INTO hrv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Vi sami morate ići i tražiti je gdje god je možete naći. Ali zato neću smanjiti vaš posao.'” ");
INSERT INTO hrv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Stoga se narod raziđe po svoj zemlji egipatskoj da skuplja strnjiku namjesto slame. ");
INSERT INTO hrv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","A nadglednici ih gonili: “Morate svakoga dana svršiti jednako posla kao i onda dok ste slamu dobivali.” ");
INSERT INTO hrv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","A bilježnike koje faraonovi nadglednici bijahu postavili nad Izraelcima tukli su i korili: “Zašto niste ni jučer ni danas napravili opeke koliko i prije?” ");
INSERT INTO hrv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Onda bilježnici Izraelaca odu i potuže se faraonu: “Zašto ovako postupaš sa svojim slugama? ");
INSERT INTO hrv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Tvoje sluge više ne dobivaju slame, a ipak se od nas traži: napravite opeku? Čak i tuku tvoje sluge, a kriv je tvoj narod!” ");
INSERT INTO hrv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","“Lijenčine ste vi! Lijenčine!” - odgovori faraon. “Stoga i kažete: 'Hajdemo da prinesemo žrtvu Jahvi!' ");
INSERT INTO hrv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nosite se na posao! Slama vam se neće davati, ali morate praviti određene količine opeke.” ");
INSERT INTO hrv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Bilježnici Izraelaca nađu se na muci zbog naredbe: “Svakodnevnu količinu opeke ne smijete smanjiti!” ");
INSERT INTO hrv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Otišavši od faraona, naiđu na Mojsija i Arona, koji su ih čekali. ");
INSERT INTO hrv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","“Neka vas Jahve ima na oku i sudi vam!” - dobace im. “Omrazili ste nas kod faraona i njegovih dvorana; dali ste im mač u ruke da nas pobiju.” ");
INSERT INTO hrv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mojsije se vrati Jahvi i reče: “Zašto, Gospodine, nanosiš štetu svome puku? Zašto si me poslao? ");
INSERT INTO hrv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Otkad sam ja stupio pred faraona i progovorio mu u tvoje ime, on još gore postupa s ovim narodom. A ti ništa ne poduzimaš da izbaviš svoj narod.” ");
INSERT INTO hrv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Jahve reče Mojsiju: “Naskoro ćeš vidjeti kako ću ja s faraonom! Pod jakom rukom pustit će ih da odu; pod jakom rukom sam će ih iz svoje zemlje istjerati.” ");
INSERT INTO hrv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Još reče Bog Mojsiju: “Ja sam Jahve. ");
INSERT INTO hrv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Abrahamu, Izaku i Jakovu objavljivao sam se kao El Šadaj. Ali njima se nisam očitovao pod svojim imenom - Jahve. ");
INSERT INTO hrv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I sklopio sam svoj Savez s njima da ću im dati kanaansku zemlju, zemlju gdje su živjeli kao pridošlice. ");
INSERT INTO hrv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","A sada, pošto sam čuo uzdisaje Izraelaca koje Egipćani drže u ropstvu, sjetih se svoga Saveza. ");
INSERT INTO hrv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Kaži, dakle, Izraelcima da sam ja Jahve; da ću vas izbaviti od tereta što su vam ga Egipćani nametnuli. Oslobodit ću vas od ropstva u kojem vas drže; izbavit ću vas udarajući jako i kažnjavajući strogo. ");
INSERT INTO hrv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Za svoj ću vas narod uzeti i bit ću vašim Bogom. Tada ćete znati da sam vas ja, Jahve, vaš Bog, izbavio od egipatske tlake. ");
INSERT INTO hrv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Dovest ću vas u zemlju za koju sam se zakleo da ću je dati Abrahamu, Izaku i Jakovu i dat ću vam je u baštinu, ja, Jahve.” ");
INSERT INTO hrv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mojsije to kazivaše Izraelcima, ali ga ne htjedoše slušati: duhovi su im bili pomućeni od teškoga ropstva. ");
INSERT INTO hrv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Onda Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Idi i reci faraonu, kralju egipatskome, da otpusti Izraelce iz svoje zemlje.” ");
INSERT INTO hrv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mojsije prozbori Jahvi: “Kad me Izraelci nisu slušali, kako će me, spora u govoru, saslušati faraon!” ");
INSERT INTO hrv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ali je Jahve govorio Mojsiju i Aronu i slao ih sad k Izraelcima, a sad k faraonu, kralju egipatskome, da pusti Izraelce iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ovo su glave njihovih domova. Sinovi Izraelova prvorođenca Rubena: Henok, Palu, Hesron i Karmi. To su obitelji potekle od Rubena. ");
INSERT INTO hrv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","A sinovi Šimunovi: Jemuel, Jamin, Ohad, Jakin, Sohar i Šaul, sin Kanaanke. To su obitelji potekle od Šimuna. ");
INSERT INTO hrv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ovo su imena Levijevih sinova s njihovim potomstvom: Geršon, Kehat i Merari. Levi je živio sto trideset i sedam godina. ");
INSERT INTO hrv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Sinovi su Geršonovi: Libni i Šimi sa svojim obiteljima. ");
INSERT INTO hrv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Sinovi su Kehatovi: Amram, Jishar, Hebron i Uziel. Kehat je živio sto trideset i tri godine. ");
INSERT INTO hrv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merarijevi su sinovi: Mahli i Muši. To su Levijeve obitelji s njihovim potomcima. ");
INSERT INTO hrv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram se oženi svojom tetkom Jokebedom, koja mu rodi Arona i Mojsija. Amram je živio sto trideset i sedam godina. ");
INSERT INTO hrv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Sinovi Jisharovi bijahu: Korah, Nefeg i Zikri. ");
INSERT INTO hrv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","A sinovi su Uzielovi: Mišael, Elsafan i Sitri. ");
INSERT INTO hrv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron se oženi Elišebom, kćerkom Aminadabovom, a sestrom Nahšonovom, koja mu rodi: Nadaba, Abihua, Eleazara i Itamara. ");
INSERT INTO hrv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korahovi su sinovi: Asir, Elkana i Abiasaf. To su Korahovi potomci. ");
INSERT INTO hrv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aronov sin Eleazar oženi se jednom Putielovom kćeri, koja mu rodi Pinhasa. To su glave Levijevih domova prema njihovim koljenima. ");
INSERT INTO hrv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","To je onaj Aron i Mojsije kojima je Jahve zapovjedio da izvedu Izraelce iz Egipta po njihovim četama. ");
INSERT INTO hrv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","To su oni isti, Mojsije i Aron, koji su govorili faraonu, kralju egipatskome, da pusti Izraelce iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","U dan kad je Jahve govorio s Mojsijem u egipatskoj zemlji, ");
INSERT INTO hrv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","rekao mu je: “Ja sam Jahve. Izvijesti faraona, egipatskoga kralja, o svemu što ti kažem.” ");
INSERT INTO hrv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mojsije se pred Jahvom ispričavao: “Spor sam ja u govoru. Kako će me faraon poslušati?” ");
INSERT INTO hrv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mojsiju je Jahve odgovorio: “Vidi! Faraonu ću te nametnuti kao božanstvo; tvoj brat Aron bit će tvoj prorok. ");
INSERT INTO hrv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ti kazuj sve što ti naređujem, a tvoj brat Aron neka faraonu ponovi da pusti Izraelce te odu iz njegove zemlje. ");
INSERT INTO hrv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ja ću učiniti da otvrdne srce faraonu i umnožit ću znakove i čudesa u zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Kako vas faraon neće poslušati, ja ću staviti svoju ruku na Egipat: strašno kažnjavajući, izbavit ću svoje čete, narod svoj, Izraelce, iz egipatske zemlje. ");
INSERT INTO hrv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kad pružim svoju ruku na Egipat i izvedem Izraelce iz njihove sredine, tada će Egipćani spoznati da sam ja Jahve.” ");
INSERT INTO hrv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mojsije i Aron poslušaše: kako im je Jahve naredio, upravo tako učiniše. ");
INSERT INTO hrv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mojsiju je bilo osamdeset, a Aronu osamdeset i tri godine kad su faraonu postavili svoje zahtjeve. ");
INSERT INTO hrv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Još doda Jahve Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kad faraon zatraži od vas da izvedete kakvo znamenje, ti reci Aronu da uzme svoj štap i baci ga pred faraona, a štap će se pretvoriti u zmiju.” ");
INSERT INTO hrv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Dođu Mojsije i Aron pred faraona i učine kako im je Jahve naredio. Aron baci pred faraona i njegove službenike svoj štap, koji se pretvori u zmiju. ");
INSERT INTO hrv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Zovne faraon mudrace i vračare. I zaista, egipatski vračari svojim vračanjem učine isto: ");
INSERT INTO hrv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","svaki baci svoj štap, koji se pretvori u zmiju. Ali Aronov štap proguta njihove štapove. ");
INSERT INTO hrv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Faraon bijaše tvrdokorna srca: ne htjede poslušati Mojsija i Arona, kako je Jahve i kazao. ");
INSERT INTO hrv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Tada Jahve reče Mojsiju: “Faraonovo je srce okorjelo; odbija da pusti narod. ");
INSERT INTO hrv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ujutro pođi k faraonu. Kad izađe k vodi, stani preda nj na obali Rijeke. Uzmi u ruku štap što se bio u zmiju pretvorio. ");
INSERT INTO hrv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Reci mu: 'Jahve, Bog Hebreja, poslao me k tebi s porukom da pustiš moj narod da mi iskaže štovanje u pustinji. Ali sve dosad ti nisi poslušao. ");
INSERT INTO hrv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ovako Jahve poručuje: Ovim ćeš spoznati da sam ja Jahve. Gledaj! Štapom koji imam u ruci mlatnut ću po vodi u Rijeci i pretvorit će se u krv. ");
INSERT INTO hrv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ribe će u Rijeci pocrkati; Rijeka će se usmrdjeti, i grstit će se Egipćanima piti vodu iz Rijeke.'” ");
INSERT INTO hrv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Još Jahve reče Mojsiju: “Reci Aronu da uzme svoj štap i pruži svoju ruku povrh egipatskih voda: njihovih rijeka, njihovih prokopa, njihovih jezeraca, svih njihovih vodenih stjecišta, da se pretvore u krv; po svoj zemlji egipatskoj neka je krv, čak i u drvenim i kamenim posudama.” ");
INSERT INTO hrv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mojsije i Aron učiniše kako im je Jahve naredio. Podiže Aron svoj štap i naočigled faraona i njegovih službenika mlatnu po vodi u Rijeci. Sva se voda u Rijeci prometnu u krv. ");
INSERT INTO hrv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ribe u Rijeci pocrkaše; Rijeka se usmrdje, tako da Egipćani nisu mogli piti vodu iz Rijeke; krv bijaše po svoj zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ali egipatski vračari svojim vračanjem učiniše isto. Tako faraon ostade tvrdokorna srca: nije htio poslušati Mojsija i Arona, kako je Jahve i kazao. ");
INSERT INTO hrv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faraon se okrenu i ode u svoj dvor, ne uzimajući ni to k srcu. ");
INSERT INTO hrv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Svi su Egipćani počeli kopati oko Rijeke tražeći pitke vode jer nisu mogli piti vode iz Rijeke. ");
INSERT INTO hrv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Kad je prošlo sedam dana kako je Jahve udario po Rijeci, ");
INSERT INTO hrv_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","opet Jahve reče Mojsiju: “Pođi k faraonu i reci mu: 'Ovako govori Jahve: Pusti moj narod da ode i štovanje mi iskaže. ");
INSERT INTO hrv_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Ako odbiješ da ih pustiš, svu ću ti zemlju kazniti žabama. ");
INSERT INTO hrv_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Rijeka će vrvjeti žabama. One će izići i prodrijeti u tvoj dvor, u ložnicu, u tvoju postelju, u kuće tvojih službenika i tvoga naroda, pod sačeve i naćve tvoje. ");
INSERT INTO hrv_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Po tebi, po tvome narodu i svim tvojim službenicima skakat će žabe.'” ");
INSERT INTO hrv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Onda Jahve reče Mojsiju: “Reci Aronu neka ispruži svoju ruku sa štapom povrh rijeka, prokopa i jezeraca i učini da žabe navale na egipatsku zemlju.” ");
INSERT INTO hrv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aron pruži svoju ruku povrh egipatskih voda, i žabe iziđoše i prekriše zemlju egipatsku. ");
INSERT INTO hrv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ali i vračari učiniše tako svojim vračanjem, te žabe navališe na egipatsku zemlju. ");
INSERT INTO hrv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Zovne sad faraon Mojsija i Arona i rekne: “Molite Jahvu da ukloni žabe od mene i moga puka, a ja ću pustiti narod da prinese žrtvu Jahvi.” ");
INSERT INTO hrv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mojsije uzvrati faraonu: “Dostoj se odrediti mi kad hoćeš da molim za te, za tvoje službenike i za tvoj narod da se žabe odstrane od tebe i tvojih domova i ostanu samo u Rijeci.” ");
INSERT INTO hrv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","“Sutra”, reče. “Neka bude kako kažeš”, odvrati Mojsije, “da znaš kako nitko nije kao Jahve, Bog naš. ");
INSERT INTO hrv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Žabe će otići od tebe, od tvojih službenika i tvoga naroda; ostat će samo u Rijeci.” ");
INSERT INTO hrv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mojsije i Aron odu od faraona, a onda Mojsije zazva Jahvu zbog žaba kojima je kaznio faraona. ");
INSERT INTO hrv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","I Jahve usliša Mojsija, te žabe pocrkaju po kućama, dvorištima i njivama. ");
INSERT INTO hrv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Na hrpe su ih zgrtali, zemlja se njima usmrdjela. ");
INSERT INTO hrv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kad je faraon vidio da je nastupilo olakšanje, srce mu otvrdnu te ne posluša Mojsija i Arona, kako je Jahve i kazao. ");
INSERT INTO hrv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Onda će opet Jahve Mojsiju: “Reci Aronu neka zamahne svojim štapom i udari po prahu na tlu neka se pretvori u komarce po svoj zemlji egipatskoj.” ");
INSERT INTO hrv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","I učine tako: zamahne Aron rukom i štapom te udari po prahu na tlu. Komarci navale na ljude i životinje. Sav prah na tlu pretvori se u komarce po svoj zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Vračari pokušaše da svojim vračanjem stvore komarce, ali nisu mogli. Ljudi i životinje postanu plijenom komaraca. ");
INSERT INTO hrv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Tada vračari reknu faraonu: “To je prst Božji!” Ali je faraonovo srce bilo okorjelo, pa nije poslušao Mojsija i Arona, kako je Jahve i kazao. ");
INSERT INTO hrv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Onda Jahve reče Mojsiju: “Podrani ujutro, iziđi pred faraona kad krene k vodi, i reci mu: 'Ovako poručuje Jahve: Pusti moj narod da ode i da mi štovanje iskaže. ");
INSERT INTO hrv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ako ne pustiš moga naroda, pripustit ću obade na te, na tvoje službenike, na tvoj puk i tvoje domove. Egipatski domovi i samo tlo na kojem stoje vrvjet će od obada. ");
INSERT INTO hrv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ali ću toga dana izuzeti gošenski kraj, u kojem živi moj narod, te se ondje obadi neće pojaviti, tako da znaš da sam ja Jahve u središtu zemlje. ");
INSERT INTO hrv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Tu ću razliku napraviti između svoga i tvoga naroda. To će znamenje biti sutra.'” ");
INSERT INTO hrv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","I učini Jahve tako. Rojevi obada nalete u faraonov dvor, na domove njegovih službenika i po svoj zemlji egipatskoj. Zemlja nastrada od obada. ");
INSERT INTO hrv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Sad faraon pozove Mojsija i Arona pa im rekne: “Idite, prinesite žrtvu svome Bogu, ali u ovoj zemlji.” ");
INSERT INTO hrv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“Ne dolikuje da tako učinimo”, odgovori Mojsije. “Žrtve koje mi prinosimo Jahvi, Bogu svome, za Egipćane su svetogrđe. Kad bismo, dakle, na njihove oči prinosili žrtve koje su Egipćanima svetogrdne, zar nas ne bi kamenovali? ");
INSERT INTO hrv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Zato moramo u pustinju tri dana hoda te prinijeti žrtvu Jahvi, Bogu svome, kako nam je zapovjedio.” ");
INSERT INTO hrv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","“Pustit ću vas da odete u pustinju”, odgovori faraon, “i prinesete žrtvu Jahvi, svome Bogu, ali ne odlazite predaleko. Molite za me!” ");
INSERT INTO hrv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Nato odvrati Mojsije: “Čim odem od tebe, zazvat ću Jahvu da sutra nestane obada s faraona, njegovih službenika i njegova puka. Ali neka faraon više ne vara! Neka pusti narod da ide i prinese žrtvu Jahvi.” ");
INSERT INTO hrv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Tako Mojsije ode od faraona i pomoli se Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","I Jahve učini kako je Mojsije tražio: s faraona, s njegovih službenika i s njegova puka nestane obada - ni jedan jedini nije ostao. ");
INSERT INTO hrv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ali opet ukruti faraon srce svoje i ne dopusti narodu da ode. ");
INSERT INTO hrv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Tada Jahve reče Mojsiju: “Idi k faraonu i reci mu: 'Ovako poručuje Jahve, Bog Hebreja: Pusti moj narod da ode i da mi štovanje iskaže. ");
INSERT INTO hrv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ako ga ne pustiš, nego ga i dalje budeš zadržavao, ");
INSERT INTO hrv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ruka Jahvina udarit će strašnim pomorom po tvome blagu što je u polju: po konjima, magaradi, devama, krupnoj i sitnoj stoci. ");
INSERT INTO hrv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Razlikovat će Jahve stoku Izraelaca od stoke Egipćana, tako da ništa što pripada Izraelcima neće stradati.'” ");
INSERT INTO hrv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Jahve je odredio i vrijeme, rekavši: “Sutra će Jahve izvesti ovo u zemlji.” ");
INSERT INTO hrv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Sutradan Jahve tako i učini. Sva stoka Egipćana ugine, a od stoke Izraelaca nije uginulo ni jedno grlo. ");
INSERT INTO hrv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraon je istraživao i uvjerio se da od izraelske stoke nije uginulo ni jedno grlo. Ali je srce faraonovo ipak otvrdlo i nije pustio naroda. ");
INSERT INTO hrv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Reče Jahve Mojsiju i Aronu: “Zagrabite pune pregršti pepela iz peći, pa neka ga Mojsije pred faraonovim očima baci prema nebu. ");
INSERT INTO hrv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Od toga će nastati sitna prašina po svoj zemlji egipatskoj, i na ljudima će i na životinjama izazivati otekline i stvarati čireve s kraja na kraj Egipta.” ");
INSERT INTO hrv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Tako oni uzeše pepela iz peći i dođoše pred faraona. Onda Mojsije rasu pepeo prema nebu, a otekline s čirevima prekriše ljude i životinje. ");
INSERT INTO hrv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ni čarobnjaci se nisu mogli pojaviti pred Mojsijem, jer su i čarobnjaci, kao i ostali Egipćani, bili prekriveni čirevima. ");
INSERT INTO hrv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ali je Jahve otvrdnuo srce faraonu, pa on ne posluša Mojsija i Arona, kako je Jahve Mojsiju i rekao. ");
INSERT INTO hrv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Tada Jahve reče Mojsiju: “Podrani ujutro, iziđi pred faraona i reci mu: 'Ovako poručuje Jahve, Bog Hebreja: Pusti narod da ode i da mi štovanje iskaže. ");
INSERT INTO hrv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ako ih ne pustiš, sva zla svoja navalit ću ovaj put na te, na tvoje službenike i tvoj puk, tako da spoznaš da nema nikoga na svoj zemlji kao što sam ja. ");
INSERT INTO hrv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Da sam ruku svoju spustio i udario tebe i tvoj puk pomorom, nestalo bi te sa zemlje. ");
INSERT INTO hrv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Poštedio sam te da ti pokažem svoju moć i da se hvali moje ime po svoj zemlji. ");
INSERT INTO hrv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ali se ti previše uzdižeš nad mojim narodom i priječiš mu da ode. ");
INSERT INTO hrv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Sutra u ovo doba pustit ću tuču tako strašnu kakve u Egiptu još nije bilo otkad je postao do sada. ");
INSERT INTO hrv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Zato naredi da pod krov utjeraju tvoje blago i sve što je vani, na otvorenu. Sve što se nađe u polju, bilo čovjek bilo živinče, ne bude li uvedeno unutra, poginut će kad tuča zaspe po njima.'” ");
INSERT INTO hrv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Faraonovi službenici, koji su se pobojali Jahvina govora, utjeraju svoje sluge i svoje blago unutra. ");
INSERT INTO hrv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Oni koji nisu marili za Jahvinu prijetnju ostave vani i svoje sluge i stoku. ");
INSERT INTO hrv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Onda rekne Jahve Mojsiju: “Pruži ruku prema nebu da udari tuča po svoj zemlji egipatskoj: po ljudima, životinjama i svemu bilju u zemlji egipatskoj.” ");
INSERT INTO hrv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mojsije diže svoj štap prema nebu. Jahve zagrmje i pusti tuču i munje sastavi sa zemljom. Sipao je Jahve tuču po zemlji Egipćana. ");
INSERT INTO hrv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tuča je mlatila, kroz nju munje parale. Strahota se takva nije oborila na zemlju egipatsku otkako su ljudi u njoj. ");
INSERT INTO hrv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tuča pobi po svem Egiptu sve što je ostalo vani, ljude i životinje; uništi sve bilje po poljima i sva stabla poljska polomi. ");
INSERT INTO hrv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Samo u gošenskom kraju, gdje su živjeli Izraelci, nije bilo tuče. ");
INSERT INTO hrv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Faraon posla po Mojsija i Arona pa im reče: “Ovaj put priznajem da sam kriv. Jahve ima pravo, a ja i moj narod krivo. ");
INSERT INTO hrv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Molite Jahvu da ustavi gromove i tuču, a ja ću vas pustiti da idete. Nećete više dugo ostati.” ");
INSERT INTO hrv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","“Kad iziđem iz grada”, reče mu Mojsije, “dići ću ruke prema Jahvi, pa će gromovi prestati, a ni tuče više neće biti, tako da znaš da zemlja pripada Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ali ni ti ni tvoji dvorani, znam ja, još se ne bojite Boga Jahve.” ");
INSERT INTO hrv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","I tako propade lan i ječam: jer ječam bijaše u klasu, a lan u cvatu. ");
INSERT INTO hrv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pšenica i raž nisu nastradali jer su ozima žita. ");
INSERT INTO hrv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Otišavši od faraona, Mojsije iziđe iz grada i podigne ruke prema Jahvi. Prestane grmljavina i tuča, a ni kiša više nije padala na zemlju. ");
INSERT INTO hrv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kad je faraon vidio da je prestala grmljavina, tuča i kiša, opet padne u grijeh: i on i njegovi službenici opet otvrdnu srcem. ");
INSERT INTO hrv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Otvrdnu srce faraonu i ne pusti on Izraelce, kako je Jahve i prorekao preko Mojsija. ");
INSERT INTO hrv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Reče Jahve Mojsiju: “Idi k faraonu. Učinio sam da njemu i njegovim službenicima otvrdne srce da izvedem svoja znamenja među njima; ");
INSERT INTO hrv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","da možeš pripovjedati svome sinu i svome unuku što sam učinio Egipćanima i kakva sam znamenja izvodio među njima, kako biste znali da sam ja Jahve.” ");
INSERT INTO hrv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Tako Mojsije i Aron odu k faraonu i kažu mu: “Ovako poručuje Jahve, Bog Hebreja: 'Dokle ćeš odbijati da se preda mnom poniziš? Pusti moj narod da mi iskaže štovanje. ");
INSERT INTO hrv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Jer ako ne pustiš moga naroda, sutra ću navesti skakavce na tvoju zemlju. ");
INSERT INTO hrv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Tako će prekriti površinu da se zemlja od njih neće vidjeti. Pojest će ono što vam je iza tuče ostalo; i ogolit će vam sva stabla što po polju rastu. ");
INSERT INTO hrv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ispunit će ti sav dvor, kuće tvojih službenika i domove svih ostalih Egipćana - takvo što ne vidješe ni tvoji očevi ni očevi tvojih očeva u ovoj zemlji od svojih vremena do danas.'” Okrene se i ode od faraona. ");
INSERT INTO hrv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","“Dokle će nam ovaj čovjek biti stupica?” - rekoše faraonu njegovi službenici. - “Pusti te ljude neka idu i iskažu štovanje Jahvi, svome Bogu! Zar ne vidiš kako Egipat srlja u propast?” ");
INSERT INTO hrv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Dovedu Mojsija i Arona natrag k faraonu, a on im reče: “Idite! Iskažite štovanje Jahvi, svome Bogu! A tko će sve ići?” ");
INSERT INTO hrv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","“Svi idemo”, odgovori Mojsije, “i mlado i staro. Odlazimo sa svojim sinovima i svojim kćerima; sa svojom krupnom i sitnom stokom, jer moramo održati svečanost Jahvi.” ");
INSERT INTO hrv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","“Jahve bio s vama isto kao što i ja pustio da s vama pođu i djeca!” - odgovori im. “Očito se vidi da vam nakana nije čista. ");
INSERT INTO hrv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nećemo tako! Nego muškarci neka odu i štovanje iskažu Jahvi. To ste i tražili.” I otjeraju ih od faraona. ");
INSERT INTO hrv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Tada reče Jahve Mojsiju: “Pruži ruku povrh zemlje egipatske da navale skakavci na egipatsku zemlju i pojedu sve bilje što još ostade nakon tuče!” ");
INSERT INTO hrv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Tako Mojsije podigne svoj štap povrh egipatske zemlje, a Jahve navrati istočni vjetar po zemlji; puhao je toga cijelog dana i cijele noći. A kad je jutro svanulo, vjetar nanio skakavce. ");
INSERT INTO hrv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Oni se razlete po svoj egipatskoj zemlji i padnu po svim krajevima Egipta u silnoj gustoći: toliko ih mnoštvo nikad prije nije bilo niti će kada biti. ");
INSERT INTO hrv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Pokriju sve tlo, tako da se od njih zacrnjelo. Pojedu sve bilje u polju i sve plodove sa stabala što su bili ostali iza tuče. Ništa se više nije zelenjelo: ni stabla ni poljska trava u svem Egiptu. ");
INSERT INTO hrv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Brže-bolje dozva faraon Mojsija i Arona pa im reče: “Sagriješio sam protiv Jahve, vašega Boga, i vas! ");
INSERT INTO hrv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Oprostite mi uvredu još samo ovaj put i molite Jahvu, Boga svoga, da samo otkloni od mene ovaj smrtonosni bič!” ");
INSERT INTO hrv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kad je Mojsije otišao od faraona, zazva Jahvu ");
INSERT INTO hrv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","i Jahve promijeni vjetar u veoma jak zapadnjak, koji pothvati skakavce i odnese prema Crvenome moru. Ni jedan jedini skakavac nije ostao ni u kojem kraju Egipta. ");
INSERT INTO hrv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ali je Jahve otvrdnuo srce faraonu i ne pusti on Izraelaca. ");
INSERT INTO hrv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","“Pruži ruku prema nebu”, rekne Jahve Mojsiju, “pa neka se tmina spusti na egipatsku zemlju, tmina koja će se moći opipati.” ");
INSERT INTO hrv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mojsije pruži ruku prema nebu i spusti se gusta tmina na svu zemlju egipatsku: tri je dana trajala. ");
INSERT INTO hrv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tri dana nisu ljudi jedan drugoga mogli vidjeti i nitko se sa svoga mjesta nije micao. A u mjestima gdje su Izraelci živjeli sjala svjetlost. ");
INSERT INTO hrv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pozva onda faraon Mojsija i reče: “Idi i štovanje iskaži Jahvi! Ali vaša stoka, krupna i sitna, neka ostane ovdje. Vaša djeca neka idu s vama!” ");
INSERT INTO hrv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","“Ti nas sam moraš opskrbiti prinosima i žrtvama paljenicama koje ćemo prinijeti Jahvi, Bogu svojemu”, odgovori Mojsije. ");
INSERT INTO hrv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","“Zato ćemo sa sobom potjerati i svoja stada. Ni papak neće ostati ovdje. Od njih nam valja izabrati za žrtvovanje Jahvi, Bogu našemu, a ne znamo, dok onamo ne stignemo, što moramo Jahvi prinijeti.” ");
INSERT INTO hrv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Jahve otvrdne faraonu srce i on ne pristane da odu. ");
INSERT INTO hrv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","“Odlazi!” - vikne faraon na Mojsija. “I da mi više na oči ne dolaziš! Onoga dana kad mi se opet pojaviš na oči, zaglavit ćeš!” ");
INSERT INTO hrv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","“Dobro si kazao!” - uzvrati Mojsije. “Lica tvoga više neću vidjeti!” ");
INSERT INTO hrv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","“Još ću samo jednom nedaćom udariti faraona i Egipat”, reče Jahve Mojsiju. “Poslije toga pustit će vas odavde. I više: sam će vas odavde potjerati. ");
INSERT INTO hrv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kaži svijetu neka svaki čovjek ište od svoga susjeda i svaka žena od svoje susjede srebrnih i zlatnih dragocjenosti.” ");
INSERT INTO hrv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Jahve učini te Egipćani bijahu naklonjeni narodu. Sam Mojsije postane vrlo uvažen u egipatskoj zemlji, u očima faraonovih službenika i u očima naroda. ");
INSERT INTO hrv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","A onda Mojsije navijesti: “Ovako poručuje Jahve: 'O ponoći proći ću Egiptom. ");
INSERT INTO hrv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Svaki će prvorođenac u egipatskoj zemlji umrijeti, od prvorođenca faraonova, koji bi imao sjediti na njegovu prijestolju, do prvorođenca ropkinje koja se nalazi uz mlinski kamen; a uginut će i sve prvine od stoke. ");
INSERT INTO hrv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","U svoj će zemlji egipatskoj nastati veliki jauk, kakva nije bilo niti će kad poslije biti. ");
INSERT INTO hrv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Među Izraelcima ni pas neće zalajati na živo stvorenje: ni na čovjeka ni na životinju.' Po tome ćete znati da Jahve luči Izraelca od Egipćanina. ");
INSERT INTO hrv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Onda će svi ovi tvoji dvorani k meni doći, preda me se baciti i vikati: Nosi se i ti i sav puk koji za tobom ide! Poslije toga ću otići.” I gnjevan ode od faraona. ");
INSERT INTO hrv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","“Neće vas faraon poslušati”, reče Jahve Mojsiju, “a to da bi se umnožila moja znamenja u zemlji egipatskoj.” ");
INSERT INTO hrv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mojsije i Aron izveli su sva ta znamenja pred faraonom, ali je Jahve okorio srce faraonu, tako te on nije puštao Izraelaca da odu iz njegove zemlje. ");
INSERT INTO hrv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Jahve reče Mojsiju i Aronu u zemlji egipatskoj: ");
INSERT INTO hrv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ovaj mjesec neka vam bude početak mjesecima; neka vam bude prvi mjesec u godini. ");
INSERT INTO hrv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ovo objavite svoj zajednici izraelskoj: Desetog dana ovoga mjeseca neka svatko za obitelj pribavi jedno živinče. Tako, jedno na obitelj. ");
INSERT INTO hrv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ako je obitelj premalena da ga potroši, neka se ona priključi svome susjedu, najbližoj kući, prema broju osoba. Podijelite živinče prema tome koliko koja osoba može pojesti. ");
INSERT INTO hrv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Živinče neka bude bez mane, od jedne godine i muško. Možete izabrati bilo janje bilo kozle. ");
INSERT INTO hrv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Čuvajte ga do četrnaestoga dana ovoga mjeseca. A onda neka ga sva izraelska zajednica zakolje kad se spusti suton. ");
INSERT INTO hrv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Neka uzmu krvi i poškrope oba dovratnika i nadvratnik kuće u kojoj se bude blagovalo. ");
INSERT INTO hrv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Meso, pečeno na vatri, neka se pojede te iste noći sa beskvasnim kruhom i gorkim zeljem. ");
INSERT INTO hrv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Da ništa sirovo ili na vodi skuhano od njega niste jeli, nego na vatri pečeno: s glavom, nogama i ponutricom. ");
INSERT INTO hrv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ništa od njega ne smijete ostaviti za sutradan: što bi god do jutra ostalo, morate na vatri spaliti. ");
INSERT INTO hrv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","A ovako ga blagujte: opasanih bokova, s obućom na nogama i sa štapom u ruci. Jedite ga žurno: to je Jahvina pasha. ");
INSERT INTO hrv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Te ću, naime, noći ja proći egipatskom zemljom i pobiti sve prvorođence u zemlji egipatskoj - i čovjeka i životinju. Ja, Jahve, kaznit ću i sva egipatska božanstva. ");
INSERT INTO hrv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Krv neka označuje kuće u kojima vi budete. Gdje god spazim krv, proći ću vas; tako ćete vi izbjeći biču zatornomu kad se oborim na zemlju egipatsku.” ");
INSERT INTO hrv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Taj dan neka vam bude spomen-dan. Slavite ga kao blagdan u čast Jahvi. Svetkujte ga po trajnoj uredbi od koljena do koljena. ");
INSERT INTO hrv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sedam dana jedite beskvasan kruh. Prvoga već dana uklonite kvasac iz svojih kuća. Jer, tko bi god od prvoga do sedmoga dana jeo ukvasan kruh, taj se ima iskorijeniti između Izraelaca. ");
INSERT INTO hrv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Prvoga dana držite sveto zborovanje, a tako i sedmoga dana. Nikakva posla tih dana nemojte raditi. Jedino jelo, što kome treba, možete pripraviti. ");
INSERT INTO hrv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Držite blagdan beskvasnog kruha! Toga sam, naime, dana izveo vaše čete iz zemlje egipatske. Držite zato taj dan kao blagdan od koljena do koljena: to je vječna naredba. ");
INSERT INTO hrv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Od večeri četrnaestoga dana prvoga mjeseca pa do večeri dvadeset prvoga dana toga mjeseca jedite beskvasan kruh. ");
INSERT INTO hrv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sedam dana ne smije biti kvasca u vašim domovima. Tko bi god jeo bilo što ukvasano, taj neka se ukloni iz izraelske zajednice, bio stranac ili domorodac. ");
INSERT INTO hrv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ništa ukvasano ne smijete jesti: u svim svojim prebivalištima jedite nekvasan kruh.” ");
INSERT INTO hrv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Zatim sazva Mojsije sve starješine Izraelaca te im reče: “Idite i pribavite janje za svoje obitelji i žrtvujte Pashu. ");
INSERT INTO hrv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Onda uzmite kitu izopa, zamočite je u krv što je u zdjeli i poškropite krvlju iz zdjele nadvratnik i oba dovratnika. Neka nitko ne izlazi preko kućnih vrata do jutra. ");
INSERT INTO hrv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Kad Jahve bude prolazio da pobije Egipćane, zapazit će krv na nadvratniku i na oba dovratnika, pa će mimoići ta vrata i neće dopustiti da Zatornik uđe u vaše kuće da hara. ");
INSERT INTO hrv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ovu uredbu držite u svim vremenima kao zakon za se i djecu svoju. ");
INSERT INTO hrv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","I kad dođete u zemlju koju će vam Jahve dati kako je obećao, vršite ovaj obred. ");
INSERT INTO hrv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kad vas vaša djeca zapitaju: Što vam taj obred označuje? ");
INSERT INTO hrv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","odgovorite im: Ovo je pashalna žrtva u čast Jahvi koji je prolazio mimo kuće Izraelaca kad je usmrćivao Egipćane, a naše kuće pošteđivao.” Tada narod popada ničice i pokloni se. ");
INSERT INTO hrv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Potom Izraelci odu i poslušaju: kako je Jahve Mojsiju i Aronu naredio, tako i učine. ");
INSERT INTO hrv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","U ponoći Jahve pobije sve prvorođence po zemlji egipatskoj: od prvorođenca faraonova, koji je imao sjediti na prijestolju, do prvorođenca sužnja u tamnici, a tako i sve prvine od stoke. ");
INSERT INTO hrv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Noću ustane faraon, on pa svi njegovi dvorani i svi Egipćani, jer se strašan jauk razlijegao Egiptom: ne bijaše kuće u kojoj nije ležao mrtvac. ");
INSERT INTO hrv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Faraon pozva u noći Mojsija i Arona te im reče: “Ustajte i odlazite od moga naroda i vi i vaši Izraelci! Idite! Odajte štovanje Jahvi, kako ste tražili. ");
INSERT INTO hrv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Pokupite svoju i sitnu i krupnu stoku, kako ste zahtijevali: idite pa i mene blagoslovite!” ");
INSERT INTO hrv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egipćani nagonili narod da brže ide iz zemlje, “jer izgibosmo svi”, govorahu oni. ");
INSERT INTO hrv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Tako narod ponese svoje još neukislo tijesto; naćve, uvijene u ogrtače, ponesoše na ramenima. ");
INSERT INTO hrv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","I učiniše Izraelci kako im je Mojsije bio rekao: zatražiše od Egipćana srebrnine, i zlatnine, i odjeće. ");
INSERT INTO hrv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Jahve je učinio te Egipćani bijahu naklonjeni narodu pa davahu. Tako su Egipćane oplijenili. ");
INSERT INTO hrv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Pođu tako Izraelci iz Ramsesa prema Sukotu. Bilo je oko šest stotina tisuća pješaka, osim žena i djece. ");
INSERT INTO hrv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","A mnogo i drugoga svijeta pođe s njima, i mnoga stoka, krupna i sitna. ");
INSERT INTO hrv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ispeku beskvasne prevrte od tijesta što su ga iz Egipta ponijeli: nije se bilo ukvasalo. A kako su bili tjerani iz Egipta, nisu mogli odgađati, i tako nisu sebi spremili poputninu. ");
INSERT INTO hrv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Vrijeme što su ga Izraelci proveli u Egiptu iznosilo je četiri stotine i trideset godina. ");
INSERT INTO hrv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","I kad se navrši četiri stotine i trideset godina - točno onoga dana - sve čete Jahvine iziđoše iz zemlje egipatske. ");
INSERT INTO hrv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ona noć koju je Jahve probdio da njih izbavi iz Egipta, odonda je svima Izraelcima, u sve naraštaje njihove, noć bdjenja u čast Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Reče Jahve Mojsiju i Aronu: “Neka je ovo pravilo za pashalnu žrtvu: ni jedan stranac ne smije od nje jesti! ");
INSERT INTO hrv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Svaki rob, kupljen novcem i obrezan, može je jesti. ");
INSERT INTO hrv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ni gost ni najamnik ne smiju je jesti! ");
INSERT INTO hrv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Blagujte je u jednoj te istoj kući; iz kuće ne smijete iznositi mesa niti na žrtvi smijete koju kost slomiti. ");
INSERT INTO hrv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Sva zajednica Izraelaca neka je prikazuje! ");
INSERT INTO hrv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ako bi stranac koji među vama boravi htio svetkovati Pashu u čast Jahvi, svi se njegovi muški moraju obrezati. Tek tada neka pristupi i slavi je, jer je tada kao i domorodac zemlje. Ali neobrezani ne smije od nje jesti. ");
INSERT INTO hrv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Neka vrijedi isto pravilo za domoroca i pridošlicu koji među vama boravi.” ");
INSERT INTO hrv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Svi Izraelci poslušaju: kako je Jahve naredio Mojsiju i Aronu, tako su i učinili. ");
INSERT INTO hrv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Toga istog dana izbavio je Jahve Izraelce u njihovim četama iz zemlje egipatske. ");
INSERT INTO hrv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Meni posvetite svakoga prvorođenca! Prvenci materina krila kod Izraelaca, i od ljudi i od životinja, meni pripadaju!” ");
INSERT INTO hrv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","A onda Mojsije reče narodu: “Sjećajte se ovoga dana u koji ste izbavljeni iz Egipta, iz kuće ropstva, jer vas Jahve izbavi odande svojom jakom mišicom. Ukvasani kruh neka se ne jede! ");
INSERT INTO hrv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ovoga dana mjeseca Abiba vaše je izbavljenje. ");
INSERT INTO hrv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Stoga: kad te Jahve uvede u zemlju Kanaanaca, Hetita, Amorejaca, Hivijaca i Jebusejaca, za koju se zakleo tvojim precima da će ti je dati - zemlju kojom teče med i mlijeko - ovoga mjeseca obavi ovakav obred: ");
INSERT INTO hrv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","sedam dana jedi nekvasan kruh, a sedmoga dana neka se slavi svetkovina u čast Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Sedam dana neka se jede nekvasan kruh; ukvasanog kruha neka ne bude kod tebe; i neka se nigdje ne vidi kvasac na tvome području. ");
INSERT INTO hrv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Svome sinu toga dana objasni: to je za ono što mi je Jahve učinio kad sam se iz Egipta izbavio. ");
INSERT INTO hrv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Neka ti bude kao znak na tvojoj ruci i kao opomena na tvome čelu: da Jahvin zakon bude uvijek na tvojim ustima. Jer te rukom jakom Jahve izbavio iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ovaj propis vršite svake godine u određeno vrijeme.” ");
INSERT INTO hrv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“A kada te Jahve dovede u zemlju Kanaanaca - kako vam se zakle, tebi i tvojim ocima - i kada ti je preda, ");
INSERT INTO hrv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ustupajte Jahvi prvorođence materinjega krila, a tako i sve prvine što ih tvoja stoka dade - svako muško pripada Jahvi! ");
INSERT INTO hrv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Svaku prvinu magaradi otkupi janjetom ili jaretom. Ako je ne otkupiš, slomi joj vrat. A svakoga prvorođenca između svoje djece otkupi. ");
INSERT INTO hrv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Kad te sin tvoj sutra zapita: Što znači to? - odgovori mu: Rukom jakom izvede nas Jahve iz Egipta, iz kuće ropstva. ");
INSERT INTO hrv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Kako je faraon postao tvrdokoran pa nas nije htio pustiti, Jahve je poubijao sve prvorođence u zemlji egipatskoj: prvorođence ljudi i prvine stoke. Eto zato Jahvi žrtvujem svaku mušku prvinu materinjega krila, a svakoga prvorođenca od svojih sinova otkupljujem. ");
INSERT INTO hrv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Neka ti to bude kao znak na tvojoj ruci i kao znamenje posred čela da nas je rukom jakom Jahve izbavio iz Egipta.” ");
INSERT INTO hrv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kad je faraon dopustio da narod ode, Bog ih nije poveo prema filistejskoj zemlji, iako je onuda bilo najbliže. Bog je, naime, rekao: “Mogao bi se narod predomisliti i vratiti u Egipat kad vidi ratovanje.” ");
INSERT INTO hrv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Stoga Bog povede narod zaobilaznim putem, kroz pustinju prema Crvenome moru. Izraelci su napustili zemlju egipatsku naoružani od glave do pete. ");
INSERT INTO hrv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mojsije ponese sa sobom Josipove kosti. Jer Josip bijaše zakleo Izraelce riječima: “Bog će se zacijelo za vas zauzeti. Tada i moje kosti odavde ponesite sa sobom!” ");
INSERT INTO hrv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Krenuvši iz Sukota, utabore se u Etamu, na kraju pustinje. ");
INSERT INTO hrv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Jahve je išao pred njima, danju u stupu od oblaka da im put pokazuje, a noću u stupu od ognja da im svijetli. Tako su mogli putovati i danju i noću. ");
INSERT INTO hrv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","I nije ispred naroda nestajao stup od oblaka danju ni stup od ognja noću. ");
INSERT INTO hrv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Reci Izraelcima da se vrate i utabore pred Pi-Hahirotom, između Migdola i mora, nasuprot Baal-Sefonu. Utaborite se nasuprot ovome mjestu, uz more. ");
INSERT INTO hrv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faraon će reći: 'Izraelci lutaju krajem tamo-amo; pustinja ih zatvorila.' ");
INSERT INTO hrv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ja ću otvrdnuti faraonu srce, i on će za njima poći u potjeru. Ali ja ću se proslaviti nad faraonom i svom njegovom vojskom. Tako će Egipćani spoznati da sam ja Jahve.” Izraelci tako učine. ");
INSERT INTO hrv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kad su egipatskom kralju kazali da je narod pobjegao, faraon i njegovi dvorani predomisliše se o narodu. “Što ovo učinismo!” - rekoše. “Pustismo Izraelce i više nam neće služiti.” ");
INSERT INTO hrv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Zato opremi faraon svoja kola i povede svoju vojsku. ");
INSERT INTO hrv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Uze šest stotina svojih kola sve poizbor i ostala kola po Egiptu. I u svima bijahu štitonoše. ");
INSERT INTO hrv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Jahve otvrdnu srce faraonu, kralju egipatskom, te on krenu u potjeru za Izraelcima, koji su otišli uzdignute pesnice. ");
INSERT INTO hrv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Egipćani, dakle, pođu za njima u potjeru. I dok su Izraelci taborovali uz more, blizu Pi-Hahirota nasuprot Baal-Sefonu, stignu ih svi faraonovi konji pod kolima, njegovi konjanici i njegovi ratnici. ");
INSERT INTO hrv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kako se faraon približavao, Izraelci pogledaju i opaze da su Egipćani za njima u potjeri, pa ih obuzme velik strah. I poviču Izraelci Jahvi: ");
INSERT INTO hrv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","“Zar nije bilo grobova u Egiptu”, reknu Mojsiju, “pa si nas izveo da pomremo u pustinji? Kakvu si nam uslugu učinio što si nas izveo iz Egipta! ");
INSERT INTO hrv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Zar ti nismo rekli baš ovo u Egiptu: Pusti nas! Služit ćemo Egipćane! Bolje nam je i njih služiti nego u pustinji poginuti.” ");
INSERT INTO hrv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","“Ne bojte se!” - reče Mojsije narodu. “Stojte čvrsto pa ćete vidjeti što će vam Jahve učiniti da vas danas spasi: Egipćane koje danas vidite nikad više nećete vidjeti. ");
INSERT INTO hrv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Jahve će se boriti za vas. Budite mirni!” ");
INSERT INTO hrv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","“Zašto zapomažete prema meni?” - reče Jahve Mojsiju. “Reci Izraelcima da krenu na put. ");
INSERT INTO hrv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","A ti podigni svoj štap, ispruži svoju ruku nad morem i razdijeli ga nadvoje da Izraelci mogu proći posred mora po suhu. ");
INSERT INTO hrv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ja ću otvrdnuti srce Egipćana, i oni će poći za njima, a ja ću se onda proslaviti nad faraonom i njegovim ratnicima, njegovim kolima i konjanicima. ");
INSERT INTO hrv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Neka znaju Egipćani da sam ja Jahve kad se proslavim nad faraonom, njegovim kolima i njegovim konjanicima.” ");
INSERT INTO hrv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Anđeo Božji, koji je išao na čelu izraelskih četa, promijeni mjesto i stupi im za leđa. A i stup od oblaka pomakne se ispred njih i stade im za leđa. ");
INSERT INTO hrv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Smjesti se između vojske egipatske i vojske izraelske te postade onima oblak taman, a ovima rasvjetljivaše noć, tako te ne mogoše jedni drugima prići cijele noći. ");
INSERT INTO hrv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mojsije je držao ruku ispruženu nad morem dok je Jahve svu noć na stranu valjao vode jakim istočnim vjetrom i more posušio. Kad su se vode razdvojile, ");
INSERT INTO hrv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Izraelci siđoše u more na osušeno dno, a vode stajahu kao bedem njima nadesno i nalijevo. ");
INSERT INTO hrv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Egipćani: svi faraonovi konji, kola i konjanici, nagnu za njima u more, u potjeru. ");
INSERT INTO hrv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Za jutarnje straže pogleda Jahve iz stupa od ognja i oblaka na egipatsku vojsku i u njoj stvori zbrku. ");
INSERT INTO hrv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Zakoči točkove njihovih kola da su se jedva naprijed micali. “Bježimo od Izraelaca!” - poviču Egipćani, “jer Jahve se za njih bori protiv Egipćana!” Tada će Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","“Pruži ruku nad more da se vode vrate na Egipćane, na njihova kola i konjanike.” ");
INSERT INTO hrv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mojsije pruži ruku nad more i u cik zore more se vrati u svoje korito. Kako su Egipćani, bježeći, jurili prema moru, Jahve ih strmoglavi usred voda. ");
INSERT INTO hrv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tako vode, slijevajući se natrag, potope kola, konjanike i svu vojsku faraonovu koja bijaše pošla u potjeru za Izraelcima - u more. I ne ostade od njih ni jedan jedini. ");
INSERT INTO hrv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","A Izraelci išli suhim posred mora, vode im stale kao zid zdesna i slijeva. ");
INSERT INTO hrv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tako Jahve u onaj dan izbavi Izraela iz šaka egipatskih, i vidje Izrael pomorene Egipćane na morskome žalu. ");
INSERT INTO hrv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Osvjedoči se Izrael i o silnoj moći koju Jahve pokaza nad Egipćanima. Narod se poboja Jahve i povjerova Jahvi i njegovu sluzi Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tada Mojsije s Izraelcima zapjeva ovu pjesmu Jahvi u slavu: “U čast Jahvi zapjevat ću, jer se slavom proslavio! Konja s konjanikom u more je survao. ");
INSERT INTO hrv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Moja je snaga, moja pjesma - Jahve jer je mojim postao izbaviteljem. On je Bog moj, njega ja ću slaviti, on je Bog oca moga, njega ću veličati. ");
INSERT INTO hrv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Jahve je ratnik hrabar, Jahve je ime njegovo. ");
INSERT INTO hrv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Kola faraonova i vojsku mu u more baci; cvijet njegovih štitonoša More crveno proguta. ");
INSERT INTO hrv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Valovi ih prekriše; poput kamena u morske potonuše dubine. ");
INSERT INTO hrv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Desnica tvoja, Jahve, snagom se prodiči; desnica tvoja, Jahve, raskomada dušmana. ");
INSERT INTO hrv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Veličanstvom svojim obaraš ti protivnike; puštaš svoj gnjev i on ih k'o slamu proždire. ");
INSERT INTO hrv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Od daha iz tvojih nosnica vode narastoše, valovi se u bedem uzdigoše, u srcu mora dubine se stvrdnuše. ");
INSERT INTO hrv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mislio je neprijatelj: 'Gonit ću ih, stići, plijen ću podijelit', duša će moja sita ga biti; trgnut ću mač, uništit' ih rukom svojom.' ");
INSERT INTO hrv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","A ti dahom svojim dahnu, more se nad njima sklopi; k'o olovo potonuše silnoj vodi u bezdane. ");
INSERT INTO hrv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Tko je kao ti, Jahve među bogovima, tko kao ti sija u svetosti, u djelima strašan, divan u čudima? ");
INSERT INTO hrv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Desnicu si pružio i zemlja ih proguta! ");
INSERT INTO hrv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Milošću svojom vodio si ovaj narod, tobom otkupljen, k svetom tvom Stanu snagom si ga svojom upravio. ");
INSERT INTO hrv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kada to čuše, prodrhtaše narodi; Filistejce muke spopadoše. ");
INSERT INTO hrv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Užas je srvao edomske glavare, trepet je obuzeo moapske knezove i tresu se svi koji žive u Kanaanu. ");
INSERT INTO hrv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Strah i prepast na njih se obaraju; snaga tvoje ruke skamenila ih je dok narod tvoj, Jahve, ne prođe, dok ne prođe narod tvoj koji si otkupio. ");
INSERT INTO hrv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Dovest ćeš ih i posaditi na gori svoje baštine, na mjestu koje ti, Jahve, svojim učini Boravištem, Svetištem, o Jahve, tvojom rukom sazidanim. ");
INSERT INTO hrv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Vazda i dovijeka Jahve će kraljevati.” ");
INSERT INTO hrv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Kad su faraonovi konji, njegova kola i konjanici sašli u more, Jahve je na njih povratio morske vode pošto su Izraelci prošli posred mora po suhu. ");
INSERT INTO hrv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Tada Aronova sestra, proročica Mirjam, uze bubanj u ruku, a sve žene pridruže joj se s bubnjem u ruci i plešući. ");
INSERT INTO hrv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mirjam je začinjala pjesmu: “Zapjevajte Jahvi jer se slavom proslavio! Konja s konjanikom u more je survao.” ");
INSERT INTO hrv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Pokrene Mojsije Izraelce od Crvenog mora i pođu na put kroz pustinju Šur. Tri su dana putovali pustinjom, a vode nisu našli. ");
INSERT INTO hrv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Dođu k Mari, ali nisu mogli piti vode kod Mare jer je bila gorka. Stoga se i zove Mara. ");
INSERT INTO hrv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Narod je mrmljao na Mojsija i govorio: “Što ćemo piti?” ");
INSERT INTO hrv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","A on zazva Jahvu. Jahve mu pokaže neko drvo. Baci on to drvo u vodu i voda postane slatka. Tu im Jahve postavi zakon i pravo i tu ih stavi u kušnju. ");
INSERT INTO hrv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Zatim reče: “Budeš li zdušno slušao glas Jahve, Boga svoga, vršeći što je pravo u njegovim očima; budeš li pružao svoje uho njegovim zapovijedima i držao njegove zakone, nikakvih bolesti koje sam pustio na Egipćane na vas neću puštati. Jer ja sam Jahve koji dajem zdravlje.” ");
INSERT INTO hrv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Zatim stignu u Elim, gdje je bilo dvanaest izvora i sedamdeset palma. Tu se, uz vodu, utabore. ");
INSERT INTO hrv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Potom krenu iz Elima, i sva izraelska zajednica dođe u pustinju Sin, koja je između Elima i Sinaja, petnaestoga dana drugoga mjeseca nakon odlaska iz zemlje egipatske. ");
INSERT INTO hrv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","U pustinji sva izraelska zajednica počne mrmljati protiv Mojsija i Arona. ");
INSERT INTO hrv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Oh, da smo pomrli od ruke Jahvine u zemlji egipatskoj kad smo sjedili kod lonaca s mesom i jeli kruha do mile volje!” - rekoše im. “Izveli ste nas u ovu pustinju da sve ovo mnoštvo gladom pomorite!” ");
INSERT INTO hrv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Tada reče Jahve Mojsiju: “Učinit ću da vam daždi kruh s neba. Neka narod ide i skuplja svaki dan koliko mu za dan treba. Tako ću ih kušati i vidjeti hoće li se držati moga zakona ili neće. ");
INSERT INTO hrv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A šestoga dana, kad spreme što su nakupili, bit će dvaput onoliko koliko su skupljali za svaki dan.” ");
INSERT INTO hrv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Onda Mojsije i Aron progovore svim Izraelcima: “Večeras ćete poznati da vas je Jahve izveo iz zemlje egipatske, ");
INSERT INTO hrv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","a ujutro ćete vidjeti svojim očima Jahvinu slavu, jer vas je čuo Jahve kako ste protiv njega mrmljali. Što smo mi da protiv nas mrmljate? ");
INSERT INTO hrv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Večeras će vam Jahve dati mesa da jedete”, nastavi Mojsije, “a ujutro kruha do mile volje, jer je Jahve čuo vaše mrmljanje protiv njega. Što smo mi? Vi ne mrmljate protiv nas nego protiv Jahve.” ");
INSERT INTO hrv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Poslije toga rekne Mojsije Aronu: “Reci svoj izraelskoj zajednici: 'Skupite se pred Jahvu, jer je čuo vaše mrmljanje!'” ");
INSERT INTO hrv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","I dok je Aron svoj izraelskoj zajednici govorio, oni se okrenu prema pustinji, i gle! u oblaku pojavi se Jahvina slava. ");
INSERT INTO hrv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Onda se Jahve oglasi Mojsiju i reče mu: ");
INSERT INTO hrv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Čuo sam mrmljanje Izraelaca. Ovako im reci: 'Večeras ćete jesti meso, a ujutro ćete se nasititi kruha. Tada ćete poznati da sam ja Jahve, Bog vaš.'” ");
INSERT INTO hrv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","I doista! Navečer se pojave prepelice i prekriju tabor. A ujutro obilna rosa sve orosila oko tabora. ");
INSERT INTO hrv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Kad se prevlaka rose digla, površinom pustinje ležao tanak sloj, nešto poput pahuljica, kao da se slana uhvatila po zemlji. ");
INSERT INTO hrv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Kad su Izraelci to vidjeli, pitali su jedan drugoga: “Što je to?” Jer nisu znali što je. Onda im Mojsije reče: “To je kruh koji vam je Jahve pribavio za hranu. ");
INSERT INTO hrv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","A ovo je zapovijed koju je Jahve izdao: 'Nakupite koliko kome treba za jelo - jedan gomer po osobi, svatko prema broju članova koji su mu u šatoru.'” ");
INSERT INTO hrv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Izraelci tako uradiše. Neki nakupe više, neki manje. ");
INSERT INTO hrv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Kad su izmjerili na gomer, pokaza se da nije ništa preteklo onome koji bijaše nakupio mnogo, a niti je nedostajalo onome koji bijaše nakupio manje: svatko je nakupio koliko mu je trebalo za jelo. ");
INSERT INTO hrv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","“Neka nitko ne ostavlja ništa za ujutro!” - rekne im Mojsije. ");
INSERT INTO hrv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ali oni nisu poslušali Mojsija; neki ostave i za sutra. A to im se ucrva i usmrdje. Mojsije se na njih razljuti. ");
INSERT INTO hrv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tako su skupljali svako jutro koliko je kome trebalo za jelo. I kad bi sunce ogrijalo, mÓana bi se rastopila. ");
INSERT INTO hrv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Onda šestoga dana nakupiše dvostruku količinu hrane - po dva gomera na svakoga. Kad su starješine zajednice došle da izvijeste Mojsija, ");
INSERT INTO hrv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","on im reče: “Ovo je zapovijed Jahvina: Sutra je dan potpunog odmora, subota Jahvi posvećena. Ispecite što želite peći; skuhajte što želite kuhati. Sve što vam preteče ostavite za sutra.” ");
INSERT INTO hrv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ostave to oni za sutra, kako je Mojsije naredio, i niti se usmrdjelo niti su se crvi pojavili. ");
INSERT INTO hrv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","“Jedite to danas”, reče im Mojsije, “jer je ovaj dan subota u čast Jahve; danas nećete naći mÓane na polju. ");
INSERT INTO hrv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Šest je dana skupljajte, a sedmoga, u subotu, neće je biti.” ");
INSERT INTO hrv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Bijaše nekih koji su i sedmoga dana išli da je nakupe, ali ništa ne nađoše. ");
INSERT INTO hrv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Zato Jahve reče Mojsiju: “Dokle ćete odbijati da se pokorite mojim zapovijedima i mojim zakonima? ");
INSERT INTO hrv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Pogledajte! Zato što vam je Jahve dao subotu, daje vam hrane šestoga dana za dva dana. Neka svatko stoji gdje jest; neka nitko u sedmi dan ne izlazi iz svoga stana.” ");
INSERT INTO hrv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tako se sedmoga dana narod odmarao. ");
INSERT INTO hrv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Dom je Izraelov tu hranu prozvao mÓanom. Bijaše kao zrno korijandra; bijela, a imala je ukus medenog kolačića. ");
INSERT INTO hrv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Onda rekne Mojsije: “Ovo je zapovijed koju je izdao Jahve: Napunite tim jedan gomer i čuvajte ga za svoje potomke da vide hranu kojom sam vas hranio u pustinji kad sam vas izbavio iz zemlje egipatske.” ");
INSERT INTO hrv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","I naredi Mojsije Aronu: “Uzmi jednu posudu; stavi u nju cio gomer mane, a onda je položi pred Jahvu da se sačuva za vaše potomke.” ");
INSERT INTO hrv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kako je Jahve naredio Mojsiju, Aron je stavi pred Svjedočanstvo na čuvanje. ");
INSERT INTO hrv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Izraelci su se hranili manom četrdeset godina, sve dok nisu došli u naseljenu zemlju: jeli su manu do dolaska na granicu zemlje kanaanske. ");
INSERT INTO hrv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Gomer je deseti dio efe. ");
INSERT INTO hrv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Sva izraelska zajednica po Jahvinoj zapovijedi krene dalje iz pustinje Sina. Utabore se kod Refidima. Tu nije bilo vode da narod pije. ");
INSERT INTO hrv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Zato narod zapodjene prepirku s Mojsijem. Vikali su: “Daj nam vode da pijemo!” A Mojsije im odgovori: “Zašto se sa mnom prepirete? Zašto kušate Jahvu?” ");
INSERT INTO hrv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ali je narod žeđao za vodom, pa je mrmljao na Mojsija i govorio: “Zašto si nas iz Egipta izveo? Zar da nas žeđom pomoriš, nas, našu djecu i našu stoku?” ");
INSERT INTO hrv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","“Što ću s ovim narodom!” - zazivao je Mojsije Jahvu. “Još malo pa će me kamenovati.” ");
INSERT INTO hrv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","“Istupi pred narod!” - rekne Jahve Mojsiju. “Uzmi sa sobom nekoliko izraelskih starješina; uzmi u ruku štap kojim si udario Rijeku i pođi. ");
INSERT INTO hrv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","A ja ću stajati pred tobom ondje, na pećini na Horebu. Udari po pećini: iz nje će poteći voda, pa neka se narod napije.” Mojsije učini tako naočigled izraelskih starješina. ");
INSERT INTO hrv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mjesto prozovu Masa i Meriba, zbog toga što su se Izraelci prepirali i kušali Jahvu govoreći: “Je li Jahve među nama ili nije?” ");
INSERT INTO hrv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Uto dođu Amalečani i zarate s Izraelcima kod Refidima. ");
INSERT INTO hrv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","A Mojsije reče Jošui: “Odaberi momčad pa pođi i zapodjeni borbu s Amalečanima. Ja ću sutra stati na vrh brda, sa štapom Božjim u ruci.” ");
INSERT INTO hrv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Jošua učini kako mu je Mojsije rekao te zađe u borbu s Amalečanima, a Mojsije, Aron i Hur uzađoše na vrh brda. ");
INSERT INTO hrv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","I dok bi Mojsije držao ruke uzdignute, Izraelci bi nadjačavali; a kad bi ruke spustio, nadjačavali bi Amalečani. ");
INSERT INTO hrv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ali Mojsiju ruke napokon klonu. Zato uzeše kamen, staviše ga poda nj i on sjede, dok mu Aron i Hur, jedan s jedne, a drugi s druge strane, držahu ruke, tako da mu izdržaše do sunčanog zalaska. ");
INSERT INTO hrv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","I Jošua oštricom mača svlada Amaleka i njegov narod. ");
INSERT INTO hrv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Onda Jahve reče Mojsiju: “Zapiši ovo u knjigu na sjećanje i utuvi u uši Jošui da ću ja spomen na Amalečane sasvim izbrisati pod nebom!” ");
INSERT INTO hrv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Podiže zatim Mojsije žrtvenik i nazva ga : Jahve mi je stijeg! ");
INSERT INTO hrv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","“Jer”, reče, “Jahvin stijeg u ruku! Jahvin je boj protiv Amalečana od naraštaja do naraštaja!” ");
INSERT INTO hrv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","A Jitro, midjanski svećenik, tast Mojsijev, ču sve što učini Bog Mojsiju i svemu izraelskom narodu i kako Jahve izbavi Izraelce iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Tada tast Mojsijev Jitro povede Siporu, Mojsijevu ženu - koju Mojsije bijaše otpustio - ");
INSERT INTO hrv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","i oba njezina sina. Jednomu je bilo ime Geršon, a to će reći: “Bijah došljak u tuđoj zemlji.” ");
INSERT INTO hrv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Drugi se zvao Eliezer, to jest: “Bog oca moga bio mi je u pomoći i spasio me od faraonova mača.” ");
INSERT INTO hrv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Tako Mojsijev tast Jitro povede k Mojsiju u pustinju, gdje se Mojsije bio utaborio na Božjem brdu, njegove sinove i njegovu ženu. ");
INSERT INTO hrv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Poruči on Mojsiju: “Ja, tvoj tast Jitro, dolazim k tebi s tvojom ženom i s oba njezina sina.” ");
INSERT INTO hrv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Izađe Mojsije u susret svome tastu; duboko mu se nakloni i zagrli ga. Pošto su se upitali za zdravlje, uđu pod šator. ");
INSERT INTO hrv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mojsije je onda pripovijedao svome tastu o svemu što je Jahve učinio faraonu i Egipćanima zbog Izraelaca; o svim nezgodama što su ih snašle na putu, ali ih je Jahve od njih izbavio. ");
INSERT INTO hrv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jitro se radovao svemu dobru koje je Jahve učinio Izraelcima i što ih je oslobodio od egipatskih šaka. ");
INSERT INTO hrv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","“Neka je hvaljen Jahve koji vas je izbavio od egipatskih šaka i od šaka faraonovih”, reče Jitro. ");
INSERT INTO hrv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","“Sada znam da je Jahve veći od svih bogova jer je izbavio narod ispod egipatske vlasti kad su s njim okrutno postupali.” ");
INSERT INTO hrv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Zatim Jitro, Mojsijev tast, prinese Bogu žrtvu paljenicu i prinos. Uto dođe Aron i sve izraelske starješine da s Mojsijevim tastom blaguju gozbu pred Bogom. ");
INSERT INTO hrv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Sutradan Mojsije sjede da kroji pravdu narodu. Narod je oko njega stajao od jutra do mraka. ");
INSERT INTO hrv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Vidjevši Mojsijev tast sav trud što ga on za narod čini, rekne mu: “Što to imaš toliko s narodom? I zašto ti sam sjediš, a sav narod stoji oko tebe od jutra do mraka?” ");
INSERT INTO hrv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","“Narod dolazi k meni”, odgovori Mojsije, “da se s Bogom posavjetuje. ");
INSERT INTO hrv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kad zađu u prepirku, dođu k meni. Ja onda rasudim između jednoga i drugoga; izložim im Božje zakone i odredbe.” ");
INSERT INTO hrv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","“Nije dobro kako radiš”, odgovori Mojsiju tast. ");
INSERT INTO hrv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","“I ti i taj narod s tobom potpuno ćete se iscrpsti. Taj je posao za te pretežak; sam ga ne možeš obavljati. ");
INSERT INTO hrv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Poslušaj me. Svjetovat ću te, i Bog će biti s tobom! Ti zastupaj narod pred Bogom; podastiri Bogu njihove razmirice. ");
INSERT INTO hrv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Poučavaj ih o zakonima i odredbama; svraćaj ih na put kojim moraju ići, upućuj ih na djela koja moraju vršiti. ");
INSERT INTO hrv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Onda proberi između svega puka ljude sposobne, bogobojazne i pouzdane, koji mrze mito, te ih postavi za glavare puku: tisućnike, stotnike, pedesetnike i desetnike. ");
INSERT INTO hrv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Neka sude narodu u svako doba. Sve veće slučajeve neka preda te iznose, a u manjima neka sami rasuđuju. Olakšaj sebi breme: neka ga oni s tobom nose. ");
INSERT INTO hrv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ako tako uradiš - i Bog ti to odobri - moći ćeš izdržati, a sav ovaj narod odlazit će kući u miru.” ");
INSERT INTO hrv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mojsije posluša savjet svoga tasta i učini sve kako ga svjetova. ");
INSERT INTO hrv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Probere Mojsije sposobnih ljudi od svih Izraelaca pa ih postavi za glavare narodu: tisućnike, stotnike, pedesetnike i desetnike. ");
INSERT INTO hrv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Oni su sudili narodu u svako doba. Teže slučajeve iznosili bi Mojsiju, a sve manje rješavali sami. ");
INSERT INTO hrv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Zatim Mojsije otpusti svoga tasta i on ode u svoju zemlju. ");
INSERT INTO hrv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Tri mjeseca nakon izlaska iz zemlje egipatske, istoga dana, stignu Izraelci u Sinajsku pustinju. ");
INSERT INTO hrv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Idući od Refidima, dođu u Sinajsku pustinju i utabore se u pustinji. Postave Izraelci tabor tu pred brdom, ");
INSERT INTO hrv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","a Mojsije se popne k Bogu. Jahve ga zovne s brda pa mu rekne: “Ovako kaži domu Jakovljevu, proglasi djeci Izraelovoj: ");
INSERT INTO hrv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","'Vi ste vidjeli što sam učinio Egipćanima; kako sam vas nosio na orlovskim krilima i k sebi vas doveo. ");
INSERT INTO hrv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Stoga, budete li mi se vjerno pokoravali i držali moj Savez, vi ćete mi biti predraga svojina mimo sve narode - tÓa moj je sav svijet! - ");
INSERT INTO hrv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","vi ćete mi biti kraljevstvo svećenika, narod svet.' Tim riječima oslovi Izraelce.” ");
INSERT INTO hrv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mojsije se vrati i sazva narodne starješine te im izloži sve što mu je Jahve naredio. ");
INSERT INTO hrv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","A sav narod uzvrati jednoglasno: “Vršit ćemo sve što je Jahve naredio.” Onda Mojsije prenese odgovor naroda Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nato Jahve reče Mojsiju: “Ja ću, evo, doći k tebi u gustom oblaku da narod čuje kad budem s tobom govorio i da ti zauvijek vjeruje.” Tako je Mojsije prenio Jahvi odgovor naroda. ");
INSERT INTO hrv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","“Pođi k narodu”, reče Jahve Mojsiju, “i posvećuj ga danas i sutra. Neka opere svoju odjeću; ");
INSERT INTO hrv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","neka bude gotov prekosutra, jer će prekosutra sići Jahve na brdo Sinaj naočigled svega puka. ");
INSERT INTO hrv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Postavi naokolo granicu za narod i izdaj naredbu: 'Pripazite da se na brdo ne penjete; da se ni podnožja ne dotičete! Tko se god brda dotakne, smrt će ga snaći. ");
INSERT INTO hrv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Nikakva ruka neka ga se ne dotakne, nego neka bude kamenjem zasut ili strijelom ustrijeljen: bio čovjek ili živinče, neka na životu ne ostane.' Na otegnuti zvuk trube neka se na brdo penju.” ");
INSERT INTO hrv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mojsije siđe s brda k narodu i poče posvećivati narod. Oni operu svoju odjeću. ");
INSERT INTO hrv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","“Budite gotovi za prekosutra!” - rekne Mojsije narodu. “Ne primičite se ženi!” ");
INSERT INTO hrv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","A prekosutra, u osvit dana, prolomi se grmljavina, munje zasijevaše, a gust se oblak nadvi nad brdo. Gromko zaječa truba, zadrhta sav puk koji bijaše u taboru. ");
INSERT INTO hrv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mojsije povede puk iz tabora u susret Bogu. Stadoše na podnožju brda. ");
INSERT INTO hrv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Brdo Sinaj zavilo se u dim jer je Jahve u obliku ognja sišao na nj. Dizao se dim kao dim iz peći. Sve se brdo silno treslo. ");
INSERT INTO hrv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Zvuk trube bivao sve jači. Mojsije je govorio, a Bog mu grmljavinom odgovarao. ");
INSERT INTO hrv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Jahve siđe na Sinajsko brdo, na vrhunac, i pozva Jahve Mojsija na vrhunac brda. Mojsije se uspe. ");
INSERT INTO hrv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Sad Jahve reče Mojsiju: “Siđi i opomeni narod da ne bi provalio prema Jahvi da ga vidi. Mnogo bi ih poginulo. ");
INSERT INTO hrv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","I sami svećenici, koji dolaze blizu Jahvi, moraju se očistiti, da ih Jahve ne uništi.” ");
INSERT INTO hrv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","“Narod se ne može popeti na brdo Sinaj”, odgovori Mojsije Jahvi, “jer si nas sam ti opomenuo: 'Postavi granice naokolo brda i proglasi ga svetim.'” ");
INSERT INTO hrv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","“Siđi pa se opet popni zajedno s Aronom”, odgovori mu Jahve. “Ali neka svećenici i narod ne navaljuju da se popnu prema Jahvi da ne izginu.” ");
INSERT INTO hrv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mojsije siđe k narodu i sve mu kaza. ");
INSERT INTO hrv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Onda Bog izgovori sve ove riječi: ");
INSERT INTO hrv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ja sam Jahve, Bog tvoj, koji sam te izveo iz zemlje egipatske, iz kuće ropstva. ");
INSERT INTO hrv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Nemoj imati drugih bogova uz mene. ");
INSERT INTO hrv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ne pravi sebi lika ni obličja bilo čega što je gore na nebu, ili dolje na zemlji, ili u vodama pod zemljom. ");
INSERT INTO hrv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ne klanjaj im se niti im služi. Jer ja, Jahve, Bog tvoj, Bog sam ljubomoran. Kažnjavam grijeh otaca - onih koji me mrze - na djeci do trećeg i četvrtog koljena, ");
INSERT INTO hrv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","a iskazujem milosrđe tisućama koji me ljube i vrše moje zapovijedi. ");
INSERT INTO hrv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ne uzimaj uzalud imena Jahve, Boga svoga, jer Jahve ne oprašta onome koji uzalud izgovara ime njegovo. ");
INSERT INTO hrv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sjeti se da svetkuješ dan subotni. ");
INSERT INTO hrv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Šest dana radi i obavljaj sav svoj posao. ");
INSERT INTO hrv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","A sedmoga je dana subota, počinak posvećen Jahvi, Bogu tvojemu. Tada nikakva posla nemoj raditi: ni ti, ni sin tvoj, ni kći tvoja, ni sluga tvoj, ni sluškinja tvoja, ni živina tvoja, niti došljak koji se nađe unutar tvojih vrata. ");
INSERT INTO hrv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ta i Jahve je šest dana stvarao nebo, zemlju i more i sve što je u njima, a sedmoga je dana počinuo. Stoga je Jahve blagoslovio i posvetio dan subotni. ");
INSERT INTO hrv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Poštuj oca svoga i majku svoju da imadneš dug život na zemlji koju ti da Jahve, Bog tvoj. ");
INSERT INTO hrv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ne ubij! ");
INSERT INTO hrv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ne učini preljuba! ");
INSERT INTO hrv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ne ukradi! ");
INSERT INTO hrv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ne svjedoči lažno na bližnjega svoga! ");
INSERT INTO hrv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ne poželi kuće bližnjega svoga! Ne poželi žene bližnjega svoga; ni sluge njegova, ni sluškinje njegove, ni vola njegova, ni magarca njegova, niti išta što je bližnjega tvoga!” ");
INSERT INTO hrv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Sav je puk bio svjedok grmljavine i sijevanja, svi čuše zvuk trube i vidješe kako se brdo dimi: gledali su i tresli se i stajali podalje. ");
INSERT INTO hrv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Onda rekoše Mojsiju: “Ti nam govori, a mi ćemo slušati. Neka nam Bog ne govori, da ne pomremo!” ");
INSERT INTO hrv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","“Ne bojte se”, reče Mojsije narodu. “Bog je došao da vas samo iskuša; da strah pred njim ostane s vama te da ne griješite.” ");
INSERT INTO hrv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Narod ostane podalje, a Mojsije pristupi gustom oblaku gdje se Bog nalazio. ");
INSERT INTO hrv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","“Ovako reci Izraelcima”, progovori Jahve Mojsiju. “Sami ste vidjeli da sam s vama govorio s neba. ");
INSERT INTO hrv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ne pravite uza me kumira od srebra niti sebi pravite kumira od zlata. ");
INSERT INTO hrv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Načini mi žrtvenik od zemlje i na njemu mi prinosi svoje žrtve paljenice i žrtve pričesnice, svoju sitnu i svoju krupnu stoku. Na svakome mjestu koje odredim da se moje ime spominje ja ću doći k tebi da te blagoslovim. ");
INSERT INTO hrv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ako mi budeš gradio kameni žrtvenik, nemoj ga graditi od klesanoga kamena, jer čim na nj spustiš svoje dlijeto, oskvrnit ćeš ga. ");
INSERT INTO hrv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ne uzlazi na moj žrtvenik po stepenicama, da se ne pokaže na njemu golotinja tvoja.” ");
INSERT INTO hrv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ovo su propisi koje treba da im izložiš: ");
INSERT INTO hrv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kad za roba kupiš jednoga Hebreja, neka služi šest godina. Sedme godine neka ode, bez otkupnine, slobodan. ");
INSERT INTO hrv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ako dođe sam, neka sam i ode; ako li je oženjen, neka s njim ide i njegova žena. ");
INSERT INTO hrv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ako mu gospodar nabavi ženu, pa mu ona rodi bilo sinova bilo kćeri, i žena i njezina djeca neka pripadnu njezinu gospodaru, a on neka ide sam. ");
INSERT INTO hrv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ali ako rob otvoreno izjavi: 'Volim svoga gospodara, svoju ženu i svoju djecu, neću da budem slobodan', ");
INSERT INTO hrv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","neka ga onda njegov gospodar dovede k Bogu. Kad ga dovede k vratima ili dovratku, neka mu gospodar šilom probuši uho i neka mu trajno ostane u službi. ");
INSERT INTO hrv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Kad čovjek proda svoju kćer za ropkinju, neka se ona ne oslobađa kao i muški robovi. ");
INSERT INTO hrv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ako se ne svidi svome gospodaru, koji ju je sebi bio odredio, neka joj dopusti da se otkupi. Nema prava prodati je strancima kad joj nije bio vjeran. ");
INSERT INTO hrv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","A ako je odredi svome sinu, neka s njome postupa kao i sa kćeri. ");
INSERT INTO hrv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ako se oženi drugom, ne smije prvoj uskraćivati hrane, odjeće ili njezinih bračnih prava. ");
INSERT INTO hrv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ne bude li joj činio ovo troje, neka je slobodna da ode bez otkupnine.” ");
INSERT INTO hrv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Tko god udari čovjeka pa ga usmrti, neka se smrću kazni. ");
INSERT INTO hrv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ali ako to ne učini hotimično, nego Bog pripusti da padne u njegovu šaku, odredit ću ti mjesto kamo može pobjeći. ");
INSERT INTO hrv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Tko hotimično navali na svoga bližnjega te ga podmuklo ubije, odvuci ga i s moga žrtvenika da se pogubi. ");
INSERT INTO hrv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Tko udari svoga oca ili svoju majku, neka se kazni smrću. ");
INSERT INTO hrv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Tko otme čovjeka - bilo da ga proda, bilo da ga u svojoj vlasti zadrži - neka se kazni smrću. ");
INSERT INTO hrv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Tko prokune svoga oca ili svoju majku, neka se kazni smrću.” ");
INSERT INTO hrv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ako se ljudi posvade, pa jedan od njih udari drugoga kamenom ili šakom, ali ovaj ne pogine nego padne u postelju, ");
INSERT INTO hrv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ali poslije ustane i mogne izlaziti, makar i sa štapom, onda onome koji ga je udario neka je oprošteno, samo neka mu plati njegov gubitak vremena i pribavi mu posvemašnje izlječenje. ");
INSERT INTO hrv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ako tko udari batinom svoga roba ili svoju ropkinju te umru pod njegovom šakom, mora snositi osvetu. ");
INSERT INTO hrv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ali ako rob preživi dan-dva, neka se osveta ne provodi, jer je rob njegovo vlasništvo. ");
INSERT INTO hrv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ako se ljudi pobiju i udare trudnu ženu te ona pobaci, ali druge štete ne bude, onda onaj koji ju je udario neka plati odštetu koju zatraži njezin muž. On neka plati kako suci odrede. ");
INSERT INTO hrv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Bude li drugog zla, neka je kazna: život za život, ");
INSERT INTO hrv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","oko za oko, zub za zub, ruka za ruku, noga za nogu, ");
INSERT INTO hrv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","opeklina za opeklinu, rana za ranu, modrica za modricu. ");
INSERT INTO hrv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Udari li tko svoga roba ili svoju ropkinju u oko i upropasti ga, neka ga oslobodi zbog oka. ");
INSERT INTO hrv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ako izbije zub svome robu - ili svojoj ropkinji - neka ga oslobodi zbog zuba.” ");
INSERT INTO hrv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kad goveče ubode čovjeka ili ženu pa ih usmrti, neka se kamenjem kamenuje. Njegovo se meso tada ne smije pojesti, a vlasniku njegovu neka je oprošteno. ");
INSERT INTO hrv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ali ako je to goveče i prije bolo, a njegov vlasnik, iako opominjan, nije ga čuvao, pa ono usmrti čovjeka ili ženu, neka se to goveče kamenuje; a i njegov se vlasnik ima pogubiti. ");
INSERT INTO hrv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ako se vlasniku označi otkupna cijena da svoj život iskupi, neka plati koliko mu se odredi. ");
INSERT INTO hrv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ubode li goveče dječaka ili djevojčicu, neka se prema njemu postupi isto prema ovome pravilu. ");
INSERT INTO hrv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ako ubode roba ili ropkinju, neka vlasnik isplati njihovu gospodaru trideset srebrnih šekela, a goveče neka se kamenuje. ");
INSERT INTO hrv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Kad tko ostavi bunar otvoren, ili tko iskopa bunar a ne pokrije ga, pa u nj upadne goveče ili magare, vlasnik bunara ima dati naknadu: ");
INSERT INTO hrv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","neka isplati vlasniku u novcu, a uginula životinja neka njemu pripadne. ");
INSERT INTO hrv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Kad nečije goveče ubode goveče drugome te ono ugine, onda neka prodaju živo goveče, a dobiveni novac neka podijele; i uginulo goveče neka među sebe podijele. ");
INSERT INTO hrv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ali ako se zna da je to goveče i prije bolo, a njegov ga gospodar nije čuvao, onda mora nadoknaditi goveče za goveče, dok će uginulo živinče biti njegovo.” ");
INSERT INTO hrv_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","“Tko ukrade goveče ili marvinče od sitne stoke, pa bilo da ga zakolje, bilo da ga proda, onda za jedno goveče neka se vrati petero goveda, a za malo marvinče četvero marvinčadi. ");
INSERT INTO hrv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ako se lopov zateče gdje probija zid, pa mu se zada smrtan udarac, njegovu krv ne treba osvećivati. ");
INSERT INTO hrv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","No ako je već izišlo sunce, njegovu krv treba osvetiti. Lopov mora štetu nadoknaditi. Ako nema ništa, njega za njegovu krađu treba prodati. ");
INSERT INTO hrv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Nađe li se ukradeno živinče živo u njegovu vlasništvu - goveče, magare ili koja glava sitne stoke - treba da ga plati dvostruko.” ");
INSERT INTO hrv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Tko opustoši njivu ili vinograd pustivši svoju stoku da obrsti tuđe, neka nadoknadi onim što najbolje nađe na svojoj njivi i u svome vinogradu. ");
INSERT INTO hrv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Tko zapali vatru pa ona zahvati drač te izgori žito u snopu, u klasu ili na njivi, onaj tko je vatru zapalio mora štetu nadoknaditi. ");
INSERT INTO hrv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Kad tko položi kod znanca novac ili stvari na čuvanje, pa budu pokradene iz njegove kuće, ako se lopov pronađe, mora dvostruko platiti. ");
INSERT INTO hrv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ako se lopov ne pronađe, vlasnik kuće neka se primakne k Bogu, da se dokaže kako on nije spustio svoje ruke na dobra svoga bližnjega. ");
INSERT INTO hrv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Za svaki prekršaj pronevjere - radilo se o govečetu, magaretu, sitnoj stoci, odjeći ili bilo kojoj izgubljenoj stvari za koju se ustvrdi: to je ono! - treba spor iznijeti pred Boga. Onaj koga Bog proglasi krivim neka plati dvostruko drugome. ");
INSERT INTO hrv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Kad tko povjeri svome susjedu magare, goveče, glavu sitne stoke ili bilo kakvo živinče, pa ono ugine, osakati se ili ga tko odvede a da ne bude svjedoka, ");
INSERT INTO hrv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","zakletva pred Jahvom neka odluči među obojicom je li čuvar posegao za dobrom svoga bližnjega ili nije. Neka je vlasniku to dovoljno, a čuvar nije dužan da nadoknađuje. ");
INSERT INTO hrv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Nađe li se da je on ukrao, mora štetu nadoknaditi. ");
INSERT INTO hrv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ako ga zvijer razdere, neka ga donese za dokaz, tako da za razderano ne daje odštete. ");
INSERT INTO hrv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kad tko posudi živinu na izor od svoga susjeda, pa se ona osakati ili ugine dok joj vlasnik nije bio s njom, neka plati odštetu. ");
INSERT INTO hrv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Je li vlasnik bio s njom, odštete mu ne daje; ali ako je bila unajmljena na izor, neka dođe po svoju nadnicu.” ");
INSERT INTO hrv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","“Ako tko zavede djevojku koja nije zaručena i s njom legne, neka za nju dadne ženidbenu procjenu i uzme je za ženu. ");
INSERT INTO hrv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ako njezin otac odbije da mu je dadne, zavodnik mora odmjeriti srebra u vrijednosti ženidbene procjene za djevojku. ");
INSERT INTO hrv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ne dopuštaj da vračarica živi! ");
INSERT INTO hrv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Tko bi god sa živinom legao, treba ga kazniti smrću. ");
INSERT INTO hrv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Tko bi prinosio žrtve kojemu kumiru - osim Jahvi jedinom - neka bude izručen prokletstvu, potpuno uništen. ");
INSERT INTO hrv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ne tlači pridošlicu niti mu nanosi nepravde, jer ste i sami bili pridošlice u zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ne cvilite udovice i siročeta! ");
INSERT INTO hrv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ako ih ucviliš i oni zavape k meni, sigurno ću njihove vapaje uslišati. ");
INSERT INTO hrv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Moj će se gnjev raspaliti i mačem ću vas pogubiti. Tako će vam žene ostati udovice a djeca siročad. ");
INSERT INTO hrv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ako uzajmiš novca kome od moga naroda, siromahu koji je kod tebe, ne postupaj prema njemu kao lihvar! Ne nameći mu kamata! ");
INSERT INTO hrv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Uzmeš li svome susjedu ogrtač u zalog, moraš mu ga vratiti prije zalaza sunca. ");
INSERT INTO hrv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","TÓa to mu je jedini pokrivač kojim omata svoje tijelo i u kojem može leći. Ako k meni zavapi, uslišat ću ga jer sam ja milostiv! ");
INSERT INTO hrv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ne huli Boga i ne psuj glavara svoga naroda. ");
INSERT INTO hrv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ne oklijevaj s prinosima od svoga obilja s gumna i od svoga mladog vina! Meni daj prvorođenca od svojih sinova. ");
INSERT INTO hrv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Isto učini sa svojim govedima i sitnom stokom: sedam dana neka ostane sa svojom majkom, a osmoga dana da si ga meni dao! ");
INSERT INTO hrv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Budite narod meni posvećen! Zato nemojte jesti mesa od životinje koju je rastrgala zvjerad nego je bacite paščadi!” ");
INSERT INTO hrv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Nemojte davati lažne izjave! Ne pomaži zlikovcu svjedočeći krivo! ");
INSERT INTO hrv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ne povodi se za mnoštvom da činiš zlo; niti svjedoči u parnici stajući na stranu većine protiv pravde. ");
INSERT INTO hrv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ne smiješ biti pristran prema siromahu u njegovoj parnici. ");
INSERT INTO hrv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Kad nabasaš na zalutalo goveče ili magare svoga neprijatelja, moraš mu ga natrag dovesti. ");
INSERT INTO hrv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ako opaziš magarca onoga koji te mrzi kako je pao pod svojim tovarom, nemoj ga ostaviti: zajedno s njegovim gospodarom moraš mu pomoći da se digne. ");
INSERT INTO hrv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ne krnji prava svome siromahu u njegovoj parnici. ");
INSERT INTO hrv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Stoj daleko od lažne optužbe; ne ubijaj nedužna i pravedna, jer ja zlikovcu ne praštam. ");
INSERT INTO hrv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ne primaj mita, jer mito zasljepljuje i one koji najjasnije gledaju i upropašćuje pravo pravednika. ");
INSERT INTO hrv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ne ugnjetavaj pridošlicu! TÓa znate kako je pridošlici; i sami ste bili pridošlice u zemlji egipatskoj.” ");
INSERT INTO hrv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Šest godina zasijavaj svoju zemlju i njezine plodove pobiri, ");
INSERT INTO hrv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","a sedme je godine pusti da počiva neobrađena. Neka se s nje hrani sirotinja tvoga naroda, a što njoj ostane, neka pojede poljska živina. Radi tako i sa svojim vinogradom i svojim maslinikom. ");
INSERT INTO hrv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Šest dana obavljaj svoj posao, ali sedmoga dana od posala odustani, da ti otpočine vo i magarac i da odahne sin tvoje sluškinje i pridošlica. ");
INSERT INTO hrv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Pripazite na sve što sam vam rekao. Ne spominjite imena drugih bogova. Neka se to i ne čuje iz tvojih usta.” ");
INSERT INTO hrv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Triput na godinu održavaj u moju čast svetkovinu. ");
INSERT INTO hrv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Slavi Blagdan beskvasnoga kruha. U određeno vrijeme u mjesecu Abibu - jer si u njemu iz Egipta izišao - sedam dana jedi beskvasan kruh, kako sam ti naredio. Neka nitko ne stupa preda me praznih ruku! ");
INSERT INTO hrv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Onda slavi Blagdan žetve - prvina što ih donose polja koja zasijavaš. Zatim Blagdan berbe na koncu godine, kad s polja pokupiš plodove svoga truda. ");
INSERT INTO hrv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Triput na godinu neka svi tvoji muški stupe pred Gospodara Jahvu. ");
INSERT INTO hrv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Krv žrtve koju u moju čast žrtvuješ nemoj prinositi s ukvasanim kruhom; salo od žrtve prinesene na moju svetkovinu ne ostavljaj za sutradan. ");
INSERT INTO hrv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Donosi u kuću Jahve, svoga Boga, najbolje prvine sa svoje zemlje. Ne kuhaj kozleta u mlijeku njegove majke.” ");
INSERT INTO hrv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Šaljem, evo, svog anđela pred tobom da te čuva na putu i dovede te u mjesto koje sam priredio. ");
INSERT INTO hrv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Poštuj ga i slušaj! Ne buni se protiv njega, jer vam neće opraštati prekršaje: tÓa moje je ime u njemu. ");
INSERT INTO hrv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ako mu se budeš vjerno pokoravao i budeš vršio sve što sam naredio, ja ću biti neprijatelj tvojim neprijateljima i protivnik tvojim protivnicima. ");
INSERT INTO hrv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Anđeo će moj ići pred tobom i dovesti te do Amorejaca, Hetita, Perižana, Kanaanaca, Hivijaca i Jebusejaca da ih uništim. ");
INSERT INTO hrv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Nemoj se klanjati njihovim kumirima niti im iskazuj štovanje; ne postupaj kako oni rade nego njihove kumire poruši i stupove im porazbijaj. ");
INSERT INTO hrv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Iskazujte štovanje Jahvi, Bogu svome, pa ću blagoslivati tvoj kruh i tvoju vodu i uklanjati od tebe bolest. ");
INSERT INTO hrv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","U tvojoj zemlji neće biti pometkinje; ja ću učiniti punim broj tvojih dana. ");
INSERT INTO hrv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Pred tobom ću odaslati stravu svoju; u metež ću baciti sav svijet među koji dospiješ i učinit ću da svi tvoji neprijatelji bježe pred tobom. ");
INSERT INTO hrv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Stršljene ću pred tobom odašiljati da ispred tebe tjeraju u bijeg Hivijce, Kanaance i Hetite. ");
INSERT INTO hrv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Neću ih otjerati ispred tebe u jednoj godini, da zemlja ne opusti i divlje se životinje ne razmnože na tvoju štetu. ");
INSERT INTO hrv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Tjerat ću ih ispred tebe malo-pomalo dok ti potomstvo ne odraste, tako da zemlju zaposjedneš. ");
INSERT INTO hrv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Postavit ću ti granicu: od Crvenoga do Filistejskoga mora, od pustinje pa do Rijeke. Predat ću, naime, stanovništvo zemlje u tvoje šake, a ti ga ispred sebe tjeraj. ");
INSERT INTO hrv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ne pravi savez ni s njima ni s njihovim kumirima. ");
INSERT INTO hrv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Neka ne ostanu u tvojoj zemlji da te ne navode na grijeh protiv mene. Ako bi štovao njihove kumire, to bi ti bila stupica.” ");
INSERT INTO hrv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Potom reče Mojsiju: “Uzađi k Jahvi - ti, Aron, Nadab i Abihu i sedamdeset izraelskih starješina. Poklonite se izdaljega! ");
INSERT INTO hrv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Neka se sam Mojsije primakne k Jahvi! Oni neka se ne primiču, a puk neka se s njim ne penje.” ");
INSERT INTO hrv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Dođe Mojsije i kaza narodu sve riječi Jahvine i sve odredbe. A sav puk odgovori u jedan glas: “Sve riječi što ih Jahve reče, vršit ćemo.” ");
INSERT INTO hrv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Tada Mojsije popiše sve riječi Jahvine. A ujutro podrani te podigne žrtvenik na podnožju brda i dvanaest stupova za dvanaest plemena Izraelovih. ");
INSERT INTO hrv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Zatim naloži mladim Izraelcima da prinesu žrtve paljenice i da žrtvuju Jahvi junce kao žrtve pričesnice. ");
INSERT INTO hrv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mojsije uhvati krv; polovinu krvi ulije u posude, a polovinu izlije po žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Prihvati zatim Knjigu Saveza pa je narodu glasno pročita, a narod uzvrati: “Sve što je Jahve rekao, izvršit ćemo i poslušat ćemo.” ");
INSERT INTO hrv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mojsije potom uzme krvi te poškropi narod govoreći: “Ovo je krv Saveza koji je Jahve s vama uspostavio na temelju svih ovih riječi.” ");
INSERT INTO hrv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Onda se uspne Mojsije s Aronom, Nadabom i Abihuom i sa sedamdeset starješina Izraelovih. ");
INSERT INTO hrv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Oni vidješe Boga Izraelova: podnožje njegovim nogama kao da je bilo od dragoga kamena safira, sjajem nalik na samo nebo. ");
INSERT INTO hrv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ni ruke svoje nije pružio na izabranike Izraelaca: slobodno su Boga motrili i jeli i pili. ");
INSERT INTO hrv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Onda Jahve reče Mojsiju: “Popni se k meni na brdo i pričekaj ondje. Dat ću ti kamene ploče sa zakonom i zapovijedima koje sam za njihovu pouku napisao.” ");
INSERT INTO hrv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ustane Mojsije i njegov pomoćnik Jošua te se Mojsije popne na brdo Božje. ");
INSERT INTO hrv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","A starješinama reče: “Čekajte nas ovdje dok se ne vratimo. Eto je s vama Aron i Hur. Tko imadne kakvu razmiricu, neka se obrati na njih.” ");
INSERT INTO hrv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Zatim Mojsije uzađe na brdo, a onda oblak prekri brdo. ");
INSERT INTO hrv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Slava se Jahvina nastani na Sinajskom brdu i oblak ga obavijaše šest dana. Sedmoga dana zovne Jahve Mojsija isred oblaka. ");
INSERT INTO hrv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Slava Jahvina na vrhuncu brda bijaše očima Izraelaca kao vatra koja sažiže. Mojsije zađe u oblak i uspne se na brdo. ");
INSERT INTO hrv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Četrdeset dana i četrdeset noći boravio je Mojsije na brdu. ");
INSERT INTO hrv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Reci Izraelcima da me darivaju, a vi primajte darove u moju čast od svakoga koji daje od srca. ");
INSERT INTO hrv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","A primajte ove darove: zlato, srebro i tuč; ");
INSERT INTO hrv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ljubičasto, crveno i tamnocrveno predivo i prepredeni lan; ");
INSERT INTO hrv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","učinjene ovnujske kože, pa fine kože; bagremovo drvo; ");
INSERT INTO hrv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ulje za svjetlo; mirodije za ulje pomazanja i miomirisno kađenje; ");
INSERT INTO hrv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","oniks i drugo drago kamenje koje će se umetnuti u oplećak i naprsnik. ");
INSERT INTO hrv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Neka mi sagrade Svetište da mogu boraviti među njima. ");
INSERT INTO hrv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Pri gradnji Prebivališta i svega u njemu postupi točno prema uzorku koji ti pokažem.” ");
INSERT INTO hrv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Od bagremova drva neka naprave Kovčeg: dva i po lakta dug, lakat i po širok i lakat i po visok. ");
INSERT INTO hrv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Okuj ga čistim zlatom, okuj ga izvana i iznutra; a oko njega stavi naokolo završni pojas od zlata. ");
INSERT INTO hrv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Salij za nj četiri zlatna koluta; prikuj ih za četiri njegove noge; dva koluta s jedne strane, a dva s druge. ");
INSERT INTO hrv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Od bagremova drva napravi i motke te ih u zlato okuj. ");
INSERT INTO hrv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Onda provuci motke kroz kolutove sa strana Kovčega da se na njima Kovčeg nosi. ");
INSERT INTO hrv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Neka motke ostanu u kolutima Kovčega; neka se iz njih ne izvlače. ");
INSERT INTO hrv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Svjedočanstvo koje ću ti predati - u Kovčeg položi.” ");
INSERT INTO hrv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Pomirilište napravi također od čistoga zlata. Neka bude dugo dva i pol lakta, a široko lakat i pol. ");
INSERT INTO hrv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Skuj i dva kerubina od zlata za oba kraja Pomirilišta. ");
INSERT INTO hrv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Napravi jednoga kerubina za jedan kraj, a drugoga kerubina za drugi kraj. Pričvrsti ih na oba kraja Pomirilišta da s njim sačinjavaju jedan komad. ");
INSERT INTO hrv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kerubini neka dignu svoja krila uvis tako da svojim krilima zaklanjaju Pomirilište. Neka budu licem okrenuti jedan prema drugome, ali tako da lica kerubina gledaju u Pomirilište. ");
INSERT INTO hrv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Stavi na Kovčeg Pomirilište, a u Kovčeg položi ploče Svjedočanstva što ću ti ih dati. ");
INSERT INTO hrv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Tu ću se ja s tobom sastajati i ozgo ću ti, iznad Pomirilišta - između ona dva kerubina što su na Kovčegu ploča Svjedočanstva - saopćavati sve zapovijedi namijenjene Izraelcima.” ");
INSERT INTO hrv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Napravi od bagremova drva stol dva lakta dug, lakat širok, a lakat i pol visok. ");
INSERT INTO hrv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","U čisto ga zlato obloži i načini mu naokolo završni pojas od zlata. ");
INSERT INTO hrv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Naokolo mu načini obrub, podlanicu širok, a onda po obrubu stavi završni pojas od zlata. ");
INSERT INTO hrv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Nadalje, uspravi mu četiri koluta od zlata pa mu ih pričvrsti na njegova četiri nožna ugla. ");
INSERT INTO hrv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Neka su kolutovi tik pod obrubom da služe kao kvake motkama za nošenje stola. ");
INSERT INTO hrv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Motke napravi od bagremova drva i u zlato ih okuj. O njima će se stol nositi. ");
INSERT INTO hrv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Za nj onda napravi: zdjele, varjače, vrčeve i pehare za izlijevanje prinosa. Načini ih od čistoga zlata. ");
INSERT INTO hrv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Na stol svagda stavljaj pred moje lice prineseni kruh.” ");
INSERT INTO hrv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Načini svijećnjak od čistoga zlata. Svijećnjak neka bude skovan. Njegovo podnožje, njegov stalak, njegove čaše, čaške i latice - sve neka bude od jednoga komada. ");
INSERT INTO hrv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Šest krakova neka mu izbija sa strana: tri kraka s jedne strane stalka, a tri kraka s druge strane stalka. ");
INSERT INTO hrv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Na jednome kraku neka budu tri čaše u obliku bademova cvijeta, svaka s čaškom i laticama. Tako za svih šest krakova što budu izbijali iz stalka svijećnjaka. ");
INSERT INTO hrv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na samome svijećnjaku neka budu četiri čaše u obliku bademova cvijeta, svaka s čaškom i laticama. ");
INSERT INTO hrv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Čaška ispod dva kraka, sačinjavajući jedan komad s njime; onda čaška ispod druga dva kraka, od jednoga komada s njime, pa čaška ispod dva posljednja kraka, od jednoga komada s njime. Tako za svih šest krakova što iz stalka budu izbijali. ");
INSERT INTO hrv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Njihove čaške i njihovi krakovi sačinjavat će jedan komad s njim - sve skovano u jednome komadu od čistoga zlata. ");
INSERT INTO hrv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Napravi i sedam svjetiljaka za njih. Svjetiljke neka tako budu postavljene da osvjetljuju prostor sprijeda. ");
INSERT INTO hrv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Usekači i pepeljare za njih neka su od čistoga zlata. ");
INSERT INTO hrv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Upotrijebi talenat čistoga zlata za svijećnjak i sav njegov pribor. ");
INSERT INTO hrv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Pazi! Načini ih prema uzorku koji ti je na brdu pokazan.” ");
INSERT INTO hrv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Prebivalište načini od deset zavjesa: od ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana. Na njima neka budu vezeni likovi kerubina - djelo umjetnika. ");
INSERT INTO hrv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Dužina svake zavjese neka je dvadeset i osam lakata, neka joj je širina četiri lakta. Sve zavjese neka su iste mjere. ");
INSERT INTO hrv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pet zavjesa neka su sastavljene jedna s drugom, a drugih pet zavjesa opet jedna s drugom. ");
INSERT INTO hrv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Napravi petlje od ljubičaste vune pri rubu krajnje zavjese u sastavljenom komadu. ");
INSERT INTO hrv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Napravi pedeset petlji na rubu jednoga sastavljenog komada od zavjesa, a pedeset pri rubu drugoga. Neka su petlje načinjene jedna spram druge. ");
INSERT INTO hrv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Onda napravi pedeset kopča od zlata. Zavjese zatim kopčama sastavi jednu s drugom. Tako će Prebivalište biti jedna cjelina. ");
INSERT INTO hrv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Načini zatim zavjese od kostrijeti za Šator povrh Prebivališta. Načini ih jedanaest. ");
INSERT INTO hrv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Neka duljina svake zavjese bude trideset lakata, a širina svake zavjese četiri lakta. Tih jedanaest zavjesa neka bude iste mjere. ");
INSERT INTO hrv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Sastavi pet zavjesa napose, a onda opet drugih šest zavjesa napose. Šestu zavjesu podvostruči na pročelju Šatora. ");
INSERT INTO hrv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ušij pedeset petlji na rubu jednoga sastavljenog komada od zavjesa, a pedeset na rubu drugoga. ");
INSERT INTO hrv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Izradi pedeset kopča od tuča, zapni kopče za petlje da sastaviš Šator u cjelinu. ");
INSERT INTO hrv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","A kako će zavjese od Šatora pretjecati, neka se polovina zavjesa što preostane spušta na zadnjem dijelu Prebivališta. ");
INSERT INTO hrv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Od onoga što preteče na dužini šatorskih zavjesa neka po jedan lakat visi na obje strane svetoga Šatora da ga zaklanja. ");
INSERT INTO hrv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Napokon napravi Šatoru pokrov od učinjenih i u crveno obojenih ovnujskih koža, a povrh njega pokrov od finih koža. ");
INSERT INTO hrv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Trenice što će nauzgor stajati za Prebivalište napravi od bagremova drva. ");
INSERT INTO hrv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Svaka trenica neka bude deset lakata duga, a lakat i pol široka. ");
INSERT INTO hrv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Svaka trenica neka ima dva klina da je uspravno drže. Tako napravi na svakoj trenici za Prebivalište. ");
INSERT INTO hrv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Trenice za Prebivalište postavi: dvadeset trenica s juga, prema podnevu; ");
INSERT INTO hrv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","onda pod dvadeset trenica napravi četrdeset podnožja od srebra, dva podnožja pod prvu trenicu za njezina dva klina, i tako redom, dva podnožja za dva klina svake slijedeće trenice. ");
INSERT INTO hrv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Za drugu stranu Prebivališta, sa sjevera: dvadeset trenica ");
INSERT INTO hrv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","i četrdeset srebrnih podnožja, dva podnožja za dva klina prve trenice, i tako redom, dva podnožja za svaku trenicu. ");
INSERT INTO hrv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Na stražnjoj strani Prebivališta, sa zapada, postavi šest trenica. ");
INSERT INTO hrv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Napravi i dvije trenice za stražnje uglove Prebivališta. ");
INSERT INTO hrv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Neka budu rastavljene pri dnu, ali na vrhu kod prvoga koluta neka budu sastavljene. Neka tako obadvije prave dva ugla. ");
INSERT INTO hrv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Neka dakle bude osam trenica s njihovim srebrnim podnožjima: šesnaest podnožja, dva podnožja pod prvom trenicom, a dva opet podnožja pod svakom slijedećom trenicom. ");
INSERT INTO hrv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Nadalje napravi priječnice od bagremova drva: pet njih za trenice s jedne strane Prebivališta, ");
INSERT INTO hrv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","a pet priječnica s druge strane Prebivališta; onda pet priječnica za trenice Prebivališta straga prema zapadu. ");
INSERT INTO hrv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Srednja priječnica neka ide sredinom trenica s jednoga kraja na drugi. ");
INSERT INTO hrv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Trenice obloži zlatom, a i kolutove za njih, kroz koje će se priječnice provlačiti, načini od zlata. Priječnice onda obloži zlatom. ");
INSERT INTO hrv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tako, dakle, podigni Prebivalište prema nacrtu koji ti je pokazan na brdu.” ");
INSERT INTO hrv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Napravi zavjesu od ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana. Neka su na njoj izvezeni kerubini. ");
INSERT INTO hrv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Objesi je na četiri stupa od bagremova drva, zlatom obložena, s kopčama od zlata, a na četiri podnožja od srebra. ");
INSERT INTO hrv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Objesi zavjesu za kvake. Onda unesi Kovčeg svjedočanstva tu za zavjesu. Neka ti tako zavjesa odjeljuje Svetište od Svetišta nad svetištima. ");
INSERT INTO hrv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Stavi Pomirilište na Kovčeg svjedočanstva u Svetinji nad svetinjama. ");
INSERT INTO hrv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Postavi zatim stol van pred zavjesu, a svijećnjak na južnu stranu Prebivališta, prema stolu. Stol stavi na sjevernu stranu. ");
INSERT INTO hrv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","A na ulazu u Šator napravi zastorak od ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana - vezom izvezen. ");
INSERT INTO hrv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Za zastorak isteši pet stupčića od bagrenova drva pa ih obloži zlatom. Kopče za njih neka budu od zlata. Salij za njih pet podnožja od tuča.” ");
INSERT INTO hrv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Načini žrtvenik od bagremova drva, pet lakata dug, pet lakata širok - prava četvorina - i tri lakta visok. ");
INSERT INTO hrv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Na njegova četiri ugla načini rogove. Neka mu rogovi budu u jednome komadu s njim. I tučem ga okuj. ");
INSERT INTO hrv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Dalje, načini za žrtvenik posude za zgrtanje otpadaka: strugače, kotliće, viljuške i kadionike. Sve potrepštine za žrtvenik načini od tuča. ");
INSERT INTO hrv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Onda načini za nj rešetku od tuča, u obliku mrežice, ");
INSERT INTO hrv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","a na četiri ugla mrežicu ispod izbočine žrtvenika, tako da zahvati do sredine žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Napravi zatim motke za žrtvenik, motke od bagremova drva, pa ih tučem okuj. ");
INSERT INTO hrv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Neka se motke provuku kroz kolutove, tako da dođu na obje strane žrtvenika kad se nosi. ");
INSERT INTO hrv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Načini ga šuplja, od dasaka: kako ti je pokazano na brdu, onako neka je i napravljen.” ");
INSERT INTO hrv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Napravi i dvorište Prebivališta. Na južnoj strani napravi zavjese od prepredenog lana, sto lakata u dužinu s te strane. ");
INSERT INTO hrv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Njihovih dvadeset stupova neka stoji na dvadeset podnožja od tuča i neka imaju kopče i šipke od srebra. ");
INSERT INTO hrv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Isto tako za sjevernu stranu načini plahte sto lakata duge. Njihovih dvadeset stupova i dvadeset podnožja od tuča, ali kopče i šipke neka su od srebra. ");
INSERT INTO hrv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Širini dvorišta sa zapadne strane trebat će zavjese pedeset lakata duge, sa deset stupova i deset podnožja. ");
INSERT INTO hrv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Širina dvorišta prema istočnoj strani neka bude pedeset lakata. ");
INSERT INTO hrv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Nadalje, zavjese s jedne strane vrata neka su petnaest lakata duge, sa svoja tri stupa i njihova tri podnožja. ");
INSERT INTO hrv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","A s druge strane neka su zavjese opet petnaest lakata, sa svoja tri stupa i njihova tri podnožja. ");
INSERT INTO hrv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Za dvorišni ulaz: vezen zastor od dvadeset lakata, od ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana; i sa svoja četiri stupa i njihova četiri podnožja. ");
INSERT INTO hrv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Svi stupovi naokolo dvorišta neka su povezani srebrnim šipkama. Neka su im kopče od srebra, a podnožja od tuča. ");
INSERT INTO hrv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Neka je dvorište u duljinu sto lakata, u širinu pedeset, a u visinu pet lakata. Neka su mu plahte od prepredenog lana, podnožja od tuča. ");
INSERT INTO hrv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Sve potrepštine u Prebivalištu za opću upotrebu i svi njegovi kočići, a tako i kočići u dvorištu, neka su od tuča.” ");
INSERT INTO hrv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Nadalje, naredi Izraelcima da ti za svjetlo donose čistoga ulja od istupanih maslina, tako da svjetlo neprestano gori. ");
INSERT INTO hrv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aron i njegovi sinovi neka ga postavljaju u Šator sastanka izvan zavjese što zaklanja Svjedočanstvo da gori pred Jahvom od večeri do jutra. Neka je to neopoziva naredba za izraelske naraštaje.” ");
INSERT INTO hrv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“A onda dovedi k sebi između Izraelaca svoga brata Arona zajedno s njegovim sinovima: Nadabom, Abihuom, Eleazarom i Itamarom da mi služe kao svećenici. ");
INSERT INTO hrv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Napravi svome bratu Aronu sveto ruho na čast i ukras. ");
INSERT INTO hrv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Obrati se svim vještacima koje sam obdario mudrošću neka naprave haljine Aronu da bi se posvetio i vršio svećeničku službu u moju čast. ");
INSERT INTO hrv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Neka ovu odjeću naprave: naprsnik, oplećak, ogrtač, košulju resama obrubljenu, mitru i pas; neka naprave svetu odjeću za tvoga brata Arona i njegove sinove da mi služe kao svećenici. ");
INSERT INTO hrv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Stoga neka oni primaju zlato, ljubičasto, crveno i tamnocrveno predivo i prepredeni lan.” ");
INSERT INTO hrv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Oplećak neka naprave od zlata, od ljubičastog, crvenog i tamnocrvenog prediva i od prepredenog lana - vješto izrađen. ");
INSERT INTO hrv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Neka na njemu budu dvije poramenice, pričvršćene za njegove krajeve. ");
INSERT INTO hrv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Tkanica što bude na njemu neka je napravljena kao i on: od zlata, od ljubičastog, crvenog i tamnocrvenog prediva i od prepredenog lana, a neka s njim sačinjava jedan komad. ");
INSERT INTO hrv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Zatim uzmi dva draga kamena oniksa i u njih ureži imena Izraelovih sinova: ");
INSERT INTO hrv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","šest njihovih imena na jednome dragom kamenu, a preostalih šest imena na drugome dragom kamenu, prema njihovu rođenju. ");
INSERT INTO hrv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kao što rezbar dragulja urezuje pečate na prstene, tako ti ureži imena Izraelovih sinova. Oko njih navezi zlatan obrub, ");
INSERT INTO hrv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","pa pričvrsti oba draga kamena za poramenice oplećka da budu spomen-dragulji na Izraelove sinove. Tako neka Aron nosi njihova imena o svoja dva ramena pred Jahvom da ih se sjeća. ");
INSERT INTO hrv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Načini zlatne okvire ");
INSERT INTO hrv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","i dva lančića od čistoga zlata. Načini ih kao zasukane uzice i onda zasukane lančiće pričvrsti za okvire.” ");
INSERT INTO hrv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Naprsnik za presuđivanje izradi umjetnički; izvedi to kao i posao na oplećku: od zlata, od ljubičastog, crvenog i tamnocrvenog prediva i od prepredenog lana. ");
INSERT INTO hrv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Neka bude četvorinast i dvostruk; jedan pedalj neka mu je duljina, a pedalj širina. ");
INSERT INTO hrv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Na njemu poredaj četiri reda dragulja. U prvome redu neka bude: rubin, topaz i alem; ");
INSERT INTO hrv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","u drugome redu: smaragd, safir i ametist; ");
INSERT INTO hrv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","u trećem redu: hijacint, ahat i ledac; ");
INSERT INTO hrv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","a u četvrtom redu: krizolit, oniks i jaspis. Neka budu ukovani u zlatne okvire. ");
INSERT INTO hrv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Tih dragulja neka bude dvanaest, koliko i imena Izraelovih sinova. Neka budu urezani kao i pečati na prstenju, svaki s imenom jednoga od dvanaest plemena. ");
INSERT INTO hrv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Napravi za naprsnik lančiće od čistoga zlata, zasukane kao uzice. ");
INSERT INTO hrv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Zatim napravi za naprsnik dva kolutića od zlata i pričvrsti ih na dva gornja ugla naprsnika. ");
INSERT INTO hrv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Onda priveži dvije zlatne uzice za ta dva kolutića koja budu pričvršćena za uglove naprsnika. ");
INSERT INTO hrv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Druga dva kraja uzica priveži za dva okvira. Sad ih tako pričvrsti za poramenice oplećka sprijeda. ");
INSERT INTO hrv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Napravi dva kolutića od zlata pa ih pričvrsti za dva donja ugla naprsnika, uz rub iznutra koji je okrenut prema oplećku. ");
INSERT INTO hrv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Napravi još dva kolutića od zlata i pričvrsti ih za donji, prednji kraj poramenice oplećka, uz njegov šav povrh tkanice oplećka. ");
INSERT INTO hrv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Neka se naprsnik sveže za svoje kolutiće s kolutićima oplećka vrpcom od modroga grimiza, tako da naprsnik stoji iznad tkanice i da se ne može odvajati od oplećka. ");
INSERT INTO hrv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Neka tako Aron, kada god ulazi u Svetište, na svome srcu nosi imena sinova Izraelovih na naprsniku za presuđivanje da ih uvijek doziva u sjećanje pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","U naprsnik za presuđivanje neka se stave i 'Urim' i 'Tumim' da i oni budu na Aronovu srcu kad bude dolazio pred Jahvu. Tako neka Aron uvijek na svom srcu pred Jahvom nosi presudu sinova Izraelovih.” ");
INSERT INTO hrv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ogrtač za oplećak sav napravi od ljubičastog prediva. ");
INSERT INTO hrv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Prorez za glavu na njemu neka bude na sredini. Rub naokolo proreza neka bude opšiven kao ovratnik na oklopu, tako da se ogrtač ne podere. ");
INSERT INTO hrv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Na njegovu rubu sve naokolo načini šipke od ljubičastog, crvenog i tamnocrvenog prediva, a između njih zvonca od zlata naokolo; ");
INSERT INTO hrv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","zlatno zvonce pa šipak, zlatno zvonce pa šipak naokolo ogrtača uz rub. ");
INSERT INTO hrv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Neka budu na Aronu dok vrši službu, da se čuje kad ulazi u Svetište pred Jahvu i kad izlazi; tako neće umrijeti.” ");
INSERT INTO hrv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Napravi potom jednu ploču od čistoga zlata i na njoj ureži, kao što se urezuje na pečatnom prstenu: 'Jahvi posvećen'. ");
INSERT INTO hrv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Za mitru je priveži modrom vrpcom da stoji s pročelja mitre. ");
INSERT INTO hrv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Neka stoji na Aronovu čelu. Tako neka Aron na se preuzme nedostatke koji bi mogli okaljati sve svete prinose što ih Izraelci posvećuju. Neka uvijek stoji na njegovu čelu da za njih stječe blagonaklonost Jahvinu. ");
INSERT INTO hrv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Košulju s resama napravi od lana, od lana napravi i mitru, a pas vezom izvezi. ");
INSERT INTO hrv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","I za Aronove sinove napravi haljine, pasove i turbane, njima na čast i ukras. ");
INSERT INTO hrv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","U njih odjeni svoga brata Arona i njegove sinove; onda ih pomaži, ispuni im ruke vlašću i posveti ih da mi služe kao svećenici. ");
INSERT INTO hrv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Napravi za njih gaćice od lana da im pokriju golo tijelo. Neka sežu od bedara do stegna. ");
INSERT INTO hrv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Neka ih nosi Aron i njegovi sinovi kad ulaze u Šator sastanka ili kad se primiču žrtveniku za službu u Svetištu da ne navuku na se krivnju i umru. To neka bude vječna naredba za nj i za njegovo potomstvo poslije njega.” ");
INSERT INTO hrv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Ovo je obred koji ćeš obaviti na njima da ih posvetiš za moje svećenike: Uzmi jednog junca i dva ovna bez mane; ");
INSERT INTO hrv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","onda beskvasnoga kruha, beskvasnih kolača zamiješenih u ulju i beskvasnih prevrta uljem namazanih. Napravi ih od bijeloga pšeničnog brašna. ");
INSERT INTO hrv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Naslaži ih u košaricu i u košarici prinesi ih s juncem i oba ovna.” ");
INSERT INTO hrv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Dovedi Arona i njegove sinove k ulazu u Šator sastanka i operi ih u vodi. ");
INSERT INTO hrv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Zatim uzmi odijelo i obuci Arona u košulju; stavi na nj ogrtač oplećka, oplećak i naprsnik i opaši ga tkanicom oplećka. ");
INSERT INTO hrv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ustakni mu mitru na glavu; na mitru stavi sveti vijenac. ");
INSERT INTO hrv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Uzmi zatim ulja za pomazanje; izlij na njegovu glavu i pomaži ga. ");
INSERT INTO hrv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Onda dovedi njegove sinove; obuci ih u košulje; ");
INSERT INTO hrv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","opaši ih u pasove i obvij im turbane. Svećeništvo neka im pripada vječnom uredbom. Tako posveti Arona i njegove sinove!” ");
INSERT INTO hrv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Dovedi zatim junca pred Šator sastanka, pa neka Aron i njegovi sinovi stave ruke juncu na glavu. ");
INSERT INTO hrv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Onda pred Jahvom, na ulazu u Šator sastanka, junca zakolji. ");
INSERT INTO hrv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Uzmi junčeve krvi i svojim je prstom stavi na rogove žrtvenika. Ostatak krvi izlij podno žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Uzmi sav loj oko droba, privjesak na jetri i oba bubrega s lojem oko njih, pa spali na žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Meso od junca, njegovu kožu i njegovu nečist spali na vatri izvan taborišta. To je žrtva okajnica. ");
INSERT INTO hrv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Poslije toga uzmi jednoga ovna, pa neka Aron i njegovi sinovi stave na njegovu glavu svoje ruke. ");
INSERT INTO hrv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Onda ovna zakolji, uhvati mu krvi i zapljusni njome žrtvenik sa svih strana. ");
INSERT INTO hrv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Isijeci zatim ovna u komade, operi mu drobinu i noge i položi ih na njegove ostale dijelove i glavu. ");
INSERT INTO hrv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","I onda cijeloga ovna spali na žrtveniku. Žrtva je to paljenica u čast Jahvi, miris ugodan, žrtva ognjena. ");
INSERT INTO hrv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Uzmi onda drugoga ovna, pa neka Aron i njegovi sinovi stave svoje ruke ovnu na glavu. ");
INSERT INTO hrv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Sad ovna zakolji; uzmi mu krvi i njome namaži resicu desnoga Aronova uha, resicu desnog uha njegovim sinovima, palac na njihovoj desnoj ruci pa palac na njihovoj desnoj nozi. Ostatkom krvi zapljusni žrtvenik naokolo. ");
INSERT INTO hrv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Uzmi onda krvi što je ostala na žrtveniku i ulja za pomazanje i poškropi Arona i njegovo odijelo, njegove sinove i njihova odijela. Tako će biti posvećen on i njegovo odijelo, njegovi sinovi i odijela njegovih sinova.” ");
INSERT INTO hrv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Poslije toga uzmi s ovna loj, pretili rep, loj oko droba, privjesak s jetre, oba bubrega i loj oko njih; desno pleće - jer je to ovan prinesen za svećeničko posvećenje - ");
INSERT INTO hrv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","zatim jedan okrugli kruh, jedan kolač na ulju i jednu prevrtu iz košarice beskvasnoga kruha što je pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Sve to stavi na ruke Arona i njegovih sinova i prinesi žrtvu prikaznicu pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Uzmi ih onda s njihovih ruku i spali na žrtveniku, povrh žrtve paljenice, da bude Jahvi na ugodan miris. To je paljena žrtva u čast Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Zatim uzmi grudi ovna prinesena za Aronovo posvećenje i prinesi ih kao žrtvu prikaznicu pred Jahvom. Neka to bude tvoj dio. ");
INSERT INTO hrv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Posveti grudi što su bile prinesene kao žrtva prikaznica i pleće što je bilo prineseno kao žrtva podizanica od ovna prinesena za posvećenje Arona i njegovih sinova. ");
INSERT INTO hrv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Neka to bude pristojba Aronu i njegovim potomcima od Izraelaca za sva vremena. TÓa to je ujam koji će Izraelci davati od svojih pričesnica - ujam koji Jahvi pripada. ");
INSERT INTO hrv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aronova posvećena odijela neka pripadnu njegovim sinovima poslije njega da u njima budu pomazani i posvećeni. ");
INSERT INTO hrv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sin koji postane svećenikom mjesto njega, kad uđe u Šator sastanka da vrši službu u Svetištu, neka ih nosi sedam dana.” ");
INSERT INTO hrv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Uzmi onda ovna za posvećenje i skuhaj njegovo meso na posvećenome mjestu. ");
INSERT INTO hrv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aron i njegovi sinovi neka blaguju meso od toga ovna i kruh iz košarice na ulazu u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Neka jedu od onoga što je poslužilo za njihovo očišćenje, da im se ruke ispune vlašću i da budu posvećeni. Nijedan svjetovnjak neka ne jede od toga jer je posvećeno. ");
INSERT INTO hrv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ako bi ostalo što mesa od svećeničkog posvećenja ili što od onoga kruha do ujutro, spali na vatri. Ne smije se pojesti jer je posvećeno.” ");
INSERT INTO hrv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Točno tako učini Aronu i njegovim sinovima kako sam ti naredio. Posvećuj ih sedam dana. ");
INSERT INTO hrv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Svakoga dana prinesi jednoga junca kao žrtvu okajnicu - za pomirenje. I prinesi žrtvu okajnicu za pomirenje oltara, zatim ga pomaži da bude posvećen. ");
INSERT INTO hrv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sedam dana prinosi žrtvu pomirnicu za žrtvenik i posvećuj ga. Tako će žrtvenik postati presvet, i sve što se žrtvenika dotakne bit će posvećeno.” ");
INSERT INTO hrv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“A ovo treba da prinosiš na žrtveniku: dva janjca godinu dana stara, svaki dan bez prijekida. ");
INSERT INTO hrv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Jedno janje žrtvuj ujutro, a drugo uvečer. ");
INSERT INTO hrv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Prinesi s prvim janjetom jednu desetinu efe bijeloga brašna zamiješena u četvrtini hina istupanog ulja i žrtvu ljevanicu od četvrtine hina vina. ");
INSERT INTO hrv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Drugo janje prinesi u suton. S njim prinesi žrtvu prinosnicu s njezinom žrtvom ljevanicom kao i izjutra - na ugodan miris, žrtvu u čast Jahvi paljenu. ");
INSERT INTO hrv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Neka to bude trajna žrtva paljenica od koljena do koljena - na ulazu u Šator sastanka, pred Jahvom. Tu ću se ja s tobom sastajati da ti govorim. ");
INSERT INTO hrv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","I s Izraelcima ću se tu sastajati, i moja će ih slava posvećivati. ");
INSERT INTO hrv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ja ću posvetiti Šator sastanka i žrtvenik; posvetit ću Arona i njegove sinove da mi služe kao svećenici. ");
INSERT INTO hrv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ja ću prebivati među Izraelcima i biti njihov Bog. ");
INSERT INTO hrv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Upoznat će oni tada da sam to ja, Jahve, Bog njihov koji ih je izbavio iz zemlje egipatske da prebivam među njima - ja, Jahve, Bog njihov.” ");
INSERT INTO hrv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Napravi i žrtvenik za paljenje tamjana; napravi ga od bagremova drva. ");
INSERT INTO hrv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Neka bude lakat dug, lakat širok, u pravokut, i dva lakta visok. Neka mu roščići budu od jednoga komada s njim. ");
INSERT INTO hrv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Obloži mu u čisto zlato: njegovu gornju plohu, njegove strane naokolo i njegove roščiće. Načini mu zlatan završni pojas naokolo. ");
INSERT INTO hrv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Načini mu dva zlatna koluta. Pričvrsti mu ih s dviju suprotnih strana ispod završnog pojasa. Kroz njih će se provlačiti motke za nošenje. ");
INSERT INTO hrv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Motke načini od bagremova drva i zlatom ih obloži. ");
INSERT INTO hrv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Postavi žrtvenik pred zavjesu što zastire Kovčeg Svjedočanstva - nasuprot Pomirilištu nad Svjedočanstvom - gdje ću se ja s tobom sastajati. ");
INSERT INTO hrv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Neka na njemu Aron pali miomirisni tamjan svako jutro kad priprema svjetla; ");
INSERT INTO hrv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","neka ga Aron opet pali u suton kad svjetla zapaljuje, da to bude svagdašnje kadiono prinošenje pred Jahvom u sve vaše naraštaje. ");
INSERT INTO hrv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ne prinosi na njemu ni neposvećenoga tamjana, ni paljenice, ni prinosnice, ni ljevanice! ");
INSERT INTO hrv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Jednom u godini neka Aron obavi obred pomirenja na njegovim roščićima. Krvlju žrtve koja se prinosi za grijeh, jednom na godinu, neka obavi obred pomirenja za žrtvenik. Tako činite u sve naraštaje. Jer oltar je presveta svetinja Jahvina.” ");
INSERT INTO hrv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Nadalje Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Kad budeš pravio popis Izraelaca prilikom novačenja, neka svatko da Jahvi otkupninu za se kad se upiše, da ih kakvo zlo ne snađe zbog novačenja. ");
INSERT INTO hrv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Tko god potpada pod novačenje, ovoliko neka dadne: pola šekela - prema hramskom šekelu, gdje je dvadeset gera u šekelu. To pola šekela neka bude kao prinos Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Tko god potpada pod novačenje, od dvadeset godina starosti pa naviše, neka dadne prinos Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Bogataš neka ne plaća više niti siromah manje od pola šekela kad daju prinos Jahvi kao otkup za se. ");
INSERT INTO hrv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Uzimaj otkupni novac od Izraelaca i određuj ga za potrebe Šatora sastanka. Neka to bude Jahvi na spomen da se sjeća Izraelaca i da im bude milostiv.” ");
INSERT INTO hrv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Reče Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Napravi umivaonik od tuča i podnožje od tuča za umivanje. Postavi ga između Šatora sastanka i žrtvenika. Nalij u nj vode ");
INSERT INTO hrv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","pa neka Aron i njegovi sinovi peru svoje ruke i noge vodom iz njega. ");
INSERT INTO hrv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kad moradnu ulaziti u Šator sastanka, ili kad se moradnu primicati žrtveniku za službu da spaljuju žrtve u čast Jahvi paljene, neka se vodom operu da ne poginu. ");
INSERT INTO hrv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Neka operu ruke svoje i noge svoje da izbjegnu smrti: to je trajna naredba Aronu i njegovim potomcima u sve naraštaje.” ");
INSERT INTO hrv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Još reče Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Nabavi najboljih mirodija: pet stotina šekela smirne samotoka, pola te težine - dvjesta pedeset - mirisavog cimeta, dvjesta pedeset mirisave trstike, ");
INSERT INTO hrv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","pet stotina - prema hramskom šekelu - lovorike i jedan hin maslinova ulja. ");
INSERT INTO hrv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Od toga napravi posvećeno ulje za pomazanje; da bude smjesa kao da ju je pravio pomastar. Neka to bude posvećeno ulje za pomazanje. ");
INSERT INTO hrv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Time onda pomaži: Šator sastanka i Kovčeg Svjedočanstva; ");
INSERT INTO hrv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","stol i sav njegov pribor; svijećnjak i sav njegov pribor; žrtvenik kadioni; ");
INSERT INTO hrv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","žrtvenik za žrtve paljenice i sav njegov pribor; umivaonik i njegov stalak: ");
INSERT INTO hrv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","posveti ih, i oni će tako postati posvećeni; i što god ih se dotakne, posvećeno će postati. ");
INSERT INTO hrv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Pomaži Arona i njegove sinove i posveti ih meni za svećenike. ");
INSERT INTO hrv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Onda kaži Izraelcima ovako: 'Ovo je moje posvećeno ulje za pomazanje od koljena do koljena. ");
INSERT INTO hrv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ne smije se polijevati po tijelu običnoga čovjeka; ne smijete praviti drugoga ovakva sastava! To je posvećeno i neka vam bude sveto! ");
INSERT INTO hrv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Tko god takvo napravi, ili tko ga stavi na kojeg svjetovnjaka, neka se odstrani od svog naroda!'” ");
INSERT INTO hrv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Jahve još reče Mojsiju: “Nabavi mirodija: natafe, šeheleta i helebene. Od ovih mirodija i čistoga tamjana, ");
INSERT INTO hrv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","sve u jednakim dijelovima, napravi tamjan za kađenje, smjesu mirodija kakvu pravi pomastar, opranu, čistu, svetu. ");
INSERT INTO hrv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Od toga nešto smrvi u prah i jedan dio stavi pred Svjedočanstvo, u Šator sastanka, gdje ću se ja s tobom sastajati. Držite ovu mirodiju presvetom! ");
INSERT INTO hrv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","A miomiris koji napraviš prema ovome sastavu za svoju upotrebu ne smijete praviti. To drži za svetinju Jahvi! ");
INSERT INTO hrv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Tko sebi napravi što takvo da mu miriše, neka se iskorijeni iz svoga naroda.” ");
INSERT INTO hrv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Pozvao sam, gledaj, po imenu Besalela, sina Urijeva, od koljena Hurova iz plemena Judina. ");
INSERT INTO hrv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Napunio sam ga duhom Božjim koji mu je dao umješnost, razumijevanje i sposobnost za svakovrsne poslove: ");
INSERT INTO hrv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","da zamišlja nacrte za radove od zlata, srebra i tuča; ");
INSERT INTO hrv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","za rezanje dragulja, za umetanje; za rezbarije u drvu i poslove svakakve. ");
INSERT INTO hrv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Dodao sam još Oholiaba, sina Ahisamakova iz Danova plemena; vještinom sam obdario sve sposobne ljude da mognu napraviti sve što sam ti naredio: ");
INSERT INTO hrv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Šator sastanka, Kovčeg Svjedočanstva, povrh njega Pomirilište i sav namještaj Šatora; ");
INSERT INTO hrv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","stol i sav njegov pribor, čisti svijećnjak sa svim njegovim priborom; ");
INSERT INTO hrv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kadioni žrtvenik, žrtvenik za žrtve paljenice i njegov pribor, onda umivaonik i njegovo podnožje; ");
INSERT INTO hrv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","odijela za službu, posvećena odijela za svećenika Arona i odijela za njegove sinove, za njihovu svećeničku službu; ");
INSERT INTO hrv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","pa ulje za pomazanje i miomirisni tamjan za Svetište. Sve neka načine kako sam ti naredio.” ");
INSERT INTO hrv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Jahve opet reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Reci Izraelcima: Subote moje morate održavati, jer subota je znak između mene i vas od naraštaja do naraštaja, da budete svjesni da vas ja, Jahve, posvećujem. ");
INSERT INTO hrv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Držite, dakle, subotu, jer je ona za vas sveta. Tko je oskvrne neka se pogubi; tko bude u njoj radio ikakav posao neka se odstrani iz svoga naroda. ");
INSERT INTO hrv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Šest dana neka se vrše poslovi, ali sedmi dan neka bude dan posvemašnjeg odmora, Jahvi posvećen. Tko bi u dan subotni obavljao kakav posao neka se pogubi. ");
INSERT INTO hrv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Stoga neka Izraelci drže subotu - svetkujući je od naraštaja do naraštaja - kao vječni savez. ");
INSERT INTO hrv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Neka je ona znak, zauvijek, između mene i Izraelaca. TÓa Jahve je za šest dana sazdao nebo i zemlju, a sedmoga je dana prestao raditi i odahnuo.” ");
INSERT INTO hrv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kad Jahve svrši svoj razgovor s Mojsijem na Sinajskom brdu, dade mu dvije ploče Svjedočanstva, ploče kamene, ispisane prstom Božjim. ");
INSERT INTO hrv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","A narod, videći gdje Mojsije dugo ne silazi s brda, okupi se oko Arona pa mu rekne: “Ustaj! Napravi nam boga, pa neka on pred nama ide! Ne znamo što se dogodi s tim čovjekom Mojsijem koji nas izvede iz zemlje egipatske.” ");
INSERT INTO hrv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","“Poskidajte zlatne naušnice što vise o ušima vaših žena, vaših sinova i vaših kćeri”, odgovori im Aron, “pa ih meni donesite.” ");
INSERT INTO hrv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Sav svijet skine zlatne naušnice što ih je o ušima imao i donese Aronu. ");
INSERT INTO hrv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Primivši zlato iz njihovih ruku, rastopi kovinu u kalupu i načini saliveno tele. A oni poviču: “Ovo je tvoj bog, Izraele, koji te izveo iz zemlje egipatske.” ");
INSERT INTO hrv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Vidjevši to Aron, sagradi pred njim žrtvenik a onda najavi: “Sutra neka se priredi svečanost u čast Jahvi!” ");
INSERT INTO hrv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Sutradan rano ustanu i prinesu žrtve paljenice i donesu žrtve pričesnice. Onda svijet posjeda da jede i pije. Poslije toga ustade da se zabavlja. ");
INSERT INTO hrv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","“Požuri se dolje!” - progovori Jahve Mojsiju. “Narod tvoj, koji si izveo iz zemlje egipatske, pošao je naopako. ");
INSERT INTO hrv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Brzo su zašli s puta koji sam im odredio. Napravili su sebi tele od rastopljene kovine, preda nj pali ničice i žrtve mu prinijeli uz poklike: 'Ovo je tvoj bog, Izraele, koji te izveo iz zemlje egipatske!' ");
INSERT INTO hrv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Dobro vidim”, reče dalje Jahve Mojsiju, “da je ovaj narod tvrde šije. ");
INSERT INTO hrv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Pusti sada neka se moj gnjev na njih raspali da ih istrijebim. Onda ću od tebe razviti velik narod.” ");
INSERT INTO hrv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mojsije pak zapomagao pred Jahvom, Bogom svojim, i govorio: “O Jahve! Čemu da gnjevom plamtiš na svoj narod koji si izbavio iz zemlje egipatske silom velikom i rukom jakom! ");
INSERT INTO hrv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Zašto bi Egipćani morali reći: 'U zloj ih je namjeri i odveo, tako da ih smakne u brdinama i izbriše s lica zemlje!' Smiri svoj gnjev i ljutinu; odustani od zla svome narodu! ");
INSERT INTO hrv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Sjeti se Abrahama, Izaka i Izraela, slugu svojih, kojima si se samim sobom zakleo i obećao im: 'Razmnožit ću vaše potomstvo kao zvijezde na nebu i svu zemlju ovu što sam obećao dat ću vašem potomstvu i ona će zavazda biti njihova baština.'” ");
INSERT INTO hrv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","I Jahve odustane da na svoj narod svali nesreću kojom mu bijaše zaprijetio. ");
INSERT INTO hrv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mojsije se okrene i siđe s brda. U rukama su mu bile dvije ploče Svjedočanstva, ploče ispisane na objema plohama; ispisane i s jedne i s druge strane. ");
INSERT INTO hrv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ploče su bile djelo Božje; pismo je bilo pismo Božje u pločama urezano. ");
INSERT INTO hrv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","A Jošua ču viku naroda koji je bučio pa reče Mojsiju: “Bojna vika u taboru!” ");
INSERT INTO hrv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mojsije mu odgovori: “Niti viču pobjednici, niti tuže pobijeđeni: tu ja samo pjesmu čujem.” ");
INSERT INTO hrv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Čim se približi taboru te opazi tele i kako igraju, razgnjevi se Mojsije. Baci iz ruku ploče i razbije ih na podnožju brda. ");
INSERT INTO hrv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Pograbi tele koje bijahu napravili, spali ga ognjem i u prah satre. Onda prah razbaca po vodi i natjera Izraelce da je piju. ");
INSERT INTO hrv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","“Što ti je ovaj puk učinio”, reče Mojsije Aronu, “da si tako velik grijeh na nj svalio?” ");
INSERT INTO hrv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","“Neka se moj gospodar srdžbom ne raspaljuje”, odgovori Aron. “Sam dobro znaš kako je ovaj narod na zlo sklon. ");
INSERT INTO hrv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Rekoše mi: 'Napravi nam boga pa neka pred nama ide! Ne znamo što se dogodi s tim čovjekom Mojsijem koji nas izbavi iz zemlje egipatske.' ");
INSERT INTO hrv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Na to im ja rekoh: 'Tko ima zlata, neka ga skine!' Tako mi ga dadoše, a ja ga bacih u vatru te izađe ovo tele.” ");
INSERT INTO hrv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Kad je Mojsije vidio kako je narod postao razuzdan - tÓa Aron ih je pustio da padnu u idolopoklonstvo među svojim neprijateljima - ");
INSERT INTO hrv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","stade na taborskim vratima i povika: “Tko je za Jahvu, k meni!” Svi se sinovi Levijevi okupe oko njega. ");
INSERT INTO hrv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","On im reče: “Ovako govori Jahve, Bog Izraela: 'Neka svatko pripaše mač o bedro i pođe taborom od vrata do vrata pa neka ubije tko svoga brata, tko svoga prijatelja, tko svoga susjeda.'” ");
INSERT INTO hrv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Sinovi Levijevi izvršiše Mojsijev nalog, i toga dana pade naroda oko tri tisuće ljudi. ");
INSERT INTO hrv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","“Danas ste se posvetili Jahvi za službu”, reče Mojsije, “tko uz cijenu svoga sina, tko uz cijenu svoga brata, tako da vam danas daje blagoslov.” ");
INSERT INTO hrv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Sutradan reče Mojsije narodu: “Težak ste grijeh počinili. Ipak ću se Jahvi popeti. Možda za vaš grijeh oproštenje pribavim.” ");
INSERT INTO hrv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mojsije se vrati Jahvi pa reče: “Jao! Narod onaj težak je grijeh počinio napravivši sebi boga od zlata. ");
INSERT INTO hrv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ipak im taj grijeh oprosti... Ako nećeš, onda i mene izbriši iz svoje knjige koju si napisao.” ");
INSERT INTO hrv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nato Jahve odgovori Mojsiju: “Onoga koji je protiv mene sagriješio izbrisat ću iz svoje knjige. ");
INSERT INTO hrv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Nego, idi sad! Povedi narod kamo sam ti rekao. Anđeo će moj pred tobom ići. Ali u dan kad ih pohodim, zbog njihova ću ih grijeha kazniti.” ");
INSERT INTO hrv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Udari Jahve po narodu pomorom zbog teleta što im ga Aron načini. ");
INSERT INTO hrv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Jahve reče Mojsiju: “Idi! Putuj odavde, ti i narod koji si izveo iz zemlje egipatske, u zemlju za koju sam se zakleo Abrahamu, Izaku i Jakovu da ću je dati njihovim potomcima. ");
INSERT INTO hrv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Pred tobom ću poslati anđela; istjerat ću Kanaance, Amorejce, Hetite, Perižane, Hivijce i Jebusejce. ");
INSERT INTO hrv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Idite u zemlju kojom teče mlijeko i med. Ja s vama neću poći - jer ste narod tvrde šije - da vas putem ne istrijebim.” ");
INSERT INTO hrv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kad narod ču ove oštre riječi, poče tugovati. I nitko više ne stavi na se svoga nakita. ");
INSERT INTO hrv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Jer reče Jahve Mojsiju: “Kaži Izraelcima: 'Vi ste narod tvrde šije. Kad bih ja s vama išao samo čas, uništio bih vas. Stoga skinite svoj nakit, a ja ću vidjeti što ću s vama učiniti.'” ");
INSERT INTO hrv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Tako su od brda Horeba Izraelci bili bez nakita. ");
INSERT INTO hrv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mojsije uze Šator i razape ga izvan tabora, daleko od tabora. I nazva ga Šator sastanka. Tko bi se god htio obratiti Jahvi, pošao bi k Šatoru sastanka, koji se nalazio izvan tabora. ");
INSERT INTO hrv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kad bi god Mojsije pošao u Šator, sav bi se narod digao; svatko bi stajao kod ulaza u svoj šator i gledao za Mojsijem dok ne bi ušao u Šator. ");
INSERT INTO hrv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","A kad bi Mojsije ušao u Šator, stup bi se oblaka spustio i ostajao na ulazu u Šator dok je Jahve s Mojsijem razgovarao. ");
INSERT INTO hrv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Videći kako stup oblaka stoji na ulazu Šatora, sav bi se narod tada dizao i svatko bi se duboko klanjao na vratima svoga šatora. ");
INSERT INTO hrv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Tako bi Jahve razgovarao s Mojsijem licem u lice, kao što čovjek govori s prijateljem. Mojsije bi se poslije vratio u tabor, ali se njegov pomoćnik Jošua, sin Nunov, mlađarac, iz Šatora ne bi micao. ");
INSERT INTO hrv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mojsije oslovi Jahvu: “Vidi, ti si meni rekao: 'Povedi ovaj narod', ali mi nisi objavio koga ćeš sa mnom poslati. Još si mi rekao: 'Znam te po imenu, i ti uživaš moju blagonaklonost.' ");
INSERT INTO hrv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Stoga, ako uživam tvoju blagonaklonost, objavi mi svoje putove da te shvatim i da dalje uživam tvoju blagonaklonost. Promisli također da je ova svjetina tvoj narod.” ");
INSERT INTO hrv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","“Ja ću osobno s tobom poći”, odgovori Jahve, “i počinak ti priuštiti.” ");
INSERT INTO hrv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","“Ako ti ne pođeš”, nadoda Mojsije, “odavde nas i ne izvodi. ");
INSERT INTO hrv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","TÓa kako će se znati da uživamo tvoju naklonost, ja i tvoj narod? Po tome što ideš s nama. Time ćemo se samo razlikovati ja i tvoj narod među svim narodima koji su na licu zemlje.” ");
INSERT INTO hrv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","“I ovo što si zatražio, učinit ću”, odgovori Jahve Mojsiju. “TÓa ti uživaš moju blagonaklonost jer te po imenu poznajem.” ");
INSERT INTO hrv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","“Pokaži mi svoju slavu”, zamoli Mojsije. ");
INSERT INTO hrv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","“Dopustit ću da ispred tebe prođe sav moj sjaj”, odgovori, “i pred tobom ću izustiti svoje ime Jahve. Bit ću milostiv kome hoću da milostiv budem; smilovat ću se komu hoću da se smilujem. ");
INSERT INTO hrv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","A ti”, doda, “moga lica ne možeš vidjeti, jer ne može čovjek mene vidjeti i na životu ostati. ");
INSERT INTO hrv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Evo mjesta ovdje uza me”, nastavi Jahve. “Stani na pećinu! ");
INSERT INTO hrv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Dok moja slava bude prolazila, stavit ću te u pukotinu pećine i svojom te rukom zakloniti dok ne prođem. ");
INSERT INTO hrv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Onda ću ja svoju ruku maknuti, pa ćeš me s leđa vidjeti. Ali se lice moje ne može vidjeti.” ");
INSERT INTO hrv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Reče Jahve Mojsiju: “Okleši dvije kamene ploče kao i prijašnje pa ću ja na ploče napisati riječi koje su bile na prvim pločama što si ih razbio. ");
INSERT INTO hrv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Budi gotov do jutra. Onda, ujutro, popni se na brdo Sinaj i ondje ćeš, navrh brda, stupiti preda me. ");
INSERT INTO hrv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nitko drugi neka se s tobom ne penje; neka se nitko nigdje na brdu ne pokaže. Neka ni ovce ni goveda ne pasu podno brda.” ");
INSERT INTO hrv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mojsije okleše dvije kamene ploče kao i prijašnje; rano jutrom ustane i popne se na Sinajsko brdo, uzevši u ruke dvije kamene ploče, kako mu je Jahve naredio. ");
INSERT INTO hrv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Jahve se spusti u liku oblaka, a on stade preda nj i zazva Ime: “Jahve!” ");
INSERT INTO hrv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Jahve prođe ispred njega te se javi: “Jahve! Jahve! Bog milosrdan i milostiv, spor na srdžbu, bogat ljubavlju i vjernošću, ");
INSERT INTO hrv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","iskazuje milost tisućama, podnosi opačinu, grijeh i prijestup, ali krivca nekažnjena ne ostavlja nego kažnjava opačinu otaca na djeci - čak na unučadi do trećega i četvrtog koljena.” ");
INSERT INTO hrv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mojsije smjesta pade na zemlju i pokloni se. ");
INSERT INTO hrv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Onda reče: “Gospodine moj! Ako sam stekao blagonaklonost u tvojim očima, onda, o Gospodine, pođi s nama! Premda je narod tvrde šije, oprosti naše grijehe i naše opačine i primi nas za svoju baštinu!” ");
INSERT INTO hrv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","“Dobro”, odgovori, “sklapam Savez. Pred cijelim tvojim pukom činit ću čudesa kakva se nisu događala ni u kojoj zemlji, ni u kojem narodu. Sav narod koji te okružuje vidjet će što može Jahve, jer ono što ću s tobom učiniti bit će strašno. ");
INSERT INTO hrv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Vrši, dakle, što ti danas nalažem! Gle, protjerat će ispred tebe Amorejce, Kanaance, Hetite, Perižane, Hivijce i Jebusejce. ");
INSERT INTO hrv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Čuvaj se da ne praviš saveza sa stanovnicima zemlje u koju ideš; da ne budu zamkom u tvojoj sredini. ");
INSERT INTO hrv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nego porušite njihove žrtvenike, oborite njihove stupove, počupajte im ašere! ");
INSERT INTO hrv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Jer ne smiješ se klanjati drugome bogu. TÓa Jahve - ime mu je Ljubomorni - Bog je ljubomoran. ");
INSERT INTO hrv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ne pravi saveza sa stanovnicima one zemlje da te oni, kad se odaju bludnosti sa svojim bogovima i žrtve im budu prinosili, ne bi pozivali, a ti pristao da jedeš od prinesene žrtve; ");
INSERT INTO hrv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","da ne bi uzimao njihove djevojke za žene svojim sinovima, da one - odajući se bludništvu sa svojim bogovima - ne bi za sobom povele i tvoje sinove. ");
INSERT INTO hrv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ne pravi sebi livenih bogova! ");
INSERT INTO hrv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Drži Blagdan beskvasnoga kruha - jedući beskvasni kruh sedam dana, kako sam ti naredio - u određeno vrijeme u mjesecu Abibu, jer si u mjesecu Abibu izišao iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Svako prvorođenče materinjega krila meni pripada: svako muško, svaki prvenac tvoga i sitnoga i krupnoga blaga. ");
INSERT INTO hrv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Prvenca od magarice otkupi jednim grlom sitne stoke. Ako ga ne otkupiš, moraš mu šijom zavrnuti. A sve prvorođence od svojih sinova otkupljuj. Neka nitko preda me ne stupa praznih ruku! ");
INSERT INTO hrv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Šest dana radi, a sedmoga od poslova odustani, sve ako je u doba oranja ili u vrijeme žetve. ");
INSERT INTO hrv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Svetkuj Blagdan sedmica - prvine pšenične žetve - i Blagdan berbe na prekretu godine. ");
INSERT INTO hrv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Triput na godinu neka se svi muškarci pojave pred Gospodinom Jahvom, Bogom Izraelovim. ");
INSERT INTO hrv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Jer ću protjerati narode ispred tebe i proširiti tvoje međe te nitko neće hlepiti za tvojom zemljom kad triput u godini budeš uzlazio da se pokažeš pred Jahvom, Bogom svojim. ");
INSERT INTO hrv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Od žrtve koju mi namjenjuješ ne prinosi krvi ni s čim ukvasanim; niti ostavljaj žrtve prinesene na blagdan Pashe da prenoći do jutra. ");
INSERT INTO hrv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","U kuću Jahve, Boga svoga, donosi najbolje prvine plodova sa svoje zemlje. Ne kuhaj kozleta u mlijeku njegove majke. ");
INSERT INTO hrv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Zapiši ove riječi”, reče Jahve Mojsiju, “jer su one temelji na kojima sam s tobom i s Izraelom sklopio Savez.” ");
INSERT INTO hrv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mojsije ostade ondje s Jahvom četrdeset dana i četrdeset noći. Niti je kruha jeo niti je vode pio. Tada je na ploče ispisao riječi Saveza - Deset zapovijedi. ");
INSERT INTO hrv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Napokon Mojsije siđe sa Sinajskog brda. Silazeći s brda, nosio je u rukama ploče Svjedočanstva. Nije ni znao da iz njegova lica, zbog razgovora s Jahvom, izbija svjetlost. ");
INSERT INTO hrv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Kad su Aron i svi Izraelci vidjeli kako iz Mojsijeva lica izbija svjetlost, ne usudiše se k njemu pristupiti. ");
INSERT INTO hrv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Onda ih Mojsije zovnu. Tada k njemu dođoše Aron i sve starješine zajednice. I Mojsije razgovaraše s njima. ");
INSERT INTO hrv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Poslije k njemu dođoše i svi Izraelci, pa im on priopći sve što mu je naložio Jahve na Sinajskom brdu. ");
INSERT INTO hrv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Kad je Mojsije završio razgovor s njima, prevuče preko svoga lica koprenu. ");
INSERT INTO hrv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kad bi god Mojsije ulazio pred Jahvu da s njim razgovara, koprenu bi skinuo dok opet ne bi izišao. Kad bi izlazio da Izraelcima kaže što mu je naređeno, ");
INSERT INTO hrv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Izraelci bi vidjeli kako iz Mojsijeva lica izbija svjetlost. Tada bi Mojsije opet prevukao koprenu preko lica dok ne uđe da s Jahvom govori. ");
INSERT INTO hrv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mojsije sazva svu zajednicu sinova Izraelovih pa im reče: “Ovo vam je Jahve naložio da činite: ");
INSERT INTO hrv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Neka se posao obavlja šest dana. Sedmi dan neka vam bude sveti dan, dan potpunog počinka u čast Jahvi. Tko bi radio u taj dan neka se kazni smrću. ");
INSERT INTO hrv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Na subotnji dan ni vatre ne ložite po svojim stanovima.” ");
INSERT INTO hrv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Nadalje Mojsije reče svoj zajednici izraelskoj: “Ovo je Jahve naredio: ");
INSERT INTO hrv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Među sobom pokupite prinos Jahvi! Tko god je plemenita srca neka Jahvi donese prinos: zlata, srebra i tuča; ");
INSERT INTO hrv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana; ");
INSERT INTO hrv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","učinjenih ovnujskih koža, onda finih koža, bagremova drva, ");
INSERT INTO hrv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ulja za svjetlo, mirodija za ulje pomazanja i miomirisni tamjan; ");
INSERT INTO hrv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","oniksa i drugoga dragog kamenja za umetanje u oplećak i naprsnik. ");
INSERT INTO hrv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","A svi koji su među vama vješti neka dođu praviti što je Jahve naredio: ");
INSERT INTO hrv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Prebivalište, njegov Šator i pokrov; njegove kuke i trenice, njegove priječnice i stupce; njegova podnožja; ");
INSERT INTO hrv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","njegov Kovčeg i motke; Pomirilište pa zavjesu za zaklon; ");
INSERT INTO hrv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","stol s njegovim motkama i sve njegove potrepštine; prinesene hljebove; ");
INSERT INTO hrv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","svijećnjak za svjetlo, njegov pribor i njegove svijeće, onda ulje za svjetlo; ");
INSERT INTO hrv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","kadioni žrtvenik i njegove motke; ulje za pomazanje i miomirisni tamjan; zastorak na ulazu u Prebivalište; ");
INSERT INTO hrv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","žrtvenik za žrtve paljenice s njegovom rešetkom od tuča; motke za nj i sav njegov pribor; umivaonik i njegov stalak; ");
INSERT INTO hrv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","zastore za dvorište; stupce i njihova podnožja, pa zastor na ulazu u dvorište; ");
INSERT INTO hrv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","kočiće za Prebivalište i kočiće za dvorište s njihovim uzicama; ");
INSERT INTO hrv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","svečano ruho za vršenje službe u Svetištu - posvećena odijela za svećenika Arona i odijela za svećeničku službu njegovih sinova.” ");
INSERT INTO hrv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Nato se sva izraelska zajednica povuče ispred Mojsija. ");
INSERT INTO hrv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","A onda svatko koga je srce vuklo i duša poticala dođe noseći svoj prinos u čast Jahvi za gradnju Šatora sastanka, za svaku službu u njemu i za posvećena odijela. ");
INSERT INTO hrv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Strčaše se muževi i žene: svi koje je srce vuklo donesoše zapinjača, naušnica, prstenja, narukvica, ogrlica i svakovrsna zlatnog nakita; svi koji bijahu zavjetovali kakvu zlatninu u čast Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Svi kod kojih se našlo ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana, učinjenih ovnujskih koža ili finih koža donesoše svoje. ");
INSERT INTO hrv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Nadalje, svatko tko je mogao dati kakav dar u srebru ili tuču donese to kao prinos u čast Jahvi. Svatko u koga se našlo bagremova drva za upotrebu u bilo kojem poslu, donese ga. ");
INSERT INTO hrv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Sve žene koje su bile vješte prele su svojim rukama i donosile što bijahu oprele: ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana. ");
INSERT INTO hrv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Sve opet žene koje je njihovo srce poticalo zbog njihove vještine prele su kostrijet. ");
INSERT INTO hrv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Glavari su donosili oniksa i drugoga dragog kamenja za umetanje u oplećak i naprsnik; ");
INSERT INTO hrv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","pa mirodije i ulje za svjetlo, ulje za pomazanje i miomirisni tamjan. ");
INSERT INTO hrv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","I tako Izraelci - svi ljudi i sve žene koje je srce poticalo da pridonesu bilo što poslu koji je Jahve po Mojsiju naredio da se izvrši - donesoše to kao dragovoljan prinos u čast Jahvi. ");
INSERT INTO hrv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Potom reče Mojsije Izraelcima: “Vidite! Jahve je po imenu pozvao Besalela, sina Urijeva, od koljena Hurova a iz plemena Judina. ");
INSERT INTO hrv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Njega je napunio duhom Božjim, dao mu umješnost, sposobnost i razumijevanje u svim poslovima: ");
INSERT INTO hrv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","da zamišlja nacrte i da radove izvodi od zlata, srebra i tuča; ");
INSERT INTO hrv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","da reže dragulje za umetanje; da urezuje u drvetu i da umješno radi svaki posao. ");
INSERT INTO hrv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Njemu i Oholiabu, sinu Ahisamakovu, od plemena Danova, udijeli i sposobnost da poučavaju druge. ");
INSERT INTO hrv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Obdari ih umještvom u svakom poslu rezbarskom, krojačkom, veziljskom i tkalačkom; oni tkaju tkanine od ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana, sposobni su u svakom poslu i vješti u nacrtima. ");
INSERT INTO hrv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Stoga neka Besalel, Oholiab i svi vještaci koje je Jahve obdario vještinom i sposobnošću da vješto izvedu sve poslove oko podizanja Svetišta obave sve kako je Jahve naredio.” ");
INSERT INTO hrv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mojsije onda pozva Besalela, Oholiaba i sve one što ih je Jahve obdario vještinom; sve koje je srce poticalo da se prihvate posla i izvedu ga. ");
INSERT INTO hrv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Oni preuzmu od Mojsija sve prinose koje Izraelci bijahu donijeli da se izvedu poslovi oko podizanja Svetišta. Ali kako su oni i dalje donosili prinose jutro za jutrom, ");
INSERT INTO hrv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","svi majstori koji su gradili Svetište dođu - svaki s posla na kojem je radio - ");
INSERT INTO hrv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","i reknu Mojsiju: “Svijet donosi mnogo više nego što je potrebno za izvođenje posla koji nam je Jahve naredio da izvedemo.” ");
INSERT INTO hrv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Zato Mojsije izda naredbu koju po taboru proglase: “Neka više nijedan čovjek ni žena ne donosi nikakva priloga za Svetište!” Tako ustave narod te nije donosio novih darova. ");
INSERT INTO hrv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Što imahu bijaše dosta da se izvede sve djelo; i još je pretjecalo. ");
INSERT INTO hrv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","I tako najvještiji ljudi među radnicima naprave Prebivalište. Načine ga od deset zavjesa od prepredenog lana i ljubičastog, crvenog i tamnocrvenog prediva. Na njima bijahu izvezeni likovi kerubina. ");
INSERT INTO hrv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Dužina je svake zavjese iznosila dvadeset osam lakata, a širina svake zavjese četiri lakta. Sve su zavjese bile iste mjere. ");
INSERT INTO hrv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pet zavjesa sastave jednu s drugom, a pet drugih zavjesa sastave opet jednu s drugom. ");
INSERT INTO hrv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Na rubu posljednje od zavjesa sastavljenih u jedno načine petlje od modre vune; jednako ih načine i na rubu posljednje zavjese drugoga dijela; ");
INSERT INTO hrv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","načine pedeset petlji na jednome komadu, a pedeset na rubu zavjese drugoga komada. Petlje su stajale jedna spram druge. ");
INSERT INTO hrv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Onda naprave pedeset zlatnih kopča pa sastave zavjese kopčama jednu s drugom. Tako je Prebivalište bilo kao jedna cjelina. ");
INSERT INTO hrv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Zatim za Šator povrh Prebivališta načine zavjese od kostrijeti; načine ih jedanaest. ");
INSERT INTO hrv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Dužina svake zavjese bila je trideset lakata, a širina četiri lakta. Tih jedanaest zavjesa bilo je iste mjere. ");
INSERT INTO hrv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Sastave pet zavjesa za se, a šest drugih opet za se. ");
INSERT INTO hrv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Naprave pedeset petlji na rubu zavjese jednoga komada, a pedeset načine na rubu drugoga komada. ");
INSERT INTO hrv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Načine i pedeset kopča od tuča da sastave Šator zajedno, tako da bude jedna cjelina. ");
INSERT INTO hrv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Zatim naprave pokrov za Šator od učinjenih ovnujskih koža, a povrh njega drugi, od finih koža. ");
INSERT INTO hrv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Trenice nauzgor za Prebivalište izrade od bagremova drva. ");
INSERT INTO hrv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Duljina je svake trenice bila deset lakata, a širina lakat i pol. ");
INSERT INTO hrv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Svaka je trenica imala dva klina da je drže uspravno. To su napravili na svakoj trenici za Šator. ");
INSERT INTO hrv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Trenice za Prebivalište napravili su ovako: dvadeset trenica za južnu stranu; ");
INSERT INTO hrv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","napravili su četrdeset podnožja od srebra pod dvadeset trenica - dva podnožja pod prvu trenicu za njezina dva klina i dva podnožja pod svaku slijedeću trenicu za njezina dva klina. ");
INSERT INTO hrv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Za drugu, sjevernu, stranu Prebivališta naprave dvadeset trenica ");
INSERT INTO hrv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","i za njih četrdeset podnožja od srebra - dva podnožja pod prvu trenicu, a po dva podnožja pod svaku slijedeću trenicu. ");
INSERT INTO hrv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Prebivalištu straga, prema zapadu, napraviše šest trenica. ");
INSERT INTO hrv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Naprave i dvije trenice za uglove Prebivališta straga. ");
INSERT INTO hrv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Pri dnu su bile rastavljene, ali su se pri vrhu, kod prvoga koluta, sastajale. Tako su ih obje postavili za dva ugla. ");
INSERT INTO hrv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Bilo je osam trenica s njihovim podnožjima od srebra: šesnaest podnožja, pod svakom trenicom dva. ");
INSERT INTO hrv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Načine priječnice od bagremova drva: pet njih za trenice s jedne strane Prebivališta, ");
INSERT INTO hrv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","a pet opet priječnica za trenice s druge strane Prebivališta te pet priječnica za trenice Prebivalištu straga, prema zapadu. ");
INSERT INTO hrv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Onda načine središnju priječnicu što je prolazila sredinom trenica s kraja na kraj. ");
INSERT INTO hrv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Trenice oblože zlatom, a njihove kolutove, kroz koje su priječnice bile provučene, načine od zlata. I priječnice oblože zlatom. ");
INSERT INTO hrv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Naprave zavjesu od ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana; načine je s izvezenim kerubinima. ");
INSERT INTO hrv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Za nju naprave četiri stupa od bagremova drva i oblože ih zlatom. Kuke su im bile od zlata, a saliju im i četiri podnožja od srebra. ");
INSERT INTO hrv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Na ulazu u Šator naprave zavjesu od ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana, umjetnički protkanu, ");
INSERT INTO hrv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","i za nju pet stupčića s njihovim kukama. Vrhove stupčića i njihove šipke oblože zlatom, dok im pet podnožja naprave od tuča. ");
INSERT INTO hrv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalel napravi Kovčeg od bagremova drva, dug dva i pol lakta, širok lakat i pol, a lakat i pol visok. ");
INSERT INTO hrv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Iznutra ga i izvana okuje čistim zlatom. Naokolo mu napravi zlatan završni pojas. ");
INSERT INTO hrv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","I salije mu četiri koluta na njegova četiri ugla: dva koluta s jedne strane, a dva koluta s njegove druge strane. ");
INSERT INTO hrv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Napravi i motke od bagremova drva i u zlato ih okuje; ");
INSERT INTO hrv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","onda provuče motke kroz kolutove Kovčegu sa strane za nošenje Kovčega. ");
INSERT INTO hrv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Zatim napravi Pomirilište od čistoga zlata, dva i pol lakta dugo, a lakat i pol široko. ");
INSERT INTO hrv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Napravi i dva kerubina od kovanoga zlata, na dva kraja Pomirilišta: ");
INSERT INTO hrv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","jednoga kerubina na jednome kraju, a drugoga kerubina na drugome kraju. Kerubine na oba kraja načini u jednome komadu s Pomirilištem. ");
INSERT INTO hrv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kerubini imali uzdignuta i raširena krila, zaklanjali njima Pomirilište. Bili su licem okrenuti jedan prema drugome, tako da su im lica gledala u Pomirilište. ");
INSERT INTO hrv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Od bagremova drva načini stol, dva lakta dug, lakat širok, a lakat i pol visok. ");
INSERT INTO hrv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Obloži ga čistim zlatom i od zlata mu naokolo načini završni pojas. ");
INSERT INTO hrv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","I načini mu obrub unaokolo, podlanicu širok. A za obrub naokolo načini zlatan završni pojas. ");
INSERT INTO hrv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Salije mu četiri zlatna koluta. Kolutove onda pričvrsti za njegova četiri nožna ugla. ");
INSERT INTO hrv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Kolutovi su bili tik pod obrubom, kao kvake za motke, da se stol može nositi. ");
INSERT INTO hrv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Motke za nošenje stola načinio je od bagremova drva i zlatom ih obložio. ");
INSERT INTO hrv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","A pribor što se držao na stolu - njegove zdjele, varjače, vrčeve i pehare za izlijevanje prinosa - napravio je od čistoga zlata. ");
INSERT INTO hrv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Od čistoga zlata načini i svijećnjak. Svijećnjak - njegovo podnožje i stalak - skova. Njegove čaše - čaške i latice - bile su u jednome komadu s njim. ");
INSERT INTO hrv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Šest je krakova izbijalo s njegovih strana: tri kraka svijećnjaka s jedne strane, a tri kraka svijećnjaka s druge strane. ");
INSERT INTO hrv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Na jednome kraku bile su tri čaše u obliku bademova cvijeta, svaka sa svojom čaškom i laticama. Na drugome opet kraku bile su tri čaše u obliku bademova cvijeta, svaka s čaškom i laticama. Tako je bilo na svih šest krakova što izbijahu iz svijećnjaka. ");
INSERT INTO hrv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na samome svijećnjaku bile su četiri čaše u obliku bademova cvijeta, svaka s čaškom i laticama: ");
INSERT INTO hrv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","čaška, u jednom komadu s njim, pod prva dva kraka; pa konačno čaška, u jednom komadu s njim, pod zadnja dva kraka. Tako na svih šest krakova što su iz njega izbijali. ");
INSERT INTO hrv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Njihove čaške i njihove peteljke bile su u jednom komadu s njim; sve to od čistoga kovanog zlata. ");
INSERT INTO hrv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","A od čistoga zlata napravi mu i sedam svjetiljaka, usekače i pepeljare. ");
INSERT INTO hrv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Svijećnjak i sav njegov pribor načini od jednoga talenta čistoga zlata. ");
INSERT INTO hrv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Kadioni je žrtvenik napravio od bagremova drva, lakat dug, lakat širok - u četvorinu - a dva lakta visok. Roščići su mu bili u jednom komadu s njim. ");
INSERT INTO hrv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Obloži mu čistim zlatom plohu, strane naokolo i njegove roščiće. Načini mu naokolo završni pojas od zlata. ");
INSERT INTO hrv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Na njemu načini i dva zlatna koluta na oprečnim stranama, ispod završnog pojasa, da služe motkama za kvake kad se na njima nosi. ");
INSERT INTO hrv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Motke načini od bagremova drva pa ih obloži zlatom. ");
INSERT INTO hrv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Onda pripravi posvećeno ulje za pomazanje i čisti kad mirisni, onako kako ga pravi pomastar. ");
INSERT INTO hrv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Od bagremova drva napravi žrtvenik za žrtve paljenice, pet lakata dug, pet lakata širok - u četvorinu - a tri lakta visok. ");
INSERT INTO hrv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Na njegova četiri ugla načini mu četiri roga. Rogovi su bili u jednom komadu s njim. Onda ga obloži tučem. ");
INSERT INTO hrv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","A načini i sav pribor za žrtvenik: lonce, strugače, kotliće, viljuške i kadionike; sav mu je ovaj pribor načinio od tuča. ");
INSERT INTO hrv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Za žrtvenik zatim načini rešetku u obliku mrežice od tuča ispod izbočine; zahvaćala mu je do sredine. ");
INSERT INTO hrv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Salije četiri koluta na četiri ugla tučane rešetke da služe kao kvake za motke. ");
INSERT INTO hrv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Motke načini od bagremova drva pa ih obloži tučem. ");
INSERT INTO hrv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Onda provuče motke kroz kolutove na objema stranama žrtvenika da se na njima nosi. Napravio ga je šuplja - od dasaka. ");
INSERT INTO hrv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","A zatim, od zrcala žena koje su posluživale na vratima Šatora sastanka, načini tučani umivaonik i tučani stalak za nj. ");
INSERT INTO hrv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Onda načini dvorište. Na južnoj strani dvorišta bijahu zavjese od prepredenog lana, stotinu lakata duge. ");
INSERT INTO hrv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Njihovih dvadeset stupova sa dvadeset podnožja bilo je od tuča, dok su kuke na stupovima i njihove šipke bile od srebra. ");
INSERT INTO hrv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Od stotinu lakata bile su zavjese i sa sjeverne strane. Njihovih dvadeset stupova sa dvadeset podnožja bilo je od tuča, dok su kuke na stupovima i njihove šipke bile od srebra. ");
INSERT INTO hrv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Sa zapadne strane bijahu zavjese od pedeset lakata, sa deset stupova i deset njihovih podnožja. Kuke su na stupovima i njihove šipke bile od srebra. ");
INSERT INTO hrv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Sprijeda, s istoka, zavjese od pedeset lakata. ");
INSERT INTO hrv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","S jedne strane vrata zavjese su bile petnaest lakata, sa tri stupca i njihova tri podnožja. ");
INSERT INTO hrv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Tako i s druge strane - dakle, na obje strane dvorišnih vrata - bile su zavjese od petnaest lakata, sa tri stupca i njihova tri podnožja. ");
INSERT INTO hrv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Sve su zavjese oko dvorišta bile od prepredenog lana. ");
INSERT INTO hrv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Podnožja za stupove bila su od tuča, a kuke na stupovima i njihove šipke od srebra. Vrhovi stupova bili su srebrom obloženi. Sve šipke na dvorišnim stupovima bijahu od srebra. ");
INSERT INTO hrv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Zavjesa na dvorišnim vratima - izvezena - bila je od ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana. Dvadeset je lakata bila duga; visoka, po širini, pet lakata kao i dvorišne zavjese. ");
INSERT INTO hrv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Bila su četiri njihova stupa sa četiri podnožja od tuča. Kuke na stupovima bile su od srebra. Vrhovi stupova bili su srebrom obloženi, a njihove šipke bile su srebrne. ");
INSERT INTO hrv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Svi kočići unutar Prebivališta bili su od tuča. ");
INSERT INTO hrv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","To je popis stvari za Prebivalište - Prebivalište Svjedočanstva, koji je sastavljen na zapovijed Mojsijevu trudom levita pod vodstvom Itamara, sina svećenika Arona. ");
INSERT INTO hrv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besalel, Urijev sin, iz koljena Hurova od plemena Judina napravio je sve što je Jahve Mojsiju naredio. ");
INSERT INTO hrv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","S njim je bio Oholiab, sin Ahisamakov, iz plemena Danova, rezbar, krojač i vezilac za ljubičasto, crveno i tamnocrveno predivo i prepredeni lan. ");
INSERT INTO hrv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Sve zlato što je utrošeno u radove oko Svetišta - zlato posvećeno prinosom - iznosilo je: dvadeset i devet talenata i sedam stotina trideset šekela u hramskim šekelima. ");
INSERT INTO hrv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","A srebro, sabrano prigodom upisivanja zajednice - ");
INSERT INTO hrv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","to jest beku po glavi, odnosno pola šekela prema hramskom šekelu, od svakoga koji je bio upisan, od dvadeset godina pa naprijed - iznosilo je: stotinu talenata i tisuću sedam stotina sedamdeset i pet šekela u hramskim šekelima. Bilo je upisanih: šest stotina tri tisuće i petsto pedeset. ");
INSERT INTO hrv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Stotinu talenata srebra otišlo je za salijevanje podnožja Svetištu i zavjesi: sto podnožja od sto talenata - talenat za podnožje. ");
INSERT INTO hrv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A od tisuću sedam stotina sedamdeset i pet šekela načinio je kuke za stupove, obložio njihove vrhove i napravio šipke za njih. ");
INSERT INTO hrv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Tuč od žrtve prikaznice iznosio je sedamdeset talenata i dvije tisuće četiri stotine šekela. ");
INSERT INTO hrv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Od njega je načinio: podnožja za ulaz u Šator sastanka, žrtvenik od tuča s njegovom tučanom rešetkom i sav pribor za žrtvenik; ");
INSERT INTO hrv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","dalje, podnožja oko dvorišta, podnožja za dvorišni ulaz; sve kočiće za Prebivalište i sve kočiće oko dvorišta. ");
INSERT INTO hrv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Od ljubičastog, crvenog i tamnocrvenog prediva naprave lijepo izrađeno ruho za službu u Svetištu; naprave svetu odjeću Aronu, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Oplećak naprave od zlata, ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana. ");
INSERT INTO hrv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Skuju zlatne pločice, a onda ih na niti izrežu da ih vještački uvezu u ljubičasto, crveno i tamnocrveno predivo i prepredeni lan. ");
INSERT INTO hrv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Za oplećak naprave poramenice koje su bile s njim sastavljene na svoja dva kraja; ");
INSERT INTO hrv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","tkanica što je na njemu stajala bila je napravljena od zlata, ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana kao i on, i u jednome komadu s njim, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Kamenje oniksa optoče obrubom od zlata. Na njima su, kao što se režu pečati, bila urezana imena Izraelovih sinova. ");
INSERT INTO hrv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Njih stave na poramenice oplećka da budu spomen-kamenje sinovima Izraelovim, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","I naprsnik izrade radovima vještaka kao i oplećak: od zlata, ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana. ");
INSERT INTO hrv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Naprsnik načiniše četverouglast, dvostruk; bio je pedalj dug, pedalj širok, a predvostručen. ");
INSERT INTO hrv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Umetnu u nj četiri reda dragulja. Prvi red bijaše od rubina, topaza i alema; ");
INSERT INTO hrv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","drugi red od smaragda, safira i ametista; ");
INSERT INTO hrv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","treći red od hijacinta, ahata i leca; ");
INSERT INTO hrv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","a četvrti red od krizolita, oniksa i jaspisa. Sve je bilo zlatom obrubljeno. ");
INSERT INTO hrv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Na kamenima su bila imena Izraelovih sinova. Na broj ih je bilo dvanaest, kao i njihovih imena. Bila su urezana kao i pečati - svaki kamen s imenom jednoga od dvanaest plemena. ");
INSERT INTO hrv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Za naprsnik naprave lančiće od čistoga zlata kao zasukane uzice. ");
INSERT INTO hrv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Naprave zatim dva zlatna okvira i dva zlatna kolutića pa pričvrste oba kolutića za dva gornja ugla naprsnika. ");
INSERT INTO hrv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Sad privežu ovdje zasukane uzice od zlata za dva kolutića što su bila pričvšćena za uglove naprsnika. ");
INSERT INTO hrv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Druga dva kraja zasukanih uzica pričvrste za dva okvira. Tako ih povežu za poramenice oplećka sprijeda. ");
INSERT INTO hrv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Potom načine dva zlatna kolutića pa ih pričvrste za dva kraja naprsnika uz nutarnji rub, okrenut prema oplećku. ");
INSERT INTO hrv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Još naprave dva zlatna kolutića te ih pričvrste za donji, prednji kraj poramenice oplećka, pokraj mjesta gdje se veže, povrh tkanice oplećka. ");
INSERT INTO hrv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Svežu kolutiće naprsnika s kolutićima oplećka modrom vrpcom, tako da naprsnik stoji nad tkanicom oplećka i da se s oplećka ne mogne odvojiti, kako je Jahve Mojsiju naredio. ");
INSERT INTO hrv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Naprave i ogrtač za oplećak, sav satkan od ljubičastog prediva. ");
INSERT INTO hrv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","U sredini je ogrtača bio prorez kao otvor na oklopu, prorez naokolo opšiven, da se ogrtač ne podere. ");
INSERT INTO hrv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","O donjem rubu ogrtača načine šipke od ljubičastog, crvenog i tamnocrvenog prediva i prepredenog lana. ");
INSERT INTO hrv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","A načine i zvonca od čistog zlata, pa zvonca privežu među šipke; sve naokolo donjeg ruba ogrtača između šipaka: ");
INSERT INTO hrv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","zvonce pa šipak, zvonce pa šipak okolo donjeg ruba ogrtača za vršenje službe, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Zatim od otkanog lana načine košulje Aronu i njegovim sinovima; ");
INSERT INTO hrv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","a naprave i mitru od lana i kape od lana; platnene gaće načine od prepredenog lana. ");
INSERT INTO hrv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","I pasovi su bili od prepredenog lana i od ljubičastog, crvenog i tamnocrvenog prediva, iglama izvezeni, kako je Jahve Mojsiju naredio. ");
INSERT INTO hrv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Načine i ploču, sveti vijenac, od čistoga zlata i na njoj urežu natpis kako se urezuje na pečatnome prstenu: “Posvećen Jahvi.” ");
INSERT INTO hrv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Za nju privežu modru vrpcu da je mogu svezati na vrhu mitre, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Tako su bili završeni svi radovi na Prebivalištu, Šatoru sastanka. Izraelci su sve načinili onako kako je Jahve Mojsiju naredio da načine. ");
INSERT INTO hrv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Onda donesu Mojsiju Prebivalište, Šator i sav njegov pribor: njegove kuke, njegove trenice, njegove priječnice, njegove stupove i njegova podnožja; ");
INSERT INTO hrv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","pokrov od učinjenih ovnujskih koža, pokrov od finih koža, zavjesu za zaklon; ");
INSERT INTO hrv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Kovčeg svjedočanstva s njegovim motkama i Pomirilištem; ");
INSERT INTO hrv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","stol i sav njegov pribor, prinesene hljebove, ");
INSERT INTO hrv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","svijećnjak od čistoga zlata s njegovim svijećama - svijeće već u red stavljene - i sav njegov pribor i ulje za svjetlo; ");
INSERT INTO hrv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","zlatni žrtvenik, ulje za pomazanje, miomirisni tamjan i zavjesu za ulaz Šatora; ");
INSERT INTO hrv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","žrtvenik od tuča s tučanom rešetkom; njegove motke i sav njegov pribor; umivaonik i njegov stalak; ");
INSERT INTO hrv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","zavjese za dvorište; njihove stupove i njihova podnožja, zavjesu za dvorišni ulaz, njegova užeta i njihove kočiće - sav pribor za službu u Prebivalištu, za Šator sastanka; ");
INSERT INTO hrv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","lijepo izrađeno ruho za službu u Svetištu - svetu odjeću za svećenika Arona i odijela za svećeničku službu njegovih sinova. ");
INSERT INTO hrv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Upravo kako je Jahve Mojsiju naredio, tako su Izraelci sav posao obavili. ");
INSERT INTO hrv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mojsije pregleda sve radove i utvrdi da su ih dovršili: kako je Jahve naredio, onako su ih i napravili. I Mojsije ih blagoslovi. ");
INSERT INTO hrv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Reče Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Na prvi dan prvoga mjeseca podigni Prebivalište, Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ondje postavi Kovčeg svjedočanstva, onda Kovčeg zakloni zavjesom. ");
INSERT INTO hrv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Potom unesi stol i što na nj spada poredaj; unesi i svijećnjak i svijeće mu pripremi. ");
INSERT INTO hrv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","A zlatni žrtvenik za kađenje postavi pred Kovčeg svjedočanstva. Onda objesi zastor nad ulazom u Prebivalište. ");
INSERT INTO hrv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Stavi žrtvenik za žrtve paljenice pred ulaz Prebivališta, Šatora sastanka. ");
INSERT INTO hrv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Između Šatora sastanka i žrtvenika smjesti umivaonik i u nj nalij vode. ");
INSERT INTO hrv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Naokolo napravi dvorište i objesi zastor nad dvorišnim ulazom. ");
INSERT INTO hrv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Zatim uzmi ulja za pomazanje pa pomaži Prebivalište i sve što je u njemu; posveti ga i sav njegov pribor, pa će svetim postati. ");
INSERT INTO hrv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Pomaži potom žrtvenik za žrtve paljenice i sav njegov pribor; posveti žrtvenik i presvetim će žrtvenik postati. ");
INSERT INTO hrv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Pomaži umivaonik s njegovim stalkom: posveti ga! ");
INSERT INTO hrv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Dovedi zatim Arona i njegove sinove na ulaz Šatora sastanka pa ih operi vodom. ");
INSERT INTO hrv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Stavi onda na Arona posvećenu odjeću; pomaži ga i posveti da mi služi kao svećenik. ");
INSERT INTO hrv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Dovedi i njegove sinove, na njih stavi košulje ");
INSERT INTO hrv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","i pomaži ih, kako si pomazao i njihova oca, da mi služe kao svećenici. Njihovo pomazanje neka ih uvede u vječno svećenstvo u sve njihove naraštaje.” ");
INSERT INTO hrv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Tako Mojsije učini. Kako mu je Jahve naredio, sve je tako i učinio. ");
INSERT INTO hrv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Prvoga dana prvoga mjeseca druge godine Prebivalište bi podignuto. ");
INSERT INTO hrv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ovako Mojsije namjesti Prebivalište: razmjesti njegova podnožja, onda uspravi njegove trenice, zatim postavi priječnice i podiže stupove. ");
INSERT INTO hrv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Zatim raspne Šator nad Prebivalište, a povrh njega stavi pokrov Šatora, kako je Jahve Mojsiju naredio. ");
INSERT INTO hrv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Uze onda Svjedočanstvo i stavi ga u Kovčeg; na Kovčeg postavi motke; onda stavi Pomirilište ozgo na Kovčeg. ");
INSERT INTO hrv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Potom unese Kovčeg u Prebivalište; objesi zavjesu za zaklon. Tako zastre Kovčeg svjedočanstva, kako je Jahve i naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Zatim postavi stol u Šator sastanka, Prebivalištu sa sjeverne strane, ali izvan zavjese. ");
INSERT INTO hrv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Po njemu poreda kruhove pred Jahvom, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Onda smjesti svijećnjak u Šator sastanka naprama stolu, na južnoj strani Prebivališta. ");
INSERT INTO hrv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","I postavi svjetiljke pred Jahvom, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Zlatni žrtvenik smjesti u Šator sastanka, pred zavjesu. ");
INSERT INTO hrv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Na njemu zapali miomirisnog tamjana, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Poslije toga stavi zavjesu na ulaz u Prebivalište. ");
INSERT INTO hrv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Kod ulaza u Prebivalište, u Šator sastanka, postavi žrtvenik za žrtve paljenice. Na njemu prinese žrtvu paljenicu i žrtvu od žita, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Između Šatora sastanka i žrtvenika smjesti umivaonik pa u nj ulije vode za pranje. ");
INSERT INTO hrv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Iz njega su Mojsije, Aron i njegovi sinovi prali svoje ruke i svoje noge. ");
INSERT INTO hrv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","A prali su se kad su ulazili u Šator sastanka i kad su pristupali k žrtveniku, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Napokon Mojsije napravi dvorište oko Prebivališta i žrtvenika i postavi zavjesu na dvorišnim vratima. Tako Mojsije završi taj posao. ");
INSERT INTO hrv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","A onda oblak prekri Šator sastanka i slava Jahvina ispuni Prebivalište. ");
INSERT INTO hrv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mojsije nije mogao ući u Šator sastanka zbog oblaka koji je na njemu stajao i slave Jahvine koja je ispunjala Prebivalište. ");
INSERT INTO hrv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Sve vrijeme njihova putovanja, kad god bi se oblak digao s Prebivališta, Izraelci bi krenuli; ");
INSERT INTO hrv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ali ako se oblak ne bi digao, ni oni ne bi na put polazili sve do dana dok se ne bi digao. ");
INSERT INTO hrv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Jer sve vrijeme njihova putovanja oblak Jahvin danju stajaše nad Prebivalištem, a noću bi se u oblaku pojavila vatra vidljiva svemu domu Izraelovu. ");
INSERT INTO hrv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Zovnu Jahve Mojsija te mu iz Šatora sastanka reče: ");
INSERT INTO hrv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Govori Izraelcima i kaži im: 'Kad tko od vas želi prinijeti Jahvi žrtvu od stoke, prinijet će je ili od krupne ili od sitne stoke. ");
INSERT INTO hrv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ako njegov prinos za žrtvu paljenicu bude od krupne stoke, neka prinese muško bez mane. Neka ga dovede k ulazu u Šator sastanka da pred Jahvom bude primljen. ");
INSERT INTO hrv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Neka stavi svoju ruku na glavu žrtve paljenice da mu za njegovo ispaštanje bude primljena. ");
INSERT INTO hrv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Neka zatim zakolje junca pred Jahvom. A Aronovi sinovi, svećenici, neka prinesu krv. Neka njome zapljusnu sve strane žrtvenika koji stoji pred ulazom u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Potom neka se žrtva sadre i rasiječe na dijelove. ");
INSERT INTO hrv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Neka sinovi Aronovi, svećenici, nalože vatru na žrtveniku i na vatru metnu drva. ");
INSERT INTO hrv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Neka zatim sinovi Aronovi, svećenici, naslažu dijelove, s glavom i lojem, na drva što su na vatri na žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Drobina i noge neka se operu u vodi. A onda neka svećenik sve sažeže u kad na žrtveniku. To je žrtva paljenica, žrtva paljena Jahvi na ugodan miris.' ");
INSERT INTO hrv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ako bi htio prinijeti za žrtvu paljenicu od sitne stoke - od ovaca ili koza - neka prinese muško bez mane. ");
INSERT INTO hrv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Neka ga zakolje pred Jahvom, na žrtveniku sa sjeverne strane. Neka zatim Aronovi sinovi, svećenici, zapljusnu žrtvenik krvlju sa svih strana. ");
INSERT INTO hrv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Potom neka je rasijeku na dijelove, a svećenik neka ih, s glavom i lojem, naslaže na drva što su na vatri na žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Drobina i noge neka se operu u vodi. Onda svećenik neka sve prinese i na žrtveniku sažeže. To je žrtva paljenica, žrtva paljena Jahvi na ugodan miris. ");
INSERT INTO hrv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Ako bi hto prinijeti Jahvi ptice kao žrtvu paljenicu, neka onda prinese grlicu ili golubića. ");
INSERT INTO hrv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Neka ga svećenik prinese k žrtveniku i, zavrnuvši mu vratom, otkine glavu i na žrtveniku sažeže. Zatim neka mu krv iscijedi žrtveniku sa strane. ");
INSERT INTO hrv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Neka mu gušu i perje ukloni i pobaca ih na istočnu stranu žrtvenika, na mjesto za otpatke. ");
INSERT INTO hrv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Neka ga raspori duž obaju krila, ali neka ih ne rastavlja. Onda neka ga svećenik na žrtveniku sažeže na drvima što su na vatri. To je žrtva paljenica, žrtva paljena Jahvi na ugodan miris.” ");
INSERT INTO hrv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Kad tko želi prinijeti Jahvi žrtvu prinosnicu, neka njegov dar bude od najboljeg brašna; neka ga polije uljem i na nj stavi tamjana. ");
INSERT INTO hrv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Neka ga onda donese Aronovim sinovima, svećenicima. Zatim neka zagrabi šaku od toga brašna i ulja i sav tamjan, pa neka svećenik na žrtveniku to sažeže u kad za spomen-žrtvu. To je žrtva paljena Jahvi na ugodan miris. ");
INSERT INTO hrv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","A što od žrtve prinosnice ostane, neka pripadne Aronu i njegovim sinovima - najsvetije od žrtava Jahvi paljenih. ");
INSERT INTO hrv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ako za žrtvu prinosnicu želiš prinijeti tijesta pečena u peći, neka to budu beskvasne pogače od najboljeg brašna, zamiješene u ulju, ili beskvasne prevrte uljem namazane. ");
INSERT INTO hrv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ako tvoj dar bude žrtva prinosnica pečena na tavi, neka bude od najboljeg brašna, neukvasana i u ulju zamiješena. ");
INSERT INTO hrv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","U komade je izlomi i po njima ulja polij: žrtva je to prinosnica. ");
INSERT INTO hrv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Bude li tvoja prinosnica kuhana u kotluši, neka bude od najboljeg brašna, pripravljena s uljem. ");
INSERT INTO hrv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Donosi Jahvi žrtvu prinosnicu tako pripravljenu! Neka se preda svećeniku, a on će je polagati na žrtvenik. ");
INSERT INTO hrv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Neka svećenik odvoji od žrtve prinosnice dio kao spomen-žrtvu, pa neka ga sažeže u kad na žrtveniku - kao žrtvu paljenu Jahvi na ugodan miris! ");
INSERT INTO hrv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","A što od žrtve prinosnice ostane, neka pripadne Aronu i njegovim sinovima - najsvetije od žrtava Jahvi paljenih. ");
INSERT INTO hrv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Nikakva žrtva prinosnica koju budeš prinosio Jahvi neka ne bude priređivana s kvasom, jer ne smiješ u kad sažigati ni kvasa ni meda kao žrtvu paljenicu. ");
INSERT INTO hrv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Prinosite ih Jahvi kao prvine plodova, ali neka se sa žrtvenika ne viju na ugodan miris. ");
INSERT INTO hrv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Svaku svoju žrtvu prinosnicu posoli. Ne ostavljaj svoje žrtve prinosnice bez soli Saveza sa svojim Bogom: sa svakim svojim prinosom prinesi i sol. ");
INSERT INTO hrv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ako prinosiš Jahvi žrtvu prinosnicu od prvina, prinesi tu žrtvu od prvina svojih plodova u obliku klasa pržena na vatri ili brašna od samljevenog zrnja. ");
INSERT INTO hrv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Dodaj još ulja i na nju stavi tamjana. To je žrtva prinosnica. ");
INSERT INTO hrv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Onda neka svećenik sažeže u kad za spomen-žrtvu dio kruha i ulja i sav tamjan kao žrtvu Jahvi paljenu.” ");
INSERT INTO hrv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Ako tko prinosi žrtvu pričesnicu te ako prinosi goveče - žensko ili muško - neka je bez mane što prinosi pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Neka stavi svoju ruku na glavu svoje žrtve i zakolje je na ulazu u Šator sastanka. Neka zatim Aronovi sinovi, svećenici, zapljusnu krvlju sve strane žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Od žrtve pričesne, kao žrtvu paljenu, neka prinese loj što omotava drobinu, sav loj što je oko drobine; ");
INSERT INTO hrv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","oba bubrega i loj što je na njima i na slabinama; pa privjesak s jetre: neka i njega s bubrezima izvadi. ");
INSERT INTO hrv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Zatim neka Aronovi sinovi te dijelove sažegu na žrtveniku sa žrtvom paljenicom koja bude na drvima na vatri. To neka je žrtva paljena Jahvi na ugodan miris. ");
INSERT INTO hrv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ako tko prinosi za žrtvu pričesnicu od sitne stoke Jahvi, neka prinese bez mane, bilo muško ili žensko. ");
INSERT INTO hrv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ako na dar prinosi ovcu, neka je prinese pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Neka stavi svoju ruku na glavu svoje žrtve i neka je zakolje pred Šatorom sastanka. Zatim neka Aronovi sinovi zapljusnu njezinom krvlju sve strane žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Od žrtve pričesnice neka prinesu žrtvu paljenu Jahvi: njezin loj, cio pretili rep, otkinuvši ga tik uz hrptenjaču; loj što omotava drobinu, sav loj što je oko drobine; ");
INSERT INTO hrv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","oba bubrega i loj što je na njima i na slabinama; pa privjesak s jetre: neka i njega s bubrezima izvadi. ");
INSERT INTO hrv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Onda neka svećenik to sažeže na žrtveniku u kad - kao hranu vatre u čast Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ako li prinosi kozu, neka je prinese pred Jahvom: ");
INSERT INTO hrv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","neka stavi svoju ruku na glavu svoje žrtve i neka je zakolje pred Šatorom sastanka. Neka zatim Aronovi sinovi zapljusnu njezinom krvlju sve strane žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Onda neka od nje prinese, kao paljenu žrtvu Jahvi, loj što omotava drobinu, sav loj što je oko drobine; ");
INSERT INTO hrv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","oba bubrega i loj što je na njima i na slabinama; pa privjesak s jetre; neka i njega s bubrezima izvadi. ");
INSERT INTO hrv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Onda neka ih svećenik sažeže na žrtveniku - žrtvu paljenu Jahvi na ugodan miris. Sav loj pripada Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Neka ovo bude zakon za sva vremena svim vašim naraštajima u kojem god mjestu budete boravili: nipošto ne smijete jesti ni loja ni krvi.” ");
INSERT INTO hrv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Ovako kaži Izraelcima: 'Ako se tko nehotice ogriješi o bilo koju Jahvinu zapovijed te učini što je zabranjeno činiti: ");
INSERT INTO hrv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Bude li to pomazanjem posvećeni svećenik koji pogriješi i navuče tako krivnju na narod, onda za grijeh koji učini neka prinese Jahvi jedno grlo krupne stoke, jednoga junca bez mane, kao žrtvu okajnicu. ");
INSERT INTO hrv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Neka junca dovede pred Jahvu do ulaza u Šator sastanka; neka juncu na glavu položi svoju ruku i onda junca zakolje pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Zatim neka pomazanjem posvećeni svećenik uzme krvi od junca i donese je u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Onda neka svećenik zamoči svoj prst u krv i tom krvlju neka sedam puta poškropi prednju stranu zavjese Svetišta, pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Potom neka svećenik stavi te krvi na rogove žrtvenika za miomirisni kad koji se dimi pred Jahvom u Šatoru sastanka. Svu ostalu krv od junca neka izlije podno žrtvenika za žrtve paljenice što se nalazi na ulazu u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Iz junca što ga prinosi kao žrtvu okajnicu neka izvadi: loj što omotava drobinu, sav loj što je oko drobine; ");
INSERT INTO hrv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","oba bubrega i loj što je na njima i na slabinama, privjesak s jetre; neka i njega izvadi s bubrezima; ");
INSERT INTO hrv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","onako kako se uzima dio iz vola žrtve pričesnice. Neka ih zatim svećenik sažeže u kad na žrtveniku za žrtve paljenice. ");
INSERT INTO hrv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Kožu od junca, sve meso od njega, njegovu glavu, njegove noge, drobinu i njegovu nečist ");
INSERT INTO hrv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","- svega junca - neka iznese na čisto mjesto izvan tabora gdje se pepeo izasiplje i neka ga spali na vatri od drva; tu na pepelu neka se junac spali.'” ");
INSERT INTO hrv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Ako sva izraelska zajednica nehotično pogriješi počinivši štogod što je Jahve zabranio pa tako postanu krivi a ne budu svjesni krivnje, ");
INSERT INTO hrv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","onda, kad se sazna za učinjeni prijestup, neka zajednica prinese jedno grlo krupne stoke - jednoga junca bez mane - kao žrtvu okajnicu. Neka ga dovedu pred Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Tu pred Jahvom neka starješine zajednice polože svoje ruke juncu na glavu. Neka se onda junac zakolje pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Neka zatim pomazanjem posvećeni svećenik donese krvi od junca u Šator sastanka; ");
INSERT INTO hrv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","neka svećenik zamoči svoj prst u krv i sedam puta poškropi prednju stranu zavjese, pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Neka zatim stavi krvi na rogove žrtvenika koji se nalazi pred Jahvom u Šatoru sastanka. Svu ostalu krv neka izlije podno žrtvenika za žrtve paljenice što se nalazi na ulazu u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","S junca neka skine sav loj i sažeže ga u kad na žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","I s juncem neka uradi kako je uradio s onim juncem žrtve okajnice - tako neka učini i s tim. I pošto svećenik nad članovima zajednice izvrši obred pomirenja, bit će im oprošteno. ");
INSERT INTO hrv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Neka odnese junca izvan tabora i spali ga kako je spalio i prvoga junca. To je žtrva za prijestup zajednice.” ");
INSERT INTO hrv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Ako nehotično pogriješi glavar i učini štogod što je Jahve, Bog njegov, zabranio i tako sagriješi, ");
INSERT INTO hrv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","onda, kad ga obznane o prijestupu koji je počinio, neka kao svoj prinos donese muško jare bez mane. ");
INSERT INTO hrv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Položivši svoju ruku jaretu na glavu, neka ga zakolje na mjestu gdje se kolju pred Jahvom žrtve paljenice. To je žrtva okajnica. ");
INSERT INTO hrv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Svećenik neka uzme na svome prstu krvi od žrtve okajnice pa je stavi na rogove žrtvenika za žrtve paljenice. A svu ostalu krv neka izlije podno žrtvenika za žrtve paljenice. ");
INSERT INTO hrv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Sav loj neka sažeže u kad na žrtveniku kao i loj sa žrtve pričesnice. Neka tako svećenik nad glavarom izvrši obred pomirenja za njegov grijeh, pa će mu biti oprošteno.” ");
INSERT INTO hrv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Ako tko od običnoga puka nehotično pogriješi učinivši štogod što je Jahve zabranio i tako sagriješi, ");
INSERT INTO hrv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","onda, kad ga obznane o prijestupu koji je počinio, neka kao svoj prinos za grijeh koji je počinio donese žensko jare bez mane. ");
INSERT INTO hrv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Neka stavi svoju ruku na glavu okajnice i zakolje žrtvu okajnicu na mjestu za žrtve paljenice. ");
INSERT INTO hrv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Neka svećenik uzme krvi na svome prstu pa je stavi na rogove žrtvenika za žrtve paljenice. A svu ostalu krv neka izlije podno žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Neka zatim izvadi sav njezin loj kao što se vadi loj iz žrtve pričesnice; neka ga onda svećenik sažeže u kad na žrtveniku kao ugodan miris Jahvi. Kad svećenik izvrši nad tim čovjekom obred pomirenja, bit će mu oprošteno. ");
INSERT INTO hrv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Ako bi tko htio dovesti janje kao žrtvu okajnicu, neka dovede žensko bez mane. ");
INSERT INTO hrv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Položivši svoju ruku na glavu žrtve okajnice, neka je zakolje kao žrtvu okajnicu na mjestu gdje se kolju žrtve paljenice. ");
INSERT INTO hrv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Neka onda svećenik uzme krvi od žrtve okajnice na svome prstu pa je stavi na rogove žrtvenika za žrtve paljenice. A svu ostalu krv neka izlije podno žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Neka zatim izvadi sav njezin loj kao što se vadi loj iz žrtve pričesnice. Neka to svećenik sažeže u kad povrh žrtava paljenih Jahvi u čast. Neka tako svećenik izvrši nad tim čovjekom obred pomirenja za grijeh koji je počinio, pa će mu biti oprošteno.” ");
INSERT INTO hrv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Zgriješi li tko tako što čuje riječi proklinjanja a odbije da svjedoči iako je mogao biti svjedokom jer je ili sam vidio ili doznao pa tako nosi krivnju na sebi; ");
INSERT INTO hrv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ili ako tko dirne kakav nečist predmet, strv nečiste zvijeri, strv nečista živinčeta ili strv nečista puzavca - i u neznanju postane nečist i odgovoran; ");
INSERT INTO hrv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ili kad se tko dotakne nečistoće čovječje, bilo to što mu drago od čega se nečistim postaje i toga ne bude svjestan, kad dozna, biva odgovoran; ");
INSERT INTO hrv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","nadalje, kad tko nepromišljeno izusti zakletvu na dobro ili zlo - na što se već čovjek nepromišljeno zaklinje - i toga ne bude svjestan, onda, kad dozna, biva odgovoran; ");
INSERT INTO hrv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ako, dakle, tko postane odgovoran u bilo čemu od toga, neka prizna počinjeni grijeh. ");
INSERT INTO hrv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","I neka prinese Jahvi kao žrtvu naknadnicu za počinjeni grijeh jednu ženku od sitne stoke, janje ili kozle, kao žrtvu okajnicu. Neka svećenik izvrši nad njim obred pomirenja koji će ga osloboditi od njegova grijeha.” ");
INSERT INTO hrv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Ako mu sredstva ne dopuštaju da pribavi glavu sitne stoke, neka Jahvi, kao naknadnicu za počinjeni grijeh, prinese dvije grlice ili dva golubića; jedno kao žrtvu okajnicu, a drugo kao žrtvu paljenicu. ");
INSERT INTO hrv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Neka ih donese svećeniku, a on neka najprije prinese ono što je određeno kao žrtva okajnica. Stisnuvši ga za vrat, neka mu slomi šiju, ali neka glave ne otkida. ");
INSERT INTO hrv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Neka krvlju žrtve poškropi žrtvenik sa strane, a ostatak krvi neka se iscijedi podno žrtvenika. To je žrtva okajnica. ");
INSERT INTO hrv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Onda neka drugo prinese kao žrtvu paljenicu prema propisu. Neka tako svećenik nad tim čovjekom izvrši obred pomirenja za grijeh koji je počinio, i bit će mu oprošteno. ");
INSERT INTO hrv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ako mu sredstva ne dopuštaju da pribavi dvije grlice ili dva golubića, neka Jahvi, u zadovoljštinu za počinjeni grijeh, prinese jednu desetinu efe njaboljeg brašna. Ulja u nj neka ne ulijeva niti na nj tamjana stavlja jer je žrtva okajnica. ");
INSERT INTO hrv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Kada to donese svećeniku, neka svećenik zagrabi punu pregršt kao spomen-žrtvu i na žrtveniku sažeže u čast Jahvi povrh paljenih žrtava. To je žrtva okajnica. ");
INSERT INTO hrv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Neka tako svećenik izvrši nad tim čovjekom obred pomirenja za grijeh koji je počinio u bilo kojem od tih slučajeva, pa će mu biti oprošteno. Ono ostalo neka pripadne svećeniku kao i od žrtve prinosnice.” ");
INSERT INTO hrv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Još reče Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ako tko počini pronevjerenje ogriješivši se nehotično o svete stvari Jahvine, neka za naknadu, kao žrtvu naknadnicu, prinese Jahvi, iz svoga stada, ovna bez mane, vrijedna - po tvojoj procjeni - najmanje dva šekela srebra - prema cijeni hramskog šekela. ");
INSERT INTO hrv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Neka nadoknadi koliko se ogriješio o svete stvari i tome doda još petinu i neka dadne svećeniku. Neka svećenik nad njim izvrši obred pomirenja ovnom žrtve naknadnice, i bit će mu oprošteno. ");
INSERT INTO hrv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ako tko i ne znajući pogriješi i učini štogod što je Jahve zabranio, kriv je, pa neka snosi posljedice svoje krivnje. ");
INSERT INTO hrv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Neka svećeniku dovede za naknadnicu iz svoga stada ovna bez mane, prema tvojoj procjeni. Neka svećenik nad tim čovjekom izvrši obred pomirenja za pogrešku što je počinio u neznanju, i bit će mu oprošteno. ");
INSERT INTO hrv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","To je žrtva naknadnica; on je doista bio odgovoran Jahvi.” ");
INSERT INTO hrv_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Jahve još reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","“Kad se tko ogriješi i počini pronevjeru prema Jahvi prevarivši svoga bližnjega u pologu ili pohrani, a tako i krađom ili iskorištavanjem svoga bližnjega; ");
INSERT INTO hrv_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","ili, nađe li što je bilo izgubljeno pa slaže i krivo se zakune u bilo kojem grijehu što ga čovjek može učiniti; ");
INSERT INTO hrv_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","ako tko tako pogriješi i kriv postane, onda ono što je krađom oduzeo ili što je iskorištavanjem namakao; ili polog što mu je bio povjeren; ili izgubljenu stvar što ju je našao; ");
INSERT INTO hrv_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ili ono za što se bio krivo zakleo - neka u cijelosti vrati i, dodavši tome petinu, neka dadne onome kome pripada istoga dana kad spozna svoju krivnju. ");
INSERT INTO hrv_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Neka potom svećeniku za naknadu, kao žrtvu naknadnicu Jahvi, dovede iz svog stada jednoga ovna bez mane, prema tvojoj procjeni, ");
INSERT INTO hrv_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","a svećenik neka nad tim čovjekom izvrši obred pomirenja pred Jahvom, i bit će mu oprošteno, ma kakvo bilo nedjelo kojega je krivac.” ");
INSERT INTO hrv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Jahve još reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Naredi Aronu i njegovim sinovima: 'Ovakav je obred za žrtvu paljenicu: žrtva paljenica neka ostane na žeravi na žrtveniku svu noć do jutra; i vatra neka neprestano gori na žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Neka svećenik stavi na se lanenu košulju, na svoje tijelo neka navuče lanene gaće; zatim neka zgrne zamašćeni pepeo u što je vatra pretvorila žrtvu paljenicu na žrtveniku i neka ga stavi pokraj žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Potom neka svuče svoje ruho i na se obuče drugo te neka odnese zamašćeni pepeo na čisto mjesto izvan tabora. ");
INSERT INTO hrv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Vatra na žrtveniku mora uvijek gorjeti; ne smije se gasiti. Neka svako jutro svećenik na nju naloži drva i onda na nju naslaže žrtvu paljenicu. Tu neka u kad sažiže loj sa žrtava pričesnica. ");
INSERT INTO hrv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Neka na žrtveniku trajno gori vatra; neka se ne gasi.'” ");
INSERT INTO hrv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","“Ovo je obred za žrtvu prinosnicu: neka je Aronovi sinovi pronose u nazočnosti Jahve pred žrtvenikom. ");
INSERT INTO hrv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Pošto jedan od njih zagrabi pregršt najboljeg brašna i ulja sa žrtve prinosnice i sav tamjan što bude na njoj, pošto to sažeže na žrtveniku kao spomen-žrtvu, ugodan miris Jahvi, ");
INSERT INTO hrv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","neka ostatak u obliku beskvasnih kruhova pojedu Aron i njegovi sinovi; neka ga jedu na posvećenu mjestu - u dvorištu Šatora sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Neka se ne peče s kvascem. To je dio žrtava meni paljenih što im ga ja dajem - dio najsvetiji, jednako kao i žrtva okajnica i kao žrtva naknadnica. ");
INSERT INTO hrv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Svaki muškarac Aronova potomstva može jesti taj dio od žrtava paljenih Jahvi, i to je vječni zakon za sve vaše naraštaje: i tko ih se god dotakne, bit će posvećen.” ");
INSERT INTO hrv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Jahve još reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","“Neka Aron i njegovi sinovi na dan svoga pomazanja prinesu Jahvi ovaj prinos: desetinu efe najboljeg brašna kao redovitu žrtvu prinosnicu, polovinu ujutro, a polovinu uvečer. ");
INSERT INTO hrv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Neka bude pripravljena u tavi na ulju. Donesi je dobro namočenu i prinesi Jahvi kao ugodan miris, kao žrtvu prinosnicu od više komada. ");
INSERT INTO hrv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Neka je tako pripravi svećenik koji od njegovih sinova bude pomazan da ga naslijedi. To je vječni zakon. Neka se ta žrtva Jahvi sva sažeže! ");
INSERT INTO hrv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Svaka svećenička žrtva prinosnica treba da bude posve spaljena; neka se od nje ne jede.” ");
INSERT INTO hrv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Još reče Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","“Kaži Aronu i njegovim sinovima: 'Ovo je obred žrtvovanja za grijeh: žrtva okajnica neka se zakolje pred Jahvom na mjestu gdje se kolje žrtva paljenica - presveta je! ");
INSERT INTO hrv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Svećenik koji prinosi tu žrtvu okajnicu neka od nje i jede; neka se ona jede na posvećenu mjestu, u dvorištu Šatora sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Tko se god dotakne njezina mesa bit će posvećen; ako krv poštrapa odijelo, poštrapani dio neka se ispere na posvećenu mjestu. ");
INSERT INTO hrv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","A posuda od ilovače u kojoj bude meso kuhano neka se razbije; a ako bude kuhano u posudi od tuča, neka se istare i vodom ispere. ");
INSERT INTO hrv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Svaki muški od svećeničke loze može od nje jesti - presveta je! ");
INSERT INTO hrv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ali nijedna žrtva okajnica od koje je krv donesena u Šator sastanka za obred pomirenja u Svetištu neka se ne jede, nego na vatri spali.'” ");
INSERT INTO hrv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Ovo je obred za žrtvu naknadnicu. ");
INSERT INTO hrv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nadasve je sveta! Neka se žrtva naknadnica zakolje na mjestu gdje se kolju žrtve paljenice, a njezinom krvlju neka svećenik zapljusne sve strane žtrvenika. ");
INSERT INTO hrv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Zatim neka prinese sav loj s nje: pretili rep, loj što omotava drobinu, ");
INSERT INTO hrv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","oba bubrega i loj što je na njima i na slabinama; pa privjesak s jetre: neka i njega izvadi s bubrezima! ");
INSERT INTO hrv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Neka ih svećenik sažeže na žrtveniku kao žrtvu u čast Jahvi paljenu. To je žrtva naknadnica. ");
INSERT INTO hrv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Svaki muški od svećeničke loze može od nje jesti. Neka je jedu na posvećenu mjestu - presveta je! ");
INSERT INTO hrv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Kakva je žrtva okajnica, takva je i žrtva naknadnica; jedno je pravilo za njih: neka pripadne svećeniku koji njome vrši obred pomirenja. ");
INSERT INTO hrv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Tako isto koža od žrtve koju tko preda svećeniku da bude prinesena za žrtvu paljenicu neka pripadne svećeniku. ");
INSERT INTO hrv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Nadalje, svaka žrtva prinosnica što bude pečena u peći, kao i svaka što bude zgotovljena u kotluši ili na tavi, neka pripadne svećeniku koji je prinosi. ");
INSERT INTO hrv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","A svaka žrtva prinosnica, zamiješena s uljem ili nasuho, neka pripadne svim Aronovim sinovima bez razlike!” ");
INSERT INTO hrv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Ovo je obred za žrtvu pričesnicu koja će se prinositi Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ako se prinosi u zahvalu, neka se zajedno sa žrtvom zahvalnicom prinesu i beskvasne pogače uljem zamiješene; beskvasne prevrte uljem namazane i kolači od najboljeg brašna, zamiješeni uljem. ");
INSERT INTO hrv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ovaj prinos, nadopunjen kolačima od ukvasanoga tijesta, neka se prinosi zajedno sa žrtvom pričesnicom u zahvalu. ");
INSERT INTO hrv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Od svake ovakve žrtve neka se prinese po jedan kolač na dar Jahvi. To neka bude za svećenika koji zapljuskuje krv od žrtve pričesnice. ");
INSERT INTO hrv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","A meso žrtve pričesnice neka se pojede istoga dana kad bude žrtvovana; neka se od nje ne ostavlja ništa za sutradan. ");
INSERT INTO hrv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","A bude li prinos žrtva zavjetnica ili žrtva dragovoljna, neka se jede na dan kad se žrtva prinosi. Što ostane od nje neka se jede sutradan. ");
INSERT INTO hrv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","A što još mesa od žrtve preteče, neka se treći dan na vatri spali.” ");
INSERT INTO hrv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","“Ako bi tko jeo meso žrtve pričesnice i treći dan, žrtva neće biti primljena niti će onome koji je prinosi biti uračunata. To je meso kvarno, i onaj koji od toga jede neka i posljedice krivnje snosi! ");
INSERT INTO hrv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Meso koje se dotakne bilo čega nečista neka se ne jede nego na vatri spali! Inače, tko je god čist može jesti meso. ");
INSERT INTO hrv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","A tko bi nečist jeo mesa od žrtve pričesnice što je bila Jahvi prinesena takav neka se iskorijeni iz svoga naroda. ");
INSERT INTO hrv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kad se tko dotakne bilo čega nečista - bila to nečist čovječja, kakva nečista životinja ili bilo kakvo nečisto stvorenje - pa pojede mesa od žrtve pričesnice koja je prinesena Jahvi takav neka se iskorijeni iz svoga naroda!” ");
INSERT INTO hrv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Reče Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Ovako kaži Izraelcima: 'Ne jedite loja ni volujskoga, ni ovčjega, ni kozjega. ");
INSERT INTO hrv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Loj sa životinje koja ugine, ili koju divlje zvijeri razderu, može se upotrijebiti za bilo što, ali ga ne smijete jesti. ");
INSERT INTO hrv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Tko god jede loj od životinje koja se može prinijeti Jahvi kao žrtva paljenica takav neka se iskorijeni iz svoga naroda. ");
INSERT INTO hrv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ne smijete uživati krvi ni od ptica ni od stoke ni u kojem svome prebivalištu. ");
INSERT INTO hrv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Tko bi god uživao bilo kakvu krv neka se iskorijeni iz svoga naroda.'” ");
INSERT INTO hrv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Jahve još reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Ovako kaži Izraelcima: 'Prinos Jahvi od žrtve pričesnice mora donijeti onaj koji Jahvi prinosi žrtvu pričesnicu. ");
INSERT INTO hrv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Svojim vlastitim rukama neka prinese Jahvi žrtvu paljenicu; neka prinese loj i grudi; grudi neka se prinesu pred Jahvom kao žrtva prikaznica. ");
INSERT INTO hrv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Neka svećenik sažeže loj na žrtveniku, a grudi neka pripadnu Aronu i njegovim sinovima. ");
INSERT INTO hrv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Desno pleće od svojih žrtava pričesnica dajte svećeniku na dar. ");
INSERT INTO hrv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Onome Aronovu sinu koji bude prinosio krv i loj sa žrtve pričesnice neka u dio pripadne desno pleće. ");
INSERT INTO hrv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Jer ja uzimam od Izraelaca grudi od žrtava pričesnica što se prinose kao žrtva prikaznica i pleće žrtve podizanice te ih predajem svećeniku Aronu i njegovim sinovima. To je trajna odredba za Izraelce. ");
INSERT INTO hrv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","To je dohodak Aronov i njegovih sinova od žrtava paljenih u čast Jahvi; dodjeljuje im se od onog dana kad se dovedu da vrše svećeničku službu u čast Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Jahve je naredio da im se od dana kad budu pomazani to daje kao pristojbina od Izraelaca. To je trajna odredba za njihove naraštaje'.” ");
INSERT INTO hrv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","To je obred za žrtvu paljenicu, prinosnicu, okajnicu, naknadnicu, žrtvu posvetnicu i žrtvu pričesnicu ");
INSERT INTO hrv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","koji je Jahve naredio Mojsiju na Sinajskom brdu kad je zapovjedio Izraelcima da Jahvi u Sinajskoj pustinji prinose žrtve. ");
INSERT INTO hrv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Uzmi Arona, a s njim i njegove sinove; ruho, ulje pomazanja, junca žrtve okajnice, dva ovna i košaru beskvasnih kruhova ");
INSERT INTO hrv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","te skupi svu zajednicu na ulazu u Šator sastanka.” ");
INSERT INTO hrv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mojsije učini kako mu je Jahve naredio, i zajednica se sabra na ulazu u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Tada Mojsije progovori zajednici: “Ovo je Jahve zpovjedio da se učini.” ");
INSERT INTO hrv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Izvede zatim Mojsije Arona i njegove sinove pa ih u vodi opra. ");
INSERT INTO hrv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Obuče na nj haljinu, opasa ga pojasom, ogrnu ga ogrtačem i stavi mu oplećak. Zatim ga opasa tkanicom oplećka i njome pritegnu uza nj oplećak. ");
INSERT INTO hrv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Stavi mu naprsnik, a u naprsnik metnu Urim i Tumim. ");
INSERT INTO hrv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Na glavu mu stavi mitru, a sprijeda na mitru postavi zlatnu pločicu - sveti vijenac - kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Uzme zatim Mojsije ulje pomazanja te pomaže Prebivalište i sve što je u njemu da ih posveti. ");
INSERT INTO hrv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Sedam puta poškropi njime žrtvenik te pomaže žrtvenik i sav njegov pribor, umivaonik s njegovim stalkom da ih posveti. ");
INSERT INTO hrv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Izlije ulja pomazanja Aronu na glavu te ga pomaže da ga posveti. ");
INSERT INTO hrv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Potom Mojsije dovede Aronove sinove; na njih obuče haljine, pasovima ih opaše i poveze im zavije, kako je Jahve Mojsiju naredio. ");
INSERT INTO hrv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Dovede potom junce žrtve okajnice. Aron i njegovi sinovi stave svoje ruke na glavu juncu žrtve okajnice. ");
INSERT INTO hrv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Zatim ga Mojsije zakolje. Onda uzme krvi pa je svojim prstom stavi na rogove oko žrtvenika. Tako žrtvenik očisti. Zatim izlije krv podno žrtvenika; posveti ga, izvršivši na njemu obred pomirenja. ");
INSERT INTO hrv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Zatim Mojsije uzme sav loj što je bio oko drobine, privjesak s jetre, oba bubrega i njihov loj, pa to sažeže u kad na žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","A kožu od junca, njegovo meso i njegovu nečist spali u vatri izvan tabora, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Dovede potom ovna za žrtvu paljenicu. Aron i njegovi sinovi stave svoje ruke ovnu na glavu. ");
INSERT INTO hrv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Sad ga Mojsije zakolje. Onda krvlju zapljusne žrtvenik sa svih strana. ");
INSERT INTO hrv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Pošto isiječe ovna na dijelove, Mojsije sažeže u kad glavu, dijelove i loj. ");
INSERT INTO hrv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","U vodi opere drobinu i noge pa u kad sažeže na žrtveniku svega ovna. Bila je to žrtva paljenica na ugodan miris - žrtva u čast Jahvi paljena - kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Zatim dovede drugoga ovna, ovna za žrtvu posvetnicu. Aron i njegovi sinovi stave svoje ruke ovnu na glavu. ");
INSERT INTO hrv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mojsije ga zakolje. Onda uzme krvi pa stavi na resu Aronova desnog uha, na palac njegove desne ruke i na palac njegove desne noge. ");
INSERT INTO hrv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Potom Mojsije dovede Aronove sinove, pa im stavi iste krvi na resu desnog uha, na palac desne ruke i na palac desne noge. Zatim Mojsije krvlju zapljusne žrtvenik sa svih strana. ");
INSERT INTO hrv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Poslije toga uzme loj, pretili rep, loj što je bio oko drobine, privjesak s jetre, oba bubrega i njihov loj - i desno pleće; ");
INSERT INTO hrv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","a iz košare beskvasnih kruhova, što je stajala pred Jahvom, uzme jednu beskvasnu pogaču, jednu prevrtu s uljem i jedan kolač i postavi ih na loj i desno pleće. ");
INSERT INTO hrv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Sve to položi na ruke Arona i na ruke njegovih sinova pa to prinese kao žrtvu prikaznicu pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Potom Mojsije opet to uzme s njihovih ruku i sažeže u kad na žrtveniku povrh žrtve paljenice. Bila je to žrtva posvetnica na ugodan miris, žrtva u čast Jahvi paljena. ");
INSERT INTO hrv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Naposljetku Mojsije uzme grudi i prinese ih kao žrtvu prikaznicu pred Jahvom. To je bila pristojbina Mojsiju od ovna žrtve posvetnice, kako je Jahve Mojsiju naredio. ");
INSERT INTO hrv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Zatim Mojsije uze ulja za pomazanje i krvi što je bila na žrtveniku te poškropi Arona i njegove haljine, a tako i njegove sinove i njihove haljine. Tako posveti Arona i njegove haljine; njegove sinove i njihove haljine. ");
INSERT INTO hrv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Onda reče Mojsije Aronu i njegovim sinovima: “Skuhajte to meso na ulazu u Šator sastanka i ondje ga blagujte s kruhom što je u košari za žrtvu posvetnicu, kako sam naredio. Neka ga jedu Aron i njegovi sinovi! ");
INSERT INTO hrv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","A što od mesa i kruha ostane, spalite na vatri. ");
INSERT INTO hrv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Sedam dana ne odlazite s ulaza Šatora sastanka - do dana kad se navrši rok vašega svećeničkog posvećenja. Jer sedam dana treba za vaše posvećenje. ");
INSERT INTO hrv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Kako se radilo danas, Jahve je naredio da se tako radi dalje, da se nad vama izvrši obred pomirenja. ");
INSERT INTO hrv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Zato ostanite na ulazu Šatora sastanka sedam dana, danju i noću vršeći što je Jahve naredio, da ne pomrete. Takvu sam ja zapovijed dobio.” ");
INSERT INTO hrv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aron i njegovi sinovi učiniše sve što je Jahve naredio preko Mojsija. ");
INSERT INTO hrv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Osmoga dana Mojsije pozva Arona, njegove sinove i starješine Izraelove ");
INSERT INTO hrv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","i reče Aronu: “Uzmi jedno tele za žrtvu okajnicu, jednoga ovna za žrtvu paljenicu, oboje bez mane, i dovedi ih pred Jahvu. ");
INSERT INTO hrv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","A Izraelcima reci ovako: 'Uzmite jednoga jarca za žrtvu okajnicu, tele i janje od godine, oboje bez mane, za žrtvu paljenicu; ");
INSERT INTO hrv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","a junca i ovna za žrtvu pričesnicu da žrtvujete pred Jahvom; napokon prinosnicu, s uljem zamiješenu; jer će vam se danas Jahve ukazati.'” ");
INSERT INTO hrv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Dovedu oni pred Šator sastanka što je Mojsije naredio; naprijed stupi sva zajednica i stane pred Jahvu. ");
INSERT INTO hrv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","“Ovo je zapovijed”, reče Mojsije, “koju je Jahve izdao. Izvršite je, da vam se pokaže slava Jahvina.” ");
INSERT INTO hrv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Zatim Mojsije reče Aronu: “Stupi k žrtveniku, prinesi svoju žrtvu okajnicu i svoju žrtvu paljenicu i tako izvrši obred pomirenja za se i svoj dom; onda prinesi dar naroda i za nj izvrši obred pomirenja, kako je Jahve naredio.” ");
INSERT INTO hrv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aron se primače žrtveniku i zakla tele žrtve za svoj vlastiti grijeh. ");
INSERT INTO hrv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Zatim mu Aronovi sinovi donesu krvi. On u nju zamoči svoj prst i stavi je na rogove žrtvenika. Potom ostalu krv izli podno žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A loj, bubrege i privjesak s jetre žrtve okajnice sažeže u kad na žrtveniku, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Meso i kožu spali na vatri izvan tabora. ");
INSERT INTO hrv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Zakolje poslije toga žrtvu paljenicu, od koje mu sinovi Aronovi pruže krv. On njome zapljusne žrtvenik sa svih strana. ");
INSERT INTO hrv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Dodaju mu i žrtvu paljenicu, dio po dio, a tako i glavu, i on je sažeže u kad na žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Drobinu i noge opere pa i njih na žrtveniku sažeže u kad povrh žrtve paljenice. ");
INSERT INTO hrv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Zatim prinese dar naroda. Uze jarca žrtve okajnice za grijehe naroda, zakla ga i prinese kao žrtvu okajnicu, isto onako kao i prijašnju. ");
INSERT INTO hrv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Donese potom žrtvu paljenicu i prinese je prema propisu. ");
INSERT INTO hrv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Donijevši poslije toga žrtvu prinosnicu, od nje zagrabi pregršt i sažeže na žrtveniku u kad povrh jutarnje žrtve paljenice. ");
INSERT INTO hrv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Napokon zakolje junca i ovna kao žrtvu pričesnicu za narod. Aronovi mu sinovi pruže krv, a on zapljusne žrtvenik sa svih strana; ");
INSERT INTO hrv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","dodaju mu i loj s junca i ovna, pretili rep, loj oko drobine, bubrege i privjesak s jetre. ");
INSERT INTO hrv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Metnuvši te masne dijelove na grudi, sažga ih u kad na žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","A grudi i desno pleće Aron prinese kao žrtvu prikaznicu pred Jahvom, kako je Mojsije naredio. ");
INSERT INTO hrv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Tada Aron podiže ruke spram naroda i blagoslovi ga. Pošto prinese žrtvu okajnicu, paljenicu i pričesnicu, siđe. ");
INSERT INTO hrv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Poslije toga Mojsije i Aron uđoše u Šator sastanka. Kad iziđoše, blagosloviše narod. Slava Jahvina pokaza se svemu narodu. ");
INSERT INTO hrv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ispred Jahve izbi oganj i sažga žrtvu paljenicu i masne komade na žrtveniku. A sav narod, vidjevši to, viknu od veselja i pade ničice. ");
INSERT INTO hrv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","A sinovi Aronovi Nadab i Abihu uzmu svaki svoj kadionik; stave u nj vatre i na nju metnu tamjana da prinesu pred Jahvom neposvećenu vatru, koju im on ne bijaše propisao. ");
INSERT INTO hrv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Ali izbije plamen ispred Jahve te ih proguta - poginuše oni pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Nato će Mojsije Aronu: “To je ono što je Jahve navijestio: Po onima koji su mi blizu svetim ću se pokazati; pred svim ću se pukom proslaviti.” Aron je šutio. ");
INSERT INTO hrv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mojsije zovnu Mišaela i Elsafana, sinove Aronova strica Uziela, pa im reče: “Dođite i odnesite svoju braću ispred Svetišta u polje izvan tabora!” ");
INSERT INTO hrv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Oni dođu i odnesu ih u njihovim košuljama u polje izvan tabora, kako je Mojsije rekao. ");
INSERT INTO hrv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Poslije toga Mojsije reče Aronu i njegovim sinovima, Eleazaru i Itamaru: “Ne raščupavajte svoje kose niti razdirite svojih haljina da ne poginete i da se On ne razljuti na svekoliku zajednicu. Vaša braća i sav dom Izraelov neka oplakuje one koje je vatra Jahvina sažegla. ");
INSERT INTO hrv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ne smijete odlaziti s ulaza u Šator sastanka da ne pomrete, jer na vama je Jahvino ulje pomazanja.” Oni učine po riječi Mojsijevoj. ");
INSERT INTO hrv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Jahve reče Aronu: ");
INSERT INTO hrv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Kad ulazite u Šator sastanka, nemojte piti vina niti opojnoga pića, ni ti ni tvoji sinovi s tobom! Tako nećete poginuti. To je trajan zakon za vaše naraštaje; ");
INSERT INTO hrv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","da možete lučiti posvećeno od običnoga, čisto od nečistoga; ");
INSERT INTO hrv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","da možete učiti Izraelce svim zakonima što ih je Jahve predao preko Mojsija.” ");
INSERT INTO hrv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Onda Mojsije rekne Aronu i njegovim preživjelim sinovima, Eleazaru i Itamaru: “Uzimajte od žrtve prinosnice što preostaje nakon prinesene žrtve u čast Jahvi paljene i beskvasnu je uza žrtvenik jedite jer je vrlo sveta. ");
INSERT INTO hrv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Blagujte je u svetom mjestu, jer to je - tako je meni naređeno - pristojbina tvoja i pristojbina tvojih sinova od žrtava paljenih u čast Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","A grudi žrtve prikaznice i pleće žrtve podizanice ti i tvoji sinovi i tvoje kćeri s tobom jedite na bilo kojem čistom mjestu. Jer to je dodijeljeno za pristojbinu tebi i tvojim sinovima od izraelskih žrtava pričesnica. ");
INSERT INTO hrv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Pleće žrtve podizanice i grudi žrtve prikaznice što se donose zajedno s lojem, na vatri paljenim - pošto budu prineseni za žrtvu prikaznicu pred Jahvom - neka pripadnu tebi i tvojim sinovima s tobom. To je, kako je Jahve naredio, trajan zakon.” ");
INSERT INTO hrv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Potom se Mojsije potanje raspita o jarcu žrtve okajnice. Već je bio spaljen. On se razljuti na Eleazara i Itamara, Aronove preživjele sinove, pa rekne: ");
INSERT INTO hrv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Zašto ste jeli žrtvu okajnicu na svetome mjestu? Vrlo ja sveta! To vam je dao Jahve da uklanjate krivnju sa zajednice vršeći nad njom obred pomirenja pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Budući da krv žrtve nije bila unesena unutar Svetišta, morali ste je blagovati u Svetištu, kako mi je bilo zapovjeđeno.” ");
INSERT INTO hrv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Nato će Aron Mojsiju: “Danas su, eto, prinijeli svoju žrtvu okajnicu i svoju žrtvu paljenicu pred Jahvom! Što bi se meni dogodilo da sam ja danas jeo od žrtve okajnice? Bi li to bilo milo Jahvi?” ");
INSERT INTO hrv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Kad Mojsije to ču, odobri. ");
INSERT INTO hrv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Jahve reče Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Ovako kažite Izraelcima: 'Ovo su životinje koje između svih četveronožaca na zemlji možete jesti: ");
INSERT INTO hrv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","svaku koja ima papke, ali papke razdvojene, i koja preživa možete jesti. ");
INSERT INTO hrv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ali ove, iako preživaju ili papke imaju, ne smijete jesti: devu, jer iako preživa, razdvojena papka nema - za vas je nečista; ");
INSERT INTO hrv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","svisca, jer iako preživa, razdvojena papka nema - za vas je nečist; ");
INSERT INTO hrv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","arnebeta, iako preživa, razdvojena papka nema - za vas je nečist. ");
INSERT INTO hrv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","A svinja, iako ima papak, i to papak razdvojen, ne preživa - za vas je nečista. ");
INSERT INTO hrv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Njihova mesa nemojte jesti niti se njihove strvine doticati - za vas su one nečiste.'” ");
INSERT INTO hrv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Od svih vodenih životinja ove možete jesti: sve što živi u vodi, bilo u morima, bilo u rijekama, a ima peraje i ljuske možete jesti. ");
INSERT INTO hrv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","A što u morima i rijekama nema peraja i ljusaka - sve životinjice u vodi, sva živa vodena bića - neka su vam odvratna ");
INSERT INTO hrv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","i odvratna neka vam ostanu! Mesa od njih nemojte jesti, a njihove strvine držite za odvratnost. ");
INSERT INTO hrv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Sve, dakle, što je u vodi a nema peraja i ljusaka neka je za vas odvratno.” ");
INSERT INTO hrv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Od ptica neka su vam ove odvratne i neka se ne jedu - odvratnost su: orao, orao strvinar i jastreb, ");
INSERT INTO hrv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","tetrijeb i sokol bilo koje vrste; ");
INSERT INTO hrv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","gavran svih vrsta; ");
INSERT INTO hrv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","noj, kobac i galeb; lastavica svake vrste; ");
INSERT INTO hrv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","sova, gnjurac, ušara, ");
INSERT INTO hrv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","labud, pelikan, droplja; ");
INSERT INTO hrv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","roda, čaplja svake vrste; pupavac i šišmiš.” ");
INSERT INTO hrv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Svi krilati kukci što hodaju četveronoške neka su vam odvratni! ");
INSERT INTO hrv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Od svih tih krilatih kukaca što hodaju četveronoške možete jesti samo one koji imaju na svojim nožicama listove za skakutanje po zemlji. ");
INSERT INTO hrv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Od njih možete jesti: svaku vrstu skakavaca, cvrčaka i zrikavaca. ");
INSERT INTO hrv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","A svi drugi krilati kukci na četiri nožice neka su vam odvratni! ");
INSERT INTO hrv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","I od njih ćete se onečistiti: tko se god dotakne njihove crkotine, neka je nečist do večeri; ");
INSERT INTO hrv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","tko god ponese crkotinu bilo koje od njih, neka opere svoju odjeću i nečistim se smatra do večeri; ");
INSERT INTO hrv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","i životinje s nerazdvojenim papkom što ne preživaju za vas su nečiste, i tko ih se dotakne neka je nečist! ");
INSERT INTO hrv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Onda, četveronožne životinje koje hodaju na četiri šape za vas su nečiste. Tko se dotakne njihova strva, neka je nečist do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","A onaj koji ponese njihov strv, neka opere svoju odjeću i bude nečist do večeri. Za vas su one nečiste.” ");
INSERT INTO hrv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Od životinja što po zemlji gmižu neka su za vas ove nečiste: krtica, miš i svaka vrsta guštera; ");
INSERT INTO hrv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","zidni macaklin, kameleon, daždevnjak, zelembać i tinšamet. ");
INSERT INTO hrv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Te su životinje od svih što gmižu za vas nečiste. Tko ih se mrtvih dotakne neka je nečist do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","A na što koja od njih mrtva padne, neka je onečišćeno: bio to kakav drveni predmet ili odjeća, koža ili vreća. Svaki takav predmet koji se upotrebljava neka se zamoči u vodu i ostane nečist do večeri. Onda će postati čist. ");
INSERT INTO hrv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Upadne li što od njih u kakvu zemljanu posudu, razbijte je; sve je u njoj onečišćeno. ");
INSERT INTO hrv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","A bilo kakva hrana što se jede, ako na nju kapne voda iz te posude, bit će onečišćena. Svaka tekućina što se pije u svakoj takvoj posudi neka se smatra nečistom. ");
INSERT INTO hrv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","A sve na što padne bilo što od njihove crkotine neka je nečisto; bude li to peć ili ognjište, neka se sruše: onečišćeni su za vas i neka nečisti budu. ");
INSERT INTO hrv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","A vrelo ili čatrnja koja drži vodu neka se smatraju čistima. Ali tko dirne strvinu životinje neka je nečist. ");
INSERT INTO hrv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ako što od njihova strva padne na žitno sjemenje što će se sijati, ono ostaje čisto; ");
INSERT INTO hrv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ali ako se sjemenje nakvasi vodom, a onda na nj padne što od njihove crkotine, neka je za vas nečisto. ");
INSERT INTO hrv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ako ugine koja životinja što vam služi za hranu, onaj koji dotakne njezinu strvinu neka je nečist do večeri; ");
INSERT INTO hrv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","a koji pojede od njezine strvine neka opere svoju odjeću i bude nečist do večeri; koji ponese njezinu strvinu neka opere svoju odjeću i bude nečist do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Svaka životinja što po tlu gmiže odvratna je. Neka se ne jede! ");
INSERT INTO hrv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ništa što puže na trbuhu, ništa što god ide na četiri noge ili na više nogu - nikakve puzavce što po tlu gmižu nemojte jesti jer su odvratni! ");
INSERT INTO hrv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Nemojte sami sebe poganiti svim tim puzavcima što gmižu; ne prljajte se njima, da i vi zbog njih ne postanete nečisti. ");
INSERT INTO hrv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ta ja - Jahve - Bog sam vaš! Posvećujte se, dakle, da sveti budete, jer svet sam ja! Nijednim se puzavcem što po tlu gmiže ne prljajte! ");
INSERT INTO hrv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Jest, ja sam Jahve; izveo sam vas iz zemlje egipatske da vam budem Bog. Budite, dakle, sveti jer sam svet ja!” ");
INSERT INTO hrv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","To je odredba koja se odnosi na ptice i sva živa bića što se u vodi kreću i na sve stvorove koji po zemlji gmižu. ");
INSERT INTO hrv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Svrha joj je da se razlikuje nečisto od čistoga; životinja koja se može jesti od životinje koja se ne smije jesti. ");
INSERT INTO hrv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Kaži Izraelcima: 'Kad koja žena zatrudni i rodi muško čedo, neka je nečista sedam dana, kako je nečista u vrijeme svoga mjesečnog pranja. ");
INSERT INTO hrv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Osmoga dana neka se dijete obreže. ");
INSERT INTO hrv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","A ona neka ostane još trideset i tri dana da se očisti od svoje krvi; ne smije dirati ništa posvećeno niti dolaziti u Svetište dok se ne navrši vrijeme njezina čišćenja. ");
INSERT INTO hrv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ako rodi žensko čedo, neka je nečista dva tjedna, kao za svoga mjesečnog pranja, i neka ostane još šezdeset i šest dana da se očisti od svoje krvi. ");
INSERT INTO hrv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","A kad se navrši vrijeme njezina čišćenja - bilo za sinčića, bilo za kćerkicu - neka donese svećeniku na ulaz u Šator sastanka jednogodišnje janje za žrtvu paljenicu i jednoga golubića ili grlicu za žrtvu okajnicu. ");
INSERT INTO hrv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Neka on to prinese pred Jahvom i nad njom izvrši obred pomirenja. Tako će ona biti očišćena od svoga krvarenja. To je odredba koja se odnosi na ženu kad rodi bilo muško bilo žensko čedo. ");
INSERT INTO hrv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ali ako ne može da nađe dovoljno sredstava za grlo od sitnoga stada, neka onda uzme dvije grlice ili dva golubića - jedno za žrtvu paljenicu, a drugo za žrtvu okajnicu. Neka svećenik izvrši nad njom obred pomirenja, i ona će biti očišćena'.” ");
INSERT INTO hrv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Reče Jahve Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Ako se kome na koži pojavi oteklina ili lišaj ili bjelkasta pjega što bi bila nagovještaj gube na koži njegova tijela, neka se takav dovede svećeniku Aronu ili kojemu od njegovih sinova svećenika. ");
INSERT INTO hrv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Neka svećenik pregleda zaraženo mjesto na koži njegova tijela. Ako je dlaka na zaraženom mjestu postala bijela i učini se da je ono dublje od kože njegova tijela, onda je to guba. Pošto ga svećenik pregleda, neka ga proglasi nečistim. ");
INSERT INTO hrv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ali ako se pokaže da bjelkasta pjega na koži njegova tijela nije dublja nego i koža, a dlaka na njoj nije pobijeljela, neka onda svećenik bolesnika osami sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Neka ga sedmoga dana opet svećenik pregleda. Ako ustanovi svojim očima da zaraza još postoji, ali da se po koži dalje ne širi, neka ga osami još sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sedmoga dana neka ga opet pregleda. Bude li zaraženo mjesto manje upadno, a bolest se kožom ne bude proširila, neka ga proglasi čistim: to je samo lišaj. Pošto opere svoje haljine, bit će čist. ");
INSERT INTO hrv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ali ako se lišaj kožom proširi, pošto je svećenik bolesnika pregledao i proglasio ga čistim, neka se ponovo pokaže svećeniku. ");
INSERT INTO hrv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Neka ga svećenik pregleda. Bude li se lišaj proširio po koži, neka ga svećenik proglasi nečistim: to je guba. ");
INSERT INTO hrv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ako se na čovjeku pokaže guba, neka ga dovedu svećeniku. ");
INSERT INTO hrv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Neka ga svećenik pregleda. Ako po koži bude bjelkasta oteklina s pobijeljelom dlakom i napetim čirom, ");
INSERT INTO hrv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","to je duboko ukorijenjena guba po koži njegova tijela. Neka ga svećenik proglasi nečistim. Ne treba ga osamljivati, jer je sigurno nečist. ");
INSERT INTO hrv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ako guba izbije po koži tako da bolesniku prekrije svu kožu od glave do pete - sve što svećenikove oči vide - ");
INSERT INTO hrv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","neka svećenik obavi pregled. Bude li guba prekrila sve njegovo tijelo, neka ga proglasi čistim. Budući da je sav pobijelio, čist je. ");
INSERT INTO hrv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ali onog dana kad se na njemu pokaže čir, bit će nečist. ");
INSERT INTO hrv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kad svećenik vidi taj čir, neka bolesnika proglasi nečistim: čir je nečista stvar, to je guba. ");
INSERT INTO hrv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ali ako se čir promijeni u bijelo, neka čovjek dođe k svećeniku. ");
INSERT INTO hrv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Svećenik neka ga pregleda. Bude li rana postala bijela, neka svećenik proglasi bolesnika čistim - čist i jest.” ");
INSERT INTO hrv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Kad se kome na koži napne čir i zacijeli, ");
INSERT INTO hrv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","i ondje gdje je bio čir pojavi se bjelkasta oteklina ili mjesto izblijedi i postane bjelkasto, ili izbije bijelocrvenkasta pjega, neka se taj čovjek pokaže svećeniku. ");
INSERT INTO hrv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Neka ga svećenik pregleda. Pronađe li da je tu koža udubljenija a dlaka pobijeljela, neka ga svećenik proglasi nečistim - to je onda guba što je izbila u čiru. ");
INSERT INTO hrv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ali ako svećenik ustanovi da tu dlaka nije pobijeljela, da koža nije udubljenija nego drugdje, da mjesto tamni, neka bolesnika osami sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Proširi li mu se bolest po koži, neka ga svećenik proglasi nečistim - to je guba. ");
INSERT INTO hrv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ako pjega ostane na mjestu i ne proširi se, to je ožiljak od čira. Neka toga čovjeka svećenik proglasi čistim.” ");
INSERT INTO hrv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Kome na koži bude opeklina, pa mjesto opekline postane pjega bijelocrvenkasta ili bjelkasta, ");
INSERT INTO hrv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","neka to svećenik pregleda. Ako dlaka na mjestu bude pobijeljela i učini se da je to mjesto udubljenije od kože, onda je to guba što je u opeklini izbila. Neka ga svećenik proglasi nečistim; to je guba. ");
INSERT INTO hrv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ali ako svećenik ustanovi da dlaka nije pobijeljela, da mjesto nije udubljenije od kože i da tamni, neka ga osami sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sedmoga dana neka ga pregleda. Ako se pjega po koži proširi, neka ga svećenik proglasi nečistim: to je guba. ");
INSERT INTO hrv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ostane li ozljeda na mjestu i proširi se po koži, to je onda oteklina od opekline. Neka čovjeka svećenik proglasi čistim: to je ožiljak od opekline.” ");
INSERT INTO hrv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Ako se na glavi ili na bradi kojega čovjeka ili žene pokaže bolest, ");
INSERT INTO hrv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","neka svećenik bolest pregleda. Ustanovi li se da je dublje od kože i da je tu dlaka požutjela i otančala, neka bolesnika svećenik proglasi nečistim. To je šuga, to jest guba na glavi ili na bradi. ");
INSERT INTO hrv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ali ako svećenik, pregledavši oboljelo mjesto, ustanovi da nije dublje od kože, ali da tu ipak nema crne dlake, neka svećenik odstrani šugavca sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sedmoga dana neka ga svećenik pregleda. Ako se šuga nije proširila niti dlaka požutjela, te ako se čini da šuga nije dublja od kože, ");
INSERT INTO hrv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","neka se bolesnik obrije - ali ošugano mjesto da ne brije! - i neka ga svećenik odstrani od drugih sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sedmoga dana neka opet svećenik pregleda šugavo mjesto. Ako se šuga kožom ne bude proširila i učini se da nije dublja od kože, neka tog bolesnika svećenik proglasi čistim. On neka opere svoju odjeću i bude čist. ");
INSERT INTO hrv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Proširi li se šuga po koži pošto je bio čistim proglašen, ");
INSERT INTO hrv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","neka ga svećenik ponovo pregleda. Ako se šuga kožom bude proširila - svećenik neka više i ne traži žute dlake - bolesnik ja nečist. ");
INSERT INTO hrv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ali ako opazi da je šuga stala i da je nikla crna dlaka, šuga je zacijeljela - on je čist. Neka ga svećenik proglasi čistim.” ");
INSERT INTO hrv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Ako se na koži kojeg čovjeka ili žene pokažu pjege te ako su te pjege bijele, ");
INSERT INTO hrv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","neka ih svećenik pregleda. Ako te pjege po koži budu tamnobijele, onda je to osip što je izbio po koži: bolesnik je čist.” ");
INSERT INTO hrv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Ako čovjeku opadne kosa s glave, oćelavio mu je zatiljak, ali je čist. ");
INSERT INTO hrv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ako mu sprijeda opadne kosa s glave, oćelavio je na čelu, ali je čist. ");
INSERT INTO hrv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ali ako se po ćelavu zatiljku ili po oćelavljelu čelu pojavi crvenkastobijela bolest, to je guba što je izbila po njegovu ćelavom zatiljku ili oćelavljelu čelu. ");
INSERT INTO hrv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Neka ga svećenik pregleda. Ako ustanovi da je osip na ćelavu zatiljku ili po oćelavljelu čelu bjelkastocrvenkast - naizgled kao i guba na koži tijela - ");
INSERT INTO hrv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","čovjek se ogubavio, nečist je. Svećenik ga mora proglasiti nečistim - guba mu je na glavi.” ");
INSERT INTO hrv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Onaj koji se bude ogubavio, neka nosi rasparanu odjeću; kosa neka mu je raščupana; gornju usnu neka prekrije i viče: “Nečist! Nečist!” ");
INSERT INTO hrv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Sve dok na njemu bude bolest, neka nečistim ostane, a kako je nečist, neka stanuje nasamo: neka mu je stan izvan tabora.” ");
INSERT INTO hrv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Kad se zaraza gube pokaže na odijelu, bilo vunenu bilo lanenu, ");
INSERT INTO hrv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","na osnovi ili na potki od lana ili vune; ili na koži; ili na bilo kakvu predmetu od kože; ");
INSERT INTO hrv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","pa ako mrlja na odijelu ili koži, na osnovi ili na potki, ili na bilo kakvu predmetu od kože, bude zelenkasta ili crvenkasta, to je guba i neka se svećeniku pokaže. ");
INSERT INTO hrv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Neka svećenik, pošto pregleda što je zaraženo, to stavi na osamu sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Onda neka sedmoga dana zarazu pregleda. Ako se zaraza proširi po odijelu, po osnovi ili potki, ili po koži, ili po kakvu god predmetu od kože, to je zarazna guba. Stvar je nečista. ");
INSERT INTO hrv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","To odijelo - bilo osnova bilo potka, od vune ili lana - ili kakav kožni predmet za koji je zaraza prionula, gubom se zarazio; neka na vatri izgori. ");
INSERT INTO hrv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ali ako svećenik opazi da se zaraza nije proširila na odijelu - na osnovi ni na potki - niti na bilo kakvu kožnom predmetu, ");
INSERT INTO hrv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","onda neka naredi da se zaražena stvar opere. Neka je zatim stavi nasamo drugih sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","A ako, pošto je stvar bila oprana, svećenik opazi da se zaraženo mjesto nije promijenilo, ipak, mada se bolest nije raširila, stvar je nečista. Neka se na vatri spali: trula je i iznutra i izvana. ");
INSERT INTO hrv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Opazi li svećenik da se bolest smanjuje nakon pranja, neka to mjesto izreže, bilo ono na odijelu ili na koži, na osnovi ili na potki. ");
INSERT INTO hrv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ako se na odijelu opet pojavi, u osnovi ili potki, ili bilo kakvu kožnom predmetu, onda je to zaraza, i zaraženi predmet neka u vatri izgori. ");
INSERT INTO hrv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ako li bolest nestane s odijela - osnove ili potke - ili bilo kakva kožnoga predmeta pošto je bio opran, neka se opere opet, pa neka je čist.” ");
INSERT INTO hrv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","To su propisi za bolest gube na odijelu od vune ili lana - u osnovi ili potki - ili bilo kakvu predmetu od kože da se proglase čistim ili nečistim. ");
INSERT INTO hrv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Neka ovo bude obred za gubavca na dan njegova čišćenja: neka se dovede svećeniku; ");
INSERT INTO hrv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","neka svećenik iziđe iz tabora i obavi pregled. Ako ustanovi da je gubavac od gube ozdravio, ");
INSERT INTO hrv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","neka naredi da se za čovjeka koji se ima čistiti uzmu dvije ptice, čiste i žive, cedrovine, grimiznog prediva i izopa. ");
INSERT INTO hrv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Neka zatim svećenik naredi da se jedna ptica zakolje nad živom vodom u zemljanoj posudi. ");
INSERT INTO hrv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Potom neka uzme živu pticu, a onda zajedno živu pticu, cedrovinu, grimizno predivo i izop zamoči u krv ptice što je bila zaklana povrh žive vode. ");
INSERT INTO hrv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Sada neka sedam puta poškropi onoga koji se od gube čisti, a onda ga čistim proglasi. Poslije toga neka pusti živu pticu na otvorenu polju. ");
INSERT INTO hrv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Onaj koji se čisti neka opere svoju odjeću, obrije sve svoje dlake i u vodi se okupa. Tako neka je čist. Poslije toga neka uđe u tabor, ali sedam dana neka stanuje izvan svoga šatora. ");
INSERT INTO hrv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sedmi dan neka obrije sve svoje dlake: kosu, bradu i obrve; neka obrije sve ostale svoje dlake. Pošto u vodi opere svoju odjeću i okupa se, neka je čist. ");
INSERT INTO hrv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Osmoga dana neka uzme muško janje bez mane, jedno žensko janje od godine dana, također bez mane, tri desetine efe najboljeg brašna zamiješena u ulju za žrtvu prinosnicu i jedan log ulja. ");
INSERT INTO hrv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Svećenik koji vrši čišćenje neka ih stavi pred Jahvu na ulazu u Šator sastanka s čovjekom koji se ima čistiti. ");
INSERT INTO hrv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Neka zatim svećenik uzme jedno muško janje pa ga s ono ulja u logu prinese kao žrtvu naknadnicu. Neka ih prinese pred Jahvom kao žrtvu prikaznicu. ");
INSERT INTO hrv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Neka janje zakolje ondje gdje se kolju žrtve okajnice i žrtve paljenice - na svetome mjestu, jer žrtva naknadnica kao i okajnica pripada svećeniku: vrlo je sveta! ");
INSERT INTO hrv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Potom neka svećenik uzme krvi od žrtve naknadnice, pa neka njome namaže resicu desnoga uha, palac desne ruke i palac desne noge onoga koji se čisti. ");
INSERT INTO hrv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Poslije toga neka uzme log s uljem i izlije na dlan svoje lijeve ruke. ");
INSERT INTO hrv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Zamočivši svećenik svoj desni prst u ulje na svojoj lijevoj ruci, neka uljem sa svoga prsta obavi škropljenje pred Jahvom sedam puta. ");
INSERT INTO hrv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Od ulja što mu preostane u ruci neka svećenik, po krvi od žrtve naknadnice, pomaže resicu desnoga uha, palac desne ruke i palac desne noge onoga koji se čisti. ");
INSERT INTO hrv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ostatak ulja sa svoje ruke neka svećenik metne na glavu onoga koji se čisti. Tako će svećenik nad njim izvršiti obred pomirenja pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Neka svećenik poslije toga prinese žrtvu okajnicu i nad onim koji se čisti neka obavi obred pomirenja za njegovu nečistoću. Napokon neka zakolje žrtvu paljenicu, ");
INSERT INTO hrv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","a onda neka svećenik žrtvu paljenicu i žrtvu prinosnicu podigne na žrtvenik. Kad tako svećenik nad njim obavi obred pomirenja, neka je čist. ");
INSERT INTO hrv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ako bude siromašan te ne mogne to priskrbiti, neka uzme samo jedno muško janje za žrtvu naknadnicu i neka se ono prinese kao žrtva prinosnica da se nad tim čovjekom izvrši obred pomirenja. I neka uzme samo desetinu efe najboljeg brašna zamiješena u ulju za žrtvu prinosnicu, jedan log ulja, ");
INSERT INTO hrv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","k tome dvije grlice ili dva golubića - prema svojim mogućnostima - jedno za žrtvu okajnicu, a drugo za žrtvu paljenicu. ");
INSERT INTO hrv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Osam dana nakon svoga očišćenja neka ih donese svećeniku na ulaz u Šator sastanka pred Jahvu. ");
INSERT INTO hrv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Neka svećenik uzme janje za žrtvu naknadnicu i log s uljem pa ih prinese pred Jahvom kao žrtvu prikaznicu. ");
INSERT INTO hrv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Neka se onda zakolje janje žrtve naknadnice, a svećenik neka uzme njegove krvi i neka njome namaže resicu desnoga uha, palac desne ruke i palac desne noge onoga koji se čisti. ");
INSERT INTO hrv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Poslije toga neka svećenik izlije ulje na dlan svoje lijeve ruke. ");
INSERT INTO hrv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","A onda neka od ulja što mu je na dlanu lijeve ruke obavi škropljenje sedam puta prstom svoje desne ruke pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Od ulja iz svoje ruke neka svećenik, po krvi žrtve naknadnice, namaže resicu desnog uha, palac desne ruke i palac desne noge onoga koji se čisti. ");
INSERT INTO hrv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ostatak ulja što bude na dlanu neka svećenik stavi na glavu onoga koji se čisti, vršeći nad njim obred pomirenja pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Neka zatim prinese jednu od dviju grlica ili jednoga od dvaju golubića - što je već mogao pribaviti - ");
INSERT INTO hrv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","kao žrtvu okajnicu, a drugu kao žrtvu paljenicu zajedno sa žrtvom prinosnicom. Neka tako svećenik izvrši obred pomirenja pred Jahvom nad onim koji se čisti.” ");
INSERT INTO hrv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","To je propis za onoga koji je gubom zaražen a ne može priskrbiti sve za svoje očišćenje. ");
INSERT INTO hrv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Jahve reče Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Kad uđete u kanaansku zemlju koju ću vam dati u posjed, a ja pustim gubu na koju kuću u zemlji što je budete zaposjeli, ");
INSERT INTO hrv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","onda onaj čija je kuća neka dođe svećeniku i kaže: 'Čini mi se da je moja kuća zaražena gubom.' ");
INSERT INTO hrv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Neka svećenik naredi da se kuća isprazni prije nego on dođe da bolest pregleda, da ne bi sve što je u kući bilo proglašeno nečistim; poslije toga neka svećenik uđe da kuću pregleda. ");
INSERT INTO hrv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ako nakon pregleda zapazi da je bolest na kućnim zidovima od zelenkastih ili crvenkastih udubina i pričini mu se da idu dublje od površine zida, ");
INSERT INTO hrv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","neka svećenik iziđe iz kuće na kućna vrata i neka kuću zatvori sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sedmi dan neka svećenik opet dođe i pregleda: ako se bolest bude proširila po zidovima kuće, ");
INSERT INTO hrv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","neka svećenik naredi da se povadi zaraženo kamenje i baci na koje nečisto mjesto izvan grada. ");
INSERT INTO hrv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Zatim neka zapovjedi da se svi unutarnji zidovi kuće ostružu i da se sastrugani prah baci na koje nečisto mjesto izvan grada. ");
INSERT INTO hrv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Onda neka se uzme drugo kamenje i umetne namjesto onoga kamenja. Potom neka se uzme druga žbuka i kuća ponovo ožbuka. ");
INSERT INTO hrv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ako se pošast na kući opet pojavi pošto je kamenje bilo povađeno i kuća ostrugana i opet ožbukana, ");
INSERT INTO hrv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","neka svećenik ode da pregleda: bude li se bolest po kući proširila, to je onda u kući zarazna guba; kuća je nečista. ");
INSERT INTO hrv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Neka se kuća poruši, a njezino kamenje, njezina drvena građa i sva žbuka s kuće neka se odnese izvan grada na koje nečisto mjesto. ");
INSERT INTO hrv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Tko uđe u kuću dok je zatvorena, neka je nečist do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Tko u kući legne, mora oprati svoju odjeću. I tko u kući objeduje, mora svoju odjeću oprati. ");
INSERT INTO hrv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ako li svećenik dođe i vidi da se bolest po kući nije proširila pošto je kuća opet bila ožbukana, neka svećenik kuću proglasi čistom, jer se bolest izliječila. ");
INSERT INTO hrv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","A za očišćenje kuće neka uzme: dvije ptice, cedrovine, grimizna prediva i izopa. ");
INSERT INTO hrv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Jednu od ptica neka zakolje nad živom vodom u zemljanoj posudi. ");
INSERT INTO hrv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Potom neka uzme: cedrovinu, izop, grimizno predivo i pticu živu te ih zamoči u krv ptice zaklane i u živu vodu pa kuću poškropi sedam puta. ");
INSERT INTO hrv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Očistivši tako od grijeha kuću krvlju ptice, živom vodom, živom pticom, cedrovinom, izopom i grimiznim predivom, ");
INSERT INTO hrv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","neka pticu živu pusti izvan grada na otvorenu polju. Kad tako obavi obred pomirenja nad kućom, bit će čista.” ");
INSERT INTO hrv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","To je propis za svaku vrst gube i šuge, ");
INSERT INTO hrv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","za gubu odjeće ili kuće, ");
INSERT INTO hrv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","za otekline, lišaje ili pjege. ");
INSERT INTO hrv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","On određuje vrijeme nečistoće i čistoće. To je zakon o gubi. ");
INSERT INTO hrv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Jahve reče Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Govorite Izraelcima i kažite im: 'Kad koji čovjek imadne izljev iz svoga tijela, njegov je izljev nečist. ");
INSERT INTO hrv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Evo u čemu je njegova nečistoća ako ima taj izljev: ispusti li njegovo tijelo izljev ili ga zadrži, on je nečist. ");
INSERT INTO hrv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Svaka postelja na koju legne onaj koji ima izljev neka je nečista; i svaki predmet na koji sjedne neka je nečist. ");
INSERT INTO hrv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","A svaki koji se dotakne njegove posteljine neka opere svoju odjeću, u vodi se okupa i nečistim ostane do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Tko god sjedne na predmet na kojemu je sjedio onaj koji je imao izljev neka opere svoju odjeću, u vodi se okupa i nečistim ostane do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Tko se dotakne tijela onoga koji je imao izljev neka opere svoju odjeću, u vodi se okupa i do večeri nečistim ostane. ");
INSERT INTO hrv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ako onaj koji ima izljev pljune na koga tko je čist neka taj opere svoju odjeću, u vodi se okupa i nečistim ostane do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Neka je nečisto i svako sjedalo na koje za vožnje sjedne onaj koji ima izljev; ");
INSERT INTO hrv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","i tko se dotakne čega što je pod tim bolesnikom bilo neka je nečist do večeri. Tko ponese štogod takvo neka svoju odjeću opere, u vodi se okupa i ostane nečistim do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","A svaki koga se onaj koji ima izljev dotakne neopranih ruku neka svoju odjeću opere, u vodi se okupa i ostane nečistim do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Zemljana posuda koje se dotakne onaj s izljevom neka se razbije, a svaki drveni sud neka se vodom ispere. ");
INSERT INTO hrv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Kad se onaj koji ima izljev od toga izliječi, neka onda nabroji sedam dana za svoje oćišćenje; neka opere svoju odjeću, okupa se u živoj vodi i neka je čist. ");
INSERT INTO hrv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Osmoga pak dana neka uzme dvije grlice ili dva golubića, dođe pred Jahvu na ulaz u Šator sastanka pa ih svećeniku preda. ");
INSERT INTO hrv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Neka ih svećenik prinese jedno kao žrtvu okajnicu, a drugo kao žrtvu paljenicu. Time će svećenik izvršiti obred pomirenja nad tim čovjekom za njegov izljev. ");
INSERT INTO hrv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Kad čovjek imadne sjemeni izljev, neka u vodi okupa cijelo svoje tijelo i ostane nečistim do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Svaka haljina i svaka koža na koju dospije takav sjemeni izljev neka se u vodi opere i ostane nečistom do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ako koja žena legne s kojim čovjekom i on ispusti sjeme, neka se okupaju u vodi i budu nečisti do večeri'.” ");
INSERT INTO hrv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Kad žena imadne krvarenje, izljev krvi iz svoga tijela, neka ostane u svojoj nečistoći sedam dana; tko se god nje dotakne neka je nečist do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Na što god bi legla za svoje nečistoće neka je nečisto; na što god sjedne neka je nečisto. ");
INSERT INTO hrv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Tko se dotakne njezine posteljine neka opere svoju odjeću, u vodi se okupa i do večeri ostane nečistim. ");
INSERT INTO hrv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Tko god dotakne bilo koji predmet na kojemu je ona sjedila neka svoju odjeću opere, u vodi se okupa i nečist ostane do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","A ako bi se dotakao čega što je bilo na njezinoj postelji ili na predmetu na kojem je ona sjedila, neka je nečist do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ako koji čovjek s njom legne, njezina nečistoća za nj prianja, pa neka je nečist sedam dana. Svaka postelja na koju on legne neka je nečista. ");
INSERT INTO hrv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Ako žena imadne krvarenje dulje vremena izvan svoga mjesečnog pranja, ili ako se njezino mjesečno pranje produžuje, neka se smatra nečistom sve vrijeme krvarenja kao da su dani njezina mjesečnog pranja. ");
INSERT INTO hrv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Svaka postelja na koju legne za sve vrijeme svoga krvarenja bit će joj kao i postelja za njezina mjesečnog pranja. I svaki predmet na koji sjedne neka postane nečistim kao što bi bio nečist u vrijeme njezina mjesečnog pranja. ");
INSERT INTO hrv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","A svatko tko ih se dotakne neka je nečist; neka opere svoju odjeću, okupa se u vodi i ostane nečistim do večeri. ");
INSERT INTO hrv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ako ozdravi od svog krvarenja, neka namiri sedam dana, a poslije toga neka je čista. ");
INSERT INTO hrv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Osmoga dana neka uzme dvije grlice ili dva golubića te ih donese svećeniku na ulaz u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Neka jedno svećenik prinese kao žrtvu okajnicu, a drugo kao žrtvu paljenicu. Tako će svećenik obaviti pred Jahvom obred pomirenja nad njom, za njezino nečisto krvarenje.” ");
INSERT INTO hrv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Odvraćajte Izraelce od njihovih nečistoća, da ne bi zbog njih pomrli oskvrnjujući moje Prebivalište koje se nalazi među njima. ");
INSERT INTO hrv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","To je propis za čovjeka koji ima izljev; za onoga koga čini nečistim sjemeni izljev; ");
INSERT INTO hrv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","za ženu u vrijeme nečistoće njezina mjesečnog pranja; za svakoga - bilo muško bilo žensko - tko imadne izljev, a tako i za čovjeka koji legne s onečišćenom ženom.” ");
INSERT INTO hrv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Poslije smrti dvojice Aronovih sinova, koji su poginuli prinoseći pred Jahvom neposvećenu vatru, progovori Jahve Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Jahve reče Mojsiju: “Kaži svome bratu Aronu da ne ulazi u svako doba u Svetište iza zavjese, pred Pomirilište koje se nalazi na Kovčegu, da ne pogine. Jer ja ću se pojavljivati nad Pomirilištem u oblaku. ");
INSERT INTO hrv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Neka Aron ulazi u Svetište ovako: s juncem za žrtvu okajnicu i ovnom za žrtvu paljenicu. ");
INSERT INTO hrv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Neka se obuče u posvećenu košulju od lana; na svoje tijelo neka navuče gaće od lana; neka se opaše lanenim pasom, a na glavu stavi mitru od lana. To je posvećeno ruho koje ima obući pošto se okupa u vodi. ");
INSERT INTO hrv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Od zajednice izraelske neka primi dva jarca za žrtvu okajnicu i jednoga ovna za žrtvu paljenicu. ");
INSERT INTO hrv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Pošto Aron prinese junca za žrtvu okajnicu za svoj grijeh i izvrši obred pomirenja za se i za svoj dom, ");
INSERT INTO hrv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","neka uzme oba jarca i postavi ih pred Jahvu na ulaz u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Neka Aron baci kocke za oba jarca te jednoga odredi kockom Jahvi, a drugoga Azazelu. ");
INSERT INTO hrv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Jarca na kojega je kocka pala da bude Jahvi neka Aron prinese za žrtvu okajnicu. ");
INSERT INTO hrv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","A jarac na kojega je kocka pala da bude Azazelu neka se smjesti živ pred Jahvu, da se nad njim obavi obred pomirenja i otpremi Azazelu u pustinju. ");
INSERT INTO hrv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Zatim neka Aron prinese junca za žrtvu okajnicu za svoj grijeh; i obavi obred pomirenja za se i za svoj dom: i neka zakolje toga junca za žrtvu okajnicu za svoj grijeh. ");
INSERT INTO hrv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Potom neka uzme kadionik pun užarena ugljevlja sa žrtvenika ispred Jahve i dvije pune pregršti miomirisnoga tamjana u prah smrvljenoga. Neka to unese iza zavjese. ");
INSERT INTO hrv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Sad neka stavi tamjan na vatru pred Jahvom da oblak od tamjana zastre Pomirilište što je na Svjedočanstvu. Tako neće poginuti. ");
INSERT INTO hrv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Poslije toga neka uzme krvi od junca i svojim prstom poškropi istočnu stranu Pomirilišta; a ispred Pomirilišta neka svojim prstom poškropi sedam puta tom krvlju. ");
INSERT INTO hrv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Neka potom zakolje jarca za žrtvu okajnicu za grijeh naroda; neka unese njegovu krv za zavjesu te s njegovom krvi učini kako je učinio s krvlju od junca: neka njome poškropi po Pomirilištu i pred njim. ");
INSERT INTO hrv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Tako će obaviti obred pomirenja nad Svetištem zbog nečistoća Izraelaca, zbog njihovih prijestupa i svih njihovih grijeha. A tako neka učini i za Šator sastanka što se među njima nalazi, sred njihovih nečistoća. ");
INSERT INTO hrv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kad on uđe da obavi obred pomirenja u Svetištu, neka nikoga drugog ne bude u Šatoru sastanka dok on ne iziđe. Obavivši obred pomirenja za se, za svoj dom i za svu izraelsku zajednicu, ");
INSERT INTO hrv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","neka ode k žrtveniku koji se nalazi pred Jahvom te nad žrtvenikom obavi obred pomirenja. Neka uzme krvi od junca i krvi od jarca pa stavi na rogove oko žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Neka svojim prstom poškropi žrtvenik istom krvlju sedam puta. Tako će ga očistiti od nečistoća Izraelaca i posvetiti. ");
INSERT INTO hrv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Kad svrši obred pomirenja Svetišta, Šatora sastanka i žrtvenika, neka primakne jarca živoga. ");
INSERT INTO hrv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Neka mu na glavu Aron stavi obje svoje ruke i nad njim ispovjedi sve krivnje Izraelaca, sve njihove prijestupe i sve njihove grijehe. Položivši ih tako jarcu na glavu, neka ga pošalje u pustinju s jednim prikladnim čovjekom. ");
INSERT INTO hrv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Tako će jarac na sebi odnijeti sve njihove krivnje u pusti kraj. Otpremivši jarca u pustinju, ");
INSERT INTO hrv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","neka se Aron vrati u Šator sastanka, sa sebe svuče lanenu odjeću u koju se bio obukao kad je ulazio u Svetište i neka je ondje ostavi. ");
INSERT INTO hrv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Neka potom opere svoje tijelo vodom na posvećenu mjestu, na se obuče svoju odjeću te iziđe da prinese svoju žrtvu paljenicu i žrtvu paljenicu naroda i obavi obred pomirenja za se i za narod. ");
INSERT INTO hrv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Loj sa žrtve okajnice neka sažeže u kad na žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Onaj koji je odveo jarca Azazelu neka opere svoju odjeću, svoje tijelo u vodi okupa i poslije toga može opet doći u tabor. ");
INSERT INTO hrv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","A junca žrtve okajnice i jarca žrtve okajnice od kojih je krv bila donesena u Svetište da se obavi obred pomirenja neka odnesu izvan tabora pa neka na vatri spale njihove kože, njihovo meso i njihovu nečist. ");
INSERT INTO hrv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Tko ih bude spaljivao, neka opere svoju odjeću, svoje tijelo okupa u vodi i poslije toga može opet doći u tabor. ");
INSERT INTO hrv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Ovaj zakon neka za vas trajno vrijedi. U sedmom mjesecu, deseti dan toga mjeseca, postite i ne obavljajte nikakva posla: ni domorodac ni stranac koji među vama boravi. ");
INSERT INTO hrv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Jer toga dana nad vama se ima izvršiti obred pomirenja da se očistite od svih svojih grijeha te da pred Jahvom budete čisti. ");
INSERT INTO hrv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Neka je to za vas subotnji počinak kad postite. Trajan je to zakon. ");
INSERT INTO hrv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Neka obred pomirenja obavi onaj svećenik koji bude pomazan i posvećen za vršenje svećeničke službe namjesto svoga oca. Neka se obuče u posvećeno laneno ruho; ");
INSERT INTO hrv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","on neka obavi obred pomirenja za posvećeno Svetište, za Šator sastanka i za žrtvenik. Zatim neka izvrši obred pomirenja nad svećenicima i nad svim narodom zajednice. ");
INSERT INTO hrv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Tako neka to bude za vas trajan zakon; jednom na godinu neka se nad Izraelcima obavi obred pomirenja za sve njihove grijehe.” Mojsije je učinio kako mu je Jahve naredio. ");
INSERT INTO hrv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Govori Aronu, njegovim sinovima i svima Izraelcima te im reci: 'Evo što je zapovjedio Jahve: ");
INSERT INTO hrv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","svaki onaj od Izraelova doma koji u taboru ili izvan tabora zakolje vola, ili ovcu, ili kozu, ");
INSERT INTO hrv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a ne donese ih na ulaz u Šator sastanka da se prinesu na dar Jahvi pred njegovim Prebivalištem, svaki takav neka je odgovoran: prolio je krv i neka se odstrani iz svoga naroda.' ");
INSERT INTO hrv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Zato neka Izraelci svoje žrtve koje bi htjeli klati vani u polju dovedu na ulaz u Šator sastanka, k svećeniku, i neka ih prinose kao žrtve pričesnice. ");
INSERT INTO hrv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Neka svećenik izlije krv po Jahvinu žrtveniku koji se nalazi na ulazu u Šator sastanka, a loj spali na ugodan miris Jahvi, ");
INSERT INTO hrv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","tako da ubuduće ne prinose svojih žrtava klanica jarcima s kojima se odaju bludu. Neka je ovo trajan zakon za njih i njihove naraštaje. ");
INSERT INTO hrv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","I kaži im: 'Svaki pojedinac od Izraelova doma, ili stranac koji među vama boravi, koji prinese paljenicu ili klanicu ");
INSERT INTO hrv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","a ne donese je na ulaz u Šator sastanka da se prinese Jahvi, taj neka se odstrani iz svoga naroda.'” ");
INSERT INTO hrv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Nadalje, protiv svakoga pojedinca od Izraelova doma, a tako i protiv svakoga pridošlice među vama koji bi blagovao bilo kakvu krv, ja ću se okrenuti, svakoga tko blaguje krv odstranit ću iz njegova naroda. ");
INSERT INTO hrv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Jer je život živoga bića u krvi. Tu krv ja sam vama dao da na žrtveniku njome obavljate obred pomirenja za svoje živote. Jer krv je ono što ispašta za život. ");
INSERT INTO hrv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Zato sam kazao Izraelcima: neka nitko od vas ne jede krvi; neka ni stranac koji među vama bude ne jede krvi. ");
INSERT INTO hrv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Tko god, Izraelac ili stranac koji među vama boravi, uhvati u lovu kakvu zvijer ili pticu što se može jesti neka joj prolije krv i zatrpa zemljom. ");
INSERT INTO hrv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Jer život svakoga živog bića jest njegova krv. Zato sam i rekao Izraelcima: ne smijete jesti krvi ni od kakva živog bića, jer život svakoga živog bića jest njegova krv. Tko god je bude jeo, neka se odstrani. ");
INSERT INTO hrv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Tko bi god, Izraelac ili stranac, jeo što je uginulo ili što su zvijeri rastrgale neka opere svoju odjeću, u vodi se okupa i ostane nečistim do večeri. Tada će postati čist. ");
INSERT INTO hrv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ali ako je ne opere i ne okupa svoga tijela, neka snosi posljedice svoje krivnje.” ");
INSERT INTO hrv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Govori Izraelcima i reci im: 'Ja sam Jahve, Bog vaš. ");
INSERT INTO hrv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Nemojte raditi kako se radi u zemlji egipatskoj, gdje ste boravili; niti radite kako se radi u zemlji kanaanskoj, kamo vas vodim; ne povodite se za njihovim običajima! ");
INSERT INTO hrv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Vršite moje naredbe; vršite moje zapovijedi; prema njima hodite. Ja sam Jahve, Bog vaš. ");
INSERT INTO hrv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Zato držite moje zakone i moje naredbe; tko ih vrši - u njima će naći život. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Neka se nitko od vas ne približuje svojoj krvnoj rodbini da otkriva njezinu golotinju. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ne otkrivaj golotinje svoga oca ni golotinje svoje majke. Majka ti je, ne otkrivaj njezine golotinje! ");
INSERT INTO hrv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ne otkrivaj golotinje žene svoga oca! I to je golotinja tvoga oca! ");
INSERT INTO hrv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ne otkrivaj golotinje svoje sestre - kćeri svoga oca ili kćeri svoje majke - bila rođena u kući ili izvan nje! ");
INSERT INTO hrv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ne otkrivaj golotinje kćeri svoga sina niti golotinje kćeri svoje kćeri! TÓa njihova je golotinja tvoja vlastita golotinja. ");
INSERT INTO hrv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ne otkrivaj golotinje kćeri žene svoga oca! Jer, rođena od tvog oca, ona ti je sestra. ");
INSERT INTO hrv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ne otkrivaj golotinje sestre svoga oca! Ona je krv tvoga oca. ");
INSERT INTO hrv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ne otkrivaj ni golotinje sestre svoje majke! Ta i ona je krv tvoje majke! ");
INSERT INTO hrv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ne otkrivaj golotinje svoga strica! To jest, nemoj se približavati njegovoj ženi. Ta ona je tvoja strina. ");
INSERT INTO hrv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ne otkrivaj golotinje svoje snahe! Ona je žena tvoga sina. Ne otkrivaj golotinje njezine. ");
INSERT INTO hrv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ne otkrivaj golotinje žene svoga brata! Ta to je golotinja tvoga brata. ");
INSERT INTO hrv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ne otkrivaj golotinje koje žene i njezine kćeri! Nemoj se ženiti kćerju njezina sina niti kćerju njezine kćeri te im golotinju otkrivati. Oni su krvna rodbina. To bi bila pokvarenost. ");
INSERT INTO hrv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ne uzimaj sebi koju ženu u isto vrijeme kad i njezinu sestru da je ljubomorom žalostiš otkrivajući golotinju ovoj preko nje za njezina života! ");
INSERT INTO hrv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ne približuj se ni jednoj ženi kad je u nečistoći svoga mjesečnog pranja da joj otkrivaš golotinju! ");
INSERT INTO hrv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ne lijegaj sa ženom bližnjega svoga; od nje bi postao nečist. ");
INSERT INTO hrv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ne smiješ dopuštati da koje tvoje dijete bude žrtvovano Moleku; ne smiješ tako obeščašćivati ime Boga svoga. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ne lijegaj s muškarcem kako se liježe sa ženom! To bi bila grozota. ");
INSERT INTO hrv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Da nisi legao ni s jednom životinjom - od nje bi postao nečist. Žena ne smije stati pred životinju da se s njom pari. To bi bila krajnja opačina. ");
INSERT INTO hrv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ničim se od toga nemojte onečišćavati! Ta svim su se tim onečišćavali narodi koje ja ispred vas tjeram. ");
INSERT INTO hrv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","I zemlja je postala nečista. Zato ću kazniti njezinu opačinu, i zemlja će ispljuvati svoje stanovnike. ");
INSERT INTO hrv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Vi pak držite moje zakone i moje naredbe: ni jedne od tih opačina nemojte počinjati - ni vi ni stranac koji među vama boravi. ");
INSERT INTO hrv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Sve je te zloće počinjao svijet koji je bio u toj zemlji prije vas te je zemlja postala nečista. ");
INSERT INTO hrv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Neće li, ako je učinite nečistom, zemlja ispljuvati i vas kako je ispljuvala narod koji je bio prije vas? ");
INSERT INTO hrv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Jest, svi koji bi počinili bilo koju od tih zloća bit će odstranjeni iz svoga naroda. ");
INSERT INTO hrv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Zato držite moje zapovijedi; nemojte se podavati ni jednome od onih odvratnih običaja što su se održavali prije vas; tako se njima nećete onečistiti. Ja sam Jahve, Bog vaš!'” ");
INSERT INTO hrv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Govori svoj zajednici Izraelaca i reci im: 'Sveti budite! Jer sam svet ja, Jahve, Bog vaš! ");
INSERT INTO hrv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Svoje se majke i svoga oca svaki bojte! Subote moje držite! Ja sam Jahve, Bog vaš! ");
INSERT INTO hrv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ne obraćajte se na ništavila! Ne pravite sebi lijevanih kumira! Ja sam Jahve, Bog vaš! ");
INSERT INTO hrv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Kad prinosite Jahvi žrtvu pričesnicu, prinesite je tako da budete primljeni. ");
INSERT INTO hrv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Neka se pojede na dan kad je prinosite ili sutradan. Što preostane za prekosutra neka se spali na vatri. ");
INSERT INTO hrv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kad bi se jelo od toga jela treći dan, bilo bi odvratno i žrtva ne bi bila primljena. ");
INSERT INTO hrv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","A onaj koji je ipak jede neka snosi posljedice svoje krivnje. Budući da je oskvrnuo ono što je Jahvi posvećeno, neka se takav odstrani iz svoga naroda. ");
INSERT INTO hrv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Kad žetvu žanjete po svojoj zemlji, ne žanjite dokraja svoje njive; niti pabirčite ostatke poslije svoje žetve. ");
INSERT INTO hrv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ne paljetkuj svoga vinograda; ne kupi po svom vinogradu palih boba nego ih ostavljaj sirotinji i strancu! Ja sam Jahve, Bog vaš. ");
INSERT INTO hrv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Nemojte krasti; nemojte lagati i varati svoga bližnjega. ");
INSERT INTO hrv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Nemojte se krivo kleti mojim imenom i tako oskvrnjivati ime svoga Boga. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ne iskorišćuj svoga bližnjega niti ga pljačkaj! Radnikova zarada neka ne ostane pri tebi do jutra. ");
INSERT INTO hrv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Nemoj psovati gluhoga niti pred slijepca stavljaj zapreku. Svoga se Boga boj! Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ne počinjajte nepravde u osudama! Ne budi pristran prema neznatnome, niti popuštaj pred velikima; po pravdi sudi svome bližnjemu! ");
INSERT INTO hrv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ne raznosi klevete među svojim narodom; ne izvrgavaj pogibli krv svoga bližnjega. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ne mrzi svoga brata u svom srcu! Dužnost ti je koriti svoga sunarodnjaka. Tako nećeš pasti u grijeh zbog njega. ");
INSERT INTO hrv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ne osvećuj se! Ne gaji srdžbe prema sinovima svoga naroda. Ljubi bližnjega svoga kao samoga sebe. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Držite moje zapovijedi! Ne daj svome blagu da se pari s drugom vrstom. Svoga polja ne zasijavaj dvjema vrstama sjemena. Ne stavljaj na se odjeće od dvije vrste tkanine. ");
INSERT INTO hrv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ako bi tko legao s ropkinjom koja je zaručena za drugoga, a ona ne bude ni otkupljena ni oslobođena, treba ga kazniti, ali ne smrću, jer ona nije slobodna. ");
INSERT INTO hrv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Neka on na ulazu u Šator sastanka prinese Jahvi žrtvu naknadnicu, to jest jednoga ovna kao žrtvu naknadnicu. ");
INSERT INTO hrv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Neka svećenik tim ovnom žrtve naknadnice izvrši nad tim čovjekom obred pomirenja pred Jahvom za počinjeni grijeh. I grijeh koji je počinio bit će mu oprošten. ");
INSERT INTO hrv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kad uđete u zemlju i zasadite bilo kakvu voćku, smatrajte njezine plodove za neobrezane. Tri godine neka vam budu neobrezani: neka se ne jedu. ");
INSERT INTO hrv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Četvrte godine neka se svi njezini plodovi posvete na svetkovinu zahvale Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Istom pete godine jedite njezin plod i ubirite sebi njezin urod. Ja sam Jahve, Bog vaš! ");
INSERT INTO hrv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ništa s krvlju nemojte jesti! Ne gatajte! Ne čarajte! ");
INSERT INTO hrv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ne zaokružujte kose na svojim sljepoočnicama; ne šišajte okrajka svoje brade. ");
INSERT INTO hrv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ne urezujte zareza na svome tijelu za pokojnika; niti na sebi usijecajte kakvih biljega. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ne obeščašćuj svoje kćeri dajući je za javnu bludnicu. Tako se zemlja neće podati bludnosti niti će se napuniti pokvarenošću. ");
INSERT INTO hrv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Držite moje subote; štujte moje Svetište. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ne obraćajte se na zazivače duhova i vračare; ne pitajte ih za savjet. Oni bi vas opoganili. Ja sam Jahve, Bog vaš! ");
INSERT INTO hrv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ustani pred sijedom glavom; poštuj lice starca; boj se svoga Boga. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Ako se stranac nastani u vašoj zemlji, nemojte ga ugnjetavati. ");
INSERT INTO hrv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Stranac koji s vama boravi neka vam bude kao sunarodnjak; ljubi ga kao sebe samoga. TÓa i vi ste bili stranci u egipatskoj zemlji. Ja sam Jahve, Bog vaš. ");
INSERT INTO hrv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ne počinjajte nepravde u osudama, u mjerama za duljinu, težinu i obujam. ");
INSERT INTO hrv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Neka su vam mjerila točna; utezi jednaki; efa prava; prav hin. Ja sam Jahve, Bog vaš, koji sam vas izveo iz zemlje egipatske. ");
INSERT INTO hrv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Držite sve moje zakone i sve moje naredbe; vršite ih. Ja sam Jahve!'” ");
INSERT INTO hrv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Kaži Izraelcima: 'Tko god, Izraelac, ili stranac koji živi s Izraelcima, ustupi svoje čedo Moleku, mora se smaknuti; narod zemlje neka ga kamenuje. ");
INSERT INTO hrv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ja ću se okrenuti protiv toga čovjeka i odstraniti ga iz njegova naroda, jer je on, ustupivši svoje čedo Moleku, okaljao moje Svetište i obeščastio moje sveto ime. ");
INSERT INTO hrv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","A ako narod zatvori svoje oči nad tim čovjekom kad svoje čedo ustupi Moleku te ga ne smakne, ");
INSERT INTO hrv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ja ću se suprotstaviti tome čovjeku i njegovoj obitelji; odstranit ću ih iz njihova naroda, njega i sve koji poslije njega pođu za Molekom da se podaju bludu s Molekom. ");
INSERT INTO hrv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ako se tko obrati na zazivače duhova i vračare da se za njima poda javnom bludu, ja ću se okrenuti protiv takva čovjeka i odstranit ću ga iz njegova naroda. ");
INSERT INTO hrv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Posvećujte se da budete sveti! TÓa ja sam Jahve, Bog vaš. ");
INSERT INTO hrv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Držite moje zakone i vršite ih. Ja, Jahve, posvećujem vas'.” ");
INSERT INTO hrv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Tko god prokune svoga oca i svoju majku, neka se smakne. Jer je oca svoga i majku svoju prokleo, neka njegova krv padne na nj. ");
INSERT INTO hrv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Čovjek koji počini preljub sa ženom svoga susjeda neka se kazni smrću - i preljubnik i preljubnica. ");
INSERT INTO hrv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Čovjek koji bi legao sa ženom svoga oca - otkrio bi golotinju svoga oca - neka se oboje kazne smrću, krv njihova neka padne na njih. ");
INSERT INTO hrv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Legne li tko sa svojom snahom, neka se oboje kazne smrću. Učinili su rodoskvrnuće i neka krv njihova padne na njih. ");
INSERT INTO hrv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ako bi muškarac legao s muškarcem kao što se liježe sa ženom, obojica bi počinila odvratno djelo. Neka se smaknu i krv njihova neka padne na njih. ");
INSERT INTO hrv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Čovjek koji se oženi kćerju i njezinom majkom - krajnja je to pokvarenost! - neka se u vatri spali i on i one, da među vama ne bude pokvarenosti. ");
INSERT INTO hrv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Čovjek koji bi spolno općio sa životinjom ima se smaknuti. Životinju ubijte! ");
INSERT INTO hrv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ako bi se žena primakla bilo kakvoj životinji da se s njom pari, ubij i ženu i životinju. Neka se smaknu i njihova krv neka padne na njih. ");
INSERT INTO hrv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Čovjek koji bi se oženio svojom sestrom, kćerju svoga oca ili kćerju svoje majke te vidio njezinu golotinju, a ona vidjela njegovu - pogrdno je to djelo! - neka se istrijebe pred očima naroda. Otkrio je golotinju svoje sestre, pa neka snosi i posljedice svoje krivnje. ");
INSERT INTO hrv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Čovjek koji bi legao sa ženom za njezina mjesečnog pranja te otkrio njezinu golotinju - razgolio izvor njezine krvi i ona sama otkrila izvor svoje krvi - neka se oboje odstrane iz svoga naroda. ");
INSERT INTO hrv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ne otkrivaj golotinje sestre svoje majke niti sestre svoga oca - to je otkrivanje golotinje svoga roda, neka snose posljedice svoje krivnje. ");
INSERT INTO hrv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Čovjek koji bi legao sa svojom strinom otkrio bi golotinju svoga strica. Neka snose posljedice svoga grijeha: neka umru bez poroda. ");
INSERT INTO hrv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Čovjek koji bi se oženio ženom svoga brata - golotinju bi svoga brata otkrio - i to je nečisto. Neka ostanu bez poroda.” ");
INSERT INTO hrv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Zato držite sve moje zakone, sve moje naredbe i vršite ih da vas ne ispljune zemlja u koju vas vodim da se u njoj nastanite. ");
INSERT INTO hrv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Nemojte živjeti po zakonima naroda koje ja ispred vas tjeram. TÓa oni su činili sve to, i zato mi se zgadili. ");
INSERT INTO hrv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","A vama sam ja rekao: vi ćete zaposjesti njihovu zemlju; vama ću je predati u posjed - zemlju kojom teče mlijeko i med. Ja sam Jahve, vaš Bog, koji sam vas odvojio od tih naroda. ");
INSERT INTO hrv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Pravite, dakle, razliku između čiste životinje i nečiste; između čiste ptice i nečiste. Nemojte sami sebe opoganjivati ni životinjom, ni pticom, ni bilo čim što zemljom puže: što sam vam ja odlučio kao nečisto. ");
INSERT INTO hrv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Budite mi dakle sveti, jer sam ja, Jahve, svet; ja sam vas odvojio od tih naroda da budete moji. ");
INSERT INTO hrv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Čovjek ili žena koji među vama postanu zazivači duhova ili vračari neka se kazne smrću; neka se kamenuju i neka njihova krv padne na njih.” ");
INSERT INTO hrv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Jahve još reče Mojsiju: “Govori svećenicima, Aronovim sinovima, i reci im: Neka se nitko ne okalja dodirom pokojnika u svome narodu, ");
INSERT INTO hrv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","osim svoje najbliže rodbine: svoje majke, svoga oca, svoga sina, svoje kćeri i svojega brata. ");
INSERT INTO hrv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","I svojom sestrom, djevicom, koja mu je također najbliža, jer nije bila udata, može se okaljati. ");
INSERT INTO hrv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ali neka se ne okalja svojom svojtom i tako se oskvrne. ");
INSERT INTO hrv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Neka ne briju glave; neka ne šišaju okrajke svojih brada niti prave ureze na svome tijelu. ");
INSERT INTO hrv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Neka budu posvećeni svome Bogu; neka ne oskvrnjuju ime svoga Boga, jer oni prinose žrtve u čast Jahvi paljene, hranu Boga svoga. Zato moraju biti sveti. ");
INSERT INTO hrv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Neka se ne žene javnom bludnicom i obeščašćenom ženom; niti se smiju ženiti onom koju je njezin muž otpustio. Jer je svećenik posvećen svome Bogu. ");
INSERT INTO hrv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Svetim ga drži, jer on prinosi hranu tvoga Boga. Neka ti je svet, jer sam svet ja, Jahve, koji vas posvećujem. ");
INSERT INTO hrv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ako se kći kojeg svećenika oskvrne podavši se javnom bludništvu, ona oca svoga skvrne, pa se mora na vatri spaliti.” ");
INSERT INTO hrv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“A svećenik koji je najveći među svojom braćom, na čiju je glavu bilo izliveno ulje pomazanja i koji je posvećen da nosi svetu odjeću, neka ne ide raščupane kose niti razdire svoje odjeće. ");
INSERT INTO hrv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Neka ne ulazi nijednom mrtvacu; ne smije se okaljati ni za svojim ocem ni za svojom majkom. ");
INSERT INTO hrv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Neka ne izlazi iz Svetišta, tako da ne oskvrne Svetište svoga Boga, jer na sebi nosi posvećenje uljem pomazanja Boga svoga. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Neka za ženu uzme djevicu. ");
INSERT INTO hrv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Udovicom, otpuštenicom, obeščašćenom i bludnicom ne smije se ženiti. Jedino djevicom između svoga naroda neka se ženi; ");
INSERT INTO hrv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","tako neće oskvrnuti svoga potomstva među svojim narodom, jer ja, Jahve, njega posvećujem.” ");
INSERT INTO hrv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Reci Aronu: 'Nitko od tvojih potomaka, za njihovih naraštaja, koji imadne kakvu tjelesnu manu ne smije se primaknuti da prinosi hranu svoga Boga. ");
INSERT INTO hrv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ni jedan na kome bude mane ne smije se primaknuti: nitko koji je slijep ili sakat; nitko izobličen ili iznakažena kojeg uda; ");
INSERT INTO hrv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","nitko tko ima slomljenu nogu ili ruku; ");
INSERT INTO hrv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ni poguren, ni kržljav, ni bolesnih očiju, ni lišajav, ni krastav, niti uškopljenik. ");
INSERT INTO hrv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Dakle, ni jedan od potomaka svećenika Arona koji imadne manu neka se ne primiče da prinosi u čast Jahvi paljenu žrtvu; budući da ima manu, neka se ne primiče da prinosi hranu svoga Boga. ");
INSERT INTO hrv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Može blagovati hranu svoga Boga i od žrtava presvetih, i svetih, ");
INSERT INTO hrv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ali neka ne dolazi k zavjesi niti se žrtveniku primiče jer ima manu. Neka ne skvrne mojih svetih stvari, jer sam ih ja, Jahve, posvetio.'” ");
INSERT INTO hrv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Mojsije to kaza Aronu, njegovim sinovima i svim Izraelcima. ");
INSERT INTO hrv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Reci Aronu i njegovim sinovima da sveto postupaju sa svetim prinosima Izraelaca; neka ne oskvrnjuju moje sveto ime koje oni - ta moje je! - moraju svetiti. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Reci im: 'Ako se ikad tko od vaših naraštaja primakne u stanju nečistoće k svetim prinosima što ih Izraelci posvećuju Jahvi, taj će biti uklonjen od moje nazočnosti. Ja sam Jahve!' ");
INSERT INTO hrv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Neka nitko od Aronovih potomaka koji bude gubav ili imadne izljev ne blaguje svetih prinosa dok ne postane čist. Onaj koji se dotakne bilo čega što je mrtvo tijelo okaljalo ili onaj koji iz sebe prospe sjemeni izljev; ");
INSERT INTO hrv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","onaj koji se dotakne kakva puzavca koji ga onečisti; ili čovjeka od kojega se okalja bilo kakvom nečistoćom - ");
INSERT INTO hrv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","onaj koji se dotakne čega takva neka je nečist do večeri i neka ne blaguje svetih prinosa dok ne okupa svoje tijelo u vodi. ");
INSERT INTO hrv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Čim sunce zađe, čist je. Poslije toga može blagovati od svetih prinosa jer mu je to hrana. ");
INSERT INTO hrv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Neka ne jede ni strva ni što je zvjerad rastrgla. Time bi se okaljao. ");
INSERT INTO hrv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Neka drže moje naredbe, da ne navuku na se krivnju i zbog nje, oskvrnuvši se, ne poginu. Ta ja, Jahve, njih posvećujem.” ");
INSERT INTO hrv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Neka nijedan svjetovnjak ne blaguje od prinosa; ni ukućanin ni svećenikov sluga ne smije jesti od svetoga prinosa. ");
INSERT INTO hrv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ali ako svećenik steče koga novcem u svoje vlasništvo, taj to može jesti kao onaj što se rodi u njegovoj kući; oni mogu jesti od njegove hrane. ");
INSERT INTO hrv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ako se svećenikova kći uda za svjetovnjaka, ne smije blagovati od podizanih svetih prinosa. ");
INSERT INTO hrv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ali ako svećenikova kći obudovi ili bude otpuštena, a nema djece pa se vrati u očevu kuću, može se hraniti očevom hranom kao u svojoj mladosti. Nikakav svjetovnjak ne smije što od toga jesti. ");
INSERT INTO hrv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Bude li tko iz neznanja jeo sveti prinos, neka ga nadoknadi svećeniku dodajući petinu. ");
INSERT INTO hrv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Neka ne oskvrnjuju svetih prinosa što ih Izraelci Jahvi podižu. ");
INSERT INTO hrv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Jedući ih, navukli bi na se krivnju koja bi ih obvezivala na nadoknadu, jer ja, Jahve, posvetio sam te prinose.” ");
INSERT INTO hrv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Govori Aronu, njegovim sinovima i svim Izraelcima i reci im: 'Svaki čovjek doma Izraelova ili stranac u Izraelu koji donosi svoj prinos kao zavjet ili kao dragovoljan dar da se prinese Jahvi kao žrtva paljenica - da bude primljen - ");
INSERT INTO hrv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","mora prinijeti muško bez mane, bilo to goveče, ovca ili koza. ");
INSERT INTO hrv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Nikakvo s manom na njemu nemojte prinositi jer vam to neće biti primljeno. ");
INSERT INTO hrv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ako tko prinosi Jahvi žrtvu pričesnicu da izvrši kakav zavjet ili učini dragovoljan prinos, bilo od krupne ili sitne stoke, ta životinja, da bude primljena, mora biti bez mane; nikakve mane na njoj ne smije biti. ");
INSERT INTO hrv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Nikakvu slijepu, ili hromu, ili osakaćenu, gušavu, šugavu ili krastavu životinju, nikakvu takvu Jahvi nemoj prinositi niti ikakvu takvu na žrtvenik kao paljenu žrtvu Jahvi polagati. ");
INSERT INTO hrv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Junca ili ovcu s kakvim udom protegnutim ili prikaćenim možeš prinijeti kao dragovoljan prinos, ali kao žrtva zavjetnica neće biti primljena. ");
INSERT INTO hrv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Jahvi nemojte prinositi životinje sa zgnječenim, stučenim, rastrgnutim ili odsječenim mošnjama. To u svoj zemlji ne činite ");
INSERT INTO hrv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","niti takvo što primajte od stranca da to prinesete kao hranu svoga Boga. S manom su jer su osakaćene. Zato vam neće biti primljene.'” ");
INSERT INTO hrv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Kad se tele oteli, janje se ojanji ili se kozle okozi, sedam dana neka ostane uza svoju majku. Od osmoga dana može biti primljeno kao paljena žrtva Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ne koljite krave ni ovce u isti dan s njezinim mladim. ");
INSERT INTO hrv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kad Jahvi žrtvujete žrtvu zahvalnicu, žrtvujte je tako da budete primljeni. ");
INSERT INTO hrv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Neka se žrtva blaguje onoga istog dana; od nje ništa ne ostavljajte za ujutro. Ja sam Jahve!” ");
INSERT INTO hrv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Moje zapovijedi držite i vršite ih. Ja sam Jahve! ");
INSERT INTO hrv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ne oskvrnjujte moga svetog imena, nego neka budem proglašen svetim među Izraelcima - ja, Jahve, koji vas posvećujem. ");
INSERT INTO hrv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ja koji sam vas izbavio iz zemlje egipatske da budem vaš Bog, ja, Jahve.” ");
INSERT INTO hrv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Kaži Izraelcima i reci im: Blagdani Jahvini koje imate sazivati jesu sveti zborovi. Ovo su moji blagdani: ");
INSERT INTO hrv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Šest dana neka se posao obavlja, a sedmi je dan subota - dan potpunog odmora, dan svetoga zbora, kad ne smijete raditi nikakva posla. Gdje god boravili, subota je Jahvina.” ");
INSERT INTO hrv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“A ovo su blagdani Jahvini - sveti zborovi - koje imate proglasiti u njihovo određeno vrijeme: ");
INSERT INTO hrv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","U prvom mjesecu četrnaestoga dana u suton jest Pasha u čast Jahvi; ");
INSERT INTO hrv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","petnaestoga dana toga mjeseca jest Blagdan beskvasnih kruhova u čast Jahvi - sedam dana jedite beskvasan kruh. ");
INSERT INTO hrv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Prvoga dana neka vam bude sveti zbor; nikakva težačkog posla nemojte raditi. ");
INSERT INTO hrv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Sedam dana prinosite paljenu žrtvu u čast Jahvi, a sedmoga dana neka opet bude sveti zbor; nikakva težačkog posla ne radite.” ");
INSERT INTO hrv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Kaži Izraelcima i reci im: 'Kad uđete u zemlju koju vam dajem i u njoj žetvu požanjete, prvi snop svoje žetve donesite svećeniku. ");
INSERT INTO hrv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Neka ga on prinese kao žrtvu prikaznicu pred Jahvom da budete primljeni. Sutradan po suboti neka ga svećenik prinese kao žrtvu prikaznicu. ");
INSERT INTO hrv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","A u dan kad budete prinosili snop kao žrtvu prikaznicu, prinesite Jahvi jednogodišnjeg janjca bez mane kao žrtvu paljenicu. ");
INSERT INTO hrv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Uz to žrtva prinosnica neka bude: dvije desetine efe najboljeg brašna zamiješena u ulju, kao paljena žrtva Jahvi na ugodan miris; a s njom ljevanica od vina neka bude četvrt hina. ");
INSERT INTO hrv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Prije toga dana - dok ne donesete prinose svoga Boga - ne smijete jesti ni kruha, ni pržena zrnja, ni svježa klasja. To je trajan zakon za vaše naraštaje gdje god vi boravili.'” ");
INSERT INTO hrv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“A počevši od sutrašnjega dana po suboti - dana u koji donesete snop za žrtvu prikaznicu - nabrojte punih sedam tjedana. ");
INSERT INTO hrv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Onda na dan po sedmoj suboti, na Pedesetnicu, prinesite Jahvi novu žrtvu. ");
INSERT INTO hrv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Donesite iz svojih stanova po dva kruha za žrtvu prikaznicu. Neka svaki bude od dvije desetine efe najboljeg brašna; neka budu ispečeni ukvas, kao prvine Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","S kruhom prinesite sedam jednogodišnjih janjaca bez mane, jednoga junca i dva ovna kao žrtvu paljenicu Jahvi zajedno sa žrtvom prinosnicom i ljevanicom, žrtvom paljenom na ugodan miris Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Prinesite i jednoga jarca kao žrtvu okajnicu, a dva janjca od godine dana za žrtvu pričesnicu. ");
INSERT INTO hrv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Neka ih svećenik prinese pred Jahvom kao žrtvu prikaznicu povrh kruha od prvina. Uz oba janjca, i ovo je Jahvi sveto i neka pripadne svećeniku. ");
INSERT INTO hrv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Toga istog dana sazovite zbor. Neka vam to bude posvećen zbor - nikakva težačkog posla ne radite. To je trajan zakon za vaše naraštaje gdje god vi boravili. ");
INSERT INTO hrv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Kad budete želi žetvu sa svoje zemlje, nemoj žeti dokraja svoje njive niti pabirčiti poslije svoje žetve. Ostavi to sirotinji i strancu. Ja sam Jahve, Bog vaš.” ");
INSERT INTO hrv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Govori Izraelcima i reci: 'Sedmoga mjeseca, prvoga dana u mjesecu, neka vam je potpun odmor, proglašen glasom trube, sveti zbor. ");
INSERT INTO hrv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Nikakva teškog posla ne radite; u čast Jahvi paljenu žrtvu prinesite.'” ");
INSERT INTO hrv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Reče Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Povrh toga, u deseti dan toga sedmog mjeseca pada Dan pomirenja. Neka vam to bude prigoda za sveti zbor; postite i prinesite u čast Jahvi paljenu žrtvu. ");
INSERT INTO hrv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Toga dana nemojte raditi nikakva posla. To je, naime, Dan pomirenja, kada će se za vas obaviti obred pomirenja pred Jahvom, Bogom vašim. ");
INSERT INTO hrv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Jest, tko god ne bude postio toga dana, neka se odstrani iz svoga naroda. ");
INSERT INTO hrv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","A tko bi god radio kakav posao na taj dan, toga ću ja istrijebiti iz njegova naroda. ");
INSERT INTO hrv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Nikakva posla nemojte raditi. To je trajan zakon za vaše naraštaje gdje god vi boravili. ");
INSERT INTO hrv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Neka vam je to subotnji počinak. Postite! Navečer devetoga dana u mjesecu - od večeri do večeri - prestanite raditi.” ");
INSERT INTO hrv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Reci Izraelcima: 'Od petnaestoga dana toga sedmog mjeseca neka se sedam dana drži Blagdan sjenica u čast Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Prvoga dana, u dan svetoga zbora, nikakva težačkog posla nemojte raditi. ");
INSERT INTO hrv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sedam dana prinosite paljenu žrtvu u čast Jahvi. Osmi dan neka vam bude sveti zbor, kada ćete u čast Jahvi prinijeti paljenu žrtvu. To je svečani zbor; nikakva težačkog posla nemojte obavljati.'” ");
INSERT INTO hrv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“To su blagdani Jahvini koje imate sazvati - sveti zborovi određeni za prinošenje žrtava u čast Jahvi; žrtava paljenica, prinosnica, žrtava klanica i ljevanica; svaku na njezin pravi dan, ");
INSERT INTO hrv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","povrh Jahvinih subota, povrh vlastitih prinosa, povrh svojih zavjetnih i dragovoljnih darova koje inače prinosite Jahvi.” ");
INSERT INTO hrv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Osim toga, petnaestoga dana mjeseca sedmoga, pošto pokupite sa zemlje plodove, svetkujte Jahvin blagdan sedam dana. Na prvi dan i na osmi dan neka je potpun počinak. ");
INSERT INTO hrv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Uzmite već prvoga dana lijepih plodova, palmovih grana, grančica s lisnatih drveta i potočne vrbovine pa se veselite u nazočnosti Jahve, Boga svoga, sedam dana. ");
INSERT INTO hrv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Svetkujte tako blagdan u čast Jahvi sedam dana svake godine. Neka je to trajan zakon za vaše naraštaje. Svetkujte taj blagdan sedmoga mjeseca. ");
INSERT INTO hrv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Sedam dana stanujte u sjenicama. Svi Izraelovi domoroci neka proborave u sjenicama, ");
INSERT INTO hrv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","da vaši potomci znaju kako sam ja učinio da Izraelci žive u sjenicama kad sam ih izbavio iz zemlje egipatske. Ja sam Jahve, Bog vaš.” ");
INSERT INTO hrv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","I tako Mojsije objavi Izraelcima Jahvine blagdane. ");
INSERT INTO hrv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Naredi Izraelcima da ti za svijećnjak donose čistoga ulja od istupanih maslina, da se uvijek održava svjetlo. ");
INSERT INTO hrv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Neka ga Aron svagda sprema pred Jahvom od večeri do jutra u Šatoru sastanka, pred zavjesom Svjedočanstva. Neka je ovo trajan zakon vašim naraštajima. ");
INSERT INTO hrv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Neka Aron neprekidno održava svjetlila na čistome svijećnjaku pred Jahvom.” ");
INSERT INTO hrv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Potom uzmi najboljeg brašna i od njega ispeci dvanaest pogača. Neka u svakoj pogači budu dvije desetine efe. ");
INSERT INTO hrv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Onda ih poredaj u dva reda - po šest u redu - na čistome stolu što je pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Na svaki red stavi čistoga tamjana. Neka to bude hrana prinesena kao spomen - paljena žrtva Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Svake subote, bez prijekida, neka se postavljaju pred Jahvu. To neka Izraelci vrše zbog vječnoga Saveza. ");
INSERT INTO hrv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Neka pripadnu Aronu i njegovim sinovima. Oni ih imaju blagovati na posvećenu mjestu. To je njemu vrlo svet dio Jahvinih paljenih žrtava. To neka bude trajna odredba.” ");
INSERT INTO hrv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","A sin jedne Izraelke, komu otac bijaše Egipćanin, iziđe među Izraelce i zametne u taboru svađu s nekim Izraelcem. ");
INSERT INTO hrv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Uto sin Izraelke pogrdi Ime i opsuje ga. Tada ga dovedu Mojsiju. - Mati mu se zvala Šelomit, a bila je kći Dibrijeva iz plemena Danova. - ");
INSERT INTO hrv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Stave ga u zatvor dok im se ne očituje volja Jahvina. ");
INSERT INTO hrv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Onda Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Izvedi psovača iz tabora. Potom svi oni koji su ga čuli neka stave svoje ruke na njegovu glavu. A onda neka ga sva zajednica kamenuje. ");
INSERT INTO hrv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Poslije toga ćeš ovako prozboriti Izraelcima: Tko god opsuje Boga svoga neka snosi svoju krivnju; ");
INSERT INTO hrv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","tko izgovori hulu na ime Jahvino neka se smakne - neka ga sva zajednica kamenuje; bio stranac ili domorodac, ako pohuli ime Jahvino, mora mrijeti. ");
INSERT INTO hrv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Ako čovjek zada smrtan udarac drugome, mora se smaknuti. ");
INSERT INTO hrv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Tko usmrti živinče mora ga nadomjestiti: život za život. ");
INSERT INTO hrv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Tko ozlijedi svoga bližnjega neka mu se učini kako je on učinio: ");
INSERT INTO hrv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","lom za lom, oko za oko, zub za zub - rana koju je on zadao drugome neka se zada i njemu. ");
INSERT INTO hrv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Tko usmrti živinče mora ga nadoknaditi, ali tko ubije čovjeka mora umrijeti. ");
INSERT INTO hrv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Neka vam je jednak sud i strancu i domorocu. Jer ja sam Jahve, Bog vaš.” ");
INSERT INTO hrv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Pošto je Mojsije to izložio Izraelcima, oni izvedu psovača izvan tabora i zaspu ga kamenjem. Učine, dakle, Izraelci kako je Jahve Mojsiju naredio. ");
INSERT INTO hrv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Jahve reče Mojsiju na Sinajskom brdu: ");
INSERT INTO hrv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Govori Izraelcima i kaži im: Kad uđete u zemlju koju vam dajem, neka ta zemlja održava Jahvin subotni počinak. ");
INSERT INTO hrv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Šest godina zasijavaj svoju njivu, šest godina svoj vinograd obrezuj i beri njegov plod. ");
INSERT INTO hrv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ali sedme godine neka i zemlja uživa subotnji počinak, Jahvinu subotu: svoje njive ne zasijavaj niti obrezuj svoga vinograda. ");
INSERT INTO hrv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Što samo od sebe uzraste na tvojoj njivi nemoj žeti niti beri grožđe s neobrezane loze. Neka to bude zemlji godina počivanja. ");
INSERT INTO hrv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Zemljišni počinak neka vam priskrbi prehranu: tebi, tvome sluzi, tvojoj sluškinji, tvome najamniku koji s tobom živi; ");
INSERT INTO hrv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","a i tvojoj stoci i zvjeradi u tvojoj zemlji neka njezini plodovi služe za hranu.” ");
INSERT INTO hrv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Nabroj sedam sedmica takvih godina, sedam puta sedam godina. Sedam sedmica godina iznosit će ti četrdeset devet godina. ");
INSERT INTO hrv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","A onda zaori u trubu! U sedmome mjesecu, desetoga dana toga mjeseca, na Dan pomirenja, zatrubite u trubu širom svoje zemlje. ");
INSERT INTO hrv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Tu pedesetu godinu proglasite svetom! Zemljom proglasite oslobađanje svim njezinim stanovnicima. To neka vam bude jubilej, oprosna godina. Neka se svatko vaš vrati na svoju očevinu; neka se svatko vrati k svome rodu! ");
INSERT INTO hrv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ta pedesetogodišnjica neka vam je jubilejska godina: nemojte sijati, nemojte žeti što samo od sebe uzraste niti berite grožđe s neobrezane loze. ");
INSERT INTO hrv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Jer jubilej vam mora biti svet! Hranite se onim što njiva donese od sebe. ");
INSERT INTO hrv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Te jubilejske godine neka se svatko vrati na svoju očevinu. ");
INSERT INTO hrv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Zato, kad prodajete imanje svome sunarodnjaku ili kupujete od svoga sunarodnjaka, nemojte nanositi štete svome bratu! ");
INSERT INTO hrv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Od svoga sunarodnjaka kupuj, odbivši samo broj godina poslije jubileja, a on neka ti proda prema broju proizvodnih godina. ");
INSERT INTO hrv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Što više godina, više i cijenu povisi; što manje godina, neka je i cijena manja. Jer, ono što ti on prodaje jest broj ljetina. ");
INSERT INTO hrv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Neka nitko od vas ne nanosi štete svome sunarodnjaku, nego se boj Boga svoga! Jer ja sam Jahve, Bog vaš. ");
INSERT INTO hrv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Vršite moje zakone i moje naredbe; vjerno ih provodite u djelo pa ćete u sigurnosti živjeti na zemlji. ");
INSERT INTO hrv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Zemlja će davati svoj rod, jest ćete do sitosti i živjet ćete u sigurnosti. ");
INSERT INTO hrv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ako biste rekli: 'Čime ćemo se hraniti te sedme godine kad ne budemo ni sijali ni brali plodova?' ");
INSERT INTO hrv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","evo, blagoslov ću svoj pustiti na vas: šesta godina rodom će roditi za tri godine. ");
INSERT INTO hrv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Kad budete sijali osme godine, hranit ćete se starim prihodom sve do devete godine; dok ne dođe njezin prihod, jest ćete stari.” ");
INSERT INTO hrv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Zemlja se ne smije prodati potpuno, jer zemlja pripada meni, dok ste vi samo stranci i gosti kod mene. ");
INSERT INTO hrv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Zato u svakome kraju gdje imate zemljišne posjede morate dopustiti otkupljivanje zemlje. ");
INSERT INTO hrv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ako tvoj brat zapadne u škripac te moradne prodati dio svoje očevine, neka dođe njegov najbliži izbavitelj i otkupi što je njegov brat prodao. ");
INSERT INTO hrv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ako nema koga da mu ga otkupi, a poslije i sam postane imućan te stekne sredstva da je otkupi, ");
INSERT INTO hrv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","neka prebroji godine od prodaje, isplati kupcu svotu za preostalo vrijeme i vrati se na svoju očevinu. ");
INSERT INTO hrv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ako nema sredstava da je vrati, onda prodano neka ostane u rukama kupca do jubilejske godine. A stupivši u jubilej, neka se vrati na svoju očevinu. ");
INSERT INTO hrv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ako tko proda stojnu kuću u gradu zidom obzidanu, može je otkupiti dokle se ne navrši godina poslije prodaje; otkupni rok neka je, dakle, jedna godina. ");
INSERT INTO hrv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ako je ne otkupi u roku od godine, onda kuća u gradu zidom opasana prelazi potpuno kupcu i njegovim potomcima: ni za jubileja neka se ne vraća. ");
INSERT INTO hrv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ali kuće po selima što nemaju zidova oko sebe neka se smatraju kao posjedi u polju; mogu se otkupljivati. U jubileju kupac mora iz njih izići. ");
INSERT INTO hrv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Kuće koje u levitskim gradovima pripadaju levitima mogu leviti otkupiti u svako vrijeme. ");
INSERT INTO hrv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ako se koji levit ne posluži svojim pravom otkupa, onda će kuća što bude prodana u gradu njegova vlasništva biti za jubileja vraćena. Jer kod Izraelaca kuće u gradovima levita njihovo su vlasništvo. ");
INSERT INTO hrv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Neograđena zemlja oko njihovih gradova ne može se prodati, jer je ona njihovo vlasništvo za sva vremena.” ");
INSERT INTO hrv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Ako tvoj brat zapadne u škripac i ne mogne održavati svoje odnose s tobom, primi ga; i neka s tobom živi kao stranac ili gost. ");
INSERT INTO hrv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ne uzimaj od njega ni lihve ni kamata. Boga se svoga boj, i neka tvoj brat živi s tobom! ");
INSERT INTO hrv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ne uzajmljuj mu novac na kamate niti mu lihvarski davaj svoju hranu. ");
INSERT INTO hrv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ja, Jahve, Bog vaš, izbavio sam vas iz zemlje egipatske da vam dadem zemlju kanaansku i budem vaš Bog. ");
INSERT INTO hrv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Ako li tvoj brat padne u škripac dok je s tobom u urednim odnosima te se moradne tebi prodati, nemoj ga prisiliti da služi kao rob; neka bude kod tebe kao najamnik ili nadničar. ");
INSERT INTO hrv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Neka služi kod tebe do jubilejske godine. ");
INSERT INTO hrv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Onda neka bude slobodan da ode od tebe - i on i njegova djeca s njim; neka ide natrag svome rodu i opet zaposjedne svoju djedovinu. ");
INSERT INTO hrv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","TÓa oni su moji službenici, ja sam ih izbavio iz zemlje egipatske; oni se ne smiju prodavati kao robovi. ");
INSERT INTO hrv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Nemoj s njim grubo postupati! Boga se svoga boj! ");
INSERT INTO hrv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","A robove i ropkinje, budeš li ih htio imati, možete kupiti, i muške i ženske, od naroda koji su oko vas. ");
INSERT INTO hrv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Možete ih kupovati i od pridošlica koji s vama borave; od njihovih obitelji što žive s vama i rođeni su u vašoj zemlji. Takvi mogu postati vašim vlasništvom. ");
INSERT INTO hrv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Njih možete predati u nasljedstvo svojoj djeci da ih zavazda naslijede u baštinu. Prema njima možete postupati kao prema robovima. Ali prema svojoj braći, Izraelcima, nitko ne smije grubo postupati. ");
INSERT INTO hrv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ako se stranac s tobom nastanjen obogati, a tvoj brat, u svojim odnosima prema njemu, zapadne u škripac te se proda strancu koji je s tobom nastanjen ili kojemu god potomku strančeve obitelji, ");
INSERT INTO hrv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","on ima pravo i nakon prodaje biti otkupljen. Neka ga otkupi netko od njegove braće; ");
INSERT INTO hrv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ili neka ga otkupi njegov stric, njegov rođak ili bilo tko od njegove obitelji koji bude od njegove krvi. Ili, ako ima sredstava, neka se sam otkupi. ");
INSERT INTO hrv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Sa svojim kupcem neka proračuna vrijeme od godine kad mu se prodao do jubilejske godine. Cijena za njegovo oslobođenje neka bude prema broju godina. Vrijeme što ga je proveo sa svojim vlasnikom neka se procijeni kao vrijeme jednog najamnika. ");
INSERT INTO hrv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ako ostaje još mnogo godina, neka isplati za svoju otkupninu u omjeru svoje prodajne svote. ");
INSERT INTO hrv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","A ako ostaje samo nekoliko godina do jubilejske godine, neka izračuna pa isplati za svoj otkup prema godinama službe. ");
INSERT INTO hrv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Prema njemu neka bude kao prema najamniku koji se iznajmljuje od godine na godinu. Neka se na tvoje oči s njim ne postupa grubo. ");
INSERT INTO hrv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ne bude li iskupljen ovako, onda i on i njegova djeca s njim neka odu u jubilejskoj godini. ");
INSERT INTO hrv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Jer Izraelci su moji službenici; oni su moji službenici koje sam ja izveo iz zemlje egipatske, ja, Jahve, Bog vaš.” ");
INSERT INTO hrv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Ne pravite sebi kumira; ne podižite sebi ni kipa ni spomen-stupa; ne postavljajte u svojoj zemlji kamenja s likovima da pred njih padate. ");
INSERT INTO hrv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Održavajte moje subote; poštujte moje Svetište - jer ja sam Jahve, Bog vaš.” ");
INSERT INTO hrv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Budete li živjeli prema mojim zakonima, održavali moje zapovijedi i u djelo ih provodili, ");
INSERT INTO hrv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","davat ću vam kiše u pravo vrijeme te će zemlja rađati rodom a stabla po polju donositi plodove. ");
INSERT INTO hrv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Vršidba će vam stizati berbu, a berba stizati sjetvu. Jest ćete kruh svoj do sitosti i u svojoj ćete zemlji živjeti u sigurnosti. ");
INSERT INTO hrv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Zemlji ću dati mir; tako ćete počivati a da vas nitko ne plaši. Štetne ću životinje iz zemlje ukloniti; mač neće prolaziti vašom zemljom. ");
INSERT INTO hrv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","U bijeg ćete nagoniti svoje neprijatelje, a oni će padati pred vama od mača. ");
INSERT INTO hrv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Petorica vas nagonit će u bijeg stotinu njih, a stotina vas nagonit će u bijeg deset tisuća njih. Da, vaši će neprijatelji padati pred vama od mača. ");
INSERT INTO hrv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","K vama ću se okrenuti te vas rodnima činiti i razmnažati. Držat ću svoj Savez s vama. ");
INSERT INTO hrv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Starom ćete se zalihom hraniti; štoviše, trebat će vam zalihe ispražnjavati da mognete sasipati novo žito. ");
INSERT INTO hrv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Među vama ću postaviti svoje Prebivalište i neću vas odbaciti; ");
INSERT INTO hrv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","među vama ću hoditi i bit ću vam Bog, a vi ćete mi biti narod. ");
INSERT INTO hrv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ja, Jahve, Bog vaš, izveo sam vas iz zemlje egipatske da im više ne budete roblje; polomio sam palice vaših jarmova i učinio da hodate uspravno.” ");
INSERT INTO hrv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Ali ako me ne poslušate i u djelo ne provedete sve ove moje zapovijedi; ");
INSERT INTO hrv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ako odbacite moje zakone, pogazite moje naredbe i prekršite moj Savez, ne provodeći u djelo sve moje zapovijedi, ");
INSERT INTO hrv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","evo što ću ja učiniti vama: podvrgnut ću vas strepnji, iznemoglosti i groznici što oči troše a život gase. ");
INSERT INTO hrv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Sjetve ćete svoje uzalud sijati - neprijatelji vaši njima će se hraniti. Ja ću se protiv vas okrenuti, a vaši će vas neprijatelji ametice tući. Oni koji vas mrze gospodarit će nad vama. Bježat ćete i onda kad vas nitko ne bude progonio. ");
INSERT INTO hrv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Pa ako me i unatoč tome ne poslušate, ja ću vas sedmerostruko kažnjavati za vaše grijehe. ");
INSERT INTO hrv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Slomit ću ja vašu drsku silu. Vaša ću nebesa učiniti poput gvožđa, a zemlju vašu poput tuča. ");
INSERT INTO hrv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Uzalud će se trošiti vaša snaga. Zemlja vam više neće davati svoga roda niti će stabla na zemlji donositi svojih plodova. ");
INSERT INTO hrv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Budete li se još i dalje protivili, ne htjednete li me poslušati, sedmerostruko ću još na vama povisiti rane za vaše grijehe. ");
INSERT INTO hrv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Na vas ću pustiti šumsku zvjerad da vas liši djece, blago vam podavi a vas prorijedi tako da vam putovi postanu pusti. ");
INSERT INTO hrv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Ako vas ni to ne popravi nego nastavite življenje koje se meni protivi, ");
INSERT INTO hrv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","onda ću se i ja suprotstaviti vama i sam ću vas još sedmerostruko udariti za vaše grijehe. ");
INSERT INTO hrv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Na vas ću dovesti mač neka se iskali osvetom za Savez. A kad se zbijete u svoje gradove, poslat ću na vas kugu i bit ćete predani u ruke neprijatelju. ");
INSERT INTO hrv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Još kad vam obustavim namicanje kruha, deset žena moći će vam peći kruh u jednoj peći i na mjeru će vam kruh davati. Jest ćete, ali se nećete nasititi. ");
INSERT INTO hrv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Ako me ni tada ne poslušate nego mi se dalje budete suprotstavljali, ");
INSERT INTO hrv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","i ja ću se vama suprotstaviti - sedmerostruko ću vas kazniti za vaše grijehe. ");
INSERT INTO hrv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Jest ćete meso od svojih sinova, jest ćete meso od svojih kćeri. ");
INSERT INTO hrv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Porušit ću vaše idolske uzvišice; oborit ću vaše kadione žrtvenike, zgrnut ću vaša mrtva trupla na trupla vaših kumira i odbacit ću vas. ");
INSERT INTO hrv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Gradove ću vaše pretvoriti u ruševine; svetišta ću vaša opustošiti, vaš ugodni miris neću više mirisati. ");
INSERT INTO hrv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Zemlju ću ja pretvoriti u zgarište tako da će se vaši neprijatelji koji se u njoj nastane zaprepastiti nad njom. ");
INSERT INTO hrv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Vas ću rasijati po narodima; izvući ću protiv vas mač iz korica tako da će vam se zemlja pretvoriti u pustaru a gradovi u ruševine. ");
INSERT INTO hrv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Tada će zemlja namiriti svoje subote za sve vrijeme dok bude pusta i vi budete u zemlji svojih neprijatelja. Otpočinut će tada zemlja i moći će namiriti svoje subote. ");
INSERT INTO hrv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Sve dok bude pusta, imat će počinak koji nije imala za vaših subota dok ste vi u njoj stanovali. ");
INSERT INTO hrv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","A onima od vas koji na životu ostanu po zemljama svojih neprijatelja, njima ću strah u srce utjerati. U bijeg će ih nagoniti šuštaj lista što zatrepti. Bježat će kao što se bježi od mača; padat će, iako ih nitko neće progoniti. ");
INSERT INTO hrv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Spoticat će se jedan o drugoga kao kad se bježi ispred mača, premda ih nitko neće progoniti. Nećete se održati pred svojim neprijateljima; ");
INSERT INTO hrv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","izginut ćete među narodima - proždrijet će vas zemlja vaših neprijatelja. ");
INSERT INTO hrv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","A koji od vas prežive venut će u zemljama svojih neprijatelja zbog svojih opačina; venut će i zbog opačina svojih otaca. ");
INSERT INTO hrv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Priznat će tada svoju opačinu i opačinu svojih otaca što su je protiv mene počinili izdajom, što su mi se protivili. ");
INSERT INTO hrv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","I ja sam sa morao suprotstaviti njima i odvesti ih u zemlju njihovih neprijatelja.” “Onda će se napokon njihovo tvrdokorno srce poniziti; ispaštat će oni svoju krivnju. ");
INSERT INTO hrv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Tada ću se ja sjetiti svoga Saveza s Jakovom i svoga Saveza s Izakom; sjetit ću se svoga Saveza s Abrahamom - zemlje ću se sjetiti. ");
INSERT INTO hrv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Zemlja će, ostavljena od njih, namiriti svoje subote kad ostane pusta zbog njih. A oni će ispaštati svoju krivnju što su odbacili moje zapovijedi; što su prezreli moje zakone. ");
INSERT INTO hrv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ali ni onda dok budu u zemlji svojih neprijatelja, neću ih zabaciti niti ću ih prezreti tako da ih posve uništim i da prekršim svoj Savez s njima. TÓa ja sam Jahve, Bog njihov. ");
INSERT INTO hrv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Radi njih sjetit ću se Saveza s njihovim precima koje sam izveo iz zemlje egipatske naočigled naroda da budem njihov Bog, ja Jahve.” ");
INSERT INTO hrv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","To su odredbe, uredbe i zakoni koje je Jahve uglavio između sebe i Izraelaca po Mojsiju na Sinajskome brdu. ");
INSERT INTO hrv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Govori Izraelcima i reci im: 'Ako tko zaželi podmiriti Jahvi zavjet što vrijedi koliko čovjek, ");
INSERT INTO hrv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","neka ti je mjerilo: muškarca od dvadeset do šezdeset godina starosti procijeni pedeset šekela u srebru, prema hramskom šekelu, ");
INSERT INTO hrv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","a žensku procijeni trideset šekela. ");
INSERT INTO hrv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","A za dob od pet do dvadeset godina neka tvoja procjena bude: za muškarca dvadeset šekela, a za žensku deset šekela. ");
INSERT INTO hrv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Je li dob od jednoga mjeseca do pet godina, neka ti je procjena: za muško pet šekela u srebru, a procjena za žensko tri šekela u srebru. ");
INSERT INTO hrv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Bude li u starosti od šezdeset godina ili više, neka ti je procjena: za muškarca petnaest šekela, a za žensku deset šekela. ");
INSERT INTO hrv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ali ako je tko siromašan te ne može platiti svoju cijenu, neka ga dovedu pred svećenika i neka ga svećenik procijeni. Ali neka svećenik procijeni prema onome što zavjetovalac može dati. ");
INSERT INTO hrv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ako zavjetovani prinos bude od životinja koje se mogu Jahvi prinositi, svaki takav prinos Jahvi bit će posvećena stvar. ");
INSERT INTO hrv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Neka se ne nadomješta niti zamjenjuje za što drugo - bilo dobro za loše, bilo loše za dobro. Ako li se napravi zamjena jednoga živinčeta za drugo, onda će i zavjetovano i ono koje ga je zamijenilo biti posvećena stvar. ");
INSERT INTO hrv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Bude li zavjetovani prinos od nečiste životinje koja se ne može Jahvi prinositi, neka se takvo živinče dovede k svećeniku ");
INSERT INTO hrv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","pa neka ga on procijeni. Bilo skupo, bilo jeftino, kako svećenik procijeni, neka tako bude. ");
INSERT INTO hrv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Zaželi li ga tko otkupiti, neka doda njegovoj procjeni jednu petinu. ");
INSERT INTO hrv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Ako tko posveti svoju kuću zavjetovavši je Jahvi, neka svećenik procijeni da li je dobra ili loša. Kako svećenik prosudi, neka tako ostane. ");
INSERT INTO hrv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ako onaj koji je svoju kuću zavjetovao zaželi da je otkupi, neka dometne jednu petinu svoti na koju je procijenjena pa neka bude njegova. ");
INSERT INTO hrv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Ako tko zavjetuje Jahvi dio zemljišta od svoga vlasništva, procijeni ga prema njegovu usjevu: za jedan homer ječmena sjemena pedeset šekela u srebru. ");
INSERT INTO hrv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Zavjetuje li zemljište za jubilejske godine, neka ostane prema ovoj procjeni. ");
INSERT INTO hrv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ali ako zemljište zavjetuje poslije jubilejske godine, neka svećenik proračuna cijenu prema godinama što preostaju do jubilejske godine i prema tome smanji procjenu. ");
INSERT INTO hrv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ako onaj tko je zemljište zavjetovao zaželi da ga otkupi, neka doda jednu petinu svoti na koju je procijenjeno pa neka mu ostane. ");
INSERT INTO hrv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ako zemljište ne otkupi nego ga proda drugome, ne može se više otkupiti. ");
INSERT INTO hrv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kad zemljište bude oslobođeno u jubilejskoj godini, neka se posveti Jahvi kao zavjetovano zemljište i postane svećenikov posjed. ");
INSERT INTO hrv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Zavjetuje li tko Jahvi kupljeno zemljište koje nije dio njegove očevine, ");
INSERT INTO hrv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","neka mu svećenik proračuna razmjernu procjenu do jubilejske godine. I toga istog dana neka isplati iznos kao stvar posvećenu Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","U jubilejskoj godini zemljište se ima vratiti onome od koga je kupljeno - kome pripada zemljišno vlasništvo. ");
INSERT INTO hrv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Svaka procjena neka se vrši prema hramskom šekelu: dvadeset gera jedan šekel. ");
INSERT INTO hrv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Ali neka nitko ne zavjetuje prvinu od stoke. TÓa prvina ionako pripada Jahvi - Jahvina je, pa bila od sitnoga bila od krupnoga blaga. ");
INSERT INTO hrv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Bude li od nečiste stoke, može se otkupiti prema procjeni, dometnuvši petinu cijene. Ako se ne otkupi, neka se prema procjeni proda. ");
INSERT INTO hrv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ali ništa od 'herema', od onog što je Jahvi izručeno, bio to čovjek ili živinče ili njegovo baštinjeno zemljište, ništa što je tko Jahvi zavjetom posvetio, ne može se niti prodati niti otkupiti. Svaka zavjetom posvećena stvar najveća je Jahvina svetinja. ");
INSERT INTO hrv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Nijedno ljudsko biće koje bude 'heremom' - prokletstvom - udareno ne smije se otkupljivati: mora se smaknuti. ");
INSERT INTO hrv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Svaka desetina sa zemljišta, bilo od poljskih usjeva bilo od plodova sa stabala, pripada Jahvi; to je Jahvi posvećeno. ");
INSERT INTO hrv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ako bi tko htio otkupiti koji dio svoje desetine, mora tome dodati jednu petinu cijene. ");
INSERT INTO hrv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Svaka desetina od krupnoga i sitnoga blaga, to jest svako deseto od svega što prolazi ispod pastirskog štapa, neka bude posvećeno Jahvi. ");
INSERT INTO hrv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Neka se ne gleda je li dobro ili rđavo; i neka se ne zamjenjuje. Ako se ipak zamijeni, neka je onda i jedno i drugo posvećeno i ne smije se otkupljivati.'” ");
INSERT INTO hrv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","To su zapovijedi koje je Jahve izdao Mojsiju za Izraelce na Sinajskome brdu. ");
INSERT INTO hrv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","U Sinajskoj pustinji, u Šatoru sastanka, reče Jahve Mojsiju prvoga dana drugoga mjeseca, druge godine po izlasku iz zemlje egipatske: ");
INSERT INTO hrv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Obavite popis sve zajednice izraelske po rodovima i porodicama, navodeći imena svih muškaraca, glavu po glavu. ");
INSERT INTO hrv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Od dvadeset godina naviše, za borbu sposobne u Izraelu, ti i Aron pobilježite prema njihovim jedinicama. ");
INSERT INTO hrv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Neka s vama bude po jedan čovjek od svakoga plemena, glavari svoga pradjedovskog doma. ");
INSERT INTO hrv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ovo su imena ljudi koji će vam pomagati: Elisur, sin Šedeurov, za pleme Rubenovo; ");
INSERT INTO hrv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Šelumiel, sin Surišadajev, za pleme Šimunovo; ");
INSERT INTO hrv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Nahšon, sin Aminadabov, za pleme Judino; ");
INSERT INTO hrv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Netanel, sin Suarov, za pleme Jisakarovo; ");
INSERT INTO hrv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Eliab, sin Helonov, za pleme Zebulunovo. ");
INSERT INTO hrv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Za Josipove sinove: Elišama, sin Amihudov, za pleme Efrajimovo; Gamliel, sin Pedahsurov, za pleme Manašeovo; ");
INSERT INTO hrv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Abidan, sin Gidonijev, za pleme Benjaminovo; ");
INSERT INTO hrv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ahiezer, sin Amišadajev, za pleme Danovo; ");
INSERT INTO hrv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Pagiel, sin Okranov, za pleme Ašerovo; ");
INSERT INTO hrv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Elijasaf, sin Deuelov, za pleme Gadovo; ");
INSERT INTO hrv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Ahira, sin Enanov, za pleme Naftalijevo.” ");
INSERT INTO hrv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","To bijahu sazivači zajednice, knezovi pradjedovskih plemena i glavari rodova izraelskih. ");
INSERT INTO hrv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mojsije i Aron onda uzmu one ljude što su po imenu bili određeni ");
INSERT INTO hrv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","te prvoga dana drugoga mjeseca sazovu svu zajednicu. Tada se u popis prema rodovima i porodicama po redu unosio broj osoba starijih od dvadeset godina. ");
INSERT INTO hrv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Kako je Jahve naredio Mojsiju, tako ih je on pobilježio u Sinajskoj pustinji. ");
INSERT INTO hrv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Kad se utvrdi potomstvo Rubena, Izraelova prvorođenca, prema njegovim rodovima i porodicama, pribilježiše, glavu po glavu, imena svih muškaraca od dvadeset godina naviše, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Popisanih od Rubenova plemena bilo je četrdeset i šest tisuća i pet stotina. ");
INSERT INTO hrv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Bili su popisani Šimunovi potomci prema njihovim rodovima i porodicama: pribilježiše se, glava po glava, imena svih muškaraca od dvadeset godina naviše, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Popisanih od Šimunova plemena bilo je pedeset i devet tisuća i tri stotine. ");
INSERT INTO hrv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kad se utvrdi potomstvo sinova Gadovih prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Popisanih od Gadova plemena bilo je četrdeset i pet tisuća i šest stotina i pedeset. ");
INSERT INTO hrv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kad se utvrdi potomstvo sinova Judinih prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Popisanih od Judina plemena bilo je sedamdeset i četiri tisuće i šest stotina. ");
INSERT INTO hrv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kad se utvrdi potomstvo sinova Jisakarovih prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Popisanih od Jisakarova plemena bilo je pedeset i četiri tisuće i četiri stotine. ");
INSERT INTO hrv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kad se utvrdi potomstvo sinova Zebulunovih prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Popisanih od Zebulunova plemena bilo je pedeset i sedam tisuća i četiri stotine. ");
INSERT INTO hrv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Josipovi sinovi: Kad se utvrdi potomstvo sinova Efrajimovih, prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Popisanih od Efrajimova plemena bilo je četrdeset tisuća i pet stotina. ");
INSERT INTO hrv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kad se utvrdi potomstvo sinova Manašeovih, prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Popisanih od Manašeova plemena bilo je trideset i dvije tisuće i dvjesta. ");
INSERT INTO hrv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kad se utvrdi potomstvo sinova Benjaminovih, prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Popisanih od Benjaminova plemena bilo je trideset i pet tisuća i četiri stotine. ");
INSERT INTO hrv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kad se utvrdi potomstvo sinova Danovih, prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Popisanih od Danova plemena bilo je šezdeset i dvije tisuće i sedam stotina. ");
INSERT INTO hrv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kad se utvrdi potomstvo sinova Ašerovih, prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Popisanih od Ašerova plemena bila je četrdeset i jedna tisuća i pet stotina. ");
INSERT INTO hrv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kad se utvrdi potomstvo sinova Naftalijevih, prema njihovim rodovima i porodicama, pribilježiše se, glava po glava, imena onih od dvadeset godina i više, svih za borbu sposobnih. ");
INSERT INTO hrv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Popisanih od Naftalijeva plemena bilo je pedeset i tri tisuće i četiri stotine. ");
INSERT INTO hrv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","To su oni koje popisaše Mojsije i Aron sa dvanaest knezova izraelskih, po jedan na svaki pradjedovski dom. ");
INSERT INTO hrv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Bili su popisani svi Izraelci, prema pradjedovskim domovima, od dvadeset godina i više, svi za borbu sposobni u Izraelu. ");
INSERT INTO hrv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Bilo je, dakle, svih popisanih šest stotina i tri tisuće i pet stotina i pedeset. ");
INSERT INTO hrv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Među te nisu se ubrojili Levijevci prema svojem pradjedovskom plemenu. ");
INSERT INTO hrv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Jahve je, naime, rekao Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Nipošto nemoj popisivati Levijeva plemena niti ga unosi u popis Izraelaca. ");
INSERT INTO hrv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Nego ti sam odredi Levijevce za službu u Prebivalištu svjedočanstva; za sav njegov namještaj i sve što na nj spada; neka oni nose Prebivalište i sav njegov namještaj; neka oni u njemu poslužuju i oko njega tabore. ");
INSERT INTO hrv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kad se Prebivalište mora premještati, neka ga Levijevci rastave; a kad se s Prebivalištem treba utaboriti, neka ga Levijevci opet podignu. Svjetovnjak koji bi mu se primakao neka se pogubi. ");
INSERT INTO hrv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Neka Izraelci logoruju svatko u svome taboru; svatko kod svoje zastave, po četama. ");
INSERT INTO hrv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Levijevci neka borave oko Prebivališta svjedočanstva, da se gnjev ne obori na izraelsku zajednicu. Neka tako Levijevci stražu straže oko Prebivališta svjedočanstva.” ");
INSERT INTO hrv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Izraelci učine kako je Jahve Mojsiju naredio. U svemu tako urade. ");
INSERT INTO hrv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Jahve reče Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Neka Izraelci logoruju svatko kod svoje zastave, pod znakovima svojih pradjedovskih domova; neka se utabore oko Šatora sastanka, ali malo podalje. ");
INSERT INTO hrv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Sprijeda, s istočne strane, zastava Judina tabora, prema njihovim četama. Glavar je Judinih potomaka Nahšon, sin Aminadabov. ");
INSERT INTO hrv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Njegova vojska broji sedamdeset i četiri tisuće i šest stotina popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Do njega neka taboruje Jisakarovo pleme. Glavar je Jisakarovih potomaka Netanel, sin Suarov. ");
INSERT INTO hrv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Njegova vojska broji pedeset četiri tisuće i četiri stotine popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Onda pleme Zebulunovo. Glavar je Zebulunovih potomaka Eliab, sin Helonov. ");
INSERT INTO hrv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Njegova vojska broji pedeset i sedam tisuća i četiri stotine popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Prema njihovim četama, svih je upisanih u Judinu taboru sto osamdeset i šest tisuća i četiri stotine. Neka oni prvi stupaju! ");
INSERT INTO hrv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","S juga je zastava tabora Rubenova, prema njihovim četama. Glavar je Rubenovih potomaka Elisur, sin Šedeurov. ");
INSERT INTO hrv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Njegova vojska broji četrdeset i šest tisuća i pet stotina popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Do njega neka taboruje pleme Šimunovo. Glavar je Šimunovih potomaka Šelumiel, sin Surišadajev. ");
INSERT INTO hrv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Njegova vojska broji pedeset i devet tisuća i tri stotine popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Onda pleme Gadovo. Glavar je Gadovih potomaka Elijasaf, sin Deuelov. ");
INSERT INTO hrv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Njegova vojska broji četrdeset i pet tisuća šest stotina i pedeset popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Prema njihovim četama, svih je upisanih u taboru Rubenovu sto pedeset i jedna tisuća četiri stotine i pedeset. Neka oni stupaju drugi! ");
INSERT INTO hrv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Potom neka ide Šator sastanka, tako da tabor levitski bude usred drugih tabora. Kako taboruju, onako neka i stupaju: svatko pod svojom zastavom. ");
INSERT INTO hrv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Sa zapada, zastava tabora Efrajimova, prema njihovim četama. Glavar je Efrajimovih potomaka Elišama, sin Amihudov. ");
INSERT INTO hrv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Njegova vojska broji četrdeset tisuća i pet stotina popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Do njega je pleme Manašeovo. Glavar je Manašeovih potomaka Gamliel, sin Pedahsurov. ");
INSERT INTO hrv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Njegova vojska broji trideset i dvije tisuće i dvjesta popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Onda je pleme Benjaminovo. Glavar je potomaka Benjaminovih Abidan, sin Gidonijev. ");
INSERT INTO hrv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Njegova vojska broji trideset i pet tisuća i četiri stotine popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Prema njihovim četama, svih je upisanih u Efrajimovu taboru sto i osam tisuća i sto. Oni neka stupaju treći! ");
INSERT INTO hrv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Sa sjevera, zastava tabora Danova, prema njihovim četama. Glavar je Danovih potomaka Ahiezer, sin Amišadajev. ");
INSERT INTO hrv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Njegova vojska broji šezdeset i dvije tisuće i sedam stotina popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Do njega neka se utabori pleme Ašerovo. Glavar je Ašerovih potomaka Pagiel, sin Okranov. ");
INSERT INTO hrv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Njegova vojska broji četrdeset i jednu tisuću i pet stotina popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Onda pleme Naftalijevo. Glavar je Naftalijevih potomaka Ahira, sin Enanov. ");
INSERT INTO hrv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Njegova vojska broji pedeset i tri tisuće i četiri stotine popisanih. ");
INSERT INTO hrv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Svih je popisanih u taboru Danovu sto pedeset i sedam tisuća i šest stotina. Neka oni stupaju posljednji pod svojim zastavama.” ");
INSERT INTO hrv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","To su popisani Izraelci prema pradjedovskim domovima. Svih je upisanih u taborima, po njihovim četama, šest stotina i tri tisuće i pet stotina i pedeset. ");
INSERT INTO hrv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Levijevci nisu bili upisivani s Izraelcima, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","U svemu su Izraelci učinili kako je Jahve naredio Mojsiju. Tako su taborovali pod svojim zastavama i tako išli, svatko prema svom rodu i porodici. ");
INSERT INTO hrv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ovo je potomstvo Aronovo i Mojsijevo iz vremena kad je Jahve Mojsiju govorio na Sinajskom brdu. ");
INSERT INTO hrv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ovo su bila imena Aronovih sinova: prvorođenac Nadab, zatim Abihu, Eleazar i Itamar. ");
INSERT INTO hrv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","To su imena Aronovih sinova, svećenika pomazanih, za svećeništvo posvećenih. ");
INSERT INTO hrv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ali Nadab i Abihu umriješe pred Jahvom kad su u Sinajskoj pustinji pred njim prinosili neposvećenu vatru. Kako nisu imali sinova, to su Eleazar i Itamar služili kao svećenici u nazočnosti svoga oca Arona. ");
INSERT INTO hrv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Dozovi pleme Levijevo neka stane pred svećenika Arona. Neka mu poslužuju; ");
INSERT INTO hrv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","neka vrše njegovu dužnost i dužnost sve zajednice pred Šatorom sastanka, služeći Prebivalištu. ");
INSERT INTO hrv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Neka se brinu za sav namještaj u Šatoru sastanka, za dužnost sinova izraelovih, i obavljaju službu u Prebivalištu. ");
INSERT INTO hrv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Podaj levite Aronu i njegovim sinovima. Neka mu ih Izraelci potpuno daruju. ");
INSERT INTO hrv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Arona i njegove sinove postavi da vrše svoju svećeničku službu. A svjetovnjak koji bi se tome približio neka se pogubi.” ");
INSERT INTO hrv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ja, evo, uzimam Levijevce između Izraelaca namjesto svih prvorođenaca - onih koji otvaraju materinju utrobu kod Izraelaca. Moji su, dakle, Levijevci! ");
INSERT INTO hrv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Meni, naime, pripada svaki prvorođenac. Onoga dana kad sam pobio sve prvence u zemlji egipatskoj, sebi sam posvetio sve prvorođence u Izraelu - i od ljudi i od stoke. Oni su moji. Ja sam Jahve.” ");
INSERT INTO hrv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Jahve reče Mojsiju u Sinajskoj pustinji: ");
INSERT INTO hrv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Popiši Levijevce po njihovim porodicama i rodovima; popiši sve muškarce od jednoga mjeseca i više.” ");
INSERT INTO hrv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Na zapovijed Jahvinu Mojsije ih popisa, kako mu je bilo naređeno. ");
INSERT INTO hrv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ovo su poimenice bili sinovi Levijevi: Geršon, Kehat i Merari. ");
INSERT INTO hrv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","A ovo su imena Geršonovih sinova po njihovim rodovima: Libni i Šimi. ");
INSERT INTO hrv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","A sinovi su Kehatovi po svojim rodovima: Amram, Jishar, Hebron i Uziel. ");
INSERT INTO hrv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Sinovi su Merarijevi po svojim rodovima: Mahli i Muši. To su Levijevi rodovi po svojim porodicama. ");
INSERT INTO hrv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Od Geršona lozu vuče rod Libnijev i rod Šimijev. To su rodovi Geršonovaca. ");
INSERT INTO hrv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Njih je u popisu svih muškaraca od jednoga mjeseca naviše ubilježeno sedam tisuća i pet stotina. ");
INSERT INTO hrv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Rodovi Geršonovaca taborovali su za Prebivalištem prema zapadu. ");
INSERT INTO hrv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Glava porodice Geršonovaca bijaše Elijasaf, sin Laelov. ");
INSERT INTO hrv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Geršonovci su se u Šatoru sastanka brinuli za Prebivalište, za Šator i njegov krov, za zavjese na ulazu u Šator sastanka; ");
INSERT INTO hrv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","onda za dvorišne zavjese, za zavjesu na ulazu u dvorište što je oko Prebivališta i žrtvenika, za njihova užeta i za sve što spada na tu službu. ");
INSERT INTO hrv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Od Kehata potječe rod Amramov, rod Jisharov, rod Hebronov i rod Uzielov. To su rodovi Kehatovaca. ");
INSERT INTO hrv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Kad se popisaše svi muškarci od jednoga mjeseca naviše, bilo ih je osam tisuća i šest stotina. Oni su se brinuli za Svetište. ");
INSERT INTO hrv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Rodovi Kehatovaca taborovali su s južne strane Prebivališta. ");
INSERT INTO hrv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Glava rodova u domu Kehatovu bijaše Elisafan, sin Uzielov. ");
INSERT INTO hrv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Oni su se brinuli za Kovčeg, stol, svijećnjak, žrtvenik i sveti pribor kojim su se služili i, konačno, za zavjesu i za sve što joj pripada. ");
INSERT INTO hrv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Vrhovni poglavar levita bio je Eleazar, sin svećenika Arona. On je vršio nadzor nad onima koji su se brinuli za Svetište. ");
INSERT INTO hrv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Od Merarija potječe rod Mahlijev i rod Mušijev. To su Merarijevi rodovi. ");
INSERT INTO hrv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Njih je u popisu svih muškaraca od jednoga mjeseca i više ubilježeno šest tisuća i dvije stotine. ");
INSERT INTO hrv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Glava rodova u domu Merarijevu bijaše Suriel, sin Abihajilov. Oni su taborovali sa sjeverne strane Prebivališta. ");
INSERT INTO hrv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merarijevci su se brinuli za trenice Prebivališta, za njegove priječnice, za stupce i njihova podnožja, za sav njegov pribor i za sve što spada na njegovu službu. ");
INSERT INTO hrv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Povrh toga, za stupove uokolo predvorja, njihova podnožja, kočiće i užeta. ");
INSERT INTO hrv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Pred Prebivalištem prema istoku, pred Šatorom sastanka s istočne strane, utaborivali se Mojsije, Aron i njihovi sinovi, kojima je u ime Izraelaca bila povjerena služba u Svetištu. Svjetovnjak koji bi se približio imao se pogubiti. ");
INSERT INTO hrv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Svih popisanih Levijevaca od jednoga mjeseca naviše, koje je na Jahvinu zapovijed po njihovim rodovima popisao Mojsije i Aron, bijaše dvadeset i dvije tisuće. ");
INSERT INTO hrv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Jahve rekne Mojsiju: “Popiši sve muške prvorođence izraelske od jednoga mjeseca naviše te načini popis njihovih imena. ");
INSERT INTO hrv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","I levite dodijeli meni - ja sam Jahve - namjesto svih prvorođenaca izraelskih, a stoku levitsku namjesto sve prvenčadi stoke izraelske.” ");
INSERT INTO hrv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Tako Mojsije popiše sve prvorođence izraelske, kako mu je Jahve naredio. ");
INSERT INTO hrv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Svih muških prvorođenaca od jednoga mjeseca naviše bijaše u popisu imena dvadeset i dvije tisuće i dvije stotine sedamdeset i tri. ");
INSERT INTO hrv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Tada Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Uzmi levite namjesto svih prvorođenaca izraelskih, a stoku levitsku namjesto stoke njihove; leviti neka budu moji. Ja sam Jahve. ");
INSERT INTO hrv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A za otkupninu dvjesta sedamdeset i triju izraelskih prvorođenaca što ih je više nego levita, ");
INSERT INTO hrv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","uzmi pet šekela po glavi, uzmi ih prema hramskom šekelu: dvadeset gera - jedan šekel. ");
INSERT INTO hrv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Onda podaj taj novac Aronu i njegovim sinovima za otkupninu onih kojih je odviše.” ");
INSERT INTO hrv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Tako Mojsije primi taj novac kao otkupninu za prvorođence koji su nadilazili broj onih koje su leviti otkupili. ");
INSERT INTO hrv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Od izraelskih je prvorođenaca primio u srebru tisuću trista šezdeset i pet šekela hramske mjere. ");
INSERT INTO hrv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Po nalogu Jahvinu Mojsije predade novac te otkupnine Aronu i njegovim sinovima, kako je Jahve Mojsiju naredio. ");
INSERT INTO hrv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Jahve reče Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Izdvojite između sinova Levijevih glavare Kehatovih sinova po rodovima i porodicama njihovim: ");
INSERT INTO hrv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","od trideset godina naviše, sve do pedeset godina - sve koji mogu ući u red da vrše službe u Šatoru sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","A služba je Kehatovih sinova u Šatoru sastanka: briga za svetinje nad svetinjama. ");
INSERT INTO hrv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kad se tabor diže na put, neka uđu Aron i njegovi sinovi te skinu zaštitnu zavjesu i njom pokriju Kovčeg svjedočanstva. ");
INSERT INTO hrv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Neka onda na nj stave pokrivalo od fine kože, a po njemu neka razastru platno, potpuno ljubičasto. Potom neka Kovčegu namjeste motke. ");
INSERT INTO hrv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Po stolu prinošenja neka prostru ljubičasto platno. Onda neka na nj stave zdjele, žlice, krčage i vrčeve za ljevanice. Kruh neprekidnog prinošenja neka također bude na njemu. ");
INSERT INTO hrv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","To neka prekriju tamnocrvenim platnom, a preko njega neka prebace pokrivalo od fine kože. Potom neka stolu namjeste motke. ");
INSERT INTO hrv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Neka zatim uzmu ljubičasto platno i pokriju svijećnjak za svjetlo i njegove svjetiljke, njegove usekače, njegove lugare i sve posude za ulje kojima se ono poslužuje. ");
INSERT INTO hrv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Neka ga stave sa svim njegovim priborom na pokrivalo od fine kože pa polože na nosiljku. ");
INSERT INTO hrv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Po zlatnom žrtveniku neka razastru ljubičasto platno i prekriju ga pokrivalom od fine kože. Potom neka mu namjeste motke. ");
INSERT INTO hrv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Neka sad uzmu sav pribor što se upotrebljava za službu u Svetištu pa ga stave na ljubičasto platno i onda prekriju pokrivačem od fine kože. Zatim neka sve to polože na nosiljku. ");
INSERT INTO hrv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Neka pometu pepeo sa žrtvenika i po njemu razastru crveno platno. ");
INSERT INTO hrv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Na nj neka postave sav pribor što se upotrebljava za službu: kadionike, viljuške, lopatice i zdjele - sve posuđe za žrtvenik. Po njemu onda neka razastru pokrivalo od fine kože. Zatim neka namjeste motke. ");
INSERT INTO hrv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Pošto Aron i njegovi sinovi završe pokrivanje Svetišta i svega svetog posuđa, u času kad imadne tabor krenuti na put, neka dođu potomci Kehatovi da to ponesu. No svetih se predmeta ne smiju doticati da ne poginu. To je dužnost Kehatovih potomaka u Šatoru sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","A Eleazar, sin svećenika Arona, neka se brine za ulje svijećnjaka, za mirisni kad, za trajnu prinosnicu i za ulje pomazanja; neka se brine za sve Prebivalište, za sve što je u njemu - za Svetište i njegovo posuđe.” ");
INSERT INTO hrv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Jahve reče Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Ne dopustite da nestane pleme rodova Kehatovih između levita. ");
INSERT INTO hrv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ovako postupajte s njima, da žive i ne izginu primičući se najvećim svetinjama: neka dođu Aron i njegovi sinovi da postave svakoga od njih na njegovu službu i uz njegovu dužnost. ");
INSERT INTO hrv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Oni neka ne ulaze ni da začas pogledaju Svetište da ne bi poginuli.” ");
INSERT INTO hrv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Popiši i Geršonove sinove po njihovim porodicama i njihovim rodovima, od trideset godina naviše, sve do pedesete godine; ");
INSERT INTO hrv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","popiši ih sve koji mogu ići u red da vrše službu u Šatoru sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","A ovo je služba rodova Geršonovaca pri radu i prenošenju: ");
INSERT INTO hrv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","neka nose zavjese Prebivališta, Šator sastanka s njegovim krovom, pokrivalo od fine kože što je povrh njega, i zavjesu na ulazu u Šator sastanka; ");
INSERT INTO hrv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","onda, dvorišne zavjese, zavjesu s vrata na ulazu u predvorje što opkoljuje Prebivalište i žrtvenik, konopce i sav pribor za njihovu službu; što god treba oko tih stvari raditi, neka učine. ");
INSERT INTO hrv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Neka Geršonovci obavljaju sve svoje dužnosti - sve što imaju nositi i sve što imaju raditi - po nalogu Arona i njegovih sinova. Njihovoj brizi povjerite sve što treba da nose. ");
INSERT INTO hrv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","To je služba rodova Geršonovaca u Šatoru sastanka. Njihova služba neka bude pod vodstvom Itamara, sina svećenika Arona.” ");
INSERT INTO hrv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Sinove Merarijeve popiši po rodovima i porodicama njihovim. ");
INSERT INTO hrv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Popiši ih od trideset godina naviše, sve do pedeset godina, koji mogu ući u red da vrše službu u Šatoru sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Za sve njihove službe u Šatoru sastanka dužnost im je da nose trenice za Prebivalište, njegove priječnice, njegove stupce i njegova podnožja; ");
INSERT INTO hrv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","stupce što okružuju predvorje, njihova podnožja, njihove kočiće, njihove konopce, sa svim priborom za njihovu službu. Poimenično popišite predmete što su im povjereni da ih nose. ");
INSERT INTO hrv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","To je služba rodova Merarijevaca u svemu što imaju činiti u Šatoru sastanka pod vodstvom Itamara, sina svećenika Arona.” ");
INSERT INTO hrv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mojsije, Aron i glavari zajednice popisali su Kehatove sinove po njihovim rodovima i porodicama - ");
INSERT INTO hrv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","sve koji mogu ući u red da vrše službu u Šatoru sastanka, od trideset godina naviše, sve do pedeset godina. ");
INSERT INTO hrv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","I popisanih po njihovim rodovima bijaše dvije tisuće sedam stotina i pedeset. ");
INSERT INTO hrv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","To je popis rodova Kehatovaca, svih koji su služili u Šatoru sastanka, a koje popisa Mojsije i Aron na zapovijed što je Jahve dade Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Popisanih sinova Geršonovih po njihovim rodovima i porodicama, ");
INSERT INTO hrv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","od trideset godina naviše, sve do pedeset godina, svih koji mogu ući u red da vrše službu u Šatoru sastanka - ");
INSERT INTO hrv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","popisanih, dakle, po njihovim rodovima i porodicama bijaše dvije tisuće šest stotina i pedeset. ");
INSERT INTO hrv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","To je popis rodova Geršonovaca, svih koji su služili u Šatoru sastanka, a koje popisa Mojsije i Aron na Jahvinu zapovijed. ");
INSERT INTO hrv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Popis rodova Merarijevih sinova po njihovim rodovima i porodicama, ");
INSERT INTO hrv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","od trideset godina naviše, sve do pedeset godina, svih koji mogu ući u red da vrše službu u Šatoru sastanka - ");
INSERT INTO hrv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","popisanih, dakle, po njihovim rodovima bijaše tri tisuće dvjesta. ");
INSERT INTO hrv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","To je popis Merarijevaca što su ga sastavili Mojsije i Aron na zapovijed koju je Jahve dao Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Svih, dakle, popisanih levita koje su popisali Mojsije, Aron i glavari izraelski po njihovim rodovima i porodicama, od trideset godina naviše do pedeset godina - ");
INSERT INTO hrv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","svih koji su ušli u službu posluživanja i službu prenošenja u Šatoru sastanka - ");
INSERT INTO hrv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","bilo je osam tisuća pet stotina i osamdeset. ");
INSERT INTO hrv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Na zapovijed koju je Jahve dao Mojsiju svakoga su unijeli u popis prema onom u čemu je služio i što je prenosio. Popisali su ih kako je Jahve zapovjedio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Naredi Izraelcima da iz tabora odstrane svakoga gubavca, svakoga koji imadne izljev i svakoga koji se onečisti mrtvim tijelom. ");
INSERT INTO hrv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Odstranite i muške i ženske! Izvan tabora ih istjerajte da ne onečiste svoje tabore u kojima ja boravim među njima.” ");
INSERT INTO hrv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Izraelci tako učine: istjeraju ih iz tabora. Kako je Jahve rekao Mojsiju, tako Izraelci učine. ");
INSERT INTO hrv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Kaži Izraelcima: Kad koji čovjek ili žena počini bilo kakav grijeh na štetu čovjeka ogriješivši se protiv Jahve, i osjeti se krivim, ");
INSERT INTO hrv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","neka prizna počinjeni grijeh, nadoknadi štetu što bolje može te još doda tome petinu i dadne onome kome je nanio nepravdu. ");
INSERT INTO hrv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ako čovjek ne bi imao bližeg rođaka kome bi se nadoknada mogla uručiti, dužna nadoknada pripada Jahvi za svećenika, ne računajući u to pomirbenoga ovna kojim će svećenik izvršiti nad krivcem obred pomirenja. ");
INSERT INTO hrv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","I svaka podizanica od svih posvećenih stvari što ih Izraelci svećeniku donose njemu pripada. ");
INSERT INTO hrv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Svakome idu stvari koje je posvetio; i neka svećeniku bude ono što njemu tko dadne.” ");
INSERT INTO hrv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Govori Izraelcima i reci im: Ako nekome žena pođe stranputicom te mu se iznevjeri ");
INSERT INTO hrv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","i netko s njom legne, ali to ostane sakriveno očima njezina muža i žena ostane neotkrivena iako se oskvrnula te protiv nje ne bude svjedoka budući da u činu nije bila uhvaćena - ");
INSERT INTO hrv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","i sad muža obuzme duh ljubomore i on postane ljubomoran na svoju ženu koja se oskvrnula; ili ako ga spopadne duh ljubomore te postane ljubomoran na svoju ženu a da se ona nije oskvrnula - ");
INSERT INTO hrv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","neka taj muž dovede svoju ženu svećeniku. Neka za nju donese prinos: desetinu efe ječmenog brašna. Neka po njemu ne polijeva ulja niti na nj stavlja tamjana, jer to je prinosnica za ljubomoru, spomen-prinosnica da podsjeti na grijeh. ");
INSERT INTO hrv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Neka svećenik povede tu ženu i postavi je pred Jahvu. ");
INSERT INTO hrv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Sad neka svećenik uzme posvećene vode u kakvu zemljanu posudu i, uzevši prašine što je na podu Prebivališta, neka je svećenik ubaci u vodu. ");
INSERT INTO hrv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Pošto je svećenik postavio ženu pred Jahvu, neka joj otkrije glavu a na njezine ruke stavi spomen-prinosnicu, to jest žitnu prinosnicu za ljubomoru, s svećenik neka drži u ruci vodu gorčine i prokletstva. ");
INSERT INTO hrv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Zatim neka svećenik ženu zakune. Neka joj reče: 'Ako nikad čovjek s tobom nije ležao te ako nisi išla stranputicom i oskvrnula se dok si bila pod vlašću svoga muža, budi pošteđena od ove vode gorčine i prokletstva! ");
INSERT INTO hrv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ali ako si išla stranputicom dok si bila pod vlašću svoga muža te se oskvrnula; ako je koji čovjek osim tvoga muža legao s tobom ...' ");
INSERT INTO hrv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Ovdje neka svećenik zakune ženu ovom kletvom: neka joj rekne: Jahve te postavio za prokletstvo i kletvu među tvojim narodom, učinio da ti uvene rodnica i da ti se utroba nadme! ");
INSERT INTO hrv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Neka ova voda prokletstva zađe u tvoju utrobu! Trbuh ti se od nje naduo, a rodnica uvenula! - A žena neka poprati: Amen! Amen! ");
INSERT INTO hrv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Potom neka ta prokletstva svećenik napiše na list pa ih ispere u vodu gorčine. ");
INSERT INTO hrv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Onda neka ženu napoji vodom gorčine i prokletstva, da bi se voda gorčine po njoj razišla i napunila je gorkošću. ");
INSERT INTO hrv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Neka svećenik onda uzme iz ženine ruke prinosnicu za ljubomoru, prinese je pred Jahvom kao žrtvu prikaznicu te je donese na žrtvenik. ");
INSERT INTO hrv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Zagrabivši od prinosnice punu pregršt kao spomen-žrtvu, neka to sažeže u kad na žrtveniku. Napokon, neka ženu napoji vodom. ");
INSERT INTO hrv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Pošto je napoji vodom, bude li oskvrnuta iznevjerivši se svome mužu, voda prokletstva ući će u nju i napunit će je gorčinom; njezina će se utroba naduti a rodnica uvenuti - ta će žena postati prokletstvom u svome narodu. ");
INSERT INTO hrv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","A ako žena ne bude oskvrnuta nego nevina, neće joj biti ništa i imat će djece. ");
INSERT INTO hrv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","To je obred u slučaju ljubomore, kad žena pođe stranputicom i oskvrne se dok je pod vlašću svoga muža; ");
INSERT INTO hrv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ili kad kojega čovjeka obuzme duh ljubomore te postane ljubomoran na svoju ženu. Neka, dakle, postavi svoju ženu pred Jahvu, a svećenik neka nad njom izvrši sav ovaj obred. ");
INSERT INTO hrv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Neka je muž slobodan od krivnje, a žena neka snosi svoju krivnju.” ");
INSERT INTO hrv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Govori Izraelcima i reci im: 'Ako tko, bilo čovjek ili žena, položi nazirejski zavjet te se posveti Jahvi, ");
INSERT INTO hrv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","neka se suzdržava od vina i svakoga opojnog pića. Neka ne pije ni ukiseljena vina niti ukiseljena opojnog pića; a niti kakva soka od grožđa neka ne pije; neka ne jede grožđa, ni svježa ni suha. ");
INSERT INTO hrv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Sve vrijeme svoga nazireata ne smije jesti ništa što rađa lozov trs - od zelena grožđa do komine.' ");
INSERT INTO hrv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Sve dok traje njegov nazirejski zavjet, neka britva ne prelazi preko njegove glave; dok se ne navrši vrijeme što ga je Jahvi zavjetovao, neka bude posvećen i pusti kose da mu slobodno rastu na glavi. ");
INSERT INTO hrv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Za sve vrijeme svoga zavjeta Jahvi neka se ne primiče nikakvu mrtvacu. ");
INSERT INTO hrv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Neka se ne onečišćuje ni zbog svoga oca, ni zbog svoje majke, svoga brata ili svoje sestre ako bi umrli, jer na svojoj glavi nosi posvećenje svoga Boga. ");
INSERT INTO hrv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Sve vrijeme svoga nazireata on je posvećen Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Umre li tko nenadanom smrću pokraj njega, onečistivši tako njegovu posvećenu glavu, neka na dan svoga očišćenja obrije svoju glavu - neka je obrije sedmoga dana. ");
INSERT INTO hrv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A osmoga dana neka donese svećeniku, na ulazu u Šator sastanka, dvije grlice ili dva golubića. ");
INSERT INTO hrv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Neka svećenik prinese jedno kao žrtvu okajnicu, a drugo kao žrtvu paljenicu, zatim neka nad njim izvrši obred pomirenja zbog ljage kojom se okaljao uz mrtvaca. Toga dana neka posveti svoju glavu; ");
INSERT INTO hrv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","neka zavjetuje Jahvi dane svoga nazireata; neka donese jednogodišnjeg janjca kao žrtvu naknadnicu. Prijašnje vrijeme neka se ne računa, jer je njegov nazireat bio oskvrnjen. ");
INSERT INTO hrv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ovo je obred za nazirejca: na dan kad se navrši vrijeme njegova nazireata, neka ga dovedu na ulaz Šatora sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Kao svoj prinos neka Jahvi donese: jednogodišnjeg janjca bez mane za žrtvu paljenicu; jednogodišnje žensko janje, bez mane, za žrtvu okajnicu; jednoga ovna, bez mane, za žrtvu pričesnicu; ");
INSERT INTO hrv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","nadalje, košaru neukvasanih pogača od najboljeg brašna, u ulju zamiješenih i neukvasanih kolača, namazanih uljem, s njihovim prinosnicama i ljevanicama. ");
INSERT INTO hrv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Svećenik, pošto to donese pred Jahvu, neka prinese njegovu okajnicu i paljenicu. ");
INSERT INTO hrv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Zatim neka prinese ovna Jahvi kao žrtvu pričesnicu zajedno s košarom neukvasanih pogača. I njegovu prinosnicu i njegovu ljevanicu neka prinese svećenik. ");
INSERT INTO hrv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Na ulazu u Šator sastanka neka nazirejac obrije svoju posvećenu glavu i, uzevši uvojke sa svoje posvećene glave, neka ih stavi na vatru što gori pred žrtvom pričesnicom. ");
INSERT INTO hrv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Zatim neka svećenik uzme kuhano pleće ovna, jednu neukvasanu pogaču iz košare i jedan neukvasani kolač i stavi to na ruke nazirejcu pošto ovaj obrije svoje posvećene kose. ");
INSERT INTO hrv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Neka to svećenik prinese kao žrtvu prikaznicu pred Jahvom. To je svetinja što pripada svećeniku, osim grudi prikaznice i stegna podizanice. Poslije toga nazirejac može piti vina.” ");
INSERT INTO hrv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ovo je obred nazirejca, ne računajući ono što bi još mogla prinijeti njegova ruka. Ako je povrh svoga nazireata obećao kakav dar, neka povrh obreda svoga nazireata učini kako je zavjetovao. ");
INSERT INTO hrv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Reci Aronu i njegovim sinovima: 'Ovako blagoslivljajte Izraelce govoreći im: ");
INSERT INTO hrv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Neka te blagoslovi Jahve i neka te čuva! ");
INSERT INTO hrv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Neka te Jahve licem svojim obasja, milostiv ti bude! ");
INSERT INTO hrv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Neka pogled svoj Jahve svrati na te i mir ti donese!' Tako neka stavljaju moje ime nad sinove Izraelove, i ja ću ih blagoslivljati.” ");
INSERT INTO hrv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","U onaj dan kad Mojsije završi podizanje Prebivališta i kad ga pomaza i posveti sa svim njegovim posuđem, a tako i žrtvenik sa svim njegovim priborom, ");
INSERT INTO hrv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","pristupe glavari izraelski, starješine njihovih pradjedovskih domova, to jest knezovi plemenski koji su vodili popisivanje, ");
INSERT INTO hrv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","i dovedu svoje prinose pred Jahvu: šestora teretna kola i dvanaest volova - jedna kola za dvojicu glavara i vola za svakoga pojedinoga. Dovedu ih pred Prebivalište. ");
INSERT INTO hrv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Tada Jahve progovori Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Primi to od njih za upotrebu pri službi u Šatoru sastanka; onda to podaj svakome levitu prema njegovoj službi.” ");
INSERT INTO hrv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mojsije uze kola i volove pa ih dade levitima. ");
INSERT INTO hrv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dvoja kola i četiri vola dade Geršonovcima prema njihovoj službi, ");
INSERT INTO hrv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","a četvera kola i osam volova dade Merarijevcima prema njihovoj službi pod vodstvom Itamara, sina svećenika Arona. ");
INSERT INTO hrv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Kehatovcima nije dao ništa, jer je njihova zadaća bila nositi posvećene predmete na ramenima. ");
INSERT INTO hrv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Tada glavari prinesu prinos za posvetu žrtvenika na dan njegova pomazanja. Dok su glavari prinosili svoje prinose pred žrtvenik, ");
INSERT INTO hrv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Jahve progovori Mojsiju: “Svakoga dana neka po jedan glavar donese svoj prinos za posvetu žrtvenika!” ");
INSERT INTO hrv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Prvoga dana donese svoj prinos Nahšon, sin Aminadabov, od plemena Judina. ");
INSERT INTO hrv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela i jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; jedno i drugo bijaše napunjeno najboljim brašnom, zamiješenim u ulju, za prinosnicu. ");
INSERT INTO hrv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Onda jedna zlatna posudica od deset šekela puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","jedan jarac za žrtvu okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","a za žrtvu pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Nahšona, Aminadabova sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Drugoga dana donese svoj prinos Netanel, sin Suarov, glavar Jisakarovaca. ");
INSERT INTO hrv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Za svoj prinos donio je: jednu srebrnu zdjelu tešku sto trideset šekela, jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje puno najboljeg brašna, zamiješena u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","onda jednu zlatnu posudicu od deset šekela punu tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","jednog junca, jednoga ovna, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","jednog jarca za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Netanela, Suarova sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Trećega dana donese svoj prinos glavar Zebulunovaca, Eliab, sin Helonov. ");
INSERT INTO hrv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela i jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje puno najboljeg brašna, zamiješena u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","jedna zlatna posudica puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Eliaba, Helonova sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Četvrtog dana donese svoj prinos glavar Rubenovaca, Elisur, sin Šedeurov. ");
INSERT INTO hrv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela, jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje puno najboljeg brašna, zamiješena u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","onda jedna zlatna posudica od deset šekela puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Elisura, Šedeurova sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Petoga dana donese svoj prinos glavar Šimunovaca, Šelumiel, sim Surišadajev. ");
INSERT INTO hrv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela, jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje napunjeno najboljim brašnom, zamiješenim u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","onda jedna zlatna posudica od deset šekela puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Šelumiela, Surišadajeva sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Šestoga dana donese svoj prinos glavar Gadovaca, Elijasaf, sin Deuelov. ");
INSERT INTO hrv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela, jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje napunjeno najboljim brašnom, zamiješenim u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","onda jedna zlatna posudica od deset šekela puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Elijasafa, Deuelova sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Sedmoga dana donese svoj prinos glavar Efrajimovaca, Elišama, sin Amihudov. ");
INSERT INTO hrv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela i jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje puno najboljeg brašna, zamiješena u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","onda jedna zlatna posudica od deset šekela puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Elišama, Amihudova sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Osmoga dana donese svoj prinos glavar Manašeovaca, Gamliel, sin Pedahsurov. ");
INSERT INTO hrv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela i jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje napunjeno najboljim brašnom, zamiješenim u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","onda jedna zlatna posudica od deset šekela puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Gamliela, Pedahsurova sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Devetoga dana donese svoj prinos glavar Benjaminovaca, Abidan, sin Gidonijev. ");
INSERT INTO hrv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela i jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje napunjeno najboljim brašnom, zamiješenim u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","onda jedna zlatna posudica od deset šekela puna tamjana, ");
INSERT INTO hrv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Abidana, Gidonijeva sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Desetoga dana donese svoj prinos glavar Danovaca, Ahiezer, sin Amišadajev. ");
INSERT INTO hrv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela i jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje napunjeno najboljim brašnom, zamiješenim u ulju, za prikaznicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","onda jedna zlatna posudica od deset šekela puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Ahiezera, Amišadajeva sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Jedanaestoga dana donese svoj prinos glavar Ašerovaca, Pagiel, sin Okranov. ");
INSERT INTO hrv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela i jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje napunjeno najboljim brašnom, zamiješenim u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","onda jedna zlatna posudica od deset šekela puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Pagiela, Okranova sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Dvanaestoga dana donese svoj prinos glavar Naftalijevaca, Ahira, sin Enanov. ");
INSERT INTO hrv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Njegov je prinos bio: jedna srebrna zdjela teška sto trideset šekela i jedan srebrni kotlić od sedamdeset šekela, prema hramskom šekelu; oboje napunjeno najboljim brašnom, zamiješenim u ulju, za prinosnicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","onda jedna zlatna posudica od deset šekela puna tamjana; ");
INSERT INTO hrv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","jedan junac, jedan ovan, jedno janje od godinu dana za paljenicu; ");
INSERT INTO hrv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","jedan jarac za okajnicu, ");
INSERT INTO hrv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","a za pričesnicu: dva vola, pet ovnova, pet kozlića i pet jednogodišnjih janjaca. To je bio prinos Ahire, Enanova sina. ");
INSERT INTO hrv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","To su bili prinosi glavara izraelskih za posvetu žrtvenika na dan kad bijaše pomazan: dvanaest srebrnih zdjela, dvanaest srebrnih kotlića i dvanaest zlatnih posudica. ");
INSERT INTO hrv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Svaka srebrna zdjela težila je sto trideset šekela; svaki kotlić sedamdeset šekela. Svega srebra u posuđu bilo je dvije tisuće i četiri stotine hramskih šekela. ");
INSERT INTO hrv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Zlatnih posudica punih tamjana bilo je dvanaest, svaka posudica težila je deset hramskih šekela. Sve zlato u posudicama težilo je sto dvadeset šekela. ");
INSERT INTO hrv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Sve stoke za paljenicu: dvanaest junaca, dvanaest ovnova, dvanaest jednogodišnjih janjaca s njihovim prinosima. Za okajnicu dvanaest jaraca. ");
INSERT INTO hrv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Sve stoke za pričesnicu: dvadeset i četiri vola, šezdeset ovnova, šezdeset kozlića i šezdeset janjaca od godine dana. To je bio prinos za posvetu žrtvenika pošto bijaše pomazan. ");
INSERT INTO hrv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Kad bi Mojsije ulazio u Šator sastanka da razgovara s Njim, slušao bi glas kako mu govori ozgo s Pomirilišta što je bilo na Kovčegu svjedočanstva, među dva kerubina. Tada bi mu govorio. ");
INSERT INTO hrv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Govori Aronu i reci mu: 'Kad budeš palio svjetionice, neka sedam svjetionica svijetli na prednjoj strani svijećnjaka.'” ");
INSERT INTO hrv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aron i učini tako: smjesti svjetionice na prednju stranu svijećnjaka, kako je Jahve Mojsiju naredio. ");
INSERT INTO hrv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Svijećnjak bijaše skovan od zlata; skovan od svoga podnožja do svoje čaške. Svijećnjak je bio napravljen prema uzorku što ga je Jahve pokazao Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Uzmi levite između Izraelaca i očisti ih! ");
INSERT INTO hrv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ovako s njima postupi da ih očistiš: poškropi ih vodom za okajavanje; a oni neka se obriju po svemu svome tijelu, neka operu svoju odjeću i bit će čisti. ");
INSERT INTO hrv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Neka zatim uzmu jednog junca i prinosnicu od najboljeg brašna, zamiješena u ulju. A ti uzmi drugog junca za okajnicu. ");
INSERT INTO hrv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Dovedi onda levite pred Šator sastanka i skupi svu izraelsku zajednicu. ");
INSERT INTO hrv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Kad dovedeš levite pred Jahvu, neka Izraelci stave na njih svoje ruke. ");
INSERT INTO hrv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Neka zatim Aron prinese levite, kao prikaznicu pred Jahvom, u ime Izraelaca. Tako će njihov posao biti da služe Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Neka potom leviti stave svoje ruke juncima na glave; onda jednoga prinesi kao okajnicu, a drugoga kao paljenicu Jahvi, da se izvrši obred pomirenja nad levitima. ");
INSERT INTO hrv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Stavivši levite pred Arona i njegove sinove, prikaži ih Jahvi žrtvom prikaznicom. ");
INSERT INTO hrv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Odvoji tako levite između Izraelaca da budu moji. ");
INSERT INTO hrv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Poslije toga, pošto ih očistiš i prineseš žrtvom prikaznicom, neka leviti uđu u službu Šatora sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Jer oni su između Izraelaca meni potpuno darovani; njih sam sebi uzeo namjesto svih koji otvaraju majčinu utrobu, svih izraelskih prvorođenaca. ");
INSERT INTO hrv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Svako, naime, prvorođenče među Izraelcima, kako čedo tako i živinče, moje je; sebi sam ih posvetio onoga dana kad sam pobio svu prvorođenčad u zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Tako sam uzeo levite namjesto svih izraelskih prvorođenaca. ");
INSERT INTO hrv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","I predao sam levite između Izraelaca kao dar Aronu i njegovim sinovima da mjesto Izraelaca obavljaju službu u Šatoru sastanka; da nad njima obavljaju obred pomirenja, tako da kakva nedaća ne bi pogodila Izraelce što bi se približili Svetištu.” ");
INSERT INTO hrv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mojsije, Aron i sva izraelska zajednica učine tako s levitima; kako je Jahve naredio Mojsiju za levite, tako im Izraelci i učine. ");
INSERT INTO hrv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leviti se očiste i operu svoju odjeću; onda ih Aron prinese pred Jahvu žrtvom prikaznicom. Aron nad njima obavi obred pomirenja da ih očisti. ");
INSERT INTO hrv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Poslije toga uđu leviti u službu u Šator sastanka, u nazočnosti Arona i njegovih sinova. Kako je Jahve naredio Mojsiju za levite, tako su s njima i uradili. ");
INSERT INTO hrv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“I ovo se tiče levita: od dvadeset i pet godina naviše neka leviti po redu preuzimaju službu u Šatoru sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","A kad kome bude pedeset godina, neka istupi iz službe i neka više ne služi. ");
INSERT INTO hrv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ali može pomagati svojoj braći u vršenju njihovih dužnosti u Šatoru sastanka, no sam ne mora vršiti službe. Tako postupi prema levitima za njihove dužnosti!” ");
INSERT INTO hrv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Prvoga mjeseca druge godine nakon izlaska iz zemlje egipatske Jahve reče Mojsiju u Sinajskoj pustinji: ");
INSERT INTO hrv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Neka Izraelci slave Pashu u njezino vrijeme. ");
INSERT INTO hrv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Slavite je u njezino vrijeme, u suton, četrnaestoga dana ovoga mjeseca; slavite je prema svim njezinim propisima i običajima.” ");
INSERT INTO hrv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Tako Mojsije reče Izraelcima da slave Pashu. ");
INSERT INTO hrv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","I oni su je slavili u Sinajskoj pustinji, u suton, prvoga mjeseca, četrnaestoga dana u mjesecu. Kako je god Jahve Mojsiju naredio, tako su Izraelci i učinili. ");
INSERT INTO hrv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","A bijaše ljudi onečišćenih mrtvacem; ti nisu mogli slaviti Pashu onoga dana. Dođu tako pred Mojsija i Arona istoga dana ");
INSERT INTO hrv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","pa reknu: “Mrtvacem smo se onečistili; ipak, zašto bi nam bilo uskraćeno prinositi Jahvi žrtvu u njezino vrijeme usred Izraelovih sinova?” ");
INSERT INTO hrv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mojsije im reče: “Strpite se da čujem što će Jahve za vas odrediti.” ");
INSERT INTO hrv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","I Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Ovako kaži Izraelcima: 'Kad se tko između vas ili vaših potomaka onečisti mrtvacem ili je na daleku putu, neka ipak slavi Pashu Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Neka je slave u suton četrnaestog dana drugoga mjeseca. Neka je blaguju s neukvasanim kruhom i gorkim zeljem; ");
INSERT INTO hrv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","neka ništa od nje ne ostavljaju za ujutro; neka ni jedne kosti na njoj ne lome. Neka je slave prema propisima Pashe. ");
INSERT INTO hrv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Onaj koji je čist a ne bude na putovanju pa ipak propusti proslaviti Pashu, neka se iskorijeni iz svoga naroda. Budući da nije prinio Jahvi žrtve u njezino vrijeme, takav neka snosi svoju krivnju. ");
INSERT INTO hrv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ako s vama boravi stranac i Pashu prinosi Jahvi, neka je prinosi prema propisima i običajima njezinim. Neka bude jedan zakon za vas, bio to stranac ili domorodac.'” ");
INSERT INTO hrv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Na dan kad je podignuto Prebivalište oblak prekri Prebivalište, Šator svjedočanstva. Od večeri do jutra stajao je u obliku ognja nad Prebivalištem. ");
INSERT INTO hrv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tako ga je oblak neprestano zaklanjao, a noću bijaše poput ognja. ");
INSERT INTO hrv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Kad bi se god oblak digao sa Šatora, Izraelci bi poslije toga krenuli. A gdje bi oblak stao, tu bi se i Izraelci utaborili. ");
INSERT INTO hrv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Na zapovijed Jahvinu Izraelci su kretali na put i na Jahvinu se zapovijed utaborivali. Sve vrijeme što bi oblak stajao nad Prebivalištem oni su taborovali. ");
INSERT INTO hrv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ako bi oblak dugo stajao nad Prebivalištem, Izraelci su slušali Jahvin nalog i ne bi polazili na put. ");
INSERT INTO hrv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ali ako bi se dogodilo da oblak ostane nad Prebivalištem malo vremena, oni bi se na Jahvinu zapovijed utaborili i na Jahvinu zapovijed opet krenuli na put. ");
INSERT INTO hrv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ako bi se oblak digao pošto se zadržao od večeri do jutra, oni bi tada ujutro krenuli na put. Danju ili noću, kad bi se oblak digao, oni bi krenuli na put. ");
INSERT INTO hrv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Dva dana ili mjesec ili godinu - dok bi oblak ostajao nad Prebivalištem - Izraelci su taborovali, ne krećući na put, a čim bi se digao, oni bi krenuli. ");
INSERT INTO hrv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Po zapovijedi Jahvinoj stajahu u taboru i po zapovijedi Jahvinoj kretahu na put. Držali su se Jahvina naloga, kako Jahve bijaše zapovjedio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Napravi sebi dvije trube; napravi ih od kovana srebra. Neka ti služe za sazivanje zajednice i za pokretanje tabora. ");
INSERT INTO hrv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kad se u njih zatrubi, neka se sva zajednica skupi k tebi na ulazu u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ako li se zatrubi u jednu, neka se k tebi skupe glavari izraelski, tisućnici. ");
INSERT INTO hrv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kad popratite trubljenje bojnim poklikom, neka krenu logori utaboreni na istočnoj strani. ");
INSERT INTO hrv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Kad popratite trubljenje bojnim poklikom po drugi put, neka krenu logori utaboreni s južne strane: neka se trubljenje poprati bojnim poklikom da oni krenu. ");
INSERT INTO hrv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Trubite i da skupite zajednicu, ali bez bojnog poklika. ");
INSERT INTO hrv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Neka u trube trube svećenici, sinovi Aronovi. Neka vam to bude trajnom uredbom za vaše naraštaje. ");
INSERT INTO hrv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Kad u svojoj zemlji pođete u rat na neprijatelja koji vas pritisne, zaorite na trube s bojnim poklikom, i Jahve, Bog vaš, sjetit će se vas i bit ćete izbavljeni od svojih neprijatelja. ");
INSERT INTO hrv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Na dan svoje svečanosti, svojih blagdana ili svojih mjesečevih mlađaka, dok prinosite svoje paljenice i pričesnice, trubite u trube. Neka to za vas bude spomen pred Bogom vašim. Ja sam Jahve, Bog vaš.” ");
INSERT INTO hrv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Druge godine drugoga mjeseca dvadesetog dana u mjesecu diže se oblak iznad Prebivališta svjedočanstva. ");
INSERT INTO hrv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Tada se Izraelci zapute iz Sinajske pustinje na svoja putovanja. Oblak se zaustavi u pustinji Paranu. ");
INSERT INTO hrv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Tako na Jahvinu zapovijed danu Mojsiju krenuše prvi put. ");
INSERT INTO hrv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Prva je krenula zastava tabora Judinih sinova u svojim četama. Nad njihovom vojskom bijaše Nahšon, sin Aminadabov; ");
INSERT INTO hrv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","nad vojskom plemena Jisakarovaca stajaše Netanel, sin Suarov, ");
INSERT INTO hrv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","a nad vojskom plemena Zebulunovaca bijaše Eliab, sin Helonov. ");
INSERT INTO hrv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Zatim, pošto je rastavljeno Prebivalište, krenuše Geršonovci i Merarijevci noseći Prebivalište. ");
INSERT INTO hrv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Potom krenu zastava tabora Rubenova u svojim četama. Nad njihovom vojskom bijaše Elisur, sin Šedeurov; ");
INSERT INTO hrv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","nad vojskom plemena Šimunovaca stajao je Šelumiel, sin Surišadajev; ");
INSERT INTO hrv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","nad vojskom plemena Gadovaca bio je Elijasaf, sin Deuelov. ");
INSERT INTO hrv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Potom krenuše Kehatovci noseći posvećene predmete. Tako je Prebivalište bilo podignuto prije njihova dolaska. ");
INSERT INTO hrv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Onda krenu zastava tabora Efrajimovaca u svojim četama. Nad njihovom vojskom bijaše Elišama, sin Amihudov, ");
INSERT INTO hrv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","nad vojskom plemena Manašeovaca stajaše Gamliel, sin Pedahsurov; ");
INSERT INTO hrv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","nad vojskom plemena Benjaminovaca bijaše Abidan, sin Gidonijev. ");
INSERT INTO hrv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","A kao zalazna straža za sve tabore krenu, u svojim četama, zastava tabora Danovaca. Nad njihovom je vojskom stajao Ahiezer, sin Amišadajev. ");
INSERT INTO hrv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Nad vojskom plemena Ašerovaca bio je Pagiel, sin Okranov; ");
INSERT INTO hrv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","a nad vojskom plemena Naftalijevaca bio je Ahira, sin Enanov. ");
INSERT INTO hrv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Takav je bio red putovanja Izraelaca svrstanih u svoje čete. Tako su putovali. ");
INSERT INTO hrv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mojsije reče Hobabu, sinu Midjanca Reuela, Mojsijeva tasta: “Zaputili smo se u kraj o kojemu je Jahve rekao: 'Dat ću vam ga!' Pođi s nama i dobro ćemo ti činiti, jer je Jahve obećao sreću Izraelu.” ");
INSERT INTO hrv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","“Ne idem”, odgovori mu, “nego se vraćam u svoju zemlju; k svojima se vraćam.” ");
INSERT INTO hrv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","“Molim te, ne ostavljaj nas!” - reče. “Budući da znaš gdje nam se treba u pustinji utaboriti, valjat ćeš nam kao oči. ");
INSERT INTO hrv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ako s nama pođeš, dobročinstva koja nam Jahve bude udijelio s tobom ćemo dijeliti.” ");
INSERT INTO hrv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Od Jahvina brda putovali su tri dana hoda. Kovčeg Jahvina saveza išao je pred njima ta tri dana hoda da im potraži mjesto odmora. ");
INSERT INTO hrv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Danju je opet Jahvin oblak bio nad njima, kako bi se iz tabora zaputili. ");
INSERT INTO hrv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kad bi Kovčeg polazio, Mojsije bi rekao: “Ustani, Jahve! Neprijatelji tvoji neka se rasprše! Koji tebe mrze nek' bježe pred tobom!” ");
INSERT INTO hrv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","A kad bi se zaustavljao, popratio bi: “Vrati se, o Jahve! Izraelu ti si tisuće bezbrojne!” ");
INSERT INTO hrv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","I stade narod zlobno mrmljati u Jahvine uši. Kad to ču Jahve, planu gnjevom. Jahvin oganj izbi među njima i spali jedan kraj tabora. ");
INSERT INTO hrv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Narod zavapi Mojsiju, a Mojsije se pomoli Jahvi i oganj se utiša. ");
INSERT INTO hrv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ono se mjesto prozva Tabera, jer je Jahvin oganj ondje zaplamtio na njih. ");
INSERT INTO hrv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Svjetinu koja se oko njih skupila obuzme pohlepa za jelom. Izraelci se opet upuste u jadikovanje govoreći: “Tko će nas nasititi mesom? ");
INSERT INTO hrv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Sjećamo se kako smo u Egiptu jeli badava ribe, krastavaca, dinje, prÓase, luka i češnjaka. ");
INSERT INTO hrv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Sad nam život vene; nema ničega, osim mÓane, pred našim očima.” ");
INSERT INTO hrv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","MÓana je bila kao zrno korijandera i nalik na bdelij. ");
INSERT INTO hrv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Narod išao naokolo, skupljao je, a onda tro kamenom na kamenoj ploči ili stÓupao u stÓupi. Kuhao ju je u loncu i od nje pravio kolače. Okus joj bijaše kao okus kolača zgotovljena u ulju. ");
INSERT INTO hrv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kad bi se noću spuštala rosa po taborištu, s njome bi se spustila i mÓana. ");
INSERT INTO hrv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mojsije je slušao kako jadikuje narod u svojim obiteljima, svatko na ulazu u svoj šator. Gnjev Jahvin žestoko planu i Mojsije se ražalosti. ");
INSERT INTO hrv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","“Zašto zlostavljaš slugu svoga?” - upravi Mojsije riječ Jahvi. “Zašto nisam stekao milost u tvojim očima kad si na me uprtio teret svega ovog naroda? ");
INSERT INTO hrv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Zar je od mene potekao sav ovaj narod? Zar sam ga ja rodio, kad veliš: 'Nosi ga u svome krilu, kao što dojilja nosi dojenče, u zemlju što sam je pod zakletvom obećao njihovim očevima!' ");
INSERT INTO hrv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Odakle meni meso da ga dam svemu ovom puku koji plače oko mene govoreći: 'Daj nam mesa da jedemo!' ");
INSERT INTO hrv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ja sam ne mogu nositi sav ovaj narod. Preteško je to za me. ");
INSERT INTO hrv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ako ćeš ovako sa mnom postupati, radije me ubij, ako sam stekao milost u tvojim očima, da više ne gledam svoga jada.” ");
INSERT INTO hrv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Onda Jahve reče Mojsiju: “Skupi mi sedamdeset muževa između starješina izraelskih za koje znaš da su starješine narodu i njegovi nadglednici. Dovedi ih u Šator sastanka pa neka ondje zauzmu svoja mjesta s tobom. ");
INSERT INTO hrv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ja ću sići i ondje s tobom govoriti; uzet ću nešto duha koji je na tebi i stavit ću ga na njih. Tako će s tobom nositi teret naroda da ga ne nosiš sam. ");
INSERT INTO hrv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Nadalje, kaži narodu: Za sutra se posvetite i jest ćete mesa, jer ste mrmljali u uši Jahvi govoreći: 'Tko će nas nasititi mesa? U Egiptu nam je bilo dobro.' Jahve će vam, dakle, dati mesa da jedete. ");
INSERT INTO hrv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nećete ga jesti samo jedan dan, ni dva dana, ni pet dana, ni deset dana, ni dvadeset dana, ");
INSERT INTO hrv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","nego cio mjesec, sve dok vam ne izbije na nosnice i ne ogadi vam se, jer ste odbacili Jahvu koji je među vama mrmljajući pred njim riječima: 'Zašto smo uopće odlazili iz Egipta!'” ");
INSERT INTO hrv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","“Naroda u kojemu se nalazim”, odgovori Mojsije, “ima šest stotina tisuća pješaka, a ti kažeš: 'Mesa ću im dati da jedu mjesec dana.' ");
INSERT INTO hrv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Može li im se naklati sitne i krupne stoke da im dostane? Mogu li im se sve ribe iz mora zgrnuti da im bude dosta?” ");
INSERT INTO hrv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Jahve reče Mojsiju: “Zar je ruka Jahvina tako kratka? Sad ćeš vidjeti hoće li se obistiniti moja riječ ili neće.” ");
INSERT INTO hrv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mojsije izađe i kaza narodu Jahvine riječi. Onda skupi sedamdeset muževa između narodnih starješina i smjesti ih oko Šatora. ");
INSERT INTO hrv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Jahve siđe u oblaku i poče s njim govoriti. Zatim uze od duha koji bijaše na njemu i stavi na onu sedamdesetoricu starješina. Kad duh počinu na njima, počeše prorokovati, ali to više nikad ne učiniše. ");
INSERT INTO hrv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Dvojica ostadoše u taboru. Jednome je bilo ime Eldad, a drugome Medad. Duh je i na njima počinuo - bili su i oni među upisanima, premda nisu došli u tabor - te počeše u taboru prorokovati. ");
INSERT INTO hrv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Neki mladić otrča te javi Mojsiju: “Eldad i Medad”, reče, “prorokuju u taboru!” ");
INSERT INTO hrv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Jošua, sin Nunov, koji je posluživao Mojsija od svoje mladosti, prozbori i reče: “Mojsije, gospodaru moj, ušutkaj ih!” ");
INSERT INTO hrv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mojsije mu odgovori: “Zar si zavidan zbog mene! Oh, kad bi sav narod Jahvin postao prorok! Kad bi Jahve na njih izlio svoga duha!” ");
INSERT INTO hrv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Potom se Mojsije i starješine izraelske vrate u tabor. ");
INSERT INTO hrv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Tada Jahve zapovjedi te zapuhnu vjetar i nanese prepelice od mora i sasu ih na tabor, na dan hoda i s ove i s one strane tabora, na dva lakta iznad zemlje. ");
INSERT INTO hrv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Narod je ustao te je toga cijeloga dana, svu noć i cio sutrašnji dan skupljao prepelice. Onaj tko ih je skupio najmanje imao je deset homera. ");
INSERT INTO hrv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Zatim ih razastriješe oko tabora. Meso još bijaše među njihovim zubima - još ga nisu prožvakali - kadli planu Jahvin gnjev protiv naroda: Jahve udari narod strašnim pomorom. ");
INSERT INTO hrv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ono se mjesto prozva Kibrot Hataava, jer su ondje pokopali one koji se bijahu polakomili. ");
INSERT INTO hrv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Iz Kibrot Hataave narod se zaputi u Haserot. I utabori se u Haserotu. ");
INSERT INTO hrv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","A Mirjam i Aron uzeše rogoboriti protiv Mojsija zbog žene Kušanke kojom se oženio; jer bijaše uzeo za ženu jednu Kušanku. ");
INSERT INTO hrv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“Zar je samo Mojsiju govorio Jahve?” - rekoše mu. “Zar i nama nije govorio?” Jahve to ču. ");
INSERT INTO hrv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mojsije je bio veoma skroman čovjek, najskromniji čovjek na zemlji. ");
INSERT INTO hrv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","I odmah reče Jahve Mojsiju, Aronu i Mirjami: “Vas se troje pojavite u Šatoru sastanka.” Njih se troje pojavi. ");
INSERT INTO hrv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","U stupu oblaka siđe Jahve te stade na ulazu u Šator. Zovnu Arona i Mirjamu. Kad njih dvoje istupi naprijed, ");
INSERT INTO hrv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","reče Jahve: “Saslušajte riječi moje: Nađe li se među vama prorok, u viđenju njemu ja se javljam, u snu njemu progovaram. ");
INSERT INTO hrv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ali nije tako sa slugom mojim Mojsijem. Od svih u kući mojoj najvjerniji je on. ");
INSERT INTO hrv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Iz usta u usta njemu ja govorim, očevidnošću, a ne zagonetkama, i lik Jahvin on smije gledati. Kako se onda niste bojali govoriti protiv sluge moga Mojsija?” ");
INSERT INTO hrv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Uskipjevši gnjevom na njih, Jahve ode. ");
INSERT INTO hrv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Čim se od šatora oblak udaljio, gle! Mirjam ogubavi, kao snijegom posuta. Aron se okrenu prema Mirjami, a to guba na njoj. ");
INSERT INTO hrv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Tada rekne Aron Mojsiju: “Gospodaru moj, ne svaljuj na nas kazne za grijeh koji smo u ludosti počinili i kojega smo krivci. ");
INSERT INTO hrv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ne daj da ona ostane kao mrtvo dijete kojemu je već na izlasku iz majčine utrobe meso napol uništeno!” ");
INSERT INTO hrv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Tada zavapi Mojsije Jahvi: “Bože, molim te, ozdravi je!” ");
INSERT INTO hrv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","“Da joj je otac njezin pljunuo u lice”, reče Jahve Mojsiju, “zar se ne bi morala stidjeti sedam dana? Neka i ona bude odvojena izvan tabora sedam dana, pa neka se poslije opet pripusti.” ");
INSERT INTO hrv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Tako je Mirjam bila odvojena izvan tabora sedam dana. Narod nije na put polazio dok Mirjam nije opet bila pripuštena. ");
INSERT INTO hrv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Poslije toga narod krenu iz Haserota i utabori se u pustinji Paranu. ");
INSERT INTO hrv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Pošalji ljude, po jednoga čovjeka iz pojedinog pradjedovskog plemena, da izvide kanaansku zemlju, koju dajem Izraelcima. Pošaljite sve njihove glavare!” ");
INSERT INTO hrv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Na Jahvinu zapovijed Mojsije ih posla iz pustinje Parana. Svi ti ljudi bijahu glavari Izraelaca. ");
INSERT INTO hrv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","A ovo su njihova imena: Šamua, sin Zakurov, od plemena Rubenova; ");
INSERT INTO hrv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Šafat, sin Horijev, od plemena Šimunova; ");
INSERT INTO hrv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kaleb, sin Jefuneov, od plemena Judina; ");
INSERT INTO hrv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Jigal, sin Josipov, od plemena Jisakarova; ");
INSERT INTO hrv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hošea, sin Nunov, od plemena Efrajimova; ");
INSERT INTO hrv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti, sin Rafuov, od plemena Benjaminova; ");
INSERT INTO hrv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gadiel, sin Sodijev, od plemena Zebulunova; ");
INSERT INTO hrv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gadi, sin Susijev, od plemena Josipova, od plemena Manašeova; ");
INSERT INTO hrv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Amiel, sin Gemalijev, od plemena Danova; ");
INSERT INTO hrv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Setur, sin Mikaelov, od plemena Ašerova; ");
INSERT INTO hrv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nahbi, sin Vofsijev, od plemena Naftalijeva; ");
INSERT INTO hrv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Geuel, sin Makijev, od plemena Gadova. ");
INSERT INTO hrv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","To su imena ljudi koje je Mojsije poslao da izvide zemlju. A Hošeu, sina Nunova, Mojsije prozva Jošuom. ");
INSERT INTO hrv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Posla ih Mojsije da izvide kanaansku zemlju pa im reče: “Idite gore u Negeb, onda se popnite na brdo. ");
INSERT INTO hrv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Razgledajte zemlju kakva je. Je li narod koji u njoj živi jak ili slab, malobrojan ili mnogobrojan? ");
INSERT INTO hrv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Kakva je zemlja u kojoj živi: dobra ili rđava? Kakvi su gradovi u kojima borave: otvoreni ili utvrđeni? ");
INSERT INTO hrv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Kakvo je tlo: plodno ili mršavo? Ima li po njemu drveća ili nema? Odvažni budite i ponesite plodova te zemlje.” Bilo je upravo vrijeme ranog grožđa. ");
INSERT INTO hrv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Odu oni gore da izvide zemlju od pustinje Sina do Rehoba, koji je na ulazu u Hamat. ");
INSERT INTO hrv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Popnu se u Negeb i dođu do Hebrona, gdje su se nalazili Ahiman, Šešaj i Talmaj, Anakovi potomci. - Hebron je osnovan sedam godina prije nego Soan u Egiptu. - ");
INSERT INTO hrv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kada stigoše u Dolinu Eškol, odrezaše ondje lozu s grozdom i ponesoše ga, udvoje, na motki; ponesoše i mogranja i smokava. ");
INSERT INTO hrv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ono se mjesto prozva Dolina Eškol zbog grozda koji su ondje Izraelci odrezali. ");
INSERT INTO hrv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Nakon četrdeset dana vrate se iz zemlje koju su izviđali. ");
INSERT INTO hrv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Odu k Mojsiju i Aronu i svoj izraelskoj zajednici u Kadeš, u Paranskoj pustinji. Podnesu njima i svoj zajednici izvještaj, a onda im pokažu plodove zemlje. ");
INSERT INTO hrv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Izvijeste ga oni: “Išli smo u zemlju u koju si nas poslao. Zaista njome teče med i mlijeko. Evo njezinih plodova. ");
INSERT INTO hrv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ali je jak narod koji u onoj zemlji živi, gradovi su utvrđeni i vrlo veliki. A vidjesmo ondje i potomke Anakove. ");
INSERT INTO hrv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalečani borave u negepskom kraju: Hetiti, Jebusejci i Amorejci žive u brdu; a Kanaanci se nalaze uz more i duž Jordana.” ");
INSERT INTO hrv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaleb ušutka narod oko Mojsija i progovori: “Krenimo ne oklijevajući i zauzmimo je, jer je možemo nadvladati!” ");
INSERT INTO hrv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ali ljudi što su s njim išli odvratiše: “Ne možemo ići na onaj narod jer je jači od nas.” ");
INSERT INTO hrv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","I počnu ozloglašivati Izraelcima zemlju koju su izviđali: “Zemlja kroz koju smo prošli da je izvidimo zemlja je što proždire svoje stanovništvo. Sav narod što ga u njoj vidjesmo ljudi su krupna stasa. ");
INSERT INTO hrv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Vidjesmo ondje i divove - Anakovo potomstvo od divova. Činilo nam se da smo prema njima kao skakavci. Takvi bijasmo i njima.” ");
INSERT INTO hrv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Tada zagraja sva zajednica i poče vikati. I te noći narod plakaše. ");
INSERT INTO hrv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Svi su Izraelci mrmljali protiv Mojsija i Arona. Sva im je zajednica govorila: “Kamo sreće da smo pomrli u zemlji egipatskoj! Ili da smo pomrli u ovoj pustinji! ");
INSERT INTO hrv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Zašto nas Jahve vodi u tu zemlju da padnemo od mača a žene naše i djeca da postanu roblje! Zar nam ne bi bilo bolje da se vratimo u Egipat!” ");
INSERT INTO hrv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Jedan je drugome govorio: “Postavimo sebi vođu i vratimo se u Egipat!” ");
INSERT INTO hrv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mojsije i Aron padoše ničice pred svom okupljenom izraelskom zajednicom. ");
INSERT INTO hrv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","A Jošua, sin Nunov, i Kaleb, sin Jefuneov, koji bijahu među onima što su izviđali zemlju, razderaše svoju odjeću. ");
INSERT INTO hrv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Zatim rekoše svoj zajednici izraelskoj: “Zemlja kroz koju smo prošli da je istražimo izvanredno je dobra. ");
INSERT INTO hrv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ako nam Jahve bude dobrostiv, u tu će nas zemlju dovesti i dat će nam je. To je zemlja u kojoj teče med i mlijeko. ");
INSERT INTO hrv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Samo, nemojte se buniti protiv Jahve! Ne bojte se naroda one zemlje: tÓa on je zalogaj za nas. Oni su bez zaštite, a s nama je Jahve! Ne bojte ih se!” ");
INSERT INTO hrv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","I dok je sva zajednica već mislila da ih kamenuje, pokaza se Slava Jahvina u Šatoru sastanka svima sinovima Izraelovim. ");
INSERT INTO hrv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Tada reče Mojsiju: “Dokle će me taj narod prezirati? Dokle mi neće vjerovati unatoč svim znamenjima što sam ih među njima izvodio? ");
INSERT INTO hrv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Udarit ću ih pomorom i istrijebiti, a od tebe ću učiniti narod veći i moćniji od njega.” ");
INSERT INTO hrv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Onda Mojsije reče Jahvi: “Egipćani su shvatili da si ti, svojom moći, izveo ovaj narod između njih. ");
INSERT INTO hrv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Oni su to kazali žiteljima one zemlje. Već su saznali da si ti, Jahve, usred ovog naroda, kojemu se očituješ licem u lice, i da ti, Jahve, u oblaku stojiš nad njima; da obdan u stupu od oblaka, a obnoć u stupu od ognja ideš pred njima. ");
INSERT INTO hrv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Zato, ako pobiješ ovaj narod kao jednoga čovjeka, narodi koji su čuli glas o tebi reći će: ");
INSERT INTO hrv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","'Jahve je bio nemoćan da dovede ovaj narod u zemlju koju mu je pod zakletvom obećao, i zato ih je poubijao u pustinji.' ");
INSERT INTO hrv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Zato neka se snaga moga Gospodina uzvisi, kako si najavio rekavši: ");
INSERT INTO hrv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","'Jahve je spor na srdžbu, a bogat milosrđem; podnosi opačinu i prijestup, ali krivca ne ostavlja nekažnjena, nego opačinu otaca kažnjava na djeci do trećega i četvrtog koljena.' ");
INSERT INTO hrv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Oprosti krivnju ovome narodu po veličini svoga milosrđa, kao što si vodio ovaj narod od Egipta dovde.” ");
INSERT INTO hrv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","“Opraštam po riječi tvojoj”, reče Jahve. ");
INSERT INTO hrv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","“Ali ipak, tako ja živ bio i slave se Jahvine napunila sva zemlja, ");
INSERT INTO hrv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ni jedan od ljudi koji su vidjeli slavu moju i znamenja što sam ih izveo u Egiptu i u pustinji, pa me ipak iskušavali već deset puta ne hoteći poslušati moj glas, ");
INSERT INTO hrv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","neće vidjeti zemlje što sam je pod zakletvom obećao njihovim ocima; nitko od onih koji me preziru neće je vidjeti. ");
INSERT INTO hrv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","A slugu svoga Kaleba, jer je u njemu drukčiji duh i jer mi bijaše poslušan, njega ću ja dovesti u zemlju u koju je išao i njegovi će je potomci zaposjesti! Neka Amalečani i Kanaanci samo ostanu u dolini. ");
INSERT INTO hrv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Sutra se vratite i krenite u pustinju put Crvenog mora.” ");
INSERT INTO hrv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Još reče Jahve Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Dokle će ta opaka zajednica mrmljati protiv mene? Čuo sam tužbe što ih Izraelci na me dižu. ");
INSERT INTO hrv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Kaži im: Tako ja živ bio, objavljuje Jahve, kako ste na moje uši govorili, tako ću vam i učiniti. ");
INSERT INTO hrv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","U ovoj pustinji popadat će vaša mrtva tijela: svih vas koji ste ubilježeni u bilo koji vaš popis od dvadeset godina pa naprijed, koji ste rogoborili protiv mene. ");
INSERT INTO hrv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Nećete ući u zemlju na koju sam svoju ruku digao da vas u njoj nastanim, osim Kaleba, sina Jefuneova, i Jošue, sina Nunova. ");
INSERT INTO hrv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","A vašu djecu, o kojoj kažete da bi postala roblje, njih ću uvesti da nastane zemlju što ste je vi prezreli. ");
INSERT INTO hrv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","A vi? Neka vam tjelesa popadaju u ovoj pustinji! ");
INSERT INTO hrv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Vaši sinovi neka lutaju pustinjom četrdeset godina, neka trpe zbog vaše nevjere dok vam ne ispropadaju tjelesa u ovoj pustinji. ");
INSERT INTO hrv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Prema broju dana u koje ste istraživali zemlju - dana četrdeset, za svaki dan jednu godinu - ispaštajte svoje opačine četrdeset godina. Iskusite što znači mene napustiti. ");
INSERT INTO hrv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ja, Jahve, to kažem: tako ću postupiti s ovom opakom zajednicom što se sjatila protiv mene. U ovoj istoj pustinji neka završi! Tu neka izgine.” ");
INSERT INTO hrv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","A oni ljudi koje Mojsije bijaše poslao da istraže zemlju i koji su nakon povratka potakli svu zajednicu da rogobori protiv njega ozloglašujući zemlju; ");
INSERT INTO hrv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","oni, dakle, ljudi koji su zlobno ozloglasili zemlju bijahu pomoreni pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Od onih ljudi koji su išli da istraže zemlju ostadoše na životu jedino Jošua, sin Nunov, i Kaleb, sin Jefuneov. ");
INSERT INTO hrv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Kad je Mojsije prenio te riječi svim Izraelcima, narod se uvelike ražalosti. ");
INSERT INTO hrv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","I uranivši ujutro počnu se uspinjati na vrh brda govoreći. “Evo uzlazimo na mjesto o kojem je govorio Jahve jer smo zgriješili.” ");
INSERT INTO hrv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","A Mojsije rekne: “Zašto kršite zapovijed Jahvinu? Nećete uspjeti. ");
INSERT INTO hrv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ne penjite se, da vas ne potuku vaši neprijatelji, jer Jahve nije među vama. ");
INSERT INTO hrv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ta ondje se pred vama nalaze Amalečani i Kanaanci te ćete od mača pasti jer ste se odvratili od Jahve i jer Jahve neće biti s vama.” ");
INSERT INTO hrv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ali se oni prkosno penjahu prema vrhu brda, iako se ni Kovčeg saveza Jahvina ni Mojsije nisu micali iz tabora. ");
INSERT INTO hrv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Amalečani i Kanaanci koji su živjeli na onome brdu spuste se, udare po njima i rasprše ih sve do Horme. ");
INSERT INTO hrv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Govori Izraelcima i reci im: 'Kad uđete u zemlju gdje ćete boraviti i koju vam ja dajem, ");
INSERT INTO hrv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","pa budete prinosili Jahvi paljenu žrtvu, paljenicu ili klanicu, zavjetnicu ili dragovoljnu žrtvu, ili žrtvu prigodom svojih svetkovina - praveći tako od krupne ili sitne stoke ugodan miris Jahvi - ");
INSERT INTO hrv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","neka prinositelj prinese svoj dar Jahvi: prinosnicu od desetine efe najboljeg brašna, zamiješena u četvrtini hina ulja. ");
INSERT INTO hrv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Uz paljenicu ili uz klanicu prinesi čevrtinu hina vina za ljevanicu na svako janje. ");
INSERT INTO hrv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Povrh ovna prinesi kao prinosnicu dvije desetine efe najboljeg brašna, zamiješena u jednoj trećini hina ulja; ");
INSERT INTO hrv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","i vina za ljevanicu prinesi trećinu hina na ugodan miris Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ako Jahvi prinosiš junca kao paljenicu ili kao klanicu da izvršiš zavjet ili kao pričesnicu, ");
INSERT INTO hrv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","neka se onda uz junca prinesu tri desetine efe najboljeg brašna, zamiješena u pola hina ulja, ");
INSERT INTO hrv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","a za ljevanicu prinesi pola hina vina kao paljenu žrtvu na ugodan miris Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Neka se tako postupi uza svakoga vola i uza svakoga ovna, uza svaku glavu sitne stoke, ovce ili koze: ");
INSERT INTO hrv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","koliko ih god prinesete, za svako pojedino tako učinite, već prema njihovu broju. ");
INSERT INTO hrv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Svaki domorodac neka postupa ovako kad prinosi žrtvu paljenu na ugodan miris Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","I ako koji stranac koji živi među vama, ili će biti među vašim potomcima, htjedne prinijeti žrtvu paljenu na ugodan miris Jahvi, neka radi kako i vi radite. ");
INSERT INTO hrv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Neka je jedan zakon i za vas i za stranca koji s vama boravi. To je trajan zakon za vaše naraštaje: pred Jahvom, kako je s vama, tako neka bude i sa strancem. ");
INSERT INTO hrv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Jedan zakon i jedno pravo neka vrijedi za vas i za stranca koji s vama boravi.'” ");
INSERT INTO hrv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Govori Izraelcima i reci im: 'Kad dođete u zemlju u koju vas vodim ");
INSERT INTO hrv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","i budete jeli kruh te zemlje, prinesite podizanicu Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Kao prvinu iz svojih naćava prinesite jedan kolač kao podizanicu; prinesite ga kao i podizanicu s gumna. ");
INSERT INTO hrv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Od prvine svojih naćava davajte Jahvi podizanicu od naraštaja do naraštaja.'” ");
INSERT INTO hrv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Ako nehotice pogriješite te ne budete obdržavali koju od zapovijedi što ih je Jahve objavio po Mojsiju - ");
INSERT INTO hrv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","sve što vam je Jahve zapovjedio po Mojsiju, odonda kad vam je izdao zapovijedi pa dalje od koljena do koljena - ");
INSERT INTO hrv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","onda: ako je to počinjeno nepažnjom zajednice, neka sva zajednica prinese jednoga junca kao paljenicu na ugodan miris Jahvi s propisanom prikaznicom i ljevanicom i jednoga jarca kao okajnicu. ");
INSERT INTO hrv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Neka svećenik obavi obred pomirenja nad svom izraelskom zajednicom, pa će im biti oprošteno. Bila je samo nepažnja, a oni su prinijeli svoj dar - paljenu žrtvu Jahvi - i okajnicu pred Jahvom za svoju nepažnju. ");
INSERT INTO hrv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Bit će oprošteno svoj izraelskoj zajednici, a tako i strancu koji među njima boravi, jer se sav narod iz nepažnje ogriješio. ");
INSERT INTO hrv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Pogriješi li iz nepažnje pojedinac, neka prinese jedno žensko kozle od godine dana kao okajnicu. ");
INSERT INTO hrv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Neka svećenik obavi obred pomirenja pred Jahvom nad osobom koja je nehotice pogriješila od nepažnje. Kad nad njom obavi obred pomirenja, bit će joj oprošteno. ");
INSERT INTO hrv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Kada tko pogriješi nepažnjom, neka vam jedan zakon vrijedi i za domoroca i za stranca koji boravi među vama. ");
INSERT INTO hrv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ali onaj koji nešto učini naumice, bio on domorodac ili stranac, taj na Jahvu huli. Takav neka se istrijebi između svoga naroda ");
INSERT INTO hrv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","jer je prezreo Jahvinu riječ i prekršio njegovu zapovijed. Neka se takav iskorijeni. Neka njegova krivnja padne na nj!” ");
INSERT INTO hrv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Kad su Izraelci bili u pustinji, nađu čovjeka kako kupi drva u subotnji dan. ");
INSERT INTO hrv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","I oni koji su ga našli da kupi drva dovedu ga Mojsiju i Aronu i svoj zajednici. ");
INSERT INTO hrv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Stave ga pod stražu, jer još nije bilo određeno što treba s njim učiniti. ");
INSERT INTO hrv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","“Toga čovjeka treba pogubiti!” - reče Jahve Mojsiju. “Neka ga kamenjem zaspe izvan tabora sva zajednica.” ");
INSERT INTO hrv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Sva ga zajednica izvede izvan tabora i zasu ga kamenjem te on poginu, kako je Jahve zapovjedio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Reče Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Govori Izraelcima i reci im: neka od naraštaja do naraštaja prave rese na skutovima svojih haljina, a za resu svakoga skuta neka privezuju ljubičastu vrpcu. ");
INSERT INTO hrv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Imat ćete rese zato da vas pogled na njih sjeća svih Jahvinih zapovijedi. Vršite ih, a ne zanosite se svojim srcem i svojim očima, što vas tako lako zavode na bludnost. ");
INSERT INTO hrv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Tako ćete se sjećati svih mojih zapovijedi, vršit ćete ih i bit ćete posvećeni svome Bogu. ");
INSERT INTO hrv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ja sam Jahve, Bog vaš, koji sam vas izveo iz zemlje egipatske da vam budem Bogom. Ja, Jahve, Bog vaš.” ");
INSERT INTO hrv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Korah, sin Jisharov, sin Kehatov, sin Levijev, pa Datan i Abiram, sinovi Eliabovi, i On, sin Peletov - potomci Rubenovi - ");
INSERT INTO hrv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ustanu protiv Mojsija zajedno sa dvjesta pedeset Izraelaca, glavara zajednice, uglednih na skupštini i ljudi na glasu. ");
INSERT INTO hrv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Oni se sjate oko Mojsija i Arona govoreći im: “Vi prelazite mjeru! Sva je zajednica, svi njezini članovi, posvećena i među njima je Jahve. Zašto se onda uzvisujete iznad zajednice Jahvine!” ");
INSERT INTO hrv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Kad to ču Mojsije, pade ničice. ");
INSERT INTO hrv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Zatim reče Korahu i svoj njegovoj družini: “Sutra će Jahve pokazati tko je njegov i tko je posvećen, kome dopušta da mu se približi. Koga sebi izabere, k sebi će ga i pustiti. ");
INSERT INTO hrv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Učinite ovo: uzmite kadionike, Korah i sva njegova družina; ");
INSERT INTO hrv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","sutra stavite u njih vatre i metnite odozgo tamjana pred Jahvom. Koga Jahve odabere, taj neka bude posvećen. Vi prelazite mjeru, Levijevci!” ");
INSERT INTO hrv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Potom Mojsije reče Korahu: “Poslušajte, Levijevci! ");
INSERT INTO hrv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Zar vam je malo što vas je Bog Izraelov izdvojio iz Izraelove zajednice da vas približi k sebi te da vršite službu u Jahvinu prebivalištu i da stojite pred zajednicom služeći joj? ");
INSERT INTO hrv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Promaknuo je tebe i s tobom svu tvoju braću Levijevce, a vi još tražite i svećeništvo! ");
INSERT INTO hrv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ti i sva tvoja družina, dakle, sjatili ste se protiv Jahve; jer što je Aron da protiv njega rogoborite?” ");
INSERT INTO hrv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Zatim posla Mojsije po Datana i Abirama, sinove Eliabove, ali oni odgovore: “Nećemo doći! ");
INSERT INTO hrv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Zar je malo što si nas odveo iz zemlje kojom teče med i mlijeko da nas pobiješ u ovoj pustinji, pa hoćeš da nasilno zagospodariš nad nama? ");
INSERT INTO hrv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Nisi nas uveo u zemlju kojom teče med i mlijeko i nisi nam dao u posjed njive i vinograde! Misliš li iskopati oči ovim ljudima? Nećemo doći!” ");
INSERT INTO hrv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mojsije se vrlo razljuti i reče Jahvi: “Ne obaziri se na njihovu prinosnicu! Ni jednoga njihova magarca nisam prisvojio niti sam ijednoga od njih oštetio.” ");
INSERT INTO hrv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Zatim Mojsije reče Korahu: “Ti i sva tvoja družina stupite sutra pred Jahvu; ti, i oni, i Aron. ");
INSERT INTO hrv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Neka svaki uzme svoj kadionik, stavi u nj tamjana i neka svaki donese svoj kadionik pred Jahvu - dvjesta i pedeset kadionika. A i ti i Aron donesite svaki svoj kadionik.” ");
INSERT INTO hrv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Svaki uzme svoj kadionik, stavi u nj vatre, onda odozgo metne tamjana i stane s Mojsijem i Aronom kod ulaza u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kad, naprama njima, sabra Korah svu zajednicu na ulazu u Šator sastanka, onda se svoj zajednici pokaza slava Jahvina. ");
INSERT INTO hrv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","I reče Jahve Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Odvojite se od te zajednice da je odmah satrem!” ");
INSERT INTO hrv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Oni popadoše ničice i povikaše: “Bože! Bože životnog duha u svakome tijelu! Zar ćeš se razgnjeviti na svu zajednicu kad je samo jedan sagriješio!” ");
INSERT INTO hrv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Onda Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Reci toj zajednici: 'Uklonite se iz okolice prebivališta Koraha, Datana i Abirama!'” ");
INSERT INTO hrv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mojsije ustade i pođe k Datanu i Abiramu. Za njim krenuše izraelske starješine. ");
INSERT INTO hrv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Zatim ovako progovori zajednici: “Odstupite od šatora tih opakih ljudi! Ne dotičite se ničega što je njihovo, da ne budete uništeni zbog svih njihovih grijeha.” ");
INSERT INTO hrv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Tako se oni udalje iz okolice prebivališta Korahova, Datanova i Abiramova. Uto izađu Datan i Abiram te stanu na ulazu svojih šatora sa svojim ženama, svojim sinovima i svojom nejačadi. ");
INSERT INTO hrv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","“Po ovom ćete vidjeti”, reče Mojsije, “da me Jahve poslao da vršim sva ova djela, a da ih ne činim sam od sebe: ");
INSERT INTO hrv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ako ovi ljudi umru kao što umru i svi ljudi; ako ih pohodi sudbina kakva pohodi sve ljude, onda me Jahve nije poslao. ");
INSERT INTO hrv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ali ako Jahve učini nečuveno: ako zemlja rastvori svoje ralje i proguta ih sa svim što je njihovo te živi siđu u Šeol, onda znajte da su ovi ljudi prezreli Jahvu.” ");
INSERT INTO hrv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","A kad on završi sve te riječi, tlo se pod njima raspukne; ");
INSERT INTO hrv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","zemlja rastvori svoje ralje i proguta ih s njihovim domovima, sa svim Korahovim ljudima i svim njihovim imanjem. ");
INSERT INTO hrv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Živi siđu u Šeol, oni i sve njihovo. Onda se nad njima zemlja zatvori i oni iščeznu iz zbora. ");
INSERT INTO hrv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Na njihov vrisak svi Izraelci što su stajali oko njih pobjegoše govoreći: “Da i nas zemlja ne proguta!” ");
INSERT INTO hrv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ali sukne oganj od Jahve te proždre dvjesta i pedeset ljudi koji su prinosili tamjan. ");
INSERT INTO hrv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Kaži Eleazaru, sinu svećenika Arona, da ukloni kadionike - jer su posvećeni - iz toga zgarišta, a neposvećenu vatru iz njih neka razaspe podalje. ");
INSERT INTO hrv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Kadionici onih koji su sagriješili i grijehom život pokopali neka se prekuju u pločice za oblaganje žrtvenika. Doneseni su, naime, pred Jahvu, pa su posvećeni. Neka budu opomenom Izraelcima!” ");
INSERT INTO hrv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Tako svećenik Eleazar uze kadionike od tuča što su ih prinosili oni koji izgorješe; prekovaše ih u pločice za oblaganje žrtvenika. ");
INSERT INTO hrv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","One su opomena Izraelcima da se nitko nepozvan - nitko tko nije od Aronova potomstva - ne smije približiti da pali tamjan pred Jahvom, kako mu se ne bi dogodilo kao Korahu i njegovoj družini, prema onom što je kazao Jahve po Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Sutradan je sva zajednica rogoborila protiv Mojsija i Arona. “Pobili ste Jahvin narod!” - govorili su. ");
INSERT INTO hrv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Dok se zajednica skupljala protiv Mojsija i Arona, oni se okrenuše prema Šatoru sastanka, i gle! oblak ga prekri i slava se Jahvina pokaza. ");
INSERT INTO hrv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Tada Mojsije i Aron odoše pred Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","I Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","“Udaljite se od te zajednice; u tili ću je čas uništiti!” Oni padoše ničice. ");
INSERT INTO hrv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Zatim Mojsije reče Aronu: “Uzmi kadionik, stavi u nj vatre sa žrtvenika, metni tamjana, a onda se žuri do zajednice da obaviš nad njom obred pomirenja. Gnjev je Jahvin već izbio i zlo je počelo!” ");
INSERT INTO hrv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aron uze što mu je Mojsije rekao te otrča usred zbora, a kad tamo: pomor među narodom već počeo. Stavi tamjana te obavi obred pomirenja nad narodom. ");
INSERT INTO hrv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Zatim stade između mrtvih i živih i zlo se ustavi. ");
INSERT INTO hrv_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Bilo ih je mrtvih od toga zla četrnaest tisuća i sedam stotina, osim onih koji su poginuli zbog Koraha. ");
INSERT INTO hrv_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Aron se vrati k Mojsiju na ulaz u Šator sastanka: pomor se ustavi. ");
INSERT INTO hrv_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","“Razloži Izraelcima te od njih uzmi po jedan štap za svaki predjedovski dom; uzmi od svih njihovih starješina za njihove pradjedovske domove dvanaest štapova. Ime svakoga napiši na njegovu štapu. ");
INSERT INTO hrv_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","A kako ima po jedan štap za svakoga starješinu pradjedovskih domova, Aronovo ime napiši na Levijevu štapu. ");
INSERT INTO hrv_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Onda ih pohrani u Šator sastanka pred Svjedočanstvo; ondje gdje se s tobom sastajem. ");
INSERT INTO hrv_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Štap onoga čovjeka koga izaberem propupat će. Tako ću maknuti od sebe rogoborenje Izraelaca kojim prigovaraju vama.” ");
INSERT INTO hrv_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Mojsije tako kaza Izraelcima. Sve njihove starješine dadoše mu štap, po jedan štap za svakoga starješinu - dakle, dvanaest štapova za njihove pradjedovske domove. Među njihovim štapovima bio je i štap Aronov. ");
INSERT INTO hrv_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Mojsije pohrani štapove pred Jahvu u Šatoru svjedočanstva. ");
INSERT INTO hrv_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Kad sutradan Mojsije uđe u Šator svjedočanstva, gle: štap Arona iz doma Levijeva propupao! Potjerala mladica, procvjetao cvijet i sazreli bademi. ");
INSERT INTO hrv_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Tada iznese Mojsije ispred Jahve sve štapove sinovima Izraelovim. Oni ih razgledaše, a onda svatko uze svoj štap. ");
INSERT INTO hrv_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Jahve reče Mojsiju: “Opet stavi Aronov štap pred Svjedočanstvo, neka se čuva za znak buntovnim sinovima. Dokončaj tako njihovo rogoborenje protiv mene da ne izginu.” ");
INSERT INTO hrv_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","I učini Mojsije: kako mu je Jahve zapovjedio, tako učini. ");
INSERT INTO hrv_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","“Izgibosmo!” - rekoše Izraelci Mojsiju. “Propadosmo! Svi odreda propadosmo! ");
INSERT INTO hrv_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Tko god priđe Jahvinu prebivalištu, umire ... Zar ćemo svi izginuti?” ");
INSERT INTO hrv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Tada Jahve reče Aronu: “Ti, tvoji sinovi i tvoj pradjedovski dom s tobom bit ćete odgovorni za grijehe u Svetištu; ti i tvoji sinovi s tobom bit ćete odgovorni za grijehe svoga svećeništva. ");
INSERT INTO hrv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Pridruži k sebi i svoju braću od Levijeva plemena - tvoga pradjedovskog doma - neka ti se priključe da ti poslužuju, tebi i tvojim sinovima s tobom, pred Šatorom svjedočanstva. ");
INSERT INTO hrv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Neka stoje na službu tebi i svemu Šatoru, ali neka se ne približuju pokućstvu u Svetištu niti žrtveniku, da ne poginu i oni i vi. ");
INSERT INTO hrv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Neka su, dakle, tebi pridruženi i neka preuzmu brigu za Šator sastanka, svaku službu oko Šatora. I neka se ni jedan svjetovnjak ne približuje vama, ");
INSERT INTO hrv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","a vi vršite službu u Svetištu i službu oko žrtvenika da se više ne izlijeva gnjev na Izraelce. ");
INSERT INTO hrv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Uzeh, evo, vašu braću levite između Izraelaca vama za dar; kao darovani pripadaju Jahvi da obavljaju službu oko Šatora sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ti i tvoji sinovi s tobom preuzmite svećeničke poslove oko svega što spada na žrtvenik i iza zavjese. Službu koju dajem na dar vašem svećeništvu vi obavljajte. A svjetovnjak koji se primakne neka se pogubi.” ");
INSERT INTO hrv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Još reče Jahve Aronu: “Tebi, evo, povjeravam brigu o onom što se meni prinosi. Sve što Izraelci posvećuju dodjeljujem tebi i tvojim sinovima kao baštinu trajnim zakonom. ");
INSERT INTO hrv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ovo neka pripadne tebi od svetinja nad svetinjama: od paljenih žrtava svi njihovi darovi, za sve njihove prinosnice, za sve njihove okajnice i za sve njihove naknadnice što ih budu meni uzvraćali; ta vrlo sveta stvar neka pripadne tebi i tvojim sinovima! ");
INSERT INTO hrv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Blagujte ih kao najveće svetinje! Svaki muškarac može ih jesti. Neka ti budu svete! ");
INSERT INTO hrv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","I ovo neka bude za te: ono što se uzima od izraelskih prinosa da se prinese kao prikaznica - trajnim zakonom predajem tebi, tvojim sinovima i tvojim kćerima s tobom. Svatko tko u tvome domu bude čist može od toga jesti. ");
INSERT INTO hrv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Najbolje od novoga ulja i najbolje od novoga vina i žita - prvine koje se prinose Jahvi - predajem tebi. ");
INSERT INTO hrv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Prvi rodovi svega u njihovoj zemlji što ih budu donosili Jahvi neka budu tvoji. Tko je god čist u tvome domu može ih jesti. ");
INSERT INTO hrv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Sve što u Izraelu bude određeno za 'herem' neka je tvoje. ");
INSERT INTO hrv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Svako prvorođenče svih bića - kako ljudi tako i životinja - što se prinose Jahvi neka bude tvoje. Samo pusti da se otkupi prvenac od ljudi i prvenče od nečiste stoke. ");
INSERT INTO hrv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Kad budu stari mjesec dana, pusti da ih otkupljuju. A njihovu otkupnu cijenu odredi: pet srebrnih šekela, prema hramskom šekelu, a to je dvadeset gera. ");
INSERT INTO hrv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ali prvenče kravlje, prvenče ovčje i prvenče kozje neka se ne otkupljuje. Oni su svetinja. Krv njihovu izlij na žrtvenik, a pretilinu njihovu sažeži u kad kao žrtvu spaljenu na ugodan miris Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Njihovo meso neka pripadne tebi; kao i grudi žrtve prikaznice i desno pleće. ");
INSERT INTO hrv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Sve posvećene prinose što ih Izraelci podižu Jahvi predajem trajnim zakonom tebi, tvojim sinovima i tvojim kćerima s tobom. To je savez osoljen, trajan pred Jahvom, tebi i tvome potomstvu s tobom.” ");
INSERT INTO hrv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","“Nemoj imati baštine u zemlji njihovoj”, reče Jahve Aronu, “niti sebi stječi posjeda među njima! Ja sam tvoj dio i tvoja baština među Izraelcima.” ");
INSERT INTO hrv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Levijevim sinovima, evo, predajem u baštinu sve desetine u Izraelu za njihovu službu - za službu što je obavljaju u Šatoru sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","A Izraelci neka se više ne primiču Šatoru sastanka, da ne navuku na se grijeh i ne poginu. ");
INSERT INTO hrv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Neka samo leviti obavljaju službu u Šatoru sastanka; i neka oni budu odgovorni za svoj grijeh. Trajna je to odredba za vaše naraštaje; među Izraelcima neka nemaju posjeda, ");
INSERT INTO hrv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","jer ja im predajem u posjed desetine što ih Izraelci prinose na dar Jahvi. Stoga sam za njih rekao: neka oni nemaju posjeda među Izraelcima.” ");
INSERT INTO hrv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Levitima govori i reci im: 'Kad od Izraelaca primate desetinu, koju ja od njih dajem vama u baštinu, od toga onda vi prinesite podizanicu Jahvi: desetinu od desetine. ");
INSERT INTO hrv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Prinos će vam biti zaračunan kao da je prinos s gumna i Óotoka iz badnja. ");
INSERT INTO hrv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Tako isto prinosite podizanicu Jahvi i od svih svojih desetina što ih primate od Izraelaca. Od toga davajte podizanicu Jahvinu svećeniku Aronu. ");
INSERT INTO hrv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Od svih darova koje budete primali podižite podizanicu Jahvi; od svega ono najbolje - onaj dio koji treba posvećivati.' ");
INSERT INTO hrv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Još im reci: 'Pošto od toga prinesete najbolji dio, neka se to levitima uračuna kao prihod s gumna i prihod iz badnja. ");
INSERT INTO hrv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Na svakome ga mjestu možete jesti, i vi i vaši ukućani, jer to vam je nagrada za vašu službu u Šatoru sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Pošto prinesete njegov najbolji dio, nećete navući na se grijeha; svetinja Izraelaca nećete oskvrnjivati te nećete ginuti.'” ");
INSERT INTO hrv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Jahve reče Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ovo je zakonska odredba što ju je Jahve naredio: Reci Izraelcima neka ti dovedu crvenu junicu, zdravu, na kojoj nema mane i na koju još nije stavljan jaram. ");
INSERT INTO hrv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","A vi je predajte svećeniku Eleazaru. Neka se zatim izvede izvan tabora i zakolje pred njim. ");
INSERT INTO hrv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Svećenik Eleazar neka uzme njezine krvi na svoj prst pa njome poškropi sedam puta prema pročelju Šatora sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Neka se onda junica spali na njegove oči; neka joj se spale: koža, meso, krv i nečist. ");
INSERT INTO hrv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Potom neka svećenik uzme cedrovine, izopa i crvenoga prediva pa ih baci usred vatre gdje se krava spaljuje. ");
INSERT INTO hrv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Neka svećenik opere svoju odjeću, a svoje tijelo u vodi okupa. Poslije toga neka se svećenik vrati u tabor, ali neka je nečist do večeri. ");
INSERT INTO hrv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","I onaj koji ju je spaljivao neka svoju odjeću opere i okupa svoje tijelo u vodi te bude nečist do večeri. ");
INSERT INTO hrv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","A jedan čist čovjek neka pokupi pepeo od junice pa ga pohrani izvan tabora na čisto mjesto da se čuva izraelskoj zajednici za vodu očišćenja. To je žrtva okajnica. ");
INSERT INTO hrv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","I onaj koji skupi pepeo od junice neka opere svoju odjeću i bude nečist do večeri. Neka to bude trajan zakon i za Izraelce i za stranca koji među njima boravi.” ");
INSERT INTO hrv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Tko se dotakne mrtva ljudskog tijela neka je nečist sedam dana. ");
INSERT INTO hrv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Takav neka se opere tom vodom trećega dana i sedmoga dana pa će biti čist. Ako se ne opere trećega dana i sedmoga dana, neće biti čist. ");
INSERT INTO hrv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Tko se dotakne mrtvaca, tijela preminula čovjeka, a ne opere se, oskvrnjuje Jahvino prebivalište. Takav neka se iskorijeni iz Izraela. Budući da vodom za očišćenje nije bio poliven, nečist je; njegova je nečistoća još na njemu.” ");
INSERT INTO hrv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Ovo je zakon kad koji čovjek umre u šatoru; tko god uđe u šator i tko god bude u šatoru neka je nečist sedam dana. ");
INSERT INTO hrv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Svaka otvorena posuda koja ne bude zatvorena poklopcem neka je nečista. ");
INSERT INTO hrv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","A na otvorenu polju tko se god dotakne poginuloga od mača, ili mrtvaca, ili ljudskih kostiju, ili groba neka je nečist sedam dana. ");
INSERT INTO hrv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Neka se za onoga koji se onečistio uzme pepela od životinje spaljene za okajnicu i na nj, u kakvu sudu, nalije žive vode. ");
INSERT INTO hrv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Onda neka čist čovjek uzme izopa, zamoči ga u vodu te poškropi po šatoru, po svemu posuđu, po ljudima koji su tu bili, po onome koji se dotakao kostiju, ili ubijenoga, ili preminuloga, ili groba. ");
INSERT INTO hrv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Neka čisti čovjek škropi nečistoga trećega i sedmoga dana. Tako će ga na sedmi dan očistiti. Taj onda neka opere svoju odjeću, okupa se u vodi i neka je navečer čist. ");
INSERT INTO hrv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","A bude li tko nečist pa se ne očisti, neka se iskorijeni iz zajednice, jer je oskvrnuo Jahvino svetište; vodom za očišćenje nije bio poliven; nečist je! ");
INSERT INTO hrv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Neka im i ovo bude trajnim zakonom: i onaj koji je škropio vodom za očišćenje neka opere svoju odjeću; i onaj koji je dirnuo vodu za očišćenje neka je nečist do večeri. ");
INSERT INTO hrv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Čega se god nečisti dotakne neka je nečisto; a osoba koja se njega dotakne neka je nečista do večeri.” ");
INSERT INTO hrv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Potom stigoše Izraelci, sva zajednica, u pustinju Sin u prvome mjesecu. Narod se nastani u Kadešu. Ondje umrije Mirjam i ondje je sahraniše. ");
INSERT INTO hrv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Nije bilo vode za zajednicu. Stoga se udruže protiv Mojsija i protiv Arona. ");
INSERT INTO hrv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Narod se poče svađati s Mojsijem i govoriti: “Da smo bar izginuli kad su nam i braća poginula pred Jahvom! ");
INSERT INTO hrv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Zašto ste doveli Jahvinu zajednicu u ovu pustinju da ovdje pomremo i mi i naša stoka? ");
INSERT INTO hrv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Zašto ste nas izveli iz Egipta da nas dovedete u ovo nesretno mjesto; mjesto u kojem nema ni žita, ni smokava, ni loze, ni mogranja? Nema ni vode da pijemo.” ");
INSERT INTO hrv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mojsije i Aron odu ispred zajednice do ulaza u Šator sastanka i padnu ničice. Tada im se pokaza slava Jahvina. ");
INSERT INTO hrv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","I Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Uzmi štap pa ti i tvoj brat Aron skupite zajednicu. Onda, na njihove oči, progovorite pećini da ustupi svoje vode. Iz pećine im izvedi vodu te napoj zajednicu i njezino blago.” ");
INSERT INTO hrv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mojsije uzme štap ispred Jahve kako mu je naredio. ");
INSERT INTO hrv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Zatim Mojsije i Aron skupe zbor pred pećinu pa im Mojsije rekne: “Čujte, buntovnici! Hoćemo li vam iz ove pećine izvesti vodu?” ");
INSERT INTO hrv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Zatim Mojsije podigne ruku i dvaput udari štapom o pećinu: voda provali u obilju, pa su mogli piti i zajednica i njezino blago. ");
INSERT INTO hrv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Potom će Jahve Mojsiju i Aronu: “Budući da se niste pouzdavali u me i niste me svetim očitovali u očima sinova Izraelovih, nećete uvesti ovaj zbor u zemlju koju im dajem.” ");
INSERT INTO hrv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","To su Meripske vode, kraj njih su se Izraelci prepirali s Jahvom, a on se pokazao svetim. ");
INSERT INTO hrv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Iz Kadeša pošalje Mojsije glasnike: “Kralju Edoma. Ovako veli tvoj brat Izrael: 'Ti znaš sve jade koji su nas snašli. ");
INSERT INTO hrv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Naši se preci spustiše u Egipat. U Egiptu smo proboravili mnogo vremena. Egipćani su s nama i s našim precima loše postupali. ");
INSERT INTO hrv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Stoga smo vapili Jahvi, i on ču naš glas i posla anđela koji nas izbavi iz Egipta. Evo nas sad u Kadešu, gradu uz rub tvoga područja. ");
INSERT INTO hrv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Pusti nas da prođemo kroz tvoju zemlju. Nećemo ići preko polja ni vinograda niti ćemo piti vodu iz bunara; ići ćemo Kraljevskim putem, ne skrećući ni desno ni lijevo, dok ne prođemo tvoje područje.” ");
INSERT INTO hrv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom mu odgovori: “Ne prolazi preko moje zemlje, jer eto me s mačem preda te!” ");
INSERT INTO hrv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","“Ići ćemo utrenikom”, rekoše Izraelci, “a budemo li pili tvoje vode, mi i naša stada, za to ćemo ti platiti. Ništa više, samo da prođemo pješice.” ");
INSERT INTO hrv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","“Ne prolazi!” - odgovori. I Edom mu izađe u susret s mnogo ljudi i s velikom silom. ");
INSERT INTO hrv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Tako Edom nije dopustio Izraelu da prođe kroz njegovo područje i Izrael se okrenu od njega. ");
INSERT INTO hrv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Zaputivši se od Kadeša, stigoše Izraelci, sva zajednica, k brdu Horu. ");
INSERT INTO hrv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Kod brda Hora, uz među edomsku, reče Jahve Mojsiju i Aronu: ");
INSERT INTO hrv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Neka se Aron pridruži svojim precima! Neće ući u zemlju koju dajem Izraelcima, jer ste se oprli mojoj zapovijedi kod Meripskih voda. ");
INSERT INTO hrv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Uzmi Arona i njegova sina Eleazara, pa ih izvedi na brdo Hor. ");
INSERT INTO hrv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","I svuci Aronu njegove haljine pa ih obuci njegovu sinu Eleazaru. Aron će se pridružiti precima, umrijet će ondje.” ");
INSERT INTO hrv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mojsije učini kako naredi Jahve. Pred svom zajednicom popeše se na brdo Hor. ");
INSERT INTO hrv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mojsije svuče s Arona njegove haljine te ih obuče njegovu sinu Eleazaru. Ondje navrh brda umrije Aron. Zatim se Mojsije i Eleazar spustiše s brda. ");
INSERT INTO hrv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Sva zajednica vidje da je Aron preminuo i sav dom Izraelov oplakivaše Arona trideset dana. ");
INSERT INTO hrv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kralj Arada, Kanaanac koji je živio u Negebu, ču da Izrael dolazi Atarimskim putem, pa navali na Izraela i neke njegove zarobi. ");
INSERT INTO hrv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Tada se Izrael ovako zavjetova Jahvi: “Ako u moje ruke izručiš ovaj narod, potpuno ću uništiti njegove gradove.” ");
INSERT INTO hrv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Jahve usliša glas Izraela i predade mu Kanaance. A Izrael njih i njihove gradove 'heremom' uništi. Stoga se ono mjesto prozva Horma. ");
INSERT INTO hrv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Od brda Hora zapute se prema Crvenom moru da zaobiđu zemlju edomsku. Narod putem postane nestrpljiv. ");
INSERT INTO hrv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","I počne govoriti i protiv Boga i protiv Mojsija: “Zašto nas izvedoste iz Egipta da pomremo u ovoj pustinji? Nema kruha, nema vode, a to bijedno jelo već se ogadilo dušama našim.” ");
INSERT INTO hrv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Onda Jahve pošalje na narod ljute zmije; ujedale ih one, tako te pomrije mnogo naroda u Izraelu. ");
INSERT INTO hrv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Dođe narod k Mojsiju pa reče: “Sagriješili samo kad smo govorili protiv Jahve i protiv tebe. Pomoli se Jahvi da ukloni zmije od nas!” Mojsije se pomoli za narod, ");
INSERT INTO hrv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","i Jahve reče Mojsiju: “Napravi otrovnicu i stavi je na stup: tko god bude ujeden, ostat će na životu ako je pogleda.” ");
INSERT INTO hrv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mojsije napravi zmiju od mjedi i postavi je na stup. Kad bi koga ujela ljutica, pogledao bi u mjedenu zmiju i ozdravio. ");
INSERT INTO hrv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Pođu Izraelci i utabore se u Obotu. ");
INSERT INTO hrv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Potom se zapute iz Obota i utabore se kraj Ije-Abarima, u pustinji što je nasuprot Moabu, sa strane sunčeva izlaska. ");
INSERT INTO hrv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Odande otputuju te se utabore u dolini Zaredu. ");
INSERT INTO hrv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Odande krenu i utabore se s onu stranu Arnona, koji je u pustinji a izvire u području Amorejaca. Jer je Arnon granica moapska između Moabaca i Amorejaca. ");
INSERT INTO hrv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Zato se veli u “Knjizi Jahvinih vojni”: “Vaheb kod Sufe i doline arnonske ");
INSERT INTO hrv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","i padine doline što se naginje prema mjestu Aru i naslanja se na granicu moapsku ...” ");
INSERT INTO hrv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Odande odoše u Beer. To je bunar o kojem je Jahve rekao Mojsiju: “Skupi narod da im dam vode!” ");
INSERT INTO hrv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Tada Izrael zapjeva ovu pjesmu: “Proključaj, studenče! A vi ga uznosite: ");
INSERT INTO hrv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","knezovi ga iskopali, prvaci narodni izdubli žezlom, štapom svojim.” Iz pustinje odu u Matanu, ");
INSERT INTO hrv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","iz Matane u Nahaliel, a iz Nahaliela u Bamot; ");
INSERT INTO hrv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","iz Bamota u dolinu što se stere u moapskom polju, prema vrhuncu Pisge, s koje se pruža vidik na pustaru. ");
INSERT INTO hrv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Sad Izrael posla glasnike Sihonu, amorejskome kralju, s porukom: ");
INSERT INTO hrv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Pusti da prođem preko tvoje zemlje. Nećemo zalaziti u polja i u vinograde, niti ćemo piti vode iz bunara. Ići ćemo Kraljevskim putem dok ne prođemo tvoje područje.” ");
INSERT INTO hrv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ali Sihon ne dopusti Izraelu da prođe njegovim područjem, nego skupi sav svoj narod te izađe u pustinju da presretne Izraelce. Stigavši do Jahze, zavojuje na Izraela. ");
INSERT INTO hrv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ali ga Izrael potuče oštrim mačem i osvoji njegovu zemlju od Arnona do Jaboka, do Amonaca, jer je Az ležao na granici Amonaca. ");
INSERT INTO hrv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Izrael zauzme sve one gradove i Izrael se nastani u svim onim gradovima Amorejaca; u Hešbonu i svim njegovim naseljima. ");
INSERT INTO hrv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Kako je Hešbon bio glavni grad Sihona, amorejskog kralja, koji je ratovao protiv prijašnjega moapskoga kralja te osvojio svu njegovu zemlju do Arnona, ");
INSERT INTO hrv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","kažu zato pjesnici: “Hrabro, o Hešbone, dobro sazdani, čvrsto posađeni grade Sihonov! ");
INSERT INTO hrv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Iz Hešbona oganj suknu, plamen iz grada Sihonova, sažga Ar moapski, proždrije visove arnonske. ");
INSERT INTO hrv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Teško tebi, Moabe! Propao si, narode Kemošev! Od sinova bjegunce učini, a od kćeri svojih ropkinje Sihonu, kralju amorejskom. ");
INSERT INTO hrv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Pobili smo ih; propao je Hešbon do Dibona: sve smo razorili do Nofaha, što je blizu Medebe ...” ");
INSERT INTO hrv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Tako se Izrael nastani u zemlji Amorejaca. ");
INSERT INTO hrv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mojsije se uputi da izvidi Jazer. Potom zauzmu njegova naselja a rastjeraju Amorejce koji bijahu ondje. ");
INSERT INTO hrv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Okrenu se onda i pođu prema Bašanu. A bašanski kralj Og presrete ih sa svim svojim narodom da zapodjene boj kod Edreja. ");
INSERT INTO hrv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ali Jahve reče Mojsiju: “Ne boj ga se! Predao sam u tvoje ruke njega, sav njegov narod i njegovu zemlju. Postupi s njim kako si postupio s amorejskim kraljem Sihonom koji je boravio u Hešbonu.” ");
INSERT INTO hrv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","I potukoše ga, i sinove njegove, i sav njegov narod, tako da nitko ne uteče. Potom zaposjedoše njegovu zemlju. ");
INSERT INTO hrv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Poslije toga Izraelci otputuju i utabore se na Moapskim poljanama, s onu stranu Jordana, nasuprot Jerihonu. ");
INSERT INTO hrv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, sin Siporov, vidje sve što Izrael učini Amorejcima. ");
INSERT INTO hrv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moab se uvelike poboja toga naroda jer je bio brojan. Moaba obuze strah od Izraelaca. ");
INSERT INTO hrv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Zato reče Moab midjanskim starješinama: “Sad će ova rulja oko nas sve popasti kao što vol popase travu po polju.” Balak, sin Siporov, bijaše moapski kralj u ono vrijeme. ");
INSERT INTO hrv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","On pošalje glasnike Bileamu, sinu Beorovu, u Petoru, koji se nalazi na Rijeci, u zemlji Amonaca. Pozove ga rekavši: “Evo je došao neki narod iz Egipta; evo je prekrio lice zemlje i naselio se uza me. ");
INSERT INTO hrv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Zato dođi i prokuni mi ovaj narod jer je jači od mene. Tako ću ga moći svladati i istjerati iz zemlje. A znam da je blagoslovljen onaj koga blagosloviš, a proklet onaj koga prokuneš.” ");
INSERT INTO hrv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Starješine moapske i starješine midjanske krenu s nagradom za vračanje u svojim rukama. Stignu Bileamu i prenesu mu Balakovu poruku. ");
INSERT INTO hrv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","On im rekne: “Prenoćite ovdje te ću vam odgovoriti prema onome što mi Jahve kaže.” Tako moapski knezovi ostanu kod Bileama. ");
INSERT INTO hrv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Bog dođe Bileamu i upita: “Tko su ti ljudi s tobom?” Bileam odgovori Bogu: ");
INSERT INTO hrv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","“Poslao ih k meni Balak, sin Siporov, moapski kralj, s porukom: ");
INSERT INTO hrv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","'Evo je neki narod došao iz Egipta i prekrio lice zemlje. Dođi da ga prokuneš. Tako ću ga moći svladati i protjerati.'” ");
INSERT INTO hrv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ali Bog reče Bileamu: “Nemoj ići s njima! Nemoj proklinjati onaj narod jer je blagoslovljen.” ");
INSERT INTO hrv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ujutro Bileam ustane te će Balakovim knezovima: “Odlazite u svoju zemlju jer mi ne da Jahve da pođem s vama.” ");
INSERT INTO hrv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moapski se knezovi dignu, odu Balaku pa mu reknu: “Bileam nije htio poći s nama.” ");
INSERT INTO hrv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak opet pošalje knezove, brojnije i uglednije od prvih. ");
INSERT INTO hrv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Oni dođu Bileamu i reknu mu: “Ovako je poručio Balak, sin Siporov: 'Ne skanjuj se nego dođi k meni. ");
INSERT INTO hrv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Bogato ću te nagraditi i učinit ću sve što mi kažeš. Dođi, molim te, i prokuni mi ovaj narod!'” ");
INSERT INTO hrv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ali Bileam odgovori Balakovim slugama: “Da mi Balak dadne svoju kuću punu srebra i zlata, ne bih mogao prestupiti zapovijedi Jahve, Boga svoga, da učinim išta, bilo veliko bilo malo. ");
INSERT INTO hrv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ali provedite ovdje i vi noć da doznam što će mi Jahve još kazati.” ");
INSERT INTO hrv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Noću Bog dođe Bileamu pa mu rekne: “Ako su ti ljudi došli da te pozovu, ustani, pođi s njima! Ali da činiš samo što ti ja reknem!” ");
INSERT INTO hrv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ustane Bileam ujutro, osamari svoju magaricu i ode s moapskim knezovima. ");
INSERT INTO hrv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","No Božja srdžba usplamtje što je on pošao. Zato anđeo Jahvin stade na put da ga spriječi. On je jahao na svojoj magarici, a pratila ga njegova dva momka. ");
INSERT INTO hrv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kad magarica opazi anđela Jahvina kako stoji na putu s isukanim mačem u ruci, skrene sa staze i pođe preko polja. Bileam poče tući magaricu da je vrati na put. ");
INSERT INTO hrv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Anđeo Jahvin tada stade na uskom prolazu, među vinogradima, a bijaše ograda i s ove i s one strane. ");
INSERT INTO hrv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Magarica, spazivši Jahvina anđela, stisne se uza zid i o zid pritisne Bileamovu nogu. On je opet poče tući. ");
INSERT INTO hrv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Anđeo Jahvin pođe naprijed te stade na usko mjesto gdje nije bilo prostora da se provuče ni desno ni lijevo. ");
INSERT INTO hrv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Kad je magarica ugledala Jahvina anđela, legne pod Bileamom. Bileam pobjesni i poče tući magaricu štapom. ");
INSERT INTO hrv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Tada Jahve otvori usta magarici te ona progovori Bileamu: “Što sam ti učinila da si me tukao tri puta?” ");
INSERT INTO hrv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bileam odgovori magarici: “Što sa mnom zbijaš šalu! Da mi je mač u ruci, sad bih te ubio!” ");
INSERT INTO hrv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","A magarica uzvrati Bileamu: “Zar ja nisam tvoja magarica na kojoj si jahao svega svoga vijeka do danas? Jesam li ti običavala ovako?” - “Nisi!” - odgovori on. ");
INSERT INTO hrv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Tada Jahve otvori oči Bileamu i on opazi anđela Jahvina kako stoji na putu s golim mačem u ruci. Pognu on glavu i pade ničice. ");
INSERT INTO hrv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Onda će mu anđeo Jahvin: “Zašto si tukao svoju magaricu već tri puta? TÓa ja sam istupio da te spriječim, jer te put meni naočigled vodi u propast. ");
INSERT INTO hrv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Magarica me opazila i preda mnom se uklonila sva tri puta. Da mi se nije uklanjala, već bih te ubio, a nju ostavio na životu.” ");
INSERT INTO hrv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Onda će Bileam anđelu Jahvinu: “Sagriješio sam! Nisam znao da ti preda mnom stojiš na putu. Ali sad, ako je zlo u tvojim očima, ja ću se vratiti.” ");
INSERT INTO hrv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ali anđeo Jahvin odvrati Bileamu: “Idi s tim ljudima, ali samo ono govori što ti ja kažem.” Tako Bileam ode s Balakovim knezovima. ");
INSERT INTO hrv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kad je Balak čuo da Bileam dolazi, iziđe mu u susret do grada Moaba što se nalazi na granici Arnona, na kraju područja. ");
INSERT INTO hrv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","“Zar nisam uporno po te slao i pozivao te? Zašto mi nisi došao?” reče Balak Bileamu. “Zar te zaista ne mogu bogato nagraditi?” ");
INSERT INTO hrv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","“Evo sam ti došao”, reče Bileam Balaku. “Ali hoću li ti moći sada što kazati? Samo što mi Bog stavi na jezik, to ću govoriti.” ");
INSERT INTO hrv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Pođe zatim Bileam s Balakom i dođoše u Kirjat Husot. ");
INSERT INTO hrv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Žrtvova Balak i krupne i sitne stoke te od toga pruži Bileamu i knezovima koji su ga pratili. ");
INSERT INTO hrv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Sutradan uze Balak Bileama i odvede ga gore na Bamot-Baal, odakle mogaše vidjeti krajnji dio naroda. ");
INSERT INTO hrv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","I Bileam reče Balaku: “Ovdje mi načini sedam žrtvenika; ovdje mi pripravi sedam junaca i sedam ovnova.” ");
INSERT INTO hrv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak učini kako je Bileam rekao. A onda Balak i Bileam prinesu po jednoga junca i ovna na svakome žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Potom će Bileam Balaku: “Ti stoj kod svoje paljenice, a ja idem ne bih li se sreo s Jahvom, pa što mi očituje, kazat ću ti.” I ode na osamljeno mjesto. ");
INSERT INTO hrv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","I Bog srete Bileama, koji mu reče: “Sedam sam žrtvenika podigao i prinio na svakome po jednoga junca i ovna.” ");
INSERT INTO hrv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","A Jahve stavi riječi u usta Bileamu te mu zapovjedi: “Vrati se Balaku i ovako govori.” ");
INSERT INTO hrv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Bileam se vrati k njemu, a on stajaše uza svoju paljenicu i s njim svi knezovi moapski. ");
INSERT INTO hrv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Tada on poče svoju pjesmu i reče: “Iz Arama dovede me Balak, kralj Moaba, iz strana istočnih: 'Dođi, prokuni mi Jakova, dođi, gromom udri Izraela!' ");
INSERT INTO hrv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Kako mogu proklinjati koga Bog ne proklinje? Kako gromom udarati koga Jahve ne udara? ");
INSERT INTO hrv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Jer s vrha hridi ja ga gledam, s visoka ga motrim brijega. Gle naroda koji odvojeno živi, među narode on se ne broji. ");
INSERT INTO hrv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Prah Jakovljev tko će prebrojiti; pijesak Izraela tko će izmjeriti! O, da mi je umrijeti smrću pravednika! O, da svršetak moj bude kao njegov!” ");
INSERT INTO hrv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","“Što mi to uradi!” - reče Balak Bileamu. “Dovedoh te da prokuneš moje neprijatelje, a kad tamo, ti ih blagoslovom obasu!” ");
INSERT INTO hrv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","On odgovori: “Zar mi nije dužnost kazati što mi Jahve stavlja u usta?” ");
INSERT INTO hrv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","“Hajde sa mnom na drugo mjesto, odakle ga možeš svega vidjeti” zamoli ga Balak. “Odavde mu vidiš samo jedan kraj, a ne vidiš ga svega. Odande mi ga prokuni!” ");
INSERT INTO hrv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Povede ga zatim na Sede Sofim, na vrh Pisge. Tu sagradi sedam žrtvenika i na svakom žrtveniku prinese po jednoga junca i ovna. ");
INSERT INTO hrv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bileam tada rekne Balaku: “Stoj ovdje kraj svoje paljenice, a ja odoh onamo na susret Bogu.” ");
INSERT INTO hrv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Jahve sretne Bileama; stavi riječi u njegova usta te mu zapovjedi: “Vrati se k Balaku i tako govori!” ");
INSERT INTO hrv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","I vrati se on Balaku, koji stajaše uza svoju paljenicu i s njim moapski knezovi. Balak ga zapita: “Što je Jahve rekao?” ");
INSERT INTO hrv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Tada Bileam započe svoju pjesmu i reče: “Ustani, Balače, i poslušaj! Uhom me posluhni, sine Siporov! ");
INSERT INTO hrv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Bog nije čovjek da bi slagao, nije sin Adama da bi se kajao. Zar on kada rekne, a ne učini, zar obeća, pa ne ispuni? ");
INSERT INTO hrv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Gle, primih od Boga da blagoslovim, blagoslovit ću i povuć' neću blagoslova. ");
INSERT INTO hrv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","U Jakovu nesreće ne nazreh, nit' nevolje vidjeh u Izraelu. Jahve, Bog njegov, s njime je, poklik kralju u njemu odzvanja. ");
INSERT INTO hrv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Iz Egipta Bog ga je izveo, on je njemu k'o rozi bivola. ");
INSERT INTO hrv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Gatanja nema protiv Jakova nit' protiv Izraela vračanja. I kada budu rekli Jakovu i Izraelu: 'Što radi Bog?' ");
INSERT INTO hrv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","gle, ustat će narod k'o lavica, dići će se poput lava: leći neće dok plijen ne proguta, dok ne popije krv pobijenih.” ");
INSERT INTO hrv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Zatim Balak reče Bileamu: “Nemoj ga ni kletvom kleti, ali ni blagoslovom blagoslivljati.” ");
INSERT INTO hrv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bileam odvrati Balaku. “Zar ti nisam rekao: sve što Jahve kaže, to ću činiti.” ");
INSERT INTO hrv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Potom Balak reče Bileamu: “Hajde! Odvest ću te na drugo mjesto. Možda će Bogu biti pravo da mi ga odande prokuneš.” ");
INSERT INTO hrv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","I odvede Balak Bileama na vrh Peora, odakle se pruža vidik na pustaru. ");
INSERT INTO hrv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","“Sagradi mi ovdje sedam žrtvenika”, reče Bileam Balaku. “Nadalje, pripremi mi ovdje sedam junaca i sedam ovnova.” ");
INSERT INTO hrv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak učini kako je Bileam rekao i prinese po jednoga junca i ovna na svakome žrtveniku. ");
INSERT INTO hrv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Kad opazi Bileam da je Jahvi drago što on blagoslivlja Izraela, ne htjede više ni ići kao prije u potragu za znamenjima, nego se licem okrenu prema pustari. ");
INSERT INTO hrv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Bileam podiže oči i vidje Izraela utaborena po njegovim plemenima. Na nj siđe Duh Božji ");
INSERT INTO hrv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","i on poče svoju pjesmu te reče: “Proročanstvo Bileama, sina Beorova, proročanstvo čovjeka pronicava pogleda, ");
INSERT INTO hrv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","proročanstvo onoga koji riječi Božje sluša, koji vidi viđenja Svesilnoga, koji pada i oči mu se otvaraju. ");
INSERT INTO hrv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Kako su lijepi ti šatori, Jakove, i stanovi tvoji, Izraele! ");
INSERT INTO hrv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Kao dolovi što se steru, kao vrtovi uz obalu rijeke, kao aloje što ih Jahve posadi, kao cedri pokraj voda! ");
INSERT INTO hrv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Iz potomstva junak mu izlazi, nad mnogim on vlada narodima. Kralj će njegov nadvisit' Agaga, uzdiže se kraljevstvo njegovo. ");
INSERT INTO hrv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Iz Egipta Bog ga izveo, on je njemu k'o rozi bivola. On proždire narode dušmanske, on njihove kosti drobi. ");
INSERT INTO hrv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Skupio se, polegao poput lava, poput lavice: tko ga podići smije? Blagoslovljen bio tko te blagoslivlje, proklet da je tko tebe proklinje!” ");
INSERT INTO hrv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","I usplamtje srdžbom Balak na Bileama i udari rukom o ruku. “Pozvao sam te da prokuneš moje neprijatelje”, reče Balak Bileamu, “a kad tamo, ti ih blagoslovi evo triput! ");
INSERT INTO hrv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Nosi se odmah u svoj kraj. Bio sam rekao: dostojno ću te počastiti! A eto, Jahve te liši časti.” ");
INSERT INTO hrv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Nato Bileam odgovori Balaku: “Zar nisam rekao i tvojim glasnicima koje si k meni poslao: ");
INSERT INTO hrv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","'Da mi Balak dadne svoju kuću punu srebra i zlata, ne bih mogao prestupiti zapovijed Jahvinu i po svojoj volji činiti bilo dobro, bilo zlo; ono što kaže Jahve, to ću i ja reći.' ");
INSERT INTO hrv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","A sada, kad, evo, odlazim k svome narodu, hajde da ti objavim što će ovaj narod učiniti tvome narodu u budućnosti!” ");
INSERT INTO hrv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","I poče svoju pjesmu i reče: “Proročanstvo Bileama, sina Beorova, proročanstvo čovjeka pronicava pogleda, ");
INSERT INTO hrv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","proročanstvo onoga koji riječi Božje sluša, koji poznaje mudrost Svevišnjega, koji vidi viđenja Svesilnoga, koji pada i oči mu se otvaraju. ");
INSERT INTO hrv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Vidim ga, ali ne sada: motrim ga, al' ne iz blizine: od Jakova zvijezda izlazi, od Izraela žezlo se diže. On Moabu razbija bokove i svu djecu Šetovu zatire! ");
INSERT INTO hrv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom će njegovim postati posjedom, a Seir zemljom osvojenom. Razvija snagu svoju Izrael, ");
INSERT INTO hrv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jakov vlada nad neprijateljima i uništava preživjele iz Ira.” ");
INSERT INTO hrv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Bileam se zagleda u Amaleka te poče svoju pjesmu i reče: “Amalek je prvenac među narodima, ali vječna propast njegov je svršetak.” ");
INSERT INTO hrv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Onda se zagleda u Kenijce te poče svoju pjesmu i reče: “Tvrd je stan tvoj, Kajine, na timoru ti gnijezdo savijeno! ");
INSERT INTO hrv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Al' gnijezdo pripada Beoru; dokle ćeš Ašuru robovati?” ");
INSERT INTO hrv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Opet poče svoju pjesmu i reče: “Narodi pomorski sabiru se sa sjevera, ");
INSERT INTO hrv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","a brodovlje od strane Kitima. Podjarmljuju Ašur, podjarmljuju Heber, pa i njega će propast stići vječita.” ");
INSERT INTO hrv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Potom ustade Bileam te se uputi natrag u svoj kraj. A i Balak ode svojim putem. ");
INSERT INTO hrv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Dok je Izrael boravio u Šitimu, narod se upusti u blud s Moapkama. ");
INSERT INTO hrv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","One pozivahu narod na žrtvovanje svojim bogovima, a narod sudjelovaše u njihovim gozbama i klanjaše se njihovim bogovima. ");
INSERT INTO hrv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Tako se Izrael osramoti s Baalom peorskim. I Jahve planu gnjevom na Izraela. ");
INSERT INTO hrv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","“Pokupi sve narodne glavare”, reče Jahve Mojsiju. “Objesi ih Jahvi usred bijela dana da se Jahvin gnjev odvrati od Izraela.” ");
INSERT INTO hrv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Onda Mojsije rekne izraelskim sucima: “Neka svatko pobije one svoje ljude koji su se osramotili s Baalom peorskim.” ");
INSERT INTO hrv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Baš tada neki Izraelac dođe i dovede k svojoj braći jednu Midjanku naočigled Mojsija i naočigled sve izraelske zajednice koja zaplaka na ulazu u Šator sastanka. ");
INSERT INTO hrv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kad to opazi Pinhas, sin Eleazara, sina svećenika Arona, ustade ispred zajednice: uze koplje u ruku ");
INSERT INTO hrv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","i pođe za Izraelcem u odaje i probode ih oboje, Izraelca i ženu; nju kroza slabine. Tako pomor Izraelaca prestade. ");
INSERT INTO hrv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","A onih koji su od pomora pomrli bilo je dvadeset i četiri tisuće. ");
INSERT INTO hrv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Pinhas, sin Eleazara, sina svećenika Arona, odvratio je moj gnjev od Izraelaca, obuzet među njima mojim revnovanjem. Zato u svome revnovanju nisam istrijebio izraelskoga naroda. ");
INSERT INTO hrv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Kaži mu dakle: 'S njime, evo, sklapam savez mira. ");
INSERT INTO hrv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Neka to bude za nj i njegove potomke poslije njega savez vječnoga svećeništva, jer je revnovao za svoga Boga i izvršio pomirenje za izraelski narod.'” ");
INSERT INTO hrv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ime Izraelcu koji je bio ubijen - onome što je ubijen s Midjankom - bijaše Zimri. Bio je sin Salua, glavara jedne od Šimunovih porodica. ");
INSERT INTO hrv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","A ime ubijene žene Midjanke bijaše Kozbi. Bila je kći Surova. Sur je bio glavar jednog plemena, jedne porodice u Midjanu. ");
INSERT INTO hrv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Navali na Midjance i potuci ih, ");
INSERT INTO hrv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","jer su i oni navaljivali na vas svojim lukavštinama kad su lukavo radili protiv vas u slučaju Peora i svoje sestre Kozbi, kćeri glavara midjanskoga, koja je zaglavila u vrijeme pomora nastalog zbog Peora.” ");
INSERT INTO hrv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Poslije toga zla Jahve reče Mojsiju i Eleazaru, sinu svećenika Arona: ");
INSERT INTO hrv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Obavite popis sve zajednice sinova Izraelovih, po njihovim porodicama, popišite sve, od dvadeset godina pa naviše, koji su u Izraelu sposobni za borbu.” ");
INSERT INTO hrv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Mojsije, dakle, i svećenik Eleazar popišu ih na Moapskim poljanama, uz Jordan blizu Jerihona, ");
INSERT INTO hrv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","sve od dvadeset godina pa naviše, kako je Jahve naredio Mojsiju i Izraelcima. Sinovi Izraelovi koji su izašli iz zemlje egipatske bili su: ");
INSERT INTO hrv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Izraelov prvorođenac Ruben. Sinovi Rubenovi: od Henoka rod Henokovaca; od Palua rod Paluovaca; ");
INSERT INTO hrv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","od Hesrona rod Hesronovaca i od Karmija rod Karmijevaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","To su rodovi Rubenovaca. Njih je bilo četrdeset i tri tisuće sedam stotina i trideset. ");
INSERT INTO hrv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Paluov sin bijaše Eliab, ");
INSERT INTO hrv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","a sinovi Eliabovi: Nemuel, Datan i Abiram. Taj Datan i Abiram bijahu ugledni članovi zajednice koji se podigoše protiv Mojsija i Arona u buni Korahovoj, kad se pobuniše protiv Jahve. ");
INSERT INTO hrv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Nato je zemlja rastvorila svoje ralje i progutala ih zajedno s Korahom, kad je smrt pograbila tu skupinu i oganj proždro dvjesta i pedeset ljudi. Tako su postali opomenom. ");
INSERT INTO hrv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","No sinovi Korahovi ne izginuše. ");
INSERT INTO hrv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Sinovi Šimunovi po svojim rodovima: od Nemuela rod Nemuelovaca; od Jamina rod Jaminovaca; od Jakina rod Jakinovaca; ");
INSERT INTO hrv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","od Zeraha rod Zerahovaca i od Šaula rod Šaulovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","To su rodovi Šimunovaca, njih dvadeset i dvije tisuće i dvjesta. ");
INSERT INTO hrv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Sinovi Gadovi po svojim rodovima: od Sefona rod Sefonovaca; od Hagija rod Hagijevaca; od Šunija rod Šunijevaca; ");
INSERT INTO hrv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","od Oznija rod Oznijevaca; od Erija rod Erijevaca; ");
INSERT INTO hrv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","od Aroda roda Arodovaca i od Arelija rod Arelijevaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","To su rodovi Gadovih potomaka. Njih je upisano četrdeset tisuća i pet stotina. ");
INSERT INTO hrv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Judini sinovi: Er i Onan. I Er i Onan umriješe u zemlji kanaanskoj. ");
INSERT INTO hrv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Sinovi Judini po svojim rodovima bijahu: od Šele rod Šelinaca; od Peresa rod Peresovaca i od Zeraha rod Zerahovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Peresovi su sinovi opet bili: od Hesrona rod Hesronovaca i od Hamula rod Hamulovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","To su Judini rodovi. Njih je upisano sedamdeset i šest tisuća i petsto. ");
INSERT INTO hrv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Sinovi Jisakarovi, prema svojim rodovima: od Tole rod Tolinaca; od Puve rod Puvinaca; ");
INSERT INTO hrv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","od Jašuba rod Jašubovaca i od Šimrona rod Šimronovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","To su Jisakarovi rodovi. Njih je upisano šezdeset i četiri tisuće i trista. ");
INSERT INTO hrv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sinovi Zebulunovi, po svojim rodovima: od Sereda rod Seredovaca; od Elona rod Elonovaca i od Jahleela rod Jahleelovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","To su rodovi Zebulunovaca. Njih je upisano šezdeset tisuća i pet stotina. ");
INSERT INTO hrv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Sinovi Josipovi, po svojim rodovima: Manaše i Efrajim. ");
INSERT INTO hrv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Sinovi Manašeovi: od Makira rod Makirovaca. Makiru se rodio Gilead. Od Gileada rod Gileadovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ovo su bili sinovi Gileadovi: od Jezera rod Jezerovaca; od Heleka rod Helekovaca; ");
INSERT INTO hrv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","od Asriela rod Asrielovaca; od Šekema rod Šekemovaca; ");
INSERT INTO hrv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","od Šemide rod Šemidinaca i od Hefera rod Heferovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Heferov sin Selofhad nije imao sinova, nego kćeri. Imena Selofhadovih kćeri bila su: Mahla, Noa, Hogla, Milka i Tirsa. ");
INSERT INTO hrv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","To su Manašeovi rodovi. Njih je upisano pedeset i dvije tisuće i sedam stotina. ");
INSERT INTO hrv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ovo su opet sinovi Efrajimovi, po svojim rodovima: od Šutelaha rod Šutelahovaca; od Bekera rod Bekerovaca i od Tahana rod Tahanovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ovo su sinovi Šutelahovi: od Erana rod Eranovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","To su rodovi Efrajimovih sinova. Njih je upisano trideset i dvije tisuće i pet stotina. To su sinovi Josipovi, po svojim rodovima. ");
INSERT INTO hrv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Sinovi Benjaminovi, po svojim rodovima: od Bele rod Belinaca; od Ašbela rod Ašbelovaca; od Ahirama rod Ahiramovaca; ");
INSERT INTO hrv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","od Šefufama rod Šefufamovaca i od Hufama rod Hufamovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Belini sinovi bili su: Ard i Naaman. I tako, od Arda rod Ardovaca, a od Naamana rod Naamanovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","To su sinovi Benjaminovi, po svojim rodovima. Njih je upisano četrdeset i pet tisuća i šest stotina. ");
INSERT INTO hrv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ovo su sinovi Danovi, po svojim rodovima: od Šuhama rod Šuhamovaca. To su sinovi Danovi, prema svojim rodovima. ");
INSERT INTO hrv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Od svih rodova Šuhamovaca bilo je upisano šezdeset i četiri tisuće i četiri stotine. ");
INSERT INTO hrv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Sinovi Ašerovi, po svojim rodovima: od Jimne rod Jimninaca; od Jišvija rod Jišvijevaca i od Berije rod Berijevaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Od sinova Berijinih: od Hebera rod Heberovaca i od Malkiela rod Malkielovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ašerovoj kćeri bilo je ime Serah. ");
INSERT INTO hrv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","To su rodovi Ašerovih sinova. Njih je upisano pedeset i tri tisuće i četiri stotine. ");
INSERT INTO hrv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Sinovi Naftalijevi, po svojim rodovima: od Jahseela rod Jahseelovaca; od Gunija rod Gunijevaca; ");
INSERT INTO hrv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","od Jesera rod Jeserovaca i od Šilema rod Šilemovaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","To su rodovi Naftalijevaca. Po njihovim rodovima upisano ih je četrdeset i pet tisuća i četiri stotine. ");
INSERT INTO hrv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Bilo je, dakle, upisanih Izraelaca šest stotina i jedna tisuća i sedam stotina i trideset. ");
INSERT INTO hrv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Tima neka se razdijeli zemlja u baštinu prema broju osoba. ");
INSERT INTO hrv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Većem broju povećaj njegovu baštinu, a manjem smanji njegovu baštinu; neka se svakomu dadne njegova baština prema broju upisanih. ");
INSERT INTO hrv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ali zemlja neka se podijeli kockom: neka se primi u baštinu prema djedovskim plemenskim imenima. ");
INSERT INTO hrv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Baština se ima podijeliti kockom svakom plemenu prema njegovoj veličini.” ");
INSERT INTO hrv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ovo je popis Levijevaca, po njihovim rodovima: od Geršona rod Geršonovaca; od Kehata rod Kehatovaca i od Merarija rod Merarijevaca. ");
INSERT INTO hrv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ovo su rodovi Levijevaca: rod Libnijevaca, rod Hebronovaca, rod Mahlijevaca, rod Mušijevaca i rod Korahovaca. Kehatu se rodio Amram. ");
INSERT INTO hrv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amramovoj ženi bijaše ime Jokebeda. Bila je kći Levijeva, koja se Leviju rodila u Egiptu. Ona je Amramu rodila: Arona, Mojsija i njihovu sestru Mirjam. ");
INSERT INTO hrv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aronu se rodili: Nadab, Abihu, Eleazar i Itamar. ");
INSERT INTO hrv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab i Abihu poginuli su kad su prinosili neposvećenu vatru pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Svih je popisanih muškaraca od jednog mjeseca pa naviše bilo dvadeset i tri tisuće. Oni nisu bili popisani s Izraelcima i nije im bila dodijeljena baština među Izraelcima. ");
INSERT INTO hrv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","To su, dakle, oni koje je popisao Mojsije i svećenik Eleazar; oni su obavili ovaj popis Izraelaca uz Jordan, na Moapskim poljanama nasuprot Jerihonu. ");
INSERT INTO hrv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Među njima nije bilo ni jednoga od onih koje su popisali Mojsije i svećenik Aron kad su popisivali Izraelce u Sinajskoj pustinji. ");
INSERT INTO hrv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Jer Jahve bijaše za njih rekao: “Neka pomru u pustinji i neka nitko od njih ne ostane, osim Kaleba, sina Jefuneova, i Jošue, sina Nunova!” ");
INSERT INTO hrv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Tada pristupiše kćeri Selofhada, sina Heferova, sina Gileadova, sina Makirova, sina Manašeova iz roda Josipova sina Manašea. A imena kćeri bila su: Mahla, Noa, Hogla, Milka i Tirsa. ");
INSERT INTO hrv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","One stanu pred Mojsija, pred svećenika Eleazara, pred glavare i svu zajednicu na ulazu u Šator sastanka pa reknu: ");
INSERT INTO hrv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Naš je otac umro u pustinji. Nije pripadao družini što se pobunila protiv Jahve - Korahovoj družini - nego je umro od svoga vlastitoga grijeha. Sinova nije imao. ");
INSERT INTO hrv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Zašto bi se odstranilo ime našega oca iz njegova roda? Budući da nije imao sina, daj nama posjed među braćom našega oca!” ");
INSERT INTO hrv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mojsije iznese njihov slučaj pred Jahvu. ");
INSERT INTO hrv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","A Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Selofhadove kćeri pravo kažu. Treba svakako da im dadneš posjed koji će biti njihova baština među braćom njihova oca. Prenesi na njih baštinu njihova oca. ");
INSERT INTO hrv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Nadalje, reci Izraelcima: 'Kad koji čovjek umre a ne imadne sina, prenesite njegovu baštinu na njegovu kćer. ");
INSERT INTO hrv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ne imadne li ni kćeri, predajte baštinu njegovoj braći. ");
INSERT INTO hrv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ako ne imadne ni braće, njegovu baštinu podajte braći njegova oca. ");
INSERT INTO hrv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ako mu otac ne imadne braće, baštinu njegovu podajte najbližem rođaku njegova roda: neka je on uzme u posjed.' Neka to bude zakonska odredba Izraelcima, kako je Jahve naredio Mojsiju.” ");
INSERT INTO hrv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Jahve reče Mojsiju: “Popni se na ovo brdo Abarim i razgledaj zemlju koju dajem Izraelcima. ");
INSERT INTO hrv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","A kad budeš razgledao, pridružit ćeš se svojim precima i ti, kako se pridružio i tvoj brat Aron. ");
INSERT INTO hrv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Jer ste se u pobuni zajednice u pustinji Sin usprotivili mojim ustima umjesto da vodom očitujete moju svetost pred njihovim očima.” (To su Meripske vode kod Kadeša u Sinskoj pustinji.) ");
INSERT INTO hrv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","A Jahvi Mojsije progovori ovako: ");
INSERT INTO hrv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Neka Jahve, Bog duhova u svakom tijelu, postavi čovjeka nad ovom zajednicom ");
INSERT INTO hrv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","koji će pred njom izlaziti; koji će pred njom stupati; koji će je izvoditi i uvoditi tako da Jahvina zajednica ne bude kao stado što nema pastira.” ");
INSERT INTO hrv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","“Uzmi Jošuu, sina Nunova!” - reče Jahve Mojsiju. “To je čovjek u kome ima duha. Na nj položi ruku svoju! ");
INSERT INTO hrv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Onda ga odvedi pred svećenika Eleazara i pred svu zajednicu te mu na njihove oči daj naredbe! ");
INSERT INTO hrv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Predaj mu dio svoje vlasti da ga sluša sva zajednica sinova Izraelovih. ");
INSERT INTO hrv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Neka pristupa k svećeniku Eleazaru, koji će za nj tražiti odluke Urima pred Jahvom. Na njegovu zapovijed neka izlaze i na njegovu zapovijed neka ulaze, oni i svi Izraelci s njim - sva zajednica.” ");
INSERT INTO hrv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mojsije učini kako mu je Jahve naredio: uzme Jošuu te ga postavi pred svećenika Eleazara i pred svu zajednicu. ");
INSERT INTO hrv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Položi zatim na nj svoje ruke i dade mu svoje naredbe, kako je Jahve zapovjedio preko Mojsija. ");
INSERT INTO hrv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Naredi Izraelcima i reci im: 'Točno u određeno vrijeme prinosite mi moje prinose, moju hranu - žrtve paljene meni na ugodan miris.' ");
INSERT INTO hrv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Reci im: Ovo su žrtve paljene koje ćete prinositi Jahvi: Svaki dan dva jednogodišnja janjca bez mane kao trajnu paljenicu. ");
INSERT INTO hrv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Jedno janje prinosite jutrom, a drugo janje prinosite u suton. ");
INSERT INTO hrv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","A za prinosnicu desetinu efe najboljeg brašna, zamiješena u četvrtini hina čistoga ulja. ");
INSERT INTO hrv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Trajna je to paljenica koja je već bila prinesena na Sinajskom brdu - žrtva spaljena na ugodan miris Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Njezina ljevanica neka se sastoji od četvrtine hina za svako janje. Ljevanica vina neka se Jahvi izlijeva u Svetištu. ");
INSERT INTO hrv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Drugo janje prinosite u suton. Prinosi ga kao i jutarnju prinosnicu i njezinu ljevanicu: kao žrtvu spaljenu Jahvi na ugodan miris.” ");
INSERT INTO hrv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Na subotnji dan: dva jednogodišnja janjeta bez mane i dvije desetine efe najboljeg brašna, zamiješena s uljem, za prinosnicu, s njezinom ljevanicom. ");
INSERT INTO hrv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Neka se subotnja paljenica svake subote dodaje trajnoj paljenici i njezinoj ljevanici.” ");
INSERT INTO hrv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Na početku vaših mjeseci prinosite Jahvi za paljenicu: dva junca, jednoga ovna i sedam jednogodišnjih janjaca bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Za pojedinog junca kao prinosnicu: tri desetine najboljeg brašna zamiješena s uljem; za svakog ovna kao prinosnicu: dvije desetine efe najboljeg brašna zamiješena s uljem. ");
INSERT INTO hrv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Za svako janje jednu desetinu efe najboljeg brašna zamiješena s uljem kao prinosnicu. To je paljenica spaljena na ugodan miris Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Njihove ljevanice neka budu: na junca polovica hina vina; na ovna trećina hina; na janje četvrtina hina. To neka bude mjesečna paljenica na mlađak svakog mjeseca u godini. ");
INSERT INTO hrv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Povrh trajne paljenice neka se Jahvi prinosi jedan jarac kao okajnica s njezinom ljevanicom.” ");
INSERT INTO hrv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Prvoga mjeseca, četrnaestoga dana u mjesecu, Jahvina je Pasha, ");
INSERT INTO hrv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","a petnaestoga dana toga mjeseca jest blagdan. Neka se sedam dana jedu beskvasni hljebovi. ");
INSERT INTO hrv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Prvog dana neka bude sveti saziv. Nikakva težačkog posla nemojte raditi. ");
INSERT INTO hrv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Prinesite Jahvi žrtvu paljenu, žrtvu paljenicu: dva junca, jednoga ovna i sedam jednogodišnjih janjaca. Neka vam budu bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Njihova prinosnica, od najboljeg brašna zamiješena s uljem, neka bude: tri desetine efe na junca, dvije desetine efe na ovna, ");
INSERT INTO hrv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","a na svakoga od onih sedam janjaca neka bude jedna desetina efe. ");
INSERT INTO hrv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Neka bude jedan jarac kao okajnica, da se nad vama izvrši obred pomirenja. ");
INSERT INTO hrv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ovo prinosite povrh jutarnje paljenice, koje se prinosi kao trajna paljenica. ");
INSERT INTO hrv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Tako činite svaki dan za sedam dana; to je hrana, žrtva paljena na ugodan miris Jahvi. To neka se prinosi povrh trajne paljenice i njezine ljevanice. ");
INSERT INTO hrv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Sedmoga dana neka vam bude sveti savez. Nikakva težačkog posla nemojte raditi!” ");
INSERT INTO hrv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“I na Dan prvina - na svoj Blagdan sedmica - kad budete Jahvi prinosili prinosnicu, imajte sveti saziv: nikakva težačkog posla nemojte raditi. ");
INSERT INTO hrv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Za paljenicu na ugodan miris Jahvi prinesite dva junca, jednoga ovna i sedam jednogodišnjih janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Njihova prinosnica, od najboljeg brašna zamiješena s uljem, neka bude: na pojedinog junca tri desetine efe, na pojedinoga ovna dvije desetine efe, ");
INSERT INTO hrv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","a jedna desetina efe na svakoga od onih sedam janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Neka bude i jedan jarac kao okajnica, da se nad vama izvrši obred pomirenja. ");
INSERT INTO hrv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Prinosite ih povrh trajne paljenice i njezine prinosnice, a neka vam budu bez mane one i njihove ljevanice.” ");
INSERT INTO hrv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“U sedmome mjesecu, na prvi dan mjeseca, imajte sveti saziv. Nikakva težačkog posla nemojte raditi. Neka vam to bude Dan sazivanja. ");
INSERT INTO hrv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Za paljenicu na ugodan miris Jahvi prinesite: jednoga junca, jednoga ovna i sedam jednogodišnjih janjaca bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Njihova prinosnica, od najboljeg brašna zamiješena s uljem, neka bude: tri desetine efe na junca, dvije desetine efe na ovna ");
INSERT INTO hrv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","i jedna desetina efe na svakoga od onih sedam janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Neka bude jedan jarac kao okajnica, da se nad vama izvrši obred pomirenja. ");
INSERT INTO hrv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Neka to bude povrh paljenice o mlađaku mjesecu i njezine prinosnice, povrh trajne paljenice i njezine prinosnice i povrh njihovih propisanih ljevanica, žrtva spaljena na ugodan miris Jahvi.” ");
INSERT INTO hrv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“A desetoga dana toga sedmog mjeseca imajte sveti saziv. Postite i nemojte raditi nikakva posla. ");
INSERT INTO hrv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Prinesite paljenicu Jahvi na ugodan miris: jednoga junca, jednoga ovna i sedam jednogodišnjih janjaca. Neka su vam bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Njihova prinosnica, od najboljeg brašna zamiješena s uljem, neka bude: tri desetine efe na junca, dvije desetine na jednoga ovna ");
INSERT INTO hrv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","i jedna desetina efe na svakoga od onih sedam janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Jedan jarac neka se prinese kao okajnica. To je povrh okajnice na Dan pomirenja, povrh trajne paljenice i njezine prinosnice i njihovih ljevanica.” ");
INSERT INTO hrv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Na petnaesti dan sedmoga mjeseca imajte sveti saziv. Nikakva težačkog posla nemojte raditi. Sedam dana svetkujte svečanost Jahvi. ");
INSERT INTO hrv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","A za paljenicu, spaljenu na ugodan miris Jahvi, prinesite: trinaest junaca, dva ovna i četrnaest jednogodišnjih janjaca. Neka su bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Njihova prinosnica, od najboljeg brašna zamiješena s uljem, neka bude: tri desetine efe na svakoga od trinaest junaca, dvije desetine efe na svakoga od dvaju ovnova ");
INSERT INTO hrv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","i jedna desetina efe na svako pojedino od četrnaestero janjadi. Neka se nadoda jedan jarac kao okajnica. ");
INSERT INTO hrv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","To neka bude povrh trajne paljenice, njezine prinosnice i njezine ljevanice. ");
INSERT INTO hrv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Drugog dana: dvanaest junaca, dva ovna, četrnaest jednogodišnjih janjaca bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Njihovu prinosnicu i njihove ljevanice prinesite propisno prema broju junaca, ovnova i janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Prinesite jednoga jarca kao okajnicu povrh trajne paljenice, njezine prinosnice i njezinih ljevanica. ");
INSERT INTO hrv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Trećeg dana: jedanaest junaca, dva ovna, četrnaest jednogodišnjih janjaca bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Njihovu prinosnicu i njihove ljevanice prinesite propisno prema broju junaca, ovnova i janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Prinesite jednoga jarca kao okajnicu povrh trajne paljenice, njezine prinosnice i njezine ljevanice. ");
INSERT INTO hrv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Četvrtog dana: deset junaca, dva ovna, četrnaest jednogodišnjih janjaca bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Njihovu prinosnicu i njihove ljevanice prinesite propisno prema broju junaca, ovnova i janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Jednog jarca prinesite kao okajnicu povrh trajne paljenice, njezine prinosnice i njezine ljevanice. ");
INSERT INTO hrv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Petog dana: devet junaca, dva ovna, četrnaest jednogodišnjih janjaca bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Njihovu prinosnicu i njihove ljevanice prinesite propisno prema broju junaca, ovnova i janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Prinesite jednog jarca kao okajnicu povrh trajne paljenice, njezine prinosnice i njezine ljevanice. ");
INSERT INTO hrv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Šestog dana: osam junaca, dva ovna, četrnaest jednogodišnjih janjaca bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Njihovu prinosnicu i njihove ljevanice prinesite propisno prema broju junaca, ovnova i janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Jednoga jarca prinesite kao okajnicu povrh trajne paljenice, njezine prinosnice i njezinih ljevanica. ");
INSERT INTO hrv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Sedmog dana: sedam junaca, dva ovna, četrnaest jednogodišnjih janjaca bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Njihovu prinosnicu i njihove ljevanice prinesite propisno prema broju junaca, ovnova i janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Jednog jarca prinesite kao okajnicu povrh trajne paljenice, njezine prinosnice i njezine ljevanice. ");
INSERT INTO hrv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Osmog dana imajte svečani zbor. Nikakva težačkog posla nemojte raditi. ");
INSERT INTO hrv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","A za paljenicu, spaljenu na ugodan miris Jahvi, prinesite: jednog junca, jednoga ovna i sedam jednogodišnjih janjaca bez mane. ");
INSERT INTO hrv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Njihovu prinosnicu i njihove ljevanice prinesite propisno prema broju junaca, ovnova i janjaca. ");
INSERT INTO hrv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Jednog jarca prinesite kao okajnicu povrh trajne paljenice, njezine prinosnice i njezine ljevanice. ");
INSERT INTO hrv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Na svoje određene blagdane prinesite to Jahvi osim svojih zavjetnica i svojih dragovoljnih žrtava, svojih paljenica, prinosnica, ljevanica i svojih pričesnica.” ");
INSERT INTO hrv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Sve kako mu je Jahve naredio Mojsije kaza Izraelcima. ");
INSERT INTO hrv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Zatim reče Mojsije glavarima plemena Izraelovih: “Ovo je Jahve naredio. ");
INSERT INTO hrv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Ako koji čovjek učini zavjet ili se uz zakletvu obveže da će se nečega odreći, neka ne krši svoje riječi; neka izvrši sve što iz njegovih usta izađe! ");
INSERT INTO hrv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Ako koja žena učini Jahvi zavjet ili se obveže da će se nečega odreći dok je još mlada, u očevu domu, ");
INSERT INTO hrv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","a otac joj sazna za zavjet i obećanje kojim se obvezala pa joj ništa ne rekne, tada su valjani svi njezini zavjeti i valjano je svako obećanje kojim se obvezala. ");
INSERT INTO hrv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Ali ako joj se otac usprotivi kad sazna, nikakav njezin zavjet ni njezino obećanje kojim se vezala ne vrijedi. Jahve će joj oprostiti jer joj se otac usprotivio. ");
INSERT INTO hrv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Ako se uda dok je pod svojim zavjetima ili pod obećanjem koje je nepromišljeno izišlo iz njezinih usta, ");
INSERT INTO hrv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","pa njezin muž sazna i pošto je saznao ništa joj ne rekne, tada vrijede njezini zavjeti i vrijede obećanja kojima se obvezala. ");
INSERT INTO hrv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","No ako se njezin muž usprotivi kad o tom sazna, ukida se time njezin zavjet i obećanje što je nepromišljeno izišlo iz njezinih usta. I Jahve će joj oprostiti. ");
INSERT INTO hrv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","A zavjet udovice ili žene otpuštene i sve obveze koje je na se preuzela vrijede za nju. ");
INSERT INTO hrv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Ako se zavjetuje ili se obveže zakletvom na obećanje dok je u kući svoga muža, ");
INSERT INTO hrv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","pa njezin muž sazna i ništa joj ne rekne, ne usprotivi joj se, svaki je njezin zavjet valjan i valjano je svako obećanje kojim se obvezala. ");
INSERT INTO hrv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ali ako ih njezin muž proglasi ništetnim kad o njima sazna, tada ništa što je izišlo iz njezinih usta, njezini zavjeti ili preuzete obveze neće vrijediti. Muž ih je njezin poništio, i Jahve će joj oprostiti. ");
INSERT INTO hrv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Svaki zavjet i svaku zakletvu koja obvezuje ženu na neko mrtvenje njezin muž može uzdržati na snazi ili poništiti. ");
INSERT INTO hrv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ako joj muž od dana do dana ništa ne rekne, time potvrđuje sve njezine zavjete i sva njezina obećanja kojima se obvezala; on ih je učinio valjanima ako ništa nije rekao kad je o njima čuo. ");
INSERT INTO hrv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ali ako ih poništi kasnije, pošto je o njima već čuo, neka snosi njezinu krivnju.” ");
INSERT INTO hrv_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","To su uredbe koje je Jahve Mojsiju izdao za muža i njegovu ženu i za oca i njegovu kćer, koja, još mlada, živi u kući očevoj. ");
INSERT INTO hrv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Iskali osvetu Izraelaca na Midjancima, a poslije toga pridružit ćeš se svojim precima.” ");
INSERT INTO hrv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","A Mojsije reče narodu: “Opremite ljude između sebe za pohod na Midjance, ");
INSERT INTO hrv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","da na Midjancima izvrše Jahvinu osvetu. Na vojnu opremite po jednu tisuću od svakoga izraelskog plemena!” ");
INSERT INTO hrv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","I tako su iz izraelskih porodica - tisuću po plemenu - za vojnu skupili dvanaest tisuća. ");
INSERT INTO hrv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Posla ih Mojsije - tisuću po plemenu - na vojnu zajedno s Pinhasom, sinom svećenika Eleazara. On je nosio posvećene stvari i trube. ");
INSERT INTO hrv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Oni zavojuju na Midjance, kako je Jahve naredio Mojsiju, i pobiju sve muškarce. ");
INSERT INTO hrv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Među ostalima pobili su i midjanske kraljeve: Evija, Rekema, Sura, Hura i Rebu - pet midjanskih kraljeva. Mačem pogube i Bileama, Beorova sina. ");
INSERT INTO hrv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Odvedu tada Izraelci u ropstvo midjanske žene s njihovom djecom i svu njihovu stoku, krupnu i sitnu, i zaplijene sve njihovo blago. ");
INSERT INTO hrv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ognjem spale sve gradove njihove u kojima se živjeli i sva njihova naselja, ");
INSERT INTO hrv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","a sve njihovo uzmu za plijen i pljačku, i ljude i životinje. ");
INSERT INTO hrv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Onda u tabor na Moapskim poljanama uz Jordan, nasuprot Jerihonu, dovedu Mojsiju, svećeniku Eleazaru i svoj izraelskoj zajednici zarobljenike, plijen i pljačku. ");
INSERT INTO hrv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mojsije, svećenik Eleazar i svi glavari zajednice izađu im u susret izvan tabora. ");
INSERT INTO hrv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Mojsije se razljuti na zapovjednike vojske, tisućnike i satnike, koji se bijahu vratili s toga bojnog pohoda. ");
INSERT INTO hrv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Reče im: “Što! Na životu ste ostavili sve ženskinje! ");
INSERT INTO hrv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","A baš su žene, po nagovoru Bileamovu, zavele Izraelce da u Peorovu slučaju istupe protiv Jahve. Tako dođe pomor na Jahvinu zajednicu. ");
INSERT INTO hrv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Stoga svu mušku djecu pobijte! A ubijte i svaku ženu koja je poznala muškarca! ");
INSERT INTO hrv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","A sve mlade djevojke koje nisu poznale muškarca ostavite na životu za se. ");
INSERT INTO hrv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Vi pak proboravite izvan tabora sedam dana; svi vi koji ste koga ubili i koji ste se ubijenoga dotakli. Čistite se i vi i vaši zarobljenici trećega i sedmoga dana; ");
INSERT INTO hrv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","očistite svu odjeću, sve mješine, sve od kostrijeti napravljeno i sve drvene predmete.” ");
INSERT INTO hrv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Zatim svećenik Eleazar progovori borcima koji su se vratili iz boja: “Ovo je odredba koju je izdao Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","'Zlato, srebro, bakar, gvožđe, mjed i olovo - ");
INSERT INTO hrv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","sve što podnosi vatru - provucite kroz vatru i bit će očišćeno.' Ipak, neka se očisti i vodom očišćenja. A sve što ne podnosi vatru provucite kroz vodu. ");
INSERT INTO hrv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Sedmoga dana operite svoju odjeću i bit ćete čisti. Poslije toga možete se vratiti u tabor.” ");
INSERT INTO hrv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ti, svećenik Eleazar i obiteljske starješine zajednice napravite popis ratnoga plijena, ljudstva i stoke, ");
INSERT INTO hrv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","a onda ratni plijen podijeli napola: na borce koji su išli u borbu i na svu ostalu zajednicu. ");
INSERT INTO hrv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Od boraca koji su išli u borbu ustavi ujam za Jahvu: jednu glavu od svakih pet stotina, bilo ljudi, bilo krupnog blaga, magaradi ili sitne stoke. ");
INSERT INTO hrv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Uzmi to od njihove polovice i podaj svećeniku Eleazaru kao podizanicu za Jahvu. ");
INSERT INTO hrv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","A od polovice što zapadne druge Izraelce uzmi po glavu od pedeset, bilo ljudi, bilo krupnog blaga, magaradi ili sitne stoke - od svih životinja - pa ih podaj levitima koji vode brigu o Jahvinu prebivalištu.” ");
INSERT INTO hrv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mojsije i svećenik Eleazar učine kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Ratnoga je plijena bilo, osim pljačke što su vojnici napljačkali: šest stotina sedamdeset i pet tisuća grla sitne stoke, ");
INSERT INTO hrv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","sedamdeset i dvije tisuće grla krupne stoke, ");
INSERT INTO hrv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","šezdeset i jedna tisuća magaradi, ");
INSERT INTO hrv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","a ljudskih duša - žena koje nisu poznale muškarca - bijaše u svemu trideset i dvije tisuće. ");
INSERT INTO hrv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Prema tome, polovica što je dodijeljena onima koji su išli u borbu bila je: tri stotine trideset i sedam tisuća i pet stotina grla sitne stoke; ");
INSERT INTO hrv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ujam za Jahvu od sitne stoke šest stotina sedamdeset i pet grla; ");
INSERT INTO hrv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","krupne je stoke bilo trideset i šest tisuća grla, a njihov ujam za Jahvu sedamdeset i dva grla; ");
INSERT INTO hrv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","magaradi je bilo trideset tisuća i pet stotina, a njihov ujam za Jahvu šezdeset i jedno. ");
INSERT INTO hrv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Ljudskih je duša bilo šesnaest tisuća, a njihov ujam za Jahvu trideset i dvije osobe. ");
INSERT INTO hrv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Ujam predade Mojsije svećeniku Eleazaru za podizanicu Jahvi, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","A od polovice koja je zapala druge Izraelce i koju Mojsije odijeli od one što je pripala ljudima koji su se borili - ");
INSERT INTO hrv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","dakle, polovica što je pripala zajednici iznosila je: trista trideset i sedam tisuća i pet stotina grla sitne stoke, ");
INSERT INTO hrv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","a krupne stoke trideset i šest tisuća grla; ");
INSERT INTO hrv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","magaradi trideset tisuća i pet stotina, ");
INSERT INTO hrv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","a ljudskih duša šesnaest tisuća. ");
INSERT INTO hrv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Tako, od polovice što je pripala Izraelcima Mojsije ostavi po jedno od pedeset, i od ljudstva i od stoke, te ih predade levitima koji su se brinuli o Jahvinu prebivalištu, kako je Jahve naredio Mojsiju. ");
INSERT INTO hrv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Onda pristupiše k Mojsiju vojnički zapovjednici, tisućnici i satnici, ");
INSERT INTO hrv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","i rekoše mu: “Tvoje sluge prebrojile su borce što bijahu pod našim zapovjedništvom i od nas nitko nije izgubljen. ");
INSERT INTO hrv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Uz to smo donijeli svoje darove Jahvi: narukvica, orukvica, prstenja, naušnica i ogrlica - na kakvu je tko zlatninu već naišao - da se nad nama obavi obred pomirenja pred Jahvom.” ");
INSERT INTO hrv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mojsije i svećenik Eleazar prime od njih to zlato, to jest sve te izrađene predmete. ");
INSERT INTO hrv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Bilo je svega zlata što su kao svoju podizanicu Jahvi donijeli tisućnici i satnici: šesnaest tisuća sedam stotina i pedeset šekela. ");
INSERT INTO hrv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Svaki je vojnik za se zadržao svoj plijen. ");
INSERT INTO hrv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Tako Mojsije i svećenik Eleazar uzmu zlato od tisućnika i satnika te ga donesu u Šator sastanka na spomen Izraelcima pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Rubenovci i Gadovci imađahu mnogo, vrlo mnogo blaga. Opaze, međutim, da je zemlja jazerska i zemlja gileadska pogodna za stočarstvo. ");
INSERT INTO hrv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Zato Gadovci i Rubenovci dođu k Mojsiju, svećeniku Eleazaru i glavarima zajednice pa reknu: ");
INSERT INTO hrv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarot, Dibon, Jazer, Nimra, Hešbon, Eleale, Sebam, Nebo i Beon - ");
INSERT INTO hrv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","kraj što ga Jahve osvoji pred izraelskom zajednicom - kraj je pogodan za stočarstvo; a sluge tvoje bave se stočarstvom. ");
INSERT INTO hrv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ako smo stekli blagonaklonost u tvojim očima”, nastave, “neka se ovaj kraj dade u posjed tvojim slugama. Ne šalji nas preko Jordana!” ");
INSERT INTO hrv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mojsije odgovori Gadovcima i Rubenovcima: “Zar da vaša braća idu u rat, a vi da ostanete ovdje? ");
INSERT INTO hrv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Zašto odvraćate srca Izraelaca da ne prijeđu u zemlju koju im je Jahve predao? ");
INSERT INTO hrv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Tako su učinili i vaši očevi kad sam ih poslao iz Kadeš Barnee da izvide zemlju. ");
INSERT INTO hrv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Popeli su se do Eškola i razgledali zemlju, ali su onda ubili srčanost u Izraelcima da ne odu u zemlju koju im je Jahve dao. ");
INSERT INTO hrv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Onog dana Jahve planu gnjevom. Zakle se i reče: ");
INSERT INTO hrv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","'Ljudi što su izišli iz Egipta, kojima je dvadeset ili više godina, jer me nisu vjerno slijedili, nikad neće vidjeti zemlju što sam je pod zakletvom obećao Abrahamu, Izaku i Jakovu!' ");
INSERT INTO hrv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Jahvu su jedino vjerno slijedili Kenižanin Kaleb, sin Jefuneov, i sin Nunov Jošua. ");
INSERT INTO hrv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Jahve je gnjevom planuo na Izraelce pa ih je pustinjom povlačio četrdeset godina, sve dok ne pomrije sav naraštaj što je u očima Jahvinim zlo postupio. ");
INSERT INTO hrv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","A sad vi - grešni naraštaj - ustajete namjesto svojih očeva da još povećate srdžbu Jahvinu na Izraela. ");
INSERT INTO hrv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ako se od njega odvratite, on će još produžiti vaš boravak u pustinji; tako ćete upropastiti sav taj narod.” ");
INSERT INTO hrv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Onda se oni primaknu k njemu i reknu: “Mi bismo ovdje podigli torove za svoje blago i gradove za svoju nejačad, ");
INSERT INTO hrv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","a sami ćemo pograbiti oružje i poći na čelu Izraelaca dok ih ne dovedemo na njihovo mjesto. Naša nejačad neka ostane - zbog stanovništva ove zemlje - u utvrđenim gradovima. ");
INSERT INTO hrv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Mi se svojim kućama nećemo vraćati sve dok svaki Izraelac ne zaposjedne svoju baštinu. ");
INSERT INTO hrv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","S njima nećemo dijeliti svoje posjede s onu stranu Jordana niti dalje, jer će nas zapasti naša baština s ovu stranu, na istok od Jordana.” ");
INSERT INTO hrv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mojsije im reče: “Ako tako uradite, ako pođete pred Jahvom u boj; ");
INSERT INTO hrv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ako vi svi naoružani prijeđete Jordan pred Jahvom dok on ne rastjera ispred sebe svoje neprijatelje: ");
INSERT INTO hrv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","tada, kad zemlja bude pokorena Jahvi, vi ćete se moći vratiti. Tako ćete biti oslobođeni odgovornosti prema Jahvi i prema Izraelu, a ova će zemlja postati pred Jahvom vaše vlasništvo. ");
INSERT INTO hrv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ali ako tako ne uradite, sagriješit ćete protiv Jahve i znajte da će vas stići kazna za vaš grijeh. ");
INSERT INTO hrv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Sazidajte, dakle, gradove za svoju nejačad i torove za svoju stoku, ali izvršite što ste obećali.” ");
INSERT INTO hrv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gadovci i Rubenovci odgovore Mojsiju: “Tvoje će sluge učiniti kako gospodar naš nalaže. ");
INSERT INTO hrv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Naša nejačad, naše žene, naša stoka i sve naše blago neka ostanu ondje u gileadskim gradovima, ");
INSERT INTO hrv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","a tvoje sluge, svi koji su za boj sposobni, poći će pred Jahvom u boj, kako naš gospodar nalaže.” ");
INSERT INTO hrv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Tada za njih Mojsije izda nalog svećeniku Eleazaru, Nunovu sinu Jošui i glavarima obitelji izraelskih plemena. ");
INSERT INTO hrv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","I reče im Mojsije: “Ako Gadovci i Rubenovci, svi oni koji nose oružje, s vama prijeđu Jordan da se bore pred Jahvom i zemlja bude pokorena vama, onda im dajte gileadsku zemlju u vlasništvo. ");
INSERT INTO hrv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ali ako ne prijeđu naoružani s vama, neka dobiju baštinu među vama u zemlji kanaanskoj.” ");
INSERT INTO hrv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Nato odgovore Gadovci i Rubenovci: “Što je god Jahve rekao tvojim slugama, to ćemo učiniti. ");
INSERT INTO hrv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Mi ćemo naoružani prijeći pred Jahvom u zemlju kanaansku, ali neka nam bude posjed naše baštine s ove strane Jordana.” ");
INSERT INTO hrv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","I tako njima - Gadovcima, Rubenovcima i polovici plemena Manašea, sina Josipova - dadne kraljevstvo amorejskoga kralja Sihona i kraljevstvo bašanskoga kralja Oga, zemlju s gradovima u njihovim granicama, gradove okolne zemlje. ");
INSERT INTO hrv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gadovci sagrade: Dibon, Atarot i Aroer, ");
INSERT INTO hrv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot Šofan, Jazer, Jogbohu, ");
INSERT INTO hrv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet Nimru i Bet Haran, utvrđene gradove i torove za stada. ");
INSERT INTO hrv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Rubenovci sagrade: Hešbon, Eleale, Kirjatajim, ");
INSERT INTO hrv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal Meon - nazivi su izmijenjeni - i Šibmu. Oni prozovu svojim imenima gradove koje su oni podigli. ");
INSERT INTO hrv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Sinovi Makira, sina Manašeova, odu u Gilead, osvoje ga i protjeraju Amorejce koji bijahu ondje. ");
INSERT INTO hrv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Mojsije preda Gilead Manašeovu sinu Makiru, i on se u njemu nastani. ");
INSERT INTO hrv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","A Manašeov sin Jair ode te zauzme njihova sela pa ih prozva “Jairova sela”. ");
INSERT INTO hrv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Potom ode Nobah i zauzme Kenat i njegova područja te ga nazove svojim imenom “Nobah”. ");
INSERT INTO hrv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ovo su postaje Izraelaca što ih prijeđoše kad iziđoše iz zemlje egipatske u svojim četama pod vodstvom Mojsijevim i Aronovim. ");
INSERT INTO hrv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Na zapovijed Jahvinu Mojsije je bilježio polazne točke njihova putovanja. Ovo su njihove postaje prema njihovim polaznim točkama. ");
INSERT INTO hrv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Iz Ramsesa krenuše u prvome mjesecu. Bio je petnaesti dan prvoga mjeseca - sutradan poslije Pashe - kad se Izraelci zaputiše uzdignutih pesnica i naočigled sviju Egipćana, ");
INSERT INTO hrv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","dok su Egipćani pokopavali one koje je Jahve između njih pobio, to jest sve prvorođence, i tako nad njihovim božanstvima izvršio pravdu. ");
INSERT INTO hrv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Krenu dakle Izraelci iz Ramsesa i utabore se u Sukotu. ");
INSERT INTO hrv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Zatim odu iz Sukota i utabore se u Etamu, baš na rubu pustinje. ");
INSERT INTO hrv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Pođu iz Etama, a onda okrenu prema Pi Hahirotu, koji se nalazi nasuprot Baal Sefona. Tabore postave pred Migdolom. ");
INSERT INTO hrv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Krenu od Pi Hahirota i prijeđu posred mora u pustinju. Išli su tri dana pustinjom Etanom, a onda se utabore u Mari. ");
INSERT INTO hrv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Zatim odu iz Mare i stignu u Elim. U Elimu je bilo dvanaest izvor-voda i sedamdeset palma. Tu su se utaborili. ");
INSERT INTO hrv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Potom krenu iz Elima te se utabore uz Crveno more. ");
INSERT INTO hrv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","A otišavši od Crvenog mora, utabore se u pustinji Sinu. ");
INSERT INTO hrv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Potom odu iz pustinje Sina i postave tabore u Dofki. ");
INSERT INTO hrv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Otišavši iz Dofke, utabore se u Alušu. ");
INSERT INTO hrv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Krenu iz Aluša i utabore se u Refidimu. Tu narod nije imao vode da pije. ");
INSERT INTO hrv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Odu iz Refidima te se utabore u Sinajskoj pustinji. ");
INSERT INTO hrv_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Krenu iz Sinajske pustinje te se utabore u Kibrot Hataavi. ");
INSERT INTO hrv_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Odu iz Kibrot Hataave te se utabore u Haserotu. ");
INSERT INTO hrv_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Onda odu iz Haserota i utabore se u Ritmi. ");
INSERT INTO hrv_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Krenu iz Ritme i utabore se u Rimon Peresu. ");
INSERT INTO hrv_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Odu iz Rimon Peresa i utabore se u Libni. ");
INSERT INTO hrv_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Iz Libne odu i utabore se u Risi. ");
INSERT INTO hrv_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Odu iz Rise te se utabore u Kehelati. ");
INSERT INTO hrv_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Odu iz Kehelate i utabore se na brdu Šeferu. ");
INSERT INTO hrv_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Odu s brda Šefera i utabore se u Haradi. ");
INSERT INTO hrv_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Odu iz Harade i utabore se u Makhelotu. ");
INSERT INTO hrv_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Odu iz Makhelota te se utabore u Tahatu. ");
INSERT INTO hrv_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Odu iz Tahata i utabore se u Tarahu. ");
INSERT INTO hrv_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Iz Taraha odu i utabore se u Mitki. ");
INSERT INTO hrv_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Odu iz Mitke i utabore se u Hašmoni. ");
INSERT INTO hrv_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Iz Hašmone odu i utabore se u Moserotu. ");
INSERT INTO hrv_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Odu iz Moserota i utabore se u Bene Jaakanu. ");
INSERT INTO hrv_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Odu iz Bene Jaakana i utabore se u Hor Gidgadu. ");
INSERT INTO hrv_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Odu iz Hor Gidgada i utabore se u Jotbati. ");
INSERT INTO hrv_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Odu iz Jotbate i utabore se u Abroni. ");
INSERT INTO hrv_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Iz Abrone odu i utabore se u Esion Geberu. ");
INSERT INTO hrv_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Iz Esion Gebera odu i utabore se u pustinji Sinu, to jest u Kadešu. ");
INSERT INTO hrv_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Iz Kadeša krenu te se utabore na brdu Horu, na granici zemlje edomske. ");
INSERT INTO hrv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Na zapovijed Jahvinu svećenik se Aron pope na brdo Hor i tu umre na prvi dan petoga mjeseca, u četrdesetoj godini nakon izlaska Izraelaca iz egipatske zemlje. ");
INSERT INTO hrv_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aronu je bilo stotinu dvadeset i tri godine kad je preminuo na brdu Horu. ");
INSERT INTO hrv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Aradski kralj, Kanaanac, koji je živio u kanaanskom kraju Negebu, čuo je o dolasku Izraelaca. ");
INSERT INTO hrv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","S brda Hora odu te se utabore u Salmoni. ");
INSERT INTO hrv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Odu iz Salmone i utabore se u Punonu. ");
INSERT INTO hrv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Odu iz Punona i utabore se u Obotu. ");
INSERT INTO hrv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Odu iz Obota i utabore se na moapskom području u Ije-Abarimu. ");
INSERT INTO hrv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Odu iz Ije-Abarima i utabore se u Dibon Gadu. ");
INSERT INTO hrv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Iz Dibon Gada odu i utabore se u Almon Diblatajimu. ");
INSERT INTO hrv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Iz Almon Diblatajima odu i utabore se na Abarimskim bregovima, pred Nebom. ");
INSERT INTO hrv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Odu s Abarimskih bregova i utabore se na Moapskim poljanama, uz Jordan, nasuprot Jerihonu; ");
INSERT INTO hrv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","taborovali su uz Jordan od Bet Haješimota sve do Abel Hašitima na Moapskim poljanama. ");
INSERT INTO hrv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Na Moapskim poljanama uz Jordan, nasuprot Jerihonu, Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Ovako reci Izraelcima: 'Kad prijeđete preko Jordana u zemlju kanaansku, ");
INSERT INTO hrv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","potjerajte ispred sebe sve stanovnike te zemlje, uništite sve njihove slike; uništite sve njihove salivene kumire i sve njihove uzvišice porušite. ");
INSERT INTO hrv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Onda zaposjednite zemlju i u njoj se nastanite, jer sam vam je predao da je zaposjednete. ");
INSERT INTO hrv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Zemlju razdijelite kockom među svoje rodove. Brojnijem povećajte dio, a manjem smanjite. Gdje god kocka padne, bilo za koga, neka je to njegovo, a prema otačkim plemenima dijelite im baštinu. ");
INSERT INTO hrv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ako stanovnike zemlje ispred sebe ne potjerate, onda će oni koje od njih na životu ostavite biti trnje u vašim očima i bodljike u vašim bokovima; dosađivat će vam u zemlji u kojoj budete živjeli ");
INSERT INTO hrv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","i postupit ću s vama kako sam mislio postupiti s njima.'” ");
INSERT INTO hrv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Izdaj Izraelcima naredbu i reci im: 'Kad uđete u kanaansku zemlju, ta će vam zemlja pripasti u baštinu, zemlja kanaanska sa svojim granicama. ");
INSERT INTO hrv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Južna strana protezat će vam se od pustinje Sina uz Edom. Južna će vam granica početi s kraja Slanog mora na istočnoj strani. ");
INSERT INTO hrv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Onda će vam granica skrenuti na jug, prema Akrabimskoj strmini, i nastaviti se preko Sina. Doprijet će na jugu do Kadeš Barnee; zatim će izaći prema Hasar Adaru i nastaviti se do Asmone. ");
INSERT INTO hrv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Od Asmone granica će skrenuti prema Egipatskom potoku i izaći će na more. ");
INSERT INTO hrv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Zapadna granica bit će vam Veliko more; neka vam je to granica prema zapadu. ");
INSERT INTO hrv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","A ovo će vam biti sjeverna granica: od Velikog mora povucite crtu na brdo Hor; ");
INSERT INTO hrv_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","s brda Hora onda potegnite crtu do ulaza u Hamat; završetak granice bit će Sedada. ");
INSERT INTO hrv_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Onda će se granica protegnuti do Zifrona i završiti u Hasar Enanu. To će vam biti sjeverna granica. ");
INSERT INTO hrv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Za svoju istočnu granicu povucite crtu od Hasar Enana do Šefama. ");
INSERT INTO hrv_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Granica će se spuštati od Šefama do Rible, istočno od Ajina. Odande će se granica spustiti i doprijeti do istočne obale Kineretskog jezera. ");
INSERT INTO hrv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Iza toga spustit će se granica niz Jordan da završi u Slanome moru. To će biti vaša zemlja sa svojim granicama naokolo.'” ");
INSERT INTO hrv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Tada Mojsije naredi Izraelcima: “To je zemlja koju ćete kockom dobiti u baštinu, a za koju je zapovjedio Jahve da je dobije devet plemena i polovica jednog plemena. ");
INSERT INTO hrv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Jer pleme Rubenovaca prema svojim porodicama, zatim pleme Gadovaca prema svojim porodicama već primiše svoju baštinu, kao što je svoju baštinu primila i polovica plemena Manašeova. ");
INSERT INTO hrv_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Ta dva plemena i pol primila su svoje baštine s one strane Jordana, nasuprot Jerihonu, s istočne strane.” ");
INSERT INTO hrv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Jahve reče Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Ovo su imena ljudi koji će vam zemlju podijeliti: svećenik Eleazar i Nunov sin Jošua; ");
INSERT INTO hrv_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","i od svakoga plemena uzmi po jednoga glavara za razdiobu zemlje. ");
INSERT INTO hrv_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Ovo su imena tih ljudi: Kaleb, sin Jefuneov; od plemena Judina; ");
INSERT INTO hrv_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Šemuel, sin Amihudov, od plemena Šimunova; ");
INSERT INTO hrv_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidad, sin Kislonov, od plemena Benjaminova; ");
INSERT INTO hrv_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","knez Buki, sin Joglijev, od plemena Danovaca. ");
INSERT INTO hrv_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Od sinova Josipovih: knez Haniel, sin Efodov, od plemena Manašeovaca; ");
INSERT INTO hrv_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","knez Kemuel, sin Šiftanov, od plemena Efrajimovaca; ");
INSERT INTO hrv_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","knez Elisafan, sin Parnakov, od plemena Zebulunovaca; ");
INSERT INTO hrv_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","knez Paltiel, sin Azanov, od plemena Jisakarovaca; ");
INSERT INTO hrv_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","knez Ahihud, sin Šelomijev, od plemena Ašerovaca; ");
INSERT INTO hrv_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","knez Pedahel, sin Amihudov, od plemena Naftalijevaca.” ");
INSERT INTO hrv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","To su oni kojima je Jahve naložio da Izraelcima izdijele baštinu u zemlji kanaanskoj. ");
INSERT INTO hrv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Reče Jahve Mojsiju na Moapskim poljanama kod Jordana, nasuprot Jerihonu: ");
INSERT INTO hrv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Naredi Izraelcima da ustupe levitima od baštine koju posjeduju gradove gdje će stanovati i pašnjake oko gradova. To dajte levitima. ");
INSERT INTO hrv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Neka gradovi budu njima za stanovanje, a okolni pašnjaci neka budu za njihova goveda, njihovo blago i sve njihove životinje. ");
INSERT INTO hrv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Pašnjaci uz gradove koje ustupite levitima neka zahvate od gradskih zidina van do tisuću lakata naokolo. ");
INSERT INTO hrv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Izmjerite od grada van dvije tisuće lakata s istočne strane, dvije tisuće lakata s južne strane, dvije tisuće lakata sa zapadne strane i sa sjeverne strane dvije tisuće lakata, tako da grad bude u sredini. To neka im budu gradski pašnjaci. ");
INSERT INTO hrv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Od gradova koje budete dali levitima šest će ih biti gradovi-utočišta, koje ćete ustupiti da ubojica može tamo pobjeći. Ovima dodajte još četrdeset i dva grada. ");
INSERT INTO hrv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Tako će svih gradova koje ustupite levitima biti četrdeset i osam gradova s njihovim pašnjacima. ");
INSERT INTO hrv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","A gradove koje budete izdvajali od vlasništva Izraelaca, od onih koji ih imaju mnogo uzmite više, a manje od onih koji imaju malo. Neka svatko ustupi gradove levitima prema omjeru baštine koju bude primio.” ");
INSERT INTO hrv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Nadalje reče Jahve Mojsiju: ");
INSERT INTO hrv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Govori Izraelcima i reci im: 'Kad prijeđete preko Jordana u zemlju kanaansku, ");
INSERT INTO hrv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","označite sebi gradove koji će vam služiti kao gradovi-utočišta, kamo može pobjeći ubojica koji nehotice koga ubije. ");
INSERT INTO hrv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Ti gradovi neka vam budu utočište od osvetnika, tako da ubojica ne moradne poginuti dok ne stane na sud pred zajednicu. ");
INSERT INTO hrv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Od gradova koje ustupite bit će vam šest gradova za utočište. ");
INSERT INTO hrv_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Dodijelite tri grada s onu stranu Jordana, a tri grada u zemlji kanaanskoj. Neka to budu gradovi-utočišta. ");
INSERT INTO hrv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Tih šest gradova neka budu za utočište kako Izraelcima tako i strancu i došljaku koji među njima borave, kamo može pobjeći tko god ubije koga nehotice. ");
INSERT INTO hrv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Ali ako tko udari koga gvozdenim predmetom te ga usmrti, to je onda ubojica. Ubojica mora glavom platiti. ");
INSERT INTO hrv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Udari li ga iz ruke kamenom od kojega čovjek može poginuti i zbilja pogine, to je opet ubojica. Ubojica mora glavom platiti. ");
INSERT INTO hrv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ili ako ga udari iz ruke kakvim drvenim predmetom od kojega može umrijeti i zbilja umre, i to je ubojica. Ubojica mora glavom platiti. ");
INSERT INTO hrv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Krvni osvetnik mora sam ubojicu usmrtiti. Kad ga sretne, neka ga ubije. ");
INSERT INTO hrv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Nadalje, ako tko koga gurne iz mržnje ili na nj nešto baci namjerno te ga usmrti, ");
INSERT INTO hrv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ili ga udari rukom iz zlobe te udareni umre, napadač mora zaglaviti - on je ubojica. Krvni osvetnik neka ubojicu ubije čim ga sretne. ");
INSERT INTO hrv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","No gurne li ga slučajno, ne iz neprijateljstva, ili nešto na nj baci, ali ne iz zasjede, ");
INSERT INTO hrv_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ili iz nepažnje na njega obori kakav kamen od kojega čovjek može poginuti te ga usmrti, a nije mu bio neprijatelj niti mu je zlo želio - ");
INSERT INTO hrv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","tada neka zajednica prosudi između ubojice i krvnog osvetnika prema ovim pravilima: ");
INSERT INTO hrv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Zajednica mora izbaviti ubojicu iz ruku krvnog osvetnika; onda neka ga zajednica vrati u grad-utočište kamo je pobjegao; tu neka on ostane do smrti velikoga svećenika koji je bio pomazan svetim uljem. ");
INSERT INTO hrv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ali ako ubojica ikad izađe izvan granice utočišta kamo je pobjegao, ");
INSERT INTO hrv_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","pa na nj nabasa krvni osvetnik izvan granica njegova grada-utočišta te krvni osvetnik ubije ubojicu, to mu se ne računa u krvoproliće, ");
INSERT INTO hrv_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","jer ubojica mora ostati u gradu-utočištu do smrti velikoga svećenika. A poslije smrti velikoga svećenika može se vratiti na svoj posjed. ");
INSERT INTO hrv_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Neka vam takvi budu sudbeni postupci od naraštaja do naraštaja svuda gdje budete boravili. ");
INSERT INTO hrv_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Za svako ubojstvo čovjeka kazna smrti nad ubojicom može se izvršiti na dokaz svjedoka. Nitko se ne može smrću kazniti na dokaz samo jednog svjedoka. ");
INSERT INTO hrv_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Ne smijete primati otkupnine za život ubojice koji je zaslužio smrt: on mora umrijeti. ");
INSERT INTO hrv_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Niti smijete primati otkupnine od bilo koga koji, pošto je pobjegao u svoj grad-utočište, hoće da se vrati i da živi na svome tlu prije smrti velikoga svećenika. ");
INSERT INTO hrv_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Nemojte oskvrnjivati zemlje u kojoj živite. A krvoprolićem zemlja se oskvrnjuje. Za zemlju na kojoj je krv prolivena pomirenje se ne može pribaviti, osim krvlju onoga koji ju je prolio. ");
INSERT INTO hrv_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Ne smije se obeščašćivati zemlja u kojoj živite i usred koje ja boravim, jer ja, Jahve, prebivam među sinovima Izraelovim.'” ");
INSERT INTO hrv_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Tada pristupe obiteljski glavari od roda sinova Gileada, sina Makirova, sina Manašeova, jednoga roda Josipovih sinova, te pred Mojsijem i starješinama, glavarima obitelji, ");
INSERT INTO hrv_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","reknu: “Jahve je naredio našemu gospodaru da kockom dade ovu zemlju u baštinu Izraelcima; nadalje, našem je gospodaru naredio Jahve da baštinu našega brata Selofhada dade njegovim kćerima. ");
INSERT INTO hrv_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ali ako se one udaju za koga iz drugog izraelskoga plemena, onda će njihova baština biti otrgnuta od naše djedovske baštine i biti priključena baštini plemena kojemu one pripadnu. Tako će se okrnjiti baština koja kockom pripadne nama. ");
INSERT INTO hrv_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","A kada nastupi jubilej Izraelcima, baština će se tih žena dodati baštini plemena kojemu pripadnu. Tako će njihova baština biti oduzeta od baštine našega pradjedovskog plemena.” ");
INSERT INTO hrv_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","I po zapovijedi Jahvinoj Mojsije naredi Izraelcima: “Pleme Josipovih sinova pravo govori. ");
INSERT INTO hrv_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ovo naređuje Jahve za Selofhadove kćeri: Neka se one udaju za onoga koji im se učini dobar, samo neka se udaju u rod svoga očinskoga plemena. ");
INSERT INTO hrv_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Baština Izraelaca ne smije se prenositi iz jednoga plemena u drugo; i svaki Izraelac mora ostati privezan uz pradjedovsku baštinu svoga plemena. ");
INSERT INTO hrv_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Zato se svaka djevojka koja steče baštinu u izraelskim plemenima mora udati za nekoga u plemenu kojemu pripada rod joj očev, tako da bi svaki Izraelac sačuvao baštinu svoga oca. ");
INSERT INTO hrv_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Tako se baština neće prenositi iz jednoga plemena u drugo, nego će svako izraelsko pleme prianjati uza svoju baštinu.” ");
INSERT INTO hrv_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Kako je Jahve Mojsiju naredio, tako su i učinile kćeri Selofhadove: ");
INSERT INTO hrv_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mahla, Tirsa, Hogla, Milka i Noa, kćeri Selofhadove, udaše se za sinove svojih stričeva. ");
INSERT INTO hrv_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Kako su se udale u rod potomstva Manašea, Josipova sina, njihova je baština ostala u plemenu kojemu pripadaše rod im očev. ");
INSERT INTO hrv_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","To su zapovijedi i zakoni koje je Jahve preko Mojsija izdao Izraelcima na Moapskim poljanama uz Jordan, nasuprot Jerihonu. ");
INSERT INTO hrv_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Ovo su riječi što ih je Mojsije upravio svemu Izraelu s onu stranu Jordana - u pustinji, u Arabi nasuprot Sufu, između Parana i Tofela, Labana, Hazerota i Di Zahaba - ");
INSERT INTO hrv_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","od Horeba do Kadeš Barnee, Seirskom gorom, jedanaest dana hoda. ");
INSERT INTO hrv_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Bilo je to godine četrdesete, prvog dana mjeseca jedanaestoga, kad Mojsije reče Izraelcima sve što mu je Jahve za njih naređivao. ");
INSERT INTO hrv_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Pošto je porazio amorejskoga kralja Sihona, koji je živio u Hešbonu, i bašanskoga kralja Oga, koji je živio u Aštarotu i Edreju, ");
INSERT INTO hrv_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","dakle s onu stranu Jordana, u zemlji moapskoj, poče Mojsije razlagati ovaj Zakon. Govoraše on: ");
INSERT INTO hrv_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Jahve, Bog naš, reče nam na Horebu: 'Dosta ste boravili na ovome brdu. ");
INSERT INTO hrv_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Krenite na put! Idite u gorski kraj Amorejaca i svih njihovih susjeda, u Arabu, u Gorje, u Šefelu i u Negeb, na morsku obalu, u zemlju kanaansku i u Libanon, sve do Velike rijeke, rijeke Eufrata. ");
INSERT INTO hrv_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Eto, pred vas stavljam ovu zemlju. Idite, dakle, i zauzmite zemlju za koju se Jahve zakle ocima vašim, Abrahamu, Izaku i Jakovu, da će je dati njima i njihovu potomstvu poslije njih.' ");
INSERT INTO hrv_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Tada sam vam rekao: 'Ne mogu vas voditi sam. ");
INSERT INTO hrv_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Jahve, Bog vaš, toliko vas je razmnožio da vas danas ima kao zvijezda na nebu. ");
INSERT INTO hrv_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Neka vas Jahve, Bog vaših otaca, umnoži još tisuću puta! Neka vas blagoslivlja kako vam je obećao! ");
INSERT INTO hrv_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Ali kako bih ja sam mogao nositi vaš teret, vaše breme i vaše sporove? ");
INSERT INTO hrv_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Izaberite stoga iz svojih plemena ljude pametne, iskusne i ugledne da vam ih postavim za poglavare.' ");
INSERT INTO hrv_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Vi ste mi odgovorili: 'Dobro je što predlažeš.' ");
INSERT INTO hrv_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Zato sam uzeo prvake iz vaših plemena, ljude pametne i ugledne, te ih postavio za poglavare: tisućnike, stotnike, pedesetnike, desetnike i vaše plemenske nadglednike. ");
INSERT INTO hrv_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","U to isto vrijeme naložio sam i vašim sucima: 'Saslušajte svoju braću; sudite pravedno između čovjeka i njegova brata ili pridošlice. ");
INSERT INTO hrv_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","U suđenju nemojte biti pristrani; saslušavajte maloga kao i velikoga. Ne bojte se nikoga! TÓa sud je Božji! Ako vam koji slučaj bude pretežak, iznesite ga meni, da ga ja razvidim.' ");
INSERT INTO hrv_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Tako sam vam onda naložio sve što vam je činiti. ");
INSERT INTO hrv_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Krenusmo iz Horeba i, na putu u gorske krajeve Amorejaca, kako nam je naredio Jahve, Bog naš, prijeđosmo svu onu veliku i strašnu pustinju koju ste vidjeli. Stigosmo u Kadeš Barneu. ");
INSERT INTO hrv_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Tada vam rekoh: 'Došli ste u gorski kraj Amorejaca, koji nam Jahve, Bog naš, daje. ");
INSERT INTO hrv_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Eto, Jahve, Bog tvoj, stavio je preda te tu zemlju. Ustaj! Zaposjedni je, kako ti je rekao Jahve, Bog otaca tvojih. Ne boj se! Ne strahuj!' ");
INSERT INTO hrv_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Svi ste onda došli k meni i rekli: 'Pošaljimo pred sobom ljude da izvide zemlju i jave nam o putu kojim ćemo ići i o gradovima u koje ćemo doći.' ");
INSERT INTO hrv_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Svidje mi se što rekoste. Zato uzeh dvanaest ljudi između vas, po jednoga iz svakog plemena. ");
INSERT INTO hrv_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Krenuli su na pogorje, stigli do Eškolske doline te izvidjeli kraj. ");
INSERT INTO hrv_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","I nabraše plodova one zemlje, donesoše ih k nama i javiše: 'Zemlja koju nam daje Jahve, Bog naš, dobra je.' ");
INSERT INTO hrv_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Ali vi niste htjeli onamo; pobunili ste se protiv naredbe Jahve, Boga svoga. ");
INSERT INTO hrv_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Rogoborili ste u svojim šatorima i govorili: 'U svojoj mržnji na nas Jahve nas je izveo iz zemlje egipatske da nas preda u ruke Amorejaca, kako bi nas posve uništili. ");
INSERT INTO hrv_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Kamo da idemo? Naša su braća ubila u nama srčanost kad rekoše: Narod je i veći i jači nego mi; gradovi su veliki, i zidine im sežu do nebesa. A vidjeli smo ondje i Anakovce.' ");
INSERT INTO hrv_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","'Ne bojte se!' - rekoh vam. - 'Ne plašite ih se! ");
INSERT INTO hrv_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Jahve, Bog vaš, koji ide pred vama, borit će se za vas kako je to učinio na vaše oči u Egiptu.' ");
INSERT INTO hrv_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","A vidio si, uostalom, i u pustinji, gdje te Jahve, Bog tvoj, cijeloga puta što ste ga prevalili dok ste stigli do ovoga mjesta, nosio kao što čovjek nosi svoga sinčića. ");
INSERT INTO hrv_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ali, unatoč tome, vi niste imali pouzdanja u Jahvu, Boga svoga, ");
INSERT INTO hrv_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","u onoga koji je na putu išao pred vama da vam potraži mjesto za taborovanje - u ognju obnoć da vam osvijetli put kojim ćete ići, a obdan u oblaku. ");
INSERT INTO hrv_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Jahve ču graju vašu i zakle se u svojoj srdžbi: ");
INSERT INTO hrv_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","'Ni jedan jedini od ovih ljudi, od ovoga opakog naraštaja, neće vidjeti ove dobre zemlje za koju sam se zakleo da ću je dati vašim ocima. ");
INSERT INTO hrv_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Izuzimam Kaleba, sina Jefuneova. On će je vidjeti; njemu i njegovim potomcima dat ću zemlju kojom je išao, jer je vjerno slijedio Jahvu.' ");
INSERT INTO hrv_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Zbog vas se Jahve i na mene razljutio te mi rekao: 'Ni ti onamo nećeš ući. ");
INSERT INTO hrv_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Ući će onamo Jošua, sin Nunov, koji te služi. Njega ti osokoli, jer će on uvesti Izraela u posjed. ");
INSERT INTO hrv_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","A i vaši mališani, o kojima rekoste da će postati roblje, sinovi vaši koji još ne znaju razlikovati dobro i zlo, oni će u nju ući; njima ću je u posjed dati. ");
INSERT INTO hrv_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","A vi se okrenite i zaputite u pustinju, prema Crvenome moru!' ");
INSERT INTO hrv_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Vi ste mi tada odgovorili riječima: 'Sagriješili smo protiv Jahve. Poći ćemo gore i boriti se kako nam je Jahve, Bog naš, zapovjedio.' Svaki od vas dohvati svoje oružje i nepromišljeno pođe gore u brda. ");
INSERT INTO hrv_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Onda mi Jahve reče: 'Kaži im: Ne idite gore i ne stupajte u borbu da vas ne poraze vaši neprijatelji jer ja nisam među vama.' ");
INSERT INTO hrv_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Tako sam vam i govorio, ali niste poslušali. Oprli ste se zapovijedi Jahvinoj i, puni drskosti, krenuli u brda. ");
INSERT INTO hrv_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Ali Amorejci, koji žive u onome gorju, udariše na vas, pognaše vas, za vama se natisnuše kao pčele te su vas tukli od Seira do Horme. ");
INSERT INTO hrv_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Vrativši se, plakali ste pred Jahvom, ali Jahve nije slušao vašega jauka niti je okrenuo svoga uha k vama. ");
INSERT INTO hrv_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","U Kadešu vam valjade ostati dugo vremena, onoliko koliko ste već ostali. ");
INSERT INTO hrv_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Onda se okrenusmo i pođosmo u pustinju prema Crvenome moru, kako mi je Jahve naredio. Dugo smo se vrtjeli oko gore Seira. ");
INSERT INTO hrv_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","I reče mi Jahve: ");
INSERT INTO hrv_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","'Dosta ste se vrtjeli oko ovoga brda. Okrenite prema sjeveru!' ");
INSERT INTO hrv_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","I narodu naloži ovako: 'Sad ćete proći preko područja svoje braće, potomaka Ezavovih, koji žive u Seiru. Oni se vas boje, ali vi dobro pripazite; ");
INSERT INTO hrv_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","s njima ne zamećite boja jer vam neću dati ni stope njihove zemlje: goru Seir predao sam Ezavu u vlasništvo. ");
INSERT INTO hrv_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Hranu od njih kupujte za novac da imate što jesti; i vodu za piće kupujte od njih za novac.' ");
INSERT INTO hrv_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Ta Jahve te, Bog tvoj, blagoslovio u svim djelima tvojih ruku; on je bdio nad tvojim putovanjem onom velikom pustinjom; ovih četrdeset godina Jahve, Bog tvoj, bijaše s tobom i ništa ti nije nedostajalo. ");
INSERT INTO hrv_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Tako smo svoju braću, potomke Ezavove što žive u Seiru, zaobišli putem što vodi u Arabu, Elat i Esjon Geber, a onda udarismo prema Moapskoj pustinji. ");
INSERT INTO hrv_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Tada mi zapovjedi Jahve: 'Nemoj uznemirivati Moapce niti s njima zameći boja, jer ništa od njihove zemlje neću dati u tvoje vlasništvo: Lotovim sinovima predao sam Ar u posjed.' ");
INSERT INTO hrv_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Prije su ondje živjeli Emijci. Bio je to moćan narod i brojan; krupna stasa kao i Anakovci. ");
INSERT INTO hrv_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Poput Anakovaca, i njih smatraju Refaimcima, ali ih Moapci nazivaju Emijcima. ");
INSERT INTO hrv_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Isto su tako u Seiru živjeli prije Horijci, ali su ih Ezavovi potomci izvlastili, istrijebili ih i naselili se na njihovo, kako je, uostalom, učinio Izrael sa zemljom - baštinom svojom - koju mu je Jahve predao. ");
INSERT INTO hrv_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","'A sada ustanite i prijeđite preko potoka Zereda!' I prijeđosmo potok Zered. ");
INSERT INTO hrv_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Vrijeme što smo išli od Kadeš Barnee pa dok smo prešli preko potoka Zereda iznosilo je trideset i osam godina - sve dok nije izumro iz tabora sav onaj naraštaj ljudi sposobnih za borbu, kako im se Jahve i zakleo. ");
INSERT INTO hrv_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","I zbilja! Ruka Jahvina bila je protiv njih: istrebljivala ih je isred tabora dok ih nije nestalo. ");
INSERT INTO hrv_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","I tako, kad je smrt istrijebila iz naroda sve ljude sposobne za borbu, ");
INSERT INTO hrv_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","reče mi Jahve: ");
INSERT INTO hrv_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","'Danas prelaziš moapsku zemlju Ar. ");
INSERT INTO hrv_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","A onda ćeš se približiti Amoncima. Nemoj ih uznemirivati niti s njima zameći boja. Ništa, naime, od zemlje Amonaca neću ustupiti tebi u vlasništvo jer sam je već predao u posjed Lotovim potomcima.' ");
INSERT INTO hrv_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","I nju smatraju refaimskom zemljom. U njoj su prije živjeli Refaimci, koje Amonci zovu Zamzumijcima. ");
INSERT INTO hrv_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Bio je to narod moćan i brojan; krupna stasa kao i Anakovci. No Jahve ih uništi pred Amoncima - koji ih izvlastiše i naseliše se na njihovo, ");
INSERT INTO hrv_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","kako je, uostalom, učinio i potomcima Ezavovim, koji su nastanjeni u Seiru, kad je pred njima uništio Horijce, koje su oni otjerali s posjeda i do danas žive na njihovim mjestima. ");
INSERT INTO hrv_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","I Avijce, koji su živjeli po zaseocima sve do Gaze, istrijebiše Kaftorci koji su došli iz Kaftora te se naseliše na njihovo mjesto. ");
INSERT INTO hrv_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","'Ustajte! Na put krenite i prijeđite preko potoka Arnona. U ruke ti, eto, predajem Amorejca Sihona, kralja hešbonskoga, i njegovu zemlju. Počni s osvajanjem; izazovi ga na boj! ");
INSERT INTO hrv_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Od danas počinjem ugoniti strah i trepet pred tobom u narode koji su pod svim nebesima, tako da će strepiti i tresti se pred tobom kad god čuju glas o tebi.' ");
INSERT INTO hrv_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Tada sam iz pustinje Kedmot uputio glasnike kralju hešbonskom Sihonu s miroljubivim riječima: ");
INSERT INTO hrv_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","'Pusti da prođem preko tvoje zemlje. Samo ću proći putem, ne skrećući ni desno ni lijevo. ");
INSERT INTO hrv_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Hranu mi prodavaj za novac da mogu jesti; i vodu za piće davaj mi za novac. Pusti me samo da pješice prođem, ");
INSERT INTO hrv_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","da prijeđem preko Jordana u zemlju koju nam daje Jahve, Bog naš - kao što su mi dopustili potomci Ezavovi, nastanjeni u Seiru, i Moapci, što žive u Aru.' ");
INSERT INTO hrv_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ali hešbonski kralj Sihon ne htjede nas pustiti preko svoga; jer Jahve, Bog tvoj, duh mu zaslijepi a srce otvrdnu, da ga preda u tvoje šake, gdje je i danas. ");
INSERT INTO hrv_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Tada mi reče Jahve: 'Eto sam počeo da ti izručujem Sihona i njegovu zemlju. Počni osvajanje da mu zemljom zagospodariš.' ");
INSERT INTO hrv_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Kod Jahasa presrete nas Sihon. ");
INSERT INTO hrv_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Navali on i sav njegov narod. Ali Jahve, Bog naš, predade nam ga, tako da potukosmo njega, njegove sinove i sav njegov narod. ");
INSERT INTO hrv_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Tada osvojismo sve njegove gradove i prokletstvom udarismo sve gradove s ljudima, ženama i djecom, ništa ne štedeći, ");
INSERT INTO hrv_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","izuzev stoke, koju uzesmo kao plijen, skupa s plijenom iz gradova što smo ih osvojili. ");
INSERT INTO hrv_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Od Aroera, koji se nalazi na obali potoka Arnona, i od grada koji je u njegovoj dolini pa do Gileada nije bilo grada koji bi nam odolio: sve nam ih je Jahve, Bog naš, predao. ");
INSERT INTO hrv_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Jedino se nisi primicao zemlji Amonaca, kraju uz potok Jabok, i gradovima u pogorju, kako je Jahve, Bog naš, odredio. ");
INSERT INTO hrv_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Tada se okrenusmo i pođosmo prema Bašanu. Presrete nas bašanski kralj Og sa svim svojim narodom i nametnu nam boj kod Edreja. ");
INSERT INTO hrv_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Tada mi Jahve reče: 'Ne boj ga se! TÓa u tvoje sam ruke predao njega, sav njegov narod i njegovu zemlju. Učini s njim kako si učinio sa Sihonom, kraljem amorejskim, koji je živio u Hešbonu.' ");
INSERT INTO hrv_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Tako je Jahve, Bog naš, u ruke naše predao i bašanskoga kralja Oga sa svim njegovim narodom. Tukli smo ga tako da mu nitko na životu nije ostao. ");
INSERT INTO hrv_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Osvojili smo tada sve njegove gradove. Nije bilo grada koji im nismo oteli - šezdeset gradova, zapravo svu argopsku krajinu, Ogovo kraljevstvo u Bašanu. ");
INSERT INTO hrv_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Svi su oni gradovi bili utvrđeni visokim zidinama, vratima i prijevornicama. Uz njih je bilo veoma mnogo otvorenih zaselaka. ");
INSERT INTO hrv_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Udarismo ih prokletstvom - kako smo učinili i sa Sihonom, kraljem hešbonskim - zatrvši svaki grad, ljude, žene i djecu. ");
INSERT INTO hrv_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","A svu stoku i plijen po tim gradovima zadržasmo za se. ");
INSERT INTO hrv_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Tako smo u ono vrijeme iz ruku dvaju amorejskih kraljeva uzeli zemlju što se nalazi s onu stranu Jordana, od potoka Arnona do brda Hermona ( ");
INSERT INTO hrv_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sidonci zovu Hermon Sirjon, a Amorejci ga zovu Senir): ");
INSERT INTO hrv_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","sve gradove po Visoravni, sav Gilead i sav Bašan, sve do Salke i Edreja - gradove Ogova kraljevstva u Bašanu. ( ");
INSERT INTO hrv_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Bašanski kralj Og jedini je od preostalih Refaimovaca. Krevet njegov, odar od željeza, još se nalazi u Rabi, gradu sinova Amonovih: deset je lakata - običnih lakata - dug, a četiri lakta širok.) ");
INSERT INTO hrv_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","To je, dakle, bila zemlja koju smo zauzeli u ono vrijeme, počev od Aroera, koji je na potoku Arnonu. Polovicu gileadskog pogorja s njegovim gradovima dao sam Rubenovcima i Gadovcima. ");
INSERT INTO hrv_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Ostatak Gileada i sav Bašan, Ogovo kraljevstvo, dodijelio sam polovini Manašeova plemena. (Sva argopska krajina i sav Bašan zove se zemlja refaimska. ");
INSERT INTO hrv_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manašeov sin Jair zauzeo je svu argopsku krajinu do međe Gešurovaca i Maakinovaca. On ta mjesta bašanska nazva svojim imenom, pa se još i danas zovu Jairova Sela.) ");
INSERT INTO hrv_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Makiru sam dodijelio Gilead. ");
INSERT INTO hrv_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Rubenovcima i Gadovcima dao sam od Gileada do potoka Arnona - sredina potoka jest međa - i do potoka Jaboka, amonske granice. ");
INSERT INTO hrv_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","A granicom su služile Araba i Jordan od Kinereta do mora uz Arabu - Slanog mora - na podnožju obronaka Pisge prema istoku. ");
INSERT INTO hrv_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","U ono vam vrijeme naredih: 'Jahve, Bog vaš, daje vam ovu zemlju u posjed. Svi vi koji ste od boja pođite naoružani pred svojom braćom Izraelcima. ");
INSERT INTO hrv_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Jedino žene vaše, djeca vaša i stoka vaša - znam da imate mnogo stoke - neka ostanu u vašim gradovima što vam ih dodijelih ");
INSERT INTO hrv_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","dokle Jahve ne dadne miran boravak i vašoj braći kao i vama; tako da i oni zauzmu zemlju što im je Jahve, Bog vaš, daje s onu stranu Jordana. Istom onda neka se svaki od vas vrati na posjed što sam vam ga dodijelio.' ");
INSERT INTO hrv_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","U ono sam vrijeme naredio Jošui: 'Svojim si očima vidio što je sve Jahve, Bog vaš, učinio onoj dvojici kraljeva. Tako će Jahve učiniti sa svim kraljevstvima preko kojih budeš prelazio. ");
INSERT INTO hrv_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ne bojte se njih! TÓa Jahve, Bog vaš, bori se za vas.' ");
INSERT INTO hrv_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Tada zamolih milost u Jahve: ");
INSERT INTO hrv_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","'Gospodine moj, Jahve! Ti si počeo pokazivati svome sluzi svoju veličajnost i svoju moć. TÓa koji bog, na nebu ili na zemlji, može izvesti takva djela i čudesa kao što su tvoja! ");
INSERT INTO hrv_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Dopusti mi da odem onamo i pogledam onu blaženu zemlju preko Jordana, onaj krasni gorski kraj i Libanon!' ");
INSERT INTO hrv_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Ali je Jahve, zbog vas, bio na me ljut, pa me nije uslišao. 'Dosta', reče mi Jahve, 'ne govori mi više o tom! ");
INSERT INTO hrv_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Popni se na vrhunac Pisge i upri oči svoje na zapad, sjever, jug i istok. Razmotri dobro očima svojim, jer preko Jordana nećeš prijeći. ");
INSERT INTO hrv_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Uputi Jošuu, osokoli ga i ohrabri! On neka ide na čelu ovoga naroda; neka ih on uvede u posjed zemlje koju vidiš.' ");
INSERT INTO hrv_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Tako smo ostali u toj dolini kraj Bet Peora.” ");
INSERT INTO hrv_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“A sada, Izraele, poslušaj zakone i uredbe kojima vas učim da biste ih vršili i tako poživjeli te unišli i zaposjeli zemlju koju vam daje Jahve, Bog otaca vaših. ");
INSERT INTO hrv_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Niti što nadodajite onome što vam zapovijedam niti što od toga oduzimljite; vršite zapovijedi Jahve, Boga svoga, što vam ih dajem. ");
INSERT INTO hrv_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Vidjeli ste svojim očima što je Jahve učinio s Baal Peorom: jer Jahve, Bog tvoj, iskorijenio je iz tvoje sredine svakoga koji je slijedio Baal Peora. ");
INSERT INTO hrv_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","A svi vi koji se čvrsto držite Jahve, Boga svoga, živi ste i danas. ");
INSERT INTO hrv_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Ja sam vas, eto, poučio o zakonima i uredbama, kako mi je Jahve, Bog moj, naredio da ih vršite u zemlji u koju idete da je zaposjednete. ");
INSERT INTO hrv_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Držite ih i vršite: to će u očima naroda biti vaša mudrost i vaša razboritost. Kad oni čuju za sve ove zakone, reći će: 'Samo je jedan narod mudar i pametan, a to je ovaj veliki narod.' ");
INSERT INTO hrv_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Jer koji je to narod tako velik da bi mu bogovi bili tako blizu kao što je Jahve, Bog naš, nama kad god ga zazovemo? ");
INSERT INTO hrv_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Koji je to narod tako velik da bi imao zakone i uredbe pravedne kao što je sav ovaj Zakon koji vam ja danas iznosim? ");
INSERT INTO hrv_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Zato pazi i dobro se čuvaj da ne zaboraviš događaje što si ih svojim očima vidio; neka ti ne iščeznu iz srca ni jednoga dana tvoga života; naprotiv, pouči o njima svoje sinove i sinove svojih sinova. ");
INSERT INTO hrv_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Onog dana kad si stajao na Horebu pred Jahvom, Bogom svojim, Jahve mi je rekao: 'Skupi mi narod! Hoću da čuju moje riječi, da me se nauče bojati sve vrijeme što budu živjeli na zemlji te da o njima pouče i svoju djecu.' ");
INSERT INTO hrv_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Vi ste se onda primakli i stali pod brdo. S usplamtjeloga brda plamen je sukljao do sred neba zamračena tmastim oblakom. ");
INSERT INTO hrv_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Isred ognja Jahve je govorio vama; čuli ste zvuk riječi, ali lika niste nazreli - ništa osim glasa. ");
INSERT INTO hrv_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Objavio vam je svoj Savez i naložio vam da ga vršite - Deset zapovijedi, što ih ispisa na dvije kamene ploče. ");
INSERT INTO hrv_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","A meni je Jahve naredio da vas poučim o zakonima i uredbama što ćete ih vršiti u zemlji u koju odlazite da je zaposjednete. ");
INSERT INTO hrv_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Pazite dobro! Onoga dana kad vam je Jahve, Bog vaš, govorio isred ognja na Horebu, niste vidjeli nikakva lika, ");
INSERT INTO hrv_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","da se ne biste pokvarili te da ne biste pravili sebi kakva klesana lika, kipa muškoga ili ženskoga obličja, ");
INSERT INTO hrv_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ni obličja kakve životinje što je na zemlji, ni obličja kakve ptice što pod nebom lijeta, ");
INSERT INTO hrv_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ni obličja bilo čega što po zemlji gmiže, ni obličja kakve ribe što je u vodi pod zemljom ");
INSERT INTO hrv_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","i da se ne bi, kad digneš svoje oči prema nebu te vidiš sunce, mjesec i zvijezde - svu nebesku vojsku - dao zavesti da im se klanjaš i da im iskazuješ štovanje. Njih je Jahve, Bog tvoj, dao svim narodima, svugdje pod nebom. ");
INSERT INTO hrv_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","A vas je uzeo Jahve i izveo vas iz Egipta - iz one peći ražarene - da postanete narod njegove baštine, to što ste danas. ");
INSERT INTO hrv_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ali se zbog vas Jahve na me razljutio i zakleo da ja neću prijeći preko Jordana i unići u blaženu zemlju koju ti Jahve, Bog tvoj, daje u baštinu. ");
INSERT INTO hrv_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Tako, ja ću umrijeti u ovoj zemlji; ja preko Jordana neću prijeći. A vi ćete prijeći i zaposjesti onu krasnu zemlju. ");
INSERT INTO hrv_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Zato pazite da ne zaboravljate Saveza što ga je Jahve, Bog vaš, sklopio s vama te sebi ne pravite klesanih likova bilo čega što je Jahve, Bog tvoj, zabranio. ");
INSERT INTO hrv_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Jer Jahve, Bog tvoj, oganj je što proždire; on je Bog ljubomoran. ");
INSERT INTO hrv_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Kad budete izrodili djecu i unučad i budete dulje u onoj zemlji proboravili, a pokvarite se praveći sebi bilo kakve klesane likove i čineći zlo u očima Jahve, Boga svojega, tako da ga na srdžbu izazovete, ");
INSERT INTO hrv_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","znajte - uzimam za svjedoke protiv vas nebesa i zemlju - da će vas brzo nestati sa zemlje u koju idete preko Jordana da je zaposjednete: nećete dugo u njoj živjeti nego ćete biti iskorijenjeni. ");
INSERT INTO hrv_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Jahve će vas raspršiti po narodima i ostat će vas samo malen broj među narodima među koje vas Jahve odvede. ");
INSERT INTO hrv_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ondje ćete se klanjati bogovima što su ih ljudske ruke načinile od drveta i kamena, bogovima koji ne mogu ni vidjeti ni čuti, ni jesti ni mirisati. ");
INSERT INTO hrv_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Ondje ćeš tražiti Jahvu, Boga svoga. I naći ćeš ga ako ga budeš tražio svim srcem svojim i svom dušom svojom. ");
INSERT INTO hrv_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","U nevolji tvojoj snaći će te sve to, ali u posljednje vrijeme ti ćeš se obratiti Jahvi, Bogu svomu, i poslušati njegov glas. ");
INSERT INTO hrv_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","TÓa Jahve, Bog tvoj, Bog je milosrdan; neće te on zapustiti ni upropastiti niti će zaboraviti Saveza što ga je pod zakletvom sklopio s ocima tvojim. ");
INSERT INTO hrv_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Ispitaj samo prijašnja vremena što su protekla prije tebe, sve otkad je Bog stvorio čovjeka na zemlji: je li ikad, s jednoga kraja nebesa do drugoga, bilo ovako veličanstvena događaja? Je li se što takvo čulo? ");
INSERT INTO hrv_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Je li ikad koji narod čuo glas Boga gdje govori isred ognja kao što si ti čuo i na životu ostao? ");
INSERT INTO hrv_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ili, pokuša li koji bog da ode i uzme sebi jedan narod isred drugog naroda kušnjama, znakovima, čudesima i ratom, jakom rukom i ispruženom mišicom, uza silne strahote, kao što je sve to, na vaše oči, učinio za vas Jahve, Bog vaš, u Egiptu? ");
INSERT INTO hrv_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Tebi je to pokazano da znaš da je Jahve pravi Bog i da nema drugoga uz njega. ");
INSERT INTO hrv_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","S neba ti se oglasio svojim glasom da te pouči; dopustio ti je da vidiš njegov veliki oganj na zemlji; i isred ognja čuo si njegove riječi. ");
INSERT INTO hrv_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Zbog toga što je ljubio očeve tvoje, izabrao je poslije njih njihovo potomstvo; on, glavom, izveo te iz Egipta svojom silnom moći; ");
INSERT INTO hrv_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ispred tebe rastjerao je narode, i brojnije i jače od tebe, da te dovede u njihovu zemlju i preda je tebi u baštinu, kao što je i danas. ");
INSERT INTO hrv_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Danas, dakle, spoznaj i zasadi u svoje srce: Jahve je Bog gore na nebu i ovdje na zemlji - drugoga nema. ");
INSERT INTO hrv_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Drži njegove zakone i njegove zapovijedi koje ti dajem danas da dobro bude tebi i tvojoj djeci poslije tebe; da dugo poživiš na zemlji koju ti Jahve, Bog tvoj, daje zauvijek.” ");
INSERT INTO hrv_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Tada Mojsije izabra tri grada preko Jordana, na istočnoj strani, ");
INSERT INTO hrv_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","kamo će se moći skloniti ubojica koji nehotice ubije svoga bližnjega a da prije nije imao mržnje prema njemu: da bi, bježeći u koji od ovih gradova, mogao spasiti svoj život. ");
INSERT INTO hrv_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","To su: Bezer u pustinji, u zemlji Mišoru, za Rubenovce; Ramot u Gileadu za Gadovce, i Golan u Bašanu za Manašeovce. ");
INSERT INTO hrv_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ovo je Zakon što ga je Mojsije postavio pred Izraelce; ");
INSERT INTO hrv_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ovo su upute, zakoni i uredbe što ih je Mojsije dao Izraelcima kad su izišli iz Egipta, ");
INSERT INTO hrv_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","s one strane Jordana, u dolini nasuprot Bet Peoru, u zemlji amorejskoga kralja Sihona, koji je živio u Hešbonu i koga su potukli Mojsije i Izraelci pošto iziđoše iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Njegovu su zemlju zauzeli i zemlju bašanskoga kralja Oga, dvaju amorejskih kraljeva koji su živjeli preko Jordana na istoku, ");
INSERT INTO hrv_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","od Aroera, koji se nalazi na obali potoka Arnona, do brda Sirjona, to jest Hermona, ");
INSERT INTO hrv_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","i svu Arabu preko Jordana, s istoka do mora u Arabi, pod obroncima Pisge. ");
INSERT INTO hrv_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mojsije sazva sav Izrael te im reče: “Čuj, Izraele, naredbe i zapovijedi što ih danas izričem u tvoje uši! Naučite ih, držite i vršite. ");
INSERT INTO hrv_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Jahve, Bog naš, sklopio je s nama Savez na Horebu. ");
INSERT INTO hrv_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Nije Jahve sklopio taj Savez s našim očevima, nego baš s nama svima koji smo danas ovdje živi. ");
INSERT INTO hrv_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Licem je u lice Jahve govorio s vama na brdu isred ognja. ");
INSERT INTO hrv_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Ja sam u ono vrijeme stajao između Jahve i vas da vam objavim Jahvine riječi, jer se vi, u strahu od ognja, niste htjeli peti na brdo. Rekao je: ");
INSERT INTO hrv_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","'Ja sam Jahve, Bog tvoj, koji sam te izveo iz zemlje egipatske, iz kuće ropstva. ");
INSERT INTO hrv_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Nemoj imati drugih bogova uz mene! ");
INSERT INTO hrv_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Ne pravi sebi lika ni obličja bilo čega što je gore na nebu, ili dolje na zemlji, ili u vodama pod zemljom. ");
INSERT INTO hrv_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ne klanjaj im se niti im služi. Jer ja, Jahve, Bog tvoj, Bog sam ljubomoran. Kažnjavam grijeh otaca - onih koji me mrze - na djeci do trećeg i četvrtog koljena, ");
INSERT INTO hrv_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","a iskazujem milosrđe tisućama koji me ljube i vrše moje zapovijedi. ");
INSERT INTO hrv_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Ne uzimaj uzalud imena Jahve, Boga svoga, jer Jahve ne oprašta onome koji uzalud izgovara ime njegovo. ");
INSERT INTO hrv_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Dan subotnji obdržavaj i svetkuj, kako ti je naredio Jahve, Bog tvoj. ");
INSERT INTO hrv_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Šest dana radi i obavljaj sav svoj posao. ");
INSERT INTO hrv_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","A sedmoga je dana subota, počinak posvećen Jahvi, Bogu tvome. Tada nikakva posla nemoj raditi: ni ti, ni sin tvoj, ni kći tvoja, ni sluga tvoj, ni sluškinja tvoja, ni vol tvoj, ni magarac tvoj, niti ikakvo živinče tvoje, niti došljak koji je unutar tvojih vrata; tako da mogne otpočinuti i sluga tvoj, i sluškinja tvoja kao i ti. ");
INSERT INTO hrv_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Sjeti se da si i ti bio rob u zemlji egipatskoj i da te odande izbavio Jahve, Bog tvoj, rukom jakom i ispruženom mišicom. Zato ti je zapovjedio Jahve, Bog tvoj, da držiš dan subotnji. ");
INSERT INTO hrv_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Poštuj oca svoga i majku svoju, kako ti je Jahve, Bog tvoj, zapovjedio, da dugo živiš i dobro ti bude na zemlji koju ti Jahve, Bog tvoj, daje. ");
INSERT INTO hrv_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Ne ubij! ");
INSERT INTO hrv_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Ne učini preljuba! ");
INSERT INTO hrv_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Ne ukradi! ");
INSERT INTO hrv_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Ne svjedoči lažno na bližnjega svoga! ");
INSERT INTO hrv_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Ne poželi žene bližnjega svoga! Ne poželi kuće bližnjega svoga, ni njive njegove, ni sluge njegova, ni sluškinje njegove, ni vola njegova, ni magarca njegova, niti išta što je bližnjega tvoga.' ");
INSERT INTO hrv_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Te je riječi na brdu, isred ognja, oblaka i guste tmine, jakim glasom upravio Jahve svemu vašem zboru. Ništa nije dodavao nego ih je ispisao na dvije kamene ploče te ih predao meni. ");
INSERT INTO hrv_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","A onda, kad čuste glas iz tmine, dok je brdo plamtjelo u ognju, k meni pristupiše svi vaši plemenski glavari i vaše starješine ");
INSERT INTO hrv_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","pa rekoše: 'Jahve, Bog naš, očitovao nam je, eto, svoju slavu i svoju veličajnost; čuli smo njegov glas isred ognja; danas smo vidjeli da čovjek može ostati na životu iako mu Bog govori. ");
INSERT INTO hrv_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","A sad, zašto da umremo? Ovaj bi nas veliki oganj mogao proždrijeti; budemo li dalje slušali glas Jahve, Boga svoga, mogli bismo umrijeti. ");
INSERT INTO hrv_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Jer, koji je smrtnik ikad slušao glas Boga živoga kako govori isred ognja - kao mi - i ostao na životu? ");
INSERT INTO hrv_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Ti se primakni i slušaj sve što će ti reći Jahve, Bog naš. A onda ti nama kaži sve što tebi Jahve, Bog naš, rekne, i mi ćemo to poslušati i izvršiti.' ");
INSERT INTO hrv_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Jahve je čuo vaše riječi kad ste mi govorili pa mi reče: 'Čuo sam riječi što ih je taj narod tebi upravio. Sve što su rekli dobro je. ");
INSERT INTO hrv_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Kad bi samo njihova srca bila takva da me se uvijek boje i drže sve moje zapovijedi, da tako vazda budu sretni, oni i njihovo potomstvo! ");
INSERT INTO hrv_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Hajde, reci im: Vratite se u svoje šatore! ");
INSERT INTO hrv_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","A ti ostani ovdje kod mene; kazat ću ti sve zapovijedi, zakone i uredbe kojima ćeš ih poučiti i koje će oni vršiti u zemlji što im je dajem u posjed.' ");
INSERT INTO hrv_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Pazite, dakle, da radite kako vam je Jahve, Bog vaš, naložio! Ne skrećite ni desno ni lijevo. ");
INSERT INTO hrv_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Slijedite potpuno put koji vam je Jahve, Bog vaš, označio, da tako uzmognete živjeti, imati sreću i dug život u zemlji koju ćete zaposjesti. ");
INSERT INTO hrv_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Ovo su zapovijedi, zakoni i uredbe koje mi Jahve, Bog vaš, zapovjedi da vas u njima poučim, kako biste ih vršili u zemlji u koju odlazite da je zaposjednete; ");
INSERT INTO hrv_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","da se svega svog vijeka bojiš Jahve, Boga svoga, ti, sin tvoj i sin tvoga sina, vršeći sve zakone njegove i sve zapovijedi njegove što ti ih danas propisujem, pa da imaš dug život. ");
INSERT INTO hrv_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Slušaj, Izraele, drži ih i vrši da ti dobro bude i da se razmnožiš u zemlji kojom teče med i mlijeko, kao što ti je obećao Jahve, Bog otaca tvojih. ");
INSERT INTO hrv_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Čuj, Izraele! Jahve je Bog naš, Jahve je jedan! ");
INSERT INTO hrv_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Zato ljubi Jahvu, Boga svoga, svim srcem svojim, svom dušom svojom i svom snagom svojom! ");
INSERT INTO hrv_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Riječi ove što ti ih danas naređujem neka ti se urežu u srce. ");
INSERT INTO hrv_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Napominji ih svojim sinovima. Govori im o njima kad sjediš u svojoj kući i kad ideš putem; kad liježeš i kad ustaješ. ");
INSERT INTO hrv_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Priveži ih na svoju ruku za znak i neka ti budu kao zapis među očima! ");
INSERT INTO hrv_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Ispiši ih na dovratnicima kuće svoje i na vratima svojim! ");
INSERT INTO hrv_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","A kad te Jahve, Bog tvoj, dovede u zemlju za koju se zakleo tvojim ocima, Abrahamu, Izaku i Jakovu, da će je tebi dati - u velike i lijepe gradove kojih nisi zidao; ");
INSERT INTO hrv_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","u kuće pune svakog dobra kojih nisi punio; na iskopane čatrnje kojih nisi kopao; u vinograde i maslinike kojih nisi sadio - i sit se najedeš: ");
INSERT INTO hrv_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","pazi da ne zaboraviš Jahvu koji te izveo iz zemlje egipatske, iz kuće ropstva. ");
INSERT INTO hrv_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Boj se Jahve, Boga svoga; njemu iskazuj štovanje; njegovim imenom polaži prisegu. ");
INSERT INTO hrv_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Ne idite za drugim bogovima između bogova drugih naroda što su oko vas. ");
INSERT INTO hrv_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Jer je Jahve, Bog tvoj, što stoji u sredini tvojoj, ljubomoran Bog; gnjev bi Jahve, Boga tvoga, usplamtio protiv tebe i istrijebio te sa zemlje. ");
INSERT INTO hrv_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Ne iskušavajte Jahvu, Boga svoga, kao što ste ga iskušavali kod Mase. ");
INSERT INTO hrv_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Točno vršite zapovijedi Jahve, Boga svoga, upute njegove i zakone njegove koje je izdao. ");
INSERT INTO hrv_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Čini što je pravo i dobro u očima Jahve da ti dobro bude i da se domogneš dobre zemlje za koju se Jahve zakleo tvojim ocima ");
INSERT INTO hrv_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","da će iz nje protjerati sve tvoje neprijatelje ispred tebe; tako je obećao Jahve. ");
INSERT INTO hrv_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","A kad te sutra zapita tvoj sin: što su te upute, zakoni i uredbe što ih je Jahve, Bog naš, vama propisao - ");
INSERT INTO hrv_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","kaži svome sinu: 'Bili smo faraonovi robovi u Egiptu, ali nas je Jahve izveo iz Egipta jakom rukom. ");
INSERT INTO hrv_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Na naše je oči Jahve učinio velike i strašne znakove i čudesa protiv Egipta, protiv faraona i protiv svega doma njegova, ");
INSERT INTO hrv_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","a nas je odande izveo da nas dovede i dade nam zemlju koju je zakletvom obećao ocima našim. ");
INSERT INTO hrv_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","I naredio nam je Jahve da sve ove naredbe vršimo u strahopoštovanju prema Jahvi, Bogu svome, da bismo uvijek bili sretni i da živimo kao što je to danas.' ");
INSERT INTO hrv_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Naša će, dakle, pravednost biti: držati i vršiti sve ove zapovijedi pred Jahvom, Bogom našim, kako nam je naredio. ");
INSERT INTO hrv_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Kad te Jahve, Bog tvoj, uvede u zemlju u koju ideš da je zaposjedneš i kad ispred tebe otjera mnoge narode: Hetite, Girgašane, Amorejce, Kanaance, Perižane, Hivijce i Jebusejce - sedam naroda brojnijih i jačih od tebe - ");
INSERT INTO hrv_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","te kad ih Jahve, Bog tvoj, preda tebi i ti ih poraziš, udari ih prokletstvom; nemoj sklapati s njima saveza niti im iskazuj milosti. ");
INSERT INTO hrv_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Ne sklapaj ženidbe s njima, ne udavaj svoje kćeri za njihova sina niti ženi svoga sina njihovom kćeri; ");
INSERT INTO hrv_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","jer bi ona odvratila od mene sina tvoga; drugim bi bogovima on služio; Jahve bi se razgnjevio protiv vas i brzo bi te istrijebio. ");
INSERT INTO hrv_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Nego ovako učinite prema njima: porušite njihove žrtvenike, porazbijajte njihove stupove, njihove ašere počupajte a njihove kumire spalite. ");
INSERT INTO hrv_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","TÓa ti si narod posvećen Jahvi, Bogu svome; tebe je Jahve, Bog tvoj, izabrao da među svim narodima koji su na zemlji budeš njegov predragi vlastiti narod. ");
INSERT INTO hrv_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Nije vas Jahve odabrao i prihvatio zato što biste vi bili brojniji od svih naroda - vi ste zapravo najmanji - ");
INSERT INTO hrv_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","nego zato što vas Jahve ljubi i drži zakletvu kojom se zakleo vašim ocima. Stoga vas je Jahve izveo jakom rukom i oslobodio vas iz kuće ropstva, ispod vlasti faraona, kralja egipatskoga. ");
INSERT INTO hrv_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Zato znaj da je Jahve, Bog tvoj, pravi Bog, Bog vjeran, koji drži svoj Savez i milost svoju iskazuje do tisuću koljena onima koji ga ljube i drže njegove zapovijedi. ");
INSERT INTO hrv_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","A onima koji ga mrze uzvraća izravno njima samima; uništava bez odgađanja onoga koji ga mrzi: uzvraća izravno njemu samomu. ");
INSERT INTO hrv_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Stoga drži zapovijedi, zakone i uredbe koje ti danas nalažem da ih vršiš. ");
INSERT INTO hrv_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","A za nagradu - budeš li slušao ove naloge, držao ih te izvršavao - Jahve, Bog tvoj, držat će ti Savez svoj i milost za koje se zakleo tvojim ocima. ");
INSERT INTO hrv_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Ljubit će te, blagoslivljati i razmnažati; blagoslivljat će plod utrobe tvoje i rod zemlje tvoje: žito tvoje, vino tvoje, ulje tvoje, mlad krava tvojih i prirast stoke tvoje u zemlji za koju se zakleo ocima tvojim da će je tebi dati. ");
INSERT INTO hrv_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Bit ćeš blagoslovljen nad sve narode; neće u tebe biti ni neplodna ni neplodne, ni među tvojom čeljadi ni među stokom tvojom. ");
INSERT INTO hrv_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Jahve će od tebe maknuti svaku bolest; neće na te pustiti ni jedno od strašnih zala egipatskih za koja znaš nego će njima pritiskati one koji te mrze. ");
INSERT INTO hrv_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Uništavaj sve narode koje ti Jahve, Bog tvoj, bude predavao. Neka ih ne sažaljuje oko tvoje. Nemoj se klanjati njihovim kumirima, jer bi ti to bilo zamkom. ");
INSERT INTO hrv_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Možda ćeš u svome srcu reći: 'Oni su narodi brojniji od mene, kako ću ih onda protjerati?' ");
INSERT INTO hrv_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Ne boj ih se! Sjeti se što je Jahve, Bog tvoj, učinio faraonu i svemu Egiptu! ");
INSERT INTO hrv_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Pomisli na velike kušnje što si ih vidio na svoje oči; na one znakove i čudesa pa na jaku ruku i ispruženu mišicu kojima te Jahve, Bog tvoj, izveo. Tako će Jahve, Bog tvoj, učiniti sa svim narodima kojih se plašiš. ");
INSERT INTO hrv_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Povrh toga, među njih će Jahve, Bog tvoj, slati stršljene dok ne izginu koji bi preostali i sakrili se pred tobom. ");
INSERT INTO hrv_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ne strepi, dakle, pred njima! TÓa Jahve, Bog tvoj, u sredini je tvojoj, Bog silan i strahovit. ");
INSERT INTO hrv_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Malo će pomalo Jahve, Bog tvoj, ispred tebe uništiti one narode; i nećeš ih moći ujedanput sve istrijebiti da se zvijeri ne bi protiv tebe razmnožile. ");
INSERT INTO hrv_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Ali Jahve, Bog tvoj, tebi će ih predati i među njih unositi stravu dok ne budu uništeni. ");
INSERT INTO hrv_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","I njihove će kraljeve predati u tvoje ruke da zatreš ime njihovo pod nebom. Nijedan se neće održati pred tobom dok ih ne uništiš. ");
INSERT INTO hrv_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Likove njihovih kumira spali! Ne hlepi za srebrom i zlatom što je na njima; ne uzimlji ga da ne budeš njime zaveden; jer bi to bilo gadno Jahvi, Bogu tvome. ");
INSERT INTO hrv_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Ne unosi gnusobe u svoju kuću da ne budeš udaren prokletstvom kao i ona; duboko je prezri i grozi se od nje jer je prokleta. ");
INSERT INTO hrv_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Držite i vršite sve zapovijedi koje vam danas naređujem da biste živjeli i raznmožili se i da biste ušli i zaposjeli zemlju koju je Jahve pod zakletvom obećao ocima vašim. ");
INSERT INTO hrv_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Sjećaj se svega puta kojim te Jahve, Bog tvoj, vodio po pustinji ovih četrdeset godina da te ponizi, iskuša i dozna što ti je u srcu: hoćeš li držati zapovijedi njegove ili nećeš. ");
INSERT INTO hrv_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Ponižavao te i glađu morio, a onda te hranio manom - za koju nisi znao ni ti ni tvoji oci - da ti pokaže kako čovjek ne živi samo o kruhu nego da čovjek živi o svemu što izlazi iz usta Jahvinih. ");
INSERT INTO hrv_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Tvoja se odjeća na tebi nije izderala niti su ti noge oticale ovih četrdeset godina. ");
INSERT INTO hrv_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Priznaj onda u svome srcu da te Jahve, Bog tvoj, odgaja i popravlja, kao što čovjek odgaja sina svoga. ");
INSERT INTO hrv_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","I drži zapovijedi Jahve, Boga svoga, hodeći putovima njegovim i bojeći se njega! ");
INSERT INTO hrv_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","TÓa Jahve, Bog tvoj, vodi te u dobru zemlju: zemlju potoka i vrela, dubinskih voda što izviru u dolinama i bregovima; ");
INSERT INTO hrv_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","zemlju pšenice i ječma, loze, smokava i šipaka, zemlju meda i maslina; ");
INSERT INTO hrv_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","zemlju u kojoj nećeš sirotinjski jesti kruha i gdje ti ništa neće nedostajati; zemlju gdje kamenje ima željeza i gdje ćeš iz njezinih brdina vaditi mjed. ");
INSERT INTO hrv_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Do sita ćeš jesti i blagoslivljati Jahvu, Boga svoga, zbog dobre zemlje koju ti je dao. ");
INSERT INTO hrv_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Čuvaj se da ne zaboraviš Jahvu, Boga svoga, zanemarujući njegove zapovijedi, njegove uredbe i njegove zakone koje ti danas dajem. ");
INSERT INTO hrv_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","I pošto se najedeš do sitosti, posagradiš lijepe kuće i u njima se nastaniš; ");
INSERT INTO hrv_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","kad ti se krupna i sitna stoka namnoži; kad se nakupiš srebra i zlata i kada sve tvoje uznapreduje, ");
INSERT INTO hrv_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","nemoj da se uznese srce tvoje i da zaboraviš Jahvu, Boga svoga, koji te izveo iz zemlje egipatske, iz kuće ropstva; ");
INSERT INTO hrv_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","koji te proveo kroz onu veliku i strašnu pustinju, kroz zemlju plamenih zmija i štipavaca, suhim i bezvodnim krajem; koji ti je izveo vodu iz stijene tvrde kao kremen; ");
INSERT INTO hrv_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","koji te u pustinji hranio manom, nepoznatom tvojim ocima, da te ponizi i da te iskuša te da na kraju budeš sretan. ");
INSERT INTO hrv_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ne reci tada u svome srcu: svojom sam moći i snagom svojih ruku sebi namakao ovo bogatstvo. ");
INSERT INTO hrv_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Sjeti se Jahve, Boga svoga! TÓa on ti je dao snagu da stječeš bogatstvo da tako ispuni - kao što je danas - svoj Savez za koji se zakleo tvojim ocima. ");
INSERT INTO hrv_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Ako li zaboraviš Jahvu, Boga svoga, i pođeš za drugim bogovima te njima budeš iskazivao štovanje, njima se klanjao, kunem vam se danas da ćete zacijelo izginuti; ");
INSERT INTO hrv_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","poput naroda koje će Jahve pogubiti pred vama, tako će i vas nestati jer niste poslušali glasa Jahve, Boga svoga. ");
INSERT INTO hrv_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Slušaj, Izraele! Danas prelaziš preko Jordana da sebi podvrgneš narode i veće i brojnije nego što si ti; velike gradove, s utvrdama do nebesa; ");
INSERT INTO hrv_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","narod velik i gorostasan poput Anakovaca, koje već poznaješ i o kojima si slušao: 'Tko da odoli Anakovcima?' ");
INSERT INTO hrv_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Znaj dakle danas da Jahve, Bog tvoj, ide pred tobom. On je vatra što proždire; on će ih oboriti, tebi ih podvrgnuti. A ti ćeš ih onda rastjerati i ubrzo pobiti, kako ti je Jahve i rekao. ");
INSERT INTO hrv_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Pošto ih otjera ispred tebe Jahve, Bog tvoj, nemoj reći u srcu svome: 'Jahve me uveo da zaposjednem ovu zemlju zbog moje pravednosti.' Naprotiv, zbog opačina onih naroda Jahve ih tjera ispred tebe. ");
INSERT INTO hrv_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ne ideš ti da zaposjedneš njihovu zemlju zbog svoje pravednosti i čestitosti svoga srca, nego zato što Jahve, Bog tvoj, zbog opačine onih naroda tjera njih ispred tebe da tako održi riječ kojom se zakleo tvojim ocima: Abrahamu, Izaku i Jakovu. ");
INSERT INTO hrv_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Znaj, dakle, da ti Jahve, Bog tvoj, ne daje ovu dobru zemlju u posjed zbog tvoje pravednosti, jer si ti narod tvrde šije! ");
INSERT INTO hrv_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Sjećaj se i ne zaboravljaj kako si u pustinji ljutio Jahvu, Boga svoga. Od dana kad ste izašli iz zemlje egipatske do dolaska na ovo mjesto, Jahvi ste se opirali. ");
INSERT INTO hrv_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Na Horebu ste rasrdili Jahvu i Jahve je na vas tako planuo da vas je htio uništiti. ");
INSERT INTO hrv_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Popeo sam se na brdo da primim kamene ploče, ploče Saveza što ga s vama sklopi Jahve. Na brdu sam ostao četrdeset dana i četrdeset noći: niti sam jeo kruha niti pio vode. ");
INSERT INTO hrv_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","I dade mi Jahve dvije kamene ploče, ispisane prstom Božjim, na kojima bijahu sve riječi što vam ih je Jahve isred ognja na brdu rekao na dan zbora. ");
INSERT INTO hrv_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Kad je prošlo četrdeset dana i četrdeset noći, Jahve mi dade dvije kamene ploče - ploče Saveza. ");
INSERT INTO hrv_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","I reče mi Jahve: 'Ustaj! Žurno siđi odavde, jer se pokvario narod tvoj koji si izveo iz Egipta. Brzo su zašli s puta koji sam im označio: već su sebi napravili livenog kumira.' ");
INSERT INTO hrv_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Još mi reče Jahve: 'Promatrao sam taj narod. Zbilja je to narod tvrde šije! ");
INSERT INTO hrv_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Pusti me da ih uništim i njihovo ime izbrišem pod nebesima, a od tebe da učinim narod i jači i brojniji nego što je ovaj!' ");
INSERT INTO hrv_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Okrenuh se i siđoh niz brdo, a brdo svejednako plamtjelo u ognju. Dvije ploče Saveza bijahu mi u rukama. ");
INSERT INTO hrv_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Pogledah: zbilja ste sagriješili protiv Jahve, Boga svoga. Salili ste sebi tele od kovine. Tako ste brzo zašli s puta što vam ga Jahve bijaše označio. ");
INSERT INTO hrv_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Pograbih dvije ploče te ih bacih od sebe objema rukama - razbih ploče pred vašim očima. ");
INSERT INTO hrv_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Onda se ničice bacih pred Jahvu. Četrdeset dana i četrdeset noći - kao i prije - niti sam jeo kruha niti pio vode zbog svih grijeha koje ste počinili radeći zlo u očima Jahve i srdeći ga. ");
INSERT INTO hrv_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Jer se bojah srdžbe i gnjeva kojim je Jahve usplamtio na vas da vas zatre. Ali me i tada Jahve usliša. ");
INSERT INTO hrv_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","I na Arona se Jahve silno rasrdio, htio ga uništiti. Tada se zauzeh i za Arona. ");
INSERT INTO hrv_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Vaš grijeh, tele što bijaste načinili, uzeh i sažegoh ga u vatri. U prah ga satrh i prah mu bacih u potok što teče s brda. ");
INSERT INTO hrv_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Kod Tabere, kod Mase i Kibrot Hataave srdili ste Jahvu. ");
INSERT INTO hrv_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Kad vas je Jahve slao od Kadeš Barnee govoreći: 'Idite gore i uzmite zemlju koju sam vam dao', pobunili ste se protiv riječi Jahve, Boga svoga; u nj se niste pouzdavali niti ste slušali njegov glas. ");
INSERT INTO hrv_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Nepokorni bijaste Jahvi otkad vas poznajem. ");
INSERT INTO hrv_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Zato sam pao ničice i ležao pred Jahvom četrdeset dana i četrdeset noći, jer Jahve bijaše rekao da će vas uništiti. ");
INSERT INTO hrv_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Jahvu sam molio i rekao: 'Gospodine moj, Jahve! Ne uništavaj naroda svoga, baštine svoje koju si izbavio u svojoj veličajnosti i svojom moćnom rukom izveo iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Sjeti se slugu svojih: Abrahama, Izaka i Jakova, a ne obaziri se na tvrdokornost ovoga naroda, na njegovu opačinu, na grijeh njegov, ");
INSERT INTO hrv_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","da se ne rekne u zemlji iz koje si nas izbavio: Jahve ih nije mogao uvesti u zemlju koju im je obećao, ili ih je mrzio pa ih je zato odveo da ih pomori u pustinji. ");
INSERT INTO hrv_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","A oni su tvoj narod, tvoja baština, oni koje si izveo svojom velikom moći i ispruženom mišicom.' ");
INSERT INTO hrv_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","U to vrijeme Jahve mi reče: 'Iskleši dvije kamene ploče kao i prijašnje pa se popni k meni na brdo; a napravi i drveni kovčeg. ");
INSERT INTO hrv_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Na ploče ću napisati riječi koje su bile na prvim pločama što si ih razbio. A onda ih položi u kovčeg.' ");
INSERT INTO hrv_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Načinih kovčeg od bagremovine, isklesah dvije kamene ploče kao što bijahu prve, pa se, s dvjema pločama u ruci, popeh na brdo. ");
INSERT INTO hrv_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","I napisa na te ploče, kao i prije, Deset riječi koje vam je Jahve rekao na brdu, isred ognja, na dan zbora. Onda ih Jahve dade meni. ");
INSERT INTO hrv_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Okrenuh se i siđoh s brda. Položih ploče u kovčeg koji bijah napravio. I stadoše ondje, kako mi je Jahve naredio. ");
INSERT INTO hrv_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Od Beerota sinova Jaakanovih odoše Izraelci u Moseru. Ondje umrije Aron i ondje bi pokopan. Svećenikom mjesto njega postade njegov sin Eleazar. ");
INSERT INTO hrv_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Odande odoše u Gudgodu; iz Gudgode u Jotbatu, u kraj bogat potocima. ");
INSERT INTO hrv_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","U to vrijeme odvoji Jahve pleme Levijevo da nosi Kovčeg saveza Jahvina; da pred Jahvom stoji u njegovoj službi te da u njegovo ime blagoslivlja, kako radi i danas. ");
INSERT INTO hrv_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Stoga Levi nema udjela ni baštine sa svojom braćom: Jahve je njegova baština, kako mu je Jahve, Bog tvoj, i rekao. ");
INSERT INTO hrv_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Na brdu sam ostao, kao i prvi put, četrdeset dana i četrdeset noći. I usliša me Jahve i taj put; nije htio da te uništi, ");
INSERT INTO hrv_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","nego mi Jahve reče: 'Ustaj! Idi pred ovim narodom da uđu i zaposjednu zemlju za koju sam se zakleo njihovim ocima da ću im je dati.' ");
INSERT INTO hrv_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Dakle, Izraele, što od tebe traži Jahve, Bog tvoj? Samo to da se bojiš Jahve, Boga svoga; da po svim putovima njegovim hodiš; da ga ljubiš i služiš Jahvi, Bogu svome, svim srcem svojim i svom dušom svojom; ");
INSERT INTO hrv_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","da držiš Jahvine zapovijedi i njegove zakone što ti ih danas za tvoje dobro dajem. ");
INSERT INTO hrv_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Evo, Jahvi, Bogu tvome, pripada nebo i nebo nad nebesima, zemlja i sve što je na njoj. ");
INSERT INTO hrv_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Ali Jahvi samo vaši oci omilješe i poslije njih izabrao je vas, potomke njihove, između svih naroda, kako je i danas. ");
INSERT INTO hrv_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Srce svoje obrežite; šiju više ne ukrućujte! ");
INSERT INTO hrv_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Jer Jahve, Bog vaš, Bog je nad bogovima, Gospodar nad gospodarima, Bog velik, jak i strašan, koji nije pristran i ne da se podmititi; ");
INSERT INTO hrv_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","daje pravdu siroti i udovici; ljubi pridošlicu, daje mu hranu i odjeću. ");
INSERT INTO hrv_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Ljubite i vi pridošlicu, jer ste i sami bili pridošlice u zemlji egipatskoj. ");
INSERT INTO hrv_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Boj se Jahve, Boga svojeg; njemu služi; uza nj se priljubi; njegovim imenom priseži. ");
INSERT INTO hrv_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","On je tvoja slava, Bog tvoj, koji je radi tebe učinio velika i čudesna djela što su ih vidjele tvoje oči. ");
INSERT INTO hrv_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Tvojih otaca, kad su se spustili u Egipat, bješe samo sedamdeset, a sad je Jahve, Bog tvoj, učinio te vas ima kao zvijezda na nebu. ");
INSERT INTO hrv_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Ljubi, dakle, Jahvu, Boga svoga, i vrši u sve dane njegove naredbe, njegove zakone, uredbe i zapovijedi. ");
INSERT INTO hrv_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Vi, a ne vaši sinovi, koji nisu ni upoznali ni vidjeli pouke Jahve, Boga vašega, danas ste se osvjedočili o njegovoj veličajnosti, o njegovoj moćnoj ruci, ispruženoj mišici, ");
INSERT INTO hrv_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","o znamenjima njegovima i o djelima što ih učini usred Egipta na faraonu, kralju egipatskom, i na svoj zemlji njegovoj; ");
INSERT INTO hrv_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","što je učinio egipatskoj vojsci, njihovim konjima i kolima; kako ih je preplavio vodama Crvenog mora kad su vas progonili i kako ih je zatro do današnjeg dana; ");
INSERT INTO hrv_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","što je za vas radio u pustinji dok ne stigoste do ovoga mjesta; ");
INSERT INTO hrv_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","što je učinio s Datanom i Abiramom, sinovima Eliaba, Rubenova potomka, kad zemlja rastvori ralje svoje te ih proguta sred svega Izraela, njih i njihove obitelji, njihove šatore i sve što imahu. ");
INSERT INTO hrv_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Vaše su oči vidjele sva ta velika djela što ih je Jahve učinio. ");
INSERT INTO hrv_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Zato držite sve zapovijedi što vam ih danas naređujem da budete jaki te uzmete u posjed zemlju u koju idete da je osvojite; ");
INSERT INTO hrv_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","napokon, da dugo živite u zemlji za koju se zakleo Jahve ocima vašim da će je dati njima i njihovu potomstvu - zemlju kojom teče med i mlijeko. ");
INSERT INTO hrv_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Jer zemlja u koju ideš da je zaposjedneš nije kao zemlja egipatska iz koje ste izašli, gdje si, posijavši sjeme, morao svoj usjev svojom nogom natapati kao što se natapa povrtnjak. ");
INSERT INTO hrv_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Zemlja u koju idete da je zaposjednete zemlja je bregova i dolova i natapa je dažd nebeski; ");
INSERT INTO hrv_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","zemlja nad kojom Jahve, Bog tvoj, bdi; na kojoj oči Jahve, Boga tvoga, uvijek počivaju, od početka do svršetka godine. ");
INSERT INTO hrv_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Zato, ako doista poslušate zapovijedi koje vam danas izdajem i budete ljubili Jahvu, Boga svoga, i služili mu svim srcem svojim i svom dušom svojom, ");
INSERT INTO hrv_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","davat ću vašoj zemlji kišu u pravo vrijeme: u jesen i u proljeće, i moći ćeš sabirati svoje žito, svoje vino i svoje ulje; ");
INSERT INTO hrv_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","travu ću davati po tvome polju tvome blagu. Tako ćeš jesti i biti sit. ");
INSERT INTO hrv_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Pazite da se vaše srce ne zavede, da ne pođete stranputicom, da drugim bogovima ne iskazujete štovanje i da im se ne klanjate. ");
INSERT INTO hrv_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Jer tada bi na vas Jahve usplamtio gnjevom: nebesa bi zatvorio; kiše ne bi bilo; zemlja ne bi davala roda i vas bi brzo nestalo s te dobre zemlje koju vam Jahve daje. ");
INSERT INTO hrv_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Utisnite ove moje riječi u svoje srce i svoju dušu; kao znak ih privežite na svoju ruku; neka vam budu kao zapis među očima! ");
INSERT INTO hrv_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Poučite u njima svoje sinove; izgovarajte ih kad sjedite u svojoj kući i kad idete putem; kad liježete i kad ustajete. ");
INSERT INTO hrv_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Ispišite ih na dovratnike svoje kuće i na svoja vrata ");
INSERT INTO hrv_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","da vaši dani i dani vaših sinova u zemlji za koju se Jahve zakleo vašim ocima da će im je dati - budu brojni kao dani nebesa nad zemljom. ");
INSERT INTO hrv_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Ako budete vjerno držali sve ove zapovijedi koje vam naređujem, vršili ih i ljubili Jahvu, Boga svoga, hodili svim njegovim putovima i čvrsto se priljubili uz njega, ");
INSERT INTO hrv_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","Jahve će ispred vas protjerati sve te narode i vi ćete s posjeda odagnati narode brojnije i jače od sebe. ");
INSERT INTO hrv_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Svako mjesto na koje stupi vaša noga bit će vaše; od pustinje i Libanona, od Rijeke, rijeke Eufrata, do Zapadnog mora sterat će se vaše područje. ");
INSERT INTO hrv_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Nitko se neće održati pred vama; strah i trepet raširit će Jahve, Bog vaš, po svoj zemlji u koju stupite, kako vam je rekao. ");
INSERT INTO hrv_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Gledajte! Nudim vam danas blagoslov i prokletstvo: ");
INSERT INTO hrv_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","blagoslov, budete li slušali zapovijedi Jahve, Boga svoga, koje vam danas dajem; ");
INSERT INTO hrv_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","a prokletstvo, ne budete li slušali zapovijedi Jahve, Boga svoga, nego sađete s puta koji vam danas određujem te pođete za drugim bogovima kojih niste poznavali. ");
INSERT INTO hrv_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Kada te Jahve, Bog tvoj, uvede u zemlju u koju ideš da je zaposjedneš, tada nad gorom Gerizimom izreci blagoslov, a prokletstvo nad gorom Ebalom. ");
INSERT INTO hrv_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Te se gore izdižu, kako znate, s onu stranu Jordana, za putom prema zapadu, u zemlji Kanaanaca, koji žive u Arabi, nasuprot Gilgalu, uz Hrast More. ");
INSERT INTO hrv_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Eto ćete prijeći preko Jordana da zaposjednete zemlju koju vam daje Jahve, Bog vaš. Zaposjednite je i nastanite se u njoj. ");
INSERT INTO hrv_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Ali držite i vršite sve zakone i uredbe koje vam danas izlažem. ");
INSERT INTO hrv_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Ovo su zakoni i uredbe što vam ih valja držati i vršiti u zemlji koju vam Jahve, Bog otaca vaših, daje u posjed za sve dane što budete živjeli na zemlji. ");
INSERT INTO hrv_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Sravnite sa zemljom sva mjesta na kojima su narodi koje ćete protjerati iskazivali štovanje svojim bogovima, nalazila se ona na visokim brdima, na humovima ili pod kakvim zelenim drvetom. ");
INSERT INTO hrv_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Porušite njihove žrtvenike, porazbijajte njihove stupove, spalite im ašere; smrvite kipove njihovih bogova, zatrite im imena s onih mjesta. ");
INSERT INTO hrv_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Jahvi, Bogu svome, nemojte onako iskazivati štovanje. ");
INSERT INTO hrv_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Jahvu, Boga svoga, tražite jedino na mjestu koje je on odabrao, sred svih vaših plemena, da ondje stavi svoje ime i da ondje prebiva; ");
INSERT INTO hrv_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","onamo donosite svoje paljenice i svoje klanice, svoje desetine i darove svojih ruku, svoje zavjetne i dragovoljne prinose i prvine od svoga krupnoga i sitnoga blaga. ");
INSERT INTO hrv_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Blagujte ondje, vi i vaše obitelji, u nazočnosti Jahve, Boga svoga; veselite se svime što su vaše ruke namaknule i što vam je Jahve, Bog vaš, blagoslovom udijelio. ");
INSERT INTO hrv_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Nemojte raditi čak ni kako radimo ovdje danas - svatko što se njemu čini dobro - ");
INSERT INTO hrv_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","jer još niste stigli u Počivalište, u baštinu koju ti daje Jahve, Bog tvoj. ");
INSERT INTO hrv_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Ali kad prijeđete preko Jordana i nastanite se u zemlji koju vam Jahve, Bog vaš, daje u baštinu, kad vas smiri od svih neprijatelja koji budu oko vas te budete živjeli bez straha, ");
INSERT INTO hrv_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","onda ćete donositi sve što vam naređujem: svoje paljenice, svoje klanice, svoje desetine, darove svojih ruku i sve svoje izabrane zavjetnice koje budete zavjetovali Jahvi - na mjesto koje Jahve, Bog vaš, odabere da ondje nastani svoje ime. ");
INSERT INTO hrv_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Veselite se tada pred Jahvom, Bogom svojim, vi, vaši sinovi i kćeri, vaše sluge i sluškinje i levit koji bude u vašim gradovima, jer on nema s vama udjela ni baštine. ");
INSERT INTO hrv_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Pazi da ne prinosiš svojih žrtava paljenica na bilo kojem mjestu što ga zamijetiš, ");
INSERT INTO hrv_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","nego samo na mjestu što ga odabere Jahve, u jednome od tvojih plemena. Tu prinosi svoje paljenice i tu obavljaj sve što ti naređujem. ");
INSERT INTO hrv_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Ali svaki put kad ti srce zaželi, možeš zaklati i jesti mesa u svim svojim gradovima, prema blagoslovu koji ti Jahve, Bog tvoj, bude davao. I nečist i čist može ga jesti, kao da je od srne ili jelena. ");
INSERT INTO hrv_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Ali krvi nemojte blagovati; istočite je na zemlju kao vodu. ");
INSERT INTO hrv_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Po svojim gradovima nemojte jesti desetine svoga žita, svoga vina, svoga ulja ni prvine svoga krupnog ili sitnog blaga; niti išta od svojih zavjetovanih i od svojih dragovoljnih prinosa, ni od prinosa svojih ruku, ");
INSERT INTO hrv_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","nego ćeš to blagovati pred Jahvom, Bogom svojim, u mjestu koje Jahve, Bog tvoj, odabere, ti, tvoj sin, tvoja kći, tvoj sluga, tvoja sluškinja i levit koji bude u tvojim gradovima. Proveseli se u nazočnosti Jahve, Boga svoga, svime što ti ruka namakne. ");
INSERT INTO hrv_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Pazi da nikad ne zaboraviš levita dok si na svojoj zemlji. ");
INSERT INTO hrv_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Kad ti Jahve, Bog tvoj, proširi tvoje područje, kao što ti je rekao, i ti rekneš: 'Ja bih jeo mesa' - jer želiš jesti mesa - možeš ga jesti koliko ti duša želi. ");
INSERT INTO hrv_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Bude li mjesto koje Jahve, Bog tvoj, odabere da u njemu svoje ime smjesti daleko od tebe, onda možeš zaklati bilo što od svoje krupne ili sitne stoke što ti je Jahve dadne - kako sam ti već naredio - te jesti u bilo kojem svome gradu koliko ti duša želi. ");
INSERT INTO hrv_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Jedi ga ipak onako kako se jede srna ili jelen: neka ga jedu zajedno čisti i nečisti. ");
INSERT INTO hrv_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Samo, pazi da ne jedeš krvi! Ta krv je život. Ne smiješ jesti život s mesom. ");
INSERT INTO hrv_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Ne blaguj je; istoči je na zemlju kao vodu. ");
INSERT INTO hrv_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Ne smiješ je jesti, da bude dobro i tebi i tvojim sinovima poslije tebe kad činiš što je pravo u očima Jahvinim. ");
INSERT INTO hrv_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Ali svoje posvećene prinose i svoje zavjetne prinose uzmi i nosi na mjesto koje Jahve odabere. ");
INSERT INTO hrv_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Tu prinesi svoje paljenice, meso i krv, na žrtveniku Jahve, Boga svoga. Ali krv od svojih klanica istoči na žrtvenik Jahve, Boga svoga, a meso pojedi. ");
INSERT INTO hrv_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Drži i vrši sve ove naredbe što ti ih propisujem, da bude dobro zauvijek tebi i tvojim sinovima poslije tebe kad činiš što je dobro i pravedno u očima Jahve, Boga svoga. ");
INSERT INTO hrv_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","A kad Jahve, Bog tvoj, istrijebi narode na koje ideš da ih otjeraš s posjeda ispred sebe i kad ih otjeraš te se u njihovoj zemlji nastaniš, ");
INSERT INTO hrv_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","čuvaj se da ne padneš u zamku; ne pođi za njima pošto budu uništeni ispred tebe. Ne istražuj o njihovim bogovima i ne govori: 'Kako su oni narodi štovali svoje bogove, tako ću i ja.' ");
INSERT INTO hrv_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Nemoj onako postupati prema Jahvi, Bogu svome. TÓa Jahvi je zazorno i mrsko sve što su oni činili svojim bogovima. Čak su svoje sinove i kćeri spaljivali u čast svojim bogovima. ");
INSERT INTO hrv_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Sve što vam naređujem držite; tomu ništa ne domeći i ništa ne oduzimaj. ");
INSERT INTO hrv_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","Ako se u tvojoj sredini pojavi kakav prorok ili čovjek sa snoviđenjima pa ti iznese kakvo znamenje ili čudo; ");
INSERT INTO hrv_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","i to se znamenje ili čudo o kojem ti je govorio ispuni i onda ti on rekne: 'Pođimo sad za drugim bogovima kojih dosad ne poznaješ i njima iskazujmo štovanje', ");
INSERT INTO hrv_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","nemoj slušati riječi toga proroka ni sne toga sanjača: tÓa to vas iskušava Jahve, Bog vaš; hoće da dozna ljubite li zbilja Jahvu, Boga svoga, svim srcem svojim i svom dušom svojom. ");
INSERT INTO hrv_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Idite samo za Jahvom, Bogom svojim; njega se bojte; njegove zapovijedi vršite; njegov glas slušajte; njemu štovanje iskazujte; uz njega se priljubite. ");
INSERT INTO hrv_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","A onaj prorok ili sanjač neka se pogubi jer je poticao na otpad od Jahve, Boga vašega, koji vas je izveo iz zemlje egipatske i otkupio vas iz kuće ropstva. Onaj te htio zavesti s puta kojim ti je Jahve, Bog tvoj, naredio da ideš. Tako treba da iskorijeniš zlo iz svoje sredine. ");
INSERT INTO hrv_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","Kad bi te brat tvoj, sin majke tvoje, ili sin tvoj vlastiti, kći tvoja, žena u tvom naručju ili prijatelj tvoj koji ti je kao i život, potajno zavodio govoreći: 'Hajde da iskazujemo štovanje drugim bogovima', kojih ne poznaješ ni ti niti su ih poznavali tvoji oci, ");
INSERT INTO hrv_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","bogovima onih naroda što oko vas budu, bilo tebi blizu bilo od tebe daleko, od jednoga kraja zemlje do drugoga - ");
INSERT INTO hrv_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","nemoj pristati niti ga slušaj! Neka ga tvoje oko ne sažaljuje; ne štedi ga i ne sakrivaj ga ");
INSERT INTO hrv_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","nego ga ubij! Neka se najprije tvoja ruka digne na nj da ga usmrtiš, a onda ruka svega naroda. ");
INSERT INTO hrv_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Zaspi ga kamenjem dok ne umre, jer je kušao da te odvrati od Jahve, Boga tvoga, koji te izvede iz zemlje egipatske, iz kuće ropstva. ");
INSERT INTO hrv_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Sav će se Izrael, kad to čuje, napuniti strahom te više neće počinjati takva zla u tvojoj sredini. ");
INSERT INTO hrv_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","Ako u kojem tvome gradu što ti ga Jahve, Bog tvoj, dadne da se u njemu nastaniš, čuješ gdje govore: ");
INSERT INTO hrv_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","'Pojavile se ništarije iz tvoje sredine i zavedoše žitelje svoga grada kazujući: Hajde da služimo drugim bogovima! - kojih vi inače ne poznajete - ");
INSERT INTO hrv_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","tada dobro istraži, raspitaj se i temeljito izvidi. Bude li istina i doista se ta grozota učinila u tvojoj sredini, ");
INSERT INTO hrv_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","onda posijeci oštrim mačem stanovništvo toga grada, izvrši nad njim kleto uništenje i nad svime što bude u njemu. ");
INSERT INTO hrv_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Snesi onda sav plijen nasred trga te spali grad sa svim plijenom kao paljenicu Jahvi, Bogu svome. Neka zauvijek ostane ruševina i neka se više nikada ne sazida. ");
INSERT INTO hrv_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","Od onoga što je bilo prokletstvom udareno neka ništa ne prione za tvoju ruku, da Jahve odustane od žestine svoga gnjeva; da ti iskaže milosrđe, smiluje ti se i razmnoži te, kako se zakleo tvojim ocima ");
INSERT INTO hrv_vpl VALUES ("DT13_19","006_13_19","DEU","13","19","19","ako ti budeš slušao glas Jahve, Boga svoga, držeći sve njegove zapovijedi koje ti danas naređujem i vršeći što je pravo u očima Jahve, Boga tvoga. ");
INSERT INTO hrv_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Vi ste sinovi Jahve, Boga svoga. Nemojte na sebi praviti ureza ni podstriga na čelu za pokojnikom. ");
INSERT INTO hrv_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","TÓa ti si narod posvećen Jahvi, Bogu svome; Jahve je odabrao tebe između svih naroda na zemlji da budeš njegov narod, njegova predraga svojina. ");
INSERT INTO hrv_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Ništa odvratno nemojte jesti. ");
INSERT INTO hrv_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Ovo su životinje koje možete jesti: vol, ovca, koza, ");
INSERT INTO hrv_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","jelen, srna, srndać, kozorog, antilopa, bivol i divokoza; ");
INSERT INTO hrv_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","možete jesti svaku životinju koja ima razdvojene papke - nadvoje posve razdvojene - i koja preživa. ");
INSERT INTO hrv_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Samo od preživača ili od životinja s razdvojenim čaporcima ne možete jesti ove : devu, arnebeta i svisca. Te, naime, iako preživaju, nemaju razdvojenih papaka; neka su za vas nečiste. ");
INSERT INTO hrv_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","A svinja, premda ima papke razdvojene, ne preživa: neka je za vas nečista. Njezina mesa nemojte jesti niti se njezina strva doticati. ");
INSERT INTO hrv_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","A od svega što u vodi živi ovo možete jesti: što god ima ljuske i peraje, možete jesti. ");
INSERT INTO hrv_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","A što nema ljusaka i peraja, ne smijete jesti. To neka je za vas nečisto. ");
INSERT INTO hrv_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Svaku čistu pticu možete jesti. ");
INSERT INTO hrv_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Ali ovih ne smijete jesti: orla strvinara i jastreba, ");
INSERT INTO hrv_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","tetrijeba, sokola bilo koje vrste; ");
INSERT INTO hrv_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","gavrana bilo koje vrste; ");
INSERT INTO hrv_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","noja, kopca, galeba ni kraguja bilo koje vrste; ");
INSERT INTO hrv_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","sove, jejine i labuda; ");
INSERT INTO hrv_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","pelikana, bijelog strvinara i gnjurca; ");
INSERT INTO hrv_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","rode, čaplje bilo koje vrste; pupavca i šišmiša. ");
INSERT INTO hrv_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Svi krilati kukci neka su za vas nečisti - ne smijete ih jesti. ");
INSERT INTO hrv_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Sve krilato čisto možete jesti. ");
INSERT INTO hrv_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Ne smijete jesti ništa što crkne. Daj to pridošlici koji boravi u tvojim gradovima neka jede ili pak prodaj tuđincu. Jer ti si narod posvećen Jahvi, Bogu svome. Ne kuhaj kozleta u mlijeku njegove majke! ");
INSERT INTO hrv_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Odvajaj desetinu dohotka svake godine od svega što tvoj usjev u polju donese. ");
INSERT INTO hrv_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","A onda blaguj desetine svoga žita, svoga vina, svoga ulja i prvine svoje krupne i sitne stoke u nazočnosti Jahve, Boga svoga, na mjestu koje on odabere da svoje ime ondje nastani; da se tako naučiš zauvijek bojati se Jahve, Boga svoga. ");
INSERT INTO hrv_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Bude li ti put predug te ne mogneš donijeti desetine - jer je mjesto što ga Jahve odabere da u njemu nastani svoje ime previše daleko od tebe - tada, kad te Jahve, Bog tvoj, blagoslovi, ");
INSERT INTO hrv_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","prodaj to za novac, uzmi novac u ruku pa idi u mjesto što ga odabere Jahve, Bog tvoj. ");
INSERT INTO hrv_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Ondje za novac kupi što želiš: goveče, sitno živinče, vino ili opojno piće - što god ti duša zaželi. Ondje u nazočnosti Jahve, Boga svoga, blaguj i veseli se ti i tvoji ukućani. ");
INSERT INTO hrv_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Ne zanemaruj levita koji bude u tvojim gradovima, jer on nema udjela ni baštine s tobom. ");
INSERT INTO hrv_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Na kraju svake treće godine iznesi svu desetinu svoga prihoda od te godine i položi je na svoja vrata. ");
INSERT INTO hrv_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","Pa neka dođe levit - jer nema udjela ni baštine s tobom - došljak, sirota i udovica koji budu živjeli u tvom gradu i neka jedu i neka se nasite. Tako će te blagoslivljati Jahve, Bog tvoj, u svim poslovima što ih tvoja ruka poduzme. ");
INSERT INTO hrv_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Na završetku sedme godine opraštaj dugove. ");
INSERT INTO hrv_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Ovako neka bude opraštanje: neka svatko oprosti dužniku svoje potraživanje; neka ne utjeruje duga od svoga bližnjega ni od svoga brata kad se jednom proglasi Jahvino otpuštanje dugova. ");
INSERT INTO hrv_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Možeš tražiti od tuđina, ali ono što se tvoga nađe kod tvoga brata treba da otpustiš, ");
INSERT INTO hrv_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","da ne bude siromaha kod tebe. TÓa Jahve će te obilno blagoslivljati u zemlji koju ti Jahve, Bog tvoj, daje u baštinu da je zaposjedneš, ");
INSERT INTO hrv_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","samo ako budeš dobro slušao glas Jahve, Boga svoga, držeći i vršeći sve ove zapovijedi što ti ih danas naređujem. ");
INSERT INTO hrv_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Jahve, Bog tvoj, blagoslivljat će te kako ti je obećao te ćeš moći zajmove davati mnogim narodima, a sam ih nećeš morati uzimati; i nad mnogim ćeš narodima vladati, dok oni nad tobom neće gospodariti. ");
INSERT INTO hrv_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Nađe li se kod tebe kakav siromah, netko od tvoje braće u kojem god gradu u zemlji što ti je Jahve, Bog tvoj, dadne, ne budi tvrda srca niti zatvaraj svoje ruke prema svome siromašnome bratu, ");
INSERT INTO hrv_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","nego mu širom rastvori svoju ruku i spremno mu daj što mu nedostaje. ");
INSERT INTO hrv_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Čuvaj se da ti se u srcu ne porodi opaka misao te rekneš: 'Sedma se godina, godina otpuštanja dugova, već približuje' - i da prijekim okom pogledaš svoga siromašnog brata i ništa mu ne dadneš. On bi zazvao Jahvu protiv tebe i grijeh bi bio na tebi. ");
INSERT INTO hrv_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Daj mu rado, a ne da ti srce bude zlovoljno kad mu daješ, jer će te zbog toga blagoslivljati Jahve, Bog tvoj, u svakom poslu tvome i u svakom pothvatu ruku tvojih. ");
INSERT INTO hrv_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Kako siromaha nikad neće nestati iz zemlje, zapovijedam ti: širom otvaraj svoju ruku svome bratu, svome siromahu i potrebitu u zemlji svojoj. ");
INSERT INTO hrv_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Ako se tebi proda brat tvoj - Hebrejac ili Hebrejka - neka ti služi šest godina, a sedme ga godine otpusti od sebe slobodna. ");
INSERT INTO hrv_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Kad ga slobodna od sebe otpustiš, ne šalji ga praznih ruku. ");
INSERT INTO hrv_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Daruj ga čime između stoke svoje, s gumna svoga i iz badnja svoga; čime te već Jahve, Bog tvoj, blagoslovio, od toga i njemu daj. ");
INSERT INTO hrv_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Sjećaj se kako si bio rob u zemlji egipatskoj i kako te Jahve, Bog tvoj, otkupio. Zato ti ovo zapovijedam danas. ");
INSERT INTO hrv_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Ali ako ti on kaže: 'Neću da odlazim od tebe', jer voli tebe i dom tvoj i jer mu je kod tebe bilo dobro - ");
INSERT INTO hrv_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","uzmi tada šilo i probuši mu uho na vratima, i neka ti bude robom zauvijek! Tako isto učini i sa svojom sluškinjom. ");
INSERT INTO hrv_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Kad ga budeš otpuštao od sebe slobodna, neka ti ne bude teško, jer je zavrijedio dvostruku najamničku plaću za šest godina što ti je služio. Zato će te Jahve, Bog tvoj, blagosloviti u svemu što budeš radio. ");
INSERT INTO hrv_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Sve muške prvine što ih omladi tvoja krupna i sitna stoka posveti Jahvi, Bogu svome! Stoga vola prvenca nemoj uprezati niti strići prvenca od svoje sitne stoke. ");
INSERT INTO hrv_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Blaguj ga ti i tvoj dom svake godine u nazočnosti Jahve, Boga svoga, u mjestu što ga odabere Jahve. ");
INSERT INTO hrv_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Ali ako bi imali kakvu manu, ako bi bili hromi ili slijepi ili imali kakvu god ružnu manu, nemoj ih žrtvovati Jahvi, Bogu svomu! ");
INSERT INTO hrv_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Pojedi ih u svojoj kući. I nečist i čist mogu ih jesti, kao srnu i jelena. ");
INSERT INTO hrv_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Jedino krvi njihove ne smiješ jesti! Istoči je na zemlju kao vodu. ");
INSERT INTO hrv_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Drži mjesec Abib i slavi Pashu u čast Jahvi, Bogu svome, jer te Jahve, Bog tvoj, u mjesecu Abibu izveo noću iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Kao pashu u čast Jahvi, Bogu svome, žrtvuj ovce i goveda u mjestu koje Jahve odabere da u njemu nastani ime svoje. ");
INSERT INTO hrv_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Ništa ukvasano nemoj s njome jesti; nego sedam dana jedi beskvasan kruh - kruh nevoljnički - budući da si u žurbi izišao iz zemlje egipatske: da se svega svog vijeka sjećaš dana kad si izišao iz zemlje egipatske. ");
INSERT INTO hrv_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Neka se sedam dana u tebe ne vidi kvasac na svemu tvome području i ništa od mesa žrtve što je zakolješ navečer prvoga dana ne smije ostati preko noći do jutra. ");
INSERT INTO hrv_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Nije ti dopušteno žrtvovati pashu u bilo kojem gradu što ti ga dadne Jahve, Bog tvoj, ");
INSERT INTO hrv_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","nego u mjestu koje odabere Jahve, Bog tvoj, da ondje nastani ime svoje; samo tu žrtvuj pashu u predvečerje, o zalasku sunca, jer u to si vrijeme izišao iz Egipta. ");
INSERT INTO hrv_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Skuhaj je i pojedi na mjestu koje odabere Jahve, Bog tvoj. Ujutro se onda okreni i zaputi svojim šatorima. ");
INSERT INTO hrv_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Šest dana jedi beskvasan kruh, a sedmoga dana neka bude svečani zbor u čast Jahvi, Bogu tvome. Posla nikakva ne radi! ");
INSERT INTO hrv_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Nabroj sedam tjedana; a tih sedam tjedana uzmi brojiti kad srp počne žeti klasje. ");
INSERT INTO hrv_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Tada drži Blagdan sedmica u čast Jahvi, Bogu svome, prinoseći dragovoljni prinos iz svoje ruke, kako te već Jahve, Bog tvoj, bude blagoslovio. ");
INSERT INTO hrv_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","I proveseli se tada u nazočnosti Jahve, Boga svoga - na mjestu što ga Jahve, Bog tvoj, odabere da ondje nastani ime svoje - ti, sin tvoj i kći tvoja, sluga tvoj i sluškinja tvoja, levit koji bude u tvome gradu, došljak, sirota i udovica što budu kod tebe. ");
INSERT INTO hrv_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Sjećaj se da si i sam bio rob u Egiptu. Zato drži i vrši ove uredbe. ");
INSERT INTO hrv_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Blagdan sjenica slavi sedam dana pošto pokupiš plodove sa svoga gumna i iz svoga badnja. ");
INSERT INTO hrv_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Proveseli se na svoj blagdan ti, sin tvoj, kći tvoja, sluga tvoj, sluškinja tvoja, levit i došljak, sirota i udovica što se nađe u tvome gradu. ");
INSERT INTO hrv_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Svetkuj u čast Jahvi, Bogu svome, sedam dana na mjestu koje odabere Jahve, jer će te Jahve, Bog tvoj, blagoslovom obasipati u svim tvojim žetvama, u svakom poslu ruku tvojih, da budeš potpuno veseo. ");
INSERT INTO hrv_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Triput u godini neka se pokažu svi tvoji muškarci pred Jahvom, Bogom tvojim, na mjestu koje on odabere: na Blagdan beskvasnog kruha, na Blagdan sedmica i na Blagdan sjenica. Ali neka nitko ne dođe pred Jahvu praznih ruku, ");
INSERT INTO hrv_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","nego neka svatko prinese što može, prema blagoslovu koji ti je udijelio Jahve, Bog tvoj. ");
INSERT INTO hrv_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","U svakom gradu koji ti dade Jahve, Bog tvoj, postavi suce i nadglednike za svoja plemena da narodom pravedno upravljaju. ");
INSERT INTO hrv_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Ne iskrivljuj pravde; ne budi pristran; ne primaj mita, jer mito zasljepljuje oči mudrih, a ugrožava stvar pravednih. ");
INSERT INTO hrv_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Teži za samom pravdom, da dugo živiš i zaposjedneš zemlju koju ti Jahve, Bog tvoj, daje. ");
INSERT INTO hrv_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Ne postavljaj ašere ni od kakva drveta oko žrtvenika Jahve, Boga svoga, koji podigneš; ");
INSERT INTO hrv_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","i ne podiži stupova, jer su na zazor Jahvi, Bogu tvome. ");
INSERT INTO hrv_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Ne žrtvuj Jahvi, Bogu svome, ni vola ni ovna koji bi na sebi imao manu ili kakvo zlo, jer bi to bilo ružno pred Jahvom, Bogom tvojim. ");
INSERT INTO hrv_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Ako se u tvojoj sredini - u bilo kojem tvojem gradu što ti ga dade Jahve, Bog tvoj - nađe čovjek ili žena da učini što je zlo u očima Jahve, Boga tvoga, i krši njegov Savez: ");
INSERT INTO hrv_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","otišavši da iskazuje štovanje drugim bogovima te se pokloni njima, suncu, mjesecu ili bilo čemu od nebeske vojske, a što sam ja zabranio, ");
INSERT INTO hrv_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","i tebi se to javi i ti to čuješ, onda pomno istraži; i bude li istina i doista se ta grozota učinila u Izraelu, ");
INSERT INTO hrv_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","onda toga čovjeka ili tu ženu koji učiniše takvu opačinu izvedi na gradska vrata te ih kamenuj da poginu. ");
INSERT INTO hrv_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Na smrt osuđeni neka se pogubi na iskaz dvojice ili trojice svjedoka. Na riječ jednoga svjedoka ne smije se pogubiti. ");
INSERT INTO hrv_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Neka najprije svjedoci dignu ruku na nj da ga smaknu, a poslije toga neka je digne sav narod. Tako ćeš iskorijeniti zlo iz svoje sredine. ");
INSERT INTO hrv_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Bude li ti preteško štogod rasuditi: ubojstvo, sukob o pravima, kakvu ozljedu ili svađu u tvome gradu, tada ustani i pođi u mjesto što ga odabere Jahve, Bog tvoj. ");
INSERT INTO hrv_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","Obrati se svećenicima, levitima i sucu koji bude za ono vrijeme. Njih pitaj, oni će ti rasuditi. ");
INSERT INTO hrv_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","I učini onako kako ti budu kazali u mjestu koje Jahve odabere. Pazi: sve učini kako te upute. ");
INSERT INTO hrv_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Uradi prema uputi koju ti dadnu i prema presudi koju donesu. Od presude koju ti kažu ne odstupaj ni desno ni lijevo. ");
INSERT INTO hrv_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Ako bi se tko drsko odupro i ne bi poslušao ni svećenika koji ondje stoji da služi Jahvi, Bogu tvome, ni suca, neka se taj čovjek pogubi. Tako ćeš iskorijeniti zlo iz Izraela, ");
INSERT INTO hrv_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","a sav će se narod, kad sazna, bojati i više se neće drsko odupirati. ");
INSERT INTO hrv_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Kad stigneš u zemlju koju ti Jahve, Bog tvoj, daje; kad je zaposjedneš i u njoj se nastaniš, pa onda kažeš: 'Želim da nad sobom postavim kralja, kako ga imaju svi drugi narodi oko mene' - ");
INSERT INTO hrv_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","tada ćeš onoga koga Jahve, Bog tvoj, odabere, sebi postaviti za kralja. Nekoga od svoje braće postavi sebi za kralja, a ne smiješ postavljati nad sobom tuđina koji ti nije brat. ");
INSERT INTO hrv_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Samo neka ne drži mnogo konja i ne šalje naroda u Egipat da poveća broj konja. Jer vam je Jahve rekao: 'Ovim se putem nikada više ne vraćajte!' ");
INSERT INTO hrv_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","I neka nema mnogo žena da mu srce ne pođe stranputicom; i neka sebi ne gomila srebra ni zlata! ");
INSERT INTO hrv_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","A kad sjedne na kraljevsko prijestolje, neka sebi na svitak prepiše ovaj Zakon od svećenika Levijevaca. ");
INSERT INTO hrv_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Neka ga drži uza se; neka ga čita sve vrijeme svoga života da nauči bojati se Jahve, Boga svoga, držati sve riječi ovoga Zakona i vršiti ove odredbe; ");
INSERT INTO hrv_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","da se svojim srcem ne uzdigne iznad svoje braće i da ne skrene od ove zapovijedi ni desno ni lijevo, kako bi dugo kraljevao, on i sinovi njegovi, u Izraelu. ");
INSERT INTO hrv_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","Svećenici Levijevci - sve pleme Levijevo - neka nemaju udjela ni baštine s Izraelom; neka žive od žrtava paljenih Jahvi i od njegove baštine. ");
INSERT INTO hrv_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Neka, dakle, nemaju baštine među svojom braćom: Jahve je njihova baština, kako im je i rekao. ");
INSERT INTO hrv_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","Ovo neka bude svećenička pristojba od naroda - od onih koji žrtve prinose, bilo to goveče ili što od sitne stoke: svećeniku treba dati pleće, vilice i želudac. ");
INSERT INTO hrv_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Davaj mu i prvine od svoga žita, od svoga vina, od svoga ulja i prvine od vune svojih ovaca, ");
INSERT INTO hrv_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","jer je njega odabrao Jahve, Bog tvoj, od svih tvojih plemena; njega i njegove sinove, da zauvijek stoje pred Jahvom, Bogom tvojim, te da obavljaju službu i blagoslivljaju u ime Jahve. ");
INSERT INTO hrv_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","Ako bi koji levit što boravi u nekom tvome gradu, bilo gdje u Izraelu, svom dušom zaželio da dođe u mjesto što ga Jahve odabere, ");
INSERT INTO hrv_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","može tu službovati u ime Jahve, Boga svoga, kao i druga njegova braća Levijevci koji stoje ondje pred Jahvom. ");
INSERT INTO hrv_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","Neka jede jednak dio kao i drugi, bez obzira na prodanu očevinu. ");
INSERT INTO hrv_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Kad uđeš u zemlju koju ti daje Jahve, Bog tvoj, nemoj se priučavati na odvratne čine onih naroda. ");
INSERT INTO hrv_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Neka se kod tebe ne nađe nitko tko bi kroz oganj gonio svoga sina ili svoju kćer; tko bi se bavio gatanjem, čaranjem, vračanjem i čarobnjaštvom; ");
INSERT INTO hrv_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","nitko tko bi bajao, zazivao duhove i duše predaka ili se obraćao na pokojnike. ");
INSERT INTO hrv_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Jer tko god takvo što čini gadi se Jahvi; zbog takvih odvratnosti njih i goni ispred tebe Jahve, Bog tvoj. ");
INSERT INTO hrv_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Budi posve vjeran Jahvi, Bogu svome. ");
INSERT INTO hrv_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Narodi koje ćeš naskoro otjerati s posjeda slušaju vračare i gatare, ali tebi to Jahve, Bog tvoj, ne dopušta. ");
INSERT INTO hrv_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Proroka kao što sam ja, iz tvoje sredine, od tvoje braće, podignut će ti Jahve, Bog tvoj: njega slušajte! ");
INSERT INTO hrv_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Posve onako kako si i tražio od Jahve, Boga svoga, na Horebu, na dan zbora, kada si govorio: 'Neću više da slušam glas Jahve, Boga svoga, niti želim više gledati taj silni oganj da ne poginem!' ");
INSERT INTO hrv_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Nato mi reče Jahve: 'Pravo su rekli. ");
INSERT INTO hrv_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Podignut ću im proroka između njihove braće, kao što si ti. Stavit ću svoje riječi u njegova usta da im kaže sve što mu zapovjedim. ");
INSERT INTO hrv_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","A ne bude li tko poslušao mojih riječi što ih prorok bude govorio u moje ime, taj će odgovarati preda mnom. ");
INSERT INTO hrv_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","A prorok koji bi se usuđivao govoriti što u moje ime što ja ne budem zapovjedio da govori i koji bi govorio u ime drugih bogova, takav prorok neka se pogubi.' ");
INSERT INTO hrv_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Možda ćeš reći u svome srcu: 'Kako ćemo raspoznati riječ koju Jahve nije izrekao?' ");
INSERT INTO hrv_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Kad prorok govori u ime Jahve pa to ne bude i riječ se ne ispuni, onda je to riječ koje Jahve nije kazao. U drskosti je taj prorok govorio. Nemoj od njega strahovati. ");
INSERT INTO hrv_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","Kad Jahve, Bog tvoj, istrijebi narode čiju zemlju tebi daje te kad ih istjeraš i nastaniš se u njihovim gradovima i domovima, ");
INSERT INTO hrv_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","u zemlji koju ti Jahve, Bog tvoj, daje u baštinu, odvoji tri grada. ");
INSERT INTO hrv_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","Načini put onamo, a onda područje zemlje koju ti Jahve, Bog tvoj, daje u baštinu podijeli natroje, tako da svaki ubojica može onamo uteći. ");
INSERT INTO hrv_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","Ovo je slučaj u kojemu ubojica može onamo pobjeći i spasiti svoj život: kad tko ubije svoga bližnjega nehotice, a da ga prije nije mrzio; ");
INSERT INTO hrv_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","primjerice, kad ode sa svojim bližnjim u šumu da siječe drva, zamahne sjekirom u ruci da obori drvo, gvožđe odleti s držalice i pogodi njegova druga te on pogine: takav ubojica neka uteče u jedan od tih gradova i spasit će život. ");
INSERT INTO hrv_vpl VALUES ("DT19_6","006_19_6"