﻿USE sofia;
DROP TABLE IF EXISTS sofia.hru_vpl;
CREATE TABLE hru_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hru_vpl WRITE;
INSERT INTO hru_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ñimko a ha ha lyilyedama, se ná nüna añe na galyiw ĝipüñejoñe dada. ");
INSERT INTO hru_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sünda he ñu ná dju nudzoĝ iñiyo hohusedama se naje, seyo, Tawgyew i shi-ñu truñe kahisedaw se naje, se ñu ná ütrüyomdo ñí trukuida. ");
INSERT INTO hru_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Sünambo, no je ütrüyomdo, he na he í, usupa yo hoksüñe kalyisedaw no, süvzüw Tiyofilus bábo, he na he í magabolyiw ĝi vyeimeje ujoñe vyeda. ");
INSERT INTO hru_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hado cheholye, bá ha trudrülyedama, se ná umsowgo ba danghuweñe no vyedame. ");
INSERT INTO hru_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nugo Herodes i Yahudiya ñetrü go ñetrü nugo dañe shüi ñeto ge ana lyikülye: Abiya müga go Jakariya cheñe mügaw a du. Üfum ye, mügaw Arõ yo samtolyiw namko yo a, iñiñi ye Elishiba. ");
INSERT INTO hru_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sünda se naksü Tawgyew uvro ge chiñifoñe, seyo Prabhu ichi shotuko dügyew ná je da shüw. Ǘĝü dadrülyedaw ná je madatruw-makitruw da shüw. ");
INSERT INTO hru_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sünda Elishiba i ügübzümdá naksü agü je ñiwbi. Sünda se naksü kewje keahubi. ");
INSERT INTO hru_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dzakariyas i í ñeŝü ná daĝañ kuwñe, Tawgyew uvro ge, i ñegru ge müga chew daw. ");
INSERT INTO hru_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sündada mügaw ná daw basha yo dañe kako dzulaw ge iñiñi kakülye, Tawgyew í küĝüw ñegru ge jiñe shobrovzü foweñe. ");
INSERT INTO hru_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sündada shobrovzü fomkoi sese vyew na nopsü ge kahuañe küĝütsü. ");
INSERT INTO hru_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sese Tawgyew ichi sorgomuko a ye shobrovzü fodaw südzüvyepsüĝ vyego psüĝañe ge gudzukülyedaw ye, í hohu. ");
INSERT INTO hru_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sünda Jakariya í hoglye ŝüpo lamosha, sünda í ĝew vyehua. ");
INSERT INTO hru_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Seŝo ye sorgomuko i í che, “Jakariya, djuĝejodawe hado chemeje bá küĝüdaw ye dzühujemme sündada bafum Elishiba yo babó saw a sakülyejome, sünda ba se iñiñi ye Yohañ ñe ñijodawe. ");
INSERT INTO hru_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sünda ba agü saahuñe ŝüpyo lüshüñe, lüshümfoajome seyo ŝüpyo nüna na agü sadabi cheñe lüshüjome.” ");
INSERT INTO hru_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hado chemeje i Tawgyew üvro ge sawlyiw chiñifojome; seyo tsü keje matujome; seyo iyañ ulhu ge duluge yo ĝulo güdraw yo güdraavojobi. ");
INSERT INTO hru_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Seyo Israyel yo naje ŝüpo nüna na Tawgyew ichi ge kakultrujome. ");
INSERT INTO hru_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","I ñihow Eliya í ĝulo seyo küña dafidama dañe üvro üvro kutrojome hado chemeje awu na na üdrü-ulu ye agü nachi ge tchodügyejo; seyo zew chew madzüw na Tawgyewchi ge chiñidrüñe lakujo sünda Tawgyew ibó dafimsofiw dashütrüvojo. ");
INSERT INTO hru_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakariya i sorgomuko í dzü, hei no künda danghujowa; hado chemeje nobó mukroadabi seyo nofum boje mukromyadabi. ");
INSERT INTO hru_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sorgomuko i í trutcho, “No Gebriyalwa, Tawgyew ichi mukow kewwa sünda üdra gudzusaw ye wa; sündada nó badra chitruweñe seyo bá he ñu ye truweñe kiadaw yewa. ");
INSERT INTO hru_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Seyo hojo dawe, he ñu ye umsow makalu kuw ba mulyo ĝyojome, sünda mazefijomme, hado chemeje ba nó ñu ye, i ke damdrüñe dafiajoma, sei umsow mavye.” ");
INSERT INTO hru_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nüna na Jakariya í ĝyokrütsü, sünda mavyenghuahuw lyatsü, hado cheme ñegru ge aña künda uwalajemañe? Vyeñe. ");
INSERT INTO hru_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sünda i ñopsü kahuadabi abó ñu mazefibi, sündawñe na danghuladabi i ñegru ulunge hama ñita homadadañe, sünda i sei vyeĝelalye seyo mulyo lyadabiñe. ");
INSERT INTO hru_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sünda i sehu datunofiahuñe i í ñe ge katcho. ");
INSERT INTO hru_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Setasaĝa yo ifum Elishiba somafobi, sünda hubye pom kuw i nudzoĝ ana cheñe müŝüñe vye. ");
INSERT INTO hru_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nüna nafo ge nó bümazeamedañe nobó Tawgyew i he ñeto ye ana daidawa.” ");
INSERT INTO hru_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elishiba agü ñiw yo hubye ĝe kuw sa a Tawgyewchi go sorgomuko Gebriyal i Galili iñiñi Nazrat ñetrü ge, ");
INSERT INTO hru_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mimsa nano makaw a ichi ge kiku. Djú Joseb cheñe Dawud í ñeŝü go Muhusa a idra ĝulo daida, se nano makaw mimsa iñiñi ye Mariyamwa ");
INSERT INTO hru_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Sünda Sorgomuko i ichi ge ñelunge jimyoñe che, ba hu je adjüdjüw no je aĝimiw lüshütukoaiwe, Djú Tawgyew í nülvow tukoaidama! Tawgyew i badraŝome. ");
INSERT INTO hru_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","I se ñu yo ŝüpyo ĝelamoag, sünda vyemche, hei küna ñu a djüjemma? ");
INSERT INTO hru_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Séŝo Sorgomuko i í che, Mariyamya; djuĝejoda, hado cheme Tawgyew í nülvo bá tukoaidawa. ");
INSERT INTO hru_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sünda hojodawe, ba somafojome, sünda ba saw a sakülyejome, ba iñiñi ye Jisu ñe ñijodawe. ");
INSERT INTO hru_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I ŝüĝlyiĝjome; seyo bá Soĝgro-yaloñe üsaw chejome; sünda Tawgyew i í awu Dawud i psüĝa ye í djüjome. ");
INSERT INTO hru_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sünda i Yakub í ñeŝü ge shüwa nugo da shükejome; sünda í ĝadzü da shükyew ye keje mamütrajome. ");
INSERT INTO hru_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyam i Sorgomuko í che, “Hei künda lyijowa? Nobó muhuje madanghulubi.” ");
INSERT INTO hru_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sorgomuko i í trutcho “ĝulo güdraw ye baso ge kamyojome, seyo Toĝgroyama í Ĝagra ye badru ge duñgudrujome; Hado chemeje í ĝulo güdraw yo sakülyalaibi, Í Tawgyew üsaw chejome. ");
INSERT INTO hru_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sünda hojo dawe, bá ñeŝüĝ go Elishiba i je mukromyadabi a saw sakülyemkoiba, hei ichimsoba í na Ügübzüm chebabi, i so mafow hubye ĝe kudaba. ");
INSERT INTO hru_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hado chemeje Tawgyew ichi ge ha ñu je madafiwjo che ñiwme.” ");
INSERT INTO hru_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariyam i che, “Howe, no Tawgyew i chiĝadambabi, bachi ñu trudo trüduyo dubroñe nodra ana lyimeje.” Sese sorgomuko ye itrü yo katrükralye. ");
INSERT INTO hru_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sündaw se ñeto Mariyam i kutcho yo gudzuñe pufo go Yahudi na ñetrü a ge ji. ");
INSERT INTO hru_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sünda Jakariya iñe ge jiñe Elishiba í gagañe da. ");
INSERT INTO hru_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elishiba i Mariyam ichi gaga chewye dzühuhuwñe, seŝügudoye ulhu go agü yeje gog, sünda Ilishiba i ĝulo güdraw yo tukoa. ");
INSERT INTO hru_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sünda i gow yo ŝogzuñe che, ba mim naĝi yo süvzüfowmme, seyo balhu go sheje ye ŝüvzüw me. ");
INSERT INTO hru_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sünda noje hango yo nülvojema, no Tawgyew üyañ ye notrüĝañ a jikuda. ");
INSERT INTO hru_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sünda holabya bachi gaga chew ye nofu ge dzühubyo dzühuĝyowñe seŝügudo ye nolhu go agü yeje lüshülye gogje. ");
INSERT INTO hru_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sündada seiye ŝüvzüwmme, se í djuyo umsow vyeñe Tawgyew ichi go, ha ñu ye idra chedama, sei damsojebi. ");
INSERT INTO hru_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sese Mariyam i che, “Nodrü-nolu yo Tawgyew i troime. ");
INSERT INTO hru_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Sünda noĝulo ye, nó gudraw choakejo Tawgyew yo lüshü damme. ");
INSERT INTO hru_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Hado chemeje i í chiĝadam idru ge nülvo hoida, sündada holabya, ayo dalalye shüwa shüw pumnüshüĝi kuw nüna na nó ŝüvzübram chejome. ");
INSERT INTO hru_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Hado chemeje se bolugobraw Tawgyew i nobo chiĝa dew dew daida, sündada iñiñ ye güdraw me. ");
INSERT INTO hru_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Sünda i nülvo ye se nadra jome, dju í ĝeima, saltso saltsow daw kuw sünañgudrujome. ");
INSERT INTO hru_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","I í bolugow ye sheiwa, seyo dju nudzo drü-lu ge dafowŝoñe daima sena daame-kiame vye. ");
INSERT INTO hru_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I shotuko dümbraw na psüĝa go dügaaha; Sünda nülvodaw i udruda vye. ");
INSERT INTO hru_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Luhuŝümgraado na gañ uwyo da djü, séso dzomo-külyimodaw na ügzü ufobüla lyadügye. ");
INSERT INTO hru_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","I í nüdzoĝ aki-awu na, kulo Israyel na ĝaksüla, hado chemeje se nülvo ye büvyesüdañe. ");
INSERT INTO hru_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Shüwa Abraham ñe i saltsoahuw nadra shüwa duñgudrujo, I küna ñi bupye-ñipye nadra chedama süna.” ");
INSERT INTO hru_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyam i hubye dzü kuw idra ĝyoselyeñe, i ñe ge katcho. ");
INSERT INTO hru_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sese Elishiba i samdrü kudabi, sünda i saw sakülye. ");
INSERT INTO hru_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I ĝafopsüĝ-ĝampsüĝ seyo i ñeŝüĝ-ñepeĝ na sei dzühulye, Tawgyew i ídru ge ŝüpyo nülvo dadañe, idra ye lüshütuno. ");
INSERT INTO hru_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sündalye ana a dadawa ñegi ŝügzü kuwñe se agü í fyuw ñeto kudabi sünda i ñiñi ye ichi awu Jakariya í iñiñ ye ñiweñeda. ");
INSERT INTO hru_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Séŝo iyañ i che, mowwe; i ñiñi ye Yohañ ñe ñijo dawe. ");
INSERT INTO hru_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Sünda na í che, bá ñeŝüĝ ge ana üñiñi djuchije ñiwa. ");
INSERT INTO hru_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sese i ichi awu i damcheñe dzü, ba iñiñi í ha ñiĝoñda? ");
INSERT INTO hru_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sündawñe i ĝijo kako prülañe ĝiag, iñiñi ye Yohañ me, sündawñe vyew na mavyenghuatsüg. ");
INSERT INTO hru_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sündawñe ichi umdzu ñe zebüla naksü seŝügudo ye zefikülye; Sünda i ñu zehuahuw ye Tawgyew i trokülye. ");
INSERT INTO hru_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sündawñe iñisa ye ĝyodo na vyew ĝemoatsü; sünda se ñu ye vyew se Yahudiya nachi ñetrü üñisa üñisa naje ŝüĝeatsü. ");
INSERT INTO hru_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sünda vyew dzühudo na nudzoĝ nudzoĝ drü-lu ge vyelatsü che, “He agü ye künajojeŝoma?” Hado chemeje Tawgyew i ügzü ye idra dubi. ");
INSERT INTO hru_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sünda iyaw Jakariya i ĝulo güdraw yo tukoa, sünda ñihokülye. ");
INSERT INTO hru_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Israyel go Tawgyew í ŝüvzüwe. Hado chemeje i í nudzo nüna ná hokrüvo, Sünda ná ĝaksüivo, ");
INSERT INTO hru_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Seyo i kulo Dawud i ñe ge ñibo muchoaijo hosüw üŝüvzü a lahuaida. ");
INSERT INTO hru_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sünambo i bzüga yomdo güdraw ñihow truw bupye-ñipye nayo, dju ñedzü üña no üña gomdo dulyisema, senayo trulyeida. ");
INSERT INTO hru_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Chemeje ñi vyeñiw-vyeĝaw nayo, seyo ñi homsüsew nagzü yo ñi muchoaida; ");
INSERT INTO hru_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sei ye ñi bupye-ñipye na nülvo dañe nudzoĝ güdraw ñu i vyesüweñe, ");
INSERT INTO hru_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Seyo se trasĝa sei, se í i ñi awu Abraham yo todoye, ");
INSERT INTO hru_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","I ñi hei djüjo, sei ye ñí vyeñido nayo kahajoñe, ");
INSERT INTO hru_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ivro ge chiñiw seyo güdraw ĝabo kaw ge shüdzowkuw maĝew ichi chiĝa dañgudruweñe. ");
INSERT INTO hru_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Seyo ba ye muhusa agüsa, Toĝgroyama i ñihobraw chejome, hado cheme ba Tawgyew ichi ĝabo dashütrüvojoñe uvro uvro kutrojome, ");
INSERT INTO hru_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Sei ichi nüna na djumuchoawe, dju, ná lalo yo güdraw pawma. ");
INSERT INTO hru_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Hei ñi Tawgyew í nülvo dado yo lyijome, seiyo ñidru ge udrugo yo müsaw a dzüto-rünokülyejo. ");
INSERT INTO hru_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Sei ye nukuĝuw seyo dzüjo ĝabo ge ĝyodo na müsaw djü, seyo ñishi í lüshüw ĝabo gudow lakutrokewe. ");
INSERT INTO hru_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Seyo se muhusa angasa ye Yohañ, shülyifi shülyi seyo ĝulo ge gokülyefi gokülye seyo Israyel ge kakujo ñeto kuw i bye ge ĝyo. ");
INSERT INTO hru_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Se ñeto ge ñubyu Kesar Agastas ichivye gow shotuko-kunu kihua, vyow Druguw-Drulyiw gow ĝadzü-ĝaĝi nañiñ ĝimyoweñe. ");
INSERT INTO hru_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","He uvromashü iñiñ ĝimyow ye ñubyu Keriniyas í Siriya gow dümbraw dadaw ñetow ge daw. ");
INSERT INTO hru_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Vyew na nañiñ í ĝimyojoñe nudzo-nudzo ñetrü ge katsüküĝatsü. ");
INSERT INTO hru_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sünda: Joseb je Dawud i ñeŝü go üŝü umu, sündada i Galili go Nazrat ñetrü yo kañe Yahudiya ge Dawud i ñetrü Betlehem ge ka. ");
INSERT INTO hru_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I iñiñ ĝimyow, í goidaw Mariyam dju so mafoma idra jisa. ");
INSERT INTO hru_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na Betlehem ñetrü ge dulu ge, i agü sajo ümdrü kuadabi. ");
INSERT INTO hru_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Sünda i agü üsaw samkyo a saa sündañe í gyeka ge ĝüshüñe káko ge zua ve, hado chemeje nabo süge ñe ĝyojo mapa. ");
INSERT INTO hru_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Seyo se ñetrü a küña fugulu ĝyokrüw duma, se na ñegi ge vi ge ĝyoñe ná hokrü ĝow. ");
INSERT INTO hru_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Seyo Tawgyew i sorgomukow a namgkow ge gudzukülye, sünda Tawgyew i ĝagra namgkow ye dubrokülyeg, sündawñe na ŝupo ĝeatsüg. ");
INSERT INTO hru_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sündawñe sorgomukow i na che, “Dju ĝejo dawe; Hado cheholye chemeje, howe, no tuĝu-tumo vyow nabo ŝüpo lüshüw ñu a trujome. ");
INSERT INTO hru_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yow ñubyu Dawud i ñetrü ge djobo muchoaijo a sadame, sünda se i Prabhu Masime.” ");
INSERT INTO hru_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sünda se ye ba chi shewme, sei ye ba agü a ye gye ĝüshüñe seyo káko ge zuw hohujome. ");
INSERT INTO hru_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sündawñe sorgomuko a üdra ye soĝgomuko upua a Tawgyew i iñiñ la troñe ana chew hohuda, ");
INSERT INTO hru_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ñedzü ge Tawgyew í ĝüdzüw sünda no ge se tuĝu-tumo na ĝüdzüw djüwe djú ñedzü Tawgyew i uw veima.” ");
INSERT INTO hru_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sorgomuko i natrü go soĝgo ge katralyewñe, fugulu ĝaksüw na ĝütchü cheĝi, “Tchow, ñi Betlehem jiñe he ñu chedaw i, seyo Tawgyew i trudaw í, hobo.” ");
INSERT INTO hru_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sünda na mekutcho djeñe Mariyam ñe seyo Joseb naksü ütrü ge anga i káko ge vedaw hohu. ");
INSERT INTO hru_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","I holyeñe na se anga ufo gow na ha trudama se ñu chedaw na truzeĝiatsü. ");
INSERT INTO hru_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Seyo vyew dzühutsüdaw na fugulu ĝaksüvow na ñu trudaw yo mavenghuatsüg. ");
INSERT INTO hru_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Seŝo Mariyam i he ñu na üdrü-ulu ge veñe vemchepüñe. ");
INSERT INTO hru_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sünda fugulu ĝaksüw na ná küna trudama, sünambo vyew dzühuñe hohuñe Tawgyew i trolyeñe lüshüñe katsütcho. ");
INSERT INTO hru_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ñegi ŝügzü kufiahuñe, seyo i Jisu i mükraksüw fyumdrü kuadabi, sünda iñiñ Jisu ñe ñi, he iñiñ ye sorgomuko i uluhudrü ge mañilugomdo djülyedabi. ");
INSERT INTO hru_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sünda Musa í shotuko dalyedaw yo Mariyam i güdraw ĝyow ye ĝomdzoahuwñe sünda Joseb ñe Mariyam naksü í Tawgyew uvro ge shew Yarusalem lañe jike. ");
INSERT INTO hru_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tawgyew i shotuko ge ĝimbo: “Vyew saw samkyo na Tawgyew ibó güdraw vyejome.” ");
INSERT INTO hru_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Sünda Tawgyew i shotuko dalyedaw go chemeje, “Aŝüm osa ksü, momeje paĝusa üsasa ksü lañe küĝüwe.” ");
INSERT INTO hru_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Se ñeto ge Yarusalem ge Simon iñiñ yo nüna a duw, sünda i güdraw nüna seyo Tawgyew i küĝüw nüna, sünda Israyel ge ĝüdzüjo i ĝyokrü, seyo ĝulo güdraw üdra dusa. ");
INSERT INTO hru_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sünda ĝulo güdraw yo truhua, ba Tawgyew i saw Masi í mahohulu, ba madzüvzüjome. ");
INSERT INTO hru_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sünda í Ĝulo Güdraw i ñegru nopsü ge jidügye; sünda iyaw ñe üyañ naksü se agüsa Jisu íbo, ahugo shotuko na dajoñe veñe lajikedaw sesse, ");
INSERT INTO hru_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","sünda Simon i angasa í lolalyeñe, Tawgyew í troñe ana che: ");
INSERT INTO hru_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“He Tawgyewwa, ba ñu chew kudabi, bá kulo í ba ĝüdzüw yo kadügyejodabe; ");
INSERT INTO hru_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Hado chemeje noñi yo ba muchoadügyedaw ye hohudamme. ");
INSERT INTO hru_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Djú ba vyew druguw-drulyiw gow nüna na hovow sa a dadrü kikülyadama. ");
INSERT INTO hru_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I utro sama nabo umsow truhoahuw müsaw da kakülyajome, sünda Israyel go djo nüna nabo lüshü-lübajome.” ");
INSERT INTO hru_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sünda üyaw ñe üyañ naksü ubo gow ñu chedaw yo mavenghuatcheseñgudru. ");
INSERT INTO hru_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sündawñe Simon i í gaĝüzü djüñe, üyañ Mariyam í che, “Howe, i Israyel go na gaañe seyo pülyidügyejo go, seyo ana a chi shedügyejoñe ĝyokrüdügyeda, seifo go ñu zeĝijome. ");
INSERT INTO hru_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sünda ba ĝülo je vetsü yo vudüga-vudüga dajome. He yo ŝüpo na drü-lu ge vedaw na truhuajome.” ");
INSERT INTO hru_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Sünda Asher ĝübye go Fanual üsam a duw iñiñ Hanna, i ñihow trum: I ŝüpo mukrombi, I ülshi dzüwñe üdra gzü daw yo odje mro kuw shüfisawba. ");
INSERT INTO hru_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","I odje ŝügzüĝütrü psüĝi gow müjem: sünda ñegru keje matrahuw ñegiw-ñetow drüpsü-ñilyi mañiw seyo küĝüñe ĝyonggudruwba. ");
INSERT INTO hru_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sünda i sehu ñeto süge jikuñe Tawgyew i drü-lu yo uw che, sünda vyew ná, dju Yarusalem i yo muchoajoñe ĝyokrüvodaw na, ifo go ñu trumyokülye. ");
INSERT INTO hru_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sünda na Tawgyew davyedaw shotuko üĝü ye vyew damdzoahuwñe sese Galili ge nudzoĝ ñetrü Nazrat ge katcho. ");
INSERT INTO hru_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Sünda angasa ye nugow lya, sünda bolu dukülyebi, seyo patsü-sholu tukoaha, sünda Tawgyew i nülvo üdra sa dusa. ");
INSERT INTO hru_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Üyaw ñe üyañ naksü oje drü-drü Yarusalem ge Fasa rhano ge jinggudru. ");
INSERT INTO hru_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","I oje ĝüyo ksü kuwñe, na rhano ge ĝidaw ñom í daw Jerusalem ge ji. ");
INSERT INTO hru_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sünda na vyew ñegi ĝyomdzolye sese katcho, se angasa Jisu Yarusalem ge ĝyotralye; sei üyow ñe üyañ naksü madanghu. ");
INSERT INTO hru_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Na ana veñ, i upu jiw nadra dusamada, ñegi a kapseajebi: sünda na í nadraw seyo na ñeŝü nangko ge tchüpüñe. ");
INSERT INTO hru_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sé matchülawñe na tchü-tchüñe Yarusalem ge katcho. ");
INSERT INTO hru_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Seyo ñegi dzü sefum ye na í ñegru nopsü ge dadrüw nangko ge ĝyosañe, ná ñu dzüñe seyo naje i chi dzü ĝyodaw hohu. ");
INSERT INTO hru_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Seyo küña na i ñu truw dzü ĝyodama, se na vyew í danghuw yo seyo i ñu hutrow yo mavenghuatsü. ");
INSERT INTO hru_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sündawñe na í holyeñe mavenghualyeñe seyo üyañ i í che, “No sawwa, ba ñidra ana hado daña? Howe, baw ñiksü ba taĝaw na veduw tchü ñegiaha.” ");
INSERT INTO hru_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","I í che, “Ba no hado tchüña? Hadoma madanghuma, no nó awu i ñe ge dujobabi cheñe?” ");
INSERT INTO hru_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Seŝo i í ha ñu chedama, i se i madzüsüla. ");
INSERT INTO hru_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sündawñe i üdra kasa, sünda Nazrat ge kaku, sünda na chew dzü ĝyosa; sünda üyañ i he ñu ye üdrü-ulu ge ve. ");
INSERT INTO hru_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Seyo Jisu i patsü-sholu seyo udru ge lyifilyi sünda Tawgyew ñe nüna naksü ubo yo go shülyi. ");
INSERT INTO hru_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nugo Tibiriyus Kesar ñetrü nugo dañe oje ĝütrüpom kuw sese, seyo Pontus Pilatus i Yahudiya go ñetrü nugo da shüi sese, seyo Galili ge Herodes, sünda üñu Filip Ituriya seyo Trakonitis go nugo da shüw sese, sündalye Abilene ge ye Lisaniyas go nugo da shüw sese. ");
INSERT INTO hru_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Seyo sese Anasñe Kefas naksü müga gow, seta-seĝa Tawgyew ichi shi-ñu ye, ge bye ge Jakariya ichi üsaw Yohañ ütrü ge dzühuku. ");
INSERT INTO hru_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Sündalye i Yordan hu itrüĝañ go vyew ñetrü-ñetrü ge jiñe, lalo muchojoñe drü-lu ye vyegudoweñe baptisma ifo ye truzekülye. ");
INSERT INTO hru_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yasaya i ñihow trulyedaw shi-ñu kako ge ĝidaw ye: “Bye ge shogzükülyedaw nüna i ĝuksüwme he i: ‘Tawgyew i ĝabo dashütrüvowe, i ĝabo í gudow davowe. ");
INSERT INTO hru_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kaguĝuahuw küñama kazeĝiyijome, Seyo púsa je lüñew daajo; Seyo üküngüw ná gudojo, lüvzüw lüñew ĝabo Sena ĝabo rhugro lyijome. ");
INSERT INTO hru_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Seyo uso duw chebiw ye vyew Tawgyew i muchoaihuw hohujome.’” ");
INSERT INTO hru_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dju upu dyam na ichi ge baptisma lajoñe jihuañe jikutsüdaw na, se na i che, “He byu üsa nawa, djó dju truda, he kalai lusuvyuw yo ĝe jehuatsüwe che? ");
INSERT INTO hru_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Drü-lu vyegudofilaw kuw sheje lakuwe: seyo nudzoĝ-nudzoĝ drü-lu ge ana djuvyelajo dawe, se ñi aki-awu ye Abrahameñe; hado cheme no dju chengkoime, Tawgyew i he kunu yo je Abraham íbo mulo lakülyefijobame. ");
INSERT INTO hru_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Seyo ya bo puĝje ye shoñ ükrütrü ge vyedabi, sündada ha shoñ ye sheje uw yo majema, se na poskealye mi ge foahuebabi.” ");
INSERT INTO hru_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Seyo nüna na í dzü, “Sename ñi ha dajowa?” ");
INSERT INTO hru_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","I ná tru, “Djuchi ge polu ksü duma, se djuchi ge ñima se i djüwe seyo djuchi ge tsajo duma, se naje süna datsüwe.” ");
INSERT INTO hru_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Seyo patso-law na je baptisma law jiku, seyo í dzü, “He dadrüwwa, ñi ha dajobya?” ");
INSERT INTO hru_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I ná trutcho, “Dju djóbo ĝyokrüima, se í fojelübzüw patso djulajo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Seyo rhünakew na je í ana dzü, “Ñi ha dajobya?” I ná chetcho, “Djudru ge je külü djujowe, seyo mülaw-mütraw djufojo dawe, seyo nudzoĝ chiĝa dadaw ge lüshüjo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sünda nüna na se í vyeksüñe ĝyomkoi sese, seyo vyew na nadrü-nalu ge Yohañ ifo go vyemkoi, haña he ashá he i Masi moŝomachañe. ");
INSERT INTO hru_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Sündawñe Yohañ i vyew ná che, “Nobó djo hu yo baptisma djüwbame, séŝoye i kalaime, dju nó cheje saw-lyiw bolufowme; no ivro ge ichi shita udro tashaijoje ugõ ñiw sünabame, se i djó ĝulo güdraw seyo mi yo baptisma djüjome. ");
INSERT INTO hru_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ichi chiaĝi ye ichi ügzü a me; seyo i í ñetchü ye uw yo dagüdrajosome; seyo pulgü tcholadaw na üŝaka lakeĝijome, séŝo üĝütchü na ye mi ge foajo se mi ye keje madzoñoajo.” ");
INSERT INTO hru_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sündalye i nüna na dadrüñ-dadrülye shi-ñu uw je trusejome. ");
INSERT INTO hru_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Seŝoye i psüĝimko yo ñetrü a go nugo Herodes í iñuw Filipus ufum Hirodiyas ifo go, vyew lalo datruw nafo se na sei í dadaw na fokülye. ");
INSERT INTO hru_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Sündada Hirodes i vyew naĝi yo je i fow lalo je datru, Yohañ í pache ñe ge shü vyewe che. ");
INSERT INTO hru_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Vyew na baptisma latsüwñe, seyo Jisu je baptisma lalyeñe küĝü ĝyo, sündawñe ñedzü müsaag. ");
INSERT INTO hru_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Seyo ĝulo güdraw paĝusa veduw ye uso dañe idru ge ĝudrokülya, sünda ñedzüdru go ñu zekülye “Ba nó sawme, ba yo no ŝüpo lüshüdame.” ");
INSERT INTO hru_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisu i shi-ñu trukülyewñe, sese i oje dzüĝü kuw. I Joseb üsaw (nüna na ana vedabi), seyo i Eli ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Seyo i Mattat üsaw, seyo i Lewi ichi, seyo i Malki ichi, seyo i Jannai ichi, seyo i Yusuf ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Seyo i Mantiyah ichi, seyo i Amos ichi, seyo i Nahum ichi, seyo i Asaliya ichi, seyo Naggai ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Seyo i Mat ichi, seyo i Matiyah ichi, seyo i Simi ichi, seyo i Yosek ichi, Seyo i Yoda ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Seyo i Yohañ ichi, seyo Resa ichi, seyo i Jarubbabel ichi, seyo i Shaltiyel ichi seyo Nari ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Seyo i Malki ichi, seyo Adi íchi, seyo i Kosam ichi, seyo i Almadam ichi, seyo i Er ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Seyo i Jisu ichi, seyo i Aliyejer ichi, seyo i Yorim ichi, seyo i Mantat ichi, seyo i Lewi ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Seyo i Simon ichi, seyo i Yahuda ichi, Seyo i Yusuf ichi, seyo i Yonan ichi, seyo i Eliyakim ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Seyo i Maleyah ichi, seyo i Minnah ichi, seyo i Mantat ichi, seyo i Natan ichi, seyo i Dawud ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Seyo i Yise ichi, seyo i Obed ichi, seyo i Boj ichi, seyo i Salmon ichi, seyo i Nason ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Seyo i Amminadab üsaw, seyo i Arni üsaw, seyo i Henson üsaw, seyo i Peres üsaw, seyo i Yahuda üsaw, ");
INSERT INTO hru_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Seyo i Yakub ichi, seyo i Isahak ichi, seyo i Abraham ichi, seyo i Terah ichi, seyo i Nahor ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seyo i Sarug ichi, seyo i Rawu ichi, seyo i Peleg ichi, seyo i Eber ichhi, seyo i Shilah ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Seyo i Kenan ichi, seyo i Arafzed ichi, seyo i Shom ichi, seyo Nuha ichi, seyo Lemek ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Seyo i Matushilah ichi, seyo i Hanok ichi, seyo i Yirid ichi, seyo i Mahallel ichi, seyo i Kenan ichi, ");
INSERT INTO hru_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Seyo i Enosh ichi, seyo i Shet ichi, seyo i Adam ichi, seyo Tawgyew ichi üsawwa. ");
INSERT INTO hru_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sünda Jisu i ĝulo güdraw yo tukoañe, Yordan hu go kakutcho; seyo ĝülo yo bye ge laĝüshi laĝüshi vye; ");
INSERT INTO hru_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Seyo ñegi piĝü kuw mütü na dakütso-kikütso ho. Se ñeto ge i haje-haje matsa-matuw seyo se ñeto kamdzohuñe, sese i luhuŝüku. ");
INSERT INTO hru_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sündañe mütü ye í che, “Sünameje ba Tawgyew üsawŝommeje, he kunu ye cheha odje lyaweñe.” ");
INSERT INTO hru_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisu i í trutcho “Ĝidame, nüna na odje yo aka mashüjome.” ");
INSERT INTO hru_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sündatchowñe mütü ye í la djeketcho sündalye lüĝañe pu udru gow vyew druguw-drulyiw go ñetrü ná shemdzoa. ");
INSERT INTO hru_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sündalye mütü chetcho, “No he na he i vyew bá übraw daweñe djüjome, sünda no ĝagra djüjome, hado cheholye he na braw nobabi, seyo no dju djüĝoñdama djüfijobame. ");
INSERT INTO hru_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sündada ba nó küĝümeje, he na vyew bachi lyajo.” ");
INSERT INTO hru_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisu i í chetcho, “Ana ĝidame: ‘Ba bá nudzoĝ Tawgyew í gaga dawe; seyo í küĝüjo dabawe.’” ");
INSERT INTO hru_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sündatchowñe i í lalye Yarusalem go küĝüw ñegru ñelütsü udru ge lalyi vye, sündalye í che, “Süname ba Tawgyew üsaŝommeje, babraw bá nudzoĝ he ayo üla ge gaawe. ");
INSERT INTO hru_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Hado cheme ĝidabi, ‘I bábo í sorgomuko ná babo ĝaksüweñe dügyejome’ ");
INSERT INTO hru_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Seyo ‘I bábo ügzü yo lolajobame, hado chemeje bá gaañe kunu ge bashi í mapadügyejoñe.’” ");
INSERT INTO hru_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisu i í chetcho, “Ana je chedame; ‘Ba nudzoĝ Tawgyew í dafimsoima djuhojo dawe.’” ");
INSERT INTO hru_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mütü ye í dafiyima madafima da hopüñemdzoahuñe, sündawñe memja kuw ütrü yo kahatrükralye. ");
INSERT INTO hru_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sündatchowñe Jisu i Ĝulo Güdraw yo tukoañe, Galili ge katcho, sünda ífo go ñu ye üñisa üñisa yo küña ñetrü duma vyew dzühuzeĝiatsü. ");
INSERT INTO hru_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Seyo i süge Tawgyew í küĝüw melye ñe ge truw ñe ge shi-ñu truñgudru, sünda vyew na í trotsüküĝatsü. ");
INSERT INTO hru_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sündalye i Nazrat ñetrü ge jiku; hayo sa a í dalañe shükyedama sese; seyo í nudzoĝ daw üĝü dajo ge ĝyogow ñeto kuwñe küĝüw ñegru ge jiñe kako ngüjoñe gudzu. ");
INSERT INTO hru_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ñihow Yasaya í ĝilyedaw kako ye í djü, sünda i kako ye tahalye, hayo sa a ĝidama se i lakülye: ");
INSERT INTO hru_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tawgyew í ĝulo güdraw nodra dume, Sündada i sapse na shi-ñu truweñe nó lakülyedame, Seyo nó ana daweñe kiadame, külyidaw ná shaaweñe, Seyo üñi ĝew ná hofidügyeweñe shi-ñu na truñe, Seyo dügrülyadaw na lahuaiweñe, ");
INSERT INTO hru_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Seyo Tawgyew ichi lüshü ĝyojo oje í shi-ñu trujo.” ");
INSERT INTO hru_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sündalye i se kako ye pyelyealye í shürhaw ügzü ge djü, sündalye ĝyoag: seyo se küĝüw ñegru yo nüna na í homdzoatsü. ");
INSERT INTO hru_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sündawñe i ná che, “Yow he ĝidaw ye djovro a damdzojemme.” ");
INSERT INTO hru_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Seyo vyew na í umsolyeñe vyeatsü, seyo ha shi-ñu ye i umdzu yo zehuahima, se na i djühulye vyengatsü; sünda ná ubo chetsü, “Haña he i Joseb üsaw mowma?” ");
INSERT INTO hru_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","I na chetcho, “Djo nó he anabo zeĝajobamme, ‘He mügawwa, nudzoĝ í uw dagyolatchowe! No hadamje ñu dzühudaw ye ba Kafarnahum ge dadaw ná age nudzoĝ ñetrü a je dawe.’” ");
INSERT INTO hru_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Seyo i je chetcho, “No djó umsow cheime, djú ñihow je yow kuw nudzoĝ ñetrü ge ügõ mapawme. ");
INSERT INTO hru_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","No bá umsow cheime, Eliya í ñeto ge oje dzü kuw ñedzü ye pyelyeatrülye, ana lyiladjew vyew druguw-drulyiw ge luhuŝümoatsü, sese Israyel ge ŝüpyo müjem kadã dutsü. ");
INSERT INTO hru_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Séŝo Eliya í se namko ye djuchi ge je maki, Sidon go Sarfat ge Jewishñim mo müjem a ichi a aka ki. ");
INSERT INTO hru_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Seyo ñihow Elisha i shüi ñeto ge Israyel to ŝüpyo ĝoĝo naw kadã, séŝo Naman ñidaw Jewish mo Siriya go nüna yé tralye vyew na so güdraw madaw kadã.” ");
INSERT INTO hru_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","He ñu ye dzühubyo-dzühuĝyowñe küña na se ñegru a duma, se na vyew lusvyumfoatsü. ");
INSERT INTO hru_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sündalye gudzulyitsüñe í na se ñetrü yo lahua, sünda ha pudru to í ñetrü ĝyodama, se pudru ulodza ge la jiku, í seyoŝü üla ge dügaajoñe. ");
INSERT INTO hru_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Séŝo i nalumko yo kahulalye katrükralye. ");
INSERT INTO hru_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sündatcholye i Galili ñetrü go Kafarnahum ge jiku, sünda ĝyogow ñeto ge nüna ná shi-ñu tru. ");
INSERT INTO hru_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Se na í shi-ñu ye dzülye mavyenghuatsü hado chemeje í ñu ye dügyebyo-dügyeĝowdra du. ");
INSERT INTO hru_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Melye ñe ulunge nüna a du, djuso ge ĝulo mauw kamyo ĝyodama. Se i ŝüpyo gow yo ŝogzukülye, ");
INSERT INTO hru_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“He Nazret go Jisua, no bá ha tsünghu? Haña ba no damtrüajoñe jikuwma? No bá danghuwŝowa ba djuma? Ba Tawgyew ichi güdraw üsaw ñe sakülyedaw yewa!” ");
INSERT INTO hru_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisu i í züñe che, “Mazüda ĝyo sünda i yo kahuag!” Sündawñe se ĝulo mauw kamyodaw ye ilungo haje ma uw madalyew kahuag. ");
INSERT INTO hru_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sei holye vyew na aañiñe vyeatsüg, seyo se na naĝütchü ge ñu truĝiñe che, “He i ye küna ñu bajeŝoma? I se ĝulo ye ñigudu yo maĝew dügyebyo-dügyeĝyoiwa, sündawñe se i je kuhuabai.” ");
INSERT INTO hru_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hangge je hangge je ímdo í kadang ifo truĝitsüabaibi. ");
INSERT INTO hru_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","I ñegru yo kahuañe simon í ñe ge ji, süge se Simon (Pirat) ichi apye ye uso shüñe nala. Sündada i íbo i küĝütcho. ");
INSERT INTO hru_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I ichi üñisa a gudzulye se usso shü nadaw í züg, züwñe sese usso shüw ye gabruag sünda uwabyo-uwaĝyowñe i süge age da í datunotcho. ");
INSERT INTO hru_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Dru guamkoi sese dju-dju sama-sama yo nomñew yo so natsüdama, se na ichi ge la jikutsü, sündawñe i ügzü ye nadru ge a a dañe vyeñe na dagyotsü. ");
INSERT INTO hru_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sündawñe ĝulo mauw na ŝogzuñe che, “Ba Tawgyew ichi üsawwa,” ŝüpyo nachi go kuhuatsü, séŝo i se na züñe seyo ñu mazüdügye, hado chemeje na danghudabi, i Masi cheñe. ");
INSERT INTO hru_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sünda ñetoahuwñe i namko yo kahuañe ĝüdzüw ge katrükralye, sündawñe upu na í tchüsetcho ichi a kakusetcho, sünda í dügoha, nachi go djukatrükralyeweñe. ");
INSERT INTO hru_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Séŝo i ná chetcho, “No ñetrü utro ge je Tawgyew ichi shi-ñu trujo dulumme, hado chemeje nó he í daweñe kiabadamme.” ");
INSERT INTO hru_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sünda i Galili ñetrü go ñegru ge shi-ñu tru. ");
INSERT INTO hru_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Upu na ichi ge gapulotsüñe, seyo Tawgyew ichi shi-ñu na dzütsüküĝütsü, sünda ibó ge Gannesrat go huĝülyi üdza to gudzu, sese ana a da. ");
INSERT INTO hru_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Sese i huĝülyi üdza ge lü ksü vyedaw hohu, seyo tromaw-dzükrüw na ná tromaw na tchegüdramkoi. ");
INSERT INTO hru_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Se lü namko ye a ye, se Simon ichi ye lyimyoalye, i í hudza ge me latrülyeweñe küĝüñe che, sündawñe i lü ge ĝyolye i nüna ná shi-ñu trukülye. ");
INSERT INTO hru_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","I ñu trufiahuwñe, sese i Simon i che, “Ĝyuw ge la jikewe, seyo tchü lügyejoñe bá tromaw ye majo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon i í chetcho, “He Tabrawwa, no yakülyi ñegimütrü kuw koĝiw dawye ha malügyelafibi; sedamje ba ñu cheda, tromaw mamkoime.” ");
INSERT INTO hru_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Se i süna dawñe, ichi tromaw ye tchü aña-ŝütchüw tromaw gaĝalajew malgrula. ");
INSERT INTO hru_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sündaw i í draw utro lü ge gyodaw na, age djeñe latunoweñe naje damche: seyo se na djekutsüñe, se lü ksü ye gudze-gulüŝüahuw lagu vye sünda lü yeje mülajo ladjew latchuĝyo vye. ");
INSERT INTO hru_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Se na holyebi Simonñe Patras naksü Jisu üshitrü ye gaañe, seyo che, “He Tawgyewwa, notrüĝañ yo katrülyewe, hado cheme no lalo nünabame!” ");
INSERT INTO hru_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Hado chemeje aña ŝütchüw tchü lügyeladaw í holyeñe i seyo üdra ayo na mavenghuatsüdabi; ");
INSERT INTO hru_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Seyo sünatchombo Jabdi í üsaw Yakub ñe Yohañ naksü je, dju Simon í shürhawma, mavyenghuatsü dawñe Jisu i Simon í chetcho, “Djuĝejodawe, ayogo ba nüna ná üshü tsülajo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sündawñe na lü ye hudza ge lakulye seyo sa a tralye ífum ífum kase. ");
INSERT INTO hru_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","I utro ñetrü ge dulu sese, se süge ĝoĝo yo tsafoahuw nüna a ye jiku, sünda i Jisu í hohulye uvro ye gakülyea, sündalye küĝüñe che, “He Tawgyewwa ba dagyojoñe vyedameje nó ba muchoadügyefijoŝome.” ");
INSERT INTO hru_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","I ügzü ye djüñe dadülye che, “Bá muchogüdraweñe, no vedame.” Sündawñe ichi se ĝoĝo tsadaw ye seŝügudo ye kagüdrüatsü. ");
INSERT INTO hru_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sündawñe i í trudrüse, “Djusaje djutruwe, séŝo kañe babraw ba mügaw na shewe, seyo ba künda güdraw mucholawma se fo ye, se hadamje Musa i djüvyelyedama se í djüwe ifo gow trufijoñe.” ");
INSERT INTO hru_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Séŝo íbo gow ñu ŝüpyo tüĝa-zeĝitsü, seyo ŝüpyo nünapu ye ichi ge shi-ñu dzüjoñe seyo sonaw na dagyolajoñe ichi ye keĝitsü. ");
INSERT INTO hru_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Séŝo i nüna ñiw ge utroga kagañe küĝüñgudru. ");
INSERT INTO hru_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ahua ye ana a datcho, i shi-ñu trumkotchoi sese, Farisiñe dakyew kikyew na sa a ĝyoda, dju Galili seyo Yahudiya go küña ñetrü duluma sego na, seyo Yarusalem go jiku; sünda naw na dagyoijoye Tawgyew í ĝagra gokyew ye idra ye duse. ");
INSERT INTO hru_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Seyo howe kagua na külyi-ĝüdjew naw nüna a ye, ñelütsüdru ge lalyi, seyo na í ĝütrü ge la jikuñe lamyoañe seyo Jisu ivro ye vyejoñe daahi. ");
INSERT INTO hru_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Seyo na upu mutchusübyeñe ñelunge la majimyofiwñe, na ñelütsü udru ge lyilyiñe seyo ñeltsü tahalye, í ĝütrü nadra ye Jisu uvro ge ulungko ye kikülyeaha. ");
INSERT INTO hru_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisu i na umsow lutuksüw vyedaw ye holyeñe che, “He nüna bá lalo ye muchoajemme.” ");
INSERT INTO hru_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sündawñe shizew-ñuzew nañe Farisi naĝütchü cheĝi, “He i djubajema, Tawgyew í mow uw zehi ye? Tawgyew í tralye dju lalo na muchoifiwa?” ");
INSERT INTO hru_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisu i nalu ge vyedaw danghulye ná che, “Djo djolu ge ha vyemkoiya? ");
INSERT INTO hru_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hado vyedoña? Ana chejoma, ‘Djo lalo ná muchoadama,’ semome ana ma ‘Gudzuñe seyo kutro djeg?’ ");
INSERT INTO hru_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Séŝo ye ana dadá djo danghujo dawe nüna üsaw í druguw-drulyiw ayo lalo muchoaifiwme.” I se külyi-ĝüdjea nado í che, “No ba chemkoi me, gudjuwe seyo bá ĝütrü ye lalye ba ñe ge la kabi.” ");
INSERT INTO hru_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","I jeañe ütrü a gudzu, seyo hayo sa a í gudru dama se í lolalye, Tawgyew í trolye í nudzoĝ ñe ge kajebi. ");
INSERT INTO hru_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sündawñe vyew na mavyenghuatsüñe Tawgyew í trotsü, sündalye ŝüpyo ĝeñe che, “Yow ñi sama a ñu hohujemme.” ");
INSERT INTO hru_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Seyo sefum a i ñepsü ge jihua, seyo Leviñe ñidaw a ye patso-law nüna ye patso ñe ye ĝyodaw hohu, sünda í che, “Nófum kasewe.” ");
INSERT INTO hru_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sündawñe i vyew tratsülye ífum kase. ");
INSERT INTO hru_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sünada Levi i í ñe ge ava tsaw rhano a djü; seyo sünda se patso-law nañe seyo nüna utro a upua nañe üŝa ĝyoñe ava tsa, ŝüpyo upu dyam. ");
INSERT INTO hru_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Seyo Farisi nañe seyo shizew-ñuzew nañe í shürhaw ná ana cheñe zekütso-zemrhü “Djo patso-law seyo lalobraw nadra hado ĝyoñe üŝa tsa-tu daiya?” ");
INSERT INTO hru_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisu i na chetcho, “Müga ñachi ge so manaw na majijome, séŝo sonaw na jijome. ");
INSERT INTO hru_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","No nüna güdraw na mowme, lalo duw ná nadrü-nalu lagudoijoñe balaw kakuwme.” ");
INSERT INTO hru_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Seyo na í chetcho, “Yohañ í shürhaw na ye ŝüpyo uw yo matsa-matuw küĝüñe ĝyoiwa, seyo sünambó Farisi nachi go na je, séŝo bá shürhaw na ye tsa-tuiwa.” ");
INSERT INTO hru_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisu i ná chetcho, “Hawa ba name gzü jiw nüna ná gzübraw ye nadra dulu sese, matsa-matudügyefijoma? ");
INSERT INTO hru_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Séŝo se ñeto je kakujome, sayo sa a gzübraw ye nayo utroga dajome, sese na se ñeto ge matsa-matuw dajome.” ");
INSERT INTO hru_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ná i zeĝaw a ze tru, “Dju nüna yo gye ükün ye taĝañe dju matüpsüwme, semome ükün ye taĝajobabi sedamje se tüpsüdaw ye je gye üme üdra makamyoĝijo. ");
INSERT INTO hru_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Seyo dju je tsühu ükün ye dzaĝi üme gye mapyujo, semome tsü ükün ye se dzaĝi üme yebó byoĝalye kasuajo, seyo dzaĝi je mau lyajo. ");
INSERT INTO hru_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Séŝo anggur uhu ükün ye dzaĝi ükün ge pyujo dume. ");
INSERT INTO hru_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kagua nüna na tsühu üme ye tulye ükün ye matuĝoñjo, hado chemeje na truibi, üme ye ufomdodaŝo cheñe.” ");
INSERT INTO hru_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sündalye ĝyogow ñeto sehu i vi goŝü dañe kamkoi sese, seyo í shürhaw na pu ye trükülyelalye, ügzüku yo shükrüñe tsa-tsa ka. ");
INSERT INTO hru_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sese Farisi namko yo na hadamje chekülyetcho, “Djo süna chiĝa hado dawwa hai ye ĝyogow ñeto ge madafiwjoma?” ");
INSERT INTO hru_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisu i ná trutcho, “Hawa djo he í mangüma, nugo Dawudñe üdra ayo na luhuŝüda sese ha dawma? ");
INSERT INTO hru_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I kündañe Tawgyew ichi ñe ge jima, seyo lapsü djüdaw go odje na lañe tsa, se na bó mügaw ná tralye djusaje matsafijo, seyo ídra yo naje djüdalubi?” ");
INSERT INTO hru_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sünda i ná chetcho, “Nüna üsaw ye ĝyogow ñeto ge je Tawgyewbamme.” ");
INSERT INTO hru_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sünda ana dañ ahua ye ĝyogow ñeto kuw sese i ñegru ge jiñe shi-ñu trutchoñe da ĝyo; seyo sa a nüna a duw ye ügzü fuvro go krosdzüada. ");
INSERT INTO hru_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Shizew-ñuzewñe Farisi na í hadamje zeñe ñu jojoñe hoksü ĝyo, i ĝyogow ñeto ge dagyoahima madagyoima hojoñe. ");
INSERT INTO hru_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Séŝo ibó nalu vyedaw dãhuñda; sündada i se ügzü kroadaw nüna í che, “Pülyiñe, umko a gudzug.” I pülyiñe gudzu. ");
INSERT INTO hru_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jisu i í chetcho, “No djo he dzüime ĝyogow ñeto ge ha dafijowa, uw dajo veima mo mau dajoma; shüw ná ĝaksüjoma mo maĝaksüjoma?” ");
INSERT INTO hru_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Seyo i vyew ná hozeĝiatsülye, se nüna í che, “Bagzü ye vro ge djüwe.” I süna da, sündawñe ügzü ye muchoañe uw lya. ");
INSERT INTO hru_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Séŝo se na ñepsü ge kuhuatcholye lusvyuñe naĝütchü poĝitcho, ñi he Jisu idra ha dañelye? ");
INSERT INTO hru_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Seyo se ñeto bó i pudru ge küĝüw katrükralye, seyo akülya ñetow Tawgyew í küĝü ñetoaha. ");
INSERT INTO hru_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ñetoahuwñe, i í shürhaw ná balalye namko ye ĝü yo ksü ye pola, sündalye ná shürhawñe che. ");
INSERT INTO hru_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sünda se na heimme; Simon í ñiñi ye i Patras ñe je vye; seyo í ñuw Andriyas, seyo Yakub, seyo Yohañ, seyo Fillipus, seyo Bertulme, ");
INSERT INTO hru_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Seyo Matti, seyo Tomas, seyo Halfais í saw Yakub, seyo Simon dju í Jeletes je chewma, ");
INSERT INTO hru_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Seyo Yakub í saw Yahuda, seyo Yahuda tcho Iskariyoti, se i í tsadrüahuw lyikülye. ");
INSERT INTO hru_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sündawñe na ídra kagalye no üpra a ye gudzutsü, sünda ichi shürhaw na upu mutchu, seyo vyew Yahudiya na, seyo Yarusalem, seyo Sor seyo Sidon go sütüĝülü üdza ge küña ñetrü ma sego ŝüpyo nüna upu na je, ");
INSERT INTO hru_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dju i shi-ñu truw í seyo ĝulo ná muchoañe dagyojoñe ichi ge jikutsüdama, süge dutsü. Seyo chigüje na maw da vyedaw na je uw dagyo. ");
INSERT INTO hru_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Seyo vyew na í kidüĝyoñ vyetsü, hado cheme íso go ĝagra na kahuañe ná muchoahi. ");
INSERT INTO hru_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sündawñe i í shürhaw nachi ge hoñe che, “Ŝüvzüwme bá, ñeto daw ye, Hado cheme Tawgyew ichi ñetrü ye bachime.” ");
INSERT INTO hru_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Ŝüvzüwme bá je, dju luhuŝüdama, Hado cheme ĝaksüjome, Ŝüvzüwme bá, dju ksei ma; Hado cheme tchüjome.” ");
INSERT INTO hru_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ŝüvzüwme bá, dju nüna üsaw íbo Bá mau dajome, Seyo bá lahuajome, seyo bá tchüĝo-hoĝojome, Seyo bá ñiñi danghulye vyetsü djojome. ");
INSERT INTO hru_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Sehu ñeto lüshüñe gyojo dawe, hado cheme hojo dawe, babó soĝgo ge lapsü dume. Í bupye-ñipye ñihow kew nadra je süna dawbamme.” ");
INSERT INTO hru_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Séŝo tui me djo, dju bo-luko duma, Hado cheme djo djolu vyew apyew pajebi.” ");
INSERT INTO hru_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Tuime djó dju hesahe ĝaksüwdadama, Hado cheme luhuŝüjome.” “Tuime djó, dju hesahe tchüima, Hado cheme duhu pajome seyo ksejome.” ");
INSERT INTO hru_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Tui me djó, nüna na djodruge uw chejome, Hado cheme ná bupye-ñipye na mülaw ñihow nadra je ana dawbamme.” ");
INSERT INTO hru_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Seŝo dzüvodo djó no chei me, bá vyeñido na nülvow dawe; bá dju mau daiba sena uw dajo dawe. ");
INSERT INTO hru_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bá dju chemui ma, sená gaĝüzü djüjo dawe; bá dju zeamei ma, senábo küĝüijo dawe. ");
INSERT INTO hru_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Dju bákrumo ge tcheima, ichi ge krumo a go je djüwe; seyo dju bachi güfaw laĝaima, se í bá polu djulawe djuchewe. ");
INSERT INTO hru_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dju damje bá prüima sená djüwe; seyo bachi gañ laĝaimeje, í djuprüwe. ");
INSERT INTO hru_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Seyo ba nüna ná bá küna daweñe vyedama, baje ná süna dajo dawe. ");
INSERT INTO hru_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Seŝo ba bá nülvow dai ná akasa ba nülvow dame je, ba ha dew dawwa? Hado chemeje lalo dado na je, ná dju nülvow daima na je sená nülvow daŝoi. ");
INSERT INTO hru_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ba bá dju uw daihi ma sená akasa uw daijobame, bá ha dew chejowa? Hado chemeje lalo daw na je süna bó daŝoi. ");
INSERT INTO hru_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Seŝo ba í chi gudzumeje, nachi go patchojoñe vyemeje, bachi ha uwwa? Hado cheme lalo daw naĝütchü je chi bó gudzuŝoi. ");
INSERT INTO hru_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Seŝo bá vyeñido nadra nülvow dawe, seyo uw dawe, seyo patchojoñe mavyew chi gudzujo dawe; seyo babó dew lapsü lyijome; seyo ba Tawgyew í üsañe chejome, hado chemeje i se nabó dju maŝüvzüdügyejome, dju kew nadru ge nülvoi me ");
INSERT INTO hru_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Baw küna nülvosüwma, sünambo ba je nülvojo dawe. ");
INSERT INTO hru_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Külü dju jowe, sündame badru ge je külü majojome; trudañe djuchewe, badru ge je truda machejome; aloijoda, sündameje bá je alojome. ");
INSERT INTO hru_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Djüjo dawe, sündame bá je djüjome: nüna na düsdzü-düsdzüñe seyo so-soñe seyo gusuañe badru ge suijome, hado cheme ha chi yo ba tsoima, se chi yo babó je seiyo tsojome.” ");
INSERT INTO hru_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sündatcholye i ná zeĝaw a yo chetcho: “Hawa ñiĝew ye, ñiĝew í ĝabo trufijoma? Hawa naksü noĝu ge magaajoma? ");
INSERT INTO hru_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Shürhaw na nudzoĝ chi dadrüw na yo madewfojome, seŝo djudamje dagro dama, i í chi dadrüw imbó vyedujome. ");
INSERT INTO hru_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ba bá ñuw ichi iñi go gashüsadaw shobosa í hado hoiya, seyo bá nudzoĝ báñi go sholbosa duw ye maholama? ");
INSERT INTO hru_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Seyo ba bá nudzoĝ bañi go sholbosa mahomeje, ba bá ñuw ichi í künda chefijowa, ‘No ñuwwa, mola bañi go gashüdaw ye lahuajoma?’ He dakulyutchüwba, uvromashü bachi iñi go sholbosa lahuavzüwe, sündameje sese bachi üñuw ichi iñi go gashüdaw ye hohulye lahuahifijome. ");
INSERT INTO hru_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ha shoñ uw a je ñime, dju sheje ha madaĝiw jewma, seyo ha madaĝiw shoñ je ñime, dju shejo uw jewma. ");
INSERT INTO hru_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Shoñ küña duma, nudzoĝ üje yo hosüwme; hado cheme nüna na gralye go lufuje mapyowme, seyo küfsüje go angur mapyofijome. ");
INSERT INTO hru_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nüna uw na nudzoĝ lu go ñu uw chehuahi; seyo nüna mau na nudzoĝ lu go mau ñu na mau yo chehuajome; hado cheme lu ge ha gudama se i namdzu go kahuajome. ");
INSERT INTO hru_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ba nó ñu chew ná madzüjomeje, sünameje hado nó ‘He Tawgyewwa, he Tawgyewwa,’ cheiya? ");
INSERT INTO hru_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Dju damje nochi ge jikuima, seyo nó ñu í dzühulyeñe zew dzüima, no djo trujome, na dju vyeduwma? ");
INSERT INTO hru_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I se nüna i vyeduwme, dju ñe damkoi sese nogüdzü ye ĝyuw chigalye kunu ge ñekrü dzuñe, seyo hutchuĝo-ĝolüŝü ye idru yo da kaa, séŝo í madañifijome; hado chemeje i lyow yo dada. ");
INSERT INTO hru_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Séŝo dju dzhutcholyeñe zew madzüma, se i se nüna i dambo vyeduwme, dju nogüdzü ye ñekru lyow madaw dadama. Se udru ge hutchuĝo-ĝolüŝü kame, i sebyo-seĝyo ngüañe seyo se i gaañe ganü-gaĝaaha.” ");
INSERT INTO hru_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","I í ñu ná nüna na trumdzoalyeñe Kafarnahum ñetrü ge jiku. ");
INSERT INTO hru_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sünda mükaw a ichi kulom djú i, í ñeŝümbo veduw vewma, usso nañe dzüjo veduw lyada. ");
INSERT INTO hru_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jisu iñiñ hutraw-notraw dzühulyeñe Yahudi ñetrü go nugow na ütrü ge í kulo í jikuñe dagyoiwe cheñe ki. ");
INSERT INTO hru_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na Jisu ichi ge jikuñe ishitrü ge gaañe ana che, “Ba ibo he i daijo dawe ");
INSERT INTO hru_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Hado chemeje i ñí ĝübye na nülvo daw, sünda ñi melye ñe ije i daihu.” ");
INSERT INTO hru_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jisu i nadra nadra hutro jisa, sünda i ñe yo añe üĝa ñibisa sa a, mükaw i üdraw na yo ana cheñe ki, “He Tawgyewwa, ba ñikuñisüw djudajodawe, hado chemeje nochi ge übadzü ñime, ba no ñelütsü pudaw ge jimyojo. ");
INSERT INTO hru_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sündada nudzo no bachi ge jikujo übadzü duñe mavemme, sé ba bá ñu i truñe no kulo usso dagyoiijodawe. ");
INSERT INTO hru_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Noje nüna na üla yo nünabame; sünda shipashi na nogzü geme, sünda nüna a í ‘Kab’ chewñe se nüna ye kaw, sünda ütro a í ‘age kab’ chewñe i kaku; sünda no kulo na ‘He i da’ chewñe na se chiĝa i daag.” ");
INSERT INTO hru_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","He ñu í dzühulye Jisu i lumashüw vea, sünda i ufum ge nüna upu kalasalai nachi ge tcholtruĝiañe cheñ, “No djo he trungkoi heme, Israyel ge je no ana veksüw mapame.” ");
INSERT INTO hru_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sünda nüna kidaw na ñe kaku hobanda, kulo usso nadaw i dagyovodabi. ");
INSERT INTO hru_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Me ñegi fum sa a i Nayan cheñe ñetrü a ge ji, ichi shürhaw nañe seyo nüna upu üdra jisa. ");
INSERT INTO hru_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","I se ñetrü gow füta ütrü iñisa jiku, hojodawe, nüna na ñimo a í ñepsü ge la kahuangkoi; se ye üyan üsaw akasa ba, sünda i müjem: sünda ñetrü gow ŝüpo nüna añe üdra dusa. ");
INSERT INTO hru_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Í hoñe Prabu üdrapra-ulupra na, sünda i cheñ, “Dju ksewe.” ");
INSERT INTO hru_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sündawñe i iñisa ge jikuñe ñimo vedaw i ki; sünda gidaw na ĝogog jebi, sündawñe i cheñ, “O muhumya, No ba chengkoime, pakülyejodawe.” ");
INSERT INTO hru_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sündawñe se dzüdaw ye pakülye ĝyo, sünda ütrü zekülye: sünda i í üyañ i djülye. ");
INSERT INTO hru_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","He yo vyew na ĝeatsü, sünda na Tawgyew ibo gow troñe ana che, “Ñimko a ŝüpo dyew ñihow truw a kakülyadame, sünda Tawgyew i í nülvow í nüna na she.” ");
INSERT INTO hru_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sünda ibo gow ñu ye vyew Yahudiya seyo iñisa gow vyew ñetrü ge truzeĝiatsü. ");
INSERT INTO hru_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sünda Yohañ i í shürhaw na he ñu na trutsü. ");
INSERT INTO hru_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Sündawñe Yohañ i í shürhaw nangko yo ksü i balalyeñe Prabu ichi ana dzüw ki, “Kakujo ye babamma, mo no utro na ĝyokrüjoma?” ");
INSERT INTO hru_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na ichi ge jikuñe cheñ, “Yohañ baptisma djüw i ñi bachi ge ana a dzüw kidame, se ye kakujo ye babamma, mo no utro ĝyokrüjoma?” ");
INSERT INTO hru_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sa yo sa a i ŝüpo na usso naw yo seyo duhu yo lahuaida; sünda mütü kamyodaw seyo ŝüpo iñi ĝiw na iñi djü. ");
INSERT INTO hru_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sünda i í che, “Djo ha ha hohuñe dzühudama, kañe Yohañ i trujo dawe; iñi ĝyew hohungkoimme, üshi lyew kahingkoimme, ĝoĝo nadaw i dagüdrajemme, ufu vaw dzühungkoimme, sünda dzüdaw ye üshükülyejemme, sünda sapse na Tawgyew i shi-ñu trujeme. ");
INSERT INTO hru_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tawgyew i ŝüvzüw djudra duma na ushi mahütrüjome.” ");
INSERT INTO hru_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohañ i kidaw nüna na kawñe, Jisu i Yohañ ubo gow nüna na ana tru, “Djo bye ge ha how jiña? Ha, ñedzülyiw yo age ngüa süge ngüa daw müsuĝ i? ");
INSERT INTO hru_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nameje djo ha how jibaña? Ha, nüna gye howsa shedaw í? Howe, dju gye-ĝuvo uw sheima sünda ñe uw ge gyoima, na mahal ge ĝyowwa. ");
INSERT INTO hru_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nameje ha how jimdobaña? Ha, djuma a ñihow í? Am, no djo trungkoime, ñihow truw ije dyewfo. ");
INSERT INTO hru_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","He ye sebamme, djubo ĝidama: ‘Howe, no muko í bavro bavro kijome, dju bavro ge kañe ĝabo gudow davojome.’” ");
INSERT INTO hru_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“No djo trungkoime, mim naluhu yow sadaw na, namko ye Yohañ i dyewfo djuje mome sé dju Tawgyew i ñe ge imisafo dama, i se ije dyewfo me i.” ");
INSERT INTO hru_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sünda vyew nüna na seyo patso-lavow naje dzühuñe Yohañ ichi gow baptisma lañe Tawgyew i umso ve. ");
INSERT INTO hru_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sé Farisi seyo shotuko-kunu davow na ichi baptisma malañe Tawgyew i ĝabo shedaw i madzü. ");
INSERT INTO hru_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Sündada: no he shültsongkoi gow nüna na ha üdra tsojowa? Na ha veduda? ");
INSERT INTO hru_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Na se angasa na veduw dju bajar ge ĝyoñe naĝütchü ĝuksuĝiñe ana cheĝiw, ‘Ñi babo bzüva viw, se ba ñuksu je mada, sünda ñi duhu dawgeje ba kseje makse.’ ");
INSERT INTO hru_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hado chemeje Yohañ baptisma djüw i odje je matsaw kakülyada seyo tsü je matuw kakülyada, sé ba cheiye, usso ge mütü du. ");
INSERT INTO hru_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nüna üsaw na tsa tuñe kakülyahume; se ba chewye, ‘Howe, tsaĝotüw sünda tsü tujetchüw nüna nawa, patso-law üdraw seyo lalo gifuĝuw nadraw.’ ");
INSERT INTO hru_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sé patsü-sholu ye nasaw nachi í umsoñe da veda.” ");
INSERT INTO hru_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sünda Farisi a ye í üdra ava tsasaweñe bakuda; sündawñe: i se Farisi i ñe ge jiñe ava tsajone ĝyoha. ");
INSERT INTO hru_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Süge se ñetrü yo lalobram a ye, i Farisi i ñe ge ava tsaw jikuñe ĝyoda che danghulye, kunulübzü yo daw shüve a ge ŝowsa ŝow uhu lajikuda. ");
INSERT INTO hru_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Sünda üshi ütrü ge, fum gow gudzüñe kseñe üshi i üñiŝü yo daĝüñe sünda nudzo ükye gow ükyetrü yo dügüdra sünda üshi ge umdzu yo tsa tsañe, ŝowsa ŝow uhu yo ŝüi. ");
INSERT INTO hru_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","He í holyeñe, se Farisi dju í baladama, üdrü-ulu ve vemche, “I ñihow truw nünan meje i danghujobi, dju i kingkoima, se ye djuma seyo küna mimma cheñe? Hado chemeje ibo lalobrambabi.” ");
INSERT INTO hru_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","He í dzühulye Jisu i hutrolañe cheñ, “Simonña, no ba hadamje a chejome.” ");
INSERT INTO hru_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Bo djüw a ichi gudzuvaw ksü duw, a ye lumu yo bosüñ fo pom, seyo utro a ichi ge lumu yo bosüñ pomĝü duw. ");
INSERT INTO hru_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ichi ge domĝütchojo ñiahuñe, sündawñe i naksü maksü i ujobammeñe traaha. Sünda: naksümko a dju í nülvo fo vejowa?” ");
INSERT INTO hru_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon i cheñ, “no vew ge, i djú añe traafodama.” I í cheñ, “Ba uw vebadamme.” ");
INSERT INTO hru_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sünda se mim ichi ge tcholtrüñe i Simon i che, “Ba he mim i homa? No ba ñe ge jikuwbi sé ba nó üshi chejo hu je madjü, se i noshi i iñiŝü yo dagzüida, seyo i nudzo ükyetrü yo dügüdraida.” ");
INSERT INTO hru_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ba no umdzo yo bubu matsa, se no jikuw yo i noshi i umdzo yo bubu madamdu. ");
INSERT INTO hru_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ba no kye ge tel je maŝüi; se i noshi ge ŝowsa ŝow uhu ŝüida. ");
INSERT INTO hru_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Sündada no ba chengkoime; i lalo ŝüpo duw ye, muchoihumme, hado chemeje i ŝüpo nülvo dada; sé djuchi mesame muchodama, i nülvow je mesame dawba.” ");
INSERT INTO hru_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sünda i mim í che, “Ba lalo muchoajemme.” ");
INSERT INTO hru_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sündawñe üdra a ava tsaw ĝyosadaw na, nadrü-nalu ve vetsü, “He lalo na muchoihu ye djubajema?” ");
INSERT INTO hru_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Se i mim i che, “Ba küĝüw ye ba ĝaksüi damme, lüshüw yo kajodabe.” ");
INSERT INTO hru_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Se yo na ñetrü ñetrü shi-ñu tru ka, seyo Tawgyew í ñe gow shi-ñu na truñe kahiw, sünda i nadra shürhaw ĝü yo ksü duse, ");
INSERT INTO hru_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","seyo mim üchea naje djuso gow mütü na lahuañe so naw na dagyodama, se iñiñ ye Mariyam Magdalini chewme, djuso gow mütü mro kahuadama. ");
INSERT INTO hru_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Seyo Herodes i hokrüvow Kuja ufum Yoanañe Susana seyo ŝüpo mim na í ná gañ-miĝi yo na kulom na hotunovow. ");
INSERT INTO hru_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nüna upu jikyeĝiatsüwñe, seyo ñetrü ñetrü gow na je ütrü ge jikutsüwñe, i zeĝaw tru: ");
INSERT INTO hru_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Üsü traw nüna a ye üsaw traw jihua: trangkoi ye üsü üchea ye ĝabokutru ge gaa, sünda dügrüprag, seyo ñedzü gow musu na pilag. ");
INSERT INTO hru_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Seyo üche ye kunuka udru ge gaa, sünda shükülye, séŝo hu gzüw mapawtro graha. ");
INSERT INTO hru_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Üchea ye tsü namko ge gaa, sünda tsü na üŝa üŝa shüsañe i shümüla. ");
INSERT INTO hru_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Seyo üchea na no uw ge gaada, sünda shülyilyeñe sheje fuĝua dzaw djüda.” Ana chefialyeñe i gow yo ñu che, “Djuchi ge dzüjo ufu duma dzüsawe.” ");
INSERT INTO hru_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","I shürhaw na i dzü, “He zeĝaw ichi hawa?” ");
INSERT INTO hru_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","I cheñ, “Djo Tawgyew i ñe go ñu na dzüsüdügyewbi, se utro na zeĝaw go trujome, hado chemeje na hohuñe mahohujome, seyo dzühuñe je madzüsüjome.” ");
INSERT INTO hru_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Zeĝaw í chemeje ana me: üsü ye Tawgyew í ñume.” ");
INSERT INTO hru_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ĝabo üdza ge ĝyodaw na dju dzühudama; sündawñe mütü na jikuñe nadrü-nalu gow Tawgyew í ñu i lañe katrükralye, hado cheme ana malyajoŝoma na Tawgyew i küĝüñe na ĝaksüw pajo. ");
INSERT INTO hru_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kunnu udru ge duw na, dzüñe lüshüw yo shi-ñu bo laŝoi, séŝo ükrü ñiw tro ye na umso mesame kuw ve, sünda muchow ge gaaha. ");
INSERT INTO hru_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Dju kusu ge gamyoadama, se na, dju dzüi na, sé vro ge kañe vesumow seyo bo-luko seyo shüng-dongkoi ge duhu ge gamyojome, sünda na sheje mañujo. ");
INSERT INTO hru_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sé no uw gow na he me, dju shi-ñu lu-drü lümyew yo dzüñe veima, na se yo sheje lakufijome. ");
INSERT INTO hru_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Djuje müsaw tchüholyeñe boĝtom yo pelye mavejo, seyo buĝo ufum ge mavejo, sé mütchü ubo ge vejo, hado chemeje nüna jikudaw na müsaw pajo. ");
INSERT INTO hru_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Haje mamüŝüme, ha ye matruhoajoma; seyo haje trumŝüw ñime, se ye madanghujome sünda müsaw mapajoma. ");
INSERT INTO hru_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Sündada ĝüdzüw ĝyowe, ba ha vego dzüngkoima? Hado chemeje djuchi ge dumañe vedama, i djüpyojolume; seyo djuchi ge ñima, ichi gow se ije laĝajome, ha ye ichi nudzoĝchiñe vedama.” ");
INSERT INTO hru_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Üyaññe uñuw naksü ütrü ge jiku, sé nüna añe duw tro sa í matüvafilye. ");
INSERT INTO hru_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sünda í tru, “Baññe bañuw naksü ba tüvajoñe ñepsü ge gudzudame.” ");
INSERT INTO hru_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","I í ñu i hutrolañe che, “No aññe no ñuw he bamme, dju Tawgyew i shi-ñu dzüñe seyo umso vewma.” ");
INSERT INTO hru_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sesüyo ahua ye i seyo i shürhaw na lü ge gyolyi, sünda i ná cheñ, “Age djebya, hu dügepsü ge jibo.” ");
INSERT INTO hru_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sündawñe: na lü í shaa. ");
INSERT INTO hru_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sündawñe na jiñe í dapüñe, sünda cheñ, “Tawgyewa! Tawgyewa! Ñi mauwfimauw lyangkoimme. Sündawñe i pakülyeñe ñedzü ŝüw-lyiw seyo hu i lashüraw i miĝi sündawñe na damudoañe ĝüdzüw lyaha.” ");
INSERT INTO hru_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sünda i na che, “djo küĝüi ye hanga?” Se na ĝeaglye seyo mavenghuañe naĝütchü cheĝi, “He djubajema, ñedzü ŝüw-lyiw seyo hu naje dügyeiye, sünda na i chew dzütsü.” ");
INSERT INTO hru_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sünda Giraseni na ñetrü ge jiku se ye süge pseĝ ge Galili hu ütrü iñisa ge. ");
INSERT INTO hru_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","I hudza ge jikuwñe, se ñetrü go nüna a í tüva, djuso ge mütü kamyodama. Seyo ŝüpo üĝaluw gomdo gye-ĝuvo je mashew seyo ñe ge je maĝyow nuĝu ge aka ĝyow. ");
INSERT INTO hru_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","I Jisu i hoñe ŝogzu, sünda uvro toi gaañe gow yo ñu che, “He Toĝgroyama Tawgyew üsaw Jisu! No badra ha dajo duwa? No ba chengkoime, no ñiku-ñisüw djudjüjodawe.” ");
INSERT INTO hru_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hado chemeje i mütü í se nüna usso go kahuawe cheñe dügyengkoi, sündada i üdra gow lyanggudrulai. Sünda nüna na í sülyeñtchü seyo sülyebu yo vogo vew, sedamje i se sü na gokyoaha, sünda mütü ye i sümbye ge sagañgudrudügye. ");
INSERT INTO hru_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisu i í dzü, “Bañiñ hawa?” I cheñ, “Upu,” hado chemeje ŝüpo uĝulo na usso ge kamyolyedabi. ");
INSERT INTO hru_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sünda i í cheñ, “No noĝu ge djukadügyejowe.” ");
INSERT INTO hru_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Süge puge vo upulo dyew a tsamroñe ĝyoda, sünda: i í cheñ, “No nalung ge kamyodügyewe.” Sünda: i í kamyodügye. ");
INSERT INTO hru_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Sündawñe se uĝulo ge nüna usso go kahuañe vo usso ge kamyoag sünda se vo upulo ye ĝo ge ĝüañe husu ge gamyoñe gamüla dzüag. ");
INSERT INTO hru_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Fugulu ĝyokrüw na se dagjew i holyeñe ĝe djeshükralyetsü, sünda ñetrü ñetrü ge kañe he ñu i trutsüküĝa. ");
INSERT INTO hru_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sünda nüna na se dajew i how jihuatsü, sünda Jisu ichi ge jikuñe dju nüna usso go uĝulo mauw lahuadama se ye Jisu ishitrü ge gye sheñe ĝyodaw i hohuñe ĝeag. ");
INSERT INTO hru_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sünda hohusadaw nüna na ná tru, se üĝulo mauw ye nüna i ñiku-ñisüw da vedaw í kündañe uw dagyodama. ");
INSERT INTO hru_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sündawñe Giraseni ñetrü üñisa gow nüna na Jisu i cheñ, ñichi ayo kahuajodabe; hado chemeje na ĝemĝekyoatsüdabi. Sünda: na lü ge gyolaye katrükralye. ");
INSERT INTO hru_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Djuso gow uĝulo mauw lahuadama se nüna ye í che, no badra ĝyokyejodawe, séŝo Jisu i kadügyelye cheñ. ");
INSERT INTO hru_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bañe ge kañe nüna na truwe, Tawgyew i kündañe babo aña ŝüw-lyiw chiĝa dadama.” I kañe vyew ñetrü ge trüzeĝiatsüg, Jisu i nobo küña ŝüw-lyiw chiĝa dadama. ");
INSERT INTO hru_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisu i Galili ñetrü go kalai sa a, nüna na lüshüw yo i tüva; hado chemeje na í ĝyokrüñe ĝyow. ");
INSERT INTO hru_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sündañe howe, Yayir cheñe nüna a iñiñ dju ñegru go dyewma, i jikuñe Jisu ishitrü ge gaañe cheñ, “Noñe ge jisawe.” ");
INSERT INTO hru_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Hado chemeje ichi oje ĝüyo ksü yo üsam akasa a duw ye dzüasalaibi. I jingkoi ge nüna ishitrü ge gaatsü. ");
INSERT INTO hru_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sünda mim a dju oje ĝüyo ksügomdo ŝü lu ĝyowma sünda dju nudzo shüw-duw na so naw dagyow nadru ge tratsüdabi sedamje djugzü gow je i madagyofibi, ");
INSERT INTO hru_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","fum gow jiñe i gye üdza ge kig sündawñe seŝüĝdo a i ŝü luw ye lumudoag. ");
INSERT INTO hru_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Se yo a Jisu i cheñ, “No dju kidügña?” Vyow na makitsüñe chetsüwñe, Patras seyo üdra ayo dusaw na cheñ, “He Tawgyewwa, bá he nüna fupulodaw na düñe badru ge gaiwa.” ");
INSERT INTO hru_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Séŝo Jisu i cheñ, “Djudamje a no kidawa hado chemeje no danghudabi nochi gow mu kahuajewa.” ");
INSERT INTO hru_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mim ye holyeñe no mamuŝufijobañe vewñe, usso somsokyo jikülye, sünda ishitrü ge gaañe vyew nüna navro se trukülye, i hado kima, sünda kündañe mekutcho dagyogdama. ");
INSERT INTO hru_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","I í cheñ, “Nosamya ba küĝüw ye ba dagyodaŝoñe, lüshüw yo kajodawe.” ");
INSERT INTO hru_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","I trungkoibalubi ye, ñegru go mügaw i nüna a jekuñe che, “Basam dzüdamme: mügaw i duhu djujüwe.” ");
INSERT INTO hru_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisu i dzühuñe cheñ, “Djuĝejodawe; küĝüjodabuwe; i basüjoŝome.” ");
INSERT INTO hru_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ñe ge jikuñe i üdra ye Patras, Yohañ, Yakub seyo mimsa üyow-üyañ na tralyeñe djuje ütrü üñisa ge majidüggyew da. ");
INSERT INTO hru_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sünda vyew na ubo kse-ñiĝitsü, séŝo i cheñ, “Djuksejodawe; I madzüme, i drumubadame.” ");
INSERT INTO hru_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nüna na i dzüdabi che danghuñe, i chedaw i dzüñe tchüg. ");
INSERT INTO hru_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sé i ügzü í kigolañe ĝuksuñe che, “He akoa pakülyebi.” ");
INSERT INTO hru_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sündawñe ĝulo üshükülyeñe pakülyeg; sünda i na dügye í tsajo hadamje djüwe che. ");
INSERT INTO hru_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Üyawñe üyañ naksü mavenghutsüg, sé i ná cheñ, he ha dajema se i djuje djutruwe. ");
INSERT INTO hru_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sündatcholye i na ĝüyo ksü shürhaw na balañe ná ĝuló mauw seyo so naw na dagyow dajo gow bó vye. ");
INSERT INTO hru_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Sünda ná Tawgyew i ñe go shi-ñu uw truw, seyo so naw na dagyowe cheñe ki. ");
INSERT INTO hru_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Sünda i ná che, “Jiw ge haje djulawe: shobo je djulawe, kapüĝa je, odje je, bo je seyo polu ksü ksü djulawe. ");
INSERT INTO hru_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Seyo dju ñe yedamje ba ĝyogoima, se a ĝyojodawe; sünda se yo kahuajodawe. ");
INSERT INTO hru_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dju bala maĝokyema se ñetrü yo kahuañe ishigo ñelümo na pafiajodawe, hado chemeje nadru ge na je truksüfijo.” ");
INSERT INTO hru_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sünda: na jihuañe ñetrü, ñetrü shi-ñu uw tru kaahi, seyo nüna ná djuje djuje dagyoñe kaahi. ");
INSERT INTO hru_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Seyo ñetrü go psüĝi fum yo nugo Herodes i he í dzühulyeñe mavenghuag, hado chemeje küña nüna na trudabya, Se i Yohañ dzüdo go üshükülyetchoda cheñe. ");
INSERT INTO hru_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sünda küña nüna na he i, se Eliya i hohuda: utro na ana je chetcho, ahugo ñihow truw mügaw namko yo djuma üshükülyetchoda. ");
INSERT INTO hru_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Seŝo Herodes i che, “Yohañ ükye bo no poskeadügyembi, he ye djutchoa, djufo go ana ñu dzühumkotchoiya?” Sünda i í hoĝoñikülye. ");
INSERT INTO hru_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sünda í shürhaw na kakuñe na ha ha dalyedama ná í truatsü. Sünda i ná utro ge lagañe, Betseda cheñe ñetrü a ge lañe kakye. ");
INSERT INTO hru_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","He i danghulyeñe nüna na ufum fupuloatsü, sünda í ná lüshüw yo tüvatsü, seyo ná i Tawgyew i Nogofo shi-ñu trukye, sünda djú dagyodügyeĝoñdama, ná dagyo. ");
INSERT INTO hru_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ñeto kapsealaibi a, se í shürhaw ĝüyo ksü jikuñe che, “Upu na kadügyejodabe, kañe na ñetrü ge ná ĝyojo seyo tsajo bühohidame, hado chemeje ñi ĝüdzüw ñetrü ge dume.” ");
INSERT INTO hru_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","I ná che, “Djo ná tsajo djübalabya.” Na cheñ, “Ñichi ge odje pom seyo tchükro ksü yo haje ñime; sé ñi jihuañe vyow nabo tsaw-tuw prülameje, se ye dujome.” ");
INSERT INTO hru_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Hado chemeje sa yo sa a muhu fo pom kuw du.) Sünda i í shürhaw na che, “Ná pom ĝü, pom ĝü dañe ĝyodügyewe.” ");
INSERT INTO hru_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na süna dabadába, seyo vyow ná ĝyodügye. ");
INSERT INTO hru_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sese Tawgyew i ülgü odje pom seyo tchükrosa ksü í la, seyo ñedzüdru ge hotroñe na gaĝüzü djü, sünda tchekuĝi, tchekuĝiñe í shürhaw na djü nüna na hawe cheñe. ");
INSERT INTO hru_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sünda: vyow na tsalyeñe tsaŝelatsüdabi, seyo godza daw yo mo ĝü yo ksü guw trügula. ");
INSERT INTO hru_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Se i akasa ĝüdzüw ge kagañe küĝümkoi sese, seyo idra ye ichi shürhaw na idra dusa, sündawñe i ná dzü, “Nüna na nó ha cheiya?” ");
INSERT INTO hru_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na che, “Yohañ baptisma djui ye, seyo kagua na mügaw Eliya, seyo kagua na chew ye ahugo ñihow truw mügaw nangko yo a üshükülye da.” ");
INSERT INTO hru_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","I ná dzü, “Seŝo djo nó ha cheiya?” Patras i che, “Tawgyew i üsaw Masi.” ");
INSERT INTO hru_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sündawñe Jisu ná züpsüĝeñe che, “He ana djúje djuchewe.” ");
INSERT INTO hru_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sünda i che, “Nüna üsaw í duhu paketrajobamme, seyo dasüñejome seyo kew mügaw na seyo mügaw sawlyiw seyo shizew-ñuzew na í hosügaw vyeñe shijobamme, sünda i ñegi dzü ye üshükülyetchojome.” ");
INSERT INTO hru_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","I vyow ná che, “djuma no fum kasajo vedama, nudzoĝ yo makasajoñe trawe seyo shüwa nudzo shokru i gilañe no fum kasajodawe. ");
INSERT INTO hru_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hado chemeje dju yo nudzoĝ shüw ye fupojome vedama na shokru í moajome, sé djudamje nobo nudzoĝ uluvyu takyoima se iyo í fupojome. ");
INSERT INTO hru_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nüna na vyow druguw-drulyiw í patsülameje, seyo nudzoĝ uluvyu ye takyoame, semome ñiku-ñisüw pa, se yo ha palajowa? ");
INSERT INTO hru_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Djudamje no yo seyo no ñu yo ñimtchüñjema; nüna üsaw ye je ichi seyo i awu ichi sünda güdraw sorgomuko ichi lüshüw pawñe, ije ñimtchüñjome. ");
INSERT INTO hru_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","No djo umso trungkoime, dju ayo ha a gudzudama, namko he a üchea na ana dame Tawgyew i ñetrü mahohumdoluye, na dzüw ye künama madanghujome.” ");
INSERT INTO hru_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","He ñu na chelye ñegi ŝügzü fum sa a Patras, Yohañ seyo Yakub na üdra küĝüw pu a ge lañe jike. ");
INSERT INTO hru_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","I küĝüngkolui ye, ukrumro utro a lya, seyo i gye ye grobülaŝüksüñe lüna-lünakülye. ");
INSERT INTO hru_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sese, muhu ksü se ye Musa ñe Eliya naksü üdra ñu chitrungkoi. ");
INSERT INTO hru_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Na ĝulo güdrawdra hohu, sünda i dzüjo go ñu poĝi, se ye Yarusalem ge dajo. ");
INSERT INTO hru_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Patras ñe üdraw na drumuĝoñatsüdabi, sünda na pakülyewñe, i ĝulo güdraw; seyo se nüna ksü ye dju üdra gudzüsadama, hohu. ");
INSERT INTO hru_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na ichi yo kajoñe dawñe, Patras i Jisu í che, “He übrawwa, ñi ha a ĝyow ye uwme: sünda: ñi lañe ulügü dzü dajome, a ye babo, a ye Musa ibo, seyo a ye Eliya ibo.” I madanghu, i ha chengkoima. ");
INSERT INTO hru_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","I ana chengkobaiye, ná mumu yo boshiĝiag, ná mumu yo bolyangkoi ye na ĝeatsüg. ");
INSERT INTO hru_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sünda se mumu yo ana ñu a zekülye, “He ye nosaw seyo no i golawme, i chew dzüwe.” ");
INSERT INTO hru_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","He ñu i dzühungkoi ge, Jisu i akasa hohuda; sünda i mazüda ĝyoda, sünda ha hohudama, se ñu í se ñeto ge djuje malakülye. ");
INSERT INTO hru_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Seyo se draha na pu goŝü kagaahuñe, upu dyew a í jiñe tüva. ");
INSERT INTO hru_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sündawñe, upumko yo nüna a ye ŝogzuñe che, “He dadrüwa, no ba chengkoime, nosaw i nülvow hoijodawe; hado chemeje i nosaw akasame. ");
INSERT INTO hru_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sünda howe, ĝulo mauw a usso ge kamyo, sünda i ülya akaye ŝogzukülyeg; seyo i se í ana ĝüshülyiĝiada, se i üga ge üzetcho fegukülye; seyo í ana damgzüw yo ñiku-ñisüw da tra. ");
INSERT INTO hru_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Seyo no bachi shürhaw ná che, í lahuawe; séŝo na malahuafi.” ");
INSERT INTO hru_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisu i che, “He maküĝü seyo bolu datchüw shürhaw nawa, no djodra küña kuw ĝyofisajowa, seyo djó daw na vejowa? I muhu i cheñ, basaw i age la jekuha.” ");
INSERT INTO hru_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","I jimkolai ye ĝulo mauw ye í lola padubug, sé Jisu i ñiŝgzüñ ĝulo í miĝiñe seyo muhusa í uw dagyoñe uyow ügzü ge djü. ");
INSERT INTO hru_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sündawñe vyow na Tawgyew i gow yo mavenghutsü. Sé vyow na í ha ha chiĝa dadama se na trongkoiye, sese i í shürhaw na che. ");
INSERT INTO hru_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“He ñu ye djo djofu ge vejodawe, hado chemeje nüna üsaw í nüna nagzü yo kigo ladügyejome.” ");
INSERT INTO hru_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sé na he ñu i madzüsü; se i í madanghdügye; seyo na he ñu ífo go idra dzüjoje ĝetcho. ");
INSERT INTO hru_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sünda shürhaw naĝütchü ge ñu a kakülye, se i ye nangko a dju dyewfoma? ");
INSERT INTO hru_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Seŝo Jisu i nalu ge vedaw í danghula, sünda muhumsasa a í lañe idra a gudzudügye, ");
INSERT INTO hru_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Sünda i che, “Dju damje noñiñi yo he muhusa i hutroima, se i nó hutrolawme; seyo dju nó hutroima, se na nó kidaw na je hutrolawbamme, hado chemeje djomko yo imisa yo imisafodama, se ye dyewfobamme.” ");
INSERT INTO hru_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sündawñe Yohañ i che, “He übrawwa, ñí nüna a ye bañiñi lañe ĝulo mauw í lahuahuw hohudame, sündada ñi í gohame, hado chemeje i ñidra ñisañe bafum makasa.” ");
INSERT INTO hru_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisu i ná che, “Í djugohajo dawe; hado chemeje dju djo mauw madama, na djodra dujome.” ");
INSERT INTO hru_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Se í sorgo ge lalyimdrü ñeto kakusalaibi sese, sündawñe i Yarusalem ge jijoñe vye. ");
INSERT INTO hru_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Seyo i ivro ge mukow ki: i Samariya na ñetrü a ge ji, ibó ĝyojo dashütrüivojoñe. ");
INSERT INTO hru_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sé na i magyogadügye, hado chemeje i Yarusalem ge jingkoida. ");
INSERT INTO hru_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Se i hoñe í shürhaw Yakub ñe Yohañ naksü che, “He Tawgyewwa; ba ha tsüda, se i ñi dügye, se i ñedzü go mi gaañe ná damyaweñe ma?” ");
INSERT INTO hru_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Séŝo i tcholtruĝiañe na ze, Seyo che “Ba madanghuwa ba ha uĝulo yo ma. Hado chemeje nüna üsaw ye nüna nachi luvyu ye damütrajoñe madaw se í ĝaksüijoñe kakuwme.” ");
INSERT INTO hru_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sündalye iñe i shürhaw na ñetrü utro ge jitrükralye. ");
INSERT INTO hru_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Se i ĝabo jimkoi ge, se djuma a ye í che, “Ba hange hange jiyima, no bafum kasajome.” ");
INSERT INTO hru_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisu i í che, “Ŝelü ichi uksu seyo ñedzü go musu nachi üdrü duwme, sé nüna üsaw ichi ükye vejo je ñe ñime.” ");
INSERT INTO hru_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","I utro nüna a i che, “Nofum jisawe.” I che, “He Tawgyewwa, nó uvromashü kadügyevzüwe, no awu í ĝuavzüjome.” ");
INSERT INTO hru_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","I í che, “Dzüdaw na ná nudzoĝ dzüw í büĝudame, sé ba jiñe Tawgyew ichi ñetrü go shi-ñu trujodawe.” ");
INSERT INTO hru_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Utro a ye je che, “He Tawgyewwa, no bafum kasajome; sé uvromashü nó kadügyevzüwe no nochi ñe go nüna na yo mülüñ kajoñe.” ");
INSERT INTO hru_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisu i í che, “Djudamje nudzo ügzü i luksungkuĝu ge kiñe fum ge homeje, i Tawgyew i ñetrü ge ĝyofiwjome.” ");
INSERT INTO hru_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Seyo he ñu nafum sa a Tawgyew i nüna mroĝü lapyo, sünda ha ha ñetrü ge i jijoma, süge ksü, ksü dañe ivro kibraĝitsü. ");
INSERT INTO hru_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sünda i ná che, “Rhamu kiw añe dume; séŝo chiĝa daw mesame duba sündada vi übraw i küĝüwe chejodawe, se i í nudzoĝ vi í tcholajo vi nüna kiwe.” ");
INSERT INTO hru_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jiwe; howe no djó fugulu vyeduw dañe fumsu namko ge kijome. ");
INSERT INTO hru_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sündada dzulngasaje djulawe, kapüĝa je, seyo shita je; sünda ĝabo ge je nüna ná dju je gaga djudawe. ");
INSERT INTO hru_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Dju ñe ge jihima, uvromashü chevzüwe, ‘He ñe ge ĝüdzüw djuwe chewe.’” ");
INSERT INTO hru_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Süge djuma ĝüdzüw pafiwjo dumeje, ba ĝüdzüw djüdaw ye üdra dusajome, momeje bachi ge kakutchojome. ");
INSERT INTO hru_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Se ñe ge ĝyowe, sünda ichi go ha paima, se í tsa-tuwe, hado chemeje chiĝa daw nüna na ná shishü patsüw; ñetro-ñetro djukahijodawe. ");
INSERT INTO hru_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Seyo ha ñetrü ge jiyima, sügow nüna na hutrovowñe, se bavro a ha vedama se i tsajodabuwe. ");
INSERT INTO hru_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","“Sügow sonaw ná dagyojodawe: sünda ná chewe, ‘Tawgyew í ñetrü ye batrü iñiñisa ge kakudamme.’” ");
INSERT INTO hru_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sé ba ha ñetrü ge jimyoima, seyo sügo nüna na bá mahutrovolaime, ná bodzaĝ ge jeñe ana chewe, ");
INSERT INTO hru_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“‘Djo ñetrü yo ñelümo naje, ñishi ge güdrüsadaw na, ñi djovro a pafiamkoimme, sedamje he í danghujodawe, Tawgyew i ñetrü djotrü iñiñsa ge kakulaimme.’ ");
INSERT INTO hru_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","No djo trungkoime, se niyay ñeto se ñetrü ye Sadom ñetrü i je mofokaw gijo lyajome.” ");
INSERT INTO hru_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Tui Kurajiña! Tui Betseda! Dju dyew chiĝa dafiw ye djo ge dadama, sese í Sor ñetrüñe sidon ñetrü ge dameje, na ke ge gye güpañe seyo kütsesüpu ge ĝyoñe na kye ge dru-lu vyegudoñjemma. ");
INSERT INTO hru_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Seŝo, melye gzuñe cheĝiyi sehu bafo vyego yo yeje Sor ñe Sidon naksü vyego ye vyeksufofijome. ");
INSERT INTO hru_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Seyo Kafarnahum ñetrü, hawa ba soĝgo kuw lüvzüw dalyijoma? Ba bó noĝu üla ge kuw üla kaajome.” ");
INSERT INTO hru_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Dju ba chew dzüima, se i no chew dzüjo, sünda ba dju mauw daima, noje i mauw dajome; seyo dju no mauw daima, se ye no kiadaw i je mauw dajome.” ");
INSERT INTO hru_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Se shürhaw mroĝü yo ksü na lüshüw yo kakutchoñe che, “He Tawgyewwa, ba üñiñi yo se ĝuló mauw na je ñichi pudu-puña ulunge pumódame.” ");
INSERT INTO hru_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","I ná che, “No mütü í ñedzü lüĝaw veduw ñedzü go gaahu hohuime.” ");
INSERT INTO hru_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","No djó byu na seyo mütü güdzü na dügrüdzagofijo djüwme, seyo vyeñiw nachi go vyew mau dafiwjo ná madafijo pudu-puña djüwme; seyo ha gañ yo je djo naw madafijomme. ");
INSERT INTO hru_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sé sünaŝo cheñe djulüshüwe, se ĝulo mauw na djo pudu-puña yo pumoda cheñe, seŝo djo lüshüjo dawe se djo ñiñi Ñedzü ge ĝi vyedotro yo. ");
INSERT INTO hru_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sa yo sa a i ĝulo güdraw yo dañe lüshüdzoalye, seyo che “He Awa, Ñedzü ñe No i Tawgyewwa, no ba ulu yo uw cheime, se ba he ñu na danghu-kinghuw nüna seyo vyesü-vyelüw na yo müŝüñe veda, sünda angasa natrü ge duda. Am, he Tawgyewa, hado chemeje bá he í uw veda. ");
INSERT INTO hru_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","No awu i nó vyow nodru ge traadamme; seyo djuje madanghu se saw ye djujema, awu aka danghuba seyo awu djujema se je dju madanghu, se i ye sawchi gemdo aka seyo se djudru ge saw i dujoñe vyedama.” ");
INSERT INTO hru_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Seyo í shürhaw nachi ge tchoñe akasa ge che, “Ŝüvzüwme se iñi ye, se he ñu ná se ba hoiwa hoiye, ");
INSERT INTO hru_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Hado chemeje no djo chemkoime, ŝüpo ñihow truw na seyo ñubyu na tsüdaw ye, se ba ha ñu ye hoima howe; sé maho seyo ha ñu ye ba dzüima dzüwe, sé madzühu.” ");
INSERT INTO hru_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sündawñe nüna a gudzulyi; sünda ana cheñe í küna daima hopüñew che, “He shotuko-kunu go dadrüwa, shüwa shüw shüjo ibo ha dameje ujowa?” ");
INSERT INTO hru_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","I í che, “Shotuko-kunu ge ha ĝida? Ba künda ngüña?” ");
INSERT INTO hru_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","I trutcho, “Ba Tabraw bá nudzoĝ Tawgyewchi go vyew nudzoĝ drü-lu seyo nudzoĝ krãŝe seyo nudzoĝ budzu vyew se nadra nülvow vyejodawe; seyo nudzoĝ ĝafopsüĝi-ĝampsüĝi go ná nülvojo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","I í che, “Ba umso chedaba, he ana dabya sündame üshü ĝyojome.” ");
INSERT INTO hru_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sé i í nudzo í usu dajoñe veñe Jisu í dzü, “Nameje nochi ĝafopsüĝi-ĝampsüĝi na djuwa?” ");
INSERT INTO hru_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisu i che, “Nüna a ye Yarusalem yo Jeriko ge jimkoi ye ñigudu tsaĝaw na djeshiĝiaña i gye í na shalügülag, sünda gü-shü dañe atrü dzüw datralye katrükralye. ");
INSERT INTO hru_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sünda ana da, se ĝabo ge mügaw a kamkoi, séŝo í holye ĝeaglyeñe djetrükralye. ");
INSERT INTO hru_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ana vedumbo Lewi a ye je seŝü katcho, ije í holyeñe ĝeaglye djetrükralyetcho. ");
INSERT INTO hru_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Séŝo djudamje Samari ñetrü a go sa a kakukülye, sünda í hohulyeñe nülvo vyela. ");
INSERT INTO hru_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Sünda itrüĝañ ge jikuñe seyo ichi üshi ge luvuhu seyo tsühu prüñe gyeche-gyelye yo pyogo, seyo í güĝedru ge gyodügyelyeñe ñe ĝyow ge lajikye sünda í uwyo hoivo. ");
INSERT INTO hru_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Se draha í lumu yo bosüñ ksü lahuañe se ñebraw i djüñe che, ‘I uwyo hoivojodawe, seyo bachi go küña kapyoima, se ye no kakuwñe doajome.’” ");
INSERT INTO hru_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hesahelu he ba vyew ge se na ñigudu-tsaĝaw süna ge lyalahado, nadzüngko a dju ichi ĝafopsüĝi ĝampsüĝi go na ñe veiya,? ");
INSERT INTO hru_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","I che, “Se i dju í nülvodama.” Jisu i í che, “Kai, baje kañe süná dajodawe.” ");
INSERT INTO hru_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sündatcholye Jisuñe i shürhaw na jimkoitchoi ye, se i ñetrü a ge ji, seyo Marta cheñe mim a ye í iñe ge balada. ");
INSERT INTO hru_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Seyo Mariam cheñe uñum a duw, i Tawgyew ishitrü ge ĝyoñe i shi-ñu dzüw. ");
INSERT INTO hru_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sé Marta chiĝa da dañe mavenghua sünda itrü iñisa ge jikuñe che, “He Tawgyewwa, ba haje mavema, noñum í no akasa chiĝa daweñe traadaw ye? Sündada í chetcho, nó datunowe.” ");
INSERT INTO hru_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tawgyew i í trutcho, “Marta O Marta; ba ŝüpyo ñu ha vejema venglyeñe seyo mavenghu lyaha.” ");
INSERT INTO hru_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","“Séŝo ñu a ye umsome, seyo se chiĝa uw í Mariam i golame; se i ichi go malaĝafijomme.” ");
INSERT INTO hru_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sündatcholye ahua ye i nolu a ye küĝüngkoi. Seyo i se küĝüfiahuwñe, ichi shürhaw namko yo a ye í che, “He Tawgyewwa, Yohañ i í shürhaw ná küna veduw küĝüdrüdama baje ñi süna veduw küĝüdrüwe.” ");
INSERT INTO hru_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","I í che, “kye damje djo küĝümkoime, sese chejodawe: ‘He Awa, Bañiñ güdraw vejome, ba ĝadzü kakülyawe.’” ");
INSERT INTO hru_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","“‘Ñichi muhu muhu yo tsajo-tujo í ñi djüijodawe.’ ");
INSERT INTO hru_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","‘Seyo ñi lalo na muchoaijo dawe, Hado chemeje ñi je, ñi mauw dado na muchoaijome, Sünda ñi mauw uw dajo yo ĝaksüiwe.’” ");
INSERT INTO hru_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sünda Jisu i ná che, “Djumko ye üdraw a duw ye djuwa, sünda i ñegimko ge pakülyeñe ichi ge ji í chewe, ‘He drawwa; nó odje üka dzü djüwe. ");
INSERT INTO hru_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Hado chemeje, kasew-biŝew go draw a ye nochi ge jikuda, sünda ivro ge veijo nochi ge haje ñime.’” ");
INSERT INTO hru_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sünda i ulung goŝü ñu tru, se nó afafsüw djudjüwe; yabó ñegüdrüŝü je dugoadammje, sünda nosa ye nodra buĝo ge ĝüsadame, sündada no bá pakülyeñe haje madjüfijomme. ");
INSERT INTO hru_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","No ba trungkoime, se üdraw duñ sese je í pakülyeñe haje madjüfisabamme, sedamje i ñimtchüñ ye tralye prüdo ye í küña tsüdama süña pakülyeñe djüjoŝo. ");
INSERT INTO hru_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sünda no djó cheime; prümeje, djo djüjome; tchümeje djo pajome; dümeje, djobo voaijome. ");
INSERT INTO hru_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hado chemeje dju prüima, ná pajome; sünda dju tchüima, na pajome; seyo dju düima, nabo voaijome. ");
INSERT INTO hru_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Djomko ye dju ana awu duwa, se üsaw ye odje prüme, se í kunnu djü, seyo sündalye tchü prümeje, se tchü madjüw byu djü? ");
INSERT INTO hru_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Semome jeje prülaime, se í mütü güdzü djü? ");
INSERT INTO hru_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sünda, ba maulyeñe je basa ná gañ uw djüjo danghumeje, se djo ñedzü go Awu, i ichi nudzoĝ nüna prüi ná hado ĝulo güdraw madjüjowa. ");
INSERT INTO hru_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sündatcholye Jisu i ügadow ĝulo mauw a í lahuatcho; se ĝulo mauw ye kahuahuñe, ügadodo ye ütrü zekülye; sünda nüna na mavenghuatsü. ");
INSERT INTO hru_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Séŝo namko ye küña na cheda, “I bó ĝuló mauw nachi go dyewfow mütü ichi datunow yo lahuabaiwa.” ");
INSERT INTO hru_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Utro na í dafidama hojoñe í ñedzü udru ge hadamge sheweñe cheshew shewe che. ");
INSERT INTO hru_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Séŝo Jisu i, nadrü-nalü ge vedaw i danghulyeñe, na che, “Ha ha ñetrüĝüfo ge braĝidama, se ñetrüĝüfo ye mütrüajome; sünda ha ñe ye braĝidama, se ñe ye je mümyajome. ");
INSERT INTO hru_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Seyo sünda mütü ye í nudzo íbo magotchow dame, se ichi ñetrüĝüfo kündañe dujowa? Hado chemeje djo nofo go ana cheŝoibi, se mütü i datunow yo se mauw ná lahuabaibi cheñe. ");
INSERT INTO hru_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Senameje no mütü i datunow yo ĝuló mauw ná lahuabaimeje, se djó agü na dju tunow yo kakülyebaiya? Sündada ná djo niyay djüw nüna chejome. ");
INSERT INTO hru_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Séŝo no Tawgyew udruyo yo uĝulo mauw na lahuameje, Tawgyew i ñetrüĝüfo ye djotrü ge kakujome. ");
INSERT INTO hru_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nüna gow na nachi ñe i ĝaksüw chiaĝi pyogoñe ñe í hokrüimeje, se ichi gañ-miĝi na ĝüdzüw dujo. ");
INSERT INTO hru_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Seŝo ije gofotchow na djuma a í tumuvojoñe í dafoahuñe, í se chiaĝi na ha ye i veksüdama, sena laĝalag seyo ichi gañ-miĝi na laĝañe habraĝiame. ");
INSERT INTO hru_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Dju nodra ñima se i no mavyewme, seyo dju nodra dukyeĝiyima se i trabraĝiajome.” ");
INSERT INTO hru_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nüna usso go ñiŝügzüñ ĝulo kahuahuñe nokro ge ĝyogojo tchüĝijome, sünda mapawñe i chejome, no ha ñe yo kahua dama se ñe ge kamyotchojome. ");
INSERT INTO hru_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sünda kakuwñe i gümsa-gümĝañe howsa hohujome. ");
INSERT INTO hru_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sündawñe i idra ye í je mofokow uĝulo mauw mro ye idra ye lakujome, sünda na ilunge kamyoñe sayo sa ĝyojome, sünda se nüna ye uvro gow ije mokofow mauw lyajome.” ");
INSERT INTO hru_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sese i he ñu i trungkoi ye upumko go mim a ye gow yo che, “Ŝüvzüwme se uluhu ye hayo sa a ba ĝyodama seyo se apu ye ha ye ba mütsüdama.” ");
INSERT INTO hru_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","I che, “Am; séŝo ŝüvzüwme i, dju Tawgyew i ñu dzüñe i chew dzüima.” ");
INSERT INTO hru_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Se ŝüpyo upu kyeĝipyo dawñe, i che, “He ñishü yo nüna na maume; na chishew tchünggudru; se ná Yona i chishew í tralye seyo haje chi mashejome. ");
INSERT INTO hru_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yona í küna veduw Ninwe ñetrü go chishew vewma, sünambo nüna üsa ye he ñishü yo nüna na chishew vedujome. ");
INSERT INTO hru_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Müdzavye go nugom niyay djüw se ñetomüdrü ayo nüna nadra gudzuñe, í datrüwñe chejome, hado chemeje i Suleman i ñu dzüjoñe druguw-drulyiw udza go jikuda, sünda holabya he ayo he a Suleman ije dyewfo a du. ");
INSERT INTO hru_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninwe go nüna na Niyay djüw ñetomdrü ye hesalu yo nüna nadra gudzuñe, naso ge truchoaijome; hado chemeje na Yona i ñu tru í dzüñe nadra-nalu muchoagye sünda howe, age Yona ije dyewfo a dume.” ");
INSERT INTO hru_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Dju nüna je bela ge mütrü tchühoñe ĝumŝü ge seyo ñeshü ge mavewme, seŝo mütrü ubo ge dzugo vewme hado chemeje nüna jikui na hohujoñe. ");
INSERT INTO hru_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Baso go mütrü ye bañi ye me, sündada bañi güdrameje, se basso naje vyow müsajome; séŝo se ye maumeje, basso ge je nukuĝujome. ");
INSERT INTO hru_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sündada ufu je ksü-üñi je ksü dañe ĝyowe, se müsaw ye baso duwye nukuĝuañeme. ");
INSERT INTO hru_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sündada baso ye vyow müsazeĝiame, seyo se ichi hangeje manukrumeje, se sündame se vyow na müsajome, süna vyeduw ñeto ge dadawa, se mütrü ye ichi lünaw yo djó müsaw djüiwa.” ");
INSERT INTO hru_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisu i ñu trungkoi ye, djudamje Farisi a ye i che, se nochi ge jiñe ava tsawe; sünda i ñelu ge djemyoñe ava tsajoñe ĝyoag. ");
INSERT INTO hru_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisi na basha go na ava matsalu üshi-upo machew í holyeñe mavyenghua. ");
INSERT INTO hru_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tawgyew i í che, “O Farisi, ba bekasa seyo bela na udru udru go güdrawŝo, séŝo balung ge vyesbiw seyo mauw vyesumokradama. ");
INSERT INTO hru_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Budzu ñiw nawa, dju ñepsü go vye ye dadama, hawa se i ulung go i madaima? ");
INSERT INTO hru_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Am séŝo, ulung go gañ-miĝi duw na chi djüajo dawe, sündameje bábo vyow güdraw lyajome.” ");
INSERT INTO hru_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Se Farisi nawa, djo tui me! Ba pudina ñe sudab yo, seyo vyow ñomñow sheĝe baĝüdo yo ülye ĝü tronguaña djüŝoma, séŝo Niay i seyo Tawgyew i nülvo í mahutroiwa; tsüwbo tsüda hena je dañgudru seyo sena je tratcho. ");
INSERT INTO hru_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisia nawa, djo druge tui me! Djo ñegru ge nugo buĝo uw vye seyo badzaĝ ge ye djó gaga tsüw.” ");
INSERT INTO hru_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Djo tui me! Hado chemeje djo se pelyado nuĝu vedudame, süge nüna na udru ge dügrüñe kahi, se madanghuw nuĝu du cheñe.” ");
INSERT INTO hru_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sündawñe mükyew a ye í che, “Dadrüwa, he ana cheñe ba ñi tchüĝoime.” ");
INSERT INTO hru_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisu che, “Oi shotuko-kunu dakyew nawa, djoje tui me! Djo ana lojemalofiw gañ me, nüna nadrü ge joŝoi seŝo yabó djo djogzütsü a je madadü.” ");
INSERT INTO hru_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Djo je tui! Djo se ñihow truw na nuĝu chiw, dju djo aki-awu na shilyedama. ");
INSERT INTO hru_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sünda: djo truksüw nüna me, seyo djo aki-awu na dalyedaw yo uw vye; hado chemeje na bó ná shidabi sünda djo ná nuĝu í daw. ");
INSERT INTO hru_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Sündada Tawgyew i patsü-sholu je chedame, se no nachi ge ñihow truw seyo shürhaw kiajome, seyo na naĝiyo küña na shijojema seyo küña na daŝe-damejojema. ");
INSERT INTO hru_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Se i ye küña ñihow truw duma naŝü í he druguw-drulyiw í dakülyejobo a fualyedame, vyew na ĝilyedo ye he ñefo ayo nüna nachi yo lajodawe. ");
INSERT INTO hru_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Habil í üŝü yo dalalye Jakaria í shiw kuw se psüĝañe mügañe naksümko ye shiw: no djo umso truime; ichi ĝidoye he ñefo syo shüdo nüna nachi go lajome. ");
INSERT INTO hru_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Shotuko-kunu dakyew djo tui me! Se djo je patsü-sholu veĝiw bo ladaŝome, séŝo djo djoluvyo makakume, seyo kakujoñe dado na dugo vye. ");
INSERT INTO hru_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sündalye i sa yo kahuahuñe, sese shizew-ñuzew nañe seyo Farisi ŝüpyo ifum kase seyo i dagtso-damrhüñe, ha ha ñu bütruluweñe da, se i ŝüpyo ñu ufo bütruluweñe ");
INSERT INTO hru_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","sünda na i ha ñu chehualaima ĝyokrü ĝyo, se umdzu yo ha damje ñu zetruahuw ye kigolajoñe. ");
INSERT INTO hru_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aña a sese hadzaĝ-hadzaĝ dzaw nüna fuguñe, aña ana kuw naĝütchü tcheĝi-lügyeĝi da, se i uvromashü í shürhaw ná che, “Farisi nago loĝãloĝe yo üĝa ĝyojodawe. ");
INSERT INTO hru_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Vyojo haje dümyoñe maveme, madanghujo haje müŝüñe maveme. ");
INSERT INTO hru_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sündada ba ha damje nukuĝuw ge chedo ye, se i müsaw ge dzühujome; seyo ñeĝüñ ulung ge ufu ge ha aŝesa yo chedama, se ye ñelütsü udru go yo trujome.” ");
INSERT INTO hru_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Séŝo no djo trungkoime, nodraw nawa, dju usso i shifidama se na seyo ha madamñefijomme, ná djuĝejo dawe. ");
INSERT INTO hru_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","No djo trumchemjome djo djú ĝejoma, dzüwñe djú chigüje ge lañe djoafima, se í ĝejo dawe; no djo trupangkoitchoimme, se í ĝejodabuwe. ");
INSERT INTO hru_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Hawa ajolya ksü yo sülyisa pom madrüafima? Sedamje Tawgyew i namko ye a ye je makoŝoa. ");
INSERT INTO hru_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bakye go vyow ükyetrü duw naje ngümdzo vedame, sündada: djuĝejo dawe, ba sülyisa na dafowme. ");
INSERT INTO hru_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“No djo chengkoime djudamje no nüna navro ge nó noŝobiñe danghumeje na je nüna üsaw ye je Tawgyew i sorgomuko uvro ge ẽŝobijome. ");
INSERT INTO hru_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Séŝo dju nüna navro ge no hopseĝiahima ije Tawgyew í sorgomuko uvro ye hopseĝiajome.” ");
INSERT INTO hru_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Dju nüna üsaw ütüma mauw truima, i datrudaw í muchoaijome. Séŝo dju ĝulo güdraw ütüma mauw trüima, í datruw í mamuchoijomme.” ");
INSERT INTO hru_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nüna na ba mügaw-ñegru seyo mükyew seyo damikyew navro lakuwñe, ba navro ge ha chemeje ujojema seyo küna chejojema se na djuvengüajodawe. ");
INSERT INTO hru_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Hado chemeje ĝulo güdraw ba sayo sa a ha chejome zedrüjome.” ");
INSERT INTO hru_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Seyo upu go nüna a ye í che, “He dadrüwa, noñuw í awu í bo-luko ná noje hawe chejodawe.” ");
INSERT INTO hru_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","I í che, “Nüna nawa, nó dju niyay djüw seyo baĝüĝiw nüna boña?” ");
INSERT INTO hru_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sünda i í che, “Uw yo ho ĝyojodawe, seyo tsaĝa-laĝaw süna yo basü ĝyojodawe; hado chemeje nüna na shüw ye dju bo-luko duw yo mashüwme.” ");
INSERT INTO hru_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","I í zeĝaw a tru, “Tümbum nugo a í no ge rhamu ŝüpo kakülye. ");
INSERT INTO hru_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sündawñe i ulvyu ge no hadajojemmañe ve, hado chemeje nochi ge bo no dakülyedaw rhamu na vejo buĝo je ñi. ");
INSERT INTO hru_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Sünda i che, ‘no ana dajobabi: no nó ñetchü í tashalyeñe dyew dalajo; sünda no rhamu seyo bo-luko na vyow süge vejo; ");
INSERT INTO hru_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","sünda no ĝulo i chejo, ĝuloa, bachi ge oje ŝüpo üĝalaw kuw bo-luko vewme; ĝyogowe, tsawe, tuwe seyo lüshüw yo ĝyowe.’ ");
INSERT INTO hru_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Seŝo Tawgyew i í che, ‘Chi madnaghuw nüna! He ñegimdo ñegi a ba lutuw ye lutukyoadügyejomme; sündawñe ba küña dashütrüñe vedama, se ye djuchi lyajowa?’ ");
INSERT INTO hru_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ana je nüna duwme dju nudzo ubo bo-luko dashütrüñe ve, sé i Tawgyew iñigzü ge nugo mo.” ");
INSERT INTO hru_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sünda i í shürhaw ná che, “Sündada no djo trungkoime, nudzo shüjo-dujo ubo djuvewe, no ha tsajojemañe; seyo nudzo usso ubo je ha gye-ĝuvo shejojemañe. ");
INSERT INTO hru_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hado chemeje tsaw-tuw í shüw ye, seyo gye-ĝuvo í dyewfo usso yeme. ");
INSERT INTO hru_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pülĝam na hojodawe; na zuje mazuw seyo ñetchü ge rhamu je mapaw; sedamje Tawgyew i ná tsakyewŝo. Bá musu na fow go añe dufowme. ");
INSERT INTO hru_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Djomko ye dju duwa, dju vengaw yo nudzo i shüngkoi ge ganta a ña damje shafijo ye? ");
INSERT INTO hru_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sündada ba imisa fo chiĝa íje madafimeje, hado utro ñu ná lañe vemyoñña? ");
INSERT INTO hru_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Bye go shoba ná hojo dawe, na kündañe shülyima; na chiĝa je madaw chitra je madaw; sedamje no djo chengkoime, Suleman je í küña übadzü gidama, namko ye ana veduw gañ a je magime. ");
INSERT INTO hru_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sündada Tawgyew i no go suso-mütchü namaje yow gye sheida sünda draha ná boti shüw ge joañe, anambo gye-ĝuvo sheñe veihume; Tawgyew ge mesame veksüw nawa, djo künadañe añe masheijowa? ");
INSERT INTO hru_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sünda djo ha tsajojema ha tujojema süna ve djuĝyowe, sünda meaje mavemyow djudajodawe. ");
INSERT INTO hru_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hado chemeje he druguw-drulyiw ayo go vyow tuĝu-tumo na he ana veduw bostu na tchünggudruwme sünda ba Awu danghudame djo he bostu na ŝüpo tsüda cheñe. ");
INSERT INTO hru_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Séŝo ichi ĝadzü i tchüjodawe, sündameje, he bostu naje pajome. ");
INSERT INTO hru_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nüna imisa nawa, djuĝejodawe; hado chemeje ba awu i bá ĝadzü paweñe vedame. ");
INSERT INTO hru_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nudzo ichi fuñ-voñ na draalyeñe tunoajodawe; sündalye nudzo ubo ana dalajodawe, ha ye üme malyajoma, sünda soĝgo ge ana bo-luko dashütrülajo dawe ha ye makaajoma, djutrü iñisa ge tsaksutchüw naje majikujo seyo bulu naje mauw madajo. ");
INSERT INTO hru_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hado chemeje hange bachi bo-luko duma, badrü-balu he süge dujome. ");
INSERT INTO hru_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Djotsü na pyogo vejo dawe, seyo dju mütrü na dzodügyejo dawe. ");
INSERT INTO hru_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sünda djo se kulo na veduw dajo dawe, dju nudzo dadrü í gzü jiw go ke kakujojemañe ĝyokrü ĝyow veduw; i kakuñe ñegüdrüŝü düwñe mekutcho djeñe voa. ");
INSERT INTO hru_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Gaĝüzewe se kulo í, djú dadrüw ye kakuñe madrumuvow hohudama; no djo umso trungkoime, i ütsü ge pyogolañe ava tsajoñe ĝyojo, sünda üñisa jiñe í hoijo. ");
INSERT INTO hru_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","I ñegi ge ülye ksü seyo ülye dzü ñepüñew ge je pakülyew hohumeje, se kulo ye gaĝüzebamme. ");
INSERT INTO hru_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Djo he i danghujo vejo dawe, ñe übraw ye tsaksutchüw na tsaksuw ke jikujoma se í danghubammeje, i pakülye ĝyojobamme, sünda nudzo ñe ge majimyogyejome. ");
INSERT INTO hru_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Baje dashütrü ĝyojodawe; hado chemeje ha homoi ye jikujoñe mavew se homoi ge nüna üsaw jikujome.” ");
INSERT INTO hru_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sündawñe Patras i che, “He Tawgyewwa, ba he zeĝaw ye ñi aka bama mow vyow naje truwma.” ");
INSERT INTO hru_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tawgyew i che, “He veksüw seyo patsü-sholu hokrüw ye djuwa, djuchi dadrüw ye ná tsaw-tuw homai ge djüweñe kulo-kutro boñe ve. ");
INSERT INTO hru_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Se kulo ye gaĝüzeme, djú í dadrüw ye ana dangkoiye hohudama. ");
INSERT INTO hru_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","No djo umso cheime; I í nudzo ichi vyow bo-luko ge zeĝiw vejobamme. ");
INSERT INTO hru_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Séŝo se kulo ye ulu ge ana vemeje, no dadrüw ye üĝalaw ge kakujobañe veñe, sünda kulo seyo kulom na güñe seyo tsañe tuñe tukrañe ĝyomeje. ");
INSERT INTO hru_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Se kulo i dadrüw ye ana ñeto a ye, i madanghuw ñeto a ye, i í maĝyokrüngkoi ye, seyo i madanghuw homai ye, kakujo sündañe í sojai djüñe í usu maw ge ngüañe vejo. ");
INSERT INTO hru_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Seyo se kulo dju nudzo dadrüw í véw í danghuñe, seyo madashütrüvoñe seyo í vew kuw ge makasabammeje, ŝüpo tsalajobamme. ");
INSERT INTO hru_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Séŝo dju madanghuñe ĝüw tsalajo chiĝa dadama se ye me tsalajobame, sündada dju añe djüdama, í añe prüjome; seyo dju ŝüpo boñe vedame, ichigo añe lajome. ");
INSERT INTO hru_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“No druguw-drulyiw ge mi dahow kakülyahume; sünda ha tsüdawa chemeje hesalu mi dzomzoaweñe! ");
INSERT INTO hru_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","No baptisma lajome; sünda no malamdolu kuw no küna mauw ñiku-ñisüw ge ĝyojojema! ");
INSERT INTO hru_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ba vedaw ye no he druguw-drulyiw ge ĝüdzüw kakudañe vedama? No ba chengkoime; mome, no dabraĝiahuw kakülyahume. ");
INSERT INTO hru_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hado chemeje hesalu yo ñe ge nüna pom naĝütchü ge magaĝijome, dzü ye ksü üdra seyo ksü ye dzü üdra. ");
INSERT INTO hru_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Awu ye saw üdra, seyo saw ye awu üdra maveĝijome; añ ye sam üdra seyo sam ye añ üdra, apye ye safu üdra, seyo safu apye üdra maveĝijome.” ");
INSERT INTO hru_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sünda i upu naje che, “Mumu íje druguw go kalyiw hohumeje, djeañe ñedzü ŝüjo chew; sünda süna dabaibi. ");
INSERT INTO hru_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sünda müdza gow ñedzü lyiw hohuñe cheibi, ñedzü shüw lyijome, sünda süna dabyo-daĝyotcho. ");
INSERT INTO hru_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Loĝa-loĝe nüna nawa, djo ñedzüñe no naksü í utroñe danghudameje, hado he shüw-duw ubo kündañe madanghufia?” ");
INSERT INTO hru_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ba hesalu ba nudzo yo hado ñu mavelafia? ");
INSERT INTO hru_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ba bá fodaw nüna üdra mukow ichi ge jingko ye, ĝabo ge ñu chegüdrajo dawe, momeje ba í mukow ichi ge ŝüñe lajikyeñeme, sünda mukow i bá shipashi nagzü ge djüñe seyo shipashi na bá pache ge shüñeme. ");
INSERT INTO hru_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","No djo trungkoime, ba ajolya ajolya dañe magimdzoalu kuw, ba makahuafijome.” ");
INSERT INTO hru_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nüna üchea sayo sa a djeku, seyo Jisu í Galiliyo nabo go ñu dzüngkoi, djuŝü í Pilatus i í küĝüw ge djüasadamma. ");
INSERT INTO hru_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","He í dzühuñe Jisu i na che, “Djo ana veima, he Galili na utro Galili ná lalofoñe, hado chemeje nadru ge ana veduw ñiku-ñisüw djüda che? ");
INSERT INTO hru_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","No djo trungkoime, mowme; séŝo djo djüdrü djolu mavetülümeje djo vyow he ñom yo mütratsüjobamme. ");
INSERT INTO hru_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mow djo ana vedama, Shilom ge nüna ĝütrü ŝügzü djudrü ge post gaañe trüalyañe dzüdama: na vyow Yarusalem ge küña tuĝu-tumo shütsüdama ná lalofoma? ");
INSERT INTO hru_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","No djo trungkoime, mowme; séŝo djo djüdrü djolu mavetülümeje djo vyow he ñom yo mütratsüjobamme.” ");
INSERT INTO hru_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sünda i he zeĝaw ije tru, “Djuchidamje anggur vi ge lufuje üyañ a zuñe veda: i sayo sa a sheje thcüw jikuda, sé í mapa. ");
INSERT INTO hru_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sünda i vi ĝyokrüw nüna i che, ‘Howe oje dzü gomdo no he lufuje üyañ go sheje tchüw jikunggudru, sé keje mapa, he í chepyojo dawe, i hado no í ĝyokrügejowa?’ ");
INSERT INTO hru_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","I í ana che, dadrüwa, í oje a kuw ĝyokrüluwe; no üdza üdza ge no chiguĝuañe nobi sujome. ");
INSERT INTO hru_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sündañe, drawha ge sheje jelaimeje uw; se molaimeje chepyojo daŝobe.” ");
INSERT INTO hru_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ĝyogow ñeto sehu Jisu küĝüw ñegru a ye truñe ĝyoda. ");
INSERT INTO hru_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Süge mim a du, dju oje ĝütrü ŝügzügomdo ksuw kaw mütü a kamyoda, sünda i utsubo kuw lyada, sünda i keje gudow magudzufiwbi. ");
INSERT INTO hru_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisu i hohuñe balayeñe, che, “O mimya, ba bá hamalyiw yo kahuajemme.” ");
INSERT INTO hru_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sünda i ügzü í udru ge ve, sünda i djeañe gudow lyajebi, sünda Tawgyew í trokülyejebi. ");
INSERT INTO hru_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hado chemeje Jisu i ĝyogow ñeto sehu dagyoda, mügaw na seyo nugobraw na nüna na che, “Ñegi ĝe duw me, sa yo sa chiĝa dajo dawe, seyo se ñeto ye jikuñe dagyojo dabuwe; séŝo Sabat ñeto ge djudawe.” ");
INSERT INTO hru_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","He í dzühulye Tawgyew i che, “Loĝa-loĝe nüna nawa, ĝyogow ñeto sehu djo djó nudzo fulhu seyo giĝá na ñe tashalyeñe hu tuw lañe majikewma? ");
INSERT INTO hru_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Seyo ha ye madafijo cheña, he mim Abraham üsam djuso ge oje ĝütrü ŝügzügomdo mütü ye pyogodama, se í ĝyogow ñeto ye vogodaw i kihuajo?” ");
INSERT INTO hru_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ná he ñu na chewñe, í ubo mauw dai na ñimtchüñ lyatsü, seyo vyow upu na se uw chiĝa dadaw ubo lüshütsü. ");
INSERT INTO hru_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sünda Jisu í chetcho, “Tawgyew í ĝadzü dju veduda? Seyo no í ha shipyew üdra djüsejowa? ");
INSERT INTO hru_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I pemdu üsü a veduwbame, djú nüna na lañe ná vi ge trawma; sünda i shülyiñe shoñ lya; sünda ñedzü go musu na ufotsa ge guñe ĝyow.” ");
INSERT INTO hru_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","I sünda chetcho, “No Tawgyew í ĝadzü í dju vedu dañe vejowa? ");
INSERT INTO hru_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I pa vedudame, djú mim a ye lañe oje ulumo tola dzü ge gülüŝüĝia, sünda ñu-ñuñe oje ulumo ye pa lya.” ");
INSERT INTO hru_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","I ñetrü-ñetrü jiñe dadrüshü Yarusalem ge ji. ");
INSERT INTO hru_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sünda djudamje a í che, “He Tawgyewa, nüna mesame basüafijobama?” I í che, ");
INSERT INTO hru_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ñegüdrüŝü imisa yo jimyojodawe, hado chemeje no djo trungkoime, ŝüpo nüna na jimyojoñe dajome, se majimyofijome. ");
INSERT INTO hru_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ñe ubrow gudzulyiñe ñegüdrüŝü dugoahuñe, seyo ba ñepsü ge gudzuñe ñegüdrüŝü düñe che, ‘He Tawgyewwa, nobo voijodawe,’ sünda i sügow no ba madanghume, ha hanggowa? ");
INSERT INTO hru_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sündawñe ba chejo, ‘No ba how ge tsa-tuw sünda ba ñi bodzaĝ ge dadrüda.’ ");
INSERT INTO hru_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Séŝo i chejo, no djo chengkoime, ‘No madanghume djo hanggoma. Mütü chiĝa daw nüna nawa, djo vyow no yo üĝa ĝyojodawe.’ ");
INSERT INTO hru_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Süge ksew seyo utu trashügrüjome, ba Abraham, Isahak seyo Yakub seyo vyow ñihow truw ná Tawgyew ge ĝadzü ge ĝyodaw hohuñe nudzo í ñepsü kahuahuw hohujome. ");
INSERT INTO hru_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sünda druguw seyo drulyiw; tchüsa seyo müdza go nüna na jikuñe Tawgyew i ñetrüĝüfo ge dusejome. ");
INSERT INTO hru_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","He i danghulajo dawe, küña ná fum ge duma, na uvro ge dujome, seyo küña na uvro ge duma, na fum ge dujome.” ");
INSERT INTO hru_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sa yo sa küña Farisi na jikuñe í chejea, “Ayogo kahuañe kajo dawe; hado chemeje Herodes í ba shijoñe vedame.” ");
INSERT INTO hru_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","I ná che, “Kañe se ŝelü í trujodawe, howe, no yow je seyo draha je uĝulo na lahuañe seyo usso naw na dagyojolume, sünda ñegi dzü ye no chiĝa damdzoajome. ");
INSERT INTO hru_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sedamje no yow, draha seyo pülha kuw jijome, hado chemeje dju ñihow truw na Yarusalem í ñepsü ge madzüfijome. ");
INSERT INTO hru_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“He Yarusalem! He Yarusalem! Ba se ñihow truw ná shiiye, seyo bachi ge dju kiima ná kunu yo trümoahiye; no ana veduw küña tsüda, joñi i üsa ná utupro ulung ge küna tchelaima, sünambo noje basa ná lakyeĝiajoñe daw, sé ba he í matsü. ");
INSERT INTO hru_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Howe, bañe babo kabra-kasaĝijjome, sünda no djo chengkoime; ba ‘Ná üdrü-ulu yo uw cheime, se nüna ye gaĝüzü dume dju Tawgyew iñiñi yo lañe kakuima,’ machemdolu ba nó keje mahohujome.” ");
INSERT INTO hru_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sünda í ĝyogow ñeto sehu djudamje Farisi nágo nugo a i ñe ge odje tsaw ji: sünda ná í usu yo hopasa. ");
INSERT INTO hru_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Süge í veduw muhu a du, dju usso dalfuñe nada. ");
INSERT INTO hru_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisu í Farisi seyo shotuko-kunu damivro ná che, “ĝyogow ñeto ge dagyomeje ujo ma mow ma?” ");
INSERT INTO hru_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sé na madañda ĝyo. Sündawñe Jisu i í ügzü kiñe dagyo, sünda kadügye. Sünda i í ügzü kidüñe dagyo, sünda kadügye. ");
INSERT INTO hru_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sünda i ná che, “Djongko ye dju duwa, djusa seyo fulhu ye kalü ulung ge gamyoa sünda ĝyogow ñeto ye kutcho malahuajo.” ");
INSERT INTO hru_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Sé ná he ñu ge haje machefibi. ");
INSERT INTO hru_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","I hobanda, tumona baladaw na uw uw buĝo tsatchüñe lai sünda í se ná hoñe zeĝaw ze, ");
INSERT INTO hru_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Djuma djo ĝü ge balai ye, buĝo dyew tsatchüñe djuĝyojodawe, asha baje dyewfo tumona baw je dufijome. ");
INSERT INTO hru_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Sünda dju ije seyo baje badama, bá jikuñe ana chemeje, ‘Í buĝo djüjo dawe,’ sündawñe ba ñimtchüñ lyañe ülafo buĝo ge ĝyow dujobamme. ");
INSERT INTO hru_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sé bá bawñe, ülafo buĝo ge jiñe ĝyojo dawe, bá badaw nüna ye jikuwñe, bá ana che ‘Drawa, uvro ge kalyiñe ĝyoa,’ sündawñe badra a ĝyosadaw navro ge udru kalyijome. ");
INSERT INTO hru_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hado chemeje dju nudzo yo dyew dalaima, se ye imisa lyajome; seyo dju nudzó í imisa dalaima, se ye dyew lyajome.” ");
INSERT INTO hru_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sündawñe Jisu i í baladaw naje che, “Djo ñeto ge damje ñegi ge damje ava tsaw ge, nudzo draw, ayo-ñuw, ñeŝü seyo nugo na djubajodawe, ana dañeme, naje djo balañe daĝuñeme. ");
INSERT INTO hru_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sé ba ava tsakelai ge sapse, hamalyiw, üshilyew seyo iñiĝew ná bajo dawe. ");
INSERT INTO hru_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sündawñe ba gaĝüzebamme, hado chemeje nachi ge djó djüjo haje ñiwme, séŝo djó ná güdraw yo üshükülyejo go küĝüijome.” ");
INSERT INTO hru_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Üdra ava tsasangkoi go nüna a ye he ñu ná dzühulyeñe che, “Gaĝüze nadra dujome, dju Tawgyew í ĝadzü ge odje tsaima.” ");
INSERT INTO hru_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ná i che, “Djudamje nüna a ye ava dyew tsakeñe seyo sünda ŝüpo ná ba. ");
INSERT INTO hru_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tsaw-tuw dafihuñe, i í kulo ná tumona baladaw ná cheñe ki, ‘Age djebe; tsaw-tuw dafiadamme.’ ");
INSERT INTO hru_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sé vyow na chetsü, ‘uvro go ye í che, no vi a prülawme, sünda no se í hojo dume; no ba chengkoime, no maf daijo dawe.’ ");
INSERT INTO hru_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Utro a ye che, ‘No fulhu fulshi pom lawme, sünda no he na dañe how jingkoime; no ba chengkoime, no maf daijo dawe.’ ");
INSERT INTO hru_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sünda a ye che, ‘No gzü dawme, sündada no majikufijome.’ ");
INSERT INTO hru_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Se kulo ye jekuñe i ñe übraw í he ñu ná trutsü. Sündawñe se ñe ubraw ye lusuvyulalye í kulo í che, ‘ñetrü go bozaĝ seyo ĝabo ge kutcho jeñe sapse, kiĝi, üshilyew seyo iñiĝew ná age lañe kakuwe.’ ");
INSERT INTO hru_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kulo ye che, ‘O übrawa, ba küna chedama, süna damme; sé yaje buĝo ufo dulumme.’ ");
INSERT INTO hru_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Übraw ye kulo í che, ‘Ĝabo ge seyo füta duw ge djeñe nüna ná künadamje lañe kakujodawe sündameje noñe gujome.’ ");
INSERT INTO hru_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Hado chemeje no djó trungkoime, se tumona badaw ná no tsaw-tuw í tsapüñeje matsapüñejome.” ");
INSERT INTO hru_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sünda upu na ufum kasawñe, sünda Jisu i fum ge tchoñe ná che. ");
INSERT INTO hru_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Djudamje nochi ge jikuñe, seyo nudzo awu, añ, ufum, agü, ñu seyo ñum seyo nudzo shüw-duw naje mahosübammeje, í no shürhaw mowme; ");
INSERT INTO hru_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Seyo dju nudzo shokru íje magilama; sünda nofum makameje; se je no shürhaw madafijome.” ");
INSERT INTO hru_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Djomko ye dju post dzuĝoñdama, seyo uvromsahü bo küña kajoma, damdzojo kuw nochi ge duŝoma ñima mahow? ");
INSERT INTO hru_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ana dawñe, i shobo dzugoñe ñekru makrufiwñe, sündawñe hovow nüna na vyow í tchüĝojoŝo, ");
INSERT INTO hru_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘He nüna ye damyowbo damyodaŝowa, sé madamdzofiwa?’ ");
INSERT INTO hru_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mo dju ñubyu duwa, utro ñubyu nadra tumo daw jiw, sünda uvromashü ĝyoñe mavemchevzüme, se hadza büsha kulo lañe nodrü ge tujovodawye no hadza ĝü lañe üdra daĝufijoŝoma mo mowma? ");
INSERT INTO hru_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mowmeje üĝa ĝyodamje, mukow kiñe ñu ĝüdzüagyefijo. ");
INSERT INTO hru_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ana veduw djo nudzo ichi küña duma ná nobo matrafimeje, se ye no shürhaw malyafijome. ");
INSERT INTO hru_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ĝu bo udame, sé ĝu tsamĝüw lyameje, se í ha yo ĝu lüw dajowa. ");
INSERT INTO hru_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Se ye no ubo je seyo nobi ubo je chiĝa ge makakujomme: se í nüna na ñepsü ge joajohubamme. Djuchi ge dzüjo ufu duma dzülasajodawe.” ");
INSERT INTO hru_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vyow patso-law na seyo lalo ubraw ná ichi ge dzüw jikuw. ");
INSERT INTO hru_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Seyo Farisi na seyo shizew-ñuzew na dubyoĝunguñe che, “I bó lalo ubraw ná tüvañe seyo nadra ava je tsasai.” ");
INSERT INTO hru_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sündawñe i ná he zeĝaw í tru: ");
INSERT INTO hru_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Djongko ye djuwa djuchi fugulu fuĝua duma, sünda namko sa a moahuñe se sütü ĝütrü sütü ná nodo ge tralye, se a moadaw í matchülalu kuw tchü ĝyo? ");
INSERT INTO hru_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sünda tchülawñe, i ŝüpo lüshüw upostu ge trütalañe ka. ");
INSERT INTO hru_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Sünda ñe ge kakuñe draw seyo ñeŝü na bakeĝiañe che, ‘Nodra lüshüsawe, hado chemeje nochi fugulu moadaw ye tchüladamme.’ ");
INSERT INTO hru_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","No djo truime; ana veduw ñedzü ge je lalo a dju vyegudoladama ubo lüshüjome, küñambo sütüĝütrü sütü nüna ĝüdraw dju ulu mavegudojo duma nabo madama. ");
INSERT INTO hru_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ana mim dju dujowa, djuchi ge bosüñ ĝü duw, sünda namko ye bosüñ a moadabi; sündawñe i matchü uw mütrü tchühoñe seyo ñe na süñe, dju uw yo matchüjowa? ");
INSERT INTO hru_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sünda tchülawñe, i üdram na seyo ñeŝü ná balañe che, nodra lüshü-lübasawe nochi bosüñ moadaw ye tchüladamme. ");
INSERT INTO hru_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","No djo truime; ana veduw, lalo nüna a í ulu vyegudolaw ge Tawgyew í sorgomuko ná ana lüshüjome.” ");
INSERT INTO hru_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sünda Jisu i che, “Nüna a ichi saw ksü duw. ");
INSERT INTO hru_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Naksümko ye kiĝiw ye uyow í che ‘Awa, nobo go bo-luko duw ye, no djüjo dawe.’ I í ichi bo-luko na haĝiag. ");
INSERT INTO hru_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sünda ñegi añe makulu fum ye üsaw kiĝiw ye vyow dashütrü lalyeñe ñetrü üĝa a ge katrükralye, sünda süge bo-luko duw na vyow tsaĝudroamdzoag. ");
INSERT INTO hru_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","I vyow damdzoahuñe, se ñetrü ge nokrow kaku, sünda i usso ufobüla lya. ");
INSERT INTO hru_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sünda i se ñetrü go nüna a ichi ji, se nüna ye í í vi ge vo na ava gyew ki. ");
INSERT INTO hru_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sünda i ve uluhu í gudugyejoñe se votsa pago go vo na tsa; hado chemeje í djuje haje madjü. ");
INSERT INTO hru_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Í vepalawñe, sünda che, ‘No awu ichi küña vi daw ná tsaw-tuw añe paw, seyo no age luhuŝüw yo dzüangkoibi. ");
INSERT INTO hru_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","No gudzulyiñe no awu ichi kañe í chejo, awa no ñedzüñe ba how ge lalo datroadaŝomme. ");
INSERT INTO hru_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","No basaw chejo haje matramme, no ba vi daw a veduw vejodawe.’” ");
INSERT INTO hru_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Sünda i gudzulyiñe, i awu ichi ge ji: uĝa gudzudalu sa a uyow i í hoñe nülvo veag, sünda gyojeñe í krumogo lag, seyo ŝüpo chuma tsa. ");
INSERT INTO hru_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Üsaw ye í che, ‘Awa, no ñedzü í hovow seyo ba how ye lalo dadamme; sünda hesalu basaw chejo go ñimme.’ ");
INSERT INTO hru_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sé uyow i í kulo ná che, ‘Kutcho shedra uw yo je uw lañe í sheijodawe, sünda ügzütsü ge gütsülye lyeijo dawe, seyo ishi ge shita duijo dawe, ");
INSERT INTO hru_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sünda rhano a dajo dawe, sünda me ñi tsa-tuñe lüshüfijobi. ");
INSERT INTO hru_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hado chemeje nosaw ye dzüwmme, sünda üshükülyedamme: moahumme, hesalu tchülatchodamme.’ Sünda í lüshü-lübaw da.” ");
INSERT INTO hru_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Sé üsaw nugow ye vi ge du. Sünda í kañe ñe kakulai ye, i nuĝuw dagruw seyo ñuksu daw dzühu. ");
INSERT INTO hru_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sünda i kulo a í balañe dzü, ‘He ha dangkoiya?’ ");
INSERT INTO hru_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","I í che, ‘Ba ñuw kakudamme, sünda ba awu i tsa-tuw dyew vedame, hado chemeje i í nüna uw hohuda.’” ");
INSERT INTO hru_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Saw nugow ye he í dzühulyeñe i lusuvyumfoag seyo ñe ulung makamyoĝoñ lyag: séŝo uyow i ñepse ge jihuañe í nü. ");
INSERT INTO hru_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","I uyo i che, ‘Howe; no aña ojegomdo bá ĝaksüñe ĝyow, sünda ba chew keje madzügaahuw, nodraw nadra lüshü-lübaw dajo, ba no yow kuw küŝüsa üsa adamje madjülu. ");
INSERT INTO hru_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Séŝo he basaw ye ba bo-luko ná utroñiw mim nadru ge djoañe kakuwñe, ba ubo aña dyew tsaw-tuw dañe gyew.’ ");
INSERT INTO hru_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","I í che, ‘Sawwa, ba shüwduw nodra dusaw; seyo nochi ha duma se vyow bachibamme. ");
INSERT INTO hru_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Séŝo hesalu lüshü-lübajodume hado chemeje he ba ñuw ye dzüñe üshükülyetchodabi; moadabi, se hesalu tchülatchodabi.’” ");
INSERT INTO hru_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sünda Jisu je í shürhaw ná che, “Nugo a ichi ge hokrüĝiw a duwme, sünda nüna na i howye se hokrüw í i bo-luko ná tsaĝudroahime cheñe usso ge trutchoañe ve. ");
INSERT INTO hru_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sünda nugo ye í balañe che, ‘He hawa no babo go ñu dzühuiye? Ba hokrüŝo cheñe shewe; momeje ba hokrüĝiw ge maĝyofijome.’ ");
INSERT INTO hru_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sündawñe hokrüĝiw ye vemchepüñe, ‘Hesalu no hadajobya? Hado chemeje no übraw ye hokrüĝiw go no lahuangkoibi: noje no machifi; seyo no tsatuĝujoje ŝüpo ñimtchüñ vei. ");
INSERT INTO hru_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","No danghudaba no ha dajoma: nó hokrüĝiw go lahuahuwñe nüna na nó nañe ge lajo.’ ");
INSERT INTO hru_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Sünda i übraw i chi gudzüdaw ná a a balañe dzüpüñe, no ubraw ichi ge ba küña dojo duwa? ");
INSERT INTO hru_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","I che, ‘Fuĝua tsow psüw tel du,’ sünda i í che, ba kutcho ĝyoañe kako ge pomĝü ĝijo dawe. ");
INSERT INTO hru_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sünda i utro a í dzütcho, ‘Bachi küña dojo duwa?’ I che, ‘Pu ulumo fuĝua tsow dume,’ sündawñe i í che, ‘Bá kako lañe ŝügzüĝü ĝijo dawe.’” ");
INSERT INTO hru_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Übraw ye se machiñiw hokrüĝiw í tro, hado chemeje i budzu yo chiĝa dadabi; hado chemeje he druguw-drulyiw go nüna na ná ñeto go nüna nadra chiĝa dasaw ge, müsaw go nüna ná fow budzu du. ");
INSERT INTO hru_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sünda no djo cheime, mauw go bo yo ba nudzo ubo üdra dalajo dawe; hado chemeje i kaahuñe, bá na shüwa-shüw lüshüw ge lamyosajo. ");
INSERT INTO hru_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Dju imisa yo je imisa ge usuima, ná añe ge je usujobamme: seyo dju imisa yo je imisa ge usu mowma: se na añe ge je usu mojome. ");
INSERT INTO hru_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sündada ba he druguw-drulyiw ayo bo-luko ge usu mowbammeje, bo umso dju djüjowa? ");
INSERT INTO hru_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sünda ba tuĝuda-ĝuvodzü i bo-luko ge je usu mowbammeje, ha ye bachi ma, se í dju djüjowa?” ");
INSERT INTO hru_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Dju kulo ye je übraw ksü í maĝaksüfijome hado chemeje i a í mahoĝoñ dajo seyo a í nülvo dajome; mome a udra gaaĝijo seyo a üdra magaĝijo: ba Tawgyewñe bo-luko naksü í maĝaksüfijome.” ");
INSERT INTO hru_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi na, dju tsaĝotüdama, he na dzühulyeñe Jisu í maw-uw zekülye. ");
INSERT INTO hru_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","I ná che, “Djobó nüna na how ge uw dañe she, séŝo Tawgyew í djodru djolu ná danghuwme, hado chemeje ha gañ ye nünan na how ge dyew dama, se ye Tawgyew i iñigzü ge imisame.” ");
INSERT INTO hru_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yohañ í kakuw kuw, shotuko-kunu seyo ñihow truw naje ná chiĝa daw. Sehu ñetogomdo Tawgyew i ñetrüĝüfo go shi-ñu truñe kaw, sünda vyow nüna na süna datsü. ");
INSERT INTO hru_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ñedzüñe no naksü í kabraĝiahu ye shotuko ütra a yo lyajobame. ");
INSERT INTO hru_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Dju nudzo ufum udra braĝilyeñe utro nadra gzü daima, se na lalo dawme, seyo dju braĝiñe ĝyodaw mim í gzü daima se ye lalo dawme. ");
INSERT INTO hru_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Nugo nüna a duw dju djüw rong seyo gye uw shewma, seyo shüwa-duwa lüshü-lübaw dañe ĝyonggudruw. ");
INSERT INTO hru_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sünda Lajar iñiñ yo sapse seyo tsadu yo guñe í molgi ütrü toi tralye. ");
INSERT INTO hru_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sünda í vew, nugo í tsamyew djoadaw yo uluhu í tsaŝelajo; momeje ŝulyo na je í tsadu í kañe tsalowba. ");
INSERT INTO hru_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sünda se sapse ye dzütrükralye, sünda sorgomuko na í Abraham ichi laku. Seyo nugo ye je dzüdañe zuadabi, ");
INSERT INTO hru_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sünda noĝu üŝü ge ŝüpo naw yo iñi voañe üĝa go hobanda, Lajar í Abraham í udru ge ĝgyodaw hohu. ");
INSERT INTO hru_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sünda i ĝuksuñe che, ‘He Awa Abrahamya, no nülvo veñe, Lajar í kiñe, ügzütsü üdza ge hu pagzüñe nozelbüla í ngüadügyejo dawe, hado chemeje no he mi ulbu dzongkoige dzahiimme.’ ");
INSERT INTO hru_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Séŝo Abraham i che, ‘Sawwa vehujodawe, ba bá shülye ge gye-ĝuvo uw shehulyewme, sünambo Lajar i gye-ĝuvo mauw, seŝo i hesalu age güdzüw pangkoimme, sünda ba namoahibi. ");
INSERT INTO hru_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Sünda he ñu na traañe no seyo ba, ñiksüngko ye ĝo dyam a dzühadame, ago dju bachi ge jilaĝoñ dama, na majilafijomme, seyo sügo dju age nochi ge jikuĝoñdama na majikufijomme.’ ");
INSERT INTO hru_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Lajar i che, ‘He awa, no ba chengkoime, ba no awu iñe ge kiyajo dawe, ");
INSERT INTO hru_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Hado chemeje no ñu pom duwlume, i na hovrow ge he ñu na trume ujome, mowmeje na he anambo ñiku-ñisüw no ge kakuñeme.’ ");
INSERT INTO hru_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham i í che, ‘Nachi ge Musa seyo ñihow truw ná kako duwbase, na se í chew büdzüda.’ ");
INSERT INTO hru_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","I che, ‘Awu Abrahamya, mowme; nüna dzüw a nachi ge jikülyameje, na nadrü-nalu vyegudoĝijome.’ ");
INSERT INTO hru_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","I í che, ‘Na Musa seyo ñihow truw na chew maje madzübi se í, nüna dzüw namko yo djudam üshükülyeñe jiadamje, na madzüjomme.’” ");
INSERT INTO hru_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sünda Jisu i í shürhaw ná che, “He ye umsome ha ñu ye lalo yo ma, se ye kakujome, séŝo se nüna í lalome dju yo kakuima. ");
INSERT INTO hru_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dju he ĝato kunu namko ye djudamje a í dügaima, ibo shedra psüm yo udum ge pyogolyeñe, huĝi ge djoahuye ufojobamme. ");
INSERT INTO hru_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Vemcheñe ĝyojodawe; bañuw datrulaimeje, zehajodawe, seyo vepalaimeje í muchoaijo dawe. ");
INSERT INTO hru_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Í ahua ye ülye mro datrudamje bachi ge ülye mro jikuñe che, no datrudaŝomme, sündawñe ba í datrudaw í muchoaijo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sündawñe í shürhaw na Tawgyew i che, “Ñí veksüw í damñeijo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Prabu i che, “Bachi ge pemdu üsü ütraña kuwdamje veksüw dumeje, ba he kumtchü iyañ í ükrügomdo taprülañe huĝi ge shüwe chejo, sündameje i ba chew dzüjo. ");
INSERT INTO hru_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Sé djomko ye ana dju chejowa, dju kulo ye no chi momeje fugulu ná saw, sünda i vi go kakuwñe, sünda í che, ‘Kutcho age jeñe ĝyoñe ava tsabe?’ ");
INSERT INTO hru_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Haña i ná machejoma, no ava dashütrübe: no tsangko tungkolui kuw toi baŝümpe í kidzagolalyeñe no hoiwe; sünda se fum ye baje tsa-tuwe. ");
INSERT INTO hru_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Haña i se kulo í ulu yo vejoma, hado chemej i í dügyedaw chiĝa í aka dabada? ");
INSERT INTO hru_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anambo ba je, se vyow chiĝa dügyedaw ná damdzoahuñe, baje chewe, ‘Ñi machiñiw kulome; ñi ha dasajo duma se í aka dabadame.’” ");
INSERT INTO hru_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sünda ana da, Jisu Yarusalem jiw ge Samariañe Galili ñetrü yo jipseañe ji. ");
INSERT INTO hru_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Sünda ñetrü a ge jimyongkoi ge í südzüm ĝü ĝoĝo nadaw na tüva, dju na üĝa gudzudama. ");
INSERT INTO hru_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Sünda i üĝa ge gudzüñe, gó yo che, “He Jisu, he dadrüwa, no nülvojo dawe!” ");
INSERT INTO hru_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisu i í hoñe che, “Jebe; sünda bá nudzo í mügaw ná shejo dawe.” Seyo kabyo-kaĝyowñe güdrajebi. ");
INSERT INTO hru_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sündawñe namko yo a ye hoñe dagyolagdabi, gow yo Tawgyew í troñe katrükralye. ");
INSERT INTO hru_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Seyo Jisu ishitrüge gaañe ukrumro yo ishi ge drüñe, ulvyu yo uw che; sünda í nüna uw. ");
INSERT INTO hru_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","He íbo Jisu i che, “Haña na ĝü güdraw malyama, nameje se sütü ye hanga? ");
INSERT INTO hru_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Haña he tuĝuda-ĝuvodzü í tralyeñe dju ñimma Tawgyew í trojo?” ");
INSERT INTO hru_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sündawñe i í che, “Gudzuñe kabi; ba veksüw ye bá dagyodamme.” ");
INSERT INTO hru_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi namko yo a í Tawgyew í ĝadzü ke kakülyajowa che dzüñe, Jisu ná che, “Tawgyew í ĝadzü ana holaw dañe makakülyajome.” ");
INSERT INTO hru_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sünda nüna naje ana machejome, age howe, age dume, süge dume. Hado chemeje, Tawgyew í ĝadzü djumko ye dume. ");
INSERT INTO hru_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sündawñe i shürhaw ná che, “Sé ñeto je kakujome, hai ba nüna üsaw í hoĝoñiw dzüajo, sé mahohujome. ");
INSERT INTO hru_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nüna na ba chejome, ‘Howe, süge dume!’ Mome ‘Howe age dume!’ Séŝo ba djujejo dawe sünda nafum je djudajo dawe. ");
INSERT INTO hru_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hado chemeje ñedzü-lüĝaw ye ñedzü üdza a yo utro üdza ge kuw müsakumbo, nüna üsaw ye je í ñeto kuwñe kakülyejoŝome. ");
INSERT INTO hru_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Séŝo uvromashü i ŝüpo ñiku-ñisüw gilajome, seyo he shülyiw yo nüna na í matsüñe chejome. ");
INSERT INTO hru_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nuha i ñeto ge küna dadama, sünambo nüna üsaw i ñeto ge je dajome. ");
INSERT INTO hru_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nuha i lü ulung ge magyomyolu kuw, nüna na tsa-tu ĝyo, seyo namko ye gzü dañe ĝyo; sündawñe hulüŝü kaküñe vyow mauw damdzoa. ");
INSERT INTO hru_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Seyo Lut i ñeto ge dambo veduw, nüna tsa-tuñe bumdzu daĝiw, shobro zuñe seo ñe daw. ");
INSERT INTO hru_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Séŝo ha ñeto Lut í Sadom ge kadama, sehu ñeto ñedzü go mi seyo ecid ŝükülyañe vyow mauw damdzoag. ");
INSERT INTO hru_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nüna üsaw í kakülyahu ge je ana dajobamme.” ");
INSERT INTO hru_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Sehu ñeto, dju ñelütsü ge duma; seyo na gañ ñe ulung ge du, na se na law ulung ge djukamyowe, sünda sünambo dju vi ge duma na fum ge djukawe. ");
INSERT INTO hru_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lut ufum í vehujodawe! ");
INSERT INTO hru_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dju nudzo í ĝaksüjoñe veima na maĝaksüfijome, seyo dju nudzo shüw í maĝaksüfima na basüjome. ");
INSERT INTO hru_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","No djo trungkoime, se ñegi nüna ksü buĝo a ye üŝa dujome, a í latrayemjomme, seyo utro a í traalyjome. ");
INSERT INTO hru_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mim ksü ye ĝato üŝa ĝüjome, a í latrayejo, a í traayejome. ");
INSERT INTO hru_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nüna ksü vi ge dujome, a í latrayejo seyo a í traayejome.” ");
INSERT INTO hru_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","He ná dzühuyeñe na í dzü, “He Tawgyewwa he na hai dajowa?” I ná che, “Hai ñimo duma, süge kurkukiñ dujome.” ");
INSERT INTO hru_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sünda Jisu i ná he ubo go zeĝaw a trulyeñe udrü-ulu magaada, mamuduw küĝüweñe che: ");
INSERT INTO hru_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Hange damje ñetrü a ye mukow a ĝyow; dju Tawgyew ije maĝew seyo nüna nabo je mavew. ");
INSERT INTO hru_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sünda se ñetrü ye müjem je a ĝyow: dju ichi ge jikunggudruñe í chenggudru, ‘No insaf djüiyeñe nobo ĝaksüiijodawe.’ ");
INSERT INTO hru_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","I üĝaluw kuw madzü séŝo fum ye ulu ge vepüñeñe che, ‘No Tawgyew ije maĝew, seyo nüna nabo je mavetunow; ");
INSERT INTO hru_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Sedamje he müjem ye no matraa, sündada ubo insaf djüijo, mowmeje i nochi ge jikunggudruñe no ĝüdzüw maĝodügyejo.’” ");
INSERT INTO hru_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tawgyew i che, “Dzüwe, he magüdraw mukow ye ha cheima? ");
INSERT INTO hru_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nameje: haña Tawgyew i í nüna basü ladaw ná mamutchoaijoma, dju ñegiw-ñetow í küĝüñe ĝyowma; seyo i ná üĝaluw vejoma? ");
INSERT INTO hru_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","No djo chengkoime, i mekutcho ná mutchoijome; sé nüna üsaw kakülyahuñe, i he druguw-drulyiw í umso vefijosoma?” ");
INSERT INTO hru_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Seyo Jisu i shürhaw na dju nudzo í güdrawñe veksüw veima, sünda utro na mauw daima ná ana zeĝaw che: ");
INSERT INTO hru_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nüna ksü ñegru ge küĝüw ji; a ye Farisi seyo a ye patso-law nüna. ");
INSERT INTO hru_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi i gudzulyiñe üdrü-ulu ge ana küĝü, ‘He Tawgyewwa no ba ulu yo uw cheime, no utro nüna na dambo tsaksu-laksuw, mütü chiĝa daw, seyo mim ĝubuw, seyo he patso-law na dambo nüna mowme.’ ");
INSERT INTO hru_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","No sopta ye ülye ksü tsaw-tuw matsaw ĝyowme, seyo no bo-luko dalaw gow üchea je djüwme.” ");
INSERT INTO hru_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Séŝo patso-law nüna ye üĝa gow gudzuñe, ñedzü ge je iñi maholyi dá i ülüjetchü ge güñe che, ‘He Tawgyewwa, he lalobraw no nülvoijo dawe!’ ");
INSERT INTO hru_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","No djo cheime, i ufum yo mowme; séŝo he nüna ye güdrañe ñe ge kajeme; hado chemeje dju nudzo í dyewñe veima, i imisa lyajome; seyo dju nudzo í imisañe veima, i dyew lyajome.” ");
INSERT INTO hru_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sünda nüna na na sa naje ichi ge lañe jikeñe nagzü Jisu udru ge vefijoñe; sünda shürhaw na hohuñe ná goha. ");
INSERT INTO hru_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jisu i angasa ná ichi ge balañe che, “Angasa ná nochi ge jigyejo dawe, seyo ná djugohajo dawe: hado chemeje Tawgyew í ĝadzü he nambo nabome. ");
INSERT INTO hru_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","No djo umso truime, dju Tawgyew í ĝadzü í angasa na dambo malama, ná keje süge majimyofijome.” ");
INSERT INTO hru_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Djudamje dümbraw a ye í dzü, “He uw übrowa, no shüwa-shüw shüjo ye küna dameje ujowa?” ");
INSERT INTO hru_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisu i í che, “Ba nó hado uw chewwa? Djuje uw mowme, nüna a akasa uwbame, se ye Tawgyewme. ");
INSERT INTO hru_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ba shotuko-kunu í bo danghuŝo: ‘Mim dju ĝubuwe, djushiwe, djutsakŝuwe, mülaw-mütraw djutruwe, nudzo awuñe nudzo añ naksü í chew dzüwe.’” ");
INSERT INTO hru_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","I che, “Nobo he ná vyew angasa ulvyu ladañe vewbame.” ");
INSERT INTO hru_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","He í dzüwe, “Jisu i ná che, bachi ge yaje ñu a ñilumme, bachi vyew ha duma ná draatsülyeñe sapse ná hatsüwe; sünda bá ñedzü ge luko pajome, sünda kakuñe nofum kasajo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","He í dzühulyeñe i ŝüpo duhu da, hado chemeje i ŝüpo nugo. ");
INSERT INTO hru_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisu i í holyeñe che, “Bo-luko duw na Tawgyew ichi ĝadzü ge ŝüpo ataĝa yo kamyofijobame. ");
INSERT INTO hru_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tawgyew i ĝadzü ge bo-luko duw na kamyojo í bo ut í sütrü üŝü yo kamyow je ufojomabe.” ");
INSERT INTO hru_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sünda dzühu daw na che, “Nameje djú basüafijowa?” ");
INSERT INTO hru_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","I che, “Haye nüna yo madafima, se ye Tawgyew i dafijome.” ");
INSERT INTO hru_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Patras i che, “Howe, nobó ñe-vi je tralyeñe bafum kasawme.” ");
INSERT INTO hru_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","I í che, “No bá umso truime, ana djuje ñime, dju Tawgyew í ĝadzü ubo, ñe, mim-kiĝi, ñu, awu-añ seyo saw-sam ná trahuw. ");
INSERT INTO hru_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Sünda sa yo sa a na haje añe djupawe; seyo dzüwñe druguw-drulyiw ge shüw lüshüw pajodawe.” ");
INSERT INTO hru_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sünda Jisu na ĝüyo ksü shürhaw ná üdra lañe ná che, “Ñi Yarusalem ge jingkoime, sünda küña ñu nüna üsaw ibo ñihow truw na ĝi vedama, se na vyow datsüjome. ");
INSERT INTO hru_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hado chemeje i tuĝuda-ĝuvodzü nagzü ge djüjome, sünda na í tchüĝoñe-hoĝojome, sünda zehu je müdrüdzajome. ");
INSERT INTO hru_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sünda na í güjome, sünda shijome, sünda i ñegi dzü ye üshükülyetchojome.” ");
INSERT INTO hru_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sünda na he ñu namko ye haje madzüsü sünda he ñu na namko ye müŝütsü, sünda ha trudama se ye na madzüla. ");
INSERT INTO hru_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","I Jeriko ñetrü ütrü üñisa jikulai sa a, iñi ĝew a ye üdza ge tsatuĝuñe ĝyoda. ");
INSERT INTO hru_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sünda i upu na dügrü jiw dzühuñe dzüpüñe, “Ayo a ha dangkoiya?” ");
INSERT INTO hru_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na í tru, “Jisu i Nasri ge jingkoime.” ");
INSERT INTO hru_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sündawñe i ĝuksuñe che, “He Jisu, Dawud i üsaw, no nülvoijo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dju vro-vro jeima, na í madañda ĝyo cheñe ze, sé i umsow ŝogzukülye, “He Dawud üsawa, no nülvoijo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sündawñe Jisu i gudzulyiñe í ichi ge lañe jikuwe che, sünda i iñisa jikuwñe, i í dzü, ");
INSERT INTO hru_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Bá ha tsüda, “No babo daijome?” I che, “He Tawgyewa, nó hofidügyewe.” ");
INSERT INTO hru_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisu i í che, “Hojodabe, ba veksüw ye ba dagyojemme.” ");
INSERT INTO hru_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sünda í djeañe hohu; sünda Tawgyew í troñe, ufum kase, sünda vyow nüna na hohuñe, Tawgyew íbo trotsü. ");
INSERT INTO hru_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisu Jeriko ge jimyolye jimkoi sese. ");
INSERT INTO hru_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Süge Jakkai cheñe nüna duvo, i patso-law go mukyew sünda nügo je nügo. ");
INSERT INTO hru_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I Jisu í hoĝoñ vyew i djuma cheñe? Seŝo upungda sese mahofi. Hado cheme i üchesada. ");
INSERT INTO hru_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sese i í hojoñe vye uvro ge gyo djeñe lufuje shoñ udru a ye lyilyig, hado cheme Jisu i se ĝabo kajoda. ");
INSERT INTO hru_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sese Jisu se a jikuñe, udru ge hotrolyiñe í che, “He Jakkai, kutcho lyiga; hado cheme yow no bá ñe ge ĝyojo dume”. ");
INSERT INTO hru_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","I kutcho yo lyigalye lüshüldzulalye í ichi ñe ge la kake. ");
INSERT INTO hru_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","He í hohulyebi nüna na zeĝi, “I bó se lalo nüna ichi ñe ge jijeba.” ");
INSERT INTO hru_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jakkai i gudzuñe Tawgyew í che, “He Tawgyewwa, No nó bo-luko üchea ye ñiw ná djüjome, seyo üchea ye sena djüjome djuchi go no laĝamüñeda ma se na no psüĝingua fow djüpyojome.” ");
INSERT INTO hru_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sese Jisu i í che, “Yow he ñe a muchoahuw jikudame, sündada he i je Abraham ichi sawbamme. ");
INSERT INTO hru_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Hado cheme nüna üsaw ye moadaw ná tchüw seyo ná basüaijo kakuwme.” ");
INSERT INTO hru_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sese i he ñu ná dzümkoi sese, i zeĝaw a ze, sündada chedawa i Yarusalem ütrüañ a duda, seyo i vyesüw je vyesüw, se Tawgyew ichi ĝadzübraw ye hesahe kakudalaibiñe. ");
INSERT INTO hru_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sünda: I che, “Nüna nugo a ye ge ñetrü üĝa ge ka sügo nugo pafiñe kakutchofijo. ");
INSERT INTO hru_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Seyo i í kulo naĝi yo ĝü ye balalye ná bosün uvyu ĝü djü, seyo ná che, ‘No kakuw kuw bumdzu davojo dawe.’ ");
INSERT INTO hru_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Seŝo í ñetrü ge ĝyodaw na í mahoĝoñ daw, seyo ífum ge muko kiñe ñu che ki, se i ye no matsüme, se i ñidru ge ñubyu dañjo.” ");
INSERT INTO hru_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“I ñubyu lyibiñe kakutchow sese, i ana a da, ichi se kulo ĝü ye dju í bosün uvyu ĝü djülyedama, se na itrü a balaku sünda danghujoñe vyeñe se na se i yo küña ha ha dashaladama. ");
INSERT INTO hru_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sese uvromashü yo a ye jiku che, He übrawwa bachi djüdaw bosüñ uvyu ĝü yo dañe ĝü müñew damñeladame. ");
INSERT INTO hru_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","I í che, ‘He kulo ülüksüfowwa, bá ŝüvzüw me, ba ŝüpyo mesame sese ba umsowda kakülyeda, ayo ba ñetrü ĝü yo übraw dabei.’ ");
INSERT INTO hru_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sefum yo a ye jikuñe che, ‘He übrawwa, hoŝoa, bachi bosün yo uvyu pom dashamüñewme.’ ");
INSERT INTO hru_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","I í chetcho, ‘Ba je ñetrü pom yo übraw dabei.’ ");
INSERT INTO hru_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Sefum ye a ye jikuñe chetcho, ‘He übrawwa, hoŝoa, bá bosün ye he duw ye, he í no nó gye güpaw üdza toi pyogoñe vyedaw he. ");
INSERT INTO hru_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Hado chemeje no bá ĝedabi.’ ");
INSERT INTO hru_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","I í che, ‘Mauw kuloa, no bamdzu yo bá no trudañe chei he me.’ Ba nó danghuwbi nüna mügzütchüwñe, ha ye no ma vyema se í dzula, seyo se no ma zuw, se í djoahuwme; ");
INSERT INTO hru_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ba nochi bo ye bo dashabraw ná hado madjüña, se í no kakuñe sashadaw ye lakeĝijobi? ");
INSERT INTO hru_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Seyo dju nüna na üñisa gudzudama, se na í che, ‘Se bosün ye ichigo latchojodawe, seyo djuchi ge bosün ĝü duma se í djüpyojo dawe.’ ");
INSERT INTO hru_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Na í che, ‘He übrawwa, ichi bosün ĝü bó duŝo.’ ");
INSERT INTO hru_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘No bá chemkoime, se djuchi ge duma, í seyo djüpyojoluwe; seyo djuchi ñima ichi go se í je lajodawe se ichi ha dusama. ");
INSERT INTO hru_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Seŝo nochi se fugulu ná se vyeñidaw na se no nadru ge ñubyu dame, se na age lakuñe noñisa a shiwe.’” ");
INSERT INTO hru_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisu i he ñu na chelye i Yarusalem ge navro-navro ka. ");
INSERT INTO hru_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Seyo se i Jetun üñiñi yo pu sa a Betfage ñe Betniyah üñisa ge jikuwñe, sese i í shürhaw naĝi yo ksü ye ana cheñe ki, ");
INSERT INTO hru_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Üñisa yo ñetrü ge jijo dawe, seyo süge jikubyo jikuĝyoñe giĝe ichi üsa a udru ge djusa je magyoluw, pyogo vyedaw bá pajome, se í tashalye lakuwe. ");
INSERT INTO hru_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Seyo djudamje bá dzülaimeje, hado tashamkoiya chemeje, se a ana chejodase, se Tawgyew i he í tsüdame” ");
INSERT INTO hru_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Se kidaw ná, na jikuñe i ná ha chesedama, süna pabadabi. ");
INSERT INTO hru_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Se na giĝe üsa ye tashamkoi se, ichi übraw ye ná dzü, “He üsasa ye hado tashamkoiya?” ");
INSERT INTO hru_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na che, “Tawgyew í he í tsüdame.” ");
INSERT INTO hru_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na í Jisu ichi ge la kaku seyo nudzoĝ gye ye tapualye se udru a ñeilye Jisu í giĝe udru ge gyodügye. ");
INSERT INTO hru_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sünda na kamkoi sese, na nudzoĝ polu ye ĝabo toi ñevoñe ji. ");
INSERT INTO hru_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Seyo üñisa kakulye se i Jetun pu i ĝo ge kaku, sese shürhaw na vyew upua na vyemoñe chiĝa dadaw ibó i hohuda na, lüshüldzuañe gow yo ñu zeñe Tawgyew ibo trokülye: ");
INSERT INTO hru_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ŝüvzüwme se ñubyu ye, dju Tawgyew iñiñi yo jikuma! Sorgo ge ĝüdzüw seyo ñedzü ge lüshüwme! ");
INSERT INTO hru_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sese upu na yo süña Farisi na í chengkoibi, “He Danghubrawwa, bá shürhaw ná zea.” ");
INSERT INTO hru_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","I ná chetcho, “No djomko a chemkoime, he i maziw ĝyome, kunu na ŝogzukülyejome”. ");
INSERT INTO hru_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Se Jisu üñisa kakuñe se ñetrü í holye ubo kse. ");
INSERT INTO hru_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Sündalye che, “Ha ye ujowa, he ba; am, ba bába, he ñeto ai lüshüjo ñu danghudama, séŝo se i yabó bañisa yo muŝuadabi. ");
INSERT INTO hru_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hado cheme se ñeto ye badru ge kakujo se bá vyeñiw na sülyeñtchü pyogoñe bá djetuĝujome, seyo djetuĝulye bá ñujome. ");
INSERT INTO hru_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Seyo bá seyo badra ayo a ná bachi angasa ná, nogüdzü nadra gülyiajome, seyo badru ge kunu yo je kunu matrüjome; hado cheme ba süna dajo ye kye badru ge nülvow vyeñe hojema sei madanghuje”. ");
INSERT INTO hru_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sese Jisu i ñegru ge drüñe ĝyodaw ná nopsü ge lahuatsü. ");
INSERT INTO hru_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Seyo ná che, “Ĝidame; ‘Nochi ñe ye küĝüw ñejome,’ séŝo djo he í tsaĝa-laĝaw nachi ñe da joadamme.” ");
INSERT INTO hru_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Seyo i muhu-muhu ñegru ge shi-ñu truñgudru: seyo se müga sawlyiw na seyo shizew-ñu zew na vyew djekeĝiñe í shijoñe tumuñgudru. ");
INSERT INTO hru_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Séŝo haje ĝabo matchüla; he í küna dañe dajojema, hado chemeje vyew na dru-lu djübyo djüĝoñe ichi ñu dzüñgudru. ");
INSERT INTO hru_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ahua ye ana a da, jisu i sese ñegru ge shi-ñu trumkoi sese, mügaw dew seyo shi zew-ñu zew kew nadra jikuñe sese gudzu. ");
INSERT INTO hru_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Seyo chemkoibi, “Ba ñí truwe, ba he chiĝa ná dju dadügyedañe dawdo daña, seyo se i djua, dju bá he i daweñe dügyedaye?” ");
INSERT INTO hru_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","I ná trutcho, “No je djó ñu a dzüjome; nó trujo dawe ");
INSERT INTO hru_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohañ ichi Baptisma djüw ye Soĝgo go ma mo nüna yo ma?” ");
INSERT INTO hru_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sündawñe naĝütchü zeĝi, “Se ñí chebammeje, ‘Soĝgo gobabi,’ sünchewñe i chetchojo; ‘Sünameje djo idru ge hado umso mavyeña?’ ");
INSERT INTO hru_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Seyo ñi chetchojobi, ‘Nüna yo me chetchobamme,’ se vyew na ñidru ge kunu trüjobi, hado cheme i umsow go danghudabi, Yohañ i ñihow cheñe.” ");
INSERT INTO hru_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dañdañlye na tru, “Ñi madanghume, se i djuchi go jema.” ");
INSERT INTO hru_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Seyo Jisu i ná che, “Nameje no je djo matrujome no he chi ná dju dügyeñe dadama.” ");
INSERT INTO hru_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sese i se nüna ná he ana zeĝaw go tru, “Nüna a ye anggur zugua, sündalye vi daw ná howeñe bo ve seyo ŝüpo uwalaw kuw utro ñetrü ge jitrükralye. ");
INSERT INTO hru_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bomdrü sese i vi daw nachi ge kulo a ki, se vi yo kakülyedaw anggur üje ibó je djüweñe cheñe k, sé vi daw na í gümoamdo gümoañe ufo kadügye. ");
INSERT INTO hru_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sündawñe i kulo a ye kitcho, sé na se í je gütcholyebi zeaŝe zeameñe ügzü ufo kikutcho. ");
INSERT INTO hru_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sündatchowñe i ülye dzü kitcho, seyo na se í je dzütchüzew gimoañe lahuag. ");
INSERT INTO hru_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Sündawñe se anggur go vi übraw ye che, ‘No há dajobabya? No nó saw í kijobaba, asha na í chew dzüw dujojeŝoma.’ ");
INSERT INTO hru_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sese vi daw na i hohulyebi naĝütchü poĝi, ‘He i bó üsaw ye ba; age djebya, ñi í shibow, sündañe he na ñichi lyajobi.’ ");
INSERT INTO hru_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Seyo na í se anggur vi yo lahuañe shiag: sündada vi übraw i nadra ha dajobabya?” ");
INSERT INTO hru_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“I kakuñe se anggur vi daw nüna ná damütrajo, seyo vi ye utro ná djüjo.” He í dzühulye na che, “Tawgyewwa ana djuda.” ");
INSERT INTO hru_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","I nachi ge holye che, “Se he ye ha ĝida: ‘Ha kunu ye ñe dasüw na ha madaĝiwñe süñeadama, Se i ukutru go dakrükye se i lyada.’ ");
INSERT INTO hru_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Djudamje se kunu ge gaahima se i ganüajobamme, seyo djudru ge i gahima, se í ĝünü-ĝüĝajobamme.” ");
INSERT INTO hru_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Seŝügudo ye Shi-ñu zew nañe seyo Mügaw dew na í külyijoñe vye, hado cheme danghula dabi, i nabó magow ñu zeĝaw yo tru, seŝo í ná büĝedañe vye. ");
INSERT INTO hru_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Seyo na í hokrübabiñe seyo ichi ge hotumuw ki, se hadowo cheme i alyamo alya ye shi-ñu trutroameje sese ñustu kigojoñe, se í nugo ichi ge trutroadame che djüfijoñe. ");
INSERT INTO hru_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na í ana dzü, “He dadrüwwa, ba mülaw truiñe ñi danghudame, Seyo dadrüw je darüi, Seyo djubó go goñeje mache; Semome Tawgyew ichi ĝabo ye umsow trufijo. ");
INSERT INTO hru_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hawa ñí Kesar í patso djümeje ujoma, mo mowma?” ");
INSERT INTO hru_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","I ná budzu yo dzüi ye dzüsülye che, ");
INSERT INTO hru_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Bosüñ a nó shejo dawe. He a djuchi ĝiĝe düdama seyo dju ñiñ duma?” Na che, “Kesar ichi.” ");
INSERT INTO hru_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","I ná chetcho, “Se Kesar ichimeje í djüwe, seyo Tawgyewchimeje í djüwe.” ");
INSERT INTO hru_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","I nüna ñisa a se ñu ye madzüsüla, semome ichi ñu hutrodaw se i yo mavyenghuatsü. ");
INSERT INTO hru_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sündatcholye Saduki i chew ye, nüna dzüw na kenghuaje maüshüjome, naĝi yo nüna üchea na ichi ge jikuñe dzü. ");
INSERT INTO hru_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“He dadrüwwa, Musa i ñibó ana ĝidawa, ‘Se djuchi damje üyalyo a ichi ufum ye saw-sam malaluye dzütrükralyemeje se üñuw ye se mim üyañedra i gzü datchowe, seyo üyalyo íbó agü mulo sakülyewe.’ ");
INSERT INTO hru_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sünda ye alyoñuw mro duw, üyalyo nugowfow ye agü je masakülyelubi ye dzütrükralye. ");
INSERT INTO hru_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sefum yo ye je, ");
INSERT INTO hru_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Seyo seladzü kiĝiw ye je se mimdra í gzü daladabi. Se ana dadañe namro mamro agü masakülye dzümdzoaha. ");
INSERT INTO hru_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Se nafum se mim ye je dzüase. ");
INSERT INTO hru_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Se a na üshükülyemeje se mim ye djufum lyijowa, hado chemeje i na mro mamro üdra gzü datsüwdabi.” ");
INSERT INTO hru_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisu i ná che, “He ñefo go shüdaw agü na gzü daibi, ");
INSERT INTO hru_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Se dju nüna damje ana lyifikülyemeje, sé ñeto go dzüdaw nüna na üshükülyetchojo lyifime, namko ai gzü madafijo. ");
INSERT INTO hru_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Se i dzü je madzüjo; hado cheme i sorgomuko vyedujo, seyo güdrakoŝksüw yo agü üshükülyemeje Tawgyew ichi je agü lyijo. ");
INSERT INTO hru_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Seŝo he ñu ye dzüdaw na je üshütchoi, Musa je shoñ ge süna folakülyeda, i Tawgyew í ‘Abraham üsa, seyo Isahak üsa, seyo Yakub üsa ana chelyew. ");
INSERT INTO hru_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tawgyew ye dzüw nachi mow séŝo üshü nachi Tawgyew: hado chemeje ubo yo vyew na üshütsü.’” ");
INSERT INTO hru_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sese na se í dzühulye Shi-ñu zekew küña duma na che, “He dadrüwwa ba uw chejejeba.” ");
INSERT INTO hru_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Seyo bó na í ha madzülofibi. ");
INSERT INTO hru_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sündatcholye Jisu ná dzütcho, “Masi í Dawud üsaw cheñe kündañe cheña?” ");
INSERT INTO hru_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","“Dawud i üsaw Masi i kako ge cheda: ‘Tawgyew i nochi Tawgyew í cheda, Nochi südzüvopsüĝi ge ĝyowe, ");
INSERT INTO hru_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","No bá fugulu ná bashitrü ai malakyeĝitsülu kuw.’” ");
INSERT INTO hru_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Dawud bó í Tawgyew chew; se sünameje i í üsaw künda cheña?” ");
INSERT INTO hru_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Vyew na dzümkoi sese, i í shürhaw ná che. ");
INSERT INTO hru_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Shi-ñu zekyew na yo hochiĝiwe, dju shedra psüw sheñe kahiw uw vewma, seyo ná bodzaĝ ge gaga daw, seyo küĝüw ñegru ge psüĝa dew ge ĝyojo uw vyejome. ");
INSERT INTO hru_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na müjem nachi ge tsaw jiñe seyo bühodañe uwalaw kuw küĝüw dawme, he na ŝüpyo mau ñe ge gajome.” ");
INSERT INTO hru_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sündatcholye Jisu i íñi yo lapsü dzüw nüna na nudzoĝ nudzoĝ lapsü í lapsügyebyo ge trümkoi hohu. ");
INSERT INTO hru_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Seyo i haje ñiw müjem a ye je i sayo sa a bosüñ ksü trümyoajew hohu. ");
INSERT INTO hru_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sese i che, “No djó umsow chejome se i ye he haje ñiw müjem ye fow trümoabajeme. ");
INSERT INTO hru_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hado cheme nabó nachi nudzoĝ nudzoĝ lapsü yo me trüje, seŝo i í shüda yo küña dusama vyew trümdzoajebi.” ");
INSERT INTO hru_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Küña nüna na ñegru ufo go chemkoi ye, se i küña kunu howsa yo seyo gañ yo chibra daida, se i che, ");
INSERT INTO hru_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Süna ñeto je kakujome, sese he na he i ba hohui na, namko ye ha yo ha a kunu udru ge kunu je matrajome.” ");
INSERT INTO hru_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na í dzütcho, “He dadrüwwa, he na kye dajowa? Seyo he ñu na dajobi sese, ha chi hosüw dujowa?” ");
INSERT INTO hru_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","I chetcho, “Chitchüĝivowe, dju dzüŝeawe, hado chemeje ŝüpyo nüna na nó ñiñi lañe chejome, no se ibamme; seyo he i damdrü kakudamme: djo se nafum djukasejo dawe. ");
INSERT INTO hru_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Seyo djo pseĝi-luĝi daw süna nafo go dzühulaimeje, dju ĝejo dawe; hado cheme he na uvromashü davzüjowbamme; seŝo se ñeto kutcho mamütrajome.” Süna ñeto je kakujome, sese he na he i ba hohui na, namko ye ha yo ha a kunu udru ge kunu je matrajome, Süna ñeto je kakujome, sese he na he i ba hohui na, namko ye ha yo ha a kunu udru ge kunu je matrajome, ");
INSERT INTO hru_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sündawñe i ná che, “Ĝübye yo ĝübyeĝütchü seyo ñetrü yo ñetrüĝütchü pseĝijome. ");
INSERT INTO hru_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Seyo ñeĝüzüw je dew dew dajome, seyo ñetrü ñetrü sapseañe seyo ĝañemu kajome, seyo ñedzü ge ñiĝeñiw ñu seyo dew dew chi shejome. ");
INSERT INTO hru_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Séŝo he ñu na madaluye na uvro nó ñiñi yo kigovzüjome, seyo maw-uw ze dajome, seyo ñegru ge djüjome, seyo pache ge shüjome, seyo ñetrü ge ñetrü ñubyu natrü ge lajikujome. ");
INSERT INTO hru_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Se he na babó ñu truvomdrü kakülyejome. ");
INSERT INTO hru_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sündada nudzoĝ nudzoĝ drü-lu ge pyogo vyejo dawe, no vrogomdo trufijo se í duhu madadañe. ");
INSERT INTO hru_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Hado cheme no bá ana chejo seyo ana budzu djüjome, se bá mau zeñe zeaŝe zeame dai na madafijo. ");
INSERT INTO hru_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Seyo bachi awu-añ seyo ñuw-ñum seyo ñeŝüĝ-ñepyeĝ, seyo draw na je tsüladügyejobamme; aña kuw dajome, djomkoye ŝüpo na dzüdügyejome. ");
INSERT INTO hru_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Seyo no ñiñi yo badra mau dajome. ");
INSERT INTO hru_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Séŝo bakyetrü umu a je matrüafijome. ");
INSERT INTO hru_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ba nudzoĝ drü-lu ye ĝüdzüw yo shütrüñe vyejo dawe. ");
INSERT INTO hru_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ba kyedamje Yarusalem í rhünokew na yo jiĝshiĝiahuw hohume, sese ichi mütrüjo üñisabammeñe danghujo dawe. ");
INSERT INTO hru_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sese dju Yahudiya ñetrü ge duma se na pu udru ge djetralyewe, seyo dju Jerusalem ulung ge duma se na djehuajo dawe; seyo dju ñetrü ge duma se na süge djujijo dawe. ");
INSERT INTO hru_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Hado che se i dutruĝijo ana ñeto kujome, sese ñu ĝiñe vyelyedaw na vyew lyitsüjobamme. ");
INSERT INTO hru_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Se ñeto ge dju agü ñiw seyo agü apu tudügyeima, se nabó tui! Hado cheme se ñeto ge no naĝütchü daĝijo seyo se a ná ŝüpyo ñiku-ñisüw lyijo. ");
INSERT INTO hru_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Na vyetsü ürhü yo süĝüajome, seyo vyew ñetrü drü-drü ge mubyo na lakuzeĝiatsüjome, seyo utro sama nachi ümdrü vyew makulu kuw, sese Yarusalem í utro sama yo dashiĝiajome. ");
INSERT INTO hru_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Seyo dru seyo hubye seyo lütsü se na ge chi shejome, seyo nomñew ñetrü a je, ñetrü drü-drü go nüna ná chitruw dajome; hado cheme na sütüĝülü ichi hu rhaw yo lamo ĝetsüjome. ");
INSERT INTO hru_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Seyo ĝew yo druguw-drulyiw a trǘw kakujo se í hohuñe nüna üshüjoñe je mavyejome, hado cheme ñedzü go gokew ye je ĝüdü-ĝüdüjome. ");
INSERT INTO hru_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sese na nüna üsa í lüshüw-lübaw mumudrü ge gow kalai hohujome. ");
INSERT INTO hru_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","He ñu ye trumkoi sese, ükye ye gudow dañe udru ge hotrojo dase; hado cheme bá solutoajo üñisame.” ");
INSERT INTO hru_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","I ná zeĝaw je a tru, “Lufuje üyaññe vyew shoñ na howe. ");
INSERT INTO hru_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ichi übatra kakülyebyo kalyeĝyowñe, se í ba hohulyeñe balvyo danghulaibi ñeshü kalaibiñe. ");
INSERT INTO hru_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sünambó vyeduw ba he ñu na kye hohuima, sese danhulababise Tawgyew i ñetrüĝüfo kakujo üñisababiñe. ");
INSERT INTO hru_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","No bá umsow trujome, he ĝhei ñu na madalu kuw he ñefo ayo shüdo nüna na kyeje lüshüw mapajome. ");
INSERT INTO hru_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ñedzüñe No naksü kaltruĝidamje, seŝo nochi ñu kye je makatrujome.” ");
INSERT INTO hru_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Sündada ufu je ksü üñi je ksü da ĝyowe, ya ba badrü balu ye he druguw drulyiw ayo dashüw ge daŝea kiŝeañe, shüjo djojo ge vyeŝeañe da ĝyomkoñbai ye jia, ñe se badru ge kyegüdü-ñiĝi kakugme. ");
INSERT INTO hru_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hado chemeje i he añawa nomñew ñetrü ayo ĝyodo nachi ge ana vyeduw dañe kakujobabi. ");
INSERT INTO hru_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Sündada chiĝiñgudrujo dawe seyo küĝüñgudrujo dawe, he ana a kyegüdü-ñiĝi kakudamje ha madaw ĝaksüfisejoñe, seyo nüna üsaw i vro a gudzufiwjo lyijo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Seyo se ñeto ge ñegru ge shi-ñu tru süna dawse; Seyo ñegi ge i nopsü ge jihuañe Jetun pudru ge ĝyoñgudru. ");
INSERT INTO hru_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Seyo na je ŝüzüw ye tralye ichi ge jikuñe shi-ñu truw ye dzüjoñe ñegru ge jikuñgudru. ");
INSERT INTO hru_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Odje oĝüme se i na ofo rhano chew, üñisa dabi. ");
INSERT INTO hru_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Seyo mügaw dew nañe shi-ñu zew naksü shüwa í kündañe shijoma se í kadang hotumu, sé na nüna nayo ĝew. ");
INSERT INTO hru_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Seyo mütü Yahuda ge kamyoa, djú Iskariyoti chew sünda í shürhaw ülgü ĝü yo ksü namko ge i je duw. ");
INSERT INTO hru_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","I jiñe Mügaw dew ñe kulow kyew hotumuw nadra chitru, Tawgyew í künda lügyelajoma sena. ");
INSERT INTO hru_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na lüshülag, Seyo í na bo djüjome cheñe müdaa. ");
INSERT INTO hru_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","I je embi che, sündalye hotuma-hotumuhi, se í usso ge ñu majodügyew lügyeladügyejoñe. ");
INSERT INTO hru_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sese odje oĝüme daw ñeto kakudabi, sese Fasa ge fugulu üsa ye che küĝüw kijobabi. ");
INSERT INTO hru_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sünda Jisu i Patrasñe Yohañ naksü i ana cheñe ki, “Djeñe ñibó Fasa ge tsajo-tujo dashütrüvowe.” ");
INSERT INTO hru_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","I í dzütcho, “Ba nó hange dashütrüvoweñe tsüda?” ");
INSERT INTO hru_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","I ná che, “Howe, ñetrü ge kaakubyo-kakuĝyowñe nüna a ye hu guw kolo lodow tüvajome, dju ñe ge i jihima; ba ifum jisajo dawe, ");
INSERT INTO hru_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Seyo sé ñe go übraw í chewe, ‘Dadrüwwa bá chemkoime; se tumóna ná ñe hagewa sa a no nó shürhaw nadra Fasa tsajo ye?’ ");
INSERT INTO hru_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bá i howsa yo dagüdravodaw üĝüñ dew a shejome; süge dashütrüvowe.” ");
INSERT INTO hru_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","I jikubanda, i küna chedama sünabyo-sünaĝyo duvobi, sünda i Fasa í dashütrüvo. ");
INSERT INTO hru_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Damdrü kuwñe, Jisuñe i shürhaw na nadra tsajobiñe ĝyo. ");
INSERT INTO hru_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sündalye i ná che, “No nolu ge ŝüpyo ana vyewme, duhu makakulu kuw djodra ye ülya ana üŝa ĝyoñe ava tsajoñe vyewme. ");
INSERT INTO hru_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hado cheme no djó chemkoime, he i Tawgyew ichi nogo ge vyew makulu kuw no se í keje matsajome.” ");
INSERT INTO hru_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sese i bekasa lañe dru-lu yo ŝüvzüw gañe che, “He í lalyeñe djoĝütchü ge habraĝijo dawe. ");
INSERT INTO hru_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Hado cheme je no djó chemkoime, Tawgyew ichi ĝadzü madalu kuw no ayo dalalye keje he shejehu matujome.” ");
INSERT INTO hru_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sündatcholye i odje la, seyo üdrü-ulu yo küĝüñe takuĝia, seyo ná ana cheñe djü, “He i nó usso me, ha yé djobo djüwma: nó vyehuñe he ana dajo dase.” ");
INSERT INTO hru_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","He ana dambo i tsaw tsafialye bekasa je ana cheñe la, “He i nochi sé ŝü yeme he i djobó fuadaw yeme ñu ükünüme. ");
INSERT INTO hru_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sé hojo dawe, nó kigoladügyejo ichi ügzü ye nodra a dume. ");
INSERT INTO hru_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hado chemeje nüna üsaw ye bó ibo küna daweñe dadama, sünambó dajobabi, séŝo tui se nüna idru ge, djubó sa a í kigoladügyejoma!” ");
INSERT INTO hru_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sündawñe na naĝütchü dzüĝi-hoĝingkoibi, “Ñimko a djuwa, he chiĝa dajo ye?” ");
INSERT INTO hru_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Namko a ana ñu che zeĝi; ñimko a dju dew vyefijowa? ");
INSERT INTO hru_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","I ná che, “Utro sama nago nugo na nadru ge shotuko joi; seyo dju nadru ge shotuko jofijo daima, se ná povow nüna chewme. ");
INSERT INTO hru_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Séŝo ba ana djulyiwe; mowme djomko a dju nugow dama, se i angasa vyeduw seyo dju ye ñubyu ma se i kulo vyeduw lyiwe.” ");
INSERT INTO hru_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hado cheme dyew ye djuwa; se i buĝo ge ĝyodaw yeme, semome se chiĝa damkoi yema? Hawa se i je mowma se tsawdra ĝyodaw ye? Séŝo no djodra a kulo vyeduwbame. ");
INSERT INTO hru_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Seŝo djo se na me, dju nodra ñiku-ñisüw ge je nodra duwsaw na me; ");
INSERT INTO hru_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Seyo sünambo vyeduw nochi Awu i nóbó ñetrü ükün a davyedama, sünambo no je djobó davyeijome. ");
INSERT INTO hru_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Se i ye hadowo cheme djo nodra nó buĝotrü ge tsawe-tuweñe; se psüĝa a ĝyoñe Israyel nachi go ĝübye ĝüyoksü í zegüdralawe. ");
INSERT INTO hru_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, oi Simon, djó mütü ye prüdame pu í dambo güjoñe. ");
INSERT INTO hru_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Séŝo no djóbó küĝüwme, djódrü-djolu go umsowñe vyedaw ye kyeje mañoajo seyo djo kakume djó nudzoĝ alyo-ñuw na je ĝüdükewe.” ");
INSERT INTO hru_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","I í che, “He Tawgyewwa, no badra pache ge damje kasejo semome dzüjoje dzüfijobame.” ");
INSERT INTO hru_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","I che, “Oi Patras no bá chemkoime, yow jo külyiwñe sese ba nó ülye dzü mahosüw chejome.” ");
INSERT INTO hru_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Seyo i í che, “Bá no dzulngasa seyo kapüĝa seyo shita je ñiw ufobüla kimkoi ge ba hama a mapu mavyew dadama?” I chetcho, “Ha chi go mowme.” ");
INSERT INTO hru_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","I í che, “Séŝo djuchige dzulngasa duma se na se i lawe, seyo sünambo kapüĝa í je, seyo djuchi ge kyeĝi ñima ná nachi gye na damje drütülüalye lawe. ");
INSERT INTO hru_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hado cheme no djó chemkoime, he ĝido ye, ‘Se i truw nüna ge ngüjobamme,’ se i nódru ge dajoye krükrüwbamme; hado chemeje nogru ge küna dajoñe dadama se na datsüjobamme.” ");
INSERT INTO hru_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na che, “He Tawgyewwa, howe, he a kyeĝi ksü duwa.” I ná chetcho, “Ŝüpyo dume.” ");
INSERT INTO hru_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sese na ñepsü ge jihuañe na dadaw basha yo na ge Jetun pudru ge jitsü, seyo shürhaw na nafum jisa. ");
INSERT INTO hru_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Süge jikuñe i ná che, “Küĝüjo dawe, djo zeĝaw ge magajoñe.” ");
INSERT INTO hru_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Seyo i na yo utroga kunusa a josajombuaña ge jiñe, seyo üshipyu dugoñe küĝümyomkoibi. ");
INSERT INTO hru_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“He Awua ba tsübameje he bekasa ye notrü yo latrülyewe, sedamje nó husü yo mow bá husü yé dadzowe.” ");
INSERT INTO hru_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sese soĝgo go sorgomuko a í sa yo sa a hohu dju í zego dawma. ");
INSERT INTO hru_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Seyo babiye i ŝüpyo vyemülüañe vyemoañe küĝükülyejebi; seyo ichi úfu ye no ge ŝü fuw vyeduw tra tra dzuamkoi. ");
INSERT INTO hru_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sese i küĝüfialye gudzulye ichi shürhaw nachi ge kakuñe hoholye vyew na drumutsüdaw hoñe duhu da. ");
INSERT INTO hru_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sündalye i ná che, “Hado drumuiya? Pülyibya, küĝübya, na zeĝow ge magajoñe.” ");
INSERT INTO hru_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisu i süna chemkoi sese, howe upu a djelai ná, seyo se ĝü yo ksü namko a ye dju ñiñi ye Yahuda chewma i uvro uvro djekelaibi, i Jisutrü ge djeku, í bubu dajoñe. ");
INSERT INTO hru_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sé Jisu i í che, “Oi Yahuda, hawa ba bubu dañe nüna üsaw í kigoladügyejoma?” ");
INSERT INTO hru_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Idra yo na idra ha dajoma í hohuwñe, sünda che, “He Tawgyewwa, ñi keĝi dzofijoma?” ");
INSERT INTO hru_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Seyo namko ayo a ye mügaw dew ichi kulo nadru ge keĝi yo dzohiñe ufu fuvo go dzoga. ");
INSERT INTO hru_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sé Jisu i che, “Sayo sa a damudoabe.” Seyo sa a ichi ufu ye kiñe dagyoi. ");
INSERT INTO hru_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sese Jisu i mügaw dafow na seyo ñegru ge hokrüvow go mükyefow na seyo kew se na ídru ge lyikülyedaw ná che, “Hawa djo nó ñiguduñe danghuñe keĝi ñe shalbo ñe lañe jikuma? ");
INSERT INTO hru_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","No djodra ñegru ge muhu-muhu djodra duw sa je sesüge djo nó gzü a je maki; sé hesahe djochi ümdrübamme, vataĝüsagiahuw yo vataĝüsagiahuwme.” ");
INSERT INTO hru_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sündatcholye í na tsülalye la kakye, seyo mügaw dafow saw-lyiw ichi ñe ge lañe kaku seyo se Patras i üĝa-üĝa djega djegañe ifum-ifum djese. ");
INSERT INTO hru_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Seyo na nopsü ge mi pyeñe tchü üŝa ĝyomkoi sese Patras je namko a ĝyoa. ");
INSERT INTO hru_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Seyo se a kulom a ye í mi müsaw ge ĝyokülyedaw hohulye seyo í usu yo hopafi hopañe chemkoibi “He i je üdra yo baba.” ");
INSERT INTO hru_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Séŝo i ana che hujonoĝyoa, “O mimya, no í madanghuwe.” ");
INSERT INTO hru_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Me uwalatchowñe utro a ye hotcholye chetcho, “Ba je nadra yo baba se.” Patras i che, “Oi nüna, no mowhoje.” ");
INSERT INTO hru_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Me uwalatchowñe nüna a ye dügago hoñe chengkotchoibi, “He i je nadrayobabiŝa; umsow cheme he i Galilibabi.” ");
INSERT INTO hru_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sé Patras i che, “Oi nüna, no madanghuwa ba cheijema.” I süna chemkoi sese jo je külyijebi. ");
INSERT INTO hru_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sündawñe Tawgyew i tcholtruĝiañe Patraschi ge ho, sündawñe Patras i Tawgyew i ñu chedo ye vyehu i ha chedama, “Yow jo makülyilu uvro ge ba nó ülye dzü kuw madanghuw cheñe hujonoĝyoajome.” ");
INSERT INTO hru_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Seyo i ñepsü ge kahualye ŝüpyo ku ku kuw kse. ");
INSERT INTO hru_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Dju nüna ye Jisu í kigo dama, na í mülakulyuñe gümyomkoibi; ");
INSERT INTO hru_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Seyo ichi iñi ye pyelyeñe í dzü, “Ñiholye trubya bá dju güima.” ");
INSERT INTO hru_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Seyo ana ŝüpyo nomñew zeaŝe-zeameñe í maw-uw ze. ");
INSERT INTO hru_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ñetoahuwñe naĝi yo kyew seyo müga dew shi-ñu zekyew-kikyew se na vyew keĝitsü, sündalye í na melye dew gudo ge lakuñe chi dzü, ");
INSERT INTO hru_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Sünameje ba Masimeje, ñí trujo dawe!” I ná che, “No djó trumsome djo nó umsow mavyejome. ");
INSERT INTO hru_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Seyo dzüdamje, matrufijome. ");
INSERT INTO hru_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Seŝo ayo dalalye nüna üsa no sawlyiw Tawgyew ichi upo südzügo gow dañe ĝyongudrujobi.” ");
INSERT INTO hru_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Sünchewñe vyew na chetsü, “Sünameje ba Tawgyew üsawma?” I ná che, “Djo cheñŝoiwa, hado chemeje nobabi.” ");
INSERT INTO hru_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sese na che, “Yabó no truvoijoje ha matsübi; hado cheme no bó nobyo no dzühuladabi.” ");
INSERT INTO hru_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sese vyew keĝidaw nüna na gudzutsüñe Jisu í Pilatus ichi ge la jiku. ");
INSERT INTO hru_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sündalye na ana cheñe ídruge külü jo, “Ñí i nüna ná zeĝow seyo Kesar í patso i madadügyew seyo nudzo í Masi seyo nugomeñe chew dzühudame.” ");
INSERT INTO hru_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatus i í dzü, “Ba hawa Yahudi nago nugoma?” I í tru, “Sebó ba cheŝoiwa.” ");
INSERT INTO hru_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sünchewñe Pilatus i mügaw saw-lyiw nañe se nüna ná che, “No he nüna idru ge ha je külü mahohume.” ");
INSERT INTO hru_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Séŝo nabó sünchewñe seyoje ŝüpyo mügzüw yo chemkoibi, “He i Galili yo dalalye age kuw Yahudiya ná vyew shi-ñu tru truñe truĝolatsüdame.” ");
INSERT INTO hru_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Süna dzühulye Pilatus i dzü, “Hawa he nüna ye Galili ñetrü goma?” ");
INSERT INTO hru_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Seyo he í danghula i Herodes ichi shotuko ulungo nüna dabi, í Herodes itrü ge kitcho, hadowo cheme sé ñeto ge i je Yarusalem ge duvo. ");
INSERT INTO hru_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes Jisu í hohulye ŝüpyo lüshü, hadowo cheme ŝüpyo uwalaw gomdo í hoĝoñiw vye: se i ye hadowo cheme ifogo dzühuda, seyo ichi chi ashama asha ye sheweñe ve. ");
INSERT INTO hru_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","I í ŝüpyo ha ha ñu dzü, se i í ha je matru. ");
INSERT INTO hru_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Seyo se müga saw-lyiwñe shi-ñu zekyew naksü ulung ulung ge í ze. ");
INSERT INTO hru_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sese Herodes i ichi nüna nadra ye í zeaŝe-zeameñe zekütso zemürhü, seyo iĝi ĝiguw gye ye sheisalye ge Pilatus ichi ge kitülütcho. ");
INSERT INTO hru_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sehu ñeto yo Pilatusñe Herodes naksü üdraw lya. Ana madalu. Sevro ge naksü mahoĝiw. ");
INSERT INTO hru_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus i mügaw saw-lyiw í seyo nüna na balañe ná che, ");
INSERT INTO hru_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Djo he nüna í nüna ná zeĝoime cheñe nochi ge lakuda, seyo holaŝoa, no djó how a í dzü howŝobi, se djo ha ñu yo iso ge külü joima, se ñu yobó no hasaje ichige külü mahohu; ");
INSERT INTO hru_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ge Herodes je mowbi, hado cheme i í nochi ge djültrutchodabi: seyo holaŝoa, i düm takyolaje shimdojo ana haje mada. ");
INSERT INTO hru_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Sündada no í shidzü trabañebi” ");
INSERT INTO hru_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatus i rhanomko a nüna a tsüla vyedaw ye kihuajobabiñe lya. ");
INSERT INTO hru_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sündawñe vyew na ŝogzutsü, “I damtrüabei, seyo ibó Barabba i trajodawe.” ");
INSERT INTO hru_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","I ñetrü a ye pseĝi-luĝiñe, shiw-law dadaw ubo go pache ge shüñe vew. ");
INSERT INTO hru_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Seŝo Pilatus i Jisu í trajoñe vyeñe nüna ná che hopüñetcho. ");
INSERT INTO hru_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Seŝo nabó ŝogzuñe che, “Í kuros ge külyiwe, kuros ge!” ");
INSERT INTO hru_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","I ülye dzü kuw ná che, “Hado cheme i ha mau damdoda? Nobó í düm takyoñe shimdojo lalo daw mahohubei! Sündada no í gidüñe trabañebya.” ");
INSERT INTO hru_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Seŝo na ŝogzu-ŝogzuñe zetsü, í kuros ge külyimdoweñe, sünda ná ŝozuw ye foajebi. ");
INSERT INTO hru_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ha madanghulye: Pilatus i dügyeaha, na ha cheima sei dzülye dawe cheñe. ");
INSERT INTO hru_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Seyo i se nüna vyesvye-vyemdolalye nüna shido í pache ge shüdaw ye, seyo djú í prüwma í trase; seyo Jisu í na nalu ge ha vyedama süna vyew apyew kuw djüki. ");
INSERT INTO hru_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na í lañe kakemkoi sese, Simon cheñe Kureni a ye ñetrü go kanglai sa a, í kigo lalye shokru giñe Jisuchi ge lakuñe ifum ifum la kake. ");
INSERT INTO hru_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Seyo nüna ye gumtchubabiñe ifum ifum kase: seyo ŝüpo upu mim na je, dju ibó üldjetchü gü gü kseñe ksekuĝiladjew. ");
INSERT INTO hru_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisu i nachi ge tcholtruĝialye che, “He Yarusalem ayo sam nawa, nóbo djuksejoda; seŝo djo josa seyo djó nudzoĝbó ksejoda. ");
INSERT INTO hru_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hadowo cheme se ñeto kakujome, seyosa a nüna na chejome, ‘Ŝüvzüwme se na dju ügübzümma, seyo dju saw-sam masakülyema seyo dju agü apu manuma.’ ");
INSERT INTO hru_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Se ümdrü ge ‘Na pu naje chejome, ñidru ge gaabe, Seyo noĝüfo yo ñi muŝuiwe.’ ");
INSERT INTO hru_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Hado cheme na shoñ djüw nadra ana damkoibi ye, krow nadra küna ha dañjema?” ");
INSERT INTO hru_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na seyo nüna ksü ije lalo datruw go idra ye shijoñe la jikye. ");
INSERT INTO hru_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na se Kopri che Noĝüfo ye jikuwñe, na sayo sa a í seyo se lalo datrudo ksü ye je, a ye ichi südzü go seyo a ye ichi fuvogo ge süna kuros ge külyiñe vye. ");
INSERT INTO hru_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Sündawñe Jisu i che, “He Awuwa, ná muchoaiwe, hadowo cheme he na madanghume na ha dangkoima?” Sünda na kako ge ĝi veñe i gye í habraĝia lastü. ");
INSERT INTO hru_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nüna na gudzu-gudzu hoĝyo, seyo nugo na je zeaŝe-zeameñe ze ĝyo, “I utro na ĝaksülaw, i Tawgyew ichi Masimeje, seyo ichi dzulawmeje, nudzoĝ ĝaksülajo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Rhünokyew naje í trow uhu ye í nuñe zeaŝe-zeameñe che. ");
INSERT INTO hru_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Senameje ba Yahudi nachi go nugomeje, ba bá nudzoĝ í ĝaksülalabya!” ");
INSERT INTO hru_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Seyo idru ge truw a chedalubi; “He i Yahudi na go nugome.” ");
INSERT INTO hru_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ha lalobraw ye shokru ge külyi suntchadama, namko a yo a ye í zebze-zeĝeñe che, “Hawa ba Masi moma? Sünameje ba balvyo ĝaksüñe seyo ñiksü i je ĝaksüila!” ");
INSERT INTO hru_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sünchewñe utro a ye í zeñe che, “Hawa ba Tawgyew í je maĝewbama? Ba je süna pabaibi, ");
INSERT INTO hru_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Seyo ñiksü bó shotukobasha yo pangkobabi, hadowe cheme ñibó ñi chiĝa ha dadama süna shishü pangkobi; séŝo i haje mau chiĝa mada.” ");
INSERT INTO hru_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sese i che, “He Jisua, ba bá ñetrü kakuwñe nó je dju koŝoawe.” ");
INSERT INTO hru_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","I í che, “No bá umsow chemkoime yow yo ba nodra sorgo nogo ge dujome.” ");
INSERT INTO hru_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Seyo muhumdzu yo dalalye me apyew djüdualai kuw ye vyew ñetrü na nukuĝuatsüdabi, ");
INSERT INTO hru_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Seyo dru müsaw yebó je kañoahibi, seyo ñegru go gyeña bó je ulumko toñe-meñe yo gaĝaajebi, ");
INSERT INTO hru_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Seyo Jisu i ŝüpyo gow yo ŝogzuñe che, “He Awuwwa, no nó ĝulo ye bagzü ge trahime.” Seyo i süna chelye ulvyu sese lutukyoaha. ");
INSERT INTO hru_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ĝyokrüw nüna ye sa a ha dadama se na holye i Tawgyew í tro, sündalye che, “He nüna ye güdraŝobi.” ");
INSERT INTO hru_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Seyo upu na he í hojoñe keĝitsüdaw na, he ŝoboŝulyw dadaw í holyeñe nalüjetchü ge güñe kalütrü. ");
INSERT INTO hru_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Seyo ichi hosüw-holüw küña duma vyew, seyo mim na je dju dju idra Galili go jikusedama vyew, üĝa ge gudzuñe se na ho ĝyo. ");
INSERT INTO hru_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Seyo süge, Yusuf cheñe yo nüna a ye se rhano dew ge du, dju ye uw seyo chi danghuw muhu. ");
INSERT INTO hru_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Seyo ichi vyéw seyo ichi chiĝa daw yo malüshüw; seyo i Yahudi na ñetrü go Arimitiya ge ĝyow seyo Tawgyew ichi nogo ye ĝyokrüw nüna. ");
INSERT INTO hru_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I Pilatus ichi ge jiñe Jisu ichi ñimo ye prü, ");
INSERT INTO hru_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Seyo í lagaalye gyelüdü yo daw gyeña ge vaŝüñi, seyo nuĝu a ye vye, se i ye kunu ge chido süna; seyo süge keje dju je mavyewlu. ");
INSERT INTO hru_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Se i ye dashüwtrüw ñeto, seyo ĝyogow rhano damivrojo ümdrü ge. ");
INSERT INTO hru_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Seyo se mim na dju idra Galili go jikusedama, ifum, ifum jiñe se nuĝu ye ho seyo uso je ho í daw basha yo da vyedaŝomañe. ");
INSERT INTO hru_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Seyo kakultruñe ŝowsa chi seyo ŝonuw dashütrü; seyo ĝyogow ñeto ge bó i je daw basha yo ĝyogo. ");
INSERT INTO hru_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sopta uvro ge, saĝa-müĝa na nuĝu ge ŝowsa ŝow gañ-miĝi lañe jiku. ");
INSERT INTO hru_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sünda na kunu í ĝühuadaw hohu. ");
INSERT INTO hru_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Sünda ulung ge jemyongkoi ge, na Prabu Jisu usso mahohubi. ");
INSERT INTO hru_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","I he ñu yo mavenghuañe ĝyoñbaiye, muhu ksü ye lütsü-lütsüw gye sheñe ütrü iñisa ge gudzu. ");
INSERT INTO hru_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","I ĝeñe, sünda nodo ge ukrumro i pelye; sündawñe i í che, “Ba üshü í dzüw namko ye hado tchüwwa. ");
INSERT INTO hru_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I ayo a ñimme, séŝo üshükülyedamme. I djo Galili ge ha trudama vehujodawe. ");
INSERT INTO hru_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Umsogo je nüna üsa í lalobraw nagzü ge kigo ladügyejobamme, sünda kuros ge tükegojome, sünda ñegi dzü ye üshükülyetchojome.’” ");
INSERT INTO hru_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sünda i í ñu í vehuag, ");
INSERT INTO hru_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sünda nuĝu go kangkoi ye i se ĝüyo a ná, sünda utro naje, he vyow ñu ná truzeĝiatsü. ");
INSERT INTO hru_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Dju he ñu í shürhaw ná trudama, se na Mariam Magdalini seyo Yoana, seyo Yakub üyañ Mariyam sünda nadra ye utro mim naje duw. ");
INSERT INTO hru_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Séŝo na ñu trudaw ye ná shipyew truw veduw velada sünda na ná umso mave. ");
INSERT INTO hru_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sündawñe Patras i gudzulyiñe nuĝu ge gyo dje, sünda gye ufobüla hohubadabi, sünda hadadama, se yo mavenghulyaha, í nudzo ñe ge kaltrutcho. ");
INSERT INTO hru_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sehu namko ye nüna ksü ye Imawus cheñe ñetrü ge jiinngkoi, Yarusalem yo kilo mitar mro kuw üĝa. ");
INSERT INTO hru_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sünda naksü se vyow ñu ná, hadadama se na naksüĝütchü chitruñe ji. ");
INSERT INTO hru_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sünda naksü se ñu na naksüĝütchü ge truĝiñe dzüĝiñe jingkoi ye, Jisu i iñisa jikuñe naksü üdra jisa. ");
INSERT INTO hru_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Séŝo nañi ye ana veduw mütrüdaw ye í mahosülafi. ");
INSERT INTO hru_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisu i ná dzü, “He ha ñuwa, djoksüĝütchü ge truñe jiiye.” I duhu dañe ĝudzu. ");
INSERT INTO hru_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","He í dzühulyeñe, namko ye Kilyupas ñetrü go nüna a ye che, “Haña ba Yarusalem go ba akasa tüvaw jiw nünabamma, dju he ñeto ge hadadama se na se i madanghu.” ");
INSERT INTO hru_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","I í dzü, “Ha ñu ye wa?” Na í che, “Nazret go Jisu ibo dju Tawgyew seyo nüna nabo chiĝa dawma sünda shi-ñu truw go ñihow truw. ");
INSERT INTO hru_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sünda mügaw kew na seyo ñi dümbraw dakyew na í kigoladügyeñe, shibeñe dügyeaha; sünda kuros ge sümtchadügye. ");
INSERT INTO hru_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Séŝo ñi vyeksüwŝo, i Israyel í mutchoaijo che, sünda he ñu na tralye, he soboŝulyuw dajew ye ñeĝi dzü kujebi. ");
INSERT INTO hru_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sünda jimko ye je mim üchea na ñi mavenghuadügyeda, dju saĝa-müĝa nuĝu ge jidama na. ");
INSERT INTO hru_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Sé usso í mahohuwñe, sorgomuko nadra í üshüdame cheñe ñu truw che djekuda. ");
INSERT INTO hru_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sündawñe ñimko yo a ye nuĝu ge how ji, sünda mim na küna trudama, süna tchülada; séŝo í mahohu.” ");
INSERT INTO hru_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sündawñe Jisu i ná che, “O madzühoave dañe ĝyodaw nawa, seyo ñihow truw ná ñu ge üdrü-ulu yo umso dzüngahu nawa! ");
INSERT INTO hru_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ana dajo mowma, Masi i duhu gilañe nudzo lüshüw ge kalyitralyejo?” ");
INSERT INTO hru_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sünda í ná ibo go kako ge ha ĝidama se ye Musa ichi yo dalalyeñe vyow ñihow truw nachi ge ĝidaw na, i ná danghudügye. ");
INSERT INTO hru_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aña sa a na hange jingkoima, se ñetrü jikujebi, sünda í dawyo na ana danghuda, i ayoje uvro ge jijolu cheñe. ");
INSERT INTO hru_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sé na í ana cheñe ĝokrüdügye, “Ñidra ĝyosajodawe; hado chemeje djüdu lyañe añe uwaladabi.” Sünda i ulung ge nadra ĝyosaw kamyoa. ");
INSERT INTO hru_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","I nadra ava tsajoñe ĝyosangkoi ye, i odje í lañe gaĝüzü djü, seyo í takuĝiañe ná djü. ");
INSERT INTO hru_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sündawñe nañi hojukülyeñe í hosülag, sünda na iñi how yo müŝü. ");
INSERT INTO hru_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na naĝütchü ge che, “Ñidrü-ñilvyu ge mi madzoma, i ñí ĝabo ge kako ge ĝidaw ná truñe jomkooi ge?” ");
INSERT INTO hru_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","I sa yo sa a gudzulyiñe Yarusalem ge katrükralye, sünda i se ĝüyo a seyo nadra a yo na üŝaka ye keĝidaw hohu. ");
INSERT INTO hru_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na che, “Tawgyew umsogo je üshükülyetchoda, sünda Simon i hohu.” ");
INSERT INTO hru_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sündawñe i ná ĝabo ge chitru jidaw na ná tru seyo he je tru, i ná kündañe odje í takuĝiañe tsadama. ");
INSERT INTO hru_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na he ñu í trumkoi ye, Jisu í husü yo namko ye gudzukülye; sünda ná che, “Djo ĝüdzüw pawe.” ");
INSERT INTO hru_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Séŝo na mavenghuatsüg, seyo ĝeatsüg, sündañe na velatsü, ñi mütü hohungkoi. ");
INSERT INTO hru_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","I ná che, “Hado mavenghuatsüña? Sünda djulvyu ge hado mavenutsüña? ");
INSERT INTO hru_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","No gzü seyo noshi na howe, no sebamme; no kiñe hojodawe; hado chemeje ñeĝulo nachi uso üĝübye ñijo nochi ge hohumbo.” ");
INSERT INTO hru_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ana chelyeñe ná i ichi ügzü ishi na she. ");
INSERT INTO hru_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ná lüshüw yo seyo umsojemañe veñe, seyo lümashü ve, sündawñe i ná dzü, “Haña djochi ge ava duma?” ");
INSERT INTO hru_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na í psekrow tchükro üsüla a djü. ");
INSERT INTO hru_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","I lañe na how sa a tsag. ");
INSERT INTO hru_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sünda i ná che, “He na no ñu name, no djodra ĝyosañe truwme, Musa í shotuko ge seyo ñihow truw kuw na seyo kako ge nobo go ĝidaw na umso kakülyejome.” ");
INSERT INTO hru_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sünda i na ükye-ümüñi í güdraw ñu ĝidaw dzüsüdügyejoñe voiha. ");
INSERT INTO hru_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Sünda ná che, “Ana ĝidame Masi duhu gilañe seyo ñegi dzü ye dzüñe üshükülyetchojome, ");
INSERT INTO hru_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Sünda Yarusalem yo dalalyeñe vyow ĝübye geg vetrüw seyo lalo daw na iñiñ yo lañe truzeĝiatsüjo. ");
INSERT INTO hru_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Djo he ñu na hohusawme. ");
INSERT INTO hru_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sünda djuchi traŝüĝa no awu i dadama, se ná no djo lakülyaijome sünda udru go gow mapamdolu, süña kuw djo he ñetrü ge ĝyokrüjo dawe.” ");
INSERT INTO hru_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sünda i ná Betniyah kuw ñepse lañe jekülyasa, sünda ügzü i lañe ná gaĝüzü djü; ");
INSERT INTO hru_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sünda ná gaĝüzü djüshüñe i na yo utro lya seyo ñedzü ge kalyitralye. ");
INSERT INTO hru_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sünda na mraañe í ŝüpo lüshüw yo Yarusalem ge katrükralye. ");
INSERT INTO hru_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Sünda ná ñegru mamuduw keĝiñe Tawgyew í troñe seyo gaĝüzüwe.");
INSERT INTO hru_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Polus ichi go bó, se Jisu Masi ichi pache ge shüdáw nüna, seyo ñuw Timotiyus ichi ve go ñichi nülvo chiĝadam Filemon, ");
INSERT INTO hru_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","Seyo ñum Afiya seyo ñidra yo shipashi Arkipusñe Filemon ichi ñe go ñeŝü na ñiñi. ");
INSERT INTO hru_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Ñichi Tawgyew awuñe Tawgyew Jisu Masi naksü naksüchi vye go ĝüdzüw ye bá pangudruwe. ");
INSERT INTO hru_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","No shüwa Tawgyew í ŝüvzütrojome; seyo nudzo küĝülai ge je bá vyehuwme. ");
INSERT INTO hru_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","Hado cheme no bachi sé nülvo seyo vyemso chi shi-ñu na dzühulye, se Tawgyew Jisu dru ge seyo vyew güdraw nüna nadra. ");
INSERT INTO hru_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","No küĝüjome se vyemsodaw ge bachi üdra ayo na hadamje uw ñu ge danghusajo dawe ha ye Jisu Masi ichi yo ñidra dusama. ");
INSERT INTO hru_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Hado cheme noñuwwa, nó bachi nülvo yo ŝüpyo lüshüw seyo ĝüdzüw padame, sündada, ba yo dañe güdraw nüna nadrü-nalu hu je adjüdjüw no je aĝimiw pajome, uñuw nawa. ");
INSERT INTO hru_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Sündada sedamje noje Jisu ge ŝüpyo bolu duda, se ha ñu ye udama, se í bá dügyejo. ");
INSERT INTO hru_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","Sedamje no vyeduw mukro Polus i se yabó Jisu Masi ibó pache ge ĝyow nüna babi, se ayoje ŝüpyo nülvo yo ibó küĝüjolu. ");
INSERT INTO hru_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","No nosaw Tawgyew go Unesumus ibó no yo nochi sülyeñtchü ge sakülye dame no yo küĝüime. ");
INSERT INTO hru_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Se ibó ahuge ha madaĝiw a ba, se yabó ba ñe seyo nochi dew chiĝa tsüwbaba. ");
INSERT INTO hru_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Se í ñe seyo dju nolu ge kadama, no se í bachi ge djütülütchowba. ");
INSERT INTO hru_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Í no nochi ge vyejoñe vyehomacha se í bó bachi vye go shüdabi shi-ñu ibó yo sülyeñtchü sumbo, nó datunowe. ");
INSERT INTO hru_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Sé no ba mahusüw haje madaĝoñ se bachi he nülvo djüdo ye datüdalüw yo mow lüshüw dawe. ");
INSERT INTO hru_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Hado chemeje ha danghuñda i ba yo ksühua dzühua kuw he ibó utro lyadawa shüwa bañisa ge ĝyojoñe. ");
INSERT INTO hru_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Seŝo ayogo kulo mavyeduw, kulo yo je dewfo, seyo ñuw vyeduw ĝyowe se nochi drü-lü ge duw süna nülvobó seŝo, se yabó usofu ge je seyo ĝulo ge je, bachi je drü-lu ge sünda Tawgyew ge. ");
INSERT INTO hru_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Senameje ba nó bachi nudzoĝ dakyetunowñe vyedameje, se na vyeduw yo shutrolajodawe. ");
INSERT INTO hru_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Chemeje se nó bachi ha damje damdalyoama semome sa a bachi ha damje a kakuw, se í nochi üñiñi ge ĝiwe. ");
INSERT INTO hru_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Polus no nó gzü yo ĝijome, se i no bá ĝigujome; seyo ichi chejoje ha madaĝi, se no añawa he daado na badru me se i babamme. ");
INSERT INTO hru_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","He no ñuwwa, he lüshüw nó bachi Tawgyewwa nó bachi go pawe, Tawgyew ge nodrü nolu ye hu je adjüdjüw no je aĝimiw daiwe. ");
INSERT INTO hru_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","No bachi dügyew dafiw dajo umsow vyyeñe, bá ĝimkoime seyo he ana danghuwme, se no ha cheima, ba se í foje lübzüw daijo. ");
INSERT INTO hru_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Seyo he i je, nobó ĝyojo buĝo dashütrüvowe; no süna umsow vyedame, se bá küĝüw trüdu yo noje no bachi ügzü ge djüjome. ");
INSERT INTO hru_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Ifras se Jisu ge nodra pacheshüw ge ");
INSERT INTO hru_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Seyo se Markus ñe Aristikurs seyo Demas seyo Luka seyo no chiĝadam. ");
INSERT INTO hru_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Ñichi Prabu Jisu Masi nülvow ye bachi ĝulodra duwe. Amin.");
ALTER TABLE hru_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
