﻿USE sofia;
DROP TABLE IF EXISTS sofia.hrebt_vpl;
CREATE TABLE hrebt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hrebt_vpl WRITE;
INSERT INTO hrebt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Xinoe da Jesus Christ, kon xau bùa Đawit, kon xau Apraham. ");
INSERT INTO hrebt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apraham baq da Ysac, Ysac baq da Jacôp, Jacôp baq da Juđa xam wì oh haq. ");
INSERT INTO hrebt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juđa baq da Pharê xam Sara, Thama aih miq wa haq. Pharê baq da Êch rôm, Êch rôm baq da Aram, ");
INSERT INTO hrebt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram baq da Aminađap, Aminađap baq da Na-ach son, Na-ach son baq da Sanh môn. ");
INSERT INTO hrebt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sanh môn baq da Bô-ô, miq da haq aih Rahap, Bô-ô baq da Ôbet, miq da haq aih Ruto, Ôbet baq da Jêse, Jêse baq bùa da Đawit. ");
INSERT INTO hrebt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Đawit baq da Salômôn, miq haq aih mai Uri. ");
INSERT INTO hrebt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salômôn baq da Rôbôam, Rôbôam baq da Abija, Abija baq da Asa ");
INSERT INTO hrebt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa baq da Jôsaphat, Jôsaphat baq da Jôram, Jôram baq da Ôxia. ");
INSERT INTO hrebt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ôxia baq da Jôtam, Jôtam baq da Acha, Acha baq da Êxêchia. ");
INSERT INTO hrebt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Êxêchia baq da Manase, Manase baq da Amôn, Amôn baq da Jôsia. ");
INSERT INTO hrebt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jôsia baq da Jêchônia xam wì oh haq, jò wì lam broq dìc ta Babilôn. ");
INSERT INTO hrebt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jò khoe lam broq dìc ta Babilôn, Jêchônia baq da Sala thi-ên, Sala thi-ên baq da Xôrôbabên, ");
INSERT INTO hrebt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Xôrôbabên baq da Abi-ut, Abi-ut baq da Êliakim, Êliakim baq Axô. ");
INSERT INTO hrebt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Axô baq da Sađoc, Sađoc baq da Achim, Achim baq da Êli-ut, ");
INSERT INTO hrebt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Êli-ut baq da Êlê-axa, Êlê- axa baq da Mathan, Mathan baq da Jacôp. ");
INSERT INTO hrebt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacôp baq da Jôsep, ŏng Mari. Mari mangai ma hauang Chuaq Jesus, aih raq Christ. ");
INSERT INTO hrebt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Qmang aih, patep enh Apraham trùh Đawit, dìq dŏng jah moeq jàt pôn qnhòng; patep enh Đawit trùh jò lam broq dìc ta Babilôn hanoh jah moeq jàt pôn qnhòng; pang jò lam broq dìc ta Babilôn trùh Chuaq Jesus Christ, hadai jah moeq jàt pôn qnhòng. ");
INSERT INTO hrebt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bìac ma hauang ka Chuaq Jesus aih rameh, Mari miq haq, khoe tèu bàu yŏc Jôsep, mahaq qnhòq acaq oe moeq qmang ti dabau, yàng aih haq khoe hadràp enh Yeang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jôsep ŏng haq aih mangai i manoh, ùh enh dôq haq pòq bàu qmèq, ta manoh haq khoe hèm ka cađac ma haq broq qmang leq ma ùh hìaq ta-uàng. ");
INSERT INTO hrebt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mahaq, jò haq qnang hèm trùh trong aih, i moeq bình plình Chuaq trùh ti haq jò haq apô, doe ka haq: “Jôsep, kon xau Đawit, ìh apaq hòq ka yŏc Mari broq mai, ma jah qmang aih kon haq ma hadràp qmat trùh enh Yeang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Haq aih èh ma hauang loh moeq ngai kon calô, ìh yiniq am ka haq Jesus. Kon calô aih èh ma jah dèch dèh mangai loh khoe ka yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Rìm yiniq khoe loh qmang aih dôq xìt troeq bàu Boc plình ma thê ƀài mangai pajàu haq khoe anoe: ");
INSERT INTO hrebt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kô oq, i mòeq ngai adrùh sriu chìuq hadràp, èh ha-uang mòeq ngai kon calô, Khoe aih wì yiniq ka haq Imanuli” (aih la Boc plình oe ti bèn). ");
INSERT INTO hrebt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jò Jôsep khoe cadrat enh kùi, haq broq tiaq bàu ƀình plình Chuaq ma khoe thê, ahlài Mari broq dèh mai. ");
INSERT INTO hrebt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mahaq ùh kùi oe ti da bau trùh jò Mari ha-uang mòeq ngai kon calô, haq hi yiniq ka kon aih la Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jò Chuaq Jesus khoe ha-uang ta Bêtlêhem, gùng Juđê, qnhòng aih Hêrôt broq bùa, ƀài ƀŏcsi oe gùng mahì loh, trùh ta Jêrusalem ");
INSERT INTO hrebt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","bòch rameh: Bùa da mangai Juđa ma neo ha-uang oe taleq? Nhèn khoe hnoq halŏng Haq oe pah gùng mat mahì loh, kô ìq nhèn majah khoe trùh đòeq kùh waiq haq. ");
INSERT INTO hrebt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tàng bàu aih bùa Hêrôt xam dìq mangai oe ta Jêrusalem dìq jaq crè hamàih ");
INSERT INTO hrebt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Bùa creo ka ƀài broq cla craq pajàu xam mangai hnài ranenh ta aih, haq bòch: Christ kô ìq ha-uang taleq? ");
INSERT INTO hrebt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wì padreo bàu: Oe ta bêtlêhem gùng Juđê majah qmang aih khoe i bàu pajàu achìh rameh: ");
INSERT INTO hrebt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ìh, Bêtlêhem, gùng Juđê. Joq qnàng ìh ùh i yeo hamoq ka ƀài plài ma kàn ta gùng Juđê, Majah qmang aih, enh ìh kô èh loh mòeq ngai broq Cla craq. Haq aih ma wèq ban Isorali, aih mangai da au.” ");
INSERT INTO hrebt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bùa Hêrôt creo atùng ka ƀài ƀŏcsi, bòch panhìn halŏng khoe loh jò leq. ");
INSERT INTO hrebt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Khoe èh bùa thê wì aih lam ta Bêtlêhem, rai tanap: Pì drah lam beq, taƀoe chaq kon qyoh aih ma ro haq, jò pì khoe hnoq, patìn ka au loq diq, dôq au hadai trùh hu kùh waiq haq. ");
INSERT INTO hrebt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Khoe ka ƀàu bùa thê, wì loh lam. Hatau, halŏng wì haq ma khoe hnoq enh gùng mat mahì loh, lam adroe ka wì haq trùh nòe kon qyoh oe men waq yòng. ");
INSERT INTO hrebt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wì aih hnoq halŏng, manè oe i jaq cleq. ");
INSERT INTO hrebt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jò khoe mùt ta hnem, hnoq kon qyoh xam Mari miq haq, tajòe qmòe wì haq hacùn cràng ta haqneq đòeq kùh waiq. Khoe aih qnoh deh hang canaq dèch am ka haq: Wang, gahnàu, dàu xua thùm. ");
INSERT INTO hrebt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Khoe aih, jò apô Boc plình doe ka wì haq apaq wìh hlài dèh ta Hêrôt, wì aih hi tawìh trong qnoeq hu bròc dèh gùng. ");
INSERT INTO hrebt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jò wì aih khoe lam, i moeq bình plình da Chuaq trùh ti Jôsep, jò haq apô, doe rameh: “Drah yòng beq, qnung kon qyoh qmat hloe xam miq haq lam amot ta diac Êdip, oe ta aih trùh jò leq au creo ka ìh, majah qmang aih kô èh bùa Hêrôt chaq jêh đac kon qyoh qmat. ");
INSERT INTO hrebt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jôsep drah yòng, jò oe raq damang, qnung wa miq kon lam ta diac Êdip. ");
INSERT INTO hrebt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Haq oe ta gùng aih trùh jò Hêrôt cachìt, dôq xìt ka bàu Chuaq ma khoe thê dèh ƀài pajàu tapoch: “Au khoe creo dèh ka kon loh enh diac Êdip.” ");
INSERT INTO hrebt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bùa Hêrôt hnoq ƀài ƀŏcsi khoe qnùt rađeh, haq nòeh pi ka jaq, haq thê jêh ka cachìt dŏng qyoh calô pang baiq hanam dang loh oe ta Bêtlêhem hloe xam dìq dŏng ka kon qyoh ta cròng aih. Tiaq troq hì troq khê ƀài ƀŏcsi ma khoe am haq loq. ");
INSERT INTO hrebt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Qmang aih, khoe xìt troeq bàu Jêrêmi pajàu Boc Plình ma khoe anoe: ");
INSERT INTO hrebt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Wì tàng bàu breo, cajiah. Ta-oeh, hmoe tagùng Rama Aih bàu Rachen hmoe dèh ka wì kon Mahaq ùh dôq cabô alòng rađeh, majah qmang aih wì haq khoe pi i. ");
INSERT INTO hrebt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mahaq khoe ka bùa Hêrôt cachìt, i moeq bình plình Chuaq trùh ti Jôsep jò haq apô, jò oe ta diac Êdip, thê rameh: ");
INSERT INTO hrebt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Drah yòng beq, qnung kon qyoh hloe xam miq haq hlài tagùng Isorali, majah qmang aih mangai ma chaq jêh đac kon qyoh qmat khoe cachìt.” ");
INSERT INTO hrebt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jôsep drah yòng, qnung kon qyoh xam miq haq wìh hlài gùng Isorali. ");
INSERT INTO hrebt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mahaq, jò tàng doe Achêla-u broq bùa thai dèh baq haq aih Hêrôt, qnang wèq gùng Juđê, Jôsep loh ka crè pi hùa hlài ta aih, qnah hòm Boc plình khoe anoe jò haq apô, haq hi mùt ta gùng Galili, ");
INSERT INTO hrebt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","lam rìh oe ta plài Naxaret. Qmang aih khoe xìt troeq bàu ƀài pajàu Boc Plình ma khoe anoe adroe: “Wì creo ka Haq mangai Naxaret.” ");
INSERT INTO hrebt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jò aih, Jon Baptit trùh tanòe hawit gùng Juđê hnài bàu lem ");
INSERT INTO hrebt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","rameh: “Drah loq raxach beq! majah qmang aih diac plình trùh khoe haten” ");
INSERT INTO hrebt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon Baptit aih raq mangai pajàu Êsai ma khoe anoe: “I bàu creo tanòe hawit: Drah padon trong am ka Chuaq, Broq ma tamang trong da Haq”. ");
INSERT INTO hrebt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon caxùnh eo broq enh xàc lŏcđa, kàt caxy qnam broq xam akia, acaq toq lìp xam diac xùt ta rôm wang. ");
INSERT INTO hrebt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jò aih, dìq dŏng ka mangai ma oe ta Jêrusalem, xam dìq dŏng mangai oe gùng Galili, hloe xam gùng trong cròng diac Jôđan trùh dìq ti haq. ");
INSERT INTO hrebt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jò wì khoe paqnoh dèh yiniq lui, wì dôq haq broq ƀaptem ka rađeh ta cròng diac Jôđan. ");
INSERT INTO hrebt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mahaq jò haq hnoq bàc ngai nang noe Pharisi xam mangai Sađusê trùh đòeq hu jah broq ƀaptem, haq doe: Ƀài nang noe bìh plŏng meh, cabô hnài pì ma khoe loq wia đeh ka kan noèh hì atìq meh? ");
INSERT INTO hrebt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Qmang qmat, thê pì loh plì lem, dôq ùh hìaq qngwan ka pì ma khoe loq raxach, ");
INSERT INTO hrebt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","èh apaq catèh: “Apraham aih kan cadraq nhèn, majah qmang aih au doe ka pì, enh hmo kô, Boc plình thê haq loh nang noe ka Apraham dua jah. ");
INSERT INTO hrebt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Manòeq kô, chòng khoe roh đòeq jang xèm long, long leq ma ùh loh plì lem, long aih èh kau hu bùh đac. ");
INSERT INTO hrebt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Da au kô, au yŏc diac broq ƀaptem am ka pì, mahaq i Mangai ma trùh atìq ka au, haq aih cwìang yeo haqnhèq ka au, au kô ùh tajì ka jah broq mangai wê da haq jep. Haq aih èh ma broq ƀaptem ka pì xam Yiang Hadròeh xam ùnh. ");
INSERT INTO hrebt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tì Haq wê tŏnh đòeq hu dè palem dèh qmau ta haneh, lênh qmau Haq don đòeq ta hapom, manùh bùh ta ralùng ùnh ùh pat.” ");
INSERT INTO hrebt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jò aih, Jesus loh enh gùng Galili trùh ti Jon oe ta cròng diac Jođan, dôq Jon broq ka rađeh ƀaptem. ");
INSERT INTO hrebt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mahaq Jon hangah rameh: Au kô ma khòh dôq Ìh broq ƀaptem ka rađeh, hagleq Ìh majah trùh glòq ti au? Chuaq Jesus padreo bàu: ");
INSERT INTO hrebt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Manòeq kô broq beq, bèn khòh broq ma gêh geo trong taq atoq qmang qmat. Jon hi broq tiaq ƀàu Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Broq ƀaptem bu khoe, Chuaq Jesus loh khoe ka diac, tajòe qmòe diac plình tapèh, Chuaq Jesus hnoq Yiang Hadròeh Boc Plình, tìah ka trù pan loh jràp ta chac Haq. ");
INSERT INTO hrebt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","I bàu enh plình doe: “Kô kon da au, mangai au ma loq waq dèh, lem manoh au rìm trong.” ");
INSERT INTO hrebt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Khoe aih, Yiang Hadròeh qnung Chuaq Jesus mùt tanòe gùng hawit, dôq kan kiac padô qnùt Haq. ");
INSERT INTO hrebt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chuaq Jesus apàm ka acaq pôn jàt hì, pôn jàt mang, khoe aih haq loh qmòe ka hrah. ");
INSERT INTO hrebt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kan kiac trùh ajang Chuaq, haq doe: Tàng joq ìh kô kon Boc Plình, thê hmo kô wìa ƀênh beq. ");
INSERT INTO hrebt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Chuaq Jesus doe: “Khoe i bàu achìh rameh: Mangai rìh ùh xài canòm toq ka ƀênh, mahaq canòm rìm nà loh enh bàu Boc Plình”. ");
INSERT INTO hrebt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kan kiac qmùt Chuaq Jesus tanòe plài hadròeh, atŏc Haq nòe poc hnim kùh waiq, ");
INSERT INTO hrebt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","rai doe: Tàng joq ìh kon Boc plình, caqnìh rađeh beq, ajoq khoe i bàu achìh rameh: “Chuaq thê ƀài ƀình plình wèq ìh: Wì aih hi dèch ìh ta xŏng, Aih èh jènh ìh ùh i catoeh ka hmo”. ");
INSERT INTO hrebt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chuaq Jesus doe: “Hadai i bàu achìh rameh: Ìh ùh khòh ti qnhro ngan Chuaq aih Boc Plình ìh.” ");
INSERT INTO hrebt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kan kiac atŏc Haq ta wang haqnhèq hòm, patô ka Haq ƀài diac oe crŏng taneh xam kan rahù ranhòm ƀài diac aih, ");
INSERT INTO hrebt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","haq anoe: Tàng joq ìh kùn cràng kùh waiq enh ngèa au, ƀài diac qmat au am dŏng ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chuaq Jesus tapoch ka haq: “Satan wia ma khoe ka au beq, majah qmang aih i bàu khoe achìh: Ìh ep kùh waiq Chuaq aih Boc Plình ìh, rai patìh toq ka haq raq. ");
INSERT INTO hrebt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Khoe aih Kan kiac hi lam, i ƀình plình trùh haten patìh ka Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jò Chuaq Jesus tàng doe wì khoe rùp clêh Jon, haq wìh hlài ta gùng Galili, ");
INSERT INTO hrebt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Haq ùh oe ta Naxaret, mahaq lam oe ta Cabênaum, haten diac raxìq, hatìa ka gùng Sabulôn, gùng Neptali. ");
INSERT INTO hrebt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dôq xìt troeq bàu pajàu Êsai ma khoe doe: ");
INSERT INTO hrebt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Taneh Sabulôn xam Neptali, Oe ti trong loh ta diac raxìq, pah tau cròng diac Jođan, Aih gùng Galili mahaq ùh xài mangai Juda…, ");
INSERT INTO hrebt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wì aih hangui tanòe clam cluiq, Khoe jah hnoq kan qngah kàn; Xam ƀài mangai ma hangui enh caqnàm qmù kan cachìt, Kan qngah kàn khoe tŏc ka wì aih.” ");
INSERT INTO hrebt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pang aih, Chuaq Jesus hi lam hnài: “Loq raxach beq, diac Plình trùh khoe haten.” ");
INSERT INTO hrebt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jò Haq qnang lam roc haqmai diac raxìq Galili, hnoq wa baiq ngai oh daq, Simôn (ma loq creo Phiero) xam oh haq Anrê, qnang tang hlàm ta diac raxìq, majah qmang aih wa aih dìq mangai ranang ka. ");
INSERT INTO hrebt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Haq doe ka wa: “Lam tiaq Au beq, au hu thê chôp lam tang hlàm mangai.” ");
INSERT INTO hrebt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tajòe qmòe wa oh daq cađac hlàm, lam tiaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Lam yeo hangai ka aih, Jesus hnoq baiq ngai wa oh daq maqnoeq hòm, Jaco kon Sêbêđê xam oh haq aih Jon, qnang hmình hlàm taboang ti Sêbêđê baq wa haq, Chuaq hi creo ka wa. ");
INSERT INTO hrebt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tajòe qmòe wa haq hi đòeq boang xam dèh baq wa haq, hu lam tiaq Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Chuaq Jesus lam jàp gùng Galili, hnài roc hnim tagop, anoe bàu lem diac Boc Plình, rai broq brêh ka mangai yinìq ta gùng aih. ");
INSERT INTO hrebt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Qmang aih, yiniq haq wì hìa jàp jìa gùng Syri, wì aràng ka haq ƀài mangai ùh hrŏc, mangai yinìq, mangai kiac pawè, ranhùa, mangai pen. Haq broq brêh dìq dŏng ka wì aih. ");
INSERT INTO hrebt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Èh hòm, patep enh gùng Galili, Đêcabôlo, gùng Jêrusalem, enh gùng Juđê, trùh hloe pah tau cròng diac Jôđan, wì ti adràc dabau bàc haraya lam tiaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jò Chuaq Jesus hnoq mangai bàc, haq hi tŏc ta wang, jò haq khoe hangui, ƀài mangai tiaq hŏc thia haten ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Haq hi tapoch đòeq hnài wì: ");
INSERT INTO hrebt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Xôq ramot am ka ƀài mangai xalep ta manoh, majah qmang aih diac plình aih da wì haq! ");
INSERT INTO hrebt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Xôq ramot am ka ƀài mangai crò hmoe, majah qmang aih wì haq jah alòng! ");
INSERT INTO hrebt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Xôq ramot am ka ƀài mangai loq kèm, majah qmang aih wì haq jah taneh! ");
INSERT INTO hrebt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Xôq ramot am ka ƀài mangai pangot kan taq atoq, majah qmang aih wì haq jah panàc! ");
INSERT INTO hrebt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Xôq ramot am ka ƀài mangai ma loq ha-och, majah qmang aih wì haq jah ha-och chau! ");
INSERT INTO hrebt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Xôq ramot ka ƀài mangai i manoh hliang hadròeh, majah qmang aih wì haq jah hnoq Boc Plình! ");
INSERT INTO hrebt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Xôq ramot ka ƀài mangai broq ka wì hatroq, majah qmang aih jah creo ka wì haq aih kon Boc Plình! ");
INSERT INTO hrebt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Xôq ramot am ka ƀài mangai lam tiaq trong taq atoq, chìuq dôq qmòe wì rùp rađeh, majah qmang aih wì haq jah waq diac Plình! ");
INSERT INTO hrebt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Xôq ramot am ka pì, jò wì hnap hnuq ka pì, rùp pani rai yŏc trong dù capoch haƀo ka pì, taiq pì tiaq au. ");
INSERT INTO hrebt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Drah lem bùi rai tadèch qmoè cliac manè, qmang aih kan baha pì oe ta Plình kàn haraya, majah qmang aih wì hadai khoe hmaq rùp ƀài pajàu yiang adroe ka pì qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Pì kô boh da crŏng taneh, mahaq tàng boh aih pi xang, aih èh yŏc cleq broq dôq haq jah xang hlài, boh aih oe broq cleq ma oe wìa, ep hrôq đac enh gùng, èh wì hi jôiq đac enh caqnàm jènh. ");
INSERT INTO hrebt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Pì kô kan qngah da crŏng taneh kô, mòeq toq plài broq ta wang, ùh jò leq i cleq jah hanàp đac haq. ");
INSERT INTO hrebt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hadai qmang aih, ùh i cabô bùh đen ma đòeq enh qneq ka cađap, mahaq wì dèch đòeq nòe haqnhèq, dôq haq hu sreo qngah ka rìm ngai oe ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kan qngah pì drah sreo enh ngèa wì qmang aih diq, dôq wì jah hnoq ƀài kan lem enh pì, wì hu manè Baq ƀài pì oe ta Plình. ");
INSERT INTO hrebt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Pì apaq hèm au trùh đòeq hu raliang đac ranenh xam ƀài bàu pajàu; au trùh, ùh xài hu raliang, mahaq đòeq hu pagêh. ");
INSERT INTO hrebt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Au doe qnàng ka pì, jò plình crŏng taneh kô oe raq, yac ka moeq teo, moeq pliang chù, ma yi qyoh oe ta ranenh dua ùh hnhung, dua waq ka gòm trùh hì rìm yiniq jah gêh. ");
INSERT INTO hrebt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Qmang aih, mangai leq raliang đac mòeq yiniq ma yeo qyoh dìq dŏng ta ƀài ranenh kô, rai hnài wì qnoeq broq tiaq, mangai aih èh wì doe haq mangai yeo qyoh dŏng oe ta diac plình, mahaq mangai leq wèq ranenh aih, rai hnài wì qnoeq broq tiaq, mangai aih èh wì doe haq mangai yeo kàn tanòe diac plình. ");
INSERT INTO hrebt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Majah qmang aih, au doe qnàng ka pì, tàng joq kan taq atoq pì ùh yeo haq nhèq ka kan taq atoq da ƀài thài hnài ranenh xam mangai Pharisi, pì ùh jah mùt diac plình. ");
INSERT INTO hrebt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Pì i tàng bàu ma doe ka wì craq calah nèh: Ìh ùh khòh jêh đac mangai, èh hòm cabô ma jêh đac mangai, haq aih ep pòq kan hadrah. ");
INSERT INTO hrebt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yàng Au doe ka pì: “Waq toq cabô nòeh dèh ka oh daq, haq aih khoe wìa dôq ka wì tah hadrah ka haq, cabô hnap dèh ka oh daq: Raca, ep qnoh haq aih tanòe hadrah kàn dôq wì hu hadarh ka haq, cabô lech dèh ka oh daq: Ranhùa, haq aih khoe khòh dôq ùnh oe ta hwinh baxa haq. ");
INSERT INTO hrebt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Aih ìq, jò leq pì aràng dèch ramènh tadreo tanòe prang, mahaq hmàng hlài oh daq i yiniq cleq ma ùh troq ka rađeh, ");
INSERT INTO hrebt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","drah đòeq ramènh aih enh ngèa ka prang tawìh hlài broq hatroq ka oh daq òeq, khoe hi lam dèch ramènh tadreo. ");
INSERT INTO hrebt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Jò ìh lam trong ti mangai tah hadrah ka ìh, drah hatroq hôiq, tabeq haq qmùt ìh ta cwan hadrah, cwan aih aràng ìh ta cwan lình, qmang aih wì loq rùp clêh ìh, ");
INSERT INTO hrebt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Au doe qnàng ka ìh, ìh caqnaih oe thìuq moeq đùng dua ìh qnhòq jah loh enh aih.” ");
INSERT INTO hrebt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Pì tàng bàu cô: “Ùh dùh tango.” ");
INSERT INTO hrebt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mahaq Au doe ka pì: “Mangai leq haqmiang mangai cadrì, ta manoh khoe hèm ùh wìa, haq aih khoe tango ta manoh. ");
INSERT INTO hrebt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Qmang aih tàng joq mat pah qma broq ka ìh loh kan yiniq lui, qngwia khwên cađac ma hangai ka ìh, dôq haq yac ka moeq qnah ta chac ìh pi tôm, aih dua ùh hnau dìq ka chac clìh ta hwinh. ");
INSERT INTO hrebt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tàng joq tì pah qma basrùq ìh broq yiniq lui, pot khwênh đac ma hangai ka ìh dôq haq moeq qnah ta chac ìh raliang, ùh hnau dìq ka chac clìh ta hwinh.” ");
INSERT INTO hrebt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","I bàu doe rameh: Tàng joq mangai leq cađac mai, ep achìh jàiq đòeq broq ƀò akang. ");
INSERT INTO hrebt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mahaq au doe ka pì: “Mangai leq cađac mai, mahaq ùh xài taiq haq tango, mangai aih broq dèh ka mai loh mangai i tuiq tango, èh hòm, cabô yŏc gùcadrì wì cađac, haq aih hadai i tuiq tango.” ");
INSERT INTO hrebt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Pì tàng bàu doe ka wì craq calah nèh: ùh khòh loq hapah paqnùt, mahaq ajang Chuaq, ep wèq dèh bàu cla khoe hapah, ");
INSERT INTO hrebt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mahaq au anoe ka pì rameh: “Ùh dùh hapah cadèh, apaq patô trŏc hu hapah, aih xài gèq Boc Plình, ");
INSERT INTO hrebt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ùh dùh patô taneh hu hapah aih xài nòe Boc Plình roh jènh, ùh dùh patô Jêrusalem hu hapah, aih xài plài Bùa kàn. ");
INSERT INTO hrebt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ùh dùh patô dèh gàu hu hapah, majah qmang aih mòeq hadrang xàc gàu, cla pì broq dôq haq loh ka taboc loh ka gam dua ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mahaq pì ep doe rameh: “Joq joq, ùh ùh”. Ƀài bàu wì ma tapoch tam aih, dìq loh enh kiac dù. ");
INSERT INTO hrebt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Pì tàng bàu doe rameh: Mat am hlài mat, hanenh am hlài hanenh, ");
INSERT INTO hrebt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yàng au doe ka pì: “Ùh dùh àu tablêq ka mangai dù, mahaq tàng i cabô tep tabŏc pah qma, pì tawìh am hloe ka wì tabŏc pah qngeo, ");
INSERT INTO hrebt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tàng i cabô enh tah hadrah ka ìh đòeq chaq trong lêh yŏc da pì eo đêq, dôq haq wì yŏc hloe xam eo yôh enh gùng; ");
INSERT INTO hrebt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","tàng i cabô thê pì lam moeq apot trong ti wì haq, pì lam baiq apot trong ti wì. ");
INSERT INTO hrebt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Cabô bòch pì cleq, am beq, cabô enh bòch đò da pì cleq, apaq hwi đac ta qnoeq.” ");
INSERT INTO hrebt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Pì lah tàng wì doe qmang kô: Thê loq waq ka mangai haten hatìa ka pì, git ka mangai tablêq ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yàng Au doe ka pì rameh: “Thê loq waq ka mangai git ka pì, rai waiq khàn ka mangai ma loq rùp baxa pì. ");
INSERT INTO hrebt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dôq pì jah broq kon Baq pì oe ta plình, majah qmang aih Haq broq mat mahì tŏc đòeq sreo ka mangai dù xam mangai lem, broq mè ka mangai lem xam mangai dù. ");
INSERT INTO hrebt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tàng pì loq waq toq ka mangai ma loq waq ka pì, aih èh pì jah baha cleq? Ƀài mangai ma yŏc thèq ma ùh hadai broq qmang aih? ");
INSERT INTO hrebt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tàng pì đìh dèh toq oh daq, aih i crài cleq ka wì qnoeq? Ƀài wì enh gùng ma ùh hadai broq qmang aih? ");
INSERT INTO hrebt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Qmang aih, pì ep geo rìm trong qmang ka Baq pì oe ta plình geo rìm trong.” ");
INSERT INTO hrebt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Rabiaq oq, apaq broq bìac taq atoq cla rađeh enh ajang mat wì qnoeq waq ka wì hnoq. Tàng ùh meh, Baq pì oe ta plình ùh baha ka pì cleq. ");
INSERT INTO hrebt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Qmang aih, jò pì tabàih, paq hlui taliaq enh ngèa dèh cla, troeq ƀài mangai toq ti patìah ma loq broq nòe hnim tagop, waq ka wì qnoeq hnoq rađeh. Joq qnàng Au doe ka pì, wì aih khoe jah qmòe dèh kan baha. ");
INSERT INTO hrebt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mahaq jò pì taƀàih, apaq dôq pah qngeo loq tì pah qma broq cleq, ");
INSERT INTO hrebt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","dôq kan tabàih aih jah hlèp; Baq pì, aih Mangai xau hnoq tanòe hlèp, aih èh haq ma baha ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jò pì waiq khàn, apaq broq qmang ka ƀài mangai toq ti patìah, wì haq enh toq yòng waiq khàn tanòe hnim tagop, tanòe trong lam, đoèq dìq ka phù cròng mangai hnoq đeh hra. Joq qnàng Au doe ka pì, wì aih khoe jah qmòe dèh kan baha. ");
INSERT INTO hrebt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mahaq jò pì waiq khàn, mùt dèh ta bluàng, clòng qmang, khoe aih hi waiq khàn dèh ka Baq pì, oe ta nòe hlèp aih, Baq pì aih Mangai xau hnoq tanòe dìq jaq hlèp, aih èh ma baha ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jò pì waiq khàn, ùh dùh yŏc bàu capoch lauq capoch clò ùh loh qmòe ranenh troeq wì enh gùng, majah qmang aih wì haq xoh đeh capoch bàc aih i mangai tamàng. ");
INSERT INTO hrebt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Qmang aih, pì apaq top dua wì haq, Baq pì khoe loq pì qnang enh cleq adroe ka pì bòch Haq. ");
INSERT INTO hrebt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Qmang aih pì waiq khàn rameh: “Waiq Baq nhèn oe ta plình; Yiniq Baq jah hadròeh; ");
INSERT INTO hrebt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Diac Baq jah trùh; Manoh Baq jah gêh, oe ta crŏng taneh tìah ka oe ta plình! ");
INSERT INTO hrebt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Am ka nhèn dahwèq acaq qnang lem ka hì kô; ");
INSERT INTO hrebt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cađac da nhèn yiniq lui, qmang ka nhèn cađac ka mangai broq yiniq lui ka nhèn; ");
INSERT INTO hrebt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Paq dôq nhèn clìh ta kan padô qnùt, dèch nhèn claih enh kan dù! (Majah qmang aih: diac, kan itai, kan ranhòm, oe dìq ta Baq mòeq đòe.) ");
INSERT INTO hrebt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Majah qmang aih, tàng joq pì cađac yiniq lui mangai qnoeq ma broq ka pì, Baq pì oe ta plình hanoh cađac yiniq lui da pì. ");
INSERT INTO hrebt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mahaq tàng joq pì ùh cađac yiniq lui wì qnoeq, Baq pì oe ta plình hanoh ùh cađac da pì yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jò pì apàm ka acaq, apaq broq dèh mangò troeq ƀài mangai toq ti patìah, wì aih broq dèh ma haqnhuaq ta mùh mat, waq ka wì qnoeq loq ka wì haq apàm ka acaq, Joq qnàng au doe ka pì, wì aih khoe jah qmòe dèh kan baha. ");
INSERT INTO hrebt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yàng jò ìh apàm ka acaq, xùt dàu ta gàu, qmùq mat. ");
INSERT INTO hrebt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Dôq wì qnoeq ùh hìaq loq pì qnang apàm ka acaq, mahaq toq Baq ìh mangai ma xau hnoq tanòe, aih èh haq ma hu baha ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Pì apaq don đòeq kùng hang oe crŏng taneh, aih nòe i catia, i kan axiang loq broq haq om cađac èh mangai atùng loq kŏch radua, chìa panàt hu yŏc atùng, ");
INSERT INTO hrebt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","mahaq ep don đòeq ta plình, nòe aih ùh i ka catia, ùh i kan axiang pa-om cađac, ùh i mangai atùng chìa panàt, kŏch radua hu atùng. ");
INSERT INTO hrebt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Majah qmang aih, kùng hang pì oe taleq, manoh cliac pì hadai oe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mat aih đen da chac hamac. Tàng joq mat ìh qngah lem, aih dìq ka chac pì jah qngah, ");
INSERT INTO hrebt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","tàng mat ìh ùh lem, dìq chac hamac ìh loh dŏng ka clam cluiq. Qmang aih, tàng joq kan qngah oe ta ìh aih loh ka clam cluiq, aih èh kan clam kô kàn dàng leq! ");
INSERT INTO hrebt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ùh bô jah broq hapŏng ka baiq toq craq, majah qmang aih haq loq git ka mangai kô èh loq waq ka mangai tau, ùh meh haq padèch mangai kô, mahaq jù cađac magai tau. Pì ùh jah rai broq hapŏng Boc Plình rai broq hapŏng Mamon. ");
INSERT INTO hrebt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Aih ìq Au ma jah doe ka pì: “Apaq taiq kan rìh rađeh ma lèt ka trong acaq ôq, hanoh apaq taiq chac hamac ma hu lèt ka rađeh caxùnh cleq. Kan rìh ma ùh yeo kàn ka dahwèq acaq, chac hamac ma ùh xài yeo kàn ka dahwèq caxùnh? ");
INSERT INTO hrebt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ngan chim oe ta trŏc: haq ùh i rai adrech, ùh i gat, hanoh ùh i don đòeq ta hapom aih dua Baq pì oe ta plình ban haq. Pì ma ùh xài yeo canaq ùh hnau ka chìm aih? ");
INSERT INTO hrebt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Qnah hòm, taqne pì qmat i ka cabô taiq haq loq lèt ma broq ka rađeh jah halình tam moeq ahyàc ùh? ");
INSERT INTO hrebt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Dahwèq caxùnh pì lèt dèh? Haqmiang ngan ƀài riang tacreo oe ta gùng honh qmang leq, ùh i abroq, ùh i caxênh brai, ");
INSERT INTO hrebt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","mahaq au doe ka pì, yac ka bùa Salômôn nhòm dàng leq, dua qnhòq lah caxùnh moeq blah eo leq ma lem dàng ƀài riang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pì qmat joq mangai ƀiaq manoh lùi, nhat oe tagùng, aih adrech hì kô oe rìh, hì da èh bùh ta ùnh. Boc Plình dua am haq caxùnh lem qmang aih, loq ka pì! ");
INSERT INTO hrebt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Qmang aih, pì apaq lèt đòeq hu doe: Bèn acaq cleq? Ôq cleq? caxùnh cleq? ");
INSERT INTO hrebt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Majah qmang aih, wì mangai enh gùng cadàu tiaq rìm yiniq aih, Baq pì oe ta plình khoe loq pì i yiniq waq ka ƀài trong aih. ");
INSERT INTO hrebt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mahaq adroe dìq dŏng, drah chaq diac Boc Plình xam kan taq atoq da Haq òeq, ƀài yiniq aih èh, brì ka Haq baha tam ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Qmang aih, apaq lèt dèh ka hì da èh, hì da èh đoèq da hì da èh. Kan xalep hì leq lap qmòe ka hì aih. ");
INSERT INTO hrebt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Pì apaq ti tah hadrah dèh ka wì qnoeq, dôq wì qnoeq hadai ùh hìa tah hadrah ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pì tah hadrah ka wì qnoeq qmang leq, wì hanoh tah hadrah hlài ka pì qmang aih, pì dèch ka wì dàng leq wì dèch hlài ka pì dàng aih. ");
INSERT INTO hrebt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hagleq pì hnoq khênh ta mat oh daq, mahaq ùh hnoq long tanòng ta mat cla? ");
INSERT INTO hrebt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gleq ma hùa doe ka oh daq: Dôq au doeh khênh loh khoe ka mat ìh, yàng ta mat cla i qmòe long tanòng? ");
INSERT INTO hrebt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wùih! Ƀài mangai toq ti patìah meh, angoe aih doeh long tanòng loh khoe ka mat cla òeq, khoe aih men xau hnoq đòeq hu doeh khênh ta mat oh daq. ");
INSERT INTO hrebt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Apaq khwênh ka koq ƀài dahwèq hadroèh, apaq caqnìh ngŏc enh ngèa ka chùa, beq haq jôiq cađac, khoe aih haq hwi hlài nhah glòq cla pì. ");
INSERT INTO hrebt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Bòch beq, aih èh hi jah, chaq beq, aih èh hi glàm, clôq qmang beq, aih èh qmang hi pèch. ");
INSERT INTO hrebt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Majah qmang aih, waq toq mangai leq bòch, mangai aih hi jah, mangai leq ti chaq mangai aih hi hnoq, mangai leq clôq qmang, qmang hi tapèch. ");
INSERT INTO hrebt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Taqne pì, i mangai leq jò kon bòch ƀênh mahaq pì am ka haq hmo? ");
INSERT INTO hrebt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tàng ùh meh, kon bòch ka mahaq pì am bìh? ");
INSERT INTO hrebt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Qmang aih, qmèq troeq pì qmat, xôq oe loq am dèh ka kon yiniq lem, loq ka Baq pì oe ta plình, Haq ma ùh am yiniq lem ka ƀài mangai leq creo bòch haqqmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Qmang aih, trong leq pì ma enh wì qnoeq broq ka rađeh, pì ep broq trong aih am ka wì, aih raq ranenh xam bàu pajàu. ");
INSERT INTO hrebt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Drah mùt qmang ma chit, majah qmang aih qmang ma kàn xam trong ma anòh qnung trùh ta kan lùng pac. ");
INSERT INTO hrebt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mahaq qmang qyoh, trong ùh anòh qnung trùh ta kan rìh, ƀiaq ngai raq chaq ma hnoq. ");
INSERT INTO hrebt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ngan oq, loq i ƀài pajàu patìah, ƀài mangai caxùnh caqmoc trìu lam trùh ti pì, mahaq enh dalam aih koq yiang toq ti kap hit. ");
INSERT INTO hrebt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pì ngan plì ma canau ka haq. Aleq lah i cabô git plì nho tanòe xèm yila, git plì pŏc tanòe xèm yila cađê? ");
INSERT INTO hrebt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Qmang aih, toq long lem men loh plì lem, long qmèq loh plì qmèq. ");
INSERT INTO hrebt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Long lem ùh jò leq loh plì qmèq, long qmèq hadai ùh jò leq loh plì lem. ");
INSERT INTO hrebt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Waq toq long leq ùh loh plì lem aih èh ep kau bùh cađac ta ùnh. ");
INSERT INTO hrebt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aih èh, pì ngan plì haq men canau ka wì haq. ");
INSERT INTO hrebt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ùh xài waq toq ka cabô hi creo ka au: Chuaq, Chuaq, aih dìq jah mùt diac plình, mahaq toq magai leq ma broq tiaq manoh Baq au oe ta plình. ");
INSERT INTO hrebt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hì aih èh i bàc mangai doe ka au: “Chuaq, Chuaq, ùh xài nhèn kô raq ma khoe hmaq canòm yiniq Ìh đòeq tapoch pajàu? Canòm ka yiniq Ìh đòeq drùh hnan kiac chŏc? Canòm yiniq Ìh broq bàc trong halac qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jò aih èh, au hi capoch hloh ka wì haq: “Wùih ƀài mangai broq trong dù meh, Au qnhòq lah qnì ka pì, drah wia khoe ka Au.” ");
INSERT INTO hrebt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Qmang aih èh, mangai leq tamàng rai broq tiaq bàu au anoe kô, haq aih tìah ka mangai rabiaq broq hnem ta crŏng hmo talech. ");
INSERT INTO hrebt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yac ka i mè dêh, i diac trùh, cayeo hlui, glàm caqnhùt hnem aih, dua ùh raliang, majah qmang aih haq khoe broq nòe hmo càn. ");
INSERT INTO hrebt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mahaq mangai leq khoe tàng bàu au anoe kô yàng ùh broq tiaq, haq aih budàng mangai ratùt broq hnem ta braih. ");
INSERT INTO hrebt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","I mè dêh, diac trùh, cayeo hlui, glàm caqnhùt ta hnem aih, hi ralàih, raliang bàc oe i jaq cleq. ");
INSERT INTO hrebt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jò Jesus bu khoe ka anoe bàu aih, ƀài wì dìq jaq hamàih ka bàu haq hnài, ");
INSERT INTO hrebt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Majah qmang aih bàu haq hnài tìah gleq i cwìang, ùh xài troeq da ƀài mangai hnài ranenh. ");
INSERT INTO hrebt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jò Chuaq Jesus loh enh bui wang, i ƀài mangai pi cajaq tiaq Haq. ");
INSERT INTO hrebt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","I moeq ngai bacùn thia haten rai kùh haq, rai doe: Waiq Chuaq, tàng joq Ìh ma waq, Ìh broq au brêh. ");
INSERT INTO hrebt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus hnhu tì bèq haq, rai doe: “Au waq, brêh beq.” Tajòe qmòe jò aih raq mangai bacùn jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chuaq Jesus tanap ka haq: “Ngan oq, ùh dùh anoe ka cabô, mahaq ìh lam patô rađeh ka ƀài pajàu kàn, rai dèch ramènh qmang ka Môise khoe hnài, hu panhìn ka wì aih. ");
INSERT INTO hrebt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jò Chuaq Jesus mùt ta plài Cabênaum, i moeq ngai cwan wèq lình trùh ti Haq, ");
INSERT INTO hrebt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","rai creo dang: Waiq Chuaq, mangai hapŏng au loh ka pen, kùi mòeq nòe ta hnim au, haq jìq pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chuaq Jesus doe: “Au lam ta aih hu broq ka haq jah brêh.” ");
INSERT INTO hrebt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Cwan aih padreo bàu: Waiq Chuaq, au kô ùh tajì ka jah đìh Ìh mùt dèh ta hnim, mòeq nà bàu Ìh tapoch raq, hapŏng au hi jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Majah qmang aih, au oe đeh enh qneq ka cwìang wì qnoeq, au hanoh i ƀài lình oe enh qneq ka au, au thê mangai kô: lam beq! haq aih hi lam. Thê mangai qnoeq: Drah trùh jang kô! mangai aih hi trùh, au thê dèh hapŏng: Drah broq yiniq kô, haq aih hi broq. ");
INSERT INTO hrebt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tàng bàu aih, Chuaq Jesus loh ka hamàih, haq doe ka ƀài mangai ma tiaq rađeh rameh: “Joq qnàng au doe ka pì, au qnhòq lah hnoq ta Isorali, i mangai leq i manoh lùi kàn qmang qmat. ");
INSERT INTO hrebt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Au anoe hloe ka pì, i bàc ngai enh gùng mat mahì loh, enh gùng mat ma hì clìh, trùh hangui acaq pajùm moeq aniang ti Apraham, Isac, Jacôp, tanòe diac plình. ");
INSERT INTO hrebt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yàng ƀài kon cla diac aih, wì khwênh qnoh đac enh gùng tanòe clam cluiq, ta aih èh i toq kan crò hmoe, ta- oeh, cadrit hanenh. ");
INSERT INTO hrebt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chuaq Jesus doe ka cwan aih: “Hlài beq, ìh jah tìah dèh ka manoh ìh ma khoe lùi aih.” Wop jò aih raq, mangai hapŏng haq jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Khoe aih, Chuaq Jesus mùt ta hnim Phiero, hnoq miq mai Phiero qnang kùi ta aniang, rai tôq tanget. ");
INSERT INTO hrebt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Chuaq Jesus yŏc tì bèq mangai yinìq aih, kan tôq taqnget hi dìq, khoe èh haq aih hi yòng patìh ka Chuaq Jesus ");
INSERT INTO hrebt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Trùh xèq, wì aràng ka Chuaq Jesus bàc ngai kiac chŏc pawè, Chuaq Jesus yŏc bàu capoch drùh qnoh ƀài kiac aih, rai broq brêh dìq dŏng mangai ùh hrŏc. ");
INSERT INTO hrebt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","qmang aih dôq xìt troeq bàu Pajàu Êsai ma khoe anoe: Haq khoe doeh dŏng kan yinìq bèn, Pòq wê kan ùh hrŏc bèn. ");
INSERT INTO hrebt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jò Chuaq Jesus hnoq bàc ngai oe dudan ka dađeh, haq thê tŏc apah tau diac. ");
INSERT INTO hrebt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","I moeq ngai hnài ranenh trùh ti Haq rai anoe: Ìh lam taleq, au tiaq ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus padreo bàu: “Ƀài chia i trom, chìm i pù, mahaq Kon Mangai ùh i qmòe ka nòe hu angèn gàu. ");
INSERT INTO hrebt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mangai qnoeq hòm doe: Waiq Chuaq, Ìh dôq au hlài catùh hanang dèh baq òeq. ");
INSERT INTO hrebt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mahaq Chuaq Jesus doe ka haq: “Lam tiaq au, dôq da mangai cachìt catùh mangai cachìt.” ");
INSERT INTO hrebt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Khoe aih, Chuaq Jesus loh ta boang, ƀài mangai tiaq hŏc hi tiaq haq. ");
INSERT INTO hrebt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cadoe, ta diac raxìq loh bahùt kàn, diac lai laq yòng haqnhèq enh gùp qmòe boang. Mahaq Chuaq Jesus oe raq kùi. ");
INSERT INTO hrebt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ƀài mangai tiaq hŏc, thia haten padrìu haq, wì doe: Waiq Chuaq! Ìh dang nhèn diq, nhèn cachìt manòeq kô raq! ");
INSERT INTO hrebt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus doe: “Ƀài mangai ƀiaq manoh lùi, hagleq pì ma yùq? Chuaq Jesus yòng tagàih ka cayeo xam diac raxìq, dìq baiq hi hatinh rangep hloe. ");
INSERT INTO hrebt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dìq dŏng ka wì aih hamàih bòch dabau: Mangai kô ìq cabô? Jaq wa cayeo wa diac dua iu bàu Haq? ");
INSERT INTO hrebt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jò Chuaq Jesus khoe trùh pah tau ka diac, haq hnoq baiq ngai i kan kiac oe ta chac, wa aih loh enh cadràng hanang tùh glàm Haq. Wa aih dù haraya, pi i cabô oe hùa lam pagat trong aih. ");
INSERT INTO hrebt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wa cachech qmòe cadêh: Waiq Kon Boc Plình, bèn kô ìq ep cleq ka dabau, ajoq Ìh trùh tacô, đòeq hu baxa nhèn adroe ka jò ùh xài? ");
INSERT INTO hrebt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wop jò aih diq, i moeq calùh chùa qnang acaq. ");
INSERT INTO hrebt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ƀài kiac bòch Chuaq Jesus rameh: Tàng joq Ìh hnan nhèn loh, Ìh am nhèn jah mùt đeh ta ƀài chùa tau. ");
INSERT INTO hrebt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Haq thê ƀài kiac: “Drah lam beq! Ƀài kiac loh enh wa aih, hi mùt hloe ta calùh chùa, tajòe qmòe jò aih dìq dŏng ka calùh chùa oe enh criang tawang clàm loh ta diac raxìq, cachìt dŏng ta diac. ");
INSERT INTO hrebt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ƀài mangai ban chùa hi cadàu lam amot, mùt taplài taqmon hlài ƀài yiniq wì haq hnoq, anoe hloe xam bìac wa baiq ngai kiac ma pawè ka wì tàng. ");
INSERT INTO hrebt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dìq dŏng ka wì gùng aih loh tàt Chuaq Jesus, jò wì bu hnoq haq, wì drah thê haq lam taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chuaq Jesus loh taboang wìh hlài pah tau diac raxìq, haq hlài dèh ta plài. ");
INSERT INTO hrebt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","I wì tòng aràng ka haq moeq ngai pen kùi ta dra drah. Chuaq Jesus hnoq wì aih i manoh lùi, Haq doe ka mangai pen: “Ùh dùh yùq dèh kon, yiniq lui kon khoe jah caqnaih.” ");
INSERT INTO hrebt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jò aih, i toq ƀiaq ngai ma hnài ranenh oe ta aih, wì haq hèm ta manoh: Mangai kô capoch joq loq hanhèq. ");
INSERT INTO hrebt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yàng Chuaq Jesus loq ka manoh wì haq hèm cleq, haq hi doe rameh: “Hagleq ta manoh pì majah hèm qmèq qmang aih? ");
INSERT INTO hrebt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Baiq nà bàu kô: moeq aih doe “Dìq ka yiniq lui kon khoe caqnaih, tàng ùh meh doe drah yòng cadiang lam beq, maleq ma yeo hlàu ka tapoch? ");
INSERT INTO hrebt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mahaq au waq ka pì loq Kon Mangai oe ta crŏng taneh kô i cwìang đòeq caqnaih yiniq lui”. Khoe aih, Chuaq Jesus thê mangai pen: “Yòng beq, xùi da ìh dra drah qmat hlài ta hnem.” ");
INSERT INTO hrebt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mangai pen padinh yòng hlài dèh ta hnem. ");
INSERT INTO hrebt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dìq ka phù cròng hnoq kan halac aih, mangai leq mangai meh crè đeh hra, rai manè apôi Boc Plình khoe am ka kon mangai cwìang itai qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jò Jesus lam khoe ka nòe aih, Haq hnoq moeq ngai yiniq haq Mathio qnang hangui tanòe hnem yŏc thèq, Chuaq Jesus creo ka haq: “Drah lam tiaq au”, haq aih padinh yòng, lam tiaq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yàng jò wì qnang hangui acaq ta hnim Mathio, i bàc ngai yŏc thèq xam ƀài mangai ùh wìa trùh acaq moeq qmang ti Chuaq Jesus xam ƀài mangai tiaq hŏc haq. ");
INSERT INTO hrebt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","mangai Pharisi hnoq qmang aih, wì haq capoch ka ƀài tiaq hŏc Chuaq Jesus: Hagleq mangai hnài da pì qmat majah hangui acaq pajùm ti ƀài mangai yŏc thèq xam ti ƀài mangai ùh wìa? ");
INSERT INTO hrebt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chuaq Jesus tàng bàu aih, haq doe ka vì: “Mangai tadêh ma i waq mangai broq jreo, mangai ùh hrŏc ma waq ka mangai broq jreo. ");
INSERT INTO hrebt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lam beq, rai boq ngan bàu kô anoe cleq: Au enh kan loq waq, au ùh ngèh trùh ramènh tadreo. Majah qmang aih, au trùh ta kô ùh xài đòeq creo ka ƀài mangai taq atoq mahaq đòeq creo ka mangai i yiniq lui.” ");
INSERT INTO hrebt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jò aih, ƀài mangai tiaq hŏc Jon lam chaq Chuaq Jesus, wì bòch: Hagleq nhèn xam ƀài mangai Pharisi apàm ka acaq, yàng da ƀài mangai ma tiaq hŏc Ìh aih ùh dùh apàm ka acaq? ");
INSERT INTO hrebt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Chuaq Jesus padreo bàu: “Jò cla kon ŏng oe raq oe mòeq qmang ti wì bua haq lam acaq yiniang, wì aih mangò qmang leq ma wìa? Mahaq trùh hì leq wì hi qnung đac cla kon ŏng, jò aih èh bua haq ma apàm ka acaq. ");
INSERT INTO hrebt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ùh i ka cabô yŏc ahyah neo đòeq clep tanòe eo kùn, tàng joq broq qmang aih haqnech maneo aih èh haq tadùng hyah hloe ka blah eo, nòe hyah aih yeo qmèq tam. ");
INSERT INTO hrebt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hadai qmang aih, ùh i mangai leq yŏc alac neo ùc ta abôq akia dùnh, tàng broq qmang aih, abôq aih padah, alac aih ta-ùc, abôq aih hi raliang. Mahaq alac neo wì ùc ta abôq akia neo, aih èh ma hi jah wèq dìq baiq. ");
INSERT INTO hrebt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jò Chuaq Jesus qnang tapoch qmang aih, i moeq ngai wèq hnem tagop qyoh cadiang mùt, hacùn cràng enh ngèa ka Chuaq Jesus rai anoe: Kon cadrì au neo pat, au canòm đeh ka Ìh trùh, yŏc tì bèq chac haq, aih èh haq jah rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chuaq Jesus hi yòng lam, ƀài mangai tiaq hŏc hadailam ti haq aih. ");
INSERT INTO hrebt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hanoh jò aih diq, i moeq ngai gucadrì, haq loh ka dahrôq mahim khoe jah mòeq jàt baiq hanam, thia haten enh rù bèq haqmai eo Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Majah qmang aih, haq xan hèm yôt đeh ta manoh: Tàng joq au jah bèq đeh toq haqmai eo haq raq, au loq đeh jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Chuaq Jesus wìh hlài, hnoq gucadrì aih, Haq doe: “Ùh dùh yùq, toq cajap manoh oq! Manoh lùi da kon khoe broq kon jah brêh”, mangai cadrì aih jah brêh hloe jò aih raq. ");
INSERT INTO hrebt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jò Chuaq Jesus trùh hnim mangai wèq hnim tagop, hnoq ƀài mangai hlui taliaq, hnoq wì broq ma tagruàng. ");
INSERT INTO hrebt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Haq doe ka wì: “Pì loh enh gùng beq, kon cadrì qyoh kô ùh i cachìt, haq qnang kùi”. Tàng bàu aih wì do halê ka Haq. ");
INSERT INTO hrebt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jò wì aih khoe loh dìq enh gùng, Chuaq Jesus thia carùp tì kon qyoh aih haq hi yòng hangui. ");
INSERT INTO hrebt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Bìac kô, jàp cròng aih hìa đeh hra. ");
INSERT INTO hrebt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chuaq Jesus loh enh aih, i baiq ngai ùh xau tiaq haq rai creo: Kon bùa Dawit! Ha-och ka ma diq. ");
INSERT INTO hrebt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jò khoe mùt ta hnim, wa aih trùh, Chuaq Jesus bòch wa haq: “Chôp lùi au jah broq am ka chôp trong chôp ma ngèh kô qmòh?” Wa aih padreo bàu: Joq ma lùi Ìh broq jah. ");
INSERT INTO hrebt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chuaq Jesus bèq mat wa aih rai doe: “Tiaq manoh chôp khoe lùi, chôp jah qmang aih.” ");
INSERT INTO hrebt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mat wa haq jah xau hoq hlài. Chuaq Jesus yŏc bàu panhet wa haq: “Ngan oq, chôp ùh dùh dôq cabô loq bìac kô!” ");
INSERT INTO hrebt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mahaq, loh bu khoe enh hnim, wa anoe yiniq Haq jàp jìa tagùng aih. ");
INSERT INTO hrebt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jò qnang loh enh aih, wì aràng ka Chuaq Jesus moeq ngai làu i kiac oe ta chac haq. ");
INSERT INTO hrebt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jò Chuaq Jesus khoe drùh qnoh kiac, mangai aih jah tapoch. Ƀài phù cròng hamàih đeh hra wì ta anoe ka da bau: Qnhòq lah hnoq yiniq qmang kô tanòe Isorali. ");
INSERT INTO hrebt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mahaq da mangai Pharisi doe: Haq qmat yŏc cwìang enh cla craq kan kiac đòeq drùh kiac. ");
INSERT INTO hrebt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chuaq Jesus lam rìm gùng, rìm plài, hnài roc hnim tagop qyoh, anoe ka wì loq bàu lem diac Boc plình, rai broq brêh bàc ngai yinìq, ùh hrŏc. ");
INSERT INTO hrebt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jò Chuaq Jesus hnoq ƀài mangai bàc, ta manoh haq ha-och ka wì, majah qmang aih, wì nanxa, prah priang, tìah ka trìu ùh i ka mangai ban. ");
INSERT INTO hrebt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Haq doe ka ƀài mangai tiaq hŏc rameh: Qmau kô bàc, mangai gat aih toq biaq, ");
INSERT INTO hrebt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Qmang aih, drah creo ka Cla craq qmau qnoh tam bình gat loh ta ruàng haq. ");
INSERT INTO hrebt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chuaq Jesus creo ka moeq jàt baiq ngai tiaq hŏc trùh ti cla haq, am ka wì cwìang drùh hnan kiac chŏc jròng, rai broq brêh kan yinìq tôq, ùh hrŏc. ");
INSERT INTO hrebt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kô hiniq moeq jàt bài ngai Tiaq cla: mangai baxèm aih Simôn, bèn loq xan creo ka haq Phiero, xam Anrê (aih oh haq); Jaco kon Sêƀêđê xam Jon oh haq, ");
INSERT INTO hrebt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip xam Bathêlêmi; Thôma, xam Mathio (mangai yŏc thèq); Jaco kon Aphê, xam Thađê, ");
INSERT INTO hrebt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simôn mangai Cana-an, xam Juđa Icariôt, mangai ma blòq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aih raq, moeq jàt baiq ngai Tiaq cla, Chuaq Jesus thê wì loh lam rai tanap ka wì haq: “Apaq lam tanòe ùh xài mangai Juđa, ùh dùh mùt ta plài leq da mangai Samari. ");
INSERT INTO hrebt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mahaq lam chaq ƀài kon trìu Isorsli ma khoe hnhung. ");
INSERT INTO hrebt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jò lam ti trong pì anoe bàu kô: “Diac Plình trùh khoe haten”. ");
INSERT INTO hrebt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Broq brêh ka mangai ùh hrŏc, broq ka mangai cachìt rìh hlài, broq ka magai bacùn jah brêh, drùh hnan kan kiac jròng. Pì khoe jah dech pì hadai am dech. ");
INSERT INTO hrebt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ta caqnam pì ùh dùh catonh wê dèh ka wang, yac ka bac jèn hadai. ");
INSERT INTO hrebt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Lam ti trong ùh dùh wê ayôp, apaq racop baiq blah eo, yac ka jep hanoh qmang aih, apaq wê long ka nhra, majah qmang aih, yiniq da pì ma abroq khòh jah acaq. ");
INSERT INTO hrebt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pì mùt gùng leq, plài leq pì ti chaq ngan mangai leq ma tajì ka đìh pì, khoe aih oe hnim wì haq trùh jò pì loh lam. ");
INSERT INTO hrebt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jò pì mùt hnim leq, waiq kan catèm am ka hnem aih; ");
INSERT INTO hrebt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tàng joq hnim aih tajì, kan catèm enh pì hi loh am ka wì haq, tàng joq ùh aih, kan catèm pì hlài ta cla pì. ");
INSERT INTO hrebt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tàng mangai leq ùh đìh pì, ùh tamàng bàu pì, jò pì loh enh hnim aih, plài aih, drah hapùih blo ma top ta jènh pì. ");
INSERT INTO hrebt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Joq qnàng Au doe ka pì, trùh hì hadrah èh, gùng Sôđôm xam gùng Gômôro pòq kan hadrah yeo biaq ka wì aih. ");
INSERT INTO hrebt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Au thê pì loh lam tìah ka trìu oe taqne calùh koq yiang. Qmang aih pì ep rabiaq qmang ka bìh, khun khauq tìah ka trù. ");
INSERT INTO hrebt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pì ep hamang ngan oq, majah qmang aih èh wì rùp qnoh pì tanòe hadrah, jêh pì roc hnim tagop qyoh, ");
INSERT INTO hrebt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Qnah hòm, taiq au kô èh wì majah rùp qnoh pì enh ngèa ƀài cwan ƀài bùa, đòeq pì yòng anoe enh ngèa ka wì haq hloe xam ƀài ùh xài mangai Juda. ");
INSERT INTO hrebt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mahaq jò wì rùp pì, apaq lèt ka anoe qmang leq, anoe bàu cleq, gleq ma jah qmang aih, bàu leq ma troq ka anoe, trùh jò aih èh hi am ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aih ùh xài cla pì pì capoch đeh ma joq qnàng aih Yiang Hadròeh Baq pì oe enh dalam ka pì capoch qnoh. ");
INSERT INTO hrebt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Daq rùp dèh oh, dôq wì jêh đac, baq rùp dèh kon dôq wì jêh đac, mangai kon yòng tablêq dèh ka miq baq, waq ka dìq baiq wa aih cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jao yiniq au kô èh, dìq ka phù cròng majah tagit ka pì, mahaq mangai leq cajap manoh trùh lùch trùh gêh, mangai aih èh ma jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jò wì rùp pì ta plài kô, pì puplech lam ta plài qnoeq, joq qnàng au anoe ka pì, pì lam qnhòq jàp ka plài mangai Isorali, Kon mangai khoe trùh. ");
INSERT INTO hrebt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mangai tiaq hŏc ma lah yi ùh hnau ka mangai hnài, hapŏng malah yi ùh hnau ka cla wì craq. ");
INSERT INTO hrebt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mangai tiaq hŏc jah dàng mangai hnài, hapŏng jah dàng cla wì craq aih khoe wìa. Tàng joq wì khoe doe ka cla wì craq ta hnim aih Bênxêbun, loq ka mangai ta hnem. ");
INSERT INTO hrebt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Qmang aih, pì apaq yùq, ùh i cleq cadoc èh ma ùh ep paqnoh dŏng, ùh i cleq bahlèp atìq èh ma ùh loq. ");
INSERT INTO hrebt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aih ìq raq, bàu au anoe ka pì ta clam, drah anoe qnoh ta qngah, bàu pì tàng gìt ajang don, drah yòng ta kùa po hnim hu anoe qnoh. ");
INSERT INTO hrebt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ùh dùh yùq dèh ka mangai jah jêh toq chac pì mahaq ùh jah jêh mahua yiang pì; ma khòh yùq aih Mangai jah broq hnhung xam mahua xam chac pì oe ta hwinh ùnh. ");
INSERT INTO hrebt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Baiq toq chim prùch ùh xài wì hmaq tech moeq jèn bac raq qmòh? Mahaq tàng joq ùh xài tiaq manoh Baq pì, qnhòq lah i mòeq toq chim leq ma taclìh ta haqneq. ");
INSERT INTO hrebt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Xàc ta gàu pì qmat hadai rènh khoe dìq. ");
INSERT INTO hrebt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Qmang aih, apaq yùq cleq, pì yeo canaq ùh hnau ka chìm prùch. ");
INSERT INTO hrebt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aih ìq raq, cabô ràu trùh au enh ngèa ka phù cròng, au hanoh ràu trùh haq enh ngèa ka Baq au oe ta plình; ");
INSERT INTO hrebt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Cabô hangah đac au enh ngèa phù cròng, au hadai hangah đac haq enh ngèa ka Baq au oe ta plình. ");
INSERT INTO hrebt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Apaq xoh au trùh đòeq aràng kan catèm ta crŏng taneh, au trùh ùh xài đòeq aràng kan catèm, mahaq aràng chang aràng jaoq. ");
INSERT INTO hrebt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Au trùh đòeq lah kon calô khoe ka baq haq, lah kon cadrì khoe ka miq haq, lah kon mai khoe ka yaq haq; ");
INSERT INTO hrebt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","qmang aih, mangai oe ta hnim pì raq, ma tablêq hlài ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Cabô loq waq dèh ka miq baq ùh hnau ka au, mangai aih ùh tajì đòeq hu tiaq au, cabô loq waq dèh ka kon calô kon cadrì ùh hnau ka au, mangai aih hadai ùh tajì ka tiaq au, ");
INSERT INTO hrebt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Cabô ùh xùi dèh long pagat đòeq tiaq au, mangai aih hanoh ùh tajì ka tiaq au. ");
INSERT INTO hrebt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Cabô àu wèq dèh toq kan rìh dèh cla, haq aih èh jah hnhung, mahaq cabô chìuq cađac dèh kan rìh đòeq hu tiaq au, aih èh jah chaq hnoq hlài dèh. ");
INSERT INTO hrebt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Cabô đìh pì, haq aih đìh au, cabô đìh au, haq aih đìh Mangai ma khoe thê au. ");
INSERT INTO hrebt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Cabô đìh mòeq ngai pajàu taiq mangai aih broq pajàu, haq aih jah kan baha da mangai pajàu, cabô đìh mòeq ngai taq atoq, taiq mangai taq atoq, aih èh haq aih jah kan baha ka mangai ta atoq. ");
INSERT INTO hrebt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cabô chìuq am ka mòeq ngai kon qyoh taqne ƀài kon qyoh kô, ôq moeq chrŏng diac hangeo, taiq mangai qyoh aih broq mangai tiaq hŏc au, joq qnàng au doe ka pì, kan baha da haq aih èh ùh jò leq hnhung. ");
INSERT INTO hrebt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Khoe ka hnài dèh mòeq jàt baiq ngai tiaq hŏc, Chuaq Jesus loh enh aih, lam hnài roc plài oe gùng Galili. ");
INSERT INTO hrebt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jò Jon oe ta hnem tù, tàng wì anoe ƀài yiniq Chuaq Jesus Christ ma broq, haq thê dèh mangai tiaq hŏc haq trùh ti Chuaq Jesus, ");
INSERT INTO hrebt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wì bòch: Ìh kô raq ùh xài Mangai ma hu trùh tacô, nhèn ahìaq oe raq ep gòm mangai qnoeq ùh? ");
INSERT INTO hrebt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Chuaq Jesus padreo bàu: “Drah hlài beq, taqmon hlài ka Jon loq rìm yiniq pì ma khoe tàng, khoe hnoq: ");
INSERT INTO hrebt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mangai ùh xau jah hnoq, mangai liap jah lam, mangai bacùn jah hreo, mangai clìc don jah tàng, mangai cachìt jah rìh hlài, mangai nanxa jah tamàng bàu lem. ");
INSERT INTO hrebt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Xôq ramot am ka mangai leq ùh hìaq catoeh ka au. ");
INSERT INTO hrebt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jò wì aih khoe hlài, Chuaq Jesus men anoe trùh Jon dôq wì phù cròng ma tiaq haq loq: “Pì khoe lam ngan cleq tanòe hawit? Ajoq pì lam ngan long triang niaq cayeo hlui ùh xài? ");
INSERT INTO hrebt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pì lam ngan cleq hòm? Pì lam ngan mangai caxùnh atàc eo lem ùh xài? Hatau! wì mangai ma caxùnh eo ranhòm oe ta hnim bùa. ");
INSERT INTO hrebt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pì lam ngan cleq hòm? Ajoq lam ngan mangai tapoch pajàu ùh xài? Joq, au doe ka pì, ùh hnau ka tapoch pajàu hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aih raq mangai ma khoe i bàu achìh trùh haq: “Au thê dèh mangai lam adroe ka Kon, Đòeq chônh taqmroq trong Kon lam.” ");
INSERT INTO hrebt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Joq qnàng au doe ka pì, dìq dŏng taqne ƀài mangai ha-uang loh enh gucadrì, ùh i cabô yeo haq nhèq ùh hnau ka Jon Baptit, mahaq yac ka mangai dìq jaq hamoq oe tanòe diac plình, dua yeo haq nhèq ùh hnau ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mahaq, patep enh hì da Jon Baptit trùh manòeq, diac plình glàm kan khech tàt, mangai khech tàt aih blah yŏc diac plình. ");
INSERT INTO hrebt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Majah qmang aih, dìq dŏng ka ƀài bàu pajàu hloe xam hset ranenh ma khoe achìh trùh pang qnhòng da Jon raq. ");
INSERT INTO hrebt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tàng pì enh waq ka loq, haq aih raq Êli, mangai ma ep trùh. ");
INSERT INTO hrebt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Cabô i don đoèq tamàng, tamàng beq!” ");
INSERT INTO hrebt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Au alìah nang noe kô ti cabô kô èh? Nang noe kô bu dàng kon qyoh ha qngui tanòe atech, creo dèh ka bua, ");
INSERT INTO hrebt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","rameh: “Au khoe hlui taliaq ka pì, gleq pì ùh ti yòng cađoeq? Au khoe ti atoch, gleq pì ùh crò hmoe.” ");
INSERT INTO hrebt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon trùh ùh acaq, ùh ôq, pì doe: Kiac khoe caqnit don haq. ");
INSERT INTO hrebt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kon mangai trùh, haq acaq, haq ôq, aih pì doe: Meh mangai plai toq ka acaq ôq, taqmùt toq ka mangai yŏc thèq xam ƀài mangai ùh wìa. Mahaq, kan rabiaq ma joq qnàng aih jah hnoq ajang nòe yiniq broq ");
INSERT INTO hrebt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Taiq ƀài wì ma oe tanòe plài gùng Chuaq Jesus khoe broq bàc trong halac, ùh lòm raxach, Chuaq Jesus tapoch ka wì gùng aih: ");
INSERT INTO hrebt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Haƀo ka pì, plài Côrasin, haƀo ka pì plài Betsaiđa. Tàng joq ƀài kan halac khoe broq ta pì qmat aràng broq gùng Tyro, gùng Siđôn, baiq plài aih khoe yŏc eo briang đòeq taqmàn rađeh, kui blo tanùh, raxach nèh haq raq. ");
INSERT INTO hrebt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aih au doe ka pì, trùh hì hadrah, gùng Tyro, gùng Siđôn pòq kan hadrah yi biaq ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Gè kô èh, Cabênaum, gùng ma khoe jah atŏc haq nhèq trùh ta plình, kô èh jah caqnìh cađac trùh ta hwinh. Tàng joq ƀài kan halac ma khoe broq qne gè, aràng broq ka gùng Sôđôm, gùng aih oe raq trùh manòeq. ");
INSERT INTO hrebt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mahaq au doe trùh hì hadrah èh, gùng Sôđôm èh jah hadrah yeo biaq ka gè. ");
INSERT INTO hrebt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jò aih raq, Chuaq Jesus doe: “Baq! Ìh broq Craq oe taplình crŏng taneh, au manèh apôi Ìh, majah qmang aih Ìh khoe cadoc ƀài yiniq kô ka ƀài mangai rabiaq, mangai loq, mahaq Ìh patô am ka kon qyoh jah loq. ");
INSERT INTO hrebt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Baq ôi, joq qmang aih raq, majah qmang aih Ìh khoe hnoq bìac aih lem. ");
INSERT INTO hrebt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Rìm yiniq Baq khoe jao dŏng ka au, enh gùng ka Baq ùh i mangai leq canau ka Kon, enh gùng ka Kon ùh i mangai leq loq ka Baq. ");
INSERT INTO hrebt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Dìq dŏng ka mangai tagah lep, pòq trap, drah trùh ta au beq, au jah am ka pì padài. ");
INSERT INTO hrebt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Au i manoh khun alàng loq hamuan rađeh, drah taqmac wê long ech au, hŏc tiaq au, aih èh mahua yiang pì jah padài. ");
INSERT INTO hrebt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Majah qmang aih long ech da au kô hlàu, tanòng da au kô hèu. ");
INSERT INTO hrebt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jò aih, wop hì sabat, Jesus pùh pagat đùng ruàng, ƀài mangai tiaq hŏc pangot wì haq git kaq hadròc qmau. ");
INSERT INTO hrebt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mangai Pharisi hnoq qmang aih, wì lam doe ka Chuaq Jesus: Ngan meh, ƀài mangai tiaq hŏc ìh, broq trong ùh lòh ta hì Sabat. ");
INSERT INTO hrebt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mahaq Chuaq Jeus padreo bàu ka wì aih: “Ha bùa Đawit xam mangai lam tiaq haq khoe broq jò wì haq pangot, pì qnhòq hmaq đŏc qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aih ìq, bùa mùt ta hnim Boc Plình, yŏc acaq ƀênh dèch ka Boc Plình, ƀênh aih bùa xam mangai lam tiaq haq ùh khòh kaq, ƀênh aih đòeq toq ka ƀài pajàu. ");
INSERT INTO hrebt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hìaq pì ùh i ngan ta hset ranenh, trùh hì sabat, ƀài pajàu oe ta hnim kùh waiq, broq ùh troq tiaq ranenh hì aih aleq i tuiq cleq? ");
INSERT INTO hrebt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Au doe ka pì, ajang kô i moeq ngai yeo kàn ùh hnau ka hnem kùh waiq. ");
INSERT INTO hrebt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tàng pì loq bàu kô anoe cleq: “Au tangèh ka manoh loq waq, ùh i ngèh trùh ramènh tadreo, qmang aih pì khoe ùh hìaq capoch haƀo đac ka ƀài mangai ùh i đeh yiniq lui cleq. ");
INSERT INTO hrebt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Majah qmang aih Kon mangai aih craq hì sabat”. ");
INSERT INTO hrebt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Lam khoe ka aih, Chuaq Jesus mùt tanòe hnim tagop qyoh. ");
INSERT INTO hrebt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta aih i mòeq ngai, angwenh mòeq pah tì. I mangai bòch Chuaq Jesus: Hì Sabat akhòh broq brêh ka mangai yinìq ùh? Majoq qnàng aih wì qnang chaq nen đòeq hu tah hadrah ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chuaq Jesus tapoch ka wì: “Taqne pì qmat i ka mangai leq i mòeq toq kon trìu, tàng hì Sabat haq taclìh ta ralŏc, pì ma ùh dèch atŏc haq? ");
INSERT INTO hrebt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mangai ma ùh yeo kàn ùh hnau ka trìu! Qmang aih hì sabat khòh broq trong lem. ");
INSERT INTO hrebt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Khoe aih, Chuaq Jesus doe ka mangai ngwenh tì: “Hnhu tì qmat” Haq aih qnhu dèh tì, tajòe qmòe tì pah kô lem hlài tìah ka tì pah tau. ");
INSERT INTO hrebt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ƀài mangai Pharisi loh enh gùng, hatình ka dabau chaq trong hu jêh cađac Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chuaq Jesus loq qmang aih, haq lam đac taqnoeq, i bàc ngai tiaq haq, haq broq dìq dŏng ka wì jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Chuaq Jesus ùh lòh wì anoe am ka cabô loq ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dôq xìt qmang ka bàu pajàu Êsai khoe anoe: ");
INSERT INTO hrebt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kô, hapŏng Au ma khoe ràih, Mangai Au ma dìq jaq loq waq, lem manoh au rìm trong. Au am Yiang Hadròeh au oe ti haq, Haq aih èh ma anoe qnoh bàu taq atoq am ka rìm diac. ");
INSERT INTO hrebt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Haq ùh tarahen, ùh dêh bàu, Ùh i cabô tàng bàu haq oe ti trong ");
INSERT INTO hrebt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Haq ùh plêh đac triang niaq khoe tagoh, ùh hlui đac đen khoe ten pat. Trùh jò Haq broq ka kan taq atoq jah blêq. ");
INSERT INTO hrebt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Rìm diac tangèh dìq anòe yiniq Haq.” ");
INSERT INTO hrebt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jò aih i mangai aràng ka Chuaq Jesus mòeq ngai kiac caqnit don, ùh xau hnoq rai làu, Chuaq Jesus broq brêh ka haq aih loh ka jah tapoch jah hnoq. ");
INSERT INTO hrebt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wì hamàih đeh hra, wì bòch dabau: Haq qmat ajoq kon xau bùa Đawit? ");
INSERT INTO hrebt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mahaq ƀài mangai Pharisi hìa qmang aih wì doe: Haq qmat canòm ka Ƀênsêbun craq kan kiac đòeq drùh kiac. ");
INSERT INTO hrebt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Chuaq Jesus loq ka manoh wì, haq doe: “Moeq diac tàng joq cla haq hit lah rađeh, diac aih èh ùh khoe ka raliang, mòeq plài, mòeq hnim tàng hit lah dabau aih èh pi oe dràng yòng. ");
INSERT INTO hrebt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tàng joq Satan hnan Satan, aih ajoq haq hit lah dađeh, aih èh diac haq yòng qmang leq ma oe keo? ");
INSERT INTO hrebt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tàng au canòm ka Ƀênsêbun đòeq hnan kan kiac, ha wì kon pì qmat èh canòm ka cabô đòeq drùh hnan kan kiac? Qmang aih, wì haq aih èh ma broq mangai hu hadrah ƀài pì. ");
INSERT INTO hrebt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tàng joq au canòm ka Yiang Hadròeh enh Boc Plình đòeq drùh hnan kan kiac, aih diac Plình khoe trùh ta pì. ");
INSERT INTO hrebt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Qnah hòm, i ka cabô jah mùt ta hnim mangai dêh padren hu tablah yŏc da haq aih kùng hang, ma baxèm aih ùh kàt cla haq adroe oèq? Ep kàt cla haq adroe khoe èh men jah blah yŏc hang ta hnim haq. ");
INSERT INTO hrebt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Cabô ùh oe ti au, haq aih mangai tablêq ka au, cabô ùh taqmùt ti au, wì aih prah priang dŏng. ");
INSERT INTO hrebt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Qmang aih au doe ka pì, rìm yiniq lui pì xam ƀàu tapoch qmèq ka Boc plình, dìq dŏng èh oe jah paclaih, mahaq bàu tapoch troq trùh Yiang Hadròeh ùh jò leq jah paclaih. ");
INSERT INTO hrebt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tàng cabô capoch tablêq ka Kon mangai, èh oe jah paclaih, mahaq cabô tapoch bàu taƀlêq Yiang Hadròeh, yac ka qnhòng kô trùh qnhòng atìq èh yiniq lui aih dua ùh jah caqnaih. ");
INSERT INTO hrebt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Long lem èh loh plì lem, long qmèq plì hadai qmèq, ngan plì ma loq ka long. ");
INSERT INTO hrebt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wùih! Ƀài adrech bìh plŏng meh, pì qmat nang noe qmèq, broq qmang leq ma hloh bàu lem? Ta cliac khoe bình, men hloh bàu tapoch a hacùng. ");
INSERT INTO hrebt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mangai lem ta dalam haq bình kan lem men jah tapoch hloh bàu lem, mangai dù ta haq bình kan dù majah tapoch hloh bàu dù. ");
INSERT INTO hrebt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Au doe ka pì, trùh ta hì hadrah, rìm ngai ep anoe qnoh dŏng dèh bàu rađeh ma khoe tapoch. ");
INSERT INTO hrebt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Majah qmang aih, ajang nòe bàu capoch aih raq, ma hi jah creo ka ìh mangai taq atoq, hadai ajang bàu tapoch aih raq ìh ep pòq kan baxa. ");
INSERT INTO hrebt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Khoe aih i ƀài mangai hnài ranenh xam ƀài mangai Pharisi doe ka Chuaq Jesus: Mangai hnài, nhèn enh hnoq ìh broq trong halac. ");
INSERT INTO hrebt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Chuaq Jesus padreo bàu: “ƀài caxi noe dù, loq tango kô, bòch ngan kan halac, ùh i kan halac leq am ka pì hnoq enh gùng ka kan halac troeq pajàu Jôna. ");
INSERT INTO hrebt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Majah qmang aih Jôna khoe oe ta cliac ka kàn piq hì piq mang, hanoh qmang aih èh, Kon mangai hadai piq hì piq mang oe ta taneh. ");
INSERT INTO hrebt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Trùh hì hadrah, wì ma oe ta Ninive aih èh ma yòng hu hadrah ka caxi noe kô, ma jah qmang aih wì haq tàng bàu pajàu Jôna hnài aih wì khoe raxach, mahaq ajang nòe kô, i mòeq ngai yeo haqnhèq ùh hnau ka Jôna! ");
INSERT INTO hrebt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Trùh hì hadarah, bùa Cadrì enh ƀè mahì tŏc èh ma yòng hu hadrah ka nang noe kô, majah qmang aih bùa aih khoe trùh enh nòe hangai đòeq hu tamàng bàu rabiaq enh nòe bùa Salômôn, mahaq anòe kô i mòeq ngai yeo haqnhèq ùh hnau ka bùa Salômôn! ");
INSERT INTO hrebt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jò kan kiac khoe loh enh moeq ngai, haq lam tanòe croh crênh chaq nòe padài, mahaq chaq ùh jah, ");
INSERT INTO hrebt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","èh haq hi doe: Au wìh hlài ta hnim au ma neo loh, jò haq hlài, hnoq hnem dech do, khwit khoe lem, khoe palauq qmòe ka alàng. ");
INSERT INTO hrebt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Haq lam hòm, ahlài tam tapèh toq kiac qnoeq yeo dù ùh hnau ka haq, hlài oe pajùm ta hnim aih, mangai aih atìq èh yeo hamoq ùh hnau ka adroe hòm. Ƀài caxi noe dù kô qmang aih èh diq. ");
INSERT INTO hrebt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jò Chuaq Jesus oe raq tapoch ka ƀài wì, miq haq xam ƀài oh haq yòng enh gùng, enh capoch ka haq, ");
INSERT INTO hrebt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","I mangai trùh doe ka Chuaq Jesus: Miq Ìh xam ƀài oh ìh yòng enh gùng, enh tapoch ka Ìh ");
INSERT INTO hrebt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Haq padreo bàu: “Cabô miq au, cabô oh au?” ");
INSERT INTO hrebt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Haq patô dèh ƀài mangai tiaq hŏc rai doe: “Hacô miq au xam ƀài oh daq au!” ");
INSERT INTO hrebt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Majah qmang aih, mangai leq broq tiaq manoh Baq au oe ta plình, aih raq oh daq calô, oh daq cadrì xam miq au. ");
INSERT INTO hrebt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hadai hì aih, Chuaq Jesus loh enh hnim lam hangui ta kênh diac raxìq, ");
INSERT INTO hrebt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wì phù cròng tagop ti dabau haraya dudan ka Haq, Chuaq Jesus ep loh hangui ta boang, dìq ka wì qnoeq oe ta go. ");
INSERT INTO hrebt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chuaq Jesus yŏc bàc trong alìah hu hnài wì, Haq doe: “I moeq ngai lam rai adrech. ");
INSERT INTO hrebt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jò haq rai adrech, i qnah ta clìh ti trong lam, chìm loh jôh dŏng. ");
INSERT INTO hrebt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Moeq qnah taclìh tanòe raga, taneh toq biaq, catùh ùh jrùq, rênh plôh. ");
INSERT INTO hrebt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mahaq jò mat mahì yòng sreo, ùh i ka riah hi loh ka croh. ");
INSERT INTO hrebt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mòeq qnah taclìh nòe xèm yila, yila rai èh ray cràm bahlac haq jôq ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mòeq qnah qnoeq hòm, clìh troq tanòe taneh lem, hi loh plì, mòeq pliang loh jah moeq hrinh, mòeq pliang jah tadràu jàt, mòeq jah piq jàt. ");
INSERT INTO hrebt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Cabô i don, tamàng beq! ");
INSERT INTO hrebt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mangai tiaq hŏc, thia ka haten bòch Chuaq Jesus: Gleq Ìh ma jah yŏc bàu alìah qmang aih đòeq tapoch ka wì? ");
INSERT INTO hrebt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chuaq Jesus padreo bàu: “Majah qmang aih kan hlèp da diac plình khoe am ka pì loq, mahaq ƀài wì tau aih ùh dôq ka wì haq loq.” ");
INSERT INTO hrebt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Majah qmang aih mangai leq ma khoe i aih jah am tam, aih èh wì hi i rah ùh dìq ùh dài, mahaq mangai leq ma ùh i, aih èh doeh yŏc hloe yiniq haq ma khoe i. ");
INSERT INTO hrebt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aih ìq au ma jah toq aliàh ka wì haq, yac ka wì haq ngan dua ùh xau hnoq, hadràng don mahaq ùh tàng, tamàng mahaq ùh qnì cleq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Qmang aih khoe xìt ka bàu pajàu Êsai jò haq ràu trùh wì qmat: Pì hadràng don tamàng, mahaq ùh qnì cleq; Haqmiang ngan mahaq ùh xau hnoq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Majah qmang aih, manoh wì haq khoe cadoq; Don wì haq khoe trap, mat wì haq khoe tajìp, Yùq dèh mat loq xau hnoq, don rađeh loq jah tàng, Manoh da đeh loq jah loq, rađeh loq wìh hlài, Èh au loq broq wì haq jah brêh qmòh. ");
INSERT INTO hrebt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mahaq xôq ramot am ka ƀài pì mat jah hnoq, xôq ramot am ƀài pì, don ma jah tàng. ");
INSERT INTO hrebt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Joq qnàng au doe ka pì, i bàc mangai pajàu, bàc ngai taq atoq khoe ngèh ka jah hnoq trong pì hnoq, mahaq ùh jah hnoq, ngèh ka jah tàng trong pì ma jah tàng, mahaq ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Pì tamàng bàu alìah mangai lam rai adrech aih anoe cleq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jò mangai leq tàng bàu lem diac plình, mahaq ùh lòm qnì qmòe cleq, aih kiac dù trùh ta qmiaq yŏc yiniq ma khoe jah rai ta manoh haq, aih la mangai majah adrech clìh ti trong lam. ");
INSERT INTO hrebt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mangai jah adrech clìh nòe taneh raga aih mangai bu tàng bàu, khoe lem bùi drah yŏc huiq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mahaq ta manoh ùh i ka riah, rìh moeq hyàc raq, trùh jò glàm nanxa, khech tàt, hi tacro. ");
INSERT INTO hrebt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mangai jah adrech clìh nòe xèm yila, aih mangai tàng bàu, mahaq manoh hèm toq ka qnhòng kô, ònh toq trong padrŏng kan, broq ka bàu aih ùh plôh ramot, hi loh ka ùh sròc. ");
INSERT INTO hrebt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mahaq, mangai ma jah adrech clìh tanòe taneh lem, aih mangai loq tàng, haq aih jah loh plì, moeq pliang jah qmòe moeq hrinh, pliang qnoeq jah tadràu jàt, ma qnoeq jah piq jàt. ");
INSERT INTO hrebt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chuaq Jesus alìah trong qnoeq hòm ka wì haq: “Diac plình tìah ka mangai yŏc adrech lem loh rai dèh ta ruàng. ");
INSERT INTO hrebt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mahaq jò dìq ka wì oe raq kùi, mangai tagit ka haq loh rai adrech nhat adrònh ta qmau aih, khoe aih hi lam đac. ");
INSERT INTO hrebt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trùh jò qmau aih yòng kàn, loh hadròc, adrònh hadai ploah loh diq.” ");
INSERT INTO hrebt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ƀài mangai patìh lam anoe ka wì craq ruàng aih: Wì craq, ma ùh xài ìh rai toq adrech lem ta ruàng ìh qmòh? ha nhat adrònh qmat loh enh leq? ");
INSERT INTO hrebt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wì craq padreo bàu: Aih mangai tagit ka au ma broq. Ƀài hapŏng doe: Ìh alòh ƀài nhèn loh bùiq nhat aih loq ùh? ");
INSERT INTO hrebt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Wì craq padreo bàu: Hêq ùh dùh, yùq jò bùiq pì loq troq bùiq ataq qmau. ");
INSERT INTO hrebt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dôq haq dìq baiq wa yòng hloe trùh jò gat, trùh jò gat i au tanap ka ƀài ƀình gat qmau rameh: “Adroe aih, pì bùiq nhat adrònh òeq, cadop tang cadop hu bùh đac, qmau aih pì don đòeq da au ta hapom”. ");
INSERT INTO hrebt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Chuaq Jesus yŏc trong qnoeq hòm hu alìah tam ka wì: “Diac plình tìah adrech habài wì ma rai ta ruàng. ");
INSERT INTO hrebt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Adrech joq yi yêq dŏng ka ƀài adrech qnoeq, mahaq jò hi jah honh, haq yeo kàn ka ƀài cachiq qnoeq, wìa qmòe long, jaq chìm mech lam broq pù ta hamenh haq”. ");
INSERT INTO hrebt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Chuaq Jesus patìah hòm ka wì: “Diac plình tìah ka blo alac, mangai cadrì ma yŏc tah ta piq cađap dàc, hi trùh dèh jò dàc aih hi rèu dŏng.” ");
INSERT INTO hrebt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Chuaq Jesus capoch ka wì phù cròng ma tiaq Haq toq xam bàu alìah, ùh i tapoch cleq haq ma ùh alìah ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Waq ka xìt troeq bàu pajàu ma khoe anoe: “Au dahah bàu đòeq tapoch alìah. Au hu paqnoh ƀài kan hlèp, patep enh jò broq plình crŏng taneh.” ");
INSERT INTO hrebt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jò khoe am wì hlài, Chuaq Jesus wìh mùt ta hnim, ƀài mangai tiaq hŏc trùh ka haten bòch haq: Ìh anoe am ka nhèn loq bàu ìh ma alìah adrech nhat adrònh oe ta ruàng aih qmang leq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus padreo bàu: “Mangai rai adrech lem aih Kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ruàng aih crŏng taneh kô, adrech lem aih kon diac plình, nhat adrònh aih kon kiac dù, ");
INSERT INTO hrebt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","mangai tagit rai adrech nhat, aih kan kiac dù, hì gat qmau aih hì pulùch da crŏng taneh kô, ƀình gat qmau aih ƀình plình. ");
INSERT INTO hrebt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tìah ka wì bùiq nhat adrònh bùh ta ùnh qmang leq, hì crŏng taneh kô dìq lùch qmang aih èh diq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kon mangai hi thê dèh ƀình plình hacom qnoh dŏng ƀài mangai ma broq dua qmèq xam mangai broq dù loh khoe ka diac Haq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Khwênh caqnìh wì aih tanòe hlŏng ùnh, ta aih èh i toq kan crò hmoe rai cadrit hanenh. ");
INSERT INTO hrebt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jò aih, ƀài mangai taq atoq ca-ah tìah ka qngah mahì oe tanòe diac Baq wì haq. Cabô i don, drah tamàng. ");
INSERT INTO hrebt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Diac plình tìah ka hang canaq catùh đòeq ta ruàng, i moeq ngai chaq hnoq, haq hi cadoc đòeq rai hlài rai lem bùi, tech dìq dŏng dèh kùng hang, đòeq hu rot ruàng aih. ");
INSERT INTO hrebt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Diac plình hadai tìah ka mangai lam padro, chaq ngŏc canaq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jò chaq khoe hnoq ngŏc canaq, haq tech dŏng dèh kùng hang đòeq rot pliang ngŏc aih. ");
INSERT INTO hrebt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Diac plình hanoh tìah ka hlàm ma tang ta hlŏng, hlech rìm yiniq ka. ");
INSERT INTO hrebt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jò khoe bình ka tanang hlàm, mangai tang hi dèch hlàm atŏc tago, khoe aih hangui ràih ma lem đòeq crài, èh tah ta tabŏng, mahaq khwênh cađac dŏng ƀài ma ùh wìa. ");
INSERT INTO hrebt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Trùh hì crŏng taneh kô lùch, hanoh qmang aih diq: Jò aih, ƀài ƀình plình trùh đòeq lah ƀài mangai dù loh khoe ka mangai taq toq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Khwênh caqnìh ƀài mangai broq dù ta tanùh ùnh, oe nòe aih i kan hmoe rai cadrit hanenh. ");
INSERT INTO hrebt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pì atem ƀài bàu aih? Ƀài mangai tiaq hŏc doe: Nhèn loq tàng. ");
INSERT INTO hrebt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chuaq Jesus hi doe: “Dài qmang aih rìm ngai hnài ranenh, jò wì haq khoe hŏc loq rìm trong tanòe diac plình, hi tìah ka wì craq hnim qnoh dŏng dèh ƀài hang neo xam hang dùnh loh enh gùng ka hapom. ");
INSERT INTO hrebt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jò Chuaq Jesus khoe hêq ka capoch ƀài bàu alìah aih, haq hi lam taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Haq hlài dèh gùng cla, mùt hnài tanòe hnim tagop qyoh, wì hamàih đeh hra ka bàu haq, wì bòch dabau: Mangai qmat haq jah enh leq ƀài kan rabiaq xam kan halac qmang meh? ");
INSERT INTO hrebt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Haq qmat ma ùh xài kon mangai thòq broq long chàm qmòh? Miq haq ajoq Mari? Ƀài oh daq haq ajoq Jaco, Jôsep, Simôn, Jiu đe? ");
INSERT INTO hrebt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ƀài oh cadrì haq ma ùh joq oe taqne bèn kô? Enh leq haq majah ƀài yiniq qmang meh? ");
INSERT INTO hrebt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","wì aih hi catoeh ka haq. Mahaq Chuaq Jesus doe ka wì: “Toq gùng cla, hnem cla raq ma hnoq mangai pajàu ùh loh cleq.” ");
INSERT INTO hrebt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta aih Chuaq Jesus ùh broq bàc kan halac, ma jah qmang aih ta aih wì ùh i ka manoh lùi. ");
INSERT INTO hrebt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jò aih Hêrot (aih bùa yi enh qneq), hìa bàu wì anoe trùh Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Haq doe dèh ka ƀài mangai ma tiaq ka jènh ka tì ti haq: Kô raq Jon Baptit, mangai cachìt rìh hlài men jah broq trong halac qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Aih ìq rameh: Taiq Hêrôdia, aih mai da Philip, oh cla haq, dài Hêrôt majah rùp clêh Jon Baptit. ");
INSERT INTO hrebt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Majah qmang aih, Jon i tagàih ka bùa rameh: Bùa ùh jah yŏc mangai cadrì qmat broq mai. ");
INSERT INTO hrebt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bùa enh jêh đac Jon, mahaq haq ùh hùa ka wì phù cròng, majah qmang aih phù cròng dìq doe Jon aih mangai pajàu kàn. ");
INSERT INTO hrebt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Wop hì acaq yiniang manè hì ha-uang ka bùa Hêrôt, kon cadrì da Hêrôđia muaq taqne ƀài mangai trùh acaq yiniang, dìq jaq troq ka manoh bùa. ");
INSERT INTO hrebt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jaq bùa mech chìuq hapah jò ma tèu bàu am ka kon cadrì aih, waq toq kon mangai aih bòch cleq dua haq am. ");
INSERT INTO hrebt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jao miq haq patùt, kon cadrì aih hi bòch bùa: Ìh yŏc gàu Jon Baptit tah ta dòt kàn hu am ka au. ");
INSERT INTO hrebt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bùa mangò ta manoh, yàng haq khoe troq hapah, qnah hòm i ƀài mangai ma hangui acaq yiniang oe ta aih, bùa hi dôq kon cadrì aih jah troeq bàu haq bòch. ");
INSERT INTO hrebt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bùa hi thê wì lam jêh Jon tanòe hnim clêh. ");
INSERT INTO hrebt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Khoe aih wì yŏc gàu haq tah ta dòt kàn qnoh am ka kon cadrì aih, haq aih hi aràng dèh ka miq. ");
INSERT INTO hrebt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Atìq ka aih, mangai tiaq hŏc Jon, lam yŏc hanang haq ahlài catùh. ");
INSERT INTO hrebt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chuaq Jesus hìa qmang aih, haq tŏc ta boang wia taqnoeq, haq lam tanòe ma hawit. Yàng jò wì phù cròng ma hi loq, wì loh enh bàc plài, wì lam jènh hu tiaq Haq. ");
INSERT INTO hrebt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chuaq Jesus bu tŏc enh boang, hnoq ƀài mangai bàc haraya harayùc, manoh haq tamèt ka wì, haq broq brêh ka wì ma yinìq. ");
INSERT INTO hrebt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Trùh jò mat mahì khoe haqneq, ƀài mangai tiaq hŏc, thia doe ka Haq: Tanòe kô hawit, èh trŏc hadai khoe ten clam, Ìh am wì hlài beq, dôq wì mùt roc plài chaq rot dahwèq acaq. ");
INSERT INTO hrebt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chuaq Jesus doe: “Wì ùh i ep lam, pì qmat raq mangai ma ep am ka wì acaq. ");
INSERT INTO hrebt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mangai tiaq hŏc doe: Tacô nhèn i padam toq ƀênh xam baiq pliang ka raq. ");
INSERT INTO hrebt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chuaq Jesus doe “Aràng ka au tacô. ");
INSERT INTO hrebt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chuaq Jesus thê wì hangui ta nhat, khoe aih, yŏc padam toq ƀênh xam baiq pliang ka, Haq qngoc ta plình rai manè apôi, khoe èh goh ƀênh aih am ka ƀài mangai tiaq hŏc, mangai tiaq hŏc ti aràng ka ƀài wì. ");
INSERT INTO hrebt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mangai leq mangai meh panàc đeh hra, rah ƀênh ti toch hlài bình jah moeq jàt baiq talênh. ");
INSERT INTO hrebt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wì ma acaq ta aih jah qnah ta padam muàn mangai, ùh rènh wì gucadrì xam kon qyoh. ");
INSERT INTO hrebt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Khoe aih Chuaq Jesus drah bahôiq ƀài mangai tiaq hŏc loh ta boang chônh tŏc pah tau, jò aih haq oe tago hu ti am wì mangai bàc hlài ta hnem. ");
INSERT INTO hrebt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Atìq ka haq khoe am wì hlài, haq tŏc ta wang moeq ngai đòeq hu waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jò aih, boang loh khoe trùh taqne diac raxìq, glàm cayeo tàt qngìa, i diac lai laq tep ta boang. ");
INSERT INTO hrebt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mahaq trùh jò pôn ta mang aih, Chuaq Jesus lam jènh ti riang diac đòeq trùh ti ƀài mangai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jò wì hnoq haq lam ti riang diac, ƀài mangai tiaq hŏc yùq crè wì doe: Tau raq kiac chŏc, khoe aih wì yùq pi cajaq wì breo wênh dênh. ");
INSERT INTO hrebt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mahaq Chuaq Jesus drah creo ka wì haq: “Pì catèm beq hacô au, apaq yùq!” ");
INSERT INTO hrebt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Phiero doe: Craq au! tàng joq Ìh, Ìh dôq au jah lam ti riang diac hu trùh ta Ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Chuaq Jesus doe: “Lam ta kô” Phiero cadiang loh enh boang, lam ti riang diac đòeq thia ta Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yàng jò haq hnoq cayeo hlui, haq loh yùq crè, haq hi hlòp ta diac, haq drah breo cadêh: Craq au, dèch au diq. ");
INSERT INTO hrebt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tajòe qmòe Chuaq Jesus hnhu tì cadop tì haq, rai doe: “Wùih! mangai biaq hrình manoh lùi, hagleq ìh ma toq ùh tùt qmang qmat.” ");
INSERT INTO hrebt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jò Chuaq Jesus xam Phiero khoe tŏc ta boang, cayeo hi hatinh. ");
INSERT INTO hrebt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ƀài wì ma oe ta boang trùh kùn cràng enh ngèa ka Chuaq Jesus rai doe: Ìh kô joq qnàng Kon calô Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jò khoe catech pah tau diac, Chuaq Jesus xam mangai tiaq hŏc lam ta gùng Gênêsaret. ");
INSERT INTO hrebt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wì gùng aih canau ka haq, drah thê mangai lam bahìa jàp jìa ka ƀài gùng du danh ta aih, wì tòng qnàng ƀài mangai yinìq trùh ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Rai bòch Chuaq Jesus am ka ƀài mangai yinìq jah bèq đeh toq haqmai eo haq, qmang aih waq toq cabô hi bèq eo haq, hi jah brêh dŏng. ");
INSERT INTO hrebt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Khoe aih, i ƀài mangai Pharisi xam ƀài mangai hnài ranenh trùh enh Jêrusalem hu bòch Chuaq Jesus ");
INSERT INTO hrebt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Hagleq ƀài mangai tiaq hŏc Ìh ùh wèq bàu wì craq dùnh nèh, wì haq ùh qnheo tì adroe ka acaq. ");
INSERT INTO hrebt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Chuaq Jesus padreo bàu: “Ha pì, hagleq pì majah tiaq dèh bàu qmon loh qmòe ka cađac ranenh Boc Plình? ");
INSERT INTO hrebt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Majah qmang aih Boc Plình i thê rameh: “Thê loq iu miq baq pì, èh bàu kô hòm: Mangai leq hnap dèh ka miq baq, haq aih ep cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yàng da pì aih doe: Cabô doe dèh ka miq baq rameh: Dìq dŏng ƀài yiniq cleq au jah patìh ka miq baq, au khoe dèch dŏng ka Boc Plình, haq aih pi hìaq ep iu deh miq baq hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Qmang aih, pì tiaq dèh bàu cla qmon mahaq cađac bàu Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pì qmat joq mangai toq ti patìah! Êsai tapoch pajàu khoe troq jò haq ràu trùh pì rameh: ");
INSERT INTO hrebt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Wì kô yŏc toq hacùng bàu kùh waiq au; Yàng manoh cliac wì haq hangai ka au raya, ");
INSERT INTO hrebt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bìac wì kùh waiq Au aih qngwan, Majah qmang aih wì haq hnài tiaq toq ranenh loh enh kon mangai.” ");
INSERT INTO hrebt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Khoe aih Chuaq Jesus creo ka ƀài wì mangai bàc ta aih, haq doe: “Thê pì tamàng rai loq tàng. ");
INSERT INTO hrebt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ùh xài yiniq cleq mùt ta hacùng ma broq ka pì loh ka amùa, mahaq yiniq cleq loh enh bàu pì aih ma broq ka pì loh ka amùa”! ");
INSERT INTO hrebt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ƀài mangai tiaq hŏc thia haten ka Jesus wì bòch: Ìh aloq ƀài mangai Pharisi tàng bàu ìh wì haq nòeh ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Chuaq Jesus padreo bàu: Long leq Baq ta plình ma ùh i pìt, ep bùiq cađac ");
INSERT INTO hrebt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dôq haq: Aih raq ƀài mangai ùh xau broq mangai qnung trong, tàng joq mangai ùh xau qnung mangai ùh xau, dìq baiq ka wa clìh ta ralŏc. ");
INSERT INTO hrebt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Phiero hi doe: Ìh anoe am ka nhèn loq đeh bàu alìah aih diq. ");
INSERT INTO hrebt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chuaq Jesus bòch: “Pì ùh tem bàu aih qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Pì qnhòq qnì cleq ma mùt ta hacùng aih èh haq hi loh hloe tacliac, khoe aih ma ùh xài lam cađac tanòe hlèp qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yàng ƀài yiniq cleq ma loh enh hacùng, aih dìq loh enh manoh cliac, ƀài yiniq aih ma broq ka pì loh ka amùa. ");
INSERT INTO hrebt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Majah qmang aih enh manoh cliac ma loh ƀài kan dù, jêh đac mangai, tanqnong, loq tango, atùng, tapoch qmùt, tapoch hwang. ");
INSERT INTO hrebt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ƀài yiniq aih ma broq amùa ka pì, mahaq acaq ùh i qnheo tì ùh i broq ka pì amùa. ");
INSERT INTO hrebt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Loh enh aih Chuaq Jesus mùt ta gùng Tyro xam gùng Siđôn, ");
INSERT INTO hrebt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","I mòeq ngai gucadrì Cana-an oe gùng aih trùh ta Chuaq Jesus, haq creo ka Chuaq Jesus: Wì Craq! Kon bùa Đavit, ha-och ka au diq, kon cadrì au kiac pawè yôt haq, joq hamoq đeh hrình. ");
INSERT INTO hrebt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mahaq Chuaq Jesus ùh tapoch moeq nà bàu. Mangai tiaq hŏc lam haten, cali calo ka Chuaq Jesus: Ìh thê dŏng haq qmat hlài beq, ngan haq toq creo dang enh rù ka bèn meh! ");
INSERT INTO hrebt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Chuaq Jesus padeo bàu: “Au ma jah trùh tacô, aih đòeq hu chaq toq ƀài kon trìu Isorali ma khoe lam hwang.” ");
INSERT INTO hrebt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mahaq mangai gucadrì aih thia qmòe ka haten, kùh waiq Chuaq Jesus, haq doe: Wì Craq, ha-och ka au dìq. ");
INSERT INTO hrebt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chuaq Jesus padreo bàu: Ùh dùh yŏc ƀênh kon acaq đòeq caqnìh ka koq. ");
INSERT INTO hrebt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mangai gucadrì aih doe: Joq qmang aih Wì craq, mahaq ƀài kon koq ti kaq đeh ƀài hanech ƀênh ma taclìh enh pra wì craq. ");
INSERT INTO hrebt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chuaq Jesus hi doe: “Mangai gucadrì meh! Ìh i manoh lùi kàn, yiniq aih èh ep loh tìah ka manoh ìh ma enh.” Wop jò aih raq kon cadrì haq jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Enh aih Chuaq Jesus lam tiaq haqmai diac raxìq Galili, èh Haq hi tŏc hangui tawang, ");
INSERT INTO hrebt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jò aih i mangai pi ka jaq trùh ti haq, qnung ƀài mangai cwê, lua mat, làu, mangai ngwênh xam bàc ngai yinìq, đòeq wì aih ti jènh Chuaq Jesus. Chuaq Jesus broq ka wì aih jah brêh dìq dŏng. ");
INSERT INTO hrebt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aih, wì hnoq mangai làu hloh tapoch, ƀài mangai ngwênh jah brêh, mangai liap jah cadiang lam, mangai ùh xau khoe jah qngah, wì hamàih dìq jaq, dìq ka wì manè apôi Boc Plình da Isorali. ");
INSERT INTO hrebt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chuaq Jesus creo dèh ka mangai tiaq hŏc trùh ajang rađeh, haq doe: “Au ha-och ka wì kô, khoe piq hì wì haq oe ti au, manòeq kô pi i ka dahwèq hu acaq. Au ùh enh dôq wì haq hlài cliac dech, èh yùq wì haq loq hrah ti trong”. ");
INSERT INTO hrebt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mangai tiaq hŏc doe: Oe tanòe ma hawit qmang kô, ma i hlàu cleq ka chaq dahwèq acaq đòeq ka mangai bàc qmang qmat jah acaq ka panàc? ");
INSERT INTO hrebt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chuaq Jesus bòch mangai tiaq hŏc: “Pì i toq leq toq ƀênh?” mangai tiaq hŏc doe: Tapèh toq ƀênh xam toq ƀiaq pliang ka. ");
INSERT INTO hrebt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chuaq Jesus thê ƀài wì mangai bàc hangui ta taneh. ");
INSERT INTO hrebt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Khoe aih, haq yŏc tapèh toq ƀênh xam biaq pliang ka, manè apôi, goh ƀênh am ka mangai tiaq hŏc, wì aih ti aràng axong ka ƀài mangai bàc tau acaq. ");
INSERT INTO hrebt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mangai leq mangai meh panàc đeh hra, rah haq wì ti toch bình tapèh talênh. ");
INSERT INTO hrebt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mangai acaq jah pôn muàn mangai, ùh rènh gucadrì xam kon qyoh. ");
INSERT INTO hrebt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Khoe aih haq dôq wì hlài, èh haq hi loh taboang, đòeq hu tŏc tagg Magađan. ");
INSERT INTO hrebt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ƀài mangai Pharisi xam mangai Sađusê trùh ti Chuaq Jesus đòeq qnhro haq, wì bòch Chuaq Jesus broq kan halac loh enh plình am ka wì haq hnoq. ");
INSERT INTO hrebt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mahaq Chuaq Jesus padreo bàu: “Jò trŏc ten xèq, pì doe: Trŏc kô èh lem, majah qmang aih trŏc gòh. ");
INSERT INTO hrebt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yàng di sroq, aih pì doe: Hì kô èh i cayeo dêh, majah qmang aih hì kô trŏc clam ùh dai gòh. Pì loq hadro ngan trŏc qmang leq, laiq pì ùh qnì hadro ngan jò! ");
INSERT INTO hrebt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Qnang noe ngang dù, tango anang kô bòch ngan moeq yiniq cleq ma halac, mahaq ùh i kan halac leq enh gùng kan halac da pajàu Jôna.” Khoe aih Chuaq Jesus hi wia lam ta qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jò ƀài mangai tiaq hŏc tŏc khoe trùh pah tau diac, ùh hmàng wê ƀênh. ");
INSERT INTO hrebt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chuaq Jesus doe ka wì haq: “Rabiaq haq, wèq rađeh khoe ka blo da ƀài mangai Pharisi xam mangai Sađusê.” ");
INSERT INTO hrebt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mangai tiaq hŏc hèm ta manoh rai hatuàng ti dabau: Kô jao bèn ùh hmàng wê ƀênh. ");
INSERT INTO hrebt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chuaq Jesus loq qmang aih, haq doe ka wì: Joq ƀài mangai biaq manoh lùi, hagleq pì ma hèm jao pì ùh i ka ƀênh? ");
INSERT INTO hrebt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Pì ma qnhòq loq, pì ma ùh hmàng padam toq ƀênh am ka padam muàn mangai acaq, rah haq pì toch bình jah toq leq rajo qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ji laiq pì ma ùh hmàng tapèh toq ƀênh am ka pôn muàn mangai acaq, rah haq pì toch bình jah toq leq rajo? ");
INSERT INTO hrebt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pì ma ùh tem? Ùh xài au enh anoe trùh ƀênh, mahaq pì ep ngan wèq rađeh khoe ka blo da mangai Pharisi xam mangai Sađusê. ");
INSERT INTO hrebt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pang aih, mangai tiaq hŏc hi tem bàu Chuaq Jesus, haq ùh i anoe trùh blo broq ƀênh, mahaq haq enh ràu trùh bàu mangai Pharisi xam mangai Sađusê ma hnài. ");
INSERT INTO hrebt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jò Chuaq Jesus khoe mùt ta gùng Sêsarê Philip, haq bòch ƀài mangai tiaq hŏc rameh: Tiaq bàu wì ma anoe aih, Kon mangai kô ìq cabô? ");
INSERT INTO hrebt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mangai tiaq hŏc tèu bàu: Qnah ngai doe Ìh kô Jon Baptit, qnah ngai doe Jêrêmi, tàng ùh meh pajàu qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chuaq Jesus bòch: “Pì qmang leq? Pì doe au kô cabô.” ");
INSERT INTO hrebt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simôn Phiero doe: Ìh kô raq Christ kon Boc Plình rìh halình. ");
INSERT INTO hrebt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jò aih, Chuaq Jesus doe: “Simôn kon da Jôna, ìh qmat jah xôq ramot, mahnu kô ùh xài enh xech akia enh mahim am ka ìh loq, mahaq mahnu kô loh enh nòe Baq au oe ta plình. ");
INSERT INTO hrebt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Au hòm, au creo ka ìh: Ìh kô Phiero, kô èh au dèch paqnàng dèh Tagop Hadròeh enh crŏng hmo kô, ƀài qmang kan cachìt ùh jò leq hlàt blêq haq. ");
INSERT INTO hrebt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kô èh au am ka ìh gahlòng diac plình, waq toq yiniq cleq ìh clênh padràng oe ta crŏng taneh, yiniq aih hanoh clênh padràng ta diac plình, èh hòm yiniq cleq ìh pèch caqnaih oe ta crŏng taneh, yiniq aih hanoh pèch caqnaih oe ta diac plình.” ");
INSERT INTO hrebt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Khoe aih haq ùh lòh mangai tiaq hŏc doe ka cabô loq ka rađeh aih Christ. ");
INSERT INTO hrebt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pang aih, Chuaq Jesus men anoe ka magai tiaq hŏc loq kô èh haq ep tŏc ta Jêrusalem, ta aih haq ep chìuq bàc kan xalep enh tì kŏng ƀài gucraq, ƀài pajàu kàn xam ƀài mangai hnài ranenh, ta aih èh wì jêh cađac haq ka cachìt, trùh hì piq aih èh haq hi rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Phiero qnàng Chuaq Jesus lam takênh, haq tagàih: Ùh đòh Craq au, Boc Plình ma manaq taleq, ƀài yiniq aih ùh i trùh ti Ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Chuaq Jesus wìh hlài rai tapoch ka Phiero: “Wia loh oe enh rù ka au! Satan, ìh qnang broq kan catoeh ka au, tagàu ìh ùh i hèm trùh trong da Boc plình, mahaq hèm trùh toq trong da kon mangai.” ");
INSERT INTO hrebt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chuaq Jesus doe ka ƀài mangai tiaq hŏc: “Mangai leq enh tiaq au, ep tamùa rađeh, ep xùi dèh long pagat hu tiaq au. ");
INSERT INTO hrebt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Majah qmang aih, mangai leq enh dŏng dèh kan rìh, kan rìh aih èh hnhung, mangai leq jao au chìuq cađac qmòe rađeh, kan rìh mangai aih èh jah hlài. ");
INSERT INTO hrebt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mangai leq jah dìq dŏng crŏng taneh kô mahaq cađac hnhung dèh mahua yiang, aih jah cleq? Haq aih èh yŏc cleq hu baxon yŏc hlài dèh mahua yiang? ");
INSERT INTO hrebt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Majah qmang aih, kô èh Kon mangai oe ta qne kan ranhòm dèh Baq, pajùm ti ƀài ƀình plình đòeq hu loh crŏng taneh, jò aih èh haq baha am ka tang ngai tiaq tang yiniq wì ma khoe broq. ");
INSERT INTO hrebt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Joq qnàng au doe ka pì: Taqne ƀài pì ma yòng jang kô, i qnah ngai ùh cachìt adroe ka jah hnoq Kon mangai trùh dèh enh diac haq.” ");
INSERT INTO hrebt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tadràu hì atìq ka aih, Chuaq Jesus aràng Phiero, Jaco xam Jon oh Jaco, tiaq haq tŏc ta wang haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ta aih haq wìh wìa enh ngèa wì aih hadrò haq ka ah tìah ka mat mahì, eo haq tabŏc tìah ka kan qngah. ");
INSERT INTO hrebt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jò aih i Môise xam Êli trùh hatuàng ti Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Phiero doe ka haq: Chuaq au! tanòe kô joq lem ka bèn oe, tàng troq ka manoh ìh, au broq piq toq hapom tacô, moeq ka Ìh, moeq ka Môise, moeq ka Êli. ");
INSERT INTO hrebt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Jò haq oe raq tapoch, i kan yùc tabŏc glàp dŏng ƀài wì ma oe ta aih, i bàu tapoch loh enh yùc: “Hacô Kon calô Au, lem manoh Au rìm trong, thê tamàng bàu haq”. ");
INSERT INTO hrebt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jò ƀài mangai tiaq hŏc, tàng bàu aih, haq cro bla op dŏng ta haqneq, wì dìq jaq crè. ");
INSERT INTO hrebt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mahaq Chuaq Jesus lam haten, bèq wì haq rai doe: “Drah yòng beq! Ùh dùh yùq cadèh.” ");
INSERT INTO hrebt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mangai tiaq hŏc qngŏc ngan hnoq moeq ngai Chuaq Jesus raq. ");
INSERT INTO hrebt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jò wì haq loh enh wang, Chuaq Jesus ùh lòh wì haq “Yiniq pì ma khoe hnoq, ùh dùh anoe hlài ka cabô, gòm trùh jò Kon mangai rìh hlài enh cachìt”. ");
INSERT INTO hrebt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mangai tiaq hŏc bòch: Qmang aih hagleq ƀài mangai hnài ranenh doe Êli ep trùh adroe? ");
INSERT INTO hrebt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chuaq Jesus padreo bàu “Joq, Êli ep trùh đòeq hu palauq hlài rìm trong. ");
INSERT INTO hrebt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mahaq au doe ka pì: Êli khoe trùh, wì ùh canau ka haq, mahaq wì tabroq ka haq tiaq dèh manoh cla. Kon mangai kô èh hanoh ep pòq kan xalep enh wì aih qmang ka haq aih diq. ");
INSERT INTO hrebt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mangai tiaq hŏc hi tem bàu haq, wì loq aih haq ràu trùh Jon Baptit.” ");
INSERT INTO hrebt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jò Chuaq Jesus xam mangai tiaq hŏc wìh hlài tanòe bàc ngai, i moeq ngai thia haten, hacùn cràng enh ngèa ka Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","haq aih doe: Waiq Chuaq, Ìh tamèt ka kon au diq, majah qmang aih haq loh ka jìq troq, jìq oe i jaq cleq, tacro yôt ta ùnh, cro yôt ta diac. ");
INSERT INTO hrebt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Au khoe qnàng haq trùh ti ƀài mangai tiaq hŏc ìh, mahaq wì haqnauq ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chuaq Jeus padreo bàu: “Ƀài nang noe ùh i manoh lùi meh, au oe jah oe ti pì trùh pang leq? Au àt ka pì trùh jò leq? Aràng kon mangai qyoh aih tacô.” ");
INSERT INTO hrebt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Khoe aih Chuaq Jesus cwò kan kiac, kiac hi loh enh gùng ka kon mangai qyoh aih, pang aih kon qyoh aih jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mangai tiaq hŏc thia haten ka Haq đòeq hu bòch: Hagleq nhèn drùh kiac aih ma ùh jah? ");
INSERT INTO hrebt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chuaq Jesus padreo bàu: “Jao pì biaq manoh lùi: Au anoe joq qnàng ka pì, tàng joq pì i manoh lùi toq clong cachiq habài, pì thê wang kô: Qnhac enh kô tŏc pah tau, haq hi qnhac rađeh, èh ùh i yiniq leq pì broq ma ùh jah. (I hset dùnh tam moeq brong) ");
INSERT INTO hrebt_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mahaq kiac qmang kô, tàng pì ùh waiq khàn rai apàm ka acaq, pì drùh haq ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jò Chuaq Jesus xam mangai tiaq hŏc lam pajang gùng Galili, Haq doe ka wì: “Kon mangai kô èh mùt ta cadop tì wì. ");
INSERT INTO hrebt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Èh wì jêh cađac Haq, mahaq trùh hì piq, Haq hi rìh hlài. Ƀài mangai tiaq hŏc mangò haraya. Chuaq Jesus am thèq ");
INSERT INTO hrebt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jò khoe trùh ta Cabênaum, ƀài mangai yŏc thèq ka hnem kùh waiq lam bòch Phiero: Mangai hnài da ìh qmat i am thèq ùh? ");
INSERT INTO hrebt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Haq padreo bàu: i. Jò Phiero mùt ta hnim Chuaq Jesus khoe chônh bòch haq: “Simôn, ìh hèm qmang leq? Ƀài bùa oe ta crŏng taneh kô yŏc thèq cabô? Yŏc da kon cla loq yŏc da wì enh gùng? ");
INSERT INTO hrebt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Phiero doe: yŏc da wì enh gùng. Chuaq Jesus doe: “Tàng qmang aih ƀài kon calô haq ùh hìaq ep am thèq. ");
INSERT INTO hrebt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mahaq, đòeq bèn ùh hìaq broq dua qmèq ka wì haq, ìh loh ta diac axai ka, rùp pliang ka ma kap axay adroe, wah hacùng haq, ìh hnoq mòeq hliac bac oe ta dalam. Aràng bac aih hu am thèq ka ba. ");
INSERT INTO hrebt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jò aih ƀài mangai tiaq hŏc thia haten ka Chuaq Jesus, wì haq bòch: Ta diac plình mangai leq ma yeo haqnhèq dŏng ka mangai qnoeq? ");
INSERT INTO hrebt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chuaq Jesus creo ka moeq ngai kon qyoh, dôq haq oe ta qne ƀài mangai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Haq hi doe: “Tàng joq pì ùh tablòq hlài, dôq tìah ka kon qyoh kô, aih èh ùh i mangai leq jah mùt diac plình. ");
INSERT INTO hrebt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Qmang aih mangai leq pa haqneq rađeh troeq kon qyoh kô, haq aih èh ma yeo haqnhèq tanòe diac plình. ");
INSERT INTO hrebt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Èh hòm oe enh dalam ka yiniq au mangai leq ma chìuq đìh kon mangai qyoh kô, aih haq đìh au. ");
INSERT INTO hrebt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mahaq, mangai leq broq ka moeq ngai kon qyoh qmang kô jò haq khoe lùi au cro ta yiniq lui, yŏc apau hmo ma kàn taqmac ajang ranŏng haq aih, khoe èh cadram caqnìh ta diac raxìq xan ka ùh hnau hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Haƀo ka crŏng taneh kô, majah qmang aih i bàc yiniq broq ka kon mangai catoeh! Hiloq waq ka i kan catoeh, mahaq joq haƀo ka mangai broq kan catoeh ka wì qnoeq! ");
INSERT INTO hrebt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tàng joq tì qnì jènh pì broq ka pì clìh ta yiniq lui, drah pot khwênh cađac ma hangai ka pì, yac ka tapot jènh tapot tì mahaq jah mùt tanòe kan rìh halình, ma hnau ka oe tôm baiq jènh baiq tì mahaq wì hwênh caqnìh tabau ùnh moeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tàng mat pì broq ka pì clìh ta yiniq lui, drah ngwia khwênh cađac ma hangai ka pì, majah qmang aih yac ka oe moeq apah mat raq mahaq jah mùt ta kan rìh halình, dua ùh hnau ka oe tôm baiq pah mat mahaq clìh ta bau ùnh ta hwinh. ");
INSERT INTO hrebt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ngan oq!! Apaq jù moeq ngai kon qyoh leq oe taqne ƀài qyoh kô, majah qmang aih au doe ka pì, ƀình plình da wì haq qmat hnoq yôt hadrò Baq au, aih Mangai oe ta plình. ");
INSERT INTO hrebt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Pì hèm qmang leq? Tàng mangai leq i moeq hrinh toq trìu, yàng i mòeq toq lac hnhung, haq ma ùh đòeq đò hachìn jàt hachìn toq kon trìu oe ta wang đòeq hu lam chaq mòeq toq kon trìu ma khoe hnhung aih qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Joq qnàng au anoe ka pì, tàng joq haq chaq hi hnoq hlài, haq lem bùi ka kon trìu aih ùh hnau ka hachìn jàt hachìn toq kon trìu ma ùh hìaq hnhung tau. ");
INSERT INTO hrebt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hadai qmang aih diq, Baq pì oe ta plình hanoh ùh enh dôq ka mòeq ngai kon qyoh leq oe taqne ƀài kon qyoh kô hnhung cađac. ");
INSERT INTO hrebt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Tàng joq oh daq ìh troq loh yiniq ka ìh, tagàih ka haq jò moeq ngai ìh raq oe ti haq, tàng haq tàng bàu, ìh jah hlài dèh oh daq. ");
INSERT INTO hrebt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tàng joq haq ùh tàng, ìh akhen tam moeq baiq ngai lam ti ìh, dôq bàu i baiq piq ngai wiang tamàng, aih èh rìm trong men loh ka kajap. ");
INSERT INTO hrebt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tàng joq haq ùh tamàng bàu wì aih, aih ìh hi anoe ka Tagop Hadròeh, tàng joq haq dua ùh tàng bàu Tagop Hadròeh, aih hi ngan haq tìah wì mangai enh gùng tìah ka mangai yŏc thèq diq. ");
INSERT INTO hrebt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Joq qnàng, au doe ka pì, waq toq yiniq cleq pì kàt rahnit ta crŏng taneh kô, ta plình hanoh kàt rahnit. ");
INSERT INTO hrebt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Joq qnàng, au anoe tam ka pì, tàng joq baiq ngai taqne pì hi hatroq manoh ti dabau, yac ka waiq trong leq, Baq au oe ta plình dua am ka wa haq. ");
INSERT INTO hrebt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Majah qmang aih, tanòe leq i baiq piq ngai canòm hiniq au hu àng tagop ti dabau, ta aih au oe taqne wì haq”. ");
INSERT INTO hrebt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Phiero lam haten ka Chuaq Jesus, haq bòch: Chuaq au, tàng joq oh daq au loh yiniq ka au, aih èh au ep cađac ka haq aih toq leq yàng? Ajoq ta pèh yàng ùh? ");
INSERT INTO hrebt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Chuaq Jesus padreo bàu: “Au doe ka ìh ùh xài tapèh yàng, mahaq tapèh jàt yàng tapèh”. ");
INSERT INTO hrebt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Qmang aih, diac plình tìah ka bùa tau, enh hatình dèh bac jèn ka ƀài mangai hapŏng haq ");
INSERT INTO hrebt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jò bùa bu ngan jàiq, wì qnàng ka haq moeq ngai pòq dòeh bùa moeq jàt muàn talàng. ");
INSERT INTO hrebt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pàng haq aih pi i qmòe cleq hu caqnaih, wì craq thê tech cla haq, cadrì kon haq xam ƀài dahwèq haq, đòeq hu caqnaih dòeh. ");
INSERT INTO hrebt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mangai hapŏng aih hi bla op ajang jènh cla craq rai waiq dang: Wì craq, ìh qnhùa ka au da adia, au hu caqnaih dŏng da ìh! ");
INSERT INTO hrebt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Cla wì craq tamèt ha-och ta manoh, hi caqnaih haq hlài rai paclaih hloe dòeh ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mahaq jò magai aih loh hlài, glàm moeq ngai bua haq ma hadai abroq qmoeq qmang ti haq, i pòq dòeh haq moeq hrinh đoniê, haq it ranŏng dèh bua aih rai doe: Drah caqnaih da au dòeh beq! ");
INSERT INTO hrebt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Bua haq bla op haqneq, rai waiq dang: Ìh qnhùa ka au adia, i au caqnaih dŏng da ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mahaq haq aih ùh qmòe blinh, dua waq ka rùp clêh đac dèh bua ta hnem tù, trùh jò leq claih dŏng ka dòeh men waq hêq. ");
INSERT INTO hrebt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ƀài bua haq hnoq qmang aih, wì mangò raya, lam taqmon dèh ka wì craq rìm yiniq ma khoe hnoq. ");
INSERT INTO hrebt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Cla wì craq creo ka mangai hapŏng aih trùh rai doe: “Ìh qmat joq mangai hapŏng ngang dù qnàng, au khoe cađac dŏng dòeh ka ìh, jao ìh waiq dang au. ");
INSERT INTO hrebt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ìh ma ùh khòh loq ha-och dèh ka bua ma abroq moeq qmang ti ìh troeq au khoe loq waq ka ìh qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cla wì craq nòeh haraya, hataq haq aih ka mangai wèq hnim clêh mangai trùh jò leq haq claih dŏng dèh ka dòeh. ");
INSERT INTO hrebt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tàng joq pì ùh dìq ka manoh caqnaih ƀài yiniq lui ka oh daq, aih èh Baq au oe ta plình hanoh broq ka pì qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Khoe ka hnài qmang aih, Chuaq Jeus loh enh gùng Galili lam trùh ta gùng Giuđê, pah tau ka cròng diac Jôđan. ");
INSERT INTO hrebt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","I mangai bàc pi cajaq tiaq haq, haq broq brêh dŏng ka mangai ma ùh hrŏc yinìq ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mangai Pharisi trùh ten đòeq hu qnhro haq, wì bòch: Yac ka qmang leq, qmang leq, tiaq trong ranenh, mangai calô akhòh cađac mai ùh? ");
INSERT INTO hrebt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Haq padreo bàu doe: “pì ma qnhòq lah ngan ta hset, jò baxèm Boc Plình broq moeq mangai gucalô xam moeq mangai gucadrì, ");
INSERT INTO hrebt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Haq i doe: Aih ìq, mangai calô ma jah talah dèh ka miq baq, hu hatop dèh ti mai, wa baiq ngai hi wìa moeq xech qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pang aih, ŏng mai pi oe xài baiq hòm, mahaq moeq chac raq. Qmang aih, kon mangai ùh khòh lah ƀài mangai Boc Plình ma khoe taqmroq”. ");
INSERT INTO hrebt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wì bòch hòm: Tàng joq qmang aih hagleq Môise ma jah thê achìh jàiq ta cađac đòeq broq ƀò acang, khoe aih dôq mai haq lam? ");
INSERT INTO hrebt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chuaq Jesus doe: “Jao pì cadoq manoh Môise majah lòh pì cađac mai, mahaq jò baxèm ùh i qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Au anoe ka pì, tàng joq mangai leq cađac mai, mahaq ùh xài jao haq tango, đoèq hu lam yŏc mai qnoeq, mangai aih loh mangai tango, èh hòm, cabô yŏc cadrì wì ma cađac, mangai aih khoe i tuiq tango. ");
INSERT INTO hrebt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mangai tiaq hŏc doe: Tàng joq mangai gucalô ep broq qmang aih, hêq ùh yŏc dŏng mai yi hnao hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Chuaq Jeus doe: “Ùh xài rìm ngai dìq hlàt wê bàu kô, mahaq dôq toq ka mangai Boc Plình ma khoe thê qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Majah qmang aih, i qnah ngai ùh yŏc mai taiq jò ha-uang haq khoe qmang aih raq, i qnah ngai, ùh yŏc mai jao enh tì kŏng kon mangai broq, hadai i qnah ngai nhet ka diac plình, majah to broq ka rađeh dech. Mangai leq hlàt wê bàu aih wê beq”. ");
INSERT INTO hrebt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Khoe aih wì aràng trùh ka Chuaq Jesus ƀài kon qyoh, dôq haq roh tì ta chac wì haq rai waiq khàn am ka wì haq, mangai tiaq hŏc tagàih ka ƀài mangai ma aràng. ");
INSERT INTO hrebt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mahaq Jeus doe: “Dôq kon qyoh jah trùh ti au, apaq tàt wì haq, majah qmang aih diac plình aih da mangai leq ma tìah ka ƀài kon qyoh.” ");
INSERT INTO hrebt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Haq yŏc tì bèq bòe kon qyoh, khoe aih haq loh lam. ");
INSERT INTO hrebt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jò aih, i moeq ngai trùh bòch Chuaq Jeus: Mangai hnài, trong lem leq au ma ep broq đòeq hu jah kan rìh mòeq đòe? ");
INSERT INTO hrebt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chuaq Jesus bòch: “Hagleq ìh ma jah bòch au trùh trong lem? I moeq Ngai raq malem. Tàng joq ìh enh jah kan rìh halình moeq đòe, ìh ep wèq ƀài ranenh”. ");
INSERT INTO hrebt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Haq aih bòch: Ƀài ranenh leq? Chuaq Jesus doe: “Ƀài ranenh kô: Apaq jêh đac mangai, ùh dùh tango, ùh dùh atùng, ùh dùh wiang tapoch hwang, ");
INSERT INTO hrebt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","loq iu loq camaih ka miq baq rai loq ha-och dèh ka mangai haten tìah ka cla ìh”. ");
INSERT INTO hrebt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mangai radam aih doe: Au khoe wèq dìq dŏng ƀài ranenh kô, oe i ranenh leq hòm? ");
INSERT INTO hrebt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chuaq Jesus doe: “Tàng joq ìh enh waq ka geo gua, drah hlài tech dŏng kùng hang ta hnim đòeq hu am ka mangai pa, qmang aih èh ìh hi jah hang lem ta diac plình, khoe aih hi lam tiaq au”. ");
INSERT INTO hrebt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mahaq jò mangai radam tàng bàu aih, haq loh lam rai mangò haraya, majah qmang aih haq i kùng hang bàc pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chuaq Jesus doe ka mangai tiaq hŏc: “Joq qnàng au doe ka pì, mangai padrŏng mùt diac plình joq xa haraya. ");
INSERT INTO hrebt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Au anoe hòm ka pì lŏcđa mùt trom jrùm yi hlàu ka mangai padrŏng mùt diac Boc Plình”. ");
INSERT INTO hrebt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mangai tiaq hŏc tàng bàu aih, dìq jaq hamàih, wì haq bòch: Qmang aih mangai leq majah dèch? ");
INSERT INTO hrebt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chuaq Jesus ngan ƀài mangai tiaq hŏc: “Trong aih kon mangai broq ùh jah mahaq Boc plình broq trong leq dua jah”. ");
INSERT INTO hrebt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Phiero doe: Hacô, nhèn khoe cađac dìq dŏng đòeq tiaq Ìh, aih èh nhèn jah cleq? ");
INSERT INTO hrebt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Chuaq Jesus padreo bàu: “Joq qnàng au anoe ka pì, trùh jò rìm ka yiniq loh ka neo dìq dŏng, aih jò Kon mangai hangui deh tagèq ranhòm cla haq, pì mangai ma khoe tiaq au hadai jah hangui ta moeq jàt baiq toq gèq, đòeq hu hadrah ka moèq jàt baiq xinoe Isorali. ");
INSERT INTO hrebt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mangai leq taiq yiniq au loh qmòe ka cađac dèh oh daq calô, oh daq cadrì, xam kon, xam taneh ruàng, xam hnim, mangai aih èh jah hlài yeo bàc ùh hnau ka aih hòm, èh jah kan rìh halình moeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mahaq bàc ngai adroe loh ka atìq, bàc ngai atìq loh ka adroe. ");
INSERT INTO hrebt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Majah qmang aih, diac plình tìah ka wì craq ta hnim tau, bu padrèh qngah khoe loh lam, chaq mangai hu mùt abroq dèh ta wuàn plì nho, ");
INSERT INTO hrebt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jò haq khoe òq ka baha mangai patìh, mòeq hì mòeq đoniê, haq hi thê wì aih mùt dèh ta wuàn. ");
INSERT INTO hrebt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Qnah ta hachìn jò di sroq, haq aih lam hòm, hnoq ƀài mangai qnoeq, oe dech ùh i ka yiniq broq qnang yòng tanòe wì ma padro atech. ");
INSERT INTO hrebt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Haq doe ka wì aih: Pì mùt ta wuàn plì nho au beq, au baha pì ùh hìaq hamoq. ");
INSERT INTO hrebt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wì aih hi drah lam. Jò qne hì trùh qnah ta piq jò, haq loh lam hòm, haq hadai broq qmang aih raq. ");
INSERT INTO hrebt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Canau khoe ta padam jò haq lam hòm, hnoq wì mangai qnoeq hòm yòng tanòe wì ti padro atech, haq hi bòch: Hagleq pì ma jah yòng ta kô xèq ka hì ùh dùh broq qmòe cleq? ");
INSERT INTO hrebt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wì aih padreo bàu: Ùh i qmòe ka cabô creo ka nhèn broq. Haq doe ka wì aih: Pì hadai mùt ta wuàn au beq. ");
INSERT INTO hrebt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Trùh clam, cla wì craq wuàn nho doe ka mangai ma wèq ngan wì abroq: Lam creo ka wì ma abroq hu caqnaih da wì haq kùng, patep enh mangai ma atìq dŏng, èh hi trùh mangai ma adroe. ");
INSERT INTO hrebt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wì mangai ma abroq pang padam jò di xèq jah yŏc moeq ngai moeq đoniê. ");
INSERT INTO hrebt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Èh ƀài mangai ma abroq enh jò baxèm trùh, hèm dèh canau đeh jah yeo bàc, yàng èh hadai moeq đoniê. ");
INSERT INTO hrebt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jò khoe yŏc kùng baha, wì aih badrùt mamùc ka cla wì craq, ");
INSERT INTO hrebt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","wì haq doe: Ƀài mangai ma atìq qmat broq moeq ahyàc raq, ìh baha ka wì haq taq atoq qmòe ka nhèn kô ƀài mangai ma abroq lep xèq ka hì rai catènh tôq. ");
INSERT INTO hrebt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mahaq wì craq aih, anoe ka mòeq ngai taqne ƀài wì aih: Ê daq, au tình ka ìh ma i hamoq, ma ùh joq ìh khoe òq ka au moeq đoniê raq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hêq yŏc da ìh kùng kan qmat khoe lam beq, au enh baha ka mangai ma atìq taq atoq qmang ka au khoe baha ìh diq. ");
INSERT INTO hrebt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kùng hang cla, au ma ùh khòh broq tiaq dèh manoh cla qmòh? Ahìaq hnoq au rìh lem ka oh daq, mat ìh majah loh ka tajênh ùh xài? ");
INSERT INTO hrebt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aih, mangai atìq loh ka adoe, mangai adroe loh ka atìq, aih qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jò Chuaq Jesus tŏc ta Jêrusalem, haq qnung dèh moeq jàt baiq ngai tiaq hŏc raq lam tiaq rađeh, ti trong, haq doe ka wì: ");
INSERT INTO hrebt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Beq, bèn tŏc ta Jêrusalem, Kon mangai kô èh, wì jah rùp am ka ƀài pajàu kàn xam ƀài mangai hnài ranenh, wì aih èh ma hatình ka dabau hu chaq trong jêh đac haq. ");
INSERT INTO hrebt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wì aih èh rùp haq am ka ƀài mangai ùh xài mangai Juđa, dôq wì aih do halê, blai, èh tiang đình haq ta long pagat, trùh hì piq, haq hi rìh hlài”. ");
INSERT INTO hrebt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Khoe aih, i mai da Sêƀêđê xam wa kon haq trùh haten ka Chuaq Jesus, hacùn cràng enh ngèa ka Chuaq Jesus đòeq bòch haq moeq hiniq. ");
INSERT INTO hrebt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chuaq Jesus bòch haq: “Ìh enh bòch cleq?” Mangai gucadrì aih doe: Ìh am wa kon au kô mòeq ngai jah hangui pah qma ka ìh, mòeq ngai jah hangui pah qngeo ka Ìh oe ta diac ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Chuaq Jesus doe: “Pì ùh qnì ka rađeh qnang bòch cleq, chrŏng au ma ôq kô èh pì ôq ajah?” Wa aih padreo bàu: Ma ôq jah. ");
INSERT INTO hrebt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Joq chôp kô èh ôq chrŏng au mahaq hangui pah qma, pah qngeo ka au, aih ùh xài au am, nòe aih đòeq toq ka ƀài mangai Baq au khoe palauq adroe”. ");
INSERT INTO hrebt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Moeq jàt ngai tiaq hŏc tau, tàng bòch qmang aih, wì haq nòeh ka wa oh daq aih. ");
INSERT INTO hrebt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mahaq Chuaq Jesus creo ka wì trùh, haq doe: “Pì loq, bùa ƀài diac wì padit dôq wì qnoeq patìh ka rađeh, ƀài cwan kàn yo dèh cwìang đòeq hu oe enh qnhèq ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yàng pì kô ùh xài qmang aih, mahaq taqne pì mangai leq enh broq kàn, mangai aih ep broq hapŏng pì, ");
INSERT INTO hrebt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","mangai leq enh broq gàu, mangai aih ep broq dìc pì. ");
INSERT INTO hrebt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Qmang ka Kon mangai khoe trùh, ùh xài đòeq mangai qnoeq patìh ka rađeh, mahaq đòeq cla rađeh patìh ka wì, rai phùq dèh kaxènh broq maneh đòeq hu baxon yŏc hlài bàc ngai. ");
INSERT INTO hrebt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jò Chuaq Jesus xam mangai tiaq hŏc loh enh plài Giêricô, i mòeq calùh mangai ra rawình ti tiaq haq. ");
INSERT INTO hrebt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","I baiq ngai lua mat oe kênh trong, tàng doe i Chuaq Jesus lam pagat trong aih, wa aih creo cadêh: Waiq Chuaq, kon xau bùa Đawit, ha-och ka ma diq! ");
INSERT INTO hrebt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wì lech ka wa aih, thê wa hatinh, mahaq wa aih creo yeo dêh hòm: Waiq Chuaq, kon xau bùa Đawit, ha-och ka ma diq! ");
INSERT INTO hrebt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chuaq Jeus hi yòng, creo ka wa aih trùh, haq bòch wa: “Chôp enh au broq ka chôp cleq?” ");
INSERT INTO hrebt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wa aih doe: Ma enh mat ma jah xau hnoq. ");
INSERT INTO hrebt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chuaq Jesus ta manoh ha-och ka wa. Haq bèq mat wa, tajòe qmòe wa jah xau hnoq, èh wa hi tiaq hloe Haq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jò Chuaq Jesus xam ƀài mangai tiaq hŏc khoe ten trùh ta Jêrusalem, khoe trùh ta Bêpha-giê, haq hi tŏc ta wang Ôliu, khoe aih haq thê baiq ngai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Haq doe: “Chôp mùt ta plài enh ngèa ka chôp qmat, chôp hi hnoq moeq toq lùa kan wì khoe kàt xam kon haq, chôp caqnaih èh dùi aràng ka au tacô. ");
INSERT INTO hrebt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tàng i cabô doe cleq, chôp doe ka wì Chuaq i yiniq waq ka baiq toq lùa kô, aih èh wì hi caqnaih ka chôp tiaq”. ");
INSERT INTO hrebt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yiniq kô loh qmang aih đoèq xìt troeq bàu pajàu khoe anoe: ");
INSERT INTO hrebt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Anoe ka kon cadrì Siôn, Kô, bùa pì trùh ti pì, Khun khauq, oe enh crŏng lùa Aih lùa kon, kan haq bac long ech. ");
INSERT INTO hrebt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mangai tiaq hŏc hi loh lam rai broq tiaq qmang ka bàu haq khoe tanap. ");
INSERT INTO hrebt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wa dùi lùa kan xam kon haq, yŏc dèh eo hlèch enh crŏng lùa, khoe aih dèch Chuaq Jesus tŏc hangui enh qnhèq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Haraya cađac mangai yŏc eo hlèch ti trong lam, mangai qnoeq hòm goh hamenh long xap ti trong. ");
INSERT INTO hrebt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dìq ka wì ma lam adroe xam mangai lam atìq hadai creo ka dêh: Hôsana, Kon bùa Đawit! Khòh manè Haq mangai ma yŏc Yiniq Chuaq đòeq trùh ti bèn! Hôsana oe tanòe ma dìq jaq haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jò khoe mùt ta Jêrusalem, dìq dŏng ka wì tagùng aih loh ka tagruàng tagràt, wì bòch dabau: Mangai kô ìq cabô? ");
INSERT INTO hrebt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mangai bàc ta aih padreo bàu: Kô Chuaq Jesus, Mangai pajàu oe ta Naxaret, gùng Galili. ");
INSERT INTO hrebt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chuaq Jeus mùt ta nòe hnem Kùh waiq, drùh qnoh dìq dŏng ƀài mangai padro ta aih, hacùp cabŏng ƀài mangai ti halìh bac jèn, caqnhùt đac gèq ƀài mangai tech trù hangui. ");
INSERT INTO hrebt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Haq doe ka wì: “I bàu khoe achìh, hnim au jah creo hnim waiq khàn, mahaq pì broq hnim aih loh kòp atùng. ");
INSERT INTO hrebt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jò aih, ƀài mangai ùh xau hnoq, mangai liap, trùh ti haq tanòe hnim kùh waiq, haq broq brêh dŏng ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mahaq ƀài pajàu kàn, ƀài mangai hnài ranenh hnoq kan halac haq khoe broq, èh wì tàng tam bàu kon qyoh cachech ta hnim kùh waiq: Hôsana Kon bùa Đawit! Wì plôh nòeh, ");
INSERT INTO hrebt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","wì doe ka haq: Ìh atàng bàu ƀài kon qyoh anoe cleq ùh? Chuq Jesus doe: “Au tàng. Pì qnhòq lah đŏc bàu kô ta hset hadròeh qmòh? Chuaq khoe jah bàu manè loh enh hacùng kon qyoh xam kon qyoh oe ùq qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Khoe èh haq hi cađac wì aih haq mùt ta plài Bêthani, mang aih haq kùi ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sroq èh, jò wìh hlài ta Jêrusalem, haq pangot. ");
INSERT INTO hrebt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hnoq ti trong i moeq xèm long pŏc, haq thia ka haten, yàng hnoq toq hla, haq cwò ka long pŏc: Gè kô èh pi jò leq oe loh plì hòm! Long pŏc croh qmòe jò aih raq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mangai tiaq hŏc hnoq qmang aih, wì haq hamàih, wì bòch: Hagleq bu moeq hyàc long pŏc ma khoe croh qmang qmat? ");
INSERT INTO hrebt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Chuaq Jesus doe: Joq qnàng! au anoe ka pì, tàng joq pì i manoh lùi ùh hìaq rangòt, ùh xài pì broq jah toq yiniq khoe broq ka long pŏc kô, yac ka pì doe ka bui wang kô: Dèch caqnìh rađeh ta diac raxìq beq, yiniq aih broq dua jah. ");
INSERT INTO hrebt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jò waiq khàn, pì yŏc manoh lùi đòeq waiq khàn, yac ka pì bòch cleq, dua jah dŏng dìq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jò Chuaq Jesus khoe mùt ta hnim kùh waiq, haq qnang hnài wì, i ƀài pajàu kàn xam ƀài gucraq mangai Juđa trùh bòch haq: Ìh yŏc cwìang enh leq ma hu broq qmang kô, cabô khoe am ka ìh cwìang kô? ");
INSERT INTO hrebt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Chuaq Jesus padreo bàu: “Au hanoh bòch pì mòeq yiniq, tàng joq pì tèu da au, au hanoh anoe am ka pì loq au yŏc cwìang enh leq ma broq ƀài yiniq kô. ");
INSERT INTO hrebt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ƀaptem da Jon aih loh enh leq? Loh enh diac plình loq loh enh kon mangai?” Wì aih hatuàng ka dabau: Tàng joq bèn doe loh enh plình, aih èh haq bòch bèn qmang aih gleq pì ùh lùi? ");
INSERT INTO hrebt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tàng bèn doe: Loh enh kon mangai, aih bèn ùh hùa ka wì phù cròng, majah qmang aih dìq ka phù cròng mangai leq mangai meh dìq doe Jon aih pajàu. ");
INSERT INTO hrebt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wì doe ka Haq: Nhèn ùh qnì. Chuaq Jesus doe ka wì: “Au hadai ùh doe ka pì loq cwìang enh leq ma broq bòe yiniq kô”. ");
INSERT INTO hrebt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Pì hèm qmang leq? I moeq ngai tau, haq i baiq ngai kon calô, haq doe ka mangai kon ramua: Kon! hì kô kon lam broq ta wuàn nho oq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kon aih doe: Òq baq, mahaq khoe aih haq ùh waq lam. ");
INSERT INTO hrebt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Khoe aih, mangai baq lam ajang kon ma hatìa, hanoh doe qmang ka adroe ìq diq. Kon ma kô doe: Au ùh enh lam. Yàng khoe ka aih haq hèm hlài, haq hi lam. ");
INSERT INTO hrebt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Taqne wa aih ma leq ma broq tiaq bàu dèh baq?” Wì doe: Mangai ma atìq. Chuaq Jesus doe ka wì aih: “Joq qnàng au anoe ka pì, ƀài mangai ti yŏc thèq xam ƀài gucadrì ti taqnung tango jah mùt diac Plình adroe ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Majah qmang aih Jon khoe tiaq trong taq atoq lam trùh ta pì, mahaq pì ùh lùi haq, yàng ƀài mangai ti yŏc thèq xam ƀài mangai gucadrì ma taqnung tango aih khoe lùi haq, èh da pì hòm yac ka khoe hnoq qmang aih, dua ùh waq raxach đòeq hu lùi haq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Pì tamàng tam bàu alìah qnoeq hòm. I mòeq ngai pìt wuàn nho, haq kàng canàng dudan, enh dalam haq chìa moeq toq ralùng hu broq alac, èh haq broq moeq toq hapom haqnhèq, khoe aih haq am ka wì muàn pìt ta axong, cla haq lam gùng qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Trùh jò git plì, cla haq thê dèh mangai hapŏng trùh ta nòe ƀài mangai ma abroq ta aih, đòeq hu yŏc dèh plì. ");
INSERT INTO hrebt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ƀài mangai pìt nho rùp ƀài mangai hapŏng aih, wì hwat mangai kô, jêh đac mangai meh, yŏc hmo đàp mangai tau. ");
INSERT INTO hrebt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Cla wì craq, thê hòm ƀài wì hapŏng ma qnoeq, yeo bàc ka yàng adroe, yàng èh hadai wì tabroq ka ƀài hapŏng kô tìah ka ƀài hapŏng ma adroe diq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Atìq dŏng, cla wì craq thê dèh kon cla haq trùh ta wì aih, majah qmang aih haq hèm dèh ta manoh: Kon cla au kô, wì aih loq yi camaih. ");
INSERT INTO hrebt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mahaq, jò ƀài mangai pìt nho hnoq kon aih, wì haq doe ka dabau: Kô raq mangai hu jah waq dŏng kùng hang, beq bèn jêh đac hloe èh bèn hu blah yŏc hloe hang haq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wì hi rùp mangai kon aih, qnoh enh gùng ka wuàn plì nho, jêh cađac hloe. ");
INSERT INTO hrebt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Qmang aih èh jò cla wì craq trùh haq broq ka ƀài mangai pìt nho kô qmang leq cadèh? ");
INSERT INTO hrebt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wì padreo bàu: Cla wì craq aih trùh haq jêh palùng đac ƀài ngang dù aih, èh haq yŏc hlài dèh wuàn đòeq am ka mangai qnoeq patìh acaq axon, aih la ƀài mangai waq toq hi trùh jò hi dèch am phàn da cla wì craq. ");
INSERT INTO hrebt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Chuaq Jesus doe: “Pì ma qnhòq đŏc ta hset Hadròeh: Hmo ƀài mangai broq hnem khoe qnìh đac, khoe wìa hmo mùm hnim. Aih yiniq Boc Plình broq. Ma ùh joq kan halac enh ngèa bèn qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aih au ma jah doe ka pì, diac Boc Plình jah doeh yŏc enh pì qmat èh đoèq hu am ka mangaì qnoeq aih la ƀài mangai ma loh plì lem am ka diac aih. ");
INSERT INTO hrebt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Cabô ma taclìh enh crŏng hmo aih èh, haq hech pòh dŏng dìq, hmo aih clìh enh qnhèq ka cabô, mangai hadai hech loh blo”. ");
INSERT INTO hrebt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ƀài mangai hnài ranenh xam mangai Pharisi tàng bàu aih, wì loq Chuaq Jesus tapoch ka wì haq; ");
INSERT INTO hrebt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","wì chaq yiniq hu rùp haq, mahaq yùq ka phù cròng, majah qmang aih wì phù cròng khoe doe Chuaq Jesus aih mangai pajàu. ");
INSERT INTO hrebt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Chuaq Jeus alìah tam ka wì aih: ");
INSERT INTO hrebt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Diac plình tìah ka bùa tau, haq broq yiniang taqnèp dèh ka kon. ");
INSERT INTO hrebt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bùa aih thê dèh ƀài hapŏng lam bahmàng ƀaàimangai ma khoe jah akhen trùh acaq yiniang mahaq wì aih ùh waq trùh. ");
INSERT INTO hrebt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bùa thê hòm ƀài hapŏng qnoeq lam rai tanap: Doe ka ƀài mangai ma khoe jah bàu akhen: Au khoe padon yiniang yinàng ƀo xam jam ramaq au khoe bùh, cleq clài hadai khoe padon đòeq, drah trùh hu hangui acaq yiniang. ");
INSERT INTO hrebt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mahaq wì ùh do tamàng, mangai lam dèh hra trong, mangai kô loh ta ruàng, mangai tau lam padro, ");
INSERT INTO hrebt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","mangai qnoeq hòm rùp hapŏng bùa aih jêh cađac. ");
INSERT INTO hrebt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bùa nòeh haraya, thê ƀài lình jêh dŏng ƀài magai dù aih, bùh hloe plài wì haq. ");
INSERT INTO hrebt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Khoe aih, bùa doe dèh ka ƀòe hapŏng: “Yiniang yinàng khoe padon, mahaq ƀài mangai ma khoe jah akhen aih pi tajì ka acaq. ");
INSERT INTO hrebt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Manòeq, pì loh lam roc halah trong, waq toq hnoq mangai leq, akhen ma dìq lam acaq yiniang tacô. ");
INSERT INTO hrebt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ƀài mangai hapŏng lam jàp rìm trong ta aih, tagop dìq mangai wì haq glàm, lem qmèq ùh loe, ta hnim loh ka bìn bauq mangai hangui acaq yiniang yinàng. ");
INSERT INTO hrebt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Bùa mùt ngan mangai acaq yiniang, ka doe hnoq ta aih i moeq ngai ùh caxùnh eo yiniang. ");
INSERT INTO hrebt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bùa doe ka haq aih: Ùih daq, hagleq ìh mùt tacô ma ùh caxùnh eo yiniang taqnèp? Mangai aih hatinh. ");
INSERT INTO hrebt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bùa thê ƀaàimangai hapŏng: Kàt jènh tì haq qmat, khwênh qnoh ta clam tau, tanòe ma toq crò hmoe rai cadrit haneng. ");
INSERT INTO hrebt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Majah qmang aih bàc ngai jah creo mahaq toq biaq ngai raq ma jah ràih. ");
INSERT INTO hrebt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Khoe aih, mangai Pharisi loh enh gùng hatuàng ka dabau chaq trong hu bahlac Chuaq Jesus trong bàu tapoch. ");
INSERT INTO hrebt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wì haq thê dèh mangai tiaq hŏc taqmùt ti ƀòe bua da bùa Hêrôt lam bòch Chuaq Jesus: Mangai hnài, nhèn loq ìh kô joq qnàng, tiaq kan taq atoq ìh hnài trong Boc Plình, ùh wiang enh cabô, majah qmang aih ìh ùh ngan da wì toq enh gùng. ");
INSERT INTO hrebt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Doe ka nhèn loq ìh hèm qmang leq: Am thèq ka Sêsa aih troq loq ùh? ");
INSERT INTO hrebt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Chuaq Jesus loq manoh wì haq qmèq, haq doe: “Wùih ƀài mangai toq ti patìah meh, hagleq pì ma bahlac dèh ka au? ");
INSERT INTO hrebt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Am au ngan hliac pì ma đòeq am thèq. Wì aih am ka haq mòeq đoniê. ");
INSERT INTO hrebt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Haq bòch: “Kô ìq qmù cabô, achìh kô achìh cabô. ");
INSERT INTO hrebt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wì doe: Sêsa. Khoe aih Haq doe ka wì: “Padreo da Sêsa yiiniq cleq da Sêsa, padreo da Boc Plình yiniq cleq da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jò khoe tàng bàu aih, wì hi loh ka lui ta manoh. Èh wì hi lam. ");
INSERT INTO hrebt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hanoh hì aih, mangai sađusê, aih ƀài ma mangai doe ùh i ka kan rìh hlài, lam haten ka Chuaq Jesus, wì bòch: ");
INSERT INTO hrebt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mangai hnài ôi, Môise i anoe: Tàng joq mangai leq cachìt mahaq ùh i ha kon, oh haq aih ep yŏc cadrì dèh daq ma khoe hadrô aih. ");
INSERT INTO hrebt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Qmang aih nhèn i ta pèh ngai oh daq. Mangai daq ramua cachìt, mahaq qnhòq i kon, mai haq đòeq hlài dèh ka oh. ");
INSERT INTO hrebt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Èh mangai daq ma hatìa, mangai daq ma atìq trùh mangai ma atìq dŏng hanoh qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pu lùch, mangai gucadrì aih hanoh cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aih èh trùh jò rìh hlài, taqne wì tapèh ngai aih, mangai gucadrì aih èh broq mai cabô? Majah qmang aih dìq dŏng wì haq khoe yŏc mangai cadrì aih broq mai. ");
INSERT INTO hrebt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chuaq Jesus doe: “Pì hèm ùh troq, majah qmang aih pì ùh qnì ka hset Hadròeh, èh hadai ùh qnì cwìang itai Boc Plình qmang leq. ");
INSERT INTO hrebt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Majah qmang aih, trùh jò rìh hlài, kon mangai ùh yŏc mai, ùh yŏc ŏng, mahaq ƀài mangai rìh hlaì tìah ka ƀình plình oe ta plình. ");
INSERT INTO hrebt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pì ma qnhòq ngan bàu Boc Plình anoe trùh kan rìh hlài da mangai cachìt: ");
INSERT INTO hrebt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Au kô Boc Plình da Apraham, Boc Plình da Ysac, Boc Plình da Jacôp qmòh? Boc Plình ùh xài Boc Plình da ƀài mangai cachìt, mahaq Boc Plình da ƀài mangai rìh. ");
INSERT INTO hrebt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tàng qmang aih, wì hamàih ka bàu Haq hnài. ");
INSERT INTO hrebt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mangai Pharisi tàng doe Chuaq Jesus khoe broq ka ƀài mangai Sađusê pi jah hah hacùng, wì haq tagop dabau. ");
INSERT INTO hrebt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Taqne wì aih i mòeq ngai hnài ranenh bòch Chuaq Jesus bàu kô đòeq hu qnhro ngan haq: ");
INSERT INTO hrebt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Mangai hnài ôi, oe ta hset ranenh, ranenh leq ma yeo kàn dìq dŏng? ");
INSERT INTO hrebt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Chuaq Jesus padreo bàu: “Ìh ep dìq ka cliac, dìq ka mahua yiang, dìq ka manoh loq waq ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aih ranenh angoe ma yeo kàn dŏng ka maqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ranenh ma atìq kô hadai qmang aih: Ìh ep loq waq ka mangai haten hatìa ka ìh tìah ka cla. ");
INSERT INTO hrebt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dìq dŏng ka ranenh xam bàu pajàu dìq loh enh baiq ranenh aih. Christ kon xau Davit ");
INSERT INTO hrebt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jò ƀài mangai Pharisi oe moeq qmang ti dabau, Chuaq Jesus bòch wì haq: ");
INSERT INTO hrebt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ràu trùh Christ, pì hèm qmang leq? Haq aih kon cabô?” wì doe: Kon bùa Đawit. ");
INSERT INTO hrebt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Haq padreo bàu ka wì aih: “Tàng qmang aih gleq bùa Đawit canòm ka Yeang Hadròeh, haq ma creo ka Christ aih Chuaq au, haq doe: ");
INSERT INTO hrebt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Chuaq doe ka Chuaq au, Hangui enh pah qma au, Trùh jò au roh ƀài mangai ma tablêq ka ìh enh qneq ka jènh ìh? ");
INSERT INTO hrebt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tàng joq jò aih Đawit khoe creo ka Haq aih: Chuaq au, aih haq broq kon bùa aih qmang leq?” ");
INSERT INTO hrebt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pi i cabô oe jah tèu mòeq nà bàu, èh hanoh pang aih, pi i cabô oe hùa bòch haq cleq hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Khoe aih Chuaq Jesus anoe ka ƀài mangai ta aih hloe xam ka mangai tiaq hŏc: ");
INSERT INTO hrebt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ƀài ngai hnài ranenh xam mangai Pharisi dìq hangui tagèq Môise. ");
INSERT INTO hrebt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Qmang aih pì ep broq tiaq rai wèq rìm trong wì haq khoe hnài pì, mahaq apaq top dua wì haq, majah qmang aih wì haq ùh broq tiaq dèh bàu đeh ma hnài. ");
INSERT INTO hrebt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wì aih yŏc kan trap, kan tawac, taqmac ta plêh wì qnoeq, mahaq cla ùh wiang poh moeq hadrang tì ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Rìm yiniq wì haq broq aih đòeq toq ka mangai qnoeq hnoq, balet akia da wì haq wê waq ka yeo kàn, cadrai eo waq ka yôh, ");
INSERT INTO hrebt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","tanòe acaq ôq wì haq enh toq hangui nòe ma rahù, ta hnim tagop wì haq enh toq haqngui nòe yeo haqnhèq dŏng, ");
INSERT INTO hrebt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","enh toq mangai qnoeq kùp gàu ka rađeh taqne chòq, enh ka mangai qnoeq creo ka rađeh Rabi! ");
INSERT INTO hrebt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mahaq pì apaq dôq wì qnoeq creo ka rađeh Rabi, majah qmang aih dìq ka pì i mòeq Mangai hnài raq, dìq dŏng ka pì qmat aih oh daq dabau. ");
INSERT INTO hrebt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hadai qmang aih, oe ta crŏng taneh kô apaq creo ka cabô aih baq rađeh, majah qmang aih pì i moeq ngai Baq raq, haq aih ta Plình. ");
INSERT INTO hrebt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hadai paq đoèq cabô creo ka pì mangai hnài, majah qmang aih dìq ka pì i moeq Mangai hnài raq, aih Christ. ");
INSERT INTO hrebt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mahaq taqne pì mangai yeo kàn dŏng, haq aih èh jah broq hapŏng ƀài pì. ");
INSERT INTO hrebt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mangai leq padèch rađeh ka haqnhèq, haq aih èh jah caqnìh qnoh haqneq, hadai qmang aih, mangai leq hamon rađeh ka haqneq haq aih èh jah padèch ka haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Haƀo ka pì, ƀài mangai hnài ranenh xam mangai Pharisi, ƀài mangai patìah toq enh gùng! Majah qmang aih pì clenh qmang diac plình enh ngèa wì qnoeq, pì qnhòq lah mùt ta aih mahaq tàng i mangai leq enh nùt aih pì tàt đac. ");
INSERT INTO hrebt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Haƀo ka pì, ƀài mangai hnài ranenh xam mangai Pharisi, ƀài mangai patìah toq enh gùng! Pì lam jàp tadiac jàp tago đòeq adràc mangai tiaq trong da pì, jò adràc khoe jah pì broq ka wì aih wìa mangai ta hwinh yi hnau cla pì baiq yàng. ");
INSERT INTO hrebt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Haƀo ka pì! ƀài mangai ùh xau broq mangai qnung trong, pì doe: Tàng i cabô patô hnim kùh waiq đòe hu hapah, aih ùh troq cleq, mahaq tàng patô wang oe ta hnim kùh waiq đòeq hu hapah, aih èh ep hlac dèh ka bàu hapah aih. ");
INSERT INTO hrebt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wùih! Mangai rai blùng rai lua meh, wang xam hnim kùh waiq ma broq ka wang aih jah hadròeh, maleq ma yeo kàn. ");
INSERT INTO hrebt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pì anoe rameh hòm: Tàng mangai leq patô prang oe tahnim kùh waiq đòeq hu hapah, aih ùh troq cleq, mahaq tàng patô ramènh tadreo oe ta prang đòeq hu hapah, haq aih èh khoe hlac dèh ka bàu. ");
INSERT INTO hrebt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wùih! mangai lua tau, ramènh tadreo, èh prang mabroq ka ramènh aih jah hadròeh, wa aih maleq ma yeo kàn? ");
INSERT INTO hrebt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Qmang aih mangai leq patô prang ta hnim kùh waiq đòeq hu hapah, aih haq patô xam prang xam ramènh oe ta prang aih, ");
INSERT INTO hrebt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","mangai leq patô hnem kùh waiq đòeq hu hapah, aih haq patô xam hnim xam Mangai oe ta hnem kùh waiq aih, ");
INSERT INTO hrebt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","mangai maleq hòm ma patô plình đòeq hu hapah, aih haq patô gèq Boc Plình xam Haq ma hangui tagèq aih. ");
INSERT INTO hrebt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kan haƀo ka pì, ƀài mangai hnài ranenh xam mangai Pharisi, ƀài mangai patìah toq enh gùng! Majah qmang aih pì dèch ka Boc Plình moeq phàn moeq jàt cachiq bŏc ha, cachiq xua thùm, cachiq thila, mahaq trong ma yeo haqnhèq dìq dŏng ta ranenh aih pì cađac, aih la kan taq toq, kan loq waq xam manoh ùh tablòq, aih ƀài yiniq pì ep broq, mahaq hadai ùh jah cađac ƀài yiniq tau. ");
INSERT INTO hrebt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wùih! ƀài mangai ùh xau broq mangai qnung trong, pì doeh đac pliang roe qyoh mahaq lonh yŏc kan o lŏcđa kaiq! ");
INSERT INTO hrebt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Haƀo ka pì! ƀài mangai hnài ranenh xam mangai Pharisi, ƀài mangai patìah toq enh gùng! Majah qmang aih, dòt doe pì haliang toq enh gùng, yàng enh dalam bình bauq toq kan atùng kan plai. ");
INSERT INTO hrebt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wùih ƀài mangai Pharisi lua mat tau, baxèm aih xài haliang enh dalam adroe, khoe aih enh gùng diq đòeq haq hanoh jah hreo. ");
INSERT INTO hrebt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Haƀo ka pì, ƀài mangai rabiaq trong ranenh xam mangai Pharisi ƀài mangai patìah toq enh gùng! Majah qmang aih pì tìah ka ralùng hanang, palàng taboc toq enh gùng waq ka lem, mahaq enh dalam bình toq caxènh hanang xam ƀài kan trùq traq. ");
INSERT INTO hrebt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pì hanoh qmang aih diq, enh gùng aih loh mangai taq atoq, mahaq enh dalam bình toq kan loq patìah xam yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Haƀo ka pì! ƀài mangai hnài ranenh xam mangai Pharisi, ƀài mangai patìah toq enh gùng! Pì xùh hanang mangai pajàu, palàng hanang mangai taq atoq, ");
INSERT INTO hrebt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","rai doe: Tàng joq bèn hadai rìh mòeq qnhòng ti wì kan cadraq nèh, bèn ùh taqmùt ka wì haq đòeq hu broq ta-ùc mahim mangai pajàu. ");
INSERT INTO hrebt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Qmang aih cla pì panhìn rađeh kô joq qnàng caxi noe ƀài mangai khoe jêuh đac bài mangai pajau. ");
INSERT INTO hrebt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Qmang aih drah broq beq dôq haq bình dŏng ka maneh kan cadraq ma khoe patep. ");
INSERT INTO hrebt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wùih ƀài bìh, ƀài xi noe bìh plŏng tau, broq qmang leq pì ma claih ka kan hadrah ta hwinh. ");
INSERT INTO hrebt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dài aih raq, au ma jah khoe thê ƀài mangai pajaù, ƀài mangai rabiaq loq, xam mangai hnài ranenh trùh ti pì, taqne wì aih, i ngai pì jêh cađac, tiang đình wì haq talong pagat, i ngai pì blai wì haq tanòe hnim tagop qyoh, pì hadai ti hnan rùp wì aih enh gùng kô trùh gùng tau, ");
INSERT INTO hrebt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","waq ka dìq dŏng ka mahim ùh i đeh ka yiniq lui cleq dahrôq jàp ta taneh, ta-ùc hlài ta pì, enh mahim Abên mangai taq atoq trùh mahim Xachari, kon da Barachi, mangai pì ma khoe jêh cađac ta adreo hnim kùh waiq xam prang tadreo. ");
INSERT INTO hrebt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Joq qnàng au doe ka pì, dìq dŏng ƀài yiniq aih èh jah trùh ti caxi noe kô. ");
INSERT INTO hrebt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jêrusalem, Jêrusalem, ìh jêh đac wì mangai pajàu rai yŏc hmo tèm ƀài mangai au ma khoe thê wì trùh ta pì, khoe bàc yàng au enh tagop ƀài kon ìh tìah ka ia kan creo deh kon trùh hu àm ta caqnàm pananh, mahaq pì ùh waq. ");
INSERT INTO hrebt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kô èh, hnim pì cađac klui dŏng! ");
INSERT INTO hrebt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Majah qmang aih, au doe ka pì, kô èh pì pi hnoq au hòm, trùh jò leq pì ma hi doe: Xôq ramot ka Mangai trùh enh dalam ka yiniq Chuaq! ");
INSERT INTO hrebt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Chuaq Jesus loh enh hnim kùh waiq, jò qnang lam ti trong, mangai tiaq hŏc trùh haten ka haq đòeq patô ka haq hnoq kan ranhòm ta hnim kùh waiq. ");
INSERT INTO hrebt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chuaq Jesus bòch wì aih: “Pì i hnoq dìq dŏng rìm yiniq taqmat ùh? Joq qnàng au doe ka pì, kô èh pi i moeq pliang hmu leq oe jah taraxon enh crŏng hmo leq hòm, dìq ep clìh dŏng taqneq. ");
INSERT INTO hrebt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jò Chuaq Jesus hangui ta bui wang Ôliu, mangai tiaq hŏc thia crài ti haq, wì doe: Ìh anoe ka nhèn loq diq, ƀài bìac aih jò leq ma trùh? Qnah hòm i kan halac cleq mahnu jò Ìh trùh, xam hì crŏng taneh kô ma hu lùch. ");
INSERT INTO hrebt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chuaq Jesus padreo bàu: “Ngan oq, paq dôq cabô padô pì. ");
INSERT INTO hrebt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Majah qmang aih bàc ngai patìah ka yiniq au đoèq trùh doe: Au kô raq Christ, rai ti aluàn bàc ngai. ");
INSERT INTO hrebt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Èh pì tàng anoe trùh kan tajêh tablah, xam bàu tajêh tablah: drah wèq rađeh, apaq lèt, majah qmang aih ƀài yiniq aih ep trùh, mahaq kan atìq lùch qnhòq trùh. ");
INSERT INTO hrebt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nang noe kô yòng tablêq ka nang noe tau, diac kô tablêq ka diac tau, bàc nòe i kan pangot hrah xam taneh ralàng. ");
INSERT INTO hrebt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mahaq ƀòe yiniq aih bu qnang baxèm kan haƀo. ");
INSERT INTO hrebt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jò aih èh wì rùp tah pì ta kan nanxa hu jêh đac, rìm diac git ka pì ajang yiniq au. ");
INSERT INTO hrebt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jò aih èh i bàc ngai cađac manoh lùi rai blòq dabau rai git ka dabau. ");
INSERT INTO hrebt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bàc ƀòe mangai pajàu patìah plôh loh rai padô qnùt bàc ngai. ");
INSERT INTO hrebt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nah hòm taiq kan dù rai èh rai bàc dài manoh loq waq da bàc ngai majah hi loh ka rai èh rai hangeo. ");
INSERT INTO hrebt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mahaq mangai leq cajap manoh trùh lùch trùh gêh, aih èh ma jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bàu lem da diac Boc plình kô èh jah hnài jàp tnna crŏng taneh, đòeq panhìn ka rìm diac. Jò aih èh kan lùch hi trùh ");
INSERT INTO hrebt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jò pì hnoq kan amùa broq ka raliang nòe hadròeh, pajàu Đaniên khoe anoe trùh (cabô đŏc khòh hmàng), ");
INSERT INTO hrebt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","jò aih mangai leq oe gùng Jiuđê drah amot tŏc ta wang, ");
INSERT INTO hrebt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","cabô oe ta kùa po hnim, ùh dùh loh qnhon kùng hang ta hnim, ");
INSERT INTO hrebt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","mangai leq oe ta ruàng, apaq wìh hlài ta hnim hu yŏc eo. ");
INSERT INTO hrebt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jò aih, joq hamoq qnàng ka mangai gucadrì wê cliac xam mangai cadrì kon oe ùq! ");
INSERT INTO hrebt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Drah waiq khàn dôq pì ùh hìaq ep cadàu glàm jò ralìm, ùh hìaq glàm hì Sabat, ");
INSERT INTO hrebt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Majah qmang aih i kan nan no kàn, jaq enh jò baxèm i crŏng taneh trùh hloe manòeq qnhòq hmaq i qmang aih, yac ka atìq kô èh dua pi i qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tàng joq ƀài hì aih ùh qnhùa hlài qnah, ùh i moeq ngai leq oe rìh, mahaq taiq i pì ƀài mangai ma khoe jah ràih, ƀài hì aih ma khoe jah pot hlài qnah. ");
INSERT INTO hrebt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jò aih, tàng joq i cabô doe ka pì: Ngan! hacô raq Christ, tàng ùh meh doe: Hatau haq, apaq lùi ƀài aih. ");
INSERT INTO hrebt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Majah qmang aih bàc Christ patìah, pajàu patìah trùh, broq bàc kan halac, tàng majah wì aih trùh hu padô hloe pì aih mangai ma khoe jah ràih. ");
INSERT INTO hrebt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ngan oq, au khoe chônh doe ka pì adroe. ");
INSERT INTO hrebt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tàng i mangai leq doe ka pì: Hatau! Haq oe tanòe go hawit, pì apaq lam, tàng ùh meh wì doe: Hacô! haq oe trom hnem. ùh dùh lùi dèh. ");
INSERT INTO hrebt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Majah qmang aih tìah ka kan camlet cađah enh gùng mahì loh cadàu trùh apah mat mahì clìh, Kon mangai trùh hadai qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Taleq i hanang jam om cachìt, ƀài cliang apùq dabau ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kan nanxa ta hì aih bu khoe, mat ma hì tajòe qmòe loh ka clam, mat khê hadai pi qngah, ƀài halŏng taclìh enh plình, èh ƀài cleq clài ma oe ta plình hanoh dalàc. ");
INSERT INTO hrebt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jò aih èh ta trŏc i kan bahìan Kon Mangai loh, dìq ka mangai oe ta crŏng taneh crò hmoe, jò wì haq hnoq Kon Mangai hangui tayùc, yŏc dìq ka cwìang itai xam kan ranhòm kàn, đòeq loh ta qneq. ");
INSERT INTO hrebt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Haq thê deh ƀình plình yŏc bàu ken dêh đòeq hu tagop ƀài mangai haq ma khoe ràih loh enh pôn qngèa, enh caqnàm plình kô trùh caqnàm plình tau. ");
INSERT INTO hrebt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Manòeq, pì tamàng bàu alìah trùh long pŏc, jò hamenh nga bu plôh ramot, aih pì loq jò padrang khoe ten trùh. ");
INSERT INTO hrebt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hadai qmang aih diq, jò pì hnoq ƀài yiniq kô, pì loq Kon mangai trùh khoe haten. Haq qnang yòng ajang trong qmang. ");
INSERT INTO hrebt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Joq qnàng au doe ka pì: nang noe kô èh ùh lùch, jò ƀài yiniq tau qnhòq trùh. ");
INSERT INTO hrebt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Plình crŏng taneh kô èh hnhung, mahaq bàu au anoe ùh jò leq hnhung. ");
INSERT INTO hrebt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mahaq anoe trùh hì aih, jò aih, ùh i cabô loq, yac ka ƀình plình oe ta plình, yac ka Kon hanoh ùh qnì, toq cla Baq raq ma loq dèh. ");
INSERT INTO hrebt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Qnhòng Nôe nèh qmang leq, jò Kon mangai hi trùh hanoh qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Majah qmang aih adroe ka diac kàn, wì acaq, wì ôq, wì atŏc ŏng mai, trùh hì Nôe mùt taboang, ");
INSERT INTO hrebt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","wì haq ùh lòm qnì qmòe yiniq cleq hu lap trùh kô èh, trùh jò diac kàn trùh glua dìq dŏng, jò Kon mangai trùh hanoh qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hì aih, baiq ngai oe ta ruàng, moeq ngai jah dèch, moeq ngai đòeq hlài; ");
INSERT INTO hrebt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","baiq ngai gucadrì, qnang pêh qmau, moeq ngai jah dèch, moeq ngai đòeq hlài. ");
INSERT INTO hrebt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Qmang aih, pì ep hamang oq. ");
INSERT INTO hrebt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Thê pì loq qmang kô, tàng joq cla wì craq ta hnem khoe loq jò leq i mangai atùng trùh, aih ajoq haq hamang đòeq dôq mangai atùng ùh jah mùt dèh ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pì hadai ep hamang đòeq qmang aih diq, majah qmang aih Kon mangai trùh wop jò pì ùh ngèh ka haq trùh. ");
INSERT INTO hrebt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mangai hapŏng leq ma ùh ta blòq manoh rai khun rabiaq, wì craq ma khoe dèch haq broq mangai wèq hapŏng qnoeq, đòeq hu am ka wì aih dahwèq acaq troq jò. ");
INSERT INTO hrebt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Xôq ramot am ka haq aih, jò cla wì craq trùh hnoq haq broq qmang aih! ");
INSERT INTO hrebt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Joq qnàng au doe ka pì, haq aih èh wì craq dèch haq broq mangai wèq dìq dŏng kùng hang ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mahaq, tàng mangai hapŏng qmèq, haq hèm dèh ta cliac: Jò leq wì craq men trùh, ");
INSERT INTO hrebt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aih èh haq hi jêh ƀài mangai hadai abroq moeq qmang ti haq, rai acaq ôq, taqmùt ti ƀài mangai bù ka alac. ");
INSERT INTO hrebt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cla wì craq haq trùh troq hì haq ma ùh ùac, wop jò haq ùh hèm. ");
INSERT INTO hrebt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Cla wì craq jêh haq aih dahit dahoch rai alùh đòeq haq oe moeq qmang ti ƀài mangai patìah toq enh gùng, tanòe aih i toq kan crò hmoe rai cadrit hanenh.” ");
INSERT INTO hrebt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jò aih èh diac plình tìah ka moeq jàt ngai adrùh sriu, wê đen lam đìh cla kon ŏng. ");
INSERT INTO hrebt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ta aih i padam ngai blùng, padam ngai rabiaq. ");
INSERT INTO hrebt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Da ƀài mangai blùng wê toq đen mahaq ùh waq wê dàu. ");
INSERT INTO hrebt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Da ƀài mangai rabiaq, wê đen rai wê dàu ta cabi. ");
INSERT INTO hrebt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yàng kon ŏng xòe trùh, wì haq loh dŏng ka gù kùi pi hmàng. ");
INSERT INTO hrebt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Trùh qne mang i bàu creo: Kô cla kon ŏng! Loh đìh haq beq. ");
INSERT INTO hrebt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Khoe aih dìq dŏng ƀài guadrùh cadrat enh kùi rai palauq dèh đen. ");
INSERT INTO hrebt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ƀài mangai blùng doe ka mangai rabiaq: lah ka nhèn dàu pì daq toq biaq diq, đen nhèn khoe ten pat. ");
INSERT INTO hrebt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ùh! wì aih padreo bàu, aih èh ma oe tàu ka nhèn xam ka pì. Xan pì cadàu lam tanòe wì ma atech, hu rot ònh dàu ka cla pì, ma aih ùh hnau hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mahaq jò wì haq qnang lam rot dàu, cla kon ŏng khoe trùh. Ƀài mangai guadrùh ma khoe gòm qmòe jang aih, jah mùt ti haq tanòe acaq yiniang, èh wì hi clenh qmang. ");
INSERT INTO hrebt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Khoe ka aih dùnh wì tau hi trùh diq, wì haq creo: Wì craq, wì craq, pèh ka nhèn qmang diq. ");
INSERT INTO hrebt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mahaq haq padreo bàu: “Au doe jang ka pì, au ùh qnì ka pì.” ");
INSERT INTO hrebt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aih èh pì ep hamang đòeq, majah qmang aih pì ùh loq ka hì, hadai ùh qnì ka jò. ");
INSERT INTO hrebt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Qmang kô hòm, diac plình tìah ka mangai padon lam hangai, haq creo dèh ƀài hapŏng trùh hu jao dèh kùng hang ka wì aih. ");
INSERT INTO hrebt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mangai kô haq am padam talàng, mangai tau haq am baiq talàng, mangai qnoeq hòm haq am moeq talàng, tiaq cabô leq hlàt dèh pang leq. Khoe aih haq hi lam. ");
INSERT INTO hrebt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mangai ma khoe jah padam talàng, drah lam abroq jah tam padam talàng. ");
INSERT INTO hrebt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hadai qmang aih, mangai ma jah baiq talàng abroq jah tam baiq talàng hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mahaq da mangai ma jah moeq talàng aih loh lam, chìa moeq toq trom jrùq ta taneh hu catùh đòeq hang wì craq. ");
INSERT INTO hrebt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Atìq ka aih joq dùnh cla craq wì aih wìh hlài creo ka wì haq trùh đòeq hangui hatình trong bac jènh. ");
INSERT INTO hrebt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mangai ma khoe jah padam talàng hi trùh, haq wê tam padam talàng qnoeq hòm rai doe: Wì craq, ìh khoe am ka au padam talàng, hacô au khoe broq jah tam padam talàng qnoeq hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Cla wì craq doe ka haq: Wìa! Mangai hapŏng jang lem dìq ka manoh, ìh khoe ùh tablòq manoh ka au enh trong qyoh, au dèch ìh broq mangai wèq yeo bàc hòm. Trùh ta kô đòeq beq jah lem bùi ti cla craq ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mangai ma khoe jah baiq talàng hanoh trùh. Haq doe: Wì craq ìh khoe am ka au baiq talàng, ngan kô au khoe jah tam baiq talàng hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Cla wì craq padreo bàu ka haq: Wìa! mangai hapŏng jang lem ùh talòq manoh, ìh khoe dìq manoh ka au enh trong qyoh, au dèch ìh broq mangai wèq yeo bàc hòm. Trùh ta kô đòeq jah lem bùi ti cla craq ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Khoe aih mangai ma khoe jah moeq talàng trùh diq, haq doe: Wì craq, au loq ìh kô mangai ùh jah blià, gat tanòe ìh ùh rai, tagop toch nòe ìh ùh caqnìh; ");
INSERT INTO hrebt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","aih ìq dài au yùq crè majah lam cadŏc ka hlèp talàng ìh ta taneh. Ngan hacô hang ìh oe raq da ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Cla craq haq padreo bàu “Ìh qmat, mangai hapŏng ùh wìa waq rai aroh! Ìh khoe loq au gat tanòe au ùh rai, tagop toch tanòe au ùh i caqnìh? ");
INSERT INTO hrebt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","loq qmang aih, xài ìh yŏc hang qmat aràng tanòe wì padro bac, qmang aih jò au wìh hlài xài au jah yŏc hlài xam xèm xam goe haq. ");
INSERT INTO hrebt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hêq, yŏc hlài talàng enh haq qmat am ka mangai ma khoe jah moeq jàt talàng tau. ");
INSERT INTO hrebt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Majah qmang aih, am tam ka mangai leq ma khoe i, dôq haq jah bình bauq tàu tìa hloe. Mangai ma ùh i, qnhac ka haq i toq xit cleq dua doeh yŏc hlài yiniq haq ma khoe jah. ");
INSERT INTO hrebt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Khoe aih mangai hapŏng ma ùh wìa waq aih khwênh qnìh đac hloe tanòe clam cluiq, nòe i toq kan crò hmoe rai cadrit hanenh.” Bubi wa trìu ");
INSERT INTO hrebt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jò Kon Mangai ma hi trùh enh plình, taqne kan ranhòm cla haq xam dìq ka ƀài ƀình plình lam tiaq haq, jò aih haq hangui dèh tagèq ranhòm cla. ");
INSERT INTO hrebt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dìq dŏng ka mangai tagop dìq enh ngèa ka haq, èh haq hi lah mangai kô loh khoe ka mangai tau tìah ka mangai ban trìu lah trìu loh khoe ka bubi. ");
INSERT INTO hrebt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Haq đòeq trìu oe pah qma, èh bubi haq đòeq pah qngeo rađeh. ");
INSERT INTO hrebt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Khoe ka aih Bùa hi doe ka mangai oe enh pah qma haq: “Trùh tacô, pì mangai ma khoe jah Baq au am xôq ramot, đòeq hu yŏc diac plình khoe padon đòeq ka pì enh jò baxèm broq plình crŏng taneh. ");
INSERT INTO hrebt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Majah qmang aih, jò au pangot pì khoe am ka au acaq, au croh ranŏng, pì khoe am ka au ôq, Au mangai tamoe ùh canau, pì khoe đìh au mùt dìh ta hnem. ");
INSERT INTO hrebt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Au chac dech, pì khoe taqmàn au, au ùh hrŏc yinìq, pì wèq au, wì clêh au pì trùh hmàih ka au. ");
INSERT INTO hrebt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jò aih ƀài mangai taq atoq hi padreo bàu ka haq: Chuaq nhèn, nhèn lah hnoq ìh pangot jò leq ma am ìh acaq? Nhèn lah hnoq ìh croh ranŏng jò leq ma i am ìh ôq diac? ");
INSERT INTO hrebt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nhèn lah hnoq ìh broq tamoe jò leq ma hu đìh, ùh meh oe chac dech jò leq ma hu taqmàn. ");
INSERT INTO hrebt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nhèn lah hnoq ìh ùh hrŏc jò leq, lah hnoq wì clêh ìh jò leq ma i lam hmàih ka ìh? ");
INSERT INTO hrebt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Bùa hi padreo bàu: “Joq qnàng, Au doe ka pì, yiniq cleq pì khoe broq am ka mangai leq ma yi hamoq dŏng oe taqne wì oh daq au, aih pì khoe broq ka au.” ");
INSERT INTO hrebt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Khoe aih, haq doe ka wì ma oe enh pah qngeo haq: “Wia ma khoe ka au, pì qmat ƀài mangai jìang ka ramòt, lam mùt tanòe ùnh ùh pat khoe palauq đòeq ka kiac dù xam bua da haq. ");
INSERT INTO hrebt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Majah qmang aih au pangot, pì ùh dùh ka am au acaq qmòe cleq, au croh ranŏng pì ùh dùh am qmòe ka au cleq hu ôq, ");
INSERT INTO hrebt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Au tamoe hangai, pì ùh đìh au mùt ta hnim pì, Au chac dech, pì ùh taqmàn au cleq, au rai ùh hrŏc rai oe ta hnim tù, pì ùh wiang wèq au.” ");
INSERT INTO hrebt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dìq ka wì wiang padreo bàu: Chuaq nhèn, nhèn lah hnoq ìh pangot, croh ranŏng, ìh tamoe jò leq, ìh chac dech jò leq, yac ka ìh oe ta hnim tù jò leq ma ùh patìh ka ìh? ");
INSERT INTO hrebt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Bùa padreo bàu: “Joq qnàng au doe ka pì, yiniq cleq pì ma ùh broq am ka mòeq mangai ma yi hamoq dŏng oe taqne wì kô, aih pì ùh broq ka au.” ");
INSERT INTO hrebt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Khoe èh, wì aih mùt tanòe baxa mòeq đòe, mahaq ƀài mangai taq atoq mùt tanòe kan rìh halình mòeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jò Chuaq Jesus khoe hêq ka hnài trong kô, haq doe dèh ka ƀài mangai tiaq hŏc: ");
INSERT INTO hrebt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Pì loq oe baiq hì hòm hi trùh ramènh Pan cwa, Kon Mangai kô èh wì rùp, wì tiang đình haq talong pagat.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jò aih ƀài pajàu xam ƀài gucraq mangai Juđa, tagop dabau oe ta hnim pajàu kàn, yiniq haq Caiphe, ");
INSERT INTO hrebt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","wì aih hatình ka dabau rùp Chuaq Jesus qmang leq ma hlèp đòeq jêh đac. ");
INSERT INTO hrebt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mahaq jò ramènh aih ùh dùh yùq ka phù cròng loq tagruàng tagràt. ");
INSERT INTO hrebt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jò Chuaq Jesus oe ta Bêthani, ta hnim Simôn mangai bacùn, ");
INSERT INTO hrebt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","I mòeq ngai gucadrì wê mòeq toq abôq ngŏc, enh dalam tah bình dàu xua thùm canaq bac, haq thia haten yŏc dàu aih pùc ta gàu Chuaq Jesus jò haq qnang haqngui acaq. ");
INSERT INTO hrebt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ƀài mangai tiaq hŏc hnoq qmang aih, wì nòeh haraya, wì doe: Hagleq ma loq racaih hrìn? ");
INSERT INTO hrebt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Dàu kô tech xài jah bàc bac, yŏc bac aih ajoq jah am ka mangai pa. ");
INSERT INTO hrebt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Chuaq Jeus loq qmang aih, haq doe ka wì: “Hagleq pì ma tapoch ka mangai gucadrì kô? Haq khoe broq mòeq yiniq dìq jaq lem ka au. ");
INSERT INTO hrebt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jò leq ma ùh i ka manga pa oe ti pì, mahaq ma xài jò leq pì xôq i au oe ti pì. ");
INSERT INTO hrebt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jò haq pùc dàu kô ta chac au, aih haq khoe padon hu lòm chac au. ");
INSERT INTO hrebt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Joq qnàng au doe ka pì, Bàu lem kô jah anoe trùh pang leq ta crŏng taneh kô, yiniq haq ma khoe broq ka au hì kô hadai jah anoe trùh đòeq hu hmàng trùh haq.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Taqne moeq jàt baiq ngai tiaq hŏc, i mòeq ngai yiniq haq Juđa Icariôt, lam tanòe ƀài pajàu kàn ");
INSERT INTO hrebt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Haq bòch wì: Pì am ka au toq leq, tàng joq au rùp haq am ka pì? Aih wì hi am ka haq pi jàt catah bac. ");
INSERT INTO hrebt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pang aih, Juda toq rap chaq jò hu rùp Chuaq Jesus am ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hì baxèm ramènh acaq ƀênh ùh tah blo, ƀì mangai tiaq hŏc thia haten ka Chuaq Jesus, wì bòch: Ìh enh nhèn padon ka ìh acaq ramènh Pancwa taleq? ");
INSERT INTO hrebt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Haq padreo bàu: “Pì mùt ta plài, glàm mòeq ngai, pì doe ka haq, Mangai hnài nhèn doe: Jò da au khoe ten trùh, au xam ƀài mangai tiaq hŏc au acaq ramènh Pancwa ta hnim ìh.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mangai tiaq hŏc broq qmang ka bàu Chuaq ma khoe thê, aih wì haq hi padon ramènh Pancwa. ");
INSERT INTO hrebt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jò trŏc khoe clam, Chuaq Jesus angèn nòe caƀŏng ti wì Moeq jàt baiq ngai. ");
INSERT INTO hrebt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jò wì qnang acaq, haq doe: “Joq qnàng! Au doe ka pì, i moeq ngai taqne pì kô èh blòq au.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dìq dŏng wì ta aih loh ka mangò, khoe ka maleq trùh maleq bòch haq: Chuaq au! ùh xài ìh doe au, ajoq? ");
INSERT INTO hrebt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Chuaq Jesus padreo bàu: “Mangai ma poh tì ta chrŏng kô ti au, aih raq mangai ma hu blòq au.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kon Mangai loh lam tìah ka bàu ma khoe achìh đòeq ka haq. Mahaq haƀo ka dađeh mangai ma blòq haq! Apaq hauang loh haq aih xan ka ùh hnau hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Juđa mangai ma blòq Chuaq Jesus hadai bòch: Rabi! Joq qnàng ùh xài doe au ajoq èh? Chuaq Jesus padreo bàu: “Joq qmang ka bàu ìh khoe anoe.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jò qnang acaq, Chuaq Jesus yŏc ƀênh, manè apôi, khoe aih goh ƀênh hnhu ka mangai tiaq hŏc rai doe: “Yŏc acaq beq, kô chac au!” ");
INSERT INTO hrebt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Haq yŏc chrŏng, manè apôi, khoe aih qnèp ka mangai tiaq hŏc rai doe: “Dìq ka pì ôq beq! ");
INSERT INTO hrebt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kô mahim au, mahim da kan tajao khoe dahrôq qnoh dôq bàc ngai jah claih enh yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Au doe ka pì, pang kô ta èh, au pi ôq diac plì nho kô hòm, trùh hì au ma hi ôq diac plì nho neo ti pì oe ta diac Baq au. ");
INSERT INTO hrebt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Khoe ka wì calêu bàu hset hadròeh, Chuaq Jesus xam mangai tiaq hŏc tŏc ta wang Ôliu. ");
INSERT INTO hrebt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Haq doe ka wì: “Mang kô dìq ka pì catoeh dŏng ka au! majah qmang aih khoe i bàu achìh: Au jêh mangai ban, Aih èh ƀài trìu haq hi prah hapriang dŏng. ");
INSERT INTO hrebt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mahaq atìq ka au khoe rìh hlài, au lam mùt ta gùng Galili adroe ka pì.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mahaq Phiero doe: Yac ka rìm ngai tacro cađac dŏng ìh, au dua ùh jò leq cro. ");
INSERT INTO hrebt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Chuaq Jesus padreo bàu doe: “Joq qnàng au doe ka ìh, mang kô raq adroe ka ia rŏng, piq yàng ìh hangah đeh ùh qnì ka au”. ");
INSERT INTO hrebt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dua Phiero doe: Yac ka au ep cachìt ti ìh, dua au ùh hangah rađeh ùh qnì ka ìh. Ƀài mangai tiaq hŏc dìq capoch moeq bàu qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Khoe aih Chuaq Jesus xam mangai tiaq hŏc lam trùh moeq nòe, jang aih wì creo yiniq haq Getsêmanê, haq doe ka wì: “Pì hangui a kô, gòm au lam waiq khàn ajang tau.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Haq qnung Phiero xam baiq ngai kon calô Sêbêđê tiaq haq, khoe aih haq loh ka mangò, ùh catèm ta manoh. ");
INSERT INTO hrebt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Haq doe ka wì: “Ta mahua yiang au bình kan mangò trùh cachìt. Pì oe ajang kô hu wiang rìu ti au.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Lam tam yi hangai ka aih toq biaq, haq bla-op hadrò ta taneh, rai waiq khàn: “Baq au, tàng loq jah, Ìh dèch chrŏng kô ma khoe ka au, hnoq anoe aih paq tiaq manoh au, mahaq tiaq manoh Ìh.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Khoe aih haq wìh hlài nòe ƀài mangai tiaq hŏc hnoq wì aih khoe hliac dŏng. Haq bòch Phiero: “Pì rìu ti au moeq jò dua ùh nui qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rìu rai waiq khàn dôq pì ùh hìaq clìh ta kan padô qnùt. Mahua yiang aih enh haraya, mahaq chac aih ùh hlàt.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Haq lam tam yàng baiq hòm rai waiq khàn: “Baq au, tàng joq chrŏng kô ùh jah lah khoe ka au, dua au ep ôq, waiq manoh Baq ma enh jah gêh.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jò haq wìh hlài, haq hnoq wì kùi pi hmàng, majah qmang aih mat wì haq khoe tajìp đeh. ");
INSERT INTO hrebt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Haq cađac wì oe ta aih, lam tam mòeq yàng hòm đòeq hu waiq khàn yàng piq, yàng kô dua moeq bàu tìah baiq yàng adroe. ");
INSERT INTO hrebt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Khoe aih haq wìh hlài nòe ƀài mangai tiaq hŏc, haq doe ka wì: “Pì oe raq kùi oe raq padài qmòh? Kô! khoe trùh jò, Kon Mangai kô èh wì rùp haq am ka ƀài mangai yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yòng! beq bèn lam, hatau mangai blòq au khoe trùh. ");
INSERT INTO hrebt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jò haq oe raq capoch, cadoe Juđa aih mangai hadai oe ta moeq jàt baiq ngai tiaq hŏc, khoe trùh, pi cajaq ƀài mangai wê ranac, wê chang lam ti haq, aih la ƀài mangai enh hnim pajàu kàn xam ƀài gucraq Juđa thê lam. ");
INSERT INTO hrebt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mangai blòq Chuaq Jesus khoe tanap ka wì, haq doe: Au hìp cabô, pì rùp mangai aih raq. ");
INSERT INTO hrebt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Lam haten ka Chuaq Jeus, Juđa doe: Joq manè apôi qnàng, Rabi, khoe aih haq hi hìp Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Chuaq Jesus doe: “Ìh lam tacô hu broq cleq, drah broq beq” wì aih hi thia ka haten, rùp Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","I moeq ngai oe mòeq qmang ti Chuaq Jeus hroe qnoh chang, jêh mangai hapŏng ƀài pajàu, pot clìh moeq apah don haq aih. ");
INSERT INTO hrebt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chuaq Jeus doe ka haq: “Qmùt hlài chang qmat ta caqnop, majah qmang aih mangai leq wê chang haq aih èh cachìt dèh ka chang. ");
INSERT INTO hrebt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ìh ma xoh au ùh jah creo dèh ka Baq drah qnoh ka au loe moeq jàt baiq calùh ƀình plình qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Qmang aih, broq qmang leq ma xìt tiaq bàu Hset hadròeh ma khoe achìh, yiniq kô ep loh qmang kô raq.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jò aih Chuaq Jesus doe ka wì: “Pì wê chang jaoq, long dùi lam rùp au tìah ka lam rùp mangai atùng. Rìm hì au haqngui hnài ta hnem kùh waiq gleq pì ùh rùp au? ");
INSERT INTO hrebt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mahaq dìq ka yiniq kô loh qmang kô đoèq hu pagêh ka hset hadròeh ƀòe pajàu ma khoe achìh.” Jò aih ƀòe mangai tiaq hŏc ma hi cadàu qnìc ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ƀài mangai rùp Chuaq Jesus qnung haq trùh hnim Caiphe, aih mangai pajàu kàn, ƀài mangai hnài ranenh xam ƀài gucraq khoe oe qmòe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Phiero tiaq tayoe enh hangai trùh ta hamlang hnim mangai pajàu kàn, haq thia hangui pajùm ti ƀài mangai wèq qmang mùt loh, đòeq gòm ngan qmang leq ka dèh. ");
INSERT INTO hrebt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jò aih ƀài pajàu xam dìq dŏng ka wì oe ta hnim hadarh chaq trong tapoch patìah waq ka i nen jêh đac Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yac ka i bàc ngai tapoch qmùt oe ta aih, mahaq dua wì chaq ùh lòh qmòe moeq yiniq cleq đòeq broq nen, pulùch i baiq ngai trùh, ");
INSERT INTO hrebt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","doe rameh: Mangai kô i doe: Au raliang đac hnim kùh waiq Boc Plình khoe ka aih piq hì au hi paqnàng hlài. ");
INSERT INTO hrebt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mangai pajàu kàn padinh yòng bòch Chuaq Jesus: Ƀài wì qmat tapoch ka ìh qmang aih, ìh ùh tapoch hlài qmoeq nà bàu cleq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mahaq dua Chuaq Jesus hatinh. Mangai pajàu kàn doe hòm ka haq: Au thê ìh patô Boc Plình rìh halình mòeq đòe đòeq hu hapah, anoe ka nhèn loq, ìh ajoq Christ kon BocPlình? ");
INSERT INTO hrebt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chuaq Jesus tèu bàu: “Wop qmang ka bàu aih, qnah hòm, au doe ka pì: atìq kô èh pì hi hnoq Kon Mangai hangui enh pah qma cwìang itai Boc Plình, haqngui ta yùc haq loh taqneq.” ");
INSERT INTO hrebt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mangai pajàu kàn hit dèh eo rai doe: Haq khoe tapoch bàu pi hòq qmang aih, bèn oe ep gòm tam cabô lam panhìn hòm? Pì khoe tàng bàu pi hòq aih, pì hèm qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dìq ka wì wiang tèu bàu doe: Haq qmat troq ka cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wì cachôh ta hadrò haq, ramap haq, i qnah ngai tep haq. ");
INSERT INTO hrebt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Rai doe: Aleq Christ, tapoch pajàu beq, doe ka nhèn loq cabô jêh ìh? ");
INSERT INTO hrebt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jò Phiero oe raq hangui ta hamlang, i moeq ngai hapŏng cadrì thia haten, doe ka haq: Ìh kô hanoh oe ti Jesus, mangai Galili. ");
INSERT INTO hrebt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mahaq enh ngèa wì aih, Phiero hangah rađeh: Au ùh qnì tàng qmòe ìh capoch cleq? ");
INSERT INTO hrebt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jò loh atrong qmang, i mangai hapŏng cadrì qnoeq hòm hnoq haq, hi doe ka wì ta aih: Mangai kô hanoh oe ti Jesus mangai Naxaret. ");
INSERT INTO hrebt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mahaq Phiero rai hangah rai hapah: Au joq ùh qnì qmòe ka mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mòeq ahyàc hòm, ƀài wì oe ta aih doe: Joq qnàng ìh hadai qmoeq bua ti wì aih, bàu tapoch ìh khoe patô qnoh ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Phiero tapoch brùaq rai hapah cadêh: Au ma i loq ka haq aih. Draq drình hloe jò aih raq, ia hi rŏng. ");
INSERT INTO hrebt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Phiero hmàng hlài ka bàu Chuaq Jesus ma khoe doe: Adroe ka ia rŏng, piq yàng ìh hangah đeh ùh qnì ka au. Khoe aih haq hi loh enh gùng rai lam rai hmoe ra-ua. ");
INSERT INTO hrebt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Trùh sroq èh, ƀài pajàu xam ƀài gucraq Juđa, hatình ka dabau chaq trong tablêq ka Chuaq Jesus hu jêh đac haq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wì kàt aràng haq ka Philat mangai cla craq wèq dìq gùng aih. ");
INSERT INTO hrebt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jò aih, Juđa mangai ma blòq Chuaq Jesus, hnoq wì khoe taqmòq yiniq lui ka Chuaq Jesus, rawòe ka rađeh khoe broq qmang aih, haq wê piq jàt cachêh bac aràng padreo hlài da ƀài pajàu xam ƀài gucraq, ");
INSERT INTO hrebt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","haq doe: au kô khoe broq yiniq, majah qmang aih au khoe blòq cađac mahim ùh i đeh qmoè ka yiniq lui cleq! Mahaq wì aih doe: Aih ìq ep cleq ka nhèn? Lènh ka da ìh. ");
INSERT INTO hrebt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Juđa yŏc bac aih khwênh qmùt ta hnim kùh waiq, khoe aih loh enh gùng, lam hanŏc rađeh. ");
INSERT INTO hrebt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ƀài mangai pajàu toch bac aih, wì haq doe: Bac kô ùh khòh tah tanòe bac hadròeh, majah qmang aih bac kô khoe padrinh. ");
INSERT INTO hrebt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Khoe aih wì hatuàng ka dabau yŏc bac aih rot ruàng mangai thòq broq padrì abôq đòeq broq nòe catùh hanang mangai cachìt lìq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aih ìq, trùh manòeq ruàng aih wì oe raq creo ruàng mahim. ");
INSERT INTO hrebt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Qmang aih ma khoe xìt tiaq bàu pajàu Jêrêmi ma khoe anoe: “Wì yŏc piq jàt cachêh bac, aih bac caxènh mangai Israli qnoh ka Mangai wì haq ma tah hadrah, ");
INSERT INTO hrebt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","wì yŏc bac aih rot ruàng mangai thòq broq abôq padrì, wop qmang ka bàu Chuaq doe ka au.” ");
INSERT INTO hrebt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jò Chuaq Jesus yòng enh ngèa ka cwan Philat, cwan aih bòch Chuaq Jesus: Ìh ajoq bùa mangai Juđa? Chuaq Jesus padreo bàu: “Joq qmang aih.” ");
INSERT INTO hrebt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jò dìq dŏng ka ƀài pajàu kàn xam ƀài gucraq wiang tah hadrah ka haq, haq ùh tèu moeq nà bàu. ");
INSERT INTO hrebt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Philat bòch haq: wì i bàc trong tah hadrah ka ìh, ìh ma ùh tàng? ");
INSERT INTO hrebt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mahaq Chuaq Jesus ùh tèu moeq nà bàu, Philat loh ka dì qjaq hamàih. ");
INSERT INTO hrebt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Rìm hanam trùh hì ramènh Pancwa, cwan loq canaih moeq ngai wì ma rùp clêh ta hnim cadrong, tiaq manoh mangai Juđa ma enh. ");
INSERT INTO hrebt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jò aih i mòeq ngai xòc i qmoè tìang wì clêh ta hnim cadrong, yiniq haq Baraba. ");
INSERT INTO hrebt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jò wì tagop dabau khoe bàc, Philat bòch wì haq: Pì enh au caqnaih ka pì cabô? Baraba loq caqnaih Jesus, mangai ma creo Christ aih? ");
INSERT INTO hrebt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Majah qmang aih cwan aih haq loq jao manoh wì tarènh dài wì majah rùp aràng Jesus ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jò Philat qnang hangui ta gèq hadrah, cadrì haq thê wì lam anoe ka haq bàu kô: Ùh dùh troq dèh ka mangai taq atoq qmat, majah qmang aih hì kô jao haq qmat raq dài au ma khoe ep xalep ta kan apô. ");
INSERT INTO hrebt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mahaq ƀài mangai pajàu kàn xam ƀài wì gucraq dua àu padô bàc ngai oe ta aih, dôq wì aih bòch cwan caqnaih Baraba ka wì haq, èh jêh đac hloe Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Philat bòch wì haq: Wa baiq ngai kô, pì enh au caqnaih ka pì mangai leq? Wì tèu bàu: Baraba, ");
INSERT INTO hrebt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Philat doe: Tàng qmang aih ha Jesus, mangai ma creo Christ kô au broq qmang leq? Dìq dŏng ka wì aih tèu: Tiang đình haq qmat talong pagat! ");
INSERT INTO hrebt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Philat bòch: Hagleq? haq kô khoe broq cleq ma dù? Mahaq wì aih cachech yeo dêh hòm: Tiang đình haq qmat talong pagat! ");
INSERT INTO hrebt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jò Philat hnoq bàu rađeh khoe pi ƀlêq wì aih, mahaq kan tagruàng èh rai dêh, haq yŏc diac qnheo dèh tì enh ngèa ƀài aih, haq doe: Au ùh pòq mahim mangai kô, cla pì pòq dèh! ");
INSERT INTO hrebt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dìq ka wì wiang doe: Mahim haq mat dahrôq tagàu nhèn xam kon nhèn! ");
INSERT INTO hrebt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Khoe aih haq caqnaih Baraba ka wì, èh haq thê blai Jesus, khoe aih am ka wì lam tiang đình talong pagat. ");
INSERT INTO hrebt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Lình cwan aih qmùt Jesus ta hnim kàn, tagop dabau oe dudan ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wì lêh đac eo haq, caxùnh ònh ka haq eo yôh gòh. ");
INSERT INTO hrebt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Khoe aih, wì tênh moeq toq cadoh yila, pacui tagàu haq. Wì tah moeq catoch cadia ta tì pah qma haq, wì hacùn cràng enh ngèa haq rai halê haq, wì doe: Waiq bùa mangai Juđa. ");
INSERT INTO hrebt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wì cachôh ta chac haq, yŏc cadia blai tagàu haq ");
INSERT INTO hrebt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Atìq ka wì halê haq, wì lêh đac eo yôh gòh enh chac haq, caxùnh hlài eo da cla haq, khoe hi qnung haq lam đòeq tiang đình haq talong pagat. ");
INSERT INTO hrebt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jò wì qnang lam ti trong, wì glàm moeq ngai oe ta Siren, yiniq haq Simôn, wì thê haq xùi long pagat. ");
INSERT INTO hrebt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wì lam trùh ajang nòe wì ma creo Gôgotha (aih la go cadôh gàu). ");
INSERT INTO hrebt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ta aih wì am Jesus ôq alac clai pajùm ka mat xang, mahaq jò Jesus liah ngan, haq ùh waq ôq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jò wì khoe tiang đình haq talong pagat, wì pàih panàih đòeq ta axong ka dabau eo yôh haq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Khoe aih wì hi hangui ta aih đòeq gòm ngan haq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Enh qnhèq ka gàu haq, wì đòeq moeq capiac long ban, wì achìh yiniq lui haq: KÔ RAQ JESUS, BÙA MANGAI JUĐA. ");
INSERT INTO hrebt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hanoh jò aih diq, wì tiang đình baiq ngai atùng ti haq, moeq ngai apah qma ka haq, moeq ngai apah qngeo ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ƀài mangai lam pagat trong aih hnoq haq, wì do halê rai ngu ngìu gàu, ");
INSERT INTO hrebt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","wì doe: Ìh mangai ma doe đeh raliang hnem kùh waiq, èh dìq piq hì raq hi broq hlài, doeh rađeh beq! Tàng joq ìh kon Boc Plình, loh enh long pagat beq! ");
INSERT INTO hrebt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ƀài pajàu kàn xam mangai hnài ranenh hloe xam ƀài gucraq hanoh lê haq: ");
INSERT INTO hrebt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Wì doe: Haq khoe dèch bàc ngai qnoeq mahaq doeh rađeh ùh jah. Tàng ìh joq bùa mangai Israli, manòeq loh enh qmat beq, aih nhèn men lùi. ");
INSERT INTO hrebt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Haq canòm ka Boc Plình, tàng joq Boc Plình loq waq ka haq, manòeq ajoq Boc Plình khe doeh haq, majah qmang aih haq khoe doe đeh kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wa mangai atùng wì ma khoe tiang đình talong pagat ti haq, hadai hnap ka haq qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pang jò qne hì, trùh piq jò xèq aih, dìq ka gùng aih trŏc loh ka clam cluiq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Qnah ta piq jò, Chuaq Jesus creo ka dêh: “Êli, Êli, lam-ma-sa-bat-ta-ni?” Bàu aih ìq rameh: Boc Plình au, Boc Plình au, Gleq Ìh majah cađac au? ");
INSERT INTO hrebt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wì yòng haten ka aih, tàng bàu haq, wì doe: Haq creo ka Êli. ");
INSERT INTO hrebt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tajòe qmòe i moeq ngai tùh yŏc moeq cato capaih, chùq ta diac jòq, srep agoe long cadia, dèch am ka Haq ôq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mahaq qnah ngai qnoeq doe: Dôq haq, ngan Êli i trùh dèch haq ùh? ");
INSERT INTO hrebt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus creo tam moeq nà bàu dêh, khoe aih qnèp dèch dèh mahua yiang ka Baq. Haq hi pat. ");
INSERT INTO hrebt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wop jò aih, bai prình haganh ta hnim kùh waiq dahit enh qnhèq trùh taqneq, loh baiq apah, taneh loh ka ralàng, hmo kàn padah, ");
INSERT INTO hrebt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ralùng hanang tapèch, bàc hanang mangai tiaq trong hadròeh cachìt rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Atìq ka Chuaq Jesus rìh hlài, ƀài wì aih loh enh ralùng hanang, mùt ta Plài hadròeh, mahno rađeh ka bàc ngai jah hnoq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Cla craq lình xam ƀài mangai oe ti haq đòeq wiang gòm hanang Chuaq Jesus, hnoq taneh ralàng, xam bàc yiniq qnoeq hòm, haq dìq jaq yùq crè, haq doe: Mangai kô, joq kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bàc ngai gucadrì yòng haqmiang đeh enh hangai, wì haq aih ƀài mangai ma tiaq Chuaq Jesus enh gùng Galili, tiaq đòeq patìh ka haq, hanoh oe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ta aih i Mari Mađolen, Mari miq Jaco xam Jôsep, xam miq baiq ngai kon Sêbêdê. ");
INSERT INTO hrebt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Trùh mahì khoe haqneq, i moeq ngai padrŏng trùh enh gùng Arimathê, yiniq haq Jôsep, haq aih hanoh mangai tiaq hŏc Chuaq Jesus, ");
INSERT INTO hrebt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","haq trùh ta Philat đòeq hu bòch ahlài hanang Chuaq Jesus. Philat hi am ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jôsep yŏc bai taboc lom hanang Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Lam đòeq ta ralùng haq ma neo thê wì pùng đòeq ka rađeh tanòe hmo kàn, khoe aih, wì cadro moeq toq hmo kàn padit ajang ngah ralùng, khoe aih èh hi bròc. ");
INSERT INTO hrebt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari Madolen, xam ƀài wì qnoeq hangui tangèa ka ralùng. ");
INSERT INTO hrebt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sroq èh rameh (aih hì atìq ka hì ma padon acaq ramènh), ƀài pajàu kànx am mangai Pharisi adràc dabau lam glàm Philat, ");
INSERT INTO hrebt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","wì haq doe: Wì craq! Nhèn hmàng mangai loq qnùt kô, jò haq oe rìh i doe rameh: Atìq ka piq hì, au hi rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Manòeq kô, Ìh am lình lam gòm ralùng hanang ma hagau haq, trùh piq hì, yùq ƀài mangai tiaq hŏc haq loq lam atùng hanang, khoe aih anoe ka phù cròng: Haq khoe rìh hlài enh kan cachìt. Kan qnùt yàng ma atìq kô yeo hamoq ka yàng adroe hòm. ");
INSERT INTO hrebt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Philat doe ka wì: Pì i dèh lình, lam broq tiaq dèh manoh pì ma enh beq. ");
INSERT INTO hrebt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Qmang aih, wì haq hi lam, nìm hadro ajang ngah ralùng, yŏc lình đòeq gòm, cla hnoq dèh hagau haraya. ");
INSERT INTO hrebt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Atìq ka hì Sabat, hì baxèm ta tuàng ramènh, jò bu badrèh qngah, i Mari Madolen xam Mari qnoeq hòm, lam ta ralùng hanang. ");
INSERT INTO hrebt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","I kan taneh ralàng dêh, majah qmang aih i mòeq ƀình plình Chuaq loh enh plình, trùh cadro hmo, èh haq hangui enh qnhèq ka hmo aih. ");
INSERT INTO hrebt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hadrò haq qngah tìah ka camlet, eo haq taboc tìah ka yiloc. ");
INSERT INTO hrebt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dài aih, ƀài lình gòm ralùng tarìt tariang, gang tìah ka mangai cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mahaq ƀình plình doe ka wì mangai gucadrì: Chôp paq yùq dèh, au loq chôp chaq Chuaq Jesus mangai wì ma tiang đình haq talong pagat. ");
INSERT INTO hrebt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Haq ùh oe tacô, haq khoe rìh hlài, tìah ka bàu haq khoe doe. Drah lam ngan nòe taqnguì haq beq, ");
INSERT INTO hrebt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","èh drah lam anoe ka bua Haq loq haq khoe rìh hlài. Hacô Haq lam adroe ka pì tŏc ta Galili, ta aih èh pi hi hnoq haq. Aih au khoe doe ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wa mangai cadrì aih drah loh enh ralùng, rai yùq crè rai manè, tùh cadàu lam anoe ka ƀài mangai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ùh xài! Chuaq Jesus loh glàm wa aih, haq doe: “Lem bùi am ka chôp!” Wa haq tùh haten ta haq, cwat jènh rai kùh waiq haq. ");
INSERT INTO hrebt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chuaq Jesus doe: “Apaq yùq cleq, drah lam anoe ka oh daq au tŏc ta Galili, ta aih èh wì jah hnoq au. ");
INSERT INTO hrebt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jò wa mangai gucadrì qnang lam roc trong, i qnah ngai lình gòm ralùng hanang mùt ta Jêrusalem taqmon hlài ka ƀài pajàu loq dìq dŏng rìm yiniq. ");
INSERT INTO hrebt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ƀài pajàu kàn tagop pajùm ka ƀài gucraq đòeq hu hatình ka dabau, jò khoe hatình, wì haq am ka ƀài mangai lình bàc ƀac, ");
INSERT INTO hrebt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wì haq tanap: Pì doe rameh oq: Damang, jò nhèn oe kùi, ƀài mangai tiaq hŏc haq atùng yŏc hanang aràng taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tàng bàu kô loq trùh don cwan kàn, i nhèn chaq trong hu anoe ka haq, dôq pì ùh hìaq ep yùq cleq. ");
INSERT INTO hrebt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ƀài lình yŏc ƀac, wì haq broq tiaq bàu tanap aih. Tagùng Juđa, bàu aih oe raq trùh manoèq. ");
INSERT INTO hrebt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Moeq jàt moeq ngai tiaq hŏc lam ta gùng Galili, wì haq tŏc ta wang Chuaq Jesus ma khoe thê. ");
INSERT INTO hrebt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jò wì hnoq haq, wì kùh waiq haq, mahaq i ƀiaq ngai, qnhòq dai lùi. ");
INSERT INTO hrebt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Chuaq Jesus lam ka haten ti ƀài mangai tiaq hŏc, haq doe ka wì qmang kô: “Dìq ka cwìang itai oe ta plình xam ta crŏng taneh khoe jao dŏng ka au. ");
INSERT INTO hrebt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Qmang aih, drah lam jàp crŏng taneh đòeq broq ka mangai oe rìm diac wìa dŏng mangai tiaq hŏc au, canòm ka hiniq Baq, hiniq Kon, hiniq Yiang Hadròeh đòeq broq ƀaptem ka wì, ");
INSERT INTO hrebt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","rai hnài wì wèq rìm trong au khoe hnài pì. Kô èh au oe hloe ti pì trùh hì atìq lùch. ");
INSERT INTO hrebt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Baxèm Bàu lem da Chuaq Jesus Christ, kon calô Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tìah ka khoe achìh tanòe hset pajàu Êsai rameh: Kô au thê dèh mangai wê bàu lam enh ngèa ka Ìh, Haq aih mangai đòeq hu palauq ka Ìh trong. ");
INSERT INTO hrebt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","I bàu creo tanòe hawit, Palauq đòeq trong ka Chuaq, Pajang trong lam ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon Ƀaptit khoe trùh tagùng hawit, hnài rai broq ka wì ramènh ƀaptem da kan raxach, dôq jah kan caqnaih yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dìq dŏng cròng diac Juđa xam mangai oe ta Jêrusalem trùh dìq ta haq. Anoe paqnoh dèh yiniq lui rai dôq haq broq ƀaptem ka wì ta diac Jodan. ");
INSERT INTO hrebt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon caxùnh eo broq enh xàc lŏcđa, kàt caqnam xam caxi akia, acaq toq ƀài lìp rai ôq diac xùt rôm wang. ");
INSERT INTO hrebt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Haq hnài rameh: Atìq ka au kô èh, I mòeq ngai i cwìang ùh hnau ka au, au ùh tajì ka jah broq đeh mangai kùp lêh caxi jep haq, ");
INSERT INTO hrebt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","au broq ƀaptem ka pì xam diac, mahaq Haq aih èh broq ƀaptem ka pì xam Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jò aih Chuaq Jesus trùh enh Naxaret gùng Galili, haq dôq Jon broq ƀaptem ka rađeh ta diac Jodan. ");
INSERT INTO hrebt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jò Jesus bu loh enh gùng ka diac, haq hnoq plình tapèh èh Yiang Hadròeh tìah ka trù, loh jràp ta haq. ");
INSERT INTO hrebt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Èh i bàu loh enh plình doe: “Kô Kon da Au loq waq dèh, haq lem manoh Au rìm trong.” ");
INSERT INTO hrebt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jò aih raq, Yiang Hadròeh qmùt haq tagùng hawit. ");
INSERT INTO hrebt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Èh haq oe tanòe hawit aih pôn jàt hì, dôq Satan padô rađeh. Haq oe pajùm mòeq qmang ti ƀài ngè rôm, khoe èh i ƀình plình trùh patìh ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Atìq ka wì rùp clêh Jon. Chuaq Jesus trùh ta Galili hnài Bàu lem da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Haq doe: “Khoe trùh jò! Diac Boc Plình trùh khoe haten, drah raxach rai lùi Bàu lem beq. Jesus creo ka mangai tiaq hŏc ma baxèm ");
INSERT INTO hrebt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jeus lam jènh ti haqmai diac raxìq Galili, haq hnoq Simôn xam oh haq, qnang tang hlàm ta hlŏng, majah qmang aih wa aih dìq mangai ranang ka. ");
INSERT INTO hrebt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","“Drah tiaq Au, dôq au hu thê chôp lam tang hlàm mangai.” ");
INSERT INTO hrebt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jò aih raq, wa cađac dŏng dèh hlàm lam hloe ti haq. ");
INSERT INTO hrebt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chuaq Jesus lam hi hangai ka aih toq biaq, haq hnoq Jaco kon Sêbêdê xam oh haq oe ta boang, qnang padon dèh hlàm. ");
INSERT INTO hrebt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ùh lòm trò, Haq creo ka wa aih, èh wa oh daq aih đòeq Sêbêđê baq wa haq, oe ta boang ti ƀài mangai broq acaq kùng, đòeq tiaq haq. ");
INSERT INTO hrebt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wì haq lam ta Cabênaum, trùh hì Sabat, Chuaq Jesus mùt tanòe hnim tagop qyoh, haq hnài wì. ");
INSERT INTO hrebt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dìq ka mangai oe ta aih hamàih ka bàu haq hnài, majah qmang aih bàu haq hnài wì tìah ka mangai i cwìang itai, ùh xài troeq da ƀài mangai hnài ranenh. ");
INSERT INTO hrebt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hanoh jò aih, tanòe him tagop qyoh i moeq ngai kiac pawè, ");
INSERT INTO hrebt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","haq creo: Jesus, mangai Naxaret, Ìh enh broq cleq ka nhèn, Ìh trùh hu palùng đac nhèn qmòh? Au loq Ìh qmat cabô: Ìh, Mangai hadròeh da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chuaq Jesus tapoch ka haq: “Oe ma hatinh haq! Drah loh khoe ka mangai kô!” ");
INSERT INTO hrebt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kiac jròng rapôh mangai aih, rai cachech cadêh èh hi loh hloe enh gùng ka mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mangai leq mangai meh hamàih đeh hra, wì bòch dabau: Cleq kô ìq wa, kô trong hnài maneo qmòh? Mangai kô joq i cwìang, trùh kiac jròng dua iu bàu haq thê! ");
INSERT INTO hrebt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yiniq haq wì ràu, maloq khoe jàp dudan gùng Galili. ");
INSERT INTO hrebt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ƀu loh enh nòe hnim tagop, Chuaq Jesus xam mangai tiaq hŏc lam ti Jaco xam Jon mùt ta hnim Simôn xam An rê. ");
INSERT INTO hrebt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Miq mai Simôn tacat qnang caqnùng ta juàng, wì drah anoe ka Chuaq Jeus loq. ");
INSERT INTO hrebt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chuaq Jesus lam trùh nòe haq kùi, carùp tì rai dèch haq yòng. Kan tacat hi hnhung, èh haq hi patìh ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Xèq aih, jò mahì khoe clìh, wì aràng ƀòe mangai ùh hrŏc xam ƀài mangai i kiac pawè trùh ka Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dìq dŏng ka mangai oe ta plài, tagop dabau yòng ajang qmang hnim, ");
INSERT INTO hrebt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chuaq Jesus broq bàc ngai brêh ka yinìq. Haq hadai drùh qnoh bàc kiac, mahaq Haq ùh lòh ƀài kiac doe cleq, majah qmang aih ƀài kiac aih loq ka haq. Jesus waiq khàn tanòe hawit ");
INSERT INTO hrebt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sroeh sroq, jò trŏc oe raq clam, Chuaq Jesus loh enh hnim lam tanòe hawit, haq waiq khàn ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simôn xam ƀài bua lam chaq haq, ");
INSERT INTO hrebt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jò hnoq Haq, wì doe: Rìm ngai qnang ti chaq ìh. ");
INSERT INTO hrebt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Chuaq Jesus padreo bàu: “Beq bèn lam taqnoeq, trùh roc plài haten ta kô, dôq au hu hnài ta aih. Jao aih ìq raq au majah khoe trùh.” ");
INSERT INTO hrebt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Haq lam jàp gùng Galili, hnài ta hnim tagop qyoh rai drùh qnoh kan kiac. ");
INSERT INTO hrebt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","I mòeq ngai bacùn trùh ti Haq, rai hacùn cràng rai waiq: Waiq Chuaq! Tàng joq ìh ma waq, ìh broq au brêh. ");
INSERT INTO hrebt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chuaq Jesus tamèt ta manoh, haq hnho tì bèq mangai bacùn aih, haq doe: “Au waq, brêh beq.” ");
INSERT INTO hrebt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tajòe qmòe, kan bacùn hnhung hloe haq aih hi jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chuaq Jesus thê haq aih loh enh gùng rai tanap: ");
INSERT INTO hrebt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ngan oq! Ùh jah anoe ka cabô loq. Mahaq ìh lam patô rađeh enh ngèa ka ƀài pajàu, ìh khoe jah brêh qmat, ìh dèch ramènh troeq bàu Môise thê đòeq anoe patô ka wì.” ");
INSERT INTO hrebt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yàng èh, loh enh gùng, haq bahìa yiniq kô, lam pang leq haq anoe pang aih, jaq Chuaq Jesus loh ka pi jah mùt ta plài ka lem, haq ep oe đeh enh gùng, oe tanòe hawit, èh wì phù cròng jàp jìa trùh ti haq. ");
INSERT INTO hrebt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ƀiaq hì atìq ka aih, jò Chuaq Jesus wìh hlài ta Cabênaum, wì ta aih tàng doe haq oe ta hnem. ");
INSERT INTO hrebt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wì tagop dabau ta aih bàc joq qnàng. Jaq ajang trong qmang dua ùh anòh oe. Haq hi hnài wì. ");
INSERT INTO hrebt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","I mangai trùh, aràng ka haq mòeq mangai pen, i pôn ngai wiang tòng. ");
INSERT INTO hrebt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mahaq mangai bàc hrìn wì haq ùh jah trùh ka haten ka Chuaq Jesus, wì haq hit kùa po hnim tajang ka nòe Chuaq Jesus hangui, jang nòe trom aih wì cadrai qnoh mangai pen. ");
INSERT INTO hrebt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jò Chuaq Jesus hnoq kan lùi wì aih, Haq doe ka mangai pen: “Kon ôi, dìq dŏng yiniq lui kon khoe jah caqnaih”. ");
INSERT INTO hrebt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mahaq i biaq ngai hnài ranenh hangui ta aih, wì haq hèm dèh ta manoh, ");
INSERT INTO hrebt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Hagleq mangai kô majah doe qmang aih? Haq jòq pi hòq qmòe ka Boc Plình! Enh gùng ka Boc Plình oe i cabô ma jah caqnaih yiniq lui? ");
INSERT INTO hrebt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ta jòe qmòe jò aih, Chuaq Jesus loq ka manoh wì aih hèm cleq, Haq doe ka wì: “Hagleq pì majah hèm qmang aih? ");
INSERT INTO hrebt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Manoèq kô doe ka mangai pen kô: Yiniq lui kon khoe jah caqnaih, tàng ùh meh doe: Yòng beq! Dèch da ìh dradrah qmat hlài beq! Baiq bàu aih ma leq ma yi hlàu ka anoe? ");
INSERT INTO hrebt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mahaq Au enh ka pì loq Kon mangai oe crŏng taneh kô i cwìang caqnaih yiniq lui”, khoe aih Chuaq Jesus doe ka mangai pen, ");
INSERT INTO hrebt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Au thê ìh yòng beq, xùi dradrah qmat hlài ta hnim”. ");
INSERT INTO hrebt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mangai pen padinh yòng, dèch dèh dradrah lam enh ngèa dìq dŏng ka wì. Dìq dŏng mangai leq mangai meh hamàih đeh hra, wì manè apôi Boc Plình rai doe: Bèn qnhòq hmaq hnoq kan halac qmang kô! ");
INSERT INTO hrebt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chuaq Jesus wìh hlài kênh haqmai diac raxìq hòm. Haraya mangai trùh ti haq, haq hi hnài wì. ");
INSERT INTO hrebt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jò Haq qnang lam ti trong, haq hnoq Lêwi, kon da Aphê qnang hangui ta hnim yŏc thèq. Chuaq Jesus doe ka haq: “Lam tiaq au.” Lêwi hi padinh yòng tiaq hloe haq. ");
INSERT INTO hrebt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jò Chuaq Jesus hangui acaq ta hnem Lêwi, i bàc ngai yŏc thèq xam ƀài mangai broq trong ùh lem hanoh hangui acaq moeq qmang ti Chuaq Jesus xam mangai tiaq hŏc haq. ");
INSERT INTO hrebt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jò mangai hnài ranenh aih ƀài mangai moeq bua ka mangai Pharisi hnoq Chuaq Jesus acaq ti ƀài mangai yŏc thèq xam ƀài mangai broq trong ùh lem, wì bòch ƀài mangai tiaq hŏc haq: Gleq Haq ma acaq pajùm ti ƀài mangai yŏc thèq xam ƀài mangai i yiniq lui? ");
INSERT INTO hrebt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tàng bàu aih, Chuaq Jesus hi doe ka wì: “Mangai tadêh ùh nhet cleq ka mangai broq jreo, mahaq mangai ùh hrŏc ma nhet đeh, au trùh ùh xài đòeq creo ka mangai taq atoq mahaq đòeq creo ka mangai i yiniq lui”. ");
INSERT INTO hrebt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jò aih, mangai tiaq hŏc da Jon xam mangai ma tiaq hŏc da mangai Pharisi dìq apàm ka acaq. I mangai trùh bòch Chuaq Jesus: Hagleq mangai tiaq hŏc da Jon xam mangai ma tiaq hŏc da mangai Pharisi dìq apàm ka acaq, mangai tiaq hŏc da ìh ma ùh apàm? ");
INSERT INTO hrebt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chuaq Jesus doe: “Jò acaq yineang, ƀài bua cla Kon ŏng ma wìa ka apàm ka acaq jò cla kon ŏng oe raq ti wì? ");
INSERT INTO hrebt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mahaq, trùh jò wì ma hi qnung cađac Haq, hì aih èh wì ma hi apàm ka acaq. ");
INSERT INTO hrebt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ùh i mangai leq yŏc ahyah neo clep qmùt ta blah eo dùnh, broq qmang aih, calep neo dùng hyah ka eo dùnh, teo hyah aih rai hamoq ùh hnau ka adroe hòm. ");
INSERT INTO hrebt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hanoh ùh i mangai leq yŏc alac neo ùc qmùt ta abôq akia dùnh, broq qmang aih, alac broq ka abôq akia padah, alac ta-ùc, abôq akia hanoh pi oe. ");
INSERT INTO hrebt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wop hì Saƀat, Chuaq Jesus xam mangai tiaq hŏc lam trong đùng qmau, jò lam ti trong, mangai tiaq hŏc git hadròc qmau hu kaq. ");
INSERT INTO hrebt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mangai Pharisi hnoq, wì doe ka haq: Ìh ngan tau, hagleq mangai tiaq hŏc Ìh broq yiniq ma ùh khòh broq ta hì Sabat? ");
INSERT INTO hrebt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Chuaq Jesus doe: “Pì ma qnhòq đŏc ta hset, bùa Đawit broq cleq jò haq xam mangai tiaq haq pangot qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Qnhòng Abitha broq pajàu kàn, bùa aih mùt tanòe hnim kùh waiq Boc Plình, bùa aih acaq bênh wì ma padon, hadai am ka wì ma lam tiaq haq acaq diq, hi loq bênh aih toq ƀài mangai pajàu ma khòh acaq?” ");
INSERT INTO hrebt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Khoe aih, Haq doe: “Taiq kon mangai kô majah broq loh hì Saƀat, ùh xài jao hì Saƀat ma jah broq loh kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Qmang aih, Kon Mangai broq craq hì Saƀat.” ");
INSERT INTO hrebt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yàng qnoeq, Jesus mùt tanòe hnim tagop qyoh, ta aih i mòeq ngai gucalô ngwen moeq pah tì. ");
INSERT INTO hrebt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ta aih i qnah ngai rap chaq nen hu rùp haq, wì hamrìh ngan hì saƀat haq i broq brêh ka mangai aih ùh, đòeq hu tah hadrah ka Haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Chuaq Jesus doe ka mangai angwen tì: “Yòng beq! lam oe taqne kô.” ");
INSERT INTO hrebt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Khoe èh Chuaq Jesus bòch wì: “Tiaq ranenh hì Saƀat, broq trong leq ma troq! Khòh broq trong lem loq khòh broq trong qmèq? khòh dèch mangai, loq khòh jêh cađac mangai?” Mahaq dìq ka wì oe hatinh dŏng. ");
INSERT INTO hrebt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Haq haqmiang ngan dudan ka wì, rai nòeh rai mangò ka manoh wì ma cadoq hrìn, khoe aih haq doe ka mangai angwen tì: “Hnhu tì ìh qmat!” haq aih hi bahnhoh dèh tì, aih tì haq hi brêh. ");
INSERT INTO hrebt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ƀài mangai Pharisi loh hloe jò aih raq, wì drah taqmùt pajùm ti bua Hêrot đòeq hatình ka dabau chaq trong jêh đac Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Chuaq Jesus xam mangai tiaq hŏc wia enh aih, wì haq loh ta haqmai diac raxìq, haraya mangai trùh enh gùng Galili, Juđê ");
INSERT INTO hrebt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","enh Jêrusalem, gùng Ydumê, wì pah tau cròng diac Jođan, hloe xam gùng Tyro gùng Siđôn, hìa tàng ƀài yiniq haq ma khoe broq, wì trùh dìq ta Haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mangai bàc pi cajaq, haq hi thê dèh mangai tiaq hŏc palauq đòeq ka haq mòeq toq boang qyoh, dôq wì ùh hìaq dahnen ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Haq khoe broq bàc ngai jah brêh ka hinìq, aih ìq ƀài mangai ùh hrŏc majah àu hnen waq ka jah bèq Haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jò ƀài kiac dù hnoq Chuaq Jesus, wì bla op anòe jènh haq, rai breo: Ìh kô kon Boc Plình! ");
INSERT INTO hrebt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mahaq Chuaq Jesus ùh lòh wì aih anoe ka cabô loq ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Khoe aih, Chuaq Jesus tŏc ta wang, haq creo ka ƀài mangai haq ma enh, wì aih hi trùh ti haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Haq hi ràih yŏc moeq jàt baiq ngai, đòeq hu oe ti haq, èh đòeq haq hu thê wì loh lam hnài bàu lem, ");
INSERT INTO hrebt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Haq am ka wì aih cwìang itai đòeq drùh hnan kan kiac. ");
INSERT INTO hrebt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kô! yiniq wì moeq jàt baiq ngai tiaq cla Haq ma khoe dì: Simôn, Haq yiniq hlài Phiero, ");
INSERT INTO hrebt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jaco xam Jon oh haq, wa aih kon Xêbêđê, Haq yiniq am ka wa Bô-a-net (aih la kon calô da kan camlet kan cađah), ");
INSERT INTO hrebt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anrê, Philip, Bathêlemy, Mathio, Thôma, Jaco kon da Aphê, Thađê, Simôn, mangai Canaan, ");
INSERT INTO hrebt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Hloe xam Juđa Icariôt, mangai ma blòq đac Haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Atìq ka aih, Chuaq Jesus mùt tanòe hnim, i bàc ngai tagop dabau ta aih, Chuaq Jesus xam mangai tiaq hŏc loh ka pi jah acaq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jò wì oh daq Haq tàng qmang aih, wì trùh đòeq hu padràng haq, majah qmang aih wì doe haq khoe rawè. ");
INSERT INTO hrebt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","I ƀài mangai hnài ranenh loh enh Jêrusalem, wì aih doe: Mangai qmat, kiac Bênxebun khoe mùt ta chac haq, haq qmat canòm ka cla craq kan kiac đòeq drùh qnoh kiac. ");
INSERT INTO hrebt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chuaq Jesus creo ka wì aih, haq alìah ka wì: “Satan hnan cla Satan qmang leq majah? ");
INSERT INTO hrebt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tàng joq diac leq to lah rađeh, diac aih èh pi dràng yòng, ");
INSERT INTO hrebt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hnim leq, to lah rađeh, hnim aih èh hadai pi dràng yòng. ");
INSERT INTO hrebt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Qmang aih, tàng joq Satan yòng tablêq ka cla rađeh, aih ajoq haq hit dađeh, haq yòng qmang leq ma oe dràng, ajoq haq khoe trùh dèh jò lùng pac. ");
INSERT INTO hrebt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ùh i mangai leq jah mùt ta hnim mangai dêh padren đòeq hu atùng, tàng joq ùh kàt đòeq cla mangai aih adroe, ep kàt cla haq aih òeq, khoe aih men jah atùng yŏc hang ta hnim haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Au anoe joq qnàng ka pì, yiniq lui kon mangai dìq jah caqnaih dŏng xam rìm nà tapoch qmèq ka Boc Plình hanoh qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mahaq cabô tapoch qmèq ka Yiang Hadròeh, yiniq lui aih ùh jò leq jah caqnaih, haq pòq hloe dèh mòeq đòe”. ");
INSERT INTO hrebt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Chuaq Jesus ma jah doe qmang aih, jao wì aih doe: i kiac oe ta chac haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jò miq Chuaq Jesus xam ƀài oh haq trùh, wì aih yòng enh gùng, thê mangai lam doe ka Haq. Ƀài mangai bàc dua oe raq du danh ka Haq. ");
INSERT INTO hrebt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","I mangai lam doe ka Haq: Miq xam oh ìh wì oe enh gùng, wì enh chaq ìh. ");
INSERT INTO hrebt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mahaq Haq doe ka wì: “Cabô miq au, cabô oh au?” ");
INSERT INTO hrebt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Haq ngan wì ma hangui tap dan ka haq rai doe: “Hatau miq au, xam ƀài oh daq au!” ");
INSERT INTO hrebt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mangai leq broq tiaq manoh Boc Plình, aih raq oh daq calô, oh daq ca drì, aih raq miq au. ");
INSERT INTO hrebt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Chuaq Jesus hnài hòm tanòe haqmai diac raxìq. I bàc ngai tagop ti dabau oe dudan ka haq. Haq cadiang tŏc hangui ta boang, ƀài wì mangai bàc oe dìq tago ti kênh haqmai diac. ");
INSERT INTO hrebt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Haq yŏc bàu alìah hnài wì bàc trong, Jò hnài wì, haq doe: ");
INSERT INTO hrebt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tamàng kô, i mòeq ngai lam rai dèh adrech. ");
INSERT INTO hrebt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jò haq qnang rai adrech, i tang qnah adrech taclìh ti trong lam, khoe aih i chìm loh jôh caq dŏng; ");
INSERT INTO hrebt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","qnah hòm taclìh tanòe hmo raga, ta aih taneh toq biaq, adrech aih rênh plôh, majah qmang aih taneh catùh ùh jrùq. ");
INSERT INTO hrebt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mahaq jò mat mahì tŏc haqnhèq, kan tôq jraq, haq hi cachìt ka croh, majah qmang aih haq ùh i ka riah. ");
INSERT INTO hrebt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mòeq qnah hòm taclìh ta xèm yila, xèm yila èh rai cràm, padit cađac haq loh ka pi hrŏc sròc. ");
INSERT INTO hrebt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Maqnoeq taclìh nòe taneh lem, jah yòng kàn, loh ka tacon, mòeq pliang jah piq jàt, mòeq pliang jah tadràu jàt, pliang qnoeq jah moeq hrinh.” ");
INSERT INTO hrebt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Khoe aih Haq doe: “Cabô i don, tamàng beq!” ");
INSERT INTO hrebt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jò Chuaq Jesus oe đeh moeq ngai, ƀài wì ma oe dudan xam mòeq jàt baiq ngai tiaq hŏc bòch haq bàu alìah aih anoe cleq. ");
INSERT INTO hrebt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Haq doe ka wì: “Kan hlèp oe ta diac Boc Plình khoe patô am ka pì loq. Mahaq ƀài wì ma oe enh gùng tau, rìm yiniq dìq anoe ka wì xam bàu alìah.” ");
INSERT INTO hrebt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Qmang aih dôq wì ngan mahaq ùh hnoq cleq, tamàng aih tàng, mahaq ùh qnì cleq, ùh qmang aih wì tawìh hlài ajoq wì haq jah claih dèh yiniq lui.” ");
INSERT INTO hrebt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Khoe ka aih Haq doe ka wì: “Pì ùh qnì tàng bàu alìah aih qmòh? Aih èh broq qmang leq pì ma loq tàng rìm bàu alìah qnoeq? ");
INSERT INTO hrebt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mangai loh rai adrech aih mangai rai bàu lem. ");
INSERT INTO hrebt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mangai oe ti trong, aih mangai khoe jah bàu mùt ta manoh, mahaq bu tàng bàu aih, tajòe hloe jò aih raq kiac Satan trùh blah yŏc hloe bàu ma khoe rai ta manoh wì haq. ");
INSERT INTO hrebt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hadai tìah ka qmang aih diq, mangai jah adrech taclìh nòe raga, aih ƀài mangai bu tàng bàu khoe dìq jaq lem bùi yŏc ka rađeh. ");
INSERT INTO hrebt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mahaq ta manoh cliac wì haq ùh i ka riah, rìh toq biaq hì, glàm kan tagah, kan baxa taiq bàu aih, wì tacro draq drình jò aih raq. ");
INSERT INTO hrebt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Èh da ƀài mangai qnoeq hòm, tìah ka adrech clìh nòe xèm yila, khoe tàng bàu, ");
INSERT INTO hrebt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mahaq loq lèt ka rìh qmòe qnhòng kô, enh waq toq ka padrŏngkan, xam ƀài yiniq qnoeq hòm mùt ta manoh wì haq wiang padit cađac, bàu lem loh ka pi caqmon. ");
INSERT INTO hrebt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mahaq mangai qnoeq hòm, tìah ka adrech taclìh nòe taneh lem, aih ƀài mangai tàng bàu, wì wê yŏc bàu aih, loh plì, mòeq pliang jah piq jàt, pliang qnoeq jah tadràu jàt, pliang qnoeq jah moeq hrinh”. ");
INSERT INTO hrebt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Haq doe hòm ka wì: “I cabô bùh đen mahaq gùp xi cađap tàng ùh meh đòeq ta caqnàm jùang loq ùh? Ma ùh xài đòeq tanòe haqnhèq? ");
INSERT INTO hrebt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Majah qmang aih ùh i cleq hlèp èh wì ma ùh hnoq, ùh i yiniq leq cadoc èh wì ma ùh paqnoh. ");
INSERT INTO hrebt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tàng cabô i don, tamàng beq”. ");
INSERT INTO hrebt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Haq doe hòm: “Rabiaq haq oq, rìm trong pì ma tàng, pì tŏng xam ranac leq, ranac aih raq wì ma hu tŏng hlài ka pì, ra-ùng haq tah tam ùh hnau ka aih hòm. ");
INSERT INTO hrebt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Majah qmang aih, brì ka am tam ka mangai leq khoe i, mahaq mangai leq ma qnhòq i, doeh yŏc hloe yiniq haq ma khoe i”. ");
INSERT INTO hrebt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Haq anoe hòm: “Diac Boc Plình tìah ka mangai rai adrech ta taneh, ");
INSERT INTO hrebt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","yac cla haq aih kùi, yac cla haq rìu, dahì damang ardech aih dua plôh đeh, cla haq ma i loq qmang leq. ");
INSERT INTO hrebt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Majah qmang aih taneh broq dèh ka long aih loh plì, baxèm aih loh long, atìq aih loh riang, khoe aih riang loh plì. ");
INSERT INTO hrebt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jò plì hi dùm, haq hi qnoh pla haiq, majah qmang aih khoe trùh jò gat.” ");
INSERT INTO hrebt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Haq doe hòm: “Bèn yŏc cleq hu alìah ka diac plình kô èh, yŏc kan patìah leq đòeq hu paqnoh? ");
INSERT INTO hrebt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Diac aih tìah ka adrech habài: Jò wì rai haq aih yeo qyoh dìq dŏng ka adrech qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mahaq jò khoe rai, haq hi jah plôh, haq yeo kàn dŏng ka cachiq qnoeq, loh hamenh kàn, jaq chìm met lam broq qmòe pù ta aih.” ");
INSERT INTO hrebt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Haq yŏc bàc trong alìah qmang aih, đòeq hu hnài wì rìm trong, tiaq dèh wì bu loq tàng dàng leq. ");
INSERT INTO hrebt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yac ka jò leq hnài wì dua haq yŏc bàu alìah đòeq hu hnài, mahaq jò ùh i ka mangai qnoeq, haq hi capoch ka hloh dôq ƀài mangai tiaq hŏc loq tàng. ");
INSERT INTO hrebt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hì aih jò mahì khoe haqneq, haq doe ka ƀài mangai tiaq hŏc: “Beq bèn tŏc apah tau.” ");
INSERT INTO hrebt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jò Haq khoe thê ƀài mangai bàc hlài, haq tŏc ta boang, ƀài mangai tiaq hŏc chùng boang qnung haq lam, i ƀài boang qnoeq hadai lam tiaq. ");
INSERT INTO hrebt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","I kan bahùt kàn, lai laq dêh tep ta boang, diac ten bình qmòe ta boang. ");
INSERT INTO hrebt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mahaq oe enh cloh boang, Chuaq Jesus angèn gàu ajang gôiq haq kùi. Mangai tiaq hŏc tùh padrìu haq: Mangai hnài! bèn cachìt manòeq raq ìh ùh lèt qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Haq hi yòng, lech ka cayeo rai tagàih ka diac: “Hatinh beq, rangep beq!” Cayeo hi dìq, diac loh ka hatinh hatot hloe. ");
INSERT INTO hrebt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Khoe aih Haq bòch mangai tiaq hŏc: “Hagleq pì ma yùq, pì qnhòq i manoh lùi qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wì mangai tiaq hŏc tarìt qmòe rai bòch dabau: Òq mangai kô ìq cabô? Jaq trùh cayeo, trùh lai laq diac raxìq, dìq iu bàu haq! ");
INSERT INTO hrebt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chuaq Jesus xam mangai tiaq hŏc tŏc trùh tago apah tau diac, tagùng Jêrasê. ");
INSERT INTO hrebt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Haq bu cadiang loh enh boang, tajòe qmòe i moeq ngai kiac khoe pawè, tùh loh enh nòe cadràng hanang lam ajang ngèa Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mangai aih haq rìh toq roc nòe cadràng hanang, yac ka wì kàt haq xam caxi datoeq dua ùh dràng. ");
INSERT INTO hrebt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Majah qmang aih khoe bàc yàng wì clang jènh tì haq dua haq goh wah cađac, pi cabô oe blêq haq. ");
INSERT INTO hrebt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Xèq ka hì qngah ka mang haq rangòt roc ralùng hanang xam ta wang, cachech, cajiah yŏc hmo xah dèh ta chac. ");
INSERT INTO hrebt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Oe enh hangai haq hnoq Chuaq Jesus, haq cadàu tùh kùn cràng ajang ngèa Chuaq Jesus, ");
INSERT INTO hrebt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","rai breo ka dêh: Jesus, kon da Boc Plình ma haqnhèq, Ìh enh broq cleq ka au? Au canòm yiniq Boc Plình hu doe ka ìh apaq baxa dèh ka au! ");
INSERT INTO hrebt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Majah qmang aih Chuaq Jesus i doe ka haq: “Kiac dù meh, drah loh enh gùng ka mangai kô.” ");
INSERT INTO hrebt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chuaq Jesus bòch haq hòm: “Gè qmat yiniq cleq?” Haq aih doe: yiniq au ƀài lình, majah qmang aih nhèn bàc haraya, ");
INSERT INTO hrebt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","èh haq toq cali calo ka Chuaq Jesus apaq hnan qnoh wì haq loh enh gùng aih. ");
INSERT INTO hrebt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","I moeq calùh chùa qnang acaq ta hidroe wang haten ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kiac aih bòch Chuaq Jesus: Ìh am nhèn trùh ajang calùh chùa tau, dôq nhèn mùt ta ƀài chùa tau. Chuaq Jesus òq bàu. ");
INSERT INTO hrebt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ƀài kiac aih hi loh enh mangai aih, mùt ta chac calùh chùa, ƀài chùa oe enh ƀùc haqnhèq hadrùc loh ta hlŏng, jah qnah ta baiq muàn toq chùa cachìt ta diac raxìq. ");
INSERT INTO hrebt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ƀài mangai ban chùa cadàu amot, wì haq anoe hlài yiniq kô jàp ka gùng ka plài ta aih. Dìq ka mangai ta gùng aih dahrôq loh ngan yiniq aih. ");
INSERT INTO hrebt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jò wì haq trùh ajang nòe Chuaq Jesus, wì haq hnoq mangai ma i calùh kiac oe ta chac, qnang hangui, atàc eo kwàn, gàu ngoc haq khoe talang, wì dìq jaq crè. ");
INSERT INTO hrebt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ƀài mangai ma khoe hnoq yiniq aih, anoe hlài ka wì qnoeq tàng yiniq ma khoe trùh ka mangai i kiac mùt ta chac, anoe hloe yiniq ma khoe loh ka calùh chùa. ");
INSERT INTO hrebt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Khoe aih dìq ka mangai ta aih hi pi lòh Chuaq Jesus mùt dèh ta gùng. ");
INSERT INTO hrebt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jò Chuaq Jesus bu cadiang tŏc ta boang, mangai adroe nèh kiac ma khoe pawè, haq bòch tiaq. ");
INSERT INTO hrebt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Chuaq Jesus ùh am haq tiaq, mahaq Chuaq Jesus doe ka haq: “Hlài ta hnim ìh beq, anoe ka oh daq ìh loq Chuaq khoe broq am ka ìh yiniq kàn dàng leq, haq khoe loq waq ka ìh qmang leq.” ");
INSERT INTO hrebt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mahaq mangai aih loh lam anoe jàp moeq jàt baiq plài oe ta cròng aih. Haq taqmon hlài yiniq kàn dàng leq Chuaq Jesus khoe broq am ka rađeh, Dìq ka mangai tàng hamàih đeh hra. ");
INSERT INTO hrebt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jò Chuaq Jesus xam mangai tiaq hŏc loh ta boang tŏc pah tau, i ƀài mangai bàc tagop ti da bau oe dudan ka haq, haq oe ti haqmai diac ra xìq. ");
INSERT INTO hrebt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ta wì mangai ma broq gàu hnim tagop qyoh, i mòeq ngai yiniq haq Jairu, trùh ti Chuaq Jesus, jò bu hnoq Chuaq Jesus haq hacùn cràng ajang nòe jènh Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Haq anoe: Kon cadrì au ma qyoh, ten cachìt, au canòm đeh ka Ìh trùh bèq chac haq, dôq haq hu jah rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chuaq Jesus lam ti haq, ƀài mangai bàc hadai lam, wì ti dahnen ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ta aih i mòeq ngai gùcadrì da hrôq mahim khoe moeq jàt baiq hanam, ");
INSERT INTO hrebt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","khoe bàc hanam haq xalep ta tì kŏng ƀài mangai broq jreo, khoe dìq dŏng dèh ka ƀac jèn kùng hang, dua ùh yeo, mahaq yinìq aih èh rai hrìn tam. ");
INSERT INTO hrebt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Haq tàng wì anoe trùh Chuaq Jesus, haq thia đeh enh rù, pachiu taqne mangai bàc đòeq hujah bèq eo Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Majah qmang aih haq doe: Tàng joq au jah bèq đeh toq haqmai eo haq raq, aih au loq đeh brêh. ");
INSERT INTO hrebt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tajòe qmòe jò aih, mahim hi atàt, haq tàng dèh ta chac khoe brêh. ");
INSERT INTO hrebt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jò aih raq, Chuaq Jesus loq i padren khoe loh dèh enh chac, haq hwi hlài taqne mangai bàc haq bòch: “Khoe bèq au?” ");
INSERT INTO hrebt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ƀài mangai tiaq hŏc doe: Ìh hnoq ƀài mangai bàc qmang qmat dahnen ka ìh, ìh ma oe bòch: Cabô bèq eo au? ");
INSERT INTO hrebt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mahaq dua Chuaq Jesus hwi dudan hu chaq mangai leq khoe broq qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mangai gùc cadrì loq yiniq leq ma khoe trùh ka rađeh, rai yùq crè, haq hacùn cràng enh ngìa Chuaq Jesus rai anoe paqnoh dìq dŏng. ");
INSERT INTO hrebt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chuaq Jesus doe ka haq: “Yôiq kon cadrì au, manoh kon lùi khoe broq kon jah brêh. Lam beq lam ka catèm brêh ka yinìq.” ");
INSERT INTO hrebt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Chuaq Jò Jesus oe raq tapoch, i mangai trùh enh hnim Jairu, mangai broq gàu tanòe hnim tagop qyoh, wì aih doe: Kon ìh khoe cachìt, ìh oe pangài dèh ka haq qmat? ");
INSERT INTO hrebt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mahaq Jesus ùh tamàng bàu aih, haq doe ka Jairu: “Apaq yùq, ìh rap toq lùi raq.” ");
INSERT INTO hrebt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chuaq Jesus ùh am mangai leq tiaq haq enh gùng ka Phiero, Jaco xam Jon oh Jaco. ");
INSERT INTO hrebt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jò khoe trùh ta hnim mangai broq gàu nòe hnim tagop qyoh, Haq hnoq wì broq ma tagrùang, qnah ngai hmoe, qnah ngai cajiah. ");
INSERT INTO hrebt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jò khoe mùt ta hnim, Haq doe ka wì: “Gleq pì ma jah tagruàng qmang qmat? Kon qyoh kô ùh xài cachìt, qmat xài haq kùi”. ");
INSERT INTO hrebt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wì do rai halê Haq. Haq thê wì loh dìq dŏng, đòeq toq miq baq kon qyoh aih xam mangai tiaq Haq, hanoh wì haq hi mùt tanòe tangùi kon qyoh aih. ");
INSERT INTO hrebt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Haq rùp tì kon qyoh aih rai doe: “Ta-li-tha-Cu-mi.” (bàu aih doe rameh: Yôiq kon cadrì qyoh, Au thê gè yòng beq.) ");
INSERT INTO hrebt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kon mangai qyoh aih padinh yòng rai cadiang lam, majah qmang aih haq khoe jah moeq jàt baiq hanam. Wì dìq jaq hamàih. ");
INSERT INTO hrebt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Haq panhet wì ùh dùh am ka cabô loq yiniq aih, khoe èh Haq thê wì am kon qyoh aih acaq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chuaq Jesus loh enh aih hlài dèh tagùng, ƀài mangai tiaq hŏc hadai lam ti Haq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Trùh hì Saƀat, haq hi hnài tanòe hnim tagop qyoh, tàng bàu haq hnài, wì dìq jaq hamàih, wì bòch dabau: Ƀài yiniq kô haq jah đeh enh leq? Kan rabiaq meh ìq qmang leq? Jaq ƀài trong halac qmang meh haq broq dua jah haq qmat? ");
INSERT INTO hrebt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Qmat ùh joq mangai thòq broq long, kon da Mari, daq ƀài Jaco, Jôsep, Juđa, Simôn qmòh? Ƀài oh cadrì haq ma ùh xài oe taqne bèn kô qmòh? Wì hi catoeh ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mahaq Chuaq Jesus doe ka wì: “Mangai pajàu toq tagùng cla, oh daq cla, hnim cla raq ma ùh ta-iu ka haq.” ");
INSERT INTO hrebt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ta aih Haq ùh broq kan halac cleq, enh gùng ka yŏc tì bèq biaq ngai ùh hrŏc dôq wì aih jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Haq loh ka hamàih majah qmang aih hnoq manoh wì ùh lùi. Khoe aih haq lam jàp plài ten aih hu hnài wì. ");
INSERT INTO hrebt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Haq creo dèh ka moeq jàt baiq ngai Tiaq cla, thê wì lam tang racop baiq ngai, haq am ka wì aih cwìang drùh qnoh kiac chŏc. ");
INSERT INTO hrebt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Haq tanap ka wì lam ti trong apaq wê cleq enh gùng ka mòeq toq long canhra, yac ka ƀênh yac ka ayôp, apaq wê ƀac ta caqnam, ");
INSERT INTO hrebt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","enh gùng ka tŏc jep, ùh dùh wê racop baiq blah eo. ");
INSERT INTO hrebt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Haq doe ka wì: Jò pì mùt ta hnim cabô, pì hi oe hloe ta aih trùh hì pì loh lam. ");
INSERT INTO hrebt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tàng i nòe leq ùh waq đìh pì, ùh tamàng bàu pì, drah loh enh aih rai hapùih blo ma khoe top ta jènh pì, đòeq broq acang ka wì hnoq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Moeq jàt baiq ngai Tiaq cla loh lam anoe hnài dôq rìm ngai loq raxach, ");
INSERT INTO hrebt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","drùh hnan qnoh bàc kiac chŏc, xùt dàu am ka bàc ngai yinìq rai broq brêh ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bùa Hêrôt tàng wì anoe trùh Chuaq Jesus, (majah qmang aih yiniq Chuaq mangai khoe loq đeh hra jàp jìa) haq doe: Jon mangai broq ƀaptem, cachìt khoe rìh hlài, ha-aih haq men jah broq bàc trong halac. ");
INSERT INTO hrebt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mangai qnoeq hòm doe: Aih Êli, qnah ngai qnoeq doe: Aih mangai pajàu dùnh qnhòng calah nèh. ");
INSERT INTO hrebt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mahaq da bùa Hêrôt doe: Aih raq Jon, mangai au khoe thê pot ranŏng, haq khoe rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Majah qmang aih, Hêrôt i thê wì rùp clêh Jon ta hnim cadrong, xèm goe haq oe ajang nòe bùa Hêrot yŏc Hêrô-đia aih cadrì da Philip oh cla bùa Hêrot raq, đòeq broq mai. ");
INSERT INTO hrebt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon i bàu ùh lòh haq rameh: Bùa ùh khòh yŏc cadrì dèh oh broq mai. ");
INSERT INTO hrebt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Aih ìq, Hêrođia majah git ka Jon, enh chaq trong jêh cađac haq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mahaq ùh jah jêh, majah qmang aih Hêrot crè ka Jon, loq Jon kô aih mangai hadròeh, mangai taq atoq. Bùa chaq trong wèq Jon, jò khoe tàng bàu Jon, ta manoh bùa toq manhài, mahaq dua bùa enh tamàng. ");
INSERT INTO hrebt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yàng èh taqnàih, wop glàm hì acaq ôq manè hì ha-uang bùa Hêrot, bùa akhen ka ƀài cwan kàn, cwan wèq ƀài lình, xam dìq dŏng gucraq ta gùng Galili. ");
INSERT INTO hrebt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kon adrùh da Hêrođia mùt muaq ta aih, lem ka manoh bùa Hêrot xam ƀài mangai acaq ôq hì aih. Bùa doe ka kon mangai adrùh aih: Drah bòch beq enh waq cleq, au hu am. ");
INSERT INTO hrebt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bùa hapah ka haq aih rameh: Waq toq hi bòch cleq, dua au am, pah axon taneh diac kô ùh loe. ");
INSERT INTO hrebt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mangai cadrì aih loh enh gùng, hatùang dèh ka miq: Au bòch cleq ma yeo troq kô? Miq haq doe: Bòch gàu Jon Ƀaptit. ");
INSERT INTO hrebt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mangai cadrì aih drah mùt ajang bùa, haq doe: Au enh ìh yŏc gàu Jon Baptit tah ta dòt kàn am ka au manòeq raq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bùa mangò pi ka jaq, mahaq khoe troq hapah, èh qnah hòm enh ngèa bàc ngai acaq ôq ta aih, bùa pi xèp hangah ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bùa hi thê dèh lình lam jêh cađac Jon khoe aih aràng gàu haq ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mangai lình aih lam pot ranŏng Jon ta hnim cadrong, khoe èh haq tah gàu aih ta dòt kàn aràng am ka kon mangai cadrì, èh mangai kon cadrì aih aràng dèh ka miq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mangai tiaq hŏc Jon hìa qmang aih, wì lam yŏc dèh hanang haq hlài catùh. ");
INSERT INTO hrebt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Moeq jàt baiq ngai Tiaq cla tagop dabau oe dudan ka Chuaq Jesus, anoe hlài ka haq rìm yiniq wì haq ma khoe broq khoe hnài. ");
INSERT INTO hrebt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Haq doe dèh ka ƀài mangai tiaq cla: “Beq bèn lam tanòe ma hawit hu padài toq biaq.” Majah qmang aih tacô mangai lam hlài bàc hrìn, jaq haq xam ƀài mangai tiaq cla met pi dòh jah acaq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wì haq hi loh ta boang đòeq hu lam tanoè ma yeo hawit. ");
INSERT INTO hrebt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mahaq bàc ngai hnoq wì haq lam, wì canau loq, ƀài mangai oe bàc plài ta gùng aih cadàu trùh adroe tanòe Chuaq Jesus xam bài mangai tiaq cla lam. ");
INSERT INTO hrebt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jò Chuaq Jesus cadiang tŏc enh boang, haq hnoq bàc mangai oe ta aih, haq tadèch qmòe nòeh, haq tamèt ka wì aih, majah qmang aih ƀài wì aih tìah ka trìu ùh i ka mangai ban. Haq hi hnài wì bàc trong ");
INSERT INTO hrebt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Trùh jò mat mahì khoe haqneq, mangai tiaq hŏc thia haten ka Chuaq, wì anoe: Tacô hawit, èh qnah hòm trŏc khoe ten xèq, ");
INSERT INTO hrebt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ìh am wì bròc, dôq wì ti mùt roc plài ten tacô hu rot dahwèq acaq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Haq padreo bàu: “Pì kô raq mangai am ka wì acaq.” Mangai tiaq hŏc anoe: Qmang aih nhèn ep dìq loe qne hanam ƀac kùng abroq hu rot ƀênh am ka wì acaq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Haq bòch: “Pì i toq leq toq ƀênh? lam ti ngan beq!” Mangai tiaq hŏc lam ti ngan, khoe èh wì doe: Padam toq ƀênh xam baiq pliang ka. ");
INSERT INTO hrebt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Haq doe ka ƀài mangai tiaq hŏc thê wì hangui tang apùq tanòe nhat. ");
INSERT INTO hrebt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wì hangui tiaq tang brong, i brong moeq hrinh, brong padam jàt. ");
INSERT INTO hrebt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus yŏc ƀênh xam baiq pliang ka, haq qngoc ta plình, manè apui, khoe aih haq goh ƀênh qnèp am ka mangai tiaq hŏc dôq wì lam am ka wì ma hangui ta nhat acaq, Haq hanoh axong baiq pliang ka qmang aih ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Rìm ngai acaq dìq jaq panàc, ");
INSERT INTO hrebt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","mangai tiaq hŏc toch hlài rah bình moeq jàt baiq talênh haqnech ƀênh xam ka. ");
INSERT INTO hrebt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Toq gucalô ma acaq hì aih khoe padam muàn mangai. ");
INSERT INTO hrebt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Khoe ka aih, Haq pariaq mangai tiaq hŏc drah loh ta boang, hu tŏc pah tau adroe ka haq, tangèa qnah ta gùng Bêtsaiđa, jò haq thê ƀài mangai bàc hlài. ");
INSERT INTO hrebt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Atìq ka haq talah ka wì, haq tŏc ta wang đòeq hu waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Trùh damang, boang khoe oe taqne diac, cla haq oe moeq ngai tago. ");
INSERT INTO hrebt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Haq hnoq ƀài mangai tiaq hŏc chiu boang dìq jaq xalep, majah qmang aih glàm cayeo tàt ngèa wì haq. Trùh ten qngah, haq lam jènh ti riang diac hu trùh ti wì, haq enh lam adroe ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mangai tiaq hŏc hnoq haq lam ti riang diac, xoh kiac chŏc, wì cajiah, ");
INSERT INTO hrebt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Majah qmang aih wì dìq hnoq haq, ùh i cabô ma ùh crè. Mahaq haq drah creo capoch ka wì, haq doe: “Paq yùq, hacô Au kô, apaq yùq.” ");
INSERT INTO hrebt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Haq cadiang tŏc ta boang ti ƀài mangai tiaq hŏc, tajòe qmòe jò aih cayeo hi hatinh hloe. Ƀài mangai tiaq hŏc hamàih ùh hnau adroe ka aih hòm. ");
INSERT INTO hrebt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Majah qmang aih, manoh wì haq cadoq yac ka wì khoe hnoq kan halac jò haq broq ƀênh, dua wì qnhòq qnì cleq. ");
INSERT INTO hrebt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jò Chuaq Jesus xam mangai tiaq hŏc khoe tŏc apah tau, trùh ta Gênesaret, wì mùt ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jò bu cadiang loh enh boang, wì gùng aih khoe canau ka Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wì drah cadàu jàp gùng aih wì tòng aràng mangai ùh hrŏc kùi ta dradrah, waq toq wì hìa haq oe taleq, wì tòng qnàng trùh ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Haq lam trùh taleq, yac ka plài qyoh, plài kàn, yac ta gùng leq, wì taqngùi mangai ùh hrŏc tanòe chòq, wì bòch haq am ka wì jah bèq đeh toq haqmai eo haq, mangai leq khoe jah bèq eo haq dìq jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","I mangai Pharisi xam ƀiaq ngai hnài ranenh, wì aih loh enh Jêrusalem, wì oe dudan ka Jesus ");
INSERT INTO hrebt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wì aih hnoq i mangai tiaq hŏc, acaq xam tì ùh sròeh, aih ìq wì acaq mahaq ùh qnheo tì. ");
INSERT INTO hrebt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mangai Pharisi xam dìq dŏng mangai Juđa wèq yôt bàu wì craq dùnh nèh qmon, ");
INSERT INTO hrebt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","tàng jòq qnhòq qnheo tì ka lem, ùh jò leq wì haq acaq, jò wì haq hlài enh nòe padro atech, tàng joq qnhòq qnheo dua wì ùh acaq. Wì haq oe tiaq bàc bàu qmon qnoeq hòm, troeq haliang doe mŏng, abôq broq xam taneh, gŏc diac. ");
INSERT INTO hrebt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aih ìq qmang aih, dài mangai Pharisi xam mangai hnài ranenh majah bòch Chuaq Jesus: Hagleq mangai tiaq hŏc ìh ùh wèq tiaq bàu wì craq dùnh nèh haq khoe hnài, gleq wì majah acaq ùh dùh qmòe ka qnheo tì. ");
INSERT INTO hrebt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Haq padreo bàu doe: “Wùih! Ƀài mangai patìah toq enh gùng meh, bàu pajàu Êsai ràu trùh pì nèh joq khoe troq, qmang ka bàu khoe achìh: Wì kô yŏc toq bàu kùh waiq au, Mahaq manoh wì haq hangai ka au. ");
INSERT INTO hrebt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wì haq kùh waiq au aih joq qngwan, majah qmang aih, wì haq hnài tiaq toq ranenh loh enh bàu kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pì cađac ranenh Boc Plình, mahaq wèq tiaq bàu kon mangai qmon!” ");
INSERT INTO hrebt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Haq doe ka wì: “Pì cađac dŏng ranenh Boc Plình, đòeq hu wê tiaq bàu cla qmon. ");
INSERT INTO hrebt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Majah qmang aih Môise i doe: Thê pì loq iu dèh miq baq, èh qnah hòm: Cabô hanip ra-òh dèh ka miq baq, mangai aih ep cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mahaq da pì aih doe: Mangai leq doe dèh ka miq baq: Rìm yiniq au đòeq wiang ban chôp au khoe côƀan (bàu aih rameh: au khoe dèch dŏng ka Boc Plình.) ");
INSERT INTO hrebt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Qmang aih mangai aih pi ep wèq ngan miq baq. ");
INSERT INTO hrebt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Qmang aih pì yŏc bàu cla rađeh qmon đòeq hu cađac bàu Boc Plình. Oe i bàc trong qnoeq hòm pì hadai broq qmang aih.” ");
INSERT INTO hrebt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Haq creo ka ƀài mangai bàc ma oe ta aih, haq doe: “Thê pì rai tamàng rai loq tàng, ");
INSERT INTO hrebt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ùh i ka yiniq cleq oe enh gùng mùt ta chac pì, broq ka pì ùh sròeh, mahaq ƀài yiniq enh dalam ka chac pì loh enh gùng, yiniq aih èh ma broq ka pì ùh sròeh.” ");
INSERT INTO hrebt_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tàng cabô i don, tamàng beq (Bàu kô ta hset dùnh nèh ùh i). ");
INSERT INTO hrebt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jò Haq khoe mùt ta hnim, jò khoe hangai ka ƀài mangai bàc, mangai tiaq hŏc bòch haq bàu alìah aih. ");
INSERT INTO hrebt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Haq padreo bàu: “Pì ma ùh i ka manoh loq hèm? Ùh i ka yiniq leq oe enh gùng mùt ta chac mangai, jah broq ka mangai loh ka amùa, bàu aih pì ma qnhòq qnì tàng? ");
INSERT INTO hrebt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Majah qmang aih ƀài yiniq aih ùh i mùt ta manoh mangai, mahaq ƀài yiniq aih loh hloe ta padùc, khoe aih hi loh enh gùng. Qmang aih haq doe: Yiniq acaq aih dìq lem. ");
INSERT INTO hrebt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Haq doe tam: “Yiniq leq loh enh chac mangai aih ma broq ka mangai ùh sròeh! ");
INSERT INTO hrebt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Joq qnàng aih enh dalam ka mangai ma jah loh manoh dù, loq taqnung, loq atùng, loq jêh đac mangai. ");
INSERT INTO hrebt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Tango anang, daiq plai, ratauq, gôpla, ùh qnì camaih, ta grình, tapoch dech ka wì, panhòm, tapoch blùng. ");
INSERT INTO hrebt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ƀài kan qmèq aih dìq loh enh manoh, aih ma broq ka mangai loh ka ùh sròeh. ");
INSERT INTO hrebt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chuaq Jesus loh enh aih haq lam ti kênh gùng Tiro, Haq mùt ta moeq toq hnim aih, ùh enh am cabô loq haq oe ta aih, mahaq ùh hlèp. ");
INSERT INTO hrebt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bu mùt ta aih, i moeq ngai gucadrì haq aih i moeq toq kon cadrì qyoh i kiac mùt ta chac, jò haq hìa tàng Chuaq Jesus, haq aih mùt pacro dađeh nòe jènh Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Gucadrì aih mangai Gorec, ha-uang ta gùng Siro Phênisi. Haq canòm đeh ka Chuaq Jesus hnan qnoh kiac loh enh chac kon haq. ");
INSERT INTO hrebt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Chuaq Jesus doe ka haq: “Adroe aih, đòeq da cla wì yoh acaq ka panàc òeq, majah qmang aih yŏc ƀênh wì qyoh acaq caqnìh am ka koq aih ùh troq!” ");
INSERT INTO hrebt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Gucadrì aih padreo bàu: Waiq Chuaq, khoe joq qmang aih raq, mahaq ƀài kon koq oe đeh ta caqnàm jah acaq đeh cràc ƀênh kon qyoh ma taclìh. ");
INSERT INTO hrebt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Khoe aih Chuaq Jesus doe ka mangai cadrì: “Pàng ìh khoe doe qmang aih, kiac majah khoe loh enh chac kon ìh, hlài beq”. ");
INSERT INTO hrebt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mangai gucadrì aih hlài dèh ta hnim, haq hnoq dèh kon oe ta juàng, kiac khoe loh. ");
INSERT INTO hrebt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Atìq ka aih, Chuaq Jesus pi oe ta kênh gùng Tiro hòm, haq lam pajang trong gùng Siđôn rai dang jùa loh diac raxìq Galili, khoe aih Haq mùt ta cròng Đêcaboli. ");
INSERT INTO hrebt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wì tòng aràng ka haq moeq ngai clìc don rai tapoch ùh hloh, wì canòm đeh ka Chuaq Jesus yŏc tì bèq mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chuaq Jesus qnung haq aih lam ti rađeh, hangai ka mangai bàc tau, Chuaq Jesus yŏc hadrang tì đòeq ajang don haq aih, rai yŏc diac hai xùt rapet haq aih. ");
INSERT INTO hrebt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chuaq Jesus qngŏc ta plình, haq hihèm cadrùq, haq doe: “Ephata, (bàu aih rameh: Ta pèch beq!) ");
INSERT INTO hrebt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tajòe qmòe jò aih raq, don mangai aih hi tapèch, rapet haq aih hadai jah rađah ka lem, mangai aih hi hloh tapoch. ");
INSERT INTO hrebt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Chuaq Jesus ùh am wì anoe ka cabô loq, mahaq haq ùh am dàng leq, wì anoe yeo hnau ka aih hòm. ");
INSERT INTO hrebt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ƀài mangai tàng yiniq aih, wì hamàih oe i jaq cleq, wì doe: Haq broq rìm yiniq dìq loh ka lem dŏng, broq ka mangai clìc don jah tàng, mangai làu jah hloh tapoch. ");
INSERT INTO hrebt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ƀài hì aih, i bàc mangai qnoeq hòm lam tiaq Chuaq Jesus, jò wì aih pi i cleq hu acaq hòm, Chuaq Jesus creo ka mangai tiaq hŏc trùh ajang da đeh, Haq doe: ");
INSERT INTO hrebt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Au ha-och ka ƀài mangai bàc kô, wì haq oe ti au khoe jah piq hì kô, ùh i ka yiniq acaq. ");
INSERT INTO hrebt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tàng joq au thê wì haq hlài ta hnim rai pangot, wì haq loq tacro ti trong majah qmang aih wì haq trùh enh nòe hangai”. ");
INSERT INTO hrebt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mangai tiaq hŏc padreo bàu: Mahaq tanòe hawit qmang kô, cabô qnì chaq enh leq ma i ƀênh tàu ka wì acaq? ");
INSERT INTO hrebt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus bòch: “Pì i toq leq toq ƀênh?” mangai tiaq hŏc doe: i tapèh toq! ");
INSERT INTO hrebt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Haq thê ƀài mangai bàc aih haqngui ta taneh; khoe aih Haq yŏc tapèh toq ƀênh, manè apôi Boc Plình, haq goh ƀênh aih khoe èh qnèp ka mangai tiaq hŏc, đòeq wì haq lam axong ka mangai bàc acaq, mangai tiaq hŏc lam axong ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mangai tiaq hŏc hanoh i biaq pliang kon ka qyoh, haq manè apôi Boc Plình khoe èh thê mangai tiaq hŏc lam axong qmang ka yàng adroe diq. ");
INSERT INTO hrebt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mangai leq mangai meh acaq qmòe ka tàu joq qnàng. Khoe aih mangai tiaq hŏc toch hlài ƀài hanech oe rah jah qmòe tapèh talênh bình. ");
INSERT INTO hrebt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ƀài mangai acaq hì aih jah qnah ta pôn muàn. ");
INSERT INTO hrebt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Atìq ka khoe am wì hlài, haq tŏc ta boang ti mangai tiaq hŏc, lam ta gùng Đama-nutha. ");
INSERT INTO hrebt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ƀài mangai Pharisi trùh bòch Chuaq Jesus, đòeq hu chaq trong bahlac haq, wì thê haq am wì hnoq kan halac enh plình, đòeq hu qnhro Haq. ");
INSERT INTO hrebt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chuaq Jesus hi hèm cadrùq, rai doe: “Hagleq xinoe kô majah bòch ngan kan halac. Au anoe joq qnàng ka pì, ùh i kan halac leq hu am ka pì.” ");
INSERT INTO hrebt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Haq hi cađac wì, tŏc hlài dèh taboang đòeq hu tŏc pah tau. ");
INSERT INTO hrebt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mangai tiaq hŏc ùh hmàng wê ƀênh, taboang i mòeq toq ƀênh raq. ");
INSERT INTO hrebt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Haq pariaq mangai tiaq hŏc: “Ngan oq, pì ep wèq rađeh ma khoe ka blo da mangai Pharisi xam blo ƀài bua da Hêrot”. ");
INSERT INTO hrebt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mangai tiaq hŏc doe ka dabau: Aih jao bèn ùh i wê ƀênh. ");
INSERT INTO hrebt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Loq ka trong wì ta hatuàng, Chuaq Jesus bòch wì haq: “Gleq pì ma jah hatuàng ti dabau bèn ùh i ka bênh? Pì ma qnhòq tàng, pì ma qnhòq tem raq qmòh? Manoh pì dua oe raq cadoq yôt qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pì i mat mahaq gleq ma ùh hnoq? I don mahaq gleq ùh tàng? Pì ùh hmàng qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jò au goh padam toq ƀênh am ka padam muàn mangai acaq, haqnech haq pì toch hlài jah toq leq rajo?” Wì doe: Moeq jàt baiq rajo. ");
INSERT INTO hrebt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ha yàng au goh tapèh toq ƀênh am ka pôn muàn mangai acaq, pì toch hlài jah toq leq rajo? Wì doe: tapèh rajo. ");
INSERT INTO hrebt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Haq doe: “Pì dua oe raq qnhòq qnì qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chuaq Jesus xam mangai tiaq hŏc lam trùh ta plài Bêtsaida. Wì aràng ka haq mòeq mangai lua mat wì canòm đeh ka haq yŏc tì bèq haq aih. ");
INSERT INTO hrebt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Chuaq Jesus carùp tì mangai aih, tìc qnoh enh gùng ka plài, xùt diac hai ta mat haq aih, yŏc tì bèq haq aih rai bòch: “Ìh i hnoq cleq ùh?” ");
INSERT INTO hrebt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mangai lua mat qngoc ta haqnhèq rai padreo bàu: Au hnoq mangai wì haq lam tìah taiq ka long. ");
INSERT INTO hrebt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chuaq Jesus yŏc tì bèq mat mangai aih mòeq yàng hòm, aih mat haq hi tapèh, jah qngah, haq hnoq rìm yiniq dìq jaq hliang. ");
INSERT INTO hrebt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chuaq Jesus thê haq aih hlài dèh ta hnim rai tanap: “Ùh dùh mùt dèh ta plài.” ");
INSERT INTO hrebt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chuaq Jesus xam mangai tia hŏc loh enh aih, wì lam ta roc plài haten ka Sêsare philip. Jò lam ti trong haq bòch wì: “Wì doe au kô ìq cabô?” ");
INSERT INTO hrebt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wì padreo bàu: Qnah ngai doe Jon Ƀaptit, tang ngai doe Êli, mangai qnoeq hòm doe ìh qmat moeq ngai pajàu dùnh calah nèh. ");
INSERT INTO hrebt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Haq bòch: “Ha pì doe au kô ìq cabô?” Phiero padreo bàu: Ìh kô raq Christ! ");
INSERT INTO hrebt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chuaq Jesus panhet mangai tiaq hŏc ùh jah anoe ka mangai qnoeq loq ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pang aih, haq hi hnài ka mangai tiaq hŏc rameh “Kon Mangai ep xalep bàc trong, ƀài wì gucraq, ƀài pajàu kàn xam ƀài mangai hnài ranenh kêh qnoh đac haq, haq ep cachìt, atìq ka piq hì haq hi rìh hlài.” ");
INSERT INTO hrebt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Haq anoe hloh trong aih ka mangai tiaq hŏc. Phiero qnàng Haq lam ta kênh rai tagàih haq. ");
INSERT INTO hrebt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mahaq Chuaq Jesus hwi ngan mangai tiaq hŏc rai tapoch ka Phiero: “Wùih Satan meh! Drah wia oe enh rù ka au beq. Majah qmang aih ìh ùh i hèm trùh trong da Boc Plình, mahaq hèm toq trong kon mangai.” ");
INSERT INTO hrebt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Khoe aih haq creo ka ƀài mangai bàc xam mangai tiaq hŏc trùh ajang haq. Haq doe: “Tàng cabô enh tiaq au, haq aih ep cađac rađeh, xùi dèh long pagat đòeq hu tiaq au. ");
INSERT INTO hrebt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Majah qmang aih cabô àu wèq dèh kan rìh, aih èh hnhung, mahaq mangai leq taiq au taiq bàu lem chìuq cađac dèh kan rìh, mangai aih èh jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mangai leq i dìq dŏng crŏng taneh kô mahaq cađac hnhung dèh ka mahua yiang, aih haq jah cleq? ");
INSERT INTO hrebt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","I ka cabô jah yŏc cleq đòeq hu halìh yŏc hlài dèh mahua yiang ùh? ");
INSERT INTO hrebt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Oe taqne nang noe loq taqnung tango, broq toq yiniq lui kô, tàng cabô xep camaih ka yiniq au, camaih ka bàu au, Kon Mangai hadai camaih xep ka mangai aih, jò haq oe taqne kan ranhòm enh Baq haq hu trùh, xam ƀài ƀình plình hadròeh.” ");
INSERT INTO hrebt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Èh Haq doe ka mangai taq hŏc: “Joq qnàng Au doe ka pì, pì ma yòng ajang kô i ngai ùh cachìt adroe ka jah hnoq diac Boc Plình yŏc cwìang itai hu trùh. ");
INSERT INTO hrebt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Atìq ka tadràu hì, Chuaq Jesus aràng Phiero, Jaco xam Jon tiaq haq tŏc ta wang haqhèq, ùh i ka mangai qnoeq ta aih, toq wì haq raq. Ta aih Haq wìh wìa enh ngèa wì piq ngai. ");
INSERT INTO hrebt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Eo Haq loh ka taboc camla dìq jaq, ùh i mangai leq oe ta crŏng taneh broq taboc jah qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Êli xam Môise loh hatuàng ti Haq. ");
INSERT INTO hrebt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phiero doe ka Chuaq Jesus: Rabi! Bèn oe ta kô lem joq qnàng, beq broq piq toq ranòh, moeq toq ka Ìh, moeq toq ka Môise, moeq toq hòm ka Êli. ");
INSERT INTO hrebt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Phiero ùh qnì qmòe đeh doe cleq, majah qmang aih dìq ka wì haq yùq crè pi ka jaq. ");
INSERT INTO hrebt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","khoe aih i moeq cato yùc kàn glàp wì haq, enh yùc aih i bàu doe: “Kô raq Kon calô da Au, mangai Au ma loq waq dèh, thê pì tamàng bàu haq.” ");
INSERT INTO hrebt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jò aih, ƀài mangai tiaq hŏc hwi ngan dudan, cadoe pi hnoq cabô, enh gùng ka moeq ngai Chuaq Jesus raq ma oe ti wì. ");
INSERT INTO hrebt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jò wì loh enh wang, haq ùh lòh mangai tiaq hŏc anoe hlài ka cabô loq bài yiniq wì haq ma khoe hnoq, trùh jò leq Kon Mangai khoe rìh hlài enh cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mangai tiaq hŏc wê bàu aih, wì bòch dabau: Cachìt rìh hlài, aih ìq haq doe cleq? ");
INSERT INTO hrebt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mangai tiaq hŏc bòch haq: Hagleq ƀài mangai hnài ranenh ma doe Êli ep trùh adroe? ");
INSERT INTO hrebt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chuaq Jesus padreo bàu: “Joq Êli ep trùh adroe, đòeq hu palauq hlài rìm trong. Aih ìq hagleq majah i bàu achìh Kon Mangai ep xalep bàc trong, wì halê cađac haq? ");
INSERT INTO hrebt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mahaq au doe ka pì Êli khoe trùh, wì tabroq ka haq tiaq dèh manoh wì ma enh, wop troeq bàu ma khoe achìh trùh haq.” ");
INSERT INTO hrebt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jò Chuaq Jesus xam piq ngai aih lam trùh ajang nòe ƀài mangai hanoh tiaq hŏc, hnoq mangai bàc pi ka jaq oe dudan ka wì aih, èh i mangai hnài ranenh tarahen ka ƀài mangai tiaq hŏc aih. ");
INSERT INTO hrebt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ƀài mangai bàc aih bu hnoq haq wì khoe hamàih, wì tùh ta haq. ");
INSERT INTO hrebt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Haq bòch wì: “Pì rahen ka mangai tiaq hŏc au yiniq cleq?” ");
INSERT INTO hrebt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","I moeq ngai ta aih tèu bàu: Mangai hnài! Au aràng dèh kon trùh ka ìh, kiac làu khoe pawè haq, ");
INSERT INTO hrebt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","yac ka qnang oe taleq, jò kiac hi mùt ta haq broq ka haq loh ka troq kênh, loh toq diac hai camùh, cadrit hanenh, haq loh ka gang got hloe, au canòm đeh ka mangai tiaq hŏc drùh qnoh kiac aih, mahaq ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chuaq Jesus doe: “Wùih! nang noe ùh qnì lùi tau, Au oe jah oe ti pì trùh pang leq? Au ep àt ka pì trùh jò leq hòm? Qnàng kon mangai qyoh aih ka au”. ");
INSERT INTO hrebt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wì hi qnàng kon qyoh aih ka haq. Kon qyoh aih bu hnoq Chuaq Jesus, kiac khoe rapôh haq, haq tacro ta taneh, cadro cadria hacùng loh toq diac hai. ");
INSERT INTO hrebt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chuaq Jesus bòch baq haq: “Haq loh ka qmang kô dùnh neo?” Baq haq tèu: enh qyoh nèh raq. ");
INSERT INTO hrebt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kiac khoe bàc yàng khwênh qnìh haq ta ùnh, ta diac, hu jêh đac haq, mahaq ìh broq cleq jah, ìh ha-och rai broq biaq ka ma diq! ");
INSERT INTO hrebt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chuaq Jesus doe: “Hagleq ìh majah doe: Tàng ìh broq jah? Waq toq cabô hi lùi rìm yiniq dìq jah”. ");
INSERT INTO hrebt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Baq kon mangai qyoh aih drah doe: au lùi ìh, Waiq Chuaq! Ìh wiang biaq da au ajang kan ùh qnì lùi aih. ");
INSERT INTO hrebt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jò Chuaq Jesus hnoq mangai bàc trùh, Haq lech ka kiac aih rai thê: “Kiac clìc rai làu meh, au thê gè loh enh kon mangai qyoh kô, pang kô ta èh pi jah pawè haq hòm”. ");
INSERT INTO hrebt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kiac rai cajiah rai rapôh kon qyoh aih cadêh, khoe kiac hi loh, kon mangai aih tìah qmòe ka khoe cachìt, bàc ngai crè wì doe: haq khoe cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mahaq Chuaq Jesus rùp tì dèch haq hi yòng. ");
INSERT INTO hrebt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jò Chuaq Jesus khoe mùt ta hnim, mangai tiaq hŏc thia haten wì chop bòch: Gleq nhèn drùh kiac aih ùh jah? ");
INSERT INTO hrebt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Haq doe: “Tàng ùh waiq khàn ùh i cabô drùh qnoh kiac aih jah.” ");
INSERT INTO hrebt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Khoe aih Chuaq Jesus xam mangai tiaq hŏc loh enh aih, lam pagat trong Galili, Haq ùh enh dôq ka cabô loq wì haq qnang oe taleq. ");
INSERT INTO hrebt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Majah qmang aih haq khoe hnài dèh mangai tiaq hŏc, haq doe: “Kon mangai kô èh mùt ta tì wì, wì jêh cađac, haq cachìt piq hì khoe èh rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mahaq mangai tiaq hŏc ùh tem bàu aih, wì ùh hùa bòch haq trong aih. ");
INSERT INTO hrebt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wì haq trùh ta Cabênaum. Jò khoe oe ta hnim, haq bòch wì: “Jò lam ti trong ìq pì tarahen cleq ka dabau? ");
INSERT INTO hrebt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mahaq wì hatinh majah qmang aih oe ti trong wì tarahen ka dabau: Taqne bèn kô cabô ma yeo kàn? ");
INSERT INTO hrebt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chuaq Jesus hangui, creo dŏng moeq jàt baiq ngai tiaq hŏc, Haq doe: “Mangai leq enh broq gàu, haq aih ep oe atìq lùch, ep broq hapŏng patìh ka wì qnoeq.” ");
INSERT INTO hrebt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Haq yŏc moeq toq kon qyoh, tah taqne mangai tiaq hŏc, khoe aih haq caqmìn kon qyoh aih rai doe ka wì: ");
INSERT INTO hrebt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Cabô jao Yiniq Au chìuq đìh moeq ngai kon qyoh qmang kô, aih haq đìh au, cabô đìh au, aih ùh xài haq đìh au, mahaq đìh Mangai ma khoe thê au.” ");
INSERT INTO hrebt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon doe ka Haq: Mangai hnài, nhèn khoe hmaq hnoq i mangai yŏc yiniq ìh đòeq drùh kan kiac, nhèn khoe ùh lòh haq, majah qmang aih wì aih ùh tiaq bèn. ");
INSERT INTO hrebt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Chuaq Jesus doe: “Apaq tàt dèh, ùh i mangai leq rai yŏc yiniq au broq kan halac rai tapoch qmèq ka au. ");
INSERT INTO hrebt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Majah qmang aih, mangai leq ùh hìaq taƀlêq ka bèn haq aih hanoh ti bèn. ");
INSERT INTO hrebt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Cabô jao yiniq au kô èh ma am ka pì moeq doe chrŏng diac, majah qmang aih taiq pì aih mangai da Christ, Joq qnàng au doe ka pì haq aih ùh hnhung dèh kan baha. ");
INSERT INTO hrebt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mahaq mangai leq broq ka mòeq ngai taqne ƀài wì qyoh kô khoe lùi au clìh ta yiniq lui, yŏc apau hmo ma kàn kàt ranŏng haq aih lam cadram ta diac raxìq aih ùh hnau hòm. ");
INSERT INTO hrebt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Tàng joq tì ìh broq ka ìh loh yiniq, pot đac tì aih, yac ka moeq apah tì mahaq jah mùt ta kan rìh, ùh hnau tôm baiq apah tì mahaq taclìh ta hwinh, ta ƀau ùnh ùh pat. ");
INSERT INTO hrebt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Tàng jènh ìh broq ka ìh loh yiniq, pot cađac jènh aih, moeq apah jènh mahaq jah mùt ta kan rìh, ùh hnau tôm baiq apah jènh mahaq wì khwênh qnìh ta bau ùnh. ");
INSERT INTO hrebt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tàng joq mat ìh broq ka ìh loh yiniq, ƀŏc đac mat aih beq, oe moeq apah mat ma haq jah mùt ta diac BocPlình, ùh hnau tôm baiq pah mat mahaq ta clìh ta hwinh, ");
INSERT INTO hrebt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","aih la nòe i hrai ma kaq wì haq, hrai aih ùh kachìt, tanòe ùnh ùh jò leq pat. ");
INSERT INTO hrebt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Rìm ngai ta aih jah paqnhòq xi ùnh. ");
INSERT INTO hrebt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Boh aih ngè lem, mahaq tàng boh aih pi xang, aih èh yŏc cleq hu broq haq xang hlài. ");
INSERT INTO hrebt_vpl VALUES ("MK9_51","071_9_51","MRK","9","51","51","Dìq ka pì ep i boh oe ta manoh, ep hatroq ti dabau”. ");
INSERT INTO hrebt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chuaq Jesus loh enh aih, trùh ta cròng Juđê, tŏc pah tau ka diac Jođan, mangai bàc tagop dabau trùh hòm ti haq, tiaq dèh ma khoe hmaq yôt, haq hi hnài wì. ");
INSERT INTO hrebt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ƀài mangai Pharisi lam haten bòch đòeq hu chaq trong bahlac haq: Mangai gucalô akhòh cađac mai? ");
INSERT INTO hrebt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","“Môise khoe thê pì qmang leq?” Haq bòch wì. ");
INSERT INTO hrebt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wì aih padreo bàu: Môise lòh mangai calô achìh moeq araq jàiq broq ƀò acan tacađac, khoe aih caqnaih deh cadrì loh lam. ");
INSERT INTO hrebt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chuaq Jesus padreo bàu: “Aih jao pì cadoq manoh Môise ma jah achìh ranenh aih. ");
INSERT INTO hrebt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mahaq enh jò baxèm broq plình crŏng taneh, Boc Plình broq moeq ngai calô, moeq ngai cadrì. ");
INSERT INTO hrebt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Aih ìq mangai calô majah talah dèh miq baq đòeq taqmùt dèh ti mai, ");
INSERT INTO hrebt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","wa baiq ngai hi wìa moeq xech akia. Pang aih, ŏng mai pi xài baiq hòm, mahaq khoe loh moeq xech akia. ");
INSERT INTO hrebt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Qmang aih, kon mangai ùh jah lah ƀài mangai leq Boc Plình ma khoe acop”. ");
INSERT INTO hrebt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jò oe ta hnim, mangai tiaq hŏc bòch hòm trong aih, ");
INSERT INTO hrebt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Haq padreo bàu: “Cabô cađac mai èh yŏc mangai cadrì qnoeq broq mai, haq khoe wìa mangai tango ka mangai cadrì tau, ");
INSERT INTO hrebt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","tàng joq mangai cadrì cađac dèh ŏng, yŏc ŏng qnoeq, aih hanoh loh mangai tango. ");
INSERT INTO hrebt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wì aràng kon qyoh trùh ti Chuaq Jesus dôq ka haq yŏc tì bèq wì qyoh, mahaq mangai tiaq hŏc lech ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jò Chuaq Jesus hnoq qmang aih, haq nòeh ka mangai tiaq hŏc, haq doe: “Dôq haq kon qyoh trùh ti au, apaq tàt wì haq, majah qmang aih diac Boc Plình am ƀài mangai leq ma tìah ka kon qyoh. ");
INSERT INTO hrebt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Joq qnàng au doe ka pì, mangai leq ùh đìh yŏc diac plình qmang kon qyoh qmat, haq aih ùh jò leq jah mùt ta diac plình”. ");
INSERT INTO hrebt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Khoe aih, haq caqmìn kon qyoh rai waiq am xôq ramot ka wì qyoh. ");
INSERT INTO hrebt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chuaq Jesus qnang hu loh lam, i moeq ngai cadàu tùh hacùn cràng enh ngèa ka haq, rai bòch: Ìh kô mangai hnài lem lình, au ep broq cleq đòeq hu jah kan rìh halình? ");
INSERT INTO hrebt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Chuaq Jesus doe: “Hagleq ìh majah doe au mangai lem lình? Ùh i mangai leq lem lình, enh gùng ka Boc Plình”. ");
INSERT INTO hrebt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ìh loq ƀài ranenh kô: “Apaq tango, apaq jêh đac mangai, apaq atùng, apaq yòng tapoch dech ka cabô, apaq qnùt bô, loq ta-iu dèh miq baq” ");
INSERT INTO hrebt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mangai aih padreo bàu: Mangai hnài, enh jò au oe qyoh nèh raq au khoe wèq dìq ƀài raneng kô. ");
INSERT INTO hrebt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chuaq Jesus ngan mangai aih rai ha-ŏch ka haq, Chuaq Jesus doe: “Ìh qnhòq i moeq yiniq hòm, hlài tech dìq dŏng kùng hang ìh, am ka mangai pa, aih èh ìh hi i kùng hang canaq oe ta diac Plình. Khoe aih hi lam tacô đòeq hu tiaq au”. ");
INSERT INTO hrebt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jò aih hadrò mangaih guradam aih hnoq qmòe kan haq mangò ka bàu aih, majah qmang aih, kùng hang haq bàc haraya. ");
INSERT INTO hrebt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chuaq Jesus ti ngan dudan rai doe ka mangai tiaq hŏc: “Mangai padrŏng ùh hlàu cleq ka jah mùt diac Plình”! ");
INSERT INTO hrebt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mangai tiaq hŏc hamàih ka bàu aih. Mahaq Chuaq Jesus doe hòm: “Wì kon! mangai padrŏng yo đeh kan đòeq mùt diac plình aih joq xa qnàng! ");
INSERT INTO hrebt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lŏcda mùt trom jrùm yi hlàu ka mangai padrŏng mùt diac Boc Plình.” ");
INSERT INTO hrebt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mangai tiaq hŏc hamàih ùh hnau hòm, wì hatuàng ti dabau: Tàng qmang aih èh mangai leq ma oe jah dèch? ");
INSERT INTO hrebt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chuaq Jesus ngan wì haq rai doe: “Yiniq aih kon mangai broq trong ùh jah, mahaq Boc Plình ùh qmang aih, Boc Plình broq jah rìm yiniq”. ");
INSERT INTO hrebt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Phiero anoe ka haq: Hacô nhèn khoe cađac rìm yiniq hu lam tiaq ìh. ");
INSERT INTO hrebt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Chuaq Jesus padreo bàu: “Joq qnàng au anoe ka pì, ùh i moeq ngai leq cađac dèh hnim, oh daq calô, oh daq cadrì, cađac miq baq hloe xam ƀài kon xam ruàng pràm, đòeq tiaq au xam trong Bàu lem, ");
INSERT INTO hrebt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","manòeq kô raq, qnhòng kô raq haq aih ma ùh jah yŏc hlài hloe ka hrinh yàng ƀòe hnim, oh daq calô, oh daq cadrì, miq kon, taneh ruàng, hloe xam ƀài kan nanxa xam kan rìh halình qnhòng atìq kô èh. ");
INSERT INTO hrebt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mahaq bàc ngai oe adroe loh ka atìq, mangai atìq loh ka adroe”. ");
INSERT INTO hrebt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jò Chuaq Jesus xam mangai tiaq hŏc qnang lam ti trong tŏc ta Jêrusalem, Haq lam adroe, ƀài mangai tiaq hŏc dìq jaq yùq, ƀài mangai lam tiaq hadai crè. Haq qnung moeq jàt baiq ngai tiaq hŏc lam crài ti haq hòm rai anoe ka wì loq yiniq padon trùh ka wì haq. ");
INSERT INTO hrebt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Haq doe: “Bèn qnang tŏc ta Jêrusalem, Kon Mangai kô èh mùt ta tì ƀài pajàu kàn xam ƀài mangai hnài ranenh. Wì aih hi taqmòq ka haq yiniq cachìt, wì aih aràng jao haq am ka wì enh gùng. ");
INSERT INTO hrebt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wì hi halê haq, cachôh ka haq, mahaq piq hi ònh èh haq hi rìh hlài.” ");
INSERT INTO hrebt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Atìq ka aih, Jaco xam Jon (kon Sêbeđe thia ajang Haq), wa doe: Mangai hnài, Ìh broq am ka ma yiniq ma enh bòch đeh. ");
INSERT INTO hrebt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Haq doe: “Chôp enh Au broq ka chôp cleq?” ");
INSERT INTO hrebt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wa aih pa dreo bàu: Jò leq Ìh jah kan ranhòm èh, ìh am ka ma moeq ngai haqngui apah qma, moeq ngai apah qngeo ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chuaq Jesus padreo bàu: “Chôp ùh qnì ka rađeh qnang bòch cleq, doe chrŏng au ôq, chôp ahlàt ôq, ƀaptem hu broq ka au, chôp ahlàt broq ùh?” ");
INSERT INTO hrebt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wa aih tèu: Ma hlàt. Chuaq Jesus anoe ka wa: “Doe chrŏng au ôq kô èh chôp hanoh ôq, ƀaptem hu broq ka au kô èh chôp hadai jah broq, ");
INSERT INTO hrebt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","mahaq hu hangui apah qma, apah qngeo ka au aih ùh xài au am, ajang aih đòeq da ƀài mangai leq nòe aih khoe padon dèh adroe”. ");
INSERT INTO hrebt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jò wì moeq jàt ngai tau tàng qmang aih, wì haq nòeh ka wa Jaco wa Jon. ");
INSERT INTO hrebt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chuaq Jesus creo ka wì haq oe qmoeq qmang ti dabau, haq doe: “Pì loq mangai ma broq gàu wì enh gùng, thê wì qnoeq iu rađeh, cwan kàn aih haq yo ka rađeh đòeq padit mangai qnoeq, ");
INSERT INTO hrebt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","pì ùh xài qmang aih, mahaq tapì mangai leq enh broq kàn, mangai aih ep broq hapŏng, ");
INSERT INTO hrebt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","mangai leq enh broq gàu, haq aih ep broq dìc rìm ngai. ");
INSERT INTO hrebt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Majah qmang aih, Kon Mangai trùh ùh xài đòeq wì patìh ka haq, mahaq đòeq haq patìh glòq ka wì, rai cađac kan rìh rađeh đòeq hu dèch bàc ngai”. ");
INSERT INTO hrebt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Khoe aih, Chuaq Jesus xam mangai tiaq hŏc trùh ta Jêrico. Jò wì haq hloe xam ƀài mangai bàc qnang loh enh aih, i moeq ngai lua mat yiniq haq Ƀatimê, (kon daTimê) qnang haqngui ti trong hu axìn. ");
INSERT INTO hrebt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jò haq tàng wì doe: aih Chuaq Jesus mangai Naxaret, haq drah creo cadêh: waiq Chuaq Jesus, Kon bùa Đawit, xa-och ka au diq! ");
INSERT INTO hrebt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bàc ngai tapoch hnap ka haq, thê haq chaq oe ma hatinh, mahaq haq ka creo tam yeo dêh hòm: Kon Đawit, xa-och ka au diq! ");
INSERT INTO hrebt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chuaq Jesus yòng jang aih rai doe: “Creo ka haq lam ajang kô”. Wì creo ka mangai ùh xau aih rai doe ka haq: Cajap manoh, yòng beq, Haq creo ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mangai lua mat aih lêh dèh eo enh gùng, tùh thia ajang Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chuaq Jesus bòch haq: “Ìh enh au broq ka ìh cleq?” Mangai lua mat aih padreo bàu: Rabi, au enh jah hnoq. ");
INSERT INTO hrebt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chuaq Jesus doe ka haq: “Lam beq! Kan lùi ìh khoe broq ìh brêh.” Tajòe hloe jò aih haq jah hnoq, haq hi lam tiaq ti Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jò khoe ten trùh Jêrusalem, tanòe plài Bêphajê xam plài Bêthani tajang ka wang Oliu, Chuaq Jesus thê baiq ngai tiaq hŏc, ");
INSERT INTO hrebt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Haq doe ka wa: “Mùt ta plài enh ngèa ka chôp, jò mùt ta aih hnoq moeq toq lùa qyoh wì kàt ta aih, qnhòq i cabô lah tŏc crŏng haq, chôp canaih haq khoe aih tiaq ahlài tacô ka au. ");
INSERT INTO hrebt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tàng i mangai leq loq bòch: Gleq ma jah broq qmang qmat? Chôp doe ka wì: Chuaq i yiniq waq, aih èh wì hi dôq chôp tiaq ahlài”. ");
INSERT INTO hrebt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wa aih hi lam, hnoq kon lùa qyoh qnang kàt enh gùng tajang ka trong qmang, wa hi lêh canaih. ");
INSERT INTO hrebt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Wì ma oe ta aih i qnah ngai oe ta aih bòch: Chôp caqnaih kon lùa qyoh qmat hu broq cleq? ");
INSERT INTO hrebt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wa aih padreo bàu qmang ka Chuaq Jesus khoe tanap, wì hi canaih wa lam. ");
INSERT INTO hrebt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wa tiaq ahlài kon lùa aih ka Chuaq Jesus, yŏc dèh eo hlèch enh crŏng lùa aih, khoe aih Chuaq Jesus hi tŏc enh crŏng. ");
INSERT INTO hrebt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bàc ngai lêh dèh eo hlèch ti trong lam, i qnah ngai loh ta ruàng goh hamenh long xap roc trong. ");
INSERT INTO hrebt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mangai lam adroe, mangai lam atìq dìq moeq bàu cadêh: Hôsana! Khòh manè ka Mangai trùh enh dalam ka yiniq Chuaq! ");
INSERT INTO hrebt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Xôq ramot am ka diac padon trùh kô èh, aih raq diac bùa Đawit, kan cadraq bèn! Hôsana oe ta Plình haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Chuaq Jesus mùt ta Jêrusalem, haq lam ta hnim kùh waiq. Haq ti ngan rìm yiniq dudan ta aih, jò mat mahì khoe haqneq, haq xam moeq jàt baiq ngai tiaq hŏc loh enh aih lam ta plài Bêthani. Long pŏc croh ");
INSERT INTO hrebt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sroq atìq, jò khoe loh enh plài Bêthani, aih Haq pangot. ");
INSERT INTO hrebt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hnoq enh hangai i moeq xèm long pŏc i hla, Haq lam ngan long aih i ka plì ùh, jò trùh haten ka xèm long hnoq toq hla, majah qmang aih ùh xài jò plì. ");
INSERT INTO hrebt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Haq tapoch ka long aih: “Pang kô èh pi i cabô oe kaq plì enh gè hòm.” Dìq dŏng mangai tiaq hŏc dìq tàng bàu aih. ");
INSERT INTO hrebt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jò trùh ta Jêrusalem, Haq mùt ta hnim kùh waiq, drùh qnoh ƀài mangai padro ta aih, blòq caƀŏng mangai ma halìh ƀac hloe xam gèq wì ma atech trù. ");
INSERT INTO hrebt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Haq ùh am cabô wê cleq jah lam pagat trong aih. ");
INSERT INTO hrebt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Khoe aih haq hnài wì: “Ajoq i bàu achìh, Hnim au jah creo hnim waiq khàn ka rìm taneh diac? Mahaq pì khoe broq haq loh pù ƀài mangai atùng.” ");
INSERT INTO hrebt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ƀài pajàu xam ƀài mangai hnài ranenh tàng bàu aih, hi chaq trong hu jêh cađac haq, wì ùh hùa ka haq, majah qmang aih dìq dŏng phù cròng mangai leq mangai meh hamàih đeh hra ka bàu haq hnài. ");
INSERT INTO hrebt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jò trŏc khoe ten clam, Chuaq Jesus xam mangai tiaq hŏc loh enh aih. ");
INSERT INTO hrebt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sroq atìq, jò lam trong aih, wì haq hnoq long pŏc khoe croh trùh ta riah. ");
INSERT INTO hrebt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Phiero hi hmàng hlài haq doe ka Chuaq Jesus, Rabi, Ìh ngan tau, long pŏc ìh tapoch ka haq hì nèh khoe croh. ");
INSERT INTO hrebt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Chuaq Jesus doe: “Thê pì i manoh lùi Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Au doe qnàng ka pì, tàng cabô doe ka bui wang kô: lam caqnìh rađeh ta diac raxìq beq, ta manoh haq aih ùh i kan rangòt, mahaq lùi troeq bàu rađeh ma khoe anoe, haq jah qmang dèh ka bàu. ");
INSERT INTO hrebt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Aih ìq au majah doe ka pì: Rìm yiniq pì bòch jò pì waiq khàn, drah lùi pì khoe jah, aih èh pì hijah yiniq aih. ");
INSERT INTO hrebt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jò pì yòng waiq khàn, tàng joq pì oe i yiniq cleq ùh hatroq ka cabô, drah cađac yiniq aih ka wì beq, aih èh Baq pì oe ta plình hanoh cađac da pì yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(*hset dùnh) Tàng pì qnhòq cađac da wì yiniq lui, Baq pì oe ta plình hadai qnhòq cađac da pì.” ");
INSERT INTO hrebt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chuaq Jesus xam mangai tiaq hŏc wìh ta Jêrusalem hòm, jò Chuaq Jesus qnang cadiang lam ta hamlang hnim kùh waiq, ƀài pajàu kàn, ƀài mangai hnài ranenh hloe xam ƀài gucraq thia ajang haq. ");
INSERT INTO hrebt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wì aih bòch: Ìh yŏc cwìang enh leq ma broq qmang kô? Cabô ma khoe thê ìh broq? ");
INSERT INTO hrebt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Chuaq Jesus padreo bàu: “Au hanoh bòch pì moeq bàu. Pì padreo bàu au, aih èh au hadai doe ka pì loq au yŏc cwìang enh leq hu broq ƀài trong kô. ");
INSERT INTO hrebt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ƀaptem da Jon aih loh enh Plình, loq loh enh kon mangai? Anoe ka au beq!” ");
INSERT INTO hrebt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wì aih hatuàng ti dabau, wì doe: Tàng joq bèn doe loh enh plình aih èh haq bòch bèn: Meh pì ma ùh lùi Jon? ");
INSERT INTO hrebt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mahaq tàng bèn doe: loh enh kon mangai? Wì ùh hùa ka mangai ta aih, majah qmang aih, mangai ta aih dìq lùi Jon aih mangai pajàu joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aih ìq wì haq majah hi doe ka Chuaq Jesus: Nhèn ùh qnì. Chuaq Jesus doe ka wì haq: “Au hadai ùh anoe ka pì loq au yŏc cwìang enh leq hu broq yiniq kô”. ");
INSERT INTO hrebt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Khoe aih, Chuaq Jesus hi tapoch alìah ka wì haq: “I mòeq ngai pìt mòeq wuàn plì nho, haq broq canàng dudan, taqne wuàn haq broq mòeq toq nòe đòeq padit yŏc diac plì nho, haq broq mòeq toq hapom ka haqnhèq, khoe aih, haq am ka wì patìh axong, èh cla haq lam ta gùng qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Trùh jò, cla haq thê dèh mòeq ngai hapŏng lam trùh ti ƀài mangai pìt nho, đòeq hu yŏc plì wì ma axon da haq. ");
INSERT INTO hrebt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mahaq, wì rùp jêh hapŏng aih, khoe qnat haq bròc tì dech. ");
INSERT INTO hrebt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Haq thê dèh hapŏng qnoeq hòm, mahaq wì blai gàu haq aih rai hanip broq ka haq dìq jaq camaih. ");
INSERT INTO hrebt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Haq thê hapŏng qnoeq hòm, wì jêh ca đac mangai aih, Haq thê bàc ngai qnoeq hòm trùh, qnah ngai wì blai, qnah ngai jêh cađac. ");
INSERT INTO hrebt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yàng atìq pulùch, haq i dèh mòeq ngai kon calô raq haq ma loq waq dèh dìq jaq, haq hi thê kon aih lam, cla haq hèm dèh: Yi laiq wì ma ùh iu kon au. ");
INSERT INTO hrebt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mahaq ƀài mangai pìt nho ta hatình ka dabau: Kô raq kon cla wì craq, mangai ma hu jah waq dŏng kùng hang, beq bèn jêh đac haq, aih èh kùng hang haq hi jah dŏng bèn. ");
INSERT INTO hrebt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wì hi rùp jêh cađac kon calô aih, khoe èh khwênh qnoh enh gùng ka wuàn plì nho. ");
INSERT INTO hrebt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Khoe aih cla wì craq wuàn nho broq qmang leq? Haq trùh hu jêh cađac dŏng ƀài mangai pìt nho aih, khoe èh yŏc wuàn aih am ka wì qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pì akhoe lah đŏc bàu kô ta hset hadròeh: “Hmo, ƀài mangai broq hnem ma ràih qnoh cađac, Khoe wìa hmo mùm hnim; ");
INSERT INTO hrebt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Boc Plình khoe broq qmang kô, Aih ajoq kan halac enh ngèa ka mat bèn?” ");
INSERT INTO hrebt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ƀài mangai pajàu kàn, ƀài mangaih hnài ranenh, xam ƀài gucraq, chaq trong hu rùp Chuaq Jesus, majah qmang aih wì loq bàu haq ma alìah aih anoe trùh wì. Mahaq wì pi lênh hùa ka ƀài mangai bàc ta aih, èh wì haq hi lam đac taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Atìq ka aih, wì thê ƀài bua da mangai Pharisi xam ƀài bua da Hêrot trùh ti Chuaq Jesus đòeq rùp haq ajang nòe bàu tapoch. ");
INSERT INTO hrebt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wì aih trùh ti haq rai doe: Mangai hnài, nhèn loq Ìh kô mangai taq atoq, ùh i yùq ka cabô, majah qmang aih ngan mangai, ìh ùh i ngan toq enh gùng, mahaq hnài trong Boc Plình tiaq bàu joq qnàng. Am thèq ka Sêsa aih troq loq ùh? Nhèn i ep am thèq ka sêsa? ");
INSERT INTO hrebt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mahaq Chuaq Jesus loq kan patìah wì aih, haq bòch: “Gleq pì ma ti àu chaq trong bahlac au? Drah qnàng ka au ngan moeq hliac ƀac beq”. ");
INSERT INTO hrebt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wì aràng ka haq moeq hliac ƀac, Haq bòch wì: “Qmù kô qmù ka cabô, yiniq dacabô?” Wì padreo bàu: Da Sêsa. ");
INSERT INTO hrebt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chuaq Jesus doe ka wì: “Padreo hlài da Sêsa yiniq cleq da sêsa, padreo hlài da Boc Plình yiniq cleq da Boc Plình.” Dìq ka wì hamàih deh hra ka bàu Haq. ");
INSERT INTO hrebt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mangai Sađusê, aih ƀài mangai ma doe ùh i ka kan rìh hlài, wì haq thia haten bòch Chuaq Jesus: ");
INSERT INTO hrebt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Wì doe: Mangai hnài! Môise i achìh ka nhèn ranenh rameh: Tàng moeq ngai tau, i oh daq haq cachìt, đòeq hlài dèh mai mahaq ùh i ka kon, mangai aih ep yŏc gucadrì hadrô aih, đòeq taqmot hlài caxi noe daq haq. ");
INSERT INTO hrebt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Manòeq kô wì oh daq aih i ta pèh ngai. Mangai ramua yŏc mai, khoe aih haq cachìt, ùh i ha kon. ");
INSERT INTO hrebt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mangai ma hatìa, yŏc mangai cadrì hadrô aih, khoe aih haq cachìt, hadai ùh i ka kon, èh mangai ma atìq hanoh qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dìq dŏng ka wì ta pèh ngai aih, ùh i mangai leq i kon. Pulùch, mangai cadrì aih hadai cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Trùh jò rìh hlài, taqne wì ta pèh ngai oh daq aih, mangai cadrì aih broq mai cabô? Majah qmang aih dìq dŏng ka wì haq, hanoh khoe yŏc gucadrì aih broq mai. ");
INSERT INTO hrebt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chuaq Jesus padreo bàu: “Ma ùh joq pì khoe hèm hwang? Majah qmang aih pì ùh qnì ka bàu Hset dadròeh xam kan itai Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Jò mangai cachìt rìh hlài, wì ùh i yŏc mai, hadai ùh yŏc ŏng, mahaq ƀài mangai rìh hlài aih rìh tìah ka ƀình plình oe ta diac plình. ");
INSERT INTO hrebt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Anoe trùh ƀài mangai cachìt rìh hlài aih, ta hset Môise i achìh bàu Boc Plình capoch ka haq tanòe xèm yila rameh: Au kô Boc plình da Apraham, Boc Plình da Ysac, Boc Plình da Jacôp, pì ma qnhòq đŏc? ");
INSERT INTO hrebt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Haq ùh xài Boc Plình da ƀài mangai cachìt, mahaq Boc Plình da ƀài mangai rìh! Pì qmat joq khoe hèm lìq”. ");
INSERT INTO hrebt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","I mòeq ngai hnài ranenh tàng bàu wì tarahen, haq hnoq Chuaq Jesus tèu bàu dìq jaq rabiaq, haq aih thia ka haten hu bòch: Dìq dŏng ka ƀài ranenh, ranenh maleq ma yeo kàn dŏng? ");
INSERT INTO hrebt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Chuaq Jesus padreo bàu: “Kô ranenh ma yeo kàn: Dìq ka mangai Isorali tamàng kô! Chuaq aih Boc Plình da bèn, i moeq Chuaq raq. ");
INSERT INTO hrebt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Loq waq ka haq dìq ka cliac, dìq ka mahua yiang, dìq ka manoh, dìq ka padren hiwa. ");
INSERT INTO hrebt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kô ranenh ma atìq, thê loq waq ka magai haten hatìa qmang ka cla pì. Ùh i ka ranenh leq yeo kàn ùh hnau ka baiq ranenh kô”. ");
INSERT INTO hrebt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mangai hnài ranenh doe: Ìh anoe troq joq qnàng! I mòeq Boc Plình raq, enh gùng ka haq pi i ma qnoeq hòm; ");
INSERT INTO hrebt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","joq ep loq waq ka Haq dìq ka cliac, dìq ka manoh, dìq ka padren hiwa, rai loq waq ka mangai haten hatìa tìah dèh cla, aih lem ùh hnau ka tadreo bùh, ùh hnau ka hang tadreo ma qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chuaq Jesus hnoq haq aih padreo bàu qmang ka mangai rabiaq, Chuaq Jesus doe: “Ìh pi hangai ka diac Boc Plình”. Pang aih pi i cabô oe hùa bòch Haq cleq hòm. ");
INSERT INTO hrebt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jò Chuaq Jesus yòng hnài wì tanòe hnim kùh waiq, haq bòch: “Hagleq ƀài mangai hnài ranenh doe Christ aih kon Đawit? ");
INSERT INTO hrebt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cla Đawit jò Yiang Hadròeh mahno, haq doe: Chuaq khoe doe ka Craq au: Hangui enh pah qma au, trùh jò au roh ƀài mangai taƀlêq ka ìh enh qneq ka jènh ìh.” ");
INSERT INTO hrebt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Cla Đawit khoe creo ka Haq: Craq au! aih wìa ka haq oe broq kon Đawit qmang leq? Ƀài mangai ma bàc ta aih dìq jaq enh tamàng bàu haq rai lem bùi. ");
INSERT INTO hrebt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jò hnài wì, Chuaq Jesus doe: “Ngan oq, pì ep wèq rađeh ma khoe ka ƀài mangai hnài ranenh, ƀài mangai enh toq caxùnh eo yôh lam bayràt, enh waq toq mangai qnoeq kùh gàu ka rađeh taqne nòe padro, ");
INSERT INTO hrebt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","tanòe hnim tagop xam nòe acaq yiniang enh hangui toq nòe ma rahù, ");
INSERT INTO hrebt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","wì haq lonh apom hnim mangai cadrì hadrô, mahaq broq dèh waiq khàn waq ka yôh, trùh jò hadrah wì aih èh ep pòq kan baxa yeo trap hòm. ");
INSERT INTO hrebt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Chuaq Jesus hangui tangèa ka nòe đòeq tah ƀac, rai ngan wì ta aih tah dèh bac qmang leq. Bàc ngai padrŏng tah qmòe cabàc. ");
INSERT INTO hrebt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mahaq i moeq ngai gucadrì hadrô pa, lam tah baiq hliac ƀac, ");
INSERT INTO hrebt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chuaq Jesus creo dèh ka ƀài mangai tiaq hŏc trùh, haq doe: “Joq qnàng au anoe ka pì, mangai cadrì hadrô kô haq pa, mahaq khoe tah yeo bàc ùh hnau dìq dŏng ka wì qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Majah qmang aih, ƀài mangai qnoeq yŏc toq rah đòeq tah tacô, yàng da mangai hadrô kô, haq dìq jaq pa, mahaq haq khoe tah dìq dŏng dèh hliac ƀac đòeq huban rađeh.” ");
INSERT INTO hrebt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jò Chuaq Jesus bu loh enh hnim kùh waiq, i mòeq ngai tiaq hŏc doe ka Haq: Ìh ngan tau, bòe hmo ta hnim meh lem dàng leq! ");
INSERT INTO hrebt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Chuaq Jeus padreo bàu: “Ìh hnoq ƀài hnim kàn kô qmòh? Kô èh pi i moeq toq hmo leq tacô oe jah raxon enh qnhèq ka hmo qnoeq hòm, dìq dŏng taclìh taqneq.” ");
INSERT INTO hrebt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jò Chuaq Jesus hangui ta wang Oliu, tajang ka ngèa hnim kùh waiq, jò ùh i ka mangai qnoeq, Phiero, Jaco, xam Jon thia bòch haq: ");
INSERT INTO hrebt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ìh anoe ka nhèn loq đeh diq, jò leq men loh ƀài yiniq aih? Èh i cleq patô am ka nhèn hu canau khoe trùh jò pagêh? ");
INSERT INTO hrebt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chuaq Jesus doe ka wì: “Ngan oq! Paq dôq cabô trùh qnùt pì. ");
INSERT INTO hrebt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","I bàc ngai yŏc yiniq au đòeq trùh ta pì, wì doe: Au kô raq Christ! Èh wì qnùt bàc ngai. ");
INSERT INTO hrebt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jò pì tàng kan tajêh poh, pì hìa trùh trong tablah, ta manoh pì ùh dùh lèt. Ƀài yiniq aih ep trùh, mahaq hì pulùch qnhòq trùh. ");
INSERT INTO hrebt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gùng tamoe kô yòng taƀlêq ka gùng tamoe tau, Diac kô yòng taƀlêq ka Diac tau. Bàc nòe taneh loh ka ralàng, bàc nòe loh ka pangot hrah. Aih bu diang kan baxèm jìq hauang. ");
INSERT INTO hrebt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pì ep wèq rađeh, wì loq rùp qnoh pì tanòe hadrah rai blai pì tanòe hnim tagop. Jao au kô èh pì majah ep yòng enh ngèa ƀài cwan kàn, ƀài bùa, đòeq hu panhìn ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mahaq adroe dìq dŏng, Bàu lem ep waq ka jah anoe jàp ka mangai òeq. ");
INSERT INTO hrebt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jò wì rùp qnong pì, apaq yùq đeh ep anoe cleq, mahaq hi trùh dèh jò, pì toq tapoch tiaq bàu ma am ka pì, aih ùh xài cla pì tapoch dèh bàu, mahaq Yiang Hadròeh tapoch. ");
INSERT INTO hrebt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jò aih èh, oh daq blòq dèh oh daq ka cachìt, baq blòq dèh kon, ƀài kon taƀlêq dèh ka miq baq, waq ka wa cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jao au kô èh dìq ka phù cròng wiang git ka pì, mahaq mangai leq ma cajap manoh trùh lùch haq aih èh ma jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jò pì hnoq kan raliang, kan pada broq tanòe ma ùh khòh broq (cabô đŏc ep loq), jò aih mangai leq oe ta gùng Juđê drah cadàu tŏc ta wang, ");
INSERT INTO hrebt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","mangai leq oe ta kùa po hnim ùh dùh loh dèh, ùh dùh mùt ta hnim hu qnhon qnoh dahwèq, ");
INSERT INTO hrebt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","mangai leq oe ta gùng apaq wìh hlài hu yŏc eo. ");
INSERT INTO hrebt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jò aih, haƀo ka ƀài mangai gucadrì qnang oe jiang hloe xam ƀài magai kon oe ùq! ");
INSERT INTO hrebt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Drah waiq khàn dôq ƀài yiniq aih ùh hìaq trùh glàm jò ralìm. ");
INSERT INTO hrebt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Majah qmang aih ƀài hì aih i kan ranàc kàn, enh jò Boc Plình baxèm broq plình crŏng taneh trùh manòeq qnhòq lah i qmang aih, trùh hloe ta atìq kô èh dua ùh i qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tàng joq Boc Plình ùh pot qnah ƀài hi aih dôq haq yi đêq, pi i cleq ma oe rìh. Mahaq taiq ƀài mangai haq ma khoe ràih haq majah khoe broq ka ƀòe hi aih yi đêq. ");
INSERT INTO hrebt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jò aih tàng joq i cabô doe ka pì: Hacô Christ oe ta kô, ùh meh wì doe: Haq oe ta tau, pì apaq lùi. ");
INSERT INTO hrebt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bàc Christ patìah, pajàu patìah trùh, broq bàc trong halac, tàng majah wì haq enh padô qmòe mangai ma khoe jah ràih raq. ");
INSERT INTO hrebt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ngan oq wèq rađeh, Au khoe anoe ka pì loq adroe. ");
INSERT INTO hrebt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Oe ta ƀài hì aih, atìq ka kan nanxa, mat mahì loh ka clam, mat khê pi sreo qngah hòm, ");
INSERT INTO hrebt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ƀài halang ta trŏc taclìh ka rađeh, chac plình hanoh loh ka dalàc. ");
INSERT INTO hrebt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jò aih wì ma hi hnoq Kon Mangai trùh enh yùc plình xam kan cwiàng itai kàn, kan ranhòm kàn. ");
INSERT INTO hrebt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Haq hi thê dèh ƀình plình trùh gop ƀài mangai khoe jah ràih enh pôn ƀè ta crŏng taneh, enh caqnàm plình kô trùh caqnàm plình tau. ");
INSERT INTO hrebt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tamàng rai hŏc bàu alìah trùh long pŏc: Jò hamenh haq bu plôh hamŏng loh ramot, aih pì loq khoe ten trùh jò padrang. ");
INSERT INTO hrebt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hanoh qmang aih diq, jò pì hnoq ƀài yiniq aih trùh, pì loq, Kon Mangai trùh khoe haten, haq oe ajang trong qmang. ");
INSERT INTO hrebt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Joq qnàng au doe ka pì: caxi noe kô ùh hnhung adroe ka ƀài yiniq aih trùh. ");
INSERT INTO hrebt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Plình crŏng taneh kô èh hnhung, mahaq bàu au ùh jò leq hnhung. ");
INSERT INTO hrebt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mahaq hì mang jò aih, ùh i cabô loq, yac ka ƀình plình oe ta plình, yac ka Kon, moeq ngai cla Baq raq ma loq dèh. ");
INSERT INTO hrebt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Thê pì wèq ra đeh, pì hmàng hamang oq, majah qmang aih pì ùh qnì jò leq yiniq aih trùh. ");
INSERT INTO hrebt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yiniq aih tìah ka moeq ngai lam hangai, Haq cađac dèh hnim, thê deh ƀài hapŏng broq moeq ngai moeq yiniq, haq hanoh i thê mangai rìu gòm qmang. ");
INSERT INTO hrebt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Qmang aih, pì ep rìu gòm, majah qmang aih pì ùh loq cla wì craq hnim hlài jò leq, jò mahì wìh, jò qne mang, jò ia rŏng, loq jò bu qngah, ");
INSERT INTO hrebt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","beq rayeq cla wì craq hlài hlaiq, glàm jò pì qnang oe raq kùi. ");
INSERT INTO hrebt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Bàu au anoe ka pì kô, au hadai anoe ka bàc ngai qnoeq: Hmàng hamang oq!”. ");
INSERT INTO hrebt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Baiq hì adroe ka hì ramènh pan cwa xam ramènh acaq ƀênh ùh wàt blo, ƀài pajàu kàn xam ƀài mangai hnài ranenh hatình ka dabau chaq trong rùp Chuaq Jesus ka hlèp hu jêh cađac. ");
INSERT INTO hrebt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wì doe: ùh khòh broq yiniq kô ta hì ramènh, yùq ka phù cròng loq loh ka tagruàng. ");
INSERT INTO hrebt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jò Chuaq Jesus oe ta plài Bêthani, ta hnim Simôn, mangai bacùn, haq qnang hangai acaq, i moeq ngai gucadrì trùh, tì haq wê moeq toq cabi broq xam hmo ngŏc, enh dalam tah bình dàu xua thùm canaq bac, haq tùq padah cabi dàu aih, èh ùc dàu xua thùm ta gàu Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","I biaq ngai ta aih nòeh ka haq, wì anoe ka dabau: Hagleq maloq racaih ka dàu canaq qmang meh? ");
INSERT INTO hrebt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tech dàu qmat jah loe piq hrinh đoniê, yŏc bac aih ajoq jah am ka mangai pa? Khoe ka aih wì tapoch ka mangai gucadrì aih oe loh cleq. ");
INSERT INTO hrebt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mahaq Chuaq Jesus doe ka wì: “Apaq troq haq, hagleq pì ma tapoch ka haq? Haq qmat khoe broq moeq yiniq lem ka au. ");
INSERT INTO hrebt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Majah qmang aih yac ka jò leq dua i mangai pa oe dudan ka pì, pì enh broq trong lem ka wì aih jò leq ma ùh jah, mahaq au ùh i oe yôt ti pì. ");
INSERT INTO hrebt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mangai gucadrì kô khoe broq trong haq jah broq. Haq xùt dàu ta chac au adroe đòeq hu padon catùh hanang au. ");
INSERT INTO hrebt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Joq qnàng au doe ka pì: Dìq ka crŏng taneh kô, waq toq nòe leq Bàu Lem jah hnài, trong haq ma khoe broq kô èh hadai jah ràu qnoh, đòeq hu hmàng trùh haq. ");
INSERT INTO hrebt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Taqne wì moeq jàt baiq ngai, i moe ngai yiniq haq Juda Icariôt, lam trùh ta ƀài mangai pajàu kàn đòeq hu tech Chuaq Jesus ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tàng bàu aih wì aih dìq jaq manè, wì tèu bàu am ka haq ƀac. Pang aih Juda rap gòm toq jò leq bu taqnàih, haq hi rùp Chuaq Jesus am ka wì. ");
INSERT INTO hrebt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hì baxèm da ramènh kaq ƀênh ùh wàt blo, aih hì jêh kon trìu broq tadreo ka ramènh Pan cwa, ƀài mangai tiaq hŏc bòch haq: Ìh enh nhèn lam padon ka ìh kaq ramènh Pan cwa taleq? ");
INSERT INTO hrebt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Haq thê baiq ngai tiaq hŏc lam, haq tanap: “Mùt ta plài qmat, chôp hnoq moeq ngai qnang kôi abôq diac, chôp tiaq haq aih. ");
INSERT INTO hrebt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Haq aih mùt hnim leq, chôp doe ka cla wì craq hnim aih: Mangai hnài bòch: “Aleq nòe aniang au hu acaq ramènh Pan cwa dèh ti mangai tiaq hŏc? ");
INSERT INTO hrebt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Haq aih hi patô ka chôp nòe aniang anòh oe enh qnhèq, rìm yiniq ta aih khoe palauq qmòe. Padon ka bèn ta aih èh.” ");
INSERT INTO hrebt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wa mangai tiaq hŏc hi lam, wa mùt ta plài, glàm tìah ka bàu troeq bàu Haq thê, wa hi padon ramèng Pan cwa. ");
INSERT INTO hrebt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Xèq aih, Jesus sam ƀài mangai tiaq hŏc trùh ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jò dìq dŏng wì haq qnang hangui acaq, Haq doe “Au anoe joq qnàng ka pì, i moeq ngai oe taqne pì kô, haq acaq moeq qmang ka au mahaq haq blòq đac au.” ");
INSERT INTO hrebt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ƀài mangai tiaq hŏc mangò pi cajaq, khoe ka maleq trùh maleq, wì bòch haq: A hìaq au? ");
INSERT INTO hrebt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chuaq Jesus doe: “Moeq ngai oe taqne pì moeq jàt baiq ngai, mangai ma chùq bênh pajùm ti au ta doe kô. ");
INSERT INTO hrebt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Majah qmang aih Kon mangai kô èh loh lam, tìah ka bàu khoe achìh ka haq, mahaq haƀo ka mangai ma blòq haq, apaq ha-uang qnoh haq aih xan ka ùh hnau hòm”. ");
INSERT INTO hrebt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jò qnang acaq, Chuaq Jesus yŏc ƀênh, manè apôi, khoe aih haq goh, qnèp dèh ka ƀài mangai tiaq hŏc, rai doe: “Drah yŏc beq, kô chac au.” ");
INSERT INTO hrebt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Haq rùp doe chrŏng, manè apôi, khoe èh am dèh ka ƀài mangai tiaq hŏc, maleq diq ôq enh chrŏng aih. ");
INSERT INTO hrebt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Haq doe ka wì: “Kô mahim au, mahim da kan tajao dahrôq qnoh ka bàc ngai. ");
INSERT INTO hrebt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Au anoe joq qnàng ka pì, au pi ôq plì diac nho kô hòm, trùh hì au ôq plì nho niu oe ta diac Boc Plình.” ");
INSERT INTO hrebt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jò khoe calêu hset hadròeh, Chuaq Jesus xam ƀài mangai tiaq hŏc lam tŏc ta wang Ôliu. ");
INSERT INTO hrebt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chuaq Jesus doe ka mangai tiaq hŏc: “Dìq ka pì tacro dŏng, majah qmang aih i bàu khoe achìh: Au hi jêh cla mangai ban trìu, trìu haq hi paclac dìq dŏng. ");
INSERT INTO hrebt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mahaq jò au rìh hlài èh, au lam trùh ta Galili adroe ka pì.” ");
INSERT INTO hrebt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phiero haq doe qmòe: Yac ka dìq dŏng rìm ngai tacro, au dua ma ùh. ");
INSERT INTO hrebt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Chuaq Jesus padreo bàu: “Joq qnàng au anoe ka ìh, hì kô, qmang kô raq, adroe ka ia rŏng baiq yàng, ìh khoe piq yàng hangah đeh ùh qnì ka au.” ");
INSERT INTO hrebt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mahaq dua Phiero doe: Yac ka au ep cachìt ti ìh, dua au ùh hangah đeh ùh qnì ka ìh. Dìq dŏng ka wì qnoeq hadai anoe moeq bàu qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Khoe aih, wì lam trùh moeq nòe, ta aih wì creo Gêtsemane, Chuaq Jesus doe ka ƀài mangai tiaq hŏc: “Pì hangui ajang kô, gòm au waiq khàn.” ");
INSERT INTO hrebt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Haq qnung Phiero, Jaco, xam Jon tiaq haq, aih èh Haq hi loh ka cadròt rai mangò. ");
INSERT INTO hrebt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Haq doe ka wì piq ngai: “Mahua yiang au mangò haraya trùh cachìt, pì oe tacô, hmàng rìu gòm oq.” ");
INSERT INTO hrebt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Khoe èh, Haq lam yeo hangai toq ƀiaq, bla op rađeh ta taneh rai waiq khàn rameh tàng jah, dôq jò kô cwa đac dŏng khoe ka rađeh. ");
INSERT INTO hrebt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Haq creo: “Aba, waiq Baq, rìm yiniq Ìh broq jah dìq dŏng, au waiq Ìh dèch đac doe chrŏng kô ma khoe ka au, mahaq apaq tiaq manoh au enh, tiaq manoh Baq ma enh.” ");
INSERT INTO hrebt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Khoe aih, Haq wìh hlài, hnoq piq ngai khoe kùi, haq doe ka Phiero: “Simôn, ìh kùi qmòh! Moeq jò ìh rìu ma ùh jah? ");
INSERT INTO hrebt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Rìu rai waiq khàn beq, dôq pì ùh hìaq taclìh ta kan padô aluàn, manoh aih enh raya mahaq chac aih ùh nèn”. ");
INSERT INTO hrebt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Haq lam hòm, rai waiq khàn qmang ka yàng adroe. ");
INSERT INTO hrebt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Haq tawìh hlài, hnoq mangai tiaq hŏc oe raq kùi, majah qmang aih mat wì haq pi jah tablèch qmòe, wì loh ka pi qnì tèu haq mang leq. ");
INSERT INTO hrebt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Haq tawìh hlài yàng piq, doe ka ƀài mangai tiaq hŏc: “Manòeq kô pì oe raq kùi rai padài qmòh! Hêq, kô khoe trùh jò, Kon Mangai oe toq ma hì mùt ta tì kŏng ƀài mangai broq dù. ");
INSERT INTO hrebt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yòng beq! Hatau, mangai ma blòq au trùh khoe ten”. ");
INSERT INTO hrebt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Haq oe raq anoe, tajòe qmòe, Juđa mangai ma hadai oe ti wì moeq jàt baiq ngai tiaq cla khoe trùh, lam moeq qmang ti haq i bàc ngai wê chang xam ƀài long dùi, wì aih trùh enh nòe ƀài pajàu kàn, ƀài mangai hnài ranenh, enh wì gucraq. ");
INSERT INTO hrebt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mangai ma blòq Chuaq Jesus, khoe tanap ka wì qmang kô: Au hìp mangai leq, mangai aih raq, pì rùp qnung ma rabiaq oq. ");
INSERT INTO hrebt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Qmang aih, jò bu trùh Juda thia ka haten ka Chuaq Jesus, haq doe: Rabi! khoe aih haq hìp Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wì aih hi rùp Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","I mòeq ngai oe ten aih, dot qnoh pla chang yôh, jêh hapŏng pajàu kàn, koh taclìh hla don mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chuaq Jesus tapoch ka wì: “Pì wê chang wê long dùi lam rùp au tìah ka mangai atùng. ");
INSERT INTO hrebt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Rìm hì au oe taqne pì, hnài ta nòe hnim kùh waiq, gleq pì ùh rùp au? Mahaq yiniq kô loh qmang kô đòeq xìt ka bàu Hset hadròeh”. ");
INSERT INTO hrebt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jò aih rìm ngai khoe cadàu amot, cađac dŏng haq. ");
INSERT INTO hrebt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","I mòeq ngai radam lam tiaq Chuaq Jesus, haq taqmàn rađeh xi moeq blah mù briang, jò wì rùp haq. ");
INSERT INTO hrebt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Haq cađac hloe dèh mù briang, cadàu qmòe rahòng. ");
INSERT INTO hrebt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wì aràng Chuaq Jesus trùh nòe pajàu haqnhèq, ƀài mangai pajàu kàn i dìq ta aih, ƀài gucraq, ƀài mangai hnài ranenh hadai tagop ti dabau ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phiero tiaq Chuaq Jesus, haq ti tayoe enh hangai, trùh tanòe hamlang hnim pajàu haqnhèq. Haq hangui ti ƀài mangai lình rai qnhìa ùnh pajùm ti wì ta aih. ");
INSERT INTO hrebt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ƀài pajàu kàn, xam dìq ka craq hadrah wiang chaq trong hu tablêq ka Chuaq Jesus, đòeq hu jah jêh đac haq, mahaq wì haq chaq ùh loh. ");
INSERT INTO hrebt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bàc ngai wiang yòng tapoch qmùt ka haq, mahaq bàu wì aih tapoch ùh tacap ka dabau. ");
INSERT INTO hrebt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Atìq ka aih i ƀiaq ngai yòng tapoch dech ka haq: ");
INSERT INTO hrebt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","wì doe: Nhèn i tàng haq doe: Kô èh au raliang cađac hnim kùh waiq tì kŏng kon mangai ma khoe broq kô, khoe aih piq hì au broq ònh hnim kùh waiq qnoe, ùh xài broq xam tì kŏng kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mahaq bàu kô, dua wì haq tapoch ùh hatroq ka dabau. ");
INSERT INTO hrebt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Khoe aih, pajàu haqnhèq yòng enh ngìa wì aih, haq bòch Chuaq Jesus: Ìh ùh tèu hlài moeq nà bàu cleq trong wì ma tapoch ka ìh qmòh? ");
INSERT INTO hrebt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mahaq Chuaq Jesus oe hatinh, ùh tèu mòeq nà bàu. Mangai pajàu haqnhèq bòch hòm: Ìh qmat Christ, kon Boc Plình ma khòh manè apôi joq ùh? ");
INSERT INTO hrebt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chuaq Jesus padreo bàu: “Joq Au raq! atìq èh pì hi hnoq Kon Mangai hangui apah qma ka Boc Plình dìq jaq haqnhèq i cwìang itai, hangui taqne yùc plình đòeq loh ta crŏng taneh”. ");
INSERT INTO hrebt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jò aih, mangai pajàu haqnhèq hic dèh eo rai doe: Bèn oe ep chaq dèh yiniq qnoeq hòm? ");
INSERT INTO hrebt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pì akhoe tàng bàu haq ùh hòq qmòe ka Boc Plình? Pì hèm qmang leq? Rìm ngai doe: Haq qmat troq ka cachìt. ");
INSERT INTO hrebt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","I ngai cachôh ka Chuaq Jesus, srùp hadrò haq, rai tùc rai doe ka haq: Tapoch pajàu beq. Ƀài lình yŏc long tong haq. ");
INSERT INTO hrebt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Phiero qnang hangui ta hamlang, i moeq ngai gucadrì hapŏng pajàu kàn trùh jang aih, ");
INSERT INTO hrebt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","hnoq Phiero oe hangui qnhìa ùnh, haq chrìh ka haten khoe èh haq doe: Ìh hadai oe moeq qmang ti Jesus, mangai Naxaret. ");
INSERT INTO hrebt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mahaq Phiero hangah: Au ùh qnì, hadai ùh loq tàng ìh anoe cleq. Khoe aih haq yòng loh enh gùng ka hamlang, ia hi rŏng. ");
INSERT INTO hrebt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mangai hapŏng cadrì aih hnoq haq, doe hòm ka wì ta aih: Mangai kô hadai bua wì tau raq. ");
INSERT INTO hrebt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mahaq Phiero hangah hòm. Moeq ahyàc hòm, wì ma oe ta aih doe ka Phiero: Hi loq ka ìh moeq bua ti wì tau, majah qmang aih ìh hadai mangai Galili. ");
INSERT INTO hrebt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Phiero hapah rai doe: Joq au ùh lòm canau ka mangai ìh ma anoe aih! ");
INSERT INTO hrebt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Adrình hloe jò aih, ia hi rŏng yàng baiq, Phiero hmàng hlài ka bàu Chuaq Jesus khoe anoe adroe ka rađeh: Adroe ka ia rŏng baiq yàng, Ìh piq yàng hangah đeh ùh qnì ka au. Hèm ka bàu aih, haq toq moe. ");
INSERT INTO hrebt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bu qngah, ƀài pajàu kàn hatình ti ƀài gucraq, ƀài mangai hnài ranenh xam dìq ka mangai oe ta hnim hadrah, jò khoe kàt wì hi qnung Chuaq trùh ka Philat. ");
INSERT INTO hrebt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Philat bòch haq: Ìh kô raq bùa da mangai ùh xài? Chuaq Jeus tèu bàu: Wop qmang ka bàu aih.” ");
INSERT INTO hrebt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ƀài mangai pajàu kàn ta qmòq ka haq bàc trong. ");
INSERT INTO hrebt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Philat bòch hòm: Ìh ùh tèu moeq nà bàu cleq qmòh? Ngan! Wì ta qmòq ka ìh bàc trong! ");
INSERT INTO hrebt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mahaq Chuaq Jesus dua pi tèu tam moeq bàu cleq hòm, Philat loh ka hamàih. ");
INSERT INTO hrebt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Khoe hmaq, rìm hanam trùh hì ramènh Pan cwa cwan caqnaih moeq ngai broq yiniq lui loh enh hnim tù, tiaq bàu wì bòch. ");
INSERT INTO hrebt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jò aih i moeq ngai yiniq haq Banaba, wì clêh pajùm ti ƀài mangai yòng tablêq ka chênh phù, majah qmang aih jò yòng tablêq, wì haq i jêh đac mangai. ");
INSERT INTO hrebt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mangai Juđa trùh, wì haq bòch Philat caqnaih ka wì haq moeq ngai qmang hmaq caqnaih rìm hanam. ");
INSERT INTO hrebt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Philat padreo bàu: Pì enh au caqnaih bùa Juđa ka pì ùh? ");
INSERT INTO hrebt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Majah qmang aih Philat loq wì mangai pajàu kàn majah rùp Chuaq Jesus aih jao wì tajìq ka haq. ");
INSERT INTO hrebt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mahaq ƀài pajàu kàn basrùq mangai Juđa bòch Philat caqnaih Banaba ka wì haq. ");
INSERT INTO hrebt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Philat bòch hòm: Tàng qmang aih manòeq kô pì enh au broq qmang cleq ka mangai pì ma doe haq Bùa mangai Juđa? ");
INSERT INTO hrebt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wì cajiah cadêh: Drah tiang haq talong pagat! ");
INSERT INTO hrebt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Philat doe ka wì: Mahaq mangai kô khoe broq cleq ma dù? Kiang wì cachech cadêh ùh hnau hòm: Tiang đình haq talong pagat! ");
INSERT INTO hrebt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Philat enh broq lem ka manoh mangai Juđa, haq hi caqnaih Banaba, èh thê wì blai Chuaq Jesus, khoe aih dôq wì qnung Chuaq Jesus lam tiang đình talong pagat. ");
INSERT INTO hrebt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ƀài lình aràng Chuaq Jesus mùt ta blùang kàn, aih nòe đòeq hu hadrah, creo dìq ka lình ta aih tagop ti dabau. ");
INSERT INTO hrebt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wì paclùm ka haq moeq blah eo gòh, wì tênh moeq toq cadoh yila pacôi ta gàu haq, ");
INSERT INTO hrebt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","wì tapoch ka Chuaq Jesus: Waiq bùa Juđa! ");
INSERT INTO hrebt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wì yŏc long dùi tong gàu haq, cachôh ka haq rai hacùn cràng kùh waiq haq, wì broq qmang aih bàc yàng. ");
INSERT INTO hrebt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Khoe ka wì halê do ka haq qmang aih, wì lêh đac eo gòh, caxùnh hlài eo da cla haq, khoe aih aràng haq lam hu tiang đình talong pagat. ");
INSERT INTO hrebt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","I mòeq ngai Siren, yiniq haq Simôn, baq da wa Alet-san-đo xam Ruphu, hlài enh ruàng, lam trong aih, wì rùp haq thê haq xùi long pagat. ");
INSERT INTO hrebt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wì qnung Chuaq Jesus trùh nòe go wì ma creo Gôgotha (bàu aih la cadôh gàu). ");
INSERT INTO hrebt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wì am ka haq ôq alac clai pajùm ka jan long xua thùm, mahaq haq ùh waq ôq. ");
INSERT INTO hrebt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Khoe ka tiang đình Haq talong pagat, wì ta axong ka dabau eo yôh haq, wì pàih panàih đòeq ngan maleq jah waq yiniq cleq. ");
INSERT INTO hrebt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jò wì tiang đình haq, aih bu hachìn jò di sroq. ");
INSERT INTO hrebt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Capiac long ban qyoh enh gàu long pagat, wì achìh bàu đòeq taqmòq yiniq lui ka haq: BÙA MANGAI JUDA. ");
INSERT INTO hrebt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","I baiq ngai atùng wì hadai tiang đình wa aih ti haq, mòeq ngai talong pagat apah qma ka Haq, moeq ngai talong pagat apah qngeo ka haq. (I qnah hset noeq tam brong) ");
INSERT INTO hrebt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","“Qmang aih wì khoe alùh haq pajùm ka ƀài mangai dù.” ");
INSERT INTO hrebt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ƀài mangai lam pagat trong aih halê do haq, wì ngù ngìu gàu doe: Ùih! Ìh mangai doe đeh raliang cađac hnim kùh waiq, piq hì broq ònh hi gêh, ");
INSERT INTO hrebt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","doeh rađeh, loh enh long pagat qmat beq. ");
INSERT INTO hrebt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ƀài mangai pajàu kàn xam mangai hnài ranenh hadai ta anoe ka dabau qmang aih, wì halê haq qmang aih: Haq doeh mangai qnoeq mahaq doeh rađeh ùh jah! ");
INSERT INTO hrebt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aleq! Christ bùa Isorali, loh enh long pagat qmat beq, dôq nhèn hnoq, aih èh nhèn hu lùi. Wa baiq mangai wì ma tiang đình ti haq hadai halê haq. ");
INSERT INTO hrebt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","I kan clam cluiq jàp dŏng gùng aih, enh qne hì trùh piq jò di xèq. ");
INSERT INTO hrebt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Trùh piq jò di xèq, Chuaq Jesus creo bàu dêh: “Ê-lo-i, Ê-lo-i, lam-ma-sa-bat-ta-ni.” Bàu aih rameh: Boc Plình au, Boc Plình au. Hagleq Ìh majah cađac au? ");
INSERT INTO hrebt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","I wì ma yòng ta aih, wì doe: Tamàng aih, Haq qnang creo ka Êli. ");
INSERT INTO hrebt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","I mòeq ngai oe ta aih cadàu yŏc capaih chùq ta diac jòq, đòeq ajang goe long dèch am ka haq ôq rai doe: Dôq haq! Đòeq bèn ngan Êli i trùh doeh haq ùh? ");
INSERT INTO hrebt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mahaq Chuaq Jesus creo moeq nà bàu cadêh, khoe aih haq pat hihèm. ");
INSERT INTO hrebt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bai prình ta hnim kùh waiq dahic broq baiq enh qnhèq trùh ta qneq. ");
INSERT INTO hrebt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cla craq ƀài lình oe tajang ka Chuaq Jesus, hnoq haq pat qmang aih, haq doe: Mangai kô joq Kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","I ƀài mangai gucadrì yòng ngan đeh enh hangai. Ta wì aih i Mari mađolen, Mari miq da wa Jaco qyoh xam Jôsep, xam Salomê. ");
INSERT INTO hrebt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aih piq ngai ma khoe tiaq patìh ka haq jò oe ta Galili, hanoh i bàc ngai gucadrì qnoeq hòm, aih ƀài mangai khoe tiaq haq tŏc ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hì aih wop hì padon, hì adroe ka hì Sabat, jò trŏc khoe ten clam, ");
INSERT INTO hrebt_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","I mòeq ngai oe ta Arimathê, yiniq haq Jôsep mangai broq kàn tanòe ƀài mangai broq gàu Juda, haq aih hadai xan tangèh gòm diac Boc Plình. Haq pacraq dèh manoh thia ta Philat đòeq hu bòch hanang Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Philat hamàih haraya tàng doe Chuaq Jesus cachìt rênh qmang aih, haq creo ka mangai cwan ƀài lình hu bòch Chuaq Jesus cachìt a khoe dùnh. ");
INSERT INTO hrebt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bu tàng cla craq ƀài lình anoe, haq hi am Jôsep yŏc hanang Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jôsep khoe rot đòeq bai hu lòm hanang, qnoh hanang Chuaq Jesus loh enh long pagat, haq yŏc bai lòm chac Chuaq Jesus khoe aih đòeq ta ralùng hanang haq ma khoe pùng tanòe hmo kàn. Khoe èh, cadro hmo kàn padit ajang ngah ralùng. ");
INSERT INTO hrebt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari mađolen, xam Mari miq Jôsê, hanoh hnoq nòe catùh Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bu khoe ka hì Sabat, Mari mađolen, Mari miq da Jaco, xam Salomê, rot dàu xua thùm lam hu qnheo hanang Chuaq Jesu. ");
INSERT INTO hrebt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hì gàu tuàng, sroeh sroq jò mat mahì butŏc, wì piq ngai aih lam ta ralùng, ");
INSERT INTO hrebt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","wì rai tanoe ka dabau: Cabô ma cadro hmo padit ajang ngah ralùng ka bèn kô èh? ");
INSERT INTO hrebt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Jò wì haq ngan, hnoq hmo aih khoe cadro, hmo aih kàn haraya. ");
INSERT INTO hrebt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","wì haq mùt trom ta ralùng, hnoq moeq ngai radam hangui pah qma, caxùnh eo yôh taboc, wì haq crè pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mahaq mangai aih doe ka wì haq: Apaq yùq dèh, pì chaq Chuaq Jesus mangai Naxaret, Mangai wì makhoe tiang đình talong pagat, Haq khoe rìh hlài, Haq pi i oe tacô, trùh ngan nòe wì ma khoe taqngùi haq beq. ");
INSERT INTO hrebt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mahaq drah lam anoe ka mangai tiaq hŏc haq hloe xam Phiero, Haq lam adroe ka pì mùt ta Galili. Ta aih èh pì hnoq Haq, qmang ka bàu Haq khoe anoe ka pì. ");
INSERT INTO hrebt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ƀài mangai gucadrì aih loh enh ralùng hanang, cadàu amot rai yùq rai hamàih, ùh hùa anoe ka cabô cleq, majah qmang aih wì haq crè pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chuaq Jesus khoe rìh hlài sroeh sroq oe ta hì baxèm gàu tuàng, angoe aih haq mahno rađeh ka Mari Mađolen, aih mangai haq ma khoe drùh qnoh tapèh toq kiac dù. ");
INSERT INTO hrebt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mangai gucadrì aih lam patình ka ƀài mangai adroe aih ma khoe tiaq Chuaq Jesus, mahaq manòeq qnang mangò crò hmoe. ");
INSERT INTO hrebt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mahaq jò wì aih tàng mangai gucadrì aih doe Chuaq Jesus khoe rìh hlài, èh rađeh khoe hnoq haq, wì ùh lùi. ");
INSERT INTO hrebt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Atìq ka aih, Chuaq Jesus yŏc chac qnoeq hòm đòeq hu mahno rađeh ka baiq ngai tiaq hŏc, jò wa aih qnang hlài dèh gùng. ");
INSERT INTO hrebt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wa aih drah lam patình ka wì qnoeq loq diq, mahaq dua ùh i cabô lùi. ");
INSERT INTO hrebt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Atìq hòm, haq mahno rađeh ka moeq jàt moeq ngai tiaq hŏc jò wì aih qnang acaq, Haq i tapoch cwò ka wì ma ùh i manoh lùi, manoh ma cadoq, ùh lùi bàu ƀài mangai ma khoe hnoq haq rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Haq thê wì aih: “Drah lam jàp dìq crŏng taneh, anoe Bàu lem ka rìm ngai. ");
INSERT INTO hrebt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mangai leq lùi rai chìuq broq ƀaptem haq aih jah dèch, mangai leq ùh lùi haq aih èh jah pòq yŏc kan hadrah. ");
INSERT INTO hrebt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ƀài mangai ma lùi aih èh jah kan halac kô: Wì jah yŏc yiniq au đòeq drùh qnoh kiac dù, jah tapoch bàu neo. ");
INSERT INTO hrebt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cadop bìh ta tì, tàng ôq yiniq ma ùh khòh, dua ùh hìa troq cleq, yŏc tì bèq mangai ùh hrŏc, mangai ùh hrŏc jah brêh.” ");
INSERT INTO hrebt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Atìq ka Chuaq Jesus anoe ka wì qmang aih, khoe èh haq jah dèch atŏc ta plình, haq hangui enh pah qma Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Khoe aih, mangai tiaq hŏc loh lam rai anoe jàp jìa, Chuaq wiang broq pajùm ti wì, rai yŏc ƀài kan halac acop tiaq đòeq broq cajap deh ka bàu. ");
INSERT INTO hrebt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wì craq Thêopilo, i bàc ngai khoe dìq ka manoh achìh hu taqmon hlài ƀài yiniq broq ma khoe gêh oe taqne nhèn, ");
INSERT INTO hrebt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tiaq wì ma hnoq qmòe enh baxèm, manòeq khoe loh mangai ma patìh ka Bàu lem khoe anoe hlài ka bèn, ");
INSERT INTO hrebt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","qmang aih jò khoe ngan hlài ka rabiaq rìm trong enh jò baxèm, au hèm khòh tiaq qmòe tang cadiang hu achìh hlài ka ìh, ");
INSERT INTO hrebt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","dôq ìh loq qmoè ka cajap bàu ìh ma khoe jah hŏc aih joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Qnhòng Hêrôt broq bùa diac Juđê, i mòeq ngai pajàu yiniq haq Xachari, tiaq dèh apah Abija, Êlisabet mai haq hadai nang noe Arôn. ");
INSERT INTO hrebt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Boc Plình ngan hnoq dìq baiq ka wa aih mangai taq atoq, wèq gêh geo rìm ranenh hloe xam rìm ramènh Boc Plình thê. ");
INSERT INTO hrebt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wa ùh i ka kon majah qmang aih Êlisabet haq xon, èh dìq baiq ka wa khoe bàc hanam. ");
INSERT INTO hrebt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jò Xachari tiaq dèh wì ma ta axong, khoe troq jò da haq broq pajàu dèch ramènh tadreo am ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tiaq dèh trong ƀài pajàu kàn xan broq, Xachari pàih panàih troq ka haq mùt ta hnim kùh waiq đòeq bùh gahnàu xua thùm ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Trùh jò bùh gahnàu, ƀài mangai bàc oe dìq enh gùng waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Moeq ƀình plình loh enh ngèa ka Xachari, yòng enh pah qma ka nòe prang bùh gahnàu. ");
INSERT INTO hrebt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jò Xachari hnoq ƀình plình, haq loh ka lèt rai yùq crè. ");
INSERT INTO hrebt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mahaq ƀình plình doe ka haq: Xachari, ùh dùh yùq, bàu ìh waiq khàn khoe jah tamàng, Êlisabet cadrì ìh, haq aih èh ha-uang ka ìh moeq ngai kon calô, ìh yiniq ka aih Jon. ");
INSERT INTO hrebt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kon calô aih èh broq ka ìh jah lem bùi, bàc ngai qnoeq hadai manè jò ha-uang qnoh haq. ");
INSERT INTO hrebt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Enh ngèa Boc Plình, kon qyoh aih wìa gucraq, yac ka alac plì nho, yac ka cleq ma loq bù dua haq ùh ôq, haq aih jah bình halùih Yiang Hadròeh jò haq oe raq ta cliac miq. ");
INSERT INTO hrebt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Haq qnung bàc ngai Isorali wìh hlài trùh ti Chuaq aih Boc Plình wì haq. ");
INSERT INTO hrebt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Èh haq lam enh ngèa ka Chuaq tiaq manoh xam kan itai qmang da Êli, đòeq broq manoh baq wìh hlài dèh ta kon, èh mangai ùh qnì iu wìh hlài ta kan rabiaq da mangai taq atoq, hu padon đòeq ka Chuaq moeq nang noe khoe palauq đòeq ta manoh. ");
INSERT INTO hrebt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Xachari bòch ƀình plình: Broq qmang leq au ma loq ka bàu ìh aih joq qnàng? Au khoe craq, mai au khoe bàc hanam. ");
INSERT INTO hrebt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ƀình plình doe: Au kô Gapriên, yòng enh ngèa ka Boc Plình. Haq khoe thê au trùh bahìa kan lem bùi kô. ");
INSERT INTO hrebt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Manòeq kô, ìh loh ka làu, pi hloh tapoch trùh hì loh ƀài yiniq qmang bàu au khoe anoe, majah qmang aih ìh ùh lùi bàu au, aih la bàu trùh dèh jò hi xìt. ");
INSERT INTO hrebt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jò aih dìq ka ƀài wì mangai bàc oe enh gùng gòm Xachari dìq jaq hamàih, majah qmang aih haq oe ta hnim kùh waiq dùnh hrìn. ");
INSERT INTO hrebt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jò Xachari loh enh gùng, haq tapoch ùh jah, aih wì ma hi loq haq i hnoq kan mahno tanòe hnim kùh waiq, haq yŏc tì ti patìah ka wì, mahaq oe raq làu. ");
INSERT INTO hrebt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jò haq khoe dìq dèh ka hì patìh, haq hlài dèh ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Toq biaq atìq ka aih, Êlisabet, mai haq hi hadràp, haq cadoc rađeh padam khê ");
INSERT INTO hrebt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","haq doe: Chuaq khoe broq yiniq kô ka au, haq khoe haqmiang ngan au, đòeq lêh kan camaih au oe taqne mangai bàc. ");
INSERT INTO hrebt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jò Êlisabet oe jiang khoe jah tadràu khê, Boc Plình thê ƀình plình Gapriên trùh ta plài Naxaret, gùng Galili. ");
INSERT INTO hrebt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Lam glàm mangai adrùh sriu yiniq haq Mari, khoe tèu bàu yŏc moeq ngai radam yiniq haq Jôsep, caxi noe Đawit. ");
INSERT INTO hrebt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ƀình plình trùh ajang nòe mangai adrùh aih rai doe: Manè am ka ìh, mangai jah xôq ramot! Chuaq oe ti ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tàng bàu aih Mari haq hamàih, haq hèm bàu hangah qmang aih ìq qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ƀình plình doe: Mari ùh dùh yùq dèh, majah qmang aih ìh khoe jah kan tamèt enh nòe Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kô èh ìh hadràp èh ha-uang loh moeq ngai kon calô, ìh yiniq ka haq Jesus ");
INSERT INTO hrebt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Haq aih èh wìa gucraq, jah creo Kon Yiang Dìq Jaq Haqnhèq. Chuaq aih Boc Plình jah am ka haq gèq enh kan cadraq haq aih Đawit. ");
INSERT INTO hrebt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Haq aih èh ma wèq cwìang enh qnhèq ka nang noe Jacôp trùh mòeq đòe, diac da haq ùh lùch. ");
INSERT INTO hrebt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari padreo bàu: Au qnhòq lah qnì ka gucalô leq, wìa ka i qmang aih? ");
INSERT INTO hrebt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ƀình plình doe: Yiang Hadròeh trùh enh qnhèq ka ìh èh kan itai Yiang Dìq Jaq Haqnhèq taqmàn ìh tayàp haq, dài aih ìq raq, kon hadròeh aih ha-uang loh majah ep creo kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hatau, Êlisabet mangai hadròng ìh, hanoh oe jiang jò haq khoe craq, rìm ngai khoe loq ka haq aih xon, yàng manòeq kô haq oe jiang khoe jah tadràu khê. ");
INSERT INTO hrebt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Majah qmang aih, ùh i cleq Boc Plình ma broq ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari padreo bàu: Au kô mangai hapŏng Chuaq, waiq bàu ìh anoe ka au aih jah gêh! Khoe aih ƀình plình hi lam. ");
INSERT INTO hrebt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ta ƀài hì aih, Mari haq drah lam trùh ta plài ma oe ta wang nòe gùng Juđe, ");
INSERT INTO hrebt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ta aih haq mùt ta hnim Xachari rai dèch bàu manè lem bùi ka Êlisabet. ");
INSERT INTO hrebt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Êlisabet bu tàng bàu Mari, kon nga oe ta cliac khoe canhroh, Êlisabet khoe jah bình Yiang Hadròeh, ");
INSERT INTO hrebt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Haq dèch bàu anoe: Taqne dìq dŏng ka mangai gucadrì, ìh kô mangai i xôq ramot, kon qyoh oe ta cliac hadai jah xôq ramot. ");
INSERT INTO hrebt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Enh leq kô ìq au majah kan tamèt qmang kô, miq da Chuaq au trùh hmàih ka au? ");
INSERT INTO hrebt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Majah qmang aih don au butàng bàu ìh, kon nga ta cliac au khoe canhroh rai lem bùi. ");
INSERT INTO hrebt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Xôq ramot ka ìh mangai khoe lùi bàu Chuaq anoe, aih bàu trùh dèh hì jah xìt. ");
INSERT INTO hrebt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari doe rameh: Manoh au manè apôi Chuaq, ");
INSERT INTO hrebt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mahua yiang au lem bùi tanòe Boc Plình aih Chuaq dèch au, ");
INSERT INTO hrebt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Majah qmang aih haq khoe hqmàng hnoq kan hamoq au, mangai hapŏng haq. Pang kô ta èh, rìm qnhòng dìq anoe au kô mangai i xôq ramot; ");
INSERT INTO hrebt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Majah qmang aih, Yiang dìq jaq haqnhèq, khoe broq bìac kàn ka au. Yiniq haq aih hadròeh, ");
INSERT INTO hrebt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Haq loq waq ka mangai loq iu haq enh qnhòng kô trùh qnhòng tau. ");
INSERT INTO hrebt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Haq yŏc dèh tì kŏng đòeq patô qnoh deh kan itai; Rai raliang đac trong da mangai i manoh loq padèch rađeh. ");
INSERT INTO hrebt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Haq khoe caqnìh qnoh mangai i cwìang clìh enh gèq cla wì haq, Rai dèch atŏc mangai loq hamon rađeh ");
INSERT INTO hrebt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Haq khoe broq ka mangai pangot jah bình dahwèq jìang, Hnan mangai kan hlài tì dech. ");
INSERT INTO hrebt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Haq khoe wiang ti Isorali, hapŏng haq Đòeq bahmàng hlài dèh kan loq waq haq, ");
INSERT INTO hrebt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tìah ka bàu haq khoe doe ka kan cadraq bèn. ");
INSERT INTO hrebt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari oe ti Êlisabet jah ta piq khê, khoe aih hi wìh hlài dèh ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Jò khoe trùh dèh khê Êlisabet hi ha-uang, haq ha-uang moeq ngai kon calô. ");
INSERT INTO hrebt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Plài pla xam ƀài oh daq hìa Chuaq khoe dìq jaq tamèt ka Êlisabet wì wiang trùh lem bùi ti haq. ");
INSERT INTO hrebt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Trùh rahem hì, dìq ka wì lam ta aih đòeq broq ramènh kat akia, wì yiniq ka kon qyoh aih Xachari tiaq yiniq dèh baq. ");
INSERT INTO hrebt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mahaq miq haq doe: Ùh, ep yiniq ka haq Jon. ");
INSERT INTO hrebt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wì doe: Dìq dŏng ka nang noe ìh ùh i ka cabô leq i yiniq aih. ");
INSERT INTO hrebt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wì yŏc tì ti patìah hu bòch baq haq enh yiniq dèh ka kon yiniq cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xachari thê wì yŏc capiac long ban qyoh, haq achìh: yiniq haq Jon. Mangai leq mangai meh hamàih đeh hra. ");
INSERT INTO hrebt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wop hloe jò aih raq, rapet haq jah rađah, haq tapoch rai manè apôi Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Dìq ka wì taplài cadròt đeh hra, dìq ka gùng wang Galili wì anoe ka dabau toq trong aih. ");
INSERT INTO hrebt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Cabô tàng bàu aih hanoh wê đòeq ta manoh rai doe: Kon nga aih èh qmang leq cadèh oq? Majah qmang aih tì Chuaq oe ti haq. ");
INSERT INTO hrebt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jò aih, Xachari baq kon nga aih jah bình Yiang Hadròeh, haq tapoch pajàu rameh: ");
INSERT INTO hrebt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Manè apôi Chuaq aih Boc Plình Isorali, majah qmang aih Ìh khoe trùh hmàih, rai baxon yŏc hlài Isorali mangai da Ìh, ");
INSERT INTO hrebt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ìh khoe paqnàng ka nhèn, ta hnim Đawit hapŏng Ìh, moeq Ngai dèch nhèn i kwìang itai! ");
INSERT INTO hrebt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tìah ka Ìh khoe yŏc bàu wì mangai pajàu hadròeh qnhòng calah nèh, ");
INSERT INTO hrebt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ìh dèch nhèn khoe ka mangai tablêq, khoe ka nòe tì kŏng wì ma tagit ka nhèn; ");
INSERT INTO hrebt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ìh paqnoh kan loq waq am ka kan cadraq nhèn, rai hmàng bàu tajap hadròeh cla Ìh, ");
INSERT INTO hrebt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tìah ka Ìh ma khoe hapah ka Apraham kan cadraq nhèn, ");
INSERT INTO hrebt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ìh khoe tèu bàu dèch nhèn claih enh tì kŏng mangai tagit ka nhèn, Ìh am ka nhèn sôq ramot malem, ti ngèa Ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Đòeq yŏc kan hadroèh, kan taq atoq hu patìh ka Ìh, dìq ka qnhòng cla ùh hòq qmòe cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kon oq! kô èh wì creo kon aih pajàu da Yiang Haqnhèq; Kô èh kon lam enh ngèa ka Chuaq, padon trong ka haq, ");
INSERT INTO hrebt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dôq ka mangai da haq ajang nòe yiniq lui wì haq jah caqnaih aih hu canau loq kan dèch am dech. ");
INSERT INTO hrebt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Majah qmang aih Boc Plình nhèn tamèt ta manoh, Mat mahì enh qnhèq jah sreo qngah ka nhèn, ");
INSERT INTO hrebt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Đòeq sreo ka mangai hangui tanòe clam cluiq xam mangai hangui ta yàp qmù kan kachìt, Rai qnung jènh nhèn lam ta trong catèm. ");
INSERT INTO hrebt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kon qyoh aih yòng kàn, mahua yiang tadêh, rìh oe tanòe hawit trùh hì paqnoh rađeh ka mangai Isorali. ");
INSERT INTO hrebt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jò aih Auguto, bùa kàn qnoh bàu thê dìq ka Lamah, aih taneh diac kàn dìq jaq, ep ti rèn ngan hlài mangai ta aih jah toq leq. ");
INSERT INTO hrebt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aih yàng baxèm wì ti rèn ngan hlài, wop qnhòng da Quiniri-u broq cla craq ƀài cwan tagùng Siri. ");
INSERT INTO hrebt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mangai hlài đeh hra ta gùng cla đòeq achìh qmùt dèh yiniq. ");
INSERT INTO hrebt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jôsep aih caxi noe Đawit, haq hanoh lam enh Naxaret, gùng Galili, loh ta gùng Juđê trùh ta Bêt-le-hem. ");
INSERT INTO hrebt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hu achìh qmùt dèh yiniq rađeh xam yiniq Mari, mangai khoe òq bàu yŏc haq, qnang oe jiang. ");
INSERT INTO hrebt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jò wa qnang oe ta aih, khoe trùh hì Mari ha-uang. ");
INSERT INTO hrebt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Haq ha-uang kon calô ramua, yŏc mù taqmàn deh kon, ta qngùi ta atong nhat, majah qmang aih ta hnim padài khoe dìq ka nòe. ");
INSERT INTO hrebt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hadai gùng aih, i ƀài mangai ban trìu oe tagùng, rìu qngah ka mang đòeq wèq dèh trìu. ");
INSERT INTO hrebt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Moeq ƀình plình da Chuaq trùh ten ka wì, kan ranhòm Chuaq qngah qngiang dudan wì haq, wì crè pi cajaq ");
INSERT INTO hrebt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ƀình plình doe: Ùh yùq cleq! Hacô au bahìa ka pì moeq Bàu lem, aih raq kan lem bùi am dìq ka mangai oe ta crŏng taneh; ");
INSERT INTO hrebt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hì cô ta plài Đawit khoe ha-uang ka pì moeq Ngai dèch mangai, aih Christ, aih Chuaq pì. ");
INSERT INTO hrebt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kô oq kan hadro dôq pì hu canau ka Haq, pì hnoq moeq ngai kon qyoh taqmàn xi mù, kùi ta atong nhat. ");
INSERT INTO hrebt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tajòe qmòe jò aih, raya rayùc lình plình xam ƀình plình aih calêu manè apôi Boc Plình rameh: ");
INSERT INTO hrebt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Qngah yiniq Boc Plình oe taplình haqnhèq, Catèm tanòe haqneq am ka bài mangai haq loq waq! ");
INSERT INTO hrebt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jò wì bình plình khoe talah ka wì haq hu wìh hlài ta plình, ƀài mangai ban trìu doe ka dabau: Beq bèn lam ta Bêtlehem hu ngan yiniq neo loh kô, Chuaq ma khoe doe ka bèn loq. ");
INSERT INTO hrebt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Qmang aih wì haq drah lam ka nhet, hnoq Mari xam Jôsep xam kon qyoh qnang kùi ta atong nhat. ");
INSERT INTO hrebt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jò khoe hnoq wì anoe hlài bàu ƀình plình anoe trùh kon qyoh, wì haq ma khoe jah tàng. ");
INSERT INTO hrebt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dìq ka mangai tamàng hamàih đeh hra ka bàu ƀài mangai ban trìu anoe ka wì haq. ");
INSERT INTO hrebt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mahaq Mari wê dìq dŏng ƀài bàu aih rai hèm yôt dèh ta manoh. ");
INSERT INTO hrebt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ƀài mangai ban trìu tawìh hlài, rai broq qngah yiniq rai manè apôi Boc Plình trong wì haq khoe tàng xam yiniq wì haq khoe hnoq joq tìah ka bàu ma khoe anoe ka wì haq. ");
INSERT INTO hrebt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Trùh rahem hì, aih hì ep broq ramènh kat akia ka kon qyoh, wì yiniq ka haq Jesus, aih yiniq ƀình plình ma khoe yiniq adroe qmòe ka jò hadràp. Dèch Jesus ka Boc Plình ");
INSERT INTO hrebt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Khoe dìq ka hì basròeh, tiaq ranenh Moise, Jôsep xam Mari atŏc kon qyoh ta Jêrusalem đòeq dèch ka Boc Plình, ");
INSERT INTO hrebt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","qmang ka khoe achìh ta hset ranenh haq: “Rìm ngai kon calô ramua, ep dèch ka Chuaq”, ");
INSERT INTO hrebt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","dèch tam baiq toq trù braih ùh meh baiq toq kon trù qyoh, qmang ka ranenh Chuaq khoe thê. ");
INSERT INTO hrebt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jò aih, ta Jêrusalem i moeq ngai rìh lem rìh taq atoq, yiniq haq aih Simêon, haq aih toq gòm kan alòng trùh ka Isorali, Yiang Hadròeh oe ti haq. ");
INSERT INTO hrebt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yiang Hadròeh khoe anoe ka haq loq haq ùh cachìt adroe ka jah hnoq Christ da Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Qmang aih, haq tiaq Yiang Hadròeh qnung, haq mùt ta hnim kùh waiq wop troq jò wa miq baq aràng Chuaq Jesus ta aih, hu pagêh ka haq rìm trong ramnenh khoe thê. ");
INSERT INTO hrebt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Haq aih hi caqmìn kon qyoh aih, haq manè apôi Boc Plình rameh: ");
INSERT INTO hrebt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Waiq Chuaq! Manòeq kô Ìh am au jah cachìt ka catèm tiaq troeq bàu Ìh; ");
INSERT INTO hrebt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Majah qmang aih mat au khoe hnoq kan dèch kon mangai trùh enh nòe Ìh, ");
INSERT INTO hrebt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ìh ma khoe palauq qmòe dèh, đòeq broq kan qngah enh ngèa rìm diac, ");
INSERT INTO hrebt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","kan qngah sreo jàp ka phù cròng, broq ka Isorali Ìh jah kan ranhòm. ");
INSERT INTO hrebt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wa miq baq kon qyoh aih dìq jaq hamàih ka bàu wì anoe trùh dèh kon. ");
INSERT INTO hrebt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simêon waiq xôq ramot am ka wa ŏng mai, haq doe ka Mari miq kon qyoh aih rameh: I bàu khoe tèu đòeq am ka Kon qyoh kô, haq broq nen ka bàc ngai Isorali tacro, èh hadai broq ka bàc ngai jah yòng, khoe tèu đòeq dôq haq wìa teo ka bàc ngai tarahen; ");
INSERT INTO hrebt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","da ìh hòm, i moeq pla chang pàc hlùh ta cliac ìh. Aih èh bàc yiniq oe ta manoh bàc ngai jah paqnoh. ");
INSERT INTO hrebt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Èh hòm i mangai pajàu cadrì, yiniq haq An-ne, kon da Phanu-ên, caxi noe Ase, joq khoe bàc hanam. Enh jò haq oe raq adrùh sriu, atìq ka aih haq oe dèh ti ŏng jah tapèh hanam, ");
INSERT INTO hrebt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","khoe aih haq hi hadrô. Jò aih haq khoe jah rahem jàt pôn hanam, oe toq ta hnim kùh waiq, dahì damang patìh ka Boc Plình, apàm ka acaq rai waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hanoh jò aih diq, haq trùh ta aih, manè apôi Boc Plình rai anoe trùh kon qyoh ka bài mangai qnang tangèh gòm Jêrusalem jah dèch paclaih. ");
INSERT INTO hrebt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jò Jôsep xam Mari khoe broq gêh ka trong ranenh Boc Plình thê, wa haq tawìh hlài ta Galili, trùh dèh ta Naxaret plài cla. ");
INSERT INTO hrebt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kon qyoh aih yòng kàn, rai tadêh, jah bình kan rabiaq, xôq ramot Boc Plình oe ti Haq. Jò Jesus jah moeq jàt baiq hanam ");
INSERT INTO hrebt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Rìm hanam wa miq baq Haq tŏc ta Jersalem, đòeq lam tagop ta hì ramènh Pancwa. ");
INSERT INTO hrebt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jò khoe jah moeq jàt baiq hanam haq lam tiaq dèh wa miq baq tŏc ta aih hu hadai tagop ta hì ramènh qmang ka xan hmaq broq. ");
INSERT INTO hrebt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Khoe dìq ka hì ramènh, wì haq wìh hlài dèh tagùng, Chuaq Jesus oe hlài ta aih mahaq miq baq haq ùh qnì. ");
INSERT INTO hrebt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hèm deh haq lam ti ƀài bua ta aih, khoe moeq hì lam trong aih men ti bòch wì oh daq xam ƀài mangai canau; ");
INSERT INTO hrebt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","jò chaq haq khoe pi hnoq, wa wìh hlài ta Jerusalem đòeq chaq. ");
INSERT INTO hrebt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Piq hì wa men hnoq haq tanòe hnim Kùh waiq, qnang hangui taqne ƀài mangai hnài, rai tamàng rai bòch hlài wì aih. ");
INSERT INTO hrebt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Rìm ngai tàng bàu rai hnoq kan rabiaq haq wì dìq loh ka hamàih jò haq bòch wì. ");
INSERT INTO hrebt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jò hi hnoq haq, wa miq baq dìq jaq hamàih. Miq haq doe: A kon! Hagleq ma jah haƀo ka ma qmang kô, ma khoe lèt oe i jaq cleq? ");
INSERT INTO hrebt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Haq bòch: “Aih chôp chaq dèh ka au? Chôp ma ùh loq au ep oe patìh dèh ta hnim Baq qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mahaq wa aih ùh tem bàu haq anoe ka rađeh cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Khoe aih haq hlài ta Naxaret ti wa miq baq rai iu broq tiaq bàu wa, mahaq bàu da haq miq haq wê dŏng ta manoh. ");
INSERT INTO hrebt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Chuaq Jesus rai èh rai rabiaq tam, chac rai èh rai kàn, kiang èh kiang lem manoh Boc plình xam kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Hanam moeq jàt padam qnhòng Tibêro broq bùa kàn, jò aih Bônso-philat broq cla craq ƀài cwan ta gùng Juđê, Herôt broq bùa qyoh ta gùng Galili, Philip oh haq broq bùa qyoh ta gùng Yturê xam tracôni, Lysa-nia broq bùa qyoh ta gùng Abilen, ");
INSERT INTO hrebt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anne xam Caiphe broq pajàu kàn, aih i bàu Boc Plình thê Jon kon Xacahri tanòe gùng hawit. ");
INSERT INTO hrebt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon ti lam dudan jàp ka rìm gùng cròng diac Jôđan, hnài wì broq ramènh ƀaptem da kan loq raxach cađac trong dù đòeq hu jah caqnaih yiniq lui, ");
INSERT INTO hrebt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","tìah ka bàu khoe achìh ta hset pajàu Êsai: I bàu creo tanòe hawit: Drah palauq trong ka Chuaq, pajang trong da haq. ");
INSERT INTO hrebt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nòe jrùq tàc dôq haq bình, Roc bui wang, roc nòe haqnhèq qnoh dôq haq haqneq; Trong tawech pajang dôq haq hnhoh, Trong qnhèq qneq broq dôq haq tamang. ");
INSERT INTO hrebt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dìq dŏng kon mangai jah hnoq kan dèch enh Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon anoe ka mangai bàc qnang trùh ta aih đòeq jah broq ƀaptem: Nang noe bìh tau, cabô ma hnài pì loq wia ka kan nòeh hì atìq? ");
INSERT INTO hrebt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Qmat èh, drah wìa malem dôq ùh qngwan ka pì khoe loq raxach, ùh dùh doe Apraham aih kan cadraq nhèn, majah qmang aih au doe ka pì Boc Plình broq ƀài hmo kô loh nang noe ka Apraham jah. ");
INSERT INTO hrebt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chòng khoe roh qmòe ajang xèm long, waq toq long leq ùh loh plì lem, long aih èh koh đòeq hu bùh cađac. ");
INSERT INTO hrebt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Wì bòch Jon: Aih èh nhèn ep broq qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Haq padreo bàu: Cabô i baiq blah eo, yŏc moeq blah am ka mangai chac dech, dahwèq acaq hadai qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","I bàc ngai yŏc thèq trùh hu broq ƀaptem, wì aih bòch: Ha nhèn ep broq cleq? ");
INSERT INTO hrebt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Haq doe ka wì: Apaq yŏc yeo bàc ka maneh khoe pajaq. ");
INSERT INTO hrebt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ƀài mangai lình hanoh bòch: Ha nhèn kô hòm ep broq cleq? Haq doe: apaq tacaq ka cabô, apaq qnùt cabô, jèn baha pì pang leq, pì waq dèh pang aih. ");
INSERT INTO hrebt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Majah qmang aih wì qnang tagòm ngèh, wì hèm dèh ta manoh ahìaq Jon kô raq Christ, ");
INSERT INTO hrebt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","aih ìq Jon majah doe ka wì: Au broq ka pì ƀaptem xi diac mahaq Mangai trùh atìq ka au cwìang yeo haqnhèq ka au, au mech qnhòq wìa broq đeh magai doeh da haq caxi jep. Haq aih èh ma broq ka pì ƀaptem xi Yiang Hadròeh xi ùnh. ");
INSERT INTO hrebt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tì Haq wê cađap hu dè dèh qmau ta haneh ka hreo, lênh qmau haq tah ta hapom, manùh haq bùh ta ùnh ùh jò leq pat. ");
INSERT INTO hrebt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jò Jon anoe Bàu lem, haq hadai hnài wì bàc trong qnoeq, ");
INSERT INTO hrebt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mahaq Hêrôt bùa qyoh, Jon khoe i tapoch ùh lòh haq yŏc Hêrođia mai oh haq, hloe xam ƀài trong dù bùa ma broq, ");
INSERT INTO hrebt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","haq broq tam moeq yiniq dù hòm, aih haq rùp clêh Jon ta hnim tù. ");
INSERT INTO hrebt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jò dìq ka mangai ta aih khoe jah broq ƀaptem, Chuaq Jesus hanoh jah broq ƀaptem, plình tapèh qmòe jò haq qnang waiq khàn, ");
INSERT INTO hrebt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Yiang Hadròeh yŏc chac trù loh jràp ta chac haq, tajòe qmòe jò aih i bàu enh plình doe: “Ìh kô kon au, mangai au loq waq deh, kon lem ka manoh au rìm trong.” ");
INSERT INTO hrebt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jò Chuaq Jesus baxèm broq dèh trong haq broq, jò aih haq bu jah qnah ta piq jàt hanam. Tiaq manoh wì hèm haq aih kon Jôsep, Jôsep kon Hêli, ");
INSERT INTO hrebt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hêli kon Matat, Matat kon Lêwi, Lêwi kon Mên chi, Mên chi kon Jane, Jane kon Jôsep ");
INSERT INTO hrebt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jôsep kon Mata-thia, Mata-thia kon Amôt, Amôt kon Nahum, Nahum kon Êt-li, Êt-li kon Na-gê, ");
INSERT INTO hrebt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Na gê kon Ma at, Ma at kon Mata-lia, Mata-lia kon Sê-me-in, Sê-me-in kon Jô-et, Jô-et kon Jô-đa, ");
INSERT INTO hrebt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jô-đa kon Jô-anan, Jô-anan kon Rêsa, Rêsa kon Xôro-baben, Xôro-baben kon Sala-thien, Sala-thien kon Nêri, ");
INSERT INTO hrebt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nêri kon Mênchi, Mênchi kon A đi, A đi kon Kôsam, Kôsam kon Ên-mađan, Ên-mađan kon Ero, ");
INSERT INTO hrebt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ero kon Jêsu, Jêsu kon Êli-ese, Êli-ese kon Jôrim, Jôrim kon Ma-that, Ma-that kon Lêvi, ");
INSERT INTO hrebt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lêvi kon Si-mê-on, Si-mê-on kon Juda, Juda kon Jôsep, Jôsep kon Jônam, Jônam kon Êli-akim, Êli-akim Mê-lea, ");
INSERT INTO hrebt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Mê-lea kon Mêna, Mêna kon Mata-tha, Mata-tha kon Nathan, Nathan kon Đawit, ");
INSERT INTO hrebt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Đavit kon Jêse, Jêse kon Jôbet, Jôbet kon Bo-ô, Bo-ô kon sala, Sala kon Nach-son, Nach-son kon Ami-na-đap, ");
INSERT INTO hrebt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ami-na-đap kon Amin, Amin kon Arôni, Arôni kon Et-rôm, Et-rôm kon Pharê, Pharê kon Juda, ");
INSERT INTO hrebt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda kon Jacôp, Jacôp kon Ysac, Ysac kon Apraham, apraham kon Tharê, Tharê kon Nacô, ");
INSERT INTO hrebt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacô kon Sêruc, Sêruc kon Ragao, Ragao kon Phalet, Phalet kon Hêbe, Hêbe kon Sala, ");
INSERT INTO hrebt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala kon Canam, Canam kon Abasac, Abasac Sem, Sem kon Noê, Noê kon Lêmec, ");
INSERT INTO hrebt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec kon Mêtu-sela. Mêtu-sela kon Hênoc, Hênoc kon Jaret, Jaret kon Mêle-le-en, Mêle-le-en kon Cainam, ");
INSERT INTO hrebt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainam kon Enot, Enot kon Sêt, Sêt kon Adam, Adam kon Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Chuaq Jesus bình Yiang Hadròeh, hlài enh cròng diac Jođan, Yiang Hadròeh aràng haq mùt tagùng hawit. ");
INSERT INTO hrebt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ta aih kiac padô aluàn haq pôn jàt hì, Ta ƀài hì aih haq ùh lòm acaq qmòe cleq, dìq dèh ka jò haq loh qmòe ka hrah. ");
INSERT INTO hrebt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kan kiac doe ka haq: Tàng joq ìh kon Boc Plình, thê hmo kô wìa ƀênh beq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chuaq Jesus padreo bàu: “Khoe i bàu achìh, kon mangai rìh ma xài canòm toq ka ƀênh.” ");
INSERT INTO hrebt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kiac atŏc haq tanòe haqnhèq, qmoeq rahyàc raq haq khoe patô ka Chuaq Jesus dìq dŏng ka ƀài diac ta crŏng taneh; ");
INSERT INTO hrebt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","haq doe ka Chuaq Jesus: dìq dŏng ka cwìang xam ka ranhòm taqmat, khoe am dŏng ka au, au enh am ka cabô leq am. ");
INSERT INTO hrebt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tàng ìh kùh waiq au, aih hi jah ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Chuaq Jesus pareo bàu: “I bàu achìh rameh: ìh ep kùh waiq Boc plình ìh rai patìh toq ka haq raq” ");
INSERT INTO hrebt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kiac aràng haq trùh ta Jêrusalem rai dèch atŏc haq oe tanòe dìq jaq haqnhèq ta bui hnim kùh waiq, haq doe: Tàng joq ìh kon Boc plình, hadrùc beq, ");
INSERT INTO hrebt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","majah qmang aih khoe i bàu achìh: Haq thê dèh ƀình plình wèq ìh, ");
INSERT INTO hrebt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Wì aih dèch ìh tŏc taxŏng wì haq, aih èh dôq jènh ìh ùh hìaq catoeh ka hmo. ");
INSERT INTO hrebt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chuaq Jesus padreo bàu: “I bàu khoe achìh: Ùh khòh qnhro Chuaq aih Boc Plình ìh”. ");
INSERT INTO hrebt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kan kiac dìq ka trong đòeq hu padô Chuaq Jesus, haq hi wia đò hòeq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chuaq Jesus jah bình cwìang atai enh Yiang Hadròeh, haq wìh hlài ta Galili, jàp gùng dudan aih khoe hìa tàng yiniq haq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Haq hnài tanòe hnim tagop qyoh, mangai mannè đeh hra. ");
INSERT INTO hrebt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Haq trùh ta Naxaret, nòe haq yòng kàn. Tìah dèh Haq hmaq broq, trùh hì Sabat haq mùt hnim tagop qyoh, èh hi yòng đŏc. ");
INSERT INTO hrebt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Wì am ka haq hset pajàu Êsai, haq pèh jang nòe khoe achìh: ");
INSERT INTO hrebt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Yiang Boc Plình oe ti au; Majah qmang aih haq khoe xùt dàu ka au, đòeq hu anoe Bàu lem ka mangai pa; ");
INSERT INTO hrebt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Haq khoe thê au trùh paclaih mangai oe ta hnim tù jah loh enh gùng, Mangai ùh xau jah hnoq, Mangai wì tacaq ka haq jah claih; Rai bahìa hanam catèm da Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Khoe aih haq don hlài hset padreo am da ka mangai patìh ta aih khoe èh haq hi hangui. Rìm ngai ta hnim tagop qyoh aih dìq haqmiang ngan haq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Haq doe ka wì: Bàu hset hadròeh pì ma tamàng aih, hì kô khoe xìt. ");
INSERT INTO hrebt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dìq ka mangai ta aih maleq ma meh dìq anoe trùh haq, wì hamàih ka bàu rabiaq loh enh haq, wì doe: Haq qmat ajoq kon Jôsep? ");
INSERT INTO hrebt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Haq doe ka wì: “Canau pì yŏc bàu cachôi qmang kô hu anoe ka au: Mangai broq jreo, haqnauq dèh cla òeq, aleq ƀài yiniq ìh broq ta Cabênaum nhèn ma khoe tàng, broq nòe gùng cla kô beq.” ");
INSERT INTO hrebt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Haq doe ka wì: “Joq au doe ka pì, qnhòq lah i mangai pajàu leq jah gùng cla manè. ");
INSERT INTO hrebt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Au anoe qnàng ka pì, qnhòng Êli, jò trŏc pađang piq hanam qne, dìq dŏng ka gùng loh ka pangot hrah, tanòe mangai Isorali i bàc mangai hadrô; ");
INSERT INTO hrebt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","yac ka qmang aih, aleq i thê Êli trùh hnim cabô taqne ƀài aih, mahaq thê haq lam ta hnim mangai cadrì hadrô oe ta Sarepta gùng Siđôn. ");
INSERT INTO hrebt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Qnhòng da pajàu Êlisê mangai Isorali loh ka bacùn ma i palap cleq, mahaq ma i mangai leq jah brêh, enh gùng ka Na-aman, mangai Siri. ");
INSERT INTO hrebt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Maleq ma meh oe ta hnim tagop qyoh tàng bàu aih, wì nòeh pi ka jaq cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wì padinh yòng, hua qnoh haq loh enh gùng ka plài, qnung haq tŏc ta bui wang nòe wì broq plài đòeq hu caqnhùt qnìh đac haq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yàng haq pagat ti ngèa wì èh hi lam taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Haq loh ta Cabênaum, oe ta gùng Gallili, hnài ta hì Sabat. ");
INSERT INTO hrebt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Rìm ngai tamèt ta manoh jò tàng bàu haq hnài, majah qmang aih bàu haq i ang. ");
INSERT INTO hrebt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tanòe hnim kùh waiq i moeq ngai ta dalam chac haq i kiac mùt, breo cadêh: Jesus mangai Naxaret, ");
INSERT INTO hrebt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ìh enh broq ka nhèn cleq kô ìq? Ìh trùh hu raliang cađac nhèn qmòh? Ìh qmat cabô, au loq: Mangai Hadròeh da Boc plình! ");
INSERT INTO hrebt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mahaq Chuaq Jesus capoch nhang ka haq aih: “Oe ma hatinh haq! Drah loh enh mangai qmat”. Hloe jò aih, taqne mangai bàc kiac rapòt mangai aih ta haqneq, èh hi loh, ùh hìaq broq ka haq aih loh habau. ");
INSERT INTO hrebt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mangai leq mangai meh haglènh đeh hra, wì ta anoe ka dabau: Ƀài bàu kô qmang leq ìq! Haq yŏc cwìang yŏc kan dêh enh leq ma drùh qnoh kiac, kiac ma loh hloe qmang meh. ");
INSERT INTO hrebt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dìq dŏng gùng dudan ta aih wì loq đeh hra ka Haq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chuaq Jesus loh enh hnim tagop qyoh, haq lam ta hnim Simôn. Miq mai Simôn qnang tôq tanget hlàc raya. Wì canòm ka Chuaq Jesus broq brêh ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chuaq Jesus cachình chac ta mangai aih, haq tapoch ka kan tanget, kan tanget hi dìq. Mangai aih hi padinh yòng patìh. ");
INSERT INTO hrebt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jò mat mahì clìh, mangai yinìq qmang leq, mangai ùh hrŏc qmang leq wì aràng trùh dìq ta haq, haq yŏc tì bèq tang ngai hu broq brêh ka wì. ");
INSERT INTO hrebt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bàc kiac cadàu loh enh bàc ngai rai cajiah: Ìh qmat kon Boc Plình. Mahaq Chuaq Jesus lech ùh am wì haq tapoch, majah qmang aih kiac loq ka haq aih raq Christ. ");
INSERT INTO hrebt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Buqngah, Chuaq Jesus loh lam tanoè hawit. Bàc mangai lam ti chaq haq. Jò hnoq haq, wì padràng haq oe, wì ùh enh dôq haq lam taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mahaq haq doe ka wì: “Au ep lam anoe Bàu lem da Boc Plình ka wì ta qnoeq hòm, aih raq majah khoe thê au trùh.” ");
INSERT INTO hrebt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Haq ti hnài roc hnim tagop qyoh da mangai Juda. ");
INSERT INTO hrebt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","I mòeq hì, jò Chuaq Jesus yòng ti haqmai hlŏng Gêne-saret, ƀài mangai bàc raya oe dudan dahnen dabau hu tamàng bàu Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Haq hnoq i baiq toq boang oe ti haqmai diac, cla mangai ranang khoe loh qnheo hlàm ta diac. ");
INSERT INTO hrebt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Baiq toq boang aih haq hi tŏc ta moeq toq, aih boang da Simôn, thê haq qnoh tadrùq toq biaq, èh haq hangui ta boang đòeq hu hnài wì. ");
INSERT INTO hrebt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jò khoe hêq ka hnài haq thê Simôn: “Chùng boang qnoh tanòe diac jrùq tau đòeq caqnìh hlàm hu rùp ka.” ");
INSERT INTO hrebt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simôn padreo bàu: Mangai hnài, nhèn broq khoe lep qngah moeq mang ìq, ùh lòm jah qmòe cleq. Mahaq ìh khoe doe qmang aih, òq nhèn tang hlàm. ");
INSERT INTO hrebt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wì caqnìh hlàm ta diac jah ka pi cajaq, hlàm wì haq ten tapot, ");
INSERT INTO hrebt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","aih wì haq hi gwàih tì dèh ka bua oe ta boang qnoeq trùh, đòeq wiang ti wì haq, ka bình baiq toq boang, boang loh qmòe ka enh cram. ");
INSERT INTO hrebt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jò Simôn hnoq qmang aih, haq hacùn cràng enh ngèa ka Chuaq Jesus: Chuaq au! Ìh wia hangai ka au beq, au kô mangai bình toq yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Majah qmang aih haq xam ƀài dèh bua oe ti haq, hnoq jah hrìn ka, maleq mameh loh ka crè dŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Chuaq Jesus doe ka Simôn: “Apaq yùq cleq, pang kô ta èh, ìh jah wìa mangai tang hlàm mangai”. ");
INSERT INTO hrebt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Khoe ka atŏc boang tago, wì hi cađac dìq dŏng đòeq hu tiaq haq. ");
INSERT INTO hrebt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jò Chuaq Jesus qnang oe tanòe plài tau, i moeq ngai bacùn dìq tachac, trùh bla op dèh hadrò taqneq rai dang: Waiq Chuaq, tàng ìh ma waq broq, ìh broq au brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chuaq Jesus hnhu tì bèq haq aih, rai doe: “Au enh, brêh beq!” Tajòe hloe jò aih kan bacùn hi brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chuaq Jesus tanap ka haq: “Paq anoe ka cabô loq, mahaq ìh khoe brêh qmat drah lam patô rađeh ka ƀài pajàu, rai dèch ramènh tiaq bàu Môise khoe thê, đòeq patô ka wì hnoq.” ");
INSERT INTO hrebt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yiniq Chuaq Jesus chàc rai èh rai hangai, bàc mangai trùh hu tamàng, rai đòeq haq broq ka wì jah brêh ka yinìq. ");
INSERT INTO hrebt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mahaq Chuaq Jesus xan lam tanòe hawit đòeq hu waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","I mòeq hì, Chuaq Jesus qnang hnài, i ƀiaq ngai Pharisi xam ƀài mangai hnài ranenh trùh hangui ta aih, wì haq loh enh ƀài plài tagùng Galili, gùng Juđê xam Jêrusalem. Cwìang itai Boc Plình oe ti Chuaq Jesus broq brêh ka mangai yinìq. ");
INSERT INTO hrebt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jò aih, i wì tòng aràng moeq ngai pen kùi ta dradrah, chaq trong đòeq qmùt haq enh ngèa Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mahaq taiq mangai bàc hrình, pì qnì qmùt qmòe trong leq, dài wì majah àu atŏc haq aih ta crŏng hnim, doeh kùa po, qnhùa qnoh haq aih oe ta dradrah taqne wì mangai bàc ta aih, tajang hloe ka ngèa Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chuaq Jesus hnoq manoh lùi wì aih, haq doe ka mangai pen: “Yôiq kon, yiniq lui kon khoe jah caqnaih.” ");
INSERT INTO hrebt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ƀài mangai hnài ranenh xam mangai Pharisi hèm dèh ta manoh: Cleq meh ìq cabô, mangai tapoch ùh hòq, enh gùng ka Boc Plình oe i cabô majah baclaih yiniq lui? ");
INSERT INTO hrebt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Chuaq Jesus loq ka manoh wì hèm cleq, haq bòch “Hagleq pì majah hèm qmang aih ta manoh? ");
INSERT INTO hrebt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Manòeq kô doe: Yiniq lui ìh khoe jah caqnaih, tàng ùh meh doe yòng lam beq, aih maleq ma yi hlàu ka capoch? ");
INSERT INTO hrebt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mahaq au dôq pì loq Kon Mangai oe ta crŏng taneh i cwìang caqnaih yiniq lui.” Haq doe ka mangai pen “Au thê ìh, yòng, dèch dra drah qmat hlài ta hnim beq.” ");
INSERT INTO hrebt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mangai pen padinh yòng enh ngèa ka wì hloe jò aih raq, binh dèh dradrah haq ma kùi hlài ta hnim, rai manè apôi Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rìm ngai tadèch qmòe nòeh rai manè Boc Plình rai crè tarìt wì doe: Hì kô joq bèn khoe hnoq trong joq dìq jaq halac! Acaq moeq qmang ti mangai i yiniq lui ");
INSERT INTO hrebt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Atìq ka aih, Chuaq Jesus loh enh gùng, hnoq moeq ngai, broq mangai yŏc thèq, yiniq haq Lêwi, qnang haqngui tanòe hnim yŏc thèq. Haq creo ka mangai aih: “Lam tiaq au.” ");
INSERT INTO hrebt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lêwi cađac dìq dŏng, padinh yòng tiaq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lêwi broq yiniang kàn ta hnim rađeh padon ka Chuaq Jesus, i bàc ngai yŏc thèq xam ƀài mangai qnoeq haqngui acaq pajùm. ");
INSERT INTO hrebt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ƀài mangai Pharisi xam mangai hnài ranenh mamùc ka mangai tiaq hŏc Chuaq Jesus: Hagleq pì ma acaq pajùm ti mangai yŏc thèq xam mangai i yiniq lui? ");
INSERT INTO hrebt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chuaq Jesus doe ka wì: “Mangai tadêh ma i nhet ka chaq mangai broq jreo, mangai ùh hrŏc ma nhet.” ");
INSERT INTO hrebt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Au ùh xài trùh đòeq creo ka mangai taq atoq, mahaq creo ka mangai i yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wì anoe ka haq: Mangai tiaq hŏc da Jon xan apàm ka acaq đòeq waiq khàn, èh mangai tiaq hŏc da mangai Pharisi hadai, ùh xài qmang ka mangai tiaq hŏc da ìh toq acaq toq ôq. ");
INSERT INTO hrebt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Haq padreo bàu: “Jò cla kon ŏng oe raq dèh ti bua, trùh lem bùi hì yiniang haq, wìa ka pì ma thê wì apàm ka acaq? ");
INSERT INTO hrebt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mahaq trùh hì wì ma qnung kon ŏng lam hangai ka wì, ƀài hì aih èh wì men apàm ka acaq.” ");
INSERT INTO hrebt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Haq alìah ka wì qmang kô: “Ùh i cabô hit mòeq calep eo neo đòeq clep ka eo dùnh. Tàng broq qmang aih, eo neo loh ka hyah, èh haqnech maneo hadai ùh tajì ka eo dùnh. ");
INSERT INTO hrebt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hadai ùh i cabô ùc alac neo ta ƀau akia dùnh, broq qmang aih, alac neo broq ka ƀau akia dùnh hađah, alac taùc, ƀau akia hadai pi wìa waq. ");
INSERT INTO hrebt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Alac neo ep ùc ta ƀau akia neo. ");
INSERT INTO hrebt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hanoh ùh i mangai leq khoe ôq alac dùnh èh bòch alac neo, majah qmang aih haq doe: alac dùnh yeo jìang”. ");
INSERT INTO hrebt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","I moeq yàng, wop hì sabat Chuaq Jesus lam pagat trong ruàng qmau, mangai tiaq hŏc git hadròc qmau rai tuta hu kaq. ");
INSERT INTO hrebt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ƀài mangai Pharisi bòch: Hagleq pì majah broq trong ùh troq ta hì Sabat? ");
INSERT INTO hrebt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chuaq Jesus doe ka wì: “Pì ma qnhòq đŏc Đawit broq cleq jò haq xam mangai tiaq haq hadai pangot qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Haq mùt ta hnim Boc Plình, yŏc ƀênh ta aih qnoh acaq rai am dèh ka bua, ƀênh aih toq pajàu ma khòh acaq. ");
INSERT INTO hrebt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Haq doe hòm: Kon Mangai aih Chuaq hì Sabat”. ");
INSERT INTO hrebt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hì sabat qnoeq hòm, Chuaq Jesus mùt hnài ta hnim tagop qyoh. Ta aih i moeq ngai angwenh tì pah qma. ");
INSERT INTO hrebt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ƀài mangai hnài ranenh xam mangai Pharisi qnang ti chaq yiniq đòeq rùp Chuaq Jesus, wì ti ngan ta hì sabat haq i broq brêh ùh. ");
INSERT INTO hrebt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mahaq Chuaq Jesus loq ka wì aih qnang hèm trong leq, haq doe ka mangai angwenh tì: “Yòng beq, yòng oe taqne kô.” Mangai aih hi yòng oe taqne wì ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aih èh Chuaq Jesus hi doe: “Au bòch pì: Maleq ranenh ma am broq tahì sabat, khòh broq trong lem loq broq trong qmèq? jêh đac mangai loq dèch mangai?” ");
INSERT INTO hrebt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Haq ti ngan dudan dìq ka wì ta aih, khoe èh haq doe ka mangai angwenh tì: “Bahnhoh tì ìh qmat.” Mangai aih broq tiaq qmang bàu, tì haq hi jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mahaq mangai Pharisi xam mangai hnài ranenh wì nòeh pi cajaq, wì bòch dabau broq qmang leq ka Jesus kô èh. ");
INSERT INTO hrebt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Oe ta ƀài hì aih Chuaq Jesus tŏc ta wang waiq khàn, haq rìu qngah ka mang aih đòeq waiq khàn ka Boc Plình ");
INSERT INTO hrebt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Trùh qngah sroq èh, haq creo dèh mangai tiaq hŏc, haq ràih moeq jàt baiq ngai, đòeq broq mangai Tiaq cla: ");
INSERT INTO hrebt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Haq yiniq ka Simôn aih Phiero, Anrê oh Simôn, Jaco xam Jon, Philip xam Bathê-lemi, ");
INSERT INTO hrebt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathio xam Thôma, Jaco kon Aphê, Simôn wì ma creo Xêlot, ");
INSERT INTO hrebt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juđe kon Jaco, xam Juđa Ica-riôt, mangai ma blòq Chuaq Jesus atìq kô èh. ");
INSERT INTO hrebt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Khoe aih, Chuaq Jesus xam mangai tiaq hŏc loh enh wang, wì oe tanòe tamang, ta aih i bàc ngai tiaq hŏc xam bàc ngai trùh enh gùng Juđê, Jêrusalem, xam trong diac Tiro, Siđôn, trùh tamàng bàu haq hnài rai dôq haq broq wì jah brêh kan yinìq tôq. ");
INSERT INTO hrebt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ƀài mangai kiac mùt ta chac hadai jah brêh dŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dìq dŏng ka mangai bàc ta aih ti àu bèq haq, majah qmang aih i kan itai loh enh chac haq, broq ka bàc ngai jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chuaq Jesus ngan dèh mangai tiaq hŏc, rai doe: “Xôq ramot am ka mangai pa, majah qmang aih diac Plình aih da pì. ");
INSERT INTO hrebt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Xôq ramot am ka mangai qnang pangot, majah qmang aih pì jah panàc, Xôq ramot ka qnang crò hmoe, majah qmang aih pì jah do lem bùi! ");
INSERT INTO hrebt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Xôq ramot am ka pì, jò wì git ka pì, hnan qnoh pì, hnap hnuq ka pì, cađac yiniq pì tìah kan amùa! Taiq pì tiaq au! ");
INSERT INTO hrebt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hì aih, thê pì lem bùi, ti aplôh rai manè, majah qmang aih kan baha pì oe ta Plình èh kàn haraya: Majah qmang aih, kan cadraq wì haq calah nèh hadai khoe tabroq ka ƀài mangai pajàu qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mahaq haƀo ka pì mangai ma padrŏng, majah qmang aih pì khoe jah qmòe dèh kan alòng! ");
INSERT INTO hrebt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Haƀo ka pì, mangai qnang panàc, majah qmang aih pì jah pangot! Haƀo ka pì mangai qnang lem bùi, majah qmang aih pì jah hmoe ta-oeh ka kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Haƀo ka pì mangai qnang jah bàc ngai tapoch manè, majaq qmang aih kan cadraq wì haq calah nèh hadai broq ka ƀài pajàu patìah qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mahaq au doe ka pì aih ƀài mangai qnang tamàng bàu au: Thê loq waq ka mangai tablêq ka pì, broq lem ka mangai git ka pì. ");
INSERT INTO hrebt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Waiq xôq ramot am ka mangai hanip pì, waiq khàn am ka mangai tapoch qmèq ka pì. ");
INSERT INTO hrebt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Cabô tep da pì tabŏc pah kô, hnhu hloe ka wì haq tabŏc pah tau, cabô hrùiq da pì eo enh gùng, dôq haq wì yŏc hloe da pì eo enh dalam. ");
INSERT INTO hrebt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tàng cabô bòch cleq, drah am, tàng i cabô blah yŏc da pì cleq, apaq bòch yŏc hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pì enh wì broq ka rađeh qmang leq, pì ep broq ka wì qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tàng pì loq waq toq mangai ma loq waq ka pì, aih ma ep pòq dòeh cleq? Mangai i yiniq lui hadai loq waq ka mangai loq waq ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tàng pì toq hanò ka magai loq hanò ka pì, aih ma i pòq dòeh cleq? Mangai broq yiniq lui hadai qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tàng pì am đò ka wì qnoeq cleq, mahaq toq ngèh ka wì am hlài, aih ma i pòq dòeh cleq? Mangai i yiniq lui hadai am ka mangai i yiniq lui ti lình, đòeq hu jah yŏc hlài xam xèm xam goe. ");
INSERT INTO hrebt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mahaq thê pì loq waq ka mangai tablêq ka pì, loq hanò ka wì, loq am ka wì, apaq ngèh ka yŏc hlài cleq enh wì. Aih èh kan baha ka pì kàn joq qnàng, aih pì jah broq kon da Mangai dìq Jaq haqnhèq, majah qmang aih haq hanò ka mangai gôpla xam mangai broq dù. ");
INSERT INTO hrebt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Thê pì loq waq tìah ka Baq pì aih Mangai ma xan loq waq. ");
INSERT INTO hrebt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Apaq ti hadrah dèh cabô, èh pì ùh hìaq pòq kan hadrah, apaq taqmòq yiniq lui ka cabô, aih wì hadai ùh hìaq taqmòq yiniq lui ka pì. Thê cađac da wì qnoeq yiniq lui, aih wì hadai cađac da pì yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Am beq, aih èh wì hadai am hlài ka pì, èh wì yŏc cađap kàn, xàu dôq haq nhet, tŏng qmòe ka bình, tah tam ta eo pì, majah qmang aih pì dèch ka wì maneh leq, wì hadai dèch hlài maneh aih. ");
INSERT INTO hrebt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Haq hadai capoch alìah hu hnài wì rameh: “Mangai ùh xau qnung mangai ùh xau ajah? Ùh xài dìq baiq ka wa aih clìh ta ralùng qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mangai tiaq hŏc ùh yeo haqnhèq ka mangai hnài, mahaq mangai tiaq hŏc leq ma gêh geo, aih èh haq jah tìah dèh mangai hnài. ");
INSERT INTO hrebt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Gleq ìh hnoq criah ta mat oh daq ìh, mahaq ùh hnoq long ban ta mat cla? ");
INSERT INTO hrebt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ìh doe dèh ka oh daq: Aleq dôq au doeh criah ta mat ìh, mahaq ùh hnoq dèh long ban ta mat cla! pì capoch dèh qmang leq majah? Wùih! ƀài mangai patìah toq enh gùng meh! doeh long ban loh enh mat cla qmat adroe, aih èh men xau hnoq hu doeh criah ta mat oh daq. ");
INSERT INTO hrebt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Long loh plì qmèq aih ùh xài long lem, long loh plì lem aih ùh xài long qmèq ");
INSERT INTO hrebt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","majah qmang aih ngan plì ma canau ka long. Ùh i cabô git plì pŏc ta yila, ùh i cabô git plì nho ta brech. ");
INSERT INTO hrebt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mangai ta manoh haq bình trong lem, hloh bàu rangot lem, mangai dù ta manoh bình trong dù, hloh bàu dù, majah qmang aih khoe bình ta manoh men hloh ajang bàu. ");
INSERT INTO hrebt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hagleq pì creo ka au: Chuaq, Chuaq, mahaq ùh dùh ka broq tiaq bàu au? ");
INSERT INTO hrebt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kô au patô ka pì loq mangai trùh ti au, tamàng bàu au, broq tiaq bàu au, aih èh haq tìah ka cabô. ");
INSERT INTO hrebt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Haq aih tìah ka mangai broq hnem, chìa jrang cajrùq, dèch hnem enh crŏng hmo talech: Diac tŏc, diac dêh glàm ta hnim aih, mahaq ùh dalàc, majah qmang aih broq khoe cajap. ");
INSERT INTO hrebt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yàng mangai leq tàng bàu au mahaq ùh broq tiaq, haq aih tìah ka mangai broq hnim ta taneh ùh i ka xèm, diac dêh glàm ta hnim aih, moeq ayàc raq khoe ralàih, raliang dìq dŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jò khoe hêq ka hnài bàu aih, Chuaq Jesus mùt ta Caƀênaum. ");
INSERT INTO hrebt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Cwan lình tagùng aih i moeq ngai hapŏng haq dìq jaq loq waq, qnang ùh hrŏc ten cachìt, ");
INSERT INTO hrebt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","tàng wì anoe i Chuaq Jesus trùh, cwan thê wì gucraq mangai Juđa lam canòm ka Chuaq Jesus broq brêh dèh ka hapŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wì aih trùh ti Chuaq Jesus, wì doe: Cwan kô troq ka ìh dì bàu haq, ");
INSERT INTO hrebt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","majah qmang aih haq loq waq ka mangai bèn, khoe broq am ka nhèn hnim tagop. ");
INSERT INTO hrebt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chuaq Jesus lam ti wì aih. Jò ten trùh hnim, cwan aih thê dèh bua lam anoe ka Chuaq Jesus: Waiq Chuaq! Ìh ùh dùh baxa hrìn rađeh, majah qmang aih au ùh tajì ka đìh Ìh mùt dèh ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Au hadai khoe hèm rađeh kô qnhòq tajì ka trùh ti ìh. Mahaq ìh tapoch toq bàu raq brì ka hapŏng au brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Majah qmang aih au kô hadai oe enh qneq ka cwìang wì qnoeq, au hanoh i lình enh qneq ka cwìang au diq, au doe ka mangai kô: Lam beq! haq aih hi lam, thê mangai qnoeq: Trùh tacô! haq hi trùh, au thê dèh hapŏng: Broq yiniq kô! haq hi broq. ");
INSERT INTO hrebt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jò Chuaq Jesus tàng bàu aih, hamàih dèh ta manoh, Haq hwi ngan ƀài mangai lam tiaq rađeh, haq doe: “Au doe ka pì, oe ta Isorali, au qnhòq lah hnoq mangai leq i kan lùi kàn dàng kô.” ");
INSERT INTO hrebt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Khoe aih, ƀài mangai cwan ma thê wì lam aih, wìh hlài ta hnim, hnoq mangai hapŏng khoe brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hì atìq, Chuaq Jesus lam ta plài Na-in, mangai tiaq hŏc xam bàc mangai lam tiaq haq. ");
INSERT INTO hrebt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jò haq bu trùh gàu plài, hnoq wì tòng qnoh moeq ngai cachìt, aih kon calô gucadrì hadrô ta plài aih, haq i dèh moeq toq kon aih raq, bàc ngai ta plài aih wiang lam ti mangai hadrô aih. ");
INSERT INTO hrebt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jò Chuaq Jesus hnoq, tamanoh haq ha-och ka mangai miq aih, haq doe: “Apaq hmoe.” ");
INSERT INTO hrebt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Khoe aih, Chuaq Jesus thia haten, haq bèq hom, ƀài mangai tòng hanang hi yòng. Haq hi doe: “Mangai radam meh, au thê oh yòng beq.” ");
INSERT INTO hrebt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mangai cachìt padinh hangui rai tapoch tuàng, khoe aih Chuaq Jesus hi am da miq haq. ");
INSERT INTO hrebt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mangai leq mangai meh crè đeh hra, rai manè apôi Boc Plình rameh: I moeq pajàu kàn khoe loh taqne bèn. Boc Plình khoe trùh đòeq wiang dèh ti mangai da Haq. ");
INSERT INTO hrebt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bìac aih, wì anoe jàp cròng Juđê xam gùng dudan ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mangai tiaq hŏc da Jon taqmon dìq dŏng ƀài yiniq aih ka Jon. ");
INSERT INTO hrebt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jon creo dèh wa baiq ngai ma tiaq hŏc rađeh, thê wa lam trùh ta Chuaq Jesus hu bòch: Ìh ajoq mangai đòeq trùh tacô, nhèn ahìaq ep gòm mangai qnoeq hòm? ");
INSERT INTO hrebt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jò wa aih trùh ta Chuaq Jesus, wa doe: Jon Baptit thê ma trùh bòch: Ìh ajoq mangai đòeq trùh tacô loq nhèn ep gòm mangai ma qnoeq? ");
INSERT INTO hrebt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wop jò aih Chuaq Jesus broq brêh bàc ngai yinìq, ùh hrŏc, mangai i kiac dù mùt ta chac, rai broq bàc ngai ùh xau jah hnoq. ");
INSERT INTO hrebt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chuaq Jesus padreo bàu ka wa: “Hlài anoe ka Jon loq rìm yiniq chôp khoe hnoq, khoe tàng: Mangai ùh xau jah hnoq, mangai liap jah lam, mangai bacùn jah hreo, mangai clìc jah tàng, mangai cachìt jah rìh hlài, mangai pa jah tamàng Bàu lem. ");
INSERT INTO hrebt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Xôq ramot ka mangai leq ùh hìaq catoeh ka au.” ");
INSERT INTO hrebt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jò wa aih khoe lam, Chuaq Jesus hi anoe trùh Jon dôq ƀài mangai bàc ma lam tiaq haq tàng: “Pì khoe lam ngan cleq taqnòe hawit? Pì lam ngan triang niaq cayeo ma hlui qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ùh qmang ai pì lam ngan cleq hòm? Ngan mangai caxùnh eo lem qmòh? Hatau wì ma caxùnh eo canaq, mangai oe acaq rahù dìq oe ta hnim bùa. ");
INSERT INTO hrebt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mahaq pì lam ngan cleq hòm? Mangai pajàu qmòh? Joq au anoe ka pì ùh hnau ka pajàu hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kô raq mangai ma khoe i bàu achìh trùh haq: Kô au thê dèh mangai wê bàu lam adroe ka Ìh, Haq aih èh ma palauq da ìh trong enh ngèa ka Ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Au anoe ka pì, dìq dŏng ka ƀài mangai gucadrì ma hauang qnoh, ùh i mangai leq yeo kàn ùh hnau ka Jon, mahaq oe ta diac Boc Plình, mangai yac ka qyoh dàng leq, dua haq yeo kàn ùh hnau ka Jon. ");
INSERT INTO hrebt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dìq dŏng ka ƀài mangai ta aih hloe xam mangai yŏc thèq khoe jah Jon broq baptem, wì tàng bàu Chuaq Jesus hnài, mangai leq mangai meh dìq doe Boc Plình aih taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mahaq mangai Pharisi xam mangai hnài ranenh chàih cađac trong Boc Plình enh taqmroq ka wì haq, majah qmang aih wì ùh waq Jon broq ƀaptem ka dađeh. ");
INSERT INTO hrebt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chuaq Jesus doe: Au alìah wì qnhòng kô tìah ka cabô? ");
INSERT INTO hrebt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wì haq tìah ka wì qyoh hangui ta nòe atech, doe ka dabau: Nhèn khoe hlui taliaq, gleq pì ma ùh ti cađoeq, nhèn khoe ti calêu atoch gleq pì ùh crò hmoe. ");
INSERT INTO hrebt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon khoe trùh, haq ùh acaq ƀênh ùh ôq alac, aih pì doe: I kiac dù oe ta chac haq. ");
INSERT INTO hrebt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kon Mangai trùh, haq acaq haq ôq, aih pì doe: Meh mangai plai toq ka acaq, daiq ka ôq, taqmùt ti ƀài mangai yŏc thèq xam ƀài mangai i yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mahaq kan khun rabiaq aih jah creo ka haq taq atoq canòm ajang yiniq broq da wì haq.” ");
INSERT INTO hrebt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","I moeq ngai Pharisi akhen ka Chuaq Jesus trùh acaq dèh ta hnim, jò khoe mùt ta hnim, Chuaq Jesus hi hangui. ");
INSERT INTO hrebt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tagùng aih, i moeq ngai gucadrì rìh ùh wìa, hìa doe Chuaq Jesus qnang hangui acaq ta hnim mangai Pharisi, haq aràng moeq toq cabi ngŏc tabŏc enh dalam tah bình dàu xua thùm. ");
INSERT INTO hrebt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Haq yòng đeh enh rù ajang nòe jènh Chuaq Jesus, crò hmoe, diac mat taclìh ta jènh Chuaq Jesus, khoe èh haq yŏc dèh xàc gàu hi xùt, èh haq hìp jènh Chuaq Jesus, khoe aih haq xùt dàu ta jènh Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mangai Pharisi ma akhen ka Chuaq Jesus, hnoq qmang aih, haq hèm dèh ta manoh: Mangai kô tàng haq joq pajàu, aih wìa ka haq ùh loq ka mangai gucadrì ma bèq rađeh aih cabô, wìa ka haq ùh loq ka gucadrì qmat mangai qmang leq, qmat xài mangai bình toq yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chuaq Jesus doe ka haq: “Simôn, au i biaq nà anoe ka ìh.” Simôn padreo bàu: Mangai hnài, ìh anoe beq. ");
INSERT INTO hrebt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“I moeq ngai aih, i baiq ngai pòq dòeh haq: moeq ngai pòq padam hrinh đoniê, moeq ngai pòq padam jàt. ");
INSERT INTO hrebt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dìq baiq ka wa ùh i cleq hu caqnaih dòeh, cla wì craq hi cađac dŏng ka wa. Taqne wa baiq ngai aih, maleq ma loq waq ka wì craq yi bàc?” ");
INSERT INTO hrebt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simôn hi tèu: Au hèm mangai leq ma khoe jah cađac yeo bàc aih, haq aih loq waq yi bàc. Chuaq Jesus doe: “Ìh hèm troq.” ");
INSERT INTO hrebt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Khoe aih, haq wìh ta gucadrì rai doe ka Simôn: “Ìh i hnoq mangai gucadrì kô? Au mùt ta hnim ìh, ìh ùh qnoh qmòe diac qnheo jènh, mahaq gucadrì kô yŏc dèh diac mat srùh jènh au, khoe èh yŏc dèh xàc gàu hu xùt. ");
INSERT INTO hrebt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ìh ùh hìp au, mahaq haq kô patep haq mùt hnim ìh, haq hìp jènh au ùh hêq. ");
INSERT INTO hrebt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ìh ùh xùt dàu ta gàu au, yàng da haq kô yŏc dàu xua thùm xùt ta jènh au. ");
INSERT INTO hrebt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aih ìq au majah doe ka ìh, yiniq lui mangai gucadrì kô bàc joq qnàng, khoe jah caqnaih dìq dŏng, majah qmang aih haq khoe loq waq yeo bàc, yàng da mangai jah caqnaih yeo biaq, haq loq waq yeo biaq.” ");
INSERT INTO hrebt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chuaq Jesus doe ka mangai gucadrì: “Yiniq lui ìh khoe jah caqnaih dŏng.” ");
INSERT INTO hrebt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ƀài wì ma hadai hangui acaq moeq qmang ta aih hèm ta manoh: Mangai kô ìq cabô ma doe rađeh i cwìang caqnaih yiniq lui? ");
INSERT INTO hrebt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mahaq Chuaq Jesus doe ka mangai gucadrì aih: “Kan lùi ìh khoe dèch ìh, lam ka catèm oq.”. ");
INSERT INTO hrebt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Atìq ka aih, Chuaq Jesus lam enh gùng kô trùh gùng tau, enh plài kô trùh plài qnoeq, anoe hnài Bàu lem lem da diac Boc Plình. I moeq jàt baiq ngai tiaq cla oe ti haq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Èh hadai i wì gucadrì lam tiaq haq, aih la ƀài mangai khoe jah paclaih enh kiac dù, khoe jah brêh ka yinìq: Mari, wì ma creo Mađolen, tapèh toq kiac dù loh enh chac haq, ");
INSERT INTO hrebt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jan-no, cadrì da Chu-sa, aih cwan wèq ta hnim bùa Hêrôt, Su-sana xam bàc ngai qnoeq hòm wiang dèch bac jènh ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jò ƀài mangai bàc tagop ti dabau xam mangai enh rìm plài trùh dìq ta Chuaq Jesus, haq hi yŏc bàu alìah hu hnài wì: ");
INSERT INTO hrebt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“I moeq ngai lam rai dèh adrech. Jò rai, moeq qnah clìh ti trong, aih wì hi troq jôiq èh chìm enh qnhèq loh jôh dŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Moeq qnah clìh ta taneh raga, bu hon ma loq khoe croh majah qmang aih ùh i đeh toq biaq hnha kan da-ìm. ");
INSERT INTO hrebt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Maqnoeq taclìh taqne xèm yila, haq hon pajùm ti yila, haq toq hlac loh ka pi jah kàn. ");
INSERT INTO hrebt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Adrech ma qnoeq clìh tanòe taneh lem. Haq hon lem, loh hadròc, moeq jah moeq hrinh. Jò anoe qmang aih haq doe: “Mangai leq i don, tamàng beq.” ");
INSERT INTO hrebt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mangai tiaq hŏc bòch haq bàu alìah aih anoe cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Haq doe: “Kan hlèp tanòe diac Plình khoe am pì loq, yàng wì qnoeq aih yŏc bàu alìah hu anoe, dôq wì ngan manhaq ùh hnoq cleq, tamàng mahaq ùh qnì tàng. ");
INSERT INTO hrebt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bàu alìah aih rameh: Adrech aih bàu Boc Plình ");
INSERT INTO hrebt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Adrech taclìh ti trong, aih ƀài mangai tàng bàu, yàng atìq ka aih kan kiac trùh tablah yŏc bàu ta manoh cliac wì haq, yùq wì haq lùi èh loq jah dèch qmòh. ");
INSERT INTO hrebt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Adrech taclìh nòe raga, aih bài mangai bu tàng bàu khoe lem bùi yŏc bàu aih, mahaq ùh i ka riah. Wì lùi moeq rayàc, jò i kan khech tàt, wì haq hi talùi. ");
INSERT INTO hrebt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Adrech taclìh ta yila, aih ƀài mangai tàng bàu, mahaq tiaq dèh manoh kan loq lèt kan padrŏng kan rìh qmòe ka hlàu toq taqnhòng kô, broq ka bàu aih pi jah chet, pi loh qmòe plì ma yi wìa. ");
INSERT INTO hrebt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mahaq adrech taclìh tanòe taneh lem aih ƀài mangai i manoh cliac lem joq qnàng, ƀài mangai tàng bàu, rai cajap manoh wèq bàu aih hi jah loh plì. ");
INSERT INTO hrebt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ùh i cabô bùh đen èh yŏc griang gùp cađac, tàng ùh meh cadoc ta caqnàm, mahaq dèch tanòe haqnhèq, dôq cabô mùt ta hnim dìq jah hnoq kan qngah. ");
INSERT INTO hrebt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Majah qmang aih ùh i cleq hlèp, èh ma ùh hnoq, ùh i cleq cadoc èh wì ma ùh loq, ma ùh hìa ep patô qnoh. ");
INSERT INTO hrebt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Qmang aih pì ep tamàng ma rabiaq bàu pì tàng majah qmang aih mangai khoe i, èh jah am tam, mangai leq ùh i, aih èh jah doeh yŏc hloe yiniq cleq haq xoh đeh khoe i.” ");
INSERT INTO hrebt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jò aih, miq da Chuaq Jesus xam wì oh haq lam chaq haq. Yàng mangai bàc hrình, ùh jah thia haten ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","I mangai lam anoe ka haq: Miq ìh xam wì oh ìh oe enh gùng, enh glàm ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mahaq Chuaq Jesus padreo bàu “Miq au xam oh daq au aih ƀài mangai tàng bàu Boc Plình rai broq tiaq bàu aih”. ");
INSERT INTO hrebt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","I moeq hì, Chuaq Jesus loh taboang ti mangai tiaq hŏc, haq doe: “Beq bèn tŏc pah tau hlŏng”; khoe wì hi lam. ");
INSERT INTO hrebt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jò boang qnang cadàu, Chuaq Jesus kùi. I bahùt trùh ta hlŏng aih, diac bình taboang, qnang jò yat dìq jaq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mangai tiaq hŏc tùh padrìu haq: Mangai hnài, mangai hnài, bèn cachìt manòeq kô raq! Mahaq jò haq bu yòng, haq tagàih ka cayeo xam diac dôq wa hatinh, aih wa hi hatinh hatot hloe. ");
INSERT INTO hrebt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Haq doe ka mangai tiaq hŏc: “Manoh lùi pi taleq hòm.” Mangai tiaq hŏc rai crè rai hamàih, bòch dabau: Mangai kô ìq cabô, jaq cayeo xam diac dìq iu dŏng bàu haq? ");
INSERT INTO hrebt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Khoe aih wì trùh tagùng mangai Jêrasê, tajang ka gùng Galili. ");
INSERT INTO hrebt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jò Chuaq Jesus tŏc tago, tagùng aih i moeq ngai bàc kiac tachac haq. Khoe dùnh, haq pi lah caxùnh eo, pi lah oe ta hnim, mahaq oe ta cadràng hanang. ");
INSERT INTO hrebt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bu hnoq Chuaq Jeus, haq aih cajiah ta gruàng, rai pacro dađeh anòe jènh Chuaq Jesus, haq tapoch qmòe cadêh: Ìh enh broq ka au cleq kô ìq, Chuaq Jesus kon da Boc Plình haqnhèq au waiq ìh ùh dùh baxa au dèh. ");
INSERT INTO hrebt_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Majah qmang aih, Chuaq Jesus i thê kiac dù aih loh ma khoe ka mangai kiac rùp khoe dùnh aih. Yac ka wì tàt haq, kàt, clang jènh tì haq, dua haq hràt cađac caxi mem, wah cađac long clang, kiac qmùt haq tanòe hawit. ");
INSERT INTO hrebt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chuaq Jesus bòch haq: “Gè yiniq cleq?” haq padreo bàu: Ƀài lình, majah qmang aih bàc toq kiac khoe mùt tachac haq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wì haq cali calo ka Chuaq Jesus apaq caqnìh wì haq kòe jrùq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jò aih i meq calùh chùa qnang acaq tawang. Ƀài kiac bòch Chuaq Jesus am wì haq jah mùt đeh ta calùh chùa aih, Chuaq hi am. ");
INSERT INTO hrebt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ƀài kiac loh enh mangai aih, mùt ta calùh chùa, calùh chùa oe enh bùc haqnhèq cadàu hatàp gàu ta hlŏng cachìt dìq dŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ƀài mangai ban chùa hnoq qmang aih, drah cadàu lam amot, rai anoe yiniq aih jàp rìm gùng rìm plài ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wì dahrôq loh ngan, jò wì haq trùh tanòe Chuaq Jesus, hnoq mangai kiac neo loh enh haq aih qnang hangui nòe jènh Chuaq Jesus, sràp eo cwàn, gàu ngoc prau prình, wì yùq pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ƀài mangai ma khoe hnoq kan halac aih, anoe ka hlài jàp ka phù cròng loq mangai kiac rùp aih khoe jah brêh qmang leq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dìq dŏng mangai oe ta gùng Jêrasê cali calo doe ka Chuaq Jesus đòeq haq lam đac tagùng qnoeq, majah qmang aih wì crè pi cajaq. Haq loh taboang wìh hlài pah tau. ");
INSERT INTO hrebt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mahaq mangai kiac ma khoe cadàu loh enh chac, haq bòch tiaq Chuaq Jesus, mahaq Chuaq Jesus thê haq hlài, Chuaq Jesus doe ka haq: ");
INSERT INTO hrebt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hlài ta hnim hu anoe ka wì dôq wì loq Boc Plình khoe broq am ka ìh cleq.” Qmang aih, haq hi lam rai anoe hlài rìm yiniq Boc Plình khoe broq am ka rađeh jàp rìm gùng. ");
INSERT INTO hrebt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jò wì wìh hlài, i bàc ngai đìh Chuaq Jesus, majah qmang aih mangai leq mangai meh ngèh đeh hra ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","I moeq ngai wèq hnim tagop qyoh yiniq haq Jairu trùh bla op nòe jènh Chuaq Jesus, cali calo canòm ka Chuaq trùh dèh ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Majah qmang aih haq i moeq ngai kon cadrì moeq jàt baiq hanam khoe ten cachìt. Jò Chuaq Jesus lam ti trong bài wì dahnen dudan ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jò aih i moeq ngai gucadrì yinìq khoe moeq jàt baiq hanam dahrôq mahim, bac jènh haq khoe yam dìq dŏng ka ƀài mangai broq jreo, mahaq ùh i ka mangai leq haqnauq haq brêh, ");
INSERT INTO hrebt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","haq trùh enh rù bèq haqmai eo Chuaq Jesus, tajòe qmòe mahim haq hi xŏt. ");
INSERT INTO hrebt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chuaq Jesus doe: “Cabô khoe bèq au?” mangai leq mangai meh haqngah đeh hra, Phiero xam bua haq doe: Mangai hnài, mangai bàc ti dudan rai hnen ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Chuaq Jesus doe: “I mangai khoe bèq au, au tàng i padren loh enh chac au. ");
INSERT INTO hrebt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mangai cadrì aih hnoq dađeh cadŏc pi hlèp, haq tarìt thia bla op dađeh ta haqneq ajang nòe jènh Chuaq Jesus enh ngèa mangai bàc, haq anoe dŏng hagleq đeh majah bèq haqmai eo Chuaq Jesus, èh manòeq rađeh khoe jah brêh qmang leq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mahaq Chuaq Jesus doe ka haq: “Yôiq kon cadrì au, manoh lùi kon khoe broq kon jah brêh, lam ma catèm beq.” ");
INSERT INTO hrebt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chuaq Jesus oe raq capoch, i mangai loh enh hnim Jairu, craq wèq hnimtagop qyoh doe ka haq: Kon cadrì ìh khoe cachìt, oe pangài dèh ka haq qmat hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tàng bàu aih, mahaq Chuaq Jesus doe ka Jairu: “Apaq yùq! toq lùi raq, aih èh kon ìh hi jah brêh.” ");
INSERT INTO hrebt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jò khoe trùh ta hnim, Chuaq Jesus am toq Phiero, Jaco, Jon xam wa miq baq kon qyoh aih mùt tiaq haq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jò meh dìq ka mangai ta aih ta-oeh ti atoch ka kon mangai aih, Chuaq Jesus doe: “Hêq pi dùh hmoe! Kon mangai kô ùh xài haq kachìt, haq qnang kùi.” ");
INSERT INTO hrebt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wì do ka haq, majah qmang aih wì loq kon mangai aih joq khoe cachìt. ");
INSERT INTO hrebt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mahaq Chuaq Jesus carùp tì kon cadrì qyoh aih rai doe “Kon au, yòng beq!”. ");
INSERT INTO hrebt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mahua yiang mùt hlài tachac, haq hi padinh yòng. Khoe aih Chuaq Jesus thê wì qmi kon qyoh aih acaq. ");
INSERT INTO hrebt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Miq baq kon qyoh aih dìq jaq hamàih ta manoh, mahaq Chuaq Jesus ùh lòh wa anoe ka cabô loq yiniq aih. ");
INSERT INTO hrebt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Chuaq Jesus creo ka wì moeq jàt baiq ngai, haq am ka wì padren cwìang itai đòeq drùh hnan kiac chŏc, broq brêh ka mangai yinìq, ");
INSERT INTO hrebt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","khoe aih haq thê wì loh lam anoe hnài trong diac Boc Plình rai broq ka mangai ùh hrŏc jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Haq tanap ka wì: “Jò pì lam ùh dùh wê cleq, yac ka long dùi, yac ka ayôp, yac ka ƀênh, ƀac jènh, apaq wê racop baiq blah eo.” ");
INSERT INTO hrebt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pì mùt hnim leq, pì oe ta aih trùh jò loh enh plài aih, ");
INSERT INTO hrebt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","tàng wì ùh đìh ùh pachùh pì, loh enh plài aih pì hapùih blo top tajènh pì đòeq broq kan pagau am ka wì haq hnoq.” ");
INSERT INTO hrebt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Moeq jàt baiq ngai tiaq cla, loh lam enh plài kô trùh plài tau, anoe Bàu lem rìm nòe rai broq ka bàc ngai jah brêh ka yinìq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jò aih, bùa Herôt hìa wì anoe rìm yiniq Chuaq Jesus ma khoe broq, haq loh ka rawè, hèm pi hlùh, majah qmang aih i ngai doe: aih Jon, khoe rìh hlài enh cachìt; ");
INSERT INTO hrebt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","mangai qnoeq doe: Êli khoe loh, mangai qnoeq hòm doe: taqne ƀài pajàu dùnh calah nèh i moeq ngai khoe rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mahaq Hêrôt doe: Au khoe thê wì pŏt ranŏng Jon, mangai kô aih cabô hòm, gleq au ma jah tàng bàc trong haq broq? Bùa Herôt hi ti chaq nen hu glàm Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Moeq jàt baiq ngai tiaq cla wìh hlài taqmon ka Chuaq Jesus rìm yiniq wì haq khoe broq, haq qnong wì aih tiaq haq, wì lam đeh crài haten ka plài Bêtsaiđa. ");
INSERT INTO hrebt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mahaq ƀài mangai ta aih wì tàng, wì hi lam tiaq haq. Chuaq Jesus đìh wì aih, hnài dôq wì loq ka diac Boc Plình rai broq ka mangai yinìq jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Trùh mat mahì ten clìh, mòeq jàt baiq mangai tiaq cla thia haten ka Chuaq, wì doe: Ìh thê wì hlài beq, dôq wì haq ti mùt roc gùng roc plài ten dudan tacô, hu chaq nòe padài rai chaq dahwèq acaq, majaq qmang aih bèn kô qnang oe tanòe hawit. ");
INSERT INTO hrebt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mahaq haq doe ka wì: “Pì raq mangai hu qmi ka wì acaq!” Moeq jàt baiq ngai tiaq cla tèu: Tàng joq nhèn ùh lam rot dahwèq acaq am dìq ka wì tacô, nhèn i padam toq ƀênh xam baiq pliang ka raq, ");
INSERT INTO hrebt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Jah padam muàn mangai gucalô ta aih) Chuaq Jesus doe ka mangai tiaq hŏc: “Thê wì hangui tang brong padam jàt ngai.” ");
INSERT INTO hrebt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mangai tiaq hŏc broq tiaq bàu aih, thê dìq dŏng wì hangui. ");
INSERT INTO hrebt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Èh Chuaq Jesus yŏc padam toq ƀênh xam baiq pliang ka, haq qngŏc ngan ta plình, manè apôi Boc Plình khoe aih goh ƀênh. Haq am ka mangai tiaq hŏc ti axong ka mangai ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mangai leq mangai meh acaq panàc đeh hra, wì toch hlài ƀài haqnech rah jah moeq jàt baiq rajo. ");
INSERT INTO hrebt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","I moeq hì, jò Chuaq Jesus qnang waiq khàn đeh moeq ngai, mangai tiaq hŏc tagop dudan ka haq. Haq bòch: “Dìq ka ƀài mangai bàc doe au kô ìq cabô?” ");
INSERT INTO hrebt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wì padreo bàu: Mangai kô doe Jon Baptit, mangai tau doe Êli, mangai qnoeq hòm doe moeq ngai pajàu qnhòng calah nèh rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Haq bòch hòm “Ha pì, pì doe au cabô?” Phiero doe: Ìh kô Christ, kon da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Chuaq Jesus ùh lòh wì mangai tiaq hŏc anoe yiniq aih ka cabô loq, ");
INSERT INTO hrebt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Haq doe tam ka wì: “Kon mangai ep glàm bàc kan xalep, ƀaì wì gucraq, ƀài pajàu xam mangai hnài ranenh kêh qnoh cađac haq, wì jêh cađac haq, piq hì èh haq hi rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Khoe aih, haq doe: “Tàng mangai leq enh tiaq au, ep cađac rađeh, rìm hì xùi dèh long pagat lam tiaq au.” ");
INSERT INTO hrebt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Majah qmang aih, cabô enh wèq dèh kan rìh, aih èh hnhung, mangai leq cađac dèh kan rìh đòeq tiaq au, haq aih èh jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","I jah cleq ka mangai jah dìq dŏng crŏng taneh kô mahaq cla haq aih raliang hnhung. ");
INSERT INTO hrebt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mangai leq camaih đac ka au xam bàu au, aih èh Kon mangai hadai camaih chau ka wì aih, jò haq trùh hangui dèh ta kan ranhòm cla haq, kan ranhòm Baq xam kan ranhòm ƀình plình hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Joq qnàng au doe dìq ka pì mangai qnang yòng tacô, i ngai ùh cachìt adroe ka wì jah hnoq diac plình”. ");
INSERT INTO hrebt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Qnah ta rahem hì atìq ka anoe bàu aih, Chuaq Jesus qnong Phiero, Jon xam Jaco tiaq haq tŏc tawang đòeq waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jò qnang waiq khàn, hadrò haq loh ka crài, eo haq loh ka taboc camla. ");
INSERT INTO hrebt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","I Môise xam Êli oe ta kan ranhòm loh hatuàng ti haq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Wì hatuàng trùh bìac Chuaq Jesus cachìt, aih trong haq ep broq gêh ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Phiero xam bua haq enh kùi pi cajaq, mahaq jò bu cadrat, wì hnoq kan ranhòm Chuaq Jesus xam baiq ngai qnang yòng ti haq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jò wa aih bu talah ka Chuaq Jesus, Phiero doe ka haq: Mangai hnài, bèn oe tacô lem joq qnàng, beq bèn broq piq toq hapom tacô, moeq toq ka ìh, moeq toq ka Môise, moeq toq ka Êli. (Haq ùh qnì ka rađeh khoe anoe cleq) ");
INSERT INTO hrebt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Jò haq oe raq anoe, i moeq cato yùc trùh glom dìq ka wì haq, ƀài mangai tiaq hŏc crè pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jò aih i bàu enh yùc doe: “Kô Kon da au, Mangai au khoe ràih dèh, drah tamàng bàu haq”. ");
INSERT INTO hrebt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jò bàu aih atêh loh, wì haq hnoq moeq ngai Chuaq Jesus raq. Mangai tiaq hŏc oe aiq hatinh, ùh anoe ka cabô loq đeh khoe hnoq cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hì atìq, jò wì loh enh bui wang, pi cajaq mangai lam đìh haq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ta aih i moeq ngai creo cadêh: Mangai hnài! au cali calo đeh ka ìh, lam ngan biaq da au kon, au i dèh moeq toq haq aih raq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Moeq toq kiac rùp haq oe hi cachech cachaiq cadêh, kiac aih rapôh rapàt haq dìq jaq, hacùng loh toq diac hai camùh, chac haq hech hoch men waq loh. ");
INSERT INTO hrebt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Au khoe canòm ka mangai tiaq hŏc ìh drùh qnoh kiac aih, mahaq wì drùh ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chuaq Jesus doe: “Wùih! caxi noe ùh qnì lùi rai gôpla tau, au oe ti pì, au àt ka pì trùh pang leq kô èh? Drah aràng kon ìh lam acô”. ");
INSERT INTO hrebt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mangai kon calô aih bu thia haten, kiac caqnhùt haq tacro ta haqneq, rai ranhùq haq. Mahaq Chuaq Jesus lech ka kiac aih, khoe èh haq broq brêh ka kon qyoh aih èh hi am hlài da baq haq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mangai leq mangai meh hamàih đeh hra kan itai Boc Plình. Jò dìq ka wì ta aih oe raq manè trong Chuaq Jesus ma broq, haq doe dèh ka mangai tiaq hŏc: ");
INSERT INTO hrebt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pì tamàng ma rabiaq haq bàu au anoe ka pì kô èh: Kon mangai kô èh mùt ta tì kŏng wì.” ");
INSERT INTO hrebt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mahaq mangai tiaq hŏc ùh qnì tàng, bàu aih khoe cadoc ka wì haq dôq wì haq ùh loq, wì hadai ùh hùa bòch haq bàu aih. ");
INSERT INTO hrebt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ƀài mangai tiaq hŏc tarahen ti dabau hu ngan taqne wì haq kô èh mangai leq ma yeo kàn dŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mahaq Chuaq Jesus loq ta manoh ƀài mangai tiaq hŏc, haq yŏc moeq ngai kon qyoh đòeq oe haten ka haq, ");
INSERT INTO hrebt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Haq doe: “Enh dalam ka yiniq au cabô đìh kon qyoh kô, aih haq đìh au, cabô leq đìh au, aih haq đìh Mangai khoe thê au. Majah qmang aih taqne pì mangai leq ma yeo qyoh dŏng, aih raq mangai ma yeo kàn dŏng.” ");
INSERT INTO hrebt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon doe: Mangai hnài, nhèn i hnoq mangai yŏc yiniq ìh đòeq hnan qnoh kan kiac, nhèn khoe tàt haq, majah qmang aih haq ùh pajùm moeq qmang ti bèn. ");
INSERT INTO hrebt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chuaq Jesus padreo bàu: “Apaq tàt haq, majah qmang aih mangai leq ùh tablêq ka pì, aih haq hatroq ti pì”. ");
INSERT INTO hrebt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Khoe ten trùh dèh jò Chuaq Jesus pi oe ta crŏng taneh, dua haq waq ka tŏc ta Jerusalem. ");
INSERT INTO hrebt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Haq thê mangai lam bahìa adroe. Wì aih loh lam, mùt ta plài mangai Samari đòeq hu padon hnim padài ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mahaq mangai Samari ùh waq đìh haq, majah qmang aih haq tŏc ta Jerusalem. ");
INSERT INTO hrebt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jò mangai tiaq hŏc aih la Jaco xam Jon, hnoq qmang aih, wa doe: Chuaq au, ìh i enh ma creo ka ùnh enh plình loh bùh đac wì qmat loq ùh? ");
INSERT INTO hrebt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mahaq Chuaq Jesus tawìh ta wa, haq tagàih: “Chôp ùh qnì cleq ma jrôq chiu rađeh qmat.” ");
INSERT INTO hrebt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Khoe aih haq xam mangai tiaq hŏc hi lam ta plài qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jò qnang lam ti trong, i mangai doe ka haq: Waiq Chaq, Ìh lam pang leq au tiaq pang aih. ");
INSERT INTO hrebt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Chuaq Jesus tèu haq: “Chôn i cabŏc, chìm i pù, mahaq Kon mangai ùh i nòe hu angèn gàu.” ");
INSERT INTO hrebt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Haq doe ka mangai qnoeq hòm: “Ìh lam tiaq au beq!” Mangai aih tèu bàu: Ìh dôq au hlài catùh hanang deh baq òeq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mahaq Chuaq Jesus doe: “Dôq da mangai cachìt catùh dèh mangai cachìt, ìh lam tiaq au hu anoe trong diac Plình.” ");
INSERT INTO hrebt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mangai qnoeq hòm doe: Brì ka au tiaq ìh, mahaq adroe aih ìh dôq au hlài hangah dèh kan cadraq òeq. ");
INSERT INTO hrebt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chuaq Jesus padreo bàu: “Cabô tì khoe cadop long kai ma oe raq hwi ngan enh rù, mangai ùh tajì ka diac Boc Plình.” ");
INSERT INTO hrebt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Atìq ka aih, Chuaq Jesus raìh yŏc tapèh jàt ngai tiaq hŏc maqnoeq hòm, khoe èh haq thê wì lam racop baiq ngai, baiq ngai, lam adroe ka rađeh, trùh rìm nòe haq padon lam. ");
INSERT INTO hrebt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Haq doe ka mangai tiaq hŏc: “Qmau trùh khoe bàc, yàng mangai gat aih toq ƀiaq. Qmang aih, drah bòch cla wì craq qnoh tam ƀình gat hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Drah lam beq, meh au thê pì lam, i crài cleq ka kon trìu oe qne koq yiang. ");
INSERT INTO hrebt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Apaq wê cayôp bac, apaq wê bau, jai, roc trong apaq kùh gàu ka cabô. ");
INSERT INTO hrebt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jò pì mùt hnim cabô, adroe aih pì doe: waiq kan catèm am ka hnim kô! ");
INSERT INTO hrebt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tàng joq hnim aih i mangai tajì ka jah kan catèm, aih èh kan catèm enh pì loh oe ti mangai aih, tàng ùh qmang aih, kan catèm wìh hlài ta cla pì. ");
INSERT INTO hrebt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pì oe ta hnim aih, acaq dahwèq wì qnoh ka pì, majah qmang aih mangai patìh ùh qngwan ka jah kùng baha. Apaq rangòt lam hawàt enh hnim kô trùh hnim tau. ");
INSERT INTO hrebt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jò pì mùt gùng leq, wì gùng aih pachùh adràc, wì padon cleq, pì acaq ka aih. ");
INSERT INTO hrebt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Broq brêh ka mangai yinìq ta aih, rai doe ka wì: Diac Boc Plình trùh khoe haten ti pì. ");
INSERT INTO hrebt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mahaq jò pì mùt ta plài leq, yàng wì ta aih ùh đìh pì mùt, pì loh roc trong rai doe: ");
INSERT INTO hrebt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Pì ngan kô, blo plài pì ma top ta jènh, nhèn ha pùih đac đòeq chônh pariaq pì hnoq, mahaq pì ep loq rameh Diac plình khoe trùh haten ka pì. ");
INSERT INTO hrebt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Au doe ka pì, trùh hì ma atìq lùch èh, gùng Sôđom pòq kan hadrah yi ƀiaq ka gùng aih. ");
INSERT INTO hrebt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Haƀo ka gè, Côrasin. haƀo ka gè Bêtsaida, majah qmang aih tàng joq kan halac khoe broq taqne pì qmat aràng broq ta gùng Tiro xam Siđôn, wa aih khoe caxùnh eo briang, kui blo tanùh, khoe raxach, tawìh hlài khoe dùnh. ");
INSERT INTO hrebt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aih èh, trùh hì hadrah, plài Tiro xam Sôđom pòq kan hadrah yi ƀiaq ka pì. ");
INSERT INTO hrebt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Da gè hòm, Cabênaum, gè jah dèch atŏc trùh ta plình qmòh? Ùh đòh, gè qmat èh jah qnìh cađac trùh qmòe ta hwinh. ");
INSERT INTO hrebt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Cabô tamàng pì, aih tamàng au, cabô cađac pì, aih cađac au, cabô cađac au aih ca đac Mangai ma khoe thê au.” ");
INSERT INTO hrebt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tapèh jàt ngai tiaq hŏc wìh hlài rai lem bùi rai doe: Chuaq! Enh dalam yiniq Ìh, jaq kan kiac dua iu bàu nhèn. ");
INSERT INTO hrebt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chuaq Jesus padreo bàu: “Au hnoq Satan clìh tìah ka kan camlet enh plình. ");
INSERT INTO hrebt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Au khoe am ka pì cwìang itai hu jôiq padit bìh, agôt hloe xam cwìang mangai tagit ka pì. Ùh i mangai leq hlàt broq ka pì raliang. ");
INSERT INTO hrebt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Qmang aih, ùh dùh lem bùi jò kiac iu bàu pì, mahaq lem bùi jò yiniq pì khoe jah achìh ta diac plình.” ");
INSERT INTO hrebt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jò aih, Chuaq Jesus dìq jaq lem bùi ta Yiang Hadròeh, haq doe: “Waiq Baq! Craq da plình crŏng taneh, au manè apôi Ìh, majah qmang aih ìh khoe cadoc yiniq kô ka mangai rabiaq, mangai i hŏc, mahaq patô qnoh ka kon qyoh. Baq ôi, joq qnàng qmang aih, majah qmang aih ìh khoe hnoq bìac aih lem. ");
INSERT INTO hrebt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Baq khoe jao dŏng rìm yiniq ka au, enh gùng ka Baq ùh i cabô loq ka Kon, enh gùng ka Kon, xam mangai leq kon enh mahno am, hadai ùh i mangai leq loq ka Baq aih cabô.” ");
INSERT INTO hrebt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Khoe aih, Chuaq Jesus hwi ngan mangai tiaq hŏc rai doe: “Xôq ramot ka mat jah hnoq trong pì hnoq! ");
INSERT INTO hrebt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Majah qmang aih au anoe ka pì, bàc ngai pajàu xam bùa tangèh jah hnoq trong pì hnoq, mahaq ùh jah hnoq, tangèh ka jah tàng trong pì tàng mahaq ùh jah tàng.” ");
INSERT INTO hrebt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","I moeq ngai hnài ranenh, yòng bòch đòeq hu qnhro ngan Chuaq Jesus, haq doe rameh: Mangai hnài, au ep broq cleq đòeq hu jah kan rìh halình mòeq đòe? ");
INSERT INTO hrebt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chuaq Jesus bòch: “Ta hset ranenh achìh cleq? Ìh đŏc cleq ta aih?” ");
INSERT INTO hrebt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Haq aih tèu bàu: Ìh ep dìq ka manoh, dìq ka mahua yiang, dìq ka padren, dìq ka gàu ngoc loq iu Chuaq aih Boc Plình ìh, rai loq waq ka mangai haten hatìa ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chuaq Jesus doe ka haq: “Ìh tèu khoe troq, broq qmang aih beq, ìh hi jah rìh.” ");
INSERT INTO hrebt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mahaq mangai hnài ranenh aih enh doe rađeh aih mangai taq atoq, haq bòch Chuaq Jesus: Mangai haten hatìa ka au aih cabô? ");
INSERT INTO hrebt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chuaq Jesus padreo bàu: “I moeq ngai enh Jêrusalem loh ta Jêrico, ti trong glàm ƀài mangai atùng, wì blah yŏc dìq dŏng da haq bac jèn, jêh haq habau habùa ta chac, khoe cla wì hi lam cađac haq oe ti aih ten cachìt ten rìh. ");
INSERT INTO hrebt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jò aih, i moeq ngai pajàu loh trong aih, hnoq mangai aih, haq wia pah tau trong èh lam hloe. ");
INSERT INTO hrebt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Èh hòm, i moeq ngai Lêwi hadai trùh jang aih, thia haten, ngan hnoq qmang aih, èh hanoh lam hloe. ");
INSERT INTO hrebt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mahaq i moeq ngai samari lam ti trong, thia haten hnoq qmang aih, ta manoh haq ha-och ka mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Haq yŏc dàu, yŏc alac qnheo teo habau, khoe èh ti kàt palauq, khoe aih, dèch atŏc enh crŏng lùa aràng trùh hnim padài, hu wèq ngan. ");
INSERT INTO hrebt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Trùh hì atìq, yŏc baiq đoniê am ka craq hnim padài rai tanap: Ìh wèq ngan mangai kô oq, tàng loq yam ùh hnau, jò au wìh hlài i au caqnaih. ");
INSERT INTO hrebt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Taqne piq ngai aih, ìh hèm beq, mangai leq ma haten hatìa ka mangai wì ma atùng aih?” ");
INSERT INTO hrebt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mangai hnài ranenh aih padreo bàu: Aih mangai ma khoe i manoh loq waq, khoe loq hanò ka haq. Chuaq Jesus doe: “Drah lam beq, broq tiaq qmang aih” ");
INSERT INTO hrebt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jò Chuaq Jesus xam mangai tiaq hŏc lam ti trong, trùh ta plài tau, i moeq ngai gucadrì yiniq haq Mathê đìh Chuaq Jesus mùt dèh ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Haq aih i moeq ngai oh cadrì, yiniq haq Mari, haqngui nòe jènh Chuaq Jesus hu tamàng bàu Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mathê toq ti hawet jiang patìh, trùh anoe ka Chuaq Jesus: Chuaq au! oh au đòeq au patìh đeh moeq ngai, ìh doe ka haq wiang patìh ti au diq. ");
INSERT INTO hrebt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chuaq Jesus padreo bàu: “Mathê, Mathê, ìh chìuq lep rai hèm bàc trong; ");
INSERT INTO hrebt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","mahaq i moeq yiniq raq ma nhet. Mari khoe ràih yŏc ka dadeh yiniq aih, ùh i cabô jah blah yŏc da haq”. ");
INSERT INTO hrebt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","I moeq hì, Chuaq Jesus qnang waiq khàn tanòe aih, jò khoe hêq ka waiq khàn, moeq ngai tiaq hŏc doe ka haq: Chuaq ôi, Ìh hnài nhèn waiq khàn qmang ka Jon khoe hnài dèh mangai tiaq hŏc diq. ");
INSERT INTO hrebt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chuaq Jesus doe: “Jò waiq khàn pì anoe qmang kô: Waiq Baq, Yiniq Baq jah hadròeh, diac Baq jah trùh, ");
INSERT INTO hrebt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Am ka nhèn dahwèq acaq hì leq qnang lem hì meh, ");
INSERT INTO hrebt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Caqnaih da nhèn yiniq lui, majah qmang aih nhèn hadai caqnaih yiniq lui ka mangai ma broq yiniq ka nhèn, ùh dùh aràng nhèn tanòe padô qnùt”. ");
INSERT INTO hrebt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Khoe aih, haq doe ka wì mangai tiaq hŏc: “Tàng taqne pì i moeq ngai i dèh bua qne mang trùh creo: Ê daq, am đò ka au piq toq ƀênh, ");
INSERT INTO hrebt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","majah qmang aih i bua au neo trùh enh hangai, au ùh i ka dahwèq hu qnoh ka haq acaq. ");
INSERT INTO hrebt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tàng joq mangai oe ta hnim doe: Apaq pangài ka au, qmang khoe clênh, wì kon xam cla au dìq khoe kùi, ùh jah yòng yŏc ƀênh ka ìh; ");
INSERT INTO hrebt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","au doe ka pì, yac ka mangai ùh enh yòng yŏc ƀênh am dèh ka bua, mahaq pàng mangai aih xan bòch yôt, èh dua haq yòng am dèh ka bua haq rìm yiniq bua haq qnang nhet ka waq. ");
INSERT INTO hrebt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Au anoe tam ka pì: Bòch beq, yiniq aih jah am ka pì, chaq beq pì hi hnoq, clôq beq qmang hi tapèh am ka pì. ");
INSERT INTO hrebt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Majah qmang aih mangai leq bòch, mangai aih jah, mangai leq chaq, mangai aih hnoq, èh mangai leq clôq, qmang hi ta pèch am ka mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Dìq ka pì ma broq baq qmat, i cabô jò kon cla bòch ƀênh yàng aih am hmo? Ùh meh bòch ka mahaq am bìh? ");
INSERT INTO hrebt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tàng ùh meh bòch catap mahaq am agôt? ");
INSERT INTO hrebt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Qmang aih, pì qmat mangai qmèq mahaq oe loq am dèh ka kon yiniq lem, ùh dùh dèh ka Baq pì oe ta plình ma ùh am Yiang Hadròeh ka mangai creo dang haq!” ");
INSERT INTO hrebt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Chuaq Jesus hnan qnoh moeq toq kiac làu, jò kiac khoe loh, mangai làu aih hi jah capoch. Mangai leq mangai meh hamàih đeh hra. ");
INSERT INTO hrebt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mahaq i qnah ngai doe: Mangai kô canòm ka Bê-en xêbun, craq kiac đòeq drùh kiac. ");
INSERT INTO hrebt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mangai ma qnoeq hòm enh qnhro ngan haq, wì bòch haq am wì hnoq kan halac loh enh plình. ");
INSERT INTO hrebt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Chuaq Jesus loq ka manoh wì, haq doe: “Diac leq to hit rađeh, diac aih raliang, hnim leq cla to lah dabau, hnim aih èh tacro. ");
INSERT INTO hrebt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Qmang aih tàng joq kiac Satan hit rađeh, diac haq ma oe dràng, majah qmang aih pì doe au canòm ka Bê-en xêbun đòeq drùh qnoh kan kiac? ");
INSERT INTO hrebt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tàng joq au canòm ka Ben xê bun đòeq drùh kiac, aih èh kon pì canòm ka cabô đòeq drùh kiac? Aih ìq raq, kon pì ma jah broq mangai hadrah cla pì. ");
INSERT INTO hrebt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mahaq tàng joq au canòm ka hadrang tì Boc Plình đòeq drùh hnan kan kiac, aih diac Boc plình trùh khoe haten ka pì. ");
INSERT INTO hrebt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jò mangai dêh padren wê ranac wèq dèh hnim cla, aih èh kùng hang ta hnim haq jah cajap. ");
INSERT INTO hrebt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yàng i mangai ma yeo dêh ka haq, trùh blêq haq, blah yŏc ranac haq ma canòm xam dìq kùng hang haq aih. ");
INSERT INTO hrebt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mangai leq ùh oe ti au, mangai aih tablêq ka au, mangai leq ùh pajùm ti au, mangai aih èh haprah hapriang. ");
INSERT INTO hrebt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jò kiac dù loh enh chac moeq ngai, haq lam rangòt tanòe croh crênh ti chaq nòe padài. Chaq ùh jah, haq hi doe: Hêq au hlài dèh tanòe au ma neo loh. ");
INSERT INTO hrebt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Haq wìh hlài, hnoq hnim hwit khoe hreo, rìm yiniq ta hnim khoe don palauq qmòe calem, ");
INSERT INTO hrebt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","haq hi lam adràc tam tapèh toq kiac qnoeq yeo dù ùh hnau ka haq mùt oe ta hnim aih, aih èh, mangai aih yeo hamoq ùh hnau ka adroe hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jò Chuaq Jesus qnang anoe bàu aih, i moeq ngai gucadrì oe taqne mangai bàc ta aih dêh bàu doe: Xôq ramot ka mangai miq khoe ha-uang ìh, ma khoe ta-ùq ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Chuaq Jesus padreo bàu: “Mangai leq tàng bàu Boc plình rai iu bàu aih, jah xôq ramot ùh hnau ka aih hòm.” ");
INSERT INTO hrebt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ƀài mangai tagop dabau ta aih èh rai bàc, Chuaq Jesus doe: “Caxi noe kô xinoe dù, wì haq bòch ngan teo halac, mahaq ùh am ka wì haq teo halac qnoeq enh gùng ka teo halac da Jôna. ");
INSERT INTO hrebt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Majah qmang aih, Jôna aih raq kan halac ka plài Ninive, hadai qmang aih, Kon mangai hadai kan halac am ka xinoe kô. ");
INSERT INTO hrebt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Trùh hì tah hadrah, bùa cadrì enh pah qma mat mahì loh, yòng hadrah ka xinoe kô, majah qmang aih haq oe enh gùng haqmai lùch crŏng taneh khoe trùh hu tamàng bàu rabiaq da bùa Salomôn, mahaq, oe tacô i moeq Ngai kàn ùh hnau ka Salomôn. ");
INSERT INTO hrebt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Trùh hi tah hadrah, mangai oe ta Ninive wì haq yòng pajùm hu hadrah caxi noe kô, majah qmang aih wì haq tàng bàu Jôna, wì haq khoe loq raxach, mahaq, ajang kô i moeq Ngai yeo kàn ùh hnau ka Jôna. ");
INSERT INTO hrebt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ùh i cabô bùh đen mahaq đòeq tanòe hanàp, tanòe caqnàm, mahaq wì dèch đòeq tanòe haqnhèq, dôq mangai mùt ta hnim jah hnoq kan qngah. ");
INSERT INTO hrebt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mat aih đen ta chac hamac, tàng joq mat ìh tadêh, dìq ka chac ìh jah qngah, tàng joq mat ìh ùh nèn, dìq ka chac ìh oe ta clam. ");
INSERT INTO hrebt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Qmang aih, ngan oq, kan qngah ta pì loq loh kan clam. ");
INSERT INTO hrebt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tàng joq dìq tachac pì qngah qngai, ùh i nòe leq clam jah qngah dìq dŏng, aih hadai tìah ka jò i đen sreo qngah am ka pì diq.” ");
INSERT INTO hrebt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jò Chuaq Jesus anoe bàu aih bu dìq, i moeq ngai Pharisi akhen ka Chuaq Jesus hlài acaq dèh ta hnim. Chuaq hangui acaq. ");
INSERT INTO hrebt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mangai Pharisi hnoq Chuaq Jesus ùh qnheo tì adroe ka acaq, haq hamàih. ");
INSERT INTO hrebt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chuaq Jesus doe ka haq: “Dìq ka bài pì aih mangai Pharisi, pì haliang dòt doe hreo toq enh gùng, mahaq enh dalam bình toq kan atùng xam kan dù. ");
INSERT INTO hrebt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wùih! mangai ratùt, Mangai ma khoe broq enh gùng, ma ùh joq haq broq hloe enh dalam qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Xan pì yŏc dèh hang pì ma i aih, ti am ka mangai pa, aih èh rìm yiniq hi lem hreo am ka pì. ");
INSERT INTO hrebt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mahaq, haƀo ka pì, mangai Pharisi, majah qmang aih pì dèch ka Boc Plình mòeq phàn mòeq jàt cachiq bŏc ha, cachiq xang, xam rìm bài cachiq qnoeq, mahaq trong taq atoq, trong loq iu Boc plình aih pì cađac! Aih ƀài yiniq pì ma ep broq, mahaq hadai ùh dùh cađac ƀài yiniq tau. ");
INSERT INTO hrebt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Haƀo ka pì, mangai Pharisi, majah qmang aih pì enh haqngui nòe yeo haqnhèq tanòe hnim tagop, enh mangai qnoeq kùh gàu ka rađeh taqne nòe padro! ");
INSERT INTO hrebt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Haƀo ka pì, majah qmang aih pì tìah ka ralùng hanang khoe cađac klui, wì jôiq enh qnhèq mahaq ùh canau!” ");
INSERT INTO hrebt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","I moeq ngai hnài ranenh doe: Mangai hnài, ìh capoch qmang aih ma ùh joq ìh broq ka nhèn kan xep. ");
INSERT INTO hrebt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chuaq Jesus padreo bàu: “hadai haƀo ka ìh qmang aih diq, mangai rabiaq toq ka hnài ranenh, pì dèch taqmòq ka mangai qnoeq kan trap, kan tawac, cla pì aih ùh tadroq qmòe moeq hadrang tì! ");
INSERT INTO hrebt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Haƀo ka pì, majah qmang aih pì bùn ralùng hanang wì pajàu kan cadraq pì ma khoe jêh đac nèh haq! ");
INSERT INTO hrebt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Qmang aih ajoq pì patô qnoh pì khoe mòeq manoh dèh ka trong kan cadraq pì broq, majah qmang aih wì haq khoe jêh cađac pajàu Boc Plình, pì aih mangai bùn ralùng. ");
INSERT INTO hrebt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Aih ìq raq, kan rabiaq Boc plình i doe: Au thê dèh mangai pajàu xam mangai pòq bàu trùh ti wì haq, wì haq jêh cađac mangai kô rùp mangai tau, ");
INSERT INTO hrebt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dôq mahim rìm ngai pajàu khoe ta-ùc enh jò baxèm broq plình crŏng taneh, jah taƀoe dìq ka nang noe kô, ");
INSERT INTO hrebt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Patep enh mahim da Abên trùh mahim Xachari, mangai wì ma khoe jêh cađac ta adreo prang tadreo xam hnim kùh waiq, joq, au anoe ka pì, mahim wì aih èh, bòch hlài dìq ajang nang noe kô èh. ");
INSERT INTO hrebt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Haƀo ka pì, mangai hnaì ranenh, majah qmang aih pì ta qmiaq yŏc long gahlòng da kan rabiaq, cla pì aih ùh waq mùt, mangai qnoeq aih enh mùt, aih pì ùh lòh!” ");
INSERT INTO hrebt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jò Chuaq Jesus khoe loh enh gùng, mangai Pharisi xam mangai hnài ranenh dìq jaq àu tablêq ka haq, wì bòch bàc trong hu dakhwàiq haq, ");
INSERT INTO hrebt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","chaq trong đòeq bahlac haq ta bàu tapoch. ");
INSERT INTO hrebt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jò aih, mangai ta aih tagop ti dabau hi bình qmòe ka mùan, loh qmòe ka tajôiq dabau, Chuaq Jesus chônh anoe dèh ka mangai tiaq hŏc: “Ngan oq! wèq rađeh apaq top blo da mangai Pharisi, aih kan ti patìah toq enh gùng. ");
INSERT INTO hrebt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ùh i cleq cadoc èh ma ùh hnoq, ùh i yiniq cleq hlèp èh wì ma ùh qnì. ");
INSERT INTO hrebt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Qmang aih rìm trong pì anoe tanòe clam cluiq, jah tàng dìq tanòeh qngah qngai, rìm yiniq pì ta bahech tabluàng hlèp, aih èh jah paqnoh ta kùa po. ");
INSERT INTO hrebt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Au anoe ka pì aih mangai bua da au, apaq yùq ka mangai jêh đac toq chac pì khoe aih pi jah broq cleq hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mahaq au patô am ka pì khòh yùq ka cabô: Khòh yùq crè ka Mangai jò khoe jêh cađac chac hamac, èh haq i cwìang tèm caqnìh ta hwinh, joq qnàng au doe ka pì: aih Mangai pì ep yùq crè! ");
INSERT INTO hrebt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ma ùh joq padam toq chìm xê wì tech baiq hliac bac raq qmòh? Mahaq moeq toq ta aih dua Boc plình ùh hèt. ");
INSERT INTO hrebt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xàc ta gàu pì qmat hadai rènh khoe dìq. Apaq yùq dèh! Majah qmang aih pì canaq ùh hnau ka chìm xê. ");
INSERT INTO hrebt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Au anoe ka pì: mangai leq doe đeh canau loq ka au enh ngèa wì phù cròng, aih èh Kon mangai hadai doe đeh canau loq ka yiniq haq enh ngèa ka ƀình plình Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mahaq mangai leq hangah đeh ùh canau ka au enh ngèa phù cròng, aih èh enh ngèa ka ƀình plình da Boc plình, au hadai doe đeh ùh qnì ka yiniq haq aih. ");
INSERT INTO hrebt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mangai leq tapoch tablêq ka Kon mangai, yiniq lui aih oe jah caqnaih, mahaq mangai leq tapoch ùh hòq ka Yiang Hadròeh, yiniq lui haq aih èh pi oe jah caqnaih. ");
INSERT INTO hrebt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Jò wì aràng pì trùh enh ngèa hnim tagop, qnoh pì enh ngèa cwan hadrah, cwan wèq cwìang, aih pì apaq hèm đeh anoe qmang leq, anoe cleq hu cwaih doeh rađeh, ");
INSERT INTO hrebt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","majah qmang aih, wop jò aih raq Yiang Hadròeh hnài pì bàu ma troq ka tapoch. ");
INSERT INTO hrebt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jò aih, taqne mangai bàc i moeq ngai dèch bàu doe: Mangai hnài, ìh anoe biaq ka daq au dôq haq axong kùng hang ka au diq. ");
INSERT INTO hrebt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mahaq Chuaq Jesus padreo bàu: “Wùih mangai meh, cabô dèch au broq mangai hadrah yiniq, broq mangai axong da pì kùng hang?” ");
INSERT INTO hrebt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Khoe aih, haq doe ka wì ta aih: “Rabiaq haq oq! apaq daiq cadèh, mangai kô rìh ùh xài canòm ajang nòe bàc kùng hang”. ");
INSERT INTO hrebt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Haq alìah ka wì bàu kô: “I moeq ngai padrŏng, ruàng haq jah qmau pi cajaq, ");
INSERT INTO hrebt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","haq aih hèm dèh ta manoh: Au broq qmang leq kô èh? Pi i qmòe ka nòe anòh hu don đòeq qmau, ");
INSERT INTO hrebt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Haq doe dèh raq: Au broq qmang kô èh, raliang dŏng hapom ma dùnh, broq ònh ma qnoeq yi kàn, tah đòeq qmau xam ƀài dahwèq ta aih, ");
INSERT INTO hrebt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","khoe aih anoe dèh ka mahua yiang cla: Gè i qmau khoe bàc, hu acaq bàc hanam, hêq, padài beq, acaq, ôq, rai bùi hyòq diq. ");
INSERT INTO hrebt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mahaq Boc plình doe ka haq: Wùih mangai blùng, mahua yiang gè au yŏc hlài mang kô raq. Aih èh kùng hang gè khoe padon ka dađeh qmat èh jah cabô? ");
INSERT INTO hrebt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mangai leq toq ti gop đòeq ka rađeh mahaq ùh padrŏng kan nòe Boc plình, qmang aih èh diq.” Trong loq lèt ");
INSERT INTO hrebt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chuaq Jesus doe dèh ka mangai tiaq hŏc: “Qmang aih, au doe ka pì, apaq crè ka kan rìh pì kô èh acaq cleq, hadai ùh dùh yùq ka chac pì kô èh caxùnh cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kan rìh yeo kàn ka dahwèq acaq, chac hamac yeo kàn ka dahwèq caxùnh atàc. ");
INSERT INTO hrebt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Haqmiang ngan ac: haq ùh i rai adrech, ùh i gat, hadai ùh i ka bùaq, ùh i ka hapom, mahaq dua Boc plình wèq ban haq, pì aih ajoq yeo canaq ùh hnau ka ac? ");
INSERT INTO hrebt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","I ka cabô oe taqne pì qmat canòm kan loq lèt majah broq ka rađeh halình tam toq biaq ùh? ");
INSERT INTO hrebt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tàng bìac qyoh dàng aih pì broq ùh jah, meh pì oe lèt dèh trong qnoeq? ");
INSERT INTO hrebt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ngan riang tacreo hon qmang leq? Haq ùh i abroq xalep, hadai ùh i caxênh brai, mahaq au doe ka pì: Qnhac ka bùa Salomôn ranhòm dàng leq, dua ùh jah caxùnh eo lem tìah ka ƀài riang aih. ");
INSERT INTO hrebt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wùih! ƀài mangai ƀiaq kan lùi, tàng joq ƀài nhat oe ta gùng aih hì kô oe rìh, hì da èh bùh ta ralùng, mahaq Boc plình oe am haq caxùnh lem qmang aih, ùh dùh dèh ka pì! ");
INSERT INTO hrebt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Qmang aih, manoh cliac pì paq hèm acaq cleq, ôq cleq, ùh dùh lèt dèh trong aih. ");
INSERT INTO hrebt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Majah qmang aih, wì mangai enh gùng oe ta crŏng taneh kô jò leq ma ùh cadàu tiaq ƀài yiniq aih, èh Baq pì oe ta plình khoe loq pì nan đeh ka ƀài yiniq aih. ");
INSERT INTO hrebt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mahaq chaq diac Haq òeq, ƀài yiniq aih troq jò èh brì ka haq am tam ka pì. ");
INSERT INTO hrebt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yôiq wì kon qyoh, apaq yùq cadèh, majah qmang aih Baq pì khoe lem manoh hu am ka pì Diac plình. ");
INSERT INTO hrebt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tech kùng hang pì beq hu am ka mangai ma hamoq, palauq đòeq ka rađeh balet tah bac ma ùh hìaq loq hyah xam kùng hang canaq ùh hìaq loq racòch oe ta plình, aih nòe ùh i ka mangai atùng jah thia haten, ùh i ka hadrùng, ùh i catia kap bahech. ");
INSERT INTO hrebt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Majah qmang aih kùng hang pì oe taleq, manoh cliac pì hadai oe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Caxi caqnam pì ep kàt, đen bùh dôq haq qngah yôt. ");
INSERT INTO hrebt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Qmang ka magai hapŏng gòm dèh wì craq hnim hlài enh acaq yiniang, waq toq wì craq hi clôq qmang, haq khoe drah pèh qmòe carênh. ");
INSERT INTO hrebt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Xôq ramot ka mangai hapŏng aih, jò wì craq hlài hnoq wì haq hmàng rìu gòm! Joq qnàng au doe ka pì, craq aih kàt dèh caxi caqnam, am mangai hapŏng hangui ti cabŏng, khoe haq hi patìh hlài ka wì. ");
INSERT INTO hrebt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Joq xôq ramot am ka mangai hapŏng jò wì craq hlài hnoq wì haq rìu gòm qmang aih, yac ka jò qne mang, yac ka jò ia rŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Loq maro qmang kô! tàng joq cla wì craq hnim khoe loq jò leq i mangai atùng trùh, aih èh haq hamang đòeq hu rap, ùh dôq mangai atùng chìa da haq panàt hnim. ");
INSERT INTO hrebt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pì hadai qmang aih diq, hmàng gòm rap qmòe oq, majah qmang aih Kon mangai trùh wop qmòe jò pì ùh ùac ngèh.” ");
INSERT INTO hrebt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Phiero bòch: Chuaq au, bàu alìah kô Ìh anoe ka nhèn, loq ìh anoe xam mangai qnoeq? ");
INSERT INTO hrebt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chuaq Jesus doe: “Cabô ma i manoh ùh hìaq gôpla rai rabiaq ka taqmroq, craq hnim dèch haq broq mangai wèq dìq ka hapŏng ta hnim, đòeq trùh jò hu ti axong ka wì aih dahwèq acaq? ");
INSERT INTO hrebt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Xôq ramot ka mangai hapŏng aih jò wì craq wìh hlài, hnoq haq broq qmang aih! ");
INSERT INTO hrebt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Joq qnàng au anoe ka pì, aih èh craq hnim am haq wèq dìq kùng hang ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mahaq tàng joq mangai hapŏng aih hèm dèh ta manoh: Craq au oe dùnh men trùh, èh haq ti jêh ƀài mangai hapŏng calô, hapŏng cadrì, rai acaq ôq bù bia, ");
INSERT INTO hrebt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","aih èh craq haq trùh wop hì haq ùh tangèh, wop qmòe jò haq ta ùac, yŏc long roe blai haq hyah hyoch ka akia, khoe aih cađac haq oe moeq qmang ti ƀài mangai manoh gôpla. ");
INSERT INTO hrebt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mangai hapŏng kô khoe loq ka manoh cla wì craq, mahaq ùh padon ùh broq tiaq manoh aih, haq jah jìq yeo bàc. ");
INSERT INTO hrebt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yàng mangai hapŏng ma ùh qnì ka manoh cla wì craq, haq broq ùh troq ka manoh wì craq, aih èh jah jìq yeo biaq. Majah qmang aih mangai leq khoe jah am yeo bàc, aih èh wì craq bòch hlài yeo bàc, mangai leq khoe jah jao yeo bàc èh wì craq bòch hlài yeo bàc hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Au khoe trùh hu caqnìh ùnh ta crŏng taneh, tàng joq haq khoe jah cheo cadêh, aih au oe tangèh cleq loe ka aih hòm! ");
INSERT INTO hrebt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","I moeq ƀaptem au ep pòq, au mangò xalep oe i jaq cleq men trùh hì ƀaptem aih jah gêh! ");
INSERT INTO hrebt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pì xoh au trùh au trùh hu aràng kan catèm ka crŏng tanenh qmòh? Au anoe ka pì: ùh! mahaq aràng kan talah. ");
INSERT INTO hrebt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Majah qmang aih, pang kô ta èh, tàng padam ngai oe pajùm moeq hnim, ƀài aih èh talah ka dabau, piq ngai tablêq ka baiq ngai, baiq ngai tablêq ka piq ngai, ");
INSERT INTO hrebt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","baq tablêq dèh ka kon calô, kon calô tablêq dèh ka baq, miq tablêq dèh ka kon cadrì, kon cadrì tablêq dèh ka miq, yaq tablêq dèh ka kon mai, kon mai tablêq dèh ka yaq.” ");
INSERT INTO hrebt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Haq doe ka ƀài mangai bàc ta aih: “Jò pì hnoq yùc yòng enh apah mat mahì clìh, pì doe: Hì kô èh loq i mè, èh joq qnàng qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Èh i cayeo hlui enh pah qma mat mahì loh pì doe: Hì kô èh tôq, èh joq i qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wùih! ƀài mangai patìah toq enh gùng tau! Pì loq hadro ngan ta trŏc, hadro ngan ta taneh, òq hagleq pì ùh qnì hadro ngan qnhòng kô? ");
INSERT INTO hrebt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hagleq cla pì ùh ti ngan deh trong leq ma taq atoq? ");
INSERT INTO hrebt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Qmang aih, jò pì lam ti ƀài mangai ma qnoh pì tanòe hadrah, roc trong drah àu hatroq ka wì, yùq èh wì dùi pì trùh enh ngèa cwan hadrah, cwan aih qmùt pì tanòe cwan wèq hnim cadrong, cwan aih clêh pì. ");
INSERT INTO hrebt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Au doe ka pì: Pì caqnaih yac ka oe pòq moeq hliac raq dua pì qnhòq jah loh enh aih”. ");
INSERT INTO hrebt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hadai jò aih raq, i ƀài mangai anoe hlài ka Chuaq Jesus loq Philat khoe jêh đac toq leq ngai Galili, yŏc mahim clai ta ngè tadreo. ");
INSERT INTO hrebt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chuaq Jesus doe ka wì haq: “Pì xoh đeh ƀài mangai Galili aih broq yiniq lui cleq yeo qmèq ùh hnau ka mangai Galili qnoeq qmòh, dài wì majah glàm kan haƀo qmang aih? ");
INSERT INTO hrebt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Au doe ka pì loq: Ùh xài, mahaq tàng pì ùh qnì raxach, èh dìq ka pì hanoh lùng pac qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tàng ùh qmang aih, moeq jàt rahem ngai cachìt ka hnim haqnhèq Siloê tùc, aih pì hèm wì haq broq yiniq lui yeo qmèq ka mangai oe ta Jêrusalem qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Au doe ka pì: Ùh! Mahaq tàng pì ùh raxach, dìq ka pì hadai cachìt lùch qmang aih èh. ");
INSERT INTO hrebt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Khoe aih haq hi alìah bàu kô: “I moeq ngai pìt dèh ta wuàn plì nho moeq xèm long pŏc, haq loh chaq git plì ta aih mahaq chaq ùh lòm hnoq, ");
INSERT INTO hrebt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Haq doe ka ƀài wì mangai pìt nho: Khoe piq hanam au loh git plì nòe xèm long pŏc kô mahaq ùh lah i qmòe plì, kau cađac long qmat, gleq majah đòeq haq tawac ngwan toq ka taneh? ");
INSERT INTO hrebt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mangai pìt nho padreo bàu: Wì craq, ìh đòeq tam moeq hanam kô hòm, dôq au bŏc dudan taxèm haq khoe aih tah phàn. ");
INSERT INTO hrebt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Broq braiq atìq èh haq loh plì, ùh qmang aih èh ìh hi koh cađac. ");
INSERT INTO hrebt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","I moeq hì sabat, Chuaq Jesus mùt hnài tanòe hnim tagop qyoh. ");
INSERT INTO hrebt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta aih i moeq ngai gucadrì, loh ka pen khoe moeq jàt rahim hanam, majah qmang aih kiac rùp baxa haq. Haq kŏc crŏng ùh jah yòng ka qnhoh. ");
INSERT INTO hrebt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bu hnoq haq, Chuaq Jesus khoe creo doe: “Yôiq! mangai gucadrì tau, ìh khoe jah brêh ka yinìq”, ");
INSERT INTO hrebt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chuaq Jesus hi yŏc tì bèq chac haq. Tajòe hloe, haq aih jah yòng cajang, rai dèch bàu manè apôi Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jò aih, mangai wèq hnim tagop qyoh hnoq Chuaq Jesus broq brêh ka mangai yinìq ta hì sabat, haq aih tapoch hloe ka mangai bàc ta aih: I tadràu hì hu abroq, pì trùh ta ƀài hì aih đòeq hu jah broq brêh ka yinìq ùh hrŏc, ùh dùh trùh dèh hì sabat. ");
INSERT INTO hrebt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mahaq Chuaq Jesus tèu haq: “Wùih! Mangai patìah toq enh gùng tau, hì sabat pì ma ùh caqnaih ƀo, caqnaih lùa loh enh cadrong hu tiaq aràng haq lam ôq diac qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kon cadrì da Apraham kô, satan khoe rùp kàt haq moeq jàt rahim hanam, ta hì sabat ma ùh khòh lêh caqnaih haq qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Haq tapoch qmang aih ƀài mangai ma tagit ka haq loh dŏng ka camaih, yàng da mangai bàc ta aih lem bùi ka trong halac haq khoe broq. ");
INSERT INTO hrebt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chuaq Jesus doe: “Diac Boc plình qmang leq, au yŏc cleq hu alìah? ");
INSERT INTO hrebt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Diac aih tìah ka moeq pliang clong habài, i moeq ngai aih haq rai deh ta wia, jah hon hi wìa long kàn, chìm trùh broq pù ta hamenh haq.” ");
INSERT INTO hrebt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Haq anoe hòm: “Au alìah diac Boc plình ti cleq kô hòm? ");
INSERT INTO hrebt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Diac aih tiàh ka blo, i moeqngai gucad rì yŏc jràu ta piq cađap dàc, trùh dèh jò dàc hi rèu dŏng.” ");
INSERT INTO hrebt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Khoe aih Chuaq Jesus tŏc ta Jêrusalem, haq lam pagat enh ƀài plài qyoh trùh plài kàn, rai lam haq hnài wì. ");
INSERT INTO hrebt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","I mangai bòch haq: Waiq Chuaq! Ajoq toq biaq ngai raq ma jah dèch qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Haq doe ka wì: “Ep ran dìq ka paden đòeq àu mùt ta qmang chit, majah qmang aih au doe ka pì, bàc ngai àu chaq trong hu mùt mahaq ùh jah.” ");
INSERT INTO hrebt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jò cla wì craq ta hnim yòng clenh qmang, pì yòng enh gùng clôq qmang rai creo: waiq Chuaq! pèh ka nhèn qmang diq. Mahaq cla wì craq doe: Au ùh qnì ka pì trùh enh leq. ");
INSERT INTO hrebt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jò aih èh pì doe: Nhèn khoe acaq, khoe ôq pajùm ti ìh, ti trong ti chòq ìh khoe hnài nhèn. ");
INSERT INTO hrebt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mahaq wì craq doe hòm: Au doe ka pì, au ùh qnì ka pì trùh enh leq, dìq dŏng ƀài mangai broq dù tau, drah wia dŏng ma khoe ka au beq! ");
INSERT INTO hrebt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jò aih èh, pì hnoq Apraham, Ysac xam Jacôp hloe xam dìq dŏng ƀài mangai pajàu tanòe diac Boc plình, mahaq pì èh jah khwênh qnoh cađac enh gùng, tanòe aih toq crò hmoe xam cadrit hanenh. ");
INSERT INTO hrebt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yàng èh, enh gùng mahì loh, enh gùng mahì mùt, enh gùng pah qma, enh gùng pah qngeo, wì trùh hangui ta aniang hu acaq yiniang ta diac Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aih èh, i mangai atìq jah loh angoe, mangai adroe jah loh ka atìq.” ");
INSERT INTO hrebt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hadai jò aih, i mangai Pharisi lam doe ka Chuaq Jesus: Ìh pi dùh oe tacô chaq lam taqnoeq beq, Herôt enh jêh đac Ìh, ");
INSERT INTO hrebt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Chuaq Jesus padreo bàu: “Lam anoe ka chôn aih: Hì kô, hì da èh, au oe drùh hnan kan kiac rai broq brêh kan hinìq tôq, trùh hì mòe, aih èh qnhòng rìh da au hi dìq. ");
INSERT INTO hrebt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mahaq hì kô, hì da èh, xam hì mòe au ep lam, majah qmang aih wìa ka mangai pajàu ma cachìt enh gùng ka Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wùih! Jêrusalem, Jêrusalem, gè jêh cađac ƀài mangai pajàu, yŏc hmo hibùq ƀài mangai wê bàu trùh ti gè, bàc yàng au enh hacom haqmon pì qmang ka ia kan creo àm dèh kon ta panan, mahaq pì ùh waq! ");
INSERT INTO hrebt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kô èh, hnim pì wìa hnim catù. Au doe qmòe ka pì, kô èh pì pi hnoq au hòm trùh hì ma hi doe: Xôq ramot am ka Mangai trùh enh dalam ka Yiniq Chuaq.” ");
INSERT INTO hrebt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","I moeq hì sabat, Chuaq Jesus mùt acaq ta hnim mangai gucraq Pharisi, ƀài mangai ta aih ti achop ngan haq. ");
INSERT INTO hrebt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","I moeq ngai lìu ten padah oe enh ngèa haq. ");
INSERT INTO hrebt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Chuaq Jesus bòch mangai Pharisi xam mangai hnài ranenh: “Tiaq qmang ka ranenh ta hì sabat akhòh broq brêh ka mangai yinìq, loq ùh khòh?” ");
INSERT INTO hrebt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mahaq wì oe hatinh ùh padreo bàu. Chuaq Jesus dèch mangai yinìq yòng, broq brêh ka haq, khoe aih thê haq hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Khoe aih haq bòch wì: “taqne pì qmat i ka mangai leq wop hì sabat, i dèh moeq ngai kon lô qyoh, tàng ùh meh i dèh moeq toq ƀo clìh ta ralùng, pì ma ùh drah loh dèch qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Trong aih wì tèu ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jò haq hnoq ƀài mangai ma jah akhen trùh acaq ta aih, wì toq ràih ka rađeh nòe haqngui ma haqnhèq ranhòm, haq hi alìah ka wì: ");
INSERT INTO hrebt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Jò wì akhen ka ìh trùh acaq yiniang ŏng mai, apaq ràih hanqgui nòe rahù, tabeq i tamoe ma yeo kàn ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mangai akhen lam doe ka ìh: Dôq haq meh hangui ajang kô, aih ajoq ìh xep ka rađeh ep loh hangui enh qneq qmòh. ");
INSERT INTO hrebt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mahaq jò ìh jah akhen, ìh hangui đeh enh nòe haqneq raq, aih èh cla wì craq trùh, haq doe ka ìh: Ê daq! tŏc hangui enh qnhèq kô. Aih ajoq broq bàc ngai hadai jah akhen jah ta-iu ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Qmang aih cabô padèch rađeh, haq aih èh jah qnoh haqneq, mangai leq paqnoh rađeh haqneq, haq aih èh jah dèch atŏc”. ");
INSERT INTO hrebt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Khoe aih Chuaq Jesus anoe ka mangai ma akhen ka haq: “Jò ìh i yiniq akhen wì acaq ôq qne hì qnì, di xèq qnì, apaq akhen toq deh ka bua, deh ka oh daq calô, oh daq cadrì, xam wì plài pla ma kan padrŏng, yùq èh wì loq akhen hlài ka ìh đòeq hu caqnaih dòeh. ");
INSERT INTO hrebt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mahaq jò ìh i yiniq acaq ôq, akhen ka mangai pa, mangai angwenh, mangai liap, mangai lua mat, ");
INSERT INTO hrebt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","aih èh majah xôq ramot. Hiloq wì haq ùh hlàt akhen hlài ka ìh, mahaq trùh jò mangai taq atoq jah rìh hlài, aih èh hi jah padreo hlài ka ìh.” ");
INSERT INTO hrebt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","I moeq ngai hangui acaq moeq qmang ti haq, tàng bàu aih hi tèu: Xôq ramot am ka mangai ma jah acaq ƀênh tanòe diac Plình! ");
INSERT INTO hrebt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mahaq Chuaq Jesus padreo bàu rameh “I mangai aih haq padon yineang kàn, akhen ka bàc ngai lam acaq. ");
INSERT INTO hrebt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Trùh jò acaq, thê dèh hapŏng lam anoe ka ƀài mangai ma khoe jah akhen: Trùh beq, rìm yiniq dìq khoe jah padon. ");
INSERT INTO hrebt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mahaq dìq dŏng ka wì pajùm moeq bàu hangah. Mangai baxèm doe: Au i rot moeq haqnech ruàng, ep lam ngan, apaq da yo oq. ");
INSERT INTO hrebt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mangai qnoeq doe: Au i rot moeq jàt toq ƀo, au ep lam ngan qmang leq cadèh, apaq da yo oq. ");
INSERT INTO hrebt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mangai maqnoeq hòm doe: Au neo yŏc mai, au lam ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mangai hapŏng wìh hlài anoe dèh ka wì craq. Khoe aih craq hnim aih plôh nòeh, thê dèh hapŏng: “Drah loh roc trong, roc hanom taplài, aràng ƀài mangai pa, mangai angwenh, mangai lua xam mangai cwê mùt tacô.” ");
INSERT INTO hrebt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Khoe aih, hapŏng anoe: Wì craq bàu ìh thê nhèn khoe broq, mahaq nòe rah oe raq bàc. ");
INSERT INTO hrebt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mangai craq hnim doe deh ka hapŏng: “Loh lam roc plài roc gùng, hnoq mangai leq, pa-àu wì mùt, aih dôq haq bình ka hnim au. ");
INSERT INTO hrebt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Majah qmang aih au doe ka pì: Dìq dŏng ka mangai ma khoe jah akhen adroe, aih ùh i mangai leq ma oe jah acaq yiniang ta hnim au”. ");
INSERT INTO hrebt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","I ƀài mangai bàc haraya lam ti tiaq, haq hwi ngan wì aih rai doe. ");
INSERT INTO hrebt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tàng joq i mangai leq trùh ti au mahaq ùh git deh ka miq baq, cadrì, kon, oh daq cadrì, calô, git hloe kan rìh deh cla, haq aih ùh jah broq mangai tiaq hŏc au. ");
INSERT INTO hrebt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mangai leq ùh xùi deh long pagat tiaq au mangai aih hadai ùh wìa broq mangai tiaq hŏc au. ");
INSERT INTO hrebt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","I mangai leq oe taqne pì enh broq moeq toq hnim haqnhèq kàn. Ma ùh joq baxèm aih haq hangui òeq hu ngan dìq toq leq, đòeq ngan rađeh atàu bac đòeq pagêh hnim aih ùh? ");
INSERT INTO hrebt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Majah qmang aih jò haq khoe broq xèm èh ùh lênh gêh ka chac hnim, aih rìm ngai hnoq ajoq wì loq do, ");
INSERT INTO hrebt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wì doe: Mangai kô khoe broq, mahaq ùh lênh gêh”. ");
INSERT INTO hrebt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","I ka bùa leq lam tajêh ka bùa qnoe, ma ùh dùh hangui hatình ngan òeq, đòeq ngan rađeh qnung moeq muàn lình, ahlàt tablêq ka bùa tau ma wê baiq muàn lình loq ùh? ");
INSERT INTO hrebt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tàng joq haq hnoq đeh ùh blêq, jò bùa tau oe raq hangai haq khoe thê deh mangai hadrah chônh lam đòeq ti alìa aclai chaq trong hatroq. ");
INSERT INTO hrebt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hadai qmang aih, tàng joq pì ùh cađac dèh rìm yiniq pì ma i, pì ùh jah broq mangai tiaq hŏc Au. ");
INSERT INTO hrebt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Boh aih lem, mahaq tàng haq hnhung dèh kan xang, aih yŏc cleq broq dôq haq xang hlài hòm? ");
INSERT INTO hrebt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yac ka qnoh ta ruàng dua pi wìa, broq phàn dua piloh cleq; wì ep ùc qnoh cađac enh gùng. Cabô i don tamàng, drah tamàng beq!” ");
INSERT INTO hrebt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dìq dŏng ka ƀài mangai yŏc thèq xam ƀài mangai i yiniq lui thia haten ka Chuaq Jesus hu tamàng bàu haq hnài. ");
INSERT INTO hrebt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mahaq mangai Pharisi xam ƀài mangai hnài ranenh, bahech ka dabau: Mangai kô đìh toq ƀài mangai i yiniq lui rai acaq moeq qmang ka wì! ");
INSERT INTO hrebt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Haq hi alìah ka wì: ");
INSERT INTO hrebt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Taqne pì qmat, mangai leq ma i moeq hrinh toq trìu mahaq hnhung moeq toq raq, haq ma ùh đòeq dèh hachìn hachìn toq oe tanòe hawit, đòeq hu chaq trìu ma hnhung aih waq qmòe ka hnoq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Èh jò khoe hnoq, haq bùi pi cajaq, binh dèh trìu aih taplêh; ");
INSERT INTO hrebt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","hlài ta hnim. Khoe aih, haq creo deh ka ƀài bua xam wì plài, haq doe: Beq lem bùi ti au, majah qmang aih kon trìu au ma hnhung, au chaq hoe hnoq deh. ");
INSERT INTO hrebt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Au doe ka pì: Hadai qmang aih diq, ta plình lem bùi jò moeq ngai i yiniq lui loq raxach, ùh hnau ka hachìn jàt hachìn ngai taq atoq ùh ep raxach. ");
INSERT INTO hrebt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Patìah haq, i moeq ngai gucadrì i moeq jàt hliac bac, hnhung moeq hliac bac raq, haq ma ùh bùh đen, hwit hnim rai chaq qmòe ka da adia waq qmòe ka hnoq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Èh trùh jò haq chaq khoe hnoq, haq creo deh ka bua xam wì plaì haten, haq doe: Lem bùi ti au beq, majah qmang aih bac au ma hnhung au chaq khoe hnoq. ");
INSERT INTO hrebt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Au doe ka pì: Enh ngèa bình plình Boc Plình hadai qmang aih, wì lem bùi ka mangai i yiniq lui loq raxach.” ");
INSERT INTO hrebt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Haq anoe hòm: “I moeq ngai tau haq i baiq ngai kon calô. ");
INSERT INTO hrebt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mangai kon ma qyoh doe deh ka baq: Baq, hang leq ma axong ka au, am da au. Mangai baq hi axong deh kùng hang am ka wa kon. ");
INSERT INTO hrebt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Atìq ka aih ƀiaq hì, mangai oh yŏc dŏng deh kùng hang, lam ka hangai, ta aih, haq rìh loh ka pi wìa cleq, acaq racaih hreo dŏng deh kùng hang. ");
INSERT INTO hrebt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jò haq racaih khoe dìq dŏng kùng hang, gùng aih i kan pangot kàn, haq loh ka nan pa, ");
INSERT INTO hrebt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","haq hi lam patìh ka wì gùng aih, wì thê haq lam ban chùa tagùng. ");
INSERT INTO hrebt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Haq enh yŏc đeh caqnhah tòh đòeq chem chùa hu acaq đeh ka panàc, mahaq dua wì ùh am. ");
INSERT INTO hrebt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jò aih haq men cadrat don, haq doe: Ta hnim baq au, oe i jaq cleq mangai patìh jah acaq ùh dìq ùh dài, tacô aih au cachìt ka hrah. ");
INSERT INTO hrebt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Au kô èh yòng hu wìh hlài dèh ta baq rai anoe ka haq: Baq! Au khoe broq yiniq lui ka plình xam ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Au pi oe wìa creo kon ìh hòm, ìh ngan au tìah ka wì ma patìh ka ìh diq. ");
INSERT INTO hrebt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Haq hi padinh yòng hlài dèh ta baq. Jò oe raq enh hangai, hnoq deh kon baq haq tadèch qmòe nòeh, tùh loh yŏc tì kwat dèh kon raih hìp haq. ");
INSERT INTO hrebt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Haq doe deh ka baq: Baq! au khoe i yiniq lui ka trŏc ka ìh, pi oe wìa ka creo kon ìh hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mahaq baq haq doe ka ƀài mangai hapŏng: Rênh haq! Drah aràng eo ma dìq jaq lem caxùnh am ka haq, asràng nhàn ajang hadrang tì haq, tŏc ka haq jep. ");
INSERT INTO hrebt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Drah rùp kon ƀo ma bit lem hu broq jam. Beq! bèn acaq lem bùi, ");
INSERT INTO hrebt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","majah qmang aih kon au kô khoe cachìt mahaq manòeq khoe rìh hlài, khoe hnhung mahaq manòeq kô khoe hnoq hlài. Khoe aih, dìq ka wì hi lem bùi. ");
INSERT INTO hrebt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jò aih, mangai daq ramua qnang oe ta gùng. Jò haq hlài ten trùh hnim, tàng atêh broc tàng bàu calêu, ");
INSERT INTO hrebt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","haq hi creo ka moeq ngai hapŏng hu bòch ngan i yiniq cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hapŏng aih padreo bàu: Oh ìh khoe hlài, aih ìq baq ìh majah khoe bùh kon ƀo bit, majah qmang aih, hnoq oh ìh hlài jah tadêh. ");
INSERT INTO hrebt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mangai kon ramua plôh nòeh, pi waq mùt ta hnim. Baq haq hi loh padô haq mùt. ");
INSERT INTO hrebt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mahaq haq doe: Ngan kô, au patìh ka ìh khoe toq leq hanam, qnhòq lah i yàng leq broq ùh troq ka manoh ìh, aleq ìh malah am ka au moeq toq kon bubi qyoh au hu acaq lem bùi deh ti bua. ");
INSERT INTO hrebt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yàng manòeq kô, kon ìh mangai ma khoe racaih dŏng kùng hang ìh ti ƀài gucadrì hađoh, manòeq haq wìh hlài aih ìh bùh qmòe kon bo bit. ");
INSERT INTO hrebt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Baq haq doe: Akon! Kon oe yôt ti baq, dìq dŏng kùng hang baq aih xài kùng hang kon. ");
INSERT INTO hrebt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mahaq bèn joq khòh acaq yiniang lem bùi, majah qmang aih oh kon khoe cachìt mahaq manòeq khoe rìh hlài, khoe hnhung mahaq khoe hnoq hlài.” ");
INSERT INTO hrebt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Chuaq Jesus anoe hòm ka ƀài mangai tiaq hŏc “Mangai padrŏng tau i moeq ngai hapŏng wèq da haq kùng hang, i wì lam anoe ka haq: Wì craq! haq aih racaih dŏng hang wì craq. ");
INSERT INTO hrebt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aih wì craq hi creo ka mangai aih mùt rai bòch: Ìh broq cleq! hagleq au majah tàng wì anoe qmang aih ìq? Ìh wèq kùng hang qmang leq, anoe beq! Majah qmang aih, pang kô èh ìh pi oe jah wèq kùng hang au hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mangai wèq kùng hang aih hèm: Wì craq pi am au broq hòm, broq qmang leq kô èh? abèq ruàng au ùh i ka padren, lam chaq acaq aih camaih hrìn. ");
INSERT INTO hrebt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Au khoe loq broq qmang leq, đòeq jò wì craq pi am broq, oe i mangai đìh ahlài au ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Haq hi creo ka tang ngai pòq dòeh wì craq trùh, haq bòch mangai adroe: Ìh pòq dòeh craq au toq leq? ");
INSERT INTO hrebt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mangai aih doe: Moeq hrinh thùng dàu. Mangai wèq kùng hang thê: Drah yŏc jàiq hangui aqmat achìh beq: Padam jàt. ");
INSERT INTO hrebt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Èh haq bòch mangai tau: Ha ìh qmat pòq dòeh craq au toq leq? Haq padreo bàu doe: Moeq hrinh ateo qmau. Mangai wèq kùng hang doe: Drah achìh jàiq dòeh: Rahem jàt. ");
INSERT INTO hrebt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Craq haq hi manè mangai wèq kùng hang loq gôpla trong haq rabiaq ka broq qmang aih. Majah qmang aih kon da qnhòng kô yeo rabiaq ùh hnau ka kon da kan qngah trong taqmùt ti dabau. ");
INSERT INTO hrebt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Au anoe ka pì: Yŏc ma dìq ka hang gôpla aih hu taqmùt chaq bua beq, dôq jò hang aih khoe dìq, wì hu đìh qmùt pì tanòe oe hloe. ");
INSERT INTO hrebt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mangai leq ùh tablòq manoh trong yiniq qyoh, haq aih hadai ùh tablòq manoh trong yiniq kàn, mangai leq gôpla trong yiniq qyoh, hadai gôpla trong yiniq kàn. ");
INSERT INTO hrebt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Qmang aih tàng kùng qnhòng kô, pì khoe ùh dìq ka manoh, aih èh cabô ma tùt am ka pì wèq kùng hang joq qnàng ta diac plình? ");
INSERT INTO hrebt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tàng joq khoe pi wìa ka lùi pì trong kùng hang mangai qnoeq, aih cabô oe dôq pì jah wèq deh kùng hang cla? ");
INSERT INTO hrebt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ùh i ka hapŏng leq jah patìh ka baiq toq craq, majah qmang aih haq loq waq ka mangai kô mahaq git ka mangai tau, dìq manoh ka mangai kô mahaq hnoq mangai tau ùh loh cleq. Pì ùh jah broq hapŏng Boc hlình rai broq hapŏng Mamôn hòm.” ");
INSERT INTO hrebt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mangai Pharisi aih ƀài ma plai ka bac jèn, tàng dìq bàu aih, wì haq halê Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Haq tapoch ka wì: “Pì broq deh taq atoq dôq mangai qnoe ùh qni, mahaq Boc plình loq ka manoh pì, majah qmang aih trong leq kon mangai pì hnoq đeh lem, aih kan amùa ramòt enh ngèa ka Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ranenh xam bàu pajàu trùh pang qnhòng da Jon raq hi dìq, pang aih Bàu lem diac da Boc Plình jah anoe qnoh, mangai leq mangai meh ep àu dìq ka padren hujah mùt ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Plình crŏng taneh kô hnhung yi hlàu ùh hnau ka cađac moeq chù, moeq teo yi qyoh ta hset ranenh. ");
INSERT INTO hrebt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Cabô cađac deh mai lam yŏc cadrì qnoeq, mangai aih pòq yiniq lui tango, mangai leq yŏc gucadrì ŏng haq cađac, hadai pòq yiniq lui tango. ");
INSERT INTO hrebt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","I moq ngai padrŏng kan, caxùnh toq eo gòh drinh broq xi bai lem, rìm hì rìh acaq oe ta kan rahù. ");
INSERT INTO hrebt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","I moeq ngai pa yiniq haq Laxaro, kùi ajang qmang ngo mangai padrŏng aih, tachac haq xìa dŏng kan talêh bachùng. ");
INSERT INTO hrebt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Haq toq ngèh đeh jah toch acaq chiac ƀài cràc taclìh enh caƀŏng mangai padrŏng, hadai i koq liah da haq rahenh. ");
INSERT INTO hrebt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Trùh jò mangai pa cachìt, ƀình plình aràng haq qmùt oe ta achong Apraham. Mangai padrŏng hadai cachìt, wì lam catùh. ");
INSERT INTO hrebt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mangai padrŏng oe tanòe mangai kachìt, qnang chìuq salep, enh hangai haq qngoc ngan, hnoq Laxaro oe ta achong Apraham, ");
INSERT INTO hrebt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","haq drah creo cadêh: Apraham kan cadraq au! Ha-och ka au diq, thê Laxaro lùac hadrang tì tadiac đòeq broq ka rapet au jah hangèp đeh toq ƀiaq, majah qmang aih au tôq lep pi cajaq ta ùnh kô. ");
INSERT INTO hrebt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mahaq Apraham doe: A kon! Hmàng hlài beq, jò oe rìh kon khoe jah waq deh kan lem, yàng Laxaro aih glàm toq trong qmèq, Yàng manòeq oe tacô haq jah alòng, da kon jah oe tanòe baxa. ");
INSERT INTO hrebt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Qnah hòm, ta adreo bèn i moeq toq kòe jrùq, yac ka i cabô oe pah kô enh tŏc pah qmat dua ùh jah, cabô enh pah qmat enh tŏc pah kô hadai ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mangai padrŏng aih anoe: Kan cadraq au! Ìh thê Laxaro lam ta hnim baq au, ");
INSERT INTO hrebt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","majah qmang aih au i padam ngai oh daq, đòeq haq doe ka wì loq yiniq kô, tàng ùh qmang aih, yùq èh wì hadai loh tanòe xalep kô diq. ");
INSERT INTO hrebt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Apraham padreo bàu: Wì haq khoe i Môise xam ƀòe pajàu, wì haq ep tamàng bàu wì aih. ");
INSERT INTO hrebt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mangai padrŏng anoe: Apraham kan cadraq au, ùh xài qmang aih, tàng joq i mangai cachìt rìh hlài trùh ta wì haq, aih èh wì haq hi raxach. ");
INSERT INTO hrebt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mahaq Apraham doe tàng joq ùh tamàng Môise xam ƀài pajàu, yac ka i mangai cachìt rìh hài, dua wì haq ùh lùi”. ");
INSERT INTO hrebt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Chuaq Jesus doe ka magai tiaq hŏc: “Ƀài yiniq đòeq broq ka mangai qnoeq catoeh tacro aih ùh jê, mahaq haƀo ka rađeh mangai ma broq trong aih. ");
INSERT INTO hrebt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tàng joq mangai leq broq ka moeq ngai kon mangai qyoh kô cro ta yiniq lui, yŏc apau hmo kàt ajang ranŏng haq aih hu khwênh caqnìh cađac ta diac raxìq aih xan ka ùh hnau hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pì ep wèq rađeh. Tàng joq i oh daq ìh broq yiniq lui ka ìh, drah tagàih ka haq, tàng joq wì haq loq raxach, drah cađac yiniq lui ka wì haq. ");
INSERT INTO hrebt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yac ka moeq hì, wì loh yiniq ka ìh tapèh yàng, tapèh yàng wì haq wìh hlài doe: Au raxach, aih drah caqnaih yiniq lui wì haq. ");
INSERT INTO hrebt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ƀài mangai tiaq cla doe ka haq: Tam ka nhèn manoh lùi. ");
INSERT INTO hrebt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chuaq Jesus doe: “Tàng joq pì i manoh lùi qyoh budàng clong habài, pì doe ka long pôh kô: Tabùiq enh kô hu loh pìt tadiac raxìq chàm, aih dua haq iu bàu ");
INSERT INTO hrebt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Taqne pì qmat i mangai leq i hapŏng lam kai ruàng, lam ban trìu, jò haq hlài enh gùng pì doe ka haq: Drah thia hangui tacô hu acaq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma ùh xài pì thê haq: Padon ka au acaq, kàt caxi caqnam patìh ka au hòeq, trùh jò leq au hêq ka acaq, khoe aih pì hi acaq diq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hapŏng iu tiaq bàu, craq haq i ep cleq ka manè haq? ");
INSERT INTO hrebt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pì hadai qmang aih, jò broq gêh trong thê pì broq, pì doe rameh: Nhèn kô ƀài hapŏng ùh loh cleq, nhèn broq toq trong nhèn ma ep broq.” Mòeq jàt ngai bacùn ");
INSERT INTO hrebt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Manòeq Chuaq Jesus qnang lam trong tŏc ta Jêrusalem, Haq lam tiaq roc acang taqne gùng Samari xam gùng Galili. ");
INSERT INTO hrebt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wop jò haq mùt taplài aih, i moeq jàt ngai bacùn đìh haq, wì haq yòng enh hangai, ");
INSERT INTO hrebt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","wì creo: Wì craq! ha-och ka nhèn diq. ");
INSERT INTO hrebt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jò bu hnoq wì aih, Chuaq Jesus doe: “Lam beq! lam patô rađeh ka ƀài pajàu.” Jò wì aih qnang lam, dìq ka wì haq jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","I moeq ngai, hnoq rađeh jah brêh, haq wìh hlài, rai dêh bàu manè apôi Boc plình; ");
INSERT INTO hrebt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","mangai aih caqnìh rađeh ajang jènh Chuaq rai manè haq. Kô aih mangai Samari. ");
INSERT INTO hrebt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chuaq Jesus bòch: “Ùh xài moeq jàt ngai jah brêh dŏng qmòh? Hachìn ngai tau taleq hòm? ");
INSERT INTO hrebt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hagleq ùh i moeq ngai leq wìh hlài manè apôi Boc plình enh gùng ka mangai diac wì kô”. ");
INSERT INTO hrebt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Khoe èh, haq doe ka mangai aih: “Yòng lam beq! manoh lùi ìh khoe broq ìh brêh lem.” ");
INSERT INTO hrebt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mangai Pharisi bòch Chuaq Jesus jò leq diac Plình ma trùh, haq padreo bàu “Diac plình trùh ùh tìah ka yiniq jah hnoq xam mat, ");
INSERT INTO hrebt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ùh i cabô jah doe: Oe tacô loq oe hatau, majah qmang aih diac plình oe ta pì.” ");
INSERT INTO hrebt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Haq doe deh ka mangai tiaq hŏc: “Kô èh i jò pì ma tangèh jah hnoq đeh mòeq hì da Kon mangai, mahaq ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Èh i wì doe ka pì: Haq oe tacô loq oe ta tau, mahaq apaq lam, paq tiaq wì. ");
INSERT INTO hrebt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Majah qmang aih tìah ka camlet enh caqnàm plình kô trùh ta caqnàm plình tau qmang leq, Kon Mangai trùh dèh hì cla haq hanoh qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mahaq adroe aih, Kon mangai ep xalep bàc trong, èh kon mangai qnhòng kô kwaih ùh waq đac haq. ");
INSERT INTO hrebt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bìac ma khoe loh ta hì Noê nèh qmang leq, hì da Kon Mangai trùh hadai qmang aih: ");
INSERT INTO hrebt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wì acaq, ôq, ban ŏng, yŏc mai, trùh hì Noê hi mùt ta boang, diac kàn trùh, palùng dìq dŏng phù cròng. ");
INSERT INTO hrebt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yiniq ma khoe loh ta hì da Lot nèh hadai, wì acaq ôq, wì tapadro, wì pìt, wì broq hnim. ");
INSERT INTO hrebt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mahaq hì Lot loh khoe enh gùng Sôđom, aih i mè ngia ùnh clìh enh plình jêh dŏng mangai ta plài aih. ");
INSERT INTO hrebt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Hì Kon mangai loh hadai qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Hì aih èh, cabô oe ta kùa po, i dahwèq ta hnim, ùh dùh loh qnhon, cabô oe tagùng, hanoh ùh dùh wìh hlài dèh. ");
INSERT INTO hrebt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Hmàng hlài cadrì Lot beq! ");
INSERT INTO hrebt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mangai leq chaq trong hu dèch dèh kan rìh, aih èh hnhung, mangai leq cađac deh kan rìh, aih èh jah yŏc hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Au doe ka pì, mang aih, baiq ngai kùi moeq aniang, mòeq ngai jah dèch atŏc, mòeq ngai rong đòeq hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Baiq ngai gucadrì pêh pajùm mòeq toq apau qmau, mòeq ngai jah dèch atŏc, mòeq ngai jah rong đòeq hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Baiq ngai gucalô oe tagùng, mòeq ngai jah dèch atŏc, mòeq ngai jah rong đòeq hlài.” ");
INSERT INTO hrebt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mangai tiaq hŏc bòch: Chuaq nhèn! yiniq aih èh loh taleq? Haq padreo bàu: “Taleq i hanang cachìt, cliang kèn tagop dabau ta aih”. ");
INSERT INTO hrebt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Chuaq Jesus alìah ka mangai tiaq hŏc mòeq yiniq, dôq wì loq ep waiq khàn yôt, ùh dùh tagah lep: ");
INSERT INTO hrebt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tagùng aih, i mòeq ngai cwan ùh yùq ka Boc Plình, rai ùh camaih qmòe ka cabô. ");
INSERT INTO hrebt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tagùng aih hadai i mòeq ngai gucadrì hadrô, trùh anoe ka cwan: Au canòm chiac ka ìh, hadrah taq atoq am ka au xam mangai tagit ka au. ");
INSERT INTO hrebt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Cwan aih ùh tamàng khoe dùnh. Yàng khoe ka aih haq hèm: Hiloq ka au ùh yùq ka Boc plình, ùh camaih qmòe ka cabô, ");
INSERT INTO hrebt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mahaq mangai gucadrì kô lam pangài yôt qmòe ka au, hêq au tamàng dŏng ka haq kan taq atoq, dôq haq pi hìaq trùh yôt broq ka au loh qmòe ka jìq gàu. ");
INSERT INTO hrebt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Khoe aih, haq bòch wì: “Pì atàng bàu cwan hadrah ùh taq atoq aih khoe anoe cleq ùh? ");
INSERT INTO hrebt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Qmang aih yilaiq Boc plình ma ùh hadrah taq atoq ka mangai ma khoe jah ràih, aih ƀài mangai dahì damang toq creo dang haq, wìa ka haq xòe ka trùh hu dèch wì aih qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Au doe ka pì: Haq drah rênh tamàng kan taq atoq ka wì. Mahaq èh jò Kon mangai hi trùh haq i hnoq manoh lùi oe ta crŏng taneh loq ùh? ");
INSERT INTO hrebt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Haq alìah bàu kô ka ƀài mangai loq doe rađeh taq atoq èh hnoq mangai qnoeq ùh loh cleq: ");
INSERT INTO hrebt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“I baiq ngai tŏc ta hnim kùh waiq hu waiq khàn: mòeq ngai Pharisi, mòeq ngai yŏc thèq. ");
INSERT INTO hrebt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mangai Pharisi yòng waiq khàn ta manoh qmang kô: Waiq Boc plình, au manè apôi ìh, majah qmang aih au ùh hìaq tìah ka wì qnoeq: loq atùng, broq dù, loq tango, ùh hìaq tìah ka mangai yŏc thèq meh. ");
INSERT INTO hrebt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mòeq tuàn au apàm ka acaq baiq yàng, tarìm yiniq au i, mòeq jàt phàn au dèch mòeq. ");
INSERT INTO hrebt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mahaq mangai yŏc thèq yòng chiac enh hangai, haq ùh lùi qngoc taplình, haq tùc dèh rada rai anoe: Boc plình, ha-och ka au diq, au mangai i yiniq lui! ");
INSERT INTO hrebt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Au doe ka pì, enh ngèa ka Boc plình, mangai kô wìh hlài deh ta hnim jah kan taq atoq ùh hnau ka mangai tau. Majah qmang aih, mangai leq chaq trong padèch atŏc rađeh, aih èh jah caqnìh qnoh haqneq, mangai leq paqnoh rađeh, aih èh jah dèch atŏc ka haqnhèq”. Bòe kon qyoh ");
INSERT INTO hrebt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wì hadai aràng ƀài kon qyoh trùh ti Chuaq Jesus, dôq haq yŏc tì bèq wì qyoh aih. Mangai tiaq hŏc hnoq qmang aih, hi lech ka ƀài mangai aràng. ");
INSERT INTO hrebt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mahaq Chuaq Jesus crêu anoe ka wì: “Dahaq wì qyoh trùh ti au, apaq tàt, majah qmang aih mangai hatìah ƀài kon qyoh qmat majah diac Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Joq qnàng au doe ka pì, cabô ùh waq yŏc diac Boc plình tìah ka mòeq ngai kon qyoh, haq aih ùh jah mùt diac Plình”. ");
INSERT INTO hrebt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jò aih i mòeq ngan cwan bòch Chuaq Jesus: Mangai hnài lem, au ep broq cleq đòeq hu jah kan rìh halình mòeq đòe? ");
INSERT INTO hrebt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Haq padreo bàu: “Hagleq ìh majah creo ka au mangai lem. Ùh i ka mangai leq lem enh gùng ka mòeq ngai Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ìh khoe loq ƀài ranenh kô: Ìh apaq tango, apaq jêh đac mangai, apaq atùng, apaq wiang yòng đòeq capoch dech ka mangai qnoeq. Ep i loq hèm dèh ka miq baq”. ");
INSERT INTO hrebt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mangai aih doe: Dìq dŏng rìm yiniq aih au khoe wèq qmòe enh jò oe qyoh nèh raq. ");
INSERT INTO hrebt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chuaq Jesus tàng qmang aih, hi doe ka haq: “Ìh oe raq i mòeq yiniq hòm. Tech dŏng kùng hang ìh beq, axong am ka mangai pa èh ìh hi jah hang oe ta plình, khoe aih ìh trùh, hu lam tiaq au.” ");
INSERT INTO hrebt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jò tàng qmang aih, mangai radam aih loh ka mangò, majah qmang aih haq padrŏng pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chuaq Jesus ngan ta haq rai doe: “Mangai padrŏng mùt diac Boc plình joq xa. ");
INSERT INTO hrebt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lŏcđa mùt trom jrùm yeo hlàu ka mangai kan mùt diac Plình”! ");
INSERT INTO hrebt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ƀài mangai tàng bàu aih, wì bòch: Qmang aih èh cabô majah dèch? ");
INSERT INTO hrebt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Haq padreo bàu: “Trong leq mangai broq ùh jah, aih Boc plình broq jah.” ");
INSERT INTO hrebt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Phiero bòch: Hacô nhèn khoe cađac dìq dŏng yiniq nhèn i đòeq hu tiaq ìh, aih èh nhèn jah cleq? ");
INSERT INTO hrebt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Chuaq Jesus padreo bàu: “Joq qnàng au doe ka pì, mangai leq taiq diac Plình loh qmòe ka cađac deh hnim, miq baq, oh daq, cadrì kon, ");
INSERT INTO hrebt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","oe ta qnhòng kô haq jah hlài yeo bàc, qnhòng atìq jah kan rìh halình mòeq đòe.” ");
INSERT INTO hrebt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Chuaq Jesus qnong wì mòeq jàt baiq ngai lam crài ti rađeh, haq doe ka wì: “Kô èh bèn tŏc ta Jêrusalem, rìm yiniq ƀài pajàu ma khoe achìh trùh Kon mangai èh hi jah xìt. ");
INSERT INTO hrebt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Majah qmang aih wì rùp haq am ka mangai diac wì. Wì halê haq, hanip haq rai cachôh ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Khoe ka wì blai haq wì hi jêh cađac haq. Trùh hì piq, haq hi rìh hlài.” ");
INSERT INTO hrebt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mahaq ƀài mangai tiaq hŏc ùh qnì tàng, bàu aih enh anoe cleq majah qmang aih khoe cadoc ka ƀài mangai tiaq hŏc, dài wì haq majah ùh qnì Chuaq Jesus anoe cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jò Chuaq Jesus ten trùh ta Jêrico, i mòeq ngai lua mat hangui ti trong đòeq hu ti axìn acaq. ");
INSERT INTO hrebt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jò haq tàng i ƀài mangai bàc lam trong aih, haq bòch i yiniq cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","wì doe ka haq: Chuaq Jesus mangai Naxaret lam trong kô. ");
INSERT INTO hrebt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Haq crêu cadêh: Waiq Kon bùa Đawit, ha-och ka au diq! ");
INSERT INTO hrebt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bài mangai lam adroe lech thê haq chaq oe ma hatinh haq; yàng aih kiang haq creo yeo dêh hòm: Kon bùa Đawit ha-och ka au diq! ");
INSERT INTO hrebt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chuaq Jesus hi yòng rai thê wì aràng mangai aih trùh. Jò mangai lua mat trùh ten jang aih, haq hi bòch: ");
INSERT INTO hrebt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ìh enh au broq ka ìh cleq?” mangai aih doe: Waiq Chuaq! au enh jah xau hnoq! ");
INSERT INTO hrebt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chuaq Jesus doe ka haq: “Xau hnoq hlài beq! Manoh lùi da ìh khoe broq brêh ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tajòe qmòe jò aih raq, haq jah xau hnoq hlài, haq hi lam tiaq Chuaq Jesus rai manè apôi Boc plình. Dìq ka mangai hnoq qmang aih wì hadai manè apôi Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Chuaq Jesus mùt ta Jêrico, haq pagat ti trong. ");
INSERT INTO hrebt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ta aih i mòeq ngai yiniq haq Xachê, broq gàu ƀài mangai yŏc thèq, padrŏng pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Haq aih enh hnoq Chuaq Jesus aih mangai qmang leq, mahaq ùh jah, majah qmang aih mangai bàc hrình, èh haq aih mangai đêq. ");
INSERT INTO hrebt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Haq cadàu adroe, heo tŏc goe long pŏc đòeq hu jah ngan Chuaq Jesus, majah qmang aih Chuaq Jesus lam trong aih. ");
INSERT INTO hrebt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chuaq Jesus trùh ajang aih, qngoc ngan rai crêu: “Xachê! drah loh beq, majah qmang aih hì kô au mùt hnim ìh.” ");
INSERT INTO hrebt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Xachê drah loh qmòe ka rênh, rai đìh Chuaq Jesus rai lem bùi. ");
INSERT INTO hrebt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dìq dŏng mangai hnoq qmang aih, wì bahech ka dabau: Mangai kô ka doe mùt oe ta hnim mangai i tuiq. ");
INSERT INTO hrebt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mahaq Xachê padinh yòng rai anoe: Waiq Chuaq! Au yŏc deh moeq haqne hang cla au hu đòeq axong ka mangai pa, tàng joq au i broq haƀo ka cabô yiniq cleq ùh loe, au padreo hlài loe pôn yàng. ");
INSERT INTO hrebt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chuaq Jesus doe: “Hì kô, kan dèch khoe mùt ta hnim kô, majah qmang aih haq kô hadai kon xau Apraham. ");
INSERT INTO hrebt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Majah qmang aih Kon mangai trùh hu chaq dèch mangai ma khoe hnhung”. Alìah trùh ƀac ");
INSERT INTO hrebt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jò wì oe raq tamàng bàu aih, Chuaq Jesus tam mòeq alìah ka wì hòm, majah qmang aih haq khoe ten trùh Jêrusalem, wì xoh dèh diac Boc plình loh hloe draq drình jò aih raq. ");
INSERT INTO hrebt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Haq doe rameh: “I mòeq ngai kon bùa lam hangai đòeq hujah dèch broq bùa khoe èh hi wìh hlài; ");
INSERT INTO hrebt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","haq hi crêu dèh moeq jàt ngai hapŏng, am ka wì aih moeq jàt capiac bac, rai tanap: Yŏc ƀac kô abroq dôq haq loh tam trùh hì au wìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mahaq mangai gùng aih git ka haq, wì thê mòeq mangai wê bàu atìq ka haq hu doe: Nhèn ùh enh mangai kô broq bùa wèq nhèn. ");
INSERT INTO hrebt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Jò haq khoe jah dèch broq bùa, haq wìh hlài, crêu ka ƀòe mangai khoe yŏc ƀac trùh ta haq, đòeq hu ngan mòeq ngai wì broq jah toq leq. ");
INSERT INTO hrebt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mangai adroe trùh doe: Wì craq! ƀac ìh khoe loh tam mòeq jàt capiac qnoeq hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wì craq doe: Joq wìa qnàng, mangai hapŏng lem da au, trong qyoh ìh khoe dìq ka manoh, ìh kô èh jah wèq mòeq jàt gùng. ");
INSERT INTO hrebt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hapŏng ma hatìa trùh doe: Wì craq! ƀac ìh am, au khoe broq jahtam padam capiac hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wì craq doe: Ìh jah wèq padam gùng. ");
INSERT INTO hrebt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mangai qnoeq hòm trùh doe: Wì craq! Hacô ƀac ìh, au khoe caxop don đòeq ta mù, ");
INSERT INTO hrebt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","majah qmang aih au crè ka ìh, au loq ìh kô mangai nhang ùh palap cleq, yŏc tanòe ìh ùh i đòeq, gat tanòe ùh i rai. ");
INSERT INTO hrebt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Wì craq doe: Wùih! mangai hapŏng dù tau, au tiaq bàu cla ìh raq đòeq hu hadrah ka ìh, ìh khoe loq ka au mangai nhang, yŏc toq taqnòe ùh i đòeq, gat toq tanòe ùh i rai, ");
INSERT INTO hrebt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","hagleq ùh yŏc ƀac aih tah ta hnim padro ƀac? jò au hlài au hu yŏc dèh xam xèm xam goe. ");
INSERT INTO hrebt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wì craq doe ka ƀài mangai ma yòng ta aih: yŏc ƀac haq qmat, am ka mangai ma khoe i moeq jàt capiac ƀac. ");
INSERT INTO hrebt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wì doe: Wì craq! haq aih khoe jah mòeq jàt capiac ƀac. ");
INSERT INTO hrebt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Au doe ka pì: mangai leq khoe i, aih èh jah am tam, mangai leq ùh i, aih èh yŏc hloe cleq wì haq ma khoe i. ");
INSERT INTO hrebt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mahaq ƀài mangai leq ma tagit ka au, ùh enh ka au broq bùa enh qnhèq ka wì haq, qnoh wì haq tacô, jêh cađac enh ngèa au kô.” ");
INSERT INTO hrebt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Atìq ka Chuaq Jesus tapoch qmang aih, haq lam enh ngoe ka wì, tŏc ta Jerusalem. ");
INSERT INTO hrebt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jò haq ten trùh ta plài Bêpha-jê xam plài Bêthani ajang wang Ôliu, haq thê deh baiq ngai tiaq hŏc lam, ");
INSERT INTO hrebt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","rai tanap: “Lam ta plài enh ngèa chôp qmat, Jò mùt ta plài chôp hnoq mòeq toq lùa kon wì kàt, qnhòq lah i cabô kòe, caqnaih caxi dùi ahlài tacô ka au. ");
INSERT INTO hrebt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tàng i cabô bòch chôp: gleq chôp majah caqnaih haq? Chôp doe: Chuaq i yiniq waq ka haq”. ");
INSERT INTO hrebt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Baiq ngai loh lam, glàm tìah ka bàu Chuaq Jesus khoe doe. ");
INSERT INTO hrebt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jò qnang caqnaih lùa kon aih, cla mangai ban lùa aih bòch: Hagleq majah caqnaih lùa mat, ");
INSERT INTO hrebt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","wa padreo bàu: Chuaq i yiniq waq. ");
INSERT INTO hrebt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wa aih tiaq lùa aih ahlài ka Chuaq khoe èh yŏc deh eo hlèch ta crŏng lùa, dèch Chuaq tŏc hangui enh qnhèq. ");
INSERT INTO hrebt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jò Chuaq Jesus qnang tŏc ti trong, bàc ngai qyŏc dèh eo hlèch ti trong lam. ");
INSERT INTO hrebt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jò ten trùh criang Ôliu, dìq dŏng mangai tiaq hŏc manè pi cajaq, wì dêh bàu manè apôi Boc plình rìm trong halac wì haq ma khoe hnoq. ");
INSERT INTO hrebt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Xôq ramot am ka bùa trùh ma trùh enh dalam ka Yiniq Chuaq Kan catèm tanòe diac Plình, kan ra nhòm tanòe dìq jaq haqnhèq” ");
INSERT INTO hrebt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","I ƀài mangai Pharisi oe ta mangai bàc ta aih anoe ka Chuaq Jesus: Mangai hnài, ìh tagàih ƀài mangai hŏc tiaq ìh qmat. ");
INSERT INTO hrebt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chuaq Jesus padreo bàu: “Au doe ka pì, tàng joq wì qmat hatinh, ƀài hmo qmat èh hi cachech”. ");
INSERT INTO hrebt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jò Chuaq Jesus haten ngan hnoq Jêrusalem, haq hmoe ka Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Haq doe: “Au ngèh hì kô, gè loq yiniq cleq aràng am ka gè kan catèm, mahaq yiniq aih hì kô khoe gahnàp, mat gè ùh xau hnoq.” ");
INSERT INTO hrebt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Majah qmang aih i mòeq hì trùh ti gè, jò wì ma tagit ka gè bŏc lì wa wênh ka gè, dudan ka gè tap bè; ");
INSERT INTO hrebt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","wì raliang jêh cađac dìq dŏng, xam cla xam wì kon ma oe taqne gè qmat. Wì ùh đòeq mòeq pliang hmo leq oe jah raxon enh qnhèq ka dabau, majah qmang aih, gè khoe ùh canau jò Boc plình trùh ti dađeh”. ");
INSERT INTO hrebt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jò Chuaq Jesus mùt ta hamlang hnim kùh waiq, haq drùh qnoh dŏng ƀài mangai padro ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Haq doe: “I bàu achìh: Hnim au kô hnim waiq khàn, mahaq pì broq haq wìa pù atùng.” ");
INSERT INTO hrebt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Rìm hì haq hnài ta hnim kùh waiq. Ƀài pajàu kàn, ƀài mangai hnài ranenh xam ƀài gucraq gùng aih, chaq trong jêh đac haq; ");
INSERT INTO hrebt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mahaq wì ùh qnì chaq trong leq, majah qmang aih dìq dŏng mangai ta aih ùh talìc ka tamàng bàu haq. ");
INSERT INTO hrebt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","I mòeq hì ta bài hì aih Chuaq Jesus qnang hnài wì tanòe hnim kùh waiq rai anoe ka wì trong Bàu lem, i ƀài pajàu kàn, ƀài mangai hnài ranenh, taqmùt ti ƀài gucraq trùh ta haq, ");
INSERT INTO hrebt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wì bòch: Anoe ka nhèn cwìang enh leq ìh majah broq qmang kô, cabô ma am ka ìh cwìang aih? ");
INSERT INTO hrebt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Haq padreo bàu: “Au hanoh bòch pì mòeq bàu. Drah anoe ka au: ");
INSERT INTO hrebt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ƀaptem da Jon trùh enh Plình loq loh enh mangai? ");
INSERT INTO hrebt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wì aih ta hatình ka dabau: Tàng bèn doe: Trùh enh Plình, aih èh haq bòch bèn: Qmang aih gleq pì ma ùh lùi bàu haq? ");
INSERT INTO hrebt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tàng bèn doe: Loh enh mangai, aih èh dìq ka mangai bàc wì yŏc hmo đàp bèn, majah qmang aih wì khoe lùi Jon aih joq mangai pajàu. ");
INSERT INTO hrebt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Qmang aih wì padreo bàu doe: Nhèn ùh qnì haq loh enh leq. ");
INSERT INTO hrebt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chuaq Jesus doe: “Au hadai ùh doe ka pì loq cwìang enh leq au ma broq ƀòe yiniq kô.” ");
INSERT INTO hrebt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Haq alìah hloe ka wì qmang kô: “I mòeq ngai pìt mòeq wuàn plì nho, am ka wì broq axong wuàn nho aih khoe èh cla haq lam gùng hangai dùnh hì. ");
INSERT INTO hrebt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Trùh jò git plì, cla haq thê deh mòeq ngai hapŏng trùh ta ƀài pìt nho hu ta axon yŏc plì, mahaq ƀài mangai pìt nho jêh hapŏng aih, hnan haq hlài tì dech. ");
INSERT INTO hrebt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wì craq thê hapŏng maqnoeq hòm, mahaq wì hadai jêh, hanip, èh hnan haq aih hlài tì dech. ");
INSERT INTO hrebt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wì craq thê hapŏng yàng piq, wì hadai jêh haq aih loh habau rai hnan đac. ");
INSERT INTO hrebt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Craq wuàn nho aih doe: Au broq qmang leq kô? Au thê deh kon calô au ma loq waq, lam, broq braiq wì camaih iu ka haq.” ");
INSERT INTO hrebt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mahaq jò ƀài mangai pìt nho hnoq kon calô aih trùh, wì hatuàng ka dabau: Hatau mangai kon majah waq dŏng kùng hang, beq bèn jêh cađac haq, aih èh kùng hang haq jah dŏng bèn. ");
INSERT INTO hrebt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wì hi khwênh qnoh haq enh gùng ka wuàn nho rai jêh cađac hloe. Aih èh craq wuàn nho broq cleq ka ƀài aih? ");
INSERT INTO hrebt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Haq trùh jêh dŏng ƀài mangai pìt nho aih khoe èh yŏc wuàn aih am ka mangai qnoeq abèq. Ƀài mangai ma tàng bàu aih wì doe: Boc Plình ùh i manaq taleq! ");
INSERT INTO hrebt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Chuaq Jesus ngan wì haq rai bòch: “Tàng qmang aih bàu ma achìh: Hmo mangai thòq broq hnim cađac, Khoe wìa hmo mùm hnim, bàu aih anoe cleq? ");
INSERT INTO hrebt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mangai leq ta clìh ta hmo kô èh, hech loh dàc, hmo kô tùc troq cabô, mangai aih èh hech hoch dŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wop jò aih, ƀài pajàu kàn xam ƀài mangai hnài ranenh chaq trong jêh cađac haq, majah qmang aih wì loq bàu Chuaq Jesus alìah aih anoe trùh wì haq raq. Mahaq wì ùh hùa ka ƀài mangai bàc ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Wì ti hanhoe ngan haq, wì thê ƀài mangai ti rinh broq patìah mangai khôn khauq, đòeq chaq trong hu goh haq ajang bàu tapoch, hu rùp haq am ka ƀài mangai i cwìang, mangai gàu ƀài cwan. ");
INSERT INTO hrebt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wì aih bòch Chuaq Jesus bàu kô: Mangai hnài! Nhèn loq trong bàu tapoch, trong hnài da ìh tiaq trong jang, ùh loq waq tang ngai, yŏc bàu joq qnàng đòeq hnài trong Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nhèn akhòh am thèq ka Sêsa ùh? ");
INSERT INTO hrebt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mahaq Chuaq Jesus loq ka manoh wì, haq doe: ");
INSERT INTO hrebt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Am ka au ngan mòeq đo-ni-ê beq, Kô ìq qmù cabô, yiniq cabô?” Wì padreo bàu: Sêsa. ");
INSERT INTO hrebt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Haq doe ka wì: “Padreo da Sêsa yiniq cleq da Sêsa, am da Boc Plình yiniq cleq da Boc Plình.” ");
INSERT INTO hrebt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Enh ngèa mangai bàc wì bahlac bàu haq ùh jah. Toq hamàih ka bàu haq ta hatèu, wì hi loh ka hatinh. ");
INSERT INTO hrebt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","I qnah ngai Sađusê, aih ƀài mangai loq doe ùh i kan rìh hlài, wì trùh haten ka Chuaq Jesus rai bòch: ");
INSERT INTO hrebt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mangai hnài, Môise khoe đòeq ka nhèn ranenh qmang kô: Tàng mangai i daq yŏc mai, khoe haq cachìt, ùh i đeh kon, mangai oh aih ep yŏc mai deh daq aih đòeq haqmot hlài xinoe ka daq haq. ");
INSERT INTO hrebt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Qmang aih, i tapèh ngai oh daq. Mangai daq ramua yŏc mai, èh cachìt qnhòq i kon. ");
INSERT INTO hrebt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mangai hatìa yŏc mai aih, ");
INSERT INTO hrebt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","èh trùh mangai atìq, dìq dŏng wì tapèh ngai dìq yŏc mangai aih, wì dìq cachìt mahaq ùh lòm i kon. ");
INSERT INTO hrebt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pulùch, mangai cadrì aih hanoh cachìt. ");
INSERT INTO hrebt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Qmang aih èh trùh hì rìh hlài gucadrì aih broq mai cabô? Majah qmang aih dìq dŏng tapèh ngai aih hanoh khoe yŏc gucadrì aih broq mai. ");
INSERT INTO hrebt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Chuaq Jesus doe: “Mangai qnhòng kô yŏc ŏng yŏc mai, ");
INSERT INTO hrebt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","mahaq ƀài mangai ma khoe troq ka jah kan rìh hlài qnhòng atìq, jò rìh hlài enh kan cachìt, aih pi i yŏc ŏng yŏc mai hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Majah qmang aih wì haq pi cachìt hòm, wì haq tìah ka ƀình plình, wì haq aih kon Boc Plình, aih kon da kan rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mahaq da mangai cachìt rìh hlài aih Môise khoe am loq jò anoe hlài ùnh cheo ramù yila, jò haq doe Chuaq aih Boc Plình da Apraham, Boc Plình da Ysac, Boc Plình da Jacôp. ");
INSERT INTO hrebt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Haq ùh xài Boc Plình da mangai cachìt, mahaq da mangai rìh, majah qmang aih rìm ngai dìq rìh ka haq.” ");
INSERT INTO hrebt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","I ƀài mangai hnài ranenh anoe ka haq: Mangai hnài, bàu Ìh anoe dìq jaq troq. ");
INSERT INTO hrebt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wì pi hùa bòch tam haq mòeq bàu leq hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Khoe aih Chuaq Jesus bòch wì haq: “Hagleq wì ma doe Christ aih kon bùa Đawit? ");
INSERT INTO hrebt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","majah qmang aih cla Đawit raq khoe anoe ta hset calêu plình rameh: Boc Plình doe ka Chuaq au: Hangui enh apah qma ka au, ");
INSERT INTO hrebt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Trùh jò au rùp mangai tagit ka ìh broq radua roh jènh ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Đawit khoe crêu ka haq aih Chuaq, atìq ka aih haq wìa kon Đawit qmang leq?” ");
INSERT INTO hrebt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jò dìq dŏng ka wì ta aih qnang tamàng, Chuaq Jesus doe ka mangai tiaq hŏc: ");
INSERT INTO hrebt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ngan oq! ƀài mangai hnài ranenh, aih ƀài mangai enh toq caxùnh eo yôh, ti lam dauq hawàt, enh wì kùh gàu ka rađeh taqne chòq, ta hnim tagop enh toq hangui nòe yi haqnhèq, jò acaq yiniang enh toq hangui enh qnhèq; ");
INSERT INTO hrebt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","waiq khàn broq deh waq ka yôh, mahaq lŏnh apom hnim gucadrì hadrô. Ƀài aih èh Boc plình taqmòq kan baxa ka wì haq yeo bàc.” ");
INSERT INTO hrebt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jò Chuaq Jesus haqmiang ngan, hnoq ƀài mangai padrŏng tah ƀac ta hnim kùh waiq, ");
INSERT INTO hrebt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","èh hadai hnoq mòeq ngai gucadrì hadrô tah baiq hliac bac. ");
INSERT INTO hrebt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Haq doe: “Joq qnàng au doe ka pì, mangai hadrô pa qmat tah yeo bàc dŏng ka wì qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Majah qmang aih ƀài mangai padrŏng tau tah toq ƀac rah, yàng mangai hadrô qmat joq nan pa, mahaq khoe tah dŏng deh ƀac đòeq haq ban rađeh.” ");
INSERT INTO hrebt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","I qnah ngai anoe trùh hnim kùh waiq, xam ƀài hmo lem xam ƀài dahwèq dèch ka Boc Plình. Chuaq Jesus doe: ");
INSERT INTO hrebt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tangèa kô èh, rìm yiniq pì ngan hnoq qmat èh taclìh dŏng dìq pi oe i mòeq pliang hmo leq oe jah raxon crŏng hmo leq. ");
INSERT INTO hrebt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wì hi bòch haq: Mangai hnài, ƀài yiniq aih jò leq men trùh? I cleq pateo ka am ka mangai loq ƀài yiniq aih khoe ten trùh? ");
INSERT INTO hrebt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Haq padreo bàu: “Pì ngan oq! apaq dôq wì padô qnùt pì, majah qmang aih i bàc ngai patìah yiniq au, trùh doe ka pì: Au kô raq Christ! Jò atìq lùch khoe ten trùh. Ùh dùh tiaq wì haq. ");
INSERT INTO hrebt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jò pì tàng ràu trùh trong tajêh tablah, apaq yùq hrìn, majah qmang aih ƀài yiniq aih ep trùh adroe, mahaq kan atìq lùch qnhòq trùh hloe draq drình.” ");
INSERT INTO hrebt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Khoe aih haq anoe ka wì: “Gùng kô yòng tagit gùng tau. Diac kô tagit ka diac tau. ");
INSERT INTO hrebt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Èh i kan ralàng kàn, pangot hrah, xam bàc kan jìq dài, i ƀài kan ramòt halac kàn oe ta trŏc. ");
INSERT INTO hrebt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mahaq adroe ka ƀài yiniq aih trùh, taiq yiniq au kô èh wì phù cròng majah ti canàt rùp baxa pì, aràng pì ta hnim tagop rai clêh pì, qnoh pì yòng enh ngèa ka bùa xam mangai broq craq cwan. ");
INSERT INTO hrebt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aih đòeq pì yòng anoe dôq wì loq ka au. ");
INSERT INTO hrebt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Qmang aih pì ep hmàng ta gàu, apaq lèt kô èh đeh anoe cleq hu aclai ka rađeh. ");
INSERT INTO hrebt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Majah qmang aih, i au am ka pì bàu capoch xam kan rabiaq đòeq mangai git ka pì ùh hlàt tablêq, ùh i trong hu goh pì. ");
INSERT INTO hrebt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kô èh, ra-ùng haq, miq baq, daq oh, hadròng, trùh hloe bua cla pì hadai blòq pì, broq ka bàc ngai taqne pì ep cachìt. ");
INSERT INTO hrebt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Taiq au kô èh rìm ngai majah git ka pì. ");
INSERT INTO hrebt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mahaq mòeq hadrang xàc tagàu pì dua ùh hnhung. ");
INSERT INTO hrebt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yòng ma cajap haq oq, aih èh pì jah kan rìh. ");
INSERT INTO hrebt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jò pì hnoq ƀài lình canàt tap danh ka Jêrusalem, aih pì loq kan raliang da haq khoe ten trùh. ");
INSERT INTO hrebt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jò aih cabô oe ta gùng Juđê drah cadàu tŏc tawang. Cabô oe ta plài drah ca dàu loh enh gùng. Cabô oe tagùng ùh dùh wìh mùt taplài. ");
INSERT INTO hrebt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Majah qmang aih ƀòe aih jò đòeq hu patem chau, dôq xìt qmang ka rìm bàu khoe achìh. ");
INSERT INTO hrebt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ƀài hì aih èh, haƀo ka mangai cadrì oe jiang xam gucadrì ta-ùq kon! I kan ranàc kàn, kan panòeh ka mangai gùng kô. ");
INSERT INTO hrebt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wì haq cro enh qneq ka pla chang, èh wì rùp qnong wì haq lam broq dìc ta diac qnoeq. Èh mangai diac qnoeq jôiq padit Jêrusalem, trùh jò da mangai diac qnoeq jah gêh. ");
INSERT INTO hrebt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Èh i kan halac ta mat mahì, mat khê xam ƀài halŏng, ƀài mangai ta taneh loh ka mangò yùq crè majah qmang aih diac raxìq loh atêh tagruàng tagràt. ");
INSERT INTO hrebt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jò aih kon mangai hnoq trong dù trùh ta crŏng taneh, loh ka pi i qmòe mahua yiang, majah qmang aih bài cwìang ta trŏc tì hadai ka dalàc. ");
INSERT INTO hrebt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jò aih èh phù cròng ma hi hnoq Kon Mangai yŏc cwìang yŏc kan ranhòm kàn hangui taqne yùc plình hu trùh. ");
INSERT INTO hrebt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jò ƀài yiniq kô bu trùh, drah yòng majang, gàu rai qngŏc, hì baxon yŏc ahlài pì trùh khoe ten ");
INSERT INTO hrebt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Haq alìah ka wì qmang kô: Pì ngan long pŏc xam bài long qnoeq; ");
INSERT INTO hrebt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","jò haq plôh hamŏng, pì hnoq qmang aih, pì loq đeh khoe ten trùh jò padrang. ");
INSERT INTO hrebt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hadai qmang aih, jò hnoq khoe loh ƀài yiniq kô, aih pì loq diac Boc Plình khoe ten trùh. ");
INSERT INTO hrebt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Au anoe qnàng ka pì, nang noe kô ùh lùch adroe ka ƀài yiniq aih trùh. ");
INSERT INTO hrebt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Plình crŏng taneh kô èh hnhung, mahaq bàu au anoe kô èh ùh jò leq hnhung. ");
INSERT INTO hrebt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Qmang aih ep wèq rađeh, yùq èh trong acaq ôq, trong bù bia xam kan loq lèt taqnhòng kô broq ka manoh pì loh ka pi hmàng, èh hì aih trùh tapì tìah taiq ka jeo gùp; ");
INSERT INTO hrebt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","majah qmang aih, hì aih hadai trùh ka rìm ngai oe ta crŏng taneh. ");
INSERT INTO hrebt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Qmang aih pì ep hamang rai waiq khàn yôt, dôq pì jah puplech ka ƀài kan ranàc aih, hu jah yòng enh ngèa Kon mangai.” ");
INSERT INTO hrebt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Rìm hì haq hnài ta hnim kùh waiq, rìm mang haq tŏc ta wang Oliu kùi padài ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Èh bu qngah ƀài mangai bàc khoe trùh ta hnim kùh waiq hu tamàng bàu haq. ");
INSERT INTO hrebt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hì Ramènh Ƀênh ùh tah blo, aih la hì ramènh Pancwa. ");
INSERT INTO hrebt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ƀài pajàu kàn xam ƀài mangai hnài ranenh chaq trong hu jêh cađac Chuaq Jesus, majah qmang aih wì ùh hùa ka mangai bàc ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kiac Satan khoe mùt enh dalam ka Juđa, ma creo Icari-ôt, haq hadai mangai oe ta Mòeq jàt baiq ngai, ");
INSERT INTO hrebt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","haq lam chaq ƀài mangai pajàu kàn xam ƀài craq lình ma wèq hnim kùh waiq, haq ta hatình ti wì hu chaq trong leq đòeq rùp Chuaq Jesus am ka wì. ");
INSERT INTO hrebt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wì aih manè pi cajaq, dìq ka wì wiang òq bàu am ka haq ƀac. ");
INSERT INTO hrebt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Haq khoe mòeq manoh ka wì, chaq jò hatroq hu rùp Chuaq Jesus am ka wì, mahaq ùh dôq mangai bàc loq. ");
INSERT INTO hrebt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Trùh hì Ramènh acaq ƀênh ùh tah blo, hì aih ep jêh kon trìu broq tadreo hì ramènh Pancwa, ");
INSERT INTO hrebt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chuaq Jesus thê xam Phiero xam Jon lam rai tanap: “Lam padon ka bèn acaq ramènh Pancwa.” ");
INSERT INTO hrebt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wa aih doe: Ìh enh nhèn padon ramènh aih taleq? ");
INSERT INTO hrebt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Haq padreo bàu: “Jò chôp mùt taplài, hnoq mòeq ngai wê abôq diac, chôp drah tiaq haq aih mùt ta hnim, ");
INSERT INTO hrebt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","chôp doe ka craq hnim aih, Mangai hnài nhèn doe ka ìh: Aniang kàn nòe au acaq ramènh pajùm deh ti mangai tiaq hŏc oe taleq? ");
INSERT INTO hrebt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Craq hnim aih hi patô am ka chôp mòeq adùq kàn oe enh qnhèq, ta aih rìm yiniq khoe palauq qmòe, pì padon ta aih”. ");
INSERT INTO hrebt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wa aih hi lam, joq qnàng wa glàm tìah ka bàu Chuaq Jesus khoe doe, wa hi padon ramènh Pancwa ta aih. ");
INSERT INTO hrebt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Trùh jò, Chuaq Jesus xam ƀài mangai tiaq cla hangui acaq ti haq. ");
INSERT INTO hrebt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Haq doe: “Au dìq jaq enh acaq ramènh Pancwa kô ti pì adroe ka au chìuq xalep. ");
INSERT INTO hrebt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Majah qmang aih, au pi acaq ramènh kô hòm trùh hì ramènh aih jah gêh ta diac Boc Plình”. ");
INSERT INTO hrebt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Khoe aih haq dèch doe chrŏng, manè apôi, hi khoe haq doe: “Yŏc chrŏng kô pì qnèp ka dabau. ");
INSERT INTO hrebt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Majah qmang aih au doe ka pì, pang kô ta èh au pi ôq diac plì nho kô hòm trùh jò leq diac Boc Plình jah trùh”. ");
INSERT INTO hrebt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Khoe aih, haq yŏc bênh, manè apôi, khoe èh goh bênh axong am ka mangai tiaq hŏc, rai doe: “Kô chac au, khoe am ka pì, pì broq qmang kô hu hmàng trùh au.” ");
INSERT INTO hrebt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Acaq hi khoe, hanoh qmang aih, haq yŏc chrŏng qnèp ka mangai tiaq hŏc rai doe: “Doe chrŏng kô aih tajao maneo oe ta mahim au, mahim khoe ta ùc qnoh am ka pì… ");
INSERT INTO hrebt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mahaq tì kŏng da mangai ma padon blòq au hadai oe ta caƀŏng kô ti tì au. ");
INSERT INTO hrebt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kon Mangai kô èh lam, tìah ka bàu khoe thê. Mahaq haƀo ka mangai ma blòq haq.” ");
INSERT INTO hrebt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mangai tiaq hŏc bòch dabau, taqne wì haq mangai leq ma broq trong aih. Mangai tiaq hŏc tarahen ");
INSERT INTO hrebt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mangai tiaq hŏc tarahen ti dabau, đòeq hu ngan mangai leq ta wì haq èh majah broq yeo kàn dŏng. ");
INSERT INTO hrebt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chuaq Jesus doe ka wì: “Ƀài bùa diac wì yŏc deh cwìang enh cla đòeq hu hmet mangai qnoeq, ƀài mangai broq gàu yŏc cwìang padit mangai qnoeq, mahaq creo ka rađeh aih mangai broq lem. ");
INSERT INTO hrebt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mahaq pì ùh dùh qmang aih, taqne pì mangai leq ma yeo kàn ep tìah qmang ka mangai yeo qyoh, mangai leq broq gàu ep broq tìah ka mangai patìh. ");
INSERT INTO hrebt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Majah qmang aih moeq ngai haqngui acaq xam moeq ngai yòng patìh mangai maleq ma yeo kàn? Axài mangai haqngui acaq loq ùh? Mahaq oe taqne pì au tìah ka mangai patìh. ");
INSERT INTO hrebt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pì ƀài mangai ma khoe cajap manoh yòng ti au jò wì tah hadrah ka au, ");
INSERT INTO hrebt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","aih èh au am ka pì diac au, tìah ka Baq au ma khoe am ka au, ");
INSERT INTO hrebt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","dôq pì jah acaq ôq pajùm ti au ta diac au, jah hangui ta gèq hu hadrah mòeq jàt baiq xinoe Isorali. ");
INSERT INTO hrebt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simôn, Simôn! Kiac Satan khoe bàc yàng bòch ùm ìh tìah ka ùm qmau. ");
INSERT INTO hrebt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mahaq au khoe waiq khàn ka ìh, dôq manoh lùi ìh ùh hìaq capòch. Qmang aih, jò ìh khoe hwi hlài, drah broq ka cajap manoh oh daq”. ");
INSERT INTO hrebt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Phiero doe: Chuaq au! yac ka wì rùp clêh au, yac ka au cachìt, dua au tiaq ìh. ");
INSERT INTO hrebt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Chuaq Jesus padreo bàu: “Phiero, au doe ka ìh, hì kô èh, adroe ka ia rŏng ìh khoe piq yàng hangah đeh ùh qnì ka au.” ");
INSERT INTO hrebt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Khoe aih Chuaq Jesus bòch wì haq: “Jò au thê pì lam ùh wê ƀac, ƀau, ùh i qmòe ka jep, pì ahìaq thìuq cleq ùh?” Wì padreo bàu: ùh hìaq! ");
INSERT INTO hrebt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Haq doe ka wì: “Mahaq manòeq kô, tàng pì i ƀac, wê beq, maleq i ƀau, hadai qmang aih. Maleq ùh i ka chang, lam tech eo yôh qmat đòeq hu rot. ");
INSERT INTO hrebt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Majah qmang aih, kô au anoe ka pì loq, i bàu khoe achìh rameh: wì alùh haq pajùm ti ƀài mangai dù. Bàu aih ep xìt trùh ka au. Joq qmang aih, rìm yiniq khoe patô trùh au qnang jah xìt.” ");
INSERT INTO hrebt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mangai tiaq hŏc doe: Ìh ngan kô, nhèn i baiq pla chang. Haq doe: “Toq aih khoe qnang lem.” ");
INSERT INTO hrebt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Khoe aih, Chuaq Jesus tŏc ta wang Ôliu, qmang ka haq ma loq lam dèh yôt, ƀài mangai tiaq hŏc lam tiaq deh haq. ");
INSERT INTO hrebt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jò khoe trùh nòe, haq doe ka mangai tiaq hŏc: “Waiq khàn beq, dôq pì ùh hìaq taclìh ta kan padô qnùt. ");
INSERT INTO hrebt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Khoe aih haq lam yeo hangai bu mòeq atèm hmo, rai hacùn cràng rai waiq khàn ");
INSERT INTO hrebt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","rameh: “Waiq Baq! Tàng joq lem manoh Ìh, dèch chrŏng kô khoe ka tì au. Hnoq doe qmang aih apaq dì manoh au mahaq tiaq manoh Ìh.” ");
INSERT INTO hrebt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","I mòeq ƀình plình loh enh plình trùh jang haq, tam padren ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jò dìq jaq mangò aih, haq waiq khàn yeo criaq hòm, pa-ùh haq loh tìah qmòe ka mahim, catôh ta taneh. ");
INSERT INTO hrebt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hêq ka waiq khàn haq wìh hlài ajang nòe ƀài mangai tiaq hŏc hnoq wì kùi pi hmàng ta kan mangò. ");
INSERT INTO hrebt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Haq bòch wì: “Hagleq pì majah kùi? Drah yòng beq hu waiq khàn dôq pì ùh hìaq clìh ta kan padô qnùt.” ");
INSERT INTO hrebt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jò haq oe raq anoe, mòeq calùh mangai trùh, Juđa haq hadai oe ta mòeq jàt baiq ngai, lam qmòe adroe hu qnong wì. Juđa trùh ka haten hìp Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mahaq Chuaq Jesus bòch haq: “Juđa, ìh blòq cađac Kon mangai xi mòeq qmang hìp kô raq qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jò mangai tiaq Chuaq Jesus hnoq khoe padon loh yiniq, wì bòch: Nhèn yŏc chang nhèn jêh khòh ùh? ");
INSERT INTO hrebt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","I mòeq ngai ta ƀòe mangai tiaq hŏc jêh mangai hapŏng pajàu haqnhèq, pot catech da haq aih don pah qma. ");
INSERT INTO hrebt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mahaq Chuaq Jesus doe: “Hêq pi dùh broq qmang kô.” Èh Haq yŏc tì bèq don mangai aih rai broq brêh. ");
INSERT INTO hrebt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Khoe aih Chuaq Jesus tapoch ka ƀài pajàu kàn, ƀài cwan wèq hnim tagop xam ƀài gucraq ma lam rùp haq “Pì wê chang, wê long lam rùp au tìah ka lam rùp mangai atùng. ");
INSERT INTO hrebt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rìm hì au oe ti pì tanòe hnim kùh waiq, pì ùh rùp au. Mahaq manòeq kô jò da pì, jò da diac clam cluiq”. ");
INSERT INTO hrebt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Khoe aih wì hi rùp Chuaq Jesus, qnong haq trùh hnim mangai pajàu haq nhèq, Phiero ti taqyoe enh hangai. ");
INSERT INTO hrebt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jò aih i qnah ngai patep ùnh qne hamlamg, wì hangui qnhìa ùnh ti dabau, Phiero hadai hangui ti wì aih. ");
INSERT INTO hrebt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","I mòeq ngai hapŏng cadrì hnoq Phiero hangui qnhìa ùnh, haq chrìh ngan ka haten rai doe: Mangai kô hadai mòeq bua ti haq tau. ");
INSERT INTO hrebt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mahaq Phiero hangah: Mangai cadrì meh, au ma i loq ka haq aih. ");
INSERT INTO hrebt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Atìq ka aih mòeq ahyàc, i mangai qnoeq hnoq Phiero, haq doe: Ìh hadai taqmùt ti haq tau. Phiero doe: Cleq kô! Au ùh i taqmùt ti wì aih. ");
INSERT INTO hrebt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jah mòeq jò atìq ka aih, i mangai qnoeq hòm doe: Cleq kô, hi loq ka mangai taqmùt ti haq tau, majah qmang aih ìh kô mangai Galili. ");
INSERT INTO hrebt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Phiero padreo bàu: Mangai kô! Au ùh qnì tàng ìh doe cleq. Jò Phiero qnang anoe, ia rŏng hloe jò aih raq. ");
INSERT INTO hrebt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chuaq Jesus hwi enh rù rai ngan tajang ka Phiero. Aih Phiero ma hi hmàng hlài bàu haq ma khoe doe ka rađeh: “Hì kô èh, adroe ka ia rŏng, ìh khoe piq yàng hangah đeh ùh loq ka au.” ");
INSERT INTO hrebt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Haq hi loh enh gùng rai hmoe ua ac. ");
INSERT INTO hrebt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ƀài mangai ti rap ngan Chuaq Jesus halê rai jêh haq; ");
INSERT INTO hrebt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","wì bàng mat haq raih bòch: Tapoch pajàu beq! cabô jêh ìh! ");
INSERT INTO hrebt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wì hnap ka haq bàc trong qnoeq hòm. ");
INSERT INTO hrebt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Qngah sroq eh, ƀài gucraq gùng aih xam ƀòe mangai pajàu kàn hloe xam ƀài mangai hnài ranenh, wì tagop ti dabau, thê qnoh Chuaq Jesus loh enh ngèa wì haq. ");
INSERT INTO hrebt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Wì doe: Tàng joq ìh qmat Christ, ìh drah anoe ka nhèn beq! Haq padreo bàu: “Yac ka au doe cleq, dua pì ùh lùi, ");
INSERT INTO hrebt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","tàng joq au bòch pì, aih dua pì ùh tèu bàu. ");
INSERT INTO hrebt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mahaq pang kô ta èh, Kon mangai hi hangui pah qma cwìang itai Boc Plình”. ");
INSERT INTO hrebt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Rìm ngai wiang bòch: Tàng qmang aih ìh qmat ma kon Boc Plình qmòh? Haq padreo bàu: “Pì raq khoe doe au kon haq” ");
INSERT INTO hrebt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Khoe aih wì doe: Bèn ep gòm cabô anoe cleq ka bèn hòm? Bèn khoe tàng qmòe bàu enh cla haq qmat raq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Khoe aih dìq dŏng mangai wiang tah hadrah padinh yòng aràng haq trùh enh ngèa Philat. ");
INSERT INTO hrebt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wì tapoch bàu hu taqmòq yiniq lui ka haq: Nhèn khoe hnoq mangai kô patùt mangai bèn broq ùh troq, ùh lòh am thèq ka Sêsa, haq doe rađeh kô Mêsia, aih la bùa. ");
INSERT INTO hrebt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Philat àu bòch haq: Ìh kô ajoq bùa mangai Juđa? Chuaq Jesus padreo bàu: “Joq qmang ka bàu ìh khoe doe”. ");
INSERT INTO hrebt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Philat doe ka ƀài pajàu kàn xam dìq ka mangai ta aih: Au ùh i hnoq qmòe mangai kô i yiniq lui cleq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mahaq dua wì àu waq ka jah: Haq kô baxrùq dìq ka mangai ta gùng Juđa xi bàu haq hnài. Haq baxèm qmòe enh gùng Galili trùh hloe ta kô. ");
INSERT INTO hrebt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tàng bàu aih, Philat bòch: mangai kô ajoq mangai Galili? ");
INSERT INTO hrebt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jò Philat khoe loq Chuaq Jesus oe tanòe cwìang bùa Hêrot, hi aràng haq trùh ta bùa Hêrot, jò aih bùa Hêrot hadai oe ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jò Hêrot hnoq Chuaq Jesus, haq manè pi cajaq, majah qmang aih haq ngèh ka jah hnoq Chuq Jesus khoe dùnh. Haq khoe tàng wì anoe trùh Chuaq Jesus, haq enh hnoq kan halac. ");
INSERT INTO hrebt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hêrot bòch bàc trong, mahaq Chuaq Jesus ùh tèu. ");
INSERT INTO hrebt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ƀài pajàu kàn xam mangai hnài ranenh yòng ta aih, chaq trong taqmòq yiniq lui ka haq nhang haraya. ");
INSERT INTO hrebt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jò aih Hêrot xam ƀài lình haq, ngan Chuaq Jesus ùh loh cleq, toq ti halê haq, caxùnh ka haq eo yôh lem khoe hi padreo ahlài da Philat. ");
INSERT INTO hrebt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nèh haq, wa Philat wa Hêrot tagit ka dabau, mahaq pang hì aih wa hi loh ka hatroq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Philat creo ka ƀài pajàu kàn xam ƀài cwan hadrah xam dìq ka mangai ta aih oe mòeq nòe, ");
INSERT INTO hrebt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","haq doe ka wì: Pì aràng ka au mangai kô pì doe haq baxrùq wì hu yòng tablêq ka Sêsa; enh ngèa ka pì au khoe ti bòch haq, au ùh hnoq haq i yiniq lui cleq tìah bàu pì ma anoe; ");
INSERT INTO hrebt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","yac ka bùa Hêrot hadai, majah qmang aih, hacô haq khoe padreo ahlài mangai kô ka bèn, pì hanoh hnoq. Mangai kô ùh i yiniq lui cleq ma troq ka cachìt, ");
INSERT INTO hrebt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","qmang aih au thê wì blai haq khoe èh hi caqnaih haq ");
INSERT INTO hrebt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dìq ka wì wiang cachech: Jêh cađac mangai kô, caqnaih da nhèn Baraba! ");
INSERT INTO hrebt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraba aih mangai pagàu yòng tablêq ka Sêsa, haq i jêh đac mangai.) ");
INSERT INTO hrebt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Philat enh caqnaih Chuaq Jesus, haq majah bòch hòm wì. ");
INSERT INTO hrebt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mahaq kiang wì cachech cadêh: Tiang đình haq talong pagat beq! Tiang đinh haq talong pagat beq! ");
INSERT INTO hrebt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Philat doe hòm yàng piq: Mahaq mangai kô khoe broq cleq ma dù? Au ùh i hnoq haq i qmòe yiniq lui cleq ma troq ka cachìt. Qmang aih au blai haq khoe èh caqnaih haq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mahaq dua wì àu cachech cadêh: Ep tiang đình haq talong pagat; bàu cachech wì haq jah blêq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Philat hi thê broq tiaq qmang ka bàu wì bòch. ");
INSERT INTO hrebt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Philat caqnaih mangai haq ma khoe clêh, aih mangai jêh đac mangai rai baxrùq wì yòng tablêq ka Sêsa, tiaq bàu wì bòch, khoe aih am Chuaq Jesus ka wì haq tiaq manoh wì ma enh. ");
INSERT INTO hrebt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jò ƀài lình qnong Chuaq Jesus lam, hnoq mòeq ngai gùng Siren, yiniq haq Simôn hlài enh ruàng. Wì rùp haq aih thê xùi long pagat lam atìq ka Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Raya mangai lam tiaq Chuaq Jesus, i qnah ngai gucadrì rai tùc dèh nòeh rai crò hmoe ka haq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Chuaq Jesus hwi ngan rai doe ka wì haq: “Yôiq ƀài kon gucadrì Jêrusalem, ùh dùh hmoe dèh ka au, hmoe ka cla pì xam ƀài kon pì. ");
INSERT INTO hrebt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Majah qmang aih ta ngèa kô èh jò pì ma hi doe: Xôq ramot ka gucadrì xon, xôq ramot ka cliac ma ùh lah hauang xam tôh ma ùh lah ta-ùq! ");
INSERT INTO hrebt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jò aih èh wì doe ka bui wang: Ta-ùc enh qnhèq ka nhèn kô beq! doe ka go: Gùp enh qnhèq ka nhèn beq! ");
INSERT INTO hrebt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tàng joq wì broq ƀài yiniq aih ka long rìh, long croh èh qmang leq?” ");
INSERT INTO hrebt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wì hadai qnong baiq ngai qnoeq hòm, wa aih mangai atùng, đòeq hujêh pajùm ti haq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jò wì khoe trùh tanòe wì ma creo go Cadôh, ta aih wì tiang đình haq talong pagat ti wa mangai atùng – mòeq ngai apah qma, mòeq ngai apah qngeo. ");
INSERT INTO hrebt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mahaq Chuaq Jesus waiq khàn: “Waiq Baq! Ìh caqnaih da wì yiniq lui, majah qmang aih wì ùh qnì rađeh broq cleq.” Khoe èh, wì pàih panàih hu ngan maleq majah eo haq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wì mangai bàc yòng haqmiang ngan ta aih. Wì mangai ma i cwìang do halê haq. Wì doe: Haq khoe dèch mangai qnoeq, tàng joq haq qmat Mêsia Boc Plình ma khoe ràih, dôq cla haq doeh rađeh beq! ");
INSERT INTO hrebt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ƀài lình hadai racaih blìa ka haq, lam haten ka haq yŏc diac panhòq am haq ôq, ");
INSERT INTO hrebt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","rai doe rameh: Tàng ìh joq bùa Juđa, doeh rađeh beq! ");
INSERT INTO hrebt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Enh qnhèq ka gàu haq wì achìh: Mangai kô bùa Juđa. ");
INSERT INTO hrebt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mòeq ngai atùng wì ma tiang đình hadai hnap ka haq: Ìh qmat ùh xài Christ qmòh? Dèch rađeh beq khoe aih dèch nhèn diq! ");
INSERT INTO hrebt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mahaq mangai matau lech ka mangai aih, haq doe: Ìh hadai khoe qmang qmat, gleq ma ùh crè ka Boc Plình ");
INSERT INTO hrebt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Da ba kô, khoe troq tiaq kan taq atoq, kan baxa ba ùh i qngwan ka trong dù ba broq, mahaq mangai kô haq ùh lah broq qmòe yiniq cleq ma qmèq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Khoe èh, haq doe: Chuaq Jesus! jò Ìh hlài dèh diac Plình, hmàng trùh au diq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chuaq Jesus doe ka haq: “Joq qnàng au doe ka ìh, hì kô raq ìh jah oe ta au ta Parađi.” ");
INSERT INTO hrebt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jò aih wop qne hì, dìq ta gùng aih loh dŏng ka clam trùh hloe piq jò dixèq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mat mahì loh ka clam cluiq, èh bai prình ta hnim kùh waiq loh ka dahit broq baiq apah. ");
INSERT INTO hrebt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chuaq Jesus creo cadêh: “Baq! au qnèp deh mahua yiang ta tì kŏng ìh.” Atìq ka bàu aih, haq hi pat hi hèm. ");
INSERT INTO hrebt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Cla craq ƀài lình hnoq qmang aih, haq dèch bàu manè apôi Boc Plình, haq doe: Kô joq mangai taq atoq joq qnàng! ");
INSERT INTO hrebt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Dìq dŏng ƀài mangai lam ngan, wì hnoq qmang aih wì rai hlài rai tùc deh rada. ");
INSERT INTO hrebt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mahaq ƀài mangai canau ka Chuaq Jesus xam ƀài mangai gucadrì ma khoe tiaq haq enh gùng Galili, dìq yòng enh hangai hu haqmiang ngan. ");
INSERT INTO hrebt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","I mòeq ngai yiniq haq Jôsep, hadai broq cwan hadrah, haq aih mangai taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","haq ùh mòeq manoh èh haq ùh wiang jò wì ma hadrah Chuaq Jesus. Haq oe ta Ari-mathê, gùng Juđê, toq tangèh ka diac Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Haq lam ta Philat bòch yŏc hanang Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jò khoe qnoh hanang Chuaq Jesus enh long pagat, haq yŏc bai lòm hanang, taqngùi hanang ta trom ralùng wì khoe pùng đòeq tanòe hmo kàn. Ralùng aih qnhòq lah tah cabô. ");
INSERT INTO hrebt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hì aih hì padon, èh hì sabat khoe ten trùh. ");
INSERT INTO hrebt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ƀài mangai gucadrì khoe lam ti Chuaq Jesus enh gùng Galili, tiaq Jôsep hu ngan ralùng rai ngan wì ta qngùi hanang Chuaq Jesus qmang leq. ");
INSERT INTO hrebt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wì haq wìh hlài ta hnim, padon diac jreo xam dàu xua thùm. Mahaq hì sabat, tiaq deh ranenh wì haq padài. ");
INSERT INTO hrebt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hì baxèm tuàng lè, buqngah ƀài mangai gucadrì wê diac jreo xam dàu xua thùm wì haq ma khoe palauq aràng trùh ta ralùng. ");
INSERT INTO hrebt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wì haq hnoq hmo padit qngah ralùng khoe cadro taqnoeq; ");
INSERT INTO hrebt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","mahaq, mùt enh dalam ùh hnoq hanang Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wop jò wì haq qnang hamàih trong kô, i baiq ngai calô caxùnh eo tìah ka camlet, loh yòng enh ngèa wa haq. ");
INSERT INTO hrebt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wa haq qnang crè dìq jaq, toq kùp hadrò ta haqneq, wa aih doe: Hagleq pì majah chaq mangai rìh tanòe mangai cachìt? ");
INSERT INTO hrebt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Haq pi oe tacô, haq khoe rìh hlài. Hmàng hlài beq, jò oe ta Galili haq doe ka pì qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Haq khoe doe: “Kon mangai mùt ta tì kŏng mangai yiniq lui, wì tiang đình haq talong pagat, hì piq haq hi rìh hlài.” ");
INSERT INTO hrebt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aih wì men hmàng hlài bàu Chuaq Jesus ma khoe anoe. ");
INSERT INTO hrebt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jò wì haq wìh hlài enh ralùng hanang, wì haq anoe hlài yiniq kô ka mòeq jàt mòeq ngai tiaq cla, xam dìq ka wì qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ƀài gucadrì aih: Mari-mađolen, Jano, Mari miq da Jaco xam ƀài gucadrì qnoeq, ma hadai i lam, wì aih anoe hlài yiniq kô am ka ƀài mangai tiaq cla Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mahaq wì ùh lùi bàu ƀài mangai gucadrì aih anoe, majah qmang aih bàu wì haq tìah taiq ka bàu tapoch hwang. ");
INSERT INTO hrebt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hnoq doe qmang aih, Phiero yòng cadàu tùh loh ta ralùng, haq kùp chri ngan, hnoq toq bai lom hanang oe jang aih, khoe aih haq hi hlài rai hamàih ta manoh ka bìac aih. ");
INSERT INTO hrebt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hì aih raq, i baiq ngai hadai tiaq hŏc, qnang ti trong trùh ta plài Em-mau, enh aih trùh ta Jêrusalem tadràu jàt Êtađo; ");
INSERT INTO hrebt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","wa hatuàng ka dabau ƀài yiniq neo loh khoe toq leq hì kô. ");
INSERT INTO hrebt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jò wa haq qnang ta anoe rai hatình ka dabau, cla Chuaq Jesus trùh rai lam ti wa. ");
INSERT INTO hrebt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mahaq mat wa haq ùh canau ka Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Haq bòch wa aih: “Jò chôp lam ti trong ìq, chôp qnang ta anoe ka dabau cleq?” Wa aih hi yòng, hadrò wa mangò dìq jaq. ");
INSERT INTO hrebt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ta wa aih i mòeq ngai yiniq haq Clê-oba, bòch haq: Ahìaq toq ìh kô raq qmòh, mangai enh gùng hangai trùh ta Jêrusalem ma ùh dùh ka loq yiniq neo loh ta aih bu baiq piq hì kô? ");
INSERT INTO hrebt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Haq bòch wa: “yiniq cleq aih?” Wa aih doe: Aih Chuaq Jesus, mangai gùng Naxaret, haq aih mangai pajàu itai enh yiniq broq trùh bàu capoch, enh ngèa Boc Plình xam enh ngèa kon mangai; ");
INSERT INTO hrebt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ùh qnì hagleq ƀài pajàu kàn xam ƀài cwan hadrah majah rùp haq am ka wì jêh đac, èh tiang đình haq talong pagat. ");
INSERT INTO hrebt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nhèn ngèh haq aih èh raq mahu dèch mangai Isorali, nhèn oe ngèh ùh hnau ka aih hòm, yiniq kô loh khoe piq hì kô. ");
INSERT INTO hrebt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Taqne nhèn, i ƀài mangai gucadrì broq ka nhèn hamàih, sroeh sroq kô wì haq lam ta ralùng, ");
INSERT INTO hrebt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mahaq chaq ùh hnoq hanang haq. Wì aih hlài doe ka nhèn i ƀình plình loh doe haq khoe rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Khoe aih i bua nhèn lam trùh ta ralùng hnoq rìm yiniq tìah ka bàu ƀài gucadrì khoe anoe, cla haq aih ùh hnoq. ");
INSERT INTO hrebt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chuaq Jesus doe ka wa haq: “Chôp kô joq ùh qnì, hagleq majah adia ka lùi dìq ka bàu wì pajàu ma khoe anoe! ");
INSERT INTO hrebt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ùh joq Mangai Mêsia ep xalep qmang aih, khoe aih men jah deh kan ranhòm qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Khoe aih, haq yŏc qmòe enh Môise trùh dìq dŏng ƀài pajàu hu anoe dôq wa loq dìq dŏng bàu ta hset hadròeh, aih dìq anoe trùh haq. ");
INSERT INTO hrebt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jò ten trùh ta plài wì haq ma ta-en lam, Chuaq Jesus tìah gleq enh lam tam yeo hangai. ");
INSERT INTO hrebt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mahaq wa aih àu padràng haq, wa aih doe: Ìh oe tacô ti ma, majah qmang aih trŏc khoe ten clam. Qmang aih, haq hi oe ti wa. ");
INSERT INTO hrebt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jò haq hangui acaq ti wa, haq yŏc ƀênh, manè apôi, khoe èh goh axong ka wa. ");
INSERT INTO hrebt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Wa hi tapèch mat, canau ka haq, yàng aih haq khoe hnhung hnhaiq. ");
INSERT INTO hrebt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wa doe ka dabau: Ìq haq jò oe ti trong, haq capoch tuàng ti ba rai anoe bahloh hset Hadròeh, ma ùh joq manoh ba tôq tìah qmòe ka ùnh qmòh? ");
INSERT INTO hrebt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jò aih raq, wa drah yòng, wìh hlài ta Jêrusalem, glàm mòeq jàt mòeq ngai tiaq cla xam ƀài mangai tiaq hŏc maqnoeq qnang tagop ti dabau, ");
INSERT INTO hrebt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","wa doe: Hi loq! Chuaq Jesus khoe rìh hlài, haq khoe mahno rađeh ka Simôn. ");
INSERT INTO hrebt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Khoe aih wa hi anoe yiniq wa khoe hnoq ti trong, qmang leq wa ma khoe canau ka Chuaq Jesus jò haq goh ƀênh. ");
INSERT INTO hrebt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mangai tiaq hŏc qnang anoe ti dabau, cla Chuaq Jesus loh taqne wì haq rai doe: “Catèm am ka pì.” ");
INSERT INTO hrebt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ƀài mangai tiaq hŏc haglènh, tarìt tariang, majah qmang aih wì haq xoh đeh hnoq kiac chŏc. ");
INSERT INTO hrebt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Haq doe: “Gleq pì majah yùq, gleq pì majah ùh lùi qmang qmat? ");
INSERT INTO hrebt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ngan jènh tì au, joq au raq. Pì bèq au beq, ngan beq, kiac chŏc ùh i ka xech akia, ùh i ka caxènh, mahaq au i.” ");
INSERT INTO hrebt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jò haq anoe qmang aih, haq patô dèh xam tì xam jènh ka wì aih hnoq. ");
INSERT INTO hrebt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mahaq ƀài mangai tiaq hŏc lem bùi hrìn, wì loh ka hamàih qnhòq dai lùi, haq hi doe ka wì: “Tacô pì i cleq acaq ùh?” ");
INSERT INTO hrebt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mangai tiaq hŏc qnèp ka haq haqnech ka bùh. ");
INSERT INTO hrebt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Haq hi yŏc acaq enh ngèa ka wì. ");
INSERT INTO hrebt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Khoe aih, haq doe: “Kô raq yiniq au khoe anoe ka pì loq jò au ma oe ti pì: Rìm yiniq ta ranenh Môise, xam ƀài pajàu xam hset calêu plình khoe achìh trùh au ep waq ka gêh”. ");
INSERT INTO hrebt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Khoe aih, haq pèh gàu ngoc wì, aih wì ma hi loq ka bàu Hset hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Haq doe ka wì: “I bàu achìh: Mangai Mêsia ep xalep qmang aih, trùh hì piq haq hi rìh hlài enh kan cachìt, ");
INSERT INTO hrebt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","aih èh wì hi yŏc Yiniq Haq hu lam anoe ka rìm ngai, rìm diac dôq wì loq raxach đòeq hujah caqnaih yiniq lui, patep enh Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pì lam anoe hlài yiniq aih, kô èh Au am ka pì yiniq Baq au ma khoe tèu, ");
INSERT INTO hrebt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","mahaq pì ep oe gòm ta Jêrusalem trùh jò pì jah caxùnh cwìang itai loh enh qnhèq.” ");
INSERT INTO hrebt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Khoe aih haq qnong ƀài mangai tiaq hŏc trùh nòe haten ka plài Bêthani, haq dèch tì am xôq ramot ka wì. ");
INSERT INTO hrebt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Qnang jò am xôq ramot, haq hi talah ka wì rai jah dèch tŏc ta plình. ");
INSERT INTO hrebt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mangai tiaq hŏc kùh waiq haq, khoe aih wì wìh hlài ta Jêrusalem rai lem bùi dìq jaq. ");
INSERT INTO hrebt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mangai tiaq hŏc oe yôt ta hnim kùh waiq, manè apôi Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ƀaxèm i Bàu, Bàu aih oe ti Boc Plình, èh Bàu aih raq Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Haq oe ti Boc Plình enh jò baxèm. ");
INSERT INTO hrebt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Rìm yiniq khoe jah broq loh enh haq, ùh i yiniq cleq ma i đeh enh gùng ka haq. ");
INSERT INTO hrebt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ta haq i kan rìh, èh kan rìh aih raq kan qngah am ka kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kan qngah sreo ta clam mahaq kan clam ùh waq kan qngah. ");
INSERT INTO hrebt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","I moeq ngai Boc Plình thê haq trùh, yiniq haq Jon. ");
INSERT INTO hrebt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Haq trùh hu anoe panhìn ka kan qngah aih, dôq mangai lùi đeh hra. ");
INSERT INTO hrebt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Cla haq aih ùh xài kan qngah, mahaq anoe am ka kan qngah. ");
INSERT INTO hrebt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kan qngah kô, aih raq joq kan qngah joq qnàng, jò haq trùh crŏng taneh kô sreo qngah ka rìm ngai. ");
INSERT INTO hrebt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bàu aih oe crŏng taneh kô, crŏng taneh kô loh enh haq, crŏng taneh kô ùh canau ka haq. ");
INSERT INTO hrebt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Haq khoe trùh ta gùng cla, mahaq wì ta aih ùh waq ka haq. ");
INSERT INTO hrebt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mahaq waq toq cabô hi lùi haq, aih haq hi am ka mangai aih cwìang đòeq hu wìa kon Boc Plình ");
INSERT INTO hrebt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","aih ƀài mangai ùh xài loh enh mahim jan, ùh xài loh enh ŏng mai, enh manoh mangai, mahaq loh enh Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bàu khoe wìh wìa xech akia, oe ta qne bèn, bình halùih kan tabàih xam trong joq qnàng, bèn khoe haqmiang hnoq kan ranhòm haq, joq kan ranhòm da Kon mòeq loh enh Baq. ");
INSERT INTO hrebt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jò anoe trùh Haq, Jon dêh bàu doe: Kô raq Mangai au khoe ràu trùh jò au doe: Haq mangai trùh atìq ka au, mahaq ùh hnau ka au, majah qmang aih haq i adroe ka au. ");
INSERT INTO hrebt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Aih ìq, jao kan bình halùih ta haq bèn majah kan tabàih yeo bàc hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Majah qmang aih, ranenh khoe paqnoh enh Môise, yàng kan tabàih xam trong joq qnàng aih trùh enh Jesus Christ. ");
INSERT INTO hrebt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Qnhòq i cabô hmaq hnoq Boc Plình, enh gùng ka Kon mòeq oe ta manoh Baq, Haq aih raq Mangai mahnu Baq am ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kô bàu Jon paqnoh, jò mangai Juđa thê bài mangai pajàu, ƀài mangai Lêwi enh Jêrusalem trùh bòch haq: Ìh kô ìq cabô? ");
INSERT INTO hrebt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Haq tapoch hloh ùh hangah moeq nà cleq, doe rađeh ùh xài Christ. ");
INSERT INTO hrebt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wì bòch hòm: qmang aih ìh qmat kabô? Ìh qmat Êli ùh xài? Haq padreo bàu: Ùh xài! Ìh qmat pajàu ùh xài? Haq padreo bàu: Ùh xài. ");
INSERT INTO hrebt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wì hi bòch: Qmang aih ìh kô ìq cabô? Dôq nhèn loq đòeq nhèn hu anoe hlài ka mangai ma thê nhèn lam. Ìh doe rađeh cabô? ");
INSERT INTO hrebt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Haq padreo bàu: Au kô bàu mangai creo ta gùng hawit: “Pajang trong ka Chuaq.” ");
INSERT INTO hrebt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ƀài mangai wì ma thê trùh ta Jon, aih dìq mangai Pharisi. ");
INSERT INTO hrebt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Wì bòch clò hòm: Tàng joq ìh ùh xài Christ, ùh xài Êli, ùh xài pajàu, òq hagleq ìh ma jah broq ƀaptem ka wì? ");
INSERT INTO hrebt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon doe: Au broq ƀaptem xi diac, mahaq i moeq ngai oe ta qne pì mahaq pì ùh canau. ");
INSERT INTO hrebt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aih raq Mangai trùh atìq ka au, au qnhòq tajì ka jah broq mangai kùp doeh caxi jep haq. ");
INSERT INTO hrebt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ƀài yiniq kô dìq loh ta gùng Bêthani, apah tau cròng diac Jôđan, nòe Jon broq ƀaptem. ");
INSERT INTO hrebt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Trùh hì atìq, Jon hnoq Chuaq Jesus trùh ti rađeh, haq doe: Hatau, Kon trìu da Boc Plình, Mangai ma hu dèch dŏng yiniq lui ta crŏng taneh! ");
INSERT INTO hrebt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Haq qmat raq mangai au ma khoe doe i Mangai trùh atìq ka au, mahaq yiloe ka au, majah qmang aih haq i adroe ka au. ");
INSERT INTO hrebt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Cla au ùh qnì ka Haq, mahaq au khoe trùh broq ƀaptem xam diac dôq Haq jah mahnu qnoh ka mangai Isorali. ");
INSERT INTO hrebt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon anoe am hòm: Au khoe hnoq Yiang Hadròeh enh plình tìah ka trù loh jràp Haq. ");
INSERT INTO hrebt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Au joq ùh qnì ka Haq, mahaq Yiang ma thê au broq ƀaptem xi diac i doe ka au rameh: Mangai ìh ma hnoq Yiang Hadròeh loh jràp oe ti haq, aih raq Mangai broq ƀaptem xi Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Au khoe hnoq, au majah doe: Haq aih raq kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hì da èh rameh, Jon oe ta aih ti baiq ngai tiaq hŏc haq. ");
INSERT INTO hrebt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hnoq Chuaq Jesus pagat trong aih, haq doe: Hatau, Kon trìu Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Baiq ngai tiaq hŏc tàng bàu aih, wa hi lam tiaq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chuaq Jesus wìh ngan, hnoq wa aih lam tiaq dađeh, haq bòch: “Chôp chaq cleq?” Wa aih padreo bàu: Rabi (aih mangai hnài). Ìh oe ta leq? ");
INSERT INTO hrebt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chuaq Jesus tèu wa: “Lam ngan beq!” Wa aih hi lam, hnoq nòe Chuaq Jesus oe, wa haq hi oe ti haq, jò aih qnah ta pôn jò di xèq. ");
INSERT INTO hrebt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wa baiq ngai ma tàng bàu Jon doe, èh lam tiaq hloe haq, aih moeq ngai yiniq haq Anrê, oh Simôn Phiero. ");
INSERT INTO hrebt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Angoe aih, haq lam chaq deh daq haq aih Simôn, haq hi anoe: Nhèn khoe glàm Mêsi (Mêsi aih Christ). ");
INSERT INTO hrebt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Haq hi qnung Simôn trùh ti Chuaq Jesus. Bu hnoq Simôn, Chuaq Jesus doe: “Ìh kô Simôn kon Jôna, pang kô èh jah creo ka ìh Sêpha” (aih Phiero). ");
INSERT INTO hrebt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Trùh hì atìq hòm, Chuaq Jesus tŏc ta gùng Galili, chaq Philip, haq creo: “Drah tiaq au.” ");
INSERT INTO hrebt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip aih oe gùng Bêtsai-đa, moeq gùng ka wa Anrê wa Phiero. ");
INSERT INTO hrebt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip chaq Natha-naên, haq doe: Nhèn khoe hnoq Mangai Môise ma achìh ta hset ranenh nèh, ƀài pajàu hanoh ràu trùh, aih Chuaq Jesus mangai ta Naxaret, kon da Jôsep. ");
INSERT INTO hrebt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natha-naên bòch: A lah i cleq ma wìa loh enh gùng Naxaret ùh? Philip doe: Trùh ngan beq. ");
INSERT INTO hrebt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jò Chuaq Jesus hnoq Natha-naên trùh ti dađeh, haq doe: “Kô, majoq mangai Isorali joq qnàng, enh dalam ka haq ùh i qmòe mòeq yiniq cleq jùh jùn”. ");
INSERT INTO hrebt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natha-naên bòch: Enh leq ìh ma jah loq ka au? Chuaq Jesus padreo bàu: “Adroe ka Philip creo ka ìh, au khoe hnoq ìh jò ìh oe anòe xèm long pŏc. ");
INSERT INTO hrebt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natha-naên hi doe: Rabi! Ìh kô joq kon calô Boc Plình! ");
INSERT INTO hrebt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chuaq Jesus doe: “Au khoe doe au hnoq ìh oe anòe xèm long pŏc ìh majah lùi, kô èh ìh jah hnoq trong ùh hnau ka aih. ");
INSERT INTO hrebt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Haq anoe hòm: “Joq qnàng, au anoe dìq ka pì, kô èh pì jah hnoq plình tapèch, xam ƀaì bình plình Boc Plình tŏc loh ajang Kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Piq hì atìq ka aih, i wì acaq yiniang ta Cana, trong gùng Galili, miq da Chuaq Jesus i mat ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chuaq Jesus xam mangai tiaq hŏc hanoh jah akhen. ");
INSERT INTO hrebt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jò wì bu dìq ka alac, miq Chuaq Jesus doe ka haq: Wì pi i ka alac! ");
INSERT INTO hrebt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Chuaq Jesus padreo bàu: “Mangai gucadrì meh, yiniq cleq ka ba? Jò da au qnhòq lap trùh! ");
INSERT INTO hrebt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Miq Haq tanap ka ƀài mangai patìh: Haq i thê cleq, pì broq tiaq dìq dŏng. ");
INSERT INTO hrebt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ta aih i tadràu toq padrì hmo, padon đòeq hu qnheo jènh ka mangai Juda, moeq toq jah padam ùh ta dràu jàt lit diac. ");
INSERT INTO hrebt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chuaq Jesus thê wì ùc diac bình ta aih, wì ùc bình trùh ta ngah. ");
INSERT INTO hrebt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chuaq Jesus doe: “Manòeq pì qmùc diac qmat beq, aràng am ka mangai ma ngan acaq ôq hì kô”. Wì hi qnàng ka haq aih. ");
INSERT INTO hrebt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jò haq aih ôq diac khoe wìa alac (haq ùh qnì alac kô loh enh leq, toq mangai patìh ma i qmùc diac aih ma loq) haq creo ka cla kon ŏng, ");
INSERT INTO hrebt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","rai doe: Da mangai qnoeq qnoh alac jìang adroe, jò wì ôq khoe bàc, èh qnoh alac qnang lem. Da ìh kô aih don đòeq alac jìang trùh manòeq. ");
INSERT INTO hrebt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aih ìq oe ta Cana, gùng Galili, Chuaq Jesus baxèm broq trong halac, rai mahno kan ranhòm dađeh, ƀài mangai tiaq hŏc hi lùi haq. ");
INSERT INTO hrebt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Khoe aih, Chuaq Jesus xam miq haq xam ƀài oh daq haq xam mangai tiaq hŏc, dìq loh ta Cabênaum, wì oe ta aih ƀiaq hì raq. ");
INSERT INTO hrebt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hì ramènh Pan cwa da mangai Juđa khoe ten trùh, Chuaq Jesus tŏc ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tanòe hamlang hnem kùh waiq, haq hnoq ƀài wì qnang tapadro: ƀo, trìu, trù, qnah mangai qnoeq hòm qnang hangui ti halìh bac jèn. ");
INSERT INTO hrebt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chuaq Jesus đênh moeq hadrang long roe caxi, haq hnan qnoh dŏng enh gùng ka nòe hnem kùh waiq, xam ƀo xam trìu, ùc cađac bac mangai ma padro bac jèn, hacùp hloe da wì aih cabŏng. ");
INSERT INTO hrebt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Haq doe ka mangai atech trù: “Qnoh ma dìq ƀài cleq qmat loh enh gùng ka nòe kô, apaq broq ka hnem Baq au loh nòe padro baxen. ");
INSERT INTO hrebt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mangai tiaq hŏc hmàng hlài i bàu ma khoe achìh: “Kan nhet dèh ka hnim Baq khoe bùh cheo au”. ");
INSERT INTO hrebt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ƀài mangai Juđa rahen ka haq: Ìh broq qmang qmat, ìh i dôq nhèn hnoq kan halac leq ùh, đòeq nhèn ma hu loq ìh cwìang broq qmang kô? ");
INSERT INTO hrebt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Chuaq Jesus padreo bàu: “Raliang hnem kô beq! Piq hì raq, au hi paqnàng hlài”. ");
INSERT INTO hrebt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mangai Juđa doe: Wì broq hnem kùh waiq kô dìq qmòe pôn jàt tadràu hanam, aih ìh ma doe ra đeh dèch haq piq hì raq? ");
INSERT INTO hrebt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mahaq hnim kùh waiq Chuaq Jesus ma anoe aih chac cla haq. ");
INSERT INTO hrebt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Khoe ka Chuaq Jesus rìh hlài enh kan cachìt, mangai tiaq hŏc hèm hlài haq i anoe bàu aih, aih wì ma hi lùi bàu hset hadròeh xam bàu Chuaq Jesus ma khoe tapoch. ");
INSERT INTO hrebt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Hì ramènh Pan cwa, Chuaq Jesus qnang oe ta Jêrusalem, bàc ngai hnoq kan halac haq broq, wì hi lùi yiniq haq. ");
INSERT INTO hrebt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mahaq Chuaq Jesus ùh dôq rađeh mùt ta ti kŏngwì, majah qmang aih haq loq ka manoh rìm ngai. ");
INSERT INTO hrebt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ùh ep i cabô doe, majah qmang aih haq loq đeh rìm yiniq oe ta manoh mangai. ");
INSERT INTO hrebt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Taqne ƀài mangai Pharisi, i moeq ngai yiniq haq Nicôđem, haq aih hanoh broq craq wèq mangai Juda. ");
INSERT INTO hrebt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Damang, mangai kô trùh ti Chuaq Jesus haq doe: Rabi, nhèn loq ìh kô mangai hnài trùh enh Boc Plình, majah qmang aih ƀài trong halac ìh ma khoe broq, tàng joq Boc Plình ùh oe moeq qmang, ùh i cabô broq jah. ");
INSERT INTO hrebt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chuaq Jesus padreo bàu: “Joq nàng, joq qnàng, au doe ka ìh, ùh i mangai leq jah hnoq Diac Plình, tàng joq mangai aih ùh ha-uang lauq moeq yàng hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicôđem bòch: Mangai khoe craq, ha-uang lauq qmang leq ma oe jah? Haq wìa ka oe jah mùt ta cliac miq đòeq hu ha-uang lauq moeq yàng hòm? ");
INSERT INTO hrebt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Chuaq Jesus doe: “Joq qnàng au doe ka ìh, ùh i mangai leq jah mùt Diac Boc Plình, tàng joq mangai aih ùh canòm ka diac xamYiang Hadròeh đòeq ha-uang lauq. ");
INSERT INTO hrebt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Xech akia ha-uang loh xech akia, mahaq Yiang ha-uang loh yiang. ");
INSERT INTO hrebt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ùh dùh hamàih bàu au anoe ka ìh: Pì ep ha-uang lauq moeq yàng hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Cayeo enh taleq haq hlui tameh, pì tàng atêh, mahaq pì ùh qnì cayeo trùh enh leq, haq lam taleq. Mangai leq ha-uang loh enh Yiang Hadròeh hadai qmang aih”. ");
INSERT INTO hrebt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicôđem bòch: Broq qmang leq majah qmang aih? ");
INSERT INTO hrebt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Chuaq Jesus padreo bàu: “Ìh qmat mangai hnài mangai Isorali, laiq ìh ma ùh qnì tàng bàu aih? ");
INSERT INTO hrebt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Joq qnàng, joq qnàng au doe ka ìh: nhèn anoe trong nhèn loq, nhèn patô trong nhèn khoe hnoq, mahaq dua pì ùh dì yŏc bàu nhèn khoe anoe patô. ");
INSERT INTO hrebt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tàng joq au anoe ka pì trong oe crŏng taneh kô, dua pì qnhòq lùi, loq ka au anoe ka pì yiniq ma oe ta plình, aih pì lùi qmang leq majah? ");
INSERT INTO hrebt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Qnhòq i cabô tŏc ta plình, enh gùng ka Mangai ma loh enh plình, aih raq Kon mangai ma oe dèh ta plình. ");
INSERT INTO hrebt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nèh haq Môise dèch paqnàng bìh tanòe hawit croh crênh qmanag leq, Kon mangai èh hadai ep wì dèch paqnàng haq qmang aih diq, ");
INSERT INTO hrebt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","mahaq waq toq cabô hi lùi haq, hi jah kan rìh halình mòeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pàng Boc plình loq waq ka crŏng taneh, loh qmòe ka khoe am dèh Kon moeq cla haq, đòeq cabô lùi Kon aih ùh hìaq raliang hnhung mahaq jah kan rìh halình mòeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Aih ìq, Boc Plình khoe thê dèh Kon haq loh crŏng taneh kô, ùh xài đòeq hu tah kan hadrah ka crŏng taneh, mahaq đòeq ka crŏng taneh kô canòm ka Kon aih hujah dèch. ");
INSERT INTO hrebt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Cabô hi lùi haq mangai aih pi ep pòq kan hadrah hòm, cabô ùh lùi khoe pòq qmòe kan hadrah, majah qmang aih pàng haq ùh lùi yiniq Kon mòeq Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kan hadrah aih rameh: Kan qngah khoe trùh crŏng taneh, mahaq kon mangai bêh kan clam cluiq ùh hnau ka kan qngah, majah qmangai yiniq wì haq broq dìq qmèq. ");
INSERT INTO hrebt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mangai broq qmèq, dìq git ka kan qngah, ùh hùa thia ta kan qngah, yùq yiniq đeh khoe broq loq pi hlèp. ");
INSERT INTO hrebt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mahaq mangai leq rìh tiaq bàu joq qnàng aih, haq trùh ti kan qngah, dôq dìq dŏng yineq haq khoe broq jah paqnoh majah qmang aih haq khoe broq enh ngèa ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Khoe aih, Chuaq Jesus xam ƀài mangai tiaq hŏc lam trùh ta gùng Juđa, haq oe ta aih ti wì, rai broq ƀaptem. ");
INSERT INTO hrebt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jò aih Jon hanoh broq ƀaptem ta Ênon, haten ka Salim, majah qmang aih ta aih bàc diac, wì bàc ngai trùh hu jah broq ƀaptem. ");
INSERT INTO hrebt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jò aih wì qnhòq rùp clêh haq. ");
INSERT INTO hrebt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mangai tiaq hŏc Jon i tarahen ka mangai Juđa trong ramènh basròeh. ");
INSERT INTO hrebt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wì lam anoe ka Jon rameh: Rabi, hatau mangai ma oe ti ìh pah tau cròng diac Jôđan, mangai ìh ma khoe ràu trùh, manòeq haq qnang broq ƀaptem, mangai trùh đeh hra ta haq. ");
INSERT INTO hrebt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon doe: Tàng joq ùh xài enh plình am, ùh i cabô jah cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Cla pì raq ma khoe wiang tàng bàu au doe: Au kô ùh xài Christ, mahaq au kô khoe jah thê lam enh ngèa haq. ");
INSERT INTO hrebt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cabô neo yŏc mai, aih raq cla kon ŏng, ƀòe bua haq oe ten aih tàng bàu haq, jò wì jah tàng bàu cla kon ŏng wì dìq jaq lem bùi, aih raq kan lem bùi da au. ");
INSERT INTO hrebt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Haq aih jah padèch ka haqnhèq, au kô èh ep paqnoh đac ta haqneq. ");
INSERT INTO hrebt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mangai trùh enh qnhèq, haq aih yeo haqnhèq dìq dŏng rìm trong, mangai loh enh taneh, haq aih da taneh, haq tapoch hadai tìah ka mangai loh enh taneh. Mangai loh enh plình, haq aih ma yeo nhèq dìq dŏng rìm trong. ");
INSERT INTO hrebt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Haq anoe trong haq ma khoe hnoq khoe tàng, mahaq ùh i cabô dì bàu haq. ");
INSERT INTO hrebt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mangai leq khoe rùp bàu haq, mangai aih hadai wiang panhìn ka cajap bàu Boc Plình aih joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Majah qmang aih Mangai Boc Plình ma khoe thê, haq aih trùh anoe toq bàu Boc Plình, majah qmang aih Boc Plình khoe am ka haq Yiang Hadròeh oe i jaq cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baq loq waq dèh Kon, khoe qnèp dìq dŏng rìm yiniq ta tì Kon. ");
INSERT INTO hrebt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mangai leq lùi Kon, jah kan rìh halình mòeq đòe, mangai ùh lùi Kon, ùh i hnoq kan rìh taleq, mahaq kan mahau nòeh da Boc Plình oe raq enh qnhèq ka mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jò Chuaq Jesus hìa bàu doe mangai Pharisi i tàng haq creo broq ƀaptem jah bàc ngai ùh hnau ka Jon, ");
INSERT INTO hrebt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ùh xài cla Jesus, ma joq qnàng aih mangai tiaq hŏc haq). ");
INSERT INTO hrebt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Chuaq Jesus cađac gùng Juđê wìh hlài ta Galili. ");
INSERT INTO hrebt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jò aih, haq ep pagat trong Samari. ");
INSERT INTO hrebt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Qmang aih, Haq trùh ta mòeq plài gùng Samari, plài aih wì creo Sikha, haten tanòe taneh Jacôp ma am ka Jôsep aih kon haq. ");
INSERT INTO hrebt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ta aih i moeq toq diac adràm Jacôp, khoe lep ka trong hangai Chuaq Jesus hangui haten ka adràm aih, jò aih khoeqne hì. ");
INSERT INTO hrebt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mòeq ngai gucadrì samari loh qnình diac. Chuaq Jeus doe: “Am au ôq diac. ");
INSERT INTO hrebt_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ƀài mangai tiaq hŏc khoe mùt ta plài đòeq chaq rot dahwèq acaq). ");
INSERT INTO hrebt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mangai cadrì aih padreo bàu: Ùih! Ìh qmat mangai Juđa, gleq ma jah bòch ôq da au diac (majah qmang aih mangai Juđa ùh taqmùt ka mangai Samari). ");
INSERT INTO hrebt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Chuaq Jesus doe: “Tàng joq ìh maloq ka yiniq Boc Plình ma khoe am, rai loq ka magai ma doe ka ìh: Am au ôq đeh diac aih cabô, aih ìh khoe bòch haq am ka ìh ôq, aih èh haq aih hi am ka ìh diac kan rìh.” ");
INSERT INTO hrebt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mangai gucadrì aih doe: Wì Craq! Ìh ùh i cleq đòeq hu qmùc, diac adràm kô aih jrùq, ìh jah diac rìh aih enh leq? ");
INSERT INTO hrebt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kan cadraq nhèn aih Jacôp khoe đòeq hlài ka nhèn diac adràm kô, cla haq hanoh ôq adràm kô, hloe xam ƀài kon xau haq, hloe xam ƀài kùng hang haq ban, ìh ma yeo kàn ùh hnau ka Jacôp? ");
INSERT INTO hrebt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chuaq Jesus padreo bàu ka haq: “Cabô ôq diac kô dua oe raq croh ranŏng, ");
INSERT INTO hrebt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","mahaq mangai leq ôq diac au am, mangai aih èh pi jò leq croh ranŏng hòm. Diac au ma am aih èh wìa tamŏc plôh enh chac mangai aih trùh ta kan rìh halình mòeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mangai gucadrì aih doe: Wì Craq, Ìh am ka au diac aih diq, dôq au ùh hìaq croh ranŏng, dôq au pi hìaq ep lam qmùc diac ta kô hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chuaq Jesus doe ka haq: “Lam beq! creo ka ŏng ìh, khoe aih wìh hlài ta kô.” ");
INSERT INTO hrebt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mangai gucadrì aih doe: Au ùh i ka ŏng. Chuaq Jesus anoe hòm: “Ìh doe đeh ùh i ka ŏng aih joq khoe troq, ");
INSERT INTO hrebt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ìh khoe padam yàng yŏc ŏng, mahaq mangai yàng kô aih ùh xài ŏng ìh, ma aih joq ìh khoe tapoch dèh joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mangai gucadrì aih doe: Wì Craq, au hnoq ìh kô mangai pajàu joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kan kadraq nhèn khoe kùh waiq tanòe bui wang kô, yàng da mangai Juđa aih doe nòe ma troq ka kùh waiq aih oe ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chuaq Jesus doe ka mangai gucadrì: “Drah lùi bàu au, hi trùh jò èh, pì kùh waiq Baq, ùh xài ta bui wang kô, hanoh ùh xài ta Jerusalem. ");
INSERT INTO hrebt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pì kùh waiq ƀàiyiniq pì ùh qnì, nhèn kùh waiq yiniq nhèn ma khoe loq, majah qmang aih kan dèch loh enh mangai Juđa. ");
INSERT INTO hrebt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mahaq jò mahi trùh, manòeq kô khoe trùh, jò wì mangaima kùh waiq joq qnàng yŏc manoh xam bàu joq qnàng đòeq kùh waiq, aih raq ƀài mangai kùh waiq Baq ma enh. ");
INSERT INTO hrebt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Boc Plình aih Yeang, cabô kùh waiq haq ep yŏc manoh xam bàu joq qnàng đòeq kùh waiq. ");
INSERT INTO hrebt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mangai gucadrì doe: Au loq, Mangai Mêsi (aih bèn creo Christ) ep trùh, jò haq trùh, haq hi anoe rìm trong am ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Chuaq Jesus doe: “Au, mangai qnang capoch ti ìh, au kô raq Mangai aih”. ");
INSERT INTO hrebt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jò aih, wì mangai tiaq hŏc hlài hi trùh, wì haq haglènh jò wì hnoq Chuaq Jesus capoch tuàng ti mangai gucadrì, mahaq ùh i mangai leq bòch: Ìh anoe ka haq qmat yiniq cleq? Ùh meh hagleq Ìh majah hatuàng ti haq? ");
INSERT INTO hrebt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mangai gucadrì aih hi đòeq đac dèh abôq ta aih wìh mùt ta plài, doe ka wì ta aih: ");
INSERT INTO hrebt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Drah loh ngan, i mòeq ngai khoe anoe dŏng da au rìm trong au ma khoe broq, aih ma ùh xài Christ qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wì hi loh enh plài trùh ti Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mahaq, wì mangai tiaq hŏc ti àu yôt haq: Rabi, Ìh acaq diq. ");
INSERT INTO hrebt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Haq padreo bàu: “Au i dèh dahwèq đòeq hu ban rađeh mahaq pì ùh qnì. ");
INSERT INTO hrebt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aih ìq, mangai tiaq hŏc majah bòch dabau: Ahìaq i mangai leq khoe aràng ka haq dahwèq acaq ùh xài? ");
INSERT INTO hrebt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chuaq Jesus doe: “Dahwèq acaq da au aih broq tiaq manoh Mangai ma khoe thê au trùh, rai pagêh da haq yiniq broq. ");
INSERT INTO hrebt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ma ùh xài pì doe oe pôn khê ònh èh men trùh jò gat qmòh? Mahaq au doe ka pì: “Haqmiang beq! rai ngan ta ruàng khoe dùm yrùng dŏng, oe toq hu gat raq. ");
INSERT INTO hrebt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mangai gat khoe yŏc dèh kùng baha rai don đòeq qmau ta kan rìh halình mòeq đòe, dôq xam mangai rai adrech xam mangai gat hadai jah lem bùi ti da bau. ");
INSERT INTO hrebt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kô èh wì jah doe: “Mangai kô rai, mangai tau gat, aih joq khoe wop. ");
INSERT INTO hrebt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Au khoe thê pì trùh gat tanòe pì ùh i abèq, mangai qnoeq ma khoe broq, pì mùt ta aih toq yŏc haqnauq padren mangai qnoeq” ");
INSERT INTO hrebt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","I bàc ngai Samari ta aih lùi haq, tiaq bàu mangai gucadrì ma doe: Haq qmat khoe anoe dŏng rìm trong au ma khoe broq. ");
INSERT INTO hrebt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Qmang aih, ƀài mangai Samari ma khoe trùh ti haq, àu thê haq mùt padài dèh ta plài, Haq padài ta aih baiq hì. ");
INSERT INTO hrebt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jò khoe tàng bàu haq, mangai lùi haq rai bàc tam. ");
INSERT INTO hrebt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wì aih doe ka mangai gucadrì: Kô pi oe xài enh bàu ìh ma khoe anoe am ka nhèn taleq, nhèn ma lùi, manòeq kô nhèn khoe tàng qmòe enh cla haq, èh nhèn loq haq kô joq Mangai hu dèch dìq crŏng taneh kô. ");
INSERT INTO hrebt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Atìq ka aih baiq hì Chuaq Jesus loh enh aih lam ta Galili. ");
INSERT INTO hrebt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Aih ìq cla Haq raq khoe doe mangai pajàu ùh i jò leq jah mangai gùng cla manè). ");
INSERT INTO hrebt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jò khoe trùh ta gùng Galili, wì gùng aih đìh haq dìq dèh ka manoh, majah qmang aih wì gùng aih khoe hnoq rìm yiniq Haq broq ta hì ramènh jò oe ta Jêrusalem, majah qmang aih wì aih hanoh i lam hàu hì ramènh aih. ");
INSERT INTO hrebt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Haq trùh ta plài Cana, ta gùng Galili, nòe Haq ma khoe broq diac hangeo wìa alac. Oe ta plài Cabênaum, i moeq ngai cwan kàn, kon calô haq aih hinìq. ");
INSERT INTO hrebt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cwan aih tàng doe Chuaq Jesus enh gùng Juđê khoe trùh ta Galili, haq drah trùh chaq rai creo dang Chuaq Jesus loh ta hnem rađeh hu haqnauq dèh kon haq khoe ten cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Chuaq Jesus doe: “Tàng joq pì ùh hnoq kan halac, kan hamàih, ùh jò leq pì lùi”. ");
INSERT INTO hrebt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Cwan aih doe: Wì Craq, au canòm đeh ka ìh loh ta hnim au jò kon au qnhòq hìaq cachìt! ");
INSERT INTO hrebt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chuaq Jesus doe ka haq: “Lam beq, kon ìh rìh.” Mangai aih lùi bàu Chuaq Jesus khoe anoe ka rađeh, haq hi lam. ");
INSERT INTO hrebt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jò haq oe raq lam titrong, wì mangai hapŏng loh đìh haq, wì doe: Kon calô ìh khoe rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Haq bòch wì aih kon haq khoe blình jò leq. Wì aih padreo bàu: Hì nèh, jò mòeq jò, kan tanget khoe brêh. ");
INSERT INTO hrebt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mangai baq aih kanau loq aih raq jò Chuaq Jesus doe ka haq: Kon ìh rìh, pang aih haq aih xam dìq ka wì ta hnem hi lùi. ");
INSERT INTO hrebt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aih kan halac yàng baiq Chauaq Jesus broq, Jò haq tawìh enh gùng Juđê hlài ta Galili. ");
INSERT INTO hrebt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Khoe aih, i mòeq hì ramènh ta wì mangai Juđa, Chuaq Jesus tŏc ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jò aih ta Jêrusalem, haten ka qmang Trìu, i moeq toq hlŏng, bàu Hêbru creo Bêtetda, dudan ta aih i padam toq qmang. ");
INSERT INTO hrebt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bàc haraya ƀài mangai yinìq, mangai ùh xau hoq, mangai angwenh, mangai pen kùi ta aih, (rap gòm jò diac lai laq), ");
INSERT INTO hrebt_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","majah qmang aih i moeq ƀình plình dùnh dùnh loh lai laq diac ta hlŏng aih, jò diac khoe lai laq, mangai leq loh ta hlŏng adroe, yac ka haq yinìq qmang leq dua brêh). ");
INSERT INTO hrebt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ta aih i moeq ngai ùh hrŏc khoe piq jàt rahem hanam. ");
INSERT INTO hrebt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chuaq Jesus hnoq haq aih caqnùng, loq ka haq aih yinìq khoe dùnh, Haq doe: “Ìh i enh brêh ùh? ");
INSERT INTO hrebt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mangai yinìq aih padreo bàu: Wì Craq! au ùh i đeh ka mangai hu wiang caqnìh qnoh au ta diac. Jò au qnang ti àu loh đeh, i mangai qnoeq khoe loh adroe ka au. ");
INSERT INTO hrebt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chuaq Jesus doe: “Drah yòng, dèch da ìh hadòng qmat lam beq.” ");
INSERT INTO hrebt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wop hloe jò aih raq, mangai aih jah brêh. Hì aih hanoh wop hì Sabat. ");
INSERT INTO hrebt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ƀài ma broq gàu mangai Juđa tapoch ka mangai ma khoe jah brêh: Kô xài hì Sabat, tiaq troq ranenh ìh ùh khòh xùi hadòng lam qmang qmat. ");
INSERT INTO hrebt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Haq padreo bàu ka wì: Cla mangai ma broq ka au brêh thê: Dèch da ìh hadòng qmat lam beq. ");
INSERT INTO hrebt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wì bòch haq: Mangai ma thê dèch da ìh hadòng qmat lam beq, haq aih ìq cabô? ");
INSERT INTO hrebt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mahaq mangai khoe jah broq brêh aih haq pi qnì qmòe ka cabô, majah qmang aih Chuaq Jesus khoe alùh pajùm ti ƀài mangai cràm jang aih raq. ");
INSERT INTO hrebt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Atìq ka aih, Chuaq Jesus hnoq haq aih tanòe hnim kùh waiq hi doe ka haq: “Meh oq, ìh khoe brêh pi dùh broq yiniq lui hòm, beq loq i yiniq cleq mèq trùh ti ìh.” ");
INSERT INTO hrebt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Haq aih lam anoe ka mangai Juđa: Hatau raq Chuaq Jesus mangai khoe broq rađeh jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Aih ìq, dài mangai Juda majah tirùp baxa Chuaq Jesus, majah qmang aih haq broq yiniq kô hi Sabat. ");
INSERT INTO hrebt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mahaq Chuaq Jesus doe ka wì aih: “Baq au abroq trùh manòeq kô, au kô hadai broq qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ajang aih raq mangai Juđa majah chaq trong hu jêh đac hloe haq, ùh xài aq toq poh hì Sabat hi hêq, yàng haq oe doe Boc Plình aih Baq rađeh rai broq ka rađeh daq dàng ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chuaq Jesus hi anoe ka wì haq: “Joq qnàng, joq qnàng, au anoe ka pì, Kon ùh broq đeh cleq jah, Kon broq toq yiniq cleq kon hnoq dèh Baq broq, Kon hadai broq tiaq qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Baq loq waq ka kon rai mahno dìq dŏng rìm yiniq Baq broq: Baq oe mahno tam ka Kon yiniq kàn ùh hnau ka bài yiniq broq kô hòm, dôq pì hu hamàih. ");
INSERT INTO hrebt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Hanoh, qmang ka Baq broq mangai cachìt rìh hlài rai am kan rìh ka wì aih qmang leq, Kon kô èh hadai am kan rìh ka mangai kon ma enh qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baq hadai ùh hadrah ka cabô, mahaq khoe dôq dìq ka Kon cwìang hadrah, ");
INSERT INTO hrebt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","đòeq dìq dŏng rìm ngai jah dèch kan ranhòm ka Kon, tìah ka wì ma padèch kan ranhòm ka Baq. Mangai leq ùh dèch kan ranhòm ka Kon, aih haq ùh dèch kan ranhòm ka Baq, aih Mangai ma khoe thê Kon trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Joq qnàng, joq qnàng, au doe ka pì, mangai leq tàng bàu au, èh lùi Mangai ma khoe thê au, mangai aih jah kan rìh mòeq đòe, ùh hìaq ep trùh tanòe hadrah, mahaq khoe claih enh kan cachìt đòeq trùh ta kan rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Joq qnàng, joq qnàng, au anoe ka pì, tangèa kô èh, manòe kô hanoh khoe troq jò, jò ƀài mangai cachìt hujah tàng bàu Kon Boc Plình, mangai jah tàng aih èh hi jah rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tìah troeq Baq i kan rìh enh dalam, Baq hadai khoe am ka Kon i kan rìh enh dalam qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Baq khoe am dìq dŏng cwìang đòeq hu hadrah ta tì Kon, majah qmang aih Kon kô Mangai. ");
INSERT INTO hrebt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ùh dùh hamàih dèh trong aih, kô èh jò wì ma oe ta ralùng tàng bàu haq, wì jah loh enh aih, ");
INSERT INTO hrebt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mangai leq broq trong lem aih èh rìh hlài đòeq hu jah kan rìh, mangai leq khoe broq dù, aih èh rìh hlài đòeq hu jah kan hadrah. ");
INSERT INTO hrebt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Cla Au ùh broq cleq ma hlàt, au hadrah tiaq au trong tàng, qmang aih kan hadrah au aih taq toq, majah qmang aih au ùh chaq trong manoh cla ma enh, mahaq chaq trong Mangai ma khoe thê au. ");
INSERT INTO hrebt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tàng joq au capoch panhìn ka cla rađeh, bàu panhìn aih ùh wìa ka pì lùi dèh. ");
INSERT INTO hrebt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","I mangai qnoeq capoch panhìn am ka au, èh au loq bàu haq aih anoe khòh lùi. ");
INSERT INTO hrebt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pì khoe thê mangai trùh ti Jon, haq khoe anoe panhìn ka pì trùh bàu joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Da Au hòm, bàu panhìn au jah ùh xài trùh enh kon mangai, mahaq au anoe qmang aih, dôq pì jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon aih, tìah ka hadreo khoe bùh khoe qngah, kan qngah đò aih lem manoh pì, pì hyòq ajang nòe qngah haq aih. ");
INSERT INTO hrebt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mahaq i mòeq bàu capoch panhìn trùh au, bàu aih yeo haqnhèq ùh hnau ka bàu Jon, majah qmang aih trong leq Baq khoe thê, au broq gêh, ƀài yiniq au broq aih patô am ka pì loq Baq khoe thê au. ");
INSERT INTO hrebt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Cla Baq, aih Mangai ma khoe thê au, hanoh wiang panhìn am ka au. Pì qnhòq hmaq tàng bàu Haq, qnhòq lah hnoq hadrò Haq, ");
INSERT INTO hrebt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","èh bàu Haq ùh oe enh dalam ka pì, majah qmang aih pì ùh lùi Mangai Haq ma khoe thê trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pì chèh chaq ta hset Hadròeh, pì hèm dèh canau ajang aih majah kan rìh halình mòeq đòe: Aih Hset hadròeh mahno trùh au. ");
INSERT INTO hrebt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pì ùh enh trùh ti au đòeq hu jah kan rìh! ");
INSERT INTO hrebt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Au ùh chaq kan ranhòm loh enh kon mangai, ");
INSERT INTO hrebt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","mahaq au loq enh dalam pì ùh i ka kan loq waq ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Au khoe trùh tacô enh dalam ka yiniq Baq au, pì ùh waq ka au. Tàng joq i mangai qnoeq yŏc dèh yiniq cla haq hu trùh ti pì, aih èh pì ma đìh yŏc haq. ");
INSERT INTO hrebt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pì toq enh canòm kan ranhòm dabau, ùh chaq kan ranhòm trùh enh Boc Plình, qmang aih thê pì lùi qmang leq majah. ");
INSERT INTO hrebt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Apaq hèm au yòng enh ngèa Baq đòeq patô da pì yiniq lui, mangai ma yòng patô da pì yiniq lui aih Môise, mangai pì ma tangèh canòm. ");
INSERT INTO hrebt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Aih ìq, tàng joq pì lùi bàu Môise, pì hadai lùi bàu au, majah qmang aih bàu haq ma khoe achìh aih, haq achìh trùh au. ");
INSERT INTO hrebt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mahaq tàng joq pì ùh lùi bàu haq, pì lùi bàu au qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Atìq ka aih toq biaq, Chuaq Jesus tŏc apah tau diac raxìq Galili, (nòe kô aih haqmai gùng Têbiriat, ");
INSERT INTO hrebt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Moeq calùh mangai bàc haraya tiaq haq, majah qmang aih wì aih hmaq hnoq bàc trong halac haq broq brêh ka ƀài mangai yinìq. ");
INSERT INTO hrebt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mahaq, Chuaq Jesus tŏc ta wang, hangui ta aih ti ƀài mangai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hì ramènh Pancwa da mangai Juđa khoe ten trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jò Chuaq Jesus haqmiang ngan hnoq wì aih qnang thia ta haq, haq doe ka Philip: “Bèn chaq rot ƀênh taleq đòeq hu am ka wì acaq?” ");
INSERT INTO hrebt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Haq bòch qmang aih hu nhro ngan Philip, majah qmang aih ta manoh haq khoe loq đeh padon broq cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip padreo bàu: Yŏc baiq hrinh đo-ni-ê, rot ƀênh dua ùh rìm mòeq ngai toq biaq. ");
INSERT INTO hrebt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","I mòeq ngai tiaq hŏc yiniq haq Anrê, oh Simôn doe: ");
INSERT INTO hrebt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Hacô i mòeq ngai kon calô qyoh, i padam toq ƀênh mi xam baiq pliang ka qyêq, mahaq mangai bàc qmang qmat i jàp pang leq? ");
INSERT INTO hrebt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chuaq Jesus doe: “Thê wì hangui”. Tanòe aih bàc nhat, wì hi hangui. Jah qnah ta padam muàn mangai. ");
INSERT INTO hrebt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chuaq Jesus yŏc ƀênh manè apôi Boc plình, khoe aih axong am ka ƀài mangai hangui, haq hadai yŏc baiq pliang ka axong am ka wì, mac ka cabô enh toq leq toq meh. ");
INSERT INTO hrebt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jò dìq ka wì khoe panàc, haq thê mangai tiaq hŏc: “Ti toch hlài ƀòe rah, apaq cađac yac ka toq xit.” ");
INSERT INTO hrebt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mangai tiaq hŏc toch hlài haqnech rah padam toq ƀênh atìq ka wì khoe panàc jah mòeq jàt baiq rajo. ");
INSERT INTO hrebt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wì ta aih, hnoq kan halac Chuaq Jesus broq, wì doe ka dabau: Kô raq Pajàu! mangai mahu loh ta crŏng taneh. ");
INSERT INTO hrebt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Chuaq Jesus loq ka wì enh trùh đòeq pa-àu rađeh broq bùa, Haq wia enh aih, tŏc oe đeh mòeq ngai ta wang. ");
INSERT INTO hrebt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jò mat mahì khoe ten clìh, mangai tiaq hŏc loh ta haqmai diac. ");
INSERT INTO hrebt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wì loh ta boang pajang tŏc pah tau, ngèa qnah ta plài Cabêna-um. Trŏc khoe clam mahaq Chuaq Jesus qnhòq trùh ti wì haq. ");
INSERT INTO hrebt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Cayeo hlui tagruàng tagràt, diac lai laq dêh pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jò aih wì chùng boang khoe jah qnah ta baiq jàt padam ùh piq jàt êta-đo, hnoq Chuaq Jesus lam tiriang diac, ten trùh ti boang, wì loh ka crè crep. ");
INSERT INTO hrebt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mahaq Chuaq Jesus doe: “Kô raq Au, apaq yùq.” ");
INSERT INTO hrebt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jò aih mangai tiaq hŏc hi đìh Chuaq Jesus tŏc boang ti wì, draq drình hloe jò aih boang khoe trùh tago wì ma padon lam. ");
INSERT INTO hrebt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hì atìq, ƀài mangai bàc oe tago patau hlŏng hnoq mòeq toq boang ta aih raq, loq Chuaq Jesus ùh i tŏc taboang ti ƀài mangai tiaq hŏc, toq mangai tiaq hŏc lam ka rađeh. ");
INSERT INTO hrebt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Khoe aih i biaq toq boang enh Têbi-ri-at trùh tanòe ƀài wì ma acaq ƀênh atìq ka Chuaq Jesus ma manè apôi Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wì hnoq Chuaq Jesus ùh i oe ta aih, mangai tiaq hŏc hadai ùh hnoq, wì drah loh taboang hu lam ta Cabêna-um đòeq chaq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jò wì bu hnoq Chuaq Jesus tago apah tau diac, wì bòch Haq: Rabi! Ìh trùh tacô jò leq? ");
INSERT INTO hrebt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Chuaq Jesus doe: “Joq qnàng Au doe ka pì, pì ti chaq au ùh xài taiq pì khoe hnoq trong halac au khoe broq, mahaq taiq pì khoe jah acaq ƀênh ka panàc. ");
INSERT INTO hrebt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Apaq abroq hu chaq toq dahwèq acaq hi dìq hi hnhung, mahaq chaq dahwèq ma oe hloe mòeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Khoe aih wì bòch Haq: Nhèn ep broq qmang leq men jah broq yiniq Boc plình ma thê? ");
INSERT INTO hrebt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Chuaq Jesus doe: “Yiniq broq da Boc plình thê, aih pì lùi Mangai Boc plình ma khoe thê haq trùh.” ");
INSERT INTO hrebt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wì bòch haq: “Tàng joq qmang aih, ìh broq trong halac leq dôq nhèn hnoq đòeq nhèn hu lùi? Kô èh ìh broqcleq? ");
INSERT INTO hrebt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Boc yaq nhèn nèh khoe acaq mana oe ta gùng hawit, tìah ka bàu khoe achìh: Haq am ka wì acaq ƀênh enh plình. ");
INSERT INTO hrebt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chuaq Jesus padreo bàu: “Joq qnàng, joq qnàng au doe ka pì: Môise qnhòq lah am ka pì ƀênh enh plình, mahaq Baq au ma am ka pì ƀênh joq qnàng, aih ƀênh loh enh plình. ");
INSERT INTO hrebt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Majah qmang aih, ƀênh da Boc plình aih ƀênh loh enh plình, am kan rìh ka crŏng taneh. ");
INSERT INTO hrebt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wì doe: Waiq Chuaq, Ìh am ka nhèn ƀênh aih yôt oq! ");
INSERT INTO hrebt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Chuaq Jesus doe ka wì: “Au kô raq ƀênh kan rìh, mangai leq trùh ti au haq aih pi hìaq pangot hòm, mangai leq lùi au, haq aih pi hìaq croh ranŏng hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mahaq au khoe anoe: Pì khoe hnoq au, mahaq pì ùh lùi. ");
INSERT INTO hrebt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dìq dŏng mangai leq Baq khoe am ka au aih èh wì trùh ti au, mangai leq trùh ti au, ùh jò leq au khwênh qnoh đac enh gùng. ");
INSERT INTO hrebt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Majah qmang aih au khoe loh enh plình ùh xài đòeq broq tiaq deh manoh, mahaq broq tiaq manoh Mangai ma khoe thê au. ");
INSERT INTO hrebt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kô manoh Mangai ma khoe thê au: mangai leq Haq khoe am ka au, aih au apaq cađac hnhung, mahaq au ep broq haq rìh hlài ta hì pulùch èh. ");
INSERT INTO hrebt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kô manoh Baq au: Mangai leq ngan Kon rai lùi kon aih mangai aih jah kan rìh halình mòeq đòe, hì atìq lùch au broq haq aih rìh hlài.” ");
INSERT INTO hrebt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jò aih, mangai Juđa mumùc ka haq, majah qmang aih haq i doe: Au kô raq ƀênh loh enh Plình.” ");
INSERT INTO hrebt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wì aih doe: Kô ma ùh joq Jesus kon da Jôsep, bèn ma ùh qnì ka miq baq haq qmòh? Aih hagleq haq ma wìa ka doe: Au khoe loh enh plình? ");
INSERT INTO hrebt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chuaq Jesus doe: “Pì apaq mumùc ti dabau. ");
INSERT INTO hrebt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tàng joq Baq, aih Mangai ma khoe thê au, ùh aràng ka au, ùh i cabô jah trùh ti au, hì atìq èh au jah broq ka mangai aih rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Hset pajàu i achìh rameh: kô èh rìm ngai dìq jah tàng Boc Plình hnài. Mangai leq hi jah tàng bàu Baq rai hŏc tiaq dua haq, mangai aih èh trùh ti au. ");
INSERT INTO hrebt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ùh i mangai leq hmaq hnoq Baq, enh gùng ka mòeq ngai loh enh Baq, toq haq aih ma khoe hnoq Baq. ");
INSERT INTO hrebt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Joq qnàng au doe ka pì: waq toq mangai leq hi lùi, mangai aih hi jah kan rìh halình mòeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Au kô ƀênh kan rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Boc yaq pì acaq mana tanòe gùng hawit, èh dua khoe cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mahaq hacô ƀênh ma loh enh plình, waq toq cabô hi acaq ƀênh kô mangai aih ùh cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Au kô ƀênh kan rìh loh enh plình. Mangai leq hi acaq ƀênh kô hi jah kan rìh halình mòeq đòe. Ƀênh am dìq ka mangai đòeq wì hu jah kan rìh aih xech cla au kô raq.” ");
INSERT INTO hrebt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aih ìq dài baì mangai Juđa majah tarahen: Wìa ka mangai kô yŏc deh xech hu am ka bèn acaq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chuaq Jesus doe ka wì haq: “Joq qnàng, oq qnàng, au doe ka pì, tàng joq pì ùh acaq xech Kon Mangai, ùh ôq mahim haq, aih èh ta pì ùh i kan rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mangai leq acaq xech, ôq mahim au, aih èh jah kan rìh halình mòeq đòe, tahì pulùch au broq haq aih jah rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Majah qmang aih xech au kô dahwèq acaq joq qnàng, mahim au kô dahwèq ôq joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mangai leq acaq xech au ôq mahim au, mangai aih oe enh dalam ka au, au hadai oe enh dalam ka haq aih. ");
INSERT INTO hrebt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tìah ka Baq rìh halình, khoe thê au trùh, au hadai rìh xi Haq, hanoh qmang aih, mangai leq acaq xech au, hadai rìh xi au diq. ");
INSERT INTO hrebt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kô ƀênh loh enh plình. Ƀênh aih ùh xài qmang ka ƀênh mana kan cadraq pì ma khoe acaq, èh dua cachìt, mangai leq acaq ƀênh kô aih èh jah kan rìh halình mòeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Chuaq Jesus anoe bàu aih, jò haq hnài nòe hnim tagop qyoh ta Cabêna-um. ");
INSERT INTO hrebt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tàng bàu aih, bàc ngai tiaq hŏc doe: Bàu kô joq xa ka tàng, Cabô ma hlàt tamàng? ");
INSERT INTO hrebt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Loq ka bai mangai tiaq hŏc mumùc ka bàu kô, Chuaq Jesus doe ka wì haq: “Bàu kô broq ka manoh pì catoeh qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tàng joq pì hnoq Kon Mangai jah dèch atŏc tanòe haq ma oe dèh enh nèh, aih èh qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Aih ìq, yiang ma broq ka rìh, chac mac ùh i loh cleq. Dìq dŏng bàu au ma anoe ka pì aih dìq yiang xam kan rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mahaq taqne pì i mangai ùh lùi. Majah qmang aih enh jò baxèm raq, Chuaq Jesus khoe loq ka mangai ma ùh lùi, mangai leq ma blòq cađac haq. ");
INSERT INTO hrebt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Haq anoe hòm: “Aih ìq raq, au majah doe ka pì tàng joq Baq au ùh am, ùh i mangai leq jah trùh ti au.” ");
INSERT INTO hrebt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pang aih, bàc ngai tiaq hŏc talùi pi tiaq haq hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chuaq Jesus bòch wì mòeq jàt baiq ngai: “Aleq, pì ahìaq enh ta lùi diq?” ");
INSERT INTO hrebt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simôn Phiero doe: Chuaq! Nhèn tiaq đeh cabô? Ìh i bàu kan rìh halình mòeq đòe; ");
INSERT INTO hrebt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","nhèn khoe lùi, nhèn khoe loq Ìh raq Kon mòeq Hadròeh da Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chuaq Jesus doe: “Ajoq Au khoe ràih pì mòeq jàt baiq ngai? Mahaq moeq ngai aih kiac dù.” ");
INSERT INTO hrebt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Bàu aih, Haq anoe trùh Juđa, kon da Simôn I-cari-ot, majah qmang aih taqne wì mòeq jàt baiq ngai, haq aih mangai atìq kô èh ma blòq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Atìq ka aih, Chuaq Jesus lam dudan gùng Galili. Haq ùh enh lam tagùng Juđê, majah qmang aih mangai Juđa toq chaq trong hu jêh đac haq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mahaq hì Ramènh hla da mangai Juđa khoe ten trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wì oh Chuaq Jesus doe ka haq: Drah loh enh kô hu lam tagùng Juđa beq, đòeq mangai tiaq hŏc jah hnoq yiniq ìh broq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Jò enh ka mangai qnoeq loq ka rađeh, ùh i cabô cadoc deh yiniq broq ta nòe hlèp. Patep pang hì ìh ma broq ƀài bìac aih, drah lam paqnoh rađeh am ka phù cròng beq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Majah qmang aih wì oh haq hadai ùh lùi haq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aih ìq Chuaq Jesus majah doe ka wì haq: “Jò da au qnhòq troq, da pì jò leq ma ùh troq.” ");
INSERT INTO hrebt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wì phù cròng ùh i tagit ka pì, mahaq git ka au, majah qmang aih au anoe patô qnoh trong da wì haq broq aih trong dù. ");
INSERT INTO hrebt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pì tŏc hàu ramènh aih beq, au qnhòq tŏc ta ramènh aih majah qmang aih qnhòq troq jò da au. ");
INSERT INTO hrebt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Atìq ka anoe bàu aih, haq dua oe raq ta Galili. ");
INSERT INTO hrebt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hnoq anoe qmang aih, khoe ka wì oh haq lam hàu ramènh, haq hanoh lam, haq lam laiq ka hlèp, ùh dôq cabô loq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Oe tanòe ramènh, ƀòe gucraq Juđa ti rinh chaq Chuaq Jesus, wì bòch dabau: Taleq haq? ");
INSERT INTO hrebt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tanòe mangai bàc i bàu wì ta anoe ka dabau. Qnah ngai doe: Haq aih mangai lem, qnah ngai doe: Ùh! haq aih mangai toq ti qnùt wì phù cròng. ");
INSERT INTO hrebt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mahaq ùh i cabô hùa anoe hloh trùh Chuaq Jesus, majah qmang aih wì crè ka ƀài gucraq Juđa. Jesus hnài jò Ramènh ");
INSERT INTO hrebt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Qne ramènh, Chuaq Jesus tŏc hnài ta hnim kùh waiq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mangai Juđa ta aih dìq jaq hamàih wì bòch dabau: Mangai kô qnhòq lah hŏc, gleq haq majah rabiaq ka hset Hadròeh qmang meh? ");
INSERT INTO hrebt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chuaq Jesus doe: “Bàu au hnài ùh xài loh eh cla au, mahaq loh enh Mangai ma khoe thê au. ");
INSERT INTO hrebt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mangai leq broq tiaq manoh Boc Plình, aih èh hi canau bàu au ma hnài loh enh Boc Plình loq loh enh cla au. ");
INSERT INTO hrebt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mangai leq capoch tiaq deh manoh, aih haq chaq kan ranhòm toq ka dađeh, mahaq mangai leq broq ka Mangai ma thê dađeh jah ranhòm, aih mangai ma joq qnàng, tanòe haq ùh i yiniq cleq jùh jùn. ");
INSERT INTO hrebt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ma ùh joq Môise khoe am ka pì ranenh? I cabô leq taqne pì broq tiaq ranenh! Hagleq pì chaq trong hu jêh cađac au? ");
INSERT INTO hrebt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ƀài wì doe: Ìh qmat kiac khoe pawè, cabô ma chaq jêh đac ìh? ");
INSERT INTO hrebt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chuaq Jesus padreo bàu: “Au khoe broq mòeq yiniq, pì mangai leq mangai meh hamàih đeh hra. ");
INSERT INTO hrebt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Môise thê pì wèq ranenh kat akia (ranenh aih ùh i loh enh Môise, mahaq loh enh wì kan cadraq) pì broq ranenh aih ka mangai gucalô ta hì Sabat! ");
INSERT INTO hrebt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tàng joq mangai gucalô kat akia ta hì Sabat waq ka hatroq tiaq ranenh Môise, aih hagleq pì majah nòeh ka au jò au broq ka chac mangai yinìq jah brêh ta hì Sabat? ");
INSERT INTO hrebt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Apaq ngan toq enh gùng đòeq hu hadrah mangai qnoeq, mahaq ep hadrah tiaq trong ma taq toq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","I qnah ngai oe ta Jêrusalem doe: Meh raq ùh xài mangai wì ma chaq jêh cađac? ");
INSERT INTO hrebt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ngan meh haq ma i capoch rai amot, atàng i cabô tapoch mòeq nà bàu cleq ka haq. Ahìaq ƀài cwan khoe doe haq meh raq Christ joq qnàng? ");
INSERT INTO hrebt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mahaq mangai meh trùh enh leq bèn loq, Yàng jò Christ hi trùh, i cabô maloq haq trùh enh leq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jò aih Chuaq Jesus oe raq hnài tanòe hamlang hnim kùh waiq, Haq capoch qmòe cadêh: “Pì canau ka au, loq ka au trùh enh leq, ùh xài au trùh đeh ajang kô, mahaq Mangai ma khoe thê au aih joq qnàng. Pì ùh qnì ka haq, ");
INSERT INTO hrebt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","mahaq au loq ka haq, majah qmang aih au loh enh haq, haq khoe thê au”. ");
INSERT INTO hrebt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aih ìq raq, wì majah ti àu chaq trong rùp Chuaq Jesus, mahaq ùh i mòeq ngai leq hùa poh ta chac Jesus, majah qmang aih jò da haq qnhòq trùh; ");
INSERT INTO hrebt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","mahaq i bàc ngai lùi haq. Wì doe: Jò Christ trùh, haq i broq bàc trong halac ùh hnau ka mangai kô ùh? ");
INSERT INTO hrebt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mangai Pharisi tàng bàc ngai ta aih ta hatuàng trùh Chuaq Jesus ti dabau. Aih, wì haq hi mòeq manoh ka ƀài pajàu kàn wiang thê ƀài lình wèq hnim kùh waiq lam rùp haq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chuaq Jesus doe: “Au oe ti pì toq biaq hòm, khoe aih au hi hlài deh ta Mangai ma khoe thê au. ");
INSERT INTO hrebt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pì hi ti chaq au, mahaq ùh hnoq au, èh hòm tanòe au ma oe, ta aih pì trùh ùh jah”. ");
INSERT INTO hrebt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mangai Juđa doe ka dabau: Mangai kô enh lam taleq haq ma doe bèn chaq ùh hnoq haq? Ahìaq haq lam trùh ti ƀài mangai bèn ma haprah priang taqne mangai Gorec, đòeq hu hnài mangai Gorec qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Haq khoe doe: Pì ti chaq au, mahaq ùh glàm au, èh hòm tanòe au oe pì enh trùh ta aih ùh jah, bàu aih qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hì atìq pulùch, aih hi ma yeo nhet dìq dŏng ta hì ramènh, Chuaq Jesus yòng rai tapoch bàu dêh: “Mangai leq croh ranŏng, drah trùh ti au hu ôq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mangai leq lùi au, qmang ka bàu Hset Hadròeh khoe anoe: cròng diac kan rìh plôh loh qmòe enh dalam ka wì haq”. ");
INSERT INTO hrebt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Bàu aih, Haq anoe trùh Yiang Hadròeh mangai leq ma lùi haq atìq kô èh hi jah, jò aih qnhòq ùc qnoh Yiang Hadròeh, majah qmang aih Chuaq Jesus qnhòq jah ranhòm. ");
INSERT INTO hrebt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ta aih bàc ngai tàng, wì doe: Mangai kô pajàu joq qnàng. Mangai qnoeq doe: Qmat raq Christ. ");
INSERT INTO hrebt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mangai qmoeq hòm doe: Wìa ka Christ ma loh enh gùng Galili? ");
INSERT INTO hrebt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ma ùh joq hset Hadròeh doe: Christ ep loh enh nang noe Dawit, enh plài Bêtlehem aih plài da bùa qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Taiq ajang nòe Chuaq Jesus, wì haq majah talah đac dabau. ");
INSERT INTO hrebt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Qnah ngai enh rùp haq, mahaq ùh i cabô hùa hnho deh mòeq apah tì ta chac haq. ");
INSERT INTO hrebt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Qmang aih, ƀài lình tawìh hlài nòe ƀài pajàu kàn xam ƀài mangai Pharisi. Wì aih bòch: Hagleq pì ma ùh ahlài mangai aih tacô? ");
INSERT INTO hrebt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ƀài lình padreo bàu: Qnhòq lah i cabô capoch tìah ka mangai kô. ");
INSERT INTO hrebt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mangai Pharisi goh bàu ƀài aih: Ahìaq haq aih khoe padô hloe xam pì qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","I ka cwan leq, mangai Pharisi leq lùi haq aih ùh? ");
INSERT INTO hrebt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ùh! mahaq ƀài mangai bình qmòe ka calùh chàm joq ùh lòm loq qmòe ka ranenh cleq, joq jìang toq ra òh hamaiq! ");
INSERT INTO hrebt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicôđem (mangai adroe ka aih i trùh ti Chuaq Jesus, haq hanoh oe mòeq bua ti ƀài aih) doe: ");
INSERT INTO hrebt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ranenh da bèn ma rùp mangai leq bèn qnhòq bòch, qnhòq qnì ka yiniq haq aih broq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wì doe ka haq: Ìh kô ma hadai mangai Galili qmòh? Ìh ngan beq! ìh hi hnoq ùh lah i mangai pajàu leq ma loh enh gùng Galili. ");
INSERT INTO hrebt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Khoe aih, dìq ka wì hi hlài deh hra ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mahaq Chuaq Jesus tŏc ta bui wang Oliu. ");
INSERT INTO hrebt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bu qngah, haq wìh hlài ta hnim kùh waiq, dìq dŏng ka mangai ta aih trùh tapdan ka haq. Haq hangui hu hnài wì. ");
INSERT INTO hrebt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jò aih ƀài mangai hnài ranenh xam ƀài mangai Pharisi aràng trùh ka haq mòeq ngai cadrì wì jah rùp jò haq qnang tango. Wì thê haq yòng taqne mangai bàc ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Wì bòch Chuaq Jeus: Mangai hnài, mangai gucadrì kô nhèn rùp jò haq qnang tango, ");
INSERT INTO hrebt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ta ranenh da Môise thê bèn hachùq đac xam hmo mangai qmang kô, ha da ìh doe qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wì bòch qmang aih đòeq hu bahlac haq, đòeq chaq nen hu tah hadrah ka haq. Mahaq Chuaq Jesus kùp ta haqneq, yŏc hadrang tì achìh ta taneh. ");
INSERT INTO hrebt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jò wì xan bòch yôt, haq padinh yòng rai doe ka wì: “Dôq ka mangai leq taqne pì qmat tàng dađeh ùh hìaq i yiniq lui cleq, mangai aih yŏc hmo hachùq adroe beq” ");
INSERT INTO hrebt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Haq hi kùp achìh hòm ta taneh. ");
INSERT INTO hrebt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jò wì tàng qmang aih, wì hi lam, mangai craq lam adroe, trùh jò oe mòeq ngai Chuaq Jesus ta aih, xam mangai gucadrì oe raq yòng. ");
INSERT INTO hrebt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chuaq Jesus yòng bòch haq: “Mangai gucadrì meh, wì taleq hòm? Ùh i ca bô taqmòq ka ìh yiniq lui cleq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Haq padreo bàu: Waiq Chuaq, ùh i ka cabô. Chuaq Jesus doe: “Au hadai ùh taqmòq ka ìh yiniq lui, lam beq pi dùh broq yiniq hòm”. ");
INSERT INTO hrebt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chuaq Jesus doe hòm ka wì: “Au kô raq kan qngah ka crŏng taneh kô, mangai leq tiaq au, haq aih ùh hìaq lam ta kan clam, mahaq i kan qngah da kan rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mangai Pharisi rahen: Ìh yòng jang kô anoe cla rađeh, bàu aih ùh wìa ka lùi. ");
INSERT INTO hrebt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Chuaq Jesus doe: “Yac ka cla au anoe rađeh, bàu aih dua khòh lùi, majah qmang aih au loq đeh khoe trùh enh leq, loq đeh padon lam taleq. Mahaq pì ùh qnì ka au trùh enh leq, ùh qnì au lam taleq. ");
INSERT INTO hrebt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pì tah hadarh tiaq ranenh da kon mangai, au ùh tah hadrah ka cabô. ");
INSERT INTO hrebt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mahaq tàng joq au hadrah ka cabô, au hadrah troq joq qnàng, majah qmang aih au ùh i yòng đeh mòeq ngai, au yòng deh ti Baq ma khoe thê au. ");
INSERT INTO hrebt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tanòe ranenh pì khoe achìh: bàu baiq ngai wiang anoe patô, bàu aih joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Au panhìn ka rađeh, Baq ma khoe thê au trùh, hadai wiang anoe panhìn ti au”. ");
INSERT INTO hrebt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wì bòch haq: Aleq baq ìh? Chuaq Jesus doe: “Pì ùh canau ka au, ùh qnì ka Baq au, tàng joq pì khoe canau ka au, aih pì hadai khoe loq ka Baq au”. ");
INSERT INTO hrebt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Chuaq Jesus tapoch bàu kô jò yòng hnài tanòe hamlang hnim kùh waiq, haten ka nòe hnim don đòeq kùng hang ma dèch am ka hnim kùh waiq, ùh i mangai leq rùp haq majah qmang aih haq qnhòq trùh dèh jò. ");
INSERT INTO hrebt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Chuaq Jesus noe tam ka wì haq: “Au kô èh lam, pì ti chaq au, pì qmat èh cachìt dèh ta yiniq lui. Nòe Au lam pì ùh jah trùh”. ");
INSERT INTO hrebt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mangai Juđa anoe: Haq doe nòe au lam pì ùh jah trùh, qmang aih haq lam cachìt qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mahaq Chuaq Jesus tapoch hòm: “Pì qmat loh enh qneq, au loh enh qnhèq. Pì qmat da crŏng taneh kô, au ùh xài da crŏng taneh kô. ");
INSERT INTO hrebt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Au khoe doe pì cachìt dèh ta yiniq lui cla, tàng joq pì dua ùh lùi au kô raq, joq qnàng pì cachìt dèh ta yiniq lui cla”; ");
INSERT INTO hrebt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","wì bòch: Ìh qmat ìq cabô? Chuaq Jesus padreo bàu: “Qmang ka bàu au khoe doe ka pì enh baxèm raq, ");
INSERT INTO hrebt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Au i bàc trong anoe, bàc trong hu hadrah pì, mahaq Mangai khoe thê au trùh aih ma joq qnàng, au tàng cleq enh Haq, aih au hi anoe hlài ka crŏng taneh kô. ");
INSERT INTO hrebt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wì ùh qnì tàng aih haq anoe trùh dèh Baq. ");
INSERT INTO hrebt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aih ìq Chuaq Jesus majah doe: “Jò pì hi atua Kon Mangai, aih èh pi men loq au kô cabô, loq yac ka moeq yiniq cleq dua au ùh broq đeh, mahaq au anoe toq trong Baq khoe hnài au. ");
INSERT INTO hrebt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mangai khoe thê au trùh dua oe yôt ti au, qnhòq lah dôq au oe đeh mòeq ngai, majah qmang aih yac ka jò leq dua au broq lem manoh Haq”. ");
INSERT INTO hrebt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chuaq Jesus anoe qmang aih i bàc ngai lùi bàu haq. ");
INSERT INTO hrebt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chuaq Jesus doe ka mangai Juđa ma khoe lùi haq: “Tàng joq pì wèq bàu au hnài, aih pì joq mangai tiaq hŏc au; ");
INSERT INTO hrebt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","pì jah loq bàu joq qnàng, bàu joq qnàng jah lêh caqnaih pì”. ");
INSERT INTO hrebt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mangai Juđa doe: Nhèn kô nang noe Apraham, qnhòq lah broq dìc hapŏng cabô, gleq ìh ma doe: jah lêh caqnaih nhèn? ");
INSERT INTO hrebt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Chuaq Jesus doe ka wì: “Joq qnàng, joq qnàng au doe ka pì, mangai leq broq yiniq lui aih broq dìc yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","hapŏng dìc majah oe hloe ta hnim, mahaq toq Kon raq majah oe hloe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Qmang aih tàng joq Kon lêh caqnaih pì, aih pì joq khoe jah paclaih joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Au loq pì nang noe Apraham, mahaq pì toq chaq trong jêh cađac au, majah qmang aih bàu au ùh i nòe ta manoh cliac pì. ");
INSERT INTO hrebt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Au anoe yiniq au hnoq enh ngèa Baq au, pì broq trong pì top dua baq pì.” ");
INSERT INTO hrebt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wì doe: Apraham aih baq da nhèn, Chuaq Jesus doe: “Tàng joq pì kon Apraham, aih pì broq tiaq Apraham. ");
INSERT INTO hrebt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mahaq manòeq kô pì chaq trong jêh đac au, mangai ma khoe yŏc bàu joq qnàng enh Boc Plình đòeq anoe ka pì. Apraham ùh i broq qmang aih! ");
INSERT INTO hrebt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pì qmat broq yiniq baq pì broq.” Wì aih padreo bàu: Nhèn ùh xài kon tango, nhèn i mòeq ngai baq raq, aih Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chuaq Jesus doe: “Tàng joq Boc Plình aih baq pì, pì loq waq ka au, majah qmang aih au loh enh Boc Plình, au trùh enh Haq, au ma i trùh đeh tacô, Haq aih ma khoe thê au. ");
INSERT INTO hrebt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hagleq pì ma ùh qnì tàng bàu au? Aih ìq taiq pì ùh qnì trong da au. ");
INSERT INTO hrebt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Pì loh enh kan kiac aih kan cadraq da pì, pì enh broq gêh trong baq pì enh. Enh baxèm raq haq aih mangai jêh đac mangai, ùh cajap manoh wèq bàu joq qnàng, majah qmang aih ùh i ka bàu joq qnàng enh dalam ka haq. Jò haq amòng, haq capoch tiaq deh khoe hmòt, majah qmang aih haq mangai loq amòng broq baq mangai loq amòng. ");
INSERT INTO hrebt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mahaq pàng au anoe bàu joq qnàng, dài pì majah ùh lùi au. ");
INSERT INTO hrebt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Taqne pì qmat i cabô patô jah yiniq lui da au ùh?... Tàng au anoe bàu joq qnàng gleq pì ma ùh lùi au? ");
INSERT INTO hrebt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mangai da Boc Plình aih tàng bàu Boc Plình. Pì majah ùh tàng bàu Boc Plình, pàng pì ùh xài mangai da Boc Plình.” ");
INSERT INTO hrebt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mangai Juđa doe: Nhèn doe ìh qmat mangai Samari kan kiac khoe pawè, aih ma ùh troq? ");
INSERT INTO hrebt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Chuaq Jesus pa dreo bàu: “Au ùh xài mangai kiac pawè au, mahaq au ta iu Baq au, da pì aih enh poch qmèq ka au. ");
INSERT INTO hrebt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Au ùh chaq kan nhòm ka dađeh, mahaq i mòeq Mangai chaq, haq aih èh mangai hadrah. ");
INSERT INTO hrebt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Joq qnàng, joq qnàng au doe ka pì, mangai leq iu tiaq bàu au, haq aih èh ùh hnoq kan cachìt”. ");
INSERT INTO hrebt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mangai Juđa doe: Manoèq kô nhèn khoe loq joq qnàng, ìh qmat joq mangai kiac khoe pawè. Apraham khoe cachìt, dìq dŏng ƀài pajàu hadai, yàng ìh aih doe mangai leq iu tiaq bàu ìh ùh jò leq glàm kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ìh ma yeo kàn ùh hnau ka baq nhèn? Aih la Apraham mangai khoe cachìt. Ƀài pajàu hadai khoe cachìt, ìh qmat patìah đeh broq cabô? ");
INSERT INTO hrebt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chuaq Jesus padreo bàu: “Tàng joq au padèch kan ranhòm ka rađeh, kan ranhòm aih ùh loh cleq, Baq au, mangai pì doe deh Baq, aih mangai broq ka au jah kan ranhòm. ");
INSERT INTO hrebt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pì ùh qnì ka Haq, au loq ka Haq. Tàng au doe đeh ùh qnì ka Haq, aih au hadai loq qnùt tìah ka pì diq, mahaq au loq ka Haq rai broq tiaq bàu haq. ");
INSERT INTO hrebt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Baq pì aih Apraham, calah nèh haq tadèch qmòe qnòeh jò haq hnoq hì da au, khoe jah hnoq haq dìq jaq lem bùi.”. ");
INSERT INTO hrebt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wì tèu ka haq: Ìh qnhòq jah padam jàt hanam ìh ma khoe hnoq Apraham. ");
INSERT INTO hrebt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chuaq Jesus padreo bàu: “Joq qnàng, joq qnàng au doe ka pì, adroe ka i Apraham, khoe i au.” ");
INSERT INTO hrebt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jò aih wì toch hmo đòeq hibùq haq, mahaq Chuaq Jesus cadoc dađeh loh hnim kùh waiq, lam taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Chuaq Jesus bu lam ti trong, hnoq mòeq ngai lua qmòe enh jò baxèm ha-uang. ");
INSERT INTO hrebt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mangai tiaq hŏc bòch: Rabi, cabô ma khoe i yiniq lui, cla haq loq miq baq haq, hagleq haq bu ha-uang ma khoe lua qmang qmat? ");
INSERT INTO hrebt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chuaq Jesus doe: “Qmat ùh xài claq haq hadai ùh xài miq baq haq khoe i yiniq lui, mahaq qmat đòeq yiniq Boc Plình broq jah paqnoh ajang haq. ");
INSERT INTO hrebt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Jò oe raq qngah da hì, au ep broq gêh ka yiniq Mangai ma khoe thê au trùh, jò trŏc clam ùh i cabô oe jah broq cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Jò au oe raq ta crŏng taneh, au raq kan qngah ka crŏng taneh.” ");
INSERT INTO hrebt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Khoe ka capoch bàu aih, haq cachôh ta taneh, jràu diac hai ta blo dôq haq wìa tràp, èh haq xùt ta mat mangai lua aih. ");
INSERT INTO hrebt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Khoe haq doe: “Lam beq, lam ta bau diac Siloê đòeq hu qnheo (Siloê aih la Jah thê)”; haq hi lam trùh ta bau aih, qnheo, khoe èh wìh hlài, hi jah xau hnoq qmòe lem lech. ");
INSERT INTO hrebt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wì plài mangai lua aih xam ƀài mangai nèh haq hmaq hnoq mangai lua kô rìh ka axìn, wì doe: Ùih! kô ajoq mangai xan hangui axìn ùh xài? ");
INSERT INTO hrebt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Qnah ngai doe: hi loq haq qmat raq! Mangai qnoeq doe: Ùh xài, mangai tah hatìah ka haq. Mahaq cla haq doe lam doe hlài: Hi loq ka au kô raq! ");
INSERT INTO hrebt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wì bòch: Hagleq mat gè khoe jah tapèch? ");
INSERT INTO hrebt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Haq tèu bàu: Mangai yiniq haq Jesus leo tràp xùt ta mat au. Haq thê au lam ta bau diac Siloê hu qnheo. Au hi lam qnheo, manòeq au khoe jah xau hnoq. ");
INSERT INTO hrebt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wì bòch haq: Taleq mangai aih? Haq doe: au ùh qnì. ");
INSERT INTO hrebt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Wì qnong mangai neh haq ma lua mat trùh ajang ngèa mangai Pharisi. ");
INSERT INTO hrebt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hì Jesus ma leo tràp broq ka mangai lua mat jah brêh aih, wop hì Sabat. ");
INSERT INTO hrebt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mangai Pharisi bòch hòm hagleq haq ma khoe jah xau hnoq. Haq doe: Mangai aih xùt tràp ta mat au, au lam qnheo khoe hi jah hnoq. ");
INSERT INTO hrebt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Qnah ngai Pharisi doe: Mangai kô ùh xài loh enh Boc Plình, hacô haq ùh wèq hì Sabat. Mahaq mangai qnoeq hòm doe: Mangai i yiniq lui majah broq kan halac qmang qmat? Pi tahatroq, wì hi loh ka talah ka dabau. ");
INSERT INTO hrebt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Khoe aih wì haq tawìh hlài ajang mangai lua, wì bòch: Manòeq kô mangai ma khoe broq ka ìh jah xau hnoq qmat ìh doe qmang leq? Mangai aih padreo bàu: Haq aih mangai pajàu. ");
INSERT INTO hrebt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mahaq mangai Juđa ùh lùi haq aih nèh lua mat yàng manòeq khoe jah hnoq, trùh wì ma hi creo ka miq baq haq. ");
INSERT INTO hrebt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Wì àu bòch: Kô ajoq kon calô chôp ma xan doe haq lua qmòe enh jò ha-uang nèh raq? Òq hagleq manòeq haq majah xau hnoq? ");
INSERT INTO hrebt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wa miq baq haq doe: Ma canau haq qmat joq kon ma, lua qmòe enh jò ha-uang nèh raq, ");
INSERT INTO hrebt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","yàng manòeq kô hagleq haq jah xau hnoq, ma hadai ùh loq, ma hanoh ùh qnì ka cabô khoe pèch da haq mat. Bòch cla haq, haq khoe kàn, cla haq doe đeh. ");
INSERT INTO hrebt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Miq baq haq majah anoe qmang aih, wa haq crè ka ƀài gucraqJuđa, wì aih khoe doe waq toq cabô doe Jesus aih raq Mêsia, mangai aih èh wì hnan qnoh đac enh gùng ka hnim tagop qyoh. ");
INSERT INTO hrebt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Aih wa miq baq haq majah doe: Haq khoe troq hanam, bòch cla haq. ");
INSERT INTO hrebt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mangai Pharaisi creo ka mangai nèh haq lua mat aih tam mòeq yàng hòm, wì doe: Drah manè apôi Boc Plình beq, nhèn loq mangai aih i yiniq lui; ");
INSERT INTO hrebt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","mangai aih doe: au ùh qnì mangai aih i yiniq lui loq ùh, au loq mòeq yiniq, nèh au lua mahaq manòeq au jah qngah. ");
INSERT INTO hrebt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wì bòch hòm: Haq khoe broq ka gè cleq, haq pèch da gè mat qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Haq padreo bàu: au khoe doe ka pì, pì ùh ta màng. Gleq pì majah enh tàng hòm? Ahìaq pì enh broq mangai tiaq hŏc haq aih diq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wì hnap hnuq ka haq rai doe: Gè qmat òq mangai tiaq hŏc haq, nhèn kô mangai tiaq hŏc Môise. ");
INSERT INTO hrebt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nhèn loq Boc Plình khoe doe ka Môise, mahaq mangai kô nhèn ùh qnì qmòe ka haq loh enh leq. ");
INSERT INTO hrebt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Haq aih padreo bàu: Mangai aih khoe pèch da au mat, aih pì doe ùh qnì haq loh enh leq, aih joq ma halac! ");
INSERT INTO hrebt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bèn loq Boc Plình malah tamàng bàu mangai i yiniq lui, mahaq tàng cabô loq yùq iu bàu Boc Plình, broq tiaq manoh Haq, bàu mangai aih Haq tamàng. ");
INSERT INTO hrebt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","I cabô lah tàng doe i mangai pèh mat mangai lua qmòe enh qyoh. ");
INSERT INTO hrebt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tàng joq mangai kô ùh loh enh Boc Plình, haq ùh broq cleq majah. ");
INSERT INTO hrebt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wì tèu haq: Gè qmat catàm ta yiniq lui enh jò ha-uang nèh raq, broq deh hnài nhèn! khoe aih wì hnan qnoh haq enh gùng. ");
INSERT INTO hrebt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chuaq Jesus tàng doe wì khoe hnan qnoh cađac mangai aih loh enh gùng, jò hnoq mangai aih, haq doe: “Ìh alùi Kon Mangai?” ");
INSERT INTO hrebt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mangai aih bòch: Wì Craq! anoe ka au loq haq aih cabô, đòeq au hu lùi. ");
INSERT INTO hrebt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Chuaq Jesus doe: “Manòeq kô ìh khoe hnoq haq, joq qnàng, hacô haq mangai qnang hatuàng ti ìh.” ");
INSERT INTO hrebt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mangai aih doe: Waiq Chuaq! au lùi ìh. ");
INSERT INTO hrebt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chuaq Jesus doe: “Au khoe trùh ta crŏng taneh đoèq broq kan tah hadrah qmang kô: mangai ùh xau èh jah hnoq, mangai hnoq èh loh ka ùh xau.” ");
INSERT INTO hrebt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mangai Pharisi ma yòng ti haq tàng anoe qmang aih, wì bòch: Ìh doe cleq? Nhèn ma hadai lua mat? ");
INSERT INTO hrebt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chuaq Jesus doe: “Tàng joq pì hadai lua, aih pì ùh ka yiniq lui cleq, mahaq manòeq pì doe đeh qngah, dài aih raq yiniq lui pì majah oe.”. ");
INSERT INTO hrebt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Joq qnàng qnàng au doe ka pì mangai, mangai leq thia ta cadrong trìu ma ùh mùt trong qmang, mahaq heo trong qnoeq, aih mangai atùng. ");
INSERT INTO hrebt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mangai leq mùt ti trong qmang, aih majoq mangai ban trìu. ");
INSERT INTO hrebt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mangai gòm qmang pèh ka haq qmang, trìu tàng dèh bàu mangai ban, haq creo yiniq dèh trìu hu tiaq qnoh enh gùng. ");
INSERT INTO hrebt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jò haq khoe qnoh trìu loh dìq enh gùng, cla haq lam adroe, trìu lam atìq, majah qmang aih trìu canau ka bàu haq. ");
INSERT INTO hrebt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mahaq ùh jò leq trìu tiaq mangai ùh canau, majoq qnàng aih trìu loh ka cadàu amot, majah qmang aih haq ùh canau ka bàu mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Chuaq Jesus alìah bàu aih, mahaq ƀài mangai Pharisi ùh qnì tàng haq anoe cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aih ìq Chuaq Jesus majah anoe hòm: “Joq qnàng au anoe ka pì, au kô raq qmang trìu. ");
INSERT INTO hrebt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ƀài mangai trùh adroe ka au dìq ƀài mangai atùng, mahaq trìu ùh tamàng bàu wì aih. ");
INSERT INTO hrebt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Au kô raq qmang, mangai leq mùt jang au mangai aih jah dèch. Wì haq jah mùt loh, jah glàm nhat. ");
INSERT INTO hrebt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mangai atùng trùh đòeq toq hu atùng, jêh rai palùng đac. Mahaq au khoe trùh đòeq trìu jah rìh, rai jah kan rìh tàu tìa. ");
INSERT INTO hrebt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Au kô raq mangai ban trìu khun rabiaq, mangai ban khun rabiaq haq cađac qmòe rađeh dôq trìu jah kan rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mangai ban acaq baha aih ùh xài mangai ban joq qnàng, trìu hadai ùh xài trìu haq, tàng haq hnoq koq gùng trùh, haq cađac trìu hu cadàu claih toq ka dađeh. Koq gùng blah yŏc trìu rai broq ka trìu haprah priang. ");
INSERT INTO hrebt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mangai ban baha cadàu toq ka dađeh, haq ùh i hèm trùh trìu. ");
INSERT INTO hrebt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Au kô raq mangai ban khun rabiaq, au loq deh ka trìu, èh trìu au hadai loq ka au. ");
INSERT INTO hrebt_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tìah ka Baq loq ka au, au loq ka Baq – Au cađac rađeh am ka trìu. ");
INSERT INTO hrebt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Au oe raq i calùh trìu qnoeq ùh xài ta cadrong kô; au ep tiaq ahlài haq. Trìu aih èh hadai jah tàng bàu au, jah wìa mòeq calùh, èh mòeq ngai ban raq. ");
INSERT INTO hrebt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Hagleq Ƀaq majah loq waq au, aih au phùq deh kan rìh đòeq hu jah yŏc hlài. ");
INSERT INTO hrebt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ùh i cabô doeh yŏc da au kan rìh, mahaq cla au phùq đeh, au i cwìang cađac deh kan rìh hadai i cwìang yŏc hlài. Ƀaq khoe thê qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mangai Juđa tàng bàu aih, wì loh qmòe ka talah ka dabau. ");
INSERT INTO hrebt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Qnah ngai doe: Haq qmat kiac pawè haq khoe loh ka rawè, tamàng dèh ka bàu haq? ");
INSERT INTO hrebt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Qnah ngai doe: Bàu kô ùh xài bàu mangai kiac khoe caqnit don. Kiac wìa ka jah pèh mat mangai ùh xau? ");
INSERT INTO hrebt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Trùh hì Ramènh dèch hnim kùh waiq ta Jêrusalem. Aih troq jò ralìm, ");
INSERT INTO hrebt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Chuaq Jesus oe ta hamlang hnim kùh waiq, haq ti dauq roc canhiang qmang Salomôn. ");
INSERT INTO hrebt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mangai Juđa ti dudan ka haq rai bòch: Ìh đòeq nhèn rangòt yôt qmang kô trùh jò leq? Tàng joq ìh kô raq Mêsia, anoe ka nhèn ma hloh haq. ");
INSERT INTO hrebt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Chuaq Jesus padreo bàu: “Au khoe doe ka pì, mahaq pì ùh lùi. Ƀài yiniq au broq enh dalam ka yiniq Baq au, khoe wiang panhìn ka au; ");
INSERT INTO hrebt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","mahaq pì ùh lùi, majah qmang aih pì ùh xài trìu au. ");
INSERT INTO hrebt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Trìu da au tamàng bàu au, Au loq ka wì haq, wì haq tiaq au. ");
INSERT INTO hrebt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Au am ka wì haq kan rìh halình mòeq đòe, wì haq ùh jò leq cachìt, ùh i cabô jah hrùiq yŏc wì haq enh tì au. ");
INSERT INTO hrebt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baq au Mangai ma khoe am trìu aih ka au, Haq yeo kàn dìq dŏng. Ùh i cabô jah hrùiq yŏc wì haq enh tì Baq au. ");
INSERT INTO hrebt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Au xam Baq aih mòeq raq. ");
INSERT INTO hrebt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mangai Juđa tŏch hmo hu hibùq haq hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Chuaq Jesus doe: “Au khoe broq ka pì hnoq bàc yiniq lem loh enh Baq. Yiniq cleq pì majah tŏch hmo hu đàp au.” ");
INSERT INTO hrebt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","wì doe: Ùh xài ìh broq lem nhèn majah đàp ìh, mahaq taiq ìh capoch haqnhèq bàu ùh hòq qmòe cleq, ìh qmat xài mangai, aih ìh ma doe rađeh Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Chuaq Jesus padreo bàu: Ta Hset ranenh pì ùh xài i achìh: Au khoe creo ka pì aih yiang qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tàng Hset Ranenh creo ka ƀài mangai jah bàu Boc Plình aih yiang, tàng joq bàu Hset Hadròeh ùh jah cađac, ");
INSERT INTO hrebt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ha mangai Baq ma khoe đòeq dèh crài, khoe thê loh ta crŏng taneh kô? Hagleq pì majah doe au haqnhèq bàu jò au doe au kon Boc Plình.” ");
INSERT INTO hrebt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Apaq lùi, tàng joq au ùh broq yiniq Baq broq. ");
INSERT INTO hrebt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mahaq tàng au broq, yac ka pì ùh lùi au, pì lùi ƀài yiniq au broq, aih pì hi canau loq Baq oe enh dalam ka au, au hadai oe enh dalam ka Baq.” ");
INSERT INTO hrebt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wì àu rùp haq hòm, mahaq haq wia cađac. ");
INSERT INTO hrebt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Khoe aih Chuaq Jesus wìh hlài apah tau cròng diac Jôđan, trùh ta nòe Jon ma baxèm broq baptem nèh. Haq oe ta aih, ");
INSERT INTO hrebt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","bàc ngai trùh ta haq. Wì doe: Yac ka Jon qnhòq hmaq broq cleq ma halac, mahaq rìm nà Jon anoe trùh mangai kô aih dìq wop dŏng. ");
INSERT INTO hrebt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ta aih, i bàc ngai lùi Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","I mòeq ngai ùh hrŏc yiniq haq Laxaru, oe ta Bêthani, plài Mari xam Mathê daq haq. ");
INSERT INTO hrebt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari aih mangai ma khoe xùt dàu xua thùm ka Chuaq Jesus, rai yŏc deh xàc gàu xùt jènh Jesus, daq haq Laxaru qnang ùh hrŏc. ");
INSERT INTO hrebt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Wa thê mangai lam patìn ka Chuaq Jesus: Waiq Chuaq! Mangai ìh ma loq waq khoe ùh hrŏc. ");
INSERT INTO hrebt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jò Chuaq Jesus tàng qmang aih, haq doe: “Yinìq kô ùh i ma doe cachìt, mahaq đòeq ka Boc Plình jah kan ranhòm, aih èh yiniq Kon haq hadai jah qngah qngai”. ");
INSERT INTO hrebt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Chuaq Jesus loq waq ka Mathê, loq waq ka oh haq xam Laxaru. ");
INSERT INTO hrebt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jò Haq tàng doe Laxaru ùh hrŏc, haq oe tam ta aih baiq hì. ");
INSERT INTO hrebt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Khoe aih haq doe ka mangai tiaq hŏc: “Beq bèn wìh hlài ta Juđê”. ");
INSERT INTO hrebt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mangai tiaq hŏc doe: Rabi! Neo ta adreo kô nèh, mangai Juđa kô yŏc hmo hu hacam đàp ìh, ìh oe wìh hlài ta aih hòm qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Chuaq Jesus padreo bàu: “Dahì ma ùh xài i mòeq jàt baiq jò qmòh? Mangai cadiang lam jò dahì aih ùh catoeh, majah qmang aih kan qngah ta crŏng taneh kô broq ka haq xau hnoq. ");
INSERT INTO hrebt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mahaq tàng cabô cadiang lam jò damang, haq catoeh majah qmang aih haq ùh i ka kan qngah”. ");
INSERT INTO hrebt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Atìq ka anoe bàu kô, Chuaq Jesus doe: “Laxaru bua bèn qnang kùi, mahaq au trùh ta aih hu padrìu haq.” ");
INSERT INTO hrebt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mangai tiaq hŏc doe: Tàng joq haq jah kùi, aih èh haq rênh brêh. ");
INSERT INTO hrebt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Chuaq Jesus anoe bàu aih hu doe Laxaru khoe cachìt mahaq mangai tiaq hŏc xoh đeh haq kùi joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Haq hi anoe hloh hloe ka wì: “Laxaru khoe cachìt”. ");
INSERT INTO hrebt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Au lem bùi am ka pì, ùh i ka au ta aih, đòeq pì hu lùi, beq bèn lam ta haq.” ");
INSERT INTO hrebt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Khoe aih Thôma (Qnah ngai creo Đi đim) doe: Beq bèn hanoh lam, hu cachìt pajùm ti haq.” ");
INSERT INTO hrebt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jò trùh ta aih, Chuaq Jesus loq Laxaru oe ta ralùng khoe jah pôn hì. ");
INSERT INTO hrebt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Adreo Bêthani trùh Jêrusalem bu mòeq jàt padam êtađo. ");
INSERT INTO hrebt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","I bàc ngai Juđa trùh ta aih hu alòng Mathê xam Mari jò daq wa khoe pi i. ");
INSERT INTO hrebt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jò Mathê tàng doe i Chuaq Jesus trùh, haq tùh loh, mahaq Mari oe raq ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mathê doe: Waiq Chuaq! Tàng i ìh tacô, daq au ùh cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mahaq manòeq kô au loq, ìh bòch cleq dua Boc Plình am. ");
INSERT INTO hrebt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Chuaq Jesus doe ka haq “Daq ìh jah rìh hlài.” ");
INSERT INTO hrebt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mathê padreo bàu: Au loq trùh jò mangai cachìt rìh hlài hì atìq pulùch èh, haq jah rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Chuaq Jesus doe ka haq: “Au kô raq kan rìh xam kan rìh hlài. Mangai leq lùi au haq aih jah rìh hlài, yac ka haq khoe cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Èh hòm, mangai oe rìh lùi au, haq aih ùh cachìt. ìh alùi qmang aih?” ");
INSERT INTO hrebt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mathê padreo bàu: Waiq Chuaq, au lùi ìh kô raq Christ, Kon calô Boc Plình, Mangai đòeq trùh ta crŏng taneh kô. ");
INSERT INTO hrebt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Khoe ka doe qmang aih, haq hlài chop anoe deh ka Mari oh haq: Mangai hnài qnang oe tacô, haq creo chaq oh. ");
INSERT INTO hrebt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jò Mari tàng qmang aih, haq drah yòng lam trùh ta Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jò kô Jesus qnhòq mùt taplài, oe raq yòng tanòe Mathê ma loh đìh haq. ");
INSERT INTO hrebt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mangai Juđa qnang oe ta hnim ti Mari đòeq alòng haq, jò hnoq haq loh lam, wì drah tiaq haq majah qmang aih wì hèm canau haq loh hmoe ta ralùng. ");
INSERT INTO hrebt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jò Mari trùh ajang nòe Chuaq Jesus yòng, bu hnoq Haq, Mary hacùn cràng nòe jènh Chuaq Jesus rai anoe: Waiq Chuaq! Tàng joq ìh oe tacô, daq au ùh i cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jò Chuaq Jesus hnoq Mary hmoe, èh hnoq ƀòe mangai Juđa ma lam tiaq haq hanoh hmoe, Chuaq Jesus tamèt ta manoh, haq bòch: “Pì catùh hanang haq taleq?” ");
INSERT INTO hrebt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dìq ka wì doe: Waiq Chuaq! Ìh lam hu ngan. ");
INSERT INTO hrebt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chuaq Jesus hmoe. ");
INSERT INTO hrebt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mangai Juđa ta anoe: Ngan meh! Kan haq loq waq ka Laxaru qnì dàng leq. ");
INSERT INTO hrebt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mahaq i qnah ngai doe: Mangai khoe jah pèch mat mangai lua, laiq ma hadai broq mangai kô ùh cachìt qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jò aih, Chuaq Jesus haq jìq tam ta manoh, haq lam trùh ta ralùng (Ralùng aih kòp i mòeq toq hmo kàn padit ajang ngah). ");
INSERT INTO hrebt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Haq doe: “Cadro hmo qmat lam taqnoeq”. Mathê oh mangai cachìt aih doe: Waiq Chuaq! manòeq kô khoe xua, majah qmang aih haq oe ta ralùng khoe pôn hì. ");
INSERT INTO hrebt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Chuaq Jesus doe hòm: “Au ma qnhòq lah doe ka ìh tàng joq ìh lùi, ìh hi jah hnoq kan ranhòm Boc plình?” ");
INSERT INTO hrebt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Qmang aih, wì hi cadro đac hmo. Khoe aih Chuaq Jesus qngoc ngan ta plình rai doe: “Baq, au manè apôi ìh khoe tamàng bàu au, ");
INSERT INTO hrebt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","au loq yac ka jò leq dua Ìh tamàng bàu au, mahaq au majah anoe qmang aih dôq wì ma yòng dudan tacô jah tàng, đòeq ka wì haq jah loq Ìh khoe thê au trùh”. ");
INSERT INTO hrebt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Khoe ka anoe qmang aih, haq creo cadêh “Laxaru! loh beq”. ");
INSERT INTO hrebt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mangai cachìt hi cadiang loh, bai lòm hanang oe raq kàt da haq jènh tì, mù oe raq tù da haq hadrò. Chuaq Jesus doe ka wì: “Lêh dŏng bai qmat, dôq haq jah lam”. ");
INSERT INTO hrebt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bàc ngai Juđa ma trùh đòeq hu alòng Mari hnoq yiniq Chuaq Jesus broq, wì hi lùi haq. ");
INSERT INTO hrebt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mahaq i qnah ngai lam chaq ƀài mangai Pharisi anoe ka wì aih loq yiniq Chuaq Jesus khoe broq. ");
INSERT INTO hrebt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ƀòe pajàu kàn xam mangai Pharisi tagop ti dabau ta hnim hadrah, wì doe: Mangai kô broq bàc kan halac, bèn broq qmang leq kô èh? ");
INSERT INTO hrebt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tàng joq bèn xan dôq haq broq yôt qmang kô, trùh wì ma lùi dŏng haq, jò aih èh hnim kùh waiq xam taneh diac bèn, mangai Rôma trùh tacô raliang đac dŏng. ");
INSERT INTO hrebt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Khoe aih i mòeq ngai yiniq haq Caiphe, hanam aih haq broq cla craq pajàu kàn, haq doe: Pì ùh lòm qnì qmòe cleq! ");
INSERT INTO hrebt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Pì ùh hèm tàng mòeq ngai cachìt am dìq dŏng ka mangai aih ajoq yeo lem ùh hnau dìq ka taneh diac kô lùng pac dŏng. ");
INSERT INTO hrebt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Bàu aih ùh xài cla haq anoe đeh, mahaq hanam aih haq broq cla craq pajàu kàn, haq tapoch pajàu trùh Chuaq Jesus padon cachìt am dìq dŏng ka mangai, ");
INSERT INTO hrebt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","èh ùh xài toq ka taneh diac aih mahaq xam dìq dŏng ka kon Boc plình ma khoe prah priang, đòeq hu tagop ahlài wì haq dôq wì haq wìa mòeq. ");
INSERT INTO hrebt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pang hì aih wì hi chaq trong jêh cađac haq. ");
INSERT INTO hrebt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dài aih ìq, Chuaq Jesus lam ta gùng Juđa, mahaq pi am bàc ngai loq, Chuaq Jesus cađac ta aih haq lam mùt tagùng haten ka đùng hawit, trùh ta plài Epra-im haq hi oe ta aih dèh ti ƀòe mangai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hì ramènh Pan cwa da mangai Juđa ten trùh, bàc ngai tŏc ta Jerusalem adroe ka hì ramènh basròeh. ");
INSERT INTO hrebt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wì haq ti chaq Chuaq Jesus, oe ta hnim kùh waiq wì haq bòch dabau: Pì hèm qmang leq cadèh? Haq aih ma ùh tŏc hàu ta hì ramènh kô qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mahaq ƀài pajàu kàn xam mangai Pharisi khoe tanap bàu waq toq cabô hnoq Chuaq Jesus oe taleq, mangai aih ep lam anoe ka wì haq loq đòeq wì haq hu rùp Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tadràu hì adroe ka ramènh Pancwa, Chuaq Jesus mùt ta plài Bêthani, aih nòe Laxaru, mangai Chuaq Jesus khoe broq haq rìh hlài enh kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Wì padon yiniang ka Chuaq Jesus acaq ta aih, Mathê ti patìh, Laxaru hadai hangui ti wì ma acaq pajùm aniang ti haq. ");
INSERT INTO hrebt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari yŏc qne lit dàu xua thùm canaq bac, haq pùc dàu aih ta jènh Chuaq Jesus èh yŏc deh xàc gàu xùt da haq jènh. Ta hnim aih bìn dŏng kan xua thùm. ");
INSERT INTO hrebt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mahaq i mòeq ngai tiaq hŏc, yiniq haq Juđa, mangai atìq kô èh ma blòq Chauq Jesus, haq doe: ");
INSERT INTO hrebt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Hagleq ma ùh tech dàu kô hu yŏc ƀac đòeq am ka mangai pa? Dàu qmat mòeq hanam abroq men plàih. ");
INSERT INTO hrebt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Haq anoe qmang aih ùh xài haq loq hèm trùh mangai pa, mahaq haq aih mangai loq atùng, haq mangai wèq bac jèn xan bŏc yŏc atùng ƀac wì tah ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chuaq Jesus doe: “Paq troq dèh ka haq, haq khoe palauq dàu qmat đòeq trùh hì hu lòm hanang au. ");
INSERT INTO hrebt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Jò leq ma ùh i ka mangai pa oe dudan ti pì, mahaq au ma i oe yôt ti pì”. ");
INSERT INTO hrebt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jò aih haraya mangai Juđa loq ka Chauq Jesus oe ta aih, wì trùh ùh xài đòeq hnoq toq Chuaq Jesus, mahaq hu ngan hloe xam Laxaru, mangai Chuaq Jesus khoe broq rìh hlài enh kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ƀài mangai pajàu kàn hadai chaq trong jêh cađac hloe xam Laxaru. ");
INSERT INTO hrebt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ajang Laxaru aih raq majah i bàc ngai Juđa rai trùh rai lùi Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Hì atìq, pi cajaq mangai tŏc hàu Ramènh Pancwa, tàng doe Chuaq Jesus qnang tŏc ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wì hlêh hla triaq, tùh loh ta Chuaq Jesus rai cachech: Hôsana! Xôq ramot am ka mangai trùh enh dalam yiniq Chuaq. Xôq ramot ka bùa Isorali! ");
INSERT INTO hrebt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Chuaq Jesus hnoq mòeq toq lùa qyoh, Haq tŏc hangui enh crŏng lùa aih, qmang ka bàu khoe achìh: ");
INSERT INTO hrebt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kon adrùh Siôn! Apaq crè, Ngan meh, bùa pì qnang trùh, Hangui enh crŏng lùa qyoh.” ");
INSERT INTO hrebt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jò baxèm aih, mangai tiaq hŏc ùh qnì ƀài bìac kô. Trùh atìq ka jò Chuaq Jesus khoe jah ranhòm wì haq men hmàng hlài ƀài bàu aih khoe achìh trùh haq, wì broq qmang aih dôq xìt ka bàu aih gêh. ");
INSERT INTO hrebt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bài mangai ma oe ti Chuaq Jesus jò haq creo ka Laxaru loh enh ralùng rai broq ka haq rìh hlài, hadai ùh hêq ka anoe yôt bìac aih. ");
INSERT INTO hrebt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bàc ngai khoe tàng doe Chuaq Jesus broq trong halac kô, aih ìq ƀài wì majah loh đìh Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mangai Pharisi ta anoe ka da bau: Pì ahnoq rađeh ùh broq cleq jah, ngan tau, dìq ka phù cròng tiaq dŏng haq! ");
INSERT INTO hrebt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jò wì ma tŏc kùh waiq ta hì Ramènh, ta aih i mangai Gorec, ");
INSERT INTO hrebt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","trùh ajang Philip mangai Bet-saiđa gùng Galili, wì haq doe: wì craq! nhèn enh hnoq đeh Chuaq Jesus! ");
INSERT INTO hrebt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip lam doe ka Anrê, Anrê xam Philip lam anoe ka Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chuaq Jesus padreo bàu: “Jò Kon Mangai jah kan ranhòm khoe trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Joq qnàng, joq qnàng au anoe ka pì, tàng joq pliang adrech qmau tau ùh cachìt, atìq ka jò haq khoe jah rai ta taneh aih èh haq oe moe dèh qmang aih raq. Mahaq tàng joq haq cachìt, aih èh haq men jah loh qmòe ka bàc. ");
INSERT INTO hrebt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mangai leq loq waq dèh toq kan rìh cla, aih èh hnhung, mangai leq git deh kan rìh cla ta qnhòng kô, haq aih èh jah wèq hlài dèh trùh ta qnhòng rìh halình mòeq đòe. ");
INSERT INTO hrebt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mangai leq patìh ka au, ep tiaq au, èh au oe taleq mangai patìh hadai ep oe ta aih, tàng cabô patìh ka au, Baq au ta-iu ka mangai aih… ");
INSERT INTO hrebt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Manòeq kô mahua yiang au ma nhài ùh catèm, au anoe cleq kô èh? Waiq Baq! dèch kon khoe ka jò kô! mahaq taiq jò kô raq kon majah khoe trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baq! broq ka cla yiniq Ìh jah qngah qngai.” Wop jò aih, i bàu enh plình doe: Au khoe broq qngah qngai yiniq au, au oe raq broq dôq qngah qngai hòm! ");
INSERT INTO hrebt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wì ma oe ta aih tàng bàu aih wì doe: Trŏc hilùng, i qnah ngai doe: I ƀình plình loh hatuàng ka haq. ");
INSERT INTO hrebt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chuaq Jesus doe: “Bàu kô ùh xài am ka au, mahaq đòeq am ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Manòeq kô i kan hadrah ka crŏng taneh kô, hanoh manòeq kô raq bùa crŏng taneh kô ep drùh qnoh đac. ");
INSERT INTO hrebt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yàng da au kô hòm, jò chac au jah dèch atua khoe ka taneh, aih èh au hi aràng dìq ka mangai trùh ti au”. ");
INSERT INTO hrebt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Haq doe bàu kô đòeq hu anoe rađeh cachìt qmang leq. ");
INSERT INTO hrebt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ƀài mangai ta aih doe: Nhèn i hŏc ta hset ranenh doe Christ rìh mòeq đòe, wìa ka ìh doe: Kon Mangai ep dèch atua haqnhèq? Kon mangai aih ìq cabô? ");
INSERT INTO hrebt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chuaq Jesus padreo bàu: “Kan qngah oe taqne pì toq biaq hòm, cadiang lam jò oe raq i kan qngah, adroe ka kan clam trùh enh qnhèq ka pì. Mangai cadiang lam ta clam ùh qnì ka rađeh qnang lam taleq. ");
INSERT INTO hrebt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pì qnang i kan qngah, drah lùi kan qngah aih, dôq pì wìa kon da kan qngah”. Jò khoe hêq ka capoch qmang aih, Chuaq Jesus puplech hangai ka wì. ");
INSERT INTO hrebt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yac ka Chuaq Jesus khoe broq bàc trong halac enh ngèa wì, dua wì ùh lùi haq. ");
INSERT INTO hrebt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Qmang aih dôq xìt qmang ka bàu pajàu Êsai khoe doe: Chuaq! cabô ma khoe lùi bàu nhèn anoe Tì Chuaq khoe paqnoh am ka cabô? ");
INSERT INTO hrebt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Wì majah ùh lùi, taiq ajang qnoeq Êsai i doe: ");
INSERT INTO hrebt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Haq khoe broq ka mat wì ùh xau hnoq, manoh wì cadoq, Yùq mat wì loq hnoq, manoh wì loq tàng, Wì haq wìh hlài, èh au loq broq wì haq jah brêh qmòh! ");
INSERT INTO hrebt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Êsai capoch bàu kô, haq anoe trùh Chuaq Jesus majah qmang aih haq khoe hnoq kan ranhòm Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hnoq anoe qmang aih, jò aih taqne ƀài cwan ma broq gàu i bàc ngai lùi Chuaq Jesus, mahaq wì haq ùh hùa anoe qnoh, majah qmang aih wì crè ka ƀài mangai Pharisi loq hnan qnoh wì haq enh gùng ka hnim tagop. ");
INSERT INTO hrebt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aih ìq, wì haq enh waq kan ranhòm da kon mangai ùh hnau kan ranhòm da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Khoe aih, Chuaq Jesus tapoch qmòe cadêh: “Cabô lùi au ùh xài lùi mòeq ngai au, mahaq lùi Mangai ma khoe thê au; ");
INSERT INTO hrebt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","mangai leq hnoq au, aih hnoq Mangai thê au. ");
INSERT INTO hrebt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Au khoe trùh đòeq hu broq kan qngah ta crŏng taneh, dôq ka mangai leq lùi au pi hìaq oe raq ta kan clam cluiq hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tàng mangai leq tamàng bàu au, mahaq ùh wèq tiaq bàu aih, au ùh i tahadrah ka haq aih, majah qmang aih au trùh ùh xài hu hadrah crŏng taneh kô, mahaq hu dèch crŏng taneh kô. ");
INSERT INTO hrebt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Khoe i kan hadrah ka mangai leq ma cwaih cađac au, ùh dì yŏc bàu au, bàu au khoe capoch, bàu aih raq ma hadrah wì haq ta hì pulùch. ");
INSERT INTO hrebt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Majah qmang aih dìq ka bàu au anoe, ùh xài au anoe tiaq deh manoh cla, mahaq Baq khoe thê au trùh. Haq khoe am bàu đòeq au hu anoe hu hnài. ");
INSERT INTO hrebt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Au loq bàu Haq thê, aih kan rìh halình mòeq đòe. Qmang aih, bàu au anoe, aih anoe tiaq bàu Baq au khoe thê”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Adroe ka hì ramènh Pancwa, Chuaq Jesus loq khoe ten trùh jò rađeh padon cađac crŏng taneh đòeq hu hlài deh ti Baq, haq khoe loq waq deh ka mangai da haq oe ta crŏng taneh kô aih haq loq waq trùh lùch trùh gêh. ");
INSERT INTO hrebt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Qnang jò acaq di xèq, kan kiac baxrùq manoh Juđa icariôt, kon Simôn đòeq haq blòq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Chuaq Jesus loq Baq khoe jao ta tì dađeh rìm yiniq, majah qmang aih haq khoe trùh enh Boc Plình, manòeq padon wìh hlài ta Boc Plình, ");
INSERT INTO hrebt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jò acaq, haq padinh yòng, lêh deh eo enh gùng, yŏc mù kàt ajang caqnam. ");
INSERT INTO hrebt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Èh haq ùc diac ta khai hi qnheo jènh mangai tiaq hŏc, khoe aih haq yŏc mù ma kàt ti caqnam hi xùt waq ka srênh. ");
INSERT INTO hrebt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Haq trùh ajang Simôn Phiero, Phiero doe: Chuaq au! Wìa ka ìh qnheo jènh au qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Chuaq Jesus padreo bàu: “Manòeq kô ìh qnhòq qnì trong au ma qnang broq, mahaq atìq èh ìh hi loq”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Phiero doe: Ùh đòh! ùh jò leq au dôq ìh qnheo da au jènh. Chuaq Jesus doe: “Tàng joq au ùh qnheo jènh ìh, aih èh ìh ùh i pajùm cleq ti au”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simôn padreo bàu: Chuaq au! Tàng qmang aih, ùh xài toq qnheo jènh, ìh qnheo hloe xam tì xam gàu au diq. ");
INSERT INTO hrebt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Chuaq Jesus doe: “Mangai khoe hùm, qnheo toq jènh raq hi hreo, pì khoe jah hreo, mahaq ùh xài rìm ngai”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Majah qmang aih Chuaq Jesus loq cabô ma padon blòq haq, dài haq majah doe: “Ùh xài rìm ngai khoe jah hreo”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jò qnheo da wì jènh hi khoe, Chuaq Jesus caxùnh dèh eo, lam hangui hlài dèh anòe acaq, haq bòch wì: “Pì aloq yiniq au ma neo broq am ka pì qmat? ");
INSERT INTO hrebt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pì doe au: Mangai hnài, creo au Chuaq pì, aih troq, au joq qmang aih, ");
INSERT INTO hrebt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","tàng au Chuaq pì, mangai hnài pì, khoe qnheo jènh pì, qmang aih pì hadai ep qnheo jènh da bau. ");
INSERT INTO hrebt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Majah qmang aih, au khoe broq dua đòeq pì hnoq, dôq pì hadai broq qmang ka au khoe broq ka pì.” ");
INSERT INTO hrebt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Joq qnàng, joq qnàng au doe ka pì, hapŏng ùh yeo kàn hnau cla wì craq, mangai loh lam ùh yeo kàn hnau ka mangai thê lam. ");
INSERT INTO hrebt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tàng pì loq ƀài yiniq kô rai broq tiaq aih èh pì jah xôq ramot. ");
INSERT INTO hrebt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Au ùh i anoe ka pì rìm ngai, au loq dèh mangai leq au khoe ràih, mahaq waq ka jah xìt qmang ka bàu Hset Hadròeh: Mangai hmaq acaq bênh au, dèch lùn jènh blòq au. ");
INSERT INTO hrebt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Manòeq kô au chônh anoe adroe ka pì jò ƀài yiniq aih qnhòq trùh, đòeq jò yiniq aih trùh, pì hu jah loq au kô raq Mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Joq qnàng, joq qnàng au anoe ka pì, cabô đìh mangai au thê, aih đìh au, cabô đìh au aih đìh Mangai thê au”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Atìq ka anoe bàu aih, Chuaq Jesus manhài ùh catèm ta manoh, Haq doe: “Joq qnàng, joq qnàng au doe ka pì, taqne pì i mòeq ngai padon blòq au”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mangai tiaq hŏc ti ngan dabau, ùh qnì qmòe haq ràu trùh cabô. ");
INSERT INTO hrebt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Taqne mangai tiaq hŏc i mòeq ngai Chuaq Jesus ma loq waq, jò aih haq hangui hatìa ka Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simôn Phiero kùh gàu ka haq thê haq aih bòch ngan Chuaq Jesus enh anoe trùh cabô. ");
INSERT INTO hrebt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Haq chinh rađeh angèn ajang rada Chuaq, haq hi bòch: Chuaq au! aih ìq cabô? ");
INSERT INTO hrebt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Chuaq Jesus padreo bàu “Aih mangai au padon am ka haq haqnech ƀênh au khoe chùq diac kô”. Èh Chuaq Jesus yŏc mòeq haqnech ƀênh chùq ta diac khoe aih am ka Juđa, kon da Simôn Icariôt. ");
INSERT INTO hrebt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Draq drình hloe jò Juđa hnhu tì yŏc ƀênh, Satan mùt enh dalam ka haq. Chuaq Jesus doe ka haq: “Ìh broq deh cleq, drah broq beq”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mahaq dìq ka wì hangui acaq ta aih, ùh i mangai leq qnì hagleq Chuaq Jesus majah thê haq qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Majah qmang aih Juđa mangai wèq bac, qnah ngai hèm Chuaq thê haq lam rot dahwèq palauq đòeq ka hì ramènh, tàng ùh meh yŏc bac ti am ka mangai pa. ");
INSERT INTO hrebt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Juđa yŏc ƀênh hi loh lam. Jò aih trŏc khoe clam. ");
INSERT INTO hrebt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jò Juđa khoe lam, Chuaq Jesus doe: “Manòeq kô khoe trùh jò Kon Mangai jah ranhòm, Boc Plình hadai jah kan ranhòm enh dalam ka haq. ");
INSERT INTO hrebt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tàng joq Boc Plình ranhòm enh dalam ka haq, aih èh Boc plình hadai dèch kan ranhòm ka Kon Mangai enh dalam cla Boc Plình, Boc Plình broq qmòe manòeq kô raq. ");
INSERT INTO hrebt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yôiq yôiq wì kon! Au oe tam ti pì toq biaq hòm, kô èh pì ti chaq au, tìah ka au anoe ka mangai Juđa: Nòe au lam pì lam ùh jah, manòeq au hadai anoe ka pì bàu aih. ");
INSERT INTO hrebt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Au am ka pì ranenh neo: aih pì ep loq waq ka dabau! tìah ka au khoe loq waq ka pì qmang leq, pì hadai loq waq ka dabau qmang aih”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tàng joq pì loq waq ka dabau, ajang aih èh wì phù cròng ma canau pì joq qnàng mangai tiaq hŏc da au”. ");
INSERT INTO hrebt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simôn doe: Chuaq au! Ìh lam taleq? ChuaqJesus padreo bàu: Nòe au lam, manòeq ìh tiaq ùh jah, mahaq hì atìq èh ìh ma tiaq au”: ");
INSERT INTO hrebt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Phiero bòch: Chuaq au! Hagleq manòeq au ma ùh jah tiaq ìh? Au hùa tamùa hu tiaq Ìh. ");
INSERT INTO hrebt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chuaq Jesus padreo bàu: “Ajoq ìh hùa tamùa hu tiaq au? Joq qnàng, joq qnàng, au doe ka ìh jò ia qnhòq rŏng ìh khoe piq yàng hangah đeh ùh qnì ka au”. ");
INSERT INTO hrebt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Manoh pì ùh dùh manhài dèh, pì lùi Boc Plình, pì hadai ep lùi au. ");
INSERT INTO hrebt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Hnim Baq au i bàc nòe oe, tàng ùh qmang aih, ajoq au khoe doe ka pì au lam adroe đòeq padon ka pì mòeq nòe oe? ");
INSERT INTO hrebt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jò au khoe lam padon ka pì nòe, aih èh au wìh hlài đòeq hu aràng pì oe ti au, dôq au taleq pì hadai oe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Pì loq au lam taleq, pì hadai loq trong lam. ");
INSERT INTO hrebt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thôma bòch Chuaq Jesus: Chuaq au! nhèn ùh qnì ìh lam taleq, aih broq qmang leq nhèn ma loq ka trong lam? ");
INSERT INTO hrebt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chuaq Jesus padreo bàu: “Au kô raq trong lam, bàu joq qnàng xam kan rìh”. Enh gùng ka au ùh i cabô jah trùh ti Baq. ");
INSERT INTO hrebt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tàng joq pì loq ka au, pì hadai loq ka Baq au. Pang kô ta èh pì loq ka Haq, pì hadai khoe hnoq haq. ");
INSERT INTO hrebt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip doe: Chuaq au! Ìh patô am ka nhèn hnoq đeh Baq diq, toq aih raq khoe hêq. ");
INSERT INTO hrebt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Chuaq Jesus padreo bàu: “Philip, au oe ti pì khoe dùnh, pì qnhòq qnì ka au! Cabô khoe hnoq au aih khoe hnoq Baq. Gleq ìh majah doe: Patô am nhèn jah hnoq đeh Baq?”: ");
INSERT INTO hrebt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ìh ma ùh lùi au oe enh dalam ka Baq, Baq oe enh dalam ka au qmòh? Dìq ka bàu au anoe ka pì, aih ùh xài cla au capoch đeh mahaq aih Baq rìh enh dalam ka au, cla Haq abroq gêh dèh bìac da haq. ");
INSERT INTO hrebt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jò au doe au oe ti Baq, Baq oe enh dalam ka au, pì drah lùi au, ùh meh lùi ƀài yiniq au khoe broq. ");
INSERT INTO hrebt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Joq qnàng au doe ka pì, cabô lùi au, hadai jah broq yiniq au ma broq èh broq kàn ùh hnau ka aih hòm, majah qmang aih au hlài dèh ta Baq. ");
INSERT INTO hrebt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pì canòm ka yiniq au đòeq bòch cleq, dua au am ka pì, waq ka Baq jah kan ranhòm ajang Kon. ");
INSERT INTO hrebt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pì canòm ka yiniq au yac ka bòch cleq, dua au broq am ka pì”. ");
INSERT INTO hrebt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Tàng joq pì loq waq ka au, aih pì wèq bàu au khoe thê. ");
INSERT INTO hrebt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","I au bòch Baq dôq haq am ka pì Yiang alòng maqnoeq đòeq hu oe hloe ti pì, ");
INSERT INTO hrebt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","aih Yiang bàu joq qnàng. Crŏng taneh kô ùh jah yŏc haq, majah qmang aih wì ùh xau hnoq haq, wì hadai ùh qnì ka haq. Mahaq pì loq ka haq, majah qmang aih haq rìh ti pì, oe enh dalam ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Au ùh cađac pì tìah lac lai. Au trùh ti pì; ");
INSERT INTO hrebt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","oe toq biaq hòm, mangai oe crŏng taneh kô pi jah hnoq au, mahaq pì jah hnoq au, majah qmang aih au rìh pì hadai jah rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Hì aih, pì hi canau au oe enh dalam ka Baq au, pì oe enh dalam ka au, au oe enh dalam ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mangai leq i ranenh au rai wèq tiaq, aih mangai ma loq waq ka au. Mangai leq ma loq waq ka au, Baq au hadai loq waq chau ka haq aih, au hanoh loq waq ka haq rai patô rađeh ka wì haq. ");
INSERT INTO hrebt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Juđa, (ùh xài Ica-riot) doe: Chuaq au! Hagleq ìh majah doe ìh mahnu rađeh am ka nhèn mahaq ùh mahnu rađeh ka mangai crŏng taneh kô? ");
INSERT INTO hrebt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Chuaq Jesus padreo bàu: “Mangai leq loq waq ka au, mangai aih iu bàu au hnài. Baq au loq waq ka haq aih, dìq ka nhèn trùh rai oe ti haq. ");
INSERT INTO hrebt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mangai leq ùh loq waq ka au, mangai aih ùh tiaq bàu au hnài. Dìq ka bàu pì tàng aih ùh xài bàu cla au, mahaq loh enh Baq, haq aih mangai ma thê au trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Dìq ka ƀài yiniq aih au khoe anoe jò au oe raq oe ti pì. ");
INSERT INTO hrebt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mahaq jò Yiang alòng, aih la Yiang Hadròeh, Baq canòm ka yiniq au đòeq thê trùh. Haq aih èh jah hnài pì rìm trong, bahmàng pì hmàng hlài rìm yiniq au anoe ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Au đòeq ka pì kan catèm, au am ka pì kan catèm da au, kan catèm au am ka pì ùh xài qmang da crŏng taneh am. Manoh pì apaq rawè hadai apaq yùq. ");
INSERT INTO hrebt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Pì khoe tàng au doe: Au padon lam hangai khoe aih au tawìh hlài ta pì. Tàng pì loq waq ka au, aih èh pì lem bùi jò au hlài deh ta Baq, majah qmang aih Baq yeo kàn ka au. ");
INSERT INTO hrebt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Manòeq kô au chônh anoe am ka pì, adroe ka ƀài yiniq aih trùh, đòeq jò ƀài yiniq aih trùh pì hu lùi. ");
INSERT INTO hrebt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Au pi anoe ka pì cleq bàc hòm, majah qmang aih bùa da crŏng taneh kô qnang padon trùh. Haq aih ùh i cwìang cleq enh qnhèq ka au; ");
INSERT INTO hrebt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mahaq đòeq ka crŏng taneh kô loq au loq waq deh ka Baq, au broq troq tiaq bàu Baq au thê. Drah yòng! beq bèn loh khoe enh kô.” ");
INSERT INTO hrebt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Au kô raq rangàu nho joq qnàng, Baq au Mangai pìt. ");
INSERT INTO hrebt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hamenh leq ta au ma ùh loh plì, Haq sri dŏng, Haq trêh palauq bài hamenh ma loh plì dôq plì top ùh hnau hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pì khoe jah sròeh canòm ka bàu au khoe doe ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pì ep oe yôt enh dalam au tìah ka au hadai oe enh dalam ka pì. Tìah ka hamenh nho tàng joq haq ùh hatop ajang rangàu tùn nho, aih haq ùh loh plì, hadai qmang aih tàng joq pì ùh oe yôt enh dalam ka au, pì hadai ùh loh plì. ");
INSERT INTO hrebt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Au kô raq tùn nho, pì aih hamenh. Mangai leq oe yôt enh dalam ka au, au oe enh dalam ka haq aih èh loh plì ma bàc, majah qmang aih enh gùng ka au, pì ùh i broq cleq jah. ");
INSERT INTO hrebt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tàng joq mangai leq ùh oe yôt enh dalam ka au, haq aih èh ep khwênh qnoh cađac enh gùng, tìah ka hamenh nho, hamenh hi croh, wì toch khwênh ta ùnh haq hi cheo. ");
INSERT INTO hrebt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tàng pì oe yôt enh dalam ka au èh bàu au hadai oe yôt enh dalam ka pì, bòch beq yiniq cleq pì enh aih pì hi jah. ");
INSERT INTO hrebt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ạjang kô ma broq ka yiniq Baq au jah qngah: Aih pì loh plì bàc, qmang aih èh mangai tiaq hŏc da au. ");
INSERT INTO hrebt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tìah ka Baq khoe loq waq ka au qmang leq, au hadai loq waq ka pì qmang aih. Manòeq kô thê pì oe hloe ta kan loq waq au. ");
INSERT INTO hrebt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tàng pì wèq ranenh au thê, aih pì jah oe hloe ta kan loq waq da au, tìah ka au wèq deh ranenh Baq au thê, au hanoh jah oe yôt ti kan loq waq Haq. ");
INSERT INTO hrebt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Au anoe ka pì ƀài yiniq kô, đòeq kan lem bùi da au jah oe enh dalam ka pì, dôq kan lem bùi pì jah tôm xrôm. ");
INSERT INTO hrebt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kô ranenh au thê: Pì loq waq ka dabau qmang ka au khoe loq waq ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ùh i kan loq waq leq ma yeo kàn ùh hnau kan loq waq chìuq cachìt am deh ka bua. ");
INSERT INTO hrebt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tàng joq pì broq tiaq bàu au hnài, aih pì joq bua au. ");
INSERT INTO hrebt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Au pi creo pì hapŏng hòm, majah qmang aih hapŏng ùh qnì wì craq broq cleq, mahaq au khoe doe pì kô bua au, majah qmang aih au khoe anoe ka pì loq rìm yiniq au tàng deh enh Baq au. ");
INSERT INTO hrebt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aih ùh xài pì khoe ràih au, mahaq au ma khoe ràih rai dèch paqnàng pì, đòeq pì loh lam, dôq plì da pì jah top hloe, èh Baq hadai am tam ka pì rìm trong pì canòm ka yiniq au đòeq bòch Haq. ");
INSERT INTO hrebt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kô ranenh au thê: Pì ep loq waq ka dabau. ");
INSERT INTO hrebt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Tàng wì phù cròng tagit ka pì, aih pì loq wì khoe git ka au adroe ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tàng pì mòeq bua ka crŏng taneh kô, aih èh crŏng taneh kô loq waq deh ka bua, mahaq au khoe ràih pì taqne crŏng taneh kô pì ùh mòeq bua ka wì haq, aih ìq dài crŏng taneh kô majah git ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ep hmàng bàu au khoe anoe ka pì: Hapŏng ùh yeo kàn ùh hnau ka cla wì craq, tàng wì khoe rùp pani baxa au, wì hadai rùp pani baxa pì. Tàng wì iu bàu au hnài aih èh wì hadai iu bàu pì hnài. ");
INSERT INTO hrebt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mahaq taiq yiniq au, wì yŏc ƀài trong aih hu baxa pì, majah qmang aih wì qnì ka Mangai khoe thê au trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tàng joq au ùh trùh hu hnài wì haq, aih wì haq ùh i ka yiniq lui cleq, mahaq manoèq kô wì haq pi jah aclai dèh yiniq lui hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Cabô git ka au hadai git ka Baq au. ");
INSERT INTO hrebt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tàng joq au ùh broq taqne wì haq trong qnhòq hmaq i cabô broq, aih wì haq ùh i ka yiniq lui cleq, mahaq manoèq wì haq khoe hnoq, mahaq dua wì haq git ka au xam Baq au. ");
INSERT INTO hrebt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mahaq ajang kô aih dôq xìt qmang ka bàu khoe achìh ta hset ranenh wì haq: Wì git ka au ùh i qmòe ka yiniq. ");
INSERT INTO hrebt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jò Yiang alòng hi trùh, aih Yiang enh Baq, au thê haq trùh ta pì, aih Yiang da bàu joq qnàng loh enh Baq, Haq aih èh ma yòng anoe panhìn am ka au; ");
INSERT INTO hrebt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","xam ƀài pì, hadai yòng anoe panhìn am ka au, majah qmang aih pì khoe oe qmòe ti au enh jò baxèm. ");
INSERT INTO hrebt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Au khoe anoe ka pì dìq ka ƀài yiniq kô, dôq pì ùh hìaq catoeh cro. ");
INSERT INTO hrebt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wì hnan qnoh cađac pì loh enh gùng ka hnim tagop qyoh, ma joq qnàng tangèa kô èh jò wì jêh cađac pì, aih cla wì xoh dèh wì qnang dèch ramènh patìh ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wì majah broq qmang aih, taiq wì ùh qnì ka Baq, wì hadai ùh canau ka au. ");
INSERT INTO hrebt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Au khoe doe ka pì ƀài yiniq kô, đòeq trùh jò da wì, pì jah hmàng hlài au khoe anoe ka pì. Enh baxèm au ùh doe ka pì ƀài yiniq kô majah qmang aih au oe raq oe ti pì. ");
INSERT INTO hrebt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Manòeq kô au padon hlài dèh ta Mangai khoe thê au trùh, pì ùh i cabô leq bòch au: Ìh padon lam taleq? ");
INSERT INTO hrebt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mahaq au anoe ƀài yiniq kô ta manoh pì bình bauq kan mangò. ");
INSERT INTO hrebt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mahaq au doe qnàng ka pì: Au lam aih troq ka pì. Tàng au ùh lam, Yiang alòng ùh trùh ta pì, mahaq tàng au lam, au jah thê Haq trùh ta pì. ");
INSERT INTO hrebt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jò Haq trùh, haq broq ka crŏng taneh kô canau deh kan yiniq lui, kan taq toq xam kan hadrah; ");
INSERT INTO hrebt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","kan yiniq lui aih taiq wì haq ùh lùi au, ");
INSERT INTO hrebt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kan taq toq, aih taiq au hlài dèh ta Baq, aih èh pì pi hnoq au hòm, ");
INSERT INTO hrebt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","kan hadrah, aih taiq bùa crŏng taneh kô khoe pòq kan hadrah. ");
INSERT INTO hrebt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Au oe i bàc yiniq hu anoe ka pì, mahaq ƀài yiniq aih manòeq kô padren pì qnhòq hlàt wê. ");
INSERT INTO hrebt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mahaq jò Yiang da Bàu joq qnàng hi trùh, Haq aih èh ma hu ajèn qmùt pì tarìm bàu joq qnàng, majah qmang aih Haq ùh capoch đeh, mahaq anoe yiniq haq ma khoe tàng, rai anoe am ka pì loq ƀài yiniq padon trùh ta ngèa kô èh. ");
INSERT INTO hrebt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Haq aih èh ma paqngah Yiniq au, majah qmang aih Haq yŏc ƀài yiniq enh au đòeq hu anoe am ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dìq rìm yiniq Baq i, aih jah au, dài au majah doe: Haq yŏc ƀài yiniq enh au đòeq hu anoe am ka pì loq. ");
INSERT INTO hrebt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Chuaq Jesus anoe hòm: “Oe toq ƀiaq hòm pì pi hnoq au, khoe ka aih toq biaq pì hi jah hnoq au”. ");
INSERT INTO hrebt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jò aih, i toq ƀiaq ngai tiaq hŏc hatuàng ka dabau: Oe toq ƀiaq hòm pì pi hnoq au, khoe ka aih toq biaq, pì hi jah hnoq hlài au, aih haq doe: Au hlài dèh ta Baq. Qmang aih ìq qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mangai tiaq hŏc tabòch yôt dabau: Oe toq ƀiaq hòm aih ìq haq doe cleq? Bèn ùh qnì tàng qmòe haq anoe cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus hnoq wì enh bòch, Haq doe ka wì: “Ajoq pì bòch dabau au anoe cleq jò au doe: Oe toq ƀiaq hòm pì pi hnoq au hòm, èh khoe ka aih toq ƀiaq pì hi jah hnoq hlài au? ");
INSERT INTO hrebt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Joq qnàng, joq qnàng au doe ka pì, kô èh pì jah crò hmoe, wì crŏng taneh jah lem bùi, pì jah kan mangò mahaq kan mangò da pì jah wìh wìa kan bùi lem. ");
INSERT INTO hrebt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mangai gucadrì jò hauang aih jìq pi cajaq, majah qmang aih khoe trùh dèh jò, yàng jò kon khoe jah clìh enh cliac, haq pi hmàng dèh kan jìq hòm, toq lem bùi jò hnoq đeh khoe jah hauang qnoh mòeq ngai ta crŏng taneh kô. ");
INSERT INTO hrebt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Qmang ka pì manòeq kô qnang mangò, mahaq au jah hnoq hlài pì, jò aih pì hi lem bùi, ùh i cabô jah qnung yŏc da pì kan lem bùi aih. ");
INSERT INTO hrebt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Hì aih èh pì pi oe bòch au cleq hòm. Joq qnàng, joq qnàng au doe ka pì, enh dalam ka yiniq au pì bòch cleq dua Baq am ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Trùh manoèq kô pì qnhòq canòm ka yiniq au đòeq hu bòch cleq. Bòch beq aih pì hi jah, dôq kan lem bùi pì jah gêh geo. ");
INSERT INTO hrebt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Au khoe alìah ka pì ƀài yiniq aih. Kô èh au pi yŏc bàu alìah đòeq anoe ka pì hòm, mahaq au capoch hloh dôq pì loq ka Baq. ");
INSERT INTO hrebt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Hì aih èh, pì hi yŏc yiniq au đòeq hu bòch. Au ùh i doe au bòch am ka pì. ");
INSERT INTO hrebt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ùh! Cla Baq raq ma loq waq ka pì, majah qmang aih pì khoe loq waq ka au rai lùi au trùh enh Baq. ");
INSERT INTO hrebt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Au khoe loh enh Baq đòeq trùh ta crŏng taneh, manòeq kô au cađac crŏng taneh kô đòeq hu hlài dèh ta Baq. ");
INSERT INTO hrebt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mangai tiaq hŏc doe: Manòeq kô ìh khoe capoch hloh, pi hìaq capoch alìah hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Manòeq kô nhèn loq ìh loq rìm trong, ùh ep ka cabô bòch ìh, ajang aih nhèn loq ìh loh enh Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chuaq Jesus doe “Ajoq manòeq kô pì khoe lùi? ");
INSERT INTO hrebt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Khoe ten trùh jò, majoq qnàng aih khoe trùh, aih jò dìq ka pì mangai haprah hapriang đeh hra, cađac au oe đeh mòeq ngai, mahaq au ùh oe đeh mòeq ngai, majah qmang aih Baq oe ti au. ");
INSERT INTO hrebt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Au khoe anoe ka pì qmang aih dôq manoh pì jah kan catèm ta au. Pì glàm bàc kan ranàc kàn ta crŏng taneh kô, mahaq cajap manoh oq, au khoe blêq crŏng taneh kô.” ");
INSERT INTO hrebt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Atìq ka anoe bàu kô, Chuaq Jesus qngoc ngan ta plình rai waiq khàn: “Baq! khoe trùh jò, ìh broq dôq on jah kan ranhòm, đòeq kon hadai jah dèch kan ranhòm ka baq; ");
INSERT INTO hrebt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ma jah qmang aih baq khoe am ka kon cwìang enh qnhèq dìq dŏng ka rìm ngai, đòeq Kon jah am kan rìh halình mòeq đòeq ka mangai ìh ma khoe am ka kon. ");
INSERT INTO hrebt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Manòeq kô, kan rìh halình mòeq đòeq aih ìq: Canau ka Baq rai loq toq ìh raq Boc Plình joq qnàng, xam Jesus Christ mangai ìh khoe thê trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kon khoe dèch kan ranhòm ka baq ta crŏng taneh, broq gêh trong baq thê broq. ");
INSERT INTO hrebt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Manòeq kô Baq! Ìh broq ka kon jah ranhòm enh ngèa ka ìh xi kan ranhòm kon khoe i qmòe anòe ìh, adroe ka jò i crŏng taneh. ");
INSERT INTO hrebt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kon khoe paqnoh yiniq ìh am ka ƀài mangai ìh ma khoe am ka kon taqne crŏng taneh kô, wì haq mangai da Baq, ìh khoe am ka kon, wì haq khoe wèq bàu ìh. ");
INSERT INTO hrebt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Manòeq kô, wì haq khoe loq rìm yiniq ìh am ka kon aih dìq trùh enh Baq. ");
INSERT INTO hrebt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Majah qmang aih, au khoe am hlài ka wì bàu baq ma am ka kon, wì haq khoe wèq yŏc bàu aih. Wì haq loq joq qnàng Baq khoe thê kon trùh. ");
INSERT INTO hrebt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kon waiq khàn ka wì haq, ùh xài waiq khàn ka crŏng taneh kô, mahaq waiq khàn ka mangai baq khoe am ka kon, majah qmang aih wì haq mangai da ìh. ");
INSERT INTO hrebt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Rìm yiniq da kon i aih da Baq, rìm yiniq da baq i aih da kon. Èh ajang wì haq kon jah kan ranhòm. ");
INSERT INTO hrebt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kon pi oe dùnh ta crŏng taneh kô hòm, mahaq wì haq oe raq ta crŏngtaneh kô, kô èh kon bròc ta baq. Baq Hadròeh, ìh wèq wì haq ta yiniq cwìang i tai da ìh, yiniq ìh ma khoe am ka kon, dôq wì haq wìa mòeq tìah ka bèn aih mòeq. ");
INSERT INTO hrebt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jò kon oe raq ti wì haq, kon khoe wèq wì haq jah catèm ta yiniq baq, aih yiniq ìh am ka kon. Enh gùng ka mòeq ngai kon da kan lùng pac, ta qne wì haq ùh hnhung mòeq ngai, dôq bàu Hset Hadròeh jah xìt. ");
INSERT INTO hrebt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Manòeq kon hlài ta baq, mahaq kon anoe ƀài bàu kô jò kon oe raq ta crŏng taneh, dôq ta manoh cliac wì haq jah bình kan lem bùi da kon ");
INSERT INTO hrebt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Au khoe am ka wì haq bàu Ìh, crŏng taneh kô tagit ka wì haq, majah qmang aih wì haq pi xài mangai da crŏng taneh kô tìah ka kon hadai ùh xài mangai da crŏng taneh kô. ");
INSERT INTO hrebt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kon ùh waiq ìh dèch wì haq loh khoe crŏng taneh kô mahaq waiq Baq wèq wì haq khoe ka mangai dù. ");
INSERT INTO hrebt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wì haq ùh oe xài mangai da crŏng taneh qmang troeq kon hadai ùh xài mangai da crŏng taneh kô. ");
INSERT INTO hrebt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Waiq Baq yŏc bàu joq qnàng broq wì haq jah hadròeh, bàu ìh aih bàu joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Qmang ka Ìh khoe thê kon ta crŏng taneh kô, au hadai thê wì haq ta crŏng taneh kô. ");
INSERT INTO hrebt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Taiq wì haq kon majah broq rađeh hadròeh, đòeq wì haq hadai canòm ka bàu joq qnàng hu jah wìh wìa hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ùh xài kon waiq khàn am toq ka wì haq, mahaq waiq khàn hloe ka ƀài mangai ma lùi kon jò tàng bàu wì haq anoe, ");
INSERT INTO hrebt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","dôq rìm ngai jah wìa mòeq, tìah ka Baq oe enh dalam ka kon èh kon hadai oe enh dalam ka Baq, đòeq wì haq hadai oe enh dalam ka bèn, waq ka crŏng taneh kô lùi cla Baq khoe thê kon. ");
INSERT INTO hrebt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kon khoe am ka wì haq kan ranhòm Baq ma khoe am ka kon, đòeq wì hadai pajùm broq mòeq tìah ka bèn kô dua mòeq raq: ");
INSERT INTO hrebt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kon oe enh dalam ka wì, Baq oe enh dalam ka kon, qmang aih wì jah wìa mòeq gêh geo ti dabau. Aih èh crŏng taneh kô hu jah ngan loq ih thê au, au hadai khoe loq waq ka wì haq tìah ka ìh khoe loq waq ka au. ");
INSERT INTO hrebt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baq! Kon enh cla kon oe taleq ƀài mangai ìh khoe am ka kon hadai jah oe ti kon ta aih, đòeq wì haq jah ngan hnoq kan ranhòm da kon, aih kan ranhòm Baq khoe am ka kon, majah qmang aih Baq khoe loq waq ka kon adroe ka broq loh crŏng taneh. ");
INSERT INTO hrebt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baq tatoq ôi! Yac ka crŏng taneh kô ùh lòm qnì ka Ìh, mahaq kon loq ka ìh, wì kô hadai loq ìh khoe thê kon. ");
INSERT INTO hrebt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kon khoe paqnoh yiniq Baq am ka wì haq loq, èh kon oe raq paqnoh hòm, dôq kan loq waq Baq ma loq waq ka kon jah oe dalam wì haq, èh cla kon hadai oe enh dalam ka wì haq.");
INSERT INTO hrebt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Khoe ka waiq khàn, Chuaq Jesus xam mangai tiaq hŏc pùh tŏc apah tau thòng diac Xêt-rôn. Ta aih i mòeq toq wuàn, Chuaq Jesus xam mangai tiaq hŏc mùt dŏng ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Juđa mangai ma blòq Chuaq Jesus hadai loq nòe aih, majah qmang aih Chuaq Jesus xam mangai tiaq hŏc bàc yàng tagop dabau ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Juđa qnung mòeq calùh lình, xam ƀài mangai enh wì pajàu kàn xam ƀài mangai Pharisi thê lam, wì haq wê hadreo xam ranac mùt ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Chuaq Jesus khoe loq i yiniq padon trùh ka dađeh, haq cadiang trùh bòch: “Pì chaq cabô?” ");
INSERT INTO hrebt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wì aih padreo bàu: Nhèn chaq Jesus mangai Naxaret. Chuaq Jesus doe: “Au kô raq!” Juđa mangai blòq Chuaq Jesus hadai yòng ti wì ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jò Chuaq Jesus doe: “Au kô raq” wì aih talùi tacro dŏng ta taneh. ");
INSERT INTO hrebt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chuaq Jesus bòch hòm: “Pì enh chaq cabô?” Wì padreo bàu: Chaq Jesus mangai Naxaret! ");
INSERT INTO hrebt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chuaq Jesus doe hòm: “Au khoe doe ka pì hacô raq au, tàng joq pì chaq rùp au, pì ep caqnaih wì kô lam. ");
INSERT INTO hrebt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Qmang aih dôq xìt troeq bàu cla haq doe: “Au ùh cađac hnhung mòeq ngai leq ìh ma khoe am ka au.” ");
INSERT INTO hrebt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simôn Phiero i mòeq rala chang, haq doeh chang jêh mangai hapŏng da pajàu kàn, koh catech da mangai aih don pah qma. Mangai hapŏng aih yiniq haq Manchu. ");
INSERT INTO hrebt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mahaq Chuaq Jesus thê Phiero: “Qmùt chang qmat ta caqnop beq, chrŏng Baq qnèp ka au wìa ka au ùh ôq qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Khoe aih ƀài lình xam cla craq, hloe xam dìq dŏng ƀài mangai loh enh mangai Juđa wiang rùp kàt Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Baxèm aih, wì aràng Chuaq Jesus trùh jang Anne, majah qmang aih haq aih baq mai da Caiphe, hanam aih haq qnang broq craq pajàu haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiphe aih raq mangai ma khoe doe ka mangai Juđa rameh: Dôq mòeq ngai raq cachìt am dìq dŏng ka mangai qnoeq, ma aih yeo troq. ");
INSERT INTO hrebt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simôn Phiero xam mòeq ngai tiaq hŏc ma qnoeq lam tiaq atìq ka Chuaq Jesus. Mangai tiaq hŏc aih i canau ka craq pajàu haqnhèq, aih ìq haq jah mùt ti Chuaq Jesus ta hamlang hnim craq pajàu kàn. ");
INSERT INTO hrebt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mahaq phiero aih haq yòng gòm enh gùng, haten ka trong qmang. Mangai tiaq hŏc mangai ma i canau ka craq pajàu haqnhèq loh poch tuàng ka mangai hapŏng cadrì ma gòm qmang, khoe aih haq hi qmùt Phiero mùt diq. ");
INSERT INTO hrebt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mangai hapŏng cadrì ma gòm qmang aih bòch Phiero: Ìh kô, hadai mangai tiaq hŏc mangai tau, joq ùh? Mahaq Phiero doe: Au ùh xài. ");
INSERT INTO hrebt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Trŏc tanget, dìq ka ƀài hapŏng xam ƀài lình baxù tanùh ùnh, wì yòng dudan qnhìa ka hatôq. Phiero hadai yòng qnhìa ti wì. Craq pajàu haqnhèq bòch Jesus ");
INSERT INTO hrebt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Craq pajàu haqnhèq ti àu bòch trùh ƀài mangai tiaq hŏc xam trong Chuaq Jesus loq hnài. ");
INSERT INTO hrebt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Chuaq Jesus doe: “Au hmaq anoe hloh yôt am ka wì phù cròng, jò leq au ma ùh hnài ta hnim tagop xam hnim kùh waiq, aih nòe dìq ka mangai Juđa tagop ti dabau, au qnhòq lah capoch cadoc qmòe yiniq cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Hagleq pì ma ti àu bòch au? Drah lam bòch ƀòe mangai ma khoe lah tàng au hnài beq, wì aih loq au anoe cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jò Chuaq Jesus doe qmang aih, i mòeq ngai patìh ta hnim cwan yòng ten aih, dèch tì tep haq rai doe: Ìh hùa hatèu ka craq pajàu haqnhèq qmang aih ayòq? ");
INSERT INTO hrebt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chuaq Jesus doe: “Tàng joq au capoch ajang leq ùh troq, patô beq, tàng au anoe troq gleq ìh ma jêh au? ");
INSERT INTO hrebt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Khoe aih, jò wì oe raq kàt, Anne thê wì aràng Jesus trùh ta hnim Caiphe aih craq pajàu haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jò aih Simôn Phiero oe raq yòng qnhìa ùnh, i mangai bòch haq: Ìh kô hadai mangai tiaq hŏc haq tau joq ùh? Phiero hangah: Au ùh xài. ");
INSERT INTO hrebt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","I mòeq ngai hapŏng da craq pajàu haqnhèq, hadròng ka mangai Phiero ma koh catech da haq don, doe: Ma ùh joq au hnoq ìh oe ta wuàn ôliu ti haq tau qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mòeq yàng hòm Phiero hangah cađac hloe, wop jò aih raq ia hi rŏng. ");
INSERT INTO hrebt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Khoe aih, ƀài gucraq Juđa qnung Chuaq Jesus enh hnim Caiphe trùh tanòe hnim hadarh Rôma. Jò aih oe raq sroeh sroq. Cla wì haq ùh waq mùt tanòe hadrah, wì waq ka dađeh jah sròeh đòeq hu acaq ramènh Pancwa. ");
INSERT INTO hrebt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Qmang aih, Philat cadiang loh bòch wì: Pì tah hadrah ka haq kô yiniq lui cleq? ");
INSERT INTO hrebt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wì padreo bàu: Tàng haq kô ùh xài mangai dù, nhèn ùh aràng haq trùh ta ìh. ");
INSERT INTO hrebt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Philat doe ka wì: Cla pì rùp ahlài hadrah tiaq deh ranenh da cla pì beq. Wì padreo bàu: Nhèn ùh i cwìang hadrah jêh đac cabô. ");
INSERT INTO hrebt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Qmang aih waq ka xìt qmang ka bàu Chuaq Jesus khoe anoe đeh cachìt qmang leq. ");
INSERT INTO hrebt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Philat wìh mùt tanòe hadrah, creo ka Chuaq Jesus hu bòch haq: Ìh kô ajoq bùa mangai Juđa? ");
INSERT INTO hrebt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Chuaq Jesus bòch: “Aih ìq cla ìh capoch tiaq deh manoh, loq khoe i cabô anoe ka ìh loq ka au? ");
INSERT INTO hrebt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Philat padreo bàu: Au kô ìq ma mangai Juđa qmòh? Mangai cla pì xam ƀài pajàu kàn rùp ìh aràng ka au. ìh khoe broq yiniq lui cleq? ");
INSERT INTO hrebt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Chuaq Jesus doe: “Diac au ùh xài oe ta crŏng taneh kô, tàng joq diac au oe ta crŏng taneh kô, ƀài bua au khoe tajêh đòeq tàt ƀài gucraq Juđa ùh dôq wì aih rùp au. Mahaq manòeq kô diac au ùh oe ta crŏng taneh kô”. ");
INSERT INTO hrebt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Philat bòch hòm: Tàng qmang aih ìh kô bùa joq qnàng qmòh? Chuaq Jesus tèu: “Joq qmang ka bàu ìh doe, au kô bùa, aih ìq raq au majah ha-uang loh ta crŏng taneh kô đòeq hu anoe bàu joq qnàng. Mangai leq mòeq bua da bàu joq qnàng, mangai aih èh tàng bàu au.” ");
INSERT INTO hrebt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Philat bòch: Bàu joq qnàng aih qmang leq? Khoe aih haq loh hòm enh gùng doe ka ƀài mangai Juđa: Au ùh i hnoq qmòe haq kô i yiniq lui cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mahaq pì khoe hmòt, waq toq trùh hì Ramènh Pancwa, au hi caqnaih ka pì mòeq ngai loh enh hnim clêh, qmang aih pì i enh au caqnaih da pì bùa Juđa ùh? ");
INSERT INTO hrebt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dìq dŏng ka wì cajiah cadêh: Apaq caqnaih haq qmat, mahaq caqnaih da nhèn Baraba! Baraba aih mangai loq ti atùng. ");
INSERT INTO hrebt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Khoe aih, Philat thê wì rùp qnung lam blai Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ƀài lình broq mòeq toq cadoh yila, dèch pacôi ta gàu Chuaq Jesus, rai taqmàn ka haq mòeq blah eo gòh. ");
INSERT INTO hrebt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Khoe èh, wì thia haten doe ka haq: Waiq bùa Juđa. Khoe èh wì dèch tì tep haq. ");
INSERT INTO hrebt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Philat loh enh gùng doe hòm ka mangai Juđa ma oe ta aih: Ngan kô! Au qnoh haq enh gùng, dôq pì loq au khoe chaq ùh lòm hnoq qmòe haq kô i yiniq lui cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jò Chuaq Jesus loh enh gùng gàu haq kôi cadoh yila, chac haq caxùnh eo gòh, Philat doe ka wì: Pì ngan mangai kô! ");
INSERT INTO hrebt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mahaq jò ƀài pajàu kàn xam ƀài mangai ma tiaq wì haq bu hnoq Chuaq Jesus, wì khoe cachech: Drah tiang đình haq qmat talong pagat! drah tiang đình haq qmat talong pagat! Phi lat doe ka wì: Cla pì rùp tiang đình mangai kô talong pagat beq, majah qmang aih au ùh lòm hnoq haq kô i yiniq lui cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mangai Juđa doe: Nhèn i dèh ranenh, tiaq ranenh aih haq qmat ep cachìt, majah qmang aih haq doe đeh Kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jò Philat tàng qmang aih, kiang haq crè ùh hnau hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Philat wìh mùt hlài tanòe hadrah bòch Chuaq Jesus: Ìh trùh enh leq? Mahaq dua Chuaq Jesus ùh tèu. ");
INSERT INTO hrebt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Philat doe: Ìh ùh waq tèu au, Ìh ma ùh qnì au i cwìang caqnaih, i cwìang tiang đình ìh qmòh? ");
INSERT INTO hrebt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Chuaq Jesus padreo bàu: “Tàng ùh xài enh qnhèq khoe am ka ìh cwìang aih, ìh ùh i cwìang cleq enh qnhèq ka au, qmang aih mangai ma rùp au aràng ka ìh, mangai ma i tuiq yeo kàn. ");
INSERT INTO hrebt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pang aih Philat toq chaq trong hu caqnaih Chuaq Jesus, mahaq mangai Juđa cajiah yeo dêh hòm: Tàng joq ìh caqnaih mangai qmat, ìh pi xài mòeq bua ka Sêsa hòm, majah qmang aih cabô doe rađeh kô bùa, mangai aih enh yòng tablêq ka Sêsa! ");
INSERT INTO hrebt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Philat tàng bàu qmang aih, haq hi qnoh Chuaq Jesus loh enh gùng, haq hangui ta gèq hadrah, ajang aih wì creo dèh Pawi (bàu Hebru creo Gabatha). ");
INSERT INTO hrebt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hì aih wop hì padon ka Ramènh Pancwa, jò aih khoe qne hì, Philat doe ka mangai Juđa: Kô bùa pì. ");
INSERT INTO hrebt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mahaq wì cajiah cadêh: Jêh đac haq beq! jêh đac haq beq! tiang đình haq talong pagat beq! Philat doe ka wì: Au tiang đình bùa pì talong pagat qmòh? Ƀài pajaù kàn doe: Enh gùng ka Sêsa, nhèn ùh i ka bùa ma qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pulùch aih, Philat hi am ka wì Chuaq Jesus đòeq wì qnung lam tiang đình haq talong pagat. Qmang aih wì hi rùp qnung Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Chuaq Jesus xùi dèh long pagat trùh ajang nòe ta aih wì creo go Cadôh, (bàu Hebru aih creo Gogôtha). ");
INSERT INTO hrebt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wì tiang đình haq ta aih, i baiq ngai qnoeq hòm ti haq, mòeq apah mòeq ngai, Chuaq Jesus oe taqne wa. ");
INSERT INTO hrebt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Philat broq mòeq capiac long ban, đòeq enh gàu ka long pagat. Ta aih i achìh: JESUS MANGAI NAXARET, BÙA DA MANGAI JUĐA. ");
INSERT INTO hrebt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bàc ngai Juđa đŏc bàu kô majah qmang aih nòe tiang đình Chuaq Jesus haten ka plài, èh bàu aih achìh tiaq bàu Hebru, bàu Latin xam bàu Gorec. ");
INSERT INTO hrebt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ƀài pajàu kàn da mangai Juđa lam anoe ka Philat: Apaq achìh bùa da mangai Juđa, mahaq achìh mangai kô doe rađeh kô bùa mangai Juđa. ");
INSERT INTO hrebt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Philat doe: Bàu au achìh cleq, au khoe achìh. ");
INSERT INTO hrebt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jò ƀài lình khoe tiang đình Chuaq Jesus talong pagat, wì lêh yŏc da haq eo đòeq hu lah axong broq pôn phàn, mòeq ngai mòeq phàn ka wì haq, wì hadai yŏc da haq eo yôh. Mahaq eo yôh kô ùh i ka trong jìp, khoe jah atênh mòeq yàng enh qnhèq trùh taqneq. ");
INSERT INTO hrebt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wì haq doe ka dabau: Apaq hit eo kô, beq bèn pàih paqnàih, troq ka magai leq, mangai hi jah. Qmang aih, waq ka xìt qmang ka bàu Hset hadròeh achìh: Wì ta axong ka dabau eo au, Pàih paqnàih hu yŏc eo yôh au. Aih bìac da ƀài lình ma khoe broq. ");
INSERT INTO hrebt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Haten ka long pagat da Chuaq Jesus, miq haq xam daq miq haq yòng jang aih, i Mari cadrì da Clê-ôba, hloe xam Mari Mađolen hòm. ");
INSERT INTO hrebt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chuaq Jesus hnoq deh miq xam mangai tiaq hŏc đeh ma loq waq yòng tìa aih, haq doe deh ka miq: Mangai cadrì meh, qmat kon ìh. ");
INSERT INTO hrebt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Èh Chuaq Jesus doe ka mangai tiaq hŏc: “Qmat miq ìh.” Pang hì aih, mangai tiaq hŏc aih hi ahlài miq da Chuaq Jesus ta hnim đòeq hu wèq ban. ");
INSERT INTO hrebt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Khoe aih, loq rìm yiniq khoe jah gêh, èh bàu Hset hadròeh hadai khoe jah xìt, Chuaq Jesus doe: “Au croh ranŏng. ");
INSERT INTO hrebt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ajang aih i mòeq toq abôq diac jòq, wì yŏc cato capaih tàm ta diac aih, kàt cato aih ajang goe long dèch ta hacùng Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jò Chuaq Jesus khoe jah diac jòq aih, haq hi doe: “Rìm yiniq khoe jah gêh.” Haq wech gàu, mahua yiang haq hi loh. ");
INSERT INTO hrebt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Hì aih wop hì padon ramènh Pancwa, hì atìq aih troq hì Sabat, yàng hì Sabat kô aih dìq jaq kàn, dài aih ƀài gucraq mangai Juđa ùh enh dôq ta hì Sabat ƀài hanang oe raq ta long pagat. Wì haq trùh bòch Philat am wì tùq tagoh caxènh tangong đòeq hu qnoh ƀài hanang enh long pagat loh ta haqneq. ");
INSERT INTO hrebt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Qmang aih, lình trùh tong tagoh caxènh tangong mangai baxèm, èh trùh mangai ma tau diq, aih wa mangai wì tiang đình pajùm ti Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jò ƀài lình trùh ajang Chuaq Jesus, hnoq haq khoe cachìt, wì pi hìaq tùq tagoh da haq tangong hòm; ");
INSERT INTO hrebt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","mahaq i mòeq ngai lình yŏc jaoq bìt da haq yimìa cabŏng, tajòe qmòe xam mahim xam diac dahrôq loh. ");
INSERT INTO hrebt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mangai ma khoe jah hnoq ƀài yiniq aih haq hi taqmon hlài (bàu haq anoe aih joq qnàng, cla haq loq ka dađeh anoe joq qnàng) đòeq pì hadai lùi. ");
INSERT INTO hrebt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ƀài yiniq kô, khoe loh qmang aih dôq xìt tiaq bàu kô ta Hset hadròeh: “Ùh i mòeq toq caxènh leq da haq tagoh”. ");
INSERT INTO hrebt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Èh i bàu kô hòm ta Hset hadròeh: “Wì jah hnoq mangai wì ma khoe bìt”. ");
INSERT INTO hrebt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Atìq ka aih, Jôsep mangai oe ta Arimathê, haq aih mangai tiaq hŏc Chuaq Jesus mahaq haq cadoc rađeh majah qmang aih haq crè ka ƀài gucraq Juđa. Haq trùh ajang Philat bòch yŏc hanang Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicôđem aih mangai nèh haq hadai khoe trùh ti Chuaq Jesus jò damang, jò aih haq hanoh trùh, haq aràng jah piq jàt pôn kìq jan xua thùm jràu pajùm ti gahnàu. ");
INSERT INTO hrebt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wa aih qnoh hanang Chuaq Jesus yŏc bai xam diac jreo xua thùm lom hanang Chuaq Jesus tiaq ranenh mangai Juđa. ");
INSERT INTO hrebt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jò aih, tanòe wì ma tiang đình Chuaq Jesus i mòeq toq wuàn, ta wuàn aih i mòeq toq ralùng oe raq neo, ralùng aih qnhòq lah catùh cabô. ");
INSERT INTO hrebt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Wa taqngùi hanang Chuaq Jesus ta aih, majah qmang aih, hì aih hì padon da mangai Juđa, èh qnah hòm ralùng hanang haten hloe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sroeh sroq hì baxèm tuàng ramènh, trŏc bu badrèh badrah oe raq clam, Mari Mađolen lam ta ralùng hanang, hnoq hmo padit qngah ralùng khoe cadro taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Haq drah cadàu chaq Simôn Phiero xam mangai tiaq hŏc maqnoeq, aih mangai Chuaq Jesus ma loq waq, haq doe: Wì khoe qnoh hanang Chuaq Jesus lam taqnoeq, ùh qnì wì đòeq haq taleq. ");
INSERT INTO hrebt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Wa Phiero xam mangai tiaq hŏc maqnoeq drah tùh loh ta ralùng hanang. ");
INSERT INTO hrebt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dìq baiq ka wa cadàu, mahaq mangai matau cadàu yeo dêh ka Phiero haq trùh ta ralùng adroe. ");
INSERT INTO hrebt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Haq aih ki ngan hnoq bai oe ta haqneq, mahaq haq ùh mùt. ");
INSERT INTO hrebt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Phiero trùh diq, mùt hloe ta ralùng, hnoq bai oe ta haqneq. ");
INSERT INTO hrebt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mù gàu xam bai lom hanang ùh oe pajùm ti dabau, mahaq khoe canua đòeq crài taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jò aih mangai ma trùh adroe, hadai cadiang mùt, hnoq qmang aih haq hi lùi diq. ");
INSERT INTO hrebt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Majah qmang aih wa aih dìq qnhòq tem bàu Hset Hadròeh anoe: Jesus ep rìh hlài enh mangai cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Khoe ka aih, wa mangai tiaq hŏc hi hlài deh tahnim. ");
INSERT INTO hrebt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mahaq Mari yòng đeh enh gùng, haten ka ralùng hanang rai hmoe. Haq rai hmoe rai kùp ngan ta ralùng. ");
INSERT INTO hrebt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Haq hnoq baiq ƀình plình caxùnh eo taboc, mòeq ngai haqngui enh gàu, mòeq ngai hangui enh jènh, ajang nòe taqngùi hanang Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Baiq ƀình plình bòch: Mangai gucadrì meh, gleq ìh majah crò? Haq padreo bàu: Wì khoe qnhac Chuaq au taqnoeq, au ùh qnì wì đòeq haq taleq? ");
INSERT INTO hrebt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Capoch bu khoe, haq hwi ngan hnoq Chuaq Jesus yòng ajang aih, mahaq haq ùh canau. ");
INSERT INTO hrebt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chuaq Jesus bòch: Mangai gucadrì meh, hagleq ìh majah hmoe? Ìh chaq cabô? Hèm deh aih canau mangai broq wuàn, haq doe: Wì daq, tàng joq ìh khoe qnung hanang Haq taqnoeq, ìh anoe biaq ka au loq, dôq au lam yŏc ahlài. ");
INSERT INTO hrebt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chuaq Jesus creo ka haq: “Mari.” Mari drah hwi ngan, haq capoch bàu Hebru: Rabuni (aih la mangai hnài)! ");
INSERT INTO hrebt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Chuaq Jesus doe: “Apaq bèq au, majah qmang aih au qnhòq tŏc deh ta Baq, mahaq drah lam anoe ka ƀài oh daq au, doe ka wì loq au tŏc dèh ta Baq au, aih hadai Baq pì, tŏc ti Boc Plình au, aih hadai Boc Plình pì. ");
INSERT INTO hrebt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari Mađolen lam anoe ka ƀài mangai tiaq hŏc: Au khoe hnoq Chuaq Jesus. Rai taqmon ka wì dìq dŏng rìm yiniq Chuaq Jesus anoe ka haq. ");
INSERT INTO hrebt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hì aih raq jò khoe xèq, aih hì baxèm ta gàu tuàng, ƀài qmŏc qmang nòe ƀài mangai tiaq hŏc oe, dìq clenh clòng ka cajap, majah qmang aih wì crè ka mangai Juđa, Chuaq Jesus loh yòng taqne wì haq rai doe: “Catèm ka pì! ");
INSERT INTO hrebt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Doe qmang aih hi khoe, Haq am ka wì ngan xam tì xam yimìa haq. Mangai tiaq hŏc dìq jaq lem bùi jò jah hnoq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Haq doe hòm: “Catèm am ka pì, Baq khoe thê au qmang leq, au hadai thê pì qmang aih.” ");
INSERT INTO hrebt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Èh Haq hlui qmùt hi hèm ka wì rai doe: “Drah yŏc Yiang Hadròeh beq. ");
INSERT INTO hrebt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tàng pì caqnaih da cabô yiniq lui, yiniq lui wì aih èh jah claih, tàng joq pì ùh caqnaih da wì yiniq lui, yiniq lui wì aih ùh jah claih.” ");
INSERT INTO hrebt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mahaq jò Chuaq Jesus trùh, Thôma wì macreo Đi đim, aih mangai hadai oe ti wì mòeq jàt baiq ngai, ùh i ka mat ta aih ti ƀòe mangai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wì mangai tiaq hŏc qnoeq anoe ka haq: Nhèn khoe hnoq Chuaq Jesus. Mahaq haq doe: Tàng joq au ùh hnoq qmòe teo đình ta capiang tì haq, rai tah hadrang tì ajang habau aih, tàng joq au ùh bèq yimìa haq, ùh jò leq au lùi. ");
INSERT INTO hrebt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Rahem hì atìq ka aih, mangai tiaq hŏc Chuaq Jesus oe hòm ti dabau ta hnim, Thôma hadai oe ti wì ta aih. Jò qmang hnim oe raq clòng, Chuaq Jesus mùt yòng taqne mangai tiaq hŏc rai doe ka wì: “Catèm am ka pì.” ");
INSERT INTO hrebt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Khoe aih Haq doe ka Thôma: “Yŏc hadrang tì ìh tah ajang kô, èh ngan capiang tì au, hnhu tì bèq ti yimìa au, apaq cadoq manoh, mahaq toq lùi raq.” ");
INSERT INTO hrebt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thôma doe: Waiq Chuaq au aih Boc Plình au! ");
INSERT INTO hrebt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chuaq Jesus doe: “Pàng ìh khoe hnoq au ìh majah lùi. Xôq ramot am ka mangai qnhòq hmaq hnoq mahaq khoe lùi.” ");
INSERT INTO hrebt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Chuaq Jesus oe broq bàc kan halac enh ngèa mangai tiaq hŏc mahaq ùh i achìh ta hset kô. ");
INSERT INTO hrebt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mahaq ƀài yiniq kô khoe achìh, dôq pì lùi Chuaq Jesus aih raq Mêsi, Kon da Boc Plình, đòeq jò pì lùi, canòm ka yiniq haq aih èh đòeq hu jah kan rìh. ");
INSERT INTO hrebt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Atìq ka aih, Chuaq Jesus loh mahno rađeh hòm ka mangai tiaq hŏc ta haqmai diac raxìq Têbi-riat. Bìac aih rameh: ");
INSERT INTO hrebt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simôn Phiero, Thôma (wì creo Đi đim), Natha-na-ên mangai Cana gùng Galili, kon da Sêbeđê xam baiq ngai tiaq hŏc qnoeq hòm oe ti dabau. ");
INSERT INTO hrebt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simôn Phiero doe ka wì: Au lam ranang ka, wì padreo bàu: Nhèn hadai lam ti ìh. Qmang aih wì loh ta boang, mahaq mang aih ranang ùh jah qmòe cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Trùh sroeh sroq, Chuaq Jesus yòng tago mahaq ƀài mangai tiaq hŏc ùh canau ka haq. ");
INSERT INTO hrebt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Haq creo ka wì: “Yôiq ƀài bua au, Pì ajah ka ùh?” Wì doe: Ùh jah cleq. ");
INSERT INTO hrebt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Haq doe ka wì: “Caqnìh hlàm enh pah qma ka boang qmat aih pì hi jah ka.” Jò wì aih caqnìh hlàm, wì jah ka bàc haraya, loh qmòe ka pi hlàt dèch dèh hlàm. ");
INSERT INTO hrebt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mangai tiaq hŏc Chuaq Jesus ma loq waq doe ka Phiero: Hatau raq Chuaq. Jò Simôn Phiero tàng doe: Aih raq Chuaq, haq drah yŏc caxùnh dèh eo yôh (majah qmang aih haq oe chac dech) rai hadrùc ta diac. ");
INSERT INTO hrebt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ƀài mangai tiaq hŏc maqnoeq chùng boang atŏc tago rai chua hlàm khoe bình ƀài ka, majah qmang aih wì haq ùh hìaq hangai ka go, loq jah bu baiq hrinh hagat. ");
INSERT INTO hrebt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jò mangai tiaq hŏc khoe tŏc tago, hnoq ta aih i ka phiang ta ngia ùnh, ƀênh hadai i. ");
INSERT INTO hrebt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chuaq Jesus doe ka wì haq: “Aràng ka pì neo ranang tacô”. ");
INSERT INTO hrebt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simôn Phiero cadiang loh ta boang, rai hua hlàm hlech jah mòeq hrinh padam jàt piq pliang ka kàn atŏc tago, mahaq yac ka hnoq jah bàc qmang aih, hlàm dua ùh hyah. ");
INSERT INTO hrebt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chuaq Jesus doe ka wì: “Thia tacô hu acaq di sroq.” Ùh i moeq ngai tiaq hŏc leq hùa bòch: Ìh kô ìq cabô? Wì loq aih raq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chuaq Jesus lam haten yŏc ƀênh yŏc ka am ka mangai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aih yàng piq Chuaq Jesus mahnu rađeh am ka mangai tiaq hŏc hnoq, atìq ka haq rìh hlài enh mangai cachìt. ");
INSERT INTO hrebt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jò wì khoe hêq ka acaq, Chuaq Jesus doe ka Simôn Phiero: “Simôn kon da Jôna, ajoq ìh loq waq ka au ùh hnau ka wì kô ùh? Phiero doe: Chuaq au, joq ìh loq au loq waq ka ìh. Chuaq Jesus doe: “Qmi da au trìu kon acaq. ");
INSERT INTO hrebt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chuaq Jesus doe hòm yàng baiq: “Simôn kon da Jôna, ajoq ìh loq waq ka au ùh hnau ka wì kô ùh?” Phiero padreo bàu: Chuaq au, joq ìh loq au loq waq ka ìh. Chuaq Jesus doe: “wèq da au trìu oq.” ");
INSERT INTO hrebt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yàng piq Haq anoe ka Simôn hòm: “Simôn kon da Jôna, ajoq ìh loq waq ka au?” Phiero dìq jaq mangò ta manoh majah qmang aih Chuaq Jesus bòch haq piq yàng: “Ajoq ìh loq waq ka au?” Phiero doe: Chuaq au, ìh loq rìm trong, ìh loq au loq waq ka ìh. Chuaq Jesus doe ka haq: “Qmi da au trìu.” ");
INSERT INTO hrebt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Joq qnàng au anoe ka ìh, jò ìh oe raq radam, cla ìh kàt dèh kaxi caqnam, enh lam taleq lam, mahaq trùh jò ìh hi craq, ìh hnhu tì am ka wì kàt da ìh kaxi caqnam qnung ìh trùh tanòe ìh ùh enh lam. ");
INSERT INTO hrebt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Chuaq Jesus anoe bàu kô đòeq patô ka Phiero haq loq rađeh kô èh cachìt qmang leq dôq ka Boc Plình jah kan ranhòm. Khoe aih haq doe ka Phiero: “Lam tiaq au.” ");
INSERT INTO hrebt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phiero hwi ngan hnoq mangai tiaq hŏc Chuaq Jesus ma loq waq qnang tiaq wa, aih mangai mang wì haq ma acaq ramènh Pancwa, haq ma angèn ta rada Chuaq Jesus rai bòch: Chuaq au, cabô ma blòq Ìh? ");
INSERT INTO hrebt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jò hnoq mangai aih, Phiero bòch: Chuaq au! ha mangai meh èh qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Chuaq Jesus padreo bàu: “Tàng joq au enh ka haq qmat oe rìh yôt trùh hì au wìh hlài, aih ep cleq ka ìh?” mahaq ìh kô ep tiaq au. ");
INSERT INTO hrebt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aih ìq taqne oh daq majah i bàu doe: Mangai tiaq hŏc aih ùh cachìt. Mahaq ùh xài Chuaq Jesus doe haq aih ùh cachìt, haq toq doe: “Tàng joq au enh ka haq qmat oe rìh yôt trùh hì au wìh hlài, aih ep cleq ka ìh?” ");
INSERT INTO hrebt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Cla mangai tiaq hŏc kô raq ma rai anoe rai achìh hlài ƀài yiniq kô, bèn loq bàu haq ma anoe aih joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Oe i bàc yiniq qnoeq Chuaq Jesus khoe broq, tàng joq achìh hlài dìq tang yiniq, au hèm dìq dŏng ka crŏng taneh kô ùh anòh đòeq hset wì ma achìh aih. ");
INSERT INTO hrebt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Wì craq Thiôpi, oe ta hset adroe au khoe anoe rìm trong Chuaq Jesus ma khoe broq rai hnài qmòe enh jò baxèm, ");
INSERT INTO hrebt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","trùh hì haq jah dèch atŏc ta plình, atìq ka haq khoe canòm ka Yiang Hadròeh đòeq hu hnài deh ƀài mangai tiaq cla haq ma khoe ràih. ");
INSERT INTO hrebt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Atìq ka haq khoe pòq kan xalep, enh ngèa ka ƀài mangai tiaq cla haq yŏc bàc trong đòeq patô ka wì loq haq kô rìh, èh haq oe ti ƀài tiaq cla pôn jàt hì, anoe ka wì trong diac Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jò oe ti ƀài mangai tiaq cla, haq tanap: Apaq loh enh gùng ka Jêrusalem, mahaq pì ep oe ta aih raq gòm yiniq Baq ma khoe tèu am ka pì, aih yiniq pì khoe tàng au doe. ");
INSERT INTO hrebt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Majah qmang aih Jon khoe broq ka pì ƀaptem xi diac, mahaq toq biaq hì hòm, pì jah broq ƀaptem xi Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ƀài mangai ma tagop ta aih bòch: Waiq Chuaq! manoèq kô raq ùh xài ìh ma dèch paqnàng hlài diac Isorali? ");
INSERT INTO hrebt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Haq padreo bàu “Hì leq jò leq toq cla Baq khoe loq deh, trong aih pì ùh khòh loq. ");
INSERT INTO hrebt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mahaq Jò Yiang Hadròeh jràp enh qnhèq ka pì, aih èh pì hi jah yŏc kan cwìang itai đòeq hu lam anoe dôq wì loq ka au, ta Jêrusalem, jàp hloe gùng Juđê, gùng Samari trùh jàp jìa crŏng taneh. ");
INSERT INTO hrebt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Khoe ka anoe qmang aih, haq jah dèch atŏc ta plình, jò wì ta aih qnang ngan qngoc haq, i yùc glom qnung haq lam, pi hnoq hòm. ");
INSERT INTO hrebt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jò wì ta aih oe raq haqmiang ngan haq jah dèch atŏc ta trŏc i baiq ngai gucalô caxùnh eo taboc loh enh ngèa wì haq, ");
INSERT INTO hrebt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","rai doe: “Wùih mangai Galili, pì yòng ajang kô hanhoe dèh ta trŏc qmang qmat ìq? Jesus kô khoe jah dèch atŏc ta trŏc enh ngèa ka pì, èh haq hadai wìh hlài qmang ka pì khoe hnoq haq tŏc ta trŏc diq.” ");
INSERT INTO hrebt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Khoe aih, wì haq enh nòe wang Ôliu hlài ta Jêrusalem, wang aih hangai ka Jêrusalem lam bu mòeq hì sabat. ");
INSERT INTO hrebt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jò wì haq hlài khoe trùh, drah tŏc talàu aih nòe Phiero, Jon, Jaco, Anrê, Philip, Thôma, Bathêlemi, Mathio, Jaco kon da Aphê, Simôn Silot, Jiuđe kon da Jaco loq oe. ");
INSERT INTO hrebt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dìq dŏng ka wì aih cajap mòeq manoh waiq khàn pajùm ti ƀài mangai gucadrì, Mari miq da Chuaq Jesus xam wì oh haq. ");
INSERT INTO hrebt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ta ƀài hì aih, Phiero yòng taqne oh daq tagop ti dabau – ƀài mangai tagop ta aih jah mòeq hrinh baiq jàt ngai, haq doe: ");
INSERT INTO hrebt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Dìq dŏng oh daq calô xam oh daq cadrì, bàu Yiang Hadròeh ma khoe canòm ka hacùng Đawit capoch pajàu tanòe Hset Hadròeh anoe trùh Juđa mangai khoe ajèn trong dôq wì rùp Chuaq Jesus, aih khoe xìt. ");
INSERT INTO hrebt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Majah qmang aih haq hanoh oe ti bèn, hadai khoe jah broq mangai tiaq cla qmang ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Haq aih yŏc ƀac baha kan dù da rađeh rot moeq haqnech ruàng, ta aih haq taclìh hatàp gàu padah loh dŏng cliac. ");
INSERT INTO hrebt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bìac aih dìq ka Jêrusalem mangai loq đeh hra, wì loh qmoè ka creo ka ruàng aih tiaq bàu wì haq aih Haênđama, aih ruàng mahim. ");
INSERT INTO hrebt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ta hset Calêu plình i achìh: “Xoeq diq nòe da haq oe loh ka clui hawit Apaq i cabô oe ta aih. Èh hòm: Xoeq diq i mangai mùt yŏc ajang nòe da haq. ");
INSERT INTO hrebt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Aih ìq, taqne mangaì ma khoe tiaq bèn enh jò Chuaq Jesus baxèm oe ti bèn, ");
INSERT INTO hrebt_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","pang Jon ma broq ƀaptem trùh hì Chuaq Jesus jah dèch atŏc khoe ka bèn, taqne wì aih ep i mòeq ngai hu wiang lam anoe ti bèn trong Chuaq Jesus khoe rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mangai tiaq hŏc ràih baiq ngai: Jôsep aih Basaba, tang jò creo Juctu, xam Mathia, ");
INSERT INTO hrebt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","khoe aih wì waiq khàn: Waiq Chuaq, ìh loq manoh cliac rìm ngai, ìh patô am ka nhèn loq wa baiq ngai kô ìh khoe dì deh maleq, ");
INSERT INTO hrebt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","đòeq hu broq mangai tiaq cla, hu qmùt hlài ajang nòe da Juđa ma khoe cađac hu lam oe dèh tanòe. ");
INSERT INTO hrebt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Khoe aih, wì pàih panaìh, hi troq ka Mathia, haq hi jah qmùt ajang mòeq jàt mòeq ngai tiaq cla. ");
INSERT INTO hrebt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Trùh Ramènh hì padam jàt, mangai tiaq hŏc tagop dabau mòeq nòe. ");
INSERT INTO hrebt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Cadoe i atêh loh enh plình qmang atêh ka cayeo hlui, jàp jìa ta hnim mangai tiaq hŏc hangui. ");
INSERT INTO hrebt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","wì haq hnoq i tang pla ùnh tìah ka rapet, loh jràp tang ngai ta wì haq. ");
INSERT INTO hrebt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Rìm ngai jah bình Yiang Hadròeh, pang aih wì hi capoch ƀài bàu qnoeq, tiaq qmang ka Yiang Hadròeh am ka rađeh capoch. ");
INSERT INTO hrebt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jò aih, ta Jêrusalem ƀài mangai Juđa ma loq iu yùq ka Boc plình enh rìm diac oe ta caqnàm plình trùh ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jò wì haq tàng atêh bàu aih, wì tùh loh ngan, mangai leq mangai meh hi haglènh đeh hra majah qmang aih wì haq tàng ƀài mangai tiaq hŏc capoch bàu gùng wì haq. ");
INSERT INTO hrebt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wì haq yùq pi cajaq rai bòch dabau: Dìq dŏng ka wì qmat ma ùh xài mangai Galili qmòh? ");
INSERT INTO hrebt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tàng joq qmang aih, hagleq bèn majah tàng wì haq tapoch bàu gùng bèn? ");
INSERT INTO hrebt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ƀài magai Bathê, Mêđi, Êlamit, mangai oe ta Mêsôbôtami, Jiu đê, Capbađoc, Bong, Asi, ");
INSERT INTO hrebt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phirigi, Bam phili, Êdip, Libi ma haten ka gùng Siren, mangai trùh enh Rôma, ");
INSERT INTO hrebt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","mangai Jiuđa hloe xam mangai maneo tiaq trong mangai Jiuđa, mangai Coret, mangai Aràp, nhèn tàng wì haq capoch bàu gùng nhèn đòeq anoe kan haqnhèq kàn kaiq da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wì hamàih loh ka pi qnì hèm cleq, wì tabòch dabau: Yiniq kô ìq qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mahaq i ƀài mangai ma loq ti halê doe: Wì qmat bù ka alac neo. ");
INSERT INTO hrebt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jò aih Phiero yòng pajùm ti mòeq jàt mòeq ngai tiaq cla, dèch bàu anoe ka mangai bàc ta aih: “Oh daq Jiuđa xam dìq ka mangai oe ta Jêrusalem, dôq au anoe ka pì qmang kô, pì tamàng ma adia haq. ");
INSERT INTO hrebt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wì kô ùh i bù qmang ka pì xoh, majah qmang aih manòeq kô bu hachìn jò di sroq. ");
INSERT INTO hrebt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mahaq kô raq yiniq Jôen mangai pajàu Boc Plình ma khoe anoe: ");
INSERT INTO hrebt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Boc Plình doe: Tahì atìq kô èh, Au ùc qnoh Yiang au am dìq ka kon mangai; Kon calô xam kon cadrì pì dìq jah tapoch pajàu, Ƀài guradam jah hnoq kan mahno, Mangai craq jah hnoq apô. ");
INSERT INTO hrebt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Joq qnàng taƀài hì aih èh, au ùc qnoh Yiang au jàp ka mangai hapŏng calô xam hapŏng cadrì, Dìq ka wì haq jah capoch bàu pajàu; ");
INSERT INTO hrebt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Au mahno tam ka wì haq kan halac oe ta plình, Xam ta crŏng taneh; Aih la mahim, ùnh, xam kan nhòe; ");
INSERT INTO hrebt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mahì loh ka clam, Khê wìh wìa mahim, Adroe ka hì kàn hì ranhòm da Chuaq trùh; ");
INSERT INTO hrebt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aih èh cabô ma canòm ka Chuaq, mangai aih hi jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mangai Isorali, pì tamàng bàu kô: Chuaq Jesus mangai Naxaret kô, aih raq mangai Boc Plình khoe yŏc haq đòeq broq trong i cwìang itai, kan halac, kan hamàih oe taqne pì, dôq pì jah loq đòeq pì hu anoe ka wì qnoeq qmang ka cla pì ma khoe loq. ");
INSERT INTO hrebt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pì khoe rùp haq am ka wì, tiaq manoh Boc Plình ma khoe loq khoe tamroq deh adroe, pì khoe canòm tì kŏng mangai dù tiang đình haq talong pagat đòeq hu jêh cađac. ");
INSERT INTO hrebt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mahaq Boc Plình khoe broq ka Chuaq Jesus rìh hlài, hràt catech caxi kan cachìt, majah qmang aih kan cachìt ùh jah rùp padràng Chuaq Jesus oe enh qneq ka cwìang haq. ");
INSERT INTO hrebt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ràu trùh haq, Đawit khoe anoe: Au hmaq hnoq yôt Chuaq oe enh ngèa ka au, Majah qmang aih haq oe enh apah qma au, Dôq au ùh hìaq dalàc. ");
INSERT INTO hrebt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Aih ìq raq, manoh cliac au lem bùi, rapet au manè, Chac au hadai jah padài ta kan canòm; ");
INSERT INTO hrebt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Majah qmang aih Chuaq ùh dôq mahua yiang au oe ta hwinh, Hanoh ùh cađac au oe ta kan cachìt. Haq ùh dôq chac mangai hadròeh haq hech hnhung. ");
INSERT INTO hrebt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Chuaq khoe patô ka au trong kan rìh; Am ka manoh au jah bình kan lem bùi enh ngèa ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Dìq ka oh daq Isorali, au anoe qnàng ka pì, Đawit aih kan cadraq bèn, haq khoe cachìt, wì khoe catùh, manòeq kô ralùng hanang haq oe raq taqne bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mahaq, haq aih mangai pajàu, haq loq Boc plình khoe hapah đòeq tèu bàu ka haq, aih ta xinoe haq Boc plình dèch mòeq ngai đòeq hangui tanòe gèq bùa haq, ");
INSERT INTO hrebt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","aih haq khoe chônh hnoq yiniq ma padon trùh, chônh anoe trùh kan rìh hlài da Christ rameh: Haq ùh oe hloe tanòe kan cachìt, chac haq hadai ùh hech ùh hnhung. ");
INSERT INTO hrebt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Boc Plình khoe broq ka Chuaq Jesus kô rìh hlài, dìq ka nhèn hadai wiang hnoq. ");
INSERT INTO hrebt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jò haq khoe jah dèch atŏc hangui apah qma Boc Plình, enh nòe Baq haq khoe jah yŏc Yiang Hadròeh Baq ma khoe tèu am, haq hi ùc qnoh Yiang Hadròeh, aih yiniq pì ma qnang hnoq qnang tàng kô. ");
INSERT INTO hrebt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Majah qmang aih Đawit qnhòq lah tŏc ta plình, mahaq cla haq raq doe: Chuaq khoe doe ka Chuaq au: Hangui enh qma ka au, ");
INSERT INTO hrebt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Trùh jò au roh mangai git ka ìh oe enh qneq ka ìh, đòeq broq radua ròh jènh ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Qmang aih dìq ka mangai Isorali pì ep loq qmang kô Boc Plình khoe dèch Chuaq Jesus kô mangai pì ma khoe tiang đình haq talong pagat broq Christ broq Chuaq.” ");
INSERT INTO hrebt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jò wì tàng bàu kô, wì tadèch qmòe ta manoh, wì bòch Phiero xam ƀài mangai tiaq cla: Wì daq! nhèn ep broq qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phiero padreo bàu: thê pì loq raxach, rìm ngai ep canòm ka yiniq Chuaq Jesus đòeq jah broq ƀaptem, dôq yiniq lui pì jah caqnaih, khoe aih hi jah yŏc Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Majah qmang aih bàu ma khoe tèu aih jah pì xam ƀài kon da pì, xam dìq ka ƀài mangai oe hangai, aih ƀài mangai Boc Plình bèn ma khoe padon creo”. ");
INSERT INTO hrebt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Phiero yŏc tam bàc trong đòeq rai hnài rai pariaq wì, haq doe: “Pì drah doeh rađeh claih enh xinoe ngang dù kô”. ");
INSERT INTO hrebt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mangai ma tamàng bàu haq dìq jah broq ƀaptem, hì aih i tam piq muàn mangai jah qmùt tanòe Tagop Hadròeh. Mòeq manoh ka dabau ");
INSERT INTO hrebt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wì aih dìq ka manoh wèq bàu ƀài mangai tiaq cla hnài, hatroq ka dabau, wèq Ramènh goh ƀênh wèq trong waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Rìm ngai i manoh iu yùq, majah qmang aih i bàc kan halac loh enh tì kŏng mangai tiaq cla. ");
INSERT INTO hrebt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Dìq dŏng mangai ma lùi Chuaq Jesus, pajùm mamoh ti dabau, yŏc rìm yiniq broq hang pajùm. ");
INSERT INTO hrebt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tech dŏng dèh ƀài kùng hang, taneh ruàng đòeq hu axong ka dabau, tiaq dèh tang ngai ma i yiniq nan ka waq pang leq. ");
INSERT INTO hrebt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hì leq hì meh panim ka tŏc ta hnim kùh waiq. Jò oe ta hnim wì haq dìq ka manoh lem bùi goh ƀênh acaq ôq ti dabau, ");
INSERT INTO hrebt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","rai manè apôi Boc Plình, wì haq jah lem ka manoh phù cròng. Rìm hì Chuaq qmùt tam mangai jah dèch ta Tagop Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","I mòeq hì, wa Phiero wa Jon tŏc ta hnim kùh waiq, hu waiq khàn, jò aih khoe jah piq jò dixèq. ");
INSERT INTO hrebt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ta aih, i mòeq ngai pen enh jò haq clìh enh cliac, rìm hì wì aràng pagui đòeq haq ta hnim kùh waiq ajang nòe qmang wì ma creo Qmang lem, hu axìn enh ƀài mangai ma mùt ta hnim kùh waiq. ");
INSERT INTO hrebt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hnoq wa Phiero wa Jon mùt, haq hnhu tì bòch đeh bac wa aih. ");
INSERT INTO hrebt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Phiero xam Jon chrìh ngan haq, èh Phiero doe: Ngan ma kô. ");
INSERT INTO hrebt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mangai aih hi ngan đeh wa ja cajoq, xoh dèh ta manoh canau loq jah đeh toq xit toq criah cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yàng èh, Phiero doe ka haq: Au ùh i ka ƀac wang, mahaq au i cleq au am ka ìh ka aih: Canòm ka yiniq Chuaq Jesus Christ, mangai Naxaret, cadiang lam beq! ");
INSERT INTO hrebt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Phiero rùp tì pah qma dèch haq yòng. Tajòe qmòe jò aih, capiang jènh xam mat ka haq loh ka qnhrang. ");
INSERT INTO hrebt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Haq hi padinh yòng tiaq wa mùt ta hnim kùh waiq, rai lam rai aplôh calêu manè appôi Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wì ta aih dìq hnoq haq lam rai manè apôi Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Wì canau meh raq mangai ma hangui ajang Qmang lem hu axìn, wì loh dŏng haglènh rai hamàih jò hnoq kan halac loh ka haq qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Haq aih qnang carùp tì Phiero xam Jon, ƀài mangai ta aih hamàih pi cajaq, rìm ngai tùh loh ngan wì aih, ajang nòe wì ma creo radua qmang Salômôn. ");
INSERT INTO hrebt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Phiero hnoq qmang aih, haq doe ka mangai ta aih: Dìq ka oh daq Isorali, hagleq pì majah hamàih ka yiniq kô? Hagleq pì majah chrìh ma qmang qmat, tìah gleq ma khoe canòm kan itai, kan taq atoq da cla ma đòeq broq ka mangai kô jah cadiang lam? ");
INSERT INTO hrebt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Boc Plình da Apraham, Ysac, Jacôp, Boc Plình da kan cadraq bèn khoe broq ka hapŏng haq aih Chuaq Jesus jah ranhòm, aih Mangai pì khoe rùp, khoe ùh waq đac ka haq enh ngèa Philat, jò Philat enh caqnaih haq. ");
INSERT INTO hrebt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pì khoe cađac Mangai Hadròeh, Mangai taq atoq đòeq hu bòch caqnaih ka rađeh mòeq ngai jêh đac mangai, ");
INSERT INTO hrebt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","pì khoe jêh đac Yiang kan rìh, mahaq Boc plình khoe broq haq rìh hlài enh kan cachìt. Nhèn kô mangai khoe hnoq trong aih. ");
INSERT INTO hrebt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mangai kô haq lùi yiniq Chuaq Jesus, yiniq Chuaq Jesus khoe broq ka mangai pì ma hnoq ma canau loq kô jah brêh, aih la kan lùi enh Chuaq Jesus khoe am haq kô jah brêh lem enh ngèa ka pì. ");
INSERT INTO hrebt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Manòeq kô oh daq Isorali au loq pì xam ƀài cwan, pàng pì ùh qnì dài ma khoe broq qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mahaq Boc plình khoe broq qmang aih raq đòeq xìt qmang ka bàu haq tapoch qnoh enh hacùng ƀài pajàu: Christ da haq ep glàm bàc kan xalep. ");
INSERT INTO hrebt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Drah loq raxach rai tawìh hlài ta Boc Plình, dôq dìq dŏng yiniq lui jah caqnaih, ");
INSERT INTO hrebt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","đòeq trùh jò kan padài loh enh Chuaq, aih èh haq thê deh Christ ma khoe tèu am ka pì, aih la Chuaq Jesus, ");
INSERT INTO hrebt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","mangai Trŏc ep đìh ahlài dèh gòm trùh jò dìq dŏng rìm yiniq jah paneo hlài, aih jò Boc plình ma khoe anoe adroe enh hacùng ƀài pajàu hadròeh haq. ");
INSERT INTO hrebt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Môise i doe: Chuaq aih Boc Plình bèn dèch paqnàng taqne oh daq mòeq Ngai pajàu qmang ka au, pì ep broq tiaq rìm bàu haq thê. ");
INSERT INTO hrebt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Waq toq cabô ùh tamàng bàu Pajàu aih, mangai aih ep hnan qnoh đac enh gùng ka oh daq. ");
INSERT INTO hrebt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Joq dìq dŏng ƀai pajàu enh Samuên xam ƀài wì ma atìq ka haq, dìq khoe anoe adroe trùh ƀài hì kô. ");
INSERT INTO hrebt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pì qmat xinoe da ƀài pajàu, xam bàu tajao Boc plình khoe jap ka kan cadraq bèn, jò haq doe ka Apraham: Dìq ka mangai oe ta crŏng taneh canòm ka xinoe ìh kô èh majah xôq ramot ");
INSERT INTO hrebt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Boc plình khoe dèch paqnàng deh hapŏng cla haq, adroe aih thê haq aih loh am xôq ramot ka pì, đòeq tìc ahlài rìm ngai oe taqne pì wìh cađac deh trong dù. ");
INSERT INTO hrebt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Jò Phiero xam Jon qnang capoch tuàng ka wì ta aih, i ƀài pajàu, cwan wèq hnim tagop xam mangai Sađusê trùh. ");
INSERT INTO hrebt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wì nòeh pi cajaq jò hnoq wa haq hnài rai doe enh dalam ka Chuaq Jesus i kan rìh hlài da mangai cachìt. ");
INSERT INTO hrebt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ƀài aih rùp clêh wa haq ta hnim cadrong trùh sroq atìq, majah qmang aih trŏc khoe clam. ");
INSERT INTO hrebt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yac ka qmang aih, i bàc ngai lùi jò khoe tàng bàu wa aih hnài, mangai lùi tŏc jah padam muàn. ");
INSERT INTO hrebt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sroq atìq, ƀài cwan, ƀài gucraq xam ƀài mangai hnài ranenh tagop ti dabau ta Jêrusalem, ");
INSERT INTO hrebt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","xam Anne, aih pajàu haqnhèq, Caiphe, Jon, Alexanđo xam dìq dŏng ƀài nang noe pajàu haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wì rùp qnoh wa Phiero wa Jon yòng enh ngèa wì haq, wì bòch: Yŏc cwìang enh leq, tàng ùh meh canòm ka yiniq cabô chôp ma broq qmang kô? ");
INSERT INTO hrebt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jò aih, Phiero, bình halùih Yiang Hadròeh, haq doe: “Dìq dŏng ƀài cwan xam ƀài gucraq, ");
INSERT INTO hrebt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tàng joq hì kô pì creo ka ma yòng ajang kô đòeq hu tah hadrah ma, taiq ma khoe broq lem ka mangai pen, èh bòch ma broq qmang leq haq ma khoe jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","aih dìq ka pì xam ƀài mangai Isorali khòh loq rameh aih canòm ka yiniq Chuaq Jesus Christ mangai Naxaret, Mangai pì khoe tiang đình talong pagat, Boc plình khoe broq haq rìh hlài enh mangai cachìt, canòm ka haq aih mangai kô khoe jah brêh lem, manòeq kô qnang yòng enh ngèa ka pì. ");
INSERT INTO hrebt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Chuaq Jesus aih: “Hmo ƀài pì mangai broq hnim ma khoe khwênh cađac, Khoe wìa hmo mùm hnim.” ");
INSERT INTO hrebt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ùh ih kan dèch dech ajang cabô qnoeq, majah qmang aih enh caqnàm plình kô, ùh i ka yiniq ma qnoeq am ka mangai đòeq bèn ep canòm ajang aih hu jah dèch”. ");
INSERT INTO hrebt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jò wì hnoq kan tanoq da Phiero xam Jon, loq ka wa aih mangai blùng ùh qnì đeh cleq, wì toq hamàih, èh wì loq wa aih hmaq oe ti Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mahaq patep pang jò wì hnoq mangai khoe jah brêh yòng pajùm ti wa ta aih, wì pi oe jah tapoch cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wì hi thê wa aih loh enh gùng ka nòe hadrah, wì hatình ka dabau: ");
INSERT INTO hrebt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Wa kô èh bèn broq qmang leq? Dìq ka Jêrusalem mangai loq đeh hra wa kô khoe broq kan halac kàn, yac ka bèn enh cadoc dua ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mahaq dôq yiniq kô pi hìaq prai tam yi hangai, bèn taqnhùq hacam ka wa haq, ùh lòh wa haq, pang kô ta èh pi jah yŏc yiniq aih đòeq hu hnài cabô hòm. ");
INSERT INTO hrebt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wì hi creo ka wa mùt hòm, wì doe: Pi jah ràu yiniq Chuaq Jesus đòeq anoe đòeq hnài cabô hòm. ");
INSERT INTO hrebt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mahaq Phiero xam Jon padreo bàu: Cla pì hèm beq, maleq ma yeo troq enh ngèa ka Boc plình, tamàng bàu pì, loq tamàng bàu Boc plình? ");
INSERT INTO hrebt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Majah qmang aih da nhèn kô, ùh jah tàng ùh anoe trùh yiniq nhèn ma khoe hnoq khoe tàng!” ");
INSERT INTO hrebt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Aih ìq, wì hi taqnhùq hacam tam ka wa, khoe hi caqnaih, pi chaq trong hu rùp wa hòm, majah qmang aih mangai ta aih dìq hnoq kan halac neo loh, mangai leq mangai meh manè apôi đeh hra Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mangai ma khoe jah brêh aih khoe loe pôn jàt hanam. ");
INSERT INTO hrebt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Loh enh aih, wa bròc dèh ti ƀài oh daq, taqmon hlài dìq dŏng bàu ƀài pajàu kàn xam ƀài gucraq ma anoe ka wa. ");
INSERT INTO hrebt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jò dìq ka wì tàng bàu aih, wì mòeq bàu ti dabau waiq khàn ka Boc plình: “Boc Plình ma dìq jaq haqnhèq, Ìh khoe broq plình, taneh, diac rasìq xam rìm yiniq oe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ìh khoe canòm ka Yiang Hadròeh, tapoch ajang hacùng kan cadraq nhèn, aih bùa Đawit hapŏng ìh, rameh: “Hagleq rìm diac ma plôh nòeh, Hagleq phù cròng wiang hatình trong ùh loh qmòe cleq? ");
INSERT INTO hrebt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ƀài bùa ma padinh yòng. Ƀài cwan hangui pajùm ti dabau, Đòeq hu tablêq ka Chuaq aih Mangai ìh khoe xùt dàu”… ");
INSERT INTO hrebt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Joq qnàng Herôt xam Bônso Philat, mangai diac wì xam mangai Isorali khoe tagop ti dabau ta kô đòeq hu tablêq ka Hapŏng hadròeh ìh aih la Chuaq Jesus ìh ma khoe xùt dàu, ");
INSERT INTO hrebt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","đòeq hu broq rìm yiniq tì kŏng xam manoh ìh khoe thê deh adroe. ");
INSERT INTO hrebt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Manòeq kô, ìh tamàng bàu wì ma khoe hacam aih, am ka mangai hapŏng ìh bình manoh tanoq đòeq hnài trong da ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Hnhu qnoh tì kŏng ìh đòeq broq brêh kan yinìq, broq kan halac canòm ajang nòe yiniq hapŏng hadròeh ìh aih la Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Khoe ka waiq khàn, nòe wì haq tagop loh qmòe ka ralàng. Mangai leq mangai meh jah bình halùih Yiang Hadròeh, ùh lòm yùq qmòe cleq ka anoe trong da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Dìq dŏng ka ƀài mangai ma lùi, wì moeq manoh moeq cliac ti dabau. Pi cabô oe arènh kô dahwèq da au, mahaq dìq dŏng ka dahwèq wì pajùm dŏng ti dabau. ");
INSERT INTO hrebt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ƀài tiaq cla yŏc kan itai kàn hu anoe kan rìh hlài da Chuaq Jesus Christ; dìq ka wì jah xôq ramot kàn. ");
INSERT INTO hrebt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Taqne wì ma lùi Chuaq Jesus pi oe i cabô leq nan cleq hòm, majah qmang aih i ruàng i hnim, wì tech dŏng, jah toq leq dua wì wê ");
INSERT INTO hrebt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aràng đòeq ajang jènh ƀài mangai tiaq cla, khoe aih cabô nan pang leq axong pang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","I mòeq ngai yiniq haq Jôsep, ƀài mangai tiaq cla yiniq ònh ka haq aih Banaba (Banaba aih la kon calô da kan alòng), xinoe Lêwi, gùng Chipro, ");
INSERT INTO hrebt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","i mòeq haqnech ruàng, haq tech ruàng aih yŏc ƀac aràng đòeq ajang nòe jènh ƀài mangai tiaq cla. ");
INSERT INTO hrebt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mahaq i mòeq ngai yiniq haq Anania, pajùm manoh dèh ti mai haq aih la Saphira, tech dèh kùng hang, ");
INSERT INTO hrebt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ƀac aih wa đòeq hlài mòeq qnah, khoe aih mòeq qnah wa aràng đòeq ajang jènh ƀài mangai tiaq cla. ");
INSERT INTO hrebt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Phiero doe: Anania, aih hagleq Satan ma khoe bình ta manoh ìh, ìh loh qmòe ka qnùt Yiang Hadròeh, ƀac tech ruàng gleq ìh khoe lah đòeq qnah? ");
INSERT INTO hrebt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Jò ìh qnhòq tech aih ma ùh joq ruàng ìh? Jò khoe tech ìh đòeq dèh ƀac aih ma ùh jah? Trong aih mùt ta manoh ìh qmang leq? kô aih ùh xài ìh qnùt kon mangai, mahaq ìh qnùt Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Jò Anania tàng qmang aih haq tabùng cro ta haqneq cachìt hloe, dìq dŏng mangai ma loq ka bìac aih crè pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Khoe aih ƀài guradam hi trùh lom hanang haq aih, èh wì hi aràng lam catùh. ");
INSERT INTO hrebt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Jah piq jò atìq ka aih, mai haq mùt diq, haq ùh qnì neo loh i yiniq cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phiero doe ka haq: Anoe ka au beq, ajoq chôp Anania tech taneh jah toq kô? Saphira padreo bàu: Joq, jah toq qmat raq. ");
INSERT INTO hrebt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Phiero doe: Hagleq chôp mahùa mòeq manoh ti dabau đòeq hu nhro ngan Yiang Hadròeh da Chuaq? ");
INSERT INTO hrebt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Draq drình jò aih Saphira cro cachìt hloe ajang jènh Phiero. Ƀài wì guradam hlài enh gùng, hnoq haq khoe cachìt, wì hi tòng lam catùh haq hatìa ralùng dèh ŏng. ");
INSERT INTO hrebt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Dìq dŏng ka Tagop Hadròeh crè pi cajaq, yac ka wì qnoeq hìa hanoh qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jò aih i bàc kan halac broq loh enh tì kŏng mangai tiaq cla, dìq ka mangai tiaq hŏc tagop ti dabau tanòe hawài qmang ngo Salômon. ");
INSERT INTO hrebt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ùh i cabô hùa taqmùt ti mangai tiaq hŏc, yac ka phù cròng dêh bàu manè apôi. ");
INSERT INTO hrebt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mangai tiaq Chuaq èh rai bàc tam, gucalô xam gucadrì hanoh bàc. ");
INSERT INTO hrebt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Wì loh qmòe ka tòng aràng ƀài mangai yinìq đòeq ti trong lam, taqngùi ta driah, ta racoh, đòeq jò Phiero lam pagat trong aih, loq qmang leq dôq qmù haq jah pagat đeh toq biaq ƀiaq ngai hnha. ");
INSERT INTO hrebt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wì ma oe gùng ten aih hadai qnung dabau tŏc ta Jêrusalem, aràng ƀài mangai ùh hrŏc, mangai kiac pawè, dìq dŏng jah broq brêh. ");
INSERT INTO hrebt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jò aih, pajàu haqnhèq xam ƀài mangai tiaq haq (aih mangai Sađusê) ta manoh wì haq bình kan tajìq, ");
INSERT INTO hrebt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","rùp clêh ƀài mangai tiaq cla. ");
INSERT INTO hrebt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mahaq jò damang i mòeq ƀình plình da Chuaq pèh qmang qnoh mangai tiaq cla loh enh gùng. ");
INSERT INTO hrebt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ƀình plình doe: Lam beq! lam yòng tanòe hamlang hnim kùh waiq, anoe ka wì ta aih loq rìm bàu kan rìh kô. ");
INSERT INTO hrebt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mangai tiaq cla tàng toq aih nà, bu qngah wì haq mùt ta hnim kùh waiq, hi hnài wì ta aih. Mahaq, Pajàu haqnhèq xam ƀài bua haq trùh, wì creo ka dabau tagop ta hnim hadrah, hloe dìq dŏng xam ƀài gucraq mangai Isorali. Wì thê lình lam ta hnim cadrong rùp qnoh ƀài mangai tiaq cla loh enh gùng am ka wì haq. ");
INSERT INTO hrebt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mahaq jò ƀài lình trùh ta hnim cadrong, ùh hnoq ƀài mangai tiaq cla ta aih, wì hlài doe: ");
INSERT INTO hrebt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Nhèn hnoq qmang oe raq clenh cajap, ƀài lình rap oe raq yòng ajang trong qmang, mahaq jò pèh qmang enh dalam ùh i hnoq cabô. ");
INSERT INTO hrebt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cwan wèq hnim tagop xam ƀài pajàu tàng doe qmang aih, wì nòeh rai hamàih ùh qnì hagleq majah qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mahaq i mangai trùh doe: Hatau ƀài mangai pì cwan ma khoe rùp clêh, manòeq kô wì haq qnang yòng ta hnim kùh waiq, hnài wì ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Cwan wèq hnim kùh waiq xam ƀài bua haq, hi lam rùp ahlài mangai tiaq cla, mahaq ùh hùa dalam ka wì aih majah qmang aih wì haq crè ka mangai bàc ta aih loq hachùq wì haq xi hmo. ");
INSERT INTO hrebt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wì qnung mangai tiaq cla mùt yòng tanòe hadrah, Pajàu Haqnhèq bòch ƀài mangai tiaq cla: ");
INSERT INTO hrebt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nhèn khoe ùh lòh pì blinh ùh jah hnài yiniq Jesus am ka cabô, aih kiang pì hnài jàp jìa broq ka Jêrusalem bình dŏng trong da pì, pì enh taqmòq ka nhèn mahim mangai aih dôq haq dahrôq hlài ta nhèn qmòh? ");
INSERT INTO hrebt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phiero xam mangai tiaq cla maqnoeq padreo bàu: Nhèn ep iu tiaq bàu Boc Plình ùh hnau ka bàu kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Boc Plình da boc yaq nhèn khoe broq ka Chuaq Jesus, Mangai pì ma khoe tiang đình jêh cađac talong pagat rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Boc plình khoe dèch atŏc haq aih oe enh qma Boc Plình, broq Bùa, broq Chuaq, đòeq am manoh loq raxach xam kan paclaih yiniq lui ka mangai Isorali. ");
INSERT INTO hrebt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nhèn kô mangai panhìn hlài trong aih, tìah ka Yiang Hadròeh Boc Plình ma khoe am ka mangai iu bàu haq. ");
INSERT INTO hrebt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jò tàng bàu aih, wì cadrit qmòe haninh, nòeh pi cajaq, wì hatình ka dabau chaq trong jêh cađac ƀài mangai tiaq cla. ");
INSERT INTO hrebt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mahaq i mòeq ngai Pharisi, yiniq haq Gamalien, mangai hnài ranenh, haq aih bàc ngai iu camaih ka haq, yòng taqne nòe hadrah, thê wì qnoh ƀài mangai tiaq cla loh enh gùng mòeq ahyàc. ");
INSERT INTO hrebt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Khoe aih, haq doe: Dìq ka mangai Isorali, pì ep rabiaq haq oq trong pì padon tabroq ka wì kô. ");
INSERT INTO hrebt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Adroe kô nèh, i mòeq ngai yiniq haq Thêuđa, yòng doe đeh kô mangai broq gàu, ten jah pôn hrinh ngai tiaq haq: Wì jêh haq cachìt, dìq dŏng mangai tiaq haq hi pac lac dŏng, pulùch èh pi loh cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Atìq ka aih, i mòeq ngai yiniq haq Jiuđa, mangai Galili, yòng pagàu, aih wop jò bùa thê rèn hlài mangai ta diac haq jah toq leq, haq aih adràc bàc ngai tiaq rađeh, haq aih èh hanoh cachìt, mangai tiaq haq hadai haprah hapriang. ");
INSERT INTO hrebt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Manòeq kô au doe ka pì: Wia ma hangai ka wì kô, dôq da wì haq. Majah qmang aih tàng joq trong kô loh enh kon mangai, aih èh haq raliang đeh, ");
INSERT INTO hrebt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","mahaq tàng loh enh Boc Plình, pì ùh i broq cleq ka wì haq jah, aih budàng pì tamùa rađeh hu tajêh ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wì tiaq bàu haq, creo ka ƀài mangai tiaq cla mùt ta hnim, thê mangai blai wì aih, khoe èh blinh ùh am qmòe wì haq yŏc yiniq Chuaq Jesus đòeq hnài cabô hòm, khoe èh hi caqnaih wì lam. ");
INSERT INTO hrebt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ƀài mangai tiaq cla loh enh nòe hadrah, lem bùi ka rađeh khoe tajì ka jah broq mangai pòq kan xalep ka yiniq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hì leq hì meh, ta hnim kùh waiq, enh hnim kô trùh hnim tau, ƀài mangai tiaq cla toq anoe hnài yôt Bàu lem da Chuaq Jesus, aih raq Christ. ");
INSERT INTO hrebt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jò aih, mangai tiaq èh rai bàc, dài haq mangai Hêlenit mamùc ka mangai Hêbru, majah qmang aih wì ùh hmàng axong ka ƀài mangai hadrô da wì haq dahwèq acaq. ");
INSERT INTO hrebt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Wì Mòeq jàt baiq ngai creo tagop dìq dŏng ƀài mangai tiaq hŏc, wì doe: Cađac trong hnài bàu Boc Plình đòeq hu patìh trong ranenh acaq aih joq ùh troq. ");
INSERT INTO hrebt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Manòeq kô oh daq ràih yŏc taqne cla pì qmat tapèh ngai ma i tìang, bình Yiang Hadròeh, i kan rabiaq, khoe aih nhèn hi đòeq wì haq patìh trong kô. ");
INSERT INTO hrebt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aih èh nhèn jah toq waiq khàn jah dìq ka manoh broq dèh bìac. ");
INSERT INTO hrebt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bàu kô hatroq manoh dìq dŏng oh daq, wì hi patô Êtien, aih mangai bình manoh lùi xam Yiang Hadròeh, Philip, Bôcoro, Nicanô, Timôn, Bamêna xam Nicôla, aih mangai Antiôt neo wìh tiaq trong mangai Juđa; ");
INSERT INTO hrebt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","wì aràng tapèh ngai aih loh enh ngèa ƀài mangai tiaq cla. Ƀài mangai tiaq cla waiq khàn khoe aih roh tì ta wì aih. ");
INSERT INTO hrebt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bàu Boc Plình chàc rai èh rai hangai, ta Jêrusalem mangai tiaq rai bàc. I bàc ngai pajàu hanoh tiaq. ");
INSERT INTO hrebt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Jò aih, Êtien jah bình xôq yiang xam cwìang itai, broq bàc trong halac taqne phù cròng. ");
INSERT INTO hrebt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mahaq i toq ƀiaq ngai enh hnim tagop wì ma creo dèh: Tagop da mangai pi tawac, xam ƀài mangai ta Siren, mangai gùng Alecxanđo, xam mangai Juđa oe ta Silisi, gùng Asi, ƀài aih yòng tarahen ka Êtien. ");
INSERT INTO hrebt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mahaq wì ùh blêq kan rabiaq enh Yiang Hadròeh am ka haq jò haq capoch. ");
INSERT INTO hrebt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aih ìq wì hi lam baxrùq wì qnoeq, rameh: Nhèn khoe tàng haq kô tapoch qmèq ka Môise xam Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wì patùt ƀài phù cròng, ƀài gucraq xam ƀài mangai hnài ranenh, khoe aih wì hi clàm cadêh mùt rùp Êtien, aràng haq loh yòng enh ngèa nòe hadrah. ");
INSERT INTO hrebt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wì hi qnoh dèh ƀài mangai yòng tapoch qmùt ka haq, ƀài aih doe rameh: Mangai kô toq capoch troq nòe hadròeh xam ranenh. ");
INSERT INTO hrebt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Majah qmang aih nhèn khoe tàng haq doe: Jesus mangai Naxaret raliang cađac nòe kô èh rai broq tablòq hlài ranenh rìh acaq Môise ma khoe đòeq hlài ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jò aih ƀài mangai hangui tanòe hadrah dìq chrìh ngan Êtien, hnoq hadrò haq tìah ka hadrò ƀình plình. ");
INSERT INTO hrebt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Craq pajàu haqnhèq bòch Êtien: Ajoq qmang aih loq ùh? ");
INSERT INTO hrebt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Êtien padreo bàu: Wì daq xam ƀài baq, pì tamàng au anoe kô! Boc plình da kan ranhòm khoe mahno rađeh ka kan cadraq bèn aih Apraham jò haq oe raq ta gùng Mêso-bôtami, adroe ka haq rìh ta Charan, ");
INSERT INTO hrebt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Boc plình doe: “Drah cađac gùng kô cađac hloe xam oh daq ìh hu lam trùh tanòe au patô am ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jò aih haq hi loh enh Kan-đê lam trùh ta Charan. Atìq ka baq haq cachìt, enh aih Boc plình qnung haq trùh ta gùng pì qnang oe manòeq. ");
INSERT INTO hrebt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Boc plình ùh am ka haq cleq ta gùng kô, mòeq haqnech taneh toq capiang jènh dua ùh i, mahaq Boc plình i tèu am ka haq xam xinoe haq gùng kô, yac ka jò aih haq qnhòq i kon. ");
INSERT INTO hrebt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Boc plình doe ka haq rameh: Xinoe ìh broq đeh tamoe tanòe taneh diac wì qnoeq. Gùng aih rùp wì haq broq hapŏng dìc rai baxa pani wì haq pôn hrinh hanam. ");
INSERT INTO hrebt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Boc plình doe: Mahaq au tahadrah ka ƀài mangai ma khoe rùp xinoe ìh broq hapŏng dìc aih, khoe èh wì haq loh enh gùng aih đòeq kùh waiq au tanòe kô. ");
INSERT INTO hrebt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Khoe aih Boc plình am ka haq tajao ramènh kat akia. Aih ìq, jò Apraham khoe i ka Ysac, haq broq ramènh kat akia kaYsac jò khoe jah rahem hì. Ysac broq ramènh kat akia ka Jacôp, èh Jacôp broq ramènh aih ka mòeq jàt baiq ngai kan cadraq. ");
INSERT INTO hrebt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Mòeq jàt baiq ngai kan cadraq tajênh ka Jôsep, wì rùp tech haq broq hapŏng ta gùng Êdip. Mahaq Boc plình oe ti haq. ");
INSERT INTO hrebt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Rai paclaih haq khoe kan nanxa, broq ka haq jah kan tamèt, kan rabiaq enh ngèa Pharaôn, bùa Êdip, bùa aih dèch haq broq cla craq cwan wèq dìq dŏng tagùng aih wèq hloe xam hnim bùa. ");
INSERT INTO hrebt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Qnhòng aih, i kan pangot kàn ta gùng Êdip xam gùng Cana-an, nanxa joq qnàng, kan cadraq bèn chaq ùh loh qmòe dahwèq acaq. ");
INSERT INTO hrebt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacôp hìa gùng Êdip i qmau, haq hi thê kan cadraq bèn loh ta aih yàng adroe. ");
INSERT INTO hrebt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Yàng atìq, ƀài oh daq hi canau ka haq, aih Pharaôn men loq ka xinoe Jôsep. ");
INSERT INTO hrebt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Atìq ka aih, Jôsep thê wì đìh qnoh dèh baq xam wì ta hnim dìq dŏng jah tapèh jàt padam ngai. ");
INSERT INTO hrebt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jacôp loh oe ta Êdip, haq cachìt ta aih, ƀài cadraq bèn hadai qmang aih, ");
INSERT INTO hrebt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Atìq ka aih èh, jah ahlài ta Sichem catùh tanòe ralùng Apraham ma khoe yŏc ƀac rot hlài enh nang noe Hêmo oe ta Sichem. ");
INSERT INTO hrebt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Mahaq ten trùh jò Boc plình hu pagêh deh bàu haq ma khoe tèu ka Apraham, ƀài mangai bèn oe ta gùng Êdip èh rai bàc. ");
INSERT INTO hrebt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Trùh jò gùng aih i mòeq ngai bùa qnoeq ùh loq ka Josep. ");
INSERT INTO hrebt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Haq aih chaq trong hu palùng đac xinoe Isorali rai baxa kan cadraq bèn, thê wì cadraq bèn tèm cađac kon qyoh neo hauang, dôq cachìt đac dŏng. ");
INSERT INTO hrebt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Môise hanoh jah hauang jò aih diq; haq yeo alàng ka kon qyoh qnoeq, jah ban dèh ta hnim baq piq khê. ");
INSERT INTO hrebt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Trùh hì wì ma ep cađac haq, kon cadrì da Pharaôn hi dèch haq tŏc enh diac, ban broq deh kon. ");
INSERT INTO hrebt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Môise hŏc yŏc dŏng kan rabiaq da mangai Êdip, enh bàu capoch trùh yiniq broq dìq rabiaq. ");
INSERT INTO hrebt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mahaq jò haq pôn jàt hanam, ta manoh haq hmàng enh lam hmàih deh ka oh daq aih mangai Isorali. ");
INSERT INTO hrebt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Môise hnoq i mangai baxa mòeq ngai oh daq ta aih, haq wiang deh ti oh daq jêh cachìt mangai Êdip đòeq hu patem chau. ");
INSERT INTO hrebt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Haq hèm dèh oh daq loq Boc plình khoe yŏc haq đòeq dèch paclaih wì, mahaq wì ùh qnì. ");
INSERT INTO hrebt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Trùh hì atìq, jò wì qnang tajêh dabau, Môise thia haten hu plah, haq doe: Òq wa, oh daq wìa ka jêh hrìn dabau qmang qmat? ");
INSERT INTO hrebt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mangai ma jêh deh bua caqnhùt đac Môise rai doe: Cabô khoe dèch ìh broq cwan đòeq hadrah nhèn? ");
INSERT INTO hrebt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ahìaq ìh enh jêh đac nhèn qmang ka mangai Êdip hì nèh? ");
INSERT INTO hrebt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Môise bu tàng qmang aih haq drah cadàu amot tagùng Mađi-an, ta aih haq i baiq ngai kon calô. ");
INSERT INTO hrebt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Atìq ka aih, pôn jàt hanam, mòeq ƀình plình loh ta haq, tanòe hawit trong wang Sina-i, taqne pla ùnh cheo xèm yila. ");
INSERT INTO hrebt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Môise hnoq qmang aih, hamàih pi cajaq, haq thia ka haten đòeq hu ngan, haq tàng bàu Chuaq doe: ");
INSERT INTO hrebt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Au kô raq Boc plình da Apraham, da Ysac, da Jacôp. Môise crè pi cajaq, ùh hùa blèch ngan. ");
INSERT INTO hrebt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Chuaq doe: “Drah lêh jai ìh qmat, majah qmang aih nòe ìh yòng qmat, aih nòe taneh hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Au joq khoe hnoq kan nanxa mangai da au oe ta gùng Êdip, au khoe tàng bàu wì haq hràng, hacô au khoe loh hu paclaih wì haq. Manòeq lam tacô, au hu thê ìh hlài ta Êdip. ");
INSERT INTO hrebt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Môise aih mangai wì khoe qnoh đac, wì doe: Cabô khoe dèch ìh broq cwan đòeq hadrah nhèn? Aih raq mangai Boc plình khoe thê broq gàu broq mangai paclaih, canòm ka mòeq ƀình plình loh doe ka haq ta xèm yila. ");
INSERT INTO hrebt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aih raq mangai khoe qnung wì haq loh enh Êdip, broq bàc teo halac kan hamàih ta gùngÊdip, ta diac Raxìq gòh, xam pôn jàt hanam tanòe braih kàn. ");
INSERT INTO hrebt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Môise kô raq ma khoe anoe ka mangai Isorali: Atìq kô èh Boc Plình paqnàng taqne pì oh daq, mòeq ngai pajàu tìah ka au ");
INSERT INTO hrebt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Aih raq Mangai khoe oe ti Isorali tanòe braih kàn, oe ti ƀình plình yiang ma khoe capoch tuàng ka haq xam yaq boc bèn ta bui wang Sina-i. Haq khoe yŏc bàu kan rìh đòeq hu am hlài ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Aih raq mangai yaq boc bèn ùh iu qmòe blinh bàu haq, cađac haq đòeq hu ta ngèa dèh manoh ta gùng Êdip, ");
INSERT INTO hrebt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","wì anoe ka Arôn: Broq ƀòe kiac hu lam adroe ka nhèn beq, majah qmang aih Môise mangai ma khoe qnoh nhèn loh enh gùng Êdip, pi qnì haq khoe glàm yiniq cleq taleq hnha. ");
INSERT INTO hrebt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ta ƀài hì aih, wì broq mòeq toq radua qmù ƀo kon, dèch ramènh ka radua qmù rai lem bùi dèh ka yiniq broq loh enh tì kŏng cla. ");
INSERT INTO hrebt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Boc plình hi cađac wì haq, dôq da wì haq kùh waiq mat mahì, mat khê xam ƀài halŏng ta trŏc, qmang ka ƀàu khoe achìh ta hset pajàu rameh: Dìq ka mangai Isorali, pôn jàt hanam nòe braih kàn, Pì i hmaq dèch ka au ramènh tadreo leq ùh, ");
INSERT INTO hrebt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Jò pì tòng ranòh da Molŏc, Xam halŏng da kiac Rom phan, Aih ƀài radua qmù cla pì broq loh đòeq hu kùh waiq qmòh? Qmang aih èh au hadai lam palac pì ta gùng Babilôn. ");
INSERT INTO hrebt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Hnim ranòh kùh waiq oe ti yaq boc bèn tanòe hawit, qmang ka Chuaq khoe thê Môise broq tiaq dua haq khoe hnoq. ");
INSERT INTO hrebt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Atìq ka aih, yaq boc bèn khoe aràng hnim ranòh kùh waiq aih, tiaq Josuê mùt tagùng wì haq ma khoe blah yŏc enh tì kŏng ƀài mangai diac wì, Boc plình ma khoe hnan qnoh enh ngèa wì haq, hnim ranòh kùh waiq aih oe yôt ta aih trùh qnhòng bùa Đawit, ");
INSERT INTO hrebt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","aih mangai jah xôq ramot enh ngèa Boc plình, haq bòch mòeq nòe hu đòeq ka Boc plình da Jacôp oe. ");
INSERT INTO hrebt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Khoe aih, bùa Salomôn broq am ka Chuaq mòeq toq hnim. ");
INSERT INTO hrebt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mahaq Yiang Dìq Jaq Haqnhèq ùh oe ta hnim broq enh tì kŏng kon mangai, tìah ka bàu pajàu khoe doe: ");
INSERT INTO hrebt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Chuaq doe: Trŏc aih gèq au, Taneh aih nòe au roh jènh. Hnim qmang leq pì broq ka au, I nòe leq dôq ka au padài? ");
INSERT INTO hrebt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ma ùh joq tì kŏng au broq loh dìq dŏng rìm yiniq kô qmòh?” ");
INSERT INTO hrebt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Wùih, ƀài mangai cadoq ranŏng, manoh xam don qnhòq kat akia meh! Pì àu tablêq yôt ka Yiang Hadròeh, kan cadraq pì qmang leq, pì hadai qmang aih! ");
INSERT INTO hrebt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","I pajàu leq kan cadraq pì ùh rùp? Wì hadai khoe jêh cađac ƀài mangai pajàu anoe trùh Mangai taq atoq, manòeq kô pì raq khoe rùp jêh cađac Mangai aih; ");
INSERT INTO hrebt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","pì khoe yŏc ranenh anoe qnoh xi bàu ƀình plình, mahaq pì ùh wèq tiaq ranenh aih! ");
INSERT INTO hrebt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wì tàng bàu aih, ta manoh nòeh pi cajaq, wì cadrit qmòe hanenh ka Êtien. ");
INSERT INTO hrebt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mahaq Êtien jah bình Yiang Hadròeh, haq qngoc ngan ta plình, hnoq kan ranhòm Boc plình, hnoq Chuaq Jesus yòng enh apah qma Boc plình; ");
INSERT INTO hrebt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","haq doe: Hatau, au hnoq Diac plình tapèh, i Kon mangai yòng apah qma Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Jò aih, ƀài wì cajiah cadêh rai bàng don, wì glàm ta haq, ");
INSERT INTO hrebt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","hua qnoh Êtien enh gùng ka plài, wì yŏc hmo đàp rachùq haq. Ƀài mangai yòng capoch dech ka Êtien yŏc deh eo yôh đòeq ajàng nòe jènh mòeq ngai guradam yiniq haq aih Saulo. ");
INSERT INTO hrebt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jò wì oe raq đàp haq, Êtien waiq khàn: Waiq Chuaq Jesus ìh đìh yŏc mahua au. ");
INSERT INTO hrebt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Khoe aih, haq kùn cràng rai capoch cadêh: Waiq Chuaq, apaq taqmòq yiniq lui kô ka wì! Bu khoe ka bàu aih, haq hi kùi. ");
INSERT INTO hrebt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Êtien cachìt aih troq ka manoh Saulò, jò aih Tagop Hadròeh ta Jêrusalem glàm kan haƀo kàn, enh gùng ka ƀài mangai tiaq cla, dìq dŏng ka mangai lùi Chuaq ep cadàu prah priang jàp gùng Juđê xam gùng Samari. ");
INSERT INTO hrebt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mahaq, ƀài mangai dìq ka manoh iu yùq ka Boc plình catùh hanang Êtien rai crò hmoe ka haq. ");
INSERT INTO hrebt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mahaq pang aih, Saulo àu raliang đac Tagop Hadròeh. Lam enh hnim kô trùh hnim tau haq ti hua qnoh rùp clêh gucalô xam gucadrì. ");
INSERT INTO hrebt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ƀài mangai ma khoe cadàu paclac trùh taleq anoe Bàu lem ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip hadai qmang aih, haq cadàu loh ta Samari rai anoe Chuaq Jesus Christ ka wì ta aih, ");
INSERT INTO hrebt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","wì ta aih tàng bàu haq hnài rai hnoq kan halac haq broq, dìq ka wì mòeq manoh tamàng bàu haq, ");
INSERT INTO hrebt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","i ƀòe kiac chŏc breo cadêh cadàu loh enh chac bàc ngai, mangai cwê jah brêh hanoh bàc. ");
INSERT INTO hrebt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Dài aih, ta gùng aih i kan lem bùi kàn. ");
INSERT INTO hrebt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jò aih, gùng aih i mòeq ngai yini haq Simôn, broq pajàu tadreo, dìq ka mangai Samari hamàih đeh hra ka haq. Haq doe rađeh kô mangai i tìang i bang. ");
INSERT INTO hrebt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Enh guqyoh trùh gucraq dìq manè dèh haq, wì doe: Mangai kô raq kan itai kàn da Boc plình, ");
INSERT INTO hrebt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wì tiaq haq, majah qmang aih khoe dùnh wì hamàih ta manoh jò wì hnoq trong haq ti blàih blŏng. ");
INSERT INTO hrebt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Yàng jò wì ma hi lùi Philip aih mangai hnài Bàu lem Diac plình, lùi yiniq Chuaq Jesus, mangai gucalô xam gucadrì dìq jah broq ƀaptem. ");
INSERT INTO hrebt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simôn hadai lùi Chuaq, atìq ka jah broq ƀaptem haq hi oe hloe ti Philip, hnoq ƀài kan halac, haq hamàih pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mòeq jàt baiq ngai tiaq cla dua oe raq ta Jêrusalem, hìa ta gùng Samari khoe yŏc bàu Boc plình, wì haq thê Phiero xam Jon trùh ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wa trùh ta aih, waiq khàn ka mangai neo tiaq, dôq wì aih jah yŏc Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Majah qmang aih Yiang Hadròeh qnhòq loh ti cabô taqne wì aih, wì haq toq canòm ka yiniq Chuaq Jesus đòeq jah broq ƀaptem. ");
INSERT INTO hrebt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wa Phiero wa Jon roh tì ta chac mangai neo tiaq, dìq ka wì hi jah yŏc Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simôn hnoq wa mangai tiaq cla đòeq tì ta chac cabô mangai aih hi jah Yiang Hadròeh, haq hi yŏc ƀac dèch ka wa rai doe: ");
INSERT INTO hrebt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Am ka au kan itai aih diq, đòeq mangai leq au roh tì haq aih hi jah Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mahaq Phiero doe: Ƀac ìh qmat thê haq hnhung lùch tiaq cla ìh, majah qmang aih ìh hèm dèh yŏc ƀac canau plàih rot kan tabàih enh Boc plình! ");
INSERT INTO hrebt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ìh ùh jah pajùm cleq ti nhèn, majah qmang aih manoh cliac ìh ùh hnhuh lem enh ngèa Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Drah loq raxach cađac deh kan dù qmat đòeq hu waiq khàn ka Boc plình, dôq kan qmèq ta manoh ìh jah caqnaih. ");
INSERT INTO hrebt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Majah qmang aih, au hnoq ìh qnang rìh oe ta clong mat xang, talong clang kan dù. ");
INSERT INTO hrebt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simôn padreo bàu: Au ngèh đeh ka chôp raq waiq khàn Boc plình am ka au, dôq au ùh hìaq glàm đeh ƀài yiniq chôp ma anoe aih. ");
INSERT INTO hrebt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Atìq ka wa anoe hnài bàu Boc plình rai paqnoh Chuaq Jesus am ka wì, wa Phỉerò wa Jon hi wìh hlài ta Jêrusalem, rai lam rai hnài Bàu Lem ta bàc plài da mangai Samari. ");
INSERT INTO hrebt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jò aih, i mòeq ƀình plình da Chuaq doe ka Philip: “Drah yòng beq! lam trong apah qma enh Jêrusalem loh ta Gaxa. Trong aih hawit.” ");
INSERT INTO hrebt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Haq padinh yòng hi lam. Ti trong lam haq hnoq mòeq ngai cwan khoe xon Êthiopi, cwan patìh ka Canđac, aih bùa cadrì diac Êthiôpi, cwan aih wèq dìq dŏng kùng hang bùa aih. Haq khoe tŏc kùh waiq ta Jêrusalem, ");
INSERT INTO hrebt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jò dang hlài haq hangui ta xê, đŏc ta hset pajàu Êsai. ");
INSERT INTO hrebt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yiang Hadròeh doe ka haq: “Drah lam haten tem xê axêh tau.” ");
INSERT INTO hrebt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Philip cadàu ka haten, tàng mangai Êthiopi aih đŏc hset Êsai, aih haq hi bòch: Ìh aloq tàng bàu ìh ma đŏc aih ùh? ");
INSERT INTO hrebt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Cwan aih doe: Ùh i cabô anoe ka au broq qmang leq au maloq tàng? Cwan aih hi pachùh Philip tŏc hangui tìa cla haq. ");
INSERT INTO hrebt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Cwan aih đŏc ajang kô ta hset Hadròeh: “Wì khoe hua haq tìah ka kon trìu trùh nòe xah jam Tìah kon trìu làu enh ngèa mangai got xàc, Haq ùh dahah hacùng, ");
INSERT INTO hrebt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Jò haq loh đeh ka hamoq aih kan taq atoq da haq wì khoe cađac. Oe i cabô ma qmon hlài qnhòng da haq? Majah qmang aih kan rìh haq ta crŏng taneh wì khoe dèch đac”. ");
INSERT INTO hrebt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Cwan khoe xon aih doe: Au bòch ìh, pajàu aih anoe trùh cabô? Ahìaq haq anoe cla rađeh, ùh meh haq anoe trùh mangai leq? ");
INSERT INTO hrebt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Philip hi patep ajang nòe Hset Hadròeh cwan ma đŏc aih đòeq hu anoe Chuaq Jesus am ka cwan aih loq. ");
INSERT INTO hrebt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Wa qnang lam ti trong, glàm nòe i diac, cwan aih bòch: Hacô diac kô, i hìaq i cleq khech tàt au broq ƀaptem loq ùh? ");
INSERT INTO hrebt_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip doe: Tàng joq ìh dìq ka manoh lùi aih jah. Cwan khoe xon aih doe: Au lùi Chuaq Jesus Christ aih Kon Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Haq thê xê axêh yòng ajang aih, dìq baiq wa loh ta diac, Philip hi broq ƀaptem am ka cwan jang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jò tŏc enh diac, Yiang Hadròeh da Boc plình hi aràng Philip taqnoeq, cwan pi oe hnoq haq hòm, mahaq dua rai hlài rai lem bùi. ");
INSERT INTO hrebt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Yàng Philip aih wì hnoq haq ta Axôt, enh aih haq lam ta Sêsarê, trùh pang leq haq hnài Bàu Lem ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jò aih, Saulo ùh hêq ka hacam ti chaq jêh cađac mangai tiaq Chuaq Jesus, haq trùh ti mangai pajaù haqnhèq, ");
INSERT INTO hrebt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","bòch jàiq enh haq aih hu aràng roc hnim tagop qyoh ta gùng Đamat, waq toq hnoq magai leq tiaq Trong bàu lem yac ka mangai calô, mangai cadrì, kàt ahlài dìq ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mahaq jò Saulo qnang lam ten trùh ta Đamat, ka doe i kan qngah enh plình sreo qngah du danh ka haq. ");
INSERT INTO hrebt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Haq cro ta haqneq rai tàng bàu tapoch ka rađeh: “Saulo, Saulo, hagleq ìh majah ti chaq rùp au?” ");
INSERT INTO hrebt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Haq bòch: Waiq Chuaq, Ìh cabô? Bàu aih tèu: “Au kô raq Jesus mangai ìh ma chaq rùp baxa; ");
INSERT INTO hrebt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","mahaq manòeq kô yòng beq, mùt ta plài, i mangai anoe ka ìh trong ìh ma ep broq. ");
INSERT INTO hrebt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dìq ka mangai lam mòeq qmang ti haq, yòng ta aih hi haglènh pi jah tapoch qmòe cleq, wì tàng bàu tapoch mahaq ùh i hnoq qmòe cabô. ");
INSERT INTO hrebt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo àu yòng enh taneh, mat aih blèch mahaq ùh xau hnoq qmòe cleq. Wì carùp tì haq qnung haq mùt ta Đamat ");
INSERT INTO hrebt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","haq oe ta aih piq hì, mat ùh xau hnoq cleq, ùh dùh ka acaq ùh dùh ka ôq. ");
INSERT INTO hrebt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jò aih ta Đamat i mòeq ngai tiaq hŏc yiniq haq Ana-nia, ta kan mahno Chuaq creo ka haq: “Anania!” Haq padreo bàu: Chuaq au! hacô au kô. ");
INSERT INTO hrebt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Chuaq doe ka haq: “Drah yòng beq, lam ta trong wì ma creo Trong jang, chaq Saulo mangai Tacso, oe ta hnim Juđa, majah qmang aih haq qnang waiq khàn”, ");
INSERT INTO hrebt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","haq khoe hnoq i mòeq ngai yiniq Ana-nia, mùt ta hnim yŏc tì bèq ta chac haq, dôq haq mat haq jah qngah hlài. ");
INSERT INTO hrebt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania padreo bàu: Waiq Chuaq au! Au tàng bàc ngai anoe hlài mangai kô khoe broq kan haƀo ka bàc ngai hadròeh ìh ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Manòeq haq lam tacô, haq jah dŏng cwìang enh wì mangai pajàu haqnhèq, đòeq rùp kàt dìq dŏng mangai ma creo dang yiniq ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mahaq Chuaq doe ka Ana-nia: “Drah lam beq, majah qmang aih au khoe ràih mangai kô đòeq broq ranac da au, hu anoe yiniq au ka mangai diac wì, ka ƀài bùa, hloe xam mangai Isorali, ");
INSERT INTO hrebt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Au ji doe dôq haq loq kô èh taiq yiniq au haq ep chìuq xalep dàng leq cadèh. ");
INSERT INTO hrebt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ana-nia hi yòng lam, haq mùt ta hnim, khoe aih haq yŏc tì roh ta chac Saulo rai doe: Daq Saulo, Chuaq aih Jesus ma khoe loh ti ìh ti trong jò ìh lam tacô, khoe thê au trùh, dôq mat ìh jah qngah hlài rai jah bình Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tajòe qmòe jò aih i cleq tìah ka cachep clìh enh mat Saulo aih mat haq hi hnoq. Haq padinh yòng dôq wì broq ƀaptem ka rađeh. ");
INSERT INTO hrebt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jò haq khoe acaq aih haq hi tadêh hlài. Saulo oe ta Đamat toq biaq hì ti ƀài mangai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Haq drah hnài roc him tagop qyoh: Chuaq Jesus aih kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ƀài mangai tàng bàu haq aih, dìq loh ka hamàih, wì doe: Ma ùh xài haq qmat raq mangai yòng rùp baxa dìq dŏng ka oh daq ta Jêrusalem ma creo dang yiniq kô, ma ùh joq haq lam tacô hu rùp kàt ahlài wì ka ƀài mangai pajàu kàn qmòh? ");
INSERT INTO hrebt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mahaq Saulo rai èh rai cajap manoh, haq goh bàu ƀài mangai Juđa ma oe ta Đamat, haq doe ka wì: Chuaq Jesus aih raq Christ. ");
INSERT INTO hrebt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bàc hì atìq ka aih, ƀài mangai Juđa hatình ka dabau chaq trong jêh cađac Saulo. ");
INSERT INTO hrebt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mahaq i mangai bahìa ka Saulo loq trong mangai Juđa ma ta hatình. Wì tàt dìq dŏng roc qmang ngo đoèq hu gòm jêh đac Saulo. ");
INSERT INTO hrebt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yàng èh jò damang, ƀài mangai tiaq hŏc yŏc rajo kàn cadrai qnoh haq loh enh gùng ka panàt canàng. ");
INSERT INTO hrebt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jò Saulo khoe trùh ta Jêrusalem, haq enh taqmùt ti mangai tiaq hŏc ta aih, mahaq wì hòq ka haq, ùh lùi haq hadai khoe broq mangai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ƀanaba hi ajèn haq, qnung haq trùh enh ngèa ƀài mangai tiaq cla rai taqmon dôq wì aih loq ti trong Chuaq Jesus khoe loh anoe ka Saulo qmang leq, ta Đamat haq khoe hnài yiniq Chuaq Jesus, ùh lòm yùq crè qmòe cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pang aih, Saulo thia lam hlài ti mangai tiaq hŏc ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Canòm ka yiniq Chuaq Jesus haq capoch tuàng ùh yùq qmòe cleq. Haq hadai tarahen ka mangai Hêlênit, mahaq wì aih chaq trong hujêh cađac haq. ");
INSERT INTO hrebt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jò oh daq hìa qmang aih, wì aràng haq trùh ta Sêsarê, èh thê haq lam ta gùng Tacso ");
INSERT INTO hrebt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Qmang aih, dìq ka Tagop Hadròeh tagùng Juđê, gùng Galili xam gùng Samari jah kan lem bùi catèm, jah hagau, rìh ta kan loq iu Chuaq, canòm ka Yiang Hadròeh wiang, mangai tiaq èh rai bàc tam. ");
INSERT INTO hrebt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jò aih, Phiero lam jàp gùng, haq trùh hmàih ka mangai oh daq ta Chuaq tagùng Lyđa. ");
INSERT INTO hrebt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ta aih i mòeq ngai pen yiniq haq Ênê, kùi mòeq nòe ta racoh khoe rahim hanam. ");
INSERT INTO hrebt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phiero doe ka haq: Daq Ênê! Chuaq Jesus Christ broq ka ìh jah brêh, drah yòng beq, ti don da ìh racoh ìh ma kùi qmat. Draq adrình hloe jò aih, haq padinh yòng. ");
INSERT INTO hrebt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dìq ka mangai ta Lyđa xam gùng sarôn hnoq qmang aih wì hi tawìh hlài ta Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Oe ta Jopbê, taqne mangai tiaq hŏc, i mòeq ngai cadrì yiniq haq Tabitha, (bàu Gorec aih Đôca), haq broq bàc yiniq lem rai loq ti am ka mangai pa. ");
INSERT INTO hrebt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jò aih, haq ùh hrŏc èh hi cachìt. Wì ti ti qnheo hanang haq, khoe hi ta qngùi haq tabluàng talàu qnhèq. ");
INSERT INTO hrebt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mangai tiaq hŏc tàng doe Phiero qnang oe ta Lyđa, haten ka Jopbê, wì hi thê baiq ngai lam akhen ka haq, wa doe: Ìh drah lam rênh haq. ");
INSERT INTO hrebt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Phiero hi yòng lam ti wa aih. Jò trùh ta aih, wì atŏc haq ta bluàng haqnhèq, dìq dŏng ƀài mangai cadrì hadrô yòng dudan ka haq rai hmoe, wì patô ka haq ngan ƀài eo yôh xam ƀài eo hlaq, Đôca khoe jìp am ka wì jò haq oe rìh. ");
INSERT INTO hrebt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Phiero thê wì loh dŏng enh gùng, khoe aih haq hacùn cràng hu waiq khàn, haq wìh tajang ka hanang, rai doe: Tabitha, yòng beq! Mangai gucadrì aih hi blèch mat hnoq Phiero, haq drah yòng qmòe ka rênh. ");
INSERT INTO hrebt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Phiero hnhu tì ka haq carùp hu dèch haq yòng, èh haq ti creo ka wì ma lùi Chuaq ta aih, hloe xam ƀài mangai cadrì hadrô, dôq wì hnoq haq aih khoe rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yiniq aih tagùng Jopbê wì hìa dìq dŏng. Aih ìq, majah i bàc ngai lùi Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Phiero oe ta Jopbê bàc hì, haq oe ta hnim mangai thòq broq akia yiniq haq Simôn. ");
INSERT INTO hrebt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tagùng Sêsarê, i mòeq ngai yiniq haq aih Kot-nai, broq cla craq wèq mòeq hrinh ngai lình Italia. ");
INSERT INTO hrebt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cla haq xam cadraq haq dìq rìh rabiaq alàng loq iu yùq Boc Plình, loq tabàih am ka mangai hamoq, waiq khàn ka Boc plình ùh lah catech. ");
INSERT INTO hrebt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","I mòeq hì, wop qnah ta piq jò di xèq, ta kan mahno haq hnoq i mòeq ƀình plình enh Boc plình trùh doe ka haq: “Kot-nai!” ");
INSERT INTO hrebt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Mat haq ngan ta ƀình plình rai tarìt tariang, haq padreo bàu: Waiq chuaq! Ahìaq i yiniq cleq ùh? Ƀình plình doe: “Bàu waiq khàn xam kan tabàih da ìh am ka mangai hamoq tŏc khoe trùh ta Boc plình, Haq khoe hmàng da ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Manòeq kô drah thê mangai lam ta Jopbê, akhen ka mòeq ngai yiniq haq Simôn, mangai wì ma creo Phiero aih. ");
INSERT INTO hrebt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Manòeq kô haq oe ta hnim Simôn, aih mangaih thòq broq akia, hnim haq ten kênh diac raxìq.” ");
INSERT INTO hrebt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jò ƀình plình ma tapoch ka haq khoe lam, Kot-nai hi creo deh baiq ngai hapŏng xam mòeq ngai lình ma dìq dèh manoh ka haq, ");
INSERT INTO hrebt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","haq anoe hlài ka wì tàng dìq dŏng, khoe aih haq hi thê lam ta Jopbê. ");
INSERT INTO hrebt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Hì atìq wì piq ngai qnang lam ti trong, jò qne hì wì lam ten trùh ta Jopbê, Phiero tŏc enh kùa po hnim hu waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Haq loh ka pangot enh acaq, jò wì qnang padon qnoh ka haq acaq, haq loh ka pi hmàng pi hmat. ");
INSERT INTO hrebt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Haq hnoq plình tapèh i cleq tìah taiq ka blah mù kàn wì ma rùp dèch pôn toq mùm cadrai loh ta taneh. ");
INSERT INTO hrebt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Haq hnoq ta aih i rìm ngè rìh i pôn toq jènh, rìm yiniq rìh loq rai pan rai moq ta taneh, xam chìm ta trŏc. ");
INSERT INTO hrebt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Khoe aih i bàu doe ka haq: “Phiero! drah yòng beq, broq jam qmat hu acaq”. ");
INSERT INTO hrebt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mahaq Phiero padreo bàu: Chuaq au! ùh đòh, majah qmang aih au ùh lah acaq adrech cleq ma ùh hruah. ");
INSERT INTO hrebt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Bàu aih doe tam ka haq: “Yiniq cleq Boc plình khoe broq haq hadròeh, aih paq ngan haq oe raq ùh hruah”. ");
INSERT INTO hrebt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bàu aih doe ka haq piq yàng, khoe èh cleq aih hi dèch atŏc hlài ta plình. ");
INSERT INTO hrebt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Jò Phiero oe raq hèm trùh kan mahno đeh ma khoe hnoq aih, ƀài mangai Kot-nai thê lam, chaq khoe hnoq hnim Simôn, khoe yòng qmòe ajang trong qmang. ");
INSERT INTO hrebt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wì creo bòch: Simôn wì ma creo Phiero aih ajoq oe ta hnim kô loq ùh? ");
INSERT INTO hrebt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Phiero oe raq hèm yôt ta kan mahno, Yiang Hadròeh doe ka haq: “Hatau i piq ngai chaq ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Drah yòng loh lam ti wì beq! Apaq rangòt, majah qmang aih au kô ma khoe thê wì haq.” ");
INSERT INTO hrebt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Phiero hi loh ta wì, haq doe: Hacô au kô, mangai pì ma qnang chaq, pì trùh i yiniq cleq ùh? ");
INSERT INTO hrebt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wì padreo bàu: Claq craq nhèn Kot-nai, aih mangai taq atoq loq yùq crè ka Boc plình, mangai Juđa dìq capoch lem ka haq, i mòeq ƀình plình hadròeh anoe ka haq, thê nhèn lam tacô akhen waq qmòe ka jah ìh hlài deh ta hnim haq, đòeq tamàng bàu ìh hnài. ");
INSERT INTO hrebt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Phiero pachùh wì mùt ta hnim, mang aih haq dôq wì oe kùi ta aih. Sroq èh, Phiero yòng lam ti wì, i biaq ngai oh daq ta Jopbê hanoh tiaq haq. ");
INSERT INTO hrebt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Hì atìq wì trùh ta Sêsarê, cla Kot-nai loh đìh, rai kùh rai bla op nòe jènh Phiero; ");
INSERT INTO hrebt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Phiero bu mùt, aih cla Kot-nai loh đìh, rai kùh rai bla op nòe jènh Phiero. ");
INSERT INTO hrebt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mahaq Phiero dèch haq yòng rai doe: Ìh yòng beq, au kô hanoh mangai. ");
INSERT INTO hrebt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Phiero capoch tuàng ti Kot-nai, jò mùt ta hnim haq hnoq i bàc ngai khoe tagop ti dabau ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Haq doe ka wì: Mangai Juđa ùh khòh ta qmùt ti mangai diac wì, hadai ùh khòh thia ta hnim wì. Mahaq Boc plình khoe mahno ka au loq ùh jah ngan mangai leq amùa ùh sròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Aih ìq jò mangai ìh thê lam chaq au bu trùh, au hadai ùh hòq cleq ka trùh tacô. Aleq au bòch, i yiniq cleq pì majah akhen ka au trùh tacô? ");
INSERT INTO hrebt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kot-nai padreo bàu: Khoe pôn hì ta adreo kô, qnah ta piq jò di xèq, au qnang oe ta hnim waiq khàn, cadoe i mòeq ngai caxùnh eo tabŏc ka-ah ka-iang yòng enh ngèa au, ");
INSERT INTO hrebt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","mangai aih doe: Kot-nai! bàu waiq khàn ìh khoe jah dì, yiniq ìh ma ti tabàih ka mangai pa Boc Plình khoe hmàng da ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Manòeq kô ìh thê mangai lam ta Jopbê, akhen ka Simôn wì ma creo Phiero aih lam tacô: Haq qnang oe ta hnim Simôn thòq broq akia, hnim aih ten kênh diac raxìq. ");
INSERT INTO hrebt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Au hi drah thê lam chaq ìh, ìh trùh tacô aih joq troq. Manòeq kô, dìq dŏng ka nhèn qnang oe enh ngèa Boc plình, hu tamàng bàu haq khoe tanap ka ìh đòeq anoe hlài ka nhèn. ");
INSERT INTO hrebt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Phiero hi anoe: Joq qnàng, au loq Boc plình ùh loq waq tang ngai, ");
INSERT INTO hrebt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","mahaq dìq dŏng ka mangai ta crŏng taneh, waq toq cabô loq iu yùq ka haq rai broq trong taq atoq, mangai aih jah lem manoh haq. ");
INSERT INTO hrebt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Aih la bàu haq khoe anoe ka mangai Isorali, jò hnài Bàu lem da kan catèm enh Chuaq Jesus Christ, aih Chuaq dìq dŏng da kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yiniq aih baxèm enh Galili khoe aih jàp tagùng Juđê, atìq ka aih Jon khoe hnài broq ƀaptem, aih pì hanoh khoe loq, ");
INSERT INTO hrebt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Boc plình khoe xùt dàu ka Chuaq Jesus mangai Naxaret xi Yiang Hadròeh, khoe aih haq hi lam enh gùng kô trùh gùng tau ti am xôq ramot rai paclaih ka ƀài mangai kiac padit, majah qmang aih Boc Plình oe ti haq. ");
INSERT INTO hrebt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nhèn mangai hnoq rìm yiniq haq broq tagùng mangai Juđa xam ta Jêrusalem. Wì khoe taqmac haq talong hu jêh cađac. ");
INSERT INTO hrebt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mahaq trùh hì piq, Boc plình khoe broq haq rìh hlài rai paqnoh haq. ");
INSERT INTO hrebt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ùh xài paqnoh am dìq dŏng ka mangai hnoq, mahaq am toq ka mangai hu lam panhìn, ƀài mangai Boc plình ma khoe ràih qmòe enh baxèm, aih nhèn kô mangai ma khoe acaq ôq pajùm ti haq, atìq ka haq rìh hlài enh kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Haq khoe thê nhèn hnài rai anoe dôq rìm ngai loq haq aih raq Mangai Boc plình ma khoe xùt dàu đòeq hu hadrah mangai rìh xam mangai cachìt. ");
INSERT INTO hrebt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dìq dŏng ƀài mangai pajàu hanoh khoe anoe trùh haq, wì doe: waq toq mangai leq lùi haq, aih hi jah claih dìq ka yiniq lui taiq canòm ka yiniq haq. ");
INSERT INTO hrebt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Jò Phiero oe raq anoe, aih Yiang Hadroèh loh oe dìq dŏng ti mangai ma tamàng bàu. ");
INSERT INTO hrebt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ƀài mangai khoe broq ranenh kat akia, aih la ƀài mangai ma lam ti Phiero, wì hamàih pi cajaq majah qmang aih wì hnoq Boc plình hadai ùc am Yiang Hadròeh ka mangai diac qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Majah qmang aih wì tàng ƀài aih tapoch bàu crài đòeq manè apôi Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Jò aih Phiero hi doe: Wì kô hadai khoe jah Yiang Hadròeh qmang ka bèn, cabô hùa tàt wì haq jah broq ƀaptem xi diac hòm? ");
INSERT INTO hrebt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Haq hi thê broq ƀaptem ka wì, canòm ka yiniq Chuaq Jesus. Wì àu padràng haq oe tam ti wì toq biaq hì. ");
INSERT INTO hrebt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ƀài mangai tiaq cla xam oh daq oe ta Juđê hìa doe mangai diac wì hanoh khoe tawìh tiaq trong Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jò Phiero khoe wìh tŏc ta Jerusalem, ƀài mangai lùi mahaq khoe broq tiaq ranenh kat akia i tapoch ka haq rameh: ");
INSERT INTO hrebt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ìh khoe mùt hnim ƀài mangai qnhòq broq ranenh kat akia, rai acaq pajùm ti wì! ");
INSERT INTO hrebt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mahaq Phiero yŏc rìm yiniq ma khoe loh đòeq taqmon hlài ka wì tiaq tang yiniq i xèm goe, rameh: ");
INSERT INTO hrebt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Jò au qnang waiq khàn ta Jopbê aih au loh ka pi hmàng, ta kan mahno au hnoq i cleq tìah ka mòeq blah mù kàn, pôn toq mùm haq aih yinh atŏc, qnhùa qnoh enh plình clìh enh ajang qngèa au. ");
INSERT INTO hrebt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Au ngan ka nhìn ta aih, hnoq ta aih i ƀài ngè i pôn toq jènh, ƀài jam gùng, ƀài yiniq ma loq ti pan loq ti moq ta taneh xam ƀài chìm pan ta trŏc. ");
INSERT INTO hrebt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Khoe aih, au tàng i bàu doe ka au: “Phiero! drah yòng beq, broq jam qmat hu acaq.” ");
INSERT INTO hrebt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Au padreo bàu: Chuaq au! Ùh đòh, majah qmang aih ùh lah i cleq amùa ùh sròeh mùt ta hacùng au. ");
INSERT INTO hrebt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Bàu enh plình doe hòm ka au yàng baiq: “Ƀài yiniq cleq Boc Plình ma khoe basròeh ùh dùh doe haq oe raq amùa.” ");
INSERT INTO hrebt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bàu aih capoch lauq piq yàng, khoe aih, dìq dŏng ƀài yiniq aih hi jah dèch atŏc hlài ta plình. ");
INSERT INTO hrebt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Meh oq, draq drình hloe jò aih, piq ngai enh Sêsare wì ma thê lam ta au, khoe trùh qmòe ajang qmang hnim au ma oe. ");
INSERT INTO hrebt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yiang Hadròeh thê au lam ti wì aih, apaq hòq cleq. Hacô, tadràu ngai oh daq kô hanoh lam ti au, èh hadai dìq dŏng ka nhèn mùt ta hnim Kot-nai. ");
INSERT INTO hrebt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Haq aih hi anoe hlài ka nhèn haq i hnoq mòeq ƀình plình loh ta hnim haq qmang leq rai thê: “Drah thê mangai lam ta Jopbê, akhen ka Simôn wì macreo Phiero aih trùh tacô. ");
INSERT INTO hrebt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Haq aih hi anoe ka pì, đòeq canòm ajang ƀài bàu aih, ìh xam dìq ka cadraq ìh jah dèch.” ");
INSERT INTO hrebt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Au bu qnang anoe, aih i Yiang Hadròeh enh qnhèq loh ti wì, tìah ka jò baxèm haq khoe loh ti bèn diq. ");
INSERT INTO hrebt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Aih au hi hmàng hlài bàu Chuaq Jesus khoe doe: “Jon khoe broq ƀaptem xi diac, mahaq kô èh pì jah ƀaptem xi ùnh. ");
INSERT INTO hrebt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Qmang aih, tàng joq Boc Plình khoe am ka wì hadai jah kan tabàih qmang ka bèn aih ƀài mangai ma khoe lùi Chuaq Jesus Christ, qmang aih au kô ìq cabô mahùa tàt Boc Plình? ");
INSERT INTO hrebt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jò wì khoe tàng qmang aih, dìq ka wì pi oe tablêq ka haq hòm, wì manè apôi Boc Plình rameh: Qmang aih, Boc Plình hadai khoe am ka wì kan loq raxach dôq mangai diac wì hanoh jah kan rìh! ");
INSERT INTO hrebt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ƀài mangai ma khoe cadàu haprah priang ka kan baxa jò wì ma jêh đac Êtien, wì trùh ta Phênixi, Chipro xam Antiôt, wì anoe bàu lem am toq ka mangai Juđa. ");
INSERT INTO hrebt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mahaq ta wì aih i biaq ngai gùng Chipro, gùng Syren, wì lam trùh ta Antiôt, wì hanoh hadai anoe am ka mangai Gorec, hnài Bàu lem da Chuaq Jesus ka wì. ");
INSERT INTO hrebt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tì Chuaq oe ti wì aih, dài mangai lùi rai tawìh hlài ta Chuaq majah bàc haraya. ");
INSERT INTO hrebt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tagop Hadròeh ta Jêrusalem hìa bàu aih, wì thê Banaba lam ta Antiôt. ");
INSERT INTO hrebt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jò trùh ta aih hnoq xôq ramot Boc Plình haq mannè pi cajaq rai toq ti alòng oh daq ep cajap manoh tiaq Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba aih mangai lem manoh qnàng, bình Yiang Hadròeh xam kan lùi. Jò aih mangai tiaq Chuaq rai bàc. ");
INSERT INTO hrebt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Khoe aih, Banaba lam ta gùng Tacso, hu chaq Saulo, ");
INSERT INTO hrebt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jò khoe glàm, hi ahlài ta Antôt. Wop jah mòeq hanam, wa aih tagop pajùm ti Tagop Hadròeh rai hnài bàc ngai. Oe tagùng Antiôt wì ma hi creo ka mangai tiaq hŏc aih Corê-tien. ");
INSERT INTO hrebt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Oe ta ƀài hì aih, i wì mangai pajàu loh enh Jêrusalem trùh ta Antiôt. ");
INSERT INTO hrebt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Taqne wì aih i mòeq ngai yiniq haq Agabut padinh yòng, Yiang Hadròeh am haq capoch pajàu: “Kô èh i kan pangot hrah jàp ta crŏng taneh”; Joq qnàng qmang aih, kan pangot hrah kô troq qnhòng da Colôt broq bùa. ");
INSERT INTO hrebt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mangai tiaq hŏc hatình ka dabau, rìm ngai tiaq deh hra padren, padon đòeq hliac jènh hu tabàih ka oh daq tagùng Juđê. ");
INSERT INTO hrebt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mangai tiaq hŏc broq gêh trong aih, canòm ka Banaba xam Saulo aràng dahwèq aih am ka ƀài gucraq. ");
INSERT INTO hrebt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Hanoh qnhòng aih, bùa Hêrôt rùp toq ƀiaq ngai ta Tagop Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Bùa yŏc chang jêh cađac Jaco, aih daq da Jon, ");
INSERT INTO hrebt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Haq hnoq broq qmang aih lem ka manoh mangai Juđa, haq hi thê rùp hloe xam Phiero hòm. Jò aih wop troq jò ramènh kaq ƀênh ùh tah blo. ");
INSERT INTO hrebt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bùa rùp clêh haq, thê pôn calùh lình gòm rap, mòeq calùh i pôn ngai lình. Bùa hèm dèh gòm khoe ka hì ramènh pancwa, aih èh hi rùp Phiero loh yòng enh ngèa dìq dŏng ka mangai ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Qmang aih, wì jrong Phiero ta hnim cadrong, mahaq Tagop Hadròeh dìq jaq waiq khàn am ka haq. ");
INSERT INTO hrebt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mang adroe ka hì Hêrôt ma hu padon qnoh haq loh yòng nòe hadrah, Phiero oe raq kùi i caxy datoeq kàt haq taqne baiq ngai lình, ajang trong qmang i ƀài lình gòm rap. ");
INSERT INTO hrebt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Cadoe i mòeq ƀình plình da Chuaq trùh, i kan qngah sreo qngah ta hnim cadrong clam cluiq aih. Haq tep ta yimìa Phiero, padrìu haq yòng, ƀình plình doe: “Drah yòng.” Caxy datoeq kàt tì haq taclìh dŏng haqneq. ");
INSERT INTO hrebt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Khoe aih ƀình plình doe “Rìt hlài caxy qnam qmat, tŏc jep beq.” Phiero broq tiaq bàu. Ƀình plình doe hòm “Drah caxùnh eo enh gùng qmat hu tiaq au.” ");
INSERT INTO hrebt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Phiero tiaq haq loh enh gùng, ùh qnì aih joq qnàng, haq xoh deh kan mahno. ");
INSERT INTO hrebt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wa lam khoe catech ka nòe rap ma adroe èh nòe ma atìq, aih hi trùh ajang qmang mem, aih nòe ma hu mùt ta phôq. Qmang aih tapèch đeh am ka wa, wa hi lam trong aih, tŏc ta trong kàn, aih ƀình plình hi cađac haq. ");
INSERT INTO hrebt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Khoe aih Phiero ma hi cadrat don, haq doe: Manòeq kô au ma hi loq Boc Plình joq khoe thê deh ƀình plình loh caqnaih au claih enh tì Hêrôt xam trong mangai Juđa ma tangèh. ");
INSERT INTO hrebt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Haq hèm hlài ƀài yiniq aih, khoe aih haq lam ta hnim Mari, miq da Jon wì ma creo Mŏc, ta aih i bàc ngai qnang tagop waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Haq clôq qmang, i mòeq ngai hapŏng yiniq haq Rôđo loh pèch qmang, ");
INSERT INTO hrebt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","canau ka bàu Phiero haq manè pi cajaq, loh ka pi dòh pèch qmang, haq drah cadàu mùt doe: Phiero qnang yòng ajang trong qmang! ");
INSERT INTO hrebt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wì doe: Gè khoe rawè. Mahaq dua haq doe hi loq. Wì doe: Aih ƀình plình da haq. ");
INSERT INTO hrebt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mahaq Phiero clôq yôt qmang. Jò pèh qmang, hnoq Phiero, dìq dŏng ka wì hamàih đeh hra. ");
INSERT INTO hrebt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mahaq Phiero dèch tì, patìah ka wì thê wì hatinh, haq hi anoe ka wì loq Chuaq khoe qnoh haq loh enh gùng ka hnim cadrong qmang leq, khoe aih haq tanap: Doe ka Jaco xam dìq ka oh daq loq yiniq kô. Khoe aih haq hi lam taqnoeq. ");
INSERT INTO hrebt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Trùh qngah sroq èh, taqne ƀài lình i kan tagruàng kàn: Majah qmang aih wì haq ùh qnì ka Phiero lam taleq. ");
INSERT INTO hrebt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Bùa Hêrôt thê wì ti chaq jaq ka joq, mahaq wì chaq ùh hnoq, Hêrôt ti creo bòch qmòe tang ngai lình, khoe aih thê wì qnung lam jêh đac ƀài aih. Khoe ka aih Hêrôt loh ta Sêsare, haq oe hlài ta aih ");
INSERT INTO hrebt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Bùa Hêrôt git ka mangai ta Tyro xam mangai ta Siđôn. Majah qmang aih, wì aih khoe jah manoh Balatut aih mangai cwan patìh oe ka jènh ka tì ti bùa, bùa ma tùt dèh, wì pajùm mòeq manoh ka dabau trùh glàm bùa Hêrôt đòeq hu bòch broq hatroq ka bùa, majah qmang aih gùng wì haq acaq canòm đeh dahwèq enh taneh diac bùa. ");
INSERT INTO hrebt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Trùh hì aih, Hêrôt caxùnh eo bùa, haqngui tagèq bùa, capoch tuàng qne nòe mangai bàc. ");
INSERT INTO hrebt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ƀài mangai ta aih doe: Aih bàu da kiac, ùh xài bàu da mangai! ");
INSERT INTO hrebt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tajòe qmòe jò aih, i ƀình plình da Chuaq jêh bùa Hêrôt, majah qmang aih Hêrôt enh blah yŏc kan ranhòm da Boc Plình, khoe aih bùa loh ka hrai kaq, haq hi cachìt. ");
INSERT INTO hrebt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mahaq bàu Boc Plình hlàng trùh rai èh rai jàp jìa. ");
INSERT INTO hrebt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba xam Saulo broq gêh dèh ka bìac, wa haq hi loh enh Jêrusalem hlài ta Antiôt, qnong Jon wì ma creo dèh Mŏc lam ti wa. ");
INSERT INTO hrebt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Oe ta Tagop Hadròeh Antiôt có bàc ngai pajàu xam mangai hnài, aih Basaba, Simeôn wì macreo dèh Nijê, Lusi-ut mangai gùng Syren, Manahem aih (oh ban da Hêrôt bùa qyoh), xam Saulo. ");
INSERT INTO hrebt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jò oh daq qnang kùh waiq Chuaq rai apàm ka acaq, Yiang Hadròeh thê: “Lah đòeq crài Banaba xam Saulo đòeq wa hi broq trong Au khoe creo wa broq. ");
INSERT INTO hrebt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Atìq ka apàm ka acaq rai waiq khàn, oh daq roh tì enh qnhèq ka wa, khoe aih hi thê wa lam. ");
INSERT INTO hrebt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Qmang aih, Jò Yiang Hadròeh khoe thê Banaba xam Saulo lam, wa loh ta Sêloxi, enh aih wa tŏc boang lam ta pleo Chipro. ");
INSERT INTO hrebt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Jò wa khoe trùh ta Salamin, wa hnài trong Boc plình ta hnim tagop qyoh da mangai Juđa, Jon hadai lam hu wiang patìh ka wa. ");
INSERT INTO hrebt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wa lam dìq ka pleo aih trùh hloe ta Ƀaphô, wa glàm mòeq ngai Juđa, mangai aih i canàih, aih mangai pajàu qnùt, yiniq haq Ƀajêsu, ");
INSERT INTO hrebt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","oe ti mangai tình truàng yiniq haq Sêjut-Phaulut, mangai tình truàng kô khun rabiaq dìq jaq. Haq akhen ka Banaba xam Saulo trùh, haq enh bòch tamàng đeh trong Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mahaq Êlima, mangai pajàu i canàih (aih ngìah yiniq haq), tàt wa aih, ti àu chaq trong dôq cwan tình truàng ùh lùi. ");
INSERT INTO hrebt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Khoe aih, Saulo wì ma loq creo Phaulô bình ha lùih Yiang Hadròeh, ngan tajang ka Êlima rai doe: ");
INSERT INTO hrebt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Wùih, mangai bình bauq kan gôpla, kan dù meh, kon da kiac chŏc jròng, taƀlêq ka kan taq atoq, ìh ùh hêq ka enh toq troq đac trong jang da Chuaq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Manòeq kô Chuaq dèch kŏng taƀlêq ka ìh, kô èh ìh jah lua mat, pi hnoq mat mahì toq ƀiaq hì.” Tajòe hloe jò aih raq, i kan clam cluiq gùp dŏng haq, haq ti tawìh dudan đòeq chaq mangai tìc rađeh. ");
INSERT INTO hrebt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jò cwan tình truàng hnoq qmang aih, haq hi lùi, haq hamàih dìq cajaq ka bàu da Chuaq. Oe ta Antiôt gùng Bisiđi ");
INSERT INTO hrebt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Phaulô xam deh bua tŏc boang enh Baphô lam ta Ƀetjê trong gùng Bamphi-li. Mahaq Jon cađac wa, đòeq hlài ta Jêrusalem. ");
INSERT INTO hrebt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wa aih hòm, loh Ƀetjê wa ƀoe trong lam trùh Antiôt gùng Bisi-đi, Troq hì Sabat, wa mùt haqngui ta hnim tagop qyoh. ");
INSERT INTO hrebt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bu hêq ka đŏc ta hset ranenh xam ƀài hset pajàu, wì craq wèq hnim tagop qyoh doe ka wa haq: “Wa daq! Tàng joq loq i ƀiaq nà bàu đòeq anoe hnài oh daq, anoe beq.” ");
INSERT INTO hrebt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Phaulô hi yòng, gwàih tì ka oh daq, haq doe: “Dìq ka oh daq Isorali xam mangai loq iu yùq Boc Plình, tamàng kô! ");
INSERT INTO hrebt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Boc Plình da mangai Isorali kô, khoe ràih kan cadraq bèn, broq ka wì aih chèch lòe jò wì haq oe đeh tanòe taneh diac wì, aih diac Êdip, yŏc cwìang itai kàn qnoh wì loh enh gùng aih. ");
INSERT INTO hrebt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Jah ta pôn jàt hanam, haq chìuq àt ka kan ùh wìa da wì aih nòe braih kàn. ");
INSERT INTO hrebt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jò khoe raliang qnìh cađac tapèh diac ta Cana-an, yŏc taneh wì aih aq am dèh ka mangai da haq. ");
INSERT INTO hrebt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Khoe èh, qnah ta pôn hrinh padam jàt hanam tìa aih, Boc Plình am ka wì aih ƀài mangai hadrah trùh hloe ta qnhòng pajàu Samuên. ");
INSERT INTO hrebt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Jò aih wì bòch ka haq am ka wì mòeq ngai broq bùa, Haq am ka wì Saulo kon da Kit, nang noe Bênjamin, broq bùa wèq wì haq aih pôn jàt hanam. ");
INSERT INTO hrebt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Khoe èh haq cađac bùa aih, dèch Đawit broq bùa, anoe trùh Đawit Boc plình doe: “Au khoe chaq hnoq Đawit kon da Jêse, aih mangai lem ka manoh au, haq aih èh ma broq tiaq rìm yiniq au enh thê haq broq. ");
INSERT INTO hrebt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tiaq qmang ka bàu khoe tèu đòeq adroe, enh nang noe haq aih èh Boc Plình ma hi padèch am ka magai Isorali mòeq Ngai Dèch, aih Chuaq Jesus Christ. ");
INSERT INTO hrebt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Adroe ka Chuaq Jesus trùh, Jon khoe hnài ranenh ƀaptem da kan loq raxach am mangai Isorali. ");
INSERT INTO hrebt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jò Jon qnang pagêh dèh yiniq broq, haq doe: “Pì xoh au kô ìq cabô? Au ùh xài mangai pì qnang ti chaq. Mahaq i mòeq ngai trùh atìq ka au, au ùh tajì ka jah broq đeh mangai lêh caxy jep haq aih.” ");
INSERT INTO hrebt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Yôi oh daq bèn kô aih mangai kon xau da Apraham xam mangai ma loq iu yùq ka Boc Plình, bàu bahìa trùh kan dèch kô khoe anoe am ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Majah qmang aih xam cwan xam mangai oe ta Jêrusalem ùh canau loq ka Chuaq Jesus kô, aih ìq raq jò wì ma tahadrah ka haq, wì haq khoe broq gêh bàu ƀài mangai pajàu wì haq ma loq đŏc ta hì Sabat. ");
INSERT INTO hrebt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yac ka wì chèh chaq ta haq wì ùh loh qmòeq yiniq lui cleq ma troq ka cachìt, mahaq dua wì àu bòch dôq Philat jêh cađac haq. ");
INSERT INTO hrebt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jò wì broq khoe xìt rìm trong ma khoe achìh trùh haq, wì hi qnoh haq enh long pagat, èh catùh hanang haq ta ralùng. ");
INSERT INTO hrebt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mahaq Boc Plình khoe broq haq rìh hlài enh kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ƀài mangai ma tiaq haq enh Galili tŏc trùh Jêrusalem jah hnoq haq bàc hì, wì aih manoèq kô qnang anoe hu panhìn haq am ka mangai bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Da nhèn kô hòm, anoe am ka oh daq bàu lem, aih la bàu Boc Plình ma khoe tèu am ka kan cadraq bèn rameh: ");
INSERT INTO hrebt_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Boc Plình khoe broq ka Chuaq Jesus rìh hlài, qmang aih khoe xìt bàu haq ma tèu am ka bèn, aih ƀài kon xau da kan cadraq bèn, wop qmang ka bàu khoe achìh ta hset Calêu Plình: “Kon kô kon calô da au, hì kô au khoe hauang kon.” ");
INSERT INTO hrebt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Boc Plình broq ka Chuaq Jesus rìh hlài enh kan cachìt, qmang aih dôq chac haq ùh jò leq om hnhung hòm, qmang ka Boc Plình khoe doe: “Au am ka pì bàu hadròeh cajap, am xôq ramot au ma khoe tèu ka Đawit.” ");
INSERT INTO hrebt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ajang brong qnoeq hòm doe: “Ìh ùh dôq dèh Mangai Hadròeh ìh hnoq kan om taleq.” ");
INSERT INTO hrebt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Jò Đawit oe rìh, broq tiaq bàu Boc Plình thê, khoe aih cachìt, haq khoe jah catùh dèh ti kan cadraq, hanang haq khoe om. ");
INSERT INTO hrebt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mahaq Mangai Boc plình ma broq ka haq rìh hlài enh kan cachìt ùh om taleq. ");
INSERT INTO hrebt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Qmang aih, oh daq au, bèn khòh loq rameh: Canòm ka Chuaq Jesus aih raq, kan baclaih yiniq lui khoe jah anoe am ka pì; ");
INSERT INTO hrebt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","èh canòm ka haq aih raq waq toq cabô lùi aih hi jah kan taq atoq, rìm trong tiaq ranenh da Môise ùh broq ka mangai leq jah kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Aih ìq, drah wèq rađeh dôq bàu khoe achìh ta hset pajàu ùh hìaq trùh ka pì: ");
INSERT INTO hrebt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Wùih! mangai ma loq halê meh, ngan beq, drah loq crè rai lùng pac beq; Majah qmang aih au padon broq mòeq yiniq oe ta qnhòng da pì, Yac ka i cabô anoe hlài ka pì, dua pì ùh lùi.” ");
INSERT INTO hrebt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Wa aih cadiang loh enh hnim tagop qyoh, wì akhen ka wa trùh hì Sabat atìq hnài tam bàu aih. ");
INSERT INTO hrebt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jò khoe hêq enh tagop, i bàc ngai neo tiaq trong Juđa, tiaq Phaulô xam Banaba, wa capoch tuàng ti wì rai pariaq wì oe ma cajap ta kan loq waq Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hì sabat atìq, wì ta aih tagop ten dìq ka dabau đòeq ta màng bàu Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yàng ƀài mangai Juđa hnoq mangai bàc qmang aih ta manoh wì bình chàu kan tagit, wì haq tàih cađac bàu Phaulô rai capoch qmèq hloe ka haq. ");
INSERT INTO hrebt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Phaulô xam Banaba hi doe hloe ka wì: Nhèn ep hnài bàu Boc Plình ka pì adroe òeq, mahaq pì khoe ùh tamàng, pì hnoq rađeh ùh tajì đòeq jah kan rìh halình mòeq đòe, kô èh nhèn tawìh ta mangai diac wì. ");
INSERT INTO hrebt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Majah qmang aih Chuaq i thê nhèn rameh: “Au dèch pì broq kan qngah am bàc diac, Dôq pì aràng kan dèch trùh jàp caqnàm plình”. ");
INSERT INTO hrebt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mangai diac wì tàng anoe qmang aih wì toq lem bùi manè apôi bàu da Chuaq, mangai leq ma khoe jah padon đòeq ka kan rìh halình mòeq đòe, dìq lùi dŏng. ");
INSERT INTO hrebt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Trong da Chuaq hlàng jàp gùng aih. ");
INSERT INTO hrebt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mahaq mangai Juđa baxrùq ƀài mangai gucadrì padrŏng kan tagùng aih xam ƀài mangai ratauq, tirùp Phaulô xam Banaba, khoe aih hnan đac wa loh khoe dèh ka gùng. ");
INSERT INTO hrebt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Wa aih tangèa ta wì, hapùih caqnìh blo top ta jo wa, Khoe hi lam ta Ycôni. ");
INSERT INTO hrebt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wì mangai tiaq hŏc jah ùc bình kan lem bùi xam Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Oe ta Ycôni, Phaulô xam Banaba mùt ta hnim tagop qyoh da mangai Juđa, wa capoch hnài qmòe dìq jaq, loh qmòe ka i bàc ngai Juđa xam mangai Gorec lùi tiaq. ");
INSERT INTO hrebt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mahaq mangai Juđa ma qnhòq waq lùi xan toq patah rai baxrùq manoh cliac ƀài mangai cla gùng aih đòeq hu tablêq ka wì oh daq. ");
INSERT INTO hrebt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Yac ka qmang aih, Phaulô xam Ƀanaba oe ta aih dùnh diq wa bình manoh lùi, anoe Chuaq am ka wì, ùh lòm yùq qmòe cleq. Chuaq yŏc tì kŏng wa broq bàc kan halac, đòeq panhìn ka cajap trong loq waq da Haq. ");
INSERT INTO hrebt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mangai ma oe ta phôq aih talah broq baiq: Qnah ngai tiaq pah magai Juđa, qnah ngai tiaq wa. ");
INSERT INTO hrebt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jò mangai diac wì xam mangai Juđa hloe xam bài cwan mòeq manoh ti dabau yòng taƀlêq rai enh yŏc hmo đàp wa, ");
INSERT INTO hrebt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","mahaq wa khoe loq adroe, wa hi wia enh aih lam puplech tagùng Lycôni aih phôq Lit tro, Đetbo, xam ƀài gùng ten aih, ");
INSERT INTO hrebt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","rai hnài Bàu lem. ");
INSERT INTO hrebt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Oe ta Lit tro i mòeq ngai pen, liap qmòe enh jò baxèm hauang, ùh jah cadiang. ");
INSERT INTO hrebt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Haqngui tamàng bàu Phaulô hnài. Phaulô ngan mat haq, hnoq haq i manoh lùi đòeq jah broq brêh, ");
INSERT INTO hrebt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Phaulô hi capoch cadêh: “Ìh yòng beq, yòng ma hnhoh haq.” Haq aih aplôh mòeq qmang, khoe aih hi cadiang lam. ");
INSERT INTO hrebt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wì ta aih hnoq yiniq Phaulô khoe broq, wì tapoch xam bàu Lycôni: Ƀài kiac khoe yŏc chac mangai đòeq loh ti bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Wì creo ka Ƀanaba aih kiac Jupite, Phaulô aih wì creo kiac Mecuro, majah qmang aih haq mangai broq gàu yòng hnài. ");
INSERT INTO hrebt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Craq pajàu da kiac Jupite i hnim tadreo ajang qmang ngo mùt ta phôq, aràng mòeq toq ƀo qnìq xam riang trùh ajang trong qmang, enh pajùm mòeq manoh ti wì ta aih hu dèch mòeq ramènh tadreo. ");
INSERT INTO hrebt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mahaq jò Ƀanaba xam Phaulô aih mangai tiaq cla, tàng qmang aih, wa haq hit deh eo rai tùh loh ta mangai bàc, rai doe cadêh: ");
INSERT INTO hrebt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Wùih oh daq! gleq majah broq qmang qmat? Ma hadai mangai tìah ka oh daq, ma aràng Bàu lem am ka pì, dôq pì cađac ƀài kiac ùh loh cleq tau, hu hlài ti Boc Plình rìh halình mòeq đòe, Haq aih ma broq loh plình crŏng taneh, diac raxìq xam rìm yiniq ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Qnhòng calah nèh, haq dôq rìm diac mangai leq mangai meh tiaq deh hra trong, ");
INSERT INTO hrebt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","mahaq dua haq patô rađeh yôt ka wì, aih la haq am xôq ramot, caqnìh mè enh plình, jò mùa am ka wì jah qmau jah plì, dahwèq acaq ùh dìq, xam kan lem bùi. ");
INSERT INTO hrebt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mahaq yac ka wa anoe qmang aih, bu qnang lem tàt wì ùh hìaq dèch ka wa ramènh tadreo. ");
INSERT INTO hrebt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Khoe ka aih, i mangai Juđa trùh enh Antiôt xam Ycôni lam padô wì ta aih, wì yŏc hmo hibùq Phaulô, xoh dèh haq khoe cachìt, wì hua qnoh haq enh gùng ka phôq. ");
INSERT INTO hrebt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mahaq jò mangai tiaq hŏc ta aih qnang tagop dabau oe dudan ka haq, haq padinh yòng mùt ta phôq. Hì atìq, haq lam ti Ƀanaba trùh ta Đetbo. ");
INSERT INTO hrebt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Wa anoe Bàu lem ta aih, broq ka bàc ngai wìh wìa mangai tiaq hŏc, wa hi hlài ta Litro, Ycôni xam Antiôt. ");
INSERT INTO hrebt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pariaq mangai tiaq hŏc ep cajap manoh lùi, anoe ka wì loq qmòe adroe ep glàm bàc kan xalep men jah mùt diac Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Jò wa khoe ràih ƀài mangai đòeq hu broq gucraq ka rìm Tagop Hadròeh ta aih, khoe ka apàm ka acaq rai waiq khàn, dèch wì aih ka Chuaq wa haq ma khoe lùi dèh. ");
INSERT INTO hrebt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Khoe aih, wa lam catech ka gùng Bisiđi, trùh tagùng Bamphily. ");
INSERT INTO hrebt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Atìq ka hnài ta Betjê, wa hi loh ta Atali. ");
INSERT INTO hrebt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Enh aih, wa lam boang hlài ta Antiôt, aih raq nòe wa ma khoe loh lam, ma khoe jah jao am ka kan loq waq Boc Plình, đòeq hu broq rìm yiniq wa neo broq gêh. ");
INSERT INTO hrebt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Trùh nòe, wa creo ka Tagop Hadròeh tagùng aih, wa hi taqmon rìm yiniq Boc Plình khoe broq ajang tì kŏng wa, Boc Plình khoe pèh mòeq toq qmang kan lùi am ka mangai diac wì qmang leq cadèh. ");
INSERT INTO hrebt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mangai tiaq hŏc ta aih bàc hì. ");
INSERT INTO hrebt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","I ƀiaq ngai enh gùng Juđê trùh hnài oh daq rameh: Tàng joq pì ùh broq ramènh kat akia tiaq ranenh da Môise, aih pì ùh jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Aih ìq dài Phaulô xam Ƀanaba majah loh ka tarahen kàn ka wì aih, wì waq qmòe ka Phaulô xam Ƀanaba lam ti wì haq tŏc ta Jêrusalem, glàm ƀài mangai tiaq cla xam gucraq ta aih đòeq bòch yiniq kô. ");
INSERT INTO hrebt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Qmang aih, jòTagop Hadròeh khoe thê wì haq, wì lam trong gùng Phênisi gùng Samari, taqmon bìac mangai diac wì khoe wìh hlài ti Bàu lem qmang leq, broq dìq dŏng ka oh daq lem bùi dìq jaq. ");
INSERT INTO hrebt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bu trùh ta Jêrusalem, Tagop Hadròeh xam mangai tiaq cla, hloe wì gucraq ta aih đìh wì haq ka alàng. Wì anoe hlài Boc Plình khoe thê wì haq broq cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mahaq i ƀài mangai moeq bua ti mangai Pharisi hadai khoe tiaq, padinh yòng doe: Ep broq ranenh kat akia ka mangai diac wì rai thê wì aih ep wèq tiaq ranenh Môise. ");
INSERT INTO hrebt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Wì Mangai tiaq cla xam gucraq hi haqngui ti dabau đòeq hu hatình trong kô. ");
INSERT INTO hrebt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Khoe ka hatình Phiero hi yòng anoe ka wì: “Dìq ka oh daq, pì loq rameh enh jò baxèm, Boc Plình khoe ràih au taqne oh daq, dôq mangai diac wì jah tamàng Bàu lem loh enh hacùng au đòeq wì hu lùi tiaq. ");
INSERT INTO hrebt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Boc Plình loq ka manoh cliac kon mangai, haq paqnoh rađeh khoe dì yŏc mangai diac wì, ajang nòe am ka wì Yiang Hadròeh tìah ka bèn diq. ");
INSERT INTO hrebt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Haq ùh i ngan bèn xam mangai diac wì crài ka dabau, majah qmang aih haq khoe yŏc kan lùi broq ka manoh wì jah hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Manòeq kô hagleq oh daq majah ti qnhro ngan Boc Plình, taqmac ta ranŏng oh daq mangai diac wì long ech yac ka cadraq bèn, yac ka bèn enh nèh trùh manòeq qnhòq lah hlàt pòq? ");
INSERT INTO hrebt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Majoq qnàng aih, bèn lùi rameh canòm kan am dech ajang Chuaq Jesus, bèn jah dèch qmang ka mangai diac wì diq.” ");
INSERT INTO hrebt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Dìq ka mangai tagop ta aih loh ka hatinh dŏng, tamàng Ƀanaba xam Phaulô anoe hlài bàc trong bàc kan halac Boc Plình khoe broq ajang wa am ka mangai diac wì hnoq. ");
INSERT INTO hrebt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Khoe ka wa anoe, Jaco hi doe: “Dìq ka oh daq tamàng kô! ");
INSERT INTO hrebt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simôn i taqmon hlài ka bèn yàng baxèm, Boc Plình khoe ha-och ka mangai diac wì qmang leq, enh aih ràih yŏc mòeq xinoe hu dèch ka yiniq cla haq. ");
INSERT INTO hrebt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Bìac aih, hatroq troeq bàu wì pajàu, majah qmang aih i bàu achìh rameh: ");
INSERT INTO hrebt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Atìq ka aih, au wìh hlài, Broq hlài hnim ranòh da Dawit ma khoe taclìh raliang; Au palàng hlài nòe ma khoe taclìh, Au dèch paqnàng hlài haq; ");
INSERT INTO hrebt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Dôq ƀài mangai ma oe rah, jah chaq Chuaq Xam dìq dŏng mangai diac wì ma creo dang yiniq au. Chuaq, Mangai ma broq loh ƀài yiniq kô i anoe qmang aih; ");
INSERT INTO hrebt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","enh calah nèh raq, haq khoe loq ƀài bìac kô. ");
INSERT INTO hrebt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Qmang aih, troeq manoh au, ùh dùh baxa oh daq mangai diac wì ma khoe wìh hlài ti Boc Plình, ");
INSERT INTO hrebt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","mahaq toq achìh jàiq tanap ka wì haq ep dênh apaq acaq dahwèq khoe tadreo am ka kiac qmù, paq tango anang, apaq acaq jam cachìt ka ùh jah hi hèm, apaq acaq mahim. ");
INSERT INTO hrebt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Majah qmang aih enh nèh trùh manòeq, yac ka taleq dua i mangai hnài ranenh Môise, rìm hì sabat, oe ta hnim tagop qyoh wi i đŏc ranenh aih. ");
INSERT INTO hrebt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Khoe ka aih, ƀài mangai tiaq cla xam wì gucraq xam dìq dŏng ka Tagop Hadròeh ràih biaq ngai ta aih, khoe èh thê wì aih lam ti Phaulô xam Banaba trùh ta Antiôt. Wì ràih Juđe aih mangai wì xan creo dèh Ƀasaba xam Sila, aih baiq ngai broq gàu wì oh daq; ");
INSERT INTO hrebt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","khoe aih am ka wa aih jàiq i achìh rameh: Ƀài mangai tiaq cla, xam wì gucraq xam oh daq i bàu hmàih trùh oh daq mangai diac wì ma oe ta Antiôt, gùng Siri xam gùng Silisi! ");
INSERT INTO hrebt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nhèn khoe tàng doe i ƀiaq ngai enh nhèn, wì aih ùh i yŏc mòeq nà bàu nhèn, wì aih yŏc bàu deh cla broq ka manoh oh daq loh ka manhài ùh catèm, ");
INSERT INTO hrebt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","aih ìq dìq ka nhèn majah mòeq manoh ràih ƀiaq ngai hu lam ti wa bua bèn aih Phaulô xam Banaba, đòeq trùh ta oh daq. ");
INSERT INTO hrebt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Wa aih khoe tamùa rađeh am ka yiniq Jesus Christ aih Chuaq bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aih raq nhèn majah thê Juđe xam Sila trùh đòeq anoe xi bàu waq ka oh daq loq trong aih: ");
INSERT INTO hrebt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Qmang aih Yiang Hadròeh xam nhèn khoe hadai pi taqmòq tam ka oh daq kan trap leq hòm enh gùng ka yiniq ma khòh nhet, ");
INSERT INTO hrebt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","aih oh daq ep dênh: apaq acaq ƀòe dahwèq khoe tadreo ka kiac qmù, mahim, jam cachìt ka ùh jah hi hèm, èh apaq tango anang; aih raq ƀài yiniq oh daq ep dênh, ep wia ka hangai. Waiq kan catèm ka oh daq! ");
INSERT INTO hrebt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wì aih loh lam ta trùh ta Antiôt, creo tagop dìq dŏng ka oh daq, khoe hi am jàiq aih. ");
INSERT INTO hrebt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wì đŏc jàiq aih, rìm ngai lem bùi majah qmang aih wì khoe jah tàng bàu alòng. ");
INSERT INTO hrebt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juđe xam Sila wa aih raq mangai pajàu, wa hadai yŏc bàc trong hnài hu pariaq manoh oh daq tadêh. ");
INSERT INTO hrebt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Oe ta aih toq ƀiaq hì, oh daq wiang waiq kan catèm ka wa khoe aih dôq wa hlài dèh ti mangai khoe thê wa trùh. ");
INSERT INTO hrebt_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","- ");
INSERT INTO hrebt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Mahaq Phaulô xam Ƀanaba dìq oe hlài ta Antiôt, hnài Bàu lem rai hnài trong da Chuaq am ka bàc ngai qnoeq hòm. ");
INSERT INTO hrebt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Atìq ka aih toq biaq, Phaulô hatuàng ka Ƀanaba: Beq ba hlài hmàih dìq dŏng ka oh daq oe roc gùng ba ma khoe anoe ka wì trong Chuaq enh adroe kô nèh, ngan wì haq manòeq kô qmang leq cadèh. ");
INSERT INTO hrebt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ƀanaba enh qnung Jon ma creo Mŏc lam tiaq. ");
INSERT INTO hrebt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mahaq Phaulô ùh waq qnung Mŏc lam diq, majah qmang aih tagùng Bamphili, haq khoe cađac wa, pi abroq pajùm ti wa. ");
INSERT INTO hrebt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ajang aih, wa haq majah loh kan tarahen kàn, loh qmòe ka talah ka dabau, Ƀanaba qnung Mŏc tŏc boang lam ta pleo Chipro. ");
INSERT INTO hrebt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Phaulô ràih Sila, canòm ka oh daq waiq khàn dèch wa haq ta kan loq waq da Chuaq, khoe aih wa hi lam. ");
INSERT INTO hrebt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Phaulô lam trong gùng Siri, Silisi, broq ka ƀài Tagop Hadròeh ta aih jah hagau. ");
INSERT INTO hrebt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Phaulô lam trùh ta Đetbo xam Litro. Ta aih i mòeq ngai tiaq hŏc yiniq haq Timothê, miq haq aih mangai Juđa khoe lùi, baq haq aih mangai Gorec. ");
INSERT INTO hrebt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Oh daq oe ta Litro xam Ycôni dìq capoch lem ka haq. ");
INSERT INTO hrebt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Phaulô enh qnong haq tiaq, mahaq mangai Juđa oe ta aih dìq loq baq da Timothê aih mangai Gorec, aih ìq Phaulô majah broq ramènh kat akia ka Timothê. ");
INSERT INTO hrebt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Wì thia phôq leq, wì toq ti tanap oh daq ep wèq tiaq ranenh mangai tiaq cla xam ƀài gucraq ta Jêrusalem khoe paqnoh. ");
INSERT INTO hrebt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Qmang aih, ƀài Tagop hadròeh jah cajap manoh lùi, mangai tiaq rai èh rai bàc. ");
INSERT INTO hrebt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Khoe aih, lam catech trong gùng Phirigi xam taneh gùng Galati, majah qmang aih Yiang Hadròeh khoe ùh lòh wì haq lam anoe Bàu lem ta cròng Asi. ");
INSERT INTO hrebt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ten trùh gùng Misi, wa padon mùt tagùng Bithini, mahaq Yiang Hadròeh da Jesus ùh am, ");
INSERT INTO hrebt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","wa drah lam khoe ka gùng Misi, èh wa loh ta Trô-ach, ");
INSERT INTO hrebt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Jò damang, Phaulô hnoq kan mahno, i mòeq ngai Maxêđoan yòng eh ngèa rađeh, cali calo ka haq rameh: “Drah trùh ta Maxêđoan hu dèch nhèn diq.” ");
INSERT INTO hrebt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Atìq ka Phaulô hnoq kan mahno aih, nhèn hi drah lam padon lam ta Maxêđoan, majah qmang aih nhèn loq Boc Plình khoe creo ka nhèn lam anoe Bàu lem ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Qmang aih, enhTrô-ach nhèn tŏc bong pajang trùh ta Samôtra, hì atìq nhèn trùh ta Napôli; ");
INSERT INTO hrebt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","enh aih, nhèn trùh ta Philip, gùng aih khoe jah diac Roma, aih phôq basèm da tình Masêđoan. Nhèn oe ta aih toq biaq hì. ");
INSERT INTO hrebt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Trùh hì sabat, nhèn loh enh gùng ka phôq, lam roc kênh cròng diac, nhèn hèm dèh wì tagop dabau ta aih đòeq hu waiq khàn, nhèn hi hangui, khoe aih hi ta hatuàng ti ƀài mangai cadrì oe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","I mòeq ngai ta aih tamàng bàu nhèn, yiniq haq Lyđi, mangai gùng Thia-tiro, haq aih mangai padro bai gòh. Haq aih mangai loq iu yùq ka Boc Plình. Chuaq pèh manoh, haq dìq jaq tamàng bàu Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jò haq xam dìq ka hnim haq khoe jah broq ƀaptem, haq doe: “Tàng joq pì khoe doe au kô mangai dìq manoh ka Chuaq, aih pì ep mùt oe padài ta hnim au”; khoe aih haq hi àu pachùh waq qmòe ka jah. ");
INSERT INTO hrebt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","I mòeq hì, nhèn lam waiq khàn, glàm mòeq ngai hapŏng cadrì i kiac Phitôn mùt oe enh dalam ka haq, haq loh ka loq blàih blŏng, broq ka cla craq haq jah ƀac jènh haraya. ");
INSERT INTO hrebt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Haq ti tiaq Phaulô xam dìq ka nhèn, rai cachech cadêh rameh: Ƀài wì kô, aih dìq hapŏng Boc plình haqnhèq, anoe am ka pì trong jah dèch claih. ");
INSERT INTO hrebt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Bàc hì haq broq qmang aih, Phaulô loh ka mahèu, haq hwi doe ka kiac: “Au canòm ka yiniq Chuaq Jesus Christ thê gè loh enh gùng ka mangai cadrì kô.” Kiac loh qmòe jò aih raq. ");
INSERT INTO hrebt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mahaq cla craq da mangai gucadrì aih, wì hnoq đeh pi oe jah bac jèn enh mangai hapŏng aih, wì rùp Phaulô xam Sila, hua wa trùh tanòe broq bìac, enh ngèa ƀài mangai cwan, ");
INSERT INTO hrebt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","khoe èh aràng wa ta cwan haqnhèq hòm, wì doe: Wa kô dìq mangai Juđa, broq ka gùng bèn loh dŏng ka manhài. ");
INSERT INTO hrebt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Hnài toq trong bèn ùh khòh tamàng yŏc, ùh khòh broq tiaq, majah qmang aih bèn kô mangai Rôma. ");
INSERT INTO hrebt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ƀài mangai ta aih hanoh wiang yòng tablêq ka wa, jò cwan haqnhèq khoe thê hich da wa haq eo, haq hi thê wì tong wa aih. ");
INSERT INTO hrebt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Jò wì tong wa khoe bàc, wì hi lam clêh wa, rai tanap ka cwan wèq hnim clêh aih ep ngan wa ja cajoq. ");
INSERT INTO hrebt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Jah bàu aih, cwan aih hi clêh wa haq ta cadrong clam rai clang da wa jènh. ");
INSERT INTO hrebt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Qnah ta qne mang, Phaulô xam Sila qnang waiq khàn, calêu manè apôi Boc Plình, ƀài mangai wì ma clêh ta aih hadai tàng dŏng. ");
INSERT INTO hrebt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ùh xài oq, taneh loh ka ralàng kàn, xàn hnim ma clêh wì haq loh ka dalàc, adrình hloe mòeq yàng ƀài qmŏc qmang tapèh dŏng, ƀài caxi datoeq clìh dìq haqneq. ");
INSERT INTO hrebt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mangai wèq hnim clêh rarì cadrat, hnoq qmŏc qmang khoe tapèch dŏng, haq hèm ta manoh ƀài wì cadàu khoe dìq, haq hroe qnoh deh chang hu pàc đac rađeh. ");
INSERT INTO hrebt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mahaq Phaulô creo cadêh: “Apaq broq cleq ti haƀo ka rađeh, nhèn oe dìq tacô.” ");
INSERT INTO hrebt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mangai wèq hnim clêh drah creo ka wì qnoh đen, haq rai tùh rai crè, hacùn cràng ajang jènh Phaulô xam Sila. ");
INSERT INTO hrebt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Khoe aih, haq qnoh wa loh enh gùng rai bòch: Wì craq! au ep broq cleq men jah dèch? ");
INSERT INTO hrebt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wa padreo bàu: “Drah lùi Chuaq Jesus, aih èh ìh xam dìq ka hnim ìh hi jah dèch.” ");
INSERT INTO hrebt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wa hi hnài ka haq xam rìm mngai ta hnim haq trong Boc plình, . ");
INSERT INTO hrebt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mang aih, hloe jò aih raq mangai wèq hnim clêh qnoh wa aih, qnheo da wa habau, khoe aih xam cla haq xam mangai oe ta hnim haq dìq jah broq ƀaptem. ");
INSERT INTO hrebt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Khoe aih, akhen ka wa hlài deh ta hnim, padon qnoh ka wa acaq, cla haq xam dìq ka mangai ta hnim lem bùi ka rađeh jò wì khoe jah tiaq trong Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Trùh qngah, cwan enh qnhèq thê lình lam anoe ka mangai wèq hnim clêh rameh: Drah caqnaih wa beq. ");
INSERT INTO hrebt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Haq aih anoe ka Phaulô: Ƀài cwan enh qnhèq khoe thê au caqnaih chôp lam, chôp loh beq, lam ma catèm haq oq. ");
INSERT INTO hrebt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mahaq Phaulô doe ka mangai lình: “Nhèn kô mangai diac Rôma, qnhòq loq ma i yiniq lui cleq, wì khoe blai ma qne mangai đùng đam, khoe aih clêh ma ta hnim cadrong, manòeq kô aih wì haq caqnaih atùng ma qmòh? Qmang aih ùh jah. Cla ƀài cwan ep lam jang kô hu caqnaih ma, xài qmang aih ma troq.” ");
INSERT INTO hrebt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ƀài cwan enh qnhèq tàng lình anoe hlài qmang aih, loq ka wa haq aih mangai Rôma, wì haq yùq pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Wì lam alìa èh hi caqnaih wa, rai cali calo dôq wa loh khoe gùng wì haq. ");
INSERT INTO hrebt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Jò khoe jah caqnaih, wa lam ta hnim Liđy, hmàih ra pariaq, khoe aih wa men lam. ");
INSERT INTO hrebt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Phaulô xam Sila pagat trong gùng Amphi-bôlit xam gùng Abôloni, khoe aih wa trùh ta Têsalonica, ta aih mangai Juđa i mòeq toq hnim tagop qyoh. ");
INSERT INTO hrebt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Phaulô tiaq dèh cla khoe hmaq, ta piq hì saƀat haq mùt ta aih hu rahen ka wì. ");
INSERT INTO hrebt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Yŏc Hset Hadròeh patô ka hloh dôq wì loq Christ ep xalep, khoe aih rìh hlài enh kan cachìt. Haq doe: “Chuaq Jesus au ma khoe anoe ka pì kô aih raq Christ.” ");
INSERT INTO hrebt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Taqne mangai Juđa, aih i ƀiaq ngai lùi tiaq bàu rai taq mùt ti Phaulô xam Sila, èh hadai i bàc ngai Gorec loq iu yùq ka Boc plình hloe xam ƀài mangai gucadrì padrŏng ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mahaq mangai Juđa toq tajìq, ti adràc ƀài mangai lam ròe ratauq roc trong rai baxrùq mangai gùng aih broq kan manhài ta phôq aih. Wì haq clàm mùt ta hnim Jasôn, ti chaq Phaulô xam Sila đòeq hu rùp qnoh taqne mangai đung đam ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Chaq ùh hnoq, wì haq hi hua qnoh Jasôn xam biaq ngai oh daq loh enh ngèa ƀòe cwan wèq gùng aih, wì cachech: Kô raq ƀài mangai khoe broq ka phù cròng loh toq kan manhài, manoèq wì haq khoe trùh tacô diq. ");
INSERT INTO hrebt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasôn khoe đìh wì haq mùt oe dèh ta hnim! Wì haq kô dìq ƀài mangai yòng tablêq ka Sêsa, majah qmang aih wì haq doe oe i mòeq toq bùa qnoeq, yiniq haq aih Jesus. ");
INSERT INTO hrebt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tàng bàu aih dìq ka mangai ta aih hloe xam ƀài cwan loh dŏng ka rawè. ");
INSERT INTO hrebt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mahaq jò cwan khoe thê Jasôn xam bua haq ep clìh ka ƀac, aih hi caqnaih wì haq lam. ");
INSERT INTO hrebt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ùh batrò, mang aih raq oh daq drah thê Phaulô xam Sila lam ta Ƀêrê. Trùh ta aih, wa mùt ta hnim tagop qyoh da mangai Juđa. ");
INSERT INTO hrebt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mangai Bêrê i manoh ùh hnau ka mangai Têsalônica, majah qmang aih wì haq toq enh tamàng yŏc bàu hnài, hì leq hì meh toq ti ngan ta Hset hadròeh đòeq hu ngan bàu Phaulô xam Sila hnài ajoq troq ùh. ");
INSERT INTO hrebt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ta aih i bàc ngai Juđa lùi tiaq, i bàc ngai gucadrì Gorec ma padrŏng, i bàc ngai gucalô hanoh lùi tiaq. ");
INSERT INTO hrebt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mahaq jò mangai Juđa oe ta Têsalônica tàng doe Phaulô anoe trong Boc Plình ta Bêrê, wì haq drah trùh ta aih hu rai kan manhài đòeq baxrùq mangai ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Oh daq drah thê Phaulô lam trong diac raxìq, mahaq Sila xam Timôthê oe raq ta Bêrê. ");
INSERT INTO hrebt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ƀài oh daq ma ajèn Phaulô wì aràng haq trùh ta Athen, èh wì hi bròc, ahlài bàu ka Sila xam Timôthê, thê wa drah rênh trùh ti Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Phaulô oe ta Athen gòm wa aih trùh, haq jìq qmòe ta manoh majah qmang aih haq hnoq ta aih bình toq qmù dua kan kiac. ");
INSERT INTO hrebt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Qmang aih, ta hnim tagop qyoh haq rahen ka mangai Juđa xam mangai Gorec ma loq iu yùq ka Boc Plình, xam mangai haq glàm rìm hì tanòe padro atech. ");
INSERT INTO hrebt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","I ƀài mangai hŏc tiaq trong da Êpicurien xam trong da Stocien, hadai wiang ta rahen ka haq. Qnah ngai doe: Cleq bàc bàu kô haq enh anoe cleq? Qnah ngai doe: Tìah gleq haq enh anoe ka bèn ƀài kiac diac wì. (Majah qmang aih Phaulô qnang anoe trùh Chuaq Jesus xam trong rìh hlài enh kan cachìt am ka wì). ");
INSERT INTO hrebt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Wì rùp aràng haq trùh ta Arêoba, wì bòch: Nhèn ajah loq trong ìh neo hnài aih ùh? ");
INSERT INTO hrebt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Majah qmang aih ìh hnài ka nhèn trong joq halac, nhèn enh loq qmang leq ka dèh. ");
INSERT INTO hrebt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Dìq ka mangai Athen xam mangai diac wì ma oe ta aih enh toq tamàng rai ta anoe trong maneo ma halac.) ");
INSERT INTO hrebt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Jò aih, Phaulo mahi yòng taqne Arêoba, haq doe: “Mangai Athen tamàng kô, au hnoq yac ka trong leq dua pì loq nhet pi cajaq. ");
INSERT INTO hrebt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Majah qmang aih au lam dudan tanòe pì, au ngan qmòe ka adia hnoq ƀài ngè pì kùh waiq, ta aih mòeq toq prang i achìh: KÙH WAIQ KIAC NHÈN QNHÒQ QNÌ, manòeq kô Yiang au qnang anoe ka pì, aih raq Mangai pì qnhòq qnì mahaq khoe kùh waiq. ");
INSERT INTO hrebt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Boc Plình ma khoe broq loh plình crŏng taneh xam rìm yiniq rìh oe ta aih, aih raq Chuaq da plình crŏng taneh. Haq ùh oe ta hnim kùh waiq broq loh enh tì kŏng kon mangai. ");
INSERT INTO hrebt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Haq hadai ùh ep waq ka i tì kon mangai patìh ka rađeh, tìah taiq ka haq ma i nan no cleq, majah qmang aih haq raq ma am ka rìm ngai jah kan rìh, hiwa rìh, xam hloe rìm yiniq qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Haq khoe broq dìq ka phù cròng ha-uang loh enh mòeq ngai raq, am wì oe jàp crŏng taneh, pajaq adroe qnhòng rìh rai acang ka wì nòe oe. ");
INSERT INTO hrebt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Boc Plình khoe broq qmang aih dôq kon mangai loq chaq haq, àu qmòe dìq ka padren waq ka jah bèq, yac ka haq ùh i oe hangai ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Majah qmang aih enh dalam ka haq, bèn jah rìh, jah tadroq, jah i, tìah ka calah nèh taqne pì ƀài mangai ma loq cachôi i doe: Bèn kô hadai xinoe haq. ");
INSERT INTO hrebt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Qmang aih, bèn kô xinoe Boc plình, apaq hèm haq tìah taiq ka wang, ƀac, ka hmo, tìah ka qmù broq loh enh tì kŏng mangai ma rabiaq. ");
INSERT INTO hrebt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Enh nèh, Boc Plình khoe cađac da wì kan blùng aih, manòeq haq thê dìq dŏng kon mangai oe rìm nòe ep loq raxach, ");
INSERT INTO hrebt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Majah qmang aih Boc plình khoe ràih đòeq dèh mòeq hì, yŏc kan taq atoq hu hadrah crŏng taneh xi mangai haq ma khoe dì deh adroe, Boc Plình khoe broq ka haq aih rìh hlài enh kan cachìt, đòeq panhìn ka cajap trong kô. ");
INSERT INTO hrebt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Jò wì tàng anoe trùh mangai cachìt rìh hlài, qnah ngai aih hi halê haq, qnah ngai doe: Hêq trong aih yàng qnoeq èh nhèn tamàng ònh. ");
INSERT INTO hrebt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Aih ìq Phaulô majah cadiang loh khoe ka wì haq. ");
INSERT INTO hrebt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mahaq i ƀiaq ngai tiaq haq wì hi lùi Chuaq Jesus, ta aih i Đêni, mangai cwan hadrah ta Arêoba, i tam mòeq ngai gucadrì yiniq haq Đamari xam ƀài mangai qnoeq ");
INSERT INTO hrebt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Khoe èh, loh enh Athen Phaulô lam ta Côrintô. ");
INSERT INTO hrebt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ta aih haq glàm mòeq ngai Juđa, yiniq haq Aquila mangai gùng Ƀông xam Ƀêritsin aih mai haq, wa aih neo trùh tacô majah qmang aih bùa Kolôt i thê dìq dŏng mangai Juđa ep loh ma khoe ka Rôma, Phaulô hi taqmùt ti wa. ");
INSERT INTO hrebt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Haq hanoh mangai ajìp traiq qmang ka wa, aih ìq Phaulô majah oe mòeq hnim ti wa đòeq hu abroq pajùm ti dabau. ");
INSERT INTO hrebt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Rìm hì Saƀat Phaulô hnài ta hnim tagop qyoh, pariaq mangai Juđa xam mangai Gorec. ");
INSERT INTO hrebt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Jò Sila xam Timôthê enh gùng Maxêđoan trùh ta aih, aih Phaulô hi cađac ka ajìp đòeq toq ti hnài. Anoe patô ka mangai Juđa loq Chuaq Jesus aih raq Christ. ");
INSERT INTO hrebt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Mahaq wì tablêq rai jù cađac haq, aih ìq haq majah da arù deh eo rai doe: Mahim pì da hrôq hlài tagàu cla pì! Au ùh pòq, pang kô èh au lam trùh ti mangai diac wì. ");
INSERT INTO hrebt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Loh enh aih Phaulô mùt ta hnim mòeq ngai yiniq haq Titiu Juptu, aih mangai loq iu yùq ka Boc Plình, hnim haq aih pajùm panàt ka hnim tagop qyoh. ");
INSERT INTO hrebt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Koritbu mangai broq gàu hnim tagop qyoh, xam dìq ka hnim haq lùi dŏng Chuaq Jesus. Khoe èh i bàc ngai Côrintô khoe hmaq tàng Phaulô hnài, hadai lùi rai chìuq broq Baptem. ");
INSERT INTO hrebt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","I mòeq mang Chuaq doe ka Phaulô ta kan mahno: “Apaq yùq cleq! anoe beq! apaq hatinh; ");
INSERT INTO hrebt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","au oe ti ìh, ùh i cabô jah dèch tì broq habo cleq ka ìh, majah qmang aih au i bàc ngai oe tacô.” ");
INSERT INTO hrebt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Phaulô oe ta aih mòeq hanam tadràu khê, hnài ka wì trong Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Jò Galiôn qnang broq cwan kàn tagùng Achai, mangai Juđa mòeq manoh wiang ti dabau hu taƀlêq ka Phaulô wì rùp aràng haq trùh ajang nòe hnim hadrah, ");
INSERT INTO hrebt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","wì doe: Haq kô toq ti baxrùq mangai tagùng bèn kùh waiq Boc Plình ùh troq tiaq ka ranenh. ");
INSERT INTO hrebt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Phaulô qnang hah bàu hu hatèu, Galiôn khoe doe ka mangai Juđa: Dìq ka mangai Juđa pì tamàng kô, tàng joq i cleq ma ùh troq, tàng joq loq i yiniq lui cleq, ma aih au troq ka hangui tamàng pì. ");
INSERT INTO hrebt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mahaq tàng joq tarahen trong bàu tapoch, trong yiniq creo, trong ranenh da pì, aih cla pì hadrah deh, au ùh tamàng trong qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Haq hi hnan qnoh đac wì loh enh gùng ka hnim hadrah. ");
INSERT INTO hrebt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Jò aih, wì hi tawìh rùp ataq Sôthen, mangai broq craq hnim tagop qyoh, tong rachùq haq aih enh ngèa hnim hadrah, mahaq dua Galiôn ùh waq tamàng. ");
INSERT INTO hrebt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Phaulô oe tam ta Côrintô toq ƀiaq hì, khoe aih haq hangah ka oh daq, haq tŏc boang ti Bêritsin xam Aquila wì haq lam tagùng Syri, atìq ka haq got gàu ta Sencôrê, majah qmang aih haq khoe i bàu hapah deh adroe; ");
INSERT INTO hrebt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","khoe aih wì piq ngai trùh ta Êphêsô, Phaulô dôq deh bua oe ta aih. Cla haq aih mùt ta hnim tagop qyoh, capoch tùang ti mangai Juđa. ");
INSERT INTO hrebt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Jò wì aih enh àu haq oe tam ti wì toq ƀiaq hì hòm, haq ùh òq bàu. ");
INSERT INTO hrebt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Haq hangah ka wì aih rameh: Tàng joq Boc plình thê, yàng qnoeq hòm au hi trùh ti pì, khoe aih enh Êphêsô haq tŏc boang lam. ");
INSERT INTO hrebt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Jò boang khoe trùh ta Sêsarê, haq tŏc ta Jêrusalem, hmàih ka Tagop hadròeh, khoe ka aih, haq loh hòm ta Antiôt. ");
INSERT INTO hrebt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Oe ta aih toq ƀiaq hì, haq lam hòm, haq lam jàp jìa ka gùng Galati hloe xam gùng Phirigi, broq dìq dŏng ka mangai tiaq hŏc cajap manoh. ");
INSERT INTO hrebt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jò aih i mòeq ngai Juđa, yiniq haq Abôlô, gùng haq oe ta Alecxantri, haq aih mangai rabiaq ka tapoch tùang rai rabiaq ka Hset hadròeh, haq trùh ta Êphêsô. ");
INSERT INTO hrebt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Haq khoe hŏc trong Chuaq, dài haq majah dìq ka manoh anoe rai hnài rìm trong da Chuaq Jesus, yac ka haq bu loq đeh toq Ƀaptem da Jon. ");
INSERT INTO hrebt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Qmang aih, enh jò baxèm haq khoe hùa hnài qmòe ka hagau hagình ta hnim tagop qyoh. Bêritsin xam Aquila tàng haq hnài, wa ahlài haq hlài ta wa, anoe trong Boc Plình dôq haq loq tam ùh hnau hòm. ");
INSERT INTO hrebt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Jò Abôlô padon lam ta Achai, dìq dŏng oh daq wiang parông haq rai achìh jàiq tanap ka mangai tiaq hŏc ta aih ep đìh haq ka alàng. Jò haq khoe trùh ta aih, canòm ka kan loq waq jah dech enh Boc Plình haq broq lòeq ka oh daq ma khoe lùi. ");
INSERT INTO hrebt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Haq dìq cajaq ƀàt hlài mangai Juđa qne mangai bàc, yŏc Hset Hadròeh đòeq mahnu ka wì loq Chuaq Jesus aih ra Christ. ");
INSERT INTO hrebt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Jò Aƀôlô oe ta Côrintô, Phaulô lam khoe jàp ta ƀài gùng enh qnhèq, khoe aih haq loh ta Êphêsô, ta aih haq glàm toq biaq ngai tiaq hŏc. ");
INSERT INTO hrebt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Haq bòch wì: “Pang jò oh daq khoe lùi, akhoe jah yŏc đeh Yiang Hadròeh ùh?” Wì padreo bàu: “Ùh! Nhèn qnhòq lah tàng doe i Yiang Hadròeh. Phaulô bòch hòm: “Tàng qmang aih Ƀaptem leq pì khoe jah? ");
INSERT INTO hrebt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Wì doe: “Ƀaptem da Jon aih.” ");
INSERT INTO hrebt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Phaulô doe: “Ƀaptem da Jon aih ƀaptem da kan loq raxach dèh ka yiniq lui, rai thê wì lùi Mangai ma trùh atìq ka haq, aih lùi Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wì tàng qmang aih, wì hi broq ƀaptem canòm ka yiniq Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Jò Phaulô roh tì ta chac wì haq, Yiang Hadròeh loh ta wì haq, am wì haq capoch bàu qnoeq xam bàu pajàu. ");
INSERT INTO hrebt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Dìq ka wì aih jah ta mòeq jàt baiq ngai. ");
INSERT INTO hrebt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Phaulô mùt ta hnim tagop qyoh, ta piq khê haq ùh hòq qmòe ka hnài wì ta aih, mahnu ka wì loq bàc trong da Diac Plình đòeq hu pariaq mangai ma tamàng haq. ");
INSERT INTO hrebt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mahaq ta aih i qnah ngai cadoq manoh, wì tàih đac ùh waq lùi, enh ngèa phù cròng wì haq tapoch halê trong Boc Plình, aih ìq Phaulô majah hi lah rađeh, tagop deh crài mangai ma tiaq hŏc, rìm hì haq hnài ta truàng Tiranu. ");
INSERT INTO hrebt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ƀaiq hanam qmang aih, rìm ngai oe ta cròng Asi, yac ka mangai Juđa, yac ka mangai Gorec, dìq tàng trong Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Boc Plình broq bàc bìac halac anòe tì kŏng Phaulo, ");
INSERT INTO hrebt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","wì yŏc mù yŏc eo haq ma khoe caxùnh taqmàn ka ƀài mangai ùh hrŏc, dìq ka wì aih loh ka jah brêh, jah paclaih enh kiac dù. ");
INSERT INTO hrebt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","I bài mangai Juđa, lam dudan enh gùng kô trùh gùng tau, wì haq patìah rađeh canòm yiniq Chuaq Jesus đòeq drùh qnoh kan kiac, wì doe: “Au canòm ka Yiniq Chuaq Jesus, aih la mangai Phaulô ma hnài, au thê gè loh beq! ");
INSERT INTO hrebt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tapèh ngai ma broq qmang aih dìq kon calô da Sêwa, haq aih hanoh mangai broq pajàu kàn ta mangai Juđa. ");
INSERT INTO hrebt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","I mòeq hì, kiac dù tèu bàu: Chuaq Jesus, au loq, Phaulô aih cabô au hadai loq, mahaq pì kô ìq cabô? ");
INSERT INTO hrebt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mangai kiac ma rùp aih, glàm ta wì aih, haq blêq dŏng wì, haq jêh pani rachùq wì, wì habau habùa dŏng tachac, loh qmòe ka cadàu qmòe rahòng khoe ka hnim aih. ");
INSERT INTO hrebt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Jò mangai Juđa xam mangai Gorec rìh oe ta Êphêsô hìa qmang aih, wì yùq crè dìq jaq, yiniq Chuaq Jesus jah dèch ka haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bàc ngai ma khoe lùi, lam paqnoh dèh yiniq lui, anoe dŏng rìm trong wì haq ma khoe broq. ");
INSERT INTO hrebt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bàc ngai adroe ka aih broq pajàu tadreo aràng bùh dèh hset enh ngèa ka phù cròng, wì boq hset aih tàng tech jah padam mùan hliac bac. ");
INSERT INTO hrebt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Qmang aih, Bàu lem hlàng hangai jàp jìa rai èh rai cajap. ");
INSERT INTO hrebt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Atìq ka ƀài yiniq aih, Phaulô enh pagat trong gùng Maxêđoan xam Achai đòeq hu lam ta Jêrusalem. Haq doe: “Jò au khoe hmàih ta aih, au hadai ep lam hmàih ta Rôma diq. ");
INSERT INTO hrebt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Haq thê Timôthê xam Êrat, aih baiq ngai ma wiang ti haq chônh lam ta Maxêđoan, cla haq oe raq ta Asi biaq hì hòm. ");
INSERT INTO hrebt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Jò aih i kan manhài kàn enh tablêq ka Bàu lem. ");
INSERT INTO hrebt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","I mòeq ngai thòq ƀac yiniq haq aih Đêmêtriu, haq yŏc ƀac broq loh radua qmù kiac cadrì Đi-an, broq ka bàc ngai thòq ma patìh ka haq jah bàc kùng hang, ");
INSERT INTO hrebt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","haq gop ƀài wì aih, haq doe: “Oh daq bèn loq, bèn jah padrŏng kan enh bìac abroq kô, ");
INSERT INTO hrebt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","pi hadai hnoq, hadai tàng, ùh xài toq ta Êphêsô, mahaq ten dìq hloe ka cròng Asi, Phaulô padô broq ka bàc ngai khoe tawìh manoh, haq doe kiac loh enh tì kŏng kon mangai aih dìq ùh xài kiac. ");
INSERT INTO hrebt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ùh xài bèn toq yùq ka yiniq abroq da bèn kô èh wì loq halê, mahaq bèn hadai yùq ka hnim kùh waiq da Đi-an kiac cadrì kàn kaiq kô èh wì loq jù đac, èh kan ranhòm kiac cadrì da bèn oe tagùng Asi xam dìq crŏng taneh kô loq lùch.” ");
INSERT INTO hrebt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tàng toq aih bàu, tagrùang qmòe wì plôh nòeh, wì cachech cadêh: “Kàn oe i jaq cleq Đi-an kiac cadrì da mangai Êphêsô.” ");
INSERT INTO hrebt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Dìq ka Êphêsô loh dŏng ka manhài, wì rùp Gai-ut xam Aritac, mangai gùng Maxêđoan, wa aih hanoh lam pajùm ti Pahulô, mòeq manoh ka dabau wì hua wa aih qmùt ta hnim kon hat. ");
INSERT INTO hrebt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Phaulô enh cla rađeh loh yòng enh ngèa wì ta aih, mahaq mangai tiaq hŏc ùh am. ");
INSERT INTO hrebt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Èh hadai i ƀài cwan kàn ta Asi aih bua haq, thê mangai lam doe ka haq ùh dùh lam ta hnim kon hat. ");
INSERT INTO hrebt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Qnah ngai cajiah qmang kô, qnah ngai cachech qmang tau, nòe wì tagop loh ka tagrùang, bàc ngai ùh qnì hagleq rađeh majah wiang lam tagop dèh tacô. ");
INSERT INTO hrebt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wì dùi qnoh Alecxanđo loh enh gùng ka mangai đùng đam, mangai Juđa caqnhùt haq loh yòng enh ngèa, haq hnhè tì enh ngèa ka wì hu capoch hu cwaih rađeh. ");
INSERT INTO hrebt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mahaq jò wì bu canau ka haq aih mangai Juđa, beq meh dìq ka wì wiang cachech tagrùang jah baiq jò đùng hô: “Kàn dìq jaq! Đi-an kiac cadrì da mangai Êphêsô!”. ");
INSERT INTO hrebt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Jò aih i cwan thu kìq ta phôq aih, loh pagàt wì haq waq ka hatinh, haq doe: “Oh daq mangai Êphêsô! dìq ta crŏng taneh kô, cabô ùh loq đeh hra gùng Êphêsô bèn kô raq mangai wèq hnim tadreo da Đi-an kiac cadrì ma dìq jaq kàn, radua qmù haq aih khoe loh qmòe enh trŏc tì qmòh? ");
INSERT INTO hrebt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Yiniq aih ùh ep rahen dèh, pì oe ma hatinh haq, apaq tem broq cleq loh yiniq, ");
INSERT INTO hrebt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Majah qmang aih ƀài mangai pì ma khoe aràng trùh tacô ùh i atùng cleq ta hnim tadreo, wì haq hadai ùh i tapoch qmèq cleq trùh kiac cadrì da bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Manòeq kô, tàng joq Đêmêtriu xam ƀài thòq ma abroq ka haq, i yiniq enh tah hadarh ka cabô, hnim hadrah pèch qmang rìm hì, cwan kàn hanoh oe ta aih. Dôq ka da wì tah hadrah ka dabau. ");
INSERT INTO hrebt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tàng joq pì i enh bòch tam cleq, pì lam trùh ta wì mangai hadrah, dôq wì haq hadrah troq tiaq ranenh. ");
INSERT INTO hrebt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Majah qmang aih, yùq loq haƀo ka bèn tàng joq wì bòch hagleq bèn majah rèu ka broq lìq hì kô, bèn chaq ùh loh trong đòeq hutèu. ");
INSERT INTO hrebt_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Haq capoch toq aih bàu, khoe aih haq thê wì hlài. ");
INSERT INTO hrebt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Jò kan manhài khoe jah hatinh, Phaulô creo ka ƀài mangai tiaq hŏc trùh, khoe ka pariaq oh daq, haq hangah ka wì đoèq lam tagùng Maxêđoan. ");
INSERT INTO hrebt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Haq lam jàp gùng aih, haq anoe bàc trong đòeq pariaq mangai lùi; khoe aih haq lam ta diac Gorec, ");
INSERT INTO hrebt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","oe ta aih piq khê. Taiq mangai Juđa khoe hatình chaq trong hu jêh đac haq jò haq bu tŏc boang lam ta Syri, aih ìq haq majah hi wìh trong Maxê đoan đoèq hu hlài. ");
INSERT INTO hrebt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sôbate, kon da Biru, mangai gùng Berê, lam ti haq, i tam Aritac xam Sacunđu mangai gùng Têsalônica, Gai-ut, gùng Đecbo xam Timôthê, Tichico xam Trôphim dìq gùng Asi. ");
INSERT INTO hrebt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Wì kô lam adroe, gòm nhèn ta Trô-ach. ");
INSERT INTO hrebt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Atìq ka hì ramènh acaq ƀênh ùh wàt blo, nhèn tŏc boang enh Philip, padam hì atìq nhèn glàm dabau ta Trô-ach, èh nhèn oe ta aih tapèh hì. ");
INSERT INTO hrebt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Hì baxèm tagàu tuàng, nhèn tagop dabau đòeq goh ƀênh, Phaulô ep lam hì da èh, dài haq majah hatùang ka oh daq rai hnài hloe trùh qne mang, ");
INSERT INTO hrebt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","I bàc toq đen talàu nòe nhèn ma qnang tagop dabau. ");
INSERT INTO hrebt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","I mòeq ngai radam yiniq haq Ôtic, hangui ajang trong qmŏc, Phaulô hnài xòe hêq haq aih loh ka gù kùi, jò kùi pi hmàng haq taclìh enh làu piq, wì loh dèch hnoq haq khoe cachìt. ");
INSERT INTO hrebt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Mahaq, Phaulô cadiang loh chinh deh chac ta mangai aih, yŏc tì kwat chac haq rai doe: “Apaq lèt, mahua oe raq tachac. ");
INSERT INTO hrebt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Phaulô tŏc hlài taqnhèq, goh acaq ƀênh; rai anoe hnài hòm trùh qngah men lam. ");
INSERT INTO hrebt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mangai radam oe rìh, wì tòng ahlài haq ta hnim, yiniq aih broq ka wì jah alòng haraya. ");
INSERT INTO hrebt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ƀài nhèn hòm, chônh lam adroe, tŏc boang lam ta Asôt, aih nòe nhèn ma hu glàm Phaulô; haq khoe taqmroq deh qmang aih, majah qmang aih haq enh lam jènh. ");
INSERT INTO hrebt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nhèn glàm Phaulô ta Asôt, khoe aih haq tŏc boang ti nhèn, hadai nhèn trùh ta Mitilen. ");
INSERT INTO hrebt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Khoe enh aih, tiaq trong diac raxìq, sroq eh nhèn trùh tajang ka pleo Chi-ô. Hì atìq hòm nhèn padòh mùt ta plaì Samôt, mòeq hì hòm hi trùh ta Milê. ");
INSERT INTO hrebt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Phaulô khoe dì deh ta manoh, haq chônh lam adroe ta Êphêsô, mahaq ùh padài ta aih yùq loq trò ta cròng Asi. Haq haqnan lam waq ka trùh ta Jêrusalem tem ramènh Hì padam jàt. ");
INSERT INTO hrebt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Yàng aih, Phaulô thê wì ma oe ta Milê lam ta Êphêsô akhen ka wì gucraq broq gàu Tagop Hadròeh lam glàm haq. ");
INSERT INTO hrebt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Jò wì aih khoe trùh tagop ti haq, haq anoe “Enh jò au baxèm trùh ta Asi, au acaq oe qmang leq qne pì, oh daq loq. ");
INSERT INTO hrebt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Au qnoh rađeh dìq jaq haqneq hu patìh ka Chuaq, loh bàc diac mat, bàc yàng mangai Juđa khoe qnhro ngan rai chaq trong jêh đac au. ");
INSERT INTO hrebt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Oh daq loq, au ùh lòm ra-òeq đòeq anoe ka oh daq loq trong leq ma lem ka pì, ùh lòm cadoc qmòe toq xit cleq, èh hòm pì loq au khoe hnài taqne nòe mangai bàc, ùh meh enh hnim kô trùh hnim tau, ");
INSERT INTO hrebt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","hnài ka mangai Juđa xam mangai Gorec kan loq raxach đòeq hu wìh hlài ta Boc Plình, xam kan lùi enh dalam ka Chuaq Jesus Christ aih Chuaq bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Manòeq kô Yiang Hadròeh khoe panan, thê au lam ta Jêrusalem, qnhòq qnì i yiniq cleq trùh ka au ta aih èh, ");
INSERT INTO hrebt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Moèq yiniq raq Yiang Hadròeh khoe anoe ka au loq: enh phôq kô trùh phôq tau, kaxi datoeq xam kan nanxa khoe gòm đòeq au. ");
INSERT INTO hrebt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mahaq au ùh i adênh ka rađeh, toq ran broq qmang leq au cadàu magêh dèh ka trong, broq gêh yiniq Chuaq Jesus ma khoe thê au, lam panhìn Bàu lem aih kan am dech da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Manoèq kô, taqne oh daq au ma khoe trùh anoe hnài diac Boc Plình, kô èh pi i cabô oe hnoq hadrò au hòm. ");
INSERT INTO hrebt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Aih ìq raq, dài hì kô au majah doe dìq ka mahim oh daq au pi pòq. ");
INSERT INTO hrebt_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Majah qmang aih au ùh lòm i ra-òeq đòeq anoe ka oh daq jah loq manoh da Boc Plình ma enh. ");
INSERT INTO hrebt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Oh daq ep wèq rađeh, èh wèq hloe xam ƀài Yiang Hadròeh ma khoe dèch oh daq broq mangai wèq, đoèq ban Tagop Hadròeh da Boc Plình haq ma khoe rot deh xi mahim cla. ");
INSERT INTO hrebt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Au loq khoe ka au loh lam kô èh, i koq yiang ngang dù mùt taqne pì, haq ùh i adênh ka oh daq. ");
INSERT INTO hrebt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Taqne oh daq hòm imangai yòng tapoch bàu patah, àu padô mangai tiaq hŏc cadàu tiaq wì haq. ");
INSERT INTO hrebt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Qmang aih, drah loq hamang, hmàng hlài khoe piq hanam rìm hì rìm mang au loh diac mat đòeq hu pariaq rìm ngai oh daq. ");
INSERT INTO hrebt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Manòeq kô au jao oh daq dìq ta tì kŏng Boc Plình ta kan loq waq haq ma am dech ka bèn, aih jao oh daq ka Mangai broq ka oh daq jah cajap rai am kùng hang ka oh daq pajùm ti mangai jah hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Au ùh i lòm daiq ka ƀac, wang, eo yôh cabô. ");
INSERT INTO hrebt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Cla pì oh daq loq, baiq toq capiang tì kô khoe broq loh dahwèq ka cla au xam ƀài bua au. ");
INSERT INTO hrebt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Au khoe hnài yôt, oh daq ep panim ka abroq qmang aih, đòeq hu wiang tabàih ka mangai hamoq, rai hmàng hlài ka bàu Chuaq Jesus i doe: hnhu am aih i xôq ramot ùh hnau ka hnhu yŏc. ");
INSERT INTO hrebt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Khoe ka capoch qmang aih, Phaulô hacùn cràng waiq khàn pajùm ti wì. ");
INSERT INTO hrebt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mangai leq mangai meh hmoe đeh hra, rai kwat ranŏng Phaulô rai hìp haq, ");
INSERT INTO hrebt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","wì mangò pi cajaq jò tàng haq doe: kô èh oh daq pi hnoq hadrò rađeh hòm. Khoe aih, wì qnoh haq tŏc boang. ");
INSERT INTO hrebt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Atìq ka talah ka wì aih, nhèn tŏc boang lam trùh hloe ta Kôt, hì atìq trùh ta Ruđo enh aih nhèn trùh ta Batara. ");
INSERT INTO hrebt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ta aih nhèn hnoq moèq toq boang padon lam ta Phênisi; nhèn hi tŏc boang aih đòeq hu lam. ");
INSERT INTO hrebt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Jò khoe hnoq pleo Chipro, nhèn hi puplech apah qma, tiaq trong lam ta Siri, boang hi yòng majah qmang aih boang ep qnoh hang ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nhèn chaq hnoq ƀài mangai tiaq hŏc, nhèn hi oe ti wì tapèh hì. Mangai tiaq hŏc ta aih jah Yiang Hadròeh pariaq, wì aih padràng Phaulô apaq tŏc ta Jêursalem. ");
INSERT INTO hrebt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mahaq jò khoe dìq ka hì padài, nhèn hi lam dèh hòm; ƀài mangai tiaq hŏc xam cadrì kon wì haq wiang lam ti nhèn loh enh gùng ka aih, dìq ka wì haq hacùn cràng tago, waiq khàn ti da bau. ");
INSERT INTO hrebt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Atìq ka hangah ka dabau, nhèn loh ta boang, ƀài mangai tiaq hŏc hlài deh ta hnim. ");
INSERT INTO hrebt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nhèn lam trong diac enh Tiro trùh ta Bêtôlêmai, hmàih ka oh daq èh oe ti wì mòeq hì. ");
INSERT INTO hrebt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Hì da èh loh enh aih nhèn trùh ta Sêsarê, mùt ta hnim Philip mangai hnài Bàu lem, (mòeq ngai patìh ta tapèh ngai) nhèn oe ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Haq i pôn ngai kon cadrì oe raq sriu, loq capoch pajàu. ");
INSERT INTO hrebt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nhèn oe ta aih khoe jah toq leq hì, i mòeq ngai pajàu loh enh gùng Juđê yiniq haq Agabut. ");
INSERT INTO hrebt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Haq thia hmàih ka nhèn, khoe aih haq doeh caxi caqnam Phaulô, kàt dèh jènh tì, rai doe: “Kô bàu Yiang Hadròeh doe: Ta Jêrusalem, mangai Juđa kàt mangai ma i caxi qnam kô qmang kô diq, đòeq rùp haq hu am ka mangai diac wì.” ");
INSERT INTO hrebt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Jò khoe tàng toq aih nà, oh daq tiaq hŏc ta aih xam ƀài nhèn wiang cali calo ka Phaulô ùh dùh tŏc ta Jerusalem. ");
INSERT INTO hrebt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mahaq Phaulô padreo bàu: “Oh daq hmoe broq cleq, qnang ti broq ka au loq mangò? Ùh xài toq dôq wì kàt rađeh, yac ka cachìt ka yiniq Chuaq Jesus ta Jêrusalem dua au lènh.” ");
INSERT INTO hrebt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Haq ùh dì bàu pagàt, nhèn hi hêq, nhèn doe: Waiq dôq manoh da Chuaq jah gêh. ");
INSERT INTO hrebt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Khoe aih nhèn hi padon lam tŏc Jerusalem. ");
INSERT INTO hrebt_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","I ƀài mangai tiaq hŏc oe ta Sêsarê hadai lam ta aih ti nhèn, aràng nhèn mùt ta hnim Manason, mangai gùng Chipro, haq aih hadai mangai tiaq khoe dùnh, haq am nhèn padài ta hnim cla haq. ");
INSERT INTO hrebt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Trùh ta Jêrusalem, oh daq ta aih đìh nhèn bùi ka dìq jaq. ");
INSERT INTO hrebt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Hì atìq, Phaulô lam ti nhèn trùh ta hnim Jaco, dìq dŏng ƀài gucraq khoe tagop đòeq ta aih, ");
INSERT INTO hrebt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Phaulô ti bòch hmàih wì haq, khoe èh haq hi taqmon hlài tang yiniq Boc plình khoe broq taqne nòe mangai diac wì ajang tì kŏng rađeh. ");
INSERT INTO hrebt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Tàng qmang aih, wì dèch bàu manè apôi Boc plình. Khoe aih, wì doe ka haq: “Ê daq! Ìh ji hnoq, toq leq jàt muàn mangai Juđa khoe lùi, dìq ka wì aih mangai leq ma ùh nhet pi cajaq trong ranenh. ");
INSERT INTO hrebt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wì hìa, ìh khoe hnài dìq ka mangai Juđa, ma rìh ta mangai diac wì ep cađac Môise, apaq broq ramènh kat akia deh ka ƀài kon, ùh dùh rìh acaq tiaq wì craq qmon. ");
INSERT INTO hrebt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Kô èh bèn broq qmang leq? Wì loq ìh khoe trùh tacô. ");
INSERT INTO hrebt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Manòeq ìh broq tiaq bàu nhèn ma anoe ka ìh, ta nhèn kô i pôn ngai khoe hlac dèh ka bàu hapah; ");
INSERT INTO hrebt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","aràng wì aih lam ti ìh, broq ramènh basròeh ka wì xam ka cla ìh hloe, ƀac wì haq ma got xàc gàu aih, ìh caqnaih. Aih èh wì hi loq đeh hra bàu wì haq ma tàng anoe trùh ìh aih ùh xài, wì hi jah loq joq qnàng ìh hanoh rìh tiaq ranenh. ");
INSERT INTO hrebt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Èh da mangai diac wì ma khoe lùi aih, i nhèn achìh jàiq ka wì haq loq trong nhèn ma khoe dì: Aih ep dênh ùh khòh acaq dahwèq ma khoe tadreo ka kiac, mahim xam jam cachìt ka ùh jah hi hèm. ");
INSERT INTO hrebt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Phaulô hi qnong wì pôn ngai ti haq, trùh hì atìq, haq broq ramènh basròeh ti wì, khoe aih lam ta hnim kùh waiq hu patình ka wì loq trùh hì leq ramènh basròeh men gêh đòeq tang ngai jah dèch ramènh. ");
INSERT INTO hrebt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Jò tapèh hì khoe ten dìq, i ƀài mangai Juđa, gùng Asi hnoq Phaulô oe ta hnim kùh waiq, wì baxrùq dìq dŏng mangai ta aih rùp haq, ");
INSERT INTO hrebt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","wì cachech creo: Dìq dŏng ka manai Isorali, drah tùh wiang tacô! Hacô raq mangai ma ti hnài jàp jìa ka phù cròng đòeq taƀlêq ka mangai bèn, taƀlêq ka ranenh, taƀlêq hloe ka nòe kô, jaq haq mech aràng ƀài mangai Gorec mùt hloe ta hnim kùh waiq broq ka nòe hadròeh ko loh ka pi hruah. ");
INSERT INTO hrebt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Wì majah doe qmang aih, adroe ka aih wì i hnoq Trôphim mangai Êphêsô lam ti Phaulô, wì xoh deh Phaulô khoe qnung haq aih mùt ta hnim kùh waiq. ");
INSERT INTO hrebt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dìq ka mangai gùng aih loh ka tagrùang tagràt, wì tùh loh tagop ti dabau, rùp Phaulô, hrùiq haq qnoh enh gùng ka hnim kùh waiq, khoe èh drah clenh clòng dŏng qmŏc qmang. ");
INSERT INTO hrebt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Wì qnang ti chaq trong hu jêh đac haq, bàu aih hìa trùh don mangai cla craq lình Rôma: Dìq ka Jêrusalem khoe manhài dŏng. ");
INSERT INTO hrebt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Cla craq lình Rôma drah creo ka lình xam ƀài cwan tùh lam ngan. Bu hnoq mangai cla craq xam lình haq, wì hi hêq, pi jêh Phaulô hòm. ");
INSERT INTO hrebt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Craq lình hi thia rùp Phaulô, haq thê wì yŏc baiq hadrang caxi datoeq kàt Phaulô, khoe èh haq bòch: Mangai kô ìq cabô? Haq khoe broq loh yiniq cleq? ");
INSERT INTO hrebt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Qnah ngai doe qmang kô, qnah ngai cachech doe qmang tau, hnoq kan manhài qmang aih, haq pi qnì maleq ma joq troq, haq hi thê lình ahlài Phaulô ta đôn. ");
INSERT INTO hrebt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Jò Phaulô bu cadiang tŏc haqmai hnim, lình ep tòng haq majah qmang aih ƀài wì ta aih xòc hrìn. ");
INSERT INTO hrebt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Pi cajaq cađac mangai ma ti tiaq enh rù, rai tiaq rai cachech: Jêh đac, jêh đac mangai qmat. ");
INSERT INTO hrebt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Jò Phaulô khoe mùt ta đôn, haq anoe ka claq craq lình: “Au ajah anoe đeh toq biaq nà ka ìh? Cla craq lình bòch: “Ìh loq capoch bàu Gorec qmòh? ");
INSERT INTO hrebt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Tàng qmang aih ìh kô ùh xài mangai Êdiptô nèh haq ma broq lìq rai qnung pôn muàn mangai atùng cadàu mùt ta braih kàn qmòh? ");
INSERT INTO hrebt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Phaulô padreo bàu doe: “Au kô mangai Juđa, gùng Tatso, oe ta Silisi aih gùng ma i bang i tìang, ìh dôq au jah tapoch ƀiaq bàu ka wì tau. ");
INSERT INTO hrebt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Jò khoe jah bàu enh cla craq lình, Phaulô yòng ajang caloeh hnim, haq hnhè tì thê wì tamàng. Dìq ka wì oe hatinh, haq capoch ka wì xi bàu Hêbru: ");
INSERT INTO hrebt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Wì daq xam wì baq, tamàng au anoe hu palem rađeh”. ");
INSERT INTO hrebt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Jò wì tàng haq capoch ka wì xi bàu Hêbru, wì loh dŏng ka hatinh. Khoe aih Phaulô doe: ");
INSERT INTO hrebt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Au kô mangai Juđa, hauang ta Tatso, trong gùng Silisi mahaq jah yòng kan tacô. Au hŏc enh qneq ka Gamalien, tiaq troq ka ranenh boc yaq bèn. Nèh haq, au dìq jaq nhet trong Boc Plình, qmang ka pì hì kô diq. ");
INSERT INTO hrebt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Au hmaq ti rùp jêh cađac ka cachìt ƀài mangai ma tiaq Trong kô, rùp clêh gucalô xam gucadrì, ");
INSERT INTO hrebt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","dìq ka pajàu haqnhèq xam wì craq hadrah wiang loq. Au khoe jah jàiq enh wì aih achìh ka oh daq oe ta Đamat, aih nòe au padon lam đòeq rùp kàt ƀài mangai ta aih ahlài ta Jêrusalem hu baxa wì haq. ");
INSERT INTO hrebt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Au qnang lam ti trong, wop qne hì jò au ten trùh ta Đamat, aih cadoe i kan qngah enh plình sreo dudan ka au. ");
INSERT INTO hrebt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Au tacro ta taneh, au tàng i bàu capoch ka au: Saulo, Saulo! Hagleq ìh majah rùp baxa au? ");
INSERT INTO hrebt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Au bòch: Chuaq au, Ìh kô ìq cabô? Haq padreo bàu: Au raq Jesus mangai Naxaret, mangai ìh qnang ti chaq rùp baxa kô. ");
INSERT INTO hrebt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wì ma lam ti au hanoh hnoq kan qngah mahaq ùh tàng bàu Mangai ma tapoch ka au. ");
INSERT INTO hrebt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Au bòch: Chuaq au, manòeq kô au ep broq qmang leq? Chuaq doe: drah yòng, mùt ta Đamat, ta aih èh i mangai anoe ka ìh loq rìm trong au ma khoe thê ìh broq. ");
INSERT INTO hrebt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kan qngah aih qngah picajaq, au loh ka pi xau hnoq, ƀài bua au ep rùp tì tìc au trùh ta Đamat. ");
INSERT INTO hrebt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","I mòeq ngai yiniq haq Anania trùh chaq au, haq aih mangai dìq ka manoh wèq tiaq ranenh, mangai Juđa oe ta Đamat dìq manè haq; ");
INSERT INTO hrebt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","haq yòng enh ngèa au rai doe: Daq Saulo, qngah hlài mat beq, jò aih raq au jah hnoq hloe Anania. ");
INSERT INTO hrebt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Haq doe ka au: Boc Plình da kan cadraq bèn, khoe ràih dôq ìh jah loq manoh Chuaq enh, jah hnoq Mangai Taq atoq, èh jah tàng hloe bàu loh enh hacùng haq. ");
INSERT INTO hrebt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Majah qmang aih, kô èh ìh jah yòng enh ngèa bàc ngai hu anoe rìm yiniq ìh ma khoe hnoq khoe tàng, dôq wì loq ka haq, ");
INSERT INTO hrebt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Manòeq kô ìh oe batrò dèh? Ùh drah yòng creo dang yiniq Chuaq đòeq hu jah ƀaptem hu jah broq hreo deh yiniq lui beq. ");
INSERT INTO hrebt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Jò au ta wìh hlài ta Jêrusalem, au qnang waiq khàn ta hnim kùh waiq, au loh ka pi hmàng ka don ");
INSERT INTO hrebt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","hnoq Chuaq doe ka au: “Drah loh enh gùng ka Jêrusalem ma rênh haq! Majahq qmang aih, bàu ìh ma anoe trùh au mangai tacô ùh waq tamàng”. ");
INSERT INTO hrebt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","au padreo bàu: “Chuaq! mangai gùng kô loq au hmaq lam enh hnim tagop qyoh kô trùh ta hnim tagop qyoh tau rùp clêh rai jêh mangai leq ma lùi ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Èh hòm jò mahim Êtien, mangai ma lam anoe panhìn dôq wì loq ka ìh, ma ta-ùc au yòng ta aih wiang moèq manoh ti wì rai wê eo ƀài mangai jêh đac haq aih. ");
INSERT INTO hrebt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Chuaq doe ka au: “Lam beq, Au thê ìh lam trùh ta mangai diac wì”. ");
INSERT INTO hrebt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Wì aih tàng Phaulô anoe pang aih, wì padinh yòng rai cachech: “Hêq mangai qmang qmat pi oe rong rìh dèh ta crŏng taneh kô! Haq pi troq ka rìh dèh hòm”. ");
INSERT INTO hrebt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wì cachech, lêh hwênh dèh eo, caxaiq blo ta haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Cla craq lình drah thê wì qmùt Phaulô ta đôn. Haq thê wì yŏc long roe blai Phaulô đòeq bòch ngan hagleq ƀài mangai bàc enh gùng tau majah cachech hrìn ka haq qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Jò wì qnang hua qnoh Phaulo đòeq hu blai, Phaulô bòch mangai wèq lình yòng ajang aih: “Tiaq ranenh ìh akhòh jêh mangai Rôma, mangai pì qnhòq chaq hnoq haq aih i qmòe yiniq lui cleq loq ùh? ");
INSERT INTO hrebt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Jò mangai wèq lình tàng qmang aih, haq lam ajang nòe ka mangai cla craq thê haq, haq bòch: “Wùih! Ìh qnang padon broq cleq kô ìq? Mangai kô mangai Rôma. ");
INSERT INTO hrebt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Cla craq lình tàng qmang aih, haq lam trùh ajang Phaulô, haq bòch: “Anoe ka au loq, ìh kô ajoq mangai Rôma? Phaulô tèu “Joq”. ");
INSERT INTO hrebt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mangai cla craq lình doe: “Au clìh ka ƀac bàc haraya men jah rot cwìang broq mangai Rôma”. Phaulô tèu: “Jò bu hauang au kô khoe mangai Rôma”. ");
INSERT INTO hrebt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Dìq ka mangai ma blai haq, tàng doe qmang aih wì drah wia ka hangai, cla craq lình jò loq ka rađeh khoe kàt mangai diac Rôma, haq crè pi cajaq cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Sroq atìq, cla craq lình enh loq ka nhìn hagleq mangai Juđa majah enh tah hadah ka Phaulô, haq thê wì lêh caqnaih phaulô, creo dìq ka ƀài pajàu kàn xam ƀài craq hadrah trùh ta aih, khoe èh haq qnoh Phaulô loh yòng enh ngèa wì. ");
INSERT INTO hrebt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Phaulô ngan tajang tanòe hadrah rai doe: “Wì oh daq! enh ngèa Boc Plình au khoe acaq oe dìq ka manoh loq yùq loq iu trùh manòeq. ");
INSERT INTO hrebt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mahaq Anania, mangai pajàu haqnhèq thê wì ma yòng haten aih tep hacùng Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Phaulô hi capoch ka haq: “Wùih panàt xòn taboc meh, Boc Plình jêh ìh, ìh hangui đòeq hu hadrah au tiaq trong ranenh, mahaq ìh ngan ranenh ùh loh cleq, aih ka ìh thê wì jêh au. ");
INSERT INTO hrebt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ƀài mangai yòng kênh aih doe: Ìh hùa hnap ka pajàu Boc plình qmòh! ");
INSERT INTO hrebt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Phaulô padreo bàu: “Wì oh daq, au ùh qnì ka haq qmat broq pajàu haqnhèq, majah qmang aih khoe i bàu achìh: Ìh ùh dùh capoch qmèq ka mangai ma wèq mangai bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Phaulô loq ka wì ta aih, qnah aih mangai Sađusê, qnah aih mangai Pharisi, haq hi creo cadêh: “Wì oh daq! au kô mangai Pharisi, nang noe da mangai Pharisi. Gleq au majah yòng ajang kô? Aih taiq au lùi i kan rìh hlài enh mangai cachìt. ");
INSERT INTO hrebt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Haq tapoch qmang aih bu hêq, mangai Pharisi xam mangai Sađusê hi loh ka tarahen, ƀài mangai hadrah hi lah broq baiq pah. ");
INSERT INTO hrebt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Majah qmang aih mangai Sađusê doe: ùh i ka kan rìh hlài, ùh i ka ƀình plình, ùh i ka kan kiac taleq, yàng da mangai Pharisi dìq lùi i trong aih. ");
INSERT INTO hrebt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Bàu tagruàng tagràt èh rai dêh. I ƀài mangai hnài ranenh nang noe da mangai Pharisi yòng tarahen ka mangai qnoeq, wì doe: “nhèn ùh hnoq mangai kô i broq cleq ma ùh troq. Cabô ma qnì, broq braiq qnì i kiac i ƀình plình qnì khoe capoch tuàng ka haq? ");
INSERT INTO hrebt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","kan tarahen rai èh rai dêh, cla craq lình yùq trùh wì ma hit cađac Phaulô loh baiq, haq thê deh lình drah loh blah yŏc Phaulô enh tì wì aih hu ahlài ta đôn. ");
INSERT INTO hrebt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mang atìq Chuaq yòng haten ka Phaulô rai doe: “Apaq yùq! ta Jêrusalem ìh khoe anoe dôq wì loq ka au qmang leq, ta Rôma ìh hadai ep anoe dôq wì loq ka au qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Trùh qngah, mangai Juđa khoe hatình ti dabau, dìq dŏng ka wì haq hapah ti dabau ùh acaq, ùh ôq trùh jò leq khoe jah jêh cađac Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Loe pôn jàt ngai ma hatình qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Wì lam chaq ƀài mangai pajàu kàn xam ƀài gucraq wì doe: “nhèn khoe hapah ti dabau ùh acaq qmòe blinh trùh jò leq nhèn jah jêh cađac Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Manòeq kô xam pì xam wì craq hadrah, trùh bòch cwan cla craq lình, dôq haq qnoh Phaulô yòng enh ngèa ka pì broq tìah ka pì ma i yiniq enh bòch dôq hu loq tam, èh nhèn khoe rap qmòe ti trong jò haq qnhòq trùh tacô nhèn khoe jêh cađac. ");
INSERT INTO hrebt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mahaq, i kon calô mangai daq cadrì da Phaulô loq ka wì hatình qmang aih, haq mùt ta đôn, anoe ka Phaulô loq adroe. ");
INSERT INTO hrebt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Phaulô creo ka mòeq ngai broq đaiq đôiq, haq doe: “Aràng kon mangai radam kô trùh glàm cwan cla craq lình, haq kô i yiniq enh patìn ka cwan aih. ");
INSERT INTO hrebt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Haq hi qnong mangai radam aih lam glàm cwan cla craq lình. Mangai đaiq đôiq doe: “Phaulô mangai ma qnang oe tù i creo ka au thê au aràng kon mangai radam kô trùh ta ìh, haq kô i yiniq enh anoe ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mangai cla craq lình rùp tì mangai radam aih lam ta kênh rai bòch: “ìh enh patình ka au yiniq cleq?” ");
INSERT INTO hrebt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mangai aih doe: “Mangai Juđa khoe mòeq manoh ti dabau đòeq wiang bòch ìh, hì da èh am Phaulô lam yòng enh ngèa nòe hadrah, broq tìah qmang ka wì haq ma i yiniq enh bòch panhìn dôq hu loq tam. ");
INSERT INTO hrebt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mahaq ìh apaq lùi, majah qmang aih i loe pôn jàt ngai khoe hatình ti dabau chaq trong jêh cađac Phaulô, wì aih khoe hapah ka dabau adroe ka jah jêh cađac Phaulô, wì haq blinh ùh acaq ùh ôq qmòe cleq, manoeq kô wì haq khoe padon đòeq gòm toq ìh òq bàu. ");
INSERT INTO hrebt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Cwan cla craq lình am kon mangai radam aih hlài rai tanap: “Apaq anoe ka cabô loq bàu ìh neo bahìa ka au.” ");
INSERT INTO hrebt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Khoe aih, haq creo ka baiq ngai đaiq đôiq rai tanap ka wa: “Hachìn jò mang kô, padon đòeq baiq hrinh ngai lình, tapèh jàt lình kòe axêh, baiq hrinh lình wê jaoq, hu lam ta Sêsarê; ");
INSERT INTO hrebt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","padon am ka Phaulô axêh, dôq jah qnung lam ka catèm trùh ta Phêlit cwan haqnhèq. ");
INSERT INTO hrebt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Haq achìh ka cwan aih mòeq araq jàiq, rameh: ");
INSERT INTO hrebt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kôlot-Lysia, achìh ka Phêlit cwan haqnhèq, waiq ka ìh jah kan catèm! ");
INSERT INTO hrebt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mangai Juđa khoe rùp mangai kô hujêh cađac, mahaq au khoe qnung lình lam blah yŏc haq claih enh wì aih, majah qmang aih au tàng doe haq kô mangai diac Rôma. ");
INSERT INTO hrebt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Au enh loq hagleq wì majah tah hadrah ka mangai kô, aih ìq au hi qnoh haq tanòe hadrah da cla wì haq. ");
INSERT INTO hrebt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Au hnoq mangai kô wì tah hadrah ka haq tiaq toq trong ranenh da cla wì aih, mahaq ùh lòm i ajang leq ma doe mangai kô troq ka cachìt qnì troq ka rùp clêh qnì. ");
INSERT INTO hrebt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Yàng aih au hìa i wì hatình chaq trong hu jêh cađac mangai kô, aih ìq au majah thê haq drah trùh ta ìh. Au hadai khoe thê ƀài mangai tah hadrah ka haq kô enh anoe cleq aih trùh ajang ìh.” ");
INSERT INTO hrebt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ƀài lình iu tiaq bàu, mang aih raq qnung Phaulô tiaq wì haq trùh ta Anti-batri. ");
INSERT INTO hrebt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Sroq atìq wì dôq toq lình kòe axêh lam ti haq, ƀài lình qnoeq aih hi wìh hlài ta đôn. ");
INSERT INTO hrebt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Jò lình kòe axêh khoe trùh ta Sêsarê, wì yŏc jàiq aih dèch am ka cwan haqnhèq rai jao hloe Phaulô ka haq. ");
INSERT INTO hrebt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Cwan haqnhèq ngan jàiq, khoe aih haq bòch Phaulô oe ta tình leq, jò haq bu loq ka Phaulô oe ta tình Silisi, ");
INSERT INTO hrebt_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","aih haq hi doe: “Jò leq ƀài mangai tah hadrah aih trùh tacô, aih èh brì ka au tamàng ìh. Khoe aih haq thê wì rùp padràng Phaulô ta hnim Hêrot. ");
INSERT INTO hrebt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Atìq ka aih padam hì, Anania mangai pajàu haqnhèq xam ƀiaq ngai gucraq lam pajùm ti mòeq ngai rabiaq ka capoch acaq, yiniq haq Tectulu, am ka cwan haqnhèq jàiq wì haq khoe achìh đòeq tah hadrah ka Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Jò khoe creo ka Phaulô mùt, Tectulu hi doe: ");
INSERT INTO hrebt_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","“Cwan haqnhèq Phêlit, canòm đeh ka ìh nhèn ma khoe jah rìh catèm rìm trong, canòm kan rabiaq, kan loq hnoq hangai enh ìh ƀài kan qmèq khoe wìa kan lem am ka nhèn, jò leq jò meh yac ka oe taleq dua nhèn toq hmàng toq manè ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mahaq đòeq ùh hìaq pangài hrìn đeh ka ìh, broq qmang leq ìh hai tamàng da nhèn ƀiaq nà. ");
INSERT INTO hrebt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nhèn hnoq haq kô mangai enh chaq toq yiniq, toq ti jrôq chiu mangai Juđa jàp ta crŏng taneh. Haq pagàu ƀài bua mangai Naxaret, ");
INSERT INTO hrebt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Haq hadai khoe hwaq broq kan amùa ta hnim kùh waiq, dài nhèn ma jah rùp haq, nhèn enh hadrah haq qmat tiaq ranenh cla nhèn. ");
INSERT INTO hrebt_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Mahaq Lysia, cwan cla craq lình, haq aih ngang haraya khoe blah mangai qmat enh tì kŏng nhèn. ");
INSERT INTO hrebt_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Thê dìq ka mangai hadrah lam glàm qmòe cla ìh, manòeq kô cla ìh bòch haq qmat beq, aih ìh hi loq gleq nhèn majah qnang tah hadrah ka haq. ");
INSERT INTO hrebt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ƀài mangai Juđa hadai wiang mòeq bàu ka Tectulu, wì doe hiloq qmang aih raq. ");
INSERT INTO hrebt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Cwan haqnhèq hnhè tì thê Phaulô capoch, Phaulô padreo bàu: “Au loq ìh broq cwan hadrah ta taneh diac kô khoe bàc hanam, aih ìq dài au majah lem bùi hu capoch cwaih rađeh. ");
INSERT INTO hrebt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ìh ti bòch beq, ìh hi loq au neo tŏc ta Jerusalem đòeq kùh waiq, qnhòq tem jah mòeq jàt baiq hì. ");
INSERT INTO hrebt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wì qnhòq hmaq hnoq au tanòe hnim kùh waiq, tanòe hnim tagop qyoh, ta roc phôq, tarahen ka cabô đòeq jrôq chiu thê wì broq manhài. ");
INSERT INTO hrebt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Manòeq kô wì ùh yŏc cleq aleq hu patô am ka ìh hnoq đòeq panhìn bàu wì ma tah hadrah ka au. ");
INSERT INTO hrebt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Enh ngèa cwan, au ùh hangah rađeh joq au kùh waiq Boc Plình boc yaq nhèn ma lùi dèh enh nèh, au lùi rìm bàu achìh ta hset ranenh xam hset pajàu, ");
INSERT INTO hrebt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","au hadai lùi tìah qmang ka wì haq ma lùi nòe Boc Plình diq, aih lùi i kan rìh hlài da mangai taq atoq xam mangai dù. ");
INSERT INTO hrebt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Dài aih ìq raq, enh ngèa Boc Plình enh ngèa kon mangai au majah àu wèq dèh manoh cliac dôq haq jah hliang lem. ");
INSERT INTO hrebt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Au arù hangai khoe bàc hanam, au hlài ta Jêrusalem hu qnàng dahwèq tabàih am ka oh daq au ƀài mangai ma pa đeh, rai dèch ramènh ka Boc plình. ");
INSERT INTO hrebt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Jò aih, i ƀài mangai Juđa oe ta gùng Asi hnoq au qnang broq ramènh basròeh ka rađeh ta hnim kùh waiq, ùh i broq cleq lìq làn, ùh i mangai enh leq ma bàc. ");
INSERT INTO hrebt_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tàng joq wì aih i yiniq cleq enh tah hadrah ka au, aih ajoq wì haq trùh anoe enh ngèa ka cwan kô ma troq. ");
INSERT INTO hrebt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Tàng ùh meh, ƀài pì ma yòng tacô ep doe beq, pì khoe hnoq au i broq yiniq cleq ùh troq jò au yòng tanòe hadrah da mangai Juđa, ");
INSERT INTO hrebt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","enh gùng ka mòeq bàu au ma khoe capoch dêh enh ngèa wì haq: Hì kô au majah ep yòng ajang kô tamàng bàu pì bòch aih taiq au lùi kan rìh hlài da mangai cachìt. ");
INSERT INTO hrebt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Phêlit khoe loq Trong Phaulô ma anoe aih, dài haq majah taqnhùa, haq doe: “Hêq gòm jò leq Lysia mangai cla craq lình trùh tacô, brì ka au tamàng yiniq kô”. ");
INSERT INTO hrebt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Khoe aih, Phêlit thê mangai đaiq đôiq rùp đòeq Phaulô mahaq ep am haq jah lam hlài đeh toq ƀiaq, apaq tàt ƀài bua Phaulô jò wì lam hmàih rai aràng ka haq dahwèq haq ma i yiniq waq. ");
INSERT INTO hrebt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Biaq hì atiq ka aih, Phêlit xam Đorusi cadrì haq, aih mangai Juđa, trùh thê wì creo ka Phaulô, tamàng haq anoe trùh kan lùi nòe Chuaq Jesus Christ. ");
INSERT INTO hrebt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Mahaq jò tàng Phaulô anoe trùh kan taq atoq, kan loq wèq rađeh xam kan hadrah hì atìq, Phêlit crè picajaq, haq doe: “Hêq hì kô anoe pang kô raq, gòm hì qnoeq au dòh au hi creo ònh”. ");
INSERT INTO hrebt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Phêlit hadai toq tangèh ka Phaulô am ka haq ƀac jèn, dài haq majah ti hawet creo capoch tuàng yôt ka Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Baiq hanam atìq ka aih, Bôtiu-Phêtu trùh broq thai ka Phêlit. Taiq Phêlit enh yŏc manoh mangai Juđa dài haq majah ùh caqnaih Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Phêtu broq tình trùang bujah piq hì, haq loh enh Sêsarê tŏc ta Jerusalem. ");
INSERT INTO hrebt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ta aih, i ƀài mangai pajàu kàn, ƀài gucraq da mangai Juđa trùh enh ngèa haq hu tah hadrah ka Phaulô, ");
INSERT INTO hrebt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Wì haq àu bòch cwan Phêtu caqnaih Phaulô hlài ta Jêrusalem, majah qmang aih wì haq khoe hatình ka dabau jêh cađac Phaulô jò haq qnang lam ti trong. ");
INSERT INTO hrebt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Mahaq Phêtu doe “Phaulô, wì oe raq clêh ta Sêsarê”, cla au kô èh hadai ep haqnan ka hlài ta aih, ");
INSERT INTO hrebt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","manòeq kô pì yŏc biaq ngai gàu gucraq lam ti au, tàng joq mangai aih i broq cleq ùh troq, aih pì hi paqnoh. ");
INSERT INTO hrebt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Phêtu oe ti wì loq jah rahem hì ùh moèq jàt hì, khoe aih haq ta wìh loh Ta Sêsarê, sroq atìq haq hangui nòe hnim hadrah, haq thê wì qnoh Phaulô loh yòng enh ngèa haq. ");
INSERT INTO hrebt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Phaulô bu trùh, ƀài mangai Juđa ma loh enh Jêrusalem khoe tùh yòng dudan ka haq, wì yŏc bàc trong tapoch cheo đòeq taqmòq yiniq lui ka haq, mahaq ùh i cleq đòeq hu panhìn ƀài bàu aih. ");
INSERT INTO hrebt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Khoe aih Phaulô hi anoe đòeq cwaih rađeh: “Au qnhòq lah broq cleq ùh troq, broq cleq ma pagau ka ranenh mangai Juđa, pagau ka hnim kùh waiq, pagau ka Sêsa.” ");
INSERT INTO hrebt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Mahaq Phêtu enh lem ka manoh mangai Juđa haq bòch Phaulô: “Ìh i enh tŏc ta Jêrusalem đòeq hadrah ƀài yiniq kô enh ngèa ka au loq ùh?” ");
INSERT INTO hrebt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Phaulô padreo bàu doe: “Manòeq kô au yòng nòe hadrah yiniq da Sêsa, au waq ka jah hadrah ta aih, au ùh i broq yiniq lui cleq ka mangai Juđa, yac ka ìh hadai khoe loq. ");
INSERT INTO hrebt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Tàng joq au i broq yiniq lui cleq ma troq ka cachìt, au ka ùh chuiq ka cachìt. Mahaq tàng joq bàu wì mangai Juđa ma tah hadrah ka au ùh joq qnàng, ùh i cabô jah rùp au am ka wì haq. Au dang trùh ta Sêsa.” ");
INSERT INTO hrebt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Phêtu hatình ka ƀài mangai wiang hadrah, khoe aih haq hi doe: “Ìh khoe creo dang Sêsa, aih èh ìh jah trùh ta Sêsa”. ");
INSERT INTO hrebt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ƀiaq hì atìq ka aih, bùa Aripba xam Bêrêsit, wa lam trùh ta Sêsarê đòeq hmàih ka Phêtu. ");
INSERT INTO hrebt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Wa haq oe ta aih bàc hì, Phêtu hi anoe ka bùa loq trong yiniq da Phaulô. Haq doe: “Tacô i mòeq ngai cwan Phêlit khoe clêh đòeq. ");
INSERT INTO hrebt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jò au tŏc ta Jêrusalem, ƀài mangai pajàu kàn xam ƀài gucraq da mangai Juđa trùh hu tah hadrah ka haq aih, wì àu thê au dèch taqmòq tuiq ka haq. ");
INSERT INTO hrebt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Au hi doe: Mangai Rôma ùh taqmòq yiniq lui ka cabô, jò mangai aih qnhòq yòng enh ngèa ƀài mangai tah hadrah ka haq đòeq hu capoch cwaih rađeh. ");
INSERT INTO hrebt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Jò wì aih lam tiaq au trùh tacô, au hadai ùh batrò, sroq atìq au khoe thê qnoh mangai aih đòeq hu hadrah. ");
INSERT INTO hrebt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ƀài mangai ma tah hadrah khoe tôm dŏng, mahaq ùh lòm i qmòe yiniq cleq ma wìa ka taqmòq ka haq tuiq troeq au ma hèm dèh ta manoh. ");
INSERT INTO hrebt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Wì toq tapoch rahen ka haq toq trong đaoq da cla wì, èh ràu trùh mòeq ngai khoe cachìt yiniq haq Jesus, mahaq Phaulô dua rahen: Haq aih oe rìh. ");
INSERT INTO hrebt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Wì tarahen deh qmang aih, au pi qnì tiaq da ma leq, dài au ma hi bòch cla Phaulô i enh tŏc ta Jêrusalem đòeq tamàng wì hadrah ta aih loq ùh. ");
INSERT INTO hrebt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mahaq cla Phaulô khoe dang waq ka jah wì hadrah haq enh ngèa ka Sêsa. Au khoe thê wi clêh haq đòeq gòm trùh hì aràng haq ka Sêsa. ");
INSERT INTO hrebt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Bùa Aripba anoe ka Phêtu: “Au hadai enh tamàng bàu mangai aih.” Phêtu doe “Sroq èh ih hi jah tamàng haq aih”. ");
INSERT INTO hrebt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Sroq atiq bùa Ariba xam Bêrisit nhòm nhình cadiang mùt ta hnim hadrah hangui ti ƀài cwan lình xam wi gucraq gùng aih, Phêtu hi thê wì qnoh Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Khoe aih Phêtu doe: “Bùa Ariba xam dìq ka pì i mat tacô, pì dìq hnoq mangai kô, taiq haq kô dìq ka mangai Juđa oe ta Jêrusalem xam mangai oe tacô majah khoe lam canòm ka au, wì doe: “Apaq dôq haq rìh hòm”. ");
INSERT INTO hrebt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mahaq au khoe ti chaq ngan ùh hnoq haq i yiniq lui cleq ma troq ka cachìt, cla haq hadai khoe creo dang trùh ta Sêsa, Au hèm kô èh au aràng haq ka Sêsa. ");
INSERT INTO hrebt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mahaq au ùh qnì yŏc cleq đòeq achìh hu anoe ka Sêsa, hì kô au qnoh haq loh enh ngèa pì, ajang kô i bùa Ariba, aih joq pi i cleq yeo loe hòm, đòeq bòch haq, khoe aih au men i yiniq đòeq hu achìh ka Sêsa. ");
INSERT INTO hrebt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Majah qmang aih, au hèm qnung mòeq ngai broq yiniq lui mahaq ùh anoe hloh trong wì ma tah hadrah ka haq, aih ajoq kan talìq talàn. ");
INSERT INTO hrebt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Khoe aih bùa Ariba doe ka Phaulô: “Ìh jah capoch đòeq hu cwaih rađeh”. Phaulô qnhè tì ka wì, khoe aih haq anoe qmang kô: ");
INSERT INTO hrebt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Bùa Ariba, joq lem ka au hì kô jah yòng enh ngèa ìh đòeq hu capoch palem rađeh khoe ka rìm trong mangai Juđa ma tah hadrah ka au, ");
INSERT INTO hrebt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","majah qmang aih ìh loq joq qnàng trong mangai Juđa rìh acaq xam kan wì haq loq tarahen dàng leq. Aih ìq au majah ngèh ìh ran àt hu tamàng au anoe. ");
INSERT INTO hrebt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Enh qyoh nèh raq, au rìh acaq qmang leq, mangai Juđa oe tagùng cla au xam mangai Juđa oe ta Jêrusalem dìq loq. ");
INSERT INTO hrebt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wì loq ka au khoe dùnh tàng joq wì ma waq anoe biaq ka au, au kô mangai Pharisi, au tiaq đaoq aih yeo nhet diq dŏng ka wì qnoeq. ");
INSERT INTO hrebt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Manòeq kô, taiq tangèh ajang bàu Boc Plình ma khoe tèu am ka boc yaq nhèn au majah ep yòng nòe hadrah kô, ");
INSERT INTO hrebt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Mòeq jàt baiq xinoe Isorali nhèn yŏc dìq ka manoh kùh waiq Boc Plình, xam dahì xam damang, toq tangèh ka bàu aih jah pagêh. Bùa Ariba ôi! taiq kan tangèh aih mangai Juđa majah tah hadrah ka au. ");
INSERT INTO hrebt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Wùih! Ji laiq pì mahèm Boc plình broq mangai cachìt rìh hlài ùh jah qmòh? ");
INSERT INTO hrebt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Au hadai khoe lah hèm ta manoh ep broq bàc trong đòeq hu tablêq hlài ka yiniq Jesus mangai Naxaret. ");
INSERT INTO hrebt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Joq qnàng au khoe broq qmang aih ta Jêrusalem. Au jah cwìang enh ƀài pajàu kàn, au rùp clêh bàc ngai hadròeh, èh hòm jò wì ma jêh cađac ƀài mangai aih, au hadai mòeq manoh ti wì. ");
INSERT INTO hrebt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Bàc yàng au lam enh hnim tagop qyoh kô trùh hnim tagop qyoh tau, hujêh wì, thê wi tapoch qmèq ka Boc plình. Au nòeh oe i jaq cleq au ti chaq rùp wì haq trùh hloe tanòe diac wì. ");
INSERT INTO hrebt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Qmang aih, jah cwìang enh ƀài pajàu kàn, au tŏc ta Đamat, jò qnang lam ti trong, ");
INSERT INTO hrebt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","wop qne hì, au hnoq i kan qngah loh enh plình, qngah ùh hnau ka mat mahì sreo dudan ka au xam bua au. ");
INSERT INTO hrebt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Dìq ka nhèn tacro dŏnq ta taneh, au tàng i bàu capoch ka au xi bàu Hêbru: “Saulo, Saulo! hagleq ìh majah ti rùp baxa dèh ka au? ìh đaq ta long hin aih habo ka cla. ");
INSERT INTO hrebt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Au padreo bàu “Craq au! Ìh kô cabô”. Haq doe” Au kô Jesus mangai qnang ti chaq rùp. ");
INSERT INTO hrebt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mahaq drah rai yòng beq! Majah qmang aih au khoe loh ti ìh đòeq thê ìh broq mangai patìh rai anoe dôq wì qnoeq loq rìm yiniq ìh ma khoe hnoq xam ƀài yiniq au padon patô ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","I au caqnaih ìh loh khoe tì kŏng mangai gùng kô xam mangai diac wì nòe Au thê ìh lam, ");
INSERT INTO hrebt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","đòeq hu pèch mat wì haq, dôq enh nòe clam cluiq wì haq jah atŏc tanòe qngah qngai, enh caqnàm Satan wì haq jah trùh ti Boc plình, jò manoh wì haq lùi ajang au wì haq jah kan caqnaih yiniq lui, hadai jah kùng hang ti ƀài mangai khoe jah barsòeh. ");
INSERT INTO hrebt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Pang aih, bùa Ariba ôi, au pi hùa tablêq ka kan mahnu enh plình, ");
INSERT INTO hrebt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","baxèm aih au anoe ka mangai oe ta Đamat, atìq aih anoe ka mangai oe ta Jêrusalem, xam dìq dŏng gùng Jiuđê, khoe aih trùh mangai diac wì, au hnài wì ep loq raxach đòeq hu tawìh hlài ti Boc Plình, khoe aih broq trong lem đòeq patô joq qnàng wì haq khoe raxach. ");
INSERT INTO hrebt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Aih ìq, dài haq mangai Juđa majah rùp au ta Hnim kùh waiq rai àu jêh cađac hloe au. ");
INSERT INTO hrebt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mahaq rìm hì Boc plình wèq, trùh hì kô au jah yòng ajang kô đòeq anoe panhìn ka mangai qyoh xam mangai gucraq, au ùh anoe cleq enh gùng ka bàu ƀài pajàu xam Môise khoe anoe ƀài bàu aih jah trùh. ");
INSERT INTO hrebt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Aih Christ ep xalep, haq rìh hlài adroe dìq dŏng ka mangai cachìt, aràng am kan qngah ka mangai bèn xam mangai diac wì.” ");
INSERT INTO hrebt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Phaulô qnang cwaih rađeh qmang aih, Phêtu tapoch cadêh đòeq pot bàu haq: “Phaulô ìh qmat hŏc bàc hrìn khoe loh ka ranhùa.” ");
INSERT INTO hrebt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Phaulô padreo bàu: “Cwan kàn Phêtu, au ùh i ranhùa, bàu au anoe aih dìq troq dìq joq qnàng”. ");
INSERT INTO hrebt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Yac ka bùa hadai loq trong kô, dài au ùh xa cleq anoe ka ìh, majah qmang aih i cleq bùa ùh qnì, rìm yiniq aih ùh i broq ta hanàp clam. ");
INSERT INTO hrebt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Bùa Ariba, ìh alùi ƀài pajàu ùh? Au loq ma joq qnàng aih ìh lùi”. ");
INSERT INTO hrebt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Bùa Ariba doe ka Phaulô “Oe toq xit hòm ìh khoe thê au wìa mangai tiaq hŏc da Christ”. ");
INSERT INTO hrebt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Phaulô doe: “Waiq Boc Plình, ùh rênh èh adia, ùh xài mòeq ngai bùa mahaq dìq dŏng ka mangai tamàng au hì kô, jah wìa tìah ka au, enh gùng ka hadrang kaxi datoeq kô raq”. ");
INSERT INTO hrebt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Bùa padinh yòng, cwan tình truàng, Bênêphit xam dìq ka wì ma haqngui ta aih hanoh qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Jò khoe loh enh gùng, wì haq ta anoe ka dabau: “Mangai kô ùh i broq cleq ma troq ka cachìt troq ka clêh haq.” ");
INSERT INTO hrebt_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Bùa Ariba doe ka Phêtu: “Mangai kô troq ka caqnaih, apaq haq ma khoe creo dang trùh ta Sêsa”. ");
INSERT INTO hrebt_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Jò khoe hatình, nhèn ep lam trong diac raxìq đòeq trùh ta diac Itali, wì hi jao Phaulô xam ƀài mangai oe tù maqnoeq hòm ka mòeq ngai cwan lình yiniq haq Juliut, aih cla craq lình wèq bùa kàn. ");
INSERT INTO hrebt_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nhèn tŏc mòeq toq boang trùh enh Atramit padon lam bàc tình ti kênh diac raxìq Asi, loh lam enh aih i Aritac mangai Maxêđoan oe ta Têsalônica lam ti nhèn. ");
INSERT INTO hrebt_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Hì atìq nhèn trùh ta Siđôn, Juliut aih mangai lem manoh, haq am Phaulô lam hmàih dèh ƀài bua, dôq wì aih jah taqmroq palauq ka Phaulô ƀài dahwèq haq ma qnang nan. ");
INSERT INTO hrebt_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Enh aih, nhèn lam tiaq haqmai pleo Chipro, majah qmang aih glàm cayeo tàt qngèa. ");
INSERT INTO hrebt_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Jò nhèn lam khoe catech diac raxìq Silisi xam Bamphili, nhèn trùh ta Mira oe ta Lysi. ");
INSERT INTO hrebt_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ta aih, cwan lình hnoq mòeq toq boang enh Alecxantri lam pagat gùng Itali, haq am nhèn tŏc boang aih. ");
INSERT INTO hrebt_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Boang cadàu adia, bàc hì men trùh ta Conit. Cayêu dêh hrìn boang ùh jah mùt tago, nhèn ep lam ti haqmai pleo Coret, tangèa ka Samôn. ");
INSERT INTO hrebt_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Lam qmòe caxa roc haqmai diac qmang aih. Nhèn men trùh mòeq nòe wì creo dèh “Wình boang lem”, haten ka Lasê. ");
INSERT INTO hrebt_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Bàc hì boang cadàu glàm kan yat (khoe dìq ka jò apàm ka acaq), Phaulô pariaq bài mangai taboang, ");
INSERT INTO hrebt_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","haq doe: “Oh daq! Au hnoq bèn lam boang yàng kô glàm kan yat, ùh xài hnhung toq ka hang ka boang mahaq yat hloe trùh cla. ");
INSERT INTO hrebt_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mahaq mangai cwan lình lùi bàu mangai wèq boang ùh hnau ka bàu Phaulô. ");
INSERT INTO hrebt_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ta aih ùh lem ka boang achàt oe clech ka ralìm, bàc ngai wiang hatình ep loh ma khoe enh aih, hèm dèh ran trùh ta Phênit oe ta aih clech ka ralìm, aih nòe achàt boang da pleo Corêt, nòe kô i baiq trong boang hu mùt mòeq aih ta ngèa pah qma mahì loh, mòeq aih pah qngeo mahì clìh. ");
INSERT INTO hrebt_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Jò cayêu enh apah qma mahì loh bu hlui, wì hèm dèh jah trùh tanòe wì ma enh lam, wì drah dèch glêh boang, lam tiaq haqmai pleo Corêt. ");
INSERT INTO hrebt_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Atìq ka aih toq biaq, i kan cayeo bahùt dêh, yiniq cayeo Aquilôn rapàt cadêh tŏc ta pleo. ");
INSERT INTO hrebt_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Bahùt hlui boang talùi ka hangai, ùh hlàt tablêq ka cayeo nhèn hi mac maiq ka cayêu qnung. ");
INSERT INTO hrebt_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Cayêu qnung boang trùh ta mòeq toq pleo qyoh yiniq haq Clođa, xalep haraya men jah dèch boang qyoh atŏc ta boang kàn. ");
INSERT INTO hrebt_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Jò khoe jah dèch atŏc, nhèn yŏc kaxi griaq tap dan caqnam haq ka cajap. Khoe aih yùq boang loq hlac nòe braih Siroto, nhèn hi caqnìh glêh boang ta diac, khoe aih dôq daiq cayeo tàih boang taleq tameh. ");
INSERT INTO hrebt_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Trùh hi da èh, bahùt dêh mòeq jaq, wì khwênh caqnìh ƀài hang ta diac rasìq. ");
INSERT INTO hrebt_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Trùh hì piq, tì kŏng cla nhèn caqnìh ƀài hang ta diac. ");
INSERT INTO hrebt_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Bàc hì qmang aih ùh i ka mat mahì, ùh i ka halŏng, bahùt ùh dùh ka rangep, nhèn loh ka pi i cabô ma oe ùac ka jah rìh. ");
INSERT INTO hrebt_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Wì ùh acaq khoe dùnh, Phaulô yòng enh ngèa wì aih, haq doe: “Dìq ka oh daq, adroe nèh tàng pì waq tamàng bàu au, apaq loh enh Corêt, aih bèn khoe ùh hìaq glàm kan habo qmang kô. ");
INSERT INTO hrebt_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mahaq manòeq kô au anoe dôq pì ùh hìaq yùq, majah qmang aih dìq ka pì ùh i cabô cachìt, toq boang ko èh ma hnhung. ");
INSERT INTO hrebt_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mang ìq, mòeq bình plình da Boc plình au ma patìh i loh doe ka au: ");
INSERT INTO hrebt_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Phaulô apaq yùq! ìh ep yòng enh ngèa Sêsa, hacô Boc Plình khoe am ka ìh kan rìh da ƀài mangai ma lam ti ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Qmang aih, dìq capì cajap manoh oq, majah qmang aih au i kan lùi Boc Plình, kô èh rìm yiniq wop tìah ka bàu haq khoe anoe”; ");
INSERT INTO hrebt_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","bèn jah tŏc tapleo leq qnhòq qnì. ");
INSERT INTO hrebt_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Khoe mòeq jàt pôn mang, boang nhèn oe raq hìu lìq làn ta diac raxìq Ađri-atic, trùh qne mang, wì xoh đeh khoe ten trùh tago. ");
INSERT INTO hrebt_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Wì caqnìh mòeq hadrang caxi đòeq nhro ngan, hnoq jrùq oe jah baiq jàt plaih, hangai tam toq biaq, wì caqnìh hòm hnoq jrùq bu mòeq jàt padam plaih. ");
INSERT INTO hrebt_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Jò aih yùq boang loq glàm hmo, enh cloh boang wì caqnìh pôn toq glêh mem loh ta diac, khoe aih toq waiq ka trŏc drah qngah. ");
INSERT INTO hrebt_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Mahaq, ta boang i mangai enh cadàu claih toq ka rađeh, wì haq enh caqnìh boang qyoh patìah đeh lam ngan glêh mem enh ngèa boang, ");
INSERT INTO hrebt_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Phaulô doe ka cwan craq lình: “Tàng joq bài mangai qmat ùh oe taboang, dìq ka pì ùh i mangai leq jah rìh. ");
INSERT INTO hrebt_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ƀài lình kat cađac caxi grap boang qyoh dôq haq clìh tadiac. ");
INSERT INTO hrebt_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Jò oe gòm trŏc qngah, Phaulô pariaq wì acaq. Haq doe: “Hì kô khoe mòeq jàt pôn hì pì toq ngèh gòm ùh dùh i acaq toq xit cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Manòeq au pariaq pì drah acaq, broq qmang aih dôq pì i padren, majah qmang aih dìq ka pì ùh i mòeq ngai leq ma hnhung mòeq hadrang xàc gàu. ");
INSERT INTO hrebt_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Anoe qmang aih hi khoe, haq yŏc ƀênh, manè apôi Boc plình èh hi goh hu acaq. ");
INSERT INTO hrebt_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Qmang aih, mangai leq mangai meh jah kan alòng, wì hi paran dabau acaq. ");
INSERT INTO hrebt_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Dìq ka nhèn ma oe ta boang jah baiq hrinh tapèh jàt tadràu ngai. ");
INSERT INTO hrebt_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Jò khoe panàc dìq jaq, wì caqnìh dŏng dahwèq acaq ta diac dôq boang pi hìaq trap. ");
INSERT INTO hrebt_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Jò trŏc hi qngah, wì ùh canau ka rađeh oe ta taneh leq, mahaq hnoq wình i braih ta kênh, wì hatình ka dabau tàng jah chaq trong qmùt boang ta aih. ");
INSERT INTO hrebt_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Qmang aih wì hi kat caqnìh đac caxi kàt boang tadiac raxìq, lêh caxi wì ma kàt long loeq boang, hi khoe ka aih caqnìh bai boang dôq cayeo hlui boang tŏc tago. ");
INSERT INTO hrebt_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mahaq boang cadàu glàm ataq nòe diac ma daxrùp, boang hi hlac, mùh haq hatàp ta braih pi jah tadroq, diac lai laq dêh tep ta cloh boang padah padech dŏng. ");
INSERT INTO hrebt_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ƀài lình enh jêh đac dŏng mangai tù, majah qmang aih yùq i mangai ma loq glài èh wì loq claih. ");
INSERT INTO hrebt_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mahaq mangai cla cwan lình, enh wèq Phaulô, dài haq majah tàt đac trong aih. Haq thê dìq ka mangai leq loq glài aih chônh hadrùc ta diac hu glài mùt tago, ");
INSERT INTO hrebt_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","mangai ma qnoeq aih capùng ka capiac long ban, ka hanech boang. Qmang aih rìm ngai jah tŏc tago ka catèm. ");
INSERT INTO hrebt_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Jò khoe jah tŏc tago ka catèm qmang aih, nhèn men loq pleo aih yiniq haq Manta. ");
INSERT INTO hrebt_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mangai ta pleo aih đìh nhèn joq laq alàng joq qnàng. Wì haq baxù tanùh ùnh, pachùh dìq ka nhèn qnhìa majah qmang aih trŏc mè rai tanget. ");
INSERT INTO hrebt_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Phaulô yŏc moeq ha-om ra-ùnh tah ta tanùh, i moeq toq bìh plŏng, loh enh ra-ùnh tôq aih ƀuƀan tì haq. ");
INSERT INTO hrebt_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Mangai ta pleo aih hnoq bìh kap atua ta kŏng Phaulô, wì doe ka dabau “Mangai kô joq mangai jêh mangai joq qnàng, hacô yac ka khoe jah dèch enh diac raxìq, mahaq trŏc ma taq atoq dua ùh rong haq rìh”. ");
INSERT INTO hrebt_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Mahaq Phaulô da arêh bìh aih clìh ta ùnh, cla haq ùh i troq cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Wì hèm kŏng haq aih èh đìc tablù cadeh, tàng ùh meh diq tacro taqneq cachìt hloe, mahaq gòm khoe dùnh ùh i hnoq haq troq cleq, ta manoh wì hèm trong qnoeq hòm, wì doe ka haq kan kiac. ");
INSERT INTO hrebt_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ten aih i đùng ruàng da Bupliu, cla craq pleo aih, haq aih đìh nhèn mùt deh ta hnim, qmi nhèn acaq piq hì. ");
INSERT INTO hrebt_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Baq haq ùh hrŏc ta aniang, rai tacat rai jìq cliac keo. Phaulô mùt tìn haq, khoe ka waiq khàn yŏc tì bèq chac haq đòeq broq brêh ka haq. ");
INSERT INTO hrebt_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hnoq qmang aih, ƀài mangai ùh hrŏc ta aih dìq trùh ti Phaulô, dìq ka wì hadai jah brêh. ");
INSERT INTO hrebt_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Wì loq ta- iu nhèn bàc trong, trùh jò padon lam, wì palauq am ka nhèn bàc dahwèq nhèn ma nhet ka waq. ");
INSERT INTO hrebt_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Piq khê atìq ka aih, nhèn tŏc boang trùh enh Alecxantri, jò ralìm boang kô khoe oe ta pleo aih, yiniq boang kô Điôkua. ");
INSERT INTO hrebt_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Trùh ta Sira-cuso, nhèn oe tacô piq hì. ");
INSERT INTO hrebt_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Enh aih, nhèn boe tiaq roc haqmai diac raxìq Siliso, trùh ta Rêgium. Hì da èh rameh, i cayêu enh pah qma mat mahì loh hlui dêh, dài haq baiq hì hòm nhèn hi trùh ta Buxôlo. ");
INSERT INTO hrebt_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ta aih, ƀài oh daq pachùh nhèn oe ti wì tapèh hì, khoe aih nhèn hi trùh ta Rôma. ");
INSERT INTO hrebt_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Oh daq ta aih hìa nhèn trùh, enh nòe hangai wì haq lam trùh ta Phôrum Abiu lam ajang nòe Piq Hnim đòeq hu đìh nhèn. Bu hnoq oh daq, Phaulô manè apôi Boc Plình, manoh haq jah tam kan cajap. ");
INSERT INTO hrebt_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Jò nhèn trùh ta Rôma, wì am Phaulô jah oe crài, i mòeq ngai lình wèq haq. ");
INSERT INTO hrebt_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Piq hì atìq ka aih, haq creo ka ƀài gucraq mangai Juđa trùh tagop ti haq, jò wì khoe trùh haq doe: “Oh daq au. Yac ka au qnhòq lah broq cleq đòeq tablêq hlài ka mangai bèn, broq cleq ma pagau hlài ka trong ranenh rìh acaq da kan boc yaq bèn, mahaq ta Jêrusalem wì rùp au am ka mangai Rôma. ");
INSERT INTO hrebt_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Wì aih khoe hadrah ngan au, wì enh caqnaih au, majah qmang aih au ùh lòm i broq qmòe yiniq lui cleq ma troq ka cachìt. ");
INSERT INTO hrebt_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mahaq mangai Juđa ùh waq qmang aih, dài au majah dang trùh ta Sêsa, ùh xài au enh tah hadrah ka mangai bèn. ");
INSERT INTO hrebt_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Dài aih raq, au majah enh glàm đeh pì oh daq đòeq hu anoe đeh ka pì, taiq kan tangèh da mangai Isorali au majah ep bac wê caxi datoeq kô”. ");
INSERT INTO hrebt_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Wì aih tèu bàu: “Nhèn qnhòq i hnoq moeq araq jàiq leq enh Juđê trùh ta nhèn, ùh i cabô lam anoe cleq ka nhèn, èh hadai ùh i mangai leq capoch qmèq cleq ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mahaq nhèn enh jah loq ìh hèm qmang leq, majah qmang aih nhèn loq dìq ka mangai oe taleq tameh qnang tablêq ka đaoq kô”. ");
INSERT INTO hrebt_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Khoe tanap hì ka haq, wì bàc ngai trùh tanòe haq oe, enh sroeh sroq trùh clam, haq toq anoe patô rai hnài wì loq ka diac Boc Plình, yŏc enh ranenh Môise xam ƀài pajàu đòeq hu àu waq ka wì lùi Chuaq Jesus. ");
INSERT INTO hrebt_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","I mangai lùi bàu haq anoe, i ngai ùh lùi. ");
INSERT INTO hrebt_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Pi mòeq manoh ka dabau wì hi loh hlài, dài qmang aih Phaulô capoch tam bàu kô: “Bàu Yeang Hadròeh khoe anoe joq troq, jò haq canòm ka pajàu Êsai đòeq hu doe ka boc yaq pì ");
INSERT INTO hrebt_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Drah trùh nòe ƀài mangai kô đòeq hu doe: Pì yŏc don tamàng mahaq ùh qnì tàng cleq; Yŏc mat ngan mahaq ùh hnoq cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Majah qmang aih, wì haq khoe trap manoh; Wì caxet don, Caqnhip clong mat. Yùq deh mat loq hnoq, Don cla loq tàng, Manoh loq hèm, Wì wìh hlài Èh Au loq broq ka wì jah brêh qmòh. ");
INSERT INTO hrebt_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Qmang aih, au enh pì loq kan dèch dech da Boc Plình khoe aràng am ka mangai diac wì, wì aih èh ma tamàng, ");
INSERT INTO hrebt_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Khoe ka Phaulô capoch qmang aih, mangai Juđa loh enh gùng rai tarahen ka dabau oe i jaq cleq. ");
INSERT INTO hrebt_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Phaulô oe wop baiq hanam, ta hnim haq ma clìh ka bac đòeq hu oe đò. Haq đìh dìq dŏng mangai leq lam glàm haq. ");
INSERT INTO hrebt_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Haq cajap manoh đòeq anoe ka wì diac Boc Plình, hnài wì loq ka Chuaq Jesus Christ, pi oe i cabô khech tàt hòm. ");
INSERT INTO hrebt_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Phaulô hapŏng da Jesus Christ, khoe jah creo broq mangai Tiaq cla, khoe jah lah đòeq crài hu anoe Bàu lem da Boc Plình, ");
INSERT INTO hrebt_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","aih Bàu lem enh nèh raq Boc Plình khoe tèu adroe ajang wì pajàu ta hset hadròeh, ");
INSERT INTO hrebt_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ràu trùh kon da haq, tiaq xech akia aih hauang loh enh nang noe bùa Đawit, ");
INSERT INTO hrebt_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","tiaq yiang da kan hadròeh, taiq haq khoe rìh hlài enh kan cachìt, aih ma khoe jah nhìn haq joq kon Boc Plình i cwìang i tai, aih raq Chuaq Jesus Christ, Chuaq da bèn, ");
INSERT INTO hrebt_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","canòm ka haq xam yiniq haq aih, nhèn ma khoe jah waq kan tabàih dech, jah broq mangai tiaq cla, đòeq creo dìq ka mangai rìm diac qnoeq trùh ajang kan loq iu da manoh lùi, ");
INSERT INTO hrebt_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ta ƀài mangai aih, oh daq hanoh khoe jah creo enh cla Chuaq Jesus Christ; ");
INSERT INTO hrebt_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","gòe dìq ka mangai Boc Plình ma loq waq deh oe ta Rôma, jah creo broq mangai hadròeh. Waiq dìq ka oh daq jah waq kan tabàih dech, jah kan catèm enh Boc Plình, aih Baq bèn, xam enh nòe Chuaq Jesus Christ! ");
INSERT INTO hrebt_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Adroe dìq dŏng aih, canòm ka Chuaq Jesus Christ, au manè apôi Boc Plình majah qmang aih manoh lùi da oh daq khoe jah anoe hlài jàp jìa ta crŏng taneh. ");
INSERT INTO hrebt_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Boc Plình au ma patìh dìq dèh ka manoh ti ajang anòe au ma anoe Bàu lem da kon haq, hadai wiang panhìn au ùh lah hêq ka ràu trùh oh daq. ");
INSERT INTO hrebt_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Rìm yàng jò au waiq khàn, au waiq khàn tàng ùh manòeq kô dua hì atìq èh tiaq manoh Boc Plình, pèh am trong au jah trùh ta oh daq. ");
INSERT INTO hrebt_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Joq qmang aih, au toq tangèh jah trùh hmàih ka oh daq, đòeq hadai jah pajùm kan tabàih yiang ti oh daq, dôq oh daq rai èh rai cajap, ");
INSERT INTO hrebt_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","aih ìq, au oe qne oh daq, đòeq hadai bèn wiang parông manoh dabau jah tadêh pajùm ta manoh lùi bèn, aih manoh lùi da oh daq xam da au. ");
INSERT INTO hrebt_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Au ùh enh dôq oh daq ùh qnì, bàc yàng au khoe padon lam hmàih ka oh daq đòeq hu jah wiang git plì ti oh daq xam mangai diac wì mahaq i kan khech tàt au trùh manòeq. ");
INSERT INTO hrebt_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Au pòq dòeh mangai Gorec xam mangai ùh xài mangai Gorec, mangai rabiaq xam mangai blùng. ");
INSERT INTO hrebt_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Aih ìq dài au majah toq enh anoe Bàu lem am ka pì oh daq, aih mangai ma rìh oe ta Rôma. ");
INSERT INTO hrebt_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Joq au ùh camaih ka Bàu lem majah qmang aih, aih raq kan itai da Boc Plình đòeq dèch rìm ngai ma i manoh lùi, adroe aih ka mangai Juđa atìq aih ka mangai Gorec; ");
INSERT INTO hrebt_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Majah qmang aih, enh dalam ka Bàu lem kô khoe mahnu kan taq atoq da Boc Plình, xi manoh lùi men jah, èh ajèn trùh ta kan lùi hòm, qmang ka bàu ma khoe achìh: “Mangai taq atoq rìh xi manoh lùi”. ");
INSERT INTO hrebt_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Qmang aih, kan nòeh da Boc Plình khoe mahnu enh plình tablêq hlài ka rìm trong ùh qnì iu yùq xam kan ùh taq atoq da ƀài mangai yŏc kan ùh taq atoq đòeq padit trong joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Majah qmang aih, yiniq cleq hu dôq wì jah loq ka Boc Plình, dìq khoe paqnoh ka wì, Boc Plình khoe patô ka wì, ");
INSERT INTO hrebt_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","majah qmang aih kan geo da haq mat bèn ùh xau hnoq, aih la kan itai mòeq đòe xam manoh haq, enh jò baxèm broq plình crŏng taneh khoe dayình qmòe tìah ka mat hnoq, jò wì ti ngan yiniq broq da haq. Aih ìq dài wì ma pi jah aclai rađeh, ");
INSERT INTO hrebt_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","majah qmang aih yac ka wì loq ka Boc Plình mahaq wì ùh waq broq qngah yiniq haq aih Boc Plình, èh hadai ùh waq manè apôi haq, ti tiaq toq trong ùh loh cleq xam manoh blùng bình toq kan clam cluiq. ");
INSERT INTO hrebt_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Wì doe đeh rabiaq, mahaq loh ka ratùt. ");
INSERT INTO hrebt_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Wì haq khoe halìh kan ranhòm ùh lùch da Boc Plình yŏc radua qmù loq hnhung lùch da kon mangai, da chìm, da ngè rìh tagùng, da ngè loq moq ta taneh. ");
INSERT INTO hrebt_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Aih ìq, Boc Plình majah dôq da wì haq clìh deh ta kan amùa qmang ka manoh cla wì haq ma enh, loh qmòe ka broq kan camaih hloe deh ka chac cla. ");
INSERT INTO hrebt_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Wì haq halìh trong joq qnàng da Boc Plình, đòeq yoc kan amòng, kùh waiq rai patìh ka ƀài ngè Boc Plình ma broq loh, ùh kùh waiq Boc Plình ma broq loh ƀài ngè aih, aih Boc Plình bèn ma khòh manè apôi mòeq đòe! Amen. ");
INSERT INTO hrebt_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Taiq ajang raq Boc Plình majah hi dôq da wì haq tiaq trong tango anang jìang ka camaih, taqne wì haq, gucadrì pi rìh hatiaq ma troq trong, wìh tiaq trong ùh troq. ");
INSERT INTO hrebt_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Gucalô hadai qmang aih cađac trong gucadrì gucalô, tiaq trong ùh troq aih toq ti enh ka dabau, hadai gucalô aih waq ka dabau, èh cla wì haq hi ep pòq dèh kan baxa aih. ");
INSERT INTO hrebt_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ùh hnau ka aih hòm, pàng wì haq ùh nhet chaq canau ka Boc Plình, aih ìq Boc Plình majah cađac wì tiaq dèh manoh ùh wìa, đòeq broq toq trong ùh loh cleq. ");
INSERT INTO hrebt_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Wì bình toq kan ùh taq atoq, kan đùc, kan plai, ratauq, toq kan tagit, jêh đac mangai, talech, loq qnùt, loq nòeh; ");
INSERT INTO hrebt_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","tapoch dech, tapoch qmèq ka dabau, git ka Boc Plình, da hadìac, padèch rađeh, catèh, rabiaq trong dù, ùh iu bàu miq baq; ");
INSERT INTO hrebt_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","blùng, ùh qnì wèq dèh bàu, ùh qnì tamèt, ùh i manoh loq waq. ");
INSERT INTO hrebt_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Yac ka wì loq ka Boc Plình taq atoq i doe: mangai leq broq ƀài yiniq qmang aih troq ka cachìt, aleq ma xài toq wì haq broq hi hêq, mahaq wì ti baxrùq tam mangai qnoeq broq qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Qmang aih, ìh qmat mangai ma toq ti tah hadarah tau, yac ka ìh qmat cabô ùh dèh, waq toq ìh hi hadrah mangai qnoeq aih èh ìh pi jah cwaih rađeh hòm, majah qmang aih jò ìh tah hadrah ka wì qnoeq, aih ìh hadai tah hadrah ka cla rađeh, ìh tah hadrah ka wì mahaq cla ìh hadai broq qmang ka wì. ");
INSERT INTO hrebt_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Manòeq kô, bèn loq kan hadrah da Boc Plình am ka ƀài mangai broq yiniq qmang aih, aih joq troq tiaq bàu joq qnàng. ");
INSERT INTO hrebt_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Wùih! mangai ma toq ti hadrah ka ƀài mangai broq qmang aih, mahaq cla hadai broq ùh troq, pì loq xoh cla pì claih ka kan hadrah enh Boc Plình qmòh? ");
INSERT INTO hrebt_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ahìaq ìh ùh dèh dèm đac kan loq waq bình halùih, kan loq àt, kan ùh manaq da haq, loh ka pi qnì canau kan loq waq da Boc Plình ma aràng ìh trùh ajang kan loq raxach ùh xài? ");
INSERT INTO hrebt_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Taiq manoh ìh cadoq, ùh raxach, aih ìh chàu pabình đòeq ka rađeh kan nòeh ta hì mahau atìq kô èh, jò kan hadrah taq atoq da Boc Plình mahi trùh, ");
INSERT INTO hrebt_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","jò aih, Boc Plình hi am hlài da tang ngai tiaq tang yiniq wì ma broq: ");
INSERT INTO hrebt_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Mangai leq cajap manoh broq trong lem, chaq kan qngah, kan ranhòm xam kan ùh hìaq loq lùch. Boc Plình am ka wì kan rìh halình mòeq đòe; ");
INSERT INTO hrebt_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","mangai leq i manoh toq àu tablêq, ùh tiaq trong joq qnàng, mahaq iu tiaq kan ùh taq atoq, aih èh Boc plình patem ka wì kan nòeh xam kan mahau. ");
INSERT INTO hrebt_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kan ùh catèm kan nanxa ka mangai broq dù, adroe aih ka mangai Juđa, khoe aih ka mangai Gorec; ");
INSERT INTO hrebt_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","mahaq kan qngah, kan ranhòm, xam kan catèm am ka rìm ngai broq lem, adroe aih ka mangai Juđa atìq aih ka mangai Gorec. ");
INSERT INTO hrebt_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Majah qmang aih, Boc Plình ùh loq waq ka apah. ");
INSERT INTO hrebt_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Mangai leq broq yiniq lui, yac ka haq ùh qnì ka ranenh haq aih dua hnhung lùch, magai leq loq ka ranenh mahaq broq yiniq lui, aih èh ep đòeq da ranenh hadrah haq; ");
INSERT INTO hrebt_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","majah qmang aih ùh xài mangai leq tàng đŏc ranenh aih hi wìa mangai taq atoq enh ngèa Boc Plình, mahaq mangai ma broq tiaq ranenh aih majah broq mangai taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ma joq qnàng, mangai diac wì ùh i đeh ka ranenh Môise, jò wì haq broq đeh trong ranenh ma thê, ƀài mangai aih yac ka ùh i ka ranenh, dua khoe broq ka rađeh i ranenh. ");
INSERT INTO hrebt_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Wì haq patô qnoh trong ranenh ma thê aih khoe achìh đeh ta manoh cliac wì haq: Manoh da cla panhìn am ka ranenh, gàu ngoc da cla i jò bahmàng i jò palem deh cla. ");
INSERT INTO hrebt_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Aih la ƀài yiniq padon trùh ta hì da Boc Plình enh dalam ka Chuaq Jesus Christ hu hadrah kan hlèp ta manoh kon mangai, wop qmang ka Bàu lem au ma khoe anoe. ");
INSERT INTO hrebt_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Manòeq, ìh doe rađeh kô mangai Juđa, kùi padài enh qnhèq ka ranenh, catèh đeh loq ka Boc Plình, ");
INSERT INTO hrebt_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","loq ka manoh haq, canau trong leq troq, trong leq ùh, majah qmang aih ranenh khoe hnài ìh; ");
INSERT INTO hrebt_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","catèh đeh broq mangai ajèn trong ka mangai lua mat, broq kan qngah ka mangai oe ta clam, ");
INSERT INTO hrebt_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","broq mangai hnài ƀài mangai blùng, ƀài mangai qnhòq gêh manoh, majah qmang aih ta hset ranenh i kan rabiaq xam trong joq qnàng, ");
INSERT INTO hrebt_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","qmang aih ìh hnài mangai qnoeq mahaq ùh hnài cla rađeh qmoh? Ìh hnài apaq atùng, mahaq ìh atùng! ");
INSERT INTO hrebt_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ìh doe: ùh khòh tango, mahaq ìh tango! Ìh git ramòt ka ƀài radua qmù, mahaq ìh blah yŏc da haq dahwèq. ");
INSERT INTO hrebt_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ìh hnhè rađeh wèq tiaq ranenh, mahaq ìh ùh broq tiaq ranenh, dài aih raq ìh ma khoe broq kan xep ka Boc Plình! ");
INSERT INTO hrebt_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Taiq pì raq, wì mangai enh gùng majah tapoch qmèq ka yiniq Boc plình, tìah qmang ka bàu ma khoe achìh. ");
INSERT INTO hrebt_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Joq! tàng pì broq tiaq ranenh, ramènh kat akia aih ùh hìaq ngwan, mahaq tàng pì broq ùh troq tiaq ranenh, yac ka pì broq ramènh kat akia aih bu diang ùh. ");
INSERT INTO hrebt_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Qmang aih, tàng mangai qnhòq broq ramènh kat akia wèq tiaq bàu ranenh hnài, aih ma ùh tìah ka khoe kat akia qmòh? ");
INSERT INTO hrebt_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mangai ùh broq ramènh kat akia, mahaq wèq gêh geo tiaq bàu ranenh, mangai aih èh ma hadrah ƀài pì, aih ƀài mangai yac ka i ranenh, i broq ramènh kat akia, mahaq ùh lênh broq tiaq ranenh. ");
INSERT INTO hrebt_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Qmang aih mangai leq toq enh gùng haq broq mangai Juđa, aih ùh xài mangai Juđa, ramènh kat akia toq enh gùng, aih ùh xài ra mènh kat akia; ");
INSERT INTO hrebt_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","mahaq mangai Juđa ma joq qnàng aih mangai Juđa enh dalam, ramènh kat akia ma joq qnàng aih ramènh kat akia enh dalam xi Yiang hadròeh, ùh xài tiaq toq bàu achìh. Mangai Juđa qmang aih ma tajì ka manè, khòh jah padèch, ùh xài enh kon mangai mahaq enh Boc Plình.");
INSERT INTO hrebt_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Tàng qmang aih kan yeo loe da mangai Juđa aih qmang leq, ùh meh ramènh kat akia ajah cleq? ");
INSERT INTO hrebt_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Jah bàc trong. Adroe aih rameh: Aih xài bàu Boc Plình khoe am ka mangai Juđa. ");
INSERT INTO hrebt_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Mahaq tàng ta wì aih i ƀiaq ngai loq tablòq manoh ka Boc Plình, kan loq blòq manoh da wì haq ahìaq broq ka kan ùh tablòq mannoh cliac da Boc Plình loh qngwan qngwaiq ùh? ");
INSERT INTO hrebt_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ùh i qmang aih! Boc Plình aih joq qnàng, kon mangai kô ma loq qnùt, tìah ka khoe achìh “Wì jah creo ka ìh mangai taq atoq, jò ìh capoch, Jah blêq jò wì tah hadarah ka ìh”. ");
INSERT INTO hrebt_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mahaq tàng kan ùh taq atoq da bèn jah patô qnoh kan taq atoq da Boc Plình, aih èh bèn anoe qmang leq? Boc Plình ma ùh taq atoq jò haq qnoh kan panòeh ka bèn qmòh? (Au capoch troeq wì ma dìh loq rahen) ");
INSERT INTO hrebt_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Joq ùh lòm, tàng qmang aih èh Boc Plình hadrah crŏng tneh kô qmang leq? ");
INSERT INTO hrebt_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Mahaq tàng bàu joq qnàng da Boc Plình jah kan ranhòm haqnhèq ajang nòe bàu tapoch qnùt da au, aih hagleq au majah oe ep pòq kan hadrah tìah ka mangai broq yiniq lui? ");
INSERT INTO hrebt_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Tàng qmang aih hagleq bèn ùh broq trong dù đòeq jah trong lem, tìah ka mangai loq patah khoe capoch dech ka nhèn doe nhèn hnài trong aih? Kan hadrah baxa taqmòq ka wì haq aih taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Aih qmang leq, bèn i cleq ma yeo lem ka wì? Ùh lòm i, hacô bèn khoe anoe panhìn yac ka mangai Juđa yac mangai Gorec dìq oe enh qneq ka cwìang yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","qmang ka khoe achìh: “Ùh i cabô taq atoq, yac ka mòeq ngai dua ùh, ");
INSERT INTO hrebt_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ùh i cabô i mamoh loq hèm, Ùh i cabô ti chaq Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wì haq dìq khoe lam hwang, dìq khoe pi loh cleq; Ùh i mòeq ngai broq trong lem, yac ka mòeq ngai dua ùh. ");
INSERT INTO hrebt_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Hŏng wì haq da hah tìah ka ngah ralùng hanang; Yŏc dèh rapet đòeq qnùt wì qnoeq; Blìa hacùng wì haq i nŏc bìh tùa. ");
INSERT INTO hrebt_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Hacùng wì haq toq nà hanip xam kan pagau. ");
INSERT INTO hrebt_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Jènh wì haq darênh toq ka broq ta ùc mahim. ");
INSERT INTO hrebt_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Trong lam da wì haq toq kan raliang xam nanxa, ");
INSERT INTO hrebt_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Wì ùh lah qnì ka trong ma catèm. ");
INSERT INTO hrebt_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Enh ngèa wì haq ùh i kan loq iu yùq Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Manòeq kô bèn loq, rìm yiniq ranenh ma anoe, aih anoe ka rìm ngai oe enh qneq ka ranenh, dôq rìm toq hacùng dìq ep caqnhìp, dìq ka phù cròng ep pòq yiniq lui enh ngèa Boc Plình; ");
INSERT INTO hrebt_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","majah qmang aih ùh i ka cabô broq tiaq ranenh ma jah creo ka haq aih taq atoq enh ngèa Boc Plình, majah qmang aih ranenh patô dôq wì loq dèh ka yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Mahaq manòeq kô, kan taq atoq enh Boc Plình, Hset ranenh xam ƀài pajàu ma khoe wiang panhìn, khoe patô qnoh enh gùng ka ranenh: ");
INSERT INTO hrebt_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Aih la kan taq atoq da Boc Plình oe ajang nòe bèn lùi Chuaq Jesus Christ, am dìq ka rìm ngai ma lùi. Ùh i cleq crài ka dabau, ");
INSERT INTO hrebt_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","majah qmang aih rìm ngai dìq khoe broq yiniq lui, khoe capòch ka kan ranhòm da Boc Plình, ");
INSERT INTO hrebt_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","mahaq canòm kan tabàih enh Boc Plình, wì jah dech kan taq atoq, majah qmang aih kan baxon hlài khoe jah broq gêh enh dalatm ka Chuaq Jesus Christ, ");
INSERT INTO hrebt_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","aih la Mangai Boc Plình khoe dèch haq broq ramènh baxon hlài, xi manoh lùi ta mahim haq aih, Boc Plình rangep ka kan panòeh, ajang aih haq paqnoh dèh kan taq atoq. Majah qmang aih, haq khoe caqnaih da wì yiniq lui ma broq enh nèh, ");
INSERT INTO hrebt_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Haq khoe broq qmang aih đòeq taqnhòng kô haq patô đeh kô taq atoq đòeq creo ka mangai leq ma lùi Chuaq Jesus jah kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Qmang aih, kan catèh oe jang leq? Pi i, khoe cađac, cađac ajang ranenh leq? Tiaq ranenh da yiniq broq? Ùh xài, mahaq tiaq ranenh da manoh lùi; ");
INSERT INTO hrebt_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","majah qmang aih bèn doe kon mangai jah kan taq toq ajang noè manoh lùi, ùh xài ajang broq tiaq ranenh. ");
INSERT INTO hrebt_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ahìaq Boc Plình aih Boc Plình toq da mangai Juđa? Ma ùh xài hadai Boc Plình da mangai diac wì diq? ");
INSERT INTO hrebt_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Majah qmang aih i moèq Boc Plình raq, aih Yiang broq ka mangai kat akia jah taq atoq tiaq manoh lùi, hanoh broq ka mangai ùh kat akia jah kan taq atoq tiaq manoh lùi. ");
INSERT INTO hrebt_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Tàng qmang aih, canòm ka manoh lùi bèn ka cađac ranenh qmòh? Joq ùh lòm i qmang aih! Yeo hnau ka aih bèn broq ka ranenh jah cajap. ");
INSERT INTO hrebt_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Qmang aih bèn anoe qmang leq Apraham cadraq bèn. Tiaq xech akia haq khoe jah lòeq cleq? ");
INSERT INTO hrebt_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Joq qmang aih, tàng joq haq khoe jah kan taq atoq tiaq yiniq broq, aih i noè đòeq haq jah padèch rađeh, mahaq enh ngèa ka Boc Plình ùh xài qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Majah qmang aih, Hset Hadròeh hnài cleq? Apraham lùi Boc Plình, bìac aih raq khoe broq ka haq jah kan taq atoq! ");
INSERT INTO hrebt_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Manòeq kô mangai abroq, hliac jènh baha aih ùh xài kan tabàih, mahaq tìah ka dòeh, ");
INSERT INTO hrebt_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","mangai ma ùh dùh i broq qmòe cleq, mahaq lùi Boc Plình aih Yiang broq ka mangai pòq yiniq lui jah kan taq atoq, manoh lùi da haq aih majah creo ka haq aih taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Đawit hanoh anoe qmang aih, jò haq ràu trùh xôq ramot ka mangai jah Boc Plình am ka haq kan taq atoq ùh tiaq trong yiniq abroq, rameh: ");
INSERT INTO hrebt_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Joq xôq ramot qnàng ka ƀài mangai lui haq jah caqnaih, Yiniq lui haq jah gahnàp! ");
INSERT INTO hrebt_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Joq xôq ramot qnàng ka mangai Boc Plình pi arèn da haq yiniq lui”. ");
INSERT INTO hrebt_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Bàu anoe trùh xôq ramot aih, ma anoe toq ka mangai ma kat akia qmòh? Hadai am ka mangai ma ùh kat akia. Majah qmang aih bèn doe ameh: Manoh lùi da Apraham khoe jah tình ka haq taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Mahaq jah tình qmang leq? Atìq ka haq broq ramènh kat akia loq adore ka haq broq ramènh kat akia? Aih ùh xài atìq ka haq broq ramènh kat akia, mahaq adroe. ");
INSERT INTO hrebt_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Qmang aih, haq khoe jah yŏc teo xìt kat akia, tìah ka teo da kan taq atoq haq ma khoe jah dèh adroe xi manoh lùi, jò haq qnhòq broq ramènh kat akia, đòeq hu broq baq dìq dŏng ƀài mangai lùi mahaq ùh broq ramènh kat akia, dôq wì aih hadai jah kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Èh hadai broq baq ƀài mangai broq ramènh kat akia, aih baq da ƀài mangai ùh xài toq kat akia hi hêq, mahaq hadai cadiang tiaq teo manoh lùi manoh lùi da Apraham kan cadraq bèn, ma khoe jah dèh adroe ka haq broq ramènh kat akia. ");
INSERT INTO hrebt_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Qmang aih, bàu ma tèu am ka Apraham xam nang noe haq jah yŏc dìq crŏng taneh kô broq kùng hang, ùh xài loh enh ranenh, mahaq loh enh kan taq atoq da manoh lùi. ");
INSERT INTO hrebt_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Majah qmang aih, tàng tiaq ranenh men jah kùng hang, aih èh manoh lùi hi loh ka qngwan qngwaiq, bàu tèu am hadai khoe cađac. ");
INSERT INTO hrebt_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Majah qmang aih, ranenh plôh loh toq kan panòeh, mahaq taleq ùh hìaq i ranenh, ta aih hadai ùh i mangai broq ùh troq ka ranenh. ");
INSERT INTO hrebt_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Qmang aih, canòm ka manoh lùi kon mangai ma hi jah waq kùng hang, ƀài yiniq aih dìq jah xi kan tabàih dech, đòeq bàu tèu jah cajap ka nang noe Apraham, ùh xài am toq ka nang noe oe enh qneq ka cwìang da ranenh, mahaq hadai am ka nang noe i manoh lùi da Apraham, kan cadraq bèn, ");
INSERT INTO hrebt_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","wop qmang ka bàu ma khoe achìh: Au khoe dèch ìh broq baq bàc diac. Haq aih joq baq da bèn oe enh ngèa ka Boc Plình, aih Mangai haq ma khoe lùi, aih Boc Plình ma am kan rìh ka mangai cachìt, creo ka ƀài yiniq qnhòq i tìah gleq khoe i. ");
INSERT INTO hrebt_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Haq taqngèh gòm jò pi qmòe ka dua hu gòm tangèh, mahaq dua haq lùi, aih haq ma hijah wìa baq bàc diac, tiaq qmang ka bàu khoe doe ka haq: “Nang noe ìh jah qmang aih èh”. ");
INSERT INTO hrebt_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Haq hnoq dèh chac khoe craq, majah qmang aih khoe ten hrinh hanam, hnoq Sara pi oe jah ha-uang, mahaq manoh lùi da haq dua ùh xùch. ");
INSERT INTO hrebt_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Haq ùh lòm rangòt, hadai ùh hìaq ùh tìn bàu Boc Plình, mahaq kan lùi haq èh rai dêh rai toq manè apôi Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Majah qmang aih haq lùi trong leq Boc Plình khoe tèu, Boc Plình i cwìang đòeq broq gêh trong aih. ");
INSERT INTO hrebt_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Aih ìq, dài manoh lùi da haq khoe broq ka haq jah kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Bàu ma doe: “Manoh lùi da haq khoe broq ka haq jah kan taq atoq”, aih ùh xài anoe toq ka mòeq ngai cla haq, ");
INSERT INTO hrebt_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","mahaq hadai anoe am ka bèn, manoh lùi hadai broq ka bèn jah kan taq atoq, majah qmang aih bèn lùi Boc Plình aih Mangai khoe broq ka Chuaq Jesus, Chuaq da bèn rìh hlài enh kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Taiq yiniq lui bèn wì rùp jêh đac haq, haq rìh hlài đòeq broq ka bèn jah kan taq atoq.");
INSERT INTO hrebt_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Qmang aih patep pang jò khoe jah creo ka bèn mangai taq atoq tiaq manoh lùi, aih bèn khoe jah hatroq ti Boc Plình, canòm ka Chuaq Jesus Christ da bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Aih Mangai broq ka bèn jah mùt ta kan tabàih dech kô, aih raq kan tabàih ma broq ka bèn jah yòng cajap manòeq, èh bèn hadai catèh rađeh ajang nòe tangèh gòm kan ranhòm da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ma xài toq aih hi dìq, bèn hadai catèh rađeh ta kan nanxa diq, majah qmang aih bèn loq kan nanxa men loh kan loq kèm, ");
INSERT INTO hrebt_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","kan loq kèm men loh kan qnhrang, kan qnhrang men loh kan tangèh. ");
INSERT INTO hrebt_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Kan tangèh ùh broq ka bèn ep camaih xep, majah qmang aih kan loq waq da Boc Plình khoe pùc jàp ta manoh bèn xi Yiang Hadròeh ma khoe am ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Joq qmang aih, jò bèn oe raq ùh nac canèn, tiaq troq dèh jò ma SaSt 17:5 SaSt 15:5 pajaq adroe, Christ khoe cachìt am ka mangai i yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ƀiaq ka i mangai chìuq cachìt am ka mangai taq atoq, dùnh dùnh ji loq i mangai cachìt am ka mangai lem. ");
INSERT INTO hrebt_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mahaq Boc Plình mahno kan loq waq haq am ka bèn, jò bèn oe raq mangai i yiniq lui, aih Christ khoe cachìt am ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Manòeq kô bèn khoe canòm ka mahim haq đoèq jah kan taq atoq, aih èh hadai canòm ka haq raq đòeq hu jah dèch claih khoe ka kan mahau kàn enh Boc Plình dàng leq hòm! ");
INSERT INTO hrebt_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Majah qmang aih jò bèn oe raq tablêq ka Boc Plình, mahaq khoe jah hatroq hlài ka haq canòm ajang nòe kon haq khoe cachìt am ka bèn, loq ka manòeq kô jò khoe jah hatroq, bèn jah canòm kan rìh da Kon aih raq đòeq bèn jah dèch dàng leq hòm! ");
INSERT INTO hrebt_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ùh xài toq aih hi dìq, mahaq enh dalam ka Chuaq Jesus Christ bèn jah catèh rađeh ta Boc Plình, canòm ka haq aih bèn khoe jah hatroq ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Qmang aih, taiq mòeq ngai raq yiniq lui ma khoe mùt ta crŏng taneh kô, taiq yiniq lui majah i kan cachìt, hadai qmang aih kan cachìt khoe trùh ta rìm ngai, majah qmang aih taiq rìm ngai dìq khoe i yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Majah qmang aih, adroe ka i ranenh, yiniq lui khoe i ta crŏng taneh kô, mahaq qnhòq i ranenh, dài aih yiniq lui hadai qnhòq taqmòq ka cabô. ");
INSERT INTO hrebt_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Hnoq anoe qmang aih, patep enh Ađam trùh ta Môise, rìm ngai dìq khoe oe enh qneq ka cwìang da kan cachìt, hloe xam mangai ùh broq đeh yiniq lui tiah ka yiniq lui da Ađam, aih mangai ma broq dua đoèq ka Mangai hu padon trùh. ");
INSERT INTO hrebt_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Mahaq yiniq lui crài ka kan tabàih dech. Majah qmang aih, tàng joq taiq mòeq ngai raq ma broq yiniq lui mahaq mangai qnoeq ep cachìt ataq, loq ka kan loq waq da Boc Plình xam kan am dech da haq canòm ajang moèq ngai Chuaq Jesus khoe ùc bình halùih ka rìm ngai! ");
INSERT INTO hrebt_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Èh hòm, kan am dech kô haq crài ka bìac loh enh mòeq ngai ma broq yiniq lui: Mòeq yiniq lui raq, mahaq kan hadrah khoe taqmòq kan cachìt, mahaq da kan am dech aih: atìq ka jò yiniq lui khoe bàc aih cadoe aràng am ka bèn kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Majah qmang aih, tàng joq taiq yiniq lui da mòeq ngai raq kan cachìt khoe jah wèq cwìang enh mangai aih, loq ka ƀài mangai jah ùh dìq ùh dài kan tabàih enh Boc Plình xam kan am dech da kan taq atoq, wì haq jah canòm ka mòeq ngai Chuaq Jesus Christ đòeq jah cwìang ta kan rìh yeo hnau ka aih hòm! ");
INSERT INTO hrebt_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Qmang aih, taiq mòeq yiniq lui raq kan hadrah baxa khoe taqmòq ka rìm ngai qmang leq, hadai qmang aih mòeq ngai raq broq taq atoq, kan taq atoq aih am kan rìh hadai jàp ka rìm ngai. ");
INSERT INTO hrebt_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Majah qmang aih, taiq kan ùh iu da moèq raq, dài mangai qnoeq dìq loh dŏng đeh mangai i tuiq, hadai qmang aih diq, taiq kan loq iu da mòeq ngai raq dài mangai qnoeq dìq loh dŏng mangai taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Ranenh khoe plah rađeh taqne, dôq yiniq lui èh rai bàc, mahaq taleq yiniq lui khoe rai bàc, ta aih kan tabàih dech bàc yeo hnau hòm, ");
INSERT INTO hrebt_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","qmang aih, yiniq lui wèq cwìang ta kan cahìt qmang leq, kan tabàih dech wèq cwìang ta kan taq atoq hanoh qmang aih đòeq hu am kan rìh halình mòeq đòe enh dalam ka Jesus Christ aih Chuaq bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Qmang aih bèn oe anoe qmang leq hòm? Ajoq bèn oe catàm yôt ta yiniq lui dôq kan tabàih dech jah ùh dìq ùh dài qmòh? ");
INSERT INTO hrebt_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ùh lòm qmang aih, bèn khoe cachìt ka yiniq lui, ji laiq bèn ma oe rìh ta yiniq lui hòm? ");
INSERT INTO hrebt_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ahìaq oh daq ùh qnì, dìq dŏng ka bèn khoe jah ƀaptem enh dalam ka Chuaq Jesus Christ, aih ƀaptem enh dalam kan cachìt da haq qmòh? ");
INSERT INTO hrebt_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Bèn khoe jah catùh ti haq xi ƀaptem enh dalam kan cachìt haq, đòeq tìah ka Chuaq Jesus Christ canòm kan ranhòm enh nòe Baq jah rìh hlài enh kan cachìt qmang leq, bèn hadai jah rìh hlài ta kan rìh maneo qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Tàng joq bèn khoe pajùm mòeq ti haq ta kan cachìt qmang ka haq, aih èh joq qnàng bèn hadai jah pajùm mòeq ti haq ta kan rìh hlài tìah qmang ka haq: ");
INSERT INTO hrebt_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","majah qmang aih bèn loq kon mangai dùnh da bèn khoe jah tiang talong pagat ti haq, dôq chac ma patìh ka yiniq lui kô jah lùch đac dŏng, aih èh bèn pi ep broq hapŏng ka yiniq lui hòm. ");
INSERT INTO hrebt_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Majah qmang aih, mangai leq khoe cachìt haq aih khoe jah claih ka yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Manoèq kô, tàng joq bèn khoe cachìt ti Christ, bèn loq aih èh rađeh hadai jah rìh hlài ti haq, ");
INSERT INTO hrebt_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","majah qmang aih bèn loq, pang jò Chuaq Jesus Christ khoe rìh hlài enh kan cachìt, haq pi cachìt hòm, kan cachìt pi i cwìang cleq enh qnhèq ka haq hòm. ");
INSERT INTO hrebt_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Haq cachìt aih cachìt ka yiniq lui, cachìt moèq yàng am ka dìq dŏng, mahaq manòeq kô haq rìh aih rìh ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Hadai qmang aih diq, oh daq drah ngan rađeh hadai khoe cachìt ka yiniq lui mahaq rìh ka Boc Plình enh dalam ka Chuaq Jesus Christ. ");
INSERT INTO hrebt_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Apaq dôq yiniq lui oe i cwìang cleq ta chac hamac ma loq cachìt da oh daq, apaq tiaq trong haq ma ònh. ");
INSERT INTO hrebt_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Apaq dèch chac hamac cla am ka yiniq lui, đoèq broq ranac patìh ka kan dù, mahaq drah dèch chac cla oh daq ka Boc Plình qmang ka mangai khoe cachìt mahaq manòeq kô khoe rìh hlài, dèch rìm yiniq ta chac cla am ka Boc Plình đoèq broq ranac patìh am ka kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Majah qmang aih yiniq lui ùh i cwìang cleq ta oh daq; taiq oh daq pi i oe enh qneq ka ranenh mahaq oe enh qneq kan tabàih dech. ");
INSERT INTO hrebt_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Khoe aih qmang leq! Taiq bèn pi oe enh qneq ka ranenh, mahaq oe enh qneq ka kan tabàih dech aih èh bèn khòh broq yiniq lui qmòh? Ùh qmang aih! ");
INSERT INTO hrebt_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Oh daq ma ùh loq! tàng joq oh daq khoe dèch cla rađeh đoèq hu iu tiaq cabô, aih axài broq dìc mangai bèn ma iu, broq dìc da yiniq lui ajèn trùh ta kan cachìt loq broq dìc da kan loq iu đoèq hujah kan taq atoq? ");
INSERT INTO hrebt_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Mahaq manè apôi Boc Plình, majah qmang aih atìq ka oh daq broq dìc ka yiniq lui, mahaq manòeq kô khoe dìq ka manoh wìh hlài iu tiaq Trong ma khoe hnài đòeq broq maneh ka rađeh! ");
INSERT INTO hrebt_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Qmang aih oh daq khoe claih enh yiniq lui, khoe jah wìa hapŏng kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Au anoe troeq bàu wì maloq doe, majah qmang aih kon mangai da oh daq ùh i nèn cleq. Qmang aih oh daq khoe hmaq đoèq dèh chac hamac broq hapŏng dìc kan amùa ratauq broq dù qmang leq, manòeq kô oh daq hadai dèch dèh chac broq hapŏng kan taq atoq qmang aih diq. ");
INSERT INTO hrebt_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Jò oh daq oe raq broq dìc ka yiniq lui, oh daq ùh i tawac cleq ka trong taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Aih oh daq jah cleq? Ajoq manòeq kô oh daq jah toq kan camaih, majah qmang aih pulùch da ƀài yiniq aih xài kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Mahaq manòeq kô oh daq khoe jah claih enh yiniq lui khoe jah wìa hapŏng Boc plình, aih oh daq jah yŏc ka rađeh kan hadròeh đòeq pulùch èh jah kan rìh halình moèq đòe. ");
INSERT INTO hrebt_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Majah qmang kan baha da yiniq lui aih kan cachìt, mahaq kan am dech enh Boc Plình aih kan rìh halình enh dalam ka Chuaq Jesus Christ, Chuaq da bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Oh daq ma ùh loq (Au doe ka mangai ma loq ka ranenh) ranenh i cwìang toq jò mangai oe rìh qmòh? ");
INSERT INTO hrebt_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Tìah ka gucadrì i ŏng, waq toq ŏng haq oe rìh pang leq, ranenh panan haq tiaq deh ŏng pang aih, mahaq tàng ŏng haq cachìt haq jah claih enh ranenh ma khoe kàt haq ti ŏng. ");
INSERT INTO hrebt_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Qmang aih, tàng joq ŏng haq oe rìh, mai haq lam yŏc mangai qnoeq, aih ep creo ka haq mangai gucadrì tango, mahaq tàng joq ŏng haq khoe cachìt, aih haq khoe claih ka ranenh, yac ka haq yŏc mangai qnoeq, haq ùh xài mangai tango. ");
INSERT INTO hrebt_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Yôiq oh daq da au! oh daq hanoh qmang aih, xam chac da Christ oh daq hadai khoe cachìt ka ranenh, đoèq hu jah yŏc mangai qnoeq, aih mangai ma khoe rìh hlài enh kan cachìt, dôq bèn jah loh plì ka Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Majah qmang aih jò bèn oe rìh tiaq kan loq ònh da xech akia nèh, ranenh khoe parèu ƀài kan qmèq tabroq ta chac bèn dôq loh plì ta kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Mahaq manòeq kô tiaq ranenh ma xan rùp padràng yôt bèn, bèn khoe cachìt, bèn khoe jah claih khoe ka ranenh, đòeq hu patìh ka Boc Plình tiaq trong neo da Yiang Hadròeh, pi oe tiaq trong dùnh da bàu achìh. ");
INSERT INTO hrebt_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Qmang aih bèn oe anoe cleq hòm? Ranenh aih ìq yiniq lui qmòh? Joq ùh lòm i qmang aih! Mahaq taiq ranenh au men jah loq dèh ka yiniq lui, tàng joq ranenh ùh doe: “Ìh ùh khòh daiq”, aih au khoe ùh qnì ka kan daiq. ");
INSERT INTO hrebt_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Aih ìq, yiniq lui khoe dahôiq ajang ranenh đòeq xêh qnoh bài kan loq ònh daiq ta cliac au: Ùh hìaq i ranenh, aih yiniq lui cachìt. ");
INSERT INTO hrebt_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Nèh haq, qnhòq i ranenh aih au rìh, yàng jò ranenh hi trùh aih yiniq lui rìh, au loh ka cachìt glòq hòm. ");
INSERT INTO hrebt_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Au ma hi hnoq, lêh gêh haq ranenh đoèq broq ka au rìh, cadoe tìc aràng au trùh ta kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Majah qmang aih yiniq lui khoe dahôn yŏc ranenh đoèq hu padô au, ti ajang aih raq au majah cachìt. ");
INSERT INTO hrebt_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Qmang aih, ranenh aih hadròeh, bàu thê hanoh hadròeh, dìq lem rai taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Wùih kan lem qmang aih khoe loh nen dôq au cachìt qmòh? Ùh lòm i qmang aih! Mahaq yiniq lui ma khoe broq ka au cachìt, haq yŏc kan lem broq au cachìt, đòeq haq jah patô rađeh aih yiniq lui, aih ìq yiniq lui cachàt ajang ranenh majah loh ka xòc dìq jaq. ");
INSERT INTO hrebt_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Bèn loq ranenh aih yiang, mahaq manoh da au kô aih xech akia, khoe tech đoèq broq dìc ka yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Majah qmang aih, au ùh qnì đeh broq cleq: Au ùh lòm broq trong cla ma enh, mahaq broq toq trong cla ma git. ");
INSERT INTO hrebt_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Mahaq tàng au broq trong au ma git, aih au canau loq ranenh joq qnàng lem. ");
INSERT INTO hrebt_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Jò aih au mahi loq, ùh xài au broq ƀài yiniq aih, mahaq yiniq lui rìh oe enh dalam ka au. ");
INSERT INTO hrebt_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Au loq kan lem ùh oe ta au, aih ìq rameh: haq ùh oe ta manoh au, majah qmang aih au enh broq trong lem mahaq ùh hlàt broq ka gêh; ");
INSERT INTO hrebt_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","au ùh broq trong lem au ma enh, mahaq broq trong qmèq cla ma ùh enh. ");
INSERT INTO hrebt_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Manòeq kô tàng joq au broq trong au ùh enh, aih pi xài au broq mahaq yiniq lui ma rìh oe enh dalam ka au ma broq trong aih. ");
INSERT INTO hrebt_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Qmang aih au hnoq i ranenh kô enh dalam ka au: Jò au enh broq trong lem, kan qmèq hatiaq hloe au jò aih raq. ");
INSERT INTO hrebt_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Majah qmang aih tiaq kon mangai enh dalam, au lem bùi ka ranenh Boc Plình; ");
INSERT INTO hrebt_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","mahaq au loq dèh ta chac i mòeq ranenh qnoeq tablêq ka ranenh ta gàu au, panan thê au broq hapŏng ranenh da yiniq lui, aih ranenh ma qnang tabroq ta chac au. ");
INSERT INTO hrebt_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Joq haƀo ka au! Cabô mahu dèch au claih khoe ka chac hamac loq cachìt kô èh? ");
INSERT INTO hrebt_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Manè apôi Boc Plình, canòm ka Chuaq Jesus Christ, aih Chuaq da bèn! Qmang aih, cla au yŏc dèh gàu ngoc patìh ka ranenh da Boc Plình, mahaq xech akia au broq hapŏng dìc ka ranenh da yiniq lui.");
INSERT INTO hrebt_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Qmang aih, manòeq kô khoe pi i kan hadrah ka mangai oe ta Chuaq Jesus Christ; ");
INSERT INTO hrebt_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","majah qmang aih ranenh da Yiang Hadròeh kan rìh khoe canòm ka Chuaq Jesus Christ đòeq caqnaih au loh khoe ka ranenh da yiniq lui xam kan cachìt. ");
INSERT INTO hrebt_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Majah qmang aih yiniq cleq ranenh ma ùh hlàt broq, taiq xech akia broq ka ranenh loh ka pi nèn, aih Boc Plình khoe broq: Taiq yiniq lui haq majah khoe thê dèh kon yŏc xech akia qmang ka xech akia yiniq lui da bèn, èh khoe hadrah yiniq lui ta xech akia aih, ");
INSERT INTO hrebt_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","dôq kan taq atoq da ranenh ma panan broq jah gêh enh dalam bèn, aih la ƀài mangai ma ùh tiaq dua da xech akia mahaq tiaq dua da Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Mangai rìh tiaq xech akia gàu ngoc wì haq haqmiang chaq toq trong xech akia ma enh, mangai rìh tiaq Yiang Hadròeh manoh haq haqmiang chaq toq trong daYiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Chaq toq trong da xech akia enh aih èh loh kan cachìt, chaq trong Yiang Ha droèh aih èh loh kan rìh xam kan catèm. ");
INSERT INTO hrebt_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Majah qmang aih haqmiang chaq toq trong da xech akia aih tablêq hlài ka Boc Plình, majah qmang aih haq ùh tiaq ranenh da Boc Plình, yeo hnau ka aih hòm haq tiaq ùh jah. ");
INSERT INTO hrebt_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ƀài mangai rìh tiaq xech akia, ùh jò leq lem ka manoh Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Hnoq anoe qmang aih, tàng joq Yiang Hadròeh da Boc Plình rìh oe enh dalam oh daq, oh daq ùh rìh tiaq xech akia hòm mahaq rìh tiaq Yiang Hadròeh, tàng cabô ùh i ka Yiang Hadròeh da Christ, aih ùh xài mangai da haq. ");
INSERT INTO hrebt_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Qmang aih, tàng joq Christ oe enh dalam oh daq, yac ka chac oh daq cachìt ka yiniq lui, mahaq yiang aih rìh taiq kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Èh hòm, tàng joq Yiang da Boc Plình ma khoe broq ka Chuaq Jesus rìh hlài enh kan cachìt oe ti oh daq. Haq ma broq ka Chuaq Jesus rìh hlài enh kan cachìt aih hadai canòm ka Yiang da haq ma oe ta dalam oh daq đoèq broq ka chac mac ma loq cachìt da oh daq jah rìh hlài. ");
INSERT INTO hrebt_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Qmang aih, dìq ka oh daq bèn pi oe pòq doèh xech akia đòeq hu rìh tiaq haq. ");
INSERT INTO hrebt_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Joq qmang aih, tàng joq oh daq rìh tiaq xech akia, aih èh ep cachìt, mahaq tàng canòm ka Yiang Hadroèh đòeq haq broq cachìt dŏng ƀài kan qmèq da chac hamac aih èh oh daq rìh. ");
INSERT INTO hrebt_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Majah qmang aih, dìq dŏng mangai leq i Yiang Hadròeh da Boc Plình qnung trong, aih dìq kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Yiang Hadròeh oh daq ma khoe jah aih ùh dôq oh daq broq hapŏng dìc đòeq rìh ta kan yùq crè hòm, mahaq khoe am ka oh daq jah i manoh da kon ban, canòm ajang aih bèn mahi jah creo: “Aba- Baq!” ");
INSERT INTO hrebt_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Yiang Hadròeh raq ma khoe panhìn ta manoh bèn loq đeh kô kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Manoèq kô, tàng joq bèn kon Boc Plình, aih bèn hadai mangai wiang jah kùng hang. Mangai wiang jah kùng hang enh Boc Plình, mangai wiang jah kùng hang ti Christ, waq toq bèn hadai wiang nanxa ti haq, aih èh bèn hadai wiang jah kan ranhòm ti haq. ");
INSERT INTO hrebt_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Au hèm, kan nanxa manòeq kô ùh tajì đoèq hu tawêh ti kan ranhòm padon trùh ta bla èh, aih la ƀài kan ranhòm hu padon qnoh am ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Joq qnàng qmang aih, rìm yiniq dìq toq tangèh gòm hnoq ƀài kon Boc Plình jah paqnoh. ");
INSERT INTO hrebt_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Majah qmang aih, rìm yiniq Boc Plình broq loh dìq khoe oe enh qneq ka kan cachìt lùch, ùh xài cla enh qmang aih mahaq enh Mangai ma broq loh ƀài yiniq aih. ");
INSERT INTO hrebt_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Rìm yiniq khoe jah broq loh aih hadai tangèh ka rađeh jah dèch claih khoe ka kan cachìt lùch, đoèq hu hanoh jah oe ta kan ranhòm ti kon Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Bèn loq rìm yiniq hadai toq hràng xalep trùh manòeq; ");
INSERT INTO hrebt_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ùh xài toq ƀài ngè khoe jah broq loh aih, mahaq xam ƀài bèn aih ƀài mangai ma i plì ramua da Yiang Hadròeh, hadai hràng ta manoh cliac, jò bèn qnang gòm đòeq hu jah broq kon ban, aih la kan baxon hlài chac hamac bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ta kan tangèh gòm kô raq bèn ma khoe jah dèch, jò wì khoe jah trong rađeh ma tangèh gòm, aih ma oe tangèh cleq hòm, bèn khoe jah hnoq aih oe tangèh gòm dèh hòm? ");
INSERT INTO hrebt_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Mahaq tàng bèn tangèh yiniq đeh qnhòq hnoq, aih ajoq bèn gòm qmòe rai àt, ");
INSERT INTO hrebt_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hadai qmang aih, Yiang Hadròeh wiang da bèn trong ma ùh nèn. Bèn ùh qnì ka rađeh ep bòch cleq đòeq waiq khàn ka hatroq, mahaq Yiang Hadròeh yŏc kan pi atêh hràng enh bèn đòeq hu waiq khàn am ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Mangai ma sreo ta manoh mangai loq ka manoh Yiang Hadroèh, aih la tiaq manoh Boc Plình enh haq ma waiq khàn am ka ƀài kon da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Bèn loq rìm yiniq Boc Plình ma broq aih dìq đoèq jah lòeq ka ƀài mangai loq waq ka haq, aih ƀài mangai haq ma khoe dì dèh adroe. ");
INSERT INTO hrebt_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Majah qmang aih, mangai haq ma khoe loq dèh adroe, haq khoe ta qmroq đoèq hu jah tìah ka Kon Haq, dôq Kon aih jah broq Kon ramua oe taqne oh daq; ");
INSERT INTO hrebt_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","mangai haq ma khoe ta qmroq dèh adroe, aih haq khoe creo, mangai haq khoe creo, aih haq khoe doe dèh mangai taq atoq, mangai haq khoe doe dèh taq atoq aih haq khoe broq dôq jah kan ranhòm. ");
INSERT INTO hrebt_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Khoe qmang aih bèn doe qmang leq? Tàng joq Boc Plình wiang ti bèn, oe i cabô hu tablêq ka bèn? ");
INSERT INTO hrebt_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Haq khoe ùh adênh dèh Kon cla, mahaq khoe am dŏng ka bèn, oe i cleq hòm haq ma ùh am hloe ka bèn ajang Kon aih? ");
INSERT INTO hrebt_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Cabô ma aràng kan tah hadrah ka mangai Boc Plình ma khoe ràih dèh? Boc Plình aih Mangai ma doe dèh wì aih jah kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Cabô ma taqmòq yiniq lui ka wì aih? Ùh i ka cabô. Chuaq Jesus Christ aih Mangai khoe cachìt, manoeq khoe rìh hlài, haq qnang haqngui enh qma Boc Plình đòeq waiq khàn ka bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Cabô jah lah bèn loh khoe kan loq waq da Christ? Kan mangò, kan nanxa, kan canàt rùp, pangot hrah, hyah hyai, kan yat, chang jaoq ùh xài? ");
INSERT INTO hrebt_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Qmang ka bàu khoe achìh: “Tiaq Ìh, nhèn glàm kan cachìt xèq ka hì, Wì ngan nhèn bu dàng trìu đoèq xah jam”. ");
INSERT INTO hrebt_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Mahaq ùh xài, ta rìm yiniq aih bèn canòm ka Mangai ma loq waq ka bènThi Tv 44:22, đòeq jah blêq yeo hnau ka aih hòm. ");
INSERT INTO hrebt_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Au cajap manoh rameh: Yac ka kan cachìt, kan rìh, yac ka ƀình plình, yac ka kiac dù, yac ka mangai i cwìang, yac ka manòeq, yac ka yiniq padon trùh ta bla èh, ");
INSERT INTO hrebt_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","kan haqnhèq kan jrùq, ùh i cleq jah lah bèn loh khoe ka kan loq waq Boc Plình khoe am ka bèn oe enh dalam ka Chuaq Jesus Christ, aih Chuaq da bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Enh dalam ka Christ, au ùh qnùt, manoh cliac au hadai wiang panhìn ka au xam Yiang Hadròeh: ");
INSERT INTO hrebt_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Au mangò pi cajaq, manoh au jò leq ma ùh jìq. ");
INSERT INTO hrebt_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Au khoe hmaq ngèh dôq au chìuq dìq kan wì git, dôq au kô dahlêh khoe ka Christ thai ka oh daq ma pajùm mahim jan ka au, ");
INSERT INTO hrebt_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","aih la mangai Isorali, aih ƀài mangai jah broq kon ban da Boc Plình, jah kan ranhòm, bàu tajao, ranenh, jah kùh waiq xam bàu khoe tèu am; ");
INSERT INTO hrebt_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","aih ƀài mangai ha-uang loh enh wì kan cadraq tiaq mahim jan aih raq nang noe ha-uang qnoh Christ, aih Mangai enh qnhèq dìq dŏng rìm ka yiniq, aih raq Boc Plình ma khòh manè apôi mòeq đòe Amen. ");
INSERT INTO hrebt_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Aih ùh xài bàu Boc Plình khoe loh ka qngwan qngwaiq. Majah qmang aih ùh xài mangai leq ha-uang loh enh nang noe Isorali aih dìq mangai Isorali. ");
INSERT INTO hrebt_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Èh ùh xài hi loh enh nang noe da Apraham aih dìq kon haq, mahaq i bàu achìh: “Enh Ysac aih èh ìh men i mòeq nang noe creo tiaq yiniq ìh”; ");
INSERT INTO hrebt_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","bàu aih rameh: Kon kaiq enh xech akia aih ùh xài kon Boc Plình, mahaq kon da bàu haq khoe tèu đòeq dèh adroe aih men joq kon da Apraham. ");
INSERT INTO hrebt_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kô raq bàu ma khoe chônh doe đoèq adroe: “Kô èh jah mòeq hanam, Au hi wìh hlài tacô, èh Sara hi i kon calô”. ");
INSERT INTO hrebt_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ma xài toq aih hi dìq, da Rêbeca hòm jò haq hadràp kon camia, kon da Ysac kan cadraq bèn, hanoh qmang aih. ");
INSERT INTO hrebt_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Majah qmang aih, jò wa kon qnhòq ha-uang loh, qnhòq i broq trong lem trong dù dôq hu jah cajap tiaq manoh Boc Plình ma khoe dì adroe tiaq manoh cla haq enh (ùh xài tiaq yiniq broq, mahaq tiaq manoh Mangai ma creo) ");
INSERT INTO hrebt_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","aih khoe i bàu doe ka miq wa kon qyoh: “Mangai ma daq ep broq hapŏng dèh oh”; ");
INSERT INTO hrebt_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","qmang ka bàu khoe achìh: “Au ha-och ka Jacôp, mahaq git ka Êsau”. ");
INSERT INTO hrebt_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Qmang aih bèn anoe qmang leq? Ahìaq i kan ùh taq atoq ta Boc Plình? Ùh i qmang aih! ");
INSERT INTO hrebt_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Majah qmang aih, haq doe ka Môise: “Au ha-och deh ka mangai au loq waq, Au ùh manaq deh ka mangai au ma ha-och”. ");
INSERT INTO hrebt_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Trong aih ma xài cabô hi tangèh hi àu hi jah, mahaq oe ajang kan loq waq da Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ta Hset Hadroèh hadai i doe ka Pharaôn: “Hagleq au majah khoe dèch paqnàng ìh, đoèq ajang aih hujah patô qnoh cwìang itai au, dôq yiniq au jah anoe jàp crŏng taneh”. ");
INSERT INTO hrebt_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Qmang aih, Haq ha-och deh ka mangai haq enh ha-och, enh broq cadoq manoh bô haq broq. ");
INSERT INTO hrebt_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Qmang aih ìh bòch au: Hagleq Boc Plình oe cwò dèh ka nhèn? Oe i cabô hlàt tablêq ka manoh haq enh qmòh?... ");
INSERT INTO hrebt_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Mahaq ìh qmat cabô, ìh ma hùa rahen ka Boc Plình? Abôq taneh wìa ka tarahen ka mangai broq loh abôq: “hagleq ìh majah broq loh au qmang kô? ");
INSERT INTO hrebt_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mangai thòq mŏt taneh ma ùh xài haq i cwìang yeo hnau ka taneh, hadai taneh aih qnah haq broq loh abôq lem đoèq hu tah hang canaq, qnah haq broq đòeq hu tah dahwèq hwòt hwat qmòh? ");
INSERT INTO hrebt_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Tàng joq Boc Plình enh am hnoq deh kan nòeh rai broq đòeq hnoq kan cwìang itai haq, mahaq haq àt deh manoh khoe dùnh am ka ƀài abôq ma troq toq ka nòeh troq ka raliang cađac, ");
INSERT INTO hrebt_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","haq broq qmang kô am ka ƀài abôq haq ma loq waq, haq ma khoe palauq đòeq ka wì jah hnoq kan padrŏng ranhòm da haq, aih bèn oe jah anoe tam cleq hòm? ");
INSERT INTO hrebt_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Aih au anoe trùh bèn, ƀài mangai haq khoe creo deh, ùh xài toq ta mangai Juđa, mahaq hloe xam ƀài mangai diac wì. ");
INSERT INTO hrebt_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Qmang ka haq anoe ta hset Ôse: “Mangai ùh xài da au, au creo deh mangai da au, Mangai au ùh ha-och, au doe deh mangai au ha-och;” ");
INSERT INTO hrebt_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Èh hòm, tanoè haq ma doe ka wì: “Pì ùh xài mangai da au, Hadai ta aih raq wì ma hi jah creo kon Boc Plình halình mòeq đòeq”. ");
INSERT INTO hrebt_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Da Êsai jò haq ràu trùh mangai Isorali, haq creo rai hmoe cadêh: “Yac ka mangai Isorali bàc tìah ka braih diac rasixq, mahaq toq rah ròp da haq majah dèch; ");
INSERT INTO hrebt_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","majah qmang aih Boc Plình haqnan ka broq dôq xìt rìm bàu haq ta crŏng taneh. ");
INSERT INTO hrebt_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Èh hòm Êsai khoe doe: “Tàng Boc Plình dìq jaq haqnhèq, ùh rong đoèq ka nang noe bèn mòeq toq hamŏng, Aih bèn hadai khoe tìah ka Sôđôm tìah ka Gômôro diq”. ");
INSERT INTO hrebt_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Aih èh bèn doe cleq hòm? Mangai diac wì ùh chaq kan taq atoq, aih khoe jah kan taq atoq, mahaq kan taq atoq loh enh manoh lùi; ");
INSERT INTO hrebt_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","mangai Isorali chaq ranenh da kan taq atoq, dìq khoe capòch ka ranenh aih. ");
INSERT INTO hrebt_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Hagleq? Taiq wì haq ùh chaq xi manoh lùi, mahaq chaq xi yiniq broq. Wì haq khoe catoeh ka hmo, ");
INSERT INTO hrebt_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","qmang ka bàu khoe achìh: “Kô! Au đòeq ta Siôn mòeq toq hmo, aih hmo kàn broq ka wì catoeh, mangai leq lùi haq, ùh hìaq ep camaih.");
INSERT INTO hrebt_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Wùih dìq ka oh daq, kan tangèh ta manoh au hloe xam bàu au waiq khàn ka Boc Plình, au waiq khàn deh ka oh daq au, aih la mangai Isorali đoèq dìq ka wì jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Au wiang capoch panhìn wì haq joq i manoh nhet joq qnàng trong da Boc Plình mahaq kan nhet aih ùh tiaq manoh rabiaq. ");
INSERT INTO hrebt_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Majah qmang aih, wì haq ùh canau kan taq atoq da Boc Plình wì haq àu chaq ònh đeh trong qnoeq đoèq broq ka rađeh jah taq atoq, ùh iu tiaq kan taq atoq da Boc Plình; ");
INSERT INTO hrebt_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","majah qmang aih, Christ aih kan atìq lùch da ranenh, đòeq dìq ka mangai lùi hujah kan taq atoq. ");
INSERT INTO hrebt_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Anoe trùh kan taq atoq loh enh ranenh, Môise achìh qmang kô: “Ƀài mangai leq ma broq tiaq trong aih, canòm dèh aih raq đoèq hujah rìh”. ");
INSERT INTO hrebt_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Mahaq kan taq atoq da manoh lùi, aih achìh rameh: “Manoh ìh apaq capoch qmang kô: Cabô ma tŏc ta Plình? Đòeq hu qnoh Christ loh; ");
INSERT INTO hrebt_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","tàng ùh aih: Cabô ma hu loh ta hwin jrùq đòeq hu dèch atŏc Christ enh kan cahìt”? ");
INSERT INTO hrebt_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Mahaq doe qmang leq? Bàu oe ten ka ìh, oe ta hacùng ìh, oe ta manoh ìh. Aih raq bàu da manoh lùi nhèn qnang anoe hnài. ");
INSERT INTO hrebt_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Qmang aih tàng joq hacùng ìh anoe qnoh Chuaq Jesus Christ, manoh ìh lùi Boc Plình khoe broq ka haq rìh hlài enh kan cachìt, aih èh ìh jah dèch; ");
INSERT INTO hrebt_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","majah qmang aih, lùi ta manoh aih jah kan taq atoq, mahaq anoe qnoh ajang hacùng bàu aih èh jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Qmang ka Hset Hadròeh anoe: “Mangai leq ma lùi haq, aih ùh hìaq xep. ");
INSERT INTO hrebt_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Majah qmang aih yac ka mangai Juđa yac ka mangai Gorec ùh i cleq crài ka dabau. Wì hanoh i pajùm mòeq Chuaq bình halùih xôq ramot ka mangai creo dang haq. ");
INSERT INTO hrebt_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Majah qmang aih, mangai leq creo dang yiniq Chuaq, aih hi jah dèch.” ");
INSERT INTO hrebt_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Mahaq, wì qnhòq lùi haq, aih wì creo dang qmang leq majah? Qnhòq lah i cabô anoe trùh haq aih broq qmang leq wì ma lùi? Èh broq qmang leq wì ma hìa tàng joq ùh i cabô lam doe ka wì? ");
INSERT INTO hrebt_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Mahaq tàng ùh i ka mangai ma khoe jah thê loh lam, aih èh hnài qmang leq? Tìah ka bàu ma khoe achìh: “Capiang jènh da ƀài mangai aràng Bàu lem, aih lem i jaq clceq”. ");
INSERT INTO hrebt_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Mahaq ùh xài rìm ngai dìq lùi Bàu lem, majah qmang aih Êsai khoe doe: “Waiq Chuaq! cabô ma lùi bàu nhèn anoe?” ");
INSERT INTO hrebt_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Qmang aih, manoh lùi trùh, jò wì hi jah tàng, wì jah tamàng jò bàu da Christ jah anoe hnài. ");
INSERT INTO hrebt_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Mahaq au bòch: Ahìaq wì qnhòq tàng? Majoq qnàng wì khoe tàng: “Bàu wì anoe khoe trùh rìm cròng, Bàu wì khoe jàp crŏng taneh”. ");
INSERT INTO hrebt_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Au bòch hòm: “Tàng qmang aih mangai Isorali ùh lòm qnì cleq qmòh? Môise khoe doe: “Au broq ka pì tagrình ka mangai diac wì; Au broq ka pì plôh nòeh ka mangai ùh qnì qmoè cleq”. ");
INSERT INTO hrebt_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Êsai khoe ùh yùq ka anoe: “Bài mangai ma ùh chaq au, aih khoe hnoq au, Au mahno rađeh ka mangai ma ùh lah bòch trùh au”. ");
INSERT INTO hrebt_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ràu trùh mangai Isorali aih haq doe: “Au khoe hnhu tì xèq ka hì tangèa ta nang noe ma cadoq manoh loq capoch gôpla”. ");
INSERT INTO hrebt_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","“Khoe aih au bòch hòm: Boc Plình i cađac dèh mangai da haq? Ùh i, majah qmang aih; au hadai mangai Isorali, kon xau Apraham, nang noe da Bênjamin. ");
INSERT INTO hrebt_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Boc Plình qnhòq hmaq cađac dèh mangai haq ma khoe loq deh adroe. Oh daq ma ùh qnì ajang noè Hset Hadròeh ma achìh trùh Êli? Jò haq àu bòch waq ka Boc Plình tabroq ka mangai Isorali, haq doe: ");
INSERT INTO hrebt_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Waiq Chuaq! wì khoe jêh đac dŏng da ìh pajàu, raliang caqnìh đac da ìh prang tadreo; oe mòeq ngai au raq, dua wì chaq jêh đac hloe”. ");
INSERT INTO hrebt_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Mahaq Boc Plình tèu qmang leq? “Au khoe padon đòeq ka rađeh tapèh mùan mangai gucalô ùh hacùn cràng enh ngèa ka Ba-an. ");
INSERT INTO hrebt_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Manòeq hadai, i mòeq qnah oe xrong hlài tiaq kan tabàih ma ràih dèh. ");
INSERT INTO hrebt_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Mahaq tàng joq hi tiaq kan tabàih dech aih pi tiaq trong yiniq broq hòm, ùh qmeh kan tabàih ma oe xài kan tabàih hòm? ");
INSERT INTO hrebt_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Aih qmang leq? Aih ìq mangai Isorali chaq ùh jah trong wì haq ma chaq, mahaq mangai majah ràih aih khoe jah, mangai ma qnoeq aih loh ka cadoq manoh, ");
INSERT INTO hrebt_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","qmang ka bàu ma khoe achìh: “Boc Plình khoe broq ka wì loh ka clam cluiq, Mat ùh xau hnoq, don ùh xau tàng, Trùh hloe manòeq”. ");
INSERT INTO hrebt_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Đawit hanoh doe: “Xoeq diq, yiniang yinàng da wì haq wìa jroh wìa hlàp, Wìa kan catoeh đòeq hu patem chau ka wì haq; ");
INSERT INTO hrebt_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Xoeq diq mat wì haq loh ka clam cluiq, dôq wì haq ùh xau hnoq, Crŏng wì haq kŏc hloe mòeq đòe”! ");
INSERT INTO hrebt_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Au bòch hòm: Mangai Isorali catoeh qmang aih ahìaq đòeq hu cro hloe ùh xài? Ùh xài qmang aih! Mahaq taiq yiniq lui wì haq kan dèch majah khoe trùh ka mangai diac wì, đoèq broq ka wì haq tagrình. ");
INSERT INTO hrebt_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Mahaq tàng yiniq lui wì haq khoe broq ka crŏng taneh jah kan padrŏng, kan capòch da wì haq khoe broq ka mangai diac wì jah padrŏng kan, loq ka kan padrŏng da wì haq! ");
INSERT INTO hrebt_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Au anoe ka pì oh daq mangai diac wì: Enh nèh trùh manòeq, au broq mangai Tiaq Cla am ka mangai diac wì, au àu broq dôq trong au ma patìh jah ranhòm, ");
INSERT INTO hrebt_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","đòeq ka manoh cliac oh daq mangai diac cla nhèn tajênh, dôq wì loq ran đeh diq, đòeq i đeh moeq qnah ngai ta wì haq jah dèch. ");
INSERT INTO hrebt_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Tàng joq kan hlêh đac da wì haq khoe broq ka phu cròng jah hatroq, aih èh jò wì haq wìh hlài ta kan tabàih dech, aih ma ùh xài rìh hlài enh kan cachìt qmòh? ");
INSERT INTO hrebt_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Tàng plì gàu mùa hadròeh, aih dìq ka đùng hanoh hadròeh, tàng riah haq hadroèh, aih dìq ka hanenh hanoh hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Tàng i mòeq baiq hamenh ma khoe sri đac, aih èh ìh qmat long ôliu gàng khoe jah srep qmùt ajang ƀài teu hamenh aih đòeq jah pajùm đeh ka jan, đeh ka riah da long ôliu, ");
INSERT INTO hrebt_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","apaq catèh rađeh kô yeo loe ka ƀài hamenh aih. Tàng joq loq enh catèh, ìh ep hèm qmang kô: Ùh xài ìh tagah lep ka riah, ma joq qnàng riah ma tagah lep ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Aih èh ìh hi doe: Ƀài hamenh qnoeq khoe sri đac đòeq ka au jah srep qmùt ajang teu ƀài aih. ");
INSERT INTO hrebt_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Joq qmang aih, ƀài hamenh aih khoe sri cađac taiq wì haq ùh lùi, ìh canòm ka manoh lùi majah keo oe, apaq catèh rađeh mahaq thê ìh loq iu yùq. ");
INSERT INTO hrebt_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Majah qmang aih tàng joq Boc Plình khoe ùh adênh ka ƀài hamenh cla long aih, aih èh haq hadai ùh i adênh cleq ka ìh. ");
INSERT INTO hrebt_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Qmang aih, ngan beq, ngan kan loq hanò xam kan ùh jah blìa da Boc Plình: Kan ùh jah blìa ka wì aih ƀài mangai khoe tacro, kan loq hanò am ka ìh, waq toq ìh loq wèq rađeh ta kan loq waq da haq, ùh meh ìh hadai ep sri cađac. ");
INSERT INTO hrebt_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Da wì aih, tàng wì ùh hìaq catàm yôt ta kan ùh lùi, aih èh wì hadai jah srep qmùt majah qmang aih Boc Plình i cwìang srep qmùt wì haq. ");
INSERT INTO hrebt_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Mahaq tàng ìh khoe jah pot enh long ôliu gàng đòeq hu srep qmùt talong ôliu lem, aih loq ka ƀài wì aih hamenh da cla long ma ùh jah srep qmùt ta xèm cla qmòh! ");
INSERT INTO hrebt_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Qmang aih, au ùh enh ka oh daq ùh qnì kan hlèp kô, yùq èh oh daq loq doe đeh kô rabiaq: Aih ìq, mòeq qnah raq mangai Isorali ma khoe loh ka cadoq manoh, gòm trùh jò leq mangai diac wì khoe jah qmùt dôq haq tôm òeq; ");
INSERT INTO hrebt_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","khoe aih èh dìq ka mangai Isorali hi jah dèch, qmang ka bàu khoe achìh: “Mangai paclaih loh enh Si-ôn, Dèch đac kan ngang dù loh khoe ka Jacôp; ");
INSERT INTO hrebt_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Aih kan tajao au broq ka wì, Jò au dèch cađac ka hangai yiniq lui wì haq”. ");
INSERT INTO hrebt_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Tàng hatùang trùh Bàu lem, wì aih khoe loh mangai tagit ka pì, mahaq tàng hatuàng trùh kan ràih enh plình wì haq aih raq mangai jah kan loq waq taiq ajang boc yaq, ");
INSERT INTO hrebt_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","majah qmang aih ƀài bìac Boc Plình ma am xam bàu creo da haq ùh jò leq tablòq. ");
INSERT INTO hrebt_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Qmang ka enh adroe nèh oh daq khoe ùh iu Boc Plình, yàng manòeq kô taiq kan ùh iu da wì aih oh daq ma khoe loh ka jah kan ha-och, ");
INSERT INTO hrebt_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","hanoh qmang aih, manòeq kô wì haq khoe ùh iu, đoèq hu hadai jah kan ha-och troeq kan ha-och khoe am da oh daq. ");
INSERT INTO hrebt_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Majah qmang aih, Boc Plình khoe clêh dìq dŏng ta kan ùh qnì iu đòeq hu ha-och dìq dŏng rìm ngai. ");
INSERT INTO hrebt_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Wùih! joq jrùq qnàng kan padrŏng, kan rabiaq, kan loq da Boc Plình! Kan hadrah da haq cabô ma hlàt tem, trong da haq cabô ma hlàt qnhro! ");
INSERT INTO hrebt_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Aleq i cabô loq ka manoh da Chuaq? Cabô ma khoe wiang hatình ti haq? ");
INSERT INTO hrebt_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Cabô khoe am ka haq cleq adroe đòeq hu jah haq padreo hlài? ");
INSERT INTO hrebt_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Majah qmang aih rìm yiniq dìq loh enh haq, canòm ka haq, tangèa dìq ta haq. Kan ranhòm mòeq đòe ùh lùch oe dìq dŏng ta haq! Amen. ");
INSERT INTO hrebt_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Qmang aih, au yŏc kan loq waq da Boc Plình, pariaq dìq ka pì oh daq dèch qmòe chac cla pì đòeq broq ramènh rìh, hadròeh lem ka manoh Boc Plình, aih raq kan kùh waiq ma troq da oh daq. ");
INSERT INTO hrebt_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Apaq top dua qnhòng kô, mahaq wìh wìa tiaq manoh oh daq ma khoe jah paneo, đòeq hujah qnhro loq trong lem manoh xam kan geo gùa da Boc Plình aih qmang leq cadèh. ");
INSERT INTO hrebt_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Qmang aih, tiaq kan tabàih dech ma khoe am ka au, au anoe ka tang ngai oh daq apaq hèm rađeh kô haqnhèq hrìn, mahaq ep i manoh hèm bu qnang lem tiaq maneh kan lùi Boc Plình ma khoe am ka tang ngai. ");
INSERT INTO hrebt_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Majah qmang aih, tìah ka mòeq toq chac raq mahaq ta aih i bàc yiniq, ƀài yiniq aih i deh hra trong abroq crài ka dabau; ");
INSERT INTO hrebt_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","hadai qmang aih, enh dalam ka Christ bèn kô bàc ngai mahaq khoe loh mòeq chac, ƀài bèn kô aih hamenh da dabau. ");
INSERT INTO hrebt_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Majah qmang aih bèn i ƀài kan tabàih crài ka dabau, tiaq kan tabàih dech khoe am ka tang ngai, mangai leq jah am tapoch pajàu, aih asràm tapoch hatiaq dèh manoh lùi; ");
INSERT INTO hrebt_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","cabô jah creo hu broq mangai patìh, aih ep kàt racop rađeh ti bìac patìh, cabô broq mangai hnài, aih ep hnài; ");
INSERT INTO hrebt_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","cabô broq mangai pariaq, aih pariaq, cabô broq mangai ti tabàih am, aih tabòeh am majoq qnàng haq, cabô broq mangai qnung ngoe, panim haq đòeq hu qnung ngoe, cabô broq mangai loq ha-och, drah lem bùi ka broq. ");
INSERT INTO hrebt_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Kan loq waq ep ma joq qnàng haq. Ep git ka trong dù bêh trong lem. ");
INSERT INTO hrebt_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Drah yŏc kan loq waq laq alàng đòeq ha-och ka dabau tìah ka oh daq, ngan wì qnoeq ùh hnau ka cla rađeh. ");
INSERT INTO hrebt_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Drah panim apaq aroh, ep i manoh loq nhet: ep patìh ka Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Drah loq bùi ta kan tangèh, loq àt ta kan nanxa, cajap manoh đòeq hu waiq khàn. ");
INSERT INTO hrebt_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Drah lah axong dahwèq am ka mangai da Boc Plình jò wì haq i đeh yiniq nhet ka waq, dìq ka manoh loq đìh tamoe; ");
INSERT INTO hrebt_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","waiq am xôq ramot ka mangai rùp oh daq, waiq am xôq ramot ùh dùh hanip. ");
INSERT INTO hrebt_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Wiang lem bùi ti mangai lem bùi, crò ti mangai crò. ");
INSERT INTO hrebt_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Oh daq ep acaq oe ma hatroq ti dabau, apaq enh toq ka rahù rahòm, mahaq loq haqmuan rađeh. Apaq doe đeh rabiaq. ");
INSERT INTO hrebt_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Apaq yŏc kan dù đòeq hu patem chau ka cabô, mahaq enh ngèa rìm ngai, ep hèm ngan trong leq malem. ");
INSERT INTO hrebt_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Tàng jah, yŏc dìq dèh ka padren hiwa đòeq àu hatroq ka rìm ngai. ");
INSERT INTO hrebt_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Yôi yôiq oh daq da au, cla pì apaq patem chau ka cabô, mahaq dôq daiq ka kan nòeh da Boc Plình, majah qmang aih i bàu khoe achìh: “Kan patem chau aih oe ta au, i au tabroq chau.” ");
INSERT INTO hrebt_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Qmang aih tàng joq mangai tagit ka pì haq hrah, qmi haq acaq, tàng joq haq croh ranŏng, drah am haq ôq, broq qmang aih tìah ka pì tah ngia ùnh tagàu wì”. ");
INSERT INTO hrebt_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Apaq dôq trong dù blêq pì, mahaq dôq trong lem blêq trong dù. ");
INSERT INTO hrebt_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Rìm ngai ep iu tiaq mangai wèq cwìang enh qnhèq ka rađeh, majah qmang aih ùh i ka cwìang leq ma ùh trùh enh Boc Plình, ƀài cwìang aih dìq Boc Plình thê. ");
INSERT INTO hrebt_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Qmang aih, cabô taƀlêq hlài ka mangai wèq cwìang, aih haq taƀlêq hlài ka bàu Boc Plình khoe thê, mangai taƀlêq qmang aih haq taqmac yŏc ka rađeh kan hadrah. ");
INSERT INTO hrebt_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Majah qmang aih, mangai wèq cwìang ùh xài dôq ka mangai broq lem crè mahaq đòeq ka mangai broq dù crè. Ìh ngèh ka ùh hìaq ep yùq crè ka mangai i cwìang ajoq? Aih drah broq trong lem beq đòeq hujah wì haq manè baha ìh; ");
INSERT INTO hrebt_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","majah qmang aih wì haq aih hapŏng Boc Plình đòeq i lòeq ka pì. Mahaq tàng ìh broq trong qmèq, aih khòh lèt, majah qmang aih mangai wê chang ùh lah wê waiq ùh i ka yiniq, wì haq aih ranac da Boc Plình đòeq hadrah mangai broq dù. ");
INSERT INTO hrebt_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Aih ìq dài majah ep iu, ùh xài crè toq ka loq phŏc hi hêq, mahaq hadai taiq deh manoh cliac. ");
INSERT INTO hrebt_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Aih ìq raq oh daq majah ep caqnaih thèq, majah qmang aih mangai wèq cwìang aih hapŏng Boc Plình đòeq hu broq trong kô. ");
INSERT INTO hrebt_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ep caqnaih da rìm ngai dòeh oh daq ma khoe pòq: Caqnaih thèq ka mangai ìh ep thèq, wiang tagop ka mangai khòh wiang gop, crè ka mangai khòh crè, ta iu ka mangai khòh ta iu. ");
INSERT INTO hrebt_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Apaq pòq dòeh bô yac ka yiniq cleq, enh gùng kan loq waq ka dabau, majah qmang aih cabô loq waq dèh ka mangai ma haten hatìa aih haq khoe broq gêh ranenh. ");
INSERT INTO hrebt_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Hacô ƀài ranenh aih qmang kô: Ìh apaq tango, apaq jêh đac mangai, apaq atùng, apaq daiq plai hloe xam ƀài ranenh qnoeq, yac ka ranenh leq dìq yùp ta mòeq bàu kô: Ìh ep loq waq ka mangai haten hatìa tìah ka cla ìh. ");
INSERT INTO hrebt_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Kan loq waq ùh broq habo ka mangai ten tìa. Qmang aih kan loq waq broq gêh geo ranenh. ");
INSERT INTO hrebt_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Drah acaq oe qmang aih, majah qmang aih bèn loq manòeq: Khoe ten trùh jò, oh daq ma kùi rìu beq, majah qmang aih kan dèch da bèn trùh khoe ten, ùh hnau ka jò bèn ma baxèm lùi. ");
INSERT INTO hrebt_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Mang khoe jrùq, hì khoe ten trùh, qmang aih bèn drah lêh cađac ƀài yiniq broq da kan clam cluiq đòeq hu taqmac wê ranac da kan qngah qngai. ");
INSERT INTO hrebt_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Drah cadiang lam ma qnhrang qmang ka dahì. Apaq dôq rađeh tacro catàm ta kan ôq bù haqnhròch, talìq talàn xam kan tajênh; ");
INSERT INTO hrebt_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","mahaq caxùnh yŏc Chuaq Jesus Christ rai apaq hèm đòeq chaq trong hu patìh ƀài bìac xech akia ma rahènh. XuXh 20:13-17 PhuDnl 5:17-21 ");
INSERT INTO hrebt_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Drah lem manoh đòeq hu đìh wì oh daq manoh lùi ma yeo hamoq đeh, ùh dùh rahen dèh trong haq ma qnhòq dai lùi. ");
INSERT INTO hrebt_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Mangai kô lùi rìm yiniq dìq khòh acaq, mangai manoh lùi ma yeo ƀiaq tau acaq đeh toq cachiq. ");
INSERT INTO hrebt_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Mangai acaq apaq jù dèh ka mangai ùh acaq, mangai ùh acaq apaq ti hadrah dèh ka mangai ma acaq, majah qmang aih Boc Plình khoe đìh yŏc dèh haq. ");
INSERT INTO hrebt_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ìh qmat ìq cabô gleq ma hùa hadrah hapŏng da mangai qnoeq? Haq yòng qnì haq cro qnì aih mac da cla craq haq mahaq haq yòng, majah qmang aih Chuaq i cwìang am ka haq qnhrang. ");
INSERT INTO hrebt_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Managai kô hèm hi kô ùh hnau ka hì qnoeq, mangai tau hèm yac ka hì leq hanoh daq adàng, mangai leq mangai meh lùi cajap dèh ta gàu ngoc. ");
INSERT INTO hrebt_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Mangai ma wèq hì aih, dài Chuaq haq majah wèq, mangai ma acaq aih dài Chuaq haq men acaq, majah qmang aih wì haq manè apôi Boc Plình, mangai ma ùh acaq aih hanoh dài Chuaq wì haq majah ùh acaq, wì haq hanoh manè apôi Boc Plình. ");
INSERT INTO hrebt_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Majah qmang aih taqne bèn kô ùh i mangai leq rìh toq ka rađeh, èh hòm taqne bèn hanoh ùh i mangai leq ma cachìt ka rađeh, ");
INSERT INTO hrebt_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","tàng bèn rìh aih rìh ka Chuaq, tàng bèn cachìt aih cachìt ka Chuaq. Qmang aih yac ka bèn rìh yac ka bèn cachìt, aih dìq ta Chuaq. ");
INSERT INTO hrebt_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Christ khoe cachìt mahaq khoe rìh hlài aih đòeq hu broq Chuaq da mangai cachìt xam mangai rìh. ");
INSERT INTO hrebt_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Mahaq gleq ìh majah hadrah dèh oh daq? Da ìh hòm, hagleq ìh loq jù đac dèh oh daq? Majah qmang aih, bèn kô èh dìq ep yòng enh ngèa ka gèq Boc Plình haqngui hadrah bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Majah qmang aih i bàu khoe achìh rameh: “Chuaq doe: Joq qnàng troeq au kô rìh halình, rìm toq cràng dìq ep hacùn enh ngèa au, rìm toq rapet jah manè apôi Boc Plình”. ");
INSERT INTO hrebt_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Aih èh, ajang ngèa Boc Plình bèn dìq ep taqmon hlài rìm yiniq bèn ma khoe broq. ");
INSERT INTO hrebt_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Qmang aih bèn pi dùh ti hadrah dèh ka dabau, yac ka qmang leq dua bèn ùh roh hmo ti qngèa oh daq, ùh broq ka wì haq tacro. ");
INSERT INTO hrebt_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Au loq rai lùi joq qnàng ta Chuaq Jesus ùh i cleq ma ùh hruah, toq rameh raq cabô hèm dahwèq kô ùh hruah aih haq ùh hruah toq ka mangai aih. ");
INSERT INTO hrebt_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Tàng joq mòeq dahwèq acaq ìh broq ka oh daq ep mangò, qmang aih ìh pi oe broq tiaq kan loq waq hòm. Ùh dùh đòeq dahwèq acaq da ìh broq raliang đac mangai Christ ma khoe cachìt am. ");
INSERT INTO hrebt_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Qmang aih apaq dôq i yiniq cleq ìh loq haq lem mahaq loh nen đòeq ka wì capoch qmèq. ");
INSERT INTO hrebt_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Majah qmang aih diac Boc Plình aih ùh xài ajang nòe acaq ôq mahaq ajang kan taq atoq, catèm, lem bùi trùh enh Yiang Hadròeh. ");
INSERT INTO hrebt_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Mangai leq tiaq trong aih đòeq patìh ka Christ aih jah lem manoh Boc Plình, jah wì manè. ");
INSERT INTO hrebt_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Qmang aih, bèn drah chaq trong broq qmang leq hujah hatroq ti dabau ma đòeq broq dua qngah ka dabau. ");
INSERT INTO hrebt_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Ùh dùh đòeq trong acaq raliang đac bìac Boc Plình ma broq. Rìm dahwèq acaq aih dìq hruah, bèn acaq mahaq broq ka mangai qnoeq catoeh ataq, aih raq kan dù. ");
INSERT INTO hrebt_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ma yeo lem, aih ùh acaq jam, ùh ôq alac rai ùh broq qmòe cleq dôq ka oh daq bèn catoeh cro. ");
INSERT INTO hrebt_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ƀài trong kô, ìh i dèh manoh lùi pang leq, ìh wèq ka rađeh pang aih enh ngèa ka Boc Plình. Xôq ramot ka mangai leq ma ùh taqmac yiniq lui ka rađeh tiaq trong cla haq ma khoe dì dèh. ");
INSERT INTO hrebt_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Mahaq mangai leq oe raq i manoh qnhòq dai tùt ka dahwèq đeh ma acaq aih haq khoe taqmòq ka rađeh yiniq lui, majah qmang aih haq ùh acaq tiaq manoh lùi, yac ka broq cleq mahaq ùh tiaq manoh lùi aih raq yiniq lui. ");
INSERT INTO hrebt_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Qmang aih bèn mangai ma tadêh, ep wiang pòq blòh kan trap ka mangai ma ùh i đeh ka padren, apaq broq waq ka lem toq ka manoh deh cla. ");
INSERT INTO hrebt_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Rìm ngai bèn ep broq lem manoh ka mangai haten hatìa bèn, đoèq i loèq ka wì hu broq dua lem ka wì. ");
INSERT INTO hrebt_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Majah qmang aih, yac ka Christ hadai ùh broq lem toq manoh dèh cla, qmang ka bàu khoe achìh: “Bàu ƀài mangai capoch qmèq khoe ta ùc enh qnhèq ta chac au”. ");
INSERT INTO hrebt_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Majah qmang aih, rìm yiniq enh nèh khoe achìh hlài đòeq hnài bèn, dôq enh kan loq àt xam kan alòng da Hset Hadròeh hnài, bèn jah i kan tangèh. ");
INSERT INTO hrebt_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Waiq Boc Plình aih xèm da kan loq àt xam kan alòng am ka oh daq jah mòeq manoh oe ti dabau qmang ka Chuaq Jesus Christ. ");
INSERT INTO hrebt_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Đòeq ka oh daq jah mòeq manoh mòeq bàu ti dabau hu manè apôi Boc Plình, aih Baq da Chuaq Jesus Christ bèn. ");
INSERT INTO hrebt_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Qmang aih, oh daq drah đìh dabau, qmang ka Christ khoe 