﻿USE sofia;
DROP TABLE IF EXISTS sofia.hre_vpl;
CREATE TABLE hre_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hre_vpl WRITE;
INSERT INTO hre_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Baxèm Boc Plình broq plình crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Jò aih crŏng taneh ùh i ca 'mù wa rahùang. Can clam chê gahnàp diac jrùq. Yiang da Boc Plình tabròc enh 'nhèq ca riang diac. ");
INSERT INTO hre_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Boc Plình doi: “Phai i can 'ngah,” èh i can 'ngah. ");
INSERT INTO hre_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Boc Plình hnoq can 'ngah aih lem lình, hi khoi Haq lah can 'ngah wa clam. ");
INSERT INTO hre_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Boc Plình hiniq can 'ngah aih “dahì,” can clam Haq hiniq “damang.” Èh i daxèq wa daxroq, aih hì mòiq. ");
INSERT INTO hre_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Èh Boc Plình doi: “Phai i hagan dech ŏi ta'ne diac đòiq lah axong diac enh 'nhèq wa diac enh 'neq.” ");
INSERT INTO hre_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Haq broq loh mòiq hagan dech đòiq lah diac ŏi enh 'neq ca hagan dech wa diac ŏi enh 'nhèq ca hagan dech, èh i 'màng aih. ");
INSERT INTO hre_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Boc Plình hiniq ca hagan dech aih, “plình.” Èh i daxèq wa daxroq, aih hì baiq. ");
INSERT INTO hre_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Èh Boc Plình doi: “Diac ŏi enh 'neq ca plình phai tagop ŏi mòiq nòi, wa taneh croh phai 'noh loh.” Èh i 'màng aih. ");
INSERT INTO hre_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Boc Plình hiniq ca nòi croh aih “taneh,” wa nòi diac ma tagop, aih “raxìq.” Boc Plình hnoq bìac aih lem lình. ");
INSERT INTO hre_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Boc Plình doi: “Taneh phai hon nhat, hon long loh adrech tiaq dèh adrech, hon long ta taneh ma loh plì tiaq dèh adrech.” Èh i 'màng aih. ");
INSERT INTO hre_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Taneh hon nhat, hon long i adrech tiaq dèh adrech, hon long loh plì tiaq dèh adrech. Boc Plình hnoq bìac aih lem lình. ");
INSERT INTO hre_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Èh i daxèq wa daxroq, aih hì piq. ");
INSERT INTO hre_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Boc Plình hi doi: “Phai i mat 'ngah ta hagan dech ŏi ta plình đòiq hadro dahì wa damang, đòiq broq teo wa patô jò padrang wa jò prò, hì wa hanam, ");
INSERT INTO hre_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","hadai phai broq mat 'ngah ta hagan dech ŏi ta plình đòiq xreo ta crŏng taneh.” Èh i 'màng aih. ");
INSERT INTO hre_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Boc Plình hi broq loh baiq toq can 'ngah càn: Mat 'ngah yi càn wèq cwìang nahì wa mat 'ngah yi 'yoh wèq cwìang damang. Haq hadai broq loh dìq ca halŏng. ");
INSERT INTO hre_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Boc Plình đòiq 'bài can 'ngah aih ta hagan dech ta plình waq ca xreo ta crŏng taneh, ");
INSERT INTO hre_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","đòiq wèq cwìang dahì wa damang đòiq axong can 'ngah wa can clam. Boc Plình hnoq bìac aih lem lình. ");
INSERT INTO hre_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","'Màng aih i daxroq wa daxèq, aih hì pôn. ");
INSERT INTO hre_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Boc Plình doi: “Phai i bàc dìq jaq ngè rìh ta diac, wa 'bài chìm pan enh 'nhèq ca taneh ŏi ta hagan dech ta plình.” ");
INSERT INTO hre_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Boc Plình broq loh bàc ngè càn dìq jaq rìh ta diac raxìq, bàc hiniq ca crài ca dabau tiaq dèh adrech bình halùih rìh ta diac, wa rìm hiniq chìm tiaq dèh adrech. Boc Plình hnoq bìac aih lem lình. ");
INSERT INTO hre_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Boc Plình 'noh am xôq ramŏt ca 'bài ngè aih, doi: “Phai xa-ông tam ma bàc đòiq jah bình halùih ta diac raxìq, wa 'bài chìm hadai xêh ma bàc ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","'Màng aih i daxèq wa daxroq, aih hì padam. ");
INSERT INTO hre_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Boc Plình doi: “Taneh phai xa-ông rìm ngè rìh tiaq dèh adrech: ngè aban tiaq dèh adrech, dìq rìm ngè 'yêh wa 'bài ngè rôm tiaq dèh adrech.” Èh i 'màng aih. ");
INSERT INTO hre_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Boc Plình broq loh 'bài ngè rôm tiaq dèh adrech, ngè aban tiaq dèh adrech, ngè 'yêh rìh moq ta taneh tiaq dèh adrech. Boc Plình hnoq bìac aih lem lình. ");
INSERT INTO hre_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Boc Plình doi: “Nhèn phai broq loh con mangai tiaq 'mù da Nhèn, tìah ca Nhèn. Wì phai wèq cwìang ca ta diac raxìq, chìm ŏi ta plình, 'bài ngè aban, dìq rìm ngè rìh ta crŏng taneh, wa rìm ngè 'yêh ma moq jàp jìa ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Boc Plình broq loh con mangai tìah ca 'mù Haq, tiaq dua 'mù Boc Plình, Haq broq loh con mangai. Haq broq loh con calô wa con cadrì. ");
INSERT INTO hre_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Boc Plình 'noh am xôq ramŏt ca con mangai, doi: “Phai xa-ông tam ma bàc đòiq jah bình halùih ta crŏng taneh. Phai wèq cwìang crŏng taneh, ca ta diac raxìq, chìm ŏi ta plình, wa dìq ngè ma rìh ŏi ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Boc Plình doi: “Au khoi am ca chôp rìm adrech nhat wa long i clong hon jàp jìa ta crŏng taneh, wa rìm long loh plì i clong wìa broq adrech. Aih dahwèq caq am ca chôp. ");
INSERT INTO hre_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Au hadai am ca ngè rôm, wa 'bài ngè ma 'noiq, chìm ta plình, wa dìq ca 'bài ngè ma rìh ta crŏng taneh, nhat xenh đòiq broq dahwèq caq.” Èh i 'màng aih. ");
INSERT INTO hre_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Boc Plình hnoq dìq rìm bìac Haq khoi broq joq lem lình dìq ca jaq. 'Màng aih i daxèq wa daxroq, aih hì tadràu. ");
INSERT INTO hre_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","'Màng aih plình, crŏng taneh wa dìq ca bìac ta aih broq khoi gêh. ");
INSERT INTO hre_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Trùh hì tapèh Boc Plình khoi broq gêh dìq ca bìac Haq broq. Hì tapèh Haq padài. ");
INSERT INTO hre_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Boc Plình am xôq ramŏt ca hì tapèh wa broq hì aih wìa hì hadròih, ma jah 'màng aih hì aih Haq padài taiq dìq ca bìac Haq broq loh khoi gêh. ");
INSERT INTO hre_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Cô raq bàu achìh hlài bìac plình wa crŏng taneh broq loh ta hì Chuaq, Boc Plình broq loh crŏng taneh wa plình. ");
INSERT INTO hre_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Jò aih 'nhòq i rôm loq long leq ta taneh, hadai 'nhòq i xèm nhat leq ta đùng taneh ma jah 'màng aih Chuaq, Boc Plình 'nhòq am mè 'noh ta crŏng taneh, wa 'nhòq i mangai abèq achap taneh. ");
INSERT INTO hre_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mahaq i hòi diac enh taneh tŏc pùc jàp taneh. ");
INSERT INTO hre_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Chuaq, Boc Plình yŏc blo taneh broq loh mangai calô, hlôi hòi hihèm 'mùt ta mùh, èh haq i can rìh. ");
INSERT INTO hre_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Chuaq, Boc Plình broq mòiq toq wùan ŏi pah mat mahì loh, hiniq wùan aih Êđen, èh Haq đòiq ta aih mangai calô Haq ma broq loh. ");
INSERT INTO hre_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Chuaq, Boc Plình thê taneh hon tŏc bàc long lem ca mat hnoq, plì haq caq jìang. Ta'ne wùan i Long Can Rìh, wa Long Canao Loq Bìac Lem wa Bìac Dù. ");
INSERT INTO hre_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","I mòiq toq cròng diac loh enh wùan Êđen đòiq pùc wùan. Enh nòi aih, haq axong loh pôn hamenh cròng diac. ");
INSERT INTO hre_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Hiniq hamenh baxèm, aih Pisôn. Hamenh aih cadàu wawenh jàp gùng Ha-wi-la, nòi i wang. ");
INSERT INTO hre_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Wang ta gùng aih lem dìq jaq. Hadai i jan xua thùm wa hmu ngŏc gam. ");
INSERT INTO hre_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Hiniq hamenh ma baiq, aih Ghihôn cadàu wawenh jàp gùng Cut. ");
INSERT INTO hre_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Hiniq hamenh ma piq, aih Tigrit cadàu pah mat mahì loh ta gùng A-si-ri. Hiniq hamenh pôn, aih U-phra-tê. ");
INSERT INTO hre_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Chuaq, Boc Plình 'ràng mangai calô ta wùan Êđen đòiq abèq rai wèq wùan. ");
INSERT INTO hre_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Chuaq, Boc Plình thê mangai aih: “Ìh jah caq dìq ca plì long ta wùan, ");
INSERT INTO hre_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mahaq plì ta Long Canao Loq Bìac Lem wa Bìac Dù, apaq caq, ma jah 'màng aih hì leq ma ìh caq plì aih, ìh joq 'nàng cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Chuaq, Boc Plình doi: “Mangai calô aih ŏi mòiq ngai, ùh lem. Au broq loh mòiq ngai tìah ca haq wa bu troq ca haq đòiq jùp đò haq.” ");
INSERT INTO hre_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Chuaq, Boc Plình yŏc taneh broq loh rìm ngè rôm, wa rìm adrech chìm ta plình, èh 'ràng wì ca Ađam đòiq ngan haq hiniq wì 'màng leq, èh hiniq cleq Ađam am ca tàng ngè rìh, aih raq hiniq haq. ");
INSERT INTO hre_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ađam hiniq dìq dŏng rìm ngè ma ban, 'bài chìm ta plình wa dìq ca ngè rôm. Mahaq cla Ađam, èh chaq ùh i mòiq ngai leq bu troq ca haq đòiq jùp đò haq. ");
INSERT INTO hre_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","'Màng aih, Chuaq, Boc Plình broq ca Ađam cùi hnia. Jò haq cùi hnia, Boc Plình yŏc mòiq hadrang caxènh himìa haq, èh baxìa hlài xech akia. ");
INSERT INTO hre_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Chuaq, Boc Plình yŏc caxènh himìa da Ađam, broq loh mòiq ngai gu cadrì 'ràng trùh ca Ađam. ");
INSERT INTO hre_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ađam doi: “Caxènh cô enh caxènh au, xech cô enh xech au. Jah creo haq ‘mangai cadrì,’ ma jah 'màng aih haq khoi jah yŏc loh enh mangai calô.” ");
INSERT INTO hre_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Taiq 'màng aih, mangai calô phai loh dèh enh miq baq, èh pajùm mòiq dèh ti mai, 'màng aih wa baiq ngai jah broq mòiq. ");
INSERT INTO hre_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ađam wa mai haq, wa baiq ngai rahòng, mahaq ùh hìaq loq camaih. ");
INSERT INTO hre_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ta dìq ca ngè rôm ma Chuaq, Boc Plình broq loh, bìh gô pla yi hnao dìq dŏng. Bìh doi ca mangai cadrì: “I joq Boc Plình doi ca ìh, ‘Ùh jah caq rìm plì long ta wùan cô ùh’?” ");
INSERT INTO hre_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mangai cadrì tèu haq: “Ma jah caq dìq ca plì long ta wùan, ");
INSERT INTO hre_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","mahaq toq mòiq toq long ma hon ta'ne wùan, Boc Plình i doi: ‘Chôp ùh jah caq, hadai ùh jah bèq, tàng ùh iu tiaq, èh chôp cachìt.’ ” ");
INSERT INTO hre_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Bìh doi ca mangai cadrì: “Chôp joq 'nàng ùh cachìt! ");
INSERT INTO hre_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mahaq Boc Plình loq, tàng chôp caq plì long 'mat, mat chôp jah tapèh, jah wìa tìah dàng Boc Plình, jah canao loq bìac lem wa bìac dù.” ");
INSERT INTO hre_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Jò mangai cadrì hnoq plì da long jìang caq, ngan lem wa jah broq ca dađeh wìa khôn rabiaq, haq gich plì caq, hi khoi hadai am dèh ca ŏng ma yòng ŏi ti haq, èh ŏng haq caq dìq. ");
INSERT INTO hre_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Jò aih, mat wa baiq ngai jah tapèh, loq dađeh ŏi rahòng. Wa haq yŏc hla pŏc broq capen cabàn dèh chac. ");
INSERT INTO hre_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Trùh chìu hì hangèp, jò wa haq tàng atêh cadiang da Chuaq, Boc Plình lam pagat wùan, Ađam wa mai haq amot ta'ne xèm long ta wùan đòiq hlèp ca Chuaq, Boc Plình 'nang ŏi. ");
INSERT INTO hre_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Chuaq, Boc Plình creo ca Ađam, bòch: “Ađam, ìh ŏi ta leq?” ");
INSERT INTO hre_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ađam tèu Haq: “Au i tàng bàu da Chuaq ta wùan, èh au yùq taiq au rahòng, 'màng aih au amot.” ");
INSERT INTO hre_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Boc Plình bòch: “Cabô ma patô ca ìh loq ca dađeh ŏi rahòng? Ìh i caq plì Au ma khoi thê ùh khòh caq aih ùh?” ");
INSERT INTO hre_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ađam tèu Haq: “Mangai cadrì ma Ìh khoi am đòiq ŏi ti au, haq am ca au plì long aih, èh au caq.” ");
INSERT INTO hre_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Chuaq, Boc Plình doi ca mangai cadrì: “Ìh khoi broq cleq cô?” Mangai cadrì tèu: “Bìh khoi padô 'nùt au, 'màng aih au caq plì.” ");
INSERT INTO hre_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Chuaq, Boc Plình doi ca bìh: “Taiq gè khoi broq bìac 'màng aih, gè raq khoi 'bìq waiq hanip yi hnao dìq ca ngè aban wa ngè rôm. Gè ep moq xam cliac wa caq blo taneh lùch ca 'nhòng rìh. ");
INSERT INTO hre_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Au broq gè wa mangai cadrì tagit ca dabau, aih hadròng hadrech gè wa Hadròng Hadrech mangai cadrì tagit ca dabau. Mangai aih èh jôiq gàu gè, gè cap lùnh jènh Haq.” ");
INSERT INTO hre_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Boc Plình doi ca mangai cadrì: “Au am tam bìac tagah lep yi hnao jò ìh ŏi jiang, jò ìh xa-ông con hadai jìq xalep. 'Nhac ca ìh i manoh enh wèq cwìang dèh ŏng, xôq haq wèq cwìang ìh.” ");
INSERT INTO hre_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Haq doi ca Ađam: “Taiq ìh khoi tamàng bàu mai, hi caq plì long Au khoi tanap ùh jah caq, 'màng aih taneh 'bìq waiq hanip taiq ìh. “Lùch ca 'nhòng rìh ìh phai chìuq xalep abèq achap taneh men i dahwèq caq. ");
INSERT INTO hre_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Taneh èh hon bàc hiniq hila, mahaq ìh xôq chaq caq cachiq yŏc enh đùng. ");
INSERT INTO hre_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ìh phai abèq loh pa-ùh ngòng men i dahwèq caq, trùh jò ìh wìh hlài wìa taneh, ma jah 'màng aih ìh wìa enh blo taneh, èh wìh hlài wìa blo taneh.” ");
INSERT INTO hre_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ađam hiniq dèh ca mai Êwa, taiq haq miq dìq dŏng ca con mangai. ");
INSERT INTO hre_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Chuaq, Boc Plình yŏc akia ngè aban broq eo yôh caxùnh am ca wa ŏng mai. ");
INSERT INTO hre_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Chuaq, Boc Plình doi: “Cô, con mangai khoi wìa tìah ca bèn dìq, loq hadro bìac lem wa bìac dù. Manàiq cô ep ngan kenh oq yùq wa haq loq dèch tì kech caq plì ta Long Can Rìh, èh wa haq jah rìh hloi hloi 'mòh.” ");
INSERT INTO hre_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Taiq 'màng aih, Chuaq, Boc Plình hnan Ađam loh khoi ca wùan Êđen đòiq abèq taneh, cla taneh aih ma khoi yŏc đòiq broq loh haq. ");
INSERT INTO hre_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","'Màng aih Haq hnan con mangai loh khoi ca wùan. Ŏi pah mat mahì loh ca wùan Êđen, Haq thê 'bài chê-ru-bim wê pla chang gùm ca-ah camla tawìh cô tau đòiq wèq trong lam trùh Long Can Rìh. ");
INSERT INTO hre_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ađam caq ŏi dèh ti mai Êwa, èh mai haq hadràp wa xa-ông Cain. Êwa doi: “Nhò Chuaq jùp đò, au khoi jah xa-ông ca mòiq ngai calô.” ");
INSERT INTO hre_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Êwa xa-ông hòm Abên, oh Cain. Abên broq bìac ban trìu, mahaq Cain broq bìac abèq taneh. ");
INSERT INTO hre_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Atìq cô èh Cain yŏc 'ràng dahwèq abroq enh đùng taneh broq ngè tadreo am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abên hadai yŏc 'ràng trìu ramua wa ramaq am ca Chuaq. Chuaq ngan hnoq Abên wa nhàn ngè tadreo da haq, ");
INSERT INTO hre_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","mahaq Haq ùh ngan trùh Cain wa ùh nhàn ngè tadreo da haq. Cain nòih dìq jaq, nhinh mùh mat wa loh mango dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Chuaq bòch Cain: “Gleq ìh ma nòih? Gleq ìh ma nhinh mùh mat? ");
INSERT INTO hre_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tàng ìh broq bìac troq, ajoq mùh mat ìh jah catèm 'mòh? Mahaq tàng ìh broq bìac ùh troq, tôiq lôi gòm ìh aradua 'mang, wa loq rahènh ca ìh dìq jaq, mahaq ìh phai wèq cwìang haq.” ");
INSERT INTO hre_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cain adràc Abên oh haq loh ta đùng. Jò wa baiq ngai ŏi ta đùng, Cain clŏng tùh jêh đac Abên oh haq. ");
INSERT INTO hre_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Chuaq bòch Cain: “Abên oh ìh ta leq?” Haq tèu: “Au ùh 'nì. Au mangai wèq dèh oh 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Chuaq bòch: “Ìh khoi broq bìac cleq? Bàu da mahem oh ìh enh taneh 'nang hmoi trùh Au! ");
INSERT INTO hre_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Manàiq cô ìh jah 'bìq taneh waiq hanip, taneh ma khoi hah hacùng trôt mahem oh ìh taiq bìac tì cla ìh ùc loh. ");
INSERT INTO hre_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Jò ìh abèq taneh, taneh pi hon ca ìh dahwèq caq hòm. Ìh pi jah ŏi mòiq nòi, mahaq ep lam hloi hloi enh nòi cô trùh nòi tau jàp ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cain doi ca Chuaq: “Baxa 'màng aih trap hrìn ca au pòq ùh hrŏng. ");
INSERT INTO hre_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Joq 'nàng Ìh khoi hnan au loh khoi ca taneh cô. Au lam hloi hloi enh nòi cô trùh nòi tau wia hangai ca mat Chuaq. Tàng i mangai leq glàm au, èh wì jêh cađac au.” ");
INSERT INTO hre_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Chuaq doi: “Taiq 'màng aih, tàng i mangai leq jêh Cain, mangai aih ep chìuq tabroq hlài tapèh yàng ma Cain chìuq baxa.” Chuaq broq teo ta chac Cain waq ca mangai leq glàm haq, wì ùh hìaq jêh haq. ");
INSERT INTO hre_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Cain wia hangai ca mat Chuaq. Haq lam ŏi ta gùng Nôt, pah mat mahì loh da wùan Êđen. ");
INSERT INTO hre_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain caq ŏi dèh ti mai, èh mai haq hadràp wa xa-ông ca Ênoc. Cain broq mòiq toq phôq, hiniq ca phôq aih Ênoc tiaq dèh hiniq ca con calô haq. ");
INSERT INTO hre_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enh Ênoc jah xa-ông loh Irat. Irat wìa baq da Mê-hu-ja-ên. Ma-hu-ja-ên wìa baq da Mê-lu-sa-ên. Mê-lu-sa-ên wìa baq da Lamec. ");
INSERT INTO hre_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamec yŏc baiq toq mai, mòiq ngai haq hiniq Ađa, mòiq hòm Xila. ");
INSERT INTO hre_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ađa xa-ông ca Jaban. Jaban broq baq da wì mangai jàn rìh ŏi ta traiq wa i ngè aban. ");
INSERT INTO hre_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Oh haq Juban. Haq broq baq dìq ca mangai rawêh broc wa hlôi taliaq. ");
INSERT INTO hre_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Xila hadai xa-ông Tuban Cain, mangai atèm ranac xam mem wa đùng. Oh cadrì Tuban Cain, aih Na-a-ma. ");
INSERT INTO hre_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamec doi dèh ca baiq mai, Ađa wa Xila: “Ôi Ađa wa Xila, tamàng au beq. Au khoi jêh đac mòiq ngai taiq haq broq ca au habau, wa mangai radam taiq haq broq ca chac au jìq! ");
INSERT INTO hre_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tàng mangai leq jêh Cain, èh jêh chau mangai aih tapèh yàng yi trap, 'màng aih èh Lamec phai chìuq 70 yàng 7 yi trap hòm!” ");
INSERT INTO hre_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ađam caq ŏi dèh ti mai mòiq yàng hòm. Mai haq xa-ông con calô, hiniq haq Sêt. Êwa doi: “Boc Plình khoi am ca au mòiq toq con calô 'noiq thai ca Abên ma Cain khoi jêh đac.” ");
INSERT INTO hre_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sêt hadai i mòiq toq con calô hiniq haq Ênot. Pàng cô, con mangai baxèm loq waiq khàn dang creo ca hiniq Chuaq. ");
INSERT INTO hre_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Cô sech achìh ca xinoi Ađam. Hì ma Boc Plình broq loh con mangai, Haq broq loh con mangai tìah ca Boc Plình. ");
INSERT INTO hre_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Haq broq gu calô wa gu cadrì, am xôq ramŏt ca wa, èh Haq hiniq wa haq “Mangai,” ta hì ma Haq broq loh wa haq. ");
INSERT INTO hre_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Jò Ađam khoi rìh 130 hanam, xa-ông mòiq toq con calô tìah ca 'mù dađeh, haq hiniq Sêt. ");
INSERT INTO hre_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Atìq ca Ađam wìa baq da con calô Sêt, haq ŏi rìh tam 800 hanam, èh haq i con calô wa con cadrì ma 'noiq hòm. ");
INSERT INTO hre_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","'Màng aih Ađam halình jah 930 hanam, èh haq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sêt jah 105 hanam, èh wìa baq da Ênot. ");
INSERT INTO hre_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Atìq ca Sêt xa-ông ca Ênot, haq ŏi rìh jah 807 hanam, xa-ông con calô, con cadrì. ");
INSERT INTO hre_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","'Màng aih Sêt halình jah 912 hanam, èh haq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ênot jah 90 hanam, wìa baq da con calô Kênan. ");
INSERT INTO hre_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Atìq ca Ênot wìa baq da Kênan, haq ŏi rìh tam 815 hanam, èh haq i con calô wa con cadrì ma 'noiq hòm. ");
INSERT INTO hre_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ênot halình jah 905 hanam, èh haq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kênan jah 70 hanam, èh haq wìa baq da Ma-ha-la-lên. ");
INSERT INTO hre_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Atìq ca Kênan wìa baq da Ma-ha-la-lên, haq ŏi rìh 840 hanam, èh haq i con calô wa con cadrì ma 'noiq hòm. ");
INSERT INTO hre_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kênan halình jah 910 hanam, èh haq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ma-ha-la-lên jah 65 hanam, èh wìa baq da Jêrêt. ");
INSERT INTO hre_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Atìq ca Ma-ha-la-lên wìa baq da Jêrêt, haq ŏi rìh jah 830 hanam, èh haq i con calô wa con cadrì ma 'noiq hòm. ");
INSERT INTO hre_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ma-ha-la-lên halình jah 895 hanam, èh haq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jêrêt jah 162 hanam, èh haq wìa baq da Ênoc. ");
INSERT INTO hre_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Atìq ca Jêrêt wìa baq da Ênoc, haq ŏi rìh 800 hanam, èh haq i con calô wa con cadrì ma 'noiq hòm. ");
INSERT INTO hre_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","'Màng aih Jêrêt halình 962 hanam, èh haq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ênoc jah 65 hanam, èh haq wìa baq da Mê-tu-sê-la. ");
INSERT INTO hre_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Atìq ca Ênoc wìa baq da Mê-tu-sê-la, haq mòiq manoh ca Boc Plình trong caq ŏi 300 hanam, èh haq i con calô wa con cadrì ma 'noiq hòm. ");
INSERT INTO hre_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","'Màng aih Ênoc halình 365 hanam. ");
INSERT INTO hre_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ênoc mòiq manoh ca Boc Plình trong caq ŏi, èh haq ùh ŏi i hòm taiq Boc Plình khoi atŏc haq. ");
INSERT INTO hre_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mê-tu-sê-la ŏi rìh 187 hanam, èh haq wìa baq da Lamec. ");
INSERT INTO hre_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Atìq ca Mê-tu-sê-la wìa baq da Lamec, haq ŏi rìh 782 hanam, èh haq i con calô wa con cadrì ma 'noiq hòm. ");
INSERT INTO hre_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","'Màng aih Mê-tu-sê-la halình jah 969 hanam, èh haq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamec ŏi rìh 182 hanam, èh haq wìa baq da mòiq ngai con calô. ");
INSERT INTO hre_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Haq hiniq con calô aih Noah. Haq doi: “Mangai cô jah alòng manoh bèn trong bìac broq da bèn, bìac abèq xalep ca tì da bèn taiq taneh khoi 'bìq Boc Plình khoi waiq hanip.” ");
INSERT INTO hre_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Atìq ca haq wìa baq da Noah, haq ŏi rìh 595 hanam, èh haq i con calô wa con cadrì ma 'noiq hòm. ");
INSERT INTO hre_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","'Màng aih Lamec halình jah 777 hanam, èh haq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah khoi jah 500 hanam, èh haq wìa baq da Sem, Ham wa Japhêt. ");
INSERT INTO hre_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Jò con mangai baxèm bàc tam ta crŏng taneh, wa jò con mangai khoi xa-ông tam con cadrì, ");
INSERT INTO hre_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","èh 'bài con calô da Boc Plình hnoq con cadrì da con mangai ngan lem. 'Màng aih wì yŏc broq mai mangai leq troq manoh. ");
INSERT INTO hre_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Chuaq doi: “Yiang Au ùh jah chìuq ŏi hloi ta con mangai, ma jah 'màng aih wì haq toq chac xech raq. 'Nhac 'màng aih, 'nhòng mangai rìh jah 120 hanam hêq.” ");
INSERT INTO hre_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","'Nhòng aih wa 'nhòng atìq, i mangai ca'nhòng dìq jaq, jò con calô Boc Plình caq ŏi ti con cadrì da con mangai, èh xa-ông con caiq ma i 'bang càn. ");
INSERT INTO hre_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Chuaq hnoq bìac ngang dù hlòm da con mangai ta crŏng taneh; manoh hèm da wì haq xôq 'mèq 'mac hloi hloi. ");
INSERT INTO hre_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Èh Haq rawòi taiq Haq khoi broq con mangai ta crŏng taneh; Haq mango ta manoh. ");
INSERT INTO hre_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Chuaq doi: “Au raliang đac con mangai Au ma broq loh khoi enh taneh. Enh con mangai trùh ngè aban ta hnem, ngè rôm, ngè 'yêh wa chìm ta plình, ma jah 'màng aih Au rawòi Au khoi broq loh wì haq.” ");
INSERT INTO hre_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mahaq Noah jah xôq enh ngìa Chuaq. ");
INSERT INTO hre_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Cô xinoi da Noah. Haq mangai rìh ta-atoq, ùh nòi leq jah trech haq ta'ne 'bài mangai rìh pajùm ta 'nhòng da haq. Noah mòiq manoh ca Boc Plình trong caq ŏi. ");
INSERT INTO hre_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah wìa baq da piq toq con calô: Sem, Ham wa Japhêt. ");
INSERT INTO hre_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Manàiq crŏng taneh, dìq broq lìq broq làn 'mèq 'mac enh ngìa ca Boc Plình, wa crŏng taneh bình halùih bìac ngang dù. ");
INSERT INTO hre_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Boc Plình ngan crŏng taneh, hnoq joq 'nàng dìq broq lìq broq làn, ma jah 'màng aih dìq ca con mangai khoi broq trong dađeh loh ca 'mèq 'mac. ");
INSERT INTO hre_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Boc Plình doi ca Noah: “Bìac lùch da rìm chac xech khoi trùh enh ngìa ca Au, taiq con mangai ma crŏng taneh bình halùih bìac ngang dù. 'Màng aih Au phai raliang đac wì haq wa taneh hòm. ");
INSERT INTO hre_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ìh phai broq mòiq toq bong xam long Gôphe, broq bàc adùq, khoi èh baxìa xam chai enh trom wa enh gùng. ");
INSERT INTO hre_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ìh phai broq tiaq 'màng cô: Dàng yôh 280 hagat, dàng gat 46 hagat, dàng ha'nhèq 28 hagat. ");
INSERT INTO hre_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ìh phai broq ta bong mòiq toq 'mŏc gàu mòiq hagat enh 'neq ca cùa bong, broq mòiq 'mang pah pinh bong, wa broq piq hagan: hagan 'nhèq, hagan ta'ne, hagan 'neq. ");
INSERT INTO hre_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ngan cô, cla Au cô thê diac càn jàp enh 'nhèq ca crŏng taneh, đòiq raliang cađac dìq ca chac xech i hihèm ŏi enh ca'nàm plình, wa dìq ca hiniq ma rìh ta crŏng taneh cachìt dŏng dìq. ");
INSERT INTO hre_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mahaq Au broq wêh jao ca ìh; Ìh phai mùt ta bong pajùm mai ìh, 'bài con wa mai wì haq. ");
INSERT INTO hre_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ìh phai 'ràng mùt ta bong rìm hiniq ma rìh, mòiq adrech baiq toq, i cadrì i calô, i hmùng i can, ìh phai wèq wì haq ùh hìaq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Chìm tiaq dèh adrech, ngè rôm wa ngè aban tiaq dèh adrech, rìm hiniq 'yêh moq ta taneh tiaq dèh adrech. Èh rìm adrech mòiq adrech i baiq toq jah trùh ta ìh đòiq ìh wèq wì haq jah ŏi rìh. ");
INSERT INTO hre_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ìh phai yŏc rìm hiniq dahwèq caq 'ràng tiaq đòiq gop hanìuq broq dahwèq caq am ca ìh wa wì haq.” ");
INSERT INTO hre_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noah broq tiaq bàu Boc Plình khoi tanap ca haq. ");
INSERT INTO hre_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Chuaq doi ca Noah: “Ìh wa dìq ca cadraq ìh mùt ta bong beq, ma jah 'màng aih ta caxi 'nhòng cô, Au hnoq toq ìh mangai ta-atoq enh ngìa ca Au. ");
INSERT INTO hre_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ta ngè aban lem xriu, ìh phai 'ràng tiaq mòiq adrech tapèh đôi, calô wa cadrì 'mat. Èh 'bài ngè rìh ma ùh lem xriu, mòiq adrech mòiq đôi, calô wa cadrì. ");
INSERT INTO hre_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Hadai 'ràng tiaq 'bài chìm ta plình, mòiq adrech tapèh đôi i cadrì i calô, đòiq wèq adrech ŏi jàp crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ma jah 'màng aih ŏi tapèh hì hòm, Au broq mè 'noh ta crŏng taneh 40 hì wa 40 mang. Au jêh cađac dìq dŏng mangai wa ngè rìh Au ma khoi broq loh.” ");
INSERT INTO hre_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noah broq tiaq dìq ca bìac Chuaq ma khoi tanap ca haq. ");
INSERT INTO hre_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah khoi jah 600 hanam jò diac làp dŏng ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Taiq nen diac càn, Noah tŏc ta bong dèh ti mai, 'bài con calô wa 'bài mai da con calô haq. ");
INSERT INTO hre_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ngè rìh ma lem xriu, wa ngè rìh ma ùh lem xriu, 'bài chìm, wa ngè 'yêh ma moq ta taneh, ");
INSERT INTO hre_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","tang đôiq hmùng wa can, calô wa cadrì, dìq trùh ti Noah hi khoi tŏc ta bong, troi Boc Plình khoi doi ca Noah. ");
INSERT INTO hre_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Atìq ca tapèh hì, diac càn baxèm làp ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Wop hanam 600 'nhòng da Noah, hì 17, khê baiq, ta hì aih raq dìq ca diac mŏng enh 'neq ca taneh padah loh wa dìq ca diac mè enh plình hrôq 'noh tìah ca đàp tapŏt. ");
INSERT INTO hre_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mè ùh atàt 40 hì, 40 mang. ");
INSERT INTO hre_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Hì aih raq Noah tŏc ta bong dèh ti mai, piq toq con calô: Sem, Ham, Japhêt wa piq ngai con mai. ");
INSERT INTO hre_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Wì haq wa 'bài ngè rôm tiaq dèh adrech, ngè aban ta hnem tiaq dèh adrech, ngè 'yêh ta đùng, tagop tiaq dèh adrech, chìm tiaq adrech wa dìq ca adrech ma i panan. ");
INSERT INTO hre_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Dìq tang đôiq tiaq Noah mùt ta bong, aih 'bài ngè rìh ma i hihèm. ");
INSERT INTO hre_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","I calô wa cadrì, i hmùng wa can, mùt ta bong tiaq Boc Plình ma khoi tanap, hi khoi Chuaq clenh 'mang bong. ");
INSERT INTO hre_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Diac càn làp crŏng taneh 40 hì, diac tŏc yi ha'nhèq, èh diac dèch bong tŏc enh 'nhèq ca taneh. ");
INSERT INTO hre_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Diac tŏc yi ha'nhèq ca taneh, èh bong đòng ti diac. ");
INSERT INTO hre_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Diac tŏc yi ha'nhèq hòm, èh dìq ca wang ha'nhèq enh ca'nàm plình khoi làp dŏng dìq. ");
INSERT INTO hre_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Diac tŏc 15 hagat enh 'nhèq ca wang ma yi ha'nhèq ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Dìq ca chac xech ma rìh ta crŏng taneh cachìt ca glàc: chìm, ngè rôm, ngè aban, ngè 'yêh ma moq ta taneh, wa dìq ca mangai. ");
INSERT INTO hre_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Dìq dŏng ma i hihèm ŏi ta crŏng taneh cachìt dŏng dìq. ");
INSERT INTO hre_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","'Màng aih Boc Plình raliang đac rìm adrech ŏi ta crŏng taneh, enh adrech con mangai trùh adrech ngè rôm, adrech 'yêh ma moq ta taneh, adrech chìm ta plình. Toq Noah, wì mangai ŏi ti haq, wa dìq ca ngè ŏi ti haq ti bong jah ŏi rìh hêq. ");
INSERT INTO hre_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Diac càn ŏi ta crŏng taneh 150 hì. ");
INSERT INTO hre_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","'Màng aih Boc Plình hmàng hlài ca Noah wa dìq ca ngè ma rìh ŏi ta bong ti haq. Boc Plình thê cayeo hlôi cwa crŏng taneh, èh diac loh ca xŏt. ");
INSERT INTO hre_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Dìq ca diac tamŏc enh 'neq ca taneh wa dìq ca đàp ta plình jah clenh, èh mè enh plình atàt. ");
INSERT INTO hre_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Diac rai èh rai loh. Khoi dìq 150 hì, diac khoi yi 'biaq ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Hì 17, khê tapèh, bong tài ŏi ta wang A-ra-rat. ");
INSERT INTO hre_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Diac rai loh adia trùh khê 10. Hì mòiq, men jah hnoq 'bài bôi wang. ");
INSERT INTO hre_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Khoi 40 hì, Noah pèh 'mŏc gàu haq khoi broq ta bong. ");
INSERT INTO hre_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Haq ca'naih mòiq toq chìm ac loh. Chìm aih pan lam pan hlài trùh jò diac xŏt croh ti mat taneh. ");
INSERT INTO hre_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Khoi èh haq ca'naih mòiq chìm trù hnem đòiq ngan thù diac khoi xŏt jah dàng leq. ");
INSERT INTO hre_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mahaq chìm trù chaq ùh jah jang leq ma i nòi jràp. Haq pan hlài ta bong ti Noah, ma jah 'màng aih diac ŏi raq jàp ta crŏng taneh. 'Màng aih Noah hnhu tì rùp chìm trù 'mùt hlài ti dađeh ta bong. ");
INSERT INTO hre_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Haq gòm tapèh hì hòm, hi khoi haq ca'naih chìm trù loh enh bong. ");
INSERT INTO hre_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Trùh xèq, chìm trù hlài ti Noah. Ti hacùng haq cap wê mòiq hadrang hla ôliu ŏi rìh. 'Màng aih Noah loq diac khoi ten xŏt enh crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tapèh hì hòm atìq ca aih, Noah ca'naih hòm chìm trù, mahaq yàng cô chìm trù ùh hlài ta haq hòm. ");
INSERT INTO hre_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Hì mòiq, khê mòiq, jò Noah khoi jah 601 hanam, haq pèh 'mang bong, hnoq taneh khoi croh. ");
INSERT INTO hre_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Trùh khê baiq, hì 27, taneh khoi croh. ");
INSERT INTO hre_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Boc Plình doi ca Noah: ");
INSERT INTO hre_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Loh enh bong beq, ìh, mai ìh, wa con mai ìh. ");
INSERT INTO hre_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Phai 'ràng loh ti ìh dìq rìm ngè rìh da chac xech ma khoi ŏi ti ìh: Chìm, ngè rôm, ngè aban, wa rìm ngè 'yêh ma moq ta taneh, waq ca wì haq xêh tam loh bàc ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","'Màng aih Noah, mai haq, con calô haq, wa wì con mai haq loh khoi ca bong. ");
INSERT INTO hre_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Rìm ngè rôm, rìm ngè 'yêh moq, rìm chìm, wa rìm ngè aban, tiaq dèh adrech loh khoi enh bong. ");
INSERT INTO hre_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah broq mòiq toq ca'bŏng tadreo đòiq cùh waiq Chuaq. Haq rùp ngè aban ma hadròih, adrech chìm hadròih, èh broq ngè tadreo bùh ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Chuaq tàng hòi xua thùm, èh hèm ta manoh: “Au pi taiq con mangai ma waiq hanip taneh hòm, hadai pi jêh đac dìq ca ngè ma rìh ŏi ta crŏng taneh ma Au khoi broq loh, ma jah 'màng aih enh jò ŏi 'yoh, adrech da con mangai khoi i manoh hèm 'mèq. ");
INSERT INTO hre_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Jò leq ŏi raq i crŏng taneh, Èh jò rai adrech, jò gat, Jò tanget, jò tôq, Jò padrang, jò ralìm, Dahì, damang, Ùh i jò leq ma ùh i.” ");
INSERT INTO hre_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Boc Plình am xôq ramŏt ca Noah wa 'bài con calô haq, hi doi: “Phai xa-ông tam ma bàc waq ca bình halùih crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Dìq ca ngè ma rìh ta crŏng taneh, dìq ca chìm ta plình, wa dìq 'bài ca ma rìh ta diac, dìq dŏng ngè cô loq yùq crè ca pì. Pì jah wèq cwìang wì haq. ");
INSERT INTO hre_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Dìq ca ngè ma loq lam wa i hihèm, èh đòiq broq ca pì dahwèq caq, hadai tìah ca cachiq ma 'noiq, Au khoi am ca pì. ");
INSERT INTO hre_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Mahaq pì apaq caq jam adrìh, aih jam ma ŏi i mahem. ");
INSERT INTO hre_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ùh jah jêh đac mangai. Au joq 'nàng bòch hlài rìm ngè rôm leq ma broq ta-ùc mahem pì. Au hadai bòch chau mahem da mangai leq jêh đac oh daq cla. ");
INSERT INTO hre_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Mangai leq jêh đac mangai, ep 'bìq mangai jêh cađac, ma jah 'màng aih Boc Plình khoi broq loh con mangai tiaq 'mù Haq. ");
INSERT INTO hre_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","'Màng aih, pì phai xa-ông tam bàc broq bình halùih ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Boc Plình doi ca Noah wa 'bài con calô haq: ");
INSERT INTO hre_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Manàiq cô, Au broq wêh jao ca pì wa xinoi pì, ");
INSERT INTO hre_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","wa dìq ca ngè ma rìh ŏi ti pì, chìm ta plình, ngè aban ta hnem, rìm ngè rôm, rìm ngè khoi loh enh bong, aih rìm ngè ŏi ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Au broq wêh jao ca pì: Pàng cô ta èh, dìq ca chac xech ùh hìaq 'bìq jêh đac xam diac càn, hadai ùh i diac càn làp raliang đac crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Boc Plình doi hòm: “Cô teo patô Au khoi broq đòiq ca pì wa dìq ca ngè rìh ŏi ti pì, trùh dìq xinoi atìq cô èh. ");
INSERT INTO hre_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Au đòiq hađong da Au ta yùc, đòiq broq teo patô bìac wêh jao da Au wa crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Jò leq Au tagop yùc ŏi ta plình, wa jò leq hađong loh ŏi ta yùc aih, ");
INSERT INTO hre_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Èh Au hmàng hlài bàu wêh jao da Au ma khoi broq ŏi ti pì wa rìm ngè ma rìh i hihèm. Èh ùh jò leq i diac càn hòm raliang cađac dìq ca chac xech. ");
INSERT INTO hre_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","'Màng aih, jò hađong ŏi ta yùc, Au ngan hnoq haq, èh hmàng hlài bìac wêh jao hloi hloi ma Au khoi rùp bàu am dìq ca chac xech ma i hihèm rìh ŏi ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Boc Plình doi ca Noah: “Aih teo patô bìac wêh jao Au broq ta'ne ca Au wa rìm chac xech ŏi crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","'Bài con calô da Noah loh enh bong, aih: Sem, Ham wa Japhêt. Ham broq baq da Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Enh piq ngai con calô Noah ma i adrech dìq ca con mangai ŏi jàp ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","'Màng aih Noah baxèm abèq taneh, èh broq wùan pìt long nho. ");
INSERT INTO hre_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","I mòiq hì haq ôq diac plì nho loh ca bù, èh ŏi rahòng cùi dèh ta hnem traiq. ");
INSERT INTO hre_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, baq da Ca-na-an, hnoq 'màng aih, haq loh enh gùng anoi hlài ca Sem wa Japhêt. ");
INSERT INTO hre_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Mahaq Sem wa Japhêt yŏc eo ma ha'mac ta palêh dađeh, lam laq alùi mùt ta hnem traiq ta'màn dèh ca baq. Mat wa haq ngan enh ngìa dađeh, 'màng aih wa ùh hnoq dèh baq ŏi rahòng. ");
INSERT INTO hre_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Jò Noah hi brêh ca bù, loq dèh ca con ma tìa khoi broq ca dađeh, ");
INSERT INTO hre_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","haq doi: “Ca-na-an đang ca waiq hanip! Haq jah broq hapŏng dèh ca 'bài oh daq haq.” ");
INSERT INTO hre_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Haq doi tam: “Manè apôi Chuaq, Boc Plình da Sem! Ca-na-an phai broq hapŏng ca Sem. ");
INSERT INTO hre_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Waiq xìn Boc Plình pèh rùng taneh ca Japhêt, am ca haq rìh ŏi ta traiq Sem, èh Ca-na-an phai broq hapŏng haq.” ");
INSERT INTO hre_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Atìq ca diac càn, Noah ŏi rìh jah 350 hanam. ");
INSERT INTO hre_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Haq rìh halình 950 hanam, hi cachìt. ");
INSERT INTO hre_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Cô xinoi da Sem, Ham wa Japhêt, piq ngai con calô Noah. Atìq ca diac càn wì haq i con caiq xa-ông loh ca wì. ");
INSERT INTO hre_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Con calô da Japhêt, aih: Gôme, Magot, Mađai, Jawan, Tuban, Mêsiac wa Tira. ");
INSERT INTO hre_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Con calô da Gôme, aih: Ach-kê-na, Riphat wa Tô-ga-ma. ");
INSERT INTO hre_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Con calô da Jawan, aih: Ê-li-sa, Ta-rê-si, Kittim wa Rô-đa-nim. ");
INSERT INTO hre_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Enh wì haq aih i tam mangai ŏi jàp gùng ta dìq ca 'bò diac raxìq, lah ca dabau tiaq dèh bàu capoch wa tiaq dèh xinoi ta diac wì haq. ");
INSERT INTO hre_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Con calô Ham, aih Cut, Mich-ra-im, Put wa Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Con calô Cut, aih Sêba, Ha-wi-la, Sapta, Ra-ê-ma, wa Sap-tê-ca. Con calô Ra-ê-ma, aih Sêba wa Đêđan. ");
INSERT INTO hre_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cut wìa baq da Nimrôt. Haq cô mangai i manoh tanuq dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Haq mangai axan tanuq enh ngìa ca Chuaq, taiq 'màng aih i bàu anoi: “Tanuq tìah ca Nimrôt, mangai axan tanuq enh ngìa ca Chuaq.” ");
INSERT INTO hre_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Baxèm haq broq taneh diac Babên, Êrêt, Acat wa Canê ŏi ta gùng Sina. ");
INSERT INTO hre_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Enh gùng aih haq trùh gùng A-si-ri, khoi èh haq broq wìa Ni-ni-we, Rê-hô-bôt, Calach ");
INSERT INTO hre_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","wa Rêsen, phôq càn ŏi ta'ne Ni-ni-we wa Calach. ");
INSERT INTO hre_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mich-ra-im wìa baq da Luđim, A-na-mim, Lê-ha-bim, Nap-tu-him, ");
INSERT INTO hre_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pa-thru-sim, Cach-lu-him, (enh haq khoi wìa mangai Phi-li-tin) wa Cap-tô-rim. ");
INSERT INTO hre_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ca-na-an wìa baq da Siđôn, aih con ramua calô, wa Hêt, ");
INSERT INTO hre_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jê-bu-xit, A-mô-rit, Ghi-rê-ga-sit, ");
INSERT INTO hre_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hêwit, A-rê-kit, Sinit, ");
INSERT INTO hre_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","A-wa-đi, Xê-ma-ri, Ha-ma-tit. Atìq ca aih hadròng hadrech Ca-na-an lam pac lac. ");
INSERT INTO hre_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Gùng taneh da mangai Ca-na-an ta ngìa 'nah ta Ghêra, loh enh Siđôn trùh Gaxa, enh ngìa Sôđôm, Gô-mô-ra, Atma wa Xê-bô-im trùh Lasê. ");
INSERT INTO hre_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Aih con xau da Ham, tiaq dèh hadròng hadrech, bàu capoch, nòi gùng wa Diac wì haq. ");
INSERT INTO hre_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, haq daq da Japhêt. Haq broq boc dìq ca jàn Êbe. Haq hadai i con calô. ");
INSERT INTO hre_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Con calô da Sem, aih: Êlam, Asua, A-bac-sat, Lut wa Aram. ");
INSERT INTO hre_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Con calô da Aram, aih Uxò, Hulò, Ghête wa Mach. ");
INSERT INTO hre_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","A-bac-sat wìa baq da Sêlah, wa Sêlah wìa baq da Êbe. ");
INSERT INTO hre_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Êbe i baiq toq con calô, mòiq ngai hiniq haq Pêlec, ma jah 'màng aih ta 'nhòng haq, taneh khoi lah axong. Oh Pêlec, aih Joctan. ");
INSERT INTO hre_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctan wìa baq da A-mô-đat, Sêlep, Ha-sa-ma-wêt, Jêra, ");
INSERT INTO hre_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Ha-đô-ram, Uxan, Đichla, ");
INSERT INTO hre_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Ôban, A-bi-ma-ên, Sêba, ");
INSERT INTO hre_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ôphia, Ha-wi-la wa Jôbap. Dìq ca wì haq, aih con calô da Joctan. ");
INSERT INTO hre_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Gùng taneh da wì haq aih ŏi pah Mêsa trùh Sêpha, aih nòi wang pah mat mahì loh. ");
INSERT INTO hre_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Aih con calô wa con xau da Sem, lah axong tiaq xinoi bàu capoch, gùng nòi wì haq ŏi, wa tiaq dèh Diac wì haq. ");
INSERT INTO hre_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Dìq ca wì cô, aih cadraq con calô da Noah, tiaq dèh xinoi, tiaq dèh Diac. Enh wì haq aih dìq ca Diac jàn axong loh ta crŏng taneh atìq ca diac càn. ");
INSERT INTO hre_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Manàiq dìq ca mangai crŏng taneh i mòiq bàu capoch pajùm wa mòiq trong achìh chù bàu aih. ");
INSERT INTO hre_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Jò wì rai lam pah mat mahì loh, wì glàm mòiq đùng tamang ta gùng Sina, èh wì ŏi hloi ta aih. ");
INSERT INTO hre_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Mangai cô doi ca mangai tau: “Ê beq bèn broq gech khoi bùh ta ùnh.” 'Nhòng aih gech broq thai hmu, chai broq thai ximàng. ");
INSERT INTO hre_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Èh wì doi hòm: “Manàiq beq bèn broq mòiq toq phôq wa broq mòiq toq hnem hin bôi ha'nhèq trùh ta plình. Bèn phai broq ca hiniq dađeh i 'bang lem, yùq jò leq ep tac mac jàp ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Chuaq loh trùh đòiq ngan phôq wa hnem hin bôi da con mangai khoi broq. ");
INSERT INTO hre_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Chuaq doi: “Cô mòiq toq jàn raq, pajùm mòiq toq bàu. Tau bìac wì haq 'nang baxèm broq. Manàiq pi i cacleq jah tàt bìac wì haq khoi pajaq. ");
INSERT INTO hre_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Beq bèn phai loh broq manhài bàu capoch da wì haq, èh wì haq ùh 'nì tàng bàu capoch da mangai cô wa mangai tau.” ");
INSERT INTO hre_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Khoi èh pàng aih, Chuaq broq ca con mangai prai priang jàp ta crŏng taneh, 'màng aih wì hêq ca bìac broq phôq. ");
INSERT INTO hre_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Taiq nen aih hiniq ca phôq aih Babên, ma jah 'màng aih nòi aih Chuaq broq manhài dìq ca bàu capoch ta crŏng taneh, wa pàng cô Haq broq ca con mangai haprah hapriang jàp ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Cô xinoi da Sem: Baiq hanam atìq ca diac càn, Sem jah 100 hanam, èh wìa baq da A-bac-sat. ");
INSERT INTO hre_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Atìq ca Sem wìa baq da A-bac-sat, haq ŏi rìh tam 500 hanam, èh haq i con calô wa con cadrì hòm. ");
INSERT INTO hre_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","A-bac-sat jah 35 hanam, èh wìa baq da Sêlah. ");
INSERT INTO hre_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Atìq ca A-bac-sat wìa baq da Sêlah, haq ŏi rìh tam jah 403 hanam, èh haq i con calô wa con cadrì hòm. ");
INSERT INTO hre_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sêlah rìh 30 hanam, èh haq wìa baq da Êbe. ");
INSERT INTO hre_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Atìq ca Sêlah wìa baq da Êbe, haq ŏi rìh tam jah 403 hanam, èh haq i con calô wa con cadrì hòm. ");
INSERT INTO hre_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Êbe rìh 34 hanam, èh haq wìa baq da Pêlec. ");
INSERT INTO hre_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Atìq ca Êbe wìa baq da Pêlec, haq ŏi rìh tam jah 430 hanam, èh haq i con calô wa con cadrì hòm. ");
INSERT INTO hre_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pêlec rìh 30 hanam, èh haq wìa baq da Reu. ");
INSERT INTO hre_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Atìq ca Pêlec wìa baq da Reu, haq ŏi rìh tam 209 hanam, èh haq i con calô wa con cadrì hòm. ");
INSERT INTO hre_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu jah 32 hanam, èh haq wìa baq da Sêruc. ");
INSERT INTO hre_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Atìq ca Reu wìa baq da Sêruc, haq ŏi rìh tam jah 207 hanam, èh haq i con calô wa con cadrì hòm. ");
INSERT INTO hre_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sêruc jah 30 hanam, èh haq wìa baq da Nacô. ");
INSERT INTO hre_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Atìq ca Sêruc wìa baq da Nacô, haq ŏi rìh tam jah 200 hanam, èh haq i con calô wa con cadrì hòm. ");
INSERT INTO hre_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacô jah 29 hanam, èh haq wìa baq da Terah. ");
INSERT INTO hre_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Atìq ca Nacô wìa baq da Terah, haq ŏi rìh tam jah 119 hanam, èh haq i con calô wa con cadrì hòm. ");
INSERT INTO hre_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah jah 70 hanam, èh haq wìa baq da Apram, Nacô wa Haran. ");
INSERT INTO hre_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Cô xinoi da Terah: Terah wìa baq da Apram, Nacô wa Haran. Haran wìa baq da Lot. ");
INSERT INTO hre_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran cachìt dèh ta gùng cla, aih Urò ŏi ta gùng Canđê jò Terah, baq haq ŏi rìh. ");
INSERT INTO hre_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Apram wa Nacô yŏc mai. Mai Apram aih Sarai. Mai Nacô aih Minca, con cadrì Haran, aih baq da Mincah wa Itcah. ");
INSERT INTO hre_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai xon, haq ùh i ca con. ");
INSERT INTO hre_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah 'nong Apram, con calô cla haq, wa xau haq, aih Lot, con calô da Haran, wa Sarai mai con haq, loh khoi enh Urò ŏi ta gùng Canđê waq ca jah mùt gùng Ca-na-an. Wì haq lam trùh Haran hi ŏi ta aih. ");
INSERT INTO hre_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah rìh jah 205 hanam, khoi èh haq cachìt ta Haran. ");
INSERT INTO hre_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Khoi èh Chuaq doi ca Apram: “Ìh phai loh khoi ca gùng cla, oh daq wa baq ìh, èh lam trùh ta gùng Au jah patô am. ");
INSERT INTO hre_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Au jah broq am ca ìh wìa mòiq toq jàn càn. Au jah am ca ìh xôq ramŏt, èh broq hiniq ìh i 'bang càn bàc ngai jah canao loq. Èh ìh jah wìa mòiq toq nòi xèm xôq ramŏt. ");
INSERT INTO hre_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Èh Au am xôq ramŏt ca mangai leq waiq xôq ramŏt ca ìh. Mangai leq waiq hanip ìh, èh Au waiq hanip ca wì haq. Nhò ìh, dìq ca 'bài tamoi jàp ta crŏng taneh jah xôq ramŏt.” ");
INSERT INTO hre_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Apram lam tiaq troi bàu Chuaq ma khoi tanap. Lot hadai lam ti haq. Jò Apram loh khoi enh Haran, haq khoi 75 hanam. ");
INSERT INTO hre_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Apram 'nong Sarai mai haq, Lot mon haq, dìq ca cùng hang khoi tagop, wa 'bài hapŏng haq ma jah ŏi ta Haran. Wì haq loh enh nòi aih lam trùh gùng Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Apram lam cwa gùng cô trùh ta long rayai da Môrê ta Sichem. Jò aih mangai jàn Ca-na-an ŏi ta aih. ");
INSERT INTO hre_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Chuaq mahno loh ca Apram hi doi: “Au am ca xinoi ìh taneh gùng cô!” Khoi èh, ta aih Apram broq mòiq ca'bŏng tadreo am Chuaq, Haq ma khoi mahno dađeh loh ca Apram. ");
INSERT INTO hre_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Enh aih haq lam trùh wang ŏi pah mat mahì loh ca Bêtên. Haq đòiq traiq ta aih; i Bêtên ŏi pah mat mahì mùt, wa Ahi ŏi pah mat mahì loh. Haq broq mòiq ca'bŏng tadreo am Chuaq, èh waiq dang hiniq Haq. ");
INSERT INTO hre_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Atìq ca aih Apram xôq rai lam trong pah 'ma ca mat mahì loh. ");
INSERT INTO hre_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Manàiq cô ta gùng cô i bìac pangot hrah càn dìq jaq, taiq 'màng aih Apram loh ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Jò ten mùt ta gùng Aicàp, Apram doi ca Sarai mai haq: “Cô, au loq gè mòiq ngai gu cadrì lem, ");
INSERT INTO hre_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","èh jò mangai Aicàp hnoq gè, wì jah doi: Aih mai haq tau. Èh wì jêh đac au mahaq đòiq gè rìh. ");
INSERT INTO hre_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Au xìn gè doi ca wì, gè oh au waq ca nhò gè èh au men jah ŏi aiq wa jah ŏi rìh.” ");
INSERT INTO hre_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Apram bu trùh Aicàp, mangai Aicàp hnoq mangai gu cadrì dìq jaq lem. ");
INSERT INTO hre_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","'Bài cwan da bùa Pha-ra-ôn hnoq haq, èh wì padràu hau jang ngìa bùa. Khoi èh wì 'nong haq mùt ta hnem bùa Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Taiq Sarai, Pha-ra-ôn ma jah tamèt broq lem ca Apram, am ca haq bàc trìu, 'bo, lùa, lŏcđa wa hapŏng calô, hapŏng cadrì. ");
INSERT INTO hre_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mahaq taiq Sarai mai Apram, Chuaq baxa Pha-ra-ôn wa 'bài mangai ŏi ta hnem haq, dìq glàm ranàc càn. ");
INSERT INTO hre_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pha-ra-ôn creo ca Apram trùh, bòch: “Ìh khoi broq ca au cleq 'màng cô? Gleq ma ùh doi ca au loq Sarai mai ìh? ");
INSERT INTO hre_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Gleq ìh doi, haq aih oh ìh? Ùac aiq au khoi jah yŏc haq broq mai au! 'Màng aih manàiq cô yŏc mai ìh, èh lam beq.” ");
INSERT INTO hre_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Khoi èh Pha-ra-ôn thê 'bài cwan haq 'nong wa ŏng mai Apram xam dìq dŏng cùng hang haq lam. ");
INSERT INTO hre_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Apram enh diac Aicàp 'nong dèh mai xam dìq cùng hang cla wa Lot, mon haq, lam ta gùng Nêghep. ");
INSERT INTO hre_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Apram loh ca dìq jaq padrŏng can i ngè aban, wang wa 'bac. ");
INSERT INTO hre_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Enh gùng Nêghep, haq rai lam trùh Bêtên, nòi haq đòiq traiq yàng baxèm adroi ŏi ta'ne Bêtên wa Ahi, ");
INSERT INTO hre_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","nòi yàng adroi haq khoi broq ca'bŏng tadreo. Ŏi ta aih Apram creo dang Chuaq. ");
INSERT INTO hre_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot lam pajùm ti Apram, hadai i calùh trìu, 'bo wa traiq. ");
INSERT INTO hre_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Gùng aih ùh anòh ca wa haq ŏi pajùm, ma jah 'màng aih cùng hang bàc hrìn trùh 'mòi wì pi jah ŏi pajùm ti dabau. ");
INSERT INTO hre_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","I bìac 'bài mangai ban ngè aban da Apram wa 'bài mangai ban ngè aban da Lot tarahen ca dabau. Jò aih jàn Ca-na-an wa jàn Pe-rê-xit ŏi ta gùng aih. ");
INSERT INTO hre_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Apram doi ca Lot: “Ba cô mòiq mahem. Ìh wa au, wa 'bài mangai ban ngè aban au wa 'bài mangai ban ngè aban ìh ùh khòh tarahen ca dabau. ");
INSERT INTO hre_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Dìq ca gùng cô ma ùh ŏi jang ngìa ìh 'mòh? 'Màng aih loh khoi enh au beq. Tàng ìh yŏc pah 'ngeo, èh au yŏc pah 'ma. Tàng ìh yŏc pah 'ma, èh au yŏc pah 'ngeo.” ");
INSERT INTO hre_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot ngoi ngan hnoq jàp gùng tamang pah diac Jôđan, aih nòi adroi ca jò Boc Plình 'nhòq raliang đac phôq Sôđôm wa Gô-mô-ra, dìq dŏng taneh i bàc diac cròng lem trùh ta Xoa. Đùng aih hadai tìah ca wùan Chuaq wa tìah ca gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot ràih yŏc ca dađeh dìq dŏng taneh tamang pah diac Jôđan wa lam pah mat mahì loh. 'Màng aih wa baiq ngai talah dabau. ");
INSERT INTO hre_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Apram ŏi ta gùng Ca-na-an, mahaq Lot ŏi hloi ta dìq ca phôq ta gùng tamang. Haq 'nhon dèh traiq cla haten phôq Sôđôm, ");
INSERT INTO hre_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mahaq jàn Sôđôm ngang dù dìq ca jaq; mangai broq tôiq lôi càn ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Atìq ca Lot loh khoi ca Apram, Chuaq doi ca haq: “Ngoi mat ngan beq. Enh nòi ìh 'nang ŏi trùh pah 'ngeo ca mat mahì loh, pah 'ma ca mat mahì loh, pah mahì loh, wa pah mat mahì mùt, ");
INSERT INTO hre_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","taiq dìq ca taneh gùng ìh hnoq, Au am ca ìh wa am ca xinoi ìh hloi hloi. ");
INSERT INTO hre_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Au jah broq am xinoi ìh bàc tìah ca blo taneh. Tàng mangai leq nui rèn blo ta crŏng taneh, hadai nui rèn xinoi ìh 'màng aih. ");
INSERT INTO hre_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Yòng lam jàp ta gùng beq, pah dàng yôh, pah dàng gat, 'màng aih raq Au jah am ca ìh taneh gùng cô.” ");
INSERT INTO hre_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Khoi èh Apram 'nhon dèh traiq trùh ŏi nòi xèm long rayai ta Mamrê, ŏi ta Hêprôn. Ŏi ta aih haq broq mòiq toq ca'bŏng tadreo am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ta 'nhòng Am-ra-phin, bùa Sina, A-ri-oc, bùa Ê-la-sa, Kêt-rô-lao-me, bùa Êlam, wa Tiđan, bùa Gô-im, ");
INSERT INTO hre_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","pôn toq bùa aih yùp pajùm ca dabau tajêh poh ca Bêra bùa Sôđôm, Bi-rê-sa bùa Gô-mô-ra, Si-nê-ap bùa Atma, Sê-mê-bê bùa Xê-bô-im, wa bùa da phôq Bêla, aih Xoa. ");
INSERT INTO hre_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Dìq ca bùa cô yùp hlài ca dabau ŏi ta thòng Siđim, aih Diac Raxìq Boh. ");
INSERT INTO hre_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ta 12 hanam 'bài bùa cô khoi patìh ca bùa Kêt-rô-lao-me, mahaq hanam ma 13 wì haq yòng blàq. ");
INSERT INTO hre_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Wop hanam ma 14, Kêt-rô-lao-me wa dìq ca bùa ti haq, trùh tabroq tajêh ca jàn Rê-pha-im ta gùng Ach-ta-rôt Ca-ma-in, jàn Xuxim ta gùng Ham, jàn Êmim ta gùng Ki-ri-a-tha-im, ");
INSERT INTO hre_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","wa jàn Hôrit ŏi ta wang Sirò, trùh nòi Ên-pha-ran ŏi haten ca braih càn. ");
INSERT INTO hre_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Khoi èh 'bài bùa tagop lình wìh hlài trùh cròng diac Hadrah, aih Cađê, glàm jêh jàp cròng jàn A-ma-lec wa jàn A-mô-rit ŏi ta Ha-xa-xan Tama. ");
INSERT INTO hre_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","'Bài bùa da Sôđôm, Gô-mô-ra, Atma, Xê-bô-im, wa bùa Bêla, aih Xoa, loh tagop lình padon tajêh wì haq ŏi ta thòng Siđim, ");
INSERT INTO hre_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","đòiq tajraq ca Kêt-rô-lao-me, bùa Êlam, Tiđan, bùa Gô-im, Am-ra-phin, bùa Sina, wa A-ri-oc, bùa Ê-la-sa. Pôn bùa tabroq tajêh ca padam toq bùa. ");
INSERT INTO hre_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ta jàp nòi thòng Siđim i bàc ralùng bình chai. Bùa Sôđôm wa bùa Gô-mô-ra pi 'blêq, hi cadàu mot, èh 'nah ngai clìh ta ralùng chai, mangai leq ma jah claih, cadàu mot ta bôi wang. ");
INSERT INTO hre_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wì ma jêh 'blêq, yŏc hloi dìq dŏng ca cùng hang wa 'mau phi da Sôđôm wa Gô-mô-ra, khoi èh lam. ");
INSERT INTO hre_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Wì hadai rùp yŏc Lot, mon Apram ŏi ta Sôđôm, wa dìq dŏng cùng hang haq, khoi èh 'nong lam. ");
INSERT INTO hre_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","I mòiq ngai jah claih cadàu hlài anoi bìac aih ca Apram, mangai Hêbru, 'nang ŏi ta xèm long rayai da Mamrê, mangai A-mô-rit, daq Êchcôn wa Ane. Piq ngai cô khoi wêh jao ca Apram. ");
INSERT INTO hre_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Jò Apram hìa tìn mon haq 'bìq wì rùp, haq ràih gop 318 ngai hapŏng khoi jah hnài axràm gêh geo bìac tajêh poh, wì ma khoi xa-ông loh ta hnem haq, èh haq hnan tiaq 'bài bùa aih trùh gùng Đan. ");
INSERT INTO hre_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Apram lah dèh 'bài hapŏng gòm trùh damang glàm jêh lình wì, hnan tiaq trùh ta gùng Hôba, ŏi pah 'ngeo mat mahì loh Đamat. ");
INSERT INTO hre_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Apram gop hlài tôm dìq cùng hang wì ma khoi yŏc, ji 'nong dèh mon Lot wa cùng hang haq, gu cadrì wa mangai jàn, èh wìh hlài. ");
INSERT INTO hre_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Khoi ca Apram ta'blêq bùa Kêt-rô-lao-me wa wì bùa ti haq, èh wìh hlài, bùa Sôđôm loh lam glàm haq ŏi ta thòng Sawê, aih thòng da bùa. ");
INSERT INTO hre_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mên-chi-xê-đec, bùa Salem, thê 'ràng 'benh wa alac. Bùa cô pajàu Boc Plình ma Yi Ha'nhèq. ");
INSERT INTO hre_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Mên-chi-xê-đec waiq xôq ramŏt ca Apram, doi: “Waiq xìn Boc Plình ma Yi Ha'nhèq, Haq ma broq loh crŏng taneh, am xôq ramŏt ca Apram! ");
INSERT INTO hre_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Đang ca manè padèch Boc Plình ma Yi Ha'nhèq, khoi 'mùt mangai git ca ìh ta tì ìh!” Khoi èh Apram am ca Mên-chi-xê-đec mòiq phàn mòiq jàt ca cùng hang haq ma khoi 'ràng hlài. ");
INSERT INTO hre_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Bùa Sôđôm doi ca Apram: “Am ca au toq mangai beq, dìq ca cùng hang ìh ma khoi 'ràng hlài, ìh yŏc beq.” ");
INSERT INTO hre_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mahaq Apram tèu hlài: “Au dèch tì jang ngìa Chuaq Boc Plình ma Yi Ha'nhèq, Haq ma khoi broq loh plình crŏng taneh, au pachac: ");
INSERT INTO hre_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ma leq ma cùng hang da bùa, 'nhac ca mòiq hadrang brai, loq mòiq hadrang caxi jai, au ji ùh yŏc; èh yùq ìh loq doi: ‘nhò au broq ca Apram can padrŏng.’ ");
INSERT INTO hre_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Toq dahwèq leq da 'bài mangai radam khoi caq, wa phàn da 'bài mangai ma hadai lam ti au, aih Ane, Êchcôn wa Mamrê. Đòiq wì haq yŏc phàn da wì haq beq.” ");
INSERT INTO hre_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Atìq dìq ca bìac aih, Chuaq am ca Apram bìac mahno, i bàu doi: “Ô Apram, ìh apaq crè. Au cô khìan wèq ban ìh, cùng baha tam da ìh jah càn dìq jaq èh.” ");
INSERT INTO hre_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Mahaq Apram bòch: “Chuaq ôi, Ìh am ca au bìac cleq taiq au cô èh cachìt xôq ùh i ca con? Èh mangai ma ta'mŏt bìac broq ta hnem au, aih Ê-li-ê-se mangai Đamat.” ");
INSERT INTO hre_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Apram doi hòm: “Chuaq 'nhòq broq ca au jah i con, ma jah 'màng aih mòiq ngai hapŏng xa-ông loh ŏi ta hnem au, èh haq wìa con hatìa da au.” ");
INSERT INTO hre_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Chuaq tèu haq: “Mangai aih ùh xài broq mangai hùang xôxech ìh, mahaq con calô ìh ma ŏi ta chac ìh ma jah xa-ông loh èh, cla haq jah hùang xôxech da ìh.” ");
INSERT INTO hre_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Khoi ca aih, Chuaq 'nong Apram loh enh gùng hi doi: “Ìh ngoi ngan ta plình. Tàng jah, ìh rèn dìq ca halŏng beq.” Haq doi hòm: “Xinoi ìh hadai jah bàc tìah 'màng aih èh.” ");
INSERT INTO hre_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Apram lùi Chuaq, 'màng aih Chuaq doi Apram ta-atoq. ");
INSERT INTO hre_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Haq doi hòm ca Apram: “Au cô Chuaq ma khoi 'noh ìh loh khoi enh Urò ŏi ta gùng Canđê, đòiq am ca ìh taneh gùng cô broq xôxech.” ");
INSERT INTO hre_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Apram bòch: “Waiq Chuaq, 'màng leq au jah loq, au jah taneh gùng cô broq xôxech au èh?” ");
INSERT INTO hre_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Chuaq doi ca haq: “Ìh rùp 'ràng ca Au mòiq toq con 'bo cadrì piq hanam, mòiq toq bubi cadrì piq hanam, mòiq toq con trìu calô piq hanam, mòiq toq chìm trù gùng, wa mòiq toq chìm trù hnem beq.” ");
INSERT INTO hre_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Apram rùp tôm 'bài ngè aih 'ràng ca Chuaq, èh haq pah chac jang ta'ne broq baiq apah, hi khoi haq đòiq tang hachêh, mòiq pot aih, ngìa 'nah ta dabau, mahaq haq ùh pah 'bài chìm broq baiq apah. ");
INSERT INTO hre_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","I 'bài chìm cliang kèn pan jràp ti chac 'bài ngè tadreo aih, mahaq Apram hnan đac. ");
INSERT INTO hre_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Khoi èh jò mat mahì 'nang mùt, Apram cùi hnia. Èh i can yùq crè wa clam cluiq glàp chac haq. ");
INSERT INTO hre_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Chuaq doi ca Apram: “Ìh phai loq, joq 'nàng xinoi ìh jah rìh ŏi ta mòiq toq gùng, mahaq gùng aih ùh xài gùng wì haq. Ŏi ta aih wì haq broq dìch ca jàn gùng aih chìuq wì padit padiang 400 hanam. ");
INSERT INTO hre_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mahaq Au jah hadrah baxa jàn ma xinoi ìh broq dìch aih, khoi èh wì haq claih khoi enh gùng aih, 'ràng ti wì bàc cùng hang dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Phàn ìh jah catèm rìh trùh craq, hlài ca boc yaq, khoi èh hi cachìt catùh. ");
INSERT INTO hre_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Trùh 'nhòng pôn, xinoi ìh jah wìh hlài ta cô, ma jah 'màng aih tôiq lôi da jàn A-mô-rit 'nhòq hìaq bình halùih.” ");
INSERT INTO hre_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Jò mat mahì khoi mùt, èh can xèq khoi clam cluiq, i aiq mòiq toq cato nhòi pan tŏc wa mòiq pla ùnh cheo pagat cwa 'bài ngè tadreo khoi pah. ");
INSERT INTO hre_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Hì aih raq Chuaq broq wêh jao ca Apram. Haq doi: “Au am ca xinoi ìh gùng cô, enh cròng diac Aicàp trùh cròng diac ma càn tau, aih cròng diac U-phra-tê, ");
INSERT INTO hre_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","aih gùng da 'bài Kênit, Kê-nê-xit, Cat-mô-nit, ");
INSERT INTO hre_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hêtit, Pe-rê-xit, Rê-pha-im, ");
INSERT INTO hre_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","A-mô-rit, Ca-na-an, Ghi-rê-ga-sit wa Jê-bu-xit.” ");
INSERT INTO hre_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Jò aih Sarai, mai Apram xôq ùh xa-ông con. Sarai i mòiq ngai hapŏng cadrì Aicàp, hiniq haq Aga. ");
INSERT INTO hre_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai doi ca Apram: “Taiq Chuaq khoi broq ca au xon, 'màng aih au xìn ìh caq ŏi ti mangai cadrì hapŏng ma ŏi patìh ca au beq, èh au jah nhò haq i con am ca au.” Apram iu tiaq bàu Sarai. ");
INSERT INTO hre_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","'Màng aih, atìq ca jò Apram khoi rìh ŏi 10 hanam ta gùng Ca-na-an, Sarai mai Apram, 'ràng Aga mangai Aicàp, aih mangai cadrì hapŏng ma ŏi patìh ca haq, am dèh ca ŏng. ");
INSERT INTO hre_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ŏng haq cùi ŏi ti mangai cadrì aih, èh haq ŏi jiang. Jò hnoq dađeh khoi ŏi jiang, Aga khìn Sarai craq dađeh. ");
INSERT INTO hre_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai doi ca Apram: “Bìac camaih au ep ta-ùc hlài ta ìh! Au khoi am dèh mangai cadrì ŏi patìh au ca ìh, mahaq jò haq hnoq dađeh ŏi jiang, haq khìn hlài au. Waiq Chuaq hadrah ta'ne ìh wa au.” ");
INSERT INTO hre_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Apram tèu hlài Sarai: “Cô, mangai cadrì ŏi patìh aih ŏi ta tì gè, gè enh broq 'màng leq, himac da gè!” 'Màng aih Sarai padit padiang Aga, èh Aga cadàu mot khoi ca mat haq. ");
INSERT INTO hre_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mahaq 'Bình Plình da Chuaq hnoq Aga haten ca tamŏc diac ŏi ta đùng hawit ha'mai trong trùh ta Sura. ");
INSERT INTO hre_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","'Bình Plình bòch haq: “Ô Aga mangai cadrì ŏi patìh da Sarai, ìh ŏi enh leq trùh, èh lam ta leq?” Haq tèu: “Au 'nang cadàu mot hangai ca mat Sarai, craq au.” ");
INSERT INTO hre_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","'Bình Plình da Chuaq doi ca haq: “Ìh wìh hlài ta craq ìh wa chìuq xalep ŏi ta tì haq beq.” ");
INSERT INTO hre_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","'Bình Plình da Chuaq doi hòm: “Au jah broq xinoi da ìh bàc dìq jaq ùh i mangai leq nui rèn.” ");
INSERT INTO hre_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","'Bình Plình da Chuaq doi hòm: “Manàiq cô, Ìh 'nang ŏi jiang, èh ìh xa-ông mòiq toq con calô, hiniq ca haq Ich-ma-ên, ma jah 'màng aih Chuaq i tàng trùh bìac xa mango da ìh. ");
INSERT INTO hre_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Con nga aih jah tìah ca mòiq toq con lùa brì. Èh haq i manoh loq enh tajraq ca rìm ngai, èh rìm ngai tajraq hlài ca haq. Mahaq haq hadai ŏi haten dèh dìq ca oh daq haq.” ");
INSERT INTO hre_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Aga hiniq ca Chuaq ma capoch tùang ca haq: “Ìh Boc Plình ma loq hnoq ma ro”. Ma jah 'màng aih haq doi: “Au ma ùh khoi hnoq Boc Plình ma loq hnoq au 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Taiq nen aih, wì creo ca diac adràm ma ŏi ta'ne Cađê wa Bêrêt, aih diac adràm Bê-la-cha-roi. ");
INSERT INTO hre_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Khoi èh Aga xa-ông mòiq toq con calô. Apram hiniq am ca con calô aih Ich-ma-ên. ");
INSERT INTO hre_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","'Màng aih jò Aga xa-ông Ich-ma-ên, Apram khoi jah 86 hanam. ");
INSERT INTO hre_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Jò Apram jah 99 hanam, Chuaq mahno loh ca haq, doi: “Au cô Boc Plình I Cwìang Itai Dìq Dŏng. Enh ngìa Au, ìh phai caq ŏi rìh dìq jaq xriu hadròih beq. ");
INSERT INTO hre_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Au broq cajap wêh jao ta'ne Au wa ìh, èh broq am xinoi ìh bàc tam dìq jaq.” ");
INSERT INTO hre_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Apram bla-op dađeh ta taneh. Boc Plình doi ca haq: ");
INSERT INTO hre_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Cô phàn da Au, cô wêh jao Au broq ca ìh, èh ìh jah broq boc da bàc jàn. ");
INSERT INTO hre_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Pàng cô ta èh wì ùh creo ca ìh Apram hòm, mahaq creo ca ìh: Ap-ra-ham, ma jah 'màng aih Au khoi ràih ìh đòiq broq boc da bàc jàn. ");
INSERT INTO hre_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Au jah broq am ca ìh xa-ông loh bàc dìq jaq, broq ca ìh loh bàc jàn diac, èh enh ìh loh bàc bùa. ");
INSERT INTO hre_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Au jah broq cajap wêh jao ta'ne Au wa ìh, wa xinoi ìh enh 'nhòng cô trùh 'nhòng atìq, aih wêh jao hloi hloi đòiq Au broq Boc Plình da ìh wa da xinoi atìq ca ìh. ");
INSERT INTO hre_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Au jah am ca xinoi ìh gùng pì ma ŏi, aih dìq ca gùng Ca-na-an, broq xôxech hloi hloi. 'Màng aih Au jah broq Boc Plình da wì haq.” ");
INSERT INTO hre_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Khoi èh Boc Plình doi ca Ap-ra-ham: “Phàn da ìh wa xinoi ìh, enh 'nhòng cô trùh 'nhòng tau, pì ep wèq bìac wêh jao da Au. ");
INSERT INTO hre_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Wêh jao da Au broq ca ìh wa xinoi ìh, aih dìq ca gu calô ŏi ta pì ep chìuq lè cat akia. ");
INSERT INTO hre_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Akia da gŏi lô ep chìuq cat đac, aih teo da bìac wêh jao ta'ne Au wa pì. ");
INSERT INTO hre_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Rìm ngai mangai calô ŏi ta pì xa-ông ta hnem loq 'nòh 'bac rŏt haq enh mangai Diac 'noiq, ùh ŏi ta xinoi ìh, hi khoi rahem hì wì ep chìuq cat akia. ");
INSERT INTO hre_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Mangai hapŏng khoi xa-ông loh ta hnem ìh, loq khoi 'nòh 'bac rŏt haq enh mangai diac 'noiq, ep chìuq lè cat akia. Cô wêh jao hloi hloi da Au ma pì ep wèq broq ŏi ta chac da pì. ");
INSERT INTO hre_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mahaq mòiq ngai mangai calô leq ùh broq lè cat akia, jah 'bìq 'nòh đac enh gùng ca jàn cla; mangai aih khoi blàq hlài bàu wêh jao da Au.” ");
INSERT INTO hre_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Boc Plình doi ca Ap-ra-ham: “Sarai mai ìh, pi jah creo ca haq Sarai hòm, mahaq Sara, aih hiniq haq. ");
INSERT INTO hre_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Au am xôq ramŏt ca haq, enh nòi haq èh Au jah am ca ìh mòiq toq con calô. Au am xôq ca haq, èh haq broq yaq bàc jàn, 'bài bùa da con jàn jah loh enh nòi haq.” ");
INSERT INTO hre_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ap-ra-ham bla-op ta taneh do, hèm dèh ta manoh, doi: “Au khoi 100 hanam cô, jah i con 'màng leq? Sara khoi 90 jah xa-ông con 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Hi khoi Ap-ra-ham doi ca Boc Plình: “Ngèh enh Ich-ma-ên xôq jah rìh jang ngìa Ìh!” ");
INSERT INTO hre_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Boc Plình tèu: “Ùh, mahaq Au jah am ca Sara mai ìh xa-ông mòiq toq con calô, ìh hiniq ca con calô aih Isac. Au jah broq wêh jao ca haq, đòiq broq cajap wêh jao hloi hloi am ca xinoi da haq. ");
INSERT INTO hre_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mahaq ca Ich-ma-ên, Au khoi tàng bàu ìh. Au am xôq ramŏt ca haq, broq am ca haq xa-ông con bàc, èh haq jah bàc con xau tam dìq jaq. Haq jah wìa boc da 12 toq cwan càn. Au broq am ca haq wìa mòiq toq jàn càn. ");
INSERT INTO hre_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mahaq Au broq wêh jao ca Isac, con Sara ma xa-ông am ca ìh jò cô hanam atìq.” ");
INSERT INTO hre_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Jò Boc Plình hatùang ca Ap-ra-ham khoi hêq, Haq tŏc khoi ca haq. ");
INSERT INTO hre_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Hì aih raq, Ap-ra-ham yŏc Ich-ma-ên, con cla haq, dìq dŏng gu calô xa-ông loh ta hnem, wa dìq ca hapŏng khoi rŏt, èh broq lè cat akia am ca wì dìq dŏng tiaq Boc Plình khoi thê. ");
INSERT INTO hre_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ap-ra-ham khoi jah 99 hanam jò haq chìuq lè cat akia. ");
INSERT INTO hre_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ich-ma-ên con haq, jah 13 hanam jò haq chìuq lè cat akia. ");
INSERT INTO hre_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Hadai hì aih, Ap-ra-ham wa Ich-ma-ên chìuq lè cat akia. ");
INSERT INTO hre_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Rìm ngai gu calô khoi xa-ông loh ta hnem, loq khoi rŏt enh mangai Diac 'noiq, dìq chìuq lè cat akia pajùm ti haq. ");
INSERT INTO hre_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Chuaq trùh ca Ap-ra-ham ta nòi xèm long rayai ta Mamrê, 'nang jò haq ha'ngui jang 'mang traiq jò plình tôq dahì. ");
INSERT INTO hre_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ap-ra-ham ngoi mat ngan hnoq piq ngai yòng jang ngìa haq. Jò bu hnoq wì, Ap-ra-ham cadàu enh 'mang traiq trùh jang ngìa wì piq ngai aih, bla-op ta taneh. ");
INSERT INTO hre_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Haq doi: “Waiq Chuaq, tàng au jah lem manoh jang ngìa ca Chuaq, xìn apaq lam cwa khoi ca au, hapŏng da Ìh. ");
INSERT INTO hre_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Xìn pì am au yŏc diac đòiq 'nheo jènh pì, èh xìn pì ca'nùng padài jang yàp xèm long cô oq. ");
INSERT INTO hre_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Au jah lam yŏc 'benh 'ràng ca pì caq yŏc hlài padren, khoi èh hi lam hòm, ma jah 'màng aih, manàiq pì khoi trùh hmàih ca mangai hapŏng pì.” Wì tèu haq: “Broq bìac troi ìh khoi doi beq.” ");
INSERT INTO hre_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","'Màng aih, Ap-ra-ham dahôiq mùt ta traiq doi ca Sara: “Renh beq, yŏc piq cađap dàc khoi jàn loh 'yêq, rawàt ma renh broq 'benh beq.” ");
INSERT INTO hre_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ap-ra-ham cadàu trùh ta cadrong, rùp mòiq toq 'bo con bech lem, thê dèh hapŏng broq jam pai ma renh hi padon. ");
INSERT INTO hre_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ap-ra-ham yŏc sùa ramaq pajùm ca jam 'bo con khoi pai chìn, padon jang ngìa wì haq; èh cla haq yòng gòm enh 'neq ca long mòiq apah ca wì aih 'nang caq. ");
INSERT INTO hre_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Jò rai caq wì bòch Ap-ra-ham: “Sara, mai ìh ŏi ta leq?” Haq tèu: “Haq ŏi ta traiq tau.” ");
INSERT INTO hre_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mòiq Ngai doi: “Ŏi mòiq hanam hòm, ta jò cô, Au jah wìh hlài ti ìh. Jò aih èh Sara, mai ìh, jah i mòiq toq con calô.” Sara ŏi ta 'mang traiq enh cloh haq, tàng bàu aih. ");
INSERT INTO hre_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Jò aih Ap-ra-ham khoi craq, wa Sara hadai khoi bàc hanam, ùh jah xa-ông con hòm. ");
INSERT INTO hre_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara do ta manoh. Haq hèm: “Craq troi au cô 'màng leq ma ŏi jah bìac lem bùi 'màng aih 'mòh? Ŏng au hadai khoi craq.” ");
INSERT INTO hre_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Chuaq bòch Ap-ra-ham: “Gleq Sara ma do rai doi: au khoi craq 'màng cô mahaq joq 'nàng ŏi jah xa-ông con 'mòh? ");
INSERT INTO hre_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","I bìac leq Chuaq broq ùh jah ùh? Trùh jò khoi pajaq ŏi mòiq hanam hòm, Au jah wìh hlài ti ìh, Sara jah i mòiq toq con calô.” ");
INSERT INTO hre_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Mahaq Sara taiq crè, hi chôiq rai doi: “Au ùh do.” Mahaq Haq doi: “Joq 'nàng ìh khoi do.” ");
INSERT INTO hre_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","'Bài Mangai aih yòng lam, ha'miang ngan pah Sôđôm. Ap-ra-ham hadai lam bùi ti wì haq mòiq apŏt trong. ");
INSERT INTO hre_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Chuaq doi: “Au khòh cadoc ca Ap-ra-ham bìac Au padon broq cô èh ùh? ");
INSERT INTO hre_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ma jah 'màng aih Ap-ra-ham joq 'nàng wìa mòiq toq jàn càn wa dêh; mangai jàn ta crŏng taneh jah nhò haq men jah xôq ramŏt. ");
INSERT INTO hre_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Taiq Au khoi ràih haq, đòiq haq thê con, xau wa dìq ca mangai ta cadraq haq wèq iu tiaq Ranenh da Chuaq, broq bìac ta-atoq wa lem jang, 'màng aih èh Chuaq jah broq xìt bàu Haq khoi hùaq broq am ca Ap-ra-ham.” ");
INSERT INTO hre_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Chuaq doi: “Bàu creo ta-oih wa tajraq hlài da Sôđôm wa Gô-mô-ra khoi càn dêh dìq jaq, wa tôiq lôi da wì haq 'mèq 'mac hlòm. ");
INSERT INTO hre_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Au enh loh ti aih đòiq ngan trong wì caq ŏi i joq troi bàu khoi creo trùh ta Au ùh. Tàng ùh, Au jah loq.” ");
INSERT INTO hre_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","'Màng aih baiq ngai 'bình plình lam enh nòi aih trùh ta Sôđôm, mahaq Ap-ra-ham xôq ŏi yòng gòm enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ap-ra-ham thia haten doi: “Chuaq ôi, Ìh xôq jêh đac dŏng mangai ta-atoq pajùm ca mangai ngan dù 'mòh? ");
INSERT INTO hre_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tàng i 50 ngai ta-atoq ŏi ta phôq aih, jah 'màng leq? Chuaq xôq jêh đac dŏng wì haq 'mòh? ");
INSERT INTO hre_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Chuaq ùh jò leq broq 'màng aih! Chuaq ùh jêh đac mangai ta-atoq pajùm ti mangai dù, đòiq mangai ta-atoq chìuq da-adàng ca mangai dù! Ùh jah 'màng aih! Taiq Chuaq ma broq Yiang Hadrah dìq ca crŏng taneh, broq bìac dìq jaq ùh ta-atoq 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Chuaq tèu: “Tàng Au chaq hnoq ta Sôđôm 50 ngai caq ŏi ta-atoq, taiq wì haq aih Au ùh raliang đac dìq dŏng ca phôq.” ");
INSERT INTO hre_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ap-ra-ham doi hòm: “Chuaq ôi, 'nhac ca au cô toq xam blo taneh, au hùa pagraq dèh manoh bòch Chuaq hòm. ");
INSERT INTO hre_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ta 50 ngai mangai ta-atoq aih, tàng thìuq padam ngai, Chuaq jêh đac dŏng phôq aih ùh?” Chuaq padreo bàu doi: “Tàng Au chaq hnoq 45 ngai ta-atoq, Au ùh jêh đac dìq ca phôq.” ");
INSERT INTO hre_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ap-ra-ham xôq bòch: “Tàng ta phôq i 40 ngai raq mangai ta-atoq, èh 'màng leq?” Chuaq tèu: “Taiq i 40 ngai aih, Au ùh jêh đac dìq ca phôq.” ");
INSERT INTO hre_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ap-ra-ham bòch hòm: “Tàng ta aih i 30 raq, èh jah broq 'màng leq?” Chuaq tèu: “Tàng Au chaq hnoq ta aih i 30 ngai, èh ji ùh jêh đac.” ");
INSERT INTO hre_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ap-ra-ham bòch: “Au cô tanuq hùa capoch tùang ca Chuaq. Tàng i 20 ngai raq, èh 'màng leq hòm?” Chuaq tèu: “Taiq 20 ngai aih, Au ùh jêh dìq ca phôq.” ");
INSERT INTO hre_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ap-ra-ham bòch hòm: “Xìn Chuaq apaq nòih. Am ca au bòch hòm mòiq yàng cô raq. Tàng i 10 ngai raq ta-atoq, èh 'màng leq?” Chuaq tèu: “Taiq i 10 ngai aih, Au ùh jêh dìq ca phôq!” ");
INSERT INTO hre_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Jò khoi hêq capoch tùang ca Ap-ra-ham, èh Chuaq lam. Ap-ra-ham wìh hlài dèh ta traiq cla. ");
INSERT INTO hre_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Jò chìu, baiq ngai 'bình plình aih lam trùh Sôđôm. Jò aih Lot 'nang ha'ngui jang 'mang ngo phôq. Jò Lot hnoq wa baiq ngai 'bình plình trùh, haq yòng đìh yŏc, hi khoi haq bla-op ta taneh. ");
INSERT INTO hre_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Haq doi: “Waiq xìn chôp lam trùh ta hnem da mangai hapŏng chôp, 'nheo jènh, èh padài mang cô, xrŏih xroq èh hi lam hòm.” Wa baiq ngai tèu haq: “Ùh. Mang cô ma cùi roc trong.” ");
INSERT INTO hre_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mahaq Lot xìn rangoq, èh baiq ngai 'bình plình hi lam mùt ta hnem haq. Lot padon hiniang, bùh 'benh ùh tah blo, hi khoi wa haq caq. ");
INSERT INTO hre_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Adroi ca wa haq ca'nùng cùi, 'bài gu calô ŏi ta Sôđôm, enh 'yoh trùh craq, dìq ca jàn cadàu trùh apùq dudan ca hnem. ");
INSERT INTO hre_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","'Bài mangai aih creo ca Lot, bòch: “Baiq tamoi khoi mùt ta hnem ìh xèq cô ŏi ta leq? 'Ràng wa haq 'nòh jang cô beq, đòiq nhèn tango ca wa haq.” ");
INSERT INTO hre_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot loh thia ti wì jang 'mang, èh clenh hlài 'mang, ");
INSERT INTO hre_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","rai doi ca wì: “Cô au xìn oh daq apaq broq bìac dù aih! ");
INSERT INTO hre_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Cô, au i baiq toq con cadrì ŏi xriu, au am wa haq ca pì, khoi èh pì enh broq 'màng leq hi mac ca manoh pì enh, mahaq apaq broq 'mèq ca wa baiq ngai tau raq, ma jah 'màng aih wa haq khoi trùh ŏi đò ta hnem au mang cô.” ");
INSERT INTO hre_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mahaq wì tèu: “Ìh wia mòiq apah beq!” Wì doi hòm: “Mangai cô enh jàn 'noiq khoi trùh ŏi ta cô, èh hùa broq tìah ca mangai hadrah! Manàiq cô nhèn broq 'mèq ca ìh hamoq yi hnao ca baiq ngai tamoi tau hòm.” ");
INSERT INTO hre_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mahaq wa baiq ngai tamoi hnhu tì 'ràng Lot 'mùt ta hnem, clenh hlài 'mang. ");
INSERT INTO hre_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Èh wa haq broq ca mangai calô ŏi enh gùng ca 'mang, enh 'yoh trùh craq, dìq loh ca ùh xau mat. 'Màng aih wì haq chaq 'mang hnem khoi lep mahaq xôq ùh hnoq. ");
INSERT INTO hre_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Wa baiq ngai bòch Lot: “Cadraq da ìh akhoi tôm ta cô ùh? Con ŏng, con calô, con cadrì wa mangai leq ŏi ta phôq cô ma da ìh, 'nong wì lam khoi enh cô ma dìq beq! ");
INSERT INTO hre_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ma raliang đac nòi cô èh, ma jah 'màng aih bàu creo dang enh jàn cô khoi tŏc trùh Chuaq, dài Haq khoi thê ma loh đòiq raliang đac phôq cô.” ");
INSERT INTO hre_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot loh lam ti anoi dèh ca 'bài con ŏng ma padon ta'nèp con cadrì haq, hi doi: “Yòng beq, loh lam khoi enh nòi cô beq, ma jah 'màng aih Chuaq raliang đac phôq cô èh.” Mahaq 'bài con ŏng xoh haq capoch pagôq. ");
INSERT INTO hre_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Trùh 'ngah daxroq, wa baiq ngai bahôiq Lot rai doi: “Rìu yòng, 'nong mai ìh, baiq toq con adrùh ìh 'nang ŏi ta cô, loh lam beq, èh yùq ìh hadai ep cachìt tiaq đeh dìq ti bìac baxa phôq cô.” ");
INSERT INTO hre_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mahaq taiq Lot xôq ùh lam, 'màng aih baiq 'bình plình rùp tì haq, tì mai wa tì baiq con adrùh haq, dùi wì haq 'nong loh khoi ca phôq, taiq Chuaq loq xa-ŏch ca haq. ");
INSERT INTO hre_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Khoi èh jò wa baiq ngai 'bình plình 'nong wì loh enh gùng ca phôq, mòiq ngai 'bình plình doi ca wì haq: “Cadàu mot chaq trong rìh beq! Apaq hwi ngan hlài enh cloh, èh ji apaq yòng hlài nòi leq ta đùng tamang. Cadàu mot ta wang beq, tàng ùh 'màng aih, èh pì chìuq raliang cađac.” ");
INSERT INTO hre_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mahaq Lot tèu hlài: “Ô chôp, xìn ùh jah 'màng aih! ");
INSERT INTO hre_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Hapŏng da chôp khoi jah xôq jang ngìa chôp taiq chôp khoi pa'noh can xa-ŏch xam manoh loq waq dìq jaq đòiq dèch can rìh au, mahaq au cadàu tŏc mot wang èh yùq loq ùh tem adroi ca jò 'mèq ranàc loh, èh au chìuq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tau, pah tau i mòiq toq phôq 'yoh, yi haten đòiq au mùt mot. Xìn đòiq au mot ta phôq 'yoh aih đòiq wèq dèh can rìh.” ");
INSERT INTO hre_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","'Bình plình doi ca haq: “Jah, au nhàn bàu xìn da ìh cô. Au ùh raliang đac phôq ma ìh khoi doi aih. ");
INSERT INTO hre_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ma renh beq, cadàu mot ti aih, ma jah 'màng aih au ùh jah broq cleq trùh jò ìh khoi trùh ta aih.” Taiq nen aih dài haq wì hiniq ca phôq aih Xoa. ");
INSERT INTO hre_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mat mahì khoi loh jò Lot trùh mùt phôq Xoa. ");
INSERT INTO hre_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Khoi èh, Chuaq ca'nìh mè dahwèq ngèq wa ùnh enh plình loh bùh cheo dŏng dìq phôq Sôđôm wa Gô-mô-ra. ");
INSERT INTO hre_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","'Màng aih Haq raliang đac baiq toq phôq aih, dìq ca đùng tamang, dìq ca jàn, wa dìq ca long wa nhat ŏi nòi taneh cô. ");
INSERT INTO hre_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mahaq mai Lot hwi ngan hlài pah cloh, èh haq wìa jrang xam boh tìah ca dua 'mù mangai. ");
INSERT INTO hre_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ap-ra-ham rìu xrŏih, lam trùh nòi haq ma khoi yòng enh ngìa Chuaq hì nèh. ");
INSERT INTO hre_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Haq ha'miang ngan pah Sôđôm wa Gô-mô-ra wa jàp gùng ŏi ta đùng tamang, hnoq mòiq cato nhòi tŏc tìah ca nhòi enh tanùh ùnh càn. ");
INSERT INTO hre_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Jò Boc Plình raliang đac dìq ca phôq nòi đùng tamang, aih phôq Lot ŏi, èh hmàng trùh ca Ap-ra-ham, èh dèch Lot loh khoi nòi raliang piang aih. ");
INSERT INTO hre_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Khoi èh Lot yùq crè ŏi ta Xoa, 'màng aih haq 'nong dèh baiq toq con cadrì adrùh loh khoi nòi aih, tŏc ta wang, ŏi hloi ta mòiq toq còp hmu. ");
INSERT INTO hre_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Èh con adrùh ma daq doi dèh ca oh: “Baq ba khoi craq, mahaq pi i ca mangai calô ta crŏng taneh đòiq caq ŏi ta ba tiaq trong con mangai ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ê! Beq ba am baq ôq alac, èh lam cùi ti haq, đòiq ha'mŏt hlài adrech baq.” ");
INSERT INTO hre_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","'Màng aih wa am dèh baq ôq alac. Con adrùh ma daq trùh cùi dèh ti baq, mahaq baq haq ùh 'nì jò leq haq cùi loq jò leq haq yòng. ");
INSERT INTO hre_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Hì da èh, daq doi dèh ca oh: “Cô! Mang hnèh au khoi cùi ti baq. Mang cô ba am hòm baq ôq alac beq, khoi èh gè lam cùi ti haq đòiq ha'mŏt hlài adrech baq.” ");
INSERT INTO hre_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","'Màng aih wa am hòm dèh baq ôq alac. Khoi èh con adrùh ma oh lam cùi dèh ti baq, mahaq baq ùh 'nì jò leq con adrùh haq cùi ti haq loq jò leq con adrùh haq yòng. ");
INSERT INTO hre_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","'Màng aih, baiq toq con cadrì da Lot nhò dèh baq khoi ŏi jiang. ");
INSERT INTO hre_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mangai ma daq xa-ông jah mòiq toq con calô, hiniq haq Moap, aih boc yaq da jàn Moap trùh manàiq. ");
INSERT INTO hre_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mangai ma oh ji xa-ông mòiq toq con calô, hiniq haq Bên-am-mi, aih boc yaq jàn Amôn trùh manàiq. ");
INSERT INTO hre_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ap-ra-ham ŏi enh nòi aih lam trùh pah 'ma ca mat mahì loh, ŏi đò ta Ghêra ŏi ta'ne Cađê wa Sura. ");
INSERT INTO hre_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Jò ŏi ta aih, Ap-ra-ham anoi ca wì bìac Sara, mai haq: “Haq cô oh au”. 'Màng aih A-bi-mê-lec bùa Ghêra thê mangai lam đìh yŏc Sara. ");
INSERT INTO hre_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mahaq mang aih jò cùi, Boc Plình trùh ca bùa mahno ca haq jò apô, doi: “Cô ìh jah cachìt taiq gu cadrì ìh khoi yŏc, ma jah 'màng aih haq khoi i ŏng.” ");
INSERT INTO hre_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mahaq bùa A-bi-mê-lec 'nhòq trùh haten ca Sara, haq doi: “Waiq Chuaq, Ìh ma jêh đac dŏng mòiq toq jàn ma ùh broq tôiq 'mòh? ");
INSERT INTO hre_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Mangai aih ma ùh khoi doi ca au, Cô oh au 'mòh? Mai haq hadai khoi doi, Ap-ra-ham, haq daq calô au. Au broq bìac cô tiaq dèh manoh lem jang wa tì ŏi xriu dìq jaq da au!” ");
INSERT INTO hre_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ta jò apô, Boc Plình doi ca haq: “Au loq ca ìh i manoh lem jang ìh broq bìac aih. Taiq nen aih, Au ma khoi tàt ùh am ìh đùng trùh mangai aih đòiq broq tôiq. ");
INSERT INTO hre_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Manàiq cô am hlài gu cadrì aih ca ŏng haq beq, ma jah 'màng aih ŏng haq, aih mangai capoch thai Boc Plình jah waiq khàn am ca ìh, èh ìh jah ŏi rìh. Mahaq tàng ìh ùh am hlài mai haq, èh ìh wa dìq dŏng mangai leq ma ŏi ta ìh phai cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Bùa A-bi-mê-lec rìu xrŏih, creo dèh ca hapŏng trùh, ta'mon hlài dìq dŏng rìm nà. Wì haq hamàih yùq dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Khoi èh A-bi-mê-lec creo ca Ap-ra-ham, doi ca haq: “Ìh broq cleq ca au 'màng cô? Au khoi broq bìac tôiq leq ca ìh ma thê ìh broq nà cô ca au wa diac au 'màng cô?” ");
INSERT INTO hre_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Bùa A-bi-mê-lec doi hòm ca Ap-ra-ham: “Ìh khoi broq trong ma ùh khòh broq. Bìac leq ma thê ìh broq 'màng cô?” ");
INSERT INTO hre_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ap-ra-ham tèu: “Au hèm joq ta gùng cô ùh i cabô loq yùq crè Boc Plình, èh taiq mai au wì haq jêh đac au. ");
INSERT INTO hre_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Mahaq joq 'nàng haq oh au, oh mòiq baq, miq crài. Au yŏc haq broq mai. ");
INSERT INTO hre_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Jò Boc Plình broq au ep lam lac hangai ca hnem baq, èh au doi ca haq: ‘Cô xôq da gè jah broq am ca au, nòi leq ba jah lam trùh, gè anoi ca wì, “au cô daq gè.” ’ ” ");
INSERT INTO hre_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Èh bùa A-bi-mê-lec 'ràng trìu, 'bo, hapŏng calô, hapŏng cadrì am ca Ap-ra-ham, wa am hlài da haq Sara mai haq. ");
INSERT INTO hre_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A-bi-mê-lec doi: “Cô gùng da au enh ngìa ca ìh. Ìh loq enh nòi leq, ìh ŏi ta aih oq.” ");
INSERT INTO hre_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Khoi èh bùa doi ca Sara: “Cô, au khoi am ca daq ìh 1.000 capiac 'bac đòiq pachàuq hlài tìang 'bang ìh, 'màng aih tìang 'bang ìh jah wìa lem lình hlài enh ngìa rìm ngai.” ");
INSERT INTO hre_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ap-ra-ham waiq xìn Boc Plình, èh Boc Plình broq brêh ca bùa A-bi-mê-lec, mai haq wa hapŏng cadrì haq đòiq dìq ca wì haq jah i con. ");
INSERT INTO hre_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Jò adroi taiq bìac Sara, mai Ap-ra-ham, dài haq Chuaq broq dìq dŏng ca hnem bùa A-bi-mê-lec dìq loh ca xon. ");
INSERT INTO hre_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Manàiq cô Chuaq broq am ca Sara tiaq troi dèh bàu Haq khoi doi adroi. ");
INSERT INTO hre_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara ŏi jiang, èh xa-ông am ca Ap-ra-ham mòiq toq con calô jò haq khoi craq, troq dèh jò Boc Plình ma khoi pajaq. ");
INSERT INTO hre_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ap-ra-ham hiniq dèh ca con calô ma Sara khoi xa-ông ca haq, aih Isac. ");
INSERT INTO hre_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Trùh rahem hì, Ap-ra-ham broq ranenh cat akia ca Isac tiaq bàu Boc Plình khoi thê. ");
INSERT INTO hre_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Jò Isac xa-ông loh, Ap-ra-ham khoi jah 100 hanam. ");
INSERT INTO hre_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara doi: “Boc Plình khoi broq ca au jah do, èh dìq ca mangai leq hìa, hadai jah do ca bìac au.” ");
INSERT INTO hre_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Haq doi hòm: “Cabô ma hùa doi ca Ap-ra-ham, èh Sara jah i con am ùq? Mahaq au khoi xa-ông mòiq toq con calô jò au khoi craq.” ");
INSERT INTO hre_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Con aih rai yòng càn, èh cađac tôh. Wop hì Isac cađac tôh, Ap-ra-ham padon hiniang càn caq manè. ");
INSERT INTO hre_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara hnoq con calô da Aga mangai Aicàp, khoi xa-ông ca Ap-ra-ham, do lê. ");
INSERT INTO hre_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Taiq 'màng aih, haq doi ca Ap-ra-ham: “Phai hnan đac hapŏng 'yoh meh wa con haq lam beq, ma jah 'màng aih con calô da hapŏng 'yoh cô ùh jah pajùm cùng hang ti con calô au, aih Isac.” ");
INSERT INTO hre_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Bàu capoch cô broq ca Ap-ra-ham mango dìq jaq, taiq con calô aih con da cla haq. ");
INSERT INTO hre_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mahaq Boc Plình doi ca Ap-ra-ham: “Ìh apaq mango dèh ca con calô wa hapŏng ìh, Aga. Sara doi 'màng leq, ìh phai broq tiaq bàu haq, ma jah 'màng aih xinoi ìh, dìq loh enh Isac. ");
INSERT INTO hre_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Au hadai am con calô da hapŏng ìh wìa mòiq jàn, ma jah 'màng aih haq hadai loh enh ìh.” ");
INSERT INTO hre_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ap-ra-ham rìu xrŏih, yŏc 'benh wa mòiq cabi diac am ca Aga, đòiq dahwèq aih ti aplêh haq, am da haq con calô, èh thê haq lam. Aga hi loh lam lìq lam làn ta braih càn Bê-e-sê-ba. ");
INSERT INTO hre_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Jò diac ta cabi khoi dìq, Aga đòiq dèh con enh 'neq mòiq xèm long 'yoh. ");
INSERT INTO hre_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Khoi èh haq lam ha'ngui ta jang ca aih mòiq apenh panenh, hmoi rai doi: “Ôi! Au ùh manaq hnoq dèh con cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Boc Plình tàng bàu crò da con calô, èh 'bình plình da Boc Plình enh Plình creo ca Aga, doi: “Ôi Aga, bìac cleq 'mat? Apaq crè, ma jah 'màng aih Boc Plình khoi tàng bàu crò da con calô ŏi ta meh. ");
INSERT INTO hre_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Yòng beq, rùp tì haq dèch haq yòng. Au jah broq ca haq wìa mòiq diac jàn càn.” ");
INSERT INTO hre_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Khoi ca aih, Boc Plình pèh mat Aga. Haq hi hnoq mòiq toq diac adràm. Haq lam trùh 'mùt bình mòiq cabi 'ràng ca con haq ôq. ");
INSERT INTO hre_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Boc Plình wèq ban con calô aih. Haq rai èh rai càn, rìh ŏi ta nòi braih càn. Khoi èh haq wìa thài ca bìac penh panenh. ");
INSERT INTO hre_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Haq rìh ŏi ta nòi braih càn Paran. Miq haq ta'nèp ca haq mòiq toq mai enh gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Jò aih bùa A-bi-mê-lec wa craq lình Phicôn, mangai ma wèq dìq ca lình, doi ca Ap-ra-ham: “Boc Plình ŏi ti ìh tiaq rìm bìac ìh broq. ");
INSERT INTO hre_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","'Màng aih, manàiq cô enh ngìa Boc Plình, ìh phai pachac èh ìh ùh hìaq broq bìac amòng ca au, con au, wa xinoi au, mahaq tiaq trong au ma xa-ŏch ca ìh, ìh khòh xa-ŏch ca au wa wì ta nòi ìh 'nang ŏi.” ");
INSERT INTO hre_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ap-ra-ham tèu: “Au pachac.” ");
INSERT INTO hre_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mahaq Ap-ra-ham mamùc ca bùa A-bi-mê-lec bìac diac adràm ma hapŏng haq ta'miaq yŏc. ");
INSERT INTO hre_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Bùa A-bi-mê-lec doi ca haq: “Au ùh 'nì cabô khoi broq bìac aih. Ìh ùh doi ca au, èh au ùh tàng cleq trùh jò hì cô.” ");
INSERT INTO hre_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Khoi èh, Ap-ra-ham 'ràng trìu wa 'bo am ca bùa A-bi-mê-lec, èh wa haq wêh jao ca dabau. ");
INSERT INTO hre_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ap-ra-ham ràih tam đòiq nòi ŏi crài ca calùh, tapèh toq trìu adrùh. ");
INSERT INTO hre_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Èh bùa A-bi-mê-lec bòch haq: “Ìh đòiq crài broq cleq ca tapèh toq trìu adrùh 'mat?” ");
INSERT INTO hre_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ap-ra-ham tèu: “Bùa nhàn yŏc tapèh toq trìu adrùh cô enh tì cŏng cla au beq đòiq broq teo jah loq au ma chìa diac adràm cô.” ");
INSERT INTO hre_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","'Màng aih wì hiniq nòi aih Bê-e-sê-ba, ma jah 'màng aih jang aih wa baiq ngai khoi pachac ti dabau. ");
INSERT INTO hre_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","'Màng aih wa baiq ngai khoi wêh jao ti dabau ta Bê-e-sê-ba. Khoi ca aih, bùa A-bi-mê-lec wa Phicôn, cwan càn wèq dìq ca lình haq, wìh hlài ta gùng Phi-li-tin. ");
INSERT INTO hre_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ap-ra-ham pìt mòiq xèm long me jang Bê-e-sê-ba, ŏi jang aih haq waiq dang hiniq ca Chuaq ma rìh hloi hloi. ");
INSERT INTO hre_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ap-ra-ham ŏi dùnh hì ta gùng Phi-li-tin. ");
INSERT INTO hre_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Atìq ca aih, Boc Plình 'bàt thù manoh Ap-ra-ham. Chuaq creo: “Ôi Ap-ra-ham!” Ap-ra-ham tèu: “I au cô.” ");
INSERT INTO hre_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Boc Plình doi: “Yŏc Isac, con mòiq ìh ma loq waq dèh dìq ca jaq, lam trùh gùng Mô-ri-a, nòi aih am con calô ìh broq ngè tadreo bùh ŏi ta bôi wang tau, Au ma patô ca ìh.” ");
INSERT INTO hre_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ap-ra-ham rìu xrŏih, còi lùa, 'ràng Isac wa baiq ngai hapŏng radam lam tiaq haq. Haq coh long ùnh wê đòiq broq bùh ngè tadreo, èh lam trùh nòi ma Boc Plình khoi patô. ");
INSERT INTO hre_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Trùh hì piq, Ap-ra-ham ngoi ngan hnoq nòi aih enh hangai. ");
INSERT INTO hre_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Èh haq doi dèh ca baiq ngai hapŏng: “Chôp ŏi jang cô gòm lùa, ma con calô cô lam trùh nòi tau đòiq cùh waiq, khoi gêh èh ma wìh hlài ti chôp.” ");
INSERT INTO hre_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ap-ra-ham yŏc long ùnh đòiq broq bùh ngè tadreo, tah enh crŏng Isac con haq, cla haq wê ùnh wa chang ta tì, èh wa baq con lam pajùm. ");
INSERT INTO hre_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isac doi: “Baq ôi!” Ap-ra-ham tèu: “Con ôi, cô baq.” Isac bòch: “Ùnh wa long ùnh khoi padon, mahaq trìu con ta leq đòiq broq ngè tadreo bùh?” ");
INSERT INTO hre_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ap-ra-ham tèu haq: “Con ôi, Boc Plình jah padon am trìu con broq ngè tadreo bùh.” Èh baq wa con cadiang lam hloi. ");
INSERT INTO hre_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Wa lam trùh nòi Boc Plình khoi patô. Ap-ra-ham broq mòiq toq ca'bŏng tadreo, đòiq long ùnh enh 'nhèq ca'bŏng tadreo, càt dèh con Isac đòiq enh 'nhèq ca long ùnh ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ap-ra-ham hi 'nòh tì yŏc chang đòiq jêh dèh con. ");
INSERT INTO hre_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","'Bình Plình da Chuaq enh plình creo, doi: “Ap-ra-ham! Ap-ra-ham!” Ap-ra-ham tèu: “I au cô.” ");
INSERT INTO hre_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","'Bình Plình thê haq, doi: “Apaq jêh haq, hadai apaq broq cleq trùh haq, ma jah 'màng aih manàiq cô au khoi loq, ìh joq yùq crè Boc Plình, taiq ìh ùh adenh dèh ca con, aih con mòiq da ìh.” ");
INSERT INTO hre_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ap-ra-ham blèch mat ngan hnoq mòiq toq con trìu calô 'bìq hlac xam aki ti long ramù yila. Ap-ra-ham lam rùp con trìu calô broq ngè tadreo bùh thai ca con dađeh. ");
INSERT INTO hre_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ap-ra-ham hiniq nòi aih: Chuaq Padon Đòiq Am, ma jah 'màng aih trùh manàiq cô wì xôq doi: “Ŏi ta wang da Chuaq, khoi i ngè padon đòiq am.” ");
INSERT INTO hre_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","'Bình Plình da Chuaq creo ca Ap-ra-ham yàng baiq enh plình, ");
INSERT INTO hre_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Chuaq doi: “Taiq ìh khoi broq bìac aih, ìh ùh adenh dèh ca con calô, aih con mòiq da ìh, cla Au cô ma pachac, ");
INSERT INTO hre_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","jah am xôq ramŏt ca ìh, tam xinoi ìh bàc tìah ca halŏng ta plình, bàc tìah ca braih ta 'bò diac raxìq, wa xinoi ìh jah tablah yŏc 'mang ngo phôq lình ma git ca wì. ");
INSERT INTO hre_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Taiq ìh khoi iu tiaq bàu Au tanap, nhò adrech xinoi ìh, dìq ca jàn ŏi crŏng taneh jah xôq ramŏt.” ");
INSERT INTO hre_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Khoi ca aih, Ap-ra-ham wìh hlài ta baiq ngai hapŏng, èh dìq ca wì haq wìh hlài ta Bê-e-sê-ba, ta nòi Ap-ra-ham xôq ŏi dùnh. ");
INSERT INTO hre_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Atìq ca dìq bìac aih, i wì anoi hlài ca Ap-ra-ham bìac cô, doi: “Mincah hadai xa-ông con ca Nacô, oh ìh.” ");
INSERT INTO hre_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Con ramua calô, aih Uxò, oh calô, aih Buxò, Kê-mu-ên, baq da Aram. ");
INSERT INTO hre_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kêsêt, Haxô, Pinđat, Jitlap, wa Bê-tu-ên. ");
INSERT INTO hre_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bê-tu-ên wìa baq da Rê-bê-ca. Mincah xa-ông rahem ngai con calô aih am ca Nacô, oh da Ap-ra-ham. ");
INSERT INTO hre_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Rê-u-ma, mai yang da Nacô, hadai xa-ông con: Têba, Gaham, Tahach, wa Ma-a-ca. ");
INSERT INTO hre_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara halình jah 127 hanam. ");
INSERT INTO hre_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara cachìt ta Ki-ri-at A-ra-ba, aih Hêprôn, ŏi ta gùng Ca-na-an. Ap-ra-ham ha-on hmoi dèh ca haq. ");
INSERT INTO hre_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ap-ra-ham yòng jang nòi hanang, xìn cadraq xinoi Hêt doi: ");
INSERT INTO hre_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Au mangai tamoi enh hangai neo lam ŏi ta cô ti pì. Xìn pì tech ca au mòiq nòi ŏi ta gùng pì đòiq broq cadràng hanang, đòiq au catùh hanang dèh mai.” ");
INSERT INTO hre_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Xinoi Hêt tèu haq: ");
INSERT INTO hre_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Òq, nhèn ngan ìh mangai đang jah padèch ha'nhèq tìah ca con bùa i cwìang ŏi ta'ne nhèn. Ìh enh ràih taneh leq broq cadràng hanang, hi mac ca ìh. Ùh i ca mangai leq ma adenh dèh ca cadràng đòiq ìh catùh mangai cachìt da ìh.” ");
INSERT INTO hre_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ap-ra-ham yòng cùp gàu enh ngìa ca jàn gùng aih, aih jàn xinoi Hêt. ");
INSERT INTO hre_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Haq doi: “Tàng pì lem manoh am au catùh dèh mangai cachìt, xìn pì doi ca Eprôn, con calô Xôha, ");
INSERT INTO hre_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","xìn haq bùi manoh tech ca au còp hmu Mac-bê-la ŏi ta nòi lùch đùng haq. Enh ngìa ca pì, au rŏt tiaq troq jaq đòiq au jah i mòiq nòi broq cadràng hanang ŏi ta gùng pì.” ");
INSERT INTO hre_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","'Màng aih, Eprôn, mangai Hêtit 'nang ha'ngui ti mangai jàn xinoi Hêt, tèu hlài Ap-ra-ham enh ngìa ca jàn ta 'mang ngo phôq, doi: ");
INSERT INTO hre_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ôi Chuaq, xìn tamàng bàu au: Cô enh ngìa ca jàn au, au xìn am ca ìh đùng taneh wa hadai am hloi còp hmu ŏi ta aih. Catùh da ìh mangai cachìt beq!” ");
INSERT INTO hre_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ap-ra-ham mòiq yàng hòm cùp gàu enh ngìa ca jàn gùng aih, ");
INSERT INTO hre_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","hi doi ca Eprôn enh ngìa ca mangai jàn gùng aih ma 'nang tamàng: “Au xìn rŏt hlài troq jaq, xìn ìh bùi manoh nhàn 'bac, èh au men hùa catùh dèh mangai cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eprôn tèu haq: ");
INSERT INTO hre_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ôi Chuaq, xìn tamàng au. Mòiq ha'nech taneh, cùng haq 400 hliac 'bac, mahaq ta'ne ba ma broq bua, 'bac jèn ùh nhet toq leq Xìn ìh catùh dèh mangai cachìt beq.” ");
INSERT INTO hre_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ap-ra-ham tàng bàu Eprôn doi 'màng aih enh ngìa ca jàn xinoi Hêt, èh haq yŏc 400 hliac 'bac am ca Eprôn tiaq jaq 'bac padro jò aih. ");
INSERT INTO hre_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","'Màng aih Ap-ra-ham rŏt đùng taneh da Eprôn ta Mac-bê-la ŏi pagat Mamrê, aih đùng, còp hmu, wa dìq ca long ta đùng wa ti kenh tiaq dèh acang aih. ");
INSERT INTO hre_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Dìq dŏng wìa xôxech Ap-ra-ham, nhò wa haq baiq ngai mòiq manoh enh ngìa ca jàn xinoi Hêt ta 'mang ngo phôq. ");
INSERT INTO hre_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Atìq ca aih Ap-ra-ham catùh hanang Sara, mai haq ta còp hmu ta đùng taneh Mac-bê-la ŏi pagat Mamrê ta Hêprôn, gùng Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Đùng taneh wa còp hmu aih khoi jah jàn Hêt tech ca Ap-ra-ham đòiq broq cadràng hanang. ");
INSERT INTO hre_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Manàiq cô Ap-ra-ham khoi craq. Chuaq khoi am ca haq xôq ramŏt bàc rìm trong. ");
INSERT INTO hre_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ap-ra-ham doi dèh ca hapŏng ma ŏi yi dùnh ta hnem, haq ma wèq cwìang dìq ca cùng hang haq: “Xìn đòiq tì ìh enh 'neq cataih au, ");
INSERT INTO hre_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","èh au thê ìh pachac nhò hiniq Chuaq da Diac Plình wa taneh, ìh ùh yŏc mòiq ngai cadrì leq ta gu cadrì Ca-na-an đòiq broq mai Isac con au, 'nhac ca au ŏi ta gùng wì haq, ");
INSERT INTO hre_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","mahaq ìh phai hlài gùng au, yŏc mòiq ngai cadrì enh oh daq au, broq mai ca Isac, con calô au.” ");
INSERT INTO hre_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mangai hapŏng tèu, bòch: “Tàng gu cadrì leq aih ùh chìuq tiaq au hlài gùng cô, au akhòh 'ràng Isac con calô ìh trùh gùng ìh ma khoi cađac nèh ùh?” ");
INSERT INTO hre_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ap-ra-ham doi ca haq: “Joq 'nàng ùh! Ìh ùh jò leq jah 'ràng Isac trùh gùng aih. ");
INSERT INTO hre_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Chuaq da Diac Plình ma khoi 'ràng au loh khoi hnem baq au wa gùng au, i pachac doi: Au jah am ca xinoi ìh gùng cô, Haq thê dèh 'bình plình lam adroi ca ìh, wa enh nòi aih ìh jah yŏc mòiq ngai broq mai ca con calô au. ");
INSERT INTO hre_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tàng mangai cadrì ùh waq tiaq, èh ìh ùh hìaq pòq bàu au ma thê ìh pachac, mahaq 'nhac ca 'màng leq, ji apaq 'ràng con au hlài gùng aih.” ");
INSERT INTO hre_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","'Màng aih, hapŏng đòiq tì enh 'neq cataih Ap-ra-ham, craq dađeh wa pachac broq tiaq troi bàu Ap-ra-ham ma tanap. ");
INSERT INTO hre_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Khoi èh mangai hapŏng aih ràih 10 toq lŏcđa da craq haq, 'ràng tiaq cùng hang da craq haq ma khoi jao, hi yòng lam cwa gùng Mê-sô-bô-ta-mi, trùh phôq Nacô. ");
INSERT INTO hre_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Haq thê lŏcđa hacùn cràng padài ŏi enh gùng ca phôq hatenh ca diac adràm, wop jò chìu jò ma con cadrì lam yŏc diac. ");
INSERT INTO hre_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Haq doi: “Ôi Chuaq, Boc Plình da Ap-ra-ham, craq au, hì cô xìn am ca au glàm bìac au ma chaq, waq ca patô can xa-ŏch xam manoh loq waq da Ìh am ca Ap-ra-ham. ");
INSERT INTO hre_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Cô au yòng jang diac adràm cô, èh gu cadrì ta phôq cô loh yŏc diac. ");
INSERT INTO hre_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Xìn am mangai cadrì adrùh leq ma au capoch 'màng cô: ‘Xìn oh cachình cabi diac au ôq,’ èh haq tèu: ‘Ôq beq, hi khoi au am 'bài lŏcđa ìh ôq dìq.’ Aih raq mangai ma Chuaq khoi pachì đòiq ca Isac, mangai hapŏng Ìh. Nhò tiaq aih, au jah loq Chuaq khoi patô can xa-ŏch xam manoh loq waq am xôq ca craq au.” ");
INSERT INTO hre_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Mangai hapŏng cô capoch 'nhòq dìq dèh ca bàu, tau khoi hnoq Rê-bê-ca xùi cabi diac aplêh loh gôch diac. Haq con cadrì da Bê-tu-ên, con calô da Mincah, aih mai Nacô, oh calô Ap-ra-ham. ");
INSERT INTO hre_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mangai cadrì adrùh cô lem ngan dìq jaq, haq ŏi xriu, 'nhòq lah cùi ti gu calô. Haq loh ta diac adràm gôch diac bình ta cabi, hi khoi haq tŏc. ");
INSERT INTO hre_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Mangai hapŏng lam trùh enh ngìa haq bòch haq: “Xìn mon am au ôq mòiq ralŏn diac ta cabi oq.” ");
INSERT INTO hre_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mangai cadrì aih tèu: “Ôi Chuaq, ôq beq.” Khoi haq dahôiq, 'nòh dèh cabi enh palêh am ca mangai aih ôq. ");
INSERT INTO hre_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Jò haq am mangai aih ôq gêh, haq doi: “Au hadai am ca lŏcđa ìh ôq dìq, jò leq ôq mech èh men hêq.” ");
INSERT INTO hre_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Haq dahôiq ùc 'noh diac ta atong, cadàu loh diac adràm 'mùt tam diac, am dìq ca lŏcđa ôq. ");
INSERT INTO hre_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mangai hapŏng aih ŏi hatenh ngan Ra-bê-ca, wa hèm ta manoh waq ca loq cla haq aih joq mangai ma Chuaq enh patô. ");
INSERT INTO hre_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Jò lŏcđa ôq bu hêq, mangai hapŏng aih yŏc mòiq pliang canhàng wang trap 7 gm wa mòiq đôi maih wang trap jah 110 gm, ");
INSERT INTO hre_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","èh bòch: “Mon con cabô? Xìn doi ca au loq, ta hnem baq oh, i ca nòi au jah padài đò mang cô ùh?” ");
INSERT INTO hre_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Haq tèu: “Au cô con Bê-tu-ên, xau pah baq da Mincah wa Nacô. ");
INSERT INTO hre_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ta hnem nhèn i bàc hri wa nhat, èh hadai i nòi đòiq mangai tamoi ŏi padài.” ");
INSERT INTO hre_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mangai hapŏng cô cùp gàu, cùh waiq Chuaq, doi: ");
INSERT INTO hre_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Đang ca manè Chuaq, Boc Plình da Ap-ra-ham, craq au. Haq i can xa-ŏch xam manoh loq waq loq wèq dèh bàu ca craq au taiq jò au 'nang lam, Haq khoi ajèn au trùh hnem oh daq craq au.” ");
INSERT INTO hre_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mangai adrùh aih cadàu hlài anoi hlài bìac cô ta hnem miq haq. ");
INSERT INTO hre_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rê-bê-ca i mòiq ngai daq calô hiniq haq Laban. Laban cadàu trùh ti mangai hapŏng tau ŏi haten ca diac adràm. ");
INSERT INTO hre_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Bu hnoq canhàng wa mòiq đôi maih nòi tì oh cadrì dađeh, wa khoi tàng bàu Rê-bê-ca anoi hlài bìac mangai hapŏng doi bàu 'màng leq, èh Laban lam trùh ta mangai hapŏng 'nang yòng dèh ti 'bài lŏcđa ŏi kenh diac adràm. ");
INSERT INTO hre_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban doi: “Ôi mangai ma Chuaq khoi am xôq ramŏt, gleq ìh yòng enh gùng cô. Xìn ìh mùt ta hnem au. Au khoi padon nòi ìh jah padài, hadai i nòi ca lŏcđa ìh hòm.” ");
INSERT INTO hre_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mangai hapŏng cô tiaq Laban mùt ta hnem, èh Laban yŏc 'noh dahwèq enh lŏcđa, hi 'ràng hri wa nhat am ca wì haq caq. Khoi èh haq yŏc diac am ca mangai hapŏng wa mangai tiaq haq 'nheo jènh. ");
INSERT INTO hre_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Khoi èh Laban padon pua pachùh caq, mahaq mangai hapŏng aih doi: “Au ùh caq, ùh ôq trùh jò au pa'noh bìac leq taiq nen au trùh ta cô.” Laban doi: “Bìac cleq anoi beq!” ");
INSERT INTO hre_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Mangai hapŏng aih doi: “Au hapŏng Ap-ra-ham. ");
INSERT INTO hre_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Chuaq khoi am xôq ramŏt ca craq au bàc phàn loh ca padrŏng can. Haq am ca craq au trìu, 'bo, 'bac, wang, hapŏng cadrì, hapŏng calô, lŏcđa wa lùa. ");
INSERT INTO hre_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, mai craq au jò craq i xa-ông mòiq toq con calô ca haq. Haq jao dŏng cùng hang ca con calô aih. ");
INSERT INTO hre_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Craq au thê au pachac doi: Ìh ùh jah ta'nèp ca con calô au mòiq toq mai leq ta 'bài con cadrì jàn Ca-na-an, gùng au ma 'nang ŏi manàiq, ");
INSERT INTO hre_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","mahaq ìh phai hlài ta hnem baq au, ta 'bài oh daq au, yŏc ca haq mòiq toq mai ta aih. ");
INSERT INTO hre_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Au doi ca craq au: ‘Tàng con cadrì leq aih ùh chìuq tiaq au hlài, èh au broq 'màng leq?’ ");
INSERT INTO hre_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Haq doi ca au: Chuaq ma au patìh, jah thê 'bình plình Haq lam tiaq ìh, broq đòiq jah gêh bìac ìh ma lam. Khoi èh ìh jah yŏc ca con calô au mòiq ngai mai enh 'bài oh daq au. ");
INSERT INTO hre_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","'Màng aih, jò ìh hlài ta hnem oh daq au, èh wì ùh am dèh con, ìh ùh hìaq pòq bàu pachac ìh ma khoi pachac ca au aih. ");
INSERT INTO hre_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Hì cô jò lam trùh ta diac adràm tau, au i waiq khàn doi: ‘Waiq Chuaq, Boc Plình da Ap-ra-ham, craq au, xìn Ìh jùp bìac au ma lam ta cô, jah wìa. ");
INSERT INTO hre_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Jò au yòng haten diac adràm cô, waiq xìn mangai cadrì adrùh leq loh gôch diac, èh au doi ca haq: xìn am ca au ôq mòiq ralŏn diac enh cabi, ");
INSERT INTO hre_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","èh haq tèu: “Ôq beq, au hadai gôch ca lŏcđa da ìh ôq dìq.” Au xìn Chuaq am mangai cadrì adrùh aih broq mai ma Chuaq khoi pachì am ca con calô craq au.’ ");
INSERT INTO hre_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Au 'nhòq lùch ca bàu waiq xìn, èh hnoq Rê-bê-ca xùi cabi diac aplêh, loh ta diac adràm gôch diac. Au bòch haq am ca au ôq mòiq ralŏn diac. ");
INSERT INTO hre_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Haq dahôiq 'noh dèh cabi diac enh plêh rai doi: ‘Ôq beq, khoi au hadai gôch diac ca lŏcđa ìh ôq dìq.’ 'Màng aih au hi ôq. Haq hadai i gôch ca lŏcđa ôq dìq. ");
INSERT INTO hre_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Au bòch: ‘Oh con cabô?’ “Haq tèu: ‘Au con cadrì da Bê-tu-ên, oh daq pah baq da Nacô wa Mincah.’ “ 'Màng aih au yŏc canhàng ta'mac da haq jang mùh wa mòiq đôi maih ta acŏng tì haq. ");
INSERT INTO hre_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Hi khoi au cùp gàu cùh waiq Chuaq, manè apôi Boc Plình da Ap-ra-ham, craq au, ma jah 'màng aih Haq khoi ajèn au lam troq trong đòiq ràih jah ca con calô haq, con cadrì da oh craq au. ");
INSERT INTO hre_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","'Màng aih, tàng pì yŏc manoh khôn khaoq broq tiaq craq au, èh doi jah, loq ùh jah, đòiq au jah loq au phai broq cleq manàiq.” ");
INSERT INTO hre_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban wa Bê-tu-ên tèu: “Bìac aih loh dìq enh Chuaq. Ma ùh hùa doi jah, loq ùh jah. ");
INSERT INTO hre_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Cô Rê-bê-ca 'nang ŏi enh ngìa ìh. 'Nong haq lam beq đòiq haq jah broq mai da con calô craq ìh tiaq bàu Chuaq khoi pachì.” ");
INSERT INTO hre_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Hapŏng Ap-ra-ham tàng bàu wa baiq ngai capoch bu gêh, tajòi 'mòi haq hacùn cràng cùh waiq Chuaq. ");
INSERT INTO hre_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Khoi èh mangai hapŏng yŏc ngè anì xam 'bac, wang, wa eo yôh am ca Rê-bê-ca. Haq hadai yŏc dahwèq canaq am ca daq haq wa miq haq. ");
INSERT INTO hre_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Mangai hapŏng wa 'bài mangai tiaq haq ha'ngui caq, ôq, cùi ta aih dìq ca mang aih. Jò rìu daxroq, mangai hapŏng doi: “Xìn am au wìh hlài dèh hnem craq au beq.” ");
INSERT INTO hre_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mahaq daq haq wa miq gu cadrì doi: “Đòiq con cadrì adrùh cô ŏi tam ti nhèn 10 hì hòm, èh haq hi lam.” ");
INSERT INTO hre_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mahaq Ê-li-ê-se doi: “Xìn apaq patrò au, ma jah 'màng aih Chuaq khoi broq bìac đòiq trong au lam jah wìa. Am au lam beq đòiq au hlài dèh hnem craq au.” ");
INSERT INTO hre_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Wa haq tèu: “Ma creo Rê-bê-ca, bòch thù manoh haq 'màng leq.” ");
INSERT INTO hre_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Wa haq creo ca Rê-bê-ca bòch: “Con enh lam ti mangai cô ùh?” Haq tèu: “Au enh lam.” ");
INSERT INTO hre_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","'Màng aih, wì haq am Rê-bê-ca, wa mangai ma ban haq enh jò haq ŏi 'yoh, hlài tiaq mangai hapŏng da Ap-ra-ham wa 'bài mangai ma tiaq. ");
INSERT INTO hre_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wì haq waiq xôq ramŏt am ca Rê-bê-ca, doi: “Oh ôi! Waiq ca oh cadrì da nhèn jah wìa miq da bình trìuq mangai wa am ca xinoi oh jah blah yŏc 'mang ngo phôq da mangai ma tagit ca wì.” ");
INSERT INTO hre_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rê-bê-ca wa 'bài hapŏng haq hi tŏc lŏcđa tiaq mangai hapŏng aih. 'Màng aih mangai hapŏng aih 'nong Rê-bê-ca lam. ");
INSERT INTO hre_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Manàiq cô Isac ma ŏi nòi pah 'ma ca mat mahì loh, hlài enh nòi Bê-la-cha-roi. ");
INSERT INTO hre_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Jò chìu Isac lam ta đùng hèm haboq. Haq blèch mat hi ngan tau hnoq lŏcđa lam trùh. ");
INSERT INTO hre_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rê-bê-ca hadai blèch mat ngan. Jò haq hnoq Isac, haq hadrùc loh enh crŏng lŏcđa. ");
INSERT INTO hre_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Taiq adroi ìq, haq khoi bòch mangai hapŏng: “Mangai ma lam ŏi ta đùng tau enh ngìa ca bèn, cabô?” Mangai hapŏng tèu: “Haq con craq au.” Tajòi 'mòi, Rê-bê-ca yŏc mù ratang chê dèh hadrò. ");
INSERT INTO hre_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mangai hapŏng anoi ca Isac tàng dìq ca bìac haq khoi broq. ");
INSERT INTO hre_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isac 'mùt Rê-bê-ca mùt ta traiq Sara, miq haq, ta'nèp broq mai. Isac dìq jaq loq waq haq. 'Màng aih, Isac khoi jah alòng jò haq mango dèh ca miq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ap-ra-ham yŏc mòiq ngai gu cadrì 'noiq broq mai, hiniq haq Kê-tu-ra. ");
INSERT INTO hre_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Haq xa-ông ca Ap-ra-ham Ximran, Jocsan, Mêđan, Ma-đi-an, Ichbac, Suah. ");
INSERT INTO hre_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsan wìa baq da Sêba wa Đêđan. Con calô da Đêđan, aih A-chu-rim, Lê-lu-chim wa Lê-u-mim. ");
INSERT INTO hre_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Con calô da Ma-đi-an, aih Êpha, Êphe, Hanoc, A-bi-đa wa Ênđa. Dìq ca mangai cô raq xinoi da Kê-tu-ra. ");
INSERT INTO hre_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ap-ra-ham am dŏng dìq ca Isac cùng hang haq, mahaq haq am 'bac ca 'bài con xinoi ma 'noiq, ");
INSERT INTO hre_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","khoi èh jò haq ŏi rìh, haq thê wì lam cwa ŏi ta gùng pah mat mahì loh, hangai ca Isac. ");
INSERT INTO hre_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ap-ra-ham halình jah 175 hanam. ");
INSERT INTO hre_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Jò haq cachìt, chac haq khoi craq hanam khoi bàc, wa khoi i manoh bùi lem ca 'nhòng rìh dađeh, èh jah lam nòi boc yaq. ");
INSERT INTO hre_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Baiq toq con calô haq, aih Isac wa Ich-ma-ên, catùh haq ta còp hmu Mac-bê-la, haten Mamrê, ta tamang đùng Eprôn, con calô Xôha, mangai Hêtit, ");
INSERT INTO hre_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","aih tamang đùng adroi cô nèh Ap-ra-ham rŏt da con calô Hêt. Ta nòi aih raq wì catùh Ap-ra-ham pajùm Sara, mai haq. ");
INSERT INTO hre_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Atìq ca Ap-ra-ham cachìt, Chuaq am xôq ramŏt ca Isac, con calô Ap-ra-ham. Isac ŏi hatenh ca diac adràm Bê-la-cha-roi. ");
INSERT INTO hre_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Cô xinoi Ich-ma-ên con calô Aga xa-ông ca Ap-ra-ham. Aga, mangai Aicàp, hapŏng da Sara. ");
INSERT INTO hre_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Cô jàiq achìh hiniq 'bài con calô ca xinoi Ich-ma-ên: Con ramua aih Nê-ba-jôt, atìq ca haq Kêđa, At-bê-ên, Mipsam, ");
INSERT INTO hre_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Michma, Đuma, Masa, ");
INSERT INTO hre_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hađat, Têma, Jêthu, Naphich wa Kêtma. ");
INSERT INTO hre_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Aih 10 baiq con calô da Ich-ma-ên broq cwan càn da 12 plài hadai i hiniq plài tiaq wì haq. ");
INSERT INTO hre_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ich-ma-ên halình jah 137 hanam, èh cachìt, lam nòi boc yaq. ");
INSERT INTO hre_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Xinoi haq rìh ŏi ta gùng haten taneh da xinoi Isac, enh Ha-wi-la trùh Sura ŏi pah mat mahì loh ca Aicàp trùh nòi A-si-ri. ");
INSERT INTO hre_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Cô xinoi da Isac, con calô Ap-ra-ham. ");
INSERT INTO hre_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Jò Isac jah 40 hanam, haq yŏc Rê-bê-ca, con cadrì da Bê-tu-ên, wa oh cadrì Laban, aih jàn Aram, ŏi ta gùng Pađan Aram. ");
INSERT INTO hre_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isac waiq xìn Chuaq ca mai dađeh, ma jah 'màng aih mai haq xon. Chuaq tèu bàu waiq xìn aih, hi am Rê-bê-ca ŏi jiang. ");
INSERT INTO hre_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Mahaq taiq con camia ta cliac tajêh dabau, Rê-bê-ca doi: “Gleq bìac cô loh ca au?” Haq bòch Chuaq. ");
INSERT INTO hre_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Chuaq tèu haq: “Baiq jàn 'nang ŏi ta cliac ìh. Èh mòiq jàn wìa yi dêh ca jàn tau. Mangai ma daq phai patìh ca mangai ma oh.” ");
INSERT INTO hre_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Trùh hì haq xa-ông, joq 'nàng haq xa-ông con camia. ");
INSERT INTO hre_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mangai loh adroi gòh, xàc bình ta chac tìah ca haq caxùnh eo. Wa haq hiniq haq Êsau. ");
INSERT INTO hre_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Oh haq loh atìq, tì haq rùp lùnh jènh daq haq, taiq 'màng aih wa hiniq ca haq Jacôp. Jò xa-ông baiq toq con cô, Isac khoi jah 60 hanam. ");
INSERT INTO hre_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Jò wa baiq ngai cô yòng càn, èh Êsau loh ca mangai ragài ca axan, mangai loq enh ca bìac ŏi ta tamang đùng. Mahaq Jacôp mangai khôn khaoq, loq enh ŏi ta traiq. ");
INSERT INTO hre_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isac loq waq Êsau taiq Isac loq enh caq jam rôm. Mahaq Rê-bê-ca loq waq Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","I mòiq hì Jacôp 'nang pai cachiq, èh Êsau hlài enh đùng tagah lep. ");
INSERT INTO hre_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Haq doi ca Jacôp: “Oh am ca daq caq chauq tòh ma gòh 'mat beq, ma jah 'màng aih au tagah lep dìq jaq.” Taiq 'màng aih wì hiniq haq Êđôm. ");
INSERT INTO hre_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacôp tèu haq: “Cô ìh tech cwìang broq daq ca au beq!” ");
INSERT INTO hre_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Êsau tèu hlài: “Jò au pangot ten cachìt, au ŏi wèq cwìang con ramua broq cleq?” ");
INSERT INTO hre_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacôp tèu hlài haq: “Ìh phai pachac adroi beq.” 'Màng aih Êsau pachac, tech cwìang con ramua ca Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Hi khoi Jacôp am ca Êsau caq 'benh wa chauq tòh. Êsau caq ôq gêh, haq yòng lam. 'Màng aih Êsau khìn đac cwìang con ramua. ");
INSERT INTO hre_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","'Nhòng da Ap-ra-ham khoi i mòiq yàng pangot hrah càn. Manàiq ta gùng aih hadai i mòiq yàng hòm pangot hrah càn 'màng aih. Isac lam trùh ta A-bi-mê-lec, bùa da mangai Phi-li-tin ŏi ta Ghêra. ");
INSERT INTO hre_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Chuaq mahno loh ca haq, doi: “Apaq loh gùng Aicàp. Ìh phai ŏi hlài ta gùng Au ma patô ca ìh. ");
INSERT INTO hre_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Phai ŏi ta gùng cô. Au ŏi ti ìh wa am xôq ramŏt ca ìh, ma jah 'màng aih Au am ca ìh wa xinoi ìh dìq ca gùng cô. Au jah broq gêh dèh bàu au ma khoi pachac ca Ap-ra-ham, baq ìh. ");
INSERT INTO hre_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Au jah am tam ca xinoi ìh bàc tìah ca halŏng ta plình. Au am ca xinoi ìh dìq ca gùng cô, èh dìq dŏng ca jàn ŏi crŏng taneh nhò caxi nòi ìh wì jah xôq ramŏt, ");
INSERT INTO hre_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ma jah 'màng aih Ap-ra-ham khoi tamàng bàu Au capoch, loq iu bàu Au tanap, dì tiaq dìq ca ranenh Au, bìac Au thê wa bìac Au hnài.” ");
INSERT INTO hre_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","'Màng aih Isac ŏi ta Ghêra. ");
INSERT INTO hre_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Taiq Rê-bê-ca dìq jaq lem ngan, 'màng aih jò i 'bài mangai calô gùng aih bòch hmàih mai haq, èh haq tèu wì: “Cô oh cadrì au”, ma jah 'màng aih haq crè tàng haq doi: “Cô mai au”, èh yùq wì loq jêh cađac haq. ");
INSERT INTO hre_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isac khoi ŏi ta aih dùnh hì, i mòiq yàng bùa Phi-li-tin hiniq haq A-bi-mê-lec ngan cwa 'mŏc gàu, haq hnoq Isac 'nang baxùh dèh ca mai, Rê-bê-ca. ");
INSERT INTO hre_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Bùa creo ca Isac, doi: “Joq 'nàng mangai 'mat aih mai ìh. Gleq ìh ma doi: ‘Cô oh cadrì au’?” Isac tèu: “Taiq au yùq wì loq jêh đac au đòiq yŏc haq broq mai.” ");
INSERT INTO hre_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","A-bi-mê-lec doi ca haq: “Ìh broq cleq ca nhèn 'màng 'mat? Tàng i mòiq ngai leq lam cùi ti mai ìh, 'màng aih ìh broq dìq ca nhèn khoi broq tôiq.” ");
INSERT INTO hre_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","A-bi-mê-lec 'noh bàu doi dìq ca jàn gùng aih: “Mangai leq đùng trùh mangai cô loq mai haq, èh 'bìq hadrah cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isac rai adrech ta gùng aih. Hanam aih gat jah yi hnao mòiq hrinh phàn achùa ca hanam 'noiq, ma jah 'màng aih Chuaq khoi am xôq ramŏt ca haq. ");
INSERT INTO hre_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Haq loh ca padrŏng can, cùng hang rai èh rai bàc trùh jò haq padrŏng can dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Haq i bàc calùh trìu, calùh 'bo wa hapŏng. 'Màng aih mangai Phi-li-tin i manoh ta'mrua ta'bì ca haq. ");
INSERT INTO hre_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Mangai Phi-li-tin khoi catùh dŏng diac adràm ma 'bài hapŏng da Ap-ra-ham, baq Isac, khoi chìa nèh. ");
INSERT INTO hre_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","A-bi-mê-lec doi ca Isac: “Ìh phai loh khoi nòi nhèn, ma jah 'màng aih ìh i cwìang càn yi hnao ca nhèn bàc phàn.” ");
INSERT INTO hre_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","'Màng aih, Isac cađac gùng aih, lam đòiq traiq wa ŏi hloi ta thòng Ghêra. ");
INSERT INTO hre_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isac chìa hlài 'bài diac adràm wì ma khoi chìa ta 'nhòng Ap-ra-ham, baq haq, ma mangai Phi-li-tin khoi catùh jò Ap-ra-ham cachìt. Khoi èh haq hiniq hlài ca 'bài adràm aih troi hiniq baq haq ma khoi hiniq. ");
INSERT INTO hre_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","'Bài hapŏng Isac chìa tam hòm diac adràm nòi thòng, èh chaq hnoq mòiq toq diac tamŏc. ");
INSERT INTO hre_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mahaq 'bài ban trìu ta Ghêra ta'miaq da 'bài ban trìu Isac, doi: “Diac cô diac nhèn!” Taiq 'màng aih, Isac hiniq diac adràm aih Êsec – aih i hiniq ta'miaq. ");
INSERT INTO hre_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Khoi ca aih hapŏng Isac chìa òn mòiq toq diac adràm ma 'noiq hòm, aih xôq wì ta'miaq dìq. 'Màng aih haq hiniq ca diac adràm aih Sitnah – aih i hiniq ta'mrua ta'bì. ");
INSERT INTO hre_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Haq cađac nòi aih, chìa mòiq toq diac adràm 'noiq. Yàng cô wì ùh ta'miaq hòm, 'màng aih haq hiniq ca diac adràm cô Rê-hô-bôt. Haq doi: “Manàiq Chuaq khoi broq nòi rùng rai am ca bèn, 'màng aih bèn jah padrŏng can ta gùng cô.” ");
INSERT INTO hre_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Enh nòi aih Isac trùh ta gùng Bê-e-sê-ba. ");
INSERT INTO hre_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mang aih raq, Chuaq mahno loh ca Isac, doi: “Au cô Boc Plình da Ap-ra-ham, baq ìh. Ìh apaq yùq cleq. Au ŏi ti ìh. Au am xôq ramŏt wa broq ca xinoi ìh jah bàc tam taiq nen Ap-ra-ham hapŏng Au.” ");
INSERT INTO hre_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isac broq mòiq toq ca'bŏng tadreo, waiq xìn Chuaq, èh broq traiq nòi aih. 'Bài hapŏng haq chìa mòiq toq diac adràm ta nòi aih. ");
INSERT INTO hre_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Enh Ghêra, bùa A-bi-mê-lec pajùm ca bua haq A-bu-sat, wa Phicôn, mangai wèq dìq ca lình haq, trùh hmàih ca Isac. ");
INSERT INTO hre_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isac bòch wì haq: “Gleq pì ma lam hmàih ca au, ma jah 'màng aih pì git au, khoi èh thê au loh khoi ca pì?” ");
INSERT INTO hre_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wì tèu: “Nhèn hnoq ro Chuaq khoi ŏi ti ìh, ma jah 'màng aih nhèn doi: Bèn phai pachac bàu ca dabau, ta'ne ìh wa nhèn. Beq nhèn wêh jao ti ìh, ");
INSERT INTO hre_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","đòiq èh ìh ùh broq 'mèq cleq ca nhèn, taiq nhèn ùh lah broq 'mèq ca ìh, toq thê ìh lam khoi ca nhèn xam manoh catèm. Manàiq cô ìh joq 'nàng khoi jah Chuaq am xôq ramŏt.” ");
INSERT INTO hre_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","'Màng aih Isac broq hiniang, èh wì haq ŏi pajùm caq ôq. ");
INSERT INTO hre_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Xrŏih xroq èh wì haq pachac bàu ca dabau, Isac hi am ca wì haq lam catèm. ");
INSERT INTO hre_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Wop hì aih raq, 'bài hapŏng Isac anoi ca haq bìac diac adràm wì haq khoi chìa, doi: “Bèn khoi jah glàm diac.” ");
INSERT INTO hre_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Haq hiniq diac adràm aih Sibah. 'Màng aih enh jò aih trùh manàiq, hiniq phôq aih Bê-e-sê-ba. ");
INSERT INTO hre_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Jò Êsau khoi jah 40 hanam, haq yŏc: Jađich con cadrì Bê-ê-ri, mangai Hêtit, wa Ba-sê-mat, aih con cadrì Êlon, hadai mangai Hêtit broq mai. ");
INSERT INTO hre_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Wa haq aih broq ca Isac wa Rê-bê-ca mango manoh. ");
INSERT INTO hre_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Jò Isac khoi craq, èh mat hadai pi xau hnoq hòm, haq creo ca Êsau, con calô ramua, doi: “Ôi con au.” Êsau tèu: “I con cô.” ");
INSERT INTO hre_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isac doi: “Baq cô khoi craq, ùh 'nì ca dađeh cachìt hì leq. ");
INSERT INTO hre_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","'Màng aih, manàiq cô baq xìn con yŏc dèh ranac, panenh wa rang haq, mùt ta rôm, axan jam rôm ca baq, ");
INSERT INTO hre_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","hi padon ca baq mòiq wea caq jìang tiaq troi manoh baq loq enh, 'ràng ca baq đòiq mahua yiang baq waiq xôq ramŏt am ca con adroi ca baq cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rê-bê-ca tamàng atùng bàu Isac tanap ca Êsau. Jò Êsau mùt ta rôm axan jam rôm đòiq ahlài dèh ca baq, ");
INSERT INTO hre_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rê-bê-ca doi ca Jacôp, con calô haq: “Cô, miq i tàng baq con tanap ca Êsau, daq con: ");
INSERT INTO hre_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ahlài jam rôm ca baq, padon ca baq mòiq wea caq jìang, đòiq adroi ca baq cachìt, baq jah waiq xôq ca con enh ngìa Chuaq.’ ");
INSERT INTO hre_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","'Màng aih, con ôi, manàiq cô con tamàng bàu miq, hi broq tiaq bàu miq thê beq. ");
INSERT INTO hre_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Con loh ca cadrong, rùp baiq toq con bubi ma lem, èh miq jah broq ca baq con i mòiq wea caq jìang tiaq dèh haq ma loq enh. ");
INSERT INTO hre_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Con 'ràng ca baq caq, đòiq haq waiq xôq ca con adroi ca haq cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacôp tèu dèh miq: “Miq ôi, Êsau daq au i bàc xàc, mahaq akia au ùh i. ");
INSERT INTO hre_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tàng baq bèq chac con, baq jah canao, èh con tìah ca mangai 'nùt baq, 'màng aih au chìuq pòq dađeh can waiq hanip, ùh xài bìac waiq xôq.” ");
INSERT INTO hre_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Miq haq tèu: “Con ôi, xìn bìac waiq hanip aih đòiq ca miq pòq. Con broq tiaq bàu au, hi loh rùp baiq toq bubi beq.” ");
INSERT INTO hre_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","'Màng aih Jacôp loh rùp baiq toq con bubi 'ràng dèh ca miq. Miq haq broq mòiq wea caq jìang dìq jaq tiaq dèh baq con ma loq enh. ");
INSERT INTO hre_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Khoi ca aih, Rê-bê-ca yŏc eo ma yi lem dìq da Êsau, con calô ramua, eo ma đòiq ta hnem, thê Jacôp con ùch da haq caxùnh. ");
INSERT INTO hre_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Hi khoi haq yŏc akia con bubi chrài baiq toq tì wa ranŏng, aih nòi ma ùh i ca xàc. ");
INSERT INTO hre_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Rê-bê-ca đòiq dahwèq jìang caq wa 'benh ma khoi padon, đòiq ta tì Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacôp hi wê jam 'ràng dèh ca baq rai doi: “Ôi baq!” Isac tèu: “Cô baq! Con ma leq ma creo ca baq aih?” ");
INSERT INTO hre_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacôp tèu: “Au cô Êsau, con ramua da baq. Con khoi broq tiaq bàu baq ma thê. Xìn baq rìu, ha'ngui, caq jam axan da con, đòiq mahua yiang baq waiq xôq ca con.” ");
INSERT INTO hre_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isac bòch: “ 'Màng leq con lam ma renh jah?” Haq tèu: “Aih nhò Chuaq, Boc Plình da baq broq ca con jah renh glàm.” ");
INSERT INTO hre_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isac doi ca Jacôp: “Ôi con, lam haten jang cô đòiq baq bèq thù i joq Êsau con baq loq ùh.” ");
INSERT INTO hre_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacôp lam haten ca Isac. Haq bèq rai doi: “Bàu capoch, aih bàu capoch da Jacôp, mahaq tì, aih tì da Êsau.” ");
INSERT INTO hre_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Haq ùh canao loq ca haq, taiq tì haq i xàc tìah ca tì Êsau. 'Màng aih haq waiq xôq ramŏt am ca haq. ");
INSERT INTO hre_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Haq bòch tam hòm: “Con joq Êsau, con calô au ùh?” Jacôp tèu: “Joq cla au cô Êsau!” ");
INSERT INTO hre_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isac doi: “Yŏc jam rôm con axan padon ca baq đòiq mahua yiang baq waiq xôq am ca con!” Jacôp padon ca haq caq, hadai 'ràng alac ca haq ôq. ");
INSERT INTO hre_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Isac hi doi ca haq: “Ôi con, lam haten ta cô hìp baq.” ");
INSERT INTO hre_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jacôp lam haten hìp dèh baq. Isac xua thùm dèh eo con, èh waiq xôq am ca haq, doi: “Cô hòi xua thùm da con au, aih crài cleq hòi xua thùm da tamang đùng Chuaq ma khoi am xôq ramŏt! ");
INSERT INTO hre_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Waiq xìn Boc Plình am ca con bàc diac ngom enh plình, loh jìang ca taneh wa taneh jah bình halùih 'mau mì wa alac neo. ");
INSERT INTO hre_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Waiq con jàn patìh con. Rìm diac phai hacùn cràng enh ngìa con! Con jah wèq cwìang dìq dèh oh daq con. 'Bài con calô da miq con phai hacùn cràng ngìa con. Mangai leq waiq hanip con, mangai aih phai 'bìq waiq hanip hlài. Mangai leq waiq xôq ca con, haq jah i xôq hlài ca dađeh!” ");
INSERT INTO hre_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isac waiq xôq am ca Jacôp bu hêq, khoi èh Jacôp bu loh khoi enh nòi dèh baq, èh Êsau daq haq lam axan hlài. ");
INSERT INTO hre_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Êsau hadai padon mòiq wea jìang caq, atŏc dèh baq rai doi: “Xìn baq rìu, ha'ngui caq jam con calô ìh, đòiq mahua yiang baq waiq xôq ca con.” ");
INSERT INTO hre_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isac baq haq bòch: “Cabô 'mat?” Êsau tèu: “Au cô Êsau con calô ramua baq.” ");
INSERT INTO hre_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isac ua ta manoh dìq jaq, haq doi: “ 'Màng aih ma leq ma khoi axan jam rôm wa khoi atŏc ca baq? Adroi ca con hlài, baq khoi caq, èh khoi waiq xôq ca haq. Joq 'nàng haq aih khoi jah xôq ramŏt.” ");
INSERT INTO hre_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Jò Êsau tàng bàu dèh baq capoch bu gêh, èh haq cachech mòiq nà dìq jaq dêh bàu mango, rai doi dèh ca baq: “Baq ôi! Xìn ìh hadai waiq xôq am ca con hloi dìq.” ");
INSERT INTO hre_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Mahaq Isac doi: “Con ôi, oh con khoi mùt ta cô 'nùt baq, 'màng aih haq lam trùh atùng yŏc bìac waiq xôq da con.” ");
INSERT INTO hre_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Êsau doi: “Aih raq troq, hiniq haq Jacôp, ma jah 'màng aih haq khoi 'nùt au baiq yàng. Haq khoi ta'miaq yŏc cwìang broq con ramua calô enh au, manàiq cô haq atùng yŏc bìac waiq xôq da au hòm! Baq ôi, ìh ŏi i đòiq ca con toq 'biaq xôq ramŏt dìq ùh?” ");
INSERT INTO hre_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isac tèu: “Joq 'nàng, au khoi dèch haq broq craq con, wa khoi am 'bài oh daq hadròng hadrech con broq hapŏng haq. Au khoi am ca haq 'mau mì wa alac, 'màng aih baq broq jah ca con bìac cleq cô èh?” ");
INSERT INTO hre_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Êsau xìn dèh baq rai hmoi rai doi: “Baq ôi, ìh i mòiq toq xôq ramŏt raq 'mòh? Xìn ìh hadai waiq xôq ca con dìq!” Khoi ca aih Êsau crò rawah. ");
INSERT INTO hre_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isac doi ca haq: “Cô èh con ŏi dèh mòiq gùng croh crenh, xrenh xrŏih, ùh i ca ngom enh plình. ");
INSERT INTO hre_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Con ep nhò chang gùm tajêh poh đòiq chaq rìh. Con ep broq hapŏng dèh oh. Mahaq 'nah tangìa ta èh jò con ùh chìuq hòm, èh con jah claih ca broq hapŏng haq.” ");
INSERT INTO hre_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Pàng aih Êsau git ca Jacôp, ma jah 'màng aih Jacôp khoi ta'miaq yŏc atùng da haq xôq ramŏt. Êsau hèm ta manoh: “Jò leq baq au cachìt, au jêh đac Jacôp.” ");
INSERT INTO hre_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","I mangai anoi hlài bàu Êsau ma doi aih ca Rê-bê-ca. Rê-bê-ca hi creo ca Jacôp, doi: “Jacôp ôi, Êsau i tình tajêh đac con. ");
INSERT INTO hre_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Manàiq con tamàng bàu miq beq. Con phai cadàu camut ta hnem Laban, dùch con ŏi ta Haran! ");
INSERT INTO hre_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Con phai ŏi đò toq leq hì ta aih trùh jò leq daq con brêh ca can nòih, ");
INSERT INTO hre_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","èh hèt ca bìac con ma broq. Jò leq miq creo, èh con hi hlài. Jalaiq trom mòiq hì au ep hnhung baiq toq con 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rê-bê-ca doi dèh ca Isac: “Au khoi lep ta manoh ca 'bài con ma mangai Hêt ta gùng. Tàng Jacôp yŏc glàm con mai 'màng aih, au cachìt yi hnao.” ");
INSERT INTO hre_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","'Màng aih Isac creo ca Jacôp mùt, hi waiq xôq, èh tanap ca haq: “Con apaq yŏc mai mangai Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Yòng beq, lam cwa gùng Pađan Aram, trùh hnem Bê-tu-ên, boc pah miq. Ŏi ta aih yŏc mòiq ngai con cadrì Laban đòiq broq mai, aih dùch con. ");
INSERT INTO hre_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Waiq Boc Plình I Cwìang Itai Dìq Dŏng, xìn am xôq ramŏt ca con, broq ca con jah loh bàc ngai, èh wìa bàc jàn. ");
INSERT INTO hre_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Waiq xìn Haq hnhu am ca con wa xinoi con, xôq ramŏt da Ap-ra-ham, waq ca gùng con ma khoi ŏi jah broq xôxech da con, aih gùng Haq khoi am ca Ap-ra-ham.” ");
INSERT INTO hre_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Jò aih, Isac thê Jacôp lam cwa gùng Pađan Aram, trùh hnem Laban, con calô Bê-tu-ên, mangai Aram, daq Rê-bê-ca, miq Jacôp wa Êsau. ");
INSERT INTO hre_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Êsau hnoq Isac khoi waiq xôq ca Jacôp, thê haq lam cwa gùng Pađan Aram đòiq yŏc mai, jò 'nang waiq xôq i tanap: Apaq yŏc mai mangai Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Haq hadai hnoq Jacôp khoi iu tiaq bàu miq baq lam cwa gùng Pađan Aram. ");
INSERT INTO hre_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Êsau hadai hnoq con cadrì mangai Ca-na-an ùh troq ca manoh baq haq Isac. ");
INSERT INTO hre_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","'Màng aih Êsau lam trùh hnem Ich-ma-ên, yŏc tam mòiq ngai hòm broq mai, aih Ma-ha-lat, oh Nê-ba-jôt, con cadrì da Ich-ma-ên, con da Ap-ra-ham. ");
INSERT INTO hre_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacôp enh Bê-e-sê-ba lam trong trùh Haran. ");
INSERT INTO hre_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Trùh mòiq nòi tau, plình khoi xèq, haq yŏc hmu broq canèn angèn gàu, èh haq cùi đò jang aih. ");
INSERT INTO hre_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Jò cùi, haq apô hnoq mòiq toq gòng roh enh taneh trùh plình, èh hnoq 'bài 'bình plình da Boc Plình tŏc loh ta gòng aih. ");
INSERT INTO hre_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Cô, Chuaq yòng agàu gòng, Haq doi: “Au cô Chuaq Boc Plình da Ap-ra-ham, boc ìh, hadai Boc Plình da Isac. Au am ca ìh wa xinoi ìh taneh ìh ma 'nang cùi cô. ");
INSERT INTO hre_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Xinoi ìh jah bàc 'mang ca blo ta crŏng taneh, prai jàp pah mat mahì loh, pah mat mahì mùt, pah 'ma ca mat mahì loh, pah 'ngeo ca mat mahì loh. Nhò ìh wa xinoi ìh, dìq ca con jàn ta crŏng taneh jah xôq ramŏt. ");
INSERT INTO hre_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Cô, Au ŏi ti ìh. Ìh lam ta leq, Au tiaq wèq ban ìh ta aih, hi 'ràng ìh hlài ta gùng cô, ma jah 'màng aih Au ùh jò leq cađac ìh trùh jò leq Au broq gêh bìac Au khoi rùp bàu ca ìh.” ");
INSERT INTO hre_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacôp rìu enh cùi, doi: “Joq 'nàng Chuaq i ŏi ta nòi cô, mahaq adroi au ùh 'nì.” ");
INSERT INTO hre_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Haq yùq crè, doi: “Nòi cô, joq đang ca yùq crè. Cô raq hnem Boc Plình, wa 'mang ngo Diac Plình.” ");
INSERT INTO hre_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jacôp rìu xrŏih, yŏc hmu haq ma angèn gàu broq tìah ca long jrang, èh ùc dàu ôliu ta gàu hmu aih. ");
INSERT INTO hre_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Hi khoi haq hiniq nòi aih Bêtên, mahaq adroi nèh hiniq nòi aih Luxò. ");
INSERT INTO hre_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacôp hi pachac, doi: “Tàng Boc Plình ŏi ti au, wèq ban au jò au lam ti trong, am ca au 'benh caq, eo caxùnh, ");
INSERT INTO hre_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","wa au hlài catèm trùh hnem baq au, èh Chuaq joq wìa Boc Plình da au. ");
INSERT INTO hre_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Hmu au khoi broq tìah ca long jrang cô, jah wìa hnem da Boc Plình. Èh au am hlài ca Ìh mòiq phàn mòiq jàt dìq ca dahwèq Ìh ma khoi am ca au.” ");
INSERT INTO hre_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Khoi ca aih Jacôp lam hòm, hi trùh gùng pah mat mahì loh. ");
INSERT INTO hre_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Haq ngan hnoq mòiq toq diac adràm ta đùng. Haten ca aih i piq calùh trìu cùi padài, ma jah 'màng aih nòi cô aih nòi wì am ca trìu ôq diac. I mòiq toq hmu càn gùp diac adràm. ");
INSERT INTO hre_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Wì haq gòm dèh dìq calùh trìu lam trùh, hi khoi wì men cadro hmu aih, am ca 'bài trìu ôq diac. Khoi ôq gêh, wì cadro hmu gùp hlài diac adràm. ");
INSERT INTO hre_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacôp bòch wì mangai ban trìu: “Ôi oh daq, pì ŏi enh leq?” Wì tèu: “Nhèn trùh enh Haran.” ");
INSERT INTO hre_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Haq bòch: “Pì i loq ca Laban, con calô Nacô ùh?” Wì tèu: “Nhèn canao loq haq.” ");
INSERT INTO hre_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Haq bòch hòm: “Mangai aih i jah tadêh đeh ùh?” Wì tèu: “Tadêh. Tau con cadrì haq, Rachên 'nang lam trùh dèh ti calùh trìu.” ");
INSERT INTO hre_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jacôp doi: “Hì ŏi xrŏih, 'nhòq trùh jò tagop calùh 'bo, 'màng aih pì am ca calùh trìu ôq diac, hi khoi ca'naih wì haq lam caq hòm.” ");
INSERT INTO hre_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Wì tèu haq: “Nhèn broq 'màng aih ùh jah. Phai gòm dìq ca calùh trìu tagop hlài tôm tàu, men jah cadro hmu enh diac adràm am ca wì haq ôq.” ");
INSERT INTO hre_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jò Jacôp 'nang capoch tùang ca 'bài aih, èh Rachên 'ràng dèh trìu baq haq bu trùh, ma jah 'màng aih haq mangai ban trìu. ");
INSERT INTO hre_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Bu hnoq Rachên, con cadrì Laban, con dùch haq, èh Jacôp lam trùh cadro hmu enh diac adràm, am 'bài trìu da dùch haq, Laban, ôq diac. ");
INSERT INTO hre_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jacôp hìp Rachên, hi crò hmoi. ");
INSERT INTO hre_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacôp doi ca Rachên loq, haq oh daq, haq mon, creo Laban dùch xèm, haq con calô Rê-bê-ca. Rachên drah cadàu hlài anoi dèh ca baq. ");
INSERT INTO hre_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Bu tàng doi Jacôp con calô da oh cadrì haq, Laban cadàu trùh đìh Jacôp, oc haq rai hìp, hi khoi adràc trùh dèh ta hnem. Jacôp ta'mon hlài ca Laban tàng rìm bìac. ");
INSERT INTO hre_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban tèu haq: “Joq 'màng aih, mon xinoi dùch.” Jacôp ŏi ta hnem dùch haq mòiq khê. ");
INSERT INTO hre_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","I mòiq hì Laban doi ca Jacôp: “Ùh xài taiq bèn oh daq ma mon broq dech ca dùch 'mòh? Doi ca dùch loq beq, cùng baha khòh toq leq?” ");
INSERT INTO hre_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban i baiq toq con cadrì. Daq haq hiniq Lêa, oh haq Rachên. ");
INSERT INTO hre_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Mat Lêa ìuq, mahaq chac wa hadrò Rachên lem lình dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacôp loq waq Rachên, taiq 'màng aih haq doi ca dùch: “Au broq dech ca dùch tapèh hanam tàng dùch am ca au xoa yŏc Rachên broq mai, con cadrì ùch dùch!” ");
INSERT INTO hre_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban tèu: “Dùch am haq ca mon broq mai, aih ùh hnao ca am ca mangai 'noiq. Mon ŏi ti dùch beq!” ");
INSERT INTO hre_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","'Màng aih Jacôp khoi abroq ca dùch haq tapèh hanam, mahaq tìah ca toq 'biaq hì hêq taiq haq loq waq haq dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Khoi ca aih, Jacôp doi ca Laban: “Jò pajaq khoi dìq, xìn dùch am mai ca au đòiq au jah ŏi pajùm ti haq.” ");
INSERT INTO hre_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban akhen dìq ca mangai ta plài, padon hiniang ta'nèp. ");
INSERT INTO hre_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Trùh xèq, Laban yŏc Lêa thai ca Rachên 'ràng ti Jacôp, èh wa haq cùi ti dabau. ");
INSERT INTO hre_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban hadai am cadrì hapŏng 'yoh haq, hiniq haq Xinpa tiaq wèq Lêa, con cadrì haq. ");
INSERT INTO hre_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Xroq èh, Jacôp men loq mangai ma cùi ti haq, aih Lêa! Jacôp doi ca Laban: “Ìh 'nùt dèh ca au 'màng cô? Au ŏi ti ìh tapèh hanam nhò i Rachên. Gleq ìh ma 'nùt dèh ca au?” ");
INSERT INTO hre_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban tèu haq: “Tiaq ranenh nhèn ta cô 'màng 'mat. Oh ùh jah yŏc ŏng adroi ca daq. ");
INSERT INTO hre_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Caq ŏi ti daq mòiq tùang khoi gêh, èh au am hloi ca mon oh haq, mahaq mon phai ŏi tam abroq ti dùch tapèh hanam hòm.” ");
INSERT INTO hre_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacôp mòiq manoh broq tiaq bàu aih. Atìq ca mòiq tùang aih, Laban am ca haq Rachên, con cadrì haq, ca Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban am mòiq ngai hapŏng cadrì 'yoh hiniq haq Bila tiaq wèq Rachên, con cadrì haq. ");
INSERT INTO hre_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacôp caq ŏi ti Rachên. Haq loq waq ca Rachên yi hnao ca Lêa. Èh haq ŏi abroq ca hnem Laban tam tapèh hanam hòm. ");
INSERT INTO hre_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Chuaq hnoq Lêa 'bìq git, Haq broq ca Lêa jah xa-ông con, mahaq Rachên xon. ");
INSERT INTO hre_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lêa ŏi jiang, xa-ông mòiq toq con calô, hiniq haq Rubên. Haq doi: “Chuaq khoi hnoq manoh jìq xa da au, manàiq ŏng au jah loq waq ca au.” ");
INSERT INTO hre_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Haq ŏi jiang hòm, xa-ông mòiq toq con calô, hiniq haq Si-mê-ôn. Haq doi: “Chuaq loq ca au 'bìq git 'màng aih Haq am tam con cô.” ");
INSERT INTO hre_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Haq ŏi jìang hòm, èh xa-ông mòiq toq con calô. Haq hiniq haq Lêwi, taiq haq doi: “Yàng cô joq 'nàng ŏng au loq waq au taiq au khoi xa-ông am ca haq piq toq con calô!” ");
INSERT INTO hre_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Haq ŏi jìang hòm, xa-ông con calô. Haq hiniq haq Juđa, taiq haq doi: “Manàiq cô au manè apôi Chuaq!” Khoi èh haq pi ŏi jìang hòm. ");
INSERT INTO hre_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachên hnoq dađeh khoi xon, ùh jah xa-ông con, èh haq i manoh ta'bì ca daq haq. Haq doi ca Jacôp: “Am ca au con beq, tàng ùh am, au cachìt!” ");
INSERT INTO hre_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacôp nòih ca Rachên doi: “Au i cwìang jah broq thai ca Boc Plình 'mòh? Toq Haq i cwìang ùh am ca gè xa-ông con!” ");
INSERT INTO hre_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachên doi: “Cô Bila, hapŏng 'yoh da au. Cùi ti haq beq, waq ca haq xa-ông thai ca au đòiq con haq wìa con da au.” ");
INSERT INTO hre_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","'Màng aih Rachên 'ràng Bila, hapŏng haq, hnhu am ca Jacôp, hi khoi Jacôp caq ŏi ti haq. ");
INSERT INTO hre_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila ŏi jiang, xa-ông mòiq toq con calô. ");
INSERT INTO hre_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachên hiniq con calô aih Đan, èh doi: “Boc Plình tàng bàu au, hnoq au khoi chìuq bìac ùh ta-atoq, 'màng aih Haq am ca au con calô cô.” ");
INSERT INTO hre_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bila, hapŏng 'yoh Rachên ŏi jiang hòm, xa-ông mòiq toq con calô. ");
INSERT INTO hre_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachên hiniq ca con calô cô, Nep-ta-li, ma jah 'màng aih haq doi: “Au dìq ca padren ta'blêq dèh ca daq, 'màng aih au khoi jah 'blêq.” ");
INSERT INTO hre_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lêa hnoq dađeh pi xa-ông hòm, 'màng aih haq thê Xinpa, hapŏng 'yoh da haq broq mai da Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Xinpa, hapŏng 'yoh da Lêa, xa-ông mòiq toq con calô am ca Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lêa doi: “Joq i xôq ramŏt!” Taiq nen aih haq hiniq con calô aih, Gat. ");
INSERT INTO hre_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Xinpa, hapŏng 'yoh da Lêa xa-ông tam hòm mòiq toq con calô am ca Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Èh Lêa doi: “Au bùi manoh, taiq 'bài mangai cadrì jah doi au cô mangai i xôq.” Taiq nen aih haq hiniq con calô aih Ase. ");
INSERT INTO hre_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wop jò gat 'mau mì, Rubên lam ta rôm ket plì broq gu cadrì xùang ca ŏi jiang, 'ràng am dèh ca miq. Rachên hnoq, èh xìn đeh toq 'biaq toq dìq. ");
INSERT INTO hre_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lêa doi: “Gè ta'miaq da au ŏng aih ma bìac 'yoh? Èh gè enh yŏc hloi plì broq gu cadrì xùang ca ŏi jiang da con calô au 'mòh?” Rachên tèu: “Xìn ìh am ca au plì broq gu cadrì xùang ca ŏi jiang da con ìh 'mat, èh au am ŏng au caq ŏi ti ìh mang cô.” ");
INSERT INTO hre_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Trùh xèq, Jacôp hlài enh đùng, èh Lêa loh glàm haq, doi: “Ìh phai cùi ti au mang cô, ma jah 'màng aih au khoi yŏc plì broq gu cadrì xùang ca ŏi jiang enh con au đôiq jah ìh.” 'Màng aih Jacôp cùi ti haq mang aih. ");
INSERT INTO hre_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Boc Plình tamàng bàu dang creo da Lêa, am Lêa ŏi jiang, èh xa-ông ca Jacôp mòiq toq con calô yàng padam. ");
INSERT INTO hre_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lêa doi: “Boc Plình khoi đèn cùng au, ma jah 'màng aih au khoi am hapŏng 'yoh dèh ca ŏng.” 'Màng aih haq hiniq ca con calô aih I-sa-ca. ");
INSERT INTO hre_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lêa ŏi jiang hòm, xa-ông mòiq toq con yàng tadràu am ca Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lêa hi doi: “Boc Plình am ca au mòiq bìac lem lình: Yàng cô ŏng jah ŏi hloi ti au, ma jah 'màng aih au khoi xa-ông ca haq tadràu toq con calô.” Taiq nen aih haq hiniq con calô cô Xe-bu-lun. ");
INSERT INTO hre_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Khoi ca aih, haq xa-ông toq con cadrì, hiniq haq Đina. ");
INSERT INTO hre_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Boc Plình hmàng hlài ca Rachên, tàng bàu xìn da haq, hi am ca haq jah xa-ông. ");
INSERT INTO hre_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Haq ŏi jiang, xa-ông mòiq toq con calô, haq manè apôi Chuaq, doi: “Boc Plình khoi 'noh cađac can camaih au.” ");
INSERT INTO hre_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Taiq nen aih, haq hiniq ca con aih Jôsep, hi doi: “Chuaq joq am tam ca au mòiq toq con hòm èh.” ");
INSERT INTO hre_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Khoi ca Rachên xa-ông ca Jôsep, Jacôp doi ca Laban: “Xìn dùch am ca au hlài dèh ta gùng oq. ");
INSERT INTO hre_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mon khoi dìq dèh ca manoh ŏi abroq ca dùch tiaq troi bàu ma pajaq. Xìn dùch am ca mon 'nong dèh cadrì con lam.” ");
INSERT INTO hre_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Mahaq Laban tèu haq: “Xìn mon apaq cađac dùch, ma jah 'màng aih dùch loq Chuaq am xôq ramŏt ca dùch hì cô, aih dìq dŏng trùh nhò mon. ");
INSERT INTO hre_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mon enh dùch am tam cùng baha toq leq xôq dùch ca'naih.” ");
INSERT INTO hre_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacôp tèu: “Ìh khoi loq au jùp đò ìh 'màng leq! Au abroq wèq ngan da ìh ngè aban 'màng leq! ");
INSERT INTO hre_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Adroi ca au trùh, dahwèq ìh ŏi raq 'biaq, mahaq trùh jò au ŏi, èh tŏc tam dìq jaq bàc. Chuaq khoi am xôq ca dùch nhò rìm bìac au khoi broq. Mahaq manàiq cô phàn da mon cô trùh jò leq au jah hèm dèh ca cadraq au?” ");
INSERT INTO hre_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban bòch: “ 'Màng aih manàiq mon enh dùch am tam cùng baha toq leq?” Jacôp tèu: “Ùh ep am ca au cacleq. Tàng ìh hatroq ca bàu au padon anoi 'noh cô èh, au jah ban hòm 'bài trìu, 'bài bubi ìh. ");
INSERT INTO hre_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hì cô, dùch đòiq ca mon lam ti ngan calùh trìu wa calùh bubi da ìh. Ma leq i teo habràu loq i teo clŏc, loq i xàc gam, èh au đòiq crài, aih jah wìa cùng baha da au. ");
INSERT INTO hre_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Atìq cô èh, jò dùch ti ngan cùng baha au, èh loq manoh joq 'nàng da au jah patô ma ro 'màng leq. Tàng dùch hnoq trìu loq bubi leq ùh i teo habràu loq teo clŏc loq ùh i xàc gam, èh loq au khoi atùng.” ");
INSERT INTO hre_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban tèu: “Dùch mòiq manoh ca bàu aih. Èh tiaq troi bàu mon ma doi.” ");
INSERT INTO hre_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Wop hi aih raq, Laban ràih đòiq crài dŏng dìq 'bài bubi calô wa 'bài bubi cadrì leq i teo hot wa i teo clŏc xam nhum taboc, wa trìu i xàc gam, èh hnhu am dèh ca 'bài con calô ban. ");
INSERT INTO hre_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Hi khoi, haq lam piq hì ca trong nòi 'noiq hangai ca nòi Jacôp. Jacôp ban đeh 'bài ngè aban da Laban ma ŏi hlài. ");
INSERT INTO hre_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacôp coh hmenh long yùang liu, hmenh long apriac, wa hmenh long hatiang, èh luch ca'nhah đòiq hnoq trong ma taboc. ");
INSERT INTO hre_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Haq đòiq hmenh, ma khoi luch ca'nhah, ta atong diac da trìu, aih nòi calùh trìu lam ôq diac. Jò trùh ôq diac, èh wì haq waq ca dabau. ");
INSERT INTO hre_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Jò 'bài trìu ngan hnoq hmenh aih, wì waq ca dabau, èh xêh loh con i teo hot, i teo habràu wa i teo clŏc. ");
INSERT INTO hre_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacôp đòiq crài 'bài ma aih ca dađeh. Haq hadai 'ràng 'noh dìq ca trìu cadrì da Laban, am wì haq waq ca trìu calô i teo hot loq gam dađeh. 'Màng aih Jacôp jah bàc 'bài bubi wa 'bài trìu ca dađeh. ");
INSERT INTO hre_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","'Màng aih rìm yàng 'bài trìu bech wa tadêh enh waq ca dabau, èh Jacôp đòiq hmenh long khoi luch enh ngìa wì haq ta atong diac đòiq wì haq ngan hamenh aih jò waq ca dabau. ");
INSERT INTO hre_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mahaq jò trìu hi ragìq, èh haq pi đòiq hmenh atong diac. 'Màng aih èh 'bài con trìu ma ragìq đòiq hlài da Laban, mahaq 'bài con trìu bech wa tadêh đòiq phàn Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","'Màng aih Jacôp loh ca padrŏng can. I bàc 'bài ngè aban, 'bài hapŏng calô, hapŏng cadrì, lŏcđa wa lùa. ");
INSERT INTO hre_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacôp tàng atùng bàu 'bài con calô da Laban doi: “Jacôp khoi yŏc dŏng cùng hang baq bèn, nhò cùng hang baq bèn Jacôp jah can padrŏng 'màng cô.” ");
INSERT INTO hre_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacôp hnoq dùch khoi tablòq manoh ca haq, ùh lem ca haq troi adroi nèh. ");
INSERT INTO hre_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Chuaq doi ca Jacôp: “Wìh hlài ta gùng boc yaq ìh beq, nòi oh daq ìh. Au jah ŏi ti ìh.” ");
INSERT INTO hre_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacôp thê mangai creo Rachên wa Lêa trùh ta nòi haq ban ngè aban da cla haq ŏi ta đùng. ");
INSERT INTO hre_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Haq anoi ca wa haq: “Au hnoq manoh baq chôp khoi tablòq hlài èh ùh lem manoh ca au tìah troi enh adroi nèh, mahaq Boc Plình da baq au wèq ban au. ");
INSERT INTO hre_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Chôp loq au khoi patìh ca baq chôp dìq ca padren, ");
INSERT INTO hre_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","mahaq baq chôp khoi ngan au ùh loh cleq. Mòiq jàt yàng haq tablòq hlài cùng ma baha au, mahaq Boc Plình ùh am haq broq raliang au toq xìt leq! ");
INSERT INTO hre_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Jò haq doi: 'Bài con trìu i teo cleq clŏc jah wìa cùng ma baha ìh, èh joq 'nàng 'bài con trìu dìq xêh loh 'bài con i teo clep clŏc. Èh tàng haq doi: 'Bài con trìu i teo hot jah wìa cùng ma baha ìh, joq 'nàng 'bài trìu dìq xêh loh con i teo hot. ");
INSERT INTO hre_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","'Màng aih Boc Plình khoi rùp ngè aban da baq chôp am ca au! ");
INSERT INTO hre_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Bìac aih i 'màng cô: Jò 'bài trìu waq ca dabau, au apô hnoq bubi calô ma tapòq ca bubi cadrì, wì aih i teo hot, teo habràu wa clep clŏc. ");
INSERT INTO hre_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Jò aih 'bình plình Boc Plình doi ca au ta jò apô: ‘Ô Jacôp!’ Au tèu: ‘I au cô.’ ");
INSERT INTO hre_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","'Bình plình doi: ‘Ngoi ngan beq, dìq dŏng bubi calô 'nang tapòq ca bubi cadrì, i teo hot, i habràu wa clep clŏc, ma jah 'màng aih au khoi hnoq bìac manoh caq ŏi da Laban ti ìh 'màng leq. ");
INSERT INTO hre_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Au cô Boc Plình da Bêtên, aih nòi ìh khoi xùt dàu ti gàu jrang xam hmu, èh ìh khoi pachac ca Au. Manàiq cô yòng beq, loh khoi gùng cô, wìh hlài ta gùng da oh daq ìh.’ ” ");
INSERT INTO hre_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachên wa Lêa doi ca haq: “Manàiq cô ma ŏi i mòiq ha'nech xôxech leq loq cùng hang leq nòi hnem baq 'mòh? ");
INSERT INTO hre_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ma jah 'màng aih baq ma khoi tech ma, èh haq ji khoi caq dŏng 'bac jènh ma tech ma. Haq hadai khoi ngan ma tìah ca tamoi 'noiq dìq! ");
INSERT INTO hre_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Joq 'nàng dìq cùng hang Boc Plình ma yŏc nòi ti baq ma, aih cùng hang ma wa con caiq ma. 'Màng aih manàiq cô, ìh lam broq tiaq rìm nà Boc Plình khoi thê broq beq.” ");
INSERT INTO hre_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jacôp padinh yòng, dèch dèh mai wa con tŏc ta crŏng lŏcđa, ");
INSERT INTO hre_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","'nong dìq dŏng ngè aban wa cùng hang cla, aih ngè aban cla haq khoi broq loh ŏi ta Pađan Aram, khoi èh wìh hlài ta Isac, baq cla haq ŏi ta gùng Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Jò Laban jiang lam cat xàc trìu, Rachên atùng 'bài dua 'mù cùh waiq ta hnem baq haq. ");
INSERT INTO hre_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacôp 'nùt Laban, mangai Siri, tiaq trong ùh doi ca haq loq bìac dèh manoh haq enh lam mot. ");
INSERT INTO hre_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","'Màng aih haq yòng, 'nong dìq dŏng cùng hang cla haq, mot lam cwa Cròng Diac U-phra-tê hlài ta wang Ga-la-at. ");
INSERT INTO hre_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Trùh hì piq, wì anoi hlài ca Laban loq ca Jacôp khoi lam mot. ");
INSERT INTO hre_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Haq 'ràng dèh 'bài oh daq cla, hnan tiaq Jacôp trom tapèh hì lam ta trong, èh tiaq tem haq ta wang Ga-la-at. ");
INSERT INTO hre_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mahaq ta jò apô damang, Boc Plình trùh ti Laban, mangai Siri, doi: “ 'Nhac ca lem 'nhac ca dù, 'màng leq ìh xôq wèq dađeh apaq capoch cleq ca Jacôp.” ");
INSERT INTO hre_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Khoi èh Laban tiaq tem Jacôp. Jò cô Jacôp 'nang đòiq traiq ta wang. Laban wa oh daq haq hadai broq traiq ta wang Ga-la-at. ");
INSERT INTO hre_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban doi ca Jacôp: “Mon broq cleq 'màng cô? Mon khoi 'nùt dùch, èh 'nong 'bài con cadrì dùch tìah ca lình tù! ");
INSERT INTO hre_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Gleq lam mot 'nùt dùch ùh am ca dùch loq adroi? Taiq nen au jah bùi manoh ajèn trong ca mon xam 'bŏi calêu, atêh broc, wa ra'nhùn clùng 'mòh! ");
INSERT INTO hre_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Mon broq cleq ma blùng 'màng cô, ùh đòiq dùch hìp xau calô wa xau cadrì dùch! ");
INSERT INTO hre_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Tì dùch i cwìang jah broq raliang ca mon, mahaq Boc Plình da baq mon khoi pariaq doi ca dùch mang hnèh: 'Nhac ca lem, 'nhac ca dù, ìh phai wèq dađeh apaq doi cleq ca Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Manàiq cô, taiq manoh ngèh enh hlài ta hnem baq mon, mon khoi loh lam, mahaq gleq mon ma atùng 'bài dua 'mù ta hnem dùch?” ");
INSERT INTO hre_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacôp tèu: “Taiq au yùq ìh loq rùp hlài dèh baiq ngai con cadrì dài au ma loh lam 'màng cô. ");
INSERT INTO hre_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mahaq bìac 'bài dua 'mù da dùch, mangai leq khoi yŏc khòh cachìt! Enh ngìa dìq oh daq bèn, ìh ti chaq 'bài ngè ti nòi ngè da au beq, èh tàng i dahwèq leq da ìh, yŏc hlài beq.” Mahaq Jacôp ùh 'nì ca Rachên khoi atùng 'bài dua 'mù aih. ");
INSERT INTO hre_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","'Màng aih Laban mùt ta traiq Jacôp, traiq Lêa, wa traiq baiq ngai, mangai tiaq wèq, chaq ùh jah cleq. Khoi èh, ŏi enh traiq Lêa lam mùt ta traiq Rachên. ");
INSERT INTO hre_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachên khoi yŏc 'bài dua 'mù aih adroi, èh cadoc enh 'neq ca gèq ma đòiq enh crŏng lŏcđa, khoi èh ha'ngui enh 'nhèq. Laban chèh chaq jàp ta traiq ùh hnoq dua 'mù aih. ");
INSERT INTO hre_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachên doi dèh ca baq: “Taiq chac au tiaq jò da gu cadrì 'nang i mahem, 'màng aih au ùh jah yòng đìh ìh. Xìn baq baxŏng bìac ca au.” Laban dìq ca manoh ti chaq, mahaq ùh hnoq dua 'mù ta leq. ");
INSERT INTO hre_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacôp nòih talech ca Laban, doi: “Au i lôi cleq, i tôiq cleq ìh ma jah hnan tiaq 'màng cô? ");
INSERT INTO hre_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ìh khoi chèh chaq ta dahwèq au, i chaq hnoq dahwèq leq da ìh ùh? 'Noh ngè aih jang ngìa oh daq au wa oh daq ìh beq đòiq wì haq hadrah ba! ");
INSERT INTO hre_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Khoi 20 hanam au caq ŏi ta hnem ìh. I ca trìu leq loq bubi leq da ìh ralech ùh? Èh au i lah caq jam trìu calô calùh da ìh ùh? ");
INSERT INTO hre_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Hadai ùh lah 'ràng hlài da ìh trìu leq 'bìq ngè rôm khoi hich. Tàng i, au khoi đèn hlài da ìh. Ìh xôq thê au đèn hlài 'bài trìu leq 'bìq wì atùng dahì wa atùng damang. ");
INSERT INTO hre_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Dahì au chìuq tôq pa-ùh; damang au chìuq tanget hangeo, wa cùi ùh jah catèm. ");
INSERT INTO hre_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Trom 20 hanam au ŏi ta hnem ìh 'màng aih. Trom 14 hanam au phai abroq đòiq jah baiq toq con cadrì ìh, wa tadràu hanam đòiq yŏc calùh ngè aban da ìh, èh ìh khoi tablòq cùng abroq au 10 yàng. ");
INSERT INTO hre_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tàng Boc Plình da boc au, Boc Plình da Ap-ra-ham, Boc Plình da Isac, baq au ma yùq crè cùh waiq, ùh wèq ban au, 'màng aih manàiq cô ìh khoi hnan đac au loh lam tì dech, mahaq Boc Plình khoi hnoq manoh jìq xa au wa bìac broq xalep da au, taiq 'màng aih mang hnèh Haq khoi hadrah ta-atoq.” ");
INSERT INTO hre_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban doi ca Jacôp: “ 'Bài con cadrì cô, aih con da dùch, wa 'bài con xau cô aih con xau da dùch. Dìq ca ngè aban cô, aih calùh da dùch, wa dìq ca hang leq mon jah ngan hnoq, aih dìq dŏng da dùch. Hì cô dùch jah broq cleq dèh ca 'bài con cadrì loq 'bài xau dùch aih? ");
INSERT INTO hre_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","'Màng aih manàiq cô ba wêh jao ca dabau, wêh jao aih jah broq teo hadro ta'ne ba dùch mon.” ");
INSERT INTO hre_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jacôp yŏc mòiq toq hmu, pa'nàng yòng broq jrang. ");
INSERT INTO hre_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Haq thê dèh oh daq yòng tŏch hmu pagông mòiq 'ngùc. Khoi èh Laban wa Jacôp ha'ngui acaq enh 'nhèq. ");
INSERT INTO hre_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban hiniq ca 'ngùc hmu aih, Jêga Sa-ha-đu-tha; èh Jacôp creo aih, Galet. ");
INSERT INTO hre_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban doi: “ 'Ngùc hmu cô hì cô aih teo hadro ca dùch wa mon oq.” 'Màng aih wì creo hmu aih Galet, ");
INSERT INTO hre_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","èh hadai creo Mitba, ma jah 'màng aih Laban i anoi tam: “Jò ba talah ca dabau, xìn Chuaq ngan wèq mon wa dùch. ");
INSERT INTO hre_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tàng mon baxa 'bài con cadrì dùch yŏc òn mai 'noiq hòm, èh cô bìac mon khòh loq, 'nhac ca dùch ùh loq, mahaq Boc Plình loq ro bìac aih.” ");
INSERT INTO hre_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban doi hòm ca Jacôp: “Cô 'ngùc hmu wa hmu pa'nàng ma dùch khoi pa'nàng ta'ne ba dùch mon. ");
INSERT INTO hre_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","'Ngùc hmu cô wa hmu pa'nàng cô ngan hnoq dùch ùh jah cadiang cwa nòi cô lam trùh nòi mon, wa mon hadai ùh jah cadiang cwa nòi cô lam trùh nòi dùch đòiq tabroq ca dabau. ");
INSERT INTO hre_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Xìn Boc Plình da Ap-ra-ham, Boc Plình da Nacô, Boc Plình da boc wa haq, hadrah bìac ta'ne ba.” 'Màng aih Jacôp pachac enh ngìa ca Boc Plình da Isac, baq cla haq, ma loq crè yùq. ");
INSERT INTO hre_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Khoi èh Jacôp am ngè tadreo ta bôi wang, akhen dèh ca 'bài oh daq cla caq 'benh. Mang aih wì ŏi ta bôi wang 'ngah ca mang. ");
INSERT INTO hre_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Hì atìq Laban rìu xrŏih, hìp dèh 'bài con wa 'bài xau, waiq am xôq ramŏt ca wì, khoi èh wìh hlài dèh ta hnem. ");
INSERT INTO hre_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacôp wa dìq ca cadraq haq lam ti trong, èh glàm 'bài 'bình plình ta mòiq nòi. ");
INSERT INTO hre_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jò Jacôp hnoq wì haq, haq doi: “Cô traiq da Boc Plình!” 'Màng aih Jacôp hiniq ca nòi aih, Ma-ha-na-im. ");
INSERT INTO hre_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacôp thê dèh mangai wê bàu lam trùh ta wang Sirò gùng Êđôm, chaq Êsau daq haq. ");
INSERT INTO hre_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Haq tanap: “Pì lam doi ca Êsau, Chuaq au, 'màng cô: Jacôp, mangai hapŏng ìh, doi 'màng cô: Au khoi ŏi ta hnem Laban trùh hì cô. ");
INSERT INTO hre_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Au i 'bo, lùa, calùh trìu, hapŏng calô wa hapŏng cadrì. Manàiq cô, au 'nang hlài dèh ta gùng. 'Màng aih au thê lam anoi ca ìh loq adroi, èh dìq jaq ngèh ùac ca ìh đìh yŏc nhèn.” ");
INSERT INTO hre_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","'Bài mangai wê bàu wìh hlài anoi ca Jacôp: “Nhèn khoi lam trùh ta Êsau, daq ìh. Haq 'nang 'ràng 400 ngai trùh glàm ìh.” ");
INSERT INTO hre_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacôp dìq ca jaq yùq crè wa mango. Haq lah mangai ma lam tiaq, calùh trìu, 'bo, lŏcđa, loh baiq lù. ");
INSERT INTO hre_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tàng Êsau glàm jêh mòiq lù, lù ma ŏi jah claih. ");
INSERT INTO hre_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Khoi èh Jacôp waiq khàn: “Ôi Boc Plình da Ap-ra-ham, boc au! Boc Plình da Isac, baq au, aih Chuaq ma khoi doi ca au: Wìh hlài ta gùng ìh wa nòi oh daq ìh beq, khoi èh Au jah am xôq ramŏt ca ìh! ");
INSERT INTO hre_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Au ùh đang ca nhàn yŏc can xa-ŏch xam manoh loq waq da Chuaq, mahaq Chuaq khoi xa-ŏch wa wèq dŏng dìq dèh bàu Ìh khoi hùaq, ma jah 'màng aih jò au lam cwa cròng diac Jôđan cô yàng adroi, au i toq long canhra au raq, mahaq hì cô au wìh hlài khoi i baiq lù mangai. ");
INSERT INTO hre_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Au xìn Chuaq dŏih dèch au claih khoi ca tì Êsau, daq au, ma jah 'màng aih yùq haq loq trùh jêh au wa jêh hloi 'bài mai wa 'bài con au. ");
INSERT INTO hre_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Taiq Chuaq khoi rùp bàu: ‘Joq 'nàng Au jah broq am xôq ramŏt ca ìh, broq am ca xinoi ìh cràm tìah ca braih diac raxìq, pi nui rèn.’ ” ");
INSERT INTO hre_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacôp ŏi padài damang aih ta Ma-ha-na-im. Èh haq ràih toq leq ngè đòiq tabàih am ca Êsau. Ngè aih 'màng cô: ");
INSERT INTO hre_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 toq bubi cadrì; 20 toq bubi calô; 200 trìu cadrì; 20 trìu calô, ");
INSERT INTO hre_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 toq lŏcđa can xam 'bài con; 40 toq 'bo cadrì wa 10 toq 'bo calô; 20 toq lùa can, wa 10 toq lùa calô. ");
INSERT INTO hre_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Khoi èh haq jao dìq ngè aban haq dèh ca hapŏng, èh tanap: “Pì lam adroi ca au beq, 'nong lù cô wa lù tau hangai ca dabau mòiq hagan.” ");
INSERT INTO hre_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Jacôp tanap ca mangai hapŏng ma 'nong 'bài lam adroi dŏng 'màng cô: “Jò Êsau daq au glàm ìh, èh haq bòch: ‘Craq ìh cabô? Ìh lam ta leq? 'Bài aban jang ngìa ìh, aih ngè aban cabô?’ ");
INSERT INTO hre_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ìh phai tèu: ‘ 'Bài cô, aih ngè aban da Jacôp, hapŏng ìh. Aih ngè tabàih am ca ìh. Cô, Jacôp 'nang tiaq atìq.’ ” ");
INSERT INTO hre_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jacôp hadai tanap ca dìq mangai hapŏng ma 'noiq ma wèq ngè aban, hadai doi ca Êsau bàu aih, èh doi tam: “Jacôp, hapŏng da ìh tiaq atìq nhèn.” ");
INSERT INTO hre_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Jacôp hèm ta manoh cla: “Au gòi adroi dìq ngè tabàih am đòiq baxùai manoh Êsau, khoi èh jò au hi glàm haq atìq, haq đìh yŏc au xam manoh lem!” ");
INSERT INTO hre_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","'Màng aih, dìq ca ngè aban khoi 'ràng adroi, mahaq cla Jacôp ŏi hlài ta traiq mang aih. ");
INSERT INTO hre_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mang aih raq, haq rìu 'nong dèh baiq toq mai, baiq ngai mangai cadrì patìh wa 11 toq con lam cwa diac con Jabôc. ");
INSERT INTO hre_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Haq 'nong wì, xam dìq dahwèq cùng hang, lam cwa diac con. ");
INSERT INTO hre_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Khoi èh, Jacôp ŏi hlài mòiq ngai. Èh i mòiq Ngai tabàt ca haq trùh 'ngah. ");
INSERT INTO hre_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jò Mangai aih hnoq dađeh ùh jah 'blêq, Haq jêh ca dêh mòiq 'mang jang caxènh cabŏng Jacôp. Caxènh cabŏng da Jacôp loh ca tablŏch 'nang jò tabàt. ");
INSERT INTO hre_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Mangai aih doi ca Jacôp: “Plình khoi ten 'ngah, hêq, đòiq au lam beq!” Mahaq Jacôp tèu: “Tàng Ìh ùh am ca au xôq ramŏt, au ùh am ca Ìh lam!” ");
INSERT INTO hre_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mangai aih bòch: “Hiniq ìh ca cleq?” Jacôp tèu: “Hiniq au Jacôp.” ");
INSERT INTO hre_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Mangai aih doi: “Hiniq ìh pi xài Jacôp hòm, mahaq hiniq ìh Is-ra-ên, ma jah 'màng aih ìh khoi tabàt ca Boc Plình wa wì 'noiq, èh ìh khoi ta'blêq.” ");
INSERT INTO hre_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacôp bòch: “Xìn am au loq ca hiniq ìh.” Haq tèu: “Gleq ìh bòch hiniq Au?” Khoi èh Haq am xôq ramŏt ca Jacôp ta nòi aih. ");
INSERT INTO hre_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacôp hiniq ca nòi aih Pe-ni-ên, taiq haq doi: “Au khoi hnoq Boc Plình ta jang ca hadrò wa au ŏi rìh!” ");
INSERT INTO hre_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jò haq lam cwa nòi Pê-nu-ên, mat mahì khoi tŏc, èh haq lam troq tinh tong jènh taiq khoi loh ca tablŏch caxènh cabŏng. ");
INSERT INTO hre_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Taiq nen aih trùh manàiq, jàn Is-ra-ên ùh caq hwen cataih da xech, ma jah 'màng aih Mangai aih khoi i jêh jang caxènh cabŏng da Jacôp nòi hwen cataih. ");
INSERT INTO hre_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacôp blèch mat ngan, tau hnoq Êsau 'nong 400 ngai lam trùh. Tajòi 'mòi Jacôp axong 'bài con ca Lêa wa Rachên, wa baiq ngai mangai cadrì patìh. ");
INSERT INTO hre_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Haq đòiq baiq ngai mangai cadrì patìh wa con caiq haq lam adroi, èh Lêa wa con caiq haq atìq, pulùch haq đòiq Rachên wa Jôsep. ");
INSERT INTO hre_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Èh Jacôp lam adroi ca wì rai lam rai bla-op dađeh ta taneh tapèh yàng enh ngìa dèh ca daq haq, aih Êsau. ");
INSERT INTO hre_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mahaq Êsau cadàu trùh jang Jacôp, oc wa hìp haq. Khoi èh wa oh daq hmoi ca dabau. ");
INSERT INTO hre_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Khoi èh Êsau blèch mat ngan hnoq 'bài mangai cadrì wa con caiq, haq bòch: “ 'Bài mangai ma lam ti oh cô, cabô?” Jacôp tèu: “Cô con caiq Boc Plình khoi am ca au.” ");
INSERT INTO hre_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Baiq ngai mangai cadrì patìh, 'ràng con caiq Jacôp thia haten ca Êsau, bla-op dađeh ta taneh. ");
INSERT INTO hre_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lêa wa con caiq haq hadai thia haten bla-op dađeh ta taneh; khoi èh, Rachên wa Jôsep thia haten, bla-op dađeh ta taneh. ");
INSERT INTO hre_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Êsau bòch: “ 'Bài ngè aban au glàm wì lam adroi, gè tình ca broq cleq?” Jacôp tèu: “Aih đòiq am ca ìh waq ca ìh xa-ŏch ca au.” ");
INSERT INTO hre_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Êsau doi: “Ôi oh! Au khoi i bàc, 'màng aih yŏc hlài dahwèq leq da oh beq!” ");
INSERT INTO hre_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacôp tèu hlài: “Ùh oq, au xìn ìh, tàng au khoi jah xôq jang ngìa ca ìh, xìn ìh nhàn yŏc 'bài cùng hang tì au khoi broq loh cô beq! Ma jah 'màng aih au hnoq daq tìah ca hnoq hadrò Boc Plình, taiq daq lem manoh đìh yŏc au, au bùi manoh dìq jaq! ");
INSERT INTO hre_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Xìn daq nhàn yŏc 'bài ngè au khoi am ca daq beq, ma jah 'màng aih Boc Plình khoi am ca au bình halùih xôq ramŏt, khoi tàu dŏng.” Jacôp xìn hrìn Êsau, èh Êsau nhàn yŏc da haq. ");
INSERT INTO hre_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Êsau doi: “Hêq, beq bèn hlài ta hnem au. Au jah ajèn oh.” ");
INSERT INTO hre_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Mahaq Jacôp tèu: “Ìh loq 'bài 'yoh nhèn ìuq, wa trìu, 'bo 'nang i con ùq. Tàng ep lam renh mòiq hì raq, yùq dìq ca calùh ngè aban cachìt. ");
INSERT INTO hre_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Xìn ìh lam adroi ca au. Au cadiang lam adia tiaq 'bài ngè aban wa 'bài 'yoh, èh hadai trùh hnem ìh ta gùng Sirò.” ");
INSERT INTO hre_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Êsau doi: “ 'Màng aih, au đòiq toq 'biaq ngai hapŏng da au ca oh.” Mahaq Jacôp tèu: “Ùh nhet! Ìh khoi pa'noh ca au manoh xa-ŏch, aih khoi lem dìq jaq yàu!” ");
INSERT INTO hre_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hì aih, Êsau lam ta trong hlài ta Sirò. ");
INSERT INTO hre_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacôp lam trùh Sucôt, broq ca dađeh hnem ŏi wa broq cadrong ca ngè aban, taiq 'màng aih, wì hiniq ca nòi cô, Sucôt. ");
INSERT INTO hre_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacôp cađac gùng Pađan Aram lam trong dìq jaq catèm trùh phôq Sichem ŏi ta gùng Ca-na-an, èh đòiq traiq jang ngìa phôq aih. ");
INSERT INTO hre_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Haq rŏt taneh nòi haq đòiq traiq, 100 capiac 'bac enh con calô da Hêmô, baq da Sichem. ");
INSERT INTO hre_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ta nòi aih, haq broq mòiq toq ca'bŏng tadreo, hiniq aih Boc Plình da Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","I mòiq hì Đina, con cadrì da Lêa wa Jacôp, loh lam hmàih ca 'bài gu cadrì gùng aih. ");
INSERT INTO hre_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sichem, con calô da bùa Hêmô mangai Hêwit, hnoq Hi Đina, rùp tango ca haq. ");
INSERT INTO hre_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Manoh Sichem ca'mùh ca'màu ca Đina, con cadrì Jacôp. Haq loq waq ca Đina wa capoch bàu rangot nhim đòiq Đina ca'naih hlài can loq waq. ");
INSERT INTO hre_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","'Màng aih, Sichem anoi ca Hêmô, am ca haq yŏc Đina broq mai. ");
INSERT INTO hre_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacôp hìa ca Sichem khoi broq raliang ca hiniq Hi Đina, con cadrì haq, mahaq 'bài con calô haq jiang ŏi ta đùng ti ngè aban, 'màng aih haq ùh capoch cleq trùh jò 'bài con haq hlài. ");
INSERT INTO hre_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Jò aih, Hêmô, baq Sichem, trùh ti Jacôp đòiq hatùang ca Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jò 'bài con calô Jacôp bu hìa bìac aih, wì hlài enh đùng. Wì loh mango wa nòih dìq jaq taiq bìac Sichem khoi broq amùa 'mèq 'mac cùi ŏi ti con cadrì da Jacôp, aih bìac ùh jò leq khòh broq ta Diac Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Mahaq bùa Hêmô doi ca wì: “Con calô au khoi enh waq ca con cadrì ìh. Xìn am haq ca con au broq mai. ");
INSERT INTO hre_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Bèn taprŏi ca dabau. Pì am con cadrì ca nhèn, khoi èh pì yŏc hlài con cadrì nhèn broq mai. ");
INSERT INTO hre_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Pì ŏi ti nhèn beq, èh gùng khoi padon đòiq ca pì. Ŏi ta cô beq, padro baxen wa jah đùng taneh ta cô.” ");
INSERT INTO hre_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Khoi, Sichem hadai anoi ca Jacôp wa con calô haq: “Xìn am au jah xôq jang ngìa pì. Bìac cleq pì bòch thê au am, au am ca pì. ");
INSERT INTO hre_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Xìn pì bòch ca au mòiq toq hiniang ŏng mai ma càn beq, au pachàuq ma bàc; au am tôm troi bàu pì ma doi, mahaq am con cadrì pì ca au broq mai.” ");
INSERT INTO hre_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Mahaq 'bài con calô Jacôp tèu hlài Sichem wa Hêmô, baq Sichem, xam trong capoch 'nùt wì, taiq Sichem khoi broq raliang amùa ca hiniq Hi Đina, oh wì haq. ");
INSERT INTO hre_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Wì doi 'màng cô: “Nhèn am oh cadrì nhèn ca mangai leq ma ùh i chìuq lè cat akia, aih bìac nhèn broq ùh jah, ma jah 'màng aih, aih mòiq bìac broq camaih ca nhèn. ");
INSERT INTO hre_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mahaq nhèn jah rùp bàu ca pì, jò pì wìh wìa tìah troi nhèn, aih rìm ngai gu calô pì phai chìuq lè cat akia. ");
INSERT INTO hre_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","'Màng aih, nhèn jah am dèh 'bài con cadrì nhèn ca pì, wa yŏc hlài con cadrì pì nhèn broq mai, khoi èh ŏi pajùm ti dabau, loh mòiq toq jàn raq. ");
INSERT INTO hre_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mahaq, tàng ùh waq tamàng tiaq bàu, ùh chìuq lè cat akia, nhèn yŏc hlài dèh con cadrì wa lam ŏi nòi 'noiq.” ");
INSERT INTO hre_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Toq leq nà wì haq anoi broq lem ca manoh Hêmô wa Sichem, con calô haq. ");
INSERT INTO hre_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Gu radam aih ùh chôiq ca rìm bìac ma khoi pajaq, ma jah 'màng aih, con cadrì Jacôp lem manoh haq. Cla Sichem, haq mangai jah wì loq iu yi hnao ca rìm ngai ta hnem baq haq. ");
INSERT INTO hre_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hêmô wa Sichem, con calô haq, lam trùh 'mang ngo phôq cla, anoi ca mangai jàn ta phôq 'màng cô: ");
INSERT INTO hre_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ 'Bài mangai aih caq ŏi hatroq ca bèn. 'Màng aih, am wì ŏi ta gùng đòiq padro, ma jah 'màng aih gùng cô ji càn rùng am ca wì haq ŏi. Bèn jah yŏc cadrì wì haq broq mai, wa am hlài con cadrì bèn ca wì haq. ");
INSERT INTO hre_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mahaq wì haq lem manoh ŏi ti bèn đòiq wìa mòiq toq jàn, tàng dìq ca gu calô ŏi pah bèn chìuq lè cat akia tìah troi rìm ngai gu calô da wì haq. ");
INSERT INTO hre_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","'Màng aih èh, 'bài ngè aban, 'bài cùng hang wa dìq ca calùh trìu 'bo da wì haq, ma ùh jah dŏng bèn 'mòh? Bèn broq mòiq manoh ca wì haq, èh wì haq ŏi pajùm ca bèn.” ");
INSERT INTO hre_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Rìm ngai loh jang 'mang ngo phôq, tamàng tiaq bàu Hêmô wa Sichem, con haq. Dìq dŏng con calô loh jang 'mang ngo phôq chìuq broq lè cat akia. ");
INSERT INTO hre_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Trùh hì piq, jò rìm ngai 'nang jìq dèh teo habau, wa baiq ngai con calô Jacôp, Si-mê-ôn wa Lêwi, daq Đina, wê mòiq ngai mòiq toq chang gùm, mùt ta phôq jò con jàn ùh 'nì, èh jêh đac dìq dŏng gu calô. ");
INSERT INTO hre_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Wa yŏc chang gùm jêh đac Hêmô wa Sichem, con calô haq, 'nong Hi Đina loh khoi enh hnem Sichem, khoi èh lam. ");
INSERT INTO hre_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Taiq nen mangai aih khoi broq amùa oh cadrì wì haq, 'mang aih 'bài con calô Jacôp tablah yŏc phôq đòiq jêh chau thai dèh ca oh. ");
INSERT INTO hre_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wì haq rùp dìq calùh trìu, 'bo, lùa wa dahwèq leq ŏi ta phôq wa ta đùng. ");
INSERT INTO hre_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wì haq hadai 'nong dìq dŏng cùng hang, 'bài con 'yoh, mangai cadrì, wa rìm ngè bìac ma 'noiq ŏi ta hnem. ");
INSERT INTO hre_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jacôp lech ca Si-mê-ôn wa Lêwi, haq doi: “Chôp khoi broq ca au 'bìq manhài! Chôp khoi broq ca mangai jàn gùng cô git ca bèn, aih jàn Ca-na-an wa jàn Pe-rê-xit! Bèn ŏi raq toq 'biaq ngai. Tàng wì haq yùp hlài tajêh bèn, èh wì jêh đac au wa cadraq au, dìq dŏng cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Wa tèu hlài: “Ma ùh nui chìuq mangai aih broq ca oh cadrì ma tìah ca gu cadrì tango yŏc 'bac.” ");
INSERT INTO hre_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Boc Plình doi ca Jacôp: “Yòng beq, tŏc ŏi ta Bêtên, broq ca'bŏng tadreo ca Boc Plình ta nòi aih, nòi Haq khoi mahno loh ca ìh jò ìh cadàu mot ca Êsau, daq ìh.” ");
INSERT INTO hre_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jacôp anoi dèh ca mai ca con wa rìm ngai ma lam tiaq haq: “Cađac dŏng dìq 'bài dua 'mù enh jàn 'noiq loh khoi enh pì beq, broq hadròih dađeh, èh atùa eo yôh. ");
INSERT INTO hre_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Hi khoi bèn phai yòng lam trùh Bêtên. Bèn broq mòiq toq ca'bŏng tadreo am ca Boc Plình ta nòi Haq khoi tamàng bàu au jò au glàm bìac yat, wa Haq khoi ŏi ti au jò lam ta trong.” ");
INSERT INTO hre_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Wì am dŏng dìq ca Jacôp 'bài dua 'mù enh jàn 'noiq, wa 'bài hatai wì đang halŏng jang don. Jacôp catùh 'bài ngè aih jang xèm long rayai haten ca phôq Sichem. ");
INSERT INTO hre_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Jò wì haq rai lam, Boc Plình broq ca mangai ta phôq ŏi dudan ca aih dìq yùq crè. 'Màng aih wì ùh hùa hnan tiaq 'bài con calô Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacôp wa rìm ngai ma lam tiaq haq lam trùh ta Luxò, aih Bêtên ta gùng Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Jacôp broq mòiq toq ca'bŏng tadreo ta aih. Hiniq ca nòi aih, En Bêtên, aih nòi Boc Plình khoi mahno loh ti haq jò haq cadàu mot dèh ca daq haq. ");
INSERT INTO hre_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Jò aih Đê-bô-ra, mangai enh nèh wèq Rê-bê-ca, cachìt, èh jah catùh ta phôq Bêtên, ŏi enh 'neq xèm long rayai. Èh wì creo long aih, An-lôn-ba-cut. ");
INSERT INTO hre_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jò Jacôp loh enh gùng Pađan Aram, Boc Plình mahno loh hòm ti haq, am xôq ramŏt ca haq, ");
INSERT INTO hre_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","doi: “Hiniq ìh Jacôp, atìq cô èh pi creo Jacôp hòm, mahaq hiniq òn, aih Is-ra-ên.” 'Màng aih, Haq creo haq Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Boc Plình doi hòm: “Au cô Boc Plình I Cwìang Itai Dìq Dŏng! Ìh xa-ông bàc tam beq! Èh enh xinoi ìh jah i mòiq toq jàn, mahaq bàc jàn, wa bàc 'bài bùa hadai loh enh xinoi ìh. ");
INSERT INTO hre_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Gùng Au khoi am ca Ap-ra-ham, wa Isac, èh Au ji am ca ìh wa xinoi ìh.” ");
INSERT INTO hre_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Hi khoi, Boc Plình tŏc khoi ca nòi aih. ");
INSERT INTO hre_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacôp pa'nàng mòiq toq long jrang xam hmu jang nòi Boc Plình ma anoi ca haq, ùc 'noh lè dèch am dahwèq ôq wa pùc dàu ta hmu aih. ");
INSERT INTO hre_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Khoi èh, Jacôp hiniq ca nòi Boc Plình ma anoi ca haq, aih Bêtên. ");
INSERT INTO hre_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ŏi enh Bêtên wì haq loh lam. Jò ten trùh Ep-ra-ta, èh Rachên jìq xa-ông, bìac xa-ông da haq dìq jaq xa. ");
INSERT INTO hre_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Jò xa-ông xa, mangai cadrì jùp xa-ông doi: “Apaq crè, ma jah 'màng aih, ìh jah i tam mòiq toq con calô hòm.” ");
INSERT INTO hre_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mahaq, jò Rachên ten pat hihèm, haq hiniq ca con calô aih Bên-ô-ni, mahaq baq haq hiniq ca haq Bên-ja-min. ");
INSERT INTO hre_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Khoi ca aih, Rachên cachìt, èh jah catùh ti nòi trong lam ta Ep-ra-ta, aih 'Bêt-lê-hem. ");
INSERT INTO hre_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacôp pa'nàng mòiq toq jrang hmu đòiq patô cadràng hanang da Rachên, trùh hì cô xôq ŏi i. ");
INSERT INTO hre_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Atìq ca aih, Is-ra-ên lam, đòiq traiq ŏi enh gùng ca nòi hnem gòm ha'nhèq Mitđan Êđa. ");
INSERT INTO hre_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Wop jò Is-ra-ên ŏi ta gùng cô, èh Rubên i cùi ŏi ti Bila, mai yang da baq haq. Is-ra-ên hìa tàng bìac aih. ");
INSERT INTO hre_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Cô hiniq 12 ngai con calô da Jacôp: 'Bài con calô da Lêa, aih Rubên, con ramua Jacôp. Tìa, aih Si-mê-ôn, Lêwi, Juđa, I-sa-ca wa Xe-bu-lun. ");
INSERT INTO hre_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Con calô da Rachên: Jôsep wa Bên-ja-min. ");
INSERT INTO hre_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Con da Bila, mangai patìh da Rachên, aih Đan wa Nep-ta-li. ");
INSERT INTO hre_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Con da Xinpa, mangai patìh da Lêa, aih Gat wa Ase. Aih dìq ca con calô da Jacôp xa-ông loh ta gùng Pađan Aram. ");
INSERT INTO hre_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Khoi èh, Jacôp trùh ta Isac, baq haq, ŏi ta Mamrê ta phôq Ki-ri-at A-ra-ba, aih Hêprôn, nòi Ap-ra-ham wa Isac khoi ŏi. ");
INSERT INTO hre_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isac halình jah 180 hanam. ");
INSERT INTO hre_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Hi khoi, haq cachìt jah ahlài ti boc yaq. Êsau wa Jacôp, baiq ngai con calô haq, catùh haq. ");
INSERT INTO hre_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Cô xinoi da Êsau, aih Êđôm. ");
INSERT INTO hre_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Êsau yŏc piq toq mai, dìq 'bài con cadrì gùng Ca-na-an: Ađa, con cadrì Êlon, mangai Hêtit; Ô-hô-li-ba-ma, con cadrì Ana, xau pah miq da Xi-bê-ôn, mangai Hêwit. ");
INSERT INTO hre_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Haq hadai yŏc Ba-sê-mat, con cadrì Ich-ma-ên, wa oh cadrì da Nê-ba-jôt. ");
INSERT INTO hre_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ađa xa-ông ca Ê-li-pha. Ba-sê-mat xa-ông Ruên. ");
INSERT INTO hre_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Khoi èh, Ô-hô-li-ba-ma xa-ông ca Jêut, Jalam wa Côra. Cô 'bài con calô da Êsau khoi xa-ông ta gùng Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Êsau 'nong dèh 'bài mai, 'bài con calô, con cadrì, wa dìq ca mangai ta hnem haq, 'bài ngè aban, wa cùng hang cla haq khoi broq loh ŏi ta gùng Ca-na-an, lam ta gùng 'noiq, hangai ca Jacôp, oh haq. ");
INSERT INTO hre_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ma jah 'màng aih, taiq wa oh daq cô i bàc cùng hang, calùh ngè aban bàc, gùng wa ma 'nang ŏi aih pi tôm tàu taneh abèq, 'màng aih wa pi jah ŏi pajùm. ");
INSERT INTO hre_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","'Màng aih, Êsau ŏi ta wang Sirò. Êsau aih Êđôm. ");
INSERT INTO hre_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Cô xinoi Êsau, baq da wì mangai Êđôm ŏi ta wang Sirò. ");
INSERT INTO hre_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Cô hiniq 'bài con calô Êsau: Ađa, mai haq xa-ông ca Ê-li-pha. Ba-sê-mat hadai mai haq, xa-ông ca Ruên. ");
INSERT INTO hre_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Con calô da Ê-li-pha, aih: Têman, Ôma, Xêphô, Gatam wa Kêna. ");
INSERT INTO hre_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, mai yang da Ê-li-pha, xa-ông ca A-ma-lec, aih xau Ađa, mai Êsau. ");
INSERT INTO hre_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Cô con calô da Ruên: Nahat, Xêra, Samah, Michxa. Aih 'bài xau da Ba-sê-mat, mai da Êsau. ");
INSERT INTO hre_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","'Bài mangai cô con calô da Ô-hô-li-ba-ma, mai Êsau: Con cadrì da Ana, xau pah miq Xi-bê-ôn. Haq xa-ông ca Jêut, Jalam wa Côra ca Êsau. ");
INSERT INTO hre_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","'Bài xau da Êsau wìh wìa craq broq gàu, aih 'bài con calô Ê-li-pha, con calô ramua da Êsau: Craq Têman, craq Ôma, craq Xêphô, craq Kêna, ");
INSERT INTO hre_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","craq Côra, craq Gatam wa craq A-ma-lec. Aih 'bài craq broq gàu loh enh Ê-li-pha wa Ađa ŏi ta gùng Êđôm. ");
INSERT INTO hre_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Cô 'bài con calô da Ruên, con Êsau: Craq Nahat, craq Xêra, craq Samah wa craq Michxa. Aih mangai broq gàu da Ruên ŏi ta gùng Êđôm. Wì haq 'bài con calô Ba-sê-mat, mai Êsau. ");
INSERT INTO hre_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Cô 'bài con calô da Ô-hô-li-ba-ma, mai Êsau, con Ana: Craq Jêut, craq Jalam wa craq Côra. ");
INSERT INTO hre_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aih 'bài con calô da Êsau, aih Êđôm wa dìq ca craq broq gàu. ");
INSERT INTO hre_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Cô 'bài con calô da Sirò, mangai Hôrit, wì ta gùng aih: 'Bài da Lôthan, da Sôban, da Xi-bê-ôn wa da Ana, ");
INSERT INTO hre_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Đisôn, Êxe wa Đisan. Wì aih craq broq gàu da con jàn Hôrit, con calô da Sirò ŏi ta gùng Êđôm. ");
INSERT INTO hre_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","'Bài con calô da Lôthan, aih: Hôri wa Hêman. Oh cadrì da Lôthan, aih Timna. ");
INSERT INTO hre_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","'Bài con calô da Sôban, aih: Anwan, Ma-na-hat, Êban, Shêphô wa Ônam. ");
INSERT INTO hre_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","'Bài con calô da Xi-bê-ôn, aih: Aija wa Ana. Aih mangai khoi chaq hnoq diac tamŏc tôq ta nòi braih càn, jò haq ban lùa da baq haq, aih Xi-bê-ôn. ");
INSERT INTO hre_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","'Bài con calô da Ana, aih: Đisôn wa con cadrì haq Ô-hô-li-ba-ma. ");
INSERT INTO hre_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","'Bài con calô da Đisôn, aih: Hemđan, Êchban, Itran wa Kêran. ");
INSERT INTO hre_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","'Bài con calô da Êxe, aih: Binhan, Xawan wa Acan. ");
INSERT INTO hre_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","'Bài con calô da Đisan, aih: Uxò wa Aran. ");
INSERT INTO hre_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Cô 'bài craq broq gàu da xinoi jàn Hôrit: Lôthan, Sôban, Xi-bê-ôn wa Ana, ");
INSERT INTO hre_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Đisôn, Êxe wa Đisan. Aih 'bài craq broq gàu da xinoi jàn Hôrit ŏi ta gùng Sirò. ");
INSERT INTO hre_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Cô hiniq 'bài bùa khoi wèq cwìang gùng Êđôm adroi ca jò jàn Is-ra-ên i bùa wèq cwìang: ");
INSERT INTO hre_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bêla, con calô da Bêô, wèq cwìang gùng Êđôm. Hiniq da phôq haq, aih Đin-ha-ba. ");
INSERT INTO hre_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Jò bùa Bêla cachìt, Jôbap, con calô Xêra, mangai Bôxra thai haq. ");
INSERT INTO hre_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jò bùa Jôbap cachìt, Husam, mangai enh gùng da wì jàn Têman thai haq. ");
INSERT INTO hre_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Jò bùa Husam cachìt, Hađat, con calô da Bêđat, thai haq. Bùa cô raq ma jêh 'blêq jàn Ma-đi-an ta đùng Moap. Hiniq phôq haq, aih Awit. ");
INSERT INTO hre_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Jò bùa Hađat cachìt, Samla, mangai Ma-rê-cah, thai haq. ");
INSERT INTO hre_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Jò bùa Samla cachìt, Saulò, mangai Rê-hô-bôt ŏi kenh Cròng Diac U-phra-tê, thai haq. ");
INSERT INTO hre_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Jò bùa Saulò cachìt, Ba-an Hanan, con calô Atbô, thai haq. ");
INSERT INTO hre_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Jò bùa Ba-an Hanan, con calô Atbô cachìt, Hađa thai haq. Hiniq phôq da haq, aih Pau. Mai haq Mê-hê-ta-bên, con cadrì da Matrêt, con cadrì Mê-xa-hap. ");
INSERT INTO hre_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Cô hiniq 'bài craq broq gàu da Êsau, tiaq dèh cadraq wa nòi ŏi. Hiniq wì haq 'màng cô: Timna, Anwa, Jêthêt, ");
INSERT INTO hre_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ô-hô-li-ba-ma, Êla, Pinon, ");
INSERT INTO hre_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kêna, Têman, Mipxa, ");
INSERT INTO hre_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Mac-đi-ên wa Iram. Dìq dŏng 'bài craq broq gàu cô da Êđôm, xinoi da Êsau, tiaq nòi wì. ");
INSERT INTO hre_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacôp ŏi ta gùng baq haq khoi ŏi, aih gùng Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Cô bìac xinoi da Jacôp. Jôsep, con Jacôp, jò khoi jah 17 hanam haq lam ban trìu ti 'bài daq haq, aih 'bài con da Bila wa Xinpa. Jôsep anoi hlài ca baq haq bàu 'mèq da wì haq. ");
INSERT INTO hre_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Is-ra-ên loq waq ca Jôsep yi hnao ca 'bài con ma 'noiq, ma jah 'màng aih haq con ma xa-ông clòi, 'màng aih Jacôp jìp ca Jôsep mòiq blah eo bàc nhum teo achìh. ");
INSERT INTO hre_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","'Bài daq haq hnoq dèh baq loq waq ca Jôsep yi hnao ca wì haq, 'màng aih wì loh ca i manoh git ca Jôsep. Wì pi enh capoch bàu habùat ca haq hòm. ");
INSERT INTO hre_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","I mòiq mang Jôsep cùi haq apô, xroq èh rìu, haq ta'mon hlài dèh ca 'bài daq tamàng, 'màng aih wì daq haq kiang git tam ca haq hòm. ");
INSERT INTO hre_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Haq anoi: Xìn pì daq tamàng au ta'mon hlài bìac apô au beq. ");
INSERT INTO hre_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Jò 'nang ŏi ta đùng rùang cô achauq 'mau, 'mau da au pa'nàng yòng, èh dìq achauq 'mau da pì daq trùh ŏi dudan bla-op dađeh jang ngìa achauq 'mau au. ");
INSERT INTO hre_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","'Bài daq haq tèu: “ 'Màng aih, gè jah wèq cwìang 'bài nhèn 'mòh?” Gè jah enh 'nhèq ca nhèn 'mòh? Taiq bìac haq apô wa bàu haq anoi aih, wì daq haq git tam ca haq yi hnao hòm. ");
INSERT INTO hre_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Jôsep cùi apô hòm, haq ta'mon hlài dèh ca 'bài daq: Pì phai tamàng bìac apô da au oq: Cô mat mahì, mat khê, wa 11 toq halŏng dìq bla-op dađeh jang ngìa au. ");
INSERT INTO hre_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Jôsep ta'mon hlài bìac apô aih dèh ca baq wa ca 'bài daq haq tamàng, mahaq baq haq lech ca haq doi: “Bìac apô da gè aih 'màng leq? I joq au, miq gè, 'bài daq gè dìq ep trùh bla-op dađeh ta taneh jang ngìa gè 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","'Bài daq haq i manoh ta'mrua ta'bì ca haq, phàn da baq haq hmàng đòiq bìac aih ta manoh. ");
INSERT INTO hre_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Èh 'bài daq haq lam ban calùh trìu baq haq ta Sichem. ");
INSERT INTO hre_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Is-ra-ên doi ca Jôsep: “ 'Bài daq gè ban trìu ta Sichem joq ùh? Thia cô, baq thê con lam trùh ti wì haq.” Jôsep tèu: “Cô au baq.” ");
INSERT INTO hre_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Is-ra-ên doi: “Gè lam beq ngan thù 'bài daq gè 'màng leq ŏi aiq đeh ùh, wa 'bài calùh trìu 'màng leq, khoi èh hlài doi ca baq loq.” 'Màng aih enh thòng tamang Hêprôn, haq thê lam trùh ta Sichem. ");
INSERT INTO hre_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","I mòiq ngai glàm haq ta đùng, bòch haq: “Ìh chaq cleq.” ");
INSERT INTO hre_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Haq tèu: “Au chaq 'bài daq au, xìn patô 'biaq ca au loq wì ban trìu nòi leq?” ");
INSERT INTO hre_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Haq doi: “ 'Bài daq ìh ŏi ta cô mahaq wì khoi lam, ma jah 'màng aih au tàng wì haq adràc dabau doi: ‘Beq bèn lam trùh Đôthan.’ ” 'Màng aih, Jôsep lam chaq dèh 'bài daq, jah glàm wì ta Đôthan. ");
INSERT INTO hre_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","'Bài daq haq hnoq haq lam ŏi enh hangai, 'nhòq trùh haten, wì khoi chaq trong jêh đac haq. ");
INSERT INTO hre_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wì doi ca dabau: “Tau, mangai ma apô khoi trùh! ");
INSERT INTO hre_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Beq bèn jêh đac haq, hwenh ca'nìh đac ta mòiq toq hàm, khoi èh bèn doi haq khoi 'bìq ngè rôm hich caq, khoi èh ngan bìac apô hnoq da haq loh 'màng leq.” ");
INSERT INTO hre_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubên tàng bàu aih, haq dŏng Jôsep loh khoi enh tì 'bài oh daq haq, haq doi: “Bèn apaq jêh haq cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rubên doi hòm: “Bèn ùh khòh broq ta-ùc ca mahem; hwenh haq ta hàm nòi wang wê, apaq đòiq tì ti chac haq.” Haq doi 'màng aih taiq haq i manoh enh ca'naih Jôsep claih enh ti wì daq haq đòiq ahlài Jôsep ca baq haq. ");
INSERT INTO hre_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Jò Jôsep bu trùh ti 'bài daq haq, wì lêh đac eo haq, aih eo i bàc nhum teo achìh haq 'nang caxùnh ta chac cla. ");
INSERT INTO hre_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Khoi èh rùp haq 'ràng ca'nìh đac ta hàm, ùh i ca diac. ");
INSERT INTO hre_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Khoi èh, wì ha'ngui acaq, blèch mat ngan hnoq mòiq lù jàn Ich-ma-ên ŏi pah Ga-la-at lam trùh. Ta crŏng lŏcđa wì haq i jan xua thùm, nhù hùang wa mùc jùac 'nang 'ràng lam trùh Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juđa doi dèh ca 'bài daq 'bài oh: “Jêh đac oh èh bèn cadoc mahem haq, jah i lòiq cleq ca bèn ùh? ");
INSERT INTO hre_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","'Màng aih beq bèn tech ca jàn Ich-ma-ên, apaq đòiq tì ta chac haq, ma jah 'màng aih haq oh bèn, haq mòiq xech ca bèn.” Dìq ca 'bài wì oh daq tàng tiaq bàu haq doi. ");
INSERT INTO hre_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Èh, jò 'bài mangai padro Ma-đi-an lam cwa pagat ti aih, 'bài daq Jôsep dùi haq tŏc enh hàm, khoi èh wì tech haq ca jàn Ich-ma-ên jah 20 hliac 'bac. Wì haq 'ràng Jôsep cwa gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubên wìh hlài ta hàm hnoq ùh i Jôsep. Haq hich dèh eo. ");
INSERT INTO hre_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Haq wìh hlài ta nòi 'bài oh haq doi, “Ôi, oh khoi hnhung ta leq? Phàn au cô èh lam ta leq?” ");
INSERT INTO hre_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","'Bài daq haq jêh mòiq toq bubi calô, khoi èh yŏc eo Jôsep 'nhrùq ta mahem. ");
INSERT INTO hre_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Khoi 'ràng eo bàc nhum aih hlài dèh ca baq, hi doi: “Cô ngè nhèn khoi chaq jah, 'màng aih xìn ngan beq, i joq eo con calô da baq loq ùh?” ");
INSERT INTO hre_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacôp ngan wa doi, “Òq, cô eo con calô au, mòiq toq ngè rôm khoi hich dŏng, hi caq dŏng jam chac Jôsep!” ");
INSERT INTO hre_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacôp hich dèh eo, yŏc bai briang caxùnh, ta-oih dèh ca con calô bàc hì. ");
INSERT INTO hre_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Dìq dŏng con calô, con cadrì pajùm ti dabau alòng dèh baq, mahaq baq wì haq ùh xùai ca mango, haq doi: “Au ta-oih dèh ca con trùh jò au loh ta ralùng.” 'Màng aih, baq Jôsep hmoi crò ca haq 'màng aih. ");
INSERT INTO hre_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","'Bài mangai padro Ma-đi-an 'ràng Jôsep trùh ta gùng Aicàp, tech ca Po-ti-pha cwan gòm rap da Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Atìq ca aih, Juđa lam hangai dèh ca 'bài daq haq, lam trùh ŏi ti mangai A-đu-lam, hiniq haq Hira. ");
INSERT INTO hre_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ta aih, Juđa hnoq mòiq ngai con cadrì Ca-na-an hiniq haq Sua, haq ta'nèp broq mai, caq ŏi ti Sua. ");
INSERT INTO hre_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Sua ŏi jiang, xa-ông mòiq toq con calô, hiniq ca haq Êrò. ");
INSERT INTO hre_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sua ŏi jiang hòm, xa-ông loh mòiq toq con calô, hiniq ca haq Ônan. ");
INSERT INTO hre_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Èh xa-ông tam mòiq toq con calô, hiniq ca haq Sêlah, jò wì ŏi ta Kêxip. ");
INSERT INTO hre_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juđa yŏc am ca Êrò con ramua haq mòiq toq mai, hiniq mai haq Tama. ");
INSERT INTO hre_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mahaq Êrò ngang dù jang ngìa ca Chuaq, 'màng aih Boc Plình jêh đac haq. ");
INSERT INTO hre_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Juđa doi ca Ônan: Con lam trùh cùi ŏi ti Tama, mai daq con đòiq broq xinoi ca daq gè. ");
INSERT INTO hre_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mahaq Ônan loq xinoi aih ùh xài da haq, 'màng aih jò cùi ŏi ti Tama, Ônan 'noh đac diac enh gùng waq ca Tama ùh jah ŏi jiang. ");
INSERT INTO hre_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Mahaq bìac broq aih ùh lem manoh ca Chuaq, 'màng aih Boc Plình hadai jêh đac hloi haq. ");
INSERT INTO hre_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Khoi èh, Juđa doi ca Tama mai con haq: “Con hlài ŏi hadrô 'màng 'mat ta hnem baq miq con beq, gòm jò leq Sêlah con calô baq hì càn.” Ma jah 'màng aih Juđa hèm: “Bèn phai ngan oq, èh yùq Sêlah hadai cachìt troi wa daq dìq.” Tama iu bàu aih hlài ŏi dèh ta hnem baq. ");
INSERT INTO hre_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Atìq toq leq hì, Sua mai Juđa cachìt. Jò khoi khwài ta manoh, Juđa adràc Hira, mangai A-đu-lam, tŏc ta Timna trùh nòi 'bài thòq cat xàc trìu haq. ");
INSERT INTO hre_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Wì bahìa ca Tama loq ca bìac aih. Wì doi: Cô, baq ŏng ìh lam tŏc ta Timna cat xàc trìu. ");
INSERT INTO hre_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tama lêh đac dèh eo hadrô, yŏc mù chê dèh hadrò cabàn dŏng dađeh, khoi èh ha'ngui jang 'mang plài Ê-na-im, ti trong trùh ta Timna. Haq broq 'màng aih taiq haq hnoq Sêlah khoi càn, mahaq wì ùh am haq ca Sêlah broq mai. ");
INSERT INTO hre_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Juđa hnoq Tama haq xoh đeh mangai tango yŏc 'bac, ma jah 'màng aih taiq Tama khoi chê dŏng dèh hadrò. ");
INSERT INTO hre_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Juđa thia haten doi: Am au trùh ti ìh oq, taiq Juđa ùh 'nì aih mai con cla haq. Gu cadrì aih tèu: “Ìh am ca au leq đòiq trùh ti au?” ");
INSERT INTO hre_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Juđa tèu: “Au gòi ca ìh mòiq toq bubi ta calùh bubi da au.” Gu cadrì aih bòch: “Ìh am ca au mòiq toq ngè baxon đòiq au jah lùi, trùh jò leq ìh men gòi am ca au bubi?” ");
INSERT INTO hre_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Juđa bòch: “Manàiq au đòiq hlài ngè baxon cleq waq ca ìh jah lùi?” Gu cadrì aih tèu: “Canhàng broq teo, caxi wa long canhra ìh ma wê nòi tì 'mat.” Juđa tajòi 'mòi am ca haq, hi khoi cùi ti haq, taiq 'màng aih Tama ŏi jiang. ");
INSERT INTO hre_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Khoi èh, haq yòng hlài dèh ta hnem, lêh đac mù chê hadrò, caxùnh hlài eo gu cadrì hadrô. ");
INSERT INTO hre_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juđa nhò Hira bua haq 'ràng am bubi ca gu cadrì aih đòiq yŏc hlài ngè baxon, mahaq chaq gu cadrì aih ùh hnoq. ");
INSERT INTO hre_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hira bòch 'bài jàn ta nòi gu cadrì aih ma doi: “Mangai tango yŏc 'bac jò adroi cô nèh ŏi ti trong nòi 'mang plài Ê-na-im khoi lam ta leq?” Wì tèu: “Ŏi ta cô ùh i ca mangai leq tango yŏc 'bac?” ");
INSERT INTO hre_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hira wìh hlài ta Juđa doi: “Au chaq gu cadrì aih ùh hnoq, èh jàn ta nòi aih hadai doi, ta cô ùh i mòiq ngai tango yŏc 'bac leq.” ");
INSERT INTO hre_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juđa doi: “Cô au khoi gòi bubi trùh, mahaq ìh chaq ùh hnoq haq, 'màng aih, đòiq ca gu cadrì aih wèq yŏc ngè đòiq lùi aih. Hêq, ùh bòch hòm đòiq ùh hìaq loq camaih.” ");
INSERT INTO hre_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Cadan piq khê atìq, i wì doi hlài ca Juđa: “Tama mai con ìh khoi broq mangai tango yŏc 'bac, taiq nen aih haq khoi ŏi jiang.” Juđa doi: “ 'Noh haq bùh đac beq.” ");
INSERT INTO hre_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Jò wì 'nang 'nong Tama loh, haq thê wì trùh anoi ca baq ŏng haq: “Xìn baq ngan hlài canhàng broq teo, caxi wa long canhra cô, ngè cabô. Au ŏi jiang enh mangai ma i ngè cô.” ");
INSERT INTO hre_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juđa ngan canao ca ngè aih, haq doi: “Haq ta-atoq yi hnao ca au taiq au ùh am Sêlah, con au ca haq.” Khoi èh, Juđa pi caq ŏi ti gu cadrì aih hòm. ");
INSERT INTO hre_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Trùh jò xa-ông, ta cliac haq i con camia. ");
INSERT INTO hre_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Jò 'nang xa-ông, mòiq ta baiq ngai con nga 'noh tì loh adroi, mangai ngan xa-ông rùp tì con nga aih càt brai gòh, rai doi: “Haq cô loh adroi.” ");
INSERT INTO hre_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mahaq con nga cô dùi 'mùt hlài dèh tì, èh daq haq loh. Mangai ngan xa-ông doi: “Gè 'màng leq loh adroi 'màng cô.” Taiq 'màng aih wì hiniq ca haq Perex. ");
INSERT INTO hre_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Èh oh haq loh atìq ma i brai gòh jang cŏng, wì hiniq ca haq Xêra. ");
INSERT INTO hre_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Jôsep 'bìq wì 'ràng cwa gùng Aicàp, èh Po-ti-pha, mangai gùng aih broq cwan wèq lình da Pha-ra-ôn, rŏt Jôsep ta tì jàn Ich-ma-ên khoi 'ràng trùh. ");
INSERT INTO hre_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Chuaq ŏi ti Jôsep, 'màng aih dìq ca bìac haq broq jah i lòiq jò ŏi ta hnem craq haq mangai Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Po-ti-pha hnoq Chuaq ŏi ti Jôsep ta rìm bìac, wa 'màng leq Chuaq broq rìm bìac da haq jah i lòiq wa dìq jaq gêh lem. ");
INSERT INTO hre_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Jôsep patìh lem, 'màng aih jah xôq jang ngìa craq haq. Craq haq thê haq wèq cwìang ta hnem, wa am dìq cùng hang dađeh ca Jôsep wèq. ");
INSERT INTO hre_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Pàng jò haq đòiq Jôsep wèq cwìang ta hnem wa dìq dŏng cùng hang haq, taiq i Jôsep, Boc Plình am xôq ramŏt ca hnem haq, 'màng aih bìac xôq ramŏt da Chuaq rai jàp rìm ngè da haq ma broq craq ŏi ta hnem, loq ŏi ta đùng. ");
INSERT INTO hre_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Haq jao dìq cùng hang haq am ca Jôsep wèq, pi lo bìac cleq hòm enh gùng ca 'bài dahwèq acaq. Jôsep i chac hamac lem lình, hadrò pàt hadai lem. Jôsep i chac hamac lem lình, hadrò pàt ji lem. ");
INSERT INTO hre_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Atìq ca bìac cô, mai craq haq enh waq ca Jôsep, haq doi: “Cùi ti au beq.” ");
INSERT INTO hre_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mahaq Jôsep tèu: “Ùh waq! Craq au khoi jao ta tì au rìm ngè bìac da haq, wa haq pi lo trùh bìac leq ta hnem hòm. ");
INSERT INTO hre_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ta hnem cô pi i cabô yi càn ca au. Craq au ùh padràng ca au bìac cleq enh gùng ca ìh, taiq ìh mai haq. Broq 'màng leq au ma hùa broq bìac dù càn caiq 'màng aih, èh broq lôi ca Boc Plình 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Enh hì cô trùh hì 'noiq haq padô Jôsep, mahaq Jôsep ùh waq, ùh broq tiaq bàu haq padô cùi ti haq loq ŏi haten ca haq. ");
INSERT INTO hre_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mahaq i mòiq hì aih, Jôsep mùt ta hnem abroq. Khoi èh, ùh i ca mòiq ngai calô ma 'noiq leq ŏi ti aih, ");
INSERT INTO hre_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","mai Po-ti-pha rùp eo Jôsep, haq doi: “Cùi ti au beq.” Mahaq Jôsep ranùh hlôch eo đòiq ta tì haq, cadàu mot enh gùng. ");
INSERT INTO hre_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Jò haq hnoq Jôsep khoi đòiq dèh eo ŏi ta tì haq, hi khoi cadàu mot loh enh gùng, ");
INSERT INTO hre_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","haq creo ca 'bài mangai ta hnem rai doi: “Pì ngan cô, haq 'ràng 'mùt ta hnem mòiq ngai mangai Yothaiq đòiq leoq bèn. Haq thia haten tình ca cùi ti au, mahaq au khoi cachech dêh. ");
INSERT INTO hre_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Jò haq tàng bàu au cachech dêh, haq lêh dèh eo đòiq jang au, cadàu mot enh gùng.” ");
INSERT INTO hre_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mai Po-ti-pha đòiq eo aih jang haq, gòm dèh ŏng hlài ta hnem. ");
INSERT INTO hre_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Hi khoi haq ta'mon hlài dèh ca ŏng troi bàu adroi: “Mangai Yothaiq ìh ma 'ràng ta hnem cô khoi thia haten đòiq leoq au, ");
INSERT INTO hre_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","mahaq jò au cachech bàu dêh, haq lêh dèh eo đòiq jang au, hi cadàu mot enh gùng.” ");
INSERT INTO hre_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Cla craq da Jôsep tàng dèh bàu mai doi: “Aih mangai hapŏng ìh broq bìac 'màng aih”, haq nòih dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Haq rùp Jôsep 'mùt ta hnem tù, aih nòi wì clêh 'bài mangai broq tôiq ca bùa. 'Màng aih Jôsep ŏi tù ta aih, ");
INSERT INTO hre_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Chuaq am xôq ca Jôsep pa'noh dèh manoh loq xa-ŏch ca haq, broq haq jah xôq jang ngìa craq gòm hnem tù. ");
INSERT INTO hre_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Craq wèq hnem tù jao dìq 'bài mangai ŏi tù ti tì Jôsep, ùh i bìac leq broq ma Jôsep ùh wèq dèh. ");
INSERT INTO hre_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Craq gòm hnem tù, ùh ep ti ngan hlài bìac khoi broq ŏi ta tì Jôsep taiq Chuaq am xôq ca haq, am bìac leq haq broq ji jah gêh lem. ");
INSERT INTO hre_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Atìq ca aih i cwan 'nình alac wa cwan awìh caq da bùa Aicàp broq tôiq dèh ca bùa cla wa. ");
INSERT INTO hre_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pha-ra-ôn loh nòih dèh ca baiq toq cwan cla haq, aih cwan 'nình alac wa cwan awìh caq. ");
INSERT INTO hre_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","'Màng aih haq clêh wa haq ta hnem tù cwan lình, aih nòi 'nang clêh Jôsep. ");
INSERT INTO hre_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Cwan hnem tù am Jôsep wèq baiq ngai cwan aih. Wì haq ta hnem tù dùnh hì, ");
INSERT INTO hre_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","èh trom mòiq mang, cwan 'nình alac wa cwan awìh caq da bùa Aicàp 'nang 'bìq clêh, apô hnoq, mòiq ngai mòiq bìac apô, mòiq bìac i mòiq hiniq crài ca dabau. ");
INSERT INTO hre_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Xroq èh, Jôsep trùh ti wa, hnoq hadrò wa mango hŏnh manoh. ");
INSERT INTO hre_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Jôsep bòch: “Hì cô gleq hadrò chôp mango 'màng cô?” ");
INSERT INTO hre_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wa tèu: “Ma i apô hnoq mòiq bìac mahaq ùh i ca cabô anoi paro hiniq.” Jôsep doi: “Bìac anoi paro apô ma ùh nhò enh nòi Boc Plình 'mòh? Xìn ta'mon hlài ca au bìac chôp ma apô hnoq.” ");
INSERT INTO hre_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Cwan 'nình alac ta'mon hlài ca Jôsep bìac haq apô hnoq, haq doi: “Jò apô, au hnoq mòiq xèm long nho jang ngìa au. ");
INSERT INTO hre_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Xèm long nho aih, i piq hamenh i loh ramŏt, loh riang, i plì dùm. ");
INSERT INTO hre_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Tì au 'nang wê doi da Pha-ra-ôn, au kech plì nho aih, hadroch diac plì ta doi, khoi èh dèch diac plì nho aih hnhu am ca Pha-ra-ôn.” ");
INSERT INTO hre_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Jôsep doi hiniq apô aih 'màng cô: “Piq toq hamenh nho, aih piq hì. ");
INSERT INTO hre_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Piq hì hòm, Pha-ra-ôn ca'naih cwan loh khoi enh hnem tù, am hlài da ìh bìac broq. Cwan jah am doi da Pha-ra-ôn ta tì haq troi dùnh, tìah ca troi jò ŏi broq cwan 'nình alac nèh. ");
INSERT INTO hre_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mahaq jò cwan jah broq hlài dèh bìac, xìn hmàng trùh ca au, hanò doi ca Pha-ra-ôn bìac da au, 'ràng au loh khoi nòi cô. ");
INSERT INTO hre_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ma jah 'màng aih au 'bìq wì rùp khoi ca gùng mangai Yothaiq. Ŏi ta nòi cô au hadai ùh i broq tôiq lôi cleq mahaq 'bìq wì clêh au ŏi ta tù cô.” ");
INSERT INTO hre_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Cwan awìh caq hnoq Jôsep anoi paro apô wìa lem, haq doi: “Phàn da au apô hnoq 'màng cô: Au côi piq rajo 'benh taboc ta gàu, ");
INSERT INTO hre_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ta rajo ma enh 'nhèq dŏng, i tôm rìm hiniq 'benh broq am ca Pha-ra-ôn, mahaq chìm jràp ta rojo ti gàu au, caq dahwèq caq aih.” ");
INSERT INTO hre_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jôsep padreo bàu doi: “Bìac apô aih 'màng cô: Piq rajo, aih piq hì. ");
INSERT INTO hre_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Trom piq hì hòm, Pha-ra-ôn càt ranŏng ìh 'ràng atua ta long đòiq chìm caq jam ìh.” ");
INSERT INTO hre_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Trùh hì piq, aih hì xa-ông ca bùa Pha-ra-ôn don 'noh hiniang caq dìq dŏng ca 'bài cwan. Pha-ra-ôn 'noh cwan 'nình alac wa cwan awìh caq loh khoi nòi ma clêh wa. ");
INSERT INTO hre_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Pha-ra-ôn am hlài da cwan 'nình alac bìac broq tìah ca jò adroi, aih hnhu doi alac ta tì Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mahaq am bàu thê 'ràng atua cwan awìh caq tìah troi bàu Jôsep khoi doi. ");
INSERT INTO hre_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mahaq cwan 'nình alac aih pi ŏi hmàng ca Jôsep hòm, hèt hloi ca haq. ");
INSERT INTO hre_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Baiq hanam atìq, Pha-ra-ôn cùi, haq apô hnoq dađeh yòng ti 'bò cròng diac Ninh. ");
INSERT INTO hre_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Cô, haq hnoq tapèh toq 'bo bech lem tŏc enh cròng diac, caq nhat ta'ne xèm cadia. ");
INSERT INTO hre_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Khoi èh cô, I tapèh toq 'bo 'noiq, 'mèq, ragìq, ŏi enh cròng diac tŏc atìq, trùh yòng haten ca 'bài 'bo ma adroi ti 'bò cròng diac. ");
INSERT INTO hre_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tapèh toq 'bo 'mèq, ragìq, lŏn tapèh toq 'bo bech lem. Pha-ra-ôn cadrat rìu. ");
INSERT INTO hre_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Bùa ca'nùng cùi hlài, apô hnoq yàng baiq, haq hnoq tapèh hadròc 'mau chac, lem hon pajùm mòiq xèm. ");
INSERT INTO hre_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Atìq ca aih tapèh hadròc 'mau manùh ma 'noiq taiq 'bìq cayeo pah mat mahì loh hlôi hŏnh, hon tiaq tapèh hadròc 'mau tau. ");
INSERT INTO hre_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Tapèh hadròc 'mau manùh lŏn tapèh hadròc 'mau chac. Pha-ra-ôn cadrat rìu, khoi loq aih mòiq bìac apô. ");
INSERT INTO hre_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Xrŏih xroq manoh haq ùh catèm, haq thê creo dìq 'bài mangai amòng broq bìac halac wa 'bài mangai thai rabiaq ta gùng Aicàp trùh, ta'mon hlài ca wì bìac haq apô. Mahaq ùh i ca mangai leq anoi paro jah apô aih am ca bùa. ");
INSERT INTO hre_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Èh cwan 'nình alac doi ca Pha-ra-ôn: “Manàiq cô au hmàng trùh dèh lôi da au. ");
INSERT INTO hre_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Adroi cô nèh, bùa loh nòih, i clêh ma cwan awìh caq, ta nòi hnem tù cwan wèq lình, ");
INSERT INTO hre_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ta aih pajùm mòiq mang, ma baiq ngai apô, mòiq ngai apô i mòiq hiniq dèh crài. ");
INSERT INTO hre_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Clêh pajùm ti ma i mòiq ngai mangai Yothaiq ŏi 'yoh hanam, mangai hapŏng wèq hnem da cwan wèq lình. Ma ta'mon hlài ca haq tamàng bìac apô da ma. Haq anoi paro 'noh bìac apô da mangai leq ro rang da mangai aih. ");
INSERT INTO hre_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Rìm bìac dìq troq troi haq ma anoi paro, aih au jah broq bìac hlài, haq tau 'bìq atua.” ");
INSERT INTO hre_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pha-ra-ôn thê lam ta Jôsep. Tajòi 'mòi wì trùh ca'naih Jôsep loh khoi enh hnem tù. Haq coih dèh xàc hadrò wa atùa eo, hi khoi mùt glàm Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pha-ra-ôn doi ca Jôsep: “Au khoi apô mahaq ùh i ca mangai leq jah anoi ro 'noh. Mahaq au tàng wì doi gè jah anoi hlài bìac apô.” ");
INSERT INTO hre_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Jôsep padreo bàu doi: “Aih ùh xài au, mahaq aih Boc Plình padreo ca bùa đòiq ìh jah i can catèm ta manoh.” ");
INSERT INTO hre_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pha-ra-ôn doi: “Cô au apô hnoq, au 'nang yòng ti 'bò cròng diac, ");
INSERT INTO hre_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","èh hnoq tapèh toq 'bo bech lem tŏc enh diac lam trùh caq nhat ta'ne xèm cadia ti kenh diac. ");
INSERT INTO hre_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Khoi èh tapèh toq 'bo 'noiq 'mèq, ragìq tŏc atìq, joq 'nàng au 'nhòq lah hnoq ta gùng Aicàp cô i 'bài 'bo 'mèq 'màng cô jò leq. ");
INSERT INTO hre_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tapèh toq 'bo 'mèq ragìq aih lŏn tapèh toq 'bo bech ma adroi. ");
INSERT INTO hre_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Lŏn mùt ta cliac, mahaq tìah ca ùh i lŏn, ma jah 'màng aih 'bài 'bo aih xôq 'mèq troi adroi; au cadrat rìu. ");
INSERT INTO hre_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Khoi èh cùi hlài. Au apô hnoq bìac 'noiq hòm, aih tapèh hadròc 'mau lem hon pajùm mòiq xèm. ");
INSERT INTO hre_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Atìq ca aih, tapèh hadròc 'mau ma 'noiq hŏnh, manùh, hon tiaq tapèh hadròc 'mau adroi. ");
INSERT INTO hre_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tapèh hadròc 'mau manùh lŏn tapèh hadròc 'mau i chac. Au khoi ta'mon hlài bìac apô cô am ca 'bài mangai amòng broq bìac halac, mahaq ùh i cabô anoi paro jah.” ");
INSERT INTO hre_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Jôsep doi ca Pha-ra-ôn: “Baiq bìac apô bùa khoi apô hnoq, aih pajùm mòiq trong hiniq raq. Boc Plình mahno ca bùa loq adroi bìac Haq padon broq. ");
INSERT INTO hre_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tapèh toq 'bo bech, aih tapèh hanam, tapèh hadròc 'mau chac, aih hadai tapèh hanam. Aih pajùm mòiq toq apô raq. ");
INSERT INTO hre_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Tapèh toq 'bo 'mèq, tiaq atìq 'bài tau, aih tapèh hanam. Tapèh hadròc 'mau manùh 'bìq cayeo broq croh, aih tapèh hanam pangot hrah. ");
INSERT INTO hre_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Aih bìac au khoi doi ca bùa. Boc Plình am bùa hnoq bìac haq padon broq. ");
INSERT INTO hre_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Cô, jàp ta gùng Aicàp, i tapèh hanam jah i 'mau mì bàc dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mahaq tapèh hanam atìq ca tapèh hanam aih, pangot hrah. Jàn gùng aih dìq hèt ca bìac 'mau mì bàc dìq jaq aih, can pangot hrah broq taneh lem 'bìq raliang. ");
INSERT INTO hre_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Taiq bìac pangot hrah càn hrìn cô hatiaq dabau, 'màng aih phù cròng pi i hmàng cleq ta jò i bàc dìq jaq adroi. ");
INSERT INTO hre_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Taiq bìac apô trùh ca bùa baiq yàng, aih Boc Plình dì broq bìac aih Haq renh broq đòiq wìa 'màng aih. ");
INSERT INTO hre_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Manàiq cô bùa ep chaq mòiq ngai i manoh hèm thài wa khôn rabiaq, am haq tŏc broq gàu ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Hadai yŏc 'bài mangai wiang broq rìm nòi ta Aicàp đòiq tagop mòiq phàn padam dahwèq caq trom tapèh hanam ma i bàc dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Wì haq phai tagop yŏc dìq dŏng mòiq phàn padam dahwèq trom tapèh hanam ma i bàc dìq jaq, don đòiq 'mau mì ta dìq ca hapom don đòiq bùa ta 'bài phôq đòiq wì haq wèq dìq dŏng. ");
INSERT INTO hre_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","'Bài dahwèq caq cô phai đòiq hanìuq ca tapèh hanam pangot hrah padon trùh ca gùng Aicàp đòiq gùng cô ùh hìaq cachìt taiq bìac pangot hrah aih.” ");
INSERT INTO hre_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Bàu cô da Jôsep lem manoh Pha-ra-ôn wa 'bài cwan haq. ");
INSERT INTO hre_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pha-ra-ôn doi ca 'bài cwan, bèn chaq ta leq jah mangai i yiang Boc Plình ŏi ti haq tìah ca mangai cô 'mòh? ");
INSERT INTO hre_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pha-ra-ôn doi ca Jôsep: “Nhò Boc Plình broq am ca gè jah loq rìm bìac cô, ùh i ca mangai leq i manoh hèm thài wa khôn rabiaq troi gè hòm. ");
INSERT INTO hre_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","'Màng aih, ìh jah tŏc wèq cwìang hnem au wa dìq dŏng 'bài jàn da au phai iu tiaq bàu ìh. Toq au yi càn ca ìh taiq au ha'ngui ta gèq bùa raq.” ");
INSERT INTO hre_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pha-ra-ôn doi hòm ca Jôsep: “Cô, au am gè wèq cwìang jàp ta gùng Aicàp.” ");
INSERT INTO hre_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tajòi 'mòi bùa dŏih dèh canhàng broq teo ta tì cla, xrôp mùt ta tì Jôsep, thê caxùnh eo bai habùac lem, ta'mac caxi tagwat xam wang 'mùt jang ranŏng haq. ");
INSERT INTO hre_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Khoi èh thê tŏc ha'ngui ta xê atìq ca xê bùa, i mangai lam adroi cachech doi: “Hacùn cràng beq”. 'Màng aih haq atŏc Jôsep jah wèq cwìang jàp gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pha-ra-ôn doi hòm ca Jôsep: “Au Pha-ra-ôn, mahaq gè ma jah wèq cwìang jàp ta gùng Aicàp. Tàng gè ùh am, èh ùh i cabô jah dèch tì loq dèch jènh.” ");
INSERT INTO hre_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pha-ra-ôn hiniq ca Jôsep Xa-phe-nat Pa-nê-ah, 'ràng Hi A-sê-na con cadrì Poti Phêra, craq pajàu broq gàu phôq Ôn, ca haq broq mai. Jôsep jah wèq cwìang dìq ca gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Jôsep jò 30 hanam haq broq mangai wèq cwìang dìq ca gùng Aicàp. 'Màng aih haq loh enh nòi Pha-ra-ôn hi khoi haq lam ngan jàp ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ta tapèh hanam jah i rah, taneh loh lòiq bình halùih. ");
INSERT INTO hre_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Jôsep gop yŏc dìq dŏng 'mau mì da tapèh hanam aih ta gùng Aicàp, đòiq 'mau mì cô jàp ta rìm ca 'bài phôq, ta mòiq phôq i mòiq nòi đòiq 'mau mì da đùng ŏi dudan da phôq aih. ");
INSERT INTO hre_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","'Màng aih, Jôsep gop yŏc 'mau mì bàc dìq jaq, tìah ca braih diac raxìq, dìq jaq bàc wì rèn pi nui dìq, ma jah 'màng aih bình halùih bàc hrìn. ");
INSERT INTO hre_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Adroi ca hanam pangot hrah trùh, A-sê-na, con cadrì Poti Phêra pajàu broq gàu phôq Ôn, xa-ông ca Jôsep baiq toq con calô. ");
INSERT INTO hre_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Jôsep hiniq dèh ca con ma ramua Ma-na-se taiq haq doi: “Boc Plình khoi broq ca au hèt bìac xalep au wa dìq ca hnem baq au.” ");
INSERT INTO hre_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Haq hiniq dèh ca con ma tìa Ep-ra-im, taiq haq doi: “Boc Plình broq ca au jah padrŏng can ta gùng au glàm bìac 'bìq baxa.” ");
INSERT INTO hre_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tapèh hanam jah jò i rah ta gùng Aicàp hi cwa, ");
INSERT INTO hre_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","wa tapèh hanam pangot hrah baxèm tiaq Jôsep khoi pajaq. Dìq ca gùng ŏi wawenh hadai 'bìq pangot hrah, mahaq ta gùng Aicàp i 'benh caq. ");
INSERT INTO hre_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mahaq jò jàp ta gùng Aicàp 'bìq pangot hrah, 'bài jàn lam trùh creo xìn Pha-ra-ôn, am dahwèq caq. Pha-ra-ôn doi ca 'bài jàn: “Lam trùh jang Jôsep beq, khoi èh broq tiaq bàu haq tanap.” ");
INSERT INTO hre_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Jò jàp ta cròng taneh 'bìq pangot hrah, Jôsep pèh rìm hapom 'mau mì tech ca jàn Aicàp. Pangot hrah khoi wìa hlàm dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Jàp crŏng taneh 'bìq pangot hrah, 'màng aih jàn gùng leq xôq trùh ta Aicàp rŏt 'mau mì. Jôsep tech ca wì. ");
INSERT INTO hre_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacôp hìa ta gùng Aicàp i 'mau mì, haq doi dèh ca 'bài con calô, gleq pì ma ngan dabau 'màng 'mat? ");
INSERT INTO hre_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Èh haq doi hòm: Cô, baq tàng ta gùng Aicàp i tech 'mau mì. Pì loh ta aih rŏt ca bèn 'mau mì beq đòiq bèn jah rìh ùh hìaq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Mòiq jàt ngai daq Jôsep loh ta gùng Aicàp đòiq rŏt 'mau mì. ");
INSERT INTO hre_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mahaq Jacôp ùh am Bên-ja-min, oh Jôsep lam dèh ti 'bài daq, ma jah 'màng aih haq doi: “Èh yùq bìac 'mèq ranàc loh ti haq.” ");
INSERT INTO hre_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","'Màng aih 'bài con calô da Is-ra-ên hadai loh ta Aicàp rŏt 'mau mì pajùm mangai 'noiq taiq manàiq cô gùng Ca-na-an pangot hrah. ");
INSERT INTO hre_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Jò aih, Jôsep broq cwan wèq cwìang ta gùng aih. Haq tech 'mau mì ca dìq ca jàn ta gùng aih. 'Bài daq Jôsep trùh bla-op dađeh jang ngìa haq. ");
INSERT INTO hre_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Jôsep hnoq, ngan canao dèh ca 'bài daq, mahaq haq broq dađeh ùh canao ca 'bài wì haq, haq capoch gao ca wì: “Pì ŏi enh leq trùh?” Wì tèu: “Ŏi enh gùng Ca-na-an trùh rŏt 'mau.” ");
INSERT INTO hre_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","'Nhac Jôsep ngan canao dèh ca 'bài daq haq, 'bài daq haq ùh canao ca haq. ");
INSERT INTO hre_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Jôsep hmàng hlài bìac apô haq khoi hnoq bìac 'bài oh daq haq, hi doi dêh: “Pì mangai rinh ngan! Pì khoi trùh ta cô đòiq ngan atùng nòi ma ìuq da gùng nhèn!” ");
INSERT INTO hre_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wì tèu: “Ôi Chuaq, ùh xài 'màng aih, 'bài hapŏng ìh trùh đòiq rŏt 'mau raq. ");
INSERT INTO hre_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nhèn cô con mòiq baq, wa nhèn mangai capoch bàu joq 'nàng, nhèn ùh xài mangai rinh ngan.” ");
INSERT INTO hre_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Jôsep doi ca wì: “Ùh xài! Pì trùh đòiq ngan atùng 'bài nòi ma ìuq ta gùng cô.” ");
INSERT INTO hre_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Wì tèu: “Nhèn hapŏng Chuaq i 12 ngai oh daq, con da mòiq baq ŏi ta gùng Ca-na-an, mangai ma ùch ŏi ta hnem ti baq nhèn wa mòiq ngai khoi hnhung.” ");
INSERT INTO hre_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Mahaq Jôsep doi: “Aih raq, joq 'nàng au khoi doi, pì mangai rinh ngan. ");
INSERT INTO hre_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Cô bìac au thù pì: Au patô can rìh Pha-ra-ôn, au pachac, tàng oh ùch pì ùh trùh nòi cô, pì ùh jah loh khoi nòi cô! ");
INSERT INTO hre_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Thê mòiq ngai ŏi ta pì hlài 'nong oh ùch pì loh ta cô beq, èh pì ma 'noiq ŏi tù ta cô gòm, đòiq bàu pì capoch ca au ep thù hòiq, khoi èh, au jah loq bàu pì capoch aih i joq 'nàng ùh. Mahaq tàng ùh joq 'nàng, nhò can rìh Pha-ra-ôn au pachac, pì mangai rinh ngan.” ");
INSERT INTO hre_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Khoi èh, Jôsep thê 'ràng clêh dìq ca wì pajùm ta hnem tù piq hì. ");
INSERT INTO hre_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Hì ma piq, Jôsep doi ca wì: “Pì broq bìac cô đòiq jah rìh oq, ma jah 'màng aih au loq iu crè Boc Plình. ");
INSERT INTO hre_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tàng pì mangai capoch bàu joq 'nàng, pì đòiq hlài mòiq ngai ŏi tù ta cô, èh pì ma 'noiq 'ràng 'mau mì ahlài ta hnem pì beq đòiq ban cadraq 'nang pangot. ");
INSERT INTO hre_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Khoi èh, 'ràng oh ùch loh ta cô đòiq au jah loq bàu pì doi cô joq 'nàng, èh pì ùh hìaq ep cachìt.” 'Màng aih wì broq tiaq bàu cô. ");
INSERT INTO hre_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wì haq doi ca dabau: “Joq 'nàng bèn khoi i lôi ca oh bèn, ma jah 'màng aih jò adroi nèh bèn hnoq ta manoh haq mango jò haq xìn rangoq thê bèn ca'naih haq, mahaq bèn ùh enh tamàng haq, 'màng aih bìac ùh lem cô khoi trùh ca bèn.” ");
INSERT INTO hre_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubên tèu: “Au ma ùh khoi doi ca pì, apaq broq tôiq ca mangai 'yoh aih 'mòh, mahaq pì oh ùh tamàng. Taiq 'mang aih, manàiq cô mahem haq bèn phai đèn hlài.” ");
INSERT INTO hre_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wì haq xoh Jôsep ùh 'nì tàng bàu wì haq capoch, ma jah 'màng aih Jôsep nhò mòiq ngai anoi hlài bàu haq anoi tùang ca 'bài daq haq. ");
INSERT INTO hre_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Jôsep tawìh lam pah 'noiq, haq hmoi, hi khoi wìh hlài capoch tùang ca wì. Èh haq thê rùp càt Si-mê-ôn jang ngìa wì haq. ");
INSERT INTO hre_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Jôsep thê hapŏng ùc 'mau bình ca 'bao wì haq wa đòiq hlài 'bac ta aih am ca rìm ngai oh daq ji đòiq tam dahwèq caq ca trong hòm. Hapŏng broq tiaq troi bàu Jôsep ma thê. ");
INSERT INTO hre_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Khoi èh, wì haq tah 'bao 'mau mì aih ta crŏng lùa hi khoi wì hlài. ");
INSERT INTO hre_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Trùh hnem padài, mòiq ngai ta wì haq pèh 'bao am ca lùa caq 'mau mì, hnoq 'bac ŏi angah 'bao. ");
INSERT INTO hre_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Haq doi dèh ca oh daq: “ 'Bac au wì am hlài, manàiq cô ŏi ta 'bao au cô.” 'Bài oh daq yùq crè, rai anoi ca dabau rai tarìt, wì doi: “Boc Plình khoi broq cleq ca bèn 'màng cô?” ");
INSERT INTO hre_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Wì oh daq hlài ta Jacôp, baq wì haq ta gùng Ca-na-an, ta'mon hlài ca haq tamàng rìm bìac khoi trùh ca wì haq. ");
INSERT INTO hre_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mangai ma 'nang broq craq ta gùng Aicàp capoch gao ca nhèn, doi nhèn mangai lam rinh ngan.” ");
INSERT INTO hre_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mahaq nhèn doi ca haq: “Nhèn mangai capoch bàu joq 'nàng, nhèn ùh xài mangai rinh ngan. ");
INSERT INTO hre_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nhèn i 12 ngai oh daq con mòiq baq, mòiq ngai khoi hnhung, phàn mangai ma ùch manàiq cô ŏi ta hnem baq, ta gùng Ca-na-an.” ");
INSERT INTO hre_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Mangai broq craq gùng aih doi ca nhèn: “Cô trong broq đòiq au lùi pì mangai joq 'nàng, 'màng aih pì đòiq hlài ca au mòiq ngai, hi khoi pì lam 'ràng 'mau mì ta hnem ban cadraq 'nang pangot. ");
INSERT INTO hre_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Hi khoi 'ràng oh ùch pì loh ca au, 'màng aih au men lùi pì ùh xài mangai rinh ngan, mahaq mangai capoch bàu joq 'nàng, au am hlài da pì oh, èh pì hadai jah padro baxen ta gùng cô.” ");
INSERT INTO hre_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Èh, jò 'bài oh daq ùc 'mau enh 'bao hnoq caxop 'bac da tang ngai. Jò baq wa 'bài oh daq hnoq 'bài caxop 'bac cla, wì crè. ");
INSERT INTO hre_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacôp baq wì haq doi: “Pì bahnhung đac con au, Jôsep khoi hnhung, Si-mê-ôn hadai ùh hnoq, manàiq cô pi enh 'nong Bên-ja-min lam hòm 'mòh? Rìm bìac cô dìq tajraq hlài ca au.” ");
INSERT INTO hre_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubên doi hlài dèh ca baq: “Baq am oh au beq, au jah 'nong oh ahlài. Tàng au ùh 'nong oh hlài, èh baq jah jêh đac baiq toq con calô au beq.” ");
INSERT INTO hre_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mahaq Jacôp tèu: “Con ùch au joq 'nàng ùh lam ti pì, ma jah 'màng aih daq haq khoi cachìt, ŏi mòiq ngai haq raq, tàng i bìac ùh lem trùh ca haq roc trong pì lam, joq 'nàng pì broq ca mangai co gàu cô mango loh ta ralùng.” ");
INSERT INTO hre_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Bìac pangot hrah ta gùng aih càn dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jò caq dìq ca 'mau mì ma ahlài enh Aicàp, baq wì haq doi: “Pì loh rŏt ca bèn toq biaq 'mau mì beq.” ");
INSERT INTO hre_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juđa tèu: “Mangai aih pa'yèp nhèn con, tàng oh ùch pì ùh loh tiaq pì, èh pì pi jah hnoq hadrò au. ");
INSERT INTO hre_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tàng baq am oh ùch lam, èh nhèn men jah loh Aicàp rŏt 'mau mì am ca baq. ");
INSERT INTO hre_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tàng baq ùh am haq lam, èh nhèn ùh lam taiq mangai aih khoi doi, tàng oh ùch pì ùh loh tiaq pì, èh ùh jò leq pì jah hnoq hadrò au.” ");
INSERT INTO hre_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Is-ra-ên doi: “Gleq pì ma broq 'mèq ca au, anoi ca mangai aih loq pì ŏi i mòiq toq oh hòm?” ");
INSERT INTO hre_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wì tèu: “Mangai aih bòch nhèn geo hrìn, bòch oh daq nhèn, bòch baq pì ŏi rìh ùh? Ŏi i oh daq leq ùh? Nhèn khoi tèu 'bài bàu haq ma bòch aih. Nhèn ùh tem loq ca mangai aih ma tanap ca nhèn: Ep 'ràng oh ùch pì loh ta cô beq.” ");
INSERT INTO hre_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juđa doi ca Is-ra-ên baq haq: “Am con 'yoh tiaq au beq, èh nhèn lam manàiq raq waq ca bèn wa 'bài xau da baq jah rìh wa claih ca cachìt. ");
INSERT INTO hre_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Au xìn nhàn wèq oh au, baq am haq lam ti au oq. Tàng au ùh ahlài haq, ùh đòiq haq jang ngìa baq, èh cla au nhàn dŏng lôi aih hloi hloi. ");
INSERT INTO hre_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Joq 'nàng tàng ùh i bìac patrò, nhèn khoi lam hlài jah baiq wìt.” ");
INSERT INTO hre_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Hi khoi Is-ra-ên baq wì doi: “Tàng bìac ep 'màng aih, pì phai broq 'màng cô: Ràih yŏc 'bài ngè bìac lem ta gùng bèn beq, toq 'biaq nhù hùang wa diac xùt, dahwèq xua thùm, mùc jùac, clong caxa wa clong apriac, 'ràng am ca mangai aih. ");
INSERT INTO hre_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Wê tam 'bac baiq phàn pì ma wê yàng adroi, đòiq padreo hlài 'bac wì ma khoi đòiq jang 'ngah 'bao 'mau pì. Ùac aiq wì haq broq ùh troq. ");
INSERT INTO hre_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Pì yòng lam beq, 'nong oh ùch pì lam ta mangai aih. ");
INSERT INTO hre_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Waiq xìn Boc Plình I Cwìang Itai Dìq Dŏng broq ca pì jah xôq jang ngìa mangai aih, èh ca'naih Bên-ja-min wa Si-mê-ôn am ca pì. Phàn da baq, tàng hnhung ca con, èh baq ji chìuq 'màng aih raq.” ");
INSERT INTO hre_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","'Màng aih, 'bài wì oh daq 'ràng ngè am aih, wê ta tì 'bac baiq phàn wa Bên-ja-min, lam loh ta Aicàp, yòng enh ngìa Jôsep. ");
INSERT INTO hre_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Jò Jôsep hnoq Bên-ja-min loh tiaq wì, haq thê mangai wèq hnem: “ 'Nong 'bài cô mùt ta hnem, rùp ngè aban broq jam pai padon, ma jah 'màng aih, 'ne hì cô wì haq caq pua ti au.” ");
INSERT INTO hre_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mangai wèq hnem broq tiaq troi bàu tanap, 'nong wì mùt ta hnem Jôsep. ");
INSERT INTO hre_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Wì oh daq hnoq dađeh ep mùt ta hnem Jôsep, wì crè, èh wì anoi ca dabau: “Aih taiq 'bài 'bac ma khoi đòiq hlài ta 'bao bèn yàng adroi, dài haq wì men 'ràng bèn mùt ta nòi cô, đòiq chaq nen glàm jêh bèn, rùp bèn broq dìch, èh atùng yŏc da bèn 'bài lùa.” ");
INSERT INTO hre_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","'Bài wì oh daq thia haten ca mangai wèq hnem da Jôsep, bòch haq jang enh gùng ca 'mang. ");
INSERT INTO hre_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Wì doi: “Joq 'nàng nhèn oh daq khoi trùh ta cô mòiq yàng đòiq rŏt 'mau mì. ");
INSERT INTO hre_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Jò nhèn hlài trùh hnem padài, pèh 'bài 'bao, èh hnoq 'bac da tang ngai nhèn ŏi jang 'ngah 'bao cla nhèn. Cô nhèn 'ràng hlài dìq 'bac aih. ");
INSERT INTO hre_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Èh nhèn hadai i wê tam 'bac đòiq rŏt hòm 'mau mì ùh 'nì cabô ma đòiq 'bac ta 'bao nhèn.” ");
INSERT INTO hre_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mangai wèq hnem tèu hlài: “Catèm beq, apaq crè yùq. Aih Boc Plình da pì, Boc Plình da baq pì, khoi tah 'bac 'mùt ta 'bao pì, 'bac da pì am, au khoi i.” Khoi èh, mangai aih 'ràng Si-mê-ôn trùh ti wì oh daq. ");
INSERT INTO hre_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Hi khoi haq 'nong wì mùt ta hnem Jôsep, 'noh diac 'nheo jènh wa ji 'noh ca 'bài lùa wì nhat caq. ");
INSERT INTO hre_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wì oh daq padon đòiq ngè am gòm trùh 'ne hì Jôsep hlài đòiq am ca haq. Wì haq hìa wì jah caq pua ta hnem cô. ");
INSERT INTO hre_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Jò Jôsep hlài, wì oh daq yŏc ngè am wì ma khoi wê, am ca Jôsep ta hnem, hi khoi wì bla-op dađeh jang ngìa Jôsep. ");
INSERT INTO hre_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Tajòi 'mòi Jôsep bòch wì jah tadêh tadon ùh? Haq bòch hòm: “Mangai craq baq pì ma anoi ca au aih, jah tadêh tadon ùh? Haq ŏi rìh ùh?” ");
INSERT INTO hre_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wì tèu: “Mangai hapŏng Chuaq, baq nhèn, xôq tadêh tadon ŏi rìh.” Khoi èh, wì bla-op enh ngìa ca haq. ");
INSERT INTO hre_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Jôsep blèch mat ngan hnoq Bên-ja-min, oh haq, con calô da miq haq, haq bòch: 'Mat ajoq oh ùch pì ma doi ca au aih? Doi hòm: Con ùch ôi, xìn Boc Plình am xôq ramŏt ca oh. ");
INSERT INTO hre_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Taiq haq hnoq dèh oh, dài haq, Jôsep ua-ac ta manoh, dahôiq cadiang loh enh gùng chaq nòi leq đòiq hmoi. Haq mùt ta adùq haq, hmoi. ");
INSERT INTO hre_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Èh haq 'mùq 'mat, cadiang loh, broq tìah ca ùh i troq cleq, haq doi: “Padon pua caq beq.” ");
INSERT INTO hre_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Wì padon ca Jôsep caq crài ca wì oh daq, caq crài ca mangai Aicàp ma ha'ngui acaq crài hòm, ma jah 'màng aih mangai Aicàp i manoh ramòt ca mangai Yothaiq, wì ùh caq pajùm. ");
INSERT INTO hre_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","'Màng aih, 'bài wì oh daq ha'ngui caq jang ngìa Jôsep, càn 'yoh tiaq dèh tìa enh ramua trùh ùch, broq wì hamàih ngan dabau. ");
INSERT INTO hre_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Jôsep thê 'ràng 'bài ngè caq jang ngìa haq am ca wì oh daq, mahaq phàn da Bên-ja-min ji bàc padam yàng da mangai 'noiq. Wì haq ôq caq jìang lem bùi ti Jôsep. ");
INSERT INTO hre_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Jôsep doi ca mangai wèq hnem: “Tàng 'bài mangai aih nui 'ràng hlài toq leq, bìac ùc ta 'bao wì haq toq aih, hi khoi đòiq hlài 'bac da rìm ngai ta nòi 'ngah 'bao wì haq. ");
INSERT INTO hre_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Èh đòiq doi broq xam 'bac da au jang 'ngah 'bao pajùm ca 'bac ma rŏt 'mau mì da mangai ùch.” Mangai wèq hnem broq tìah troi bàu Jôsep tanap ca haq. ");
INSERT INTO hre_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Hì da èh plình bu 'ngah, wì am 'bài mangai aih wa lùa wìh hlài. ");
INSERT INTO hre_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Jò loh lam khoi ca phôq 'nhòq hangai, Jôsep doi ca mangai wèq hnem: “Ìh yòng hnan tiaq 'bài mangai aih beq. Jò hnan hi tem, ìh doi ca wì haq: ‘Gleq pì ma yŏc manoh 'mèq đòiq ca'naih manoh lem da craq au? ");
INSERT INTO hre_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","I joq, doi cô doi da craq au loq ôq alac wa pàih panàih 'mòh? Pì khoi broq bìac 'mèq 'màng cô.’ ” ");
INSERT INTO hre_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mangai wèq hnem hnan tem, doi hlài bàu aih. ");
INSERT INTO hre_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Wì oh daq tèu hlài: “Gleq ìh ma anoi bàu 'màng aih, mangai hapŏng ìh ùh i jò leq i manoh broq bìac 'màng cô. ");
INSERT INTO hre_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nhèn enh gùng Ca-na-an khoi 'ràng 'bac ma khoi i ta 'ngah 'bao, nhèn khoi 'noh am hlài da haq, 'màng leq ma i hòm manoh atùng 'bac loq wang da hnem craq ìh 'mòh? ");
INSERT INTO hre_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Xìn ìh am ca hapŏng leq ma ìh chaq jah doi aih, ep cachìt, èh nhèn jah broq hapŏng ìh.” ");
INSERT INTO hre_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mangai wèq hnem tèu: “Broq troi bàu pì ma khoi doi beq, au chaq jah doi aih nòi mangai leq, èh mangai aih ep broq hapŏng au, phàn pì ùh i ca tôiq cleq.” ");
INSERT INTO hre_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tajòi 'mòi rìm ngai drah 'noh dèh 'bao ha'neq pèh 'ngah. ");
INSERT INTO hre_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mangai wèq hnem ti ngan baxèm enh 'bao daq ramua trùh 'bao oh ùch. Doi aih chaq hnoq ta 'bao Bên-ja-min. ");
INSERT INTO hre_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Rìm ngai wì hich dèh eo cla, tah 'bao 'mau mì ta crŏng lùa, hi khoi wìh hlài ta phôq. ");
INSERT INTO hre_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Jôsep ŏi ŏi ta hnem jò Juđa wa 'bài wì oh daq haq mùt. Wì bla-op dađeh ta taneh jang ngìa Jôsep. ");
INSERT INTO hre_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Jôsep bòch: “Pì broq cleq 'màng 'mat? Pì ma ùh 'nì mangai troi au rabiaq ca pàih panàih 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juđa tèu: “Nhèn anoi ca ìh 'màng leq? Palem dađeh 'màng leq? Boc Plình khoi hnoq ro bìac ngan dù nhèn cô, manàiq nhèn xìn broq hapŏng ìh, dìq dŏng ca nhèn wa xam mangai ma khoi i doi ma wì chaq hnoq.” ");
INSERT INTO hre_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mahaq Jôsep tèu hlài: “Au ùh i ca manoh broq 'màng aih. Mangai ma khoi i doi ma wì chaq hnoq ti tì haq, haq broq hapŏng au, phàn pì, hlài ta hnem baq pì, catèm beq.” ");
INSERT INTO hre_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Juđa thia haten ca Jôsep doi: “Ôi Chuaq au xìn am ca hapŏng ìh jah hatùang đeh mòiq bàu cô, xìn ìh paq loh nòih ca mangai hapŏng ìh, 'nhac ca ìh dàng ca Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ìh i bòch mangai hapŏng ìh: Pì ŏi i baq loq oh daq leq ùh?” ");
INSERT INTO hre_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nhèn tèu hlài: “Nhèn ŏi i mòiq toq baq craq wa mòiq toq oh ùch xa-ông ca haq jò baq nhèn khoi craq bàc hanam. Daq con ùch khoi cachìt, ŏi mòiq toq haq mòiq miq raq. Baq haq loq waq ca haq dìq jaq. ");
INSERT INTO hre_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Ìh khoi tanap ca nhèn, 'nong haq trùh ta au beq waq ca au jah hnoq haq jang ngìa au. ");
INSERT INTO hre_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nhèn tèu hlài ìh, con 'yoh cô ùh jah hangai dèh ca baq, tàng haq hangai ca baq, èh baq loq cachìt. ");
INSERT INTO hre_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Mahaq ìh tèu hòm, tàng oh ùch pì ùh loh ta cô, èh pì pi hnoq hadrò au hòm. ");
INSERT INTO hre_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","'Màng aih jò nhèn hlài ta hnem mangai hapŏng Chuaq, aih baq au, nhèn ta'mon hlài ca haq tàng bàu da ìh. ");
INSERT INTO hre_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Atìq ca aih, baq thê nhèn: Wìh hlài rŏt toq 'biaq dahwèq hòm beq. ");
INSERT INTO hre_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mahaq nhèn tèu hlài: ‘Ùh jah, tàng oh lam tiaq dìq, èh men jah loh, tàng ùh, nhèn ùh jah hnoq hadrò mangai aih.’ ");
INSERT INTO hre_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Mangai hapŏng Chuaq, aih baq au tèu: ‘Pì loq mai au xa-ông ca au baiq ngai con calô, ");
INSERT INTO hre_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","mòiq ngai khoi lam hangai ca au, joq 'nàng ngè rôm khoi hich haq, ma jah 'màng aih trùh manàiq au ùh hnoq haq hòm. ");
INSERT INTO hre_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Mahaq tàng pì hadai 'nong con 'yoh cô hangai ca au, èh i bìac ùh lem loh ca haq, 'màng aih pì broq ca mangai craq co gàu cô mango loh ta ralùng.’ ");
INSERT INTO hre_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Baq dìq jaq loq xa-ŏch ca oh ùch. Wa haq baiq mahaq tìah ca mòiq ca dabau. Tàng manàiq cô au wìh hlài ta mangai hapŏng Chuaq, aih baq au, ùh i ca oh ùch au hlài, ");
INSERT INTO hre_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","èh jò haq hnoq ùh i ca con ùch hlài, haq cachìt hloi. 'Màng aih nhèn 'bài hapŏng ìh cô khoi broq dèh ca baq craq co gàu nhèn, aih mangai hapŏng Chuaq, mango loh ta ralùng. ");
INSERT INTO hre_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ma jah 'màng aih hapŏng ìh khoi chìuq nhàn wèq con ùch aih, doi: ‘Tàng con ùh ahlài oh ca baq, èh con jah nhàn dŏng lôi ca baq hloi hloi.’ ");
INSERT INTO hre_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“ 'Màng aih manàiq cô, xìn am au, mangai hapŏng ìh ŏi broq dìch thai mangai oh, đòiq haq hlài ti 'bài daq haq. ");
INSERT INTO hre_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ma jah 'màng aih tàng mangai 'yoh ùh hlài tiaq wì, broq 'màng leq au ma hùa hlài ti baq au, ma manaq hnoq bìac ùh lem trùh ti baq au 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Manàiq cô, Jôsep pi nui pagàt dèh manoh jang ngìa 'bài mangai patìh ŏi dudan, 'màng aih haq cachech doi: “Pì loh dŏng enh gùng beq.” 'Màng aih pi i ca mòiq ngai leq ma 'noiq ŏi ta aih jò Jôsep pa'noh dèh ca oh da loq ca haq joq 'nàng. ");
INSERT INTO hre_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Haq hmoi dêh trùh 'mòi mangai Aicàp tàng wa hnem Pha-ra-ôn hadai tàng. ");
INSERT INTO hre_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Jôsep doi dèh ca oh daq haq: “Au Jôsep, baq au ŏi rìh ùh?” Mahaq enh ngìa Jôsep 'bài oh daq haq dìq jaq yùq crè, ùh i mangai leq hùa tèu. ");
INSERT INTO hre_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Haq doi hòm: “Pì daq thia ma haten ca au beq.” Wì thia haten. Haq doi: “Au Jôsep, oh pì daq khoi tech ca wì 'nong cwa Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Manàiq cô, apaq mango, hadai apaq trech dađeh ca bìac pì khoi tech au ca wì 'nong trùh gùng cô, ma jah 'màng aih Boc Plình khoi thê au trùh ta cô adroi ca oh daq đòiq wèq can rìh. ");
INSERT INTO hre_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Khoi baiq hanam ta gùng bèn pangot hrah, ŏi padam hanam òn hòm, ùh jah abèq cleq, ùh jah gat cleq. ");
INSERT INTO hre_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Mahaq Boc Plình thê au trùh ta cô adroi pì, đòiq dèch pì claih ca bìac pangot hrah càn yàng cô wa đòiq ca xinoi pì jah ŏi i ta crŏng taneh nhò bìac dèch claih càn caiq. ");
INSERT INTO hre_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Ùh xài taiq pì daq thê au trùh ta cô, mahaq Boc Plình ta'mroq. Haq 'nàng au trùh ta cô đòiq au broq tìah ca baq Pha-ra-ôn, wèq cwìang dìq ta hnem haq wa jàp ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Pì daq renh hlài ta hnem baq au beq, doi ca haq, Jôsep, con da baq, i doi 'màng cô: Boc Plình khoi đòiq au broq craq wèq dìq ca gùng Aicàp. Baq loh ŏi ti au beq, xìn apaq patrò. ");
INSERT INTO hre_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Baq, 'bài con, 'bài xau, calùh trìu, 'bo wa cùng hang da baq loh ŏi ta gùng Gôsen haten ca au. ");
INSERT INTO hre_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ŏi ta aih au jah ban baq, ma jah 'màng aih ŏi padam hanam pangot hrah hòm. Tàng ùh 'màng aih, yùq baq, mangai ta hnem baq wa xam dìq dŏng ngè rìh da baq loq cachìt ca hrah. ");
INSERT INTO hre_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Cô, 'bài daq wa Bên-ja-min oh au khoi hnoq xam mat, hacùng au khoi capoch tùang xam bàu bèn ca pì. ");
INSERT INTO hre_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","'Màng aih, ta'mon hlài bìac 'ngah 'ngai da au ŏi Aicàp wa rìm bìac oh daq khoi hnoq ca baq tamàng beq, wa 'noh baq loh ta cô ma renh.” ");
INSERT INTO hre_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Khoi ca capoch bàu aih gêh, Jôsep oc Bên-ja-min oh haq, haq hmoi. Bên-ja-min hadai oc haq, hmoi. ");
INSERT INTO hre_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Jôsep hadai oc dèh 'bài daq wì haq, hmoi ca dabau, khoi ca aih wì oh daq capoch tùang ca Jôsep. ");
INSERT INTO hre_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tajòi 'mòi, bàu cô hìa trùh hnem Pha-ra-ôn, oh daq Jôsep khoi trùh. Pha-ra-ôn wa 'bài cwan tàng bàu aih, wì lem bùi. ");
INSERT INTO hre_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pha-ra-ôn doi ca Jôsep: “Doi ca 'bài oh daq ìh beq: ‘Atŏc 'bài dahwèq enh crŏng lùa, hlài ta Ca-na-an, ");
INSERT INTO hre_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","hi khoi 'noh baq pì wa mangai hnem da ìh loh ŏi ti au. Au axong ca pì nòi taneh ma yi jìang ta gùng Aicàp. Pì jah hùang can jìang da taneh.’ ");
INSERT INTO hre_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ìh hadai tanap ca wì haq 'màng cô: ‘ 'Ràng 'bài xê enh gùng Aicàp ahlài ca con 'yoh wa mai pì, hadai 'noh baq pì loh ta cô. ");
INSERT INTO hre_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Apaq adenh ca cùng hang cla, ma jah 'màng aih cùng hang yi lem lình da gùng Aicàp jah hlài dìq ta pì.’ ” ");
INSERT INTO hre_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","'Bài con calô Is-ra-ên broq troi bàu aih. Jôsep tiaq bàu Pha-ra-ôn, am 'bài xê ca oh daq haq wa dahwèq đòiq caq ti trong. ");
INSERT INTO hre_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Haq hadai am eo yôh đòiq atùa rìm ngai, mahaq phàn da Bên-ja-min, haq am 300 capiac 'bac wa padam blah eo yôh. ");
INSERT INTO hre_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Jôsep hadai thê wì ahlài ca baq haq 'bài dahwèq cô: 10 toq lùa calô, 'ràng 'bài cùng hang lem dìq jaq da gùng Aicàp, 10 toq lùa cadrì 'ràng 'mau mì, 'benh mì wa dahwèq caq đòiq baq haq caq jò lam ti trong. ");
INSERT INTO hre_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","'Màng aih, Jôsep thê dèh oh daq yòng lam, haq tanap wì: “Pì oh daq apaq rahen ca dabau ti trong.” ");
INSERT INTO hre_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","'Bài wì oh daq lam enh Aicàp trùh ta gùng Ca-na-an, nòi Jacôp baq wì ŏi. ");
INSERT INTO hre_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wì ta'mon hlài bàu cô dèh ca baq: “Jôsep ŏi rìh, cla haq 'nang wèq cwìang jàp gùng Aicàp.” Jacôp cadrat taiq haq ùh lùi bàu wì anoi aih. ");
INSERT INTO hre_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Wì oh daq ta'mon hlài ca haq tamàng dìq dŏng rìm bàu da Jôsep khoi anoi, jò Jacôp bu hnoq 'bài xê da Jôsep thê wê ahlài đòiq 'nong baq, haq loh ca prau hlài. ");
INSERT INTO hre_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Is-ra-ên doi: “Hêq, au khoi loq, Jôsep con calô au xôq ŏi rìh. Au lam hmàih ca haq adroi ca au cachìt.” ");
INSERT INTO hre_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Is-ra-ên loh lam, wê dŏng dèh dahwèq cùng hang trùh Bê-e-sê-ba, ta aih haq padon ngè tadreo ca Boc Plình da Isac, baq haq. ");
INSERT INTO hre_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Boc Plình doi ca Is-ra-ên ta jò haq apô hnoq: “Ô, Jacôp, Jacôp.” Jacôp tèu: “I au cô.” ");
INSERT INTO hre_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Boc Plình doi: “Au Boc Plình, Boc Plình da baq ìh. Loh ta Aicàp beq, apaq crè cleq, ma jah 'màng aih, ta aih Au broq ca ìh wìa mòiq Diac càn. ");
INSERT INTO hre_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Au loh ta aih ti ìh, hi khoi hadai ajèn ìh hlài jò ìh cachìt, èh Jôsep ma apot mat ìh.” ");
INSERT INTO hre_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Enh Bê-e-sê-ba, Jacôp wa dìq con calô haq 'nong dèh baq wa cadrì con dađeh ta 'bài xê Pha-ra-ôn khoi am đòiq 'ràng wì. ");
INSERT INTO hre_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wì haq hadai 'ràng dèh cùng hang wa dìq ngè aban khoi i ta Ca-na-an lam trùh gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","'Màng aih, Jacôp wa dìq ca hnem haq, 'bài con calô haq, 'bài xau calô, 'bài con cadrì, 'bài xau cadrì, dìq loh ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Cô con calô da mangai Is-ra-ên jò trùh gùng Aicàp: Rubên, con ramua da Jacôp. ");
INSERT INTO hre_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","'Bài con calô Rubên: Hênoc, Phalu, Hêtrôn wa Catmi. ");
INSERT INTO hre_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","'Bài con calô da Si-mê-ôn: Jê-mu-ên, Jamin, Ôhat, Jakin, Xôha wa Saulò. Miq Saulò, mangai Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","'Bài con calô da Lêwi: Getsôn, Kêhat wa Mê-ra-ri. ");
INSERT INTO hre_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","'Bài con calô da Juđa: Êrò, Ônan, Sêlah, Perex, Xêra. Mahaq Êrò wa Ônan khoi cachìt ta Ca-na-an. Con da Peret aih Hêtrôn wa Hamun. ");
INSERT INTO hre_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","'Bài con calô da I-sa-ca: Tôla, Puwa, Jop wa Simrôn. ");
INSERT INTO hre_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","'Bài con calô da Xe-bu-lun: Sêrêt, Êlôn wa Ja-lê-ên. ");
INSERT INTO hre_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Cô 'bài con calô wa mòiq toq con cadrì hiniq haq Đina ma Lêa khoi xa-ông ca Jacôp ta Pađan Aram, xam 'bài xau, aih tagop hlài jah 33 ngai. ");
INSERT INTO hre_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","'Bài con calô da Gat: Xi-phi-ôn, Haghi, Suni, Etbôn, Êri, A-rô-đi, A-rê-li. ");
INSERT INTO hre_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","'Bài con calô da Ase: Imna, Ichwa, Ichwi, Bê-ri-a wa Sêrah, aih oh cadrì 'bài aih. Con da Bê-ri-a aih Hêbe, Man-chi-ên. ");
INSERT INTO hre_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Cô 'bài con calô da Xinpa xa-ông ca Jacôp, xam dìq ca con xau wì haq, aih 16 ngai. Xinpa aih hapŏng 'yoh da Laban khoi am tiaq wèq Lêa con cadrì dađeh. ");
INSERT INTO hre_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","'Bài con calô da Rachên mai Jacôp: Jôsep wa Bên-ja-min. ");
INSERT INTO hre_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Jôsep khoi i con ta gùng Aicàp, aih Ma-na-se wa Ep-ra-im, A-sê-na mai haq khoi xa-ông ca haq, aih con cadrì da Poti Phêra pajàu càn phôq Ôn. ");
INSERT INTO hre_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","'Bài con calô da Bên-ja-min: Bêla, Bêca, Achbên, Gêra, Na-a-man, Êhi, Rôsò, Môpbim, Hôpbim wa Arêt. ");
INSERT INTO hre_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Aih 'bài con calô da Rachên wa Jacôp. Dìq ca xinoi da Jacôp nhò Rachên, aih 14 ngai. ");
INSERT INTO hre_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Con calô da Đan, aih Husim. ");
INSERT INTO hre_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","'Bài con calô da Nep-ta-li: Jat-sê-ên, Guni, Jêxe wa Silem. ");
INSERT INTO hre_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dìq con calô da Bila xa-ông ca Jacôp, wa dìq ca con xau wì haq, aih tapèh ngai. Bila hapŏng 'yoh da Laban khoi am tiaq wèq Rachên, con cadrì da Laban. ");
INSERT INTO hre_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","'Bài wì lam trùh Aicàp ti Jacôp, aih xinoi Jacôp, ùh rèn 'bài mai con, èh dìq ca 'bài wì 66 ngai. ");
INSERT INTO hre_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Jôsep khoi xa-ông baiq toq con calô ta Aicàp, 'màng aih dìq dŏng 'bài mangai ta cadraq Jacôp, aih 70 ngai. ");
INSERT INTO hre_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacôp thê Juđa lam adroi đòiq doi ca Jôsep 'ràng haq trùh cròng Gôsen, 'màng aih wì haq trùh Gôsen. ");
INSERT INTO hre_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Jôsep padon xê trùh gùng Gôsen đìh Is-ra-ên, baq haq. Jò glàm dabau, haq oc dèh baq hmoi dùnh. ");
INSERT INTO hre_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Is-ra-ên doi ca Jôsep: “Manàiq cô au padon cachìt taiq au khoi jah hnoq hadrò con wa loq con xôq ŏi rìh.” ");
INSERT INTO hre_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hi khoi Jôsep doi ca oh daq wa dìq ca cadraq baq haq: “Cô èh au tŏc doi ca Pha-ra-ôn: Oh daq wa dìq ca cadraq baq au enh Ca-na-an khoi tŏc ta cô ti au. ");
INSERT INTO hre_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Wì haq broq ngè ban trìu wa 'bo. Wì khoi 'ràng tiaq dìq 'bài cùng hang wì. ");
INSERT INTO hre_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","'Màng aih jò leq Pha-ra-ôn creo bòch oh daq: Pì broq ngè cleq? ");
INSERT INTO hre_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Pì tèu haq, doi: ‘Enh 'yoh trùh manàiq, nhèn xôq rìh xam ngè aban tìah ca boc yaq nhèn.’ 'Màng aih bùa am pì ŏi ta gùng Gôsen, ma jah 'màng aih mangai Aicàp ramòt dìq ca mangai ban trìu.” ");
INSERT INTO hre_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jôsep lam anoi rìm bìac aih ca bùa Pha-ra-ôn loq, haq doi: “Baq wa oh daq au ŏi enh gùng Ca-na-an trùh, i 'ràng trìu, 'bo wa cùng hang dađeh. Manàiq cô wì haq 'nang ŏi ta gùng Gôsen.” ");
INSERT INTO hre_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Jôsep 'ràng padam ngai ta oh daq haq yòng jang enh ngìa Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pha-ra-ôn bòch “Pì broq ngè cleq?” Wì tèu: “Mangai hapŏng 'yoh ìh cô rìh ca ngè ban trìu, tìah ca boc yaq nhèn calah nèh dìq.” ");
INSERT INTO hre_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Hi khoi wì doi hòm: “Nhèn khoi trùh ta cô, ma jah 'màng aih, ta gùng Ca-na-an i pangot hrah càn, pi i ca đùng nhat ca 'bài trìu acaq, 'màng aih xìn ìh am ca hapŏng 'yoh ìh ŏi ta gùng Gôsen.” ");
INSERT INTO hre_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pha-ra-ôn doi ca Jôsep: “Baq ìh wa oh daq ìh khoi trùh ta ìh, ");
INSERT INTO hre_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","'màng aih gùng Aicàp khoi đòiq ca ìh. Am ca baq ìh wa oh daq ìh nòi leq ma lem ta gùng aih. Au hnoq ta gùng Gôsen dìq jaq troq ca wì haq. Ta 'bài mangai 'mat tàng ìh loq ca ma leq ma thài ban 'bo, đòiq wì ban 'bài 'bo da au beq.” ");
INSERT INTO hre_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hi khoi Jôsep 'ràng baq haq Jacôp trùh enh ngìa ca Pha-ra-ôn. Jacôp waiq xôq ca Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pha-ra-ôn bòch Jacôp: “Ìh khoi jah đeh toq leq jàt hanam?” ");
INSERT INTO hre_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacôp tèu: “Au jah 130 hanam. Tàng achùa ca 'nhòng da boc yaq au 'nhòng hanam da au joq 'nàng đêq wa xalep.” ");
INSERT INTO hre_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacôp waiq xôq ca Pha-ra-ôn tam mòiq yàng hòm, hi khoi haq loh khoi ca aih. ");
INSERT INTO hre_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","'Màng aih Jôsep tiaq bàu thê Pha-ra-ôn patô, hi am dèh ca baq wa oh daq ŏi nòi dìq jaq lem ta gùng Aicàp go Ramse, gùng Gôsen, đòiq broq nòi patìh caq. ");
INSERT INTO hre_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Jôsep am dahwèq caq dèh ca baq, ca oh daq wa ca dìq ca mangai ta hnem baq haq xam con 'yoh. ");
INSERT INTO hre_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bìac pangot hrah dìq jaq càn, jàp gùng pi i ca dahwèq caq hòm. Xam gùng Aicàp wa gùng Ca-na-an tagah lep taiq pangot hrah aih. ");
INSERT INTO hre_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Jôsep tech 'mau mì, gop dìq 'bac jèn nhàn enh gùng Aicàp wa gùng Ca-na-an hi khoi 'ràng 'bac aih ca Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Jò 'bac jèn ta gùng Aicàp wa gùng Ca-na-an khoi dìq, èh dìq ca jàn Aicàp trùh ti Jôsep, doi: “Xìn am ca nhèn dahwèq caq taiq nhèn khoi dìq ca 'bac. Ìh enh nhèn cachìt hrah enh ngìa ca ìh ta cô 'mòh?” ");
INSERT INTO hre_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Jôsep tèu: “Tàng khoi dìq ca 'bac, phai am ca au ngè aban da pì 'mat, èh au am ca pì dahwèq caq.” ");
INSERT INTO hre_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","'Màng aih, dìq ca wì haq 'ràng ngè aban am ca Jôsep. Jôsep halìh dahwèq caq yŏc axêh, 'bài trìu, 'bài 'bo wa lùa. Hanam aih Jôsep yŏc dìq ca ngè aban da wì haq, èh halìh am dahwèq caq. ");
INSERT INTO hre_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Khoi ca hanam aih, hanam atìq 'bài jàn lam trùh xìn haq hòm: “Nhèn ùh cadoc cleq ca Chuaq, 'bac jèn khoi dìq, 'bài ngè aban da nhèn khoi jao ca ìh. Manàiq nhèn pi i ca cleq hòm enh gùng ca taneh wa chac hamac cla cô. ");
INSERT INTO hre_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Gleq ma nhèn pangot hrah trùh cachìt, wa taneh ŏi dech 'mòh? Rŏt đùng taneh wa cla nhèn halìh dahwèq caq beq. Hi khoi cla nhèn broq dìch broq hapŏng ca Pha-ra-ôn. Xìn am ca nhèn adrech đòiq nhèn ùh hìaq cachìt wa taneh ùh hìaq đòiq clôi.” ");
INSERT INTO hre_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Jôsep rŏt dŏng taneh ta gùng Aicàp ca Pha-ra-ôn taiq bìac pangot hrah ma jah dìq ca mangai gùng aih tech dèh taneh. 'Màng aih taneh dìq jah dŏng Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Hi khoi haq thê dìq ca jàn enh acang cô trùh acang tau ta gùng Aicàp mùt ŏi dŏng dìq ta 'bài phôq càn. ");
INSERT INTO hre_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mahaq taneh da pajàu èh Jôsep ùh rŏt, ma jah 'màng aih wì haq i nhàn mòiq phàn dahwèq caq enh Pha-ra-ôn khoi am ca wì haq. 'Màng aih wì haq tôm tàu caq da dahwèq ma Pha-ra-ôn khoi am. Wì haq ùh hìaq ep tech dèh đùng taneh. ");
INSERT INTO hre_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Jôsep doi ca 'bài jàn: “Au khoi rŏt pì, đùng taneh pì ca Pha-ra-ôn. Cô au am ca pì adrech đòiq pì rai ta dìq taneh aih. ");
INSERT INTO hre_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Trùh jò gat phai 'ràng am ca Pha-ra-ôn mòiq phàn padam, èh i pôn phàn padam am ca pì đòiq ca hnem pì caq wa broq hlài adrech.” ");
INSERT INTO hre_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","'Bài jàn doi: “Ìh khoi dèch chac cla nhèn, waiq xìn nhèn jah xôq enh ngìa ca ìh, èh jah broq dìch broq hapŏng ca Pha-ra-ôn.” ");
INSERT INTO hre_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","'Màng aih Jôsep broq loh bìac cô ca Diac Aicàp trùh manàiq xôq ŏi am ca Pha-ra-ôn mòiq phàn padam dahwèq broq loh, toq taneh da 'bài pajàu Pha-ra-ôn ùh yŏc. ");
INSERT INTO hre_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","'Màng aih jàn Is-ra-ên ŏi ta Gôsen, gùng Aicàp nòi wì haq jah taneh. Wì haq xa-ông loh wa tŏc tam bàc phàn jò ŏi ta gùng aih. ");
INSERT INTO hre_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacôp ŏi ta gùng Aicàp jah 17 hanam, halình jah 147 hanam. ");
INSERT INTO hre_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Jò tenh cachìt, Is-ra-ên creo ca Jôsep con calô haq, doi: “Con jùp baq bìac cô, yŏc tì đòiq acataih baq, yŏc manoh loq xa-ŏch ca baq, joq 'nàng pachac ùh catùh baq ta Aicàp, ");
INSERT INTO hre_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","mahaq jò au ca'nùng tiaq boc yaq, phai 'ràng chac au loh khoi gùng Aicàp, catùh pajùm tiaq hanang boc yaq.” Jôsep tèu: “Au jah broq tiaq bàu ìh tanap.” ");
INSERT INTO hre_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jacôp doi: “Con pachac beq.” Jôsep pachac, èh Is-ra-ên hacùng cràng waiq agàu jùang. ");
INSERT INTO hre_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Atìq ca aih, i mòiq ngai doi ca Jôsep: “Baq ìh ùh hrŏc.” Tàng bàu aih, Jôsep 'ràng Ma-na-se wa Ep-ra-im, baiq ngai con calô haq, lam tiaq haq. ");
INSERT INTO hre_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Wì am Jacôp loq bìac aih doi: “Cô! Jôsep con calô ìh, trùh hmàih ca ìh.” Loq ca bìac aih, Is-ra-ên ran yòng ha'ngui ta jùang. ");
INSERT INTO hre_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacôp doi ca Jôsep: “Boc Plình I Cwìang Itai Dìq Dŏng khoi loh ca au ta Luxò ŏi ta gùng Ca-na-an, hi am xôq ramŏt ca au.” ");
INSERT INTO hre_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Haq doi: “Cô! Au am ca ìh jah xa-ông loh tam bàc, broq wìa mòiq tamoi cràm. Au jah am gùng cô ca xinoi ìh broq taneh broq xôxech hloi hloi.” ");
INSERT INTO hre_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Manàiq baiq toq con calô ìh, Ep-ra-im wa Ma-na-se ma khoi xa-ông ta Aicàp adroi ca au trùh, wa haq wìa con au tìah ca Rubên wa Si-mê-ôn aih. ");
INSERT INTO hre_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mahaq 'bài 'yoh ìh ma xa-ông atìq, èh wì jah con da ìh wa jah hùang taneh wa cùng hang tiaq hiniq Ep-ra-im wa Ma-na-se. ");
INSERT INTO hre_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Jò au ŏi Pađan, hlài ta gùng Ca-na-an, èh Rachên cachìt roc trong hatenh ca Ep-ra-ta. Au catùh haq ti kenh trong hlài Ep-ra-ta, aih 'Bêt-lê-hem. ");
INSERT INTO hre_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Jò Is-ra-ên hnoq 'bài con calô Jôsep, haq bòch: “ 'Bài cô cabô?” ");
INSERT INTO hre_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Jôsep tèu: “Aih 'bài con calô Boc Plình khoi am ca au ta nòi cô.” Is-ra-ên doi: “ 'Ràng wa ta cô đòiq au waiq xôq ca wa haq.” ");
INSERT INTO hre_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Mat Is-ra-ên hnoq pi dai ro taiq haq khoi craq, ma jah thê wa lam haten, oc wa hìp wa haq. ");
INSERT INTO hre_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Is-ra-ên doi ca Jôsep: “Adroi cô nèh au xoh pi jah hnoq ìh, mahaq manàiq Boc Plình broq ca au jah hnoq con ìh dìq!” ");
INSERT INTO hre_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Jôsep dèch dèh baiq toq con loh khoi enh achong baq, hi khoi haq cùp dèh hadrò trùh taneh. ");
INSERT INTO hre_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Jôsep 'ràng baiq con haten dèh ca baq. Xam tì pah 'ma haq đòiq Ep-ra-im pah 'ngeo da baq, mahaq 'ràng Ma-na-se đòiq pah 'ma da baq haq. ");
INSERT INTO hre_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Is-ra-ên đòiq dèh tì pah 'ma enh 'nhèq ca gàu Ep-ra-im con ma oh, tì pah 'ngeo đòiq enh 'nhèq ca gàu Ma-na-se, 'nhac haq loq Ma-na-se haq con ramua. ");
INSERT INTO hre_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Is-ra-ên waiq xôq ca Jôsep doi: “Waiq xìn Boc Plình da Ap-ra-ham wa Isac, boc yaq au, khoi ajèn au wa wèq ban au enh jò baxèm loh enh cliac trùh manàiq. ");
INSERT INTO hre_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","'Bình plình khoi dŏih dèch au loh enh dìq bìac ngang dù, am xôq ca baiq ngai con 'yoh cô, đòiq 'mùt hiniq au, ha'mŏt hiniq Ap-ra-ham wa Isac boc yaq au, èh am ca wì tam bàc pi nui rèn ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mahaq Jôsep hnoq dèh baq đòiq tì 'ma agàu Ep-ra-im, èh i manoh ùh lem bùi. Haq yŏc tì khoi đòiq agàu Ep-ra-im, đôiq cwa gàu Ma-na-se. ");
INSERT INTO hre_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Hi khoi haq doi: “Ùh xài 'màng 'mat baq. Cô con ramua. Đòiq tì pah 'ma da ìh enh 'nhèq ca gàu haq, aih troq.” ");
INSERT INTO hre_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mahaq Jacôp ùh chìuq, haq doi: “Con ôi, au loq, baq loq. Haq jah wìa mòiq jàn, haq hadai jah càn, mahaq oh haq yi càn ca haq, èh xinoi haq jah bàc jàn pi nui rèn.” ");
INSERT INTO hre_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Hì aih, Jacôp waiq xôq ca baiq ngai con calô cô, haq doi: “Nhò chôp jàn Is-ra-ên jah am bàu xôq ramŏt ca dabau, doi: ‘Waiq xìn Boc Plình broq ca ìh tìah troi Ep-ra-im wa Ma-na-se.’ ” 'Màng aih Jacôp đòiq Ep-ra-im adroi ca Ma-na-se. ");
INSERT INTO hre_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Is-ra-ên doi hòm ca Jôsep: “Au ten cachìt, mahaq Boc Plình jah ŏi ti pì èh ahlài pì ta gùng boc yaq pì. ");
INSERT INTO hre_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Au am ca con mòiq phàn taneh bàc yi hnao ca oh daq 'noiq, aih taneh xam chang gùm wa panenh au khoi ta'miaq yŏc enh jàn A-mô-rit.” ");
INSERT INTO hre_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacôp creo dèh ca 'bài con calô haq doi: “Pì ŏi dudan ca au beq đòiq au jah doi bìac phai trùh ca pì hì ma atìq: ");
INSERT INTO hre_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ôi, pì con calô Jacôp, phai tagop hlài đòiq tamàng bàu Is-ra-ên, baq pì. ");
INSERT INTO hre_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ôi Rubên gè con ramua da au, padren hiwa da au, wa baxèm can tadêh tadon au, pagah jah i can loq iu yi ha'nhèq wa i cwìang itai yi ha'nhèq dŏng dìq. ");
INSERT INTO hre_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mahaq gè tìah ca diac tro halùih, ùh jah wèq cajap, èh ùh yi hnao ca cabô, taiq gè khoi tŏc ta jùang au, broq amùa ta aih. ");
INSERT INTO hre_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Si-mê-ôn wa Lêwi, mòiq miq, chang da wa haq aih ranac broq bìac ramòt. ");
INSERT INTO hre_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Waiq ca mahua yiang au apaq i mòiq manoh 'mèq ti wa haq. Apaq đòiq can loq iu da au pajùm ti tagop wa haq, ma jah 'màng aih wì khoi jêh mangai jò wì haq nòih, wa cat hwen 'bo calô tiaq manoh dađeh enh. ");
INSERT INTO hre_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Đang ca waiq hanip can nòih da wa haq, ma jah 'màng aih can nòih da wa haq hlòm ca xòc ngan. Au jah lah axong wì haq ta hnem Jacôp, palac wì haq ta jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Ôi Juđa, gè jah dèh 'bài oh daq manè apôi, tì gè jah 'met ranŏng lình mangai tagit, dìq con calô au jah cùp gàu enh ngìa gè. ");
INSERT INTO hre_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juđa, gè baco hlari bu chuai. Gè rùp jah ngè caq khoi wê ahlài. Haq ca'nùng tìah ca baco hlari, èh tìah ca baco hlari, cabô hùa padrìu haq? ");
INSERT INTO hre_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Long wèq cwìang ùh jah loh khoi enh Juđa wa long dùi da mangai wèq ùh loh khoi enh 'ne baiq jènh haq, trùh jò Silô mahno loh wa dìq ca jàn phai iu tiaq Haq. ");
INSERT INTO hre_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Haq càt lùa con jang hamenh long nho, wa càt lùa con jang hamenh long nho yi lem dìq; rùh eo yôh xam alac nho, wa yŏc mahem nho rùh dèh eo yôh. ");
INSERT INTO hre_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mat haq gam yi hnao ca alac nho, hanenh haq taboc yi hnao ca sùa. ");
INSERT INTO hre_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Xe-bu-lun jah ŏi nòi kenh diac raxìq, nòi aih jah wìa nòi chua bong. Acang taneh da haq ten trùh Siđôn. ");
INSERT INTO hre_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“I-sa-ca con lùa tadêh tadon cùi padài ta'ne cadrong. ");
INSERT INTO hre_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Jò haq hnoq dèh nòi padài aih dìq jaq lem jìang, taneh dìq jaq lem; Haq den dèh plêh genh trap, èh chìuq broq hapŏng dìch. ");
INSERT INTO hre_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Đan jah hadrah dèh jàn cla tiaq trong ta-atoq, tìah ca hadròng hadrech 'noiq da Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Đan tìah ca bìh ŏi ti trong, tìah ca bìh plŏng ŏi ta trong, cap lùnh jènh axêh, broq ca mangai còi axêh tacro. ");
INSERT INTO hre_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ôi Chuaq, au gòm ngèh bìac lêh ca'naih da Ìh. ");
INSERT INTO hre_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gat èh 'bìq mòiq lù lình trùh jêh, mahaq cla haq raq ma hnan đac 'bài lình aih. ");
INSERT INTO hre_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Enh Ase i bàc dahwèq caq, haq jah broq ngè caq jìang am ca 'bài bùa. ");
INSERT INTO hre_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nep-ta-li tìah ca jŏi can jah ca'naih enh cadrong, capoch bàc bàu rangot. ");
INSERT INTO hre_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Jôsep, haq long nho loh bàc plì, long haq hon haten ca tamŏc, hamenh haq heo tŏc ta panàt. ");
INSERT INTO hre_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","'Bài mangai penh panenh tabroq ca haq nhang nhuiq dìq jaq; wì penh panenh xam manoh dìq jaq git ca haq. ");
INSERT INTO hre_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mahaq nhò tì da Chuaq ma I Cwìang Itai da Jacôp, Mangai ban trìu, aih Hmu Xèm da Is-ra-ên, 'màng aih panenh haq xôq ŏi jah cajap baiq toq tì haq tam tadêh. ");
INSERT INTO hre_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Nhò Boc Plình da baq gè jah jùp đò gè, nhò Chuaq I Cwìang Itai Dìq Dŏng am xôq ramŏt ca gè, aih xôq lem enh Boc Plình ha'nhèq, wa xôq ramŏt enh ralùng jrùq dèch atŏc, xôq ramŏt da tôh ma ban wa pù con nga da mai con. ");
INSERT INTO hre_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Xôq ramŏt da au khoi yi càn ca xôq ramŏt trùh 'bài wang wa 'bài rôm calah. Waiq 'bài xôq aih ŏi nòi gàu da Jôsep, wa cadoh bùa haq ma khoi wèq ban dèh oh daq. ");
INSERT INTO hre_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Bên-ja-min, haq coq yiang loq tacap, daxroq lam chaq jam, daxèq hlài axong jam khoi jah aih.” ");
INSERT INTO hre_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","'Bài mangai aih broq gàu da 12 hadròng hadrech da Is-ra-ên. Aih bàu da baq wì haq khoi waiq xôq ramŏt ca wì haq. Haq waiq am dèh ca 12 ngai con calô, mòiq ngai mòiq bàu waiq crài troq dèh ca tang ngai. ");
INSERT INTO hre_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Jacôp doi dèh ca 'bài con calô: “Au jah hlài nòi boc yaq au. Pì phai catùh au pajùm ti boc yaq, nòi còp hmu ta đùng Eprôn, mangai Hêtit. ");
INSERT INTO hre_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Aih còp hmu ŏi ta đùng Mac-bê-la, ta jang ca Mamrê, ŏi ta gùng Ca-na-an ma Ap-ra-ham khoi rŏt broq cadràng hanang xam đùng da Eprôn. ");
INSERT INTO hre_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nòi aih wì khoi catùh Ap-ra-ham wa mai haq, aih Sara, Isac wa mai haq, aih Rê-bê-ca, wa nòi aih au hadai khoi catùh Lêa. ");
INSERT INTO hre_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Đùng wa còp hmu ŏi ta aih khoi rŏt enh jàn xinoi Hêt.” ");
INSERT INTO hre_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jò tanap 'bài bàu aih dèh ca con bu gêh, èh Jacôp dèch dèh jènh ta jùang, pat hihèm, jah hlài dèh ti boc yaq. ");
INSERT INTO hre_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Jôsep cùp gàu trùh dèh ahadrò baq, hìp dèh baq rai hmoi. ");
INSERT INTO hre_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Hi khoi Jôsep thê dèh 'bài 'bac sì ma broq bìac ca haq, yŏc jreo phiang ca baq haq. Wì 'bac sì yŏc jreo hi phiang ca hanang Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Pôn jàt hì phiang jreo khoi cwa, aih khoi troq dèh ca hì ma pajaq. Jàn Aicàp hmoi ca haq 70 hì. ");
INSERT INTO hre_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Hì jò khoi cwa, Jôsep doi ca 'bài cwan ma ŏi ta hnem Pha-ra-ôn: “Tàng au jah xôq enh ngìa ca 'bài pì, xìn pì anoi hlài bàu cô ca Pha-ra-ôn tàng, doi: ");
INSERT INTO hre_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Baq au i thê au pachac: Cô, jò baq cachìt, con phai catùh baq nòi cadràng hanang baq khoi padon ta gùng Ca-na-an. 'Màng aih manàiq cô xìn đòiq au tŏc ta aih catùh dèh baq, hi khoi au wìh hlài.’ ” ");
INSERT INTO hre_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pha-ra-ôn doi: “Tŏc ta aih catùh baq ìh beq, tiaq troi bàu ìh ma pachac aih.” ");
INSERT INTO hre_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","'Màng aih Jôsep atŏc dèh hanang baq ta Ca-na-an đòiq catùh. Dìq ca 'bài cwan Pha-ra-ôn, 'bài mangai gù craq ta diac aih, 'bài craq plài ta gùng Aicàp, ");
INSERT INTO hre_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","hadai dìq ca 'bài mangai ta hnem Jacôp, 'bài oh daq wa dìq ca hnem baq haq, tŏc dìq ti haq tiaq hanang, mahaq wì toq đòiq 'bài wì 'yoh wa calùh trìu, calùh 'bo wì haq ŏi ta Gôsen. ");
INSERT INTO hre_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Hi khoi hadai i xê axêh wa mangai còi axêh lam tiaq. Wì lam tiaq hanang cô dìq jaq bàc ngai. ");
INSERT INTO hre_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Jò trùh xàn len 'mau da Atat, ŏi pah tau cròng diac Jôđan, èh wì haq broq lè hmoi, ta-oih dìq jaq càn caiq ta aih. Jôsep broq lè hmoi ta-oih ca baq haq ta aih tapèh hì. ");
INSERT INTO hre_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Jàn Ca-na-an ta gùng aih hnoq wì hmoi ta-oih ta xàn len 'mau Atat, èh wì doi: “Aih bìac hmoi ta-oih ca hanang dìq ca jaq càn caiq da mangai Aicàp, taiq nen aih wì creo ca xàn cô hiniq haq A-bên-mich-ra-im ŏi pah tau cròng diac Jôđan.” ");
INSERT INTO hre_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","'Màng aih 'bài con calô da Jacôp broq tiaq dèh bàu baq wì haq ma khoi tanap. ");
INSERT INTO hre_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","'Màng aih, con calô haq ahlài dèh hanang baq trùh gùng Ca-na-an, catùh ta còp hmu ta đùng Mac-bê-la ta jang Mamrê, Ap-ra-ham ma khoi rŏt hloi xam taneh đùng Eprôn da mangai Hêtit, đòiq broq cadràng hanang. ");
INSERT INTO hre_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Catùh dèh baq gêh, Jôsep, 'bài oh daq haq, xam mangai ma lam lòm hanang hlài dìq gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","'Bài oh daq Jôsep hnoq dèh baq khoi cachìt, èh wì haq doi ca dabau: “Khoi cô èh Jôsep git ca bèn, ca'naih dòih bèn ma khoi broq ngang dù ca haq.” ");
INSERT INTO hre_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","'Bài daq haq thê mangai lam trùh ta Jôsep doi: “Adroi ca cachìt i baq tanap: ");
INSERT INTO hre_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Phai doi hlài ca Jôsep 'màng cô: Xìn gè baxŏng tôiq ca 'bài daq gè, taiq wì khoi broq lôi ca gè. Manàiq cô au xìn ìh phai baxŏng tôiq ca 'bài hapŏng 'yoh da Boc Plình da baq.” ");
INSERT INTO hre_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Cla 'bài daq haq trùh cùp dađeh jang jènh haq, doi: “Nhèn daq cô hapŏng da oh.” ");
INSERT INTO hre_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Jôsep tèu: “Pì apaq crè cleq? Au ma jah thai Boc Plình 'mòh? ");
INSERT INTO hre_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Pì daq tình ca jêh au, mahaq Boc Plình khoi halìh bìac 'mèq loh bìac lem 'ràng au trùh ta cô đòiq jah dèch bàc ngai, tìah ca bèn khoi jah hnoq cô. ");
INSERT INTO hre_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","'Màng aih apaq yùq, au am dahwèq caq ca pì daq wa cadrì con pì. Jôsep alòng dèh 'bài daq haq yŏc bàu hatùang ca wì.” ");
INSERT INTO hre_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Jôsep wa dìq ca hnem baq haq rìh ŏi ta gùng Aicàp. Jôsep halình jah 110 hanam. ");
INSERT INTO hre_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Haq tem hnoq con xau Ep-ra-im trùh 'nhòng piq, khoi hadai jah ca'mình 'bài con da Maki, aih 'bài con calô da Ma-na-se. ");
INSERT INTO hre_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Khoi ca aih Jôsep doi dèh ca 'bài oh daq: “Au cô èh cachìt, mahaq Boc Plình joq 'nàng wèq ban pì, 'ràng pì oh daq hlài gùng haq ma khoi pachac ca Ap-ra-ham, Isac wa Jacôp.” ");
INSERT INTO hre_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Jôsep thê 'bài con calô da Is-ra-ên pachac doi: “Joq 'nàng Boc Plình jah trùh hmàih ca pì. Pì phai 'ràng caxènh au loh khoi enh gùng cô.” ");
INSERT INTO hre_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Jôsep halình jah 110 hanam, hi khoi haq cachìt. Wì yŏc jreo phiang ca hanang Jôsep, èh xom haq ta hom ta gùng Aicàp.");
INSERT INTO hre_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Cô hiniq 'bài con calô da Is-ra-ên, rìm ngai dìq 'nong dèh cadraq cla lam tiaq Jacôp trùh ta gùng Aicàp: ");
INSERT INTO hre_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubên, Si-mê-ôn, Lêwi wa Juđa; ");
INSERT INTO hre_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","I-sa-ca, Xe-bu-lun, Bên-ja-min; ");
INSERT INTO hre_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Đan, Nep-ta-li, Gat wa Ase. ");
INSERT INTO hre_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Dìq dŏng mangai Jacôp xa-ông loh jah 70 ngai, taiq Jôsep khoi ŏi ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Èh Jôsep, oh daq haq wa rìm ngai ta 'nhòng aih cachìt dìq. ");
INSERT INTO hre_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Con xau Is-ra-ên loh bàc tam dìq jaq, wìa ca tadêh dìq jaq bình halùih jàp ca gùng. ");
INSERT INTO hre_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Mahaq manàiq cô ŏi ta Diac Aicàp i mòiq toq bùa ùh canao loq ca Jôsep. ");
INSERT INTO hre_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Bùa aih doi dèh ca jàn cla: “Ngan cô, jàn Is-ra-ên bàc wa ji dêh ca bèn. ");
INSERT INTO hre_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Beq, bèn ep chaq trong khôn rabiaq ta'blêq ca wì haq, èh yùq wì loq ji bàc tam, mòiq hì leq èh loq i bìac tajêh poh trùh wa wì haq jah pajùm ca lình ma git bèn, hi tajêh hlài ca bèn, èh wì cadàu mot loh khoi ca gùng cô!” ");
INSERT INTO hre_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","'Màng aih mangai Aicàp doi ca 'bài mangai broq gàu baxa jàn Is-ra-ên thê wì haq broq bìac xalep, broq phôq Pithom wa Ramse đòiq broq hapom càn ca Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mahaq mangai Aicàp baxa jàn Is-ra-ên dàng leq, èh wì loh bàc tam dang aih. 'Màng aih, mangai Aicàp yùq crè jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Mangai Aicàp thê wì broq hapŏng dìch chìuq bìac xalep yi hnao, ");
INSERT INTO hre_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","wa broq ca can rìh jàn aih loh ca nan xa, taiq wì ep jôiq taneh broq gech wa broq rìm bìac ma 'noiq ŏi ta đùng. Ta dìq ca bìac mangai Aicàp thê jàn Is-ra-ên abroq nhang nhuiq dìq jaq. ");
INSERT INTO hre_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Èh bùa Diac Aicàp doi ca baiq mangai ngai ngan xa-ông da jàn Hêbru, hiniq haq Siprah wa mòiq ngai hiniq Puah, ");
INSERT INTO hre_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Jò chôp lam ngan gu cadrì Hêbru xa-ông, tàng hnoq xa-ông con calô, pì jêh haq cachìt beq, mahaq tàng haq con cadrì đòiq haq rìh.” ");
INSERT INTO hre_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mahaq 'bài mangai ngan xa-ông yùq crè ca Boc Plình, ùh broq tiaq bàu bùa Aicàp thê, đòiq con calô rìh dŏng. ");
INSERT INTO hre_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Bùa Aicàp creo ca 'bài mangai ngan xa-ông trùh, haq doi ca wì: “Gleq pì ma broq 'màng aih đòiq ca wì con calô rìh?” ");
INSERT INTO hre_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","'Bài mangai ngan xa-ông doi: “Taiq mangai cadrì Hêbru ùh xài troi mangai gu cadrì Aicàp. Wì yi tadêh khoi xa-ông adroi ca mangai ngan xa-ông trùh.” ");
INSERT INTO hre_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Boc Plình am xôq ramŏt ca 'bài mangai ngan xa-ông, ma jah 'màng aih jàn Is-ra-ên mòiq hì mòiq bàc. ");
INSERT INTO hre_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Taiq mangai ngan xa-ông i manoh iu crè ca Boc Plình, Haq broq loh ca wì jah i cadraq ca dađeh. ");
INSERT INTO hre_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pha-ra-ôn 'noh bàu thê dèh ca jàn cla: “Con calô da jàn Hêbru leq neo xa-ông hwenh đac ta cròng diac Ninh beq, phàn con cadrì, đòiq am rìh.” ");
INSERT INTO hre_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","'Nhòng aih, i mòiq ngai ta 'bài 'bôq Lêwi yŏc con cadrì Lêwi broq mai. ");
INSERT INTO hre_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Gù cadrì aih ŏi jiang, xa-ông mòiq toq con calô, hnoq dèh con lem lình dìq jaq, haq ma jah cadoc piq khê. ");
INSERT INTO hre_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mahaq cadoc yi dùnh hòm ùh jah, haq yŏc mòiq toq cađap lìt xam chai, hi khoi ta'ngùi con 'yoh ta aih, bahìu nòi i blùm ŏi ta diac ti roc kenh cròng diac Ninh. ");
INSERT INTO hre_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Daq cadrì con nga aih yòng hangai ca nòi aih đòiq loq ca mangai 'yoh aih 'màng leq? ");
INSERT INTO hre_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Èh i con cadrì bùa Pha-ra-ôn lam hùm ta cròng diac Ninh. 'Bài mangai patìh ca haq cadiang roc kenh diac wa jò con cadrì da bùa hnoq talenh aih ŏi ta'ne blùm, haq thê dèh 'bài mangai patìh ca haq lam dèch atŏc. ");
INSERT INTO hre_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Con cadrì Pha-ra-ôn pèh calàp talenh hnoq con nga calô 'nang crò, manoh haq xa-ŏch haq doi: “Cô con mangai Hêbru.” ");
INSERT INTO hre_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Daq cadrì con nga aih doi ca con cadrì Pha-ra-ôn: “Ìh enh au lam creo ca mangai i tôh am ùq ta 'bài mangai gù cadrì Hêbru đòiq am con nga cô ùq ùh?” ");
INSERT INTO hre_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Con cadrì Pha-ra-ôn tèu haq: “Lam beq.” Daq aih lam creo ca miq con nga. ");
INSERT INTO hre_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Con cadrì Pha-ra-ôn doi: “ 'Ràng con nga cô ahlài ban ca au beq. Au ca'naih am 'bac cùng ban.” Mangai miq achong con nga am haq ùq. ");
INSERT INTO hre_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Trùh jò khoi càn, haq 'nong con mangai aih 'mùt ca con cadrì Pha-ra-ôn nhàn haq wìa dèh con, èh hiniq ca haq Môise, ma jah 'màng aih haq doi: “Au khoi dèch haq khoi enh diac.” ");
INSERT INTO hre_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Khoi èh ta 'nhòng aih, Môise khoi càn lam trùh dèh ta oh daq cla, haq hnoq wì broq bìac xalep dìq jaq, haq hadai hnoq mòiq ngai, mangai Aicàp jêh mòiq ngai mangai Hêbru, oh daq haq. ");
INSERT INTO hre_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Haq ngan dudan hnoq ùh i cabô, èh haq jêh đac mangai Aicàp, hi khoi catùh ta braih. ");
INSERT INTO hre_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Hì atìq, Môise lam hòm, hnoq baiq ngai mangai Hêbru tajêh dabau. Haq doi ca mangai ma i lôi: “Gleq ìh ma tajêh dèh ca oh daq cla?” ");
INSERT INTO hre_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mahaq mangai aih tèu haq: “I cabô thê ìh broq cwan càn wèq nhèn, broq cwan hadrah am ca nhèn? I joq ìh enh jêh đac au troi ìh ma jêh đac mangai Aicàp tau ùh?” Môise crè, haq doi: Joq 'nàng bìac cô wì khoi loq. ");
INSERT INTO hre_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pha-ra-ôn hìa bàu aih, haq chaq jêh đac Môise, mahaq Môise khoi mot claih ca Pha-ra-ôn, lam gùng Ma-đi-an, ha'ngui haten ca mòiq toq diac adràm. ");
INSERT INTO hre_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Jò aih, pajàu gùng Ma-đi-an i tapèh toq con cadrì. 'Bài con cadrì aih lam trùh 'mùt diac ùc bình ta atong đòiq calùh trìu baq wì haq ôq. ");
INSERT INTO hre_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mahaq i 'bài mangai ban trìu lam trùh hnan đac wì haq. Môise yòng wiang enh pah 'bài con cadrì aih, èh am calùh trìu da wì haq ôq diac. ");
INSERT INTO hre_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Pajàu Ruên hnoq dèh 'bài con hlài, tajòi 'mòi haq bòch: “Gleq hì cô pì con hlài ma xrŏih?” ");
INSERT INTO hre_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wì tèu: “I mòiq ngai mangai Aicàp dŏih nhèn claih enh tì 'bài mangai ban trìu, èh haq hadai gôch bàc diac am ca calùh trìu nhèn ôq.” ");
INSERT INTO hre_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Baq wì bòch: “Mangai aih manàiq ŏi ta leq? Gleq pì con ma cađac haq lam. Akhen haq lam trùh ta cô caq 'benh beq.” ");
INSERT INTO hre_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Môise enh ŏi ti mangai cô; mangai cô ta'mroq Xi-po-rah con haq broq mai am ca Môise. ");
INSERT INTO hre_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Xi-pô-rah xa-ông mòiq toq con calô. Môise hiniq ca haq Getsôn ma jah 'màng aih Môise doi: “Au ŏi đò ta Diac 'noiq.” ");
INSERT INTO hre_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Atìq ca aih dùnh, bùa Diac Aicàp cachìt. Jàn Is-ra-ên hràng rayoih creo dang, ma jah 'màng wì haq aih ep broq hapŏng abroq xalep dìq jaq. Bàu creo dang khoi trùh ta Boc Plình. ");
INSERT INTO hre_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Boc Plình tàng bàu hràng rayoih wì, hi hmàng trùh bìac wêh jao Haq ma broq ca Ap-ra-ham, Isac wa Jacôp. ");
INSERT INTO hre_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Boc Plình xa-ŏch ca jàn Is-ra-ên, ngan hnoq ro wì haq. ");
INSERT INTO hre_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Jò aih Môise ban trìu Jêtrô, baq mai haq, pajàu ta gùng Ma-đi-an. Haq ajèn calùh trìu tŏc pah tau đùng hawit trùh wang da Boc Plình, aih wang Hôrêp. ");
INSERT INTO hre_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","'Bình Plình da Chuaq mahno loh ca Môise ta pla ùnh ta'ne long ramù. Haq ngan hnoq ùnh cheo xèm long, mahaq ùh bùh đac. ");
INSERT INTO hre_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Môise doi: “Au thia haten đòiq ngan bìac halac càn cô, ma jah 'màng aih gleq ùnh cheo long ma ùh bùh đac.” ");
INSERT INTO hre_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Chuaq hnoq haq thia haten ngan, Boc Plình ŏi ta'ne long ramù creo: “Ô Môise, Ô Môise!” Haq tèu: “I au cô.” ");
INSERT INTO hre_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Boc Plình doi: “Apaq thia haten nòi cô, lêh jai ìh beq, ma jah 'màng aih nòi ìh ma 'nang yòng 'mat, aih taneh hadròih.” ");
INSERT INTO hre_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Khoi èh haq doi hòm: “Au Boc Plình da boc yaq ìh, Boc Plình da Ap-ra-ham, Boc Plình da Isac, Boc Plình da Jacôp.” Môise chê đac dèh hadrò, ma jah 'màng aih yùq loq ngan hnoq Boc Plình. ");
INSERT INTO hre_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Chuaq doi: “Au khoi hnoq ro bìac nan xa da jàn Au ta Diac Aicàp wa tàng bàu wì creo dang taiq mangai wì abroq padit padiang wì haq. Joq 'nàng au khoi loq ca can nan xa wì haq. ");
INSERT INTO hre_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Au loh trùh đòiq dèch jàn cô claih enh tì mangai Aicàp, 'nong wì haq enh gùng aih tŏc trùh mòiq gùng 'noiq lem, taneh càn i bàc sùa wa diac xùt, aih nòi jàn Ca-na-an, jàn Hêtit, jàn A-mô-rit, jàn Pe-rê-xit wa jàn Jê-bu-xit ŏi. ");
INSERT INTO hre_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Cô, bàu creo dang da jàn Is-ra-ên khoi trùh ta Au. Au khoi hnoq jàn Aicàp padit padiang wì haq 'màng leq. ");
INSERT INTO hre_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","'Màng aih manàiq cô, thia jang cô beq, Au thê ìh lam trùh Pha-ra-ôn đòiq 'nong jàn Au, jàn Is-ra-ên loh khoi ca Diac Aicàp.” ");
INSERT INTO hre_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Môise tèu: “Au cô cabô ma hùa lam trùh Pha-ra-ôn đòiq 'nong jàn Is-ra-ên loh khoi ca Diac Aicàp?” ");
INSERT INTO hre_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Boc Plình doi: “Au jah ŏi ti ìh. Cô teo broq waq ca ìh loq, Au khoi thê ìh lam: Jò ìh khoi 'nong 'bài jàn loh khoi Diac Aicàp, èh pì jah patìh ca Boc Plình ta bôi wang cô.” ");
INSERT INTO hre_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Môise bòch Boc Plình: “Cô, jò au lam trùh ta jàn Is-ra-ên doi ca wì haq: ‘Boc Plình da boc yaq pì thê au trùh ti pì;’ mahaq tàng wì bòch: ‘Haq hiniq cleq?’ Èh au doi ca wì 'màng leq?” ");
INSERT INTO hre_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Boc Plình doi ca Môise: “Au Chuaq I Đeh, Ŏi Hloi Hloi.” Khoi èh Haq doi hòm: “Doi ca jàn Is-ra-ên 'màng cô beq: ‘Chuaq i Đeh Ŏi Hloi Hloi thê au trùh ti pì.’ ” ");
INSERT INTO hre_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Boc Plình doi hòm ca Môise: “Ìh jah anoi ca jàn Is-ra-ên 'màng cô: ‘Chuaq, Boc Plình da boc yaq pì, Boc Plình da Ap-ra-ham, Boc Plình da Isac, Boc Plình da Jacôp, thê au trùh ti pì.’ “Aih hiniq hloi hloi da Au đòiq hmàng hloi ca au cwa dìq ca 'nhòng. ");
INSERT INTO hre_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Lam tagop 'bài craq broq gàu Is-ra-ên, hi doi ca wì haq: ‘Chuaq da boc yaq pì, Boc Plình da Ap-ra-ham, Boc Plình da Isac Boc Plình da Jacôp khoi mahno loh ca au doi ca au: Joq 'nàng 'màng aih, Au khoi lam hmàih ca pì, hnoq bìac wì broq ca pì ta Diac Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Au khoi rùp bàu đòiq dŏih dèch pì loh khoi ca nòi nan xa ta Diac Aicàp, đòiq 'ràng pì tŏc ta gùng da jàn Ca-na-an, jàn Hêtit, jàn A-mô-rit, jàn Pe-rê-xit, jàn Hêwit, wa jàn Jê-bu-xit, aih taneh càn ma i bàc diac sùa wa diac xùt.’ ");
INSERT INTO hre_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Jàn Is-ra-ên jah iu tiaq bàu ìh. 'Màng aih, ìh wa 'bài craq broq gàu Is-ra-ên lam bòch bùa Aicàp: ‘Chuaq, Boc Plình da jàn Hêbru khoi mahno 'noh ca nhèn. 'Màng aih manàiq cô xìn đòiq nhèn lam trùh nòi cadan piq hì lam ca trong đòiq am tadreo ca Chuaq, Boc Plình nhèn.’ ");
INSERT INTO hre_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Mahaq Au loq bùa Aicàp ùh am pì lam tàng Au ùh yŏc cwìang itai đòiq panan haq. ");
INSERT INTO hre_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mahaq Au jah hnhu tì tabroq ca jàn Aicàp xam bìac halac Au broq ta'ne wì haq. Atìq ca aih haq jah am pì lam. ");
INSERT INTO hre_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Au jah broq jàn cô jah xôq jang ngìa mangai Aicàp. 'Màng aih jò pì loh lam, èh ùh hìaq loh lam tì dech. ");
INSERT INTO hre_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mahaq rìm ngai gu cadrì Is-ra-ên jah bòch xìn mangai gu cadrì haten hatìa wa mangai ma ŏi đò ta hnem cla wì ngè xam wang, xam 'bac wa eo, caxùnh am dèh ca con calô wa con cadrì, 'màng aih, pì jah yŏc dìq ca cùng hang jàn Aicàp.” ");
INSERT INTO hre_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Môise tèu doi: “Mahaq jàn aih ùh lùi, ùh iu bàu au, loq wì doi: Chuaq ùh i mahno loh ti ìh đòh.” ");
INSERT INTO hre_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Chuaq doi: “Ta tì ìh wê cleq?” Haq tèu: “Mòiq toq long canhra.” ");
INSERT INTO hre_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Boc Plình doi: “Ca'nìh ta taneh beq.” Môise ca'nìh ta taneh, èh long canhra wìa loh mòiq toq bìh. Môise cadàu mot ca bìh. ");
INSERT INTO hre_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Èh Chuaq doi ca Môise: “Hnhu tì cadop tenh haq beq.” Môise hnhu tì cadop, èh haq wìa hlài long canhra ta tì Môise. ");
INSERT INTO hre_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Chuaq doi: “ 'Màng aih đòiq wì haq lùi Chuaq, Boc Plình da boc yaq cla wì, aih Boc Plình da Ap-ra-ham, Boc Plình da Isac, Boc Plình da Jacôp khoi mahno loh ca ìh.” ");
INSERT INTO hre_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Chuaq doi hòm: “Yŏc tì đòiq jang rada beq.” Môise đòiq tì khoi èh haq dŏih, tì haq 'bìq bacùn, taboc tìah ca capaih. ");
INSERT INTO hre_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Èh Boc Plình doi: “Yŏc tì đòiq hlài jang rada beq.” Môise đòiq hlài, khoi èh haq dŏih. Tì haq wìa hlài tìah ca akia cla haq ma dùnh. ");
INSERT INTO hre_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Boc Plình doi hòm: “Tàng jò leq jàn aih ùh lùi ìh, ùh iu tiaq bàu da bìac halac yàng mòiq, èh jah lùi tiaq bàu da bìac halac yàng baiq. ");
INSERT INTO hre_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Èh hòm, tàng jàn xôq ùh lùi baiq bìac halac cô, ùh iu tiaq bàu ìh, èh ìh gôch diac enh cròng diac Ninh, ùc ta taneh croh aih, èh diac aih jah wìa loh mahem ta taneh croh.” ");
INSERT INTO hre_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Èh Môise doi ca Chuaq: “Ôi, waiq Chuaq, enh nèh trùh manàiq, loq enh jò Chuaq doi ca hapŏng Ìh, Chuaq loq au ùh hloh capoch, au capoch ùh ro wa rapet au adia.” ");
INSERT INTO hre_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Chuaq doi: “Cabô broq loh hacùng mangai, loq broq hacùng làu, broq clìch, broq xau hnoq, broq ùh xau hnoq? I joq au Chuaq ùh? ");
INSERT INTO hre_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Manàiq, 'màng cô: Lam beq, Au jah ŏi ti hacùng bàu ìh, hnài ìh bàu ìh ep capoch.” ");
INSERT INTO hre_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Môise doi: “Ôi waiq Chuaq, Chuaq enh thê cabô 'noiq lam, èh thê.” ");
INSERT INTO hre_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Chuaq nòih ca Môise doi: “I joq Arôn mangai Lêwi daq ìh ùh? Au loq haq thài capoch. Tau haq 'nang lam trùh ti ìh. Jò hnoq gè haq lem bùi ta manoh. ");
INSERT INTO hre_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","'Màng aih, ìh ta'mon hlài ca haq wa tah bàu ta hacùng haq beq. Jò chôp capoch, Au jah ŏi tì hacùng ìh wa hacùng daq ìh, hnài chôp bìac leq ep broq. ");
INSERT INTO hre_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Arôn jah thai ìh capoch tùang ca 'bài jàn. Cla haq jah broq tìah ca hacùng capoch thai ca ìh, èh ìh jah broq tìah ca Boc Plình da Arôn. ");
INSERT INTO hre_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ìh cadop yŏc long canhra cô nòi tì beq, đòiq broq bìac teo halac.” ");
INSERT INTO hre_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Môise hlài ta Jêtrô baq mai haq, haq doi: “Xìn boc am au hlài ta nòi oh daq au ta Aicàp, đòiq hmàih ca wì ŏi rìh ùh.” Jêtrô doi ca Môise: “Waiq con lam catèm.” ");
INSERT INTO hre_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Khoi èh, Chuaq doi ca Môise ta gùng Ma-đi-an: “Wìh hlài Diac Aicàp beq; ma jah 'màng aih 'bài mangai ma chaq jêh đac ìh khoi cachìt dŏng.” ");
INSERT INTO hre_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Môise dèch dèh mai wa con tŏc ta crŏng lùa, hlài ta Diac Aicàp. Haq hadai wê long canhra da Boc Plình ta tì. ");
INSERT INTO hre_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Chuaq doi ca Môise: “Jò hlài ta Diac Aicàp, ìh ep broq dìq ca bìac halac da Au khoi jao ta tì ìh, đòiq broq jang ngìa Pha-ra-ôn. Mahaq au jah broq ca Pha-ra-ôn cadoq manoh ùh am ca jàn lam. ");
INSERT INTO hre_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","'Màng aih ìh ep doi ca Pha-ra-ôn 'màng cô: Chuaq doi 'màng cô: Is-ra-ên con calô Au, aih con ramua Au. ");
INSERT INTO hre_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Au i doi ca ìh: Am con Au lam beq, đòiq haq cùh waiq Au, mahaq tàng ìh tàt ùh am haq lam cô, Au jah jêh đac con calô ìh, aih con ramua da ìh.” ");
INSERT INTO hre_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Jò lam ti trong, Chuaq mahno loh jang ngìa Môise nòi hnem padài, jêh đac haq. ");
INSERT INTO hre_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Xi-po-rah yŏc deo xam hmu pŏt dèh akia con calô, hwenh jang jènh Môise, rai doi: “Ôi, joq 'nàng ìh con ŏng top mahem da au.” ");
INSERT INTO hre_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Boc Plình đòiq haq catèm. Jò Xi-pô-rah doi: “Ìh ŏng da mahem ca au,” haq doi 'màng aih taiq bìac lè cat akia. ");
INSERT INTO hre_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Chuaq doi ca Arôn: “Lam trùh nòi braih càn, đìh yŏc Môise beq.” Arôn lam glàm Môise ta wang da Boc Plình, hìp haq. ");
INSERT INTO hre_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Môise ta'mon hlài ca Arôn rìm bàu Chuaq ma thê haq doi, wa 'bài teo halac Haq khoi thê haq broq. ");
INSERT INTO hre_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","'Màng aih Môise lam ti Arôn tagop hlài dìq ca gu craq Is-ra-ên ma broq gàu. ");
INSERT INTO hre_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Arôn ta'mon dìq dŏng 'bài bàu da Chuaq ma khoi doi ca Môise, wa broq 'bài teo halac jang ngìa 'bài jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Wì lùi, wa loq Chuaq khoi lam hmàih ca Is-ra-ên wa khoi hnoq bìac nan xa da wì. Tajòi 'mòi cla wì cùp gàu cùh waiq. ");
INSERT INTO hre_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Khoi ca aih, Môise wa Arôn lam anoi ca Pha-ra-ôn: “Chuaq, Boc Plình da jàn Is-ra-ên i doi 'màng cô: ‘Am jàn Au lam beq, đòiq wì haq jah broq lè caq hiniang am ca Au ta nòi braih càn.’ ” ");
INSERT INTO hre_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mahaq Pha-ra-ôn tèu: “Chuaq cô bô ma au ep iu bàu Haq đòiq am jàn Is-ra-ên lam? Au ùh 'nì ca Chuaq aih, au hadai ùh am ca jàn Is-ra-ên lam.” ");
INSERT INTO hre_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Môise wa Arôn doi: “Boc Plình da jàn Hêbru khoi trùh ta nhèn. Xìn ca'naih nhèn lam mùt ta nòi braih càn cadan piq hì lam ca trong, đòiq nhèn am tadreo ca Chuaq, Boc Plình nhèn, yùq haq broq bình ramòt wa bìac chang gùm jêh đac nhèn.” ");
INSERT INTO hre_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Bùa Aicàp tèu: “Ô, Môise wa Arôn, gleq chôp ma broq ca 'bài jàn cađac ca bìac broq 'màng aih? Thê wì lam broq bìac beq!” ");
INSERT INTO hre_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pha-ra-ôn doi hòm: “Ngan, 'bài jàn ta gùng cô bàc, chôp broq ca wì haq padài ca abroq 'mòh?” ");
INSERT INTO hre_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ta hì aih, Pha-ra-ôn thê 'bài cwan wèq hapŏng wa mangai ngan abroq doi: ");
INSERT INTO hre_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Pì pi jah am hri ca 'bài jàn broq gech troi adroi hòm, đòiq wì haq ep ti chaq đeh. ");
INSERT INTO hre_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mahaq pì phai pajaq ca wì haq broq loh gech 'màng troi jaq dùnh, ùh jah baxùch 'nah, ma jah 'màng aih wì haq aroh, chaq nen doi: Lam am tadreo ca Boc Plình nhèn đeh. ");
INSERT INTO hre_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Am wì haq broq trap beq, đòiq wì haq pi hèm trùh ca bàu amòng hòm.” ");
INSERT INTO hre_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","'Bài cwan wèq hapŏng wa 'bài mangai ngan abroq doi ca 'bài jàn: “Pha-ra-ôn doi 'màng cô: Au pi am ca pì hri hòm. ");
INSERT INTO hre_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Pì chaq đeh hri ta leq, chaq beq, mahaq pì xôq ep am gech tôm tàu troi jaq dùnh.” ");
INSERT INTO hre_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Manàiq cô, 'bài jàn lam jàp ta gùng Aicàp, đòiq gop rangàu hri thai hri. ");
INSERT INTO hre_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","'Bài cla cwan wèq hapŏng bahôiq hòm: “Broq ma gêh bìac pì beq, troi ma khoi pajaq, hì leq gêh hì aih, hadai tìah ca jò bùa ma ŏi am hri.” ");
INSERT INTO hre_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","'Bài mangai ngan abroq 'bìq cwan ma Pha-ra-ôn atŏc wèq hapŏng, blai wì, hi lech: “Gleq hì nèh wa hì cô, pì ùh broq gech phàn bìac ma pajaq adroi?” ");
INSERT INTO hre_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","'Bài mangai ngan abroq lam waiq xìn Pha-ra-ôn: “Xìn ìh apaq broq ca nhèn mangai hapŏng 'màng cô! ");
INSERT INTO hre_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ùh i ca hri am ca nhèn, èh thê nhèn broq gech! Cô, nhèn hapŏng bùa 'bìq cwan wèq hapŏng blai taiq lôi cla jàn da bùa.” ");
INSERT INTO hre_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mahaq bùa tèu hlài: “Pì mangai aroh! Pì mangai aroh! Taiq nen aih dài pì doi ca dabau: ‘Bèn lam am tadreo ca Chuaq.’ ");
INSERT INTO hre_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Manàiq cô, lam broq bìac beq, pi am ca pì hri hòm, mahaq pì xôq ep am tôm gech ma khoi pajaq.” ");
INSERT INTO hre_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","'Màng aih, 'bài mangai ngan abroq loh ca manhài manoh, ma jah 'màng aih jò tàng bàu doi: “Pì ùh jah 'noh 'nah sôq gech khoi pajaq dèh ca cla, hì leq gêh hì meh.” ");
INSERT INTO hre_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Jò wì loh khoi enh Pha-ra-ôn wì glàm Môise wa Arôn ŏi yòng gòm nòi aih. ");
INSERT INTO hre_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Wì doi: “Chôp khoi broq ca nhèn loh ca xua om jang ngìa Pha-ra-ôn wa 'bài cwan haq, 'mùt chang gùm ta tì wì haq đòiq jêh đac nhèn. Waiq xìn Chuaq ngan wa hadrah chôp!” ");
INSERT INTO hre_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Môise wìh hlài ta Chuaq haq bòch: “Waiq Chuaq, gleq Ìh ma broq raliang ca jàn cô? Chuaq thê au trùh broq cleq? ");
INSERT INTO hre_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Pàng jò au canòm ca hiniq Chuaq lam anoi ca Pha-ra-ôn, èh haq hadrùq hadriang jàn cô. Chuaq ùh dŏih dèch jàn da Ìh leq.” ");
INSERT INTO hre_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Chuaq doi ca Môise: “Manàiq cô ìh jah hnoq bìac Au broq ca Pha-ra-ôn, ma jah 'màng aih nhò tì i cwìang itai Au panan bùa đòiq bùa ca'naih wa hnan jàn Is-ra-ên loh khoi ca gùng haq.” ");
INSERT INTO hre_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Boc Plình doi hòm ca Môise: “Au Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Au khoi mahno loh ca Ap-ra-ham, ca Isac wa ca Jacôp. Au pa'noh dađeh Boc Plình I Cwìang Itai Dìq Dŏng, mahaq tiaq hiniq Au, Chuaq Jê-hô-wa, èh Au 'nhòq lah paro ca wì loq. ");
INSERT INTO hre_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Au hadai i broq wêh jao ca wì haq, đòiq am gùng Ca-na-an, gùng wì haq khoi ŏi đò tìah ca mangai jàn 'noiq. ");
INSERT INTO hre_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Au hadai tàng bàu hràng rayoih da jàn Is-ra-ên 'bìq mangai Aicàp rùp wì broq hapŏng, wa Au hmàng hlài wêh jao da Au. ");
INSERT INTO hre_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“ 'Màng aih èh, ìh doi ca jàn Is-ra-ên 'màng cô: Au Chuaq jah dèch pì claih ca genh trap da mangai Aicàp, hadai dŏih pì claih ca broq hapŏng dìch. Au jah dèch claih pì xam tì da au wa hnhu 'noh tì, yŏc bìac hadrah càn đòiq rŏt hlài pì. ");
INSERT INTO hre_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","“Èh Au jah nhàn pì broq jàn Au. Au jah broq Boc Plình pì. Pì jah loq au Chuaq Boc Plình da pì ma khoi dèch pì claih ca genh trap da mangai Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Au jah tìch pì mùt ta gùng Au ma khoi hùaq am ca Ap-ra-ham, ca Isac wa ca Jacôp đòiq am ca pì broq xôxech. Au cô Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Môise anoi hlài bàu aih ca jàn Is-ra-ên, mahaq wì ùh tamàng bàu haq taiq wì mango ca bìac broq dìch trap hrìn. ");
INSERT INTO hre_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Lam doi ca Pha-ra-ôn bùa Aicàp beq, haq ep am ca jàn Is-ra-ên lam.” ");
INSERT INTO hre_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mahaq Môise doi ca Chuaq: “Jàn Is-ra-ên ùh tamàng bàu au, ùh dùh dèh Pha-ra-ôn ma tamàng bàu au, taiq au cô mangai ùh rabiaq ca capoch.” ");
INSERT INTO hre_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Chuaq doi hòm ca Môise wa Arôn, thê wa ep lam trùh ta jàn Is-ra-ên wa Pha-ra-ôn bùa Aicàp, đòiq 'nong jàn loh khoi enh Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Cô 'bài hiniq da wì broq gàu da 'bôq dèh baq: 'Bài con calô da Rubên, aih con ramua calô Is-ra-ên, aih Hênoc, Phalu, Hêtrôn, Catmi. Aih xinoi da Rubên. ");
INSERT INTO hre_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","'Bài con calô da Si-mê-ôn: Jê-mu-ên, Jamin, Ôhat, Jakin, Xôha, Saulò, con da mai mangai gùng Ca-na-an. Aih xinoi da Si-mê-ôn. ");
INSERT INTO hre_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Cô hiniq 'bài con calô da Lêwi, tiaq dèh xinoi wì haq: Getsôn, Kêhat, Mê-ra-ri. Lêwi halình jah 137 hanam. ");
INSERT INTO hre_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","'Bài con calô da Getsôn tiaq dèh xinoi cla: Lipni wa Si-mê-i. ");
INSERT INTO hre_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","'Bài con calô da Kêhat: Amram, Ixha, Hêprôn, U-xi-ên. Kêhat halình jah 133 hanam. ");
INSERT INTO hre_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","'Bài con calô da Mê-ra-ri: Mahli wa Musi. Aih xinoi 'bài hadròng hadrech da Lêwi, tiaq xinoi da wì haq. ");
INSERT INTO hre_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","'Màng aih Apram yŏc Jô-kê-bêt, dùch xèm haq broq mai, xa-ông ca haq Arôn wa Môise. Amram halình jah 137 hanam. ");
INSERT INTO hre_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","'Bài con calô da Ixha: Côra, Nêphêt wa Xicri. ");
INSERT INTO hre_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","'Bài con calô da U-xi-ên: Mi-sa-ên, Ên-xa-phan wa Sitri. ");
INSERT INTO hre_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arôn yŏc Ê-li-sê-ba broq mai, con cadrì da A-mi-na-đap, oh da Nahsôn haq xa-ông loh Nađap, A-bi-hu, Ê-li-a-xa wa I-tha-ma. ");
INSERT INTO hre_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","'Bài con calô da Côra: Atsi, Ên-ca-na wa A-bi-a-sap. Aih 'bài xinoi da jàn Côra. ");
INSERT INTO hre_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ê-li-a-xa, con calô da Arôn, yŏc con cadrì da Pu-ti-ên broq mai, haq xa-ông loh Phi-nê-hat ca Pu-ti-ên. Aih 'bài craq broq gàu da hnem Lêwi, tiaq dèh xinoi cla wì haq. ");
INSERT INTO hre_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","'Màng aih, Arôn wa Môise, cla wa haq mangai ma Chuaq khoi doi 'màng cô: “ 'Nong jàn Is-ra-ên loh khoi gùng Aicàp beq.” ");
INSERT INTO hre_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Wa baiq ngai khoi bòch Pha-ra-ôn, bùa Diac Aicàp, đòiq 'nong jàn Is-ra-ên loh khoi Diac aih, aih Môise wa Arôn cô raq. ");
INSERT INTO hre_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Au Chuaq thê ìh doi hlài ca Pha-ra-ôn, bùa Diac Aicàp, dìq rìm bàu Au ma doi ca ìh.” ");
INSERT INTO hre_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mahaq Môise tèu: “Au cô mangai ùh rabiaq ca capoch, 'màng leq Pha-ra-ôn loq tamàng bàu au 'mòh?” ");
INSERT INTO hre_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Chuaq doi ca Môise: “Ngan cô, Au am ìh broq Boc Plình ca Pha-ra-ôn. Phàn Arôn daq ìh, haq broq mangai capoch thai ìh. ");
INSERT INTO hre_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ìh anoi hlài ca Arôn rìm nà Au ma khoi thê ìh, èh Arôn doi hlài ca Pha-ra-ôn đòiq haq ca'naih jàn Is-ra-ên loh khoi ca Diac haq. ");
INSERT INTO hre_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Au broq ca Pha-ra-ôn cadoq manoh, ùh am jàn Au lam, taiq 'mang aih Au jah broq loh tam bàc teo halac da Au ta Diac Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Mahaq Pha-ra-ôn ùh tàng bàu chôp, 'màng aih Au hnhu tì ta taneh Aicàp, baxa Diac aih hlàm dìq jaq, đòiq dèch cwung đôiq da Au loh khoi enh aih, aih jàn mangai Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Jò Au hnhu tì ta Diac Aicàp, 'nong jàn Is-ra-ên loh khoi mangai Aicàp, èh wì haq jah loq Au Chuaq Boc Plình.” ");
INSERT INTO hre_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Môise wa Arôn broq tiaq troq troi bàu Chuaq khoi thê. ");
INSERT INTO hre_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Môise khoi jah 80 hanam wa Arôn 83 hanam jò wa haq anoi ca Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Chuaq doi ca Môise wa Arôn, doi: ");
INSERT INTO hre_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Jò leq Pha-ra-ôn doi ca chôp, broq bìac halac beq, èh ìh doi ca Arôn, yŏc long canhra da daq hwenh jang ngìa Pha-ra-ôn, đòiq long canhra jah wìa loh mòiq toq bìh.” ");
INSERT INTO hre_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","'Màng aih, Môise wa Arôn lam trùh ta Pha-ra-ôn, èh broq 'màng troi bàu Chuaq ma hnài tanap. Arôn hwenh dèh long canhra jang ngìa Pha-ra-ôn wa 'bài cwan, hi khoi long canhra tajòi 'mòi wìa loh mòiq toq bìh. ");
INSERT INTO hre_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mahaq Pha-ra-ôn thê doi ca 'bài mangai thai rabiaq wa 'bài pajàu 'nùt loq creo can kiac, hadai i mangai amòng broq bìac halac da Aicàp; wì haq broq xam cwìang hlèp da wì. ");
INSERT INTO hre_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Long canhra da wì haq hadai wìa bìh. Mahaq bìh da Arôn lŏn dŏng bìh wì haq. ");
INSERT INTO hre_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","'Màng aih manoh Pha-ra-ôn xôq cadoq cadang, ùh tamàng bàu Môise wa Arôn, tìah 'màng troi bàu Chuaq khoi doi. ");
INSERT INTO hre_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Chuaq doi ca Môise: “Pha-ra-ôn khoi cadoq manoh, ùh am ca 'bài jàn lam. ");
INSERT INTO hre_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Xroq èh Pha-ra-ôn loh ti 'bò cròng diac Ninh. Ìh loh glàm haq rai wê long canhra ma wìa loh bìh aih ta tì ìh beq. ");
INSERT INTO hre_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ìh doi ca haq: ‘Chuaq, Boc Plình da jàn Hêbru thê au lam trùh glàm ìh, đòiq anoi ca ìh: Ca'naih jàn Au lam beq, đòiq wì haq cùh waiq Au ta nòi braih càn, mahaq trùh manàiq ìh xôq 'nhòq tamàng. ");
INSERT INTO hre_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Chuaq doi 'màng cô, Taiq bìac cô ìh jah loq Au Chuaq: Cô, Au thê Môise yŏc long canhra ta tì haq, blai diac ta cròng diac Ninh, èh diac aih wìa mahem. ");
INSERT INTO hre_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ca ta cròng diac Ninh cachìt wa diac loh ca xua om, 'màng aih mangai Aicàp ùh jah ôq diac ta cròng diac Ninh.’ ” ");
INSERT INTO hre_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Khoi èh, Chuaq doi ca Môise: “Thê Arôn cadop long canhra hnhu tì ta dìq ca diac Aicàp, diac con, diac cròng, diac 'bau wa jàp rìm nòi leq ma i diac ta gùng aih, đòiq diac wìa mahem, jàp ta gùng Aicàp, wa diac ta 'bài abôq xam long wa abôq xam hmu, hadai wìa mahem.” ");
INSERT INTO hre_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","'Màng aih, Môise wa Arôn broq troq troi bàu Chuaq khoi thê wa, jang ngìa Pha-ra-ôn wa 'bài cwan. Arôn dèch long canhra, blai diac ta cròng diac Ninh, èh dìq dŏng ca diac wìa mahem. ");
INSERT INTO hre_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ca ta diac cachìt, diac cròng xua om, 'màng aih mangai Aicàp ùh jah ôq diac ta cròng diac Ninh. Jàp ta Diac Aicàp i mahem. ");
INSERT INTO hre_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mahaq 'bài mangai amòng broq bìac halac da Aicàp hadai broq jah 'màng aih. Manoh Pha-ra-ôn cadoq cadang, ùh tamàng bàu Môise wa Arôn, tìah troi bàu Chuaq khoi doi. ");
INSERT INTO hre_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pha-ra-ôn hlài dèh ta hnem, èh ji ùh hèm ta manoh bìac aih. ");
INSERT INTO hre_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Khoi èh, taiq dìq dŏng 'bài mangai Aicàp ùh jah ôq diac ta cròng diac Ninh, èh wì chìa roc kenh 'bò diac chaq diac ôq. ");
INSERT INTO hre_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Atìq ca Chuaq blai cròng diac Ninh jah tapèh hì. ");
INSERT INTO hre_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Khoi èh, Boc Plình doi hòm ca Môise: “Lam glàm Pha-ra-ôn, èh doi ca haq, Chuaq doi 'màng cô: ‘Ca'naih jàn Au lam beq, đòiq wì haq jah patìh Au. ");
INSERT INTO hre_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Mahaq tàng ìh ùh ca'naih wì lam, cô, Au baxa ca'naih kìt đùng bàc dìq jaq loh jàp ta taneh Diac ìh. ");
INSERT INTO hre_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kìt đùng tŏc enh cròng diac Ninh bàc dìq jaq, moq mùt ta hnem bùa, ta adùq hnem cùi, ta jùang, mùt ta hnem hapŏng wa jàn ìh, ta tanùh awìh caq, ta nòi pêh dàc broq 'benh da ìh. ");
INSERT INTO hre_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kìt đùng moq tŏc ta chac ìh, ta jàn ìh wa hapŏng ìh.’ ” ");
INSERT INTO hre_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","'Màng aih, Chuaq doi ca Môise: “Doi ca Arôn beq, ‘Cadop long canhra hnhu 'noh ta diac con, ta cròng, ta 'bau diac, broq kìt đùng bàc tŏc ta gùng Aicàp.’ ” ");
INSERT INTO hre_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","'Màng aih, Arôn hnhu tì ta 'bài diac cròng, diac con ta gùng Aicàp, kìt đùng moq tŏc jàp gùng. ");
INSERT INTO hre_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","'Bài mangai amòng broq bìac halac hadai nhò dèh itai kiac dù broq tìah troi 'màng aih đòiq broq kìt đùng moq tŏc jàp ta Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pha-ra-ôn thê chaq Môise wa Arôn, haq doi: “Waiq khàn ca Chuaq, Boc Plình đòiq haq broq kìt đùng hangai ca au wa jàn Au, èh au ca'naih jàn Hêbru lam broq tadreo ca Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Môise doi ca Pha-ra-ôn: “Bùa am ca au loq jò leq bùa enh kìt đùng loh khoi ca gùng Aicàp đòiq au waiq Chuaq đòiq troq jò aih kìt đùng cachìt dŏng, toq kìt ma ŏi ta cròng diac Ninh raq ma ŏi rìh.” ");
INSERT INTO hre_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Bùa tèu: “Trùh hì da èh.” Môise doi: “Jah broq tìah troi bàu ìh, waq ca bùa loq ùh i ca cabô tìah troi Chuaq Boc Plình nhèn. ");
INSERT INTO hre_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","'Màng aih, kìt đùng jah wia khoi ca bùa, hnem bùa, ca hapŏng wa ca jàn da bùa. Toq ta cròng diac Ninh raq ma ŏi i.” ");
INSERT INTO hre_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Môise wa Arôn wia khoi ca Pha-ra-ôn. Môise waiq khàn ca Chuaq bìac Haq ma khoi broq kìt đùng bàc ca Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Chuaq broq troi bàu Môise xìn. Dìq ca kìt đùng ta hnem, ta nòi enh gùng hnem wa ta đùng, cachìt dŏng. ");
INSERT INTO hre_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wì khua đòiq kìt đùng tang ha'ngùc, xua om jàp dìq ca gùng. ");
INSERT INTO hre_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mahaq Pha-ra-ôn hnoq khoi jah claih, haq cadoq manoh hòm, ùh tàng bàu Môise wa Arôn toq xìt leq, tìah troi bàu Chuaq khoi doi. ");
INSERT INTO hre_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Chuaq doi ca Môise: “Doi ca Arôn beq, 'noh long canhra, blai blo taneh beq đòiq blo jah wìa hamech jàp ca gùng Aicàp.” ");
INSERT INTO hre_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Wa broq tiaq 'màng aih. Arôn hnhu tì blai blo taneh, tajòi 'mòi blo wìa hamech jràp ta mangai wa ngè aban. Dìq dŏng blo wìa hamech ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","'Bài mangai amòng broq bìac halac hadai enh nhò dèh kiac dù cla broq dìq 'màng aih đòiq wìa hamech, mahaq broq ùh jah. I hamech jràp mangai wa ngè aban. ");
INSERT INTO hre_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","'Bài mangai amòng broq bìac halac doi hlài ca Pha-ra-ôn: “Aih tì Boc Plình broq.” Mahaq Pha-ra-ôn xôq cadoq manoh, ùh tamàng bàu Môise wa Arôn, tìah troi bàu Chuaq khoi doi. ");
INSERT INTO hre_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Khoi ca aih, Chuaq doi ca Môise: “Ìh phai rìu xrŏih lam glàm Pha-ra-ôn jò haq loh ti 'bò diac, doi ca haq: ‘Chuaq doi, ca'naih jàn Au lam beq đòiq wì haq patìh Au. ");
INSERT INTO hre_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ma jah 'màng aih, tàng ìh ùh am wì haq lam, cô, Au thê roi jràp ta ìh, nòi jàn, nòi hnem ìh wa hnem da mangai Aicàp, roi jràp xìa hloi ta taneh. ");
INSERT INTO hre_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Mahaq hì aih, Au jah lah cròng Gôsen, nòi jàn Au ŏi, ùh i ca roi, waq ca ìh loq ca Au Chuaq Boc Plình ŏi jàp ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Au lah jàn Au ta gùng Gôsen wa jàn ìh broq crài. Hì da èh jah i bìac teo halac cô.’ ” ");
INSERT INTO hre_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Èh Chuaq broq troi bàu haq ma doi. 'Màng aih, ta hnem bùa Pha-ra-ôn, hnem da 'bài cwan haq wa jàp ca gùng Aicàp, i roi bàc dìq jaq, taneh 'bìq roi baxa pani. ");
INSERT INTO hre_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pha-ra-ôn thê creo ca Môise wa Arôn trùh haq, doi: “Lam am tadreo ca Boc Plình pì ŏi ta gùng cô beq.” ");
INSERT INTO hre_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mahaq Môise tèu: “Broq 'màng aih ùh jah, ma jah 'màng aih 'bài ngè tadreo nhèn am ca Chuaq, Boc Plình nhèn, aih bìac 'mèq 'mac ca mangai Aicàp, wì haq ma ùh tèm nhèn xam hmu 'mòh? ");
INSERT INTO hre_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nhèn ep lam ta nòi braih càn, jah baiq piq hì lam ca trong, đòiq am tadreo ca Chuaq, Boc Plình nhèn, troi bàu Haq khoi thê.” ");
INSERT INTO hre_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pha-ra-ôn doi: “Au jah am pì lam tadreo ca Chuaq Boc Plình pì, mahaq paq lam ji hangai. Hmàng waiq khàn ca au dìq.” ");
INSERT INTO hre_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Môise tèu: “Au jah wia khoi ca ìh, waiq khàn am ca ìh. Hì da èh roi jah wia khoi Pha-ra-ôn, 'bài cwan wa jàn bùa. Mahaq ìh apaq 'nùt nhèn hòm ma ùh am nhèn lam tadreo ca Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Môise loh khoi hnem Pha-ra-ôn waiq xìn Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Haq broq troi bàu Môise, roi wia khoi hangai ca Pha-ra-ôn, 'bài cwan wa jàn haq, pi ŏi i hlài mòiq pliang leq. ");
INSERT INTO hre_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mahaq yàng cô, Pha-ra-ôn cadoq manoh hòm, ùh am jàn Is-ra-ên lam. ");
INSERT INTO hre_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Chuaq doi ca Môise: “Lam glàm Pha-ra-ôn doi ca haq, ‘Chuaq Boc Plình da jàn Hêbru doi: “Ca'naih jàn Au lam beq, đòiq wì haq patìh ca Au.” ");
INSERT INTO hre_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ma jah 'màng aih, tàng ìh ùh ca'naih wì haq lam, ŏi padràng hlài hòm. ");
INSERT INTO hre_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Cô, tì da Chuaq jah mùt ta 'bài ngè aban ta đùng, aih axêh, lùa, lŏcđa, 'bo, trìu, èh cachìt bàc dìq jaq taiq 'bình ramòt. ");
INSERT INTO hre_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Chuaq lah ngè aban da jàn Is-ra-ên wa ngè aban da jàn Aicàp loh crài, ùh i mòiq toq leq da jàn Is-ra-ên 'bìq cachìt.’ ” ");
INSERT INTO hre_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Chuaq Boc Plình pachì hì, Haq doi: “Hì da èh Chuaq, Boc Plình broq bìac aih ta Aicàp.” ");
INSERT INTO hre_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Hì atìq, Chuaq, Boc Plình broq bìac aih. Bàc dìq jaq ngè aban da mangai Aicàp cachìt, mahaq da Is-ra-ên ùh cachìt mòiq toq leq. ");
INSERT INTO hre_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pha-ra-ôn thê mangai lam ngan thù joq 'nàng hnoq ngè aban da jàn Is-ra-ên ùh i cachìt. Mahaq Pha-ra-ôn xôq cadoq manoh, ùh am jàn Is-ra-ên lam. ");
INSERT INTO hre_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Chuaq doi ca Môise wa Arôn: “Cadop yŏc blo tanùh ta tì chôp beq. Môise phai chùi blo tanùh tŏc 'nah ta plình jang ngìa Pha-ra-ôn hnoq. ");
INSERT INTO hre_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Blo tanùh wìa blo jàp ca gùng Aicàp, loh ca rahenh loh ca patenh jàp ta chac mangai wa ngè aban jàp ca gùng Aicàp.” ");
INSERT INTO hre_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","'Màng aih, wa cadop blo tanùh yòng jang ngìa Pha-ra-ôn, hi khoi Môise chùi blo tŏc ta plình, èh loh rahenh loh ca patenh jàp ta chac mangai wa ngè aban. ");
INSERT INTO hre_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","'Bài mangai amòng broq bìac halac broq teo halac pi jah yòng jang ngìa Môise, ma jah 'màng aih taiq rahenh wa patenh khoi loh jàp ta chac 'bài mangai amòng broq bìac halac tìah troi ta chac dìq ca mangai Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mahaq Boc Plình broq ca Pha-ra-ôn cadoq manoh, ùh tamàng bàu Môise wa Arôn, tìah troi bàu Chuaq khoi doi ca Môise. ");
INSERT INTO hre_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Khoi èh, Chuaq doi ca Môise: “Ìh rìu xrŏih beq, lam glàm Pha-ra-ôn doi ca haq, Chuaq Boc Plình da jàn doi 'màng cô: Ca'naih jàn Au lam beq, đòiq wì lam patìh ca Au. ");
INSERT INTO hre_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ma jah 'màng aih yàng cô Au pa'noh bìac 'mèq ranàc ca ìh, ca 'bài cwan, ca jàn ìh, waq ca ìh wa jàp crŏng taneh loq ùh i yiang leq dàng Au. ");
INSERT INTO hre_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Tàng Au enh, Au khoi jah 'noh 'bình ranàc đòiq jêh dìq ca jàn ìh khoi ca crŏng taneh cô. ");
INSERT INTO hre_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mahaq Au đòiq ìh ŏi rìh, aih đòiq ìh jah hnoq cwìang itai da Au, đòiq hiniq Au jah anoi 'noh jàp ca phù cròng. ");
INSERT INTO hre_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Mahaq tàng ìh ŏi khech tàt, ùh đòiq jàn Au lam, ");
INSERT INTO hre_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","hi da èh, wop jò cô, Au broq i mè preo càn dìq jaq, enh jò calah nèh trùh manàiq ta gùng Aicàp ùh lah i mè leq ma 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Manàiq cô ìh nhet thê mangai aban 'ràng ngè aban ŏi ta đùng hlài ta hnem beq, taiq èh i mè preo taclìh hi tùc jêh đac mangai wa ngè aban ŏi ta đùng.” ");
INSERT INTO hre_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","'Bài mangai leq ta cwan Pha-ra-ôn i manoh iu crè ca bàu Chuaq, hihôiq hihaiq thê dèh hapŏng wa ngè aban hlài ta hnem, ");
INSERT INTO hre_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","mahaq phàn mangai leq ùh hèm trùh ca bàu Chuaq, èh đòiq dèh hapŏng wa ngè aban ŏi ta đùng. ");
INSERT INTO hre_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Chuaq doi ca Môise: “Hnhu tì ta plình beq, broq mè preo taclìh jàp ca gùng Aicàp, tùc chac mangai, ngè aban wa ngè long nhat ta đùng.” ");
INSERT INTO hre_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Môise hnhu long canhra ta plình, Chuaq thê plình hilùng cađah, 'lìch 'lìch wa mè preo ùc 'noh bàc clìh ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mè preo clìh alôn ca ùnh cheo, enh jò i taneh diac Aicàp trùh manàiq ùh lah i bìac 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Jàp ta gùng Aicàp mè preo broq raliang rìm bìac ŏi ta đùng, mangai, ngè aban, ngè pìt, wa tagoh dìq ca long ta đùng. ");
INSERT INTO hre_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Toq ta Gôsen, nòi jàn Is-ra-ên ŏi, ùh i ca mè preo. ");
INSERT INTO hre_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pha-ra-ôn creo ca Môise wa Arôn doi ca wa: “Yàng cô au khoi broq tôiq, Chuaq ta-atoq. Au wa jàn au khoi broq tôiq. ");
INSERT INTO hre_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Xìn waiq ca Chuaq waq ca hnhung ca hilùng cađah wa mè preo beq, hi khoi au ca'naih pì lam, pi gòm dùnh hòm.” ");
INSERT INTO hre_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Môise tèu: “Jò au loh bu khoi ca phôq, au hnhu tì tŏc ta Chuaq, hilùng cađah hi atàt, mè preo hnhung, waq ca bùa loq crŏng taneh cô da Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mahaq au loq ìh wa 'bài cwan da ìh 'nhòq iu crè ca Chuaq, Boc Plình.” ");
INSERT INTO hre_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ta jò aih, 'mau mat wa long briang tagoh dìq taiq jò 'mau mat xròc i mè preo, wa long briang loh riang. ");
INSERT INTO hre_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Phàn 'mau mì wa 'mau mat xròc clòi, 'màng aih ùh hìaq troq cleq. ");
INSERT INTO hre_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","'Màng aih, Môise wia khoi ca Pha-ra-ôn loh khoi ca phôq, hnhu tì 'nah ta Chuaq, èh hilùng cađah wa mè preo atàt, wa prang ca mè. ");
INSERT INTO hre_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Jò Pha-ra-ôn hnoq mè, mè preo, wa hilùng cađah khoi prang, haq wa 'bài cwan cadoq manoh hòm tìah ca dùnh. ");
INSERT INTO hre_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Manoh Pha-ra-ôn cadoq ùh ca'naih jàn Is-ra-ên lam, tìah troi bàu Chuaq khoi nhò Môise anoi hlài. ");
INSERT INTO hre_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Khoi èh Chuaq doi ca Môise: “Lam trùh ta Pha-ra-ôn beq, ma jah 'màng aih, Au khoi broq ca manoh haq wa manoh 'bài cwan haq cadoq, đòiq 'bài teo halac da Au jah broq loh ŏi ta'ne wì haq, ");
INSERT INTO hre_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","đòiq ìh jah ta'mon hlài dèh ca con calô wa ca xau calô loq ca bìac càn caiq Au ma khoi broq ta'ne jàn Aicàp, 'bài teo halac Au khoi broq ta'ne wì haq, đòiq wì loq Au Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Môise wa Arôn lam trùh ta Pha-ra-ôn wa doi: “Chuaq Boc Plình jàn Is-ra-ên, doi, ‘dùnh dàng leq hòm ìh ùh chìuq 'nhùa dađeh ha'neq jang ngìa Au? Ca'naih jàn Au lam beq, đòiq wì haq patìh bìac Au. ");
INSERT INTO hre_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Tàng ìh ùh ca'naih jàn Au lam, cô, hì da èh, Au thê lìp tùc trùh ta taneh gùng ìh, ");
INSERT INTO hre_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","jràp jàp ta taneh, trùh 'mòi pì pi hnoq taneh. Wì haq caq dŏng 'bài dahwèq leq ma ŏi i hlài atìq mè preo, hadai caq 'bài long hon ta đùng pì, ");
INSERT INTO hre_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","mùt bình ta hnem ìh, hnem da 'bài cwan ìh, ta hnem 'bài mangai Aicàp, aih bìac baq ìh wa boc yaq ìh ma 'nhòq lah hnoq enh jò wì haq khoi i ta crŏng taneh trùh hì cô.’ ” Khoi èh Môise tawìh loh lam khoi ca Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","'Bài cwan Pha-ra-ôn doi ca Pha-ra-ôn: “Trùh jò leq mangai cô jah bet rahoch nhèn? Ca'naih con calô da jàn aih lam beq, đòiq wì haq patìh Chuaq, Boc Plình wì haq. Bùa ma ùh loq Diac Aicàp khoi 'bìq raliang cachìt 'mòh?” ");
INSERT INTO hre_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Wì thê creo ca Arôn wa Môise hlài ta Pha-ra-ôn. Haq doi ca wa: “Lam patìh Chuaq pì beq! Mahaq mangai leq ma lam?” ");
INSERT INTO hre_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Môise tèu: “Nhèn lam, 'nong enh mangai 'yoh trùh mangai craq, dìq con calô, con cadrì wa calùh trìu wa calùh 'bo lam tiaq, ma jah 'màng aih dìq ca nhèn ep am ngè tadreo ca Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pha-ra-ôn tèu: “Joq 'nàng Chuaq pì phai i cwìang dìq jaq wèq ban pì tàng i jò leq au ma am ca pì wa con caiq pì lam! Au loq pì i manoh broq bìac pađim. ");
INSERT INTO hre_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ùh jah 'màng aih đòh! Toq pì raq, aih gu calô ep lam patìh Chuaq, taiq bìac aih raq pì khoi xìn.” Khoi èh, wì hnan Môise wa Arôn loh khoi ca Pha-ra-ôn. ");
INSERT INTO hre_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Chuaq doi ca Môise: “Hnhu tì ìh loh ta gùng Aicàp, đòiq lìp tùc loh jàp ta gùng aih, caq dŏng nhat, cachiq wa rìm ngè leq ta taneh mè preo ma ŏi xrong hlài.” ");
INSERT INTO hre_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","'Màng aih Môise hnhu dèh long canhra ta gùng Aicàp, èh Chuaq 'nong cayeo pah mat mahì loh hlôi ta gùng aih xèq hì aih wa mang aih, trùh xroq èh cayeo pah mat mahì loh 'nong lìp tùc trùh. ");
INSERT INTO hre_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Lìp tùc tŏc jàp ta gùng Aicàp wa loh ta taneh diac gùng aih bàc dìq jaq. Calah nèh 'nhòq lah i lìp tùc 'mèq 'màng aih, atìq cô èh xôq ùh i jò leq i lìp 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Lìp tùc jràp jàp ca gùng, broq dìq ca gùng loh clam clôiq, cap lŏn dìq nhat cachiq ta đùng wa plì long mè preo rong đòiq. Ta dìq gùng Aicàp pi ŏi i tacònh nhat loq long ŏi i hla xenh ta đùng hòm. ");
INSERT INTO hre_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pha-ra-ôn bahôiq thê creo ca Môise wa Arôn trùh. Haq doi: “Au khoi broq tôiq ca Chuaq, Boc Plình pì wa cla pì. ");
INSERT INTO hre_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Mahaq manàiq cô xìn ca'naih tôiq ca au mòiq yàng cô hòm. Waiq Chuaq, Boc Plình pì beq, waq ca Haq broq ca bìac ramòt cô wia hangai ca au.” ");
INSERT INTO hre_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Môise loh khoi ca Pha-ra-ôn, waiq dang Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Chuaq 'nong cayeo pah mat mahì mùt trùh dêh, 'nong lìp tùc 'noh dìq ta Diac Raxìq Gòh. Jàp taneh Diac Aicàp pi ŏi i mòiq pliang lìp tùc leq. ");
INSERT INTO hre_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mahaq Chuaq broq ca Pha-ra-ôn cadoq manoh, haq ùh ca'naih jàn Is-ra-ên lam. ");
INSERT INTO hre_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Èh Chuaq doi ca Môise: “Hnhu tì ìh tŏc ta plình beq, waq ca jàp ta gùng Aicàp i can clam habàu dìq jaq, tìah ca jah bèq.” ");
INSERT INTO hre_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","'Màng aih, Môise hnhu tì tŏc ta plình, èh i can clam clôiq dìq jaq habàu trom piq hì ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ta piq hì aih, wì ùh jah hnoq dabau, ùh i cabô jah axìch dèh ca nòi cla. Mahaq ta nòi jàn Is-ra-ên ŏi, i 'ngah ca wì haq. ");
INSERT INTO hre_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pha-ra-ôn thê creo Môise, haq doi: “Lam patìh Chuaq beq, con 'yoh pì hadai lam, toq calùh trìu wa 'bo ŏi hlài raq.” ");
INSERT INTO hre_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mahaq Môise tèu: “Ìh phai am ca nhèn 'ràng ngè tadreo wa dahwèq leq đòiq broq ngè tadreo bùh đòiq am ca Chuaq, Boc Plình nhèn. ");
INSERT INTO hre_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Dìq calùh ngè aban jah tiaq nhèn dìq, ùh đòiq hlài mòiq cachop leq. Ma jah 'màng aih nhèn yŏc ngè aban aih đòiq patìh Chuaq nhèn, nhèn men loq ngè leq đòiq cùh waiq Boc Plình, toq jò leq hi lam trùh nòi aih.” ");
INSERT INTO hre_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mahaq Chuaq broq ca Pha-ra-ôn cadoq manoh, ùh lènh am jàn Is-ra-ên lam. ");
INSERT INTO hre_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pha-ra-ôn doi: “Lùi khoi ca au ma hangai beq! Wèq dađeh beq, apaq hnoq hadrò au hòm, ma jah 'màng aih hì leq ìh hnoq hadrò au, ìh phai cachìt.” ");
INSERT INTO hre_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Môise doi: “Ìh anoi joq. Au pi jò leq hnoq hadrò ìh hòm.” ");
INSERT INTO hre_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Chuaq doi ca Môise: “Au 'noh ca Pha-ra-ôn mòiq bìac baxa hòm. Khoi èh haq ca'naih pì lam khoi nòi cô, ùh xài toq ca'naih pì lam, mahaq hnan pì loh khoi nòi cô. ");
INSERT INTO hre_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","'Màng aih, doi ca jàn, tanap ca rìm ngai ùh kè gù cadrì loq gù calô, ep xìn mangai ma ŏi haten ca wì haq, ngè xam 'bac wa ngè xam wang.” ");
INSERT INTO hre_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Chuaq broq ca jàn Is-ra-ên jah xôq jang ngìa mangai Aicàp. Môise hadai mangai dìq jaq jah padèch ta gùng Aicàp, jang ngìa 'bài cwan da Pha-ra-ôn wa jang ngìa jàn aih. ");
INSERT INTO hre_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Môise khoi doi ca Pha-ra-ôn: “Chuaq doi 'màng cô, Jò 'ne mang Au loh lam jàp ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Dìq dŏng con calô ramua ta gùng Aicàp phai cachìt, enh con ramua da Pha-ra-ôn ha'ngui dèh ta gèq bùa, trùh con calô ramua da mangai patìh 'nang pêh 'mau, wa rìm toq con calô ramua da 'bài ngè aban. ");
INSERT INTO hre_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Èh jàp ca gùng Aicàp jah i bàu cachech ta-oih ta-ùang ta-èp dìq jaq 'nhòq lah i wa ji ùh jò leq i tìah 'màng aih hòm. ");
INSERT INTO hre_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mahaq jàp ta gùng jàn Is-ra-ên, bàu coq co ji ùh i, waq ca pì loq Chuaq lah crài jàn Is-ra-ên wa mangai Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Jò dìq cwan da bùa jah loh jang au, bla-op jang ngìa au rai doi: Ìh wa jàn ma tiaq ìh drah loh lam beq, khoi èh au men loh lam.” Môise wia khoi ca Pha-ra-ôn rai nòih dìq jaq. ");
INSERT INTO hre_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Chuaq doi ca Môise: “Pha-ra-ôn ùh tamàng bàu ìh đòh, waq ca 'bài teo halac Au bàc tam ta gùng Aicàp.” ");
INSERT INTO hre_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Môise wa Arôn broq teo halac aih jang ngìa Pha-ra-ôn, mahaq Chuaq broq ca Pha-ra-ôn cadoq manoh, dài haq ùh ca'naih jàn Is-ra-ên lam khoi gùng haq. ");
INSERT INTO hre_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ŏi ta gùng Aicàp, Chuaq doi ca Môise wa Arôn. ");
INSERT INTO hre_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Khê cô pajaq broq khê baxèm am ca pì, aih khê mòiq ta rìm hanam. ");
INSERT INTO hre_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Doi ca dìq dŏng jàn Is-ra-ên beq, trùh hì 10, khê cô, rìm gu calô ep rùp mòiq trìu con am dèh cadraq cla, rìm cadraq mòiq cadraq mòiq toq con trìu con. ");
INSERT INTO hre_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tàng mòiq cadraq caq ùh dìq mòiq toq trìu, 'màng aih phai caq pajùm ti mòiq cadraq haten hatìa, đòiq rìm ngai caq bu tôm. ");
INSERT INTO hre_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Pì phai rùp mòiq toq trìu calô loq bubi calô, bu jah mòiq hanam, ùh i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Khoi èh, đòiq gòm trùh hì 14, khê cô, rìm tang cadraq ta jàn Is-ra-ên hi pàc bubi loq trìu ca dađeh jò xèq dradrìch. ");
INSERT INTO hre_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wì haq phai yŏc mahem xùt ta radua 'mang enh 'nhèq wa baiq apah pòng 'mang hnem leq ma wì caq. ");
INSERT INTO hre_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mang aih wì caq jam trìu bùh ta ùnh, 'benh ùh tah blo wa cachiq xang. ");
INSERT INTO hre_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Apaq caq jam 'ne chìn 'ne adrìh loq jam lùac ta diac, mahaq ep phiang ta ùnh pajùm gàu, jènh tì, cliac clèm. ");
INSERT INTO hre_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Pì apaq đòiq i rah trùh hì atìq, tàng ŏi i, pì ep bùh đac. ");
INSERT INTO hre_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Caq jam aih ep 'màng cô: Caxi ca'nam càt, jènh tŏc jai, tì cadop long canhra, caq dahôiq, aih Lè Lam Cwa da Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Mang aih, Au jah lam cwa gùng Aicàp jêh đac dìq 'bài con ramua mangai Aicàp, enh con mangai trùh ngè aban. Au jah hadrah 'bài can kiac da gùng Aicàp. Au cô Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mahem xùt ti hnem pì jah broq teo pachì, jò Au baxa gùng Aicàp hi hnoq mahem aih, Au jah lam cwa, ùh hìaq i bìac 'mèq jêh đac dŏng pì. ");
INSERT INTO hre_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Pì yŏc hì aih đòiq hmàng hlài beq, wèq lè aih ca Chuaq cwa hloi rìm 'nhòng beq. Aih ranenh hloi hloi Au thê pì wèq tiaq. ");
INSERT INTO hre_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ta tapèh hì ep caq 'benh ùh tah blo. Bu trùh hì mòiq, thê pì cađac dŏng blo beq. Ma jah 'màng aih, tàng cabô caq 'benh i blo enh hì mòiq trùh hì tapèh, haq 'bìq hnan đac khoi ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Hì mòiq, jah i mòiq bìac tagop hadròih, cwa hì tapèh pì hadai jah i mòiq bìac tagop hadròih hòm. Ta hì aih ùh khòh abroq, toq padon dahwèq caq ca rìm ngai jah acaq raq. ");
INSERT INTO hre_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Pì hadai phai wèq Lè Caq 'Benh Ùh Tah Blo, ma jah 'màng aih, hì aih raq Au 'nong pì mangai bàc loh khoi Diac Aicàp. 'Màng aih, cwa rìm 'nhòng, ep wèq hì aih taiq aih ranenh hloi hloi Au thê pì wèq tiaq. ");
INSERT INTO hre_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Enh hì 14, khê mòiq, trùh jò chìu xèq hì 21, khê aih, pì phai caq 'benh ùh tah blo. ");
INSERT INTO hre_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ta tapèh hì aih ùh khòh i blo ŏi ta hnem pì, ma jah 'màng aih 'nhac ca mangai jàn 'noiq loq mangai Is-ra-ên, tàng cabô leq i caq 'benh i blo, jah 'bìq hnan đac loh khoi ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Apaq caq 'benh i blo. Rìm nòi ŏi ta pì ep caq 'benh ùh i ca blo.” ");
INSERT INTO hre_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","'Màng aih Môise tagop hlài 'bài gu craq broq gàu Is-ra-ên, doi ca wì: “Rùp mòiq toq trìu ta calùh da rìm hnem pì beq, èh pàc haq broq Lè Lam Cwa. ");
INSERT INTO hre_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Hi khoi yŏc long cachiq xônh chùq ta dòt mahem, xùt ta radua 'mang enh 'nhèq wa baiq apah pòng 'mang beq. Khoi èh dìq ca pì ùh jah i mangai leq loh khoi enh gùng ca 'mang cla trùh daxroq. ");
INSERT INTO hre_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Chuaq jah lam cwa đòiq jêh đac mangai Aicàp. Jò Haq hnoq mahem nòi radua 'mang, Haq lam cwa, ùh thê haq ma jêh đac mùt hnem pì đòiq jêh đac. ");
INSERT INTO hre_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Phai wèq Lè Lam Cwa cô tìah ca ranenh broq loh hloi hloi am ca con xau pì. ");
INSERT INTO hre_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Jò pì mùt ta gùng Chuaq padon am, troi bàu Haq khoi doi, pì phai wèq lè cô. ");
INSERT INTO hre_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Jò con xau pì bòch: ‘Lè cô enh doi cleq?’ ");
INSERT INTO hre_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Pì phai tèu 'mang cô: ‘Aih ngè tadreo Lam Cwa da Chuaq, ma jah 'màng aih jò Haq baxa jêh đac gùng Aicàp.’ ” Haq lam cwa 'bài hnem jàn Is-ra-ên wa dèch hnem nhèn 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Jàn Is-ra-ên cùp gàu cùh waiq, hi khoi lam broq tiaq troi bàu Chuaq khoi doi ca Môise wa Arôn. ");
INSERT INTO hre_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Jò 'ne mang, Chuaq jêh đac rìm con ramua ta gùng Aicàp, enh con ramua da Pha-ra-ôn ma ha'ngui ta gèq bùa, trùh con ramua da mangai ma ŏi tù, wa dìq dŏng con ramua da ngè aban. ");
INSERT INTO hre_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","'Nang jò damang, Pha-ra-ôn wa 'bài cwan, dìq dŏng mangai jàn Aicàp cadrat yòng, i bàu cachech ta-oih ta gùng Aicàp, ma jah 'màng aih ùh i ca hnem leq ma ùh i ca mangai cachìt. ");
INSERT INTO hre_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ta mang aih, Pha-ra-ôn thê creo ca Môise wa Arôn trùh, haq doi ca wa: “Chôp wa jàn Is-ra-ên rìu beq, loh khoi ca jàn au lam patìh Chuaq troi pì khoi doi beq, ");
INSERT INTO hre_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","hadai 'nong hloi calùh 'bo wa trìu troi bàu pì khoi doi beq, wa waiq xôq ramŏt ca au dìq.” ");
INSERT INTO hre_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mangai Aicàp bahôiq jàn Is-ra-ên loh khoi gùng wì haq ma renh, ma jah 'màng aih wì haq doi: “Nhèn cachìt dŏng.” ");
INSERT INTO hre_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","'Màng aih, jàn Is-ra-ên cayôp hloi dàc wa abôq rawàt dàc ta eo, tang abôq ŏi bình đeh dàc khoi rawàt ùh i tah blo, khoi èh xùi ta plêh 'nong lam. ");
INSERT INTO hre_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Jàn Is-ra-ên khoi broq tiaq troi bàu Môise khoi tanap, xìn mangai Aicàp am ca wì haq ngè 'bac, wang wa eo. ");
INSERT INTO hre_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Chuaq broq ca jàn Is-ra-ên jah xôq jang ngìa mangai Aicàp, taiq wì haq khoi am ca jàn Is-ra-ên rìm ngè bìac ma jàn Is-ra-ên khoi bòch xìn. 'Màng aih mangai Aicàp khoi 'bìq jàn Is-ra-ên lôch yŏc bàc ngè bìac da wì haq. ");
INSERT INTO hre_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Jàn Is-ra-ên lam enh Ramse trùh Sucôt, ùh tình xam wì 'yoh, jah 600.000 toq gu calô. ");
INSERT INTO hre_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Hadai i bàc ngai jàn 'noiq lam pajùm; calùh trìu, 'bo ngè aban hadai bàc. ");
INSERT INTO hre_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Wì broq 'benh ùh tah blo xam dàc cla wì khoi wê enh gùng Aicàp, dàc ùh i tah blo, ma jah 'màng aih taiq nen wì bahôiq loh renh, wì ji ùh tem padon dahwèq caq. ");
INSERT INTO hre_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","'Màng aih, 'nhòng mangai Is-ra-ên ŏi ta Aicàp, aih 430 hanam. ");
INSERT INTO hre_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Trùh hi pulùch ca 430 hanam, èh hadai ta hì aih bàc mangai da Chuaq loh khoi gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mang aih wì ep wèq ca Chuaq, ma jah 'màng aih Haq dŏih jàn Is-ra-ên loh khoi gùng Aicàp. Dìq ca jàn Is-ra-ên ep wèq mang aih cwa dìq ca 'nhòng wì haq. ");
INSERT INTO hre_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Chuaq doi ca Môise wa Arôn: “Cô ranenh da Lè Lam Cwa. “Mangai Diac 'noiq ùh jaq caq lè aih, ");
INSERT INTO hre_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","mahaq phàn da mangai dìch, mangai 'noh 'bac rŏt hlài, pì phai broq lè cat akia ca wì haq, èh wì haq men jah caq. ");
INSERT INTO hre_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Tamoi trùh enh jàn 'noiq wa mangai abroq caq cùng hadai ùh jah caq lè. ");
INSERT INTO hre_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Lè aih khòh caq toq ta hnem raq, apaq 'nong 'noh jam enh gùng wa hadai apaq broq tagoh mòiq toq hadrang caxènh leq. ");
INSERT INTO hre_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Dìq dŏng 'bài jàn Is-ra-ên ep wèq Lè Lam Cwa. ");
INSERT INTO hre_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Jò mòiq ngai enh mangai jàn 'noiq ŏi ta hnem pì, enh wèq Lè Lam Cwa da Chuaq, rìm ngai gu calô wì haq ep chìuq broq lè cat akia, khoi èh wì haq men jah trùh haten wèq lè cô, wa jah ngan tìah ca mangai xa-ông ta pì. Mahaq tàng cabô ùh chìuq broq lè cat akia, ùh jah caq lè. ");
INSERT INTO hre_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Hadai pajùm mòiq ranenh am ca mangai xa-ông ta gùng Is-ra-ên wa mangai enh jàn 'noiq ma ŏi ta pì.” ");
INSERT INTO hre_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Dìq ca jàn Is-ra-ên broq troi bàu Chuaq khoi tanap ca Môise wa Arôn. ");
INSERT INTO hre_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Hadai ta cla hi aih, Chuaq dŏih jàn Is-ra-ên loh khoi enh Aicàp tiaq dèh mangai bàc da wì haq. ");
INSERT INTO hre_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Jàn Is-ra-ên phai ràih đòiq crài wìa hadròih am ca Au dìq ca con ramua ùh kè ca con mangai loq con ngè aban, taiq aih da Au.” ");
INSERT INTO hre_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Môise doi ca jàn Is-ra-ên: “Bahmàng hlài hì cô beq, ma jah 'màng aih, cô hì Chuaq yŏc tì i cwìang itai dŏih pì loh khoi gùng Aicàp, aih claih ca broq hapŏng. Ùh khòh caq 'benh tah blo. ");
INSERT INTO hre_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hì cô, wop jò khê Abip, pì loh lam. ");
INSERT INTO hre_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","'Màng aih jò leq Chuaq khoi 'mùt pì mùt ta taneh jàn Ca-na-an, gùng da jàn Hêtit, jàn A-mô-rit, jàn Hêwit, wa jàn Jê-bu-xit, aih gùng i bàc diac sùa wa diac xùt, gùng Haq khoi pachac ca boc yaq pì Haq am ca pì, èh pì phai hmàng broq lè cô rìm khê cô. ");
INSERT INTO hre_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ta tapèh hì oh daq phai caq 'Benh Ùh Tah Blo; Trùh hì tapèh, phai broq lè caq hiniang am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Phai caq 'Benh Ùh Tah Blo ta tapèh hì. 'Benh i blo, loq blo, ùh jah hnoq ùh kè ca nòi leq ta gùng pì. ");
INSERT INTO hre_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ta 'bài hì aih ep doi ma ro ca 'bài con calô pì: Baq broq 'màng cô, aih tiaq bìac Chuaq, Boc Plình khoi broq ca au jò loh khoi enh Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Bìac wèq lè cô tìah ca teo ŏi ta tì pì, ŏi ta ngòng pì, đòiq ranenh da Chuaq jah ŏi ta hacùng pì, taiq Chuaq khoi yŏc tì i cwìang 'nong pì loh enh Diac Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","'Màng aih pì phai hmàng wèq ranenh cô troq jò khoi pajaq, enh hanam cô trùh hanam hloi hloi oq. ");
INSERT INTO hre_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Jò Chuaq, Boc Plình khoi 'ràng pì mùt ta gùng da jàn Ca-na-an, aih nòi Haq khoi rùp bàu am ca pì wa boc yaq pì, ");
INSERT INTO hre_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","èh pì ep dèch am ca Chuaq dìq con ramua, wa con ramua 'bài ngè aban da pì, ma jah 'màng aih dìq con calô aih da Chuaq Boc Plình. ");
INSERT INTO hre_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mahaq tàng con lùa ramua, pì ep yŏc con trìu loq con bubi đòiq rŏt hlài. Tàng ùh rŏt hlài, èh phai goh ranŏng lùa aih. Phai rŏt hlài dìq ca con calô ramua da pì. ");
INSERT INTO hre_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Jò leq 'bài con calô pì loq bòch pì: ‘Lè cô enh doi cleq?’ Pì doi: ‘Chuaq khoi yŏc dèh tì i cwìang itai 'ràng nhèn loh khoi enh Aicàp claih ca bìac broq hapŏng. ");
INSERT INTO hre_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Jò bùa Pha-ra-ôn cadoq manoh ùh am nhèn loh khoi enh Diac Aicàp, Boc Plình khoi jêh đac dŏng dìq 'bài con ramua wì haq xam con ramua ngè aban da wì haq. Taiq 'màng aih hì cô au dèch am ca Chuaq, Boc Plình rìm con calô ramua ngè aban đòiq broq ngè tadreo, mahaq con calô ramua, au rŏt hlài.’ ");
INSERT INTO hre_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Aih tìah ca teo ŏi ta tì pì, ŏi ta ngòng pì đòiq bahmàng pì, Chuaq khoi yŏc dèh tì i cwìang itai 'ràng nhèn loh khoi enh Aicàp.” ");
INSERT INTO hre_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Jò bùa Pha-ra-ôn khoi đòiq ca jàn Is-ra-ên lam, Boc Plình ùh ajèn wì haq lam trong Phi-li-tin, aih trong yi haten, ma jah 'màng aih Boc Plình doi: “Yùq wì haq hnoq bìac tajêh poh, hi khoi wì haq loq crè èh tawìh hlài ta Aicàp.” ");
INSERT INTO hre_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Taiq 'màng aih Boc Plình ajèn wì lam trong ta đùng braih càn ngìa 'noh ta Diac Raxìq Gòh. Jò loh khoi enh Aicàp, jàn Is-ra-ên loh lam tìah ca cwung đôiq lam. ");
INSERT INTO hre_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Môise i wê caxènh Jôsep tiaq, ma jah 'màng aih adroi nèh Jôsep thê 'bài con jàn Is-ra-ên pachac, jò haq doi: “Au loq Boc Plình jah trùh hmàih ca pì. Pì phai 'ràng caxènh au loh khoi enh Aicàp cô oq.” ");
INSERT INTO hre_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Jò loh khoi enh Sucôt, wì haq đòiq traiq padài ta Êtam haten ca đùng braih càn. ");
INSERT INTO hre_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Chuaq lam adroi ca wì haq. Dahì Haq broq jrang yùc đòiq ajèn trong, damang Haq broq jrang ùnh đòiq xreo 'ngah; nhò 'màng aih wì haq jah lam xam dahì damang. ");
INSERT INTO hre_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Jrang yùc dahì wa jrang ùnh damang Haq ùh jò leq yŏc khoi enh ngìa ca wì jàn. ");
INSERT INTO hre_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Thê jàn Is-ra-ên tawìh hlài ngìa 'nah ta Phi-ha-hi-rôt ta'ne Mitđon wa diac raxìq, hi khoi broq traiq ta 'bò diac raxìq, jang ca Ba-an Xêphôn. ");
INSERT INTO hre_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ma jah 'màng aih Pha-ra-ôn doi: ‘Jàn Is-ra-ên khoi lac ta đùng braih càn ùh chaq hnoq trong loh.’ ");
INSERT INTO hre_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Au broq ca Pha-ra-ôn cadoq manoh, haq 'nat tiaq jàn Is-ra-ên. Mahaq Au jah padèch taiq Pha-ra-ôn wa xam 'bài lình da bùa aih. Mangai Aicàp jah loq Au joq Chuaq Boc Plình da jàn Is-ra-ên.” Hi khoi wì broq tiaq troq 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Jò hìa tìn jàn Is-ra-ên khoi loh lam, bùa Pha-ra-ôn wa 'bài lình haq blòq hlài manoh ca jàn Is-ra-ên. Wì haq doi ca dabau: “Gleq bèn ma awàt đòiq ca 'bài mangai broq hapŏng ca bèn cô loh lam?” ");
INSERT INTO hre_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pha-ra-ôn drah tŏc ta xê ajèn cwung đôiq loh lam. ");
INSERT INTO hre_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Bùa wê 600 xê axêh tajêh ma yi hagao dìq jaq da Aicàp, wa rìm toq xê i mòiq toq cwan ma wèq. ");
INSERT INTO hre_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Chuaq Boc Plình broq ca Pha-ra-ôn bùa Aicàp cadoq manoh 'nat tiaq jàn Is-ra-ên mahaq jàn cô xôq loh lam tiaq manoh tanuq. ");
INSERT INTO hre_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Mangai Aicàp wa axêh, xê axêh, xam cwung đôiq da Pha-ra-ôn 'nat tiaq, tem jàn Is-ra-ên jò wì haq 'nang ŏi ta traiq ti braih diac raxìq, hatenh ca Phi-ha-hi-rôt ta jang ca Ba-an Xêphôn. ");
INSERT INTO hre_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Jò Pha-ra-ôn trùh haten, jàn Is-ra-ên ngan hnoq lình Aicàp 'nat tiaq trùh, wì haq yùq crè dìq jaq, dang creo ca Chuaq Boc Plình. ");
INSERT INTO hre_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Wì haq doi ca Môise: “Ŏi ta Aicàp ùh tôm ralùng 'mòh ìh ma 'ràng nhèn mùt cachìt ta đùng braih càn cô. Ìh 'nong dèh ca nhèn loh enh Aicàp? ");
INSERT INTO hre_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Jò ŏi ta Aicàp nhèn ji khoi doi adroi ca ìh, đòiq nhèn ŏi ta Aicàp broq hapŏng yi hnao ca 'nong nhèn lam cachìt ta đùng braih càn cô.” ");
INSERT INTO hre_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mahaq Môise doi ca wì haq: “Apaq yùq, cajap manoh beq, gòm ngan bìac dèch claih trùh enh Chuaq broq ca pì hì cô. 'Bài mangai Aicàp oh daq ma hnoq hì cô, pàng cô èh pi jah hnoq wì haq hòm. ");
INSERT INTO hre_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Chuaq tajêh poh am ca pì, cla pì ŏi ma hatenh beq.” ");
INSERT INTO hre_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Chuaq doi ca Môise: “Gleq ìh ma creo ca Au? Doi ca jàn Is-ra-ên lam beq. ");
INSERT INTO hre_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Mahaq ìh phai dèch long canhra 'mat ti 'nhèq diac raxìq beq, èh diac raxìq jah wah loh baiq, wìa trong ca jàn Is-ra-ên lam cwa tìah ca lam ta taneh croh. ");
INSERT INTO hre_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Au jah broq ca jàn Aicàp cadoq manoh 'nat tiaq jàn Is-ra-ên loh ta diac raxìq. Au jah padèch ha'nhèq taiq Pha-ra-ôn, cwung đôiq haq, xê axêh wa lình axêh da haq. ");
INSERT INTO hre_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Jò Au khoi jah padèch ha'nhèq taiq Pha-ra-ôn, xê axêh wa lình axêh da haq, èh mangai Aicàp jah loq Au cô raq Chuaq Boc Plình.” ");
INSERT INTO hre_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","'Bình Plình da Boc Plình ma lam adroi ca jàn Is-ra-ên, loh lam enh cloh wì, èh jrang ùnh lam adroi hadai lam enh cloh. ");
INSERT INTO hre_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","'Màng aih, jrang ùnh yòng ta'ne jàn Is-ra-ên wa lình Aicàp mang aih. Jrang ùnh broq ca mangai Aicàp loh ca clam clôiq, mahaq xreo 'ngah ca jàn Is-ra-ên, taiq 'màng aih wa cô ùh jah trùh haten ca dabau. ");
INSERT INTO hre_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Môise dèch tì hnhu ti 'nhèq diac raxìq, wa Chuaq broq cayeo enh pah mahì loh hlôi dêh 'ngah ca mang aih, acom hlài diac raxìq ŏi tang pah, pèh trong ca jàn Is-ra-ên lam cwa diac raxìq tìah ca lam ta taneh croh. ");
INSERT INTO hre_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","'Màng aih jàn Is-ra-ên lam cwa diac raxìq ta taneh croh wa diac khoi lah baiq toq panàt baiq pah, pah 'ngeo wa pah 'ma wì haq. ");
INSERT INTO hre_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Mangai Aicàp hnan tiaq, èh dìq dŏng axêh Pha-ra-ôn, xê axêh wa lình axêh, dìq hnan tiaq jàn Is-ra-ên loh ta diac raxìq. ");
INSERT INTO hre_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Jò xrŏih xroq, enh jrang ùnh wa jrang yùc, Chuaq ngan hnoq cwung đôiq Pha-ra-ôn, Haq hi broq ca wì loh ca manhài. ");
INSERT INTO hre_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Haq dŏih da wì blênh xê, broq ca wì wèq dèh xê dìq jaq xalep. 'Bài mangai Aicàp doi ca dabau: “Bèn khòh wia hangai ca jàn Is-ra-ên renh haq, ma jah 'màng aih Chuaq Boc Plình thai ca jàn Is-ra-ên tajêh ca bèn.” ");
INSERT INTO hre_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Chuaq doi ca Môise: “Dèch tì hnhu ti 'nhèq diac raxìq 'mat beq, đòiq diac taclìh hlài glàp đac dìq mangai Aicàp xam xê axêh wa dìq ca lình axêh wì haq.” ");
INSERT INTO hre_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Xrŏih xroq Môise dèch tì hnhu ti 'nhèq diac raxìq, diac loh hlài tìah ca dùnh. Mangai Aicàp ran cadàu mahaq ùh tem, ma jah 'màng aih Chuaq broq ca wì haq cram dŏng ta diac raxìq. ");
INSERT INTO hre_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Diac pacram dŏng dìq xê axêh, lình axêh wa dìq dŏng cwung đôiq Aicàp. Ùh i ca mòiq ngai leq ta wì ŏi rìh. ");
INSERT INTO hre_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mahaq jàn Is-ra-ên lam ta taneh croh cwa diac raxìq. Diac raxìq yòng tìah ca baiq pah panàt, pah 'ngeo wa pah 'ma ta wì haq. ");
INSERT INTO hre_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ta hì aih Chuaq dèch jàn Is-ra-ên claih ca mangai Aicàp. Wì haq hnoq hanang mangai Aicàp ta 'bò diac raxìq. ");
INSERT INTO hre_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Jàn Is-ra-ên hnoq bìac Chuaq khoi broq ca mangai Aicàp. Wì haq dìq jaq yùq crè ca Chuaq wa lùi Chuaq wa Môise hapŏng Haq. ");
INSERT INTO hre_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Khoi èh Môise wa jàn Is-ra-ên calêu 'bŏi calêu ca Chuaq 'màng cô: “Au calêu padèch Chuaq, ma jah 'màng aih Haq dìq jaq 'ngah ngai rahù rahình. Haq khoi hwenh ca'nìh đac axêh wa mangai còi axêh ta diac raxìq. ");
INSERT INTO hre_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Chuaq padren dêh wa bìac calêu padèch da Au. Haq khoi wìa bìac dèch claih au. Haq Boc Plình au, au manè pôi Haq, Boc Plình da boc yaq au, au iu padèch Haq. ");
INSERT INTO hre_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Chuaq Haq Lình Tajêh Poh, hiniq Haq Jê-hô-wa aih Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Haq khoi hwenh ca'nìh đac xê axêh wa dìq ca cwung đôiq da Pha-ra-ôn ta diac raxìq, 'bài cwan wèq lình da haq khoi cram ta Diac Raxìq Gòh. ");
INSERT INTO hre_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Diac jrùq khoi glàp wì haq, Wì cram trùh driah diac raxìq tìah ca hmu. ");
INSERT INTO hre_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ôi Chuaq, tì 'ma Ìh i padren dêh 'ngah ngai. Ôi Chuaq tì 'ma Ìh ta'blêq wa bahech đac lình ma tagit. ");
INSERT INTO hre_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Xam dìq ca cwìang itai rahù rahình Ìh jêh cađac mangai ma yòng tajraq hlài ca Ìh. Can nòih da Ìh cheo wì tìah ca hri. ");
INSERT INTO hre_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Mùh Ìh hihèm loh, diac acom hlài, diac lai laq yòng tìah ca panàt, pah baiq nòi jrùq 'ne diac raxìq. ");
INSERT INTO hre_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mangai tagit doi: ‘Au hnan tiaq, au hnan tem, au jah axong cùng hang, manoh au jah da-òih nòi wì haq, au dèch chang gùm, tì au jêh đac wì haq.’ ");
INSERT INTO hre_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ìh khoi hlôi xam cayeo Ìh, diac raxìq glàp đac wì haq. Wì haq cram tìah ca cato tanàm nòi driah diac jrùq. ");
INSERT INTO hre_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ôi Chuaq, ta'ne dìq ca 'bài yiang, ma leq tìah ca Ìh? Ta bìac hliang hadròih, cabô jah 'ngah ngai troi Ìh, đang ca crè, đang ca manè, broq bàc teo halac? ");
INSERT INTO hre_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“Ìh khoi hnhu tì 'ma loh, taneh khoi lŏn wì. ");
INSERT INTO hre_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ìh yŏc can xa-ŏch xam manoh loq waq ajèn jàn cô ma Ìh khoi rŏt hlài. Ìh khoi yŏc padren itai 'ràng wì hlài ŏi nòi hadròih da Ìh. ");
INSERT INTO hre_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","'Bài tamoi ta crŏng taneh, tàng bìac cô crè tarìt. Can crè wa mango jah rùp manoh jàn gùng Phi-li-tin. ");
INSERT INTO hre_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Èh 'bài craq broq gàu da gùng Êđôm lèt yùq. 'Bài mangai tanuq da gùng Moap i can crè crep rùp manoh wì. Dìq ca jàn Ca-na-an crè pi i 'mòi ca mahua. ");
INSERT INTO hre_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bìac yùq crè hlè lèt trùh ca wì haq. Nho tì can dêh da Ìh wì haq wìa tìah ca hmu ùh tabroq, trùh jò leq jàn Ìh lam cwa, Ô Chuaq, trùh jò leq jàn Ìh lam cwa, wì ma Ìh khoi rŏt hlài. ");
INSERT INTO hre_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ôi Chuaq, Ìh 'ràng jàn aih mùt, wa broq nòi wang xôxech da Ìh, aih nòi Ìh khoi padon đòiq, đòiq broq nòi ŏi da Ìh, Ôi Chuaq, Hnem Cùh Waiq Hadròih, tì Ìh ma broq loh. ");
INSERT INTO hre_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Chuaq jah wèq cwìang hloi hloi rìm 'nhòng.” ");
INSERT INTO hre_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ma jah 'màng aih axêh da Pha-ra-ôn, xê axêh wa lình axêh haq khoi loh ta diac raxìq, èh Chuaq khoi bùn diac enh 'nhèq ca wì haq, mahaq jàn Is-ra-ên lam ta'ne diac tìah ca lam ta taneh croh. ");
INSERT INTO hre_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Mi-ri-am, daq Arôn, mangai cadrì capoch thai Boc Plình, wê raxap xam tì, wa 'bài gu cadrì hadai wê raxap loh lam tiaq haq, rai muaq. ");
INSERT INTO hre_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mi-ri-am tèu hlài: “Calêu manè Chuaq beq, ma jah 'màng aih Haq 'ngah ngai rahù rahình hrìn. Haq khoi hwenh ca'nìh đac axêh wa mangai còi axêh.” ");
INSERT INTO hre_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Khoi èh, Môise 'nong jàn Is-ra-ên lam khoi ca Diac Raxìq Gòh, trùh nòi braih càn Sura. Wì lam piq hì ta braih càn, chaq ùh i diac ôq. ");
INSERT INTO hre_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Jò trùh Mara, wì ùh jah ôq diac ta aih taiq diac aih xang. Taiq 'màng aih wì creo nòi cô Mara, i hiniq xang. ");
INSERT INTO hre_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Jàn Is-ra-ên mamùc ca Môise: “Nhèn yŏc cleq ôq cô?” ");
INSERT INTO hre_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Môise creo dang Chuaq. Haq patô am ca Môise mòiq toq long. Môise yŏc hwenh ca'nìh ta diac wa diac loh ca nhim. 'Màng aih ŏi ta nòi aih, Chuaq broq mòiq trong ranenh ca wì ta aih nòi Haq 'bàt thù jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Tàng pì panim ca tàng bàu Chuaq, Boc Plình pì, broq bìac jang lem enh ngìa Au, halang don tamàng bàu thê wa wèq rìm trong ranenh Au, èh Au ùh hìaq ca'nìh ca pì hinìq ùh hrŏc leq ma Au khoi ca'nìh ca jàn Aicàp. Ma jah 'màng aih Au Chuaq ma jah broq brêh can ùh hrŏc pì.” ");
INSERT INTO hre_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Khoi èh jàn Is-ra-ên lam trùh ta Êlim, nòi ma i 12 toq diac tamŏc wa 70 toq long rêq. Jàn Is-ra-ên đòiq traiq ta aih haten roc kenh diac. ");
INSERT INTO hre_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Wop hì 15, khê baiq, atìq ca wì loh khoi ca gùng Aicàp, dìq ca jàn Is-ra-ên ŏi nòi Êlim lam trùh ta braih càn Sin ŏi ta'ne Êlim wa Sinai. ");
INSERT INTO hre_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Dìq ca jàn Is-ra-ên mamùc ca Môise wa Arôn ta nòi braih càn. ");
INSERT INTO hre_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Wì doi ca wa: “Ôi, thai đòiq ca nhèn cachìt ta tì Chuaq ta gùng Aicàp, jò ŏi ha'ngui jang gŏc jam 'benh panàc panìa, yi hnao chôp 'nong nhèn mùt nòi braih càn cô đòiq broq dìq ca jàn cô cachìt ca hrah.” ");
INSERT INTO hre_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Chuaq doi ca Môise: “Cô, Au ŏi enh plình ha'nhèq broq mè 'benh ca'nìh ca pì, 'bài jàn jah loh yŏc, hì leq tàu dèh ca hì aih, đòiq Au ngan thù wì haq i lam tiaq ranenh da Au loq ùh? ");
INSERT INTO hre_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Hì tadràu 'bài jàn jah tŏch yŏc baiq phàn ma wì tŏch yŏc tàng hì.” ");
INSERT INTO hre_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Môise wa Arôn doi ca jàn Is-ra-ên: “Chìu hì cô pì jah loq Chuaq khoi dèch pì loh khoi gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Xroq èh pì jah hnoq can 'ngah ngai da Chuaq. Ma jah 'màng aih Haq khoi tàng bàu pì mamùc ca Haq. Èh nhèn cabô ma pì mamùc ca nhèn?” ");
INSERT INTO hre_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Môise doi: “Chìu hì cô Chuaq jah 'noh am ca pì jam caq, hi khoi xroq èh i 'benh bàc i rah, ma jah 'màng aih Haq khoi tàng bàu pì mamùc ca Haq. Nhèn cabô? Bàu mamùc pì ùh xài tajraq ca nhèn, mahaq tajraq ta Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Môise doi ca Arôn: “Anoi padìq ca mangai Is-ra-ên beq: Pì lam trùh jang ngìa Chuaq, taiq Haq khoi tàng bàu mamùc da pì.” ");
INSERT INTO hre_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Jò Arôn yòng anoi ca mangai Is-ra-ên, èh wì haq wìh ngan pah braih càn, cô, wì hnoq can 'ngah ngai da Chuaq trùh ŏi ta yùc. ");
INSERT INTO hre_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Au khoi tàng bàu mamùc ta jàn Is-ra-ên. 'Màng aih, ìh doi ca wì haq beq: Jò xèq dradrìch pì caq jam, xroq èh pì caq 'benh panàc, èh jah loq ca Au Chuaq, Boc Plình da pì.” ");
INSERT INTO hre_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Trùh chìu, i chìm brŏch pan tŏc jràp xìa dìq ca nòi i traiq wì haq. Trùh xroq èh i mòiq lòp diac ngom ŏi dudan ca traiq wì. ");
INSERT INTO hre_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Jò lòp rangom aih hech, enh 'nhèq ca braih i ngè cleq 'yoh, tìah ca pliang adrech 'yêq ŏi enh 'nhèq ca taneh. ");
INSERT INTO hre_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Jò jàn Is-ra-ên hnoq, wì bòch dabau: “Cleq cô?” Ma jah 'màng aih wì ùh 'nì ca ngè aih cah cleq? Môise doi ca wì: “ 'Mat 'benh Chuaq am ca pì caq. ");
INSERT INTO hre_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Cô bàu Chuaq khoi doi: ‘Tiaq padren acaq da tang ngai wa tiaq jaq mangai bàc biaq ŏi ta traiq, èh gop ca mòiq ngai baiq lìt.’ ” ");
INSERT INTO hre_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Jàn Is-ra-ên broq tiaq 'màng aih, i ngai tŏch bàc, i ngai tŏch biaq. ");
INSERT INTO hre_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Wêh tiaq jaq ôme, cabô tŏch bàc ùh i rah, cabô tŏch biaq ji ùh jah thìuq, rìm ngai tŏch bu tàu dèh ca padren acaq. ");
INSERT INTO hre_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Môise doi ca 'bài jàn: “Apaq i cabô leq đòiq rah trùh xroq èh.” ");
INSERT INTO hre_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mahaq jàn ùh dì tiaq bàu Môise. I 'nah ngai đòiq rah trùh xroq èh, èh hrai ŏi enh dalam, ngè aih loh ca xua om. Môise nòih ca wì haq. ");
INSERT INTO hre_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","'Màng aih rìm xrŏih xroq rìm ngai tŏch bu tàu dèh ca padren caq. Jò mat mahì tôq, èh ngè aih loh ca hech đac. ");
INSERT INTO hre_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Trùh hì tadràu, 'bài jàn tŏch dahwèq caq baiq phàn, mòiq ngai pôn lìt. 'Bài mangai broq gàu tagop thia anoi hlài ca Môise loq. ");
INSERT INTO hre_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Môise doi: “Aih bàu Chuaq khoi doi: ‘Hì da èh aih hì padài, aih Hì Sabat hadròih am ca Chuaq. Phiang ngè caq ma leq pì ma enh, phiang beq. Pai ngè caq ma leq pì ma enh, pai beq. Tàng ŏi i rah, pì đòiq trùh xroq èh beq.’ ” ");
INSERT INTO hre_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","'Bài jàn ma đòiq trùh xroq èh, tìah troi bàu Môise khoi thê, ngè aih ùh om, ji ùh loh hrai toq xìt leq. ");
INSERT INTO hre_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","“Hì cô caq ngè 'mat beq, ma jah 'màng aih hì cô Hì Sabat da Chuaq, hì cô pì chaq ùh hnoq ngè aih ta đùng. ");
INSERT INTO hre_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Pì tŏch trom tadràu hì, mahaq ta Hì Tapèh aih Hì Sabat, ngè aih ùh loh.” ");
INSERT INTO hre_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Hì Tapèh, 'nah ngai ta jàn Is-ra-ên loh đòiq tŏch, mahaq chaq ùh hnoq cleq? ");
INSERT INTO hre_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Chuaq doi ca Môise: “Pì ùh waq wèq bàu thê wa bàu tanap da Au trùh pàng leq èh? ");
INSERT INTO hre_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Hèm beq, Chuaq khoi am ca pì Hì Sabat. Taiq 'mang aih hì ma tadràu Haq am ca pì 'benh tàu caq baiq hì. Hì tapèh rìm ngai ep ŏi ta hnem ùh jah abroq, ùh jah i cabô loh khoi ca hnem.” ");
INSERT INTO hre_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","'Màng aih èh, Hì Tapèh jàn Is-ra-ên padài dìq. ");
INSERT INTO hre_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Mangai Is-ra-ên hiniq ca ngè caq cô Mana, aih tìah ca clong plì ngò, taboc, nhim tìah ca 'benh alôn diac xùt. ");
INSERT INTO hre_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Môise doi: “Bàu Chuaq khoi thê 'màng cô: Yŏc baiq lìt Mana beq, đòiq hlài 'nhòng ma atìq, đòiq wì jah hnoq 'benh Au khoi am ca pì nòi braih càn jò Au 'nong pì loh khoi ca gùng Aicàp.” ");
INSERT INTO hre_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Môise doi hlài ca Arôn: “Yŏc mòiq toq abôq ùc bình baiq lìt Mana, đòiq jang ngìa Chuaq, đòiq hlài dìq ca 'nhòng pì.” ");
INSERT INTO hre_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Arôn broq troq tiaq bàu Chuaq khoi thê Môise. 'Màng aih, abôq Mana wìa bìac patô èh tah ta hòm wêh jao. ");
INSERT INTO hre_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Jàn Is-ra-ên caq Mana ta 40 hanam, trùh jò mùt ta acang gùng Ca-na-an, aih gùng wì 'noiq ŏi. ");
INSERT INTO hre_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ôme aih mòiq phàn mòiq jàt da êpha. ");
INSERT INTO hre_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Dìq ca 'bài jàn Is-ra-ên lam enh braih càn Sin, lam tang apŏt trong tiaq bàu Chuaq thê, đòiq traiq ta Rê-phi-đim. Ŏi ta aih ùh i ca diac ôq. ");
INSERT INTO hre_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Jàn Is-ra-ên rahen ca Môise: “Am ca nhèn diac ôq beq.” Môise tèu: “Gleq pì ma thù Chuaq?” ");
INSERT INTO hre_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Jàn ŏi ta aih ùh i ca diac ôq, wì croh ranŏng. Wì mamùc ca Môise: “Gleq ìh ma broq nhèn loh khoi enh Aicàp waq ca nhèn, con nhèn wa calùh ngè aban nhèn, ep cachìt ca croh ranŏng ta cô?” ");
INSERT INTO hre_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Môise waiq dang Chuaq, doi: “Au phai broq ca jàn cô 'màng leq? Ùh troq èh wì yŏc hmu tèm đac au.” ");
INSERT INTO hre_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Chuaq doi ca Môise: “Wê long canhra ìh ma khoi blai diac aih wa 'nong 'bài gu craq Is-ra-ên, hi khoi lam enh ngìa 'bài jàn. ");
INSERT INTO hre_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Cô, Au yòng jang ngìa ìh ŏi enh 'nhèq ca bôi hmu ta Hôrêp tau. Ìh blai hmu beq, èh loh diac enh aih, wì jah ôq.” Môise broq 'màng aih jang ngìa 'bài gu craq broq gàu Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Môise hiniq ca nòi cô Masa wa Mê-ri-ba, taiq nen bìac tarahen jàn Is-ra-ên chaq nen bìac ca haq wa taiq wì khoi thù Chuaq, wì doi: “Chuaq ŏi ta'ne nhèn loq ùh?” ");
INSERT INTO hre_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Jò aih, jàn A-ma-lec trùh tabroq ca Is-ra-ên ŏi ta Rê-phi-đim. ");
INSERT INTO hre_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Môise doi ca Jôsuê: “Ràih yŏc lình hagao ta jàn bèn, loh tajêh ca jàn A-ma-lec beq. Hì da èh au yòng nòi bôi wang, cadop long canhra da Boc Plình ta tì.” ");
INSERT INTO hre_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Jôsuê broq tiaq troi bàu Môise doi, lam tajêh ca jàn A-ma-lec. Phàn da Môise, Arôn wa Hurò tŏc enh 'nhèq ca bôi wang. ");
INSERT INTO hre_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","'Màng cô, jò Môise dèch tì tŏc, èh jàn Is-ra-ên ji dêh, mahaq jò haq tagah cŏng tì haq 'nhùa ha'neq, jàn A-ma-lec ji dêh. ");
INSERT INTO hre_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Jò tì Môise tagah, Arôn wa Hurò yŏc hmu ca haq ha'ngui, hi khoi wa yòng baiq pah dèch atŏc tì haq, tì haq pi tadroq trùh hloi jò mat mahì clìh. ");
INSERT INTO hre_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","'Màng aih, Jôsuê yŏc chang gùm ta'blêq A-ma-lec wa cwung đôiq haq. ");
INSERT INTO hre_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Chuaq doi ca Môise: “Achìh hlài bìac cô 'mùt ta sech đòiq bahmàng hlài wa doi ca Jôsuê loq, Au xùt hreo bìac hmàng da A-ma-lec đòiq ùh hmàng hlài da haq hòm.” ");
INSERT INTO hre_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Môise broq mòiq toq ca'bŏng tadreo, hiniq ca ca'bŏng aih: “Chuaq, Haq Cò Ta'blêq da Au.” ");
INSERT INTO hre_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Haq rai doi: “Ma jah 'màng aih Chuaq pachac, Haq tajêh ca A-ma-lec enh 'nhòng cô cwa 'nhòng tau.” ");
INSERT INTO hre_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jêtrô, pajàu craq gùng Ma-đi-an, baq mai da Môise, hìa loq rìm bìac Boc Plình khoi broq am ca Môise wa jàn Is-ra-ên, jàn Chuaq khoi 'nong loh khoi gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Adroi cô nèh Môise khoi thê mai haq, Xi-po-rah wa baiq toq con calô hlài ŏi ta Jêtrô baq dèh mai. ");
INSERT INTO hre_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Hiniq con calô ramua da Môise, aih Getsôn, taiq jò xa-ông con aih, Môise khoi doi: “Au khoi wìa mangai tamoi ŏi ta gùng jàn 'noiq.” ");
INSERT INTO hre_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Hiniq con calô hatìa, aih Ê-li-ê-se, taiq jò xa-ông con aih, Môise khoi doi: “Boc Plình da boc yaq au khoi jùp đò wa dŏih dèch au claih ca chang gùm da Pha-ra-ôn.” ");
INSERT INTO hre_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Manàiq cô Jêtrô baq mai da Môise, lam ti baiq ngai con calô wa mai Môise trùh hmàih ca Môise ta braih càn, nòi wì haq đòiq traiq haten ca wang Boc Plình. ");
INSERT INTO hre_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jêtrô thê wì trùh anoi ca Môise: “Au Jêtrô baq mai ìh wa baiq toq con calô ìh trùh hmàih ca ìh.” ");
INSERT INTO hre_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Môise loh đìh yŏc dèh baq mai, cùp gàu hìp haq, bòch hmàih ca dabau, hi khoi mùt ta traiq. ");
INSERT INTO hre_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Môise ta'mon hlài dèh ca baq mai loq rìm bìac Chuaq broq am ca Is-ra-ên, 'màng leq Haq khoi broq ca Pha-ra-ôn wa mangai Aicàp, wa rìm bìac nan xa khoi loh ca wì roc trong, wa 'màng leq Chuaq khoi dŏih dèch wì haq. ");
INSERT INTO hre_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jêtrô lem bùi ca rìm bìac lem ma Chuaq khoi broq am ca Is-ra-ên, dŏih dèch jàn aih claih enh tì mangai Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jêtrô doi: “Đang ca manè padèch Chuaq ma khoi dŏih dèch pì claih enh tì mangai Aicàp wa tì Pha-ra-ôn, dŏih dèch jàn Is-ra-ên claih khoi ca cwìang mangai Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Manàiq cô au khoi loq Chuaq yi càn dŏng ca 'bài can kiac, ma jah 'màng aih jò mangai Aicàp canòm dèh manoh catèh yòng tajraq, èh Chuaq khoi ta'blêq ca wì.” ");
INSERT INTO hre_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jêtrô baq mai Môise, broq mòiq ngè tadreo bùh wa 'bài ngè tadreo am ca Boc Plình, hi khoi Arôn wa 'bài gu craq broq gàu da Is-ra-ên trùh caq 'benh ti baq mai Môise, jang ngìa Boc Plình. ");
INSERT INTO hre_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Hì atìq, Môise loh ha'ngui hadrah jàn. Jàn yòng gòm dudan ca haq enh xroq trùh chìu. ");
INSERT INTO hre_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Jò Jêtrô hnoq rìm bìac Môise broq ca jàn, haq bòch: “Gleq con ma broq ca jàn 'màng 'mat? Ìh ha'ngui wa dìq ca jàn yòng dudan ca ìh enh xroq trùh chìu 'màng 'mat?” ");
INSERT INTO hre_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Môise padreo bàu tèu: “Aih taiq jàn trùh ta au đòiq bòch manoh enh da Boc Plình. ");
INSERT INTO hre_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Jò leq wì haq i bìac tablah, èh trùh ti au, au hadrah mangai cô wa mangai tau, wa am ca wì haq bàu thê wa ranenh Boc Plình.” ");
INSERT INTO hre_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Baq Môise doi hòm: “Bìac ìh broq 'màng 'mat ùh lem. ");
INSERT INTO hre_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Joq 'nàng, ìh wa jàn ma ŏi ti ìh jah tagah lep, ma jah 'màng aih bìac aih trap yi hnao ca padren ìh, mòiq ngai pòq ùh nui. ");
INSERT INTO hre_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Manàiq cô, tamàng au pariaq ìh mòiq nà oq. Waiq xìn Chuaq ŏi ti ìh. Phàn ìh, broq mangai thai ca jàn jang ngìa Boc Plình, wa anoi 'noh dŏng rìm bìac am ca Boc Plình loq. ");
INSERT INTO hre_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Yŏc bàu thê wa ranenh Au hnài wì beq, patô ca wì loq trong leq ep lam wa bìac leq ep broq. ");
INSERT INTO hre_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ìh hadai phai ràih yŏc 'bài mangai i dua loq ŏi ta jàn beq, wì ma loq crè ca Boc Plình wa i manoh joq 'nàng git ca bìac ham cùng hang, khoi èh dèch wì tŏc broq gàu wèq cwìang lù 1.000, 100 ngai, 50 ngai wa 10 ngai. ");
INSERT INTO hre_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Đòiq wì hadrah jàn tang hì. Tàng i bìac hadrah xa wa càn, wì hi atŏc ca ìh, phàn bìac ma 'yoh, đòiq wì haq raq hadrah. Lah 'noh waq ca hèo, đòiq wì haq jah wiang genh ca ìh. ");
INSERT INTO hre_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Tàng ìh broq bìac cô, wa Boc Plình am bàu thê ca ìh, èh ìh men jah chìuq nui, wa dìq ca jàn cô jah trùh nòi cla wì catèm.” ");
INSERT INTO hre_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Môise iu tiaq dèh bàu baq mai, broq tiaq rìm bìac haq khoi pariaq hnài. ");
INSERT INTO hre_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","'Màng aih, Môise ràih ta jàn Is-ra-ên, 'bài mangai rabiaq am wì haq yòng pagàu ta jàn, broq gàu, wèq cwìang lù 1.000, 100 ngai, 50 ngai wa 10 ngai. ");
INSERT INTO hre_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Wì haq hadrah jàn tang hì. Bìac ma xa wì haq atŏc ca Môise, mahaq wì haq raq hadrah bìac 'yoh. ");
INSERT INTO hre_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Khoi èh Môise đòiq dèh baq mai hlài dèh ta gùng. ");
INSERT INTO hre_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Khê ma piq, atìq ca jò loh khoi gùng Aicàp, troq hì aih, jàn Is-ra-ên trùh nòi braih càn Sinai. ");
INSERT INTO hre_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Jò wì loh lam enh Rê-phi-đim trùh nòi braih càn Sinai, đòiq traiq ta aih ngìa ta jang ca wang. ");
INSERT INTO hre_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Môise tŏc trùh Boc Plình, hi khoi Chuaq ŏi ta bôi wang creo doi ca haq: “Anoi ca cadraq Jacôp, aih jàn Is-ra-ên: ");
INSERT INTO hre_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Pì khoi hnoq bìac Au broq ca mangai Aicàp, wa 'màng leq Au pòq pì ta panan chìm cliang càn wa 'nong pì trùh ti Au. ");
INSERT INTO hre_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","'Màng aih, manàiq cô tàng pì iu tiaq bàu Au wa wèq bìac wêh jao da Au, èh dìq ca pì jah wìa jàn xôxech da Au ta'ne dìq ca jàn, taiq dìq ca crŏng taneh da Au. ");
INSERT INTO hre_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Pì jah wìa mòiq toq diac pajàu càn, wa mòiq toq tamoi hadròih ca Au.’ Aih bàu ma ìh jah anoi hlài ca jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","'Màng aih, Môise trùh creo ca 'bài gu craq broq gàu ta jàn, ta'mon hlài ca wì rìm bàu ma Chuaq khoi thê haq anoi hlài. ");
INSERT INTO hre_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Dìq ca jàn Is-ra-ên pajùm bàu tèu hlài: “Nhèn joq 'nàng broq rìm bìac Chuaq ma khoi tanap.” Môise ta'mon hlài bàu da jàn Is-ra-ên ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Chuaq doi ca Môise: “Cô, Au ŏi ta'ne yùc habàu lam trùh ta ìh, đòiq jò leq Au doi ca ìh, èh jàn tamàng wa lùi canòm ca ìh hloi hloi.” Môise 'ràng bàu da jàn anoi hlài ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Chuaq hadai doi ca Môise: “Lam trùh ti jàn Is-ra-ên beq, broq lè lah crài loh hadròih am ca jàn. Hì cô wa hì da èh, tanap ca wì rùh dèh eo yôh cla; ");
INSERT INTO hre_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","wa hì piq jàn khòh hachang đòiq, ma jah 'màng aih, Chuaq jah thia trùh jang ngìa jàn ta bôi wang Sinai. ");
INSERT INTO hre_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ìh phai pajaq acang ca jàn ŏi dudan ca wang, tanap wa wì: Ep wèq dađeh apaq heo tŏc ta wang, loq thia trùh jang jènh wang. Tàng mangai leq thia bèq wang jah 'bìq jêh đac. ");
INSERT INTO hre_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ùh jah i cabô leq đùng tì ta chac mangai aih, mahaq mangai aih ep 'bìq tèm đac xam hmu, loq penh xam panenh, 'nhac ca ngè aban loq mangai, ji ùh đòiq rìh. Jò leq i ken hlôi tanam tanuiq wì haq men jah lam haten wang.” ");
INSERT INTO hre_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Môise loh enh bôi wang, thia trùh ti jàn, thê wì wèq dađeh, wa rùh dèh eo cwàn cla. ");
INSERT INTO hre_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Môise tanap ca jàn: “Ta piq hì phai hamang đòiq, apaq trùh ten ca gu cadrì.” ");
INSERT INTO hre_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Daxroq hì piq, i hilùng, camlet, mòiq đam yùc habàu ŏi ta bôi wang. I bàu ken hlôi dìq jaq tanam tanuiq, dìq ca jàn ŏi ta nòi traiq tarìt tariang. ");
INSERT INTO hre_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Môise thê jàn loh khoi nòi traiq đòiq glàm Boc Plình. Jàn yòng ŏi jang ti jènh wang. ");
INSERT INTO hre_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Èh jò aih, jàp ca wang Sinai loh nhòi, ma jah 'màng aih Chuaq ŏi ta ùnh lam trùh nòi aih. Nhòi loh ùh crài cleq ca nhòi enh tanùh ùnh càn wa dìq ca wang tadroq dìq jaq. ");
INSERT INTO hre_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Jò bàu ken rai dùnh rai tanam tanuiq, Môise bòch, wa Boc Plình tèu hlài xam hilùng. ");
INSERT INTO hre_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Chuaq lam trùh ta bôi wang Sinai creo ca Môise tŏc wa Môise tŏc. ");
INSERT INTO hre_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Chuaq doi: “Loh tàt jàn, apaq am thia trùh haten ngan Chuaq beq, yùq bàc ngai ta jàn loq cachìt. ");
INSERT INTO hre_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hadai thê 'bài pajàu, jò trùh haten ca Chuaq, hadai ep lah crài dađeh loh hadròih, tàng ùh, èh yùq Chuaq jêh đac wì.” ");
INSERT INTO hre_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Môise doi ca Chuaq: “Jàn ùh jah tŏc ta wang Sinai, ma jah 'màng aih Ìh i padràng nhèn, doi: Pajaq acang dudan ca wang beq wa lah crài nòi aih loh hadròih.” ");
INSERT INTO hre_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Chuaq doi: “Loh beq, hi khoi 'nong Arôn tŏc ta ìh, mahaq 'bài pajàu wa jàn apaq thia đòiq tŏc trùh haten ca Chuaq, yùq Haq loq jêh wì.” ");
INSERT INTO hre_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","'Màng aih Môise loh doi hlài ca jàn tamàng. ");
INSERT INTO hre_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Khoi èh Boc Plình doi bàu 'màng cô: ");
INSERT INTO hre_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Au Chuaq Boc Plình da pì, khoi dèch pì khoi ca gùng Aicàp nòi pì broq hapŏng. ");
INSERT INTO hre_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Jang ngìa Au, paq cùh waiq yiang ma 'noiq. ");
INSERT INTO hre_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Pì apaq broq dua 'mù am ca cla, hadai apaq broq dua 'mù leq tìah ca 'bài ngè ŏi ta plình, loq ta nòi taneh ha'neq cô, loq ta diac enh 'neq ca taneh. ");
INSERT INTO hre_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Pì apaq hacùn cràng waiq jang ngìa 'bài dua 'mù aih, hadai ùh jah patìh bìac wì haq, ma jah 'màng aih Au Chuaq Boc Plình pì, Boc Plình loq tagrình, Au jah yŏc tôiq boc yaq baxa hlài con xau trùh piq pôn 'nhòng ca wì ma git ca Au, ");
INSERT INTO hre_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","mahaq pa'noh can xa-ŏch xam manoh loq waq trùh bình ngŏng 'nhòng ca mangai loq waq ca Au wa dì tiaq ranenh thê da Au. ");
INSERT INTO hre_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Apaq pagôq ca hiniq Chuaq Boc Plình pì, taiq Chuaq joq 'nàng baxa mangai leq ma ùh loq iu hiniq Haq. ");
INSERT INTO hre_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Hmàng ca Hì Sabat đòiq broq wìa hì hadròih beq. ");
INSERT INTO hre_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Pì phai broq dŏng dèh bìac broq ta tadràu hì beq, ");
INSERT INTO hre_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","mahaq Hì Sabat, aih Hì Padài da Chuaq, Boc Plình pì, ta hì aih pì, con calô, con cadrì, hapŏng cadrì, ngè aban, loq tamoi jàn 'noiq ŏi ta hnem pì, apaq broq bìac leq. ");
INSERT INTO hre_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ma jah 'màng aih, ta tadràu hì, Boc Plình khoi broq plình crŏng taneh, wa dìq dŏng ngè ŏi ta aih. Ta hì ma tapèh Haq padài. 'Màng aih Chuaq khoi am xôq ramŏt ca Hì Sabat wa broq wìa hì hadròih. ");
INSERT INTO hre_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Pì phai loq waq loq iu miq baq pì, waq ca pì jah rìh halình ta taneh Chuaq Boc Plình khoi am. ");
INSERT INTO hre_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Pì apaq jêh đac mangai. ");
INSERT INTO hre_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Pì apaq tango anang. ");
INSERT INTO hre_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Pì apaq atùng. ");
INSERT INTO hre_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Pì apaq capoch bàu anoi hlài amòng tajraq hlài ca mangai haten hatìa ca pì. ");
INSERT INTO hre_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Pì apaq ham ca hnem mangai haten hatìa, hadai apaq ham ca mai haq loq hapŏng calô, hapŏng cadrì, 'bo, lùa, loq ngè leq ma ngè haq.” ");
INSERT INTO hre_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Dìq ca jàn tàng atêh hilùng, bàu ken, hnoq camlet, bôi wang loh nhòi, èh wì tarìt yòng cadan hangai. ");
INSERT INTO hre_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Wì jàn doi ca Môise: “Ìh raq anoi ca nhèn beq, èh nhèn jah tàng, mahaq waiq xìn Boc Plình apaq doi, yùq nhèn ep cachìt.” ");
INSERT INTO hre_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Môise tèu: “Apaq yùq, ma jah 'màng aih Boc Plình trùh đòiq thù pì, đòiq bìac yùq crè ca Haq ŏi ta pì, am ca pì ùh broq tôiq.” ");
INSERT INTO hre_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","'Màng aih wì jàn yòng cadan hangai, jò Môise thia haten ca cato yùc gam nòi Boc Plình ŏi. ");
INSERT INTO hre_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Chuaq doi ca Môise: “Ìh doi ca jàn Is-ra-ên 'màng cô beq: ‘Pì khoi hnoq Au ŏi enh plình anoi 'noh ca cla pì, ");
INSERT INTO hre_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","'Màng aih, toq cùh waiq Au, apaq broq am ca dađeh dua 'mù xam 'bac loq xam wang. ");
INSERT INTO hre_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Pì phai broq ca Au mòiq ca'bŏng tadreo xam taneh beq. Enh 'nhèq aih ep am ngè tadreo bùh wa ngè tadreo waiq catèm da pì, trìu wa 'bo. Nòi leq hmàng ca hiniq Au, Au jah trùh am xôq ramŏt ca pì ta nòi aih. ");
INSERT INTO hre_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Tàng pì broq ca Au mòiq toq ca'bŏng xam hmu, èh apaq pùng padì hmu, ma jah 'màng aih jò pì yŏc ranac broq ca'bŏng tadreo èh pì broq ca ca'bŏng loh ca ùh hadròih. ");
INSERT INTO hre_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Pì apaq lam tŏc gòng ca'bŏng tadreo Au, waq ca bìac ŏi rahòng pì ùh patô loh.’ ");
INSERT INTO hre_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Cô ranenh ìh phai hnài wì jàn: ");
INSERT INTO hre_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Tàng pì rŏt mòiq ngai hapŏng Hêbru, haq patìh ca ìh tadràu hanam, ta hanam ma tapèh haq jah loh ùh tawac pakènh, haq ùh ep am 'bac cleq. ");
INSERT INTO hre_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Tàng haq mùt ŏi mòiq ngai, èh haq loh mòiq. Tàng i mai, èh loh dèh ti mai. ");
INSERT INTO hre_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Tàng cla craq ban am ca haq mai, èh mai haq xa-ông con calô loq con cadrì, èh haq jah loh đeh mòiq ngai, mai wa con ep ŏi hlài ta cla craq. ");
INSERT INTO hre_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Tàng mangai broq dìch doi: ‘Au loq waq dèh ca craq, mai wa con, au ùh enh loh lam.’ ");
INSERT INTO hre_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Èh cla craq haq 'nong haq trùh jang ngìa Boc Plình, thê thia haten ca 'mang loq long jrang, hi khoi yŏc mem hin pàc plì don haq. Haq phai patìh ca cla craq haq lùch ca 'nhòng rìh. ");
INSERT INTO hre_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Tàng i cabô tech dèh con cadrì broq hapŏng cadrì, trùh hanam ma tapèh haq ùh jah ca'naih, troi 'bài hapŏng calô. ");
INSERT INTO hre_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Tàng cla craq ùh ŏi bùi manoh ca cadrì hapŏng aih, 'nhac ca haq khoi ràih haq nèh, hi khoi phai đòiq mangai 'noiq rŏt hlài haq. Mahaq haq ùh i cwìang tech haq ca mangai jàn 'noiq taiq cla haq khoi broq ùh ta-atoq dèh ca hapŏng aih. ");
INSERT INTO hre_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Mahaq tàng cla craq enh đòiq ban dèh ca con calô, èh ep ngan haq troi con cadrì cla dìq. ");
INSERT INTO hre_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Tàng cla craq yŏc hòm mangai 'noiq, èh ùh jah baxùch dahwèq caq, ngè caxùnh atàc, wa bìac ŏng mai ca mangai mai ma adroi. ");
INSERT INTO hre_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Tàng cla craq ùh broq tiaq piq nà cô, gu cadrì aih jah loh ùh tawac pakènh cleq, ùh ep ca'naih hlài 'bac. ");
INSERT INTO hre_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Mangai leq jêh cachìt mangai, ep 'bìq jêh cachìt. ");
INSERT INTO hre_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Tàng mangai aih ùh i ca manoh enh jêh, mahaq taiq Boc Plình khoi phùq mangai 'bìq jêh mùt ta tì mangai aih, èh au jah patô ca pì mòiq nòi amot đòiq mangai jêh đac mangai mot đò. ");
INSERT INTO hre_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Blòq hlài, tàng mangai leq to broq ca mangai haten hatìa chaq trong jêh đac haq, 'nhac ca mangai aih mot nòi ca'bŏng tadreo Au, pì xôq i cwìang rùp jêh đac haq. ");
INSERT INTO hre_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Mangai leq jêh dèh baq loq miq cla haq, phai chìuq pòq tôiq jêh đac. ");
INSERT INTO hre_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Mangai leq rùp mangai èh lam tech, loq đòiq hlài dèh ta hnem cla, mangai aih ep 'bìq jêh cachìt. ");
INSERT INTO hre_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Mangai leq hanip dèh miq baq, ep 'bìq jêh cachìt. ");
INSERT INTO hre_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Jò baiq ngai tajêh dabau, mangai cô jêh mangai tau xam hmu loq xam tì, 'nhòq hìaq cachìt, mahaq hlài ep cùi ta jùang, ");
INSERT INTO hre_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","tàng mangai aih nui yòng xam canhra loh enh gùng, mangai ma jêh haq aih ùh hìaq 'bìq baxa. Mahaq toq ep đèn 'bac raliang hnhung ta toq leq hì ma padài, trùh jò haq brêh tadêh. ");
INSERT INTO hre_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Jò i craq yŏc long blai dèh hapŏng calô loq hapŏng cadrì, broq ca haq cachìt, èh craq aih ep 'bìq baxa. ");
INSERT INTO hre_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mahaq tàng mangai hapŏng ŏi rìh mòiq baiq hì, cla craq claih ca tôiq, taiq mangai hapŏng cùng hang da cla craq. ");
INSERT INTO hre_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Tàng 'bài mangai calô tajêh dabau troq đùng mangai cadrì ŏi jiang loh ca ralàih, mahaq ùh i ca habau 'noiq, èh mangai ma troq dùng aih ep đèn tiaq bàu ŏng mai mangai ma ŏi jiang pajaq, èh ca'naih 'bac jang ngìa mangai hadrah tình hiniq. ");
INSERT INTO hre_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Tàng ŏi i bìac habau hlàc hlai, èh haq phai yŏc chac đèn chac, ");
INSERT INTO hre_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","mat đèn mat, hanenh đèn hanenh, tì đèn tì, jènh đèn jènh, ");
INSERT INTO hre_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","yŏc padŏc đèn padŏc, yŏc teo pràm đèn teo pràm, yŏc habau đèn habau. ");
INSERT INTO hre_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Tàng cabô leq jêh troq clong mat hapŏng calô loq hapŏng cadrì, broq hnhung ca clong mat haq, èh phai ca'naih đòiq haq loh lam ùh tawac ùh pakènh beq, taiq nen clong mat haq khoi hnhung. ");
INSERT INTO hre_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Tàng cabô leq broq tagoh mòiq pliang hanenh da hapŏng calô loq hapŏng cadrì, èh phai ca'naih đòiq haq loh lam ùh tawac ùh pakènh beq, taiq nen haq hnhung mòiq pliang hanenh. ");
INSERT INTO hre_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Tàng i mòiq toq 'bo jàu mòiq ngai gu calô loq gu cadrì troq cachìt, 'bo aih phai 'bìq tèm hmu trùh cachìt. Wì ùh khòh caq jam 'bo aih. Phàn cla mangai ma i 'bo aih ùh hìaq 'bìq baxa. ");
INSERT INTO hre_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mahaq enh adroi 'bo aih xôq loq jàu, wì cla mangai i 'bo khoi lah 'bìq wì lech, mahaq haq ùh càt padràng, èh 'bo cô ŏi jàu cachìt hòm ca mòiq ngai gu calô loq gu cadrì, èh haq ep 'bìq tèm hmu wa cla mangai ma i 'bo, ep 'bìq jêh cachìt dìq. ");
INSERT INTO hre_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Blòq hlài, tàng wì pajaq cùng ca cla mangai ma i 'bo rŏt hlài dèh can rìh cla, mangai ma i 'bo ep am 'màng troi cùng ma khoi pajaq. ");
INSERT INTO hre_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Tàng mòiq toq 'bo jàu mòiq ngai con calô loq con cadrì, hadai tiaq ranenh cô. ");
INSERT INTO hre_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Tàng 'bo jàu mòiq ngai hapŏng calô loq hapŏng cadrì, cla mangai ma i 'bo ep ca'naih 30 'bac jèn ca cla craq da hapŏng aih, hi khoi phai tèm hmu 'bo aih trùh cachìt. ");
INSERT INTO hre_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Tàng cabô pèh ngah hàm loq chìa hàm, mahaq ùh gùp hlài, tàng i 'bo loq lùa taclìh ta aih, ");
INSERT INTO hre_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mangai ma chìa hàm phai đèn 'bac ca cla mangai ma i ngè aban, mahaq ngè ma aban 'bìq jêh đac aih jah hlài phàn mangai ma chìa hàm. ");
INSERT INTO hre_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Tàng 'bo mangai cô jàu 'bo da mangai 'noiq trùh cachìt, baiq ngai phai tech 'bo ma ŏi rìh, axong ca dabau, wa axong hloi ca dabau jam 'bo ma cachìt. ");
INSERT INTO hre_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Tàng cla mangai ma i 'bo, wa haq loq 'bo haq adroi cô xôq loq jàu, mahaq ùh lèt ca càt padràng đòiq, cla haq ep yŏc 'bo đèn 'bo, mahaq 'bo cachìt jah wìa da haq. ");
INSERT INTO hre_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Tàng cabô leq atùng 'bo loq trìu, hi khoi broq jam lam tech, èh ep đèn hlài padam toq 'bo ca mòiq toq, wa pôn toq trìu ca mòiq toq. ");
INSERT INTO hre_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Tàng mangai atùng 'nang ngaq pèh 'mang, haq 'bìq wì rùp jêh cachìt, èh mangai ma jêh haq cachìt ùh hìaq pòq tôiq jêh đac mangai. ");
INSERT INTO hre_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Mahaq tàng jêh haq cachìt jò mat mahì khoi tŏc, èh haq 'bìq broq tôiq jêh đac mangai. “Tàng mangai atùng 'bìq rùp, haq ep đèn hlài dìq dŏng. Tàng ùh i cleq đèn, èh ep tech cla haq broq hapŏng đòiq ca'naih dòih. ");
INSERT INTO hre_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Tàng ngè leq mangai atùng khoi yŏc, 'bo, lùa, loq trìu, xôq ŏi rìh ta tì haq, èh mangai atùng ep đèn baiq phàn. ");
INSERT INTO hre_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Mangai leq ca'naih dèh ngè aban mùt caq broq raliang taneh đùng loq wùan nho pì, èh mangai aih ep yŏc dèh dahwèq ma yi lem dŏng da đùng loq da wùan nho cla, lam đèn da wì. ");
INSERT INTO hre_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Tàng ùnh cheo xèm long hi bùh cheo 'mau mì khoi achauq, loq 'mau mì ŏi yòng ta đùng taneh, loq bùh cheo đùng taneh mangai 'noiq, èh mangai ma bùh ùnh aih ep đèn hlài tôm rìm ngè ma khoi cheo. ");
INSERT INTO hre_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Jò mangai leq am 'bac loq ngè leq ca mangai haten ca haq wèq, èh 'bìq wì atùng ta hnem haq aih, tàng jah rùp mangai atùng, mangai atùng aih ep đèn baiq phàn. ");
INSERT INTO hre_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Tàng ùh jah rùp mangai atùng, èh cla craq hnem ma wèq ngè aih ep lam jang ngìa mangai hadrah đòiq pachac dèh haq ùh i yŏc 'bài ngè aih. ");
INSERT INTO hre_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ta rìm bìac alùan 'nùt, 'nhac mòiq toq 'bo, mòiq toq trìu, mòiq blah eo loq ngè leq tàng mangai cô doi: Ngè cô da au, wa baiq ngai aih phai loh yòng enh ngìa ca mangai hadrah, èh mangai leq ma mangai hadrah ta'mòq, ep đèn hlài da mangai haten ca haq baiq phàn. ");
INSERT INTO hre_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Blòq hlài, tàng mangai leq đòiq lùa, 'bo, trìu loq ngè aban ma 'noiq ca mangai haten ca haq wèq đò, èh 'bìq cachìt, tagoh mòiq apah jènh loq 'bìq hnan đac, ùh i cabô hnoq, ");
INSERT INTO hre_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","èh cla wa ep yŏc hiniq Chuaq đòiq pachac, waq ca loq mangai ma wèq đò ngè aban ùh yŏc cleq cùng hang da mangai haten ca haq, cla craq ma i ngè aban aih pachac, mangai ma wèq đò ùh hìaq ep đèn. ");
INSERT INTO hre_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mahaq tàng ngè aban 'bìq haq atùng, èh mangai ma wèq đò ep đèn hlài da craq ngè aban. ");
INSERT INTO hre_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","“Tàng ngè aban 'bìq ngè rôm cap cachìt, mangai ma ban ep hnoq hanang haq đòiq patô hlài, èh ùh hìaq ep đèn ngè aban aih. ");
INSERT INTO hre_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Tàng mangai leq bòch đò da mangai haten ca haq mòiq toq ngè aban lò ca tagoh mòiq pah jènh, loq haq cachìt đac jò ùh i ca cla craq haq ta aih, èh mangai ma bòch đò aih ep đèn hlài. ");
INSERT INTO hre_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Tàng cla craq ngè aban aih ŏi ta aih, èh ùh hìaq ep đèn hlài. Tàng ngè aban aih khoi jah mangai am bòch đò, èh 'bac bòch đò jah am thai ca 'bac đèn hlài. ");
INSERT INTO hre_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Tàng mangai leq padô wa cùi ŏi ti mòiq ngai gu adrùh 'nhòq yŏc ŏng, èh mangai aih ep am 'bac ngè xìn ban mai wa ep yŏc gu adrùh aih broq mai. ");
INSERT INTO hre_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Blòq hlài, tàng baq haq ùh am wa yŏc dabau, èh mangai aih ep am 'bac toq sôq 'bac yŏc ngè xìn ban mai. ");
INSERT INTO hre_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Pì apaq am pajàu kiac dù ŏi rìh. ");
INSERT INTO hre_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Mangai leq cùi ŏi ti ngè aban ep 'bìq jêh cachìt. ");
INSERT INTO hre_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Mangai leq tadreo am yiang leq enh gùng ca Chuaq èh 'bìq jêh đac. ");
INSERT INTO hre_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Pì apaq broq 'mèq ca tamoi jàn 'noiq wa hadai apaq padit padiang wì haq, ma jah 'màng aih pì khoi broq tamoi jàn 'noiq ŏi ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Pì apaq padit padiang mangai hadrô, loq mangai lac. ");
INSERT INTO hre_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Tàng padit padiang wì haq, èh wì haq creo dang Au, Au tamàng wì haq creo, ");
INSERT INTO hre_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","hi khoi can nòih Au jah plôh tŏc, wa Au yŏc chang gùm jêh đac pì, èh mai pì wìa mangai hadrô, con pì wìa mangai lac. ");
INSERT INTO hre_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Tàng pì am đò 'bac ca mangai pabônh ta jàn Au, apaq bòch hlài 'bac i lòi ca mangai aih. ");
INSERT INTO hre_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Tàng pì wê eo yôh da mangai haten ca pì broq ngè baxon đòiq lùi, èh ep am hlài da haq adroi ca jò mat mahì clìh, ");
INSERT INTO hre_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ma jah 'màng aih, aih bai đòiq wì cabàn dèh chac. Tàng ùh i ca eo aih, haq yŏc cleq jò cùi? Tàng haq creo dang ca Au, Au tamàng bàu haq, ma jah 'màng aih Au i manoh khôn khaoq wa loq xa-ŏch. ");
INSERT INTO hre_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Pì apaq waiq hanip Boc Plình, hadai apaq hanip craq broq gàu da jàn pì. ");
INSERT INTO hre_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Pì apaq xòi am ca Au phàn am da 'mau mì wa diac nho da pì. “Pì hadai phai am ca Au con ramua pì. ");
INSERT INTO hre_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Phàn da trìu wa 'bo pì hadai 'màng aih. Ta tapèh hì baxèm, con ramua ŏi dèh ti miq haq. Ta hì rahem pì am haq ca Au beq. ");
INSERT INTO hre_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Pì phai broq mangai hadròih da Au, ma jah 'màng aih apaq caq jam leq ma 'bìq ngè rôm hich ŏi ta đùng. Hwenh jam aih ca coq beq. ");
INSERT INTO hre_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Pì apaq anoi hlài bàu amòng. Apaq anoi hlài bàu 'nùt đòiq mòiq manoh ca mangai ngang dù. ");
INSERT INTO hre_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Pì apaq broq tiaq mangai bàc đòiq broq bìac dù. Jò pì anoi hlài bìac wì tarahen ta nòi hadrah, apaq tiaq pah mangai bàc đòiq broq bìac ùh ta-atoq. ");
INSERT INTO hre_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Hadai paq gen can mangai pa jò wì tarahen bìac ta nòi hadrah. ");
INSERT INTO hre_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Tàng pì hnoq 'bo loq lùa da mangai tagit ca dađeh lam lac, èh pì ep 'ràng hlài ca haq. ");
INSERT INTO hre_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Tàng pì hnoq lùa da mangai tagit ca pì pòq trap tacro, apaq broq dađeh ùh hnoq, mahaq ep jùp haq. ");
INSERT INTO hre_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Ta jò takìan, pì apaq broq ùh ta-atoq am ca mangai pa ŏi ta'ne pì. ");
INSERT INTO hre_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Pì ep wia hangai ca bàu amòng wa apaq jêh đac mangai ùh i ca tôiq lôi loq mangai ta-atoq, ma jah 'màng aih, Au ùh ca'naih mangai i tôiq. ");
INSERT INTO hre_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Pì apaq nhàn cùng rŏt manoh, ma jah 'màng aih cùng rŏt manoh broq ùh xau mat mangai khôn rabiaq wa broq hnhung đac bìac ta-atoq. ");
INSERT INTO hre_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Pì apaq padit padiang mangai jàn 'noiq taiq pì raq ma 'nì loq ca manoh mangai jàn 'noiq 'màng leq, ma jah 'màng aih pì khoi lah broq mangai jàn 'noiq ŏi ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Pì phai rai adrech wa loh gat ta tadràu hanam beq, ");
INSERT INTO hre_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","mahaq ta hanam tapèh phai đòiq taneh padài, đòiq ca 'bài mangai pa ta jàn aih jah i dahwèq caq; 'nah ŏi rah, ngè rìh ŏi ta đùng taneh jah caq. Hadai phai broq ca plì wùan nhò wa ôliu 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ta tadràu hì pì abroq dèh bìac cla, mahaq ta hì tapèh padài beq, waq ca 'bo, lùa da pì, hapŏng calô wa hapŏng cadrì pì xam mangai jàn 'noiq ŏi ta hnem pì hadai jah padài dìq. ");
INSERT INTO hre_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Pì phai wèq dìq rìm bàu Au thê pì. Apaq dang xìn 'bài yiang ma 'noiq; Hacùng pì ùh jah ràu trùh 'bài yiang aih. ");
INSERT INTO hre_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Rìm hanam pì phai broq lè hiniang ca Au piq yàng. ");
INSERT INTO hre_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Pì phai broq Lè Hiniang 'Benh Ùh Tah Blo, phai caq 'benh ùh tah blo ta tapèh hì jò pajaq ta khê Abip, troi bàu Au khoi tanap, ma jah 'màng aih ta khê aih pì loh khoi gùng Aicàp. “Rìm ngai ep 'ràng ngè tadreo am ca Au. ");
INSERT INTO hre_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Pì phai broq Lè Hiniang Gat jò plì ma baxèm, wa broq Lè Hiniang Gop Plì cloh hanam, jò pì 'ràng plì wa 'mau nhò bìac pì abroq enh đùng. ");
INSERT INTO hre_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Mòiq hanam piq yàng dìq gu calô ep trùh jang ngìa Chuaq, Haq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Pì apaq am mahem da ngè tadreo Au pajùm ti 'benh tah blo, hadai apaq đòiq ramaq da hiniang Au cwa damang trùh daxroq. ");
INSERT INTO hre_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Pì phai 'ràng plì gàu mùa ma dìq jaq lem da taneh mùt hnem waiq khàn Chuaq Boc Plình pì. “Pì ùh khòh pai con bubi ta diac tôh miq haq. ");
INSERT INTO hre_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Cô, Au thê mòiq 'Bình Plình lam adroi jang ngìa pì, đòiq wèq ban pì jò lam ti trong, 'nong pì mùt nòi Au khoi padon đòiq. ");
INSERT INTO hre_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Jang ngìa Haq pì ep wèq dađeh, ep tamàng tiaq bàu Haq, apaq blàq hlài ca Haq, taiq Haq ùh ca'naih tôiq ca pì, taiq nen hiniq Au ŏi ti Haq. ");
INSERT INTO hre_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mahaq tàng pì panim ca dì tiaq bàu Haq, hi broq tiaq rìm nà Au tanap, èh Au jah ta'blêq ca mangai tajraq hlài ca pì, tajêh ca mangai tajêh ca pì. ");
INSERT INTO hre_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ma jah 'màng aih 'bình plình jah lam adroi, 'nong pì mùt ta gùng da jàn A-mô-rit, Hêtit, Pe-rê-xit, Ca-na-an, Hêwit wa Jê-bu-xit, hi khoi Au jah jêh đac dìq ca wì haq. ");
INSERT INTO hre_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Pì apaq cùh waiq wa patìh bìac 'bài can kiac wì haq; apaq tiaq dua bìac wì haq broq. Pì phai raliang đac wa tùq bahech đac dua 'mù wì haq. ");
INSERT INTO hre_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mahaq pì phai patìh toq Chuaq Boc Plình da pì, èh Haq jah am xôq ramŏt ca pì, i pua caq, diac ôq, èh broq can hinìq tôq ùh hrŏc hangai ca pì. ");
INSERT INTO hre_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Hadai ùh hìaq i mangai cadrì leq ralàih, loq xon ŏi ta gùng da pì. Au jah am ca pì can rìh halình. ");
INSERT INTO hre_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Au jah broq bìac yùq crè wa manoh manhài ta gùng tamoi leq pì ma padon trùh. Au broq ca wì ma tagit ca pì cadàu enh ngìa ca pì. ");
INSERT INTO hre_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Au thê ong chìa pan adroi ca pì hnan đac jàn Hêwit, jàn Ca-na-an wa jàn Hêtit enh ngìa ca pì. ");
INSERT INTO hre_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Au ùh hnan wì haq dìq ta mòiq hanam, taiq tàng broq 'màng aih èh gùng loq ca wang wê, ngè rôm loh bàc, èh wì haq loh bàc yi hnao ca pì. ");
INSERT INTO hre_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Au hnan wì haq adia adia, gòm jò leq xinoi da pì jah xa-ông loh bàc èh jah wèq gùng taneh cô. ");
INSERT INTO hre_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Au acang taneh gùng da pì enh Diac Raxìq Gòh trùh Diac Raxìq Ta'ne, enh đùng braih càn trùh Cròng Diac U-phra-tê, ma jah 'màng aih Au jah am mangai jàn ta gùng aih ca pì, èh pì mangai ma hnan đac wì haq hangai ca pì. ");
INSERT INTO hre_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Pì apaq wêh jao ca wì haq wa ca 'bài can kiac da wì haq. ");
INSERT INTO hre_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Wì haq ùh jah rìh ŏi ta taneh gùng da pì, yùq wì haq loq thê pì broq tôiq ca Au đòiq patìh 'bài can kiac da wì haq. Bìac aih wìa bu dàng manet ca pì.” ");
INSERT INTO hre_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Chuaq doi ca Môise: “Ìh wa Arôn, Nađap, wa A-bi-hu pajùm ti 70 ngai gu craq broq gàu Is-ra-ên tŏc ta bôi wang, hi khoi đòiq wì yòng hangai cùh waiq. ");
INSERT INTO hre_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mòiq ngai Môise raq jah lam haten ca Chuaq, mahaq wì haq ùh jah lam haten, jàn hadai ùh lam tiaq haq.” ");
INSERT INTO hre_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Môise trùh ta'mon hlài ca jàn rìm nà bàu doi wa ranenh da Chuaq, èh jàn tèu: “Òq nhèn broq tiaq rìm bàu Chuaq tanap.” ");
INSERT INTO hre_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Môise achìh yŏc dŏng rìm bàu da Chuaq. Hi khoi rìu xrŏih, broq mòiq toq ca'bŏng tadreo nòi jènh wang, pa'nàng 12 toq long jrang patìah hlài ca 12 toq hadròng hadrech Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Môise thê 'bài mangai gu radam da Is-ra-ên lam am ngè tadreo bùh wa ngè tadreo waiq catèm ca Chuaq xam 'bo con 'yoh. ");
INSERT INTO hre_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Môise yŏc mòiq 'ne mahem ùc đòiq ta dòt, ŏi i mòiq 'ne mahem èh da'rat ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Khoi èh, haq rùp sech wêh jao đŏc ca jàn tamàng, èh jàn doi: “Òq nhèn broq wa iu tiaq rìm bàu Chuaq doi.” ");
INSERT INTO hre_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Môise yŏc mahem da'rat ca mangai jàn, hi doi: “Cô mahem wêh jao Chuaq, Boc Plình khoi broq ca pì jò Haq am bàu cô.” ");
INSERT INTO hre_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Khoi èh, Môise wa Arôn, Nađap wa A-bi-hu, pajùm 70 gu craq broq gàu Is-ra-ên tŏc ta wang, ");
INSERT INTO hre_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ngan hnoq Boc Plình da Is-ra-ên, enh 'neq jènh haq, i tanam xèm tìah ca ngŏc xenh. ");
INSERT INTO hre_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mahaq Haq ùh achùq tì mùt ta 'bài mangai gù craq ta jàn Is-ra-ên, mahaq wì ngan hnoq Boc Plình, hi khoi wì caq, ôq. ");
INSERT INTO hre_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Chuaq doi ca Môise: “Tŏc ta wang beq, trùh ta Au wa ŏi ta aih. Au jah am ca ìh capiac hmu ma i ranenh wa bàu thê da Au khoi achìh đòiq hnài wì.” ");
INSERT INTO hre_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Môise yòng ti Jôsuê, mangai patìh ca haq, hi khoi Môise lam tŏc ta wang da Boc Plình. ");
INSERT INTO hre_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Môise doi ca 'bài gu craq broq gàu: “Pì gòm ŏi ta cô trùh jò leq ma hlài ti pì oq. Cô Arôn wa Hurò ŏi hlài ti pì, tàng i bìac cleq, èh bòch wa haq.” ");
INSERT INTO hre_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","'Màng aih, Môise tŏc ta wang, èh yùc lom wang. ");
INSERT INTO hre_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Can 'ngah ngai da Chuaq ŏi ta bôi wang Sinai, ta tadràu hì yùc lom wang, èh hì tapèh Chuaq ŏi ta yùc creo ca Môise. ");
INSERT INTO hre_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Can 'ngah 'ngai da Chuaq ta bôi wang, jàn Is-ra-ên hnoq ùh crài ca ùnh 'nang cheo. ");
INSERT INTO hre_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Môise mùt ta'ne cato yùc rai tŏc ta wang. Haq ŏi ta aih 40 hì 40 mang. ");
INSERT INTO hre_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Doi ca jàn Is-ra-ên dèch am dahwèq ca Au. Ìh nhàn yŏc ngè aih da rìm ngai i manoh joq 'nàng dèch am oq. ");
INSERT INTO hre_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Cô dahwèq pì jah nhàn yŏc da wì haq: Wang, 'bac, đùng, ");
INSERT INTO hre_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","brai nhum xenh, gòh ngùi wa gòh mahem, bai xam brai habùac lem wa xàc bubi, ");
INSERT INTO hre_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","akia trìu calô nhum gòh, akia ca nùac, long a-kê-si-a, ");
INSERT INTO hre_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","dàu bùh đòiq xreo 'ngah, dahwèq xua thùm đòiq broq dàu xùt wa dàu xua thùm, ");
INSERT INTO hre_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","hmu ngŏc gam, wa 'bài hmu ngŏc ma 'noiq đòiq 'mùt ta êphot wa capiac bac jang rada. ");
INSERT INTO hre_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Wì haq phai broq ca Au mòiq toq Hnem Traiq Cùh Waiq Hadròih đòiq Au jah ŏi ta'ne wì haq. ");
INSERT INTO hre_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ìh phai broq Hnem Traiq Cùh Waiq wa dìq ca nà tìah troi 'mù Au ma patô ca pì beq. ");
INSERT INTO hre_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Wì haq phai broq mòiq toq hom xam long a-kê-si-a, dàng yôh 2 hagat 'ne, dàng gat 1 hagat 'ne, dàng ha'nhèq 1 hagat 'ne. ");
INSERT INTO hre_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Yŏc wang 'bìt jàp enh dalam wa enh gùng, wa clep grôi xam wang dudan ca hom. ");
INSERT INTO hre_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Phai broq pôn toq gwiang xam wang 'mùt ta pôn toq mùm enh 'neq, baiq toq gwiang 'mùt mùm cô, baiq toq gwiang 'mùt mùm tau. ");
INSERT INTO hre_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Phai broq baiq catŏch long tanòng tòng xam long a-kê-si-a 'bìt xam wang. ");
INSERT INTO hre_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Hi khoi 'mùt long tanòng mùt ta gwiang baiq pah rawiang hom, đòiq broq long tòng hom. ");
INSERT INTO hre_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Long tanòng aih phai ŏi hloi ta gwiang ùh khòh dŏih. ");
INSERT INTO hre_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Phai đòiq ta hom capiac hmu wêh jao Au ma padon am. ");
INSERT INTO hre_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Phai broq mòiq toq Calàp Baxŏng Tôiq xam wang, dàng yôh 2 hagat 'ne, dàng gat 1 hagat 'ne. ");
INSERT INTO hre_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Phai broq baiq toq 'mù chê-ru-bim xam wang đòiq ta baiq toq lùch crŏng Calàp Baxŏng Tôiq. ");
INSERT INTO hre_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Đòiq mòiq toq chê-ru-bim ŏi pah cô, mòiq toq chê-ru-bim ŏi pah tau hatop ca Calàp Baxŏng Tôiq. ");
INSERT INTO hre_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Baiq toq chê-ru-bim phai ngìa ca dabau, panan wa haq hlìa ti 'nhèq enh 'nhèq ca Calàp Baxŏng Tôiq, wa hadrò wa haq cùp ngan Calàp Baxŏng Tôiq. ");
INSERT INTO hre_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Phai đòiq Calàp Baxŏng Tôiq enh 'nhèq ca Hom Wêh Jao, hi khoi tah enh dalam hom capiac wêh jao ma Au padon am. ");
INSERT INTO hre_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Au jah glàm ìh ta Calàp Baxŏng Tôiq, ta'ne baiq toq 'mù chê-ru-bim enh 'nhèq Hom Wêh Jao. Au jah anoi ca ìh loq dìq ca bàu thê da Au ma am ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Phai broq mòiq toq ca'bŏng xam long a-kê-si-a, dàng yôh 2 hagat, dàng gat 1 hagat, dàng 'nhèq 1 hagat 'ne, ");
INSERT INTO hre_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Phai 'bìt xam wang wa broq mòiq trong grôi dudan. ");
INSERT INTO hre_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Phai broq khùan dudan ca ca'bŏng càn toq mòiq capiang tì wa broq grôi xam wang ti khùan aih. ");
INSERT INTO hre_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Èh broq pôn toq gwiang wang, ŏi ta pôn toq mùm nòi jènh ca'bŏng. ");
INSERT INTO hre_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","'Bài gwiang ŏi haten ca khùan đòiq 'mùt long tòng ca'bŏng. ");
INSERT INTO hre_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Phai broq long tanòng xam long a-kê-si-a, 'bìt xam wang, đòiq tòng ca'bŏng aih. ");
INSERT INTO hre_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ìh phai yŏc wang broq 'bài ngè đòiq ta ca'bŏng: dòt, achôn, abôq wa doi chê đòiq patìh jò broq lè dèch am ngè ôq. ");
INSERT INTO hre_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Enh 'nhèq ca ca'bŏng, ìh jah đòiq 'benh hadròih i yôt jang ngìa Au. ");
INSERT INTO hre_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Ìh phai broq jènh đen xam wang mòiq calôq. Jènh, long ta'ne, abôq i riang wa 'bài riang da đen broq xam wang aih. ");
INSERT INTO hre_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Long ta'ne đen i tadràu toq hamenh, piq hamenh ŏi pah cô, piq hamenh ŏi pah tau. ");
INSERT INTO hre_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ta tadràu hamenh enh 'nhèq jènh đen, rìm hamenh i piq toq abôq tìah ca riang apriac, pajùm ca acŏn wa riang. ");
INSERT INTO hre_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ta chac jènh đen, i pôn toq abôq tìah ca riang apriac, acŏn wa riang. ");
INSERT INTO hre_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ta tadràu hamenh enh long ta'ne jènh đen, enh 'neq rìm tang baiq toq hamenh, i mòiq toq acŏn. ");
INSERT INTO hre_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Acŏn wa hamenh da jènh đen, broq xam mòiq calôq wang. ");
INSERT INTO hre_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Phai broq tapèh toq đen đòiq jò hi bùh đen, èh xreo jang ngìa jènh đen. ");
INSERT INTO hre_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Deo cat tìm đen, wa dòt đòiq tah loc đen, hadai broq xam wang. ");
INSERT INTO hre_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Phai yŏc mòiq talàng wang broq jènh đen cô wa 'bài ranac da jènh đen. ");
INSERT INTO hre_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ep broq tìah ca 'mù ma khoi patô am ca ìh ta bôi wang. ");
INSERT INTO hre_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Phai yŏc 10 blah bai prình broq Hnem Traiq Cùh Waiq, aih bai tenh xam brai habùac lem, nhum xenh, gòh ngùi wa gòh mahem, nhò mòiq ngai ragài ca achìh 'bài 'mù chê-ru-bim dìq ca jaq geo. ");
INSERT INTO hre_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Mòiq blah bai dang yôh 28 hagat wa dang gat 4 hagat, dìq ca blah bai ep i mòiq maneh tìah ca dabau. ");
INSERT INTO hre_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Phai broq padam blah bai prình jìp raclep loh mòiq wa padam blah bai prình ma 'noiq jìp raclep loh mòiq. ");
INSERT INTO hre_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Phai jìp rawiang xam brai xenh ta ha'mai bai prình blah ma mòiq, èh phai jìp rawiang xam brai xenh ta ha'mai bai prình ma baiq. ");
INSERT INTO hre_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Phai broq 50 toq rawiang ca ha'mai blah bai prình ma mòiq, wa 50 toq rawiang ca ha'mai blah bai prình ma baiq; 'bài rawiang baiq pah phai ta jang ca dabau đòiq jah ta'mùt pajùm. ");
INSERT INTO hre_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Phai broq 50 toq glêh xam wang, hi khoi gwac baiq toq blah bai prình pajùm wìa mòiq am ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Phai broq 11 blah bai prình xam xàc bubi, đòiq broq cùa Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Mòiq jàt mòiq blah bai prình cô phai i mòiq maneh tìah ca dabau, dang yôh 30 hagat, wa dang gat 4 hagat. ");
INSERT INTO hre_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Phai ta'mùt padam blah bai prình xam xàc bubi cô ca dabau, èh ta'mùt tam mòiq blah aih blah ma tadràu, mahaq blah tadràu phai cadùh broq baiq đòiq mòiq phàn 'ne da bai prình cô loh enh 'nhèq ŏi jang ngìa Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Èh hòm broq 50 toq rawiang ta ha'mai bai prình blah ma mòiq, èh 50 toq rawiang ta ha'mai bai prình blah ma baiq. ");
INSERT INTO hre_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Èh phai broq 50 toq glêh xam đùng, ta'mŏt ta rawiang, 'màng aih yùp hlài baiq blah bai prình cô đòiq haq wìa mòiq toq. ");
INSERT INTO hre_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Mahaq ŏi i rah, aih baiq hagat da blah bai prình cô jah cadrài pah cloh Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Phàn pah dang yôh da bai prình mòiq pah i rah 1 hagat, èh 'mat jah cadrài baiq pah prình hnem traiq cùh waiq đòiq chê 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Phai broq mòiq capiac xam akia trìu calô nhum gòh đòiq enh cùa hnem traiq cùh waiq, wa broq mòiq capiac xam akia ca nùac glàp tam enh crŏng hòm. ");
INSERT INTO hre_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Èh panàt Hnem Traiq Cùh Waiq phai broq dìq xam long a-kê-si-a pah loh long ban. Panàt aih pa'nàng dìq. ");
INSERT INTO hre_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Rìm ban xam long a-kê-si-a, dang yôh 10 hagat, dang gat 1 hagat 'ne. ");
INSERT INTO hre_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Rìm capiac ban i baiq toq calŏih jang ca dabau đòiq jah ta'mŏt ca dabau. Èh dìq dŏng ca capiac long ban panàt Hnem Traiq Cùh Waiq hadai broq 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Phai broq 20 capiac long ban đòiq pah 'ma ca mat mahì loh ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Enh 'neq ca rìm capiac long ban phai broq baiq toq xèm i calŏih xam 'bac, dìq dŏng aih 40 trom broq ca 20 capiac long ban. ");
INSERT INTO hre_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Èh hòm broq 20 capiac long ban đòiq ta Hnem Traiq Cùh Waiq pah 'ngeo ca mat mahì loh. ");
INSERT INTO hre_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Wa 40 xèm i calŏih xam 'bac, enh 'neq ca rìm tàng capiac ban i baiq toq calŏih. ");
INSERT INTO hre_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Phai broq tadràu capiac long ban pah cloh Hnem Traiq Cùh Waiq, aih ta ngìa pah mat mahì clìh. ");
INSERT INTO hre_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Phai broq baiq capiac long ban đòiq ta baiq toq mùm pah cloh Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Baiq capiac long ban aih phai hatop ca dabau enh 'neq tŏc trùh ta 'nhèq nhò mòiq toq gwiang; baiq toq mùm broq 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","'Màng aih èh, i rahem capiac long ban wa 16 trom ha'mai calŏih xam 'bac, aih baiq toq trom ha'mai calŏih ŏi enh 'neq rìm capiac long ban. ");
INSERT INTO hre_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Èh hòm, phai broq padam catŏch long pang dang gat xam long a-kê-si-a am ca 'bài long ban ta ngìa pah cô. ");
INSERT INTO hre_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Padam catŏch long pang dang gat ngìa pah tau wa padam catŏch long pang dang gat ma 'noiq ŏi pah crŏng da Hnem Traiq Cùh Waiq, aih ngìa pah mahì clìh. ");
INSERT INTO hre_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Long catŏch pang dang yôh baiq pah ta'ne capiac long ban panàt, pah enh ngìa trùh pah cloh. ");
INSERT INTO hre_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Phai yŏc wang 'bìt long pang dang gat wa broq 'bài gwiang xam wang đòiq wèq 'bài long pang dang gat. ");
INSERT INTO hre_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Ìh phai ta'mroq Hnem Traiq Cùh Waiq tìah troi dua khoi patô am ca ìh ta bôi wang. ");
INSERT INTO hre_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Ìh phai broq mòiq blah bai prình xam brai habùac lem, nhum xenh, gòh ngùi wa gòh mahem, èh mangai ragài jah achìh 'bài 'mù chê-ru-bim dìq ca jaq geo. ");
INSERT INTO hre_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Hi khoi, ìh phai atua bai prình aih enh 'nhèq ca pôn toq jrang xam long a-kê-si-a 'bìt xam wang. 'Bài glêh broq xam wang ta pôn toq xèm i calŏih xam 'bac. ");
INSERT INTO hre_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Phai atua bai prình aih xam glêh. Hi khoi ŏi enh pah trom ca bai prình đòiq Hòm Wêh Jao, bai prình cô broq hagan am ca pì Nòi Hadròih wa Nòi Dìq Jaq Hadròih. ");
INSERT INTO hre_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Khoi èh, đòiq Calàp Baxŏng Tôiq enh 'nhèq ca Hom Wêh Jao, đòiq Nòi Dìq Jaq Hadròih. ");
INSERT INTO hre_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Phai đòiq ca'bŏng i 'benh hadròih enh gùng ca bai prình pah 'ngeo ca mat mahì loh ta Hnem Traiq Cùh Waiq, wa jènh đen jang ca ca'bŏng pah 'ma ca mat mahì loh. ");
INSERT INTO hre_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Jang 'mang Traiq, ìh phai broq mòiq blah bai tenh xam bai habùac lem, nhum xenh, gòh ngùi wa gòh mahem, ìh ep canòm ca mangai thòq atenh dìq jaq geo broq bìac cô. ");
INSERT INTO hre_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Broq glêh xam wang đòiq atua bai prình cô ti padam toq long jrang xam long a-kê-si-a 'bìt xam wang. Dìq ca jrang cô 'mùt ti padam toq xèm i calŏih xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ìh phai broq mòiq toq ca'bŏng tadreo xam long a-kê-si-a, pah dang yôh 5 hagat, pah dang gat 5 hagat, pah ha'nhèq 3 hagat. ");
INSERT INTO hre_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Broq pôn toq aki ta mùm ca'bŏng tadreo. 'Bìt dìq dŏng ca'bŏng xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Phai broq 'bài ranac da ca'bŏng tadreo, aih: Thùng đòiq tah blo tanùh, canoch, dòt đòiq diac, achôn piq rang, wa dòch tah cachah. Dìq ranac phai broq xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Phai broq am ta ca'bŏng tadreo mòiq toq jàn xam đùng đòiq tah ngia ùnh, wa nòi pôn toq mùm broq pôn toq gwiang xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Hi khoi đòiq jàn aih enh 'neq ca ca'nàm ca'bŏng tadreo pàng enh 'neq tŏc trùh ha'ne pah ha'nhèq. ");
INSERT INTO hre_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Phai broq long tanòng tòng ca'bŏng tadreo xam long a-kê-si-a, 'bìt xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Yŏc baiq long tanòng 'mùt ta 'bài gwiang ŏi baiq pah pinh ca'bŏng tadreo đòiq tanòng. ");
INSERT INTO hre_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Phai broq ca'bŏng tadreo jah broq xam long ban, i trom ta'ne, broq tìah troi khoi patô am ca ìh ta bôi wang. ");
INSERT INTO hre_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Phai broq pagia xàn da Hnem Traiq Cùh Waiq xam bai prình. Pah 'ma ca mat mahì loh, broq prình xam bai habùac lem, dang yôh 100 hagat; ");
INSERT INTO hre_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","wa 20 long jrang wa 20 toq xèm i calŏih xam đùng; èh dìq ca glêh wa ha'mai da jrang phai broq xam 'bac. ");
INSERT INTO hre_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ngìa pah 'ngeo ca mat mahì loh hadai broq 'màng aih. Bai prình aih dang yôh 100 hagat, atua xam glêh wa ha'mai xam 'bac ti 20 long jrang đòiq ta xèm i calŏih xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Bai prình da pagia xàn ngìa pah mat mahì mùt, dang yôh 50 hagat, atua ti 10 long jrang đòiq ta 10 toq calŏih xèm. ");
INSERT INTO hre_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Pagia xam bai prình enh ngìa xàn, aih pah mat mahì loh, dang gat 52 hagat. ");
INSERT INTO hre_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Nòi enh ngìa mùt ta xàn, aih pah mat mahì loh, i bai prình da pagia dang yôh 15 hagat pah 'ma ca 'mang, atua ta piq toq long jrang đòiq ta piq toq xèm i calŏih. ");
INSERT INTO hre_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Pah 'ngeo ca 'mang hadai i bai prình pagia dang yôh 15 hagat, atua ta piq toq long jrang đòiq ta piq toq xèm i calŏih. ");
INSERT INTO hre_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Phàn 'mang pagia xàn i mòiq blah bai prình dang yôh 20 hagat tenh xam brai habùac lem, èh broq xam brai nhum xenh hliang, gòh ngui wa gòh mahem. Atua ti pôn toq long jrang đòiq ta pôn toq xèm i calŏih. ");
INSERT INTO hre_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Dìq dŏng ca long jrang dudan ca xàn phai i don ti gàu wa glêh xam 'bac wa 'mùt ta xèm i calŏih broq xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Pah yôh da pagia xàn jah 100 hagat, pah dang gat 50 hagat, jah prình xam bai habùac lem ha'nhèq 5 hagat. Xèm i calŏih đòiq jrang phai broq xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Dìq dŏng ranac đòiq broq ta bìac patìh ta Hnem Traiq Cùh Waiq, ùh kè ca ranac cleq xam long cŏc da Hnem Traiq Cùh Waiq wa long cŏc da pagia xàn, dìq phai broq xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ìh phai thê jàn Is-ra-ên 'ràng trùh dàu ôliu hliang đòiq bùh đen wa đen aih phai hloi hloi 'ngah. ");
INSERT INTO hre_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Enh dalam Hnem Traiq Cùh Waiq, mahaq enh gùng ca bai prình jang ngìa hom wêh jao, Arôn wa 'bài con calô haq phai palaoq ta'mroq đòiq đen aih jah hloi hloi 'ngah enh ngìa ca Chuaq Boc Plình enh daxèq trùh daxroq. Aih trong ranenh hloi hloi am ca xinoi jàn Is-ra-ên ep wèq. ");
INSERT INTO hre_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ta jàn Is-ra-ên, ìh phai ràih Arôn, daq ìh, wa con calô haq, aih Nađap, A-bi-hu, Ê-li-a-xa, wa I-tha-ma, yŏc wì broq pajàu Boc Plình jang ngìa Au. ");
INSERT INTO hre_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ìh phai broq eo hadròih am ca Arôn, daq ìh, aih eo anì lem lình wa jah wì loq iu bìac pajàu. ");
INSERT INTO hre_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ìh phai doi dìq dŏng ca thòq ma rabiaq, mangai Au khoi am manoh thài rabiaq, broq eo am ca Arôn caxùnh jò lah crài haq loh hadròih, atŏc broq pajàu patìh ca Au. ");
INSERT INTO hre_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Cô eo wì haq broq: Capiac bac jang rada, êphot, eo yôh, eo enh 'neq atenh ma geo, calôp wa hadrang caxi bai càt ca'nam. 'Màng aih èh wì haq broq eo hadròih am ca Arôn, daq ìh, wa 'bài con calô haq, đòiq wì broq pajàu patìh ca Au. ");
INSERT INTO hre_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Wì haq phai yŏc bai habùac lem, brai xam nhum wang, wa brai nhum xenh, gòh ngùi wa gòh mahem. ");
INSERT INTO hre_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Mangai thòq dìq jaq ragài broq êphot xam wang, brai tenh habùac lem, yŏc brai xam wang achot jìp wa hadai brai nhum xenh, gòh ngùi wa gòh mahem. (broq êphot xam wang troq ùh?) loq xam brai nhum wang. ");
INSERT INTO hre_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Baiq pah pinh êphot broq baiq hadrang caxi palêh, hatop ta êphot. ");
INSERT INTO hre_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Caxi càt êphot phai broq ma geo, hadai yŏc bai tìah troi broq êphot, broq xam nhum xenh, gòh ngùi wa gòh mahem wa xam brai habùac lem. ");
INSERT INTO hre_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Phai yŏc baiq pliang ngŏc nhum gam, èh pùng achìh hiniq con calô da Is-ra-ên ŏi enh 'nhèq, ");
INSERT INTO hre_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ta tiaq dèh hì ma xa-ông ca wì haq, tadràu toq hiniq ta pliang ngŏc cô wa tadràu toq pliang ngŏc tau. ");
INSERT INTO hre_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Phai pùng achìh hiniq 'bài con calô Is-ra-ên ta baiq toq pliang ngŏc aih, tiaq teo mangai thòq pùng, khoi èh 'mùt ta khùan broq xam wang, ");
INSERT INTO hre_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Èh 'mùt baiq pliang ngŏc aih jang baiq pah ha'mai da êphot, aih baiq pliang ngŏc đòiq bahmàng hlài 'bài con calô da Is-ra-ên. Arôn jah bac hiniq wì haq ta baiq apah plêh haq enh ngìa Chuaq đòiq broq bahmàng hlài. ");
INSERT INTO hre_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Phai broq khùan xam wang. ");
INSERT INTO hre_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Hi khoi, cadrenh baiq hadrang caxi wang broq tagwat đòiq càt caxi aih mùt ta khùan xam wang. ");
INSERT INTO hre_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ìh phai thê mòiq ngai thòq dìq jaq ragài broq capiac rada đòiq jah loq Chuaq tình 'màng leq. Haq phai broq 'mat tìah troi êphot, aih broq xam brai habùac tenh lem, wa jìp teo xam brai wang, wa brai nhum xenh, gòh ngùi wa gòh mahem. ");
INSERT INTO hre_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Phai broq capiac bac jang rada i pôn pah ta-atoq, jìp baiq capiac raclap broq mòiq, pah dang yôh mòiq hada, pah dang gat hadai mòiq hada. ");
INSERT INTO hre_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ìh phai 'bìt pôn brong ngŏc 'mùt ta capiac ma bac jang rada. Brong mòiq: Ngŏc gòh dùm, ngŏc gòh bah wa ngŏc nget bah, ");
INSERT INTO hre_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","brong baiq: Ngŏc xenh hliang wa bùac, ngŏc xenh hliang ngaiq wa ngŏc kim cùang; ");
INSERT INTO hre_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","brong piq: Ngŏc nhum crôch, ngŏc nhum bùac wa taboc wa ngŏc gòh ngùi, ");
INSERT INTO hre_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","brong pôn: Ngŏc nhum nget wang, ngŏc gam wa ngŏc nhum wang bah. 'Bài ngŏc cô phai 'mùt ta khùan wang. ");
INSERT INTO hre_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Sôq 'bài ngŏc aih dìq dŏng 12 pliang, tiaq hiniq 'bài con Is-ra-ên, ta rìm tang pliang ngŏc jah pùng achìh hiniq da 12 hadròng hadrech Is-ra-ên troi wì pùng achìh teo hadro dìq. ");
INSERT INTO hre_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ìh phai broq 'bài hadrang caxi tagwat xam wang đenh ta capiac bac jang rada. ");
INSERT INTO hre_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Hi khoi, broq baiq toq gwiang xam wang đòiq ŏi jang baiq toq mùm gàu capiac. ");
INSERT INTO hre_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Càt pajùm baiq hadrang caxi wang mùt ta baiq toq gwiang nòi baiq toq gàu capiac, ");
INSERT INTO hre_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","wa baiq ha'mai caxi càt 'mùt ta glêh gwac, khoi èh apìq top ta baiq hadrang caxi bac êphot pah ngìa. ");
INSERT INTO hre_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ìh broq baiq toq gwiang xam wang đòiq jang baiq mùm 'neq da capiac bac jang rada pah êphot. ");
INSERT INTO hre_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Èh broq baiq gwiang 'noiq hòm xam wang apìq 'mùt baiq ha'mai enh 'neq ca caxi bac êphot pah ngìa ŏi enh 'nhèq ca caxi ca'nam haten ca nòi ha'mai. ");
INSERT INTO hre_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Hi khoi mòiq hadrang xenh jah càt baiq toq gwiang da capiac bac jang rada wa baiq gwiang êphot, đòiq hatop ca caxi bac, ùh hìaq clìh khoi ca êphot. ");
INSERT INTO hre_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“ 'Màng aih èh, jò leq Arôn mùt nòi hadròih, haq jah bac wê ta manoh cla 'bài hiniq con calô Is-ra-ên ta capiac rada hadrah ta-atoq, đòiq wèq broq bahmàng hlài hloi hloi jang ngìa Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ìh phai tah Urim wa Thumim 'mùt ta capiac rada hadrah ta-atoq, đòiq jò Arôn lam trùh jang ngìa Chuaq, èh 'bài ngè aih jah ŏi enh 'nhèq manoh cla haq. 'Màng aih, jang ngìa Chuaq, Arôn jah bac wê bìac hadrah da con calô Is-ra-ên enh 'nhèq manoh cla haq hloi hloi. ");
INSERT INTO hre_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ìh phai tenh eo yôh enh 'neq ca êphot dìq xam bai nhum xenh. ");
INSERT INTO hre_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ŏi ta'ne eo i mòiq toq trom 'mùt gàu mùt. Jìp dudan ca trom eo đòiq ùh hìaq dahich. ");
INSERT INTO hre_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ta ha'mai 'neq phai broq plì ôi rôm xam brai nhum xenh, gòh ngùi wa gòh mahem, wa yŏc clinh ninh xam wang 'yoh atua ta ha'mai ta'ne rìm tàng plì ôi rôm: ");
INSERT INTO hre_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ta ha'mai 'neq phai broq plì ôi rôm xam brai nhum xenh, gòh ngùi wa gòh mahem, wa yŏc clinh ninh xam wang 'yoh atua ta ha'mai ta'ne rìm tàng plì ôi rôm: ");
INSERT INTO hre_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Jò Arôn broq bìac patìh da pajàu ha'nhèq, haq phai caxùnh eo yôh aih. Jò haq mùt loq loh enh Nòi Dìq Jaq Hadròih jang ngìa Chuaq, rìm yàng wì jah tàng atêh clinh ninh wang 'yoh, èh Arôn claih cachìt 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ìh hadai broq mòiq toq capiac xam wang, enh crŏng aih pùng padì troi wì pùng padì teo hadro: HADRÒIH CA CHUAQ. ");
INSERT INTO hre_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Hi khoi yŏc mòiq hadrang brai nhum xenh càt ta capiac aih đòiq pah ngìa calôp côi. ");
INSERT INTO hre_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Capiac aih phai ŏi angòng Arôn, đòiq Arôn jah pòq tôiq thai ca jàn Is-ra-ên broq ùh troq jò wì haq dèch am ngè tadreo hadròih, capiac aih jah hloi hloi ŏi angòng Arôn, đòiq jàn Is-ra-ên jah lem manoh ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Ìh phai broq mòiq blah eo yôh taboc, eo aih i cŏng yôh, xam brai habùac lem, caxùnh enh dalam ca eo yôh nhum xenh. Hi khoi broq mòiq toq calôp xam bai habùac wa tenh mòiq toq caxi càt ti ca'nam. ");
INSERT INTO hre_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ìh hadai phai broq am ca 'bài con calô Arôn eo yôh taboc, tenh mòiq caxi càt ti ca'nam wa calôp côi, đòiq wì haq jah anì lem lình wa jah wì loq iu bìac pajàu. ");
INSERT INTO hre_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Khoi èh, yŏc 'bài blah eo aih caxùnh am ca Arôn daq ìh, wa 'bài con calô haq. Ìh phai xùt dàu ca wì haq đòiq lah crài wì haq loh hadròih, đòiq wì haq broq pajàu yòng tadreo jang ngìa Au. ");
INSERT INTO hre_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Phai broq am ca wì haq cwàn enh dalam xam bai habùac đòiq chê đac can rahòng, atàc pàng ca'nam trùh xèm cataih. ");
INSERT INTO hre_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Arôn wa con calô haq phai caxùnh eo aih jò mùt ta Hnem Traiq Cùh Waiq loq thia trùh haten ca ca'bŏng tadreo đòiq broq bìac am ngè tadreo ta nòi hadròih, èh ùh hìaq pòq tôiq ùh hìaq cachìt. “Aih mòiq trong ranenh hloi hloi am ca Arôn wa xinoi haq. ");
INSERT INTO hre_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Cô bìac ìh phai broq đòiq lah crài Arôn wa con calô haq loh hadròih, đòiq wì haq broq pajàu yòng tadreo jang ngìa Au: Rùp mòiq toq con 'bo calô bu chuai wa baiq toq trìu calô ùh i ca teo xìt leq, ");
INSERT INTO hre_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","yŏc dàc 'mau mì dìq jaq 'yêq broq 'benh ùh tah blo, 'benh nhim ùh tah blo alôn ti dàu, wa 'benh ratang ùh tah blo xùt xam dàu. ");
INSERT INTO hre_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Hi khoi đòiq 'benh aih ta mòiq rajo am pajùm hloi ti 'bo bu chuai wa baiq toq con trìu calô. ");
INSERT INTO hre_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Khoi èh, ìh thê Arôn wa 'bài con calô haq thia haten nòi 'mang Hnem Traiq Cùh Waiq, hi khoi yŏc diac 'nheo wì haq. ");
INSERT INTO hre_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Khoi ca aih, caxùnh am ca Arôn eo yôh taboc, eo yôh nhum xenh enh gùng ca eo taboc, êphot wa capiac bac jang ca rada, wa hadrang caxi bai atenh broq geo càt ca'nam. ");
INSERT INTO hre_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Pacôi calôp jang gàu wa đòiq capiac xam wang hadròih pah ngìa enh 'nhèq ca calôp. ");
INSERT INTO hre_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Yŏc dàu xùt, èh ùc dàu ca gàu haq. ");
INSERT INTO hre_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Èh thê 'bài con calô Arôn thia haten caxùnh eo yôh taboc ca wa haq. ");
INSERT INTO hre_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Yŏc hadrang caxi bai càt ca'nam wa pacôi calôp am ca Arôn wa 'bài con haq. 'Màng aih èh, wì haq jah i bìac broq pajàu yòng tadreo nhò trong ranenh pajaq hloi hloi am ca wì haq. “ 'Màng aih, ìh jah broq lè atŏc broq pajàu ca Arôn wa 'bài con calô haq. ");
INSERT INTO hre_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Hi khoi dùi 'ràng 'bo calô thia haten jang ngìa Hnem Traiq Cùh Waiq, èh Arôn wa 'bài con calô haq jah đòiq tì jang gàu 'bo. ");
INSERT INTO hre_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ìh pàc 'bo aih jang ngìa Chuaq, jang nòi 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Hi khoi yŏc tì 'nhrùq ta mahem 'bo aih, xùt ti aki da ca'bŏng tadreo, rah mahem ùc ta xèm ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Yŏc dìq ramaq ma lom cliac, ramaq lom clèm, baiq toq plì crŏng wa ramaq lom plì crŏng, 'ràng bùh ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mahaq jam 'bo aih, akia, wa ìch haq 'ràng bùh dìq enh gùng ca traiq, aih mòiq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Ìh dùi mòiq toq con trìu calô, èh Arôn wa 'bài con calô haq jah đòiq tì jang gàu trìu aih. ");
INSERT INTO hre_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Hi khoi pàc trìu aih, yŏc mahem da'rat dudan ca ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Khoi ca aih, xah trìu aih loh tang ha'nech, 'nheo hreo cliac wa jènh, đòiq pajùm ca 'bài ha'nech wa gàu haq. ");
INSERT INTO hre_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Hi khoi, bùh dìq ca chac con trìu aih ta ca'bŏng tadreo. Aih ngè tadreo bùh i hòi xua thùm am ca Chuaq. Aih ngè tadreo bùh xam ùnh am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Khoi èh, ìh rùp trìu calô yàng baiq, èh Arôn wa 'bài con calô haq jah đòiq tì jang gàu trìu. ");
INSERT INTO hre_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ìh phai pàc trìu aih, yŏc mahem xùt nòi hla don pah 'ma Arôn wa nòi hla don pah 'ma 'bài con calô haq, ti bôi hadrang can tì pah 'ma wa hadrang can jènh pah 'ma. Mahem ŏi i rah, ìh ùc dudan ca ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Yŏc mahem ŏi nòi ca'bŏng tadreo wa dàu xùt dàu da'rat ta chac wa ta eo Arôn, hadai da'rat ta chac wa eo 'bài con calô haq. 'Màng aih, Arôn wa eo cla haq, 'bài con calô haq wa eo wì haq jah lah crài broq hadròih. ");
INSERT INTO hre_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ìh phai yŏc ramaq, tenh, ramaq ma lom cliac, ramaq lom clèm, baiq toq plì crŏng pajùm ca ramaq top ta plì crŏng wa cataih haq pah 'ma, taiq nen trìu calô aih da lè atŏc broq pajàu. ");
INSERT INTO hre_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Èh hòm yŏc mòiq toq 'benh, mòiq toq 'benh nhim wa mòiq toq 'benh ratang alôn ti dàu, enh rojo 'benh ùh tah blo đòiq jang ngìa Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Hi khoi ìh đòiq dìq 'benh aih ta tì Arôn, wa ta tì 'bài con calô haq, đòiq am lam am hlài jang ngìa Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ìh phai yŏc enh tì wì haq 'ràng bùh ta ca'bŏng tadreo, đòiq waq ca i hòi xua thùm jang ngìa Chuaq, aih ngè tadreo bùh xam ùnh am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Hadai yŏc rada da trìu calô broq lè atŏc broq pajàu ca Arôn, èh atŏc am lam am hlài jang ngìa Chuaq. Aih phàn da ìh. ");
INSERT INTO hre_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“ 'Màng aih, ìh jah lah crài loh hadròih rada wa cataih da trìu calô, aih ngè khoi dèch am lam am hlài broq lè atŏc broq pajàu, aih phàn da Arôn wa 'bài con calô haq ma khoi atŏc hnhu am. ");
INSERT INTO hre_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ngè tadreo cô loh enh jàn Is-ra-ên am ca Arôn wa con calô haq. Tiaq troi ranenh ma khoi broq loh hloi hloi, aih bìac hnhu am enh 'bài ngè tadreo waiq catèm da jàn Is-ra-ên, aih ngè tadreo wì haq atŏc am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“ 'Bài eo hadròih da Arôn jah đòiq am hlài ca 'bài con calô 'mùt atìq ca haq, đòiq wì haq caxùnh eo aih ta jò lè xùt dàu wa lè atŏc broq pajàu. ");
INSERT INTO hre_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Con leq ta 'bài con calô haq ma broq pajàu ha'nhèq thai haq, phai caxùnh eo aih tapèh hì jò haq mùt Hnem Traiq Cùh Waiq đòiq broq bìac patìh ta Nòi Hadròih. ");
INSERT INTO hre_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ìh phai yŏc con trìu calô broq lè atŏc broq pajàu, èh pai jam trìu aih ta mòiq nòi hadròih. ");
INSERT INTO hre_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Arôn wa 'bài con calô haq phai caq jam trìu aih wa 'benh ma tah ta rajo nòi 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","'Màng aih, wì haq jah caq ngè nhò bìac jah rŏt hlài enh tôiq lôi, jò broq lè atŏc broq pajàu wa lè lah crài loh hadròih da wì haq. Mahaq toq mangai broq pajàu jah caq ngè aih, ma jah 'màng aih 'bài ngè aih khoi lah crài loh hadròih. ");
INSERT INTO hre_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Tàng i jam ŏi rah leq aih da lè lah crài loh hadròih, loq 'benh ŏi i rah trùh hì da èh, apaq caq mahaq bùh đac ta ùnh, ma jah 'màng aih ngè aih khoi hadròih. ");
INSERT INTO hre_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ìh phai broq ca Arôn wa 'bài con calô haq tiaq rìm bìac Au khoi thê. Ìh phai broq lè atŏc broq pajàu cô hloi tapèh hì. ");
INSERT INTO hre_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Rìm hì ìh phai am mòiq toq con 'bo calô đòiq rŏt hlài dađeh enh tôiq lôi. Hi khoi phai 'nheo ca'bŏng tadreo ma hreo tiaq broq lè rŏt dèch hlài enh tôiq lôi, wa broq lè lah crài loh hadròih. ");
INSERT INTO hre_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ta tapèh hì ìh broq lè rŏt hlài enh tôiq lôi am ca ca'bŏng tadreo wa lah crài ca'bŏng tadreo loh hadròih. Ca'bŏng tadreo jah wìa dìq jaq hadròih, èh ngè leq hi đùng trùh hadai jah hadròih. ");
INSERT INTO hre_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Cô ngè ìh phai hmàng broq am enh 'nhèq ca ca'bŏng tadreo: Baiq toq trìu con khoi jah mòiq hanam, rìm hì hloi hloi 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Daxroq ìh am mòiq toq trìu con, wa xèq dradrìch am mòiq toq. ");
INSERT INTO hre_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tiaq pajùm ti trìu con ma mòiq, phai i baiq li dàc 'mau mì 'yêq alôn ti mòiq li dàu ôliu, wa mòiq li alac plì nho đòiq broq lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Jò dèch am trìu con ma baiq xèq dradrìch, phai dèch ngè am 'benh 'mau mì wa lè dèch am dahwèq ôq 'màng troi lè jò daxroq, aih ngè tadreo bùh i hòi xua thùm dèch am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Aih ngè tadreo bùh pì ma ep am hloi hloi cwa 'bài 'nhòng jang Hnem Traiq Cùh Waiq enh ngìa Chuaq, aih nòi Au jah glàm ìh wa anoi ca ìh. ");
INSERT INTO hre_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","'Màng aih, jah i Au ta aih pajùm ca jàn Is-ra-ên, taiq can 'ngah 'ngai Au jah broq ca Hnem Traiq Cùh Waiq cô loh ca hadròih. ");
INSERT INTO hre_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Au jah lah crài Hnem Traiq Cùh Waiq wa ca'bŏng tadreo loh hadròih. Au hadai lah crài loh hadròih Arôn wa 'bài con calô haq đòiq wì haq broq pajàu yòng am tadreo jang ngìa Au. ");
INSERT INTO hre_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Au jah ŏi ta'ne jàn Is-ra-ên, broq Boc Plình da wì haq. ");
INSERT INTO hre_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Wì haq jah loq Au cô Chuaq Boc Plình da wì haq, khoi 'nong wì haq loh khoi ca Aicàp đòiq Au ŏi ta'ne wì haq. Au cô Chuaq Boc Plình da wì haq. ");
INSERT INTO hre_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ìh phai broq mòiq toq ca'bŏng xam long a-kê-si-a đòiq bùh jreo xua thùm. ");
INSERT INTO hre_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","“Ca'bŏng aih pôn pah ta-atoq: pah dang yôh 1 hagat, wa pah dang gat 1 hagat, pah ha'nhèq 2 hagat, broq pôn toq aki ta mùm ca'bŏng. ");
INSERT INTO hre_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ìh phai 'bìt wang enh 'nhèq, pôn pah panàt dudan wa 'bài aki, wa broq grôi xam wang dudan ca ca'bŏng. ");
INSERT INTO hre_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Enh 'neq ca trong grôi aih, nòi baiq pah mùm, broq baiq toq gwiang xam wang đòiq 'mùt long tanòng đòiq tòng. ");
INSERT INTO hre_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Broq long tanòng tòng xam long a-kê-si-a hi khoi 'bìt wang. ");
INSERT INTO hre_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ìh phai đòiq ca'bŏng bùh jreo xua thùm aih jang ngìa bai prình ma tù Hom Wêh Jao wa Calàp Baxŏng Tôiq, nòi Au jah glàm ìh. ");
INSERT INTO hre_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Rìm xroq jò Arôn palaoq đen, haq phai bùh jreo xua thùm ta ca'bŏng aih. ");
INSERT INTO hre_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Jò xèq dradrìch, Arôn bùh đen, haq phai bùh jreo xua thùm. Phai i jreo xua thùm bùh jang ngìa Chuaq hloi hloi, cwa rìm 'nhòng. ");
INSERT INTO hre_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ta ca'bŏng bùh jreo xua thùm cô apaq bùh jreo xua thùm 'noiq, hadai apaq dèch am ngè tadreo bùh, ngè tadreo xam dahwèq caq, loq lè am ngè ôq leq ma 'noiq. ");
INSERT INTO hre_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Mahaq rìm 'nhòng, mòiq hanam mòiq yàng, Arôn phai yŏc mahem ngè tadreo rŏt hlài enh tôiq lôi, xùt jang aki ca'bŏng bùh jreo xua thùm cô đòiq rŏt hlài enh tôiq lôi. Aih bìac dìq jaq hadròih am ca Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Chuaq hadai doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Jò leq ìh rèn jàn Is-ra-ên đòiq achìh hiniq, mòiq ngai jàn phai am 'bac rŏt dađeh am ca Chuaq. 'Màng aih, ùh hìaq i can hinìq ramòt leq loh ca wì jò ìh rèn sôq wì haq. ");
INSERT INTO hre_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Mangai leq i hiniq ta sô ep am mòiq hliac 'bac 'yoh wìa ngè hadròih am ca Chuaq. (Hliac 'bac cô 'ne siêclò tiaq siêclò da Hnem Traiq Cùh Waiq – aih troq 20 gêra). ");
INSERT INTO hre_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Rìm ngai i hiniq ta sô pàng 20 hanam dang tŏc, dìq phai am 'bac cô ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Jò hnhu am 'bac cô ca Chuaq đòiq đèn dađeh, mangai padrŏng can ùh am yi bàc, wa mangai pa ùh am yi 'biaq ca 'ne siêclò. ");
INSERT INTO hre_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","'Màng aih, ìh gop yŏc 'bac đèn dađeh da jàn Is-ra-ên, hi khoi yŏc 'bac aih đòiq jùp bìac ta Hnem Traiq Cùh Waiq, aih mòiq bìac bahmàng hlài da jàn Is-ra-ên jang ngìa Chuaq đòiq đèn dèh can rìh.” ");
INSERT INTO hre_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Ìh phai broq mòiq toq thùng càn wa jènh thùng xam đùng đòiq 'nheo, hi khoi đòiq ŏi ta'ne 'mang Hnem Traiq Cùh Waiq wa ca'bŏng tadreo, èh ùc diac ta thùng. ");
INSERT INTO hre_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Arôn wa 'bài con calô haq phai 'nheo dèh jènh tì cla ta thùng càn aih. ");
INSERT INTO hre_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Jò wì haq mùt ta Hnem Traiq Cùh Waiq, wì phai yŏc diac 'nheo dađeh waq ca wì haq claih ca cachìt, wa jò thia haten ca ca'bŏng tadreo đòiq patìh, aih bùh ngè tadreo yŏc ùnh am ca Chuaq, wì haq hadai ep wèq 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","'Màng aih èh, wì haq phai 'nheo tì wa jènh waq ca claih ca cachìt. Aih mòiq trong ranenh broq hloi hloi am ca Arôn wa xinoi haq cwa rìm 'nhòng atìq.” ");
INSERT INTO hre_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Gop 'bài ngè ma i hòi dìq jaq xua thùm: mùc jùac diac 6 kg, cwèq aih 3 kg, riah cachiq phùc 3 kg. ");
INSERT INTO hre_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Cwèq capiac 500 siêclò tiaq siêclò da Hnem Traiq Cùh Waiq, wa 4 lìt dàu ôliu. ");
INSERT INTO hre_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ìh phai yŏc 'bài ngè i hòi xua thùm aih alôn ca dabau broq loh dàu xua thùm đòiq broq dàu xùt hadròih. ");
INSERT INTO hre_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Khoi èh, yŏc xùt ca Hnem Traiq Cùh Waiq wa Hom Wêh Jao, ");
INSERT INTO hre_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ca'bŏng đòiq 'benh hadròih wa 'bài ranac, jènh đèn wa 'bài ranac, wa ca'bŏng bùh jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ca'bŏng tadreo bùh wa dìq ranac haq, thùng càn wa jènh thùng. ");
INSERT INTO hre_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","'Màng aih, ìh phai lah crài 'bài ngè cô loh hadròih waq ca broq dìq jaq hadròih. Tàng ngè leq hi achùq, aih jah wìa hadròih. ");
INSERT INTO hre_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Ìh phai xùt dàu ca Arôn wa ca 'bài con calô haq, lah crài loh hadròih, đòiq wì jah broq pajàu patìh ca Au. ");
INSERT INTO hre_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ìh hadai phai doi ca jàn Is-ra-ên: ‘Dàu cô jah broq dàu xùt hadròih am ca Au ta 'nhòng da pì atìq. ");
INSERT INTO hre_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ùh khòh ùc ta chac hamac mangai, hadai apaq broq dàu 'noiq crài tìah dàu aih, taiq dàu cô hadròih, wa hadai hadròih am ca pì. ");
INSERT INTO hre_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Tàng i mangai leq broq xua thùm tìah ca dàu aih, wa 'ràng da'rat ta chac mangai jàn 'noiq, jah 'bìq hnan đac loh khoi ca jàn Is-ra-ên.’ ” ");
INSERT INTO hre_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Chuaq doi hòm ca Môise: “Yŏc 'bài ngè xua thùm, ma pajùm bàc hiniq aih dahwèq xua thùm, riang yim hùang, phong chi hùang, wa nhù hùang. Rìm hiniq mòiq phàn. ");
INSERT INTO hre_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Tiaq trong alôn jreo, broq loh jreo xua thùm, tah tam boh, đòiq jah hliang wa hadròih. ");
INSERT INTO hre_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Yŏc mòiq 'nah padit haq loh dàc, hi khoi 'ràng jang ngìa hòm wêh jao ta Hnem Traiq Cùh Waiq, aih nòi Au jah glàm ìh. Phàn da ìh, jreo xua thùm cô dìq jaq hadròih. ");
INSERT INTO hre_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Apaq yŏc jreo xua thùm cô broq troi trong ma broq jreo am ca dađeh. Phai ngan jreo xua thùm cô hadròih am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Tàng mangai leq broq jreo xua thùm tìah 'màng aih đòiq am ca dađeh hìp hòi, mangai aih jah 'bìq hnan đac loh khoi ca jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Cô Au creo Bê-xa-lên, con calô da Uri, xau da Hurò, ta hadròng hadrech Juđa. ");
INSERT INTO hre_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Au khoi broq ca haq bình halùih Yiang da Boc Plình, i manoh thài, bìac khôn rabiaq, wa bìac loq 'nì, đòiq broq rìm bìac da thòq. ");
INSERT INTO hre_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Đòiq achìh 'mù wa broq loh 'bài ngè xam wang, xam 'bac wa xam đùng, ");
INSERT INTO hre_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","đòiq grau padì ngŏc wa 'mùt ngŏc padì, trah long wa broq thai rìm bìac da thòq. ");
INSERT INTO hre_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Cla Au hadai khoi ràih am mòiq ngai wiang patìh bìac, hiniq haq Ô-hô-li-ap, con calô da A-hi-sa-mac, hadròng hadrech Đan. Au hadai khoi tam manoh ragài ca 'bài mangai 'noiq, đòiq wì haq broq bìac Au ma khoi thê ìh: ");
INSERT INTO hre_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","aih Hnem Traiq Cùh Waiq, Hom Wêh Jao, Calàp Baxŏng Tôiq ŏi enh 'nhèq ca Hòm wa dìq ngè 'noiq ta Hnem Traiq Cùh Waiq, ");
INSERT INTO hre_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ca'bŏng đòiq 'benh hadròih wa 'bài ranac haq, jènh đèn wang wa 'bài ranac haq, ca'bŏng bùh jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ca'bŏng tadreo bùh wa 'bài ranac haq, thùng càn wa jènh thùng, ");
INSERT INTO hre_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","dìq ca eo lè, eo hadròih am ca Arôn pajàu ha'nhèq, wa 'bài eo am ca 'bài con calô haq đòiq broq pajàu yòng patìh, ");
INSERT INTO hre_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","dàu xùt wa jreo xua thùm da Nòi Hadròih. 'Bài mangai aih ep broq tiaq dìq dŏng ca bàu thê Au khoi doi ca ìh.” ");
INSERT INTO hre_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ìh phai doi ca jàn Is-ra-ên: ‘Pì phai wèq Hì Sabat da Au, aih mòiq teo patô ta'ne Au wa pì cwa rìm 'nhòng đòiq pì loq, Au Chuaq broq am ca pì wìa hadròih. ");
INSERT INTO hre_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘ 'Màng aih, pì phai wèq hì Sabat, aih hì hadròih am ca pì. Mangai leq broq 'mèq ca hì aih, ep 'bìq wì jêh đac, tàng mangai leq abroq ta hì aih, hadai 'bìq hnan đac loh khoi enh jàn dađeh. ");
INSERT INTO hre_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Pi abroq tadràu hì, mahaq hì tapèh, hì Sabat, aih hì padài hadròih am ca Chuaq. Ta hì Sabat tàng cabô abroq, ùh kè bìac cleq, jah 'bìq jêh đac. ");
INSERT INTO hre_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Taiq 'màng aih, jàn Is-ra-ên phai wèq Hì Sabat cwa rìm 'nhòng da wì haq, tìah ca mòiq toq wêh jao hloi hloi. ");
INSERT INTO hre_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Aih mòiq toq teo hloi hloi ta'ne Au wa jàn Is-ra-ên, ma jah 'màng aih Chuaq khoi broq loh plình wa crŏng taneh trom tadràu hì, mahaq hì tapèh Haq padài ha'naoq hlài padren.’ ” ");
INSERT INTO hre_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Chuaq doi ca Môise khoi anoi gêh ŏi ta bôi wang Sinai, èh Haq am ca Môise baiq toq capiac hmu i Bàu Wêh Jao nhò hadrang tì Boc Plình achìh loh. ");
INSERT INTO hre_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Jò jàn Is-ra-ên hnoq Môise ŏi ta bôi wang xòi loh, wì haq adràc dabau thia dudan ca Arôn, doi ca haq: “Broq ca nhèn mòiq toq dua 'mù đòiq lam adroi ca nhèn beq, ma jah 'màng aih phàn da Môise cô, mangai khoi 'nong nhèn loh khoi ca gùng Aicàp, nhèn ùh 'nì bìac cleq khoi loh ca haq.” ");
INSERT INTO hre_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Arôn tèu: “Dŏih 'bài hatai wang nòi don mai pì, con calô wa con cadrì pì beq, hi khoi 'ràng trùh ca au.” ");
INSERT INTO hre_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Dìq dŏng wì haq dŏih hatai wang nòi don cla, hi 'ràng ca Arôn. ");
INSERT INTO hre_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Arôn nhàn yŏc wang enh wì haq, tùh padì loh mòiq toq dua 'mù 'bo con xam wang. Jàn Is-ra-ên doi: “Ô Is-ra-ên, cô dua 'mù da pì ma khoi 'nong pì loh khoi ca gùng Aicàp oq.” ");
INSERT INTO hre_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Arôn hnoq 'màng aih, haq broq mòiq toq ca'bŏng cùh waiq jang ngìa dua 'mù 'bo con aih, khoi èh, haq cachech bàu dêh: “Xroq èh, jah i lè padèch Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Xrŏih xroq èh, jàn Is-ra-ên rìu xrŏih, am ngè tadreo bùh wa ngè tadreo waiq catèm, ha'ngui caq ôq, khoi èh yòng pagôq racaih. ");
INSERT INTO hre_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Chuaq doi ca Môise: “Loh beq, ma jah 'màng aih wì jàn ma ìh khoi 'nong loh enh Aicàp khoi broq bìac 'mèq 'mac, ");
INSERT INTO hre_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","khoi cađac trong da bàu thê Au, broq mòiq toq dua 'mù 'bo con, cùh waiq wa am tadreo ca haq, rai doi: ‘Ô Is-ra-ên, cô dua 'mù khoi 'nong pì loh khoi ca gùng Aicàp!’ ” ");
INSERT INTO hre_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Chuaq doi ca Môise: “Au khoi hnoq jàn cô, jàn cadoq cadang. ");
INSERT INTO hre_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","'Màng aih, manàiq cô đòiq ca Au broq beq, waq ca can nòih Au yòng tajraq ca wì haq, hi jêh đac wì haq. Hi khoi, Au jah broq ca ìh wìa mòiq jàn càn.” ");
INSERT INTO hre_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Môise waiq xìn Chuaq Boc Plình haq: “Waiq Chuaq, gleq ma loh nòih ca jàn cla Ìh? Aih jàn Ìh khoi yŏc cwìang càn caiq 'nong loh khoi ca gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Gleq mangai Aicàp ma jah doi: ‘Jò 'nong wì haq loh, Chuaq i manoh enh ngang dù đòiq raliang jêh đac wì haq ta wang, wa jêh đac wì haq hloi enh crŏng taneh? Waiq xìn Chuaq ngach ca can nòih wa cađac bìac Ìh ma enh ca'nìh ca jàn Ìh. ");
INSERT INTO hre_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Xìn Chuaq hmàng hlài ca Ap-ra-ham, Isac, Is-ra-ên, 'bài hapŏng Ìh. Ìh ma khoi patô dađeh pachac ca wì haq: Au jah am tam ca xinoi pì tŏc bàc tìah ca halŏng ta plình. Au jah am ca xinoi aih dìq ca gùng Au ma patô, èh wì haq jah yŏc gùng aih broq xôxech hloi hloi.’ ” ");
INSERT INTO hre_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","'Màng aih Chuaq cađac 'mèq ranàc càn Haq ma doi ca'nìh dèh ca jàn cla Haq. ");
INSERT INTO hre_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Khoi èh, Môise loh enh bôi wang. Tì haq wê baiq capiac hmu achìh Ranenh Wêh Jao; capiac hmu aih i achìh chù baiq pah, pah cô wa pah tau. ");
INSERT INTO hre_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Baiq capiac aih bìac Boc Plình broq loh chù, aih chù Boc Plình grau ta capiac. ");
INSERT INTO hre_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Èh Jôsuê tàng bàu jàn brêu, haq doi ca Môise: “Ta traiq i atêh tajêh poh.” ");
INSERT INTO hre_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Môise tèu: “Ùh xài bàu cachech tajêh 'blêq, ji ùh xài bàu cachech tajêh ùh 'blêq, mahaq Au tàng bàu mangai calêu.” ");
INSERT INTO hre_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Jò trùh haten ca traiq, Môise hnoq 'bo con wang wa mangai nhaiq muaq, haq nòih, hwenh đac baiq capiac hmu achìh Ranenh khoi enh tì haq, padah nòi jènh wang. ");
INSERT INTO hre_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Khoi èh haq yŏc dua 'mù 'bo con xam wang da jàn ma broq, 'ràng bùh ta ùnh, hi khoi padit bahech loh dàc, rai ta diac èh ep jàn Is-ra-ên ôq. ");
INSERT INTO hre_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Môise doi ca Arôn: “Jàn cô khoi broq cleq ca ìh ma ìh 'nong wì haq broq tôiq càn 'màng aih?” ");
INSERT INTO hre_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Arôn tèu: “Xìn ìh apaq nòih ca au. Ìh loq jàn cô xôq i manoh loq enh broq bìac ngan dù. ");
INSERT INTO hre_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Wì haq doi ca au: ‘Broq loh mòiq dua 'mù lam adroi ca nhèn beq, taiq phàn da Môise mangai khoi 'nong nhèn loh khoi ca gùng Aicàp, nhèn ùh 'nì bìac cleq khoi trùh ca haq.’ ");
INSERT INTO hre_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Au doi ca wì haq: Cabô i wang 'noh beq. Wì haq am ca au wang. Au tah ta ùnh hi khoi tùh loh mòiq toq 'bo con xam wang cô.” ");
INSERT INTO hre_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","'Màng aih Môise hnoq jàn Is-ra-ên pi jah padràng dađeh, ma jah 'màng aih Arôn khoi đòiq wì haq 'màng aih, trùh 'mòi wì 'bìq jù lê ta 'bài lình jàn 'noiq ma tagit wì haq. ");
INSERT INTO hre_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Môise yòng nòi 'mang traiq, hi doi: “Cabô i manoh ŏi pah Chuaq, thia trùh ta au beq.” Dìq dŏng mangai Lêwi tagop dabau thia haten pah haq. ");
INSERT INTO hre_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Môise doi ca wì haq: “Chuaq Boc Plình da jàn Is-ra-ên, doi 'màng cô: Rìm ngai ta pì wê chang gùm ti chac cla beq, lam cwa lam hlài ta traiq, enh 'mang cô trùh 'mang tau wa rìm ngai pì jêh đac oh daq, bua wa mangai haten hatìa bèn.” ");
INSERT INTO hre_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Mangai Lêwi broq tiaq troi bàu Môise. Hì aih ùac aiq i 3.000 mangai cachìt. ");
INSERT INTO hre_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Èh Môise doi: “Hì cô pì khoi lah crài loh hadròih ca dađeh am ca Chuaq, taiq pì ùh adenh jêh dèh ca 'bài con calô wa oh daq cla, waq ca pì jah xôq ramŏt da Chuaq 'màng aih.” ");
INSERT INTO hre_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Hì atìq, Môise doi ca jàn Is-ra-ên: “Pì khoi broq tôiq dìq ca jaq càn, mahaq manàiq cô, au tŏc hlài ta bôi wang waiq dang Boc Plình, ùac aiq Chuaq jah baxŏng tôiq ca pì.” ");
INSERT INTO hre_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","'Màng aih Môise tŏc ta bôi wang waiq dang Chuaq: “Chuaq ôi! Jàn cô khoi broq tôiq càn, wì broq ca dađeh dua 'mù xam wang! ");
INSERT INTO hre_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mahaq manàiq cô xìn Chuaq baxŏng tôiq da wì haq! Tàng ùh, xìn xùt đac hiniq au khoi ca sech ma Ìh khoi achìh!” ");
INSERT INTO hre_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Chuaq tèu Môise: “Mangai leq broq tôiq ca Au, Au jah xùt đac hiniq cla haq khoi ca sech Au. ");
INSERT INTO hre_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Manàiq cô lam beq, 'nong jàn lam trùh nòi Au khoi patô đòiq. 'Bình Plình Au jah lam adroi ca ìh, mahaq hì leq Au hadrah baxa èh, Au jah baxa wì haq taiq tôiq lôi wì haq khoi broq.” ");
INSERT INTO hre_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Chuaq baxa jàn cô xam can hinìq ramòt taiq wì haq khoi broq tôiq bìac broq dua 'mù 'bo con xam wang Arôn ma broq loh. ");
INSERT INTO hre_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Chuaq doi ca Môise: “Ìh wa jàn ìh ma 'nong loh khoi ca gùng Aicàp, lam enh cô tŏc ta gùng Au khoi pachac am ca Ap-ra-ham, Isac, Jacôp, aih gùng Au am ca xinoi ìh. ");
INSERT INTO hre_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Au jah thê mòiq 'Bình Plình lam adroi ca ìh, hnan đac jàn Ca-na-an, jàn A-mô-rit, jàn Hêtit, jàn Pe-rê-xit, jàn Hêwit, wa jàn Jê-bu-xit. ");
INSERT INTO hre_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Pì lam mùt ta taneh ma i bàc diac sùa wa diac xùt, mahaq Au ùh lam ti pì taiq pì jàn cadoq manoh, yùq Au jêh đac pì ti trong lam.” ");
INSERT INTO hre_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Jò jàn tàng bàu pa'nhùq cô, dìq ca jàn hmoi, tìah ca i mangai cachìt ùh i ca mangai leq bac ngè anì. ");
INSERT INTO hre_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ma jah 'màng aih Chuaq khoi doi ca Môise: “Doi ca jàn Is-ra-ên: ‘Pì cadoq manoh. Tàng Au lam tì pì mòiq rahyàc raq, èh Au loq jêh đac pì. 'Màng aih, manàiq cô pì phai dŏih dŏng 'bài ngè anì ta chac pì beq, trùh jò Au chaq trong leq tabroq ca pì 'màng leq.’ ” ");
INSERT INTO hre_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","'Màng aih èh, enh bôi wang Hôrêp jàn Is-ra-ên khoi dŏih dŏng hloi dèh ngè bac anì cla wì haq. ");
INSERT INTO hre_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Môise yŏc dèh traiq 'ràng đòiq hangai enh gùng ca traiq jàn. Haq creo traiq cô: “Traiq Nòi Glàm”, èh cabô enh waiq dang Chuaq, mangai aih lam trùh ta traiq waiq dang aih enh gùng ca traiq jàn. ");
INSERT INTO hre_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Jò Môise loh bu trùh jang traiq, èh dìq ca jàn yòng, rìm ngai yòng dèh nòi 'mang traiq cla, ngan tiaq Môise trùh hloi jò haq khoi mùt ta traiq. ");
INSERT INTO hre_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Jò haq bu mùt ta traiq, èh cato yùc loh yòng jang 'mang traiq, Chuaq anoi tùang ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Dìq ca jàn hnoq cato yùc yòng jang 'mang traiq, dìq ca wì haq yòng jang 'mang traiq dađeh đòiq cùh waiq. ");
INSERT INTO hre_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Chuaq ta ngìa jang ta Môise jò Haq doi tùang, tìah ca mangai capoch tùang dèh ca bua. Khoi èh, Môise wìh hlài ta traiq jàn, mahaq Jôsuê, con calô radam da Nun ma patìh da haq, ùh loh khoi enh traiq. ");
INSERT INTO hre_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Môise doi ca Chuaq: “Chuaq khoi doi ca au: ‘ 'Nong jàn cô,’ mahaq Chuaq ùh am Au loq Chuaq thê cabô lam ti Au. Chuaq hadai i doi ca au: ‘Au loq ca hiniq ìh wa ìh khoi jah i bìac am dech jang ngìa Au.’ ");
INSERT INTO hre_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","'Màng aih, manàiq cô, tàng Au khoi jah bìac am dech jang ngìa Chuaq, xìn Ìh patô ca au trong da Ìh đòiq au jah bìac dech am enh ngìa ca Ìh. Ìh hadai hèm ngan jàn cô aih jàn da Ìh.” ");
INSERT INTO hre_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Chuaq tèu bàu: “Cla Au raq lam ti ìh wa Au jah am ca ìh padài.” ");
INSERT INTO hre_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Môise doi ca Chuaq: “Tàng cla Ìh ùh lam, xìn apaq 'ràng nhèn lam khoi nòi cô. ");
INSERT INTO hre_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Yŏc nen leq wì ma jah loq ca au wa jàn Ìh jah i bìac lem manoh jang ngìa Ìh tàng Chuaq ùh lam ti nhèn? 'Màng aih èh, au wa jàn Ìh jah lah crài ca dìq ca jàn ma 'noiq ta crŏng taneh.” ");
INSERT INTO hre_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Chuaq doi ca Môise: “Au jah broq bìac ìh waiq xìn Au, ma jah 'màng aih ìh broq lem manoh Au wa taiq Au khoi canao loq manoh enh da ìh.” ");
INSERT INTO hre_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Môise bòch: “Au xìn Ìh am ca au ngan can 'ngah 'ngai da Ìh.” ");
INSERT INTO hre_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Chuaq doi: “Au jah broq bìac khôn khaoq da Au pa'noh loh jang ngìa ìh ràu hiniq Chuaq jang ngìa ìh, hnhu bìac am dech ca mangai leq Au enh am wa xa-ŏch ca cabô Au enh xa-ŏch.” ");
INSERT INTO hre_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Mahaq Haq doi: “Ìh ùh jah hnoq hadrò Au, ma jah 'màng aih ùh i ca cabô hnoq hadrò Au, èh ma ŏi jah rìh.” ");
INSERT INTO hre_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Èh Chuaq doi: “Cô i mòiq nòi haten ca Au, ìh yòng enh 'nhèq hmu beq. ");
INSERT INTO hre_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Jò can 'ngah 'ngai Au lam cwa pagat, Au jah đòiq ìh ŏi ta còp hmu, yŏc tì da Au chê ìh trùh jò Au khoi lam cwa. ");
INSERT INTO hre_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Au jah dŏih hlài dèh tì, wa ìh hnoq pah crŏng Au, mahaq ùh jah hnoq hadrò Au.” ");
INSERT INTO hre_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Chuaq doi ca Môise: “Ìh phai broq òn baiq capiac hmu tìah ca baiq capiac ma adroi, hi khoi Au achìh hlài chù ta baiq capiac hmu cô bàu khoi achìh ta baiq capiac ìh ma khoi broq padah. ");
INSERT INTO hre_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Xroq èh ìh padon tŏc ta bôi wang Sinai, yòng jang ngìa Au ta nòi aih. ");
INSERT INTO hre_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ùh i ca cabô khòh tŏc ti ìh. Jàp ta wang ùh khòh i mangai, trìu 'bo hadai ùh khòh caq nhat enh ngìa bôi wang cô.” ");
INSERT INTO hre_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Môise broq baiq capiac hmu tìah ca baiq capiac hmu ma adroi. Haq rìu xrŏih wê baiq capiac hmu aih, tŏc ta bôi Wang Sinai, troi bàu Chuaq khoi tanap. ");
INSERT INTO hre_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Chuaq loh ta yùc yòng haten ca Môise wa ràu hiniq Haq, aih Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Haq lam pagat ti ngìa Môise, doi: “Au cô Chuaq! Chuaq Boc Plình xòi nòih, bình halùih can xa-ŏch xam manoh loq waq wa bàu joq 'nàng, ");
INSERT INTO hre_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","wa am can xa-ŏch xam manoh loq waq trùh bình ngŏng 'nhòng, baxŏng bìac ngang dù, bìac ùh tiaq Ranenh wa tôiq lôi, mahaq ùh đòiq mangai i tôiq claih ca baxa. Haq yŏc tôiq boc yaq baxa hlài con xau trùh piq pôn 'nhòng.” ");
INSERT INTO hre_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Môise hôiq haiq cùp gàu ta taneh wa cùh waiq. ");
INSERT INTO hre_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Haq doi ca Chuaq: “Waiq Chuaq, tàng au jah lem manoh jang ngìa Chuaq, xìn lam ta'ne nhèn beq, 'nhac ca jàn cô jàn cadoq manoh, xìn Ìh baxŏng bìac ngang dù wa tôiq lôi nhèn, wa nhàn nhèn broq xôxech Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Chuaq doi: “Cô, Au broq mòiq toq wêh jao. Jang ngìa jàn da ìh, Au jah broq bìac halac 'nhòq lah i broq ta crŏng taneh, loq ta nòi jàn leq. Dìq dŏng ca jàn Is-ra-ên ta nòi pì, jah ngan hnoq bìac Chuaq, ma jah 'màng aih bìac Au padon broq cwa pì, aih bìac đang ca ramòt. ");
INSERT INTO hre_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Phai wèq manoh dì tiaq bàu thê Au doi ca ìh hì cô. Èh Au hnan đac mangai jàn A-mô-rit, jàn Ca-na-an, jàn Hêtit, jàn Pe-rê-xit, jàn Hêwit wa jàn Jê-bu-xit. ");
INSERT INTO hre_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Phai ngan kenh apaq broq wêh jao ti jàn da gùng pì ma padon mùt, yùq bìac aih wìa bu dàng manet ca pì. ");
INSERT INTO hre_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mahaq phai raliang đac dìq ca'bŏng tadreo, tùq padah đac long jrang cùh waiq wa raliang đac jrang dua 'mù cadrì A-sê-ra da wì haq. ");
INSERT INTO hre_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","'Màng aih apaq cùh waiq yiang ma 'noiq, taiq Chuaq, hiniq Haq aih Tagrình, Haq Boc Plình loq tagrình, ");
INSERT INTO hre_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Phai ngan kenh apaq broq wêh jao ti jàn gùng aih, yùq jò wì haq tango ti 'bài can kiac da wì haq wa tadreo ca 'bài can kiac wì haq, èh i mangai akhen pì caq jam tadreo wì haq. ");
INSERT INTO hre_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Apaq am con calô pì yŏc con cadrì wì haq, yùq jò con cadrì wì haq tango ti 'bài can kiac, wì haq padô alùan con calô pì hadai broq tango ti 'bài can kiac dù da wì haq, èh bìac aih tajraq hlài ca Au. ");
INSERT INTO hre_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Apaq broq ca dađeh dua 'mù. ");
INSERT INTO hre_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Phai wèq Lè Caq 'Benh Ùh Tah Blo trom tapèh hì, troi Au khoi thê, ma jah 'màng aih wop khê aih, pì loh khoi ca gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ 'Bài con ramua dìq hlài da Au, dìq con calô da ngè aban pì, wa dìq con ramua enh calùh 'bo wa calùh trìu. ");
INSERT INTO hre_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mahaq phai rùp mòiq toq trìu loq mòiq toq bubi đòiq rŏt hlài mòiq toq con lùa ramua. Tàng ùh rŏt hlài haq, èh phai goh ranŏng haq. Phai rŏt hlài dèh rìm con ramua cla. “Apaq i cabô leq lam tì dech jò thia trùh yòng jang ngìa Au. ");
INSERT INTO hre_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Tadràu hì phai abroq, mahaq cwa hì ma tapèh phai padài, 'nhac ca jò cai loq jò gat, pì xôq ep padài 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Gàu mùa jò gat 'mau mì, pì ep wèq Lè Hiniang Da 'Bài Tùang wa Lè Hiniang Gop Plì cloh hanam. ");
INSERT INTO hre_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Mòiq hanam piq yàng, rìm ngai gù calô phai yòng jang ngìa Chuaq, Haq Chuaq Boc Plình da jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ma jah 'màng aih Au hnan jàn 'noiq adroi ca pì, èh broq acang gùng taneh yi ròng, èh ùh i jàn 'noiq enh ta'miaq yŏc gùng taneh da pì jò pì tŏc cùh waiq Chuaq mòiq hanam piq yàng. ");
INSERT INTO hre_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Apaq am tadreo xam mahem da ngè tadreo da Au pajùm ti 'benh tah blo. Jam ngè am tadreo da Lè Lam Cwa ùh khòh đòiq trùh xroq atìq. ");
INSERT INTO hre_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Phai 'ràng am plì long gàu mùa da taneh 'mùt ta hnem Chuaq Boc Plình pì. “Apaq pai jam bubi con ta diac tôh miq haq.” ");
INSERT INTO hre_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Chuaq hadai doi ca Môise: “Achìh yŏc bàu cô beq, ma jah 'màng aih taiq bàu cô au ma jah wêh jao ca ìh wa ca jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Môise ŏi ta aih ti Chuaq 40 hì 40 mang, ùh caq 'benh wa ùh ôq diac. Chuaq achìh bàu wêh jao ta baiq capiac hmu, aih Mòiq Jàt Bàu Thê da Ranenh. ");
INSERT INTO hre_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Jò Môise wê baiq capiac hmu achìh Ranenh loh enh bôi wang Sinai, Haq ùh loq dèh ca hadrò cla 'ngah ca-ah, taiq haq yòng hatùang ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Arôn wa dìq ca jàn Is-ra-ên ngan Môise hnoq hadrò haq 'ngah ca-ah, wì crè ùh hùa thia haten. ");
INSERT INTO hre_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Môise creo ca wì haq, hi khoi Arôn wa 'bài gu craq jàn Is-ra-ên thia haten, èh Môise hatùang ca wì haq. ");
INSERT INTO hre_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Atìq ca aih, dìq ca jàn Is-ra-ên thia haten, hi khoi Môise thê wì haq dì tiaq dìq ca bìac da Chuaq khoi anoi ca haq ta bôi Wang Sinai. ");
INSERT INTO hre_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Jò Môise hêq capoch tùang ca wì, haq yŏc bai chê dèh hadrò cla. ");
INSERT INTO hre_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Jò Môise mùt jang ngìa Chuaq đòiq capoch tùang, haq dŏih bai chê hadrò trùh jò leq haq loh enh gùng anoi ca jàn Is-ra-ên rìm nà bàu thê da Chuaq ma khoi doi ca haq. ");
INSERT INTO hre_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Jò aih jàn Is-ra-ên ngan hadrò Môise hnoq hadrò haq 'ngah ca-ah, èh Môise yŏc bai chê dèh hadrò trùh jò mùt yòng capoch tùang ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Môise tagop dìq dŏng jàn Is-ra-ên ŏi mòiq nòi hi doi ca wì: “Cô bàu Chuaq thê pì broq: ");
INSERT INTO hre_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Tadràu hì pì phai abroq, mahaq hì tapèh aih hì hadròih, aih Hì Sabat, hì padài hadròih am ca Chuaq. Cabô abroq ta hì aih phai 'bìq jêh đac. ");
INSERT INTO hre_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ta Hì Sabat ùh hnem leq da pì jah patep ùnh.” ");
INSERT INTO hre_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Môise doi dìq dŏng ca jàn Is-ra-ên: “Cô bàu Chuaq khoi doi: ");
INSERT INTO hre_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Yŏc mòiq 'nah dahwèq leq ŏi ta hnem am ca Chuaq beq. Tàng mangai leq i manoh joq 'nàng enh am, 'ràng am ca Chuaq: Wang, 'bac, đùng, ");
INSERT INTO hre_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","brai habùac lem nhum xenh, gòh ngùi wa gòh mahem, wa xàc bubi, ");
INSERT INTO hre_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","akia trìu calô nhum gòh, akia ca nùac wa long a-kê-si-a, ");
INSERT INTO hre_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","dàu bùh đen broq 'ngah, 'bài dahwèq xua thùm đòiq broq dàu xua thùm xùt wa hòi xua thùm, ");
INSERT INTO hre_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ngŏc gam wa 'bài ngŏc ma 'noiq đòiq tah ta êphot wa capiac bac arada. ");
INSERT INTO hre_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Dìq dŏng ta pì i mangai leq ragài tì, phai lam trùh broq bìac Chuaq khoi thê: ");
INSERT INTO hre_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Hnem Traiq Cùh Waiq: Cùa po hnem, glêh, long ban, pang, long jrang wa xèm i calŏih 'mùt long jrang. ");
INSERT INTO hre_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Hom Wêh Jao ti long tanòng tòng, Calàp Baxŏng Tôiq, wa bai prình chê nòi dìq jaq hadròih, ");
INSERT INTO hre_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","dìq ca'bŏng wa long tanòng tòng, 'bài ranac patìh da ca'bŏng wa 'benh hadròih, ");
INSERT INTO hre_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","jènh đen, ranac patìh, 'bài đen wa dàu bùh đen, ");
INSERT INTO hre_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ca'bŏng bùh jreo xua thùm wa long tanòng tòng, dàu xùt, ngè xua thùm wa blah bai prình chê 'mang Hnem Traiq Cùh Waiq; ");
INSERT INTO hre_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ca'bŏng tadreo am ngè tadreo bùh wa jàn xam đùng, long tanòng wa 'bài ranac patìh da ca'bŏng tadreo, thùng càn wa jènh thùng, ");
INSERT INTO hre_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Bai prình pagia, long jrang wa calŏih long jrang, blah Bai prình da 'mang pagia. ");
INSERT INTO hre_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Cŏc đêq da hnem cùh waiq, cŏc đêq wa caxi da pagia, ");
INSERT INTO hre_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Eo anì lem lình đòiq caxùnh jò broq bìac nòi hadròih, eo hadròih am ca Arôn pajàu ha'nhèq Boc Plình, wa eo am ca 'bài con calô haq đòiq broq bìac patìh Chuaq.” ");
INSERT INTO hre_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hi khoi dìq ca jàn Is-ra-ên lam khoi ca Môise. ");
INSERT INTO hre_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Rìm ngai jah tadroq manoh, wa i manoh loq enh am, 'ràng ngè trùh am ca Chuaq đòiq broq bìac Hnem Traiq Cùh Waiq, 'bài ranac wa eo hadròih. ");
INSERT INTO hre_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","'Bài gu calô wa 'bài gu cadrì ma i manoh loq enh joq 'nàng, 'ràng trùh 'bài hatai, canhàng mùh wa tì, maih wa 'bài ngè ma lem broq xam wang, dìq dŏng am ngè xam wang ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Mangai leq ta hnem wì haq i brai nhum xenh, gòh ngùi wa gòh mahem, bai habùac lem, xàc bubi, akia trìu calô nhum gòh wa akia ca nùac, 'ràng trùh, đòiq dèch am. ");
INSERT INTO hre_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Mangai leq i ngè xam 'bac loq xam đùng, 'ràng am ca Chuaq. Mangai leq i long a-kê-si-a ta hnem cla, 'ràng pajùm đòiq broq bìac patìh. ");
INSERT INTO hre_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","'Bài gu cadrì ma thài bìac caxenh brai, 'ràng brai leq ma khoi caxenh, aih brai nhum xenh, gòh ngùi wa gòh mahem, wa bai habùac lem. ");
INSERT INTO hre_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","'Bài gu cadrì ma 'noiq i manoh tadroq wa thài ca broq, caxenh xàc bubi. ");
INSERT INTO hre_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","'Bài mangai broq gàu ta jàn 'ràng dèch am ngŏc gam, wa 'bài ngŏc ma 'noiq đòiq mùt ta êphot wa capiac bac jang rada; ");
INSERT INTO hre_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","dàu bùh đen, 'bài ngè xua thùm đòiq broq dàu xùt wa dàu xua thùm. ");
INSERT INTO hre_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Dìq ca jàn Is-ra-ên, gu calô loq gu cadrì, phàn mangai i manoh tadroq, 'ràng ngè tabàih am ca Chuaq tiaq Haq khoi thê Môise đòiq broq bìac Chuaq. ");
INSERT INTO hre_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Môise doi ca jàn Is-ra-ên: “Chuaq khoi ràih Bê-xa-lên, con calô da Uri, xau Hurò ta hadròng hadrech Juđa. ");
INSERT INTO hre_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Haq khoi 'mùt ca Bê-xa-lên bình halùih Yiang Boc Plình, khoi am ca haq can khôn rabiaq, manoh thài, wa bìac loq 'nì, đòiq broq rìm bìac ngè da thòq. ");
INSERT INTO hre_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Haq mangai thòq thài dìq jaq đòiq broq ngè xam wang, xam 'bac wa đùng. ");
INSERT INTO hre_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Haq mangai thòq i manoh thài ca pùng padì wa 'bìt 'bài ngŏc, wa pùng padì long broq 'bài ngè rabiaq dìq jaq. ");
INSERT INTO hre_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Boc Plình 'mùt tam ta Bê-xa-lên wa hadai am ca Ô-hô-li-ap con da A-hi-sa-mac ta hadròng hadrech Đan, can thài ca hnài. ");
INSERT INTO hre_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Boc Plình 'mùt am ca wa baiq ngai aih bình halùih bìac khôn rabiaq đòiq broq bìac thòq, thòq cat ngŏc, thòq pùng padì, thòq jìp achìh, thòq atenh brai nhum xenh, gòh ngùi wa gòh mahem ŏi ti bai habùac lem, đòiq broq thòq rìm bìac, rìm trong. ");
INSERT INTO hre_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bê-xa-lên, Ô-hô-li-ap wa 'bài thòq, aih 'bài mangai Boc Plình khoi 'mùt am can khôn rabiaq, manoh ragài ca broq wa bìac loq 'nì, đòiq broq dìq ca ngè ta Hnem Traiq Cùh Waiq, waq ca broq rìm bìac Chuaq ma khoi thê broq.” ");
INSERT INTO hre_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Èh Môise creo ca Bê-xa-lên, Ô-hô-li-ap wa 'bài mangai i manoh thài, wì ma Chuaq khoi 'mùt manoh ragài ca broq, rìm ngai i manoh tadroq thê dèh cla lam trùh haten đòiq broq bìac. ");
INSERT INTO hre_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Wì haq khoi nhàn dìq ca ngè enh Môise, ma jàn Is-ra-ên khoi 'ràng trùh đòiq broq bìac cùh waiq ta Hnem Traiq Cùh Waiq. Rìm xroq, jàn xôq 'ràng hòm ngè to am đeh. ");
INSERT INTO hre_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","'Màng aih èh, 'bài mangai thòq ragài broq rìm bìac da Hnem Traiq Cùh Waiq, padài đò abroq, ");
INSERT INTO hre_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","lam trùh ta Môise, hi doi: “Mangai jàn khoi 'ràng trùh bàc ngè yi hnao ma nhet đòiq broq bìac Chuaq khoi thê nhèn broq.” ");
INSERT INTO hre_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","'Màng aih Môise thê wì haq lam tang traiq doi: “Xìn rìm ngai, gu calô loq gu cadrì pi jah am dahwèq broq Hnem Traiq Cùh Waiq hòm.” 'Màng aih wì haq tàt jàn pi am 'ràng trùh cleq hòm. ");
INSERT INTO hre_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ma jah 'màng aih, khoi tàu 'bài ngè đòiq broq dìq bìac broq, èh xôq ŏi i rah. ");
INSERT INTO hre_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","'Bài mangai thòq ragài ta wì tenh 10 blah bai prình xam brai habùac lem, i brai nhum xenh, gòh ngùi wa gòh mahem, wa nhò Bê-xa-lên thòq ragài, tenh 'mù chê-ru-bim dìq jaq geo. ");
INSERT INTO hre_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Mòiq blah bai yôh 28 hagat, dang gat 4 hagat. Rìm blah bai prình i mòiq maneh. ");
INSERT INTO hre_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Wì haq broq padam blah bai prình ta'mùt loh mòiq wa padam blah bai prình ma 'noiq ta'mùt loh mòiq. ");
INSERT INTO hre_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","jìp rawiang brai nhum xenh ta ha'mai bai prình blah ma mòiq, èh phai jìp rawiang brai nhum xenh ta ha'mai bai prình ma baiq. ");
INSERT INTO hre_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","wì haq broq 50 toq rawiang ca ha'mai blah bai prình ma mòiq, wa 50 toq rawiang ca ha'mai blah bai prình ma baiq; 'bài rawiang baiq pah phai ta ngìa 'nah ca dabau đòiq jah ta'mŏt pajùm. ");
INSERT INTO hre_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Khoi èh wì haq broq 50 toq glêh xam wang, hi khoi ta'mŏt baiq toq blah bai prình pajùm wìa mòiq am ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Khoi ca aih, wì haq broq 11 blah bai prình xam xàc bubi, đòiq broq cùa Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","11 blah bai prình cô phai i mòiq maneh tìah ca dabau, dang yôh 30 hagat, wa dang gat 4 hagat. ");
INSERT INTO hre_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Wì haq jìp raclep padam blah bai prình cô, èh jìp raclep ca dabau tadràu blah bai prình tau. ");
INSERT INTO hre_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Èh wì haq broq 50 toq rawiang ta ha'mai bai prình blah ma mòiq, èh 50 toq rawiang ta ha'mai bai prình blah ma baiq. ");
INSERT INTO hre_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Èh wì haq broq 50 toq rawiang ta ha'mai ta bai prình blah ma mòiq, èh 50 toq rawiang ta ha'mai ta bai prình blah ma baiq. ");
INSERT INTO hre_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Wì haq broq mòiq capiac xam akia trìu calô nhum gòh đòiq enh cùa hnem traiq cùh waiq, wa broq mòiq capiac xam akia ca nùac glàp tam enh 'nhèq hòm. ");
INSERT INTO hre_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Wì haq yŏc capiac ban long a-kê-si-a broq panàt pa'nàng hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Mòiq capiac yôh 10 hagat, pah dang gat 1 hagat 'ne. ");
INSERT INTO hre_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Mòiq capiac ban i baiq toq calŏih hatìa ca dabau: Dìq ca long ban Hnem Traiq Cùh Waiq broq tiaq mòiq trong cô. ");
INSERT INTO hre_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Wì haq broq 20 capiac long ban pah 'ma ca mat mahì loh da Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Enh 'neq ca 20 capiac wì haq broq 40 toq calŏih xam bac. Enh 'neq ca mòiq capiac i baiq toq calŏih. ");
INSERT INTO hre_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Wì haq hadai broq 20 capiac long ban pah 'ngeo ca mat mahì loh Hnem Traiq Cùh Waiq, ");
INSERT INTO hre_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","wa 40 toq calŏih xam 'bac enh 'neq rìm tang capiac i baiq toq calŏih. ");
INSERT INTO hre_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Pah cloh Hnem Traiq Cùh Waiq, aih pah mat mahì mùt, wì haq broq tadràu capiac long ban, ");
INSERT INTO hre_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","èh haq broq baiq capiac hòm ta baiq toq mùm pah cloh Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Baiq toq capiac long ban aih hatop dabau ta 'neq xam mòiq gwiang wa enh 'nhèq xam mòiq gwiang; haq broq baiq toq mùm 'màng aih. ");
INSERT INTO hre_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","'Màng aih rahem capiac long ban 16 toq calŏih xam 'bac; enh 'neq ca rìm tang capiac long ban i baiq calŏih. ");
INSERT INTO hre_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Wì haq broq long pang dìq xam long a-kê-si-a: padam capiac long ban đòiq broq pah 'ngeo ca mat mahì loh da Hnem Traiq Cùh Waiq, ");
INSERT INTO hre_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","wa padam catŏch long pang broq pah 'ma mat mahì loh. Wì haq hadai broq padam catŏch long pang pah cloh Hnem Traiq Cùh Waiq, aih pah mat mahì mùt. ");
INSERT INTO hre_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Wì haq broq mòiq catŏch long pang ta'ne đòiq chiu ta'ne 'bài panàt long ban enh gàu trùh cloh da Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Wì haq 'bìt wang ca 'bài capiac long ban, broq rawiang xam wang đòiq catŏch long pang, èh 'bìt wang ca 'bài catŏch long pang. ");
INSERT INTO hre_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Wì haq tenh broq mòiq blah bai prình xam brai habùac lem, nhum xenh, gòh ngùi wa gòh mahem. Wì haq tenh 'mù chê-ru-bim dìq jaq lem geo. ");
INSERT INTO hre_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Wì haq broq pôn toq long jrang xam long a-kê-si-a wa pôn toq glêh xam wang đòiq atua bai prình. Wì haq 'bìt dìq jrang xam wang, hi khoi pa'nàng jrang aih ta pôn toq xèm calŏih xam 'bac. ");
INSERT INTO hre_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Wì haq hadai broq am ca 'mang ma mùt ta Hnem Traiq Cùh Waiq mòiq blah bai prình xam bai habùac lem, èh tenh 'mù lem lình xam brai nhum xenh, gòh ngùi wa gòh mahem, dìq jaq lem geo. ");
INSERT INTO hre_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Wì haq broq padam long jrang i 'bài glêh, hi khoi 'bìt xam wang ta gàu long jrang wa 'bài ha'mai, mahaq padam toq xèm i calŏih đòiq jrang, aih broq xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Khoi èh, Bê-xa-lên broq hom xam long a-kê-si-a, pah yôh 2 hagat 'ne, dang gat 1 hagat 'ne, wa dang ha'nhèq 1 hagat 'ne. ");
INSERT INTO hre_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Haq 'bìt wang enh trom wa enh gùng, hadai broq grôi dudan. ");
INSERT INTO hre_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Haq broq pôn toq gwiang xam wang 'mùt jang pôn toq mùm enh 'neq jang jènh; baiq toq gwiang cô, baiq toq pah gwiang tau. ");
INSERT INTO hre_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Haq broq baiq catŏch long tanòng tòng xam long a-kê-si-a 'bìt xam wang. ");
INSERT INTO hre_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Haq yŏc long tanòng mùt ta rawiang baiq pah rawiang hom đòiq broq long tòng hom. ");
INSERT INTO hre_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Haq broq mòiq toq Calàp Baxŏng Tôiq xam wang, dàng yôh 2 hagat 'ne, dàng gat 1 hagat 'ne. ");
INSERT INTO hre_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Haq broq baiq toq 'mù chê-ru-bim xam wang đòiq baiq pah ta Calàp Baxŏng Tôiq, ");
INSERT INTO hre_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","đòiq mòiq toq chê-ru-bim ŏi pah cô, mòiq toq chê-ru-bim ŏi pah tau wa baiq hatop ca dabau enh 'nhèq ca Calàp Baxŏng Tôiq. ");
INSERT INTO hre_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Baiq toq chê-ru-bim ngìa 'nah dabau, panan wa haq hlìa ti 'nhèq enh 'nhèq ca Calàp Baxŏng Tôiq, wa hadrò wa haq cùp ngan Calàp Baxŏng Tôiq. ");
INSERT INTO hre_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Haq broq mòiq toq ca'bŏng xam long a-kê-si-a, dàng yôh 2 hagat, dàng gat 1 hagat, dàng 'nhèq 1 hagat 'ne. ");
INSERT INTO hre_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Haq 'bìt xam wang, wa broq mòiq trong grôi dudan. ");
INSERT INTO hre_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Haq broq pòng dàng wàu mòiq hada tì dudan ca ca'bŏng, wa broq grôi xam wang ti pòng. ");
INSERT INTO hre_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Haq broq pôn toq gwiang 'mùt ti pôn toq mùm tì nòi jènh ca'bŏng. ");
INSERT INTO hre_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","'Bài gwiang ŏi haten ca khùan đòiq 'mùt long tòng ca'bŏng. ");
INSERT INTO hre_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Haq broq long tanòng xam long a-kê-si-a 'bìt xam wang đòiq tòng ca'bŏng aih. ");
INSERT INTO hre_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ìh hadai yŏc wang broq 'bài ngè đòiq ta ca'bŏng: doi, dòt, doi chê wa abôq, đòiq patìh jò broq lè dèch am ngè ôq. ");
INSERT INTO hre_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Haq broq jènh đen xam wang calôq. Jènh, long ta'ne, abôq i riang da đen broq xam wang aih. ");
INSERT INTO hre_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Long đen jah i tadràu toq hamenh, piq hamenh ŏi pah cô, piq hamenh ŏi pah tau. ");
INSERT INTO hre_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ta tadràu hamenh enh 'nhèq jènh đen, mòiq hamenh i piq toq abôq tìah ca riang apriac, pajùm ca acŏn wa riang. ");
INSERT INTO hre_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ta chac jènh đen, i pôn toq abôq tìah ca riang apriac, acŏn wa riang. ");
INSERT INTO hre_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Haq hadai broq mòiq acŏn enh 'neq baiq hamenh baxèm hatop long đen, èh broq mòiq acŏn enh 'neq baiq hamenh ma tìa hatop long đen, hi khoi broq mòiq acŏn enh 'neq baiq hamenh ma tìa hòm hatop long đen. I dìq tadràu toq hamenh. ");
INSERT INTO hre_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Acŏn wa hamenh da jènh đen, broq xam wang calôq. ");
INSERT INTO hre_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Haq broq tapèh toq đen, keoq cat tìm đen, wa dòt tah loc đen, dìq broq xam wang. ");
INSERT INTO hre_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Haq yŏc mòiq talàng wang, broq jènh đen wa 'bài ranac da jènh đen. ");
INSERT INTO hre_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hi khoi haq broq ca'bŏng bùh jreo xua thùm. Ca'bŏng aih dang yôh 1 hagat, dang gat 1 hagat. Èh dang yòng 2 hagat, broq pôn toq aki ta mùm ca'bŏng wìa mòiq calôq. ");
INSERT INTO hre_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Haq 'bìt wang enh 'nhèq, dudan ca cabŏng xam 'bài aki, wa broq grôi xam wang dudan ca ca'bŏng. ");
INSERT INTO hre_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Enh 'neq ca trong grôi aih, nòi baiq pah mùm, haq broq baiq toq gwiang xam wang nòi 'mùt long tanòng đòiq tòng. ");
INSERT INTO hre_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Haq broq long tanòng tòng xam long a-kê-si-a wa 'bìt wang. ");
INSERT INTO hre_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Haq hadai broq dàu đòiq xùt wa ngè xua thùm lem hreo xam 'bài ngè xua thùm tiaq trong thòq broq hòi xua thùm. ");
INSERT INTO hre_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bê-xa-lên broq ca'bŏng tadreo da ngè tadreo bùh xam long a-kê-si-a, dang yôh 5 hagat, dang gat 5 hagat, dang yòng 3 hagat. ");
INSERT INTO hre_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Haq broq pôn toq aki ta pôn mùm ca'bŏng tadreo hatop ca dabau. 'Bìt dìq dŏng ca'bŏng xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Haq broq 'bài ranac da ca'bŏng tadreo, aih: thùng đòiq tah blo tanùh, canoch, dòt đòiq da'rat, achôn piq rang, wa dòch tah cachah. Ìh phai broq dìq ranac xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Haq broq mòiq toq jàn xam đùng enh 'neq ca ca'nàm ca'bŏng tadreo pàng enh 'neq tŏc trùh ha'ne pah ha'nhèq. ");
INSERT INTO hre_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Haq broq gwiang xam đùng ta pôn toq mùm jang ca jàn đòiq 'mùt long tanòng tòng. ");
INSERT INTO hre_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Haq broq long tanòng tòng xam long a-kê-si-a, èh 'bìt xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Haq 'mùt long tanòng tòng ta gwiang nòi baiq pah ca'bŏng tadreo đòiq tòng ca'bŏng jò lam. Haq broq ca'bŏng tadreo xam long ban, rahùang ta'ne. ");
INSERT INTO hre_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Haq yŏc 'bài capiac đùng ma broq gùang ngan hadrò da 'bài gu cadrì patìh ta 'mang Hnem Traiq Cùh Waiq, broq loh mòiq thùng càn đòiq 'nheo wa jènh thùng xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Hi khoi haq hadai broq pagia pah 'ma ca mat mahì loh dàng yôh 100 hagat haq jìp mòiq blah bai prình xam bai habùac lem, ");
INSERT INTO hre_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Haq broq 20 long jrang wa 20 calŏih xèm jrang xam đùng; i 'bài glêh, wa ha'mai ta gàu long jrang wa 'bài long glêh 'bìt xam 'bac. ");
INSERT INTO hre_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Pah 'ngeo ca mat mahì loh i 100 hagat bai prình, 20 long jrang wa 20 toq xèm i calŏih đòiq 'mùt long jrang broq xam đùng; glêh wa ha'mai broq xam 'bac. ");
INSERT INTO hre_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Pah mahì mùt i 50 hagat bai prình, I 10 toq long jrang wa 10 toq xèm i calŏih đòiq 'mùt long jrang broq xam đùng; glêh wa ha'mai broq xam 'bac. ");
INSERT INTO hre_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Pah mat mahì loh, i 50 hagat. ");
INSERT INTO hre_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Pah 'ma 'mang pagia i 15 hagat bai prình, piq toq long jrang wa piq toq calŏih xèm đòiq 'mùt long jrang. ");
INSERT INTO hre_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Pah 'ngeo 'mang pagia i 15 hagat bai prình, piq long jrang wa piq toq calŏih xèm đòiq 'mùt long jrang. ");
INSERT INTO hre_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Dìq dŏng bai prình da pagia dudan, aih xam bai habùac lem. ");
INSERT INTO hre_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","'Bài xèm i calŏih đòiq 'mùt long jrang aih broq xam đùng; glêh da long jrang wa ha'mai ti gàu long jrang 'bìt xam 'bac. Dìq dŏng long jrang da pagia i ha'mai xam 'bac. ");
INSERT INTO hre_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Blah bai nòi 'mang pagia tenh xam brai nhum xenh, gòh ngùi wa gòh mahem, wa brai habùac lem, pah dang yôh 20 hagat, pah ha'nhèq 5 hagat, tìah ca bai prình pagia ma 'noiq. ");
INSERT INTO hre_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Pôn long jrang wa pôn toq xèm i calŏih broq xam đùng, glêh, ha'mai wa calàp ti gàu jrang khoi 'bìt xam 'bac. ");
INSERT INTO hre_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","'Bài long cŏc đêq da Hnem Traiq Cùh Waiq wa da pagia dudan dìq broq xam đùng. ");
INSERT INTO hre_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Cô dìq ngè gop đòiq broq Hnem Traiq Cùh Waiq, aih ngè khoi rèn tiaq dìq hiniq bàu thê da Môise đòiq mangai Lêwi jah patìh, nhò I-tha-ma con calô da Arôn pajàu ha'nhèq Boc Plình, wèq ngan bìac aih. ");
INSERT INTO hre_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bê-xa-lên, con calô Uri, xau Hurò, ŏi ta hadròng hadrech Juđa broq tiaq rìm bìac Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Mangai ma wiang ti haq aih Ô-hô-li-ap, con calô da A-hi-sa-mac ŏi ta hadròng hadrech Đan, mangai thòq ragài pùng padì, thòq tenh xam brai nhum xenh, gòh ngùi wa gòh mahem, wa xam bai habùac lem. ");
INSERT INTO hre_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Dìq dŏng wang khoi yŏc đòiq broq bìac ta Hnem Traiq Cùh Waiq, aih wang jàn am, jah 29 talàng wa 730 hliac 'bac tiaq siêclò da Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","'Bac da jàn i tình ta sô dìq dŏng jah 100 talàng wa 1.775 hliac 'bac, aih tiaq siêclò da Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Dìq dŏng mangai leq ma i achìh hiniq ta sô, pàng 20 hanam dang tŏc, aih jah 603.550 ngai calô, mòiq ngai am 'ne siêclò tiaq siêclò da Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","'Màng aih ep i 100 talàng 'bac đòiq broq calŏih long jrang da Hnem Traiq Cùh Waiq wa calŏih long jrang bai prình; 100 talàng am ca 100 toq calŏih. ");
INSERT INTO hre_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Haq yŏc 1.775 hliac 'bac, èh broq glêh, wa 'bìt gàu long jrang wa ha'mai xam 'bac. ");
INSERT INTO hre_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Dìq ca đùng ma 'ràng am jah 70 talàng, aih 2.400 kg đùng. ");
INSERT INTO hre_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Wì yŏc đùng aih broq calŏih long cŏc da 'mang hnem waiq khàn broq đò, ca'bŏng tadreo broq xam đùng, 'bài ranac patìh da ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","'Bài calŏih da pagia dudan 'bài trom long cŏc da 'mang pagia, 'bài cŏc đêq da hnem waiq khàn broq đò, wa 'bài cŏc đêq da pagia dudan. ");
INSERT INTO hre_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Wì yŏc brai nhum xenh, gòh ngùi wa gòh mahem broq loh eo 'bài pajàu patìh ta Nòi Hadròih, wa eo am ca Arôn troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bê-xa-lên tenh êphot xam bai habùac lem, yŏc brai xam wang, nhum xenh, gòh ngùi wa gòh mahem. ");
INSERT INTO hre_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Wì haq yŏc tamoh tùq wang wìa dìq jaq ratang khoi èh cat tang hadrang 'yêq, jìp alôn ta bai habùac lem, brai nhum xenh, gòh ngùi wa gòh mahem. Wì haq broq dìq jaq geo. ");
INSERT INTO hre_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Wì jìp baiq hadrang caxi ca Êphot đòiq bac palêh. ");
INSERT INTO hre_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Hadrang caxi càt êphot broq dìq jaq geo, hadai yŏc bai tìah troi broq êphot, tenh xam brai broq xam wang, brai nhum xenh, gòh ngùi wa gòh mahem wa broq xam bai tenh habùac lem, troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Wì haq yŏc baiq pliang ngŏc nhum gam, èh pùng achìh hiniq con calô da Is-ra-ên ŏi enh 'nhèq, ");
INSERT INTO hre_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Haq đòiq baiq pliang ngŏc aih ta caxi bac ti plêh da êphot, đòiq broq ngŏc bahmàng hlài da jàn Is-ra-ên, 'màng troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Haq broq capiac bac jang rada dìq jaq geo, 'màng troi ma broq êphot: yŏc brai xam wang, brai nhum xenh, gòh ngùi, gòh mahem wa brai habùac lem. ");
INSERT INTO hre_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Capiac bac jang rada yôh đêq ta-atoq, pah dang yôh mòiq hada, pah dang gat mòiq hada jò khoi đôm wìa baiq lòp bai. ");
INSERT INTO hre_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Wì 'bìt pôn brong ngŏc, brong mòiq ngŏc gòh dùm, ngŏc gòh bah, wa ngŏc nget bah. ");
INSERT INTO hre_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Brong baiq i ngŏc xenh wa bùac, ngŏc xenh ngaiq wa kim cùang. ");
INSERT INTO hre_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Brong piq i ngŏc nhum crôch, ngŏc nhum bùac wa taboc wa ngŏc gòh ngùi. ");
INSERT INTO hre_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Brong pôn i ngŏc nhum wang ngaiq, ngŏc gam wa ngŏc nhum wang bah, 'bài ngŏc cô khoi đòiq ta khùan broq xam brai xam wang. ");
INSERT INTO hre_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Sôq ngŏc 12 toq tiaq hiniq 'bài con calô Is-ra-ên. Mòiq pliang ngŏc i pùng achìh mòiq toq hiniq ta 12 hadròng hadrech Is-ra-ên, troi wì pùng teo hadro. ");
INSERT INTO hre_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ta capiac bac jang rada, wì broq baiq hadrang caxi tagwat xam wang đenh. ");
INSERT INTO hre_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Wì haq hadai broq baiq toq khùan xam wang, èh broq baiq toq gwiang xam wang đòiq ŏi jang baiq toq mùm gàu capiac bac jang rada. ");
INSERT INTO hre_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Wì haq càt baiq hadrang caxi tagwat xam wang ta baiq gwiang ta capiac bac jang rada. ");
INSERT INTO hre_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Wì haq ta'mŏt baiq toq caxi tagwat xam wang ma 'noiq ta hadrang caxi plêh pah ngìa êphot jang rada. ");
INSERT INTO hre_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Èh wì haq broq baiq toq gwiang 'noiq xam wang đòiq jang baiq mùm 'neq da capiac bac jang rada pah êphot. ");
INSERT INTO hre_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Èh wì haq broq baiq gwiang 'noiq hòm xam wang apìq 'mùt baiq ha'mai enh 'neq ca caxi bac êphot pah ngìa ŏi enh 'nhèq ca caxi ca'nam haten ca nòi ha'mai. ");
INSERT INTO hre_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Wì haq yŏc mòiq hadrang nhum xenh càt baiq toq gwiang da capiac bac jang rada wa baiq gwiang êphot, đòiq hatop ca capiac bac, ùh hìaq clìh khoi ca êphot troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Èh haq tenh eo yôh enh 'neq ca êphot dìq xam bai nhum xenh. ");
INSERT INTO hre_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ŏi ta'ne ti 'nhèq eo i mòiq toq trom 'mùt gàu mùt, èh jìp dudan ca trom eo đòiq ùh hìaq dahich. ");
INSERT INTO hre_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Wì haq broq plì ôi rôm xam brai nhum xenh, gòh ngùi, gòh mahem, wa brai đenh habùac lem, càt atua ta ha'mai eo. ");
INSERT INTO hre_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Wì haq hadai broq clinh ninh xam wang, atua ta'ne rìm plì ôi rôm tap dawenh ha'mai da eo yôh: ");
INSERT INTO hre_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","hatìa mòiq toq plì ôi rôm trùh mòiq toq clinh ninh dudan tiaq ha'mai eo đòiq caxùnh jò patìh bìac, troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Wì haq hadai broq eo enh dalam tenh xam brai habùac lem taboc am ca Arôn wa 'bài con calô haq, ");
INSERT INTO hre_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","hadai broq calôp côi, anì ca calôp wa cwàn enh dalam, broq xam brai habùac lem, ");
INSERT INTO hre_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","wa caxi ca'nam xam brai habùac lem, brai nhum xenh, gòh ngùi wa gòh mahem, broq tiaq mangai thòq tenh troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Wì yŏc wang broq mòiq capiac pùng achìh ta aih tìah ca wì ma pùng achìh teo đòiq hadro am ca pajàu ha'nhèq 'màng cô: HADRÒIH CA CHUAQ. ");
INSERT INTO hre_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Hi khoi yŏc mòiq hadrang caxi nhum xenh càt capiac aih ta calôp troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","'Màng aih, bìac broq da Hnem Traiq Cùh Waiq khoi gêh. Jàn Is-ra-ên broq tìah troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Wì haq 'ràng 'bài ngè đòiq broq Hnem Traiq Cùh Waiq trùh ca Môise: Traiq wa ranac da traiq, long đêq, long ban, pang, long jrang, xèm i calŏih da long jrang. ");
INSERT INTO hre_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Bai ma po cùa xam akia trìu calô nhum gòh wa akia ca nùac; hadai i bai prình hom wêh jao; ");
INSERT INTO hre_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Hom Wêh Jao, long tanòng wa Calàp Baxŏng Tôiq. ");
INSERT INTO hre_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Ca'bŏng 'benh hadròih, ranac da ca'bŏng wa 'benh hadròih; ");
INSERT INTO hre_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","jènh đen broq xam wang, 'bài đen khoi palaoq đòiq, 'bài ranac da jènh đen wa dàu bùh; ");
INSERT INTO hre_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ca'bŏng bùh jreo xua thùm broq xam wang, dàu xùt, ngè xua thùm, blah bai da 'mang traiq; ");
INSERT INTO hre_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ca'bŏng tadreo broq xam đùng wa jàn hadai xam đùng, long tanòng tòng wa 'bài ranac da ca'bŏng tadreo, thùng càn wa jènh thùng; ");
INSERT INTO hre_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","dìq ca bai prình ti pagia xàn, jrang, xèm i calŏih da jrang, bai prình, caxi, long cŏt đêq, wa dìq ca dahwèq ma 'noiq da bìac patìh ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Eo lè đòiq caxùnh patìh bìac ta Nòi Hadròih, eo am ca Arôn, pajàu ha'nhèq wa eo da 'bài con calô haq đòiq patìh. ");
INSERT INTO hre_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Jàn Is-ra-ên broq rìm bìac cô 'màng troi bàu thê da Chuaq khoi doi ca Môise. ");
INSERT INTO hre_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Môise ngan hlài bìac broq, hnoq wì haq broq tìah troi bàu Chuaq khoi thê, hi khoi Môise waiq xìn xôq ramŏt am ca wì haq. ");
INSERT INTO hre_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Hì mòiq khê mòiq, ìh jah pa'nàng Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ìh phai đòiq Hòm Wêh Jao ta Hnem Traiq Cùh Waiq, hì khoi yŏc bai prình lom Hom Wêh Jao. ");
INSERT INTO hre_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ìh phai 'ràng 'mùt ca'bŏng đòiq 'benh hadròih, palaoq đòiq 'bài ranac ta ca'bŏng tiaq tìa dabau; èh 'ràng jènh đen bùh đen. ");
INSERT INTO hre_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ìh phai 'ràng ca'bŏng bùh jreo xua thùm broq xam wang jang ngìa Hòm Wêh Jao, hi khoi prình bai 'mang Nòi Dìq Jaq Hadròih. ");
INSERT INTO hre_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ìh phai đòiq ca'bŏng tadreo da ngè tadreo bùh jang ngìa 'mang Nòi Hadròih. ");
INSERT INTO hre_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ìh phai đòiq thùng càn đòiq 'nheo ŏi ta'ne Nòi Hadròih wa ca'bŏng tadreo, hi khoi ùc diac ta thùng. ");
INSERT INTO hre_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ìh phai đòiq pagia dudan Hnem Traiq Cùh Waiq, èh atua bai prình ta 'mang pagia xàn. ");
INSERT INTO hre_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Khoi èh, ìh phai yŏc dàu hadròih xùt ca Hnem Traiq Cùh Waiq, wa 'bài ranac dalam aih, lah crài Hnem Traiq Cùh Waiq wa 'bài ranac loh hadròih, èh loh hadròih. ");
INSERT INTO hre_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ìh phai xùt dàu ca ca'bŏng tadreo ta ngè tadreo bùh wa 'bài ranac da ca'bŏng tadreo, hi khoi lah ca'bŏng tadreo crài loh hadròih, èh ca'bŏng tadreo jah broq dìq jaq hadròih. ");
INSERT INTO hre_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ìh phai xùt dàu ca thùng càn wa jènh thùng, lah crài loh hadròih. ");
INSERT INTO hre_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Ìh phai 'nong Arôn wa con calô haq trùh haten ca 'mang Nòi Hadròih, hi khoi 'nheo wì haq ta diac. ");
INSERT INTO hre_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ìh phai caxùnh ca Arôn eo hadròih, xùt dàu wa lah crài haq loh hadròih, đòiq haq jah broq pajàu patìh jang ngìa Au. ");
INSERT INTO hre_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ìh phai 'ràng 'bài con calô haq trùh haten, hi khoi caxùnh ca wì haq eo yôh taboc. ");
INSERT INTO hre_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ìh phai xùt dàu ca wa haq troi ìh ma khoi xùt ca baq wa haq, èh wa haq jah broq pajàu patìh jang ngìa Au. Bìac xùt dàu jah patŏc wa haq broq pajàu cwa rìm 'nhòng da wa haq.” ");
INSERT INTO hre_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Môise broq tìah troi rìm bìac Chuaq khoi thê haq broq. ");
INSERT INTO hre_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Trùh hì mòiq khê mòiq, hanam ma baiq, èh Hnem Traiq Cùh Waiq khoi jah pa'nàng. ");
INSERT INTO hre_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Môise pa'nàng Hnem Traiq Cùh Waiq, pa'nàng dìq xèm i calŏih đòiq jrang, pa'nàng long ban, dèch pang roh wa pa'nàng jrang. ");
INSERT INTO hre_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Haq dèch bai càn glàp cùa Hnem Traiq Cùh Waiq, hi khoi hlèch dìq bai ma 'noiq tù enh crŏng bai càn, tìah troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Khoi èh, haq yŏc baiq toq capiac hmu i Mòiq Jàt Brong Bàu Thê tah ta Hom Wêh Jao, 'mùt long tanòng tòng ta Hom Wêh Jao wa gùp Calàp Baxŏng Tôiq enh 'nhèq ca Hom Wêh Jao. ");
INSERT INTO hre_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Haq 'ràng Hom Wêh Jao mùt ta Hnem Traiq Cùh Waiq, èh atua bai prình ta Nòi Dìq Jaq Hadròih đòiq tù Hom Wêh Jao, tìah troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Hi khoi haq đòiq ca'bŏng i 'benh hadròih ta Nòi Hadròih, pah 'ngeo ca mat mahì loh ta Hnem Traiq Cùh Waiq, pah gùng ca bai prình. ");
INSERT INTO hre_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Hi khoi ta'mroq 'benh ta ca'bŏng jang ngìa Chuaq, tìah troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Haq đòiq jènh đen ta Nòi Hadròih ta jang ca ca'bŏng mahaq pah 'ma ca mat mahì loh. ");
INSERT INTO hre_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Haq bùh đen aih enh ngìa ca Chuaq, aih troq tiaq bàu thê da Chuaq khoi thê haq. ");
INSERT INTO hre_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Hi khoi haq đòiq ca'bŏng bùh jreo xua thùm broq xam wang pah ngìa bai ma prình ta Nòi Dìq Jaq Hadròih. ");
INSERT INTO hre_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Haq bùh jreo xua thùm enh 'nhèq ca ca'bŏng aih, tìah troi bàu thê Chuaq khoi doi ca Môise. ");
INSERT INTO hre_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Hi khoi haq atua bai prình nòi 'mang Nòi Hadròih. ");
INSERT INTO hre_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Haq đòiq ca'bŏng tadreo da ngè tadreo bùh jang 'mang Nòi Hadròih, am ngè tadreo bùh wa ngè dèch am 'mau mì, tìah troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Hadai đòiq thùng càn ta'ne Nòi Hadròih wa ca'bŏng tadreo, ùc diac bình ta thùng đòiq 'nheo. ");
INSERT INTO hre_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Môise, Arôn wa 'bài con calô da Arôn 'nheo jènh, 'nheo tì ta aih. ");
INSERT INTO hre_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Jò leq wì haq 'mùt ta Nòi Hadròih thia haten ca ca'bŏng bùh jreo xua thùm, èh wì 'nheo dađeh tìah troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Dudan ca xàn Hnem Traiq Cùh Waiq wa ca'bŏng tadreo, haq pa'nàng pagia xam bai prình wa atua bai prình ta 'mang xàn. 'Màng aih Môise broq gêh dìq bìac aih. ");
INSERT INTO hre_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Cato yùc glom nòi hadròih wa can 'ngah 'ngai da Chuaq bình halùih ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Môise ùh jah mùt ta Nòi Hadròih taiq i cato yùc glom enh 'nhèq ca Traiq wa can 'ngah 'ngai da Chuaq bình halùih ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ta dìq ca trong lam, jò leq cato yùc tŏc khoi ca Hnem Traiq Cùh Waiq, jàn Is-ra-ên padon loh lam. ");
INSERT INTO hre_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mahaq tàng cato yùc ùh tŏc, èh wì haq ji ùh loh lam trùh hì leq cato yùc ma tŏc. ");
INSERT INTO hre_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ma jah 'màng aih jò jàn Is-ra-ên ŏi ta trong lam, èh cato yùc da Chuaq ŏi enh 'nhèq ca Hnem Traiq Cùh Waiq jò dahì, wa i ùnh ŏi enh 'nhèq ca Hnem Traiq Cùh Waiq jang ngìa dìq ca jàn Is-ra-ên jò damang.");
INSERT INTO hre_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Chuaq creo ca Môise enh Hnem Traiq Cùh Waiq, doi: ");
INSERT INTO hre_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Doi ca jàn Is-ra-ên: ‘Jò i mangai leq ŏi ta pì am ngè tadreo ca Chuaq, èh haq phai am ngè aban, 'bo loq trìu. ");
INSERT INTO hre_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Tàng ngè tadreo da haq ngè tadreo bùh xam 'bo, èh phai am 'bo calô, ùh i ca teo xìt leq, am atŏc jang ngìa Hnem Traiq Cùh Waiq enh ngìa ca Chuaq, đòiq Haq jah lem manoh nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Jò haq tadreo xam ngè aban, haq phai đòiq tì agàu ngè aban aih, èh ngè tadreo aih jah rŏt dèch hlài enh tôiq lôi ca haq. ");
INSERT INTO hre_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Mangai aih pàc 'bo bu chuai aih enh ngìa ca Chuaq, khoi èh 'bài pajàu, aih con calô Arôn, phai yŏc mahem da'rat dudan kenh ca'bŏng tadreo jang nòi 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Khoi ca aih luch akia, xah jam loh tang ha'nech. ");
INSERT INTO hre_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","'Bài con calô Arôn ma broq pajàu patep ùnh enh 'nhèq ca'bŏng tadreo, èh ta'mroq long ùnh enh 'nhèq. ");
INSERT INTO hre_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Khoi èh 'bài pajàu, aih con calô Arôn, phai ta'mroq ha'nech jam, gàu haq wa ramaq, bùh ta ùnh enh 'nhèq ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Hi khoi, pajàu phai 'nheo cliac wa jènh, 'ràng dìq dŏng aih bùh pajùm ta ca'bŏng tadreo. Aih ngè tadreo bùh i hòi xua thùm atŏc am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Tàng ngè tadreo bùh da haq ngè aban trìu loq bubi, èh ep am ngè ma calô ùh i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Haq phai pàc ngè aih nòi pah 'ngeo ca mat mahì loh ca ca'bŏng tadreo, enh ngìa ca Chuaq. Hi khoi 'bài pajàu aih con calô Arôn, yŏc mahem da'rat dudan ca 'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Hi khoi haq phai xah jam tang ha'nech, xam gàu wa ramaq haq ta ca'bŏng tadreo ùnh 'nang cheo. ");
INSERT INTO hre_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Hi khoi, pajàu phai 'nheo cliac wa jènh, 'ràng dìq dŏng aih bùh pajùm ta ca'bŏng tadreo. Aih ngè tadreo bùh i hòi xua thùm atŏc am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Tàng ngè tadreo da haq aih chìm, èh ep am chìm trù gùng loq chìm trù hnem. ");
INSERT INTO hre_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Pajàu phai 'ràng trùh jang nòi ca'bŏng tadreo, wech catech ranŏng, èh bùh ta ca'bŏng tadreo; hi khoi ùc mahem haq ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Haq phai yŏc 'noh padìu wa xàc haq cađac pah mat mahì loh ca ca'bŏng tadreo ta nòi ùc blo tanùh. ");
INSERT INTO hre_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Khoi èh haq phai rùp hich baiq toq panan haq mahaq ùh am catech wìa baiq toq. Aih ngè tadreo ùnh bùh đòiq am i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Jò i mangai leq dèch am 'mau mì ca Chuaq, ngè aih phai xam dàc 'yêh, èh ùc dàu wa đòiq nhù hùang enh 'nhèq. ");
INSERT INTO hre_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Hi khoi, haq phai 'ràng trùh ca 'bài pajàu, aih con calô Arôn, mòiq cadop dàc 'yêh, dàu wa nhù hùang. Èh pajàu 'ràng bùh jang ca'bŏng tadreo, aih ngè tadreo bùh xam ùnh i hòi xua thùm broq bìac hmàng yôt ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Phàn ma ŏi i rah, aih da Arôn wa 'bài con calô haq, aih ngè dèch am dìq jaq hadròih ta 'bài ngè tadreo dèch am 'mau mì ca Chuaq xam ùnh. ");
INSERT INTO hre_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Tàng mangai leq 'ràng ngè dech am 'mau mì xam 'benh phiang ta tanùh, èh mangai aih phai yŏc dàc 'yêh broq 'benh ùh tah blo mahaq alôn ca dàu, loq 'benh ratang ùh tah blo mahaq xùt dàu. ");
INSERT INTO hre_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Tàng ìh yŏc ngè adrenh ta gŏc đòiq broq ngè dèch am xam 'mau mì, èh phai broq xam dàc 'yêh alôn ca dàu ùh tah blo; ");
INSERT INTO hre_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","goh tang ha'nech wa tah dàu enh 'nhèq. Cô ngè dèch am xam 'mau mì. ");
INSERT INTO hre_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Tàng am ngè tadreo adrenh ta gŏc chao đòiq broq ngè dèch am xam 'mau mì, èh phai broq xam dàc 'yêh wa dàu. ");
INSERT INTO hre_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ngè dèch am xam 'mau mì, èh padon 'màng cô: Phai jao ca pajàu 'ràng am ca Chuaq, hi khoi haq 'ràng ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Pajàu phai yŏc phàn 'yoh ma am aih broq bìac hmàng yôt, 'ràng ta ca'bŏng tadreo, aih ngè tadreo bùh xam ùnh i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Phàn leq ta ngè dèch am xam 'mau mì ŏi i, aih da Arôn wa 'bài con calô haq. Aih ngè tadreo dìq jaq hadròih ta 'bài ngè tadreo xam ùnh am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Apaq tah blo ta ngè dèch am xam 'mau mì ca Chuaq. Pì apaq yŏc blo loq diac xùt bùh pajùm tì ngè am tadreo leq xam ùnh am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Pì jah am 'bài ngè bìac aih ca Chuaq tìah ca ngè am tadreo gàu mùa, mahaq ùh bùh ta ca'bŏng tadreo tìah ca ngè tadreo i hòi xua thùm. ");
INSERT INTO hre_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ep tah boh ta dìq ca ngè dèch am xam 'mau mì. Apaq dèch am ùh i ca boh ma jah 'màng aih boh teo patô ca bìac wêh jao da Boc Plình khoi broq ca pì. Pì phai tah boh am tŏc ta dìq ca ngè tadreo. ");
INSERT INTO hre_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Tàng 'ràng ngè tadreo dèch am xam 'mau mì baxèm mùa ca Chuaq, èh phai 'ràng hadròc neo gat, pêh hi adrenh ta ùnh 'ràng am, ");
INSERT INTO hre_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","hi khoi da'rat dàu wa đòiq nhù hùang ti 'nhèq, aih ngè dèch am xam 'mau mì. ");
INSERT INTO hre_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Pajàu phai yŏc 'nah ngè 'mau mì aih ma i dàu pajùm ca nhù hùang, èh bùh đòiq broq teo jah hmàng yôt, aih ngè tadreo xam ùnh dèch am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Tàng mangai leq am ngè tadreo waiq catèm xam 'bo calô, loq 'bo cadrì, enh ngìa ca Chuaq èh ngè aih ùh jah i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Haq phai yŏc tì đòiq agàu ngè aban aih, hi khoi pàc haq jang 'mang Hnem Traiq Cùh Waiq. Khoi èh 'bài pajàu, aih con calô Arôn, phai yŏc mahem da'rat dudan ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Enh ngè tadreo waiq catèm, haq phai broq ngè tadreo bùh xam ùnh am ca Chuaq, aih ramaq ma top roc caxènh himìa wa ramaq cliac, ");
INSERT INTO hre_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","xam baiq toq plì crŏng wa ramaq haq, ramaq ŏi kenh ca'bŏng, khoi èh cađac 'nah clèm wa baiq plì crŏng. ");
INSERT INTO hre_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","'Bài con calô Arôn phai bùh dìq ngè aih enh 'nhèq ca ca'bŏng tadreo, aih ngè tadreo xam ùnh i hòi xua thùm ma atŏc am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Tàng haq am ca Chuaq ngè tadreo waiq catèm xam trìu calô, loq trìu cadrì, aih phai trìu ma ùh i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Tàng haq am ngè tadreo xam trìu, èh phai am atŏc haq enh ngìa ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","èh haq yŏc tì đòiq agàu ngè aban aih, hi pàc jang 'mang Hnem Traiq Cùh Waiq. 'Bài con calô Arôn phai yŏc mahem da'rat dudan ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ngè tadreo waiq catèm cô haq phai bùh xam ùnh dèch am ca Chuaq; ramaq wa tenh haq pŏt haten ca caxènh crŏng, ramaq ma top roc caxènh crŏng wa ramaq cliac, ");
INSERT INTO hre_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","baiq toq plì crŏng xam ramaq haq, ramaq ŏi kenh ca'bŏng, khoi èh cađac 'nah clèm wa baiq plì crŏng. ");
INSERT INTO hre_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Pajàu phai bùh dìq ca ngè aih tìah ca dahwèq caq ta ca'bŏng tadreo. Aih ngè tadreo bùh xam ùnh atŏc am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Tàng ngè tadreo da haq xam bubi, èh haq phai am atŏc enh ngìa ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","yŏc tì đòiq agàu ngè aban aih, khoi èh pàc haq jang Hnem Traiq Cùh Waiq. 'Bài con calô Arôn phai da'rat mahem aih dudan ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Enh ngè tadreo cô haq phai atŏc am ca Chuaq ngè tadreo xam ùnh pajùm ramaq ma top roc caxènh crŏng wa ramaq cliac, ");
INSERT INTO hre_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","baiq toq plì crŏng xam ramaq haq, ramaq ŏi kenh cabŏng, khoi èh cađac 'nah clèm wa baiq plì crŏng. ");
INSERT INTO hre_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Pajàu phai bùh dìq ngè aih ta ca'bŏng tadreo, aih dahwèq ngè tadreo xam ùnh atŏc i hòi xua thùm; dìq dŏng ramaq aih da Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Aih bàu thê hloi hloi ca pì, 'nhac ca wì ŏi ta leq, hadai apaq caq ramaq wa mahem.’ ” ");
INSERT INTO hre_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Doi ca jàn Is-ra-ên: ‘Mangai leq troq lò ùh dì tiaq mòiq ranenh leq ta 'bài ranenh da Chuaq, hi broq bìac ma ùh khòh broq, ");
INSERT INTO hre_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Tàng pajàu ma khoi chìuq xùt dàu, broq tôiq, 'màng aih broq ca jàn i tôiq, taiq tôiq haq ma khoi broq, èh haq phai am ca Chuaq mòiq toq 'bo bu chuai ùh i ca teo xìt leq đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Haq phai 'ràng 'bo aih trùh jang 'mang Hnem Traiq Cùh Waiq enh ngìa ca Chuaq, đòiq tì agàu 'bo aih, hi khoi pàc haq enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Pajàu ma khoi chìuq xùt dàu phai 'ràng 'nah mahem mùt ta Hnem Traiq Cùh Waiq, ");
INSERT INTO hre_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","'nhrùq hadrang tì ta mahem, èh da'rat tapèh yàng enh ngìa ca Chuaq, aih enh ngìa ca bai prình Nòi Hadròih. ");
INSERT INTO hre_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Khoi èh pajàu phai xùt mahem ta 'bài aki ta ca'bŏng bùh jreo xua thùm enh ngìa ca Chuaq ŏi ta Hnem Traiq Cùh Waiq; hi khoi ùc dŏng dìq mahem da 'bo bu chuai aih ta xèm ca'bŏng tadreo ma ŏi jang 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Haq phai dŏih ramaq 'bo ma broq ngè tadreo rŏt hlài enh tôiq lôi, aih ramaq ma top roc caxènh crŏng wa ramaq cliac haq, ");
INSERT INTO hre_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","baiq toq plì crŏng xam ramaq dìq, ramaq ŏi kenh ca'bŏng, khoi èh cađac 'nah clèm wa baiq plì crŏng, ");
INSERT INTO hre_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","tìah ca ma dŏih enh 'bo chuai broq ngè tadreo waiq catèm; hi khoi pajàu phai bùh ngè aih ta ca'bŏng tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","mahaq akia, jam, gàu, jènh, cliac wa ìch haq, ");
INSERT INTO hre_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","pajàu phai 'ràng 'noh enh gùng ca traiq jàn ta mòiq nòi hreo, aih nòi ùc blo tanùh enh ca'bŏng tadreo, tah dŏng ngè aih enh 'nhèq ca long ùnh khoi èh bùh đac. ");
INSERT INTO hre_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Mahaq tàng dìq dŏng ca wì jàn Is-ra-ên broq ùh troq mòiq toq ta 'bài ranenh da Chuaq ma ùh khòh broq, mahaq cla wì ùh 'nì, 'nhac 'màng aih wì haq xôq pòq tôiq; ");
INSERT INTO hre_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Jò wì haq khoi loq ca dađeh broq tôiq, dìq ca wì haq phai am mòiq toq 'bo chuai đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, 'ràng 'bo aih enh ngìa ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Èh 'bài craq broq gàu phai đòiq tì agàu 'bo aih, hi khoi pàc haq enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Èh pajàu ma khoi jah xùt dàu phai 'ràng 'nah mahem 'bo aih mùt Hnem Traiq Cùh Waiq, ");
INSERT INTO hre_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","'nhrùq dèh hadrang tì ta mahem, da'rat tapèh yàng enh ngìa ca Chuaq, ta jang ca bai prình. ");
INSERT INTO hre_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Khoi èh, haq phai xùt mahem aih ta 'bài aki da ca'bŏng bùh jreo xua thùm enh ngìa ca Chuaq ta Hnem Traiq Cùh Waiq; hi khoi ùc dŏng dìq mahem da 'bo bu chuai aih ta xèm ca'bŏng tadreo ma ŏi jang 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Haq phai dŏih dŏng ramaq haq 'ràng bùh ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Bìac broq tadreo am 'bo bu chuai cô hadai tìah ca 'bo am broq ngè tadreo rŏt hlài enh tôiq lôi, 'màng aih pajàu jah rŏt hlài enh tôiq lôi pajùm dìq ca jàn, hi khoi wì haq jah baxŏng tôiq. ");
INSERT INTO hre_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Hi khoi haq phai 'ràng 'bo bu chuai aih loh enh gùng ca traiq jàn, bùh đac tìah ca ma khoi bùh 'bo bu chuai adroi. Aih ngè am tadreo rŏt hlài enh tôiq lôi dìq ca jàn. ");
INSERT INTO hre_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Tàng i mangai cwan leq taiq troq lò ùh dì tiaq mòiq ta 'bài ranenh Chuaq, Boc Plình da haq, broq bìac ma ùh khòh broq, taiq nen aih haq i tôiq. ");
INSERT INTO hre_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Jò leq cla haq canao loq dèh ca tôiq haq ma khoi broq, èh haq phai 'ràng trùh mòiq toq bubi calô ùh i ca teo xìt leq, broq ngè tadreo ca dađeh. ");
INSERT INTO hre_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Haq phai đòiq tì agàu bubi aih, hi khoi pàc haq enh ngìa ca Chuaq, ta nòi ma pàc ngè aban broq ngè tadreo bùh. Aih ngè tadreo rŏt dèch hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Èh pajàu phai 'nhrùq dèh hadrang tì ta mahem ngè ma tadreo rŏt hlài enh tôiq lôi, xùt ta aki ca'bŏng tadreo. 'Nah mahem ŏi rah haq phai ùc jang xèm ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Dìq ramaq da 'bo bu chuai aih haq phai bùh troi ma bùh ramaq ngè tadreo waiq catèm. 'Màng aih pajàu jah broq ca haq bìac rŏt hlài enh tôiq lôi, èh haq jah baxŏng tôiq. ");
INSERT INTO hre_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Tàng i mangai leq ŏi ta jàn taiq troq lò ùh dì tiaq mòiq ta 'bài ranenh Chuaq, hi broq bìac ma ùh khòh broq, taiq nen aih haq i tôiq. ");
INSERT INTO hre_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Jò leq cla haq canao loq dèh ca tôiq haq ma khoi broq, èh haq phai 'ràng trùh mòiq toq bubi cadrì ùh i ca teo xìt leq broq ngè tadreo taiq tôiq haq khoi broq. ");
INSERT INTO hre_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Haq phai đòiq tì agàu bubi aih, hi khoi pàc haq nòi ma pàc 'bài ngè aban broq ngè tadreo bùh. ");
INSERT INTO hre_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Pajàu phai 'nhrùq dèh hadrang tì ta mahem, xùt ta 'bài aki ca'bŏng tadreo ngè tadreo bùh, hi khoi ùc dŏng mahem ta xèm ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Hi khoi haq phai dŏih dŏng ramaq haq tìah ca ma dŏih ramaq ngè tadreo waiq catèm ca mangai aih, èh bùh ngè atŏc nhòi aih broq hòi xua thùm am ca Chuaq, èh tôiq haq jah baxŏng. ");
INSERT INTO hre_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Mahaq tàng ngè tadreo haq xam con trìu đòiq broq ngè tadreo taiq tôiq, èh ep am mòiq toq trìu cadrì ùh i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Haq phai đòiq tì agàu trìu aih, hi khoi pàc haq nòi ma pàc 'bài ngè aban broq ngè tadreo bùh. ");
INSERT INTO hre_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Pajàu phai 'nhrùq dèh hadrang tì ta mahem, xùt ta 'bài aki ca'bŏng tadreo ngè tadreo bùh, hi khoi ùc dŏng rah mahem ta xèm ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Hi khoi haq phai dŏih dŏng ramaq tìah ca dŏih ramaq trìu da ngè tadreo waiq catèm, 'ràng bùh ta ca'bŏng tadreo tìah ca 'bài ngè tadreo xam ùnh am ca Chuaq, 'màng aih pajàu jah broq tadreo đòiq rŏt hlài tôiq lôi ca mangai aih, èh tôiq haq jah baxŏng. ");
INSERT INTO hre_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Tàng mangai leq khoi pachac đòiq anoi hlài bìac haq ma hnoq, mahaq haq ùh anoi 'noh bìac haq ma khoi hnoq wa bìac haq ma khoi loq, èh mangai hnoq aih khoi i tôiq. ");
INSERT INTO hre_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Tàng i mangai leq bèq ngè amùa, hanang da 'bài ngè aban ta hnem, hanang da 'bài ngè ta rôm, loq hanang da 'bài ngè 'yêh ma rìh ta đùng ùh lem hreo, 'nhac ca ùh 'nì ca dađeh troq đùng, èh hadai 'bìq amùa wa i tôiq. ");
INSERT INTO hre_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Tàng mangai aih bèq bìac ùh hadròih da con mangai, ùh kè ca troq đùng 'mang leq, 'nhac ca loq, loq ùh 'nì, èh mangai aih hadai i tôiq. ");
INSERT INTO hre_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Jò i mangai leq troq lò pachac, 'nhac ca pachac ca bìac lem loq bìac dù mahaq ùh hèm adroi, khoi ca aih men loq dèh ca bàu pachac aih blùng lèh, èh haq i tôiq. ");
INSERT INTO hre_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","'Màng aih, tàng haq khoi loq haq broq tôiq mòiq ta bìac ma khoi pa'noh cô, èh mangai aih phai anoi 'noh dađeh broq tôiq cleq? ");
INSERT INTO hre_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Hi khoi taiq tôiq haq ma khoi broq, haq phai 'ràng ca Chuaq mòiq toq trìu cadrì, loq bubi cadrì, đòiq broq ngè tadreo rŏt dèch hlài enh tôiq lôi, èh pajàu broq lè rŏt dèch hlài tôiq lôi da haq. ");
INSERT INTO hre_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Tàng mangai aih ùh i đeh ca 'bac rŏt trìu loq bubi cadrì, èh taiq tôiq haq ma khoi broq, haq phai 'ràng trùh ca Chuaq baiq toq chìm trù gùng, loq baiq toq chìm trù clôi, mòiq đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, mòiq đòiq broq ngè tadreo bùh. ");
INSERT INTO hre_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Haq phai 'ràng chìm aih trùh ca pajàu. Pajàu phai yŏc mòiq toq ma adroi broq ngè tadreo rŏt hlài enh tôiq lôi, wech ranŏng chìm, mahaq ùh am gàu haq catech. ");
INSERT INTO hre_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Pajàu phai da'rat mahem da chìm mòiq pah da ca'bŏng tadreo. Mahem ŏi i rah ùc dŏng jang xèm ca'bŏng tadreo, aih lè rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Hi khoi chìm ma baiq broq lè tadreo bùh tiaq troq ranenh ma khoi pachì đòiq. 'Màng aih, pajàu broq lè rŏt hlài enh tôiq lôi ca haq, pàng aih tôiq haq jah baxŏng. ");
INSERT INTO hre_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Tàng haq chaq ùh jah baiq toq chìm trù gùng loq baiq toq chìm trù hnem, èh taiq tôiq haq ma khoi broq, haq phai 'ràng mòiq phàn mòiq jàt êpha dàc 'yêh đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, ùh ùc dàu hadai ùh tah tam nhù hùang, ma jah 'màng aih cô ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Mangai aih phai 'ràng dàc aih ca pajàu. Pajàu phai yŏc mòiq cadop dàc đòiq broq lè hmàng wa lè tadreo bùh ta ca'bŏng tadreo, tiaq troi ngè tadreo bùh xam ùnh am ca Chuaq, aih ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Jò pajàu broq lè rŏt hlài enh tôiq lôi ca mangai ma khoi broq mòiq ta 'bài ranenh ma khoi anoi enh 'nhèq cô, tôiq lôi haq jah baxŏng. Phàn dàc ma ŏi rah aih da pajàu, tìah ca ngè dèch am xam 'mau mì.’ ” ");
INSERT INTO hre_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Hi khoi Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Tàng i mangai leq troq lò đùng trùh ngè hadròih leq da Chuaq, èh haq phai 'ràng am ca Chuaq mòiq toq trìu calô ùh i ca teo xìt leq rùp enh calùh trìu, tình jaq toq siêclò 'bac tiaq troi siêclò da Hnem Traiq Cùh Waiq, aih ngè tadreo rŏt dèch hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Mangai aih phai đèn, èh am tam mòiq phàn padam cùng ngè ma khoi troq lò nòi hadròih, khoi èh am 'bac aih ca pajàu. Pajàu yŏc trìu aih broq lè rŏt hlài enh tôiq lôi ca haq, èh tôiq haq jah baxŏng. ");
INSERT INTO hre_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Tàng jò leq i mangai ùh broq tiaq mòiq bìac ta ranenh da Chuaq mahaq cla haq ùh 'nì khoi broq, èh mangai aih i tôiq wa ep pòq tôiq lôi cla. ");
INSERT INTO hre_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Mangai aih taiq tôiq dađeh haq phai 'ràng trùh ca pajàu mòiq toq trìu calô, ùh i ca teo xìt leq rùp dèh ta calùh haq, tiaq manoh tình pajaq, khoi èh pajàu jah broq lè rŏt hlài enh tôiq lôi ca haq ma khoi troq lò broq tôiq cla haq ùh 'nì, èh tôiq lôi haq jah baxŏng. ");
INSERT INTO hre_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Aih ngè tadreo rŏt hlài enh tôiq lôi taiq haq joq 'nàng khoi i tôiq enh ngìa ca Chuaq.” ");
INSERT INTO hre_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Èh Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Jò leq i mangai broq tôiq ca Chuaq, tiaq trong haq 'nùt amòng ca mangai haten hatìa doi: bìac wì ma am haq wèq đò khoi hù hnhung, loq khoi 'bìq wì atùng, ");
INSERT INTO hre_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","loq tŏch jah ngè bìac wì đac clìh khoi èh chôiq đac, loq pachac patìah. Tàng mangai leq broq bìac 'màng aih, mangai aih khoi broq tôiq, ");
INSERT INTO hre_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","jò leq khoi broq tôiq wa i lôi 'màng aih, èh mangai aih phai ca'naih hlài ngè ma atùng aih, bìac ma khoi ta'miaq yŏc, loq bìac tình am wê đò, loq bìac wì ma cađac clìh, ");
INSERT INTO hre_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","loq pachac patìah đòiq jah yŏc da wì ngè bìac cleq, èh mangai aih ep ca'naih hlài tôm tàu. Khoi ca aih haq phai am tam ca wì mòiq phàn padam tình tiaq cùng da ngè aih am hlài da cla wì hì leq haq ma am ngè tadreo rŏt hlài bìac haq ma broq tôiq. ");
INSERT INTO hre_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Tiaq dèh haq ma khoi pajaq, mangai aih phai rùp ta calùh mòiq toq trìu calô ùh i ca teo xìt leq, 'ràng trùh ca pajàu đòiq broq ngè tadreo rŏt hlài enh tôiq lôi ca dađeh, enh ngìa ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","èh pajàu jah broq lè rŏt hlài enh tôiq lôi ca mangai aih enh ngìa ca Chuaq, èh tôiq lôi haq jah baxŏng, ùh kè ca lôi cleq.” ");
INSERT INTO hre_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Ìh phai doi bàu cô ca Arôn wa ca 'bài con calô haq: ‘Cô ranenh da 'bài ngè tadreo bùh. Ngè tadreo bùh phai ŏi enh 'nhèq ca ùnh ta ca'bŏng tadreo 'ngah ca mang trùh daxroq, wa ùnh ta ca'bŏng tadreo ùh jah pat trùh 'ngah. ");
INSERT INTO hre_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Pajàu phai caxùnh eo xam bai briang wa atàc cwàn enh dalam xam bai briang, hi khoi acom blo tanùh ùc pah kenh ca ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Khoi ca aih lêh eo aih, caxùnh eo ma 'noiq, 'ràng blo tanùh aih loh enh gùng ca traiq, ùc đac ta mòiq nòi lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ùnh ta ca'bŏng tadreo phai khàng yôt, ùh khòh pat. Rìm xroq pajàu phai yŏc long ùnh bùh tam ta aih, tah ngè tadreo bùh enh 'nhèq, èh bùh ramaq da ngè tadreo waiq catèm ta aih. ");
INSERT INTO hre_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ùnh phai khàng yôt ta ca'bŏng tadreo, ùh khòh pat. ");
INSERT INTO hre_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Cô ranenh da lè dèch am 'mau mì: 'Bài con calô Arôn phai am ngè dèch am cô ta ca'bŏng tadreo enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Mòiq ngai da wa haq phai yŏc mòiq cadop dàc 'yêh ta ngè am 'mau mì cô, dàu wa nhù hùang ma khoi tah enh 'nhèq ca 'mau mì, èh 'ràng bùh ta ca'bŏng tadreo đòiq broq ngè tadreo i hòi xua thùm ca Chuaq, đòiq broq lè bahmàng. ");
INSERT INTO hre_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Dàc ma ŏi rah, Arôn wa 'bài con calô haq caq ùh alôn ca blo ta mòiq nòi hadròih, aih xàn Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Wì ùh khòh pai dàc aih alôn ca blo. Aih phàn Au khoi am ca wì haq ta 'bài ngè tadreo ma dìq jaq hadròih, tìah ta ngè tadreo rŏt hlài enh tôiq wa ngè tadreo rŏt hlài enh lôi. ");
INSERT INTO hre_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Rìm ngai calô ta xinoi Arôn jah caq 'bài ngè tadreo cô. Cô mòiq ranenh hloi hloi ca hadròng hadrech pì ta 'bài ngè tadreo yŏc ùnh am ca Chuaq, mahaq toq mangai ma khoi wìa pajàu men jah caq.’ ” ");
INSERT INTO hre_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Hi khoi Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Cô ngè am Arôn wa 'bài con calô haq phai am Chuaq hì wì haq broq lè xùt dàu: Mòiq phàn mòiq jàt êpha dàc 'yêh, aih ngè dèch am xam 'mau mì, mòiq ha'ne am jò daxroq, mòiq ha'ne am jò daxèq. ");
INSERT INTO hre_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ngè am aih adrenh đòiq ta gŏc chao alôn ca dàu. Jò khoi chìn hi 'ràng cat loh tang ha'nech đòiq am atŏc i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Con calô leq ta ca xinoi Arôn ma neo jah xùt dàu hadròih đòiq thai ca Arôn ep broq am ngè tadreo cô hì wì jah xùt dàu. Cô ngè tadreo phai bùh dìq dŏng am ca Chuaq. Aih wìa mòiq ranenh wì haq ep broq hloi hloi. ");
INSERT INTO hre_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","'Màng aih, rìm ngè dèch am xam 'mau mì cô wì ep bùh dŏng dìq, ùh khòh caq.” ");
INSERT INTO hre_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Hi khoi Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Ìh phai doi ca Arôn wa 'bài con calô haq: ‘Cô ranenh ca ngè tadreo rŏt hlài enh tôiq lôi, ep pàc ngè tadreo cô enh ngìa ca Chuaq, ta nòi wì ma pàc ngè tadreo bùh. Aih ngè tadreo dìq jaq hadròih. ");
INSERT INTO hre_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Pajàu leq am ngè tadreo rŏt hlài enh tôiq aih phai caq jam aih ta nòi hadròih ta xàn da Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Toq mangai ma khoi wìa pajàu men jah bèq jam aih. Tàng i mahem haprah troq eo mangai leq, èh phai rùh ta nòi hadròih. ");
INSERT INTO hre_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Tàng khoi tàm eo aih ta 'balù broq xam taneh, èh phai broq padah gŏc aih, mahaq tàng tàm ta gŏc broq xam đùng, èh phai coih, khoi èh 'nheo ta diac đòiq jah hreo. ");
INSERT INTO hre_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Rìm gu calô ma broq pajàu jah caq jam tadreo rŏt enh tôiq lôi cô. Cô ngè tadreo dìq jaq hadròih. ");
INSERT INTO hre_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Mahaq ùh khòh caq jam da ngè tadreo rŏt hlài enh tôiq lôi tàng mahem haq khoi 'ràng 'mùt ta Nòi Hadròih đòiq waiq rŏt hlài enh tôiq lôi. Aih ep bùh dŏng dìq. ");
INSERT INTO hre_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Cô ranenh da ngè tadreo đòiq rŏt dèch hlài enh tôiq lôi. Ngè tadreo aih phai dìq jaq hadròih. ");
INSERT INTO hre_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Wì haq phai pàc ngè aban aih đòiq tadreo ta nòi ma pàc 'bài ngè aban broq ngè tadreo bùh, hi khoi da'rat mahem dudan ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Èh haq am dìq ca ramaq xam ramaq tenh wa ramaq ma top roc caxènh crŏng wa ramaq cliac, ");
INSERT INTO hre_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","wa baiq toq plì crŏng xam ramaq da plì crŏng dìq, ramaq ŏi kenh ca'bŏng, ");
INSERT INTO hre_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Pajàu bùh dŏng dìq ta ca'bŏng tadreo, broq ngè tadreo xam ùnh am ca Chuaq. Aih ngè tadreo broq rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Rìm mangai calô ta 'bài pajàu jah caq jam cô ta nòi hadròih, aih ngè tadreo dìq jaq hadròih. ");
INSERT INTO hre_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Ngè tadreo rŏt hlài enh hiniq lôi hadai tìah ca ngè tadreo rŏt hlài enh tôiq lôi, ranenh haq hadai tìah ca dabau, 'bài ngè ma tadreo aih jah dŏng pajàu ma khoi tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Pajàu ma am ngè tadreo bùh leq, èh jah yŏc akia ngè aban ma tadreo aih. ");
INSERT INTO hre_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","'Bài lè dèch am 'mau mì khoi pai ta tanùh, chiang ta gŏc chao loq bùh ta ùnh, èh jah dŏng pajàu ma yòng am tadreo. ");
INSERT INTO hre_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Rìm lè dèch am 'mau mì alôn dàu loq ùh alôn dàu, aih jah axong ca 'bài con calô Arôn. ");
INSERT INTO hre_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Cô ranenh đòiq broq ngè tadreo waiq catèm dèch am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Tàng i mangai leq dèch am ngè tadreo manè apôi dèch am pajùm ti ngè tadreo aih, 'bài 'benh 'yoh xùt dàu ùh alôn ca blo loq 'benh ratang xùt dàu ùh alôn blo wa xam dàc 'yêh alôn broq 'benh 'yoh xùt dàu. ");
INSERT INTO hre_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pajùm ca ngè waiq catèm đòiq manè apôi, haq phai am 'benh alôn ca blo hòm. ");
INSERT INTO hre_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Haq phai yŏc mòiq hiniq ta 'bài ngè tadreo cô dèch tì am ca Chuaq. Phàn ma ŏi rah jah dŏng 'bài pajàu ma khoi da'rat mahem da ngè tadreo waiq catèm. ");
INSERT INTO hre_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Jam da ngè tadreo waiq catèm đòiq manè apôi, èh phai caq dŏng dìq hì aih, ùh khòh đòiq rah trùh xroq èh. ");
INSERT INTO hre_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Mahaq tàng 'bài ngè tadreo cla to enh am loq am taiq haq pachac, tàng caq hì aih ùh dìq, đòiq caq hì da èh xôq ùh troq cleq, ");
INSERT INTO hre_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","mahaq tàng ŏi i rah trùh hì ma piq èh phai bùh đac. ");
INSERT INTO hre_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Mangai leq ma caq ngè tadreo waiq catèm hì ma piq, ngè tadreo aih loh ca pi xìt. Mangai ma caq jam aih phai pòq tôiq. ");
INSERT INTO hre_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Ùh jah caq jam khoi đùng trùh bìac amùa, jam aih phai bùh đac. Jam ma 'noiq mangai leq hadròih men jah caq. ");
INSERT INTO hre_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Mahaq mangai leq caq jam tadreo waiq catèm da Chuaq jò haq ùh lem hreo, èh mangai aih phai 'bìq hnan đac, pi am haq ŏi dèh ti jàn hòm. ");
INSERT INTO hre_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Tàng mangai leq đùng trùh bìac amùa da con mangai loq da 'bài ngè aban loq bìac cleq 'mèq 'mac, khoi èh caq jam tadreo waiq catèm da Chuaq, èh phai 'bìq hnan đac, pi am haq ŏi dèh ti jàn hòm.’ ” ");
INSERT INTO hre_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Ìh phai doi ca jàn Is-ra-ên: ‘Ùh khòh caq ramaq 'nhac ca ramaq 'bo, trìu loq bubi. ");
INSERT INTO hre_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ramaq 'bài ngè aban ma cachìt loq jam rôm 'bìq ngè rôm hich, jam aih jah đòiq broq ta bìac ma 'noiq mahaq joq 'nàng ùh khòh caq. ");
INSERT INTO hre_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ma jah 'màng aih tàng mangai leq caq ramaq da jam wì ma yŏc ùnh bùh am ca Chuaq, haq phai 'bìq hnan 'noh đac enh jàn cla. ");
INSERT INTO hre_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ta nòi leq pì ma ŏi, ùh khòh caq mahem, 'nhac ca mahem chìm loq ngè aban ma 'noiq. ");
INSERT INTO hre_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Tàng mangai leq caq mahem, 'nhac ca mahem cleq, phai 'bìq hnan 'noh đac enh jàn cla.’ ” ");
INSERT INTO hre_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Ìh phai doi ca jàn Is-ra-ên: ‘Mangai leq am ngè tadreo waiq catèm ca Chuaq, ngè tadreo aih cla haq phai 'ràng trùh. ");
INSERT INTO hre_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Tì cla Mangai aih 'ràng dèch am xam ùnh ca Chuaq: Aih ramaq wa rada haq đòiq broq ngè tadreo am lam, am hlài enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Khoi èh pajàu phai bùh ramaq enh 'nhèq ca'bŏng tadreo, mahaq rada haq jah Arôn wa 'bài con calô haq. ");
INSERT INTO hre_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Enh ngè tadreo waiq catèm, pì phai am ca pajàu cataih pah 'ma đòiq broq ngè am. ");
INSERT INTO hre_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Mangai leq ta 'bài con calô Arôn am mahem wa ramaq da ngè tadreo waiq catèm, èh cla haq jah cataih pah 'ma. ");
INSERT INTO hre_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ma jah 'màng aih ta 'bài ngè tadreo waiq catèm da jàn Is-ra-ên, Au yŏc rada wa cataih da ngè tadreo ma am lam am hlài enh ngìa ca Au, đòiq am ca pajàu Arôn wa 'bài con calô haq, tiaq troi ranenh hloi hloi da jàn Is-ra-ên ma phai wèq.’ ” ");
INSERT INTO hre_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Aih phàn ta ngè tadreo bùh am ca Chuaq, phàn ma lah crài loh hadròih am ca Arôn wa 'bài con calô haq jah nhàn enh hì ma wì haq baxèm broq pajàu patìh ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Aih bìac Chuaq khoi tanap ca jàn Is-ra-ên phai am ca wì haq nèh, hì wì ma khoi jah xùt dàu, aih mòiq ranenh hloi hloi enh 'nhòng cô trùh 'nhòng tau. ");
INSERT INTO hre_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Aih ranenh da ngè tadreo bùh, lè dèch am 'mau mì, ngè tadreo broq rŏt hlài enh tôiq lôi, ngè tadreo broq rŏt hlài bìac hiniq lôi, ngè tadreo đòiq atŏc broq pajàu wa ngè tadreo waiq catèm. ");
INSERT INTO hre_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Chuaq khoi doi ca Môise ta wang Sinai, hì ma Haq tanap thê jàn Is-ra-ên am ngè tadreo dađeh ca Chuaq ta đùng hawit Sinai. ");
INSERT INTO hre_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“ 'Ràng ca Arôn wa 'bài con calô haq, xam eo yôh, dàu xùt, 'bo bu chuai đòiq broq ngè tadreo rŏt dèch hlài enh tôiq lôi, baiq toq trìu calô, wa mòiq rajo 'benh ùh i ca blo, ");
INSERT INTO hre_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","hi khoi tagop dŏng dìq ca jàn enh ngìa ca 'mang Hnem Traiq Cùh Waiq.” ");
INSERT INTO hre_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Môise broq tiaq troq troi bàu Chuaq ma tanap. Wì jàn tagop dìq enh ngìa ca 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Môise doi ca wì jàn: “Cô bìac Chuaq khoi thê au broq.” ");
INSERT INTO hre_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Èh Môise thê Arôn wa 'bài con calô haq trùh haten, hi khoi yŏc diac 'nheo wì haq. ");
INSERT INTO hre_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Haq caxùnh eo yôh taboc ca Arôn, càt caxi ca'nam, caxùnh eo lè, caxùnh êphot càt ha'mai ti ca'nam haq. ");
INSERT INTO hre_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Hi khoi haq ha'mac ca Arôn capiac bac jang rada, èh 'mùt enh dalam capiac bac jang rada aih Urim wa Thumim. ");
INSERT INTO hre_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Haq pacôi ca Arôn mù jang gàu, đòiq capiac xam wang enh ngìa ta mù aih, aih ca lôp Hadròih, broq troq troi bàu Chuaq khoi tanap ca Môise. ");
INSERT INTO hre_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Khoi ca aih Môise yŏc dàu xùt ca Hnem Traiq Cùh Waiq wa dìq ca ngè ma ŏi ta aih lah crài loh hadròih. ");
INSERT INTO hre_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Haq da'rat dàu tapèh yàng ta ca'bŏng tadreo, xùt dàu ca'bŏng tadreo wa dìq ca ranac ma ŏi ta ca'bŏng tadreo, thùng wa jènh thùng đòiq lah crài loh hadròih. ");
INSERT INTO hre_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Èh haq ùc dàu xùt ta gàu Arôn đòiq lah crài haq loh hadròih. ");
INSERT INTO hre_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Khoi èh Môise thê 'bài con calô Arôn trùh haten caxùnh ca wì haq eo yôh taboc, càt ha'mai haq, pacôi mù ca wì haq tìah ca troi Chuaq khoi tanap ca Môise. ");
INSERT INTO hre_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Môise thê 'ràng 'bo calô bu chuai đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, èh thê Arôn wa 'bài con calô haq đòiq tì jang gàu 'bo. ");
INSERT INTO hre_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Môise pàc 'bo yŏc mahem, èh xam tì yŏc mahem aih xùt dudan ca aki da ca'bŏng tadreo, broq ca'bŏng tadreo wìa hadròih. Khoi èh haq ùc dŏng mahem aih roc xèm ca'bŏng tadreo. 'Màng aih haq lah crài ca'bŏng tadreo loh hadròih. ");
INSERT INTO hre_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Haq yŏc dìq ramaq ma glom cliac, ramaq glom clèm, wa ramaq plì crŏng, 'ràng bùh ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Phàn ma ŏi hlài aih, akia, jam wa ìch, èh haq 'ràng bùh enh gùng ca traiq, tìah ca troi Chuaq ma khoi tanap ca haq. ");
INSERT INTO hre_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Môise dèch am trìu calô da ngè tadreo bùh, hi khoi Arôn wa 'bài con calô haq đòiq tì jang gàu trìu calô aih. ");
INSERT INTO hre_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Môise pàc trìu aih, da'rat mahem dudan ti kenh ca ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Jò haq khoi xah jam loh tang ha'nech, haq 'ràng bùh gàu wa ramaq pajùm ca tang ha'nech jam cô. ");
INSERT INTO hre_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Jò Môise khoi yŏc diac 'nheo cliac wa jènh, èh haq bùh dŏng dìq trìu calô aih enh 'nhèq ca'bŏng tadreo. Aih ngè tadreo bùh xam ùnh broq hòi xua thùm am ca Chuaq tìah ca Chuaq ma khoi thê haq. ");
INSERT INTO hre_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Hi khoi Môise yŏc trìu calô ma baiq, aih trìu calô broq ca lè atŏc mangai broq pajàu, Arôn wa 'bài con calô haq đòiq tì agàu trìu calô. ");
INSERT INTO hre_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Môise jêh haq, yŏc mahem xùt adon pah 'ma Arôn, hadrang can tì pah 'ma wa hadrang càn jènh pah 'ma. ");
INSERT INTO hre_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Môise hadai thê 'bài con calô Arôn trùh haten, xùt mahem adon wa haq, hadrang can tì pah 'ma, hadrang càn jènh pah 'ma. Hi khoi Môise da'rat mahem dudan ti kenh ca ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Haq yŏc ramaq wa tenh, dìq dŏng ramaq ma lom cliac, plì clèm, baiq toq plì crŏng wa cataih pah 'ma. ");
INSERT INTO hre_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Enh rajo 'benh ùh i ca blo đòiq enh ngìa ca Chuaq, haq yŏc mòiq toq 'benh 'yoh ùh tah blo, mòiq toq 'benh i dàu, mòiq toq 'benh ratang, 'ràng đòiq 'benh aih enh 'nhèq ca ramaq wa cataih pah 'ma. ");
INSERT INTO hre_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Khoi èh haq đòiq dìq 'bài ngè aih ta tì Arôn wa ta tì 'bài con calô haq. Wì haq dèch am xam bìac am lam am hlài jang ngìa Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Môise hi yŏc 'bài ngè aih enh tì wì haq, 'ràng bùh ta ca'bŏng tadreo pah jam ti ngè tadreo bùh. Aih ngè tadreo lè atŏc mangai broq pajàu wìa ngè tadreo bùh xam ùnh broq hòi xua thùm am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Môise hadai yŏc rada da con trìu calô, dèch am xam bìac am lam am hlài jang ngìa Chuaq. Aih phàn da Môise ma broq lè atŏc mangai broq pajàu tìah ca Chuaq khoi thê haq. ");
INSERT INTO hre_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Atìq ca aih Môise yŏc dàu wa mahem enh ca'bŏng da'rat da Arôn, wa ta eo haq, ta 'bài con calô haq wa ta eo wa haq. 'Màng aih Arôn wa eo haq, 'bài con calô Arôn wa eo wa haq khoi lah crài loh hadròih. ");
INSERT INTO hre_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Hi khoi Môise doi ca Arôn wa 'bài con calô haq: “Pì phai pai jam jang 'mang Hnem Traiq Cùh Waiq, caq jang aih pajùm ca 'benh ta rajo ma broq lè atŏc mangai broq pajàu, tìah ca Chuaq ma khoi thê, doi, ‘Arôn wa 'bài con calô haq caq jam aih.’ ");
INSERT INTO hre_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Mahaq pì phai bùh cađac jam wa 'benh ma ŏi rah. ");
INSERT INTO hre_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Trom tapèh hì pì ùh khòh loh khoi ca 'mang Hnem Traiq Cùh Waiq trùh jò leq 'bài hì lè atŏc mangai broq pajàu da pì jah gêh. ");
INSERT INTO hre_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Rìm bìac bèn khoi broq hì cô, aih bìac Chuaq khoi thê broq đòiq broq rŏt dèch hlài enh tôiq lôi da pì. ");
INSERT INTO hre_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","'Màng aih dahì damang pì phai ŏi jang 'mang Hnem Traiq Cùh Waiq trom tapèh hì tìah ca bàu Chuaq khoi tanap đòiq pì ùh hìaq cachìt.” ");
INSERT INTO hre_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","'Màng aih, Arôn wa 'bài con calô haq broq rìm bìac troq troi bàu Chuaq ma khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Trùh hì rahem, Môise creo ca Arôn, 'bài con calô haq wa 'bài craq da Is-ra-ên, ");
INSERT INTO hre_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","hi khoi haq doi ca Arôn: “Rùp mòiq toq 'bo calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, mòiq toq trìu calô dìq ùh i ca teo xìt leq đòiq broq ngè tadreo bùh am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ìh phai doi ca jàn Is-ra-ên: ‘Pì phai rùp mòiq toq bubi calô broq ngè tadreo rŏt hlài enh tôiq lôi, wa yŏc mòiq toq 'bo con wa mòiq toq trìu con dìq mòiq hanam ùh i ca teo xìt leq, đòiq broq ngè tadreo bùh am ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","wa mòiq toq 'bo, mòiq toq trìu calô, đòiq broq ngè tadreo waiq catèm am ca Chuaq, wa ngè tadreo dèch am xam 'mau mì alôn ti dàu, ma jah 'màng aih hì cô Chuaq jah mahno loh ca pì.’ ” ");
INSERT INTO hre_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","'Màng aih wì haq 'ràng enh ngìa ca Hnem Traiq Cùh Waiq 'bài ngè Môise ma khoi thê, hi khoi dìq dŏng ca jàn trùh haten enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Môise doi: “Cô bìac Chuaq thê pì broq đòiq can 'ngah 'ngai da Chuaq jah mahno loh ca pì.” ");
INSERT INTO hre_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Hi khoi Môise doi ca Arôn: “Ìh trùh haten ca'bŏng tadreo am ngè tadreo rŏt hlài enh tôiq lôi wa ngè tadreo bùh da ìh am ca cla ìh wa am ca jàn jah hadròih. Èh ìh yŏc ngè tadreo da jàn đòiq broq ca wì jah hadròih, aih broq ca wì jah ta-atoq enh ngìa Chuaq, troq troi bàu Chuaq khoi thê.” ");
INSERT INTO hre_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Arôn trùh haten ca'bŏng tadreo, pàc 'bo con đòiq broq ngè tadreo rŏt hlài enh tôiq lôi am ca dađeh. ");
INSERT INTO hre_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","'Bài con calô haq 'ràng mahem ca haq. Haq 'nhrùq hadrang tì ta mahem, xùt ta aki ca'bŏng tadreo, hi khoi ùc rah mahem ta xèm ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Hi khoi haq yŏc ramaq baiq toq plì crŏng wa 'nah clèm 'ràng bùh ta ca'bŏng tadreo troq troi bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mahaq jam wa akia haq 'ràng bùh enh gùng ca traiq. ");
INSERT INTO hre_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Hi khoi haq pàc ngè aban đòiq broq ngè tadreo bùh. 'Bài con calô haq 'ràng trùh ca haq mahem, haq da'rat mahem dudan enh 'nhèq ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Wì 'ràng ca haq jam tadreo bùh, xah tang ha'nech pajùm ca gàu, hi khoi haq bùh dìq enh 'nhèq ca ca'bŏng. ");
INSERT INTO hre_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Arôn 'nheo cliac wa jènh 'ràng bùh enh 'nhèq pajùm ngè tadreo bùh ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hi khoi haq 'ràng ngè tadreo da jàn. Haq pàc mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi da jàn, tìah ca ngè tadreo baxèm. ");
INSERT INTO hre_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Khoi ca aih haq hadai am ngè tadreo bùh tiaq ranenh khoi pachì. ");
INSERT INTO hre_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Khoi ca aih haq dèch am ngè tadreo xam 'mau mì, ùc bình cadop tì dađeh, 'ràng bùh ta ca'bŏng tadreo, broq tam ca ngè tadreo bùh daxroq. ");
INSERT INTO hre_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Èh haq hadai pàc 'bo wa con trìu calô broq ngè tadreo waiq catèm am ca jàn. 'Bài con calô Arôn 'ràng ca haq mahem đòiq da'rat dudan ta 'nhèq ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Wa haq 'ràng ca haq ramaq da 'bo wa ramaq trìu calô aih, tenh, ramaq ma lom ta cliac, baiq toq plì crŏng, wa 'nah clèm, ");
INSERT INTO hre_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","dìq ramaq cô pajùm ca rada, èh bùh pajùm ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Hi khoi Arôn yŏc rada wa cataih pah 'ma, am lam am hlài jang ngìa Chuaq, tìah ca bàu Môise khoi thê. ");
INSERT INTO hre_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Arôn dèch tì ti 'nhèq pah jàn waiq xôq ca wì. Atìq ca am ngè tadreo rŏt hlài enh tôiq lôi, ngè tadreo bùh, wa ngè tadreo waiq catèm, èh haq cadiang loh khoi ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Môise wa Arôn mùt ta Hnem Traiq Cùh Waiq. Jò wa haq loh rai waiq xôq ca jàn, 'ngah 'ngai da Chuaq mahno loh ca jàn. ");
INSERT INTO hre_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Hi khoi, mòiq pla ùnh enh ngìa ca Chuaq loh bùh cheo dŏng ngè tadreo wa ramaq ta ca'bŏng tadreo. Jò dìq ca jàn hnoq 'màng aih, wì haq dêh bàu manè apôi, rai bla-op dèh hadrò ta taneh. ");
INSERT INTO hre_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Baiq ngai con calô Arôn, aih Nađap wa A-bi-hu, wê abôq tah ùnh wa jreo xua thùm ta aih, èh dèch am ca Chuaq mòiq hiniq ùnh ma crài aih ùnh ma Chuaq ùh thê. ");
INSERT INTO hre_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Mòiq pla ùnh loh enh ngìa ca Chuaq cheo đac wa haq. Wa haq cachìt enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Môise doi ca Arôn: “Aih bìac Chuaq enh anoi jò Haq khoi doi: “ ‘Mangai ma lam haten ca Au, Wì ep ngan padèch Au hadròih wa enh ngìa dìq ca jàn, Au phai jah wì padèch ha'nhèq.’ ” 'Màng aih, Arôn ŏi hatenh. ");
INSERT INTO hre_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Môise creo ca Mi-sa-ên wa Ên-xa-phan, baiq ngai con calô da U-xi-ên, dùch da Arôn. Môise doi: “Lam haten beq, tòng hanang wa baiq ngai oh daq pì khoi enh Nòi Hadròih 'noh enh gùng ca traiq.” ");
INSERT INTO hre_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","'Màng aih wì haq trùh haten tòng hanang ŏi raq caxùnh eo ha'mac loh enh gùng ca traiq tìah bàu Môise ma thê. ");
INSERT INTO hre_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Hi khoi Môise doi ca Arôn, Ê-li-a-xa wa I-tha-ma, baiq ngai con calô da Arôn: “Pì apaq dŏih calôp wa apaq hich dèh eo, đòiq pì ùh hìaq cachìt wa Chuaq ùh hìaq nòih ca dìq ca jàn Is-ra-ên. Mahaq oh daq pì wa dìq ca jàn jah hmoi crò taiq nen ùnh ma bùh cachìt ca Nađap wa A-bi-hu. ");
INSERT INTO hre_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Apaq loh khoi ca 'mang Hnem Traiq Cùh Waiq đòiq ùh hìaq cachìt, taiq nen dàu xùt da Chuaq ŏi tì pì.” Wì haq broq tiaq bàu Môise. ");
INSERT INTO hre_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Chuaq hi doi ca Arôn: ");
INSERT INTO hre_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Jò leq mùt ta Hnem Traiq Cùh Waiq, ìh wa 'bài con calô ìh apaq ôq alac nho loq ôq cadroh đòiq pì ùh hìaq cachìt. Aih bàu thê hloi hloi ta 'bài 'nhòng ta atìq, ");
INSERT INTO hre_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","waq ca pì jah hadro bìac hadròih wa bìac ùh hadròih. Bìac lem hreo wa bìac ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Khoi èh jah hnài jàn Is-ra-ên dìq ca bàu thê Chuaq nhò Môise khoi doi am ca wì.” ");
INSERT INTO hre_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Môise doi ca Arôn wa baiq ngai con calô haq ma ŏi rìh, aih Ê-li-a-xa wa I-tha-ma: “Yŏc ngè tadreo dèch am xam 'mau mì ŏi rah atìq ma khoi bùh ta ca'bŏng tadreo am ca Chuaq, caq dahwèq aih ùh alôn blo hloi jang ca'bŏng tadreo, ma jah 'màng aih ngè am cô dìq jaq hadròih. ");
INSERT INTO hre_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Pì phai caq ngè tadreo cô nòi hadròih, ma jah 'màng aih cô phàn da ìh wa 'bài con calô ìh ta 'bài ngè tadreo yŏc ùnh am ca Chuaq taiq Haq khoi thê au broq 'màng aih. ");
INSERT INTO hre_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Mahaq rada da ngè tadreo đòiq dèch atŏc am lam am hlài wa cataih ngè ma tadreo aih, ìh, 'bài con calô ìh wa 'bài con cadrì ìh, jah caq dahwèq aih jang nòi lem hreo, ma jah 'màng aih phàn aih khoi am đòiq broq phàn crài da ìh wa 'bài con calô ìh, enh ngè tadreo waiq catèm da jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Cataih am dèch tŏc wa rada dèch atŏc am lam am hlài, wì phai 'ràng trùh pajùm ramaq ma bùh enh 'nhèq ca'bŏng tadreo tiaq ranenh am atŏc dai cwa dai hlài enh ngìa ca Chuaq. Dahwèq aih jah wìa da ìh wa 'bài con calô ìh broq tiaq ranenh hloi hloi tiaq ca Chuaq ma khoi thê.” ");
INSERT INTO hre_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mahaq Môise chaq bubi ma broq ngè tadreo rŏt dèch hlài enh tôiq lôi, hnoq haq khoi bùh cheo! Môise nòih ca Ê-li-a-xa wa I-tha-ma con calô Arôn, doi: ");
INSERT INTO hre_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Hagleq chôp ma ùh caq jam am ngè tadreo rŏt hlài enh tôiq lôi ta nòi hadròih? Ma jah 'màng aih, aih dahwèq caq dìq jaq hadròih Chuaq khoi am ca chôp waq ca chôp pòq yŏc tôiq da 'bài jàn wa broq lè rŏt hlài enh tôiq lôi ca wì haq enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Cô, taiq mahem haq ùh i 'ràng mùt nòi hadròih, joq 'nàng chôp khòh caq ngè tadreo aih ta Nòi Hadròih tiaq bàu au ma khoi thê.” ");
INSERT INTO hre_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Mahaq Arôn doi hlài ca Môise: “Hì cô wa haq khoi am ngè tadreo rŏt hlài enh tôiq lôi wa ngè tadreo bùh dađeh enh ngìa ca Chuaq. Jò bìac 'màng cô loh ti au, tàng hì cô au khoi caq ngè tadreo rŏt hlài enh tôiq lôi, 'màng aih èh i lem manoh ca Chuaq ùh?” ");
INSERT INTO hre_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Môise tàng bàu aih, haq ŏi catèm. ");
INSERT INTO hre_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Chuaq doi hòm ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Doi ca jàn Is-ra-ên: ‘Ta 'bài ngè rìh ta crŏng taneh, cô 'bài ngè ma pì jah caq. ");
INSERT INTO hre_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Ngè leq i cachop tawah wa loq tacai, èh 'bài ngè aih pì jah caq. ");
INSERT INTO hre_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Ngè leq loq tacai, mahaq cachop ùh tawah aih ùh khòh caq. Lŏcđa, 'nhac ca haq loq tacai, mahaq haq ùh tawah cachop. 'Màng aih phai ngan haq ngè ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Tajŏc loq tacai mahaq ùh i cachop tawah, 'màng aih pì ep ngan dahwèq caq aih ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Padòng wang haq loq tacai mahaq haq ùh i cachop tawah, 'màng aih phai ngan haq ngè ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Chùa haq i cachop tawah mahaq ùh i tacai, 'màng aih phai ngan haq ngè ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Pì ùh khòh caq jam, hadai ùh jah bèq hanang 'bài ngè aih, ma jah 'màng aih, 'bài ngè aih ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘ 'Bài ngè ma rìh ta diac, 'nhac ca diac raxìq loq diac cròng, tàng adrech leq ma i cachep ta akia, èh dìq ngè aih pì jah caq. ");
INSERT INTO hre_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Adrech leq ma ŏi ta diac raxìq loq diac cròng, ngè ma ŏi ta diac, ma leq ma ùh i cachep ta akia, èh ùh khòh caq. Dìq ca ngè aih pì ngan đang ca ramòt. ");
INSERT INTO hre_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Taiq pì phai ngan dìq ngè aih đang ca ramòt. 'Màng aih, pì ùh khòh caq ngè aih, mahaq phai ramòt chac hanang ngè aih. ");
INSERT INTO hre_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ma jah 'màng aih dìq ca ngè ma rìh ta diac, ma leq ma ùh i cachep ta akia, aih ngè pì phai ngan đang ca ramòt. ");
INSERT INTO hre_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘ 'Bài adrech chìm đang ca ramòt ma ùh khòh caq, aih: Chìm cliang, chìm cliang kèn wa chìm cliang cliu, ");
INSERT INTO hre_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","cliang cliu wa dìq dèh adrech tiaq chìm cliang cliu aih, ");
INSERT INTO hre_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","dìq adrech chìm ac, ");
INSERT INTO hre_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","chìm đađìu, chìm da-ôh, chìm diac raxìq wa dìq adrech chìm cliang, ");
INSERT INTO hre_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","chìm da-ôh 'yoh, chìm cli coc diac raxìq, chìm da-ôh càn, ");
INSERT INTO hre_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","da-ôh taboc, chìm talùiq, cliang kèn, ");
INSERT INTO hre_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","chìm cli coc, chìm yiac wa dìq adrech aih, chìm tèn panài wa racàt. ");
INSERT INTO hre_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Dìq ca ngè 'yêh ma rìh ta đùng leq i panan wa lam pôn toq jènh, èh pì đang ca ramòt. ");
INSERT INTO hre_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mahaq ŏi ta dìq ngè 'yêh ma rìh ta đùng, adrech leq ma i panan wa lam pôn toq jènh, pì jah caq ma leq ma i jènh đòiq aplôh ta taneh. ");
INSERT INTO hre_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Aih lìp tiaq dèh adrech haq, lìp tùc tiaq dèh adrech haq, canhenh wa dìq adrech haq. ");
INSERT INTO hre_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mahaq dìq ngè 'yêh ma rìh ta đùng i panan lam pôn toq jènh ma 'noiq èh pì đang ca ramòt. ");
INSERT INTO hre_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Dìq ca ngè aih broq ca pì ùh hreo hadròih. Cabô bèq chac hanang aih, wì haq wìa ùh hreo hadròih trùh chìuq xèq. ");
INSERT INTO hre_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Mangai leq tŏch hanang ngè aih, èh phai rùh dèh eo wa wìa ùh hreo trùh xèq. ");
INSERT INTO hre_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Dìq ngè i cachop, mahaq ùh tawah ùh loq tacai, aih ngè ùh hreo. Mangai leq đùng trùh èh ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Dìq ca ngè rìh lam pôn toq jènh i cachop, èh doi wì aih ùh hreo ca pì. Mangai leq bèq hanang aih, haq phai 'bìq ùh hreo trùh xèq. ");
INSERT INTO hre_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Tàng mangai leq tŏch hanang aih, èh haq phai rùh dèh eo wa 'bìq ùh hreo trùh xèq. Dìq ngè aih ùh hreo ca pì. ");
INSERT INTO hre_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Dìq ca ngè ma lam amoq ta crŏng taneh, aih dìq adrech ma broq ca pì ùh hreo: cani mang mai, cani wa dìq ca adrech tacot, ");
INSERT INTO hre_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","bŏn, tacot, jahòang, tacot ta braih, wa tacot tablòq nhum akia. ");
INSERT INTO hre_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Aih dìq ca ngè ma lam amoq ma broq ca pì ùh hreo. Mangai leq bèq hanang wì aih wìa ùh hreo trùh xèq. ");
INSERT INTO hre_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Jò ngè hanang aih clìh troq dahwèq cleq, èh dahwèq aih loh ca ùh hreo, 'nhac ca dahwèq xam long, eo cwàn, akia, loq 'bao, aih ngè wì ma enh waq, phai tàm ngè aih ta diac. Ngè aih 'bìq ùh hreo trùh xèq, èh men hreo hlài. ");
INSERT INTO hre_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Tàng hanang aih clìh troq cabi xam taneh, dahwèq cleq ma tah ta trom cabi aih, dìq 'bìq ùh hreo, èh phai broq padah đac cabi aih. ");
INSERT INTO hre_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ùh kè ca dahwèq caq cleq 'bìq diac aih haprah, loq diac ôq leq ta rìm abôq, diac aih èh wìa ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Jò ha'nech hanang aih taclìh troq dahwèq cleq, èh dahwèq aih ùh hreo, 'nhac ca tanùh, 'nhac ca gŏc hadai phai raliang cađac. Ngè aih ùh hreo, èh pì ep ngan ngè aih ngè ùh hreo hloi. ");
INSERT INTO hre_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Mahaq tàng mòiq toq diac tamŏc loq mòiq toq 'bau diac hreo 'bìq hanang ngè aban taclìh mùt, diac aih xôq hreo. Mahaq mangai leq bèq hanang aih, èh haq ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Tàng ha'nech hanang aih clìh troq adrech 'nhòq i rai ta đùng, èh adrech aih ŏi hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mahaq tàng adrech ta đùng khoi jah pùc diac 'bìq ha'nech hanang clìh troq, èh adrech aih 'bìq ùh hreo ca pì. ");
INSERT INTO hre_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Jò mòiq ngè aban cleq da pì khòh caq mahaq cachìt, mangai leq bèq hanang aih phai 'bìq ùh hreo trùh xèq. ");
INSERT INTO hre_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Tàng mangai leq caq jam ngè cachìt aih, èh phai rùh dèh eo, khoi èh 'bìq ùh hreo trùh xèq. Tàng mangai leq tòng ngè cachìt aih, èh hadai phai rùh dèh eo wa 'bìq ùh hreo trùh xèq. ");
INSERT INTO hre_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Dìq ca ngè ma 'yêh leq rìh ta đùng moq ta crŏng taneh, dìq 'mèq 'mac, ùh khòh caq jam haq. ");
INSERT INTO hre_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Rìm ngè 'yêh rìh ta taneh moq xam cliac, loq lam pôn toq jènh, loq lam xam bàc jènh, pì ùh khòh caq taiq dìq ngè aih ramòt.p ");
INSERT INTO hre_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Pì apaq broq ca dađeh amùa amech taiq adrech ngè 'yêh rìh ta đùng aih. Apaq broq ca dađeh ùh hreo taiq bìac aih. ");
INSERT INTO hre_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ma jah 'màng aih Au Chuaq Boc Plình da pì, 'màng aih pì phai broq ca dađeh lah crài loh hadròih, taiq Au hadròih. Pì apaq taiq ngè 'yêh leq ma rìh ta đùng broq ca dađeh ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ma jah 'màng aih Au Chuaq, Haq ma khoi 'nong pì loh khoi ca gùng Aicàp đòiq broq Boc Plình da pì. Èh pì phai wìa hadròih ma jah 'màng aih Au hadròih. ");
INSERT INTO hre_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Aih ranenh ta ngè aban, adrech chìm, dìq ngè rìh ta diac, dìq ngè ma 'yêh rìh ta đùng ta crŏng taneh, ");
INSERT INTO hre_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","đòiq achùa ta'ne ngè hreo wa ngè ùh hreo, ta'ne ngè jah caq wa ngè ùh khòh caq.’ ” ");
INSERT INTO hre_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Doi ca jàn Is-ra-ên: ‘Jò mòiq ngai cadrì ŏi jiang khoi xa-ông mòiq toq con calô, èh phai 'bìq amùa trom tapèh hì, tìah ca jò gu cadrì 'nang i mahem. ");
INSERT INTO hre_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Cwa hì rahem, wì phai broq lè cat akia ca con nga calô aih, ");
INSERT INTO hre_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Hi khoi mangai cadrì aih phai denh trom 33 hì trùh jò chac haq jah xrênh, ùh khòh bèq mòiq bìac hadròih leq, loq lam trùh Nòi Hadròih trùh jò haq jah xrênh chac. ");
INSERT INTO hre_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Mahaq tàng haq xa-ông con cadrì, èh haq phai 'bìq amùa trom 14 hì, tìah ca jò haq 'nang i mahem, ep denh trom 66 hì, waq dèh ca chac jah xrênh. ");
INSERT INTO hre_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Jò chac haq hi xrênh, 'nhac ca haq xa-ông con cadrì loq con calô, mangai cadrì aih ep am ca pajàu jang 'mang Hnem Traiq Cùh Waiq mòiq toq trìu con mòiq hanam đòiq broq ngè tadreo bùh, mòiq toq chìm trù hnem loq chìm trù gùng đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Pajàu phai 'ràng am ngè tadreo aih enh ngìa ca Chuaq broq lè rŏt hlài enh tôiq lôi ca mangai cadrì aih, hi khoi haq jah hreo atìq ca bìac loh mahem. “ ‘Aih ranenh da mangai cadrì xa-ông con calô loq con cadrì. ");
INSERT INTO hre_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Mahaq tàng haq ùh i đeh ca trìu con, èh phai i baiq chìm trù gùng loq baiq toq con trù hnem, mòiq đòiq broq ngè tadreo bùh, mòiq đòiq broq ngè rŏt hlài enh tôiq lôi. Èh pajàu broq lè rŏt hlài enh tôiq lôi ca haq, khoi ca aih haq jah hreo.’ ” ");
INSERT INTO hre_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Chuaq doi ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Tàng i mangai leq hnoq ta akia dađeh loh ca pa-êh, patenh loq teo xìt taboc, wìa tìah ca akia dađeh enh loh ca bacùn, èh wì phai ajèn 'ràng mangai trùh ta pajàu Arôn, loq trùh jang mòiq con calô haq ma broq pajàu. ");
INSERT INTO hre_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Pajàu aih phai ngan hlài teo xìt ŏi ta akia ta chac mangai aih, tàng xàc ma hon jang nòi aih loh ca taboc, khoi èh jang aih loh ca trom yi jrùq ca jang 'noiq ta chac haq, aih bình bacùn. Pajàu ngan hlài phai anoi pa'noh da mangai cô ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Mahaq tàng teo xìt taboc ŏi ta akia ta chac haq ùh jrùq yi hnao ca nòi jang 'noiq ta akia ca chac haq, èh xàc haq ma hon jang aih ùh taboc, èh pajàu phai đòiq toq mòiq ngai haq ta nòi crài tapèh hì. ");
INSERT INTO hre_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Trùh hì tapèh, pajàu phai ngan hlài haq. Tàng bình aih ùh hlàm yi hnao wa ùh hìaq loh tam ta akia, èh pajàu phai đòiq toq mòiq ngai haq ta nòi crài trom tapèh hì hòm. ");
INSERT INTO hre_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Trùh hì tapèh, pajàu phai ngan hlài haq hòm. Tàng teo xìt aih khoi taclah, ùh hìaq loh tam ta akia, èh pajàu anoi pa'noh mangai aih khoi hreo. Nòi aih toq patenh. Mangai aih phai rùh dèh eo, èh jah lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mahaq tàng atìq ca haq trùh enh ngìa ca pajàu đòiq jah anoi pa'noh haq khoi hreo, èh patenh loh hòm ta akia haq, haq phai trùh jang pajàu yàng ma baiq hòm. ");
INSERT INTO hre_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Pajàu phai ngan hlài hòm. Tàng hnoq patenh khoi loh tam ta akia, èh pajàu phai anoi pa'noh haq ùh hreo, aih bình bacùn. ");
INSERT INTO hre_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Tàng i mangai leq i bình bacùn loh ta chac haq, èh phai ajèn 'ràng mangai aih trùh enh ngìa ca pajàu. ");
INSERT INTO hre_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Pajàu phai ngan hlài. Tàng hnoq ta akia i nòi êh taboc wa broq ca xàc ma hon jang aih loh ca taboc, khoi èh i xech gòh mahem nòi êh aih, ");
INSERT INTO hre_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","aih bình bacùn khoi dùnh ta akia da chac haq. Pajàu phai anoi pa'noh mangai aih ùh hreo, èh ùh nhet đòiq toq mòiq ngai haq ta nòi crài hòm, ma jah 'màng aih haq khoi 'bìq amùa taiq bình aih. ");
INSERT INTO hre_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Mahaq tàng bình bacùn caq, lom jàp jìa ca akia haq, enh gàu trùh jènh, rìm nòi pajàu ma ngan hnoq, ");
INSERT INTO hre_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","èh pajàu phai ngan hlài da haq. Tàng bình bacùn lom dìq dŏng ca chac haq, èh phai anoi pa'noh mangai aih lem hreo, dài dìq ca teo xìt da haq khoi loh ca taboc jàp ca chac. ");
INSERT INTO hre_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mahaq tàng i xech gòh mahem loh ta chac, èh haq ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Jò leq pajàu hnoq teo xìt ta xech joq gòh mahem, èh phai anoi pa'noh mangai aih ùh lem hreo. Xech gòh mahem ùh lem hreo, aih bình bacùn. ");
INSERT INTO hre_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mahaq tàng xech gòh mahem aih loh ca taboc, èh haq phai trùh ta pajàu. ");
INSERT INTO hre_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Pajàu phai ngan hlài da haq. Tàng teo xìt khoi loh ca taboc, èh phai anoi pa'noh mangai i xìt aih khoi hreo, ma jah 'màng aih khoi jah hreo lem. ");
INSERT INTO hre_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Jò i mòiq ngai leq ta akia haq i patenh khoi jah broq brêh, ");
INSERT INTO hre_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","mahaq jang nòi ma patenh aih i teo êh taboc loh hlài loq i clŏc taboc wa gòh bah, èh mangai aih phai trùh jang ta pajàu. ");
INSERT INTO hre_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Pajàu phai ngan hlài. Tàng teo êh aih loh ca yi jrùq ca akia jang 'noiq, khoi èh tàng xàc jang aih loh ca taboc, èh pajàu phai anoi pa'noh haq ùh lem hreo, aih bình bacùn khoi loh enh nòi adroi i patenh. ");
INSERT INTO hre_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mahaq tàng pajàu ngan hlài hnoq ùh i xàc taboc jang nòi aih, wa ùh yi jrùq ca akia jang 'noiq, wa hnoq haq khoi wìa taclah, èh phai đòiq toq mòiq ngai haq ta nòi crài trom tapèh hì. ");
INSERT INTO hre_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Tàng teo xìt aih caq làn ta akia, èh pajàu phai anoi pa'noh haq ùh lem hreo, aih bình bacùn. ");
INSERT INTO hre_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mahaq tàng teo clŏc taboc aih ùh caq làn ta akia hòm, èh pajàu phai anoi pa'noh mangai aih khoi lem hreo, ma jah 'màng aih, aih toq teo xìt patenh. ");
INSERT INTO hre_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Tàng i mangai leq padŏc ca ùnh, teo padŏc aih loh ca teo xìt gòh bah loq taboc, ");
INSERT INTO hre_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","èh pajàu phai ngan hlài. Tàng xàc jang teo xìt aih loh ca taboc, wa tàng teo xìt aih yi jrùq ca akia, aih bình bacùn loh enh nòi padŏc. 'Màng aih, pajàu phai anoi pa'noh mangai aih ùh hreo, aih bình bacùn. ");
INSERT INTO hre_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mahaq tàng pajàu ngan hlài ùh hnoq xàc taboc jang teo xìt aih, ùh yi jrùq ca akia jang 'noiq, wa hnoq haq khoi taclah, èh phai đòiq toq mòiq ngai haq ta nòi crài tapèh hì; ");
INSERT INTO hre_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Trùh hì tapèh, pajàu phai ngan hlài haq. Tàng teo xìt aih caq làn ta akia, èh phai anoi pa'noh mangai aih ùh lem hreo, aih teo xìt bình bacùn. ");
INSERT INTO hre_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mahaq tàng teo xìt ùh caq làn ta akia, ŏi mòiq nòi wa wìa taclah, aih teo êh enh padŏc. Pajàu phai anoi pa'noh mangai aih lem hreo, taiq teo xìt aih toq teo xìt da padŏc ca ùnh. ");
INSERT INTO hre_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Tàng i mangai cadrì loq mangai calô i habau ta gàu loq ta kiang, ");
INSERT INTO hre_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","èh pajàu phai ngan hlài jang nòi teo xìt aih. Tàng teo xìt yi jrùq ca akia wa i xàc ratang wa nhum ngèq, èh pajàu phai anoi pa'noh haq 'nhòq jah hreo, aih 'bình bacùn loh ta gàu, ta kiang. ");
INSERT INTO hre_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Mahaq tàng pajàu ngan hlài teo xìt aih hnoq yi jrùq ca akia wa ùh i xàc gam, èh phai đòiq toq mòiq ngai haq ta nòi crài tapèh hì taiq haq i bình bacùn. ");
INSERT INTO hre_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Tapèh hì atìq, pajàu phai ngan hlài teo xìt aih. Tàng teo xìt aih ùh caq làn wa ùh i ca xàc ngèq hon ta meh, wa ùh yi jrùq ca akia, ");
INSERT INTO hre_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","èh mangai aih phai got đac xàc dudan jang aih, mahaq ùh khòh got jang teo xìt, èh pajàu đòiq toq mòiq ngai haq ta nòi crài tapèh hì hòm. ");
INSERT INTO hre_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Trùh hì ma tapèh, pajàu hi ngan hlài. Tàng teo xìt aih ùh caq làn ta akia, ùh yi jrùq ca akia, èh pajàu phai anoi pa'noh mangai khoi lem hreo. Mangai bình aih phai rùh dèh eo, èh jah lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mahaq tàng atìq ca jò khoi jah anoi pa'noh haq khoi lem hreo, èh teo xìt aih caq làn hòm ta akia, èh pajàu phai ngan hlài. ");
INSERT INTO hre_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Tàng teo xìt aih khoi caq làn akia, pajàu ùh nhet ca chaq hnoq xàc ngèq hòm. Mangai aih khoi 'bìq ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mahaq tàng teo xìt aih ùh hìaq caq làn akia wa khoi hon xàc gam jang nòi aih, haq khoi brêh, haq khoi lem hreo, wa pajàu jah anoi pa'noh haq khoi lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Jò leq hnoq mangai cadrì loq mangai calô i teo xìt taboc ta akia haq, ");
INSERT INTO hre_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","pajàu phai ngan hlài. Tàng ta akia haq i teo xìt taboc bah, aih patô đeh akia toq i rahenh. Mangai aih xôq ŏi lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Tàng i mangai leq hadrùih xàc gàu, aih mangai ngùn gàu, haq lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Tàng xàc gàu haq hadrùih toq enh ngìa, aih mangai ngùn gàu pah ngòng gàu, haq xôq ŏi lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mahaq tàng ta gàu ngùn loq pah ngòng i teo xìt taboc gòh, aih bacùn loh jang nòi gàu ngùn loq pah ngòng. ");
INSERT INTO hre_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Pajàu phai ngan hlài. Tàng nòi êh ta teo xìt jang nòi gàu ngùn loq pah ngang gàu loh ca taboc gòh bah tìah ca bình bacùn akia chac mangai, ");
INSERT INTO hre_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","èh mangai cô khoi i 'bình bacùn. Pajàu phai anoi pa'noh haq ùh lem hreo. Aih bình bacùn ta gàu haq. ");
INSERT INTO hre_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ 'Màng aih mangai khoi i 'bình bacùn phai hich dèh eo, ca'naih dèh xàc loh lìq làn, rai bàng hacùng rai cachech: ‘Ùh lem hreo, ùh lem hreo.’ ");
INSERT INTO hre_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Jò haq ŏi i 'bình bacùn aih, haq 'bìq ùh lem hreo hloi. Haq phai ŏi mòiq ngai enh gùng ca traiq. ");
INSERT INTO hre_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Jò leq ta eo i teo phòac, 'nhac ca eo xam xàc trìu, loq xam bai briang, ");
INSERT INTO hre_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ta akia loq ta caxi brai xam briang loq brai xam xàc trìu, ta akia loq ta cleq broq xam akia, ");
INSERT INTO hre_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","tàng teo aih loh ca nhum nget loq gòh bah ta eo, ta brai xam akia, aih teo phòac, èh phai 'ràng trùh ca pajàu ngan. ");
INSERT INTO hre_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Pajàu phai ngan hlài teo phòac aih, èh clêh ngè ma i teo aih tapèh hì. ");
INSERT INTO hre_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Hì ma tapèh, pajàu phai ngan hlài jang aih, tàng teo phòac aih caq làn ta eo, ta dang gat loq dang yôh, ta cleq xam akia, èh phai ngan tìah ca bình bacùn caq jàp jìa. Ngè aih khoi ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","'Màng aih pajàu phai bùh cađac eo, 'nhac ta brai dang gat loq dang yôh, ta brai xam xàc trìu loq xam briang, loq ngè cleq broq xam akia i teo phòac aih, aih bacùn. Phai bùh đac dìq ngè aih ta ùnh. ");
INSERT INTO hre_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Mahaq tàng pajàu ngan hlài, pi hnoq teo phòac aih caq làn ta eo, ta brai, loq ngè cleq broq xam akia, ");
INSERT INTO hre_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","èh pajàu phai thê wì rùh 'bài eo ma i phòac aih, khoi èh phai đòiq dìq ngè aih ŏi nòi crài tapèh hì hòm. ");
INSERT INTO hre_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Jò rùh hi gêh, pajàu phai ngan hlài. Tàng phòac aih ùh caq làn tam wa ùh halìh nhum, èh ngè aih khoi ùh lem hreo. Phai 'ràng bùh, ma jah 'màng aih teo phòac khoi caq eo enh 'nhèq wa enh ngìa. ");
INSERT INTO hre_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mahaq tàng jò khoi rùh, pajàu hnoq teo phòac aih khoi taclah, èh phai hich đac teo phòac dŏih khoi enh eo, loq enh cleq akia. ");
INSERT INTO hre_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Tàng phòac ŏi loh ta nòi leq hòm ta eo, loq ta ngè cleq xam akia, aih bìac phòac aih khoi làn tam, èh phai bùh đac ngè aih ta ùnh. ");
INSERT INTO hre_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Mahaq eo, loq brai, loq ngè cleq xam akia khoi rùh, teo phòac khoi taclah, èh phai rùh hlài yàng baiq, men jah lem hreo.” ");
INSERT INTO hre_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Aih ranenh da bìac phòac ta nòi leq ta eo xam xàc trìu loq xam brai habùac loq ta ngè cleq xam akia, đòiq anoi pa'noh lem hreo loq ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Cô ranenh ca mangai bacùn hì haq jah hreo, wì ajèn mangai bacùn trùh nòi pajàu. ");
INSERT INTO hre_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Pajàu phai loh enh gùng ca traiq ngan haq. Tàng teo xìt bacùn da haq khoi jah brêh, ");
INSERT INTO hre_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","èh pajàu thê 'ràng baiq toq chìm ŏi rìh aih adrech chìm hreo lem, long hùang nam, brai nhum gòh mahem wa long xônh. ");
INSERT INTO hre_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Pajàu thê pŏt ranŏng mòiq ŏi ta baiq toq chìm aih ta 'balù broq xam taneh ta diac 'nang loh. ");
INSERT INTO hre_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Khoi ca aih rùp chìm ma ŏi rìh wa long hùang nam, brai gòh mahem, cachiq xônh, 'ràng tah ta mahem chìm tau ma khoi pŏt ranŏng ta diac 'nang loh. ");
INSERT INTO hre_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Pajàu phai da'rat mahem tapèh yàng ta mangai ma khoi jah brêh aih, wa anoi pa'noh haq khoi jah hreo. Khoi èh ca'naih chìm ma ŏi rìh ta đùng. ");
INSERT INTO hre_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Mangai ma khoi jah brêh aih phai rùh dèh eo, got dìq ca xàc, hùm ta diac, khoi èh jah hreo. Khoi ca aih haq jah mùt ta nòi traiq, mahaq haq ùh jah mùt ta hnem traiq dađeh, mahaq phai ŏi enh gùng tapèh hì. ");
INSERT INTO hre_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Trùh hì tapèh haq phai coih dŏng dìq xàc gàu, xàc mum xam xàc canình mat. Hi khoi haq phai rùh eo, hùm ta diac, èh men jah hreo. ");
INSERT INTO hre_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Trùh hì rahem haq phai rùp baiq toq trìu calô ùh i ca teo xìt wa mòiq toq trìu cadrì 'nhòq jah mòiq hanam ùh i ca teo xìt, piq phàn mòiq jàt êpha dàc 'yêh alôn ca dàu broq ngè tadreo dèch am xam 'mau mì wa mòiq 'ne lìt dàu. ");
INSERT INTO hre_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Pajàu broq lè anoi pa'noh haq hreo lem, phai 'ràng mangai 'nang jah brêh ca 'bình aih trùh enh ngìa ca Chuaq jang nòi 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Khoi ca aih pajàu phai rùp mòiq ŏi ta baiq toq trìu calô đòiq am broq ngè tadreo rŏt hlài enh tôiq lôi, wa 'ne lìt dàu, broq tiaq ranenh đòiq atŏc am lam am hlài enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Khoi ca aih haq pàc trìu aih ta mòiq nòi hadròih ma loq jêh 'bài ngè tadreo broq ngè rŏt dèch hlài enh tôiq lôi wa ngè tadreo bùh, ma jah 'màng aih ngè tadreo rŏt dèch hlài enh tôiq lôi wa ngè tadreo bùh, aih phàn da pajàu. Aih ngè dìq jaq hadròih. ");
INSERT INTO hre_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Pajàu phai yŏc mahem ngè ma tadreo rŏt hlài enh bìac pòq lôi, xùt aplì don pah 'ma wa hadrang can tì pah 'ma wa hadrang can jènh pah 'ma. ");
INSERT INTO hre_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Khoi èh pajàu phai ùc toq 'biaq dàu ta capiang tì pah 'ngeo dađeh, ");
INSERT INTO hre_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","'nhrùq hadrang tì pah 'ma ta dàu ŏi ta gêh tì pah 'ngeo dađeh, khoi èh da'rat tapèh yàng enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Dàu ma ŏi hlài ta gêh tì, pajàu phai yŏc xùt ta plì don pah 'ma mangai ma jah brêh aih, ta hadrang tì can pah 'ma wa ta hadrang can jènh pah 'ma, wa xùt dàu enh 'nhèq ca mahem ngè tadreo rŏt hlài enh bìac pòq lôi. ");
INSERT INTO hre_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Dàu ma ŏi i rah ta gêh tì, pajàu phai xùt ta gàu mangai ma khoi jah brêh ca 'bình. 'Màng aih pajàu khoi broq lè rŏt hlài enh tôiq lôi ca haq enh ngìa Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Khoi ca aih pajàu phai am ngè tadreo rŏt dèch hlài enh tôiq lôi ca mangai bacùn jah broq hreo. Khoi ca aih pajàu phai pàc con trìu ma đòiq broq ngè tadreo bùh aih. ");
INSERT INTO hre_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Pajàu phai dèch am pajùm ti ngè tadreo dèch am 'mau mì wa ngè rŏt hlài enh tôiq lôi ta ca'bŏng tadreo. 'Màng aih pajàu khoi broq rŏt hlài enh tôiq lôi ca mangai cô, èh haq khoi jah lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Mahaq tàng mangai aih pa, ùh i đeh ca cùng đòiq am ngè tadreo cô, èh haq phai rùp mòiq toq con trìu calô đòiq broq ngè tadreo rŏt hlài am ca dađeh enh bìac pòq hiniq lôi wa broq tiaq ranenh am lam am hlài đòiq broq lè rŏt hlài enh tôiq lôi am ca haq, èh hadai yŏc mòiq phàn mòiq jàt dàc 'yêh alôn ca dàu broq ngè tadreo dèch am xam 'mau mì wa 'ne lìt dàu. ");
INSERT INTO hre_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Tiaq dèh padren haq ma i, haq hadai 'ràng baiq toq chìm trù gùng loq baiq toq con trù hnem. Mòiq toq đòiq broq lè rŏt hlài enh tôiq lôi, mòiq toq đòiq broq ngè tadreo bùh. ");
INSERT INTO hre_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Trùh hì rahem phai 'ràng trùh dahwèq cô jang nòi Hnem Traiq Cùh Waiq đòiq pajàu jah broq lè broq hreo enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Pajàu phai rùp con trìu calô wa 'ne lìt dàu đòiq broq ngè tadreo rŏt hlài am ca dađeh enh bìac pòq hiniq lôi, hi khoi dèch am tiaq ranenh am lam am hlài enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Khoi ca aih pajàu jêh con trìu ma broq lè rŏt hlài enh bìac pòq hiniq lôi, yŏc mahem xùt aplì don pah 'ma, ta tì hadrang can pah 'ma, wa ta hadrang can jènh pah 'ma da mangai ma jah bìac aih. ");
INSERT INTO hre_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Khoi èh pajàu phai ùc dàu ta tì pah 'nheo dađeh, ");
INSERT INTO hre_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","yŏc hadrang tì pah 'ma 'nhrùq ta dàu tì pah 'ngeo, da'rat tapèh yàng enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Dàu ma ŏi hlài ta gêh tì, pajàu phai xùt ta plì don mangai ma jah brêh aih, ta hadrang can tì pah 'ma wa ta hadrang can jènh pah 'ma, ta nòi ma khoi xùt mahem ngè tadreo rŏt hlài dađeh enh bìac pòq hiniq lôi. ");
INSERT INTO hre_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Dàu ŏi i rah ta tì, pajàu aih phai tah ta gàu mangai ma jah brêh aih. 'Màng aih pajàu khoi broq lè rŏt hlài enh tôiq lôi ca mangai aih enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Khoi èh pajàu phai am mòiq toq chìm trù gùng loq trù hnem tiaq dèh mangai aih ma i. ");
INSERT INTO hre_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Haq phai am ngè tiaq dèh padren haq ma i broq mòiq ngè tadreo rŏt hlài enh tôiq lôi, èh broq ngè tadreo bùh wa ngè tadreo dèch am xam 'mau mì. 'Màng aih pajàu khoi broq lè rŏt hlài enh tôiq lôi da mangai ma khoi jah brêh enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","“Aih ranenh ca lè broq am ca mangai i 'bình bacùn mahaq tiaq dèh padren haq ma i.” ");
INSERT INTO hre_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Chuaq doi ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Jò leq pì trùh ta gùng Ca-na-an nòi Au ma am ca pì đòiq broq xôxech, tàng Au loh am mòiq teo xìt tìah ca teo xìt bacùn ta hnem mangai leq ta gùng pì ma jah broq xôxech. ");
INSERT INTO hre_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Craq hnem aih phai doi ca pajàu: Au hnoq tìah hagleq i teo xìt tìah ca teo xìt bacùn ta hnem au. ");
INSERT INTO hre_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Adroi ca mùt ngan hlài ta hnem aih, pajàu phai thê wì 'noh dŏng dìq dahwèq ta hnem waq ca ùh hìaq 'bìq amùa. Hi khoi pajàu hi mùt ngan hlài ta hnem. ");
INSERT INTO hre_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Pajàu ngan teo xìt. Tàng ta panàt i trom xenh loq gòh loh ca yi jrùq ca nòi ma 'noiq, ");
INSERT INTO hre_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","èh pajàu loh enh gùng, clenh đac 'mang hnem cô trom tapèh hì. ");
INSERT INTO hre_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Trùh hì tapèh, pajàu phai lam ngan hlài. Tàng hnoq teo xìt aih caq làn ta panàt hnem, ");
INSERT INTO hre_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","èh pajàu phai thê wì dŏih đac dìq hmu ma i teo xìt aih, hwenh đac enh gùng ca phôq ta nòi ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Pajàu phai thê wì coih dìq panàt dudan enh dalam hnem, khoi èh acom cađac ngè ma coih aih, 'ràng đac ta nòi ùh hreo enh gùng ca phôq. ");
INSERT INTO hre_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Khoi ca aih, wì phai yŏc hmu 'noiq thai ca hmu wì yŏc 'noh, èh xùt hlài xam capùa dìq panàt jàp ca hnem. ");
INSERT INTO hre_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Mahaq tàng atìq ca khoi dŏih cađac hmu wa khoi coih wa lìch hlài panàt, khoi èh teo xìt aih xôq ŏi loh hlài ta hnem, ");
INSERT INTO hre_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","èh pajàu phai ngan hlài hòm. Tàng hnoq teo xìt caq làn hòm, aih teo xìt bacùn caq jàp jìa ta hnem, hnem aih khoi 'bìq ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","'Màng aih wì phai raliang cađac hnem aih, dìq ca hmu, long wa taneh, 'ràng loh đac dŏng dìq enh gùng ca phôq nòi ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Cabô mùt ta hnem atìq ca wì khoi clenh đac hnem aih, èh mangai aih 'bìq ùh hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Mangai leq ma ca'nùng cùi ŏi hnem aih, phai rùh dŏng dèh eo. ");
INSERT INTO hre_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Mahaq tàng pajàu khoi ngan hlài, hnoq teo xìt pi caq làn hòm ta hnem atìq ca wì khoi lìch hlài, èh pajàu phai doi ro hnem aih khoi hreo lem, ma jah 'màng aih teo xìt khoi hnhung. ");
INSERT INTO hre_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Đòiq broq hreo ca hnem, pajàu phai yŏc baiq toq chìm, long hùang nam, brai gòh mahem wa long xônh, ");
INSERT INTO hre_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","èh jêh mòiq toq chìm ta 'balù broq xam taneh enh 'neq ca diac 'nang loh. ");
INSERT INTO hre_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Khoi èh haq phai yŏc long hùang nam, long xônh, brai gòh mahem wa chìm ma ŏi rìh aih, 'nhrùq ta mahem chìm ma khoi pŏt ranŏng ta diac 'nang loh, khoi èh da'rat tapèh yàng ta hnem. ");
INSERT INTO hre_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","'Màng aih haq jah broq hnem lem hreo tiaq trong yŏc mahem chìm, diac 'nang loh, chìm ŏi rìh, long hùang nam, long xônh wa brai gòh mahem. ");
INSERT INTO hre_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Khoi ca aih haq ca'naih chìm ma ŏi rìh pan loh enh gùng ca phôq trùh đùng. 'Màng aih pajàu phai broq lè rŏt hlài enh tôiq am ca hnem aih, hi khoi hnem aih wìa lem hreo.” ");
INSERT INTO hre_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Aih ranenh ca bìac teo xìt bacùn, ji broq teo xìt rahenh, ");
INSERT INTO hre_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","teo xìt 'bình bacùn ta eo loq ta hnem, ");
INSERT INTO hre_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","teo êh, patenh loq nòi ta akia i clŏc taboc, ");
INSERT INTO hre_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","đòiq hnài jàn waq ca loq jò leq ùh hreo wa jò leq hreo lem. Aih ranenh ca 'bình bacùn. ");
INSERT INTO hre_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Chuaq doi ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Doi ca wì jàn Is-ra-ên: ‘Tàng i mangai calô leq top 'bình jìq làuq i diac loh enh chac, bìac aih ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Bìac amùa aih taiq nen 'bình jìq làuq i diac loh enh chac, 'nhac ca bìac loh aih atàt loq loh hloi hloi, mangai aih xôq 'bìq ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Tàng mangai ma i 'bình làuq i diac loh enh chac ca'nùng cùi ta jùang loq ha'ngui ta ngè leq, èh rìm jùang wa rìm ngè aih dìq 'bìq ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Mangai leq achùq jùang haq, phai rùh dèh eo, hùm ta diac, khoi èh 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Mangai leq ha'ngui troq ngè leq ma mangai ma i 'bình làuq i diac loh enh chac aih ma ha'ngui, phai rùh dèh eo, hùm ta diac, èh 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Mangai leq achùq chac mangai ma i 'bình làuq i diac loh enh chac, phai rùh eo, hùm ta diac, èh 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Tàng mangai ma i 'bình làuq i diac loh, cachôh ca mangai leq, èh mangai aih phai rùh dèh eo, hùm ta diac, èh 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Rìm gèq axêh mangai ma i diac 'bình diac loh enh dèh chac, tŏc còi, gèq axêh aih dìq ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Tàng mangai leq achùq ngè leq ma mangai aih ha'ngui, dìq 'bìq ùh lem hreo trùh chìu xèq. Mangai leq wê 'bài ngè da haq, phai rùh dèh eo, hùm ta diac, èh 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Tàng mangai ma i diac 'bình loh enh chac bèq mangai, mahaq 'nhòq 'nheo dèh tì, èh mangai aih phai rùh eo, hùm ta diac, wa 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Ngè cleq broq xam taneh mangai aih bèq, èh phai đàp cađac, mahaq tàng ranac aih xam long èh phai 'nheo ta diac. ");
INSERT INTO hre_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Tàng diac 'bình aih pi loh, èh mangai aih phai tình enh hì ma brêh trùh tapèh hì, èh haq phai rùh dèh eo, hùm ta diac 'nang loh, èh men jah lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Trùh hì rahem, haq phai rùp baiq toq trù gùng loq trù hnem, trùh enh ngìa ca Chuaq jang nòi 'mang Hnem Traiq Cùh Waiq, hi am ca pajàu. ");
INSERT INTO hre_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Pajàu phai yŏc mòiq toq broq ngè tadreo rŏt hlài enh tôiq lôi, mòiq toq broq ngè tadreo bùh. 'Màng aih taiq nen i diac 'bình loh enh chac da mangai aih, pajàu broq lè rŏt hlài enh tôiq lôi ca mangai aih enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Tàng mangai calô leq loq loh diac taboc, phai hùm dìq ca chac ta diac, khoi èh 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Tàng diac taboc aih clìh ta eo leq wa ngè leq xam akia, phai rùh ta diac, èh ngè aih ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Tàng mangai cadrì wa mangai calô cùi ti dabau, èh phai hùm ta diac, èh ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Jò leq mangai cadrì i mahem, haq phai chìuq ùh lem hreo trom tapèh hì. Tàng mangai leq troq achùq haq, èh mangai aih 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Rìm hiniq nòi haq ca'nùng cùi loq ha'ngui jò i mahem, ngè aih wìa ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Mangai leq achùq jùang haq, phai rùh dèh eo, hùm ta diac, èh haq 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Mangai leq achùq ngè haq ma khoi ha'ngui, phai rùh eo, hùm ta diac, èh 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Mangai leq achùq ngè cleq ta jùang loq ngè leq haq ma ha'ngui, haq 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Tàng i mangai calô leq cùi ti mangai cadrì troq jò mangai cadrì aih ŏi ùh wìa, èh mangai aih 'bìq ùh lem hreo trom tapèh hì, wa jùang leq mangai calô aih ca'nùng cùi dìq ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Tàng i mangai cadrì i mahem bàc hì, enh gùng ca jò ma i mahem, loq i mahem ji bàc hì yi hnao ca jò ma i mahem, èh mangai aih 'bìq ùh lem hreo 'bài hì ma dùnh aih. ");
INSERT INTO hre_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Jùang leq haq ca'nùng cùi loq ngè leq haq ha'ngui, dìq 'bìq ùh lem hreo tìah ca jò haq ma ŏi ùh wìa. ");
INSERT INTO hre_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Mangai leq achùq ngè aih, dìq 'bìq ùh lem hreo. Haq phai rùh dèh eo, hùm ta diac, èh 'bìq ùh lem hreo trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Tapèh hì atìq ca haq ŏi ùh wìa, mangai aih men jah lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Trùh hì rahem mangai aih phai 'ràng trùh ca pajàu mòiq toq trù gùng loq baiq toq chìm trù hnem jang 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mòiq toq chìm broq ngè tadreo rŏt hlài enh tôiq lôi, mòiq toq broq ngè tadreo bùh. 'Màng aih pajàu khoi broq lè rŏt hlài enh tôiq lôi da mangai aih enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘ 'Màng aih pì phai doi ca jàn Is-ra-ên wia hangai ca bìac amùa da wì haq, tàng ùh èh wì haq cachìt ma jah 'màng aih taiq wì haq broq amùa ca Hnem Traiq Cùh Waiq ŏi ta'ne wì haq.’ ” ");
INSERT INTO hre_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Aih ranenh ca mangai calô i 'bình làuq i diac loh enh chac wa mangai i diac taboc loh đòiq broq haq ùh lem hreo. ");
INSERT INTO hre_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Aih hadai ranenh ca mangai cadrì jò ŏi ùh wìa, wa mangai cadrì, loq mangai calô 'bình làuq i diac loh enh chac, loq diac taboc loh, loq mangai calô cùi ti mangai cadrì jò mangai cadrì ŏi ùh wìa. ");
INSERT INTO hre_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Atìq ca baiq ngai con calô Arôn cachìt taiq wa haq broq ùh troq enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Chuaq doi ca Môise: “Doi ca Arôn daq ìh, ùh xài jò leq haq enh mùt, haq jah mùt ta nòi dìq jaq hadròih aih enh ngìa ca hom wêh jao wa calàp baxŏng tôiq. Tàng ùh iu bàu, èh cachìt, ma jah 'màng aih Au mahno loh tì yùc enh 'nhèq ca calàp baxŏng tôiq. ");
INSERT INTO hre_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Mahaq jò Arôn mùt ta nòi dìq jaq hadròih, èh 'mang cô: Haq phai rùp mòiq toq 'bo calô bu chuai đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, wa mòiq toq con trìu calô đòiq broq ngè tadreo bùh. ");
INSERT INTO hre_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Arôn phai caxùnh eo yôh hadròih xam bai habùac, wa eo cwàn enh dalam xam bai habùac, càt mòiq hadrang caxi xam bai habùac ti ca'nam, côi mòiq blah mù xam bai habùac, aih eo hadròih haq caxùnh atìq ca haq khoi hùm. ");
INSERT INTO hre_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Jàn Is-ra-ên hadai phai 'ràng ca Arôn baiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi wa mòiq toq trìu calô đòiq broq ngè tadreo bùh. ");
INSERT INTO hre_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Èh Arôn am 'bo calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi ca dađeh wa am ca cadraq haq. ");
INSERT INTO hre_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Atìq ca aih haq phai yŏc baiq toq bubi calô, 'ràng đòiq enh ngìa ca Chuaq ŏi ta 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Arôn phai pàih panàih đòiq ngan bubi ma leq da Chuaq wa bubi ma leq đòiq pòq tôiq. ");
INSERT INTO hre_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Èh Arôn yŏc bubi calô ma pàih panàih troq ca Chuaq, hi khoi broq ngè tadreo rŏt dèch hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Mahaq bubi ma troq panàih ca pòq tôiq đòiq rìh, đòiq broq lè rŏt dèch hlài tôiq lôi, èh phai ca'naih haq lam ta đùng wang wê đòiq pòq tôiq lôi da jàn. ");
INSERT INTO hre_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Arôn phai am 'bo calô đòiq broq ngè tadreo rŏt dèch hlài enh tôiq lôi am ca dađeh wa cadraq haq. Haq phai jêh 'bo aih đòiq broq lè rŏt dèch hlài enh tôiq lôi ca dađeh wa cadraq dađeh. ");
INSERT INTO hre_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Arôn phai yŏc cachah 'nang cheo ùnh enh 'nhèq ca'bŏng tadreo tah bình ta abôq bùh jreo xua thùm enh ngìa ca Chuaq hi khoi cadop baiq cadop dàc 'yêq xua thùm 'ràng mùt enh trom ca bai prình. ");
INSERT INTO hre_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Arôn phai tah jreo xua thùm ti 'nhèq ca ùnh enh ngìa ca Chuaq waq ca nhòi da jreo xua thùm aih lom jàp ca calàp baxŏng tôiq enh 'nhèq ca hòm wêh jao, nhò broq 'màng aih èh Arôn ùh hìaq cachìt. ");
INSERT INTO hre_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Arôn phai yŏc 'nah mahem da 'bo calô, da'rat xam hadrang tì enh 'nhèq ca calàp baxŏng tôiq pah mat mahì loh, hadai enh ngìa ca calàp baxŏng tôiq haq phai da'rat mahem xam hadrang tì tapèh yàng. ");
INSERT INTO hre_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Atìq ca aih, Arôn phai jêh bubi calô đòiq broq lè rŏt hlài enh tôiq lôi dèch am ca jàn, hi 'ràng mahem aih enh trom ca bai prình, èh da'rat mahem enh 'nhèq ca calàp baxŏng tôiq wa enh ngìa ca calàp aih, broq tìah ca da'rat mahem 'bo calô. ");
INSERT INTO hre_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","'Màng aih, Arôn phai broq lè rŏt dèch hlài enh tôiq ŏi ta nòi hadròih taiq nen bìac amùa, bìac broq ùh troq, wa tôiq lôi ngang dù da jàn Is-ra-ên, hadai broq am ca nòi hadròih wa ca Hnem Traiq Cùh Waiq, ma jah 'màng aih Hnem Traiq Cùh Waiq ŏi ta'ne mòiq jàn amùa amech. ");
INSERT INTO hre_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Jò Arôn mùt ta nòi hadròih đòiq broq lè rŏt hlài enh tôiq lôi, trùh jò haq loh enh aih, èh ùh khòh i mangai leq ŏi ta nòi Hnem Traiq Cùh Waiq jò haq broq lè rŏt hlài enh tôiq lôi ca dađeh, ca cadraq dađeh wa ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Khoi ca aih Arôn loh lam trùh jang ca'bŏng tadreo enh ngìa ca Chuaq, đòiq broq lè rŏt hlài enh tôiq lôi ca ca'bŏng tadreo. Haq phai yŏc mahem 'bo wa mahem bubi xùt jàp ta aki da ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Khoi èh, xam hadrang tì haq da'rat mahem tapèh yàng ta ca'bŏng tadreo, broq lem hreo, đòiq lah crài loh hadròih khoi ca bìac amùa da jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Jò Arôn khoi broq lè rŏt dèch hlài enh tôiq lôi ca nòi hadròih, ca Hnem Traiq Cùh Waiq wa ca'bŏng tadreo, èh haq hadai dèch am bubi calô ma ŏi rìh aih. ");
INSERT INTO hre_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Arôn phai đòiq baiq apah tì jang nòi gàu bubi calô aih, anoi pa'noh enh 'nhèq ca haq bìac ngang dù, wa bìac broq ùh troq, aih dìq tôiq lôi da jàn Is-ra-ên agàu haq, khoi èh thê mòiq ngai ma khoi gòm đòiq broq bìac cô, 'nong haq lam, ca'naih haq ta nòi wang wê. ");
INSERT INTO hre_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","'Màng aih bubi calô aih pòq dìq tôiq lôi da jàn Is-ra-ên ta nòi wang wê hangai. Haq ca'naih bubi ta nòi wang wê. ");
INSERT INTO hre_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Hi khoi Arôn mùt ta Hnem Traiq Cùh Waiq lêh đac dèh eo xam bai habùac ma haq caxùnh jò mùt nòi dìq jaq hadròih, đòiq eo jang aih. ");
INSERT INTO hre_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Hi khoi Arôn phai hùm ta diac ŏi nòi hadròih, caxùnh hlài eo, èh dèch atŏc ngè tadreo am ca dađeh wa ngè tadreo am ca jàn, đòiq broq lè rŏt hlài enh tôiq am ca dađeh wa jàn, ");
INSERT INTO hre_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","yŏc ramaq enh ngè tadreo aih, bùh ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Mangai ma 'ràng bubi lam ca'naih ta nòi braih càn, phai rùh eo, hùm ta diac, hi khoi men jah mùt ta nòi traiq. ");
INSERT INTO hre_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Mahaq mahem da 'bo calô wa bubi calô khoi yŏc broq ngè tadreo rŏt hlài enh tôiq, ma Arôn khoi 'ràng mùt nòi hadròih, èh phai 'ràng enh gùng ca traiq, hi khoi bùh đac dìq ca akia, jam wa ìch. ");
INSERT INTO hre_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Mangai ma bùh đac ngè aih phai rùh dèh eo wa hùm diac. Atìq ca aih haq men jah mùt hlài nòi traiq. ");
INSERT INTO hre_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Bìac cô phai wìa bàu thê hloi hloi ca pì. Hi 10, khê tapèh, rìm ngai Is-ra-ên wa mangai enh jàn 'noiq ŏi đò ta pì, phai paha'neq dèh manoh, apaq broq bìac cleq, ");
INSERT INTO hre_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","taiq hì aih jah broq lè rŏt hlài enh tôiq lôi am ca pì đòiq pì jah lem hreo. 'Màng aih, pì jah lem hreo enh dìq ca tôiq lôi enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Aih hì Sabat, hì padài da pì wa paha'neq dèh manoh. Ranenh cô phai wèq hloi hloi. ");
INSERT INTO hre_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Pajàu ma khoi jah xùt dàu wa atŏc broq pajàu thai dèh ca baq đòiq broq lè rŏt hlài enh tôiq lôi, jah caxùnh eo xam bai habùac, aih eo hadròih, ");
INSERT INTO hre_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","broq lè rŏt hlài enh tôiq lôi ca Nòi Hadròih, ca Hnem Traiq Cùh Waiq wa ca'bŏng tadreo. Haq hadai broq lè rŏt enh tôiq lôi am ca 'bài pajàu wa ca dìq dŏng ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Cô bàu thê hloi hloi đòiq broq mòiq hanam mòiq yàng: Phai broq lè rŏt hlài enh tôiq lôi ca jàn Is-ra-ên đòiq broq lem hreo khoi dìq ca tôiq lôi da wì haq, mòiq yàng rìm hanam.” Arôn broq troq troi bàu Chuaq khoi tanap ca Môise. ");
INSERT INTO hre_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Doi ca Arôn, con calô haq wa dìq ca jàn Is-ra-ên: ‘Cô bàu Chuaq thê: ");
INSERT INTO hre_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Mangai leq da jàn Is-ra-ên, pàc mòiq toq 'bo, mòiq toq trìu, loq mòiq toq bubi ta traiq, loq enh gùng ca nòi traiq, ");
INSERT INTO hre_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Mahaq ùh 'ràng trùh 'mang Hnem Traiq Cùh Waiq đòiq broq ngè tadreo am ca Chuaq, èh mangai aih broq tôiq ùc mahem. 'Màng aih, haq phai 'bìq hnan 'noh khoi dèh ca jàn. ");
INSERT INTO hre_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Bìac cô waq ca jàn Is-ra-ên ùh hìaq pàc ngè tadreo ta đùng mahaq 'ràng ca pajàu enh ngìa ca Chuaq jang 'mang Hnem Traiq Cùh Waiq, đòiq am atŏc broq ngè tadreo waiq catèm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Pajàu phai da'rat mahem da ngè tadreo aih ta ca'bŏng tadreo da Chuaq jang 'mang Hnem Traiq Cùh Waiq wa bùh ramaq đòiq i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Jàn Is-ra-ên ùh jah dèch am ngè tadreo ca kiac i hiniq bubi wa pajùm mòiq manoh ti wì haq. Bìac cô jah wìa bàu thê hloi hloi ta rìm bìac 'nhòng.’ ");
INSERT INTO hre_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ 'Màng aih, ìh phai doi ca jàn Is-ra-ên: ‘Mangai leq ta jàn Is-ra-ên loq mangai diac 'noiq ŏi đò ti wì haq, am ngè tadreo bùh loq ngè tadreo leq, ");
INSERT INTO hre_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ma ùh 'ràng trùh jang 'mang Hnem Traiq Cùh Waiq đòiq am ca Chuaq, èh mangai aih 'bìq hnan 'noh khoi dèh ca jàn. ");
INSERT INTO hre_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Mangai leq da jàn Is-ra-ên loq tamoi ŏi đò, caq mahem cleq, au tajraq hlài ca mangai ma caq aih, hnan haq khoi ca jàn. ");
INSERT INTO hre_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ma jah 'màng aih can rìh da chac xech, aih ŏi ta mahem. Au khoi am ca pì mahem ta ca'bŏng tadreo đòiq broq lè rŏt dèch hlài enh tôiq lôi, 'màng aih nhò can rìh ta mahem, men jah rŏt dèch hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Taiq nen aih, Au khoi doi ca jàn Is-ra-ên: Ŏi ta pì ùh i ca mangai leq jah caq mahem, mangai jàn 'noiq ŏi đò ta 'ne pì hadai ùh jah caq mahem. ");
INSERT INTO hre_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Tàng i mangai leq ta jàn Is-ra-ên, loq tamoi ŏi đò ta'ne pì lam axan, èh jah mòiq toq ngè rôm loq mòiq toq chìm đòiq caq jam, èh mangai aih phai broq ca mahem haq loh dŏng, hi khoi yŏc taneh catùh hlài. ");
INSERT INTO hre_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Taiq nen can rìh da rìm chac xech, aih mahem haq, ma jah 'màng aih Au khoi doi ca jàn Is-ra-ên: Pì ùh jah caq mahem da chac xech leq, ma jah 'màng aih can rìh ta rìm chac xech, aih mahem, mangai leq caq mahem phai 'bìq hnan khoi ca jàn. ");
INSERT INTO hre_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Tàng mangai leq ta jàn Is-ra-ên, loq mangai jàn 'noiq leq, caq jam rôm cachìt đeh, loq 'bìq baco rôm hich, èh mangai aih ep rùh dèh eo, hùm ta diac, èh 'bìq amùa trùh chìu xèq. ");
INSERT INTO hre_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Tàng haq ùh hùm wa ùh rùh dèh eo, èh pòq tôiq dađeh.’ ” ");
INSERT INTO hre_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Doi ca jàn Is-ra-ên: ‘Au cô Chuaq Boc Plình pì. ");
INSERT INTO hre_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Pì apaq broq tiaq bìac wì ma broq ta gùng Aicàp, nòi pì ma khoi ŏi adroi nèh, hadai apaq broq tiaq wì ta gùng Ca-na-an, nòi Au ma ajèn pì trùh. Apaq lam tiaq trong wì haq. ");
INSERT INTO hre_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Pì phai tiaq bàu thê Au, wèq dìq ca ranenh ep broq da Au. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","'Màng aih pì phai wèq dìq bàu thê Au wa dìq ca ranenh Au. Mangai leq broq tiaq, èh nhò aih jah rìh. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Ùh jah i mangai leq ta pì cùi dèh ti oh daq. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Apaq broq camaih dèh ca baq tiaq trong cùi ti dèh miq, taiq haq mangai broq miq. ");
INSERT INTO hre_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Apaq broq camaih dèh ca baq tiaq trong cùi ti mai yang haq. ");
INSERT INTO hre_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Apaq cùi ti dèh oh loq daq mòiq cliac, 'nhac ca haq oh loq daq dèh baq loq oh daq dèh miq, 'nhac ca haq xa-ông ta hnem dađeh loq ta hnem mangai ma 'noiq. ");
INSERT INTO hre_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Apaq cùi dèh ti xau cadrì, 'nhac ca haq con cadrì da con calô loq con cadrì da con cadrì, tàng broq 'màng aih, khoi broq camaih ca dađeh. ");
INSERT INTO hre_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Apaq cùi dèh ti oh cadrì pajùm baq, miq crài, ma jah 'màng aih haq aih oh cadrì ìh. ");
INSERT INTO hre_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Apaq cùi dèh ti dùch cadrì, taiq haq oh cadrì dèh baq. ");
INSERT INTO hre_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Apaq cùi dèh ti mìh cadrì, ma jah 'màng aih haq caxènh wa mahem da miq. ");
INSERT INTO hre_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Apaq cùi dèh ti mìh cadrì loq dùch cadrì ìh, taiq aih broq camaih dèh ca dùch loq mìh. ");
INSERT INTO hre_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Apaq cùi dèh ti dèh con mai, ma jah 'màng aih mai da con calô ìh. ");
INSERT INTO hre_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Apaq cùi dèh ti mai oh loq daq, tàng broq 'màng aih, aih broq camaih ca oh loq daq ìh. ");
INSERT INTO hre_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Apaq cùi ti mangai miq khoi èh cùi ti con haq hòm, hadai apaq cùi ti xau da mangai miq aih, 'nhac ca cadrì aih con cadrì da con calô haq loq con cadrì haq, taiq wì haq aih dìq caxènh wa mahem haten. Tàng broq 'màng aih, aih mòiq bìac tango anang ngan dù. ");
INSERT INTO hre_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Apaq yŏc mai khoi èh yŏc hloi oh daq mòiq miq mòiq baq da mai jò mai ìh ŏi rìh, èh yùq haq loq tarènh. ");
INSERT INTO hre_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Jò con cadrì đang i mahem, apaq cùi tì haq. ");
INSERT INTO hre_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Apaq cùi ti mai mangai haten hatìa, èh broq ca dađeh amùa ti haq. ");
INSERT INTO hre_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Apaq rùp dèh con caiq broq ngè tadreo am ca kiac Moloc. Apaq broq 'mèq ca hiniq Boc Plình ìh, Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Apaq cùi ti mangai calô troi ma cùi ti mangai cadrì, aih mòiq bìac dìq jaq ramòt. ");
INSERT INTO hre_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Apaq cùi ti ngè aban, aih khoi broq ca dađeh amùa amech. Mangai cadrì hadai apaq cùi ti ngè aban, aih mòiq bìac dìq jaq ramòt. ");
INSERT INTO hre_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Apaq broq ca dađeh amùa ta rìm bìac aih, taiq jàn 'noiq ma Au hnan đac adroi ca pì, khoi broq ca dađeh amùa tiaq rìm bìac aih. ");
INSERT INTO hre_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Taiq dìq ca taneh khoi wìa amùa amech, Au baxa jàn ŏi ta aih. 'Màng aih, Au thê taneh hac wì haq loh khoi enh gùng. ");
INSERT INTO hre_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Mahaq pì ep wèq cajap dìq ca ranenh wa bàu thê da Au. Pì loq tamoi ŏi đò ti pì apaq broq bìac đang ca ramòt aih, ");
INSERT INTO hre_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","taiq dìq ca jàn ma ŏi ta aih adroi nèh khoi broq dìq ca bìac ramòt aih, èh taneh khoi wìa amùa amech. ");
INSERT INTO hre_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","'Màng aih pì apaq broq ca taneh loh ca amùa, èh yùq ca taneh loq hac 'noh pì tìah ca ma khoi hac 'noh 'bài jàn ma ŏi ta gùng adroi ca pì. ");
INSERT INTO hre_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Ma jah 'màng aih tàng mangai leq broq mòiq ta bìac đang ca ramòt aih, èh ep 'bìq hnan 'noh khoi ca jàn cla. ");
INSERT INTO hre_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","'Màng aih èh pì phai wèq bàu thê da Au, wa apaq broq tiaq mòiq ta bìac 'mèq đang ca ramòt aih ma jàn aih khoi broq adroi ca pì. 'Màng aih, pì apaq taiq bìac 'mèq aih broq ca dađeh amùa ti wì haq. Au Chuaq Boc Plình pì.’ ” ");
INSERT INTO hre_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Doi ca jàn Is-ra-ên: ‘Pì phai hadròih, ma jah 'màng aih, Au cô Chuaq Boc Plình da pì, Au hadròih. ");
INSERT INTO hre_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Rìm ngai ep iu padèch dèh miq baq wa wèq rìm Hì Sabat da Au, Au Chuaq Boc Plình pì. ");
INSERT INTO hre_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Apaq cùh waiq dua 'mù, hadai ùh jah broq dua 'mù 'bài can kiac, Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Jò pì am ngè tadreo waiq catèm ca Chuaq, phai am tiaq trong troq đòiq Haq nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Phai caq trom hì ma am aih, wa hì ma atìq; phàn ma ŏi i rah trùh hì piq èh, ep bùh đac. ");
INSERT INTO hre_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Tàng mangai leq đòiq caq trùh hì piq, aih mòiq bìac đang ca ramòt, èh Chuaq ùh lem manoh. ");
INSERT INTO hre_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Mangai leq caq ngè tadreo aih, èh pòq wê tôiq ca dađeh, ma jah 'màng aih khoi broq ùh troq ca ngè hadròih da Chuaq. Mangai aih phai 'bìq hnan đac khoi ca jàn dađeh. ");
INSERT INTO hre_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Jò pì gat dèh 'mau ta gùng cla, apaq gat trùh mùm đùng, hadai apaq tŏch hlài hadròc 'mau ma taclìh. ");
INSERT INTO hre_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Pì apaq kech plì nho yàng baiq, hadai apaq tŏch plì nho ma hadrùih. Phàn ma aih phai đòiq ca mangai pa wa mangai tamoi. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Pì apaq atùng. “ ‘Apaq capoch amòng. “ ‘Apaq padô 'nùt dabau. ");
INSERT INTO hre_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Pì apaq patô hiniq Au đòiq pachac amòng, ma jah 'màng aih broq 'mèq da hiniq Boc Plình dađeh, Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Apaq padit padiang mangai haten hatìa ca dađeh, hadai apaq atùng ngè haq. “ ‘Ùh jah wèq 'bac baha da mangai broq ca ìh trùh hì ma atìq. ");
INSERT INTO hre_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Apaq waiq hanip Mangai clìch don, hadai paq đòiq ngè cleq broq catŏih cro enh ngìa ca mangai ùh xau. Mahaq phai yùq crè ca Boc Plình. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Pì apaq broq bìac ùh ta-atoq ta bìac hadrah. Apaq gen can ca mangai pa hadai apaq padèch mangai padrŏng can, mahaq phai tiaq trong ta-atoq đòiq hadrah mangai haten hatìa ca ìh. ");
INSERT INTO hre_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Apaq capoch 'mèq ca mangai ta jàn dađeh. “ ‘Apaq broq bìac cleq 'mèq ca mangai haten hatìa. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Apaq i manoh git 'bŏn dèh ca oh daq ta jàn dađeh. Phai anoq hnài mangai haten hatìa dađeh jò haq broq ùh troq, đòiq cla dađeh ùh hìaq pòq tôiq taiq tôiq lôi da haq broq. ");
INSERT INTO hre_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Apaq hatình ca bìac tabroq hlài, loq wèq ta manoh bìac tabroq hlài dèh ca jàn cla, mahaq phai loq waq ca mangai haten hatìa tìah ca cla. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Pì phai wèq bàu thê da Au. “ ‘Apaq đòiq ca ngè aban crài ca adrech tapòq ca dabau. “ ‘Apaq rai ta đùng ìh baiq hiniq adrech. “ ‘Apaq caxùnh eo khoi tenh xam baiq toq brai crài ca dabau. ");
INSERT INTO hre_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Tàng mangai calô leq cùi ŏi dèh ti hapŏng cadrì khoi taprŏi ca mangai 'noiq, ma haq 'nhòq jah rŏt hlài, loq 'nhòq jah ca'naih, èh wa baiq ngai aih dìq 'bìq baxa, mahaq ùh trùh cachìt ma jah 'màng aih, mangai cadrì aih 'nhòq jah ca'naih. ");
INSERT INTO hre_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mangai calô aih taiq lôi dađeh haq ep 'ràng mòiq toq trìu calô enh ngìa ca Chuaq jang 'mang Hnem Traiq Cùh Waiq đòiq broq lè rŏt hlài dèh lôi. ");
INSERT INTO hre_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Pajàu jah yŏc trìu calô ma broq ngè tadreo rŏt hlài bìac i lôi đòiq broq lè rŏt tôiq lôi hlài da mangai i tôiq enh ngìa ca Chuaq, 'màng aih tôiq haq men jah baxŏng. ");
INSERT INTO hre_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Jò pì khoi mùt ta gùng Ca-na-an apìt long i plì, ùh jah kech caq plì aih adroi ca piq hanam. Phai ngan plì long aih tìah ca ùh kènh caq. Apaq caq plì aih. ");
INSERT INTO hre_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mahaq hanam ma pôn, dìq ca plì long aih wìa hadròih, èh phai broq ngè tadreo manè apôi dèch am ca Chuaq đòiq padèch hiniq Haq. ");
INSERT INTO hre_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Trùh hanam ma padam, pì jah caq plì long aih, waq ca long loh tam plì. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Pì apaq caq ngè leq ma ŏi i mahem. “ ‘Apaq bòch mangai ngan hada tì, hadai ùh jah tah jo bòch ngan kiac dù. ");
INSERT INTO hre_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Apaq cat xàc dudan ca gàu, hadai ùh jah got xàc mùm. ");
INSERT INTO hre_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Apaq taiq i mangai cachìt ma cat dèh akia. Apaq xam cleq ta chac cla. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Apaq broq amùa ca con cadrì xam bìac wìa mangai tango yŏc 'bac đòiq đùng taneh ùh hìaq bình halùih mangai tango yŏc 'bac wa bìac ngang dù. ");
INSERT INTO hre_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Pì phai wèq dìq Hì Sabat da Au wa iu padèch Nòi Hadròih da Au. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Pì apaq lam bòch mangai ma creo ca mahua mangai cachìt, loq mangai anoi ca yiang dù, ùh jah bòch wì haq, èh yùq taiq wì haq èh pì 'bìq amùa. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Pì phai yòng enh ngìa ca mangai craq đòiq loq iu wì haq, wa loq yùq crè ca Boc Plình pì. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Jò i mangai enh jàn 'noiq lam ŏi ta gùng pì, èh apaq padit padiang. ");
INSERT INTO hre_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mangai enh jàn 'noiq lam ŏi ta gùng pì, pì phai ngan wì haq tìah ca wì khoi xa-ông ta gùng pì. Phai loq waq ca wì haq tìah loq waq ca dađeh, ma jah 'màng aih pì hadai khoi lah broq jàn 'noiq ta Diac Aicàp. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Pì ùh jah tình ùh ta-atoq ta bìac wêh, bìac trap loq hèo, loq bìac tình tŏng axong. ");
INSERT INTO hre_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Maiq càng da pì phai troq joq 'nàng. Ranac tah dahwèq croh đòiq càng, phai troq joq 'nàng, mòiq êpha troq joq 'nàng wa mòiq hin troq joq 'nàng. Au Chuaq Boc Plình da pì, Haq ma khoi ajèn pì loh khoi enh gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘ 'Màng aih pì phai wèq cajap broq tiaq dìq ca ranenh wa dìq bàu thê da Au. Au Chuaq Boc Plình da pì.’ ” ");
INSERT INTO hre_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Ìh hadai phai doi ca jàn Is-ra-ên: ‘Tàng i mangai leq ta jàn Is-ra-ên, loq mangai jàn 'noiq ta wì haq, yŏc dèh con caiq cla am đòiq bùh ca kiac Molec, èh mangai aih phai 'bìq jêh đac. Jàn ta gùng aih phai tèm hmu jêh đac haq. ");
INSERT INTO hre_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Au tajraq hlài ca mangai aih, hnan 'noh haq loh khoi dèh ca jàn cla, taiq haq khoi am dèh con ca kiac Molec, broq ca Nòi Hadròih Au loh ca amùa wa broq 'mèq ca hiniq hadròih Au. ");
INSERT INTO hre_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Tàng wì jàn gùng aih ca'nhip đac mat jò mangai aih am dèh mòiq toq con ca kiac Molec, wa ùh jêh cađac mangai aih, ");
INSERT INTO hre_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","èh Au cô tajraq hlài ca mangai aih wa cadraq haq, khoi èh hnan đac haq wa mangai leq ma tiaq haq pajùm mòiq manoh ti kiac Molec loh khoi ca jàn cla. ");
INSERT INTO hre_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Au tajraq hlài ca mangai ma creo ca mahua mangai cachìt, wa mangai anoi ca yiang dù, èh Au tajraq hlài ca mangai aih, hnan haq loh khoi dèh ca jàn cla. ");
INSERT INTO hre_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘ 'Màng aih pì phai broq dađeh lah crài loh hadròih, ma jah 'màng aih Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Pì phai wèq wa broq tiaq bàu thê Au. Au Chuaq ma broq ca pì wìa hadròih. ");
INSERT INTO hre_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Tàng mangai leq hanip dèh miq baq, èh phai jêh đac, haq khoi hanip dèh miq baq, mahem haq jah ta-ùc hlài ta chac haq. ");
INSERT INTO hre_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Tàng mangai leq broq tôiq tango anang ca mai mangai 'noiq, loq broq tôiq tango anang ca mai mangai haten hatìa ca dađeh, mangai calô wa mangai cadrì aih phai 'bìq jêh đac. ");
INSERT INTO hre_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Tàng mangai leq cùi dèh ti mai baq, aih broq camaih dèh ca baq, èh wa baiq ngai dìq 'bìq jêh đac, taiq wa haq khoi broq tôiq đang ca cachìt. ");
INSERT INTO hre_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Tàng mangai leq cùi dèh ti mai con, èh wa baiq ngai dìq 'bìq hadrah jêh đac, ma jah 'màng aih wa haq khoi broq mòiq bìac 'mèq 'mac. 'Màng aih, wa haq khoi broq tôiq đang ca cachìt. ");
INSERT INTO hre_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Tàng mangai calô cùi ti mangai calô troi ma cùi ti con cadrì, èh wa baiq ngai aih dìq phai 'bìq hadrah jêh đac, ma jah 'màng aih wa haq khoi broq mòiq bìac ramòt. Wa haq khoi broq tôiq đang ca cachìt. ");
INSERT INTO hre_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Tàng i mangai calô leq yŏc miq khoi èh yŏc hloi con da mangai aih broq mai, aih bìac manhài trài. Èh wì piq ngai phai 'bìq bùh dŏng, waq ca pi i bìac manhài trài aih ŏi ti pì. ");
INSERT INTO hre_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Tàng mangai calô cùi ti ngè aban, èh phai hadrah jêh đac mangai calô aih wa hadai jêh đac ngè aban aih. ");
INSERT INTO hre_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Tàng mangai cadrì leq cùi ti ngè aban, èh ep jêh cađac con cadrì aih wa ngè aban, taiq haq wa ngè aban khoi broq tôiq đang ca cachìt. ");
INSERT INTO hre_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Tàng mangai calô cùi ti oh loq daq cadrì cla, loq cùi ti oh loq daq cadrì da baq miq crài, aih bìac manhài trài, èh wa haq phai 'bìq hnan 'noh khoi dèh ca jàn cla. Haq khoi broq manhài trài dèh ca oh daq cla. Haq pòq tôiq dađeh. ");
INSERT INTO hre_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Tàng mangai calô cùi pajùm ti mangai cadrì jò mangai cadrì i mahem, èh wa baiq ngai dìq phai 'bìq hnan 'noh khoi dèh ca jàn cla. ");
INSERT INTO hre_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Apaq cùi ti oh cadrì loq daq cadrì, aih con da miq loq baq dađeh, ma jah 'màng aih broq manhài trài dèh ca hadròng hadrech, èh wa baiq ngai phai pòq dèh tôiq dađeh. ");
INSERT INTO hre_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Tàng mangai calô leq cùi ti mai mìh dađeh, loq mai dùch dađeh, aih haq broq manhài trài dèh ca dùch wa mìh. Wa baiq ngai aih ep pòq wê bìac hadrah baxa taiq tôiq lôi cla, trùh jò wa haq cachìt ùh i con. ");
INSERT INTO hre_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Tàng mangai leq yŏc dèh mai oh loq daq dađeh, aih bìac ramòt. Wa baiq ngai èh ùh i con. ");
INSERT INTO hre_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘ 'Màng aih, pì phai wèq wa broq tiaq dìq bàu thê wa 'bài ranenh da Au, waq ca gùng Au ma ajèn pì trùh ŏi, ùh hac 'noh pì. ");
INSERT INTO hre_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Pì apaq broq tiaq bìac 'mèq 'mac da jàn Au khoi hnan 'noh cađac enh ngìa ca pì. Au ùh lem manoh ca wì haq taiq wì haq broq dìq bìac ramòt aih. ");
INSERT INTO hre_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Au khoi doi ca pì: Èh pì phai yŏc gùng da jàn aih. Cla Au am ca pì gùng aih đòiq broq xôxech, aih gùng dahwèq caq bàc tìah ca taneh i sùa wa diac xùt. Au Chuaq Boc Plình da pì ma khoi lah crài pì khoi ca dìq tamoi 'noiq. ");
INSERT INTO hre_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘ 'Màng aih phai lah crài ngè rìh hreo wa ngè ùh hreo. Apaq broq ca dađeh loh ca 'mèq 'mac taiq ngè aban, taiq chìm, taiq ngè ma 'yêh rìh ta đùng ta go ta crŏng taneh, aih Au khoi hnài pì hadro ngè ùh hreo. ");
INSERT INTO hre_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Pì phai rìh hadròih enh ngìa ca Au, ma jah 'màng aih, Au Chuaq hadròih. Au khoi ràih pì jah lah crài ca jàn 'noiq đòiq pì wìa jàn Au. ");
INSERT INTO hre_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Jò leq mangai calô loq mangai cadrì broq mangai creo ca mahua mangai cachìt, broq mangai anoi ca yiang dù, èh wì haq phai 'bìq hadrah wa 'bìq tèm hmu jêh đac. Wì haq khoi broq tôiq đang ca cachìt.’ ” ");
INSERT INTO hre_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Chuaq doi ca Môise: “Doi ca 'bài pajàu, aih 'bài con calô Arôn: ‘Pajàu ùh khòh broq ca dađeh loh ca amùa bèq chac hanang da mangai jàn ma cachìt, ");
INSERT INTO hre_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","enh gùng ca miq baq, con calô, con cadrì wa oh daq calô, ");
INSERT INTO hre_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","hadai enh gùng ca oh daq cadrì ma ŏi xriu 'nhòq i ŏng, èh ìh jah taiq oh daq cadrì aih broq ca dađeh loh ca amùa. ");
INSERT INTO hre_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Pajàu ùh khòh broq ca dađeh loh amùa taiq oh daq haten, aih mai wa dìq oh daq dèh mai. ");
INSERT INTO hre_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘ 'Bài pajàu ùh khòh coih gàu, got xàc kiang, loq cat dèh chac cla. ");
INSERT INTO hre_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Wì haq phai rìh hadròih ca Boc Plình da wì haq, ùh khòh broq 'mèq ca hiniq Boc Plình, ma jah 'màng aih wì haq am ca Chuaq 'bài ngè tadreo bùh xam ùnh, aih dahwèq da Boc Plình wì haq, taiq 'màng aih wì haq phai wìa hadròih. ");
INSERT INTO hre_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Pajàu ùh khòh yŏc mangai tango yŏc 'bac, hadai ùh jah yŏc mangai 'bìq ŏng cađac broq mai, ma jah 'màng aih pajàu khoi đòiq crài wìa hadròih ca Boc Plình dađeh. ");
INSERT INTO hre_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","'Màng aih pì phai ngan pajàu aih khoi lah crài loh hadròih, taiq haq am ngè tadreo da Boc Plình pì. Haq hadròih ca pì, ma jah 'màng aih Au Chuaq hadròih, Haq ma broq ca pì wìa hadròih. ");
INSERT INTO hre_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Tàng con cadrì da pajàu broq ca dađeh loh amùa taiq broq mangai tango yŏc 'bac, aih broq camaih ca baq, èh haq phai 'bìq bùh ta ùnh. ");
INSERT INTO hre_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Pajàu ha'nhèq ma yi ha'nhèq dèh oh daq pajàu, khoi jah xùt dàu ta gàu đòiq atŏc broq pajàu wa caxùnh eo hadròih, haq ùh khòh yŏc 'noh calôp gàu loq hich dèh eo, ");
INSERT INTO hre_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","hadai ùh jah trùh haten ca hanang, 'nhac ca hanang da baq loq miq haq, ji ùh jah broq dađeh loh ca amùa, ");
INSERT INTO hre_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","haq hadai ùh khòh loh khoi ca Nòi Hadròih, hadai ùh jah broq 'mèq ca Nòi Hadròih da Boc Plình dađeh, ma jah 'màng aih dàu xùt da Boc Plình xôq ŏi ta gàu haq. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Pajàu phai yŏc mangai cadrì ŏi xriu broq mai. ");
INSERT INTO hre_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Haq ùh khòh ta'nèp ca mangai cadrì hadrô, mangai cađac ŏng, loq mangai tango yŏc 'bac, mahaq haq phai yŏc mangai cadrì ŏi xriu ta jàn cla, ");
INSERT INTO hre_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","đòiq ùh hìaq broq amùa dèh ca xinoi 'ne jàn cla, ma jah 'màng aih Au Chuaq broq ca haq wìa hadròih.’ ” ");
INSERT INTO hre_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Doi ca Arôn: ‘Ta xinoi ìh pàng cô wa hloi 'nah ta 'nhòng atìq, ùh khòh i mòiq ngai leq ma i teo xìt leq, jah yòng am ngè tadreo ca Boc Plình. ");
INSERT INTO hre_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Mangai leq ma i teo xìt ùh kènh trùh haten, aih mangai: Ùh xau mat, cwê, lip mùh, loq chac hamac ùh tôm xrôn, ");
INSERT INTO hre_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","tagoh tì, tagoh jènh, ");
INSERT INTO hre_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","cŏc crŏng, mangai đêq dŏi, mat jôq jrê, rahenh loq hriac, padah clêu. ");
INSERT INTO hre_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ta xinoi pajàu Arôn, tàng i mangai leq i teo xìt, ùh khòh trùh haten am ngè tadreo xam ùnh ca Chuaq. Taiq haq i teo xìt ta chac, haq ùh kènh trùh haten ca'bŏng tadreo am ngè ca Boc Plình dađeh. ");
INSERT INTO hre_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Haq jah caq dahwèq am ca Boc Plình haq, xam ngè hadròih wa ngè dìq jaq hadròih, ");
INSERT INTO hre_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","mahaq taiq i ca teo xìt ta chac haq ùh kènh lam haten ca bai prình loq haten ca ca'bŏng bùh jreo xua thùm, taiq haq i ca teo xìt ta chac. 'Màng aih, haq ùh hìaq broq 'mèq Nòi Hadròih Au, ma jah 'màng aih, Au Chuaq broq nòi aih hadròih.’ ” ");
INSERT INTO hre_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Môise doi bàu 'màng aih ca Arôn wa 'bài con calô Arôn wa dìq ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Ìh phai anoi ca Arôn wa 'bài con calô haq: Wì phai ngan broq geo 'bài ngè tadreo hadròih da jàn Is-ra-ên ma am ca Au, waq ca wì haq ùh hìaq broq 'mèq ca hiniq hadròih Au. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Phai doi ca wì: ‘Tàng pajàu leq ta xinoi pì khoi 'bìq amùa, èh trùh haten ca 'bài ngè hadròih jàn Is-ra-ên khoi dèch am ca Au, èh pajàu aih phai hnan đac khoi ca enh ngìa Au. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Tàng xinoi da Arôn i bình bacùn loq bình làuq, èh ùh jah caq dahwèq caq khoi đòiq crài loh hadròih trùh jò leq haq jah hreo lem. hadai tàng i mangai leq bèq hiniq cleq ma 'bìq hanang đùng troq loq i mangai calô leq loh diac taboc khoi broq amùa, ");
INSERT INTO hre_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","loq troq bèq ngè 'yêh ma rìh moq ta đùng, loq bèq mòiq ngai khoi 'bìq amùa ùh kè ca bìac leq, aih broq ca haq amùa. ");
INSERT INTO hre_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Mangai leq bèq 'bài ngè aih, èh 'bìq amùa trùh chìu xèq. Haq ùh jah caq dahwèq caq khoi đòiq crài loh hadròih trùh jò khoi hùm ta diac. ");
INSERT INTO hre_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Atìq ca mat mahì clìh haq jah hreo, khoi èh men jah caq dahwèq caq hadròih, ma jah 'màng aih cô dahwèq caq haq. ");
INSERT INTO hre_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Xinoi da Arôn ùh khòh caq ngè aban cachìt đeh loq 'bìq baco rôm hich, đòiq ùh hìaq broq ca dađeh ùh hreo. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘ 'Màng aih wì haq phai wèq bàu Au ma tanap, đòiq wì ùh hìaq i tôiq ep cachìt taiq ùh wèq tiaq ranenh Au wa broq bìac hadròih loh amùa. Au Chuaq ma broq ca wì haq wìa hadròih. ");
INSERT INTO hre_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Mangai leq enh gùng ca cadraq pajàu, mangai ŏi đò ta hnem pajàu, loq mangai broq bìac am ca haq, ùh khòh caq dahwèq caq hadròih. ");
INSERT INTO hre_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mahaq mangai hapŏng leq ma khoi jah pajàu 'noh 'bac rŏt wa mangai xa-ông ta hnem hapŏng, èh men jah caq ngè caq hadròih. ");
INSERT INTO hre_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Tàng con cadrì da pajàu yŏc ŏng ma ùh broq pajàu, èh gu cadrì aih ùh jah caq dahwèq caq hadròih am atŏc. ");
INSERT INTO hre_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mahaq tàng con cadrì da pajàu wìa hadrô, loq 'bìq ŏng cađac, ùh i ca con, èh hlài ŏi ti baq tìah ca jò haq ŏi 'yoh, èh haq jah caq dahwèq caq da baq haq, mahaq ùh i ca mangai leq enh gùng ca cadraq pajàu khòh caq. ");
INSERT INTO hre_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Tàng mangai leq troq lò caq dahwèq caq hadròih, èh phai đèn hlài ca pajàu cùng haq dàng dahwèq caq hadròih aih, wa ep am tam mòiq phàn padam hòm.p ");
INSERT INTO hre_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Pajàu ùh jah broq 'mèq ca ngè tadreo da jàn Is-ra-ên ma am atŏc ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","tiaq trong am ca mangai caq dahwèq caq hadròih 'màng aih, èh wì haq ep pòq tôiq dađeh ma khoi broq, ma jah 'màng aih, Au Chuaq broq ca dahwèq aih wìa hadròih.’ ” ");
INSERT INTO hre_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Èh Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Doi ca Arôn, 'bài con calô haq, wa dìq ca jàn Is-ra-ên: ‘Mangai Is-ra-ên leq, loq tamoi 'nang ŏi đò ta wì haq, dèch am ngè tadreo ca Chuaq, 'nhac ca ngè tadreo waiq pachac, loq ngè tadreo cla enh am đeh broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","mangai aih phai rùp enh calùh, 'bo calô, trìu calô, loq bubi calô ùh i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Pì ùh jah am ngè leq ma i teo xìt, èh ùh jah Chuaq nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Jò mangai am ca Chuaq mòiq ngè tadreo waiq catèm xam 'bo loq trìu ngè tadreo waiq pachac, loq ngè tadreo cla enh am đeh, ngè tadreo aih phai ùh i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Pì ùh jah am ca Chuaq ngè tadreo leq ùh xau mat, i habau, cwê jènh, pa-êh, rahenh loq rahenh pachòng. Pì ùh jah yŏc ngè aih broq ngè tadreo xam ùnh am atŏc ca Chuaq ta ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Pì jah rùp mòiq toq 'bo loq trìu i jènh yôh loq jènh đêq đòiq broq ngè tadreo to am đeh, mahaq tàng yŏc 'mat đòiq broq ngè tadreo waiq pachac, èh ngè aih ùh jah Chuaq nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Pì ùh khòh dèch am ca Chuaq ngè tadreo leq ma 'bìq pràm clêu, pah clêu, loq 'bìq dahich clêu. Pì ùh jah dèch am ngè tadreo 'màng aih ta dìq ca nòi gùng da pì. ");
INSERT INTO hre_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Mangai Diac 'noiq hadai ùh jah am ca Boc Plình ngè tadreo leq ma 'bìq 'màng aih, taiq khoi i teo i xìt ta chac, èh ngè aih Chuaq ùh nhàn yŏc.’ ” ");
INSERT INTO hre_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Jò 'bo con, trìu con, loq bubi con neo xêh, haq ep ŏi dèh ti miq tapèh hì. Enh hì rahem dang tŏc, jah yŏc haq broq ngè tadreo xam ùnh am ca Chuaq, Chuaq nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Mahaq 'nhac ca 'bo loq trìu, pì ùh jah pàc haq wa con haq pajùm mòiq hì. ");
INSERT INTO hre_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Jò pì dèch am ngè tadreo manè apôi ca Chuaq, èh phai am 'mang leq đòiq ngè tadreo aih jah Chuaq lem manoh nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ngè tadreo aih phai caq ta mòiq hì aih. Ùh khòh đòiq trùh xroq èh. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“ 'Màng aih phai wèq broq tiaq bàu thê da Au. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ùh khòh broq 'mèq ca hiniq hadròih Au, ma jah 'màng aih Au phai jah padèch hadròih 'ne jàn Is-ra-ên. Au Chuaq broq ca pì wìa hadròih, ");
INSERT INTO hre_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ma khoi 'ràng pì loh khoi ca gùng Aicàp đòiq Au broq Boc Plình pì. Au Chuaq Boc Plình da pì.” ");
INSERT INTO hre_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Phai am ca jàn Is-ra-ên bàu tanap 'màng cô: ‘Cô 'bài hì lè khoi pachì da Chuaq ma pì phai broq am ca tagop hadròih. ");
INSERT INTO hre_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Pì phai broq bìac trom tadràu hì, mahaq hì tapèh, aih Hì Sabat, hì padài. Aih hì tagop hadròih ùh khòh broq mòiq bìac cleq. Aih Hì Sabat da Chuaq. Pì phai tiaq bàu tanap cô ta nòi leq pì ma ŏi. ");
INSERT INTO hre_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Cô 'bài lè da Chuaq, aih bìac tagop hadròih pì phai anoi hlài trùh hì ma pajaq cô. ");
INSERT INTO hre_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Trùh hì 14, khê mòiq, jò xèq dadrìch, aih Lè Lam Cwa da Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Hì 15, khê cô, aih Lè 'Benh Ùh Tah Blo am ca Chuaq. Pì phai caq 'benh ùh tah blo trom tapèh hì. ");
INSERT INTO hre_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Hì baxèm pì jah i mòiq hì tagop hadròih, hì aih pì ùh jah broq 'nhac ca bìac cleq ta hì aih. ");
INSERT INTO hre_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mahaq trom tapèh hì, pì phai am ca Chuaq ngè tadreo dèch atŏc xam ùnh. Hì ma tapèh, aih mòiq hì ta gop hadròih, pì ùh jah broq 'nhac ca bìac cleq ta hì aih.’ ” ");
INSERT INTO hre_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Èh Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Ìh phai doi ca jàn Is-ra-ên: ‘Jò leq pì khoi jah mùt ta gùng Au ma am ca pì, wa khoi jah gat 'mau, èh pì phai 'ràng am ca pajàu achauq 'mau gàu mùa da pì. ");
INSERT INTO hre_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Hì atìq ca Hì Sabat, pajàu phai yŏc achauq 'mau aih dèch atŏc am lam am hlài enh ngìa ca Chuaq waq ca pì jah Chuaq nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Hi ma am achauq 'mau dèch am lam am hlài aih, pì hadai phai am ca Chuaq mòiq toq trìu con calô khoi mòiq hanam, ùh i ca teo xìt leq, đòiq broq ngè tadreo bùh am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Khoi èh am tam ngè tadreo dèch am xam 'mau mì, baiq phàn mòiq jàt êpha dàc 'yêh alôn ca dàu, broq ngè tadreo xam ùnh am atŏc i hòi xua thùm ca Chuaq wa ngè am xam mòiq phàn pôn hin alac broq lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Pì ùh jah caq 'benh, loq phi adrenh loq pua neo xam 'mau neo aih adroi ca jò pì 'ràng am ngè tadreo cô am ca Boc Plình dađeh. Cô bàu thê pachì đòiq hloi hloi ca xinoi pì. ");
INSERT INTO hre_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Rèn pàng hì atìq ca Hì Sabat, aih hì 'ràng achauq 'mau dèch am lam am hlài, pì tình tôm tapèh tùang lè. ");
INSERT INTO hre_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Pì tình padam jàt hì trùh hì atìq ca hì Sabat yàng ma tapèh, èh pì phai dèch am mòiq ngè tadreo xam 'mau mì ma neo ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Pì phai 'ràng dèh enh hnem cla baiq toq 'benh đòiq broq ngè tadreo dèch am lam am hlài; 'benh aih broq xam baiq phàn mòiq jàt dàc 'yêh i blo, aih ngè gàu mùa am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Hadai phai am hloi ti 'benh aih, tapèh toq trìu con calô bu mòiq hanam, ùh i ca teo xìt leq, mòiq toq 'bo bu chuai wa baiq toq trìu calô đòiq broq ngè tadreo bùh ca Chuaq. Ngè tadreo bùh xam ùnh cô pajùm ngè tadreo dèch am xam 'mau mì wa broq lè dèch am ngè ôq, aih ngè tadreo am atŏc i hòi xua thùm lem manoh Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Pì hadai phai am mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi wa baiq toq trìu con calô bu mòiq hanam, đòiq broq ngè tadreo waiq catèm. ");
INSERT INTO hre_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Pajàu phai yŏc 'bài ngè tadreo aih, baiq toq 'benh broq xam 'mau gàu mùa, wa baiq toq trìu con đòiq dèch am lam am hlài enh ngìa Chuaq. 'Bài ngè aih jah đòiq crài loh hadròih ca Chuaq am ca pajàu. ");
INSERT INTO hre_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Hì aih pì phai anoi dìq ca jàn, wì haq phai broq hì aih wìa hì tagop hadròih, pì ùh jah broq 'nhac ca bìac cleq ta hì aih. Aih bàu thê hloi hloi ca xinoi pì, 'nhac ca pì ŏi nòi leq. ");
INSERT INTO hre_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Jò pì gat dèh 'mau ta gùng, apaq gat hreo hrìn, hadai ùh jah tŏch 'bài hadròc ma taclìh hlài, mahaq phai đòiq 'nah aih ca mangai pa wa am ca mangai jàn 'noiq ma ŏi ti pì. Au Chuaq, Boc Plình da pì.’ ” ");
INSERT INTO hre_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Ìh phai anoi ca jàn Is-ra-ên: ‘Hì mòiq khê tapèh, jah i ca pì mòiq hì đòiq padài. Aih mòiq hì tagop hadròih broq lè, yŏc taliaq hlôi đòiq bahmàng ca dađeh. ");
INSERT INTO hre_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Pì ùh jah broq 'nhac ca bìac cleq ta hì aih, mahaq pì phai dèch am ngè tadreo xam ùnh am ca Chuaq.’ ” ");
INSERT INTO hre_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Chuaq hadai tanap ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Wop hì 10, khê tapèh, aih hì rŏt hlài enh tôiq lôi. Pì jah i mòiq bìac tagop hadròih. Pì phai paha'neq dèh manoh wa broq ngè tadreo xam ùnh dèch atŏc am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Hì aih ùh khòh broq bìac cleq, ma jah 'màng aih, aih hì rŏt hlài enh tôiq lôi. Trom hì aih pì phai broq lè rŏt hlài enh tôiq lôi am ca pì enh ngìa Chuaq pì, Boc Plình pì. ");
INSERT INTO hre_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Trom hì aih mangai leq ùh paha'neq dèh manoh, èh haq phai 'bìq hnan đac khoi dèh ca jàn cla. ");
INSERT INTO hre_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Mangai leq broq 'nhac ca bìac cleq hì aih, èh Au jêh cađac mangai aih khoi dèh ca jàn cla. ");
INSERT INTO hre_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Pì ùh khòh broq 'nhac ca bìac cleq. Aih bàu thê hloi hloi ca xinoi pì, 'nhac ca ŏi nòi leq. ");
INSERT INTO hre_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Aih lè Sabat, mòiq hì padài ca pì. Pì phai paha'neq dèh manoh. Hì hachìn, khê aih, enh xèq hì cô trùh xèq hì da èh, pì phai wèq lè Sabat dađeh.” ");
INSERT INTO hre_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Ìh phai doi ca jàn Is-ra-ên: ‘Hì 15, khê tapèh, pì phai ŏi đò ta hapom tapèh hì đòiq broq Lè caq Hiniang am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Hì baxèm, phai i mòiq hì ta gop hadròih. Pì ùh jah broq 'nhac ca bìac cleq ta hì aih. ");
INSERT INTO hre_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Trom tapèh hì, pì phai am ngè tadreo xam ùnh ca Chuaq. Hì rahem, pì phai i mòiq hì ta gop hadròih hòm, wa am ngè tadreo xam ùnh ca Chuaq. Aih mòiq hì tagop hadròih. Pì ùh jah broq 'nhac ca bìac cleq ta hì aih. ");
INSERT INTO hre_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Aih 'bài hì lè càn caiq da Chuaq khoi pachì ma pì phai anoi ca tagop hadròih đòiq broq ngè tadreo xam ùnh atŏc am ca Chuaq – ngè tadreo bùh, ngè tadreo dèch am xam 'mau mì, ngè tadreo manè apôi, wa broq lè dèch am ngè ôq, ngè leq khoi troq dèh hì aih, ");
INSERT INTO hre_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","enh gùng ca aih, 'bài hì lè Sabat da Chuaq wa 'bài ngè tadreo ma 'noiq, 'bài ngè tadreo khoi pachac am wa ngè to am đeh ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Wop hì 15, khê tapèh, jò pì khoi gat 'mau khoi gêh, pì phai broq hiniang da Chuaq trom tapèh hì. Mahaq hì baxèm phai padài wa hì rahem phai padài. ");
INSERT INTO hre_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Hì baxèm pì phai yŏc hamenh long ma lem lình, acòng rêq wa hamenh cràm hla wa long yùang liu kenh cròng diac, èh pì jah yŏc manoh lem bùi trom tapèh hì enh ngìa Chuaq, Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Rìm hanam, trùh khê tapèh, pì phai wèq lè cô ca Chuaq. 'Màng aih trom tapèh hì, aih wìa bàu thê broq hloi hloi ca xinoi pì. ");
INSERT INTO hre_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Rìm ngai ta jàn Is-ra-ên ma xa-ông ta xinoi Is-ra-ên phai ŏi đò ta hapom tapèh hì, ");
INSERT INTO hre_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","waq ca xinoi pì jah loq, jò Au 'ràng jàn Is-ra-ên loh khoi gùng Aicàp, Au am ca wì ŏi đò ta hapom. Au Chuaq Boc Plình da pì.’ ” ");
INSERT INTO hre_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","'Màng aih, Môise anoi hlài ca jàn Is-ra-ên 'bài hì lè da Chuaq khoi pachì. ");
INSERT INTO hre_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ìh phai thê jàn Is-ra-ên 'ràng dàu ma dìq jaq lem khoi padit enh plì ôliu, đòiq broq đen jah cheo hloi hloi. ");
INSERT INTO hre_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Rìm hì Arôn phai ta'mroq đen aih ta Hnem Traiq Cùh Waiq đòiq enh gùng ca bai prình ma prình hòm wêh jao, waq ca đen jah cheo hloi hloi enh ngìa ca Chuaq enh xèq trùh xroq. Aih mòiq bàu thê hloi hloi ca xinoi pì. ");
INSERT INTO hre_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Arôn phai ta'mroq 'bài đen ŏi jang jènh đen broq xam wang, waq ca jah cheo hloi hloi enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Èh phai yŏc dàc 'yêh broq 12 toq 'benh mì. Mòiq toq 'benh phai i baiq phàn mòiq jàt êpha dàc. ");
INSERT INTO hre_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Phai ta'mroq đòiq baiq brong, mòiq brong tadràu toq ta ca'bŏng broq xam wang enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Phai tah nhù hùang ta kenh rìm brong 'benh aih, đòiq broq phàn lè ngè bahmàng jah wìa ngè tadreo xam ùnh atŏc am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Rìm Hì Sabat haq phai đòiq 'benh cô enh ngìa Chuaq. 'Benh cô wìa mòiq bìac wêh jao hloi hloi am ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Arôn wa 'bài con haq phai caq 'benh aih ta nòi hadròih, ma jah 'màng aih, aih ngè dìq jaq hadròih am ca wì haq enh dìq ngè xam ùnh da Chuaq, aih phàn da haq hloi hloi.” ");
INSERT INTO hre_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","I mòiq ngai gu calô, miq haq mangai Is-ra-ên, baq mangai Aicàp, ŏi ti jàn Is-ra-ên. Haq tajêh ca mangai Is-ra-ên ta nòi traiq. ");
INSERT INTO hre_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mangai calô aih waiq hanip wa capoch đùng trùh hiniq Chuaq. Wì 'ràng haq ca Môise. (Miq haq hiniq Sê-lô-mi, con cadrì da Đipri hadròng hadrech da Đan.) ");
INSERT INTO hre_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Wì haq clêh haq ta hnem tù gòm trùh jò leq Chuaq mahno tình 'màng leq. ");
INSERT INTO hre_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Èh Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ 'Ràng mangai ma loq waiq hanip aih loh enh gùng ca nòi traiq. Dìq ca mangai leq ma i tàng haq capoch đùng trùh Chuaq phai đòiq tì agàu haq. Èh dìq ca jàn phai yŏc hmu tèm haq trùh cachìt. ");
INSERT INTO hre_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ìh phai doi ca jàn Is-ra-ên: ‘Mangai leq waiq hanip Boc Plình, èh haq ep pòq bìac hadrah da tôiq dađeh. ");
INSERT INTO hre_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Mangai leq capoch đùng trùh hiniq Chuaq phai 'bìq hadrah jêh đac; dìq ca jàn phai jêh haq xam hmu. Mangai jàn 'noiq loq mangai Is-ra-ên, tàng jò leq capoch đùng trùh hiniq Chuaq, èh ep 'bìq hadrah cachìt. ");
INSERT INTO hre_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Mangai leq jêh cachìt mangai, phai 'bìq hadrah cachìt. ");
INSERT INTO hre_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Mangai leq jêh cachìt ngè aban da mangai 'noiq, phai đèn hlài, aih phai am ngè aban rìh đèn hlài ngè aban cachìt. ");
INSERT INTO hre_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Mangai leq broq loh habau ca mangai haten hatìa ca dađeh, èh wì broq habau chau ca mangai aih, ");
INSERT INTO hre_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","caxènh đèn caxènh, mat đèn mat, hanenh đèn hanenh, broq habau leq đèn habau aih. ");
INSERT INTO hre_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","'Màng aih, mangai leq broq cachìt ca ngè aban, èh phai đèn hlài. Mahaq mangai leq jêh cachìt ca mòiq ngai leq, èh haq phai 'bìq hadrah cachìt. ");
INSERT INTO hre_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Pì hadai phai wèq ranenh cô, ùh kè ca mangai jàn 'noiq loq mangai Is-ra-ên, ma jah 'màng aih, Au Chuaq Boc Plình da pì.’ ” ");
INSERT INTO hre_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","'Màng aih Môise anoi hlài ca jàn Is-ra-ên, thê 'ràng mangai ma khoi waiq hanip loh khoi ca traiq tèm hmu haq. 'Màng aih jàn Is-ra-ên broq tiaq troi bàu Chuaq ma khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Chuaq doi ca Môise ta wang Sinai: ");
INSERT INTO hre_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Ìh phai doi ca jàn Is-ra-ên: ‘Jò pì khoi mùt ta gùng Au am ca pì, èh pì phai broq ca taneh gùng aih phai wèq hì Sabat ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ta tadràu hanam, pì rai 'mau wa tadràu hanam cat palaoq long nho cleq clài, èh gop 'ràng mùt dahwèq aih, ");
INSERT INTO hre_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","mahaq hanam ma tapèh, aih hanam Sabat đòiq padài, aih mòiq Sabat ca Chuaq. Pì ùh khòh rai adrech, hadai ùh khòh cat palaoq wùan nho. ");
INSERT INTO hre_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Pì ùh khòh gat wa ùh khòh gop 'mau hon đeh hanam padài cô, wa ùh khòh kech wa gop plì nho ta wùan nho ma ùh cat palaoq. Aih mòiq hanam Sabat đòiq taneh padài. ");
INSERT INTO hre_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Dahwèq leq ma hon đeh enh taneh jò hanam Sabat, aih jah broq dahwèq caq tôm tàu am ca ìh, am ca hapŏng cadrì, hapŏng calô, am ca mangai broq cùng ca pì wa mangai jàn 'noiq ŏi ti pì. ");
INSERT INTO hre_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ngè aban da pì wa 'bài ngè rôm ma ŏi ta gùng ji i tôm tàu dahwèq caq. ");
INSERT INTO hre_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Tapèh hanam pì phai đòiq taneh padài mòiq hanam wa broq 'màng aih trùh hloi 49 hanam. ");
INSERT INTO hre_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Hì 10, khê tapèh hanam aih, pì phai hlôi kèn enh aki trìu calô jàp ca gùng, aih mòiq hì rŏt dèch hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Pì phai lah crài loh hadròih hanam yàng 50, èh anoi hlài bìac ùh hìaq tawac pakènh aih dìq ca jàn ŏi ta gùng aih. Aih hanam bùi ca pì. Mangai leq dìq jah nhàn hlài dèh đùng taneh wa rìm ngai jah hlài dèh ta cadraq. ");
INSERT INTO hre_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Hanam yàng 50 aih hanam bùi lem ca pì, ùh khòh rai, ùh khòh gat 'mau leq ma hon đeh, hi khoi hadai ùh jah kech plì nho ma ùh i cat palaoq. ");
INSERT INTO hre_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Aih mòiq hanam bùi lem jah broq hadròih ca pì. Pì jah caq toq dahwèq caq ma hon dèh ta đùng. ");
INSERT INTO hre_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Ta hanam bùi lem cô, rìm ngai phai wìh hlài broq craq ta taneh đùng dađeh. ");
INSERT INTO hre_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Mangai leq tech loq rŏt taneh đùng dèh da bua, phai tình ma troq. ");
INSERT INTO hre_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Jò rŏt taneh pì phai tình jaq toq leq, tiaq ŏi i toq leq hanam trùh hanam bùi lem aih. Mangai tech hadai phai tình tiaq ŏi i toq leq hanam jah gop dahwèq. ");
INSERT INTO hre_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Tàng ŏi i bàc hanam, 'bac jaq jah yi bàc, mahaq tàng ŏi i toq 'biaq hanam, 'bac jaq phai yi 'biaq, ma jah 'màng aih cô ranenh tech rŏt dahwèq gat. ");
INSERT INTO hre_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Apaq broq ùh ta-atoq ca dabau, mahaq phai loq iu crè ca Boc Plình, taiq Au Chuaq, Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Pì phai broq tiaq bàu thê Au, wèq cajap ranenh Au wa broq tiaq, 'màng aih pì jah ŏi catèm dèh ta gùng, ");
INSERT INTO hre_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","wa taneh jah hon dahwèq ca pì, đòiq pì jah caq panàc wa jah catèm dèh ta gùng. ");
INSERT INTO hre_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mahaq tàng pì doi: “Nhèn èh ùh i rai adrech ùh i gat, èh hanam tapèh nhèn yŏc cleq ma caq?” ");
INSERT INTO hre_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Èh hanam ma tadràu, Au am xôq ramŏt ca pì. Hanam aih pì jah dahwèq tôm ca piq hanam. ");
INSERT INTO hre_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Hanam rahem, jò pì 'nang rai adrech, pì xôq jah caq dahwèq enh hanam adroi trùh jò jah gat hanam ma hachìn. ");
INSERT INTO hre_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Taneh ùh jah tech hloi, ma jah 'màng aih taneh, aih taneh da Au. Pì ŏi ti Au tìah ca mangai jàn 'noiq wa mangai ŏi đò. ");
INSERT INTO hre_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","'Màng aih, jò pì rŏt đùng taneh, pì phai broq am ca mangai tech i cwìang rŏt hlài dèh đùng xôxech aih. ");
INSERT INTO hre_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Tàng i mòiq ngai gùng cla loh ca pa, wa tech dèh đùng taneh, èh mangai oh daq haten ca mangai cô khòh rŏt hlài am ca haq taneh xôxech da haq. ");
INSERT INTO hre_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Tàng mangai ma tech taneh cô pi i ca oh daq đòiq rŏt hlài da haq taneh, mahaq atìq cô èh tàng haq jah i tôm 'bac, haq jah rŏt hlài taneh aih. ");
INSERT INTO hre_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Mangai aih phai tình sôq hanam pàng jò haq ma tech taneh, khoi èh ca'naih ca mangai rŏt taneh haq 'bac da 'bài hanam ma ŏi hlài, khoi èh yŏc hlài dèh đùng taneh. ");
INSERT INTO hre_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mahaq tàng mangai aih khoi ran mahaq ùh jah 'bac đòiq rŏt hlài dèh taneh, èh taneh haq khoi tech phai ŏi ti mangai ma rŏt trùh hanam yàng 50, hanam bùi lem. Mahaq ta hanam 50 aih, taneh jah hlài ca mangai ma tech. ");
INSERT INTO hre_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Tàng cabô tech mòiq hnem ta phôq i pagia dudan, èh haq i cwìang rŏt hlài jò khoi jah mòiq hanam atìq ca haq ma tech. Haq i cwìang rŏt hlài hnem tình pàng jò haq ma tech aih bu mòiq hanam. ");
INSERT INTO hre_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Mahaq tàng haq ùh rŏt hlài trùh jò ma pajaq mòiq hanam, èh hnem aih jah wìa taneh ŏi hloi ti mangai ma rŏt aih, wa ca xinoi haq hloi hloi. Ta hanam 50, hnem aih xôq jah taneh da mangai ma rŏt aih. ");
INSERT INTO hre_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mahaq dìq ca hnem ta plài ma ùh i pagia phai ngan tìah ca đùng taneh. Dìq ca nòi aih èh mangai ma tech jah rŏt hlài hanam bùi lem, wa hnem aih jah hlài ca mangai ma tech. ");
INSERT INTO hre_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Ta 'bài phôq da mangai Lêwi, 'bài hnem da wì haq, 'nhac ca ŏi ta phôq, èh wì haq i cwìang rŏt hlài dèh 'nhac ca jò leq. ");
INSERT INTO hre_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","'Màng aih, đùng taneh leq da mangai Lêwi jah rŏt hlài, wa hnem leq da mangai Lêwi khoi tech, èh trùh hanam 50, hanam bùi lem, aih jah hlài ca mangai Lêwi, ma jah 'màng aih hnem ta phôq da mangai Lêwi aih cùng hang da wì haq 'ne jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mahaq dìq ca đùng taneh da mangai Lêwi enh gùng phôq, aih ùh jah tech, ma jah 'màng aih cùng hang hloi hloi da wì haq. ");
INSERT INTO hre_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Tàng pì ŏi haten ca 'bài mangai pa, cùng hang da haq ùh tôm đòiq ban dađeh, èh ep jùp haq dìq, 'nhac ca mangai enh jàn 'noiq ŏi đò, waq ca haq jah rìh ŏi ta pì. ");
INSERT INTO hre_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Jò am mangai 'noiq bòch wai 'bac, apaq bòch 'bac lòi hòm, mahaq pì phai am mangai aih rìh ti pì, taiq pì loq iu crè ca Boc Plình. ");
INSERT INTO hre_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Jò am mangai aih mùan 'bac, apaq bòch 'bac lòi hòm, wa jò am mangai aih mùan dahwèq caq, apaq bòch hlài. ");
INSERT INTO hre_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Au cô Chuaq Boc Plình da pì ma khoi dŏih dèch pì loh khoi enh diac Aicàp đòiq am ca pì taneh Ca-na-an, wa broq Boc Plình pì. ");
INSERT INTO hre_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Tàng oh daq ma ŏi haten ca pì loh ca pa, èh ep 'ràng tech dađeh ca pì, apaq thê haq broq tìah ca hapŏng dìch, ");
INSERT INTO hre_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","mahaq phai ngan mangai aih tìah ca mangai broq mùan, loq mangai ŏi đò ti pì, èh haq toq broq bìac trùh hanam lem bùi. ");
INSERT INTO hre_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Khoi ca aih haq wa con caiq haq pi ŏi hnem ìh hòm, èh wì haq hlài dèh ta hnem nhàn yŏc dèh xôxech boc yaq. ");
INSERT INTO hre_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Ma jah 'màng aih, wì haq hapŏng Au, Au ma khoi 'ràng loh khoi gùng Aicàp. Ùh khòh tech wì haq tìah ca wì ma tech hapŏng dìch. ");
INSERT INTO hre_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Pì ùh khòh wèq padit padiang wì haq, mahaq phai iu crè ca Boc Plình pì. ");
INSERT INTO hre_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Pì jah rŏt hapŏng dìch cadrì wa calô enh 'bài jàn ta diac dudan ca pì. ");
INSERT INTO hre_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Pì hadai jah rŏt 'bài hapŏng con caiq da mangai jàn 'noiq ŏi nòi pì, wa wì haq khoi xa-ông loh ta gùng pì 'nang ŏi. Wì haq jah broq cùng hang ca pì. ");
INSERT INTO hre_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Pì jah đòiq wì haq broq xôxech ca con xau pì hloi hloi. Wì haq tìah ca mangai hapŏng dìch dìq dèh can rìh. Mahaq phàn oh daq pì jàn Is-ra-ên, èh ùh i ca mangai leq jah dahnen padit padiang. ");
INSERT INTO hre_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Tàng mangai jàn 'noiq, loq mangai tamoi rìh ŏi ti pì, loh ca can padrŏng, wa mangai Is-ra-ên loh ca pa, èh 'ràng tech dađeh ca mangai jàn 'noiq ŏi ta nòi pì, loq tech dađeh ca cadraq jàn 'noiq, ");
INSERT INTO hre_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","atìq ca haq khoi 'ràng tech dađeh, haq xôq jah i cwìang rŏt hlài. Mangai oh daq haq jah rŏt hlài haq, ");
INSERT INTO hre_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","dùch, con calô dùch, loq oh daq ma 'noiq jah rŏt hlài haq, haq hadai jah rŏt hlài dađeh tàng haq tôm tàu 'bac jèn. ");
INSERT INTO hre_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Mangai aih jah hatình ca mangai ma rŏt haq, enh hanam haq ma tech dađeh trùh hanam bùi lem, cùng ma tech èh jah tình tiaq sôq hanam bàc loq 'biaq. Aih tình tiaq hì cùng baha mangai caq cùng. ");
INSERT INTO hre_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Tàng ŏi bàc hanam trùh hanam bùi lem, mangai aih ep ca'naih mòiq phàn 'bac ma rŏt hlài dađeh. ");
INSERT INTO hre_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Tàng toq ŏi toq 'biaq hanam adroi ca hanam bùi lem, èh haq hatình ca mangai ma rŏt aih toq 'biaq 'bac. ");
INSERT INTO hre_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Mangai enh jàn 'noiq aih phai ngan mangai Is-ra-ên tìah ca mangai ma broq caq cùng rìm hanam. Pì ùh khòh đòiq mangai jàn 'noiq dahnen padit padiang mangai Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Tàng mangai Is-ra-ên 'nhòq jah rŏt hlài jò trùh hanam bùi, 'màng aih haq wa con caiq haq xôq ep ca'naih. ");
INSERT INTO hre_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ma jah 'màng aih jàn Is-ra-ên hapŏng da Au ma 'ràng 'noh enh gùng Aicàp. Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Pì apaq broq 'bài dua 'mù, pùng padì dua 'mù, tùh 'mù, pa'nàng dèh ta gùng jrang xam hmu, loq choh padì hmu broq dua 'mù leq, đòiq bla-op dađeh enh ngìa ca 'mù aih, ma jah Au Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Pì phai wèq dìq Hì Sabat Au wa loq iu Nòi Hadròih da Au. Au Chuaq da pì. ");
INSERT INTO hre_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Tàng pì iu tiaq bàu thê Au, wèq cajap bàu thê da Au wa broq tiaq, ");
INSERT INTO hre_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","èh Au jah am mè troq jò, taneh jah loh ca pì dahwèq caq wa long ta đùng jah loh riang loh plì. ");
INSERT INTO hre_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Joq 'nàng jò blai 'mau jah dùnh trùh jò kech plì nho, jò kech plì nho jah trùh jò rai 'mau mì, pì jah caq panàc wa jah ŏi catèm dèh ta gùng. ");
INSERT INTO hre_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Au am ca gùng pì can catèm đòiq pì jah cùi ùh hìaq yùq crè. Au hadai jêh cađac 'bài ngè xòc ta rôm ta gùng pì, wa ùh i chang gùm jah cwa ta gùng pì, ");
INSERT INTO hre_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","mahaq pì jah hnan đac wì ma git ca pì. Wì haq jah cro enh 'neq ca chang gùm pì; ");
INSERT INTO hre_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","padam ngai pì jah hnan 100 ngai wì haq. 100 ngai pì jah hnan 10.000 wì haq. Dìq ca mangai git ca pì jah cro enh 'neq ca chang gùm pì. ");
INSERT INTO hre_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘ 'Màng aih Au jah lem manoh ca pì, broq ca pì jah xa-ông tam bàc. Au hadai broq wêh jao ti pì. ");
INSERT INTO hre_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Pì caq dahwèq mùa adroi 'nhòq dìq dahwèq mùa atìq khoi trùh. ");
INSERT INTO hre_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Au broq nòi Au ŏi ta 'ne pì, èh manoh Au ùh i jò leq ramòt ca pì loq 'noh đac pì. ");
INSERT INTO hre_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Au jah lam pajùm ca pì, broq Boc Plình pì, wa pì jah broq jàn Au. ");
INSERT INTO hre_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Au Chuaq Boc Plình da pì, Haq ma khoi 'nong pì loh khoi enh gùng Aicàp đòiq pì pi hìaq ep broq hapŏng dìch. Au khoi goh cađac long ech ca pì, broq ca pì jah yòng jang. ");
INSERT INTO hre_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Mahaq tàng pì ùh dì tiaq Au wa ùh broq tiaq bàu thê da Au, ");
INSERT INTO hre_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","tàng pì cađac bàu thê Au wa manoh pì enh tajraq hlài ca bìac ep broq da Au, đòiq pì ùh broq tiaq bàu thê da Au, wa blòq hlài bìac wêh jao Au, ");
INSERT INTO hre_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","èh cô bìac Au jah ca'nìh am ca pì: Au jah ca'nìh am ca pì bìac ramòt dìq ca jaq, aih loh ca ca-ŏc hen, loh ca tacat da'rù, broq ca pì loh ca pònh mat wa loq hŏnh manoh, 'ngwan ca pì rai adrech ma jah 'màng aih mangai git ca pì ma jah caq. ");
INSERT INTO hre_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Au jah tajraq hlài ca pì, 'màng aih pì 'bìq mangai git ca pì jêh ta'blêq ca pì, èh wì ma git ca pì jah wèq cwìang pì; èh pì jah cadàu mot 'nhac ca ùh i ca mangai hnan tiaq. ");
INSERT INTO hre_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Tàng trùh 'mòi 'màng aih mahaq pì xôq ùh tàng bàu Au, taiq bìac broq tôiq pì, Au baxa pì yi hnao ca aih tapèh yàng. ");
INSERT INTO hre_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Au jah bahnhung đac manoh loq catèh da padren dêh pì. Au jah broq plình da pì cadoq tìah ca mem, taneh tìah ca đùng. ");
INSERT INTO hre_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Pì jah 'noh padren 'ngwan, ma jah 'màng aih taneh ùh loh ca pì dahwèq caq, long ùh loh riang, ùh loh plì. ");
INSERT INTO hre_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Tàng pì xôq ùh tàng bàu Au, ùh enh tamàng Au, èh Au taiq tôiq pì, broq baxa pì yi hnao ca aih tapèh yàng. ");
INSERT INTO hre_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Au thê 'bài ngè ma xòc ta rôm rùp 'bài con caiq pì, jêh đac da pì ngè aban, broq ca sôq jàn yi 'biaq, trong lam pì ùh dai i mangai lam. ");
INSERT INTO hre_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Trùh 'mòi 'màng aih, mahaq pì xôq ùh tawìh hlài ta Au wa xôq enh tajraq hlài ca Au, trùh 'mòi 'màng aih mahaq pì xôq ùh iu bìac baxa da Au, xôq enh tajraq hlài ca Au, ");
INSERT INTO hre_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","èh Au cô tajraq hlài ca pì. Taiq tôiq pì, Au jah baxa yi hnao ca aih tam tapèh yàng hòm. ");
INSERT INTO hre_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Au jah 'ràng chang gùm ta pì đòiq ca'naih hlài bìac pì blàq wêh jao da Au. Jò pì tagop dabau ta phôq, Au broq can hinìq trùh ta pì, khoi èh am pì ca wì ma git jah ta'blêq ca pì. ");
INSERT INTO hre_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Jò Au ajèn 'ràng can pangot hrah, 10 ngai gu cadrì pajùm bùh 'benh mòiq tanùh, wì haq càng 'benh aih tang ha'nech ca pì, 'màng aih pì caq ma ùh panàc. ");
INSERT INTO hre_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Trùh 'mòi 'màng aih mahaq pì xôq ùh tàng bàu Au, enh tajraq hlài ca Au, ");
INSERT INTO hre_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","èh Au dìq jaq nòih wa tajraq hlài ca pì, Au taiq tôiq pì ma broq baxa pì yi hnao ca aih tapèh yàng hòm. ");
INSERT INTO hre_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Èh pì jah caq jam con calô wa con cadrì da pì. ");
INSERT INTO hre_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Hi khoi Au jah raliang cađac ca'bŏng tadreo ta nòi ha'nhèq da pì, broq ta-ùc cađac dìq ca'bŏng bùh jreo xùa thùm, khoi èh đòiq hanang pì enh 'nhèq ca dìq dua 'mù khoi raliang da pì, taiq manoh Au ramòt ca pì dìq jaq. ");
INSERT INTO hre_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Au broq ca phôq pì loh ca raliang ralàc, nòi hadròih pì wìa hatenh hatot, èh Au pi nhàn yŏc ngè xua thùm da pì hòm. ");
INSERT INTO hre_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Au jah broq ca gùng pì loh ca wang wê wang wot, èh mangai ma git ca pì ma ŏi ta gùng aih, hadai loh ca hamàih. ");
INSERT INTO hre_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Au palac cađac pì ta rìm jàn, khoi èh 'noh chang gùm tiaq ti cloh pì, 'màng aih gùng loh ca ŏi dech, wa phôq pì loh ca raliang ralàc. ");
INSERT INTO hre_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Jò aih đùng taneh jah padài wa ŏi dech jò pì ŏi ta diac wì ma git ca pì. Jò aih đùng taneh jah padài đòiq jah bùi hùang dìq ca hanam Sabat. ");
INSERT INTO hre_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Jò đùng taneh ŏi dech, haq jah padài, ma jah 'màng aih jò pì ŏi ŏi dèh ta đùng aih, haq ùh jah padài ta dìq ca hanam Sabat da pì. ");
INSERT INTO hre_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Ŏi i mangai leq ta pì jah rìh, jò pì ŏi ta gùng wì mangai ma git ca pì, Au broq ca manoh wì yùq crè, èh atêh hla taclìh xôq broq ca wì haq cadàu mot, ùh crài cleq ca cadàu mot ca chang gùm, 'nhac ùh i ca mangai wê chang gùm hnan tiaq. ");
INSERT INTO hre_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Mangai cô cro enh 'nhèq ca mangai tau tìah ca cadàu ca mangai wê chang gùm 'mat, 'nhac ca ùh i ca mangai leq hnan tiaq wì haq, ma jah 'màng aih pì ùh i ca padren đòiq tajraq dèh ca 'bài mangai ma git ca pì. ");
INSERT INTO hre_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Pì cachìt ta'ne jàn 'noiq, èh gùng da wì ma git ca pì jah lŏn pì. ");
INSERT INTO hre_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ta pì tàng i ma leq ma ŏi rìh taiq bìac ngang dù dađeh wa bìac ngang dù boc yaq pì, broq ca pì loh ca ragìq ragôm ta gùng wì. ");
INSERT INTO hre_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Tàng wì haq anoi 'noh dèh bìac ngang dù dađeh wa bìac ngang dù boc yaq dađeh khoi broq, aih tôiq tajraq hlài ca Au, ");
INSERT INTO hre_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","trùh 'mòi Au hadai tajraq ca wì haq, 'ràng wì haq mùt ta taneh mangai ma git ca wì haq. – Mahaq manàiq cô tàng bìac ùh chìuq cat akia ta manoh da wì haq jah wìa paha'neq dađeh waq ca wì haq cađac dèh manoh broq ngang dù, ");
INSERT INTO hre_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","èh Au jah hmàng hlài bìac wêh jao Au ma khoi broq ca Jacôp, ca Isac, ca Ap-ra-ham. Au hmàng hlài ca gùng cô wa hmàng hlài ca taneh gùng wì haq. ");
INSERT INTO hre_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Taneh ma khoi ŏi dech jah padài dìq ca hanam Sabat, tiaq dèh pàng hanam wì haq ma cađac nòi aih. Jò aih wì haq anoq hlài dèh manoh taiq tôiq lôi dađeh, ma jah 'màng aih wì haq tajraq hlài ca bìac ep broq da Au, wa manoh wì haq ramòt ca bàu thê Au. ");
INSERT INTO hre_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","'Nhac 'màng aih, jò wì haq 'nang ŏi ta gùng mangai ma git ca wì haq, Au hadai ùh cađac wì haq, ùh hìaq ramòt ca wì haq trùh 'mòi raliang cađac wì haq, èh blòq bìac wêh jao Au ma broq ca wì haq, ma jah 'màng aih Au Chuaq Boc Plình da wì haq. ");
INSERT INTO hre_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Au taiq wì haq, jah hmàng hlài bìac wêh jao Au ma khoi broq ca boc yaq wì haq; Au ma khoi 'ràng wì haq loh khoi enh gùng Aicàp enh ngìa ca jàn 'noiq, đòiq broq Boc Plình da wì haq. Au cô Chuaq.’ ” ");
INSERT INTO hre_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Aih dìq ca bàu thê, bìac ep broq wa ranenh da Chuaq khoi broq cajap cajình broq loh ta 'ne Haq wa jàn Is-ra-ên, wa khoi anoi ca Môise ta wang Sinai. ");
INSERT INTO hre_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Doi ca jàn Is-ra-ên: ‘Jò i mangai leq pachac am dađeh ca Chuaq, èh ep am 'bac tiaq sôq 'bac khoi pajaq ca con mangai. ");
INSERT INTO hre_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Gu calô enh 20 hanam trùh 60 hanam, èh pajaq ca haq 50 hliac 'bac tiaq siêclò da Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Tàng gu cadrì, pajaq ca haq 30 hliac 'bac. ");
INSERT INTO hre_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Tàng mangai calô enh padam hanam trùh 20 hanam, èh ep pajaq ca haq 20 hliac 'bac, wa 10 siêclò 'bac ca mangai cadrì. ");
INSERT INTO hre_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Mahaq tàng mangai 'yoh enh mòiq khê trùh padam hanam, èh ep pajaq padam hliac 'bac ca mangai calô wa piq hliac 'bac ca mangai cadrì. ");
INSERT INTO hre_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Tàng mangai craq enh 60 dang tŏc, ìh ep pajaq 10 padam hliac 'bac ca mangai calô wa 10 hliac 'bac ca mangai gu cadrì. ");
INSERT INTO hre_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Mahaq tàng mangai ma khoi pachac aih dìq jaq pa, ùh i ca 'bac am tiaq ìh ma khoi pajaq, èh phai 'ràng mangai aih enh ngìa pajàu đòiq pajàu pajaq toq leq; sôq ma ep am tiaq dèh can hlàt da mangai ma pajaq. ");
INSERT INTO hre_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Tàng mangai leq pachac am mòiq toq ngè aban đòiq broq ngè tadreo ca Chuaq, aih ep waq ca ngè aban hadròih. ");
INSERT INTO hre_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Mangai aih ùh jah halìh, hadai ùh jah yŏc ma lem thai ca 'mèq, loq yŏc ma 'mèq thai ca ma lem. Tàng haq halìh 'màng aih, èh baiq toq aih dìq wìa ngè hadròih. ");
INSERT INTO hre_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Mahaq tàng ngè aban ma am, aih ngè aban ùh hreo, ùh jah broq ngè tadreo am ca Chuaq, èh 'ràng ngè aban aih enh ngìa ca pajàu. ");
INSERT INTO hre_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Èh pajàu aih phai tình ngè aban aih jah toq leq 'bac tiaq ngè aih lem loq 'mèq, hi mac ca pajaq tình 'bac, aih sôq 'bac mangai pachac ep ca'naih. ");
INSERT INTO hre_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Mahaq tàng mangai aih enh rŏt hlài, èh ep am tam mòiq phàn padam sôq 'bac ma pajàu khoi pajaq. ");
INSERT INTO hre_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Tàng i mangai lah crài loh hadròih dèh hnem am ca Chuaq, èh pajàu ngan 'mèq loq lem đòiq pajaq. Haq ep am dì tiaq 'bac ma pajàu khoi pajaq aih. ");
INSERT INTO hre_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Mahaq tàng mangai aih enh rŏt hlài dèh hnem, èh ep am tam mòiq phàn padam jaq haq ma khoi pajaq, èh hnem jah hlài mangai aih. ");
INSERT INTO hre_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Tàng mangai leq enh am dèh mòiq phàn đùng taneh ca Chuaq, èh haq ep am pajaq tiaq dèh adrech nhet đòiq rai ta đùng aih. 'Màng aih phai tình 50 hliac 'bac ca 32 lìt adrech 'mau mat. ");
INSERT INTO hre_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Tàng mangai aih am đùng taneh aih troq jò hanam bùi lem, èh 'bac jaq aih ùh halìh. ");
INSERT INTO hre_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mahaq tàng mangai aih am dèh đùng taneh atìq ca hanam bùi lem, èh pajàu phai tình tiaq hanam ma ŏi aih trùh hanam bùi ma atìq đòiq tình ca jaq đùng aih. 'Màng aih, 'bac jaq da đùng taneh aih loh yi 'biaq. ");
INSERT INTO hre_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Tàng haq khoi am dèh đùng taneh ca Chuaq mahaq enh rŏt hlài, èh haq ep am tam mòiq phàn padam 'bac jaq đòiq đùng aih jah hlài cla haq. ");
INSERT INTO hre_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Mahaq tàng mangai aih khoi tech hlài đùng aih ca mangai 'noiq, èh haq ùh enh rŏt hlài, 'màng aih haq pi jah rŏt hlài hòm. ");
INSERT INTO hre_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Jò trùh hanam bùi lem, taneh đùng jah hlài dŏng dìq ca mangai ma tech, mahaq đùng jah wìa hadròih đòiq crài ca Chuaq, èh đùng aih jah wìa cùng hang da pajàu. ");
INSERT INTO hre_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Tàng i mangai leq enh am ca Chuaq đùng taneh haq rŏt, mahaq ùh xài đùng haq jah dèh enh miq baq, ");
INSERT INTO hre_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","èh pajàu dì tiaq bàu haq ma pajaq trùh hanam bùi, khoi èh hì aih raq mangai cô phai am sôq 'bac aih tajì dèh ca jaq đùng, ma jah 'màng aih cô đùng khoi đòiq crài ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Trùh hanam bùi lem đùng taneh aih jah hlài ca mangai ma tech aih. ");
INSERT INTO hre_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Bìac ma pajàu pajaq aih dì tiaq dèh siêclò Nòi Hadròih, mòiq siêclò jaq 20 gêra. ");
INSERT INTO hre_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Mahaq ùh jah i mangai leq am ca Chuaq con ramua ta ngè aban dađeh, 'nhac ca 'bo loq trìu, ma jah 'màng aih con ramua da ngè aban, aih khoi da Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Tàng aih ngè aban tiaq dèh adrech ùh hreo, mangai aih ep dì tiaq jaq pajàu ma khoi pachì, wa am tam mòiq phàn padam đòiq rŏt hlài ngè aih. Tàng mangai ma am aih ùh rŏt hlài tiaq pajàu ma pajaq cô, èh ep tech ngè aih tiaq haq ma pajaq hlài hòm. ");
INSERT INTO hre_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Mahaq enh gùng ca aih, ngè leq ma khoi jah am ca Chuaq, 'nhac mangai, ngè aban loq taneh đùng da can cadraq, èh ùh 'ràng tech hadai ùh jah rŏt hlài, ma jah 'màng aih ùh kè ca ngè bìac cleq khoi am ca Chuaq dìq jah wìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Dìq ca mangai ma khoi jah pajaq đòiq cachìt tiaq ranenh, ùh jah rŏt dèch hlài, mahaq mangai aih phai 'bìq jêh đac. ");
INSERT INTO hre_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Dìq dŏng mòiq phàn mòiq jàt dahwèq ma abèq achap, 'nhac ca plì long, loq dahwèq enh taneh đùng, jah dŏng da Chuaq, aih ngè hadròih đòiq crài ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Tàng i mangai leq rŏt hlài ngè leq enh mòiq phàn mòiq jàt dađeh, èh phai am tam mòiq phàn padam. ");
INSERT INTO hre_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Khoi èh trùh mòiq phàn jàt ca calùh 'bo, trìu mangai ma ban wa khoi rèn tiaq yŏc long dùi patô ma leq ma trùh sôq 10, ma aih hadròih đòiq crài ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ùh jah ràih ma 'mèq loq lem, hadai ùh jah yŏc ngè ma 'noiq thai ca ngè ma khoi i. Tàng yŏc ngè ma 'noiq thai ca ngè ma khoi i, aih dìq jah dŏng Chuaq, ùh khòh rŏt hlài haq.’ ” ");
INSERT INTO hre_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Aih bàu ma Chuaq doi ca Môise ta wang Sinai đòiq anoi hlài ca jàn Is-ra-ên.");
INSERT INTO hre_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Hì mòiq khê baiq ma hanam baiq, jàn Is-ra-ên loh khoi ca gùng Aicàp. Chuaq doi ca Môise jang Hnem Traiq Cùh Waiq ta braih càn Sinai: ");
INSERT INTO hre_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Ìh phai broq sô achìh hiniq dìq dŏng ca jàn Is-ra-ên, tiaq dèh xinoi wa tiaq dèh hadròng hadrech da wì haq. Rèn dŏng dìq tang hiniq gu calô, ");
INSERT INTO hre_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","enh 20 hanam dang tŏc, aih 'bài mangai ta jàn Is-ra-ên khoi jah loh nòi tajêh poh. Chôp Arôn phai achìh hiniq wì haq tiaq dèh tang lù. ");
INSERT INTO hre_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ta mòiq hadròng hadrech ep i mòiq ngai đòiq jùp đò pì, aih mangai broq gàu da hadròng hadrech haq. ");
INSERT INTO hre_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Cô 'bài hiniq mangai đòiq jùp pì, hadròng hadrech da Rubên: Ê-li-xu con calô da Sêđêu; ");
INSERT INTO hre_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","hadròng hadrech da Si-mê-ôn: Sê-lu-mi-ên, con calô da Xu-ri-sa-đai; ");
INSERT INTO hre_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","hadròng hadrech da Juđa: Nahsôn, con calô da A-mi-na-đap; ");
INSERT INTO hre_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","hadròng hadrech da I-sa-ca: Nê-tha-nên con calô da Xua; ");
INSERT INTO hre_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","hadròng hadrech da Xe-bu-lun: Ê-li-ap, con calô da Hêlôn; ");
INSERT INTO hre_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","con xau da Jôsep, hadròng hadrech da Ep-ra-im: Ê-li-sa-ma, con calô da A-mi-hut; hadròng hadrech da Ma-na-se: Ga-ma-li-ên, con calô da Pê-đah-xu. ");
INSERT INTO hre_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","hadròng hadrech da Bên-ja-min: A-bi-đan, con calô Ghi-đeo-ni; ");
INSERT INTO hre_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","hadròng hadrech da Đan: A-hi-ê-xe, con calô da A-mi-sa-đai. ");
INSERT INTO hre_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","hadròng hadrech da Ase: Pha-ghi-ên, con calô da Ocran; ");
INSERT INTO hre_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","hadròng hadrech da Gat: Ê-li-a-sap, con calô da Đê-u-ên; ");
INSERT INTO hre_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","hadròng hadrech da Nep-ta-li: A-hi-ra, con calô da Ênan;” ");
INSERT INTO hre_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Aih 'bài mangai jah creo enh 'bài jàn, mangai broq gàu da 'bài hadròng hadrech boc yaq dađeh, aih raq 'bài mangai ma broq cwan lình jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","'Màng aih Arôn wa Môise nhàn yŏc 'bài mangai ma khoi jah ràu hiniq aih, ");
INSERT INTO hre_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","èh hì mòiq, khê baiq wa haq tagop dìq dŏng ca jàn, rèn hiniq tang ngai enh 20 hanam dang tŏc, achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, ");
INSERT INTO hre_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","tiaq troi Chuaq khoi thê Môise. 'Màng aih, haq achìh hiniq wì haq 'mùt ta sô jang nòi braih càn Sinai. ");
INSERT INTO hre_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Con xau Rubên, con calô ramua da Is-ra-ên, xinoi wì haq tiaq dèh hadròng hadrech 'bài 'bôq rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc. Aih rìm ngai da hadròng hadrech Rubên khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","sôq mangai calô wì haq 46.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Con xau da Si-mê-ôn: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","sôq mangai calô wì haq 59.300 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Con xau da Gat: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","sôq mangai calô wì haq 45.650 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Con xau da Juđa: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","sôq mangai calô wì haq 74.600 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Con xau da I-sa-ca: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","sôq mangai calô wì haq 54.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Con xau da Xe-bu-lun: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","sôq mangai calô wì haq 57.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Con xau Jôsep: Con xau Ep-ra-im, Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","sôq mangai calô wì haq 40.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Con xau Ma-na-se: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","sôq mangai calô wì haq 32.200 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Con xau da Bên-ja-min: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","sôq mangai calô wì haq 35.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Con xau Đan: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","sôq mangai calô wì haq 62.700 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Con xau da Ase: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","sôq mangai calô wì haq 41.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Con xau da Nep-ta-li: Achìh 'mùt ta sô tiaq dèh ca xinoi wa hadròng hadrech da wì haq, rèn tang hiniq dìq dŏng ca 'bài gu calô enh 20 hanam dang tŏc khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","sôq mangai calô wì haq 53.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Aih 'bài mangai Môise wa Arôn khoi rèn pajùm 12 ngai broq gàu da Is-ra-ên achìh 'mùt ta sô tiaq dèh ca xinoi hadròng hadrech. ");
INSERT INTO hre_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","'Màng aih èh, dìq dŏng ca mangai ta jàn Is-ra-ên khoi jah 'mùt ta sô tiaq dèh 'bài 'bôq, enh 20 hanam dang tŏc, aih rìm ngai ta jàn Is-ra-ên khoi hlàt loh nòi tajêh poh, ");
INSERT INTO hre_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","dìq sôq mangai calô wì haq 603.550 ngai. ");
INSERT INTO hre_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mahaq mangai Lêwi, tiaq dèh hadròng hadrech boc yaq wì haq, ùh achìh 'mùt pajùm ti 'bài hadròng hadrech ma 'noiq. ");
INSERT INTO hre_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ma jah 'màng aih Chuaq khoi doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ìh ùh jah achìh 'mùt hadròng hadrech da mangai Lêwi, wa hadai ùh jah rèn wì haq pajùm ti jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Mahaq phàn 'bài mangai Lêwi, wì phai wèq ngan Hnem Traiq Cùh Waiq wa dìq dŏng ngè bìac ma ŏi ta Hnem Traiq Cùh Waiq. Mangai Lêwi phai genh 'ràng Hnem Traiq Cùh Waiq wa dìq dŏng ngè bìac ta aih, hadai wèq bìac ta Hnem Traiq Cùh Waiq wa traiq dađeh jah đòiq dudan ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Jò leq ep lam 'ràng Hnem Traiq Cùh Waiq, mangai Lêwi phai ti dŏih haq. Jò leq trùh nòi đòiq traiq, èh wì haq pa'nàng hlài. Mangai 'noiq tàng trùh haten phai 'bìq hadrah cachìt. ");
INSERT INTO hre_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Jàn Is-ra-ên rìm ngai phai đòiq traiq hatiaq tang lù, wa rìm traiq phai đòiq haten dèh ca hla cò hadròng hadrech dađeh. ");
INSERT INTO hre_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mahaq mangai Lêwi phai pa'nàng traiq dađeh dudan ca Hnem Traiq Cùh Waiq, đòiq ùh hìaq i can nòih ùc loh ta mangai jàn Is-ra-ên. 'Màng aih, mangai Lêwi phai wèq Hnem Traiq Cùh Waiq.” ");
INSERT INTO hre_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Jàn Is-ra-ên broq tiaq rìm bìac troi Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Chuaq doi ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Jàn Is-ra-ên phai đòiq traiq dudan mahaq hangai ca Hnem Traiq Cùh Waiq. Rìm traiq haten dèh ca hla cò, enh 'neq ca capiac hiniq hadròng hadrech da cla ta jang ca dabau.” ");
INSERT INTO hre_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Traiq lình da Juđa èh broq pah mat mahì loh, haten dèh ca hla cò cwung đôiq dađeh. Mangai broq gàu da mangai Juđa, aih Nahsôn, con calô da A-mi-na-đap, ");
INSERT INTO hre_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","wa cwung đôiq da haq tiaq dèh ma khoi achìh ta sô jah: 74.600 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Haten ca Juđa, aih hadròng hadrech I-sa-ca wa mangai broq gàu mangai I-sa-ca, aih Nê-tha-nên, con calô da Xua, ");
INSERT INTO hre_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","wa cwung đôiq da haq tiaq dèh ma khoi achìh ta sô jah: 54.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Khoi ca aih, hadròng hadrech Xe-bu-lun mangai broq gàu da mangai Xe-bu-lun, aih Ê-li-ap, con calô da Hêlôn, ");
INSERT INTO hre_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","wa cwung đôiq da haq ma khoi achìh ta sô jah: 57.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Mangai ma khoi achìh ta sô tiaq traiq lình Juđa, tang lù dìq dŏng aih: 186.400 ngai. Jò loh lam, wì haq lù ma lam adroi. ");
INSERT INTO hre_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ŏi pah 'ma ca mat mahì loh, i hla cò wa traiq lình da Rubên wa cwung đôiq haq. Mangai broq gàu da mangai Rubên, aih Ê-li-xu, con calô da Sêđêu, ");
INSERT INTO hre_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","wa cwung đôiq haq tiaq dèh ma khoi achìh ta sô jah: 46.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Haten ca Rubên i hadròng hadrech Si-mê-ôn, wa mangai broq gàu da mangai Si-mê-ôn, aih Sê-lu-mi-ên, con calô da Xu-ri-sa-đai, ");
INSERT INTO hre_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","wa cwung đôiq haq tiaq dèh ma khoi achìh ta sô jah: 59.300 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Khoi ca aih i hadròng hadrech da Gat wa mangai broq gàu da mangai Gat, aih Ê-li-a-sap, con calô da Đê-u-ên, ");
INSERT INTO hre_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","wa cwung đôiq haq ma khoi achìh ta sô jah: 45.600 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","'Màng aih dìq ca mangai ma khoi achìh ta sô tiaq traiq lình Rubên, cwung đôiq dìq dŏng jah: 151.450 ngai. Wì haq lam lù ma baiq. ");
INSERT INTO hre_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Atìq ca aih, hadròng hadrech Lêwi ma tòng Hnem Traiq Cùh Waiq, loh lam enh ta'ne dìq ca hadrong hadrech ma 'noiq ta traiq. Dìq ca wì phai lam tiaq troq troi ma khoi ta'mroq hatiaq dèh troi nòi ma wì khoi đòiq traiq. Rìm hadròng hadrech tiaq troq brong dađeh wa tiaq hla cò cla. ");
INSERT INTO hre_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ŏi pah mat mahì mùt, i hla cò da traiq lình Ep-ra-im wa cwung đôiq haq, mangai broq gàu da mangai Ep-ra-im, aih Ê-li-sa-ma, con calô da A-mi-hut, ");
INSERT INTO hre_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","wa cwung đôiq haq tiaq dèh ma khoi achìh ta sô jah: 40.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Haten ca traiq Ep-ra-im, i hadròng hadrech Ma-na-se wa mangai broq gàu da mangai Ma-na-se, aih Ga-ma-li-ên, con calô da Pê-đah-xu, ");
INSERT INTO hre_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","wa cwung đôiq haq tiaq dèh ma khoi achìh ta sô jah: 32.200 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Khoi ca aih i hadròng hadrech Bên-ja-min mangai broq gàu da Bên-ja-min, aih A-bi-đan, con calô da Ghi-đeo-ni, ");
INSERT INTO hre_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","wa cwung đôiq haq tiaq dèh ma khoi achìh ta sô jah: 35.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","'Màng aih dìq ca mangai ma khoi achìh ta sô traiq lình Ep-ra-im tiaq dèh tang lù dìq dŏng jah: 108.100 ngai. Wì haq lam lù ma piq. ");
INSERT INTO hre_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ŏi pah 'ngeo ca mat mahì loh i hla cò traiq da mangai Đan wa cwung đôiq haq, mangai broq gàu da mangai Đan, aih A-hi-ê-xe, con calô da A-mi-sa-đai, ");
INSERT INTO hre_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","wa cwung đôiq da haq tiaq dèh ma khoi achìh ta sô dìq dŏng jah: 62.700 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Traiq haten ca Đan aih hadròng hadrech da Ase, mangai broq gàu da mangai Ase, aih Pha-ghi-ên, con calô da Ocran, ");
INSERT INTO hre_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","wa cwung đôiq haq tiaq dèh ma khoi achìh ta sô dìq dŏng jah: 41.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Khoi ca aih i hadròng hadrech da Nep-ta-li, mangai broq gàu da mangai Nep-ta-li, aih A-hi-ra, con calô da Ênan, ");
INSERT INTO hre_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","wa cwung đôiq haq tiaq dèh ma khoi achìh ta sô dìq dŏng jah: 53.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","'Màng aih dìq ca mangai ma khoi achìh ta sô tiaq traiq lình da Đan, dìq dŏng jah: 157.600 ngai. Wì haq tiaq dèh hla cò dađeh lam tiaq cloh. ");
INSERT INTO hre_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Aih 'bài mangai da jàn Is-ra-ên ma khoi achìh 'mùt ta sô tiaq dèh ta hadròng hadrech. Dìq ca mangai ta traiq lình cwung đôiq ma khoi achìh 'mùt ta sô jah: 603.550 ngai. ");
INSERT INTO hre_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mahaq mangai Lêwi ùh jah 'mùt sô pajùm ca mangai Is-ra-ên, tiaq dèh bàu thê Chuaq ma khoi tanap ca Môise. ");
INSERT INTO hre_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","'Màng aih, mangai jàn Is-ra-ên broq tiaq dèh bàu thê Chuaq ma khoi tanap ca Môise. Wì haq đòiq traiq dèh hla cò, èh wì lam tiaq dèh ca xinoi wa hadròng hadrech dađeh. ");
INSERT INTO hre_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Cô xinoi da Arôn wa Môise jò Chuaq doi ca Môise ta wang Sinai. ");
INSERT INTO hre_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Cô hiniq 'bài con calô da Arôn: Nađap, con ramua; èh A-bi-hu, Ê-li-a-xa wa I-tha-ma. ");
INSERT INTO hre_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Aih 'bài hiniq con Arôn. Wì ma khoi jah xùt dàu đòiq atŏc broq pajàu da Boc Plình. ");
INSERT INTO hre_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Mahaq, Nađap wa A-bi-hu khoi cachìt enh ngìa ca Chuaq jò wa haq atŏc ùnh crài enh ngìa ca Chuaq ta đùng braih càn Sinai; wa cô ùh i ca con. 'Màng aih, Ê-li-a-xa wa I-tha-ma broq bìac pajàu dèh ti baq, Arôn. ");
INSERT INTO hre_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Tagop dìq dŏng 'bài hadròng hadrech mangai Lêwi trùh enh ngìa ca pajàu Arôn, đòiq mangai Lêwi patìh ca Arôn. ");
INSERT INTO hre_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Wì haq jah patìh dìq ca bìac broq da Hnem Traiq Cùh Waiq thai ca Arôn wa thai dìq ca jàn. ");
INSERT INTO hre_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Hadai phai ngan ta'mroq dìq dŏng ca ngè bìac ta Hnem Traiq Cùh Waiq wa broq rìm bìac thai ca jàn Is-ra-ên ŏi ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","'Màng aih ìh phai am mangai Lêwi ca Arôn wa 'bài con calô haq, ma jah 'màng aih wì haq khoi jah ràih enh mangai jàn Is-ra-ên đòiq am ca Arôn. ");
INSERT INTO hre_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","'Màng aih ìh phai yŏc Arôn wa 'bài con da Arôn, đòiq broq pajàu. Tàng mangai 'noiq leq enh broq bìac cô, haq phai 'bìq hadrah ca jêh đac.” ");
INSERT INTO hre_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Cô, enh ta'ne jàn Is-ra-ên, Au ràih yŏc xinoi Lêwi đòiq thai dìq dŏng con ramua da jàn Is-ra-ên, 'màng aih mangai Lêwi èh da Au. ");
INSERT INTO hre_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Ma jah 'màng aih dìq ca con calô da jàn Is-ra-ên aih da Au. Calah nèh jò Au ma jêh đac 'bài con ramua ta gùng Aicàp, Au khoi ràih đòiq crài ca Au dìq dŏng con ramua ta jàn Is-ra-ên, aih enh con mangai wa enh ngè aban, wì haq jah Au: ma jah 'màng aih Au Chuaq.” ");
INSERT INTO hre_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Chuaq doi ca Môise ta braih càn Sinai: ");
INSERT INTO hre_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Ìh phai rèn dìq sôq con calô Lêwi, tiaq dèh xinoi wa hadròng hadrech wì haq, èh achìh dŏng dìq hiniq gu calô enh mòiq khê dàng tŏc.” ");
INSERT INTO hre_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","'Màng aih, Môise achìh 'mùt hiniq mangai Lêwi tiaq bàu thê da Chuaq, tìah troi bàu Chuaq ma khoi tanap ca Haq. ");
INSERT INTO hre_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Cô hiniq tang ngai 'bài con calô da mangai Lêwi: Getsôn, Kêhat, Mê-ra-ri. ");
INSERT INTO hre_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Cô hiniq da 'bài con calô Getsôn, tiaq dèh xinoi wì haq: Lipni wa Si-mê-i. ");
INSERT INTO hre_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Cô 'bài con calô da Kêhat, tiaq dèh xinoi wì haq: Amram, Ixha, Hêprôn wa U-xi-ên. ");
INSERT INTO hre_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Cô 'bài con calô da Mê-ra-ri tiaq dèh xinoi wì haq: Mahli wa Musi. ");
INSERT INTO hre_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Xinoi da Lipni wa xinoi da Si-mê-i, aih xinoi da Getsôn. ");
INSERT INTO hre_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","'Bài mangai ta xinoi Getsôn jah achìh hiniq, rèn dŏng dìq con calô enh mòiq khê dang tŏc, jah: 7.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","'Bài xinoi da Getsôn broq traiq pah 'ma mat mahì mùt, enh pah cloh Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Mangai broq gàu da hadròng hadrech Getsôn, aih Ê-li-a-sap, con calô da La-ên. ");
INSERT INTO hre_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Bìac broq da con xau Getsôn, aih phai ngan ta'mroq dìq ngè bìac 'màng cô: Hnem Traiq Cùh Waiq, traiq, cùa traiq wa bai prình da 'mang Hnem Traiq Cùh Waiq, ");
INSERT INTO hre_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","wa dìq ca bai prình da pagia, bai prình 'mang pagia dudan ca Hnem Traiq Cùh Waiq wa ca'bŏng tadreo, caxi càt padràng wa dìq ca ranac ma nhet. ");
INSERT INTO hre_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Xinoi Amram, xinoi Ix-ha-rit, xinoi Hêprôn wa xinoi U-xi-ên ŏi ti Kêhat, aih 'bài hadròng hadrech da Kêhat. ");
INSERT INTO hre_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Rèn dŏng dìq 'bài hiniq con calô enh mòiq khê dang tŏc jah: 8.600 ngai. Wì haq ngan ta'mroq nòi hadròih. ");
INSERT INTO hre_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Xinoi da con xau Kêhat phai đòiq traiq pah 'ma ca mat mahì loh ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Mangai broq gàu da mangai Kêhat, aih Ê-li-sa-phan, con calô da U-xi-ên. ");
INSERT INTO hre_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Mangai Kêhat ngan ta'mroq hom wêh jao, ca'bŏng, dèch am 'benh hadròih, jènh đen, ca'bŏng tadreo wa dìq ranac da nòi hadròih đòiq waq ca jò cùh waiq, xam dìq ca bìac nhet đòiq patìh. ");
INSERT INTO hre_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Mangai ma wèq gàu 'bài mangai broq gàu da mangai Lêwi, aih Ê-li-a-xa con calô da pajàu Arôn. Haq wèq ngan dìq ca mangai ma broq bìac ta nòi hadròih. ");
INSERT INTO hre_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ca xinoi Mahli wa xinoi Musi, aih hadròng hadrech da Mê-ra-ri. ");
INSERT INTO hre_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Dìq ca mangai da xinoi Mê-ra-ri jah achìh 'mùt ta sô enh mòiq khê dang tŏc jah: 6.200 ngai. ");
INSERT INTO hre_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mangai broq gàu da hadròng hadrech Mê-ra-ri, aih Xu-ri-ên, con calô da A-bi-hai, wì haq đòiq traiq pah 'ngeo ca mat mahì loh ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Mangai Mê-ra-ri phai ngan 'bài long ban da Hnem Traiq Cùh Waiq, dìq ca jrang, xèm i calŏih, wa dìq ca cŏt wa caxi càt, ");
INSERT INTO hre_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","xam dìq ca jrang dudan pagia xam dìq calŏih, long cŏc đêq wa caxi càt. ");
INSERT INTO hre_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Môise, Arôn wa dìq con calô haq phai đòiq traiq pah mat mahì loh enh ngìa ca Hnem Traiq Cùh Waiq. Wì haq phai wèq ngan dìq ca bìac ta Hnem Traiq Cùh Waiq thai ca jàn Is-ra-ên. Mahaq mangai 'noiq enh gùng ca mangai Lêwi ma enh broq bìac cô, phai 'bìq hadrah jêh đac. ");
INSERT INTO hre_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Dìq ca mangai Lêwi ma Môise wa Arôn tiaq bàu thê da Chuaq achìh 'mùt ta sô tiaq dèh ca xinoi. Wì haq rèn dìq dŏng ca gu calô enh mòiq khê dang tŏc jah: 22.000 ngai. ");
INSERT INTO hre_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Khoi ca aih Chuaq doi ca Môise: “Ìh phai achìh dŏng dìq ca con calô ramua da jàn Is-ra-ên enh mòiq khê dang tŏc, 'mùt ta sô hiniq wì haq. ");
INSERT INTO hre_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ìh phai ràih yŏc ca Au mangai Lêwi thai ca 'bài con calô ramua ta jàn Is-ra-ên. Au cô Chuaq. Ìh hadai phai ràih yŏc dìq ngè aban da mangai Lêwi thai ca 'bài ngè aban ramua da jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","'Màng aih Môise rèn dìq con calô ramua ta jàn Is-ra-ên tiaq troi Chuaq ma khoi thê haq. ");
INSERT INTO hre_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Dìq ca con calô ramua rèn tang hiniq enh mòiq khê dang tŏc, dìq dŏng jah: 22.273 ngai. ");
INSERT INTO hre_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Èh Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ìh phai ràih yŏc 'bài mangai Lêwi thai dŏng dìq ca con calô ramua da jàn Is-ra-ên wa ngè aban da mangai Lêwi thai ca ngè aban da jàn Is-ra-ên. 'Màng aih 'bài mangai Lêwi èh jah Au. Au Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Phàn ma con ramua da jàn Is-ra-ên yi hnao ca con ramua da mangai Lêwi 273 ngai aih, ");
INSERT INTO hre_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","èh ìh phai yŏc mòiq ngai padam hliac, tiaq dèh siêclò nòi hadròih, mòiq siêclò baiq Gêra, ");
INSERT INTO hre_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","èh am 'bac cô ca Arôn wa 'bài con calô haq, aih 'bac rŏt hlài 'bài con calô ramua.” ");
INSERT INTO hre_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","'Màng aih Môise yŏc 'bac, rŏt hlài 'bài con calô ramua da Is-ra-ên ma yi bàc ca 'bài mangai Lêwi. ");
INSERT INTO hre_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","'Bac Môise yŏc enh con calô ramua da jàn Is-ra-ên, dìq dŏng jah: 1.365 siêclò, tiaq dèh siêclò nòi hadròih. ");
INSERT INTO hre_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Môise tiaq bàu Chuaq, am 'bac rŏt hlài aih ca Arôn wa 'bài con calô haq tiaq troi bàu thê Chuaq khoi tanap ca Môise. ");
INSERT INTO hre_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Chuaq doi ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Rèn dŏng dìq 'bài con calô da xinoi Kêhat, aih hadròng hadrech da Lêwi, tiaq cadraq wa oh daq da wì haq, ");
INSERT INTO hre_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","enh 30 hanam trùh 50 hanam, aih dìq ca wì ma jah broq bìac patìh ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Cô bìac broq da xinoi Kêhat ta Hnem Traiq Cùh Waiq; wì haq ngan wèq ranac ma dìq jaq hadròih. ");
INSERT INTO hre_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Jò leq phai lam, Arôn wa 'bài con calô haq phai mùt nòi hadròih, dŏih bai prình ma chê nòi hadròih aih, èh caxop hom wêh jao. ");
INSERT INTO hre_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Enh 'nhèq ca bai prình, wì haq tù mòiq lòp akia ca nùac, èh enh 'nhèq ca lòp akia aih, tù mòiq lòp bai nhum xenh, hi khoi 'mùt long tanòng đòiq hi tòng. ");
INSERT INTO hre_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Wì haq hadai phai gùp ca'bŏng đòiq 'benh hadròih xam bai nhum xenh, èh đòiq enh 'nhèq ca bai aih dòt, doi chê, cabi, tah alac broq lè dèch am dahwèq ôq; wa 'benh hadròih hloi hloi enh 'nhèq ca ca'bŏng. ");
INSERT INTO hre_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Wì phai hlèch enh 'nhèq ca ngè aih bai gòh mahem, èh enh 'nhèq ca bai gòh mahem aih, mòiq lòp akia da ca nùac, èh 'mùt long tanòng hi tòng. ");
INSERT INTO hre_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Wì haq phai yŏc bai nhum xenh lom jènh đen, đen, ngè cat tìm đèn, dòt đòiq tah loc đen wa cabi tah dàu đòiq bùh đèn. ");
INSERT INTO hre_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Enh 'nhèq ca bai xenh aih wì phai lom dìq ngè xam mòiq lòp akia ca nùac, hi khoi đòiq enh 'nhèq ca tanòng đòiq hi tòng lam. ");
INSERT INTO hre_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Enh 'nhèq ca ca'bŏng bùh jreo xua thùm broq xam wang, wì haq lom bai xenh wa enh 'nhèq ca lòp bai xenh aih, tù mòiq lòp akia xam ca nùac, hi khoi wì phai 'mùt long tanòng hi tòng. ");
INSERT INTO hre_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Wì haq phai yŏc dìq dŏng 'bài ngè ma broq patìh ta nòi hadròih, caxop xam bai nhum xenh, èh lom dìq xam akia ca nùac, hi khoi đòiq enh 'nhèq ca tanòng đòiq hi tòng lam. ");
INSERT INTO hre_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Wì phai yŏc đac blo enh ca'bŏng tadreo, khoi èh gùp mòiq lòp bai gòh ngùi jang aih. ");
INSERT INTO hre_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Enh 'nhèq ca bai gòh ngùi aih, wì phai đòiq dìq ca ranac da ca'bŏng tadreo, aih dòch đòiq tah cachah, achôn piq rang, canoch, wa doi chê. Enh 'nhèq ca aih wì tù mòiq lòp akia xam ca nùac, hi khoi wì 'mùt tanòng đòiq hi tòng. ");
INSERT INTO hre_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Atìq ca Arôn wa 'bài con calô haq khoi broq gêh padon nòi hadròih wa dìq ranac hadròih, wa jò wì haq phai lam, èh 'bài con calô da Kêhat phai trùh đòiq tòng 'bài ngè bìac aih, mahaq wì haq ùh jah bèq ngè hadròih aih, đòiq wì ùh hìaq cachìt. Ta Hnem Traiq Cùh Waiq, aih 'bài ngè ma con calô Kêhat phai tòng lam. ");
INSERT INTO hre_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Bìac broq da pajàu Ê-li-a-xa con calô Arôn, aih yŏc dàu wa bùh đen, jreo xua thùm, ngè tadreo dèch am xam 'mau mì, dàu xùt, hadai phai ngan dìq ca Hnem Traiq Cùh Waiq wa dìq ca ranac leq ta nòi hadròih.” ");
INSERT INTO hre_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Chuaq doi hòm ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Apaq đòiq hadròng hadrech Kêhat 'bìq hnan 'noh khoi ca hadròng hadrech Lêwi. ");
INSERT INTO hre_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Cô bìac phai broq đòiq wèq ban wì haq jò wì mùt Nòi Hadròih: Arôn wa 'bài con calô haq phai mùt ta nòi aih ti wì haq, am ca wì haq tang ngai ngè leq da mangai aih ma tòng. ");
INSERT INTO hre_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Mahaq wì 'noiq ùh jah mùt nòi aih, 'nhac ca mòiq rahyàc, đòiq ngan ngè hadròih, èh wì haq phai 'bìq cachìt èh.” ");
INSERT INTO hre_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Rèn dŏng dìq con calô da xinoi Getsôn, aih hadròng hadrech da Lêwi, tiaq cadraq wa oh daq da wì haq, ");
INSERT INTO hre_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","enh 30 hanam trùh 50 hanam, aih dìq ca wì ma jah broq bìac patìh ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Cô bìac broq da xinoi Getsôn: ");
INSERT INTO hre_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Wì haq phai tòng bai prình da Hnem Traiq Cùh Waiq, dìq ca Hnem Traiq Cùh Waiq, xam akia ca nùac ma po cùa hnem wa bai prình 'mang hnem, ");
INSERT INTO hre_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","bai prình dudan ca pagia, bai prình 'mang pagia dudan ca Hnem Traiq Cùh Waiq wa ca'bŏng tadreo, caxi ma càt wa dìq ranac ma 'noiq. 'Bài mangai ma ŏi ta hadròng hadrech Getsôn phai ngan wèq bìac cô. ");
INSERT INTO hre_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Dìq dŏng bìac broq da con xau Getsôn, bìac cleq wì haq phai tòng 'ràng, wì haq broq dìq tiaq bàu thê da Arôn wa 'bài con calô Arôn patô. Arôn phai jao ca wì haq ngan wèq ngè bìac cleq wì haq ma tòng 'ràng. ");
INSERT INTO hre_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ta Hnem Traiq Cùh Waiq, aih bìac broq da xinoi con xau Getsôn. Wì haq phai wèq dađeh enh 'neq ca mangai wèq cwìang wì haq, aih I-tha-ma con calô pajàu Arôn. ");
INSERT INTO hre_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Ìh phai rèn wa achìh hiniq 'bài con xau Mê-ra-ri tiaq dèh ca xinoi wa hadròng hadrech wì haq, ");
INSERT INTO hre_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","enh 30 hanam trùh 50 hanam, aih dìq ca mangai jah broq bìac ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Wì haq phai ngan wèq wa tòng 'ràng dìq ca long ban da Hnem Traiq Cùh Waiq, 'bài long pan, jrang wa xèm jrang i calŏih, ");
INSERT INTO hre_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","dìq ca jrang dudan ca pagia wa xèm jrang i calŏih, cŏt, caxi ma càt wa dìq ca ranac wa ngè cleq ma nhet broq bìac aih. Pì phai achìh hiniq rìm tàng ngai phai loq mangai leq tòng ngè leq đòiq ro rang. ");
INSERT INTO hre_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Aih bìac broq da xinoi Mê-ra-ri ta Hnem Traiq Cùh Waiq, tiaq bìac patìh da wì haq enh 'neq ca I-tha-ma con calô pajàu Arôn, mangai wèq cwìang wì haq.” ");
INSERT INTO hre_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","'Màng aih Môise, Arôn wa 'bài mangai broq gàu da jàn, achìh 'mùt ta sô 'bài con xau Kêhat, tiaq dèh ca xinoi wa hadròng hadrech wì haq, ");
INSERT INTO hre_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","enh 30 trùh 50 hanam, aih dìq ca mangai jah broq bìac ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","'Bài mangai ma achìh 'mùt ta sô, tiaq dèh ca xinoi wì haq dìq dŏng jah: 2.750 ngai. ");
INSERT INTO hre_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Aih dìq dŏng mangai da xinoi Kêhat ma Môise wa Arôn khoi rèn 'mùt ta sô đòiq broq bìac ta Hnem Traiq Cùh Waiq, tiaq bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Con xau da Getsôn ma khoi rèn achìh 'mùt ta sô, tiaq dèh ca xinoi wa haq hadròng hadrech wì haq, ");
INSERT INTO hre_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","enh 30 hanam trùh 50 hanam, aih dìq dŏng mangai ma jah broq bìac patìh ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Dìq sôq jah: 2.630 ngai. ");
INSERT INTO hre_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Aih 'bài mangai xinoi con xau da Getsôn khoi achìh 'mùt ta sô. Dìq ca mangai aih broq bìac ta Hnem Traiq Cùh Waiq Môise wa Arôn achìh 'mùt ta sô tiaq bàu thê da Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Con xau da Mê-ra-ri ma khoi rèn achìh 'mùt ta sô, tiaq dèh ca xinoi wa haq hadròng hadrech wì haq, ");
INSERT INTO hre_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","enh 30 hanam trùh 50 hanam, aih dìq dŏng 'bài mangai khoi jah broq bìac patìh ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Dìq dŏng jah: 3.200 ngai. ");
INSERT INTO hre_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Aih dìq dŏng mangai da xinoi Mê-ra-ri ma Môise wa Arôn khoi rèn 'mùt ta sô đòiq broq bìac ta Hnem Traiq Cùh Waiq, tiaq bàu Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Dìq dŏng ca mangai Lêwi ma Môise, Arôn, wa mangai broq gàu da jàn Is-ra-ên rèn achìh 'mùt ta sô, tiaq dèh xinoi wa hadròng hadrech wì haq, ");
INSERT INTO hre_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","enh 30 hanam trùh 50 hanam, aih 'bài mangai jah broq bìac patìh ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Dìq dŏng con calô aih jah: 8.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Wì achìh 'mùt ta sô mangai Lêwi tiaq bàu thê da Chuaq khoi anoi ca Môise, ta'mroq ca tàng ngai tiaq bìac patìh loq tòng 'ràng. Wì haq khoi jah rèn achìh 'mùt ta sô tiaq bàu thê Chuaq khoi tanap ca Môise. ");
INSERT INTO hre_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Thê jàn Is-ra-ên hnan loh dŏng dìq 'bài mangai bacùn, mangai i diac bình loh enh chac wa 'bài mangai khoi bèq hanang cachìt loh khoi enh traiq jàn. ");
INSERT INTO hre_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ùh kè ca gu cadrì loq gu calô, pì phai hnan 'noh dŏng enh gùng ca traiq jàn waq ca wì haq ùh hìaq broq amùa ca traiq, taiq aih nòi Au ŏi.” ");
INSERT INTO hre_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Jàn Is-ra-ên broq tiaq 'màng aih. Wì hnan 'noh dìq ca wì aih loh khoi ca traiq jàn, tiaq troi bàu Chuaq khoi doi ca Môise. ");
INSERT INTO hre_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Ìh phai doi ca jàn Is-ra-ên: Tàng jò leq i mangai calô loq mangai cadrì broq tôiq leq ca mangai 'noiq, tajraq hlài ca ranenh da Chuaq, ");
INSERT INTO hre_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","èh mangai aih phai pa'noh tôiq haq ma khoi broq, khoi èh ca'naih hlài ngè tôm đòiq đèn hlài, èh am tam mòiq phàn padam jaq ngè aih, khoi èh jao hlài ca mangai haq ma khoi broq tôiq aih. ");
INSERT INTO hre_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Mahaq tàng mangai ma jah nhàn ngè aih khoi cachìt, hadai ùh i ca oh daq leq đòiq nhàn yŏc hlài ngè aih, èh ngè aih hlài ta Chuaq, aih hlài ta pajàu, enh gùng ca trìu calô, đòiq ca pajàu broq ngè tadreo rŏt dèch hlài tôiq lôi mangai aih ma khoi broq. ");
INSERT INTO hre_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Dìq ca ngè khoi đòiq crài loh hadròih da jàn Is-ra-ên am ca pajàu, aih hadai ngè da pajàu. ");
INSERT INTO hre_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","'Màng aih, ngè đòiq crài hadròih ma rìm ngai am ca pajàu aih jah dŏng pajàu.” ");
INSERT INTO hre_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Doi ca jàn Is-ra-ên: ‘Tàng i mangai cadrì leq tango, ");
INSERT INTO hre_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","mahaq bìac aih haq cadoc hlèp, ùh i ca mangai hnoq, hadai ùh i ca mangai leq jah rùp jò haq ma tango aih, ");
INSERT INTO hre_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","èh tàng ŏng mangai cadrì cô ti ùac loh ca tarènh taiq mai ùh wèq dèh bàu pachac, loq ŏng mangai cadrì cô ti ùac loh ca tarènh 'nhac ca mai haq khoi wèq dèh bàu pachac, ");
INSERT INTO hre_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","èh mangai ŏng cô phai ajèn dèh mai trùh enh ngìa ca pajàu, hadai phai wê mòiq phàn mòiq jàt êpha dàc 'mau mat, ùh ùc dàu, wa hadai ùh jah tah nhù hùang enh 'nhèq, taiq aih bìac dèch am da bìac tarènh ngè dèch am đòiq bahmàng hlài bìac tôiq lôi ma khoi broq. ");
INSERT INTO hre_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Pajàu phai 'ràng mangai cadrì aih enh ngìa ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","hi khoi pajàu phai yŏc diac hadròih ùc ta cabi xam taneh, èh acom blo taneh ta Hnem Traiq Cùh Waiq tah ta diac. ");
INSERT INTO hre_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Pajàu phai thê mangai cadrì yòng enh ngìa ca Chuaq, ca'naih xàc da haq, đòiq ngè dèch am xam 'mau mì da bìac hmàng ta tì haq, aih ngè dèch am xam 'mau mì da bìac tarènh. Pajàu phai wê cabi diac xang waiq hanip ta tì. ");
INSERT INTO hre_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Pajàu phai thê mangai cadrì aih pachac, khoi èh doi ca haq: “Tàng ìh ùh i cùi ti mangai gu calô leq enh gùng ca ŏng ìh, èh au waiq ìh ùh hìaq chìuq ca bìac hanip cleq da bìac diac xang waiq hanip cô, ");
INSERT INTO hre_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","mahaq tàng enh gùng ca ŏng ìh, ìh khoi caq ŏi ti mangai ma 'noiq, aih khoi broq tôiq tango anang, ");
INSERT INTO hre_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","waiq xìn Chuaq broq ca ìh wìa bìac hanip wa bàu hatò ta'ne dèh jàn cla, broq ca cataih ìh loh ragìq wa cliac ìh loh ca bôq. ");
INSERT INTO hre_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Taiq diac xang ma wìa bìac hanip jah chiu mùt ta cliac broq cliac loh ca êh wa cataih loh ca ragìq.” “ ‘Mangai cadrì aih phai doi: “Amen, Amen.” ");
INSERT INTO hre_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Khoi ca aih pajàu phai achìh dìq bàu hanip cô ta mòiq capiac akia, èh yŏc diac hi 'nheo dìq bàu hanip aih loh ta diac xang. ");
INSERT INTO hre_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Pajàu phai thê mangai cadrì cô ôq diac xang waiq hanip, đòiq diac xang hanip mùt chac haq, broq ca haq jìq hiang ta cliac. ");
INSERT INTO hre_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Pajàu phai yŏc ngè tadreo dèch am xam 'mau mì, aih ngè tadreo ca bìac tarènh enh tì haq, am lam am hlài enh ngìa ca Chuaq, èh 'ràng ca ca'bŏng tadreo, ");
INSERT INTO hre_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","èh yŏc mòiq cadop tì ngè am da 'mau mì đòiq bahmàng hlài aih, bùh ta ca'bŏng tadreo, hi khoi thê mangai cadrì aih ôq diac xang. ");
INSERT INTO hre_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","'Màng aih jò leq pajàu thê haq ôq diac xang aih, tàng joq haq khoi tango anang wa ùh wèq bàu pachac dèh ca ŏng, èh diac xang waiq hanip aih mùt ta chac haq broq ca cliac haq loh ca caiq, cataih haq ragìq wa mangai cadrì cô wìa mangai 'bìq hanip ta'ne jàn. ");
INSERT INTO hre_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mahaq tàng mangai cadrì cô ùh i broq tôiq tango anang, èh haq ùh hìaq 'bìq mòiq bìac cleq, haq jah xa-ông con. ");
INSERT INTO hre_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Aih ranenh da bìac tarènh: Jò mangai cadrì ŏi dèh ti ŏng mahaq broq tôiq tango anang ca mangai 'noiq, ");
INSERT INTO hre_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","loq jò leq manoh tarènh da ŏng haq tarènh dèh ca mai, èh haq phai 'ràng dèh mai enh ngìa ca Chuaq, hi khoi pajàu phai broq dìq dŏng ca bìac hnài ŏi ta ranenh cô ca mangai aih. ");
INSERT INTO hre_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mangai ŏng èh ùh i ca tôiq cleq, mangai mai èh ma ep pòq wê dèh tôiq haq ma khoi broq tàng i.’ ” ");
INSERT INTO hre_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Doi ca jàn Is-ra-ên: ‘Jò mangai cadrì loq mangai calô khoi waiq pachac đòiq wìa mangai Na-xi-rê khoi hùaq am dađeh ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ep wèq dađeh ùh jah ôq alac wa ngè cleq ôq ma loq bu, hadai ùh khòh ôq diac jòq broq xam alac loq cadroh, èh hadai ùh jah ôq diac plì nho, caq plì nho ŏi rìh, loq plì nho croh. ");
INSERT INTO hre_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Adrình ca jò haq pachac hùaq am dađeh aih, ùh jah caq ôq cleq enh long nho ji ùh caq clong loq ca'nhah haq. ");
INSERT INTO hre_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Adrình ca jò haq pachac hùaq Na-xi-rê dađeh, ùh jah pŏt dèh xàc, taiq haq jah hadròih wa khoi lah crài dađeh am ca Chuaq. Haq phai đòiq xàc hon yôh trùh jò bìac pachac haq ma hùaq am dađeh ca Chuaq khoi gêh. ");
INSERT INTO hre_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘Adrình ca jò haq pachac hùaq am dađeh ca Chuaq, haq ùh jah trùh haten ca mangai cachìt. ");
INSERT INTO hre_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","'Nhac ca mangai cachìt aih miq baq loq oh daq, haq ùh jah lam haten mangai cachìt, èh broq ca dađeh amùa. Ma jah 'màng aih teo patô bìac pachac hùaq am dađeh ca Chuaq xôq ŏi jang gàu haq. ");
INSERT INTO hre_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Adrình ca jò haq lah dađeh crài wìa hadròih ca Chuaq, haq ep tiaq ranenh 'màng aih. ");
INSERT INTO hre_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Tàng i mangai leq cachìt cachaiq haten ca haq, broq amùa gàu haq, èh atìq ca aih tapèh hì haq phai coih xàc gàu, 'màng aih haq jah lem hreo, aih hì tapèh. ");
INSERT INTO hre_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Trùh hì rahem, haq phai 'ràng baiq toq trù hnem loq baiq toq trù gùng ca pajàu jang 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Pajàu phai yŏc mòiq toq đòiq broq lè rŏt dèch hlài enh tôiq lôi, mòiq toq đòiq broq ngè tadreo bùh, đòiq rŏt hlài enh tôiq lôi da mangai ma khoi 'bìq ngè cachìt broq amùa aih. Wop hì aih mangai aih phai lah crài dèh gàu loh hadròih waq dèh xàc jah yôh hlài tiaq bàu pachac haq. ");
INSERT INTO hre_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","'Màng aih èh, haq phai lah crài ca dađeh loh hadròih ca Chuaq dìq ca jò 'nah ta atìq cô èh haq pachac broq mangai Na-xi-rê, taiq dìq ca jò 'nah ta adroi pi jah tình hòm, ma jah 'màng aih haq khoi 'bìq ngè cachìt broq amùa. Khoi ca aih haq ep 'ràng mòiq toq trìu con calô mòiq hanam đòiq broq ngè rŏt hlài dađeh. ");
INSERT INTO hre_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Cô ranenh ca mangai Na-xi-rê: Jò leq hì haq ma pachac hùaq am dađeh broq mangai Na-xi-rê khoi gêh, haq phai 'ràng ngè am jang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Haq phai atŏc ngè am ca Chuaq, mòiq toq trìu con calô mòiq hanam ùh i ca teo xìt leq, broq ngè tadreo bùh, wa mòiq toq trìu con cadrì mòiq hanam, ùh i ca teo xìt leq, broq ngè tadreo rŏt hlài enh tôiq lôi, wa mòiq toq trìu calô ùh i ca teo xìt leq, broq ngè tadreo waiq catèm, ");
INSERT INTO hre_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","wa mòiq rô 'benh ùh tah blo broq xam dàc 'yêh 'benh 'yoh tah dàu, 'benh ratang ùh tah blo xùt dàu. Hadai i ngè tadreo dèch am xam 'mau mì wa lè dèch am dahwèq ôq broq tiaq dìq lè 'mat. ");
INSERT INTO hre_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Pajàu phai 'ràng 'bài ngè tadreo cô trùh enh ngìa ca Chuaq, khoi èh am ngè tadreo rŏt hlài enh tôiq lôi wa ngè tadreo bùh da haq. ");
INSERT INTO hre_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Enh gùng ca rô 'benh ùh tah blo, haq phai am hloi trìu calô đòiq broq ngè am da waiq catèm ca Chuaq, i ngè tadreo dèch am xam 'mau mì wa lè dèch am ngè ôq da haq. ");
INSERT INTO hre_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Jang 'mang Hnem Traiq Cùh Waiq mangai Na-xi-rê phai coih dèh xàc gàu, èh yŏc xàc tah ta ùnh enh 'neq ca ngè am da bìac waiq catèm. ");
INSERT INTO hre_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Atìq ca mangai Na-xi-rê coih xàc gàu, pajàu phai yŏc plêh jam ma khoi chìn da trìu calô, mòiq toq 'benh 'yoh ùh i ca blo ta rô, mòiq toq 'benh ratang ùh i ca blo đòiq ta baiq apah gêh tì mangai aih, ");
INSERT INTO hre_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","hi khoi pajàu phai am lam am hlài enh ngìa ca Chuaq. Ngè aih wìa mòiq ngè hadròih am lam am hlài pajùm rada wa cataih am atŏc. Khoi ca aih mangai Na-xi-rê jah ôq alac. ");
INSERT INTO hre_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Aih ranenh ca mangai Na-xi-rê khoi hùaq pachac am atŏc dahwèq ca Chuaq, enh gùng ca aih ngè dèch am ma 'noiq aih tiaq bàu hùaq pachac am tam ngè cleq enh jò baxèm, èh hadai phai broq troq troi 'màng aih.’ ” ");
INSERT INTO hre_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Chuaq doi ca Môise. ");
INSERT INTO hre_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Ìh phai doi ca Arôn wa 'bài con calô haq: ‘Pì ep waiq xôq ca jàn Is-ra-ên 'màng cô: ");
INSERT INTO hre_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “Waiq xìn Chuaq am xôq ca pì wa wèq ban pì. ");
INSERT INTO hre_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Waiq xìn Chuaq, am can 'ngah enh hadrò Haq broq 'ngah ca pì wa am xôq ramŏt ca pì. ");
INSERT INTO hre_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Waiq xìn Chuaq hmàng trùh pì wa am can catèm ca pì.” ’ ");
INSERT INTO hre_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Wì haq phai canòm ca hiniq Au, waiq xôq ca jàn Is-ra-ên 'màng aih, èh Au cô jah am xôq ramŏt ca jàn aih.” ");
INSERT INTO hre_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Jò Môise khoi broq gêh Hnem Traiq Cùh Waiq wa khoi xùt dàu đòiq crài hadròih dìq dŏng ngè da Hnem Traiq Cùh Waiq, haq xùt dàu ca'bŏng tadreo wa dìq ca ranac da ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Èh 'bài mangai broq gàu da jàn Is-ra-ên, aih wì ma broq gàu da 'bài hadròng hadrech ma wèq cwìang achìh 'mùt hiniq jàn ta sô, dìq 'ràng dèch am ngè tadreo. ");
INSERT INTO hre_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","'Màng aih 'bài mangai broq gàu 'ràng ngè tadreo dađeh enh ngìa ca Chuaq, tah ta tadràu toq xê 'bo wa 12 toq 'bo calô dùng xê. Mòiq xê 'bo aih da baiq ngai mangai broq gàu, èh mòiq ngai am mòiq toq 'bo calô. Wì haq am ngè tadreo aih enh ngìa ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ìh phai yŏc dìq ngè da 'bài mangai cô beq, am ca 'bài mangai Lêwi đòiq waq jò 'nong Hnem Traiq Cùh Waiq. Aih am ca rìm tàng ngai tiaq bìac patìh da wì haq.” ");
INSERT INTO hre_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","'Màng aih Môise yŏc 'bài xê 'bo wa 'bo calô am ca 'bài mangai Lêwi. ");
INSERT INTO hre_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Môise am ca con xau Getsôn baiq toq xê 'bo wa pôn toq 'bo calô, tiaq dèh bìac patìh da wì haq, ");
INSERT INTO hre_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","wa jao ca con xau Mê-ra-ri pôn toq xê 'bo wa rahem toq 'bo calô, tiaq dèh bìac patìh da wì haq. I-tha-ma con calô pajàu Arôn broq mangai wèq. ");
INSERT INTO hre_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mahaq Môise ùh am ca con xau Kêhat, ma jah 'màng aih wì haq broq patìh bìac ngè hadròih ma wì haq phai genh ti plêh. ");
INSERT INTO hre_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Jò ca'bŏng tadreo khoi jah xùt dàu, 'bài craq jàn am ngè tadreo enh ngìa ca'bŏng tadreo đòiq broq gêh bìac lè dèch am ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Chuaq doi ca Môise: “ 'Bài craq jàn, mòiq ngai mòiq hì, phai 'ràng dèh ngè tadreo đòiq broq gêh bìac lè dèch am ca'bŏng tadreo.” ");
INSERT INTO hre_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Mangai ma am ngè tadreo hì baxèm, aih Nahsôn, con calô da A-mi-na-đap, tiaq dèh hadròng hadrech Juđa. ");
INSERT INTO hre_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ngè tadreo da haq, aih mòiq toq dòt broq xam 'bac, trap 1 kìq 'ne, mòiq toq doi chê trap 800 gm tiaq can trap nòi hadròih. Baiq toq aih dìq tah dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","mòiq toq 'bo calô bu chuai, mòiq toq trìu calô, mòiq toq trìu con calô bu mòiq hanam, đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, ");
INSERT INTO hre_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô wa padam toq trìu con calô bu mòiq hanam đòiq broq ngè am waiq catèm. Aih ngè dèch am da Nahsôn, con calô da A-mi-na-đap. ");
INSERT INTO hre_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Hì ma baiq Nê-tha-nên, con calô da Xua, craq jàn I-sa-ca dèch am ngè dađeh. ");
INSERT INTO hre_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Haq am mòiq toq dòt 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq dèh can trap nòi hadròih wa baiq toq aih dìq tah dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","mòiq toq 'bo calô, mòiq toq trìu con calô mòiq hanam đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, ");
INSERT INTO hre_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","èh ngè dèch am da bìac waiq catèm, aih baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô, padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da Nê-tha-nên con calô Xua. ");
INSERT INTO hre_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Hì ma piq, mangai broq gàu da con xau Xe-bu-lun, aih Ê-li-ap con calô da Hêlôn. ");
INSERT INTO hre_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ngè tadreo da haq mòiq toq dòt broq xam 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq dèh can trap nòi hadròih, wa baiq toq aih dìq tah dàc 'yêh i dàu, đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","mòiq toq 'bo con calô bu chuai, mòiq toq trìu calô, mòiq toq trìu con calô mòiq hanam, đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, ");
INSERT INTO hre_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","èh da ngè tadreo waiq catèm, aih baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô wa padam toq con trìu bu mòiq hanam. Aih ngè dèch am da Ê-li-ap con calô da Hêlôn. ");
INSERT INTO hre_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Hì pôn trùh mangai broq gàu da con xau Rubên, aih Ê-li-xu con calô Sêđêu. ");
INSERT INTO hre_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ngè da haq, aih mòiq toq dòt xam 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq can trap nòi hadròih, wa baiq toq aih dìq bình dàc 'yêh i dàu, đòiq broq ngè am da 'mau mì, baiq toq aih dìq bình dàc 'yêh i dàu, đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","mòiq toq 'bo calô bu chuai, mòiq toq trìu calô, wa mòiq toq trìu con calô bu mòiq hanam, đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, ");
INSERT INTO hre_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","khoi èh da ngè tadreo waiq catèm, aih baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô, padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da Ê-li-xu con calô da Sêđêu. ");
INSERT INTO hre_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Hì padam trùh mangai broq gàu da con xau Si-mê-ôn, aih Sê-lu-mi-ên, con calô Xu-ri-sa-đai. ");
INSERT INTO hre_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ngè am da haq mòiq toq dòt 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq dèh can trap nòi hadròih. Baiq toq ngè aih dìq bình dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","mòiq toq 'bo calô bu chuai, mòiq toq trìu calô wa mòiq toq trìu con calô bu mòiq hanam, broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Khoi èh da ngè tadreo waiq catèm, aih baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô wa padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da Sê-lu-mi-ên con calô da Xu-ri-sa-đai. ");
INSERT INTO hre_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Hì tadràu trùh mangai broq gàu da con xau Gat, aih Ê-li-a-sap, con calô Đê-u-ên. ");
INSERT INTO hre_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ngè da haq, aih mòiq toq dòt xam 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq dèh can trap nòi hadròih. Baiq toq aih dìq bình dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","mòiq toq 'bo calô bu chuai, mòiq toq trìu calô, mòiq toq trìu con calô bu mòiq hanam, đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Khoi èh da ngè tadreo waiq catèm, aih baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô, wa padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da Ê-li-a-sap con calô Đê-u-ên. ");
INSERT INTO hre_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Hì ma tapèh trùh mangai broq gàu da con xau Ep-ra-im, aih Ê-li-sa-ma con calô da A-mi-hut. ");
INSERT INTO hre_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ngè dèch am da haq, aih mòiq toq dòt xam 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq dèh can trap nòi hadròih. Baiq ngè aih dìq bình dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","mòiq toq 'bo calô bu chuai, mòiq toq trìu calô wa mòiq toq trìu con calô bu mòiq hanam, đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","mòiq toq bubi calô đòiq broq lè rŏt hlài enh tôiq lôi, ");
INSERT INTO hre_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","èh da ngè tadreo waiq catèm, aih baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô, wa padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da Ê-li-sa-ma con calô da A-mi-hut. ");
INSERT INTO hre_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Hì rahem trùh mangai broq gàu da con xau Ma-na-se, aih Ga-ma-li-ên con calô da Pê-đah-xu. ");
INSERT INTO hre_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ngè dèch am da haq mòiq toq dòt xam 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq dèh can trap nòi hadròih. Baiq ngè aih dìq bình dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","mòiq toq 'bo calô bu chuai, mòiq toq trìu calô wa mòiq toq trìu con calô bu mòiq hanam, đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","mòiq toq bubi đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Khoi èh ngè tadreo waiq catèm, aih baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô wa padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da Ga-ma-li-ên con calô da Pê-đah-xu. ");
INSERT INTO hre_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Hì hachìn trùh mangai broq gàu da con xau Bên-ja-min, aih A-bi-đan con calô da Ghi-đeo-ni. ");
INSERT INTO hre_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ngè dèch am da haq, aih mòiq toq dòt xam 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq dèh siêclò nòi hadròih. Baiq ngè aih dìq bình dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","mòiq toq doi chrŏng xam wang, trap 110 gm tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","mòiq toq 'bo calô bu chuai, mòiq toq trìu calô wa mòiq toq trìu con calô bu mòiq hanam đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Khoi èh da ngè tadreo waiq catèm, aih, baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô wa padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da A-bi-đan con calô da Ghi-đeo-ni. ");
INSERT INTO hre_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Hì 10 trùh mangai broq gàu da con xau Đan, aih A-hi-ê-xe con calô da A-mi-sa-đai. ");
INSERT INTO hre_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ngè dèch am da haq, aih mòiq toq dòt xam 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, 800 gm tiaq dèh can trap nòi hadròih. Baiq ngè aih bình dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Mòiq toq doi chrŏng xam wang 110 gm tah bình jreo xua thùm. ");
INSERT INTO hre_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Mòiq toq 'bo calô bu chuai, mòiq toq trìu calô wa mòiq toq trìu con calô bu mòiq hanam đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Khoi èh da ngè tadreo waiq catèm, aih baiq toq 'bo calô, padam toq con trìu, padam toq bubi calô wa padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da A-hi-ê-xe, con calô A-mi-sa-đai. ");
INSERT INTO hre_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Hì 11 trùh mangai broq gàu da con xau Ase, aih Pha-ghi-ên con calô da Ocran. ");
INSERT INTO hre_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ngè dèch am da haq, aih mòiq toq dòt 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq dèh can trap nòi hadròih. Baiq ngè aih dìq bình dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","mòiq toq 'bo calô, mòiq toq trìu calô, wa mòiq toq trìu con calô bu mòiq hanam đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Khoi èh da ngè tadreo waiq catèm, aih baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô wa padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da Pha-ghi-ên con calô Ocran. ");
INSERT INTO hre_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Hì 12 trùh mangai broq gàu da con xau Nep-ta-li, aih A-hi-ra con calô da Ênan. ");
INSERT INTO hre_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ngè dèch am da haq, aih mòiq toq dòt 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm tiaq dèh can trap nòi hadròih. Baiq ngè aih dìq bình dàc 'yêh i dàu đòiq broq ngè tadreo dèch am xam 'mau mì, ");
INSERT INTO hre_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","mòiq toq doi chrŏng xam wang, trap 110 gm, tah bình jreo xua thùm, ");
INSERT INTO hre_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","mòiq toq 'bo calô, mòiq toq trìu calô wa mòiq toq trìu con calô bu mòiq hanam đòiq broq ngè tadreo bùh, ");
INSERT INTO hre_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, ");
INSERT INTO hre_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Khoi èh da ngè tadreo waiq catèm, aih baiq toq 'bo calô, padam toq trìu calô, padam toq bubi calô wa padam toq trìu con calô bu mòiq hanam. Aih ngè dèch am da A-hi-ra con da Ênan. ");
INSERT INTO hre_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Aih 'bài ngè đòiq dèch am da mangai broq gàu jàn Is-ra-ên đòiq broq lè ca'bŏng tadreo: 12 dòt xam 'bac, 12 toq doi chê xam 'bac wa 12 toq doi chrŏng xam wang, ");
INSERT INTO hre_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","mòiq toq dòt 'bac, trap 1 kìq 'ne, mòiq toq doi chê 'bac, trap 800 gm dìq dŏng sôq 'bac da dòt wa doi chê jah 28 kìq 'bac tiaq dèh can trap nòi hadròih, ");
INSERT INTO hre_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","12 toq doi chrŏng xam wang, bình jreo xua thùm, mòiq toq trap jah 110 gm, tiaq dèh can trap nòi hadròih, tình dìq wang da doi chrŏng, aih jah 1 kìq 'ne. ");
INSERT INTO hre_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Dìq dŏng 'bo calô da ngè tadreo bùh: 12 toq, 12 toq trìu calô, 12 toq trìu con calô bu mòiq hanam xam 12 ngè tadreo dèch am xam 'mau mì wa 12 toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Tình dìq dŏng ca 'bo calô, da ngè tadreo waiq catèm, jah 24 toq wa 60 toq trìu calô, 60 toq bubi calô, 60 toq trìu con calô bu mòiq hanam. Aih ngè đòiq broq ngè tadreo đòiq broq gêh bìac lè dèch am ca'bŏng tadreo, atìq ca'bŏng jah xùt dàu. ");
INSERT INTO hre_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Jò Môise mùt ta Hnem Traiq Cùh Waiq đòiq capoch tùang ca Chuaq, èh haq tàng bàu capoch ca haq enh calàp baxŏng tôiq đòiq jang hom wêh jao ŏi ta 'ne baiq toq chê-ru-bim. ");
INSERT INTO hre_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Doi ca Arôn: ‘Jò leq ìh ta'mroq tapèh toq đen, ìh phai broq đòiq can 'ngah haq jraq loh 'nah ta ngìa jènh đen.’ ” ");
INSERT INTO hre_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Arôn broq 'màng aih, ta'mroq đen đòiq can 'ngah jraq ta ngìa jènh đen tiaq troi bàu thê Chuaq ma khoi tanap ca Môise. ");
INSERT INTO hre_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Jènh đen khoi broq xam wang tùq ratang, jènh haq wa riang haq hadai tùq ratang, 'màng aih wì haq broq jènh đen tiaq troi dua Chuaq ma khoi patô ca Môise hnoq. ");
INSERT INTO hre_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Hi khoi Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Ep ràih yŏc mangai Lêwi ŏi ta jàn Is-ra-ên, lah crài wì haq đòiq broq hreo jah hadròih. ");
INSERT INTO hre_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Cô bìac ìh phai broq đòiq wì haq jah hreo: Ìh phai da'rat diac hreo ta chac wì haq, khoi èh thê wì coih dìq dèh ta chac, rùh eo, padon dađeh đòiq jah hreo. ");
INSERT INTO hre_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Èh wì haq phai yŏc mòiq toq 'bo calô wa ngè tadreo dèch am xam da 'mau mì, dàc 'yêh i dàu, khoi èh mòiq toq 'bo calô ma 'noiq hòm đòiq broq ngè tadreo rŏt hlài enh tôiq. ");
INSERT INTO hre_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","'Màng aih, ìh phai thê mangai Lêwi trùh haten jang 'mang Hnem Traiq Cùh Waiq, hi khoi tagop dìq dŏng ca jàn Is-ra-ên, ");
INSERT INTO hre_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","èh thê mangai Lêwi trùh haten enh ngìa ca Chuaq, hi khoi jàn Is-ra-ên đòiq tì achac mangai Lêwi. ");
INSERT INTO hre_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Arôn dèch am mangai Lêwi ca Chuaq tìah ca ngè atŏc am lam am hlài da mangai Is-ra-ên am atŏc, đòiq wì haq padon dèh manoh patìh bìac hnem Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Mangai Lêwi yŏc tì đòiq agàu baiq toq 'bo calô, mòiq toq đòiq broq ngè tadreo rŏt hlài enh tôiq mòiq toq broq ngè tadreo bùh ca Chuaq, đòiq broq lè rŏt hlài enh tôiq lôi da mangai Lêwi. ");
INSERT INTO hre_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ìh phai thê mangai Lêwi yòng enh ngìa ca Arôn wa 'bài con calô Arôn, dèch am wì haq ca Chuaq tìah ca ngè tadreo am lam am hlài enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","'Màng aih ìh lah đòiq crài mangai Lêwi enh ca jàn Is-ra-ên, ma jah 'màng aih mangai Lêwi èh da Au. ");
INSERT INTO hre_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Atìq ca aih, èh mangai Lêwi jah trùh đòiq patìh bìac da Hnem Traiq Cùh Waiq, mahaq ìh phai broq ca wì hreo hadròih, khoi èh dèch am wì haq tìah ca ngè tadreo am lam am hlài. ");
INSERT INTO hre_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ma jah 'màng aih ŏi ta jàn Is-ra-ên, mangai Lêwi aih dìq da Au. Au khoi ràih yŏc wì haq đòiq thai dìq dŏng con ramua da jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ma jah 'màng aih taiq dìq dŏng con ramua ta jàn Is-ra-ên dìq jah dŏng da Au, ùh kè mangai loq ngè aban. Au khoi đòiq wì haq lah crài ca Au ta hì Au jêh cachìt rìm ngai con ramua ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mahaq Au khoi ràih yŏc mangai Lêwi thai ca rìm ngai con ramua da jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ma jah 'màng aih ta jàn Is-ra-ên, Au khoi ràih mangai Lêwi am ca Arôn wa 'bài con calô haq, đòiq patìh bìac da jàn Is-ra-ên ta Hnem Traiq Cùh Waiq, wa thai ca jàn Is-ra-ên broq lè rŏt hlài enh tôiq lôi am dìq ca jàn Is-ra-ên, nhò 'màng aih mangai Is-ra-ên ùh hìaq 'bìq hinìq ramòt jò wì haq trùh haten ca nòi hadròih.” ");
INSERT INTO hre_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","'Màng aih, Môise, Arôn wa dìq ca jàn Is-ra-ên broq ca wì mangai Lêwi, tiaq troi Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Mangai Lêwi hadai broq ca dađeh wìa hadròih enh tôiq, rùh dèh eo yôh, hi khoi Arôn dèch am wì haq tìah ca ngè tadreo am lam am hlài enh ngìa ca Chuaq, broq ngè rŏt hlài enh tôiq lôi ca wì haq, đòiq broq wì haq jah hreo. ");
INSERT INTO hre_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Khoi ca aih mangai Lêwi mùt ta Hnem Traiq Cùh Waiq đòiq patìh broq bìac enh ngìa ca Arôn wa 'bài con calô haq. Wì haq broq ca mangai Lêwi tiaq troi bàu thê Chuaq ma khoi tanap ca Môise. ");
INSERT INTO hre_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Cô ranenh đòiq ca mangai Lêwi: Enh 25 hanam dang tŏc, mangai Lêwi phai mùt đòiq patìh broq bìac ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Mahaq trùh 50 hanam, èh wì haq pi i broq hòm. ");
INSERT INTO hre_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Mahaq xôq ŏi jah mùt ta Hnem Traiq Cùh Waiq đòiq broq toq 'biaq jùp đò dèh oh daq.” ");
INSERT INTO hre_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Khê 10, hanam ma baiq, atìq ca wì haq loh khoi enh gùng Aicàp, Chuaq doi ca Môise ta braih càn Sinai: ");
INSERT INTO hre_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Jàn Is-ra-ên phai wèq Lè Lam Cwa troq hì khê khoi pajaq. ");
INSERT INTO hre_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Pì phai wèq lè aih troq hì khê khoi pajaq, aih hì 14, khê 12, jò xèq dadrìch, pì ep broq tiaq dŏng dìq ranenh ma khoi pachì đòiq ca lè aih.” ");
INSERT INTO hre_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","'Màng aih Môise doi ca jàn Is-ra-ên đòiq wì haq wèq Lè Lam Cwa. ");
INSERT INTO hre_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Jàn Is-ra-ên wèq Lè Lam Cwa ta khê 12, hì 14, jò xèq dadrìch, ta braih càn Sinai, broq tiaq rìm bìac Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Mahaq hì aih i toq biaq ngai ùh jah wèq Lè Lam Cwa taiq hanang mangai cachìt broq ca wì haq amùa. Wì haq trùh enh ngìa ca Môise wa Arôn. ");
INSERT INTO hre_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Wì haq doi ca Môise: “ 'Nhac ca nhèn 'bìq top amùa taiq hanang da con mangai, hagleq nhèn ùh i đeh ca phàn ta jàn Is-ra-ên đòiq am ngè tadreo ca Chuaq wa tiaq jò ma khoi patô?” ");
INSERT INTO hre_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Môise tèu wì haq: “Gòm beq đòiq au trùh tamàng waq ca loq bìac Chuaq anoi ca pì.” ");
INSERT INTO hre_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Doi ca jàn Is-ra-ên: ‘Jò leq i mòiq ngai ŏi ta pì loq ŏi ta xinoi pì 'bìq amùa taiq hanang, loq jiang lam hangai, èh wì aih hadai jah wèq Lè Lam Cwa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","'Bài mangai aih phai wèq Lè Lam Cwa cô khê baiq, hì 14, jò xèq dadrìch. Wì haq phai caq 'benh ùh tah blo wa cachiq xang. ");
INSERT INTO hre_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Apaq đòiq rah haq trùh xroq èh, hadai ùh khòh goh 'bài caxènh; phai wèq tiaq rìm ranenh da Lè Lam Cwa aih. ");
INSERT INTO hre_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mahaq mangai leq lem hreo wa ùh hìaq lam hangai, khoi èh tàng ùh wèq Lè Lam Cwa, èh mangai aih phai 'bìq hnan 'noh khoi dèh ca jàn, ma jah 'màng aih mangai aih ùh dèch am ngè tadreo ca Chuaq jò ma khoi pajaq. Haq phai pòq wê dèh tôiq dađeh. ");
INSERT INTO hre_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Tàng i mangai jàn 'noiq ŏi ta pì, mahaq haq enh wèq Lè Lam Cwa ca Chuaq, èh phai wèq tiaq ranenh wa rìm bìac ca Lè Lam Cwa; phai i toq mòiq ranenh am ca mangai jàn 'noiq wa mangai leq ma xa-ông ta gùng aih.’ ” ");
INSERT INTO hre_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","'Màng aih hì wì ma pa'nàng Hnem Traiq Cùh Waiq, i cato yùc lom dŏng Hnem Traiq Cùh Waiq ma đòiq hom wêh jao. Jò xèq tìah hagleq i mòiq cato ùnh ŏi enh 'nhèq ca Hnem Traiq Cùh Waiq trùh daxroq. ");
INSERT INTO hre_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","I yôt 'màng aih; dahì cato yùc lom Hnem Traiq Cùh Waiq; damang cato yùc tìah hagleq i ùnh. ");
INSERT INTO hre_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Jò leq cato yùc tŏc khoi ca Hnem Traiq Cùh Waiq, èh jàn Is-ra-ên hi loh lam. Trùh jang leq cato yùc i yòng, èh jàn Is-ra-ên hi pa'nàng traiq jang aih. ");
INSERT INTO hre_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Jàn Is-ra-ên loh lam tiaq bàu thê Chuaq wa đòiq traiq hadai tiaq bàu thê da Haq, jò cato yùc lom ŏi enh 'nhèq. ");
INSERT INTO hre_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Jò leq cato yùc ŏi enh 'nhèq ca Hnem Traiq Cùh Waiq dùnh hì, èh jàn Is-ra-ên ùh loh lam, mahaq ŏi jang aih hadai dùnh hì tiaq bàu thê Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Mahaq tàng cato yùc ŏi lom toq biaq hì enh 'nhèq ca Hnem Traiq Cùh Waiq aih, atìq ca aih, jàn Is-ra-ên loh lam tiaq bàu thê da Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","I yàng cato yùc toq yòng enh daxèq trùh daxroq, mahaq jò cato yùc tŏc daxroq, èh wì haq loh lam. Ùh kè dahì loq damang, rìm yàng yùc tŏc khoi, wì haq loh lam. ");
INSERT INTO hre_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Jò cato yùc yòng enh 'nhèq ca Hnem Traiq Cùh Waiq, baiq hì loq mòiq khê loq mòiq hanam, èh wì xôq ŏi, ùh loh lam, mahaq tàng cato yùc hi tŏc lam, wì haq hadai hi lam. ");
INSERT INTO hre_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Tiaq bàu thê da Chuaq, jàn Is-ra-ên đòiq traiq wa tiaq bàu thê da Chuaq wì haq loh lam. Wì haq wèq bàu thê da Chuaq ma khoi nhò Môise anoi hlài. ");
INSERT INTO hre_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Broq baiq toq ken xam 'bac tùq ratang beq, đòiq creo jò enh tagop wì jàn wa hlôi jò dŏih 'noh traiq đòiq loh lam. ");
INSERT INTO hre_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Jò leq wì hlôi baiq toq ken, dìq dŏng ca jàn phai trùh haten ca ìh jang 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Tàng wì hlôi mòiq toq ken, èh dìq ca mangai broq gàu da hadròng hadrech Is-ra-ên phai tagop haten ca ìh. ");
INSERT INTO hre_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Mahaq jò leq hlôi bàu dêh yàng mòiq, èh dìq mangai i traiq ŏi pah mat mahì loh, phai loh lam. ");
INSERT INTO hre_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Jò hlôi bàu dêh yàng ma baiq, èh dìq mangai i traiq ŏi pah 'ma mat mahì loh, phai loh lam. Wì haq hlôi dêh jò leq, èh jò aih 'bài traiq loh lam. ");
INSERT INTO hre_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Jò tagop jàn, phai hlôi, mahaq apaq hlôi bàu dêh. ");
INSERT INTO hre_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“ 'Bài con calô Arôn ma broq pajàu phai hlôi ken cô, enh 'nhòng cô trùh 'nhòng tau. Cô mòiq ranenh hloi hloi ca pì. ");
INSERT INTO hre_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Jò leq ta gùng pì loh tajêh poh mangai ma tagit enh tajêh ca pì, èh phai hlôi ken bàu dêh, đòiq Chuaq Boc Plình da pì jah hmàng hlài ca pì, èh pì jah dèch claih ca wì ma tagit ca pì. ");
INSERT INTO hre_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Hì lem bùi ta 'bài lè hiniang wa gàu khê da pì, èh phai hlôi ken, jò dèch atŏc ngè tadreo bùh wa ngè tadreo waiq catèm hadai, đòiq broq bahmàng hlài enh ngìa ca Chuaq Boc Plình da pì. Au Chuaq Boc Plình da pì.” ");
INSERT INTO hre_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Wop hì 21, khê baiq, hanam ma baiq, cato yùc tŏc khoi ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Jàn Is-ra-ên hi dŏih 'noh traiq loh enh braih càn Sinai, èh cato yùc yòng jang braih càn Paran. ");
INSERT INTO hre_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","'Màng aih cô yàng baxèm jàn Is-ra-ên loh lam tiaq bàu thê Chuaq khoi nhò Môise anoi hlài. ");
INSERT INTO hre_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Dìq dŏng ca hadròng hadrech da Juđa lam adroi, enh 'neq dèh ca hla cò dađeh. Nahsôn con calô A-mi-na-đap, broq gàu ca traiq lình Juđa. ");
INSERT INTO hre_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nê-tha-nên con calô da Xua, broq gàu da lù lình I-sa-ca. ");
INSERT INTO hre_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Ê-li-ap con calô Hêlôn, broq gàu da lù lình Xe-bu-lun. ");
INSERT INTO hre_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Jò Hnem Traiq Cùh Waiq hi dŏih 'noh, con xau Getsôn wa con Mê-ra-ri tòng Hnem Traiq Cùh Waiq, hi loh lam. ");
INSERT INTO hre_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Khoi ca aih, lù lình da Rubên loh lam enh 'neq hla cò dađeh. Ê-li-xu con calô Sêđêu broq gàu ca Rubên. ");
INSERT INTO hre_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Sê-lu-mi-ên con calô da Xu-ri-sa-đai broq gàu lù lình da Si-mê-ôn. ");
INSERT INTO hre_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ê-li-a-sap con calô da Đê-u-ên broq gàu lù lình da Gat. ");
INSERT INTO hre_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Con xau da Kêhat loh lam tòng wê dìq ngè hadròih ta Hnem Traiq Cùh Waiq. Hnem Traiq Cùh Waiq wì pa'nàng gêh adroi ca con xau Kêhat trùh. ");
INSERT INTO hre_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Khoi ca aih lù lình da Ep-ra-im loh lam tiaq dèh hla cò. Ê-li-sa-ma, con calô A-mi-hut broq gàu ca Ep-ra-im. ");
INSERT INTO hre_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ga-ma-li-ên con calô Pê-đah-xu broq gàu lù lình da Ma-na-se. ");
INSERT INTO hre_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","A-bi-đan con calô Ghi-đeo-ni broq gàu lù lình da Bên-ja-min. ");
INSERT INTO hre_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Atìq lùch, dìq dŏng lù lình da Đan loh lam tiaq dèh hla cò dađeh. A-hi-ê-xe, con calô A-mi-sa-đai broq gàu ca cwung đôiq Đan, ");
INSERT INTO hre_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","wa Pha-ghi-ên con calô da Ocran broq gàu ca lù lình Ase, ");
INSERT INTO hre_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","wa A-hi-ra, con calô Ênan broq gàu ca lù lình Nep-ta-li. ");
INSERT INTO hre_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Aih tàng lù da cwung đôiq loh lam da jàn Is-ra-ên tiaq dèh bình lình loh lam 'màng aih. ");
INSERT INTO hre_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","'Màng aih Môise doi ca Hôbap con calô da Ruên mangai Ma-đi-an, aih daq mai Môise: “Nhèn lam trùh gùng ma Chuaq i doi: Au jah am gùng aih ca pì. Xìn pì lam tiaq nhèn oq, nhèn ta'mroq palòng bìac lem ca pì, ma jah 'màng aih Chuaq i hùaq am bìac lem ca jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hôbap tèu haq: “Au ùh lam ta leq, mahaq au ŏi hlài dèh ta gùng au, nòi oh daq au.” ");
INSERT INTO hre_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Môise doi ca haq: “Au xìn ìh apaq cađac nhèn, ma jah 'màng aih ta nòi braih càn ìh loq nòi leq lem ca broq traiq; ìh tìah ca mat nhèn. ");
INSERT INTO hre_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Tàng ìh hadai lam tiaq nhèn, èh nhèn jah axong ca pì bìac lem Chuaq ma hùaq am ca nhèn.” ");
INSERT INTO hre_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","'Màng aih jàn Is-ra-ên lam enh wang Chuaq, wang Sinai, lam ta trong piq hì. Hom wêh jao da Chuaq lam adroi đòiq chaq ca jàn nòi padài. ");
INSERT INTO hre_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Jò wì haq dŏih traiq loh lam, èh cato yùc da Chuaq ŏi enh 'nhèq ca wì haq. ");
INSERT INTO hre_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Jò Hom Wêh Jao loh lam, Môise doi: “Ôi Chuaq, xìn yòng beq, đòiq jêh đac wì ma tagit ca Ìh đòiq wì haq pac lac, wa cadàu mot enh ngìa ca Ìh.” ");
INSERT INTO hre_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Jò wì tòng Hom Wêh Jao padài, èh Môise doi: “Ôi Chuaq, xìn Ìh tawìh hlài ti bàc ngŏng mangai jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Manàiq cô jàn baxèm mamùc mamac taiq glàm bìac nan xa, èh Chuaq tàng. Can nòih Haq tŏc, wa ùnh da Chuaq cheo ta'ne 'bài jàn bùh cheo cađac traiq jàn ma ŏi pah kenh. ");
INSERT INTO hre_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Mangai jàn cachech creo ca Môise, waiq xìn Chuaq, èh ùnh pi cheo hòm. ");
INSERT INTO hre_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Nòi aih jah creo: Ta-bê-ra, ma jah 'màng aih ùnh da Chuaq khoi cheo ta'ne jàn. ");
INSERT INTO hre_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Wì ma khoi broq 'màng aih, aih mangai jàn 'noiq ma alôn alàc ti jàn Is-ra-ên, i manoh ham enh, broq ca mangai Is-ra-ên hadai crò hmoi, hi doi: “Nhèn enh caq jam! ");
INSERT INTO hre_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nhèn hmàng hlài jò nhèn ma ŏi ta Aicàp, nhèn jah caq ca mahaq ùh ep rŏt, jah caq paya, caq bacai, cwai kiuq, henh wa toi, ");
INSERT INTO hre_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","mahaq manàiq cô padren hiwa nhèn loh croh crêh, ùh i caq cah cleq enh gùng ca Mana.” ");
INSERT INTO hre_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana cô i pliang haq tìah ca clong plì ngò, ngan tìah ca hmu ngŏc. ");
INSERT INTO hre_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Mangai jàn loh acom yŏc, khoi èh xai xam apao hmu loq pêh xam apao pêh, pai ta gŏc, hi khoi broq 'benh, caq tìah ca 'benh i alôn dàu ôliu. ");
INSERT INTO hre_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Damang jò diac ngom clìh, mana hadai clìh dudan ca traiq jàn. ");
INSERT INTO hre_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","'Màng aih Môise tàng mangai jàn hmoi, rìm ngai ŏi dèh jang mang traiq dađeh. Can nòih da Chuaq plôh tŏc, èh Môise ùh lem manoh. ");
INSERT INTO hre_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","'Màng aih, Môise doi ca Chuaq: “Gleq Ìh ma broq dèh ca hapŏng 'yoh Ìh chìuq xa? Gleq au ma ùh jah xôq enh ngìa ca Ìh, trùh 'mòi Ìh ma dèch dìq dŏng can trap da jàn cô enh 'nhèq ca au? ");
INSERT INTO hre_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Au i ŏi jiang ca wì haq ùh? Au ma i xa-ông 'noh wì haq đòiq Ìh jah doi ca Au: Thê ca'mình jàn cô ta manoh ìh tìah ca mangai baq ban ca'mình con nga, trùh gùng ma ìh khoi pachac hùaq hnhu am ca boc yaq da wì haq? ");
INSERT INTO hre_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Au ma i ca jam enh leq ma axong ca wì haq? Ma jah 'màng aih wì hmoi ca au, doi: ‘Am ca nhèn jam caq beq!’ ");
INSERT INTO hre_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mòiq ngai au ùh nui wèq dìq ca jàn cô, 'màng aih trap hrìn ca au. ");
INSERT INTO hre_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Tàng Chuaq broq ca au 'màng cô, wa tàng au jah xôq enh ngìa ca Chuaq, xìn jêh đac au yi hnao ca đòiq au hnoq bìac nan xa cô.” ");
INSERT INTO hre_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Chuaq doi ca Môise: “Tagop ca Au 70 ngai, mangai gu craq jàn Is-ra-ên, 'bài mangai ìh ma canao loq wì haq wa mangai broq gàu wèq ngan jàn, ajèn wì trùh Hnem Traiq Cùh Waiq yòng nòi aih ti ìh. ");
INSERT INTO hre_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Hi khoi Au mahno loh capoch tùang nòi aih ca ìh. Au jah yŏc Yiang Au ma ŏi enh 'nhèq ca ìh, èh đòiq Haq enh 'nhèq ca wì haq; èh wì haq wiang genh trap bìac jàn pajùm ca ìh. 'Màng aih, ìh ùh hìaq genh trap mòiq ngai. ");
INSERT INTO hre_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Ìh phai doi ca jàn: ‘Hì da èh pì phai lah crài dađeh loh hadròih, èh pì jah caq jam, ma jah 'màng aih Chuaq i tàng bàu pì doi rai hmoi: Cabô ma am ca nhèn jam caq, ma jah 'màng aih nhèn xùang jò ma ŏi ta Aicàp? Taiq nen aih Chuaq am jam ca pì, èh pì jah caq. ");
INSERT INTO hre_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ùh xài pì caq mòiq hì, baiq hì, padam hì, 10 hì loq 20 hì đòh, ");
INSERT INTO hre_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mahaq trùh mòiq khê, trùh jò leq jam loh enh mùh, èh pì loh ca git, ma jah 'màng aih taiq pì khoi cađac Chuaq ma ŏi ta'ne pì, hmoi enh ngìa ca Haq. Pì doi: “Hagleq ma 'nong nhèn loh enh Aicàp?” ’ ” ");
INSERT INTO hre_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Môise tèu hlài: “Mangai jàn 'nang ŏi ta cô i 600.000 mangai con calô, mahaq Ìh doi: Au am ca jàn cô caq jam hloi mòiq khê. ");
INSERT INTO hre_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","'Màng aih 'nhac ca wì haq ep pàc dŏng dèh 'bo trìu caq men tôm, xôq ùh tôm tàu tàng acom dŏng ca atŏc enh diac raxìq hadai 'màng aih.” ");
INSERT INTO hre_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Chuaq tèu hlài Môise: “Cwìang da Au khoi 'bìq acang 'mòh? Manàiq cô ìh jah hnoq bàu da Au jah loh xìt joq 'nàng loq ùh.” ");
INSERT INTO hre_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","'Màng aih, Môise loh doi ca mangai jàn dìq ca bàu da Chuaq. Haq hadai tagop 70 ngai broq gàu, thê wì yòng ŏi wawenh ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Chuaq mahno loh ta yùc doi ca Môise. Hi khoi Haq am Yiang ca 70 ngai gu craq tìah ca Yiang ŏi ti Môise. Jò Yiang ŏi ti 70 ngai gu craq aih, wì haq loq capoch bàu thai ca Boc Plình. Mahaq bìac cô ùh loh 'màng aih yàng leq hòm. ");
INSERT INTO hre_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Jò aih i baiq ngai gu craq, hiniq wa haq Ênđat wa Mêđat. Wa haq ŏi dèh ta traiq jàn 'nhòq lam trùh ta Hnem Traiq Cùh Waiq. 'Nhac 'màng aih, Yiang hadai ŏi enh 'nhèq ca wa haq, èh wa haq capoch bàu thai ca Boc Plình hloi dèh ta traiq jàn. ");
INSERT INTO hre_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","I mòiq ngai gu radam cadàu lam ta'mon ca Môise: “Ênđat wa Mêđat capoch bàu thai ca Boc Plình ŏi ta traiq jàn!” ");
INSERT INTO hre_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Jôsuê, con calô da Nun, mangai jùp đò Môise, tèu doi: “Ôi Môise, craq au, tàt wì haq beq!” ");
INSERT INTO hre_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Môise tèu: “Ìh tagrình thai ca au 'mòh? Au ma loq enh rìm ngai jàn da Chuaq dìq loq capoch bàu thai ca Boc Plình, wa đòiq am Yiang da Haq enh 'nhèq ca wì haq!” ");
INSERT INTO hre_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Khoi ca aih Môise wa 'bài gu craq hlài dèh ta traiq jàn. ");
INSERT INTO hre_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Chuaq broq cayeo tŏc enh diac raxìq, hlôi 'ràng bàc chìm brŏch trùh clìh dudan ca traiq jàn wa enh kenh ca traiq; enh rìm pah ca traiq jàn i chìm pan hangai dàng mòiq hì lam jènh ta trong, enh 'nhèq ca taneh tenh 2 hagat. ");
INSERT INTO hre_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mangai jàn yòng ti rùp chìm brŏch hì aih enh dahì trùh damang, wa mòiq hì atìq hòm. Mangai leq rùp ma 'biaq xôq jah tenh mòiq ngŏng lìt. Wì haq 'ràng tènh chìm brŏch đòiq broq croh dudan jàp ca traiq jàn. ");
INSERT INTO hre_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Jò jam ŏi raq đeh ta hacùng, 'nhòq manha, èh can nòih da Chuaq loh ca wì haq, broq ca wì haq mòiq hiniq ramòt càn, ");
INSERT INTO hre_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Wì hiniq hloi ca nòi aih: Kiprôt Ha-tha-wa, ma jah 'màng aih wì catùh hanang 'bài mangai i manoh loq ham enh. ");
INSERT INTO hre_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Enh Kiprôt Ha-tha-wa wì haq lam trùh Hat-sê-rôt, khoi èh padài ta aih. ");
INSERT INTO hre_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mi-ri-am wa Arôn capoch 'mèq ca Môise bìac mangai cadrì Ê-thi-ô-bi haq ma yŏc broq mai, ma jah 'màng aih haq yŏc mangai cadrì Cut broq mai. ");
INSERT INTO hre_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Wa aih doi: “Chuaq yŏc mòiq ngai Môise đòiq anoi hlài bàu Haq 'mòh? Boc Plình ùh yŏc bèn đòiq anoi dìq 'mòh?” Chuaq tàng bìac aih. ");
INSERT INTO hre_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Môise mangai i manoh paha'neq dìq jaq, yi hnao dìq ca mangai ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Tajòi 'mòi Chuaq doi ca Môise, Arôn wa Mi-ri-am: “Pì piq ngai lam trùh ta Hnem Traiq Cùh Waiq beq.” Wì haq dì tiaq lam trùh. ");
INSERT INTO hre_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Chuaq mahno ta cato yùc jang 'mang Hnem Traiq Cùh Waiq creo ca Arôn wa Mi-ri-am. Jò wa baiq ngai trùh, ");
INSERT INTO hre_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Haq doi: “Tamàng ma ro bàu Au cô. “Tàng ta pì i mangai leq loq capoch bàu thai ca Boc Plình, cla Au cô Chuaq jah mahno loh ca haq ta bìac jah hnoq. Au doi ca haq jò haq apô. ");
INSERT INTO hre_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Mahaq Môise hapŏng Au ùh xài 'màng aih; haq joq wèq dèh bàu ta dìq ca mangai hnem Au; ");
INSERT INTO hre_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Au hatùang ca haq ùh ep i mangai ta'ne, dìq jaq ro 'ràng, ùh capoch bàu jrùq, haq hadai khoi hnoq chac Chuaq. 'Màng aih, gleq chôp ùh yùq èh hùa capoch 'mèq ca Môise hapŏng Au 'mòh?” ");
INSERT INTO hre_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","'Màng aih can nòih da Chuaq plôh tŏc ca wa baiq ngai, hi khoi Haq loh lam. ");
INSERT INTO hre_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Jò cato yùc tŏc khoi ca Hnem Traiq Cùh Waiq, èh Mi-ri-am loh ca bacùn taboc tìah ca capaih. Arôn tawìh pah Mi-ri-am, hnoq haq khoi loh ca bacùn. ");
INSERT INTO hre_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Arôn doi ca Môise: “Ôi waiq Chuaq au, xìn apaq ta'mòq ca nhèn bìac tôiq ma khoi broq tiaq trong ranhùa. ");
INSERT INTO hre_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Xìn apaq đòiq Mi-ri-am tìah ca con nga ralàih; chac haq khoi om mòiq ha'ne jò clìh dèh enh cliac miq.” ");
INSERT INTO hre_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Môise creo bàu dêh ca Chuaq doi: “Ôi Boc Plình au, xìn Ìh broq brêh ca haq!” ");
INSERT INTO hre_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Chuaq tèu Môise: “Tàng baq haq cachôh ta hadrò haq, èh haq ma ùh ep chìuq camaih trom tapèh hì 'mòh? 'Màng aih haq ep ŏi enh gùng ca traiq jàn tapèh hì, èh khoi ca aih men jah mùt hlài ta traiq jàn.” ");
INSERT INTO hre_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","'Màng aih Mi-ri-am ep 'bìq wèq ŏi mòiq nòi enh gùng ca traiq jàn tapèh hì. Mangai jàn ùh loh lam hòm trùh jò leq Mi-ri-am jah mùt hlài ta traiq jàn. ");
INSERT INTO hre_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Khoi ca bìac aih, mangai jàn loh lam enh Hat-sê-rôt, trùh braih càn Paran, đòiq traiq ŏi nòi aih. ");
INSERT INTO hre_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Ìh thê 'bài mangai lam rinh ngan gùng Ca-na-an beq, gùng Au khoi hùaq am ca jàn Is-ra-ên. Enh rìm hadròng hadrech pì phai thê mòiq ngai ma broq gàu lam.” ");
INSERT INTO hre_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","'Màng aih, Môise thê 'bài cô lam enh braih càn Paran tiaq bàu thê da Chuaq. Dìq ca wì aih mangai broq gàu da jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Cô hiniq 'bài mangai aih: Hadròng hadrech da Rubên, Samua, con calô Xacu. ");
INSERT INTO hre_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Hadròng hadrech Si-mê-ôn, Saphat con calô da Hôri. ");
INSERT INTO hre_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Hadròng hadrech da Juđa, Calep con calô da Jê-phu-neh. ");
INSERT INTO hre_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Hadròng hadrech da I-sa-ca, Igan con calô da Jôsep. ");
INSERT INTO hre_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hadròng hadrech da Ep-ra-im, Hôsê con calô da Nun. ");
INSERT INTO hre_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Hadròng hadrech da Bên-ja-min, Panti con calô da Raphu. ");
INSERT INTO hre_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Hadròng hadrech da Xe-bu-lun, Gat-đi-ên con calô da Sôđi. ");
INSERT INTO hre_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Hadròng hadrech da Jôsep, aih Ma-na-se, Gađi con calô da Susi. ");
INSERT INTO hre_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Hadròng hadrech da Đan, A-mi-ên con calô da Gê-ma-li. ");
INSERT INTO hre_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Hadròng hadrech da Ase, Sêthu, con calô da Mi-ca-ên. ");
INSERT INTO hre_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Hadròng hadrech da Nep-ta-li Nahbi, con calô da Wapsi. ");
INSERT INTO hre_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Hadròng hadrech da Gat, Guên con calô da Maki. ");
INSERT INTO hre_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Aih hiniq 'bài mangai Môise thê lam đòiq rinh ngan gùng Ca-na-an. Môise hiniq ca Hôsê, con calô da Nun, Jôsuê. ");
INSERT INTO hre_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Jò Môise thê wì lam rinh ngan gùng Ca-na-an, haq tanap ca wì, doi: “Pì phai lam gùng Nêghep, khoi èh tŏc ta wang ha'nhèq. ");
INSERT INTO hre_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Khoi èh pì jah ngan gùng aih 'màng leq, mangai jàn gùng aih dêh loq ìuq, bàc loq 'biaq. ");
INSERT INTO hre_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Taneh jàn aih ma ŏi lem loq 'mèq 'màng leq? 'Bài phôq jàn aih ma ŏi 'màng leq, i ca pagia hagao hagình, loq toq nòi tamang đòiq 'bài traiq? ");
INSERT INTO hre_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Taneh 'màng leq, i jìang loq ùh jìang? I hon long loq ùh? Pì phai kech plì long gùng aih ahlài.” Manàiq cô wop jò plì nho ma dùm baxèm. ");
INSERT INTO hre_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","'Màng aih, 'bài mangai aih loh lam rinh ngan ta gùng aih, enh braih càn Xin trùh Rêhôp ta Lêbô Hamat. ");
INSERT INTO hre_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Wì lam cwa gùng Nêghep trùh Hêprôn, nòi i A-hi-man, Sêsai wa Tanmai, con caiq da Anac. 'Màng aih phôq Hêprôn khoi jah broq loh tapèh hanam adroi ca Xôan ta gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Wì haq trùh thòng Êchcôn coh ta aih mòiq hamenh nho i mòiq ayùm plì nho, ep i baiq ngai yŏc long tanòng men nui tòng. Wì haq hadai kech plì ôi rôm wa plì pŏc. ");
INSERT INTO hre_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Wì creo nòi aih thòng da Êchcôn, ma jah 'màng aih i ayùm plì nho jàn Is-ra-ên khoi kech ta aih. ");
INSERT INTO hre_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Wì lam rinh ngan gùng aih 40 hì men hlài. ");
INSERT INTO hre_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Hlài Bu trùh, wì haq lam hloi ti Môise, Arôn wa dìq ca jàn Is-ra-ên ta braih càn Paran ta Cađê, hi anoi hlài rìm bìac ca wì haq wa patô ca wì plì da gùng aih. ");
INSERT INTO hre_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wì anoi hlài ca Môise: “Nhèn lam trùh gùng ìh ma thê nhèn lam. Gùng aih joq gùng taneh bình halùih diac tôh wa diac xùt. Cô plì ta gùng aih. ");
INSERT INTO hre_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mahaq, mangai jàn ŏi ta gùng aih joq tadêh tadon, phôq wì haq càn wa i pagia hagao dìq jaq càn. Nhèn hadai hnoq con caiq da Anac ŏi ta aih. ");
INSERT INTO hre_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Jàn A-ma-lec ŏi ta gùng Nêghep, jàn Hêtit, Jê-bu-xit, wa jàn A-mô-rit ŏi ta wang, jàn Ca-na-an ŏi haten ca diac raxìq wa ti kenh cròng diac Jôđan.” ");
INSERT INTO hre_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Calep thê dìq ca wì hatenh, haq doi: “Bèn phai lam tŏc wa ta'miaq yŏc gùng aih beq, ma jah 'màng aih bèn joq 'nàng jah 'blêq wì haq.” ");
INSERT INTO hre_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mahaq 'bài mangai lam tiaq Calep doi: “Bèn ùh nui ta'blêq ca jàn aih, ma jah 'màng aih wì haq dêh yi hnao ca bèn.” ");
INSERT INTO hre_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","'Bài mangai aih anoi hlài ca jàn Is-ra-ên bàu ùh troq bìac wì haq ma khoi lam rinh ngan gùng aih. Wì haq doi: “Gùng nhèn ma khoi lam rinh ngan, aih gùng ma lŏn cađac con mangai. Dìq dŏng mangai nhèn ma hnoq ta gùng aih, wì haq mangai caiq ca'nhòng. ");
INSERT INTO hre_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nhèn i hnoq mangai ca'nhòng càn, aih 'bài con xau da Anac. Nhèn hadai hnoq mangai Nê-phi-lim, con calô da Anac. Nhèn hnoq dađeh 'yoh tìah ca lìp tùc. Wì haq hnoq nhèn hadai 'màng aih.” ");
INSERT INTO hre_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mang aih dìq dŏng ca jàn cachech bàu dêh rai hmoi. ");
INSERT INTO hre_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Dìq dŏng ca jàn mamùc mamac ca Môise wa Arôn, doi ca wa baiq ngai: “Ngèh ùac nhèn cachìt ta Aicàp loq cachìt ta nòi braih càn cô yi hnao! ");
INSERT INTO hre_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Taiq nen leq Chuaq 'ràng nhèn mùt gùng cô waq ca nhèn cachìt ca chang gùm? Mai wa con 'yoh nhèn èh broq hanùm ca wì. Aleq nhèn khòh hlài dèh ta Aicàp yi hnao!” ");
INSERT INTO hre_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Khoi èh jàn doi ca dabau: “Beq bèn atŏc mòiq ngai đòiq broq gàu, đòiq haq ajèn bèn hlài ta Aicàp.” ");
INSERT INTO hre_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Môise wa Arôn bla-op dađeh enh ngìa ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Jôsuê con da Nun wa Calep con da Jê-phu-neh, baiq ngai hadai khoi lam ti wì ma lam rinh ngan, tajòi 'mòi hich dèh eo. ");
INSERT INTO hre_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Wa baiq ngai doi ca jàn ma tagop: “Gùng nhèn ma khoi lam jàp đòiq rinh ngan, aih joq gùng dìq jaq lem. ");
INSERT INTO hre_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Tàng lem manoh Chuaq, Haq jùp đò bèn, èh Haq 'ràng bèn mùt ta gùng aih đòiq am ca bèn. Aih gùng taneh bình halùih diac xùt wa sùa. ");
INSERT INTO hre_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Pì apaq blàq ca Chuaq, wa hadai apaq crè ca jàn gùng aih, ma jah 'màng aih jàn aih wìa ngè hanùm da bèn. Bìac ma wèq ban wì haq khoi loh đac enh wì haq, wa Chuaq khoi ŏi ti bèn. Apaq yùq cleq.” ");
INSERT INTO hre_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mahaq dìq dŏng ca jàn doi ca dabau phai đàp hmu wa haq. Wop jò aih bìac 'ngah 'ngai da Chuaq mahno loh ta Hnem Traiq Cùh Waiq enh ngìa ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Chuaq doi ca Môise: “Jàn cô ngan Au ùh loh cleq dùnh dàng leq? Wì haq ùh chìuq lùi Au trùh jò leq cô èh, 'nhac ca Au khoi broq bàc bìac halac ta'ne wì haq? ");
INSERT INTO hre_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Au jêh jàn xam mòiq bình ramòt wa raliang đac wì haq. Èh Au broq ca ìh jah wìa mòiq jàn càn wa i can dêh yi hnao ca wì haq.” ");
INSERT INTO hre_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mahaq Môise doi ca Chuaq: “Jàn Aicàp i loq Chuaq khoi yŏc dèh cwìang itai Haq 'ràng jàn cô loh khoi enh wì haq, ");
INSERT INTO hre_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","èh wì anoi hlài bìac aih ca jàn gùng cô. Wì haq khoi tàng Chuaq ŏi ti jàn cô, taiq Chuaq mahno loh ca mat wì haq hnoq, cato yùc Chuaq ŏi enh 'nhèq ca jàn cô, èh Chuaq lam adroi ca wì haq ŏi ta cato yùc dahì wa ŏi ta cato ùnh damang. ");
INSERT INTO hre_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Tàng Chuaq jêh jàn cô mòiq yàng tìah ca jêh mòiq ngai, èh dìq ca Diac ma khoi tàng anoi bìac Chuaq, doi: ");
INSERT INTO hre_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Chuaq ùh jah ajèn jàn cô mùt ta gùng Haq ma khoi hùaq am ca wì haq, taiq nen aih Haq jêh đac wì ta braih càn.’ ");
INSERT INTO hre_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“ 'Màng aih, manàiq cô au xìn cwìang itai da Chuaq mahno loh tìah ca Chuaq ma khoi doi, ");
INSERT INTO hre_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Chuaq ùh renh nòih, mahaq bình halùih can xa-ŏch xam manoh loq waq, loq baxŏng tôiq lôi wa bìac enh tajraq hlài Haq, mahaq ùh doi mangai i tôiq aih ùh i ca tôiq, wa taiq tôiq boc yaq Haq baxa con xau trùh piq pôn 'nhòng.’ ");
INSERT INTO hre_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Au xìn Chuaq baxŏng tôiq ngang dù da jàn cô tiaq dèh can xa-ŏch xam manoh loq waq càn caiq da Chuaq, tìah ca Chuaq ma khoi baxŏng ŏi ta Aicàp trùh manàiq.” ");
INSERT INTO hre_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Chuaq tèu: “Au khoi baxŏng wì haq tìah ca bàu ìh ma xìn. ");
INSERT INTO hre_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mahaq 'màng ca Au ma rìh hloi hloi, èh bìac 'ngah 'ngai da Chuaq jah bình halùih jàp crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Ta rìm ngai ma khoi hnoq 'ngah 'ngai Au, bìac halac Au ma khoi broq ta gùng Aicàp wa ta nòi braih càn, khoi 10 yàng mahaq xôq ùh lùi Au wa ùh tamàng Au, ");
INSERT INTO hre_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","èh ùh i mòiq ngai leq da wì haq jah hnoq gùng Au khoi hùaq thê am ca boc yaq wì haq; ùh i ca mangai leq khoi palèu Au ma jah hnoq gùng aih đòh! ");
INSERT INTO hre_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mahaq taiq hapŏng Au Calep i manoh crài ca wì haq, wa taiq haq dìq dèh ca manoh cliac dì tiaq Au, èh Au 'ràng haq ta gùng haq ma i lam wa ca xinoi haq jah yŏc ŏi gùng aih đòiq broq cùng hang xôxech. ");
INSERT INTO hre_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Jàn A-ma-lec wa jàn Ca-na-an ŏi ta thòng. Hì da èh pì phai tawìh hlài, hi khoi lam trùh braih càn tiaq trong pah Diac Raxìq Gòh.” ");
INSERT INTO hre_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Chuaq doi Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Au ŏi chìuq mangai jàn ngang dù cô mamùc mamac ca Au trùh jò leq? Au khoi tàng bàu mamùc mamac da jàn Is-ra-ên mamùc mamac ca Au. ");
INSERT INTO hre_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Doi ca wì haq: Chuaq doi, ‘Tìah troi ca Au rìh hloi hloi, Au pachac, Au jah broq ca pì tìah troi bàu Au ma khoi tàng pì anoi. ");
INSERT INTO hre_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Èh pì cachìt ta braih càn cô! Taiq pì khoi mamùc mamac ca Au, dìq ca mangai ma enh 20 hanam dang tŏc, aih 'bài mangai khoi rèn hiniq ta sô. ");
INSERT INTO hre_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Joq 'nàng pì ùh jah mùt gùng Au ma khoi pachac am ca pì ŏi, enh gùng ca Calep, con calô da Jê-phu-neh, wa Jôsuê con calô da Nun. ");
INSERT INTO hre_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mahaq Au 'ràng mùt ta gùng aih 'bài con caiq da pì, aih con caiq pì ma doi èh 'bìq broq hanùm am ca wì ta gùng aih. Hi khoi wì haq jah mùt gùng pì ma khoi ùh enh. ");
INSERT INTO hre_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mahaq khoi èh 'bài hanang pì jah catùh ta braih càn cô. ");
INSERT INTO hre_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Taiq tôiq pì ma ùh wèq dèh bàu, con caiq pì èh ban trìu ta nòi braih càn hloi 40 hanam, trùh jò leq dìq ca pì cachìt dŏng ta braih càn. ");
INSERT INTO hre_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Tiaq hì pì lam rinh ngan gùng, aih 40 hì, èh pì hadai pòq bìac baxa taiq tôiq ngang dù dađeh sôq hanam toq aih, aih 40 hanam; mòiq hanam đèn ca mòiq hì; jò aih pì jah loq Au khoi tajraq hlài ca pì.’ ");
INSERT INTO hre_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Au cô Chuaq, khoi doi, èh Au broq bìac cô dìq ca jàn ngang dù cô ma khoi tagop dabau đòiq tajraq hlài ca Au. Èh dìq ca wì haq cachìt ta braih càn cô.” ");
INSERT INTO hre_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","'Bài mangai Môise ma khoi thê lam rinh ngan gùng Ca-na-an hlài, èh broq ca jàn mamùc mamac ca Môise, taiq wì haq capoch 'mèq ca gùng, ");
INSERT INTO hre_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ji wì aih 'bìq mòiq hiniq ranàc 'mèq baxa cachìt enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mahaq ta 'bài mangai ma lam rinh ngan gùng, toq Jôsuê, con da Nun, wa Calep, con da Jê-phu-neh jah rìh. ");
INSERT INTO hre_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Jò Môise anoi bàu cô ca jàn Is-ra-ên, wì haq crò hmoi dìq jaq. ");
INSERT INTO hre_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Xrŏih xroq hì atìq, mangai jàn heo tŏc ta bôi wang. Wì haq doi: “Nhèn khoi broq tôiq, mahaq cô èh nhèn lam tŏc trùh nòi Chuaq ma khoi hùaq.” ");
INSERT INTO hre_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Èh Môise doi: “Gleq pì ma ŏi rahen hlài ca bàu Chuaq? Broq 'màng aih pì ùh ta'blêq, èh bàc bìac ùh lem trùh ca pì. ");
INSERT INTO hre_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Apaq tŏc ta aih, èh pì 'bìq lình wì jêh đac, ma jah 'màng aih Chuaq pi ŏi ta'ne pì hòm. ");
INSERT INTO hre_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Jàn A-ma-lec wa jàn Ca-na-an ŏi enh ngìa ca pì, pì 'bìq wì haq jêh đac xam chang gùm, ma jah 'màng aih pì tajraq hlài ca Chuaq, 'màng aih, Chuaq pi ŏi ti pì.” ");
INSERT INTO hre_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mahaq mangai jàn xôq dì dèh manoh tŏc ta bôi wang, 'nhac ca hom wêh jao da Chuaq wa Môise ùh loh lam khoi enh traiq jàn. ");
INSERT INTO hre_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Jàn A-ma-lec wa jàn Ca-na-an ŏi ta wang cô hadrùc loh jêh rai hnan đac wì haq cadàu trùh Hotma. ");
INSERT INTO hre_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Doi ca jàn Is-ra-ên: ‘Jò pì mùt ta gùng Au ma am ca pì đòiq pì hi ŏi, ");
INSERT INTO hre_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","pì phai am ca Chuaq ngè tadreo bùh xam ùnh đòiq broq gêh bìac khoi pachac loq ngè tadreo bùh to am, loq ngè dèch am ta hì lè càn. Pì jah yŏc ngè am enh calùh 'bo, calùh trìu loq calùh bubi. ");
INSERT INTO hre_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Jò pì dèch am dèh ngè tadreo aih, pì hadai phai am ngè tadreo dèch am xam 'mau mì xam baiq lìt dàc 'yêh, alôn mòiq lìt dàu. ");
INSERT INTO hre_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Tàng broq ngè tadreo bùh xam mòiq toq trìu con, loq ngè tadreo ma 'noiq, èh hadai phai am mòiq lìt alac đòiq broq lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Tàng am mòiq toq con trìu calô, èh phai dèch am ngè tadreo xam 'mau mì, pôn lìt dàc 'yêh alôn ta 1 lìt 'ne dàu, ");
INSERT INTO hre_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","wa 1 lìt 'ne alac broq lè dèch am dahwèq ôq đòiq atŏc am i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Jò broq ngè tadreo bùh xam 'bo calô am ca Chuaq, loq dèch am ngè tadreo ma 'noiq đòiq broq gêh pachac, loq ngè dèch am waiq catèm, ");
INSERT INTO hre_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","èh phai am pajùm ti 'bo aih xam ngè tadreo dèch am xam 'mau mì tadràu lìt đac 'yêh alôn ti 2 lìt dàu, ");
INSERT INTO hre_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","èh hadai am baiq lìt alac broq lè dèch am dahwèq ôq, aih mòiq ngè tadreo yŏc ùnh am atŏc i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Wì haq hadai phai broq 'màng aih ca rìm toq 'bo calô, rìm toq trìu calô, loq rìm toq bubi con. ");
INSERT INTO hre_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Tiaq dèh pì padon ngè tadreo am, èh phai broq 'màng aih ca rìm toq. ");
INSERT INTO hre_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Rìm ngai jàn Is-ra-ên phai broq 'màng aih, jò leq am ngè tadreo yŏc ùnh bùh, i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Tàng i mangai jàn 'noiq lam hmàih loq rìh ŏi ta'ne pì, èh enh am ngè tadreo bùh atŏc hòi xua thùm ca Chuaq, haq phai broq tìah ca pì ma broq aih. ");
INSERT INTO hre_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Toq i mòiq toq ranenh aih raq am ca jàn Is-ra-ên, wa jàn 'noiq hadai broq troi pì hloi hloi. ");
INSERT INTO hre_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Phai i mòiq toq ranenh wa mòiq trong hatìah ca dabau ca pì wa mangai jàn 'noiq ŏi ta'ne pì hadai.’ ” ");
INSERT INTO hre_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Doi ca jàn Is-ra-ên: ‘Jò leq pì mùt ta gùng Au ma ajèn 'ràng pì mùt, ");
INSERT INTO hre_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","jò leq caq dahwèq caq da gùng aih, èh pì phai broq mòiq ngè tadreo dèch am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Pì phai yŏc mòiq toq 'benh 'yoh broq ngè tadreo, aih 'benh baxèm enh dàc da pì broq ngè am enh xàn pêh 'mau dèch atŏc. ");
INSERT INTO hre_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","'Màng aih enh 'nhòng cô trùh tau pì phai dech am ca Chuaq mòiq ngè tadreo xam dàc 'yêh baxèm da pì. ");
INSERT INTO hre_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Jò pì troq lò broq tôiq, ùh wèq rìm bàu ta ranenh Au khoi anoi ca Môise, ");
INSERT INTO hre_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","aih rìm bìac leq Chuaq khoi canòm ca Môise anoi ca pì enh hì Chuaq ma khoi anoi 'noh ranenh cô trùh manàiq, wa hloi 'nah ta atìq cô èh. ");
INSERT INTO hre_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Tàng tôiq taiq troq lò, mangai jàn ùh 'nì, èh dìq dŏng ca jàn tiaq dèh ranenh phai yŏc mòiq toq 'bo calô dèch am atŏc broq ngè tadreo bùh i hòi xua thùm ca Chuaq, pajùm ti ngè am 'mau mì xam lè dèch am dahwèq ôq tiaq ranenh, wa mòiq toq bubi calô broq ngè tadreo rŏt dèch hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Hi khoi pajàu phai broq lè rŏt dèch hlài enh tôiq lôi ca dìq ca jàn Is-ra-ên, èh tôiq mangai jàn jah baxŏng, ma jah 'màng aih tôiq taiq troq lò, ma wì khoi 'ràng trùh enh ngìa ca Chuaq ngè tadreo bùh xam ùnh, wa ngè tadreo rŏt dèch hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Dìq ca jàn Is-ra-ên wa mangai jàn 'noiq ŏi ti pì jah baxŏng tôiq, ma jah 'màng aih dìq ca mangai khoi broq tôiq troq lo aih. ");
INSERT INTO hre_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Mahaq tàng toq mòiq ngai raq troq lò broq tôiq, èh mangai aih phai am mòiq toq bubi cadrì mòiq hanam đòiq broq ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Pajàu phai broq lè tadreo rŏt hlài enh tôiq lôi broq ca mangai aih jah hadròih, èh mangai aih jah baxŏng. ");
INSERT INTO hre_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ranenh cô broq ca mangai troq lò broq tôiq, 'nhac ca mangai Is-ra-ên loq mangai jàn 'noiq hadai. ");
INSERT INTO hre_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Mahaq tàng i mangai leq to broq tôiq, 'nhac ca mangai Is-ra-ên loq mangai jàn 'noiq ŏi ti wì haq, èh mangai aih phai 'bìq hnan cađac khoi dèh ca jàn, ma jah 'màng aih, mangai aih khoi capoch ha'nhèq đùng Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Ma jah 'màng aih haq khoi cađac bàu Chuaq wa broq ùh troq ca bàu thê da Haq. Mangai aih phai 'bìq hnan 'noh đac enh jàn cla. Haq phai chìuq baxa taiq tôiq dađeh.’ ” ");
INSERT INTO hre_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","'Màng aih, jò jàn Is-ra-ên 'nang ŏi ta braih càn, wì haq hnoq mòiq ngai tŏch long ùnh ta Hì Sabat. ");
INSERT INTO hre_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Wì ma hnoq haq 'nang tŏch long ùnh ajèn haq trùh ca Môise, Arôn wa dìq dŏng ca jàn. ");
INSERT INTO hre_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Wì clêh haq taiq 'nhòq 'nì ro phai hadrah bìac cô. ");
INSERT INTO hre_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Chuaq doi ca Môise: “Mangai cô phai cachìt. Dìq ca jàn phai tèm hmu haq enh gùng ca traiq jàn.” ");
INSERT INTO hre_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","'Màng aih dìq ca jàn 'ràng haq loh enh gùng ca traiq jàn, tèm haq xam hmu trùh cachìt, tìah ca Chuaq khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Ìh phai doi ca jàn Is-ra-ên: ‘Dìq ca 'nhòng cô trùh 'nhòng tau phai broq mòiq toq caxi ta ha'mai rìm mùm da eo, wa ta'mùt mòiq toq hadrang caxi nhum xenh. ");
INSERT INTO hre_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Jò pì hnoq caxi aih, èh pì jah hmàng dŏng dìq ranenh da Chuaq đòiq broq tiaq, ùh broq tiaq dèh manoh ma hèm enh, èh broq manhài trài. ");
INSERT INTO hre_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","'Màng aih đòiq ca pì jah hmàng hlài wa broq tiaq bàu thê da Au, wa broq hadròih ca Chuaq Boc Plình da pì. ");
INSERT INTO hre_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Au cô Chuaq Boc Plình da pì, Haq ma khoi 'ràng pì loh khoi enh gùng Aicàp đòiq broq Boc Plình da pì. Au cô Chuaq Boc Plình pì.’ ” ");
INSERT INTO hre_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Côra, con calô Ixha, xau Kêhat, con xau da Lêwi wa toq biaq ngai Rubên, aih Đathan wa A-bi-ram con calô Ê-li-ap, Ôn, con calô da Phêlêt, xau Rubên, ");
INSERT INTO hre_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","adràc dabau yòng tajraq hlài ca Môise. Lam tiaq wì haq i 250 ngai Is-ra-ên, aih gu craq wèq cwìang i 'bang tìang ta jàn, khoi lah broq bìac ta nòi tagop gu craq ma wèq cwìang. ");
INSERT INTO hre_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Wì haq tagop dabau tajraq hlài ca Môise wa Arôn. Wì doi ca wa: “Chôp joq hrìn hran dìq jaq! Dìq ca jàn hadròih wa Chuaq 'nang ŏi ti rìm ngai ti wì haq, 'màng aih gleq chôp ma doi dađeh i cwìang enh 'nhèq ca jàn da Chuaq?” ");
INSERT INTO hre_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Jò Môise tàng bàu aih, haq hacùn cràng bla-op ta taneh. ");
INSERT INTO hre_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Haq doi ca Côra wa dìq ca mangai pajùm ti Côra: “Xroq èh, Chuaq jah mahno loq mangai leq mangai da Haq, wa mangai leq hadròih, èh 'ràng haq trùh haten ca Haq, aih mangai leq Haq ràih, Haq jah 'ràng trùh haten ca Haq. ");
INSERT INTO hre_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ìh, Côra wa dìq ca mangai ma tiaq ìh phai wê abôq jreo xua thùm. ");
INSERT INTO hre_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Hì da èh enh ngìa ca Chuaq, phai tah ùnh wa jreo xua thùm. Mangai leq Chuaq ràih, aih mangai hadròih. Cla pì mangai Lêwi khoi padèch dađeh broq bìac dìq jaq ùh troq!” ");
INSERT INTO hre_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Môise hadai doi tam ca Côra: “Ôi pì con xau Lêwi, tamàng cô oq: ");
INSERT INTO hre_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Boc Plình da Is-ra-ên, khoi ràih crài pì khoi ca mangai jàn Is-ra-ên wa 'ràng pì trùh haten ca Haq đòiq patìh ta Hnem Traiq Cùh Waiq da Chuaq wa đòiq pì yòng enh ngìa ca jàn wa patìh wì haq. Bìac aih 'nhòq tôm 'mòh? ");
INSERT INTO hre_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Haq khoi 'ràng ìh wa dìq dŏng oh daq mangai Lêwi trùh haten ca Haq, 'màng aih manàiq pì ca doi enh ta'miaq yŏc bìac broq da pajàu broq gàu hòm! ");
INSERT INTO hre_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","'Màng aih, ìh wa dìq ca mangai ma tiaq ìh khoi pajùm ti dabau đòiq tajraq hlài ca Chuaq. Arôn cabô pì ma mamùc mamac enh tajraq hlài ca haq?” ");
INSERT INTO hre_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Khoi ca aih, Môise thê mangai lam doi ca Đathan wa A-bi-ram, baiq ngai con calô da Ê-li-ap trùh, mahaq wa tèu: “Ma ùh lam đòh. ");
INSERT INTO hre_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ìh khoi 'nong nhèn loh khoi enh nòi gùng taneh bình halùih diac xùt wa sùa, đòiq jêh đac nhèn ta nòi braih càn, 'màng aih ma 'nhòq tôm? Manàiq ìh enh wèq cwìang enh 'nhèq ca nhèn hòm 'mòh? ");
INSERT INTO hre_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ìh joq 'nàng ùh 'ràng nhèn mùt ta gùng taneh bình halùih diac xùt wa sùa, wa joq 'nàng ùh am ca nhèn jah nhàn taneh wia nho broq xôxech! Ìh enh 'bacsi mat 'bài mangai aih 'mòh? Ùh, nhèn ùh tŏc đòh?” ");
INSERT INTO hre_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Môise nòih dìq jaq, doi ca Chuaq: “Xìn apaq nhàn ngè tadreo wì haq. Au ùh i yŏc da wì haq mòiq toq lùa, hadai ùh jò leq broq 'mèq ca mangai leq ta wì.” ");
INSERT INTO hre_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Môise doi ca Côra: “Hì da èh, ìh wa dìq ca mangai ma tiaq ìh xam Arôn, phai patô dađeh enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Rìm ngai phai wê dèh abôq bùh xreo xua thùm, tah jreo xua thùm ta aih, hi khoi dèch enh ngìa ca Chuaq, aih dìq dŏng 250 abôq jreo xua thùm. Ìh wa Arôn hadai wê dèh abôq bùh jreo xua thùm.” ");
INSERT INTO hre_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","'Màng aih, rìm ngai dìq wê abôq tah jreo xua thùm, tah ùnh wa jreo xua thùm ta aih, hi khoi yòng ti Môise wa Arôn jang 'mang Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Jò Côra tagop dìq dŏng ca mangai ma tiaq dađeh tajraq hlài ca Môise wa Arôn, jang 'mang Hnem Traiq Cùh Waiq đòiq hatình, 'ngah 'ngai lem lình da Chuaq mahno loh ca dìq dŏng jàn tagop. ");
INSERT INTO hre_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Chuaq doi ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Chôp wia khoi ca jàn tagop cô beq, đòiq Au jêh đac wì haq manàiq cô raq.” ");
INSERT INTO hre_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mahaq Môise wa Arôn bla-op dađeh ta taneh dang xìn: “Waiq Boc Plình! Boc Plình yiang da con mangai, taiq mòiq ngai broq tôiq, mahaq Chuaq nòih dìq dŏng ca jàn tagop 'mòh?” ");
INSERT INTO hre_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Doi ca jàn tagop: Wia hangai ca traiq Côra, Đathan wa A-bi-ram beq.” ");
INSERT INTO hre_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Môise padinh yòng cadàu tùh pah Đathan wa A-bi-ram; tiaq atìq i 'bài craq da jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Haq doi ca jàn tagop: “Wia ma hangai ca traiq 'bài mangai ma ngang dù cô beq, apaq đùng trùh ngè cleq da wì haq, èh yùq pì dìq dŏng hadai cachìt taiq tôiq lôi wì haq 'mòh?” ");
INSERT INTO hre_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","'Màng aih jàn wia hangai ca traiq Côra, Đathan wa A-bi-ram. Adroi ca aih Côra, Đathan wa A-bi-ram yòng dèh jang 'mang traiq dèh ti cadrì con xam 'bài con 'yoh. ");
INSERT INTO hre_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Môise doi: “Nhò bìac cô èh pì jah loq Chuaq thê Au broq bìac aih ùh xài au tiaq manoh cla au. ");
INSERT INTO hre_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Mahaq tàng wì 'mat cachìt đeh troi con mangai ma cachìt, aih Chuaq ùh ràih au. ");
INSERT INTO hre_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mahaq tàng Chuaq broq mòiq bìac neo, wa taneh hah hacùng lŏn dŏng wì, wa dìq dŏng ngè bìac da wì haq, wa wì haq ŏi rìh mahaq loh ta ralùng hanang, èh pì loq 'bài mangai cô khoi ngan Chuaq ùh loh cleq.” ");
INSERT INTO hre_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Môise doi bu gêh bàu aih, taneh jang jènh wì haq loh ca hađah; ");
INSERT INTO hre_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","hah hacùng lŏn wì haq wa cadrì con wì haq, wa dìq ca 'bài mangai ma tiaq Côra wa dìq dŏng ca cùng hang wì haq. ");
INSERT INTO hre_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Wì haq ŏi raq rìh mahaq loh ta ralùng hanang wa dìq ca cùng hang da wì haq. Taneh catùh hlài wa wì haq cachìt. Wì haq 'bìq jêh đac dèh 'ne jàn dađeh. ");
INSERT INTO hre_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Tàng bàu wì haq cachech, dìq dŏng ca jàn Is-ra-ên ma ŏi kenh aih cadàu mot dŏng wa crè tarìt doi: “Taneh hadai padon lŏn bèn!” ");
INSERT INTO hre_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","I mòiq pla ùnh enh Chuaq plôh loh bùh cachìt 250 ngai 'nang bùh dèch am jreo xua thùm. ");
INSERT INTO hre_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Doi ca Ê-li-a-xa mangai pajàu, con calô da Arôn, tŏch dŏng dìq abôq jreo xua thùm loh khoi ca nòi ùnh ma cheo, èh hadai haprah hapriang chah 'nang cheo aih, taiq abôq jreo xua thùm aih khoi hadròih. ");
INSERT INTO hre_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","“Phai yŏc 'bài abôq broq xam đùng tah jreo xua thùm da 'bài mangai ma khoi broq tôiq ma 'bìq cachìt, yŏc tamoh tùq ratang 'bài abôq aih, broq loh 'bài capiac đòiq lom ca'bŏng tadreo, ma jah 'màng aih 'bài abôq aih khoi jah am tŏc enh ngìa ca Chuaq wa khoi hadròih. Đòiq 'bài capiac aih broq mòiq teo bahmàng hlài ca jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","'Màng aih, pajàu Ê-li-a-xa tŏch 'bài abôq broq xam đùng tah jreo xua thùm da 'bài mangai khoi cachìt, hi khoi yŏc tamoh tùq ratang đòiq lom ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Aih mòiq bìac đòiq bahmàng hlài ca jàn Is-ra-ên, đòiq tanap 'bài mangai enh gùng ca xinoi Arôn ùh jah trùh haten bùh jreo xua thùm enh ngìa ca Chuaq, èh yùq loq cachìt pajùm ti Côra wa 'bài mangai ma tiaq haq. ");
INSERT INTO hre_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Hì atìq, dìq dŏng ca 'bài jàn mamùc mamac tajraq hlài ca Môise wa Arôn, doi: “Chôp khoi jêh đac jàn da Chuaq!” ");
INSERT INTO hre_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Jò mangai jàn 'nang tagop dabau đòiq tajraq hlài ca Môise wa Arôn, wì tawìh hlài ngan Hnem Traiq Cùh Waiq, hnoq tajòi 'mòi i yùc glàp traiq wa can 'ngah 'ngai lem lình da Chuaq mahno loh. ");
INSERT INTO hre_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Môise wa Arôn lam yòng enh ngìa ca Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Wia hangai ca jàn cô, Au jêh đac wì manàiq cô raq!” Môise wa Arôn bla-op ta taneh. ");
INSERT INTO hre_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Môise doi ca Arôn: “Ìh wê abôq tah jreo xua thùm, hi khoi yŏc ùnh enh ca'bŏng tadreo, lam ma renh trùh ŏi ta'ne jàn ma tagop, đòiq broq lè rŏt hlài enh tôiq lôi da wì haq, ma jah 'màng aih Chuaq khoi nòih wa 'bình da can cachìt khoi baxèm.” ");
INSERT INTO hre_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","'Màng aih Arôn broq tiaq bàu Môise ma tanap ca haq, cadàu mùt yòng ta'ne jàn taiq can hinìq ramòt khoi baxèm ta'ne jàn. 'Màng aih, Arôn dèch jreo xua thùm đòiq rŏt hlài tôiq lôi da wì haq. ");
INSERT INTO hre_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Arôn yòng ŏi ta'ne mangai cachìt wa mangai rìh, 'màng aih can hinìq ramòt khoi jah tàt. ");
INSERT INTO hre_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Mahaq 14.700 ngai khoi cachìt ta can hinìq ramòt aih enh gùng ca 'bài mangai ma khoi cachìt tiaq Côra. ");
INSERT INTO hre_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Jò aih Arôn tawìh hlài ta Môise jang 'mang Hnem Traiq Cùh Waiq, ma jah 'màng aih can hinìq ramòt pi i hòm. ");
INSERT INTO hre_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Khoi ca aih Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Doi ca 'bài mangai ma broq gàu da rìm hadròng hadrech, thê wì 'ràng mòiq toq long canhra, aih 12 toq long canhra da 'bài mangai ma broq gàu da rìm hadròng hadrech. ");
INSERT INTO hre_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ìh phai achìh hiniq da rìm tàng ngai broq gàu, jang long canhra, mahaq achìh hiniq Arôn jang long canhra da Lêwi, ma jah 'màng aih, rìm tang ngai ma broq gàu ta hadròng hadrech i mòiq ngai mòiq toq long canhra. ");
INSERT INTO hre_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ìh phai đòiq 'bài long canhra aih ta Hnem Traiq Cùh Waiq, enh ngìa ca hom wêh jao, nòi Au glàm ìh. ");
INSERT INTO hre_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Long canhra da mangai Au ma ràih, èh jah plôh riang. 'Màng aih mangai jàn pi i ca nen cleq đòiq mamùc mamac ca ìh hòm.” ");
INSERT INTO hre_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Môise doi ca Is-ra-ên wa 'bài mangai ma broq gàu, tiaq dèh hadròng hadrech dađeh dì tiaq bàu tanap, 'ràng am ca haq long canhra dađeh. ");
INSERT INTO hre_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Môise 'ràng don đòiq 12 toq long canhra enh ngìa ca Chuaq ta Hnem Traiq Cùh Waiq. Long canhra da Arôn ŏi ta'ne ca 'bài long canhra ma 'noiq. ");
INSERT INTO hre_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Hì da èh jò Môise mùt ta Hnem Traiq Cùh Waiq, haq hnoq long canhra da Arôn, thai ca xinoi da Lêwi, khoi loh riang, loh plì, i clong apriac khoi dùm. ");
INSERT INTO hre_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Môise 'ràng 'bài long canhra enh Hnem Traiq Cùh Waiq loh am ca rìm ngai ngan. Wì hamàih, èh wì ma broq gàu aih yŏc ahlài dèh long canhra. ");
INSERT INTO hre_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Mahaq Chuaq doi ca Môise: “ 'Ràng hlài long canhra da Arôn đòiq enh ngìa ca hom wêh jao, đòiq broq teo bahmàng jàn ca bìac yòng blàq hlài cô, đòiq wì haq ùh hìaq cachìt taiq bìac aih wa pi jò leq mamùc mamac ca Au hòm?” ");
INSERT INTO hre_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Môise broq tiaq bàu aih: ");
INSERT INTO hre_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Mangai Is-ra-ên yùq crè doi ca Môise: “Cô nhèn 'bìq jêh đac! Nhèn đang ca cachìt! Nhèn cachìt dŏng dìq! ");
INSERT INTO hre_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Tàng mangai leq trùh haten ca Hnem Traiq Cùh Waiq, èh dìq cachìt 'màng aih, èh nhèn cachìt dŏng 'mòh?” ");
INSERT INTO hre_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Chuaq doi ca Arôn: “Ìh, 'bài con calô ìh wa xinoi ìh phai pòq bìac broq ma ùh troq nòi hadròih, hadai 'màng aih, ìh wa 'bài con calô ìh phai pòq tôiq ca bìac broq pajàu. ");
INSERT INTO hre_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","'Ràng dìq dŏng mangai hadròng hadrech da Lêwi, xinoi ìh, đòiq wì haq patìh ti ìh, mahaq toq ìh wa 'bài con calô ìh jah patìh ta Nòi Hadròih. ");
INSERT INTO hre_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","'Bài mangai Lêwi ma 'noiq phai broq gêh dìq ca bìac ìh ma thê wì haq broq ta dìq ca traiq, mahaq wì haq ùh jah trùh haten ca ngè ta Nòi Hadròih wa ca'bŏng tadreo, đòiq wì haq wa ìh ùh hìaq cachìt. ");
INSERT INTO hre_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Wì haq pajùm ti ìh patìh bìac ta Hnem Traiq Cùh Waiq, wa dìq dŏng bìac broq ta traiq, mahaq mangai 'noiq ùh i cwìang trùh haten ca pì. ");
INSERT INTO hre_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Pì ep ngan wèq bìac cleq ma ŏi ta Nòi Hadròih wa enh ngìa ca ca'bŏng tadreo đòiq ùh hìaq i can nòih da Au loh ca jàn Is-ra-ên hòm. ");
INSERT INTO hre_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Au khoi ràih mangai Lêwi ta jàn Is-ra-ên, lah crài am ca Chuaq. Au jao wì haq ca ìh đòiq wiang ti ìh patìh ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Au hadai jao ca ìh bìac broq da mangai pajàu, toq ìh wa 'bài con ìh broq bìac cô enh ngìa ca'bŏng tadreo wa enh trom ca bai prình. Mangai leq enh gùng trùh haten, èh phai 'bìq jêh cachìt.” ");
INSERT INTO hre_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Chuaq doi tam ca Arôn: “Enh gùng ca aih Au am ca pì dìq ca ngè tadreo da mangai Is-ra-ên ma am tiaq troi ranenh dèch tì am enh ngìa ca Chuaq. Dìq ca ngè hadròih aih ngè da ìh wa con calô ìh. Aih ranenh cajap jah wèq hloi hloi. ");
INSERT INTO hre_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Enh gùng ca ngè bùh ta ùnh am atŏc, phàn da ngè tadreo dèch am xam 'mau mì, ngè rŏt hlài enh tôiq, wa ngè tadreo rŏt hlài enh lôi, dìq jah ìh wa 'bài con calô ìh. ");
INSERT INTO hre_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Aih ngè dìq jaq hadròih, ìh phai caq ta nòi hadròih toq gu calô ma jah caq. ");
INSERT INTO hre_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Hi khoi ngè tadreo jah am atŏc tiaq dua am lam am hlài hadai jah ìh, mahaq ngè aih rìm ngai ta hnem, dìq jah caq ùh kè cadrì calô, tàng wì haq hadròih. ");
INSERT INTO hre_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Au am ca ìh phàn ma lem dìq jaq da dàu, alac neo wa 'mau mì, dìq dŏng ngè tadreo gàu mùa, wì ma 'ràng am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Au hadai am ca ìh dìq dŏng plì dùm lem baxèm ta đùng taneh ma wì 'ràng dèch am ca Au, rìm ngai leq ma hadròih ta hnem ìh jah caq. ");
INSERT INTO hre_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ 'Màng aih dìq dŏng rìm bìac mangai Is-ra-ên am ca Au, dìq jah ìh, xam 'bài con ramua calô, wa 'bài ngè aban ma ramua da wì haq. ");
INSERT INTO hre_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Mahaq, con ramua calô, wa con ramua da ngè aban ma ùh hreo, èh phai rŏt hlài. ");
INSERT INTO hre_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Jò wì haq jah mòiq khê, èh jah rŏt hlài, da-adàng ca padam hliac 'bac tiaq dèh ca jaq siêclò nòi hadròih. ");
INSERT INTO hre_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Mahaq con ramua da 'bo, trìu wa bubi, ùh jah rŏt hlài, ma jah 'màng aih, wì haq khoi jah ràih hadròih. Phai yŏc mahem wì haq da'rat ta ca'bŏng tadreo, yŏc ramaq 'ràng bùh, aih mòiq ngè tadreo yŏc ùnh am atŏc i hòi xua thùm lem manoh Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Jam da 'bài ngè tadreo cô jah dŏng ìh, yi hnao hòm, aih rada am lam am hlài, wa cataih pah 'ma. ");
INSERT INTO hre_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Au am ca ìh dìq ngè tadreo hadròih da mangai Is-ra-ên, aih ngè tiaq ranenh dèch tì am tŏc enh ngìa ca Chuaq. Rìm ngai ta hnem ìh, gu cadrì gu calô, dìq jah caq. Cô mòiq wêh jao xam boh hloi hloi, ùh jah halìh, enh ngìa ca Chuaq, am ca ìh wa xinoi ìh.” ");
INSERT INTO hre_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Hi khoi Chuaq doi tam ca Arôn: “Ìh ùh jah i taneh đòiq broq xôxech; ìh hadai ùh i ca phàn leq ta Is-ra-ên. Au cô da ìh, xôxech ìh ta'ne wì haq. ");
INSERT INTO hre_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Dìq dŏng mòiq phàn mòiq jàt, jàn Is-ra-ên ma khoi am ca Au, Au am ca mangai Lêwi, ma jah 'màng aih, wì haq khoi patìh bìac ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Pàng cô ta èh, mangai Is-ra-ên ùh i mangai leq jah mùt ta Hnem Traiq Cùh Waiq, đòiq ùh hìaq pòq tôiq wa ùh hìaq cachìt. ");
INSERT INTO hre_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Toq mangai Lêwi jah patìh broq bìac ta Hnem Traiq Cùh Waiq. Tàng wì broq tôiq, wì haq pòq dèh tôiq. Aih ranenh hloi hloi ta 'nhòng pì, mangai Lêwi ùh jah i xôxech cleq ta jàn Is-ra-ên, ");
INSERT INTO hre_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","taiq Au khoi am ca wì mòiq phàn mòiq jàt dahwèq ma mangai Is-ra-ên am ca Chuaq. 'Màng aih, Au khoi doi ca wì, mangai Lêwi ùh jah i xôxech ta'ne mangai jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Chuaq hadai doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Ìh doi ca mangai Lêwi: ‘Jò jah nhàn mòiq phàn mòiq jàt da jàn Is-ra-ên, Chuaq ma am ca wì haq aih, èh wì haq ep yŏc hlài mòiq phàn mòiq jàt ta mòiq phàn mòiq jàt aih, dèch am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ngè cô èh jah ngan tìah ca ngè 'mau mì enh xàn ma len 'mau, tìah ca alac nho yŏc enh nòi padit plì nho broq alac da wì haq. ");
INSERT INTO hre_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","'Màng aih dìq ca mòiq phàn mòiq jàt pì ma khoi nhàn enh Is-ra-ên, pì phai yŏc mòiq phàn mòiq jàt enh aih hòm đòiq broq ngè dèch am ca Chuaq, èh pì phai am ngè aih ca pajàu Arôn. ");
INSERT INTO hre_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ta dìq dŏng ngè pì ma jah, pì ngan ma leq ma yi lem dŏng dìq đòiq am atŏc ca Chuaq. Aih phàn đòiq crài hadròih ca Chuaq.’ ");
INSERT INTO hre_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Ìh ep doi ca mangai Lêwi: ‘Jò leq oh daq khoi dèch am dèh phàn ma yi lem, èh phàn ma ŏi i aih dahwèq enh xàn len 'mau wa apao padit yŏc diac nho. ");
INSERT INTO hre_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Phàn ma ŏi hlài cô, pì wa cadraq pì jah caq, ùh kè ca jang leq, aih cùng baha ca bìac oh daq ma khoi patìh ta Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Tàng pì am atŏc phàn ma yi lem ca Chuaq, èh pì hadai ùh i ca tôiq cleq jò caq đeh phàn ma ŏi rah. Mahaq jò pì am atŏc ca Chuaq phàn ma yi lem adroi ca pì caq, pì ùh pòq tôiq cleq ca ngè hadròih da jàn Is-ra-ên wa ùh hìaq cachìt.’ ” ");
INSERT INTO hre_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Chuaq doi ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Cô bìac ta ranenh da Chuaq khoi thê: Mangai Is-ra-ên phai ràih mòiq toq 'bo cadrì xàc gòh ùh i ca teo xìt leq 'nhòq bac long ech. ");
INSERT INTO hre_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","'Ràng 'bo aih ca pajàu Ê-li-a-xa. Pajàu Ê-li-a-xa 'ràng 'bo aih loh enh gùng ca traiq, pàc 'bo aih enh ngìa ca pajàu. ");
INSERT INTO hre_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Pajàu Ê-li-a-xa yŏc hadrang tì 'nhrùq ta mahem 'bo aih, da'rat tapèh yàng 'nah pah Hnem Traiq Cùh Waiq. ");
INSERT INTO hre_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Èh pajàu phai ngan wì ma bùh 'bo aih: Akia, xech, mahem wa ìch haq. ");
INSERT INTO hre_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Pajàu khòh yŏc long hùang nam, long xônh wa brai gòh tèm 'mùt ta 'bo ma 'nang cheo. ");
INSERT INTO hre_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Khoi ca aih, pajàu phai rùh dèh eo wa hùm, hi khoi men jah mùt ta traiq, mahaq 'bìq amùa trùh xèq hì aih. ");
INSERT INTO hre_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Mangai ma bùh 'bo aih hadai phai rùh dèh eo cwàn, hùm wa 'bìq amùa trùh xèq hì aih. ");
INSERT INTO hre_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Mòiq ngai lem hreo acom blo da 'bo bùh aih, 'ràng tah đòiq ta mòiq nòi lem hreo enh gùng ca traiq jàn. Mangai Is-ra-ên jah wèq blo cô, èh tah ta diac đòiq diac aih broq hreo ca amùa! Aih ngè tadreo rŏt hlài enh tôiq lôi. ");
INSERT INTO hre_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Mangai ma acom blo aih phai rùh eo wa 'bìq amùa trùh xèq hì aih. Ranenh cô jah wèq hloi am ca mangai Is-ra-ên wa mangai jàn 'noiq ma ŏi ta wì haq. ");
INSERT INTO hre_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Mangai leq troq bèq hanang mangai cachìt, èh 'bìq amùa tapèh hì. ");
INSERT INTO hre_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Mangai aih phai yŏc diac 'nheo baxròih dađeh hì ma piq wa hì ma tapèh èh men jah hreo. Tàng ùh broq 'màng aih, haq ùh jah wìa lem hreo. ");
INSERT INTO hre_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Mangai leq bèq hanang mahaq ùh broq hreo dađeh, èh broq ca Hnem Traiq Cùh Waiq da Chuaq loh ca amùa, mangai aih 'bìq hnan 'noh khoi ca jàn Is-ra-ên. Mangai aih xôq ŏi amùa, taiq diac broq hreo ca amùa 'nhòq da'rat ta chac haq. ");
INSERT INTO hre_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Jò i mangai cachìt ta mòiq traiq, phai broq tiaq ranenh cô: Mangai leq ma mùt ta traiq wa mangai leq ma ŏi ta traiq aih, dìq 'bìq amùa tapèh hì. ");
INSERT INTO hre_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Tàng ta traiq i cabi ùh gùp calàp, èh cabi aih hadai 'bìq amùa. ");
INSERT INTO hre_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Enh gùng ca traiq jàn ta đùng tamang, tàng i mangai leq troq bèq hanang mangai cachìt ca pàc, loq hanang mangai cachìt đeh, caxènh mangai cachìt, loq ralùng hanang, mangai aih 'bìq amùa trùh tapèh hì, ");
INSERT INTO hre_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Tàng enh broq hreo 'bài mangai cô, phai yŏc toq biaq blo da 'bo ma bùh broq ngè tadreo rŏt dèch hlài enh tôiq tah ta cabi, hi khoi yŏc diac hreo ùc ta aih. ");
INSERT INTO hre_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Èh mangai ma hreo lem phai yŏc hamenh xônh 'nhrùq ta diac aih, da'rat diac aih enh 'nhèq ca traiq, enh 'nhèq ca 'bài ranac ta traiq, enh 'nhèq ca 'bài mangai ŏi ta traiq aih, wa enh 'nhèq ca mangai ma troq bèq caxènh mangai cachìt, loq ralùng hanang, troq bèq mangai cachìt ca pàc, loq troq bèq con mangai cachìt đeh. ");
INSERT INTO hre_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Mangai lem hreo phai da'rat diac ca mangai 'bìq amùa, hì ma piq wa hì ma tapèh, bìac broq hreo can amùa hi gêh, mangai ma 'bìq amùa phai rùh eo, hùm 'nheo, èh xèq aih men jah hreo. ");
INSERT INTO hre_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mahaq tàng mangai amùa ùh chìuq broq hreo dađeh, èh mangai aih phai 'bìq hnan 'noh đac khoi dèh ca jàn, ma jah 'màng aih khoi broq ca nòi hadròih da Chuaq loh ca amùa taiq diac broq hreo can amùa ùh da'rat ta mangai aih, haq ùh jah hreo. ");
INSERT INTO hre_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Cô ranenh jah wèq hloi hloi. “Mangai da'rat diac broq hreo can amùa phai rùh dèh eo, wa mangai leq ma bèq diac broq hreo can amùa, èh 'bìq amùa trùh chìuq xèq aih. ");
INSERT INTO hre_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ngè cleq ma mangai amùa troq bèq, dìq wìa amùa, wa mangai leq troq bèq ngè aih, hadai 'bìq amùa trùh xèq hì aih.” ");
INSERT INTO hre_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Khê mòiq, dìq ca jàn Is-ra-ên trùh ta braih càn Xin. Wì haq ŏi padài ta Cađê. Mi-ri-am cachìt. Wì catùh haq ta aih. ");
INSERT INTO hre_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Taiq ùh i ca diac ôq, jàn tagop dabau tajraq hlài ca Môise wa Arôn. ");
INSERT INTO hre_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Wì haq trech Môise, doi: “Ngèh enh nhèn khoi cachìt dèh ti oh daq ma khoi cachìt enh ngìa ca Chuaq yi hnao hòm! ");
INSERT INTO hre_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Gleq ìh ma 'ràng jàn da Chuaq mùt ta braih càn cô đòiq dìq ca mangai wa ngè aban cachìt ta cô? ");
INSERT INTO hre_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Gleq ìh ma ep nhèn loh enh Aicàp đòiq mùt ta nòi 'mèq 'mac cô, nòi ùh i ca 'mau mì, plì pŏc, long nho, plì ôi rôm, wa hadai ùh i ca diac ôq?” ");
INSERT INTO hre_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Môise wa Arôn loh khoi enh wì haq, lam trùh jang 'mang Hnem Traiq Cùh Waiq, hacùn cràng bla-op. Can 'ngah 'ngai da Chuaq mahno loh. ");
INSERT INTO hre_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Wê long canhra, hi khoi ìh wa daq ìh Arôn, lam tagop jàn. Enh ngìa ca wì haq, ìh phai doi ca hmu tau, thê haq plôh diac. 'Màng aih, ìh jah am ca wì haq wa ngè aban da wì haq, ôq diac loh enh hmu talach.” ");
INSERT INTO hre_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Môise wê long canhra enh ngìa ca Chuaq tiaq bàu Haq ma thê. ");
INSERT INTO hre_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Môise wa Arôn tagop dìq ca jàn enh ngìa ca hmu, hi khoi Môise doi: “ 'Bài mangai ma loq enh blàq hlài tau, tamàng cô beq! Bèn jah yŏc diac enh hmu talach cô loh am ca pì ôq 'mòh?” ");
INSERT INTO hre_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Doi 'màng aih gêh, haq dèch long canhra hwat hmu talach baiq yàng, hi khoi diac plôh loh bàc. Mangai wa ngè aban, dìq jah ôq. ");
INSERT INTO hre_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mahaq Chuaq doi ca Môise wa Arôn: “Taiq chôp ùh lùi Au, ùh padèch hadròih hiniq Au enh ngìa ca jàn Is-ra-ên, taiq nen aih chôp ùh jah 'ràng jàn cô mùt taneh Au ma khoi hùaq ca wì.” ");
INSERT INTO hre_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Nòi aih jah creo Mê-ri-ba, taiq aih nòi jàn Is-ra-ên tajraq hlài ca Chuaq, èh hadai nòi Chuaq mahno loh manoh hadròih da Haq enh ngìa ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Enh Cađê Môise thê mangai lam trùh ta bùa Diac Êđôm, doi ca haq 'màng cô: “Cô bàu Is-ra-ên, oh daq bùa. Ìh khoi loq ca bìac nan xa da nhèn. ");
INSERT INTO hre_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Boc yaq nhèn khoi loh enh Aicàp wa ŏi hlài ta aih khoi dùnh. Mangai Aicàp khoi jùq jàm nhèn wa boc yaq nhèn. ");
INSERT INTO hre_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Mahaq jò nhèn dang creo ca Chuaq, Haq tàng wa thê 'bình plình 'ràng nhèn loh khoi enh gùng Aicàp. “Manàiq nhèn đang ŏi ta Cađê, mòiq phôq ŏi agàu jang acang Diac Êđôm. ");
INSERT INTO hre_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Xìn am ca nhèn lam cwa taneh bùa. Nhèn ùh lam pagat đùng taneh loq wia nho. Nhèn hadai ùh gôch diac adràm ôq. Nhèn lam toq roc trong, ùh wech pah 'ngeo loq pah 'ma trùh jò loh khoi enh Diac ìh.” ");
INSERT INTO hre_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mahaq Êđôm tèu: “Pì ùh jah lam cwa taneh Diac au. Tàng pì ùh tàng, èh nhèn wê chang gùm loh tajêh ca pì.” ");
INSERT INTO hre_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Mangai Is-ra-ên doi: “Nhèn xìn lam đeh toq ti trong. Tàng nhèn wa ngè aban da nhèn loq ôq diac, nhèn xìn am da ìh 'bac. Nhèn toq xìn jah lam cwa. Nhèn ùh xìn tam cleq hòm.” ");
INSERT INTO hre_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Haq tèu: “Ùh, pì ùh jah lam cwa.” Hi khoi Êđôm 'ràng mòiq cwung đôiq lình hagao hagình loh tàt. ");
INSERT INTO hre_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ma jah 'màng aih Êđôm ùh am Is-ra-ên lam cwa dèh gùng, ma jah Is-ra-ên wech lam trong 'noiq. ");
INSERT INTO hre_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Dìq ca jàn Is-ra-ên enh Cađê trùh wang Hôrò. ");
INSERT INTO hre_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ta wang Hôrò, kenh acang Êđôm. Chuaq doi ca Môise wa Arôn: ");
INSERT INTO hre_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Arôn jah hlài dèh ti boc yaq, ùh jah mùt ta taneh Au ma khoi am ca Is-ra-ên, ma jah 'màng aih, chôp khoi broq ùh troq ca Au ta Mê-ri-ba. ");
INSERT INTO hre_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","'Ràng Arôn wa con Arôn Ê-li-a-xa tŏc ta wang Hôrò beq. ");
INSERT INTO hre_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Jang aih ìh yŏc eo lè da Arôn caxùnh ca Ê-li-a-xa con Arôn. Arôn èh cachìt ta aih.” ");
INSERT INTO hre_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Môise tiaq bàu Chuaq. Wì piq ngai tŏc ta wang Hôrò, wa dìq ca jàn hnoq. ");
INSERT INTO hre_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ta bôi wang, Môise yŏc 'noh eo lè da Arôn, caxùnh ca Ê-li-a-xa con Arôn. Arôn cachìt ta bôi wang cô. Khoi ca aih Môise wa Ê-li-a-xa loh enh wang aih. ");
INSERT INTO hre_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Jò wì loq ca Arôn khoi cachìt, dìq dŏng ca jàn Is-ra-ên hmoi ta aih 30 hì. ");
INSERT INTO hre_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Jò bùa Arat mangai Ca-na-an ta nòi Nêghep ŏi pah 'ma ca mat mahì loh, hìa tình mangai Is-ra-ên đang lam trùh tiaq trong A-tha-rim, creo dèh ca lình loh tajêh, rùp jah toq 'biaq ngai. ");
INSERT INTO hre_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Jò aih mangai Is-ra-ên, pachac ca Chuaq doi: “Tàng Chuaq am ca nhèn 'blêq jàn cô, èh nhèn jah jêh dŏng phôq wì haq.” ");
INSERT INTO hre_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Chuaq tàng bàu waiq khàn da mangai Is-ra-ên, am wì haq 'blêq Ca-na-an, jêh đac 'bài lình wì, raliang đac dìq phôq wì. Hiniq ca nòi aih Hotma. ");
INSERT INTO hre_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Enh wang Hôrò, wì haq lam tiaq trong diac Raxìq Gòh đòiq wia ca taneh Êđôm, taiq 'màng aih jàn pi i ca manoh chìuq àt. ");
INSERT INTO hre_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Wì haq capoch đùng trùh Boc Plình wa Môise. Wì haq doi: “Gleq ìh 'nong nhèn loh enh Aicàp đòiq nhèn cachìt ta braih càn cô? Ŏi ta cô ùh i ca 'benh, ùh i ca diac. Nhèn hadai khoi git ca ngè 'benh caq 'mèq cô!” ");
INSERT INTO hre_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Taiq 'màng aih Chuaq thê bìh tùa trùh cap bàc ngai cachìt. ");
INSERT INTO hre_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Wì trùh doi ca Môise: “Nhèn khoi broq tôiq ma jah 'màng aih, nhèn khoi capoch 'mèq ca Boc Plình wa ca ìh. Xìn ìh waiq khàn ca Chuaq đòiq Haq hnan cađac bìh.” Môise waiq khàn am ca jàn. ");
INSERT INTO hre_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Chuaq doi ca Môise: “Broq mòiq toq bìh tùa xam đùng atua haq ta mòiq toq long. Mangai leq ma 'bìq bìh cap, èh ngan bìh aih, haq jah rìh.” ");
INSERT INTO hre_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","'Màng aih Môise broq mòiq toq bìh tùa xam đùng gam, 'ràng atua ta mòiq toq long jrang, mangai leq 'bìq bìh cap, hi ngan ta bìh broq xam đùng gam, dìq ùh hìaq cachìt. ");
INSERT INTO hre_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Mangai Is-ra-ên loh lam hòm, wa padài đòiq traiq ta Ôbôt. ");
INSERT INTO hre_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Lam enh Ôbôt, wì haq đòiq traiq ta Ijê A-ba-rim ta braih càn, pah mat mahì loh da Moap. ");
INSERT INTO hre_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Loh lam enh aih, wì haq đòiq traiq ta thòng Xêrêt, ");
INSERT INTO hre_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Wì haq loh lam hòm, đòiq traiq ta braih càn, pah tau ca cròng diac Atnôn, aih ta braih càn jêq gùng da mangai A-mô-rit. Cròng diac Atnôn broq acang ta'ne gùng Moap wa taneh gùng mangai A-mô-rit. ");
INSERT INTO hre_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Taiq 'màng aih ta Sech Tajêh Da Chuaq i achìh: “Phôq Wahep ŏi ta gùng Suphah wa 'bài hŏc diac da Atnôn, ");
INSERT INTO hre_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","loh hangai trùh phôq Arò, wa roc kenh criang da hŏc diac ta acang taneh Diac Moap.” ");
INSERT INTO hre_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Enh aih, wì haq lam hòm trùh Bê-e. Aih nòi adràm ma Chuaq doi ca Môise: “Tagop mangai jàn đòiq Au am ca wì haq diac ôq.” ");
INSERT INTO hre_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Hi khoi jàn Is-ra-ên calêu 'bŏi cô: “Ô diac ta adràm, tŏc beq! Đòiq nhìn jah calêu padèch ha'nhèq diac adràm cô! ");
INSERT INTO hre_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Diac adràm ma mangai gù craq chìa, 'Bài cwan ma chìa, Chìa xam long canhra, Baxèm xam long wèq cwìang da bùa.” Hi khoi wì haq enh braih càn lam trùh Ma-tha-na. ");
INSERT INTO hre_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Enh Ma-tha-na wì trùh Na-ha-li-ên, enh Na-ha-li-ên trùh Bamôt; ");
INSERT INTO hre_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Enh Bamôt trùh thòng ŏi ta taneh da Moap trùh bôi wang Phichga, enh aih ngan hnoq jàp ca braih càn. ");
INSERT INTO hre_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Is-ra-ên thê mangai 'ràng bàu doi ca Sihôn, bùa A-mô-rit 'màng cô: ");
INSERT INTO hre_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Xìn am nhèn lam cwa taneh bùa. Nhèn ùh lam mùt ta đùng taneh, wùan nho, hadai ùh gôch diac adràm đòiq ôq. Nhèn lam trong caiq càn da bùa trùh jò loh khoi enh acang taneh Diac ìh.” ");
INSERT INTO hre_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mahaq bùa Sihôn ùh am jàn Is-ra-ên cwa dèh taneh. Bùa 'ràng dìq dèh ca cwung đôiq loh ta braih càn wa tajêh tabroq ca jàn Is-ra-ên ta Jahai. ");
INSERT INTO hre_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Mangai Is-ra-ên jêh cachìt Sihôn xam chang gùm, ta'miaq yŏc taneh enh Atnôn trùh Jabôc, trùh acang Amôn, ma jah 'màng aih acang da Amôn hagao cajap. ");
INSERT INTO hre_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Mangai Is-ra-ên yŏc dŏng dìq 'bài phôq cô, èh ŏi hloi da phôq da mangai A-mô-rit, xam phôq Hêtbôn wa phôq ma dudan kenh aih. ");
INSERT INTO hre_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hêtbôn phôq da Sihôn bùa A-mô-rit. Adroi cô nèh, Sihôn khoi 'blêq bùa Moap yŏc taneh da bùa cô trùh cròng Atnôn. ");
INSERT INTO hre_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Taiq 'màng aih i mangai achìh: “Pajùm ti dabau trùh Hêtbôn beq! Broq hlài phôq da Sihôn! ");
INSERT INTO hre_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Enh Hêtbôn ùnh khoi plôh loh, Ùnh cheo enh phôq da Sihôn, Bùh cheo Arò da Moap, Phôq ma ha'nhèq wèq cwìang Atnôn. ");
INSERT INTO hre_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ôi jàn Moap nan xa ca gè; Ôi jàn Kêmôt, can cachìt da gè khoi trùh; Con calô gè phai cadàu mot, lam lìq lam làn; Con cadrì gè phai ŏi tù, Taiq Sihôn, bùa jàn A-mô-rit. ");
INSERT INTO hre_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Mahaq manàiq nhèn khoi jêh 'blêq haq, Enh Hêtbôn khoi raliang đac trùh Đibôn, Nhèn raliang đac wì haq trùh Nôphat, trùh Mê-đê-ba.” ");
INSERT INTO hre_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","'Màng aih mangai Is-ra-ên khoi ŏi ta taneh da mangai A-mô-rit. ");
INSERT INTO hre_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Môise thê mangai lam rinh ngan Jaxe, èh wì jêh yŏc dŏng gùng ma haten ca aih, hi hnan mangai A-mô-rit lam. ");
INSERT INTO hre_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Khoi ca aih mangai Is-ra-ên tawìh hlài, lam trùh pah Basan. Ot, bùa Basan, 'nong dìq dèh ca lình loh tàt wì ta Êt-rê-i. ");
INSERT INTO hre_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Chuaq doi ca Môise: “Apaq yùq ca bùa aih, ma jah 'màng aih Au khoi jao haq ta tì ìh, xam lình haq, jàn haq wa taneh haq hòm. Ìh broq ca haq tìah ca ìh ma khoi broq ca Sihôn, bùa jàn A-mô-rit ŏi ta Hêtbôn.” ");
INSERT INTO hre_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","'Màng aih mangai Is-ra-ên jêh Ot, con caiq wa jàn, lình haq, ùh đòiq mòiq ngai jah rìh, hi khoi yŏc taneh Diac wì haq. ");
INSERT INTO hre_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Khoi ca aih jàn Is-ra-ên lam trùh ta tamang Moap wa đòiq traiq pah tau cròng diac Jôđan, ta ngìa ca Jê-ri-cô. ");
INSERT INTO hre_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balac, con calô Xippo, hnoq dŏng rìm bìac Is-ra-ên broq ca mangai A-mô-rit, ");
INSERT INTO hre_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","'màng aih, jàn Moap yùq dìq jaq jò hnoq mangai Is-ra-ên bàc hrìn. ");
INSERT INTO hre_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Bùa Moap anoi ca mangai broq craq da Ma-đi-an: “Mangai jàn bàc cô èh caq bèn tìah ca 'bo caq nhat ta đùng taneh.” Jò aih Balac, con Xippo, broq bùa Moap. ");
INSERT INTO hre_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Haq thê mangai lam 'ràng bàu ta Ba-la-am con calô Bêô ta gùng Pethò kenh cròng diac, doi ca haq: “Mòiq jàn khoi loh enh gùng Aicàp bàc dìq jaq tìah ca lom đùng taneh. Wì 'nang ŏi enh ngìa nhèn. ");
INSERT INTO hre_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Manàiq cô xìn ìh trùh waiq hanip wì, taiq wì yi dêh ca nhèn, 'màng aih, nhèn men jah hnan đac wì haq loh khoi enh taneh cô. Ma jah 'màng aih, au loq mangai leq jah ìh waiq xôq, èh mangai aih jah xôq, mangai leq ìh hanip, èh raliang ralàc.” ");
INSERT INTO hre_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","'Màng aih mangai broq craq da Moap lam ti 'bài craq da Ma-đi-an, wê tiaq 'bac ngè baha bìac broq da Ba-la-am. Jò glàm Ba-la-am, wì anoi hlài bàu Balac ma tanap. ");
INSERT INTO hre_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ba-la-am doi ca wì: “Xìn pì ŏi ti au mang cô. Au jah doi ca pì tiaq bàu Chuaq ma doi ca au.” 'Màng aih 'bài craq da Moap ŏi đò. ");
INSERT INTO hre_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Boc Plình trùh bòch Ba-la-am: “ 'Bài mangai ma ŏi ta hnem ìh 'mat, cabô?” ");
INSERT INTO hre_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ba-la-am tèu: “Balac con calô Xippo, bùa Moap, thê 'bài mangai cô trùh doi: ");
INSERT INTO hre_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Mòiq jàn loh enh Aicàp bàc dìq jaq tìah ca lom dŏng đùng taneh. Ìh phai trùh waiq hanip jàn cô. 'Màng aih nhèn men jah jêh hnan wì haq loh lam.’ ” ");
INSERT INTO hre_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Mahaq Boc Plình doi ca Ba-la-am: “Apaq lam ti wì haq. Ìh ùh jah waiq hanip mangai jàn aih, ma jah 'màng aih wì haq khoi jah xôq ramŏt.” ");
INSERT INTO hre_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Xroq atìq Ba-la-am yòng doi ca 'bài mangai 'ràng bàu da Balac: “Xìn pì hlài dèh ta gùng beq, ma jah 'màng aih, Chuaq ùh am au lam ti pì.” ");
INSERT INTO hre_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","'Bài mangai broq craq da Moap hlài doi ca Balac: “Ba-la-am chôiq, ùh chìuq lam ti nhèn.” ");
INSERT INTO hre_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balac thê mangai ma 'noiq yi bàc lam. Wì haq i tìang i 'bang yi hnao ca 'bài mangai adroi. ");
INSERT INTO hre_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Wì trùh doi ca Ba-la-am: “Balac con Xippo doi: Xìn ìh apaq chôiq glàm au, ");
INSERT INTO hre_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","au hùaq, au dìq jaq padèch ìh wa au broq tiaq rìm bìac ìh ma thê au broq ùh kè ca bìac cleq. Xìn ìh trùh waiq hanip jàn cô am ca au beq.” ");
INSERT INTO hre_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mahaq Ba-la-am tèu wì haq: “ 'Nhac ca Balac am ca au dìq ca wang 'bac ta hnem haq, au xôq ùh jah broq ùh troq ca bàu thê Chuaq, Boc Plình da au, mòiq bìac cleq 'nhac ca bìac 'yoh loq bìac càn. ");
INSERT INTO hre_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Manàiq au hadai xìn pì ŏi ti hnem au mang cô, đòiq ca au ngan thù Chuaq doi ca au cleq mang cô!” ");
INSERT INTO hre_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Mang aih, Boc Plình trùh doi ca Ba-la-am: “Tàng 'bài mangai aih trùh adràc, lam ti wì beq, mahaq ìh toq broq tiaq bìac Au ma thê ìh broq.” ");
INSERT INTO hre_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","'Màng aih, Ba-la-am rìu xrŏih, còi lùa, loh lam ti 'bài mangai 'ràng bàu da Moap. ");
INSERT INTO hre_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Mahaq bìac haq ma lam aih broq ca Boc Plình loh nòih. 'Bình plình da Chuaq yòng ti trong đòiq tàt khech haq. Ba-la-am còi lùa wa i baiq ngai hapŏng lam tiaq. ");
INSERT INTO hre_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Jò lùa hnoq 'bình plình da Chuaq yòng ti trong, tì wê chang gùm khoi dŏih enh hnup, lùa wech enh trong, lam đac ta đùng taneh. Ba-la-am hwat lùa đòiq thê haq lam jang ti trong. ");
INSERT INTO hre_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Èh 'bình plình da Chuaq yòng ti trong chit, ŏi ta'ne wia nho, baiq pah trong i panàt. ");
INSERT INTO hre_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Jò lùa hnoq 'bình plình da Chuaq, haq ŏi đeh kenh panàt broq padit jènh da Ba-la-am. 'Màng aih Ba-la-am hwat haq mòiq yàng hòm. ");
INSERT INTO hre_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","'Bình plình da Chuaq lam hòm ŏi ti nòi trong chit, ùh i ca trong đòiq wech pah 'ngeo loq wech pah 'ma. ");
INSERT INTO hre_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Jò lùa hnoq 'bình plình da Chuaq, haq bla-op ti taneh. Ba-la-am nòih, yŏc long canhra hwat haq. ");
INSERT INTO hre_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Chuaq pèh hacùng lùa, haq doi ca Ba-la-am: “Au ma i broq đeh cleq ma ìh hwat au trùh piq yàng?” ");
INSERT INTO hre_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ba-la-am doi ca lùa: “Taiq gè jù lê au. Tàng au i chang gùm au khoi jêh đac gè.” ");
INSERT INTO hre_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Lùa bòch Ba-la-am: “Au i joq lùa ìh ma xang còi yôt enh adroi cô ùh? Au i lah broq 'màng cô ùh?” Ba-la-am tèu: “Ùh.” ");
INSERT INTO hre_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Jò aih Chuaq pèh mat Ba-la-am. Haq hnoq 'bình plình da Chuaq yòng ti trong, tì wê chang gùm khoi dŏih enh hnup. Tajòi 'mòi haq cùp gàu ta taneh. ");
INSERT INTO hre_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","'Bình plình da Chuaq bòch: “Gleq ìh ma jah hwat lùa piq yàng? Au lam trùh ta cô đòiq tàt khech ìh, ma jah 'màng aih ìh lam tiaq trong dù. ");
INSERT INTO hre_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Mahaq lùa hnoq Au, ma jah haq wech ca Au piq yàng. Tàng haq ùh wech ca Au, Au khoi jêh đac ìh wa đòiq ca haq rìh.” ");
INSERT INTO hre_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ba-la-am doi ca 'bình plình da Chuaq: “Au khoi broq tôiq. Au ùh 'nì ìh yòng ti trong tàt khech au. Tàng bìac cô ùh lem manoh ìh, au wìh hlài.” ");
INSERT INTO hre_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mahaq 'bình plình da Chuaq doi ca Ba-la-am: “Lam tiaq wì beq, mahaq ìh toq doi bàu leq Au ma thê ìh doi.” 'Màng aih Ba-la-am lam hòm ti 'bài mangai 'ràng bàu da Balac. ");
INSERT INTO hre_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Hìa tình Ba-la-am trùh, Balac lam trùh mòiq phôq ta Moap kenh acang ta cròng diac Atnôn đòiq đìh yŏc haq. ");
INSERT INTO hre_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balac bòch Ba-la-am: “Au khoi dìq jaq xìn ìh trùh! Gleq ìh ùh trùh? Au ùh tôm itai đòiq broq ca ìh jah i 'bang tìang 'mòh?” ");
INSERT INTO hre_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ba-la-am tèu: “Manàiq au khoi trùh ta cô, mahaq au ùh i ca cwìang capoch cleq! Au toq jah capoch bàu ma Boc Plình thê Au capoch.” ");
INSERT INTO hre_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ba-la-am lam ti Balac trùh ta Ki-ri-at Hutsôt. ");
INSERT INTO hre_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balac pàc 'bo wa trìu đòiq tadreo, wa thê 'ràng 'bài ngè tadreo ca Ba-la-am wa 'bài craq ma lam tiaq haq. ");
INSERT INTO hre_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Xroq atìq, Balac 'ràng Ba-la-am tŏc ta nòi ha'nhèq ta Bamôt Ba-an. Enh nòi aih Ba-la-am jah hnoq mòiq 'nah jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ba-la-am doi ca Balac: “Ìh broq jang cô tapèh toq ca'bŏng tadreo wa padon am ca au tapèh toq 'bo calô, tapèh toq trìu calô.” ");
INSERT INTO hre_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balac broq tiaq troi bàu Ba-la-am ma thê. Wa baiq ngai am mòiq toq 'bo wa mòiq toq trìu ta rìm toq ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Hi khoi Ba-la-am doi ca Balac: “Xìn bùa yòng haten dèh ca ngè tadreo. Au lam trong cô, ùac aiq Boc Plình trùh am au glàm. Haq thê bàu cleq ca au, èh au jah doi ca ìh.” Ba-la-am tŏc ta go. ");
INSERT INTO hre_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Boc Plình mahno loh ca Ba-la-am. Ba-la-am doi ca Haq: “Au khoi broq tapèh toq ca'bŏng tadreo, wa ta rìm toq ca'bŏng aih, au am mòiq toq 'bo calô wa mòiq toq trìu calô.” ");
INSERT INTO hre_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Hi khoi Chuaq đòiq bàu ta hacùng Ba-la-am wa tanap ca haq: “Hlài ta Balac beq, doi ca haq.” ");
INSERT INTO hre_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ba-la-am hlài hnoq Balac yòng dèh ti ngè tadreo ti 'bài craq da Moap. ");
INSERT INTO hre_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ba-la-am anoi ca Balac bàu cô: “Balac, bùa Moap lam ti au enh Aram; Enh hidroi wang pah mat mahì loh; Thê au trùh waiq hanip Jacôp wa Hanip jàn Is-ra-ên! ");
INSERT INTO hre_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","'Màng leq au jah waiq hanip Mangai ma Boc Plình ùh waiq hanip? 'Màng leq au jah capoch jù atòng Mangai Boc Plình ùh capoch jù atùng? ");
INSERT INTO hre_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Enh bôi wang au hnoq wì haq; Enh go ha'nhèq au ngan wì haq; Au hnoq wì haq mòiq jàn khoi lah dađeh loh crài; Ùh ngan dađeh tìah ca mòiq Diac ta crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Cabô jah rèn blo da Jacôp? Cabô rèn jah mòiq phàn pôn da jàn Is-ra-ên? Đòiq au cachìt troi mangai ta-atoq; Am ca au cachìt tìah ca haq ma cachìt.” ");
INSERT INTO hre_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balac bòch Ba-la-am: “Ìh broq cleq 'màng 'mat? Au xìn ìh trùh thê ìh waiq hanip jàn ma tagit ca au, mahaq ìh waiq xôq ca wì haq!” ");
INSERT INTO hre_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ba-la-am tèu: “Au ep doi bàu Chuaq ma khoi đòiq ta hacùng au.” ");
INSERT INTO hre_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Khoi ca aih Balac doi ca Ba-la-am: “Ìh lam tiaq au trùh nòi 'noiq, jang nòi aih ìh jah hnoq wì, mahaq jah hnoq dèh mòiq phàn raq, wa ìh waiq hanip wì haq am ca au.” ");
INSERT INTO hre_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Hi khoi Balac 'ràng Ba-la-am trùh ta đùng taneh Xôphim, tŏc ta bôi wang Phichga, broq ta nòi aih tapèh toq ca'bŏng tadreo wa ta rìm toq ca'bŏng tadreo am mòiq toq 'bo wa mòiq toq trìu calô. ");
INSERT INTO hre_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ba-la-am doi ca Balac: “Xìn bùa yòng jang 'mat dèh ti ngè tadreo, èh au lam trùh nòi tau glàm Chuaq.” ");
INSERT INTO hre_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Chuaq mahno loh ca Ba-la-am wa đòiq bàu ta hacùng haq, hi khoi thê haq hlài doi ca Balac. ");
INSERT INTO hre_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","'Màng aih Ba-la-am hlài, hnoq Balac yòng dèh ti 'bài craq da Moap, jang ngè tadreo bùh. Balac bòch: “Chuaq tanap ca ìh 'màng leq?” ");
INSERT INTO hre_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ba-la-am capoch bàu loq adroi: “Ôi Balac, yòng beq tamàng cô; Ôi con calô Xippo, tamàng oq! ");
INSERT INTO hre_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Boc Plình ma xài con mangai đòiq amòng; Haq ma xài con mangai đòiq tablòq manoh; I jò leq Haq doi, èh ùh broq? Loq hùaq ma ùh tiaq dèh bàu? ");
INSERT INTO hre_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Cô, au nhàn bàu thê đòiq waiq xôq; Haq khoi waiq xôq, au ùh jah blòq hlài; ");
INSERT INTO hre_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Ta Jacôp, Haq ùh hnoq bìac ùh xôq; Ta jàn Is-ra-ên ùh hnoq bìac nan xa Chuaq Boc Plình da haq ŏi ti haq; Ta jàn Is-ra-ên i bàu cachech manè apôi da bùa! ");
INSERT INTO hre_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Boc Plình 'nong wì haq loh khoi enh Aicàp; Wì haq dêh tìah ca aki 'bo brì. ");
INSERT INTO hre_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Taiq ùh i ca mangai leq jah pacrô Jacôp; hadai ùh i ca bàu da pajàu ngan plình anoi 'noh bìac adroi broq 'mèq ca jàn Is-ra-ên; ma jah 'màng aih, ta jò troq, jah anoi bìac Boc Plình khoi broq ca Jacôp wa Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Wì haq yòng tìah ca baco hlari cadrì, tìah ca baco hlari calô. Padài toq jò khoi lŏn ngè caq wa Ôq mahem 'bài ngè ma 'bìq jêh cachìt.” ");
INSERT INTO hre_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balac doi ca Ba-la-am: “Ìh ùh waiq hanip wì haq, hêq hadai apaq waiq xôq ca wì haq hòm.” ");
INSERT INTO hre_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ba-la-am tèu: “Au khoi doi, au toq jah capoch hlài bàu Chuaq ma khoi doi ca au.” ");
INSERT INTO hre_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Hi khoi Balac doi ca Ba-la-am: “Đòiq au 'ràng ìh mòiq nòi 'noiq, èh ùac aiq yàng cô, Boc Plình am ìh hanip wì ŏi nòi aih.” ");
INSERT INTO hre_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","'Màng aih, Balac 'ràng Ba-la-am tŏc ta bôi wang Pêo, enh aih ngan hnoq braih càn. ");
INSERT INTO hre_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ba-la-am doi: “Broq tapèh toq ca'bŏng tadreo wa padon tapèh toq 'bo, tapèh toq trìu jang cô am ca au.” ");
INSERT INTO hre_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balac broq tiaq bàu Ba-la-am. Haq am mòiq toq 'bo, mòiq toq trìu, tah ta rìm toq ca'bŏng tadreo. ");
INSERT INTO hre_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Jò Ba-la-am hnoq ro rang Chuaq loq enh waiq xôq ca jàn Is-ra-ên, 'màng aih haq ùh lam chaq bìac bahìan troi enh adroi hòm, mahaq haq tawìh ngan pah braih càn. ");
INSERT INTO hre_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Haq hnoq 'bài traiq jàn Is-ra-ên, mòiq hadròng hadrech broq dèh mòiq traiq crài; èh Yiang Hadròih da Boc Plình loh ti haq. ");
INSERT INTO hre_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Haq capoch bàu loq adroi 'màng cô: “Bàu loq adroi da Ba-la-am, con calô Bêô; Mangai i mat khoi blèch. ");
INSERT INTO hre_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Mangai ma jah tàng bàu da Boc Plình; Mangai ma hnoq bìac mahno da Chuaq I Cwìang Itai Dìq Dŏng; 'Nhac ca haq tacro, mahaq mat haq xôq blèch. ");
INSERT INTO hre_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Ôi Jacôp! Traiq ìh lem dìq jaq; Ôi Is-ra-ên! Hnem traiq ìh broq lem dìq jaq. ");
INSERT INTO hre_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Tìah ca thòng ma yôh; Tìah ca wia ŏi kenh diac; Tìah ca long gahnàu jah tì Chuaq pìt; Tìah ca long hùang nam hon ti thòng diac. ");
INSERT INTO hre_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Diac jah loh bàc, wì haq jah i rah; Con xau wì haq ùh hìaq rìh croh crenh. “Bùa wì haq i cwìang yi hnao ca Aga; Taneh Diac wì haq càn dêh. ");
INSERT INTO hre_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Boc Plình 'ràng wì haq loh khoi enh Diac Aicàp; Wì haq loh ca càn dêh tìah ca aki da 'bo brì ta rôm; Wì haq lŏn adrìh 'bài Diac ma tagit ca wì haq. ");
INSERT INTO hre_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Wì haq cùi padài tìah ca baco hlari cùi padài; Cabô ma hùa padrìu haq? “Mangai leq ma waiq xôq ca wì haq, èh jah xôq; Cabô ma waiq hanip wì haq èh 'bìq ranàc càn.” ");
INSERT INTO hre_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Jò aih Balac loh nòih, pi nui àt. Haq tep dèh tì, hi doi ca Ba-la-am: “Au creo ca ìh trùh đòiq ìh waiq hanip mangai tagit ca au, mahaq ìh khoi piq yàng cô waiq xôq ca wì haq. ");
INSERT INTO hre_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Hêq ìh cadàu mot hlài beq! Au i hùaq au broq ca ìh jah i 'bang tìang, mahaq Chuaq khoi tàt khech ìh broq bìac aih.” ");
INSERT INTO hre_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ba-la-am tèu: “Au khoi doi ca mangai 'ràng bàu da bùa, ");
INSERT INTO hre_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ 'nhac ca bùa am ca au dìq ca 'bac wa wang ŏi ta hnem, au ùh jah tiaq dèh manoh broq cleq ma ùh tiaq bàu thê da Chuaq, 'nhac ca bìac lem loq bìac 'mèq. Chuaq thê capoch cleq, au ep capoch troq 'màng aih.’ ");
INSERT INTO hre_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Manàiq cô, adroi ca au loh hlài, au xìn doi adroi bìac Is-ra-ên broq ca jàn da bùa atìq cô èh.” ");
INSERT INTO hre_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ba-la-am doi hòm: “Bàu loq adroi da Ba-la-am, con calô Bêô; Mangai i mat khoi blèch. ");
INSERT INTO hre_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Mangai jah tàng bàu Boc Plình; Loq ca bìac càn caiq da Haq ma yi Ha'nhèq; Jah hnoq bìac mahno da Boc Plình I Cwìang Itai Dìq Dŏng; 'Nhac ca haq tacro, mat haq xôq blèch. ");
INSERT INTO hre_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Bìac au hnoq ma 'nhòq i pa'noh; Manàiq bìac au ngan 'nhòq trùh haten. Mòiq toq halŏng ma hnoq loh enh hnem Jacôp; Mòiq toq long wèq cwìang da bùa èh trùh enh Is-ra-ên; Cô èh jah jêh Moap Haprah hapriang jêh đac dŏng dìq xinoi da wì ma loq enh blàq hlài. ");
INSERT INTO hre_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Is-ra-ên jah catèh dèh can dêh; Ta'blêq yŏc Êđôm wa Sirò. ");
INSERT INTO hre_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Bùa ma i cwìang loh enh hnem Jacôp cô; Jêh đac dŏng mangai jàn ma xrong hlài rìh ta phôq.” ");
INSERT INTO hre_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Khoi ca aih, Ba-la-am ngan hnoq A-ma-lec; Haq capoch bàu loq adroi 'màng cô: “A-ma-lec jah wèq cwìang rìm diac; Mahaq atìq èh hadai 'bìq jêh đac dŏng.” ");
INSERT INTO hre_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Jò ngan hnoq mangai Kên, haq doi: “Nòi ìh ŏi jah catèm, Tìah ca pù broq enh 'nhèq ca hmu talach! ");
INSERT INTO hre_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","'Nhac 'màng aih, Kên hadai 'bìq raliang ralàc; Asua jah rùp haq dùnh dàng leq?” ");
INSERT INTO hre_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Haq padìq bàu loh adroi dađeh 'màng cô: “Ôi! Jò Boc Plình broq bìac cô, I cabô ma nui rìh tàng Boc Plình ùh pajaq? ");
INSERT INTO hre_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Mahaq bong trùh enh kenh diac raxìq Kittim; Broq Asua wa Êbe xalep; Khoi èh wì haq hadai 'bìq jêh đac.” ");
INSERT INTO hre_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ba-la-am yòng hlài dèh ta hnem. Balac hadai lam. ");
INSERT INTO hre_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Jò mangai Is-ra-ên ŏi ta Sitim, i 'nah ngai con calô da Is-ra-ên tango anang ti 'bài con cadrì Moap. ");
INSERT INTO hre_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","'Bài gu cadrì adràc wì haq caq ngè tadreo dèh ca can kiac wì haq. Wì haq caq ôq wa hacùn cràng cùh waiq can kiac aih. ");
INSERT INTO hre_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","'Màng aih jàn Is-ra-ên khoi pajùm ta bìac cùh waiq kiac Ba-an Pêo. Taiq bìac aih Chuaq nòih ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Chuaq doi ca Môise: “Rùp dìq mangai ma broq gàu ta jàn, atua tènh wì haq ta tôq enh ngìa ca Chuaq, đòiq can nòih da Chuaq tawìh khoi enh jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Môise doi ca 'bài cwan tình hiniq da jàn Is-ra-ên: “Pì hadrah cachìt dŏng dìq 'bài mangai khoi broq pajùm ti wì haq cùh waiq Ba-an Pêo.” ");
INSERT INTO hre_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Jò dìq ca jàn 'nang creo hmoi jang 'mang Hnem Traiq Cùh Waiq, i mòiq ngai Is-ra-ên ahlài mòiq ngai gù cadrì Ma-đi-an hlài ta hnem dađeh enh ngìa ca Môise wa dìq ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Hnoq 'màng aih, Phi-nê-hat, con calô Ê-li-a-xa, xau Arôn, pajàu Boc Plình padinh yòng lam yŏc jaoq, ");
INSERT INTO hre_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","cadàu tiaq mangai aih, mùt ta traiq, bìt racop wa baiq ngai, bìt hlùh mangai Is-ra-ên wa cliac gù cadrì. 'Màng aih, can ranàc 'mèq men hêq. ");
INSERT INTO hre_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Mangai ma cachìt ta bìac yàng cô, tŏc trùh 24.000 ngai. ");
INSERT INTO hre_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Phi-nê-hat, con calô Ê-li-a-xa, xau Arôn, pajàu khoi dèch jàn Is-ra-ên claih khoi can nòih Au. Haq tagrình manoh taiq haq yŏc manoh tagrình da Au, 'màng aih Au pi jêh dìq jàn Is-ra-ên taiq tagrình da Au. ");
INSERT INTO hre_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","'Màng aih, ìh am ca haq loq: Au broq wêh jao catèm ca haq; ");
INSERT INTO hre_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Aih wêh jao ca haq wa con xau haq. Wì haq jah wèq broq pajàu hloi hloi, ma jah 'màng aih haq khoi i manoh dêh nhang dèh ca Boc Plình dađeh, wa rŏt hlài enh tôiq ca jàn Is-ra-ên.” ");
INSERT INTO hre_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Hiniq mangai Is-ra-ên ma 'bìq jêh pajùm ti gù cadrì Ma-đi-an, aih Ximri, con calô Salu ma broq gàu ta mòiq xinoi Si-mê-ôn, ");
INSERT INTO hre_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","wa hiniq gù cadrì Ma-đi-an, aih Côtbi, con Xurò, mangai broq gàu mòiq xinoi ta Ma-đi-an. ");
INSERT INTO hre_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Ìh phai ngan mangai Ma-đi-an, aih mangai tagit, èh phai jêh cachìt wì haq, ");
INSERT INTO hre_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ma jah 'màng aih wì haq khoi ngan pì tìah ca mangai enh ta'blêq ca wì haq, jò wì haq broq bìac padô 'nùt pì, ta bìac cùh waiq Ba-an da Pêo, wa taiq bìac da Côtbi, con cadrì da mangai broq gàu Ma-đi-an, aih mangai cadrì ma 'bìq jêh ta hì loh bìac ranàc 'mèq, taiq bìac cùh waiq ŏi ta Pêo.” ");
INSERT INTO hre_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Atìq ca bìac ranàc 'mèq aih, Chuaq doi ca Môise wa Ê-li-a-xa, con calô pajàu Arôn: ");
INSERT INTO hre_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Ti rèn sôq jàn Is-ra-ên tiaq dèh hadròng hadrech, enh 20 hanam dang tŏc, 'bài mangai ma khoi hlàt loh ta nòi tajêh.” ");
INSERT INTO hre_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","'Màng aih ta tamang Moap, pah diac Jôđan, ta jang ca Jê-ri-cô, Môise wa pajàu Ê-li-a-xa anoi hlài bàu aih ca jàn: ");
INSERT INTO hre_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Ti rèn 'bài mangai enh 20 hanam dang tŏc, troi Chuaq khoi thê Môise.” Aih sôq jàn Is-ra-ên ma loh khoi enh Aicàp: ");
INSERT INTO hre_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Con xau Rubên, con calô ramua da jàn Is-ra-ên. Enh Hênoc xa-ông loh hadròng hadrech Hênoc. Enh Phalu xa-ông loh hadròng hadrech Phalu. ");
INSERT INTO hre_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Enh Hêtrôn xa-ông loh hadròng hadrech Hêtrôn. Enh Catmi xa-ông loh hadròng hadrech Catmi. ");
INSERT INTO hre_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Aih dìq hadròng hadrech ŏi ta hadròng hadrech Rubên, i 43.730 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Con calô Phalu aih Ê-li-ap. ");
INSERT INTO hre_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Dìq ca con calô Ê-li-ap: Nê-mu-ên, Đathan wa A-bi-ram. Đathan wa A-bi-ram cô baiq ngai 'nong gàu jàn. Wì haq khoi tiaq Côra yòng tajraq hlài ca Môise, Arôn wa ca Chuaq hloi; ");
INSERT INTO hre_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Taneh hah hacùng lŏn wì haq xam Côra, hadai i 250 ngai tiaq wì haq 'bìq ùnh bùh cachìt. Bìac cô jah pa'noh đòiq pa'yèp jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mahaq con xau Côra ùh cachìt. ");
INSERT INTO hre_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Con xau Si-mê-ôn, tình tiaq tang hadròng hadrech enh Nê-mu-ên xa-ông loh hadròng hadrech Nê-mu-ên. Enh Jamin xa-ông loh hadròng hadrech Jamin. Enh Jakin xa-ông loh hadròng hadrech Jakin. ");
INSERT INTO hre_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Enh Xêra xa-ông loh hadròng hadrech Xêrach. Enh Saulò xa-ông loh hadròng hadrech Saulò. ");
INSERT INTO hre_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Aih hadròng hadrech Si-mê-ôn, i 22.200 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Con xau Gat, tình tang hadròng hadrech: Enh Xêphôn xa-ông loh hadròng hadrech Xêphôn. Enh Haghi xa-ông loh hadròng hadrech Haghi. Enh Suni xa-ông loh hadròng hadrech Suni. ");
INSERT INTO hre_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Enh Ocni xa-ông loh hadròng hadrech Ocni. Enh Êri xa-ông loh hadròng hadrech Êri. ");
INSERT INTO hre_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Enh Arôt xa-ông loh hadròng hadrech Arôt. Enh A-rê-li xa-ông loh hadròng hadrech A-rê-li. ");
INSERT INTO hre_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Aih hadròng hadrech da Gat, i 40.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","I baiq ngai con calô da Juđa, aih Êrò wa Ônan khoi cachìt ta Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Con xau da Juđa, tình tang hadròng hadrech: Enh Sêlah xa-ông loh hadròng hadrech Sêlah. Enh Perex, xa-ông loh hadròng hadrech Perex. Enh Xêrach xa-ông loh hadròng hadrech Xêra. ");
INSERT INTO hre_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Enh Hêtrôn xa-ông loh hadròng hadrech Hêtrôn. Enh Hamun xa-ông loh hadròng hadrech Hamun. Hêtrôn wa Hamun aih con Perex. ");
INSERT INTO hre_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Aih hadròng hadrech da Juđa, i 76.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Con xau I-sa-ca, tình tang hadròng hadrech: Enh Tôla xa-ông loh hadròng hadrech Tôla. Enh Puwa xa-ông loh hadròng hadrech Puwa. ");
INSERT INTO hre_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Enh Jasup xa-ông loh hadròng hadrech Jasup. Enh Simrôn xa-ông loh hadròng hadrech Simrôn. ");
INSERT INTO hre_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Aih hadròng hadrech da I-sa-ca, i 64.300 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Con xau da Xe-bu-lun, tình tang hadròng hadrech: Enh Sêrêt xa-ông loh hadròng hadrech Sêrêt. Enh Êlôn xa-ông hadròng hadrech Êlôn. Enh Ja-lê-ên xa-ông loh hadròng hadrech Ja-lê-ên. ");
INSERT INTO hre_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Aih hadròng hadrech Xa-bu-lun, i 60.500 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Con xau Jôsep, tình tang hadròng hadrech, i Ma-na-se wa Ep-ra-im. ");
INSERT INTO hre_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Con xau Ma-na-se: Enh Maki xa-ông loh hadròng hadrech Maki. Enh Ga-la-at, con Maki, xa-ông loh hadròng hadrech Ga-la-at. ");
INSERT INTO hre_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Cô 'bài mangai da Ga-la-at: Enh Ixe xa-ông loh hadròng hadrech Ixe. Enh Hêlec xa-ông hadròng hadrech Hêlec. ");
INSERT INTO hre_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Enh Ach-ri-ên xa-ông loh hadròng hadrech Ach-ri-ên. Enh Sichem xa-ông loh hadròng hadrech Sichem. ");
INSERT INTO hre_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Enh Sê-mi-đa xa-ông loh hadròng hadrech Sê-mi-đa. Enh Hêphê xa-ông loh hadròng hadrech Hêphê. ");
INSERT INTO hre_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Xê-lô-phat, con calô Hêphê ùh i ca con calô. 'Bài hiniq con cadrì Xê-lô-phat, aih Mahlah, Noah, Hotlah, Mincah wa Ti-ri-xah. ");
INSERT INTO hre_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Aih hadròng hadrech da Ma-na-se, i 52.700 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Con xau Ep-ra-im: Enh Su-tê-la xa-ông hadròng hadrech Su-tê-la. Enh Bêca xa-ông loh hadròng hadrech Bêca. Enh Tahan xa-ông loh hadròng hadrech Tahan. ");
INSERT INTO hre_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Con da Su-tê-la, aih Êran. Enh Êran xa-ông loh hadròng hadrech Êran. ");
INSERT INTO hre_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Aih hadròng hadrech da Ep-ra-im, i 32.500 ngai. Dìq hadròng hadrech da baiq hadròng hadrech khoi achìh, dìq aih con xau da Jôsep. ");
INSERT INTO hre_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Con xau Bên-ja-min, tình tang hadròng hadrech: Enh Bêla xa-ông loh hadròng hadrech Bêla. Enh Achbên loh hadròng hadrech Achbên. Enh A-chi-ram xa-ông loh hadròng hadrech A-chi-ram. ");
INSERT INTO hre_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Enh Sê-phu-pham xa-ông loh hadròng hadrech Sê-phu-pham. Enh Hupham xa-ông loh hadròng hadrech Hupham. ");
INSERT INTO hre_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","'Bài con calô Bêla, aih Arêt wa Na-a-man. Enh Arêt xa-ông loh hadròng hadrech Arêt. Enh Na-a-man xa-ông loh hadròng hadrech Na-a-man. ");
INSERT INTO hre_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Aih 'bài hadròng hadrech da Bên-ja-min, i 45.600 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Con xau Đan, tình tang hadròng hadrech: Enh Suham xa-ông loh hadròng hadrech Suham. ");
INSERT INTO hre_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Hadròng hadrech da Đan, toq i mòiq hadròng hadrech raq. Hadròng hadrech Suham, i 64.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Con xau Ase, tình tang hadròng hadrech: Enh Imna xa-ông loh hadròng hadrech Imna. Enh Ichwi xa-ông loh hadròng hadrech Ichwi. Enh Bê-ri-a xa-ông loh hadròng hadrech Bê-ri-a. ");
INSERT INTO hre_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","'Bài con calô da Bê-ri-a: Enh Hêbe xa-ông loh hadròng hadrech Hêbe. Enh Man-chi-ên xa-ông loh hadròng hadrech Man-chi-ên. ");
INSERT INTO hre_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ase i mòiq toq con cadrì, hiniq haq Sêrah. ");
INSERT INTO hre_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Aih 'bài hadròng hadrech Ase, i 53.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Con xau Nep-ta-li, tình tang hadròng hadrech: Enh Jat-sê-ên xa-ông loh hadròng hadrech Ja-xê-ên. Enh Guni xa-ông loh hadròng hadrech Guni. ");
INSERT INTO hre_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Enh Jêxe xa-ông loh hadròng hadrech Jêxe. Enh Silem xa-ông loh hadròng hadrech Silem. ");
INSERT INTO hre_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Aih 'bài hadròng hadrech Nep-ta-li, i 45.400 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","'Màng aih ta Is-ra-ên dìq dŏng ca mangai jah ti rèn, aih 601.730 ngai. ");
INSERT INTO hre_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Taneh jah axong ca wì haq broq xôxech tiaq dèh jàn bàc loq biaq. ");
INSERT INTO hre_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Hadròng hadrech leq ma cràm, èh jah taneh bàc. Hadròng hadrech leq 'biaq, èh jah 'biaq taneh. Rìm hadròng hadrech jah nhàn taneh tiaq dèh sôq jàn wì ma khoi achìh 'mùt hiniq. ");
INSERT INTO hre_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Wì pàih panàih đòiq axong taneh. Rìm phàn i hiniq rìm hadròng hadrech. ");
INSERT INTO hre_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Tiaq bìac pàih panàih đòiq axong xôxech ca rìm hadròng hadrech tiaq dèh sôq jàn 'biaq, bàc.” ");
INSERT INTO hre_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Mangai Lêwi hadai jah ti rèn tình tang hadròng hadrech: Enh Getsôn xa-ông loh hadròng hadrech Getsôn. Enh Kêhat xa-ông loh hadròng hadrech Kêhat. Enh Ma-ra-ri xa-ông loh hadròng hadrech Mê-ra-ri. ");
INSERT INTO hre_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","'Bài hadròng hadrech ma 'noiq ŏi ta hadròng hadrech Lêwi: Hadròng hadrech Lipni, hadròng hadrech Hêprôn, hadròng hadrech Mahli, hadròng hadrech Musi, hadròng hadrech Côra. Kêhat xa-ông Amram. ");
INSERT INTO hre_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Lêwi jò ŏi ta Aicàp, xa-ông mòiq ngai con cadrì hiniq Jô-kê-bêt. Amram yŏc Jô-kê-bêt xa-ông loh Arôn, Môise wa mòiq ngai con cadrì hiniq haq Mi-ri-am. ");
INSERT INTO hre_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Arôn xa-ông Nađap, A-bi-hu, Ê-li-a-xa wa I-tha-ma. ");
INSERT INTO hre_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Mahaq Nađap wa A-bi-hu cachìt jò ma am ùnh crài enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Dìq dŏng 'bài gu calô ŏi ta hadròng hadrech Lêwi, enh mòiq khê dang tŏc jah 23.000 ngai. Wì ùh i ti rèn pajùm jàn Is-ra-ên taiq ùh i xôxech am ca wì haq. ");
INSERT INTO hre_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Aih bìac ti rèn ta tamang Moap pah tau ca cròng diac Jôđan, ta jang ca Jê-ri-cô. ");
INSERT INTO hre_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ta sôq mangai cô, ùh i hiniq mòiq ngai leq ma Môise wa Arôn ma ti rèn ta braih càn Sinai. ");
INSERT INTO hre_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ma jah 'màng aih Chuaq i doi ca 'bài mangai ma adroi aih: “Wì haq phai cachìt ta braih càn”, 'màng aih ùh i mangai leq ŏi rìh enh gùng ca Calep, con calô Jê-phu-neh wa Jôsuê con calô Nun. ");
INSERT INTO hre_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Xê-lô-phat i padam ngai con cadrì: Mahlah, Noah, Hotlah, Mincah, wa Ti-ri-xah. Xê-lô-phat haq con Hêphê, xau Ga-la-at, xau chi Maki, xau chô Ma-na-se, ŏi ta hadròng hadrech Ma-na-se. Ma-na-se haq con Jôsep. ");
INSERT INTO hre_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","'Bài con cadrì Xê-lô-phat lam trùh ti Môise wa pajàu Ê-li-a-xa, wa enh ngìa mangai broq gàu dìq ca jàn đang ŏi jang 'màng Hnem Traiq Cùh Waiq; wì haq doi: ");
INSERT INTO hre_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Baq nhèn khoi cachìt ta nòi braih càn, ùh xài taiq haq tiaq wì Côra yòng tajraq hlài ca Chuaq, mahaq haq cachìt dèh ca tôiq lôi; haq ùh i con calô. ");
INSERT INTO hre_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Taiq ùh i con calô ma jah baq nhèn ep cađac hiniq haq loh khoi ca hadròng hadrech haq 'mòh? 'Màng aih xìn am nhèn nhàn phàn xôxech dèh ti 'bài dùch, 'bài mìh nhèn.” ");
INSERT INTO hre_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Môise anoi hlài bìac cô ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Chuaq doi ca haq: ");
INSERT INTO hre_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Wì con cadrì Xê-lô-phat doi troq. Axong ca wì haq mòiq phàn taneh đòiq wì haq broq xôxech dèh ti dùch wa mìh wì haq, aih phàn ma axong ca baq wì haq. ");
INSERT INTO hre_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Ìh hadai doi ca jàn Is-ra-ên: Tàng i mangai leq cachìt ma ùh i ca con calô, phai axong phàn aih ca 'bài con cadrì cla haq. ");
INSERT INTO hre_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Tàng mangai aih ùh i ca con cadrì, èh jao phàn xôxech ca 'bài oh daq mangai aih. ");
INSERT INTO hre_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Tàng ùh i ca oh daq, èh jao ca 'bài dùch wa mìh. ");
INSERT INTO hre_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Tàng ùh i ca dùch loq mìh, èh ìh jao phàn xôxech ca oh daq ma haten. Cô ranenh broq ca jàn Is-ra-ên, troq troi Chuaq ma khoi doi ca Môise.” ");
INSERT INTO hre_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Atìq ca aih, Chuaq doi ca Môise: “Ìh tŏc ta wang A-ba-rim ngan hnoq taneh Au ma am ca Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ngan hi gêh ìh hadai hlài ti Boc yaq troi Arôn, daq ìh ma khoi hlài. ");
INSERT INTO hre_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Ma jah 'màng aih ta nòi braih càn Xin, pì khoi ùh iu bàu Au wa ùh padèch hadròih Au enh ngìa ca jàn wì haq tarahen ca bìac taneh diac.” (Cô diac Mê-ri-ba ŏi Cađê, ta braih Xin.) ");
INSERT INTO hre_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Môise doi ca Chuaq: ");
INSERT INTO hre_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Waiq Chuaq, Ìh broq Boc Plình da mahua yiang rìm ngai, xìn Ìh patô mòiq ngai đòiq wèq cwìang mangai jàn, ");
INSERT INTO hre_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","aih mòiq ngai ŏi ta'ne wì haq đòiq ajèn wì loh wa 'ràng wì mùt, đòiq ca jàn da Chuaq ùh tìah ca trìu ùh i ca mangai ban.” ");
INSERT INTO hre_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Chuaq tèu Môise: “Ràih Jôsuê, con calô da Nun, mangai i Yiang Hadròih ŏi ta haq. Ìh phai đòiq tì achac haq. ");
INSERT INTO hre_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ìh 'ràng haq yòng enh ngìa ca pajàu Ê-li-a-xa wa dìq dŏng ca mangai jàn. Enh ngìa ca wì haq, ìh jao bìac broq ca haq. ");
INSERT INTO hre_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ìh jah jao am mòiq phàn cwìang da ìh ca haq, 'màng aih dìq ca jàn Is-ra-ên jah iu tiaq bàu haq. ");
INSERT INTO hre_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Haq phai trùh yòng enh ngìa ca pajàu Ê-li-a-xa. Pajàu Ê-li-a-xa phai yŏc Urim đòiq waiq bòch Chuaq tình 'màng leq. Ìh wa dìq ca mangai jàn Is-ra-ên phai broq tiaq Au ta rìm bìac.” ");
INSERT INTO hre_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","'Màng aih Môise broq tìah troi Chuaq khoi thê. Haq 'ràng Jôsuê trùh yòng enh ngìa pajàu Ê-li-a-xa wa dìq dŏng ca jàn. ");
INSERT INTO hre_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Haq đòiq tì ti chac Jôsuê wa jao bìac broq ca haq troi bàu Chuaq ma khoi thê. ");
INSERT INTO hre_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Doi ca jàn Is-ra-ên bàu thê cô: ‘Pì phai hmàng am tŏc ca Au troq jò ma pajaq 'bài ngè tadreo da Au, wa 'bài ngè caq da Au xam ùnh am tŏc, i hòi xua thùm lem manoh Au.’ ");
INSERT INTO hre_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","'Màng aih ìh doi ca wì haq: ‘Cô ngè tadreo bùh xam ùnh am atŏc ca Boc Plình: Rìm hì am baiq toq trìu calô, bu mòiq hanam, ùh i ca teo xìt leq, broq ngè tadreo bùh. ");
INSERT INTO hre_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mòiq toq ìh am daxroq, mòiq toq ìh am jò xèq dradrìch, ");
INSERT INTO hre_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","hi khoi lè dèch am 'mau mì, aih phai i mòiq kìq dàc 'mau mì 'yêh alôn ca mòiq lìt dàu ôliu pêh xam apao. ");
INSERT INTO hre_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Aih ngè tadreo bùh rìm hì khoi jah pajaq ta wang Sinai, ngè tadreo bùh xam ùnh am atŏc, i hòi xua thùm lem manoh Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Enh gùng ca aih, am pajùm ti rìm trìu con, mòiq lè dèch am dahwèq ôq xam mòiq lìt alac plì nho, èh ùc alac aih ta ca'bŏng tadreo enh ngìa ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Jò xèq dradrìch hadai am mòiq toq trìu con pajùm ti lè dèch am 'mau mì wa lè dèch am dahwèq ôq daxroq; dìq ngè tadreo am atŏc xam ùnh i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Rìm Hì Sabat, phai am baiq toq trìu con calô bu mòiq hanam, ùh i ca teo xìt leq, xam baiq kìq dàc 'mau mì 'yêh alôn ti dàu, aih lè dèch am broq dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Cô ngè tadreo bùh am rìm Hì Sabat, enh gùng ca ngè tadreo bùh rìm hì wa lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Rìm gàu khê, phai am ngè tadreo bùh ca Chuaq baiq toq 'bo calô bu chuai, mòiq toq trìu calô wa tapèh toq trìu con bu mòiq hanam, ùh i ca teo xìt leq; ");
INSERT INTO hre_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","lè dèch am 'mau mì xam piq lìt dàc 'mau mì alôn ca dàu pajùm ca mòiq toq 'bo, wa baiq kìq lìt dàc 'mau mì alôn ti dàu pajùm ti mòiq toq trìu. ");
INSERT INTO hre_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Phai i mòiq kìq dàc 'mau mì 'yêh alôn ca mòiq lìt dàu đòiq broq lè dèch am 'mau mì pajùm ti rìm toq trìu con, aih ngè tadreo bùh xam ùnh am atŏc i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Pajùm ti mòiq toq 'bo, phai broq lè dèch am ngè ôq da wì haq, aih baiq lìt alac, èh pajùm ti mòiq toq trìu calô, phai am yi hnao mòiq lìt alac, hi khoi pajùm ti mòiq trìu con phai i mòiq lìt alac. Cô ngè tadreo bùh baxèm rìm khê ta hanam. ");
INSERT INTO hre_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Enh gùng ca ngè tadreo bùh am rìm hì, pajùm ti lè dèch am dahwèq ôq, phai am atŏc ca Chuaq, mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài dèh tôiq. ");
INSERT INTO hre_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Èh hì 14, khê mòiq, phai wèq Lè Lam Cwa da Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ta hì 15 khê cô, wì caq lè hiniang, aih caq 'benh ùh tah blo tapèh hì. ");
INSERT INTO hre_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Hì ma baxèm pì phai tagop hlài đòiq cùh waiq Chuaq; hì aih ùh mangai leq jah broq bìac cleq. ");
INSERT INTO hre_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Pì phai am ca Chuaq ngè tadreo xam ùnh, aih ngè tadreo bùh baiq toq 'bo calô bu chuai, mòiq toq trìu calô wa tapèh toq trìu con bu mòiq hanam ùh i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Pajùm ti lè dèch am 'mau mì, pì phai am piq kìq dàc 'mau mì 'yêh alôn wa dàu, piq kìq pajùm ca 'bo calô wa ti trìu calô baiq kìq, ");
INSERT INTO hre_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Mòiq kìq dàc pajùm ti mòiq toq trìu broq rìm tapèh toq trìu 'màng aih. ");
INSERT INTO hre_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Hadai am mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài dèh tôiq. ");
INSERT INTO hre_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Enh gùng ca ngè tadreo bùh rìm hì jò daxroq, pì phai am 'bài ngè tadreo cô. ");
INSERT INTO hre_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ta tapèh hì, hì leq xôq am ngè tadreo bùh 'màng aih, am atŏc i hòi xua thùm ca Chuaq. 'Bài ngè tadreo aih jah am pajùm ti ngè tadreo bùh rìm hì pajùm ti lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Hì tapèh, hadai tagop hlài đòiq cùh waiq Chuaq, ùh i ca mangai leq jah abroq hì aih. ");
INSERT INTO hre_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Hì gàu mùa, hì baxèm ta Lè Hiniang Da 'Bài Tùang, jò am atŏc ca Chuaq lè dèch am 'mau mì ma neo, pì hadai phai tagop hlài đòiq cùh waiq Chuaq, ùh i ca mangai leq jah broq cleq ta hì aih. ");
INSERT INTO hre_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Pì phai atŏc am baiq toq 'bo calô bu chuai, mòiq toq trìu calô, wa tapèh toq trìu con bu mòiq hanam, broq ngè tadreo bùh am atŏc i hòi xua thùm ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","wa pajùm ti mòiq toq 'bo, am mòiq lè dèch am 'mau mì, aih piq kìq dàc 'mau mì 'yêh alôn wa dàu, wa pajùm ti con trìu calô baiq kìq, ");
INSERT INTO hre_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","wa broq am tapèh toq trìu con, mòiq kìq dàc ti rìm toq trìu con, ");
INSERT INTO hre_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Pì hadai phai am mòiq toq con bubi calô đòiq broq ngè tadreo rŏt hlài dèh tôiq. ");
INSERT INTO hre_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Enh gùng ca ngè tadreo bùh rìm hì, wa lè dèch am 'mau mì, phai am ngè tadreo cô pajùm lè dèch am ngè ôq. Dìq ngè tadreo phai ùh i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Wop hì mòiq, khê tapèh, pì phai tagop hlài đòiq cùh waiq Chuaq, ùh i ca mangai leq jah broq bìac cleq trom hì aih. Hì aih hì pì hlôi ken. ");
INSERT INTO hre_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ngè tadreo bùh dèch am atŏc i hòi xua thùm ca Chuaq, aih mòiq toq 'bo calô bu chuai, mòiq toq trìu calô, wa tapèh toq trìu con calô bu mòiq hanam ùh i ca teo xìt leq. ");
INSERT INTO hre_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Pajùm ti 'bo phai i lè dèch am 'mau mì, aih xam piq kìq dàc 'mau mì 'yêh alôn wa dàu, èh pajùm ti trìu calô phai am baiq kìq, ");
INSERT INTO hre_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ti rìm toq trìu con, mòiq kìq. ");
INSERT INTO hre_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Hadai am mòiq toq bubi calô broq ngè tadreo rŏt hlài enh tôiq lôi ca pì. ");
INSERT INTO hre_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","'Bài ngè tadreo cô phai am ti ngè tadreo bùh dèch am rìm gàu khê pajùm lè dèch am 'mau mì; ngè tadreo bùh rìm hì ti lè dèch am 'mau mì wa lè dèch am ngè ôq tìah ma khoi pajaq. Aih 'bài ngè tadreo yŏc ùnh am atŏc i hòi xua thùm ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Hì 10 khê tapèh, pì phai tagop hlài đòiq cùh waiq Chuaq. Rìm ngai phai rôn ca acaq wa ùh jah broq bìac cleq. ");
INSERT INTO hre_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Phai broq ngè tadreo bùh am atŏc i hòi xua thùm ca Chuaq, aih mòiq toq 'bo calô bu chuai, mòiq toq trìu calô wa tapèh toq trìu con calô bu mòiq hanam ùh i ca teo xìt leq, ");
INSERT INTO hre_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","wa pajùm ti 'bo, i lè dèch am 'mau mì; ta aih piq kìq dàc 'mau mì alôn xam dàu. Ti trìu calô, baiq kìq, ");
INSERT INTO hre_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ti rìm toq trìu con, i mòiq kìq; ");
INSERT INTO hre_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","hadai am mòiq toq bubi calô broq ngè tadreo rŏt hlài enh tôiq lôi, ngè tadreo cô jah am tam ti ngè tadreo hì rŏt hlài enh tôiq; ngè tadreo bùh hloi hloi pajùm ti lè dèch am 'mau mì wa lè dèch am ngè ôq. ");
INSERT INTO hre_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Hì 15, khê tapèh, pì phai tagop hlài đòiq cùh waiq Chuaq, ùh i cabô jah broq cleq trom hì aih. Mangai jàn phai broq lè hiniang tapèh hì am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Pì phai broq ngè tadreo bùh am atŏc i hòi xua thùm ca Chuaq, aih xam 13 toq 'bo calô bu chuai, baiq toq trìu calô, wa 14 toq trìu con calô bu mòiq hanam, ùh i ca teo xìt leq; ");
INSERT INTO hre_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","wa pajùm ti rìm toq 'bo phai am lè dèch am 'mau mì, aih xam piq kìq dàc 'mau mì 'yêh alôn ca dàu, ti rìm toq trìu calô, baiq kìq, ");
INSERT INTO hre_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ti mòiq toq con trìu mòiq kìq. ");
INSERT INTO hre_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Hadai am mòiq toq bubi calô broq ngè tadreo rŏt hlài enh tôiq lôi, enh gùng ca ngè tadreo bùh rìm hì; lè dèch am 'mau mì wa lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Hì ma baiq phai am 12 toq 'bo calô, baiq toq trìu calô wa 12 toq trìu con calô bu mòiq hanam, ùh i ca teo xìt leq; ");
INSERT INTO hre_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","pajùm ti 'bo, trìu calô wa trìu con, i lè dèch am 'mau mì wa lè dèch am ngè ôq tiaq dèh sôq ma khoi pajaq; ");
INSERT INTO hre_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","hadai am mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài dèh enh tôiq, enh gùng ca ngè tadreo bùh rìm hì pajùm lè dèch am 'mau mì wa lè dèch am ngè ôq. ");
INSERT INTO hre_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Hì ma piq am atŏc 11 toq 'bo calô bu chuai, baiq toq trìu calô wa 14 toq trìu con calô bu mòiq hanam, ùh i ca teo xìt leq; ");
INSERT INTO hre_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","pajùm ti 'bo, trìu calô wa trìu con, i lè dèch am 'mau mì wa lè dèch am dahwèq ôq tiaq dèh sôq ma khoi pajaq; ");
INSERT INTO hre_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","hadai am mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài dèh enh tôiq lôi, enh gùng ca ngè tadreo bùh rìm hì, pajùm lè dèch am 'mau mì wa lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Hì ma pôn, am atŏc 10 toq 'bo calô bu chuai, baiq toq trìu calô wa 14 toq trìu con calô bu mòiq hanam ùh i ca teo xìt leq, ");
INSERT INTO hre_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","pajùm ti 'bo, trìu calô wa trìu con, i lè dèch am 'mau mì wa lè dèch am ngè ôq tiaq dèh sôq ma khoi pajaq; ");
INSERT INTO hre_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","hadai am mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, enh gùng ca ngè tadreo bùh rìm hì, pajùm lè dèch am 'mau mì wa lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Hì ma padam, phai am hachìn toq 'bo calô, baiq toq trìu calô wa 14 toq trìu con bu mòiq hanam, ùh i ca teo xìt leq; ");
INSERT INTO hre_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","pajùm ti 'bo, trìu calô wa trìu con, i lè dèch am 'mau mì wa lè dèch am ngè ôq tiaq dèh sôq ma khoi pajaq; ");
INSERT INTO hre_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","hadai am mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, enh gùng ca ngè tadreo bùh rìm hì, pajùm lè dèch am 'mau mì wa lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Hì ma tadràu, phai am rahem toq 'bo calô bu chuai, baiq toq trìu calô wa 14 toq trìu con bu mòiq hanam, ùh i ca teo xìt leq; ");
INSERT INTO hre_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","pajùm ti 'bo, trìu calô wa trìu con, hadai phai i lè dèch am 'mau mì wa lè dèch am ngè ôq tiaq sôq ma khoi pajaq; ");
INSERT INTO hre_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","hadai am mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, enh gùng ca ngè tadreo bùh rìm hì, pajùm lè dèch am 'mau mì wa lè dèch am ngè ôq. ");
INSERT INTO hre_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Hì tapèh phai am atŏc tapèh toq 'bo calô, baiq toq trìu calô wa 14 toq trìu con bu mòiq hanam, ùh i ca teo xìt leq; ");
INSERT INTO hre_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","pajùm ti 'bo, trìu calô wa trìu con, i lè dèch am 'mau mì wa lè dèch am ngè ôq tiaq dèh sôq ma khoi pajaq; ");
INSERT INTO hre_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","hadai am mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, enh gùng ca ngè tadreo bùh rìm hì, pajùm lè dèch am 'mau mì wa lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Hì ma rahem, phai i tagop hadròih, ùh i ca mangai leq jah broq bìac ma trap lep. ");
INSERT INTO hre_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mahaq pì phai broq ngè tadreo bùh am atŏc i hòi xua thùm ca Chuaq, aih mòiq toq 'bo calô, mòiq toq trìu calô wa tapèh toq trìu con calô bu mòiq hanam ùh i ca teo xìt leq; ");
INSERT INTO hre_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","pajùm ti 'bo, trìu calô wa trìu con, i lè dèch am 'mau mì wa lè dèch am ngè ôq tiaq dèh sôq ma khoi pajaq; ");
INSERT INTO hre_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","hadai am mòiq toq bubi calô đòiq broq ngè tadreo rŏt hlài enh tôiq lôi, enh gùng ca ngè tadreo bùh rìm hì, pajùm lè dèch am 'mau mì wa lè dèch am dahwèq ôq. ");
INSERT INTO hre_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Aih 'bài ngè tadreo am atŏc ca Chuaq ta 'bài hì lè ma khoi pajaq. Ta aih i ngè tadreo bùh, pajùm lè dèch am 'mau mì, lè dèch am ngè ôq wa ngè tadreo waiq catèm. Pì am đòiq wèq dèh bàu hùaq pachac loq to am.’ ” ");
INSERT INTO hre_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Môise anoi hlài ca jàn Is-ra-ên rìm bìac Chuaq ma khoi thê. ");
INSERT INTO hre_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Môise anoi hlài ca mangai ma broq gàu jàn Is-ra-ên, doi: “Cô bàu ma Chuaq khoi thê: ");
INSERT INTO hre_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Tàng i mòiq ngai leq pachac broq bìac cleq ca Chuaq, èh phai wèq dèh bàu ma khoi hùaq pachac aih, haq ùh jah blòq bàu, mahaq ep broq tiaq bàu ma khoi capoch 'noh. ");
INSERT INTO hre_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Jò mòiq ngai con cadrì ŏi rìh dèh ta hnem baq i bàu hùaq pachac cleq ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","èh baq haq loq tàng bàu haq ma pachac aih, mahaq ùh doi cleq, èh mangai cadrì aih phai broq tiaq dèh bàu haq ma khoi hùaq pachac aih. ");
INSERT INTO hre_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Tàng mangai baq aih ùh am dèh con cadrì broq gêh bìac haq khoi pachac wop hì haq ma khoi pachac aih, èh haq ùh hìaq ep broq tiaq bàu pachac aih. Chuaq jah baxŏng tôiq ca haq, ma jah 'màng aih taiq baq haq ùh am haq broq bìac aih. ");
INSERT INTO hre_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Mahaq tàng mangai cadrì yŏc ŏng atìq ca haq 'noh bàu pachac loq khoi capoch bàu pachac cleq jò manoh hèm ùh troq, ");
INSERT INTO hre_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","èh ŏng haq tàng bàu pachac aih, mahaq ùh doi cleq ta hì ma haq khoi tàng, èh mangai cadrì aih phai broq tiaq dèh bàu haq ma khoi hùaq pachac aih. ");
INSERT INTO hre_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mahaq tàng ŏng haq ùh am haq broq bìac aih pàng hì ŏng haq ma loq, mangai ŏng aih 'noh đac bàu hùaq pachac aih, 'màng aih bàu pachac da mai haq ma khoi capoch 'noh enh hacùng jò ùh hèm troq, ùh hìaq ep broq. Chuaq jah baxŏng tôiq ca haq. ");
INSERT INTO hre_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Bàu pachac da mangai cadrì hadrô loq mangai cadrì cađac ŏng, rìm bìac cleq ma khoi capoch 'noh, èh ep wèq dèh bàu. ");
INSERT INTO hre_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Tàng i mòiq ngai gu cadrì khoi hùaq pachac jò haq 'nang ŏi dèh hnem ŏng, ");
INSERT INTO hre_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","èh ŏng haq tàng mai haq i bàu pachac, mahaq ŏng haq ùh capoch cleq, ùh tàt haq broq bìac aih, èh ep wèq dèh bàu. ");
INSERT INTO hre_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Mahaq tàng ŏng haq 'noh đac bàu hùaq pachac aih pàng hì ŏng haq ma khoi tàng, èh mai haq ùh ep wèq dèh bàu, Chuaq jah baxŏng tôiq ca haq, ma jah 'màng aih ŏng haq khoi 'noh đac bàu pachac aih. ");
INSERT INTO hre_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","'Màng aih mangai ŏng i cwìang am, loq raliang đac bàu dèh mai khoi pachac đòiq paha'neq ca dađeh. ");
INSERT INTO hre_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Tàng mangai ŏng haq ùh capoch cleq hì haq ma neo tàng bàu pachac da mai haq, èh ŏng mòiq manoh dì tiaq bàu pachac dèh mai. ");
INSERT INTO hre_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mahaq tàng ŏng haq khoi tàng, èh gòm dùnh hì men doi đòiq raliang đac bàu pachac aih, èh mangai ŏng ep pòq yŏc ca dađeh lôi ma mai haq ma khoi pachac aih.” ");
INSERT INTO hre_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Cô 'bài ranenh Chuaq anoi ca Môise, bìac ta'ne ŏng wa mai, baq wa con, jò con 'nhòq yŏc ŏng. ");
INSERT INTO hre_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Jêh chau jàn Ma-đi-an am ca jàn Is-ra-ên beq, èh ìh jah hlài ti boc yaq ìh.” ");
INSERT INTO hre_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","'Màng aih Môise doi ca jàn: “Pì phai padon 'bài ranac tajêh đòiq lam tajêh ca jàn Ma-đi-an, broq tiaq bàu thê tabroq hlài da Chuaq, ");
INSERT INTO hre_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","mòiq hadròng hadrech phai ràih 1.000 lình đòiq loh tajêh.” ");
INSERT INTO hre_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","'Màng aih rìm hadròng hadrech ta jàn Is-ra-ên, mòiq hadròng hadrech phai ràih 1.000 ngai, èh jah i 12.000 mangai padon tôm ranac đòiq loh tajêh. ");
INSERT INTO hre_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Môise thê 12.000 ngai aih loh ta nòi tajêh, aih 1.000 lình da mòiq hadròng hadrech, ti Phi-nê-hat con pajàu Ê-li-a-xa, 'ràng tiaq 'bài ranac hadròih wa wê ken đòiq hlôi. ");
INSERT INTO hre_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","'Màng aih, wì haq jêh jàn Ma-đi-an tiaq bàu thê da Chuaq, jêh dŏng dìq 'bài mangai calô, ");
INSERT INTO hre_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","xam padam toq bùa Ma-đi-an: Êwi, Rêkem, Xurò Hurò wa Rêba, Ba-la-am, con calô Bêô, hadai 'bìq jêh cachìt xam chang gùm. ");
INSERT INTO hre_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Mangai Is-ra-ên rùp gu cadrì, con 'yoh, wa yŏc da wì haq dìq 'bo, trìu wa cùng hang. ");
INSERT INTO hre_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Èh wì haq bùh dŏng dìq phôq, 'bài traiq da mangai Ma-đi-an. ");
INSERT INTO hre_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Wì haq yŏc dìq cùng hang, mangai wa ngè aban. ");
INSERT INTO hre_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Wì haq 'ràng dŏng dìq mangai ma khoi rùp wa cùng hang wì aih ca Môise, pajàu Ê-li-a-xa wa jàn Is-ra-ên 'nang ŏi ta tamang Moap kenh diac Jôđan, ta jang ca Jê-ri-cô. ");
INSERT INTO hre_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Môise, pajàu Ê-li-a-xa wa dìq ca mangai broq gàu jàn Is-ra-ên, loh enh gùng ca traiq gòm đìh yŏc wì haq. ");
INSERT INTO hre_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Môise dìq jaq nòih ca 'bài mangai ma wèq lình, 'bài mangai ma wèq cwìang bình hrinh wa bình ngŏng lình haq, enh nòi tajêh khoi hlài. ");
INSERT INTO hre_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Môise bòch wì haq: “Gleq pì ma đòiq 'bài gu cadrì cô rìh? ");
INSERT INTO hre_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Wì haq raq 'bài mangai ma khoi broq tiaq bàu Ba-la-am adràc mangai Is-ra-ên cađac Chuaq cùh waiq dua 'mù ta Pêo, taiq 'màng aih dài jàn da Chuaq ma jah glàm bìac ranàc 'mèq. ");
INSERT INTO hre_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Manàiq cô phai jêh dŏng dìq con 'yoh calô wa 'bài con cadrì leq ma khoi cùi ti gu calô. ");
INSERT INTO hre_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mahaq pì đòiq dìq ca gu adrùh ma ŏi xriu am ca dađeh. ");
INSERT INTO hre_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Khoi èh 'bài mangai leq ma khoi jêh mangai loq khoi bèq ngè cachìt, èh phai ŏi đò enh gùng ca traiq tapèh hì. Hì ma piq wa hì ma tapèh, phai baxròih dađeh wa mangai pì ma khoi rùp. ");
INSERT INTO hre_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Pì hadai phai baxròih dèh eo yôh, 'bài ngè xam akia, ngè xàc bubi wa dìq ngè xam long.” ");
INSERT INTO hre_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Hi khoi pajàu Ê-li-a-xa doi ca 'bài lình: “Cô ranenh Chuaq ma khoi doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Wang, 'bac, đùng gam, mem, wa tanàm, ");
INSERT INTO hre_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","wa dìq ca ngè ùh cheo xam ùnh, phai bùh dìq ta ùnh đòiq broq hadròih, èh hadai phai yŏc diac broq hadròih dìq ngè aih. Mahaq ngè leq ma ùh chìuq ùnh, èh broq baxròih toq xam diac đòiq broq hreo. ");
INSERT INTO hre_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Hì ma tapèh, atìq ca pì rùh dèh eo yôh, èh pì khoi jah hreo wa jah mùt ta traiq.” ");
INSERT INTO hre_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ìh wa pajàu Ê-li-a-xa wa mangai broq gàu ta cadraq da hadròng hadrech, phai achìh hiniq rìm ngè pì ma jah da mangai Ma-đi-an, xam mangai wa ngè aban. ");
INSERT INTO hre_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Khoi èh axong loh baiq phàn. Phai am mòiq ha'ne dahwèq aih ca mangai lình ma khoi loh tajêh, èh mòiq ha'ne dahwèq ca mangai jàn. ");
INSERT INTO hre_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Ta phàn ma jah 'bài lình, phai yŏc mòiq phàn 500 đòiq dèch am ca Chuaq, 'nhac ca mangai, loq 'bo, lùa loq trìu, 'ràng am ca Chuaq. ");
INSERT INTO hre_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","'Ràng phàn ma jah aih am ca Chuaq, jao ca pajàu Ê-li-a-xa. ");
INSERT INTO hre_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ta phàn da jàn, phai yŏc mòiq phàn padam jàt đòiq dèch am ca Chuaq: Mangai, 'bo, lùa loq trìu, jao ca mangai Lêwi, wì ma patìh wa ngan wèq Hnem Traiq Cùh Waiq da Chuaq.” ");
INSERT INTO hre_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","'Màng aih Môise wa pajàu Ê-li-a-xa broq tiaq rìm bìac Chuaq ma thê Môise. ");
INSERT INTO hre_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Sôq ngè 'bài lình Is-ra-ên ma jah da jàn Ma-đi-an, aih 675.000 toq trìu, ");
INSERT INTO hre_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72.000 toq 'bo, ");
INSERT INTO hre_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61.000 toq lùa, ");
INSERT INTO hre_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","wa 32.000 ngai gu adrùh ŏi xriu. ");
INSERT INTO hre_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","'Màng aih mòiq ha'ne ma jah 'bài lình, aih 337.500 toq trìu wa bubi. ");
INSERT INTO hre_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Phàn dèch am ca Chuaq, 675 toq trìu; ");
INSERT INTO hre_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","wa 36.000 toq 'bo. Phàn am ca Chuaq, 72 toq; ");
INSERT INTO hre_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30.500 toq lùa. Phàn am ca Chuaq, 61 toq; ");
INSERT INTO hre_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","wa 16.000 gu adrùh xriu. Phàn am ca Chuaq, 32 ngai. ");
INSERT INTO hre_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Môise jao ca pajàu Ê-li-a-xa dìq phàn ma am ca Chuaq, troi bàu Chuaq ma khoi tanap ca haq. ");
INSERT INTO hre_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Mòiq ha'ne cùng hang ma jah jàn, Môise lah axong phàn da wì haq enh phàn da mangai lình; ");
INSERT INTO hre_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Phàn ha'ne cùng hang da jàn, aih 337.500 toq trìu wa bubi; ");
INSERT INTO hre_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36.000 toq 'bo; ");
INSERT INTO hre_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30.500 toq lùa; ");
INSERT INTO hre_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","wa 16.000 gu adrùh xriu. ");
INSERT INTO hre_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Enh mòiq ha'ne cùng hang am ca jàn, Môise yŏc mòiq phàn padam jàt ngè aih, xam mangai wa ngè aban, jao am ca mangai Lêwi, wì ma patìh broq bìac wèq Hnem Traiq Cùh Waiq ca Chuaq, troi bàu Chuaq ma khoi tanap ca haq. ");
INSERT INTO hre_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Èh dìq ca 'bài cwan ma wèq cwìang 'bài lình trùh glàm Môise, ");
INSERT INTO hre_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","doi ca haq: “Nhèn hapŏng ìh, khoi rèn dèh lình ma loh tajêh, wa nhèn hnoq ùh i hnhung mòiq ngai leq! ");
INSERT INTO hre_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","'Màng aih, enh phàn da nhèn, nhèn i 'ràng 'bài ngè anì xam wang nhèn ma jah: Maih acŏng, caxi 'bac aranŏng, canhàng, hatai, nhèn am ca Chuaq đòiq broq lè rŏt hlài dèh tôiq.” ");
INSERT INTO hre_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Môise wa pajàu Ê-li-a-xa nhàn sôq wang wa dìq ngè aih, ");
INSERT INTO hre_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","dìq dŏng ngè wang, 'bài cwan ma wèq cwìang bình hrinh bình ngŏng lình, jah am ca Chuaq, aih: 200 kìq. ");
INSERT INTO hre_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","'Bài lình dìq i yŏc 'bài ngè wì haq ma tŏch jò tajêh, đòiq crài ca dađeh. ");
INSERT INTO hre_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","'Màng aih, Môise wa pajàu Ê-li-a-xa nhàn wang enh tì 'bài cwan ma wèq cwìang bình ngŏng bình hrinh lình, hi khoi 'ràng đòiq ta Hnem Traiq Cùh Waiq, đòiq Chuaq hmàng hloi ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","'Màng aih con xau da hadròng hadrech Rubên wa con xau Gat i bàc lù ngè aban. Jò hnoq taneh Jaxe wa Ga-la-at lem ca ban 'bài ngè aban, ");
INSERT INTO hre_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","wì haq chaq glàm Môise, pajàu Ê-li-a-xa wa 'bài mangai ma wèq cwìang ta jàn, wì doi: ");
INSERT INTO hre_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“A-ta-rôt, Đibôn, Jaxe, Nimra, Hêtbôn, Ê-lê-a-lê, Sêbam, Nêbô wa Bê-ôn, ");
INSERT INTO hre_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","'bài gùng Ma-đi-an Chuaq khoi jêh yŏc enh ngìa ca jàn Is-ra-ên, dìq jaq lem ca ban ngè aban wa nhèn bàc ngè aban. ");
INSERT INTO hre_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Tàng nhèn khoi broq lem manoh ca pì, xìn am taneh cô ca nhèn đòiq broq xôxech nhèn, ùh hìaq ep lam cwa cròng diac Jôđan.” ");
INSERT INTO hre_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Môise bòch mangai Gat wa mangai Rubên: “Pì enh ha'ngui jò oh daq pì lam tajêh poh 'mòh? ");
INSERT INTO hre_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Gleq pì ma broq ca mangai Is-ra-ên loh ca hŏnh ta manoh, ùh enh lam cwa trùh ta gùng da Chuaq khoi pachac bàu hùaq am ca wì haq? ");
INSERT INTO hre_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ta Cađê Ba-nê-a boc yaq pì calah nèh hadai broq 'màng aih jò au thê wì lam ngan gùng Ca-na-an. ");
INSERT INTO hre_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Jò bu trùh ta thòng diac Êchcôn, wì haq khoi broq ca mangai Is-ra-ên hŏnh ta manoh, ùh enh trùh ta gùng da Chuaq khoi pachac bàu hùaq am ca wì haq. ");
INSERT INTO hre_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Ta hì aih, Chuaq nòih, pachac bàu doi: ");
INSERT INTO hre_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Dìq ca mangai ma loh enh Aicàp hì cô pàng 20 hanam dàng tŏc, dàng tŏc ùh i mangai leq jah hnoq gùng Au khoi pachac bàu hùaq am ca Ap-ra-ham, Isac wa Jacôp, taiq wì haq ùh broq tiaq bàu Au, ");
INSERT INTO hre_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","enh gùng ca Calep con calô da Jê-phu-neh, mangai Kê-nê-xit, wa Jôsuê con calô da Nun. Wa haq dìq ca manoh tiaq Chuaq.’ ");
INSERT INTO hre_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Boc Plình nòih ca Is-ra-ên taiq 'màng aih Haq thê wì lam manhaq ta đùng braih càn 40 hanam, trùh dìq ca 'nhòng ma broq dù enh ngìa ca Chuaq cachìt dŏng. ");
INSERT INTO hre_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“ 'Màng aih, manàiq cô, pì xinoi da mangai ma broq tôiq, adràc dabau thai dèh ca boc yaq broq ca Chuaq nòih ta ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Tàng pì cađac trong tiaq Chuaq, Chuaq đòiq dŏng dìq ca jàn Is-ra-ên ŏi hlài ta đùng braih càn, 'màng aih pì èh ma broq ca Is-ra-ên cachìt.” ");
INSERT INTO hre_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Wì haq trùh haten ca Môise, doi: “Nhèn xìn broq cadrong ngè aban wa broq phôq ca con caiq da nhèn ŏi ta cô, ");
INSERT INTO hre_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","mahaq khoi èh, nhèn wê ranac tajêh lam adroi ca jàn, trùh jò rìm ngai jah mùt dèh ta taneh cla. Jò aih cadraq nhèn jah rìh catèm ta phôq hagao hagình đòiq mangai jàn gùng aih ùh jah broq cleq ca con caiq da nhèn. ");
INSERT INTO hre_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nhèn ùh hlài ta hnem trùh jò leq rìm ngai mangai Is-ra-ên ma 'noiq dìq khoi jah nhàn dèh xôxech cla. ");
INSERT INTO hre_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Taiq nhèn khoi nhàn jah xôxech pah mat mahì loh da cròng diac Jôđan, taiq 'màng aih nhèn ùh jah nhàn xôxech leq pah tau ca cròng diac Jôđan.” ");
INSERT INTO hre_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Jò aih Môise doi ca wì haq: “Tàng oh daq broq troq 'màng aih, hi khoi oh daq wê ranac tajêh lam enh ngìa ca Chuaq, ");
INSERT INTO hre_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","tàng oh daq wê ranac tajêh lam cwa cròng diac Jôđan enh ngìa ca Chuaq, trùh jò Haq hnan dìq ca lình ma git ca pì lam, ");
INSERT INTO hre_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","hi khoi jò Chuaq khoi jah blah yŏc taneh, èh pì men jah hlài wa jah gêh dèh ca bìac broq ca Chuaq wa ca mangai Is-ra-ên. Enh ngìa ca Chuaq, jò aih taneh cô èh khoi jah dìq pì. ");
INSERT INTO hre_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Mahaq tàng pì ùh broq troq 'màng aih, pì khoi broq tôiq ca Chuaq. Hmàng oq, tôiq cô èh pì ep pòq. ");
INSERT INTO hre_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Manàiq cô pì broq phôq ca con caiq pì ŏi beq. Broq cadrong ca ngè aban, mahaq pì hmàng dèh ca bàu ma khoi pachac oq.” ");
INSERT INTO hre_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Mangai Gat wa Rubên tèu bàu Môise: “Nhèn hapŏng ìh joq 'nàng broq tiaq troq troi bàu ìh khoi tanap. ");
INSERT INTO hre_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Mai nhèn, con nhèn, wa ngè aban da nhèn èh ŏi ta cô ta 'bài phôq da Ga-la-at. ");
INSERT INTO hre_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Mahaq nhèn hapŏng da ìh, aih dìq ca mangai khoi padon ca wì haq ranac đòiq tajêh, èh cwa pah tau ca cròng diac Jôđan lam tajêh, tiaq bàu Chuaq da au khoi tanap.” ");
INSERT INTO hre_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Khoi ca aih, Môise pa'noh bàu thê ca pajàu Ê-li-a-xa, Jôsuê con calô da Nun, wa dìq ca mangai ma broq gàu ta 12 hadròng hadrech da Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Haq doi: “Tàng dìq ca mangai ma khoi jah padon ranac đòiq tajêh da hadrech da Gat wa Rubên, hadai cwa cròng diac Jôđan ti pì enh ngìa ca Chuaq, èh dìq ca gùng hi jah catèm, hi khoi pì am ca wì haq taneh ca Ga-la-at đòiq broq xôxech. ");
INSERT INTO hre_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Mahaq tàng wì haq ùh cwa diac lam ti pì đòiq tajêh, èh wì haq toq jah xôxech pajùm ti pì ta gùng Ca-na-an.” ");
INSERT INTO hre_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Mangai Gat wa mangai Rubên doi: “Bìac Chuaq khoi thê, nhèn hapŏng Chuaq joq 'nàng broq tiaq. ");
INSERT INTO hre_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nhèn jah wê ranac tajêh cwa cròng diac, mùt ta gùng Ca-na-an enh ngìa ca Chuaq, mahaq taneh nhèn jah đòiq broq xôxech, aih pah cô ca cròng diac Jôđan.” ");
INSERT INTO hre_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","'Màng aih Môise am ca hadròng hadrech da Gat, hadròng hadrech Rubên wa ha'ne ca hadròng hadrech da Ma-na-se, con Jôsep, taneh da Sihôn, bùa da A-mô-rit wa da Ot bùa Basan, wa dìq dŏng ca taneh gùng wa phôq wawenh ca aih. ");
INSERT INTO hre_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Mangai Gat broq hlài Đibôn, A-ta-rôt, A-rô-e, ");
INSERT INTO hre_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrôt Sôphan, Jaxe, Jô-bê-ha, ");
INSERT INTO hre_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bêt Nimra wa Bêt Haran aih 'bài phôq hagao hagình i pagia tap dan. Wì haq hadai broq bàc cadrong ngè aban. ");
INSERT INTO hre_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Mangai Rubên broq ta Hêtbôn, Ê-lê-a-lê, Ki-ri-a-tha-im, ");
INSERT INTO hre_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nêbô, Ba-an Mê-ôn ('bài hiniq cô 'bìq halìh hlài), wa Sipmah. Wì haq hiniq phôq ma neo da dìq phôq ma 'noiq wì broq. ");
INSERT INTO hre_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Con xau da Maki, con Ma-na-se, lam tablah yŏc Ga-la-at, hnan đac mangai A-mô-rit lam. ");
INSERT INTO hre_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","'Màng aih Môise am ca con xau Maki, con Ma-na-se, taneh Ga-la-at, èh wì haq rìh ŏi ta aih. ");
INSERT INTO hre_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jairò, con Ma-na-se, lam tablah yŏc 'bài phôq ma 'yoh, èh wì hiniq ca gùng aih Phôq da Jairò. ");
INSERT INTO hre_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nôbach tablah yŏc Kênat wa dìq plài haten ca aih, khoi èh hiniq ca gùng aih, Nôbach tiaq hiniq cla haq. ");
INSERT INTO hre_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Cô trong lam wa nòi jàn Is-ra-ên đòiq traiq jò wì haq loh khoi enh gùng Aicàp, lam tiaq dèh tang lù tiaq cwìang Arôn wa Môise ma wèq wì haq. ");
INSERT INTO hre_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Tiaq bàu thê da Chuaq, Môise achìh hlài trong lam wa hiniq rìm nòi wì đòiq traiq jò wì loh lam tiaq dèh tang lù. Cô trong lam wa 'bài nòi wì đòiq traiq. ");
INSERT INTO hre_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Jàn Is-ra-ên enh Ramse loh lam hì 15, khê mòiq. Mòiq hì atìq ca hì Lè Lam Cwa, wì haq tanuq lam enh ngìa ca jàn Aicàp, ");
INSERT INTO hre_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","jò mangai Aicàp aih 'nang catùh dèh 'bài con calô ramua Chuaq ma jêh đac, taiq Chuaq khoi hadrah baxa 'bài can kiac wì haq. ");
INSERT INTO hre_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Jò jàn Is-ra-ên lam khoi ca Ramse, wì haq đòiq traiq ta Sucôt. ");
INSERT INTO hre_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Enh Sucôt wì haq đòiq traiq ta Êtam, nòi acang braih càn. ");
INSERT INTO hre_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Enh Êtam wì haq tawìh hlài ta Phi-ha-hi-rôt, pah mat mahì loh Ba-an Xêphôn, wa đòiq traiq ta Mitđon. ");
INSERT INTO hre_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Enh Phi-ha-hi-rôt, wì lam cwa ta'ne diac raxìq mùt ta braih càn. Wì haq lam piq hì ta braih càn Êtam, hi khoi wì haq đòiq traiq ta Mara. ");
INSERT INTO hre_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Enh Mara wì lam ta Êlim, aih nòi i 12 toq tamŏc diac wa 70 xèm long rêq. Wì đòiq traiq ta aih. ");
INSERT INTO hre_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Enh Êlim wì lam đòiq traiq haten ca kenh Diac Raxìq Gòh. ");
INSERT INTO hre_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Enh Diac Raxìq Gòh wì haq đòiq traiq ta braih càn Sin. ");
INSERT INTO hre_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Wì haq lam enh braih càn Sin đòiq traiq ta Đapca. ");
INSERT INTO hre_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Enh Đapca wì haq đòiq traiq ta Aluc. ");
INSERT INTO hre_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Wì lam enh Aluc đòiq traiq ta Rê-phi-đim, nòi ùh i ca diac ôq. ");
INSERT INTO hre_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Wì haq lam enh Rê-phi-đim, èh đòiq traiq ta braih càn Sinai. ");
INSERT INTO hre_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Enh braih càn Sinai wì lam đòiq traiq ta Kiprôt Ha-tha-wa. ");
INSERT INTO hre_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Wì haq lam enh Kiprôt Ha-tha-wa, đòiq traiq ta Hat-sê-rôt. ");
INSERT INTO hre_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Wì haq lam enh Hat-sê-rôt, đòiq traiq ta Ritmah. ");
INSERT INTO hre_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Wì haq lam enh Ritmah, đòiq traiq ta Rimôn Perex. ");
INSERT INTO hre_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Wì haq lam enh Rimôn Perex, đòiq traiq ta Lipna. ");
INSERT INTO hre_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Wì haq lam enh Lipna, đòiq traiq ta Risah. ");
INSERT INTO hre_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Wì haq lam enh Risah, đòiq traiq ta Kê-hê-la-tha. ");
INSERT INTO hre_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Wì haq lam enh Kê-hê-la-tha, đòiq traiq ta wang Sêphe. ");
INSERT INTO hre_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Wì haq lam enh wang Sêphe, đòiq traiq ta Ha-ra-đa. ");
INSERT INTO hre_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Wì haq lam enh Ha-ra-đa, đòiq traiq ta Mac-hê-lôt. ");
INSERT INTO hre_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Wì haq lam enh Mac-hê-lôt, đòiq traiq ta Tahat. ");
INSERT INTO hre_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Wì haq lam enh Tahat, đòiq traiq ta Terah. ");
INSERT INTO hre_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Wì haq lam enh Terah, đòiq traiq ta Mitga. ");
INSERT INTO hre_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Wì haq lam enh Mitga, đòiq traiq ta Hach-mô-na. ");
INSERT INTO hre_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Wì haq lam enh Hach-mô-na, đòiq traiq ta Mô-sê-rôt. ");
INSERT INTO hre_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Wì haq lam enh Mô-sê-rôt, đòiq traiq ta Bênê Jacan. ");
INSERT INTO hre_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Wì haq lam enh Bênê Jacan, đòiq traiq ta Hô-ghi-gat. ");
INSERT INTO hre_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Wì haq lam enh Hô-ghi-gat, đòiq traiq ta Jot-ba-tha. ");
INSERT INTO hre_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Wì haq lam enh Jot-ba-tha, đòiq traiq ta Ap-rô-na. ");
INSERT INTO hre_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Wì haq lam enh Ap-rô-na, đòiq traiq ta Ê-xi-ôn Ghêbe. ");
INSERT INTO hre_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Wì haq lam enh Ê-xi-ôn Ghêbe, đòiq traiq ta braih càn Xin, aih ta Cađê. ");
INSERT INTO hre_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Wì haq lam enh Cađê, đòiq traiq ta wang Hôrò, ŏi jêq acang gùng Êđôm. ");
INSERT INTO hre_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Tiaq bàu thê da Chuaq, pajàu Arôn tŏc ta wang Hôrò, hi khoi cachìt ta aih ta hì mòiq, khê padam, hanam ma 40, rèn enh jò jàn Is-ra-ên loh enh gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Arôn halình jah 123 hanam jò haq cachìt ta wang Hôrò. ");
INSERT INTO hre_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Bùa Arat, mangai Ca-na-an ma ŏi ta gùng Nêghep ta Diac Ca-na-an, hìa jàn Is-ra-ên trùh. ");
INSERT INTO hre_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Jàn Is-ra-ên lam enh wang Hôrò, đòiq traiq ta Xa-mô-na. ");
INSERT INTO hre_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Wì haq lam enh Xa-mô-na, đòiq traiq ta Punôn. ");
INSERT INTO hre_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Wì haq lam enh Punôn, đòiq traiq ta Ôbôt. ");
INSERT INTO hre_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Wì haq lam enh Ôbôt, đòiq traiq ta Ijê A-ba-rim ta acang Moap. ");
INSERT INTO hre_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Wì haq lam enh Ijê A-ba-rim, đòiq traiq ta Đibôn Gat. ");
INSERT INTO hre_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Wì haq lam enh Đibôn Gat, đòiq traiq ta Anmôn Đip-lat-tha-im. ");
INSERT INTO hre_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Wì haq lam enh Anmôn Đip-lat-tha-im, đòiq traiq ta wang A-ba-rim, haten ca Nêbô. ");
INSERT INTO hre_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Wì haq lam enh wang A-ba-rim, đòiq traiq ta tamang Moap haten cròng diac Jôđan ta jang ca Jê-ri-cô. i ");
INSERT INTO hre_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Wì haq đòiq traiq roc kenh cròng diac Jôđan enh Bêt Jê-si-môt trùh Abên Sitim ta tamang Moap. ");
INSERT INTO hre_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Ta tamang Moap roc kenh cròng diac Jôđan, ta jang ca Jê-ri-cô, Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Ìh doi ca jàn Is-ra-ên: ‘Jò pì cwa cròng diac Jôđan đòiq mùt ta Ca-na-an, ");
INSERT INTO hre_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","èh phai hnan dŏng dìq mangai jàn ma ŏi ta gùng aih. Phai raliang dŏng dìq ca dua 'mù ma broq xam long loq dua 'mù wì ma tùh, wa raliang dŏng dìq 'bài nòi ha'nhèq da wì haq. ");
INSERT INTO hre_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Pì phai ta'blêq wa yŏc dŏng dìq taneh wì haq, wa pì ŏi ta aih, ma jah 'màng aih Au khoi am ca pì yŏc gùng aih. ");
INSERT INTO hre_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Pì phai pàih panàih axong taneh aih tiaq xinoi. Adroi dŏng dìq taneh jah axong tiaq xinoi, khoi èh ta xinoi aih tiaq dèh cadraq cràm loq catŏi. Cadraq leq cràm èh jah taneh càn, cadraq leq catŏi jah taneh 'yoh. Axong hlài tiaq cadraq 'màng aih. ");
INSERT INTO hre_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘Mahaq tàng pì ùh hnan dŏng mangai jàn enh gùng aih, 'bài mangai ma pì đòiq ŏi hlài, èh wì haq tìah ca hila ŏi ta mat, tìah ca xrŏng ta bong, jò aih wì haq broq manhài ta gùng ta pì ma ŏi. ");
INSERT INTO hre_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Èh Au broq ca pì bìac Au ma khoi broq ca wì haq.’ ” ");
INSERT INTO hre_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Chuaq thê Môise doi ca mangai jàn Is-ra-ên: ");
INSERT INTO hre_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Jò pì mùt ta gùng Ca-na-an, taneh Au ma khoi am ca pì broq xôxech, acang taneh aih èh jah pachì 'màng cô: ");
INSERT INTO hre_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Pah 'ma ca mat mahì loh, enh braih càn Xin, trùh tiaq acang diac Êđôm, baxèm enh Diac Raxìq Boh, 'nah ta pah mat mahì loh. ");
INSERT INTO hre_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Acang pah 'ma ca mat mahì loh ca criang wang Ac-rap-bim, dang gat 'nah ta pah braih càn Xin, trùh pah 'ma ca mat mahì loh da Cađê Ba-nê-a. Enh aih roc trùh Hat-sa-at-đa pagat cwa Atmôn. ");
INSERT INTO hre_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Enh Atmôn acang aih roc hlài trùh cwa cròng diac 'yoh Aicàp, èh trùh Diac Raxìq Ta'ne. ");
INSERT INTO hre_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“ ‘Acang pah mat mahì mùt, aih Diac Raxìq Ta'ne. ");
INSERT INTO hre_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“ ‘Acang pah 'ngeo ca mat mahì loh, aih enh Diac Raxìq Ta'ne loh ta jang ca wang Hôrò. ");
INSERT INTO hre_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Enh wang Hôrò chot mòiq trong trùh Hamat cwa cròng diac Xêđat, ");
INSERT INTO hre_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","trùh Xiprôn wa dìq jang Hat-sa-ê-nan, aih acang ca da pì pah 'ngeo ca mat mahì loh. ");
INSERT INTO hre_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“ ‘Acang pah mat mahì loh jah baxèm enh Hat-sa-ê-nan trùh Sêpham, ");
INSERT INTO hre_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","wa enh Sêpham loh trùh Riplah pah mat mahì loh da Ain, hi khoi loh hòm trùh jò leq trùh pah mat mahì loh da diac raxìq Ki-nê-rêt. ");
INSERT INTO hre_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Enh diac raxìq Ki-nê-rêt, acang roc tiaq cròng diac Jôđan wa dìq ŏi ta Diac Raxìq Boh.’ ” ");
INSERT INTO hre_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Môise 'noh bàu thê cô ca jàn Is-ra-ên: “Cô taneh pì phai pàih panàih axong taneh tiaq bàu thê da Chuaq am ca hachìn hadròng hadrech wa mòiq ha'ne ca hadròng hadrech Ma-na-se. ");
INSERT INTO hre_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Ma jah 'màng aih hadròng hadrech Rubên, Gat wa mòiq ha'ne hadròng hadrech Ma-na-se, ");
INSERT INTO hre_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","khoi jah nhàn taneh pah tau ca cròng diac Jôđan, ta jang ca Jê-ri-cô pah mat mahì loh.” ");
INSERT INTO hre_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Chuaq doi hòm ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Cô hiniq 'bài mangai ma yòng đòiq axong taneh: Pajàu Ê-li-a-xa, Jôsuê, con calô da Nun. ");
INSERT INTO hre_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Pì phai yŏc mòiq ngai ma broq gàu ta rìm tàng hadròng hadrech đòiq broq bìac aih. ");
INSERT INTO hre_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Cô hiniq 'bài mangai ma broq gàu ta 'bài hadròng hadrech: Calep, con calô Jê-phu-neh broq gàu ca hadròng hadrech Juđa. ");
INSERT INTO hre_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Sa-mu-ên con calô da A-mi-hut broq gàu ca hadròng hadrech Si-mê-ôn; ");
INSERT INTO hre_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Ê-li-đat con calô da Kitlong broq gàu ca hadròng hadrech Bên-ja-min; ");
INSERT INTO hre_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Buki, con Jôcđi, broq gàu ca hadròng hadrech Đan; ");
INSERT INTO hre_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Ha-ni-ên, con Êphat, broq gàu ca Ma-na-se; ");
INSERT INTO hre_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kê-mu-ên, con Siptan, broq gàu ca Ep-ra-im; ");
INSERT INTO hre_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Ê-li-sa-phan, con Phacnat, broq gàu ca Xe-bu-lun; ");
INSERT INTO hre_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Pan-ti-ên, con Axan, broq gàu ca I-sa-ca; ");
INSERT INTO hre_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","A-hi-hut, con Sê-lô-mi, broq gàu ca Ase; ");
INSERT INTO hre_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pê-đa-hên, con A-mi-hut, broq gàu ca Nep-ta-li.” ");
INSERT INTO hre_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Aih 'bài mangai Chuaq pachì yòng đòiq axong taneh Ca-na-an ca jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Ta tamang Moap roc kenh cròng diac Jôđan ta jang ca Jê-ri-cô, Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Ìh phai thê jàn Is-ra-ên yŏc enh xôxech da wì haq hi am 'bài phôq ca mangai Lêwi đòiq wì haq ŏi, èh am hloi ca wì tamang taneh dudan ca 'bài phôq aih. ");
INSERT INTO hre_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","'Màng aih wì haq i phôq đòiq ŏi, wa đùng taneh đòiq aban 'bài 'bo, trìu wa 'bài ngè aban ma 'noiq. ");
INSERT INTO hre_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Tamang taneh đòiq broq nòi aban dudan ca phôq pì ma am ca mangai Lêwi, pah rùng phai jah 1.000 hagat tình pàng pagia phôq. ");
INSERT INTO hre_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","'Màng aih pì wêh pah mat mahì loh 1.000 hagat, pah 'ma mat mahì loh, 1.000 hagat, pah mat mahì mùt, 1.000 hagat, pah 'ngeo ca mat mahì loh, 1.000 hagat, wa phôq ta'ne. Wì haq jah tamang taneh aih đòiq broq nòi aban. ");
INSERT INTO hre_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Ta 'bài phôq pì ma am ca mangai Lêwi, phai đòiq crài tadràu phôq broq phôq amot đòiq mangai troq lò jêh mangai jah cadàu mot khoi ca wì ma enh jêh haq. Enh gùng ca aih, pì phai am tam ca wì haq 42 toq phôq hòm. ");
INSERT INTO hre_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","'Màng aih pì am ca mangai Lêwi dìq dŏng 48 toq phôq wa tamang taneh dudan ca phôq đòiq broq nòi aban. ");
INSERT INTO hre_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","'Bài phôq pì ma am ca mangai Lêwi, aih yŏc taneh jàn Is-ra-ên phai tiaq dèh xôxech tang hadròng hadrech. Hadròng hadrech leq i bàc phôq yŏc bàc, ma leq ma 'biaq yŏc 'biaq.” ");
INSERT INTO hre_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Chuaq doi ca Môise: ");
INSERT INTO hre_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Ìh doi ca jàn Is-ra-ên: ‘Jò pì cwa cròng diac Jôđan mùt ta gùng Ca-na-an, ");
INSERT INTO hre_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Pì phai ràih toq 'biaq phôq đòiq broq phôq amot, đòiq ca mangai leq troq lò jêh mangai. ");
INSERT INTO hre_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Dìq ca phôq aih jah wìa nòi amot đòiq wia ca wì lam chaq jêh chau, ma jah 'màng aih wì haq ep rìh gòm trùh hì hadrah da jàn. ");
INSERT INTO hre_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Tadràu toq phôq pì ma am ca mangai Lêwi aih broq phôq amot ca pì. ");
INSERT INTO hre_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","I piq toq phôq ŏi pah tau ca cròng diac Jôđan wa piq toq phôq ta Ca-na-an đòiq broq phôq amot. ");
INSERT INTO hre_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Tadràu toq phôq aih nòi amot ca jàn 'noiq leq ma rìh ŏi ta'ne jàn Is-ra-ên, đòiq ca mangai leq troq lò jêh cachìt mangai jah lam mot ta aih. ");
INSERT INTO hre_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘Mahaq tàng mangai leq wê ranac xam mem, jêh cachìt mangai 'noiq, mangai aih ep 'bìq hadrah ca jêh đac, ma jah 'màng aih haq pòq tôiq jêh mangai. ");
INSERT INTO hre_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Loq tàng mangai leq yŏc ranac xam hmu jêh cachìt ca mangai 'noiq, mangai aih ep 'bìq hadrah ca jêh đac, ma jah 'nang aih haq pòq tôiq jêh mangai. ");
INSERT INTO hre_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Loq tàng haq wê ta tì ranac xam long, jêh cachìt mangai 'noiq, mangai aih ep 'bìq hadrah ca jêh đac ma jah 'màng aih haq pòq tôiq jêh mangai. ");
INSERT INTO hre_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Mangai chaq jêh chau đòiq ca'naih dòih mahem, jò glàm haq ma khoi jêh đac mangai, èh cla haq phai jêh mangai aih. ");
INSERT INTO hre_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Tàng mangai leq taiq tarènh tagit ca'nhùc mangai 'noiq, loq gòm rap tàt trong đòiq đàp cachìt mangai 'noiq, ");
INSERT INTO hre_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","loq taiq mangai leq git 'bŏn ca dabau adroi, dèch tì jêh cachìt mangai 'noiq, èh ep 'bìq hadrah jêh đac. Jò mangai chaq jêh chau glàm èh mangai aih, haq phai jêh đac mangai ma jêh mangai aih. ");
INSERT INTO hre_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘Mahaq tàng ùh xài taiq tagit 'bŏn mahaq troq lò ca'nhùc mangai 'noiq loq tèm ngè cleq troq mangai aih, ");
INSERT INTO hre_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","loq taiq ùh hnoq ma troq lò cadro hmu troq mangai, tàng mangai aih cachìt, wa mangai ma troq lò aih ùh i to broq ca haq cachìt, ");
INSERT INTO hre_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","èh wì cwan hadrah phai hadrah mangai ma broq bìac aih wa mangai ma chaq jêh chau aih, dì tiaq ranenh bìac hadrah cô. ");
INSERT INTO hre_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Mangai jàn phai wèq mangai ma jêh mangai khoi ca mangai chaq jêh chau, wa thê mangai aih lam ta phôq amot, nòi haq ma khoi cadàu lam mot. Èh haq phai ŏi ta aih trùh jò leq pajàu ha'nhèq cachìt, aih pajàu ma khoi jah xùt dàu hadròih. ");
INSERT INTO hre_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘Mahaq tàng mangai aih loh khoi ca acang phôq amot, nòi haq ma lam mot, ");
INSERT INTO hre_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","èh tàng mangai ma chaq jêh chau glàm haq, hi khoi jêh haq enh gùng ca acang phôq amot, èh haq aih ùh i pòq tôiq jêh mangai, ");
INSERT INTO hre_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","taiq mangai ma jêh mangai khòh ŏi ta phôq amot trùh jò leq pajàu ha'nhèq cachìt. Atìq ca pajàu ha'nhèq cachìt, èh mangai aih jah hlài dèh ti đùng taneh xôxech hadròng hadrech. ");
INSERT INTO hre_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘Ùh kè ca pì rìh ta leq, dìq phai wèq tiaq ranenh cô ca dađeh wa ca dìq 'nhòng ma atìq. ");
INSERT INTO hre_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘Tàng mangai leq jêh mangai cachìt, èh dì tiaq bàu wì ma hnoq anoi hlài, đòiq hadrah ca jêh đac mangai ma jêh mangai, mahaq mòiq ngai anoi hlài ùh tôm đòiq hadrah ca jêh đac mangai leq. ");
INSERT INTO hre_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘Pì ùh jah nhàn 'bac rŏt hlài dađeh da mangai jêh đac mangai khoi i tôiq wa đang ca cachìt, ma jah 'màng aih haq ep 'bìq hadrah ca jêh đac. ");
INSERT INTO hre_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘Pì hadai ùh jah nhàn 'bac rŏt dađeh da mangai khoi cadàu lam mot ta phôq amot, đòiq jah hlài ta hnem adroi ca hì pajàu ha'nhèq cachìt. ");
INSERT INTO hre_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘Pì ùh jah broq amùa taneh pì ma đang ŏi; ma jah 'màng aih mahem broq amùa ca gùng. Tàng i mangai leq broq ta-ùc mahem ta gùng aih, tàng ùh yŏc mahem haq ta-ùc hlài, èh ùh broq 'màng leq ma jah rŏt hlài tôiq da gùng aih. ");
INSERT INTO hre_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","'Màng aih pì ùh jah broq dèh ca gùng loh ca amùa, nòi pì ma ŏi, wa nòi Au ŏi, ma jah 'màng aih Au Chuaq ŏi ta'ne jàn Is-ra-ên.’ ” ");
INSERT INTO hre_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","'Bài mangai ma broq gàu xinoi Ga-la-at wa xinoi Maki, con Ma-na-se, con xau Jôsep, lam trùh ta Môise wa mangai broq gàu jàn Is-ra-ên, đòiq bòch wì. ");
INSERT INTO hre_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Wì doi: “Jò Chuaq thê ìh axong taneh ca jàn Is-ra-ên broq xôxech, Chuaq khoi thê ìh am xôxech Xê-lô-phat, daq nhèn, ca 'bài con cadrì haq. ");
INSERT INTO hre_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Tàng 'bài con haq ta'nèp mangai Is-ra-ên ta hadròng hadrech 'noiq, èh xôxech wì rùp bàu jah yŏc enh xôxech boc yaq nhèn, 'ràng pajùm ca xôxech hadròng hadrech leq ma wì haq yŏc broq ŏng aih. 'Màng aih phàn taneh aih khoi pàih panàih ca hadròng hadrech nhèn èh 'bìq yŏc 'nah. ");
INSERT INTO hre_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Trùh Hanam Bùi Lem ca jàn Is-ra-ên, xôxech wì haq phai 'bìq am ca hadròng hadrech leq ma neo trùh ŏi ta wì haq. 'Màng aih xôxech wì haq 'bìq yŏc khoi enh xôxech boc yaq nhèn.” ");
INSERT INTO hre_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Chuaq thê Môise doi ca jàn Is-ra-ên: “Hadròng hadrech da con Jôsep doi, aih khoi troq tiaq bàu ranenh. ");
INSERT INTO hre_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Cô bìac Chuaq doi ca 'bài con cadrì da Xê-lô-phat: Wì haq enh yŏc mangai leq broq ŏng, lènh da wì haq, mahaq toq phai yŏc ta hadròng hadrech boc yaq dađeh. ");
INSERT INTO hre_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Ùh i mòiq xôxech leq ta jàn Is-ra-ên jah 'ràng enh hadròng hadrech cô cwa hadròng hadrech tau, ma jah 'màng aih mòiq ngai Is-ra-ên jah wèq taneh da hadròng hadrech dađeh jah hùang enh boc yaq. ");
INSERT INTO hre_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Rìm ngai con cadrì jah hùang taneh ùh kè ca hadròng hadrech leq ta Is-ra-ên, hadai phai yŏc broq ŏng mangai leq ŏi ta hadròng hadrech baq dađeh, 'màng aih mòiq ngai jàn Is-ra-ên jah hùang xôxech boc yaq dađeh. ");
INSERT INTO hre_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","'Màng aih, ùh i mòiq xôxech leq jah 'ràng enh hadròng hadrech cô cwa hadròng hadrech tau, ma jah 'màng aih rìm hadròng hadrech ta Is-ra-ên phai wèq taneh dađeh khoi jah đòiq broq xôxech.” ");
INSERT INTO hre_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","'Màng aih, 'bài con cadrì Xê-lô-phat broq tiaq troi Chuaq ma khoi thê Môise. ");
INSERT INTO hre_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","'Bài con cadrì Xê-lô-phat, aih Mahlah, Ti-ri-xah, Hotlah, Mincah wa Noah, dìq yŏc ŏng, yŏc mai dèh oh daq mìh dùch dađeh. ");
INSERT INTO hre_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Wì aih yŏc ŏng ta hadròng hadrech da xinoi Ma-na-se, con calô Jôsep, 'màng aih ma jah xôxech wì haq ŏi raq ta hadròng hadrech baq wì haq. ");
INSERT INTO hre_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Aih bàu thê wa ranenh da Chuaq khoi thê Môise anoi hlài ca jàn Is-ra-ên ta tamang taneh Moap roc kenh cròng diac Jôđan enh ngìa jang ca Jê-ri-cô.");
INSERT INTO hre_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Cô bàu Môise doi dìq ca jàn Is-ra-ên pah tau cròng diac Jôđan, ta braih càn ta jang ca Sup, ta'ne hagan Paran wa Tôphên, Laban, Hat-sê-rôt wa Đi-xa-hap. ");
INSERT INTO hre_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Enh Hôrêp trùh Cađê Ba-nê-a, tiaq trong wang Sirò, lam 11 hì cùi ca trong. ");
INSERT INTO hre_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Wop hanam 40, atìq ca wì haq loh khoi enh Aicàp, hì mòiq, khê 11, Môise doi ca jàn Is-ra-ên rìm bìac Chuaq ma khoi thê haq doi ca wì haq, ");
INSERT INTO hre_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","aih atìq ca jò haq khoi jêh đac Sihôn, bùa jàn A-mô-rit ŏi ta Hêtbôn wa Ot bùa gùng Basan ma ŏi ta Ach-ta-rôt wa Êt-rê-i. ");
INSERT INTO hre_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Ŏi pah tau cròng diac Jôđan ta gùng Moap, Môise baxèm hnài anoi ranenh cô: ");
INSERT INTO hre_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Chuaq Boc Plình bèn ta Hôrêp doi ca bèn: “Pì ŏi đò ta wang cô khoi dùnh. ");
INSERT INTO hre_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Lam trùh wang ta gùng jàn A-mô-rit beq, hadai trùh ta 'bài gùng ŏi haten ta gùng A-ra-ba, aih trùh nòi đùng tamang wa ta wang, wa mùt ta đùng tamang ha'neq gùng Nêghep, lam ti 'bo diac raxìq, ta gùng jàn Ca-na-an wa Liban, trùh cròng diac càn, aih Cròng Diac U-phra-tê. ");
INSERT INTO hre_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ngan cô, Au khoi am ca pì gùng aih. Mùt blah yŏc gùng Chuaq ma khoi pachac am ca boc yaq pì, aih Ap-ra-ham, Isac, Jacôp, wa con xau da wì haq.” ");
INSERT INTO hre_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Jò aih au khoi doi ca pì: “Mòiq ngai au ùh tàu padren đòiq wèq cwìang enh 'nhèq ca pì. ");
INSERT INTO hre_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Chuaq Boc Plình pì khoi broq pì bàc tam. Hì cô pì bàc tìah ca halŏng ta plình. ");
INSERT INTO hre_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Waiq Chuaq Boc Plình yaq pì broq pì bàc tam bình ngŏng yàng wa am ca pì xôq ramŏt, tìah troi Haq khoi rùp bàu hùaq ca pì! ");
INSERT INTO hre_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Mahaq mòiq ngai au broq 'màng leq ma nui pòq bìac xa pì wa bìac pì talech tacai ca dabau. ");
INSERT INTO hre_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","'Màng aih, pì phai ràih rìm ta hadròng hadrech pì, chaq 'bài mangai khôn rabiaq, i manoh canao loq, hi khoi au jah pajaq dèch wì haq tŏc broq gàu wèq cwìang enh 'nhèq dèh ca hadròng hadrech pì.” ");
INSERT INTO hre_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Pì khoi tèu bàu doi: “Bìac ìh ma tình ca broq aih lem joq 'nàng.” ");
INSERT INTO hre_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","'Màng aih, au ràih yŏc mangai broq gàu da 'bài hadròng hadrech, aih mangai khôn rabiaq, i manoh canao loq, yŏc atŏc đòiq broq gàu pì, wèq ngŏng ngai, hrinh ngai, 50 ngai, 10 ngai wa đòiq broq cwan wèq ngan ta 'bài hadròng hadrech da pì. ");
INSERT INTO hre_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Jò aih, au thê 'bài cwan hadrah pì: Phai tamàng dìq ca bìac takìan dabau da oh daq pì oq, yŏc can ta-atoq hadrah bìac takìan da tang ngai ta oh daq pì, loq mangai tamoi jàn 'noiq ma ŏi ta pì hadai. ");
INSERT INTO hre_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ta bìac hadrah, pì apaq genh can ca cabô, tamàng mangai ùh nèn tìah ca tamàng mangai gù craq, apaq crè ca cabô, ma jah 'màng aih bìac hadrah aih bìac da Boc Plình, phàn bìac cleq ma xa ca pì hadrah, 'ràng jang ngìa au beq, èh au jah tamàng am. ");
INSERT INTO hre_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Jò aih, au jah doi am ca pì rìm bìac cla pì phai broq. ");
INSERT INTO hre_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Khoi èh, tìah troi Chuaq Boc Plình bèn khoi thê, bèn lam khoi ca Hôrêp, lam cwa braih càn laih lang wa 'mèq 'mac, bèn ma ngan hnoq tau ta ngìa bèn wang jàn A-mô-rit, hi khoi bèn lam trùh Cađê Ba-nê-a. ");
INSERT INTO hre_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Jò aih au doi ca pì: “Pì khoi trùh ta wang da jàn A-mô-rit, Chuaq Boc Plình bèn ma padon am ca bèn. ");
INSERT INTO hre_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Ngan tau, Chuaq Boc Plình pì am ca pì gùng aih. Lam tŏc beq, blah yŏc broq xôxech tìah troi Chuaq Boc Plình da boc yaq pì khoi doi ca pì. Apaq hŏnh manoh, apaq ramòt.” ");
INSERT INTO hre_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Jò aih, dìq dŏng ca pì khoi thia haten ca au, doi: Am 'bài mangai lam adroi ca nhèn beq, đòiq lam rinh ngan wa patô hnài trong leq nhèn phai lam, wa 'bài phôq leq nhèn mùt èh. ");
INSERT INTO hre_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Bàu cô lem manoh au. Au ràih 12 ngai ta pì, aih mòiq ngai ta rìm tang hadròng hadrech. ");
INSERT INTO hre_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Mòiq jàt baiq ngai aih loh lam tŏc ta wang, lam trùh thòng Êchcôn đòiq lam rinh. ");
INSERT INTO hre_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Wì haq kech wê plì ta gùng aih, 'ràng ca bèn, ta'mon hlài ca bèn: “Gùng Chuaq Boc Plình ma hùaq am ca bèn lem joq 'nàng.” ");
INSERT INTO hre_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Mahaq pì ùh enh tŏc ta aih. Pì khoi blàq hlài bàu thê da Chuaq Boc Plình pì, ");
INSERT INTO hre_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","mamùc dèh ta traiq cla pì doi: “Aih taiq Chuaq git ca bèn, dài Haq ma jah broq bèn loh khoi enh gùng Aicàp, đòiq 'mùt bèn ta tì jàn A-mô-rit đòiq jêh đac. ");
INSERT INTO hre_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Bèn jah lam ta leq? Oh daq bèn broq ca bèn crè crep, ma jah 'mang aih wì doi: ‘Aih jàn ji bàc wa ji ca'nhòng ca bèn, aih 'bài phôq càn wa hagao hagình chàu plình, èh hòm nhèn hnoq ta aih i 'bài con xau da jàn A-na-kim.’ ” ");
INSERT INTO hre_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Mahaq au doi ca pì: “Apaq yùq wa apaq crè ca wì haq. ");
INSERT INTO hre_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Chuaq Boc Plình pì lam adroi, Haq jah tajêh am ca pì, troi Haq khoi broq jang ngìa pì ŏi ta gùng Aicàp, ");
INSERT INTO hre_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","wa ŏi ta nòi braih càn, aih nòi pì hnoq lùch roc trong pì lam trùh jò trùh ta cô, 'màng leq Chuaq Boc Plình pì khoi ca'mình pì tìah ca mangai baq ca'mình dèh con calô cla.” ");
INSERT INTO hre_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","'Nhac ca 'màng aih, pì xôq ùh lùi Chuaq Boc Plình pì, ");
INSERT INTO hre_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Haq ma lam adroi 'nong pì ti trong lam, đòiq chaq am ca pì nòi đòiq traiq; damang xam cato ùnh, dahì xam cato yùc, đòiq patô trong lam ca pì phai lam. ");
INSERT INTO hre_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Jò aih Chuaq tàng bàu capoch da pì. Haq loh nòih pachac, doi: ");
INSERT INTO hre_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Pi i mòiq ngai leq da xinoi ngang dù cô jah hnoq gùng lem lình Au ma khoi pachac am ca boc yaq pì, ");
INSERT INTO hre_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","enh gùng ca Calep, con calô da Jê-phu-neh. Haq jah hnoq gùng aih, èh Au jah am ca haq wa con xau haq gùng haq ma khoi lam cwa, taiq haq khoi tiaq Chuaq dìq ca manoh gêh tôm.” ");
INSERT INTO hre_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Èh hòm, taiq nen pì, Chuaq hadai loh nòih ca au, haq doi: “Ìh hadai ùh jah mùt ta aih. ");
INSERT INTO hre_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Mahaq Jôsuê con calô da Nun jah mùt ta aih. Ìh phai parông haq ca jah i manoh tanùh beq, ma jah 'màng aih haq jah broq jàn Is-ra-ên nhàn yŏc gùng aih broq xôxech. ");
INSERT INTO hre_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Èh 'bài con nga da pì, pì ma khoi doi jah wìa hanùm am ca mangai git ca pì, wa 'bài con calô pì manàiq cô 'nhòq canao loq bìac lem loq dù, jah mùt gùng aih. Au jah am ca wì haq gùng cô broq xôxech. ");
INSERT INTO hre_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Mahaq cla pì phai wìh hlài beq, lam mùt braih càn tiaq trong 'nong pah Diac Raxìq Gòh.” ");
INSERT INTO hre_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Jò aih pì tèu Au: “Nhèn khoi broq tôiq ca Chuaq. Nhèn jah lam tŏc tajêh wa broq rìm bìac Chuaq Boc Plình nhèn khoi doi đòiq.” Èh rìm ngai ŏi ta pì teo ranac tajêh wa pì xoh bìac lam tŏc ta wang aih xùang ca broq. ");
INSERT INTO hre_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Chuaq doi ca au: “Doi ca jàn beq: ‘Apaq tajêh, ma jah 'màng aih Au joq 'nàng ùh ŏi ta'ne wì. Èh pì 'bìq lình wì jêh 'blêq pì.’ ” ");
INSERT INTO hre_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","'Nhac ca au ta'mon hlài bàu cô, mahaq pì ùh tamàng au, tajraq hlài bàu thê da Chuaq, yŏc manoh catèh, lam tŏc ta wang. ");
INSERT INTO hre_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Jò aih mangai A-mô-rit ŏi ta wang cô, loh hnan pì tìah ca lù ong, jêh 'blêq pì enh Sirò trùh Hotma. ");
INSERT INTO hre_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Jò wìh hlài, pì hmoi jang ngìa Chuaq, mahaq Chuaq ùh halang don wa ùh waq tamàng bàu pì. ");
INSERT INTO hre_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","'Màng aih pì khoi ŏi ta Cađê bàc hì, bàc hì hrìn. ");
INSERT INTO hre_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Khoi èh bèn wìh hlài mùt ta braih càn hlài 'nah ta Diac Raxìq Gòh, tìah troi Chuaq khoi doi ca au. Bèn lam dudan bàc hì ta wang Sirò. ");
INSERT INTO hre_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Chuaq i doi ca au: ");
INSERT INTO hre_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Pì lam dudan ca wang cô khoi dùnh, wìh hlài lam pah 'ngeo ca mat mahì loh beq. ");
INSERT INTO hre_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Anoi bàu thê cô am ca jàn beq: ‘Pì phai lam cwa gùng da oh daq cla, aih con xau Êsau ŏi ta Sirò. Wì haq loq crè ca pì, mahaq phai wèq dađeh oq; ");
INSERT INTO hre_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","apaq ta'miaq ca wì haq, ma jah 'màng aih Au ùh am ca pì gùng da wì haq, 'nhac ca mòiq apech taneh bu toq capiang jènh, xôq ùh am. Au khoi am ca Êsau wang Sirò đòiq broq xôxech. ");
INSERT INTO hre_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Pì phai yŏc dèh 'bac rŏt ngè caq wa diac ôq da wì haq.’ ” ");
INSERT INTO hre_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Ma jah 'mang aih Chuaq Boc Plình pì khoi am xôq ramŏt ca rìm bìac broq da tì pì. Haq khoi loq bìac pì lam ti trong cwa braih càn cô. Trom 40 hanam aih, Chuaq Boc Plình pì xôq ŏi ti pì wa pì ùh thìuq cah cleq. ");
INSERT INTO hre_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","'Mang aih bèn lam cwa cadan hangai ca oh daq bèn, con xau Êsau ŏi ta Sirò. Bèn lam khoi ca trong A-ra-ba, hadai khoi ca trong Êlat wa Ê-xi-ôn Ghêbe. Èh bèn tawìh hlài lam cwa braih càn Moap. ");
INSERT INTO hre_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Chuaq doi ca au: “Apaq leoq wa apaq broq ca jàn Moap loq enh tajêh, ma jah 'mang aih Au ùh am ca pì jàn aih đòiq broq xôxech, taiq Au khoi am Arò ca con xau Lot broq xôxech.” ");
INSERT INTO hre_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Adroi nèh, jàn Êmim ŏi ta aih. Jàn aih bàc, dêh, caiq wa ca'nhòng càn tìah ca jàn A-na-kim. ");
INSERT INTO hre_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Wì hadai jah creo, jàn Rê-pha-im tìah ca jàn A-na-kim, mahaq jàn Moap creo ca wì haq Êmim. ");
INSERT INTO hre_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Jàn Hôrit 'nhòng adroi ŏi ta Sirò, mahaq con xau Êsau jêh đac jàn aih, blah yŏc gùng wì haq wa ŏi thai ta aih, tìah ca Is-ra-ên blah yŏc gùng Chuaq ma khoi am ca wì haq broq xôxech. ");
INSERT INTO hre_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Manàiq cô, yòng beq, lam cwa hŏc diac Xêrêt. 'Mang aih bèn khoi lam cwa hŏc diac Xêrêt. ");
INSERT INTO hre_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Jò bèn loh enh Cađê Ba-nê-a trùh jò bèn lam cwa hŏc diac Xêrêt, aih dìq 38 hanam, trùh jò wì gù radam khoi trùh hanam broq lình lòp ma adroi cachìt dìq, troq troi bàu Chuaq khoi pachac ca wì haq. ");
INSERT INTO hre_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Chuaq tajraq hlài ca wì haq trùh jò Haq jêh dìq ca wì. ");
INSERT INTO hre_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Jò dìq ca lình ŏi ta jàn khoi cachìt dŏng, ");
INSERT INTO hre_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Chuaq doi ca au: ");
INSERT INTO hre_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Hì cô pì nhet ca lam cwa tiaq acang Moap ŏi ta Arò. ");
INSERT INTO hre_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Jò khoi trùh haten ca taneh da gùng Amôn, pì ùh jah broq manhài, hadai ùh jah taleoq ca wì haq, ma jah 'mang aih Au ùh am ca pì taneh da mangai Amôn, taiq Au khoi am taneh gùng aih ca con xau Lot broq xôxech.” ");
INSERT INTO hre_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Taneh aih da mangai Rê-pha-im, taiq adroi nèh jàn cô rìh ta cô, mahaq mangai Amôn doi, wì haq aih jàn Xam-xu-mim, ");
INSERT INTO hre_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","aih jàn dêh, cràm wa càn caiq tìah ca jàn A-na-kim. Chuaq jêh wì haq enh ngìa ca jàn Amôn. Mangai Amôn hnan wì haq khoi yŏc gùng wì haq broq xôxech. ");
INSERT INTO hre_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Chuaq hadai broq 'mang aih ca xinoi da Êsau ŏi ta Sirò, jò Haq jêh jàn Hôrit enh ngìa ca wì haq. Wì haq hnan đac jàn cô, khoi èh ŏi ta aih trùh manàiq. ");
INSERT INTO hre_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Mahaq jàn Awim calah nèh ŏi ta 'bài plài 'yoh trùh Gaxa, mahaq jàn Cap-tô-rim enh Captô trùh jêh dìq, khoi èh blah yŏc taneh wì haq.) ");
INSERT INTO hre_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Jò cô, pì yòng beq lam cwa thòng Atnôn. Cô Au am ca pì mangai Sihôn wa mangai A-mô-rit, bùa Hêtbôn wa gùng da haq. Pì trùh jêh beq, èh blah yŏc taneh wì haq. ");
INSERT INTO hre_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Hì cô Au baxèm broq ca rìm jàn enh 'neq ca plình jah yùq crè ca pì. Jò tàng bìac pì, wì haq tarìt wa dìq jaq yùq crè.” ");
INSERT INTO hre_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Enh đùng braih càn Kê-đê-môt, au thê mangai wê bàu glàm Sihôn, bùa Hêtbôn am bàu bòch hatroq ca wì haq, doi: ");
INSERT INTO hre_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Xìn bùa am ca bèn lam cwa phàn taneh diac da bùa. Nhèn toq lam ti trong ùh wìh 'ngeo wìh 'ma. ");
INSERT INTO hre_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Xìn bùa tech ca nhèn dahwèq caq wa diac ôq, hi khoi nhèn jah am 'bac tajì ca hang aih. Toq xìn bùa am nhèn lam cwa gùng taneh da ìh, ");
INSERT INTO hre_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","hadai tìah troi con xau Êsau ŏi ta Sirò wa jàn Moap ŏi ta Arò khoi ca'naih au lam 'màng aih, trùh hloi jò leq au cwa cròng diac Jôđan, đòiq mùt ta gùng Chuaq Boc Plình ma khoi rùp bàu am ca nhèn.” ");
INSERT INTO hre_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Mahaq Sihôn, bùa Hêtbôn ùh am bèn lam cwa pagat trong acang taneh haq, ma jah 'màng aih Chuaq Boc Plình pì khoi broq ca manoh haq cadoq cadang, đòiq 'mùt haq ta tì pì, tìah troi bìac khoi trùh hì cô. ");
INSERT INTO hre_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Chuaq doi ca au: “Ngan cô, Au baxèm 'mùt Sihôn wa gùng haq am ca ìh. Manàiq cô baxèm blah yŏc gùng haq beq.” ");
INSERT INTO hre_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","'Màng aih, Sihôn wa jàn haq loh tàt bèn đòiq tajêh ta Jahai. ");
INSERT INTO hre_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Chuaq Boc Plình bèn 'mùt haq am ca bèn, wa bèn jêh 'blêq haq xam con calô wa dìq ca jàn haq. ");
INSERT INTO hre_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Jò aih bèn blah yŏc dŏng dìq phôq haq, jêh đac dìq dŏng gu calô, gu cadrì wa con 'yoh, ùh đòiq mangai leq ŏi rìh. ");
INSERT INTO hre_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Bèn toq yŏc đòiq ca dađeh 'bài ngè aban wa dahwèq ta phôq bèn khoi jêh 'blêq. ");
INSERT INTO hre_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Enh A-rô-e, ŏi enh crŏng thòng Atnôn wa enh phôq thòng trùh Ga-la-at, ùh i ca mòiq phôq leq ma càn dêh yi hnao ca bèn jah 'blêq, taiq Chuaq Boc Plình khoi 'mùt dìq phôq aih am ca bèn. ");
INSERT INTO hre_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Mahaq pì ùh thia haten gùng da con xau Amôn ŏi jàp roc kenh cròng diac Jabôc, loq 'bài phôq ta wang, loq nòi leq Chuaq Boc Plình bèn ùh thê bèn blah yŏc. ");
INSERT INTO hre_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Atìq ca aih, bèn wìh hlài tiaq trong tŏc ta Basan. Ot, bùa Basan wa dìq dŏng ca jàn haq loh tàt bèn, đòiq tajêh ta Êt-rê-i. ");
INSERT INTO hre_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Mahaq Chuaq doi ca au: “Ìh apaq yùq ca bùa aih, ma jah 'mang aih Au khoi 'mùt haq xam jàn wa gùng haq mùt ta tì ìh. Ìh jah broq ca haq tìah ca ìh ma khoi broq ca Sihôn, bùa A-mô-rit ŏi ta Hêtbôn.” ");
INSERT INTO hre_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Chuaq Boc Plình hadai 'mùt Ot ta tì bèn, bùa Basan, wa dìq jàn haq. Bèn khoi 'blêq haq trùh pi i mòiq ngai leq ŏi rìh. ");
INSERT INTO hre_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Jò aih bèn blah yŏc dìq phôq da haq. Ùh i phôq leq bèn ma ùh blah yŏc, aih 60 toq phôq wa dìq ca gùng Atgôp, aih taneh Diac Ot ta gùng Basan. ");
INSERT INTO hre_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Dìq phôq cô i panàt ha'nhèq, 'mang i calêh clòng. Enh gùng ca aih, hadai i bàc phôq ùh i panàt wawenh. ");
INSERT INTO hre_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Bèn khoi jêh đac dìq phôq cô, tìah ca bèn khoi broq ca Sihôn, bùa Hêtbôn, aih raliang đac dìq dŏng wa jêh đac gu calô, gu cadrì wa con 'yoh. ");
INSERT INTO hre_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Mahaq bèn yŏc dìq ngè aban wa dahwèq da 'bài phôq aih. ");
INSERT INTO hre_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","'Màng aih, bèn khoi blah yŏc gùng da baiq toq bùa A-mô-rit, gùng pah tau cròng diac Jôđan, enh thòng Atnôn trùh wang Hetmôn, ");
INSERT INTO hre_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Jàn Siđôn creo wang Hetmôn aih Si-ri-ôn, mahaq jàn A-mô-rit hiniq ca wang Hetmôn aih Sênia). ");
INSERT INTO hre_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Bèn khoi blah yŏc dìq phôq ta tamang, dìq ca Ga-la-at wa dìq ca Basan trùh Sancah wa Êt-rê-i, aih 'bài phôq ta Taneh Diac da Ot ta Basan. ");
INSERT INTO hre_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Ma jah 'màng aih ta jàn Rê-pha-im, toq ŏi i mòiq ngai Ot raq, haq bùa Basan, i jùang cùi broq xam mem, dang yôh 9 hagat, wa dang gat 4 hagat; manàiq cô jùang aih xôq jah hnoq ŏi ta phôq Rapba, nòi con xau Amôn). ");
INSERT INTO hre_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","'Màng aih, jò aih bèn khoi blah yŏc gùng cô. Au am ca mangai Rubên wa mangai Gat pàng gùng A-rô-e, hŏc diac Atnôn wa mòiq 'ne taneh ta go wang Ga-la-at pajùm ca 'bài phôq da haq. ");
INSERT INTO hre_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Au am ca mòiq ha'ne hadròng hadrech Ma-na-se 'ne taneh gùng Ga-la-at ma ŏi i, wa dìq ca Basan Diac da Ot, aih jàp gùng Atgôp pajùm dìq ca Basan. Gùng aih creo gùng Rê-pha-im. ");
INSERT INTO hre_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jairò, con calô da Ma-na-se yŏc dìq ca gùng Atgôp trùh hloi ta acang taneh da jàn Gê-su-rò wa jàn Ma-a-ca, taiq 'màng aih trùh manàiq gùng Basan wì creo Hawôt Jairò taiq tiaq hiniq Jairò. ");
INSERT INTO hre_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Au am gùng da Ga-la-at ca Maki. ");
INSERT INTO hre_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Baiq xinoi Rubên wa Gat au am gùng enh Ga-la-at trùh thòng Atnôn, ta'ne thòng aih raq acang, trùh cròng diac Jabôc, aih raq acang gùng da con calô Amôn; ");
INSERT INTO hre_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","hadai gùng A-ra-ba, acang ta thòng cròng diac Jôđan, enh Ki-nê-rêt trùh diac raxìq A-ra-ba, aih Diac Raxìq Boh, enh criang wang Phichga pah mat mahì loh. ");
INSERT INTO hre_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Jò aih au tanap: “Chuaq Boc Plình da pì khoi am ca pì taneh gùng cô đòiq broq xôxech. Mahaq dìq ca mangai radam tadêh wa khoi padon ranac tajêh phai cwa cròng diac, lam adroi ca oh daq cla, aih mangai calô Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Mahaq, mai, con wa dìq ngè aban da pì (au loq pì i bàc ngè aban) đòiq ŏi ta phôq au ma khoi am ca pì, ");
INSERT INTO hre_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","trùh jò Chuaq am ca oh daq da pì jah padài, tìah ca Haq khoi am ca pì, aih trùh jò wì oh daq aih jah blah yŏc đùng taneh Chuaq Boc Plình da pì am ca wì haq ŏi pah tau ca cròng diac Jôđan. Jò aih èh pì jah hlài dèh nòi xôxech ma au khoi am ca pì.” ");
INSERT INTO hre_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Jò aih au thê Jôsuê: “Ìh joq khoi hnoq ro rang dìq ca bìac Chuaq Boc Plình da ìh khoi broq ca baiq ngai bùa tau. Chuaq hadai broq 'màng aih ca taneh diac ŏi pah tau ca cròng diac aih, nòi ìh padon trùh. ");
INSERT INTO hre_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Paq crè ca wì haq, ma jah 'màng aih Chuaq Boc Plình da ìh jah ta'blêq am ca pì.” ");
INSERT INTO hre_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Jò aih au hadai i waiq khàn dang xìn Chuaq: ");
INSERT INTO hre_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Waiq Chuaq Boc Plình, Chuaq khoi baxèm am ca hapŏng 'yoh da Ìh jah hnoq Ìh dìq jaq càn caiq wa cwìang itai da Ìh ùh i ca Yiang leq ŏi ta Plình loq ta crŏng taneh jah broq rìm bìac Ìh khoi broq, hadai ùh i ca Yiang leq tìah ca Ìh. ");
INSERT INTO hre_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Xìn Chuaq am ca au jah cwa cròng diac đòiq jah hnoq gùng taneh lem jìang, wang rôm lem lình da Liban pah tau ca cròng diac Jôđan.” ");
INSERT INTO hre_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Mahaq taiq oh daq dài Chuaq khoi nòih ca au, ùh rùp bàu au. Chuaq doi: “Hêq! Apaq anoi bìac cô ca Au hòm. ");
INSERT INTO hre_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Tŏc ta bôi wang Phichga, ngan pah mat mahì mùt, pah 'ngeo mat mahì loh, pah 'ma mat mahì loh, wa pah mat mahì loh, ìh jah ngan hnoq gùng taneh, mahaq ìh ùh jah cwa cròng diac Jôđan. ");
INSERT INTO hre_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Au jah jao am bìac broq cô ca Jôsuê, èh yŏc bàu parông đòiq broq ca haq jah dêh, ma jah 'mang aih Jôsuê mangai ma ajèn jàn trùh ta taneh gùng broq xôxech, aih gùng ìh toq jah ngan xam mat.” ");
INSERT INTO hre_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Taiq 'màng aih bèn ŏi ta thòng enh ngìa ca Bêt Pêo. ");
INSERT INTO hre_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Ôi Is-ra-ên, manàiq cô tamàng tiaq ranenh wa bìac thê broq, au ma hnài pì beq. Broq tiaq đòiq pì jah rìh wa jah 'mùt ta gùng Chuaq Boc Plình da boc yaq pì am ca pì nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Pì apaq tam wa hadai apaq yŏc 'noh 'nah bàu au ma thê, mahaq phai wèq tiaq ranenh hnài da Chuaq Boc Plình pì, aih bàu thê au ma anoi ca pì. ");
INSERT INTO hre_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Pì khoi hnoq bìac Chuaq khoi broq ca Ba-an Pêo, ma jah 'màng aih Chuaq Boc Plình pì khoi jêh đac rìm ngai ma lùi tiaq Ba-an Pêo. ");
INSERT INTO hre_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Mahaq phàn pì, mangai ma tiaq Chuaq Boc Plình cla pì, hì cô dìq dŏng ŏi rìh. ");
INSERT INTO hre_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Cô, au khoi hnài pì trong tiaq ranenh wa bìac thê broq tiaq bàu Chuaq Boc Plình au, khoi thê au, đòiq pì broq tiaq jò ŏi ta gùng cla jah mùt đòiq nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","'Màng aih, pì ep wèq wa broq tiaq bàu thê wa ranenh cô, ma jah 'mang aih cô bìac khôn rabiaq wa thài manoh da pì jang ngìa jàn 'noiq. Jò wì haq tamàng pì anoi ranenh cô, wì jah doi: “Jàn cô joq 'nàng khôn rabiaq wa thài manoh!” ");
INSERT INTO hre_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","I ca jàn leq 'nhac ca càn mahaq i Yiang cla haten ca wì haq tìah troi bèn khoi i, aih Chuaq Boc Plình haten ca bèn, rìm jò bèn waiq dang Haq ùh? ");
INSERT INTO hre_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Ma i Diac leq 'nhac ca càn ma i trong ranenh wa bìac thê broq leq ta-atoq troi dìq ca ranenh cô ma au đòiq jang ngìa pì hì cô? ");
INSERT INTO hre_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Mahaq pì phai wèq dađeh oq, wèq dèh mahua cla, yùq pì loq hèt ca bìac pì ma khoi hnoq, paq đòiq bìac aih loh khoi ca manoh pì, hadai ep hnài bìac aih am ca 'bài con wa con xau pì. ");
INSERT INTO hre_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Hmàng hlài hì ma pì yòng enh ngìa ca Chuaq Boc Plình pì ta Hôrêp, jò Chuaq doi ca au: Tagop jàn jang ngìa ca Au beq đòiq wì haq tamàng bàu Au, waq ca loq iu crè ca Au jò wì haq rìh ŏi ta nòi crŏng taneh, wa hnài bàu aih am dèh ca con cla. ");
INSERT INTO hre_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Pì thia haten yòng jang jènh wang jò ùnh cheo jàp ta wang wa pla ùnh xrŏc tŏc ta plình. I can clam clôiq yùc glom ta wang. ");
INSERT INTO hre_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Enh ta'ne ùnh Chuaq doi ca pì. Pì tàng bàu capoch, mahaq ùh hnoq chac Haq, mahaq tàng toq bàu. ");
INSERT INTO hre_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Haq doi am ca pì loq bìac wêh jao da Haq, aih Mòiq Jàt Bàu Thê da Ranenh, thê pì wèq. Haq achìh bàu thê aih ta baiq capiac hmu. ");
INSERT INTO hre_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Jò aih, Chuaq hadai thê au hnài pì trong tiaq ranenh wa bìac thê broq, đòiq pì broq tiaq jò ŏi ta gùng pì padon lam mùt nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","'Màng aih, pì rabiaq ca wèq dèh mahua yiang cla oq, ma jah 'màng aih pì ùh hnoq chac Haq ta hì Chuaq Boc Plình pì ŏi ta'ne ùnh doi ca pì ta Hôrêp. ");
INSERT INTO hre_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Phai dìq ca padren wèq dađeh đòiq ùh broq dù, aih broq mòiq dua 'mù leq, dua 'mù da mangai gu calô loq gu cadrì, ");
INSERT INTO hre_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","loq 'mù ngè rôm leq lam ta crŏng taneh, loq 'mù da ngè leq i panan pan ta plình, ");
INSERT INTO hre_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","loq 'mù da ngè 'yêq leq moq ta crŏng taneh, loq 'mù da ca cleq ŏi ta diac. ");
INSERT INTO hre_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Jò pì ngoi mat ta plình hnoq mat mahì, mat khê, wa mat halŏng ta plình, phai wèq dèh manoh apaq 'bìq padô 'nùt, hacùn cràng cùh waiq jang ngìa 'bài mat halŏng aih, Chuaq Boc Plình pì lah axong am dìq ca jàn ŏi enh ca'nàm plình. ");
INSERT INTO hre_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Mahaq phàn pì, Chuaq khoi ràih wa dèch pì claih ca tanùh ùnh bùh mem tau, aih gùng Aicàp, đòiq pi wìa mòiq jàn da Haq, tìah troi i hì cô. ");
INSERT INTO hre_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Khoi èh taiq nen pì, Chuaq nòih ca au, Haq pachac doi: Au ùh jah lam cwa cròng diac Jôđan, wa ùh jah mùt ta gùng lem lình Chuaq Boc Plình pì ma am ca pì broq xôxech. ");
INSERT INTO hre_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ma jah 'mang aih, au phai cachìt ta gùng cô, ùh jah cwa cròng diac Jôđan, mahaq pì jah lam cwa wa nhàn yŏc gùng lem lình aih. ");
INSERT INTO hre_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Rabiaq ca wèq dađeh oq, apaq hèt ca wêh jao da Chuaq Boc Plình pì khoi broq ŏi ti pì, wa apaq pùng padì dua 'mù leq Chuaq Boc Plình pì ùh thê broq. ");
INSERT INTO hre_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Ma jah 'mang aih Chuaq Boc Plình pì tìah ca mòiq pla ùnh loq bùh cheo, Haq Boc Plình loq tagrình. ");
INSERT INTO hre_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Jò pì hi jah i con wa con xau, wa jò ŏi ta gùng cô khoi dùnh, tàng pì broq 'mèq wa broq dua 'mù leq, ùh kè ca dua 'mù cleq, ma hi broq dù jang ngìa Chuaq Boc Plình pì, aih taleoq Haq nòih, ");
INSERT INTO hre_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","èh hì cô au waiq creo plình wa taneh ngan hnoq au khoi pa'yèp pì: Tàng pì ŏi broq tôiq taleoq ca Chuaq aih pì joq 'nàng renh cachìt wa hnhung đac khoi ca gùng pì ma padon lam nhàn yŏc ŏi pah tau cròng diac Jôđan. Pì ùh jah ŏi ta aih dùnh, mahaq phai 'bìq jêh đac dìq. ");
INSERT INTO hre_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Chuaq broq pì pac lac ta wì jàn 'noiq, èh ŏi i hlài toq 'biaq ta wì jàn nòi Chuaq ma hnan pì 'mùt. ");
INSERT INTO hre_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ŏi ta aih, pì tadreo cùh waiq dua 'mù broq xam hmu, aih bìac da tì con mangai broq loh xam long wa hmu ma ùh xau hnoq, ùh jah tàng, ùh jah caq, wa ùh 'nì xua. ");
INSERT INTO hre_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Mahaq tàng pì chaq Chuaq Boc Plình pì, jah glàm Haq, tàng pì chaq wa cùh waiq Haq dìq ca manoh wa dìq ca mahua yiang. ");
INSERT INTO hre_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Jò pì 'bìq nan xa, wa dìq ca bìac aih trùh ca pì, jò aih trom 'bài hì pulùch, pì jah wìh hlài ti Chuaq Boc Plình, èh pì tamàng bàu Haq. ");
INSERT INTO hre_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Ma jah 'màng aih Chuaq pì, Haq Boc Plình loq xa-ŏch, ùh hìaq cađac pì wa ùh hìaq jêh đac pì, hadai ùh hèt bìac wêh jao Haq ma khoi pachac ca boc yaq pì. ");
INSERT INTO hre_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Joq 'nàng 'màng aih, pì ti bòch enh 'nhòng adroi ca pì beq. Pàng hì Boc Plình broq loh con mangai ta crŏng taneh, enh ca'nàm plình cô, tàng jò leq i loh bìac cleq càn 'màng cô, loq wì i tàng bìac leq tìah 'màng cô? ");
INSERT INTO hre_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","I ca mòiq jàn leq jah tàng bàu Boc Plình ta'ne ùnh troi pì khoi tàng, mahaq xôq ŏi rìh ùh? ");
INSERT INTO hre_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Loq i yiang leq khoi yŏc bìac càn caiq wa bìac ramòt đòiq lam tablah yŏc ca dađeh mòiq tamoi ŏi ta'ne mòiq jàn 'noiq troi rìm bìac Chuaq Boc Plình pì ma khoi broq am ca pì ŏi ta gùng Aicàp jang ngìa pì 'mòh? ");
INSERT INTO hre_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Pì khoi wiang hnoq rìm bìac aih đòiq canao loq ca Chuaq, aih Boc Plình, ùh i Chuaq leq enh gùng ca Haq. ");
INSERT INTO hre_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Ŏi enh plình Haq broq pì tàng bàu Haq đòiq baxa hnài pì. Ŏi ta crŏng taneh Haq broq ca pì jah ngan hnoq ùnh càn da Haq wa pì tàng bàu Haq ŏi ta'ne ùnh. ");
INSERT INTO hre_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Taiq Haq loq waq boc yaq pì, ma jah 'mang aih Haq ràih yŏc xinoi wì haq raq. Nhò dèh cwìang itai cla Haq dèch pì loh khoi ca Diac Aicàp, ");
INSERT INTO hre_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","đòiq hnan đac jàn 'noiq yi càn wa yi dêh ca pì jang ngìa pì đòiq pì mùt ta gùng jàn aih, wa am ca pì taneh gùng wì haq broq xôxech tìah ca bìac aih khoi i hì cô manàiq. ");
INSERT INTO hre_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","'Màng aih, hì cô manàiq pì phai loq hmàng ta manoh pì: Chuaq aih Boc Plình da plình wa ta crŏng taneh cô, enh gùng ca Haq ùh i chuaq leq. ");
INSERT INTO hre_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Tàng pì wèq ranenh wa bàu thê da Haq, au ma khoi doi ca pì hì cô, pì wa con xau pì i xôq ramŏt wa jah rìh halình ta gùng Chuaq Boc Plình pì ma am ca pì hloi hloi. ");
INSERT INTO hre_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Jò aih Môise ràih crài piq toq phôq ŏi pah tau cròng diac Jôđan, pah mat mahì loh, ");
INSERT INTO hre_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","đòiq mangai ma troq lò jêh đac mangai, ùh xài i manoh hèm ca git enh adroi, jah lam mot ta mòiq phôq cô, èh jah rìh. ");
INSERT INTO hre_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Aih Bêxe nòi rôm hawit, ta gùng đùng tamang ha'nhèq đòiq am ca mangai Rubên; Ramôt nòi Ga-la-at đòiq am ca mangai Gat; Gôlan nòi Basan đòiq am ca mangai Ma-na-se. ");
INSERT INTO hre_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Cô ranenh Môise ma pa'noh jang ngìa jàn Is-ra-ên. ");
INSERT INTO hre_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Cô bàu anoi joq 'nàng, bàu thê wa ranenh Môise ma anoi 'noh am ca jàn Is-ra-ên jò wì loh khoi ca Diac Aicàp, ");
INSERT INTO hre_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","cwa pah tau cròng diac Jôđan, ta thòng ta jang ca Bêt Pêo, gùng Sihôn, bùa jàn A-mô-rit, ŏi Hêtbôn, aih bùa khoi 'bìq Môise wa jàn Is-ra-ên jêh 'blêq, atìq ca jò wì loh khoi ca gùng Aicàp. ");
INSERT INTO hre_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Jàn Is-ra-ên blah yŏc gùng haq wa gùng Ot, bùa da Basan, wa baiq toq bùa da jàn A-mô-rit ŏi pah tau cròng diac Jôđan pah mat mahì loh, ");
INSERT INTO hre_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","enh A-rô-e roc ti kenh thòng Atnôn, trùh wang Siôn, aih wang Hetmôn, ");
INSERT INTO hre_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","wa dìq ca đùng tamang pah tau cròng diac Jôđan, pah mat mahì loh trùh hloi diac raxìq A-ra-ba enh 'neq criang wang Phichga. ");
INSERT INTO hre_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Môise creo dìq ca jàn Is-ra-ên trùh, haq doi ca wì: Ôi Is-ra-ên, tamàng au anoi pa'noh ca pì bàu thê wa 'bài ranenh hì cô, đòiq pì hŏc waq ca loq wa dì tiaq rìm bìac aih. ");
INSERT INTO hre_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Chuaq Boc Plình bèn khoi broq wêh jao ca bèn jò ŏi ta wang Hôrêp. ");
INSERT INTO hre_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Chuaq ùh broq wêh jao cô toq ti 'bài boc bèn calah nèh, mahaq ti bèn, aih dìq ca bèn ma ŏi rìh hì cô. ");
INSERT INTO hre_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Chuaq enh ta'ne ùnh ngan jang ta pì jò ŏi ta bôi wang khoi capoch ca pì, ");
INSERT INTO hre_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","jò aih au yòng ta'ne Chuaq wa pì đòiq anoi 'noh bàu Chuaq, pì loq crè taiq ùnh, èh pì ùh hùa tŏc ta bôi wang. Chuaq doi: ");
INSERT INTO hre_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Au Chuaq Boc Plình pì, khoi 'ràng pì loh khoi ca gùng Aicàp, aih claih ca hnem broq hapŏng dìch. ");
INSERT INTO hre_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Enh gùng ca Au, pì paq cùh waiq yiang cleq ma 'noiq. ");
INSERT INTO hre_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Pì apaq broq ca dađeh dua 'mù, hadai apaq pùng padì dua 'mù leq tìah ca 'bài ngè ta plình ha'nhèq, ngè ŏi ta taneh, loq ta diac enh 'neq ca taneh. ");
INSERT INTO hre_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Pì apaq hacùn cràng cùh waiq 'bài dua 'mù aih wa apaq patìh wì haq, ma jah 'màng aih Au cô Chuaq Boc Plình pì, Boc Plình dìq jaq git ca bìac dù. Taiq tôiq boc yaq pì, Au baxa dìq ca con xau trùh piq pôn 'nhòng, ");
INSERT INTO hre_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","mahaq Au pa'noh can xa-ŏch xam manoh loq waq wì trùh bình ngŏng 'nhòng ca mangai leq loq waq ca Au wa wèq bàu thê da Au. ");
INSERT INTO hre_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Pì apaq yŏc hiniq Chuaq Boc Plình pì đòiq capoch pagôq, ma jah 'màng aih, Chuaq joq 'nàng baxa mangai ma yŏc hiniq Haq đòiq capoch pagôq. ");
INSERT INTO hre_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Pì phai wèq Hì Sabat đòiq jah wìa hì hadròih tiaq bàu thê da Chuaq Boc Plình pì khoi thê pì. ");
INSERT INTO hre_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Pì phai broq dìq dèh ca bìac cla ta tadràu hì beq, ");
INSERT INTO hre_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","mahaq hì ma tapèh aih Hì Sabat da Chuaq Boc Plình pì. Hì aih pì ùh jah broq mòiq bìac cleq, cla ìh, con calô, con cadrì, hapŏng calô, hapŏng cadrì, 'bo, lùa, loq mòiq toq ngè aban leq da pì, xam tamoi ŏi đò ta hnem pì, hadai jah padài troi pì. ");
INSERT INTO hre_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Pì phai hmàng pì hadai khoi broq hapŏng dìch nòi gùng Aicàp. Chuaq Boc Plình pì khoi yŏc tì cwìang itai 'nong pì loh khoi ca gùng aih, taiq nen aih Chuaq Boc Plình pì thê pì phai wèq Hì Sabat. ");
INSERT INTO hre_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Phai loq waq wa iu padèch dèh miq baq tiaq bàu Chuaq Boc Plình pì khoi thê, waq ca pì jah rìh halình wa i xôq ramŏt ta gùng Chuaq Boc Plình pì ma khoi hnhu am. ");
INSERT INTO hre_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Apaq jêh mangai. ");
INSERT INTO hre_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Apaq broq tôiq tango anang. ");
INSERT INTO hre_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Apaq atùng. ");
INSERT INTO hre_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Apaq anoi hlài bàu amòng tajraq hlài ca mangai haten hatìa. ");
INSERT INTO hre_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Pì apaq ham ca mai da mangai haten hatìa, hadai paq ham ca đùng taneh, hapŏng calô, hapŏng cadrì, 'bo, lùa, hadai ngè leq da mangai haten hatìa.” ");
INSERT INTO hre_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Ŏi ta bôi wang, ta'ne ùnh, yùc wa can clam clôiq, Chuaq dêh bàu capoch bàu cô am dìq ca pì, wa ùh tam bìac cleq. Khoi èh, Haq achìh bàu aih ta baiq capiac hmu, èh am ca au. ");
INSERT INTO hre_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Jò pì tàng bàu capoch loh enh nòi clam clôiq, jò bôi wang loh ùnh, dìq ca mangai broq gàu hadròng hadrech wa mangai broq craq wèq, thia haten ca au. ");
INSERT INTO hre_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","hi doi: “Chuaq Boc Plình nhèn khoi pa'noh can 'ngah 'ngai wa can rahù rahìac Haq am ca nhèn. Nhèn tàng bàu Haq capoch loh enh ta'ne ùnh. Hì cô nhèn hnoq Boc Plình hatùang ca mangai, mahaq mangai xôq ŏi rìh. ");
INSERT INTO hre_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Mahaq manàiq cô, hagleq bèn ma ep chìuq dìq jaq yat èh cachìt? Taiq ngia ùnh càn cô èh cheo bùh bèn, tàng bèn ŏi tàng bàu capoch da Chuaq yi dùnh hòm, èh bèn cachìt dŏng. ");
INSERT INTO hre_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Ma jah 'mang aih, ta con mangai, i cabô khoi tàng bàu da Boc Plình ma rìh hloi enh ta'ne ùnh capoch loh troi bèn, mahaq xôq ŏi rìh ùh? ");
INSERT INTO hre_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","'Màng aih, ìh thia haten beq, tamàng rìm bàu Chuaq Boc Plình bèn doi, hi khoi anoi 'noh hlài ca nhèn rìm bìac Chuaq Boc Plình bèn ma doi ca ìh, wa nhèn jah tàng, èh nhèn broq tiaq.” ");
INSERT INTO hre_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","'Nang jò pì anoi ca au, Chuaq tàng bàu da pì, dài Haq doi ca au: “Au tàng bàu jàn cô hatình ca ìh. Bàu wì haq doi dìq troq. ");
INSERT INTO hre_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Au ngèh enh jàn cô loq i manoh crè ca Au, wèq yôt bàu thê da Au, đòiq wì haq wa con xau wì haq jah xôq ramŏt hloi hloi! ");
INSERT INTO hre_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Lam doi ca jàn beq, thê wì hlài dèh ta traiq cla. ");
INSERT INTO hre_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Phàn da ìh, ìh ŏi hlài jang cô ti Au. Au anoi ca ìh dìq bàu thê, trong tiaq ranenh, wa bìac thê broq am ca ìh, đòiq ìh hnài wì haq, đòiq wì haq broq tiaq dìq bìac aih ta gùng Au padon am ca wì haq nhàn yŏc.” ");
INSERT INTO hre_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","'Màng aih pì phai wèq dađeh broq tiaq, rìm bìac Chuaq Boc Plình pì khoi thê pì, đòiq ùh hìaq wìh pah 'ma loq pah 'ngeo. ");
INSERT INTO hre_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Pì phai lam tiaq troq trong Chuaq Boc Plình pì ma khoi thê, đòiq pì jah rìh wa i xôq ramŏt jah ŏi dùnh ta gùng pì ma padon nhàn yŏc. ");
INSERT INTO hre_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Cô bàu thê, trong tiaq ranenh wa bìac thê broq, Chuaq Boc Plình pì khoi thê au hnài pì, đòiq pì broq tiaq bàu aih jò pì ŏi ta gùng pì padon lam mùt nhàn yŏc, ");
INSERT INTO hre_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","waq ca pì, con caiq wa con xau pì iu crè Chuaq Boc Plình pì, loq iu wèq trong ranenh da Haq wa bàu thê da Haq ma au thê pì broq tiaq đòiq pì jah rìh halình. ");
INSERT INTO hre_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Ôi Is-ra-ên, pì khòh tamàng wa wèq dađeh oq, waq ca pì jah xôq ramŏt, wa jah loh tam bàc ta gùng bình halùih sùa wa diac xùt; aih gùng Chuaq Boc Plình da boc yaq pì khoi rùp bàu am ca pì, ");
INSERT INTO hre_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Ôi Is-ra-ên, tamàng beq! Chuaq, Haq Boc Plình bèn. Toq mòiq Chuaq, Haq raq hêq. ");
INSERT INTO hre_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Pì phai dìq ca manoh, dìq ca mahua yiang, dìq ca padren loq waq ca Chuaq Boc Plình pì. ");
INSERT INTO hre_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Dìq ca bàu Au ma thê pì broq tiaq hì cô, phai ŏi ta manoh pì. ");
INSERT INTO hre_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Pì phai panim hnài bìac cô ca con caiq pì, anoi tùang bàu cô jò pì ha'ngui ta hnem, jò lam ta trong, jò ca'nùng wa jò rìu. ");
INSERT INTO hre_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Pì phai càt bàu cô ta tì cla, tìah ca teo hadro, wa ŏi jang ngòng pì đòiq jah hmàng. ");
INSERT INTO hre_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Pì phai achìh bàu aih ta long jrang 'mang hnem wa ta 'mang ngo pì. ");
INSERT INTO hre_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Jò Chuaq Boc Plình pì khoi 'nong pì mùt ta gùng Haq ma pachac am ca boc yaq pì, aih Ap-ra-ham, Isac wa Jacôp, đòiq am ca pì 'bài phôq càn lem ma pì ùh broq, ");
INSERT INTO hre_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","wa 'bài hnem khoi tôm dahwèq pì ùh rŏt, 'bài diac adràm pì ùh chìa, long nho wa long ôliu pì ùh pìt, èh pì caq jah panàc, ");
INSERT INTO hre_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ep wèq dađeh, apaq hèt ca Chuaq, Haq ma khoi 'nong pì loh khoi ca gùng Aicàp, aih claih ca broq hapŏng dìch. ");
INSERT INTO hre_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Pì ep loq iu, loq crè Chuaq Boc Plình pì, cùh waiq Haq wa yŏc hiniq Haq waiq pachac. ");
INSERT INTO hre_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Pì apaq tiaq 'bài can kiac, aih 'bài can kiac da 'bài tamoi ma ŏi dudan ca pì, ");
INSERT INTO hre_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ma jah 'màng aih Chuaq Boc Plình pì ŏi ta'ne pì, Haq Boc Plình loq tagrình, yùq Boc Plình pì nòih ca pì. Haq jêh hapùih đac pì loh enh crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Pì apaq 'bàt thù Chuaq Boc Plình pì, troi pì ma 'bàt thù Haq ta Masa. ");
INSERT INTO hre_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Pì phai dìq ca manoh wèq tiaq bàu thê da Chuaq Boc Plình pì, bàu hnài da Haq, wa trong ranenh ma Haq khoi thê pì dì tiaq. ");
INSERT INTO hre_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","'Màng aih, pì ep broq bìac troq wa lem jang enh ngìa Chuaq, đòiq pì jah xôq ramŏt wa mùt nhàn yŏc gùng jìang lem Chuaq ma khoi rùp bàu ca boc yaq pì, đòiq am ca pì, ");
INSERT INTO hre_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","wa rìm ngai git pì èh 'bìq Chuaq hnan đac troi Haq ma khoi doi. ");
INSERT INTO hre_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Atìq cô èh, jò con pì bòch pì: “Bàu thê, bìac thê broq wa trong tiaq ranenh da Chuaq Boc Plình ma khoi thê pì dì tiaq, aih enh doi cleq?” ");
INSERT INTO hre_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Èh pì phai tèu: “Bèn khoi broq hapŏng dìch ca Pha-ra-ôn ŏi ta gùng Aicàp, èh Chuaq khoi yŏc tì i cwìang itai 'nong bèn loh khoi ca Aicàp. ");
INSERT INTO hre_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Jang ngìa bèn Chuaq khoi broq bàc tèu halac, bìac halac dìq jaq càn caiq wa ramòt, baxa gùng Aicàp, Pha-ra-ôn wa dìq ca hnem haq. ");
INSERT INTO hre_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Haq khoi 'noh bèn loh khoi ca gùng aih, đòiq 'nong mùt gùng Haq ma khoi rùp bàu ca boc yaq bèn, đòiq am ca bèn. ");
INSERT INTO hre_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","'Màng aih Chuaq thê bèn phai broq tiaq dìq trong ranenh cô, loq iu crè ca Chuaq Boc Plình bèn, đòiq bèn yôt yôt jah xôq ramŏt wa jah rìh tìah troi Haq broq trùh hì cô. ");
INSERT INTO hre_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Aih bèn jah doi ta-atoq tàng bèn wèq dađeh wa broq tiaq dìq ca bàu thê cô ŏi jang ngìa Chuaq bèn, tìah troi Haq khoi thê bèn.” ");
INSERT INTO hre_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Jò Chuaq Boc Plình pì 'nong pì mùt ta gùng padon nhàn yŏc, hnan đac bàc jàn jang ngìa pì, jàn Hêtit, jàn Ghi-rê-ga-sit, jàn A-mô-rit, jàn Ca-na-an, jàn Pe-rê-xit, jàn Hêwit, wa jàn Jê-bu-xit, aih tapèh jàn càn dêh yi hnao ca pì, ");
INSERT INTO hre_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","wa jò Chuaq Boc Plình khoi am ca pì mangai jàn aih wa pì jêh 'blêq wì haq, èh ep jêh đac dŏng ma dìq, apaq wêh jao ca wì haq wa apaq xa-ŏch ca wì haq. ");
INSERT INTO hre_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Pì apaq taprŏi ca wì haq, apaq am con cadrì pì yŏc con calô wì haq, hadai apaq am con cadrì wì haq yŏc con calô pì. ");
INSERT INTO hre_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Ma jah 'màng aih wì haq padô con calô pì cađac trong tiaq Au, èh lam patìh 'bài can kiac, broq ca can nòih da Au plôh tŏc ta pì, hi khoi Haq renh jêh đac pì. ");
INSERT INTO hre_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Mahaq pì ep broq ca jàn aih 'màng cô: Raliang đac dìq ca'bŏng tadreo, tùq đac dìq dua 'mù, blai đac dìq jrang dua 'mù cadrì A-sê-ra wa bùh đac dìq dua 'mù da wì haq. ");
INSERT INTO hre_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Ma jah 'màng aih pì jàn hadròih da Chuaq Boc Plình pì, taiq ta'ne dìq jàn ta crŏng taneh, Haq khoi ràih pì wìa jàn lah crài da Haq ŏi crŏng taneh. ");
INSERT INTO hre_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Chuaq loq waq ca pì, ùh xài taiq pì yi bàc ca mangai jàn 'noiq, ma joq 'nàng pì yi 'biaq ca dìq jàn 'noiq, ");
INSERT INTO hre_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","mahaq aih taiq Chuaq loq waq ca pì, wèq bàu pachac ca boc yaq pì, dài haq Chuaq hnhu tì i cwìang itai dèch pì loh, wa rŏt hlài pì claih enh gùng broq hapŏng dìch, dèch pì claih enh tì Pha-ra-ôn bùa Diac Aicàp. ");
INSERT INTO hre_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","'Màng aih pì phai loq: Chuaq Boc Plình pì, Haq Boc Plình wèq dèh bàu, wèq bìac wêh jao wa can xa-ŏch xam manoh loq waq trùh bình ngŏng 'nhòng ca mangai leq loq waq wa wèq bàu thê da Haq; ");
INSERT INTO hre_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","mahaq Haq tajraq hlài tajòi 'mòi ca wì ma git ca Haq, hi