﻿USE sofia;
DROP TABLE IF EXISTS sofia.hoy_vpl;
CREATE TABLE hoy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hoy_vpl WRITE;
INSERT INTO hoy_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","सुरूवात दा परमेश्वर आकाश अदिक पृथ्‍वी इंद रचना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्‍वी बेकार अदिक सुनसान बिदकु ईरोद, अदिक गहरा नीर इन म्‍याकुच अंधार ईरोद; अदिक परमेश्वर उन आत्मा नीर इन म्‍याकुच वयाळतोगोद. ");
INSERT INTO hoy_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","याग परमेश्वर अंदुन, “ऊजोळ आगेग,” रा ऊजोळ आगेत. ");
INSERT INTO hoy_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","अदिक परमेश्वर ऊजोळ इक नोळदुन कि वळ्‍लीद आद; अदिक परमेश्वर ऊजोळ इक अंधार टु अलग माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","अदिक परमेश्वर ऊजुळ इक हागुल अदिक अंधार इक ईळ्‍ल्‍क अंदुन. अदिक द्‍यावगा आत बाक व्‍हातुर आत. ई प्रकार पयला दिन आगेत. ");
INSERT INTO hoy_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","बाक परमेश्वर अंदुन, “नीर इन बीच दा ऊंद ईत्‍ता अंतर आगुल कि नीर येढ्‍ढ भाग आगेगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","आग परमेश्वर ऊंद अंतर माळकु अदुर ल्‍यालमागोळोद नीर अदिक अदुर म्‍याकुच इन नीर इक अलग अलग माळदुन; अदिक हांग अच आत. ");
INSERT INTO hoy_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","अदिक परमेश्वर आ अंतर इक आकाश अंदुन. बाक द्‍यावगा आत बाक व्‍हातुर आत. ई प्रकार दुसरा दिन आत. ");
INSERT INTO hoy_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","बाक परमेश्वर अंदुन, “आकाश इन ल्‍यालमागोळोद नीर ऊंद जागा दा जमा आगेगुल अदिक वळ्गींद जागा कांळ्‍सुल,” अदिक हांग अच आत. ");
INSERT INTO hoy_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेश्वर वळ्गींद जागा अक पृथ्‍वी अंदुन, बाक जो नीर जमा आत अदरी आव समुद्र अंदुन: अदिक बाक परमेश्वर नोळदुन कि वळ्‍लीद आद. ");
INSERT INTO hoy_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","बाक परमेश्वर अंदुन, “पृथ्‍वी टु हिवरा कचरा, अदिक बींजावाळा श्‍याणेव श्‍याणेव मार्र, अदिक काय कोळावाळा मार्र भी यदुरव बींजा अऊर दा टु ऊंद ऊंद इन जात इन अनुसार आद, पृथ्‍वी मा जगसुल,” अदिक हांग अच आद. ");
INSERT INTO hoy_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ई प्रकार पृथ्‍वी टु हिवरा कचरा, अदिक श्‍याणेव श्‍याणेव मार्र, यदुर दा तान तान जात इन अनुसार बींजा ईरतद, अदिक काय कोळावाळा मार्र यदुरव बींजा ऊंद ऊंद जात इन अनुसार अऊर दा ईरताव जगसुल: अदिक परमेश्वर नोळदुन कि वळ्‍लीद आद. ");
INSERT INTO hoy_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","अदिक द्‍यावगा आत अदिक बाक व्‍हातुर आत. ई प्रकार तीसरा दिन आगेत. ");
INSERT INTO hoy_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","बाक परमेश्वर अंदुन, “दिन इक ईळ्‍ल्‍क टु अलग माळोर साटी आकाश इन अंतर दा ज्‍योतीगोळ आगुल; अदिक अव चिन्हगोळ, अदिक नियत समयगोळ अदिक दिनगोळ, अदिक वर्षगोळ कारण आगुल; ");
INSERT INTO hoy_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","अदिक अव ज्‍योतीगोळ आकाश इन अंतर दा पृथ्‍वी मा ऊजोळ कोळावाळा भी ठहरूसुल,” अदिक हांग अच आत. ");
INSERT INTO hoy_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","आग परमेश्वर येढ्‍ढ धोड्‍डेव ज्‍योतीगोळ माळदुन; अदुर दा टु धोळ्‍द ज्योति इक हागुल दा प्रभुता माळोरसाटी अदिक श्‍याण ज्योति इक ईळ्‍ल्‍क दा प्रभुता माळोरसाटी माळदुन; अदिक तारागोळ इक भी माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","परमेश्वर अवरी आकाश इन अंतर मा इदुरसाटी ईटदुन कि अव पृथ्‍वी मा ऊजोळ कोळुल, ");
INSERT INTO hoy_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","यतिकी हागुल अदिक ईळ्‍ल्‍क मा प्रभुता माळुल, अदिक ऊजुळ इक अंधकार से अलग माळुल: अदिक परमेश्वर नोळदुन कि वळ्लीद आद. ");
INSERT INTO hoy_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","अदिक द्‍यावगा आत बाक व्‍हातुर आत. ई प्रकार चौथा दिन आगेत. ");
INSERT INTO hoy_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","बाक परमेश्वर अंदुन, “नीर जीत्‍ता प्राणीगोळ से हापाळ अच तुम्‍मेगुल, अदिक पक्षी पृथ्‍वी इन म्‍याकुच आकाश इन अंतर मा उळुसुल.” ");
INSERT INTO hoy_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","इदुरसाटी परमेश्वर जाती जाती इन धोळ धोळ नीर दाकळव जन्‍तुगोळ्‍द, अदिक आ सप्‍पा जीत्‍ता प्राणीगोळव भी रचना माळदुन जो नळुताव वयाळताव अऊर देल नीर हापाळ अच तुम्‍मेत, अदिक ऊंद ऊंद जाती इन ऊळुसावाळा पक्षीगोळ्द भी रचना माळदुन: अदिक परमेश्वर नोळदुन कि वळ्‍लीद आद. ");
INSERT INTO hoy_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","अदिक परमेश्वर ईद अनकु अवरी आशीर्वाद कोट्‍टुन, “वाळुसतेला होगी, अदिक समुद्र अन नीर दा तुम्‍मेगी, अदिक पक्षी पृथ्‍वी मा वाळुसुल.” ");
INSERT INTO hoy_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","अदिक द्यावगा आत बाक व्‍हातुर आत. ई प्रकार पाचवा दिन आगेत. ");
INSERT INTO hoy_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","बाक परमेश्वर अंदुन, “पृथ्‍वी माकळव ऊंद ऊंद जाती इन जीत्‍ता प्राणी, मतलब घरेलु पशु, अदिक रांगसावाळा किळा, अदिक पृथ्‍वी इन वनपशु, जाती जाती इन वन-पशुगोळी, जाती जाती इन अनुसार पैदा आगुल,” अदिक हांग अच आत. ");
INSERT INTO hoy_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ई प्रकार परमेश्वर पृथ्‍वी इन जाती जाती इन वन-पशुगोळी, अदिक जाती जाती इन जमीन मा सप्‍पा रांगसावाळा किळागोळी माळदुन: अदिक परमेश्वर नोळदुन कि वळ्‍लीद आद. ");
INSERT INTO hoy_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","बाक परमेश्वर अंदुन, “नाव मंळसा अक तान स्‍वरूप इन अनुसार तान समानता दा माळेव; अदिक अव समुद्र दाकळव मेनगोळ, अदिक आकाश इन पक्षीगोळ, अदिक मान्‍यागोळोव पशुगोळ, अदिक पुरा पृथ्‍वी मा, अदिक सप्‍पा रांगसावाळा किळागोळ मा जो पृथ्‍वी मा रांगस्‍ताव, अधिकार ईटी.” ");
INSERT INTO hoy_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","आग परमेश्वर मंळसा अक तान स्‍वरूप इन अनुसार पैदा माळदुन, तांद अच स्‍वरूप इन अनुसार परमेश्वर आऊक पैदा माळदुन; गंळ्स अदिक आर्त माळकु आव मंळसागोळ्‍द रचना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","अदिक परमेश्वर आंदरी आशीर्वाद कोट्‍टुन, अदिक आंदुर से अंदुन, “वाळुसी, अदिक पृथ्‍वी मा तुम्‍मेगी, अदिक अदरी तान अधिकार दा माळकोमी; अदिक समुद्र दाकळव मेनगोळ, अदिक आकाश इन पक्षीगोळ, अदिक पृथ्‍वी मा रांगसावाळा सप्‍पा जन्‍तुगोळ मा अधिकार ईटी.” ");
INSERT INTO hoy_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","बाक परमेश्वर आंदुर से अंदुन, “केळी यास बींजावाळा श्‍याणेव श्‍याणेव मार्र पुरा पृथ्‍वी इन म्‍याकुच आव अदिक यास मार्रगोळ दा बींजावाला काय ईरताव, अव सप्‍पा ना नीमी कोटबुट्टीन; अव नीम भोजन इन साटी हूँ. ");
INSERT INTO hoy_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","अदिक यास पृथ्‍वी इन पशु, अदिक आकाश इन पक्षी, अदिक पृथ्‍वी मा रांगसावाळा किळागोळ आव, अऊर दा जीवन इन प्राण आद, आ सप्‍पा अक तीनोर साटी ना सप्‍पा हिवरा हिवरा श्‍याणेव श्‍याणेव मार्र कोटीन,” अदिक हांग अच आत. ");
INSERT INTO hoy_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","आग परमेश्वर जो येनारा माळीदुन सप्‍पा अक नोळदुन, कि अद हापाळ अच वळ्‍लीद आद, द्‍यावगा आत बाक व्‍हातुर आत. ई प्रकार आरवा दिन आगेत. ");
INSERT INTO hoy_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ई प्रकार आकाश अदिक पृथ्‍वी अदिक जो येनारा अदुर्दा आद अदुर्द रचना पुरा आत. ");
INSERT INTO hoy_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","अदिक परमेश्वर तान क्‍याल्‍सा यदरी आव माळतोगोन सातवा दिशी पुरा माळदुन, अदिक आव तान माळदव पुरा क्‍याल्‍सागोळ से सातवा दिशी आराम माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","अदिक परमेश्वर सातवा दिशी इक आशीष कोट्‍टुन अदिक पवित्र ठहरूसदुन; यतिकी अदुर्दा आव जगत इन रचना अन तान सप्‍पा क्‍याल्‍सा देल आराम ताकोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","आकाश अदिक पृथ्‍वी इन रचना अन्‍द वृत्‍तान्‍त ईद आद कि याग अव उत्‍पन्‍न आदव मतलब या दिशी यहोवा परमेश्वर पृथ्‍वी अदिक आकाश इक माळदुन: ");
INSERT INTO hoy_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","आग मैदान इन यातोदु पौधा जमीन मा ईला ईरोद, न मैदान इन यातोदु श्‍याण मार्र उगुसकु ईरोद, यतिकी यहोवा परमेश्वर पृथ्‍वी मा नीर ईला बरसुसीदुन, अदिक जमीन मा खेती माळोरसाटी याऊ मंळसा भी ईला ईरोन; ");
INSERT INTO hoy_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","तरी भी कोहरा पृथ्‍वी टु येळतोगोद यदुर देल पुरा जमीन हस आगतोगोद. ");
INSERT INTO hoy_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","आग यहोवा परमेश्वर मंळसा अक जमीन इन मुण्‍ण देल माळदुन, अदिक आऊन मुग्ग दा जीवन इन श्‍वास ऊरदुन; अदिक मंळसा जित्ता प्राणी आगेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","अदिक यहोवा परमेश्वर पूर्व इन दी अदन दा ऊंद वाटीका हचदुन, अदिक अल मंळसा अक यारी आव माळीदुन, ईट बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","अदिक यहोवा परमेश्वर जमीन टु सप्‍पा प्रकार इन मार्र, जो नोळदुर दा मन मोहक अदिक अऊर काय तीनदुर दा वळ्‍लेव आव, हचदुन, अदिक बगीचा अन बीच दा जीवन इन मार्र इक अदिक भला अदिक बुरा अन ग्यान इन मार्र भी हचदुन. ");
INSERT INTO hoy_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","आ वाटीका अक हस माळोरसाटी ऊंद महा गांगा अदन टु होळ्‍त अदिक अल टु मुंद वाळुसकु नाक धारागोळ दा वाटसेत. ");
INSERT INTO hoy_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पयला धारा अन हेसुर पीशोन ईरोद; ईद अदा हुन जो हवीला हेसुर इन पुरा द्‍याश इक येल व्‍हान्‍ना सीकतद, घेरस्‍कु आद. ");
INSERT INTO hoy_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","आ द्‍याश इन व्‍हान्‍ना वळ्‍लीद ईरतद; अल मोती अदिक सुलैमानी कल्ल भी सीकताव. ");
INSERT INTO hoy_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दुसरा गांगा अन्द हेसुर गीहोन आद; ईद अदा हुन जो कूश इन पुरा द्‍याश इक घेरस्‍कु आद. ");
INSERT INTO hoy_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","अदिक तीसरा गांगा अन्द हेसुर हिद्देकेल आद; ईद अदा हुन जो अश्शूर इन पूर्व इन दी वाहुसतद. अदिक चौथा गांगा अन्द हेसुर फरात आद. ");
INSERT INTO hoy_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","आग यहोवा परमेश्वर मंळसा अक हुळकु अदन इन वाटीका दा ईट बुट्‍टुन, कि आव अल क्‍याल्‍सा माळुल अदिक आ वाटीका अन्द रक्षा माळुल. ");
INSERT INTO hoy_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","अदिक यहोवा परमेश्वर मंळसा अक ईद आग्‍या कोट्‍टुन, “नी वाटीका अन्द सप्‍पा मार्र इन काय बेझीझक आगकु तीन सकत्‍या; ");
INSERT INTO hoy_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","लेकीन भला या बुरा अन ग्यान इन जो मार्र आद, अदुर्द काय नी यागलु तिनबाळेत: यतिकी या दिशी नी अदुर्द काय तिनद्या अदा दिशी जरूर सोत्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","बाक यहोवा परमेश्वर अंदुन, “आदम उन आबना ईरोद वळ्‍लीद हैलेच; ना आऊन साटी ऊंद उपयुक्त सहायक माळाईन जो आऊन से मेल तीनुल.” ");
INSERT INTO hoy_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","अदिक यहोवा परमेश्वर जमीन दा टु सप्‍पा जाती इन वनपशु अदिक आकाश इन सप्‍पा प्रकार इन पक्षीगोळ इक माळकु आदम उन हात्‍ती तंदुन कि आव नोळुल अदिक अऊर हेसुर येन येन ईटतान; अदिक आदम सप्‍पा जित्ता प्राणीगोळ इक जो जो हेसुर कोट्‍टुन, अदा अऊर हेसुर आगेत. ");
INSERT INTO hoy_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","अदिक आदम सप्‍पा मान्‍ना दाकळव पशुगोळ, आकाश इन पक्षीगोळ, अदिक जमीन इन सप्‍पा वनपशु उन हेसुर ईटदुन, लेकीन आदम उक योग्य सहायक सिकीदील. ");
INSERT INTO hoy_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","आग यहोवा परमेश्वर आदम उक भारी जप दा हाकबुट्‍टुन, अदिक याग आव मींगेदुन आग आव आऊन ऊंद पसली तेगुकु अदुर जागा दा मास तुमदुन. ");
INSERT INTO hoy_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","अदिक यहोवा परमेश्वर आ पसली इक जो आदम दा टु तेगदीदुन, आर्त माळदुन; अदिक आकी आदम उन हात्‍ती तंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","आग आदम अंदुन, “ईग ईक नान येलुगोळ दा टु येलु अदिक नान मास दा टु मास हुळ; इदुरसाटी ईकीन हेसुर आर्त आदीत, यतिकी ईक गंळ्स दा टु तेगुकु आग्‍यार.” ");
INSERT INTO hoy_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ई कारण मंळसा तान मोय-आप्प उक बिटकु तान हिंग्स उन सांगुळ ईत्‍तान, अदिक आंदुर येढ्ढु मुंदुर ऊंद तन आदार. ");
INSERT INTO hoy_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","आदम अदिक आऊन हिंग्‍स येढ्‍ढु बिना कपळा देल ईरोर, लेकीन नाचोर ईला. ");
INSERT INTO hoy_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","यहोवा परमेश्वर यास आळी दाकळव जनावर माळीदुन, आ सब दा हाव चालाक ईरोद; अद हाव आर्त इन से अंत, “येन खरा आद कि परमेश्वर अंदान, ‘नीव ईद बगीचा अन्‍द यातोदु मार्र इन काय तिनबाळेतीर’?” ");
INSERT INTO hoy_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","आर्त हाव से अंदुर, “ई बगीचा अन मार्र इन काय नाव तीन सकतेव; ");
INSERT INTO hoy_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","लेकीन जो मार्र बगीचा अन बीच दा आद, अदुर काय इन बारा दा परमेश्वर अंदान कि न रा नीव तीनेतीर अदिक न अदरी मुटेतीर, ईला रा सोतोदीर.” ");
INSERT INTO hoy_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","आग हाव आर्त से अंत, “नीव सही दा सायतीदिल! ");
INSERT INTO hoy_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","बल्‍की परमेश्वर जान्‍सतान कि या दिशी नीव अदुर काय तिंदीर अदा दिशी नीम कण्‍ण खुलसेदव, अदिक नीमी भला बुरा अन्द ग्‍यान सीकीत अदिक नीव परमेश्वर उन घाई आगेदीर.” ");
INSERT INTO hoy_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","याग आर्त नोळदुर कि आ मार्र इन काय तीनोर साटी वळ्‍लीद, अदिक नोळदुर दा हापाळ लुभावना, अदिक ग्यान कोळोर साटी चहासा लायक आद; आग आक अदुर काय मुरूकु तिंदुर, अदिक तान गांड उक भी कोट्‍टुर, अदिक आव भी तिंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","आग आ येढ्‍ढु मुंदुरव कण्‍णगोळ खुलसेदव, अदिक आंदरी मालुम आत कि आंदुर ऊगळा आर; इदुरसाटी आंदुर अंजीर इन याल्ला जोळ्स जोळ्‍सकु लंगोट माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","आग यहोवा परमेश्वर, जो हागुल इन ठंडा समय बगीचा दा वयाळ तोगोर, आंदरी शब्‍द केळ बत्‍त. आग आदम अदिक आऊन हिंग्‍स बगीचा अन मार्र इन बीच परमेश्वर उन से होचकोंडुर. ");
INSERT INTO hoy_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","आग यहोवा परमेश्वर आदम उक कारूकु आऊन से केळदुन, “नी येल आय?” ");
INSERT INTO hoy_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","आव अंदुन, “ना नीन शब्‍द बगीचा दा केळकु अंजेदीन, यतिकी ना ऊगळा ईरीन; इदुरसाटी होचकोंडीन.” ");
INSERT INTO hoy_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","परमेश्वर अंदुन, “याव नीनी हेळदुन कि नी ऊगळा आय? याता मार्र इन काय ना नीनी तीनली मना माळीदिन, येन नी अदुर काय तींद्‍या?” ");
INSERT INTO hoy_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदम अंदुन, “याता आर्त इक नी नान सांगुळ ईरली कोट्या आका आ मार्र इन काय नानी कोट्‍टुर, अदिक ना तिंदीन.” ");
INSERT INTO hoy_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","आग यहोवा परमेश्वर आ आर्त से अंदुन, “नी ईद येन माळ्‍द?” आर्त अंदुर, “हाव नानी बहकुस बुळ्‍त, आग ना तिंदीन.” ");
INSERT INTO hoy_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","आग यहोवा परमेश्वर हाव से अंदुन, “नी जो ईद माळ्‍द इदुरसाटी नी सप्‍पा मान्‍यागोळोव जनावरगोळ, अदिक सप्‍पा आळी दाकळव जनावर से येक्‍कुल श्रापित आय; नी व्‍हाटा अन सहारा देल नळद्‍या, अदिक जीवन तीम मुण्‍ण नेकतेला ईत्‍या: ");
INSERT INTO hoy_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","अदिक ना नीन अदिक ई आर्त इन बीच दा, अदिक नीन वंश अदिक ईकीन वंश इन बीच दा सिट्‍ट पैदा माळाईन; आव नीन ताल्‍ला अक कुचलुस्‍यान अदिक नी आऊन तर काल इक कच्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","बाक आर्त से आव अंदुन, “ना नीन दुख अदिक नीन व्‍हाट्‍यादी आगोद दुख इक हापाळ वाळुसाईन; नी हापाळ दुख सहन माळकु पार उक पैदा माळ्‍या; अदिक नीन लालसा नीन गांड उन मा ईत्‍तीत, अदिक आव नीन मा प्रभुता माळ्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","अदिक आदम से आव अंदुन, “नी जो तान हिंग्‍स उन मात केळ्‍द, अदिक या मार्र इन काय इन बारा दा ना नीनी आग्‍या कोटीदीन कि नी अदरी तिनबाळेत, अदरी नी तिंद इदुरसाटी जागा नीन कारण श्रापित आद. नी अदुर ऊपज जीवन तीम दुख इन सांगुळ तिनतोद्‍या; ");
INSERT INTO hoy_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","अदिक अद नीन साटी मुळ्‍ल बेळ्‍दीत, अदिक नी केई इन ऊपज तिंद्या; ");
INSERT INTO hoy_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","अदिक तान मेहनत इन कमाई इन रोट्‍टी तिनतोद्‍या, अदिक आखरी दा मुण्‍ण दा सिकेद्‍या यतिकी नी अदुर दा टु उच तेगुकु आग्या; नी मुण्‍ण रा हुय अदिक मुण्‍ण दा का मात सिकेद्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदम तान हिंग्‍स उन हेसुर हवा ईटदुन; यतिकी यास मंळसा जित्ता आर आ सप्‍पा मुंदुर आदिमाता आका आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","अदिक यहोवा परमेश्वर आदम अदिक आऊन हिंग्‍स उन साटी तोगुल इन अँगरखा माळकु आंदरी हाकसुस बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","बाक यहोवा परमेश्वर अंदुन, “मंळसा भला बुरा अन ग्‍यान ताकोमकु नाम दा टु ऊंद इन घाई आगेग्‍यान: इदुरसाटी ईग हिंग आग बाळुल कि आव कय वाळुसकु जीवन इन मार्र इन काय भी मुरूकु तीन कोमुल अदिक सदा जीवित ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","इदुरसाटी यहोवा परमेश्वर आऊक अदन इन बगीचा दा टु तेगु बुट्‍टुन कि आ जागा मा खेती माळुल यदुर दा टु आव माळकु आगीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","इदुरसाटी आदम उक आव तेगु बुट्‍टुन अदिक जीवन इन हादी इन पहरा कोळोर साटी अदन इन बगीचा अन पूर्व दी जीत्‍ता प्राणीगोळी, अदिक नाकु दी वयाळावाळा ज्‍वालामय तलवार इक भी हासील माळ कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","याग आदम तान हिंग्‍स हवा अन हाती होदुन आग आक व्‍हाट्‍यादी ईतकु कैन उक जनम कोट्‍टुर अदिक अंदुर, “नानी यहोवा अन सहारा देल ऊंद गंळ्स सिकदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","बाक आक आऊन श्‍याण वार्ट हाबिल उक भी जनम कोट्‍टुर. हाबिल मर्र-म्यांडागोळी आळसावाळा आदुन, लेकीन कैन जागा मा खेती माळावाळा किसान आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","येनारा दिन इन बाद्‍दा हिंग आत कि कैन तान जागा अन्द ऊपज दा टु यहोवा अन साटी भेंट तंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","अदिक हाबिल भी तान मर्र-म्यांडा गोळोव पयला चिकोर दा टु भेंट येर्सली तंदुन अदिक अऊर न्याण भेंट येर्सदुन; आग यहोवा हाबिल अदिक आऊन भेंट इक रा ग्रहण माळदुन, ");
INSERT INTO hoy_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","लेकीन कैन अदिक आऊन भेंट इक ग्रहण माळीदिल. आग कैन हापाळ सिट्‍ट दा बंदुन? अदिक आऊन मार्रा मा उदासी होट्‍ट बत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","आग यहोवा कैन से अंदुन, “नी येती सिट्‍टी बंद? अदिक नीन मार्रा मा उदासी यती बत्‍त? ");
INSERT INTO hoy_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","अगर नी भला माळ्‍या रा येन नीन भेंट ग्रहण माळकु आगतीदील? अगर नी भला माळाल, रा पाप दरवाजा मा होचकु ईरतद; अदिक अदुर लालसा नीन दी ईत्‍तीत, अदिक नीनी अदुर मा प्रभुता माळोद आद.” ");
INSERT INTO hoy_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","आग कैन तान वार्ट हाबिल से येनारा अंदुन; अदिक याग आंदुर मैदान मा ईरोर, आग कैन तान वार्ट हाबिल मा येरकु आऊक कोंद बुट्‍टुन; ");
INSERT INTO hoy_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","आग यहोवा कैन से केळदुन, “नीन वार्ट हाबिल येल आन?” आव अंदुन, यम्‍बाल; येन ना तान वार्ट उन रखवाला हुईन? ");
INSERT INTO hoy_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","आव अंदुन, “नी येन माळ्‍द? नीन वार्ट उन रक्‍ता जमीन टु नान दी चिळ्‍लासकु नान दोहाई कोळेत्‍याद! ");
INSERT INTO hoy_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","इदुरसाटी ईग जागा नीन वार्ट उन रक्‍ता नीन कय देल कुडोर साटी तान बाय तेरदाद, अदुर दी टु नी श्रापित आय. ");
INSERT INTO hoy_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","अगर नी जागा मा खेती माळ्‍या, तरी भी अदुर पुरा ऊपज बाक नीनी सिकतीदील; अदिक पृथ्‍वी मा भटकुसावाळा अदिक भगोळा आद्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","आग कैन यहोवा से अंदुन, “नान दण्ड सहन इन व्‍हार्या आद. ");
INSERT INTO hoy_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","नोळ, नी ईंद इन दिशी नानी भूमी मा टु तेगद्‍या, अदिक ना नीन नजर इन मुंद ईराईन; अदिक पृथ्‍वी मा भटकुसावाळा अदिक भगोळा ईराईन; हिंग आग बाळुल कि जो यावारा नानी पाऊस्‍यान, नानी कोंद बुट्‍टान.” ");
INSERT INTO hoy_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ई कारण यहोवा आऊन से अंदुन, “जो यावारा कैन इक कोंदान आऊन सांगुळ येळ गुणा बदला ताकोमकु आदीत.” अदिक यहोवा कैन उन साटी ऊंद चिन्ह ठहरूसदुन हिंग आग बाळुल कि यावारा आऊक पाऊसकु कोंद बुळुल. ");
INSERT INTO hoy_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","आग कैन यहोवा अन हाती टु होटोदुन, अदिक नोद हेसुर इन द्‍याश दा जो अदन इन पूर्व अन दी आद, ईरली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","याग कैन तान हिंग्‍स उन हाती होदुन आग आक व्‍हाट्‍यादी ईत्‍तुर, अदिक आक हनोक उक जनम कोट्‍टुर; बाक कैन ऊंद नगर बसुसदुन अदिक आ नगर इन हेसुर तान पार उन हेसुर मा हनोक ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","अदिक हनोक देल ईराद पैदा आदुन, अदिक ईराद देल महूयाएल पैदा आदुन, अदिक महूयाएल देल मतूशाएल, अदिक मतूशाएल देल लेमेक पैदा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेक येढ्‍ढ हिंग्‍सुर माळदुन: आंदुर दा टु ऊंद इन हेसुर आदा, अदिक दुसरा अन हेसुर सिल्‍ला ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदा याबाल उक जन्म कोट्‍टुर. आव आ सप्‍पा लॉकुरव पुर्वज आदुन जो ड्‍यारागोळ दा ईरतोगोर अदिक जनावरगोळ सालुतोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","अदिक आऊन वार्ट उन हेसुर यूबाल ईरोद. ईव आ लॉकुरव पुर्वज आदुन जो विणा अदिक कोळ्‍ल उयतोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","अदिक सिल्‍ला भी तूबल-कैन हेसुर इनव पार उक जनम कोट्टुर: आव कासा अदिक लोहा अन सप्‍पा सामान माळावाळा आदुन. अदिक तूबल-कैन उन आकतींग नामा ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","अदिक लेमेक तान हिंग्‍सुर से अंदुन: “अने आदा अदिक अने सिल्‍ला, नान मात केळी, अने लेमेक उन हिंग्‍सुरा, नान मात ध्‍यान देल केळी: ना ऊंद गंळ्स उक याव नानी घायल माळीदुन, मतलब ऊंद जवान उक याव नानी चोट पोहचुसीदुन, कोंद बुटीन.” ");
INSERT INTO hoy_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","अगर कैन उन बदला येळ गुणा रा लेमेक उन बदला सत्‍तर गुणा चुकुसकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदम बाक मात तान हिंग्‍स उन हाती होदुन, अदिक आक ऊंद पार उक जनम कोट्‍टुर अदिक आऊन हेसुर ईद अनकु शेत ईटदुर: “परमेश्वर नान साटी हाबिल इन बदला, यारी कैन कोंद बुट्‍टीदुन, ऊंद अदिक पार कोट्‍टुन.” ");
INSERT INTO hoy_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेत उक भी ऊंद पार पैदा आदुन. आव आऊन हेसुर एनोश ईटदुन. अदा समय टु लॉकुर यहोवा अन्‍द हेसुर ताकोमकु प्रार्थना माळली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदम उन वंशावली ई प्रकार देल आद. याग परमेश्वर मंळसा अन्द रचना माळदुन आग आव तांद अच स्‍वरूप इन घाई आऊक माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","आव आंदरी गंळ्स अदिक आर्त माळकु मंळसागोळ्‍द रचना माळदुन अदिक आंदरी आशीर्वाद कोट्‍टुन, अदिक रचना अन दिशी आंदुर हेसुर आदम ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","याग आदम ऊंद सौ तीस वर्ष इन ईरोन, आग आऊन समानता दा, आऊन स्‍वरूप इन अनुसार, आऊन ऊंद पार पैदा आदुन. आव आऊन हेसुर शेत ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","शेत उन जनम इन बाद्‍दा आदम येट्ट सौ वर्ष मात्त जीत्‍ता ईत्‍तुन, बाक आऊक भी मात्त पार पोरगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ई प्रकार देल आदम उन पुरा ऊमर ऊम्बत सौ तीस वर्ष इन आत; आग आव सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","याग शेत ऊंद सौ अईद वर्ष नव आदुन, आग आऊन से एनोश पैदा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोश उन जनम इन बाद्‍दा शेत येट्‍ट सौ येळ वर्ष जीत्‍ता ईत्‍तुन, अदिक आऊक भी पार पोरगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ई प्रकार देल शेत उन पुरा ऊमर ऊम्बत सौ हन्‍नेळ वर्ष इन आत; अदुर बाद्‍दा आव सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","याग एनोश नब्‍बे वर्ष इनव आदुन, आग आऊन से केनान उन जनम आत. ");
INSERT INTO hoy_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान उन जनम इन बाद्‍दा एनोश येट्‍ट सौ पंदरा वर्ष जीत्‍ता ईत्‍तुन, आऊक भी मात्त पार पोरगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ई प्रकार देल एनोश उन पुरा ऊमर ऊम्बत सौ अईद वर्ष इन आत; अदुर बाद्‍दा आव सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","याग केनान सत्‍तर वर्ष ईनव आदुन, आग आऊन से महललेल उन जनम आत. ");
INSERT INTO hoy_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महललेल उन जनम इन बाद्‍दा केनान येट्‍ट सौ चालीस वर्ष जीत्‍ता ईत्‍तुन, आऊक पार पोरगोळ मात्त पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ई प्रकार देल केनान उन पुरा उमर ऊम्बत सौ हत्‍त वर्ष इन आत; अदुर बाद्‍दा आव सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","याग महललेल पैसट वर्ष इनव आदुन, आग आऊन से येरेद उन जनम आत. ");
INSERT INTO hoy_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","येरेद उन जनम इन बाद्‍दा महललेल येट्‍ट सौ तीस वर्ष जीत्‍ता ईत्तुन, आऊक मात्त भी पार पोरगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ई प्रकार देल महललेल उन ऊमर येट्‍ट सौ पंच्‍यानव वर्ष इन आत; अदुर बाद्‍दा आव सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","याग येरेद ऊंद सौ बासठ वर्ष इन आदुन, आग आऊन से हनोक उन जनम आत. ");
INSERT INTO hoy_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोक उन जनम इन बाद्‍दा येरेद येट्‍ट सौ वर्ष जीत्‍ता ईत्‍तुन, आऊक मात्त पार पोरगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ई प्रकार देल येरेद उन पुरा ऊमर ऊम्बत सौ बासठ वर्ष इन आत; अदुर बाद्‍दा आव सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","याग हनोक पैसठ वर्ष इन आदुन, आग आऊन से मतूशेलह उन जनम आत. ");
INSERT INTO hoy_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मतूशेलह उन जनम इन बाद्‍दा हनोक मुर सौ वर्ष ताका परमेश्वर उन सांगुळ सांगुळ नळुतेला ईत्‍तुन, आऊक मात्त पार पोरगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ई प्रकार देल हनोक उन पुरा ऊमर मुर सौ पैसठ वर्ष इन आत. ");
INSERT INTO hoy_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोक परमेश्वर उन सांगुळ सांगुळ नळुतोगोन; बाक आव गायब आगेदुन, यतिकी परमेश्वर आऊक म्याकुच नेगु कोंडीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","याग मतूशेलह ऊंद सौ सत्‍यासी वर्ष इन आदुन, आग आऊन से लेमेक उन जनम आत. ");
INSERT INTO hoy_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लेमेक उन जनम इन बाद्‍दा मतूशेलह येळ सौ बयासी वर्ष जीत्‍ता ईत्‍तुन, आऊक मात्त पार पोरगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ई प्रकार देल मतूशेलह उन पुरा ऊमर ऊम्बत सौ उनसत्तर वर्ष इन आत; अदुर बाद्‍दा आव सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","याग लेमेक ऊंद सौ बयासी वर्ष इन आदुन, आग आऊन से ऊंद पार उन जनम आत. ");
INSERT INTO hoy_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","आव ईद अनकु आऊन हेसुर नूह ईटदुन, “यहोवा जो पृथ्‍वी इक श्राप कोटान, अदुर बारा दा ईव पार नाम क्‍याल्‍सा दा, अदिक आ कठिन मेहनत दा जो नाव माळतेव, नामी शांती कोट्‍टान.” ");
INSERT INTO hoy_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नूह उन जनम इन बाद्‍दा लेमेक अईद सौ पंच्‍यानव वर्ष जीत्‍ता ईत्‍तुन, आऊक मात्त पार पोरगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ई प्रकार देल लेमेक उन पुरा ऊमर येळ सौ सत्यातर वर्ष इन आत; अदुर बाद्‍दा आव सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","अदिक नूह अईद सौ वर्ष इन आदुन; अदिक नूह टु शेम, अदिक हाम, अदिक येपेत उन जनम आत. ");
INSERT INTO hoy_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","बाक याग मंळसा धरती मा हापाळ वाळुसली कुरतुर, अदिक आंदुर पोरगोळ पैदा आदुर, ");
INSERT INTO hoy_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","आग परमेश्वर उन पारगोळ मंळसा अन पोरगोळी नोळदुर, कि आंदुर सुंदर आर, अदिक यारी चाहासदुर आंदुर से मदा माळ कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","आग यहोवा अंदुन, “नान आत्मा मंळसागोळ सांगुळ हमेशा साटी लळाई माळतीदील, यतिकी मंळसा भी शरीर अच हुन; आंदुर ऊमर ऊंद सौ ईप्‍पत वर्ष इन ईत्‍तीत.” ");
INSERT INTO hoy_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","आ दिन दा पृथ्‍वी मा दानव ईरतोगोर; अदिक ईदुर बाद्‍दा याग परमेश्वर उन पार मंळसा अन पोरगोळ हात्‍ती होदुर आग आंदुर द्वारा जो पार पैदा आदुर आंदुर शूरवीर आगोर, यार्द किर्ती हाळाबाट्‍टुर से प्रचलित आद. ");
INSERT INTO hoy_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","यहोवा नोळदुन कि मंळसा अन बुराई पृथ्‍वी मा वाळुसीग्‍याद, अदिक आंदुर मन इन विचार दा जो येनारा पैदा आगतद अद हमेशा गलत अच आगतद. ");
INSERT INTO hoy_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","अदिक यहोवा पृथ्‍वी मा मंळसा अक माळदुर देल पछतासदुन, अदिक आव मन देल हापाळ दुखी आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","आग यहोवा अंदुन, “ना मंळसा अक यारी ना निर्माण माळदीन पृथ्‍वी इन म्‍याकुच टु मिटुस बुळाईन; येन मंळसा, येन जनावर, येन रांगसावाळा किळा, येन आकाश इन पक्षी, सप्‍पा अक नाश माळ बुळाईन, यतिकी ना आंदरी माळदुर से पछतासतीन.” ");
INSERT INTO hoy_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","लेकीन यहोवा अन्द अनुग्रह अन्द नजर नूह मा बन्सकु ईत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नूह इन वंशावली ईद हुन. नूह धर्मी मंळसा अदिक तान समय दा लॉकुर दा खरा ईरोन; अदिक नूह परमेश्वर उन अच सांगुळ नळुतेला ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नूह नोर मुर चिकोर ईरोर; शेम, हाम अदिक येपेत. ");
INSERT INTO hoy_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","आ समय पृथ्‍वी परमेश्वर उन नजर दा बीगळुसेगीत, अदिक हिंसा देल तुमकु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","अदिक परमेश्वर पृथ्‍वी मा जो नजर हाकदुन रा नोळदुन कि अद बिगळुसकु आद; यतिकी सप्‍पा प्राणीगोळ पृथ्‍वी मा तान तान चाल-चलन बिगळुस बुटीदव. ");
INSERT INTO hoy_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","आग परमेश्वर नूह से अंदुन, “सप्‍पा प्राणीगोळ्द अन्‍त माळोद सवाल नान मुंद होट बंदाद; यतिकी आंदुर कारण पृथ्‍वी उपद्रव देल तुम्‍मेग्‍याद, इदुरसाटी ना आंदरी पृथ्‍वी सांगुळ नष्‍ट माळ बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","इदुरसाटी नी गोपेर इन मार्र इन हुळ्ली इन ऊंद जहाज माळकोम, अदुर दा कमरागोळी माळेत, अदिक व्‍हार्या-बुळ्क अदुर मा राल हचेत. ");
INSERT INTO hoy_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ई ढंग देल नी अदरी माळेत: जहाज इन लंबाई मुर सौ कय, चौळाई पचास कय, अदिक ऊचाई तीस कय इन ईरूल. ");
INSERT INTO hoy_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","जहाज दा ऊंद खिळकी माळेत, अदिक अदुर ऊंद कय म्‍याकुच टु अदुर छत माळेत, अदिक जहाज इन ऊंद दी ऊंद दरवाजा ईटेत; अदिक जहाज दा पयला, दुसरा, तीसरा खण्‍ड माळेत. ");
INSERT INTO hoy_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","अदिक केळ, ना खुद पृथ्‍वी मा जल-प्रलय माळकु सप्‍पा प्राणीगोळ इक, यदुर दा जीवन प्राण आद, आकाश इन ल्‍यालमा टु नष्‍ट माळदुर मा आईन; अदिक सप्‍पा जो पृथ्‍वी मा आर सोतोदार. ");
INSERT INTO hoy_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","लेकीन ना नीन सांगुळ वादा माळतीन; इदुरसाटी तान पारगोळ, आर्त, अदिक तान सास्सा सांगुळ दा प्रवेश माळेत. ");
INSERT INTO hoy_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","अदिक सप्‍पा जित्ता प्राणी दा टु नी ऊंद ऊंद जाती इन येढ्‍ढ येढ्‍ढ, मतलब ऊंद नर अदिक मादा जहाज दा वोतकु, तान सांगुळ जीत्‍ता ईटेत. ");
INSERT INTO hoy_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","हर ऊंद जाती इन पक्षी, अदिक हर ऊंद जाती इन जनावर, अदिक हर ऊंद जाती इन जमीन मा रांगसावाळा, सप्‍पा दा टु येढ्‍ढ येढ्‍ढ नीन हात्‍ती बंदव, नी अवरी जीत्‍ता ईटेत. ");
INSERT INTO hoy_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","अदिक अलग अलग तिनोद सामान, अवरी नी हुळकु तान हात्‍ती जमा माळकु ईटेत; जो नीनी अदिक अऊर तिनोर साटी ईत्‍तीत.” ");
INSERT INTO hoy_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","परमेश्वर उन ई आग्‍या अन अनुसार नूह माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","आग यहोवा नूह से अंदुन, “नी तान पुरा घराना अन सांगुळ जहाज मा होटोग; यतिकी ना ई समय इन लॉकुर दा टु नीनी का तान नजर इन मुंद धर्मी नोळीन. ");
INSERT INTO hoy_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","सप्‍पा जाती इन शुद्ध जनावर दा टु रा नी येळ येळ जोळी मतलब नर अदिक मादा ताकोमेत; लेकीन जो जनावर शुद्‍ध हैलेच, अऊर दा टु येढ्‍ढ येढ्‍ढ ताकोमेत, मतलब नर अदिक मादा; ");
INSERT INTO hoy_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","अदिक आकाश इन पक्षी दा टु भी येळ येळ जोळी, मतलब नर अदिक मादा ताकोमेत, कि अऊर वंश उळकु पुरा पृथ्‍वी इन म्‍याकुच बन्सकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","यतिकी येळ दिन अदिक बितुसदुर मा ना पृथ्‍वी मा चालीस दिन अदिक चालीस ईळ्‍ल्‍क ताका नीर बरसुसतेला ईराईन; अदिक यास प्राणीगोळी ना माळीन आ सप्‍पा अक पृथ्‍वी मा टु नाश माळ बुळाईन,” ");
INSERT INTO hoy_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","यहोवा अन ई आग्‍या अन अनुसार नूह माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","नूह इन ऊमर आर सौ वर्ष इन ईरोद, याग जल-प्रलय पृथ्‍वी मा बत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नूह तान पारगोळ, हिंग्‍स, अदिक तान सास्सागोळ सांगुळ जल-प्रलय से ऊळोर साटी जहाज मा होदुर. ");
INSERT INTO hoy_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","शुद्ध अदिक अशुध्‍द, येढ्‍ढु प्रकार इन जनावर दा टु, पक्षीगोळ, ");
INSERT INTO hoy_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","अदिक जमीन मा रांगसावाळा कीळागोळ दा टु भी, येढ्‍ढ येढ्‍ढ, मतलब नर अदिक मादा, जहाज दा नूह इन हाती होदोव, याता प्रकार परमेश्वर नूह अक आग्‍या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","येळ दिन इन बाद्‍दा प्रलय इन नीर पृथ्‍वी मा बरली कुर्त. ");
INSERT INTO hoy_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","याग नूह अन ऊमर इन आर सौ वर्ष इन दुसरा तिंगुळ इन सतरावा दिन बत्‍त; अदा दिशी धोळ्‍द गहरा समुद्र अन सप्‍पा सोतागोळ वळ्‍द कुरतव अदिक आकाश इन झरोखागोळ खुलसेदव. ");
INSERT INTO hoy_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","अदिक माळ चालीस दिन अदिक चालीस ईळ्‍ल्‍क पृथ्‍वी मा आगतेला ईत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ठीक अदा दिशी नूह तान पार शेम, हाम, अदिक येपेत, अदिक तान हिंग्‍स, अदिक मुरू सास्सागोळ सांगुळ, ");
INSERT INTO hoy_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","अदिक आंदुर सांगुळ ऊंद ऊंद जाती इन सप्‍पा आळी दाकळव जनावर, अदिक घरेलु जनावर, अदिक ऊंद ऊंद जाती इन सप्‍पा पृथ्‍वी मा रांगसावाळा किळा, अदिक हर ऊंद जाती इन ऊळुसावाळा पक्षी, जहाज मा होदव. ");
INSERT INTO hoy_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","यास प्राणीगोळ दा जीवन इन प्राण ईरोद अऊर सप्‍पा जातीगोळ दा टु येढ्‍ढ येढ्‍ढ नूह उन हाती जहाज दा होदोव. ");
INSERT INTO hoy_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","अदिक जो होदोव, अव परमेश्वर उन आग्‍या अन अनुसार सप्‍पा जाती अन प्राणीगोळ दा टु नर अदिक मादा होदोव. आग यहोवा जहाज इन दरवाजा बंद माळ बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","पृथ्‍वी मा चालीस दिन ताका जल-प्रलय आगतेला ईत्‍त; अदिक हापाळ अच वाळुसतेला होत, यदुर देल जहाज म्‍याकुच येळली कुर्त; अदिक अद पृथ्‍वी मा टु म्‍याकुच येदोत. ");
INSERT INTO hoy_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","नीर वाळुस्‍त वाळुस्‍त पृथ्‍वी मा हापाळ अच वाळुसेत, अदिक जहाज नीर इन म्‍याकुच म्‍याकुच तैरूस्‍तेला ईत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","नीर पृथ्‍वी मा हापाळ अच वाळुसेत, ईल ताका कि पुरा धरती मा यास भी धोड्‍डेव धोड्‍डेव पहाळीगोळ ईरोव, सप्‍पा मुळकेदव. ");
INSERT INTO hoy_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","नीर पन्‍द्राह कय अदिक म्‍याकुच वाळुसेत, अदिक पहाळी भी मुळ्कदव. ");
INSERT INTO hoy_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","अदिक येन पक्षी, येन घरेलु जनावर, येन आळी दाकळव जनावर, अदिक पृथ्‍वी मा सप्‍पा नळावाळा प्राणी, अदिक यास किळा पृथ्‍वी दा हापाळ तुम्‍मेगीदव, अव सप्‍पा अदिक सप्‍पा मंळसा सोतोदुर. ");
INSERT INTO hoy_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","जो जो जागा मा ईरोर, अऊर दा टु यास मुंदुर्द मुग्गगोळ दा जीवन इन श्‍वास ईरोद, सप्‍पा सोतोदुर. ");
INSERT INTO hoy_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","अदिक येन मंळसा, येन जनावर, येन रांगसावाळा जन्तु, येन आकाश इन पक्षी, जो जो भूमी मा ईरव सप्‍पा पृथ्‍वी मा टु नाश माळदेव; सिर्फ नूह, अदिक यास आऊन सांगुळ जहाज दा ईरोर, आंदुर अच ऊळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","अदिक नीर पृथ्‍वी मा ऊंद सौ पचास दिन ताका थामस्‍कु ईत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","लेकीन परमेश्वर नूह अदिक यास आळी दाकळव जनावर अदिक घरेलु जनावर आऊन सांगुळ जहाज दा ईरव, आ सप्‍पा अन्द सुधी ताकोंडुन: अदिक परमेश्वर पृथ्‍वी मा हवा नळ्‍सदुन, अदिक नीर कम आगतेला बत्‍त; ");
INSERT INTO hoy_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","अदिक गहरा समुद्र अन सोतागोळ अदिक आकाश इन झरोखागोळ बंद आगेदव; अदिक अदुर देल जो माळ आगतोगोद अद भी रूकसेत; ");
INSERT INTO hoy_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","अदिक ऊंद सौ पचास दिन इन बाद्‍दा नीर पृथ्‍वी मा टु लगातार कम आगतेला ईत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","सातवा तिंगुळ इन सतरावा दिन इक, जहाज अरारत हेसुर इन पहाळी मा टिकसेत. ");
INSERT INTO hoy_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","अदिक नीर हतवा तिंगुळ ताका कम आगतेला होत, अदिक हतवा तिंगुळ इन पयला दिशी इक पहाळीगोळ्‍द चोटीगोळ कांळ्सदव. ");
INSERT INTO hoy_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","बाक हींग आत कि चालीस दिन इन बाद्‍दा नूह तान माळ्‍द जहाज इन खिळकी तेरूकु, ");
INSERT INTO hoy_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ऊंद काग्ग उक ऊळुस बुट्‍टुन: यागास ताका नीर पृथ्‍वी मा टु वंळ्‍गीदिल, आगासताका ताका काग्ग ईत्‍त आत्‍त वयाळतेला ईत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","बाक आव तान हाती टु ऊंद कबूतर इक भी ऊळुस बुट्‍टुन कि नोळुल कि नीर पृथ्‍वी मा टु कम आत कि ईला. ");
INSERT INTO hoy_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","आ कबूतर इक तान काल टेक्‍सली येनु आधार सिकीदील, रा अद आऊन हाती जहाज मा वापस बत्त: यतिकी पुरा पृथ्‍वी इन म्‍याकुच नीर अच नीर तुमकु ईरोद. आग आव कय वाळुसकु अदरी तान हात्‍ती जहाज दा ताकोम कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","बाक अदिक येळ दिन थाम्सदुर बाद्दा, आव अदा कबूतर इक जहाज दा टु मात ऊळुस बुट्‍टुन; ");
INSERT INTO hoy_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","अदिक कबूतर द्‍यावगा अन वती आऊन हात्‍ती होट बत्‍त, रा येन नोळदुन कि अदुर चाचु दा जैतून इन ऊंद व्‍हाशोद याल्‍ला आद; ईदुर देल नूह जान्‍स कोंडुन कि नीर पृथ्‍वी मा टु कम आगेग्‍याद. ");
INSERT INTO hoy_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","बाक येळ दिन अदिक थाम्‍सकु अदा कबूतर उक ऊळुस बुट्‍टुन; अद बाक आऊन हात्‍ती यागलु वापस बंदिदील. ");
INSERT INTO hoy_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नूह उन उमर इन आर सौ ऊंद वर्ष इन पयला तिंगुळ पयला दिन नीर पृथ्‍वी मा टु वंळगेत. आग नूह जहाज इन छत खोल्‍सकु येन नोळदुन कि धरती वंळगेग्‍याद. ");
INSERT INTO hoy_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","अदिक दुसरा तिंगुळ इन सत्ताईसवा दिशी पृथ्‍वी पुरा रीति देल वंळगेत. ");
INSERT INTO hoy_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","आग परमेश्वर नूह से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“नी तान पारगोळ, हिंग्‍स, सास्सागोळ सांगुळ जहाज दा टु होट्‍टबुळ. ");
INSERT INTO hoy_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","येन पक्षी, येन जनावर, येन सप्‍पा प्रकार इनव रांगसावाळा किळा जो पृथ्‍वी मा रांगस्ताव यास शरीरधारी जीव जन्‍तु नीन सांगुळ आव, आ सप्‍पा अक तान सांगुळ तेगु कोम कि पृथ्‍वी मा अऊर देल हापाळ चिकोर आगुल; अदिक अव फलसुल फुलुसुल, अदिक पृथ्‍वी मा फैलुसेगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","आग नूह, अदिक आऊनोर चिकोर अदिक हिंग्‍स, अदिक सास्सागोळ व्‍हार्या बंदुर: ");
INSERT INTO hoy_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","अदिक सप्‍पा जनावर, रांगसावाळा किळा, अदिक पक्षी, अदिक यास भी जीव जन्‍तु पृथ्‍वी मा नळुताव वयाळताव, सप्‍पा जाती जाती माळकु जहाज दा टु व्‍हार्या होट्‍टव. ");
INSERT INTO hoy_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","आग नूह यहोवा अन साटी ऊंद वेदी माळदुन; अदिक सप्‍पा शुद्ध जनावर अदिक सप्‍पा शुद्‍ध पक्षीगोळ दा टु येनारा येनारा हुडुकु वेदी मा होमबली येर्सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ईदुर मा यहोवा सुखदायक वास ताकोमकु सोचदुन, मंळसा अन कारण ना बाक यागलु धरती इक श्राप कोळतीदील, अगर मंळसा अन मन दा स्याणपणी टु येनारा पैदा आगतद अद बुरा अच आगतद; तरी भी ह्‍यांग ना सप्‍पा जीवगोळी ईग कोंदीन, हांग अवरी बाक यागलु कोनतीदिल. ");
INSERT INTO hoy_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ईग टु यागासताका पृथ्‍वी बन्सकु ईत्‍तीत, आगासताका बोऊसोद अदिक कडोद समय, ठंडी अदिक बिसुल, धूपकाल अदिक शीतकाल, ईळ्‍ल्‍क अदिक हागुल, हमेशा आगतेला ईत्‍ताव. ");
INSERT INTO hoy_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","बाक परमेश्वर नूह अदिक आऊन चिकोरगोळी आशीष कोट्‍टुन अदिक आव अंदुन, “तान जिन्‍दगी माळी अदिक वाळुसी, अदिक पृथ्‍वी दा तुम्‍मेगी. ");
INSERT INTO hoy_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","नीम्‍द अंज्‍क पृथ्‍वी इन सप्‍पा जनावर, अदिक सप्‍पा आकाश इन पक्षीगोळ, अदिक जमीन ईनव सप्‍पा रांगसावाळा कीळागोळ, अदिक समुद्र दाकळव सप्‍पा मेनगोळ मा बन्सकु ईत्तीत: ईव सप्‍पा नीम वश दा माळकु आगताव. ");
INSERT INTO hoy_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","सप्‍पा रांगसावाळा किळा नीम्‍द आहार आदीत; ह्‍यांग नीमी हिवरा हिवरा श्याणेव मार्र कोटीदीन, हांग अच ईग सप्‍पा येनारा कोळतीन. ");
INSERT INTO hoy_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","लेकीन मास इक जीव इन सांगुळ मतलब रक्‍ता अन सांगुळ नीव तिनबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","अदिक सही दा अच ना नीम्‍द रक्‍ता मतलब जीव इन बदला ताकोमाईन: सप्‍पा जनावरगोळ अदिक मंळसागोळ, येढ्‍ढु मुंदुर से अदरी ताकोमाईन; मंळसा अन जीव इन बदला ना ऊंद ऊंद वार्ट बंधु से ताकोमाईन. ");
INSERT INTO hoy_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","जो यावारा मंळसा अन रक्‍ता वाहुस्‍यान आऊन रक्‍ता मंळसा से अच वाहुसकु आदीत, यतिकी परमेश्वर मंळसा अक तान अच स्‍वरूप इन अनुसार माळ्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","अदिक नीव जींदगी माळी, अदिक वाळुसी, अदिक पृथ्‍वी मा हापाळ सा चिकोर पैदा माळकु अदुर्दा तुम्‍मेगी. ");
INSERT INTO hoy_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","बाक परमेश्वर नूह अदिक आऊन चिकोरगोळ से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“केळी, ना नीम सांगुळ अदिक नीम बाद्‍दा जो नीम्‍द वंश ईत्‍तीत, आंदुर सांगुळ भी वादा माळतीन; ");
INSERT INTO hoy_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","अदिक जीत्‍ता प्राणीगोळ सांगुळ भी जो नीम सांगुळ आव, येन पक्षी येन मान्‍यागोळोव जनावर येन पृथ्‍वी माकळव सप्‍पा आळी दाकळव जनावर, पृथ्‍वी नव यास जीव जन्‍तु जहाज दा टु होटाव. ");
INSERT INTO hoy_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","अदिक ना नीम सांगुळ तान ईद वादा कटतीन कि सप्‍पा प्राणी मात जल-प्रलय सेल नाश आगतीदील: अदिक पृथ्‍वी इन नाश आगोर साटी मात जल-प्रलय आगतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","बाक परमेश्वर अंदुन, “जो वादा ना नीम सांगुळ, अदिक यास जीत्‍ता प्राणी नीम सांगुळ आव आ सप्‍पा अन सांगुळ भी युग-युग इन पीढ़ीगोळ साटी कटतीन, अदुर्द ईद चिन्ह आद : ");
INSERT INTO hoy_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ना बादल दा तान धनुष ईटीन, अद नान अदिक पृथ्‍वी इन बीच दा वादा अन चिन्ह आदीत. ");
INSERT INTO hoy_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","अदिक याग ना पृथ्‍वी मा बादल फैलुसाईन आग बादल दा धनुष कांळ्सीत. ");
INSERT INTO hoy_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","आग नान वादा जो नीम अदिक सप्‍पा जीत्‍ता शरीरधारी प्राणीगोळ सांगुळ कटकु आद; अदरी ना याद माळाईन, आग ईत्‍ता जल-प्रलय बाक आगतीदील यदुर देल सप्‍पा प्राणीगोळ्द विनाश आगुल. ");
INSERT INTO hoy_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","बादल दा जो धनुष ईत्‍तीत ना अदरी नोळकु ई सदा अन वादा अक याद माळाईन, जो परमेश्वर उन अदिक पृथ्‍वी माकळव सप्‍पा जीत्‍ता शरीरधारी प्राणीगोळ बीच दा कटकु आद.” ");
INSERT INTO hoy_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","बाक परमेश्वर नूह से अंदुन, “जो वादा ना पृथ्‍वी दाकळव सप्‍पा प्राणीगोळ सांगुळ कटीन, अदुर्द चिन्ह ईदा हुन.” ");
INSERT INTO hoy_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नूह उन चिकोर जो जहाज दा टु होट्‍टुर, आंदुर शेम, हाम अदिक येपेत ईरोर; अदिक हाम कनान उन आप्‍प आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","नूह उन मुर चिकोर ईंदुरा उर, अदिक ईंदुर्द वंश पुरा पृथ्‍वी मा फैलुसेत. ");
INSERT INTO hoy_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नूह खेती किसानी माळली कुरतुन. अदिक आव अंगुर इन बेली हचदुन; ");
INSERT INTO hoy_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","अदिक आव अंगुर इन रास्‍सा कुडुकु मतवाला आदुन; अदिक तान ड्‍यारा अन्द बुळ्‍क ऊगळा आगेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","आग कनान उन आप्‍प हाम तान आप्‍प उक ऊगळा नोळदुन, अदिक व्‍हार्या बंदकु तान वार्टुरी हेळ बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","आग शेम अदिक येपेत येढ्‍ढु मुंदुर कपळा हुडुकु तान खांदा मा ईटदुर, अदिक हिंद इन दी उलटा नळुकु तान आप्‍प उन ऊगळा मय इक होचदुर, अदिक आंदुर तान बाय हिंद माळकु ईरोर इदुरसाटी आंदुर तान आप्‍प उक ऊगळा नोळीदील. ");
INSERT INTO hoy_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","याग नूह उन नशा ईळदोत, आग आव जान्‍स कोंडुन कि आऊन श्‍याण पार आऊन सांगुळ येन माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","इदुरसाटी आव अंदुन, “कनान श्रापित आगुल: अद तान वार्ट बंधु उन दासगोळ्द दास आगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","बाक आव अंदुन, “शेम उन परमेश्वर यहोवा धन्‍य आन, अदिक कनान शेम उन दास आगुल. ");
INSERT INTO hoy_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्वर येपेत उन वंश उक फैलुसुल; अदिक आव शेम उन ड्‍यारागोळ दा बसुसुल, अदिक कनान आऊन दास आगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","जल-प्रलय इन बाद्‍दा नूह मुर सौ पचास वर्ष जीत्‍ता ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ई प्रकार देल नूह उन पुरा ऊमर उम्बत सौ पचास वर्ष इन आत; अदुर बाद्‍दा आव सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नूह उन पार शेम, हाम, अदिक येपेत ईरोर; आंदुरोर चिकोर जल-प्रलय इन बाद्‍दा पैदा आदुर: आंदुर्द वंशावली ईद हुन. ");
INSERT INTO hoy_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेत उन पारगोळ: गोमेर, मागोग, मादै, यावान, तूबल, मेशेक, अदिक तीरास आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेर उन पारगोळ: अशकनज, रीपत, अदिक तोगर्मा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","अदिक यावान उन वंश दा एलीशा, अदिक तर्शीश, अदिक कित्ति, अदिक दोदानी लॉकुर आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","इंदुर द्वारा जाती जाती नोर तटवर्तीय प्रदेश तान तान भाषा, कुल अदिक जाती इन अनुसार तान तान द्‍याश दा अलग आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हाम उन पारगोळ: कूश, मिस्त्र, पूत अदिक कनान आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","अदिक कूश उन पारगोळ सबा, हवीला, सबता, रामा, अदिक सबूतका आदुर. अदिक रामा अन चिकोर शबा, अदिक ददान आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूश उन वंश दा निम्रोद भी आदुन; पृथ्‍वी मा पयला वीर आवा आग्‍यान. ");
INSERT INTO hoy_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","आव यहोवा अन नजर दा पराक्रमी शिकार आळावाळा ठहरूसदुन, ईदुर देल अद कहावत नळुत; “निम्रोद उन घाई यहोवा अन नजर दा पराक्रमी शिकार आळावाळा.” ");
INSERT INTO hoy_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","आऊन राज्‍य अन सुरूवात शिनार द्‍याश दा बेबीलोन, एरेख, अक्‍कद अदिक कलने देल आत. ");
INSERT INTO hoy_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","आ द्‍याश टु आव होटकु अश्शूर उक होदुन, अदिक नीनवे, रहोबोतीर अदिक कालह उक, ");
INSERT INTO hoy_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","अदिक नीनवे अदिक कालह इन न्‍याड्या जो रेसेन आद, अदरी भी बसुसदुन; धोळ्‍द नगर ईदा हुन. ");
INSERT INTO hoy_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिस्त्र अन वंश दा लूदी, अनामी, लहाबी, नप्‍तूही, ");
INSERT INTO hoy_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","अदिक पत्रूसी, कसलूही अदिक कप्‍तोरी लॉकुर आदुर, कसलूहियों दा टु रा पलिश्ती लॉकुर होट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान उन वंश दा आऊन धोळ पार सीदोन, तब हित्‍ती, ");
INSERT INTO hoy_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, एमोरी, गिर्गाशी, ");
INSERT INTO hoy_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिब्बी, अर्की, सीनी, ");
INSERT INTO hoy_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वदी, समारी, अदिक हमाती जाती इन लॉकुर भी आदुर; बाक कनानीगोळ्द कुल भी फैलुसेत; ");
INSERT INTO hoy_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","अदिक कनानीगोळ्द सीमा सीदोन टु हुडुकु गरार इन हादी टु आगकु गाजा ताका अदिक बाक सदोम अदिक गमोरा अदिक अदमा अदिक सबोयीम इन हादी टु आगकु लाशा ताका आत. ");
INSERT INTO hoy_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","हाम उन वंश दा ईंदुरा पैदा आदुर, अदिक ईंदुर अलग अलग कुलगोळ, भाषागोळ, द्‍याशगोळ अदिक जातीगोळ अनुसार अलग अलग आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","शेम, जो सप्‍पा एबेर वंशिगोळोव मूल गंळ्स आदुन, अदिक जो येपेत उन धोळ वार्ट ईरोन, आऊनोर भी चिकोर पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेम उन चिकोर : एलाम, अश्‍शूर, अर्पक्षद, लूद अदिक अराम आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अराम उन चिकोर : ऊस, हूल, गेतेर अदिक मश आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अदिक अर्पक्षद शेलह अक, अदिक शेलह एबेर उक पैदा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","अदिक एबेर उक येढ्ढ चिकोर आदुर, ऊंद पार उन हेसुर पेलेग ईद कारण देल ईटकु आत कि आऊन दिनगोळ दा पृथ्वी अन्द येढ्ढ भाग आदव, अदिक आऊन वार्ट उन हेसुर योक्तान ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","अदिक योक्तान उक अल्मोदाद, शेलेप, हसर्मावेत, येरह, ");
INSERT INTO hoy_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","यदोरवाम, ऊजाल, दिक्ला, ");
INSERT INTO hoy_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शबा, ");
INSERT INTO hoy_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला अदिक योबाब पैदा आदुर: ईंदुर अच सप्पा योक्तान उन चिकोर पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ईंदुर्द ईरोद ऊंद जागा मेशा टु हुळकु सपारा, जो पूर्व दा ऊंद पहाळी आद, अदुर हादी ताका आत. ");
INSERT INTO hoy_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","शेम उन चिकोर ईंदुरा आदुर; अदिक ईंदुर अलग-अलग कुलगोळ, भाषागोळ, द्याशगोळ अदिक जातीगोळ अनुसार अलग-अलग आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","नूह अन्द पारगोळ्द घराना ईदा हुन: अदिक आंदुर्द जातीगोळ्द हिसाब देल आंदुर वंशावली ईवा हु; अदिक जल-प्रलय इन बाद्दा पृथ्वी माकळव जातीगोळ इंदुर दा टु अच आगकु अलग आगेदव. ");
INSERT INTO hoy_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","पुरा पृथ्‍वी मा ऊंद अच भाषा अदिक ऊंद अच बोली ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","आ समय इन लॉकुर पूर्व इन दी नळुत नळुत शिनार द्‍याश दा ऊंद मैदान सिक्त अदुर्दा बसुसेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","आग आंदुर आपस दा अनली कुरतुर, “बरी, नाव ईटा माळ माळकु अवरी वळ्‍लीसा बेक्‍की दा बेईसाता.” अदिक आंदुर कल्‍ल इन जागा दा ईटा देल, अदिक चुना अन जागा मा मुण्‍ण इन गारा देल क्‍याल्‍सा तांकोडुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","बाक आंदुर अंदुर, “बरी, नाव तान साटी ऊंद नगर अदिक ऊंद गुम्मट माळ कोमाता, यदुर्द चोटी आकाश उन सांगुळ मात माळुल, ई प्रकार देल नाव तान हेसुर माळाता, हिंग आगबाळुल कि नामी सप्‍पा पृथ्‍वी मा फैलुसोद बिळुल.” ");
INSERT INTO hoy_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","याग लॉकुर नगर अदिक गुम्मट इक माळली कुरतुर, आग आंदरी नोळोर साटी यहोवा ईळुकु बंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","अदिक यहोवा अंदुन, “नोळी, ना येन नोळेतीन कि आंदुर ऊंद अच जाती नोर उर अदिक आंदुर सप्‍पा मुंदुर्द ऊंद अच भाषा हुन. अगर आंदुर ईग ईद अनली कुरतार रा आंदुर जो येनारा भी माळोद ठांस कोंडार, आंदुर साटी येनारा भी माळोद असम्भव आगतीदील. ");
INSERT INTO hoy_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","बरी, नाव ईळुकु आंदुर भाषा दा गळबळी हाकाता, कि आंदुर आबुर दाबुर बोली इक सम्‍सबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ई प्रकार यहोवा आंदरी अल टु पुरा पृथ्‍वी मा फैलुस बुट्‍टुन; अदिक आंदुर आ नगर इक माळोद बंद माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ईद कारण आ नगर इन हेसुर बेबीलोन बीत्‍त; यतिकी पुरा पृथ्‍वी इन भाषा दा जो गळबळी आद, अद यहोवा अल्‍या हाकदुन, अदिक अल टु उच यहोवा मंळसागोळी पुरा पृथ्‍वी इन म्‍याकुच फैलुस बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेम उन वंशावली ई प्रकार देल आद. जल-प्रलय इन येढ्‍ढ वर्ष इन बाद्‍दा याग शेम ऊंद सौ वर्ष इनव आदुन, आग आऊन से अर्पक्षद उन जनम आत; ");
INSERT INTO hoy_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अदिक अर्पक्षद उन जनम इन बाद्‍दा शेम अईद सौ वर्ष जीत्‍ता ईत्‍तुन; अदिक आऊनोर अदिक भी पोर पारगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","याग अर्पक्षद पैतीस वर्ष इनव आदुन, आग आऊन से शेलह उन जनम आत; ");
INSERT INTO hoy_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","अदिक शेलह उन जनम इन बाद्‍दा अर्पक्षद नाक सौ मुर वर्ष अदिक जीत्‍ता ईत्‍तुन, अदिक आऊनोर अदिक भी पोर पारगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","याग शेलह तीस वर्ष इनव आदुन, आग आऊन से एबेर पैदा आदुन; ");
INSERT INTO hoy_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","एबेर उन जनम इन बाद्‍दा शेलह नाक सौ मुर वर्ष ताका जीत्‍ता ईत्‍तुन अदिक आऊनोर अदिक भी पोर पारगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","एबेर याग चौतीस वर्ष इनव आदुन आग आऊन से पेलेग पैदा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","अदिक पेलेग उन जनम इन बाद्‍दा एबेर नाक सौ तीस वर्ष ताका जीत्‍ता ईत्‍तुन, अदिक आऊनोर अदिक भी पोर पारगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","याग पेलेग तीस वर्ष इनव आदुन आग आऊन से रू पैदा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","अदिक रू उन जनम इन बाद्‍दा पेलेग येढ्‍ढ सौ ऊम्बत वर्ष ताका जीत्‍ता ईत्‍तुन, अदिक आऊनोर अदिक भी पोर पारगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","रू याग बत्‍तीस वर्ष इनव आदुन आग आऊन से सरूग पैदा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","सरूग उन जनम इन बाद्‍दा रू येढ्‍ढ सौ येळ वर्ष ताका जीत्‍ता ईत्‍तुन, अदिक आऊक भी पोर पारगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","याग सरूग तीस वर्ष ईनव आदुन रा आऊन से नाहोर पैदा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","नाहोर उन जनम इन बाद्दा सरूग येढ्‍ढ सौ वर्ष जीत्‍ता ईत्‍तुन, अदिक आऊक भी पोर पारगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","याग नाहोर उनतीस वर्ष इनव आदुन रा आऊन से तेरह पैदा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","तेरह उन जनम इन बाद्‍दा नाहोर ऊंद सौ उन्‍नीस वर्ष ताका जीत्‍ता ईत्‍तुन, अदिक आऊक भी पोर पारगोळ पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तेरह याग सत्‍तर वर्ष इनव आदुन आग आऊन से अब्राहम, नाहोर अदिक हारान पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरह उन वंशावली ईद हुन. तेरह देल अब्राहम, नाहोर अदिक हारान पैदा आदुर; अदिक हारान से लूत पैदा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान उन मृत्यु आऊन आप्प तेरह अन जीवन काल दा का कसदी अन ऊर हेसुर इन नगर दा आत्त, जो आऊन जन्म भूमी ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राहम अदिक नाहोर येढ्‍ढु मुंदुर मदा माळदुर. अब्राहम उन हिंग्‍स उन हेसुर सारै अदिक नाहोर उन हिंग्‍स उन हेसुर मिल्‍का ईरोद. ईक आ हारान उन पोर ईरोर, जो मिल्‍का अदिक यिस्‍का येढ्‍ढु मुंदुरव आप्‍प ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारै रा बाँझ ईरोर; आकी चिकोर आगीदील. ");
INSERT INTO hoy_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेरह तान पार अब्राहम, अदिक तान नाती लूत, जो हारान उन पार ईरोन, अदिक तान सास्सा सारै, जो आऊन पार अब्राहम उन हिंग्‍स ईरोर, आ सप्‍पा मुंदुरी हुडुकु कसदी अन ऊर नगर टु होटकु कनान द्‍याश होगली इक होट्टुर; लेकीन हारान हेसुर इन द्‍याश दा पोहचुस्कु अल्‍या ईरली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","याग तेरह येढ्‍ढ सौ अईद वर्ष इनव आदुन; आग हारान द्‍याश दा सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","यहोवा अब्राहम से अंदुन, “तान द्‍याश, अदिक तान घरानागोळी, अदिक तान आप्‍प उन मान्‍ना अक बिटकु आ द्‍याश दा होटोग जो ना नीनी तोरसाईन. ");
INSERT INTO hoy_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","अदिक ना नीन से ऊंद धोळ्‍द जाती माळाईन, अदिक नीनी आशीष कोळाईन, अदिक नीन हेसुर महान माळाईन, अदिक नी आशीष इन मूल आद्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","जो आशीर्वाद कोळुल, आंदरी ना आशीष कोळाईन; अदिक जो नीनी कोसुस्‍यार, आऊक ना श्राप कोळाईन; अदिक भूमी माकळोर सप्‍पा कुल नीन द्वारा आशीष ताकोंडार. ");
INSERT INTO hoy_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","यहोवा अन ई वचन इन अनुसार अब्राहम नळदुन, अदिक लूत भी आऊन सांगुळ नळदुन; अदिक अब्राहम याग हारान द्‍याश टु होट्‍टुन आ समय आव पचहत्तर वर्ष इनव ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ई प्रकार देल अब्राहम तान हिंग्‍स सारै, अदिक तान पुतणा लूत उक, अदिक जो धन आंदुर जमा माळीदुर, अदिक जो प्राणी आंदुर हारान दा हासील माळीदुर, सप्‍पा अक हुडुकु कनान द्‍याश दा होगली होट्‍टुर; अदिक आंदुर कनान द्‍याश दा होट्‍ट बंदुर. ");
INSERT INTO hoy_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","आ द्‍याश इन बीच टु होगतेला अब्राहम शकेम दा, येल मोरे अन बांज इन मार्र आद, पोहचुसदुन. आ समय आ द्‍याश दा कनानी लॉकुर ईरतोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","आग यहोवा अब्राहम उक दर्शन कोटकु अंदुन, “ईद द्‍याश ना नीन वंश इक कोळाईन.” अदिक आव यहोवा अन साटी अल ऊंद वेदी माळदुन, याव आऊक दर्शन कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","बाक अल टु मुंद वाळुसकु आव आ पहाळी मा बंदुन, जो बेतेल इन पूर्व इन दी आद, अदिक तान ड्‍यारा आ जागा मा नीदरूसदुन यदुर पश्‍चिम इन दी बेतेल अदिक पूर्व दी ऐ आद. अल भी आव यहोवा अन साटी ऊंद वेदी माळदुन अदिक यहोवा अन्द साटी प्रार्थना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","अदिक अब्राहम मुंद वाळुसकु दक्षिण द्‍याश इन दी वोळेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","आ द्‍याश दा अकाल बीत्‍त : इदुरसाटी अब्राहम मिस्त्र द्‍याश इक होटोदुन कि अल परदेशी आगकु ईरूल यतिकी द्‍याश दा भयंकर अकाल बिदकु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","बाक हिंग आत कि मिस्त्र इन हात्‍ती पोहचुस्कु, आव तान हिंग्‍स सारै से अंदुन, “केळ, नानी मालुम आद कि नी ऊंद सुंदर आर्त आय; ");
INSERT INTO hoy_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","अदिक मिस्त्र लॉकुर नीनी नोळ्‍यार रा अंदार, ‘इक आऊन हिंग्‍स उर,’ इदुरसाटी आंदुर रा नीनी कोंद बुट्‍टार, लेकीन नीनी जीत्ता ईट बुट्‍टार. ");
INSERT INTO hoy_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","अत: ईद अनेत, ना आऊन आकतींग हुईन, यदुर देल नीन कारण नान कल्‍याण आगुल, अदिक नान प्राण नीन कारण ऊळदोगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","बाक हिंग आत कि याग अब्राहम मिस्‍त्र दा बंदुन, आग मिस्त्र लॉकुर आऊन हिंग्‍स उक नोळदुर कि आक हापाळ सुंदर आर. ");
INSERT INTO hoy_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","अदिक फिरौन इन हाकिमगोळ आकी नोळकु फिरौन उन मुंद आकिन प्रशंसा माळदुर; इदुरसाटी आक आर्त फिरौन उन मान्‍या पोहचुस्कु आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","अदिक फिरौन आकिन कारण अब्राहम उन भलाई माळदुन; अदिक आऊक मर्र-माट्‍ट, वस्‍ता-गोसी, दास-दासीगोळ, गधा-गदहीगोळ, अदिक ऊँट सिकदव. ");
INSERT INTO hoy_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","लेकीन यहोवा फिरौन अदिक आऊन घराना मा, अब्राहम उन हिंग्‍स सारै अन कारण धोळ धोळ परेशानीगोळ हाकदुन. ");
INSERT INTO hoy_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","आग फिरौन अब्राहम उक कारसुसकु आऊन से अंदुन, “नी नान सांगुळ ईद येन माळ्‍द? नी नानी येती हेळीदिल कि आक नीन हिंग्‍स उर? ");
INSERT INTO hoy_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","नी येती अंद कि आक नीन आकतींग उर? ना आकी तान हिंग्‍स माळोर साटी कोंडीन; लेकीन ईग तान हिंग्‍स उक हुडुकु ईल टु होटोग.” ");
INSERT INTO hoy_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","अदिक फिरौन तान मंळसागोळी आऊन बारा दा आग्‍या कोट्‍टुन अदिक आंदुर आऊक अदिक आऊन हिंग्‍स उक, सप्‍पा संपत्‍ती सांगुळ जो आऊन ईरोद, विदा माळ कोंडुर ");
INSERT INTO hoy_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","आग अब्राहम तान हिंग्‍स अदिक तान सप्‍पा संपत्ती हुडुकु, लूत उक भी सांगुळ हुडुकु, मिस्त्र अक बिटकु कनान इन दक्षिण द्‍याश दा बंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राहम मर्र-म्यांडागोळ, वस्‍ता-गोसी, अदिक व्‍हान्‍ना बेळ्ली इन हापाळ धनी ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","बाक आव दक्षिण द्‍याश टु नळुकु बेतेल इन हात्‍ती अदा जागा मा पोहचुसदुन, येल आव पयले तान ड्‍यारा नीदरूसीदुन, जो बेतेल अदिक ऐ इन बीच दा आद. ");
INSERT INTO hoy_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ईद जागा आ वेदी इन हुन, यदरी आव पयले माळीदुन; अदिक अल अब्राहम मात यहोवा से प्रार्थना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","लूत उन हात्‍ती भी, जो अब्राहम उन सांगुळ नळोन, मर्र-म्यांडागोळ, वस्‍ता-गोसीगोळ, अदिक ड्‍यारा ईरव. ");
INSERT INTO hoy_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","इदुरसाटी आ द्‍याश दा आ दिनगोळ साटी येक्‍कुल जागा ईला ईरोद कि आंदुर सांगुळल्‍या ईरूल: यतिकी आंदुर हात्‍ती हापाळ धन ईरोद इदुरसाटी आंदुर सांगुळल्‍या ईर सकीदील. ");
INSERT INTO hoy_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","अब्राहम अदिक लूत उन मर्र-माट्‍ट, अदिक वस्‍ता-गोसी नोर चरवाहागोळ दा झगळा आत. आ समय दा कनानी अदिक परिज्जी लॉकुर आ द्‍याश दा ईरतोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","आग अब्राहम लूत से अनली कुरतुन, “नान अदिक नीन बीच, अदिक नान अदिक नीन चरवाहागोळ बीच दा झगळा आग बाळुल; यतिकी नाव लॉकुर वार्ट-बंधु आयेव. ");
INSERT INTO hoy_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","इदुरसाटी नी नान से अलग आगेग, येन नीन मुंद पुरा द्‍याश हैलेच? अगर नी ऊजवा कय दी होद्‍या, रा ना डाक्‍या कय दी होगाईन; अगर नी डाक्‍या कय दी होद्‍या, रा ना ऊजवा कय दी होगाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","आग लूत कण्‍ण नेगुकु, यरदन गांगा अन हात्‍ती गोळोद सप्‍पा तराई नोळदुन कि अद सप्‍पा सिंचकु आद. यागासताका यहोवा सदोम अदिक गमोरा अक नाश ईला माळीदुन, आगासताका सोअर इन हादी ताका अद तराई यहोवा अन बगीचा, अदिक मिस्त्र द्‍याश इन घाई ऊपजाऊ ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","इदुरसाटी लूत तान साटी यरदन इन सप्‍पा तराई नीवळुस्‍कु पूर्व दी होटोदुन, अदिक आंदुर आबुर-दाबुर से अलग आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राहम कनान द्‍याश दा ईत्‍तुन, लेकीन लूत आ तराई इन नगरगोळ दा ईरली कुरतुन; अदिक तान ड्‍यारा सदोम इन हात्‍ती नीदरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोम इन लॉकुर यहोवा अन लेखा दा हापाळ बुरा अदिक पापी ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","याग लूत अब्राहम से अलग आगेदुन आग अदुर बाद्‍दा यहोवा अब्राहम से अंदुन, “कण्‍ण नेगुकु या जागा मा नी आय अल टु उत्‍तर-दक्षिण, पूर्व-पश्‍चिम, नाकु दी नोळ. ");
INSERT INTO hoy_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","यतिकी याट जमीन नीनी कांळ्सतद, आ सप्‍पा जागा ना नीनी अदिक नीन वंश इक युग युग इन साटी कोळाईन. ");
INSERT INTO hoy_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","अदिक ना नीन वंश इक पृथ्‍वी इन धुळा अन किनकागोळ घाई माळाईन, ईल ताका कि जो यावारा पृथ्‍वी इन धुळा अन किनकागोळी आळु सक्‍यान आवा नीन वंश भी आळु सक्‍यान. ");
INSERT INTO hoy_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","येळ, ई द्‍याश इन लंबाई अदिक चौळाई दा नळु वयाळ, यतिकी ना अदरी नीनी का कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ईदुर बाद्‍दा अब्राहम तान ड्‍यारा बिचकु, मम्रे अन बांज मार्रगोळ बीच जो हेब्रोन दा ईरव, होगकु ईरली कुरतुन; अदिक अल भी आव यहोवा अन्द ऊंद वेदी माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","शिनार उन राजा अम्रापेल, अदिक एल्लासार उन राजा अर्योक, अदिक एलाम उन राजा कदोर्लाओमेर, अदिक गोयीस उन राजा तिदाल उन दिनगोळ दा हिंग आत, ");
INSERT INTO hoy_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","कि आंदुर सदोम उन राजा बेरा, अदिक गमोरा अन राजा बिर्शा, अदिक अदमा अन राजा शिनाब, अदिक सबोयीम उन राजा शमेबेर, अदिक बेला जो सोअर भी कहलुसतान, ई राजागोळ्द विरूद्ध युद्ध माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","इंदुर अईदु मुंदुर सिद्दीम हेसुर इन तराई दा, जो खारा समुद्र अन हात्‍ती आद, एकता माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","हन्‍नेळ वर्ष ताका रा इंदुर कदोर्लाओमेर उन हात्‍ती ईतकु स्यावा माळदुर; लेकीन तेरहवा वर्ष दा आऊन खिलाप विद्रोह माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","चौहदावा वर्ष दा कदोर्लाओमेर अदिक आऊन संगी राजा बंदुर, अदिक अशतरोत्‍कनम दा रपाईयो अक, अदिक हाम दा जूजियोगोळ इक, अदिक शाबेकिर्यातैम दा एमियोगोळ इक, ");
INSERT INTO hoy_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","अदिक सेईर हेसुर इन पहाळी मा होरी अक बडुत बडुत आ एल्‍पारान ताका जो आळी इन हात्‍ती आद, पोहचुसेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","अल आंदुर वापस आगकु एन्‍मिशपात इक बंदुर, जो कादेश भी कहलुसतद, अदिक अमालेकियों अन पुरा द्‍याश इक अदिक आ एमोरीगोळी भी जीक्स कोंडुर, जो हससोन्‍तामार दा ईरतोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","आग सदोम, गमोरा, अदमा, सबोयीम, अदिक बेला, जो सोअर भी कहलुसतान; इंदुरव राजा होट्‍टुर अदिक सिद्दीम हेसुर इन तराई दा, आंदुर सांगुळ युद्ध इन साटी पाँती कटदुर: ");
INSERT INTO hoy_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","मतलब एलाम उन राजा कदोर्लाओमेर, गोयीम उन राजा तिदाल, शिनार उन राजा अम्रापेल, अदिक एल्लासार उन राजा अर्योक, ई नाकु मुंदुर्द खिलाप आ अईदु मुंदुर पाँती कटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीम हेसुर इन तराई दा येल दलदला मुण्‍ण इन खॉदरा अच खॉदरा ईरव; सदोम अदिक गमोरा अन राजा ओळ्‍त ओळ्‍त अऊर दा बिदोदुर, अदिक जो ऊळदोदुर आंदुर पहाळी मा वोळेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","आग आंदुर सदोम अदिक गमोरा अन सप्‍पा धन अदिक भोजन वस्‍तुगोळ इक लूट पाट माळकु वोळेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","अदिक अब्राहम उन पुतणा लूत, जो सदोम दा ईरतोगोन, आऊक भी आंदुर धन इन सांगुळ ओत कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","आग ऊंद मंळसा जो ओळकु ऊळदोगीदुन आव होगकु इब्री अब्राहम उक समाचार कोट्‍टुन; अब्राहम रा एमोरी मम्रे, जो एश्‍कोल अदिक आनेर उन वार्ट ईरोन, आऊन बांज मार्रगोळ बीच दा ईरतोगोन; अदिक ई लॉकुर अब्राहम उन सांगुळ वादा कटकु ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ईद केळकु कि आऊन पुतणा बंदी माळकु आग्‍यान, अब्राहम तान मुर सौ अठराह कल्‍द मंळसा, युद्ध कौशल दा निपुण दासगोळी हुडुकु जो आऊन कुटुम्‍ब दा पैदा आगीदुर, अस्त्र-शस्त्र धारण माळकु दान ताका आंदुर्द पीछा माळदुन; ");
INSERT INTO hoy_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","अदिक तान दासगोळ्‍द अलग अलग दल कटकु ईळ्‍ल्‍क इक आंदुर मा चळाई माळकु आंदरी कोंद बुट्‍टुर अदिक होबा ताका, जो दमिश्क इन उत्‍तर इन दी आद, आंदुर्द पीछा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","अदिक आव सप्‍पा धन इक, अदिक तान पुतणा लूत अदिक आऊन धन इक, अदिक आर्तेर इक, अदिक सप्‍पा बंदीगोळी वापस तंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","याग आव कदोर्लाओमेर अदिक आऊन साथी राजागोळी हारूसकु वापस बरोन, रा सदोम इन राजा, शाबे इन घाटी जो राजा अन घाटी अनकु आगतद, आऊन से भेंट माळली बंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","आग शालेम इन राजा मलिकिसिदक, रोट्‍टी अदिक अंगुर इन रास्सा तंदुन. आव परमप्रधान परमेश्वर उन याजक ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","आग आव आऊक ईद आशीर्वाद कोट्‍टुन “स्‍वर्ग अदिक पृथ्‍वी इक माळावाळा परमप्रधान परमेश्वर उन दी टु अब्राहम धन्‍य आगुल; ");
INSERT INTO hoy_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","परमप्रधान परमेश्वर भी धन्‍य आन, याव नीन दुश्‍मनगोळी नीन वश दा माळ कोंडुन. बाक अब्राहम आऊक सप्‍पा वस्‍तुगोळ्‍द हतवा अंश कोट्‍टुन.” ");
INSERT INTO hoy_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","आग सदोम इन राजा अब्राहम से अंदुन, “लॉकुरी रा नानी कोळ अदिक धन संपत्ती तान साटी ईट बुळ.” ");
INSERT INTO hoy_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","अब्राहम सदोम इन राजा से अंदुन, “ना स्‍वर्ग अदिक पृथ्‍वी इन परमप्रधान परमेश्वर यहोवा अन कसम ताकोंडीन, ");
INSERT INTO hoy_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","आऊन ना ईद किर्‍या तिनतीन, कि जो येनारा नींद आद अदुर दा टु ना रा ऊंद सूत, अदिक ना जुता अन बंध, अदिक न येनारा वस्‍तु ताकोमाईन कि नी हिंग अन बाळुल कि अब्राहम नांद अच कारण धनी आग्‍यान. ");
INSERT INTO hoy_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","लेकीन जो येनारा ई हारोदोर तीन कोंडार अदिक आंदुर्द भाग, जो नान सांगुळ होगीदुर मतलब आनेर, एश्‍कोल, अदिक मम्रे, ना वापस माळतीदील, आंदुर रा तान तान हिस्‍सा ईट कोमुल.” ");
INSERT INTO hoy_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ई मातगोळ बाद्‍दा यहोवा अन ईद वचन दर्शन दा अब्राहम उन हात्‍ती पोहचुस्‍त: “हे अब्राहम, अंजबाळ; नीन ढाल अदिक नीन हापाळ धोळ्‍द प्रतिफल ना हुईन.” ");
INSERT INTO hoy_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्राहम अंदुन, “हे प्रभु यहोवा, ना रा बीना चिकोर इन आईन, अदिक नान मान्‍ना अन वारीस ईव दमिश्कवासी एलीएजेर आदान, अत: नी नानी येन कोट्या?” ");
INSERT INTO hoy_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अदिक अब्राहम अंदुन, “नानी रा नी वंश कोटीदील, अदिक येन नोळतीन कि नान मान्‍या पैदा आग्‍यान ऊंद जन नान वारीस आदान.” ");
INSERT INTO hoy_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","आग यहोवा अन वचन आऊन हात्‍ती पोहचुस्त, “ईव नीन वारीस आगतीदील, नीन जो खुद इनव पार आदान, आवा नीन वारीस आदान.” ");
INSERT INTO hoy_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","अदिक आव आऊक व्हार्या वोतकु अंदुन, “आकाश इन दी नोळकु तारागोळी आळु, येन नी अवरी आळु सकत्‍या? बाक आव आऊन से अंदुन, नीन वंश हिंग अच आदीत.” ");
INSERT INTO hoy_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","आव यहोवा मा विश्वास माळदुन; अदिक यहोवा ई मात इक आऊन लेख दा धर्म आळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","आग आव आऊन से अंदुन, “ना आवा यहोवा हुईन जो नीनी कसदी अन ऊर नगर टु व्‍हार्या तंदुन, कि नीनी ई द्‍याश इन अधिकार कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","अब्राहम अंदुन, “हे प्रभु यहोवा, ना ह्‍यांग जानसाईन कि ना ईदुर्द अधिकारी आगाईन?” ");
INSERT INTO hoy_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","यहोवा आऊन से अंदुन, “नान साटी मुर वर्ष इन ऊंद कलोर, अदिक मुर वर्ष इन ऊंद मर्र, अदिक मुर वर्ष इन ऊंद म्यांडा, अदिक ऊंद फंडकुल अदिक कबूतर इन ऊंद पाड्‍डा हुडु.” ");
INSERT INTO hoy_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ई सप्‍पा जनावर हुडुकु आव अऊर बीच दा टु तुकळा माळदुन, अदिक तुकळागोळी आमने सामने ईटदुन; लेकीन पक्षीगोळोव आव तुकळा माळीदिल. ");
INSERT INTO hoy_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","याग मासाहारी पक्षी लाशगोळ मा झपटुसदव, आग अब्राहम अवरी तुळकाळ्स बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","याग सुर्य अन मुळकोद समय आत, आग अब्राहम उक भारी जप बत्‍त; अदिक नोळी, हापाळ अंज्क अदिक महा अंधकार आऊक घेर्सकोम्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","आग यहोवा अब्राहम से अंदुन, “ईद सही दा जान्‍स कि नीन वंश पराया द्‍याश दा परदेशी आगकु ईत्‍तार, अदिक आ द्‍याश इन लॉकुरोर दास आगेदार; अदिक आंदुर आंदरी नाक सौ वर्ष ताका दु:ख कोट्‍टार. ");
INSERT INTO hoy_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","बाक याता द्याश इन आंदुर दास आदार आऊक ना दण्‍ड कोळाईन: अदिक अदुर बाद्‍दा आंदुर धोळ्‍द धन अल टु हुडुकु बंदार. ");
INSERT INTO hoy_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","नी रा तान पुर्वजगोळ सांगुळ मीलुसेद्‍या; नीनी पुरा बुढ़ापा दा मुण्ण कोटकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","लेकीन आंदुर नाकवा पीढ़ी दा ईल मात बंदार : यतिकी ईगासताका एमोरी इन अधर्म पुरा आगली आद.” ");
INSERT INTO hoy_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","अदिक हिंग आत कि याग सुर्य मुळकेत अदिक हापाळ अंधार आत, आग ऊंद बेक्‍की इन भट्टी यदुर दा टु धुंगा येळ तोगोद अदिक ऊंद होततेला मशाल कांळ्‍स्‍त जो आ तुकळा गोळ बीच दा टु आगकु होटबुळ्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ईदा दिशी यहोवा अब्राहम उन सांगुळ ईद वादा माळदुन, “मिस्त्र अन महानद टु हुडुकु फरात हेसुर इन धोळ्‍द नद ताका याट द्‍याश आद, ");
INSERT INTO hoy_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","मतलब केनियो, कनिज्‍जियों, कदमोनियों, ");
INSERT INTO hoy_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परिज्जी, रपाईयो ");
INSERT INTO hoy_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरीगोळ, कनानीगोळ, गिर्गाशीगोळ, अदिक यबूसीगोळ द्‍याश ना नीन वंश इक कोटीन.” ");
INSERT INTO hoy_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्राहम उन हिंग्‍स सारै अन याऊ पार ईला ईरोन. आकिन हाजिरा हेसुर इन ऊंद मिस्त्री दासी ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","सारै अब्राहम से अंदुर, “नोळ, यहोवा रा नान क्‍वाता बंद माळकु ईट्‍यान, इदुरसाटी ना नीन से विनती माळतीन कि नी नान दासी इन हात्‍ती होग; आग सकतद कि नान मान्‍ना आकिन द्वारा बसुसेगुल.” सारै अन ईद मात अब्राहम मान्‍स कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","इदुरसाटी याग अब्राहम उक कनान द्‍याश दा ईरतेला हत्‍त वर्ष आगेगीदव आग आऊन हिंग्‍स सारै तान मिस्त्री दासी हाजिरा अक हुडुकु तान गांड अब्राहम उक कोट्‍टुर, कि आक आऊन हिंग्‍स आगुल. ");
INSERT INTO hoy_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","आव हाजिरा अन हात्‍ती होदुन, अदिक आक गर्भवती आदुर. याग आक जान्सदुर कि आक गर्भवती आर, आग आक तान स्‍वामिनी इक बेकार नजर देल नोळली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","आग सारै अब्राहम से अंदुर, “जो नान मा उपद्रव आत अद नींद अच ताल्‍ला मा ईरूल. ना रा तान दासी इक नीन हिंग्‍स माळ बुटीन; लेकीन याग आक जान्सदुर कि आक गर्भवती आर, आग आक नानी बेकार सम्‍सली कुरतुर; इदुरसाटी यहोवा नीन अदिक नान बीच दा न्‍याय माळुल.” ");
INSERT INTO hoy_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्राहम सारै से अंदुन, “नोळ, नीन दासी नीन वश दा आर; ह्‍यांग नीनी भला हततद हांग अच आकिन सांगुळ माळ.” आग सारै आक इक दुख कोळली कुरतुर, अदिक आक आकिन मुंदु टु ओळेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","आग यहोवा अन दूत आकी आळी दा शूर इन हादी मा नीर इन ऊंद झरना अन हात्‍ती नोळकु अंदुन, ");
INSERT INTO hoy_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“हे सारै अन दासी हाजिरा, नी येल टु बरेत्‍या अदिक येल होगेत्‍या?” आक अंदुर, “ना तान स्‍वामिनी इन मुंदु टु ओळकु बंदीन.” ");
INSERT INTO hoy_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","यहोवा अन दूत आकिन से अंदुन, “तान स्‍वामिनी इन हात्‍ती होटोग अदिक आकिन वश दा ईर.” ");
INSERT INTO hoy_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","अदिक यहोवा अन दूत आकिन से ईद भी अंदुन, “ना नीन वंश इक हापाळ वाळुसाईन, ईल ताका कि हापाळ वाळुसदुर कारण आऊन गिनती आग सकतीदिल.” ");
INSERT INTO hoy_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","अदिक यहोवा अन दूत आकिन से अंदुन, “नोळ, नी गर्भवती आय, अदिक चिग्‍द हाळद्‍या; नी आऊन हेसुर इश्‍माएल ईटेत, यतिकी यहोवा नीन दुख इन हाल केळ कोंडान. ");
INSERT INTO hoy_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","अदिक मंळसा आळी दाकळोद गधा अन घाई ईत्‍तान, आऊन कय सप्‍पा मुंदुर खिलाप येद्‍दव; अदिक आव तान सप्‍पा वार्टुर बीच दा बसुस्कु ईत्‍तान.” ");
INSERT INTO hoy_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","आग यहोवा याव आकिन से मातगोळ हेळीदुन आकिन हेसुर आव “नी नोळावाळा ईश्वर” ईटदुन अदिक अंदुन, येन ना ईल भी आऊक नोळदुर बाद्‍दा भी जीत्‍ता ईतोदिन. ");
INSERT INTO hoy_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ईद कारण आ भाय इन हेसुर लहैरोई भाय बीत्‍त; अद रा कादेश अदिक बेरेद इन बीच दा आद. ");
INSERT INTO hoy_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हाजिरा अक अब्राहम उन द्वारा ऊंद पार आदुन; अदिक अब्राहम तान पार उन हेसुर, यारी हाजिरा जनम कोटीदुर, इश्‍माएल ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","याग हाजिरा अब्राहम उन द्वारा इश्‍माएल उक जनम कोट्‍टुर आ समय अब्राहम छियासी वर्ष इनव ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","याग अब्राहम निन्‍यानवे वर्ष इनव आगेदुन, आग यहोवा आऊक दर्शन कोटकु अंदुन, “ना सर्वशक्तिमान ईश्‍वर हुईन; नान उपस्‍थिति दा नळु अदिक सिद्ध आगतेला होग. ");
INSERT INTO hoy_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ना नीन सांगुळ वादा माळाईन, अदिक नीन वंश इक हापाळ अच वाळुसाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","आग अब्राहम बाय इन भार बिद्‍दुन; अदिक परमेश्वर आऊन से ईव मातगोळी माळतेला ईत्‍तुन, ");
INSERT INTO hoy_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“नोळ, नान वादा नीन सांगुळ कटकु ईत्‍तीत, इदुरसाटी नी जातीगोळ समूह अन मूल आप्‍प आगेद्‍या. ");
INSERT INTO hoy_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","इदुरसाटी ईग टु नीन हेसुर अब्राहम ईरतीदील, लेकीन नीन हेसुर अब्राहम आदीत; यतिकी ना नीनी जातीगोळ समूह अन मूल आप्‍प ठहरूस बुटीन. ");
INSERT INTO hoy_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ना नीनी हापाळ फलवन्‍त माळाईन, अदिक नीनी जाती जाती इन मूल माळाईन, अदिक नीन वंश दा राजा पैदा आदार.” ");
INSERT INTO hoy_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","अदिक ना नीन सांगुळ, अदिक नीन बाद्‍दा पीढ़ी पीढ़ी ताका नीन वंश इन सांगुळ भी ई आशय इन युग युग इन वादा कटतीन, कि ना नीन अदिक नीन बाद्‍दा नीन वंश इनव भी परमेश्वर ईराईन. ");
INSERT INTO hoy_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","अदिक ना नीनी इक, अदिक नीन बाद्‍दा नीन वंश इक भी, ईद सप्‍पा कनान द्‍याश यदुर दा नी परदेशी आगकु ईरत्‍या, युग युग इन साटी कोट बुळाईन; अदिक ना आंदुरव परमेश्वर आगाईन. ");
INSERT INTO hoy_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","बाक परमेश्वर अब्राहम से अंदुन, “नी भी नान सांगुळ कट्‍द वादा अन पालन माळेत; नी अदिक नीन बाद्‍दा नीन वंश भी तान तान पीढ़ी दा अदुर्द पालन माळुल. ");
INSERT INTO hoy_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","जो वादा नीन अदिक नान बीच तथा नीन बाद्‍दा नीन वंशज इन बीच दा आद अदिक जो नीव मान्‍सतोदिर अद ईद हुन कि नीम दा टु हर ऊंद मंळसा अन खतना माळकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","नीव तान तान खतना माळ कोमेतीर: जो वादा नीम अदिक नान बीच दा आद, अदुर्द ईदा चिन्ह आदीत. ");
INSERT INTO hoy_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","अदिक नीम पीढ़ी टु पीढ़ी ताका नीम बीच दा येट्‍ट दिन इन सप्‍पा पारगोळ्‍द खतना माळकु आगुल; चाहे आव नीम मान्‍या पैदा आगीदान या यातोवारा परदेशी इन हाती टु पैस्या देल कोंडकु यती ईला आगीदान अदिक नीम वंश इनव येती ईला आगीदान. ");
INSERT INTO hoy_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","जो दास नीन मान्‍या पैदा आगीदान या नीन धन देल कोंडकु आगीदान आऊन खतना जरूर माळकु आगुल; ई प्रकार नान वादा अन ईद चिन्‍ह युग युग ताका नीम शरीर दा बन्सकु ईत्‍तीत. ");
INSERT INTO hoy_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","लेकीन जो मंळसा खतना रहित ईरूल, मतलब यार्द खतना ईला आगीदाद, आव प्राणी तान लॉकुर दा टु नष्‍ट माळकु आगुल, यतिकी आव नान सांगुळ कट्‍द वादा अक मुर्द बुट्‍टुन.” ");
INSERT INTO hoy_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","बाक परमेश्वर अब्राहम से अंदुन, “नीन हिंग्‍स जो सारै आर, आकी नी ईगी टु सारै अनबाळेत, आकिन हेसुर सारा ईत्‍तीत. ");
INSERT INTO hoy_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","अदिक ना आकी आशीष कोळाईन, अदिक सही दा नीनी आकिन द्वारा ऊंद चिग्‍द कोळाईन. अदिक ना आकी आशीष कोळाईन अदिक आक जाती जाती इन जननी आदार; अदिक आकिन से राज्‍य राज्‍य अन राजागोळ पैदा आदार.” ");
INSERT INTO hoy_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","आग अब्राहम बाय इन भार देल बिद्‍दुन अदिक नेगली कुरतुन, अदिक अनली कुरतुन, “येन सौ वर्ष इन मंळसा अन भी चिग्‍द आदीत अदिक येन सारा जो नब्‍बे वर्ष इन आर चिग्‍द हाळदार?” ");
INSERT INTO hoy_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","अदिक अब्राहम परमेश्वर से अंदुन, “इश्‍माएल नीन नजर दा बन्सकु ईरूल! ईदा हापाळ आद.” ");
INSERT INTO hoy_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","आग परमेश्वर अंदुन, सही दा नीन हिंग्‍स सारा नीन से ऊंद पार पैदा आदान; अदिक नी आऊन हेसुर इसहाक ईटेत; अदिक ना आऊन सांगुळ हिंग वादा माळाईन जो आऊन बाद्‍दा आऊन वंश इन साटी युग-युग इन वादा आदीत. ");
INSERT INTO hoy_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","इश्‍माएल इन बारा दा भी ना नींद केळीन; ना आऊक भी आशीष कोळाईन, अदिक आऊक फलवन्‍त माळाईन अदिक हापाळ अच वाळुस बुळाईन; आऊन से हन्‍नेळ प्रधान पैदा आदार, अदिक ना आऊन से ऊंद धोळ्‍द जाती माळाईन. ");
INSERT INTO hoy_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","लेकीन ना तान वादा इसहाक इन सांगुळ अच कटाईन जो सारा से सामने वर्ष ईदा नीवळुस्द समय दा पैदा आदान. ");
INSERT INTO hoy_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","आग परमेश्वर अब्राहम से मातगोळ माळोद बंद माळदुन अदिक आऊन हाती टु म्‍याकुच येरेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","आग अब्राहम तान पार इश्‍माएल उक अदिक आऊन मान्‍या यास पैदा आगीदुर सप्‍पा लॉकुर इक अदिक यारी आव धन कोटकु कोंडीदुन, मतलब आऊन मान्‍या यास मंळसागोळ ईरोर, आ सप्‍पा मुंदुरी हुडुकु अदा दिशी परमेश्वर उन वचन इन अनुसार आदुर्द खतना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","याग अब्राहम उन खतना आत आग आव निन्‍यानवे वर्ष ईनव ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","अदिक याग आऊन पार इश्‍माएल उन खतना आत आग आव तेरह वर्ष ईनव ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहम अदिक आऊन पार इश्‍माएल येढ्‍ढु मुंदुर्द खतना ऊंदा दिशी आत; ");
INSERT INTO hoy_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","आऊन सांगुळ अच आऊन मान्‍यागोळोर सप्‍पा मंळसागोळ्‍द जो मान्‍या पैदा आदुर अदिक जो परदेशीगोळ कय देल पैस्या देल कोंडकु आगीदुर, खतना आत. ");
INSERT INTO hoy_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","याग अब्राहम हागुल इन कळकळास्‍त बिसुल दा तान ड्‍यारा अन दरवाजा मा कुर्तकु ईरोन आग यहोवा मम्रे अन बांज मार्र इन हाती आऊन मुंद प्रकट आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","अदिक याग आव तान कण्‍ण म्याकुच नेगदुन रा नोळदुन कि मुर मंळसा नान मुंद नीदुरकु आर. आंदरी नोळकु आव आंदुर से सीकली ड्‍यारा अन दरवाजा टु ओळदुन, अदिक जमीन मा बिदकु आव प्रणाम माळदुन, ");
INSERT INTO hoy_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","अदिक अंदुन, “नान प्रभु, अगर नान मा नींद कृपा दृष्‍टि आद रा तान दास उन हाती टु हिंग अच होगबाळेत. ");
INSERT INTO hoy_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","थ्‍वाळासा नीर तनकु आगुल यदुर देल कि नीव लॉकुर तान काल तोळकु ई मार्र इन ल्‍यालमा आराम माळी. ");
INSERT INTO hoy_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","नीव रा तान दास उन मान्‍या बंदीर, इदुरसाटी ना येनारा रोट्‍टीगोळ तराईन कि नीव तीनकु तृप्‍त आगी, अदुर बाद्‍दा नीव होटोगेतीर.” आंदुर अंदुर, “ह्‍यांग नी अंद हांग अच माळ.” ");
INSERT INTO hoy_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","अब्राहम ड्‍यारा दा सारा अन हाती जल्‍दी होगकु अंदुन, “तुरन्‍त हत्‍त किलो मैदा हुडुकु काल्‍सकोम अदिक रोट्‍टी माळ.” ");
INSERT INTO hoy_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","बाक अब्राहम वस्‍ता-वाळी इन झुंड दी ओळदुन अदिक ऊंद कोमल अदिक वळ्‍लीद पाड्‍डा हुडुकु तान सेवक उक कोट्‍टुन, अदिक आव अदरी जल्‍दी से बेईसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","आग आव हाल अदिक दही अदिक पाड्‍डा अन मास, जो आव बेईसुसीदुन, आंदुर मुंद वाट्‍स बुट्‍टुन; अदिक खुद मार्र इन ल्‍यालमा आंदुर हात्‍ती नीदुरकु ईत्‍तुन, अदिक आंदुर तीनली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","आंदुर आऊन से केळदुर, “नीन हिंग्‍स सारा येल आर?” आव अंदुन, “आक रा ड्‍यारा दा आर.” ");
INSERT INTO hoy_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","आव अंदुन, “ना ब्‍यासक्‍या अन दिनगोळ दा सही दा नीन हात्‍ती मात्‍त बराईन, अदिक नीन हिंग्‍स सारा अक ऊंद पार पैदा आदान.” सारा ड्‍यारा अन दरवाजा मा जो अब्राहम उन हिंद ईरोर, केळोर. ");
INSERT INTO hoy_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहम अदिक सारा येढ्‍ढु मुंदुर हापाळ हाळाबाट्ट आगेगीदुर; अदिक सारा अन व्‍हार्या आगोद बंद आगेगीत. ");
INSERT INTO hoy_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","इदुरसाटी सारा मन दा नेगकु अनली कुरतुर, “ना रा हाळामुंड आईन, अदिक नान गांड भी हाळाबाट्ट आन, रा येन नानी ईद सुख आदीत?” ");
INSERT INTO hoy_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","आग यहोवा अब्राहम से अंदुन, “सारा ईद अनकु येती नेगदुर कि ना जो ईट हाळामुंड आईन, येन सही दा जनम कोळ सकाईन? ");
INSERT INTO hoy_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","येन यहोवा अन साटी येनारा भी क्‍याल्‍सा कठीण आद? ना सही समय मा मतलब सामने वर्ष ईदा समय नीन हात्‍ती मात बराईन अदिक सारा अन मोगुल दा ऊंद पार ईत्‍तान.” ");
INSERT INTO hoy_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","आग सारा अंज्‍क इन मारा ईद अनकु तान मय तेगदुर, “ना नेगीदिल.” आव अंदुन, “ईला नी रा नेगीद.” ");
INSERT INTO hoy_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","बाक आ मंळसागोळ अल टु नळदुर अदिक सदोम इन दी नोळदुर; अदिक अब्राहम आंदरी सार माळोर साटी आंदुर सांगुळ सांगुळ नळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","आग यहोवा अंदुन, “ईद जो ना माळतीन, अदरी येन ना अब्राहम से होचकोमकु ईटाईन? ");
INSERT INTO hoy_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहम से रा सही दा ऊंद धोळ्‍द अदिक सामर्थी जाती पैदा आदीत, अदिक पृथ्‍वी इन सप्‍पा जातीगोळ आऊन द्वारा आशीष सिक्कीत. ");
INSERT INTO hoy_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","यतिकी ना जान्‍सतीन कि आव तान चिकोरी अदिक परिवार इक, जो आऊन हिंद ईतोदार, आग्‍या कोट्‍टान कि आंदुर यहोवा अन हादी दा अटल बन्सकु ईरूल, अदिक धर्म अदिक न्‍याय माळतेला ईरूल; ताकी जो येनारा यहोवा अब्राहम उन बारा दा अंदान अदरी पुरा माळुल.” ");
INSERT INTO hoy_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","बाक यहोवा अंदुन, “सदोम अदिक गमोरा अन चिल्‍ळासोद वाळुसीग्‍याद, अदिक आंदुर्द पाप हापाळ भारी आगेग्‍याद; ");
INSERT INTO hoy_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","इदुरसाटी ना ईळुकु नोळाईन कि अदुर घाई चिल्‍ळासोद नान कीव ताका पोहचुस्‍याद, आंदुर ठीक हांग अच क्‍याल्‍सा माळ्‍यार कि ईला; अदिक ईला माळीदार रा ना अदरी जान्स कोमाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","आग आ मंळसागोळ अल टु तिर्गकु सदोम इन दी होगली कुरतुर; लेकीन अब्राहम यहोवा अन मुंद नीदुरकु ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","आग अब्राहम आऊन हात्‍ती होगकु अनली कुरतुन, “येन नी सही दा दुष्ट उन सांगुळ धर्मी इन भी नाश माळ्‍या? ");
INSERT INTO hoy_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","अगर आ नगर दा पचास मंळसा धर्मी ईरूल, रा येन नीव आ नगर इक नाश माळीर? येन आ पचास धर्मीगोळ कारण बाकी सप्‍पा लॉकुर ऊळु सकालुर? ");
INSERT INTO hoy_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ई प्रकार इन क्‍याल्‍सा माळोद नीम से दुर ईरूल दुष्ट मंळसा अन सांगुळ धर्मी मंळसा अक कोंद कोमोद, बुरा अदिक धर्मी इन सांगुळ ऊंद घाई व्‍यवहार माळोद. हिंग माळोद नीम से दुर ईरूल! येन सप्‍पा पृथ्‍वी इन न्‍यायी न्‍याय माळतीदील?” ");
INSERT INTO hoy_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","यहोवा अंदुन, “अगर नानी सदोम शहर दा पचास धर्मी मंळसा सीकतार, रा ना आंदुर कारण पुरा शहर इक बिट बुळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","अब्राहम मात अंदुन: “हालाकी ना सिर्फ मुण्‍ण अदिक राख हुईन, तरी भी ना प्रभु से मात माळोद हिम्‍मत माळीन, ");
INSERT INTO hoy_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","अगर अल पचास दा टु अईद धर्मी कम आगेदार, रा येन नीव अईद धर्मी कम आगदुर कारण पुरा नगर इन नाश माळीर?” यहोवा उत्‍तर कोट्‍टुन, “अगर नानी अल पैतालीस भी सीकतार, रा ना आ नगर इक नाश माळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ऊंद घन मात अब्राहम यहोवा से अंदुन, “अगर अल चालीस अच धर्मी सीक्‍यार रा?” यहोवा उत्‍तर कोट्‍टुन, “आ चालीस इन कारण भी ना नाश माळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","आग अब्राहम अंदुन, प्रभु नान मा नाराज आगबाळ, “लेकीन नानी माताळगोळ. अगर अल तीस अच धर्मी सीक्‍यार रा?” यहोवा उत्‍तर कोट्‍टुन, “अगर नानी अल तीस भी सीकतार रा नाश माळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","आग अब्राहम अंदुन, “प्रभु, ना नीम से मात माळोद रा हिम्‍मत माळ अच कोंडीन; ईद भी आग सकतद कि अल ईप्‍पत अच सीकतार रा?” यहोवा उत्‍तर कोट्‍टुन, “आ ईप्‍पत इन कारण भी ना आ नगर इक नाश माळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","बाक अब्राहम अंदुन, “हे प्रभु, नी सिट्‍ट दा बरबाळ, आखरी घन ना नीन से विनती माळतीन. अगर अल हत्‍त अच सीक्‍यार रा?” यहोवा उत्‍तर कोट्‍टुन, “ना आ हत्‍त इन कारण आ नगर इक नाश माळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","याग यहोवा अन अब्राहम से मात माळकु आत, रा आव अल टु होटोदुन, अदिक अब्राहम तान मान्‍या वापस होटोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","द्‍याव मुळकास ताका आ येढ्‍ढ स्वर्गदूत सदोम पोहचुसदुर. ई समय लूत सदोम इन प्रवेश दरवाजा मा अच कुर्तकु ईरोन. स्‍वर्गदूतगोळ मा नजर बीळतेला अच लोत आंदुर से मुलाकात माळोरसाटी नीदुरदुन अदिक आंदरी नमस्‍कार माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","अदिक अंदुन, “हे नानोर प्रभुगोळा, नीव तान सेवक उन मान्‍या बरी. नीव तान काल तोळकु ईळ्‍ल्‍की ईल ईरी अदिक व्हातर्‍या तान यात्रा मा मुंद होगी.” लेकीन आंदुर उत्‍तर कोट्‍टुर, “ईला, ईळ्‍ल्‍क रा नाव ईल नगर इन चौक दा व्‍यतीत माळेव.” ");
INSERT INTO hoy_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","अदिक लोत आंदुर से हापाळ विनती माळकु आंदरी राजी माळदुन; इदुरसाटी आंदुर आऊन सांगुळ नळुकु आऊन मान्‍या बंदुर; अदिक लोत आंदुर साटी भोजन तैयार माळदुन, अदिक बिना खमीर इन रोट्‍टी माळकु आंदरी तीन्‍सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","आंदुर मींगा से पयले, सदोम नगर इन मंळसागोळ, हारोदोर से हाळाबाट्‍टुर ताका, बल्‍की नाकु दिकळोर सप्‍पा लॉकुर बंदकु आ मान्‍ना अक घेर्स कोंडुर; ");
INSERT INTO hoy_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","अदिक लूत उक कारूकु अनली कुरतुर, “जो मंळसा ईंद ईळ्‍ल्‍की नीन हाती बंदार आंदुर येल आर? आंदरी नाम हाती व्‍हार्या तर, कि नाव आंदुर से संभोग माळेव.” ");
INSERT INTO hoy_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","आग लूत आंदुर हाती व्‍हार्या होदुन, अदिक दरवाजा अक तान हिंद बंद माळकु अंदुन, ");
INSERT INTO hoy_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“हे नान वार्टुरा, हिंग बुराई माळबाळी. ");
INSERT INTO hoy_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","केळी, नानोर येढ्‍ढ पोरगोळ आर अदिक आंदुर ईगासताका यातोदु मंळसा अन बाय नोळीदील, इच्‍छा ईतीदाद रा ना आंदरी नीम हाती व्‍हार्या तराईन, अदिक नीमी ह्‍यांग वळ्‍लीद हततद हांग व्‍यवहार आंदुर से माळी: लेकीन ई मंळसागोळ से येनु माळबाळी; यतिकी ईंदुर नान मान्‍या बंदार.” ");
INSERT INTO hoy_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","आंदुर अंदुर, “सरकुसेग!” बाक आंदुर अनली कुरतुर, “नी ऊंद परदेशी आगकु ईल ईरोर साटी बंद्‍या लेकीन इग न्‍यायी भी बन्सकु कुरत्‍या; इदुरसाटी ईग नाव आंदुर से भी वाळुसकु नीन सांगुळ बुराई माळेव.” अदिक आंदुर आ मंळसा लूत उक हापाळ दब्सली कुरतुर, अदिक दरवाजा मुरोरसाटी हाती बंदुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","आग आ पावनागोळ कय वाळुसकु लूत उक तान हाती मान्‍या जेळदूर, अदिक दरवाजा अक बंद माळ कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","अदिक आंदुर येन स्‍याणेर, येन धोड्‍डेर, सप्‍पा मंळसागोळी जो मान्‍या अन दरवाजा मा ईरोर कुढ्‍ढ माळ बुट्‍टुर, अत: आंदुर दरवाजा अक ताळुत ताळुत थकसेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","बाक आ पावनागोळ लूत से केळदुर, “ईल नीनोर अदिक यार यार आर? जवाई, पारगोळ, पोरगोळ, अदिक नगर दा नीन यावारा ईतीदान, आ सप्‍पा अक हुळकु ई जागा टु होटबुळ. ");
INSERT INTO hoy_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","यतिकी नाव आ जागा अक नाश माळोर आयेव, इदुरसाटी कि ईदुर्द चिल्‍ळासोद यहोवा अन हाती वाळुसीग्‍याद; अदिक यहोवा नामी ईदुर्द सत्‍यानाश माळोर साटी कळ्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","आग लूत होटकु तान जवाईगोळी, यार सांगुळ आऊन पोरगोळ्‍द सगाई आगेगीत, समझुसकु अंदुन, “येळी, ई जागा टु नळी; यतिकी यहोवा ई नगर इक नाश माळावाळा आन.” आऊन जवाईगोळ आऊन मज्‍याक हार्सली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","याग व्‍हातुर आगली कुर्त, आग दूतगोळ लूत उक हिंग माळली अंदुर, “येळ, तान हिंग्‍स अदिक येढ्‍ढु पोरगोळी जो ईल आर वोय: ईलारा नी भी ई नगर इन अधर्म दा भस्‍म आगेद्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","लेकीन आव विलम्‍ब माळतेला ईत्‍तुन, ईदुर मा आ मंळसागोळ आऊक अदिक आऊन हिंग्‍स, अदिक येढ्‍ढु पोरगोळ कय हुळदुर; यतिकी यहोवा अन दया आऊन मा ईरोद; अदिक आऊक तेगुकु नगर इन व्‍हार्या माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","अदिक हिंग आत कि याग आंदुर आंदरी व्‍हार्या तेगदुर, आग आव अंदुन, “तान जीव हुडुकु ओळेग; हिंद नोळ बाळेत, अदिक तराई दा थाम्‍सबाळेत; आ पहाळी मा ओळेगेत, ईलारा नी भी भस्‍म आगेद्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","लूत आंदुर से अंदुन, “हे प्रभु, हिंग माळबाळ! ");
INSERT INTO hoy_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","नोळ, नीन दास मा नींद अनुग्रह अन नजर आद, अदिक नी ईदुर्दा हापाळ कृपा तोर्स्‍द, कि नान जीव इक ऊळ्‍सद; लेकीन ना पहाळी मा ओळ सकालीन, कि हिंग आगबाळुल, कि यातोदारा परेशानी नान मा बंदकु बिळुल, अदिक ना सोतोगाईन. ");
INSERT INTO hoy_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","नोळ, अद नगर हिंग हाती आद कि ना अल ओळ सकतीन, अदिक अद स्यांळ्द भी आद. नानी अल अच ओळगोळी, येन आ नगर स्यांळ्द हैलेच? अदिक नान जीव ऊळदोदीत.” ");
INSERT INTO hoy_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","आव आऊन से अंदुन, “नोळ, ना ई बारा दा भी नीन विनती स्‍वीकार माळीन, कि याता नगर इन चर्चा नी माळ्‍द, अदरी ना नाश माळतीदील. ");
INSERT INTO hoy_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","जल्‍दी अल ओळतेला होटोग; यागासताका नी अल होगाल आगासताका ना येनु माळ सकतीदिल.” ईदा कारण आ नगर इन हेसुर सोअर बीत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","लूत उन सोअर इन हाती पोहचुसतेला अच सूर्य पृथ्‍वी मा उदय आत. ");
INSERT INTO hoy_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","आग यहोवा तान दी टु सदोम अदिक गमोरा मा आकाश टु गन्‍धक अदिक बेक्‍की बरसुसदुन; ");
INSERT INTO hoy_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","अदिक आ नगरगोळी अदिक पुरा तराई, अदिक नगर दाकळोर सप्‍पा ईरावाळेर इक, जमीन इन सप्‍पा ऊपज सांगुळ नाश माळ बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","लूत उन हिंग्‍स जो आऊन हिंद ईरोर हिंद पलटुसकु नोळदुर, अदिक आक ऊप्‍प इन खंबा बनसेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","व्हातर्‍या का येदकु अब्राहम आ जागा मा होदुन, येल आव यहोवा अन हाती नीदुरकु ईरोन; ");
INSERT INTO hoy_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","अदिक सदोम, अदिक गमोरा, अदिक आ तराई इन सप्‍पा द्‍याशगोळ दी कण्‍ण नेगुकु येन नोळदुन कि आ द्‍याश दा टु धधकुसतेला भट्‍टी घाई धुंगा येळेत्‍याद. ");
INSERT INTO hoy_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","अदिक हिंग आत कि याग परमेश्वर आ तराई इन नगरगोळी, यदुर दा लूत ईरतोगोन, उलटा पुलटा माळकु नाश माळदुन, आग आव अब्राहम उक याद माळकु लूत उक आ घटना देल उळ्स बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लूत सोअर इक बिट बुट्‍टुन, अदिक पहाळी मा तान येढ्‍ढु पोरगोळ सांगुळ ईरली कुरतुन; यतिकी आव सोअर दा ईरोर से अंजोन; इदुरसाटी आव अदिक आऊन येढ्‍ढु पोरगोळ अल ऊंद गुफा दा ईरली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","आग धोळ पोर स्‍याण पोर से अंदुर, “नाम आप्‍पा हाळाबाट्‍ट आन, अदिक पृथ्‍वी तीम दा हिंग याऊ मंळसा हैलेच जो दुनिया अन रीति इन अनुसार नाम हाती बरूल, अदिक नाव आंदुर से चिकोर पैदा माळेव. ");
INSERT INTO hoy_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","इदुरसाटी बर, नाव तान आप्‍प उक अंगुर इन रास्सा कुळ्‍सकु, आऊन सांगुळ मींगाता, यदुर देल कि नाव तान आप्‍प उन वंश इक उळ्‍सकु ईट्‍टेव.” ");
INSERT INTO hoy_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","अत: आंदुर अदा दिशी ईळ्‍लकी इन वती तान आप्‍प उक अंगुर इन रास्सा कुळ्‍सदुर, आग धोळ पोर होगकु तान आप्‍प उन हाती मींगेदुर; लेकीन आक जानसीदिल, कि आक याग मींगदुर, अदिक याग येदोदुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","अदिक हिंग आत कि दुसरा दिशी धोळ पोर स्‍याण पोर से अंदुर, “नोळ, नीन ईळ्‍लकी ना तान आप्‍प उन सांगुळ मींगदीन; इदुरसाटी ईंद भी ईळ्‍लकी नाव आऊक अंगुर इन रास्सा कुळसाता; आग नी आऊन सांगुळ मींगेत कि नाव तान आप्‍प उन द्वारा वंश पैदा माळेव.” ");
INSERT INTO hoy_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","अत: आंदुर आ दिशी भी ईळ्‍ल्‍क इन वती तान आप्‍प उक अंगुर इन रास्सा कुळ्‍सदुर, अदिक स्‍याण पोर होगकु आऊन हाती मींगेदुर; लेकीन आकी भी मींगोद अदिक येळोद ग्‍यान ईला ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ई प्रकार देल लूत इन येढ्‍ढु पोरगोळ तान आप्‍प उन दी टु व्‍हाट्‍यादी आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","धोळ पोर ऊंद पार उक हाळदुर, अदिक आऊन हेसुर मोआब ईटदुर; आव मोआब हेसुर इन जाती इन जो ईंद ताका आद मूल आप्‍प मान्सकु आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","अदिक स्‍याणेर पोर भी ऊंद पार उक हाळदुर, अदिक आऊंद हेसुर बेनअम्‍मी ईटदुर; आव अम्मोन वंशिगोळ जो ईंद ताका आर मूल आप्‍प आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","बाक अब्राहम अल टु होटकु कनान इन दक्षिण द्‍याश दा बंदकु कादेश अदिक शूर इन बीच दा थाम्‍सदुन, अदिक गरार दा ईरली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","अदिक अब्राहम तान हिंग्‍स सारा अन बारा दा अनली कुरतुन, “आक नान आकतींग हुळ,” इदुरसाटी गरार इन राजा अबीमेलेक दूत कळुकु सारा अक कार्सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ईळ्‍ल्‍क इक परमेश्वर कान्‍सा दा अबीमेलेक इन हाती बंदकु अंदुन, “केळ याता आर्त इक नी ईट्‍या, आकिन कारण नी सोतोद्‍या, यतिकी आक मदावळ्त आर.” ");
INSERT INTO hoy_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","लेकीन अबीमेलेक आकिन हाती होगली का ईरोन; इदुरसाटी आव अंदुन, “हे प्रभु, येन नी निर्दोष जाती अन भी घात माळ्‍या? ");
INSERT INTO hoy_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","येन आव खुद अच नान से अंदिदील, ‘आक नान आकतींग हुळ?’ अदिक आ आर्त भी अंदुर कि, ‘आव नान वार्ट हुन,’ ना रा तान मन इन खराई अदिक तान व्‍यवहार इन सच्‍चाई देल ईद क्‍याल्‍सा माळीन.” ");
INSERT INTO hoy_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","परमेश्वर आऊन से कान्‍सा दा अंदुन, “हा, ना भी जान्‍सतीन कि तान मन इन खराई देल नी ईद क्‍याल्‍सा माळ्‍या अदिक ना नीनी रोक्‍सकु भी ईटीन कि नी नान विरूद्ध पाप माळबाळेत; ईदा कारण ना नीनी आकी मुट गोटीदील. ");
INSERT INTO hoy_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","इदुरसाटी ईग आ मंळसा अन हिंग्‍स उक आऊक वापस माळ कोम; यतिकी आव नबी हुन, अदिक नीन साटी प्रार्थना माळ्‍यान, अदिक नी जीवन जीऊसतेला ईत्‍या लेकीन अगर नी आऊक वापस माळतीदील रा ध्‍यान ईटेत, कि नी, अदिक नीनोर यास भी लॉकुर आर, सप्‍पा सही दा सोतोदार.” ");
INSERT INTO hoy_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","व्हातर्‍या अबीमेलेक झट से यदकु तान सप्‍पा क्‍याल्‍सा माळावाळेर इक कारूकु आंदरी ईव सप्‍पा मातगोळी हेळदुन; अदिक आ लॉकुर हापाळ अंजेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","आग अबीमेलेक अब्राहम उक कारसुसकु अंदुन, “नी नाम से ईद येन माळ्‍द? अदिक ना नींद येन बीगळुसीदिन कि नी नान मा अदिक नांद राज्‍य अन म्‍याकुच हिंग धोळ्‍द पाप हाक्क कोंड्‍या? नी नान सांगुळ अद क्‍याल्‍सा माळ्‍या जो सही ईला ईरोद.” ");
INSERT INTO hoy_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","बाक अबीमेलेक अब्राहम से केळदुन, “नी येन सम्सकु ईत्‍ता क्‍याल्‍सा माळ्‍द?” ");
INSERT INTO hoy_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहम अंदुन, “ना ईद सोचीदिन कि ई जागा दा परमेश्वर उन येनु अंज्क ईला ईतीदाद; इदुरसाटी ई लॉकुर नान हिंग्‍स उन कारण नानी कोंद बुट्‍टार.” ");
INSERT INTO hoy_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","लेकीन आक सही दा नान आकतींग हुळ, आक नान आप्‍प उन पोर हुळ लेकीन नान मोय इन पोर आलच; बाक आक नान हिंग्‍स आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","बाक हिंग आत कि याग परमेश्वर नानी तान आप्‍प उन मान्‍ना बिटकु होळोद आग्‍या कोट्‍टुन, आग ना आऊन से अंदीन, “ईट कृपा नीनी नान मा माळोद बीद्‍दीत कि नाव येढ्‍ढु मुंदुर येल-येल भी होदेव अल-अल नी नान बारा दा अनेत ईव नान वार्ट हुन.” ");
INSERT INTO hoy_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","आग अबीमेलेक मर्र-म्यांडा, गोसी-वस्‍ता, अदिक दास-दासीगोळ हुडुकु अब्राहम उक कोट्‍टुन, अदिक आऊन हिंग्‍स सारा अक भी आऊक वापस माळ कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","अदिक अबीमेलेक अंदुन, “नोळ, नांद द्‍याश नीन मुंद आद; येल नीनी हततद अल ईर.” ");
INSERT INTO hoy_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","अदिक सारा से अबीमेलेक अंदुन, “नोळ, नीन वार्टुर इक ऊंद हजार बेळ्ली नव सिक्‍कागोळ कोट्टीन. आ सप्पा लॉकुर्द नजर दा नी निर्दोष आय आ सप्पा लॉकुर इक पता नळदीत कि नी यातोदु गलत क्याल्सा माळीदिल.” ");
INSERT INTO hoy_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","आग अब्राहम परमेश्वर से प्रार्थना माळदुन, अदिक यहोवा अबीमेलेक, अदिक आऊन हिंग्‍स, अदिक दासीगोळी चंगा माळदुन अदिक आंदुर चिकोर हाळुली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","यतिकी यहोवा अब्राहम उन हिंग्‍स सारा अन कारण अबीमेलेक उन सप्‍पा आर्तगोळ्‍द कोखगोळी पुरा रीति देल बंद माळकु ईटीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","यहोवा ह्‍यांग अंदीदुन हांग अच सारा अन सुधी ताकोमकु आकिन सांगुळ तान वादा अन्द अनुसार माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","सारा व्‍हाट्‍यादी ईत्‍तुर अदिक आक अब्राहम उक याग आव हाळाबाट्‍ट आगेगीदुन, परमेश्वर इन नीवळुस्द समय दा सारा ऊंद पार उक जनम कोट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहम आ पार उन हेसुर इसहाक ईटदुन यारी सारा पैदा माळीदुर. ");
INSERT INTO hoy_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","याग आऊन पार इसहाक येट्‍ट दिन इनव आदुन, आग अब्राहम परमेश्वर उन आग्‍या अन अनुसार आऊन खतना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","इसहाक उन जनम इन समय अब्राहम उन उमर ऊंद सौ वर्ष इन ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","सारा अंदुर, “नानी परमेश्वर खुशी देल तुम कोंडुन अदिक जो यावारा ईद मात केळ्‍यान, आव भी खुश आदान.” ");
INSERT INTO hoy_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","अदिक आक ईद भी अंदुर, “अब्राहम से याव अनतोगोन कि सारा चिग्‍द उक हाल कुळस्‍यार? लेकीन ना आऊन हाळाबाट्‍ट इन समय दा आऊक ऊंद पार कोट्‍टीन.” ");
INSERT INTO hoy_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","अदिक आव पार वाळुसदुन अदिक आऊंद हाल बिळसुस्‍कु आत; अदिक इसहाक उन हाल बिळसुसा दिशी अब्राहम धोळ्‍द ऊमोद कोट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","लेकीन सारा नोळदुर कि मिस्त्री हाजिरा अन पार, जो अब्राहम से पैदा आगीदुन, मज्‍याक हार्स्‍त कांळ्‍सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ईद कारण आक अब्राहम से अंदुर, “ई दासी अक पार उन सांगुळ तेगुकोम: यतिकी ई दासी अन पार नान पार इसहाक उन सांगुळ हिस्सेदार आगतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ईद मात अब्राहम उक तान पार उन कारण बुरा हत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","आग परमेश्वर अब्राहम से अंदुन, “आ पार अदिक तान दासी अन कारण नीनी बुरा हतबाळुल; जो मात सारा नीन से अनतार, अदरी मान्‍स, यतिकी जो नीन वंश अनकु आदान अद इसहाक से अच नळदीत. ");
INSERT INTO hoy_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","दासी इन पार से भी ना ऊंद जाती पैदा माळाईन इदुरसाटी आव नीन वंश हुन.” ");
INSERT INTO hoy_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","इदुरसाटी अब्राहम व्हातर्‍या जल्‍दी यदकु रोट्‍टी अदिक नीर देल तुमकु तोगुल इन झ्‍वारा भी हाजिरा अदिक आकिन पार उक कोट्‍टुन, अदिक आकी अल टु होगली हेळदुन हाजिरा अल टु होट्‍ट बुट्‍टुर अदिक बेर्शेबा अन आळी दा भटकुसतेला ईत्‍तुर. ");
INSERT INTO hoy_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","याग झ्‍वारा अन नीर खतम आगेत, आग आक पार उक झाळी इन ल्‍यालमा बिट बुट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","अदिक आक तीर इन थप्पा अन दुरी मा होगकु आऊन दी बाँय माळकु कुर्तोदुर, “यतिकी आक तान पार उन वर्लोद अदिक आऊन परेशानी नोळ ईला सकोर.” अदिक अल कुर्तकु उच आक वर्लली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमेश्वर आ पार उन वर्लोद केळदुन अदिक स्‍वर्ग टु परमेश्वर उन दूत हाजिरा से केळदुर, “हे हाजिरा, येन आत नी? अंजबाळ; यतिकी परमेश्वर पार उन वर्लोद केळ कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ईग येळ, तान पार उक नेगु, यतिकी ना आऊन से ऊंद धोळ्‍द जाती पैदा माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ईद अनतेला परमेश्वर हाजिरा अक ऊंद भाय तोर्सदुन, आक आ भाय दा टु नीर तेगुकु तान पार उक कुळ्‍सदुर. ");
INSERT INTO hoy_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","आव पार परमेश्वर उन अनुग्रह देल धोड्‍डेव आगेदुन अदिक आव पारान हेसुर इन सुनसान जागा दा ईरतोगोन; अदिक धनुषधारी बन्‍सेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","आव पारान हेसुर इन आळी दा ईरतोगोन; अदिक आऊन मोय आऊन साटी मिस्त्र द्‍याश टु ऊंद आर्त बेळसुसदुर. ");
INSERT INTO hoy_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","आ दिनगोळ दा हींग आत कि अबीमेलेक तान सेनापती पीकोल उक सांगुळ हुडुकु अब्राहम से अनली कुरतुन, “जो येनारा नी माळत्‍या अदुर दा परमेश्वर नीन सांगुळ ईरतान; ");
INSERT INTO hoy_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","इदुरसाटी नी परमेश्वर उन कसम तिन कि नी नानी, नान वंशगोळ से अदिक नान भावी पीढ़ीगोळ से यागलु ध्वाका माळतीदील, लेकीन नी नाम मा दया माळेत ह्‍यांग ना नीन से माळीदिन.” ");
INSERT INTO hoy_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अदिक अब्राहम अंदुन, “ना नीन से वादा माळतीन.” ");
INSERT INTO hoy_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","अदिक अब्राहम अबीमेलेक उक ऊंद भाय इन बारा दा जो अबीमेलेक उन दासगोळ ताकत देल ताकोम कोंडीदुर, उलाहना कोट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","आग अबीमेलेक अंदुन, “ना जानसालीन कि याव ईद क्‍याल्‍सा माळ्‍यान; अदिक नी भी नानी हेळीदिल, अदिक न ईदुर बारा दा ना ईदुर पयला केळीन.” ");
INSERT INTO hoy_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","आग अब्राहम मर्र-म्यांडा, अदिक वस्‍ता-गोसी अबीमेलेक उक कोट्‍टुन; अदिक आंदुर येढ्‍ढु मुंदुर आपस दा वादा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहम येळ म्यांडा अन्द पाड्डागोळी झुंड टु अलग माळकु ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","आग अबीमेलेक अब्राहम से केळदुन, “ईव येळ पाड्डागोळ्‍द, जो नी अलग ईट्‍या, इऊर येन मतलब आद?” ");
INSERT INTO hoy_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","अब्राहम अंदुन, “नी ईव येळ पाड्डागोळी हुडु ताकी ईद नाम बीच गवाह ईत्‍तीत, कि ईद भाय ना अगळीन.” ");
INSERT INTO hoy_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","आंदुर येढ्‍ढु मुंदुर जो आ जागा मा आपस दा वादा माळीदुर, ईदा कारण अदुर्द हेसुर बेर्शेबा बीत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","याग आंदुर बेर्शेबा दा वादा माळदुर, आग अबीमेलेक अदिक आऊन सेनापती पीकोल, येदकु पलिश्तीगोळ द्‍याश दा होटोदुर. ");
INSERT INTO hoy_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","बाक अब्राहम बेर्शेबा दा झाऊ उन ऊंद मार्र हचदुन, अदिक अल यहोवा जो सनातन परमेश्वर आन, आराधना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अब्राहम पलिश्तीगोळ द्‍याश दा हापाळ दिन ताका परदेशी आगकु ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","थ्‍वाळासा समय इन बाद्‍दा, परमेश्वर अब्राहम उन परीक्षा ताकोंडुन, परमेश्वर आऊन से अंदुन, “हे अब्राहम!” अब्राहम उत्‍तर कोट्‍टुन, “हे प्रभु! येन आग्या आद, ना ईल आईन.” ");
INSERT INTO hoy_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","परमेश्वर अंदुन, “तान पार उक मतलब तान धोळ पार इसहाक उक, यार से नी प्रेम ईटत्या, सांगुळ हुडुकु मोरिय्‍याह द्‍याश दा होटोग, अदिक अल आऊक ऊंद पहाळी इन म्‍याकुच जो ना नीनी हेळाईन होमबली माळकु येर्स.” ");
INSERT INTO hoy_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","दुसरा दिशी अब्राहम व्हातर्‍या जल्‍दी येदकु तान गधा मा हुल्ली कसुसकु तान येढ्‍ढ सेवकगोळ, अदिक तान पार इसहाक उक सांगुळ हुळदुन, अदिक होमबली साटी हुळ्ली सीळदुन; आग होटकु आ जागा अन दी होदुन, यदुर चर्चा परमेश्वर आऊन से माळीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तीसरा दिशी अब्राहम कण्‍ण नेगुकु आ जागा अक दूर टु नोळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","अदिक अब्राहम तान सेवकगोळ से अंदुन, “गधा अन हाती ईल्या थाम्‍सकु ईरी; ईव पार अदिक ना अल ताका होगकु, अदिक नमस्‍कार माळकु, बाक नीम हाती वापस बंदेव.” ");
INSERT INTO hoy_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","अब्राहम होमबली इन साटी तैयार माळदव हुळ्‍लीगोळ इसहाक उन कय दा हुळसुस बुट्‍टुन अदिक खुद बेक्‍की अदिक कत्ती हुळदुन, अदिक येढ्‍ढु मुंदुर सांगुळ नळु कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाक तान आप्‍प अब्राहम से अंदुन, “हे नान आप्‍प?” आव अंदुन, “हे नान पारा, येन मात आद?” आव अंदुन, “नोळ, बेक्‍की अदिक हुळ्ली रा आव; लेकीन होमबली साटी म्यांडा अन्द पाड्डा येल आद?” ");
INSERT INTO hoy_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहम अंदुन, “हे नान पारा, परमेश्वर होमबली इन म्यांडा अन उपाय खुद अच माळ्‍यान.” अदिक आंदुर येढ्‍ढु मुंदुर सांगुळ सांगुळ मुंद नळुतेला होदुर. ");
INSERT INTO hoy_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","याग आंदुर जागा मा पोहचुसदुर, यदरी परमेश्वर आऊक हेळीदुन, आग अब्राहम अल वेदी माळकु हुळ्‍लीगोळ इक नीवळुस नीवळुसकु ईटदुन, अदिक तान पार इसहाक उक कटकु वेदी मा ईटदव हुळ्‍लीगोळ म्‍याकुच ईट बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","बाक अब्राहम कय वाळुसकु कत्ती अक हुळदुन कि तान पार उक बली माळुल. ");
INSERT INTO hoy_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","आग यहोवा अन दूत स्‍वर्ग टु कारूकु अंदुन, “हे अब्राहम, हे अब्राहम!” अब्राहम अंदुन, “नोळ, ना ईल आईन.” ");
INSERT INTO hoy_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","यहोवा अंदुन, “आ पार उन मा कय नेगुबाळ, अदिक आऊक येनु माळबाळ; ईग नानी मालुम आगेग्‍याद कि नी परमेश्वर उन भय मान्‍सत्‍या, यतिकी नी नान साटी तान ऊंदलौता पार उक भी बलिदान माळोर साटी तैयार आगेग्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","आग अब्राहम कण्‍ण नेगदुन, अदिक येन नोळदुन, कि आऊन हिंद ऊंद म्यांडा तान सींगगोळ से ऊंद झाळी दा फसुसकु आद; अत: अब्राहम होगकु आ म्यांडा अक हुळदुन, अदिक तान पार उन जागा मा होमबली माळकु येर्सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","अब्राहम आ जागा अन हेसुर यहोवा यिरे ईटदुन, मतलब यहोवा उपाय माळावाळा, इदुरसाटी ईंद भी ईद अनकु आगतद, “यहोवा अन पहाळी मा उपाय माळकु आदीत.” ");
INSERT INTO hoy_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","बाक दुसरा घन यहोवा अन दूत स्‍वर्ग टु अब्राहम उक कारूकु अंदुन, ");
INSERT INTO hoy_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","यहोवा अन ईद वाणी आद, “कि ना तांद अच कसम तिनतीन कि नी जो क्‍याल्‍सा माळ्‍या तान पार, बल्‍की तान ऊंदलौता पार उक भी, बिटीदिल; ");
INSERT INTO hoy_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ईद कारण ना सहीदा नीनी आशीष कोळाईन; अदिक सहीदा नीन वंश इक तारागण, अदिक समुद्र तट इन रेत इन कनगोळ घाई अनगिनत माळाईन, अदिक नीन वंश तान दुश्‍मनगोळ नगर इन अधिकारी आदार; ");
INSERT INTO hoy_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","अदिक पृथ्‍वी इन सप्‍पा जातीगोळ नीन वंश इन द्वारा नान से आशीर्वाद प्राप्त माळ्‍यार: यतिकी नी नांद आग्या मान्सकु अदुर पालन माळ्द.” ");
INSERT INTO hoy_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","आग अब्राहम तान सेवक उन हाती वापस बंदुन, अदिक आंदुर सप्‍पा बेर्शेबा अक सांगुळ सांगुळ होदुर; अदिक अब्राहम बेर्शेबा दा ईरली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ई मातगोळ बाद्‍दा हिंग आत कि अब्राहम उक ईद समाचार सीक्‍त, “मिल्‍का भी मोय बनसेदुर; आक नीन वार्ट नाहोर उन साटी पार उक जनम कोटार. ");
INSERT INTO hoy_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","धोळ पार ऊस, आऊन वार्ट बुज, कमूएल आराम उन आप्‍प, ");
INSERT INTO hoy_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","बाक केसेद, हाजो, पिलदाश, यिदलाफ अदिक बतूएल.” ");
INSERT INTO hoy_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बतूएल रिबका अन आप्‍प आदुन. अब्राहम उन वार्ट नाहोर टु मिल्‍का देल ईंदुर येळ पार पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नाहोर उन रखैल रियूमाह अन भी ईंदुर पार आदुर: तेबाह, गाहम, ताहाश अदिक माकाह. ");
INSERT INTO hoy_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा रा ऊंद सौ सताईस वर्ष ताका होदुर; अदिक याग सारा अन ईट ऊमर आत; ");
INSERT INTO hoy_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","आग आक किर्यतर्बा दा सोतोदुर. ईद रा कनान द्‍याश दा आद, अदिक इदरी हेब्रोन भी अनकु आगतद. इदुरसाटी अब्राहम सारा अन साटी वर्लली अल होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","आग अब्राहम लाश इन हाती टु येदकु हित्‍तीगोळ से अनली कुरतुन, ");
INSERT INTO hoy_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ना बीच दा पावना अदिक परदेशी आईन; नानी तान बीच दा मरघट साटी हिंग जागा कोळी जो नान खुद इन आगुल, ताकी ना तान सोत्‍तकु हिंग्स उक नळ्‍स सकाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हित्‍ती अन लॉकुर अब्राहम से अंदुर, ");
INSERT INTO hoy_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“हे नावम प्रभु, नाम्‍द केळ; नी नाम बीच दा धोड्‍डेव प्रधान आय. नाम कब्र दा टु यदरी नी चाहास्‍या अदुर्दा तान सोत्‍तुर इक नळ्‍स; नाम दा टु याऊ नीनी तान कब्र ताकोमोर से रोक्‍सतीदिल, कि तान सोत्‍तुर इक अदुर्दा नळ्‍स सकतीदिल.” ");
INSERT INTO hoy_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","आग अब्राहम येदकु नीदुरदुन, अदिक हित्‍तीगोळ मुंद, जो आ द्‍याश इन ईरावाळेर ईरोर, नमस्‍कार माळकु अनली कुरतुन, ");
INSERT INTO hoy_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“अगर नीम्‍द ईद इच्‍छा आद कि ना तान सोत्‍तुर इक नळ्सकु तान कण्‍ण देल दुर माळाईन, रा नांद प्रार्थना आद, कि सोहर उन पार एप्रोन से नान साटी विनती माळी, ");
INSERT INTO hoy_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","कि आव तान मकपेलावाळा गुफा, जो आऊन भूमी इन सीमा मा आद; अदुर्द पुरा किमत ताकोमकु नानी कोट बुळ, कि अद नीम बीच दा मरघट साटी नांद खुद इन भूमी आगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एप्रोन रा हित्तीयो अन बीच दा अल कुर्तकु ईरोन, इदुरसाटी यास हित्‍ती आऊन नगर इन फाटक टु आगकु अंदर होगतोगोर, आंदुर मुंद एप्रोन अब्राहम से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“हे नान प्रभु; नांद मात केळ; ना नीनी आ गुफा केई सांगुळ नान संबंधीगोळ मुंद कोळेतीन, नी ईदुर दा तान हिंग्‍स उक नळ्‍स बुळ.” ");
INSERT INTO hoy_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","अब्राहम मात आ लॉकुरी बांगकु नमस्‍कार माळदुन ");
INSERT INTO hoy_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","अदिक लॉकुर्द केळतेला अच एप्रोन से अंदुन, “नांद मात केळ, नीनी ना आ केई इंद किमत कोळाईन, नी ईदरी स्‍वीकार माळकोम ताकी ना तान हिंग्‍स उक नळ्‍स सकाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ईद केळतेला अच एप्रोन अब्राहम से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“हे नान प्रभु, नांद मात केळ; ई केई इन किमत सिर्फ नाक सौ शेकेल चांदी इन सिक्‍का आद, लेकीन ईद नीन साटी अदिक नान साटी येनु हैलेच, नी तान हिंग्‍स उक मुण्‍ण कोटबुळ.” ");
INSERT INTO hoy_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहम एप्रोन इन मात मान्‍सकु आऊक आस किमत इन चांदी तौलुसकु कोट्‍टुन, यास आव हित्‍तीगोळ मुंद अनतेला केळीदुन, मतलब नाक सौ ईत्‍ता शेकेल जो व्‍यापारीगोळ दा नळुतोगव. ");
INSERT INTO hoy_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","इदुरसाटी एप्रोन उन अद केई अदिक गुफा, जो मकपेला दा मम्रे अन हाती ईरोद, अदिक केई इन सप्‍पा मार्र जो अदुर्दा अदिक अदुर नाकु दी सीमा अन अंदर ईरव. ");
INSERT INTO hoy_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","सप्‍पा अब्राहम उक कोट्‍ट बुट्‍टुन, यास भी मुंदुर हित्‍ती इन शहर इन फाटक मा जमा आगीदुर, आ सप्‍पा मुंदुर मुंद अद संपत्‍ती अब्राहम उन अधिकार दा पक्‍का रीति देल होट्‍ठबत्त. ");
INSERT INTO hoy_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","अदुर बाद्‍दा अब्राहम तान हिंग्‍स सारा अक मकपेला अन केई इन गुफा दा नळ्‍स कोंडुन, जो कनान द्‍याश इन मम्रे, मतलब हेब्रोन इन हाती ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ई प्रकार हित्‍तीगोळ द्वारा अद केई अदिक अदुर दाकळोद गुफा मरघट इन रूप दा अब्राहम उन अधिकार दा कोटकु आत. ");
INSERT INTO hoy_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहम हापाळ बाट्‍ट आगेगीदुन, अदिक यहोवा आऊक सप्‍पा प्रकार देल आशीषित माळीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहम तान पुराना सेवक से, जो मान्‍ना अन अदिक पुरा संपत्‍ती इंद देखभाल माळतोगोन, अंदुन, “नी तान कय नान जांघ मा ईट. ");
INSERT INTO hoy_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","अदिक नान से आकाश अदिक पृथ्‍वी अन परमेश्वर यहोवा अन ई बारा दा कसम तीन, कि नी नान पार उन साटी कनानीगोळ्द पोरगोळ दा टु, यार बीच दा ना ईरतीन, यारीकु तरतीदील. ");
INSERT INTO hoy_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","लेकीन नी नान द्‍याश दा नानोर अच घराना हाती होगकु नान पार इसहाक उन साटी ऊंद हिंग्‍स तन कोट्या.” ");
INSERT INTO hoy_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","दास आऊन से अंदुन, “आ स्‍थिती दा ना येन माळाईन, याग आ आर्त ई द्‍याश दा बरोद ईला चाहस्यार रा; येन ना नीन पार उक आ द्‍याश दा वोयाईन, येल टु नी बंद्या?” ");
INSERT INTO hoy_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ईदुर मा अब्राहम अंदुन, “नी नान पार उक अल यागलु ओयबाळेत.” ");
INSERT INTO hoy_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","यहोवा जो स्‍वर्ग इन परमेश्वर आन, याव नानी नान आप्‍प उन मान्‍या टु अदिक नांद जनम स्थान टु तनकु नान से कसम तीनकु अंदुन कि “ना ईद द्‍याश नीन वंश इक कोळाईन; आवा तान दूत नींद मुंद मुंद कळ्‍यान, कि नी नान पार उन साटी अल टु ऊंद आर्त तंद्या. ");
INSERT INTO hoy_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","अगर पोर नीन सांगुळ बरोर साटी मना माळतार, आग नी नान कसम देल मुक्त आगेद्‍या, लेकीन ध्‍यान ईटेत कि नी नान पार उक अल वापस ओयबाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","इदुरसाटी आ सेवक तान स्वामी अब्राहम उन जांघ इन ल्‍यालमा तान कय ईटदुन अदिक ई बारा दा कसम तीनकु अब्राहम से वादा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","आग आ सेवक तान स्वामी अन झुंड दा टु हत्‍त ऊँटगोळ हुळदुन अदिक अऊर मा तान स्वामी इन दी टु अलग अलग सामान कटदुन अदिक नाहोर उन गृह नगर उत्‍तर-पश्‍चिम मेसोपोतामिया इन दी होगली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","नगर इन व्‍हार्या पोहचुस्कु आव ऊँटगोळी भाय इन हाती कुर्सबुट्‍टुन; ईद द्‍यावगा अन समय ईरोद. ईदा समय आर्तेर नीर तुमली व्‍हार्या बरतोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","आग सेवक प्रार्थना माळदुन, “यहोवा, नान स्वामी अब्राहम उन परमेश्वर, नान क्‍याल्‍सा अक सफल माळ अदिक नान स्वामी अब्राहम मा दया माळ. ");
INSERT INTO hoy_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","नोळ, ना नीर इन सोता अन हाती नीदुरकु आईन; अदिक नगरवासी इन पोरगोळ नीर तुमोर साटी होळतार. ");
INSERT INTO hoy_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","इदुरसाटी आगगोळ कि या पोर इन से ना अनाईन, ‘तान माळका नान दी बांग्‍स, कि ना कुडाईन,’ अदिक आक अनुल, ‘हुडु, कुडुकोम, बाद्‍दा ना नीन ऊँटगोळी भी कुळसाईन,’ इक आका आगुल यारी नी तान दास इसहाक उन साटी ठहरूस्‍या; ईदा रीति देल ना जान्‍स कोमाईन कि नी नान स्वामी मा करूणा माळ्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ईदुर पयले कि आऊन प्रार्थना खतम आगाईत, रिबका नगर इन व्‍हार्या तान खांदा मा माळका हुडुकु नीर तुमोर साटी बंदुर, आक मिल्‍का अन पार बतूएल उन पोर ईरोर अदिक मिलकाह अब्राहम उन वार्ट नाहोर उन हिंग्‍स ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","रिबका हापाळ सुंदर ईरोर, कुवारा ईरोर; ईगासताका यातोदु मंळसा अन बाय ईला नोळीदुर, आक ल्‍यालमा सोता मा होदुर, तान माळका नीर देल तुमदुर अदिक बाक म्‍याकुच बंदुर. ");
INSERT INTO hoy_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","आग आ दास आकिन से भेंट माळोर साटी ओळदुन, अदिक आकिन से अंदुन, “तान माळका दा टु थ्‍वाळासा नीर नानी कुळ्‍सकोम.” ");
INSERT INTO hoy_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","आक अंदुर, “हे नान प्रभु, हुडु, कुडुकोम,” अदिक आक फुरताई देल माळका ईळ्सकु कय दा हुडुकु आऊक नीर कुळ्स कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","याग आक आऊक नीर कुळ्स कोंडुर, आग आक अंदुर, “ना नीन ऊँटगोळ साटी नीर तरतीन, यागासताका अव पुरा संतुष्ट आगेगालव.” ");
INSERT INTO hoy_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","इदुरसाटी रिबका झट से माळका अन नीर ऊँटगोळ साटी माळ्द धोनी दा पलटुसदुर, आग आक अदिक नीर तरोर साटी भाय दी वोळदुर अदिक आक सप्पा ऊँटगोळी नीर कुळ्सदुर. ");
INSERT INTO hoy_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","नौकर आऊक सुंगा मुंगा ध्यान देल नोळदुन. आव तय माळोद चाहासोन कि यहोवा शायद मात मान्स कोंडुन कि ईला. ");
INSERT INTO hoy_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","याग ऊँटगोळ नीर कुडु कोंडव आग आ मंळसा आरदा त्वारा व्हान्ना अन ऊंद नतनी तेगुकु आकी कोट्टुन, अदिक हत्त त्वारा व्हान्ना अन बांगळा आकिन कय दा हाकसुसदुन; ");
INSERT INTO hoy_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","अदिक केळदुन, “नी यार पोर हुय? ईद नानी हेळ. येन नीन आप्प उन मान्या नाम ईरोर साटी जागा आद?” ");
INSERT INTO hoy_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","आक उत्तर कोट्टुर, “ना रा नाहोर उन पैदा माळ्द मिल्‍का अन पार बतूएल उन पोर हुईन.” ");
INSERT INTO hoy_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","बाक आक आऊन से अंदुर, “नाम मान्या काड्डा अदिक चारा हापाळ आद, अदिक थामसोर साटी जागा भी आद.” ");
INSERT INTO hoy_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","आग आ मंळसा ताल्ला बांग्सकु यहोवा अक नमस्कार माळकु अंदुन, ");
INSERT INTO hoy_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“धन्य आय नान स्वामी अब्राहम उन परमेश्वर यहोवा, याव तान करूणा अदिक सच्चाई इक नान स्वामी मा टु हटुसीदिल: यहोवा नानी ठीक हादी मा नळ्सकु नान स्वामी इन वार्टुर मान्या पोहचुस बुट्टुन.” ");
INSERT INTO hoy_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","आग आ पोर ओळकु तान मोय इक ई घटना अन सप्पा हाल हेळ बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","आग लाबान जो रिबका अन वार्ट ईरोन, व्हार्या भाय इन हाती आ मंळसा अन दी ओळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","अदिक हिंग आत कि याग आव अद नतनी अदिक तान आकतींग रिबका अन कय दा अव बाळा भी नोळदुन, अदिक आकिन ईद मात भी केळदुन कि आ मंळसा नान से हिंग मातगोळ अंदुन; आग आव आ मंळसा अन हाती होदुन; अदिक येन नोळदुन, कि आव सोता अन हाती ऊँटगोळ हाती नीदुरकु ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","आव अंदुन, “हे यहोवा अन दी टु धन्य मंळसा अंदर बर नी यती व्हार्या नीदुरकु आय? ना मान्ना अक, अदिक ऊँटगोळ साटी भी जागा तैयार माळीन.” ");
INSERT INTO hoy_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","दुर आ मंळसा मान्या बुळ्क होदुन; अदिक लाबान ऊँटगोळ काठिगोळी खोल्सकु काड्डा अदिक चारा कोट्टुन; अदिक आऊन अदिक आऊन साथीगोळ काल तोळुली नीर कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","आग अब्राहम उन दास उन मुंद जलपान साटी येनारा ईटकु आत; लेकीन आव अंदुन “ना यागासताका तान बातणी अन कोमालीन, आगासताका येनु तीनतीदिल.” लाबान अंदुन, “अन कोम.” ");
INSERT INTO hoy_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","आग सेवक अंदुन, “ना रा अब्राहम उन दास हुईन. ");
INSERT INTO hoy_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","यहोवा नान स्वामी इक हापाळ आशीष कोटान; इदुरसाटी आव महान धनवान मंळसा आगेग्यान; अदिक आव आऊक मर्र-म्यांडा, गोसी, व्हान्ना, पैस्या, दास-दासीगीतेर, ऊँट अदिक गधागोळ कोटान. ");
INSERT INTO hoy_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","अदिक नान स्वामी इन हिंग्स सारा अक हाळामुंड इन समय दा ऊंद पार पैदा आग्यान; अदिक आ पार उक अब्राहम तान सप्पा येनारा कोट्ट बुटान. ");
INSERT INTO hoy_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","नान स्वामी नानी ईद कसम कोटान, कि ‘ना आऊन पार उन साटी कनानीगोळ पोर दा टु यार द्याश दा आव ईर तोगोन, यातारा भी आर्त इक तरबाळेत. ");
INSERT INTO hoy_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ना आऊन आप्प उन मान्या, अदिक परिवार इन लॉकुर हाती होगकु आऊन पार उन साटी ऊंद आर्त तराईन.’ ");
INSERT INTO hoy_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","आग ना तान स्वामी से अंदीन, ‘अगर आ आर्त नान हिंद बरतीदील.’ ");
INSERT INTO hoy_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","आग आव नान से अंदुन, ‘यहोवा, यार मुंद ना नळुतेला बंदीन, आव नीन सांगुळ तान दूत कळुकु नीन यात्रा अक सफल माळ्यान; अदिक नी नान परिवार, अदिक नान आप्प उन घराना दा टु नान पार उन साटी ऊंद आर्त तर सक्या. ");
INSERT INTO hoy_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","नी आग अच नान कसम देल मुक्त आद्या, याग नी नान परिवार इन लॉकुर हाती पोहचुस्या; अदिक अगर आंदुर नीनी यातोरारा आर्त कोळतीदील, रा नी नान कसम दा टु बिटोद्या.’” ");
INSERT INTO hoy_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","इदुरसाटी ईंद ना आ भाय इन हाती होगकु अनली कुरतीन, हे नान स्वामी अब्राहम उन परमेश्वर यहोवा अगर नी नान ई यात्रा अक सफल माळत्या; ");
INSERT INTO hoy_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","रा नोळ ना नीर इन भाय इन हाती निदुरकु आईन; अदिक हिंग आगुल, कि जो पोर नीर तुमली बंदार, अदिक ना आकिन अनाईन, “तान माळका दा टु नानी थ्वाळासा नीर कुळ्स,” ");
INSERT INTO hoy_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","अदिक आक नान से अनुल, “कुडु कोम, अदिक ना नीन ऊँटगोळ कुडोर साटी भी नीर तुमकु कोळाईन,” आक आका आर्त ईरूल यारी नी नान स्वामी इन पार उन साटी ठहरूस्या. ");
INSERT INTO hoy_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ना मन इन मन दा ईद अनीन अच, कि नोळ रिबका ताल्ला मा माळका हुडुकु बंदुर; बाक आक सोता अन हाती ईळकु तुमली कुरतुर. ना आकिन से अंदीन, “नानी नीर कुळ्स. ");
INSERT INTO hoy_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","अदिक आक जल्दी से तान माळका अक ताल्ला मा टु ईळ्सकु अंदुर, ‘ईका, कुडुकोम, हिंद ना नीन ऊँटगोळी भी कुळसाईन,’ ई प्रकार ना कुळदीन, अदिक आक ऊँटगोळी भी कुळ्सदुर. ");
INSERT INTO hoy_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","आग ना आकिन से केळदिन, नी यार पोर हुय? अदिक आक अंदुर, ना रा नाहोर उन पैदा माळ्द मिल्‍का अन पार बतूएल उन पोर हुईन,” “आग ना आकिन मुग्‍ग दा नतनी, अदिक आकिन कय दा अव बाळा हाकसुसदीन. ");
INSERT INTO hoy_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","बाक ना ताल्ला बांग्सकु यहोवा अक नमस्कार माळदीन, अदिक तान स्वामी अब्राहम उन परमेश्वर यहोवा अक धन्य अंदीन, यतिकी आव नानी वळ्लीद हादी देल पोहचुसदुन कि ना तान स्वामी अन पार उन साटी आऊन रीस्तेदार उन पोर इक ओयाईन. ");
INSERT INTO hoy_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ईग हेळ कि नी येन माळ्या? येन नी नान स्वामी मा दया माळ्या अदिक तान पोर आऊक कोट्या? या नी तान पोर इक कोळोर साटी मना माळ्या? नानी हेळ, यदुर देल ना ईद समसाईन कि नानी येन माळोद आद.” ");
INSERT INTO hoy_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","आग लाबान अदिक बतूएल उत्तर कोट्टुर, “ईद मात यहोवा अन दी टु आग्याद; इदुरसाटी नाव लॉकुर नीन से न रा भला अन सकतेव अदिक न बुरा. ");
INSERT INTO hoy_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","नोळ, रिबका नीन मुंद आर, आकी ओय, अदिक आक यहोवा अन वचन इन अनुसार, नीन स्वामी इन पार उन हिंग्स आगेगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","आंदुर्द ईद मात केळकु, अब्राहम उन दास जमीन मा बिदकु यहोवा अक नमस्कार माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","आग आव रिबका अक अव भेंटगोळ कोट्टुन जो आव सांगुळ तंदीदुन, आव रिबका अक व्हान्ना अदिक चांदी ईनव ईसरा कोट्टुन अदिक हापाळ वळ्लेव कपळा कोट्टुन, आव आकिन वार्ट अदिक आकिन मोय इक किमती भेंटगोळ कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","दास अदिक आऊन सांगुळ इनोर मंळसा अल थाम्सदुर अदिक तिंदुर कुळदुर, अल आंदुर ईळ्लक तीम ईत्तुर, आंदुर दुसरा दिशी व्हातर्या यद्दुर अदिक अंदुर “ईग नाव तान स्वामी इन हाती होदेव.” ");
INSERT INTO hoy_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","रिबका अन मोय अदिक वार्ट अंदुन, “रिबका अक नाम लॉकुर हाती अदिक येनारा दिन ईरगोळी, आकी हत्त दिन ताका नाम हाती अदिक ईरगोळी, अदुर बाद्दा आक होग सकतार.” ");
INSERT INTO hoy_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","लेकीन दास आंदुर से अंदुन, “नान से हादी कायसुसबाळी, यहोवा नान यात्रा सफल माळ्यान, ईग नानी तान स्वामी इन हाती होगगोळी.” ");
INSERT INTO hoy_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","रिबका अन वार्ट अदिक आकिन मोय अंदुर, “नाव लॉकुर रिबका अक कारदेव अदिक आकिन से केळेव कि आक येन चाहसतार?” ");
INSERT INTO hoy_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","आंदुर रिबका अक कारदुर अदिक आकिन से अंदुर, “येन नी ई मंळसा अन सांगुळ ईग होगोद चाहसत्या?” रिबका अंदुर, “हव, ना होगाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","इदुरसाटी आंदुर रिबका अक अब्राहम उन दास अदिक आऊन सांगुळ आऊन मंळसागोळ सांगुळ होग गोट्टुर, रिबका अन दासी भी आंदुर सांगुळ होदुर. ");
INSERT INTO hoy_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","अदिक आंदुर रिबका अक आशीर्वाद कोटकु अंदुर, “हे नामोर आकतींग, नी हजारो लाखगोळ्द आदिमाता आगुल, अदिक नीन वंश तान दुश्मनगोळ्द नगर इन अधिकारी आगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","आग रिबका तान सहेलीगोळ सांगुळ होदुर; अदिक ऊँट मा येरकु आ मंळसा अन हिंद आदुर, ई प्रकार आ दास रिबका अक हुडुकु नळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","इसहाक जो दक्षिण द्याश दा ईरतोगोन, लहैरोई हेसुर इन भाय टु आगकु सुनसान प्रदेश दा होटकु बरतोगोन. ");
INSERT INTO hoy_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","द्यावगा अन वती आव मैदान दा ध्यान माळोर साटी होटीदुन; अदिक आव कण्ण नेगुकु येन नोळदुन, कि ऊँटगोळ नळुकु बरेत्याव. ");
INSERT INTO hoy_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबका भी कण्‍ण नेगुकु इसहाक उक नोळदुर, अदिक नोळतेला अच ऊँटगोळ मा टु ईळदोदुर. ");
INSERT INTO hoy_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","आग आक तान दास से केळदुर, “जो मंळसा मैदान मा नाम दी बरेत्यान, आव याव हुन?” दास अंदुन, “आव रा नान स्वामी हुन.” आग रिबका सेरग्या हुडुकु तान बाय मा ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","दास इसहाक से तान सांगुळ आग्द घटना अन वर्णन माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","आग इसहाक रिबका अक तान मोय सारा अन ड्यारा दा तंदुन, अदिक आकिन से मदा माळकु आकिन से प्यार माळदुन. ई प्रकार इसहाक उक मोय इन मृत्यु उन बाद्दा शांती प्राप्त आत. ");
INSERT INTO hoy_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","आग अब्राहम मात्त ऊंद आर्त से मदा माळदुन यार्द हेसुर कतूरा ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","आकिन से जिम्रान, योक्षान, मदना, मिद्यान, यिशबाक, अदिक शूह पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान देल शबा अदिक ददान पैदा आदुर; अदिक ददान उन वंश दा अश्‍शूरी, लतूशी, अदिक लुम्‍मी लॉकुर आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यान उन पार एपा, एपेर, हनोक, अबीदा, अदिक एल्‍दा आदुर, ईंदुर सप्‍पा कतूरा अन चिकोर आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","इसहाक उक रा अब्राहम तान सप्‍पा येनारा कोट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","लेकीन तान रखैल उन चिकोरी, थ्‍वाळा थ्‍वाळा कोटकु तान जीत्‍ता जीवन दा तान पार इसहाक उन हात्‍ती टु पूर्व दिशा दा कळु कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहम उन पुरा ऊमर ऊंद सौ पचहत्तर वर्ष इन आत. ");
INSERT INTO hoy_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","अब्राहम उन दीर्घायु आगा कारण मतलब पुरा हाळाबाट अवस्‍था दा जीव बीटोत; अदिक आव तान लॉकुर दा होगकु सीकेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","आऊन पार इसहाक अदिक इश्‍माएल, हित्ती सोहर उन पार एप्रोन इन मम्रे अन्द पूर्व दिशा अन्द जागा दा, जो मकपेला अन गुफा ईरोद, अल आऊक मुण्‍ण कोट्‍टुर; ");
INSERT INTO hoy_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","मतलब जो जागा अब्राहम हित्‍तीगोळ हाती टु कोंडीदुन; अल्‍या अब्राहम, अदिक आऊन हिंग्‍स सारा, येढ्‍ढु मुंदरी मुण्‍ण कोटकु आत. ");
INSERT INTO hoy_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहम उन सोत्‍तुर बाद्‍दा, परमेश्वर आऊन पार इसहाक उक आशीष कोट्‍टुन, जो आ समय लहैरोई हेसुर इन भाँय इन हात्ती ईरतोगोन. ");
INSERT INTO hoy_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","अब्राहम उन पार इश्‍माएल जो सारा अन मिस्त्री दासी हाजिरा देल पैदा आगीदुन, आऊन ईद वंशावली आद. ");
INSERT INTO hoy_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्‍माएल उन चिकोर्द हेसुर अदिक वंशावली ईद हुन: मतलब इश्‍माएल उन धोळ पार नबायोत, बाक केदार, अदबएल, मिबसाम, ");
INSERT INTO hoy_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्‍मा, दूमा, मस्सा, ");
INSERT INTO hoy_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश, अदिक केदमा. ");
INSERT INTO hoy_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","इश्‍माएल उन चिकोर ईंदुरा आदुर, अदिक ईंदुरवा हेसुर इन अनुसार ईंदुर ऊरानव, अदिक छावनीगोळ हेसुर भी बीद्‍दव; अदिक ईंदुर अच हन्‍नेळ मुंदुर तान तान कुल इन प्रधान आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्‍माएल उन पुरा ऊमर ऊंद सौ सैंतीस वर्ष इन आत; आग आव सोतोदुन, अदिक तान सोतकु पुर्वजगोळ दा होगकु सीकेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","अदिक आऊन वंश हवीला से शूर ताका, जो मिस्त्र द्याश इन पूर्व अश्शूर इन हादी मा आद, बसुसेदुर; अदिक आदुर्द भाग आदुर्द सप्‍पा वार्टुर न्याड्या दा बिदकु आद. ");
INSERT INTO hoy_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहम उन पार इसहाक उन वंशावली ईद हुन; अब्राहम से इसहाक पैदा आदुन; ");
INSERT INTO hoy_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","अदिक इसहाक चालीस वर्ष इनव आगकु रिबका अक, जो पद्‍दनराम इन वासी, अरामी बतूएल इन पोर, अदिक अरामी वंशीय लाबान इन आकतींग ईरोर, मदा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाक उन हिंग्‍स रा बाँझ ईरोर इदुरसाटी आव तान हिंग्‍स उन दी टु यहोवा से विनती माळदुन; अदिक आऊन विनती केळदुन, ई प्रकार आऊन हिंग्‍स रिबका गर्भवती ईत्‍तुर. ");
INSERT INTO hoy_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","चिकोर आकिन गर्भ दा आबुर दाबुर इक धक्‍का कोळतेला ईरतोगोर. आग रिबका अंदुर, “ईद येन आगेत्‍याद नान सांगुळ?” अदिक आक यहोवा से केळली होदुर. ");
INSERT INTO hoy_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","यहोवा आकिन से अंदुन, “नीन गर्भ दा येढ्‍ढ जातीगोळ आव, आंदुर दा टु येढ्‍ढ समूह अन लॉकुर होटकु अलग आदार; ऊंद समूह अन लॉकुर दुसरा से येक्‍कुल ताकतवर आदार, अदिक धोड्‍डेव श्‍याण्णेव उन स्यावा माळ्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","याग आकिन दुख इन समय बत्‍त, रा आकिन गर्भ दा जुळवा चिकोर ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","जो पयला पार आदुन आव क्याचांद ईरोन, अदिक आऊन पुरा शरीर चुट्‍टगोळ देल तुमकु ईरोद; ईद कारण आऊन हेसुर एसाव ईटकु आत. ");
INSERT INTO hoy_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ईदुर बाद्‍दा आऊन वार्ट उन जनम आत, जो तान कय देल तान वार्ट एसाव उन काल हुडुकु ईरोन; आग आऊन हेसुर याकूब ईटकु आत. याग रिबका आऊक जनम कोट्‍टुर आग इसहाक साठ वर्ष इन ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","बाक आ चिकोर धोड्‍डेर आगली कुरतुर अदिक एसाव रा वनवासी आगकु चालाक शिकार आळावाळा आगेदुन, लेकीन याकूब सीधा मंळसा ईरोन, अदिक ड्‍यारागोळ दा ईरतोगोन. ");
INSERT INTO hoy_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","एसाव इसहाक उन प्यारा ईरोन यतिकी इसहाक उक मांस हापाळ वळ्‍लीद हततोगोद, लेकीन याकूब रिबका अन प्यारा ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ऊंद घन याग याकूब कम बेक्‍की दा येनारा बेईसोन, आग एसाव आळी टु बंदुन अदिक आव हापाळ हस्‍तकु ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","आव याकूब से अंदुन, “नानी हापाळ हसू हत्‍याद; नी जो बेईसीत्‍या, जल्‍दी माळकु अदुर दा टु नानी येनारा तीनली कोळ.” ईदा कारण आद कि आऊक एदोम भी अनकु आग्‍याद. ");
INSERT INTO hoy_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","लेकीन याकूब आऊन से अंदुन, “पयले नी तान धोळ आगोद अधिकार नानी कोळ.” ");
INSERT INTO hoy_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव अंदुन, “नोळ, हसु देल नान जीव होळेत्‍याद; धोळ आगोद अधिकार देल नानी येन फायदा आद?” ");
INSERT INTO hoy_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","लेकीन याकूब अंदुन, “रा पयले नी नान से कसम ताकोम.” आग एसाव कसम तीनकु तान धोळ आगोद अधिकार याकूब उन कय दा मार कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","आग याकूब एसाव उक येनारा रोट्‍टी अदिक बेईस्‍द मसूर इन ताग्गा कोट्‍टुन. एसाव तिंदुन कुळदुन, अदिक येदकु होटोदुन. ई प्रकार एसाव तान धोळ आगोद अधिकार इक तुच्‍छ सम्‍सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","आ द्‍याश दा अकाल बीत्‍त. हिंग अच अकाल अब्राहम उन समय दा भी बिद्दीत अदिक इसहाक गरार दा पलिश्तीगोळ राजा अबीमेलेक उन हाती होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","यहोवा इसहाक उक दर्शन कोटकु अंदुन, “मिस्त्र द्‍याश इक होगबाळ; लेकीन आ द्‍याश दा ईर, येल ना हेळाईन. ");
INSERT INTO hoy_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","येनारा समय साटी ई द्‍याश दा ईर, अदिक ना नीन सांगुळ ईराईन अदिक नीनी आशीष कोळाईन. ना ईद द्‍याश नीनी अदिक नीन वंश इक कोळाईन अदिक नीन आप्‍प अब्राहम से माळ्‍द तान वादा अक पुरा माळाईन, ");
INSERT INTO hoy_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ना नीन वंश इक आकाश इन तारागन इन घाई माळाईन; अदिक ना नीन वंश इक ईद सप्‍पा द्‍याश कोळाईन, अदिक पृथ्‍वी इन सप्‍पा जातीगोळ नीन वंश इन कारण तानीक धन्‍य मानसीत. ");
INSERT INTO hoy_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","यतिकी अब्राहम नान केळदुन, अदिक जो ना आऊक सौप्‍सदिन अदरी अदिक नान आग्‍यागोळ, विधिगोळ अदिक व्यवस्था अन पालन माळदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","इदुरसाटी इसहाक गरार नगर दा ईतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","याग आ जागा नोर लॉकुर आऊन हिंग्‍स उन बारा दा केळदुर, आग आव अंदुन, “आक नान आकतींग हुळ,” यतिकी आव ईद अनोर से अंजोन, “आक नान हिंग्‍स हुळ.” आव सोचोन, “ई जागा दाकळोर लॉकुर रिबका अन कारण शायद नानी कोंद बुट्‍टार, यतिकी आक सुंदर आर.” ");
INSERT INTO hoy_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","याग आऊक अल ईरतेला हापाळ दिनगोळ आदव, आग ऊंद दिन पलिश्तीगोळ राजा अबीमेलेक खिळकी दा टु येन नोळदुन कि इसहाक तान हिंग्‍स रिबका अन सांगुळ प्यार माळेत्‍यान. ");
INSERT INTO hoy_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","आग अबीमेलेक इसहाक उक कारसुसकु अंदुन, “आक रा सही दा नीन हिंग्‍स हुळ; बाक नी आकी यती तान आकतींग अंद?” इसहाक उत्‍तर कोट्‍टुन, “ना सोचीदिन, कि हिंग आगबाळुल कि आकिन कारण नान सायोद आगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेक अंदुन, “नी नाम से ईद येन माळ्‍द? हिंग रा प्रजा दा टु यावारा नीन हिंग्‍स उन सांगुळ सही दा कुकर्म माळ सकतान, अदिक नी नामी पाप दा फसुसाईद.” ");
INSERT INTO hoy_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","इदुरसाटी अबीमेलेक तान पुरा प्रजा अक आग्‍या कोट्‍टुन, “जो यावारा आ मंळसा अक या आ आर्त इक मुट्‍यान, आव सही दा कोंदसुसकु आदान.” ");
INSERT INTO hoy_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाक आ द्‍याश दा खेती माळदुन अदिक आऊक अदा वर्षी सौ गुणा फसल सिक्‍त, यतिकी यहोवा आऊक आशीष कोट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","आव धनवान आगेदुन; आऊन धन वाळुसतेला ईत्‍त अदिक आव हापाळ धनवान आगेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","आऊन हाती ईस मर्र-म्यांडा, जनावर अदिक सेवक आगेदुर कि पलिश्तीगोळ आऊन से होतली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","इदुरसाटी आ सप्‍पा भायगोळी, जो आऊन आप्‍प अब्राहम उन सेवकगोळ आऊन आप्‍प उन समय अगळीदुर, पलिश्तीगोळ मुण्‍ण देल मुचकु बंद माळ बुट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","आग अबीमेलेक इसहाक से अंदुन, “नी नाम हाती टु दुर होटोग, यतिकी नी नाम से हापाळ येक्‍कुल धनवान आगेग्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","इदुरसाटी इसहाक अल टु होटोदुन अदिक गरार घाटी दा ड्‍यारा नीदरूस्‍कु अल ईरली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","इसहाक आ भायगोळी मात अगळुसदुन, जो आऊन आप्‍प उन समय दा अगुळकु आगीदव, अदिक अवरी पलिश्तीगोळ अब्राहम उन सोत्‍तुर बाद्‍दा मुच्‍च कोंडीदुर, अदिक आव आ भायगोळ्‍द अवा हेसुर ईटदुन जो आऊन आप्‍प ईटीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","इसहाक उन सेवकगोळी घाटी दा अगळा वती अल ऊंद सय नीर इन झरना सीक्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ईदुर मा गरार इन चरवाहागोळ इसहाक उन चरवाहागोळ सांगुळ झगळा माळदुर अदिक अंदुर, “ईद नीर नाम्‍द हुन!” इदुरसाटी इसहाक आ भाय इन हेसुर ऐसेक ईटदुन, यतिकी आंदुर आऊन से झगळा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","आग आंदुर दुसरा भाय अगुळदुर, लेकीन आंदुर अदुर मा भी झगळा माळदुर; इदुरसाटी इसहाक आ भाय इन हेसुर सितनाह ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","आग आव अल टु होटोदुन अदिक ऊंद अदिक भाय अगुळदुर, अदिक ईदुर मा याऊ झगळा माळीदिल. इसहाक ईद अनकु आ भाय इन हेसुर रहोबोत ईटदुन, “ईग यहोवा नामी हापाळ नीर कोटान, अदिक नाव ई द्‍याश दा उन्‍नती माळेव.” ");
INSERT INTO hoy_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","अल टु इसहाक बेर्शेबा अक होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","अदा ईळ्लकी यहोवा आऊक दर्शन कोटकु अंदुन, “ना नीम आप्‍प अब्राहम उन परमेश्वर हुईन. अंजबाळ, यतिकी नान नीन सांगुळ आईन; ना नीनी तान सेवक अब्राहम उन कारण आशीष कोळाईन अदिक नीन वंश इक वाळुसाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","आग इसहाक अल ऊंद वेदी माळदुन अदिक यहोवा अन आराधना माळदुन. अल आव तान ड्‍यारा नीदरूसदुन अदिक अल आऊन सेवकगोळ ऊंद भाय अगुळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","आग अबीमेलेक तान सलाहकार अहुज्‍जत, अदिक तान सेनापती पीकोल उक सांगुळ हुडुकु, गरार नगर टु आऊन हाती होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाक आंदुर से अंदुन, “नीव नान से दुश्मनी माळकु तान हाती टु तेगु बुटीदिर, ईग नान हाती यती बंदीर?” ");
INSERT INTO hoy_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","आंदुर अंदुर, “नाव साफ-साफ नोळदेव कि यहोवा नीन सांगुळ आन; इदुरसाटी नाव अंदेव, ‘नीन अदिक नाम बीच दा कसम इन वादा ईर पायजे.’ इदुरसाटी नाव नीन से ऊंद वादा माळोद चाहसतेव. ");
INSERT INTO hoy_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","कि ह्‍यांग नाव नीनी मुठीदिल, बल्‍की नीन सांगुळ सिर्फ भलाई माळेव, अदिक नीनी कुशल क्षेम देल सार माळदुन, अदुर अनुसार नी भी नाम से यातोदु बुराई माळतीदील. अदिक नी प्रभु उन आशीष सिक्त मंळसा हुय.” ");
INSERT INTO hoy_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","आग इसहाक आंदुर साटी ऊंद भोज इन आयोजन माळदुन, अदिक आंदुर तिंदुर अदिक कुळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","दुसरा दिशी एकदम व्हातर्‍या येदकु आबुर दाबुर सांगुळ कसम ताकोंडुर. आग इसहाक आंदुर सार माळदुन, अदिक आंदुर शांती देल आ जागा टु होटोदुर. ");
INSERT INTO hoy_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","आ दिशी इसहाक उन सेवकगोळ बंदकु आऊक आ अगुळकु भाय इन बारा दा हेळदुन, यदरी आंदुर अगळीदुर, आंदुर अंदीदुर, “नामी नीर सिकेग्‍याद!” ");
INSERT INTO hoy_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","इसहाक आ भाय इन हेसुर शिबा ईटदुन, अदिक ईंद ताका आ नगर इन हेसुर बेर्शेबा आद. ");
INSERT INTO hoy_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","याग एसाव चालीस वर्ष इन आदुन, आग आव हित्ती बेरी अन पोर यहूदीत, अदिक हित्‍ती एलोन उन पोर बासमत इक हिंग्‍स माळदुन; ");
INSERT INTO hoy_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","अदिक ई आर्तेर इन कारण इसहाक अदिक रिबका अन मन इक दुख आत. ");
INSERT INTO hoy_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","याग इसहाक बाट्‍ट आगेदुन, अदिक आऊन कण्‍णगोळ हिंग कमजोर आगेदव कि आव नोळ ईला सकोन, आग आव तान धोड्‍डेव पार एसाव उक कारदुन अदिक अंदुन, “हे नान पारा.” आव अंदुन, “येन आग्‍या आद नान आप्‍पा?” ");
INSERT INTO hoy_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","इसहाक अंदुन, “ना रा हाळाबाट्‍ट आगेगीन अदिक जानसालीन कि याग सायाईन. ");
INSERT INTO hoy_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","इदुरसाटी ईग नी तान तरकस अदिक धनुष हुडु अदिक आळी दा होग अदिक नान साटी यातोदारा आळी दाकळोद जनावर शिकार माळकु तर. ");
INSERT INTO hoy_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","अदिक नान पसंद इन अनुसार सवाद भोजन माळकु नान हाती तनकु कोळेत, कि अदरी तीनकु सायोर से पयले नीनी जी तुमकु आशीर्वाद कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","याग इसहाक तान पार एसाव से मातगोळ हेळोन, आग रिबका आंदुर मातगोळ केळोर. याग एसाव आळी दा शिकार माळोर साटी होटोदुन, ");
INSERT INTO hoy_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","आग रिबका तान पार याकूब से अंदुर, “नोळ, ना नीन आप्‍प उक नीन वार्ट एसाव से ईद अनतेला केळीन, ");
INSERT INTO hoy_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘शिकार माळकु नान साटी सवाद भोजन माळकु तर कि ना अदरी तीनाईन अदिक तान सायोर से पयले यहोवा अन मुंद आशीष कोळाईन.’ ");
INSERT INTO hoy_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","इदुरसाटी ईग, हे नान पारा, नांद केळ, अदिक ईद आग्‍या मान्‍स, ");
INSERT INTO hoy_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","कि मर्रगोळ हाती होगकु मर्रगोळोव येढ्‍ढ वळ्‍लेव वळ्‍लेव पाड्डा तर; अदिक ना नीन आप्‍प उन साटी आऊन पसंद इन अनुसार सवाद भोजन माळकु कोळाईन. ");
INSERT INTO hoy_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","आग नी अदरी तान आप्‍प उन हाती ओयत, कि आव अदरी तीनकु सायोर से पयले नीनी आशीर्वाद कोळुल.” ");
INSERT INTO hoy_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकूब तान मोय रिबका से अंदुन, “केळ, नान वार्ट एसाव उन मय मा पुरा चुट्‍टी आव लेकीन नान मय मा हैलेच. ");
INSERT INTO hoy_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","अगर नान आप्‍प नानी अजमुस्यान रा, ना तान आप्‍प उन नजर दा ख्‍वाटा बीळाईन; अदिक आशीष इन बदला दा श्राप अच कमुसाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","आऊन मोय आऊन से अंदुर, “हे नान पारा, श्राप नीन मा ईला नान मा बिळुल, नी सिर्फ नांद केळ, अदिक होगकु अव पाड्‍डागोळ नान हाती तर.” ");
INSERT INTO hoy_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","आग याकूब होगकु आ पाड्‍डागोळी तान मोय इन हाती तंदुन, अदिक मोय आऊन पसंद इन अनुसार सवाद भोजन माळकु कोट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","आग रिबका तान पयला पार एसाव उन सुंदर कपळा, जो आकिन मान्‍या ईरव, तान स्याण पार याकूब उक हाकसुस बुट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","आक मर्र इन पाड्डा अन तोगुल देल आऊन कयगोळ्द हिस्‍सा अदिक कुतक्‍या अक भी ढाक्‍स कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","आग आक तान कास्‍द सवाद मांस इक अदिक रोट्‍टीगोळी हुडुकु याकूब उक कोट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","तान आप्‍प उन हाती होगकु याकूब अंदुन, “आप्‍पा.” इसहाक उत्‍तर कोट्‍टुन, “येन पारा, याव हुय नी?” ");
INSERT INTO hoy_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूब तान आप्‍प उक उत्‍तर कोट्‍टुन, “ना नीन धोड्‍डेव पार एसाव हुईन. ना अद सप्‍पा माळदीन, ह्‍यांग नी अंदीद. कृपया कुर अदिक नांद शिकार माळ्‍द भोजन माळ अदिक नानी तान आशीष कोळ.” ");
INSERT INTO hoy_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाक तान पार से अंदुन, “हे नान पारा, येन कारण आद कि शिकार नीनी ईट जल्‍दी सीकेत?” आव उत्‍तर कोट्‍टुन, “नीन परमेश्वर यहोवा अदरी नान मुंद माळ बुट्‍टुन.” ");
INSERT INTO hoy_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","बाक इसहाक याकूब से अंदुन, “हे नान पारा, हाती बर, ना नीनी ताळुकु नोळतीन, कि नी सही दा नान पार एसाव हुय या ईला.” ");
INSERT INTO hoy_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","आग याकूब तान आप्‍प इसहाक उन हाती होदुन, अदिक आव आऊक ताळुकु अंदुन, “आवाज रा याकूब घाई आद लेकीन कय एसाव उन घाई आव.” ");
INSERT INTO hoy_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","इसहाक आऊक अरतीदिल, यतिकी आऊन कय मा हांगा चुट्‍टी ईरव ह्‍यांग एसाव उन ईरव. इदुरसाटी इसहाक याकूब उक आशीष कोट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","इसहाक केळदुन, “येन नी सहीदा नान पार एसाव हुय?” याकूब उत्‍तर कोट्‍टुन, “हव.” ");
INSERT INTO hoy_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","आग इसहाक अंदुन, “हे नान पारा, तान शिकार देल बेईस्‍द येनारा भोजन नान साटी तीनली तर, ताकी ना नीनी तान आशीष कोळाईन.” आग आव अदरी आऊन हात्ती तंदुन, अदिक आव तिंदुन; अदिक आव आऊन हात्ती अंगुर इन रास्सा भी तंदुन, अदिक आव कुळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","आग आऊन आप्‍प इसहाक आऊन से अंदुन, “हे नान पारा, ईल बर अदिक नानी चुम्‍स.” ");
INSERT INTO hoy_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","इदुरसाटी याकूब आऊन हाती होदुन अदिक आऊक चुम्सदुन, याग इसहाक उक आऊन कपळा दा टु एसाव उन सुंगध बत्‍त, इदुरसाटी आव आऊक आशीष कोळतेला अंदुन, “नान पार उन खुशबू परमेश्वर यहोवा अन आशीष देल मैदान दा फैलुसीग्‍याद. ");
INSERT INTO hoy_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेश्वर नीनी आकाश टु ओद, अदिक जमीन इन वळ्‍लीद से वळ्‍लीद फसल, अदिक हापाळ सा अनाज अदिक व्‍हाशोद अंगुर इन रास्‍सा कोळुल; ");
INSERT INTO hoy_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","सप्‍पा राज्‍य अन लॉकुर नींद स्यावा माळुल, जाती जाती इन लॉकुर नींद मुंद झुकसुल, नी तान वार्टुर्द स्वामी आगुल, अदिक नीन मोय इन चिकोर नीनी नमस्‍कार माळुल. जो नीनी श्राप कोळतान आव खुद अच श्रापीत आगुल, अदिक जो नीनी आशीर्वाद कोट्‍टान आऊक आशीष सिकुल.” ");
INSERT INTO hoy_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","याग इसहाक याकूब उक आशीष कोट्‍ट बुट्‍टुन आग आऊन वार्ट एसाव शिकार माळकु मान्‍या बंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","आव जल्‍दी सवाद भोजन तैयार माळदुन अदिक तान आप्‍प से अंदुन “आप्‍पा, येळ अदिक सवाद भोजन तीनकु नानी आशीष कोळ.” ");
INSERT INTO hoy_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","आऊन आप्‍प इसहाक आऊन से केळदुन, “याव हुय नी?” आव अंदुन, “ना नीन धोड्‍डेव पार एसाव हुईन.” ");
INSERT INTO hoy_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ईद केळकु इसहाक नळ्‍गतेला अंदुन, “रा आव याव ईरोन, जो नान साटी भोजन तंदीदुन? अदिक ना आऊक आशीष भी कोट्‍टीन, ईग आव आशीषित अच ईत्‍तान!” ");
INSERT INTO hoy_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","तान आप्‍प उन ईद मात केळकु एसाव हापाळ वर्लली कुरतुन अदिक आव तान आप्‍प से अंदुन, “हे नान आप्‍पा, नानी भी आशीष कोळ!” ");
INSERT INTO hoy_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","इसहाक अंदुन, “नीन वार्ट ध्‍वाका कोट्‍टुन अदिक आशीष ताकोम कोंडुन.” ");
INSERT INTO hoy_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसाव अंदुन, “अदुर साटी याकूब हेसुर सही हैलेच, येढ्‍ढ घन आव नान सांगुळ गलत माळदुन: पयले आव नान धोड्‍डेव आगोद अधिकार ताकोम कोंडुन अदिक ईग नान आशीष भी कदू कोंडुन!” आग एसाव तान आप्‍प से केळदुन, “येन नी नान साटी ऊंद भी आशीष मीक्‍सकु ईटीदिल?” ");
INSERT INTO hoy_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाक एसाव से अंदुन, “ना रा आऊक नीन स्वामी माळ कोंडीन. अदिक सप्‍पा संबंधीगोळी आऊन सेवक माळकु आऊक सौप्स कोंडीन अदिक आऊक अनाज अदिक व्‍हाशेव अंगुर इन रास्सा देल तुमकु ईरोद आशीष कोट्‍टीन, ईग नान पारा, नीन साटी ना येन माळाईन?” ");
INSERT INTO hoy_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसाव तान आप्‍प से केळदुन, “हे नान आप्‍पा, येन नीन हाती नान साटी ऊंद भी आशीष हैलेच? अदिक वर्लतेला अनली कुरतुन कि हे नान आप्‍पा नानी भी आशीष कोळ!” ");
INSERT INTO hoy_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","आग इसहाक अंदुन, “नीन मान्‍ना वळ्‍लीद ऊपज वाळा जागा टु दूर ईरूल अदिक अदुर मा आकाश टु ओद बिळबाळुल. ");
INSERT INTO hoy_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","नी तान तलवार इन ताकत देल जीत्‍ता ईत्‍या. नी तान वार्टुन स्यावा माळ्‍या; लेकीन हा, लेकीन नी आजादी इन साटी लळुस्‍या, अदिक नी तान म्‍याकुच बीत्‍त आऊन प्रतिबन्‍ध इक मुरूकु भीट्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","एसाव तान वार्ट याकूब से तान आप्प उन कोळ्द आशीष इन कारण सिट्‍ट माळली कुरतुन अदिक मन दा हिंग सोचली हतदुन कि “आप्‍प उन सोत्‍तुर बाद्‍दा आऊन हत्‍या माळ कोमाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","याग रिबका अक तान धोड्‍डेव पार उन सिट्‍ट कांळ्सली कुर्त आग याकूब उक कारसुसकु आऊन से अंदुर, “नीन वार्ट एसाव उन मन दा नीन साटी हापाळ सिट्‍ट आद. केळ, नीन वार्ट एसाव नीनी कोन्‍नोद विचार माळेत्‍यान. ");
INSERT INTO hoy_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","इदुरसाटी नी ईल टु ओळकु नान वार्ट लाबान उन मान्‍या हारान नगर होटोग. ");
INSERT INTO hoy_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","अल होगकु येनारा समय ईर, यागास ताका नीन वार्ट उन सिट्‍ट खतम आगेगाल. ");
INSERT INTO hoy_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","यागास ताका नीन वार्ट उन सिट्‍ट खतम आदीत, अदिक आव मारतोदान कि नी आऊन सांगुळ येन माळ्‍द, आग ना नीनी अल टु कारू कोमाईन.” हिंग येती आगुल कि उंद अच दिन दा नान इक येढ्ढु पारगोळ से वंचित आगोद बिळुल. ");
INSERT INTO hoy_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ऊंद दिशी रिबका इसहाक से केळदुर, “हित्‍ती इन ई पोरगोळ नान जीवन दुखी माळ बुट्‍टार. अगर याकूब भी हेथ इन पोरगोळ दा टु यारीकारा, तान हिंग्‍स माळ कोंडान रा नान साटी जीऊसोद अदिक भी मुश्‍किल आगेदीत?” इदुरसाटी याकूब उक आऊन मामा लाबान उन मान्‍या कळु कोम. ");
INSERT INTO hoy_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","इदुरसाटी इसहाक याकूब उक आशीष कोट्‍टुन अदिक अंदुन: “कि कनानी पोरगोळ से मदा माळबाळेत. ");
INSERT INTO hoy_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","लेकीन पद्‍दनराम दा तान आजा बतूएल उन मान्‍या होगकु अल तान मामा लाबान उन ऊंद पोर इक हिंग्स माळ कोमेत. ");
INSERT INTO hoy_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वशक्तिमान परमेश्वर नीनी आशीष कोळुल, अदिक फलवंत माळकु नीनी वाळुसुल, अदिक नी राज्‍य राज्‍य अन मंडली इन मूल आगुल. ");
INSERT INTO hoy_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","परमेश्वर नीनी अद आशीष कोळुल जो अब्राहम उक कोटीदुन, नीनी अदिक नीन वंश इक, आ द्‍याश इक अधिकारी माळुल.” ");
INSERT INTO hoy_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ई सप्‍पा आशीषित वचन इन सांगुळ इसहाक याकूब उक सार माळदुन. याकूब तान अदिक एसाव इन मोय रिबका अन वार्ट अरामीवासी लाबान इन मान्‍या होटोदुन, जो पद्‍दनराम इन बतूएल अन चिकोर ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","एसाव उक मालूम आगेगीत कि इसहाक याकूब उक आशीष कोटकु पद्‍दनराम क्षेत्र दा कळुदुन ताकी आव तान साटी हिंग्‍स नीवळुसुल, अदिक आदेश भी कोट्‍टुन कि आव कनानी आर्त इन से मदा माळबाळुल, ");
INSERT INTO hoy_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","अदिक याकूब तान आप्‍प अदिक मोय इन मात इक मान्सतेला पद्‍दनराम दा होटोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","आग एसाव उक ईद समझ दा होट्‍ट बत्‍त, कि आऊन आप्‍प इसहाक कनान द्‍याश इन पोरगोळ पसंद हैलेच. ");
INSERT INTO hoy_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","इदुरसाटी एसाव तान हिंग्‍स उन अलावा अब्राहम उन पार इश्‍माएल इन पोर माहालाथ से, जो नबायोत इन आकतींग ईरोर, मदा माळ कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकूब बेर्शेबा से होटकु हारान इन दी होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","अदिक आव ऊंद जागा दा पोहचुस्कु ईळ्‍ल्‍क अल्‍या कढोद विचार माळदुन, यतिकी सुर्य मुळकेगीत; इदुरसाटी आव आ जागा अन कल्‍लगोळ दा टु ऊंद कल्‍ल हुडुकु तान ऊसा माळकु ईटदुन, अदिक अदा जागा दा मींगेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","आग आव कांन्‍सा दा येन नोळदुन, कि ऊंद सीळी पृथ्‍वी मा नीदुरकु आद, अदिक अदुर स्‍यांडा स्‍वर्ग ताका पोहचुस्कु आद; अदिक परमेश्वर उन दूतगोळ अदुर मा येरतार अदिक ईळुतार. ");
INSERT INTO hoy_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","अदिक यहोवा अदुर म्‍याकुच निदुरकु अनतान, “ना यहोवा, नीन आजा अब्राहम उन परमेश्वर, अदिक इसहाक उन भी परमेश्वर हुईन; या जागा मा नी मिंगकु आय, अदरी ना नीनी अदिक नीन वंश इक कोळाईन. ");
INSERT INTO hoy_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","अदिक नीन वंश जमीन इन धूळा अन खाळा अन घाई हापाळ आदीत, अदिक पश्‍चिम, पूर्व, उत्‍तर, दक्षिण, नाकु दी फैलुसतेला होदीत: अदिक नीन अदिक नीन वंश इन द्वारा पृथ्‍वी इन सप्‍पा कुल आशीष ताकोंडार. ");
INSERT INTO hoy_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","अदिक केळ, ना नीन सांगुळ ईराईन, अदिक नी येल्‍यारा भी होगत्‍या अल नीन रक्षा माळाईन, अदिक नीनी ई द्‍याश दा वापस ताराईन: ना तान अंदुर इक पुरा माळ कोमालीन आगासताका नीनी बिळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","आग याकूब येद्‍दुन, अदिक अनली कुरतुन, “सही दा ई जागा दा यहोवा आन; अदिक ना ई मात इक ईला जानसीन.” ");
INSERT INTO hoy_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","अदिक अंजकु आव अंदुन, “ईद जागा येन ईद भयानक आद! ईद रा परमेश्वर उन भवन उक बीळ अदिक येनु आगसकाल; बल्‍की ईद स्‍वर्ग इन फाटक अच आगीदाद.” ");
INSERT INTO hoy_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","व्‍हातर्याका याकूब येद्‍दुन, अदिक तान ऊसा अन कल्‍ल हुडुकु अदुर्द खंबा नीदरूसदुन, अदिक आव अदुर ताल्‍ला मा याण्‍णा हाक्‍क कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","अदिक आव आ जागा अन हेसुर बेतेल ईटदुन; लेकीन आ नगर इन हेसुर पयले लूज ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","याकूब ईद मन्नत ताकोंडुन, “अगर परमेश्वर नान सांगुळ ईतकु ई यात्रा दा नान रक्षा माळुल, अदिक नानी तीनोर साटी रोट्‍टी, अदिक हाक्‍कोर साटी कपळा कोळुल, ");
INSERT INTO hoy_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","अदिक नानी नान आप्‍प उन मान्‍ना ताका सुरक्षित पोहचुस्‍यान, यहोवा अच नान परमेश्वर आदान. ");
INSERT INTO hoy_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ईद कल्‍ल, यदरी ना खंबा माळकु निदरूसीन, परमेश्वर उन मान्‍ना आदीत अदिक नी जो येनारा नानी कोट्या, सही दा : ना अदुर्द दशमांश नीन इच कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","बाक याकूब तान हादी हुळदुन, अदिक पूर्वियों अन द्‍याश दा बंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","अदिक आव येन नोळदुन कि, मैदान दा ऊंद भाय आद, अदिक अदुर हाती म्यांडा मर्र इन मुर झुंड कुर्तकु आव; यतिकी जो कल्‍ल आ भाय इन बाय मा ईटकु ईरतोगोद, यदुर दा टु झुंडगोळी नीर कुळ्‍सकु आगतोगोद, अद भारी ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","अदिक याग सप्‍पा झुंड अल जमा आगतोगोव आग चरवाहगोळ आ कल्‍ल इक भाय इन बाय मा टु सरकुसकु म्यांडा मर्रगोळी नीर कुळ्‍सतोगोर, अदिक बाक कल्‍ल इक भाय इन बाय मा हांग च्‍या हांगा ईटतोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","अत: याकूब चरवाहागोळ से केळदुन, “हे नान वार्टुरा, नीव येलेर हुईर?” आंदुर अंदुर, “नाव हारान इन नोर हुयेव.” ");
INSERT INTO hoy_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","आग आव आंदुर से केळदुन, “येन नीव नाहोर उन नातु लाबान उक जान्‍सतीर?” आंदुर अंदुर, “हव, नाव आऊक जान्‍सतेव.” ");
INSERT INTO hoy_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","बाक आव आंदुर से केळदुन, “येन आव सुरक्षित आन?” आंदुर अंदुर, “हव, सुरक्षित आन अदिक नोळ, आऊन पोर राहेल म्यांडा मर्र इक हुडुकु बरेत्‍यार.” ");
INSERT INTO hoy_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","आव अंदुन, “नोळ, ईगल्‍या रा द्‍याव होगली आद बाक ईट जल्‍दी म्यांडा मर्रगोळ इक यती जमा माळेतीर, ईगल्‍या अवरी नीर कुळ्‍सकु आळगोळी.” ");
INSERT INTO hoy_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","लेकीन आंदुर अंदुर, “ईला, सप्‍पा म्यांडा मर्रगोळ ऊंद सांगुळ बंदुर मा अच भाय टु कल्‍ल हटुसकु म्यांडा मर्रगोळ इक नीर कुळ्‍सकु आगतद.” ");
INSERT INTO hoy_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","आंदुर्द ईद मातचीत आगोद, कि राहेल जो जनावर आळ्‍सतोगोर, तान आप्‍प उन म्यांडा मर्रगोळी हुडुकु बंदुर. ");
INSERT INTO hoy_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","तान मामा लाबान इन पोर राहेल इक, अदिक आऊन म्यांडा मर्रगोळी भी नोळकु याकूब उन हाती होगकु भाय इन बाय मा टु कल्‍ल इक सरकुसकु तान मामा लाबान उन म्यांडा मर्रगोळी नीर कुळ्‍सदुर. ");
INSERT INTO hoy_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","आग याकूब राहेल उक चुम्‍सदुन, अदिक धोळ्‍द आवाज देल वर्लदुन. ");
INSERT INTO hoy_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","अदिक याकूब राहेल इक हेळ बुट्‍टुन, कि ना नीन फुफेरा वार्ट हुईन, मतलब रिबका अन पार हुईन. आग आक ओळकु होदुर अदिक तान आप्‍प उक हेळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","तान भास्‍या अन समाचार केळतेला अच लाबान आऊन से भेंट माळोर साटी ओळदुन, अदिक आऊक छिना देल हचकु चुम्‍सदुन, बाक तान मान्‍या तंदुन. अदिक याकूब लाबान से तान सप्‍पा हालचाल हेळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","आग लाबान याकूब से अंदुर, “नी रा सही दा नान येलु अदिक मास हुय.”अदिक याकूब ऊंद तींगुळ ताका आऊन सांगुळ ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","आग लाबान याकूब से अंदुन, “इदुरसाटी कि नान रिश्तेदार हुय, ईद वळ्‍लीद हैलेच, कि नी नान साटी बीना पैस्‍या देल क्‍याल्‍सा माळ्या इदुरसाटी नी पैस्‍या ताकोमकु क्‍याल्‍सा माळेत?” ");
INSERT INTO hoy_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबान उन येढ्‍ढ पोरगोळ ईरोर. धोळ पोर इन हेसुर लियाह अदिक स्‍याण पोर इन हेसुर राहेल ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लियाह अन कण्‍णगोळ धुंधला ईरव लेकीन राहेल रूपवान अदिक सुंदर ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकूब राहेल इक प्रेम माळली कुरतुन, याकूब लाबान से अंदुन, “नीन स्‍याण पोर राहेल इक पाऊसोर साटी ना येळ वर्ष नीन स्यावा माळोरसाटी तैयार आईन.” ");
INSERT INTO hoy_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबान अंदुन, “आकी पराया गंळ्स उक कोळदुर देल नीन इक कोळोद वळ्लीद आदीत; नी ईल्या नाम सांगुळ ईर.” ");
INSERT INTO hoy_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","इदुरसाटी याकूब राहेल इक पाऊसोर साटी येळ वर्ष स्यावा माळदुन. लेकीन आऊक ईद समय हापाळ कम हत्‍त यतिकी आव राहेल से हापाळ प्रेम माळतोगोन. ");
INSERT INTO hoy_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","बाक याकूब लाबान से अंदुन, “येळ वर्ष आगेदव ईग नीन पोर राहेल नानी कोळ ताकी नांद मदा आगेगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","लाबान तान समाज इन लॉकुरी कारसुसकु सप्‍पा मुंदरी मदा अन्द जेवन तीन्‍सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","द्‍यावगा आव तान पोर लियाह अक याकूब उक कोट्‍ट बुट्‍टुन अदिक याकूब आकिन सांगुळ मदा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबान तान दासी जिल्‍पा अक भी लियाह अक आकिन दासी आगोर साटी कोट्‍ट बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","याग याकूब उक मालुम आत कि आक रा लियाह ईरोर! याकूब लाबान से केळदुन, “ईद येन माळ्‍द नी नान सांगुळ? ना नीन स्यावा राहेल इन साटी माळीन? बाक नी नान सांगुळ ईत्‍ता ध्‍वाका यती माळ्‍द?” ");
INSERT INTO hoy_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबान अंदुन, “नाम समाज दा धोड्‍डेर पोर बिटकु स्‍याण पोर इन मदा माळ सकालुर.” ");
INSERT INTO hoy_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","“ईद हप्ता रा पुरा माळ; बाक दुसरा भी नीनी आ स्यावा साटी सीक्‍यार जो नी नान सांगुळ ईतकु अदिक येळ वर्ष ताका माळ्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","याकूब हिंगा माळदुन, अदिक लियाह अन हप्ता पुरा माळदुन; आग लाबान आऊक तान पोर राहेल भी कोट्‍टुन, कि आक आऊन हिंग्‍स आगुल. ");
INSERT INTO hoy_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबान तान पोर राहेल इन दासी आगोर साटी तान दासी बिल्हा अक कोट्‍ट बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","आग याकूब राहेल इन हाती भी होदुन, अदिक आकिन प्रेम लियाह से येक्‍कुल आकिन मा अच आत, अदिक आव लाबान उन सांगुळ ईतकु येळ वर्ष अदिक स्यावा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","याग यहोवा नोळदुन कि लियाह अप्रिय आदुर, आग आव आकिन कोख खोल्सदुन, लेकीन राहेल बाँझ ईत्‍तुर. ");
INSERT INTO hoy_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","अत: लियाह व्‍हाट्‍यादी ईत्‍तुर, अदिक आकिन से ऊंद पार पैदा आदुन, अदिक आक ईद अनकु आऊन हेसुर रूबेन ईटदुर, “यहोवा नान दुख मा नजर माळदुन, ईग नान गांड नान से प्रेम ईट्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","बाक लियाह अक अदिक ऊंद पार आत. आक अंदुर, “यतिकी यहोवा ईद केळ कोंडुन कि ना तान गांड उक पसंद हैलेच अदिक नानी ईद ऊंद अदिक पार कोट्‍टुन.”आक आऊन हेसुर शिमोन ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","लियाह मात्‍त व्‍हाट्‍यादी ईत्‍तुर याग आकी पार पैदा आदुन आग आक अंदुर, “ईग नान गांड नान से जुळसेदान यतिकी ना आऊन मुर पारगोळी जनम कोटीन.” इदुरसाटी लियाह तीसरा पार उन हेसुर लेवी ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","आक अदिक ऊंद पार उक जनम कोट्‍टुर, “ईग ना यहोवा अन स्‍तुति माळाईन,” इदुरसाटी आक आ पार उन हेसुर यहूदा ईटदुर. अदुर बाद्‍दा लियाह अक चिकोर आगोद बंद आगेत. ");
INSERT INTO hoy_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","याग राहेल ईद नोळदुर कि याकूब उन साटी आकिन द्वारा यारू चिकोर आगीदील, रा आकी तान आकतींग से नफरत पैदा आगेत. आक याकूब से झगळा माळली कुरतुर कि, “नानी चिग्‍द कोळ, ईलारा ना सोतोगाईन!” ");
INSERT INTO hoy_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","आग याकूब राहेल से सिट्‍ट देल चिळ्‍लासदुन अदिक अंदुन, “येन ना परमेश्वर उन जागा मा आईन कि ना नींद बंद कोख खोल्‍स सकाईन?” ");
INSERT INTO hoy_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ईद केळकु आक अंदुर, “रा नान दासी बिल्हा अन हात्‍ती होग, ताकी आकिन द्वारा ना मोय बनसाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","इदुरसाटी राहेल याकूब उक तान दासी बिल्हा अक हिंग्‍स उन रूप दा कोट्‍ट बुट्‍टुर, अदिक याकूब बिल्हा अन सांगुळ वैवाहिक संबंध माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","बिल्हा व्‍हाट्‍यादी ईत्‍तुर अदिक आकी याकूब से ऊंद पार पैदा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","आग राहेल अंदुर, “परमेश्वर नांद न्‍याय माळदुन अदिक नांद दुहाई केळदुन अदिक नानी पार कोट्‍टुन.” आक आऊन हेसुर दान ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","बाक राहेल इन दासी बिल्हा मात्त व्‍हाट्‍यादी ईत्‍तुर अदिक आक याकूब से दुसरा पार उक पैदा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","आग राहेल अंदुर, “ना तान आकतींग इन सांगुळ हापाळ मेहनत माळीन अदिक ईग ना जीकेसेगीन.” इदुरसाटी ई पार उन हेसुर नप्ताली ईटकु आत. ");
INSERT INTO hoy_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","याग लियाह नोळदुर कि आकिन अदिक चिकोर आगोद थामसेग्‍याद, आग आक तान दासी जिल्‍पा अक याकूब उक हिंग्‍स उन रूप दा कोट्‍ट बुट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","लियाह अन दासी जिल्‍पा याकूब देल ऊंद पार उक जनम कोट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","लियाह सोचदुर, “ह्‍यांग धन्‍यता आद ईद!” इदुरसाटी आ पार उन हेसुर गाद ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","लियाह अन दासी जिल्‍पा याकूब से दुसरा पार उक पैदा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","आग लियाह सोचदुर, “ना धन्‍य आईन अदिक आर्तेर नानी धन्‍य अंदार.” इदुरसाटी ई पार उन हेसुर आशेर ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","केई दा गोदी इन कटाई इन समय रूबेन याग केई दा होदुन आऊक अल येनारा व्‍हाट्‍यादी माळावाळा काय सिकदव, अवरी आव तान मोय लियाह अन हाती तंदुन. राहेल लियाह से अंदुर, “नानी भी थ्‍वाळासा दूदाफल कोट बुळ.” ");
INSERT INTO hoy_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","लियाह राहेल से अंदुर, “येन ईद काफी हैलेच कि नी नान से नान गांड कसु कोंड? अदिक ईग नान पार उन तंदव दूदाफल भी हुडोद चाहसत्‍या?” आग राहेल आकिन से अंदुर, “अगर नी नानी ईद मार्र कोट्या, रा ना ईंद इन ईळ्‍ल्‍क नीनी याकूब उन सांगुळ ईरोद इजाजत कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","याग द्‍यावगा याकूब केई दा टु बंदुन आग लियाह याकूब से अंदुर, “ना नीन साटी तान पार द्वारा तंद दूदाफल इक कोटकु नीनी कोंड कोंडीन.” ");
INSERT INTO hoy_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","परमेश्वर लियाह से केळदुन. आक व्‍हाट्‍यादी ईत्‍तुर अदिक याकूब उक पाचवा पार कोट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ईदुर मा लियाह अंदुर कि, “परमेश्वर नानी नान मजदुरी कोट्‍टुन यतिकी ना तान दासी इक तान गांड उक कोट्‍टीन.” अदिक इदुरसाटी आऊन हेसुर इस्साकार ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","बाक लियाह मात्त व्‍हाट्‍यादी ईत्तुर. आक याकूब से छटवा पार उक जनम कोट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","आग लियाह अंदुर, “परमेश्वर नानी वळ्‍लीद दान कोटान; ई घनी नान गांड नान सांगुळ बन्सकु ईत्‍तान, यतिकी ना आऊक आर चिकोर कोटीन” अदिक इदुरसाटी आ पार उन हेसुर जबूलून ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","बाक येनारा समय इन बाद्‍दा लियाह अक ऊंद पोर आदुर, आकिन हेसुर दीना ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ईदुर बाद्‍दा परमेश्वर राहेल मा दया माळदुन. परमेश्वर राहेल उन प्रार्थना केळदुन अदिक आकी व्‍हाट्‍यादी ईरोर साटी समक्ष माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","आकी ऊंद पार आदुन, अदिक आक अंदुर, “परमेश्वर नांद कलंक मिटुस बुट्‍टुन.” ");
INSERT INTO hoy_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ईद अनतेला आऊक यूसुफ हेसुर कोट्‍टुर, “परमेश्वर यहोवा नानी ऊंद पार अदिक कोट्‍टान.” ");
INSERT INTO hoy_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","याग राहेल से यूसुफ पैदा आदुन, आग याकूब लाबान से अंदुन, “नानी सार माळ कि ना तान द्‍याश अदिक तान जागा अक वापस होगाईन. ");
INSERT INTO hoy_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","नान हिंग्‍सुर अदिक नानोर चिकोर, यार साटी ना नींद स्यावा माळदीन, आंदरी नानी कोळ कि ना होटोगाईन; नी रा जान्सत्या कि ना नींद ह्‍यांग स्यावा माळीन.” ");
INSERT INTO hoy_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लाबान आऊन से अंदुन, “यहोवा अन दी टु नानी ईद मालुम आग्‍याद, कि नानी जो अनुग्रह सिक्‍याद, अद नींद अच कारण सिक्‍याद. इदुरसाटी नी नान से नाराज हैलेच, रा नी नान मान्‍या अच ईर.” ");
INSERT INTO hoy_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","लाबान अंदुन, “स्यावा अन बदला नी येन चाहसत्‍या ना नीनी अदा कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","लेकीन याकूब लाबान से अंदुन, “ना नीन स्यावा ह्‍यांग माळीन, ईद मात नीन से होचकोमकु हैलेच, अदिक नीन जनावरगोळ्‍द भी देखरेख ना ह्‍यांग माळीन. ");
INSERT INTO hoy_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","पयले जनावरगोळ कम ईरव लेकीन ईग हापाळ आगेग्‍याव. ना जो भी क्‍याल्‍सा माळीन, अदुर दा यहोवा आशीष कोटान. लेकीन ईग ना तान घराना अन बारा दा सोचोद चाहसतीन.” ");
INSERT INTO hoy_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","आग लाबान केळदुन, “नींद मजदूरी येन ईत्‍तीत?” याकूब अंदुन, “नी नानी येनु कोळबाळ. लेकीन, नी चाहास्‍या रा नीन जनावरगोळ्‍द आळसोद अदिक देखभाल माळतेला ईराइन: ");
INSERT INTO hoy_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ईंद ना नीन म्यांडा मर्रगोळ बीच दा टु आगकु होळाईन, अदिक जो म्यांडा या मर्र चिट्टीवाळा या चितकबरी ईत्‍तीत, अदिक जो म्यांडा करीद ईतीदाद, अदिक जो मर्र चितकबरी अदिक चिट्टीवाळा ईतीदाद, अवरी ना अलग माळकु ईटाईन; अदिक नान मजदूरी दा अव अच ठहरूस्‍याव. ");
INSERT INTO hoy_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","अदिक याग मुंद नान मजदूरी इन चर्चा नीन मुंद नळदीत, आग धर्म इन ईद गवाही आदीत; मतलब मर्रगोळ दा टु जो यातोदारा न चिट्टीवाळा न चितकबरी ईरूल, अदिक म्यांडागोळ दा टु जो करीद ईला ईरूल, अगर नान हाती होळतद रा काळ्लपनी इन ठहरूसीत.” ");
INSERT INTO hoy_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","आग लाबान अंदुन, “ठीक आद नी ह्‍यांग चाहसत्‍या हांग अच माळ.” ");
INSERT INTO hoy_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","अत: आव अदा दिशी सप्‍पा धारीवाळा अदिक चितकबरे व्‍हातगोळ, अदिक सप्‍पा चिट्टीवाळा अदिक चितकबरी मर्रगोळी, मतलब अऊर दा थ्‍वाळासा चमकदार ईरोद, अवरी अदिक सप्‍पा करेव म्यांडागोळ इक भी अलग माळकु तान पार उन कय दा सौप्स बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","आग आव तान अदिक याकूब उन बीच दा मुर दिन इन यात्रा अन दुरी माळ कोंडुन. ईग याकूब लाबान उन मीकदव म्यांडा मर्रगोळ्द झुंड इक आळस्ली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","येनारा समय इन बाद्‍दा याकूब चिनार, बादाम अदिक अर्मोन इन मार्र इन डगालगोळ हुडुकु अऊर्द स्‍याक्‍का छिल्‍सकु अऊर मा बिळीद धारगोळ माळदुन ईदुर देल आ डगालगोळ बुळ्‍क बिळीद भाग कांळ्सली कुर्त. ");
INSERT INTO hoy_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","बाक याकूब ई छळीगोळ इक डोंगीगोळ दा सजुस बुट्‍टुन, येल म्यांडागोळ नीर कुडुतोगोव, आग आव मर्रगोळ गाबन आदव, ");
INSERT INTO hoy_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","अदिक याग पाड्‍डा आगतोगोव रा अव धारीयुक्‍त, चित्‍तीयुक्‍त या धब्‍बायुक्‍त आगतोगोव. ");
INSERT INTO hoy_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकूब अवरी अलग माळतोगोन, अदिक लाबान उन म्यांडा मर्रगोळ बाय इक चिट्टीवाळा अदिक सप्‍पा करेव पाड्‍डा दी माळ कोंडुन; अदिक तान झुंडगोळी अऊर से अलग ईटदुन, अदिक लाबान उन म्यांडा मर्रगोळ से सीक गोटीदील. ");
INSERT INTO hoy_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","अदिक याग याग ताकतवर म्यांडा मर्रगोळ गाबन आगतोगोव, आग आग याकूब आ छळीगोळी कठौता दा अऊर मुंद ईट बुळतोगोन; यदुर देल अव छळीगोळ इक नोळतेला अच गाबन आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","लेकीन याग अऊर सांगुळ निर्बल म्यांडागोळ ईरतोगोव, आग आव अव छळीगोळ अऊर हाती ईला ईटतोगोन. परिणाम स्‍वरूप सप्‍पा कमजोर म्यांडागोळ लाबान उन सशक्‍त म्यांडा याकूब उन पक्ष दा होट बरतोगोव. ");
INSERT INTO hoy_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","इदुरसाटी याकूब हापाळ धनवान आगेदुन, आऊन हाती हापाळ म्यांडा मर्रगोळ दास दासीगोळ ऊँट अदिक गधा भी ईरव. ");
INSERT INTO hoy_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","याकूब उन कीव मा ईद समाचार बत्‍त कि लाबान उन पार बळबुळसोन, “याकूब रा अद सप्‍पा हळपुस बुट्‍टुन, जो नाम आप्‍प उन ईरोद अदिक ईग आव नाम आप्‍प उन धन-संपत्‍ती इन आधार मा परिपुर्ण बनस्‍कु कुरतान.” ");
INSERT INTO hoy_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","अदिक याकूब लाबान उन चेहरा नोळदुन अदिक व्यव्हार जान्स कोंडुन, कि आव आऊन प्रती पयला अन घाई हैलेच. ");
INSERT INTO hoy_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","आग यहोवा याकूब से अंदुन, “तान आप्‍प दादागोळ द्‍याश अदिक तान जनम भूमी इक होटोग, अदिक ना नीन सांगुळ ईराईन.” ");
INSERT INTO hoy_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","आग याकूब राहेल अदिक लियाह अक, मैदान दा तान म्यांडा मर्रगोळ हाती कारसुसकु अंदुन, ");
INSERT INTO hoy_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","नीम आप्‍प उन चेहरा देल समझ बरतद, कि आव रा नानी पयले अन घाई ईग नोळालुन; लेकीन नान आप्‍प उन परमेश्वर नान सांगुळ आन. ");
INSERT INTO hoy_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","अदिक नीव भी जान्‍सतीर, कि ना नीम आप्‍प उन स्यावा माळीन. ");
INSERT INTO hoy_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","तरी भी नीम आप्‍प नान से छल माळकु नान मजदुरी इक हत्‍त घन बदलुस बुट्‍टुन; लेकीन परमेश्वर आऊक नान नुकसान माळ गोटीदील. ");
INSERT INTO hoy_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","याग नीन आप्‍प अंदुन, चिट्टीवाळा पाड्‍डागोळ नीन मजदुरी आदव, आग सप्‍पा मर्र, म्यांडागोळ चिट्टीवाळा अच हाळुली कुरतव, अदिक याग आव अंदुन, धारीवाळा पाड्‍डा नीन मजदुरी ठहरूसेव, आग सप्‍पा मर्र म्यांडागोळ धारीवाळा हाळुली कुरतव. ");
INSERT INTO hoy_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ईद रीति देल परमेश्वर नीम आप्‍प उन जनावर हुडुकु नानी कोट्‍ट बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","मर्र म्यांडागोळ्‍द गाबन आगा समय ना कांसा दा येन नोळदीन, कि जो व्हात मर्रगोळ मा येरव, अव धारीवाळा, चिट्टीवाळा, अदिक धब्‍बावाळा हूँ. ");
INSERT INTO hoy_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","आग परमेश्वर उन दूत कांसा दा नान से अंदुन, “हे याकूब,” ना अंदीन, “येन आग्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","आव अंदुन, “कण्‍ण नेगुकु आ सप्‍पा व्हातगोळी जो मर्रगोळ मा येरीत्‍याव, नोळ, कि अव धारीवाळा, चिट्टीवाळा, अदिक धब्‍बावाळा हूँ; यतिकी जो येनारा लाबान नीन से माळतान, अद ना नोळीन. ");
INSERT INTO hoy_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ना आ बेतेल इन परमेश्वर हुईन, येल नी ऊंद कल्ल इन खंबा मा याण्‍णा हाक्‍क कोंडीद अदिक नांद मन्नत मानसीद. ईग नी, ई द्‍याश टु होटकु तान जनम भूमी इक होटोग.” ");
INSERT INTO hoy_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","आग राहेल अदिक लियाह आऊन से अंदुर, “येन नाम आप्‍प उन मान्‍या ईग भी नाम येनारा भाग या अंश मिक्‍कु आद? ");
INSERT INTO hoy_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","येन नाव आऊन नजर दा पराया ईला ठहरूसेव? नोळ, आव रा नामी मार्र कोंडुन, अदिक नाम पैस्यागोळ इक तिनकु कुरतान. ");
INSERT INTO hoy_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","इदुरसाटी परमेश्वर नाम आप्‍प उन याट धन ताकोम कोंडान, अद नाम्‍द, अदिक नाम चिकोर्द हुन; ईग जो येनारा परमेश्वर नीन से अंदान, अदा माळ.” ");
INSERT INTO hoy_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","आग याकूब तान चिकोरी अदिक तान हिंग्‍सुरी ऊँटगोळ मा कुर्सदुन; ");
INSERT INTO hoy_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","अदिक यास जनावरगोळ इक जो पद्‍दनराम दा जमा माळकु धनवान आगीदुन, आ सप्‍पा अक कनान दा तान आप्‍प इसहाक उन हाती होगोद इच्‍छा देल, सांगुळ ओतुन. ");
INSERT INTO hoy_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","लाबान रा तान म्यांडा अन चुट्टीगोळ कडोर साटी होटोगीदुन, अदिक राहेल तान आप्‍प उन मान्‍यागोळ द्यावगोळी कदुकु ओतुन. ");
INSERT INTO hoy_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","अत: याकूब लाबान अरामी इन हाती काळ्‍लपणी देल होटोदुन, अदिक आऊक हेळीदिल कि ना ओळेतीन. ");
INSERT INTO hoy_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","आव तान सप्‍पा येनारा हुडुकु ओळदुन, अदिक महानदी इन आप्पाटी ईळुकु तान बाय गिलाद इन पहाळी‍ द्‍याश दी माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीसरा दिशी लाबान उक समाचार सिक्‍त कि याकूब ओळेग्‍यान. ");
INSERT INTO hoy_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","इदुरसाटी आव तान वार्टगोळ सांगुळ आऊन येळ दिन ताका पीछा माळदुन, अदिक गिलाद इन पहाळी द्‍याश दा आऊक होगकु मिलुसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","आग परमेश्वर ईळ्‍ल्‍क इन कांसा दा अरामी लाबान उन हाती होगकु अंदुन, “सावधान ईर, नी याकूब से न रा भला अनेत अदिक न बुरा.” ");
INSERT INTO hoy_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","याकूब उन ड्‍यारा गिलाद हेसुर इन पहाळी द्‍याश दा निदरूसकु बिदकु ईरोद; अदिक लाबान भी तान वार्ट उन सांगुळ तान ड्‍यारा अदा पहाळी द्‍याश दा नीदरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","आग लाबान याकूब से अनली कुरतुन, “नी ईद येन माळ्‍द, कि नान हाती टु काळ्‍लपनी देल होटबंद, अदिक नान पोरगोळी हिंग तनकोंड, ह्‍यांग यावारा तलवार इन ताकत देल बंदी माळकु आगीदार? ");
INSERT INTO hoy_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","नी यती होचकुमकु ओळकु बंद, अदिक नान से बिना येनु अनकु नान हाती टु काळ्‍लपनी देल होटबंद; ना रा नीनी आनन्‍द इन सांगुळ टापटी अदिक विणा मुर्सतेला, अदिक हाळ हाळतेला सार माळायदीन? ");
INSERT INTO hoy_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","नी रा नानी तान पोर-पारगोळी भी चुम्‍स गोटीदील? नी ईद मुर्खता माळ्‍द. ");
INSERT INTO hoy_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","नीम लॉकुर्द नुकसान माळोद ताकत नान कय दा रा आद; लेकीन नीम आप्प उन परमेश्वर नान से होत आ ईळ्लकी अंदुन, ‘सावधान! नी याकूब से येनु बुरा भला अनबाळेत.’ ");
INSERT INTO hoy_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","वळ्लीद आद, नीनी तान आप्‍प उन हाती ईरोद इच्‍छा आद, मान्‍स कोंडीन; लेकीन येन जरवत ईरोद नीमी नान मान्यागोळोव द्यावगोळी कदोद?” ");
INSERT INTO hoy_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","आग याकूब लाबान उक उत्‍तर कोट्‍टुन, “ना ईद सोचकु अंजेगीदिन, कि नी नान से तान पोरगोळी कसु कोमाईद. ");
INSERT INTO hoy_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","यार हाती भी नी तान द्‍यावगोळी नोळ्‍या, आव जीत्‍ता ईरतीदील. नान हाती नींद जो येनारा भी होट्‍टीत, अदरी वार्टुर मुंद अरूकु हुडुकोम.” यतिकी याकूब ईला जानसोन कि राहेल मान्‍यागोळोव द्यावगोळी कदुकु तंदार. ");
INSERT INTO hoy_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ईद केळकु लाबान, याकूब अदिक लियाह अदिक येढ्‍ढु दासीगोळ ड्‍यारा दा होदुन; अदिक येनु सिकीदिल. आग लियाह अन ड्‍यारा दा टु होटकु राहेल इन ड्‍यारा दा होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल रा मान्‍यागोळ द्यावगोळी ऊँट इन जीन मा ईटकु अदुर्द बेन मा कुर्तकु ईरोर. लाबान आकिन पुरा ड्‍यारा दा नोळदुर मा भी सीकिदील. ");
INSERT INTO hoy_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राहेल तान आप्‍प उन से अंदुर, “हे नान प्रभु; नी सिट्‍टी बरबाळ. ना नीन हाती नीदरा लायक हैलेच; यतिकी ना ई समय व्‍हार्या आगीन.” आग लाबान उन ढुंढस्‍दुर मा भी आऊक अव मान्‍यागोळोव द्यावगोळ सिक सकीदील. ");
INSERT INTO hoy_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","आग याकूब सिट्‍टी बंदकु लाबान से झगळा माळली कुरतुन, अदिक आऊन से अंदुन, “नांद येन अपराध आद?” नांद येन पाप आद, कि नी ईट सिट्‍टी बंदकु नांद पीछा माळ्‍द? ");
INSERT INTO hoy_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","नी जो नांद पुरा सामान इक ढुंढस्‍कु नोळ्‍द, रा नीनी नीन मान्‍यागोळ्‍द सामान दा टु येन सिक्‍त? येनारा सिकीदाद रा अदरी ईल नान अदिक तान वार्टुर्द मुंद ईट बुळ, अदिक आंदुर नाम येढ्‍ढु बीच दा न्‍याय माळुल. ");
INSERT INTO hoy_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ई ईप्‍पत वर्षगोळ टु ना नीन हाती ईत्‍तीन; इटुर दा रा ना नीन मर्र म्यांडागोळ्‍द गर्भ ईळुत, अदिक न नीन म्यांडागोळ मास ना यागलु तिनदीदील. ");
INSERT INTO hoy_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","यवरी आळी दाकळव जनावरगोळ कोन्‍नोव अवरी ना नीन हाती तरतोगीन, अऊर्द नुकसान नाच नेगुतोगीन; बाक हागुलीन वती चोरी आगोद या ईळ्‍ल्‍क इन वती, नी नान से अच अऊर नुकसान ताकोमतोग्‍या. ");
INSERT INTO hoy_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","नांद रा ईद दशा ईरोद कि हागुल इन वती पसीना अदिक ईळ्‍ल्‍क इन वती सोळ नानी तीन कोम्‍त; अदिक जप नान कण्‍णगोळ दा टु ओळेगोद. ");
INSERT INTO hoy_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ईप्‍पत वर्ष ताका ना नीन मान्‍या ईत्‍तीन; चौदह वर्ष रा ना नीन येढ्‍ढु पोरगोळ साटी नींद स्यावा माळदीन अदिक आर वर्ष नीन मर्र म्यांडागोळ साटी, अदिक नी नान मजदुरी इक हत्‍त घन बदलुस बुट्‍ट. ");
INSERT INTO hoy_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","“नान आप्‍प उन परमेश्वर मतलब अब्राहम उन परमेश्वर, यार्द अंज्क इसहाक भी ईटतान, अगर नान दी ईला ईरायदुन, रा सही दा नी ईग नानी खाली कय होग गोळाईद. नान दुख अदिक नान कय इन मेहनत नोळकु परमेश्वर होत आ ईळ्‍ल्‍की नान मा चिल्‍ळासदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ईद मात केळकु लाबान याकूब उक ईद उत्‍तर कोट्‍टुन, “ई आर्तेर नान पोरगोळ हुळ, ई चिकोर नान चिकोर हुळ, ई मर्र म्यांडा भी नानव अच हूँ अदिक जो येनारा नीनी कांळ्सीत्‍याद, अद नांद अच हुन; लेकीन ईग ना तान पोरगोळ अदिक ई चिकोर्द येन माळाईन, जो ईंदुर्द औलाद हुन? ");
INSERT INTO hoy_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ईग बा, ना अदिक नी येढ्‍ढु मुंदुर आपस दा वादा माळाता, अदिक अद नींद अदिक नान बीच दा कसम ठहरूसकु ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","आग याकूब ऊंद कल्‍ल हुडुकु अदुर्द ऊंद खंबा नीदरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","आग याकूब तान लॉकुर से अंदुन, “कल्‍लगोळ जमा माळी,” ईद केळकु आंदुर कल्‍लगोळ जमा माळकु ऊंद ढेर हचदुर अदिक अदा ढेर इन हाती आंदुर ऊंडुर. ");
INSERT INTO hoy_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","आ ढग इन हेसुर लाबान रा यज्र सहादूधा ईटदुन, लेकीन याकूब गिलियाद ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान अंदुन, “ईद ढेर ईंद टु नीन अदिक नान बीच दा कसम ईत्‍तीत.” ईद कारण अदुर हेसुर गिलियाद ईटकु आत, ");
INSERT INTO hoy_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","अदिक मिस्पा भी; यतिकी आव अंदुन, “याग नाव आबुर दाबुर से दूर ईत्‍तेव आग यहोवा नांद अदिक नींद देखभाल माळतेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","अगर नी नान पोरगोळी दुख कोट्या, या आंदुर सिवाय अदिक आर्तेर सांगुळ मदा माळ्‍या, रा नाम सांगुळ याऊ मंळसा रा ईरतीदील; लेकीन नोळ नीन अदिक नान बीच दा परमेश्वर गवाह ईत्‍तान.” ");
INSERT INTO hoy_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","बाक लाबान याकूब से अंदुन, “ई ढेर इक नोळ अदिक ई कल्ल इन खंबा अक भी नोळ, यारी ना तान अदिक नीन बीच दा नीदरूस्‍यान. ");
INSERT INTO hoy_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ईद ढेर अदिक ईद खंबा येढ्‍ढु ई मात इन गवाह ईरूल कि नुकसान माळोद इच्‍छा देल न रा ना ई ढेर इक नाहाकुसकु नीन हाती होगाईन, न रा नी ई ढेर अदिक ईद कल्ल इन खंबा अक नाहाकुसकु नान हाती बंद्‍या. ");
INSERT INTO hoy_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहम अदिक नाहोर अदिक आंदुरव आप्‍प; मुरू मुंदुरव जो परमेश्वर आन, आवा नाम येढ्‍ढु मुंदुर बीच दा न्‍याय माळुल.” आग याकूब आऊन कसम तिंदुन यार्द अंज्‍क आऊन आप्‍प इसहाक ईटतोगोन. ");
INSERT INTO hoy_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","अदिक याकूब आ पहाळी मा ऊंद जनावर इक हुळकु बलि येर्सदुन, अदिक तान वार्टुरी ऊमोद तीन्‍सदुन, आग आंदुर भोजन माळकु पहाळी मा ईळ्‍ल्‍क कळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","व्‍हातर्याका लाबान येद्‍दुन, अदिक तान पोर पारगोळी चुम्‍सकु अदिक आशीर्वाद कोटकु होट्‍टुन अदिक तान जागा अक वापस होट्‍ट बंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकूब भी तान हादी हुळदुन अदिक परमेश्वर उन दूत आऊक बंदकु सिकदुर. ");
INSERT INTO hoy_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","आंदरी नोळतेला अच याकूब अंदुन, “ईद रा परमेश्वर उन दल हुन.”इदुरसाटी आव आ जागा अन हेसुर महनैम ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","आग याकूब सेईर द्‍याश दा, मतलब एदोम द्‍याश दा, तान वार्ट एसाव उन हाती तान मुंद ऊंद खबरीगोळ इक कळुदुन. ");
INSERT INTO hoy_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","अदिक आव आंदरी आग्‍या कोट्‍टुन, “नान प्रभु एसाव से ईद अनेत; कि नीन दास याकूब नीन से ईद अनतान, कि ना लाबान उन मान्‍या परदेशी आगकु ईगासताका ईत्‍तीन; ");
INSERT INTO hoy_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","अदिक नान हाती वस्‍ता-गोसी, गधा, मर्र-म्यांडा, अदिक दास-दासीगोळ आर अदिक ना तान प्रभु उन हाती इदुरसाटी बातणी कळीन कि नीन अनुग्रह अन नजर नान मा ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","आ खबरीगोळ याकूब उन हाती वापस बंदकु अनली कुरतुर, “नाव नीन वार्ट एसाव उन हाती होगीदेव, अदिक आव भी नीन सांगुळ मुलाकात माळोर साटी नाक सौ लॉकुर सांगुळ बरेत्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","आग याकूब हापाळ अंजेदुन, अदिक संकट दा बिदोदुन: अदिक ईद सोचकु, तान साथीगोळ सांगुळ, मर्र म्यांडागोळ, अदिक वस्‍ता गोसीगोळ, अदिक ऊँटगोळ भी अलग अलग माळकु येढ्‍ढ दल माळदुन, ");
INSERT INTO hoy_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","कि अगर एसाव बंदकु पयला दल इक बडोद चालु माळ्‍यान, रा दुसरा दल ओळकु ऊळदोदीत. ");
INSERT INTO hoy_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","बाक याकूब अंदुन, “हे यहोवा, हे नान आजा अब्राहम उन परमेश्वर, हे नान आप्‍प इसहाक उन परमेश्वर, नी रा नान से अंदिद कि तान द्‍याश अदिक जनम भूमी दा वापस होटोग, अदिक ना नींद भलाई माळाईन: ");
INSERT INTO hoy_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","नी जो जो क्‍याल्‍सा तान करूणा अदिक सच्‍चाई देल तान दास इन सांगुळ माळ्‍या, कि ना जो तान छळी इक अच हुडुकु यरदन गांगा इन आप्पाटी ईळदीन, अदिक ईग नानव येढ्‍ढ दल आगेग्‍याव, नी ईत्‍ता ईत्‍ता क्‍याल्‍सा दा टु ऊंद इन भी लायक रा हैलेच. ");
INSERT INTO hoy_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","नान विनती केळकु नान वार्ट एसाव उन कय देल नानी ऊळ्‍स ना रा आऊन से अंजतीन, यागलु हिंग आग बाळुल कि आव बंदकु नानी अदिक मोय इन सांगुळ चिकोरी भी कोंद कोमुल. ");
INSERT INTO hoy_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","नी रा अंद्‍या, कि ना सही दा नीन भलाई माळाईन, अदिक नीन वंश इक समुद्र अन धुळाकणगोळ घाई हापाळ वाळुसाईन, जो हापाळ संख्‍या अन कारण आळुकु आगतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","आव आ दिन इन ईळ्‍ल्‍क अल्‍या ईत्‍तुन; अदिक जो येनारा आऊन हाती ईरोद अदुर दा टु तान वार्ट एसाव उक भेंट कोळोर साटी छाट्‍स छाट्‍सकु तेगदुन; ");
INSERT INTO hoy_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","मतलब येढ्‍ढ सौ मर्रगोळ, अदिक ईप्‍पत व्‍हातगोळ, अदिक येढ्‍ढ सौ म्यांडागोळ, अदिक ईप्‍पत म्यांडा, ");
INSERT INTO hoy_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","अदिक पाड्डागोळ सांगुळ हाल कोळावाळा तीस ऊँटनीगोळी, अदिक चालीस गोसी, अदिक हत्‍त वस्‍ता, अदिक ईप्‍पत गधागोळी अदिक अदुरव ईप्‍पत पाड्‍डा. ");
INSERT INTO hoy_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ईवरी आव झुंड माळकु, तान दासगोळी कोटकु आंदुर से अंदुन, “नान मुंद होगी; अदिक झुंडगोळ बीच दा अंतर ईटी.” ");
INSERT INTO hoy_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","बाक आव दुसरा झुंडवाळा अक ईद आग्‍या कोट्‍टुन, “याग नान वार्ट एसाव नीनी सिक्‍यान, अदिक केळली कुरतान, ‘नी यार दास हुय, अदिक अंदकु आगतद, अदिक ईंदुर नीन मुंद मुंद आर, आंदुर यारोर हुळ.’” ");
INSERT INTO hoy_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","आग अनेत, “ईव नीन दास याकूब उन हु. हे नान प्रभु एसाव, ईव भेंट नीन इक कोळोर साटी नीन हाती कळुकु आग्‍याव, अदिक आव खुद भी नाम हिंद हिंद बरेत्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","याकूब ईदा मात दुसरा अदिक तिसरा अदिक आ सप्‍पा से अंदुन, जो आंदुर हिंद हिंद बरोर. हिंग अच आग्या कोट्टुन कि याग एसाव नीम इक सिकुल आग ईदा प्रकार देल आऊन से अनेतीर. ");
INSERT INTO hoy_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","नीव ईद अनेतीर, “नीन वार्ट याकूब हिंद बरेत्‍यान.” यतिकी याकूब सोचदुन कि, “ईस भेंट कोटकु ना एसाव उक खुश माळ बुळाईन. ईदुर बाद्‍दा ना आऊन सांगुळ होगाईन, आग जरूर, आव नानी माफ माळ कोंडान.” ");
INSERT INTO hoy_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","इदुरसाटी अद झुंड इन भेंट याकूब उन से पयला आपाटी ईळुत, अदिक आव खुद आ ईळ्लक इक ड्यारा दा ईत्तुन. ");
INSERT INTO hoy_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","अदा ईळ्‍ल्‍की आव येद्‍दुन अदिक तान येढ्‍ढु हिंग्‍सुर, अदिक येढ्‍ढु दासीगोळ, अदिक हनुन चिकोरगोळी सांगुळ हुडुकु घाट दा टु यब्बोक गांगा अन्द आप्पाटी ईळदोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","याकूब सप्‍पा मुंदरी गांगा अन्द आप्पाटी कळु कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","अदिक याकूब अल्‍या रूकसेदुन. ऊंद आरी अल बंदकु व्‍हातुर ताका आऊन से मल्‍लयुद्ध माळतेला ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","याग आ आरी नोळदुन कि आव याकूब उक हारूस सकालुन आग आव याकूब उन जांघ इन नस इक मुटदुन अदिक मल्‍लयुद्ध माळ्‍त माळ्‍त अच आऊन नस येरेत. ");
INSERT INTO hoy_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ईद आगदुर मा आ मंळसा याकूब से अंदुन, “ईग नानी होगगोळ.” लेकीन याकूब आ मंळसा से अंदुन, “ईला. ना नीनी आगासताका होगगोळालीन, यागासताका नी नानी आशीष कोळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","आग आव याकूब से केळदुन, “नींद हेसुर येन आद?” आव अंदुन, “याकूब.” ");
INSERT INTO hoy_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","आग आ मंळसा आऊन से अंदुन, “ईग टु नींद हेसुर याकूब ईला बल्‍की इस्त्राएल ईत्‍तीत, यतिकी परमेश्वर से अदिक मंळसागोळ से मेहनत माळतेला नी जीकसेग्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","आग याकूब आ मंळसा से अंदुन, “कृपया नी नानी तान हेसुर हेळ.” आ मंळसा उत्‍तर कोट्‍टुन, “येन माळ्‍या नान हेसुर जान्‍सकु?” अदिक आग आ मंळसा अल्‍या याकूब उक आशीष कोट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","आग याकूब ईद अनकु आ जागा अन हेसुर पनीएल ईटदुन; “परमेश्वर उक आमने सामने नोळदुर मा भी नान जीव ऊळदोत.” ");
INSERT INTO hoy_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","पनीएल इन हाती टु नळुत नळुत सूर्य उदय आगेत, अदिक आव जाँघ इन नस यरदुर देल लंगळुसतोगोन. ");
INSERT INTO hoy_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ई घटना अक याद माळतेला इस्त्राएल वंश ईंद ताका जाँघ इन पुट्‍टा अन मांसपेशी इक तिनालुर यतिकी ईदा मांसपेशी मा याकूब उक दुख आगीत. यतिकी आ मंळसा याकूब उन जाँघ इक मुटीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","अदिक याकूब कण्‍ण नेगुकु ईद नोळदुन, कि एसाव नाक सौ लॉकुर सांगुळ बरेत्‍यान. आग आव चिकोरी अलग-अलग वाट्‍सकु लियाह अदिक राहेल अदिक येढ्‍ढु दासीगोळ इक सौप्स बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","अदिक आव सप्‍पा मुंदुर मुंद पारगोळ सांगुळ दासीगोळी आंदुर हिंद पारगोळ सांगुळ लियाह अक, अदिक सप्‍पा मुंदुर हिंद राहेल अदिक यूसुफ उक ईटदुन, ");
INSERT INTO hoy_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","अदिक खुद आ सप्‍पा मुंदुर मुंद वाळुसदुन अदिक येळ घन धरती मा बिदकु नमस्‍कार माळदुन, अदिक तान वार्टुन हात्ती पोहचुसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","आग एसाव आऊन से भेंट माळोर साटी ओळदुन, अदिक आऊक दिल देल हचकु, याद्दा देल चिपकुसकु चुम्‍सदुन; बाक आंदुर येढ्‍ढु मुंदुर वर्लली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","आग एसाव कण्‍ण नेगुकु आर्तेरी अदिक चिकोरी नोळदुन; अदिक केळदुन, “ईंदुर जो नीन सांगुळ आर आंदुर यार उर?” आव अंदुन, “ईंदुर नीन दास उन चिकोर उर, यारी परमेश्वर अनुग्रह माळकु नानी कोटान.” ");
INSERT INTO hoy_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","अदिक दासीगोळ तान तान चिकोरगोळ सांगुळ हाती बंदुर अदिक बांगकु नमस्‍कार माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","हांग अच लियाह भी तान चिकोरगोळ सांगुळ हाती बंदुर, आक भी बांगकु नमस्‍कार माळदुर अदिक बाक राहेल इन सांगुळ यूसुफ भी बंदुन अदिक नमस्‍कार माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसाव याकूब से केळदुन, “ईद धोळ दल, गोसी नानी येती कोट्‍ट, समझ दा बंदीदिल.” याकूब अंदुन, “नान स्वामी, ना ईदुर द्वारा नींद अनुग्रह ताकोमोद चाहसतीन.” ");
INSERT INTO hoy_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","एसाव अंदुन, “हे नान वार्टा नान हाती सब येनारा आद. अदिक जो भी नींद आद, अदरी तांद अच हाती ईरगोळ.” ");
INSERT INTO hoy_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकूब अंदुन, “ईला! अगर नींद अनुग्रह नान मा आद, रा नान दी टु ई भेंटगोळी स्‍वीकार माळ कोम; यतिकी नीनी नोळकु हत्‍त कि ना परमेश्वर उन दर्शन माळ कोंडीन, अदिक नी नानी दिल देल स्‍वीकार भी माळ्‍द. ");
INSERT INTO hoy_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","इदुरसाटी ईद भेंट जो नीनी कळुकु आग्‍याद, ग्रहण माळ; यतिकी परमेश्वर नान मा अनुग्रह माळ्‍यान, अदिक नान हाती हापाळ आद.” याग आव आऊन से हापाळ विनती माळदुन, आग आव भेंट इक ग्रहण माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","बाक एसाव अंदुन, “बर, नाव मुंद होगाता: अदिक ना नींद मुंद मुंद नळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","याकूब अंदुन, “हे नान प्रभु, नी जान्सत्‍या कि नान सांगुळ स्यांण पारगोळ, अदिक म्यांडा मर्रगोळ अदिक गोसी जो हाल कोळावाळा आव, अगर ईत्‍ता जनावर ऊंद दिन भी येक्‍कुल नळ्सकु आदाव, रा सप्‍पा च्‍या सप्‍पा सोतोदव. ");
INSERT INTO hoy_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ईदुर साटी नान प्रभु तान दास से मुंद होटुगुल, अदिक ना ई जनावरगोळ गती अन अनुसार, जो नान मुंद आद, अदिक चिकोर्द गती इन अनुसार धीरा धीरा नळुकु सेईर नगर दा तान प्रभु उन हाती पोहचुसाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","आग एसाव याकूब से अंदुन, “ना तान संगीगोळी नीन हाती बिट्ट बुळतीन.” आग याकूब अंदुन, “येन ईदुर्द जरवत आद? नान मा नान प्रभु स्वामी इन अनुग्रह बन्सकु ईरूल, ईदा काफी आद.” ");
INSERT INTO hoy_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","इदुरसाटी एसाव अदा दिशी सेईर नगर इक होटोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","याकूब सुक्कोत इन दिशा दा मुंद वाळुसेदुन. अदिक अल तान साटी ऊंद मान्ना, अदिक जनावरगोळ साटी झोपळी माळदुन, ईदा कारण आ जागा अन्द हेसुर सुक्कोत बित्त. ");
INSERT INTO hoy_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","अदिक याकूब जो पद्‍दनराम टु बंदीदुन, आव कनान द्‍याश इन शकेम नगर इन हाती कुशल देल पोहचुस्कु नगर इन मुंद ड्‍यारा निदरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","याता जागा मा आव ड्‍यारा नीदरूसदुन, आ जमीन इक आव शकेम उन आप्‍प, हमोर उन पारगोळ से ऊंद सौ चांदी इन मुद्रागोळ कोटकु कोंडीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","बाक याकूब अल ऊंद वेदी माळदुन, अदिक अदुर हेसुर आव एल-एलोहे-इस्त्राएल ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ऊंद दिशी लियाह अन पोर दीना, जो याकूब से पैदा आगीदुर, आ द्‍याश इन पोरगोळ से मुलाखात माळली होट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","आग आ द्‍याश इन प्रधान हिब्बी हमोर उन पार शकेम आकी नोळदुन, अदिक आकी वोतकु आकिन सांगुळ कुकर्म माळकु आकी भ्रष्‍ट माळ बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","आग आऊन मन याकूब उन पोर दीना से हत्‍तेत. अदिक आव आ पोर इन से प्रेम इन मातगोळ माळदुन, अदिक आकिन से प्रेम माळली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","शकेम तान आप्‍प हमोर से अंदुन, “नान मदा ई पोर इन से माळकु कोळ.” ");
INSERT INTO hoy_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","याग याकूब उक पता हत्‍त कि शकेम आऊन पोर दीना अक खराब माळ बुटान, आ समय आऊन पारगोळ जनावरगोळ सांगुळ मैदान दा ईरोर; इदुरसाटी याकूब आंदुर बरासताका सुंगा ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","आग शकेम उन आप्‍प हमोर याकूब उन सांगुळ मातकात माळोरसाटी आऊन हाती होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","याकूब उन पारगोळ ईद केळतेला अच मैदान टु हापाळ उदास अदिक सिट्‍ट दा बंदुर; यतिकी शकेम याकूब उन पोर इन सांगुळ कुकर्म माळकु इस्त्राएल इन घराना टु मूर्खता अन हिंग क्‍याल्‍सा माळीदुन, यदुर्द माळोद बराबर ईला ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","हमोर आ सप्‍पा से अंदुन, “नान पार शकेम उन मन नीन पोर मा हापाळ आद, इदुरसाटी नीन पोर इक आऊन हिंग्‍स उन रूप दा आऊक कोटबुळ. ");
INSERT INTO hoy_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","नाम सांगुळ वैवाहिक संबंध माळ कोमी नीव नामी तान पोरगोळ कोळी अदिक नाम पोरगोळ नीव ईटी. ");
INSERT INTO hoy_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ई प्रकार नीव नाम सांगुळ ई द्‍याश दा मिलुस्‍कु ईर सक्‍कीर; नीव ई द्‍याश दा ईरी, धंधा माळी अदिक संपत्‍ती हासील माळतेला ईरी.” ");
INSERT INTO hoy_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","अदिक शकेम भी दीना अन आप्‍प अदिक वार्टुर से अंदुन, “अगर नान मा कृपा दृष्‍टी माळेतीर, रा जो येनारा नीव नान से अंदीर, अद ना कोळाईन. ");
INSERT INTO hoy_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","नीव पोर इन साटी जो भी किमत बेळीर अदरी ना पुरा माळाईन. लेकीन नान मदा आ पोर इन से अच माळी.” ");
INSERT INTO hoy_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","आग ईद सोचकु कि शकेम आंदुर आकतींग दीना अक खराब माळदुन, याकूब उन पारगोळ शकेम अदिक आऊन आप्‍प हमोर उक छल इन सांगुळ ईद उत्‍तर कोट्‍टुर, ");
INSERT INTO hoy_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“नाव हिंग क्‍याल्‍सा माळ सकालेव कि यातोदारा खतनारहित मंळसा अक तान आकतींग इक कोट्‍टेव; यतिकी हिंग माळदुर देल नामी हेसुर हुळदार. ");
INSERT INTO hoy_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ई मात मा नाव नीम्‍द मांन्‍स कोंडेव कि नाम घाई नीम दा टु हर ऊंद मंळसा अन खतना माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","आग नाव तान पोरगोळ नीमी मदा साटी कोट्‍टेव, अदिक नीम सांगुळ बसुस्कु भी ईत्‍तेव, अदिक नाव येढ्‍ढु ऊंद अच समुदाय इन मंळसा आगेदेव. ");
INSERT INTO hoy_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","लेकीन अगर नीव नाम मात ईला केळकु तान खतना माळसुसतीदिल, रा नाव तान पोर इक हुडुकु ईल टु होटोदेव.” ");
INSERT INTO hoy_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","आंदुर्द ई मातगोळ मा हमोर अदिक आऊन पार शकेम खुश आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","अदिक आ हारोदव जो याकूब उन पोर इक चाहासोन, ई क्‍याल्‍सा अक माळदुर दा आव समय माळीदिल. आव रा तान आप्‍प उन सप्‍पा घराना दा येक्‍कुल सम्‍मानीत मंळसा ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","इदुरसाटी हमोर अदिक आऊन पार शकेम तान नगर इन फाटक इन हाती होगकु नगरवासीगोळी ईद समझुसली कुरतुर; ");
INSERT INTO hoy_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ई मंळसागोळ रा नाम सांगुळ मेल देल ईरोद चाहसतार; लेकीन आंदरी ई द्‍याश दा ईतकु लेन देन माळगोळी; नोळी, ईद द्‍याश आंदुर साटी भी हापाळ आद; बाक नाव लॉकुर आंदुर पोरगोळी हिंग्‍स माळ सकतेव, अदिक तान पोरगोळ आंदरी कोळ सकतेव. ");
INSERT INTO hoy_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ईंदुर ऊंद अच मात मा नाम सांगुळ ईरोर साटी सहमत आग्‍यार, कि नाम सप्‍पा मंळसागोळ्‍द खतना माळकु आगुल, ह्‍यांग आंदुर्द माळकु आगतद कि नाव सप्‍पा मुंदुर ऊंद आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","येन आंदुरव मर्र म्यांडा, अदिक वस्‍ता गोसी बल्‍की आंदुरव सप्‍पा जनावर अदिक धन-संपत्ती नाम्‍द आगतीदील? ईटा माळी कि नाव लॉकुर आंदुर्द मात मान्‍स कोंडेव, रा आंदुर नाम सांगुळ निसास माळली कुरतार.” ");
INSERT INTO hoy_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","इदुरसाटी यास भी आ नगर इन फाटक टु होळतोगोर, आ सप्‍पा मुंदुर हमोर उन अदिक आऊन पार शकेम उन मात मान्‍सदुर; अदिक हर ऊंद मंळसा अन खतना माळकु आत, यास आ नगर इन फाटक टु होळ तोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीसरा दिशी, याग आ लॉकुर दुख दा बिदकु ईरोर, आग हिंग आत कि शिमोन अदिक लेवी याकूब उन येढ्‍ढु पारगोळ, जो दीना अन वार्टुर ईरोर, तान-तान तलवार हुडुकु आ नगर दा बेधळक होगकु सप्‍पा मंळसागोळी घात माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","हमोर अदिक आऊन पार शकेम उक आंदुर तलवार देल कोंद बुट्‍टुर, अदिक दीना अक शकेम उन मान्‍या टु तेगुकु ओतुर. ");
INSERT INTO hoy_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","अदिक याकूब उन दुसरा चिकोर नगर इक लुट्‍स बुट्‍टुर, यतिकी आंदुर आऊनोर आकतींग इक खराब माळ बुटीदुर. ");
INSERT INTO hoy_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","आंदुर मर्र म्यांडा, अदिक वस्‍ता गोसी, अदिक गधागोळ, अदिक नगर अदिक मैदान दा जो येनारा ईरोद सप्‍पा हुडु कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","आंदुर आंदुर्द सप्‍पा संपत्‍ती मा अधिकार माळकु अदरी लुट्‍स बुट्‍टुर, ईल ताका कि आंदुर आंदुरोर हिंग्‍सुरी अदिक आंदुर चिकोरी बंदी माळकु सप्‍पा येनारा जो आंदुर मान्‍यागोळ दा ईरोद, लुट्‍स बुट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","आग याकूब शिमोन अदिक लेवी से अंदुन, “नीव जो ई द्‍याश इन निवासी कनानीगोळ अदिक परिज्जी अन मन दा नान प्रती सिट्‍ट पैदा माळीर, ईदुर देल नीव नानी मुसीबत दा हाकदीर, यतिकी नान सांगुळ रा थ्‍वाळासा अच लॉकुर आर, इदुरसाटी आंदुर जमा आगकु नान मा चळाई माळ्‍यार, अदिक नानी कोंद बुट्‍टार, रा ना तान घराना अन्द सांगुळ नाश आगेगाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","आंदुर अंदुर, “येन शकेम उक नाम आकतींग इन सांगुळ वेश्‍या अन घाई व्यवहार माळोद वळ्लीद ईरोद?” ");
INSERT INTO hoy_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","आग परमेश्वर याकूब से अंदुन, “ईल टु होटकु बेतेल इक होग, अदिक अल्‍या ईर; अदिक अल परमेश्वर उन साटी वेदी माळ, याव नीनी आ समय दर्शन कोट्‍टुन या समय नी तान वार्ट एसाव उन अंज्‍क देल ओळतोग्‍या.” ");
INSERT INTO hoy_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","आग याकूब तान घराना, अदिक आ सप्‍पा से भी जो आऊन सांगुळ ईरोर, अंदुन, “ई समय नीम हाती जो पराया द्यावगोळ आर, आंदरी दुर माळ बुळी अदिक तान तान इक शुद्ध माळकु तान कपळा बदलुस बुळी. ");
INSERT INTO hoy_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","अदिक बरी, नाव ईल टु होटकु बेतेल इक होगाता; अल ना परमेश्वर उन साटी ऊंद वेदी माळाईन, याव संकट इन दिनगोळ दा नांद केळदुन, अदिक याता हादी देल ना नळु तोगीन, अदुर दा नान सांगुळ ईत्‍तुन.” ");
INSERT INTO hoy_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ईद केळकु आंदुर याकूब उक सप्‍पा पराया द्याव कोट्‍ट बुट्‍टुर, जो आंदुर तान हाती ईटीदुर. ईदुर अलावा कीव इन कुण्‍डगोळ भी कोट्‍टुर. याकूब ई सप्‍पा अक आ बांज मार्र इन ल्‍यालमा नळ्‍सदुन, जो शकेम इन हाती ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","याग आंदुर अल टु होट्‍टुर आग पुरा नगर मा परमेश्वर उन अंज्‍क बिदकु ईरोद. याऊ भी याकूब उन चिकोर्द पीछा माळीदिल. ");
INSERT INTO hoy_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","याकूब आ सप्‍पा मुंदुर सांगुळ जो आऊन सांगुळ ईरोर, कनान द्‍याश इन लूज नगर इक बंदुन. अद नगर इक बेतेल भी अनकु आगतद. ");
INSERT INTO hoy_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","अल आव ऊंद वेदी माळदुन, अदिक आ जागा अन हेसुर एल-बेतेल ईटदुन; यतिकी याग आव तान वार्ट उन अंज्‍क देल ओळतोगोन आग परमेश्वर आऊन मा अल्‍या‍ प्रगट आगीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","अदिक रिबका अक हाल कुळसावळ्‍त दाई दबोरा सोतोदुर, अदिक बेतेल इन बांज मार्र इन हाती आकी मुण्‍ण कोटकु आत, अदिक आ बांज मार्र इन हेसुर अल्‍लोनबक्‍कूत ईटकु आत. ");
INSERT INTO hoy_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","बाक याकूब उन पद्‍दनराम टु बंदुर बाद्‍दा परमेश्वर दुसरा घन आऊक दर्शन कोटकु आशीष कोट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","अदिक परमेश्वर आऊन से अंदुन, “ईगास ताका रा नीन हेसुर याकूब ईत्‍त; लेकीन मुंदु टु नीन हेसुर याकूब ईरतीदील, नी इस्त्राएल कहलुस्‍या.” ई प्रकार आव आऊन हेसुर इस्त्राएल ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","बाक परमेश्वर आऊन से अंदुन, “ना सर्वशक्तिमान प्रभु हुईन. नी फलुस फुलुस अदिक वाळुस; अदिक नीन से ऊंद जाती बल्‍की जातीगोळ्‍द ऊंद धोळ मंडली भी पैदा आदीत, अदिक नीन वंश दा राजा पैदा आदार. ");
INSERT INTO hoy_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","अदिक जो द्‍याश ना अब्राहम अदिक इसहाक उक कोटीन, अदा द्‍याश नीनी कोळतीन, अदिक नीन हिंद नीन वंश इक भी कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","आग परमेश्वर आ जागा दा, येल आव याकूब से मातगोळ माळदुन, आंदुर हाती टु म्‍याकुच येरेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","अदिक या जागा दा परमेश्वर याकूब से मातगोळ हेळदुन, अल याकूब कल्‍ल इन ऊंद खंबा नीदरूसदुन, अदिक अदुर मा अंगुर इन रास्सा अदिक जैतुन इन याण्‍णा हाक्‍क बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","येल परमेश्वर याकूब से मातगोळ माळदुन, आ जागा अन हेसुर आव बेतेल ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","बाक आंदुर बेतेल टु नळोद चालु माळदुर; अदिक एप्राता नगर थ्वाळासा अच दुर ईरोद कि राहेल इक पार हाळोद दुख सिकली कुर्त. ");
INSERT INTO hoy_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","याग आकी हापाळ दुख येळतोगोद आग दाई आकिन से अंदुर, “अंजबाळ; ईग भी नीनी पार अच आदीत.” ");
INSERT INTO hoy_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","आग हिंग आत कि आक सोतोदुर, अदिक जीव होळ्‍त-होळ्‍त आक आ पार उन हेसुर बेनोनी ईटदुर; लेकीन आऊन आप्‍प आऊन हेसुर बिन्यामीन ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","अदिक राहेल सोत्‍तुर, अदिक एप्राता, मतलब बैतलहम हादी दा, आकी मुण्‍ण कोटकु आत. ");
INSERT INTO hoy_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","अदिक याकूब आकिन कब्र मा ऊंद खंबा नीदरूसदुन: राहेल इन कब्र अन अद खंबा ईंद ताका बन्सकु आद. ");
INSERT INTO hoy_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","बाक इस्त्राएल तान यात्रा चालु माळदुन अदिक एदेर हेसुर इन गुम्‍मट इन मुंद तान ड्‍यारा नीदरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","याग याकूब आ द्‍याश दा ईरोन, आग ऊंद दिशी हिंग आत कि रूबेन होगकु तान आप्‍प उन रखैल बिल्हा अन सांगुळ कुकर्म माळदुन; अदिक ईद मात इस्त्राएल उक मालुम आत. याकूब उक हनुन पारगोळ ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","अदुर दा टु लियाह अन चिकोर ईंदुर ईरोर; मतलब याकूब उन धोळ पार रूबेन, बाक शिमोन, लेवी, यहूदा, इस्साकार, अदिक जबूलून. ");
INSERT INTO hoy_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","अदिक राहेल इन चिकोर ईंदुर ईरोर; मतलब यूसुफ, अदिक बिन्यामीन. ");
INSERT INTO hoy_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","अदिक राहेल इन दासी बिल्हा अन चिकोर ईंदुर ईरोर; मतलब दान, अदिक नप्ताली. ");
INSERT INTO hoy_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","अदिक लियाह अन दासी जिल्‍पा अन चिकोर ईंदुर ईरोर : मतलब गाद, अदिक आशेर. याकूब उन इंदुर अच चिकोर आदुर, जो आऊन से पद्‍दनराम क्षेत्र दा पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","अदिक याकूब मम्रे दा, जो किर्यतर्बा, मतलब हेब्रोन हुन, येल अब्राहम अदिक इसहाक परदेशी आगकु ईतीदुर, तान आप्‍प इसहाक उन हाती बंदुर. ");
INSERT INTO hoy_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक उन ऊमर ऊंद सौ अस्‍सी वर्ष इन आत. ");
INSERT INTO hoy_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","अदिक इसहाक उन जीव बीटोत, अदिक आव सोतोदुन, अदिक आव बाट्‍ट अदिक पुरा ऊमर इन आगकु तान लॉकुर दा होगकु सीकेदुन; अदिक आऊन पार एसाव अदिक याकूब आऊक मुण्‍ण कोट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव जो एदोम भी कहलुसतान, आऊन ईद वंशावली हुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसाव रा कनानी पोरगोळ सांगुळ मदा माळदुन; मतलब हित्ती एलोन इन पोर आदा अक, अदिक ओहोलीबामा अक जो अना अन पोर, अदिक हिब्बी सिबोन इन नाती ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","बाक आव इश्‍माएल इन पोर बासमत इक भी, जो नबायोत इन आकतींग ईरोर, मदा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","आदा रा एसाव उन द्वारा एलीपज उक, अदिक बासमत रूएल उक जनम कोट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","अदिक ओहोलीबामा यूश, अदिक यालाम, अदिक कोरह उक पैदा माळदुर, एसाव इन ईंदुर अच चिकोर कनान द्‍याश दा पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","एसाव तान हिंग्‍सुर, अदिक पोर-पारगोळ, अदिक मान्‍यागोळोव सप्‍पा जनावरगोळ, अदिक तान मर्र-म्यांडा; अदिक वस्ता गोसी पयला सप्‍पा जनावरगोळ, अदिक तान सप्‍पा सम्पती इक, जो आव कनान द्‍याश दा जमा माळीदुन, हुडुकु तान वार्ट याकूब उन हाती टु दुसरा द्‍याश इक होटोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","यतिकी आंदुर्द सम्पती ईट आगेगीत, कि आंदुर तान सांगुळ ईला ईट सकोर; अदिक हापाळ जनावरगोळ कारण आ द्‍याश दा, येल आंदुर परदेशी आगकु ईर तोगोर, अव समुस सकीदील. ");
INSERT INTO hoy_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","एसाव जो एदोम भी कहलुसतद, सेईर हेसुर इन पहाळी द्‍याश दा ईरली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेईर हेसुर इन पहाळी द्‍याश दा ईरावाळेर एदोम उन मूल मंळसा एसाव इन वंशावली ईद हुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसाव उन पारगोळ हेसुर ईव हू; मतलब एसाव उन हिंग्‍स आदा अन पार एलीपज, अदिक एसाव उन हिंग्‍स बासमत उन पार रूएल. ");
INSERT INTO hoy_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","अदिक एलीपज उन ई पारगोळ आदुर; मतलब तेमान, ओमार, सपो, गाताम, अदिक कनज. ");
INSERT INTO hoy_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसाव उन पार एलीपज उन तिम्‍ना हेसुर इन ऊंद रखैल ईरोर, याक एलीपज इन द्वारा अमालेक इक जनम कोट्टुर: एसाव उन हिंग्‍स आदा अन वंश दा ईंदुर अच पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रूएल इन ई पारगोळ आदुर; मतलब नहत, जेरह, शम्‍मा, अदिक मिज्‍जा एसाव उन हिंग्‍स बासमत इन वंश दा ईंदुर अच पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ओहोलीबामा जो एसाव उन हिंग्‍स, अदिक सिबोन उन नातुगीत अदिक अना अन पोर ईरोर, आकिन ई पारगोळ आदुर: मतलब आक एसाव उन द्वारा यूश, यालाम अदिक कोरह अक जनम कोट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसाव उन पारगोळ दा अधिपती ईंदुर ईरोर: एसाव उन धोळ पार एलीपज उन वंश दा टु तेमान अधिपती, ओमार अधिपती, सपो अधिपती, कनज अधिपती, ");
INSERT INTO hoy_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह अधिपती, गाताम अधिपती, अमालेक अधिपती एलीपज उन वंशीगोळ दा टु, एदोम द्‍याश दा ईंदुर अच अधिपती आदुर; अदिक ईंदुर अच आदा अन वंश दा पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसाव उन पार रूएल उन वंश दा ईंदुर स्‍याणा आदुर; मतलब नहत अधिपती, जेरह अधिपती, शम्‍मा अधिपती, मिज्‍जा अधिपती रूएल वंशिगोळ दा टु, एदोम द्‍याश दा ईंदुर अच अधिपती आदुर; अदिक ईंदुर अच एसाव उन हिंग्‍स बासमत इन वंश दा पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसाव उन हिंग्‍स ओहोलीबामा इन वंश दा ईंदुर पैदा आदुर; मतलब यूश अधिपती, यालाम अधिपती, कोरह अधिपती, अना अन पोर ओहोलीबामा जो एसाव उन हिंग्‍स ईरोर आकिन वंश दा ईंदुर अच पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","एसाव जो एदोम भी कहलुसतान, आऊन वंश ईव अच हु, अदिक आंदुर अधिपती भी ईंदुर अच आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","सेईर जो होरी हेसुर इन जाती नव ईरोन, आऊन ई चिकोर आ द्‍याश दा पयला टु उच ईरतोगोर; मतलब लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO hoy_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर, अदिक दीशान: एदोम द्‍याश दा सेईर इन ईंदुर अच होरी जातीवाळेर अधिपती आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतान उन पार, होरी, अदिक हेमाम ईरोर; अदिक लोतान उन आकतींग तिम्‍ना ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबाल उन ई पारगोळ आदुर: मतलब आल्‍वान मानहत, एबल, शपो, अदिक ओनाम. ");
INSERT INTO hoy_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","अदिक सीदोन उन ई पारगोळ आदुर: अय्या, अदिक अना; ईव आवा अना हुन यारी सुनसान जागा दा तान आप्‍प सिबोन उन गधागोळी आळ्‍स्त आळ्‍स्‍त बीसी नीर इन झरनागोळ सीकदव. ");
INSERT INTO hoy_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अदिक अना अक दीशोन हेसुर ईनव पार आदुन, अदिक आवा अना अक ओहोलीबामा हेसुर ईनोर पोर आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोन उक ई पारगोळ आदुर: हेमदान, एशबान, यित्रान, अदिक करान. ");
INSERT INTO hoy_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेर उन ई पारगोळ आदुर: बिल्हान, जावान, अदिक अकान. ");
INSERT INTO hoy_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशान उन ई पारगोळ आदुर: ऊस, अदिक अरान. ");
INSERT INTO hoy_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरी जाती नोर अधिपती ईंदुर लॉकुर आदुर: लोतान अधिपती, सिबोन अधिपती, शोबाल अधिपती, अना अधिपती, ");
INSERT INTO hoy_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन अधिपती, एसेर अधिपती, दीशान अधिपती; सेईर द्‍याश दा होरी जाती नोर ईंदुर अच अधिपती आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","बाक याग इस्त्राएलगोळ मा राज्य माळावाळेर राजागोळ पयले एदोम द्‍याश मा ई राजागोळ राज्य माळदुर; ");
INSERT INTO hoy_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बोर उन पार बेला एदोम दा राज्‍य माळदुन, अदिक आऊन शहर इन हेसुर दिन्‍हाबा आद. ");
INSERT INTO hoy_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला अन सोत्‍तुर मा, बोस्रा निवासी जेरह उन पार योबाब आऊन जागा मा राजा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब उन सोत्‍तुर मा, तेमानियों अन निवासी हूशाम आऊन जागा मा राजा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","बाक हूशाम उन सोत्‍तुर मा, बदद उन पार हदद आऊन जागा मा राजा आदुन ईव आवा हुन याव मिद्यानियागोळी मोआब इन द्‍याश दा हारूस कोंडुन, अदिक आऊन शहर इन हेसुर अबीत आद. ");
INSERT INTO hoy_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","बाक हदद उन सोत्‍तुर मा, मस्रेकावासी सम्‍ला आऊन जागा मा राजा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","बाक सम्‍ला अन सोत्‍तुर मा, शाऊल जो महानद इन तटवाला रहोबोत नगर इन ईरोन, आव आऊन जागा मा राजा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शाऊल उन सोत्‍तुर मा, अकबोर उन पार बाल्‍हानान आऊन जागा मा राजा आदुन. ");
INSERT INTO hoy_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अकबोर उन पार बाल्‍हानान उन सोत्‍तुर मा, हदर आऊन जागा मा राजा आदुन अदिक आऊन शहर इन हेसुर पाऊ आद; अदिक आऊन हिंग्‍स उन हेसुर महेतबेल आद, जो मेजाहाब इन नाती अदिक मत्रेद उन पोर ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एसाव उन वंश दा जो अधिपती ईरोर आंदुरव हेसुर: तिम्‍ना, अलवाह, यथेथ, ");
INSERT INTO hoy_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामा अधिपती, एला अधिपती, पीनोन अधिपती, , ");
INSERT INTO hoy_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनज अधिपती, तेमान अधिपती, मिबसार अधिपती, ");
INSERT INTO hoy_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्‍दीएल अधिपती, ईराम अधिपती एदोम वंशीगोळ जो द्‍याश इक तान माळ कोंडीदुर, आऊन निवास जागा दा ईंदुर अच अधिपती आदुर; अदिक एदोमी जाती इन मूल मंळसा एसाव हुन. ");
INSERT INTO hoy_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब रा कनान द्‍याश दा परदेशी आगकु ईरतोगोन, येल आऊन आप्‍प परदेशी आगकु ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","अदिक याकूब उन वंश इन वृत्‍तान्‍त ईद आद; यूसुफ सतरा वर्ष इन आगकु तान वार्टुर सांगुळ मर्र-म्यांडा आळ्‍सतोगोन; अदिक आ पार तान आप्‍प उन हिंग्‍स बिल्हा, अदिक जिल्‍पा अन पारगोळ सांगुळ ईरतोगोन; अदिक आदुर्द बुराई इन समाचार तान आप्‍प उन मुंद पोहचुस तोगोन. ");
INSERT INTO hoy_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","अदिक इस्त्राएल तान सप्‍पा पारगोळ से येक्‍कुल प्रेम यूसुफ से ईट तोगोन, यतिकी आव आऊन हाळाबाट्‍ट पनी नव पार ईरोन: अदिक आव आऊन साटी रंग बिरंगी अंगरखा माळसुसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","लेकीन याग आऊन वार्टुर नोळदुर, कि नामव आप्‍प नाम सप्‍पा वार्टुर से येक्‍कुल आऊन से प्रेम माळतान, आग आंदुर आऊन से दुश्मनी ईटली कुरतुर अदिक आऊन सांगुळ वळ्लीसा मात ईला हेळतोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","यूसुफ कांसा नोळदुन, अदिक तान वार्टुर से अदुर्द वर्णन माळदुन; आगी टु आंदुर आऊन से अदिक भी दुश्मनी माळली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","आव आंदुर से अंदुन, “जो कांसा ना नोळदीन, अदरी केळी ");
INSERT INTO hoy_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","नाव लॉकुर केई दा पेंडी कटीतेव, अदिक येन नोळतीन कि नान पेंडी येदकु सीधा नीदरेत; आग नीम पेंडी नान पेंडी इक नाकु दी टु घेर्स कोंडव अदिक अदरी नमस्‍कार माळली कुरतव.” ");
INSERT INTO hoy_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","आग आऊन वार्टुर आऊन से अंदुर, “येन नी सही दा नाम मा राज्‍य माळ्‍या? या येन नी सही दा नाम मा प्रभुता माळ्‍या?” इदुरसाटी आंदुर आऊन कांसा अदिक आऊन मात इन कारण आऊन से अदिक भी येक्‍कुल दुश्‍मनी माळली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","बाक आव अदिक ऊंद कांसा नोळदुन, अदिक तान वार्टुर हाती अदुर्द भी वर्णन माळदुन, “केळी, ना अदिक ऊंद कांसा नोळदिन, कि सुर्य अदिक चन्‍द्रमा, अदिक हनुन तारागोळ नानी नमस्‍कार माळीत्‍याव.” ");
INSERT INTO hoy_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ईद कांसा अन आव तान आप्‍प अदिक तान वार्टुर से वर्णन माळदुन; आग आऊन आप्‍प आऊक दनकुसकु अंदुन, “ईद ह्‍यांग कांसा आद जो नी नोळ्‍द? येन सही दा ना अदिक नीन मोय अदिक नीन वार्टुर सप्‍पा मुंदुर होगकु नीन मुंद धरती मा बिदकु नमस्‍कार माळेव?” ");
INSERT INTO hoy_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","आऊन वार्टगोळ रा आऊन से सिट्‍ट माळतोगोर; लेकीन आऊन आप्‍प आऊन आ मातगोळ इक याद ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","यूसुफ उन वार्टुर तान आप्‍प उन मर्र-म्‍यांडागोळी आळसोर साटी शकेम उक होदुर. ");
INSERT INTO hoy_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","आग इस्त्राएल यूसुफ से अंदुन, “नीन वार्टुर रा शकेम दा का मर्र म्यांडा आळ्‍सतीदार, इदुरसाटी होग, ना नीनी आंदुर हाती कळुतीन.” आव आऊन से अंदुन, “ठीक आद ना तैयार आईन.” ");
INSERT INTO hoy_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","इस्त्राएल आऊन से अंदुन, “होग, तान वार्टगोळ अदिक मर्र म्यांडागोळ्‍द हाल नोळकु बा कि आंदुर ठीक रा आर, बाक नान हाती समाचार तर.” अत: आव आऊक हेब्रोन इन तराई दा सार माळ कोंडुन. अदिक आव शकेम दा बंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","याग यूसुफ ऊंद मैदान दा ईत्‍त आत्‍त नोळोन, आग ऊंद मंळसा आऊक सिकदुन, आव आऊन से केळदुन, “येन ढुंढसीत्‍या नी?” ");
INSERT INTO hoy_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","आव अंदुन “ना रा तान वार्टुरी नोळीतीन कृपा माळकु नानी हेळ कि आंदुर मर्र म्यांडा येल आळसीत्‍यार?” ");
INSERT INTO hoy_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","आ मंळसा अंदुन, “आंदुर रा ईल टु होटोग्‍यार; अदिक आंदरी ना अनतेला केळदीन, बरी, ‘नाव दोतान इक होगाता.’” इदुरसाटी यूसुफ तान वार्टुर हिंद होदुन, अदिक आंदरी दोतान नगर दा नोळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","याग आंदुर आऊक दुर टु बरतेला नोळदुर, रा आऊन हाती बरोर से पयले अच आऊक कोंद बुळोद योजना माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","अदिक आंदुर आपस दा अनली कुरतुर, “नोळी, आव कांसा नोळावाळा बरेत्‍यान. ");
INSERT INTO hoy_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","नळी, नाव आऊक कोंदकु ईल यातोदारा गड्‍डा दा भीट बुळाता, अदिक नाव अन बुळाता, कि आऊक यातोदारा आळी दाकळोद जनावर तीन बुळ्‍त बाक नाव नोळाता कि आऊन कांसा अन येन आगतद.” ");
INSERT INTO hoy_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","लेकीन रूबेन यूसुफ उक ऊळसोद चाहासोन. इदुरसाटी रूबेन अंदुन “नाव यूसुफ उक जान ठाय कोनालेव; ");
INSERT INTO hoy_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","बल्‍की नाव आऊक यातोदारा गड्‍डा दा हाक्‍क बुळाता,” रूबेन हिंग इदुरसाटी माळदुन कि आव यूसुफ उक उळ्‍सकु तान आप्‍प उक कोट्‍ट बुळुल. ");
INSERT INTO hoy_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ह्‍यांग यूसुफ तान वार्टुर हाती बंदुन, आंदुर यूसुफ उन रंग बिरंगा कपळा, जो आव हाक्‍कु ईरोन ईळ्‍सदुर, ");
INSERT INTO hoy_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","अदिक यूसुफ उक ऊंद वळ्गींद गड्‍डा दा हाक्‍क बुट्‍टुर, यदुर दा नीर ईला ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ईद माळकु आंदुर ऊमली कुरतुर. आग आंदुर नोळदुर कि इश्‍माएलीगोळ्‍द ऊंद दल ऊँटगोळ मा सुगन्ध द्रव्य, बलसान, अदिक गन्धरस मंण्‍सकु, गिलाद टु मिस्त्र अक होगेत्याद. ");
INSERT INTO hoy_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","आग यहूदा तान वार्टुर से अंदुन, “तान वार्ट उक कोण्‍णोद अदिक आऊन खुन होचकोमसुसकु येन लाभ आदीत? ");
INSERT INTO hoy_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","नाव ईऊक ई इश्‍माएलीगोळी मार्र कोमाता, नाव ईऊक कोनालेव, यतिकी आव नामव वार्ट हुन, नाम तान रक्‍ता हुन.” वार्टुरी ईद मात वळ्लीद हत्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","आटा वती येनारा मिद्‍यानी व्‍यापारी भी अल टु होट्‍टुर, आग आंदुर आंदुर्द मदत देल यूसुफ उक गड्‍डा दा टु व्‍हार्या तेगदुर अदिक आऊक इश्‍माएलीगोळी ईप्‍पत बेळ्ली इन सिक्‍कागोळ दा मार्र कोंडुर; अदिक आंदुर यूसुफ उक मिस्त्र द्याश दा ओतुर. ");
INSERT INTO hoy_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","रूबेन गड्‍डा दा वापस बंदकु येन नोळदुन कि यूसुफ गड्‍डा दा हैलेच; इदुरसाटी आव तान कपळा हरदुन, ");
INSERT INTO hoy_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","अदिक तान वार्टुर हाती बंदकु अनली कुरतुन, “पार रा हैलेच; ईग ना यात होगाईन?” ");
INSERT INTO hoy_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","आग आंदुर यूसुफ उन कपळा हुळदुर, अदिक ऊंद व्हात इक कोंदकु अदुर रक्‍ता दा अदरी मुळकुसदुर. ");
INSERT INTO hoy_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","अदिक आंदुर आ रंग बिरंगा अंगरखा अक तान आप्‍प उन हाती कळुकु ईद संदेश कळुदुर; “ईद नामी सिक्‍याद, अत: नोळकु अरूकोम कि ईद नीन पार उन अंगरखा हुन का आलच.” ");
INSERT INTO hoy_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","आव अदरी अरू कोंडुन, अदिक अंदुन, “हव ईद नान पार उन कपळा हुन; यातोदारा दुष्‍ट जनावर आऊक तीन बुळ्‍त; बिना संदेह यूसुफ तुकळा तुकळा माळकु आग्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","आग याकूब तान कपळा हरदुन अदिक नेळु मा टाट गुंळ्‍सदुन, अदिक तान पार उन साटी हापाळ दिन ताका वर्लतेला ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","अदिक आऊन सप्‍पा पोर पारगोळ आऊक शांती कोळोद कोशिश माळदुर; लेकीन आऊक शांती सिकीदील; अदिक आव ईदा माळतेला ईत्‍तुन, “ना वर्लतेला तान पार उन हाती अधोलोक दा ईळदोगाईन.” ई प्रकार आऊन आप्‍प आऊन साटी वर्लतेला अच ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ई बीच मिद्‍यानीगोळ यूसुफ उक मिस्त्र दा ओतकु पोतीपर हेसुर इन फिरौन उन ऊंद हाकिम अदिक अंगरक्षकगोळ प्रधान, उन कय दा मार्र बुट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","अवा दिनगोळ दा हिंग आत कि यहूदा तान वार्टगोळ हाती टु होटोदुन, अदिक हीरा हेसुर इन ऊंद अदुल्‍लामवासी मंळसा अन हाती ड्‍यारा हाक्कु आऊन हाती ईरली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","अल यहूदा शुआ हेसुर इन ऊंद कनानी मंळसा अन पोर इक नोळदुन; अदिक आकिन से मदा माळकु आकिन हाती होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","आक व्‍हाट्‍यादी ईत्‍तुर, अदिक आकी ऊंद पार आदुन; अदिक यहूदा आऊन हेसुर एर ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","अदिक आक मात व्‍हाट्‍यादी ईत्‍तुर, अदिक ऊंद पार आदुन; अदिक आऊन हेसुर ओनान ईटकु आत. ");
INSERT INTO hoy_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","बाक आकी अदिक ऊंद पार आत, अदिक आऊन हेसुर शेला ईटकु आत; अदिक या समय आऊन जनम आत आ समय यहूदा कजीब नगर दा ईरतोगोन. ");
INSERT INTO hoy_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","अदिक यहूदा तामार हेसुर इन आर्त से धोड्‍डेव पार एर उन मदा माळ कोट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","लेकीन यहूदा अन आव धोड्‍डेव पार एर यहोवा अन नजर दा दुष्‍ट ईरोन, इदुरसाटी प्रभु आऊक कोंद बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","आग यहूदा ओनान से अंदुन, “तान अतक्या अन हाती होग, अदिक आकिन सांगुळ मैदाण आगोद धर्म पुरा माळकु तान वार्ट उन साटी औलाद पैदा माळ.” ");
INSERT INTO hoy_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ओनान रा जानसोन संतान रा नानोर कहलुसतीदील; इदुरसाटी हिंग आत कि याग आव तान अतक्या अन हाती होदुन, आग आव जमीन मा तान वीर्य केडुकु नाश माळ बुट्‍टुन, यदुर देल हिंग आग बाळुल कि आऊन वार्ट उन हेसुर देल वंश नळु बाळुल. ");
INSERT INTO hoy_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ईद क्‍याल्‍सा जो आव माळदुन अदुर देल यहोवा खुश आगीदील अदिक प्रभु आऊक भी कोंद बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","आग यहूदा ई अंज्‍क इन कारण कि हिंग आगबाळुल कि तान वार्टुर घाई शेला भी सायुल, तान सास्सा तामार से अंदुन, “यागासताका नान पार शेला स्याणा आगेगालुन आगासताका तान आप्‍प उन मान्‍या अच रांड्यागीत ईर.” इदुरसाटी तामार तान आप्‍प उन मान्‍या होगकु ईरली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","हापाळ समय बितुसदुर मा यहूदा अन हिंग्‍स जो शुआ अन पोर ईरोर, आक सोतोदुर; बाक यहूदा अन दुख इन दिनगोळ होगदुर मा तान संगी हीरा अदुल्‍लामवासी सांगुळ तान मर्र-म्यांडागोळ चुट्‍टी कडावाळेर हाती तिम्ना नगर इक होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","अदिक तामार इक ईद समाचार सिक्‍त, “नीन मॉव तान मर्र-म्यांडागोळ्‍द चुट्‍टी कळसुसोर साटी तिम्ना नगर इक होगेत्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","आग तामार तान रांड्यागीत इन कपळा ईळ्‍सदुर, अदिक तान बाय घुंघट देल होचकोमकु ऊंद चादर गुंळ्‍स कोंडुर अदिक तिम्ना अन हादी मा एनैम इन प्रवेश दरवाजा मा कुरतोदुर. आक ईद इदुरसाटी माळदुर यतिकी आकिन देर शेला हारोदव आगेगीदुन अदिक आऊन से आकिन मदा माळकु आगीदील. ");
INSERT INTO hoy_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","याग यहूदा आकी नोळदुन, आकी आव वेश्‍या सम्‍सदुन; यतिकी आक तान बाय होचकोमकु ईटीदुर. ");
INSERT INTO hoy_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","आव हादी मा टु आकिन दी तिर्गदुन, अदिक आकिन से अनली कुरतुन, “नानी तान हाती बरगोळ,” यतिकी आऊक मालुम ईला ईरोद कि आक आऊन सास्सा हुळ. अदिक आक अनली कुरतुर, “अगर ना नीनी तान हाती बरगोळाईन, रा नी नानी येन कोट्या?” ");
INSERT INTO hoy_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","आव अंदुन, “ना नीनी तान झुंड दा टु ऊंद मर्री अन पाड्डा कळु बुळाईन.” आग तामार अंदुर, “अदरी कळासताका अदुर बदला दा येन कोट्या?” ");
INSERT INTO hoy_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","आव केळदुन, “नी येन चाहसत्‍या?” आक उत्‍तर कोट्‍टुर, “तान मुहर, अदिक बाजुबन्‍द, अदिक तान कय इन छळी.” आग आव आकी अव सामान कोट्‍टुन, अदिक आकिन हाती होदुन, अदिक आक आऊन से व्‍हाट्‍यादी ईत्‍तुर. ");
INSERT INTO hoy_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","आग आक येदकु होटोदुर, अदिक तान घुंघट ईळ्सकु तान रांड्यापन इन पहनावा मात हाक्‍क कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","याग यहूदा तान अदुल्‍लामवासी संगी इन कय दा अद मर्र इन पाड्डा आ आर्त इन साटी कळुदुन, गहान ईटकु वस्तु आ आर्त इन कय देल बिळस्कु तरूल; रा अल आऊक आ आर्त सिकीदील. ");
INSERT INTO hoy_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","आव ईत्‍त आत्‍त लॉकुरी केळदुन कि, “आक वेश्‍या येल आर, एनैम इन हादी मा कुरतोगोर?” आंदुर अंदुर, “ईल यारू वेश्‍या यागलु ईरोर अच ईला.” ");
INSERT INTO hoy_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","इदुरसाटी आव यहूदा अन हाती वापस बंदकु अंदुन, “नानी आक सिकीदील; अदिक आ जागा नोर लॉकुर अंदुर, ‘ईल रा यातोदु वेश्‍या ईरालुर.’” ");
INSERT INTO hoy_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","“आग यहूदा अंदुन, ठीक आद, अव निशान इन बंधक वस्तु आकिन हाती इच ईरगोळ, ईलारा नाव लॉकुर तुच्छ आळुकु आदेव; नोळ, ना मर्री इन पाड्डा कळु बुटीदीन, लेकीन आक नीनी सिकीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","लगभग मुर तींगुळ बाद्‍दा यहूदा अक ईद समाचार सिक्‍त, “नीन सास्सा तामार व्यभिचार माळ्‍यार; बल्‍की आक व्‍यभिचार देल व्‍हाट्‍यादी भी आगेग्‍यार.” आग यहूदा अंदुन, “आकी व्‍हार्या तरी कि आकी होत्‍ताकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","याग आकी व्‍हार्या तेगुकु आगोद, आग आक, तान मॉव उन हाती ईद अनकु कळुदुर, “या मंळसा अन ई सामान हुन, आऊन से अच ना व्‍हाट्‍यादी आईन,” बाक आक ईद भी अनकु कळुदुर, “अरू रा सही कि ईद मुहर, अदिक बाजुबन्‍द, अदिक छळी यार्द हुन.” ");
INSERT INTO hoy_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदा अव समान नोळतेला अच पहचान्‍स कोंडुन अदिक अंदुन, “आक रा नान कम दोषी आर, यतिकी ना अच आकी शेला अन हिंग्‍स आगोर से रोक्‍सीदिन.” यहूदा आकी बाक यागलु कय हचीदिल. ");
INSERT INTO hoy_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","याग आकिन हाळोद समय बत्‍त, आग ईद पता हत्‍त कि आकिन व्‍हाट्‍या दा येढ्‍ढ चिकोर आर. ");
INSERT INTO hoy_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","याग आक हाळुली कुरतुर आग ऊंद पार ऊंद कय व्‍हार्या बत्‍त, अदिक दाई क्‍याचांद धागा हुडुकु आऊन कय दा ईद अनतेला कटदुर, “पयले ईवा पैदा आग्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","लेकीन आव तान कय बुळ्‍क जेळदुन अदिक आऊन वार्ट उन जनम आऊन से पयला आत. आग दाई अंदुर, “नी पयले व्‍हार्या होट्‍टुर दा समर्थ आद!” इदुरसाटी आऊन हेसुर पेरेस ईटकु आत. ");
INSERT INTO hoy_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","हिंद आऊन वार्ट यार्द कय दा क्‍याचांद सुत कटकु ईरोद पेरेस आदुन, अदिक आऊन हेसुर जेरह ईटकु आत ");
INSERT INTO hoy_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","याग यूसुफ मिस्त्र दा पोहचुस्कु आदुन, आग पोतीपर हेसुर ईनव ऊंद मिस्‍त्री, जो फिरौन इन हाकिम, अदिक अंगरक्षकगोळव प्रधान ईरोन, आऊक इश्‍माएलीगोळ कय दा टु जो आऊक अल ओतीदुर, पैस्या कोटकु कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","यूसुफ तान मिस्त्री स्वामी इन मान्‍या ईरतोगोन, अदिक यहोवा आऊन सांगुळ ईरोन; इदुरसाटी सफल धनी मंळसा आगेदुन. ");
INSERT INTO hoy_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","अदिक यूसुफ उन स्वामी नोळदुन, कि यहोवा आऊन सांगुळ ईरतान, अदिक जो क्‍याल्‍सा आव माळतान अवरी यहोवा आऊन कय देल सफल माळ कोमतान. ");
INSERT INTO hoy_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","आग आऊन अनुग्रह अन नजर आऊन मा आत, अदिक यूसुफ आऊन स्यावा टहल माळोरसाटी निवळुसकु आदुन; बाक आव आऊक तान मान्ना अन्द अधिकारी माळकु सप्‍पा येनारा आऊन कय दा कोट्‍ट बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","याग टु आव आऊक तान मान्‍या अन्द अदिक सप्‍पा सम्‍पती इन अधिकारी माळीदुन, आग टु यहोवा यूसुफ उन कारण आ मिस्त्री इन मान्‍या आशीष कोळली कुरतुन; अदिक येन मान्‍या, येन केई दा, आऊन जो येनारा भी ईरोद, सप्‍पा मा यहोवा अन आशीष आगली कुर्त. ");
INSERT INTO hoy_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","इदुरसाटी आव तान सप्‍पा येनारा यूसुफ उन कय दा ईल ताका बीट बुट्‍टुन कि तान तीना रोट्‍टी इक बिटकु, आव तान सम्‍पती इन हाल येनु ईला जानसोन. यूसुफ सुंदर अदिक रूपवान ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ईव मातगोळ बाद्‍दा हिंग आत, कि आऊन स्वामी इन हिंग्‍स यूसुफ उन दी नोळदुर अदिक अंदुर, “नान सांगुळ मींग.” ");
INSERT INTO hoy_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","लेकीन आव मना माळकु तान स्वामी इन हिंग्‍स से अंदुन, “केळ, जो येनारा ई मान्‍या आद अद नान कय दा आद; अदरी नान स्वामी येनु जानसालुन, अदिक आव तान सप्‍पा येनारा नान कय दा सौप्स बुट्‍टान. ");
INSERT INTO hoy_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ई मान्‍या नान से धोड्‍डेव याऊ हैलेच; नान स्वामी नानी नीन अलावा यातोदु वस्‍तु से अलग ईटीदिल, यतिकी नी आऊन हिंग्‍स हुय. इदुरसाटी ईद ह्‍यांग संभव आद कि ना ईत्‍ता दुष्‍टता माळकु परमेश्वर उन विरूद्ध पाप माळाईन?” ");
INSERT INTO hoy_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","अदिक हिंग आत कि आक रोज यूसुफ से मातगोळ माळतेला ईत्‍तुर, लेकीन आव आकिन मान्‍सीदील कि आकिन हाती मींगाईन या आकिन सांगुळ ईराईन. ");
INSERT INTO hoy_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ऊंद दिशी येन आत कि यूसुफ तान क्‍याल्‍सा माळोर साटी मान्‍या होदुन, अदिक मान्‍यागोळोर सेवकगोळ दा टु याऊ भी मान्‍या अन बुळ्‍क ईला ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","आग आ आर्त आऊन कपळा हरकु अंदुर, “नान सांगुळ मींग,” लेकीन आव तान कपळा आकिन कय दा बिटकु ओळदुन, अदिक व्‍हार्या होट्‍ट बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ईद नोळकु कि आव तान कपळा नान कय दा बिटकु व्‍हार्या ओळदुन, ");
INSERT INTO hoy_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","आक सप्‍पा सेवकगोळी कारदुर अदिक अंदुर, “ईद नोळी, नान गांड ई इब्री मंळसा अक नान देखभाल माळोरसाटी ईट्‍यान लेकीन आव नानी खराब माळली नान हाती बंदुन आग ना चिळ्लासदीन. ");
INSERT INTO hoy_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","अदिक नान धोळ्‍द आवाज केळकु आव तान कपळा नान हाती बिटकु ओळदुन, अदिक व्‍हार्या होट्‍ट बुट्‍टुन.” ");
INSERT INTO hoy_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","अदिक आक आऊन कपळा आऊन स्वामी इन बरास ताका तान हाती ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","तान गांड उन बंदुर मा आक हेळदुर कि : “नी या इब्री दास उक ईल तंद्या, आव नान अपमान माळोर साटी ईल बंदीदुन. ");
INSERT INTO hoy_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","अदिक याग ना धोळ आवाज दा चिळ्लासदीन, आग आव तान कपळा नान हाती बिटकु व्‍हार्या ओळेदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","तान हिंग्‍स उन ई मातगोळ केळकु कि नीन दास नान सांगुळ ईत्‍ता-ईत्‍ता क्‍याल्‍सा माळदुन, यूसुफ उन स्वामी इन कोप भळकुस्‍त. ");
INSERT INTO hoy_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","अदिक यूसुफ उन स्वामी आऊक हुडुकु जेल दा, येल राजा अन कैदी बंद ईरोर, हाकसुस बुट्‍टुन; अत: आव आ बंदीगृह दा ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","लेकीन यहोवा यूसुफ उन सांगुळ सांगुळ ईत्‍तुन, अदिक आऊन मा करूणा माळदुन, अदिक जेल इन दरोगा अन अनुग्रह अन नजर आऊन मा आत. ");
INSERT INTO hoy_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","इदुरसाटी जेल इन दरोगा आ सप्‍पा बंदीगोळी, जो कारागार दा ईरोर, यूसुफ उन कय दा सौप्स बुट्‍टुन; अदिक जो जो क्‍याल्‍सा आंदुर अल माळतोगोर, अद आऊन आग्‍या देल अच आगतोगोद. ");
INSERT INTO hoy_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","यूसुफ उन वश दा जो येनारा ईरोद अदुर दा टु जेल इन दरोगा अक येनारा भी वस्‍तु नोळोद ईला बिळतोगोद; यतिकी यहोवा यूसुफ उन सांगुळ ईरोन; अदिक जो येनारा आव माळतोगोन, यहोवा आऊक अदुर दा सफलता कोळतोगोन. ");
INSERT INTO hoy_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ई मातगोळ बाद्‍दा हिंग आत, कि मिस्त्र अन राजा नोर कुळसावाळा अदिक खाना माळावाळा तान स्वामी अन खिलाप येनारा अपराध माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","आग फिरौन तान आ हाकिमगोळ, मतलब कुळसावाळा अन प्रधान, अदिक खाना माळावाळा अन प्रधान मा क्रोधित आगकु ");
INSERT INTO hoy_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","आंदरी कैद माळसुसकु, अंग रक्षकगोळ प्रधान उन मान्‍या अन अदा बंदीगृह दा, येल यूसुफ बंदी ईरोन, हाकसुस बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","आग अंग रक्षकगोळ प्रधान आंदरी यूसुफ उन कय दा सोप्सदुन, अदिक आव आंदुर्द स्यावा टहल माळली कुरतुन; अत: आंदुर येनारा दिन ताका बंदीगृह दा ईत्‍तुर. ");
INSERT INTO hoy_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","आग ऊंद ईळ्‍ल्‍की येढ्‍ढु मुंदुर अलग अलग कांसा नोळदुर, अदिक हर ऊंद कांसा अन तान अलग अलग मतलब ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","यूसुफ दुसरा दिशी व्हातर्या आंदुर हाती होदुन. अदिक नोळदुन कि येढ्ढु मुंदुर हापाळ परेशान ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","इदुरसाटी आव फिरौन उन आ हाकिमगोळ से, जो आऊन सांगुळ आऊन स्वामी इन मान्ना अन्द जेल दा ईरोर, केळदुन, “ईंद नीम्द बाँय येती उदास आद?” ");
INSERT INTO hoy_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","येढ्ढु मुंदुर उत्तर कोट्टुर, “होत आ ईळ्लकी नाव कांसा नोळदेव,” लेकीन नामी समसाल “कि कांसा अन मतलब येन हुन?” याऊ हिंग मंळसा हैलेच जो कांसागोळ्द व्याख्या माळुल या नामी स्पष्ट हेळुल. यूसुफ आंदुर से अंदुन, “केवल परमेश्वर अच हिंग आन जो कांसागोळी सम्सतान अदिक अऊर्द व्याख्या माळतान. इदुरसाटी ना निवेदन माळतीन कि तान कांसा नानी हेळी.” ");
INSERT INTO hoy_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","इदुरसाटी अंगुर इन रास्सा कोळावाळा सेनापती यूसुफ उक तान कांसा हेळदुन. आव अंदुन, “ना कांसा दा अंगुर इक बेली नोळदीन. ");
INSERT INTO hoy_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","आ अंगुर इन बेली इन मुर खांदीगोळ ईरव. ना आ खांदीगोळ मा फूल बरतेला अदिक अवरी अंगुर हततेला नोळदीन. ");
INSERT INTO hoy_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","अदिक फिरौन उन कटोरा नान कय दा ईरोद; अदिक ना आ अंगुरगोळी हुडुकु फिरौन उन कटोरा दा हिंडदीन अदिक कटोरा अक फिरौन उन कय दा कोट्टीन.” ");
INSERT INTO hoy_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","यूसुफ आऊन से अंदुन, “ईदुर्द काय ईद हुन: मुर खांदा अन मतलब मुर दिन हुन ");
INSERT INTO hoy_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","इदुरसाटी ईग टु मुर दिन इन बुळ्क नीन ताल्ला ऊँचा माळ्यान, अदिक मात नीन पद मा नीनी नीवळुस्यान, अदिक पयले अन घाई फिरौन उन कुळसावाळा आगकु आऊन कटोरा आऊन कय दा मात कोळतोद्या. ");
INSERT INTO hoy_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","अत: याग नीन भला आगेदीत आग नानी याद माळेत, अदिक नान मा दया माळकु फिरौन से नान चर्चा माळेत, अदिक ई जेल टु नानी बीळसुस बुळेत. ");
INSERT INTO hoy_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","यतिकी सही दा इब्रानीगोळ्द द्याश टु नानी कदुकु तनकु आग्याद, अदिक ईल भी ना यातोदु हिंग क्याल्सा माळीदिल, यदुर कारण ना ई जेल दा हाक्कु आगाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","रोट्टी माळावाळा नोळदुन कि दुसरा नौकर उन कांसा वळ्‍लीद ईरोद. इदुरसाटी रोट्टी माळावाळा यूसुफ से अंदुन, “ना भी कांसा नोळीन. ना नोळदीन कि नान ताल्ला मा बिळीद मुर रोट्टीगोळोव फुट्टी आव. ");
INSERT INTO hoy_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","सबसे म्याकुच इन फुट्टी दा फिरौन उन साटी सप्पा प्रकार इन कासदव भोजन आव. ईद भोजन राजा अन साटी ईरोद. लेकीन ई भोजन इक पक्षीगोळ तीनव.” ");
INSERT INTO hoy_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","यूसुफ उत्तर कोट्टुन, “ना नीनी हेळाईन कि कांसा अन मतलब येन आद? मुर फुट्टीगोळ्द मतलब मुर दिन हुन. ");
INSERT INTO hoy_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ईग टु मुर दिन इन पयले फिरौन नीन ताल्ला कळसुसकु नीनी ऊंद मार्र मा लटकुस बुट्टान, अदिक पक्षी नीन मास इक तीळ्स तीळ्सकु तींदव.” ");
INSERT INTO hoy_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","अदिक तीसरा दिशी फिरौन उन जनम दिन ईरोद, आव तान सप्पा क्याल्सा माळावाळेर इक भोजन कोट्टुन, अदिक आंदुर दा टु कुळसावाळा प्रधान, अदिक कासावाळा प्रधान येढ्ढु मुंदुरी जेल दा टु तेगसुसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","कुळसावाळा सेनापती अक रा कुळसावाळा अन पद मा मात नीवळुसदुन, अदिक आव फिरौन उक कय दा कटोरा कोळली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","लेकीन फिरौन रोट्टी माळावाळा अक कोंद बुट्टुन. ह्यांग मातगोळ यूसुफ हेळीदुन हांग अच आत. ");
INSERT INTO hoy_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","तरी भी कुळसावाळा प्रधान यूसुफ उक याद माळीदिल; लेकीन आऊन मारतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","पुरा येढ्‍ढ वर्ष आगदुर मा फिरौन ईद कांसा नोळदुन कि आव नील गांगा अन किनारा मा निदुरकु आन. ");
INSERT INTO hoy_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","अदिक आ नील गांगा दा टु येळ सुंदर अदिक मोटा-मोटा गोसी होटकु किनारा अन काड्डा तिनली कुरतव. ");
INSERT INTO hoy_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","अदिक, येन नोळदुन कि अऊर हिंद अदिक येळ गोसीगोळ, जो कुरूप अदिक कमजोर आव, नील गांगा टु होट्टव; अदिक दुसरा गोसीगोळ हात्ती गांगा अन तट मा होगकु नीदुरदव. ");
INSERT INTO hoy_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ईव येळु कमजोर गोसी, सुंदर मोटा येळ गोसीगोळी तीन कोंडव, आग फिरौन येद्दुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","फिरौन मात्त मिंगदुन अदिक दुबारा कांसा नोळदुन. आव कांसा दा अनाज इन येळ लॉम्बा, ऊंद अनाज इन हिंद ऊगुसतेला नोळदुन. अनाज इन लॉम्बागोळ मोटा अदिक वळ्लेव ईरव. ");
INSERT INTO hoy_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","अदिक, येन नोळदुन कि अऊर हिंद येळ लॉम्बागोळ पतला अदिक पुरवाई टु मुरझुस्कु होट्टव. ");
INSERT INTO hoy_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","आग पतला लॉम्बागोळ येळ मोटा लॉम्बागोळी तीन कोंडव. ईदुर देल फिरौन उन जप खुलसेत अदिक आव समसेदुन कि अद कांसा ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","व्हातुर आगदुर मा राजा अन्द मन बेचैन आदुन, इदुरसाटी आ कांसा अन मतलब जानसोर साटी मिस्त्र द्याश इन सप्पा ज्योतिषगोळी अदिक जादूगर कारसुसदुन अदिक फिरौन आंदरी तान येढ्ढु कांसागोळ हेळदुन लेकीन याऊ भी आ कांसागोळ्द मतलब हेळ सकीदील. ");
INSERT INTO hoy_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","आग प्रधान कुळसावाळा फिरौन से अंदुन, “ईंद नानी तान पाप याद बरेत्याद. ");
INSERT INTO hoy_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","याग फिरौन तान दासगोळ से सीट्टी बंदीदुन, नानी अदिक रोट्टी माळावाळा प्रधान उक कैद माळकु अंगरक्षकगोळ प्रधान उन मान्या बंदीगृह दा हाकीदुन; ");
INSERT INTO hoy_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","आग नाव येढ्ढु मुंदुर ऊंद अच ईळ्लकी, तान तान हुनर इन अनुसार कांसा नोळीदेव; ");
INSERT INTO hoy_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","अदिक अल नाम सांगुळ ऊंद इब्री हारोदव ईरोन, जो अंगरक्षकगोळ प्रधान उन दास ईरोन; अत: नाव आऊक हेळदेव, अदिक आव नाम कांसागोळ्द मतलब नाम से अंदुन, नाम दा ऊंद ऊंद उन कांसा अन मतलब आव नामी हेळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","अदिक ह्यांग काय आव नाम से अंदिदुन, हांग अच आत भी, मतलब नानी रा नान पद मात सीक्त, लेकीन आव फासी मा लटकुसकु आदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","आग फिरौन यूसुफ उक बुलावा कळुदुन. अदिक आव झटपट जेल टु व्हार्या तेगसुसकु आदुन, अदिक चुट्टी माळकु, अदिक कपळा बदलुसकु फिरौन उन मुंद बंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फिरौन यूसुफ से अंदुन, “ना ऊंद कांसा नोळीन, अदिक अदुर मतलब हेळावाळा याऊ भी हैलेच; अदिक ना नीन बारा दा केळीन, कि नी कांसा केळतेला अच अदुर मतलब हेळबुळत्या.” ");
INSERT INTO hoy_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","यूसुफ फिरौन से अंदुन, “ना रा येनु जान्सालीन: परमेश्वर फिरौन उन साटी शुभ वचन कोट्टुन.” ");
INSERT INTO hoy_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","बाक फिरौन यूसुफ से अनली कुरतुन, “ना तान कांसा दा नोळदिन, कि ना नील गांगा अन किनारा मा निदुरकु आईन. ");
INSERT INTO hoy_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","बाक, येन नोळदीन, कि नील गांगा दा टु येळ मोटा अदिक सुंदर गोसीगोळ होटकु व्हार्या बंदव अदिक किनारा अक काड्डा तिनली कुरतव. ");
INSERT INTO hoy_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","बाक, येन नोळदीन, कि अऊर हिंद येळ गोसी अदिक होट्टव, जो पतला, अदिक हापाळ कुरूप, अदिक कमजोर आव; ना रा सप्पा मिस्त्र द्याश दा ईत्ता खराब गोसी यागलु नोळीदील. ");
INSERT INTO hoy_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ईव कमजोर अदिक खराब गोसीगोळ आ पयला येळु गोसीगोळी तीन कोंडव. ");
INSERT INTO hoy_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","अदिक याग अव अवरी तीन कोंडव आग ईद ईला मालुम आगोद कि अव अवरी तीन कोंडव, यतिकी अव पयला अन घाई हांग च्या हांगा खराब ईरव. आग ना यदोदीन. ");
INSERT INTO hoy_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","बाक ना दुसरा कांसा नोळदीन, कि ऊंद अच कोर दा येळ वळ्लेव वळ्लेव अदिक अन्न देल तुमकु लॉम्बागोळ होट्टव. ");
INSERT INTO hoy_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","बाक येन नोळतीन, कि अऊर हिंद अदिक येळ लॉम्बागोळ मुरझुसकु अदिक पतला अदिक बीसी हवा देल नष्ट ईरव. ");
INSERT INTO hoy_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","अदिक आ पतला लॉम्बागोळ आ येळ वळ्लेव वळ्लेव लॉम्बागोळ तीन कोंडव. ईदरी ना ज्‍योतिषिगोळी हेळदीन, लेकीन ईवरी समझुसावाळा याऊ सीकीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","आग यूसुफ फिरौन से अंदुन, “फिरौन उन कांसा ऊंद अच हुन, परमेश्वर जो क्याल्सा माळोद चाहासतान, अदरी आव फिरौन मा प्रगट माळ्‍यान. ");
INSERT INTO hoy_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","अव येळ वळ्लेव वळ्लेव गोसी येळ वर्ष हुव; अदिक अव येळ लॉम्बागोळ भी येळ वर्ष हुव; कांसा ऊंद हुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","बाक अऊर हिंद जो दुर्बल अदिक कुडौल गोसीगोळ होट्टव, अदिक जो येळ मुरझुसकु अदिक पतला अदिक बीसी हवा देल नष्ट आगकु लॉम्बागोळ होट्टव, अव अकाल इन येळ वर्ष ईत्तव.” ");
INSERT INTO hoy_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ईद अदा मात हुन जो ना फिरौन से अन कोंडीन, कि परमेश्वर जो क्याल्सा माळोद चाहासतान, अदरी आव फिरौन उक तोर्सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","केळ, सप्पा मिस्त्र द्याश दा येळ वर्ष रा हापाळ उपज इन आदीत. ");
INSERT INTO hoy_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","अदुर बाद्दा येळ वर्ष अकाल ईनव बंदव, अदिक सप्पा मिस्त्र द्याश दा लॉकुर ई सप्पा उपज इक मारतोदार; अदिक अकाल देल द्याश इन नाश आदीत. ");
INSERT INTO hoy_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","अद कि अकाल ईट भयानक आदीत कि वळ्लीद फसल अदिक उपज द्याश दा यारीकु याद ईरतीदील? ");
INSERT INTO hoy_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","अदिक फिरौन जो ईद कांसा येढ्ढ घन नोळदुन ईदुर्द भेद ईदा हुन कि ईद मात परमेश्वर उन दी टु नीवळुसकु आगेग्याद, अदिक परमेश्वर ईदरी जल्दी पुरा माळ्यान. ");
INSERT INTO hoy_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“इदुरसाटी ईग फिरौन यातोवारा समझदार अदिक बुध्दिमान मंळसा अक नोळकु आऊक मिस्त्र द्याश इन प्रधानमंत्री ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","फिरौन ईद माळुल कि द्याश मा अधिकारीगोळी नीवळुसुल, अदिक यागासताका खुसहाल इन येळ वर्ष ईत्तव आगासताका आव मिस्त्र द्याश इन उपज इन पाचवा हिस्सा ताकोमुल. ");
INSERT INTO hoy_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","अदिक आंदुर ई वळ्लेव वर्षगोळ दा सप्पा प्रकार इन भोजन वस्तुगोळ जमा माळुल, अदिक नगर-नगर दा भंडार मान्ना भोजन इन साटी, फिरौन उन वश दा माळकु अऊर्द रक्षा माळुल. ");
INSERT INTO hoy_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","अदिक अव भोजन वस्तु अकाल इन आ येळ वर्षगोळ साटी, जो मिस्त्र द्याश दा बंदव, द्याश इन भोजन ई निमित्त ईटकु ईरूल, यदुर देल द्याश आ अकाल देल सत्यानाश आग बाळुल.” ");
INSERT INTO hoy_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ईद मात फिरौन अदिक आऊन सप्पा क्याल्सा माळावाळेर इक वळ्लीद हत्त. ");
INSERT INTO hoy_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","इदुरसाटी फिरौन तान क्याल्सा माळावाळेर से अंदुन, “येन नामी ईत्ता मंळसा, ह्यांग ईव आन, यार मा परमेश्वर उन आत्मा ईरतद, सिक सकतान?” ");
INSERT INTO hoy_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","बाक फिरौन यूसुफ से अंदुन, “परमेश्वर जो नीनी ईट ग्यान कोटान, कि नीन बराबर याऊ समझदार अदिक बुद्धिमान हैलेच; ");
INSERT INTO hoy_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ई कारण नी नान मान्या अन अधिकारी ईत्या, अदिक नीन आग्या अन अनुसार नान पुरा प्रजा नळदीत, सिर्फ राजगद्दी इन बारा दा ना नीन से धोड्डेव ठहरूसाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","बाक फिरौन यूसुफ से अंदुन, “केळ, ना नीनी मिस्त्र अन सप्‍पा द्याश इन म्याकुच अधिकारी ठहरूस बुळतीन.” ");
INSERT INTO hoy_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","आग फिरौन तान कय दा टु मुहर वाला ऊंगरा तेगुकु यूसुफ उन कय दा हाकसुसदुन; अदिक आऊक वळ्लेव मलमल इन कपळा हाकसुसदुन, अदिक आऊन कुत्या दा व्हान्ना अन माला हाकदुन; ");
INSERT INTO hoy_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","अदिक आऊक तान दुसरा रथ मा येर्सदुन; अदिक लॉकुर आऊन मुंद मुंद ईद प्रचार माळतेला नळदुर, कि ट्वागंरा टेक्सकु नमस्कार माळी अदिक आव आऊक मिस्त्र द्याश इन म्याकुच प्रधानमंत्री ठहरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","बाक फिरौन यूसुफ से अंदुन, “फिरौन रा ना हुईन, अदिक मिस्त्र द्याश दा याऊ भी नीन आग्या अन बीना कय काल आळगाळस्तिदील,” ");
INSERT INTO hoy_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फिरौन यूसुफ उन हेसुर सापनत-पानेह ईटदुन. अदिक ओन नगर इन याजक पोतीपेरा अन पोर आसनत सांगुळ आऊन मदा माळसुसदुन. अदिक यूसुफ सप्पा मिस्त्र द्याश दा दौरा माळली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","याग यूसुफ मिस्त्र अन राजा फिरौन उन हात्ती निदुरदुन, आग आव तीस वर्ष इनव ईरोन. आव फिरौन उन हात्ती टु होटकु सप्पा मिस्त्र द्याश दा दौरा माळली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सुख इनव येळु वर्ष दा जमीन हापाळ अन्न पैदा माळतेला ईत्त. ");
INSERT INTO hoy_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","अदिक यूसुफ आ येळु वर्षगोळ दा सप्‍पा प्रकार इन भोजन वस्तुगोळ, जो मिस्त्र द्याश दा आगतोगोद, जमा माळकु नगरगोळ दा ईटतोगोन, अदिक हर ऊंद नगर इन नाकु दीकळव केईगोळ्द भोजन वस्तुगोळ इक आव अदा नगर दा जमा माळतेला ईत्तुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ई प्रकार यूसुफ अन्न इक समुद्र अन धुळा अन्द घाई बहुतायत देल राशी आळकु ईटदुन, ईल ताका कि आव अऊर्द आळोद बंद माळ बुट्टुन; यतिकी अव असंख्य आगेगीदव. ");
INSERT INTO hoy_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","अकाल इक पयला वर्ष बरोर से पयला यूसुफ उन येढ्ढ चिकोर, ओन नगर इन याजक पोतीपेरा अन पोर आसनत देल पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","अदिक यूसुफ तान पयला पार उन हेसुर ईद अनकु मनश्शे ईटदुन, “कि परमेश्वर नान से सप्पा क्लेश, अदिक नान आप्प उन सप्पा घराना मारसुसदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","दुसरा अन हेसुर आव ईद अनकु एप्रैम ईटदुन, कि “नानी दुख भोगस्दुर इन द्याश दा परमेश्वर फलवंत माळदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","अदिक मिस्त्र द्याश इन वळ्लीद फसल पकुसोद येळ वर्ष खतम आगेदव. ");
INSERT INTO hoy_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","अदिक यूसुफ उन अना अनुसार येळ वर्षगोळ साटी अकाल शुरू आगेत. सप्पा द्याशगोळ दा अकाल बिळली कुर्त; लेकीन सप्पा मिस्त्र द्याश दा अन्न ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","याग मिस्त्र अन सप्‍पा द्याश हसु देल सायली कुर्त; आग प्रजा फिरौन से चिळ्लास चिळ्लासकु अन्न बेळली कुर्त; अदिक आव सप्‍पा मिस्त्रीगोळ से अनतोगोन, “यूसुफ उन हाती होगी; अदिक जो येनारा आव नीम से अंदान, अदा माळी.” ");
INSERT INTO hoy_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","इदुरसाटी याग अकाल सप्‍पा पृथ्वी मा फैलुसेत, अदिक मिस्त्र द्याश दा अकाल इन भयंकर रूप आगेत, आग यूसुफ सप्‍पा भंडारगोळी तेगु तेगुकु मिस्त्रीगोळ कय देल अन्न मारली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","इदुरसाटी सप्‍पा पृथ्वी इन लॉकुर मिस्त्र दा अन्न कोमोर साटी यूसुफ उन हाती बरली कुरतुर, यतिकी सप्पा पृथ्वी मा भयंकर अकाल ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","याग याकूब केळदुन कि मिस्त्र द्याश दा अन्‍न आद, आग आव तान चिकोर से अंदुन, “नीव आबुर दाबुर बाय यती नोळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","बाक आव अंदुन, “ना केळीन कि मिस्त्र दा अन्न आद; इदुरसाटी नीव लॉकुर अल होगकु नाम साटी अन्न कोंडकु तरी, यदुर देल ना सायतीदील, बल्‍की जीत्ता ईत्तेव.” ");
INSERT INTO hoy_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","अत: यूसुफ उन हत्त वार्टुर अन्न कोमोर साटी मिस्त्र अक होदुर. ");
INSERT INTO hoy_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","लेकीन यूसुफ उन वार्ट बिन्यामीन उक याकूब ईद सोचकु वार्टुर सांगुळ कळीदील कि यागलु हिंग आग बाळुल कि आऊन मा यातोदु मुश्किल बंदकु बिळुल. ");
INSERT INTO hoy_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ई प्रकार जो लॉकुर अन्न कोमली बंदुर आंदुर सांगुळ इस्त्राएल उन पारगोळ भी बंदुर; यतिकी कनान द्याश दा भी भारी अकाल ईरोद. ");
INSERT INTO hoy_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","यूसुफ रा मिस्त्र द्याश इन प्रधानमंत्री ईरोन, अदिक आ द्याश इन सप्पा लॉकुरव कय दा आवा अन्न मारतोगोन; इदुरसाटी याग यूसुफ उन वार्ट बंदुर आग जमीन मा बाय इन भार देल बांगकु आऊक नमस्कार माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","आंदरी नोळकु यूसुफ अरू रा कोंडुन, लेकीन आंदुर मुंद भोला आगकु कठोरता अन सांगुळ आंदुर से केळदुन, “नीव येल टु बंदीर?” आंदुर अंदुर, “नाव रा कनान द्याश टु अन्न कोमोर साटी बंदेव.” ");
INSERT INTO hoy_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","यूसुफ तान वार्टुरी अरू कोंडुन, लेकीन आंदुर आऊक अरतीदील. ");
INSERT INTO hoy_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","आग यूसुफ तान आ कांसागोळी याद माळकु जो आव आंदुर बारा दा नोळीदुन, आंदुर से अनली कुरतुन, “नीव भेदीगोळ हुईर; ई द्याश इन हालत नोळली बंदीर.” ");
INSERT INTO hoy_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","आंदुर आऊन से अंदुर, “ईला, ईला, हे प्रभु, नीन दास तीना वस्तु कोमोर साटी बंदार. ");
INSERT INTO hoy_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","नाव सप्पा ऊंद अच आप्प उन चिकोर हुयेव, नाव सच्चा मंळसागोळ आयेव; नीन दासगोळ हूएव भेदीगोळ ईला.” ");
INSERT INTO hoy_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","आव आंदुर अंदुन, “ईला ईला, नीव ई द्याश इन हालत नोळोर साटी अच बंदीर.” ");
INSERT INTO hoy_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","आंदुर अंदुर, “नाव नीनोर दास हन्नेळ वार्टुर आयेव, अदिक कनान वासी ऊंद अच मंळसा नोर चिकोर हुयेव, अदिक श्याण्णेव ई समय नाम आप्प उन हाती आन, अदिक ऊंद वार्ट सोतोदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","आग यूसुफ आंदुर से अंदुन, “ना नीम से अन कोंडीन कि नीव भेदीगोळ हुईर; ");
INSERT INTO hoy_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","अत: ई रीति देल नीव परखुसकु आदीर, फिरौन उन जीवन इन कसम, यागासताका नीम श्याण्णेव वार्ट ईल बरालुन आगासताका नीव ईल टु होळ सकालीर. ");
INSERT INTO hoy_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","इदुरसाटी तान दा टु ऊंद मंळसा अक कळी कि आव नीम वार्ट उक तरूल, अदिक नीव लॉकुर नाम्द देखरेख दा ईत्तीर; ई प्रकार नीम मातगोळी परखुसकु आदीत कि नीम दा सच्चाई आद का हैलेच. अगर सच्चा ठहरूसतीदील आग रा फिरौन उन जीवन इन कसम नीव सही दा भेदीगोळ सम्सकु आदीर.” ");
INSERT INTO hoy_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","आग आव आंदरी मुर दिन ताका बंदी माळकु ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तीसरा दिशी यूसुफ आंदुर से अंदुन, “ऊंद क्याल्सा माळी आग जीत्ता ईत्तीर; यतिकी ना परमेश्वर उन भय मान्सतीन; ");
INSERT INTO hoy_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","अगर नीव सीधा मंळसा हुईर, रा नीम सप्पा वार्टुर दा टु ऊंद मंळसा ई बंदीगृह दा बंदी ईरूल; अदिक नीव तान मान्नावाळेर्द हसु मिटुसोद साटी अनाज वई, ");
INSERT INTO hoy_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","अदिक तान श्याण वार्ट उक नान हाती तरी; ई प्रकार नीम मातगोळ सच्चा ठहरूसेव, अदिक नीव कोंदसुसकु आगतीदील.” आग आंदुर हांग अच माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","आंदुर आपस दा अंदुर, “बिलकुल नाव तान वार्ट उन बारा दा दोषी आयेव, यतिकी याग आव नाम से गिळगिळास्कु विनती माळदुन, आग भी नाव ईद नोळकु कि आऊन जीवन ह्यांग संकट दा आद, आऊंद केळीदील; ईदा कारण नाव भी ईग ईद संकट दा बिदकु आयेव.” ");
INSERT INTO hoy_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रूबेन आऊन से अंदुन, “येन ना नीम से अंदिदीन कि पार उन अपराधी आगबाळी? लेकीन नीव केळीदील. नोळी, ईग आऊन रक्ता अन बदला ताकोमकु आदीत.” ");
INSERT INTO hoy_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","यूसुफ तान वार्टुर से मात माळोर साटी ऊंद दुसरा भाषा देल क्याल्सा ताकोमोन. इदुरसाटी वार्टुर ईला जानसोर कि यूसुफ आंदुर भाषा जान्सतान. लेकीन आंदुर जो अनतोगोर अदरी यूसुफ केळोन अदिक समसोन. ");
INSERT INTO hoy_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","आंदुर मातगोळ से यूसुफ हापाळ दुखी आदुन. इदुरसाटी यूसुफ आंदुर से अलग हटसेदुन अदिक वर्लली कुरतुन. थ्वाळासा समय दा यूसुफ आंदुर हाती बंदुन. आव वार्टुर दा टु शिमोन उक हुळदुन अदिक आऊक बंदी माळदुन याग कि अन्य वार्टुर नोळतेला ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","आग यूसुफ आग्या कोट्टुन, कि आंदुरव बॉरागोळी अन्न देल तुमी अदिक ऊंद ऊंद मंळसा बॉरा दा आंदुर पैस्यागोळी भी ईट बुळी, बाक आंदरी हादी इन साटी भोजन वस्तु कोळी. आंदुर सांगुळ हिंग अच माळकु आत. ");
INSERT INTO hoy_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","आग आंदुर तान अनाज इन बॉरागोळ इक तान गधागोळ मा लादस्कु अल टु होदुर. ");
INSERT INTO hoy_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","आंदुर सप्पा वार्टुर ईळ्‍ल्‍क इक थाम्सदुर अदिक गधा अक चारा कोळोर साटी वार्टुर दा टु ऊंद येनारा अन्न इन साटी तान बॉरा तेरदुन अदिक आव धन तान बॉरा दा नोळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","आव तान वार्टुर से अंदुन, “नोळी, जो किमत ना अन्‍न साटी कोटीदीन, अद ईल आद. यावारा नान बॉरा दा ईद धन वापस माळ कोंडान. आंदुर सप्पा वार्टुर हापाळ अंजेदुर. आंदुर आपस दा मातगोळ हेळदुर, परमेश्वर नाम लॉकुर सांगुळ येन माळेत्यान?” ");
INSERT INTO hoy_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","आंदुर वार्टुर कनान द्याश दा तान आप्प याकूब उन हाती होदुर. आंदुर जो येनारा आगीत तान आप्प उक हेळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","आंदुर अंदुर, “जो मंळसा आ द्याश इन स्वामी आन, आव नाम से कठोरता देल मात हेळदुन, अदिक नामी द्याश इन भेदीगोळ अंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","आग नाव आऊन से अंदेव, ‘नाव सीधा लॉकुर आयेव, भेदीगोळ ईला. ");
INSERT INTO hoy_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","नाव हन्नेळ वार्टुर ऊंद अच आप्प उन चिकोर हुयेव, ऊंद रा सोत्तुन, लेकीन श्याण्णेव ई समय कनान द्याश दा नाम आप्प उन हात्ती आन.’ ");
INSERT INTO hoy_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","आग आ मंळसा जो आ द्याश इन स्वामी आन, नाम से अंदुन, ‘ईदुर देल मालुम आगेदीत कि नीव सीधा मंळसागोळ आईर; नीव ताम दा टु ऊंद इक नान हाती बिटकु तान मान्या वाळेर्द हसु मीटसोर साटी येनारा अनाज वई. ");
INSERT INTO hoy_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","अदिक तान श्याण वार्ट उक नान हाती तरी. आग नानी विश्वास आगेदीत कि नीव भेदीगोळ आलच, सीधा लॉकुर आईर. बाक ना नीम वार्ट उक नीम लॉकुर कोट बुळाईन, अदिक नीव ई द्याश इन सांगुळ लेन देन माळ सकीर.’” ");
INSERT INTO hoy_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","आग सप्पा वार्टुर तान बॉरागोळ दा टु अन्न तेगोर साटी होदुर अदिक हर ऊंद वार्ट तान धन इन चिला तान अन्न अन बॉरा दा नोळदुन. वार्टुर अदिक आप्प धन इक नोळदुर अदिक आंदुर हापाळ अंजेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","आग आंदुरव आप्प याकूब आंदुर से अंदुन, “नीव लॉकुर नानी बिना औलाद इन माळ कोंडीर, नोळी, यूसुफ ईतीदील, अदिक शिमोन भी बंदिदील, अदिक ईग नीव बिन्यामीन उक भी ओयोद चाहासतीर. ईव सप्पा परेशानीगोळ नान मा बंदाव.” ");
INSERT INTO hoy_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","रूबेन तान वार्ट से अंदुन, “अगर ना आऊक नीन हाती तरतीदील, रा नान येढ्ढु पारगोळ इक कोंद बुळेत; नी आऊक नान कय दा कोट्टबुळ, ना आऊक नीन हाती मात पोहचुस बुळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","आव अंदुन, “नान पार नीन सांगुळ होगतीदील; यतिकी आऊन वार्ट सोतोग्यान, अदिक ईग आव आबना आन : इदुरसाटी याता हादी देल नी होद्या, अल अगर आऊन मा यातोदारा विपत्ती बंदीत, आग रा ना नीम कारण ई हाळाबाट्ट इन समय दा दुख इन सांगुळ अधोलोक दा होटोगाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","कनान द्याश दा अकाल अदिक भी भयंकर आगतेला होत. ");
INSERT INTO hoy_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","याग अद अनाज जो आंदुर मिस्त्र टु तंदीदुर, खतम आत आग आंदुर आप्प आंदुर से अंदुन, “मात होगकु नाम साटी येनारा अदिक भोजन वस्तु कोंडकु तरी.” ");
INSERT INTO hoy_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","आग यहूदा आंदुर से अंदुन, “आ मंळसा नामी चेतावनी कोटकु अंदुन, ‘अगर नीम वार्ट नीम सांगुळ बरतीदील, रा नीव नान हाती बर सकतीदील.’ ");
INSERT INTO hoy_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","इदुरसाटी अगर नी नाम वार्ट उक नाम सांगुळ कळ्या, आग रा नाव नीन साटी भोजन वस्तु कोंडकु तंदेव; ");
INSERT INTO hoy_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","लेकीन अगर नी आऊक कळुतिदील, रा नाव होगतीदील, यतिकी आ मंळसा नाम से अंदान, ‘अगर नीम वार्ट नीम सांगुळ ईरतीदील, रा नीव नान हाती बर सकतीदील.’” ");
INSERT INTO hoy_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","इस्त्राएल याकूब से अंदुन, “नीव लॉकुर आ मंळसा से यती अंदीर, कि नीमव दुसरा वार्ट भी आन. नीव लॉकुर नान सांगुळ ईत्ता बुरा मात यती माळदीर?” ");
INSERT INTO hoy_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","आंदुर अंदुर, “याग आ मंळसा नाम्द अदिक नामोर रिश्तेदारगोळ्द स्थिति इन बारा दा केळदुन, ‘येन नीमव आप्प ईगासताका जीत्ता आन?’ आग नाव ई प्रश्नगोळ अनुसार आऊन से वर्णन माळदेव; बाक नाव येन जानसेव कि आव अंदान, ‘तान वार्ट उक ईल तरी.’” ");
INSERT INTO hoy_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","बाक यहूदा तान आप्प इस्त्राएल से अंदुन, “आ पार उक नान सांगुळ कळी, कि नाव होटोदेव; ईदुर देल नाव, अदिक नी, अदिक नाम चिकोर सायतीदिल, बल्‍की जित्ता ईत्तार. ");
INSERT INTO hoy_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ना विश्वास दिलुसतीन कि आव सुरक्षित ईत्तान. ना ईदुर्द उत्तरदायी ईराईन. अगर ना आऊक नीम हाती वापस तरतीदील रा सदा अन साटी नानी दोषी ठहरूस सकतीर. ");
INSERT INTO hoy_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","अगर नीव नामी पयले होग गोळाईदिर रा भोजन इन साटी नाव लॉकुर येढ्ढ यात्रागोळ ईगासताका माळ कोमायदेव.” ");
INSERT INTO hoy_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","आग आंदुर आप्प इस्त्राएल अंदुन “अगर सहीदा ईत्ता मात आद, रा ईद माळी; ई द्याश इन वळ्लीद वळ्लीद वस्तु दा टु येनारा तान बॉरा दा आ मंळसा अन साटी भेंट वई: ह्यांग कि थ्वाळासा ढीक, अदिक थ्वाळासा शयद, अदिक येनारा सुगन्ध द्रव्य, अदिक गन्धरस, पिस्ते, अदिक बादाम. ");
INSERT INTO hoy_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","बाक तान तान सांगुळ येढ्ढ गुणा येक्‍कुल पैस्या वई; अदिक जो पैस्या नीम बॉरा दा ईटकु वापस माळकु आगीदव, अवरी भी वई; आग सकतद ईद भूल देल आगीदाद. ");
INSERT INTO hoy_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","तान वार्ट उक भी सांगुळ हुडुकु आ मंळसा अन हाती मात्त होगी, ");
INSERT INTO hoy_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","अदिक सर्वशक्तिमान परमेश्वर आ मंळसा अक नीम मा दयालु माळ्यान, यदुर देल कि आव नीम दुसरा वार्ट उक अदिक बिन्यामीन उक भी बर गोळुल: अदिक अगर ना निर्वंश आगतीन रा आगगोळी.” ");
INSERT INTO hoy_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","आग आ मंळसागोळ अव भेंट, अदिक दुगणा पैस्या, अदिक बिन्यामीन उक भी सांगुळ हुळदुर, अदिक होट्टुर अदिक मिस्त्र दा पोहचुस्कु यूसुफ उन मुंद नीदुरदुर. ");
INSERT INTO hoy_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","आंदुर सांगुळ बिन्यामीन उक नोळकु यूसुफ तान मान्या अन अधिकारीगोळ से अंदुन, “आ मंळसागोळी मान्या दा तरी, यतिकी आ लॉकुर हागुल नान सांगुळ भोजन माळ्‍यार.” ");
INSERT INTO hoy_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","आग आव अधिकारी मंळसा यूसुफ उन अना अनुसार आ मंळसागोळी यूसुफ उन मान्या वोतुन. ");
INSERT INTO hoy_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","याग आंदुर यूसुफ उन मान्या पोहचुस्कु आदुर आग आंदुर आपस दा अंजकु अनली कुरतुर, “जो पैस्या पयला घन नाम बॉरागोळ दा वापस माळकु आगीदव, अदुर्दा कारण नाव बुळ्क पोहचुस्कु आगेव; कि आव मंळसा नाम मा येरूल, अदिक नामी वश दा माळकु तान दास माळ्यान, अदिक नाम गधागोळी भी कसुल.” ");
INSERT INTO hoy_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","आग आंदुर यूसुफ उन मान्या अन अधिकारी अन हाती होगकु मान्या अन दरवाजा मा होगकु ई प्रकार अनली कुरतुर, ");
INSERT INTO hoy_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“हे नाम प्रभु, याग नाव पयला घन अन्न कोमोर साटी बंदीदेव, ");
INSERT INTO hoy_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","आग नाव सराय दा पोहचुस्कु तान बॉरागोळी तेरदेव, रा येन नोळदेव, कि ऊंद ऊंद मंळसा अन पुरा पुरा पैस्या आऊन बॉरा दा ईटकु आव; इदुरसाटी नाव आ पैस्यागोळी मात्त वापस तंदेव. ");
INSERT INTO hoy_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","अदिक दुसरा पैस्या भी भोजन वस्तु कोमोर साटी तंदेव; नाव जानसालेव कि नाम बॉरागोळ दा नामव पैस्या याव ईट कोंडीदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","आव अंदुन, “नीम्द वळ्लीद आगुल, अंजबाळी: नीम परमेश्वर, जो नीम आप्प उन भी परमेश्वर हुन, आवा नीमी नीम बॉरा दा धन कोटीदान, नीम पैस्या रा नानी सीकीगित.” बाक आव शिमोन उक तेगुकु आंदुर सांगुळ माळ बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","सेवक आ लॉकुरी यूसुफ उन मान्या वोतुन. आव आंदरी नीर कोट्टुन अदिक आंदुर तान काल तोळदुर. आगासताका आव आंदुर गधागोळी तीनली चारा कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","वार्टुर केळदुर कि आंदुर यूसुफ उन सांगुळ भोजन माळ्यार. इदुरसाटी आऊन साटी तान भेंट तैयार माळदुर दा हागुल ताका हतकु ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","यूसुफ मान्या बंदुन अदिक वार्टुर आऊक भेंट कोट्टुर जो आंदुर तान सांगुळ तंदीदुर. आग आंदुर जमीन मा बांगकु प्रणाम माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","यूसुफ आंदुर से आंदुर्द कुशल केळदुन. यूसुफ अंदुन, “नीम लॉकुर बाट्ट आप्प यार बारा दा नीव हेळीदीर, वळ्लेव रा आन? येन आव ईगासताका जीत्ता आन?” ");
INSERT INTO hoy_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","वार्टुर उत्तर कोट्टुर, “महोदय, नाम आप्प वळ्लेव आन. आव ईगासताका जीत्ता आन” अदिक आंदुर मात्त यूसुफ उन मुंद बांगदुर. ");
INSERT INTO hoy_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","आग यूसुफ तान वार्ट बिन्यामीन उक नोळदुन. अदिक यूसुफ अंदुन, “येन ईव नीम लॉकुरव सबसे श्याण्णेव वार्ट हुन यार्द बारा दा नीव हेळीदीर?” आग यूसुफ बिन्यामीन से अंदुन, “परमेश्वर नीन मा अनुग्रह माळुल.” ");
INSERT INTO hoy_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","यूसुफ खोली दा टु व्हार्या ओळतेला होदुन. यूसुफ हापाळ चाहासोन कि आव तान वार्टुर से हापाळ प्रेम माळतान. आव वर्लदुर घाई आगोन, लेकीन आव ईला चाहासोन कि आऊन वार्ट आऊक वर्लतेला नोळुल. इदुरसाटी आव तान खोली दा ओळतेला होदुन अदिक अल्या वर्लदुन. ");
INSERT INTO hoy_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","आग यूसुफ तान बाय तोळदुन अदिक व्हार्या बंदुन. आव तान तानीक संभाळसदुन अदिक अंदुन, “ईग भोजन माळोद समय आद.” ");
INSERT INTO hoy_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","आग आंदुर यूसुफ उन साटी अलग, अदिक आऊन वार्टुर साटी अलग, अदिक जो मिस्त्री आऊन सांगुळ तीन तोगोर, आंदुर साटी भी अलग भोजन वाट्सदुर; इदुरसाटी कि मिस्त्री इब्रीगोळ सांगुळ भोजन माळ सकालुर, बल्‍की मिस्त्री हिंग माळोद घृणा सम्स तोगोर. ");
INSERT INTO hoy_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","रा यूसुफ उन वार्ट आऊन मुंद, धोड्डेर पयले, अदिक श्याण्णेर हिंद, तान तान अवस्था अन अनुसार, क्रम देल कुर्सकु आदुर; ईद नोळकु आंदुर विस्मित आगकु आबुर दाबुर दी नोळली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","आग यूसुफ तान मुंद टु भोजन वस्तुगोळ नेगु नेगुकु आंदुर हाती कळुली कुरतुन, अदिक बिन्यामीन उक तान वार्टुर से अईद गुणा भोजन वस्तु सिक्त. अदिक आंदुर आऊन सांगुळ हापाळ तिंदुर कुळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","आग आव तान मान्या अन अधिकारी इक आग्या कोट्टुन, “ई मंळसागोळ बॉरागोळ दा याट भोजन वस्तु बर सकताव आट तुमकोळी, अदिक ऊंद ऊंद मंळसा अन पैस्या अक आंदुरव बॉरा अन बाय मा ईट बुळी. ");
INSERT INTO hoy_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","अदिक नांद चांदी इन कटोरा श्याण वार्ट उन बॉरा अन बाय मा आऊन अन्न अन पैस्या अन सांगुळ ईट बुळी.” यूसुफ उन ई आग्या अन अनुसार आव माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","दुसरा दिशी हापाळ व्हातर्या सप्पा वार्टुर तान गधागोळ सांगुळ तान द्याश इक वापस कळुकु आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","याग आंदुर नगर इक बिट्ट बुट्टुर, यूसुफ तान सेवक से अंदुन, “होग अदिक आ लॉकुर्द पीछा माळ. आंदरी रोक्स अदिक आंदुर से अन, ‘नाव लॉकुर नीम लॉकुर प्रती वळ्लेव ईत्तेव. लेकीन नीव लॉकुर नाम मान्या काळ्लपनी यती माळदीर? नीव लॉकुर यूसुफ उन चांदी इन कटोरा यती कदुदीर? ");
INSERT INTO hoy_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","येन अद ईद वस्तु आलच यदुर दा नान स्वामी आप्प आन, अदिक यदुर देल आव गुप्त मातगोळ भी माळतान? नी जो ईद माळ्या अद बुरा आद.’” ");
INSERT INTO hoy_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","आग आव आंदरी हुळदुन, अदिक हिंगा मातगोळ आंदुर से अंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","आंदुर आऊन से अंदुर, “हे नामव प्रभु, नी हिंग मातगोळ यती अनत्या? हिंग क्याल्सा माळेत नीन दासगोळ से दुर ईरूल. ");
INSERT INTO hoy_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","नोळ जो पैस्या नाम बॉरागोळ बाय मा होटीत, याग नाव अदरी कनान द्याश टु तनकु नीनी वापस कोट्टेव, आग भला, नीन स्वामी इन मान्या टु नाव यातोदारा चांदी या व्हान्ना अन वस्तु ह्यांग कदू सकतेव? ");
INSERT INTO hoy_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","नीन दासगोळ दा टु यारदारा हाती भी अद होट्टीत, आऊक कोंदकु आगुल, अदिक नाव भी तान आ प्रभु उन दास आगेदेव.” ");
INSERT INTO hoy_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","आव अंदुन, “नीम्द अच अनोद सही, यार हाती भी अद कटोरा होट्टीत आव नान दास आदान; अदिक नीव लॉकुर निर्दोष ठहरूसीर.” ");
INSERT INTO hoy_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ईदुर मा आंदुर जल्दी तान तान बॉरागोळी ईळ्सकु जमीन मा ईटकु अवरी तेगुली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","आग आव ढुंढ्‍सली कुरतुन, अदिक श्याणेव उन हाती टु धोड्डेव उन बॉरा ताका खोज माळदुन: अदिक कटोरा बिन्यामीन उन बॉरा दा सीक्त. ");
INSERT INTO hoy_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","आग आंदुर दुख दा तान तान कपळा हरदुर, अदिक तान तान गधागोळ लादस्कु नगर इक वापस होदुर. ");
INSERT INTO hoy_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","याग यहूदा अदिक आऊन वार्ट यूसुफ उन मान्या पोहचुसदुर, अदिक यूसुफ अल्या ईरोन, आग आंदुर आऊन मुंद जमीन मा बिद्दुर. ");
INSERT INTO hoy_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","यूसुफ आंदुर से अंदुन, “नीव लॉकुर ईद ह्यांग क्याल्सा माळीर? येन नीव जानसीर नान जसा मंळसा गुप्त मातगोळ इक जान्स सकतीन?” ");
INSERT INTO hoy_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदा अंदुन, “नाव लॉकुर तान प्रभु से येन अंदेव? नाव येन अनकु तान तान इक निर्दोष ठहरूसेव? परमेश्वर नीन दासगोळ्द अधर्म इक हुडु कोंडान. नाव, अदिक यार हाती कटोरा होटाद आव भी, नाव सप्पा तान प्रभु उन दास अच हुयेव.” ");
INSERT INTO hoy_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","आव अंदुन, “हिंग माळोद नान से दुर ईरूल, याता मंळसा अन हाती कटोरा होटाद, आवा नान दास आदान; अदिक नीव लॉकुर तान आप्प उन हाती कुशल देल होटोगी.” ");
INSERT INTO hoy_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","आग यहूदा आऊन हाती होगकु अनली कुरतुन, “हे नान प्रभु, नीन दास उक तान प्रभु से ऊंद मात अनोद आग्या कोळ, अदिक नीन कोप नीन दास मा भळकुस बाळुल; यतिकी नी रा फिरौन उन घाई आय. ");
INSERT INTO hoy_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","नान प्रभु तान दासगोळ से केळीदुन, ‘येन नीम आप्प या दुसरा वार्टुर आर?’ ");
INSERT INTO hoy_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","अदिक नाव नीनी उत्तर कोट्टेव, नामव ऊंद आप्प आन, आव हाळाबाट्ट आन अदिक नामव ऊंद श्याणेव वार्ट आन, नाम आप्प आऊन से हापाळ प्यार माळतान, यतिकी आऊन जनम आऊन बुळापा दा आगीत, आव आबना पार आन. नाम आप्प आऊन से हापाळ प्यार माळतान. ");
INSERT INTO hoy_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","आग नी नाम से अंदीद, ‘आ वार्ट उक नान हाती तरी. ना आऊक नोळोद चाहसतीन.’ ");
INSERT INTO hoy_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","आग नाव तान प्रभु से अंदिदेव, ‘आव पार बर सकालुन. आव तान आप्प उक बीळ सकालुन, ईदारा आऊन आप्प सोतोदान.’ ");
INSERT INTO hoy_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","अदिक नी तान दासगोळ से अंद, ‘अगर नीम श्याण वार्ट नीम सांगुळ बरतीदील, रा नीव नान हाती बाक बर सकतीदिल.’ ");
INSERT INTO hoy_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","इदुरसाटी नाव लॉकुर तान आप्प उन हाती होदेव अदिक नी जो टान प्रभु उन बारा दा अंदीद, आऊक हेळदेव.” ");
INSERT INTO hoy_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“आग नाम आप्प अंदुन, ‘मात्त होगकु नाम साटी थ्वाळासा भोजन वस्तु कोंडकु तरी.’ ");
INSERT INTO hoy_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","अदिक नाव लॉकुर तान आप्प से अंदेव, नाव लॉकुर तान सब से श्याणेव वार्ट उन बीना होग सकालेव, शासक अंदान कि आव आगासताका नाम लॉकुरी अनाज मारतीदिल यागासताका आव नाम श्याणेव वार्ट उक नोळ कोमालुन.” ");
INSERT INTO hoy_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","आग नान आप्प नाव लॉकुर से अंदुन, “नीव जान्सतीर कि नान हिंग्स राहेल नानी येढ्ढ पार कोट्टुर. ");
INSERT INTO hoy_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ना ऊंद पार उक दुर होग गोट्टीन अदिक आव आळी दाकळव जनावर द्वारा सोतोदुन अदिक आग टु ना आऊक नोळीदील. ");
INSERT INTO hoy_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","अगर नीव लॉकुर नान दुसरा पार उक नान से दुर वोतीर अदिक आऊक येनारा आगेतद रा नानी ईट दुख आदीत कि ना सोतोगाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","इदुरसाटी अगर ईग नाव तान सब से श्याणेव वार्ट उन बीना मान्नी होदेव आग नाव आप्प उक ईद नोळोद बिद्दीत, ईव श्याणेव पार नाम आप्प उन जीवन दा सब से येक्‍कुल महत्व ईटतान. ");
INSERT INTO hoy_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","याग आव नोळ्यान कि श्याणेव पार नाम सांगुळ हैलेच रा आव सोतोदान अदिक ईद नाम लॉकुर्द दोष ईत्तीत. नाव लॉकुर तान आप्प उन हापाळ दुख अदिक सायोद कारण आदेव. ");
INSERT INTO hoy_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“ना श्याण पार उन जिम्मेदारी ताकोंडीन, ना तान आप्प से अंदीन, ‘अगर ना आऊक नीन हाती वापस तरतीदील रा नी नानी पुरा जीवन तीम दोषी ठहरूस सकत्या.’ ");
INSERT INTO hoy_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","इदुरसाटी ईग ना नीन से बेळतीन, अदिक नीन से प्रार्थना माळतीन कि कृपा माळकु श्याण पार उक तान वार्टगोळ सांगुळ वापस होग गोळ अदिक ना ईल ईराईन अदिक नीन दास आगाईन. ");
INSERT INTO hoy_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ना तान आप्प उन हाती वापस होग सकालीन अगर नाम सांगुळ श्याणेव वार्ट ईरतीदील, ना ईद मात देल हापाळ अंजकु आईन कि नान आप्प उन सांगुळ येन आदीत.” ");
INSERT INTO hoy_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","आग यूसुफ आ सप्पा मुंदुर मुंद, जो आऊन आस पास नीदुरकु ईरोर, तान इक अदिक रोक्स सकीदील; अदिक कारूकु अंदुन, “नान आस पास इन सप्‍पा लॉकुर इक व्हार्या माळ बुळी.” वार्टुर मुंद खुद इक प्रगट माळा वती यूसुफ उन सांगुळ अदिक याऊ ईला ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","आग आव चिल्ळास चिल्ळासकु वर्लली कुरतुन; अदिक मिस्त्रीगोळ केळदुर, अदिक फिरौन उन मान्यागोळ लॉकुरी ईदुर्द समाचार सीक्त. ");
INSERT INTO hoy_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","आग यूसुफ तान वार्टुर से अनली कुरतुन, “ना यूसुफ हुईन, येन नान आप्प ईगासताका जित्ता आन?” ईदुर्द उत्तर आऊन वार्टुर कोळ सकीदील; यतिकी आंदुर आऊन मुंद घबरूसेदुर. ");
INSERT INTO hoy_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","बाक यूसुफ तान वार्टुर से अंदुन, “नान हाती बरी.” ईद केळकु आंदुर हाती होदुर. बाक आव अंदुन, “ना नीम वार्ट यूसुफ हुईन, यारी नीव मिस्त्र बरावाळा अक मार बुटीदिर. ");
INSERT INTO hoy_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ईग नीव लॉकुर पचतासबाळी, अदिक नीव जो नानी ईल मार बुट्टीर, ईदुर से उदास आगबाळी; यतिकी परमेश्वर नीम जीव उळसोर साटी नानी नीम मुंद कळु कोंडान. ");
INSERT INTO hoy_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","यतिकी ईग येढ्ढ वर्ष टु ई द्याश दा अकाल आद; अदिक ईग अईद वर्ष अदिक हिंगा ईत्तव यतिकी अऊर दा ना ईग नांगर नळदीत अदिक न अनाज कडुकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","परमेश्वर नानी नीम मुंद इदुरसाटी कळ्यान कि नीव पृथ्वी मा जीत्ता ईरूल, अदिक नीम जीव इन ऊळोर से नीम वंश वाळुसुल. ");
INSERT INTO hoy_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ई रीति देल ईग नान इक ईल कळावाळेर नीव आलच, परमेश्वर अच ठहरूसदुन; अदिक आवा नानी फिरौन उन आप्प घाई, अदिक आऊन सप्पा मान्ना अन स्वामी, अदिक सप्पा मिस्त्र द्याश इन अधिकारी ठहरूस बुटान. ");
INSERT INTO hoy_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ईग जल्दी नान आप्प उन हाती होगकु अनी, ‘नीन पार यूसुफ ई प्रकार अनेत्यान, कि परमेश्वर नानी सप्पा मिस्त्र द्याश इन अधिकारी ठहरूस्यान; इदुरसाटी नी नान हाती बीना समय माळकु होटबर. ");
INSERT INTO hoy_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","अदिक नीन निवास गोशेन द्याश दा ईत्तीत, अदिक नी पारगोळ, नातुगोळ, व्हात-मर्रीगोळ, गोस-वस्‍तागोळ, अदिक तान सप्पा येनारा अन सांगुळ नान हाती ईत्या. ");
INSERT INTO hoy_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","अदिक अकाल ईनव अईद वर्ष अदिक ईत्तव, अऊर दा ना अल्या नींद पालन पोषण माळाईन; हिंग आगबाळुल कि नी, अदिक नींद घराना, बल्‍की यास नीनोर जनावर आव, आंदुर हसु देल सायुल.’ ");
INSERT INTO hoy_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","अदिक नीव तान कण्ण देल नोळेतीर, अदिक नान वार्ट बिन्यामीन भी तान कण्‍ण देल नोळेत्यान कि जो नाम से मातगोळ माळेत्यान आव यूसुफ हुन. ");
INSERT INTO hoy_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","नीव नान सप्पा वैभव इन, जो मिस्त्र दा आद अदिक जो येनारा नीव नोळदीर, आ सप्पा अन नान आप्प से वर्णन माळेतीर; अदिक तुरन्त नान आप्प उक ईल तरेतीर.” ");
INSERT INTO hoy_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","अदिक आव तान वार्ट बिन्यामीन उक याद्दा देल हचकु वर्लदुन; अदिक बिन्यामीन भी आऊन याद्दी इक लपटुसकु वर्लदुन. ");
INSERT INTO hoy_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","आव तान सप्पा वार्टगोळी चुम्सकु आंदुर साटी वर्लदुन, अदुर बाद्दा आऊन वार्टुर आऊन सांगुळ मातगोळ हेळली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ई मात इन समाचार कि यूसुफ उन वार्टुर बंदार, फिरौन उन भवन ताका पोहचुसेत, अदिक ईदुर देल फिरौन अदिक आऊन कर्मचारी खुश आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","इदुरसाटी फिरौन यूसुफ से अंदुन, “तान वार्टुर से अन कि ऊंद क्याल्सा माळ्‍यार: आंदरी याट अनाज हततद तान जनावरगोळ मा मंळ्सकु, कनान द्याश इक वापस होगुल. ");
INSERT INTO hoy_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","अदिक तान आप्प अदिक तान तान मान्या अन लॉकुरी हुडुकु नान हाती बंदार: अदिक मिस्त्र द्याश दा जो येनारा भी वळ्लीद से वळ्‍लीद आद अद ना नीमी कोळाईन, अदिक नीमी द्याश इन वळ्लीद से वळ्लीद पदार्थ तीनली सीक्कीत. ");
INSERT INTO hoy_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","अदिक नीनी आग्या सिक्याद, ‘नीव ऊंद क्याल्सा माळी कि मिस्त्र द्याश टु तान चिकोरी अदिक आर्तेर साटी गाळागोळ वोई, अदिक तान आप्प उक तरी. ");
INSERT INTO hoy_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","अदिक तान सामान इन चिन्ता माळ बाळेतीर; यतिकी सप्‍पा मिस्त्र द्याश दा जो येनारा वळ्लीद से वळ्लीद आद अद नीम्द हुन.’” ");
INSERT INTO hoy_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","इस्त्राएल उन पारगोळ हांग अच माळदुर; अदिक यूसुफ फिरौन उन आग्या अनुसार आंदरी गाळागोळ कोट्टुन, अदिक हादी साटी भोजन इन सामान भी कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","आंदुर दा टु ऊंद ऊंद मंळसा अक रा ऊंद ऊंद जोळा कपळा भी कोट्टुन; अदिक बिन्यामीन उक मुर सौ रूपया अन बेळ्ली नव सिक्का अदिक अईद जोळा कपळा कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","तान आप्प उन हाती आव जो कळुदुन अद ईद हुन, मतलब मिस्त्र अन वळ्लीद वस्तुगोळ देल तुमकु हत्त गधा, अदिक अनाज अदिक रोट्टी अदिक आऊन आप्प उन हादी साटी भोजन वस्तु देल तुमकु हत्त आर्त गधागोळ. ");
INSERT INTO hoy_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","आग आव तान वार्टुरी सार माळदुन, अदिक आंदुर नळदुर; अदिक आव आंदुर से अंदुन, “हादी मा येल्यारा झगळा माळबाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","मिस्त्र टु नळुकु आंदुर कनान द्याश दा तान आप्प याकूब उन हाती पोहचुसदुर. ");
INSERT INTO hoy_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","अदिक आऊन से ईद वर्णन माळदुर, “यूसुफ ईगासताका जीत्ता आन, अदिक सप्पा मिस्त्र द्याश मा प्रभुता आवा माळतान.” लेकीन आव आंदुर मा विश्वास माळीदिल, अदिक आव तान तान दा ईला ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","आग आंदुर तान आप्प याकूब से यूसुफ उन सप्पा मातगोळ, जो आव आंदुर से अंदीदुन, अंदुर; याग आव आ गाळागोळ इक नोळदुन, जो यूसुफ आऊक तरोर साटी कळीदुन, आग आऊन चित्त थामसेत. ");
INSERT INTO hoy_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","अदिक इस्त्राएल अंदुन, “बस, नान पार यूसुफ ईगासताका जीत्ता आन; ना तान मृत्यु से पयले होगकु आऊक नोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","आग इस्त्राएल तान सप्पा येनारा हुडुकु बेर्शेबा अक होदुन, अदिक अल तान आप्प इसहाक उन परमेश्वर उक बलिदान येर्सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","आग परमेश्वर इस्त्राएल से ईळ्लक इक दर्शन दा अंदुन, “हे याकूब हे याकूब.” आव अंदुन, “येन आग्या.” ");
INSERT INTO hoy_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","आव अंदुन, “ना परमेश्वर नीन आप्प उन परमेश्वर हुईन, नी मिस्त्र होगली अंजबाळ; यतिकी ना नीन से अल ऊंद धोळ्द जाती माळाईन. ");
INSERT INTO hoy_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ना नीन सांगुळ सांगुळ मिस्त्र अक बरतीन; अदिक ना नीनी अल बाक सही दा तराईन; अदिक यूसुफ तान कय देल नीन कण्ण इक बंद माळ्यान.” ");
INSERT INTO hoy_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","आग याकूब बेर्शेबा टु नळदुन; अदिक मिस्त्र ताका यात्रा माळदुन, इस्त्राएल उन चिकोर, मतलब याकूब इन चिकोर तान आप्प, तान हिंग्सगोळ अदिक तान सप्‍पा चिकोर इक मिस्त्र तंदुर, आंदुर फिरौन द्वारा कळुकु आगीदव आ गाळागोळ देल यात्रा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","आंदुर तान व्हात मर्र, वस्ता गोस, अदिक कनान द्याश दा तान जमा माळ्द सप्पा धन इक हुडुकु मिस्त्र दा बंदुर. ");
INSERT INTO hoy_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","अदिक याकूब तान पोर पारगोळ, नातु नातीगोळ, मतलब तान वंश इक तान सांगुळ मिस्त्र दा तंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","याकूब उन सांगुळ जो इस्त्राएली, मतलब आऊन पारगोळ, नातीगोळ, पयले मिस्त्र दा बंदुर, आंदुर हेसुर ईव आव याकूब उन धोड्डेव पार रूबेन ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","अदिक रूबेन उन पार हनोक, पल्लू, हेस्त्रोन, अदिक कर्मी ईरव. ");
INSERT INTO hoy_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमोन उन पार, यमूएल, यामीन, ओहद, याकीन, सोहर, अदिक ऊंद कनानी आर्त से पैदा आगीदुन शाऊल भी ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवी इन पार गेर्शोन, कहात, अदिक मरारी ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदा अन एर, ओनान, शेला, पेरेस, अदिक जेरह हेसुर इन पारगोळ आगीदुर; लेकीन एर अदिक ओनान कनान द्याश दा सोतोगीदुर; अदिक पेरेस उन पारगोळ, हेस्रोन अदिक हामुल ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साकार उन पारगोळ, तोला, पुब्बा, योब अदिक शिम्रोन ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलून उन पारगोळ, सेरेद, एलोन, अदिक यहलेल ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","लियाह अन पारगोळ जो याकूब देल पद्‍दनराम दा पैदा आगीदुर, आंदुर पारगोळ नातीगोळ ईंदुर अच ईरोर, अदिक ईंदुर से येक्‍कुल आव आंदुर सांगुळ ऊंद पोर दीना अक जनम कोटीदुन. ईल ताका रा याकूब उन सप्पा वंश वाळेर तैतीस लॉकुर आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","बाक गाद इन पारगोळ, सपोन, हाग्गी, शूनी, एसबोन, एरी, अरोदी, अदिक अरेली ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेर इन पारगोळ, यिम्ना, यिक्ष्वा, यिक्ष्वी, अदिक बरीआ ईरोर, अदिक आंदुर आकतींग सेरह ईरोर; अदिक बरीआ अन पारगोळ, हेबेर अदिक मल्कीएल ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","जिल्‍पा, यारी लाबान तान पोर लियाह अक कोटीदुन, आऊन पारगोळ नातीगोळ पयले ईंदुर अच ईरोर; अदिक आऊन द्वारा याकूब उन सोलह लॉकुर पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","बाक याकूब उन हिंग्स राहेल इन पारगोळ यूसुफ अदिक बिन्यामीन ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","अदिक मिस्त्र द्याश दा ओन नगर इन याजक पोतीपेरा अन पोर आसनत देल यूसुफ उन पारगोळ पैदा आदुर, मतलब मनश्शे अदिक एप्रैम. ");
INSERT INTO hoy_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बिन्यामीन उन पारगोळ, बेला, बेकेर, अश्बेल, गेरा, नामान, एही, रोश, मूप्पीम, हूप्पीम, अदिक अर्द ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","राहेल इन पारगोळ जो याकूब से पैदा आदुर आंदुरोर ईंदुर अच पारगोळ ईरोर; आऊन ई सप्पा पारगोळ नातीगोळ चौदहा औलाद आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","बाक दान उन पार हूशीम ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्ताली इन पारगोळ, यहसेल, गूनी, येसेर, अदिक शिल्लेम ईरोर. ");
INSERT INTO hoy_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","बिल्हा दासी, यारी लाबान तान पोर राहेल इक कोट्टुन, आऊन पारगोळ, नातीगोळ ईंदुर अच हुळ; आऊन द्वारा याकूब उन वंश दा येळ औलाद पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याकूब उन निज वंश इन प्राणी जो मिस्त्र दा बंदुर, आंदुर आऊन सास्सागोळी बिटकु सप्पा छियासठ लॉकुर आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","अदिक यूसुफ उन पारगोळ, जो मिस्त्र दा आऊन से पैदा आदुर, आंदुर येढ्ढ प्राणी ईरोर; ई प्रकार याकूब उन घराना अन लॉकुर जो मिस्त्र दा बंदुर आंदुर सप्पा मुंदुर सत्तर आदुर. ");
INSERT INTO hoy_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","बाक आव यहूदा अक मुंद यूसुफ उन हाती कळुदुन कि आव आऊक गोशेन इक हाती तोरस्यान; अदिक आंदुर गोशेन द्याश बंदुर. ");
INSERT INTO hoy_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","आग यूसुफ तान रथ तेगुकु तान आप्प इस्त्राएल उन सांगुळ मुलाकात माळोर साटी गोशेन द्याश इक होदुन, अदिक आऊन से मुलाकात माळकु आऊन याद्दी अक चिपकुसोन, अदिक हापाळ समय ताका आऊन याद्दी इक चिपकुसकु वर्लतेला ईत्तुन. ");
INSERT INTO hoy_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","आग इस्त्राएल यूसुफ से अंदुन, “ना ईग सोतोगाईन भी रा खुश आईन, यतिकी नीनी जीत्ता नोळदीन अदिक नीन बाय नोळ कोंडीन.” ");
INSERT INTO hoy_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","आग यूसुफ तान वार्टुर से अदिक तान आप्प उन घराना सांगुळ अंदुन, “ना फिरौन उक होगकु ईद समाचार कोळाईन, ‘नान वार्टुर अदिक नान आप्प उन घराना अन सप्पा लॉकुर, जो कनान द्याश दा ईर तोगोर, आंदुर नान हाती होट्ट बंदार; ");
INSERT INTO hoy_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","अदिक आंदुर चरवाहा आर, यतिकी आंदुर जनावरगोळी पाल्सतार; इदुरसाटी आंदुर तान मर्र म्यांडा, गोसी वस्ता, अदिक जो येनारा आंदुर्द आद, सप्‍पा तंदार.’ ");
INSERT INTO hoy_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","याग फिरौन नीमी कारूकु केळ्यान, ‘नीम्द क्याल्सा धंदा येन आद?’ ");
INSERT INTO hoy_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","आग अनेतीर, ‘नीन दास लड़कपन टु हुडुकु ईंद ताका जनावरगोळी पाल्सतेला बंदेव, बल्‍की नाम हाळाबाट्टगोळ भी हिंगा माळतेला बंदार.’ ईदुर देल नीव गोशेन द्याश दा ईर सकीर; यतिकी सप्‍पा चरवाहागोळ से मिस्त्री लॉकुर सिट्ट माळतार.” ");
INSERT INTO hoy_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","आग यूसुफ फिरौन उन हाती होगकु ईद समाचार कोट्टुन, “नान आप्प अदिक नानोर वार्टुर, अदिक आंदुर जनावरगोळ अदिक जो येनारा आंदुर्द आद, सप्पा कनान द्याश टु होट्ट बंदाद; अदिक ईग रा आंदुर गोशेन द्याश दा आर.” ");
INSERT INTO hoy_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","बाक आव तान वार्टुर दा टु अईद मुंदुरी हुडुकु फिरौन उन मुंद नीदरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फिरौन आऊन वार्टुर से केळदुन, “नीम्द क्याल्सा धंदा येन आद?” आंदुर फिरौन से अंदुर, “नीन दास चरवाहा आर, अदिक नाम पुर्वज भी चरवाह ईरोर.” ");
INSERT INTO hoy_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","बाक आंदुर फिरौन से अंदुर, “नाव ई द्याश दा परदेशी घाई ईरली बंदेव; यतिकी कनान द्याश दा भारी अकाल इन कारण नीन दासगोळ मर्र म्यांडागोळ साटी चारा ईतीदील; इदुरसाटी तान दासगोळी गोशेन द्याश दा ईरोद आग्या कोळ.” ");
INSERT INTO hoy_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","आग फिरौन यूसुफ से अंदुन, “नीन आप्प अदिक नीन वार्टुर नान हाती होट्ट बंदार, ");
INSERT INTO hoy_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","अदिक मिस्त्र द्याश नीन मुंद बिदकु आद; ई द्याश इन जो सब से वळ्लीद भाग ईतीदाद, अदुर दा तान आप्प अदिक तान वार्टुरी बसुसकोम, मतलब आंदुर गोशेन द्याश दा अच ईरूल; अदिक अगर नी जान्सतीद्या, कि आंदुर दा टु मेहनती मंळसा आर रा आंदरी नान जनावरगोळ अधिकारी माळ कोम.” ");
INSERT INTO hoy_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","आग यूसुफ तान आप्प याकूब उक वतकु फिरौन उन हाती नीदरूसदुन; अदिक याकूब फिरौन उक आशीर्वाद कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","आग फिरौन याकूब उक केळदुन, “नी यास वर्ष ईनव आय?” ");
INSERT INTO hoy_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकूब फिरौन से अंदुन, “ना ऊंद सौ तीस वर्ष परदेशी आगकु तान जीवन बितुस कोंडीन; नान जीवन इन दिन थ्वाळासा अदिक दुख देल भी तुमकु ईरव, अदिक नान आप्प दादागोळ परदेशी आगकु यास दिन ताका जीत्ता ईत्तुर आस दिन इनव ना आगली का आईन.” ");
INSERT INTO hoy_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","अदिक याकूब फिरौन उक आशीर्वाद कोट्टुन अदिक आऊन हाती टु होटोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","आग यूसुफ तान आप्प अदिक वार्टुरी बसुस बुट्टुन, अदिक फिरौन उन आग्या अन अनुसार मिस्त्र द्याश इन वळ्लीद से वळ्लीद भाग दा, मतलब रामसेस हेसुर इन प्रदेश दा, जागा कोटकु आंदरी सौप्स कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","अदिक यूसुफ तान आप्प उन, अदिक तान वार्टुर्द, अदिक आप्प उन सप्पा घराना अन, ऊंद ऊंद इन बाल बच्चागोळ्द गिनती इन अनुसार, अनाज कोटकु आंदुर्द पालन पोषण माळली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","आ सप्‍पा द्याश दा तीनोर साटी येनु ईतीदील; यतिकी अकाल हापाळ भारी ईरोद, अदिक अकाल इन कारण मिस्त्र अदिक कनान द्याश त्रस्त आगेदव. ");
INSERT INTO hoy_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","अदिक यास पैस्या मिस्त्र अदिक कनान द्याश दा ईरोद, सप्पा अक यूसुफ आ अनाज इन बदला, जो आऊन निवासी कोम तोगोर, जमा माळकु फिरौन उन मान्ना दा पोहचुसदुर. ");
INSERT INTO hoy_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","याग मिस्त्र अदिक कनान द्याश इन पैस्या खतम आगेत, आग मिस्त्री लॉकुर यूसुफ उन हाती बंदकु अनली कुरतुर, “नामी भोजन वस्तु कोळ; येन नाव पैस्या अन ईला ईत्तुर देल नीन ईत्तुर मा सोतिदेव?” ");
INSERT INTO hoy_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","यूसुफ अंदुन, “अगर पैस्या हैलेच रा तान जनावरगोळ कोट्ट बुळी, अदिक ना अऊर बदला दा नीमी तिनली कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","आग आंदुर तान जनावरगोळी यूसुफ उन हाती तंदुर; अदिक यूसुफ आंदरी आंदुरव घ्वाळागोळ, मर्रगोळ, गोसीगोळ, अदिक गधागोळ बदला तीनली कोळली कुरतुन: आ वर्ष दा आव सप्पा जातीगोळ जनावरगोळ बदला भोजन कोटकु अऊर्द पालन पोषण माळतेला ईत्तुन. ");
INSERT INTO hoy_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","अद वर्ष रा हिंगा होटोत; आग मुंदळोद वर्ष दा आंदुर आऊन हाती बंदकु अंदुर, “नाव तान प्रभु से ईद मात होचकु ईटतीदिल कि नाम्द पैस्या खतम आगेग्याद, अदिक नामव सप्पा प्रकार इन जनावरगोळ नाम प्रभु नव आगेग्याव; इदुरसाटी ईग नाव नाम प्रभु उन मुंद नाम्द शरीर अदिक जागा अक बिटकु अदिक येनु ईतीदील. ");
INSERT INTO hoy_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","नीन नोळतेला अच नाव सही दा सोतोदेव, लेकीन अगर नी नामी भोजन वस्तु कोळत्या रा नाव फिरौन उक तान जमीन कोट्टेव अदिक आऊन दास आगेदेव, नामी बींजा कोळी यवरी नाव बोऊस सक्केव. आग नाव लॉकुर जीत्ता ईत्तेव अदिक सायतीदिल अदिक जमीन नाम लॉकुर साटी मात्त अनाज उगुसीत.” ");
INSERT INTO hoy_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","आग यूसुफ मिस्त्र अन सप्पा जमीन इक फिरौन उन साटी कोंड कोंडुन; यतिकी आ भयंकर अकाल इन बिद्दुर देल मिस्त्रीगोळी तान तान केई मारोद बीत्त, ई प्रकार सप्पा जमीन फिरौन उन आगेत; ");
INSERT INTO hoy_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","अदिक ऊंद छोर टु हुडुकु दुसरा छोर ताका सप्पा मिस्त्र द्याश दा जो प्रजा ईर तोगोद, अदरी आव नगरगोळ दा तनकु बसुस कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","लेकीन याजकगोळ्द जमीन आव कोंडीदिल यतिकी याजकगोळ साटी फिरौन उन दी टु नित्य भोजन इन बंदोबस्त ईरोद, अदिक नित्य जो भोजन फिरौन आंदरी कोळ तोगोन अदरी आंदुर तीन तोगोर, ई कारण आंदरी तान जमीन मारोद बिदीदील. ");
INSERT INTO hoy_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","आग यूसुफ प्रजा अन लॉकुर से अंदुन, “केळी, ना ईंद इन दिशी नीमी अदिक जमीन इक भी फिरौन उन साटी कोंड कोंडीन; नोळी नीम साटी ईल बींजा आद, ईदरी जमीन दा बोऊसी. ");
INSERT INTO hoy_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","अदिक जो येनारा उपज आदीत अदुर्द पाचवा अंश फिरौन उक कोळेतीर, बाकी नाक अंश नीमव ईत्तव कि नीव अदरी तान केई दा बोऊसी, अदिक तान तान बाल बच्चा अदिक तान मान्या नोर अन्य लॉकुर सांगुळ तीनुल.” ");
INSERT INTO hoy_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","आंदुर अंदुर, “नी नामी ऊळ्स बुट्या; नाम प्रभु उन अनुग्रह अन नजर नाम मा बन्सकु ईरूल, अदिक नाव फिरौन उन दास आगकु ईत्तेव.” ");
INSERT INTO hoy_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ई प्रकार यूसुफ मिस्त्र अन जमीन इन बारा दा हिंग नियम ठहरूसदुन, जो ईंद ताका नळेत्याद कि अईवा अंश फिरौन उक सीकुल; केवल याजकगोळ्द जमीन फिरौन उन आगीदील. ");
INSERT INTO hoy_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इस्त्राएली मिस्त्र अन गोशेन द्याश दा ईरली कुरतुर; अदिक अल ईद जमीन आंदुर वश दा ईरोद; अदिक आंदुर फुलुसदुर अदिक हापाळ वाळुसदुर. ");
INSERT INTO hoy_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","मिस्त्र द्याश दा याकूब सत्रह वर्ष जीत्ता ईत्तुन: ई प्रकार याकूब उन उमर ऊंद सौ सैंतालीस वर्ष इन आत. ");
INSERT INTO hoy_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","याग इस्त्राएल उन सायोद दिन हाती होट्ट बत्त, आग आव तान पार यूसुफ उक कारसुसकु अंदुन, “अगर नीन अनुग्रह नान मा ईतीदाद, रा तान कय नान जांघ मा ईटकु कसम तीन कि नी नान सांगुळ कृपा अदिक सच्चाई इन ईद क्याल्सा माळ्या कि नानी मिस्त्र दा मुण्‍ण कोळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","याग ना तान आप्प दादागोळ सांगुळ सोतोगाईन, आग नी नानी मिस्त्र टु नेगुकु आंदुर्दा कब्रस्तान दा ईट्या, आग यूसुफ अंदुन, “ना नीन वचन इन अनुसार माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","बाक आव अंदुन, “नान से कसम तीन.” अत: आव आऊन से कसम तीनदुन. आग इस्त्राएल व्हर्स इन ताल्ला अन दी ताल्ला बांग्सकु प्रार्थना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ई मातगोळ बाद्दा यावारा यूसुफ से अंदुन, “केळ, नीन आप्प बिमार आन.” आग आव मनश्शे अदिक एप्रैम हेसुर नोर तान येढ्ढु चिकोरी सांगुळ हुडुकु आऊन हाती होदुन. ");
INSERT INTO hoy_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","यावारा याकूब उक हेळ बुट्टुन, “नीन पार यूसुफ नीन हाती बरेत्यान,” आग इस्त्राएल तान तान इक संभाळसकु व्हर्स मा कुरतोदुन. ");
INSERT INTO hoy_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","अदिक याकूब यूसुफ से अंदुन, “सर्व सर्वशक्तिमान परमेश्वर कनान द्याश इन लूज नगर इन हाती नानी दर्शन कोटकु आशीष कोट्टुन, ");
INSERT INTO hoy_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","अदिक अंदुन, ‘केळ, ना नीनी फलवन्त माळकु वाळुसाईन, अदिक नीनी राज्य राज्य अन मंडली इन मूल मंळसा माळाईन, यदुर देल कि अद सदा ताका आंदुर्द तान खुद इन जमीन आगकु ईरूल.’ ");
INSERT INTO hoy_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","अदिक ईग नीन येढ्ढु पारगोळ, जो मिस्त्र दा नान बरोर से पयले पैदा आग्यार, आंदुर नानोर अच ठहरूस्यार; मतलब या रीति देल रूबेन अदिक शिमोन नानोर आर, अदा रीती देल एप्रैम अदिक मनश्शे भी नानोर ठहरूस्यार. ");
INSERT INTO hoy_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","अदिक आंदुर बाद्दा नीनोर जो सन्तान पैदा आदार, आंदुर नीनोर रा ठहरूस्यार; लेकीन बटवारा अन समय आंदुर तान वार्टुर अच वंश दा आळकु आदार. ");
INSERT INTO hoy_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","याग ना पद्दान टु बर तोगीन, आग एप्राता पोहचुसोर थ्वाळासा पयले राहेल कनान द्याश दा, हादी मा, नान मुंद सोतोदुर; अदिक ना आकी अल्या, मतलब एप्राता जो बैतलहम भी कहलुसतद, अदा हादी मा मुण्ण कोट्टीन.” ");
INSERT INTO hoy_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","आग इस्त्राएल यूसुफ उन पारगोळी नोळदुन, आव केळदुन, “ई पारगोळ यार उर?” ");
INSERT INTO hoy_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","यूसुफ तान आप्प से अंदुन, “ईंदुर नानोर पारगोळ उर. ईंदुर आ पारगोळ उर यारी परमेश्वर नानी कोटान.” इस्त्राएल अंदुन, “तान पारगोळी नान हाती तर. ना आंदरी आशीर्वाद कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्त्राएल बाट्ट ईरोन अदिक आऊन कण्णगोळ वळ्लेव ईला ईरव, इदुरसाटी यूसुफ तान पारगोळी तान आप्प उन हाती वोतुन, याकूब पारगोळी चुम्सदुन अदिक याद्दी चीपकुसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","आग इस्त्राएल यूसुफ से अंदुन, “ना यागलु ईला सोचीदिन कि ना नीम्द बाय बाक यागलु नोळाईन, लेकीन नोळी, परमेश्वर नीनी अदिक नीन पारगोळी भी नानी तोर्सदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","आग यूसुफ पारगोळी याकूब उन क्वारा दा टु हुळदुन अदिक आंदुर आऊन आप्प उन मुंद प्रणाम माळोर साटी बांगदुर. ");
INSERT INTO hoy_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","यूसुफ एप्रैम उक तान उजवा दी माळदुन अदिक मनश्शे अक तान डाक्या दी, ई प्रकार एप्रैम इस्त्राएल उन उजवा दी ईरोन अदिक मनश्शे याकूब उन डाक्या दी ईरोन. ");
INSERT INTO hoy_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","लेकीन इस्त्राएल तान कय इन दिशा बदलुसकु तान उजवा कय श्याण पार एप्रैम उन ताल्ला मा ईटदुन अदिक आग डाक्या कय इक याकूब उन धोड्डेव पार मनश्शे अन ताल्ला मा ईटदुन, यतिकी मनश्शे अन जनम पयले आगीत. ");
INSERT INTO hoy_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","अदिक याकूब यूसुफ उक आशीर्वाद कोट्टुन अदिक अंदुन, “नान पुर्वज अब्राहम अदिक इसहाक नाम परमेश्वर उन उपासना माळदुन अदिक आवा परमेश्वर नान जीवन इक संभाळसावाळा बन्सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","अदिक आवा दूत नानी सप्पा कष्टगोळ देल उळ्सदुन, अदिक नान प्रार्थना आद कि ई पारगोळी आव आशीर्वाद कोळुल, ईग ई पारगोळी नान हेसुर सिक्‍कीत, आंदरी नाम पुर्वज अब्राहम अदिक इसहाक उन हेसुर सिक्‍कीत, ना प्रार्थना माळतीन कि आंदुर ई धरती मा धोड्डेव परिवार अदिक राष्ट्र आदार.” ");
INSERT INTO hoy_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","यूसुफ नोळदुन कि आऊन आप्प एप्रैम उन ताल्ला मा उजवा कय ईट्यान, आव यूसुफ उन खुश माळ सकीदील, यूसुफ तान आप्प उन कय हुळदुन, आव आऊन कय एप्रैम उन ताल्ला मा टु सरकुसकु मनश्शे अन ताल्ला मा ईटोद चाहासोन. ");
INSERT INTO hoy_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","अदिक यूसुफ तान आप्प से अंदुन, “हे आप्पा, हिंग ईला; यतिकी धोळ पार ईवा हुन; तान उजवा कय ईऊन ताल्ला मा ईट्ट.” ");
INSERT INTO hoy_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","लेकीन आऊन आप्प अंदुन, “पारा, ना जान्सतीन, मनश्शे अन जनम पयले आग्याद अदिक आव महान आदान, आव हापाळ सा लॉकुरव आप्प भी आदान, लेकीन श्याण्णेव वार्ट धोड्डेव वार्ट उन से धोड्डेव आदान अदिक श्याण्णेव वार्ट उन परिवार हापाळ धोळ्द आदीत.” ");
INSERT INTO hoy_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ई प्रकार इस्त्राएल आ दिशी आंदरी आशीर्वाद कोट्टुन, आव अंदुन, “इस्राएल इन लॉकुर नीन हेसुर आशीर्वाद कोळोर साटी प्रयोग माळ्यार, नीम कारण कृपा हासील माळ्यार, लॉकुर प्रार्थना माळ्यार, परमेश्वर नीमी एप्रैम अदिक मनश्शे घाई माळुल.” ई प्रकार याकूब एप्रैम उक मनश्शे से धोड्डेव माळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","आग इस्त्राएल यूसुफ से अंदुन, “नोळी नान सायोद समय हाती होट्ट बंदाद. लेकीन परमेश्वर नीम सांगुळ ईग भी ईत्तान, आव नीमी नीम पुर्वजगोळ द्याश ताका वापस वोतान. ");
INSERT INTO hoy_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ना नीमी हिंग येनारा कोटीन जो नीम वार्टुरी कोटीदील. ना नीमी अद पहाळी कोळतीन यदरी ना एमोरी लॉकुर से जीकसीदिन, आ पहाळी साटी ना तान तलवार अदिक तान बाण देल युध्द माळीदिन अदिक नान जीत आगीत.” ");
INSERT INTO hoy_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","बाक याकूब तान पारगोळ इक ईद अनकु कारदुन, “जमा आगेगी, ना नीम इक हेळाईन कि आखरी दिनगोळ दा नीम मा येन येन बितुसीत.” ");
INSERT INTO hoy_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","याकूब उन पारगोळा, ऊंद सांगुळ बरी अदिक केळी, तान आप्प इस्त्राएल उन केळी. ");
INSERT INTO hoy_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“हे रूबेन, नी नान धोड्डेव पार हुय, नी नान पयला पार अदिक नान ताकत इन पयला सबुत हुय, नानी नान सप्पा पारगोळ से येक्‍कुल गर्व नीन मा आद अदिक नी सबसे यक्कुल ताकतवर आय. ");
INSERT INTO hoy_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","नी जो नीर इन घाई उबलुसावाळा आय, नी नान सप्‍पा पारगोळ से येक्‍कुल महत्व अन आग सकतीदील, नी आ आर्त इन सांगुळ मींग्या अदिक आकी अपवित्र माळ्या जो नीन आप्प उन दासी ईरोर, नी तान आप्प उन व्हर्स मा काल ईट्या.” ");
INSERT INTO hoy_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“शिमोन अदिक लेवी वार्टुर उर, आंदरी तान तलवारगोळ से आळोद प्रिय आद. ");
INSERT INTO hoy_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","हे नान जीव, आंदुर मर्म दा बीळ बाळ, हे नान महिमा, आंदुर्द सभा दा मीसळुसबाळ; यतिकी आंदुर कोप देल मंळसागोळी कोंदार, अदिक तान अच इच्छा मा नळुकु वस्तागोळी अपंग माळ्यार. ");
INSERT INTO hoy_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","आंदुर्द सिट्ट ऊंद अभिश्राप आद, ईंदुर हापाळ कठोर अदिक तान पागलपन दा सिट्ट दा आर, याकूब उन द्याश दा ईंदुर्द परिवारगोळ दा तान जमीन ईरतीदील, आंदुर पुरा इस्त्राएल द्याश दा फैलुस्यार.” ");
INSERT INTO hoy_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“यहूदा, नीन वार्टुर नीन प्रशंसा माळ्यार, नी तान दुश्मनगोळी हारूस्या, नीन वार्टुर नीन मुंद झुकस्यार. ");
INSERT INTO hoy_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा आ हुल्ल इन घाई आन याव यातोदारा जनावर इक कोंदान, हे नान पारा, नी तान शिकार मा नीदुरकु हुल्ल इन घाई आय जो आराम माळोर साटी मींगतद. अदिक याऊ ईट हिम्मतवाळा हैलेच कि अदरी छेळस्यान. ");
INSERT INTO hoy_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यागासताका शीलो बराल्द आगासताका ना रा यहूदा से राजदण्ड बिट्टीत, ना आऊन वंश से व्यवस्था कोळावाळा अलग आदान; अदिक राज्य राज्य अन लॉकुर आऊंद अधीन आगेदार. ");
INSERT INTO hoy_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","आव तान गधा अक अंगुर इन बेली इक कटतान, आव तान गधा अन पाड्डा अक सबसे वळ्लीद अंगुर इन बेली इक कटतान, आव तान कपळागोळी ओगोर साटी सबसे वळ्लीद अंगुर इन रास्सा अन उपयोग माळतान. ");
INSERT INTO hoy_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","आऊन कण्ण अंगुर इन रास्सा अन्द घाई क्याच्यान ईरताव. आऊन हल्ल हाल इन घाई बिळेव आव.” ");
INSERT INTO hoy_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“जबूलून समुद्र अन हाती ईत्तान, ईऊंद समुद्री तट ड्वांगागोळ साटी सुरक्षित ईत्तीत, ईऊंद प्रदेश सीदोन ताका फैलुसकु ईत्तीत.” ");
INSERT INTO hoy_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साकार आ गधा अन घाई आन याव हापाळ कठोर क्याल्सा माळ्यान, आव भारी बोझ आळका कारण पस्त बिदान. ");
INSERT INTO hoy_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","आव नोळ्यान कि आऊन आराम इन जागा वळ्लीद आद, तथा ईद कि आऊन जमीन सुहाबनी आद. आग आव भारी बोझ नेगुली तैयार ईत्तान. आव दास इन रूप दा क्याल्सा माळोद स्वीकार माळ्यान.” ");
INSERT INTO hoy_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“दान तान लॉकुर्द न्याय हांगा माळ्यान ह्यांग इस्त्राएल उन अन्य परिवार माळतार. ");
INSERT INTO hoy_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान हादी माकळोद ऊंद हाव, अदिक हादी माकळोद ऊंद नाग ईत्तीत, जो घ्वाळा अन्द नली इक डंसुसताद, अदुर देल अदुर सवार पछाळ तिनकु हिंद बिदोगतान.” ");
INSERT INTO hoy_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“हे यहोवा, ना उद्धार इन हादी कायेतीन.” ");
INSERT INTO hoy_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“डाकुगोळ्द ऊंद गिरोह गाद मा आक्रमण माळीत, लेकीन गाद आंदरी बडुकु तुकाळसीत.” ");
INSERT INTO hoy_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“आशेर द्याश इन जमीन हापाळ वळ्लीद उपज कोट्टीत. आऊक अल्या भोजन सिक्‍कीत जो राजागोळ साटी उपयुक्त आदीत.” ");
INSERT INTO hoy_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“नप्ताली स्वतन्त्र वळावाळा हिरण इन घाई आद अदिक आऊन बोली अऊर्द सुन्दर चिकोर घाई आद.” ");
INSERT INTO hoy_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“यूसुफ हापाळ सफल आन, यूसुफ कयगोळ देल हतकु अंगुर इन बेली इन घाई आन, आव सोता अन हाती हतदव अंगुर इन बेली इन घाई आन, बाडा अन सहारा उग्सद अंगुर इन बेली इन घाई आन. ");
INSERT INTO hoy_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","हापाळ सा लॉकुर आऊन विरूद्‍ध आदुर अदिक आऊन से लळुसदुर, धर्नुधारी लॉकुर आऊक पंसद माळालुर. ");
INSERT INTO hoy_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","लेकीन आव तान ताकतवर बाण अदिक कुशल भुजागोळ देल युध्द जिक्सदुन, आव याकूब उन ताकतवर परमेश्वर चरवाह, इस्त्राएल इन चट्टान देल शक्ति सिकतद. ");
INSERT INTO hoy_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ईद नान आप्प आ ईश्वर उन क्याल्सा हुन, जो नीन सहायता माळ्यान, आ सर्वशक्तिमान उन जो नीनी म्याकुच टु आशीर्वादगोळी, अदिक ल्यालमा टु गयरा नीर दा टु आशीर्वाद, अदिक माल्लागोळ्द अदिक गर्भगोळ्द आशीर्वाद कोट्टान.” ");
INSERT INTO hoy_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","नान मोय आप्प उन हापाळ सा वळ्लेव चीजगोळ आगतेला ईत्तव अदिक नीम आप्प से नानी अदिक येक्‍कुल आशीर्वाद सिक्त, नीम वार्टुर नानी मारोद चाहासदुर, लेकीन ईग नीमी ऊंद धोळ्द पर्वत इन घाई, नान सप्पा आशीर्वाद इन ढग सिक्‍कीत. ");
INSERT INTO hoy_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“बिन्यामीन ऊंद हिंग हस्तकु भेड़ीया अन घाई आन जो व्हातर्या कोनतद अदिक अदरी तीनतद, द्यावगा ईद मिग्द माग्द देल क्याल्सा नळ्सतद.” ");
INSERT INTO hoy_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","इस्त्राएल उन हन्नेळ परिवार ईवा हु अदिक आंदुर आप्प याता याता वचन देल आंदरी आशीर्वाद कोट्टुन, आंदुर ईंदुर उर; ऊंद ऊंद इक आशीर्वाद इन अनुसार आव आशीर्वाद कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","आग आव आंदरी ईद अनकु आग्या कोट्टुन, “याग ना सायाईन रा ना तान लॉकुर बीच दा ईरोद चाहसतीन, ना तान पुर्वजगोळ सांगुळ हित्ती एप्रोन इन केईगोळ गुफा दा नळ्सकु आगोद चाहसतीन. ");
INSERT INTO hoy_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","मतलब अदा गुफा दा जो कनान द्याश दा मम्रे अन मुंदळोद मकपेला अन जमीन दा आद; आ जमीन इक अब्राहम हित्ती एप्रोन उन कय देल इदुरसाटी कोडींदुन, कि अद कब्रस्तान साटी आऊन खुद इन जमीन आगुल. ");
INSERT INTO hoy_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","अल अब्राहम अदिक आऊन हिंग्स सारा अक मुण्ण कोटकु आगीत, अदिक अल्या इसहाक अदिक आऊन हिंग्स रिबका अक भी मुण्ण कोटकु आत; अदिक अल्या ना लियाह अक भी मुण्ण कोट्टीन.” ");
INSERT INTO hoy_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","अद जमीन अदिक अदुर दाकळोद गुफा हित्‍तीगोळ हात्ती टु कोडंकु आगीत. ");
INSERT INTO hoy_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","याकूब याग तान पारगोळी ईद आग्या कोट्टुन, आग तान काल व्हर्स मा नेगुकु जीव बिट्टुन, अदिक तान लॉकुर दा होगकु मीलुसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","आग यूसुफ तान आप्प उन बाय मा बिदकु वर्लदुन अदिक आऊक चुम्सदुन. ");
INSERT INTO hoy_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","अदिक यूसुफ आ वैध्यगोळी, जो आऊन सेवक ईरोर, आग्या कोट्टुन कि आऊन आप्प उन लाश मा सुगन्ध द्रव्य तुमुल; आग वैध्यगोळ इस्त्राएल उन लाश दा सुगन्ध द्रव्य तुमदुर. ");
INSERT INTO hoy_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","अदिक आऊनव चालीस दिन पुरा आदव, यतिकी यार लाश दा सुगन्ध द्रव्य तुमकु आगतद, आंदरी ईसा दिन पुरा हत्ताव; अदिक मिस्त्री लॉकुर अदुर साटी सत्तर दिन ताला विलाप माळतेला ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","याग आऊनव विलाप उन दिनगोळ बितसेदव, आग यूसुफ फिरौन उन घराना अन लॉकुर से अनली कुरतुन, “अगर नीम अनुग्रह अन नजर नान मा ईतीदाद रा नान ईद बातणी फिरौन उक केळसी, ");
INSERT INTO hoy_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","नान आप्प ईद अनकु, ‘नोळ ना सोत्तुर मा आईन,’ नानी ईद कसम तीन्सदुन, ‘जो कब्र ना कनान द्याश दा अगळुसीन अल्या नी नानी मुण्‍ण कोळेत.’ इदुरसाटी ईग नानी अल होगकु तान आप्प उक मुण्ण कोळोद आग्या कोळुल, अदुर बाद्दा ना वापस होट बराईन.” ");
INSERT INTO hoy_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","आग फिरौन अंदुन, “होगकु तान आप्प उन तिन्सद कसम अन अनुसार आऊक मुण्‍ण कोळ.” ");
INSERT INTO hoy_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","इदुरसाटी यूसुफ तान आप्प उक मुण्ण कोळोर साटी होदुन, अदिक फिरौन इन सप्पा कर्मचारी, मतलब आऊन भवन इन स्याणा मंळसागोळ अदिक मिस्त्र द्याश इन स्याणागोळ आऊन सांगुळ होदुर. ");
INSERT INTO hoy_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","अदिक यूसुफ उन मान्या गोळोर सप्पा लॉकुर, अदिक आऊन वार्टुर, अदिक आऊन आप्प उन मान्या गोळोर सप्पा लॉकुर भी सांगुळ होदुर; लेकीन आंदुर तान चिकोरी, अदिक मर्र म्यांडा, अदिक गोसीगोळी गोशेन प्रदेश दा बिटकु बंदुर. ");
INSERT INTO hoy_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","अदिक आऊन सांगुळ रथ अदिक सवार होदुर, ई प्रकार भीळ हापाळ आगेत. ");
INSERT INTO hoy_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","याग आंदुर आताद उन खलयान ताका, जो यरदन गांगा अन आप्पाटी आद, पोहचुसदुर, आग अल हापाळ भारी विलाप माळदुर, अदिक यूसुफ तान आप्प उन साटी येळ दिन इन विलाप माळसुसदुन. ");
INSERT INTO hoy_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","आताद इन खलिहान दाकळोद विलाप इक नोळकु आ द्याश इन ईरावाळेर कनानीगोळ अंदुर, “ईद रा मिस्त्री लॉकुर्द भारी विलाप आगीदाद.” ईदा कारण आ जागा अन हेसुर आबेल मिस्रेम बित्त, अदिक अद यरदन इन आप्पाटी आद. ");
INSERT INTO hoy_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","इस्त्राएल उन पारगोळ ठीक अदा क्याल्सा माळदुर यदुर आव आंदरी आग्या कोटीदुन: ");
INSERT INTO hoy_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","मतलब आंदुर आऊक कनान द्याश दा वोतकु मकपेला अन आ जमीन इन गुफा दा, जो मम्रे अन मुंद आद, मुण्ण कोट्टुर; यदरी अब्राहम हित्ती एप्रोन उन कय देल इदुरसाटी कोंडीदुन, कि अद कब्रस्तान इन साटी आंदुर्द खुद इन जागा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","तान आप्प उक मुण्‍ण कोटकु यूसुफ तान वार्टुर अदिक आ सप्पा सांगुळ, जो आऊन आप्प उक मुण्ण कोळोर साटी सांगुळ बंदीदुर, मिस्त्र वापस बंदुन. ");
INSERT INTO hoy_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","याग यूसुफ उन वार्टर नोळदुन कि नाम आप्प सोतोग्यान, रा अनली कुरतुर, “कदाचित यूसुफ ईग नाम हिंद बिद्दान, अदिक याट बुरा नाव आऊन सांगुळ माळीदेव सप्पा अन पुरा बदला नाम सांगळ ताकोंडान रा.” ");
INSERT INTO hoy_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","इदुरसाटी आंदुर यूसुफ उन हाती ईद अनकु कळुदुर, “नीन आप्प सायोर से पयले नामी ईद आग्या कोटीदुन, ");
INSERT INTO hoy_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘नीव लॉकुर यूसुफ से ई प्रकार अनेतीर, कि नाव विनती माळतेव, कि नाव विनती माळतेव नी तान वार्टुर्द अपराध अदिक पाप इक क्षमा माळ; नाव नीन से बुरा माळीदेव, लेकीन ईग तान आप्प उन परमेश्वर उन दासगोळ्द अपराध क्षमा माळ.’” आंदुर्द ईद मात केळकु यूसुफ वर्लली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","अदिक आऊन वार्टुर भी आऊन मुंद होगकु वर्लली कुरतुर, अदिक अंदुर, “नोळ, नाव नीनोर दास हुयेव.” ");
INSERT INTO hoy_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","यूसुफ आंदुर से अंदुन, “अंज बाळी, येन ना परमेश्वर उन जागा मा आईन? ");
INSERT INTO hoy_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","अगर नीव नान साटी बुरा विचार माळीदीर, लेकीन परमेश्वर अदा मात दा भलाई इन विचार माळदुन, यदुर देल आव हिंग माळुल, ह्यांग ईंद इन दिन प्रगट आद, कि हापाळ सा लॉकुरव जीव ऊळ्दकु आव. ");
INSERT INTO hoy_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","इदुरसाटी ईग अंज बाळी: ना नीम्द अदिक नीमोर चिकोर्द पालन-पोषण माळतेला ईराइन.” ई प्रकार आव आंदरी समझुसकु शांती कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","यूसुफ तान आप्प उन घराना अन सांगुळ मिस्त्र दा ईत्तुन, अदिक यूसुफ ऊंद सौ हत्त वर्ष जीत्ता ईत्तुन. ");
INSERT INTO hoy_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","अदिक यूसुफ एप्रैम उन नातीगोळी नोळदुन अदिक मनश्शे अन नातीगोळ, जो माकीर उन पारगोळ ईरोर, आंदुर पैदा आदुर अदिक यूसुफ आंदरी तान क्वारा दा हुळदुन. ");
INSERT INTO hoy_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","यूसुफ तान वार्टुर से अंदुन, “ना रा सायोर मा आईन; लेकीन परमेश्वर सही दा नीम्द सुधी ताकोंडान, अदिक नीमी ई द्याश टु तेगुकु आ द्याश दा पोहचुस्यान, यदरी कोळोद आव अब्राहम, इसहाक, अदिक याकूब से कसम तिंदीदुन.” ");
INSERT INTO hoy_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","बाक यूसुफ इस्त्राएलीगोळ से ईद अनकु कि परमेश्वर सही दा नीम्द सुधी ताकोंडान, आंदरी ई बारा अन कसम तीन्सदुन, “नाव नीन येलुगोळी ईल टु आ द्याश दा वोतेव.” ");
INSERT INTO hoy_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ई प्रकार यूसुफ ऊंद सौ हत्त वर्ष इनव आगकु सोतोदुन: अदिक आऊन लाश दा सुगन्ध द्रव्य तुमकु आत, अदिक अद लाश मिस्त्र दा ऊंद लाश पेटी दा ईटकु आत.");
INSERT INTO hoy_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","इस्त्राएल मतलब याकूब उन पारगोळ हेसुर, जो तान तान घराना अक हुडुकु याकूब उन सांगुळ मिस्त्र द्‍याश दा बंदुर, ईंदुर उर: ");
INSERT INTO hoy_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, शिमोन, लेवी, यहूदा, ");
INSERT INTO hoy_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साकार, जबूलून, बिन्यामीन, ");
INSERT INTO hoy_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नप्ताली, गाद अदिक आशेर. ");
INSERT INTO hoy_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","अदिक यूसुफ रा मिस्त्र दा पयला अच होट बंदीदुन. याकूब उन निज वंश दा जो पैदा आदुर आंदुर सप्‍पा सत्‍तर लॉकुर ईरोर. ");
INSERT INTO hoy_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","यूसुफ अदिक आऊन सप्‍पा वार्टुर अदिक आऊन पीढ़ी इन सप्‍पा लॉकुर सोतोदुर. ");
INSERT INTO hoy_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","लेकीन इस्त्राएल इन सन्‍तान वाळुसली हतदुर; अदिक आ लॉकुर हापाळ सामर्थी माळतेला होदुर, अदिक ईट वाळुसेदुर कि पुरा द्‍याश आंदुर से तुम्‍मेत. ");
INSERT INTO hoy_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","मिस्त्र दा ऊंद व्हाशोव राजा गद्‍दी मा कुरतुन जो यूसुफ इक ईला जानसोन. ");
INSERT INTO hoy_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","आव तान प्रजा से अंदुन, “नोळी, इस्त्राएलीगोळ नाम से गिनती दा अदिक सामर्थ्य दा यक्‍कुल वाळुसेग्‍यार. ");
INSERT INTO hoy_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","इदुरसाटी बरी, नाव आंदुर सांगुळ चतुराई देल बर्ताव माळाता, ईलारा हींग आगबाळुल कि याग आंदुर हापाळ वाळुसेदार अदिक अगर संग्राम इन समय होट बंदीत, रा नाम दुश्‍मनगोळ से मिलुसकु नाम से लळाई माळुल अदिक ई द्‍याश टु होटबुळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","इदुरसाटी आंदुर आंदुर मा बेगारी माळसुसावाळेरी नियुक्‍त माळदुर कि आंदुर आंदुर मा भार हाक्‍क-हाक्‍कु आंदरी दुख कोळुल; अदिक आंदुर फिरौन उन साटी पितोम अदिक रामसेस हेसुर इन नगरगोळ दा भंडार माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","लेकीन ह्‍यांग ह्‍यांग आंदुर आंदरी दुख कोळ्‍त ईत्‍तुर, हांग हांग आंदुर वाळुस्‍त अदिक फैलुसतेला होदुर; इदुरसाटी मिस्त्री लॉकुर इस्त्राएलीगोळ से हापाळ अंजेदुर. ");
INSERT INTO hoy_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","तरी भी मिस्त्रीगोळ इस्त्राएलीगोळ से कठोरता अन सांगुळ स्यावा माळसुसदुर, ");
INSERT INTO hoy_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","अदिक आंदुर जीवन इक गारा, ईटा अदिक केई इन ब्‍यार्र-ब्‍यार्र क्‍याल्‍सा अन कठिन स्यावा देल जीना मुश्किल माळ बुट्‍टुर; जो याता क्‍याल्‍सा दा आंदुर आंदुर से स्‍यावा माळसुसतोगोर अदुर दा आंदुर कठोरता देल व्‍यवहार माळतोगोर. ");
INSERT INTO hoy_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","शिप्रा अदिक पूआ हेसुर इनोर येढ्‍ढ इब्री सुईनगितेर इक मिस्त्र अन राजा आग्‍या कोट्‍टुन, ");
INSERT INTO hoy_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“याग नीव इब्री आर्तेर्द बारतपन माळा समय नीम इक पता नळुल कि आग अगर पार आगुल रा आऊक कोंद बुळेतीर, अदिक पोर आगुल रा जीत्‍ता ईर गोळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","लेकीन आ सुईनगितेर परमेश्वर उन अंज्‍क मान्‍सतोगोर, इदुरसाटी मिस्त्र अन राजा अन आग्‍या ईला मान्‍सकु पारगोळी भी जीत्‍ता बिटबुळ तोगोर. ");
INSERT INTO hoy_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","आग मिस्त्र अन राजा आंदरी कारसुसकु केळदुन, “नीव जो पारगोळी जीत्‍ता बिट बुळतीर, रा हींग येती माळतीर?” ");
INSERT INTO hoy_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","सुईनगितेर फिरौन उक उत्‍तर कोट्‍टुर, “इब्री आर्तेर मिस्त्री आर्तेर घाई हैलेच; आंदुर हींग फुर्तीला आर कि सुईनगितेर्द बरा से पयला अच आंदरी चिग्‍द पैदा आगेगतद.” ");
INSERT INTO hoy_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","इदुरसाटी परमेश्वर सुईनगितेर सांगुळ भलाई माळदुन; अदिक आ लॉकुर वाळुसकु हापाळ सामर्थी आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","परमेश्वर आंदुर मान्‍ना बसुसदुन, यतिकी सुईनगितेर परमेश्वर उन अंज्‍क मान्‍सतोगोर. ");
INSERT INTO hoy_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","आग फिरौन राजा तान सप्‍पा प्रजा अक आग्‍या कोट्‍टुन, “इब्रीगोळोर यासारा भी पारगोळ पैदा आदार आ सप्‍पा मुंदुरी नीव नील गांगा दा हाक्‍क बुळेतीर, अदिक सप्‍पा पोरगोळी जीत्‍ता ईरगोळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी इन घराना अन ऊंद मंळसा ऊंद लेवी वंश इन आर्त इन से मदा माळ कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","आक आर्त व्‍हाट्‍टा दी ईत्‍तुर अदिक आक इक ऊंद पार पैदा आदुन; अदिक ईद नोळकु कि ई चिग्‍द सुंदर आन, आऊक आव मुर तिंगुळ ताका होचकोमकु ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","याग आक आऊक मात्‍त होचकोमकु ईट सकीदील आग आऊन साटी सरकंडागोळ्‍द ऊंद फुट्टी तनकु, अदुर मा चिक्‍कन मुण्‍ण अदिक डांबर हचदुर, अदिक अदुर दा पार उक ईटकु नील गांगा अन किनारा मा काड्डागोळ्‍द न्‍याड्या बिटकु बंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","आ पार उन आकतींग दुर निदुरकु ईत्‍तुर अदिक नोळोर कि आऊन सांगुळ येन आगतद. ");
INSERT INTO hoy_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","आग फिरौन उन पोर मय तोळोर साटी नील हेसुर इन गांगा अन किनारा मा बंदुर. आकिन दासीगितेर गांगा अन किनारा-किनारा टेटाळली हतदुर. आग आक काड्डागोळ बीच दा फुट्टी इक नोळकु तान दासगीत इक अदरी तरोर साटी कळुदुर. ");
INSERT INTO hoy_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","याग आक अदरी तेरूकु नोळदुर कि ऊंद वर्लतेला चिग्‍द आद, आग आक इक दया बत्‍त अदिक आक अंदुर, “ईव रा यातारा इब्री आर्त इन चिग्‍द आगीदान.” ");
INSERT INTO hoy_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","आग चिग्‍द उन आकतींग फिरौन उन पोर इन से अंदुर, “येन ना होगकु इब्री आर्तेर दा टु यातारा आर्त इक नीन हात्‍ती कारूकु तराईन, जो नीन साटी चिग्‍द उक हाल कुळ्‍सतोगुल?” ");
INSERT INTO hoy_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फिरौन उन पोर अंदुर, “होग.” आग पोर होगकु चिग्‍द उन मोय इक कारूकु तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फिरौन उन पोर आकिन से अंदुर, “नी ई चिग्‍द उक ओतकु नान साटी हाल कुळ्‍सतोग, अदिक ना नीनी मजदूरी कोळाईन.” आग आ आर्त चिग्‍द उक ओतकु हाल कुळ्‍सली हतदुर. ");
INSERT INTO hoy_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","याग चिग्‍द थ्‍वाळासा धोड्‍डेव आदुन आग आक आऊक फिरौन उन पोर इन हात्‍ती ओतुर, अदिक आव आकिन पार ठहरूसदुन; अदिक आक ईद अंदकु आऊन हेसुर मूसा ईटदुर, “ना ईऊक नीर दा टु तेगदिदीन.” ");
INSERT INTO hoy_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","हींग आत कि याग मूसा हारोदव आदुन, आ दिनगोळ दा आव व्‍हार्या तान वार्ट-बन्‍धुगोळ हात्‍ती होगकु आंदुर दुखगोळ मा नजर हाक्कदुन; आग आव नोळदुन कि ऊंद मिस्त्री मंळसा आऊन ऊंद इब्री वार्ट उक बडेत्‍यान. ");
INSERT INTO hoy_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","आव ईत आत नोळदुन कि याऊ हैलेच, रा आ मिस्त्री मंळसा अक कोंद बुट्‍टुन अदिक धुळा दा मुच्‍च बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","बाक दुसरा दिशी व्‍हार्या होगकु आव नोळदुन कि येढ्‍ढ इब्री मंळसा आपस दा बडाबडी माळेत्‍यार. आव अपराधी से अंदुन, “नी तान वार्ट उक येती बडुत्‍या?” ");
INSERT INTO hoy_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","आव अंदुन, “याव नीनी नाम लॉकुर मा हाकिम अदिक न्‍यायी ठहरूसदुन? याता प्रकार देल नी मिस्त्री मंळसा अक कोंद बुट्‍ट, येन हांगा नी नानी भी कोन्‍नोद चाहासत्‍या?” आग मूसा ईद विचार माळकु अंजेदुन, “निश्‍चय ई मात खुल्‍सेग्‍याद.” ");
INSERT INTO hoy_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","याग फिरौन ई मात केळदुन आग मूसा अक कोन्‍नोद युक्‍ति माळदुन. लेकीन मूसा फिरौन उन मुंदु टु ओळदुन, अदिक मिद्यान द्‍याश दा होगकु ईरली कुरतुन; अदिक आव अल ऊंद भाय इन हात्‍ती कुर्तोदुन. ");
INSERT INTO hoy_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिद्यान इन याजक उन येळ पोरगोळ ईरोर; अदिक आंदुर अल बंदकु नीर तुमली हतदुर कि डोनी दा तुमकु तान आप्‍प उन म्यांडा अदिक मर्रगोळी कुळसुल. ");
INSERT INTO hoy_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","आग चरवाहागोळ बंदकु आंदरी हटुसली हतदुर; इदुर मा मूसा निदुरकु आंदुर सहायता माळदुन, अदिक म्यांडा अदिक मर्रगोळी नीर कुळ्‍सदुन. ");
INSERT INTO hoy_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","याग आंदुर तान आप्‍प रूएल उन हात्‍ती वापस बंदुर, आग आव आंदुर से केळदुन, “येन कारण आद कि ईंद नीव राटनेरी वापस होट बंदीर.” ");
INSERT INTO hoy_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","आंदुर अंदुर, “ऊंद मिस्त्री मंळसा नामी चरवाहगोळ कय दा टु बिळ्सदुन, अदिक नाम साटी हापाळ नीर तुमकु म्यांडा अदिक मर्रगोळी कुळ्‍सदुन.” ");
INSERT INTO hoy_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","आग आव तान पोरगोळ से अंदुन, “आव मंळसा येल आन? नीव आऊक येती बिटकु बंदीर? आऊक कारूकु तरी कि आव भोजन माळ्‍यान.” ");
INSERT INTO hoy_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","अदिक मूसा आ मंळसा अन सांगुळ ईरली तयार आदुन. आव आऊन से तान पोर सिप्पोरा अन मदा माळ बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","आक इक ऊंद पार पैदा आदुन, आग मूसा ईद अंदकु, “ना दुसरा द्‍याश दा परदेशी आईन,” आऊन हेसुर गेर्शोम ईटदुन. ");
INSERT INTO hoy_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","हापाळ दिन बितुसदुर बाद्‍दा मिस्त्र अन राजा सोतोदुन. इस्त्राएली कठिन स्यावा अन कारण राहत इन श्वास ताकोमली कुरतुर, अदिक कारूली कुरतुर, अदिक आंदुर दुहाई जो कठिन स्‍यावा अन कारण आत अद परमेश्वर ताका पोहचुस्त. ");
INSERT INTO hoy_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","परमेश्वर आंदुर तकलीफ केळकु तान वाचा अक, जो आव अब्राहम, इसहाक, अदिक याकूब उन सांगुळ कटीदुन, याद माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","अदिक परमेश्वर इस्त्राएलीगोळ मा नजर माळकु आंदुर मा चित्त हचदुन. ");
INSERT INTO hoy_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मूसा तान मॉव यित्रो हेसुर इनव मिद्यान उन याजक उन म्यांडा अदिक मर्रगोळी आळ्‍सतोगोन; अदिक आव अवरी आळी इन पश्चिम दी होरेब हेसुर इन परमेश्वर उन पर्वत इन हात्‍ती ओतुन. ");
INSERT INTO hoy_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","अदिक परमेश्वर उन दूत ऊंद मुळ्‍ल इन झाळी इन न्‍याड्या बेक्‍की इन ज्‍वाला दा आऊक दर्शन कोट्‍टुन; अदिक आव कण्‍ण म्‍याकुच माळकु नोळदुन कि झाळी होतेत्‍याद, लेकीन भस्‍म आगाल. ");
INSERT INTO hoy_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","आग मूसा बिचार माळदुन, “ना आत होगकु ई धोळ्‍द आश्चर्य अक नोळाईन कि अद झाळी येती होत कोमाल.” ");
INSERT INTO hoy_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","याग यहोवा नोळदुन कि मूसा नोळोर साटी तिर्गकु बरेत्‍यान, आग परमेश्वर आऊक झाळी इन बीच दा टु कारदुन, “हे मूसा, हे मूसा!” मूसा अंदुन, “येन आग्‍या.” ");
INSERT INTO hoy_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","आव अंदुन, “ईत हात्ती बरबाळ; अदिक तान कालगोळ दा टु जुतागोळ ईळ्‍सबुळ, यतिकी याता जागा मा नी निदुरकु आय अद पवित्र जागा हुन.” ");
INSERT INTO hoy_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","बाक आव अंदुन, “ना नीन आप्‍प उन परमेश्वर, अदिक अब्राहम उन परमेश्वर, इसहाक उन परमेश्वर, अदिक याकूब उन परमेश्वर हुईन.” आग मूसा अन्द जो परमेश्वर उन दी नोळोद हिम्मत ईला ईरोद, तान मार्रा होच बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","बाक यहोवा अंदुन, “ना तान प्रजा अन लॉकुर जो मिस्त्र दा आर, आंदुर दुखगोळी निश्‍चय नोळीन; अदिक आंदुर जो किटरोद मयनत माळसुसावाळेर कारण आगतद अदरी भी ना केळीन, अदिक आंदुर तकलीफ मा ना चित्त हचीन; ");
INSERT INTO hoy_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","इदुरसाटी ईग ना ईळुकु बंदीन कि आंदरी मिस्त्रीगोळ कय दा टु बिळसुसाईन, अदिक आ द्‍याश दा टु तेगुकु मात्‍त ऊंद वळ्‍लीद धोळ्‍द द्‍याश दा, यदुर दा हाल अदिक शयद इन धारागोळ वाहुसताव मतलब कनानी, हित्ती, एमोरी, परिज्जी, हिब्बी, अदिक यबूसी लॉकुर जागा दा पोहचुसाईन. ");
INSERT INTO hoy_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","इदुरसाटी ईग केळ, इस्त्राएलीगोळ्‍द किटरोद नानी केळ सिक्‍याद, अदिक मिस्त्रीगोळ्द आंदुर मा अत्याचार माळोद भी नानी कांळस्‍याद. ");
INSERT INTO hoy_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","इदुरसाटी बर, ना नीनी फिरौन उन हात्‍ती कळुतीन कि नी नान इस्त्राएली प्रजा अक मिस्त्र दा टु तेगुकु तंद्या.” ");
INSERT INTO hoy_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","लेकीन मूसा परमेश्वर से अंदुन, “ना याव हुईन जो फिरौन उन हात्‍ती होगाईन, अदिक इस्त्राएलीगोळी मिस्त्र दा टु तेगुकु तराईन?” ");
INSERT INTO hoy_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","परमेश्वर अंदुन, “निश्‍चय ना नीन सांगुळ ईराईन; अदिक ई मात इन कि नीन कळावाळा ना हुईन, नीन साटी ईद चिन्ह ईत्‍तीत कि याग नी आ लॉकुरी मिस्त्र दा टु तेगु कोंड्‍या, आग नी ईदा पहाळी मा नान उपासना माळ्‍या.” ");
INSERT INTO hoy_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मूसा परमेश्वर से अंदुन, “याग ना इस्त्राएलीगोळ हात्‍ती होगकु आंदुर से अनाईन, ‘नीम पुर्वजगोळ परमेश्वर नानी नीम हात्‍ती कळ्‍यान,’ आग अगर आंदुर नान से केळुल, ‘आऊन येन हेसुर आद?’ आग ना आंदरी येन हेळाईन?” ");
INSERT INTO hoy_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","परमेश्वर मूसा से अंदुन, “ना जो आईन अद आईन.” बाक आव अंदुन, “नी इस्त्राएलीगोळ से अनेत, ‘यार्द हेसुर ना हुईन अदिक आवा नानी नीम हात्‍ती कळ्‍यान.’” ");
INSERT INTO hoy_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","अदिक परमेश्वर मूसा से ईद भी अंदुन, “नी इस्त्राएलीगोळ से ईद भी अनेत, ‘नीम पुर्वजगोळ परमेश्वर, अदिक अब्राहम उन परमेश्वर, इसहाक उन परमेश्वर, अदिक याकूब उन परमेश्वर, यहोवा, आवा नानी नीम हात्‍ती कळ्‍यान. नोळ, हमेशा ताका नान हेसुर ईदा ईत्‍तीत, अदिक पीढ़ोन पीढ़ी दा नान याद ईदुर देल अच आगतेला ईत्‍तीत.’ ");
INSERT INTO hoy_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","इदुरसाटी ईग होगकु इस्त्राएली हाळाबाट्टुर इक जमा माळ, अदिक आंदुर से अन, ‘नीम आप्‍प अब्राहम, इसहाक, अदिक याकूब उन परमेश्वर, यहोवा नानी दर्शन कोटकु ईद अंदान कि ना नीम मा अदिक नीम से जो बर्ताव मिस्त्र दा माळकु आगतद अदुर मा भी चित्त हचीन; ");
INSERT INTO hoy_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","अदिक ना ठान्‍स कोंडीन कि नीमी मिस्त्र अन दुखगोळ दा टु तेगुकु कनानी, हित्ती, एमोरी, परिज्जी, हिब्बी, अदिक यबूसी लॉकुर द्‍याश दा ओयाईन, जो हींग द्‍याश आद कि यदुर दा हाल अदिक शयद इन धारागोळ वाहुसताव.’” ");
INSERT INTO hoy_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","आग आंदुर नीन मानस्‍यार; अदिक नी इस्त्राएली हाळाबाट्टगोळ सांगुळ हुडुकु मिस्त्र अन राजा अन हात्‍ती होगकु आऊन से ईद अनेत, “इब्रीगोळ्‍द परमेश्वर, यहोवा से नाम मुलाकात आग्‍याद; ‘इदुरसाटी ईग नामी मुर दिन इन हादी मा आळी दा होगगोळ कि तान परमेश्वर उक बलिदान येर्सेव.’ ");
INSERT INTO hoy_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ना जान्‍सतीन कि मिस्त्र अन राजा नीमी आगासताका होग गोळतीदील, यागासताका कि ऊंद ताकतवर कय आऊक मजबुर माळाल्द. ");
INSERT INTO hoy_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","इदुरसाटी ना कय वाळुसकु आ सप्‍पा आश्‍चर्य कर्मगोळ से, जो मिस्त्र अन बीच दा माळाईन, आ द्‍याश इक बडाईन; अदिक अदुर बाद्‍दा आव नीमी होग गोट्‍टान.” ");
INSERT INTO hoy_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“आग ना मिस्त्रीगोळ से तान ई प्रजा अन अनुग्रह माळसुसाईन; अदिक याग नीव होट्‍टीर आग खाली कय देल होळतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","उलटा नीम ऊंद ऊंद आर्त तान तान मान्‍ना हातळोर, अदिक आंदुर्द मान्‍या ईरावाळेर से व्‍हान्‍ना- बेळ्ली इन ईसरावाळी, अदिक कपळा बेळ कोंडार, अदिक नीव अवरी तान पार अदिक पोरगोळी हाकसुसेतीर; ई प्रकार देल नीम मिस्त्रीगोळी लुट्‍सीर.” ");
INSERT INTO hoy_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","आग मूसा उत्‍तर कोट्‍टुन, “आंदुर नान विश्वास माळतीदील अदिक नांद केळतीदील, बल्‍की अंदार, ‘यहोवा नीनी दर्शन कोटीदील.’” ");
INSERT INTO hoy_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","यहोवा आऊन से अंदुन, “नीन कय दा अद येन हुन?” आव अंदुन, “कोल.” ");
INSERT INTO hoy_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","आव अंदुन, “अदरी भुमी मा हाक्‍कबुळ.” याग आव अदरी भुमी मा हाकदुन आग अद हाव बनसेत, अदिक मूसा अदुर मुंदु टु ओळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","आग यहोवा मूसा से अंदुन, “कय वाळुसकु अदुर पुछी हुडु कोम, याग आव कय वाळुसकु अदरी हुळदुन आग अद आऊन कय दा मात्‍त कोल बनसेत. कि आ लॉकुर विश्‍वास माळुल कि नीम पुर्वजगोळ परमेश्वर मतलब अब्राहम उन परमेश्वर, इसहाक उन परमेश्वर, अदिक याकूब उन परमेश्वर, यहोवा नीनी दर्शन कोटान.” ");
INSERT INTO hoy_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ताकी आ लॉकुर विश्वास माळुल कि “नीम पुर्वजगोळ परमेश्वर मतलब अब्राहम उन परमेश्वर, इसहाक उन परमेश्वर, अदिक याकूब उन परमेश्वर, यहोवा नीनी दर्शन कोटान.” ");
INSERT INTO hoy_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","बाक यहोवा आऊन से ईद भी अंदुन, “तान कय याद्‍दा मा ईटकु झाक्‍स.” इदुरसाटी आव तान कय याद्‍दा मा ईटकु झाक्‍स बुट्‍टुन; बाक याग अदरी तेगदुन आग येन नोळदुन कि आऊन कय कोढ़ इन कारण बरफ इन घाई बिळीद आगेग्‍याद. ");
INSERT INTO hoy_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","आग आव अंदुन, “तान कय याद्‍दा मा मात्‍त ईटकु झाक्‍स.” आव तान कय याद्‍दा मा ईटकु मात्‍त झाक्‍सदुन; अदिक याग आव अदरी याद्‍दा मा टु तेगदुन रा येन नोळतान कि आऊन पुरा मय पयला अन्द घाई आगेत. ");
INSERT INTO hoy_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","आग यहोवा अंदुन, “अगर आंदुर नीन मात इन विश्वास माळतीदील, अदिक पयला चिन्‍ह अक मान्‍सतीदील, रा दुसरा चिन्ह अन विश्‍वास माळ्‍यार. ");
INSERT INTO hoy_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","अदिक अगर आंदुर ई येढ्‍ढु चिन्हगोळ्द विश्वास माळतीदील अदिक नीन मातगोळी केळालुर, आग नी नील गांगा टु थ्‍वाळासा नीर हुडुकु वंळगींद जमीन मा हाक्‍क बुळेत; अदिक जो नीर नी गांगा दा टु तेगद्‍या अद वंळगींद जमीन मा रक्‍ता बनसेदीत.” ");
INSERT INTO hoy_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","मूसा यहोवा से अंदुन, “हे नान प्रभु, ना माताळदुर दा निपुण हैलेच, न पयला ईरीन, अदिक न यागी टु नी तान दास उन से मात हेळली हद; ना रा मार्रा अदिक ल्‍यालग्‍या अन तोतळा मंळसा आईन.” ");
INSERT INTO hoy_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","यहोवा आऊन से अंदुन, “मंळसा अन बाय याव माळ्‍यान? अदिक मंळसा अक मुक्‍का, या बयरा, या नोळावाळा, या कुढ्‍ढ, ना यहोवा अक बिटकु मात्‍त याव माळतान? ");
INSERT INTO hoy_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ईग होग, ना नीन दण्ण इन सांगुळ ईतकु जो नानी अनोद ईत्‍तीत अद नीनी कल्‍सतोगाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","आव अंदुन, “हे नान प्रभु, कृपया यावारा दुसरा अक कळु कोम.” ");
INSERT INTO hoy_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","आग यहोवा अन गुस्सा मूसा मा भळकुस्‍त अदिक आव अंदुन, “येन नीन वार्ट लेवीय वंश इन हारून आल्‍लच? नानी निश्‍चय आद कि आव माताळदुर दा निपुण आन, अदिक आव नीन से मुलाकात इक होटकु बरतान; अदिक नीनी नोळकु मन दा खुश आदान. ");
INSERT INTO hoy_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","नी आऊन से मात्त माळेत, अदिक आऊक हेळेत, कि येन माळोद आद, ना आऊक अदिक नीन इक माताळली मदत माळाईन अदिक नीम इक येन माळोद आद, ‘कलसाईन.’ ");
INSERT INTO hoy_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","हारून नीन दी टु लॉकुर से मातगोळ माळतेला ईत्‍तान; आव नीन साटी बाय इन दण्ण अदिक नी आऊन साटी परमेश्वर उन घाई ठहरूस्‍या. ");
INSERT INTO hoy_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","अदिक नी ई कोल इक कय दा हुडुकु ओय, अदिक ईदुर देल अच चिन्हगोळी तोर्सेत.” ");
INSERT INTO hoy_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","आग मूसा तान मॉव यित्रो अन हात्‍ती वापस बंदुन अदिक आऊन से अंदुन, “नानी सार माळ कि ना मिस्त्र दा ईरावाळेर तान वार्टुर हात्‍ती होगकु नोळाईन कि आंदुर ईगासताका जीत्‍ता आर या ईला.” यित्रो अंदुन, “कुशल देल होग.” ");
INSERT INTO hoy_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","अदिक यहोवा मिद्यान द्‍याश दा मूसा से अंदुन, “मिस्त्र अक वापस होटोग; यतिकी जो मंळसागोळ नीन जीव इन प्यासा ईरोर आंदुर सप्‍पा सोतोग्यार.” ");
INSERT INTO hoy_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","आग मूसा तान हिंग्‍स अदिक चिकोरी गदा मा येर्सकु मिस्त्र द्‍याश दी परमेश्वर उन आ कोल इक कय दा हुडुकु वापस होदुन. ");
INSERT INTO hoy_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","आग यहोवा मूसा से अंदुन, “याग नी मिस्त्र दा पोहचुस्‍या रा ध्‍यान ईटेत कि जो चमत्कार ना नीन वश दा माळीन आ सप्‍पा अक फिरौन उक तोर्सेत; लेकीन ना आऊन मन इक कठोर माळाईन, अदिक आव नान प्रजा अक होगगोळतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","अदिक नी फिरौन से अनेत, ‘यहोवा ईद अनतान, कि इस्त्राएल नान धोळ पार हुन, ");
INSERT INTO hoy_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","अदिक ना जो नीन से अंद कोंडीन नान पार उक होगगोळ कि आव नान स्यावा माळ्‍यान; अदिक नी ईगासताका आऊक होग गोटीदील, ई कारण ना ईग नीन धोळ पार उक घात माळाईन.’” ");
INSERT INTO hoy_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","आग हींग आत कि हादी मा ईरोद जागा दा यहोवा मूसा से मुलाकात माळकु आऊक कोंद बुळोद चाहासदुन. ");
INSERT INTO hoy_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","आग सिप्पोरा ऊंद तेज चकमक कल्‍ल हुडुकु तान पार उन खतना माळ बुट्टुर, अदिक मूसा अन कालगोळ मा ईद अंदकु भीट बुट्‍टुर, “निश्‍चय नी नान साटी रक्‍ता वाहुसावाळा नान गांड्‍ड हुय.” ");
INSERT INTO hoy_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","आग यहोवा आऊक बिट बुट्‍टुन. आ समय खतना अन कारण आक माताळदुर, “नी रक्‍ता वाहुसावाळा गांड्‍ड हुय.” ");
INSERT INTO hoy_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","आग यहोवा हारून से अंदुन, “मूसा से मुलाकात माळली आळी दा होग.” आव होदुन अदिक परमेश्वर उन पर्वत मा आऊन से सिकदुन अदिक आऊन पवित्र चुम्‍बन ताकोंडुन. ");
INSERT INTO hoy_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","आग मूसा हारून उक ईद हेळसुसदुन कि यहोवा येन येन मातगोळ हेळकु आऊक कळ्‍यान, अदिक याता याता चिन्ह तोरसोद आग्‍या आऊक कोटान. ");
INSERT INTO hoy_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","आग मूसा अदिक हारून होगकु इस्त्राएलीगोळ्‍द सप्‍पा पुर्वजगोळी जमा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","अदिक यास मातगोळ यहोवा मूसा से अंदीदुन अद सप्‍पा हारून आंदरी केळ्‍सदुन, अदिक लॉकुर कण्णगोळ मुंद अव चिन्ह भी तोर्सदुर. ");
INSERT INTO hoy_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","अदिक लॉकुर आंदुर विश्वास माळदुर; अदिक ईद केळकु कि यहोवा इस्त्राएलीगोळ्‍द सुधी ताकोंडान अदिक आंदुर दुखगोळ मा दृष्‍टी माळ्‍यान, आंदुर म्यांडा बांग्‍सकु दण्‍डवत माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","आग मूसा अदिक हारून होगकु फिरौन से अंदुर, “इस्त्राएल इन परमेश्वर यहोवा ईद अनतान: ‘नान प्रजा अन लॉकुरी होगगोळ कि आंदुर आळी दा नान साटी हाब्‍ब मनुस्‍यार.’” ");
INSERT INTO hoy_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फिरौन अंदुन, “यहोवा याव हुन कि ना आऊन वचन मान्‍सकु इस्त्राएलीगोळी होगगोळाईन? ना यहोवा अक अरालीन, अदिक ना इस्त्राएलीगोळी होगगोळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","आंदुर अंदुर, “इब्रीगोळ परमेश्वर नाम से मुलाकात माळ्यान; इदुरसाटी नामी आळी दा मुर दिन इन हादी मा होगगोळ, कि तान परमेश्वर यहोवा अन साटी बलिदान माळेव, हींग आगबाळुल कि आव नाम दा मरी फैलुस्‍यान या तलवार नळसुस्यान.” ");
INSERT INTO hoy_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","मिस्त्र अन राजा आंदुर से अंदुन, “हे मूसा, हे हारून, नीव येती लॉकुर से क्‍याल्‍सा बिळसुसोद चाहासतीर? नीव होगकु तान तान ओझा नेगी.” ");
INSERT INTO hoy_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","अदिक फिरौन अंदुन, “केळी, ई द्‍याश दा आ लॉकुर हापाळ आगेग्‍यार, बाक नीव आंदरी मयनत देल आराम कोळोद चाहासतीर!” ");
INSERT INTO hoy_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","फिरौन अदा दिशी आ मयनत माळसुसावाळेर इक जो आ लॉकुर म्‍याकुच ईरोर, अदिक आंदुर स्याणा अक ईद आग्‍या कोट्‍टुन, ");
INSERT INTO hoy_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“नीव जो ईगासताका ईटागोळ माळोर साटी लॉकुरी भुसा कोळतोगीर, अद मुंदु टु कोळ बाळेतीर; आंदुर खुद अच होगकु तान साटी भुसा जमा माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तरी भी यास ईटागोळ ईगासताका आंदरी माळव बिळव आसा मुंद भी आंदुर से माळसुसेतीर, ईटागोळ्‍द गिनती येनु गोर्त माळबाळेतीर; यतिकी आंदुर आलसी आर, ई कारण ईद अंदकु चिळ्लासतार, ‘नाव होगकु तान परमेश्वर उन साटी बलिदान माळेव.’ ");
INSERT INTO hoy_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","आ मंळसागोळ से मात्‍त यक्‍कुल क्‍याल्‍सा माळसुसकु आगुल कि आंदुर अदुर दा मयनत माळतेला ईरूल अदिक ख्‍वाटा मातगोळ मा ध्‍यान कोळबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","आग लॉकुर मयनत माळसुसावाळेर अदिक मुखियागोळ व्‍हार्या होगकु आंदुर से अंदुर, “फिरौन हींग अनतान, ‘ना नीमी भुसा कोळालीन. ");
INSERT INTO hoy_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","नीवा खुद होगकु भुसा ढुंढ्सकु तरी; लेकीन नीम क्‍याल्‍सा येनु अच गोर्त माळकु आगतीदील.’” ");
INSERT INTO hoy_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","इदुरसाटी आ लॉकुर पुरा मिस्त्र द्‍याश दा तितर बितर आदुर कि भुसा अन बदला लेल्‍ल इन छळी तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","मयनत माळसुसावाळेर ईद अंद अंदकु आंदुर से जल्‍दी माळसुस्‍त ईत्‍तुर, कि याता प्रकार देल नीव काड्‍डा ताकोमकु माळतोगीर अदा प्रकार देल तान हर दिन इन क्‍याल्‍सा ईग भी पुरा माळी. ");
INSERT INTO hoy_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","अदिक इस्त्राएलीगोळ दा टु याता मुखियागोळी फिरौन उन मयनत माळसुसावाळेर आंदुर अधिकारी ठहरूसीदुर, आंदुर बळ्‍सकोंडुर अदिक आंदुर से केळकु आत, “येन कारण आद कि नीव तान ठहरूस्‍द ईटागोळ गिनती इन अनुसार पयला अन घाई नाळ अदिक ईंद पुरा माळसुसीदील?” ");
INSERT INTO hoy_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","आग इस्त्राएलीगोळ्‍द मुखियागोळ होगकु फिरौन उन दुहाई ईद अंदकु कोट्‍टुर, “नी तान दासगोळ से हींग बर्ताव येती माळत्‍या? ");
INSERT INTO hoy_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","नीन दासगोळी भुसा रा कोटकु अच आगाल अदिक आंदुर नाम से अनतोगतार, ‘ईटागोळ माळी, ईटागोळ माळी, ’ अदिक नीन दासगोळ भी बळ्‍सकोंडार; लेकीन दोष नींदा लॉकुर्द आद.” ");
INSERT INTO hoy_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फिरौन अंदुन, “नीव आलसी अदिक कोळी आईर; ईदा कारण अनतीर कि नामी यहोवा अन साटी बलिदान माळली होगगोळ. ");
INSERT INTO hoy_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ईग होगकु तान क्‍याल्‍सा माळी; अदिक भुसा नीमी सिकतीदील, लेकीन ईटागोळ्‍द गिनती आट अच पुरा माळोद बिद्‍दीत.” ");
INSERT INTO hoy_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","याग इस्त्राएलीगोळ्‍द सरदारगोळ ई मात केळदुर कि आंदुर ईटागोळ्‍द गिनती गोर्त आगतीदील, अदिक हर दिशी आटा क्‍याल्‍सा पुरा माळोद बिद्‍दीत, आग आंदुर अर्त कोंडुर कि आंदुर संकट इन दिन होट बंदाव. ");
INSERT INTO hoy_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","याग आंदुर फिरौन उन हात्‍ती टु व्‍हार्या होट बुट्‍टुर आग मूसा अदिक हारून, जो आंदुर से मुलाकात माळली निदुरकु ईरोर, आंदरी सिकदुर; ");
INSERT INTO hoy_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","अदिक आंदुर मूसा अदिक हारून से अंदुर, “यहोवा नीम मा दृष्‍टी माळकु न्‍याय माळुल, यतिकी नीव नामी फिरौन अदिक आऊन कर्मचारीगोळ नजर दा घृणित ठहरूसकु नामी घात माळोर साटी आंदुर कय दा तलवार कोट बुटीर,” ");
INSERT INTO hoy_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","आग मूसा यहोवा अन हात्‍ती होगकु अंदुन, “हे प्रभु, नी ई प्रजा अक तकलीफ येती कोट्ट? अदिक नी नानी ईल येती कळुद? ");
INSERT INTO hoy_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","यागी टु ना नीन हेसुर देल फिरौन उन हात्‍ती मात हेळोर साटी होदीन आगी टु आव ई प्रजा अन सांगुळ बुरा अच दुरव्‍यवहार माळ्‍यान, अदिक नी तान प्रजा अन येनु अच छुटकारा माळीदील.” ");
INSERT INTO hoy_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","बाक यहोवा मूसा से अंदुन, “ ना फिरौन उन सांगुळ माळाईन, ईग नी अदरी नोळ्‍या, आव नान महान शक्ती इन कारण तान द्याश टु आंदरी कळाईन बिना संकोच देल नान महान शक्ती इन कारण आव आंदरी तेग्द बुट्टान.” ");
INSERT INTO hoy_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","परमेश्वर मूसा से अंदुन, “ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ना सर्वशक्तिमान ईश्‍वर उन हेसुर देल अब्राहम, इसहाक, अदिक याकूब उक दर्शन कोळीन, लेकीन यहोवा अन हेसुर देल ना आंदुर मा प्रगट आगीदील. ");
INSERT INTO hoy_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","अदिक ना आंदुर सांगुळ तान वाचा मजबुत माळीन, मतलब कनान द्‍याश यदुर दा आंदुर परदेशी आगकु ईरतोगोर, आऊक आंदरी कोट बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","इस्त्राएली यारी मिस्त्री लॉकुर दासत्‍व दा ईटतार, आंदुर कन्नासोद भी केळकु ना तान वाचा अक याद माळीन. ");
INSERT INTO hoy_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ई कारण नी इस्त्राएलीगोळ से अन, ‘ना यहोवा हुईन, अदिक नीमी मिस्त्रीगोळ बोझ इन ल्‍यालमा टु तेगाईन, अदिक आंदुर स्‍यावा दा टु नीमी बिळसाईन, अदिक तान भुजागोळ वाळुसकु अदिक भारी दण्‍ड कोटकु नीमी बिळ्‍स बुळाईन, ");
INSERT INTO hoy_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","अदिक ना नीमी तान प्रजा माळोर साटी अपनुस कोमाईन, अदिक ना नीम परमेश्वर ठहरुसाईन; अदिक नीव जान्‍स कोंडीर कि ना नीम परमेश्वर यहोवा हुईन जो नीमी मिस्त्रीगोळ्द बोझ इन ल्‍यालमा टु तेगुकु तंदीन, ");
INSERT INTO hoy_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","अदिक याता द्‍याश इन कोळोद किर्‍या ना अब्राहम, इसहाक, अदिक याकूब से तिंदीदीन अदुर दा नीमी पोहचुस्कु अदरी नीम्‍द अधिकार माळ बुळाईन. ना रा यहोवा हुईन.’” ");
INSERT INTO hoy_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ई मातगोळ मूसा इस्त्राएलीगोळी केळ्‍सदुन, लेकीन आंदुर मन इन बेचैनी अदिक स्यावा अन क्रुरता अन कारण आऊन केळीदील. ");
INSERT INTO hoy_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","आग यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“नी होगकु मिस्त्र अन राजा फिरौन से अन कि इस्त्राएलीगोळी तान द्‍याश दा टु होगगोळ.” ");
INSERT INTO hoy_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","लेकीन मूसा यहोवा से अंदुन, “नोळ, इस्त्राएलीगोळ नान केळीदील; बाक फिरौन नान तोतळा माताळावाळा अन ह्‍यांग केळ्‍यान?” ");
INSERT INTO hoy_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","आग यहोवा मूसा अदिक हारून उक इस्त्राएलीगोळ अदिक मिस्त्र अन राजा फिरौन उन साटी ई अभिप्राय देल आग्‍या कोट्‍टुन कि आंदुर इस्त्राएलीगोळी मिस्त्र द्‍याश टु तेगुकु ओयुल. ");
INSERT INTO hoy_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","आंदुर पुर्वजगोळ्‍द घराना नोर मुख्‍य मंळसा ईंदुर उर: इस्त्राएल उन धोळ पार, रूबेन उन पारगोळ: हनोक, पल्लू, हेस्त्रोन अदिक कर्मी; ईंदुर देल अच रूबेन उन वंश होट्‍टव. ");
INSERT INTO hoy_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमोन उन पारगोळ: यमूएल, यामीन, ओहद, याकीन अदिक सोहर, अदिक ऊंद कनानी आर्त इन पार शाऊल; ईंदुर देल अच शिमोन उन कुल होट्‍टव. ");
INSERT INTO hoy_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवी इन पारगोळ यार देल आंदुर्द वंशावली नळदाव, आंदुर हेसुर ईव हुव: मतलब गेर्शोन, कहात अदिक मरारी; अदिक लेवी इन पुरा अवस्‍था ऊंद सौ सदतीस साल इन आत. ");
INSERT INTO hoy_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्शोन उन पार यार देल आंदुर कुल नळदाद: लिबनी अदिक शिमी. ");
INSERT INTO hoy_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहात उन पारगोळ: अम्राम, यिसहार, हेब्रोन अदिक उज्जीएल; अदिक कहात उन पुरा अवस्‍था ऊंद सौ सदतीस साल उन आत. ");
INSERT INTO hoy_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारी इन पारगोळ: महली अदिक मूशी. लेवीगोळ्‍द कुल यार देल आंदुर वंशावली नळदाद ईंदुरा हुर. ");
INSERT INTO hoy_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्राम तान फुय योकेबेद से मदा माळदुन अदिक आकिन से हारून अदिक मूसा पैदा आदुर; अदिक अम्राम उन पुरा अवस्‍था ऊंद सौ सदतीस साल इन आत. ");
INSERT INTO hoy_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहार उन पारगोळ: कोरह, नेपेग अदिक जिक्री ईरोर. ");
INSERT INTO hoy_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्जीएल उन पारगोळ: मीशाएल, एलसाफान अदिक सित्री. ");
INSERT INTO hoy_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारून अम्‍मीनादाब उन पोर, अदिक नहशोन उन आकतींग एलीशेबा से मदा माळदुन; अदिक आकिन से नादाब, अबीहू, एलीआजर अदिक ईतामार पैदा आदुर. ");
INSERT INTO hoy_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरह अन पारगोळ: अस्‍सीर, एलकाना अदिक अबीआसाप; अदिक ईंदुर देल अच कोरह वंश इन कुल टु होट्‍टुर. ");
INSERT INTO hoy_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारून उन पार एलीआजर पूतीएल उन पोर इन से मदा माळदुन; अदिक आकिन से पीनहास पैदा आदुन. ईंदुर देल अच आंदुर कुल नळुत. लेवीगोळ्‍द पुर्वजगोळ घराना नोर मुख्‍य मंळसागोळ ईंदुरा उर. ");
INSERT INTO hoy_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","हारून अदिक मूसा ईंदुरा हुर यारी यहोवा ईद आग्‍या कोट्टान: “इस्त्राएलीगोळी दल दल माळकु आंदरी जमा माळकु मिस्त्र द्‍याश टु तेगुकु तरी.” ");
INSERT INTO hoy_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ईंदुर आंदुरा मूसा अदिक हारून हुर यार मिस्त्र द्‍याश इन राजा फिरौन से अंदुर कि नाव इस्त्राएलीगोळी मिस्त्र द्‍याश टु तेगुकु वोतेव. ");
INSERT INTO hoy_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","याग यहोवा मिस्त्र द्‍याश दा मूसा से ईद मात अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“ आव मूसा से अंदुन, ना यहोवा हुईन; इदुरसाटी जो येनारा ना नीन से अनाईन अद सप्‍पा मिस्त्र अन राजा फिरौन से अनेत.” ");
INSERT INTO hoy_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","लेकीन मूसा यहोवा अक उत्‍तर कोट्‍टुन, “ना रा माताळदुर दा तोतळा आईन; अदिक फिरौन ह्‍यांग नांद केळ्‍यान?” ");
INSERT INTO hoy_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","आग यहोवा मूसा से अंदुन, “केळ, ना नीनी फिरौन उन साटी परमेश्वर उन घाई ठहरूसतीन; अदिक नीन वार्ट हारून नीन नबी ठहरूस्‍यान. ");
INSERT INTO hoy_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जो जो आग्‍या ना नीनी कोळाईन अदा नी अनेत, अदिक हारून अदरी फिरौन से अंदान, यदुर देल आव इस्त्राएलीगोळी तान द्‍याश दा टु होळगोट्‍टान. ");
INSERT INTO hoy_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","लेकीन ना फिरौन उन मन इक कठोर माळाईन, अदिक तान हापाळ सा चिन्‍ह अदिक चमत्कार मिस्त्र द्‍याश दा तोरसुसाईन. ");
INSERT INTO hoy_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","तरी भी फिरौन नीम्‍द केळतीदील; अदिक ना मिस्त्र द्‍याश मा तान कय नेगुकु मिस्त्रीगोळी भारी दण्‍ड कोटकु तान सेना मतलब तान इस्त्राएली प्रजा अक मिस्त्र द्‍याश टु तेग्‍द बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","अदिक याग ना मिस्त्र मा कय वाळुसकु इस्त्राएलीगोळी आंदुर बीच दा टु तेगाईन, आग मिस्त्री अर्त कोंडार कि ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","आग मूसा अदिक हारून यहोवा अन आग्‍या अन अनुसार अच माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","याग आंदुर फिरौन से मात माळली कुरतुर आग मूसा अस्‍सी साल इन, अदिक हारून तिर्‍यास्सी साल इन ईरोन. ");
INSERT INTO hoy_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","बाक यहोवा मूसा अदिक हारून से ईत्‍ता प्रकार अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“याग फिरौन नीम से अनुल, ‘तान प्रमाण इन यातोदारा चमत्कार तोर्सी,’ आग नी हारून से अनेत, ‘तान कोल हुडुकु फिरौन उन मुंद हाक्‍क बुळ कि अद हाव बनसेगुल.’” ");
INSERT INTO hoy_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","आग मूसा अदिक हारून फिरौन उन हात्‍ती होगकु यहोवा अन आग्‍या अन अनुसार माळदुर; अदिक याग हारून तान कोल फिरौन अदिक आऊन कर्मचारीगोळ्‍द मुंद हाकदुन, आग अद हाव बनसेत. ");
INSERT INTO hoy_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","आग फिरौन पण्‍डीतगोळ अदिक जादु टोना माळावाळेरी कारसुसदुन; अदिक मिस्त्र अन जादूगरगोळ बंदकु तान तान तंत्र-मंत्र देल हांगा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","आंदुर भी तान तान कोलगोळी हाक्‍क बुट्‍टुर, अदिक अव भी हाव बनसेदव. लेकीन हारून उन कोल आंदुर कोलगोळी नुंगबुळ्‍त. ");
INSERT INTO hoy_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","लेकीन फिरौन उन मन मात्‍त यक्‍कुल कठिन आगेत, अदिक यहोवा अन वचन इन अनुसार आव मूसा अदिक हारून उन मातगोळी मान्‍सीदील. ");
INSERT INTO hoy_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","आग यहोवा मूसा से अंदुन, “फिरौन उन मन कठोर आगेग्‍याद अदिक आव ई प्रजा अक होग गोळालुन. ");
INSERT INTO hoy_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","याग फिरौन व्‍हातुर इन होती गांगा अन्द किनारा मा बंदान आ समय नी आऊन हात्ती होगेत; अदिक जो कोल हाव बनसेगीत, अदरी कय दा हुडुकु नील गांगा अन किनारा मा आऊन से मुलाकात माळोर साटी निदुरकु ईरेत. ");
INSERT INTO hoy_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","अदिक आऊन से ईत्‍ता प्रकार अनेत, ‘इब्रीगोळ परमेश्वर यहोवा नानी ईद अनोर साटी नीन हात्‍ती कळ्‍यान कि नान प्रजा अन लॉकुरी होगगोळ, यदुर देल आंदुर आळी दा नान उपासना माळ्‍यार; अदिक ईगास ताका नी नान मात मान्सीदील. ");
INSERT INTO hoy_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","यहोवा ईद अनतान, ईदुर देल नी जान्‍स कोंड्‍या कि ना अच परमेश्वर हुईन; नोळ, ना तान कय इन कोल इक नील गांगा अन किनारा मा बडाईन, अदिक नीर रक्‍ता बन्‍सेदीत, ");
INSERT INTO hoy_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","अदिक जो मेनगोळ नील गांगा दा आव अव सोतोदाव, अदिक गांगा वास बरली हत्तीत, अदिक गांगा अन नीर कुडोर साटी मिस्त्रीगोळ्द योग्य ईरतीदील.’” ");
INSERT INTO hoy_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","बाक यहोवा मूसा से अंदुन, “हारून से अन कि तान कोल हुडुकु मिस्त्र द्‍याश दा याट नीर आद, मतलब अदुर्द गांगागोळ, नयरगोळ, झीलगोळ, अदिक डोबनगोळ, सप्‍पा अन म्‍याकुच तान कय वाळुस कि अऊर्द नीर रक्‍ता बनसेगुल; अदिक पुरा मिस्त्र द्‍याश दा काठ अदिक कल्‍ल येढ्‍ढु भाति इन नीर इन पात्रगोळ दा रक्‍ता अच रक्‍ता आगेदीत.” ");
INSERT INTO hoy_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","आग मूसा अदिक हारून यहोवा अन आग्‍या अन अनुसार माळदुर, मतलब आव कोल इक नेगुकु फिरौन अदिक आऊन कर्मचारीगोळ्‍द नोळतेला नील गांगा अन नीर मा बळदुन, अदिक गांगा अन सप्‍पा नीर रक्‍ता बनसेत. ");
INSERT INTO hoy_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","अदिक नील गांगा दा जो मेनगोळ ईरव अव सोतोदव; अदिक गांगा दा टु वास बरली कुर्त, अदिक मिस्त्री लॉकुर गांगा अन नीर कुडु सकीदील; अदिक पुरा मिस्त्र द्‍याश दा रक्‍ता अच रक्‍ता आगेत. ");
INSERT INTO hoy_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","आग मिस्त्र अन जादूगरगोळ भी तान तंत्र-मंत्र देल हांगा माळदुर; तरी भी फिरौन उन मन कठोर आगेत, अदिक यहोवा अन अना अनुसार आव मूसा अदिक हारून उन मान्‍सीदील. ");
INSERT INTO hoy_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फिरौन ईदुर मा भी ध्‍यान कोटीदील, अदिक मार्रा तिर्गुसकु तान मान्‍नी होटोदुन. ");
INSERT INTO hoy_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","अदिक सप्‍पा मिस्त्री लॉकुर कुडा नीर इन साटी नील गांगा अन आसपास अगुळली हतदुर, यतिकी आंदुर गांगा अन नीर ईला कुडु सकोर. ");
INSERT INTO hoy_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","याग यहोवा नील गांगा अक बळदीदुन आगी टु येळ दिन आगेगीदव. ");
INSERT INTO hoy_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","आग यहोवा मात्‍त मूसा से अंदुन, “फिरौन उन हात्ती होगकु अन, ‘यहोवा नीन से ईत्‍ता प्रकार देल अनतान: नान प्रजा अन लॉकुरी होगगोळ यदुर देल आंदुर नान आराधना माळ्‍यार. ");
INSERT INTO hoy_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","लेकीन अगर आंदरी होगगोळतीदील रा केळ, ना भ्यापकागोळी कळुकु नीन सप्‍पा द्‍याश इक हानि पोहुचुसावाळा आईन. ");
INSERT INTO hoy_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","अदिक नील गांगा भ्यापकागोळ देल तुम्‍मेदित, अदिक अव नीन भवन दा, अदिक नीन हासक्‍या मा, अदिक नीन कर्मचारीगोळ मान्‍नगोळ दा, अदिक नीन प्रजा मा उलटा नीन भट्‍टागोळ अदिक हीठ कालसोद पात्रगोळ दा भी येरेदाव; ");
INSERT INTO hoy_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","अदिक नीन मा, अदिक नीन प्रजा अदिक नीन कर्मचारीगोळ, सप्‍पा मुंदुर मा भ्यापकागोळ येरेदाव.’” ");
INSERT INTO hoy_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","बाक यहोवा मूसा अक आग्‍या कोट्‍टुन, “हारून से अंदकोम कि गांगागोळ, नयरगोळ, अदिक झीलगोळ म्‍याकुच कय वाळुसकु कोल इन सांगुळ भ्यापकागोळी मिस्त्र द्‍याश मा येर्सकु तरूल.” ");
INSERT INTO hoy_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","इदुरसाटी हारून मिस्त्र द्‍याश इन जलाशयगोळ म्‍याकुच तान कय वाळुसदुन; अदिक भ्यापकागोळ मिस्त्र द्‍याश मा येरकु अदरी होच बुट्‍टव. ");
INSERT INTO hoy_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","अदिक जादूगरगोळ भी हांगा तंत्र-मंत्र देल मिस्त्र द्‍याश मा भ्यापकागोळ येर्सकु तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","आग फिरौन मूसा अदिक हारून उक कारसुसकु अंदुन, “यहोवा से विनती माळी कि आव भ्यापकागोळी नान से अदिक नान प्रजा से दुर माळुल; अदिक ना इस्त्राएली लॉकुरी होगगोळाईन. यदुर देल आंदुर यहोवा साटी बलिदान माळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","आग मूसा फिरौन से अंदुन, “ईट मात साटी नी नानी आदेश कोळ कि ईग ना नीन अदिक नीन कर्मचारीगोळ, अदिक प्रजा अन निमित्त याग विनती माळाईन, कि यहोवा नीन हात्‍ती टु अदिक नीन मान्‍नगोळ दा टु भ्यापकागोळी दुर माळुल, अदिक अव सिर्फ नील गांगा दा सिकुल?” ");
INSERT INTO hoy_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","आव अंदुन, “नाळ.” आव अंदुन, “नीन वचन इन अनुसार आदीत, यदुर नीनी ईद भास आगेगुल कि नाम परमेश्वर यहोवा अन तुल्‍य दुसरा याऊ हैलेच. ");
INSERT INTO hoy_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","अदिक भ्यापकागोळ नीन हात्‍ती टु अदिक नीन मान्‍नगोळ दा टु अदिक नीन कर्मचारीगोळ अदिक प्रजा अन हात्‍ती टु दुर आगकु सिर्फ नील गांगा दा अच ईत्‍ताव.” ");
INSERT INTO hoy_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","आग मूसा अदिक हारून फिरौन उन हात्‍ती टु होटोदुर; अदिक मूसा आ भ्यापकागोळ बारा दा, यहोवा अन दुहाई कोट्‍टुन जो आव फिरौन मा कळीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","अदिक यहोवा मूसा अन अना हिसाब देल माळदुन; अदिक भ्यापकागोळ मान्‍नगोळ, आंगुळगोळ, ऊरगोळ अदिक केईगोळ दा सोतोदव. ");
INSERT INTO hoy_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","अदिक मिस्त्री लॉकुर जमा माळकु अऊर्द ढेर हच बुट्‍टुर, अदिक पुरा द्‍याश वास देल तुम्‍मेत. ");
INSERT INTO hoy_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","लेकीन याग फिरौन नोळदुन कि ईग आराम सिक्‍याद आग यहोवा अन कहना अन अनुसार आव मात्‍त तान मन कठोर माळदुन, अदिक आंदुर केळीदील. ");
INSERT INTO hoy_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","बाक यहोवा मूसा से अंदुन, “हारून उक आग्‍या कोळ, ‘नी तान कोल वाळुसकु जमीन इन गागरा मा बडु, यदुर देल अद मिस्त्र द्‍याश तीम दा पिसोर्‍यागोळ बनसेगुल.’” ");
INSERT INTO hoy_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","मुंद आंदुर हांगा माळदुर; मतलब हारून कोल इक हुडुकु कय वाळुसकु जमीन इन गागरा मा बळदुन, आग मंळसा अदिक जनावरगोळ येढ्‍ढु मा पिसोर्‍यागोळ आगेदव, अदिक सप्‍पा मिस्त्र द्‍याश दा भुमी इन गागरा पिसोर्‍यागोळ बन्‍सेदव. ");
INSERT INTO hoy_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","आग जादूगरगोळ चाहासदुर कि तान तंत्र-मंत्रगोळ्द शक्‍ति देल नाव भी पिसोर्‍यागोळ तंदेव, लेकीन आंदुर सफल आग सकीदील. ई प्रकार मंळसागोळ अदिक जनावरगोळ येढ्‍ढु मा पिसोर्‍यागोळ बन्सकु ईत्‍तव. ");
INSERT INTO hoy_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","आग जादूगरगोळ फिरौन से अंदुर, “ईद रा परमेश्वर उन कय इन क्‍याल्‍सा हुन.” तरी भी यहोवा अन कहना अन अनुसार फिरौन उन मन कठोर आगतेला ईत्‍त, अदिक आव मूसा अदिक हारून उन मात मान्‍सीदील. ");
INSERT INTO hoy_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","बाक यहोवा मूसा से अंदुन, “व्हातऱ्या का येदकु फिरौन उन मुंद निदरेत, आव रा नील गांगा अन्द किनारा मा बंदान, अदिक आऊन से अनेत, ‘यहोवा नीन से ईद अनतान: नान प्रजा अन लॉकुरी होगगोळ कि आंदुर नान आराधना माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","अगर नी नान प्रजा अक होगगोळतीदील रा केळ, ना नीन मा अदिक नीन कर्मचारीगोळ अदिक नीन प्रजा मा, अदिक नीन मान्‍नगोळ दा झुण्‍ड इन झुण्‍ड नॉणगोळी कळाईन; अदिक मिस्त्रीगोळ मान्‍ना अदिक आंदुर ईरा जागा भी नॉणगोळ देल तुम्‍मेदीत. ");
INSERT INTO hoy_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","लेकीन आ दिशी ना गोशेन द्‍याश इक यदुर दा नान प्रजा ईरतद ब्‍यार्र माळाईन, अदिक अदुर दा नॉणगोळ्‍द झुण्‍ड ईरतीदील; यदुर देल नी जान्‍स कोम कि पृथ्‍वी इन न्याड्या दा ना अच यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","अदिक ना तान प्रजा अदिक नीन प्रजा दा अंतर पैदा माळाईन. ईद चिन्‍ह चमत्कार नाळ आदीत.’” ");
INSERT INTO hoy_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","अदिक यहोवा हांगा माळदुन, अदिक फिरौन उन भवन अदिक आऊन कर्मचारीगोळ्‍द मान्‍नगोळ दा, अदिक सप्‍पा मिस्त्र द्‍याश दा नॉणगोळ्‍द झुण्‍ड इन झुण्‍ड तुम्‍मेदव, अदिक नॉणगोळ मारा देल आ द्‍याश नष्‍ट आत. ");
INSERT INTO hoy_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","आग फिरौन मूसा अदिक हारून उक कारसुसकु अंदुन, “नीव होगकु तान परमेश्वर उन साटी ईदा द्‍याश दा बलिदान येरसी.” ");
INSERT INTO hoy_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","मूसा अंदुन, “हींग माळोद उचित हैलेच; यतिकी नाव तान परमेश्वर यहोवा अन साटी मिस्त्रीगोळ्द हिंग घृणित वस्‍तु बलिदान येरसेव; अदिक अगर नाव मिस्त्रीगोळ नोळ्‍त आंदुर्द घृणित वस्‍तु बलिदान येरसेव रा येन आंदुर नाम मा पथराव माळतीदील? ");
INSERT INTO hoy_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","नाव सुनसान आळी दा मुर दिन इन हादी मा होगकु तान परमेश्वर यहोवा अन साटी ह्यांग आव नाम से अंदान हांग अच अल नाव बलिदान येरसेव.” ");
INSERT INTO hoy_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फिरौन अंदुन, “ना नीमी आळी दा होगगोळाईन कि नीव तान परमेश्वर यहोवा अन साटी बलिदान येरसी; सिर्फ यक्कुल दुर होगबाळेतीर, अदिक नान साटी प्रार्थना माळी.” ");
INSERT INTO hoy_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","आग मूसा उत्तर कोट्टुन, “केळ, ना नीन हात्‍ती टु व्‍हार्या होगकु यहोवा से प्रार्थना माळाईन कि नॉणगोळ्द झुण्‍ड नीन, अदिक नीन कर्मचारीगोळ, अदिक प्रजा अन हात्‍ती टु नाळ अच दुर माळाईन; लेकीन फिरौन मुंद कपट माळकु नामी यहोवा अन्द साटी बलिदान माळली होगोर साटी मना माळबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","आग मूसा फिरौन उक बिट्ट बुट्टुन अदिक आऊन हात्‍ती टु व्‍हार्या होगकु यहोवा से प्रार्थना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","अदिक यहोवा मूसा अन अना हिसाब देल नॉणगोळ्‍द झुण्‍डगोळी फिरौन, अदिक आऊन कर्मचारीगोळ, अदिक आऊन प्रजा से दुर माळदुन; ईल ताका कि ऊंद भी नॉण मिक्‍कु ईतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","आग फिरौन ई घन भी तान मन इक कठोर माळदुन, अदिक आ लॉकुरी होग गोटीदील. ");
INSERT INTO hoy_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","बाक यहोवा मूसा से अंदुन, “फिरौन उन हात्ती होगकु अन, ‘इब्रीगोळ परमेश्वर यहोवा नीन से ईत्‍ता प्रकार देल अनतान: नान प्रजा अन लॉकुरी होगगोळ कि आंदुर नान आराधना माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","अदिक अगर नी आंदरी होगगोळाल अदिक ईग भी हुडुकु ईत्‍या, ");
INSERT INTO hoy_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","रा केळ, नीन जो घ्वाळागोळ, गदागोळ, ऊँटगोळ, गोसी-वस्ता, म्यांडा-मर्री ईव सप्‍पा मैदान दा आव, अऊर मा यहोवा अन कय हिंग कुरतीत कि हापाळ धोळ्‍द मरी बंदीत. ");
INSERT INTO hoy_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","लेकीन यहोवा इस्त्राएलीगोळ जनावरगोळ दा अदिक मिस्त्रीगोळ जनावरगोळ दा हींग अंतर पैदा माळ्‍यान कि जो पशु इस्‍त्राएलीगोळव हुव अऊर दा टु यातव भी सायतीदील.’” ");
INSERT INTO hoy_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","बाक यहोवा ईद अंदकु ऊंद समय निश्‍चित माळदुन, “ना ईद क्‍याल्‍सा ई द्‍याश दा नाळ माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","दुसरा दिशी यहोवा हींग अच माळदुन; अदिक मिस्त्रीगोळव रा सप्‍पा जनावरगोळ सोतोदव, लेकीन इस्त्राएलीगोळ्‍द ऊंद भी जनावर सोतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","अदिक फिरौन लॉकुरी कळुदुन, लेकीन इस्त्राएलीगोळ्‍द जनावरगोळ दा टु ऊंद भी ईला सोतीत. तरी भी फिरौन उन मन कठोर आगेत, अदिक आव आ लॉकुरी होग गोटीदील. ");
INSERT INTO hoy_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","बाक यहोवा मूसा अदिक हारून से अंदुन, “नीव येढ्‍ढु मुंदुर भट्‍टी दा टु ऊंद ऊंद मुट्‍ठी राखळ हुडु कोमी, अदिक मूसा अदरी फिरौन उन मुंद आकाश दी हार्सबुळ. ");
INSERT INTO hoy_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","आग अद श्‍याण्‍द गागरा आगकु सप्‍पा मिस्त्र द्‍याश दा मंळसागोळ अदिक जनावर येढ्‍ढु मा फफोलागोळ अदिक फॉळा बनसेदीत.” ");
INSERT INTO hoy_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","इदुरसाटी आंदुर भट्‍टी इन ठॉमा तीम राखळ हुडुकु फिरौन उन मुंद निदुरदुर, अदिक मूसा अदरी आकाश दी हार्स बुट्‍टुन, अदिक अद मंळसागोळ अदिक जनावरगोळ येढ्‍ढु मा फफोला अदिक फॉळा बनसेत. ");
INSERT INTO hoy_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","आ फॉळागोळ कारण जादूगरगोळ मूसा अन मुंद निदुरकु ईर सकीदील, यतिकी आ फॉळा ह्‍यांग मिस्त्रीगोळ्द ईरव हांग अच जादूगरगोळ्‍द भी होटीदव. ");
INSERT INTO hoy_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","लेकीन यहोवा फिरौन उन मन इक कठोर माळ बुट्‍टुन, अदिक ह्‍यांग यहोवा मूसा से अंदीदुन, आव आऊन केळीदील. ");
INSERT INTO hoy_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","बाक यहोवा मूसा से अंदुन, “व्‍हातर्‍या का येदकु फिरौन उन मुंद निदुर, अदिक आऊन से अन, ‘इब्रीगोळ परमेश्वर यहोवा ईत्‍ता प्रकार देल अनतान: नान प्रजा अन लॉकुरी होगगोळ कि आंदुर नान आराधना माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ईलारा ई घन ना नीन मा, अदिक नीन कर्मचारीगोळ अदिक नीन प्रजा मा हर प्रकार इन विपत्‍तीगोळ हाकाईन, यदुर देल नी जान्‍स कोम कि पुरा पृथ्‍वी मा नान तुल्‍य दुसरा याऊ हैलेच. ");
INSERT INTO hoy_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ना रा ईग कय वाळुसकु नीनी अदिक नीन प्रजा अक माहामारी देल कोन्‍नायदीन, अदिक पृथ्‍वी मा टु नीन सत्‍यानाश आगेगाईत; ");
INSERT INTO hoy_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","लेकीन खराखुरा ना नीनी ईदा उद्देश देल जीत्ता ईटीन कि नीनी तान सामर्थ्य तोरसाईन, अदिक तान हेसुर पुरा पृथ्‍वी मा प्रसिद्ध माळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","येन नीव ईग भी अहंकारी आईर अदिक नान लॉकुर इक होगगोळालीर? ");
INSERT INTO hoy_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","केळ, ना नाळ ईदा समय हींग भंयकर गारपीठ इन माळ बरसुसाईन, यऊर हिसाब देल मिस्त्र अन नीव बिळा दिशी टु रा ईगासताका यागलु बिदीदील. ");
INSERT INTO hoy_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","इदुरसाटी ईग लॉकुर इक कळुकु तान सप्पा जनावरगोळी अदिक नीन हात्ती खुला मैदान क्षेत्र दा आव सप्‍पा अक सुरक्षित जागा मा ओतकु ईटकु आगुल; ईला रा यास मंळसा या जनावर मैदान दा असुरक्षित ईत्‍ताव, अवरी मान्‍या जमा माळकु आगतीदील रा, अऊर मा गारपीठ बिद्‍दीत, अदिक अव सोतोदाव.’” ");
INSERT INTO hoy_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","इदुरसाटी फिरौन उन कर्मचारीगोळ दा टु जो लॉकुर यहोवा अन वचन इन अंज्‍क मान्‍सतोगोर आंदुर तान तान सेवकगोळ अदिक जनावरगोळी मान्‍या ओत कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","लेकीन यार यहोवा अन वचन मा मन हचीदील आंदुर तान सेवकगोळ अदिक जनावरगोळी मैदान दा ईर गोट्टुर. ");
INSERT INTO hoy_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","आग यहोवा मूसा से अंदुन, “तान कय आकाश दी वाळुस कि सप्पा मिस्त्र द्‍याश इन मंळसागोळ, जनावरगोळ, अदिक केई इन मार्रमठगोळ अदिक सप्‍पा उपज मा गारपीठ बिळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","आग मूसा तान कोल इक आकाश दी नेगदुन, अदिक यहोवा अन सामर्थ्‍य देल बिजली कळकुळसोद अदिक गारपीठ बिळली हतदव अदिक बेक्‍की पृथ्‍वी ताका बर कुर्त. ईत्‍ता प्रकार देल यहोवा मिस्त्र द्‍याश मा गारपीठ बरसुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","जो गारपीठ बिळतोगोद अऊर सांगुळ बेक्‍की भी मिसळुसकु ईरोद, अदिक अव गारपीठगोळ ईट भारी ईरव कि यागी टु मिस्त्र द्याश बसुस्कु ईरोद आगी टु मिस्त्र द्‍याश तिमुर दा हिंग गारपीठ यागलु बिळली ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","इदुरसाटी मिस्त्र द्‍याश तिमुर्द केईगोळ दा येन मंळसा, येन जनावर, यास ईरोर सप्‍पा गारपीठ देल सोतोदव, अदिक गारपीठ देल केई इन पुरा उपज बरबाद आगेत, अदिक मैदान इन सप्‍पा मार्रमठ भी मुर्दोदव. ");
INSERT INTO hoy_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","सिर्फ गोशेन प्रदेश दा यल इस्त्राएलीगोळ ईरतोगोर गारपीठ बिदीदील. ");
INSERT INTO hoy_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","आग फिरौन मूसा अदिक हारून उक बुलावा कळुदुन अदिक आंदुर से अंदुन, “ई घन ना पाप माळीन; यहोवा न्‍यायी आन, अदिक ना अदिक नान प्रजा अन्यायी आद. ");
INSERT INTO hoy_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","बिजली कळकुळसोद अदिक गारपीठ बिळोद रा हापाळ आगेत; ईग यहोवा से विनती माळी; आग ना नीम लॉकुरी होगगोळाईन, अदिक नीमी रोक्‍सकु आगतीदील.” ");
INSERT INTO hoy_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मूसा आऊन से अंदुन, “नगर दा टु होळ्‍त अच ना यहोवा दी कय फैलुसाईन, आग बादल इन गरजुसोद बंद आगेदीत अदिक गारपीठ भी यागलु बिळतीदील, इदुर देल नी जान्‍स कोंड्‍या कि पृथ्‍वी यहोवा अंद अच हुन. ");
INSERT INTO hoy_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","तरी भी ना जान्‍सतीन कि ना रा नी अदिक ना नीन कर्मचारीगोळ यहोवा परमेश्वर उन अंज्‍क मानसालुर.” ");
INSERT INTO hoy_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","सन अदिक जौ रा गारपीठ देल बरबाद आदव, यतिकी जौ इन लॉम्बागोळ होटबुटीदव अदिक सन दा कली अदिक फुल हतकु ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","लेकीन यातोदु गोदी बरबाद आगीदील, यतिकी अव बाद्दा हण्ण आगताव. ");
INSERT INTO hoy_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","याग मूसा फिरौन उन हात्ती टु नगर इन व्‍हार्या होटकु यहोवा दी कय फैलुस्कु प्रार्थना माळदुन, आग बादल इन गरजुसोद अदिक गारपीठ इन बिळोद बंद आत, अदिक बाक बाद्‍दा माळ धरती मा बिदीदील. ");
INSERT INTO hoy_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","लेकीन ईद नोळकु कि माळ अदिक गारपीठ अदिक बादलगोळ्‍द गरजुसोद बंद आगेत, फिरौन तान कर्मचारीगोळ सांगुळ मात्‍त तान मन इक कठोर माळकु पाप माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ईत्‍ता प्रकार देल फिरौन उन मन जिद्दी आगतेला ईत्‍त, अदिक आव इस्त्राएलीगोळी होग गोटीदील ह्‍यांग कि यहोवा मूसा अन द्वारा अनसुसीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","बाक यहोवा मूसा से अंदुन, “फिरौन उन हात्‍ती होग; यतिकी ना अच आऊन अदिक आऊन कर्मचारीगोळ्‍द मन इक इदुरसाटी कठोर माळ बुटीन कि तान चिन्ह चमत्कार आंदुर बीच दा तोरसाईन; ");
INSERT INTO hoy_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","अदिक नीव लॉकुर तान पारगोळ अदिक नातुगोळ से इदुर्द वर्णन माळी कि यहोवा मिस्त्रीगोळ्द ह्‍यांग मज्‍याक दा हार्सदीन अदिक आंदुर न्याड्या दा यास चमत्कार चिन्‍ह आंदुर बीच दा प्रगट माळदीन; यदुर देल नीव ईद जान्‍स कोंडीर कि ना अच यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","आग मूसा अदिक हारून फिरौन उन हात्‍ती होगकु अंदुर, “इब्रीगोळव परमेश्वर नीन से ईत्‍ता प्रकार देल अनतान: नी यागासताका नान मुंद गरीब आगदुर देल संकोच माळतेला ईत्‍या? नान प्रजा अन लॉकुरी होगगोळ कि आंदुर नान उपासना माळ्‍यार. ");
INSERT INTO hoy_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","अगर नी नान प्रजा अक होगगोळाल रा केळ, नाळ ना नीन द्‍याश दा फाफागोळ तराईन, ");
INSERT INTO hoy_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","अदिक अव धरती इक हिंग मुच्‍च बुट्‍टाव कि कांळ्‍सकु बिळतीदील; अदिक नीम जो येनारा ओद देल मिक्केत्याद अदरी अव साफ माळ बुट्‍टाव, अदिक नीम यास मार्रगोळ मैदान दा हतकु आव अवरी भी अव साफ माळ बुट्‍टाव, ");
INSERT INTO hoy_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","अदिक अव नींद अदिक नीन सप्‍पा कर्मचारीगोळ्‍द, ईलताका कि सप्‍पा मिस्त्रीगोळ मान्‍या तुम्‍मेदाव; ईस फाफागोळ नीन आप्‍प दादागोळ या आंदुरोर पुर्वजगोळ यागी टु धरती मा पैदा आग्‍यार आगी टु ईंद ताका यागलु नोळीदील.” आग आव तिर्गकु फिरौन उन हात्‍ती टु व्‍हार्या होटोदुन. ");
INSERT INTO hoy_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","आग फिरौन उन कर्मचारीगोळ आऊन से अनली हतदुर, “आव यागासताका नाम साटी फंदा बन्सकु ईत्‍तान? आ मंळसागोळी होगगोळ कि आंदुर तान परमेश्वर यहोवा अन उपासना माळुल. येन नी ईगासताका जान्साल कि पुरा मिस्त्र नष्‍ट आगेग्‍याद?” ");
INSERT INTO hoy_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","आग मूसा अदिक हारून फिरौन उन हात्‍ती मात्‍त कार्सुसकु आदुर, अदिक आव आंदुर से अंदुन, “होटोगी, तान परमेश्वर यहोवा अन उपासना माळी; लेकीन आंदुर जो होगावाळेर आर यार-यार उर?” ");
INSERT INTO hoy_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मूसा अंदुन, “नाव रा पार-पोरगोळ, म्यांडा-मर्रगोळ, वस्‍ता-गोसीगोळ समेत उलटा चिकोर टु रा हाळाबाट्‍टुर ताका सप्‍पा अन सप्‍पा होदेव, यतिकी नामी यहोवा अन साटी हाब्‍बा माळोद आद.” ");
INSERT INTO hoy_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","आव ईत्‍ता प्रकार देल आंदुर से अंदुन, “यहोवा नीम सांगुळ ईरूल अगर ना नीमी चिकोर समेत होगगोळतीन; नोळी, नीम मन दा बुराई आद. ");
INSERT INTO hoy_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ईला, हिंग आग सकतीदील; नीव मंळसा अच होगकु यहोवा अन उपासना माळी, नीव ईदा रा चाहासीर.” अदिक आंदुर फिरौन उन मुंदु टु तेग्‍सुसकु आदुर. ");
INSERT INTO hoy_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","आग यहोवा मूसा से अंदुन, “मिस्त्र द्‍याश इन म्‍याकुच तान कय वाळुस कि फाफागोळ मिस्त्र द्‍याश मा येरकु जमीन इन याटारा भी अनाज अदिक बाकी ओद देल मिक्‍कु आद सप्‍पा अक साफ माळ बुळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","इदुरसाटी: मूसा तान कोल मिस्त्र द्‍याश इन म्‍याकुच वाळुसदुन, आग यहोवा हागुल तीम अदिक ईळ्‍ल्‍क तीम द्‍याश तीम दा पूर्व अन हवा वाहुसदुन; अदिक याग व्‍हातुर आत आग आ हवा दा फाफागोळ बंदव. ");
INSERT INTO hoy_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","अदिक फाफागोळ येरकु मिस्त्र द्‍याश इन सप्‍पा जागागोळ दा बसेरा माळदव, अऊर्द झुण्‍ड हापाळ भारी ईरोद, उलटा न रा अऊर से पयले हींग फाफागोळ बंदीदव, अदिक न अऊर बाद्‍दा हींग फाफागोळ यागलु बंदाव. ");
INSERT INTO hoy_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","अव रा सप्‍पा धरती मा होच्‍चेदव, ईलताका कि द्‍याश दा अंधार आगेत; अदिक अदुर सप्‍पा अनाज अदिक बाकी अदिक मार्रगोळ्द सप्‍पा कायगोळ, मतलब, जो येनारा ओद देल मिक्‍कु ईरोद, सप्‍पा अक अव साफ माळ बुट्‍टव; ईलताका कि मिस्त्र द्‍याश तीम दा न रा यातारा मार्र मा येनारा हरयाली मिक्‍कु ईत्‍त अदिक न केईगोळ दा अनाज ईत्‍त. ");
INSERT INTO hoy_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","आग फिरौन तुरन्‍त मूसा अदिक हारून उक कार्सुसकु अंदुन, “ना रा नीम परमेश्वर यहोवा अन अदिक नीम भी अपराध माळीन. ");
INSERT INTO hoy_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","इदुरसाटी सिर्फ ई घन नान अपराध क्षमा माळी, अदिक तान परमेश्वर यहोवा से विनती माळी कि आव नान म्‍याकुच टु ई मृत्‍यु उक दुर माळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","आग मूसा फिरौन उन हात्‍ती टु होटकु यहोवा से विनती माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","आग यहोवा हापाळ प्रचंड पश्‍चिमी हवा वाहुसकु फाफागोळी ऊळुसकु क्याचाँद समुद्र दा हाक्‍क बुट्‍टुन, अदिक मिस्त्र अन यातोदु जागा दा ऊंद भी फाफा मिक्‍कु ईतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","तरी भी यहोवा फिरौन उन मन इक कठोर माळ बुट्‍टुन, यदुर देल आव इस्त्राएलीगोळी होग गोटीदील. ");
INSERT INTO hoy_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","बाक यहोवा मूसा से अंदुन, “तान कय आकाश दी वाळुस कि मिस्त्र द्‍याश इन म्‍याकुच अंधार आगेगुल, ईत्‍ता अंधार कि अद कय इक हतुल.” ");
INSERT INTO hoy_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","आग मूसा तान कय आकाश दी वाळुसदुन, अदिक पुरा मिस्त्र द्‍याश दा मुर दिन ताका कारकीट अंधार ईत्‍त. ");
INSERT INTO hoy_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","मुर दिन ताका न रा यारारा यारीकारा नोळदुर, अदिक न यावारा तान जागा मा टु येद्‍दुन; लेकीन सप्‍पा इस्त्राएलीगोळ मान्‍या ऊजुळ ईत्‍त. ");
INSERT INTO hoy_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","आग फिरौन मूसा अक कार्सुसकु अंदुन, “नीव लॉकुर होगी, यहोवा अन उपासना माळी; तान चिकोरी भी तान सांगुळ ओयी; सिर्फ तान म्यांडा-मर्रगोळ अदिक वस्त-वाळीगोळी बिटकु होगी.” ");
INSERT INTO hoy_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मूसा अंदुन, “नीनी नाम कय दा मेलबलि अदिक होमबली इन जनावरगोळ भी कोळव बिद्दाव, यवरी नाव तान परमेश्वर यहोवा अन साटी येर्सेव. ");
INSERT INTO hoy_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","इदुरसाटी नाम जनावरगोळ भी नाम सांगुळ होदाव, अऊर ऊंद खुर भी ईरतीदील, यतिकी अऊर दा टु ना नामी तान परमेश्वर यहोवा अन उपासना अन सामान ताकोमव बिद्दाव, अदिक नाव यागासताका अल पोचुसालेव आगासताका जान्‍सालेव कि येन येन हुडुकु यहोवा अन उपासना माळोद बिद्‍दीत.” ");
INSERT INTO hoy_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","लेकीन यहोवा फिरौन उन मन जिद्दी माळ बुट्‍टुन, यदुर देल आव आंदरी होग गोटीदील. ");
INSERT INTO hoy_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","आग फिरौन आऊन से अंदुन, “नान मुंदु टु होटोग; अदिक सचेत ईर; नानी तान मार्रा बाक तोर्सबाळेत; यतिकी याता दिशी नी नानी मार्रा तोरस्‍या अदा दिशी नी कोन्‍सुसकु आद्‍या.” ");
INSERT INTO hoy_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मूसा अंदुन, “नी बराबर अंद्‍या; ना नीन मार्रा बाक यागलु नोळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","बाक यहोवा मूसा से अंदुन, “मात्‍त ऊंद मुसीबत ना फिरौन अदिक मिस्त्र द्‍याश मा हाकतीन, अदुर बाद्‍दा आव नीम लॉकुरी अल टु होग गोट्‍टान; अदिक याग होग गोट्‍टान आग नीम सप्‍पा मुंदरी निश्‍चय तेग्‍द बुट्‍टान. ");
INSERT INTO hoy_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ईग नान प्रजा अक नान ईद आग्‍या केळ्स कि ऊंद ऊंद मंळसा अदिक ऊंद ऊंद आर्त तान तान मान्‍ना हातळोरवाळेर से, व्‍हान्‍ना-बेळ्ली इन ईसरावाळी बेळ कोमुल.” ");
INSERT INTO hoy_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","आग यहोवा मिस्त्रीगोळी तान प्रजा मा दयालु माळदुन. अदुर बाद्‍दा आव मंळसा मूसा, मिस्त्र द्‍याश दा फिरौन उन कर्मचारीगोळ अदिक साधारण लॉकुर नजर दा हापाळ महान ईरोन. ");
INSERT INTO hoy_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","बाक मूसा फिरौन से अंदुन, “यहोवा ईत्‍ता प्रकार देल अनतान: आर्धा ईळ्‍ल्‍क इन हात्‍तीपास ना मिस्त्र द्‍याश इन बीच दा आगतेला नळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","आग मिस्त्र दा सिंहासन मा कुरावाळा फिरौन टु हुडुकु चक्‍की पिसुसावळ्त दासगीती ताका अन पयला धोळ पारगोळ; उलटा जनावरगोळ ताका अन पयला पाड्डा सोतोदाव. ");
INSERT INTO hoy_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","अदिक सप्‍पा मिस्त्र द्‍याश दा धोळ्‍द हाहाकार मचुसेदीत, ईल ताका कि अदुर घाई न रा यागल्‍यारा आगीदील अदिक न यागलु आदीत. ");
INSERT INTO hoy_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","लेकीन इस्त्राएलीगोळ्‍द खिलाप, येन मंळसागोळ येन जनावरगोळ, यावारा मा यातोदु नाय भी बेगुळतीदील; यदुर देल नीव जान्‍स कोमी कि मिस्त्रीगोळ अदिक इस्‍त्राएलीगोळ दा ना यहोवा भेद माळतीन. ");
INSERT INTO hoy_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","आग नीनोर ई सप्‍पा कर्मचारीगोळ नान हात्‍ती बंदकु म्यांडा बांग्सकु नानी दण्डवत माळकु ईद अंदार, ‘तान सप्‍पा परिवार इन समेत होटबुळ.’ अदिक अदुर बाद्‍दा ना होटबुळाईन.” ईद अंदकु मूसा हापाळ सिट्‍ट दा फिरौन उन हात्‍ती टु होट बुट्‍टुन. ");
INSERT INTO hoy_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","यहोवा मूसा से अंद बुटीदुन, “फिरौन नीम मातगोळ केळतीदील; यतिकी नान इच्‍छा आद कि मिस्त्र द्‍याश दा हापाळ चमत्कार माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मूसा अदिक हारून फिरौन उन मुंद ई सप्‍पा चमत्कार माळदुर; लेकीन यहोवा फिरौन उन मन मात्‍त कठोर माळ बुट्‍टुन, इदुरसाटी आव इस्त्राएलीगोळी तान द्‍याश दा टु होग गोटीदील. ");
INSERT INTO hoy_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","बाक यहोवा मिस्त्र द्‍याश दा मूसा अदिक हारून से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ईद तिंगुळ नीम लॉकुर साटी सुरवात इन ठहरूसुल; मतलब साल इन पयला तिंगुळ ईदा ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इस्त्राएली इन सप्‍पा मंडली से ईत्‍ता प्रकार देल अनी; ईदा तिंगुळ इन दसवा दिशी इक नीव तान तान पुर्वजगोळ्‍द घरानागोळ्द अनुसार, घराना अन हींद ऊंद ऊंद पाड्डा कोंडकु ईटी; ");
INSERT INTO hoy_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","अदिक अगर यारदारा घराना दा ऊंद पाड्डा अन तिनोर साटी मंळसागोळ गोर्त ईतीदार, रा आव तान सब से हात्‍ती ईरावाळा मंळसा अन सांगुळ जनावरगोळ्‍द गिनती इन अनुसार ऊंद पाड्‍डा कोंडकु ईटुल; अदिक नीव हर ऊंद उन तिना हिसाब देल पाड्‍डगोळ्‍द हिसाब माळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","नीम पाड्डा निर्दोष अदिक ऊंद साल इन नर ईरूल, अदिक अदरी चाहे म्यांडागोळ दा टु कोमेत या चाहे मर्रगोळ दा टु. ");
INSERT INTO hoy_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","अदिक ई तिंगुळ इन चौदावा दिन ताका अदरी ईटकु ईरेत, अदिक आ दिशी द्‍यावमुळका अन होती इस्त्राएल इन सप्‍पा मंडली इन लॉकुर अदरी बलि येरसुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","आग आंदुर अदुर रक्‍ता दा टु येनारा हुडुकु याता मान्‍या पाड्‍डा तिंदार अऊर्द दरवाजा अन येढ्‍ढु बाजु दा अदिक चौखट इन म्‍याकुच हचुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","अदिक आंदुर आ मास इक अदा ईळ्‍ल्‍की बेक्‍की दा सुटकु अखमीरी रोट्‍टी अदिक केय सागपात इन सांगुळ तिनुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","अदरी ताल्‍ला, काल, अदिक अतळीगोळ समेत बेक्‍की दा सुटकु तिनेतीर, कच्‍चा या नीर दा येनारा भी बेईसकु तिनबाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","अदुर दा टु येनारा भी व्‍हातुर ताका ईटबाळेतीर, अदिक अगर येनारा व्‍हातुर ताका ईतोदीत भी, रा अदरी बेक्‍की दा होताक बुळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","अदिक अदुर तिनोद ईद विधी आद: नेळु कटकु, काल दा जुता हाक्‍कु, अदिक कय दा कोल हुडुकु अदरी फुरताई देल तिनेतीर; अद रा यहोवा अन हाब्ब ईत्‍तीत. ");
INSERT INTO hoy_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","यतिकी आ ईळ्‍ल्‍की ना मिस्त्र द्‍याश इन बीच दा टु आगतेला होगाईन, अदिक मिस्त्र द्‍याश इन येन मंळसागोळ येन जनावरगोळ, सप्‍पा अन पहिलौठागोळी कोन्‍नाईन; अदिक मिस्त्र अन सप्‍पा देवतागोळी भी ना दण्‍ड कोळाईन; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","अदिक याता मान्‍नगोळ दा नीव ईत्‍तीर अऊर मा आ रक्‍ता नीम साटी चिन्ह ठहरूसीत; मतलब ना आ रक्‍ता अक नोळकु नीमी बिटकु होगाईन, अदिक याग ना मिस्त्र द्‍याश इन लॉकुरी कोन्‍नाईन, आग अद विपत्‍ती नीम मा बिळतीदील अदिक नीम नाश आगतीदील ");
INSERT INTO hoy_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","अदिक अद दिन नीमी याद तोरसावाळा ठहरूसीत, अदिक नीव अदरी यहोवा अन साटी हाब्‍ब माळकु मान्‍सेतीर; अद दिन नीम पीढ़ीगोळ दा हमेशा अन विधी जान्‍सकु हाब्‍ब मान्‍सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","अदिक परमेश्वर अंदुन, “येळ दिन ताका अखमीरी रोट्‍टी तिनतोगेतीर, अऊर दा टु पयला अच दिशी तान तान मान्‍या दा टु खमीर हटुस बुळेतीर, उलटा जो यावारा पयला दिशी टु रा सातवा दिन ताका यातोदारा खमीर वस्तु तिनुल, आव जीव इस्त्राएलीगोळ दा टु नाश माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","पयला दिशी ऊंद पवित्र सभा, अदिक सातवा दिशी भी ऊंद पवित्र सभा माळेतीर; आ येढ्ढु दिनगोळ दा यातोदारा क्याल्सा माळकु आगबाळुल; सिर्फ याता जीव इन जो तिनोद आद आऊन क्याल्सा माळोद आग्या आद. ");
INSERT INTO hoy_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","इदुरसाटी नीव बिना खमीर इन रोट्टी इन हाब्‍ब मान्सेतीर, यतिकी अदा दिशी मान्सी ना नीमी दल दल माळकु मिस्त्र द्याश टु तेगदीन; ई कारण देल अद दिन नीम पीढ़ीगोळ दा हमेशा विधी मान्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पयला तिंगुळ इन चौदावा दिन इन द्यावमुळका टु रा एक्कीसवा दिन इन द्यावमुळका ताका नीव अखमीरी रोट्टी तिनतोगेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","येळ दिन ताका नीम मान्नगोळ दा थ्वाळासा भी खमीर मिक्‍कु ईरबाळुल, उलटा जो यावारा यातोदारा खमीर वस्तु उक तिनुल, चाहे आव देशी ईरूल या चाहे परदेशी, आव जीव इस्त्राएलीगोळ मंडली दा टु नाश माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","यातोदारा खमीर इन वस्तु तिनबाळेतीर; तान सप्पा मान्नगोळ दा बिना खमीर इन रोट्टी तिनतोगेतीर.” ");
INSERT INTO hoy_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","आग मूसा इस्त्राएल इन सप्पा पुरनिगोळी कारूकु अंदुन, “नीव तान तान कुल इन अनुसार ऊंद ऊंद पाड्डा ब्यार्र माळकु ईटी, अदिक फसह हाब्ब इन पाड्डा बलि माळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","अदिक एजोब मार्र इन ऊंद जळी हुडुकु अद पात्र दाकळोद रक्ता दा मुळकुळसेतीर अदिक अदुर देल अदुर दाकळोद रक्ता दरवाजा अन पट्टी इक अदिक येढ्ढु बाजु दा हचेतीर; अदिक व्हातुर ताका नीम दा टु याऊ मान्या टु व्हार्या होळबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","यतिकी यहोवा द्याश इन बीच दा आगकु मिस्त्रीगोळी कोनतेला होदान; इदुरसाटी यल यल अव चौखट इन क्वानागोळ, अदिक येढ्ढु बाजु मा आ रक्ता अक नोळ्यान, अल अल आव आ दरवाजा अक बिळतेला होदान, अदिक नाश माळावाळेरी नीम मान्नगोळ दा कोन्नोर साटी होगगोळतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","बाक नीव ई नियम इक तान अदिक तान वंश इन साटी हमेशा अन नियम जान्सकु मान्सतोगी. ");
INSERT INTO hoy_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","याग नीव आ द्याश दा यदरी यहोवा तान अना हिसाब देल नीमी प्रदान माळ्यान, आग ईद क्याल्सा माळतोगेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","अदिक याग नीम चिकोर नीमी केळ्यार, ‘ई नियम देल नीम्द येन मतलब आद?’ ");
INSERT INTO hoy_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","आग नीव आंदरी ईद उत्तर कोळेतीर, ‘यहोवा जो मिस्त्रीगोळी कोन्ना समय मिस्त्र दा ईरावाळेर नाव इस्त्राएलगोळ मान्नगोळी बिटकु नाम मान्नगोळी ऊळ्सदुन, ईदा कारण आऊन फसह हाब्ब इन ईद बलिदान माळकु आगतद.’ आग लॉकुर म्यांडा बांग्सकु दण्डवत माळकु आराधना माळदुर.” ");
INSERT INTO hoy_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","आग आ इस्त्राएलीगोळ होगकु, जो आग्या यहोवा मूसा अदिक हारून उक कोटीदुन, अदुर दा अनुसार माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","हींग आत कि आर्धा ईळ्लकी यहोवा मिस्त्र द्याश दा सिंहासन मा कुरावाळा फिरौन उन हात्ती टु रा जेल दा बिदकु कैदी ताका, सप्पा मुंदुर्द पहिलौठा अक, उलटा जनावरगोळ्द पहिलौठा अक कोंद बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","अदिक फिरौन ईळ्लकी का येदकु कुरतुन, अदिक आऊन सप्पा कर्मचारी, उलटा सप्पा मिस्त्रीगोळ यद्दुर; अदिक मिस्त्र द्याश दा हापाळ धोळ्द हाहाकार मचुसेत, यतिकी ऊंद भी हींग मान्ना ईला ईरोद यल याऊ सोतीदान ईला. ");
INSERT INTO hoy_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","आग फिरौन ईळ्लक इक मूसा अदिक हारून उक कारसुसकु अंदुन, “नीव इस्त्राएलीगोळ समेत नान प्रजा अन बीच दा टु होटबुळी; अदिक तान अना हिसाब देल होगकु यहोवा अन आराधना माळी. ह्यांग नीव अंदिदीर. ");
INSERT INTO hoy_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","तान अना हिसाब देल तान म्यांडा-मर्रगोळ अदिक वस्ता-गोसीगोळी सांगुळ ओयी; अदिक नानी आशीर्वाद कोटकु होगी.” ");
INSERT INTO hoy_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","मिस्त्री जो अनतोगोर, नाव रा सप्पा सोतोगेव, आंदुर इस्त्राएली लॉकुर मा दबाव हाकतेला अंदुर, “द्याश दा टु राटनेरी होटबुळी.” ");
INSERT INTO hoy_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","आग आंदुर तान काल्सद हीट्ट इक बिना खमीर कोळ्द अच कठौती समेत कपड़ागोळ दा कटकु तान तान खांदागोळ मा हाक्‍क बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इस्त्राएलीगोळ मूसा अन कहना अन अनुसार मिस्त्रीगोळ से व्हान्ना-बेळ्ली इन ईसरागोळ अदिक कपड़ागोळ बेळ कोंडुर; ");
INSERT INTO hoy_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","अदिक यहोवा मिस्त्री लॉकुरी तान प्रजा अन लॉकुर मा हींग दया माळदुन कि आंदुर जो जो बेळदुर अद सप्पा आंदरी सिक्त. ईत्ता प्रकार देल इस्त्राएली लॉकुर मिस्त्रीगोळी लुटुस कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","आग इस्त्राएली लॉकुर रामसेस टु कूच माळकु सुक्कोत नगर इक होदुर, अदिक चिकोर चिंणगेरी अदिक आर्तेर इक बिटकु आंदुर लगभग आर लाख पैदल नळावाळेर मंळसागोळ ईरोर. ");
INSERT INTO hoy_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","आंदुर सांगुळ हापाळ गैर-इस्राएली लॉकुर्द भीळ भी होत, अदिक म्यांडा, मर्रगोळ, वस्ता गोसीगोळ, हापाळ सा जनावर भी सांगुळ होदव. ");
INSERT INTO hoy_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","अदिक जो काल्सद हीट्ट आंदुर मिस्त्र टु सांगुळ ओतीदुर अदुर्द आंदुर बिना खमीर कोळ्द रोट्टीगोळ माळदुर; यतिकी आंदुर मिस्त्र दा टु हींग बरबस तेगुकु आदुर कि आंदरी मौका भी सिकीदील कि हादी मा तिनोर साटी येनारा हुडु कोंडेव, ईदा कारण अद काल्सद हीट्ट बिना खमीर इन ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","मिस्त्र दा ईरावाळेर इस्त्राएली लॉकुरी अल परदेशी ईतकु नाक सौ तीस साल आगेगीदव. ");
INSERT INTO hoy_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","अदिक आ नाक सौ तीस साल आगदुर मा, बराबर अदा दिशी, यहोवा अन पुरा सेना मिस्त्र द्याश दा टु होटबुळ्त. ");
INSERT INTO hoy_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","यहोवा इस्त्राएलीगोळी मिस्त्र द्याश दा टु तेगुकु तंदुन, ई कारण आ ईळ्लक आऊन निमित्त मानसोर साटी योग्य आद; ईद यहोवा अन अदा ईळ्लक हुन यदुर्द पीढ़ोन पीढ़ी दा मानसोद इस्त्राएली लॉकुर्द साटी जरूरी आद. ");
INSERT INTO hoy_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","बाक यहोवा मूसा अदिक हारून से अंदुन, “हाब्ब अन नियम ईद हुन: यावारा परदेशी अदुर दा टु तिनबाळुल; ");
INSERT INTO hoy_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","लेकीन जो यारदारा कोम्द दास आगीदान, अदिक नीव लॉकुर आऊन खतना माळीदीर, आव रा अदुर दा टु तिन सक्यान. ");
INSERT INTO hoy_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","लेकीन परदेशी अदिक क्याल्सा माळावाळेर अदुर दा टु तिनबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","आऊन तिनोद ऊंदा मान्या दा ईरूल; मतलब नीव आऊन मास दा टु येनु मान्या अन व्हार्या ओयबाळेतीर; अदिक पशुबलि उन यातोदारा भी येलु मुरूबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","हाब्‍ब अक मानसोद इस्त्राएल इन पुरा मंडली इन कर्तव्य आद. ");
INSERT INTO hoy_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","अदिक अगर यावारा परदेशी नीम लॉकुर सांगुळ ईतकु यहोवा अन साटी हाब्ब मानसोद चाहास्यान, रा आव तान अल इन सप्पा मंळसागोळ्द खतना माळसुसुल, आग आव हात्ती बंदकु अदरी मानसुल; अदिक आव देशी मंळसा अन घाई ठहरूस्यान. लेकीन यावारा खतना रहित मंळसा अदुर दा टु तीन ईला पायजे. ");
INSERT INTO hoy_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","आऊन व्यवस्था देशी अदिक नीम बीच दा ईरावाळेर परदेशी येढ्ढु मुंदुर साटी ऊंदा ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ईद आग्या जो यहोवा मूसा अदिक हारून उक कोट्टुन अदुर्द अनुसार सप्पा इस्त्राएली लॉकुर माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","अदिक बराबर अदा दिशी यहोवा इस्त्राएलीगोळी मिस्त्र द्याश दा टु दल बल माळकु तेगुकु ओतुन. ");
INSERT INTO hoy_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“येन मंळसा नव येन जनावरगोळव, इस्त्राएलीगोळ दा यास तान तान मोय इन पहिलौठा आर, आंदरी नान साटी पवित्र मानसेत; अद नांदा हुन.” ");
INSERT INTO hoy_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","बाक मूसा लॉकुर से अंदुन, “ई दिन इक याद ईटी, यदुर दा नीव लॉकुर दासत्व अन मान्या, मतलब मिस्त्र द्याश टु होटकु बंदीर; यहोवा नीमी अल टु तान कय इन ताकद देल तेगुकु तंदान; इदुर दा खमीरी रोट्टी तिनकु आगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आबीब इन तिंगुळ दा ईंद इन दिशी नीव होटीर. ");
INSERT INTO hoy_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","इदुरसाटी याग यहोवा नीमी कनानी, हित्ती, एमोरी, हिब्बी, अदिक यबूसी लॉकुर द्याश दा पोहचुस्यान, यदरी कोळोद किर्‍या आव नीम आप्प दादागोळ से तिंदीदुन, अदिक यदुर दा हाल अदिक शयद इन धारागोळ वाहुसताव, आग नीव ईदा तिंगुळ दा हाब्‍ब मानसेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","येळ दिन ताका अखमीरी रोट्टी तिनतोगेतीर, अदिक सातवा दिशी यहोवा अन साटी हाब्‍ब मानसेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ई येळु दिनगोळ दा अखमीरी रोट्टी तिनकु आगुल, उलटा नीम द्याश भर दा न खमीरी रोट्टी, न खमीर नीम हात्ती कांळ्सकु बिळुल. ");
INSERT INTO hoy_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","अदिक आ दिशी नीव तान तान पारगोळी ईद अंदकु समझुस बुळेतीर कि ईद नाव अदा क्याल्सा अन कारण माळतेव, जो यहोवा नाम मिस्त्र द्याश टु होटकु बरा होती नाम साटी माळीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","बाक ईद नीम साटी नीम कय दा ऊंद चिन्ह आदीत, अदिक नीम कण्णगोळ मुंद याद माळसुसावाळा वस्तु ठहरूसुल; यदुर दा यहोवा अन व्यवस्था नीम बाय मा ईरूल: यतिकी यहोवा नीमी तान ताकदवर कयगोळ देल मिस्त्र दा टु तेगदान. ");
INSERT INTO hoy_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ई कारण नीव ई विधी इक हर साल सही समय मा मान्सतोगेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“बाक याग यहोवा आ किर्‍या अन अनुसार, जो आव नीम आप्प दादागोळ से अदिक नीम से भी तिंदान, नीमी कनानीगोळ द्याश दा पोहचुस्कु अदरी नीमी कोट बुट्टान, ");
INSERT INTO hoy_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","आग नीम दा टु यास तान तान मोय इन पहिलौठा आईर आंदरी, अदिक नीम जनावरगोळ दा जो हींग ईतीदार अवरी भी यहोवा अन साटी अर्पण माळेतीर; सप्पा नर नारी रा यहोवा नोर अच हुव. ");
INSERT INTO hoy_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","अदिक गधा अन हर ऊंद पहिलौठा अन बदला पाड्डा कोटकु अदरी बिळसुस बुळेतीर, अदिक अगर नीव अदरी बिळसोद चाहासालीर रा अदुर्द कुतक्या मुरकुळ्स बुळेतीर. लेकीन तान सप्पा पहिलौठा पारगोळी बदला कोटकु बिळ्स कोमेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","अदिक मुंदळव दिनगोळ दा याग नीम पारगोळ नीम से केळुल, ‘ईद येन हुन?’ रा आंदुर से अनेतीर, ‘यहोवा नाम लॉकुरी दासत्व अन मान्या दा टु, मतलब मिस्त्र द्याश टु तान कयगोळ ताकद देल तेगुकु तंदान. ");
INSERT INTO hoy_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","आ समय याग फिरौन कठ्ठर आगकु नामी होगगोळोद चाहासीदील, आग यहोवा मिस्त्र द्याश दा मंळसागोळ हात्ती टु हुडुकु रा जनावरगोळ ताका सप्पा अन पहिलौठागोळी कोंद बुट्टुन. ईदा कारण जनावरगोळ दा टु यास तान-तान मोय इन पहिलौठा नर आव, अवरी नाव यहोवा अन साटी अर्पण माळतेव; लेकीन तान सप्पा पहिलौठा पारगोळी बदला कोटकु बिळ्स बुळतेव.’ ");
INSERT INTO hoy_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ईद नीम कयगोळ मा ऊंद चिन्ह घाई अदिक नीम भऊगोळ्द बीच टिका अन घाई ठहरूसुल; यतिकी यहोवा नाम लॉकुरी मिस्त्र दा टु तान कय इन ताकद देल तेगुकु तंदान.” ");
INSERT INTO hoy_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","याग फिरौन लॉकुरी होगोद आग्या कोट बुट्टुन, आग यतिकी पलिश्तीगोळ्द द्याश दा टु आगतेला जो हादी होगतद अद श्‍याण्‍द ईरोद; तरी भी परमेश्वर ईद विचार माळकु आंदरी आ हादी देल वोतीदील कि ईलारा हिंग आगबाळुल कि याग ई लॉकुर लळाई नोळुल आग पछतासकु मिस्त्र अक वापस बरूल. ");
INSERT INTO hoy_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","इदुरसाटी परमेश्वर आंदरी चक्कर तिन्सकु क्याचाँद समुद्र अन आळी इन हादी टु ओतुन. अदिक इस्त्राएलीगोळ पात कटकु मिस्त्र दा टु होट बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","अदिक मूसा यूसुफ उन येलुगोळी सांगुळ हुडुतेला होदुन; यतिकी यूसुफ इस्त्राएलीगोळ से ईद अंदकु, “परमेश्वर जरूर नीम्द सुधी ताकोंडान, आंदरी ई बारा अन धोळ्द किर्‍या तिन्सीदुन कि आंदुर आऊन येलुगोळी तान सांगुळ ईल टु ओतार.” ");
INSERT INTO hoy_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","बाक आंदुर सुक्कोत टु कूच माळकु आळी दी आप्पाटी एताम दा ड्यारा हाकदुर. ");
INSERT INTO hoy_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","अदिक यहोवा आंदरी हागुल इन होती हादी तोरसोर साटी बादल इन खम्भा दा, अदिक ईळ्लकी ऊजुळ कोळोर साटी बेक्‍की इन खम्भा दा आगकु आंदुर मुंद मुंद नळुतोगोन, यदुर देल आंदुर ईळ्लक अदिक हागुल नळु सकुल. ");
INSERT INTO hoy_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","आव ना रा बादल इन खम्भा अक हागुल इन होती अदिक ना बेक्‍की इन खम्भा अक ईळ्लकी लॉकुर मुंदु टु हटुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","आग यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्त्राएलीगोळी आग्या कोळ कि आंदुर वापस होगकु मिग्दोल अदिक समुद्र अन न्याड्या, पीहाहीरोत इन हात्ती, बालसपोन इन मुंद तान ड्यारा निदरूसुल, अदुर्दा मुंद समुद्र अन किनारा मा ड्यारागोळ निदरूसुल. ");
INSERT INTO hoy_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","आग फिरौन इस्त्राएलीगोळ बारा दा विचार माळ्यान, आंदुर द्याश इन उलझनगोळ दा फसुसकु आर अदिक आळी दा घिरूसेग्यार. ");
INSERT INTO hoy_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","आग ना फिरौन उन मन इक कट्टर माळ बुळाईन, अदिक आव आंदुर्द पीछा माळ्यान. आग फिरौन अदिक आऊन सप्पा सेना अन द्वारा नांद महिमा आदीत; अदिक मिस्त्री लॉकुर अर्त कोंडार कि ना यहोवा हुईन.” अदिक आंदुर हांगा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","याग मिस्त्र अन राजा अक ईद खबर सिक्त कि आ लॉकुर ओळेग्यार, आग फिरौन अदिक आऊन कर्मचारीगोळ्द मन आंदुर खिलाप पलटुसेत, अदिक आंदुर अनली हतदुर, “नाव ईद येन माळदेव कि इस्त्राएलीगोळी तान दासत्व दा टु छुटकारा कोटकु होग गोट्टेव?” ");
INSERT INTO hoy_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","आग आव तान रथ तयार माळदुन अदिक तान सेना अक सांगुळ हुळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","आव आर सौ वळ्लेव से वळ्लेव रथ उलटा मिस्त्र अन सप्पा रथ हुळदुन अदिक आ सप्पा रथगोळ मा सरदारगोळी कुर्सदुन. ");
INSERT INTO hoy_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","अदिक यहोवा मिस्त्र अन राजा फिरौन उन मन इक कट्टर माळ बुट्टुन. इदुरसाटी आव इस्त्राएली लॉकुर्द पीछा माळदुन; लेकीन इस्त्राएली बिना रूक्सद होटकु होगतोगोर. ");
INSERT INTO hoy_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","लेकीन फिरौन उन सप्पा घ्वाळागोळ, अदिक रथगोळ, अदिक अऊर मा सवारगोळ समेत मिस्त्री सेना आंदुर पीछा माळकु आंदुर हात्ती, जो पीहाहीरोत इन हात्ती, बालसपोन इन मुंद, समुद्र अन किनारा मा ड्यारा हाक्‍कु ईरोर, पोहचुसदुर. ");
INSERT INTO hoy_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","याग फिरौन हात्ती बंदुन, आग इस्त्राएली लॉकुर कण्ण नेगुकु येन नोळदुर कि मिस्त्री नाम पीछा माळतेला बरेत्यार; अदिक इस्त्राएलीगोळ हापाळ अंजेदुर, अदिक किटुरकु यहोवा अन दोहाई कोळ कुरतुर; ");
INSERT INTO hoy_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","अदिक आंदुर मूसा से अनली हतदुर, “येन मिस्त्र दा कब्रगोळ ईला ईरव जो नी नामी अल टु सायोर साटी आळी दा तंदकु भिट्ट? नी नाम से ईद येन माळ्द कि नामी मिस्त्र टु तेगुकु तंद? ");
INSERT INTO hoy_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","येन नाव नीन से मिस्त्र दा का ईदा मात अनतेला ईतीदील कि नामी ईरगोळ कि नाव मिस्त्रीगोळ्द स्यावा माळेव? नाम साटी आळी दा सायदुर अलावा मिस्त्रीगोळ्द स्यावा माळोद वळ्लीद ईरोद.” ");
INSERT INTO hoy_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मूसा लॉकुर से अंदुन, “अंजबाळी, निदुर निदुरकु अद उद्धार इन क्याल्सा नोळी, जो यहोवा ईंद नीम साटी माळ्यान; यतिकी याता मिस्त्रीगोळी नीव ईंद नोळतीर, आंदरी बाक यागलु नोळतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","यहोवा खुद अच नीम साटी लळाई माळ्यान, इदुरसाटी नीव सुंगामुंगा ईरी.” ");
INSERT INTO hoy_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","आग यहोवा मूसा से अंदुन, “नी येती नान दोहाई कोळेत्या? इस्त्राएलीगोळी आग्या कोळ कि आंदुर ईल टु कूच माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","अदिक नी तान कोल नेगुकु तान कय समुद्र अन म्याकुच वाळुस, अद येढ्ढ भाग आगेदीत; आग इस्त्राएली समुद्र अन न्याड्या दा टु आगतेला वळ्गींद जागा मा होटोदार. ");
INSERT INTO hoy_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","अदिक केळ, ना खुद मिस्त्रीगोळ्द मनगोळी कट्टर माळतीन, अदिक आंदुर अल भी आंदुर्द पीछा माळ्यार. आग फिरौन अदिक आऊन सप्पा सेना, अदिक रथगोळ अदिक सवारगोळ्द विनाश इन द्वारा नांद महिमा आदीत. ");
INSERT INTO hoy_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","अदिक याग फिरौन, अदिक आऊन रथगोळ, अदिक घुळसवारगोळ मा विजय द्वारा नांद महिमा आदीत, आग मिस्त्री लॉकुर अर्त कोंडार कि ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","आग परमेश्वर उन दूत जो इस्त्राएली सेना अन मुंद मुंद नळुतोगोन होगकु आंदुर हींद आगेदुन; अदिक बादल इन खम्भा आंदुर मुंदु टु हटुसकु आंदुर हींद निदुरकु ईत्त. ");
INSERT INTO hoy_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ईत्ता प्रकार देल आव मिस्त्रीगोळ्द सेना अदिक इस्त्राएलीगोळ्द सेना अन न्याड्या दा होटबंदुन; बादल अदिक अंधार रा ईरोद, तरी भी ईळ्लक इन होती आंदरी ऊजुळ सिकतेला ईत्त; अदिक आंदुर ईळ्लक तीम आबुर दाबुर हात्ती बंदिदील. ");
INSERT INTO hoy_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","आग मूसा तान कय समुद्र अन म्याकुच वाळुसदुन; अदिक यहोवा ईळ्लक तीम प्रचड पूरवी हवा नळ्सदुन, अदिक समुद्र अक येढ्ढ भाग माळकु नीर हिंग हटुस बुट्टुन, यदुर देल अदुर न्याड्या समुद्र अन्द नीर येढ्ढ भाग आगेत अदिक वळ्गींद जागा आगेत. ");
INSERT INTO hoy_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","आग इस्त्राएली लॉकुर समुद्र अन न्याड्या वळ्गींद जागा मा टु आगतेला नळदुर, अदिक नीर आंदुर्द डाक्या अदिक ऊजवा कय दी दीवार इन क्याल्सा माळतोगोद. ");
INSERT INTO hoy_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","आग मिस्त्री, मतलब फिरौन उन सप्पा घ्वाळागोळ, रथ अदिक सवारगोळ आंदुर पीछा माळतेला समुद्र अन न्याड्या दा टु होटोदुर. ");
INSERT INTO hoy_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","अदिक ईळ्लक इन आखरी पहर दा यहोवा बादल अदिक बेक्‍की इन खम्भा दा टु मिस्त्रीगोळ सेना मा दृष्टी माळकु आंदरी घबरूस बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","अदिक आव आंदुर्द रथगोळ्द चक्कागोळी तेग्द बुट्टुन, यदुर देल आंदुर रथ नळसोद कठिन आगेत. आग मिस्त्री आपस दा अनली हतदुर, “बरी, नाव इस्त्राएलीगोळ मुंदु टु ओळाता; यतिकी यहोवा आंदुर दी टु मिस्त्रीगोळ खिलाप लळाई माळेत्यान.” ");
INSERT INTO hoy_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","बाक यहोवा मूसा से अंदुन, “तान कय समुद्र अन म्याकुच वाळुस कि नीर मिस्त्रीगोळ, अदिक आंदुर रथगोळ, अदिक सवारगोळ मा मात्त वाहुसुल.” ");
INSERT INTO hoy_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","आग मूसा तान कय समुद्र अन म्याकुच वाळुसदुन, अदिक व्हातुर आग्त आग्त येन आत कि समुद्र मात्त ह्यांग इन हांगा आगेत; अदिक मिस्त्री उलटा ओळली हतदुर, लेकीन यहोवा आंदरी समुद्र अन न्याड्या दा अच वाहुस बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","अदिक नीर इन पलटुसदुर देल, यास रथ अदिक घुळसवारगोळ इस्त्राएलीगोळ हींद समुद्र दा बंदीदुर, आंदुर सप्पा उलटा फिरौन उन सप्पा सेना अदुर दा मुळकेत, अदिक आंदुर दा टु ऊंद भी ऊळदीदील. ");
INSERT INTO hoy_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","लेकीन इस्त्राएलीगोळ समुद्र अन न्याड्या वळ्गींद जागा मा टु आगतेला होटोदुर, अदिक नीर आंदुर्द डाक्या अदिक ऊजवा येढ्ढु दी दीवार बनस्कु नीदुरकु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ईत्ता प्रकार देल यहोवा आ दिशी इस्त्राएलीगोळी मिस्त्रीगोळ्द वश दा टु बिळ्सदुन; अदिक इस्त्राएलीगोळ मिस्त्रीगोळी समुद्र अन किनारा मा सोतकु नोळदुर ");
INSERT INTO hoy_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","अदिक यहोवा मिस्त्रीगोळ मा जो तान पराक्रम तोर्सुसीदुन, अदरी नोळकु इस्त्राएलीगोळ यहोवा अन अंज्क मान्सदुर अदिक यहोवा मा अदिक आऊन दास मूसा मा विश्वास माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","आग मूसा अदिक इस्त्राएलीगोळ यहोवा अन साटी ईद हाळ हाळदुर. आंदुर अंदुर, ना यहोवा अन हाळ हाळाईन, यतिकी आव महाप्रतापी ठहरूस्यान; आव घ्वाळागोळ सांगुळ घुळसवारगोळी समुद्र दा वाहुस बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","यहोवा नान बल अदिक भजन इन विषय हुन, अदिक आवा नान उद्धार भी ठहरूस्यान; नान परमेश्वर आवा हुन, ना आऊंदा स्तुति माळाईन, ना आऊन साटी निवासस्थान माळाईन, नान पुर्वजगोळ्द परमेश्वर आवा हुन, ना आऊन सराहना माळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","यहोवा योद्धा आन; आऊन हेसुर प्रभु आद. ");
INSERT INTO hoy_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","आव फिरौन उन रथगोळ अदिक सेनागोळी आव समुद्र दा भिट बुट्टुन; अदिक आऊन वळ्लेव से वळ्लेव रथगोळ क्याचाँद समुद्र दा मुळकेदव. ");
INSERT INTO hoy_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गयरा नीर आंदरी मुचबुळ्त; आंदुर कल्ल घाई गयरा जागागोळ दा मुळकेदुर. ");
INSERT INTO hoy_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे यहोवा, नीन ऊजवा कय शक्ति दा महाप्रतापी आत; हे यहोवा, नीन ऊजवा कय दुश्मन उक केचकांदा माळ बुळतद. ");
INSERT INTO hoy_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","नी तान विरोधीगोळी तान महाप्रताप से केळ्द बुळत्या; नी तान क्रोध भळकुसत्या, अदिक आंदुर भूसा अन घाई भस्म आगेगतार; ");
INSERT INTO hoy_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","नीन मुग्ग इन श्वास देल नीर ऊंदाओजी आगेत, धारागोळ ढेर इन घाई रूक्सदव; समुद्र अन बीच दा गयरा नीर जम्सेत. ");
INSERT INTO hoy_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","दुश्मन अंदिदुन, “ना पीछा माळाईन, ना होगकु हुडाईन, ना लुट इन माल इक वाट्स कोमाईन, अऊर देल नान जीव तुम्मेदीत. ना तान तलवार जेडुतेला अच तान कय देल आंदरी नष्ट माळ बुळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","नी तान श्वास इन पवन नळ्सद, आग समुद्र आंदरी मुचबुळ्त; आंदुर भयानक नीर दा काच इन घाई मुळकेदुर. ");
INSERT INTO hoy_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे यहोवा, देवतागोळ दा नीन तुल्य यार आर? नी रा पवित्रता अन कारण महाप्रतापी, अदिक तान स्तुति माळावाळेर्द अंज्क इन योग्य, अदिक आश्चर्यकर्म इन कर्ता हुय. ");
INSERT INTO hoy_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","नी तान ऊजवा कय वाळुस्द, अदिक धरती दुश्मनगोळ इक नुंगबुटाद. ");
INSERT INTO hoy_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","तान करूणा देल नी तान बिळ्सद प्रजा अन अगुवाई माळ्या, तान ताकद देल नी अदरी तान पवित्र निवासस्थान इक ओयेत्या. ");
INSERT INTO hoy_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","द्याश द्याश इन लॉकुर केळकु नळग्यार; पलिश्तीगोळ्द जीवा अन हाल बेहाल आगेदव. ");
INSERT INTO hoy_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोम उन अधिपति व्याकुल आदार; मोआब उन पयलवान नळ्गतेला यद्दार; सप्पा कनान दा ईरावाळेर्द मन पिघलुसेदाव. ");
INSERT INTO hoy_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","आंदुर दा अंज्क अदिक घबराहट तुम्मेदीत; नीन खांदागोळ प्रताप देल आंदुर कल्ल इन घाई निर्जीव आगेदार. यागासताका, हे यहोवा, नीन प्रजा अन लॉकुर होटबुळालुर, यागासताका नीन प्रजा अन लॉकुर यारी नी कोंड्या आप्पाटी होटबुळालुर. ");
INSERT INTO hoy_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","नी आंदरी पोहचुस्कु तान खुद इन भागवाळा पहाळी मा बसुस्या, ईद अदा जागा हुन, हे यहोवा, यदरी नी तान निवास इन साटी बनुस्या, अदिक अदा पवित्रस्थान हुन यदरी, हे प्रभु, नी खुद अच स्थिर माळ्या. ");
INSERT INTO hoy_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","यहोवा हमेशा हमेशा राज्य माळ्त ईत्‍तान. ");
INSERT INTO hoy_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ईद हाळ हाळोद कारण ईद आद, कि फिरौन उन घ्वाळागोळ, रथगोळ अदिक सवारगोळ समेत समुद्र अन न्याड्या दा होटोदुर, अदिक यहोवा आंदुर म्याकुच समुद्र अन नीर वाहुसदुन; लेकीन इस्त्राएलीगोळ समुद्र अन न्याड्या वळ्गींद जागा मा टु आगतेला होटोदुर. ");
INSERT INTO hoy_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","आग हारून उन आकतींग मरियम हेसुर नबिया कय दा टापटी हुळदुर; अदिक सप्पा आर्तेर टापटी हुडुकु कुणुतेला आकिन हींद आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","अदिक मरियम आंदुर सांगुळ ईद हाळ हाळ्त होदुर: “यहोवा अन हाळ हाळी, यतिकी आव महाप्रतापी ठहरूस्यान; घ्वाळागोळ समेत सवारगोळी आव समुद्र दा भिट बुटान.” ");
INSERT INTO hoy_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","आग मूसा इस्त्राएली लॉकुरी क्याचाँद समुद्र अन मुंद ओतुन, अदिक आंदुर शूर हेसुर इन आळी दा बंदुर; अदिक आळी दा होगतेला मुर दिन ताका नीर इन सोता सिकीदिल. ");
INSERT INTO hoy_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","बाक मारा हेसुर इन ऊंद जागा मा पोहचुसदुर, अलेव नीर खर्ट ईरोव, अदरी आंदुर कुडु सकीदील; ई कारण आ जागा अन हेसुर मारा बित्त. ");
INSERT INTO hoy_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","आग आंदुर ईद अंदकु मूसा अन विरोध दा बकबक माळली हतदुर, “नाव येन कुळदेव?” ");
INSERT INTO hoy_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","आग मूसा यहोवा अन दोहाई कोट्टुन, अदिक यहोवा आऊक ऊंद मार्र हेळ बुट्टुन, यदरी याग आव नीर दा हाकदुन, आग अद नीर सय आगेत. अल्या यहोवा आंदुर साटी ऊंद विधि अदिक नियम माळदुन, अदिक अल्या आव ईद अंदकु आंदुर्द परीक्षा माळदुन, ");
INSERT INTO hoy_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“अगर नी तान परमेश्वर यहोवा अन वचन तन मन देल केळ्या, अदिक आऊन आग्यागोळ मा कीव हच्या, अदिक आऊन सप्पा विधिगोळी मानस्या, रा यास रोग ना मिस्त्रीगोळ मा कळीन अऊर दा टु ऊंद भी नीन मा कळुतीदील; यतिकी ना नीमव चंगा माळावाळा यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","आग आंदुर एलीम इक बंदुर, यल नीर इनव हन्नेळ सोतागोळ अदिक सत्तर खजूर इन मार्रगोळ ईरव; अदिक अल आंदुर नीर इन हात्ती ड्यारागोळ नीदरूसदुर. ");
INSERT INTO hoy_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","बाक एलीम टु कूच माळकु इस्त्राएलीगोळ्द सप्पा मंडली, मिस्त्र द्याश दा टु होळदुर बाद्दा दुसरा तिंगुळ इन पंद्रावा दिशी, सीन हेसुर इन आळी दा, जो एलीम अदिक सीनै पहाळी इन बीच दा आद, पोहचुस्त. ");
INSERT INTO hoy_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","आळी दा इस्त्राएलीगोळ्द सप्पा मंडली मूसा अदिक हारून उन विरोध दा बळबळ माळली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","अदिक इस्त्राएली आंदुर से अनली हतदुर, “याग नाव मिस्त्र द्याश दा मास इन गळग्यागोळ हात्ती कुर्तकु मनमानी ऊमतोगेव, आग अगर नाव यहोवा अन कय देल कोन्सुसकु भी आगायदेव रा वळ्लीद अदा ईरोद; लेकीन नीव नामी ई आळी दा इदुरसाटी तेगुकु तंदीर कि ई सप्पा समाज इक उपासा कोंद बुळी.” ");
INSERT INTO hoy_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","आग यहोवा मूसा से अंदुन, “नोळी, ना नीम लॉकुर साटी आकाश टु तिनोद वस्तु बरसुसाईन; अदिक ई लॉकुर हर दिशी व्हार्या होगकु हर दिन इन तिनोद जमा माळ्यार, इदुर देल ना आंदुर्द परीक्षा माळाईन कि ईंदुर नान व्यवस्था मा नळदार या ईला. ");
INSERT INTO hoy_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","अदिक हिंग आदीत कि सहावा दिशी अद तिनोद दुगना आदीत, इदुरसाटी जो येनारा आंदुर आ दिशी जमा माळ्यार अदरी तयार माळकु ईटुल.” ");
INSERT INTO hoy_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","इदुरसाटी मूसा अदिक हारून सप्पा इस्त्राएलीगोळ से अंदुर, “द्यावमुळका अक नीव जान्स कोंडीर कि जो नीमी मिस्त्र द्याश दा टु तेगुकु तंदान आव यहोवा हुन, ");
INSERT INTO hoy_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","अदिक हुंजकुका नीमी यहोवा अन तेज कांळ्सकु बिद्दीत, यतिकी नीव जो यहोवा अन बारा दा कुळकुळ माळतीर अदरी आव केळतान. अदिक नाव येन हुयेव जो नीव नाम मा कुळकुळ माळतीर?” ");
INSERT INTO hoy_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","बाक मूसा अंदुन, “ईद आग आदीत याग यहोवा द्यावमुळका अक नीमी तिनोर साटी मास अदिक हुंजकुका व्हाट्टतीम रोट्टी कोट्टान; यतिकी नीव जो आऊन मा कुळकुळ माळतीर अदरी आव केळतान. अदिक नाव येन हुयेव? नीम कुळकुळ माळोद नाम मा ईला यहोवा मा अच आगतद.” ");
INSERT INTO hoy_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","बाक मूसा हारून से अंदुन, “इस्त्राएलीगोळ्द सप्पा मंडली इक आग्या कोळ कि यहोवा अन मुंद उलटा आऊन हात्ती बरूल, यतिकी आव आंदुर्द कुळकुळ माळोद केळ्यान.” ");
INSERT INTO hoy_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","अदिक हिंग आत कि याग हारून इस्त्राएलीगोळ्द सप्पा मंडली से हिंग मातगोळ माताळोन कि अचानक आंदुर आळी दी कण्णगोळ नेगुकु नोळदुर, अदिक आंदरी यहोवा अन तेज बादल दा कांळ्सली कुर्त. ");
INSERT INTO hoy_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","आग यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“इस्त्राएलीगोळ्द कुळकुळ माळोद ना केळीन; आंदुर से अंदकोम कि येढ्ढ द्यावमुळका अन होती नीव मास तिंदीर अदिक हुंजकुका नीव रोट्टी देल तृप्त आगेदीर; अदिक नीव ईद जान्स कोंडीर कि ना नीम परमेश्वर यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","आग हिंग आत कि द्यावमुळका लावागोळ बंदकु सप्पा छावनी मा कुर्तोदव; अदिक हुंजकुका छावनी इन नाकु दी ओद बित्त. ");
INSERT INTO hoy_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","अदिक याग ओद वंळ्गेत रा येन नोळतार कि आळी इन जागा मा श्याण श्याण कचरा पाला अन तुकळा अन घाई कांळ्सदव. ");
INSERT INTO hoy_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ईद नोळकु इस्त्राएलीगोळ, जो ईला जानसोर कि ईद येन वस्तु हुन, आंदुर आपस दा अनली हतदुर ईद रा मन्ना हुन. आग मूसा आंदुर से अंदुन, “ईद अदा तिनोद वस्तु हुन यदरी यहोवा नीमी तिनली कोळतान. ");
INSERT INTO hoy_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","जो आग्या यहोवा कोटान अद ईद हुन: नीव अदुर दा टु तान जरवत इन हिसाब देल तिनोर साटी जमा माळतोगेतीर, मतलब तान तान जीवागोळ्द गिनती इन अनुसार, हर मंळसा अन हींद ऊंद ऊंद ओमेर जमा माळेतीर; यार ड्यारा दा यास आर आव आंदुर्दा साटी जमा माळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","अदिक इस्त्राएलीगोळ हांगा माळदुर; अदिक यारारा यक्कुल अदिक यारारा थ्वाळासा जमा माळ कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","याग आंदुर अदरी ओमेर देल आळदुर, आग यार हात्ती यक्कुल ईरोद आऊन येनु मिक्‍कु ईतीदील, अदिक यार हात्ती थ्वाळासा ईरोद आऊक येनु गोर्त होगीदील; यतिकी ऊंद ऊंद मंळसा तान तिना लायक अच जमा माळीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","बाक मूसा आंदुर से अंदुन, “यावारा ईदुर दा टु येनारा व्हातुर ताका मिक्सकु ईटबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","लेकीन भी आंदुर मूसा अन मात मान्सीदील; इदुरसाटी याग यारारा यारारा अदुर दा टु येनारा व्हातुर ताका मिक्सकु ईटदुर, रा अदुर दा किळा हत्तेदव अदिक अद नारली कुर्त; आग मूसा आंदुर मा सिट्टी बंदुन. ");
INSERT INTO hoy_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","आंदुर हुंजकुका हर दिशी तान जरवत इन हिसाब देल तिनोर साटी जमा माळबुळतोगोर, अदिक याग बिसुल कळक आगतोगोद, आग अद गलुसेगोद. ");
INSERT INTO hoy_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","बाक हिंग आत कि सहावा दिशी आंदुर दुगना, मतलब हर मंळसा अन हींद येढ्ढ येढ्ढ ओमेर जमा माळ बुट्टुर, अदिक मंडली इन सप्पा प्रधानगोळ बंदकु मूसा अक हेळ बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","आव आंदुर से अंदुन, “ईद अदा मात हुन जो यहोवा माताळ्यान, यतिकी नाळ परविश्राम, मतलब यहोवा अन साटी पवित्र विश्राम आदीत, इदुरसाटी नीमी जो तन्दुर दा कासोद आद अदरी कासी, अदिक जो बेईसोद आद अदरी बेईसी, अदिक ईदुर दा टु यास मिक्क्याव अदरी व्हातुर साटी ईटकु बिटबुळी.” ");
INSERT INTO hoy_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","याग आंदुर अदरी मूसा अन ई आग्या अन अनुसार व्हातुर ताका ईटकु बिटबुट्टुर, आग अद ना रा नार्त, अदिक ना अदुर दा किळा हतदव. ");
INSERT INTO hoy_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","आग मूसा अंदुन, “ईंद अदरी का तिनी, यतिकी ईंद यहोवा अन विश्राम दिन आद; इदुरसाटी ईंद अद नीमी मैदान दा सिकतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","आर दिन रा नीव अदरी जमा माळीर; लेकीन सातवा दिन विश्राम इन दिन हुन, आ दिशी अद सिकतीदील.” ");
INSERT INTO hoy_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","तरी भी लॉकुर दा टु यारारा यारारा सातवा दिशी भी जमा माळोर साटी व्हार्या होदुर, लेकीन आंदरी येनु सिकीदील. ");
INSERT INTO hoy_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","आग यहोवा मूसा से अंदुन, “नीव लॉकुर नान आग्यागोळ अदिक व्यवस्था अक यागासताका मान्सतीदील? ");
INSERT INTO hoy_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","नोळी, यहोवा जो नीमी विश्राम इन दिन कोटान, ईदा कारण आव सहावा दिशी नीमी येढ्ढ दिन इन तिनोद कोळतान; इदुरसाटी नीव तान तान अल कुर्तकु ईरेतीर, सातवा दिशी याऊ तान जागा मा टु व्हार्या होगबाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","इदुरसाटी लॉकुर सातवा दिशी विश्राम माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्त्राएल इन घराना आ वस्तु उन हेसुर मन्ना ईटदुर; अदिक अद धनिया अन घाई बिळीद ईरोद, अदिक अदुर स्वाद सयद इन माळ्द बट्टी इन घाई का ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","बाक मूसा अंदुन, “यहोवा जो आग्या कोटान अद ईद हुन कि मन्ना दा टु ओमेर तुमकु तान वंश इन पिढ़ी पिढ़ी इन साटी ईटबुळी, यदुर देल आंदुर जान्सुल कि यहोवा नामी मिस्त्र द्याश टु तेगकु आळी दा ह्यांग रोट्टी तिन्सतोगोन.” ");
INSERT INTO hoy_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","आग मूसा हारून से अंदुन, “ऊंद घागरी हुडुकु अदुर दा ओमेर तुमकु अदरी यहोवा अन मुंद ईटबुळ कि अद नीम पिढ़ी इन साटी ईटकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ह्यांग आग्या यहोवा मूसा अक कोटीदुन, अदुर्दा हिसाब देल हारून अदरी साक्षी इन सन्दुक इन मुंद ईट बुट्टुन कि अद अल्या ईटकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्त्राएली लॉकुर यागासताका बसुस्द द्याश दा पोहचुसिदील आगासताका, मतलब चालीस साल ताका मन्ना तिनतेला ईत्तुर; आंदुर यागासताका कनान द्याश इन सीमा मा पोहचुसीदील आगासताका मन्ना तिनतेला ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ऊंद ओमेर रा एपा अन दसवा हिस्सा हुन. ");
INSERT INTO hoy_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","बाक इस्त्राएलीगोळ्द सप्पा मंडली सीन हेसुर इन आळी दा टु होळ्त, अदिक यहोवा अन आग्या अन अनुसार कूच माळकु रपीदीम दा तान ड्यारागोळ हाकदुर; अदिक अल आ लॉकुरी कुडव नीर सिकीदील. ");
INSERT INTO hoy_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","इदुरसाटी आंदुर मूसा से वाद विवाद माळकु अनली हतदुर, “नामी कुडव नीर कोळ.” मूसा आंदुर से अंदुन, “नीव येती नान से वाद विवाद माळतीर? अदिक यहोवा अन परीक्षा येती माळतीर?” ");
INSERT INTO hoy_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","बाक अल लॉकुरी निरळ्क हत्त, आग आंदुर ईद अंदकु मूसा मा कुळकुळ माळली हतदुर, “नी नामी चिकोर-चिणगेर अदिक जनावरगोळ समेत निरळ्क देल कोन्नोर साटी मिस्त्र दा टु येती तनकोंड्या?” ");
INSERT INTO hoy_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","आग मूसा यहोवा अन दोहाई कोट्टुन, अदिक अंदुन, “ई लॉकुर सांगुळ ना येन माळाईन? ई सब मुंदुर नान मा पथराव माळली तयार आर.” ");
INSERT INTO hoy_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","यहोवा मूसा से अंदुन, “इस्त्राएल इन स्याणा लॉकुर दा टु थ्वाळासा लॉकुरी तान सांगुळ हुडु कोम; अदिक याता कोल देल नी नील गांगा दा बळदीद, अदरी तान कय दा हुडुकु लॉकुर मुंद नळु. ");
INSERT INTO hoy_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","नोळ, ना नीन मुंद नळुत होरेब पहाळ इन ऊंद चट्टान मा निदुरकु ईराईन; अदिक नी आ चट्टान मा बडेत, आग अदुर दा टु नीर होट्टीत, यदुर देल ई लॉकुर कुडुल.” आग मूसा इस्त्राएल इन स्याणा लॉकुर्द नोळ्त हांगा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","अदिक मूसा आ जागा अन हेसुर मस्सा अदिक मरीबा ईटदुन, यतिकी इस्त्राएलीगोळ अल वाद विवाद माळीदुर, अदिक यहोवा अन परीक्षा ईद अंदकु माळदुर, “येन यहोवा नाम बीच दा आन या ईला?” ");
INSERT INTO hoy_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","आग अमालेकिगोळ जाती बंदकु रपीदीम दा इस्त्राएलीगोळ से लळाई माळली हतदुर. ");
INSERT INTO hoy_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","आग मूसा यहोशू से अंदुन, “नाम साटी हापाळ गणसुर इक निवळुसकु छाट्स कोम, अदिक नाळ व्हार्या होगकु अमालेकिगोळ से लळाई माळ; अदिक ना नाळ परमेश्वर उन कोल कय दा हुडुकु पहाळी इन चोटी मा निदुरकु ईराईन.” ");
INSERT INTO hoy_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","जसा मूसा अन ई आग्या अन अनुसार यहोशू अमालेकिगोळ से लळाई माळली हतदुन; अदिक मूसा, हारून, अदिक हूर पहाळ इन चोटी मा येरेदुर. ");
INSERT INTO hoy_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","याग याग मूसा तान कय नेगुकु ईटतोगोन आग आग इस्त्राएल जीत हासिल माळतोगोद; लेकीन याग याग आव अदरी ल्यालमा माळतोगोन आग आग अमालेक प्रबल आगतोगोद. ");
INSERT INTO hoy_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","लेकीन याग मूसा नव कयगोळ तुम्मेदव, आग आंदुर ऊंद कल्ल हुडुकु मूसा अन ल्यालमा ईट बुट्टुर, अदिक आव अदुर मा कुर्तोदुन, अदिक हारून अदिक हूर ऊंद ऊंद कय हुडुकु संभाळ्सकु ईटदुर; अदिक आऊन कयगोळ द्यावमुळका ताका स्थिर ईत्तव. ");
INSERT INTO hoy_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","अदिक यहोशू तान लॉकुर समेत अमालेकिगोळी तलवार इन बल देल हारूस बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","आग यहोवा मूसा से अंदुन, “ईद मात याद इक साटी किताब दा लिख्स कोम अदिक यहोशू उक केळ्सबुळ कि ना आकाश इन ल्यालमा टु अमालेक इन याद चिन्ह भी पुरा रीति देल मिटुस बुळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","आग मूसा ऊंद वेदी तयार माळकु अदुर्द हेसुर यहोवा निस्सी ईटदुन; ");
INSERT INTO hoy_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","अदिक आव अंदुन, “यहोवा प्रभु उन झंडा हुळकु ईरी. कि यहोवा अमालेकिगोळ से पिढ़ी टु पिढ़ी ताका लळाई माळतेला ईत्‍तान.” ");
INSERT INTO hoy_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","याग मूसा अन मॉव मिद्यान इन याजक यित्रो ईद केळदुन कि परमेश्वर मूसा अदिक तान प्रजा इस्त्राएल इन साटी येन येन माळ्यान, मतलब ईद कि याता प्रकार देल यहोवा इस्त्राएलीगोळी मिस्त्र दा टु तेगुकु तंदान, ");
INSERT INTO hoy_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","आग मूसा अन मॉव यित्रो मूसा अन हिंग्स सिप्पोरा अक, जो पयले टु ना आप्प उन मान्या कळुकु आगीदुर, ");
INSERT INTO hoy_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","अदिक आऊन येढ्ढु चिकोरी भी तंदुन; ईंदुर दा टु ऊंद उन हेसुर मूसा ईद अंदकु गेर्शोम ईटीदुन: “ना दुसरा द्याश दा परदेशी आगीन.” ");
INSERT INTO hoy_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","अदिक दुसरा अन हेसुर आव ईद अंदकु एलीएजेर ईटदुन: “नान आप्प उन परमेश्वर नान सहायक आगकु नानी फिरौन उन तलवार देल ऊळ्सदुन.” ");
INSERT INTO hoy_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मूसा अन हिंग्स अदिक पारगोळी, आऊन मॉव यित्रो सांगुळ हुडुकु मूसा अन हात्ती आळी दा आ जागा मा बंदुन, यल परमेश्वर उन पहाळ इन हात्ती आऊन ड्यारा ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","अदिक बंदकु आव मूसा अन हात्ती ईद बातणी कळुदुन, “ना नीन मॉव यित्रो हुईन, अदिक येढ्ढु पारगोळ समेत नीन हिंग्स उक नीन हात्ती तनकोटीन.” ");
INSERT INTO hoy_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","आग मूसा तान मॉव उन से मुलाकात माळोर साटी होट्टुन, अदिक आऊक दण्डवत माळकु मुत ताकोंडुन; अदिक आंदुर आबुर दाबुर हालचाल केळकु ड्यारा अन्द बुळ्क होदुर. ");
INSERT INTO hoy_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","अल मूसा तान मॉव उन से सप्पा क्याल्सागोळ्द वर्णन माळदुन कि यहोवा इस्त्राएलीगोळ निमित्त फिरौन अदिक मिस्त्रीगोळ से येन येन माळदुन, अदिक इस्त्राएलीगोळ यात्रा दा याता याता कष्ट नेगदुर, बाक यहोवा आंदरी ह्यांग ह्यांग बिळ्त बंदान. ");
INSERT INTO hoy_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","आग यित्रो आ सप्पा भलाई इन कारण जो यहोवा इस्त्राएलीगोळ सांगुळ माळीदुन, कि आंदरी मिस्त्रीगोळ्द वश दा टु बिळ्सीदुन, खुश आगकु अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","यित्रोगोळ अंदुर “धन्य आन यहोवा, याव नीमी फिरौन अदिक मिस्त्रीगोळ्द वश दा टु बिळ्सदुन, याव नीम लॉकुरी मिस्त्रीगोळ्द मुठ्ठी दा टु बिळस्यान. ");
INSERT INTO hoy_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ईग ना अर्त कोंडीन कि यहोवा सप्पा देवतागोळ से धोड्डेव आन; उलटा आ बारा दा भी यदुर देल आंदुर इस्त्राएलीगोळ सांगुळ अहंकारपुर्ण व्यवहार माळीदुर.” ");
INSERT INTO hoy_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","आग मूसा अन मॉव यित्रो परमेश्वर उन साटी होमबली अदिक मेलबलि येर्सदुन, अदिक हारून इस्त्राएलीगोळ्द सप्पा पुरनियागोळ समेत मूसा अन मॉव यित्रो अन सांगुळ परमेश्वर उन मुंद प्रार्थना माळदुर अदिक ऊमली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","दुसरा दिशी मूसा लॉकुर न्याय माळोर साटी कुरतुन, अदिक द्यावमुळका टु व्हातुर ताका लॉकुर मूसा अन आस पास निदुरकु ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ईद नोळकु कि मूसा लॉकुर साटी येन येन माळतान, आऊन मॉव अंदुन, “ईद येन क्याल्सा हुन जो नी लॉकुर साटी येन क्याल्सा माळत्या? येन कारण आद कि नी आबना कुर्तकु ईरत्या, अदिक लॉकुर द्यावमुळका टु व्हातुर ताका नीन आस पास निदुरकु ईरतार?” ");
INSERT INTO hoy_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मूसा तान मॉव उन से अंदुन, “ईदुर कारण ईद आद कि लॉकुर नान हात्ती परमेश्वर से केळली बरतार. ");
INSERT INTO hoy_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","याग याग आंदुर यातोदारा मुकदमा आगतद आग आग आंदुर नान हात्ती बरतार, अदिक ना आंदुर न्याड्या दा न्‍याय माळतेला, अदिक परमेश्वर उन विधि अदिक व्यवस्था आंदरी समझुसतीन.” ");
INSERT INTO hoy_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मूसा अन मॉव आऊन से अंदुन, “जो क्याल्सा नी माळत्या, अद वळ्लीद हैलेच. ");
INSERT INTO hoy_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ईदुर देल नी येन, उलटा ई लॉकुर भी जो नीन सांगुळ आर जरूर थक्सेदार, यतिकी ईद क्याल्सा नीन साटी हापाळ भारी आद; नी ईदरी आबना माळ सकाल. ");
INSERT INTO hoy_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","इदुरसाटी ईग नान केळकोम, ना नीनी सम्मति कोळतीन, अदिक परमेश्वर नीन सांगुळ ईरूल! नी ई लॉकुर साटी परमेश्वर उन हात्ती होगतोग, अदिक ईंदुर्द मुकदमागोळी परमेश्वर उन हात्ती नी पोहचुसतोग. ");
INSERT INTO hoy_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ईंदरी परमेश्वर उन आग्या अदिक नियम कल्सेत, अदिक याता हादी मा ईंदरी नळोद, अदिक जो जो क्याल्सा ईंदरी माळोद आद, अद हेळबुळतोग. ");
INSERT INTO hoy_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","बाक नी ई सप्पा लॉकुर दा टु ईत्ता मंळसागोळी छाट्सबुळ, जो गुणी, अदिक परमेश्वर उन अंज्क मान्सावाळेर, सच्चा, अदिक अन्याय इन लाभ देल घृणा माळावाळेर ईरूल; अदिक आंदरी हजार-हजार, सौ-सौ, पचास-पचास, अदिक हत्त-हत्त मंळसागोळ मा प्रधान नियुक्त माळबुळ. ");
INSERT INTO hoy_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","अदिक आंदुर हर सप्पा समय लॉकुर्द न्याय माळतोगुल; अदिक श्याण-श्याणेव मुकदमागोळ्द न्याय खुद अच माळतोगुल; आग नीन भार हल्का आदीत, यतिकी ई भार इक आंदुर भी नीन सांगुळ नेगदार ");
INSERT INTO hoy_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","अगर नी ईद उपाय माळ्या, अदिक परमेश्वर नीनी हिंग आग्या कोळुल, रा नी ठहरूस सक्या, अदिक ई सप्पा लॉकुर तान जागा अक कुशल देल पोहचुस सक्यार.” ");
INSERT INTO hoy_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","तान मॉव उन ईद मात मान्सकु मूसा आऊन सप्पा वचनगोळ्द अनुसार माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","इदुरसाटी मूसा सप्पा इस्त्राएलीगोळ दा टु गुणी मंळसागोळी निवळुसकु आंदरी हजार-हजार, सौ-सौ, पचास-पचास, हत्त-हत्त लॉकुरगोळ मा अधिकारी ठहरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","अदिक आंदुर सप्पा लॉकुरगोळ्द न्याय माळली हतदुर; जो मुकदमा कठिन ईरतोगोद अदरी आंदुर मूसा अन हात्ती तरतोगोर, अदिक सप्पा श्याण मुकदमागोळ्द न्याय आंदुर खुद अच माळतोगोर. ");
INSERT INTO hoy_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","आग मूसा तान मॉव उक सार माळदुन, अदिक आव तान द्याश इन हादी हुळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्त्राएलीगोळी मिस्त्र द्याश दा टु होटकु याता दिशी मुर तिंगुळ आदव, आ दिशी आंदुर सीनै अन आळी दा बंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","अदिक याग आंदुर रपीदीम टु कूच माळकु सीनै अन आळी दा बंदुर, आग आंदुर आळी दा ड्यारागोळ मंळ्सदुर; अदिक अल्या पहाळ इन मुंद इस्त्राएलीगोळ छावनी हाकदुर. ");
INSERT INTO hoy_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","आग मूसा पहाळी मा परमेश्वर उन हात्ती येरेदुन, अदिक यहोवा पहाळी मा आऊक कारूकु अंदुन, “याकूब उन घराना से हिंग अन, अदिक इस्त्राएलीगोळी नान ईद वचन केळ्स: ");
INSERT INTO hoy_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘नीव नोळीर कि ना मिस्त्रीगोळ से येन येन माळीन; नीमी मान्सी गिधाळ पक्षी इन पंखगोळ मा येर्सकु तान हात्ती तंदीन. ");
INSERT INTO hoy_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","इदुरसाटी ईग अगर नीव निश्चय नान नियम इक मान्सीर, अदिक नान वाचा अन पालन माळीर, रा सप्पा लॉकुर दा टु नीवा नान निज धन ठहरुसीर; समस्त पृथ्वी रा नांद अच हुन. ");
INSERT INTO hoy_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","अदिक नीव नान नजर दा याजकगोळ्द राज्य अदिक पवित्र राष्ट्र ठहरूसीर.’ जो मातगोळ नीनी इस्त्राएलीगोळ से अनव आव अव ईवा हुव.” ");
INSERT INTO hoy_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","आग मूसा बंदकु पुरनिए लॉकुर्द स्‍याणागोळी कार्सुसदुन, अदिक ई सप्पा मातगोळ, यऊर्द माताळोद आग्या यहोवा आऊक कोटीदुन, आंदरी समझुस बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","अदिक सप्पा लॉकुर मिलुसकु माताळ कुरतुर, “जो येनारा यहोवा अंदान अद सप्पा नाव जरूर माळेव.” लॉकुर ई मातगोळ मूसा यहोवा अक केळ्सदुन. ");
INSERT INTO hoy_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","आग यहोवा मूसा से अंदुन, “केळ, ना बादल इन अंधार दा आगकु नीन हात्ती बरतीन, इदुरसाटी कि याग ना नीन से मातगोळ हेळाईन आग आ लॉकुर केळुल, अदिक हमेशा नीन मा विश्वास माळुल.” अदिक मूसा यहोवा से लॉकुर्द मातगोळ्द वर्णन माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","आग यहोवा मूसा से अंदुन, “लॉकुर हात्ती होग अदिक आंदरी ईंद अदिक नाळ पवित्र माळेत, अदिक आंदुर तान फळक्या वग्द कोमुल, ");
INSERT INTO hoy_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","अदिक आंदुर तिसरा दिन ताका तयार आगेगुल; यतिकी तिसरा दिशी यहोवा सप्पा लॉकुर्द नोळ्त सीनै पहाळ मा ईळुकु बंदान. ");
INSERT INTO hoy_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","अदिक नी लॉकुर साटी नाकु दी वाळा कटकु कोळेत, अदिक आंदुर से अनेत: ‘नीव सचेत ईरेतीर कि पहाळी मा येरतीदील अदिक अदुर सीमा अक भी मुटतीदील; अदिक जो यावारा पहाळी इक मुट्यान आव जरूर कोंदकु आदान. ");
INSERT INTO hoy_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","अदरी याऊ कय देल मुटबाळुल; जो मुट्यान आऊन मा कल्लगोळ भिटकु आगुल, या आऊक तीर देल कोंदकु आगुल; चाहे जनावर चाहे मंळसा, आव ऊळ्दकु ईरबाळुल.’ याग म्याळा अन्द मार्र इन नरसिंगा वाळा शब्द देर ताका केळ बरूल, आग लॉकुर पहाळ मा येर्‍यार.” ");
INSERT INTO hoy_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","आग मूसा पहाळ मा टु ईळुकु लॉकुर हात्ती बंदकु आंदरी पवित्र माळसुसदुन; अदिक आंदुर तान फळक्या वग्द बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","अदिक मूसा लॉकुर से अंदुन, “तिसरा दिशी ताका तयार आगेगी; आर्तेर हात्ती होगबाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","याग तिसरा दिन बत्त आग व्हातुर आगतेला अच बादल गरजुसली अदिक बिजली चमकुसली हत्त, अदिक पहाळी मा करीद बादल छाऊसेत, बाक नरसिंगा अन धोळ्द भारी शब्द आत, अदिक छावनी दा यास लॉकुर ईरोर सप्पा नळ्गली हतदुर. ");
INSERT INTO hoy_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","आग मूसा लॉकुरी परमेश्वर उन से भेंट माळोर साटी छावनी दा टु तेगुकु तंदुन; अदिक आंदुर पहाळ इन ल्यालमा निदुरदुर. ");
INSERT INTO hoy_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","अदिक यहोवा जो बेक्‍की दा टु आगकु सीनै पहाळ मा ईळदीदुन, ई कारण देल पुरा पहाळ धूंगा देल तुम्मेत, अदिक अदुर्द धुंगा भट्टी इन घाई होळोद, अदिक पुरा पहाळ हापाळ नळगोद. ");
INSERT INTO hoy_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","बाक याग नरसिंगा अन शब्द तीव्रता देल वाळुस्त अदिक हापाळ भारी आगतेला होत, आग मूसा माताळदुन, अदिक परमेश्वर वाणी केळ्सकु आऊक उत्तर कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","अदिक यहोवा सीनै पहाळ इन चोटी टु ल्‍यालमा ईळदुन; अदिक मूसा अक पहाळ इन चोटी मा कारदुन, अदिक मूसा म्याकुच येरेदुन. ");
INSERT INTO hoy_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","आग यहोवा मूसा से अंदुन, “ल्यालमा ईळुकु लॉकुरी चेतावनी कोळ, ईलारा हिंग आगबाळुल कि आंदुर वाळा मुर्दकु यहोवा अन हात्ती नोळली होकुल, अदिक आंदुर दा टु हापाळ सा नष्ट आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","अदिक याजक जो यहोवा अन हात्ती बरतोगतार आंदुर भी तान इक पवित्र माळुल, ईलारा हिंग आगबाळुल कि यहोवा आंदरी दंड कोळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मूसा यहोवा से अंदुन, “आ लॉकुर सीनै पहाळ मा येर सकालुर; नी रा खुद नामी ईद अंदकु चेतावनी कोट कि पहाळ इन नाकु दी वाळा कटकु अदरी पवित्र ईटी.” ");
INSERT INTO hoy_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","यहोवा आऊक उत्तर कोट्टुन, “ईळ्द रा होग, अदिक हारून समेत नी म्याकुच बर; लेकीन याजक अदिक साधारण लॉकुर यहोवा अन हात्ती वाळा मुर्दकु येर्त बरबाळुल, हिंग आगबाळुल कि यहोवा आंदरी दंड कोळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","इदुरसाटी ई मातगोळ मूसा लॉकुर हात्ती ईळ्दकु आंदरी केळ्सदुन. ");
INSERT INTO hoy_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","आग परमेश्वर ई सप्पा वचन माताळदुन: ");
INSERT INTO hoy_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ना नीन परमेश्वर यहोवा हुईन, जो नीनी दासत्व अन मान्ना मतलब मिस्त्र द्याश दा टु तेगुकु तंदान.” ");
INSERT INTO hoy_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“नी नानी बिटकु दुसरा अक परमेश्वर मान्सबाळेत.” ");
INSERT INTO hoy_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“नी तान साटी यातोदु मुर्ति अगुळकु माळ बाळेत, ना यारदारा प्रतिमा बनुसेत, जो आकाश दा, या पृथ्वी मा, या पृथ्वी इन नीर दा आद.” ");
INSERT INTO hoy_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","नी आंदरी दण्डवत माळबाळेत, अदिक ना आंदुर्द उपासना माळेत; यतिकी ना नीन परमेश्वर यहोवा जलन (ईर्ष्या) ईटावाळा परमेश्वर हुईन, अदिक जो नान से दुश्‍मनी ईटतार, आंदुर पारगोळ, नातु नतरागोळ, अदिक पळनातुगोळी भी पित्तरगोळ्द दण्ड कोळतोगतीन, ");
INSERT INTO hoy_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","लेकीन जो नान से प्रेम ईटतार अदिक नान आग्यागोळी मान्सतार, आ हजारों पीढ़ीगोळ मा करूणा माळतोगतीन. ");
INSERT INTO hoy_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“नी तान परमेश्वर उन हेसुर व्यर्थ ताकोमबाळेत; यतिकी जो यहोवा अन हेसुर व्यर्थ ताकोंडान आव आऊक निर्दोष ठहरूसतीदील.” ");
INSERT INTO hoy_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“नी विश्राम दिन इक पवित्र मानसोर साटी याद ईटेत. ");
INSERT INTO hoy_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","आर दिन रा नी मयनत माळकु तान सप्पा क्याल्सा-धंधा माळेत; ");
INSERT INTO hoy_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","लेकीन सातवा दिशी नीन परमेश्वर यहोवा अन साटी विश्राम दिन आद. अदुर दा नी ना रा यातोदु प्रकार इन क्याल्सा-धंधा माळेत, अदिक ना नीन पार, ना नीन पोर, ना नीन दास, ना नीन दासगीत, ना नीन जनावर, ना यातोवारा परदेशी जो नीन फाटकगोळ्द अंदर ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","यतिकी आर दिन दा यहोवा आकाश, अदिक पृथ्वी, अदिक समुद्र, अदिक जो येनारा अऊर दा आद, सप्पा अक बनुसदुन, अदिक सातवा दिशी विश्राम माळदुन; ई कारण देल यहोवा विश्राम दिन इक आशीष कोट्टुन अदिक अदरी पवित्र ठहरूसदुन.” ");
INSERT INTO hoy_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“नी तान आप्प अदिक तान मोय इन आदर माळेत, यदुर देल जो द्याश नीन परमेश्वर यहोवा नीनी कोळतान अदुर दा नी हापाळ दिन ताका ईत्या.” ");
INSERT INTO hoy_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","नी खुन माळबाळेत. ");
INSERT INTO hoy_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","नी व्यभिचार माळबाळेत. ");
INSERT INTO hoy_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","नी काळ्लपनी माळबाळेत. ");
INSERT INTO hoy_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","नी यारदारा खिलाप ख्वाटा गवाही कोळबाळेत. ");
INSERT INTO hoy_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“नी यारदारा मान्नोद लालच माळबाळेत; ना रा यारदारा आर्त इन लालच माळेत, अदिक ना यारदारा दास-दासगीत या वस्त-वाळींद, ना यारदारा यातोदु वस्तु उन लालच माळेत.” ");
INSERT INTO hoy_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","सप्पा लॉकुर गर्जन अदिक बिजली अदिक नरसिंगा अन शब्द केळ्त, अदिक धुंगा येळ्त पहाळ इक नोळतेला ईत्तुर, अदिक नोळकु, नळ्गतेला दुर निद्रेदुर; ");
INSERT INTO hoy_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","अदिक आंदुर मूसा से अनली हतदुर, “नी ना नाम से मातगोळ हेळ, आग रा नाव केळ सक्केव; लेकीन परमेश्वर नाम से मात हेळबाळुल, हिंग आगबाळुल कि नाव सोतोदेव.” ");
INSERT INTO hoy_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मूसा लॉकुर से अंदुन, “अंजबाळी; यतिकी परमेश्वर इदुरसाटी बंदान कि नीम परीक्षा माळुल, अदिक आऊन अंज्क नीम मन दा बन्सकु ईरूल कि नीव पाप माळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","अदिक आ लॉकुर दुर अच निदुरकु ईत्तुर लेकीन मूसा आ घोर अंधार इन हात्ती होदुन यल परमेश्वर ईरोन. ");
INSERT INTO hoy_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","आग यहोवा मूसा से अंदुन, “नी इस्त्राएलीगोळी नान ई वचन केळ्स: नीव लॉकुर खुद अच नोळीर कि ना नीम सांगुळ आकाश से मातगोळ हेळीन. ");
INSERT INTO hoy_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","नीव नान सांगुळ यारीकारा सम्मिलित माळबाळेतीर, मतलब तान साटी बेळ्ली या व्हान्ना देल देवतागोळी घळुसबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","नान साटी मुण्ण इन ऊंद वेदी बनुसेतीर, अदिक तान भेड़-मर्रगोळ अदिक वस्ता-गोसीगोळ्द होमबली अदिक मेलबली इक अदुर मा येर्सेतीर; अदिक हर ऊंद जागा दा यल यल ना तान हेसुर इन याद माळसुसाईन अल अल ना बंदकु नीमी आशीष कोळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","अदिक अगर नीव नान साटी कल्लगोळ्द वेदी माळीर, रा तराशकु कल्लगोळ देल माळबाळेतीर; यतिकी यल नीव अदुर मा तान औजार हचदीर अल नीव अदरी अशुद्ध माळ बुट्टीर. ");
INSERT INTO hoy_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","अदिक नान वेदी मा सीळी देल यागलु येरबाळेतीर, ईलारा हिंग आगबाळुल कि नीन मय अदुर मा ऊगळा कांळ्सकु बिळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","बाक जो नियम नीनी आंदरी समझुसोद आद अव ईव हुव: ");
INSERT INTO hoy_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","याग नीव यातोवारा इब्री दास उक कोंडीर, आग आव आर साल ताका स्यावा माळतेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","अगर आव आबना बंदान, रा आबना अच होटोगुल; अगर हिंग्स उन सांगुळ बंदान, रा आऊन सांगुळ आऊन हिंग्स भी होटोगुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","अगर आऊन स्वामी आऊक हिंग्स उक कोटान अदिक आकिन से आऊन पारगोळ अदिक पोरगोळ पैदा आग्यार, रा आऊन हिंग्स अदिक चिकोर आ स्वामी नोर अच ईरूल, अदिक आव आबना होटोगुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","लेकीन अगर आव दास हिम्मत देल अनुल, ना तान स्वामी, अदिक तान हिंग्स, अदिक चिकोर से प्यार ईटतीन; इदुरसाटी ना स्वतंत्र आगकु होगतीदील; ");
INSERT INTO hoy_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","रा आऊन स्वामी आऊक परमेश्वर उन हात्ती ओयुल; बाक आऊक द्वार इन कवाळ या बाजु उन हात्ती ओतकु आऊन किव दा चुजी देल गड्डा माळुल; आग आव हमेशा आऊन स्यावा माळ्त ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“अगर यावारा तान पोर इक दासगीत आगोर साटी मार बुळुल, रा आक दासगीत इन घाई व्हार्या होगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","अगर आकिन स्वामी आक इक तान हिंग्स माळुल, अदिक बाक आकिन से खुश ईला ईरूल, रा आव आक इक दाम बेळकु होगगोळुल; आकिन विश्वासघात माळदुर बाद्दा आक इक परदेशी लॉकुर कय दा मारोद अधिकार आऊक ईरतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","अगर आव आकिन मदा तान पार उन से माळ्यान, रा आकिन से पोर इन घाई व्यवहार माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","चाहे आव दुसरा हिंग्स येती माळबाळुल, तरी भी आव आकिन ऊम्मोद, कपळा, अदिक वैवाहिक व्यवहार गोर्त माळबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","अदिक अगर आव ई मुरू मातगोळ दा घटी माळुल, रा आ आर्त बिना दाम कोळ्द अच होटोगुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“जो यातारा मंळसा अक हिंग बडुल कि आव सोतोगुल, रा आव भी जरूर कोन्सुसकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","अगर आव आऊन घात दा कुर्तकु हैलेच, अदिक परमेश्वर उन इच्छा देल अच आव आऊन कय दा बिदोग्यान, रा हिंग कोनावाळा अन ओळावाळा अन साटी ना ऊंद जागा ठहरूसाईन यल आव ओळेगुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","लेकीन अगर यावारा ज्यान बुजुसकु यारदारा मा चढ़ाई माळकु आऊक छल देल घात माळुल, रा आऊक कोन्द बुळोर साटी नान वेदी इन हात्ती टु भी अलग ओयेतीर.” ");
INSERT INTO hoy_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“जो तान मोय या आप्प उक मार-पीट माळ्यान आव जरूर कोंदकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“जो यावारा यातारा मंळसा अक कदुल, चाहे आऊक ओतकु मारबुळुल, चाहे आव आऊन अल कांळ्सकु बिळुल, रा आव भी जरूर कोंदकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“जो तान मोय या आप्प उक शराप कोट्टान आव भी जरूर कोंदकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“अगर मंळसागोळ बाय मुरसुल, अदिक आबुर दाबुरी कल्ल या बुक्‍की देल हिंग बडुल कि आव सायबाळुल लेकीन हासक्या मा बिदकु ईरूल, ");
INSERT INTO hoy_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","रा याग आव यदकु कोल इन सहारा देल व्हार्या कुरली येळली हतुल, आग आव बडावाळा निर्दोष ठहरूसुल; आ दशा दा आव आऊन बिदकु ईरोद समय इन भरपाई तुमुल, अदिक आऊक भला चंगा भी माळकोळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“अगर यावारा तान दास या दासगीत इक सोंटा देल हिंग बडुल कि आव आऊन बळदुर देल सोतोगुल, आग आऊक जरूर दण्ड कोटकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","लेकीन अगर आव ऊंद येढ्ढ दिन जित्ता ईरूल, रा आऊन स्वामी इक दण्ड कोटकु आगबाळुल; यतिकी आ दास आऊन धन हुन.” ");
INSERT INTO hoy_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“अगर मंळसा आपस दा बडाबडी माळकु यातारा ईत्ता आर्त जो व्‍हाट्‍यादी आर आक इक हिंग चोट पोहचुसुल कि आकिन गर्भ बिदोगुल, लेकीन मात्त येनु नुकसान आगबाळुल, रा बडावाळा से आट दण्ड ताकोमकु आगुल याट आ आर्त इन गण्स पंच लॉकुर्द सम्मति देल ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","लेकीन अगर आ आर्त मार पीट देल सोतोदार, रा जीव इन बदला जीव इन, ");
INSERT INTO hoy_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","अदिक कण्ण इन बदला कण्ण इन, अदिक हल्ल इन बदला हल्ल इन, अदिक कय इन बदला कय इन, अदिक काल इन बदला काल इन, ");
INSERT INTO hoy_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","अदिक दाग इन बदला दाग इन, अदिक घाव इन बदला घाव इन, अदिक मार इन बदला मार इन दण्ड आगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“याग यावारा तान दास या दासगीत इन कण्ण मा हिंग बडुल कि अद वळ्दोगुल, रा आव आऊन कण्ण इन बदला आऊक आजाद माळकु होगगोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","अदिक अगर आव तान दास या दासगीत इक बडुकु आऊन हल्ल मुर्द बुळुल, रा आव आऊन हल्ल इन बदला आऊक आजाद माळकु होगगोळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“अगर वस्ता यावारा मंळसा या आर्त इक हिंग सींग बडुल कि आव सोतोगुल, रा अद वस्ता जरूर पथराव माळकु कोंदकु आगुल, अदिक अदुर्द मास तिनकु आगबाळुल; लेकीन वस्ता अन स्वामी निर्दोष ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","लेकीन अगर आ वस्ता अन सींग होडोद आदत पयले टु ना आद, अदिक अदुर्द स्वामी इक ई मात मालुम ईरदुर बाद्दा भी अदरी कटकु ईटीदील, अदिक अद यातारा मंळसा या आर्त इक कोंद बुळुल, आग रा आ वस्ता मा पथराव माळकु आगुल, अदिक अदुर्द स्वामी इक भी कोंदकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","अगर आऊन मा फिरोती ईटकु आग्याद रा आव तान जीव ऊळसोर साटी तान मा कुर्द फिरोती इक कोट बुळुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","चाहे वस्ता यातारा पार उक, चाहे पोर इक कोंदाद, तरी भी ईदा नियम इन अनुसार अदुर्द स्वामी इन सांगुळ व्यवहार माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","अगर वस्ता यातारा दास या दासगीत इक सींग होळदीदाद, रा वस्ता अन स्वामी आ दास इन स्वामी इक तीस शेकेल बेळ्ली कोळुल, अदिक आ वस्ता मा पथराव माळकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“अगर यावारा मंळसा गड्डा तेरूकु या अगुळकु अदरी मुचालुन, अदिक अदुर दा यारदारा वस्ता या गदा बिदोगुल, ");
INSERT INTO hoy_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","रा आ गड्डा यार्द हुन आव आ नुकसान इक तुम कोळुल; आव जनावर इन स्वामी इक अदुर्द मोल कोळुल, अदिक सोतकु जनावर इन लाश गड्डावाळा अन ठहरूसुल.” ");
INSERT INTO hoy_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“अगर यारदारा वस्ता यातारा दुसरा मंळसा अन वस्ता अक हिंग चोट पोहचुसुल कि अद सोतोगुल, रा आ येढ्ढु मंळसागोळ जित्ता वस्ता अक मारकु अदुर्द मोल आपस दा आर्धा आर्धा वाट्स बुळुल; अदिक सोतकु जनावर इन लाश इक भी हांगा वाट्सुल. ");
INSERT INTO hoy_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","अगर ईद प्रगट आगुल कि आ वस्ता अन पयले टु ना सींग होडोद आदत ईरोद, लेकीन अदुर्द स्वामी अदरी कटकु ईटीदील, रा जरूर आव वस्ता अन बदला वस्ता तुम कोळुल, लेकीन सोतकु वस्ता अन लाश आऊंदा ठहरूसुल.” ");
INSERT INTO hoy_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“अगर यावारा मंळसा वस्ता, या भेड़, या मर्री कदुकु अदुर्द घात माळुल या मार बुळुल, रा आव वस्ता अन बदला अईद वस्ता, अदिक भेड़-मर्रगोळ बदला नाक भेड़-मर्रगोळ तुमकु कोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","अगर काळ्ल काळ्लपनी माळतेला हुडुकु आगुल, अदिक आऊन मा हिंग मार बिळुल कि आव सोतोगुल, रा आऊन खुन इन दोष हतबाळुल; ");
INSERT INTO hoy_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","अगर सुर्य होटबुटाद, रा आऊन खुन इन दोष हतुल; जरूरी आद कि आव नुकसान तुमकु कोळुल, अदिक अगर आऊन हात्ती येनु हैलेच, रा आव काळ्लपनी इन कारण मारकु आगेगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","अगर काळ्लपनी माळ्द वस्ता, या गदा, या भेड़, या मर्री आऊन कय दा जित्ता कांळसुल, रा आव अऊर्द येढ्ढ गुणा तुमकु कोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“अगर यावारा तान जनावर से यारदारा केई या अंगुर इन बेली चरूसुल, मतलब तान जनावर इक हिंग बिटबुळुल कि अद दुसरा अन केई दा चरूसुल, रा आव तान केई इन अदिक तान अंगुर इन बेली इन वळ्लीद से वळ्लीद उपज दा टु आ नुकसान इक तुम कोळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“अगर यावारा बेक्‍की होताकुल, अदिक अद मुळ्लगोळ दा हत्तेगुल अदिक फुलगोळ ढग या अनाज या ऊब्बा केई होत्तेगुल, रा याव बेक्‍की होताक्यान आव आ नुकसान इक जरूर तुम कोळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“अगर यावारा दुसरा अन हात्ती रूपये या सामग्री ईटली कोळुल, अदिक अद आऊन मान्या दा टु काळ्लपनी आगुल, रा अगर काळ्ल हुडुकु आगुल रा येढ्ढ गुणा आऊका तुम कोळोद बिद्दीत. ");
INSERT INTO hoy_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","अगर काळ्ल हुडुकु ईला आगुल, रा मान्यागोळ स्वामी परमेश्वर उन हात्ती तनकु आगुल कि पक्‍का आगेगुल कि आव तान वार्ट-बन्धुगोळ्द सम्पत्ति मा कय हच्यान या ईला. ");
INSERT INTO hoy_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","चाहे वस्ता, चाहे गदा, चाहे भेड़ या मर्री, चाहे कपळा, चाहे यातोदारा प्रकार इन ईत्ता काळ्द वस्तु उन बारा दा अपराध येती हचकु आगबाळुल, यदरी येढ्ढ मुंदुर तान तान अनतीर, रा येढ्ढु मुंदुर्द मुकदमा परमेश्वर उन हात्ती बरूल; अदिक यारी परमेश्वर दोषी ठहरूसुल आव दुसरा अक येढ्ढ गुणा तुम कोळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“अगर यावारा दुसरा अक गदा या वस्ता या भेड़-मर्रगोळ या यातोदारा दुसरा जनावर ईटोर साटी सोप्सुल, अदिक यारदारा बिना नोळ्द आव सोतोगुल, या घाव तिनुल, या हकाल्सकु आगुल, ");
INSERT INTO hoy_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","रा आ येढ्ढु मुंदुर बीच दा यहोवा अन किर्‍या तिन्सकु आगुल, ना ईऊन सम्पत्ति इक कय हचीदील; आग सम्पत्ति इन स्वामी ईदरी खरा मानसुल, अदिक दुसरा अक आऊक येनारा भी तुम कोळोद बिळतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","अगर अद खराखुरा आऊन अल टु काळ्लपनी माळकु आग्याद, रा आव स्वामी इक नुकसान तुम कोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","अदिक अगर अद हर्दकु आग्याद, रा अद हर्दकु उक प्रमाण इन साटी तरूल, आग आऊक अदरी भी तुम कोळोद बिळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“बाक अगर यावारा दुसरा से जनावर बेळकु तरूल, अदिक अदुर्द स्वामी इन ईला ईत्तुर कारण देल अदरी चोट हतुल या अद सोतोगुल, रा जरूर अदुर्द नुकसान तुम कोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","अगर अदुर्द स्वामी सांगुळ ईरूल, रा दुसरा अक अदुर्द नुकसान तुमोद बिळबाळुल; अदिक अगर अद किराया अन ईरूल रा अदुर्द नुकसान अदुर्द किराया दा होट बत्त.” ");
INSERT INTO hoy_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“अगर यावारा मंळसा यातारा कुवारा पोर इक, यार्द मदा अन मात ईला नळदीदाद, आकी फुसलुस्कु आकिन सांगुळ कुकर्म माळुल, रा आव जरूर आकिन मोल कोटकु आकिन से मदा माळ कोमुल. ");
INSERT INTO hoy_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","लेकीन अगर आकिन आप्प आक इक कोळोर साटी बिलकुल इनकार तुमुल, रा कुकर्म माळावाळा पोरगोळ्द मोल इन रिति इन अनुसार पैस्या आळ्दकु कोळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“नी जादू-टोना माळावळ्त इक जित्ता ईरगोळबाळेत. ");
INSERT INTO hoy_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“जो यावारा यातोदारा जनावर से कुकर्म माळुल रा आव जरूर कोंदकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“जो यावारा यहोवा अक बिटकु यातारा दुसरा देवता अन साटी बलि येर्सुल आऊन सत्यानाश माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“नीव परदेशीगोळी ना सतुसेतीर अदिक ना आंदुर मा अंधार माळेतीर, यतिकी मिस्त्र द्याश दा नीव भी परदेशी ईरीर. ");
INSERT INTO hoy_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","यातारा रांड्यागीत या अनाथ चिग्द उक दुख कोळ बाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","अगर नीव ईत्ता लॉकुरी यातारा प्रकार इन दुख कोट्टीर अदिक आंदुर नांद दोहाई कोट्टार, रा ना जरूर आंदुर दोहाई केळाईन; ");
INSERT INTO hoy_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","आग नान सिट्ट भळकुसीत, अदिक ना नीमी तलवार देल कोंसुसाईन, अदिक नीम हिंग्सुर रांड्यागीतेर अदिक नीम चिगदुर अनाथ आगेदार. ");
INSERT INTO hoy_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“अगर नी नान प्रजा दा टु यावारा गरीब मंळसा अक जो नीन हात्ती ईरतीदान पैस्या अन कर्ज कोट्या रा आऊन से शाहुकार उन घाई ब्याज ताकोम बाळेत. ");
INSERT INTO hoy_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","अगर नी यागल्यारा तान वार्ट बन्धु उन कपळागोळी बन्धक माळकु ईट भी कोंड्या, रा द्यावमुळका से पयले आऊक वापस माळबुळेत; ");
INSERT INTO hoy_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","यतिकी अद आऊन ऊंदा होदोद हुन, आऊन मय इन अदा आबना कपळा ईत्तीत; बाक आव यदरी होदुकु मिंग्यान? अदिक याग आव नान दोहाई कोट्टान आग ना आऊन केळाईन, यतिकी ना करूणामय आईन. ");
INSERT INTO hoy_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“परमेश्वर उक श्राप कोळबाळेत, अदिक ना तान लॉकुर्द प्रधान उक श्राप कोळेत. ");
INSERT INTO hoy_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“तान केईगोळ्द उपज अदिक कायगोळ्द रास्सा दा टु थ्वाळासा नानी कोळदुर दा समय माळबाळेत. तान पारगोळ दा टु पयला पार नानी कोळेत. ");
INSERT INTO hoy_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","हांगा तान गोसीगोळ अदिक भेड़-मर्रीगोळ्द पयला भी कोळेत; येळ दिन ताका रा चिग्द तान मोय इन सांगुळ ईरूल, अदिक आठवा दिशी नी अदरी नानी कोट बुळेत. ");
INSERT INTO hoy_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“नीव नान साटी पवित्र मंळसा हुईर; ई कारण जो जनावर मैदान दा सोतकु सिक्‍कीत अदुर्द मास तिनबाळेतीर, अदरी नाय इन मुंद बिट्ट बुळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ख्वाटा मातगोळ फैलुसबाळेतीर. अन्यायी गवाह ईतकु दुष्ट मंळसा अन साथ कोळ बाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","बुराई माळोर साटी ना रा हापाळ मुंदुर हींद आगेगीतीर; अदिक ना आंदुर हींद ओयाळतेला मुकदमा दा न्‍याय बिगळुसली गवाही कोळेतीर; ");
INSERT INTO hoy_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","अदिक कंगाल उन मुकदमा दा आऊन भी पक्ष माळ बाळेत. ");
INSERT INTO hoy_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“अगर नीन दुश्मन उन वस्ता या गदा भटकुसतेला नीनी सिकुल, रा अदरी आऊन हात्ती जरूर वापस तनकोळेत. ");
INSERT INTO hoy_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","बाक अगर नी तान दुश्मन उन गदा अक बोझ इन मारा देल वोतकु नोळ्या, रा चाहे अदरी अदुर्द स्वामी इन साटी बिळ्सली नीन मन आगतीदील, तरी भी जरूर स्वामी इन साथ कोटकु अदरी बिळ्स बुळेत. ");
INSERT INTO hoy_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“नीन लॉकुर दा टु जो गरीब ईरूल आऊन मुकदमा दा न्याय बिगळुस बाळेत. ");
INSERT INTO hoy_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ख्वाटा मुकदमा देल दुर ईरेत, अदिक निर्दोष अदिक न्यायी इक घात माळबाळेत, यतिकी ना दुष्ट मंळसा अक निर्दोष ठहरूसतीदील, ");
INSERT INTO hoy_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","रिश्वत ताकोम बाळेत, यतिकी रिश्वत नोळावाळेर इक भी कुढ्ढ माळ बुळतद अदिक न्‍यायी मंळसागोळ्द मातगोळी ऊलटुस बुळतद. ");
INSERT INTO hoy_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“परदेशी मा अंधार माळ बाळेत; नीव रा परदेशी इन मन इन मातगोळी अरूतीर, यतिकी नीव भी मिस्त्र द्याश दा परदेशी ईरीर. ");
INSERT INTO hoy_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“आर साल रा तान जमीन दा बोऊसेतीर अदिक अदुर्द उपज जमा माळेतीर; ");
INSERT INTO hoy_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","लेकीन सातवा साल दा अदरी पळ्याव ईरगोळेतीर अदिक हांगा बिट्ट बुळेतीर, मतलब नीन वार्ट बन्धुगोळ दा टु जो कंगाल ईतीदार आंदुर अदुर दा ऊगुस्द तिंदार, अदिक आंदुर तिनकु आगदुर बाद्दा जो मिक्कीत अव जनावरगोळ तिंदाव. तान अंगुर अदिक जैतून इन बेली दा टु भी हिंगा माळेत. ");
INSERT INTO hoy_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","आर दिन ताका तान क्याल्सा कळी माळेतीर, अदिक सातवा दिशी आराम माळेतीर ताकी नान वस्ता अदिक गदागोळ भी विश्राम माळुल, अदिक नीन दासगीतेर्द पारगोळ अदिक परदेशी भी तान जीव ठंडा माळ सकुल. ");
INSERT INTO hoy_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","जो येनारा ना नीम से अंदीन अदुर दा सावधान ईरेतीर; अदिक दुसरा देवतागोळ्द हेसुर इन चर्चा माळबाळेतीर, उलटा अव नीम बाय दा टु केळकु भी आगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“हर साल मुर घन नान साटी हाब्बा मनुसेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","अखमीरी रोट्टी इन हाब्बा मनुसेतीर; अदुर दा नान आग्या अन अनुसार अबीब तिंगुळ इन नियत समय मा येळ दिन ताका अखमीरी रोट्टी तिनतोगेतीर, यतिकी अदा तिंगुळ दा नीव मिस्त्र दा टु होटकु बंदीदीर. याऊ निरा कय देल नान मुंद बरबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","याग नीन बोऊस्द केई इन पयला उपज तयार आगुल, आग कटाई इन हाब्बा मान्सेत. साल इन आखरी दा याग नी मयनत इन काय जमा माळकु ढेर हच्या, आग जमावळा अन हाब्बा मान्सेत. ");
INSERT INTO hoy_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","हर साल मुरू घन नीन सप्पा मंळसागोळ प्रभु यहोवा अक तान मार्रा तोर्सुल. ");
INSERT INTO hoy_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“नान बलि इन जनावर इन रक्ता खमीरी रोट्टी इन सांगुळ येर्स बाळेतीर, अदिक ना नान हाब्बा अन वळ्लीद बलिदान दा टु येनारा व्हातुर ताका ईरगोळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","तान जमीन इन पयला उपज इन पयला हिस्सा तान परमेश्वर यहोवा अन भवन दा तरेतीर. मर्री इन पाड्डा अदुर्द मोय इन हाल दा बेईस बाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“केळ, ना ऊंद दूत नीन मुंद मुंद कळुतीन जो हादी मा नीन रक्षा माळीत, अदिक याता जागा अक ना तयार माळीन अल नीनी पोहचुसीत. ");
INSERT INTO hoy_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","अदुर मुंद सावधान ईरेत, अदिक अदुर्द मान्सेत, अदुर विरोध माळबाळेत, यतिकी अद नीम अपराध क्षमा माळतीदील; इदुरसाटी कि अदुर दा नान हेसुर ईरतद. ");
INSERT INTO hoy_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","अगर नी खराखुरा अदुर्द केळ्या अदिक जो येनारा ना अनाईन अद माळ्या, रा ना नीन दुश्मन इन दुश्मन अदिक नीन द्रोहीगोळ्द द्रोही आगाईन. ");
INSERT INTO hoy_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ईत्ता रिति देल नान दूत नींद मुंद मुंद नळुतेला नीनी एमोरी, हित्ती, परिज्जी, कनानी, हिब्बी, अदिक यबूसी लॉकुर अल पोहचुसीत, अदिक ना आंदुर्द सत्यानाश माळ बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","आंदुर देवतागोळी दण्डवत माळबाळेतीर, अदिक ना आंदुर उपासना माळेतीर, अदिक ना आंदुर घाई क्याल्सा माळेतीर, उलटा आ मुर्तिगोळ्द पुरा रिति देल सत्यानाश माळ बुळेतीर, अदिक आ लॉकुर्द स्तंभगोळ्द तुकळा तुकळा माळ बुळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","नी तान परमेश्वर यहोवा अन उपासना माळेत, आग आव नीन अनाज नीर मा आशीष कोट्टान, अदिक नीन बीच दा टु रोग दुर माळ्यान. ");
INSERT INTO hoy_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","नीन द्याश दा ना रा यारदारा गर्भ बिद्दीत अदिक ना यारारा वांजला ईत्तार; अदिक नीन उमर ना पुरा माळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","यास लॉकुर बीच दा नी होद्या आ सप्पा लॉकुर मन दा ना तान अंज्क पयले टु हिंग समुस बुळाईन कि आंदरी व्याकुल माळ बुळाईन, अदिक ना नीनी सप्पा दुश्मनगोळ्द बेन तोर्साईन. ");
INSERT INTO hoy_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","अदिक ना नीन से पयले गंदवल कळाईन जो हिब्बी, कनानी, अदिक हित्ती लॉकुरी नीन मुंदु टु तुरकाळ्सकु दुर माळ बुट्टव. ");
INSERT INTO hoy_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ना आंदरी नीन मुंदु टु ऊंदा साल दा तेग्द बुळालीन, हिंग आगबाळुल कि द्याश ऊजळुसेगुल, अदिक पालतु जनावर वाळुसकु नीनी दुख कोळली हतुल. ");
INSERT INTO hoy_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","यागासताका नीन संख्या वाळुसकु द्याश इक तान अधिकार दा माळ कोमाल आगासताका ना आंदरी नीन मुंदु टु थ्वाळा थ्वाळा माळकु तेगुतेला ईराईन. ");
INSERT INTO hoy_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ना क्याचाँद समुद्र टु हुडुकु पलिश्तीगोळ्द समुद्र ताका अदिक आळी टु हुडुकु फरात महानद ताका द्याश इक नीन वश दा माळ बुळाईन; ना आ द्याश इन ईरावाळेर इक भी नीन वश दा माळ बुळाईन, अदिक नी आंदरी तान मुंदु टु बरबस तेगद्या. ");
INSERT INTO hoy_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","नी ना रा आंदुर से वाचा कटेत अदिक ना आंदुर देवतागोळ से. ");
INSERT INTO hoy_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","आंदुर नीन द्याश दा ईरली ईला पायजे, हिंग आगबाळुल कि आंदुर नीन से नान विरूद्‍ध पाप माळसुसुल; यतिकी अगर नी आंदुर देवतागोळ्द आराधना माळ्या, रा ईद नीन साटी फंदा बन्सीत.” ");
INSERT INTO hoy_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","बाक यहोवा मूसा से अंदुन, “नी हारून, नादाब, अबीहू, अदिक इस्त्राएलीगोळ्द सत्तर स्याणागोळ समेत यहोवा अन हात्ती म्याकुच बंदकु दुर टु दण्डवत माळेत. ");
INSERT INTO hoy_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","सिर्फ मूसा यहोवा अन हात्ती बरूल; लेकीन आंदुर हात्ती बरबाळुल, अदिक दुसरा लॉकुर आऊन सांगुळ म्याकुच बरबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मूसा लॉकुर हात्ती होगकु यहोवा अन सप्पा मातगोळ अदिक सप्पा नियम केळ्स बुट्टुन. आग सप्पा लॉकुर ऊंद स्वर दा माताळ कुरतुर, “यास मातगोळ यहोवा अंदान आ सप्पा मातगोळी नाव मान्सेव.” ");
INSERT INTO hoy_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","आग मूसा यहोवा अन सप्पा वचन लिख्स बुट्टुन; अदिक हुंजकुका येदकु पहाळ इन ल्यालमा ऊंद वेदी अदिक इस्त्राएल इन हन्नेळ गोत्रगोळ अनुसार हन्नेळ खम्भागोळ भी माळसुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","आग आव हापाळ इस्त्राएली जवान मंळसागोळी कळुदुन, यार यहोवा अन साटी होमबली अदिक वस्तागोळ्द मेलबली येर्सदुर. ");
INSERT INTO hoy_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","अदिक मूसा आर्धा रक्ता हुडुकु वाटी दा ईटदुन, अदिक आर्धा वेदी मा सिप्स बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","आग वाचा अन किताब हुडुकु लॉकुरी वाचुसकु केळ्सदुन; अदरी केळकु आंदुर अंदुर, “जो येनारा यहोवा अंदान आ सप्पा मातगोळी नाव माळेव, अदिक आऊन आग्या मान्सेव.” ");
INSERT INTO hoy_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","आग मूसा रक्ता हुडुकु लॉकुर मा सिप्स बुट्टुन, अदिक आंदुर से अंदुन, “नोळी, ईद आ वाचा अन रक्ता हुन, यदरी यहोवा ई सप्पा वचनगोळ मा नीम सांगुळ कट्यान.” ");
INSERT INTO hoy_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","आग मूसा, हारून, नादाब, अबीहू अदिक इस्त्राएलीगोळ्द सत्तर स्याणा लॉकुर म्याकुच होदुर, ");
INSERT INTO hoy_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","अदिक इस्त्राएल इन परमेश्वर उन दर्शन माळदुर; अदिक आऊन काल दिशी नीलमणि इन चौरंग घाई येनतरी ईरोद, जो आकाश इन घाई का स्वच्छ ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","अदिक आव इस्त्राएलीगोळ्द प्रधानगोळ मा कय वाळुसीदील; आग आंदुर परमेश्वर उन दर्शन माळदुर, अदिक तिंदुर कुळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","आग यहोवा मूसा से अंदुन, “पहाळी मा नान हात्ती येरकु बा, अदिक अल्या ईर; अदिक ना नीनी कल्लगोळ्द पाटीगोळ, अदिक तान लिख्सद व्यवस्था अदिक आग्या कोळाईन कि नी आंदरी कलस्या.” ");
INSERT INTO hoy_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","आग मूसा यहोशू हेसुर इनव तान सेवक समेत परमेश्वर उन पहाळ मा येरेदुन. ");
INSERT INTO hoy_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","अदिक स्याणागोळ से आव ईद अंदकु होदुन, “यागासताका नाव नीम हात्ती वापस बरालेव आगासताका नीव ईल्या नाम हादी कायतेला ईरी; अदिक केळी, हारून अदिक हूर नीम सांगुळ आर; अगर यारदारा मुकदमा आदीत रा आंदुर दा हात्ती होगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","आग मूसा पहाळ मा येरेदुन, अदिक बादल पहाळ इक मुचबुळ्त. ");
INSERT INTO hoy_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","आग यहोवा अन्द तेज सीनै पहाळ मा निवास माळ्त, अदिक अद बादल आऊन मा आर दिन ताका मुचकु ईत्त; अदिक सातवा दिशी आव मूसा अक बादल इन बीच दा टु कारदुन. ");
INSERT INTO hoy_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्त्राएलीगोळ्द नजर दा यहोवा अन्द महिमा पहाळ इन चोटी मा प्रचंड बेक्‍की इन घाई कांळ्सकु बिळतोगोद. ");
INSERT INTO hoy_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","आग मूसा बादल इन बीच दा प्रवेश माळकु पहाळ मा येरेदुन. अदिक आव पहाळ मा चालीस दिन अदिक चालीस ईळ्लक ईत्तुन. ");
INSERT INTO hoy_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्त्राएलीगोळ से ईद अनेत कि नान साटी भेंट तरूल यास तान इच्छा देल कोळोद चाहास्यार आ सप्पा मुंदुर से नान भेंट ताकोमेत. ");
INSERT INTO hoy_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","अदिक याता वस्तुगोळ्द भेंट आंदुर से ताकोमोद आद अव ईव हुव; मतलब व्हान्ना, बेळ्ली, पीतळ, ");
INSERT INTO hoy_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","नीळा, जांभळा अदिक क्याचांद रंग इन कपळा, महीन मलमल कपळा, मर्री इन चुट्टी, ");
INSERT INTO hoy_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","क्याचांद रंग देल रंग्सकु म्यांडागोळ्द तोगुल, सूइसगोळ्द तोगुल, बबूल इन हुळ्ली, ");
INSERT INTO hoy_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ऊजुळ इन साटी याण्‍णा, अभिषेक इन याण्णा साटी अदिक सुगन्धित लुबान साटी सुगन्धद्रव्य, ");
INSERT INTO hoy_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","एपोद अदिक चपरास इन साटी सुलैमानी कल्ल, अदिक जळुसोर साटी मणि. ");
INSERT INTO hoy_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","अदिक आंदुर नान साटी ऊंद पवित्रस्थान माळुल कि ना आंदुर बीच दा निवास माळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","जो येनारा ना नीनी तोर्सतीन, मतलब निवासस्थान अदिक अदुर सप्पा सामान इन नमुना, अदुर्दा हिसाब देल नीव लॉकुर अदरी माळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“बबूल इन हुळ्ली इन ऊंद सन्दुक माळकु आगुल; अदुर लंबाई ढाई कय, अदिक चौळाई अदिक ऊचाई दिळ दिळ कय ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","अदिक अदरी शुद्ध व्हान्ना देल बुळ्क अदिक व्हार्या मळुसेतीर, अदिक सन्दुक इन म्याकुच नाकु दी व्हान्ना अन पट्टी बनुसेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","अदिक व्हान्ना अन नाक कळागोळ घळुसकु अदुर नाकु कालगोळ मा, ऊंद दी येढ्ढ कळा अदिक दुसरा दी भी येढ्ढ कळा हचुसेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","बाक बबूल इन हुळ्ली इन कोलगोळ माळसुसेतीर, अदिक अवरी भी व्हान्ना देल मळुसेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","अदिक कोलगोळी सन्दुक इन येढ्ढु दीकळव कळागोळ दा हाकेतीर, यदुर देल अऊर शक्ति देल सन्दुक नेगुकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","अव कोलगोळ सन्दुक इन कळागोळ दा हतकु ईरूल; अदिक अदुर देल अलग माळकु आगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","अदिक जो गवाही इन चिट्टी ना नीनी कोळाईन अदरी अदा सन्दुक दा ईटेत.” ");
INSERT INTO hoy_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“बाक शुद्ध व्हान्ना अन ऊंद प्रायश्चित इन झाकनी माळसुसेतीर, अदुर्द लंबाई ढाई कय, अदिक चौळाई दिळ कय ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","अदिक व्हान्ना मळुसकु येढ्ढ करूब माळसुसकु प्रायश्चित इन झाकनी इन येढ्ढु क्वाना मा हचुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ऊंद करूब ऊंद क्वाना मा अदिक दुसरा करूब दुसरा क्वाना मा हचुसेत; अदिक करूबगोळी अदिक प्रायश्चित इन झाकनी इक ऊंदा तुकळा देल माळकु अदुर्द येढ्ढु क्वाना मा हचुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","आ करूबगोळ्द पंख म्याकुच टु हिंग फैलुस्कु बनसुल कि प्रायश्चित इन झाकनी अऊर देल मुचकु ईरूल, अदिक अऊर मार्रगोळ आमने-सामने अदिक प्रायश्चित इन झाकनी दी ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","अदिक प्रायश्चित इन झाकनी इक सन्दुक इन म्याकुच हचुसेत; अदिक जो गवाही इन चिट्टी ना नीनी कोळाईन अदरी सन्दुक इन बुळ्क ईटेत.” ");
INSERT INTO hoy_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ना अदुर म्याकुच ईतकु नीन से मुलाकात माळतोगाईन; अदिक इस्त्राएलीगोळ्द साटी यास आग्यागोळ नानी नीनी कोळोद बिद्दीत, आ सप्पा अन बारा दा प्रायश्चित इन झाकनी इन म्याकुच टु अदिक आ करूबगोळ्द न्याड्या दा टु, जो गवाही इन चिट्टी इन सन्दुक मा ईत्ताव, नीन से मातकात हेळतोगाईन. ");
INSERT INTO hoy_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“बाक बबूल इन हुळ्ली इन ऊंद मेज माळसुसेत; अदुर लंबाई येढ्ढ कय, चौळाई ऊंद कय, अदिक ऊचाई दिळ कय ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","अदरी शुद्ध व्हान्ना देल मळसुसेत, अदिक अदुर नाकु दी व्हान्ना अन ऊंद पट्टी माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","अदिक अदुर नाकु दी नाक बेळ्ल चौळा ऊंद पटरी माळसुसेत, अदिक ई पटरी इन नाकु दी व्हान्ना अन ऊंद पट्टी माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","अदिक व्हान्ना नव नाक कळा माळसुसकु मेज इन आ नाकु क्वाना दा हचुसेत जो अदुर्द नाकु कालगोळ दा ईत्ताव. ");
INSERT INTO hoy_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","अव कळागोळ पटरी इन हात्ती का ईरूल, अदिक मेज नेगोर साटी कोलगोळ ईटेत. ");
INSERT INTO hoy_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","कोलगोळी बबूल इन हुळ्ली देल माळसुसकु व्हान्ना देल मळसुसेत, अदिक मेज अऊर देला नेगुकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","अदिक अऊर परात अदिक धूपदान, अदिक मग्गागोळ अदिक रीचुसव कटोरीगोळ, सप्पा शुद्ध व्हान्ना अन माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","अदिक मेज मा नान मुंद भेंट इन रोट्टीगोळ हमेशा ईटतोगेत.” ");
INSERT INTO hoy_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“बाक शुद्ध व्हान्ना अन ऊंद दिवट माळसुसेत. ईद दिवट घळुस्द व्हान्ना देल बन्सकु ईरूल; अदुर्द पुष्पकोष, गाठ अदिक फूल, सप्पा ऊंदा तुकळा अन बन्सकु ईरूल; ");
INSERT INTO hoy_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","अदिक अदुर किनारागोळ देल आर डगाली होळुल, मुर डगालीगोळ रा दिवट इन ऊंद दी टु अदिक मुर डगालीगोळ अदुर दुसरा दी टु होटकु ईरूल; ");
INSERT INTO hoy_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ऊंद ऊंद डगाली दा बादाम इन फूल इन घाई मुर मुर पुष्पकोष, ऊंद ऊंद गाठ, अदिक ऊंद ऊंद फूल ईरूल; दिवट दा टु होळ्द आरू डगालीगोळ्द ईदा आकार या रूप ईरूल; ");
INSERT INTO hoy_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","अदिक दिवट इन डण्डी दा बादाम इन फूल इन घाई नाक पुष्पकोष तान तान गाठ अदिक फूल समेत ईरूल; ");
INSERT INTO hoy_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","अदिक दिवट दा टु होळ्द आरू डगालीगोळ दा टु येढ्ढ येढ्ढ डगालीगोळ्द ल्यालमा ऊंद ऊंद गाठ ईरूल, अव दिवट समेत ऊंदा तुकळा अन बन्सकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","अऊर्द गाठगोळ अदिक डगालीगोळ, सप्पा दिवट समेत ऊंदा तुकळा अन ईरूल, शुद्ध व्हान्ना मळुसकु पुरा दिवट ऊंदा तुकळा अन माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","अदिक येळ दिंग्या माळसुसेत; अदिक दिंग्या होताक्कु आगुल कि अव दिवट इन मुंद ऊजुळ कोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","अदुर्द चिमटा अदिक ताटी सप्पा शुद्ध व्हान्ना अन ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","अद सप्पा ई पुरा सामान समेत चौतीस किलो तीम शुद्ध व्हान्ना अन बनसुल. ");
INSERT INTO hoy_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","अदिक सावधान ईतकु ई सप्पा वस्तुगोळी आ नमुना अन घाई माळसुसेत, जो नीनी ई पहाळी मा तोर्सकु आग्याद.” ");
INSERT INTO hoy_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“बाक निवासस्थान इन साटी हत्त पळदागोळ माळसुसेत; ईव निवळुस्द महीन मलमल देल माळ्द नीळा, जांभळा, अदिक क्याचांद रंग इन कपळा अन ईरूल, अदिक ईऊर दा यावारा कुशल कारीगर से करूबगोळ्द कढ़ाई माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ऊंद ऊंद पळदागोळ्द लंबाई आट्ठावीस कय अदिक चौळाई नाक कय इन ईरूल: सप्पा पळदागोळ ऊंदा नाप इनव ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","अईद पळदागोळ आबुर दाबुर देल जुळ्सकु ईरूल; अदिक बाक जो अईद पळदागोळ ईत्ताव अव भी आबुर दाबुर देल जुळ्सकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","अदिक यल ईव येढ्ढु पळदागोळ जोळ्सकु आगुल अल इन येढ्ढु किनारा मा नीळा नीळा फन्दागोळ हचुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","येढ्ढु किनारा दा पचास पचास फन्दागोळ हिंग हचुसेत कि अव आमने-सामने ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","अदिक व्हान्ना नव पचास आकळागोळ माळसुसेत; अदिक पळदागोळी ईवा आकळागोळ देल हिंग जोळसुसेत कि निवासस्थान मिलुसकु ऊंद आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“बाक निवास इन म्याकुच तम्बु उन क्याल्सा कोळोर साटी मर्री इन चुट्टी इन हनुन पळदागोळ माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ऊंद ऊंद पळदा अन लंबाई तीस कय अदिक चौळाई नाक कय इन ईरूल; हनुन इन हनुन पळदागोळ ऊंदा नाप इनव ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","अदिक अईद पळदा अलग अदिक बाक आर पळदागोळ अलग जोळसुसेत, अदिक छटवा पळदा अक तम्बु उन मुंद मुरूकु येढ्ढ माळ बुळेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","अदिक नी पचास आकळागोळ आ पळदागोळ किनारा दा जो व्हार्या टु मिसळुसकु आदीत अदिक पचास अच आकळागोळ दुसरा दिकळोद पळदा अन किनारा दा जो व्हार्या टु मिसळुसकु आदीत माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","अदिक पीतळा अन पचास आकळागोळ माळेत, अदिक आकळागोळी फन्दागोळ दा हचकु तम्बु उक हिंग जोळसुसेत कि अव मिलुसकु ऊंद आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","अदिक तम्बु उन पळदागोळ्द हिलगुसतेला भाग, मतलब जो आर्धा पट ईत्तीत, अद निवास इन हिंदळा भाग दी लटकुस्त ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","अदिक तम्बु उन पळदागोळ्द लंबाई दा टु कय तीम ईत्त, अदिक कय तीम आत्त निवास इन मुच्चोर साटी अदुर्द येढ्ढु दी लटकुस्त ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","बाक तम्बु उन साटी क्याचांद रंग देल रंगुस्द म्यांडागोळ्द तोगुल इन ऊंद होदोद अदिक अदुर म्याकुच सूइसगोळ तोगुल इन भी ऊंद होदोद माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“बाक निवास इक निदरूसोर साटी बबूल इन हुळ्लीगोळ्द तख्तागोळ माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ऊंद ऊंद तख्ता अन लंबाई हत्त कय अदिक चौळाई दिळ कय इन ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ऊंद ऊंद तख्ता दा आबुर दाबुर से जोळ्सद येढ्ढ येढ्ढ चूली ईरूल; निवास इन सप्पा तख्तागोळी ईदा प्रकार देल माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","निवास इन साटी जो तख्तागोळ नी माळसुस्या अऊर दा टु ईप्पत तख्तागोळ रा दक्षिण दिकळोद साटी ईरूल; ");
INSERT INTO hoy_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","अदिक ईप्पत तख्तागोळ ल्यालमा बेळ्ली इन च्यालीस कुर्चीगोळ माळसुसेत, मतलब ऊंद ऊंद तख्तागोळ ल्यालमा अदुर चूलीगोळ साटी येढ्ढ येढ्ढ कुर्चीगोळ. ");
INSERT INTO hoy_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","निवास इन दुसरा दी, मतलब उत्तर दिकळोद साटी ईप्पत तख्तागोळ माळसुसेत; ");
INSERT INTO hoy_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","अदिक अऊर साटी बेळ्ली इन च्यालीस कुर्चीगोळ माळसुसेत, मतलब ऊंद ऊंद तख्तागोळ ल्यालमा येढ्ढ येढ्ढ कुर्चीगोळ ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","निवास इन हिंदळा भाग दी, मतलब पश्चिम दिकळोद साटी आर तख्तागोळ माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","अदिक हिंदळा भाग दा निवास इन क्वानागोळ साटी येढ्ढ तख्तागोळ माळसुसेत; ");
INSERT INTO hoy_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","अदिक ईव ल्यालमा टु येढ्ढ येढ्ढ भाग इनव ईरूल, अदिक येढ्ढु भाग म्याकुच इन क्वाना ताका ऊंद ऊंद कळा दा मिलुसकु आगुल; येढ्ढु तख्तागोळ्द ईदा रूप ईरूल; ईद येढ्ढु क्वाना अन साटी ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","अदिक येठ्ठ तख्तागोळ ईरूल, अदिक अऊर्द बेळ्ली इन सॉळा कुर्चीगोळ ईरूल; मतलब ऊंद ऊंद तख्ता अन ल्यालमा येढ्ढ येढ्ढ कुर्चीगोळ ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“बाक बबूल इन हुळ्ली इन बेंडागोळ माळसुसेत, मतलब निवास इन ऊंद दिकळोद तख्तागोळ साटी अईद, ");
INSERT INTO hoy_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","अदिक निवास इन दुसरा दिकळोद तख्तागोळ साटी अईद बेंडागोळ, अदिक निवास इन जो भाग पश्चिम दी हिंदळा भाग दा ईत्तीत, अदुर साटी अईद बेंडागोळ माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","न्याड्यागोळ्द बेंडा जो तख्तागोळ्द न्याड्या दा ईत्तीत अद तम्बु उन ऊंद क्वाना टु दुसरा क्वाना ताका पोहचुसुल. ");
INSERT INTO hoy_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","बाक तख्तागोळी व्हान्ना देल मळसुसेत, अदिक अऊर्द कळागोळ जो बेंडागोळ्द मान्नोद क्याल्सा कोट्टाव अवरी भी व्हान्ना देल माळसुसेत; अदिक बेंडागोळी भी व्हान्ना देल मळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","अदिक निवास इक ईदा रिति देल निदरूसेत ह्यांग ई पहाळ मा नीनी तोर्सकु आग्याद.” ");
INSERT INTO hoy_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“बाक नीळा, जांभळा अदिक क्याचांद रंग इन अदिक महीन मलमल इन ऊंद न्याड्यागोळ्द पळदा माळसुसेत; यदुर मा कुशल कारीगर उन द्वारा करूब कढ़ाई माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","अदिक अदरी व्हान्ना देल मळुस्द बबूल इन नाक खम्भागोळ मा हिलगुसेत, ईऊर्द आकळागोळ व्हान्ना नव ईरूल, अदिक ईव बेळ्ली इन नाक कुर्चीगोळ मा निदुरकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","अदिक न्याड्यागोळ्द पळदा अक आकळागोळ्द ल्यालमा हिलगुसकु, अदुर आळ दा गवाही इन चिट्टी इन सन्दुक अंदर तरेत, ई प्रकार अद न्याड्यागोळ्द पळदा नीम साटी पवित्रस्थान इक परम पवित्रस्थान दा ब्यार्र माळकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","बाक परम पवित्रस्थान दा गवाही इन चिट्टी इन सन्दुक उन म्याकुच प्रायश्चित इन झाकनी इक ईटेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","अदिक आ पळदा अन व्हार्या निवास इन उत्तर दी मेज ईटेत; अदिक दक्षिण दी मेज इन मुंद दीवट ईटेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","बाक तम्बु उन दरवाजा अन साटी नीळा, जांभळा अदिक क्याचांद रंग इन अदिक महीन मलमल सुक्ष्म सनी इन कपळा अन कढ़ाई इन क्याल्सा माळ्द ऊंद पळदा माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","अदिक ई पळदा अन साटी बबूल इन अईद खम्भागोळ माळसुसेत, अदिक अवरी व्हान्ना देल मळसुसेत; अऊर कळागोळ व्हान्ना नव ईरूल, अदिक अऊर साटी पीतळा अन अईद कुर्चीगोळ ढाल्सकु माळसुसेत.” ");
INSERT INTO hoy_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“बाक वेदी इक बबूल इन हुळ्ली इन, अईद कय ऊद्द अदिक अईद कय चौळा माळसुसेत; वेदी चौकोन ईरूल, अदिक अदुर्द ऊचाई मुर कय इन ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","अदिक अदुर्द नाकु क्वाना मा नाक सींग माळसुसेत; अव अदुर समेत ऊंदा तुकळा नव ईरूल, अदिक अदरी पीतळा देल मळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","अदिक अदुर राखळ नेगोद पात्र, अदिक पावळागोळ, अदिक कटोरागोळ, अदिक काटागोळ, अदिक अंगीठीगोळ माळसुसेत; अदुर सप्पा सामान पीतळा अन माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","अदुर साटी पीतळा अन जाली इन ऊंद पेटी माळसुसेत; अदिक अदुर नाकु क्वाना दा पीतळा अन नाक कळागोळ हचुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","अदिक आ पेटी इक वेदी इन नाकु दिकळोद कंगनी इन ल्यालमा हिंग हचुसेत कि अद वेदी इन ऊचाई इन मध्य ताका पोहचुसुल. ");
INSERT INTO hoy_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","अदिक वेदी इन साटी बबूल इन हुळ्ली इन कोलगोळ माळसुसेत, अदिक अवरी पीतळ देल मळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","अदिक कोलगोळ कळागोळ दा हाक्‍कु आगुल कि याग याग वेदी नेगुकु आगुल आग अव अदुर येढ्ढु किनारा मा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","वेदी इक तखतगोळ से पोकर माळसुसेत; ह्यांग अव ई पहाळ मा नीनी तोर्सकु आग्याद हांगा माळकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“बाक निवास इन आंगुळ इक माळसुसेत. अदुर दक्षिण इन दिकळोद साटी महीन मलमल सूक्ष्म सनी इन कपळा अन पळदागोळ ईरूल, अदुर लंबाई सौ कय इन ईरूल; ऊंद किनारा मा ईटा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","अदिक अऊर साटी ईप्पत खम्भागोळ बनसुल, अदिक ईऊर साटी पीतळा अन ईप्पत कुर्चीगोळ बनसुल, अदिक खम्बागोळ्द कुन्डागोळ अदिक अऊर्द पट्टीगोळ बेळ्ली नव ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","अदिक अदा प्रकार देल आंगुळ इन उत्तर दिकळोद लंबाई दा भी सौ कय ऊद्द पळदागोळ ईरूल, अदिक अऊर साटी भी ईप्पत खम्भागोळ अदिक ईऊर साटी भी पीतळा अन ईप्पत खानागोळ ईरूल; अदिक आ खम्बागोळ्द कुन्डागोळ अदिक पट्टीगोळ बेळ्ली नव ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","बाक आंगुळ इन चौळाई दा पश्चिम दी पचास कय इन पळदागोळ ईरूल, अऊर साटी खम्भागोळ हत्त अदिक खानागोळ भी हत्त ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","पूर्व दी आंगुळ इन चौळाई पचास कय इन ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","आंगुळ इन दरवाजा अन ऊंद दी पंदरा कय इन पळदागोळ ईरूल, अदिक अऊर साटी खम्भागोळ मुर अदिक खानागोळ मुर ईरूल; ");
INSERT INTO hoy_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","अदिक दुसरा दी भी पंदरा कय इन पळदागोळ ईरूल, अऊर साटी भी खम्भागोळ मुर अदिक खानागोळ मुर ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","आंगुळ इन दरवाजा अन साटी ऊंद पळदा माळसुसेत, जो नीळा, जांभळा अदिक क्याचांद रंग इन कपळा अदिक महीन मलमल सूक्ष्म सनी इन कपळा अन कामदार बन्सकु ईप्पत कय इन ईरूल, अदुर साटी खम्भागोळ नाक अदिक खानागोळ भी नाक ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","आंगुळ इन नाकु दिकळव सप्पा खम्भागोळ बेळ्ली इन पट्टीगोळ देल जुळ्सकु ईरूल, अऊर कुन्डागोळ बेळ्ली नव अदिक खानागोळ पीतळा नव ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","आंगुळ इन लंबाई सौ कय इन, अदिक अदुर चौळाई पचास कय इन, अदिक अदुर पळदा अन ऊचाई अईद कय इन ईरूल, अदिक अद महीन मलमल सूक्ष्म सनी इन कपळा अन बनसुल, अदिक खम्बागोळ्द खानागोळ पीतळा नव ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","निवासस्थान इन अलग अलग प्रकार इन बर्तन अदिक सप्पा सामान अदिक अदुर सप्पा खुटागोळ अदिक आंगुळ इनव भी सप्पा खुटागोळ पीतळा नव अच ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","बाक नी इस्त्राएलीगोळी आग्या कोळेत, कि नान हात्ती दीवट इन साटी कुट्सकु तेग्द जैतून इन निर्मल याण्णा तरेतीर, यदुर देल दिंग्या हमेशा होततेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","मिलाप इन तम्बु दा, आ न्याड्यावाळा पळदा देल व्हार्या जो गवाही इन चिट्टी इन मुंद आदीत, हारून अदिक आऊन पारगोळ दीवट द्यावमुळका टु व्हातुर ताका यहोवा अन मुंद सजुसकु ईटुल. ईद विधि इस्त्राएलीगोळ्द पीढ़ीगोळ साटी हमेशा बन्सकु ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“बाक नी इस्त्राएलीगोळ दा टु तान वार्ट हारून, अदिक नादाब, अबीहू, एलीआजर अदिक ईतामार हेसुर इनोर आऊन पारगोळी तान हात्ती तरेत कि आंदुर नान साटी याजक उन क्याल्सा माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","अदिक नी तान वार्ट हारून उन साटी वैभव अदिक शोभा अन निमित्त पवित्र कपळा माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","अदिक यास मुंदुर्द मन दा बुद्धि आद, यारी ना बुद्धि कोळावाळा आत्मा देल परिपुर्ण माळीन, आंदरी नी हारून उन कपळा माळोद आग्या कोळ कि आंदुर नान निमित्त याजक उन क्याल्सा माळोर साटी पवित्र बनसुल. ");
INSERT INTO hoy_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","जो कपळा आंदरी माळव बिद्दाव अव ईव हुव, मतलब छातीबन्द, अदिक एपोद, अदिक बागा, नाक खाना अन अंगरखा, पगळी अदिक कमरबन्द; ईवा पवित्र कपळा नीन वार्ट हारून अदिक आऊन पारगोळ साटी माळकु आगुल कि आंदुर नान साटी याजक उन क्याल्सा माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","अदिक आंदुर व्हान्ना अदिक नीळा अदिक जांभळा अदिक क्याचांद रंग इन अदिक सूक्ष्म सन इन कपळा हुडुल.” ");
INSERT INTO hoy_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“आंदुर एपोद उक व्हान्ना अदिक नीळा, जांभळा अदिक क्याचांद रंग इन कपळा अन अदिक महीन मलमल सूक्ष्म सनी इन कपळा तयार माळुल, जो निपुण कढ़ाई इन क्याल्सा माळावाळा अन कय इन क्याल्सा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","अद ईत्ता प्रकार देल जोळ्सकु आगुल कि अऊर येढ्ढु बाक्का अन क्वानागोळ आपस दा मिलुसकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","अदिक एपोद मा जो कढ़ुक्द पट्टी ईत्तीत अदुर बनावट अदुर्दा घाई ईरूल, अदिक अव येढ्ढु बिना जोळ इन ईरूल, अदिक व्हान्ना अदिक नीळा, जांभळा अदिक क्याचांद रंग इन अदिक महीन मलमल सूक्ष्म सनी इन कपळा अन ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","बाक येढ्ढ सुलैमानी मणि हुडुकु अऊर मा इस्त्राएल इन पारगोळ हेसुर अग्ळुसेत, ");
INSERT INTO hoy_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","आंदुर हेसुरगोळ दा टु आर ऊंद मणि मा अदिक मिग्द आर हेसुर दुसरा मणि मा, इस्त्राएल इन पारगोळ्द उत्पत्ति इन अनुसार अग्ळुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ह्यांग जौहरी मुद्रा मा नक्काशी माळतान हांग अच नी भी येढ्ढ मणिगोळी इस्त्राएल इन पारगोळ्द हेसुर इन अनुसार अग्ळुसेत अदिक अवरी व्हान्ना अन खानगोळ दा जळुस बुळेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","अदिक येढ्ढु मणिगोळी एपोद इन बाक्कागोळ मा हचुसेत,अव इस्त्राएलीगोळ्द याद तोरसुसावाळा मणि ठहरूस्याव; मतलब हारून आंदुर हेसुर यहोवा अन मुंद तान येढ्ढु बाक्कागोळ मा याद साटी हचकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","“बाक व्हान्ना नव खानागोळ माळसुसेत, ");
INSERT INTO hoy_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","अदिक डोरीगोळ घाई गुथुस्द येढ्ढ जंजीर शुद्ध व्हान्ना अन माळसुसेत; अदिक गुथुस्द जंजीरगोळी आ खानागोळ दा जळुसेत.” ");
INSERT INTO hoy_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","बाक न्याय इन चपरास इक भी कढ़ाई इन क्याल्सा अन माळसुसेत, एपोद इन घाई व्हान्ना, अदिक नीळा, जांभळा अदिक क्याचांद रंग इन अदिक महीन मलमल सूक्ष्म सनी इन कपळा अन अदरी माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","अद चौकोन अदिक दोहरी ईरूल, अदिक अदुर लंबाई अदिक चौळाई ऊंद ऊंद बित्ता अन ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","अदिक अदुर दा नाक पंग्ति मणि जळुसेत. पयला पंग्ति दा रा माणिक्य, पुखराज अदिक पन्ना ईरूल; ");
INSERT INTO hoy_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दुसरा पंग्ति दा मरकत, नीलमणि अदिक हीरा: ");
INSERT INTO hoy_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तिसरा पंग्ति दा लशम, सुर्यकांत अदिक नीलम; ");
INSERT INTO hoy_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","अदिक चौथा पंग्ति दा फिरोजा, सुलैमानी मणी अदिक यशब ईरूल; ईव सप्पा व्हान्ना अन खान दा जळुसकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","अदिक इस्त्राएल इन पारगोळ्द यास हेसुर आव आस मणि ईरूल, मतलब मतलब अदुर्द हेसुरगोळ्द गिनती इन अनुसार ह्न्नेळ हेसुर अगळुल, हन्नेळ गोत्र दा टु ऊंद ऊंद उन हेसुर ऊंद ऊंद मणि मा हिंग अगळुल ह्यांग मोहर इन नक्काशी अगुळकु आगतद. ");
INSERT INTO hoy_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","बाक चपरास मा डोरीगोळ घाई गुथुस्द शुद्ध व्हान्ना अन जंजीर हचुसेत; ");
INSERT INTO hoy_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","अदिक चपरास दा व्हान्ना अन येढ्ढ कळीगोळ हचुसेत, अदिक येढ्ढु कळीगोळी चपरास इन येढ्ढु क्वाना मा हचुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","अदिक व्हान्ना नव येढ्ढु जंजीरगोळी आ येढ्ढु कळीगोळ दा जो चपरास इन क्वानागोळ मा ईत्ताव हचुसेत; ");
INSERT INTO hoy_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","अदिक गुथुस्द येढ्ढु जंजीरगोळ्द येढ्ढु मिग्द क्वानागोळी येढ्ढु खानागोळ दा जळुसकु एपोद इन येढ्ढु बाक्कागोळ्द बंधनगोळ मा अदुर मुंद हचुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","बाक व्हान्ना नव मात्त येढ्ढ कळीगोळ माळसुसकु चपरास इन येढ्ढु क्वाना मा, अदुर आ कोर मा जो एपोद इन बुळ्क दी ईत्तीत हचुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","बाक अऊर अलावा व्हान्ना नव मात्त येढ्ढ कळीगोळ माळसुसकु एपोद इन येढ्ढु बाक्कागोळ्द बंधनगोळ मा, ल्यालमा टु अदुर मुंद अदिक अदुर जोळ इन हात्ती एपोद इन कढ़ाई माळ्द पट्टा अन म्याकुच हचुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","अदिक चपरास तान कळीगोळ द्वारा एपोद इन कळीगोळ दा नीळा जाळी देल कटसुसकु आगुल, ई रिति देल अद एपोद इन कढ़ाई माळ्द पट्टा मा बन्सकु ईरूल, अदिक चपरास एपोद मा टु अलग आगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","याग याग हारून पवित्रस्थान दा प्रवेश माळुल, आग आग आव न्याय इन चपरास मा तान दिल इन म्याकुच इस्त्राएलीगोळ्द हेसुरगोळी हचकु ईरूल, यदुर देल यहोवा अन मुंद आंदुर याद हमेशा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","अदिक नी न्याय इन चपरास दा ऊरीम अदिक तुम्मीम इक ईटेत, अदिक याग याग हारून यहोवा अन मुंद बरूल, आग आग अव आऊन दिल इन म्याकुच ईरूल, ई प्रकार देल हारून इस्त्राएलीगोळ साटी यहोवा अन न्याय इक तान दिल इन म्याकुच हमेशा हचकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“बाक एपोद उन बागा अक पुरा नीळा रंग इन माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","अदुर बनावट हिंग ईरूल कि अदुर न्याड्या दा ताल्ला हाक्‍कोर साटी ख्वादरा ईरूल, अदिक आ ख्वादरा अन नाकु दी बख्तर इन ख्वादरा अन घाई ऊंद बुनुस्द कोर ईरूल कि अद हरूतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","अदुर्द ल्यालमागोळ्द घ्यारा दा नाकु दी नीळा, जांभळा अदिक क्याचांद रंग इन कपळा अन अनार माळसुसेत, अदिक अदुर न्याड्या न्याड्या नाकु दी व्हान्ना अन घंटीगोळ हचुसेत, ");
INSERT INTO hoy_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","मतलब ऊंद व्हान्ना अन घंटी अदिक ऊंद अनार, बाक मात्‍त ऊंद व्हान्ना अन घंटी अदिक ऊंद अनार, ईदा प्रकार देल बागा अन ल्यालमागोळ्द घ्यारा दा नाकु दी हिंग अच ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","अदिक हारून आ बागा अक स्यावा टहल माळाहोती हाकुल, कि याग याग आव पवित्रस्थान इन बुळ्क यहोवा अन मुंद होगुल या व्हार्या होळुल, आग आग अदुर्द आवाज केळ बरूल, ईलारा आव सोतोदान.” ");
INSERT INTO hoy_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“बाक शुद्ध व्हान्ना अन ऊंद पट्टी माळसुसेत, अदिक ह्यांग छापा दा हांगा अदुर दा अक्षर अगुळकु आगुल, मतलब ‘यहोवा अन साटी पवित्र.’ ");
INSERT INTO hoy_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","अदिक अदरी नीळा फिता देल कटेत; अदिक अद पगळी इन मुंदळोद हिस्सा मा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","अद हारून उन माथा मा ईरूल, इदुरसाटी कि इस्त्राएली जो येनारा पवित्र ठहरूसुल, मतलब यास पवित्र वस्तुगोळ भेंट दा येर्सुल आ पवित्र वस्तुगोळ्द दोष हारून नेगुतेला ईरूल, अदिक अद हमेशा आऊन माथा मा ईरूल, यदुर देल यहोवा आंदुर से खुश ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","अंगरखा अक सूक्ष्म सनी इन कपळा अन नाक खानावाळा माळसुसेत, अदिक ऊंद पगळी भी सूक्ष्म सन इन कपळा अन माळसुसेत, अदिक बेलबुटा अन कढ़ाई इन क्याल्सा माळ्द ऊंद कमरबन्द भी माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“बाक हारून उन पारगोळ साटी भी अंगरखागोळ अदिक कमरबन्द अदिक टोपीगोळ माळसुसेत; ई कपळागोळ भी वैभव अदिक शोभा अन साटी माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","तान वार्ट हारून अदिक आऊन पारगोळी ईवा कपळागोळ हाकसुसकु आंदुर अभिषेक अदिक संस्कार माळेत, अदिक आंदरी पवित्र माळेत कि आंदुर नान साटी याजक उन क्याल्सा माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","अदिक आंदुर साटी सन इन कपळा अन जंग्यागोळ माळसुसेत यदुर देल आंदुर मय झाक्सकु ईरूल, अव नेळु टु रा जांग ताका अच ईरूल; ");
INSERT INTO hoy_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","अदिक याग याग हारून या आऊन पारगोळ मिलाप इन तम्बु दा प्रवेश माळुल, या पवित्र स्थान दा स्यावा टहल माळली वेदी इन हात्‍ती होगुल, आग आग आंदुर आ जंग्यागोळी हाक्‍कु ईरूल, ईलारा हिंग आगबाळुल कि आंदुर पापी ठहरूसुल अदिक सोतोगुल. ईद हारून उन साटी अदिक आऊन बाद्दा आऊन वंश इन साटी भी हमेशा अन विधी ठहरूसुल.” ");
INSERT INTO hoy_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“आंदरी पवित्र माळली जो क्याल्सा नानी आंदुर सांगुळ माळोद आद कि आंदुर नान साटी याजक इन क्याल्सा माळुल, अद ईद हुन: ऊंद निर्दोष पाड्डा अदिक येढ्ढ निर्दोष म्यांडागोळ हुडेत, ");
INSERT INTO hoy_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","अदिक अखमीरी रोट्टी, अदिक याण्णा देल मुळकुळ्सद मैदा नव अखमीरी फुलकागोळ, अदिक याण्णा देल चुपळुस्द अखमीरी पापळगोळ भी हुडेत. ईव सप्पा गोदी नव मैदा नव माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ईवरी ऊंद फुट्टी दा ईटकु आ फुट्टी इक आ पाड्डा अदिक आ येढ्ढु म्यांडागोळ समेत हात्ती तरेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","बाक हारून अदिक आऊन पारगोळी मिलाप इन तम्बु उन दरवाजा अन हात्ती तंदकु नीर देल मय तोळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","आग आ फळक्यागोळी हुडुकु हारून उक अंगरखा अदिक एपोद इन बागा हाकसुसेत,अदिक एपोद अदिक चपरास कटेत, अदिक एपोद इन घळुस्द पट्टा भी कटेत; ");
INSERT INTO hoy_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","अदिक आऊन ताल्ला मा पगळी इक ईटेत, अदिक पगळी मा पवित्र मुकुट इक ईटेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","आग शुद्ध याण्णा हुडुकु आऊन ताल्ला मा हाक्कु आऊक निवळुसेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","बाक आऊन पारगोळी हात्ती तनकु आंदरी अंगरखा हाकसुसेत, ");
INSERT INTO hoy_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","अदिक आंदुर मतलब हारून अदिक आऊन पारगोळ्द नेळु कटेत अदिक आंदुर ताल्ला मा टोपीगोळ ईटेत; यदुर देल याजक इन पद मा हमेशा आंदुर हक्क ईरूल. ई प्रकार हारून अदिक आऊन पारगोळ्द संस्कार माळेत.” ");
INSERT INTO hoy_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“आग पाड्डा अक मिलाप इन तम्बु उन मुंद तरेत. हारून अदिक आऊन पारगोळ पाड्डा अन ताल्ला मा तान तान कय ईटुल, ");
INSERT INTO hoy_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","आग आ पाड्डा अक यहोवा अन हात्ती मिलाप इन तम्बु उन दरवाजा मा बलि येर्सेत, ");
INSERT INTO hoy_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","अदिक पाड्डा अन रक्ता दा टु थ्वाळासा ताकोमकु तान बेळ्ल देल वेदी इन सींगगोळ मा हचेत, अदिक मिग्द सप्पा रक्ता अक वेदी इन पाया मा रीचुस बुळेत, ");
INSERT INTO hoy_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","अदिक याता चरबी देल अतळीगोळ होचकु ईरताव, अदिक जो झिल्ली ईरग्या अन म्याकुच ईरतद, अवरी अदिक येढ्ढु गुर्दागोळी अऊर म्याकळोद चरबी समेत हुडुकु सप्पा अक वेदी मा होताकेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","लेकीन पाड्डा अन मास, अदिक तोगुल, अदिक शेंगणी, छपर्या दा टु व्हार्या बेक्‍की दा होताक बुळेत; यतिकी ईद पापबली ईत्तीत.” ");
INSERT INTO hoy_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“बाक ऊंद म्यांडा हुडेत, अदिक हारून अदिक आऊन पारगोळ अदुर्द ताल्ला मा तान तान कय ईटुल, ");
INSERT INTO hoy_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","आग आ म्यांडा अक बलि येर्सेत, अदिक अदुर्द रक्ता हुडुकु वेदी मा नाकु दी सिप्सेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","आग आ म्यांडा अक तुकळा तुकळा दा कडेत, अदिक अदुर्द पासळीगोळ अदिक कालगोळी तोळुकु अदुर्द तुकळा अदिक ताल्ला अन म्याकुच ईटेत, ");
INSERT INTO hoy_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","अदिक आ पुरा म्यांडा अक वेदी मा होताकेत; अद रा यहोवा अन साटी होमबली आदीत; अद सुखदायक सुगन्ध अदिक यहोवा अन साटी हवन आदीत.” ");
INSERT INTO hoy_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","बाक दुसरा म्यांडा अक हुडेत; अदिक हारून अदिक आऊन पारगोळ अदुर्द ताल्ला मा तान तान कय ईटुल, ");
INSERT INTO hoy_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","आग आ म्यांडा अक बलि येर्सेत, अदिक अदुर्द रक्ता दा टु थ्वाळासा हुडुकु हारून अदिक आऊन पारगोळ्द ऊजवा कीव इन म्याकुच, अदिक आंदुर्द ऊजवा कय अदिक ऊजवा काल इन धोळ्द बेळ्ल मा हचेत, अदिक रक्ता अक वेदी मा नाकु दी सिप्स बुळेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","बाक वेदी माकळोद रक्ता अदिक अभिषेक इन याण्णा, ई येढ्ढु दा टु थ्वाळा थ्वाळा हुडुकु हारून अदिक आऊन पारगोळ, अदिक आंदुर्द कपळागोळ मा भी सिप्स बुळेत; आग आव अदिक आऊन पारगोळ भी, तान तान कपळागोळ समेत पवित्र आगेदार. ");
INSERT INTO hoy_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","आग म्यांडा अक संस्कार इन जान्सकु अदुर दा टु चरबी अदिक मोटा पुछी इक, अदिक याता चरबी देल पासळीगोळ होचकु ईरताव अदरी, अदिक कलेजा माकळोद झिल्ली इक, अदिक चरबी समेत येढ्ढु गुर्दागोळी, अदिक ऊजवा जांघ इक हुडेत, ");
INSERT INTO hoy_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","अदिक अखमीरी रोट्टी इन फुट्टी जो यहोवा अन मुंद ईटकु ईत्तीत अदुर दा टु भी ऊंद रोट्टी, अदिक याण्णा देल मुच्द मैदा अन ऊंद फुलका, अदिक ऊंद पापळ हुडुकु, ");
INSERT INTO hoy_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ई सप्पा अक हारून अदिक आऊन पारगोळ्द कयगोळ दा ईटकु आलगाळ्सकु आगोद भेंट ठहरूसकु यहोवा अन मुंद आलगाळ्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","आग आ वस्तुगोळी आंदुर कयगोळ दा टु हुडुकु होमबली इन वेदी मा होताक बुळेत, यदुर देल अद यहोवा अन मुंद सुखदायक सुगन्ध ठहरूसुल; अद यहोवा अन साटी हवन आदीत. ");
INSERT INTO hoy_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","बाक हारून इन संस्कार इन जो म्यांडा ईत्तीत अदुर्द याद्दा अक हुडुकु आलगाळ्सकु आगोद भेंट इन साटी यहोवा अन मुंद आलगाळ्सेत; अदिक अद नीन भाग ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","अदिक हारून अदिक आऊन पारगोळ्द संस्कार इन जो म्यांडा ईत्तीत, अदुर दा टु आलगाळ्सकु आगोद भेंट इन याद्दा जो आलगाळ्सकु आदीत, अदिक नेगुकु आगोद भेंट इन जांघ जो नेगुकु आदीत, ई येढ्ढु उक पवित्र ठहरूसेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","अदिक ईद हमेशा अन विधि इन रिति मा इस्त्राएलीगोळ्द दी टु आऊन अदिक आऊन पारगोळ्द भाग ठहरूसुल यतिकी ईव नेगुकु आगोद भेटगोळ ठहरूस्याव; अदिक ईद इस्त्राएलीगोळ्द दी टु आंदुर्द मेलबलीगोळ दा टु यहोवा अन साटी नेगुकु आगोद भेंट ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“हारून नव जो पवित्र कपळा ईत्ताव अव आऊन बाद्दा आऊन पारगोळ नातुगोळी सिकतेला ईरूल, यदुर देल अवरी का हाकतेला आंदुर अभिषेक अदिक संस्कार माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","आऊन पारगोळ दा टु जो आऊन जागा मा याजक आदान, आव याग पवित्रस्थान दा स्यावा टहल माळली मिलाप इन तम्बु दा पयले बरूल, आग आ कपळागोळी येळ दिन ताका हाक्कु ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“बाक याजक इन संस्कार इन जो म्यांडा ईत्तीत अदरी हुडुकु अदुर मास यातारा पवित्रस्थान दा बेईसेतीर; ");
INSERT INTO hoy_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","आग हारून तान पारगोळ समेत आ म्यांडा अन मास अदिक फुट्टी इन रोट्टी, येढ्ढु उक मिलाप इन तम्बु उन दरवाजा मा तिनुल. ");
INSERT INTO hoy_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","याता पदार्थ देल आंदुर संस्कार अदिक आंदरी पवित्र माळोर‍ साटी प्रायश्चित माळकु आदीत अवरी रा आंदुर तिनुल, लेकीन पराया कुल इन यावारा अवरी तिनबाळुल, यतिकी अव पवित्र ईत्ताव. ");
INSERT INTO hoy_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","अगर संस्कार इन मास या रोट्टी दा टु थ्‍वाळासा व्हातुर ताका मिक्‍कु ईरूल, रा आ मिग्द मास या रोट्टी इक बेक्‍की दा होताकेतीर, अद तिनकु आगबाळुल; यतिकी अद पवित्र ईत्तीत.” ");
INSERT INTO hoy_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ना नीनी जो जो आग्या कोटीन; आ सप्पा अन अनुसार नी हारून अदिक आऊन पारगोळ से माळेत; अदिक येळ दिन ताका आंदुर संस्कार माळतेला ईरेत, ");
INSERT INTO hoy_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","मतलब पापबली इन ऊंद पाड्डा प्रायश्चित इन साटी हर रोज येर्सेत. वेदी इक भी प्रायश्चित माळा घनी शुद्ध माळेत, अदिक अदरी पवित्र माळोर साटी आंदुर अभिषेक माळेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","येळ दिन ताका वेदी इन साटी प्रायश्चित माळकु अदरी पवित्र माळेत, अदिक वेदी परमपवित्र ठहरूसीत; अदिक जो येनारा अदुर से मुटकु आदीत अद भी पवित्र आगेदीत.” ");
INSERT INTO hoy_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“जो वेदी मा हमेशा येर्सव बिद्दाव अव ईव हुव: हर रोज ऊंद ऊंद साल इनव येढ्ढ भेड़ इन पाड्डागोळ. ");
INSERT INTO hoy_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ऊंद भेड़ इन पाड्डा अक रा हुंजकुका, अदिक दुसरा भेड़ इन पाड्डा अक द्यावमुळका होती येर्सेत; ");
INSERT INTO hoy_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","अदिक पयला भेड़ इन पाड्डा अन सांगुळ हीन इन चौथाई कुटकागोळ होळ्द याण्णा देल मुच्द एपा अन दसवा भाग मैदा, अदिक अर्घ इन साटी हीन इन चौथाई अंगुर इन रास्सा कोळेत. ");
INSERT INTO hoy_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","अदिक दुसरा भेड़ इन पाड्डा अक द्यावमुळका अन होती येर्सेत, अदिक अदुर सांगुळ हुंजकुका अन रिति इन अनुसार अन्नबलि अदिक अर्घ येढ्ढु कोळेत, यदुर देल अद सुखदायक सुगन्ध अदिक यहोवा अन साटी हवन ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","नीम पीढ़ो अन पीढ़ी दा यहोवा अन मुंद मिलाप इन तम्बु उन दरवाजा मा नित्य हिंगा होमबली आग्त ईरूल; ईद अद जागा हुन यदुर दा ना नीम लॉकुर से इदुरसाटी सिकतोगाईन कि नीन से मातगोळ माळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ना इस्त्राएलीगोळ से अल्या सिकतोगाईन अदिक अद तम्बु नान तेज देल पवित्र माळकु आदीत; ");
INSERT INTO hoy_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","अदिक ना मिलाप इन तम्बु अदिक वेदी इक पवित्र माळाईन, अदिक हारून अदिक आऊन पारगोळी भी पवित्र माळाईन कि आंदुर नान साटी याजक उन क्याल्सा माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","अदिक ना इस्त्राएलीगोळ न्याड्या निवास माळाईन, अदिक आंदुर परमेश्वर ठहरूसाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","आग आंदुर अर्त कोंडार कि ना यहोवा आंदुर परमेश्वर हुईन, जो आंदरी मिस्त्र द्याश दा टु तेगुकु तंदीन कि आंदुर न्याड्या निवास माळाईन; ना अच आंदुर परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“बाक धूप होताकोर साटी बबूल इन हुळ्ली इन वेदी बनुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","अदुर लम्बाई ऊंद कय अदिक चौळाई ऊंद कय इन ईरूल, अद चौकोन ईरूल, अदिक अदुर ऊचाई येढ्ढ कय इन ईरूल, अदिक अदुर सींग अदुर्दा तुकळागोळ देल बन्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","अदिक वेदी इन म्याकळव पल्लागोळ अदिक नाकु दीकळव बाजुगोळ अदिक सींगगोळी शुद्ध व्हान्ना देल मळुसेत, अदिक इदुर नाकु दी व्हान्ना अन ऊंद बाळ बनुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","अदिक इदुर बाळ इन ल्यालमा इदुर आमने सामने अन येढ्ढु पल्लागोळ मा व्हान्ना अन येढ्ढ येढ्ढ कळागोळ बन्सकु इदुर येढ्ढु दी हचेत, अव इदुर्द नेगव डंडागोळ खानागोळ्द क्याल्सा कोट्टाव. ");
INSERT INTO hoy_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","डंडागोळी बबूल इन हुळ्ली इन बन्सकु अवरी व्हान्ना देल मळुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","अदिक नी अदरी आ पळदा अन मुंद ईटेत जो गवाही इन चिट्टी इन सन्दुक इन मुंद आद, मतलब प्रायश्चित इन झाकनी इन मुंद जो गवाही इन चिट्टी इन म्याकुच आद, अल्या ना नीन से मुलाकात माळतोगाईन. ");
INSERT INTO hoy_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","अदिक अदा वेदी मा हारून सुगन्धित धूप होताकुल; हर रोज हुंजकुका याग आव दिंग्या अक ठीक माळुल आग आव धूप होताकुल, ");
INSERT INTO hoy_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","अदिक द्यावमुळका अन होती याग हारून दिंग्यागोळी होताकुल आग धूप होताकतेला ईरूल, ईद धूप यहोवा अन मुंद नीम पीढ़ोन पीढ़ी दा नित्य होताक्कु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","आ वेदी मा नीव यातोदारा दुसरा प्रकार इन धूप होताक बाळेतीर, अदिक ना अदुर मा होमबली अदिक ना अन्नबलि येर्सेतीर; अदिक ना अदुर मा अर्घ कोळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","हारून साल दा ऊंद घन इदुर सींगगोळ मा प्रायश्चित माळुल; अदिक नीम पीढ़ोन पीढ़ी दा साल दा ऊंद घन प्रायश्चित इन पापबली इन रक्ता देल इदुर मा प्रायश्चित माळकु आगुल; ईद यहोवा अन साटी परमपवित्र आद.” ");
INSERT INTO hoy_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","आग यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“याग नी इस्त्राएलीगोळ्द गिनती ताकोमली हत्या, आग आळा होती यार्द गिनती आगीदाद आंदुर तान तान जीवा अन साटी यहोवा अक प्रायश्चित इन शुल्क कोळुल, यदुर देल याग नी आंदुर गिनती माळतेला ईत्या आ समय यातोदारा विपत्ति आंदुर मा बंदकु बिळबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","यास लॉकुर आळ्दकु आदार आंदुर पवित्रस्थान इन शेकेल इन अनुसार आर्धा शेकेल कोळुल ईद शेकेल ईप्पत गेरा अन ईरतद, यहोवा अन भेंट आर्धा शेकेल ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ईप्पत साल या अदुर से यक्कुल अवस्था नोर यास आळ्दकु आगुल आंदुर दा टु ऊंद ऊंद मंळसा यहोवा अक शुल्क कोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","याग नीम जीवा अन प्रायश्चित इन निमित्त यहोवा अन भेंट अर्पित माळकु आगुल, आग ना रा अमिर लॉकुर आर्धा शेकेल से यक्कुल कोळुल; अदिक ना गरीब लॉकुर अदुर से गोर्त कोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","अदिक नी इस्त्राएलीगोळ से प्रायश्चित इन रूपये ताकोमकु मिलाप इन तम्बु उन क्याल्सा दा हचेत; यदुर देल अद यहोवा अन मुंद इस्त्राएलीगोळ्द स्मरणार्थ चिन्ह ठहरूसुल, अदिक आंदुर जीवगोळ्द प्रायश्चित भी आगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“तोळोर साटी पीतळा अन ऊंद हौदी, अदिक अदुर पाया भी पीतळा अन बनुसेत. अदरी मिलाप इन तम्बु अदिक वेदी इन न्याड्या दा ईटकु अदुर दा नीर तुम बुळेत; ");
INSERT INTO hoy_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","अदिक अदुर दा हारून अदिक आऊन पारगोळ तान तान कय काल तोळु तोगुल. ");
INSERT INTO hoy_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","याग याग आंदुर मिलाप इन तम्बु दा प्रवेश माळुल आग आग आंदुर कय काल नीर देल तोळुल, ईलारा सोतोदार; अदिक याग याग आंदुर वेदी इन हात्ती स्यावा टहल माळली, मतलब यहोवा अन साटी हवन होताकली बरूल आग आग आंदुर कय काल तोळुल, हिंग आगबाळुल कि आंदुर सोतोगुल. ");
INSERT INTO hoy_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ईद हारून अदिक आऊन पीढ़ोन पीढ़ी इन वंश इन साटी हमेशा अन विधि ठहरूसुल.” ");
INSERT INTO hoy_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“नी वळ्लीद से वळ्लीद सुगन्धद्रव्य कोम, मतलब पवित्रस्थान इन शेकेल इन अनुसार अईद सौ लुबान तान ताना होळ्द गन्धरस, अदिक अदुर आर्धा, मतलब ढाई सौ शेकेल सुगन्धित कलमी, अदिक ढाई सौ शेकेल सुगन्धित अगर, ");
INSERT INTO hoy_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","अदिक अईद सौ शेकेल तेजपान, अदिक ऊंद हीन जैतून इन याण्णा कोंडकु ");
INSERT INTO hoy_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","अऊर से अभिषेक इन पवित्र याण्णा, मतलब गन्धरस इन रिति देल तयार माळ्द सुगन्धित याण्णा माळसुसेत; ईद अभिषेक इन पवित्र याण्णा ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","अदिक अदुर देल मिलाप इन तम्बु उन, अदिक गवाही इन चिट्टी इन सन्दुक इन, ");
INSERT INTO hoy_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","अदिक सप्पा सामान समेत मेज इन, अदिक सामान समेत दीवट इन, अदिक धूपवेदी इन, ");
INSERT INTO hoy_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","अदिक सप्पा सामान समेत होमबली वेदी इन, अदिक पाया समेत गंगार इन अभिषेक माळेत, ");
INSERT INTO hoy_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","अदिक अवरी पवित्र माळेत, यदुर देल अव परमपवित्र ठहरूसुल; अदिक जो येनारा अऊर से मुटकु आदीत अद पवित्र आगेदीत. ");
INSERT INTO hoy_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","बाक हारून उन आऊन पारगोळ सांगुळ अभिषेक माळेत, अदिक ई प्रकार देल आंदरी नान साटी याजक इन क्याल्सा माळोर साटी पवित्र माळेत. ");
INSERT INTO hoy_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","अदिक इस्त्राएलीगोळी नान ईद आग्या केळसेत, ‘ईद याण्णा नीम पीढ़ोन पीढ़ी दा नान साटी पवित्र अभिषेक इन याण्णा आदीत. ");
INSERT INTO hoy_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ईद यातारा मंळसा अन मय मा हाक्कु आगबाळुल, अदिक मिलावट दा अदुर घाई मात्त येनु माळ बाळेतीर; ईद पवित्र आद, ईद नीम साटी भी पवित्र आदीत. ");
INSERT INTO hoy_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जो यावारा ईदुर घाई येनारा बनुसुल, या जो यावारा ईदुर दा टु येनारा पराया कुलवाळेर मा हचुल, आव तान लॉकुर दा टु नष्ट माळकु आगुल.’” ");
INSERT INTO hoy_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","बाक यहोवा मूसा से अंदुन, “बोल, नखी अदिक कुन्दरू, ईव सुगन्धद्रव्य शुद्ध लुबान समेत कोमेत, ईव सप्पा ऊंद तवल इनव ईरूल, ");
INSERT INTO hoy_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","अदिक ईऊर धूप मतलब ऊप्प मिसळुसकु गन्धी इन रिति इन अनुसार शुद्ध अदिक पवित्र सुगन्धद्रव्य माळसुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","बाक अदुर दा टु थ्वाळासा पिसुसकु बारीक माळकु हाकेत, आग अदुर दा टु थ्वाळासा मिलाप इन तम्बु दा गवाही इन चिट्टी इन मुंद, यल ना नीन से मुलाकात माळतोगाईन, ईटेत; अद नीम साटी परमपवित्र आदीत. ");
INSERT INTO hoy_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","जो धूप नी माळसुस्या, मिलावट दा अदुर घाई नीव लॉकुर तान साटी मात्त येनारा माळ बाळेतीर; अद नीम मुंद यहोवा अन साटी पवित्र आदीत. ");
INSERT INTO hoy_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","जो यावारा वास ताकोमोर साटी अदुर घाई येनारा बनुसुल आव तान लॉकुर दा नष्ट माळकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“केळ, ना ऊरी इन पार बसलेल उक, जो हूर उन नातु अदिक यहूदा अन गोत्र नव हुन, हेसुर ताकोमकु कारूतीन. ");
INSERT INTO hoy_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","अदिक ना आऊक परमेश्वर उन आत्मा देल जो बुद्धि, हुनर, ग्यान, अदिक हर प्रकार इन क्याल्सागोळ्द समझ कोळावाळा आत्मा हुन, परिपुर्ण माळतीन, ");
INSERT INTO hoy_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","यदुर देल आव कारीगरी इन क्याल्सा बुद्धि देल तेगु तेगुकु हर प्रकार इन बनावट दा, मतलब व्हान्ना, बेळ्ली, अदिक पीतळा दा, ");
INSERT INTO hoy_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","अदिक जळुसोर साटी मणि कळदुर दा, अदिक हुळ्ली मा नकाशा अन क्याल्सा माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","अदिक केळ, ना दान इन गोत्रवाळेर अहीसामाक उन पार ओहोलीआब उक आऊन सांगुळ माळ बुळतीन; उलटा यास दिमागदार आर आ सप्पा मुंदुर दिल दा ना बुद्धि कोळतीन, यदुर देल यास वस्तुगोळ्द आग्या ना नीनी कोटीन आ सप्पा अक आंदुर बनुसुल; ");
INSERT INTO hoy_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","मतलब मिलाप इन तम्बु, अदिक गवाही इन चिट्टी इन सन्दुक अदिक अदुर माकळोद प्रायश्चित इन झाकनी अदिक तम्बु उन सप्पा सामान, ");
INSERT INTO hoy_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","अदिक सामान समेत मेज, अदिक सप्पा समान समेत शुद्ध व्हान्ना अन दीवट, अदिक धूपवेदी, ");
INSERT INTO hoy_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","अदिक सप्पा सामान समेत होमबली वेदी, अदिक पाया समेत गंगार, ");
INSERT INTO hoy_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","अदिक होलदव कपळा, अदिक हारून याजक उन याजकवाळा क्याल्सा नव पवित्र कपळा, अदिक आऊन पारगोळ्द कपळा, ");
INSERT INTO hoy_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अदिक अभिषेक इन याण्णा, अदिक पवित्रस्थान इन साटी सुगन्धित धूप, अदिक ई सप्पा अक आंदुर आ सप्पा आग्यागोळ्द अनुसार बनुसुल जो ना नीनी कोटीन.” ");
INSERT INTO hoy_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“नी इस्त्राएलीगोळ से ईद भी अनेत, ‘निश्चय नीव नान विश्राम दिनगोळी मान्सेतीर, यतिकी नीम पीढ़ोन पीढ़ी दा नान अदिक नीम लॉकुर न्याड्या ईद ऊंद चिन्ह ठहरूस्याद, यदुर देल नीव ईद मात याद ईटी कि यहोवा नाम पवित्र माळावाळा हुन. ");
INSERT INTO hoy_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ई कारण नीव विश्राम दिन इक मान्सेतीर, यतिकी आव नीम साटी पवित्र ठहरूस्यान; जो आऊक अपवित्र माळुल आव जरूर कोन्सुसकु आगुल: जो यावारा आ दिनगोळ दा येनारा क्याल्सा-कळी माळुल आ मंळसा तान लॉकुर न्याड्या दा टु नष्ट माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","आर दिन रा क्याल्सा-कळी माळकु आगुल, लेकीन सातवा दिन परम विश्राम इन दिन अदिक यहोवा अन साटी पवित्र आद; इदुरसाटी जो यावारा विश्राम इन दिन दा येनारा क्याल्सा-कळी माळुल आव जरूर कोन्सुसकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इदुरसाटी इस्त्राएली विश्राम दिन इन मान्सतोगुल, उलटा पीढ़ोन पीढ़ी दा अदरी हमेशा अन वाचा अन विषय जान्सकु मानसुल. ");
INSERT INTO hoy_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","अद नान अदिक इस्त्राएलीगोळ न्याड्या दा हमेशा ऊंद चिन्ह ईत्तीत, यतिकी आर दिन दा यहोवा आकाश अदिक धरती इक बनुसदुन, अदिक सातवा दिशी विश्राम माळकु तान जीव ठंडा माळदुन.’” ");
INSERT INTO hoy_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","याग परमेश्वर मूसा से सीनै पहाळी मा हिंग मात माळ कोंडुन, आग आव आऊक तान बेळ्ल देल लिख्सद गवाही कोळावाळा कल्ल इन येढ्ढु तखतगोळ कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","याग लॉकुर नोळदुर कि मूसा अक पहाळी मा टु ईळुली समय हतेत्याद, आग आंदुर हारून उन हात्ती जमा आगकु अनली हतदुर, “ईग नाम साटी देवता माळ, जो नाम मुंद मुंद नळुल; यतिकी आ मंळसा मूसा अक जो नामी मिस्त्र द्याश दा टु तेगुकु तंदान, नाव जान्सालेव कि येन आग्याद?” ");
INSERT INTO hoy_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","हारून आंदुर से अंदुन, “नीम हिंग्सुर अदिक पार पोरगोळ्द किवगोळ दा व्हान्ना अन जो बालीगोळ आव अवरी ईळसी, अदिक नान हात्ती तरी.” ");
INSERT INTO hoy_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","आग सप्पा लॉकुर आंदुर किवगोळ दा टु व्हान्ना अन झुक्कागोळ ईळ्सदुर, अदिक हारून उन हात्ती तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","हारून झुमकागोळ आंदुर कय देल ताकोंडुन, अदिक अवरी पिघलुसकु ऊंद साचा दा व्हान्ना हाकदुन, अदिक व्हान्ना अन ऊंद पाड्डा बनुसदुन. आग लॉकुर अनली हतदुर, “हे इस्त्राएल, नीन ईश्वर जो नीनी मिस्त्र द्याश दा टु बिळ्सकु तंदान, आव ईवा हुन.” ");
INSERT INTO hoy_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ईद नोळकु कि हारून अदुर मुंद ऊंद वेदी माळसुसदुन; अदिक ईद प्रचार माळदुन, “नाळ यहोवा अन साटी हाब्बा ईत्तीत.” ");
INSERT INTO hoy_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","अदिक दुसरा दिशी लॉकुर हुंजकुका येदकु होमबली येर्सुल, अदिक मेलबली तरूल; बाक कुर्तकु तिंदुर कुळदुर, अदिक येदकु गलत क्याल्सा माळली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","आग यहोवा मूसा से अंदुन, “ल्यालमा ईळदोग, यतिकी नीन प्रजा अन लॉकुर, यारी नी मिस्त्र द्याश दा टु तेगुकु तंद्या, आंदुर बिगळुसेग्यार; ");
INSERT INTO hoy_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","अदिक याता हादी मा नळोद आग्या ना आंदरी कोटीदीन अदरी राटनेरी बिटकु आंदुर ऊंद पाड्डा घळुसकु माळ बुट्टुर, बाक अदरी दण्डवत माळदुर, अदिक अदुर साटी बलि भी येर्सदुर, अदिक ईद अंदार, ‘हे इस्त्राएलीगोळा, नीम ईश्वर जो नीमी मिस्त्र द्याश दा टु बिळ्सकु तंदान आव ईवा हुन.’” ");
INSERT INTO hoy_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","बाक यहोवा मूसा से अंदुन, “ना ई लॉकुरी नोळदीन, अदिक केळ, आंदुर जिद्दी आर. ");
INSERT INTO hoy_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ईग नानी रोक्सबाळ, नान कोप आंदुर मा भळकुसकु येदाद यदुर देल ना आंदरी भस्म माळाईन; लेकीन नीन देल ऊंद धोळ्द वंश पैदा माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","आग मूसा तान परमेश्वर यहोवा अक ईद अंदकु मनुसली हतदुन, “हे यहोवा, नीन कोप तान प्रजा मा येती भळकुसकु येदाद यदुर देल नी धोळ्द सामर्थ्य अदिक बलवन्त कय इन द्वारा मिस्त्र द्याश दा टु तेगुकु तंद्या? ");
INSERT INTO hoy_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मिस्त्री लॉकुर ईद ईला अन पायजे, ‘आव आंदरी बेकार अभिप्राय देल मतलब पहाळगोळ दा घात माळकु धरती मा टु मिटुस बुळोद मनसा देल तेगुकु ओतुन?’ नी तान भळकुस्द कोप इक शांत माळ, अदिक तान प्रजा अक ईत्ता हानि माळबाळ. ");
INSERT INTO hoy_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","तान दास अब्राहम, इसहाक, अदिक इस्त्राएल इक याद माळ यार देल नी तांदा किर्‍या तिनकु ईद अंदीद, ‘ना नीम वंश इक आकाश इन तारागोळ्द तुल्य हापाळ बनुसाईन, अदिक ईद पुरा द्याश यार्द ना चर्चा माळीन नीम वंश इक कोळाईन कि आंदुर अदुर अधिकारी हमेशा बन्सकु ईरूल.’” ");
INSERT INTO hoy_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","आग यहोवा तान प्रजा अन हानि माळदुर देल जो आव अंदीदुन पछतासदुन. ");
INSERT INTO hoy_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","आग मूसा तिर्गकु गवाही इन येढ्ढु पाटीगोळी कय दा हुडुकु पहाळी मा टु ईळ्दोदुन. आ पाटीगोळ्द येढ्ढु बाजु दी लिख्सकु ईरोद, ");
INSERT INTO hoy_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","अदिक आ पाटीगोळ परमेश्वर उन बनुस्द ईरव, अदिक अऊर मा जो नळ्सकु लिख्सकु ईरोद अद परमेश्वर उन लिख्सद ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","याग यहोशू अक लॉकुर्द कलकल इन शब्द केळ बत्त, आग आव मूसा से अंदुन, “छावनी दा टु लळाई इन घाई शब्द केळ बरेत्याद.” ");
INSERT INTO hoy_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","आव अंदुन, “ईद जो शब्द आद अद ना रा जीतुसावाळेर्द हुन, अदिक ना हारूसावाळेर्द हुन; नानी रा हाळ इन शब्द केळ बरेत्याद.” ");
INSERT INTO hoy_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","छावनी इन हात्ती बरतेला अच मूसा अक आ पाड्डा अदिक कुणोद कांळ्सकु बिळ्त, आग मूसा अन कोप भळकुसकु येळ्त, अदिक आव पाटीगोळी तान कय देल पहाळी इन ल्‍यालमा आपटुसकु मुर्द बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","आग आव आंदुर्द माळ्द पाड्डा अक हुडुकु बेक्‍की दा हाक्कु होताक बुट्टुन. अदिक आरूकु चकनाचुर माळदुन, अदिक नीर इन म्याकुच भिट्ट बुट्टुन, अदिक इस्त्राएलीगोळी अदरी कुळसुस बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","आग मूसा हारून से अनली हतदुन, “ई लॉकुर नीन सांगुळ येन माळदुर कि नी ईंदरी ईसतोळीद धोळ्द पाप दा फसुस्द?” ");
INSERT INTO hoy_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारून उत्तर कोट्टुन, “नान स्वामी इन कोप भळकुस बाळुल; नी रा ई लॉकुरी जान्सत्या अच कि ईंदुर बुराई दा मन हचकु ईरतार. ");
INSERT INTO hoy_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","अदिक आंदुर नान से अंदुर, ‘नाम साटी देवता माळ जो नाम मुंद मुंद नळुल; यतिकी आ मंळसा मूसा अक, जो नामी मिस्त्र द्याश दा टु बिळ्सकु तंदान, नाव अरालेव कि येन आत?’ ");
INSERT INTO hoy_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","आग ना आंदुर से अंदीन, यार यार हात्ती व्हान्ना बेळ्ली आव, आंदुर अवरी ईळ्सकु तरूल; अदिक याग आंदुर नानी अवरी कोट्टुर, ना अवरी बेक्‍की दा हाक्क बुट्टीन, आग ईद पाड्डा होटकु बत्त.” ");
INSERT INTO hoy_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","हारून आ लॉकुरी हिंग खुला माळ बुटीदुन कि आंदुर तान विरोधीगोळ्द बीच दा उपास इन योग्य आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","आंदरी खुला नोळकु मूसा छावनी इन निकास मा निदुरकु अंदुन, “जो यावारा यहोवा अन दीकळव आन आव नान हात्ती बरूल;” आग सप्पा लेवीगोळ आऊन हात्ती जमा आदुर. ");
INSERT INTO hoy_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","आव आंदुर से अंदुन, “इस्त्राएल इन परमेश्वर यहोवा ईद अनतान कि तान तान नेळु मा तलवार हीलगुसकु छावनी इन ऊंद निकास टु दुसरा निकास ताका तिर्ग तिर्गकु तान तान वार्टुर, संगीगोळ, अदिक मान्ना अन हात्तीवाळेर्द घात माळी.” ");
INSERT INTO hoy_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","मूसा अन ई वचन इन अनुसार लेवीगोळ माळदुर; अदिक आ दिशी मुर हजार इन हात्ती पास लॉकुर कोन्सुसकु आदुर. ");
INSERT INTO hoy_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","बाक मूसा अंदुन, “ईंद इन दिशी यहोवा अन साटी तान याजक पद इन संस्कार माळी, उलटा तान तान पारगोळ अदिक वार्टुर्द भी विरूद्‍ध आगकु हिंग माळी यदुर देल आव ईंद नीमी आशीष कोळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","दुसरा दिशी मूसा लॉकुर से अंदुन, “नीव हापाळ अच पाप माळीर. ईग ना यहोवा अन हात्ती येरेगाईन; सम्भव आद कि ना नीम पाप इन प्रायश्चित माळ सकाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","आग मूसा यहोवा अन हात्ती होगकु अनली हतदुन, “हाय हाय, आ लॉकुर व्हान्ना अन देवता माळसुसकु हापाळ अच पाप माळ्यार. ");
INSERT INTO hoy_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","तरी भी ईग नी आंदुर पाप क्षमा माळ ईलारा तान लिख्सद किताब दा टु नान हेसुर कळ्द बुळ.” ");
INSERT INTO hoy_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","यहोवा मूसा से अंदुन, “याव नान खिलाप पाप माळ्यान आऊंदा हेसुर ना तान किताब दा टु कळ्द बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ईग नी होगकु आ लॉकुरी आ जागा दा ओय यदुर्द चर्चा ना नीन से माळीदिन; नोळ, नान स्वर्गदूत नीन मुंद मुंद नळदान. लेकीन याता दिशी ना दण्ड कोळली हताईन आ दिशी आंदरी ई पाप इन भी दण्ड कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","इदुरसाटी यहोवा आ लॉकुर मा विपत्ति हाकदुन, यतिकी हारून उन बनुस्द पाड्डा अक आंदुरा माळसुसीदुर. ");
INSERT INTO hoy_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","बाक यहोवा मूसा से अंदुन, “नी आ लॉकुरी यारी मिस्त्र द्याश दा टु बिळ्सकु तंद्या सांगुळ हुडुकु आ द्याश इक होग, यदुर बारा दा ना अब्राहम, इसहाक, अदिक याकूब से किर्‍या तिनकु अंदीदीन कि ना अदरी नीम वंश इक कोळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","अदिक ना नीन मुंद मुंद ऊंद दूत उक कळाईन, अदिक कनानी, एमोरी, हित्ती, परिज्जी, हिब्बी अदिक यबूसी लॉकुरी बरबस तेग्द बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","नीव लॉकुर आ द्याश इक होगी यदुर दा हाल अदिक शयद इन धारा वाहुसताव; लेकीन नीव जिद्दी आईर, ई कारण ना नीम बीच दा आगकु नळुतीदील, हिंग आगबाळुल कि ना हादी मा नीम अन्त माळ बुळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ईद बेकार बातणी केळकु आ लॉकुर विलाप माळली हतदुर; अदिक याऊ तान ईसरावाळी हाक्कु ईतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","यतिकी यहोवा मूसा से अंद बुटीदुन, “इस्त्राएलीगोळी नान ईद वचन केळ्स, ‘नीव लॉकुर रा जिद्दी आईर; अगर ना घळी तिमुर साटी नीम बीच दा आगकु नळाईन, रा नीम अन्त माळ बुळाईन. इदुरसाटी ईग तान तान ईसरा तान मय दा टु ईळ्सबुळी कि ना जान्साईन कि नीम सांगुळ येन माळ पायजे.’” ");
INSERT INTO hoy_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","इदुरसाटी इस्त्राएली होरेब पहाळी टु हुडुकु मुंद ताका तान ईसरा ईळ्सकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मूसा तम्बु उक छावनी टु व्हार्या उलटा दुर निदरूसकु ईटतोगोन, अदिक अदरी मिलाप इन तम्बु अनतोगोन. अदिक जो यावारा यहोवा अक ढुंढ्सतोगोन आव अद मिलाप इन तम्बु उन हात्ती जो छावनी इन व्हार्या ईरोद, होट बुळतोगोद. ");
INSERT INTO hoy_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","याग याग मूसा तम्बु उन हात्ती होगोन, आग आग सप्पा लॉकुर येदकु तान तान ड्यारा अन दरवाजा मा निद्रेगोर, अदिक यागास ताका मूसा आ तम्बु दा प्रवेश ईला माळतोगोन आगासताका ताका आऊन दी तार हचकु नोळतोगोर. ");
INSERT INTO hoy_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","याग मूसा आ तम्बु दा प्रवेश माळतोगोन, आग बादल इन खम्बा ईळुकु तम्बु उन दरवाजा मा रुक्सेगोद, अदिक यहोवा मूसा से मातगोळी हेळली हत्तेगतोगोन. ");
INSERT INTO hoy_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","अदिक सप्पा लॉकुर याग बादल इन खम्बा अक तम्बु उन दरवाजा मा रूक्सकु नोळतोगोर, आग येदकु तान तान ड्यारा अन दरवाजा मा टु ट्वांगरा टेक्सकु दण्डवत माळतोगोर. ");
INSERT INTO hoy_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","अदिक यहोवा मूसा से ईत्ता प्रकार देल आमने सामने मातगोळ हेळतोगोन, याता प्रकार देल यावारा तान वार्ट उन से मात हेळतान. अदिक मूसा रा छावनी दा वापस बरतोगोन, लेकीन यहोशू हेसुर इन ऊंद हारोदव मंळसा, जो नून उन पार अदिक मूसा अन सेवक ईरोन, आव तम्बु दा टु ईला होळतोगोन. ");
INSERT INTO hoy_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मूसा यहोवा से अंदुन, “केळ नी नान से अनत्या, ई लॉकुरी हुडुकु ओय; लेकीन ईद हेळीदील कि नी नान सांगुळ यारी कळ्या. तरी भी नी अंद्या, ना नीनी हेसुर देल जान्सतीन, अदिक नीन मा नान अनुग्रह अन दृष्टी आद. ");
INSERT INTO hoy_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","अदिक ईग अगर नान मा नीन अनुग्रह अन दृष्टी आगुल, रा नानी तान गति समजुस बुळ, यदुर देल याग ना नीन ग्यान हासिल माळाईन आग नीन अनुग्रह अन दृष्टी नान मा बन्सकु ईरूल. बाक ईद भी ध्यान ईट कि ईद जाति नीन प्रजा हुन.” ");
INSERT INTO hoy_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","यहोवा अंदुन, “ना खुद नीन सांगुळ नळाईन अदिक नीनी विश्राम कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","आव आऊन से अंदुन, “अगर नी खुद नळुतिदील, रा नामी ईल टु मुंद ओयबाळ. ");
INSERT INTO hoy_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ईद ह्यांग अर्तकु आगुल कि नीन अनुग्रह अन दृष्टी नान मा अदिक तान प्रजा मा आद? येन ईदुर देल ईला कि नी नाम सांगुळ सांगुळ नळद्या, यदुर देल ना अदिक नीन प्रजा अन लॉकुर पृथ्वी तिमुर्द सप्पा लॉकुर से अलग ठहरूसुल?” ");
INSERT INTO hoy_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","यहोवा मूसा से अंदुन, “ना ईद क्याल्सा भी, यदुर्द चर्चा नी माळ्या, माळाईन; यतिकी नान अनुग्रह अन दृष्टी नीन मा आद, ना नीनी नीन हेसुर देल जान्सतीन.” ");
INSERT INTO hoy_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","मूसा अंदुन, “नानी तान तेज तोर्स बुळ.” ");
INSERT INTO hoy_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","आव अंदुन, “ना नीन हात्ती आगकु नळुतेला नीनी तान पुरा भलाई तोर्साईन, अदिक नीन हात्ती यहोवा हेसुर इन प्रचार माळाईन; अदिक यदुर मा ना अनुग्रह माळोद चाहासाईन आऊन मा अच अनुग्रह माळाईन, अदिक यार मा दया माळोद चाहासाईन आऊन मा का दया माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","बाक आव अंदुन, “नी नान बाय इन दर्शन माळ सकाल; यतिकी मंळसा नान बाय इन दर्शन माळकु जित्ता ईर सकालुन.” ");
INSERT INTO hoy_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","बाक यहोवा अंदुन, “केळ, नान हात्ती ऊंद जागा आद, ईल नी आ चट्टान मा निदुर; ");
INSERT INTO hoy_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","अदिक याग ताका नान तेज नीन मुंद आगकु नळुतेला ईत्तीत, आग ताका ना नीनी धोळ्द कल्ल इन दरार दा ईटाईन अदिक यागासताका ना नीन मुंदु टु आगतेला होगालीन आगासताका तान कय देल नीनी मुचकु ईटाईन; ");
INSERT INTO hoy_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","बाक ना तान कय नेग्द बुळाईन, आग नी नान बेन इन रा दर्शन माळ्या; लेकीन नान बाय इन दर्शन आगतीदील.” ");
INSERT INTO hoy_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","बाक यहोवा मूसा से अंदुन, “पयला तखतगोळ घाई कल्ल इन येढ्ढ मात्त तखतगोळ केदुर कोम; आग जो वचन आ पयला तखतगोळ मा लिख्सकु ईरव, यवरी नी मुर्द बुट्ट, अवा वचन ना आ तखतगोळ मा भी लिख्साईन. ");
INSERT INTO hoy_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","व्हातर्या तयार ईरेत, अदिक व्हातर्या सीनै पहाळी मा येरकु अदुर स्यांडा मा नांद मुंद नीदरेत. ");
INSERT INTO hoy_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","नीन सांगुळ याऊ येर ईला पायजे, उलटा पहाळी तीमुर मा याऊ मंळसा येल्यारा कांळ्सबाळुल; अदिक ना मर्री-म्यांडा अदिक ना वस्त-वाळी भी पहाळी इन मुंद चरूस ईला पायजे.” ");
INSERT INTO hoy_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","आग मूसा पयला तखतगोळ घाई येढ्ढ मात्त तखतगोळ गळुसदुन; अदिक हुंजकुका येदकु तान कय दा कल्ल इन अव येढ्ढु तखतगोळ हुडुकु यहोवा अन आग्या अन अनुसार सीनै पहाळी मा येरेदुन. ");
INSERT INTO hoy_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","आग यहोवा बादल दा ईळुकु आऊन सांगुळ अल निदुरकु यहोवा अन हेसुर प्रचार माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","यहोवा आऊन मुंद आगकु ईद प्रचार माळतेला नळदुन, “यहोवा, यहोवा, ईश्वर दयालु अदिक अनुग्रहकारी, कोप माळदुर दा धीरजवन्त, अदिक हापाळ करूणामय अदिक सत्य, ");
INSERT INTO hoy_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हजारों पीढ़ी ताका लगातार करूणा माळावाळा, अधर्म अदिक अपराध अदिक पाप इन क्षमा माळावाळा हुन, लेकीन दोषी इक आव यातोदु प्रकार देल निर्दोष ठहरूसतीदील; आव आप्पुर्द अधर्म इन दण्ड आऊन चिकोर उलटा नातु अदिक पळनातुगोळी भी कोळावाळा हुन.” ");
INSERT INTO hoy_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","आग मूसा तुरन्त धरती दी ट्वांगरा टेक्सकु बांगकु दण्डवत माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","अदिक आव अंदुन, “हे प्रभु, अगर नीन अनुग्रह अन दृष्टी नान मा आगुल, रा प्रभु नाव लॉकुर न्याड्या दा टु आगतेला होदेव; ई लॉकुर जिद्दी रा आर, तरी भी नाम अधर्म अदिक पाप इक क्षमा माळ अदिक नामी तान निज भाग मान्सकु ग्रहण माळ.” ");
INSERT INTO hoy_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","आव अंदुन, “केळ, ना ऊंद वाचा कटतीन. नीन सप्पा लॉकुर मुंद ना हिंग आश्चर्यकर्म माळाईन ह्यांग धरती मा अदिक सप्पा द्याशगोळ दा यागलु आगीदील; अदिक आ सप्पा लॉकुर यार न्याड्या नी ईरत्या यहोवा अन कार्य अक नोळ्यार; यतिकी जो ना नीम लॉकुर साटी माळदुर मा आईन अद भयंकर क्याल्सा आद. ");
INSERT INTO hoy_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","जो आग्या ना ईंद नीमी कोळतीन अदरी नीव लॉकुर मान्सेतीर. नोळी, ना नीम मुंदु टु एमोरी, कनानी, हित्ती, परिज्जी, हिब्बी अदिक यबूसी लॉकुरी तेगुतीन. ");
INSERT INTO hoy_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","इदुरसाटी सावधान ईरेत कि याता द्याश दा नी होगावाळा आय अलेर ईरावाळेर से वाचा कट बाळेत; ईलारा हींग आगबाळुल कि अद नीन साटी फंदा ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","इदुरसाटी आंदुर वेदीगोळी केळ्द बुळेत, आंदुर मुंडागोळी मुर्द बुळेत, अदिक आंदुर अशेरा हेसुर इन मुर्तीगोळी कळ्द बुळेत; ");
INSERT INTO hoy_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","यतिकी नीनी यावारा दुसरा अक ईश्वर माळकु दण्डवत माळोद आग्या हैलेच, यतिकी यहोवा यार हेसुर जलनशील आद, आव होतकु येळावाळा परमेश्वर हुन, ");
INSERT INTO hoy_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","हींग आगबाळुल कि नी आ द्याश इन ईरावाळेर से वाचा कट्या, अदिक आंदुर तान देवतागोळ्द हींद आगोद व्यभिचार माळुल, अदिक आंदुर साटी बलिदान भी माळुल, अदिक यावारा नीनी बावस्या कोळुल अदिक नी भी आऊन बलिपशु उन मास तीन, ");
INSERT INTO hoy_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","अदिक नी आंदुर पोरगोळी तान पारगोळ मदा साटी तरेत, अदिक आंदुर पोरगोळ जो खुद तान देवतागोळ्द हींद आगोद व्यभिचार माळतार नीन पारगोळ से भी तान देवतागोळ्द हींद आगोद व्यभिचार माळसुसुल. ");
INSERT INTO hoy_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“नीव देवतागोळ्द मूर्तीगोळ ढाल्सकु माळ बाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“अखमीरी रोट्टी इन हाब्ब मान्सेत. अदुर दा नान आग्या अन अनुसार आबीब तिंगुळ अन नियत समय मा येळ दिन ताका अखमीरी रोट्टी तिनतोगेत; यतिकी नी मिस्त्र टु आबीब तिंगुळ दा होटकु बंद. ");
INSERT INTO hoy_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","हर ऊंद पहिलौठा नानव हुन; अदिक येन पाड्डा, येन मेम्ना, नीन जनावरगोळ दा टु जो नर पहिलौठा आव अव सप्पा नानव अच हुव. ");
INSERT INTO hoy_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गदा अन पहिलौठा अन बदला मेम्ना कोटकु अदरी बीळसेत, अगर नी अदरी बीळसोद चाहासाल रा अदुर म्यांडा मुर्द बुळेत. लेकीन तान सप्पा पहिलौठा पारगोळी बदला कोटकु बीळसेत. नानी याऊ नीरा कय तान मार्रा तोर्स बाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“आर दिन रा मयनत माळेत, लेकीन सातवा दिशी विश्राम माळेत; उलटा नागर जोत्सा होती अदिक परा हचा समय दा भी विश्राम माळेत. ");
INSERT INTO hoy_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","अदिक नी हप्तागोळ्द हाब्‍ब मनुसेत यदरी पयले परा हच्द गोदी इन हाब्‍ब अंदकु आगतद, अदिक साल इन आखरी दा बटोरन इन भी हाब्‍ब मनुसेत. ");
INSERT INTO hoy_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","साल दा मुर घन नीन सप्पा मंळसागोळ इस्त्राएल इन परमेश्वर प्रभु यहोवा अक तान मार्रा तोर्सुल. ");
INSERT INTO hoy_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","यतिकी ना गैरयहूदीगोळी नीन मुंदु टु तेगुकु नीन सीमागोळी वाळुसाईन; अदिक याग नी तान परमेश्वर यहोवा अक तान मार्रा तोरसोर साटी साल दा मुर अनली बर्तोद्या, आग याऊ नीन जमीन इन लालच माळतीदील. ");
INSERT INTO hoy_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“नान बलिदान इन रक्ता अक खमीर सांगुळ येर्स बाळेत, अदिक ना फसह अन हाब्ब अन बलिदान दा टु येनारा व्हातुर ताका मिक्सकु ईटेत. ");
INSERT INTO hoy_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","तान जमीन इन पयला उपज इन पयला भाग तान परमेश्वर यहोवा अन भवन दा तरेत. मर्री इन पाड्डा अक अदुर्द मोय इन हाल दा बेईस बाळेत.” ");
INSERT INTO hoy_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","आग यहोवा मूसा से अंदुन, “ई वचन लिख्स कोम; यतिकी ईवा वचनगोळ अनुसार ना नीन अदिक इस्त्राएल इन सांगुळ वाचा कटीन.” ");
INSERT INTO hoy_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मूसा अल यहोवा अन सांगुळ चालीस दिन अदिक चालीस ईळ्लक ईत्तुन; अदिक आगासताका ना रा आव रोट्टी तिंदुन अदिक ना नीर कुळदुन. अदिक आव आ पाटीगोळ मा वाचा अन वचन मतलब हत्त आग्यागोळ लिख्स बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","याग मूसा गवाही इन येढ्ढु तखतगोळ कय दा हुडुकु सीनै पहाळ टु ईळोन आग यहोवा अन सांगुळ मात हेळदुर कारण आऊन मार्रा दा टु किरण होळोव, लेकीन आव ईद ईला जानसोन कि आऊन मार्रा दा टु किरण होळेत्याव. ");
INSERT INTO hoy_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","याग हारून अदिक सप्पा इस्त्राएलीगोळ मूसा अक नोळदुर कि आऊन मार्रा दा टु किरण होळेत्याव, आग आंदुर आऊन हात्ती होगोर से अंजेदुर. ");
INSERT INTO hoy_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","आग मूसा आंदरी कारदुन; अदिक हारून मंडली इन सप्पा प्रधानगोळ समेत आऊन हात्ती बंदुन, अदिक मूसा आंदुर से मात हेळली हतदुन. ");
INSERT INTO hoy_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","इदुर बाद्दा सप्पा इस्त्राएलीगोळ हात्ती बंदुर, अदिक यास आग्यागोळ यहोवा सीनै पहाळ मा आऊन सांगुळ मात हेळा होती कोटीदुन, अव सप्पा आव आंदरी हेळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","यागासताका मूसा आंदुर से मात हेळ कोंडीदील आगासताका तान मार्रा मा ओढ़ना हाक्कु ईत्तुन; ");
INSERT INTO hoy_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","लेकीन याग याग मूसा बुळ्क यहोवा से मात हेळली आऊन मुंद होगोन, आग आग आव आ ओढ़नी इक होळा समय ताका तेगकु ईटतोगोन; बाक व्हार्या बंदकु जो जो आग्या आऊक सिकतोगोद अवरी इस्त्राएलीगोळ से हेळबुळतोगोन. ");
INSERT INTO hoy_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्त्राएली मूसा अन मार्रा नोळतोगोर कि आऊन मार्रा दा टु किरण होळताव; अदिक यागासताका आव यहोवा से मात हेळली बुळ्क ईला होगतोगोन आगासताका आव आ ओढ़नी इक हाक्कु ईरतोगोन. ");
INSERT INTO hoy_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मूसा इस्त्राएलीगोळ्द सप्पा मंडली इक जमा माळकु आंदुर से अंदुन, “याता क्याल्सागोळ्द माळोद आग्या यहोवा कोटान अव ईव हुव. ");
INSERT INTO hoy_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","आर दिन रा क्याल्सा-कळी माळकु आगुल, लेकीन सातवा दिशी नीम साटी पवित्र अदिक यहोवा अन साटी परम विश्राम इन दिन ठहरूसुल; अदुर दा जो यावारा क्याल्सा-कळी माळ्यान आव कोन्सुसकु आगुल; ");
INSERT INTO hoy_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","उलटा विश्राम इन दिशी नीव तान तान मान्नगोळ दा बेक्‍की ताका होताक बाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","बाक मूसा इस्त्राएलीगोळ्द सप्पा मंडली से अंदुन, याता मात इन आग्या यहोवा कोटान अद ईद हुन. ");
INSERT INTO hoy_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","नीम हात्ती टु यहोवा अन साटी भेंट ताकोमकु आगुल, मतलब यास तान इच्छा देल कोळोद चाहसुल आंदुर यहोवा अन भेंट माळकु ईव वस्तुगोळ तरूल; मतलब व्हान्ना, बेळ्ली, पीतल; ");
INSERT INTO hoy_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","नीळा, जांभळा रंग इन अदिक क्याचांद रंग इन कपळा, सुक्ष्म सन इन कपळा; मर्री इन चुट्टी, ");
INSERT INTO hoy_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","क्याचांद रंग देल रंगकु म्यांडागोळ्द तोगुल, सूइसगोळ्द तोगुल; बबूल इन हुळ्ली, ");
INSERT INTO hoy_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ऊजुळ कोळोर साटी याण्णा, अभिषेक इन याण्णा अदिक धूप इन साटी सुगन्धद्रव्य, ");
INSERT INTO hoy_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","बाक एपोद अदिक चपरास इन साटी सुलैमानी मणि अदिक जळुसोर साटी मणि. ");
INSERT INTO hoy_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“नीम दा टु यास मुंदुरव दिल दा बुद्धि इन ऊजुळ आद आंदुर सप्पा बंदकु याता याता वस्तु उन आग्या यहोवा कोटान अव सप्पा बनुसुल. ");
INSERT INTO hoy_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","मतलब तम्बु, अदिक आवरण समेत निवास, अदिक अदुर घुंडी, पट्टीगोळ, बेंडगोळ, खम्बागोळ अदिक कुर्चीगोळ; ");
INSERT INTO hoy_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","बाक डण्डागोळ समेत सन्दुक, अदिक प्रायश्चित इन झाकनी, अदिक बीच इन पळदा; ");
INSERT INTO hoy_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","डण्डागोळ अदिक सप्पा सामान समेत मेज, अदिक भेंट इन रोट्टीगोळ; ");
INSERT INTO hoy_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","सामान अदिक दिंग्यागोळ समेत ऊजुळ कोळावाळा दीवट, अदिक ऊजुळ कोळोर साटी याण्णा; ");
INSERT INTO hoy_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","डण्डागोळ समेत धूपवेदी, अभिषेक इन याण्णा, सुगन्धित धूप, अदिक निवास इन दरवाजा मा पळदा; ");
INSERT INTO hoy_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","पीतल इन झंझरी, डण्डागोळ समेत होमबली वेदी, पाया समेत गंगार; ");
INSERT INTO hoy_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","खम्बागोळ अदिक अऊर्द कुर्चीगोळ समेत आंगुळ इन पळदागोळ, अदिक आंगुळ इन दरवाजा मा पळदागोळ; ");
INSERT INTO hoy_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","निवास अदिक आंगुळ येढ्ढु उन खुटागोळ, अदिक डोरीगोळ; ");
INSERT INTO hoy_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्रस्थान दा स्यावा टहल माळोर साटी कळुस्द कपळा, अदिक याजक इन क्याल्सा माळोर साटी हारून याजक उन पवित्र कपळा, अदिक आऊन पारगोळव कपळा.” ");
INSERT INTO hoy_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","आग इस्त्राएलीगोळ्द सप्पा मंडली मूसा अन मुंदु टु वापस होत्त. ");
INSERT INTO hoy_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","अदिक यास मुंदुरी उत्साह आत अदिक यास मुंदुर मन दा हींग इच्छा उत्पन्न आगित, आंदुर मिलाप इन तम्बु उन क्याल्सा माळली अदिक अदुर सप्पा स्यावा अदिक पवित्र कपळागोळ्द माळोर साटी यहोवा अन भेंट तरली हतदुर. ");
INSERT INTO hoy_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","येन आर्तेर, येन मंळसागोळ, यास मुंदुर मन दा हींग इच्छा उत्पन्न आगित आंदुर सप्पा कुत्या दाकळोद हार, कीव दाकळव नथनी, ऊंगरा, अदिक बांगळा व्हान्ना अन ईसरा तरली हतदुर, ईत्ता प्रकार देल यास मंळसा यहोवा अन साटी व्हान्ना अन भेंट इन कोळावाळेर ईरोर आंदुर सप्पा मुंदुर अवरी तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","अदिक याता याता मंळसा अन हात्ती नीळा, जांभळा या क्याचांद रंग इन कपळा, या सुक्ष्म सन इन कपळा, या मर्री इन चुट्टी, या क्याचांद रंग देल रंगकु म्यांडागोळ्द तोगुल, या सूइसगोळ्द तोगुल ईरव आंदुर अवरी तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","बाक याट बेळ्ली, या पीतळा अन भेंट इन कोळावाळेर ईरोर आंदुर यहोवा अन साटी ईत्ता भेंट तंदुर; अदिक यार यार हात्ती स्यावा अन यातोदारा क्याल्सा अन साटी बबूल इन हुळ्ली ईरोद आंदुर अदरी तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","अदिक यास आर्तेर मन दा बुद्धि इन ऊजुळ ईरोद आंदुर तान कय देल लूला कातुस कातुसकु नीळा, जांभळा अदिक क्याचांद रंग इन, अदिक सुक्ष्म सन इन कातुस्द लूला अक तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","यास आर्तेर मन दा हींग बुद्धि इन ऊजुळ ईरोद आंदुर मर्री इन चुट्टी भी कातुसदुर. ");
INSERT INTO hoy_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","अदिक प्रधान लॉकुर एपोद अदिक चपरास इन साटी सुलैमानी मणि, अदिक जळुसोर साटी मणि, ");
INSERT INTO hoy_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","अदिक ऊजुळ कोळली अदिक अभिषेक अदिक धूप इन सुगन्धद्रव्य अदिक याण्णा तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","याता याता वस्तु उन माळोद आग्या यहोवा मूसा अन द्वारा कोटीदुन अदुर साटी जो येनारा जरूरी ईरोद, अदरी आ सप्पा मंळसागोळ अदिक आर्तेर तंदुर, यार मन दा हींग इच्छा उत्पन्न आगित. ईत्ता प्रकार देल इस्त्राएली यहोवा अन साटी तांद अच इच्छा देल भेंट तंदुर. ");
INSERT INTO hoy_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","आग मूसा इस्त्राएलीगोळ से अंदुन, “केळी, यहोवा यहूदा अन गोत्रवाळेर बसलेल उक, जो ऊरी इनव पार अदिक हूर इन नातु हुन, हेसुर ताकोमकु कारस्यान; ");
INSERT INTO hoy_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","अदिक आव आऊक परमेश्वर उन आत्मा देल हींग परिपुर्ण माळ्यान कि सप्पा प्रकार इन बनावट इन साटी आऊक ईत्ता बुद्धि, समझ, अदिक ग्यान सिक्याद ");
INSERT INTO hoy_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","कि आव कारीगरी इन युक्तिगोळ तेगुकु व्हान्ना, बेळ्ली अदिक पीतळा दा, ");
INSERT INTO hoy_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","अदिक जळुसोर साटी मणि कळदुर दा अदिक हुळ्ली मा नकाशा माळदुर दा, उलटा बुद्धि देल सप्पा प्रकार इन तेग्द बनावट दा क्याल्सा माळ सकुल. ");
INSERT INTO hoy_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","बाक यहोवा आऊन मन दा दान इन गोत्रवाळेर अहीसामाक उन पार ओहोलीआब उन मन दा भी शिक्षा कोळोद शक्ति कोटान. ");
INSERT INTO hoy_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ई येढ्ढु मुंदुर मन इक यहोवा हींग बुद्धि देल परिपुर्ण माळ्यान कि आंदुर नकाशा तेगदुर दा अदिक गळुसावाळेर अदिक नीळा, जांभळा अदिक क्याचांद रंग इन सन इन कपळा दा कातुसावाळेर अदिक बुनाई माळावाळेर आगुल, उलटा सप्पा प्रकार इन बनावट दा, अदिक बुद्धि देल क्याल्सा तेगदुर दा सप्पा प्रकार इन क्याल्सा माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“बसलेल अदिक ओहोलीआब अदिक सप्पा बुध्दिमान यारी यहोवा हींग बुद्धि अदिक समझ कोटान कि आंदुर यहोवा अन सप्पा आग्यागोळ्द अनुसार पवित्रस्थान इन स्यावा अन साटी सप्पा प्रकार इन क्याल्सा माळोद जानसुल, आंदुर सप्पा ईद क्याल्सा माळुल.” ");
INSERT INTO hoy_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","आग मूसा बसलेल अदिक ओहोलीआब अदिक सप्पा बुध्दिमानगोळी यार मन दा यहोवा बुद्धि इन ऊजुळ कोटीदुन, मतलब यार यार इक हात्ती बंदकु क्याल्सा माळोद उत्साह आगित आ सप्पा मुंदुरी कार्सुसदुन; ");
INSERT INTO hoy_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","अदिक इस्त्राएली जो जो भेंट पवित्रस्थान इन स्यावा अन क्याल्सा अदिक अदुर बनुसोर साटी तंदीदुर, अवरी आ मंळसागोळ मूसा अन कय देल हुडु कोंडुर. आग भी लॉकुर रोज हुंजकुका आऊन हात्ती भेंट तान इच्छा देल तरतेला ईत्तुर; ");
INSERT INTO hoy_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","अदिक यास बुध्दिमान पवित्रस्थान इन क्याल्सा माळतोगोर आंदुर सप्पा तान तान क्याल्सा बिटकु मूसा अन हात्ती बंदुर, ");
INSERT INTO hoy_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","आंदुर मूसा से अंदुर, “याता क्याल्सा अक माळोद आग्या यहोवा कोटान अदुर साटी याट पायजे अदुर से यक्कुल आंदुर तंदार.” ");
INSERT INTO hoy_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","आग मूसा पुरा छावनी दा ई आग्या अन प्रचार माळसुसदुन, “येन मंळसा, येन आर्तेर, यावारा पवित्रस्थान इन साटी मात्त भेंट तरबाळुल.” ईत्ता प्रकार देल लॉकुर मात्त भेंट तरोर से रोक्सकु आदुर; ");
INSERT INTO hoy_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","यतिकी सप्पा क्याल्सा माळोर साटी याट सामान जरूरी ईरोद, अदुर से यक्कुल माळावाळेर हात्ती होटबंदीत. ");
INSERT INTO hoy_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","क्याल्सा माळावाळेर याट बुध्दिमान ईरोर आंदुर निवास इन साटी वाट्सद सुक्ष्म सनी इन कपळा अन, अदिक नीळा, जांभळा अदिक क्याचांद रंग इन सन इन कपळा अन हत्त पळदागोळी कळुस्द करूबगोळ सहित माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ऊंद ऊंद पळदा अन लंबाई अठ्ठावीस कय अदिक चौळाई नाक कय इन आत; सप्पा पळदागोळ ऊंदा नाप इनव बन्सदव. ");
INSERT INTO hoy_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","आव अईद पळदागोळ आबुर दाबुर से जोळ्सदुन, अदिक मात्त दुसरा अईद पळदागोळ भी आबुर दाबुर से जोळ्स बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","अदिक यल ई पळदागोळ जोळ्सकु आदव अल इन येढ्ढु क्वाना मा आव नीळा नीळा फन्दागोळ हचदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","आव येढ्ढु क्वाना दा पचास पचास फन्दागोळ ईत्ता प्रकार देल हचदुन कि अव आबुर दाबुर मुंद ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","अदिक आव व्हान्ना अन पचास आकळागोळ बनुसदुन, अदिक अऊर द्वारा पळदागोळी आबुर दाबुर से हींग जोळ्सदुन कि निवास मिलुसकु ऊंद आगेत. ");
INSERT INTO hoy_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","बाक निवास इन म्याकुच इन तम्बु उन म्याकुच होचोर साटी आव मर्री इन चुट्टी इन हनुन पळदागोळ बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ऊंद ऊंद पळदा अन लंबाई तीस कय अदिक चौळाई नाक कय इन आत; अदिक हनुन पळदागोळ ऊंदा नाप इनव ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ईऊर दा टु आव अईद पळदागोळ अलग अदिक आर पळदागोळ अलग जोळ्सदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","अदिक यल येढ्ढु जोळ्सकु आदव अल इन क्वाना दा आव पचास पचास फन्दागोळ हचदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","अदिक आव तम्बु उन जोळसोर साटी पीतळा अन पचास आकळागोळ भी बनुसदुन यदुर देल अव ऊंद आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","अदिक आव तम्बु उन साटी क्याचांद रंग देल रंगकु म्यांडागोळ्द तोगुल इन ऊंद ओळनी अदिक अदुर म्याकुच इन साटी सूइसगोळ तोगुल इन भी ऊंद ओळनी बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","बाक आव निवास इन साटी बबूल इन हुळ्ली इन तखतगोळी निदुरकु ईरोर साटी बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ऊंद ऊंद पाटीगोळ्द लंबाई हत्त कय अदिक चौळाई दिळ कय इन आत. ");
INSERT INTO hoy_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","निवास इन सप्पा तखतगोळी आव ईत्ता प्रकार देल बनुसदुन, ऊंद ऊंद तखत दा आबुर दाबुर से जोळ्सकु येढ्ढ येढ्ढ चुलीगोळ बन्सदव. ");
INSERT INTO hoy_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","आव निवास इन साटी तखतगोळी ईत्ता प्रकार देल बनुसदुन कि दक्षिण दी ईप्पत तखतगोळ हतुल; ");
INSERT INTO hoy_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","अदिक ई ईप्पत इन ईप्पत तखतगोळ्द ल्यालमा बेळ्ली नव च्यालीस कुर्चीगोळ, मतलब ऊंद ऊंद तखत इन ल्यालमा अदुर येढ्ढ चुलीगोळ साटी आव येढ्ढ कुर्चीगोळ बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","अदिक निवास इन दुसरा दी, मतलब उत्तर दीकळोद साटी भी आव ईप्पत तखतगोळ बनुसदुन; ");
INSERT INTO hoy_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","अदिक ईऊर साटी भी आव बेळ्ली इन च्यालीस कुर्चीगोळ, मतलब ऊंद ऊंद पाटीगोळ ल्यालमा येढ्ढ येढ्ढ कुर्चीगोळ बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","अदिक निवास इन हींदळोद भाग दी, मतलब पश्चिम दीकळोद साटी आव आर तखतगोळ बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","अदिक हींदळोद भाग दा निवास इन क्वाना अन साटी आव येढ्ढ तखतगोळ बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","अव ल्यालमा टु येढ्ढ येढ्ढ भाग इनव बन्सदव, अदिक येढ्ढु भाग म्याकळव सिरा ताका ऊंद ऊंद कळा दा मिलुसकु आदव; आव आ येढ्ढु पाटीगोळ्द आकार हींग अच बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ईत्ता प्रकार देल येठ्ठ तखतगोळ आदव, अदिक अऊर्द बेळ्ली इन सॉळा कुर्चीगोळ आदव; मतलब ऊंद ऊंद तखतगोळ ल्यालमा येढ्ढ येढ्ढ कुर्चीगोळ आदव. ");
INSERT INTO hoy_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","बाक आव बबूल इन हुळ्ली इन बेंडगोळ बनुसदुन, मतलब निवास इन ऊंद दीकळोद तखतगोळ साटी अईद बेंडगोळ, ");
INSERT INTO hoy_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","अदिक निवास इन दुसरा दीकळोद तखतगोळ साटी अईद बेंडगोळ, अदिक निवास इन जो किनारा पश्चिम दी हींदळा भाग दा ईरोद अदुर साटी भी अईद बेंडगोळ बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","अदिक आव बीच इन बेंड इक तखतगोळ बीच दा तम्बु उन ऊंद सिरा से दुसरा सिरा ताका पोहचुसोर साटी बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","अदिक तखतगोळी आव व्हान्ना देल मळुसदुन, अदिक बेंडगोळ्द मान्ना अन क्याल्सा कोळावाळा कळागोळी व्हान्ना नव बनुसदुन, अदिक बेंडगोळी भी व्हान्ना देल मळुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","बाक आव नीळा, जांभळा अदिक क्याचांद रंग इन कपळा अन, अदिक सुक्ष्म सन इन कपळा अन बीच इन पळदा बनुसदुन; अद कळाई इन क्याल्सा माळ्द करूबगोळ्द सांगुळ बनुस्त. ");
INSERT INTO hoy_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","आव अदुर साटी बबूल इन नाक खम्बा बनुसदुन, अदिक अवरी व्हान्ना देल मळुसदुन; अऊर हुकगोळ व्हान्ना नव बन्सदव, अदिक आव अऊर साटी बेळ्ली नव नाक कुर्चीगोळ बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","आव तम्बु उन दरवाजा अन साटी भी नीळा, जांभळा अदिक क्याचांद रंग इन सन इन कपळा अन, अदिक सुक्ष्म सनी इन कपळा अन कढ़ाई इन क्याल्सा माळ्द पळदा बनुसदुन; ");
INSERT INTO hoy_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","अदिक आव हुकगोळ समेत अदुर्द अईद खम्बा भी बनुसदुन, अदिक अऊर सिरागोळ अदिक जोळसोद छळीगोळी व्हान्ना देल मळुसदुन, अदिक अऊर अईद कुर्चीगोळ पीतळा अन बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बाक बसलेल बबूल इन हुळ्ली इन सन्दुक बनुसदुन; अदुर्द लंबाई येढ्ढवार कय, चौळाई दिळ कय, अदिक ऊचाई दिळ कय इन ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","आव अदरी बुळ्क व्हार्या शुद्ध व्हान्ना देल मळुसदुन, अदिक अदुर नाकु दी व्हान्ना अन बाड़ बनुसुदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","अदिक अदुर नाकु कालगोळ मा हचली आव व्हान्ना नव नाक कळागोळ माळदुन, येढ्ढ कळा ऊंद दी अदिक येढ्ढ कळा दुसरा दी हतदव. ");
INSERT INTO hoy_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","बाक आव बबूल इन डण्डागोळ माळदुन, अदिक अवरी व्हान्ना देल मळुसदुन, ");
INSERT INTO hoy_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","अदिक अवरी सन्दुक इन येढ्ढु दीकळोद कळागोळ दा हाकदुन कि अऊर सहारा देल सन्दुक नेगुकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","बाक आव चोखा व्हान्ना देल प्रायश्चित इन झाकनी माळदुन; अदुर लंबाई येढ्ढवार कय अदिक चौळाई दिळ कय इन ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","अदिक आव व्हान्ना मळुसकु येढ्ढ करूब प्रायश्चित इन झाकनी इन येढ्ढु क्वाना मा बनुसदुन; ");
INSERT INTO hoy_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ऊंद करूब ऊंद क्वाना मा, अदिक दुसरा करूब दुसरा क्वाना मा बनुस्त; आव अवरी प्रायश्चित इन झाकनी इन सांगुळ ऊंदा तुकळा अन येढ्ढु क्वाना मा बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","अदिक करूबगोळ्द पंख म्याकुच टु फैलुसदुर घाई बन्सदव, अदिक आ पंखगोळ देल प्रायश्चित इन झाकनी मुचकु बनुस्त, अदिक अऊर बाय आमने सामने अदिक प्रायश्चित इन झाकनी दी माळ्द बन्सदव. ");
INSERT INTO hoy_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","बाक आव बबूल इन हुळ्ली इन मेज इक माळदुन; अदुर लंबाई येढ्ढ कय, चौळाई ऊंद कय, अदिक ऊचाई दिळ कय इन ईरोद; ");
INSERT INTO hoy_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","अदिक आव अदरी शुद्ध व्हान्ना देल मळुसदुन, अदिक अदुर दा नाकु दी व्हान्ना अन ऊंद बाड़ माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","अदिक आव अदुर साटी नाक बेळ्ल चौळा ऊंद चौखट, अदिक ई पटरी इन साटी नाकु दी व्हान्ना अन ऊंद बाड़ माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","आव मेज इन साटी व्हान्ना अन नाक कळागोळ माळकु आ नाकु क्वानागोळ दा हचदुन, जो अऊर नाकु कालगोळ मा ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","अव कळागोळ चौखट इन हात्ती मेज नेगव डण्डागोळ्द खानागोळ क्याल्सा कोळली बन्सदव. ");
INSERT INTO hoy_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","आव मेज नेगोर साटी डण्डागोळी बबूल इन हुळ्ली इन बनुसदुन अदिक व्हान्ना देल मळुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","अदिक आव मेज माकळोद सामान मतलब परात, धूपदानी, कटोरागोळ, अदिक रीचुसव बरतन सप्पा शुद्ध व्हान्ना देल बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","बाक आव शुद्ध व्हान्ना गढ़ इन पाया अदिक डण्डी समेत दीवट इक माळदुन; अदुर पुष्पकोष, गाठ, अदिक फूल सप्पा ऊंदा तुकळा नव बन्सदव. ");
INSERT INTO hoy_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","अदिक दीवट दा टु होळ्द आर डगालगोळ बनुसदव; मुर डगालगोळ अदुर ऊंद दी टु अदिक मुर डगालगोळ अदुर दुसरा दी टु होटकु बन्सदव. ");
INSERT INTO hoy_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ऊंद ऊंद डगाली दा बदाम इन फूल इन घाई मुर मुर पुष्पकोष, ऊंद ऊंद गाठ, अदिक ऊंद ऊंद फूल बन्सत; दीवट दा टु होळ्द आ आर डगालगोळ्द ईदा आकार आत. ");
INSERT INTO hoy_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","अदिक दीवट इन डंडा दा बदाम इन फूल इन घाई तान तान गाठ अदिक फूल समेत नाक पुष्पकोष बन्सदव. ");
INSERT INTO hoy_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","अदिक दीवट दा टु होळ्द आर डगालगोळ दा टु येढ्ढ येढ्ढ डगालगोळ्द ल्यालमा ऊंद ऊंद गाठ दीवट इन सांगुळ ऊंदा तुकळा अन बन्सदव. ");
INSERT INTO hoy_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","गाठगोळ अदिक डगालगोळ सप्पा दीवट इन सांगुळ ऊंदा तुकळा अन बन्सदव; पुरा दीवट नळ्सद शुद्ध व्हान्ना अन अदिक ऊंदा तुकळा अन बन्सत. ");
INSERT INTO hoy_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","अदिक आव दीवट इन येळ दिंग्या अदिक थाली अदिक गुलदान शुद्ध व्हान्ना अन माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","आव सप्पा सामान समेत दीवट इक लगभग चौतीस किलो तिमुर्द व्हान्ना अन माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","बाक आव बबूल इन हुळ्ली इन धूपवेदी भी माळदुन; अदुर लंबाई ऊंद कय अदिक चौळाई ऊंद कय इन ईरोद; अद चौकोन बन्सत, अदिक अदुर ऊचाई येढ्ढ कय इन ईरोद; अदिक अदुर सींग ऊंद अच तुकळा नव माळकु ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","म्याकळव पल्लागोळ अदिक नाकु दीकळव बाजुगोळ अदिक सींगगोळ समेत आव आ वेदी इक शुद्ध व्हान्ना देल मळुसदुन; अदिक अदुर नाकु दी व्हान्ना अन ऊंद बाड़ माळदुन, ");
INSERT INTO hoy_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","अदिक आ बाड़ इन ल्यालमा अदुर येढ्ढु पल्लागोळ मा आव व्हान्ना नव येढ्ढ कळागोळ बनुसदुन, जो अदुर नेगव डण्डागोळ्द खाचागोळ क्याल्सा कोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","अदिक डण्डागोळी आव बबूल इन हुळ्ली इन बनुसदुन अदिक व्हान्ना देल मळुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","आव अभिषेक इन पवित्र याण्णा अदिक सुगन्धद्रव्य अन धूप ईदा रिति इन अनुसार माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","बाक आव बबूल इन हुळ्ली इन होमबली वेदी भी बनुसदुन; अदुर लंबाई अईद कय अदिक चौळाई अईद कय इन ईरोद; ईत्ता प्रकार देल अद चौकोन बनुस्त, अदिक ऊचाई मुर कय इन ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","आव अदुर नाकु क्वाना मा अदुर नाक सींग बनुसदुन, अव अदुर सांगुळ बिना जोळ इन बनुसदव; अदिक आव अदरी पीतळा देल मळुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","अदिक आव वेदी इन सप्पा सामान, मतलब अदुर गळग्यागोळ, पावळागोळ, वाटीगोळ, काटागोळ अदिक करचीगोळी बनुसदुन. अदुर सप्पा सामान आव पीतळा अन बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","अदिक वेदी इन साटी अदुर नाकु दीकळोद कंगनी इन ल्यालमा आव पीतळा अन जाली इन ऊंद झंझरी बनुसदुन, अद ल्यालमा टु वेदी इन ऊचाई इन बीच ताका पोहचुस्त. ");
INSERT INTO hoy_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","आव पीतळा अन झंझरी इन नाकु क्वाना अन साटी नाक कळागोळ घळुसदुन, जो डण्डागोळ्द खानागोळ क्याल्सा कोळुल. ");
INSERT INTO hoy_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","बाक आव डण्डागोळी बबूल इन हुळ्ली इन बनुसदुन अदिक पीतळा देल मळुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","आग आव डण्डागोळी वेदी इन किनारा अन कळागोळ दा वेदी इन नेगोर साटी हाक बुट्टुन, वेदी इक आव तखतगोळ देल पोकर बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","आव गंगार अदिक अदुर्द पाया येढ्ढु पीतळ इन माळदुन, ईद मिलाप इन तम्बु उन द्वार मा स्यावा माळावाळेर आर्तेर्द पीतळ इन आरसा देल माळकु आदव. ");
INSERT INTO hoy_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","बाक आव आंगुळ बनुसदुन; अदिक दक्षिण दीकळोद साटी आंगुळ इन पळदागोळ सुक्ष्म सन इन कपळा नव ईरव, अदिक सप्पा मिलुसकु सौ कय ऊद्द ईरव; ");
INSERT INTO hoy_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","अऊर साटी ईप्पत खम्बागोळ, अदिक ईऊर्द पीतळा अन ईप्पत कुर्चीगोळ बनुसदव; अदिक खम्बागोळ्द घुंडीगोळ अदिक जोळसोद कळीगोळ बेळ्ली नव बनुसदव. ");
INSERT INTO hoy_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","अदिक उत्तर दीकळोद साटी भी सौ कय ऊद्द पळदागोळ बनुसदव; अदिक अऊर साटी ईप्पत खम्बागोळ, अदिक ईऊर्द पीतळा अन ईप्पत अच कुर्चीगोळ बनुसदव, अदिक खम्बा नव घुंडीगोळ अदिक जोळसोद कळी बेळ्ली नव बनुसदव. ");
INSERT INTO hoy_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","अदिक पश्चिम दीकळोद साटी सप्पा पळदागोळ मिलुसकु पचास कय इन ईरव; अऊर साटी हत्त खम्बागोळ अदिक हत्त अच अऊर कुर्चीगोळ ईरव, अदिक खम्बागोळ्द घुंडीगोळ अदिक जोळसोद छळीगोळ बेळ्ली नव ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","अदिक पूर्व दी भी अव पचास कय इनव ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","आंगुळ इन दरवाजा अन ऊंद दिकळोद साटी पंदरा कय इन पळदागोळ बन्सदव, अदिक अऊर साटी मुर खम्बा अदिक मुर कुर्चीगोळ ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","अदिक आंगुळ इन दरवाजा अन दुसरा दी भी हांगा बनुसीत; अदिक आंगुळ इन दरवाजा अन ईत्त अदिक आत्त पंदरा पंदरा कय इन पळदा बन्सकु ईरव; अदिक अऊर साटी मुर मुर खम्बा, अदिक मुर मुर कुर्चीगोळ भी ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","आंगुळ इन नाकु दी सप्पा पळदा सुक्ष्म सन इन कपळा अन बन्सकु ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","अदिक खम्बागोळ्द कुर्चीगोळ पीतळा अन अदिक घुंडीगोळ अदिक छळी बेळ्ली इन बनुसदव, अदिक अऊर क्वाना बेळ्ली देल मळुसकु आदव, अदिक आंगुळ इन सप्पा खम्बा बेळ्ली इन छळी देल जोळ्सकु आगीदव. ");
INSERT INTO hoy_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","आंगुळ इन दरवाजा अन पळदागोळ मा बेल बुटा अन क्याल्सा माळकु आगित, अदिक अव नीळा, जांभळा अदिक क्याचांद रंग इन सन इन कपळा अन, अदिक सुक्ष्म सनी इन कपळा अन बन्सकु आगीदव; अदिक अदुर लम्बाई ईप्पत कय इन ईरोद, अदिक अदुर ऊचाई आंगुळ इन कनात इन चौळाई इन घाई अईद कय इन बनुस्त. ");
INSERT INTO hoy_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","अदिक अऊर साटी नाक खम्बा अदिक खम्बागोळ्द नाक अच कुर्चीगोळ पीतळा अन बनुसदव, अऊर घुंडीगोळ बेळ्ली नव बनुसदव, अदिक अऊर क्वानागोळ बेळ्ली देल मळुसकु आदव, अदिक अऊर पट्टीगोळ बेळ्ली नव बनुसदव. ");
INSERT INTO hoy_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","अदिक निवास अदिक आंगुळ इन नाकु दिकळोद सप्पा खुटागोळ पीतळा अन बन्सकु ईरव. ");
INSERT INTO hoy_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","गवाही इन‍ चिट्टी इन निवास इन सामान जो लेवीगोळ्द स्यावा कार्य अन साटी बनुस्त, अदिक यदुर गिनती हारून याजक उन पार ईतामार उन द्वारा मूसा अन कहना देल आगित, अदुर विवरण ईद आद. ");
INSERT INTO hoy_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","याता याता वस्तु उन माळोद आग्या यहोवा मूसा अक कोटीदुन अदरी यहूदा अन गोत्र वाळा बसलेल, जो हूर उन नातु अदिक ऊरी इन पार ईरोन, माळ बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","अदिक आऊन सांगुळ दान इन गोत्र वाळा, अहीसामाक उन पार, ओहोलीआब ईरोन, जो नकाशी माळली अदिक कळुसावाळा अदिक नीळा, जांभळा अदिक क्याचांद रंग इन अदिक सुक्ष्म सन इन कपळा दा कढ़ाई माळावाळा निपुन कारीगर ईरोन. ");
INSERT INTO hoy_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्रस्थान इन सप्पा क्याल्सा दा जो भेंट इन व्हान्ना हत्त अद पवित्रस्थान इन शेकेल इन हिसाब देल उंत्तीस किक्कार अदिक येळ सौ तीस शेकेल ईरोद, मतलब ऊंद हजार येढ्ढ किलो. ");
INSERT INTO hoy_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","अदिक मंडली इन आळ्दकु लॉकुर्द भेंट इन बेळ्ली पवित्रस्थान इन शेकेल इन हिसाब देल सौ किक्कार अदिक सतरा सौ पच्यात्तर शेकेल मतलब मुर हजार नाक सौ तीस किलो ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","मतलब यास ईप्पत साल इनोर अदिक अदुर से यक्कुल उमर इनोर आळ्दकु आगीदुर, आंदुर आर लाख मुर हजार अईद सौ पचास मंळसा ईरोर, अदिक ऊंद ऊंद मुंदुर दी टु पवित्रस्थान इन शेकेल इन अनुसार आर्धा शेकेल, जो ऊंद बेका लगभग आर ग्राम सिक्त. ");
INSERT INTO hoy_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","अदिक अद सौ किक्कार बेळ्ली पवित्रस्थान अदिक बीच इन पळदा येढ्ढु कुर्चीगोळ्द ढाल्सदुर दा हत्तेत; सौ किक्कार देल सौ कुर्चीगोळ बनुसदव, ऊंद ऊंद कुर्ची ऊंद किक्कार इन बनुस्त. ");
INSERT INTO hoy_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","अदिक सतरा सौ पच्यात्तर शेकेल जो ऊळदोत अऊर देल खम्बागोळ्द घुंडीगोळ बन्सकु आत, अदिक खम्बागोळ्द टोकगोळ मळुसकु आदव, अदिक अऊर छळीगोळ भी बन्सकु आदव. ");
INSERT INTO hoy_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","अदिक भेंट इन पितळा सत्तर किक्कार अदिक येढ्ढ हजार नाक सौ शेकेल ईरोद; ");
INSERT INTO hoy_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","इदुर देल मिलाप इन तम्बु उन दरवाजा अन कुर्चीगोळ, अदिक पितळा अन वेदी, पितळा अन झंझरी, अदिक वेदी इन सप्पा सामान; ");
INSERT INTO hoy_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","अदिक आंगुळ इन नाकु दिकळव कुर्चीगोळ, अदिक अदुर दरवाजा अन कुर्चीगोळ, अदिक निवास, अदिक आंगुळ इन नाकु दिकळव खुटागोळ भी बन्सकु आदव. ");
INSERT INTO hoy_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","बाक आंदुर नीळा, जांभळा अदिक क्याचांद रंग इन कळुस्द कपळा पवित्रस्थान इन स्यावा अन साटी, अदिक हारून उन साटी भी पवित्र कपळा माळदुर; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","आव विशेष प्रकार इक कपळा अन्द व्हान्ना, अदिक नीळा, जांभळा अदिक क्याचांद रंग इन कपळा अन, अदिक सुक्ष्म सन इन कपळा अन बनुसदुन. ");
INSERT INTO hoy_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","अदिक आंदुर व्हान्ना पीठ्स पीठ्सकु अदुर्द पतरी माळदुर, बाक पतरीगोळी कडु कडुकु तार माळदुर, अदिक कुशल कारागीरगोळ आ तारगोळी नीळा, जांभळा अदिक क्याचांद रंग इन कपळा दा, अदिक सुक्ष्म सन इन कपळा दा कळाई इन बनावट देल मिलुस बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","एपोद इन जोळ्सली आंदुर अदुर बाक्कागोळ माकळोद बंधन माळदुर, अद तान येढ्ढु क्वानागोळ से जोळ्सकु आत. ");
INSERT INTO hoy_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","अदिक अदुर कसुसोर साटी जो काळ्सद पट्टा अदुर मा बनुस्त, अद अदुर सांगुळ बिना जोळ इन, अदिक अदुर्दा बनावट इन अनुसार, मतलब व्हान्ना अदिक नीळा, जांभळा अदिक क्याचांद रंग इन कपळा अन, अदिक सुक्ष्म सन इन कपळा अन बनुस्त; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","आंदुर सुलैमानी मणि कडुकु अऊर दा इस्त्राएल इन हन्नेळ पारगोळ हेसुर, ह्यांग छापा अगुळकु आगतद हांगा अगुळदुर, अदिक व्हान्ना नव खानगोळ दा जळुस बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","अदिक आव आंदरी एपोद इन बाक्का अन बन्धनगोळ मा हचदुन, यदुर देल इस्त्राएलीगोळ लॉकुर साटी याद माळसुसावाळा मणि ठहरूसुल; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","आव सीनाबन्द इक एपोद इन घाई व्हान्ना अन, अदिक नीळा, जांभळा अदिक क्याचांद रंग इन कपळा अन, अदिक सुक्ष्म सन इन कपळा दा बेल बुटा अन क्याल्सा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","सीनाबन्द चौकोन बनुस्त; अदिक आंदुर अदरी दोहरा माळदुर, अदिक अद दोहरा आगकु ऊंद बित्ता ऊद्द अदिक ऊंद बित्ता चौळा आत. ");
INSERT INTO hoy_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","अदिक आंदुर अदुर दा नाक लाईन दा मणि हाकदुर. पयला लाईन दा माणिक्य; पुखराज, अदिक लालड़ी हाकदुर; ");
INSERT INTO hoy_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","अदिक दुसरा लाईन दा मरकत, नीलमणि, अदिक हीरा; ");
INSERT INTO hoy_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","अदिक तीसरा लाईन दा लशम, सुर्यकांत, अदिक नीलम; ");
INSERT INTO hoy_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","अदिक चौथा लाईन दा फिरोजा, सुलैमानी मणी, अदिक यशब हाकदुर; ई सप्पा अलग अलग सीना अन खानगोळ दा हाक्कु आदव. ");
INSERT INTO hoy_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","अदिक ई मणि इस्त्राएल इन पारगोळ्द हेसुरगोळ गिनती इन अनुसार हन्नेळ ईरव; हन्नेळ गोत्रगोळ दा टु ऊंद ऊंद हेसुर ह्यांग छापा अगुळकु आगतद हांगा अगुळकु आत. ");
INSERT INTO hoy_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","अदिक आंदुर सीनाबन्द मा डोरीगोळ घाई गुथुस्द खरा व्हान्ना अन जंजीर माळकु हचदुर; ");
INSERT INTO hoy_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","बाक आंदुर व्हान्ना नव येढ्ढ खाना, अदिक व्हान्ना अन येढ्ढ कळीगोळ माळकु येढ्ढु कळीगोळी सीनाबन्द इन येढ्ढु क्वाना मा हचदुर; ");
INSERT INTO hoy_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","आग आंदुर व्हान्ना नव येढ्ढु गुथुस्द जंजीरगोळी सीनाबन्द इन क्वाना माकळोद येढ्ढु कळीगोळ दा हचदुर. ");
INSERT INTO hoy_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","अदिक गुथुस्द येढ्ढु जंजीरगोळ्द मिक्द येढ्ढु क्वानागोळी आंदुर येढ्ढु खानागोळ दा हाक्कु, विशेष कपळा अन्द मुंद येढ्ढु बाक्का अन बन्धनगोळ मा हचदुर. ");
INSERT INTO hoy_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","आग आंदुर व्हान्ना अन अदिक येढ्ढ कळीगोळ माळकु सीनाबन्द इन येढ्ढु क्वाना मा अदुर आ कोर मा, जो एपोद इन बुळ्क इन भाग दा ईरोद, हचदुर. ");
INSERT INTO hoy_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","अदिक आंदुर व्हान्ना अन मात्त येढ्ढ कळीगोळ भी माळकु एपोद इन येढ्ढु बाक्का अन बन्धनगोळ मा ल्यालमा टु अदुर मुंद, अदिक जोळ इन हात्ती विशेष कपळा अन्द काळुस्द पट्टा मा म्याकुच हचदुर. ");
INSERT INTO hoy_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","आग आंदुर सीनाबन्द इक अदुर कळीगोळ द्वारा एपोद इन कळीगोळ दा नीळा फिता देल हींग कटदुर कि अद एपोद इन काळुस्द पट्टा अन म्याकुच ईरूल, अदिक चपरास एपोद देल अलग आग सकबाळुल; ह्यांग यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","बाक एपोद इन कुर्ता पुरा नीळा रंग इन माळकु आत. ");
INSERT INTO hoy_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","अदिक अदुर बनावट हींग आत कि अदुर न्याड्या गोठ इन गड्डा अन घाई ऊंद गड्डा बनुस्त, अदिक गड्डा अन नाकु दी ऊंद कोर बनुस्त कि अद हरूबाळुल. ");
INSERT INTO hoy_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","आंदुर अदुर्द ल्यालमा अन घ्यारा दा नीळा, जांभळा अदिक क्याचांद रंग इन कपळा अन अनार माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","आंदुर शुद्ध व्हान्ना अन घंटीगोळ भी माळकु बागा अन ल्यालमा अन घ्यारा अन नाकु दी अनारगोळ्द बीचोबीच हचदुर; ");
INSERT INTO hoy_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","मतलब बागा अन ल्यालमागोळ्द घ्यारा अन नाकु दी ऊंद व्हान्ना अन घंटी, अदिक ऊंद अनार, बाक ऊंद व्हान्ना अन घंटी, अदिक ऊंद अनार हचकु आत कि अवरी हाक्कु स्यावा टहल माळुल; ह्यांग यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","बाक आंदुर हारून, अदिक आऊन पारगोळ साटी बनुस्द सुक्ष्म सन इन कपळा अन अंगरखा, ");
INSERT INTO hoy_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","अदिक सुक्ष्म सनी इन कपळा अन पगळी, अदिक सुक्ष्म सन इन कपळा अन सुंदर टोपीगोळ; अदिक सुक्ष्म सनी इन कपळा अन जंग्यागोळ, ");
INSERT INTO hoy_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","अदिक सुक्ष्म सन इन कपळा अन अदिक नीळा, जांभळा अदिक क्याचांद रंग इन कढ़ाई इन क्याल्सा माळ्द पगळी; ई सप्पा अक याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन हांगा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","बाक आंदुर पवित्र मुकुट इन पट्टी शुद्ध व्हान्ना अन माळदुर; अदिक ह्यांग छापा दा हांगा अदुर दा ई अक्षर अगुळकु आदव, मतलब “यहोवा अन साटी पवित्र.” ");
INSERT INTO hoy_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","अदिक आंदुर अदुर दा नीळा जाळी हचदुर, यदुर देल अद म्याकुच पगळी मा ईरूल, याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ईत्ता प्रकार देल मिलाप इन तम्बु उन निवास इन सप्पा क्याल्सा खतम आदव, अदिक याता याता क्याल्सा अन आग्या यहोवा मूसा अक कोटीदुन, इस्त्राएलीगोळ अदुर्दा अनुसार माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","आग आंदुर निवास इक मूसा अन हात्ती तंदुर: मतलब घुंडीगोळ, पाटीगोळ, बेंडगोळ, खम्बागोळ, कुर्चीगोळ आदि सप्पा सामान समेत तम्बु; ");
INSERT INTO hoy_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","अदिक क्याचांद रंग देल रंगुस्द म्यांडागोळ्द तोगुल इन होदोद, अदिक सूइसगोळ तोगुल इन होदोद, अदिक न्याड्या अन पळदा; ");
INSERT INTO hoy_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","डंडा सहित साक्षीपत्र इन सन्दुक, अदिक प्रायश्चित इन झाकनी; ");
INSERT INTO hoy_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","सप्पा सामान समेत मेज, अदिक भेंट इन रोट्टीगोळ; ");
INSERT INTO hoy_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","सप्पा सामान सहित दिवट, अदिक अदुर सजावट इन दिंग्या, अदिक ऊजुळ कोळोर साटी याण्णा; ");
INSERT INTO hoy_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","व्हान्ना अन वेदी, अदिक अभिषेक इन याण्णा; अदिक सुगन्धित धूप, अदिक तम्बु उन दरवाजा अन पळदा; ");
INSERT INTO hoy_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","पीतळ इन झंझरी, डण्डागोळ अदिक सप्पा सामान समेत पीतळ इन वेदी; अदिक पाया सांगुळ गंगार; ");
INSERT INTO hoy_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","खम्बागोळ अदिक कुर्चीगोळ समेत आंगुळ इन पळदागोळ, अदिक आंगुळ इन दरवाजा अन पळदा, अदिक डोरीगोळ, अदिक खुटागोळ, अदिक मिलाप इन तम्बु उन निवास इन स्यावा अन सप्पा सामान; ");
INSERT INTO hoy_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","पवित्रस्थान दा स्यावा टहल माळोर साटी बेल बुटा काळुस्द कपळा, अदिक हारून याजक उन पवित्र कपळा, अदिक आऊन पारगोळ्द कपळा यवरी हाक्कु आंदरी याजक उन क्याल्सा माळोद ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","मतलब जो जो आग्या यहोवा मूसा अक कोटीदुन अऊर्दा अनुसार इस्त्राएलीगोळ सप्पा क्याल्सा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","आग मूसा सप्पा क्याल्सा अन निरीक्षण माळकु नोळदुन कि आंदुर यहोवा अन आग्या अन अनुसार सप्पा येनारा माळदुर. अदिक मूसा आंदरी आशीर्वाद कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पयला तिंगुळ इन पयला दिन इक नी मिलाप इन तम्बु उन निवास इक निद्रुस बुळेत. ");
INSERT INTO hoy_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","अदिक अदुर दा साक्षीपत्र अन सन्दुक इक ईटकु बीच इन पळदा देल व्हर्तुस बुळी. ");
INSERT INTO hoy_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","अदिक मेज इक बुळ्क ओतकु जो येनारा अदुर मा सजुसोद आद अदरी सजुस बुळेत; आग दीवट इक बुळ्क ओतकु अदुर दिंग्यागोळी होताक बुळेत. ");
INSERT INTO hoy_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","अदिक साक्षीपत्र अन सन्दुक इन मुंद व्हान्ना अन वेदी इक, जो धूप इन साटी आद अदरी ईटेत, अदिक निवास इन दरवाजा अन पळदा अक हच बुळेत. ");
INSERT INTO hoy_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","अदिक मिलाप इन तम्बु उन निवास इन दरवाजा अन मुंद होमवेदी इक ईटेत. ");
INSERT INTO hoy_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","अदिक मिलाप इन तम्बु अदिक वेदी इन न्याड्या हौदी इक ईटकु अदुर दा नीर तुमेत. ");
INSERT INTO hoy_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","अदिक नाकु दिकळोद आंगुळ इन कनात इक निद्रुसेत, अदिक आ आंगुळ इन दरवाजा मा पळदा अक हिलगुस बुळेत. ");
INSERT INTO hoy_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","अदिक अभिषेक इन याण्णा हुडुकु निवास इन अदिक जो येनारा अदुर दा ईत्तीत सप्पा येनारा अन अभिषेक माळेत, अदिक सप्पा सामान समेत अदरी पवित्र माळेत; आग अद पवित्र ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","सप्पा सामान समेत होमबली वेदी इन अभिषेक माळकु अदरी पवित्र माळेत; आग अद परम पवित्र ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","पाया समेत गंगार इन भी अभिषेक माळकु अदरी पवित्र माळेत. ");
INSERT INTO hoy_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","आग हारून अदिक आऊन पारगोळी मिलाप इन तम्बु उन दरवाजा मा ओतकु नीर देल मय तोळसुसेत, ");
INSERT INTO hoy_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","अदिक हारून उक पवित्र कपळा हाकसुसेत, अदिक आऊन अभिषेक माळकु आऊक पवित्र माळेत कि आव नान साटी याजक उन क्याल्सा माळुल. ");
INSERT INTO hoy_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","अदिक आऊन पारगोळी ओतकु अंगरखा हाकसुसेत, ");
INSERT INTO hoy_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","अदिक ह्यांग नी आंदुर आप्प उन अभिषेक माळ्या हांगा आंदुर्द भी अभिषेक माळेत कि आंदुर नान साटी याजक उन क्याल्सा माळुल; अदिक आंदुर अभिषेक आंदुर्द पीढ़ोन पीढ़ी अन साटी आंदुर्द हमेशा अन याजकपद इन चिन्ह ठहरूसीत.” ");
INSERT INTO hoy_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ईत्ता प्रकार देल मूसा, जो आग्या यहोवा आऊक कोटीदुन अदुर्दा अनुसार माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","अदिक दुसरा साल इन पयला तिंगुळ इन पयला दिशी निवास निद्रुसकु आत. ");
INSERT INTO hoy_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मूसा निवास इक निद्रुसुसदुन, अदिक अदुर कुर्चीगोळ हुळकु अदुर तखत हचकु अऊर दा बेंड हाकदुन, अदिक अदुर खम्बागोळी निद्रुसदुन; ");
INSERT INTO hoy_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","अदिक आव निवास इन म्याकुच तम्बु उक फैलुसदुन, अदिक तम्बु उन म्याकुच आव ओढ़ना अक हचदुन; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","अदिक आव साक्षीपत्र अक हुडुकु सन्दुक दा ईटदुन, अदिक सन्दुक दा डण्डागोळी हचकु अदुर म्याकुच प्रायश्चित इन झाकनी इक ईट कोट्टुन; ");
INSERT INTO hoy_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","अदिक आव सन्दुक इक निवास दा पोहचुसदुन, अदिक बीच इन पळदा अक हिलगुसकु साक्षीपत्र अन सन्दुक इक अदुर बुळ्क माळदुन; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","अदिक आव मिलाप इन तम्बु दा निवास इन उत्तर दिशा दी न्याड्या अन पळदा से व्हार्या मेज इक हचदुन, ");
INSERT INTO hoy_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","अदिक अदुर मा आव यहोवा अन मुंद रोट्टी सजुसकु ईटदुन; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","अदिक आव मिलाप इन तम्बु दा मेज इन मुंद निवास इन दक्षिण दिशा दी दीवट इक ईटदुन, ");
INSERT INTO hoy_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","अदिक आव दिंग्यागोळी यहोवा अन मुंद होताक बुट्टुन; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","अदिक आव मिलाप इन तम्बु दा न्याड्या अन पळदा अन मुंद व्हान्ना अन वेदी इक ईटदुन, ");
INSERT INTO hoy_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","अदिक आव अदुर मा सुगन्धित धूप होताकदुन; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","अदिक आव निवास इन दरवाजा मा पळदा अक हचदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","अदिक मिलाप इन तम्बु उन निवास इन दरवाजा मा होमवेदी इक ईटकु अदुर मा होमबलि अदिक अन्नबलि इक येर्सदुन; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","अदिक आव मिलाप इन तम्बु अदिक वेदी इन न्याड्या गंगार इक ईटकु अदुर दा तोळोर साटी नीर हाकदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","अदिक मूसा, हारून अदिक आऊन पारगोळ अदुर दा तान तान कय काल तोळदुर; ");
INSERT INTO hoy_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","अदिक याग याग आंदुर मिलाप इन तम्बु दा या वेदी इन हात्ती होगतोगोर आग आग आंदुर कय काल तोळु तोगोर; याता प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","अदिक आव निवास इन नाकु दी अदिक वेदी इन आसपास आंगुळ इन कनात इक निद्रुसुसदुन, अदिक आंगुळ इन दरवाजा अन पळदा अक हिलगुस बुट्टुन. ईत्ता प्रकार देल मूसा सप्पा क्याल्सा पुरा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","आग बादल मिलाप इन तम्बु मा छासेत, अदिक यहोवा अन तेज निवास स्थान दा तुम्मेत. ");
INSERT INTO hoy_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","अदिक बादल मिलाप इन तम्बु मा रूकसेत, अदिक यहोवा अन तेज निवास स्थान दा तुम्मेत, ई कारण मूसा अदुर दा प्रवेश माळ सकीदील. ");
INSERT INTO hoy_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","इस्त्राएलीगोळ्द पुरा यात्रा दा हींग आगतोगोद, कि याग याग अद बादल निवास इन म्याकुच टु येळोद आग आग आंदुर अल टु नळोद चालु माळतोगोर; ");
INSERT INTO hoy_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","अदिक अगर अद ईला येळतोगोद, रा याता दिशी ताका अद ईला येळतोगोद आ दिशी ताका आंदुर अल टु ईला नळुतोगोर. ");
INSERT INTO hoy_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","इस्त्राएल इन लॉकुर इन पुरा यात्रा दा हागुल इक रा यहोवा अन बादल निवास मा, अदिक ईळ्लकी अदा बादल दा बेक्‍की आ सप्पा मुंदुरी कांळ्सकु बिळतोगोद.");
INSERT INTO hoy_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","आग यहोवा मूसा अक कारूकु भेटवाळा तम्बु दा टु आऊन से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","इस्राएलिगोळ सांगुळ मातगोळ माळ अदिक आंदुर से ईद अन, याग नीम दा टु यावारा मंळसा यहोवा अन्‍द साटी बलिदान तरूल रा आव पालस्द पशु ईला रा म्यांडा मर्रगोळ दा टु उच तनकु येरसुल. ");
INSERT INTO hoy_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","अगर आऊन चढ़ावा पालस्द पशु दा टु होमबली आगुल रा आव दोषरहित नर इक येरसुल. आव अदरी भेंटमाळोद तम्बू उन दरवाजा मा येरसुल कि अद खुद यहोवा अन्द मुंद ग्रहण लायक ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","आव तान कय होमबली इन पशु उन ताल्ला मा ईटुल, अदिक अद आंदुर साटी प्रायश्चित माळोर साटी ग्रहण माळकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","आग आव आ वासरू उक यहोवा अन्द मुंद बली येरसुल, अदिक हारून उन पार जो याजक आन आंदुर रकत इक हात्ती ओतकु आ वेदी इन नाकु दी सिपसुल जो भेंटमाळोद तम्बू उन दरवाजा मा आद. ");
INSERT INTO hoy_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","आग आव आ होमबली इन पशु उन तोगुल तेगुकु आ पशु उन तुकळा-तुकळा माळ बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","आग हारून याजक उन पार वेदी मा बेक्की ईटुल, अदिक बेक्की मा हुळ्ली रचस्कु ईटुल. ");
INSERT INTO hoy_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","अदिक हारून उन पार जो याजक आन अऊर ताल्ला अदिक न्याण सांगुळ पशु उन तुकळागोळी आ हुळ्ली मा जो वेदी इन बेक्की मा आद रचस्कु ईटुल, ");
INSERT INTO hoy_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","अदिक आव अदुर्द कळ्लपच्चीगोळी अदिक कालगोळी नीर देल तोळुल. आग याजक ईव सप्पा अक होमबली माळकु वेदी मा होताकुल कि अद होमबली यहोवा अन साटी सुखदायक सुगन्धित बलिदान ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“अगर आव म्यांडागोळ या व्हातगोळी होमबली येरसुल रा तंदरूस्त नर उक येरसुल; ");
INSERT INTO hoy_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","अदिक आव अदरी वेदी इन उत्तरी दिशा दी यहोवा अन मुंद बली माळुल अदिक हारून उन पार जो याजक आन अदुर्द रकत इक वेदी इन नाकु दी सिपसुल. ");
INSERT INTO hoy_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","अदिक आव अदरी तुकळा-तुकळा माळुल, ताल्ला अदिक न्याण इक अलग माळुल, अदिक याजक ईव सप्पा चीज इक आ हुळ्ली मा रचकु ईटुल जो वेदी इन बेक्की मा ईत्तीत; ");
INSERT INTO hoy_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","अदिक आव अदुर्द कळ्लपच्चीगोळी अदिक कालगोळी नीर देल तोळुल. अदिक याजक सप्पा चीज इक हात्ती वोतकु वेदी मा होताकुल कि अद होमबली आगुल अदिक यहोवा अन्द साटी सुखदायक सुगन्धवाळा बलिदान ठहरूसुल.” ");
INSERT INTO hoy_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“अगर आव यहोवा अन्द साटी पक्षीगोळ्द होमबली येरसुल, रा पंडुका या कबूतर इन पाड्डगोळ्द चढ़ावा येरसुल.” ");
INSERT INTO hoy_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","याजक अदरी वेदी इन हात्ती वतकु अऊरव कुतक्या मुरकुळ्सकु ताल्ला अक धळ देल अलग माळुल, अदिक वेदी मा होताकुल; अदिक अदुर्द पुरा रकत आ वेदी इन बाजु मा केडुकु आगुल; ");
INSERT INTO hoy_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","अदिक आव कुतक्या-थैली अदिक पिक्‍कागोळी तेगुकु वेदी इन पूर्व दी राख हाक्कोद जागा मा भीट बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","आग आव येढ्ढु पिक्‍कागोळी हुडुकु अदरी बीच दा टु हरूल, लेकीन अदरी अलग-अलग माळबाळुल. आग याजक अदरी वेदी मा आ हुळ्ली इन म्याकुच ईटकु जो बेक्की मा ईत्तीत होताकुल कि अद होमबली अदिक यहोवा अन्द साटी सुखदायक सुगन्धवाळा बलिदान ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","याग यावारा यहोवा अन्द साटी अन्नभेट इन चढ़ावा येरसोद चाहसुल, रा आव मैदा येरसुल; अदिक अदुर मा याण्णा हाक्कु अदुर म्याकुच लुबान ईटुल; ");
INSERT INTO hoy_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","अदिक आव अदरी हारून इन पारगोळ हात्ती जो याजक आन तरूल. अदिक अन्नभेट इन याण्णा मिलुस्द मैदा दा टु ई तरीका देल तान ठ्वामा तुमकु तेगुल कि सप्पा लुबान अदुर दा होट बरूल; अदिक याजक आंदरी याद दिलुसोद भाग इन साटी वेदी मा होमबली होताकुल कि ईद यहोवा अन्द साटी सुखदायक सुगन्धित भेंट ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","अदिक अन्नभेट दा टु जो मिक्कु ईरूल अद हारून अदिक आऊन पारगोळ्द ठहरूसुल; ईद यहोवा अन्द होमबली दा टु परम पवित्र भाग आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“याग नी अन्नभेट इन साटी तंदुर दा कासकु चढ़ावा येरस्या, रा अद याण्णा दा मिलुस्कु अखमीरी मैदा अन्द फुलका, या याण्णा दा चोपळुस्कु अखमीरी रोट्टीगोळ्द ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","अदिक अगर नीन चढ़ावा तावा मा कासकु अन्नभेट ईरूल, रा अद याण्णा देल मिलुस्कु अखमीरी मैदा अन्द ईरूल; ");
INSERT INTO hoy_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","अदरी तुकळा-तुकळा माळकु अदुर मा याण्णा हाकेत, आग अद अन्नभेट आगेदीत. ");
INSERT INTO hoy_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","अदिक ईद नींद चढ़ावा कळाई दा ताळस्कु अन्नभेट ईरूल, रा अद मैदा देल याण्णा दा माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","अदिक जो अन्नभेट इन ई वस्तुगोळ दा टु यारदारा माळकु ईरूल अदरी यहोवा अन्द मुंद ओईल; अदिक याग अद याजक उन हात्ती तंदकु आगुल, आग याजक अदरी वेदी इन मुंद ओईल. ");
INSERT INTO hoy_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","अदिक याजक अन्नभेट दा टु याद तोरसोर भाग इक तेगुकु होमबली मा होताकुल कि अद यहोवा अन्द साटी सुखदायक सुगन्धवाळा भेंट ठहरूसुल; ");
INSERT INTO hoy_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अदिक अन्नबली दा टु जो मिक्कु ईरूल अद हारून अदिक आऊन पारगोळ्द ठहरूसुल; अद यहोवा अन्द होमबली दा परम पवित्र भाग आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“यातोदारा भी अन्नभेट यदरी नीव यहोवा अन्द साटी येरसी खमीर मिलुस्कु माळकु आगबाळुल; नीव यागलु होमबली दा यहोवा अन्द साटी खमीर अदिक शयद होताक बाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","नीव इंदरी पयला उपज इन चढ़ावा बनुस्कु यहोवा अन्द साटी येर्सेतीर, लेकीन अव सुखदायक सुगन्ध इन साटी वेदी मा येर्सकु आगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","बाक तान सप्पा अन्नभेटगोळ इक नमकीन माळेतीर; अदिक तान यातोदारा भी अन्नभेट इक तान परमेश्वर उन सांगुळ वादा अन्द ऊप्प देल नमकीन आगगोळ बाळेतीर; तान सप्पा चढ़ावागोळ्द सांगुळ ऊप्प भी येर्सेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“अगर नी यहोवा अन्द साटी पयला उपज इन अन्नभेट येरस्या, रा तान पयला उपज इन अन्नभेट इन साटी बेक्की दा सुटकु हिवरा-हिवरा लॉम्बागोळी, मतलब हिवरा-हिवरा लॉम्बागोळी सुटकु मसलुस कोमेत, आग अनाज इक येर्सेत. ");
INSERT INTO hoy_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","अदिक अदुर दा याण्णा हाकेत, अदिक अदुर म्याकुच लुबान ईटेत; आग अद अन्नभेट आगेदीत. ");
INSERT INTO hoy_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","अदिक याजक सुटकु तेग्द अन्न अक, अदिक याण्णा अक, अदिक पुरा लुबान इक याद तोरसोद भाग माळकु होताक बुळुल; अद यहोवा अन्द साटी होमबली इन बेक्की ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“अगर आऊन चढ़ावा मेल-मिलाप इन आगुल, अदिक अगर आव पालस्द पशु दा टु यारीकारा येरसुल, रा बाक अद पशु नर आगुल या मादा, लेकीन जो तंदरूस्त ईरूल अदरी का आव यहोवा अन्द मुंद येरसुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","अदिक आव तान कय तान चढ़ावा अन्द पशु उन ताल्ला मा ईट्टुल अदिक अदरी भेंटमाळोद तम्बू उन दरवाजा मा बली कोळुल; अदिक हारून उन पार जो याजक आन आंदुर आऊन रकत इक वेदी इन नाकु दी सिपसुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","आव मेल-मिलाप दा टु यहोवा अन्द साटी होमबली इन बेक्की मा हाकुल, मतलब या न्याणद देल कळ्लपच्चीगोळ ढाक्सकु ईरताव, अदिक जो न्याण अदुर्दा गुंळ्सकु ईरतद अद भी, ");
INSERT INTO hoy_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","अदिक येढ्ढु फॉफसागोळ अदिक अदुर म्याकुच इन न्याण जो नेळु उन हात्ती ईरतद, अदिक फॉफसा अन सांगुळ ईरग्या अन्द म्याकुच इन परत, ईव सप्पा अक आव अलग माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","आग हारून इन पार इदरी वेदी मा आ होमबली इन म्याकुच होताकुल, जो आ हुळ्लीगोळ मा ईत्तीत जो बेक्की इन म्याकुच आद, कि ईद यहोवा अन्द साटी सुखदायक सुगन्धवाळा भेंट ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“अगर यहोवा अन्द मेल-मिलाप बलिदान इन साटी चढ़ावा पालस्द पशु दा टु ईरूल, रा चाहे अद नर आगुल या मादा, लेकीन जो तंदरूस्त ईरूल अदरी का आव येरसुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","अगर आव म्यांडा अन्द पाड्डा येर्सतान, रा अदरी यहोवा अन्द मुंद येरसुल, ");
INSERT INTO hoy_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","अदिक आव तान चढ़ावा अन्द पशु उन ताल्ला मा कय ईटुल अदिक अदरी भेंटमाळावाळा तम्बु उन मुंद बली कोळुल; अदिक हारून उन पार अदुर रकत इक वेदी इन नाकु दी सिपसुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","आग मेलबली इक यहोवा अन्द साटी बेक्की इन होमबली मा हाकुल, अदिक अदुर न्याण तुमकु धोळ पुसटी अद रीढ़ इन हात्ती टु अलग माळुल, अदिक या न्याण देल कळ्लपच्चीगोळ ढाक्सकु ईरताव, अदिक जो न्याण अदुर्दा गुंळ्सकु ईरतद, ");
INSERT INTO hoy_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","अदिक येढ्ढु फॉफसागोळ, अदिक जो न्याण अदुर म्याकुच नेळु उन हात्ती ईरतद, अदिक फॉफसागोळ सांगुळ ईरग्या अन म्याकुच इन झिल्ली, ईव सप्पा चीज इक आव अलग माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","अदिक याजक इदरी होमबली मा होताकुल; ईद यहोवा अन्द साटी भेंट रूपी ऊमोद ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“अगर आव मर्री येरसुल, रा अदरी यहोवा अन्द मुंद येरसुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","अदिक आव तान कय अदुर ताल्ला मा ईटुल, मात्त अदरी भेंटमाळोद तम्बू उन मुंद बली कोळुल; अदिक हारून उन पार अदुर्द रकत इक वेदी इन नाकु दी सिपसुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","आग आव अदुर दा टु तान चढ़ावा यहोवा अन्द साटी बेक्की इन होमबली मा येरसुल, अदिक या न्याण देल कळ्लपच्चीगोळ ढाक्सकु ईरताव, अदिक जो न्याण अदुर्दा गुंळ्सकु ईरतद अद भी, ");
INSERT INTO hoy_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","अदिक येढ्ढु फॉफसागोळ अदिक जो न्याण अदुर म्याकुच नेळु उन हात्ती ईरतद, अदिक फॉफसागोळ सांगुळ ईरग्या अन्द म्याकुच इन परत, ईव सप्पा चिज इक आव अलग माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","अदिक याजक इदरी होमबली मा होताकुल; ईद भेंट रूपी ऊमोद हुन जो सुखदायक सुगन्ध इन साटी ईरतद; यतिकी पुरा न्याण यहोवा अन हुन. ");
INSERT INTO hoy_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ईद नीम ईरा जागा दा नीम पीढ़ी-पीढ़ी इन साटी हमेशा अन्द विधी ठहरूसीत कि नीव न्याण अदिक रकत यागलु तिनबाळी.” ");
INSERT INTO hoy_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इस्राएलिगोळ से ईद अन कि अगर यावारा मंळसा आ क्याल्सागोळ दा टु यदरी यहोवा मना माळीदुन, यातोदारा क्याल्सा अक भूल देल माळकु पापी आगेगुल; अदिक इंदुर दा टु यावारा ऊंद मंळसा माळ्यान.” ");
INSERT INTO hoy_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","अदिक अभिषित याजक हिंग पाप माळुल, अदुर देल प्रजा दोषी ठहरूसुल, रा तान पाप इन कारण आव ऊंद हारोद वस्ता अक यहोवा अन्द पापबली माळकु येरसुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","आव आ हारोद वस्ता अक भेंटमाळोद तम्बू उन दरवाजा मा यहोवा अन्द मुंद ओतकु अदुर ताल्ला मा कय ईटुल, अदिक आ हारोद वस्ता अक यहोवा अन मुंद बली कोळुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","अदिक अभिषित याजक हारोद वस्ता अन्द रकत दा टु येनारा ओतकु भेंटमाळोद तम्बू दा ओईल; ");
INSERT INTO hoy_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","अदिक याजक तान बेल्ल रकत दा नेनाक-नेनाक्कु अदिक अदुर दा टु येनारा ओतकु पवित्र जागा अन्द न्याड्यावाळा परदा अन्द मुंद यहोवा अन मुंद येळ घन सिपसुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","अदिक याजक आ रकत दा टु येनारा मात्त हुळकु सुगन्धित धूप इन वेदी इन सींगगोळ मा जो भेंटमाळोद तम्बू दा आद यहोवा अन्द मुंद हचदुर; बाक वस्ता अन्द सप्पा रकत इक वेदी इन पायवा मा होमबली इन वेदी जो भेंट माळोद तम्बू उन दरवाजा मा आद हाक्क बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","बाक आव पापबली इन वस्ता अन्द सप्पा न्याण इक अदुर दा टु अलग माळुल, मतलब या न्याण देल कळ्लपच्चीगोळ झाक्सकु ईरताव, अदिक याट न्याण अदुर्दा गुंळ्सकु आगतद, ");
INSERT INTO hoy_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","अदिक येढ्ढु फॉफसागोळ अदिक अदुर म्याकुच इन न्याण जो नेळु उन हात्ती ईरतद, अदिक फॉफसागोळ सांगुळ ईरग्या अन्द म्याकुच इन परत, ईव सप्पा चिज इक हिंग अलग माळुल, ");
INSERT INTO hoy_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ह्यांग मेल-मिलाप इन चढ़ावा अन वस्ता से अलग माळकु आगताव, अदिक याजक ईदरी होमबली इन वेदी मा होताकुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","लेकीन आ पाड्डा अन्द तोगुल, काल, ताल्ला, कळ्लपच्चीगोळ, सेंगळी, ");
INSERT INTO hoy_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","अदिक पुरा मास, मतलब पुरा वस्ता छावनी से व्हार्या शुद्ध जागा मा, यल राख हाक्कु आदीत, ओतकु हुळ्लीगोळ मा ईटकु बेक्की देल होताकुल; यल राख हाक्कु आगतद अद अल्या होताक्कु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“अगर इस्राएल इन पुरा मंडली अग्यानता अन कारण पाप माळुल अदिक अद मात मंडली इन कण्णगोळ देल होचकु आद, अदिक आंदुर यहोवा अन्द यातोदु आग्या अन खिलाप येनारा माळकु दोषी ठहरूस्यार.” ");
INSERT INTO hoy_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","रा याग आंदुर्द माळ्द पाप प्रगट आगुल आग मंडली ऊंद वस्ता अक पापबली माळकु येरसुल. आव अदरी भेंटमाळोद तम्बू उन मुंद ओईल, ");
INSERT INTO hoy_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","अदिक मंडली इन स्याणा हाळाबाट्टुर तान-तान कयगोळी यहोवा अन्द मुंद वस्ता अन ताल्ला मा ईटुल, अदिक आ वस्ता यहोवा अन्द मुंद बली माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","आग अभिषिक्त याजक वस्ता अन्द रकत दा टु थ्वाळासा भेटवाळा तम्बु दा ओईल; ");
INSERT INTO hoy_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","अदिक याजक तान बेळ्ल रकत दा नेनाक-नेनाक्कु अदरी न्याड्यावाळा परदा अन्द मुंद येळ घन यहोवा अन्द मुंद सिपसुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","अदिक अदा रकत दा टु वेदी इन सींगगोळ मा जो यहोवा अन्द मुंद भेंट माळोद तम्बू दा आद हचुल; अदिक मिक्द सप्पा रकत होमबली इन वेदी इन पायवा मा जो भेंटमाळोद तम्बू उन दरवाजा मा आद हाक्क बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","अदिक याजक वस्ता अन सप्पा न्याण तेगुकु वेदी मा होताकुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ह्यांग पापबली इन वस्ता अन्द सांगुळ माळीद हांग अच ईदुर सांगुळ भी माळुल; ई प्रकार याजक इस्राएलीगोळ साटी प्रायश्चित माळुल, आग आंदुर पाप माफ माळकु आदव. ");
INSERT INTO hoy_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","अदिक आ वस्ता अक छावनी टु व्हार्या ओतकु हांग अच होताकुल ह्यांग पयले वस्ता अक होताकीद; ईद रा मंडली इन निमित्त पापबली ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“याग यावारा प्रधान गंळ्स पाप माळुल, मतलब तान परमेश्वर यहोवा अन्द यातोदारा भी आग्या अन्द खिलाप भूल देल येनारा माळकु दोषी आगेगुल, ");
INSERT INTO hoy_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","अदिक आऊन पाप आऊन मा प्रगट आगेगुल, रा आव ऊंद तंदरूस्त व्हात बलिदान माळोर साटी तरूल; ");
INSERT INTO hoy_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","अदिक व्हात इन ताल्ला मा तान कय ईटुल, अदिक व्हात इक आ जागा मा बली माळुल यल होमबली पशु यहोवा अन्द मुंद बली माळकु आगताव; ईद पापबली ठहरूसीत.” ");
INSERT INTO hoy_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","आग याजक तान बेळ्लगोळ देल पापबली पशु उन रकत दा टु थ्वाळासा ताकोमकु होमबली इन वेदी इन सींगगोळ मा हचुल, अदिक अदुर्द रकत होमबलि इन वेदी इन पायवा मा पलटुस बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","अदिक आव अदुर्द पुरा न्याण इक मेलबली इन न्याण इन घाई वेदी मा होताकुल; अदिक याजक आऊन पाप इन बारा दा प्रायश्चित माळुल, आग आव माफ माळकु आदान. ");
INSERT INTO hoy_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“अगर साधारण लॉकुर दा टु यावारा अग्यानता देल पाप माळुल, मतलब यातोदारा हिंग क्याल्सा यदरी यहोवा मना माळीदान अदरी माळकु दोषी ठहरूसुल, अदिक आऊन अद पाप आऊन मा प्रगट आगेगुल, ");
INSERT INTO hoy_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","रा आव आ पाप इन कारण ऊंद तंदरूस्त मर्री बलिदान माळोर साटी तरूल; ");
INSERT INTO hoy_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","अदिक आव तान कय पापबली पशु उन ताल्ला मा ईटुल, अदिक होमबली इन जागा मा पापबलि पशु उन बलिदान माळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","अदिक याजक अदुर रकत दा टु तान बेळ्ल देल थ्वाळासा ताकोमकु होमबली इन वेदी इन सींगगोळ मा हचुल, अदिक अदुर सप्पा रकत इक अदा वेदी इन पायवा मा पलटुस बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","अदिक आव अदुर्द सप्पा न्याण इक मेलबली पशु उन घाई अलग माळुल, आग याजक आऊक वेदी मा यहोवा अन्द निमित्त सुखदायक सुगन्ध इन साटी होताकुल; अदिक ई प्रकार याजक आऊन साटी प्रायश्चित माळुल, आग आऊक माफी सिक्कीत. ");
INSERT INTO hoy_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“अगर आव पापबली इन साटी ऊंद म्यांडा अन्द पाड्डा तरूल, रा अद तंदरूस्त मादा ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","अदिक आव तान कय पापबली पशु उन ताल्ला मा ईटुल, अदिक अदरी पापबलि इन साटी अल्या बलिदान माळुल यल होमबली पशु बली माळकु आगताव.” ");
INSERT INTO hoy_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","आग याजक तान बेळ्लगोळ देल पापबली इन रकत दा टु थ्वाळासा ताकोमकु होमबली इन वेदी इन सींगगोळ मा हचुल, अदिक अदुर्द सप्पा रकत इक वेदी इन पायवा मा पलटुस बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","अदिक आव अदुर्द सप्पा न्याण इक मेलबलीवाळा मेमना अन्द न्याण इन घाई अलग माळुल, अदिक याजक अदरी होमबली मा यहोवा अन्द चढावागोळ्द म्याकुच होताकुल; अदिक ई प्रकार याजक आऊन पाप साटी प्रायश्चित माळुल, अदिक आव माफ माळकु आदान. ");
INSERT INTO hoy_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“अगर यावारा गवाह आगकु हिंग पाप माळुल कि किर्‍या तिन्सकु केळकु भी कि येन नी ईद केळ्द अथवा जान्सत्या, अदिक अद मात प्रगट माळबाळुल, रा आऊक तान दोष इन भार नेगोद बिद्दीत.” ");
INSERT INTO hoy_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","अथवा अगर यावारा यातोदारा अशुद्ध वस्तु उक अग्यानता देल मुट्ट बुळुल, रा चाहे आव अशुद्ध जंगली पशु उक, चाहे अशुद्ध घरेलु पशु उक, चाहे अशुद्ध रेंगसावाळा जीव-जन्तु उन लाश आगुल, रा आव अशुद्ध आगकु दोषी ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","अथवा अगर यावारा मंळसा यातोदारा अशुद्ध वस्तु उक अग्यानता देल मुट्ट कोमुल, चाहे अद अशुद्ध वस्तु यातोदारा भी प्रकार इन यती आगबाळुल यदुर देल लॉकुर अशुद्ध आगेगतार रा याग आव आ मात इक जान्स कोंडान आग आव दोषी ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","अगर यावारा बुरा या भला माळली इक बिना सोच सम्सकु किर्‍या तिंदान, चाहे यातोदारा प्रकार इन मात दा आ मंळसा बिना सोच बिचार देल किर्या तिनकु अनुल, रा हिंग मात दा आव दोषी आ घळी दा ठहरूस्यान याग आऊक मालूम आगेदीत. ");
INSERT INTO hoy_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","आग आव ई मातगोळ दा टु यातोदारा भी मात दा दोषी ईरूल, आग या विषय दा आव पाप माळीदान आव अदरी मान्स कोमुल, ");
INSERT INTO hoy_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","अदिक आव यहोवा अन्द मुंद तान दोषबली तरूल, मतलब आ पाप इन कारण आव ऊंद मादा म्यांडा या मर्री पापबली माळोर साटी तरूल; आग याजक आ पाप इन बारा दा आऊन साटी प्रायश्चित माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“अगर आऊक म्यांडा या मर्री कोळोद सामर्थ्य ईला ईतीदाद, रा तान पाप इन कारण येढ्ढ पंडुक या कबूतर इन पाड्डा दोषबली येरसोर साटी यहोवा अन्द हात्ती तरूल, अदुर दा टु ऊंद रा पापबली इन साटी अदिक दुसरा होमबली इन साटी. ");
INSERT INTO hoy_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","आव अवरी याजक उन हात्ती तरूल, अदिक याजक पापबली माळकु आत अदरी पयले येरसुल, अदिक अदुर्द ताल्ला कुतक्या टु मुरकुळ्स बुळुल, पर अलग माळबाळुल, ");
INSERT INTO hoy_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","अदिक आव पापबली पशु उन रकत दा टु येनारा तरी वेदी इन बाजु मा सिपसुल, अदिक जो रकत मिक्कु ईरूल अद वेदी इन पायवा मा हाक्कु आगुल; आव रा पापबली ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","आग दुसरा पक्षी अक अद नियम इन अनुसार होमबली माळुल, अदिक याजक आऊन पाप इन प्रायश्चित माळुल, अदिक आग आव माफ माळकु आदान. ");
INSERT INTO hoy_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“अगर आव येढ्ढ पंडुक या कबूतर इन येढ्ढ पाड्डा भी कोळ ईला सकुल, रा आव तान पाप इन कारण तान चढ़ावा एपा अन्द हतवा भाग मैदा पापबली माळकु तरूल; अदुर मा न रा आव याण्णा हाकुल, अदिक न लुबान ईट्टुल यतिकी अद पापबली आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","आव अदरी याजक उन हात्ती तरूल, अदिक याजक अदुर दा टु तान ठ्वामा तीम याद तोरसोद भाग जान्सकु होमबली मा यहोवा अन्द बेक्कीगोळ्द म्याकुच होताकुल; अद रा पापबली ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","अदिक ई मातगोळ दा टु यातोदारा भी मात इन बारा दा जो यावारा पाप माळुल, याजक आऊन प्रायश्चित माळुल, अदिक आग अद पाप माफ माळकु आदीत. अदिक ई पापबली इन मिक्कु अन्नबली इन मिक्कु मैदा याजक उन ठहरूसीत.” ");
INSERT INTO hoy_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","बाक यहोवा मूसा अक ईद आदेश कोट्टुन, ");
INSERT INTO hoy_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ अगर यावारा मंळसा विश्वासघात माळुल अदिक अनजाना दा यहोवा अन्द पवित्र वस्तुगोळ्द संदर्भ दा पाप माळुल, रा आव तान द्वारा माळकु विश्वासघात इन साटी यहोवा अन्द मुंद दोषबली इन रूप दा म्यांडा दा टु ऊंद तंदरूस्त म्यांडा भेंट माळुल, अदुर किंमत पवित्र जागा अन्द शेकेल इन अनुसार बेळ्ल तीम ईरूल, ईद दोषबली हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","आव या पवित्र वस्तु उन बारा दा पाप माळदुन, अदुर साटी आव नुकसान इन भरपाई माळुल. आव इदुर दा इदुर्द पाचवा भाग इक जोळ्सकु याजक उक सौप्स बुळुल. याजक दोषबली इन म्यांडा अन्द सांगुळ आऊन साटी प्रायश्चित माळुल अदिक आऊन ईद पाप माफ माळकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“अगर यावारा मंळसा पाप माळतान अदिक यावारा भी अद क्याल्सा माळतान, जो यहोवा अन्द दी टु मना माळकु आग्याद, अगर आव इदुर देल अनजान आन, तौभी आव दोषी आन अदिक तान दण्ड इन भार नेगदान. ");
INSERT INTO hoy_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","बाक आव दोषबली इन साटी म्यांडा दा टु उचित किंमत इन ऊंद तंदरूस्त म्यांडा तरूल कि याजक आ मंळसा अन्द द्वारा माळकु आ विश्‍वासघात इन साटी, जो आव अनजाना दा माळीदुन, प्रायश्चित माळुल, अदिक आऊन ईद विश्वासघात माफ माळकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ईद ऊंद दोषबली हुंद; बिना संकोच आव यहोवा अन्द नजर दा दोषी ईरोन.” ");
INSERT INTO hoy_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","बाक यहोवा मूसा अक अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","यहोवा अन्द विरूद्ध अगर यावारा मंळसा पाप माळकु विश्वासघात माळुल या तान मान्ना हातळोर मंळसा अन्द द्वारा सौप्सकु आग्याद धन-दौलत या अदुर्द देखभाल इन बारा दा आऊन से छल माळुल या आऊक लुटसुल या तान मान्ना हातळोर मंळसा अक सतुसुल, ");
INSERT INTO hoy_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","या आऊक यातोदारा काळ्‍दकु वस्तु प्राप्त आगुल अदिक आव इदुर बारा दा ख्वाटा माताळकु ख्वाटा किर्या तिनुल, आग इदुर दा टु यातोद भी क्याल्सा माळोद द्वारा मंळसा पापी ठहरूस्तार; ");
INSERT INTO hoy_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","“रा याग आव हिंग क्याल्सा माळकु दोषी आगेगुल, आग जो भी वस्तु आव लुट्स्दुन, या अत्याचार माळकु, या धन-दौलत, या काळ्द चिज जो आऊक सिक्त; ");
INSERT INTO hoy_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","यातोदारा वस्तु यती आगबाळुल यदुर बारा दा आव ख्वाटा किर्या तिंदीदान; रा आव अदरी पूरा-पूरा वापस माळबुळुल, अदिक पाचवा भाग भी वाळुस्कु तुम्म बुळुल, या दिशी ईद मालुम आगुल कि आव दोषी आन, अदा दिशी आ वस्तु यार्द हुन आऊक वापस माळबुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","अदिक आव यहोवा अन्द मुंद तांद दोषबली भी तरूल, मतलब ऊंद तंदरूस्त म्यांडा दोषबली इन साटी याजक उन हात्ती तरूल, अद आटा किंमत इन ईरूल यास याजक ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ई प्रकार याजक आऊन साटी यहोवा अन्द मुंद प्रायश्चित माळुल, अदिक या क्याल्सा अक माळकु आव दोषी आगेग्यान अदुर्द माफी आऊक सिक्कीत.” ");
INSERT INTO hoy_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून अदिक आऊन पारगोळ इक आग्या कोटकु ईद अन कि होमबली इन विधी ईद हुन: होमबली पूरा ईळ्लक टु हुळकु व्हातुर ताका वेदी इन बेक्की वेदी मा होततेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","याजक तान सन इन कपळा अदिक तान मय मा मलमल इन जंग्या हाकुल; अद वेदी इन राख, जो बेक्की द्वारा होत्‍ताकु आगीत, नेगुल अदिक अदरी वेदी इन ऊंद बाजु दा ईट बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","इदुर बाद्दा आव तान ईव कपळा तेगुकु दुसरा कपळा हाकुल अदिक राख इक छावनी इन व्हार्या ऊंद शुद्ध जागा मा वोईल. ");
INSERT INTO hoy_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदी मा बेक्की होततेला ईरूल. ईद नून बाळुल, लेकीन याजक इदुर मा हर रोज हुळ्ली ईटुल; इदुर मा होमबली इक ईट्टुल अदिक इदुर मा मेलबली इन न्याणद वाळा भाग इक बेक्की दा होताकतेला ईरी. ");
INSERT INTO hoy_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदी मा बेक्की लगातार होततेला ईरूल. ईद नून बाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“अन्नभेट येरसोर साटी ईद विधी आद हारून उन पार इदरी यहोवा अन्द साटी वेदी इन मुंद पेश माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","अदुर दा टु ऊंद याजक ई अन्नभेट दा टु ऊंद ठ्वामा तीम हीट, याण्णा अदिक ईदुर मा ईटकु पुरा लुबान इक ताकोमुल अदिक इदरी वेदी इन बेक्की दा होताकुल. ईद यहोवा अक याद बली इन साटी भेंट माळ्द सुखदायक सुगन्ध हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","इदुर दा टु जो भाग मिक्कुल, हारून अदिक आऊन पार आऊन इस्तेमाल माळुल. इदुर इस्तेमाल पवित्र जागा दा बिना खमीर इन रोट्टी इन रूप दा माळकु आगुल; आंदरी भेंटमाळोद तम्बू उन आंगुळ दा अच तिनुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","इदरी खमीर इन सांगुळ कासकु आगबाळुल; ना इदरी आंदुर भाग इन रूप दा तान होमबली दा टु प्रदान माळदुन, ईद पापबली अदिक दोषबली इन घाई परम पवित्र आद. ");
INSERT INTO hoy_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","हारून उन पारगोळ दा टु हर ऊंद पार इदरी तीनुल; यहोवा अक भेंट माळ्द होमबली गोळ दा टु नीम्द पीढ़ीगोळ साटी ईद हमेशा अन्द विधी हुंद. जो यावारा ई बलिगोळ इक मुट्‍यान, आव तान-ताना पवित्र आगेदान.” ");
INSERT INTO hoy_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","यहोवा मूसा अक ईद आदेश कोट्टुन, ");
INSERT INTO hoy_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“या दिशी हारून उन अभिषेक आगुल आ दिशी आव तान पारगोळ सांगुळ यहोवा अक ईद चढ़ावा येरसुल; मतलब एपा अन्द हतवा भाग हीट्ट हमेशा अन्नभेट दा येरसुल, अदुर दा आर्धा व्हातर्या का अदिक आर्धा द्यावगा अन्द समय येरसुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","अद तावा मा याण्णा अन्द सांगुळ कासकु आगुल; याग अद याण्णा देल पुरा बेंदोदित आग अदरी तरेतीर, ई अन्नभेट इन बेंदकु तुकळागोळ यहोवा अन सुखदायक सुगन्ध इन साटी येर्सेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","हारून उन पारगोळ दा टु जो भी आ याजक पद मा विराजमान आदान, आव भी अदा प्रकार इन चढ़ावा येरसुल; ईद विधी हमेशा अन्द साटी हुंद, कि यहोवा अन्द मुंद अद पुरा चढ़ावा होत्‍ताकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","याजक उन हर ऊंद अन्नभेट पुरा तरीका देल होत्‍ताकु आगुल. इदरी तिनोद आगबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","यहोवा मूसा अक ईद आदेश कोट्टुन, ");
INSERT INTO hoy_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून अदिक आऊन पारगोळ से ईद अन कि पापबली इन विधी ईद हुन; या जागा दा होमबली पशु कोंदकु आगतद अदुर दा का पापबली पशु भी यहोवा अन्द मुंद बली माळकु आगुल; आव परम पवित्र आन. ");
INSERT INTO hoy_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जो याजक पापबली येरसुल आव अदरी तिनुल; अद पवित्र जागा दा, मतलब भेंटमाळोद तम्बू उन आंगुळ दा तिनकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जो यावारा इदुर मास इक मुट्ट बुट्टान, आव पवित्र आगेदान; अगर अदुर्द रकत इन छीटागोळ यारदारा कपळागोळ मा बंदकु बिळुल, रा जरूरी आद कि इदरी यातोदारा पवित्र जागा दा अच तोळुकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","अदिक अद मुण्ण इन गळग्या यदुर्दा अद कासकु आगीदाद वडुकु आगुल; अगर अद पीतल इन बरतन दा उबालस्कु आगीदाद, रा अद उदकु आगुल, अदिक नीर देल तोळुकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","याजकगोळ दा टु सप्पा गंळ्सुर अदरी तीन सकतार; अद परम पवित्र वस्तु आद. ");
INSERT INTO hoy_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","लेकीन या पापबली पशु उन रकत दा टु थ्वाळासा भी रकत भेंटमाळोद तम्बू उन बुळ्क पवित्र जागा दा प्रायश्चित माळली पोहचुस्कु आगुल अदुर मास यागलु तिनकु आगबाळुल; अद बेक्की दा होत्‍ताकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“बाक दोषबली इन विधी ईद हुन. अद हापाळ वळ्लीद आद: ");
INSERT INTO hoy_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","या जागा मा होमबली पशु उन बली कोळतार अदा जागा मा दोषबली पशु भी बली माळुल, अदिक अदुर्द रकत इक याजक वेदी मा नाकु दी सिपसुल.” ");
INSERT INTO hoy_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","अदिक आव अदुर्द सप्पा न्याण इक येरसुल, मतलब अदुर्द चर्बीवाळा पुसटी इक, अदिक या न्याण देल कळ्लपच्चीगोळ होचकु ईरताव अव भी, ");
INSERT INTO hoy_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","अदिक येढ्ढु फॉफसागोळ अदिक जो न्याण अदुर म्याकुच अदिक नेळु उन हात्ती ईरतद, अदिक फॉफसागोळ सांगुळ ईरग्या अन्द म्याकुच इन परत; ई सप्पा अक आव अलग माळुल; ");
INSERT INTO hoy_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","अदिक याजक इदरी होमबली मा यहोवा अन्द साटी बेक्की मा होताकुल; आग आव दोषबली आदान. ");
INSERT INTO hoy_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","याजकगोळ दा टु सप्पा गंळ्सुर इदुर दा टु तिन सकतार; अद यातोदारा पवित्र जागा दा तिनकु आगुल; यतिकी अद हापाळ वळ्लीद आद. ");
INSERT INTO hoy_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","ह्यांग पापबली आद हांग अच दोषबली भी आद, आ येढ्ढु बलिगोळ्द ऊंद अच विधी आद; जो याजक आ बेलीगोळ येर्सकु पाप इक होचकोमुल आवा आ वस्तुगोळी ताकोमुल. ");
INSERT INTO hoy_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","अदिक जो याजक यावारा मंळसा अन्द साटी होमबली इक येरसुल आ होमबली पशु उन तोगुल इक आवा याजक हुडु कोमुल. ");
INSERT INTO hoy_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","अदिक भट्टी दा, या कढ़ई दा, या तावा दा सुटकु आग्याव अव सप्पा अन्नभेट आ याजक उन आदीत जो अवरी येर्सतान. ");
INSERT INTO hoy_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","हर ऊंद अन्नभेट, चाहे याण्णा मिलुस्कु ईरूल या वळ्गींद ईरूल, हारून उन सप्पा पारगोळ इक बराबर मात्रा दा सिक्कीत. ");
INSERT INTO hoy_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“आ मेल-मिलाप बलिदान इन साटी, जो यहोवा अन्द मुंद येर्सकु आगुल, अदुर साटी विधी ईद हुन:” ");
INSERT INTO hoy_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“अगर आव इदरी आभार इन रूप दा भेंट माळतान, रा आव आभार बली इन सांगुळ याण्णा दा बेंदकु अखमीरी रोट्टी, याण्णा दा बेंदकु अखमीरी सुवारी अदिक याण्णा देल बेंदकु मैदा अन्द रोट्टी भेंट माळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","अदिक आव तान धन्यवादवाळा मेल-मिलाप बलिदान इन सांगुळ खमीरी रोट्टीगोळ भी येरसुल. ");
INSERT INTO hoy_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","अदिक हिंग ऊंद-ऊंद रोट्टी नेगुकु यहोवा अक भेंट माळकु येरसुल; अद मेल-मिलाप बलिदान इन रकत इक सिपसावाळा याजक उन आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","अदिक आ धन्यवादवाळा मेलबली इन मास बलिदान येरसोद दिशी इच तिनकु आगुल; अदुर दा टु येनारा भी मिक्कु ईर बाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","लेकीन अगर अदुर्द बलिदान इन चढ़ावा मन्नत इन या खुद इन इच्छा अन ईरूल, रा आ बलिदान इक या दिशी आव येर्सकु आगुल अदा दिशी अद तिनकु आगुल, अदिक अदुर दा टु जो मिक्कु ईरूल अद दुसरा दिशी भी तिनकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","लेकीन जो येनारा बलिदान इन मास दा टु तिसरा दिन ताका मिक्कु ईरूल रा अद बेक्की दा होत्‍ताकु आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","इदुरसाटी अगर अद मेल-मिलाप बलिदान इन पशु उन चिच्ची इक तिसरा दिशी तिनकोमतान, जो अदरी भेंट माळदुन, रा अद बली स्वीकार आगतीदील अदिक आऊन साटी लाभदायक भी आगतीदिल. ईद अशुद्ध सम्सकु आदीत अदिक जो यावारा मंळसा इदरी तिनतान, आव खुद तान दोष नेगदान. ");
INSERT INTO hoy_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“बाक जो मास यावारा अशुद्ध वस्तु देल मुटकु आगुल अद तिनकु आगबाळुल; अद बेक्की दा होत्‍ताकु आगुल. बाक मेल-मिलाप बलिदान इन मास यास मुंदुर शुद्ध आर आंदुर अच तिनुल, ");
INSERT INTO hoy_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","लेकीन जो अशुद्ध आगकु यहोवा अन्द मेल-मिलाप बलिदान इन मास दा टु येनारा तिनुल रा आव तान लॉकुर दा टु नाश माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","अदिक अगर यावारा यातोदारा अशुद्ध वस्तु उक कय देल मुटकु यहोवा अन्द मेल-मिलाप बलिदान पशु उन मास दा टु तिंदान, रा आव भी तान लॉकुर दा टु नाश माळकु आदान, चाहे आव मंळसा अन यातोदारा अशुद्ध वस्तु या अशुद्ध पशु या यातोदारा भी अशुद्ध अदिक घृणित वस्तु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएलीगोळ से ई प्रकार देल अन: नीव लॉकुर न रा वस्ता अन्द येनारा न्याण तिनेतीर अदिक न म्यांडा या मर्री इन. ");
INSERT INTO hoy_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","अदिक जो पशु खुद सोतोगुल, अदिक जो दुसरा पशु देल हर्दकु आगुल, अदुर्द न्याण दुसरा क्याल्सा दा तरेतीर, लेकीन अदरी यागलु तिनबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","जो यावारा हिंग पशु उन न्याण तिंदान यदुर दा टु लॉकुर थ्वाळासा यहोवा अन्द साटी होमबली माळकु येर्सतार अद तिनावाळा तान लॉकुर दा टु नाश माळकु आदान. ");
INSERT INTO hoy_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","अदिक नीव तान मान्या यातोदारा प्रकार इन रकत, चाहे पक्षी इन चाहे पशु उन आगुल, तिनबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","हर ऊंद प्राणी जो यातोदारा प्रकार इन रकत इक तिंदान आव तान लॉकुर दा टु नाश माळकु आदान.” ");
INSERT INTO hoy_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएलीगोळ से ई प्रकार देल अन : जो यहोवा अन्द साटी मेल-मिलाप बलिदान येरसुल आव अदा मेल-मिलाप बलिदान दा टु यहोवा अन्द हात्ती भेंट तरूल; ");
INSERT INTO hoy_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","आव तान अच कयगोळ देल यहोवा अन्द होमबली इक, मतलब याद्दा सांगुळ न्याण इक तरूल कि याद्दा हालुसोद भेंट माळकु यहोवा अन्द मुंद हालुस्कु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","अदिक याजक न्याण इक रा वेदी मा होताकुल, लेकीन याद्दा हारून अदिक आऊन पारगोळ्द आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","बाक नीव तान मेलबलीगोळ दा टु ऊजवा जांघ इक भी नेगोद भेंट माळकु याजक उक कोळेतीर; ");
INSERT INTO hoy_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारून उन पारगोळ दा टु जो मेल-मिलाप बलिदान इन रकत अदिक न्याण इक येरसुल ऊजवा जांघ आऊंदा भाग आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","यतिकी इस्राएलीगोळ्द मेलबलीगोळ दा टु हालुसोद भेंट इन याद्दा अदिक नेगोद भेंट इन जांघ इक हुळकु ना याजक हारून अदिक आऊन पारगोळ इक कोटीन, कि ईद हमेशा इस्राएलीगोळ दी टु आंदुर्द हक बन्सकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“या दिशी हारून अदिक आऊन पार यहोवा अन्द हात्ती याजक पद इन साटी तनकु आदुर, अदा दिशी यहोवा अन्द होमबली गोळ दा टु आंदुर्द ईदा अभिषित भाग ठहरूसकु आत; ");
INSERT INTO hoy_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","मतलब या दिशी यहोवा आंदुर्द अभिषेक माळदुन अदा दिशी आव आग्या कोट्टुन कि आंदरी इस्राएलीगोळ दी टु ईद भाग हमेशा सिकतेला ईरूल; आंदुर्द पीढ़ी-पीढ़ी इन साटी आंदुर्द ईदा हक ठहरूसकु आत.” ");
INSERT INTO hoy_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","होमबली, अन्नभेट, पापबली दोषबली, याजकगोळ्द संस्कार बली, अदिक मेल-मिलाप बलिदान इन व्यवस्था ईदा हुन; ");
INSERT INTO hoy_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","याग यहोवा सीनै पर्वत इन हात्ती इन आळी दा मूसा अक आग्या कोट्टुन कि इस्राएली नान साटी येन-येन चढ़ावा येरस्यार, आग आव आंदरी ईदा व्यवस्था कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“नी हारून अदिक आऊन पारगोळ्द कपळागोळ इक, अदिक अभिषेक इन याण्णा, अदिक पापबली इन हारोद वस्ता, अदिक येढ्ढु म्यांडागोळ, अदिक अखमीरी रोट्टी इन फुट्टीगोळ इक हुडुकु ");
INSERT INTO hoy_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","भेंटमाळोद तम्बू उन द्वार मा तर, अदिक अल्या पुरा मंडली इक जमा माळ.” ");
INSERT INTO hoy_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","यहोवा अन्द ई आग्या अन्द अनुसार मूसा माळदुन; अदिक मंडली भेंटमाळोद तम्बू उन द्वार मा जमा आत. ");
INSERT INTO hoy_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","आग मूसा मंडली से अंदुन, “जो क्याल्सा माळोद आग्या यहोवा कोट्टुन अद ईद हुन.” ");
INSERT INTO hoy_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","बाक मूसा हारून अदिक आऊन पारगोळ इक हात्ती वोतकु नीर देल मय तोळसुसदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","आग आव हारून उक अंगरखा हाकसुसदुन, अदिक आऊन नेळु मा कमरबन्द कटकु झागा हाकसुस बुट्टुन, अदिक एपोद हचकु एपोद इन नक्षीदार सुंदर पट्टा देल एपोद इक कटकु कसुसबुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","बाक मूसा आऊन मा सीनाबन्द कटदुन अदिक अदुर्दा ऊरीम तुम्मीम ईट बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","आग आव आऊन ताल्ला मा पगळी कटकु पगळी इन मुंद व्हान्ना अन्द पट्टी अक, मतलब पवित्र मुकुट इक हचदुर, या प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","आग मूसा अभिषेक इन याण्णा हुळकु पवित्र निवास दा जो येनारा अदुर्दा ईरोद आ सप्पा चिजगोळ्द भी अभिषेक माळकु अवरी पवित्र माळदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","अदिक आ याण्णा दा टु थ्वाळासा याण्णा आव वेदी मा येळ घन सिपसदुन, अदिक सप्पा सामान सांगुळ वेदी इन अदिक पायवा सांगुळ गंगार इन अभिषेक माळकु अवरी पवित्र माळदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","अदिक आव अभिषेक इन याण्णा दा टु थ्वाळासा हारून उन ताल्ला मा हाक्कु आऊन अभिषेक माळकु आऊक पवित्र माळदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","बाक मूसा हारून उन पारगोळ उक हात्ती तनकु, अंगरखा हाकसुसकु, नेळु उन पट्टा कटकु आऊन ताल्ला मा टोपी ईटबुट्टुन, या प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","आग आव पापबली इन हारोद वस्ता अक आंदुर हात्ती वोतुन; अदिक हारून अदिक आऊन पारगोळ तान-तान कय पापबली इन वस्ता अन्द ताल्ला मा ईट्टुल. ");
INSERT INTO hoy_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","आग अद बली माळकु आत, अदिक मूसा अदुर्द रक्ता इक हुळकु बेळ्ल देल वेदी इन नाकु सींगगोळ मा हचकु पवित्र माळदुन, अदिक रकत इक वेदी इन पायवा मा पलटुस बुट्टुन, अदिक आऊन साटी प्रायश्चित माळकु अवरी शुद्ध माळदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","अदिक मूसा कल्लगोळ्द म्याकुच इन सप्पा न्याणद, अदिक ईरग्या अन्द म्याकुच इन परत, अदिक न्याणद सांगुळ येढ्ढु क्वातागोळ इक हुळकु वेदी मा होताकदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","लेकीन बली माळ्द वस्ता दा टु जो येनारा मिक्कु ईत्तीत अदरी, मतलब सेंगळी सांगुळ अदुर तोगुल अदिक चिच्ची इक आव छावनी टु व्हार्या बेक्की दा होताकदुन, या प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","बाक आव मेल-मिलाप इन म्यांडा अक हात्ती वोतुन, अदिक हारून अदिक आऊन पारगोळ इक तान-तान कय म्यांडा अन्द ताल्ला मा ईट्टुल. ");
INSERT INTO hoy_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","आग अद बली माळकु आत, अदिक मूसा अदुर्द रकत इक वेदी मा नाकु दी सिपसदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","आग म्यांडा तुकळा-तुकळा माळकु आत, अदिक मूसा ताल्ला अदिक न्याण सांगुळ तुकळागोळ इक होताकदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","आग कल्लगोळ अदिक काल नीर देल तोळुकु आदव, अदिक मूसा पूरा म्यांडा अक वेदी मा होताकदुन, अदिक अद सुखदायक सुगन्ध कोळोर साटी होमबली अदिक यहोवा अन्द साटी होमबली आगेत, या प्रकार देल यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","बाक आव दुसरा म्यांडा अक जो अभिषेक इन म्यांडा ईरोद हात्ती वोतुन, अदिक हारून अदिक आऊन पारगोळ तान-तान कय म्यांडा अन्द ताल्ला मा ईट्टुल. ");
INSERT INTO hoy_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","आग अद बली माळकु आत, अदिक मूसा अदुर रकत दा टु थ्वाळासा हुळकु हारून इन ऊजवा किव इन स्यांडा मा अदिक अदुर ऊजवा कय अदिक ऊजवा काल इन बेळ्लगोळ मा हचदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","अदिक आव हारून उन पारगोळ इक हात्ती वोतुन, अदिक रकत दा टु थ्वाळासा ऊंद-ऊंद पार उन ऊजवा कीव इन स्यांडा मा अदिक ऊजवा कय अदिक ऊजवा काल इन बेळ्लगोळ मा हचदुन; अदिक मूसा रकत इक वेदी मा नाकु दी सिपसदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","अदिक आव न्याणद पुसटी, अदिक कल्लगोळ म्याकळोद सप्पा न्याणद, अदिक ईरग्या माकळोद परत सांगुळ येढ्ढु क्वातागोळ, अदिक ऊजवा जाँघ, ईव सप्पा हुळकु अलग ईट्टुल; ");
INSERT INTO hoy_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","अदिक अखमीरी रोट्टी इन फुट्टी जो यहोवा अन्द मुंद ईटकु आगीत अदुर दा टु ऊंद अखमीरी रोट्टी, अदिक याण्णा हतकु मैदा अन्द ऊंद रोट्टी, अदिक ऊंद पापळ हुळकु न्याणद अदिक ऊजवा जाँघ मा ईट बुट्टुन; ");
INSERT INTO hoy_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","अदिक ईव सप्पा चीजगोळ हारून अदिक आऊन पारगोळ कयगोळ मा ईटकु आत, अदिक हालुसोद भेंट इन साटी यहोवा अन्द मुंद हालुस्कु आत. ");
INSERT INTO hoy_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","आग मूसा आंदरी मात्त आंदुर कयगोळ दा टु हुळकु आंदरी वेदी मा होमबली इन म्याकुच होताकदुन, ईद सुखदायक सुगन्ध कोळोर साटी बलिदान इन भेंट अदिक यहोवा अन्द साटी संतोष हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","आग मूसा याद्दा अक हुळकु हालुसोद भेंट इन साटी यहोवा अन्द मुंद आळगाळस्दुन; अदिक अभिषेक इन म्यांडा दा टु मूसा अन्द भाग ईदा ठहरूस्त ह्यांग यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","आग मूसा अभिषेक इन याण्णा अदिक वेदी माकळोद रकत, येढ्ढु दा टु थ्वाळासा हुळकु हारून अदिक आऊन कपळागोळ मा, अदिक आऊन पारगोळ अदिक आंदुर कपळागोळ मा भी सिपसदुन; अदिक आव कपळागोळ सांगुळ हारून उक भी पवित्र माळदुन. ");
INSERT INTO hoy_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","आग मूसा हारून अदिक आऊन पारगोळ से अंदुन, “चिच्ची इक भेंटमाळोद तम्बू उन दरवाजा मा कासी, अदिक आ रोट्टी इक जो अभिषेक इन फुट्टी दा आव अवा तिनी, ह्यांग ना आग्या कोट्टीन कि हारून अदिक आऊन पारगोळ अच अदरी तिनुल. ");
INSERT INTO hoy_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","अदिक चिच्ची अदिक रोट्टी दा टु जो मिक्कु ईतोगुल अदरी बेक्की दा होताक बुळेत. ");
INSERT INTO hoy_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","अदिक यागासताका नीम्द अभिषेक इन दिन पुरा आगालव आगासताका, मतलब येळ दिन ताका भेंटमाळोद तम्बू उन दरवाजा अन्द व्हार्या होगबाळेतीर, यतिकी आव येळ दिन ताका नीम्द अभिषेक माळतेला ईत्तान. ");
INSERT INTO hoy_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","या प्रकार ईंद माळकु आग्याद हांग अच माळोद आग्या यहोवा नानी कोटान, ईदुर देल नीम्द पाप ढाँपस्कु आदव. ");
INSERT INTO hoy_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","इदुरसाटी नीव भेंटमाळोद तम्बू उन द्वार मा येळ दिन ताका ईळ्लक-हागुल ठहरूसकु ईरेतीर, ईद यहोवा अन्द आग्या अक नीव ईला मानसेतीर रा नीव सोत्तीर; कारण परमेश्वर नानी हिंग अच आग्या कोटान.” ");
INSERT INTO hoy_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","आग यहोवा अन्द ईवा सप्पा निर्देशगोळ्द आग्यागोळ अनुसार जो आव मूसा अन द्वारा कोटीदुन हारून अदिक आऊन पारगोळ माळदुर. ");
INSERT INTO hoy_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठवा दिशी मूसा हारून अदिक आऊन पारगोळ इक अदिक इस्राएली पुरनिएगोळ इक कार्सुसकु हारून से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","बाक हारून अंदुन, “पापबली इन साटी ऊंद तंदरूस्त म्यांडा अन्द पाड्डा, अदिक होमबली इन साटी ऊंद तंदरूस्त म्यांडा हुळकु यहोवा अन्द मुंद भेंट येर्स.” ");
INSERT INTO hoy_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","अदिक इस्राएलीगोळ देल ईद अन, “नीव पापबली इन साटी ऊंद व्हात, अदिक होमबली इन साटी ऊंद पाड्डा अदिक ऊंद म्यांडा अन्द पाड्डा हुडी, जो ऊंद वर्ष इन ईरूल अदिक तंदरूस्त ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","अदिक मेलबली इन साटी यहोवा अन्द मुंद येरसोर साटी ऊंद वस्ता अदिक म्यांडा, अदिक याण्णा हचकु मैदा अन्द ऊंद अन्नभेट भी तंदकोमी; यतिकी ईंद यहोवा नीमी इक दर्शन कोट्टान.” ");
INSERT INTO hoy_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","अदिक या-या चीज इक आग्या मूसा कोट्टुन आ सप्पा चीज इक आंदुर भेंटमाळोद तम्बू उन मुंद तरूल; अदिक पुरा मंडली हात्ती होगकु यहोवा अन्द मुंद निदरूत. ");
INSERT INTO hoy_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","आग मूसा अंदुन, “ईद अद क्याल्सा हुन यदरी माळोर साटी यहोवा आग्या कोटीदुन कि नीव अदरी माळी; अदिक यहोवा अन्द महिमा नीम इक कांळ्सीत.” ");
INSERT INTO hoy_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","आग मूसा हारून से अंदुन, “यहोवा अन्द आग्या अन्द अनुसार वेदी इन हात्ती होगकु तान पापबली अदिक होमबली इक येर्सकु तान अदिक सप्पा जनता अन्द साटी प्रायश्चित माळ अदिक जनता अन्द चढ़ावा अक भी येर्सकु आंदुर साटी प्रायश्चित माळ.” ");
INSERT INTO hoy_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","इदुरसाटी हारून वेदी इन हात्ती होगकु तान पापबली इन पाड्डा अक बलिदान माळदुन. ");
INSERT INTO hoy_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","अदिक हारून उन पार रकत इक आऊन हात्ती ओतुर, आग आव तान बेळ्ल इक रकत दा नेनाक्कु वेदी इन सींगगोळ मा हचदुन, अदिक मिक्कु रकत इक वेदी इन पायवा मा पलटुस बुट्टुन; ");
INSERT INTO hoy_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","अदिक पापबली दाकळोद न्याणद अदिक क्वातागोळ अदिक ईरग्या माकळोद परत इक आव वेदी मा होताकदुन, ह्यांग यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","अदिक मास अदिक तोगुल इक आव छावनी टु व्हार्या बेक्की दा होताकदुन. ");
INSERT INTO hoy_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","आग होमबली पशु उक बलिदान माळदुन; अदिक हारून उन पारगोळ रकत इक आऊन कय दा कोट्टुर, अदिक आव अदरी वेदी मा नाकु दी सिप्स बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","आग आंदुर होमबली पशु उक तुकळा-तुकळा माळकु ताल्ला सांगुळ आऊन कय दा कोट बुट्टुर अदिक आव अवरी वेदी मा होताक बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","अदिक आव कल्लगोळी अदिक कालगोळी इक तोळुकु वेदी मा होमबली इन म्याकुच होताकदुन. ");
INSERT INTO hoy_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","आग आव लॉकुर्द चढ़ावा अक मुंद ओतकु अदिक आ पापबली इन व्हात इक जो आंदुर साटी ईरोद हुळकु अदुर बलिदान माळदुर, अदिक पयला अन्द घाई अदरी भी बलिदान माळकु येर्सदुर. ");
INSERT INTO hoy_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","अदिक आव होमबली इक भी हात्ती ओतकु विधी इन अनुसार येर्सदुन. ");
INSERT INTO hoy_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","अदिक अन्नभेट इक भी हात्ती ओतकु अदुर दा टु ठ्वामा तीम हुडुकु वेदी मा होताकदुन, ईद व्हातुर इन होमबली इन अलावा येर्सकु आत. ");
INSERT INTO hoy_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","वस्ता अदिक म्यांडा, मतलब जो मेल-मिलाप बली पशु, जनता अन्द साटी ईरोद अव भी बली माळकु आदव; अदिक हारून उन पारगोळ रकत इक आऊन कय दा कोट्टुर, अदिक आव अदरी वेदी मा नाकु दी सिप्स बुट्टुन; ");
INSERT INTO hoy_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","अदिक आंदुर वस्ता अन्द न्याण इक, अदिक म्यांडा दा टु न्याणद पुसटी इक, अदिक या न्याणद देल कल्लगोळ होचकु ईरताव अदरी, अदिक क्वाता सांगुळ ईरग्या माकळोद परत इक भी आऊन कय दा कोट्टुर; ");
INSERT INTO hoy_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","अदिक आंदुर न्याण इक याद्दागोळ मा ईटदुर; अदिक आव अद ण्याण वेदी मा होताकदुन, ");
INSERT INTO hoy_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","लेकीन याद्दागोळ अदिक ऊजवा जाँघ इक हारून मूसा अन आग्या अन्द अनुसार हालुसोद भेंट इन साटी यहोवा अन्द मुंद आळगाळस्दुन. ");
INSERT INTO hoy_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","आग हारून लॉकुर दी कय वाळुस्कु आंदरी आशीर्वाद कोट्टुन; अदिक पापबली, होमबली, अदिक मेल-मिलाप इन बली इक येर्सकु आव ल्‍यालमा ईळुतेला बंदुन. ");
INSERT INTO hoy_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","आग मूसा अदिक हारून भेंटमाळोद तम्बू दा होदुर, अदिक अल टु होटकु लॉकुरी आशीर्वाद कोट्टुर; आग यहोवा अन्द महिमा सप्पा लॉकुरी कांळ्सत. ");
INSERT INTO hoy_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","अदिक यहोवा अन्द मुंद टु बेक्की होळ्त न्याण सांगुळ होमबली इक वेदी मा भस्म माळदुन; इदरी नोळकु लॉकुर जय-जयकार इन नारा हचदुर, अदिक तान-तान बाय इन भार देल बांगकु प्रणाम माळदुर. ");
INSERT INTO hoy_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","आग हारून उन नादाब अदिक अबीहू हेसुर ईनव येढ्ढ पारगोळ तान-तान धूपदान हुळदुर, अदिक अदुर दा बेक्की तुमदुर, अदिक अदुर दा लुबान हाक्कु आ अनुचित बेक्की इक यदुर आग्या यहोवा कोटिदील यहोवा अन्द मुंद अर्पित माळदुर. ");
INSERT INTO hoy_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","आग यहोवा अन्द मुंद टु बेक्की होळ्‍त अदिक आ येढ्ढु मुंदरी भस्म माळ बुट्टुन, अदिक आंदुर यहोवा अन्द मुंद सोतोदुर. ");
INSERT INTO hoy_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","आग मूसा हारून से अंदुन, “ ईद अदा मात हुंद यदरी यहोवा अंदीदुन, कि जो नांद हात्ती बंदान जरूरी आद कि आव नानी पवित्र जानसुल, अदिक पुरा जनता अन्द मुंद नांद महिमा माळुल.” अदिक हारून सुंगा ईत्तुन. ");
INSERT INTO hoy_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","आग मूसा मीशाएल अदिक एलसाफान उक जो हारून इन काका उज्जीएल उन पार ईरोन कारूकु अंदुन, “हात्ती बरी, अदिक तान मुतणागोळ इक पवित्र जागा अन्द मुंद टु नेगुकु छावनी इन व्हार्या वोई.” ");
INSERT INTO hoy_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","मूसा अन्द आग्या अन्द अनुसार आंदुर हात्ती होगकु आंदरी अंगरखा सांगुळ नेगुकु छावनी इन व्हार्या ओतुर. ");
INSERT INTO hoy_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","आग मूसा हारून से अदिक आऊन पार एलीआजर अदिक ईतामार से अंदुन, “ नीव लॉकुर तान ताल्लागोळ चुट्टी बगरूसबाळी, अदिक न तान कपळागोळी हरूबाळी, हिंग आगबाळुल कि नीव भी सोतोदीर, अदिक पुरा मंडली मा आऊन गुस्सा भळकुसुल; लेकीन इस्राएल इन सप्पा घराना अन्द लॉकुर जो नीम्द वार्टबन्धु आर नादाब अदिक अबीहू यहोवा अन्द हचकु बेक्की मा होत्तुर शोक माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","अदिक नीव लॉकुर भेंटमाळोद तम्बू उन दरवाजा अन्द व्हार्या होगबाळेतीर, हिंग आगबाळुल कि नीव सोतोदीर; यतिकी यहोवा अन्द अभिषेक इन याण्णा नीम मा हतकु आद.” मूसा अन्द ई वचन इन अनुसार आंदुर हिंग माळदुर. ");
INSERT INTO hoy_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","बाक यहोवा हारून से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“याग-याग नी या नीन पार भेंटमाळोद तम्बू दा बंदीर आग-आग नीम दा टु यावारा भी अंगुर इन रास्सा अदिक सारा कुडुकु ईरबाळुल अदिक न यातोदु प्रकार इन सार्रा, ईलारा हिंग आगबाळुल कि नीव सोतोदीर; नीम्द पीढ़ी-पीढ़ी दा ईद विधी नळुतेला ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ईदुर देल नीव पवित्र अदिक अपवित्र दा, अदिक शुद्ध अदिक अशुद्ध दा अंतर माळ सकी; ");
INSERT INTO hoy_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","अदिक इस्राएलीगोळ इक आ सप्पा विधीगोळ इक कल्स सकुल यदरी यहोवा मूसा अन्द द्वारा आंदरी हेळ बुट्टान.” ");
INSERT INTO hoy_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","बाक मूसा हारून से अदिक आऊन मिक्कु येढ्ढु पार एलीआजर अदिक ईतामार से भी अंदुन, “यहोवा अन्द चढ़ावा दा टु जो अन्नभेट मिक्कु आद अदरी हुळकु होमबली इन हात्ती बिना खमीर हचकु तिनी, यतिकी आव हापाळ वळ्लीद आद; ");
INSERT INTO hoy_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","अदिक नीव अदरी यातोदारा पवित्र जागा दा तिनी, अद यहोवा अन्द होमबली दा टु नींद अदिक नीन पारगोळ्द हक आद; यतिकी नानी हिंग अच आग्या सिक्याद. ");
INSERT INTO hoy_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","आग हालुस्कु भेंट इन याद्दा अदिक नेग्द भेंट इन जाँघ इक नीव लॉकुर, मतलब नी अदिक नीन पोर-पारगोळ सप्पा यातोदारा शुद्ध जागा दा तिनी; यतिकी आ इस्राएलीगोळ्द मेल-मिलाप इन बली दा टु नीनी अदिक नीन चिकोरगोळ्द हक ठहरूस्कु आगेग्याद. ");
INSERT INTO hoy_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","न्याण इन होमबली गोळ सांगुळ जो नेग्द जाँघ अदिक हालुस्कु याद्दा यहोवा अन्द मुंद हालुसोर साटी बंदीत, ईद भाग यहोवा अन्द आग्या अन्द अनुसार हमेशा अन्द विधी इन व्यवस्था देल नींद अदिक नीन चिकोरगोळ साटी हुंद.” ");
INSERT INTO hoy_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","बाक मूसा पापबली इन व्हात इन खोजबीन माळदुन, रा येन मालुम आत कि अद होत्‍ताकु आग्याद, इदुरसाटी एलीआजर अदिक ईतामार जो हारून उन पार मिक्कु ईरोर आंदुर से आव गुस्सा दा बंदकु अनली कुरतुन, ");
INSERT INTO hoy_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“पापबली जो परम पवित्र आद अदिक अदरी यहोवा नीमी इदुरसाटी कोटीदुन कि नीव मंडली इन अधर्म इन भार ताम मा नेगुकु आंदुर साटी यहोवा अन्द मुंद प्रायश्चित माळी, नीव आऊन मास पवित्र जागा दा येती तिंदीदील? ");
INSERT INTO hoy_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","नोळी, आऊन रकत पवित्र जागा अन्द बुळ्क रा तंदकु उच आगीदिल, बिना सक देल उचित ईरोद कि नीव नांद आग्या अन्द अनुसार आऊन चिच्ची इक पवित्र जागा दा तिनायदीर.” ");
INSERT INTO hoy_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","इदुर उत्तर हारून मूसा अक ई प्रकार देल कोट्टुन, “नोळ, ईंद अच आंदुर तान पापबली अदिक होमबली इक यहोवा अन्द मुंद येर्सदुर; बाक नान मा हिंग मुसिबतगोळ होट बंदाव! इदुरसाटी अगर ना ईंद पापबली इन चिच्ची तिनायदीन रा येन ईद मात यहोवा अन्द मुंद भला ईराइत?” ");
INSERT INTO hoy_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","याग मूसा ईद केळदुन आग आऊक वळ्लीद हत्त. ");
INSERT INTO hoy_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","बाक यहोवा मूसा से अदिक हारून से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएलीगोळ से अन: यास पशु धरती मा आव आ सप्पा दा टु नीव ई जीवधारीगोळ्द मास तिन सकतीर. ");
INSERT INTO hoy_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","पशु गोळ दा टु यास चिरूसकु या हर्दकु खुर इन ईरताव अदिक कवरी माळताव अवरी तिन सकतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","लेकीन कवरी माळावाळा या हर्दकु खुरवाळा दा टु ई पशुगोळी तिनबाळेतीर, मतलब ऊँट, जो कवरी रा माळतद लेकीन चिरा खुर इन ईराल, ईदुरसाटी अद नीम्द साटी अशुद्ध ठहरूस्कु आग्याद. ");
INSERT INTO hoy_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","अदिक चट्टानी बिज्जू, जो कवरी रा माळतद लेकीन चिरा खुर इन ईराल, अद भी नीम्द साटी अशुद्ध आद. ");
INSERT INTO hoy_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","अदिक खरगोश, जो कवरी रा माळतद लेकीन चिरा खुर इन ईराल, ईदुरसाटी अद भी नीम्द साटी अशुद्ध आद. ");
INSERT INTO hoy_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","अदिक हंदी, जो चिरा मतलब हर्दकु खुर इन रा ईरतद लेकीन कवरी माळाल, इदुरसाटी अद नीम्द साटी अशुद्ध आद. ");
INSERT INTO hoy_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ईऊर मास दा टु येनारा भी तिनबाळेतीर, अदिक ईऊरव मुर्दा अक मूठ भी बाळेतीर; ईव रा नीम्द साटी अशुद्ध आव. ");
INSERT INTO hoy_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“बाक यास नीर ईनव जन्तु आव ईऊर दा टु नीव इंदरी तिन सकतीर, मतलब समुद्र या गांगागोळ नीर इन जन्तुगोळ दा टु यासरव पिक्का अदिक छिलका ईरताव आंदरी तिन सकतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","अदिक नीर दा ईरावाळेर प्राणीगोळ दा टु यास जीवधारी बिना पिक्का अदिक खवला अन्द समुद्र या गांगागोळ दा ईरताव अव सप्पा नीम्द साटी घृणित आव. ");
INSERT INTO hoy_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","अव नीम्द साटी घृणित ठहरूस्याव; नीव अऊर दा टु येनारा भी तिन बाळेतीर, अदिक अऊर मुर्दागोळी इक अशुद्ध जान्सेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","नीर दा या जन्तु उन पिक्का अदिक छिलकागोळ ईरालव अव नीम्द साटी अशुद्ध आव. ");
INSERT INTO hoy_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“बाक पक्षिगोळ दा टु ईवरी अशुद्ध जान्सेतीर, ईव अशुद्ध आगोद कारण देल तिनकु आगबाळुल, मतलब गरूळ, दाळीवाळा गिधाळ, करीद गिधाळ, ");
INSERT INTO hoy_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","चील, अदिक अलग-अलग जाती नव घार, ");
INSERT INTO hoy_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","अदिक अलग-अलग जाती नव काग्गगोळ, ");
INSERT INTO hoy_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","शुतुरमुर्ग, ईळ्लक इन सिकरा, पानकोंबळी, अदिक अलग-अलग जाती नव पानकोंबळी, ");
INSERT INTO hoy_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","स्यांळ्द पिंजोळ्ला, बगला, धोळ्द पिंजोळ्ला, ");
INSERT INTO hoy_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","बगला, धोळ उल्लू, राजहँस, पानकोंबळी, गिधाळ, ");
INSERT INTO hoy_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","सारस, अलग-अलग जाती नव बगलागोळ, टिटवी अदिक चमगादळ.” ");
INSERT INTO hoy_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","यास पिक्कावाळेर कीळागोळ नाक कालगोळ बल मा नळुताव अव सप्पा नीम्द साटी अशुद्ध आव. ");
INSERT INTO hoy_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","लेकीन रेंगसावाळेर अदिक पिक्कावाळेर जो नाक नाक कालगोळ बल मा नळुताव, अऊरव भूमी मा हारली वोळली टांगगोळ ईरताव आंदरी रा तिन सकतीर. ");
INSERT INTO hoy_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","अव ईव हुव, मतलब अलग-अलग जाती नव हत्तीफाफागोळ, फनगे अदिक झींगुर. ");
INSERT INTO hoy_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","लेकीन अदिक सप्पा रेंगसावाळेर पिक्कावाळेर जो नाक काल वाळेर ईरताव अव नीम्द साटी अशुद्ध आव. ");
INSERT INTO hoy_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ईऊर कारण नीव अशुद्ध ठहरूसीर; यावारा ईऊर लोथ मुठबुळुल आव द्यावगा ताका अशुद्ध ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","अदिक जो ईऊर लोथ दा टु येनारा भी नेगुल आव तान कपळा वोगुल अदिक द्यावगा ताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","बाक यास पशु चिरा खुर इन ईरताव लेकीन न रा बिलकुल हर्दकु खुर इन अदिक न कवरी माळावाळा आव अव नीम साटी अशुद्ध आव; जो यावारा अवरी मुट्‍यान आव अशुद्ध ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","अदिक नाक काल इन बल आळावाळेर दा टु यास पंजागोळ बल मा नळुताव अव सप्पा नीम साटी अशुद्ध आव; जो यावारा आंदुर लोथ मुट्‍यान आव द्यावगा ताका अशुद्ध ईत्तान. ");
INSERT INTO hoy_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","अदिक जो यावारा अऊर लोथ नेगदान आव तान कपळा तोळुल अदिक द्यावगा ताका अशुद्ध ईरूल; यतिकी अव नीम्द साटी अशुद्ध आव. ");
INSERT INTO hoy_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“अदिक जो धरती मा रांगस्ताव अऊर दा टु ईव रेंगसावाळेर नीम्द साटी अशुद्ध आव, मतलब घोरपळ, ईळ्ल, अदिक अलग-अलग जाती नव डोकेला, ");
INSERT INTO hoy_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","अदिक ईजगुर, मगर, सापसिरोली, सांडा, डोकेला. ");
INSERT INTO hoy_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","सप्पा रेंगसावाळेर दा टु ईव अच नीम्द साटी अशुद्ध आव; जो यावारा ईऊर लोथ मुट्‍यान आव द्यावगा ताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","अदिक ईऊर दा टु अऊर लोथ यातोदारा वस्तु मा बिदोगुल अद भी अशुद्ध ठहरूसीत, चाहे अद हुळ्ली इन यातोदारा बरतन ईरूल, चाहे कपळा, चाहे तोगुल, चाहे बॉरा, चाहे यातोदारा क्याल्सा अन्द यातोदारा भी बरतन यती आगबाळुल; अव नीर दा हाक्कु आदीत, अदिक द्यावगा ताका अशुद्ध ईरूल, आग शुद्ध सम्सकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","अदिक अगर मुण्ण इन यातोदारा बरतन ईरूल ईदुर दा ईव जन्तुगोळ दा टु यावारा बिळुल, रा अद बरतन दा जो येनारा ईरूल अद अशुद्ध ठहरूसुल, अदिक बरतन इक नीव ओळ्द बुळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","अदुर दा तिना लायक भोजन ईरूल, अदुर दा नीर इन छुआव ईरूल अद सप्पा अशुद्ध ठहरूसुल; बाक अगर यातोदारा हिंग बरतन दा कुडोर साटी येनारा ईरूल रा अद भी अशुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","अदिक अगर लोथ दा टु येनारा तंदुर या चुली मा बिळुल रा अद भी अशुद्ध ठहरूसुल, अदिक मुरकु आगुल; यतिकी अद अशुद्ध आगेदीत, अद निम्द साटी भी अशुद्ध ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","लेकीन झरना या क्यार्रा यदुर दा नीर जमा ईरूल अद रा शुद्ध अच ईरूल; लेकीन जो ईऊर लोथ इक मुठ्ठुल आव अशुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","अदिक अगर ईऊर लोथ दा टु येनारा भी यातोदारा प्रकार इन बींजा मा जो बोऊसा साटी ईरूल, रा अद बींजा शुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","पर अगर बींजा मा नीर हाक्कु आगीदाद अदिक हिंद लोथ दा टु येनारा अदुर मा बिदोगुल, रा अद नीम्द साटी अशुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“बाक या पशुगोळ इक तिनोद आग्या नीम इक कोटकु आग्याद अगर अदुर दा टु यातोदारा पशु सोतोगुल, रा जो यावारा अदुर लोथ इक मुठ्ठुल आव द्यावगा ताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","अदिक अऊर लोथ दा टु जो यावारा येनारा तिनुल आव तान कपळा तोळुल अदिक द्यावगा ताका अशुद्ध ईरूल; अदिक जो यावारा अऊर लोथ नेगुल आव भी तान कपळा तोळुल अदिक द्यावगा ताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“सप्पा प्रकार इन धरती मा रेंगसावाळेर जन्तु घिनौना आव; अव तिनकु आग बाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","धरती मा रेंगसावाळेर दा टु यास व्हाट्टा या नाक कालगोळ मा ईरताव, अवरी नीव तिनबाळेतीर; यतिकी अव घिनौना आव. ");
INSERT INTO hoy_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","नीव यातोदारा प्रकार इन रेंगसावाळेर जन्तु उन द्वारा तान तान इक घिनौना माळबाळेतीर; अदिक न अऊर द्वारा तान इक अशुद्ध माळकु अपवित्र ठहरूसेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","यतिकी ना नीम्द परमेश्वर यहोवा हुईन; ई कारण खुद इक शुद्ध माळकु पवित्र बन्सकु ईरी, यतिकी ना पवित्र आईन. इदुरसाटी नीव यातोदारा भी प्रकार इन रेंगसावाळेर जन्तु उन द्वारा जो धरती मा नळुताव तान तान इक अशुद्ध माळबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","यतिकी ना आ यहोवा हुईन जो नीमी मिस्त्र द्याश टु इदुरसाटी तेगुकु तंदीन कि नीम्द परमेश्वर ठहरूसाईन; इदुरसाटी नीव पवित्र बन्सी, यतिकी ना पवित्र आईन.” ");
INSERT INTO hoy_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","पशु गोळ, पक्षिगोळ, अदिक सप्पा नीर दा ईरावाळेर प्राणीगोळ, अदिक धरती मा सप्पा रेंगसावाळेर प्राणीगोळ्द बारा दा ईदा व्यवस्था आद, ");
INSERT INTO hoy_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","कि शुद्ध अशुद्ध अदिक तिनालायक या बिन तिनालायक जीवधारीगोळ दा भेद माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएलीगोळ से अन: जो आर्त व्हाट्या दी ईरूल अदिक आकीन पारगोळ ईरूल, रा आक येळ दिन ताका अशुद्ध ईत्तार; या प्रकार देल आक व्हार्या आगकु ईरतार हांग अच अशुद्ध ईर पायजे.” ");
INSERT INTO hoy_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","अदिक आठवा दिशी चिग्द उन खतना माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","बाक आक आर्त तान खुन होगोद स्त्राव दा टु शुद्ध आगोर साटी तेत्तीस दिन ईरूल; अदिक यागासताका आकीन शुद्ध आगोद दिन पुरा न आगुल आगासताका आक न रा यातोदारा पवित्र जागा दा प्रवेश माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","अदिक अगर आकी पोर आत, रा मासीक पाळी इन होती ह्यांग आक ईरतोगोर हांग अच आक चौदा दिन अशुद्ध ईरूल; आकी तान रकत स्त्राव दा टु शुद्ध आगोर साटी छैसठ दिन हत्याव. ");
INSERT INTO hoy_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“याग आकीन शुद्ध आगोद दिन पुरा आगुल, आग चाहे आकी पार आगुल या बाक पोर, आक होमबली इन साटी ऊंद वर्ष इन म्यांडा अन्द पाड्डा, अदिक पापबली इन साटी कबूतर इन ऊंद पाड्डा या पंडुकी, भेंटमाळोद तम्बू उन दरवाजा मा याजक उन हात्ती तरूल.” ");
INSERT INTO hoy_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","आग याजक अवरी यहोवा अन्द मुंद भेंट येर्सकु आकीन साटी प्रायश्चित माळुल; अदिक आक तान मासीक पाळी इन अशुद्धता बिटकु शुद्ध ठहरूस्यार. “याता आर्त इक पार या पोर पैदा आगुल आंदुर साटी ईदा व्यवस्था आद.” ");
INSERT INTO hoy_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","अदिक अगर आव म्यांडा कोळदुर दा असमर्थ ईरूल, रा येढ्ढ पंडुकी या कबूतर इन येढ्ढ पाड्डा, ऊंद रा होमबली अदिक दुसरा पापबली इन साटी कोळुल; अदिक याजक आकीन साटी प्रायश्चित माळुल, आग आक शुद्ध ठहरूस्यार. ");
INSERT INTO hoy_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","बाक यहोवा मूसा अदिक हारून से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“याग यावारा मंळसा अन्द मय इन तोगुल दा सुजन या चट्टा या दाग ईरूल, अदिक इदुर देल आऊन तोगुल दा कोळ इन व्याधि इन घाई येनारा कांळ्सकु बिळुल रा आऊक हारून याजक उन हात्ती या आऊन पार जो याजक आन, आंदुर दा टु यारीकारा हात्ती ओईल. ");
INSERT INTO hoy_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","याग याजक आऊन तोगुल इन चट्टा अक नोळुल, अदिक अगर आ चट्टा अन जागा अन्द चुट्टीगोळ बिळेव आगेग्याव अदिक चट्टा तोगुल देल गहरा कांळ्सकु बिळुल, रा आव जान्स कोमुल कि कोढ़ इन चट्टा हुव; अदिक याजक आ मंळसा अक नोळकु आऊक अशुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","पर अगर अद चट्टा आऊन तोगुल दा बिळीद ईरूल, लेकीन तोगुल देल गयरा कांळ्सबाळुल, अदिक अलेव चुट्टी बिळेव हैलेच, रा याजक आऊक येळ दिन ताका अलग माळकु ईटुल; ");
INSERT INTO hoy_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","अदिक सातवा दिशी याजक आऊक नोळुल, अदिक अगर अद चट्टा ह्यांग चा हांग अच कांळ्सुल अदिक आऊन तोगुल दा फैलुसकु ईरबाळुल, रा याजक आऊक मात्त येळ दिन ताका अलग माळकु ईटुल; ");
INSERT INTO hoy_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","अदिक सातवा दिशी याजक आऊक मात नोळुल, अदिक अगर नोळुल कि चट्टा अन चमक कम आद अदिक चट्टा तोगुल मा फैलुसकु हैलेच, रा याजक आऊक शुद्ध ठहरूसुल; यतिकी आऊन रा तोगुल दा सिर्फ चट्टा आद; अदिक आव तान कपळा तोळुकु शुद्ध आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","पर अगर याजक उन आ जाच इन बाद्दा यदुर दा आव शुद्ध ठहरूसकु आगीदुन, अद चट्टा आऊन तोगुल मा हापाळ फैलुसेग्याद, रा आव बाक याजक उक तोर्सकु आगुल; ");
INSERT INTO hoy_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","अदिक अगर याजक उक कांळ्सुल कि चट्टा तोगुल दा फैलुसेग्याद, रा आव आऊक अशुद्ध ठहरूसुल; यतिकी अद कोढ़ अच हुन. ");
INSERT INTO hoy_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“अगर कोढ़ इन घाई चट्टा यातोदारा मंळसा अक ईरूल, रा आऊक याजक उन हात्ती पोहचुस्कु आगुल; ");
INSERT INTO hoy_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","अदिक याजक आऊक नोळुल, अदिक अगर अद सुजन आऊन तोगुल दा बिळीद आगुल, अदिक अदुर कारण चुट्टी भी बिळेव कांळ्सुल, अदिक आ सुजन दा बिना तोगुल इन मास ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","रा याजक जानसुल कि आऊन तोगुल दा हाळोद कोढ़ आद, इदुरसाटी आव आऊक अशुद्ध ठहरूसुल; अदिक बंद ईटबाळुल, यतिकी आव रा अशुद्ध आन. ");
INSERT INTO hoy_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","अदिक अगर कोढ़ यावारा मंळसा अन्द तोगुल दा ईल ताका फैलुसेगुल, कि येल्यारा भी याजक नोळुल रोगी इन ताल्ला टु तरकाल ताका कोढ़ पुरा तोगुल इक जकळुस कोंडाद, ");
INSERT INTO hoy_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","रा याजक ध्यान देल नोळुल, अदिक अगर कोढ़ आऊन पुरा मय इक जकळुस कोंडाद, रा आव आ मंळसा अक शुद्ध ठहरूसुल; अदिक आऊन मय जो बिलकुल बिळीद आगेग्याद आव शुद्ध अच ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","पर याग आऊन दा बिना तोगुल इन मास कांळ्सकु बिळुल, आग रा आव अशुद्ध ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","अदिक याजक बिना तोगुल इन मास इक नोळकु आऊक अशुद्ध ठहरूसुल; यतिकी हांगा बिना तोगुल इन मास अशुद्ध अच ईरतद; अद कोढ़ हुन. ");
INSERT INTO hoy_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","पर अगर अद बिना तोगुल इन मास बाक बिळीद आगेदीत, रा आव मंळसा याजक उन हात्ती होटोगुल, ");
INSERT INTO hoy_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","अदिक याजक आऊक नोळुल, अदिक अगर अद चट्टा दुबारा मात्त बिळीद आगेत्याद, रा याजक रोगी इक शुद्ध जान्सुल; आव शुद्ध आन. ");
INSERT INTO hoy_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“बाक अगर यावारा मंळसा अन्द तोगुल दा फ्वाळा आगकु चंगा आगेग्यान, ");
INSERT INTO hoy_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","अदिक फ्वाळा अन्द जागा दा बिळीद सुजन या क्याचांद घाई बिळीद दाग ईरूल, रा अद याजक उक तोर्सकु आगुल; ");
INSERT INTO hoy_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","अदिक याजक आ सुजन इक नोळुल, अदिक अगर अद तोगुल देल गयरा कांळ्सकु बिळुल, अदिक अदुर चुट्टी भी बिळेव आगीदाव, रा याजक ईद जान्सकु आ मंळसा अक अशुद्ध ठहरूसुल; यतिकी अद कोढ़ इन चट्टा हुन जो फ्वाळा दा टु वडुकु होटाद. ");
INSERT INTO hoy_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","लेकीन अगर याजक नोळुल कि अदुर्दा बिळीद चुट्टी हैलेच, अदिक अद तोगुल देल गयरा हैलेच, अदिक अदुर्द चमक कम आगेग्याद, रा याजक आ मंळसा अक येळ दिन ताका बंद माळकु ईटुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","अदिक अगर अद चट्टा आ समय ताका तोगुल दा खराखुरा फैलुसेगुल, रा याजक आ मंळसा अक अशुद्ध ठहरूसुल; यतिकी अद कोढ़ इन चट्टा हुन. ");
INSERT INTO hoy_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","लेकीन अगर अव दाग फैलुसालव अदिक तान जागा मा का बन्सकु ईरताव, रा अद फ्वाळा अन्द दाग हुन; याजक आ मंळसा अक शुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“बाक अगर यावारा मंळसा अन्द तोगुल दा होत्‍तोद घाव ईरूल, अदिक आ होतकु घाव दा बिना तोगुल इन दाग क्याचांद आगतेला बिळीद या बिळीद अच आगेगुल, ");
INSERT INTO hoy_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","रा याजक आऊक नोळुल, अदिक अगर आ दाग दाकळव चुट्टी बिळेव आगेग्याव अदिक अद तोगुल से गयरा कांळ्सकु बिळुल, रा अद कोढ़ हुन; जो आ होतकु दाग दा टु वडुकु होटाद; याजक आ मंळसा अक अशुद्ध ठहरूसुल; यतिकी आऊन दा कोढ़ इन चट्टा आद. ");
INSERT INTO hoy_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","पर अगर याजक नोळुल, कि दाग दा बिळीद चुट्टी हैलेच अदिक न अद तोगुल से येनु गयरा हैलेच, अदिक अदुर्द चमक कम आगेग्याद, रा याजक आऊक येळ दिन ताका अलग माळकु ईटुल, ");
INSERT INTO hoy_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","अदिक सातवा दिशी याजक आऊक नोळुल, अदिक अगर अद तोगुल दा फैलुसेग्याद, रा आव आ मंळसा अक अशुद्ध ठहरूसुल; यतिकी आऊक कोळ इन चट्टा आद. ");
INSERT INTO hoy_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","लेकीन अगर अद दाग तोगुल दा ईला फैलुसीदाद अदिक तान जागा मा यल इन अल बन्सकु ईरूल, अदिक अदुर्द चमक कम आगेग्याद, रा अद होतदुर कारण बातकु आद, याजक आ मंळसा अक शुद्ध ठहरूसुल; यतिकी अद दाग होतदुर कारण देल आद. ");
INSERT INTO hoy_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“बाक अगर यावारा गंळ्स या आर्त इन ताल्ला मा, या गंळ्स उन दाढ़ी दा चट्टा ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","रा याजक चट्टा अक नोळुल, अदिक अगर अद तोगुल से गयरा कांळ्सकु बिळुल, अदिक अदुर दा भुरा-भुरा पतला चुट्टी ईरूल, रा याजक आ मंळसा अक अशुद्ध ठहरूसुल; अद चट्टा चर्मरोग, मतलब ताल्ला या दाढ़ी इन कोढ़ हुन. ");
INSERT INTO hoy_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","अदिक याजक चर्मरोग अन्द चट्टा अक नोळुल, कि अद तोगुल से गयरा हैलेच अदिक अदुर्दा करेव-करेव चुट्टी हैलेच, रा याजक चर्मरोग अन्द रोगी इक येळ दिन ताका अलग माळकु ईटुल, ");
INSERT INTO hoy_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","अदिक सातवा दिशी याजक चट्टा अक नोळुल, आग अगर चर्मरोग फैलुसकु ईला ईरूल, अदिक अदुर्दा भुरा-भुरा चुट्टी ईला ईरूल, अदिक चर्मरोग तोगुल से गयरा कांळ्सकु ईला बिळुल, ");
INSERT INTO hoy_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","रा आ मंळसा अक मुंडन माळकु आगुल, लेकीन यल चर्मरोग आग्याद अल मुंडन माळकु आग बाळुल; अदिक याजक आ चर्मरोग हतकु मंळसा अक अदिक भी येळ दिन ताका अलग माळुल; ");
INSERT INTO hoy_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","अदिक सातवा दिशी याजक चर्मरोग अक नोळुल, अदिक अगर अद चर्मरोग तोगुल दा फैलुस्कु हैलेच अदिक तोगुल से गयरा कांळ्सकु बिळाल, रा याजक आ मंळसा अक शुद्ध ठहरूसुल; अदिक आव तान कपळा वगुकु शुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","पर अगर आऊन शुद्ध ठहरूसोद बाद्दा चर्मरोग तोगुल दा थ्वाळासा भी फैलुसुल, ");
INSERT INTO hoy_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","रा याजक आऊक नोळुल, अदिक अगर अद तोगुल दा फैलुसकु ईरूल, रा याजक भुरा चुट्टी इक ढुंढ्स बाळुल, यतिकी आ मंळसा अशुद्ध आन. ");
INSERT INTO hoy_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","लेकीन अगर आऊन नजर दा अद चर्मरोग ह्यांग इन हांग बन्सकु ईरूल, अदिक अदुर्दा करेव-करेव चुट्टी जमस्कु ईरूल, रा आव जान्सुल कि दाग वळ्लीद आगेग्याद, अदिक आ मंळसा शुद्ध आन; याजक आऊक शुद्ध अच ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“बाक अगर यावारा गंळ्स या आर्त इन तोगुल दा बिळेव दाग ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","रा याजक नोळुल, अदिक अगर आऊन तोगुल दा अव दाग कम बिळेव ईरूल, रा आव जान्सुल कि आऊन तोगुल दा होटकु दाद अच हुन; आ मंळसा शुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“बाक या मंळसा अन्द ताल्ला अन्द चुट्टीगोळ झळसेग्याव, रा जान्सेतीर कि आव टकला रा आन लेकीन शुद्ध आन. ");
INSERT INTO hoy_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","अदिक यावारा मंळसा अन्द ताल्ला अन्द मुंदळव चुट्टी झळसेग्याव, रा आव ताल्ला देल रा टकला आन लेकीन शुद्ध आन. ");
INSERT INTO hoy_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","लेकीन अगर टकला ताल्ला मा या टकला ह्याणा मा क्याचांद बिळीद चट्टा ईरूल, रा जान्सेतीर कि अद आऊन टकला ताल्ला या टकला ह्याणा मा होटकु कोढ़ हुन. ");
INSERT INTO hoy_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","इदुरसाटी याजक अदरी नोळुल, अदिक अगर चट्टा अन्द सुजन आऊन टकला ताल्ला या टकला माथा मा हिंग लाली हुळकु बिळीद ईरूल जसा चमळी इन कोढ़ दा ईरतद, ");
INSERT INTO hoy_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","रा आ मंळसा कोढ़ी आन अदिक अशुद्ध आन; अदिक याजक आऊक जरूर अशुद्ध ठहरूसुल; यतिकी अद चट्टा आऊन ताल्ला मा आद. ");
INSERT INTO hoy_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“यारदा ई चट्टा ईरूल आ कोढ़ी इन कपळा हरकु अदिक ताल्ला अन्द चुट्टी बगरूस्कु ईरूल, अदिक आव तान म्याकळोद टुट्टी इक मुचकु अशुद्ध-अशुद्ध कारूतेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","यास दिन ताका अद चट्टा आऊन दा ईरूल आस दिन ताका आव रा अशुद्ध ईत्तान; अदिक आव अशुद्ध ठहरूसकु ईरूल; इदुरसाटी आव आबना अच ईरूल, आऊन ईरोद जागा छावनी इन व्हार्या ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“बाक या कपळा दा कोढ़ इन चट्टा ईरूल, चाहे अद कपळा ऊन इन ईरूल या सन इन, ");
INSERT INTO hoy_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","अद चट्टा चाहे आ सनी या ऊन इन कपळा अन्द होल्द ईरूल या बन्सकु ईरूल, या अद चट्टा तोगुल दा या तोगुल इन माळकु यातोदारा वस्तु दा ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","अगर अद चट्टा यातोदारा कपळा अन्द चाहे होल्द ईरूल चाहे बन्सकु ईरूल, या तोगुल दा या तोगुल इन यातोदारा वस्तु दा हिवरा ईरूल या क्याचाँद सा ईरूल, रा जान्सेतीर कि अद कोढ़ इन चट्टा हुंद अदिक अद याजक उक तोर्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","अदिक याजक चट्टा अक नोळुल, अदिक चट्टा हतकु आ वस्तु उक येळ दिन इन साटी अलग माळुल; ");
INSERT INTO hoy_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","अदिक सातवा दिशी आव आ चट्टा अक नोळुल, अदिक अगर अद कपळा अन्द चाहे होल्द ईरूल चाहे बन्सकु ईरूल, या तोगुल दा या तोगुल इन माळ्द यातोदारा वस्तु दा फैलुस्कु ईरूल, रा जान्सेतीर कि चट्टा हानिकारक कोळ हुंद, इदुरसाटी अद वस्तु , चाहे ह्यांगारा क्याल्सा दा येती न बरबाळुल, तो भी शुद्ध ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","आव आ कपळा अक अदुर्द ताना या बाना दा अद चट्टा ईरूल, चाहे अद ऊन इन ईरूल चाहे सनी इन ईरूल, या तोगुल इन, या तोगुल इन वस्तु ईरूल, अदरी होताकबुळुल, अद चट्टा हानिकारक कोढ़ इन हुंद; अद वस्तु बेक्की दा होताक्कु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“अगर याजक नोळुल कि अद चट्टा आ कपळा अन्द होल्द या बन्सकु, या तोगुल इन वस्तु दा फैलुसकु हैलेच, ");
INSERT INTO hoy_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","रा या वस्तु दा चट्टा ईरूल अदरी तोळोद आग्या याजक कोळुल, आग आऊक मात्त येळ दिन ताका अलग माळकु ईट्टुल; ");
INSERT INTO hoy_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","अदिक आऊन तोळदुर बाद्दा याजक आऊक नोळुल, अदिक अगर चट्टा अन्द न रा रंग बदलुसकु ईरूल, अदिक न चट्टा फैलुसकु ईरूल, रा जान्सेतीर कि अद अशुद्ध आद; अदरी बेक्की दा होताकेतीर, यतिकी चाहे अद चट्टा बुळ्क चाहे म्याकुच ईरूल तो भी अद फैलुसावाळा चट्टा हुन. ");
INSERT INTO hoy_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","पर अगर याजक नोळुल, कि आऊन तोळदुर बाद्दा चट्टा अन्द चमक कम आगेग्याद, रा आव अदरी कपळा अन्द चाहे होल्द चाहे बन्सकु दा टु, या तोगुल दा टु हरूकु तेगुल; ");
INSERT INTO hoy_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","अदिक अगर अद चट्टा आग भी आ कपळा अन्द होल्द या बन्सकु दा, या तोगुल इन आ वस्तु दा कांळ्सकु बिळुल, रा जान्सेतीर कि अद वोळकु होळ्त चट्टा हुंद; अदिक यदुर्दा अद चट्टा ईरूल अदरी बेक्की दा होताकेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","अगर आ कपळा देल अदुर्द होल्द या बन्सकु दा चट्टा ईरूल, या तोगुल इन जो वस्तु ईरूल अदरी याग तोळुकु आगुल अदिक चट्टा होगतेला ईरूल, रा अद दुसरा घन तोळुकु शुद्ध ठहरूसुल.” ");
INSERT INTO hoy_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ऊन या सनी इन कपळा अन्द होल्द या बन्सकु दा, या तोगुल इन यातोदारा वस्तु दा जो कोढ़ इन चट्टा ईरूल अदुर शुद्ध अदिक अशुद्ध ठहरूसोद ईदा व्यवस्था हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“कोढ़ी इन शुद्ध ठहरूसोद व्यवस्था ईद हुन., आव याजक उन हात्ती पोहचुस्कु आगुल; ");
INSERT INTO hoy_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","अदिक याजक छावनी इन व्हार्या होगुल, अदिक याजक आ कोढ़ी इक नोळुल, अदिक अगर आऊन कोढ़ इन चट्टा चंगा आग्याद, ");
INSERT INTO hoy_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","रा याजक आग्या कोळुल कि शुद्ध ठहरूसावाळा साटी येढ्ढ शुद्ध अदिक जीत्ता पक्षी, देवदार इन हुळ्ली, अदिक क्याचाँद रंग इन कपळा अदिक जूफा अन मार्र ईव सप्पा हुळकु होगुल; ");
INSERT INTO hoy_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","अदिक याजक आग्या कोळुल कि ऊंद पक्षी वाहुसतेला नीर इन म्याकुच मुण्ण इन भांडा दा बलि माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","आग अद जीत्ता पक्षी इक देवदार इन हुळ्ली अदिक क्याचाँद रंग इन कपळा अदिक जूफा अन मार्र ईव सप्पा अक हुळकु ऊंद सांगुळ आ पक्षी इन रकत दा जो वाहुसतेला नीर इन म्याकुच बलि माळकु आग्याद; ");
INSERT INTO hoy_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","अदिक कोढ़ देल शुद्ध ठहरूसावाळा मा येळ घन सिप्सकु आऊक शुद्ध ठहरूसुल, आग आ जीत्ता पक्षी इक मैदान दा बिटबुळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","अदिक शुद्ध ठहरूसावाळा तान कपळागोळ इक तोळुल, अदिक सप्पा चुट्टी बोळस्कु नीर देल मय तोळुल, आग आव शुद्ध ठहरूस्यान; अदिक अदुर बाद्दा आव छावनी दा बरूल, लेकीन येळ दिन ताका ड्यारा टु व्हार्या अच ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","अदिक येळवा दिशी आव ताल्ला, दाढ़ी अदिक भौऊ उन सप्पा चुट्टी मुंडुसुल, अदिक सप्पा अंग मुंडन माळसुसुल, अदिक तान कपळागोळ इक तोळुल, अदिक नीर देल मय तोळुल, आग आव शुद्ध ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“आठवा दिशी आव येढ्ढ तंदरूस्त म्यांडा अन्द पाड्डागोळ, अदिक ऊंद वर्ष इन तंदरूस्त म्यांडा अन्द पाड्डा, अदिक अन्नभेट इन साटी याण्णा देल हचकु एपा अन्द अईद किलो मैदा, अदिक आरधा लीटर याण्णा तरूल. ");
INSERT INTO hoy_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","अदिक शुद्ध ठहरूसावाळा याजक ई वस्तुगोळ सांगुळ आ शुद्ध आगावाळा मंळसा अक यहोवा अन्द मुंद भेंटमाळोद तम्बू उन द्वार मा निदुरकु ईरूल.” ");
INSERT INTO hoy_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","आग याजक ऊंद म्यांडा अन्द पाड्डा हुळकु दोषबली इन साटी अदरी अदिक आरधा लीटर इन आसपास याण्णा अक हात्ती तरूल, अदिक ईव येढ्ढु उक हालुसोद भेंट इन साटी यहोवा अन्द मुंद हालुसुल; ");
INSERT INTO hoy_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","अदिक आव आ म्यांडा अन्द पाड्डा अक अदा जागा दा यल अद पापबली अदिक होमबली पशुगोळ्द बलिदान माळतेला ईरूल, मतलब पवित्र जागा दा बलिदान माळुल; यतिकी जसा पापबली याजक उन निज भाग आदीत हांग अच दोषबली भी आऊन दा निज भाग ठहरूसीत; आव परमपवित्र आन. ");
INSERT INTO hoy_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","आग याजक दोषबली इन रकत दा टु थ्वाळासा हुळकु शुद्ध ठहरूसावाळा अन्द ऊजवा कीव इन ताल्ला मा, अदिक आऊन ऊजवा कय अदिक ऊजवा कय इन बेल्लगोळ मा हचुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","आग याजक आ लोज तीम याण्णा दा टु थ्वाळासा हुळकु तान डाक्या कय इन हथेली मा हाकुल, ");
INSERT INTO hoy_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","अदिक याजक तान ऊजवा कय इन बेल्ल इक तान डाक्या हथेली इन याण्णा दा डोब्सकु आ याण्णा दा टु येनारा तान बेल्लगोळ देल यहोवा अन्द मुंद येळ घन सिपसुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","अदिक जो याण्णा आऊन हथेली मा ईतोदित याजक अदुर दा टु येनारा शुद्ध आगावाळा अन्द ऊजवा कीव इन ताल्ला मा, अदिक आऊन ऊजवा कय अदिक ऊजवा काल इन बेल्लगोळ मा दोषबली इन रकत इन म्याकुच हचुल; ");
INSERT INTO hoy_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","अदिक जो याण्णा याजक उन हथेली मा ईतोदित अदरी आव शुद्ध आगावाळा अन्द ताल्ला मा हाक्क बुळुल. अदिक याजक आऊन साटी यहोवा अन्द मुंद प्रायश्चित माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","याजक पापबली इक भी येर्सकु आऊन साटी जो तान अशुध्दता देल शुद्ध आगावाळा ईरूल प्रायश्चित माळुल; अदिक आऊन बाद्दा होमबली पशु उन बलिदान माळकु ");
INSERT INTO hoy_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","अन्नभेट सांगुळ वेदी मा येरसुल अदिक याजक आऊन साटी प्रायश्चित माळुल, अदिक आव शुद्ध ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“लेकीन अगर आव गरीब ईरूल अदिक येनारा तरोर साटी आऊन हात्ती पूंजी ईला ईरूल, रा आव तान प्रायश्चित माळसुसोर साटी, हालुसोद साटी म्यांडा अन्द पाड्डा दोषबली इन साटी, अदिक याण्णा देल हतकु एपा अईद किलो मैदा अन्नभेट माळकु, अदिक आरधा किलो याण्णा तरूल; ");
INSERT INTO hoy_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","अदिक येढ्ढ पंडुक, या कबूतर इन येढ्ढ पाड्डा तरूल, जो आव तर सकुल; अदिक इदुर दा टु ऊंद रा पापबली इन साटी अदिक दुसरा होमबली इन साटी ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","अदिक आठवा दिशी आव ई सप्पा अक तान शुद्ध ठहरूसोर साटी भेंटमाळोद तम्बू उन द्वार मा, यहोवा अन्द मुंद, याजक उन हात्ती तरूल; ");
INSERT INTO hoy_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","आग याजक आ आरधा किलो याण्णा अदिक दोषबलीवाळा म्यांडा अन्द पाड्डा अक हुळकु हालुसोद भेंट इन साटी यहोवा अन मुंद आळगाळसुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","बाक दोषबली इन म्यांडा अन्द पाड्डा अन बलिदान माळकु आगुल; अदिक याजक अदुर रकत दा टु थ्वाळासा हुळकु शुद्ध ठहरूसावाळा अन्द ऊजवा कीव इन ताल्ला मा, अदिक आऊन ऊजवा कय अदिक ऊजवा काल इन अंगूठागोळ मा हचुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","बाक याजक आ याण्णा दा टु थ्वाळासा तान डाक्या कय इन हथेली मा हाक्कु, ");
INSERT INTO hoy_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","तान ऊजवा कय इन बेल्ल देल तान डाक्या हथेली माकळोद याण्णा दा टु याजक थ्वाळासा यहोवा अन्द मुंद येळ घन सिपसुल; ");
INSERT INTO hoy_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","बाक याजक तान हथेली माकळोद याण्णा दा टु येनारा शुद्ध ठहरूसावाळा अन्द ऊजवा कीव इन ताल्ला मा, अदिक आऊन ऊजवा कय अदिक ऊजवा काल इन बेल्लगोळ, मा दोषबली इन रकत इन जागा मा हचुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","अदिक जो याण्णा याजक उन हथेली मा ईतोगुल अदरी आव शुद्ध ठहरूसावाळा साटी यहोवा अन्द मुंद प्रायश्चित माळोर साटी कीव इन क्वाना मा हाक्क बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","आग आव पंडुक या कबूतर इन पाड्डागोळ दा टु जो आव तर सकीदान ऊंद पाड्डा अक येरसुल, ");
INSERT INTO hoy_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","मतलब जो पक्षी आव तर सकीदान, अदुर दा टु ऊंद पाड्डा अक पापबली इन साटी अदिक अन्नभेट सांगुळ दुसरा अक होमबली इन साटी येरसुल; ई रीती देल याजक शुद्ध ठहरूसावाळा अन्द साटी यहोवा अन्द मुंद प्रायश्चित माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","यारी कोढ़ इन चट्टा आग्याव, अदिक आऊन ईट पूंजी ईला ईरूल कि आव शुद्ध ठहरूसोद सामान तर सकुल, रा आऊन साटी ईदा व्यवस्था आद.” ");
INSERT INTO hoy_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","बाक यहोवा मूसा अदिक हारून से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“याग नीव लॉकुर कनान द्याश दा पोहचुसीर, यारी ना नीम्द खुद इन भूमी आगोर साटी नीमी कोळतीन, आ समय अगर ना कोढ़ इन चट्टा नीम्द अधिकार इन यातोदारा मान्ना दा तोरसाईन, ");
INSERT INTO hoy_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","रा यार्द अद मान्ना ईरूल आव बनकु याजक उक हेळ बुळुल कि नानी हिंग कांळ्सकु बिळतद कि मान्ना दा मान्सी यावारा चट्टा आद. ");
INSERT INTO hoy_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","आग याजक आग्या कोळुल कि आ मान्ना दा चट्टा नोळोर साटी नांद होगोर से पयला अदरी खाली माळी, ईलारा हिंग ना आगुल कि जो येनारा मान्ना दा ईरूल सब अशुद्ध ठहरूसुल; अदिक ईदुर बाद्दा याजक मान्ना नोळली बुळ्क होगुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","आग आव आ चट्टा अक नोळुल; अदिक अगर अद चट्टा मान्ना अन्द दिवारगोळ मा हिवरा-हिवरा या क्याचाँद-क्याचाँद मान्सी अगुळकु लकीरगोळ्द रूप दा ईरूल, अदिक ईव लकीरगोळ दिवार दा खोल कांळ्सकु बिळतद, ");
INSERT INTO hoy_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","रा याजक मान्ना टु व्हार्या द्वार मा होगकु मान्ना अक येळ दिन ताका बंद माळकु ईट्टुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","अदिक येळवा दिशी याजक बनकु नोळुल; अदिक अगर अद चट्टा मान्ना अन्द दिवारगोळ मा फैलुस्कु ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","रा याजक आग्या कोळुल कि या कल्लगोळ इक चट्टा आद अदरी तेगुकु नगर टु व्हार्या यातोदारा अशुद्ध जागा दा भीळ बुळुल; ");
INSERT INTO hoy_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","अदिक आव मान्ना अन्द बुळ्क इन बुळ्क नाकु दी वरपुसुल, अदिक अद वरपुस्द मुण्ण नगर इन व्हार्या यातोदारा अशुद्ध जागा दा हाक्कु आगुल; ");
INSERT INTO hoy_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","अदिक आ कल्लगोळ जागा दा अदिक दुसरा कल्ल हुळकु हचुल अदिक याजक ताजा गारा हुळकु मान्ना अन्द जुळाई माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“अगर कल्लगोळ तेगुकु आगोद अदिक मान्ना अन्द वरपुस्द जुळाई अदिक पोचकु आगोद बाद्दा अद चट्टा बाक मान्ना दा मात्त होळुल, ");
INSERT INTO hoy_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","रा याजक बनकु नोळुल; अदिक अगर अद चट्टा मान्ना दा फैलुसेग्याद, रा आव जान्स कोमुल कि मान्ना दा हानिकारक कोढ़ आद; अद मान्ना अशुद्ध आद. ");
INSERT INTO hoy_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","अदिक अद सप्पा गारा सांगुळ कल्ल, हुळ्ली अदिक मान्ना अक अगुळकु केडु बुळुल; अदिक आ सप्पा वस्तुगोळ इक नेगुकु नगर टु व्हार्या यातोदारा अशुद्ध जागा मा भिळसुस बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","अदिक यागासताका अद मान्ना बंद ईरूल आगासताका अगर यावारा अदुर्दा होगुल रा आव द्यावगाताका अशुद्ध ईरूल; ");
INSERT INTO hoy_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","अदिक जो यावारा आ मान्ना दा मिंगुल आव तान कपळागोळ इक तोळुल; अदिक जो यावारा आ मान्ना दा येनारा तिनुल आव भी तान कपळागोळ इक तोळुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“पर अगर याजक बनकु नोळुल कि यागी टु मान्ना लिपस्कु आग्याद आगी टु अदुर्दा चट्टा फैलुसीदिल, रा ईद जान्सकु कि अद चट्टा दुर आगेग्याद, मान्ना अक शुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","अदिक आ मान्ना अक पवित्र माळोर साटी येढ्ढ पक्षी, देवदार इन हुळ्ली, क्याचाँद रंग इन कपळा अदिक जूफा अन मार्र तरूल, ");
INSERT INTO hoy_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","अदिक ऊंद पक्षी वाहुसतेला नीर इन म्याकुच मुण्ण इन बर्तन दा बलिदान माळुल, ");
INSERT INTO hoy_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","आग अद देवदार मार्र इन हुळ्ली, क्याचाँद रंग इन कपळागोळ अदिक जूफा अदिक जीत्ता पक्षी ई सप्पा अक हुळकु बलिदान माळ्द पक्षी इन रकत दा अदिक वाहुसतेला नीर दा मुळकुस बुळुल, अदिक आ मान्ना मा येळ घन सिपसुल. ");
INSERT INTO hoy_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ईद प्रकार अद पक्षी इन रकत, अदिक वाहुसतेला नीर, अदिक जीत्ता पक्षी, अदिक देवदार मार्र इन हुळ्ली, अदिक जूफा अदिक क्याचाँद रंग इन कपळा अन्द द्वारा मान्ना अक पवित्र माळुल; ");
INSERT INTO hoy_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","आग आव जीत्ता पक्षी इक नगर टु व्हार्या मैदान दा बिट्ट बुळुल; ईदा रीती देल आव मान्ना अन्द साटी प्रायश्चित माळुल, आग आव शुद्ध ठहरूस्यान.” ");
INSERT INTO hoy_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","सप्पा प्रकार इन कोढ़ इन चट्टा, अदिक सेंहुएँ, ");
INSERT INTO hoy_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","अदिक कपळा, अदिक मान्ना अन्द कोढ़, ");
INSERT INTO hoy_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","अदिक सुजन, अदिक फ्वाळा, अदिक दाग इन बारा दा, ");
INSERT INTO hoy_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","शुद्ध अदिक अशुद्ध ठहरूसोद शिक्षा कोळोद व्यवस्था ईदा हुंद. सप्पा प्रकार इन कोढ़ इन व्यवस्था ईदा हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","बाक यहोवा मूसा अदिक हारून से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएलीगोळ से अनी कि या-या गंळ्स उन मय दा टु स्त्राव होगुल, रा आव स्त्राव इन कारण देल अशुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","अद चाहे वाहुसतेला ईरूल, चाहे वाहुसोद बंद भी ईरूल, तो भी आऊन अशुध्दता बनस्कु ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","यारी स्त्राव ईरूल आव या-या बिछौना मा मिंगुल अद अशुद्ध ठहरूसुल. या वस्तु मा आव कुरतान अद भी अशुध्द ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","अदिक जो यावारा आऊन हासक्या अक मुटुल आव तान कपळागोळ इक तोळुकु नीर देल मय तोळुल, अदिक द्यावगाताका अशुद्ध ठहरूसकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","अदिक यार दा स्त्राव ईरूल अदिक आव या वस्तु मा कुर्तकु ईरूल, अदुर मा जो यावारा कुरूल आव तान कपळागोळ इक तोळुकु नीर देल मय तोळुल, अदिक द्यावगाताका अशुद्ध ठहरूसकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","अदिक यारदा स्त्राव ईरूल आऊन से जो यावारा मुटकु आगुल आव तान कपळागोळ इक तोळुकु नीर देल मय तोळुल अदिक द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","अदिक यारदा स्त्राव ईरूल अगर आव यातोदारा शुद्ध मंळसा मा ऊगळुल, रा आव तान कपळागोळ इक तोळुकु नीर देल मय तोळुल, अदिक द्यावगा ताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","अदिक यारदा स्त्राव ईरूल आव सवारी या वस्तु मा कुरूल अद अशुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","अदिक जो यावारा यातोदारा वस्तु उक जो आऊन ल्‍यालमा ईटकु ईरूल मुटुल, आव द्यावगाताका अशुद्ध ईरूल; अदिक जो यावारा हिंग यातोदारा वस्तु उक नेगुल आव तान कपळागोळ इक तोळुकु नीर देल मय तोळुल, अदिक द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","अदिक यारदा स्त्राव ईरूल आव यावारा वळ्लीद मंळसा अक बिना कय तोळुकु मुटुल रा आ मंळसा तान कपळागोळ इक तोळुकु नीर देल मय तोळुल, अदिक द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","अदिक यारदा स्त्राव ईरूल आव मुण्ण इन यातोदारा बर्तन इक कय हचुल अद वळकु आगुल, अदिक हुळ्ली इन माळ्द सप्पा प्रकार इन बर्तन नीर देल तोळुकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“बाक यारदा स्त्राव ईरूल आव याग तान रोग देल चंगा आगेगुल, आगी टु शुद्ध ठहरूसोद येळ दिन आळु कोमुल, अदिक अऊरव बितुसदुर मा तान कपळागोळ इक तोळुकु वाहुसतेला नीर देल मय तोळुल; आग आव शुद्ध ठहरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","अदिक आठवा दिशी आव येढ्ढ पंडुक या कबूतर इन येढ्ढ पाड्डा हुळकु भेंटमाळोद तम्बू उन द्वार मा यहोवा अन्द मुंद होगकु अवरी याजक उक कोळुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","आग याजक अऊर दा टु ऊंद पापबली; अदिक दुसरा अक होमबली इन साटी भेंट येरसुल; अदिक याजक आऊन साटी आऊन स्त्राव इन कारण यहोवा अन्द मुंद प्रायश्चित माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“बाक अगर यावारा गंळ्स उन वीर्यपात आगेगुल, रा आव तान पुरा मय इक नीर देल तोळुल, अदिक द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","अदिक यातोदारा कपळा या तोगुल मा अद वीर्य बिळुल अद नीर देल तोळुकु आगुल, अदिक द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","अदिक जब यावारा गंळ्स आर्त से प्रसंग माळुल रा आंदुर येढ्ढु मुंदुर नीर देल मय तोळुल, अदिक द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“बाक याग यातोदारा आर्त मासीक पाळी देल ईरूल, रा आक येळ दिन ताका अशुद्ध ठहरूसकु ईरूल, अदिक जो यावारा आकीक मुटुल आव द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","अदिक यागासताका अशुद्ध ईरूल आगासताका या-या वस्तु मा आक मिंगुल, अदिक या-या वस्तु मा आक कुरूल अव सप्पा अशुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","अदिक जो यावारा आकीन हासक्या अक मुटुल आव तान कपळा अक तोळुकु नीर देल मय तोळुल, अदिक द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","अदिक जो यावारा यातोदारा वस्तु उक मुटुल यदुर मा आक कुर्तकु ईरूल आव तान कपळा तोळुकु नीर देल मय तोळुल, अदिक द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","अदिक अगर हासक्या या अदिक यातोदारा वस्तु मा यदुर मा आक कुर्तकु ईरूल मुटदुर समय आकीन रकत हतकु ईरूल, रा मुट्ठावाळा द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","अदिक अगर यावारा गंळ्स आकीन से प्रसंग माळुल, अदिक आकीन रकत आऊक हत्तेगुल, रा आ गंळ्स येळ दिन ताका अशुद्ध ईरूल, अदिक या-या हासक्या मा आक मिंगुल अव सप्पा अशुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“बाक अगर यातोदारा आर्त इन तान मासीक धर्म इन नियुक्त समय देल येक्कुल दिन ताका रकत वाहुसतेला ईरूल, या आ नियुक्त समय देल येक्कुल समय ताका मासीक धर्म ईरूल, रा यागासताका आक हिंग दशा दा ईरूल आगासताका आक अशुद्ध ठहरूसकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","आकीन मासीक पीळा ईरोद सप्पा दिनगोळ दा या-या बिछौना मा आक मिंगीदुर अव सप्पा आकीन मासीक धर्म इन बिछौना अन्द घाई ठहरूसुल; अदिक या-या वस्तु मा आक कुरूल अव भी आकीन मासीक धर्म ईरोद दिनगोळ्द घाई अशुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","अदिक जो यावारा आ वस्तुगोळ इक मुटुल अव अशुद्ध ठहरूसुल, इदुरसाटी आव तान कपळागोळ इक तोळुकु नीर देल मय तोळुल, अदिक द्यावगाताका अशुद्ध ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","अदिक याग आ आर्त तान मासीक धर्म देल शुद्ध आगेगुल, आगी टु आक येळ दिन आळु कोमुल, अदिक आ दिनगोळ बितुसदुर मा आक शुद्ध ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","बाक आठवा दिशी आक येढ्ढ पंडुक या कबूतर इन येढ्ढ पाड्डा हुळकु भेंटमाळोद तम्बू उन द्वार मा याजक उन हात्ती होगुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","आग याजक ऊंद पाड्डा अक पापबली अदिक दुसरा अक होमबली इन साटी येरसुल; अदिक याजक आकीन साटी आकीन मासीक धर्म इन अशुध्दता अन्द कारण यहोवा अन्द मुंद प्रायश्चित माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ई प्रकार देल नीव इस्राएलीगोळ इक आंदुर अशुद्धता देल अलग ईटी, ईलारा हिंग न आगुल कि आंदुर यहोवा अन्द निवास इक जो आंदुर न्याड्या दा आर अशुद्ध माळकु तान अशुद्धता दा फसुसकु सोतोगुल.” ");
INSERT INTO hoy_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","यारदा स्त्राव ईरूल अदिक जो गंळ्स वीर्यपात आगदुर देल अशुद्ध ईरूल; ");
INSERT INTO hoy_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","अदिक जो आर्त मासीक धर्म दा ईरूल, अदिक येन गंळ्स येन आर्त, इंदुर दा टु यारीकारा धातुरोग ईरूल, अदिक जो गंळ्स अशुद्ध आर्त इन सांगुळ प्रसंग माळुल, ई सप्पा मुंदुर साटी ईदा व्यवस्था हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","जब हारून उन येढ्ढ पारगोळ यहोवा अन्द मुंद आऊन हात्ती होगकु सोतोदुर, अदुर बाद्दा यहोवा मूसा से मातगोळ माळदुन; ");
INSERT INTO hoy_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","अदिक यहोवा मूसा से अंदुन, “तान वार्ट हारून से अन कि सन्दुक इन म्याकुच इन प्रायश्चितवाळा ढकनगोळ्द मुंद, न्याड्यावाळा पळदागोळ्द बुळ्क, अति पवित्र जागा दा हर समय प्रवेश माळबाळी, ईलारा सोतोदान; यतिकी ना प्रायश्चितवाळा ढकनगोळ्द म्याकुच बादल दा कांळ्सकु बिळाईन.” ");
INSERT INTO hoy_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","याग हारून अति पवित्र जागा दा प्रवेश माळुल आग ई रीति देल प्रवेश माळुल, मतलब पापबली इन साटी ऊंद वस्ता अक अदिक होमबली इन साटी ऊंद म्यांडा अक हुळकु बरूल. ");
INSERT INTO hoy_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","आव सन इन कपळा अन्द पवित्र अंगरखा, अदिक तान तन मा सनी इन कपळा अन्द जंग्या हाक्कु, अदिक सनी इन कपळा अन्द पट्टा, अदिक सनी इन कपळा अन्द पगळी कटकु प्रवेश माळुल; ईव पवित्र कपळा हूँ, अदिक आव नीर देल मय तोळुकु ईवरी हाकुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","बाक आंदुर इस्राएलिगोळ्द मंडली इन हात्ती टु पापबली इन साटी येढ्ढ व्हातगोळ अदिक होमबली इन साटी ऊंद म्यांडा कोमुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","अदिक हारून आ पापबली इन वस्ता अक जो आऊंदा साटी आदीत येर्सकु तान अदिक तान घराना अन्द साटी प्रायश्चित माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","अदिक आ येढ्ढु व्हातगोळ इक हुळकु भेंटमाळोद तम्बू उन द्वार मा यहोवा अन्द मुंद निदरूसुल; ");
INSERT INTO hoy_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","अदिक हारून येढ्ढु व्हातगोळ मा चिट्टीगोळ हाकुल, ऊंद चिट्ठी यहोवा अन्द साटी अदिक दुसरा अजाजेल उन साटी ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","अदिक या व्हात मा यहोवा अन्द हेसुर इन चिट्टी होळुल अदरी हारून पापबली इन साटी येरसुल; ");
INSERT INTO hoy_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","लेकीन या व्हात मा अजाजेल उन साटी चिट्टी होळुल आव यहोवा अन्द मुंद जीत्ता निदरूसकु आगुल कि अदुर देल प्रायश्चित माळकु आगुल, अदिक अद अजाजेल उन साटी आळी दा बिटकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“हारून आ पापबली इन वस्ता अक, जो आऊंदा साटी आदीत, हात्ती हुळकु बरूल, अदिक अदरी बलिदान माळकु तान अदिक तान घराना अन्द साटी प्रायश्चित माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","अदिक जो वेदी यहोवा अन्द मुंद आद, अदुर माकळव होततेला कोयलागोळ देल तुमकु धूपदान इक हुळकु, अदिक तान येढ्ढु मुट्ठीगोळ इक कुटकु सुगन्धित धूप देल तुमकु, न्याड्यावाळा परदा अन्द बुळ्क तनकु ");
INSERT INTO hoy_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","आ धूप इक यहोवा अन्द मुंद बेक्की दा हाकुल, यदुर देल धूप इन धुंगा साक्षीपत्र अन्द म्याकुच इन प्रायश्चित इन ढकन इन म्याकुच छासेगुल, ईला रा अद सोतोदीत; ");
INSERT INTO hoy_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","आग आव वस्ता अन्द रकत दा टु थ्वाळासा हुळकु पूरब इन दी प्रायश्चित इन ढकन इन म्याकुच तान बेल्लगोळ देल सिपसुल, अदिक बाक आ रकत दा टु थ्वाळासा बेल्लगोळ्द द्वारा आ ढकन उन मुंद भी येळ घन सिप्स बुळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","बाक आव आ पापबली इन व्हात इक जो साधारण जनता अन्द साटी ईत्तीत बलिदान माळकु अदुर्द रकत इक न्याड्यावाळा परदा अन्द बुळ्क तरूल, अदिक या प्रकार वस्ता अन्द रकत देल आव माळीदुन ठीक हांग अच आव व्हात इन रकत देल भी माळुल, मतलब अदरी प्रायश्चित इन ढकन इन म्याकुच अदिक आऊन मुंद सिपसुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","अदिक आव इस्राएली लॉकुर्द अशुध्दता, अदिक अपराधगोळ, अदिक आंदुरव सप्पा पापगोळ्द कारण पवित्र जागा अन्द साटी प्रायश्चित माळुल; अदिक भेंट माळोद तम्बु जो आंदुर सांगुळ आंदुर भाँति-भाँति इन अशुद्धता अन्द बीच ईरतद अदुर साटी भी आव हांग अच माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","जब हारून प्रायश्चित माळोर साटी अति पवित्र जागा दा प्रवेश माळुल, आगी टु यागासताका आव तान अदिक तान घराना अदिक इस्राएल इन पुरा मंडली इन साटी प्रायश्चित माळकु व्हार्या होळ बाळुल आगासताका यावारा मंळसा भेंटमाळोद तम्बू दा ईरबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","बाक आव होटकु आ वेदी इन हात्ती जो यहोवा अन्द मुंद आन होगुल अदिक आऊन साटी प्रायश्चित माळुल, मतलब वस्ता अन्द रकत अदिक व्हात इन रकत येढ्ढु दा टु थ्वाळासा हुळकु आ वेदी इन नाकु क्वाना अन्द सींगगोळ मा हचुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","अदिक आ रक्ता दा टु थ्वाळासा तान बेल्लगोळ्द द्वारा येळ घन अदुर मा छिळकुसकु अदरी इस्राएली लॉकुर्द अशुध्दता बिळस्कु शुद्ध अदिक पवित्र माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“याग आव पवित्र जागा अदिक भेंटमाळोद तम्बू अदिक वेदी इन साटी प्रायश्चित माळ कोंडुर बाद्दा, आग जीत्ता व्हात इक मुंद तरूल; ");
INSERT INTO hoy_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","अदिक हारून तान येढ्ढु कय इक जीत्ता व्हात मा ईटकु इस्राएलिगोळ्द सप्पा दुष्कर्म इन सप्पा क्याल्सागोळ, अदिक आंदुरव सप्पा अपराधगोळ, मतलब आंदुरव सप्पा पापगोळ इक अंगीकार माळुल, अदिक आंदरी व्हात इन ताल्ला मा हुळकु अदरी यावारा मंळसा अन्द कय जो ई क्याल्सा अन्द साटी तयार ईरूल सुनसान आळी दा कळुकु बिळ्स बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","अद व्हात आंदुर सप्पा दुष्कर्म इन क्याल्सागोळ इक तान म्याकुच लादस्कु यातोदारा सुनसान जागा दा नेगुकु वोतान; इदुरसाटी आ व्हात इक आळी दा बिटबुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“आग हारून भेंटमाळोद तम्बू दा बरूल, अदिक या सन इन कपळा गोळ इक हाक्कु आव अति पवित्र जागा दा प्रवेश माळीदुन अदरी तेगुकु अल्या ईट बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","बाक आव यातोदारा पवित्र जागा दा नीर देल मय तोळुकु तान रोजी नव कपळा हाक्क कोमुल, अदिक व्हार्या होगकु तान होमबलि अदिक साधारण जनता अन्द होमबली इक येर्सकु तान अदिक जनता अन्द साटी प्रायश्चित माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","अदिक पापबली इन चरबी इक आव वेदी मा होताकुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","अदिक जो मंळसा व्हात इक अजाजेल उन साटी बिटकु बरूल आव भी तान कपळागोळ इक तोळुल, अदिक नीर देल मय तोळुल, अदिक आग आव छावनी दा प्रवेश माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","अदिक पापबली इन पाड्डा अदिक पापबलि इन व्हात इक भी अदुर रकत पवित्र जागा दा प्रायश्चित माळोर साटी पोहचुस्कु आगुल अव येढ्ढु छावनी टु व्हार्या पोहचुस्कु आगुल; अदिक अऊर तोगुल, चिच्ची, अदिक सेंगळी बेक्की दा होताक्कु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","अदिक जो अवरी होताकुल आव तान कपळागोळ इक तोळुल, अदिक नीर देल मय तोळुल, अदिक इदुर बाद्दा आव छावनी दा प्रवेश माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“नीव लॉकुर साटी ईद सदा अन्द विधी आदीत कि सातवा तिंगुळ इन दसवा दिन इक नीव उपास माळेतीर, अदिक आ दिन यावारा, चाहे अद नीम्द खुद इन द्याश इन ईरूल चाहे नीम्द न्याड्या ईरावाळा यावारा देशी या परदेशी ईरूल, यावारा भी यातोदारा प्रकार इन क्याल्सा धंदा माळबाळुल; ");
INSERT INTO hoy_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","यतिकी आ दिन नीमी शुद्ध माळोर साटी नीम्द निमित्त प्रायश्चित माळकु आदीत; अदिक नीव तान सप्पा पापगोळ देल यहोवा अन्द मुंद पवित्र ठहरूसीर. ");
INSERT INTO hoy_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ईद नीम्द साटी परम आराम इन दिन ठहरूसीत, अदिक नीव आ दिन उपास माळेतीर अदिक यातोदारा प्रकार इन क्याल्सा धंदा माळेतीर; ईद सदा अन्द विधी हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","अदिक जो तान आप्प उन जागा मा याजक पद इन साटी अभिषेक अदिक शुद्ध माळकु आगुल आ याजक प्रायश्चित माळुल, मतलब आव सन इन कपळा गोळ इक हाक्कु, ");
INSERT INTO hoy_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","पवित्र जागा, अदिक भेंटमाळोद तम्बू, अदिक वेदी इन साटी प्रायश्चित माळुल; अदिक याजक उन अदिक मंडली इन सप्पा लॉकुर साटी भी प्रायश्चित माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","अदिक ईद नीम्द साटी सदा अन्द विधी आदीत, कि इस्राएलिगोळ्द साटी हर साल ऊंद घन नीम्द पुरा पापगोळ्द साटी प्रायश्चित माळकु आगुल.” यहोवा अन्द ई आग्या अन्द अनुसार जो आव मूसा अक कोटीदुन, हारून माळदुन. ");
INSERT INTO hoy_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून अदिक आऊन पारगोळ से अदिक सप्पा इस्राएलिगोळ से अन कि यहोवा ईद आग्या कोट्टान: ");
INSERT INTO hoy_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","इस्राएल इन घराना दा टु यावारा मंळसा ईरूल जो म्यांडा अन्द पाड्डा, या मर्री इक, चाहे छावनी दा चाहे छावनी टु व्हार्या घात माळकु ");
INSERT INTO hoy_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","भेंटमाळोद तम्बू उन द्वार मा, यहोवा अन्द निवास इन मुंद यहोवा अक येर्सोद निमित्त वोयबाळुल, रा आ मंळसा अक रकत वाहुसोद दोष हत्तीत; अदिक आ मंळसा जो रकत वाहुसावाळा ठहरूस्यान, आव तान लॉकुर न्याड्या टु नष्ट माळकु आदान. ");
INSERT INTO hoy_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ई विधी इन ईद कारण आद कि इस्राएली तान बलिदान अवरी आंदुर खुला मैदान दा वध माळतार, आंदुर अवरी भेंटमाळोद तम्बू उन द्वार मा याजक उन हात्ती, यहोवा अन्द हात्ती, यहोवा अन्द साटी वोतकु आऊंदा साटी मेल-मिलाप बलि माळकु बलिदान माळकु आगुल; ");
INSERT INTO hoy_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","अदिक याजक रकत इक भेंटमाळोद तम्बू उन द्वार मा यहोवा अन्द वेदी इन म्याकुच सिपसुल, अदिक चरबी इक आऊन सुखदायक सुगन्ध इन साटी होताकुल. ");
INSERT INTO hoy_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","आंदुर जो व्हातगोळ्द पूजक ईतकु व्यभिचार माळतार, आंदुर बाक तान बलि पशुगोळ इक आंदुर साटी बलिदान माळबाळुल. नीम्द पीढ़ीगोळ साटी ईद सदा अन्द विधी आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ नी आंदुर से अन कि इस्राएल इन घराना अन्द लॉकुर दा टु या आंदुर न्याड्या ईरावाळेर परदेशीगोळ दा टु यावारा मंळसा यती ईरबाळुल जो होमबलि या मेलबलि येरसुल, ");
INSERT INTO hoy_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","अदिक अदरी भेंटमाळोद तम्बू उन द्वार मा यहोवा अन्द साटी येरसोर साटी तरबाळुल; आ मंळसा तान लॉकुर दा टु नष्ट माळकु आदान. ");
INSERT INTO hoy_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“बाक इस्राएल इन घराना अन्द लॉकुर दा टु या आंदुर न्याड्या ईरावाळेर परदेशीगोळ दा टु यावारा मंळसा यती ईरबाळुल जो यातोदारा प्रकार इन रकत तिनुल, ना आ रकत तिनावाळा अन्द दी टु तान बाय तिर्गुस बुळाईन विमुख अदिक आऊन लॉकुर न्याड्या दा टु नष्ट माळ बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","यतिकी मय इन जीव रकत दा ईरतद; अदिक अदरी ना नीम लॉकुरी वेदी मा येरसोर साटी कोट्टीन कि नीम्द जीवगोळ साटी प्रायश्चित माळकु आगुल; यतिकी जीव इन साटी रकत टु उच प्रायश्चित आगतद. ");
INSERT INTO hoy_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ई कारण ना इस्राएलिगोळ से अनतीन कि नीम दा टु यावारा प्राणी रकत तिनबाळुल, अदिक जो परदेशी नीम्द न्याड्या ईरतान आव भी रकत यागलु तिनबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“इस्राएलिगोळ दा टु या आंदुर न्याड्या ईरावाळेर परदेशीगोळ दा टु, यावारा मंळसा यती ईरबाळुल, जो शिकार माळकु तिनोद योग्य पशु या पक्षी इक हुडुल, आव अऊर रकत इक पलटुस्कु धुळा देल झाक्स बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","यतिकी मय इन जीव जो आद अद आऊन रकत अच हुंद जो आऊन जीव इन सांगुळ ऊंद आद; इदुरसाटी ना इस्राएलिगोळ से अनतीन कि यातोदु प्रकार इन प्राणी इन रकत इक नीव तिनबाळेतीर, यतिकी सप्पा प्राणीगोळ्द जीव आंदुर रकत अच हुंद; जो यावारा अदरी तिंदान आव नष्ट माळकु आदान.” ");
INSERT INTO hoy_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“अदिक चाहे अद देशी ईरूल या परदेशी ईरूल, जो यावारा यातोदारा लोथ या हर्दकु पशु उन चिच्ची तिनुल आव तान कपळागोळ इक तोळुकु नीर देल मय तोळुल, अदिक द्यावगाताका अशुद्ध ईरूल; आग आव शुद्ध आदान. ");
INSERT INTO hoy_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","लेकीन अगर आव अवरी ईला तोळदान अदिक मय तोळुतीदिल, रा आऊक तान दुष्कर्म इन भार खुद नेग्गोद बिद्दीत.” ");
INSERT INTO hoy_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","इस्राएलिगोळ से अन कि ना नीम्द परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","नीव मिस्त्र द्याश इन क्याल्सागोळ्द अनुसार व्यवहार माळबाळेतीर, यदुर्दा नीव ईरतोगीर, माळबाळेतीर; अदिक कनान द्याश इन अनुसार भी, यल ना नीमी ओयेतीन, माळबाळेतीर; अदिक न आ द्याशगोळ्द विधीगोळ मा नळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","नांद अच नियमगोळ इक मान्सेतीर, अदिक नांद अच विधीगोळ इक मान्सतेला अदुर मा नळेतीर. ना नीम्द परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","इदुरसाटी नीव नांद नियमगोळ अदिक नांद विधीगोळ इक हमेशा मान्सेतीर; जो मंळसा अवरी मानस्यान आव अऊर कारण जीत्ता ईत्तान. ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“नीम दा टु यावारा तान यातोवारा हात्ती नव कुटुम्बिगोळ सांगुळ शारीरिक संबंध माळबाळी. ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","तान मोय इन मय, जो नीम्द आप्प उन मय हुंद, आकीन से शारीरिक संबंध ईटबाळी; आक रा नीम्द मोय उर, इदुरसाटी नीव आकीन सांगुळ शारीरिक संबंध ईटबाळी. ");
INSERT INTO hoy_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","तान सौतेला मोय से भी शारीरिक संबंध ईटबाळ; अदुर देल नींद आप्प उन ईज्जत होदीत. ");
INSERT INTO hoy_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","तान आकतींग चाहे सगा ईरूल चाहे सौतेला ईरूल, चाहे आक मान्या दा पैदा आग्यार चाहे व्हार्या, आकीन से शारीरिक संबंध ईटबाळ. ");
INSERT INTO hoy_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","नी तान नातुगीतिन सांगुळ शारीरिक संबंध ईटबाळ, बाक आक नींद पार उन पोर ईरूल या बाक नीन पोर इन पोर ईरूल; अदुर देल नींद अच बदनामी आदीत! ");
INSERT INTO hoy_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","नीम्द सौतेला आकतींग जो नीम्द आप्प से पैदा आदुर, आक नीम्द आकतींग उर, ई कारण नी आकीन से शारीरिक संबंध ईटबाळ. ");
INSERT INTO hoy_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","तान फूफी इन से शारीरिक संबंध ईटबाळ; आक रा नींद आप्प उन हात्तीनोर नातावळ्त उर. ");
INSERT INTO hoy_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","तान मावसी से शारीरिक संबंध ईटबाळ; यतिकी आक नींद मोय इन आकतींग हुळ. ");
INSERT INTO hoy_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","नी तान काका अन्द बेईजती माळबाळ, मतलब आऊन हिंग्स से शारीरिक संबंध ईटबाळ; आक रा नीम्द काकी हुळ. ");
INSERT INTO hoy_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","तान सासा अन्द सांगुळ शारीरिक संबंध ईटबाळ, आक रा नीन पार उन हिंग्स उर, ई कारण नीव आकीन सांगुळ शारीरिक संबंध ईटबाळ. ");
INSERT INTO hoy_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","तान भाभी इन सांगुळ शारीरिक संबंध ईटबाळ, अदुर देल नींद वार्ट उन ईज्जत होदीत. ");
INSERT INTO hoy_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ऊंदाकान आर्त इन अदिक आकीन पोर इन म्हणजेच येढ्ढु मुंदरी मतलब आकीन नातुगीत इन सांगुळ बाक आक आकीन पोर इन पोर ईरूल या पार उन पोर ईरूल शारीरिक संबंध ईटबाळी. कारण आंदुर आकीन हात्तीनोर नातागोळ उर; हिंग माळोद महापाप आद. ");
INSERT INTO hoy_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","नींद हिंग्स जीत्ता ईतकु आकीन आकतींग इक हिंग्स माळकु आकीन सवत तरबाळ; अदुर देल आंदुर आबुर दाबुर्द दुश्मन आदार; नी आकीन आकतींग इन सांगुळ शारीरिक संबंध ईटबाळ. ");
INSERT INTO hoy_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“बाक यागासताका याकारा आर्त तान महावारी इन कारण अशुद्ध ईरूल आगासताका आकीन सांगुळ शारीरिक संबंध ईटबाळ.” ");
INSERT INTO hoy_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","बाक नी तान वार्ट बन्धु उन हिंग्स उन सांगुळ शारीरिक संबंध ईटबाळ. अदुर देल नी अशुद्ध आद्या. ");
INSERT INTO hoy_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","तान औलाद दा टु यारीकारा मोलेक द्याव इन साटी होम माळकु येर्सबाळेतीर, अदिक न तान परमेश्वर उन हेसुर इक अपवित्र ठहरूसेतीर; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","स्त्रीगमन उन रीती पुरूषगमन माळबाळेतीर; अद रा घिनौना क्याल्सा हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","यातोदारा पशु उन सांगुळ पशुगमन माळकु अशुद्ध आगबाळेतीर, अदिक न यावारा आर्त पशु उन मुंद इदुरसाटी नीदुरकु ईरूल कि आकीन सांगुळ कुकर्म माळुल; ईद रा उलटा मात हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“हिंग-हिंग यातोवारा भी क्याल्सा माळकु अशुद्ध आगबाळेतीर, यतिकी या जातीगोळ इक ना नीम्द मुंद टु तेगदुर मा आईन आंदुर हिंग-हिंग क्याल्सा माळकु अशुद्ध आगेग्यार; ");
INSERT INTO hoy_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","अदिक आंदुर द्याश भी अशुद्ध आगेग्याद, ई कारण ना आऊन मा आऊन दुष्कर्म अन दण्ड कोळतीन, अदिक अद द्याश तान ईरावाळेर इन तेगु बुळतद. ");
INSERT INTO hoy_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ई कारण नीव लॉकुर नांद विधीगोळ अदिक नियमगोळ इक हमेशा मानसेतीर, अदिक चाहे देशी, चाहे नीम्द न्याड्या ईरावाळा परदेशी ईरूल, नीम दा टु यावारा भी हिंग घिनौना क्याल्सा माळबाळेतीर; ");
INSERT INTO hoy_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","यतिकी हिंग सप्पा घिनौना क्याल्सागोळ इक आ द्याश इन मंळसा जो नीम से पयला अदुर्दा ईरतोगोर, आंदुर माळतेला बंदार, ईदुर देला अद द्याश अशुद्ध आग्याद. ");
INSERT INTO hoy_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ईग हिंग ना आगुल कि या रीती देल जो राज्य नीम से पयला आ द्याश दा ईरतोगोद, अदरी आव तेगु बुट्टुन, अदा रीती देल याग नीव आऊक अशुद्ध माळी, रा आव नीम इक भी तेगु बुट्टान.” ");
INSERT INTO hoy_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“जो यावारा हिंग घिनौना क्याल्सा माळतान आंदुर सप्पा प्राणी तान लॉकुर दा टु नष्ट माळकु आदार.” ");
INSERT INTO hoy_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“ईद आग्या जो ना नीम्द मान्सोर साटी कोट्टीन, अदरी नीव मानसेतीर, अदिक जो घिनौना रीतिगोळ नीम से पयला प्रचलित आद, अदुर्दा टु यातोदारा रीती मा नळुबाळेतीर, अदिक न अदुर कारण अशुद्ध आगेतीर. ना नीम्द परमेश्वर यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“इस्राएलिगोळ्द पुरा मंडली से अन कि नीव पवित्र बन्सकु ईरी; यतिकी ना नीम्द परमेश्वर यहोवा पवित्र आईन.” ");
INSERT INTO hoy_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","नीव तान-तान मोय अदिक तान-तान आप्प उन आदर माळी, अदिक नांद आराम दिनगोळ्द अंज्क मान्सी ना नीम्द परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","नीव मुरतीगोळ दी तिर्ग बाळेतीर, अदिक भगवानगोळ्द मुरतीगोळ इक ढाल्सकु माळबाळेतीर; ना नीम्द परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“याग नीव यहोवा अन्द साटी मेल-मिलाप बली माळी, आग हिंग बलिदान माळेतीर यदुर देल ना नीम से प्रसन्न आगेगाईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","अदुर चिच्ची बलिदान इन दिशी अदिक दुसरा दिशी तिनकु आगुल, लेकीन तीसरा दिन ताका जो मिक्कु ईरूल अद बेक्की दा होत्‍ताकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","अगर अदुर दा टु येनारा भी तीसरा दिन भी तिनकु आगुल, रा ईद अशुध्‍द ठहरूस्यान, अदिक ग्रहण माळकु आगतीदिल. ");
INSERT INTO hoy_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","अदिक अदरी तिनावाळा यहोवा अन्द पवित्र पदार्थ अक अपवित्र ठहरूसतान, इदुरसाटी आऊक तान दुष्कर्म अन भार खुद नेग्गोद बिद्दीत; अदिक अद प्राणी तान लॉकुर दा टु नष्ट माळकु आदीत.” ");
INSERT INTO hoy_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“बाक याग नीव तान द्याश इन केई कळदीर, आग तान केई इन क्वाना-क्वाना ताका पूरा कडु बाळेतीर, अदिक कळकु केई इन बिदकु लॉम्बागोळ इक आयबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","अदिक तान अंगुर इन बेली इन दाना-दाना मुरूबाळेतीर, अदिक तान अंगुर इन बेली इन झळस्कु अंगुरगोळ इक नेगुबाळेतीर; अवरी गरीब अदिक परदेशी लॉकुरगोळ साटी बिट्ट बुळेतीर; ना नीम्द परमेश्वर यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“नीव काळ्लपन माळबाळेतीर, अदिक आबुर-दाबुर देल, कपट माळबाळेतीर, अदिक झुठ माताळबाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","नीव नांद हेसुर इन ख्वाटा कसम तिनकु तान परमेश्वर उन हेसुर अपवित्र ठहरूसबाळेतीर; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“आबुर-दाबुर मा अंधेर माळबाळेतीर, अदिक आबुर-दाबुर इक लुट्‍स बाळेतीर. मजदुर उन मजदुरी नींद हात्ती पुरा ईळ्लक हागुल ईर बाळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","बयरा मंळसा अक सराप कोळ बाळेतीर, अदिक कुढ्ढ मंळसा अन्द मुंद ठोकर ईटबाळेतीर; अदिक तान परमेश्वर उन भय मानसेतीर; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“न्याय दा कुटीलता माळबाळेतीर; अदिक न रा कंगाल उन पक्ष ताकोमेतीर अदिक न धोळ मंळसा अन्द बाय नोळकु विचार माळोद; आबुर-दाबुर्द न्याय धार्मिकता देल माळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","नीव तान लॉकुर न्याड्या दा निंदा माळतेला वयाळबाळेतीर, अदिक आबुर-दाबुर्द रकत वाहुसोद योजनागोळ माळबाळेतीर; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“तान मन दा आबुर दाबुर्द प्रति द्वेष ईटबाळेतीर; गलत माळदुर मा तान मान्ना हातळोर इक अवश्य डाटसेतीर, लेकीन आंदुर्द अपराध दा सहभागी आगबाळेतीर ईला रा आऊन पाप इन भार नीनी नेग्गोद बिद्दीत.” ");
INSERT INTO hoy_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","बदला ताकोमबाळेतीर, अदिक तान लॉकुर अदिक मान्ना हातळोर वार्टुर से दुश्मनी ईट बाळेतीर, लेकीन आबुर-दाबुर से तान घाई प्रेम ईटेतीर; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“नीव नांद विधीगोळ इक हमेशा मानसेतीर. तान जनावरगोळ इक दुसरा जाती इन जनावरगोळ से व्‍हाट्‍यादी आगगोळ बाळेतीर; तान केई दा येढ्ढ प्रकार इन बींजा ऊंद सांगुळ बोऊसगोळ बाळेतीर; अदिक सनी अदिक ऊन इन मिलावट देल माळकु कपळा हाक्क बाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","बाक याकारा आर्त दासी ईरूल, अदिक आकीन सगाई यावारा गंळ्स से आगुल, लेकीन आक न रा दास देल अदिक न स्वतंत्र माळकु आगुल; आकीन से अगर यावारा कुकर्म माळुल, रा आ येढ्ढु मुंदरी दण्ड रा सिक्‍कुल, पर आ आर्त इन स्वाधीन न आगोद कारण आंदुर येढ्ढु मुंदुर कोंदकु आगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","पर आव गंळ्स भेंटमाळोद तम्बू उन द्वार मा यहोवा अन्द हात्ती ऊंद म्यांडा दोषबली इन साटी तरूल. ");
INSERT INTO hoy_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","अदिक याजक आऊन माळ्द पाप इन कारण दोषबली इन म्यांडा अन द्वारा आऊन साटी यहोवा अन्द मुंद प्रायश्चित माळुल; आग आऊन माळ्द पाप क्षमा माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“बाक याग नीव कनान द्याश दा पोहचुस्कु यातोदारा प्रकार इन काय इन मार्र हचेतीर, रा अदुर काय मुर वर्ष ताका नीम्द साटी मान्सी खतनारहित मान्सकु ईरूल; इदुरसाटी अदुर दा टु थ्वाळासा भी तिनकु आगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","अदिक चौथा वर्ष दा अऊर सप्पा काय यहोवा अन्द स्तुति इन भेंट इन रूप दा पवित्र ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","आग पाचवा वर्ष दा नीव अऊर काय तिनेतीर, इदुरसाटी कि अऊर देल नीम इक हापाळ काय सिक्याव; ना नीम्द परमेश्वर यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“नीव रकत हतकु यातोदारा चिच्ची इक तिनबाळेतीर. अदिक टोना माळबाळेतीर, अदिक शुभ अदिक अशुभ मुहुर्तगोळ इक मान्सबाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","तान ताल्ला मा घ्यारा ईटकु मुंडन माळबाळेतीर, अदिक तान गाल्ला माकळव चुट्टीगोळ इक बोळ्सबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","लाशगोळ कारण तान मय इक बिलकुल चिर्सबाळेतीर, अदिक अदुर्दा छाप हचबाळेतीर; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","तान पोरगोळ इक वेश्या माळकु अपवित्र माळबाळेतीर, हिंग ना आगुल कि द्याश वेश्यागमन इन कारण दुष्टता देल तुम्मेगुल. ");
INSERT INTO hoy_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","नांद आराम दिन इक मानसेतीर, अदिक नांद पवित्र जागा अन्द भय हमेशा मानसेतीर; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“इंद्रजालवाळा अदिक भूत इक तुळकाळसावाळा दी होगबाळेतीर, अदिक हिंग मंळसागोळ्द खोज माळकु आंदुर कारण अशुद्ध आगबाळेतीर; ना नीम्द परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“हाळाबाट्ट उन मुंद येदकु नीदरेतीर, अदिक हाळाबाटुर्द आदर मान माळेतीर, अदिक तान परमेश्वर उन भय हमेशा मानसेतीर; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ अगर यावारा परदेशी नीम्द द्याश दा नीम्द सांगुळ ईरूल, रा आऊक सतुसबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","जो देशी या परदेशी नीम्द सांगुळ ईरूल आव नीम्द साटी द्याशवाळा अन्द घाई ईरूल, अदिक आऊन से तान अच घाई प्रेम ईटेतीर; यतिकी नीव भी मिस्त्र द्याश दा परदेशी ईरीर; ना नीम्द परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“नीव न्याय दा, अदिक परिमान दा, अदिक तवल दा, अदिक नाप दा, कुटीलता माळबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","खरा तराजू, खरा बट्ट, खरा एप्पा, अदिक धर्म इन खरा लीटर नीम्द हात्ती ईरूल; ना नीम्द परमेश्वर यहोवा हुईन जो नीम इक मिस्त्र द्याश टु तेगुकु तंदीन. ");
INSERT INTO hoy_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","इदुरसाटी नीव नांद सप्पा विधिगोळ इक अदिक सप्पा न्याय इन नियमगोळ इक मान्सतेला हमेशा पालन माळी; ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इस्राएलिगोळ से अन कि इस्राएलीगोळ दा टु, या इस्राएलीगोळ्द न्याड्या ईरावाळेर परदेशीगोळ दा टु, यावारा यती ईरबाळुल, जो तान यातोदारा औलाद इक मोलेक द्याव उक बलिदान माळुल आव निश्चय कोंदकु आगुल; अदिक जनता आऊन मा कल्लगोळ भिळुल. ");
INSERT INTO hoy_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ना भी आ मंळसा अन्द विरूद्ध आगकु, आऊक आऊन लॉकुर दा टु ई कारण नाश माळाईन, कि आव तान औलाद मोलेक द्याव उक कोटकु नांद पवित्र जागा अक अशुद्ध माळदुन, अदिक नांद पवित्र हेसुर इक अपवित्र ठहरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","अदिक अगर यावारा तान औलाद मोलेक उक बलिदान माळुल, अदिक जनता आऊन बारा दा आनाकानी माळुल, अदिक आऊक कोंनबाळुल, ");
INSERT INTO hoy_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","आग रा ना खुद आ मंळसा अदिक आऊन घराना अन्द विरूद्ध आगकु आऊक अदिक यास मुंदुर आऊन हिंद आगकु मोलेक द्याव उन सांगुळ व्यभिचार माळुल आ सप्पा मुंदरी आंदुर लॉकुर्द न्याड्या दा टु नाश माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“बाक जो मंळसा इंद्रजालवाळा या भूत तुळकाळसावाळा अन्द दी तिर्गकु, अदिक आंदुर हिंद आगकु व्यभिचारी आगुल, आग ना आ मंळसा अन्द विरूद्ध आगकु आऊक आऊन लॉकुर्द न्याड्या दा टु नाश माळ बुळाईन.” ");
INSERT INTO hoy_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","इदुरसाटी नीव तान तान इक पवित्र माळी; अदिक पवित्र बन्सकु ईरी; यतिकी ना नीम्द परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","अदिक नीव नांद विधिगोळ इक मानसेतीर, अदिक अदुर पालन भी माळेतीर; यतिकी ना नीमी पवित्र माळावाळा यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“यावारा यती न ईरबाळुल, जो तान आप्प या मोय इक सराप कोळुल आव निश्चय कोंदकु आगुल; आव तान आप्प या मोय इक सराप कोट्टुन, ई कारण आऊन रकत आऊन ताल्ला मा बिद्दीत.” ");
INSERT INTO hoy_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“बाक अगर यावारा मंळसा दुसरा अन आर्त इन सांगुळ व्यभिचार माळुल, रा याव यावारा दुसरा अन्द आर्त इन सांगुळ व्यभिचार माळीदान रा आव व्यभिचारी अदिक आक व्यभिचारिणी येढ्ढु मुंदुर निश्चित कोंदकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","अगर यावारा तान मोय इन सांगुळ मिंगुल, आव तान आप्प उन ईज्जत उघळुसावाळा ठहरूस्यान; इदुरसाटी आंदुर येढ्ढु मुंदुर निश्चित कोंदकु आगुल, आंदुर खुन आंदुर्दा ताल्ला मा बिद्दीत. ");
INSERT INTO hoy_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","अगर यावारा तान सासा अन्द सांगुळ मिंगुल, रा आंदुर येढ्ढु मुंदुर निश्चित कोंदकु आगुल; यतिकी आंदुर उलटा क्याल्सा माळावाळेर ठहरूस्यार, अदिक आंदुर खुन आंदुर्दा ताल्ला मा बिद्दीत. ");
INSERT INTO hoy_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","अगर यावारा मंळसा यातारा दुसरा मंळसा अन सांगुळ बेकार क्याल्सा माळतान, जसा यातोरारा आर्त इन सांगुळ माळुल, रा आंदुर येढ्ढु घिनौना क्याल्सा माळावाळेर ठहरूस्यार; ई कारण आंदुर निश्चित कोंदकु आगुल, आंदुर खुन आंदुर्दा ताल्ला मा बिद्दीत. ");
INSERT INTO hoy_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","अगर यावारा तान हिंग्स अदिक तान आत्ता अक येढ्ढु मुंदरी ईट्टुल, रा ईद महापाप हुंद; इदुरसाटी आ गंळ्स अदिक आ आर्तेर मुरू चा मुरू मुंदुर बेक्की दा होत्‍ताकु आगुल, अदुर देल नीम्द न्याड्या दा महापाप आगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","बाक अगर यावारा गंळ्स पशु से संबंध माळतीदान, रा गंळ्स अदिक पशु येढ्ढु निश्चित कोंदकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","अगर याकारा आर्त पशु उन हात्ती होगकु अदुर सांगुळ कुकर्म माळुल, रा नी आ आर्त अदिक पशु येढ्ढु उक घात माळेत; आंदुर निश्चित कोंदकु आगुल, आंदुर खुन आंदुर्दा ताल्ला मा बिद्दीत. ");
INSERT INTO hoy_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“अगर यावारा तान आकतींग इक, चाहे आऊन सगा आकतींग ईरूल चाहे सौतेला आकतींग, आकीन ऊगळा मय नोळुल, अदिक आऊन आकतींग भी आऊन ऊगळा मय नोळुल रा ईद नाच्कवाळा मात हुंद, आंदुर येढ्ढु तान जातीनोर वार्टुर्द कण्णगोळ मुंद नाश माळकु आगुल; यतिकी जो तान आकतींग इन मय ऊगुळसावाळा ठहरूस्यान आऊक तान दुष्कर्म अन्द भार खुद नेग्गोद बिद्दीत.” ");
INSERT INTO hoy_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","बाक अगर यावारा गंळ्स याकारा ऋतुमती आर्त इन सांगुळ मिंगकु आकीन मय ऊगुळस्यान, रा आ गंळ्स आकीन रूधिर इन सोता अक ऊगळुसावाळा ठहरूस्यान, अदिक आ आर्त तान रूधिर इन सोता अक ऊगुळ्सावळ्त ठहरूस्यार; ई कारण आंदुर येढ्ढु मुंदुर तान लॉकुर्द न्याड्या दा टु नाश माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","तान मावसी या फुफी इन मय ऊगळुस बाळेतीर, यतिकी जो अदरी ऊगुळस्यान तान हात्तीगोळोर रिश्तेदारगोळ इक नंगा माळतान; इदुरसाटी इंदरी येढ्ढु मुंदरी तान दुष्कर्म अन्द भार नेग्गोद बिद्दीत. ");
INSERT INTO hoy_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","अगर यावारा तान काकी इन सांगुळ मिंगुल, रा आव तान काका अन्द ईज्जत ऊगुळसावाळा ठहरूस्यान; इदुरसाटी आंदुर येढ्ढु मुंदुर तान पाप इन भार इक नेगुतेला निर्वंश सोतोदार. ");
INSERT INTO hoy_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","अगर यावारा तान भाभी इक तान हिंग्स माळुल, रा इदरी घिनौना क्याल्सा जान्सेतीर; अदिक आव तान वार्ट उन ईज्जत ऊगुळसावाळा ठहरूस्यान, ई कारण आंदुर येढ्ढु मुंदुर बिना औलाद देल ईत्तार. ");
INSERT INTO hoy_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“नीव नांद सप्पा विधिगोळ अदिक नांद सप्पा नियमगोळ इक समझ इन सांगुळ मानसेतीर; इदुर देल ईद आगबाळुल कि या द्याश दा ना नीमी ओयेतीन अद नीमी भिट्ट बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","अदिक या राज्य अन लॉकुर इक ना नीम्द मुंद टु तेगुतीन आंदुर्द रीती-रस्म मा नळुबाळेतीर; यतिकी आ लॉकुर जो ईव सप्पा कुकर्म माळदुर, ईदा कारण नानी आंदुर से घृणा आगेग्याद. ");
INSERT INTO hoy_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","पर ना नीव लॉकुर से अनतीन कि नीव रा आंदुर्द भूमि इन अधिकारी आदीर, अदिक ना ई द्याश इक यदुर्दा हाल अदिक शयद इन धारागोळ वाहुसताव नीम्द अधिकार दा माळ बुळाईन; ना नीम्द परमेश्वर यहोवा हुईन याव नीमी अन्य द्याशगोळ्द लॉकुर से अलग माळदुन. ");
INSERT INTO hoy_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ई कारण नीव शुद्ध अदिक अशुद्ध पशुगोळ दा, अदिक शुद्ध अदिक अशुद्ध पक्षिगोळ दा भेद माळोद; अदिक यातोदारा पशु या पक्षी या यातोदारा प्रकार इन भूमी मा रेंगसावाळा जीवजन्तु यती आगबाळुल, यारी ना नीम्द साटी अशुद्ध ठहरूसकु वर्जित माळदीन, अदुर देल खुद इक अशुद्ध माळबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","नीव नान साटी पवित्र बन्सकु ईरेतीर; यतिकी ना यहोवा खुद पवित्र आईन, अदिक ना नीम इक अदिक द्याशगोळ्द लॉकुर से इदुरसाटी अलग माळदीन कि नीव हमेशा नांद अच बन्सकु ईरी. ");
INSERT INTO hoy_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“अगर यावारा गंळ्स या आर्त इंद्रजालवाळा या भूत इन साधना माळुल, रा आव निश्चित कोंदकु आगुल; हिंग मंळसागोळ मा कल्लगोळ भिटकु आगुल, आंदुर खुन आंदुर्दा ताल्ला मा बिद्दीत.” ");
INSERT INTO hoy_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","बाक यहोवा मूसा से अंदुन, “हारून उन पार जो याजक आन आंदुर से अन कि नीम्द लॉकुर दा टु यावारा भी शाईल, रा आऊन कारण नीम दा टु यावारा खुद इक अशुद्ध माळबाळुल; ");
INSERT INTO hoy_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","तान हात्तीनोर कुटुम्बिगोळ इक, मतलब तान मोय, या आप्प, या पार, या पोर, या वार्ट उन साटी, ");
INSERT INTO hoy_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","या तान कुवारा आकतींग आकीन मदा आगीदिल, यार्द हात्ती इन संबंध आद; आंदुर साटी आव तान इक अशुद्ध माळ सकतान. ");
INSERT INTO hoy_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","पर याजक आगोर नाता देल आव तान लॉकुर दा प्रधान आन, इदुरसाटी आव खुद इक हिंग अशुद्ध माळबाळुल कि अपवित्र आगेगुल.” ");
INSERT INTO hoy_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","याजक तान ताल्ला अन्द चुट्टी मुंडन माळबाळुल, अदिक तान गाल्ला अन्द चुट्टी इक भी बोळ्स बाळुल, अदिक तान मय मा घाव माळबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","आंदुर तान परमेश्वर उन साटी पवित्र बन्सकु ईरूल, अदिक तान परमेश्वर उन हेसुर अपवित्र माळबाळुल; यतिकी आंदुर यहोवा अन्द होमबली अक जो आंदुर परमेश्वर उन भोजन हुंद येर्सतार; ई कारण आंदुर पवित्र बन्सकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","याजक पवित्र रीती देल परमेश्वर उन स्यावा माळतान अनकु आव भ्रष्ट आगकु आर्त इक, वेश्या अक, या गांड्ड उक बिटकु आर्त इक तान हिंग्स माळबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","इदुरसाटी नी याजक उक पवित्र जान्सेत, यतिकी आव नीम्द परमेश्वर उक भोजन येर्सतान; इदुरसाटी आव नींद नजर दा पवित्र ठहरूसुल; यतिकी ना यहोवा, जो नीमी पवित्र माळतीन, पवित्र आईन. ");
INSERT INTO hoy_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","अदिक अगर याजक उन पोर वेश्या बन्सकु तान तान इक अपवित्र माळुल, रा आक तान आप्प उक अपवित्र ठहरूस्तार; आकी बेक्की दा होताक्कु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“जो तान वार्टुर दा महायाजक ईरूल, आऊन ताल्ला मा अभिषेक उन याण्णा हाक्कु आगुल, अदिक आऊन पवित्र कपळागोळ इक हाक्‍कोर साटी संस्कार आग्याद, आव तान ताल्ला अन्द चुट्टी बगरूसगोळ बाळुल, अदिक तान कपळागोळ इक हरू बाळुल; ");
INSERT INTO hoy_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","अदिक न आव यातोदारा लोथ इन हात्ती होगुल, अदिक न तान आप्प या मोय इन कारण खुद इक अशुद्ध माळुल; ");
INSERT INTO hoy_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","अदिक आव पवित्र जागा टु व्हार्या भी होळबाळुल, अदिक न तान परमेश्वर उन पवित्र जागा अक अपवित्र ठहरूसुल; यतिकी आव तान परमेश्वर उन अभिषेक उन याण्णारूपी मुकुट धारण माळकु आन; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","अदिक आव कुवारा आर्त इन सांगुळ मदा माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","जो रांड्यागीत, या छोळचिट्टी कोटकु आग्यार आक, या भ्रष्ट, या वेश्या ईरूल, हिंग आर्त से आव मदा माळबाळुल, आव तान अच लॉकुर न्याड्या दा टु यातोदारा कुवारा पोर से मदा माळुल. ");
INSERT INTO hoy_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","अदिक आव तान औलाद इक तान लॉकुर दा अपवित्र माळबाळुल; यतिकी ना आकीक पवित्र माळावाळा यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारून से अन कि नींद वंश इन पीढ़ी-पीढ़ी दा जो यावारा येनारा भी शारीरिक दोष ईरूल आव तान परमेश्वर उन भोजन येरसोर साटी हात्ती बर बाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","यावारा यती ईरबाळुल, यारदा दोष ईरूल, आव हात्ती बरबाळुल, चाहे आव कुढ्ढ ईरूल, चाहे लंगळा, चाहे मुग्ग कुरकु ईरूल, चाहे आऊन येनारा यक्कुल अंग ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","या आऊन काल, या कय लूला ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","या आव कुबळा, या बुटरा ईरूल, या आऊन कण्णगोळ दा दोष ईरूल, या आ मंळसा अक बिळीद दाग या खुजली ईरूल, या आव नपुंसक ईरूल; ");
INSERT INTO hoy_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","हारून याजक उन वंश दा टु यारदारा दा यातोदारा भी शारीरिक दोष ईरूल, आव यहोवा अन्द होमबली येरसोर साटी हात्ती बरबाळुल; आव जो दोषयुक्त आन यागलु भी तान परमेश्वर उक भोजन येरसोर साटी हात्ती बरबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","आव तान परमेश्वर उन पवित्र अदिक अपवित्र येढ्ढु प्रकार इन भोजन इक तिनुल, ");
INSERT INTO hoy_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","लेकीन आऊन दोष इन कारण आव न रा न्याड्यावाळा परदा अन्द बुळ्क बरूल अदिक न वेदी इन हात्ती, इदुर देल हिंग न आगुल कि आव नान पवित्र जागागोळ इक अपवित्र माळुल; यतिकी ना आंदरी पवित्र माळावाळा यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","इदुरसाटी मूसा हारून अदिक आऊन पारगोळ इक तथा सप्पा इस्राएलीगोळ इक ईव मातगोळ अनतेला केळ्सदुन. ");
INSERT INTO hoy_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून अदिक आऊन पारगोळ से अन कि इस्राएलिगोळ्द पवित्र माळ्द वस्तुगोळ से यदरी आंदुर नान साटी पवित्र माळतार अलग ईरूल, अदिक नान पवित्र हेसुर इक अपवित्र माळबाळुल; ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","अदिक आंदुर से अन कि नीम्द पीढ़ी-पीढ़ी दा नीम्द पुरा वंश दा टु जो यावारा तान अशुध्दता अन्द दशा दा आ पवित्र माळ्द वस्तुगोळ्द हात्ती होगुल, यारी इस्राएली यहोवा अन्द साटी पवित्र माळतार, आ मंळसा नान मुंद टु नाश माळकु आदान; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","हारून उन वंश दा टु यावारा यती ईरबाळुल, जो कोढ़ी ईरूल, या आऊन रकत होगतेला ईरूल, आ मंळसा यागासताका शुद्ध आगालुन, आगासताका पवित्र माळ्द वस्तुगोळ दा टु येनारा भी तिनबाळुल. अदिक जो लोथ इन कारण अशुद्ध आग्यान, या आऊन वीर्य स्खलित आग्याद, हिंग मंळसा अक जो यावारा मुटुल, ");
INSERT INTO hoy_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","अदिक जो यावारा यातोदारा हिंग रेंगसावाळा जन्तु उक मुटुल अदुर देल लॉकुर अशुद्ध आग सकतार, इंदुर दा टु यारीकारा मुटुल आऊन दा यातोदारा प्रकार इन अशुद्धता ईरूल जो आऊक भी हत्त सकतद. ");
INSERT INTO hoy_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","रा आ याजक जो इंदुर दा टु यारीकारा मुटुल द्यावगाताका अशुद्ध ठहरूसकु ईरूल, अदिक यागासताका नीर देल मय तोळुकोमालुन, आगासताका पवित्र वस्तुगोळ दा टु येनारा भी तिनबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","आग सूर्य अस्त आगोर मा आव शुद्ध ठहरूस्यान; अदिक आग आव पवित्र वस्तुगोळ दा टु तिन सक्यान, यतिकी आऊन भोजन अदा हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","जो जनावर तान देल सोताद या पशु देल हरूकु आग्याद अदरी तिनकु आव तान तान इक आव अशुद्ध माळबाळुल; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","इदुरसाटी याजक लॉकुर नांद सौप्सकु आग्याद नियमगोळ्द पालन माळुल, हिंग ना आगुल कि आंदुर अवरी अपवित्र माळकु पाप इन भार नेगुल, अदिक इदुर कारण सोतोगुल; ना आंदरी पवित्र माळावाळा यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“पराया कुल इन जन, यातोदारा पवित्र वस्तु उक तिनबाळुल, चाहे आव याजक उन अतिथी ईरूल या मजदुर ईरूल, तो भी आव यातोदारा पवित्र वस्तु तिनबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","अगर याजक यातोवारा दास उक पैस्या कोटकु कोमुल, रा आ दास अदुर दा टु तिन सकतान; अदिक जो याजक उन मान्ना दा पैदा आग्यान आंदुर भी आऊन भोजन दा टु तिनुल. ");
INSERT INTO hoy_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","अदिक अगर याजक उन पोर पराया कुल इन यावारा गंळ्स से मदा आगुल, रा आव भेंट माळ्द पवित्र वस्तुगोळ दा टु तिनबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","अगर याजक उन पोर रांड्यागीत या छोळचिट्टी माळकु ईरूल, अदिक आकीन औलाद ईर बाळुल, अदिक आक तान स्यांण पनी इन अवस्था अन्द रीती इन अनुसार तान आप्प उन मान्ना दा ईरतीदार, रा आक तान आप्प उन भोजन दा टु तिनुल; पर पराया कुल इन यावारा अदुर दा टु तिनबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“अदिक अगर यावारा मंळसा यातोदारा पवित्र वस्तु दा टु येनारा भुल देल तिन कोमुल, रा आव अदुर पाचवा भाग वाळुस्कु अदरी याजक उक तुमकु कोळुल. ");
INSERT INTO hoy_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","आंदुर इस्राएलीगोळ्द पवित्र माळ्द वस्तुगोळ इक, अवरी आंदुर यहोवा अन्द साटी येरसुल, अपवित्र माळबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","आंदुर आंदरी तान पवित्र वस्तुगोळ दा टु तिनस्कु आंदुर से अपराध इन दोष नेगसुसबाळुल; ना आंदरी पवित्र माळावाळा यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून अदिक आऊन पारगोळ से अदिक इस्राएलीगोळ इक समझुसकु अन की इस्राएल इन घराना या इस्राएलीगोळ दा ईरावाळेर परदेशीगोळ दा टु यावारा यती ईरबाळुल, जो मन्नत या स्वेच्छाबलि माळोर साटी यहोवा अक यावारा होमबली येरसुल, ");
INSERT INTO hoy_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","रा तान निमित्त ग्रहण योग्य ठहरूसोर साटी पालस्द पशु दा टु वस्ता या मर्री या म्यांडा दा टु तंदरूस्त नर येर्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","अदुर्दा यातोदारा दोष ईरूल अदरी येर्सबाळेतीर; यतिकी अद नीम्द निमित्त ग्रहण योग्य ठहरूसतीदील. ");
INSERT INTO hoy_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","अदिक जो यावारा पालस्द पशु या म्यांडा-मर्रगोळ दा टु विशेष वस्तु मन्नत माळोर साटी या स्वेच्छाबलि इन साटी यहोवा अक मेल-मिलाप बली येरसुल, रा ग्रहण आगोर साटी अवश्य आद कि आव निर्दोष आगुल, आऊन दा यातोदारा भी दोष ईरबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","जो कुढ्ढ या मय इन मुरकु या लूला ईरूल, अथवा आऊन दा फ्वाळा या पपळी या खुजली ईरूल, हिंग चीजगोळी यहोवा अन्द साटी येर्सबाळेतीर, अवरी होमबली मा यहोवा अन्द साटी बली येर्सबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","यातोदारा वस्ता या म्यांडा या व्हात इन यातोदारा अंग येक्कुल या कम ईरूल अदरी स्वेच्छाबलि इन साटी येर्स सकतीर, लेकीन मन्नत पुरा माळोर साटी अद ग्रहण माळकु आगतीदिल. ");
INSERT INTO hoy_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","यारव अंड दब्सकु या कुचलस्कु या मुरकु या कडुकु ईरूल अवरी यहोवा साटी येर्स बाळेतीर, अदिक तान द्याश दा भी हिंग क्याल्सा माळबाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“बाक ईऊर दा टु यारीकारा अक नीव तान परमेश्वर उन भोजन जानस्कु यावारा परदेशी से हुळकु येर्सबाळेतीर; यतिकी अऊर्दा दोष आद, इदुरसाटी अव नीम्द निमित्त ग्रहण आगतीदिल.” ");
INSERT INTO hoy_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“याग वस्ता या म्यांडा या मर्री पैदा आगुल, रा अद येळ दिन ताका तान मोय इन सांगुळ ईरूल; बाक आठवा दिन टु मुंद अद यहोवा अन्द होमबली येरसोर साटी ग्रहण योग्य ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","चाहे वस्ता, चाहे म्यांडा या मर्री ईरूल, अदरी अदिक अदुर पाड्डा अक ऊंद अच दिन दा बली माळबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","अदिक याग नीव यहोवा अन्द साटी धन्यवाद इन मेल-मिलाप बली येरसीर, रा अदरी ईदा रिती देल माळेतीर यदुर देल अद ग्रहण योग्य ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","अद अदा दिन तिनकु आगुल, अदुर्दा टु येनारा भी व्‍हातुर ताका ईर बाळुल; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“इदुरसाटी नीव नांद आग्यागोळ इक मानसेतीर अदिक पालन माळेतीर; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","अदिक नांद पवित्र हेसुर इक अपवित्र ठहरूसबाळेतीर, यतिकी ना इस्राएलीगोळ्द न्याड्या अवश्य अच पवित्र अच मान्सकु आगाईन; ना नीम्द पवित्र माळावाळा यहोवा हुईन, ");
INSERT INTO hoy_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","जो नीमी इक मिस्त्र द्याश टु तेगुकु तंदान यदुर देल नीम्द परमेश्वर बन्सकु ईराइन; ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएलीगोळ से अन कि यहोवा अन्द हाब्ब अदुर दा नीम इक पवित्र सभा जमा माळोर साटी ठहरूस्कु समय मा प्रचार माळोद बिद्दीत, नांद अव हाब्ब ईव हु.” ");
INSERT INTO hoy_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“आर दिन क्याल्सा धंदा माळकु आगुल, लेकीन येळवा दिन परम आराम इन अदिक पवित्र सभा अन्द दिन हुंद; अदुर दा यातोदारा प्रकार इन क्याल्सा धंदा माळकु आगबाळुल; अद नीम्द सप्पा मान्नागोळ दा यहोवा अन्द आराम दिन ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“बाक यहोवा अन्द पर्व अदुर दा टु ऊंद-ऊंद मंळसा अन्द ठहरूस्द समय दा नीमी पवित्र सभा माळोर साटी प्रचार माळोद बिद्दीत अव ईव हूँ. ");
INSERT INTO hoy_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","पयला तिंगुळ इन चौदावा दिन इक द्यावगा अन्द समय यहोवा अन्द फसह आगतेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","अदिक अदा तिंगुळ इन पन्द्रहवा दिन इक यहोवा अन्द साटी अखमीरी रोट्टी इन पर्व आगतेला ईरूल; अदुर दा नीव येळ दिन ताका अखमीरी रोट्टी तिनतेला ईरेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","अदुर दा टु पयला दिन नीम्द पवित्र सभा आगुल; अदिक आ दिशी कष्ट इन यातोदारा क्याल्सा माळबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","अदिक येळवा दिशी नीव यहोवा अक होमबली येर्सेतीर; अदिक येळवा दिन पवित्र सभा आगुल; आ दिशी कष्ट इन यातोदारा क्याल्सा माळबाळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएलीगोळ से अन कि याग नीव आ द्याश दा प्रवेश माळी यारी यहोवा नीमी कोळतान अदिक अदुर दा टु केई कढी, आग तान-तान हण्ण केई इन पयला उपज इन फसल याजक उन हात्ती तरेतीर; ");
INSERT INTO hoy_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","अदिक आव आ पेंड़ी इक यहोवा अन्द मुंद हालुसुल कि अद नीम्द निमित्त ग्रहण माळकु आगुल; याजक अदरी आराम दिन इन दुसरा दिशी हालुसुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","अदिक या दिशी नीव आ पेंड़ी इक हालुसीर अदा दिशी ऊंद वर्ष इन तंदरूस्त म्यांडा अन्द पाड्डा यहोवा अन्द साटी होमबली येर्सेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","अदिक अदुर सांगुळ अन्नभेट एपा अन्द येढ्ढ हतवा अंश याण्णा हचकु मैदा अन्द ईरूल अद होमबली सुखदायक सुगन्ध इन साटी यहोवा अन्द साटी पेयबली आगुल; अदिक अदुर सांगुळ इन अर्घ हीन भर इन चौथाई भाग अंगुर इन रास्‍सा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","अदिक यागासताका ई चढ़ावा अक नीव तान परमेश्वर उन हात्ती वोयतीदिल, आ दिन ताका व्हाशोद केई दा टु रोट्टी तिनबाळेतीर अदिक सुटकु अन्न अदिक हिवरा लॉम्बा तिनबाळेतीर; ईद नीम्द पीढ़ी-पीढ़ी दा नीम्द पुरा घरानागोळ दा हमेशा अन्द विधी ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“बाक आ आराम दिन इन दुसरा दिन टु, मतलब या दिशी नीव हालुस्कु आगोद भेंट इन फसल इक तरेतीर, आ दिन टु पुरा येळ आराम दिन आळकोमेतीर; ");
INSERT INTO hoy_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","येळवा आराम दिन इन अगला दिन ताका पचास दिन आळेतीर, अदिक पचासवा दिन यहोवा अन्द साटी व्हाशोद अन्नभेट येर्सेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","नीव तान मान्नागोळ दा टु एपा अन येढ्ढ हतवा अंश मैदा अन्द येढ्ढ रोट्टीगोळ इक हालुसोद भेंट इन साटी तरेतीर; अव खमीर इन सांगुळ कासकु आगुल, अदिक यहोवा अन्द साटी पयला फसल ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","अदिक आ रोट्टी इन सांगुळ ऊंद-ऊंद वर्ष इन येळ तंदरूस्त म्यांडा अन्द पाड्डा, अदिक ऊंद पाड्डा, अदिक येढ्ढ म्यांडागोळ येर्सेतीर; आंदुर तान-तान सांगुळ अन्नभेट अदिक अर्घ सांगुळ यहोवा अन्द साटी होमबली इन घाई येर्सकु आगुल, मतलब अव यहोवा अन्द साटी सुखदायक सुगन्ध कोळावाळा बली ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","बाक पापबली इन साटी ऊंद व्हात, अदिक मेलबली इन साटी ऊंद-ऊंद वर्ष इन म्यांडा अन्द पाड्डा येरसुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","आग याजक आंदरी पयला उपज इन रोट्टी सांगुळ यहोवा अन्द मुंद हालुसोद भेंट इन साटी हालुसुल, अदिक ई रोट्टीगोळ्द सांगुळ अव येढ्ढ म्यांडा अन्द पाड्डागोळ भी हालुस्कु आगुल; अव यहोवा अन्द साटी पवित्र, अदिक याजक उन भाग ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","अदिक नीव आ दिशी ईद प्रचार माळेतीर, कि ईंद नाम्द ऊंद पवित्र सभा आदीत; अदिक कष्ट इन यातोदारा क्याल्सा माळबाळेतीर; ईद नीम्द पुरा घराना दा नीम्द पीढ़ी-पीढ़ी दा हमेशा अन्द विधी ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“याग नीव तान द्याश इन केईगोळ कढी, आग तान केई इन क्वानागोळ इक पुरा रीती देल कडु बाळेतीर, अदिक केई दा बिदकु लॉम्बागोळ इक जमा माळबाळेतीर; अदरी गरीब अदिक परदेशीगोळ्द साटी बिटबुळेतीर; ना नीम्द परमेश्वर यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएलीगोळ से अन कि येळवा तिंगुळ इन पयला दिन इक नीम्द साटी खास आराम दिन ईरूल; आ दिन इक याद तोरसोर साटी नरसिंगगोळ ऊयकु आगुल, अदिक ऊंद पवित्र सभा जमा आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","आ दिशी नीव कष्ट इन यातोदारा क्याल्सा माळबाळेतीर, अदिक यहोवा अन्द साटी ऊंद होमबली येर्सेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“अदा येळवा तिंगुळ इन हतवा दिन पाप होचकु ईटोद दिन मान्सकु आगुल; अद नीम्द पवित्र सभा अन्द दिन आदीत, अदिक अदुर दा नीव उपास माळेतीर अदिक यहोवा अन्द होमबली येर्सेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","आ दिशी नीव यातोदु प्रकार इन क्याल्सा धंदा माळबाळेतीर; यतिकी अद पाप होचकु ईटोद दिन नियुक्त माळकु आग्याद अदुर दा नीम्द परमेश्वर यहोवा अन्द मुंद नीम्द पाप होचकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","इदुरसाटी जो मंळसा आ दिशी उपास माळतीदील आव तान लॉकुर दा टु नाश माळकु आदान. ");
INSERT INTO hoy_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","अदिक जो मंळसा आ दिशी यातोदारा प्रकार इन क्याल्सा धंदा माळुल आ मंळसा अक ना आऊन लॉकुर न्याड्या दा नाश माळ बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","नीव यातोदु प्रकार इन क्याल्सा धंदा माळबाळेतीर; ईद नीम्द पीढ़ी-पीढ़ी दा नीम्द घराना दा हमेशा अन्द विधी ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","अद दिन नीम्द साटी विशेष आराम इन ईरूल, अदुर दा नीव उपास माळेतीर; अदिक आ तिंगुळ इन ऊंम्बत दिन इन द्यावगा टु दुसरा द्यावगा ताका तान आराम दिन मान्सतेला ईरेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएलीगोळ से अन कि अदा येळवा तिंगुळ इन पन्द्रहवा दिन टु येळ दिन ताका यहोवा अन्द साटी झोपळीगोळ्द पर्व मान्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पयला दिन पवित्र सभा ईरूल; अदुर दा कष्ट इन यातोदारा क्याल्सा माळबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","येळु दिन यहोवा अन्द साटी होमबली येर्सतेला ईरेतीर, बाक आठवा दिन नीम्द पवित्र सभा आगुल, अदिक यहोवा अन्द साटी होमबली येर्सेतीर; अद महासभा अन्द दिन हुंद, अदिक अदुर दा कष्ट इन यातोदारा क्याल्सा माळबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“यहोवा अन्द ठहरूस्कु आग्याव पर्व ईव अच हूँ, इदुर दा नीव यहोवा अन्द होमबली येर्सेतीर, अदिक अन्नभेट, मेलबली, अदिक पेयबली, हर ऊंद तान-तान ठहरूस्कु आग्याद समय मा येर्सकु आगुल अदिक पवित्र सभा अन्द प्रचार माळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ईव सप्पा देल यक्कुल यहोवा अन्द आराम दिन इक मानसेतीर, अदिक तान भेटगोळ्द, अदिक सप्पा मन्नतगोळ, अदिक खुद इन इच्छा अन्द बलिगोळ इक जो यहोवा अक अर्पण माळेतीर येर्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“बाक येळवा तिंगुळ इन पन्द्रहवा दिन इक, याग नीव केई इन उपज इक जमा माळ बुट्टीर, आग येळ दिन ताका यहोवा अन्द पर्व मानसेतीर; पयला दिन विशेष आराम दिन ईरूल, अदिक येळवा दिशी आराम दिन ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","अदिक पयला दिन नीव वळ्लीद-वळ्लीद मार्रगोळ्द उपज, अदिक खजूर इन डगालगोळ, अदिक डाट मार्रगोळ्द डगालीगोळ, अदिक गांगा दा टु मजनू हेसुर इन मार्र इक हुळकु तान परमेश्वर यहोवा अन्द मुंद येळ दिन ताका आनन्द माळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","प्रति वर्ष येळ दिन ताका यहोवा अन्द साटी पर्व मानसेतीर; ईद नीम्द पीढ़ी-पीढ़ी दा सदा अन्द विधी ठहरूसुल, कि येळवा तिंगुळ दा ईद पर्व मान्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","येळ दिन ताका नीव झोपळीगोळ दा ईरेतीर, मतलब यास जन्म टु इस्राएली आर या देशी परदेशी आंदुर सप्पा अन सप्पा झोपळीगोळ दा ईरूल, ");
INSERT INTO hoy_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","इदुरसाटी कि नीम्द पीढ़ी-पीढ़ी इन लॉकुर ध्यान ईटुल, कि याग यहोवा नाव इस्राएलीगोळ इक मिस्त्र द्याश टु तेगुकु तरोन आग आव आंदरी झोपळीगोळ दा ईटीदुन; ना नीम्द परमेश्वर यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","अदिक मूसा इस्राएलीगोळ इक यहोवा अन्द पर्व अन ठहरूस्कु आग्याद समय अनकु केळ्सदुन. ");
INSERT INTO hoy_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","बाक यहोवा मूसा अक अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ इस्राएलीगोळ इक ईद आग्या कोळ कि नांद हात्ती ऊजुळ कोळोद साटी कय देल कांळ्सकु तेग्द जैतून इन शुद्‍ध याण्णा तरेत, कि दिंग्या हमेशा होततेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","हारून अदरी भेंटमाळोद तम्बू दा, किर्या चिट्टी इन न्याड्यावाळा परदा टु व्हार्या, यहोवा अन्द मुंद हमेशा द्यावगा टु व्हातुर ताका सजुसकु ईट्टुल; ईद नीम्द पीढ़ी-पीढ़ी टु हमेशा अन्द विधी ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","आव दिंग्यागोळ इक व्हान्ना अन्द दीवट मा यहोवा अन्द मुंद हमेशा सजुसकु ईट्टुल. ");
INSERT INTO hoy_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“नी मैदा हुळकु हन्नेळ रोट्टीगोळ कासेत, हर ऊंद रोट्टी दा एपा अन्द येढ्ढ हतवा अंश मैदा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","आग आंदुर येढ्ढ पंगतगोळ माळकु, ऊंद-ऊंद पंगत दा आर-आर रोट्टीगोळ, साफ मेज मा यहोवा अन्द मुंद ईटेत. ");
INSERT INTO hoy_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","अदिक ऊंद-ऊंद पंगत मा शुद्ध लुबान ईटेत कि अद रोट्टी याद तोरसावाळा वस्तु अदिक यहोवा अन्द साटी होमबली ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","हर ऊंद आराम दिन इक आव अदरी हमेशा यहोवा अन्द मुंद लाईन देल ईट्टुल, ईद सदा अन्द वादा अन्द रीती इस्राएलीगोळ दी टु आगतेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","अदिक अद हारून अदिक आऊन पारगोळ्द आदीत, अदिक आंदुर रोट्टी यातोदारा पवित्र जागा दा तिनुल, यतिकी अद यहोवा अन्द होमबली दा टु हमेशा अन्द विधी इन अनुसार हारून उन साटी शुद्ध पवित्र वस्तु ठहरूसकु आद.” ");
INSERT INTO hoy_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","आ दिनगोळ दा याकारा इस्राएली आर्त इन पार, आऊन आप्प मिस्त्र दा ईरावाळा गंळ्स ईरोन, इस्राएलिगोळ्द न्याड्या होटोदुन; अदिक आव इस्राएली आर्त इन पार अदिक ऊंद इस्राएली गंळ्स छावनी इन न्याड्या आपस दा मार पीट माळली कुरतुर, ");
INSERT INTO hoy_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","अदिक आव इस्राएली आर्त इन पार यहोवा अन्द हेसुर इन निन्दा माळकु सराप कोळली कुरतुन. ईद केळकु लॉकुर आऊक मूसा अन्द हात्ती ओतुर. आऊन मोय इन हेसुर शलोमीत ईरोद, जो दान इन गोत्र अन्द दिब्री इन पोर ईरोर. ");
INSERT INTO hoy_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","आंदुर आऊक तान देखभाल दा ईटदुर, यदुर देल यहोवा अन मन आंदुर मा प्रगट आग सकुल. ");
INSERT INTO hoy_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","आग यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“नीव लॉकुर आ सराप कोळावाळा मंळसा अक छावनी टु व्हार्या वोई; अदिक यास मुंदुर आ निन्दा केळदुर आंदुर सप्पा तान-तान कय आऊन ताल्ला मा ईटी, आग पुरा मंडली इन लॉकुर आऊन मा कल्लगोळ भीळी. ");
INSERT INTO hoy_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","अदिक नी इस्राएलीगोळ से अन कि यावारा यती ईर बाळुल, जो तान परमेश्वर उक सराप कोळुल आऊक तान पाप इन भार नेगोद बिद्दीत. ");
INSERT INTO hoy_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","यहोवा अन्द हेसुर इन निन्दा माळावाळा निश्चित रूप देल कोंदकु आगुल; पुरा मंडली इन लॉकुर निश्चित रूप देल आऊन मा कल्लगोळ बडुल; चाहे द्याश इन मंळसा ईरूल या परदेशी, अगर यावारा यहोवा अन्द हेसुर इन निन्दा माळुल रा आव कोंदकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“बाक जो यावारा याऊ मंळसा अक जान देल कोनुल आव निश्चित रूप देल कोंदकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","अदिक जो यावारा यारदु मान्नागोळ्द पशु उक जान देल कोनुल आव अदुर भरपाई माळुल, मतलब प्राणी इन बदला प्राणी कोळुल. ");
INSERT INTO hoy_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“बाक अगर यावारा दुसरा मंळसा अक दुख पोहचुसुल, रा जसा आव माळदुन हांग अच आऊन सांगुळ भी माळकु आगुल, ");
INSERT INTO hoy_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","मतलब येलु मुरदुर बदला दा येलु मुरूल, कण्ण इन बदला कण्ण, हल्ल इन बदला हल्ल, जसा दुख आ मंळसा दुसरा अक कोट्टुन हांग अच आंदरी भी कोटकु आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","पशु उक कोन्नावाळेर अदुर भरपाई कोळुल, लेकीन मंळसा अक कोनावाळा अक निश्‍चय कोंदकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","नीम्द नियम ऊंद अच ईरूल, जसा द्याश इन लॉकुर साटी हांग अच परदेशी लॉकुर साटी भी ईरूल; ना नीम्द परमेश्वर यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","बाक मूसा इस्राएलीगोळ इक ईद समझुसदुन; आग आंदुर आ सराप कोळावाळा अक छावनी टु व्हार्या वोतकु आऊन मा कल्लगोळ भिट्टुर. अदिक इस्राएलीगोळ हांग अच माळदुर ह्यांग यहोवा मूसा अक आग्या कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","बाक यहोवा सीनै पर्वत इन हात्ती मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएलीगोळ से अन कि याग नीव आ द्याश दा प्रवेश माळी जो ना नीमी कोळतीन, आग भूमी इक यहोवा अन्द साटी आराम सिकतेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","आर वर्ष रा तान-तान केई बोऊसी, अदिक आर वर्ष तान-तान अंगुर इन बेली इक छाट-छाटस्कु केई इन उपज जमा माळेतीर; ");
INSERT INTO hoy_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","लेकीन येळवा वर्ष भूमि अक यहोवा अन्द साटी वळ्लीद आराम घळी सिकतेला ईरूल; अदुर दा न रा तान केई बोऊसोद अदिक न तान अंगुर इन बेली छाटसोद. ");
INSERT INTO hoy_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","जो येनारा कळकु केई दा खुद देल बेळुल अदरी कळुबाळेतीर, अदिक तान बिना छाट्स्द अंगुर इन एल इक अंगुरगोळ इक कोय बाळेतीर; यतिकी अद भूमी इन साटी वळ्लीद आराम इन वर्ष आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","भूमी इन आराम घळी इन उपज देल नीम इक, अदिक नीम्द दास-दासी इक, अदिक नीम्द सांगुळ ईरावाळेर मजदूरगोळी अदिक परदेशीगोळ इक भी ऊमोद सिक्कीत; ");
INSERT INTO hoy_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","अदिक नीम्द पशुगोळ इक अदिक द्याश दा यास जीवजन्तु आव अऊर भी ऊमोद भूमी इन सप्पा उपज देल आदीत.” ");
INSERT INTO hoy_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“येळ आराम वर्ष, मतलब येळ गुणा येळ वर्ष आळेतीर, येळु आराम वर्षगोळ्द ईद समय उनपचास वर्ष आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","आग येळवा तिंगुळ अन्द हतवा दिन इक, मतलब प्रायश्चित इन दिन, जय-जयकार इन महाशब्द इन नरसिंगा तान पुरा द्याश दा सप्पा जागा मा भी ऊयसुसेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","अदिक आ पचासवा वर्ष इक पवित्र माळकु मानसेतीर, अदिक द्याश इन पुरा निवासीगोळ्द साटी छुटकारा अन्द प्रचार माळेतीर; अद वर्ष नीम साटी आजादी प्राप्ति इन वर्ष अनकु आगुल; अदुर दा नीम तान-तान खुद इन जागा अदिक तान-तान घराना दा वापस होगेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","नीम्द अल अद पचासवा वर्ष आजादी प्राप्ति इन वर्ष कहलुसीत; अदुर दा नीव न बोऊसेतीर, अदिक जो तान ताना बेळीत अदरी भी कडु बाळेतीर, अदिक न बिना छाट्स्द अंगुर इन एल इक मुरूबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","यतिकी अद रा आजादी प्राप्ति इन वर्ष आदीत; अद नीम्द साटी पवित्र आदीत; नीव अदुर उपज केई दा टु उच ताकोम ताकोमकु तिनेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ई आजादी प्राप्ति इन वर्ष दा नीव तान-तान खुद इन जागा दा वापस बंदीर.” ");
INSERT INTO hoy_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","अदिक अगर नीव तान वार्टुर कय देल येनारा मारीर या तान वार्टुर से येनारा कोंडीर, रा नीव आबुर दाबुर मा अन्याय माळबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","आजादी प्राप्ति इन वर्ष इन बाद्दा यास वर्ष बितुस्याव अऊर गिनती इन अनुसार किंमत ठहरूसकु आबुर दाबुर से कोंड कोमेतीर, अदिक मिग्द वर्षगोळ्द उपज इन अनुसार आव नीन कय दा मारूल. ");
INSERT INTO hoy_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","याट वर्ष मात्त ईरूल आट अच किंमत वाळुसेतीर, अदिक यास वर्ष कम ईरूल आट अच किंमत घटुसुल, यतिकी वर्ष इन उपज इन संख्या याट ईरूल आट अच आव नीन कय दा मार्यान. ");
INSERT INTO hoy_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","नीव तान-तान वार्टुर मा अन्याय माळबाळेतीर; तान परमेश्वर उन अंज्क मानसेतीर; ना नीम्द परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“इदुरसाटी नीव नांद विधीगोळ इक मानसेतीर, अदिक नान नियमगोळ मा समझ बुझुस्कु नळेतीर; यतिकी हिंग माळदुर देल नीव आ द्याश दा निडर कुर्तकु ईत्तीर. ");
INSERT INTO hoy_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","भूमी तान उपज उपजुसतेला ईत्तीत, अदिक नीव व्हाट्टतीम तिनतेला ईत्तीर, अदिक आ द्याश दा निडर कुर्तकु ईत्तीर.” ");
INSERT INTO hoy_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","अदिक अगर नीव अनी कि येळवा वर्ष दा नाव येन तिनदेव, “न रा नाव बोऊसेव न तान केई इन उपज जमा माळेव?” ");
INSERT INTO hoy_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","रा जान्सी कि ना नीम इक छठवा वर्ष दा हिंग आशीष कोळाईन, कि भूमि इन उपज मुर वर्ष ताका क्याल्सा दा बंदीत. ");
INSERT INTO hoy_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","नीव आठवा वर्ष दा बोऊसेतीर, अदिक हाळोद उपज दा टु तिनतेला ईत्तीर, अदिक ऊम्बत वर्ष इन उपज यागासताका सिकतीदील आगासताका नीव हाळोद उपज दा टु तिनतेला ईत्तीर. ");
INSERT INTO hoy_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“जागा हमेशा अन्द साटी मारकु आगबाळुल, यतिकी जागा नांद हुन; अदिक अदुर दा नीव परदेशी अदिक व्हार्या नोर लॉकुर ईत्तीर.” ");
INSERT INTO hoy_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","लेकीन नीव तान भाग इन पुरा द्याश दा जागा अक बिळ्स गोळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“अगर नींद यावारा वार्टबन्धु कंगाल आगकु तान खुद इन जागा दा टु येनारा मारबुळुल, रा आऊन परिवार दा टु जो सबसे हात्ती आन आव बंदकु तान वार्टबन्धु उन मार्द भाग इक बिळ्स कोमुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","अगर यावारा मंळसा अन्द साटी याऊ बिळसावाळा ईला ईरूल, अदिक आऊन हात्ती ईट धन ईरूल कि खुद अच तान भाग इक बिळ्स सकुल, ");
INSERT INTO hoy_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","रा आव अदुर मार्द समय टु वर्षगोळ आळुकु मिक्कु वर्षगोळ्द उपज इन किंमत आऊक, याव अदुर्द किंमत कोटकु कोंडुन, वापस माळ बुळुल; आग आव तान खुद इन जागा अन्द अधिकारी आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","लेकीन अगर आऊन हात्ती ईट पूंजी ईला ईरूल कि अदरी बाक तान माळ सकुल, रा आऊन मार्द जागा आजादी प्राप्ति इन वर्ष ताका कोमावाळा अन्द कय दा ईरूल; अदिक आजादी प्राप्ति इन वर्ष दा बिट्टोगुल आग आव मंळसा तान खुद इन जागा अन्द मात्त अधिकारी आगेदान.” ");
INSERT INTO hoy_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“बाक अगर यावारा मंळसा शहरपनाहवाळा नगर दा कुर्तकु मान्ना मारूल, रा अद मारदुर बाद्दा साल भर इन अंदर अदरी बिळ्स सक्यान, मतलब पुरा साल तीम आ मंळसा अक बिळसोद अधिकार ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","लेकीन अगर आव साल तिमुर दा बीळ्सतीदिल, रा अद मान्ना जो शहरपनाहवाळा नगर दा ईरूल कोमावाळा अन्द बन्सकु ईरूल, अदिक पीढ़ी-पीढ़ी दा आऊंदा औलाद इन माळकु ईरूल; अदिक आजादी प्राप्ति इन वर्ष इन साल दा भी बिळ्सकु आग बाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","लेकीन बिना शहरपनाह अन्द ऊरगोळ्द मान्ना रा द्याश इन केईगोळ्द भाग इन घाई आळकु आगुल; आंदुर्द बिळ्सकु भी आगेदीत, अदिक आंदुर आजादी प्राप्ति इन वर्ष इन साल दा बिटोदार.” ");
INSERT INTO hoy_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","फिर भी लेवीगोळ्द खुद इन भाग इन नगरगोळ्द जो मान्ना ईरूल आंदरी लेवीगोळ याग चाहसुल आग बिळसुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","अदिक अगर यावारा लेवी तान भाग ईला बिळस्यान, रा अद मार्द मान्ना जो आऊन भाग इन नगरगोळ दा ईरूल आजादी प्राप्ति इन वर्ष इन साल दा बिळ्सकु आगुल; यतिकी इस्राएलीगोळ्द न्याड्या लेवीगोळ्द भाग आंदुर नगरगोळ दा अव मान्नागोळ अच हूँ. ");
INSERT INTO hoy_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","लेकीन आंदुर नगरगोळ्द नाकु दी चराई इन भूमी मारकु आग बाळुल; यतिकी अद आंदुर हमेशा अन्द भाग आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“बाक अगर नीन यावारा वार्टबन्धु कंगाल आगेगुल, अदिक आऊन दश्या नींद मुंद तरस तिना योग्य आगेगुल, रा नी आऊक संभालसेत; आव परदेशी या वार्ट उन घाई नींद सांगुळ ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","आऊन से ब्याज या बळोतरी ताकोमबाळेत; तान परमेश्वर उन अंज्क मानसेतीर; अदुर देल नीन वार्टबन्धु नीन सांगुळ जीवन निर्वाह माळ सकुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","आऊक ब्याज मा पैस्या कोळबाळेत, अदिक आऊक ऊमोद वस्तु लाभ इन लालच देल कोळबाळेत. ");
INSERT INTO hoy_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ना नीम्द परमेश्वर यहोवा हुईन; ना नीमी कनान द्याश कोळोर साटी अदिक नीम्द परमेश्वर ठहरूसोद मनसा देल नीम इक मिस्त्र द्याश टु तेगुकु तंदीन.” ");
INSERT INTO hoy_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“बाक अगर नींद यावारा वार्टबन्धु नीन मुंद कंगाल आगकु तान-तान इक नीन कय दा मार्र बुळुल, रा आऊन से दास उन घाई स्यावा माळसुसबाळेत. ");
INSERT INTO hoy_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","आंदुर नीन सांगुळ मजदुर या यात्री इन घाई ईरूल, अदिक आजादी प्राप्ति इन वर्ष ताका नीन सांगुळ ईतकु स्यावा माळतेला ईरूल; ");
INSERT INTO hoy_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","आग आंदुर बाल-बच्यागोळ सांगुळ नीन हात्ती टु होटबुळुल, अदिक तान परिवार दा अदिक तान आप्प उन मुतीगोळ्द खुद इन जागा दा वापस होट बरूल. ");
INSERT INTO hoy_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","यतिकी आंदुर नान अच दास उर, आंदरी ना मिस्त्र द्याश टु तेगुकु तंदिदीन; इदुरसाटी आंदुर दास इन रीती देल मारकु आगबाळुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","आऊन मा कठोरता देल अधिकार माळबाळेतीर; तान परमेश्वर उन अंज्क मान्सतेला ईरेतीर.” ");
INSERT INTO hoy_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","नीन जो दास-दासीगोळ ईरूल आंदुर नीम्द नाकु दीकळोर राज्यगोळ दा टु ईरूल, अदिक दास अदिक दासीगोळ आंदुर दा टु उच कोमेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","जो यात्री लॉकुर नीम्द न्याड्या दा परदेशी आगकु ईत्तार, आंदुर दा टु अदिक आंदुर घराना दा टु भी जो नीम्द आस-पास ईरूल, अदिक जो नीम्द द्याश दा पैदा आग्यार, आंदुर दा टु नीव दास अदिक दासीगोळी कोंडकोमी; अदिक आंदुर नीम्द भाग ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","नीव तान पारगोळ इक भी जो नीम्द बाद्दा आदार आंदरी अधिकारी माळ सकीर, अदिक आंदुर अदुर भाग ठहरूसुल; अऊर दा टु नीव सदा तान साटी दास ताकोमेतीर, लेकीन नीम्द वार्टगोळ जो इस्राएली आर आंदुर मा तान अधिकार कठोरता देल जतुसबाळेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“बाक अगर नींद मुंद यावारा परदेशी या यात्री धनी आगेगुल, अदिक आऊन मुंद नीन वार्ट कंगाल आगकु तान खुद इक नींद मुंद आ परदेशी या यात्री या आऊन वंश इन कय दा मार्र बुळुल, ");
INSERT INTO hoy_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","रा आऊन भाग मारकु आगोद बाद्दा आव बाक बिळ्सकु आग सकतान; आऊन वार्टुर दा टु यावारा आऊक बिळ्स सकतान, ");
INSERT INTO hoy_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","या आऊन काका, या काका अन्द पार, अदिक आऊन कुल इन यावारा भी हातीगोळोव परीवारवाळा आऊक बिळ्स सकतान; या अगर आव धनी आगेदान, रा आव खुद अच तान इक बिळ्स सकतान. ");
INSERT INTO hoy_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","आव तान किंमत कोळावाळा अन्द सांगुळ तान मारोद वर्ष टु आजादी प्राप्ति इन वर्ष ताका हिसाब माळुल, अदिक आऊन मारोद किंमत वर्षगोळ्द गिनती इन अनुसार आगुल, मतलब अद किंमत मजदुर उन दिनगोळ घाई आऊन सांगुळ आदीत. ");
INSERT INTO hoy_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","अगर आजादी प्राप्ति इन वर्ष इन हापाळ वर्ष ईतोगुल, रा यास पैस्यागोळ देल अद कोंडकु आग्याद अदुर दा टु आव तान बिळसोद किंमत आट अच वर्ष इन अनुसार लौटुस बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","अगर आजादी प्राप्ति इन वर्ष इन थ्वाळासा वर्ष ईतोगुल, तो भी आव तान स्वामी इन सांगुळ हिसाब माळकु तान बिळसोद किंमत आट अच वर्ष इन अनुसार लौटुस बुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","आंदुर तान स्वामी इन सांगुळ आ मजदुर उन घाई ईरूल आऊन हार्दिक मजदुरी ठहरूसकु आगतद; अदिक आऊन स्वामी आऊन मा नींद मुंद कठोरता देल अधिकार जतुसबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","अदिक अगर आंदुर ई रीतिगोळ देल बिळ्सकु आगतीदिल, रा आंदुर आजादी प्राप्ति इन वर्ष दा तान बाल-बच्या सांगुळ बिळस्कु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","यतिकी इस्राएली नांद अच दासगोळ उर; आंदुर मिस्त्र द्याश टु नांद अच तेग्द दास उर; ना नीम्द परमेश्वर यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“नीव तान साटी मुरती माळबाळी, अदिक न यातोदारा अगुळ्द मूर्ति या खंबा तान साटी निदरूसेतीर, अदिक न तान द्याश दा प्रणाम माळोर साटी नक्काशीदार कल्ल स्थापित माळेतीर; यतिकी ना नीम्द परमेश्वर यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","नीव नांद आराम दिनगोळ्द पालन माळेतीर अदिक नांद पवित्र जागा अन्द अंज्क माळी; ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“अगर नीव नांद विधीगोळ मा नळी अदिक नांद आग्यागोळी मान्सकु पालन माळी, ");
INSERT INTO hoy_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","रा ना नीम्द साटी समय-समय मा माळ बरसुसाईन, बाक भूमी तान उपज पैदा माळीत, अदिक केई इन मार्रगोळ तान-तान काय कोट्टाव; ");
INSERT INTO hoy_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ईल ताका कि नीव अंगुर मुरा समय भी दावनी माळतेला ईत्तीर, अदिक बोऊसा समय भी व्हाट्टा तीम अंगुर मुरूतेला ईत्तीर, अदिक नीव मनमानी रोट्टीगोळ तिनतेला ईत्तीर, अदिक तान द्याश दा निडर कुर्तकु ईत्तीर.” ");
INSERT INTO hoy_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","अदिक ना नीम्द द्याश दा सुख चैन कोळाईन, अदिक नीव मिंगेतीर अदिक नीमी यावारा अंजुसावाळा ईरतीदील; अदिक ना आ द्याश दा खतरनाक प्राणीगोळ इक ईरगोळालीन, अदिक तलवार नीम्द द्याश दा नळ्सगोळालीन. ");
INSERT INTO hoy_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","अदिक नीव तान दुश्मनगोळी इक बडुकु तुळकाळसेतीर, अदिक आंदुर नीम्द तलवार देल कोंदकु आदार. ");
INSERT INTO hoy_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","नीम दा टु अईद मंळसा सव मुंदरी अदिक सव मंळसा हत्त हजार मंळसागोळी खदाळस्यार; अदिक नीम्द दुश्मन तलवार देल नीम्द मुंद-मुंद कोंदकु आदार; ");
INSERT INTO hoy_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","अदिक ना नीम्द दी कृपादृष्टी ईटाईन अदिक नीमी फलवन्त माळाईन अदिक वाळुसाईन, अदिक नीम्द सांगुळ तान वादा अक पुरा माळाईन. ");
INSERT INTO hoy_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","अदिक नीव ईटकु हाळोद अनाज इक तिंदीर, अदिक व्‍हाशोद ईत्तीत तो भी हाळोद अनाज इक तेगदीर. ");
INSERT INTO hoy_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","अदिक ना नीम्द न्याड्या तान ईरोद जागा माळकु ईट्टाइन, अदिक नांद जीव नीम से घृणा माळतीदील. ");
INSERT INTO hoy_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","अदिक ना नीम्द न्याड्या नळाईन वयाळाईन, अदिक नीम्द परमेश्वर बन्सकु ईराइन, अदिक नीव नांद प्रजा बन्सकु ईरेतीर. ");
INSERT INTO hoy_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ना रा नीम्द आ परमेश्वर यहोवा हुईन, जो नीम इक मिस्र द्याश टु इदुरसाटी तेगुकु तंदीन कि नीव मिस्त्रगोळ्द दास बन्सकु ईरबाळेतीर; अदिक ना नीम्द जुआळी इक मुरू बुट्टीन, अदिक नीमी सीधा निदरूसकु नळ्सदीन. ");
INSERT INTO hoy_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“अगर नीव नांद केळतीदिल, अदिक इव सप्पा आग्यागोळ इक ईला मानसीर, ");
INSERT INTO hoy_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","अदिक नांद विधिगोळ इक निकम्मा जान्सीर, अदिक नीम्द आत्मा नांद निर्णयगोळ देल घृणा माळुल, अदिक नीव नांद सप्पा आग्यागोळ्द पालन माळतीदील, बल्की नांद वादा अक मुरदिर, ");
INSERT INTO hoy_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","रा ना नीम से ईद माळाईन; मतलब ना नीमी इक बेचैन माळाईन, अदिक क्षयरोग अदिक मय देल पीड़ित माळाईन, अदिक ईऊर कारण नीम्द कण्णगोळ धुंधला आगेदव, अदिक नीम्द मन अति उदास आदीत. अदिक नीम्द बींजा बोऊसोद व्यर्थ आदीत, यतिकी नीम्द दुश्मन आऊन उपज तिन कोंडार; ");
INSERT INTO hoy_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","अदिक ना भी नीम्द विरूद्ध आगेगाईन, अदिक नीव तान दुश्मनगोळ देल हारूसेदीर; अदिक नीम्द दुश्मन नीम्द म्याकुच अधिकार माळ्यार, अदिक याग यावारा नीम इक खदळुसतीदिल तो भी नीव ओळीर.” ");
INSERT INTO hoy_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","अदिक अगर नीव ईव मातगोळ्द म्याकुच भी नांद केळबाळेतीर, रा ना नीम्द पापगोळ्द कारण नीमी येळ गुणा सजा मात्त कोळाईन, ");
INSERT INTO hoy_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","अदिक ना नीम्द बल इन घमण्ड मुरूबुळाईन, अदिक नीम्द साटी आकाश इक मान्सी ल्वाहा अन्द अदिक भूमी इक मान्सी पीतल इन माळ बुळाईन; ");
INSERT INTO hoy_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","अदिक नीम्द बल अकारथ गऊसकु आदीत, यतिकी नीम्द केई तान उपज पैदा माळतीदील, अदिक भूमि इन मार्रगोळ तान काय कोळतीदील. ");
INSERT INTO hoy_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“अगर नीव नांद विरूद्ध नळुतेला अच ईत्तीर, अदिक नांद कहना मान्सतीदील, रा ना नीम्द पापगोळ्द अनुसार नीम्द म्याकुच अदिक येळ गुणा संकट हाकाईन. ");
INSERT INTO hoy_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","अदिक ना नीम्द न्याड्या आळी दाकळोव पशु कळाईन, जो नीम इक बिना चिकोर्द माळबुट्टार, अदिक नीम्द घरेलु पशुगोळ इक नाश माळ बुट्टार, अदिक नीम्द गिनती घटुस्यार, यदुर देल नीम्द सळकगोळ सूना आगेदव.” ");
INSERT INTO hoy_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“बाक अगर नीव ई मातगोळ मा भी नांद ताळना देल ईला सुधुरसीर, अदिक नांद विरूद्ध नळुतेला अच ईत्तीर, ");
INSERT INTO hoy_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","रा ना भी नीम्द विरूद्ध नळाईन, अदिक नीम्द पापगोळ्द कारण ना खुद अच नीम इक येळ गुणा दंड कोळाईन. ");
INSERT INTO hoy_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","अदिक ना नीम मा ऊंद हिंग तलवार नळसुसाईन, जो वादा मुरोद पुरा-पुरा बदला ताकोमीत; अदिक याग नीव तान नगरगोळ दा होग होगकु जमा आदीर आग ना नीम्द न्याड्या मरी फैलुसाईन, अदिक नीमी तान दुश्मनगोळ्द कय दा सौप्स बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","याग ना नीम्द साटी अनाज इन आधार इक बंद माळ बुळाईन, आग हत्त आर्तेर नीम्द रोट्टी ऊंद अच तंदुर दा कासकु तौलुस तौलुसकु वाटस्यार; अदिक नीव तिनकु भी तृप्त आगतीदिल.” ");
INSERT INTO hoy_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“बाक अगर नीव इदुर म्याकुच भी नांद केळतीदिल, अदिक नांद विरूद्ध नळुतेला अच ईत्तीर, ");
INSERT INTO hoy_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","रा ना तान न्याय दा नीम्द विरूद्ध नळाईन, अदिक नीम्द पापगोळ्द कारण नीम इक येळ गुणा दंड यक्कुल भी कोळाईन. ");
INSERT INTO hoy_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","अदिक नीम इक तान पार अदिक पोरगोळ्द चिच्ची तिनोद बिद्दीत. ");
INSERT INTO hoy_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","अदिक ना नीम्द पूजा अन्द ऊँचा जागा अक नष्ट माळाईन, अदिक नीम्द सुगंधित धूप वेदी इक मुरू बुळाईन, अदिक नीम्द लोथगोळ्द नीम्द मुरूकु मुर्तीगोळ मा भीळ बुळाईन; अदिक नांद आत्मा अक नीम से घृणा आगेदीत. ");
INSERT INTO hoy_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","अदिक ना नीम्द नगरगोळ इक ऊजळुस बुळाईन, अदिक नीम्द पवित्र जागा अक ऊजळुस बुळाईन, अदिक नीम्द सुखदायक सुगन्ध ग्रहण माळालीन. ");
INSERT INTO hoy_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","अदिक ना नीम्द द्याश इक सूना माळ बुळाईन, अदिक नीम्द दुश्मन जो अदुर दा ईरतार आंदुर ई मातगोळ्द कारण चकित ईत्तार. ");
INSERT INTO hoy_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","अदिक ना नीमी द्याश-द्याश इन न्याड्या तितर-बितर माळाईन, अदिक नीम्द हिंद-हिंद तलवार जेडुकु ईराइन; अदिक नीम्द द्याश सूना आगेदीत, अदिक नीम्द नगर ऊजळुसेदाव.” ");
INSERT INTO hoy_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“आग यास दिन अद द्याश सूना बिदकु ईत्तीत अदिक नीव तान दुश्मनगोळ द्याश दा ईरेतीर आस दिन आव तान आराम दिनगोळ इक मान्सतेला ईत्तान. आग अच अद द्याश इक आराम सिक्कीत, मतलब तान आराम दिनगोळ इक मान्सतेला ईत्तान. ");
INSERT INTO hoy_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","यास दिन अद सूना बिदकु ईत्तीत आस दिन अदरी आराम ईत्तीत, मतलब जो आराम अदरी नीम्द अल कुर्तकु ईरोद समय नीम्द आराम दिनगोळ दा सिक्कीदील अद अदरी आग सिक्कीत.” ");
INSERT INTO hoy_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","अदिक नीम दा टु जो वाचुसकु ईत्तार अदिक तान दुश्मनगोळ्द द्याश दा ईत्तार आंदुर दिल दा ना निराशा पैदा माळाईन; अदिक आंदुर याल्ला अन्द मुरदुर देल भी वोळ्यार, अदिक आंदुर हिंग वोळ्यार ह्यांग यावारा तलवार देल ओळतान, अदिक यावारा बिना पीछा माळकु भी आंदुर बिदोदार. ");
INSERT INTO hoy_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","याग यावारा पीछा माळावाळा ईरबाळुल आग भी मान्सी तलवार इन अंज्क देल आंदुर आबुर दाबुर देल ठ्वाकरा तिनकु बीळतेला होदार, अदिक नीम इक तान दुश्मनगोळ्द मुंद ठहरूसोद येनारा शक्ती ईरतीदील. ");
INSERT INTO hoy_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","आग नीव द्याश-द्याश इन न्याड्या दा पोहचुस्कु नाश आगेदीर, अदिक नीम्द दुश्मनगोळ्द भूमी नीम इक तिंद बुट्टीत. ");
INSERT INTO hoy_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","अदिक नीम दा टु जो वाचुसकु ईत्तार आंदुर तान दुश्मनगोळ्द द्याशगोळ दा तान दुष्कर्म इन कारण गलुस्यार; अदिक तान आप्प उन मुतीगोळ्द दुष्कर्म इन क्याल्सागोळ्द कारण भी आंदुर आंदुर्दा घाई गलुसेदार. ");
INSERT INTO hoy_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“पर अगर आंदुर तान अदिक तान आप्प उन मुतीगोळ्द दुष्कर्म इक मान्स कोंडार, कि नाव यहोवा अन्द विरूद्ध नळदेव, ");
INSERT INTO hoy_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ईदा कारण आव नाम्द विरूद्ध आगकु नामी दुश्मनगोळ्द द्याश दा तंदुन. अगर आ समय आऊन खतनारहित दिल दबुसीत अदिक आंदुर आ समय तान दुष्कर्म इन दण्ड इक अंगीकार माळ्यार; ");
INSERT INTO hoy_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","आग जो वादा ना याकूब उन सांगुळ कटीदिन अदरी ना याद माळाईन, अदिक जो वादा ना इसहाक देल अदिक जो वादा ना अब्राहम देल कटीदुन अवरी भी याद माळाईन, अदिक आ द्याश इक भी ना याद माळाईन. ");
INSERT INTO hoy_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","लेकीन अद द्याश आंदुर बिना सूना बिदकु ईत्तीत, अदिक अऊर बिना सूना ईतकु भी तान आराम दिनगोळ इक मान्सतेला ईत्तान; अदिक आ लॉकुर तान दुष्कर्म इक अंगीकार माळ्यार, ईदा कारण देल कि आंदुर नांद आग्यागोळ्द उल्लंघन माळीदुर, अदिक आंदुर आत्मागोळ इक नांद विधीगोळ देल घृणा ईरोद. ");
INSERT INTO hoy_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ईटुर मा भी याग आंदुर तान दुश्मनगोळ द्याश दा ईत्तार, आग ना आंदरी ई प्रकार देल बिळालीन, अदिक न आंदुर से हिंग घृणा माळाईन कि आंदुर सर्वनाश माळ बुळुल अदिक तान आ वादा अक मुरू बुळाईन जो ना आंदुर से कटीदिन; यतिकी ना आंदुर यहोवा परमेश्वर हुईन; ");
INSERT INTO hoy_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","लेकीन ना आंदुर भलाई इन साटी आंदुर आप्प उन मुतीगोळ देल कटकु वादा अक याद माळाईन, यारी ना दुसरा राज्य अन्द लॉकुर्द कण्णगोळ्द मुंद टु मिस्त्र द्याश टु तेगुकु तंदीन कि ना आंदुर परमेश्वर ठहरूसाईन; ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","जो-जो विधीगोळ अदिक नियम अदिक व्यवस्था यहोवा तान दी टु इस्राएलीगोळ्द साटी सीनै पर्वत मा मूसा अन्द द्वारा ठहरूसकु ईरोद अव ईव अच हूँ. ");
INSERT INTO hoy_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","बाक यहोवा मूसा से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएलीगोळ से ईद अन कि याग यावारा विशेष मन्नत मानसुल, रा मन्नत माळ्द मंळसा नींद ठहरूसोद अनुसार यहोवा दोर आदार; ");
INSERT INTO hoy_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","इदुरसाटी अगर आव ईप्पत वर्ष या अदुर से यक्कुल अदिक साठ वर्ष से कम ऊमर इन गंळ्स ईरूल, रा आऊन साटी पवित्र जागा अन्द शेकेल इन अनुसार पचास शेकेल इन बेळ्ली नव तुकळागोळ ठहरूसुल.” ");
INSERT INTO hoy_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","अगर आक आर्त ईरूल, रा तीस शेकेल ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","बाक अगर आंदुर ऊमर अईद वर्ष या अदुर से यक्कुल अदिक ईप्पत वर्ष से कम इन ईरूल, रा पार उन साटी रा ईप्पत शेकेल, अदिक पोर इन साटी हत्त शेकेल ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","अगर आंदुर ऊमर ऊंद तिंगुळ इन या अदुर से यक्कुल अदिक अईद वर्ष से कम इन ईरूल, रा पार उन साटी रा अईद शेकेल, अदिक पोर इन साटी मुर शेकेल ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","बाक अगर आऊन ऊमर साठ वर्ष इन या अदुर से यक्कुल ईरूल, अदिक आव गंळ्स ईरूल रा आऊन साटी पन्द्रह शेकेल ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“लेकीन अगर यावारा ईट गरीब ईरूल कि याजक उन ठहरूसकु आग्याद दाम कोळ सकालुन, रा आव याजक उन मुंद निदरूसकु आगुल, अदिक याजक आऊन पूंजी ठहरूसुल, मतलब याट मन्नत माळावाळेर से आग सकुल, याजक आऊन दा अनुसार ठहरूसुल.” ");
INSERT INTO hoy_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“बाक या पशुगोळ दा टु लॉकुर यहोवा अक चढ़ावा येर्सतार, अगर हिंगुर दा टु यावारा मन्‍नत माळकु आगुल, रा जो पशु यावारा यहोवा अक कोळुल अद पवित्र ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","आव अदरी यातोदु प्रकार देल ईला बदलुसुल, ईला रा अद बुरा अन्द बदला वळ्‍लींद, अदिक न वळ्लीद इन बदला बुरा कोळुल; अदिक अगर आव आ पशु उन बदला दुसरा पशु कोळुल, रा आव अदिक आऊन बदला येढ्ढु पवित्र ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","अदिक या पशुगोळ दा टु यहोवा अन्द साटी चढ़ावा येरसालुर हिंगुर दा टु अगर अद ईरूल, आंदुर आऊक याजक उन मुंद निदरूस बुळुल, ");
INSERT INTO hoy_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","आग याजक पशु उन गुण-अवगुण येढ्ढु विचार माळकु अदुर किंमत ठहरूसुल; अदिक यास याजक ठहरूसुल अदुर किंमत आट अच ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","पर अगर मन्‍नत माळावाळा आऊक यातोदारा प्रकार देल बिळसोद चाहसुल, रा जो किंमत याजक ठहरूसदुन अदुर दा आऊन अईदवा भाग मात्त यक्कुल वाळुसकु कोळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“बाक अगर यावारा तान मान्ना यहोवा अन्द साटी पवित्र ठहरूसकु मन्‍नत माळुल, रा याजक आऊन गुण-अवगुण येढ्ढु विचार माळकु आऊन किंमत ठहरूसुल; अदिक याट याजक ठहरूसुल आऊन किंमत आट अच ईरूल. ");
INSERT INTO hoy_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","अदिक अगर मान्नी इक पवित्र माळावाळा आऊक बिळसोद चाहसुल, रा यास पैस्या याजक आऊन किंमत ठहरूसदुन अदुर दा आव अईदवा भाग मात्त यक्कुल वाळुसकु कोळुल, आग अद मान्ना आऊंद अच ईत्तीत.” ");
INSERT INTO hoy_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“बाक अगर यावारा तान खुद इन जागा अन्द यातोदारा भाग यहोवा अन्द साटी पवित्र ठहरूसोद चाहसुल, रा अदुर किंमत इदुर अनुसार ठहरूसुल, कि अदुर दा याट बींजा बिद्दीत; याट भूमी दा होमेर तीम जऊ बिद्दीत आटुर दा किंमत पचास शेकेल ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","अगर आव तान केई आजादी प्राप्ति इन वर्ष टु उच पवित्र ठहरूसुल, रा अदुर किंमत नींद ठहरावीन अनुसार ठहरूसुल; ");
INSERT INTO hoy_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","अदिक अगर आव तान केई आजादी प्राप्ति इन वर्ष इन बाद्दा पवित्र ठहरूसुल, रा याट वर्ष दुसरा आजादी प्राप्ति इन वर्ष इक बाकी ईरूल अऊर दा अनुसार याजक आऊन साटी पैस्या अन्द हिसाब माळुल, आग यास हिसाब दा बरूल आटा याजक उन ठहरूसोर देल कम आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","अदिक अगर केई इक पवित्र ठहरूसावाळा अदरी बिळसोद चाहसुल, रा जो किंमत याजक ठहरूसदुन अदुर दा अद अईदवा भाग मात्त यक्कुल वाळुसकु कोळुल, आग केई आऊंदा ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","अदिक अगर आव केई इक बिळसोद ईला चाहस्यान, या आव अदरी दुसरा अन कय दा मारीदान, रा केई मुंद भी यागलु बिळस्कु आगबाळुल; ");
INSERT INTO hoy_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","लेकीन याग अद केई आजादी प्राप्ति इन वर्ष दा बिळस्कु आगुल, आग पुरा रीती देल भेंट माळकु आत केई इन घाई यहोवा अन्द साटी पवित्र ठहरूसुल, मतलब अद याजक उन अच खुद इन जागा आगेगुल.” ");
INSERT INTO hoy_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","बाक अगर यावारा तान कोंडकु केई, जो आऊन खुद इन भूमी इन केईगोळ दाकळोद ईरबाळुल, यहोवा अन्द साटी पवित्र ठहरूसुल, ");
INSERT INTO hoy_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","रा याजक आजादी प्राप्ति इन वर्ष ताका हिसाब माळकु आ मंळसा अन्द साटी यास ठहरूसदुन आट अच आव यहोवा अन्द साटी पवित्र जान्सकु अदा दिशी कोटबुळुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","आजादी प्राप्ति इन वर्ष दा अद केई आऊंदा अधिकार दा याऊन से अद कोंडकु आग्याद बाक होट्ट बरूल, मतलब याऊन अद खुद इन जागा ईरूल आऊंदा बाक आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","या-या वस्तु उन किंमत याजक ठहरूसदुन अदुर किंमत पवित्र जागा अन्द शेकेल इन हिसाब देल ठहरूसुल: शेकेल ईप्पत गेरा अन्द ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“लेकीन मान्नागोळ पशुगोळ दा टु पयला पाड्डा, जो पयला पैदा आगोद कारण यहोवा अन्द ठहरूसकु आन, अदरी यावारा पवित्र ठहरूसबाळुल; चाहे अद पाड्डा ईरूल, चाहे म्यांडा या मर्री इन पाड्डा, अद यहोवा अन्द अच हुंद. ");
INSERT INTO hoy_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","लेकीन अगर अद अशुद्ध पशु उन आगुल , रा आऊन पवित्र ठहरूसावाळा अदरी याजक उन ठहरूसकु आग्याद किंमत इन अनुसार अदुर अईदवा भाग मात्त वाळुसकु बिळ्स सकतान; अदिक अगर अद बिळ्सकु आगीदिल, रा याजक उन ठहरूसकु किंमत मा मारकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“लेकीन तान पुरा वस्तुगोळ दा टु जो येनारा यावारा यहोवा अन्द साटी अर्पण माळुल, चाहे मंळसा आगुल चाहे पशु, चाहे आऊन खुद इन केई आगुल, हिंग यातोदारा अर्पण माळ्द वस्तु मारकु आगबाळुल न बिळ्सकु आगुल; जो येनारा अर्पण माळकु आगुल अद यहोवा अन्द साटी भेंट पवित्र ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","मंळसागोळ दा टु जो यावारा मृत्यु दण्ड इन साटी अर्पण माळकु आदुन, आऊक बिळ्सकु आगबाळुल; अवश्य आद आव कोंदकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“बाक जागा अन्द उपज इन पुरा दशमांश, चाहे अद जागा अन्द बींजा आगुल चाहे मार्र इन काय, ईव यहोवा अन्द हूँ; अद यहोवा अन्द साटी पवित्र ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","अगर यावारा तान दशमांश दा टु येनारा वापस ताकोमोद चाहसुल, रा अईदवा भाग वाळुसकु अदरी बिळसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","अदिक गोसी-वस्ता अदिक म्यांडा-मर्रगोळ, मतलब जो-जो पशु आळोर साटी कोल इन ल्‍यालमा टु होट्टबुळावाळेर आव अऊर दशमांश, मतलब हत्त-हत्त पशुगोळ दा टु ऊंद-ऊंद पशु यहोवा अन्द साटी पवित्र ठहरूसुल. ");
INSERT INTO hoy_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","यावारा अऊरव गुण-अवगुण विचार माळबाळुल, अदिक न अवरी बदलुसुल; अगर यावारा अवरी बदलुस भी कोंडुन, रा आव अदिक आऊन बदला येढ्ढु पवित्र ठहरूसुल; अदिक अव यागलु बिळ्सकु आगबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","जो आग्यागोळी यहोवा इस्राएलीगोळ साटी सीनै पर्वत मा मूसा अक कोटीदुन, अव ईव अच हूँ.");
INSERT INTO hoy_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","परमेश्वर उन सेवक मूसा अन्द सोत्तुर बाद्दा, परमेश्वर यहोशू से जो नून उन पार ईरोन अंदुन, ");
INSERT INTO hoy_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“नान सेवक मूसा सोतोदुन. ईग ई लॉकुर अदिक नीव यरदन गांगा अन्द आप्पाटी होगी. नीमी आ द्याश दा होग पायजे यारी ना इस्त्राएल इन लॉकुर इक मतलब नीमी कोळेतीन. ");
INSERT INTO hoy_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","ना मूसा अक ईद वचन कोटीदिन की ईद द्याश ना नीमी कोळाईन. इदुरसाटी ना नीमी अद हर ऊंद प्रदेश कोळाईन, जो यातोदारा जागा मा भी नीव होदीर. ");
INSERT INTO hoy_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","दक्षिण दा आळी टु उत्तर दा लबानोन इन पहाळी ताका, पूर्व दा फरात महानदी अदिक हित्ती जाती अन सप्पा लॉकुर द्याश टु पश्चिम दा महासमुद्र ताका ठहरूसीत. ");
INSERT INTO hoy_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","ना मूसा अन्द सांगुळ ईरीन अदिक ना हांग अच नीम्द सांगुळ ईराईन. नीम्द पुरा जीवन दा, नीमी यावारा भी मंळसा रोकसोर दा समर्थ आगतीदील. ना नीमी बिळालीन. ना यागलु नीम से दुर आगालीन.” ");
INSERT INTO hoy_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","“यहोशू, नीमी शक्तिशाली अदिक साहसी आग पायजे! नीमी ई लॉकुर अगुवा आग पायजे अदुर देल आंदुर तान द्याश वापस ताकोम सकुल. ईद अदा द्याश हुन अदरी ना आंदरी कोळोर साटी आंदुर पूर्वजगोळ इक वचन कोटीदिन. ");
INSERT INTO hoy_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","लेकीन नीमी ऊंद दुसरा मात इन बारा दा भी मजबुत अदिक साहसी ईरोद बिद्दीत. नीमी आ आदेशगोळ्द पालन निश्चय इन सांगुळ माळ पायजे, यारी नान सेवक मूसा नीमी कोट्टान. अगर नीव आऊन शिक्षागोळ्द ठीक-ठीक पालन माळीर, रा नीव जो येनारा माळीर अदुर्दा सफल आदीर. ");
INSERT INTO hoy_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","आ व्यवस्था अन्द किताब दा लिखस्द मातगोळ इक सदा याद ईटी. नीव आ किताब इन अध्ययन ईळ्लक हागुल माळी, आगल्या नीव अदुर्दा लिखस्द आदेशगोळ्द पालन इन बारा दा विश्वस्त ईर सकतीर. अगर ईद नीव माळीर, रा नीव बुध्दिमान बनसीर अदिक जो येनारा माळीर अदुर्दा सफल आदीर. ");
INSERT INTO hoy_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","याद ईटी, कि ना नीमी शक्तिशाली अदिक साहसी बन्सकु ईरोद आदेश कोटीदिन. इदुरसाटी यागलु भयभीत आग बाळेतीर, यतिकी नीम्द परमेश्वर यहोवा नीम्द सांगुळ सप्पा जागा दा ईत्तान, एल नीव होदीर.” ");
INSERT INTO hoy_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","आग यहोशू प्रजा अन मुख्य लॉकुरी ईद आग्या कोट्टुन, ");
INSERT INTO hoy_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“ड्यारा टु आगकु होगी अदिक लॉकुर इक तयार आगली अनी. लॉकुर से अनी, ‘थ्वाळासा भोजन तयार माळ कोमुल. ईग टु मुर दिन बाद, नाव लॉकुर यरदन गांगा पार माळेव. नाव लॉकुर होदेव अदिक आ द्याश इक ताकोंडेव यारी नीम्द परमेश्वर यहोवा नीमी कोळेत्यान.’” ");
INSERT INTO hoy_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","आग यहोशू रूबेनिगोळ, गादीगोळ, अदिक मनश्शेगोळ्द आर्धा वंश इन लॉकुर से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“अदरी याद ईटी, जो परमेश्वर उन सेवक मूसा नीमी अंदीदुन. आव अंदीदुन कि परमेश्वर, नीम्द यहोवा अक अदिक नीमी आराम इन साटी जागा कोट्टान. परमेश्वर ईद द्याश नीमी कोट्टान. ");
INSERT INTO hoy_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","नीम हिंग्सुर, बाल- बच्यागोळ, अदिक जनावरगोळ रा ई द्याश दा ईत्तव जो मूसा नीमी यरदन इन ईपाटी का कोटान, लेकीन नीव जो योध्दा शस्त्र नेगुकु तान वार्टुर्द मुंद मुंद आपाटी ईळुकु नळदीर, अदिक आंदुर्द मदत माळी. ");
INSERT INTO hoy_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","अदिक याग परमेश्वर आंदरी हींग आराम कोट्टान ह्यांग आव नीमी कोट्ट बुटान, अदिक आंदुर भी नीम परमेश्वर यहोवा अन कोळ्द द्याश इन अधिकारी आगेदार; आग नीव तान अधिकार इन द्याश दा, जो परमेश्वर उन दास मूसा यरदन इन ईपाटी पूर्व अन दी नीमी कोटान, वापस बंदकु ईदुर अधिकारी आदार.” ");
INSERT INTO hoy_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","आग लॉकुर यहोशू उक उत्तर कोट्टुर, “जो भी माळोर साटी नीव आदेश कोट्टीर, नाव लॉकुर माळेव! या जागा मा कळेतीर,नाव लॉकुर होदेव! ");
INSERT INTO hoy_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","नाव लॉकुर पुरा तरीका देल मूसा अन्द आग्या मान्सदेव. अदा तरीका देल नाव लॉकुर अव सप्पा मानसेव जो नीव अंदीर. नाव लॉकुर यहोवा से केवल ऊंद मात चाहसतेव. नाव लॉकुर परमेश्वर यहोवा से ईदा मांग माळतेव कि आव नीम सांगुळ हांग अच ईरूल जसा आव मूसा अन्द सांगुळ ईरोन. ");
INSERT INTO hoy_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","आग, अगर यावारा मंळसा नीम्द आग्या मानसोर से इंकार माळतान या यावारा मंळसा नीम्द विरूद्ध निदुरतान, आव कोंदकु आदान. केवल शक्तिशाली अदिक साहसी ईरी!” ");
INSERT INTO hoy_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","नून उन पार यहोशू अदिक सप्पा लॉकुर शित्तिम दा ड्यारा हाकीदुर. यहोशू येढ्ढ गुप्तचरगोळ इक कळुदुन. यातोदारा दुसरा मंळसा अक ईद पता हतीदिल कि यहोशू ई लॉकुर इक कळीदुन. यहोशू ई लॉकुर से अंदुन, होगी अदिक प्रदेश इन जाँच माळी, इदुरसाटी आ मंळसागोळ यरीहो होदुर. आंदुर ऊंद वेश्या अन मान्या होदुर अदिक अल ईत्तुर. आ आर्त इन हेसुर राहाब ईरोद. ");
INSERT INTO hoy_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","यावारा दुसरा मंळसा यरीहो अन्द राजा से अंदुन, “इस्त्राएल इन थ्वाळासा मंळसागोळ ईंद ईळ्लकी नाम्द द्याश इन भेद ताकोमली बंदार.” ");
INSERT INTO hoy_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","इदुरसाटी यरीहो अन्द राजा राहाब उन मान्या ईद बातणी कळुदुन: “आ मंळसागोळी होतुर्सबाळी जो बंदकु नीम्द मान्ना दा ठहरूसकु आर. आंदरी व्हार्या तरी. आंदुर भेद ताकोमली नाम द्याश दा बंदार.” ");
INSERT INTO hoy_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","आ आर्त येढ्ढु मंळसागोळ इक होतुर्सुकु ईटीदुर. लेकीन आर्त अंदुर, “आंदुर येढ्ढ मंळसागोळ बंदीदुर, लेकीन ना जानसालीन कि आंदुर यल टु बंदीदुर. ");
INSERT INTO hoy_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","नगर द्वार बंद आगोद समय आंदुर मंळसागोळ द्यावगा होटोदुर. ना जानसालीन कि आंदुर यल होदुर. लेकीन अगर नीव रा़टनेरी होदीर, रा शायद आंदरी हुडु कोंडीर.” ");
INSERT INTO hoy_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","आक आंदरी मान्ना अन्द छत मा येर्सकु सन इन हुळ्लीगोळ्द ल्यालमा होतुर्सीदुर जो आक हुळ्लीगोळी छत मा जमा माळकु ईटीदुर. ");
INSERT INTO hoy_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","इदुरसाटी इस्राएल इन येढ्ढ मंळसागोळ्द खोज दा राजा अन्द मंळसागोळ होटोदुर. राजा अन्द मंळसागोळ्द द्वारा नगर बिट्टुर तुरंत बाद नगर द्वार बंद माळकु आदव. आंदुर आ जागागोळ मा होदुर यल टु लॉकुर यरदन गांगा अक पार माळतोगोर. ");
INSERT INTO hoy_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","येढ्ढु मंळसागोळ ईळ्लक इक मिंगोद तयारी दा ईरोर. लेकीन आ आर्त छत मा होदुर अदिक आक आंदुर से मात माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","राहाब अंदुर, “ना जान्सतीन कि ईद द्याश यहोवा नीम्द लॉकुरी कोट्टुन. नीव नाम लॉकुरी भयभीत माळतीर. ई द्याश दा ईरावाळेर सप्पा मुंदुर नीम लॉकुर से भयभीत आर. ");
INSERT INTO hoy_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","नाव लॉकुर अंज्कु आयेव यतिकी नाव केळदेव कि यहोवा नीव लॉकुर्द मदत ह्यांग माळदुन. नाव केळदेव की नीव मिस्त्र टु व्हार्या बंदीर रा यहोवा क्याचाँद समुद्र इन नीर इक वंळगास बुट्टुन. नाव लॉकुर ईद भी केळदेव की नीव लॉकुर येढ्ढ एमोरी राजागोळ इक सीहोन अदिक ओग इन सांगुळ येन माळदीर नाव लॉकुर केळदेव की नीव लॉकुर यरदन गांगा अन पूर्व दा ईरावाळेर आ येढ्ढ राजागोळ इक ह्यांग नष्ट माळदीर. ");
INSERT INTO hoy_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","नाव लॉकुर आ घटनागोळ इक केळदेव अदिक हापाळ येक्‍कुल अंजदेव अदिक ईग नाम दा टु यावारा मंळसा ईट साहसी हैलेच कि नीव लॉकुर से लळाई माळ सकुल. यती? यतिकी नीमव परमेश्वर यहोवा म्याकुच आकाश अदिक ल्‍यालमा पृथ्वी इन परमेश्वर हुन. ");
INSERT INTO hoy_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","रा ईग, ना चाहसतीन कि नीव नानी वचन कोळी. ना नीम्द मदत माळदीन अदिक नीम मा दया माळदीन. इदुरसाटी यहोवा अन्द मुंद वचन कोळी कि नीव नाम परिवार मा दया माळीर. कृपया नानी अनी कि नी हिंग माळेत. ");
INSERT INTO hoy_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","नान से नीव ईद अनी कि नीव नान परिवार इक जित्ता ईर गोट्टीर आंदुर दा नान आप्प, मोय, वार्ट, आकतींगेर, अदिक आंदुर्द परिवार ईत्तीत. नीव प्रतिग्या माळी कि नीव नानी सायोर देल वाचुसीर.” ");
INSERT INTO hoy_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","आ मंळसागोळ आकिन मातगोळी मान्स कोंडुर. आंदुर अंदुर, “ नाव नीम जीवन इन साटी तान जीवन इन बाजी हच बुट्टेव. यातोदारा मंळसा अक ईद हेळबाळी कि नाव येन माळीतेव. आग याग यहोवा नाव लॉकुर इक नाम्द द्याश कोट्टान, आग नाव नीम मा दया माळेव. नीव नाम लॉकुर मा विश्वास माळ सकतीर.” ");
INSERT INTO hoy_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","आ आर्त इन मान्ना नगर इन दिवार इन बुळ्क बन्सकु ईरोद. ईद दिवार इन ऊंद हिस्सा ईरोद. इदुरसाटी आर्त खिळकी दा टु आ भेदीगोळी ईळोर साटी जाळी इन उपयोग माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","आग आर्त आंदुर से अंदुर, “पहाळीगोळ मा होगी, ईदुर देल राजा अन्द मंळसागोळ नीमी हुडु सकतीदील. अल मुर दिन होचकु ईरी. राजा अन्द मंळसागोळ याग वापस बंदार आग नीव तान हादी देल होग सकतीर.” ");
INSERT INTO hoy_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","मंळसागोळ आकिन से अंदुर, “जो किर्‍या नी नामी तिनस्या, अदुर विषय दा नाव निर्दोष ईत्तेव. ");
INSERT INTO hoy_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","नी ईद क्याचांद जाळी इन उपयोग नाम लॉकुरी ऊळ्दकु ओळोर साटी माळेत्या. नाव लॉकुर ई द्याश दा वापस बंदेव. आ समय नी ई जाळी इक तान खिळकी देल जरूर कटकु ईटेत. नीनी तान आप्प, तान मोय, तान वार्ट, अदिक तान पुरा परिवार इक तान सांगुळ ई मान्या ईटोद बिद्दीत. ");
INSERT INTO hoy_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","नाव लॉकुर हर ऊंद मंळसा अक सुरक्षित ईट्टेव जो ई मान्ना दा ईत्तान. अगर नीम मान्ना अन्द बुळ्क यारीकारा चोट पहुचुस्तद, रा अदुर साटी नाव लॉकुर दोषी ईत्तेव. अगर नीम मान्ना टु यावारा मंळसा व्हार्या होदान, रा आव कोंदकु आग सकतान. आ मंळसा साटी नाव दोषी ईरतीदील. ");
INSERT INTO hoy_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","नाव ईद वचन नीनी कोळतेव. लेकीन अगर नी यारीकारा हेळ्या कि नाव येन माळेतेव, रा नाव तान ईद वचन देल आजाद आदेव.” ");
INSERT INTO hoy_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","आर्त उत्तर कोट्टुर, “ना इदरी स्वीकार माळतीन.” आर्त नमस्कार माळदुर अदिक आंदुर आकिन मान्ना बिट्टुर. आर्त खिळकी टु क्याचाँद जाळी कटदुर. ");
INSERT INTO hoy_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","भेदी आकिन मान्ना बिटकु पहाळीगोळ दा होटोदुर. येल आंदुर मुर दिन ईत्तुर. राजा अन्द मंळसागोळ पुरा सळक मा आंदुर्द खोज माळदुर. मुर दिन इन बाद्दा राजा अन्द मंळसागोळ खोज बंद माळ बुट्टुर. आ सिपाहीगोळ आंदरी ढुंढ्स सकीदील, रा सिपाहीगोळ नगर दा वापस होट्ट बंदुर. ");
INSERT INTO hoy_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","आग येढ्ढु भेदीगोळ यहोशू उन हात्ती वापस बरोद सुरूवात माळदुर. आ मंळसागोळ पहाळीगोळी बिट्टुर अदिक गांगा अक पार माळदुर. आंदुर नून उन पार यहोशू उन हात्ती होदुर. आंदुर जो येनारा पता हचीदुर, यहोशू उक हेळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","आंदुर यहोशू उक अंदुर, “यहोवा खराखुरा पुरा द्याश नाव लॉकुर इक कोट बुट्टान. आ द्याश इन सप्पा लॉकुर नाम लॉकुर से भयभीत आर.” ");
INSERT INTO hoy_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","यहोशू व्हातर्या येद्दुन, अदिक इस्त्राएल इन सप्पा लॉकुर यद्दुर अदिक शित्तिम इक आंदुर बिट्ट बुट्टुर. आंदुर यरदन गांगा ताका यात्रा माळदुर. आंदुर आप्पाटी होगोर से पयले यरदन गांगा मा ड्यारा हचदुर. ");
INSERT INTO hoy_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","अदिक मुर दिन इन बाद्दा स्याणागोळ छावनी इन बीच होगकु ");
INSERT INTO hoy_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","प्रजा अन लॉकुरी ईद आग्या कोट्टुर, “याग नीमी तान परमेश्वर यहोवा अन वाचा अन सन्दुक अदिक आ लेवी याजक जो अदरी नेगुकु काणस्यान, आग तान जागा मा टु यदकु आऊन हींद हींद नळेतीर, ");
INSERT INTO hoy_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","लेकीन आऊन अदिक नीम बीच दा येढ्ढ हजार कय ईट अन्तर ईरूल; नीव सन्दुक इन हाती होगबाळेतीर. ताकी नीव नोळ सकीर, कि याता हादी टु नीमी नळोद आद, यतिकी ईगासताका नीव ई हादी मा आगकु नळदिदील.” ");
INSERT INTO hoy_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","बाक यहोशू इस्त्राएली लॉकुर से अंदुन, “नीव तान तान इक पवित्र माळी; यतिकी नाळ इन दिशी यहोवा नीम बीच दा आश्चर्यकर्म माळ्यान.” ");
INSERT INTO hoy_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","आग यहोशू याजकगोळ से अंदुन, “वाचा अन सन्दुक नेगुकु लॉकुर्द मुंद मुंद नळी.” आग आंदुर वाचा अन सन्दुक नेगुकु मुंद मुंद नळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","आग यहोवा यहोशू से अंदुन, “ईंद इन दिन टु ना सप्पा इस्त्राएलगोळ हाती नींद प्रशंसा माळोद चालु माळाईन, यदुर देल आंदुर जानसुल कि ह्यांग ना मूसा अन सांगुळ ईरतोगीन हांग अच ना नीन सांगुळ भी आईन. ");
INSERT INTO hoy_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","अदिक नी वाचा अन सन्दुक इक नेगावाळेर याजकगोळी ईद आग्या कोळ, ‘याग नीव यरदन इन नीर इन किनारा मा पोहचुसीर, आग यरदन दा नीदुरकु ईरेतीर.’” ");
INSERT INTO hoy_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","आग यहोशू इस्त्राएली लॉकुर से अंदुन, “हाती बंदकु तान परमेश्वर यहोवा अन वचन केळी.” ");
INSERT INTO hoy_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","अदिक यहोशू अनली कुरतुन, “ईदुर देल नीव जान्स कोंडीर कि जीत्ता परमेश्वर नीम बीच दा आन, अदिक आव नीम मुंदु टु नि:सन्देह कनानीगोळी, हित्तीगोळी, हिब्बीगोळी, परिज्जीगोळी, गिर्गाशीगोळी, एमोरिगोळी, अदिक यबूसीगोळी आंदुर द्याश दा टु तेगु बुट्टान. ");
INSERT INTO hoy_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","केळी, सप्पा पृथ्वी नोर प्रभु अन वाचा अन सन्दुक नीम मुंद मुंद यरदन दा होगदुर मा आद. ");
INSERT INTO hoy_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","इदुरसाटी ईग इस्त्राएल इन गोत्रगोळ दा टु हन्नेळ मंळसागोळी नीवळुसी, आंदुर ऊंद ऊंद गोत्र दा टु ऊंद मंळसा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","अदिक याता समय दा पृथ्वी दाकळोर प्रभु यहोवा अन वाचा अन सन्दुक नेगावाळेर याजकगोळ काल यरदन गांगा अन नीर दा बिद्दव, आ समय यरदन इन म्याकुच टु वाहुसतेला नीर थामसेदीत, अदिक ढेर आगकु थाम्सकु ईत्तीत.” ");
INSERT INTO hoy_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","इदुरसाटी याग लॉकुर यरदन गांगा अन आप्पाटी होगोर साटी होट्टुर, अदिक याजक वाचा अन सन्दुक नेगुकु लॉकुर मुंद मुंद नळदुर, ");
INSERT INTO hoy_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","अदिक सन्दुक इक नेगावाळेर यरदन मा पोहचुसदुर, अदिक सन्दुक इक नेगावाळेर याजकगोळ काल यरदन तीर इन नीर दा मुळ्कदव, यरदन इन नीर रा कटनी इन समय इन सप्पा दिन तान तट इन म्याकुच म्याकुच वाहुसतेला ईरतद, ");
INSERT INTO hoy_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","आग जो नीर म्याकुच इन दी टु वाहुसकु बरताव अव हापाळ दुर, मतलब आदाम नगर इन हात्ती जो सारतान नगर इन हात्ती रूक्सकु ऊंद ढेर आगेत, अदिक दिवाल घाई येदकु ईत्त, अदिक जो नीर अराबा अन समुद्र जो मृत समुद्र भी कहलुस्तद, अदुर दी वाहुसकु होगोद, अद पुरा रीति देल वंळ्गेत; अदिक प्रजा अन लॉकुर यरीहो अन मुंद आपाटी ईळदोदुर. ");
INSERT INTO hoy_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","अदिक याजक यहोवा अन सन्दुक नेगुकु यरदन इन बीचोबीच होगकु जागा मा स्थिर निदुरकु ईत्तुर, आखरी दा अद सप्पा जाती अन लॉकुर यरदन गांगा अन पार आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","याग आ सप्पा जाती इन लॉकुर यरदन गांगा अन आप्पाटी ईळदुर, आग यहोवा यहोशू से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“लॉकुर दा टु हन्नेळ मंळसागोळी नीवळुस कोमी, हर ऊंद वंश दा टु ऊंद मंळसा निवळुसकु ईद आग्या कोळी. ");
INSERT INTO hoy_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","अदिक लॉकुर से अनी कि आंदुर अल यरदन गांगा दा नोळुल यल याजकगोळ नीदुरकु आर, आंदुर अल हन्नेळ कल्लगोळ ढुंढस्कु तेगुली हेळी, आ हन्नेळ कल्लगोळी तान सांगुळ वोई, आ हन्नेळ कल्लगोळी आ जागा मा ईटी येल नीव ईंद ईळ्लकी ईत्तीर.” ");
INSERT INTO hoy_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","आग यहोशू आ हन्नेळ मंळसागोळी, यारी आव इस्त्राएलगोळ हर ऊंद वंश दा टु नीवळुसकु थाम्सकु ईटीदुन, ");
INSERT INTO hoy_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","यहोशू आंदुर से अंदुन, “नीव तान परमेश्वर यहोवा अन सन्दुक इन मुंद यरदन इन बीच दा होगकु इस्त्राएलगोळ वंश इन गिनती इन अनुसार ऊंद ऊंद कल्ल नेगुकु तान तान खांदा मा ईटी, ");
INSERT INTO hoy_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","यदुर देल ईद नीम लॉकुर इन बीच दा चिन्ह ठहरूसुल, अदिक मुंद याग नीम चिकोर ईद केळुल, ‘ई कल्लगोळ्द येन मतलब आद?’ ");
INSERT INTO hoy_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","आग नीव आंदरी ईद उत्तर कोळेतीर, कि यरदन गांगा अन नीर परमेश्वर उन वाचा अन सन्दुक इन मुंद येढ्ढ भाग आगेगीदव; यतिकी याग आंदुर यरदन गांगा पार माळकु बरोर, आग यरदन गांगा अन नीर येढ्ढ भाग आगेगीदव. इदुरसाटी अव कल्लगोळ इस्त्राएल इक हमेशा अन साटी याद दिलुसावाळा ठहरूसेव.” ");
INSERT INTO hoy_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","यहोशू उन ई आग्या अन अनुसार इस्त्राएलगोळ माळदुर, ह्यांग यहोवा यहोशू से अंदीदुन हांग अच आंदुर इस्त्राएलीगोळ्द वंश इन गिनती इन अनुसार हन्नेळ कल्ल यरदन इन बीच दा टु नेगदुर; अदिक आंदरी तान सांगुळ वोतकु येल आंदुर थामसीदुर ईट बुट्टुर, ");
INSERT INTO hoy_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","यहोशू भी यहोवा अन पवित्र सन्दुक इक वयावाळेर याजक येल नीदुरकु ईरोर, अल्या यरदन गांगा अन बीच दा हन्नेळ कल्ल निदरूसदुन; अव ईंद ताका अल्या अदा जागा मा आव. ");
INSERT INTO hoy_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","यहोवा यहोशू उक आदेश कोटीदुन कि आव लॉकुर से अनुल कि आंदरी येन माळोद आद. अव अवा मातगोळ ईरव, यवरी अवश्य अनोर साटी मूसा यहोशू से अंदीदुन. इदुरसाटी पवित्र सन्दुक इक वयावाळेर याजक यरदन गांगा अन बीच दा आगासताका नीदुरकु ईत्तुर, यागासताका ई सप्पा क्याल्सा पुरा आगीदील, लॉकुर जल्दी माळदुर अदिक गांगा अक पार माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","याग लॉकुर गांगा अन आप्पाटी होटोदुर आग याजक यहोवा अन सन्दुक इक हुडुकु लॉकुर मुंद बंदुन. ");
INSERT INTO hoy_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","अदिक रूबेनी, गादी, अदिक मनश्शे अन आर्धा वंश इन लॉकुर मूसा अन अनोद हिसाब देल युध्द इन हथियार कटकु इस्त्राएलीगोळ्द मुंद आपाटी आगेदुर; ");
INSERT INTO hoy_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","लगभग चालीस हजार सैनिक, जो युध्द साटी तैयार ईरोर, यहोवा अन मुंदु टु होदुर, आंदुर यरीहो अन मैदान दा पोहचुसदुर. ");
INSERT INTO hoy_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","आ दिशी यहोवा सप्पा इस्त्राएलीगोळ मुंद यहोशू उन महिमा वाळुसदुन; अदिक ह्यांग आंदुर मूसा अन भय मानसोर हांग अच यहोशू उन भी भय आऊन जीवन तीम मान्सतेला ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","आग यहोवा यहोशू से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“वाचा अन सन्दुक नेगावाळेर याजकगोळी आग्या कोळ कि यरदन दा टु व्हार्या बंदार.” ");
INSERT INTO hoy_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","रा यहोशू याजकगोळी आग्या कोट्टुन, “यरदन गांगा दा टु व्हार्या बरी.” ");
INSERT INTO hoy_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","अदिक ह्यांग अच यहोवा अन वाचा अन सन्दुक नेगावाळेर याजक यरदन गांगा दा टु व्हार्या बंदुर, अदिक आंदुरव काल जागा मा बिद्दव, आग अच यरदन गांगा अन नीर तान जागा दा बत्त, अदिक पयला घाई तटगोळ मा म्याकुच वाहुसली कुर्त. ");
INSERT INTO hoy_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","पयला तींगुळ इन हतवा दिशी इक प्रजा अन लॉकुर यरदन गांगा दा टु होटकु यरीहो अन पुर्वी सीमा मा गिलगाल दा तान ड्यारा हाकदुर. ");
INSERT INTO hoy_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","अदिक जो हन्नेळ कल्ल यरदन गांगा दा टु तेगुकु आगीदव, अवरी यहोशू गिलगाल दा निदरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","आग आव इस्त्राएलगोळ से अंदुन, “मुंद याग नीम चिकोर तान तान आप्प से ईद केळुल, ‘ईव कल्लगोळ्द येन मतलब आद?’ ");
INSERT INTO hoy_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","आग नीव आंदरी ईद हेळेतीर, ‘ई यरदन गांगा अक नाव इस्त्राएलीगोळ वंळ्गींद जागा मा नळुकु आपाटी होगीदेव.’ ");
INSERT INTO hoy_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","यतिकी ह्यांग नीम परमेश्वर यहोवा क्याचाँद समुद्र अक नाम आप्पाटी आगासताका नाम मुंद टु सरकुसकु वंळ्गीद ईटीदुन, हांग अच आव यरदन गांगा अन नीर भी नीम आप्पाटी आगासताका नीम मुंद टु सरकुसकु वंळ्गीद ईटदुन; ");
INSERT INTO hoy_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","इदुरसाटी कि पृथ्वी इन सप्पा द्याशगोळ लॉकुर जानसुल कि यहोवा अन कय ताकतवर आद; अदिक नीव हमेशा तान परमेश्वर यहोवा अन अंज्क मान्सतेला ईरी.” ");
INSERT INTO hoy_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","याग यरदन इन पश्चिम इन दी ईरावाळेर एमोरियागोळ सप्पा राजागोळ, अदिक समुद्र अन हाती ईरावाळेर कनानीगोळ सप्पा राजागोळ ईद केळदुर, कि यहोवा इस्त्राएलीगोळ पार आगासताका आंदुर मुंदु टु यरदन इन नीर सरकुसकु वंळ्गींद ईट्यान, आग इस्त्राएलीगोळ्द अंज्क इन मारा आंदुर्द मन घबरूसेत, अदिक आंदुर्द जीव दा जीव ईतीदील. ");
INSERT INTO hoy_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","आ समय यहोवा यहोशू से अंदुन “चकमक कल्ल इन चाकुगोळी माळसुसकु दुसरा घन इस्त्राएलीगोळ्द खतना माळसुस कोम.” ");
INSERT INTO hoy_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","आग यहोशू चकमक कल्ल इन चाकुगोळी माळसुसकु खतना हेसुर इन पहाळी मा इस्त्राएली लॉकुर्द खतना माळसुसदुन. ");
INSERT INTO hoy_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","अदिक यहोशू जो खतना माळसुसदुन, ईदुर्द कारण ईद हुन, कि यास मंळसा युध्द इन योग्य मिस्त्र दा टु होटीदुर आंदुर सप्पा मिस्त्र टु होट्टुर मा आळी इन हादी मा सोतोगीदुर. ");
INSERT INTO hoy_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","जो मंळसा मिस्त्र द्याश टु होटीदुर आ सप्पा मुंदुर्द रा खतना आगेगीत, लेकीन यास आंदुर्द मिस्त्र टु होट्टुर मा आळी इन हादी मा पैदा आदुर आंदुर दा टु यारदु खतना ईला आगीत. ");
INSERT INTO hoy_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","यतिकी इस्त्राएली रा चालीस वर्ष ताका आळी दा वयाळतेला ईत्तुर, यागासताका आ सप्पा जाती इन लॉकुर, मतलब यास युध्द अन योग्य लॉकुर मिस्त्र टु होटीदुर आंदुर नष्ट आगेगीदील, यतिकी आंदुर यहोवा अन ईला मान्सीदुर; इदुरसाटी यहोवा आंदुर से किर्‍या तिनकु अंदीदुन, कि जो द्याश ना नीम पुर्वजगोळ से किर्‍या तीनकु नीमी कोळली हेळीदीन, अदिक अदुर दा हाल अदिक शयद इन धारागोळ वाहुसताव, अद द्याश ना नीमी तोर्सतीदील. ");
INSERT INTO hoy_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","रा आ लॉकुर पारगोळ यारी यहोवा आंदुर जागा मा पैदा माळीदुन, आदुर्द खतना यहोशू से माळसुसदुन, यतिकी हादी मा आंदुर्द खतना ईला आगदुर कारण आंदुर खतना रहित ईरोर. ");
INSERT INTO hoy_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","अदिक याग आ सप्पा जाती इन लॉकुर्द खतना आगेत, आग आंदुर चंगा आगासताका तान तान जागा मा ड्यारा दा ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","आग यहोवा यहोशू से अंदुन, “नीम्द निंदा जो मिस्त्रीगोळ दा आग्याद, अदरी ना ईंद दुर माळदीन.” ई कारण आ जागा अन हेसुर ईंद इन दिन ताका गिलगाल बिदाद. ");
INSERT INTO hoy_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","इदुरसाटी इस्त्राएली गिलगाल दा ड्यारा हाक्कु ईत्तुर, अदिक आंदुर यरीहो अन हाती मैदान दा तिंगुळ इन चौदावा दिशी द्यावगा अन होती हाब्ब मान्सदुर. ");
INSERT INTO hoy_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","अदिक हाब्ब इन दुसरा दिशी आंदुर आ द्याश इन उपज दा टु अखमीरी रोट्टी अदिक अदा दिशी टु सुळ्द दाना भी तीनली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","अदिक याता दिन टु आंदुर आ द्याश इन फसल दा टु तीनली कुरतुर, अदा दिशी व्हातर्या का मन्ना बंद आगेत; अदिक इस्त्राएलगोळी मुंद यागलु मन्ना सिकीदील, लेकीन आ वर्ष आंदुर कनान द्याश इन फसल दा टु तिंदुर. ");
INSERT INTO hoy_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","याग यहोशू यरीहो अन हाती ईरोन आग आव तान कण्‍ण नेगदुन, अदिक येन नोळदुन, कि कय दा उगळा तलवार हुडुकु ऊंद मंळसा मुंद नीदुरकु आन; अदिक यहोशू आऊन हाती होगकु केळदुन, “येन नी नाम दिकळव हुव, या नाम दुश्मनगोळ दिकळव?” ");
INSERT INTO hoy_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","आग आव उत्तर कोट्टुन, “ईला; बल्‍की ना यहोवा अन सेना अन प्रधान आगकु ईग बंदीन.” आग यहोशू जमीन मा ट्वांगरा टेक्सकु नमस्कार माळदुन, अदिक आऊन से अंदुन, “तान दास उन साटी नान प्रभु उन येन आग्या आद?” ");
INSERT INTO hoy_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","यहोवा अन सेना अन प्रधान यहोशू से अंदुन, “तान केरू काल दा टु तेगुकोम, यतिकी या जागा मा नी नीदुरकु आय अद पवित्र आद.” आग यहोशू हांग अच माळदुन. ");
INSERT INTO hoy_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","यरीहो अन सप्पा फाटक इस्त्राएलीगोळ अंज्क इन कारण लगातार बंद ईत्तव, अदिक याऊ व्हार्या ईला होगसकोन अदिक बुळ्क ईला होगसकोन. ");
INSERT INTO hoy_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","बाक यहोवा यहोशू से अंदुन, “केळ, ना यरीहो अक आऊन राजा अदिक शूरवीरगोळ सांगुळ नीन वश दा माळ कोळतीन. ");
INSERT INTO hoy_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","इदुरसाटी नीम दा यास योध्दा आर नगर इक घेर्स कोमुल, अदिक आ नगर इन नाकु दी हागुल ऊंद घन वयाळकु बरूल. अदिक आर दिन ताका हिंग अच माळेतीर. ");
INSERT INTO hoy_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","म्यांडागोळ्द सींग इन माळ्द तुरहीगोळ हुडुकु येळ याजकगोळी नळुगोळी, याजकगोळ से अनी कि आंदुर पवित्र सन्दुक इन मुंद नळदार, सातवा दिशी नगर इन नाकु दी येळ फ्यारा माळी, याजकगोळ से अनी कि आंदुर नळुतेला तुरही मुरस्यार. ");
INSERT INTO hoy_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","याजक तुरहीगोळ देल धोळ्द आवाज माळ्यार, याग नीव आ आवाज केळीर रा नीव सप्पा लॉकुर से गर्जन सुरू माळली हेळीतीर, याग नीव हिंग माळीर रा नगर इन दिवारगोळ बिदोदव, आग नीम लॉकुर सीधा नगर दा होदार.” ");
INSERT INTO hoy_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","ई प्रकार नून उन पार यहोशू याजकगोळी जमा माळदुन, यहोशू आंदुर से अंदुन, “यहोवा अन पवित्र सन्दुक इक हुडुकु नळी अदिक येळ याजकगोळी तुरही हुडुकु नळुली हेळी, आ याजकगोळी सन्दुक इन मुंद नळु पायजे.” ");
INSERT INTO hoy_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","बाक आव लॉकुर से अंदुन, “मुंद वाळुस्कु नगर इन नाकु दी वयाळकु बरी; अदिक अस्त्र शस्त्र वाळेर मंळसा यहोवा अन सन्दुक इन मुंद मुंद नळी.” ");
INSERT INTO hoy_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","अदिक याग यहोशू लॉकुर से ईद मात अंदुन, रा आंदुर येळ याजक जो यहोवा अन मुंद येळ तुरही हुडुकु ईरोर तुरही उयतेला नळदुर, अदिक याजक यहोवा अन पवित्र सन्दुक आंदुर हिंद हिंद हुळकु नळोर. ");
INSERT INTO hoy_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","अस्त्र शस्त्र वाळेर मंळसागोळ याजकगोळ मुंद नळोर, अदिक पवित्र सन्दुक इन हिंद नळावाळेर लॉकुर तुरही मुरसोर अदिक सांगुळ नळोर. ");
INSERT INTO hoy_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","अदिक यहोशू लॉकुरी आग्या कोट्टुन, “यागासताका ना नीमी जयजयकार माळोद आग्या कोळालीन, आगासताका जयजयकार माळबाळेतीर, अदिक न निम्द येनारा शब्द केळदुर दा बरूल, अदिक यातोदु मात नीम बाय दा टु होळ ईला पायजे; याग ना नीमी आग्या कोळाईन आग जयजयकार माळेतीर.” ");
INSERT INTO hoy_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","आव यहोवा अन सन्दुक इक ऊंद घन नगर इन नाकु दी वयाळसदुन; आग आंदुर छावनी दा बंदुर, अदिक ईळ्लक अल्या कळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","यहोशू व्हातर्या येद्दुन, अदिक याजकगोळ यहोवा अन सन्दुक नेगु कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","अदिक आ येळ याजकगोळ व्हात इन सींग इन येळ तुरही हुळदुर अदिक यहोवा अन सन्दुक इन मुंद मुंद मुर्सतेला नळदुर; अदिक आंदुर मुंद अस्त्र शस्त्र वाळेर मंळसा नळदुर, अदिक हिंद वाळेर यहोवा अन सन्दुक इन हिंद हिंद नळदुर, अदिक याजकगोळ तुरही मुर्सतेला नळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","ई प्रकार आंदुर दुसरा दिशी भी ऊंद घन नगर इन नाकु दी वयाळकु छावनी दा वापस बंदुर, अदिक ई प्रकार आंदुर आर दिन ताका माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","बाक आंदुर सातवा दिशी हापाळ जल्दी यदकु अदा रीति देल नगर इन नाकु दी येळ घन वयाळकु बंदुर; सिर्फ अदा दिशी आंदुर येळ घन वयाळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","आग सातवा घन याग याजक तुरही ऊरूतोगोर, आग यहोशू लॉकुर से अंदुन, “जयजयकार माळी; यतिकी यहोवा ई नगर इक नीमी कोट्ट बुटान. ");
INSERT INTO hoy_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","नगर अदिक अदुर्द हर ऊंद वस्तु प्रभु अक बली अन रूप दा अर्पीत माळकु नाश आगेदीत; केवल राहाब वेश्या अदिक यास आकिन मान्या आर आंदुर जित्‍ता बिटकु आदार, यतिकी आक नाम कळुदव दूतगोळी होचकु ईटीदुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","अदिक नीव नाश माळ्द वस्तुगोळ से सावधानी देल तान तान इक अलग ईटी, हींग आगबाळुल कि नाश इन वस्तु ठहरूस्कु बाद्दा अदा नाश इन वस्तु दा टु येनारा ताकोम कोमी, अदिक ईत्ता प्रकार देल इस्त्राएली छावनी इक भ्रष्ट माळकु अदरी कष्ट दा हाक्क बुळी. ");
INSERT INTO hoy_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","सप्पा व्हान्ना, बेळ्ली अदिक जो बर्तन पीतल अदिक लोहा नव आव, अव यहोवा अन साटी पवित्र आव, अदिक आऊंदा भंडार दा ईटकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","आग लॉकुर जयजयकार माळदुर, अदिक याजक नरसिंगा ऊरूतेला ईत्तुर. अदिक याग लॉकुर नरसिंगा अन्द शब्द केळदुर रा बाक हापाळ धोळ्द आवाज देल आंदुर जयजयकार माळदुर, आग नगर इन दिवाल बिदोत, अदिक लॉकुर तान तान मुंदी टु आ नगर मा येरेदुर, अदिक नगर इक ताकोम कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","अदिक येन गंळ्सुर, येन आर्तेर, येन हारोदोर, येन हाळाबाट्टुर, बल्‍की गोसीगोळ, म्यांडागोळ, मर्रगोळ, गदहागोळ, अदिक यास नगर दा ईरोर, आ सप्पा मुंदरी आंदुर नाश इन वस्तु सम्सकु तलवार देल कोंद बुटुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","आग यहोशू आ येढ्ढु मंळसागोळ से जो आ द्याश इन भेद ताकोमली होगीदुर अंदुन, “तान किर्‍या अन अनुसार आ वेश्या अन मान्या होगकु आकी अदिक जो आकिन हात्ती ईतीदार आंदरी भी तेगुक तरी.” ");
INSERT INTO hoy_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","आग आ येढ्ढु हारोदोर भेदीगोळ अंदर होगकु राहाब इक, अदिक आकिन मोय-आप्प, वार्टुर अदिक सप्‍पा मुंदरी जो आकिन मान्या ईरतोगोर, बल्‍की आकिन सप्‍पा परिवार इक तेगुकु तंदुर, अदिक इस्त्राएल इन छावनी टु व्हार्या कुर्स बुटुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","आग आंदुर नगर इक अदिक जो येनारा अदुर दा ईरोद, सप्‍पा अक बेक्‍की हचकु होताक बुटुर; सिर्फ व्हान्ना, बेळ्ली अदिक जो बर्तन पीतल अदिक लोहा नव ईरव, अवरी आंदुर यहोवा अन भवन इन भंडार दा ईट बुटुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","अदिक यहोशू राहाब वेश्या अदिक आकिन आप्प उन घराना अक, बल्‍की आकिन सप्‍पा लॉकुरी जित्‍ता बिट्ट बुटुर, अदिक ईगासताका आकिन वंश इस्त्राएलीगोळ बीच दा ईरतद, यतिकी जो दूतगोळी यहोशू यरीहो अन भेद ताकोमली कळीदुन आंदरी आक होचकु ईटीदुर. ");
INSERT INTO hoy_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","बाक अदा समय यहोशू इस्त्राएलीगोळ मुंद किर्‍या तिंदुन, अदिक अंदुन, “जो मंळसा येदकु ई नगर यरीहो अक मात्त माळ्यान आव यहोवा अन दी टु श्रापित आदान. याग आव अदुर्द पायवा हाक्यान आग आऊन धोळ पार सोत्तान, अदिक याग आव अदुर फाटकगोळी हचुस्यान आग आऊन श्याण्णेव पार सोतोदान.” ");
INSERT INTO hoy_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","अदिक यहोवा यहोशू अन सांगुळ ईत्तुन; अदिक यहोशू अन्द कीर्ति आ सप्पा द्याश दा फैलुसेत. ");
INSERT INTO hoy_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","लेकीन इस्त्राएलीगोळ भेंट इन वस्तुगोळ बारा दा विश्वासघात माळदुर; मतलब यहूदा वंश इन आकान, जो जेरहवंशी जब्दी अन नातु अदिक कर्मी अन पार ईरोन, आव भेंट इन चिजगोळ दा टु येनारा ताकोम कोंडुन; ई कारण देल यहोवा अन कोप इस्त्राएलीगोळ मा भळकुसेत. ");
INSERT INTO hoy_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","यहोशू यरीहो टु आई हेसुर इन नगर इन हाती, जो बेतावेन टु हतकु बेतेल इन पूर्व अन दी आद, येनारा मंळसागोळी ईद अनकु कळुदुन, “होगकु द्याश इन भेद तरी.” अदिक आ मंळसागोळ होगकु आई नगर इन भेद ताकोंडुर. ");
INSERT INTO hoy_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","अदिक आंदुर यहोशू उन हाती वापस बंदकु अंदुर, “सप्पा लॉकुर अल होगबाळुल, येढ्ढ मुर हजार मंळसा होगकु आई नगर इक जीक्स सकतार; सप्पा लॉकुरी अल होगोद कष्ट कोळबाळ, यतिकी आ लॉकुर थ्वाळासा अच आर.” ");
INSERT INTO hoy_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","इदुरसाटी लगभग मुर हजार लॉकुर अल होदुर; लेकीन आई नगर इन ईरावाळेर मुंद टु ओळेदुर, ");
INSERT INTO hoy_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","आग आई नगर इन ईरावाळेर आंदुर दा टु छत्तीस मुंदुरी कोंद बुट्टुर, अदिक तान फाटक टु शबारीम ताका आंदुर्द पीछा माळकु उतार भाग दा आंदरी कोनतेला होदुर. आग लॉकुर्द मन पिघलुसकु थंडा बिदोत. ");
INSERT INTO hoy_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","आग यहोशू तान कपळा हरदुर, अदिक आव अदिक इस्त्राएली बाट्ट लॉकुर यहोवा अन सन्दुक इन मुंद बाय इन भार देल बिदकु जमीन मा द्यावगा ताका बिदकु ईत्तुर; अदिक आंदुर तान तान ताल्ला मा धुळा हाकदुर. ");
INSERT INTO hoy_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","अदिक यहोशू अंदुन, “हाय, प्रभु यहोवा, नी तान ई प्रजा अक यरदन इन पार यती तंद? येन नामी एमोरिया अन वश दा माळकु नष्ट माळोर साटी तंद्या? भला आगेत कि नाव संतोष माळकु यरदन इन आप्पाटी ईरायदेव! ");
INSERT INTO hoy_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","हाय, प्रभु ना येन अनाईन, याग इस्त्राएलगोळ तान दुश्मनगोळी बेन तोरस्यार! ");
INSERT INTO hoy_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","यतिकी कनानी जाती बल्‍की ई द्याश इन सप्पा ईरावाळेर ईद केळकु नामी घेर्स कोंडार, अदिक नाम हेसुर पृथ्वी मा टु मिटुस कोंडार; बाक नी तान धोळ्द हेसुर इन साटी येन माळ्या?” ");
INSERT INTO hoy_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","यहोवा यहोशू से अंदुन, “येळ, नीदरेग, नी यती ई प्रकार बाय इन भार जमीन मा बिदकु आय? ");
INSERT INTO hoy_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","इस्त्राएलगोळ पाप माळ्यार; अदिक जो वाचा ना आंदुर से तान सांगुळ कटसुसीदीन अदरी आंदुर मुर्द बुटार, आंदुर भेंट इन वस्तुगोळ दा टु ताकोंडुर, बल्‍की चोरी भी माळदुर, अदिक छल माळकु अदरी तान सामान दा ईट कोंडार. ");
INSERT INTO hoy_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ई कारण इस्त्राएली तान दुश्मनगोळ मुंद नीदुरकु ईर सकालुर; आंदुर तान दुश्मनगोळी बेन तोर्सतार, इदुरसाटी कि आंदुर खुद अर्पन इन वस्तु आगेग्यार. अदिक यागासताका नीव तान बीच दा टु भेंट इन वस्तु उन सत्यानाश माळ कोमालीर, आगासताका ना मुंद नीम सांगुळ ईर सकालीन. ");
INSERT INTO hoy_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","येळ, प्रजा अन लॉकुरी पवित्र माळ, आंदुर अन; ‘व्हातर्या ताका तान तान इक पवित्र माळकु ईटी; यतिकी इस्त्राएली इन परमेश्वर ईद अनतान, “हे इस्त्राएल, नीन बीच दा भेंट इन वस्तु आद; इदुरसाटी यागासताका नी अर्पन इन वस्तु इक तान बीच दा टु दुर माळाल आगासताका नी तान दुश्मनगोळ मुंद नीदुरकु ईर सकाल.” ");
INSERT INTO hoy_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","नाळ व्हातर्या नीम सप्पा मुंदरी यहोवा अन मुंद नीदरोद बिद्दीत, सप्पा परिवार समूह यहोवा अन मुंद पेश आदर, यहोवा ऊंद परिवार समूह अक नीवळुस्यान, आग सिर्फ अदा परिवार यहोवा अन मुंद नीदरीत, आग आ परिवार समूह दा टु यहोवा ऊंद वंश इक नीवळुस्यान. आग बस अदा वंश यहोवा अन मुंद निदुरकु ईत्तीत, आग यहोवा आ वंश इन हर परिवार इन परख माळ्यान, आग यहोवा आ वंश दा टु ऊंद परिवार इक नीवळुस्यान, आग अद परिवार आबना यहोवा अन मुंद नीदुरकु ईत्तीत, आग यहोवा आ परिवार इन हर मंळसा अन जाँच माळ्यान. ");
INSERT INTO hoy_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","आग जो मंळसा भेंट इन वस्तु ईटकु हुळसुसकु आदान, अदिक जो येनारा आऊन ईतीदाद बेक्‍की दा हाक्कु होताक्कु आदीत; यतिकी आव यहोवा अन वादा अक मुरदान, अदिक इस्त्राएल दा अनुचित कर्म माळ्यान.’” ");
INSERT INTO hoy_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","यहोशू व्हातर्या येदकु इस्त्राएलगोळी वंश वंश माळकु हात्ती वोतुन, अदिक यहूदा अन वंश हुळसुसकु आत; ");
INSERT INTO hoy_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","आग आव यहूदा अन परिवार इक हात्ती माळदुन, अदिक जेरह वंशगोळ कुल हुळसुसकु आत; बाक जेरह वंशगोळ घराना अन ऊंद ऊंद मंळसा अक हात्ती तंदुन, अदिक जब्दी हुळसुसकु आदुन; ");
INSERT INTO hoy_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","आग यहोशू ई परिवार इन सप्पा मंळसागोळी यहोवा अन मुंद बरली हेळदुन, यहूदा कर्मी इन पार आकान इक नीवळुसदुन, कर्मी जब्दी इन पार ईरोन अदिक जब्दी जेरह उन पार ईरोन. ");
INSERT INTO hoy_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","आग यहोशू आकान से अनली कुरतुन, “हे नान पारा, इस्त्राएल उन परमेश्वर उन महिमा माळ, अदिक आऊन स्तुति माळ; अदिक जो येनारा नी माळ्या अद नानी हेळबुळ, अदिक नान से येनु छप्सबाळ.” ");
INSERT INTO hoy_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","आकान यहोशू उक उत्तर कोट्टुन, “सहीदा ना इस्त्राएल उन परमेश्वर यहोवा अन विरूद्‍ध पाप माळीन, अदिक ई प्रकार ना माळीन, ");
INSERT INTO hoy_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","कि याग नानी लूट दा शिनार द्याश इन ऊंद सुंदर ओढ़ना, अदिक येढ्ढ किलो बेळ्ली, अदिक आर्धा किलो व्हान्ना अन ऊंद ईटा कांळ्सत, आग ना अऊर्द लालच माळकु अवरी ईट बुट्टीन; अव नान ड्यारा अन बुळ्क जमीन दा नळ्सकु आव, अदिक सब से ल्यालमा बेळ्ली आद.” ");
INSERT INTO hoy_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","आग यहोशू थ्वाळासा लॉकुरी कळुदुन, अदिक आंदुर आ ड्यारा दा होदुर; अदिक येन नोळदुर, कि अव वस्तु आऊन ड्यारा दा नळ्सकु आव, अदिक सप्पा अन ल्यालमा बेळ्ली आद. ");
INSERT INTO hoy_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","अवरी आंदुर ड्यारा दा टु तेगुकु यहोशू अदिक सप्पा इस्त्राएलीगोळ हाती तनकु यहोवा अन मुंद ईट बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","आग सप्पा इस्त्राएलगोळ सांगुळ यहोशू जेरहवंशी आकान उक, अदिक आ बेळ्ली अदिक आ ओढ़ना अक अदिक व्हान्ना अन ईटा अक, अदिक आऊन पोर पारगोळी, अदिक आऊन वस्तागोळी, गदहा अदिक मर्र म्यांढ्ढा अक, अदिक आऊन ड्यारा अक, मतलब जो येनारा आऊन ईरोद आ सप्पा अक आकोर हेसुर इन घाटी दा वोतुन. ");
INSERT INTO hoy_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","आग यहोशू आऊन से अंदुन, “नी नामी यती कष्ट कोट्या? ईंद इन दिन यहोवा नीनी कष्ट कोट्टान.” आग सप्पा इस्त्राएलगोळ आऊन मा पथराव माळदुर; अदिक आंदरी बेक्‍की दा हाक्कु होताकदुर, अदिक आंदुर म्याकुच कल्लगोळ हाक बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","अदिक आंदुर आऊन म्याकुच कल्लगोळ्द धोळ्द ढग माळ कोंडुर जो ईंद ताका माळकु आद; आग यहोवा अन भळकुसकु कोप शांत आगेत. ई कारण आ जागा अन हेसुर ईंद ताका आकोर इन घाटी बिदकु आद ");
INSERT INTO hoy_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","आग यहोवा यहोशू से अंदुन, “अंजबाळ, अदिक नीन मन कच्चा आगबाळुल; नेळु कटकु सप्पा योध्दागोळी सांगुळ हुडु, अदिक आई नगर मा चळाई माळ; केळ, ना आई नगर इन राजा अक आऊन प्रजा अदिक आऊन नगर अदिक जागा अन सांगुळ नीन वश दा माळ कोंडीन. ");
INSERT INTO hoy_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","अदिक ह्यांग नी यरीहो नगर अदिक अदुर राजा से माळ्द हांग अच आई नगर अदिक अदुर राजा अन सांगुळ भी माळेत; सिर्फ नीव जनावरगोळ सांगुळ आऊन लुट रा तान साटी ताकोम सक्या; इदुरसाटी आ नगर इन हींद तान मंळसागोळी घात दा हचबुळी.” ");
INSERT INTO hoy_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","अत: यहोशू सप्पा योध्दागोळ सांगुळ आई नगर मा चळाई माळोद तैयारी माळदुन; अदिक यहोशू तीस हजार मंळसागोळी जो शूरवीर ईरोर नीवळुसकु ईळ्लकी का आग्या कोटकु कळुदुन. ");
INSERT INTO hoy_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","अदिक आंदरी ईद आग्या कोट्टुन, “केळी, नीव आ नगर इन हिंद इन दी घात हचकु कुर्तकु ईरेतीर; नगर टु हापाळ दुर होगबाळेतीर, अदिक सप्पा लॉकुर तैयार ईरेतीर; ");
INSERT INTO hoy_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","अदिक ना तान सप्पा साथीगोळ सांगुळ आ नगर इन हाती होगाईन, अदिक याग आंदुर पयले अन घाई नाम सामना माळोर साटी होट्टार, आग नाव आंदुर मुंदु टु ओळेव; ");
INSERT INTO hoy_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","आग आंदुर ईद सोचकु, कि आंदुर पयले अन घाई नाम मुंदु टु ओळेत्यार, नाम्द पीछा माळ्यार; ई प्रकार नाव आंदुर मुंदु टु ओळकु आंदरी नगर टु दुर तेगुकु वोतेव; ");
INSERT INTO hoy_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","आग नीव तान होचकोमकु जागा मा टु बरेतीर अदिक नगर मा अधिकार माळ कोमेतीर, नीम परमेश्वर यहोवा नीमी जिकसोद ताकत कोट्टान. ");
INSERT INTO hoy_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","नीमी अदा माळ पायजे जो यहोवा अनतान, नान मा नजर ईटी, ना नीमी आक्रमण इन आदेश कोळाईन. नीव याग नगर मा अधिकार माळीर आग अदरी होताक कोमेतीर.” ");
INSERT INTO hoy_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","आग यहोशू आ सैनिकगोळी आंदुर्द होचकोमोद जागा मा कळु बुट्टुन अदिक हादी कायली कुरतुन, आंदुर बेतेल अदिक आई नगर इन बीच ऊंद जागा मा होदुर, ईद जागा आई नगर इन पश्चिम दा ईरोद. यहोशू तान लॉकुर सांगुळ ईळ्लक तीम अल्या ईत्तुन. ");
INSERT INTO hoy_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","यहोशू व्हातर्या येद्दुन, अदिक लॉकुर गिनती माळकु इस्त्राएली स्याणागोळ सांगुळ लॉकुर मुंद मुंद आई नगर इन दी होदुन. ");
INSERT INTO hoy_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","अदिक आऊन सांगुळोर सप्पा योध्दा येरेदुर, अदिक आई नगर इन हाती पोहचुस्कु आऊन मुंद उत्तर इन दी ड्यारा हाक्क बुट्टुर, अदिक आंदुर अदिक आई नगर इन बीच ऊंद घाटी ईरोद. ");
INSERT INTO hoy_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","आग आव लगभग अईद हजार मंळसा नीवळुसकु बेतेल अदिक आई नगर इन बीच दाकळोद इन पश्चिम इन दी आंदरी घात दा कुरसुस बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","अदिक याग लॉकुर नगर इन उत्तर इन सप्पा सेना अक अदिक आऊन पश्चिम इन दी घात दा कुर्तकु ईरोर आंदरी भी ठिकाणा मा माळ कोंडुन, आग यहोशू अदा दिशी ईळ्लकी घाटी इन बीच होदुन. ");
INSERT INTO hoy_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","याग आई नगर इन राजा ईद नोळदुन, आग आंदुर फुर्ती माळकु व्हातर्या येद्दुर, अदिक राजा तान सप्पा प्रजा अक हुडुकु इस्त्राएलीगोळ मुंद आंदुर लळुसली तेगुकु ठहरूस्द जागा मा जो अराबा अन मुंद आद पोहचुसदुन; अदिक आव ईला जानसोन कि नगर इन हिंद लॉकुर घात हचकु कुर्तकु आर. ");
INSERT INTO hoy_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","आग यहोशु अदिक सप्पा इस्त्राएलीगोळ पीछा माळोर साटी कारू कारूकु कार्सकु आदुर; अदिक आंदुर यहोशू अन पीछा माळतेला नगर टु दुर होटोदुर. ");
INSERT INTO hoy_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","आग नगर इन सप्पा लॉकुर इस्त्राएलीगोळ्द पीछा माळोर साटी कारूकु आदुर; अदिक आंदुर यहोशू उन पीछा माळतेला नगर टु दुर होट्ट बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","अदिक ना आई नगर दा अदिक ना बेतेल दा याऊ मंळसा ईतीदील, जो इस्त्राएल इन पीछा माळोर साटी ईला होगीदान; अदिक आंदुर नगर इक खुला बिटकु इस्त्राएलीगोळ्द पीछा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","आग यहोवा यहोशू से अंदुन, “तान कय इन बर्छा आई नगर इन दी वाळुस; यतिकी ना अदरी नीन कय दा कोट्ट बुळाईन.” अदिक यहोशू तान कय इन बर्छा अक नगर इन दी वाळुसदुन. ");
INSERT INTO hoy_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","आऊन कय वाळुसतेला अच जो लॉकुर घात दा कुर्तकु ईरोर आंदुर झटपट तान जागा मा टु येद्दुर, अदिक वोळकु नगर दा प्रवेश माळदुर अदिक अदरी ताकोम कोंडुर; अदिक झटपट अल बेक्‍की हच बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","याग आई नगर इन लॉकुर हिंद तिर्गकु नोळदुर, रा येन नोळदुर, कि नगर इन धुंगा आकाश इन दी येळेत्याद; अदिक आंदरी ना ईत्त वोळोद शक्ति ईत्त, अदिक ना रा आत्त, अदिक जो लॉकुर आळी इन दी वोळोर आंदुर तिर्गकु तान खेदाळसा वाळेर मा बिद्दुर. ");
INSERT INTO hoy_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","याग यहोशू अदिक सप्पा इस्त्राएलगोळ नोळदुर कि घातीगोळ नगर इक ताकोम कोंडुर, अदिक अदुर धुंगा येळेत्याद, आग वापस बंदकु आई नगर इन मंळसागोळी कोनली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","आग आ सैनिक जो होचकोमकु ईरोर, युध्द दा मदत साटी नगर टु व्हार्या बंदुर. आई नगर इन सैनिक इन येढ्ढु दी इस्त्राएल ईनोर सैनिक ईरोर, आई नगर ईनोर सैनिक जाल दा फसुसीगिदुर. इस्त्राएल आंदरी पराजीत माळदुर. आंदुर आगासताका लळुसतेला ईत्तुर यागासताका आई इन ऊंद भी मंळसा जित्ता ईला ईरोन, आंदुर दा टु याऊ वोळ सकिदील. ");
INSERT INTO hoy_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","लेकीन आई अन राजा जित्ता बिटकु आदुन. यहोशू उन सैनिक आऊक आऊन हाती तंदुर. ");
INSERT INTO hoy_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","युध्द इन समय, इस्त्राएल इन सेना आई नगर इन सैनिकगोळी मैदानगोळ दा अदिक मरूभूमी दा ढकलुसदुर अदिक ई प्रकार इस्त्राएल इन सेना आई नगर टु सप्पा सैनिकगोळी कोन्नोद क्याल्सा मैदानगोळ दा अदिक मरूभूमी दा पुरा माळदुर. आग इस्त्राएल नोर सप्पा सैनिक आई इक बंदुर. आग आंदुर आ लॉकुरी जो नगर दा जीत्ता ईरोर तलवार देल कोंद बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","आ दिशी आई नगर इन सप्पा लॉकुर सोत्तुर, अल हन्नेळ हजार आर्तेर अदिक मंळसागोळ ईरोर. ");
INSERT INTO hoy_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","यतिकी यागासताका यहोशू आई नगर इन सप्पा निवासीगोळ्द सत्यानाश माळ कोंडीदिल आगासताका तान कय, यदुर देल बर्छा वाळुसीदुन, बाक जेळदीदील. ");
INSERT INTO hoy_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","यहोवा अन आ आग्या अन अनुसार जो आव यहोशू उक कोटीदुन इस्त्राएलीगोळ जनावर अदिक नगर इन लुट तान माळ कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","आग यहोशू आई नगर इक होताकसुस दुन अदिक अदरी सदा साटी खंडर माळ कोंडुन: अद ईंद ताका भर भंगाळ आद. ");
INSERT INTO hoy_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","अदिक आई नगर इन राजा अक आव द्यावगा ताका मार्र मा लटकुसकु ईटदुन; अदिक सूर्य मुळ्क्त मुळ्क्त यहोशू उन आग्या देल आऊन लाश मार्र मा टु ईळ्सकु नगर इन फाटक इन मुंद भीटकु आत, अदिक आऊन मा कल्लगोळ्द धोळ्द ढेर हाक्कु आत, जो ईंद ताका माळकु आद. ");
INSERT INTO hoy_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","आग यहोशू इस्त्राएल उन परमेश्वर यहोवा अन साटी एबाल पहाळी मा ऊंद वेदी माळसुसदुन, ");
INSERT INTO hoy_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","ह्यांग यहोवा अन दास मूसा इस्त्राएलगोळी आग्या कोटीदुन, अदिक ह्यांग मूसा अन व्यवस्था अन किताब दा लिख्सकु आद, आव हींग कल्लगोळ्द ऊंद वेदी माळदुन यदुर मा यातोदु प्रकार इन औजार नळ्सकु आगीदील. अदिक अदुर मा आंदुर यहोवा अन साटी होमबली अदिक मेलबली येर्सदुर. ");
INSERT INTO hoy_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","अदा जागा मा यहोशू इस्त्राएलीगोळ मुंद आ कल्लगोळ म्याकुच मूसा अन व्यवस्था, जो आव लिखसीदुन, अदुर्द नकल माळसुसदुन. ");
INSERT INTO hoy_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","अदिक आंदुर, येन देशी येन परदेशी, इस्त्राएल इन सप्पा लॉकुर पवित्र संदुक इन नाकु दी नीदुरकु ईरोर. आंदुर आ लेवीवंशी याजकगोळ मुंद नीदुरकु ईरोर, जो यहोवा अन वादा अन पवित्र सन्दुक इक हुडुकु नळोर. इस्त्राएली अदिक गैर इस्त्राएली सप्पा लॉकुर अल नीदुरकु ईरोर अदिक अन्य आरधा लॉकुर गरिज्जीम पर्वत इन मुंद नीदुरकु ईरोर. यहोवा अन सेवक मूसा आंदुर से हिंग माळली अंदीदिन. मूसा आंदुर से हिंग माळोरसाटी ई आशीर्वाद इन साटी अंदीदुन. ");
INSERT INTO hoy_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","आग यहोशू व्यवस्था अन सप्पा वचनगोळी वाचुसदुन. यहोशू आशीर्वाद अदिक अभिशाप वाचुसदुन. आव सप्‍पा येनारा आ तरीका देल वाचुसदुन, याता तरीका देल अद व्यवस्था अन किताब दा लिख्सकु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","इस्त्राएल इन सप्‍पा लॉकुर अल जमा ईरोर, सप्‍पा आर्तेर, चिकोर अदिक इस्त्राएल इन लॉकुर सांगुळ ईरावाळेर सप्पा विदेशी अल जमा ईरोर अदिक यहोशू मूसा अन द्वारा कोटकु आग्‍याव हर ऊंद आदेश उक वाचुसदुन. ");
INSERT INTO hoy_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","ईद केळकु हित्ती, एमोरी, कनानी, परिज्जी, हिब्बी, अदिक यबूसी, यास राजा यरदन इन ईप्पाटी पहाळी द्याश दा अदिक ल्यालमा अन द्याश दा, अदिक लबानोन इन मुंद इन महासागर इन किनारा मा ईरतोगोर, ");
INSERT INTO hoy_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","आंदुर ऊंद मन आगकु यहोशू अदिक इस्त्राएलीगोळ सांगुळ लळाई माळोर साटी जमा आदुर. ");
INSERT INTO hoy_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","याग गिबोन इन निवासीगोळ केळदुर कि यहोशू यरीहो अदिक आई नगर से येन येन माळदुर, ");
INSERT INTO hoy_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","आग आंदुर छल माळदुर, अदिक राजदूतगोळ भेष माळकु तान गदहागोळ मा हाळोव बॉरागोळ, अदिक हाळोव हरदव, अदिक जोळ्सदव दाखमधु अन चिलागोळ कटदुर ");
INSERT INTO hoy_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","तान कालगोळ दा हाळोव केरू, अदिक मय मा हाळोव कपळा हाक्कु, अदिक तान भोजन इन साटी वंळ्गींद अदिक बुर्सी हद्द रोट्टी हुळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","आग आंदुर गिलगाल इन छावनी दा यहोशू उन हाती होगकु आऊन से अदिक इस्त्राएली मंळसागोळ से अनली कुरतुर, “नाव दुर द्याश टु बंदेव; इदुरसाटी ईग नीव नाम से वादा माळी.” ");
INSERT INTO hoy_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","इस्त्राएली मंळसागोळ आ हिब्बीगोळ से अंदुर, “येन मालुम नीव नाम बीच दा का ईरतीदीर; बाक नाव नीम से वादा ह्यांग माळेव?” ");
INSERT INTO hoy_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","आंदुर यहोशू से अंदुर, “नाव नीनोर दास हुयेव.” आग यहोशू आंदुर से अंदुन, “नीव यार हुईर? अदिक येल टु बंदीर?” ");
INSERT INTO hoy_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","आंदुर आऊन से अंदुर, “नीन दास हापाळ दुर इन द्याश टु नीन परमेश्वर यहोवा अन हेसुर केळकु बंदार; यतिकी नाव ईद सप्पा केळेव, मतलब आऊन किर्ती अदिक जो येनारा आव मिस्त्र दा माळदुन, ");
INSERT INTO hoy_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","अदिक जो येनारा आव एमोरिया अन येढ्ढु राजागोळ सांगुळ माळदुन जो यरदन इन आप्पाटी पूर्व दिशा दी ईरतोगोर, मतलब हेशबोन इन राजा सीहोन से, अदिक बाशान उन राजा ओग से जो अश्तारोत दा ईरोन. ");
INSERT INTO hoy_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","इदुरसाटी नाम मान्यागोळोर बाट्टुर अदिक नाम द्याश इन सप्पा निवासीगोळ नाम से अंदुर, कि हादी इन साटी तान सांगुळ भोजन इन सामान हुळकु आंदुर से सीकली होगी, अदिक आंदुर से अनेतीर, कि नाव नीमोर दास हुयेव; इदुरसाटी ईग नीव नाम से वादा माळी. ");
INSERT INTO hoy_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","नामव रोट्टीगोळी नोळी, याग नाव लॉकुर मान्ना बीटीदेव आग ईव बिस्स अदिक ताजा ईरव. लेकीन ईग नी नोळेत्या कि ईव वंळ्गेदव अदिक ईवरी बुर्सी हत्तेग्याद. ");
INSERT INTO hoy_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","बाक ईव अंगुर इन रास्सा अन चिला नाव तुमीदेव, आग रा व्हाशेव ईरव, लेकीन नोळी ईग ईव हरदोग्याव; अदिक नामव ईव कपळा अदिक केरूगोळ हापाळ लम्बा यात्रा अन कारण पुराना आगेग्याव.” ");
INSERT INTO hoy_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","आग आ मंळसागोळ यहोवा से बीना सलाह ताकोमकु आंदुर भोजन दा टु थ्वाळासा तिंद कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","आग यहोशू आंदुर से मेल माळकु आंदुर से ईद वादा माळदुन, कि नीमी जीत्ता बीट्टेव; अदिक मंडली इन स्याणागोळ आंदुर से किर्‍या तिंदुर. ");
INSERT INTO hoy_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","आंदुर सांगुळ वादा माळदुर मुर दिन इन बाद्दा आंदरी ईद समाचार सिक्त, कि आंदुर नाम हात्तीगोळोर ईरावाळेर लॉकुर उर, अदिक नाम बीच दा अच बसुस्कु आर. ");
INSERT INTO hoy_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","आग इस्त्राएली अल टु होटकु तीसरा दिशी आंदुर नगरगोळी यूर हेसुर गिबोन, कपीरा, बेरोत, अदिक किर्यत्यारीम दा पोहचुसदुर. ");
INSERT INTO hoy_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","अदिक इस्त्राएलगोळ आंदरी कोंदीदील, यतिकी मंडली इन स्याणागोळ आंदुर सांगुळ इस्त्राएल ईनव परमेश्वर उन किर्‍या तिंदीदुर. आग सप्पा मंडली इन लॉकुर स्याणागोळ्द विरूद्ध कुळकुळसली हतदुर. ");
INSERT INTO hoy_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","आग सप्पा प्रधानगोळ सप्पा मंडली से अंदुर, “नाव आंदुर से इस्त्राएल इन परमेश्वर उन किर्‍या तिंदेव, इदुरसाटी ईग नाव आंदरी कय हच सकालेव. ");
INSERT INTO hoy_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","नाव आंदुर से ईदा माळेव कि आ किर्‍या अन अनुसार नाव आंदरी जीत्ता बीट्ट बुट्टेव, ईलारा नाम्द तिंद किर्‍या अन कारण नाम मा क्रोध बीद्दीत.” ");
INSERT INTO hoy_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","बाक स्याणागोळ आंदुर से अंदुर, “आंदुर जीत्ता बिटकु आगुल.” अत: स्याणागोळ ईद वचन इन अनुसार आंदुर सप्पा मंडली इन साटी हुळ्ली कडावाळेर अदिक नीर तुमावाळेर आदुर. ");
INSERT INTO hoy_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","बाक यहोशू गिबोन नगर इन लॉकुरी कारूकु अंदुन, “नीव रा नाम बीच दा का ईरतीर, बाक नीव नाम से ईद अनकु यती छल माळदीर, कि नाव नीम से हापाळ दुर ईरतेव? ");
INSERT INTO hoy_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","इदुरसाटी ईग नीव श्रापित आईर, अदिक नीम दा टु याऊ हिंग ईरतीदील जो दास, मतलब नान परमेश्वर उन भवन इन साटी हुळ्ली कडावाळा अदिक नीर तुमावाळा ईरतीदील.” ");
INSERT INTO hoy_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","आंदुर यहोशू उक उत्तर कोट्टुर, “नीन दासगोळ्द ईद सहीदा हेळकु आगीत, कि नीन परमेश्वर यहोवा तान दास मूसा अक आग्या कोटीदुन कि नीमी अद सप्पा द्याश कोळुल, अदिक आंदुर सप्पा ईरावाळेरळ्द नीम मुंदु टु सर्वनाश माळुल; इदुरसाटी नाम लॉकुरी नीम कारण देल तान जीवगोळ्द लाले बीद्दव, इदुरसाटी नाव हिंग क्याल्सा माळदेव. ");
INSERT INTO hoy_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","अदिक ईग नाव नीन वश दा आयेव, ह्यांग व्यवहार नीनी वळ्लीद हततद अदिक वळ्लीद सम्सतद हांगा नी नाम सांगुळ माळ.” ");
INSERT INTO hoy_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","आग आव हांग अच माळदुन, अदिक आंदरी इस्त्राएलगोळ कय दा टु हिंग उळ्सदुन, कि आंदुर आंदरी कोनोर साटी होगीदिल. ");
INSERT INTO hoy_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","लेकीन यहोशू अदा दिशी आंदरी मंडली इन साटी, अदिक जो जागा यहोवा अन साटी नीवळुसकु आगीत आऊन वेदी साटी, हुळ्ली कडावाळेर अदिक नीर तुमावाळेर नीवळुसदुन, ह्यांग कि ईंद ताका आद. ");
INSERT INTO hoy_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","याग यरूशलेम उन राजा अदोनीसेदेक केळदुन कि यहोशू आई नगर इक ताकोम कोंडुन, अदिक अदुर सत्यानाश माळ कोंडुन, अदिक आव यरीहो अदिक अलेव राजा से माळदुन हांग अच आई नगर अदिक अदुर राजा से माळदुन, अदिक ईद भी केळदुन कि गिबोन इन निवासीगोळ इस्त्राएली से मेल माळदुन, अदिक आंदुर बीच ईरली कुरतार, ");
INSERT INTO hoy_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","आग आंदुर हापाळ अंजेदुर, यतिकी गिबोन धोळ्द नगर बल्की राजनगर इन तुल्य अदिक आई नगर से धोळ्द ईरोद, अदिक अलेर सप्पा निवासी शूरवीर ईरोर. ");
INSERT INTO hoy_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","इदुरसाटी यरूशलेम इन राजा अदोनीसेदेक इन हेब्रोन इन राजा होहाम, यर्मूत इन राजा पिराम, लाकीश ओन राजा यापी, अदिक एग्लोन इन राजा दबीर इन हाती ईद बातणी कळुदुन: ");
INSERT INTO hoy_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“नान हाती बंदकु नान मदत माळी, अदिक नळी नाव गिबोन इक कोनाता; यतिकी आव यहोशू अदिक इस्त्राएलगोळ से मेल माळ कोंडुन.” ");
INSERT INTO hoy_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","इदुरसाटी यरूशलेम, हेब्रोन, यर्मूत, लाकीश, अदिक एग्लोन इन अईदु एमोरी राजागोळ तान तान सप्पा सेना जमा माळकु चळाई माळ कोंडुर, अदिक गिबोन इन मुंद ड्यारा हाक्कु अदुर से युध्द छेळ्स बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","आग गिबोन इन निवासीगोळ गिलगाल इन छावनी दा यहोशू उन हाती ईद बातणी कळुदुर, “तान दासगोळ दी टु नी तान कय सरकुस बाळेत; जल्दी नाम हाती बंदकु नामी ऊळ्स, अदिक नाम्द मदत माळ; यतिकी पहाळी मा ईरावाळेर एमोरिया अन सप्पा राजा नाम विरूद्‍ध जमा आग्यार.” ");
INSERT INTO hoy_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","आग यहोशू सप्पा योध्दागोळ अदिक सप्पा शूरवीरगोळ सांगुळ गिलगाल टु नळदुन. ");
INSERT INTO hoy_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","अदिक यहोवा यहोशू से अंदुन, “आंदुर से अंजबाळ, यतिकी ना आंदरी नीन कय दा माळ बुटीन; आंदुर दा ऊंद भी मंळसा नीन मुंद टिक्स सकतीदिल.” ");
INSERT INTO hoy_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","आग यहोशू रातोरात गिलगाल टु होगकु एकाएक आंदुर मा चढ़ाई माळदुन . ");
INSERT INTO hoy_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","आग यहोवा हिंग माळदुन कि आंदुर इस्त्राएलगोळ से घबरूसेदुर, अदिक इस्राएली गिबोन इन हाती आंदुर्द धोळ्द संहार माळदुर, अदिक बेथोरोन इन चळाव मा आंदुर्द पीछा माळकु अजेका अदिक मक्केदा ताका आंदरी कोनतेला होदुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","बाक आंदुर इस्त्राएलगोळ मुंदु टु ओळकु बेथोरोन इन तराई मा बंदुर, आग अजेका पोहचुसा ताका यहोवा आकाश टु धोड्डेव धोडडेव गारपीट आंदुर मा बरसुसली कुरतुन, अदिक आंदुर सोतोदुर; जो गारपीट देल सोत्तुर आंदुर गिनती इस्त्राएलगोळ तलवार से सोतकु आदुर आंदुर से येक्‍कुल ईरोद. ");
INSERT INTO hoy_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","आ समय, मतलब याता दिशी यहोवा एमोरिगोळी इस्त्राएलगोळ वश दा माळदुन, आ दिशी यहोशू यहोवा से इस्त्राएलगोळी नोळतेला ई प्रकार अंदुर, “हे सूर्य, नी गिबोन मा, अदिक हे चन्द्रमा, नी अय्यालोन इन तराई इन म्याकुच थाम्सकु ईर.” ");
INSERT INTO hoy_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","अदिक सूर्य आ समय ताका थाम्सकु ईत्त, अदिक चंद्रमा आ समय ताका ठहरूस्कु ईत्त, यागासताका आ जाती इन लॉकुर तान दुश्मनगोळ से बदला तांकोडीदील. येन ईद मात याशार हेसुर इन किताब दा लिख्सकु हैलेच कि सूर्य आकाश मण्डल इन बीचोबीच ठहरूस्कु ईत्त, अदिक लगभग पुरा दिन ताका मुळकीदिल? ");
INSERT INTO hoy_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","न रा अदुर से पयले यातोदु हिंग दिन आत अदिक न अदुर बाद्दा, यदुर दा यहोवा यातारा मंळसा अन केळीदान; यतिकी यहोवा रा इस्त्राएली इन दी टु लळुसोन. ");
INSERT INTO hoy_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","आग यहोशू सप्पा इस्त्राएलीगोळ सांगुळ गिलगाल इन छावनी इक वापस होटोदुन. ");
INSERT INTO hoy_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","आंदुर अईदु राजा ओळकु मक्केदा नगर इन हाती इन गुफा दा होच कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","आग यहोशू उक ईद समाचार सिक्त, “अईदु राजा मक्केदा अन हाती इन गुफा दा होचकोमकु नामी सिक्यार.” ");
INSERT INTO hoy_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","यहोशू अंदुन, “गुफा अन बाय मा धोड्डेव धोड्डेव कल्ल हचकु अऊर्द देखभाल इन साटी मंळसागोळी अदुर हाती कुर्सबुळी; ");
INSERT INTO hoy_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","लेकीन नीव ठहरूसबाळी, तान दुश्मनगोळ्द पीछा माळकु आंदुर दा टु जो जो पिछळुस्यार आंदरी कोंद बुळी, आंदरी तान तान नगर दा प्रवेश माळोद मौका कोळबाळी; यतिकी नीम परमेश्वर यहोवा आंदरी नीम कय दा माळ कोंडान.” ");
INSERT INTO hoy_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","याग यहोशू अदिक इस्त्राएली आंदुर संहार माळकु आंदरी नष्ट माळ कोंडार, अदिक आंदुर दा टु जो उळदोग्यार आंदुर तान तान गढ़वाळा नगर दा होक्कदुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","आग सप्पा लॉकुर मक्केदा अन छावनी इक यहोशू उन हाती सुरक्षित वापस बंदुर; अदिक इस्त्राएलीगोळ विरूद्‍ध याऊ बाय दा टु ऊंद आवाज भी तेगदीदील. ");
INSERT INTO hoy_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","आग यहोशू आग्या कोट्टुन, “गुफा अन बाय खोल्सकु आ अईदु राजागोळी नान हाती तेगुकु तरी.” ");
INSERT INTO hoy_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","आंदुर हिंग अच माळदुर, अदिक यरूशलेम, हेब्रोन, यर्मूत, लाकीश, अदिक एग्लोन उन राजा अईदु राजागोळी गुफा दा टु आऊन हाती तेगुकु तंदुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","याग आंदुर आ राजागोळ इक यहोशू उन हात्ती तेगुकु तंदुर, आग यहोशू इस्त्राएल इन सप्पा मंळसागोळी कारूकु तान सांगुळ नळावाळेर योध्दागोळ अधिकारीगोळ से अंदुर, “हाती बंदकु तान तान काल ई राजागोळ कुतक्या मा ईटी.” अदिक आंदुर हाती होगकु तान तान काल आंदुर कुतक्या मा ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","आग यहोशू आंदुर से अंदुन, “अंज बाळी, अदिक न नीम मन कच्चा आगुल; हिम्मत माळकु मजबुत ईरी; यतिकी यहोवा नीम सप्पा दुश्मनगोळ से यार से नीव लळुसावाळेर आईर हिंगा माळ्यान.” ");
INSERT INTO hoy_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","ईदुर बाद्दा यहोशू आंदरी कोनसुस बुट्टुन, अदिक अईद मार्रगोळ मा लटकुस बुट्टुन. अदिक आंदुर द्यावगा ताका आ मार्रगोळ मा लटकुसकु ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","सूर्य मुळ्क्त मुळ्कत यहोशू से आग्या पाऊसकु लॉकुर आंदरी मार्र मा टु ईळ्सकु अदा गुफा दा येल आंदुर होचकोमकु ईरोर अल हाक बुट्टुर, अदिक आ गुफा अन बाय मा धोड्डेव धोड्डेव कल्ल ईट बुट्टुर, अव ईंद ताका अल्या ईटकु आव. ");
INSERT INTO hoy_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","अदा दिशी यहोशू मक्केदा नगर इक ताकोम कोंडुन, अदिक आऊक तलवार देल कोंदुन, अदिक आऊन राजा अन सत्यानाश माळदुन, अदिक यास प्राणी आंदुर दा ईरव आ सप्पा दा टु यारीकु जीत्ता बिटीदील; अदिक ह्यांग आव यरीहो अन राजा अन सांगुळ माळीदुन हांग अच मक्केदा अन राजा से भी माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","आग यहोशू सप्पा इस्त्राएली सांगुळ मक्केदा टु नळकु लिब्ना नगर अक होदुन, अदिक लिब्ना से लळुसदुन; ");
INSERT INTO hoy_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","अदिक यहोवा आऊक भी राजा सांगुळ इस्त्राएली इन कय दा माळ कोंडुन; अदिक यहोशू आऊक अदिक अलेर सप्पा प्राणीगोळी तलवार देल कोंदुन; अदिक अदुर दा टु यारीकु भी जीत्ता बिटीदील; अदिक अलेव राजा सांगुळ हांग अच व्यवहार माळदुर ह्यांग आव यरीहो अन राजा अन सांगुळ माळदुन. ");
INSERT INTO hoy_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","बाक यहोशू सप्पा इस्त्राएलीगोळ सांगुळ लिब्ना नगर टु नळुकु लाकीश नगर इक होदुन, अदिक आऊन विरूद्‍ध छावनी हाक्कु लळुसदुन; ");
INSERT INTO hoy_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","अदिक यहोवा लाकीश उक इस्त्राएल इन कय दा माळ कोंडुन, अदिक दुसरा दिशी आव आऊक जीत्स कोंडुन; अदिक ह्यांग आव लिब्ना नगर इन सप्पा प्राणीगोळ इक तलवार देल कोंदीदुन हांग अच आव लाकीश नगर से भी माळदुन. ");
INSERT INTO hoy_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","आग गेजेर उन राजा होराम लाकीश नगर इन मदत माळोर साटी येरेदुन; अदिक यहोशू लॉकुर सांगुळ आऊक भी हिंग बळदुन कि आऊन साटी यारीकु जीत्ता बिटीदिल. ");
INSERT INTO hoy_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","बाक यहोशू सप्पा इस्त्राएली सांगुळ लाकीश नगर टु नळुकु एग्लोन नगर इक होदुन; अदिक आऊन विरूद्‍ध छावनी हाक्कु युध्द माळली कुरतुन; ");
INSERT INTO hoy_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","अदिक अदा दिशी आंदुर अदरी ताकोम कोंडुर, अदिक अदुर दा ईरावाळेर सप्पा प्राणीगोळी तलवार देल कोंदुर; अदिक अदा दिशी ह्यांग आव लाकीश नगर इन सप्पा प्राणीगोळ्द सत्यानाश माळ कोंडुन हांगा आव एग्लोन नगर से भी माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","बाक यहोशू सप्पा इस्त्राएलीगोळ सांगुळ एग्लोन नगर टु नळुकु हेब्रोन नगर इक होदुन, अदिक अदुर से भी लळाई माळदुन; ");
INSERT INTO hoy_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","अदिक आंदुर अदरी ताकोम कोंडुर, अदिक अदरी अदिक अदुर राजा अदिक सप्पा प्राणीगोळी तलवार देल कोंदुर; ह्यांग यहोशू एग्लोन नगर से माळदुन हांग अच आव हेब्रोन नगर दा भी यारीकु जीत्ता बिटीदिल; आव अदरी अदिक अलेव सप्पा प्राणीगोळ इक नष्ट माळ बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","आग यहोशू सप्पा इस्त्राएली सांगुळ तिर्गकु दबीर नगर इक होदुन, अदिक आंदुर से लळाई माळदुन; ");
INSERT INTO hoy_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","अदिक राजा सांगुळ आऊक अदिक आऊन सप्पा ऊरगोळ इक ताकोम कोंडुन; अदिक आंदुर आंदरी तलवार देल घात माळदुर; अदिक नगर दा यारीकु जीत्ता बिटिदील, ह्यांग यहोशू हेब्रोन अदिक लिब्ना अदिक आऊन राजा से माळदुर हांग अच आव दबीर अदिक आऊन राजा से भी माळदुन. ");
INSERT INTO hoy_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","ई प्रकार यहोशू आ सप्पा द्याश इक , मतलब पहाळी द्याश, दक्षिण द्याश, ल्यालमागोळोव द्याश, अदिक ढलान द्याश इक, आंदुर सप्पा राजागोळ सांगुळ कोंदुर; अदिक इस्त्राएल इन परमेश्वर यहोवा अन आग्या अन अनुसार यारीकु जीत्ता बिटीदिल, बल्की यास प्राणी ईरव सप्पा अन सत्यानाश माळ कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","अदिक यहोशू दक्षिण इन कादेशबर्ने नगर टु गाजा नगर ताका, अदिक उत्तर इन गिबोन नगर ताका सप्पा गोशेन द्याश इन लॉकुरी कोंदुर. ");
INSERT INTO hoy_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","ई सप्पा राजागोळी आंदुर द्याश इन सांगुळ यहोशू ऊंद अच समय दा ताकोम कोंडुन, यतिकी इस्त्राएल उन परमेश्वर यहोवा इस्त्राएलीगोळ दी टु लळुसोन. ");
INSERT INTO hoy_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","आग यहोशू सप्पा इस्त्राएलीगोळ सांगुळ गिलगाल इन छावनी दा वापस बंदुन. ");
INSERT INTO hoy_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","ईद केळकु हासोर इन राजा याबीन मादोन नगर इन राजा योबाब, अदिक शिम्रोन नगर अदिक अक्षाप नगर इन राजागोळी, ");
INSERT INTO hoy_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","अदिक जो जो राजा उत्तर इन दी पहाळी द्याश दा, अदिक किन्नेरेत इन दक्षिण इन अराबा दा, अदिक ल्यालमा अन द्याश दा, अदिक पश्चिम इन दी दोर नगर इन ऊँचा द्याश दा ईरतोगोर, आंदरी ");
INSERT INTO hoy_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","अदिक पूर्व पश्चिम येढ्ढु दीकळोर ईरावाळेर कनानीगोळ, अदिक एमोरियों, हित्तीगोळी, परिज्जीगोळी, अदिक पहाळी यबूसीगोळी, अदिक मिस्पा द्याश दा हेर्मोन पहाळी इन ल्यालमा ईरावाळेर हिब्बीगोळी बातणी कळुदुर. ");
INSERT INTO hoy_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","अदिक आंदुर तान तान सेना अन सांगुळ, जो समुद्र अन किनारा धुळागोळ घाई हापाळ ईरोद, मीलुस्कु व्हार्या बंदुर, अदिक आंदुर सांगुळ हापाळ सा घ्वाळा अदिक रथ भी ईरव. ");
INSERT INTO hoy_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","आग आंदुर सप्पा राजा सम माळकु जमा आदुर, अदिक इस्त्राएलगोळ सांगुळ लळाई माळोर साटी मेरोम हेसुर इन क्यार्रा अन हाती बंदकु ऊंद सांगुळ छावनी हाकदुर. ");
INSERT INTO hoy_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","आग यहोवा यहोशू से अंदुन, “आंदुर से अंजबाळ, यतिकी नाळ ना ईदा समय ना आ सप्पा मुंदरी इस्त्राएलगोळ वश दा माळकु कोनसुस बुळाईन; आग नी आंदुर घ्वाळा अन ट्वांगरा अन नश कळसुस बुळेत, अदिक आंदुर रथ होत्ताकु भस्म माळ बुळेत.” ");
INSERT INTO hoy_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","अदिक यहोशू सप्पा योध्दा अन सांगुळ मेरोम हेसुर इन क्यार्रा अन हाती पोहचुस्कु अचानक आंदुर मा आक्रमण माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","अदिक यहोवा आंदरी इस्त्राएलगोळ कय दा माळ कोंडुर, इदुरसाटी आंदुर आंदरी कोंदुर, अदिक धोळ्द नगर सीदोन अदिक मिस्त्रपोतमैम ताका, अदिक पूर्व अन दी मिस्पे अन मैदान ताका आंदुर पीछा माळदुन; अदिक आंदरी कोंदुन, अदिक आंदुर दा टु यारीकु जीत्ता बिटीदील. ");
INSERT INTO hoy_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","आग यहोशू यहोवा अन आग्या अन अनुसार आंदुर से माळदुन, मतलब आंदुर घ्वाळा अन ट्वांगरा अन नश कळसुस दुन, अदिक आंदुर रथ बेक्‍की दा होत्‍ताकु भस्म माळ बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","आ समय यहोशू वयाळकु हासोर नगर इक जो पयले आ सप्पा राज्यगोळ्द मुख्य नगर ईरोद ताकोम कोंडुन, अदिक अलेव राजा अक तलवार देल कोंद बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","अदिक यास प्राणी अल ईरव आ सप्पा अक आंदुर तलवार देल कोंदकु सत्यानाश माळदुर; अदिक यातोदु प्राणी इक जीत्ता बिटीदील, अदिक हासोर इक यहोशू बेक्‍की हचकु होताक बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","अदिक आ सप्पा नगरगोळी अलेर सप्‍पा राजागोळ सांगुळ यहोशू ताकोम कोंडुन, अदिक यहोवा अन दास मूसा अन आग्या अन अनुसार आंदरी तलवार देल घात माळकु सत्यानाश माळदुन ");
INSERT INTO hoy_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","लेकीन हासोर उक बिटकु, यारी यहोशू होताक्स बुट्टुन, इस्त्राएल अदिक यातोदारा नगर इक जो तान पहाळी मा बसुस्कु ईरोद होताकिदील. ");
INSERT INTO hoy_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","अदिक ई नगर इन जनावर अदिक ईंदुर सप्पा लूट इक इस्त्राएलगोळ तांद माळ बुट्टुर; लेकीन मंळसागोळी आंदुर तलवार देल कोंद बुट्टुर, ईल ताका कि आंदुर्द सत्यानाश माळ बुट्टुर, कि ऊंद भी प्राणी इक जीत्ता बिटकु आगीदील. ");
INSERT INTO hoy_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","जो आग्या यहोवा तान दास मूसा अक कोटीदुन अदुर्दा अनुसार मूसा यहोशू उक आग्या कोटीदुन अदिक हांगा यहोशू भी माळदुन , जो जो आग्या यहोवा मूसा अक कोटीदुन अऊर दा टु यहोशू अदुर दा यातोदु भी पुरा माळ्द बीना बिटीदील. ");
INSERT INTO hoy_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","आग यहोशू आ सप्पा द्याश इक, मतलब पहाळी द्याश, अदिक सप्पा नेगेब द्याश, अदिक गोशेन द्याश, अदिक ल्यालमागोळोव द्याश, अराबा, अदिक इस्त्राएल इन पहाळी द्याश, अदिक अऊर्द ल्यालमागोळोव द्याश इक, ");
INSERT INTO hoy_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","हालाक हेसुर इन पहाळी टु हुडु , जो सेईर इन ऊचाई मा आद, बालगाद नगर ताका, जो लबानोन इन मैदान दा हेर्मोन पर्वत इन ल्यालमा आद, याट द्याशगोळ आव आ सप्पा द्याशगोळी जीक्स कोंडुर अदिक आ द्याश इन सप्पा राजागोळी हुडुकु कोंद बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","आ सप्पा राजागोळ से युद्ध माळतेला यहोशू उक हापाळ दिन हतदव. ");
INSERT INTO hoy_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","गिबोन इन निवासी हिब्बीगोळी बिटकु अदिक यातारा भी लॉकुर इस्त्राएलगोळ से मेल मिलाप माळीदिल; अदिक सप्पा नगरगोळी आंदुर लळाई माळकु जीक्स कोंडुर. ");
INSERT INTO hoy_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","यतिकी यहोवा अन जो मनसा ईरोद, कि तान आ आग्या अन अनुसार जो आव मूसा अक कोटीदुन आंदुर मा येनु दया माळ बाळुल, बल्की सत्यानाश माळ बुळुल, ई कारण आव आंदुर मन हिंग कठोर माळ बुट्टुर, कि आंदुर इस्त्राएलगोळ्द सामना माळकु आंदुर से युद्ध माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","आ समय यहोशू पहाळी द्याश दा, बंदकु हेब्रोन, दबीर, अनाब, बल्‍की यहूदा अदिक इस्त्राएल सप्पा पहाळी द्याश दा ईरावाळेर अनाकीगोळ्द नाश माळदुर; यहोशू नगरगोळ सांगुळ आंदुर सत्यानाश माळ कोंडुन. ");
INSERT INTO hoy_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","इस्त्राएल इन द्याश दा यावारा अनाकी ईतीदील; केवल गाजा, गत, अदिक अश्दोद नगर दा यारारा यारारा ईतोदुर. ");
INSERT INTO hoy_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","ह्यांग यहोवा मूसा से अंदीदुन, हांग अच यहोशू अद सप्पा द्याश ताकोम कोंडुन; अदिक आऊक इस्त्राएल इन गोत्र अदिक कुलगोळ अनुसार वाट्सकु आंदरी कोट्ट बुट्टुन. अदिक द्याश इक लळाई देल शांती सिक्त. ");
INSERT INTO hoy_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","यरदन गांगा अन आप्पाटी सुर्योदय दी, मतलब अर्नोन घाटी टु हुडुकु हेर्मोन पर्वत ताका द्याश, अदिक सप्पा पुर्वी अराबा अन या राजागोळी इस्त्राएलगोळ कोंदकु आदुर आ द्याश इक आंदुर तान अधिकार दा माळ कोंडीदुर अव ईव हुव; ");
INSERT INTO hoy_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","एमोरियो नव हेशबोनवासी राजा सीहोन, जो अर्नोन घाटी इन बीच इन नगर इक बिटकु यब्बोक गांगा ताका, जो अम्मोनीगोळ्द सीमा आद, आरधा गिलाद मा, ");
INSERT INTO hoy_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","अदिक किन्नेरेत हेसुर इन क्यार्रा टु हुडुकु बेत्यशीमोत टु आगकु अराबा अन क्यार्रा ताका, जो खारा समुद्र भी कहलुसतद, पूर्व अन दीकळोद अराबा, अदिक दक्षिण इन दी पिसगा अन ढलान इन ल्यालमा अन द्याश मा प्रभुता ईटतान. ");
INSERT INTO hoy_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","बाक मीग्दव रपाईयो नगर दा टु बाशान इन राजा ओग इन द्याश ईरोद, जो अश्तारोत नगर अदिक एद्रेई नगर दा ईरतोगोन, ");
INSERT INTO hoy_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","अदिक हेर्मोन पर्वत सल्का, अदिक गशूरीगोळ, अदिक माकिगोळ्द सीमा ताका कुल बाशान दा, अदिक हेशबोन इन राजा सीहोन इन सीमा ताका आरदा गिलाद दा भी शासन माळतोगोन. ");
INSERT INTO hoy_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","इस्त्राएलगोळ अदिक यहोवा अन दास मूसा ईंदरी कोंद बुट्टुन; अदिक यहोवा अन दास मूसा आंदुर्द द्याश रूबेनिगोळ अदिक गादीगोळ अदिक मनश्शे अन आरधा गोत्र अन लॉकुरी कोट्ट बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","यरदन इन पश्चिम इन दी, लबानोन इन मैदान दाकळोद बालगाद नगर टु हुडुकु सेईर इन ऊचाई इन हालाक पहाळी ताका द्याश इन याता राजागोळी यहोशू अदिक इस्त्राएलगोळ कोंदकु आंदुर द्याश इस्त्राएल उन गोत्र अदिक कुलगोळ अनुसार भाग माळकु कोटीदुन अव ईव हुव ");
INSERT INTO hoy_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","हित्ती, अदिक एमोरी, अदिक कनानी, अदिक परिज्जी, अदिक हिब्बी, अदिक यबूसी, जो पहाळी द्याश दा, अदिक ल्यालमागोळ द्याश दा, अदिक अराबा दा, अदिक उतार द्याश दा अदिक आळी दा, अदिक दक्षिणी द्याश दा ईरतोगोर. ");
INSERT INTO hoy_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","ऊंद यरीहो अन राजा; ऊंद बेतेल इन हाती आई नगर इन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","ऊंद यरूशलेम उन राजा; ऊंद हेब्रोन उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ऊंद, यर्मूत इन राजा; ऊंद, लाकीश उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ऊंद, एग्लोन उन राजा; ऊंद, गेजेर उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ऊंद, दबीर उन राजा; ऊंद, गेदेर उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ऊंद, होर्मा अन राजा; ऊंद, अराद उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ऊंद, लिब्ना अन राजा; ऊंद अदुल्लाम उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ऊंद, मक्केदा अन राजा; ऊंद बेतेल उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ऊंद, तप्पूह अन राजा; ऊंद हेपेर उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","ऊंद अपेक उन राजा; ऊंद, लश्शारोन उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ऊंद मादोन उन राजा; ऊंद, हासोर उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ऊंद, शिम्रोन्मरोन उन राजा; ऊंद, अक्षाप उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ऊंद तानाक उन राजा; ऊंद, मगिद्दो अन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ऊंद, केदेश उन राजा; ऊंद, कर्मेल दा योकनाम उन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ऊंद, दोर हेसुर ईनव धोळ्द द्याश इन दोर इन राजा, ऊंद, गिलगाल इन गोयीन इन राजा; ");
INSERT INTO hoy_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","अदिक ऊंद तिर्सा अन राजा; ई प्रकार सप्पा राजा इकतीस आदुर. ");
INSERT INTO hoy_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","यहोशू बाट्ट अदिक हापाळ ऊमर ईनव आगेगीदुन; अदिक यहोवा आऊन से अंदुन, “नी बाट्ट अदिक हापाळ ऊमर ईनव आगेग्या, अदिक हापाळ द्याश ईतोग्याव, जो इस्त्राएल इन अधिकार दा ईगासताका बरलीकाव. ");
INSERT INTO hoy_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","ईव द्याश ईतोग्याव, मतलब पलिश्ती इन सप्पा प्रांन्त, अदिक सप्पा गशूरी द्याश ");
INSERT INTO hoy_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","मिस्त्र अन मुंद शीहोर गांगा टु हुडुकु उत्तर इन दी एक्रोन इन सीमा ताका जो कनानीगोळ्द भाग आळुकु आगतद; अदिक पलिश्ती इन अईदु सरदार, मतलब गाजा, अश्दोद, अश्कलोन, गत, अदिक एक्रोन इन लॉकुर, अदिक दक्षिणी अदिक अव्वी जाती भी, ");
INSERT INTO hoy_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","बाक अपेक नगर अदिक एमोरियो अन सीमा ताका कनानीगोळ्द सप्‍पा द्याश अदिक सीदोनीगोळ्द मारा हेसुर इन द्याश. ");
INSERT INTO hoy_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","बाक गबालिगोळ्द द्याश, अदिक सुर्योदय इन दी हेर्मोन पहाळी अन ल्यालमा अन बालगाद नगर टु हुडुकु हमात इन घाटी ताका सप्पा लबानोन द्याश, ");
INSERT INTO hoy_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","बाक लबानोन टु हुडुकु मिस्त्रपोतमैम ताका सीदोनीगोळ्द पहाळी द्याश इन निवासी. ईंदरी ना इस्त्राएलगोळ्द मुंदु टु तेगु बुळाईन; ईट आगुल कि नी नान आग्या अन अनुसार आंदुर अधिकार इस्त्राएलगोळी वाट्स कोम. ");
INSERT INTO hoy_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","इदुरसाटी नी ईग ई द्याश इक ऊंम्बत गोत्रगोळ अदिक मनश्शे अन आरधा गोत्र अक आंदुर भाग आगोर साटी वाट्सकोम.” ");
INSERT INTO hoy_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","रूबेनिगोळ अदिक गादीगोळ इक रा अद भाग सीकेगीत. यदरी मूसा आंदरी यरदन इन पूर्व इन दी कोटीदुन, यतिकी यहोवा अन दास मूसा आंदरी कोटीदुन. ");
INSERT INTO hoy_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","मतलब अर्नोन हेसुर इन घाटी इन किनारा अन अरोएर टु हुडुकु, अदिक अदा घाटी इन बीच नगर इक बिटकु दीबोन ताका मेदबा अन हातीगोळोद सप्‍पा चौरस द्याश; ");
INSERT INTO hoy_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","अदिक अम्मोनिगोळ्द सीमा ताका हेशबोन दा ईरावाळेर एमोरियो अन राजा सीहोन उन सप्पा नगर; ");
INSERT INTO hoy_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","अदिक गिलाद द्याश, अदिक गशूरीगोळ अदिक माकिवासिगोळ्द सीमा अदिक सप्पा हेर्मोन पर्वत, अदिक सल्का नगर ताका सप्पा बाशान प्रदेश, ");
INSERT INTO hoy_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","बाक अश्तारोत अदिक एद्रेई नगर दा बरावाळेर आ ओग इन सप्पा राज्य जो रपाई जाती दा टु आबना ऊळदोगीदुन; यतिकी ईंदरी मूसा कोंदकु आंदुर प्रजा अक आ द्याश टु तेगु बुटीदुन. ");
INSERT INTO hoy_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","लेकीन इस्त्राएलीगोळ गशूरीगोळ अदिक माकिगोळ इक आंदुर द्याश दा टु तेगदीदील; इदुरसाटी हशूरी अदिक माकी जाती इस्त्राएलीगोळ बीच दा ईंद ताका ईरतार. ");
INSERT INTO hoy_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","अदिक लेवी इन वंशगोळी आव येनु भाग कोटीदील; यतिकी इस्त्राएल उन परमेश्वर यहोवा अन वचन इन अनुसार आऊंदा येर्सद होमबली आंदुर साटी भाग ठहरूस्याद. ");
INSERT INTO hoy_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","मूसा जमीन इन भाग रूबेन उन कुल इन परिवारगोळी आंदुर्द निज भाग इन रूप दा वाट्स कोंडीदुन, ");
INSERT INTO hoy_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","मतलब अर्नोन हेसुर इन घाटी इन किनारा अन अरोएर नगर टु हुडुकु अदिक अदा घाटी इन बीच इन नगर इक बिटकु मेदबा अन हाती इन सप्पा चौरस द्याश; ");
INSERT INTO hoy_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","बाक चौरस द्याश दाकळोद हेशबोन अदिक अदुर सप्पा ऊर; बाक दीबोन, बामोतबाल, बेतबाल्मोन, ");
INSERT INTO hoy_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","यहसा, कदेमोत, मेपात, ");
INSERT INTO hoy_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","किर्यातैम, सिबमा, अदिक तराई दाकळोव पहाळी मा बसुस्द सेरेथश्शहर, ");
INSERT INTO hoy_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","बेतपोर, पिसगा अन ढलान अदिक बेत्यशीमोत, ");
INSERT INTO hoy_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","मतलब चौरस द्याश दा कुर्तकु हेशबोन दा कुरावाळेर एमोरियो अन आ राजा सीहोन इन राज्य अन सप्पा नगर यदरी मूसा कोंद बुटीदुन. मूसा एवी, रेकेम, सूर, हूर, अदिक रेबा हेसुर इन मिद्यान इन प्रधानगोळ इक भी कोंद बुटीदुन जो सीहोन उन ठहरूसकु शासक अदिक अदा द्याश इन निवासी ईरोर. ");
INSERT INTO hoy_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","अदिक इस्त्राएलीगोळ आंदुर अदिक आंदरी कोनावाळेर सांगुळ बोर उन पार भविष्य हेळावाळा बिलाम उक भी तलवार देल कोंद बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","अदिक रूबेनिगोळ्द सीमा यरदन गांगा अन किनारा ठहरूस्त, रूबेनिगोळ्द भाग आंदुर कुलगोळ अनुसार नगरगोळ अदिक ऊरगोळ्द सांगुळ ईल्या ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","बाक मूसा गाद इन गोत्र वाळेर इक भी कुलगोळ अनुसार आंदुर खुद इन भाग माळकु वाट्स बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","आग ईद ठहरूस्त, मतलब याजेर अदिक गिलाद इन सप्पा नगर, अदिक रब्बा नगर इन मुंदळोद अरोएर नगर ताका अम्मोनिगोळ्द आरधा द्याश, ");
INSERT INTO hoy_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","अदिक हेशबोन टु रामत-मिस्पे अदिक बतोनीम ताका, अदिक महनैम टु दबीर इन सीमा ताका, ");
INSERT INTO hoy_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","अदिक घाटी दा बेतहारम, बेतनिम्रा, सुक्कोत, अदिक सापोन, अदिक हेशबोन इन राजा सीहोन इन राज्य अन मीकदव भाग, अदिक किन्नेरेत हेसुर इन क्यार्रा अन क्वाना ताका, यरदन इन पूर्व इन दी अद द्याश यदुर सीमा यरदन गांगा आद. ");
INSERT INTO hoy_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","गादी लॉकुर्द भाग आंदुर कुलगोळ अनुसार नगरगोळ अदिक ऊरगोळ सांगुळ ईदा ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","बाक मूसा मनश्शे अन आरधा गोत्र वाळेर इक भी आंदुर खुद इन भाग माळकु कोट्टुर; अद मनश्शेगोळ्द आरधा गोत्र अन खुद इन भाग आंदुर कुलगोळ अनुसार ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","अद ईद हुन, मतलब महनैम टु हुडुकु बाशान उन राजा ओग उन राजा अन सप्पा द्याश, अदिक बाशान दा बसुस्द आईर उन साठ बस्तीगोळ, ");
INSERT INTO hoy_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","अदिक गिलाद इन आरधा भाग, अदिक अश्तारोत, अदिक एद्रेई, जो बाशान दा ओग इन राज्य अन नगर ईरव, ईव मनश्शे अन पार माकीर उन वंश इन मतलब माकीर उन आरधा वंश इन खुद इन भाग कुलगोळ अनुसार ठहरूसदव. ");
INSERT INTO hoy_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","जो भाग मूसा मोआब इन मैदान दा यरीहो अन हाती इन यरदन इन पूर्व इन दी वाट्स बुट्टुन अव ईवा हु. ");
INSERT INTO hoy_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","लेकीन लेवी गोत्र अक मूसा येनु भाग कोटीदील; इस्त्राएल उन परमेश्वर यहोवा अच तान वचन इन अनुसार आंदुर भाग ठहरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","जो-जो भाग इस्त्राएलगोळ कनान द्याश दा नोळदुर, आंदरी एलीआजर याजक, अदिक नून उन पार यहोशू, अदिक इस्त्राएली गोत्रगोळ पुर्वज इन घराना अन मुख्य मुख्य मंळसागोळ आंदरी कोट्टुर आंदुर ईंदुर उर. ");
INSERT INTO hoy_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","जो आग्या यहोवा मूसा अन द्वारा साळे ऊंम्बत गोत्रगोळ साटी कोटीदुन, अदुर अनुसार आंदुर हिस्सा चिट्टी हाक्कु कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","मूसा रा येढ्ढवार गोत्रगोळ हिस्सा यरदन इन आप्पाटी कोटीदुन; लेकीन लेवीगोळी आव आंदरी येनु भाग कोटीदील. ");
INSERT INTO hoy_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","यूसुफ उन वंश इन रा येढ्ढ गोत्र आगीदव, मतलब मनश्शे अदिक एप्रैम; अदिक आ द्याश दा लेवीगोळी येनु भाग कोटकु आगीदील, सिर्फ ईरव नगर, अदिक जनावर अदिक धन ईटोरसाटी चराईगोळ आंदरी सिकदव. ");
INSERT INTO hoy_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","जो आग्या यहोवा मूसा अक कोटीदुन अदुर अनुसार इस्त्राएलगोळ माळदुर; अदिक आंदुर द्याश इक वाट्स बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","आग यहूदा यहोशू उन हाती गिलगाल दा बंदुन; अदिक कनजी यपुन्ने उन पार कालेब आऊन से अंदुन, “नी जान्सतीद्या कि यहोवा कादेशबर्ने दा परमेश्वर उन जन मूसा से नान अदिक नीन बारा दा येन अंदीदुन. ");
INSERT INTO hoy_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","याग यहोवा अन दास मूसा नानी ई द्याश इन भेद ताकोमोर साटी कादेशबर्ने टु कळीदुन आग ना चालीस वर्ष इनव ईरीन; अदिक सच्चा मन देल आऊन हाती बातणी तंदीन. ");
INSERT INTO hoy_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","अदिक नान साथी जो नान सांगुळ बंदीदुर आंदुर रा प्रजा अन लॉकुर्द मन निराश माळ बुट्टुर, लेकीन ना तान परमेश्वर यहोवा अन पुरा रीति देल मात मान्सदीन. ");
INSERT INTO hoy_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","आग आ दिशी मूसा किर्‍या तीनकु पुरा रीति देल ‘नान परमेश्वर उन मातगोळ्द अनुकरण माळ्यान, ईद कारण नि:सन्देह याता जमीन मा नी तान काल मंळस्या अद सदा साटी नीन अदिक नीन वंश इन हिस्सा आदीत.’ ");
INSERT INTO hoy_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","अदिक ईग नोळ, यागुटु यहोवा मूसा से ईद वचन अंदीदुन आग टु पैतालीस वर्ष आगेग्याव, यदुर दा इस्त्राएलगोळ आळी दा वयाळतेला ईत्तुर; आंदुर दा यहोवा तान अनोद अनुसार नानी जीत्ता ईटदुन; अदिक ईग ना पच्यासी वर्ष ईनव आईन. ");
INSERT INTO hoy_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","याट ताकत मूसा अन कळोद समय दा नान दा ईरोद आटा ताकत ईग भी नान दा आद; युद्ध माळोर साटी बुळ्क व्हार्या होगोर बरोर साटी याट आ समय नान दा सामर्थ्य ईरोद आट ईग भी नान दा सामर्थ्य आद. ");
INSERT INTO hoy_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","इदुरसाटी ईग अद पहाळी नानी कोळ यदुर चर्चा यहोवा आ दिशी माळीदुन; नी रा आ दिशी केळीद्या कि अल अनाकी वंश इनोर ईरतार, अदिक धोड्डेव धोड्डेव गढ़वाळा नगर भी आव; लेकीन येन पता सम्भव आद कि यहोवा नान सांगुळ ईत्तान, अदिक आऊन अनोद अनुसार ना आंदरी आंदुर द्याश दा टु तेगु कोमाईन.” ");
INSERT INTO hoy_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","आग यहोशू आऊक आशीर्वाद कोट्टुन; अदिक हेब्रोन नगर यपुन्ने अन पार कालेब उन भाग माळ बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","ई कारण हेब्रोन नगर कनजी यपुन्ने अन पार कालेब उन बाग ईंद ताका बन्सकु आद, यतिकी आव इस्त्राएल उन परमेश्वर यहोवा अन पुरा रीति देल अनुसरण माळीदुन. ");
INSERT INTO hoy_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","पयले हेब्रोन इन हेसुर किर्यतर्बा ईरोद; आव अर्बा अनाकीगोळ दा सबसे धोड्डेव मंळसा ईरोन. अदिक आ द्याश इक लळाई देल शांती सिक्त. ");
INSERT INTO hoy_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","यहूदा अन गोत्र अन भाग आंदुर कुलगोळ अनुसार चिट्टी हाकदुर देल एदोम इन सीमा ताका, अदिक दक्षिण इन दी सीन इन आळी ताका जो दक्षिणी सीमा मा ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","आंदुर भाग इन दक्षिणी सीमा मृत समुद्र अन आ सिरवाला कोल टु चालु आत जो दक्षिण इन दी वाळुस्कु आद; ");
INSERT INTO hoy_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","अदिक अद अक्रब्बीम हेसुर इन चळाई इन दक्षिण दी टु होटकु सीन आगतेला कादेशबर्ने अन दक्षिण दी येरेत, बाक हेस्रोन उन आगकु अद्दार इक येरकु कर्कआ दी तीर्गेत, ");
INSERT INTO hoy_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","अल टु अस्मोन आगतेला अद मिस्त्र अन नाला मा होळ्त, अदिक आ सीमा अन अन्त समुद्र आत. नीम्द दक्षिणी सीमा ईदा आदीत. ");
INSERT INTO hoy_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","बाक पुर्वी सीमा यरदन इन मुहाना ताका मृत समुद्र अच ठहरूस्त, अदिक उत्तर दिशा अन सीमा यरदन इन मुहाना अन हाती ताल इन कोल टु चालु माळकु, ");
INSERT INTO hoy_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","बेथोग्ला अक येरतेला बेतराबा अन उत्तर दी आगकु रूबेनी बोहन हेसुर इन कल्ल ताका येरेत; ");
INSERT INTO hoy_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","अदिक अदा सीमा आकोर हेसुर इन झरना टु दबीर दी येरेत, अदिक उत्तर दी टु आगतेला गिलगाल दी डोक्त जो झरना अन दक्षिणी दी अदुम्मीम इन चळाई इन मुंद आद; अल टु अद एनशेमेश हेसुर इन झरना अन हाती पोहचुस्कु एनरोगेल मा होळ्त; ");
INSERT INTO hoy_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","बाक अदा सीमा हिन्नोन उन पार उन तराई टु आगकु यबूसी जो यरूशलेम अनकु आगतद इन दक्षिण दी टु येरतेला आ पहाळी इन चोटी मा पोहचुस्त, जो पश्चिम दी अदिक हिन्नोम इन तराई इन मुंद अदिक रपाईम इन तराई इन उत्तर इन क्वाना मा आद; ");
INSERT INTO hoy_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","बाक अदा सीमा आ पहाळी इन चोटी टु नेप्तोह हेसुर इन सोता अक होटोत, अदिक एप्रोन पहाळी इन नगरगोळ मा होळ्त; बाक अल टु बाला अक जो किर्यत्यारीम भी कहलुसतद पोहचुस्त; ");
INSERT INTO hoy_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","बाक अद बाला टु पश्चिम इन दी तिर्गकु सेईर पहाळी ताका पोहचुस्त अदिक यारीम पहाळी जो कसालोन भी कहलुसतद, अदुर उत्तर दिशा टु आगकु बेतशेमेश इक ईळदोत, अदिक अल टु तिम्ना मा होळ्त; ");
INSERT INTO hoy_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","अल टु अद सीमा एक्रोन इन उत्तर दिशा अन हाती टु आगतेला शिक्करोन होत, अदिक बाला पहाळी आगकु यब्नेल मा होळ्त; अदिक आ सीमा अन अन्त समुद्र अन तट मा आत. ");
INSERT INTO hoy_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","अदिक पश्चिम इन सीमा महासमुद्र अन तट ठहरूस्त. यहूदागोळी जो भाग आंदुर कुलगोळ अनुसार सिक्त अदुर नाकु दिकळोद सीमा ईदा आत. ");
INSERT INTO hoy_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","यपुन्ने अन पार कालेब उक आव यहोवा अन आग्या अन अनुसार यहूदियागोळ बीच भाग कोट्टुन, मतलब किर्यतर्बा जो हेब्रोन भी कहलुसतद आव अर्बा अनाक उन आप्प ईरोन. ");
INSERT INTO hoy_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","अदिक कालेब अल टु शेशै, अहीमन, अदिक तल्मै हेसुर इन अनाक उन मुरू चिकोरी तेगु बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","बाक अल टु आव दबीर इन निवासीगोळ मा येरेदुन; पूर्वकाल दा रा दबीर उन हेसुर किर्यत्सेपेर ईरोन. ");
INSERT INTO hoy_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","अदिक कालेब अंदुन, “जो किर्यत्सेपेर उक हारूस्यान ना तान पोर अकसा अन मदा आऊन से माळ कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","आग कालेब उन वार्ट कनजी इन पार ओत्नीएल आकिन से मदा माळदुन; अदिक आव आऊन से तान पोर अकसा अन मदा माळ बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","याग आक आऊन हाती बंदुर, आग आव आकी आकिन आप्प उन से येनारा जमीन बेळली उकसुसदुन, बाक आक तान गदहा मा टु ईळदुर, अदिक कालेब आकिन से केळदुन, “नी येन चाहसत्या?” ");
INSERT INTO hoy_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","आक अंदुर नानी आशीर्वाद कोळ; “नी नानी दक्षिण द्याश दाकळोद थ्वाळासा जागा रा कोट्ट बुट्ट, नानी नीर इन झरना भी कोळ.” आग आव म्याकळव झरना, ल्यालमाकळव झरना, येढ्ढु आकी कोट बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","यहूदा अन गोत्र अन भाग रा आंदुर कुलगोळ अनुसार ईदा ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","यहूदा अन गोत्र अन किनारा मा ईरावाळेर नगर दक्षिण द्याश दा एदोम इन सीमा दी ईव आव, मतलब कबसेल, एदेर यागूर, ");
INSERT INTO hoy_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","कीना, दीमोना, अदादा, ");
INSERT INTO hoy_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","केदेश, हासोर, यित्नान, ");
INSERT INTO hoy_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","जीप, तेलेम, बालोत, ");
INSERT INTO hoy_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","हासोर्हदत्ता, करिय्योथेस्र्नोन, जो हासोर भी कहलुसतद, ");
INSERT INTO hoy_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","अदिक अमाम, शमा, मोलादा, ");
INSERT INTO hoy_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","हसर्गद्दा, हेशमोन, बेत्पालेत, ");
INSERT INTO hoy_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","हसर्शूआल, बेर्शेबा, बिज्योत्या, ");
INSERT INTO hoy_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","बाला, इय्यीम, एसेम, ");
INSERT INTO hoy_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","एलतोलद, कसील, होर्मा, ");
INSERT INTO hoy_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","सिकलग, मदमन्ना, सनसन्ना, ");
INSERT INTO hoy_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","लबाओत, शिल्हीम, ऐन, अदिक रिम्मोन; ईव सप्पा नगर उन्तीस आव, अदिक ईऊरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","ल्यालमागोळोव द्याश दा ईव आव: मतलब एशताओल, सोरा, अशना, ");
INSERT INTO hoy_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","जानोह, एनगन्नीम, तप्पूह, एनाम, ");
INSERT INTO hoy_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","यर्मूत, अदुल्लाम, सोको, अजेका, ");
INSERT INTO hoy_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","शारैम, अदीतैम, गदेरा, अदिक गदेरोतैम; ईव सप्पा चौदा नगर आव, अदिक ईऊरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","बाक सनान, हदाशा, मिगदलगाद, ");
INSERT INTO hoy_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","दिलान, मिस्पे, योक्तेल, ");
INSERT INTO hoy_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","लाकीश, बोस्कत, एग्लोन, ");
INSERT INTO hoy_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","कब्बोन, लहमास, कितलीश, ");
INSERT INTO hoy_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","गदेरोत, बेतदागोन, नामा, अदिक मक्केदा; ईव सोलाह नगर आव, अदिक ईऊरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","बाक लिब्ना, एतेर, आशान, ");
INSERT INTO hoy_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","यिप्ताह, अशना, नसीब, ");
INSERT INTO hoy_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","कीला, अकजीब अदिक मारेशा; ईव ऊम्बत नगर आव, अदिक ईऊरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","बाक नगरगोळ अदिक ऊरगोळ सांगुळ एक्रोन, ");
INSERT INTO hoy_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","अदिक एक्रोन टु हुडुकु समुद्र ताका, तान तान ऊरगोळ सांगुळ यास नगर अश्दोद इन दी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","बाक तान नगरगोळ अदिक ऊरगोळ सांगुळ अश्दोद, अदिक गाजा, बल्‍की मिस्त्र अन नाला ताका अदिक महासमुद्र अन तट ताका यास नगर आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","पहाळी द्याश दा ईव आव; मतलब शामीर, यत्तीर, सोको, ");
INSERT INTO hoy_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","दन्ना, किर्यत्सन्ना जो दबीर भी कहलुसतान, ");
INSERT INTO hoy_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","अनाब, एशतमो, आनीम, ");
INSERT INTO hoy_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","गोशेन, होलोन, अदिक गीलो; ईव हनुन नगर आव, अदिक ईंदुरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","बाक अराब, दूमा, एशान, ");
INSERT INTO hoy_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","यानीम, बेत्तप्पूह, अपेका, ");
INSERT INTO hoy_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","हुमता, किर्यतर्बा जो हेब्रोन भी कहलुसतान, अदिक सीओर, ईव ऊम्बत नगर आव, अदिक ईंदुरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","बाक माओन, कर्मेल, जीप, यूता, ");
INSERT INTO hoy_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","यिज्रेल, योकदाम, जानोह, ");
INSERT INTO hoy_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","कैन, गिबा, अदिक तिम्ना; ईव हत्त नगर आव, अदिक ईंदुरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","बाक हलहूल, बेतसूर, गदोर, ");
INSERT INTO hoy_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","मरात, बेतनोत, अदिक एलतकोन; ईव आर नगर आव, अदिक ईऊरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","बाक किर्यतबाल जो किर्यत्यारीम भी कहलुसतद, अदिक रब्बा; ईव येढ्ढ नगर आव, अदिक ईऊरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","आळी दा ईव नगर आव: मतलब बेतराबा, मिद्दीन, सकाका; ");
INSERT INTO hoy_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","निबशान, लोनवाला नगर, अदिक एनगदी, ईव आर नगर आव, अदिक ईऊरव ऊर भी आव. ");
INSERT INTO hoy_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","यरूशलेम इन निवासी यबूसिया अक यहूदीगोळ तेगु सकीदील; इदुरसाटी ईंद इन दिन ताका यबूसी यहूदीगोळ सांगुळ यरूशलेम दा ईरतार. ");
INSERT INTO hoy_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","बाक यूसुफ उन सन्तान इन भाग चिट्टी हाक्कु ठहरूसकु आत, आंदुर सीमा यरीहो अन हाती इन यरदन गांगा टु मतलब पूर्व अन दी यरीहो अन झरना देल शुरू आगकु आ पहाळी द्याश टु आगतेला जो आळी दा आद बेतेल नगर इक पोहचुस्त; ");
INSERT INTO hoy_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","बेतेल टु आव लूज क्षेत्र ताका पोहचुस्त, अदिक अर्की जाती इन सीमा टु आगतेला अतारोत मा होगकु होळ्त,: ");
INSERT INTO hoy_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","अदिक पश्चिम इन दी यपलेती जाती इन सीमा टु ईळुकु बाक ल्यालमागोळोद बेथोरोन इन सीमा टु आगकु गेजेर हेसुर इन जागा मा पोहचुस्त, अदिक महासमुद्र दा खतम आत. ");
INSERT INTO hoy_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","आग मनश्शे अदिक एप्रैम हेसुर ईनोर यूसुफ उन येढ्ढु पारगोळोर औलाद तान तान हिस्सा तांकोडुर. ");
INSERT INTO hoy_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","एप्रैमगोळ्द सीमा आंदुर्द कुलगोळ्द अनुसार ईद ठहरूस्त; मतलब आंदुर भाग इन सीमा पूर्व टु चालु आगकु अत्रोतदार टु आगतेला म्याकुचवाळा बेथोरोन ताका पोहचुस्त; ");
INSERT INTO hoy_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","अदिक उत्तरी सीमा पश्चिम इन दी मिकमतात टु चालु आगकु पूर्व इन दी तिर्गकु तानतशीला अक पोहचुस्त, अदिक अदुर हाती टु आगतेला यानोह ताका पोहचुस्त; ");
INSERT INTO hoy_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","बाक यानोह टु अद अतारोत अदिक नारा अक ईळुतेला यरीहो अन हाती टु आगकु यरदन गांगा मा खतम आत. ");
INSERT INTO hoy_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","बाक अदा सीमा तप्पूह टु होटकु, अदिक पश्चिम दी होगकु, काना नाला ताका आगकु समुद्र मा होळ्त. एप्रैमिगोळ्द गोत्र अन भाग आंदुर कुलगोळ अनुसार ईल्या ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","अदिक मनश्शे कुल इन हिस्सा अन न्याड्या भी थ्वाळासा नगर तान तान ऊरगोळ सांगुळ एप्रैमिगोळ साटी अलग माळकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","लेकीन जो कनानी गेजेर दा बसुस्कु ईरोर आंदरी एप्रैमीगोळ अल टु ईला तेगदीदुर; इदुरसाटी आंदुर कनानी आंदुर बीच ईंद इन दिन ताका बसुस्कु आर, अदिक बेगारी दा दास इन घाई क्याल्सा माळतार. ");
INSERT INTO hoy_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","बाक यूसुफ उन धोड्डेव पार मनश्शे अन गोत्र अन भाग चिट्टी हाकदुर देल ईद ठहरूस्त. मनश्शे अन धोड्डेव पार गिलाद उन आप्प माकीर योद्धा ईरोन, ई कारण आऊन वंश इक गिलाद अदिक बाशान प्रदेश कोटकु आत. ");
INSERT INTO hoy_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","इदुरसाटी ई भाग दुसरा मनश्शे अन चिकोर साटी आंदुर कुलगोळ अनुसार ठहरूस्त, मतलब अबीएजेर, हेलेक, अस्त्रीएल, शेकेम, हेपेर, अदिक शमीदा; जो तान तान कुलगोळ अनुसार यूसुफ उन पार मनश्शे अन वंश दा मंळसा ईरोर, आंदुर अलग अलग वंशगोळ साटी ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","लेकीन हेपेर जो गिलाद उन पार, माकीर उन नातु, अदिक मनश्शे अन पळनातु ईरोन, आऊन पार सलोफाद उन पारगोळ हैलेच, पोरगोळ अच आदुर; अदिक आंदुर हेसुर महला, नोआ, होग्ला, मिल्का, अदिक तिर्सा आद, ");
INSERT INTO hoy_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","आग आंदुर एलीआजर याजक, नून उन पार यहोशू, अदिक प्रधानगोळ हाती होगकु अनली कुरतुर, “यहोवा मूसा अक आग्या कोटीदुन, कि आव नामी नाम वार्टुर बीच दा नामी भाग कोळुल.” रा यहोशू यहोवा अन आग्या अन अनुसार आंदरी आंदुर काकागोळ बीच भाग कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","आग मनश्शे अक, यरदन इन आप्पाटी गिलाद द्याश अदिक बाशान इक बिटकु, हत्त हिस्सा मात्त सीकदव: ");
INSERT INTO hoy_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","यतिकी मनश्शेगोळ बीच मनश्शे अन पोरगोळी भी हिस्सा सीक्त. अदिक दुसरा मनश्शेगोळी गिलाद द्याश सिक्त. ");
INSERT INTO hoy_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","मनश्शे अन सीमा आशेर टु हुडुकु मिकमतात ताका पोहचुस्त, जो शकेम उन मुंद आद; बाक आव दक्षिण इन दी वाळुस्कु एनतप्पूह अन निवासिगोळ ताका पोहचुस्त. ");
INSERT INTO hoy_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","तप्पूह अन जमीन रा मनश्शे अक सिक्त, लेकीन तप्पूह नगर जो मनश्शे अन सीमा मा बसुस्कु आद अद एप्रैमिगोळ्द ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","बाक अल टु अद सीमा काना अन नाला ताका ईळुकु अदुर दक्षिण इन ताका पोहचुस्त; ईव नगर मनश्शे अन नगरगोळ बीच दा ईरव तरी भी एप्रैम इन ठहरूसदव; अदिक मनश्शे अन सीमा आ नाला अन उत्तर दी टु होगकु समुद्र मा होळ्त; ");
INSERT INTO hoy_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","दक्षिण इन दीकळोद द्याश रा एप्रैम उक अदिक उत्तर इन दीकळोद मनश्शे अक सिक्त, अदिक आऊन सीमा समुद्री ठहरूस्त; अदिक आंदुर उत्तर दी आशेर टु अदिक पूर्व दी इस्साकार टु होगकु सिक्त. ");
INSERT INTO hoy_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","अदिक मनश्शे अक, इस्साकार अदिक आशेर तान तान नगरगोळ सांगुळ बेतशान, यिबलाम, अदिक तान नगरगोळ सांगुळ दोर निवासी, अदिक तान नगरगोळ सांगुळ एनदोर इन निवासी, अदिक तान नगरगोळ सांगुळ तानाक इन निवासी, अदिक तान नगरगोळ सांगुळ मगिद्दो अन निवासी, ईव मुरू जो ऊँचा जागा मा बसुस्कु आव सिकदव. ");
INSERT INTO hoy_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","लेकीन मनश्शेई आ नगरगोळ निवासीगोळी अल टु तेगु सकीदील; इदुरसाटी आंदुर कनानी आ द्याश दा जबरदस्ती बसुस्कु ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","तरी भी याग इस्त्राएली सामर्थी आगेदुर, आग कनानीगोळ से बेगारी रा माळसुसली कुरतुर, लेकीन आंदरी पुरा रीति देल तेगुकु व्हार्या माळीदिल. ");
INSERT INTO hoy_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","यूसुफ उन सन्तान यहोशू से अनली कुर्त, “नाव रा गिनती दा हापाळ आयेव, यतिकी ईगासताका यहोवा नामी आशीष अच कोळतेला बंदान, बाक नी नाम भाग इन साटी चिट्टी हाक्कु यती ऊंदा हिस्सा ईट्या?” ");
INSERT INTO hoy_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","यहोशू आंदुर से अंदुन, “अगर नीव गिनती दा हापाळ आईर, अदिक एप्रैम इन पहाळी द्याश नीम साटी स्यांळ्द आगुल, जो परिज्जीगोळ अदिक रपाईगोळ अन द्याश जो आळी दा आद, अल होगकु मार्रगोळी कळ्द बुळी.” ");
INSERT INTO hoy_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","यूसुफ उन सन्तान अंदुन, “अद पहाळी द्याश नाम साटी स्यांळ्द आद; अदिक बेतशान अदिक यिज्रेल इन तराई दा ईरावाळेर, यास कनानी लॉकुर जो ल्यालमागोळ द्याश दा ईरतार, आ सप्पा मुंदुर हाती लोहानव रथगोळ आव.” ");
INSERT INTO hoy_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","बाक यहोशू, येन एप्रैमी येन मनश्शेई, मतलब यूसुफ उन सप्पा घराना से अंदुन, “हव, नीव लॉकुर गिनती दा हापाळ आईर, अदिक निम्द सामर्थ्य भी धोळ्द आद, इदुरसाटी नीमी ऊंदा भाग सिकतीदील; ");
INSERT INTO hoy_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","पहाळी द्याश भी नीम्द आगेदीत; यतिकी अद आळी रा आद, लेकीन अदुरव मार्र कडुकोमी , आग अदुर आस पास इन द्याश भी नीम्द आगेदीत; यतिकी बाक कनानी सामर्थी आगुल, अदिक आंदुर हाती लोहानव रथ भी आव, तरी भी नीव आंदरी अल टु तेगु सकीर.” ");
INSERT INTO hoy_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","बाक इस्त्राएलगोळ्द सप्पा मंडली शीलो नगर दा जमा आगकु अल मिलाप इन तम्बु अक नीदरूसदुर; यतिकी द्याश आंदुर वश दा होट्ट बंदीत. ");
INSERT INTO hoy_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","अदिक इस्त्राएलीगोळ येळ कुल इन लॉकुर ईग भी हिंग ईरोर यारी अधिकार दा हिस्सा सिकली ईरोद. ");
INSERT INTO hoy_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","आग यहोशू इस्त्राएलगोळ से अंदुन, “जो द्याश नीम पूर्वजगोळ परमेश्वर नीमी कोटान, अदरी तान अधिकार दा माळली नीव यागासताका ढिलाई माळतेला ईत्तीर? ");
INSERT INTO hoy_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","ईग हर कुल दा टु मुर मंळसा ठहरूसबुळी, अदिक ना आंदरी इदुरसाटी कळाईन कि आंदुर होगकु द्याश दा वयाळ सकुल, अदिक तान तान कुल इन भाग इन प्रयोजन इन अनुसार अदुर हाल लिख्स लिख्सकु नान हाती वापस बंदार. ");
INSERT INTO hoy_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","अदिक आंदुर द्याश इन येळ भाग लिख्सदुर, यहूदी रा दक्षिण दी तान भाग दा, अदिक यूसुफ उन घराना अन लॉकुर उत्तर इन दी तान भाग दा ईरूल. ");
INSERT INTO hoy_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","अदिक नीव द्याश इन येळ भाग इन जानकारी लिख्सकु नान हाती तरी; अदिक ना ईल नीम साटी तान परमेश्वर यहोवा अन मुंद चिट्टी हाकाईन. ");
INSERT INTO hoy_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","अदिक लेवीगोळ्द नीम बीच दा यातोदु भाग ईरतीदील, यतिकी यहोवा अन कोळ्द याजकपद आंदुर भाग आद; अदिक गाद, रूबेन, अदिक मनश्शे अन आरधा गोत्र अन लॉकुर यरदन इन पूर्व दी यहोवा अन दास मूसा अन कोटकु आत तान तान भाग हासिल माळ कोंडार.” ");
INSERT INTO hoy_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","आग आ मंळसागोळ यदकु नळुली कुरतुर; अदिक जो आ द्याश इन हाल लिखसोर साटी नळदुर आंदरी यहोशू ईद आग्या कोट्टुन, “होगकु द्याश दा वयाळी, अदिक अदुर हाल लिख्सकु नान हाती वापस बरी; अदिक ना ईल शीलो दा यहोवा अन मुंद नीम साटी चिट्टी हाकाईन.” ");
INSERT INTO hoy_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","आग आ मंळसा होदुर, अदिक आ नगर द्याश दा वयाळदुर, अदिक आऊन नगर इन येळ भाग माळकु अऊर्द हाल किताब दा लिख्सकु शीलो अन छावनी दा यहोशू अन हाती बंदुर. ");
INSERT INTO hoy_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","आग यहोशू शीलो दा यहोवा अन मुंद आंदुर साटी चिट्टीगोळ हाकदुन; अदिक अल्या यहोशू इस्त्राएलगोळी आंदुर भागगोळ अनुसार द्याश वाट्स बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","बिन्यामीनगोळ कुल इन चिट्टी आंदुर कुलगोळ अनुसार होळ्त, अदिक आंदुर्द भाग यहूदा अदिक यूसुफियो अन बीच दा बीत्त. ");
INSERT INTO hoy_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","अदिक आंदुर उत्तरी सीमा यरदन टु चालु आत, अदिक यरीहो अन उत्तर इन दी टु यरतेला पश्चिम इन दी पहाळी द्याश दा आगकु बेतावेन इन आळी दा होळ्त; ");
INSERT INTO hoy_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","अल टु अद लूज इक होळ्त जो बेतेल भी कहलुसतद, अदिक लूज इन दक्षिणी इन दी टु आगतेला ल्यालमागोळ्द बेथोरोन इन दक्षिणी इन दी पहाळी इन हाती आग हतेला अत्रोतदार इक ईळुत. ");
INSERT INTO hoy_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","बाक पश्चिमी सीमा तिर्गकु बेथोरोन इन मुंद अदिक अदुर दक्षिणी इन दीकळोद पहाळी टु आगतेला किर्यतबाल हेसुर इन यहूदा अन ऊंद नगर मा होळ्त जो किर्यत्यारीम भी अनकु आगतद; पश्चिम इन सीमा ईदा ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","बाक दक्षिण इन दिकळोद सीमा पश्चिम टु चालु आगकु किर्यत्यारीम इन सिरे टु होटकु नेप्तोह इन झरना मा पोहचुस्त; ");
INSERT INTO hoy_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","अदिक आ पहाळी इन सिरे मा ईळुत, जो हिन्नोन उन पार उन तराई इन मुंद अदिक रपाईम हेसुर तराई इन उत्तर दी आद; अल टु हिन्नोम इन तराई दा, मतलब यबूसी इन दक्षिणी इन दी आगकु एनरोगेल झरना मा ईळुत; ");
INSERT INTO hoy_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","अल टु उत्तर दी तिर्गकु एनशेमेश इक होटकु आ गलीलोत इन दी होत, जो अदुम्मीम इन चळाई इन मुंद आद, बाक अल टु ईद रूबेन उन पार बोहन उन कल्ल ताका ईळुत; ");
INSERT INTO hoy_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","अल टु अद उत्तर इन दी होगकु अराबा अन मुंद इन पहाळी इन दी आगतेला यरदन गांगा अन घाटी दा ईळुत; ");
INSERT INTO hoy_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","अल टु सीमा बेथोग्ला अन उत्तर दी होगकु खारा समुद्र अन उत्तर दीकळोद घाटी मा यरदन इन उगम स्थान मा होळ्त; दक्षिण इन सीमा ईदा ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","अदिक पूर्व दिकळोद सीमा यरदन अच ठहरूस्त. बिन्यामीनगोळ भाग, नाकु दिकळोद सीमागोळ सांगुळ, आंदुर कुलगोळ अनुसार, ईदा ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","बिन्यामीनगोळ गोत्र अक आंदुर कुलगोळ अनुसार ईव नगर सिकदव, मतलब यरीहो, बेथोग्ला, एमेक्कसीस, ");
INSERT INTO hoy_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","बेतराबा, समारैम, बेतेल, ");
INSERT INTO hoy_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","अब्बीम, पारा, ओप्रा, ");
INSERT INTO hoy_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","कपरम्मोनी, ओप्रनी अदिक गेबा; ईव हन्नेळ नगर अदिक ईंदुरव ऊर सीकदव. ");
INSERT INTO hoy_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","बाक गिबोन, रामा, बेरोत, ");
INSERT INTO hoy_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","मिस्पे, कपीरा, मोसा, ");
INSERT INTO hoy_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","रेकेम, यिर्पेल, तरला, ");
INSERT INTO hoy_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","सेला, एलेप, यबूसी जो यरूशलेम भी कहलुसतान, गिबत अदिक किर्यत; ईव चौदहा नगर अदिक ईऊरव ऊर सीकदव. बिन्यामीनिगोळ भाग आंदुर कुलगोळ अनुसार ईवा ठहरूदव. ");
INSERT INTO hoy_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","दुसरा चिट्टी शिमोन उन हेसुर मा, मतलब शिमोनिगोळ कुलगोळ अनुसार आंदुर गोत्रगोळ हेसुर मा होळ्त; अदिक आंदुर भाग यहूदागोळ्द भाग इन बीच दा ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","आंदुर भाग दा ईव नगर आव, मतलब बेर्शेबा, शेबा, मोलादा, ");
INSERT INTO hoy_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","हसर्शूआल, बाला, एसेम, ");
INSERT INTO hoy_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","एलतोलद, बतूल होर्मा, ");
INSERT INTO hoy_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","सिकलग, बेतर्काबोत, अदिक हसर्शूसा; ईव तेरहा नगर अदिक अऊरव ऊर आंदरी सीकदव. ");
INSERT INTO hoy_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","बेतलबाओत, अदिक शारूहेन; ईव तेरहा नगर अदिक ईऊरव ऊर आंदरी सीकदव. ");
INSERT INTO hoy_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","बाक ऐन, रिम्मोन, एतेर, अदिक आशान, ईव नाक नगर ऊरगोळ सांगुळ; ");
INSERT INTO hoy_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","अदिक बालत्बेर जो दक्खिन द्याश इन रामा भी कहलुसतान, अल ताका ई नगर इन नाकु दिकळव सप्पा ऊर आंदरी सीकदव. शिमोन उन गोत्र अन भाग आंदुर कुलगोळ अनुसार ईल्या ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","शिमोनिया अन भाग रा यहूदा अन अंश दा टु कोटकु आत; यतिकी यहूदा अन भाग आंदुर साटी हापाळ ईरोद, ई कारण शिमोन उन भाग आंदुर अच भाग इन बीच ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","तीसरा चिट्टी जबूलूनिगोळ कुलगोळ अनुसार आंदुर हेसुर मा होळ्त. अदिक आंदुर भाग इन सीमा सारीद नगर ताका पोहचुस्त; ");
INSERT INTO hoy_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","अदिक आंदुर सीमा पश्चिम इन दी मरला टु आगतेला दब्बेशेत इक पोहचुस्त, अदिक योकनाम इन मुंद इन नाला ताका पोहचुसेत; ");
INSERT INTO hoy_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","बाक सारीद टु अद सुर्योदय दी तिर्गकु किसलोत्ताबोर इन सीमा ताका पोहचुस्त, अदिक अल टु वाळुसतेला दाबरत दा होळ्त, अदिक यापी दी होग कुर्त; ");
INSERT INTO hoy_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","अल टु अद पूर्व इन दी मुंद वाळुस्कु गथेपेर अदिक इत्कासीन इन होत, अदिक आ रिम्मोन दा होळ्त जो नेआ दिशा ताका फैलुसकु आद; ");
INSERT INTO hoy_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","अल टु अद सीमा आऊन उत्तर इन दी टु तिर्गकु हन्नातोन मा पोहचुस्त; अदिक यिप्तहेल इन घाटी दा होगकु खतम आत; ");
INSERT INTO hoy_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","कत्तात, नहलाल, शिम्रोन, यिदला, अदिक बैतलहम; ईव हन्नेळ नगर आंदुर ऊर सांगुळ अदा भाग इक ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","जबूलूनिगोळ भाग आंदुर कुलगोळ अनुसार ईदा ठहरूस्त; अदिक अदुर दा तान ऊर इन सांगुळ ईवा नगर आव. ");
INSERT INTO hoy_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","चौथा चिट्टी इस्साकारीगोळ कुलगोळ अनुसार आंदुर हेसुर मा होळ्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","अदिक आंदुर्द सीमा यिज्रेल, कसुल्लोत, शूनेम, ");
INSERT INTO hoy_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","हपारैम, शीओन, अनाहरत, ");
INSERT INTO hoy_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","रब्बीत, किश्योन, एबेस, ");
INSERT INTO hoy_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","रेमेत, एनगन्नीम, एनहदा, अदिक बेत्पस्सेस ताका पोहचुस्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","बाक अद सीमा ताबोर, शहसूमा अदिक बेतशेमेश ताका पोहचुस्त, अदिक आंदुर सीमा यरदन गांगा मा होगकु खतम आत; ई प्रकार आंदरी सोला नगर तान तान ऊरगोळ सांगुळ सिकदव. ");
INSERT INTO hoy_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","कुलगोळ अनुसार इस्साकारीगोळ इन गोत्र अन भाग नगरगोळ अदिक ऊरगोळ सांगुळ कोटकु आत. ");
INSERT INTO hoy_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","पाचवा चिट्टी आशेर गोत्र अन कुलगोळ अनुसार आंदुर हेसुर मा होळ्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","आंदुर सीमा दा हेल्कात, हली, बेतेन, अक्षाप, ");
INSERT INTO hoy_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","अलाम्मेल्लेक, अमाद, अदिक मिशाल ईरोर; अदिक पश्चिम इन दी कर्मेल ताका अदिक शीहोर्लिब्रात ताका पोहचुस्त; ");
INSERT INTO hoy_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","बाक अद सुर्योदय दी तिर्गकु बेतदागोन इक होत, अदिक जबूलून इन भाग ताका, अदिक यिप्तहेल इन तराई देल उत्तर इन दी आगकु बेतेमेक अदिक निएल ताका पोहचुस्त; अदिक उत्तर इन दी होगकु काबूल मा होळ्त, ");
INSERT INTO hoy_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","अदिक अद एब्रोन, रहोब, हम्मोन, अदिक काना से आगकु धोळ्द सीदोन इक पोहचुस्त; ");
INSERT INTO hoy_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","अल टु अद सीमा तिर्गकु रामा टु आगतेला सोर हेसुर इन किला अन नगर ताका होटोत; बाक सीमा होसा अन दी तिर्गकु अकजीब इन हाती इन द्याश दा आगकु समुद्र मा खतम आत, ");
INSERT INTO hoy_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","उम्मा, अपेक, अदिक रहोब भी आंदुर भाग दा ठहरूसदव ई प्रकार बाईस नगर तान तान ऊरगोळ सांगुळ आऊक सिकदव. ");
INSERT INTO hoy_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","कुलगोळ अनुसार आशेर गोत्र अन भाग नगरगोळ अदिक ऊरगोळ सांगुळ ईदा ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","छटवा चिट्टी नप्तालीगोळ कुलगोळ अनुसार आंदुर हेसुर मा होळ्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","अदिक आंदुर सीमा हेलेप टु, अदिक सानन्नीम इन बांज मार्र से, अदामीनेकेब अदिक यब्नेल टु आगकु, अदिक लक्कूम इक होगकु यरदन मा खतम आत; ");
INSERT INTO hoy_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","अल अद सीमा पश्चिम इन दी तिर्गकु अजनोत्ताबोर इक होत, अदिक अल टु हुक्कोक इक होत, अदिक दक्षिण, अदिक जबूलून इन भाग ताका, अदिक पश्चिम इन दी आशेर इन भाग ताका, अदिक पूर्व दी यहूदा अन भाग इन हाती यरदन गांगा मा पोहचुस्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","अदिक आंदुर किला अन नगर ईव हुव, मतलब सिद्दीम, सेर, हम्मत, रक्कत, किन्नेरेत, ");
INSERT INTO hoy_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","अदामा, रामा, हासोर, ");
INSERT INTO hoy_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","केदेश, एद्रेई, एन्हासोर, ");
INSERT INTO hoy_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","यिरोन, मिगदलेल, होरेम, बेतनात, अदिक बेतशेमेश; ईव उन्नीस नगर ऊरगोळ सांगुळ आऊक सिकदव. ");
INSERT INTO hoy_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","कुलगोळ अनुसार नप्तालीगोळ गोत्र अन भाग नगरगोळ अदिक आंदुर ऊरगोळ सांगुळ ईदा ठहरूस्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","सातवा चिट्टी कुलगोळ अनुसार दानिगोळ गोत्र अन हेसुर मा होळ्त. ");
INSERT INTO hoy_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","अदिक आंदुर भाग न सीमा दा सोरा, एशताओल, ईरशेमेश, ");
INSERT INTO hoy_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","शालब्बीन, अय्यालोन, यितला, ");
INSERT INTO hoy_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","एलोन, तिम्ना, एक्रोन, ");
INSERT INTO hoy_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","एलतके, गिब्बतोन, बालात, ");
INSERT INTO hoy_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","यहूद, बनेबराक, गत्रिम्मोन, ");
INSERT INTO hoy_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","मेयर्कोन, अदिक एक्कोन ठहरूसदव, अदिक याफा अन मुंदळोद सीमा भी आंदुर्द ईरोद. ");
INSERT INTO hoy_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","अदिक दानिगोळ भाग ईदुर से येक्‍कुल आगेत, मतलब दानी लेशेम मा यारीकु आऊन से लळुसदुर, अदिक आऊक हुडुकु तलवार देल कोंद बुट्टुर, अदिक आऊक तान अधिकार दा माळकु अल बसुसेदुर, अदिक तान मुल मंळसा अन हेसुर मा लेशेम इन हेसुर दान ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","कुलगोळ अनुसार दानिगोळ गोत्र अन भाग नगरगोळ अदिक ऊरगोळ सांगुळ ईदा ठहरूस्त ");
INSERT INTO hoy_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","याग द्याश इन वाट्सकु आगोद सीमागोळ अनुसार पुरा आगेत, आग इस्त्राएली इन नून इन पार यहोशू उक भी तान बीच दा ऊंद भाग कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","यहोवा अन अनोद अनुसार आंदुर आऊक आऊन बेळ्द नगर कोट्टुन, ईद एप्रैम इन पहाळी द्याश दाकळोद तिन्मत्सेरह आद; अदिक अद आ नगर इक मात्त बसुस्कु अल ईरली कुरतुन. ");
INSERT INTO hoy_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","जो जो भाग एलीआजर याजक, अदिक नून उन पार यहोशू, अदिक इस्त्राएलीगोळ गोत्र अन घराना अन पुर्वजगोळ मुख्य मुख्य मंळसागोळ शीलो दा, भेंट माळोद तम्बु मा, यहोवा अन मुंद चिट्टी हाक्कु हाक हाक्कु वाट्स बुट्टुर ईव अवा हु. ई प्रकार आंदुर द्याश विभाजन इन क्याल्सा पुरा माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","बाक यहोवा यहोशू से अंदुन, ");
INSERT INTO hoy_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","इस्त्राएलगोळ इक ईद अन, “ना मूसा अन द्वारा नीम से शरण नगरगोळ्द जो चर्चा माळीदिन अदुर अनुसार आंदरी ठहरूस बुळ. ");
INSERT INTO hoy_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","यार से जो यातोदारा भुल देल बिना जान्सकु यारीकारा कोंद बुट्टार, आव आंदुर दा टु येल्यारा भी ओळुल; इदुरसाटी अव नगर रक्ता अन बदला ताकोमावाळेर से ऊळोरसाटी नीम शरणस्थान ठहरूसुल.” ");
INSERT INTO hoy_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","“आ मंळसा ईद माळ पायजे, याग आव ओळतान अदिक आ नगरगोळ दा टु यातोदारा ऊंद दा पहुचुसतान रा आऊक नगर द्वार मा रोक्स पायजे अदिक नगर इन स्याणा मंळसागोळी हेळ पायजे कि येन आग्याद, आग नगर प्रमुख आऊक नगर दा प्रवेश माळगोळ सकतार, आंदुर आऊक तान बीच दा ईरोद जागा कोट्टार. ");
INSERT INTO hoy_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","अदिक अगर खून इन बदला ताकोमावाळा आऊन पीछा माळुल, रा आंदुर ईद जान्सकु कि आव तान मान्ना हातीगोळोव बीना जान्सकु अदिक पयले आऊन से बीना दुश्मनी ईटकु कोंदुन, आ खूनी इक आऊन कय कोळबाळी. ");
INSERT INTO hoy_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","अदिक यागासताका आव मंडली इन मुंद न्याय इन साटी निदरालुन अदिक यागासताका आ दिन इन महायाजक सोतोगालुन, आगासताका आव अदा नगर दा ईरूल; अदुर बाद्दा आव खुनी तान नगर इक यदुर देल आव वोळकु बंदान आव तान मान्या बाक होग सकतान.” ");
INSERT INTO hoy_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","अत: आंदुर नप्ताली इन पहाळी द्याश दा गलील इन केदेश इक, अदिक एप्रैम इन पहाळी द्याश दा शकेम इक, अदिक यहूदा अन पहाळी द्याश दा, किर्यतर्बा अक, जो हेब्रोन भी कहलुसतद अदिक शरण नगर अंदकु आगतद. ");
INSERT INTO hoy_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","अदिक यरीहो अन हात्तीगोळोद यरदन इन पूर्व इन दी आंदुर रूबेन उन गोत्र अन भाग दा बेसेर नगर इक, जो आळी दा चौरस जमीन मा बसुस्कु आद अदिक गाद इन गोत्र भाग दा गिलाद इन रामोत इक, अदिक मनश्शे अन गोत्र अन भाग दा बाशान इन गोलान नगर इक ठहरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","सप्पा इस्त्राएलगोळ साटी अदिक आंदुर न्याड्या ईरावाळेर परदेशीगोळ साटी भी जो नगर ईद मनसा देल ठहरूसकु आदुर कि जो यावारा यातोदारा प्राणी इक भुल देल कोंदान आव आंदुर दा टु यारदारा दा ओळेगुल, अदिक यागासताका न्याय इन साटी मंडली इन मुंद निदरालुन आगासताका रक्ता अन बदला ताकोमावाळा आऊक कोन्न सकालुन अव ईवा नगरगोळ हूँ. ");
INSERT INTO hoy_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","आग लेवीगोळ पुर्वजगोळोर घराना अन मुख्य मुख्य मंळसा एलीआजर याजक, अदिक नून उन पार यहोशू, अदिक इस्त्राएली गोत्र अन पुर्वजगोळ घराना अन मुख्य मुख्य मंळसागोळ हाती बंदकु ");
INSERT INTO hoy_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","कनान द्याश इन शीलो नगर दा अनली कुरतुर, “यहोवा मूसा अन द्वारा नामी बसुसोर साटी नगर, अदिक नाम जनावर साटी अवा नगर इन चराई भी कोळोद आग्या कोटीदुन.” ");
INSERT INTO hoy_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","आग इस्त्राएली यहोवा अन अनोद अनुसार तान तान भाग दा टु लेवीगोळी चराई अन सांगुळ ईव नगर कोट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","आग कहातिगोळ कुलगोळ हेसुर मा चिट्टी तेगदुर. इदुरसाटी लेवीगोळ दा टु हारून याजक इन वंश इक यहूदी, शिमोन, अदिक बिन्यामीन इन गोत्रगोळ भाग दा टु तेरहा नगर सीकदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","बाकी कहातिगोळी एप्रैम इन गोत्र अन कुलगोळ, अदिक दान उन गोत्र, अदिक मनश्शे अन आरधा गोत्र अन भागगोळ दा चिट्टी हाक हाक्कु हत्त नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","बाक गेर्शोनीगोळी इस्साकार इन गोत्र अन कुलगोळ, अदिक आशेर, अदिक नप्ताली इन गोत्र अन भागगोळ दा टु, अदिक मनश्शे अन आ आरधा गोत्र अन भागगोळ दा टु भी जो बाशान दा ईरोन चिट्टी हाक हाक्कु तेरहा नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","कुलगोळ अनुसार मरारीगोळ इक रूबेन, गाद, अदिक जबूलून इन गोत्र अन भागगोळ दा टु हन्नेळ नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","जो आग्या यहोवा मूसा अन द्वारा कोटीदुन अदुर अनुसार इस्त्राएलीगोळ लेवीगोळी चराई सांगुळ ईव नगर चिट्टी हाक हाक्कु कोट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","आंदुर यहूदागोळ अदिक शिमोन उन गोत्र अन भागगोळ दा टु ईव नगर यारव हेसुर लिख्सकु आंदरी कोट्टुर; ");
INSERT INTO hoy_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","ईव नगर लेवीय कहाती कुलगोळ दा टु हारून इन वंश इन साटी ईरव; यतिकी पयला चिट्टी आंदुर अच हेसुर मा होटीत. ");
INSERT INTO hoy_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","मतलब आंदुर आंदरी यहूदा अन पहाळी द्याश दा नाकु दीकळोद चराई सांगुळ किर्यतर्बा नगर कोट बुट्टुन, जो अनाक उन आप्प अर्बा अन हेसुर मा कहलुसदुन अदिक हेब्रोन भी कहलुसतान. ");
INSERT INTO hoy_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","लेकीन आ नगर इन केई अदिक आऊन ऊर आंदुर यपुन्ने उन पार कालेब उक आऊन खुद इन जमीन माळकु कोट बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","आग आंदुर हारून याजक इन वंश इन चराईगोळ सांगुळ खूनी इन शरण नगर हेब्रोन, अदिक तान तान चराई सांगुळ लिब्ना, ");
INSERT INTO hoy_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","यत्तीर, एश्तमो, ");
INSERT INTO hoy_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","होलोन, दबीर, ");
INSERT INTO hoy_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","ऐन, यूता, अदिक बेतशेमेश कोट्टुर, ई प्रकार आ येढ्ढु गोत्रगोळ भाग दा टु ऊम्बत नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","अदिक बिन्यामीन इन गोत्र अन भाग दा टु तान तान चराई सांगुळ ईव नाक नगर कोटकु आदव, मतलब गिबोन, गेबा, ");
INSERT INTO hoy_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","अनातोत अदिक अल्मोन. ");
INSERT INTO hoy_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","ई प्रकार हारून वंशी याजकगोळी तेरहा नगर अदिक आंदुरव चराईगोळ सीकदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","बाक बाकी कहाती लेवीगोळ कुलगोळ भाग इन नगर चिट्टी हाक हाक्कु एप्रैम इन गोत्र अन भाग दा टु कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","मतलब आंदरी चराई सांगुळ एप्रैम उन पहाळी द्याश दा खूनी इन शरण ताकोमोद शकेम नगर कोटकु आत, बाक तान तान चराई सांगुळ गेजेर, ");
INSERT INTO hoy_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","किबसैम, अदिक बेथोरोन; ईव नाक नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","अदिक दान इन गोत्र अन भाग दा टु तान तान चराई सांगुळ, एलतके, गिब्बतोन, ");
INSERT INTO hoy_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","अय्यालोन, अदिक गत्रिम्मोन; ईव नाक नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","अदिक मनश्शे अन आरधा गोत्र अन भाग दा टु तान तान चराईगोळ सांगुळ तानाक अदिक गत्रिम्मोन; ईव येढ्ढ नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","ई प्रकार बाकी कहातिगोळ कुलगोळ सप्पा नगर चराई सांगुळ हत्त ठहरूसदुर. ");
INSERT INTO hoy_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","बाक लेवीगोळ कुल दाकळोर गेर्शोनीगोळी मनश्शे अन आरधा गोत्र अन भाग दा टु तान तान चराई सांगुळ खूनी इन शरण नगर बाशान उन गोलान अदिक बेशतरा; ईव येढ्ढ नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","अदिक इस्साकार इन गोत्र अन भाग दा टु तान तान चराई सांगुळ किश्योन, दाबरत, ");
INSERT INTO hoy_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","यर्मूत, अदिक एनगन्नीम; ईव नाक नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","अदिक आशेर इन गोत्र अन भाग दा टु तान तान चराईगोळ सांगुळ मिशाल, अब्दोन, ");
INSERT INTO hoy_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","हेल्कात, अदिक रहोब; ईव नाक नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","अदिक नप्ताली इन गोत्र अन भाग दा टु तान तान चराईगोळ सांगुळ खूनी इन शरण नगर गलील इन केदेश, बाक हम्मोतदोर, अदिक कर्तान; ईव मुर नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","गेर्शोनीगोळ कुलगोळ अनुसार आंदुर सप्पा नगर तान तान चराई सांगुळ तेरहा ठहरूसदुर. ");
INSERT INTO hoy_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","बाक बाकी लेवीगोळ, मतलब मरारीगोळ कुलगोळी जबूलून इन गोत्र अन भाग दा टु तान तान चराई सांगुळ योकनाम, कर्ता, ");
INSERT INTO hoy_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","दिम्ना, अदिक नहलाल; ईव नाक नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","अदिक रूबेन इन गोत्र अन भाग दा टु तान तान चराई सांगुळ बेसेर, यहसा, ");
INSERT INTO hoy_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","कदेमोत, अदिक मेपात; ईव नाक नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","अदिक गाद इन गोत्र अन भाग दा टु तान तान चराई सांगुळ खूनी इन शरण नगर गिलाद दाकळोद रामोत, बाक महनैम, ");
INSERT INTO hoy_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","हेशबोन, अदिक याजेर, जो सप्पा मीलुसकु नाक नगर कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","लेवीगोळ बाकी कुलगोळ मतलब मरारीगोळ कुलगोळ अनुसार आंदुर सप्पा ईवा ठहरूसदव, ई प्रकार आंदरी हन्नेळ नगर चिट्टी हाक हाक्कु कोटकु आदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","इस्त्राएलगोळ्द निज भूमी इन बीच लेवीगोळ सप्पा नगर तान तान चराई सांगुळ अळतालीस ठहरूसदव. ");
INSERT INTO hoy_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","ईव सप्पा नगर तान तान नाकु दीकळव चराईगोळ सांगुळ ठहरूसदव; ई सप्पा नगरगोळ्द ईदा दशा ईरोद. ");
INSERT INTO hoy_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","ई प्रकार यहोवा इस्त्राएलगोळी अद सप्पा द्याश कोट्टुन, यदरी आव आंदुर पुर्वजगोळ से किर्‍या तीनकु कोळली हेळीदुन; अदिक आंदुर आऊन अधिकारी आगकु अल बसुसेदुर. ");
INSERT INTO hoy_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","अदिक यहोवा आ सप्पा मातगोळ अनुसार, जो आव आंदुर पुर्वजगोळ से किर्‍या तीनकु अंदीदुन, आंदरी नाकु दी टु आराम कोट्टुन; अदिक आंदुर दुश्मनगोळ दा टु याऊ भी आंदुर मुंद टिक्स सकीदील; यतिकी यहोवा आ सप्पा अक आंदुर वश दा माळ बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","यास भलाई इन मातगोळ यहोवा इस्त्राएल इन घराना टु अंदीदुन अदुर दा टु यातोदु मात भी बिटीदील; सप्पा च्या सप्पा पुरा आदव. ");
INSERT INTO hoy_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","आ समय यहोशू रूबेनिगोळ, गादीगोळ अदिक मनश्शे अन आर्धा वंश इन लॉकुरी कारूकु अंदुन. ");
INSERT INTO hoy_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","“जो जो आग्या परमेश्वर उन दास मूसा नीमी कोटीदुन अव सप्पा नीव मान्सदीर, अदिक जो जो आग्या ना नीमी कोटीन आ सप्पा अक भी नीव मान्सदीर. ");
INSERT INTO hoy_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","नीव तान वार्टुरी ईस दिनगोळ दा ईंद ताका बिटीदील, लेकीन तान परमेश्वर यहोवा अन आग्या नीव वळ्लीसा पालन माळदीर. ");
INSERT INTO hoy_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","अदिक ईग नीम परमेश्वर यहोवा नीम वार्टुरी तान वचन इन अनुसार आराम कोटान; इदुरसाटी ईग नीव वापस होगकु तान ड्यारा अक, अदिक तान खुद इन जागा दा, यदरी परमेश्वर उन दास मूसा यरदन इन आपाटी नीमी कोटान, ओळेगी. ");
INSERT INTO hoy_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","केवल ई मात इन चौकसी माळी कि जो जो आग्या अदिक व्यवस्था परमेश्वर उन दास मूसा नीमी कोटान अदरी मान्सकु तान परमेश्वर यहोवा से प्रेम ईटी, आऊन सप्पा हादीगोळ मा नळी, आऊन आग्यागोळी मान्सी, आऊन भक्ति दा लवलीन ईरी, अदिक तान सप्पा मन अदिक सप्पा प्राण देल आऊन स्यावा माळी.” ");
INSERT INTO hoy_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","आग यहोशू आंदरी आशीर्वाद कोटकु सार्र माळदुन; अदिक आंदुर तान तान ड्यारा अक होटोदुर. ");
INSERT INTO hoy_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","मनश्शे अन आरधा गोत्रगोळी मूसा बाशान दा भाग कोटीदुन; लेकीन आरधा गोत्र अक यहोशू आंदुर वार्टुर बीच यरदन इन पश्चिम इन दी भाग कोट्टुन, आंदरी याग यहोशू सार माळदुन कि तान तान ड्यारा दा होगुल, ");
INSERT INTO hoy_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","आग आंदरी भी आशीर्वाद कोटकु अंदुन, “हापाळ सा जनावर, अदिक व्हान्ना, बेळ्ली, पीतल, लोहा, अदिक हापाळ सा कपळा अदिक हापाळ सा धन सम्पत्ति हुडुकु तान तान ड्यारा अक वापस होगी; अदिक तान शत्रुगोळ्द लूट इन सम्पत्ती इक तान वार्टुर सांगुळ वाट्स कोमेतीर.” ");
INSERT INTO hoy_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","आग रूबेनी, गादी, अदिक मनश्शे अन आरधा गोत्र इस्त्राएल इन हाती टु, मतलब कनान द्याश इन शीलो नगर टु, तान गिलाद हेसुर इन खुद इन जागा दा, जो मूसा अन द्वारा कोटकु आत, यहोवा अन आग्या अन अनुसार आदुर्द खुद इन जागा आगेगीत, होगोद विचार देल वापस होदुर. ");
INSERT INTO hoy_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","अदिक रूबेनी गादी, अदिक मनश्शे अन आरधा गोत्र यरदन इन आ तराई दा पोहचुसदुर जो कनान द्याश दा आद, आग आंदुर अल नोळोद योग्य ऊंद धोळ्द वेदी माळदुर. ");
INSERT INTO hoy_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","अदिक ईदुर समाचार इस्त्राएलगोळ केळदुर दा बत्त, कि रूबेनिगोळ, गादीगोळ, अदिक मनश्शे आरधा गोत्रगोळ कनान द्याश इन मुंद यरदन इन तराई दा, मतलब अदुर आप्पाटी जो इस्त्राएलगोळ्द आद, ऊंद वेदी माळ्यार. ");
INSERT INTO hoy_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","याग इस्त्राएलगोळ ईद केळदुर, आग इस्त्राएलीगोळ्द सप्पा मंडली आंदुर से लळुसोर साटी चढाई माळली शीलो दा जमा आत. ");
INSERT INTO hoy_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","आग इस्त्राएलीगोळ रूबेनिगोळ, गादीगोळ, अदिक मनश्शे अन आरधा वंश इन लॉकुर हाती गिलाद द्याश दा एलीआजर याजक उन पार पीनहास उक, ");
INSERT INTO hoy_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","अदिक आऊन सांगुळ हत्त प्रधानगोळी, मतलब इस्त्राएल इन ऊंद ऊंद गोत्र दा टु पूर्वजगोळ घराना अन ऊंद ऊंद प्रधान इक कळुदुन, अदिक आंदुर इस्त्राएल इन हजारगोळ दा तान तान पूर्वजगोळ घराना अन मुख्य मंळसा ईरोर. ");
INSERT INTO hoy_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","आंदुर गिलाद द्याश दा रूबेनिगोळ, गादीगोळ, अदिक मनश्शे अन आरधा वंश इन लॉकुर हाती होगकु अनली कुरतुर, ");
INSERT INTO hoy_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“यहोवा अन सप्पा मंडली ईद अनतद, कि ‘नीव इस्त्राएल यहोवा परमेश्वर उन ईद ह्यांग विश्वासघात माळीर; ईंद जो नीव ऊंद वेदी माळीर, ईदुर दा नीव आऊन हिंद नळोद बिटकु आऊन खिलाप ईंद लळाई माळीर?’ ");
INSERT INTO hoy_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","केळी, पोर नगर इन विषय इन अधर्म नाम साटी येनारा कम ईरोद, अगर यहोवा अन मंडली इक भारी दण्ड सिक्त भी रा ईंद इन दिन ताका नाव आ अधर्म देल शुद्ध आगीदील; येन अद नीम नजर दा ऊंद श्याण मात आद, ");
INSERT INTO hoy_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","कि ईंद नीव यहोवा अक त्यागस्कु आऊन हिंद नळोद बीट बुळतीर? येन नीव यहोवा टु तिर्गेगतीर, अदिक नाळ आव अद इस्त्राएल इन मंडली देल गुस्सा आदान. ");
INSERT INTO hoy_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","लेकीन अगर नीम खुद इन जागा अशुद्ध आद, रा ईपाटी बंदकु यहोवा अन खुद इन जागा दा, येल यहोवा अन निवास ईरतद, नाम लॉकुर बीच तान तान खुद इन जागा माळ बुळी; लेकीन नाम परमेश्वर यहोवा अन वेदी इक बिटकु अदिक यातोदारा वेदी माळकु न रा यहोवा से लळाई माळी, अदिक न नाम से. ");
INSERT INTO hoy_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","नोळी, याग जेरह अन्द पार आकान अर्पण माळ्द वस्तु अन बारा दा विश्वासघात माळदुन, आग येन यहोवा अन कोप इस्त्राएल इन पुरा मंडली मा ईला भळकुसीत? अदिक आ मंळसा अन अधर्म अन प्राणदण्ड आबना आऊक ईला सिकीत.” ");
INSERT INTO hoy_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","आग रूबेनिगोळ, गादीगोळ, अदिक मनश्शे अन आरदा वंश इस्त्राएल इन हजारो अन मुख्य मंळसागोळ इक ईद उत्तर कोट्टुर, ");
INSERT INTO hoy_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“यहोवा जो ईश्वरगोळोव परमेश्वर हुन, ईश्वरगोळ परमेश्वर यहोवा ईदरी जान्सतान, अदिक इस्त्राएली भी ईदरी जान्स कोंडार, कि अगर यहोवा टु तिर्गकु या आऊन विश्वासघात माळकु नाव ईद क्याल्सा माळेव, रा नी ईंद नाम इक जीत्ता बिळबाळ, ");
INSERT INTO hoy_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","अगर ईंद इन दिन नाव वेदी इक इदुरसाटी माळेव कि यहोवा अन हिंद नळोद बीट बुट्टेव, या इदुरसाटी कि अदुर मा होमबली, अन्नबली, या मेलबली येर्सेव, रा यहोवा नी खुद अच ईदुर हिसाब ताकोंडान; ");
INSERT INTO hoy_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","लेकीन नाव ईदा विचार अदिक मनसा देल ईद माळेव कि येल्यारा भविष्य दा नीम सन्तान नाम सन्तान से ईद अनली हतबाळुल, ‘नीमी इस्त्राएल इन परमेश्वर से येन क्याल्सा? ");
INSERT INTO hoy_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","यतिकी रूबेनिगोळ, हे गादीगोळ, यहोवा जो नाम अदिक नीम बीच दा यरदन इन सीमा ठहरूस्यान, इदुरसाटी यहोवा दा नीम येनु भाग हैलेच.’ हिंग अनकु नीम सन्तान नाम सन्तान दा टु यहोवा अन अंज्क बीळसुस बुट्टीत. ");
INSERT INTO hoy_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","इदुरसाटी नाव अंदेव, ‘बरी, नाव तान साटी ऊंद वेदी माळाता, अद होमबली या मेलबलि इन साटी ईला, ");
INSERT INTO hoy_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","लेकीन इदुरसाटी कि नाम अदिक नीम, अदिक नाम बाद्दा नीम अदिक नाम वंश इन बीच दा गवाही इन क्याल्सा कोळुल; इदुरसाटी नाव होमबली, अदिक मेलबली, अदिक बलिदान येर्सकु यहोवा अन हाती आऊन उपासना माळेव; अदिक भविष्य दा नीम औलाद नाम औलाद से ईद अन बाळुल, कि यहोवा दा नीम येनु भाग हैलेच.’ ");
INSERT INTO hoy_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","इदुरसाटी नाव अंदेव, ‘याग आ लॉकुर भविष्य दा नाम से या नाम वंश से ईद अनली कुरूल, आग नाव आऊन से अंदेव, कि यहोवा अन नमुना मा माळकु ईद वेदी इक नोळी, यदरी नाम पुर्वजगोळ इक, होमबली या मेलबलि, इन साटी माळीदिल, लेकीन इदुरसाटी माळदुर कि नाम अदिक नीम बीच दा गवाही इन क्याल्सा कोळुल.’ ");
INSERT INTO hoy_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","ईद नाम से दुर ईरूल कि यहोवा से तिर्गकु ईंद आऊन हींद नळोद बीट बुळुल, अदिक तान परमेश्वर यहोवा अन आ वेदी इक बिटकु जो आऊन निवास इन मुंद आद होमबली, अदिक अन्नबली, या मेलबलि इन साटी दुसरा वेदी माळुल.” ");
INSERT INTO hoy_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","रूबेनिगोळ, गादीगोळ, अदिक मनश्शे अन आरदा वंश इन लॉकुर्द ई मात केळकु पीनहास याजक अदिक आऊन सांगुळ मंडली इन प्रधान, जो इस्त्राएल इन हजारो अन मुख्य मंळसा ईरोर, आंदुर हापाळ खुश आदुर. ");
INSERT INTO hoy_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","अदिक एलीआजर याजक उन पार पीनहास रूबेनिगोळ, गादीगोळ, अदिक मनश्शेगोळ से अंदुन, “नीव जो यहोवा अन्द हिंग विश्वासघात माळीदिल, इदुर देल ईंद नाव ईद जान्स कोंडेव कि यहोवा नाम बीच दा आन: अदिक नीव लॉकुर इस्त्राएलगोळ इक यहोवा अन्द कय देल ऊळसीर.” ");
INSERT INTO hoy_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","आग एलीआजर उन पार पीनहास प्रधानगोळ सांगुळ रूबेनिगोळ, अदिक गादीगोळ हाती टु गिलाद आगतेला कनान द्याश दा इस्त्राएलगोळ हाती होट्ट बंदुन; अदिक ईद बातणी आंदरी अंदकु केळ्सदुन. ");
INSERT INTO hoy_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","आग इस्त्राएली खुश आदुर; अदिक परमेश्वर उक धन्य अंदुर, अदिक रूबेनिगोळ, अदिक गादीगोळ से लळुसली अदिक आंदुर ईरा द्याश ऊजळुसोर साटी चढाई माळोद मातचीत बाक माळीदिल. ");
INSERT INTO hoy_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","अदिक रूबेनिगोळ अदिक गादीगोळ ईद अंदकु, “ईद वेदी नाम अदिक आंदुर बीच दा ई मात इन गवाही ठहरूस्याद, कि यहोवा अच परमेश्वर हुन.” आ वेदी इन हेसुर एद ईटदुर. ");
INSERT INTO hoy_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","ईदुर हापाळ दिन इन बाद्दा, याग यहोवा इस्त्राएलगोळी आंदुर नाकु दीकळोर दुश्मनगोळ से आराम कोट्टुन, अदिक यहोशू हाळाबाट्ट अदिक हापाळ ऊमर ईनव आगेगीदुन. ");
INSERT INTO hoy_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","आग यहोशू सप्पा इस्त्राएलगोळी, मतलब पुरनियोंगोळ, मुख्य मंळसागोळ, न्यायीगोळ, अदिक सरदारगोळी कारसुसकु अनली कुरतुन, “ना रा ईग बाट्ट अदिक हापाळ ऊमर ईनव आगेदीन; ");
INSERT INTO hoy_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","अदिक नीव नोळदीर कि नीम परमेश्वर यहोवा नीम निमित्त ई सप्पा जातीगोळ से येन येन माळ्यान, यतिकी जो नीम दी टु लळुसतेला बंदान आव नीमव परमेश्वर यहोवा हुन. ");
INSERT INTO hoy_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","नोळी, ना ई मीकदव जातीगोळी चिट्टी हाक हाक्कु नीम वंश इन हिस्सा माळ कोंडीन; अदिक यरदन टु हुडुकु सुर्य मुळ्कतद आत्त धोळ समुद्र ताका ईरावाळा आ सप्‍पा जातीगोळी भी हिंग अच कोटीन, यदरी ना कळ्द बुटीन. ");
INSERT INTO hoy_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","अदिक नीम परमेश्वर यहोवा आंदरी नीम मुंदु टु आंदुर द्याश दा टु तेगु कोंडान; अदिक नीव तान परमेश्वर यहोवा अन वचन इन अनुसार आंदुर द्याश मा अधिकार माळ कोंडीर. ");
INSERT INTO hoy_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","इदुरसाटी हापाळ हिम्मत कटकु, जो येनारा मूसा अन किताब दा लिख्सकु आद अदरी पुरा माळोर दा ध्यान माळेतीर, अदुर से न रा ईत्त डोक्केतीर न आत्त. ");
INSERT INTO hoy_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","ईव जो जातीगोळ नीम बीच दा ईतोग्याव ईऊर बीच दा होगबाळेतीर, अदिक न ईंदुरव द्याव गोळोव हेसुर इन चर्चा माळेतीर, अदिक ना अऊर्द किर्‍या तीनसेतीर, अदिक ना अऊर उपासना माळेतीर, अदिक ना अवरी नमस्कार माळेतीर, ");
INSERT INTO hoy_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","लेकीन ह्यांग ईंद इन दीन ताका नीव तान परमेश्वर यहोवा अन भक्ति दा लवलीन ईरतीर, हांग अच ईरतोगेतीर. ");
INSERT INTO hoy_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","यहोवा नीम मुंद टु धोड्डेव धोड्डेव अदिक ताकतवर जातीगोळी तेगदान; अदिक नीम मुंद ईंद इन दीन ताका याऊ ठहरूस सकीदील. ");
INSERT INTO hoy_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","नीम दा टु ऊंद मंळसा हजार मंळसागोळी खेदाळस्यान, यतिकी नीम परमेश्वर यहोवा तान वचन इन अनुसार नीम दी टु लळुसतान. ");
INSERT INTO hoy_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","इदुरसाटी तान परमेश्वर यहोवा अन सांगुळ प्यार ईटोद पुरा ध्यान ईटेतीर. ");
INSERT INTO hoy_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","यतिकी अगर नीव यातोदारा रिती यहोवा से तिर्गकु ई जातीगोळ बाकी लॉकुर से मीलुसली कुरतीर जो नीम बीच उळुकु ईरतार, अदिक ईंदुर से सगाई मदा माळकु ईंदुर सांगुळ समधियाना रिश्ता जोळसीर, ");
INSERT INTO hoy_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","रा सहीदा जान्स कोमी कि मुंद नीमव परमेश्वर यहोवा ई जातीगोळी नीम मुंदु टु तेगुतिदील; अदिक ईंदुर नीम साटी जाल अदिक फंदा, अदिक नीम पांजरागोळ साटी कोळागोळ, अदिक नीम कण्‍ण दा मुळ्ल ठहरूस्यार, अदिक आखरी दा नीव ई वळ्लीद जागा मा टु जो नीम परमेश्वर यहोवा नीमी कोटान नाश आगेदीर. ");
INSERT INTO hoy_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“केळी, ईद नान सायोद समय आद, नीव जान्सतीर अदिक सहीदा विश्वास माळतीर कि यहोवा नीम साटी हापाळ धोड्डेव क्याल्सा माळ्यान, नीव जान्सतीर कि आव तान कोळ्द वचनगोळ दा टु यातोदु पुरा माळदुर दा असफल ईतीदील, यहोवा आ सप्पा वचनगोळी पुरा माळ्यान, जो आव नामी कोटान. ");
INSERT INTO hoy_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","अव सप्पा वळ्लेव वचन जो नीम परमेश्वर यहोवा नामी कोटान, पुरा तरीका देल सही आग्याव. लेकीन यहोवा, अदा तरीका देल दुसरा वचनगोळी भी सत्य माळ्यान, आव चेतावनी कोटान कि अगर नीव पाप माळीर आग नीम म्याकुच विपत्तीगोळ बंदव, आव चेतावनी कोटान कि आव नीमी आ द्याश इक बीळोर साटी विवश माळ्यान यदरी आव नीमी कोटान. ");
INSERT INTO hoy_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","ईद घटसीत, अगर नीव तान परमेश्वर यहोवा अन सांगुळ माळ्द वादा अन पालन माळोर से इनकार माळीर, अगर नीव द्यावगोळ हाती होदीर अदिक आंदुर स्यावा माळीर रा ई द्याश इक नीव खोऊस बुट्टीर, अगर नीव हिंग माळीर रा यहोवा नीम मा हापाळ सिट्टी बंदान, आग नीव ई वळ्लीद द्याश टु जल्दी से नाश आगेदीर यदरी आव नीमी कोटान.” ");
INSERT INTO hoy_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","बाक यहोशू इस्त्राएल इन सप्पा वंश इन लॉकुरी जमा माळदुन, अदिक इस्त्राएल इन बाट्ट लॉकुर, अदिक मुख्य मंळसा, अदिक न्यायीगोळी, अदिक सरदारगोळी कारसुसदुन; अदिक आंदुर परमेश्वर उन मुंद उपस्थित आदुर. ");
INSERT INTO hoy_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","आग यहोशू आ सप्पा लॉकुर से अंदुन, “इस्त्राएल उन परमेश्वर यहोवा ई प्रकार देल अनतान, कि ‘प्राचीनकाल दा अब्राहम अदिक नाहोर उन आप्प तेरह आदि, नीम पुरखा फरात महानद इन आप्पाटी ईरतेला दुसरा द्यावगोळ्द उपासना माळोर, ");
INSERT INTO hoy_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","अदिक ना नीम्द मुल मंळसा अब्राहम उक फरात इन आप्पाटी टु हुडुकु कनान द्याश इन सप्पा जागागोळ दा वयाळसदीन, अदिक आऊन वंश वाळुसदीन. अदिक अदरी इसहाक उक कोट्टीन; ");
INSERT INTO hoy_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","बाक इसहाक उक याकूब अदिक एसाव कोट्टीन. अदिक एसाव उक ना सेईर हेसुर इन पहाळी द्याश कोट्टीन कि आव अदुर अधिकारी आगुल, लेकीन याकूब पार नातुगोळ सांगुळ मिस्त्र अक होदुन. ");
INSERT INTO hoy_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","बाक ना मूसा अदिक हारून उक कळकु आ सप्पा क्याल्सागोळ द्वारा जो ना मिस्त्र दा माळदीन आ द्याश इक नष्ट माळ कोंडीन; अदिक अदुर बाद्दा नीमी तेगुकु तंदीन. ");
INSERT INTO hoy_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","अदिक ना नीम पुरखागोळी मिस्त्र दा टु तेगुकु तंदीन, अदिक नीव समुद्र अन हाती पोहचुसदीर, अदिक मिस्त्रीगोळ रथ अदिक सवारगोळी सांगुळ हुडुकु क्याचाँद समुद्र ताका नीम्द पीछा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","अदिक याग नीव यहोवा अन दुहाई कोट्टीर आग आव नीम्द अदिक मिस्त्रीगोळ बीच दा अंधार माळ बुट्टुन, अदिक आंदुर मा समुद्र अक वाहुसकु आंदरी मुळ्क्सदुन; अदिक जो येनारा ना मिस्त्र दा माळदीन अदरी नीव लॉकुर तान कण्ण देल नोळदीर; बाक नीव हापाळ दिन ताका आळी दा ईत्तीर. ");
INSERT INTO hoy_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","आग ना नीमी आ एमोरियो अन द्याश दा तंदीन, जो यरदन गांगा अन आप्पाटी पूर्व दिशा दा बसुस्कु ईरोर; अदिक आंदुर नीम से लळुसदुर अदिक ना आंदरी नीम वश दा माळ बुट्टीन, अदिक नीव आंदुर द्याश इन अधिकारी आगेदीर, अदिक ना आंदुर नीम मुंद टु सत्यानाश माळ कोंडीन. ");
INSERT INTO hoy_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","बाक मोआब इन राजा सिप्पोर उन पार बालाक यदकु इस्त्राएल से लळुसदुन; अदिक नीमी श्राप कोळोर साटी बोर उन पार बिलाम उक कारसुसदुन, ");
INSERT INTO hoy_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","लेकीन ना बिलाम उन केळीदील; आव नीमी आशीष अच आशीष कोळतेला होदुन; ई प्रकार देल ना नीमी इक आऊन कय दा टु ऊळ्सदीन. ");
INSERT INTO hoy_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","आग नीव यरदन पार आगकु यरीहो अन हाती बंदीर, अदिक याग यरीहो अन लॉकुर, अदिक एमोरी, परिज्जी, कनानी, हित्ती, गिर्गाशी, हिब्बी, अदिक यबूसी नीम से लळुसदुर, आग ना आंदरी नीम वश दा माळ कोंडीन. ");
INSERT INTO hoy_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","अदिक ना नीम मुंद बर्रागोळी कळुदीन, अदिक आंदुर एमोरीयो अन येढ्ढु राजागोळी नीम मुंदु टु तुकाळसदुन; नोळी, ईद नीम्द तलवार या धनुष इन ताकत देल आगीदील. ");
INSERT INTO hoy_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","बाक ना नीमी हिंग द्याश कोट्टीन यदुर दा नीव मयनत माळीदिल, अदिक हिंग नगर भी कोट्टीन यवरी नीव ईला बसुसीदिर, अदिक नीव अल बसुस्कु आईर; अदिक याता दाख अदिक जैतून इन बगीचा अन काय नीव तीनतीर अवरी नीव हचीदिल.’ ");
INSERT INTO hoy_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“इदुरसाटी ईग यहोवा अन अंज्क मान्सकु आऊन स्यावा खराई अदिक सच्चाई देल माळी; अदिक याता द्यावगोळ्द स्यावा नीम पुर्वज मेसोपोटामिया अदिक मिस्त्र दा माळतोगोर, आंदरी दुर माळकु यहोवा अन स्यावा माळी. ");
INSERT INTO hoy_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","अदिक अगर यहोवा अन स्यावा माळोद नीमी बुरा हततद, रा ईंद नीवळुस बुळी कि नीव यार्द स्यावा माळीर, बाक आ द्यावगोळ्द यार्द स्यावा नीम पुर्वज मेसोपोटामिया दा माळतोगोर, अदिक बाक एमोरीगोळ द्यावगोळ्द स्यावा माळी यारव द्याश दा नीव ईरतीर; लेकीन ना रा तान घराना अन सांगुळ यहोवा अन अच स्यावा हमेशा माळतेला ईराईन.” ");
INSERT INTO hoy_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","आग लॉकुर उत्तर कोट्टुर, “यहोवा अक त्यागस्कु दुसरा द्यावगोळ्द स्यावा माळोद विचार नाव यागलु माळतीदील; ");
INSERT INTO hoy_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","यतिकी नाम परमेश्वर यहोवा आवा हुन जो नामी अदिक नाम पुर्वजगोळी मिस्त्र द्याश टु तेगुकु तंदुन, अदिक नाम नोळतेला धोळ धोळ आश्चर्यकर्म माळदुन, अदिक याता हादी मा अदिक यास जातीगोळ बीच दा टु नाव नळकु बरतोगेव आंदुर नाम रक्षा माळदुन; ");
INSERT INTO hoy_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","अदिक नाम मुंद ई द्याश दा ईरावाळा एमोरी अदिक सप्पा जातीगोळी तेगु कोंडान; इदुरसाटी नाव भी यहोवा अन स्यावा माळेव, यतिकी नामव परमेश्वर आवा हुन.” ");
INSERT INTO hoy_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","यहोशू लॉकुर से अंदुन, “नीम से यहोवा अन स्यावा आग सकाल; यतिकी आव पवित्र परमेश्वर हुन; आव जलन ईटावाळा परमेश्वर हुन, आव नीम अपराध अदिक पाप क्षमा माळतीदील. ");
INSERT INTO hoy_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","अगर नीव यहोवा अक त्यागस्कु पराया द्यावगोळ्द स्यावा माळीर, रा आव भले ही नीम भला माळ्त बंदीदान तरी भी आव तिर्गकु नीम्द हानि माळ्यान अदिक नीम्द अंत भी माळ कोंडान.” ");
INSERT INTO hoy_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","लॉकुर यहोशू से अंदुर, “ईला; नाव यहोवा अंद अच स्यावा माळेव.” ");
INSERT INTO hoy_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","यहोशू लॉकुर से अंदुन, “नीव खुद अच तान गवाह हूईर कि नीव यहोवा अन स्यावा माळोद नीवळुसदीर.” आंदुर अंदुर, “हव, नाव साक्षी आयेव.” ");
INSERT INTO hoy_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","यहोशू अंदुन, “तान बीच दा टु पराया द्यावगोळी इक दुर माळकु तान तान मन इस्त्राएल उन परमेश्वर यहोवा अन दी हची.” ");
INSERT INTO hoy_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","लॉकुर यहोशू से अंदुर, “नाव रा तान परमेश्वर यहोवा अन अच स्यावा माळेव, अदिक आऊंद अच मात मानसेव.” ");
INSERT INTO hoy_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","आग यहोशू अदा दिशी आ लॉकुर से वादा माळसुसदुन, अदिक शकेम दा आंदुर साटी विधी अदिक नियम ठहरूदुन. ");
INSERT INTO hoy_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","ईद सप्पा वृतांत यहोशू परमेश्वर उन व्यवस्था अन किताब दा लिख्स बुट्टुन; अदिक ऊंद धोळ्द कल्ल नीवळुसकु अल ऊंद बांज मार्र इन हाती नीदरूसदुन, जो यहोवा अन पवित्र जागा दा ईरोद. ");
INSERT INTO hoy_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","आग यहोशू सप्पा लॉकुर से अंदुन, “केळी, ईद कल्ल नाम लॉकुर्द गवाह ईत्तीत, यतिकी यास वचन यहोवा नाम से अंदान अवरी ईद केळ्याद; इदुरसाटी ईद नीम्द गवाह ईत्तीत, हिंग आग बाळुल कि नीव तान परमेश्वर से मुकुरूसीर.” ");
INSERT INTO hoy_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","आग यहोशू लॉकुर तान तान खुद इन भाग मा होगोर साटी सार माळदुन. ");
INSERT INTO hoy_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","ई मातगोळ बाद्दा यहोवा अन दास, नून उन पार यहोशू, ऊंद सौ हत्त वर्ष इनव आगकु सोतोदुन. ");
INSERT INTO hoy_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","अदिक आऊक तिन्मत्सेरह दा, जो एप्रैम इन पहाळी द्याश दा गास हेसुर इन पहाळी इन उत्तर दा आद, अदुर अच भाग दा मुण्ण कोटकु आत. ");
INSERT INTO hoy_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","अदिक यहोशू उन जीवन तीम, अदिक जो बाट्ट लॉकुर यहोशू उन सायोर बाद्दा जीत्ता ईत्तुर अदिक जानसोर कि यहोवा इस्त्राएल इन लॉकुर साटी ह्यांग ह्यांग क्याल्सा माळीदुर, आंदुर भी जीवन तीम इस्त्राएली यहोवा अन अच स्यावा माळतेला ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","बाक यूसुफ उन येलुगोळ यवरी इस्त्राएलीगोळ मिस्त्र टु तंदीदुर आंदुर शकेम इन जागा अन साटी आ भाग दा नळ्सकु आत, यदरी याकूब शेकेम इन आप्प हमोर उन पारगोळ से ऊंद सौ बेळ्ली इन सिक्‍कागोळ देल कोंडीदुन; इदुरसाटी आव यूसुफ उन सन्तान इन खुद इन जागा आगेत. ");
INSERT INTO hoy_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","अदिक हारून उन पार एलीआजर भी सोतोदुन; अदिक आऊक एप्रैम इन पहाळी द्याश इन गिबा नगर दा मुण्‍ण कोटकु आत, जो आऊन पार पीनहास उक कोटकु आगीत.");
INSERT INTO hoy_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","क्षयर्ष हेसुर इन राजा अन दिनगोळ दा ई मातगोळ आदव: ईव आवा क्षयर्ष हुन, जो ऊंद सौ सत्ताईस राज्यगोळ मा, मतलब भारत टु हुळकु कूश द्याश ताका राज माळोन. ");
INSERT INTO hoy_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","अवा दिनगोळ दा याग क्षयर्ष राजा तान आ राजगद्दी मा विराजमान ईरोन जो शूशन गढ़ हेसुर इन राजधानी दा ईरोद. ");
INSERT INTO hoy_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","अल आव तांद शासन काल इन तिसरा वर्ष दा तान सप्पा हाकिमगोळ अदिक कर्मचारीगोळी कळु बुटुन. फारस अदिक मादै द्याश इन सेनापति अदिक राज्य-राज्य अन प्रधान अदिक हाकिम आऊन मुंद आगेदुर. ");
INSERT INTO hoy_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","आव आंदरी हापाळ दिन मतलब ऊंद सौ अस्सी दिन ताका तान राजकीय वैभव इन धन अदिक तान महानता अन अनमोल चीजगोळी तोर्सतेला ईत्‍तुन. ");
INSERT INTO hoy_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","ई दिनगोळ बित्सदुर मा राजा सप्पा स्याणेर धोड्डेर लॉकुरी जो शूशन गढ़ हेसुर इन राजधानी दा जमा आगीदुर, राजभवन इन बगीचा अन आंगुळ दा येळ दिन ताका ऊमली कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","अलेव पळदागोळ बिळेव अदिक निळा रंग इन सूत इनव ईरव, अदिक सन अदिक जांभळा रंग इन जाळीगोळ देल बेळ्ली अन छल्लागोळ दा, संगमरमर इन खम्भागोळ देल हतकु ईरव; अदिक अलेव चौकीगोळ व्हान्ना बेळ्ली नव ईरव; क्याचांद अदिक बिळेव, पिवळा अदिक करेव संगमरमर इनव बन्सदव फर्श मा हतकु ईरव. ");
INSERT INTO hoy_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","आ भोज दा राजा अन्द योग्य अंगुर इन रास्सा अलग अलग रूप इन व्हान्ना अन्द पात्रगोळ दा हाक्कु राजा अन्द उदारता देल हापाळ सा कुळ्सकु आगोद. ");
INSERT INTO hoy_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","कुडोद रा नियम इन अनुसार आगतोगोद, यारीकारा मजबुर माळकु ईला कुळ्स तोगोर; यतिकी राजा तान भवन इन सप्पा भण्डारीगोळी आग्या कोटीदुन, कि जो पावना ह्यांग चाहास्यान आऊन सांगुळ हांगा बरताव माळेतीर. ");
INSERT INTO hoy_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","रानी वशती भी राजा क्षयर्ष इन भवन दा आर्तेरी भोजन कोट्टुर. ");
INSERT INTO hoy_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","सातवा दिशी, याग राजा अन मन अंगुर इन रास्सा दा मग्न ईरोद, आग आव महूमान, बिजता, हर्बोना, बिगता, अबगता, जेतेर अदिक कर्कस हेसुर इनोर येळ किन्नरगोळ जो क्षयर्ष राजा अन साटी स्यावा टहल माळतोगोर, आग्या कोट्टुन, ");
INSERT INTO hoy_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","कि रानी वशती अक राजमुकुट धारण माळ्द राजा अन मुंद तरी; यदुर देल कि द्याश द्याश इन लॉकुर मा अदिक हाकिमगोळ मा आकिन सुंदरता प्रगट आगेगुल; यतिकी आक नोळदुर दा सुंदर ईरोर. ");
INSERT INTO hoy_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","किन्नरगोळ द्वारा राजा अन ई आग्या ताकोमकु रानी वशती बरोर से इनकार माळदुर. इदुर मा राजा हापाळ सिट्टी बंदुन. ");
INSERT INTO hoy_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","आग राजा समय समय इन भेद जानसावाळेर पंडितगोळ से केळदुन, राजा रा नीति अदिक न्याय इन सप्पा ग्यानिगोळ से हिंगा माळतोगोन. ");
INSERT INTO hoy_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","आऊन हात्‍ती कर्शना, शेतार, अदमाता, तर्शीश, मेरेस, मर्सना अदिक ममूकान हेसुर इनोर फारस अदिक मादै द्याश इनोर येळ प्रधान ईरोर, जो राजा अन दर्शन माळतोगोर, अदिक राज्य दा मुख्य मुख्य पदगोळ मा नियुक्त माळकु आगीदुर. ");
INSERT INTO hoy_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","राजा केळदुन, “रानी वशती राजा क्षयर्ष उन, किन्नरगोळ द्वारा कोळ्द आग्या अन्द उल्लंघन माळदुर, रा नीति अन अनुसार आकिन सांगुळ येन माळ पायजे.” ");
INSERT INTO hoy_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","आग ममूकान राजा अदिक हाकिमगोळ उपस्थिती दा उत्तर कोट्टुन, “रानी वशती जो अनुचित क्याल्सा माळ्यार, अद सिर्फ राजा देल अच ईला लेकीन आक सप्पा हाकिमगोळ देल अदिक आ सप्पा द्याशगोळ लॉकुर से भी जो राजा क्षयर्ष उन सप्पा राज्यगोळ दा ईरतार. ");
INSERT INTO hoy_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","यतिकी रानी इन ई क्याल्सा अन चर्चा सप्पा आर्तेर दा आदीत अदिक याग ईद अंदकु आदीत, ‘राजा क्षयर्ष रानी वशती अक तान मुंद तरोद आग्या कोटीदुन लेकीन आक बंदिदील,’ आग आंदुर भी तान तान गांडुरी तुच्छ समस्यार. ");
INSERT INTO hoy_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","ईंद इन दिशी फारसी अदिक मादी हाकिमगोळ आर्तेर यार रानी अन ई मात केळ्यार, आंदुर भी राजा अन सप्पा हाकिमगोळ से हिंगा अनली कुरतार; ई प्रकार हापाळ अच घृणा अदिक सिट्ट पैदा आदीत. ");
INSERT INTO hoy_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","अगर राजा मंजुर ईतीदाद, रा ईद आग्या तेगुल, अदिक फारसी अदिक मादीगोळ कानून दा भी लिख्सकु आगुल, यदुर देल यागलु बदलुस बाळुल, कि रानी वशती राजा क्षयर्ष उन मुंद बाक यागलु बरबाळुल, अदिक राजा पटरानी अन पद यातोदारा दुसरा अक कोट्ट बुळुल जो आकिन से वळ्लेर ईरूल. ");
INSERT INTO hoy_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","याग राजा अन ई आग्या आऊन सप्पा राज्यगोळ दा केळ्सकु आदीत, आग सप्पा हिंग्सुर तान तान गांड उन, चाहे आव धोड्डेव ईरूल या स्याणेव, आदर सम्मान माळतेला ईत्‍तार.” ");
INSERT INTO hoy_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","ईद मात राजा अदिक हाकिमगोळी पसंद बत्‍त अदिक राजा ममूकान उन सलाह मान्स कोंडुन अदिक तान राज्य दा, ");
INSERT INTO hoy_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","मतलब हापाळ सा राज्य अन अक्षरगोळ दा अदिक हापाळ सा जाती अन भाषा दा चिट्टीगोळी कळुदुन, कि सप्पा गंळ्सुर तान तान मान्या अधिकार नळसुल, अदिक तान जात इन भाषा माताळुल. ");
INSERT INTO hoy_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","ई मातगोळ बाद्दा याग राजा क्षयर्ष उन सिट्ट ठण्डा बिदोत, आग आव रानी वशती अन, अदिक जो क्याल्सा आक माळीदुर, अदिक जो आकिन बारा दा आग्या होटीत अदुर भी याद माळदुन. ");
INSERT INTO hoy_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","आग राजा अन सेवक जो आऊन खास ईरोर, अनली कुरतुर, “राजा अन साटी सुंदर अदिक हारोदोर कुवारा पोरगोळी ढुंढ्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","अदिक राजा तान राज्य अन सप्पा राज्यगोळ दा लॉकुरी इदुरसाटी निवळुसुल कि आंदुर सप्पा सुंदर हारोदोर कुवारा पोरगोळी शूशन गढ़ इन रनवास दा जमा माळुल अदिक आर्तेर प्रबंधक हेगे अक कोळुल जो राजा नव खास किन्नर सिपाही ईरोन; अदिक सिनगार इन वस्तुगोळी आंदरी कोटकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","आग आंदुर दा टु जो कुवारा पोरगोळ राजा अन नजर दा वळ्लेर ठहरूस्यार, आक रानी वशती अन जागा मा रानी माळकु आगुल.” ईद मात राजा अक पसंद बत्त अदिक आव हांगा माळदुन. ");
INSERT INTO hoy_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","शूशन गढ़ दा मोर्दकै हेसुर इनव ऊंद यहूदी ईरतोगोन, जो कीश हेसुर इनव ऊंद बिन्यामीनी नव पळनातु, शिमी अन नातु, अदिक याईर उन पार ईरोन. ");
INSERT INTO hoy_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","आव आ बंदीगोळ सांगुळ यरूशलेम टु बँधुआई दा होगीदुन, यारी बेबीलोन इन राजा नबूकदनेस्सर, यहूदा अन राजा यकोन्याह सांगुळ बंदी माळकु वोतीदुन. ");
INSERT INTO hoy_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","आव हदस्सा हेसुर इन तान काका अन आकतींग इक, जो एस्तेर भी कहलुस तोगोर, पालन पोसन माळीदुन; यतिकी आकिन मोय आप्प यारू ईला ईरोर, अदिक आ पोर सुंदर अदिक रूपवती ईरोर, अदिक याग आकिन मोय आप्पुर सोतोदुर, आग मोर्दकै आकी तान पोर इन घाई पाल्सदुन. ");
INSERT INTO hoy_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","याग राजा अन आग्या अदिक नियम केळ्सकु आदव, अदिक हापाळ सा आर्तेर, शूशन गढ़ दा हेगे अन अधिकार दा जमा माळकु आदुर, आग एस्तेर भी राजभवन दा आर्तेर प्रबंधक हेगे अन अधिकार दा कोटकु आदुर. ");
INSERT INTO hoy_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","आक पोर आऊन नजर दा वळ्लेर हतदुर; अदिक आव आकिन से खुश आदुन, आग आव बिना समय माळ्द आकी राजभवन दा टु सिनगार इन वस्तुगोळ, अदिक आकिन भोजन, अदिक आकिन साटी निवळुसदोर येळ सहेलीगोळी भी कोट्टुन, अदिक आकी अदिक आकिन सहेलीगोळी रनवास दा सब से वळ्लीद जागा कोट्टुन. ");
INSERT INTO hoy_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","एस्तेर ना तान जात हेळीदुर, ना तान कुल, यतिकी मोर्दकै आकी आग्या कोटीदुन कि आऊक हेळबाळेत. ");
INSERT INTO hoy_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","मोर्दकै रोज रनवास इन आंगुळ इन मुंद टेटाळोन ताकी जान्सुल कि एस्तेर ह्यांग आर अदिक आकिन सांगुळ येन आगतोगोद? ");
INSERT INTO hoy_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","याग ऊंद ऊंद पोर इन पारी बत्त, कि आंदुर क्षयर्ष राजा मुंद होगुल, अदिक ईद आ समय आत याग आकिन सांगुळ आर्तेर साटी ठहरूस्द नियम इन अनुसार बारा तिंगुळ ताका व्यवहार माळकु आगीत; मतलब आंदुर सिनगार माळव दिन ई रिती देल बित्सदव, कि आर तिंगुळ ताका गन्धरस इन याण्‍णा हचकु आगोद, अदिक आर तिंगुळ ताका सुगन्धद्रव, अदिक आर्तेर्द सिनगार माळोद दुसरा सामान हचकु आगोद ");
INSERT INTO hoy_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","ई प्रकार देल आ पोर याग राजा अन हाती होगोर, याग जो येनारा आक चाहासोर कि रनवास टु राजभवन दा वोतकु आगुल, अद आकी कोटकु आगोद. ");
INSERT INTO hoy_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","द्यावगा अक रा आक होगतोगोर अदिक व्हातर्या अक आव वापस बंदकु रनवास उन दुसरा मान्ना दा होगकु रखैलगोळ्द प्रबंधक राजा अन्द किन्नर सिपाही शाशगज उन अधिकार दा आगतोगोर, अदिक राजा अन्द हात्ती बाक ईला होगतोगोर. अगर राजा आकिन से खुश आगतोगोन, आग आकिन हेसुर ताकोमकु कारूकु आगोद. ");
INSERT INTO hoy_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","याग मोर्दकै अन्द काका अबीहैल उन पोर एस्तेर, यारी मोर्दकै पोर मान्सकु ईटीदुन, आकिन पारी बत्त कि राजा अन हात्ती होगुल, आग जो येनारा आर्तेर्द प्रबंधक राजा अन्द किन्नर सिपाही हेगे आऊन साटी ठहरूसीदुन, अदुर से येक्‍कुल आक मात्त येनु बेळीदील. यास मुंदुर एस्तेर उक नोळदुर, आंदुर सप्पा मुंदुर आकिन से खुश आदुर. ");
INSERT INTO hoy_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","आग एस्तेर राजभवन दा राजा क्षयर्ष उन हात्ती आऊन राज्य इन सातवा वर्ष इन तेबेत हेसुर इन हतवा तिंगुळ दा पोहचुस्कु आदुर. ");
INSERT INTO hoy_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","राजा एस्तेर उक अदिक सप्पा आर्तेर से येक्‍कुल प्यार माळदुन, अदिक अन्य सप्पा कुवारा पोरगोळ से येक्‍कुल आकिन अनुग्रह अदिक कृपा अन्द नजर आकी मा आत, ई कारण आव आकिन ताल्ला मा राजमुकुट ईटदुन अदिक आक इक वशती इन जागा मा रानी माळदुन. ");
INSERT INTO hoy_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","आग राजा तान सप्पा हाकिमगोळ अदिक क्याल्सा माळावाळेर इक ऊंद धोळ भोज कोट्टुन, अदिक अदरी एस्तेर इन भोज अंदुन; अदिक प्रान्तगोळ इक छुट्टी दिलुसदुन, अदिक तान उदारता अन्द योग्य ईनाम भी वाट्सदुन. ");
INSERT INTO hoy_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","याग कुवारा पोरगोळ दुसरा घन जमा माळकु आदुर, आग मोर्दकै राजभवन इन फाटक दा कुर्तकु ईरोन. ");
INSERT INTO hoy_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","एस्तेर तान जाति अदिक कुल इन पता कोटीदील, यतिकी मोर्दकै आक इक हिंग अच आग्या कोटीदुन कि हेळबाळुल; अदिक एस्तेर मोर्दकै अन्द मात हिंग मानसोर जसा कि आऊन अल तान पालन पोषण इन समय मानसोर. ");
INSERT INTO hoy_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","अवा दिनगोळ दा याग मोर्दकै राजा अन्द राजभवन इन फाटक दा कुरतोगोन, आग राजा अन किन्नरगोळ जो द्वारपाल भी ईरोर, आंदुर दा टु बिगताना अदिक तेरेश हेसुर इन येढ्ढ मुंदुर राजा क्षयर्ष राजा से नाराज आगकु आऊक कोन्नोद योजना माळदुर. ");
INSERT INTO hoy_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","ईद मात मोर्दकै अक मालुम आत, अदिक आव एस्तेर रानी इक ईद मात हेळदुन, अदिक एस्तेर मोर्दकै अन्द हेसुर ताकोमकु राजा अक सावधान माळदुर. ");
INSERT INTO hoy_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","आग जाँच पळताल आगदुर मा ईद मात खरा होळ्त अदिक आंदुर येढ्ढु मुंदुर मार्र मा लटकुसकु फासी हचदुर, अदिक ईद वृत्तान्त राजा अन्द मुंद इतिहास इन किताब दा लिख्सकु आग्याद. ");
INSERT INTO hoy_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","ई मातगोळ्द बाद्दा राजा क्षयर्ष अगागी वंश इनव हम्मदाता अन्द पार हामान उक म्याकळोद पद कोट्टुन, अदिक आऊक महत्व कोटकु आऊन साटी आऊन संगी हाकिमगोळ्द सिंहासनगोळ से ऊँचा सिंहासन ठहरूसदुन. ");
INSERT INTO hoy_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","राजा अन्द क्याल्सा जो राजभवन इन फाटक दा ईरतोगोर, आंदुर हामान इन मुंद बांगकु प्रणाम माळतोगोर यतिकी राजा आऊन बारा दा हिंग अच आग्या कोटीदुन; लेकीन मोर्दकै ईला झुकसोन अदिक न आऊक प्रणाम माळोन. ");
INSERT INTO hoy_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","आग राजा अन्द क्याल्सा माळावाळेर जो राजभवन इन फाटक दा ईरतोगोर, आंदुर मोर्दकै से केळदुर, “नी राजा अन्द आग्या अन्द येती उल्लंघन माळत्या?” ");
INSERT INTO hoy_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","याग आंदुर आऊन से हर रोज हिंग अच माळतेला ईत्तुर, अदिक आव आंदुर्द ऊंद भी केळीदील, आग आंदुर ईद नोळोद इच्छा देल कि मोर्दकै अन्द ईद मात नळदीत का ईला, हामान उक हेळ बुट्टुन; आव आंदरी हेळ बुट्टीदुन कि ना यहूदी हुईन. ");
INSERT INTO hoy_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","याग हामान नोळदुन कि मोर्दकै झुकसालुन, अदिक नान इक प्रणाम माळालुन, आग हामान हापाळ अच सिट्टी बंदुन. ");
INSERT INTO hoy_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","आव केवल मोर्दकै मा कय नेगोद तान मर्यादा से कम जान्सदुन. यतिकी आंदुर हामान उक ईद हेळ बुट्टुर कि मोर्दकै या जाती इन हुन, इदुरसाटी हामान क्षयर्ष इन साम्राज्य दा ईरावाळेर पुरा यहूदीगोळ इक भी मोर्दकै अन्द जाती जानस्कु, नष्ट माळोद योजना माळदुन. ");
INSERT INTO hoy_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","राजा क्षयर्ष उन हन्नेळवा वर्ष इन नीसान हेसुर इन पयला तिंगुळ दा, हामान अदार हेसुर इन हन्नेळवा तिंगुळ ताका अन्द ऊंद ऊंद दिन अदिक ऊंद ऊंद तिंगुळ इन साटी “पूर” मतलब चिट्टी तान मुंद हाक्सुसदुन. ");
INSERT INTO hoy_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","आग हामान राजा क्षयर्ष से अंदुन, “नीन राज्य अन्द सप्पा प्रान्तगोळ दा ईरावाळेर द्याश द्याश इन लॉकुर्द न्याड्या तितर-बितर अदिक सटुस्कु ऊंद जाति आद, अदुर्द नियमगोळ से अलग आव; अदिक आंदुर राजा अन्द कानून मा नळालुर, इदुरसाटी आंदरी ईरगोळोद राजा अक लाभदायक ईला ईरोद. ");
INSERT INTO hoy_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","अगर राजा अक स्वीकार ईरूल रा आंदरी नष्ट माळोद आग्या लिख्‍सकु आगुल, अदिक ना राजा अन्द भण्डारीगोळ्द कय दा राजभण्डार दा पहुचुसोर साटी, हत्त हजार बेळ्ली नव सिक्का कोळाईन.” ");
INSERT INTO hoy_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","आग राजा तान ऊँगरा तान कय टु ईळुकु, अगागी हम्मदाता अन्द पार हामान उक, जो यहूदीगोळ्द दुश्मन ईरोन कोट्ट बुट्टुन; ");
INSERT INTO hoy_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","अदिक राजा हामान से अंदुन, “अद बेळ्ली नीन इक कोटकु आत, अदिक आ लॉकुर भी, ताकी नी आंदुर से ह्यांग नी चाहासत्या हांगा व्यवहार माळ.” ");
INSERT INTO hoy_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","हिंग अदा पयला तिंगुळ इन तेरहवा दिन इक राजा अन्द लेखक कारूकु आदुर, अदिक हामान उन आग्या अन्द अनुसार राजा अन्द सप्पा अधिपतिगोळ, अदिक सप्पा प्रान्तगोळ्द प्रधानगोळ, अदिक द्याश द्याश इन लॉकुर्द हाकिमगोळ साटी चिट्टीगोळ, ऊंद ऊंद प्रान्त इन अक्षरगोळ दा, अदिक ऊंद ऊंद द्याश इन लॉकुर्द भाषा दा राजा क्षयर्ष इन हेसुर देल लिख्‍सकु आत; अदिक अऊर दा राजा अन्द ऊँगरा इन छाप हचकु आत. ");
INSERT INTO hoy_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","राज्य इन सप्पा प्रान्तगोळ दा ई आशय इन चिट्टीगोळ हरकारगोळ्द द्वारा कळुकु आत कि ऊंद अच दिन दा, मतलब अदार हेसुर इन हन्नेळवा तिंगुळ इन तेरवा दिन इक, येन हारोदव, येन हाळाबाट्ट, येन आर्त, येन चिकोर, सप्पा यहूदी कोंदकु आगुल, नष्ट माळकु आगुल अदिक आंदुर्द सत्यानाश माळकु आगुल; अदिक आंदुर्द धन सम्पत्ती लुट्सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","आ आग्या अन्द लेख इन नकल सप्पा प्रान्तगोळ दा खोल्सकु कळुकु आत कि सप्पा द्याश इन लॉकुर आ दिन इन साटी तयार आगेगुल. ");
INSERT INTO hoy_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","ईद आग्या शूशन गढ़ दा कोटकु आत, अदिक हरकारे राजा अन्द आग्या देल तुरन्त होट्ट बुट्टुर. राजा अदिक हामान रा अंगुर इन रास्सा कुडुली कुरतोदुर, लेकीन शूशन नगर दा घबराहट फैलुसेत. ");
INSERT INTO hoy_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","याग मोर्दकै जान्स कोंडुन कि येन येन माळकु आग्याद आग मोर्दकै कपळा हरदुन, टाट हाक्कु, राख हाक्कु, नगर इन न्याड्या होगकु ऊँचा अदिक दुख भरा शब्द देल चिल्‍ळासली कुरतुन; ");
INSERT INTO hoy_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","अदिक आव राजभवन इन फाटक इन मुंद पोहचुस्दुन, लेकीन टाट हाक्कु राजभवन इन फाटक इन बुळ्क रा यारीकु होगोद आग्या ईला ईरोद. ");
INSERT INTO hoy_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","ऊंद ऊंद प्रान्त दा, येल येल राजा अन्द आग्या अदिक नियम पहुचुस्त, अल अल यहूदी बळा विलाप माळली अदिक उपवास माळली अदिक वर्ली पिट्सली कुरतुर; हापाळ सा मुंदुर टाट हाक्कु अदिक राख हाक्कु बिदकु ईत्तुर. ");
INSERT INTO hoy_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","एस्तेर रानी इन दासीगीतेर अदिक किन्नरगोळ होगकु आकिक हेळ बुट्टुर, आग रानी हापाळ दुखी आगेदुर; अदिक मोर्दकै अन्द हात्ती कपळा कळुकु ईद बुलावा कळुदुर कि टाट ईळुकु इवरी हाक्क कोमुल, लेकीन आव अव कपळा हुळदीदिल. ");
INSERT INTO hoy_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","आग एस्तेर राजा अन्द किन्नरगोळ दा टु हताक उक यारी राजा आऊन हात्ती ईरली हठरूसीदुन, कारूकु आग्या कोट्टुन कि मोर्दकै अन्द हात्ती होगकु मालूम माळ कोमुल कि येन मात आद, अदिक इदुर्द येन कारण आद. ");
INSERT INTO hoy_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","आग हताक नगर इन आ चौराह दा, जो राजभवन इन फाटक इन मुंद ईरोद, मोर्दकै अन्द हात्ती होदुन. ");
INSERT INTO hoy_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","मोर्दकै आऊक सप्पा येनारा हेळ बुट्टुन कि नान म्याकुच येन बितुस्याद, अदिक हामान यहूदीगोळ्द नाश माळोद अनुमति सिक्कोर साटी राजभण्डार दा यास बेळ्ली तुम्मोद वचन कोटीदुन, ईद भी ठीक ठीक हेळ बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","बाक यहूदीगोळ्द विनाश माळोद जो आग्या शूशन दा कोटकु आगीत, अदुर्द ऊंद नकल भी आव हताक उन कय दा, एस्तेर उक तोरसोर साटी कोट्टुन, अदिक आऊक सप्पा हाल हेळोर, अदिक ईद आग्या कोळली अंदुन, कि बुळ्क राजा अन्द हात्ती होगकु तान लॉकुर्द साटी गिळगिळास्कु विनती माळुल. ");
INSERT INTO hoy_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","आग हताक एस्तेर उन हात्ती होगकु मोर्दकै अन्द मातगोळ अनकु केळ्सदुन. ");
INSERT INTO hoy_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","आग एस्तेर हताक उक मोर्दकै से ईद अनोद आग्या कोट्टुन, ");
INSERT INTO hoy_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“राजा अन्द सप्पा क्याल्सा माळावाळेर, उल्टा राजा अन्द प्रान्त ईनोर सप्पा लॉकुर इक भी मालूम आद, कि येन गंळ्स येन आर्त, यावारा येन ईर बाळुल, जो बिना आग्या सिक्त बुळ्क आंगुळ दा राजा अन्द हात्ती होदान आऊक कोन्नोद आग्या अच आद; केवल यार दी राजा व्हान्ना अन्द राजदण्ड वाळुस्यान आवा ऊळुतान. लेकीन ना ईग तीस दिन से राजा अन्द हात्ती कारूकु आगीदील.” ");
INSERT INTO hoy_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","एस्तेर इन ईव मातगोळ मोर्दकै अक केळ होत. ");
INSERT INTO hoy_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","आग मोर्दकै एस्तेर उन हात्ती ईद बुलावा कळुदुन, “नी मन इन मन दा ईद विचार माळबाळ कि ना अच राजभवन दा ईरोद कारण अदिक सप्पा यहूदीगोळ दा ऊळुकु ईराईन. ");
INSERT INTO hoy_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","यतिकी जो नी ई समय सुंगामुंगा ईत्या, रा अदिक यातोदारा न यातोदारा उपाय देल यहूदीगोळ्द छुटकारा अदिक सहायता सिक्केदीत, लेकीन नी तान आप्प उन घराना अन्द सांगुळ नष्ट आद्या. येन मालूम नीन इक हिंग अच मुश्किल समय इन साटी राजपद सिक्याद?” ");
INSERT INTO hoy_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","आग एस्तेर मोर्दकै अन्द हात्ती ईद बुलावा कळुदुन, ");
INSERT INTO hoy_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“नी होगकु शूशन उन सप्पा यहूदीगोळ इक जमा माळ, अदिक नीव सप्पा मुंदुर मिलुस्कु नान निमित्त उपवास माळी, मुर दिन ईळ्लक येनु तिनबाळी, अदिक येनु कुडुबाळी. ना भी तान दासीगीतेर सांगुळ अदा रीती देल उपवास माळाईन; अदिक हिंग अच दशा दा ना नियम इन विरूद्ध राजा अन्द हात्ती बुळ्क होगाईन; अदिक अगर नष्ट आगाईन रा आगाईन.” ");
INSERT INTO hoy_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","आग मोर्दकै होटोदुन अदिक एस्तेर उन आग्या अन्द अनुसार अच आव माळदुन. ");
INSERT INTO hoy_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","तीसरा दिशी एस्तेर तान राजकीय कपळा हाक्कु राजभवन इन बुळ्क इन आंगुळ दा होगकु, राजभवन इन मुंद नीदरेदुर. राजा राजभवन दा राजगद्दी मा भवन इन द्वार इन मुंद विराजमान ईरोन; ");
INSERT INTO hoy_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","अदिक याग राजा एस्तेर रानी अक आंगुळ दा नीदुरकु नोळदुन, आग आव प्रसन्न आगकु व्हान्ना अन्द राजदण्ड जो आऊन कय दा ईरोद आकिन दी वाळुसदुन. आग एस्तेर हात्ती होगकु राजदण्ड इन नोक मुटदुर. ");
INSERT INTO hoy_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","आग राजा आकिन से केळदुन, “हे एस्तेर रानी, नीन इक येन पायजे? नी येन बेळत्या? बेळ अदिक नीन इक आरधा राज्य ताका कोटकु आदीत.” ");
INSERT INTO hoy_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","एस्तेर अंदुर, “अगर राजा अक स्वीकार ईरूल, रा ईंद हामान उक हुळकु आ भोज दा बरूल, जो ना राजा अन्द साटी तयार माळदीन.” ");
INSERT INTO hoy_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","आग राजा आग्या कोट्टुन, “हामान उन तुरंत तरी, कि एस्तेर इन निमंत्रण स्वीकार माळकु आगुल.” अत: राजा अदिक हामान एस्तेर इन तयार माळ्द भोज दा बंदुर. ");
INSERT INTO hoy_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","भोज इन समय याग आळी दाकळोद शयद कुडोर, आग राजा एस्तेर से अंदुन, “नीन येन निवेदन आद? अद पुरा माळकु आदीत. नी येन बेळत्या? बेळ, अदिक आरधा राज्य ताका नीन इक कोटकु आदीत.” ");
INSERT INTO hoy_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","एस्तेर उत्तर कोट्टुर, “नान निवेदन अदिक जो ना बेळतीन अद ईद हुन, ");
INSERT INTO hoy_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","कि अगर राजा नान मा प्रसन्न आन अदिक नान निवेदन केळोद अदिक वरदान ना बेळाईन अदा कोळोद राजा अक स्वीकार आद, रा राजा अदिक हामान नाळ आ भोज दा बरूल अदरी ना आंदुर साटी माळाईन, अदिक नाळ ना राजा अन्द ई वचन इन अनुसार माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","आ दिशी हामान खुश अदिक मन दा प्रसन्न आगकु व्हार्या होदुन. लेकीन याग आव मोर्दकै अक राजभवन इन फाटक दा नोळदुन, कि आव आऊन मुंद नीदरीदील, अदिक हटसीदील, आग आव मोर्दकै अन्द विरूद्ध गुस्सा देल तुमेदुन. ");
INSERT INTO hoy_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","तौभी हामान तान तान इक रोक्‍सकु तान मान्नी होदुन; अदिक तान संगीगोळ अदिक तान हिंग्स जेरेश उक बुलावा कळुदुन. ");
INSERT INTO hoy_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","आग हामान आंदुर से तान धन इन वैभव, अदिक तान बाल-बच्यागोळ्द वाळुस्त अदिक राजा आऊक ह्यांग ह्यांग वाळुसदुन, अदिक अन्य सप्पा हाकिमगोळ अदिक तान अदिक सप्पा क्याल्सा माळावाळेर से ऊँचा पद कोटीदुन, ई सप्पा अन्द वर्णन माळदुन. ");
INSERT INTO hoy_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","हामान ईद भी अंदुन, “एस्तेर रानी भी नान इक बिटकु अदिक यारीकारा राजा अन्द सांगुळ तान माळ्द भोज दा बर गोटीदील; अदिक नाळ इन साटी भी राजा अन्द सांगुळ आक नान इक नेवता कोट्टुर. ");
INSERT INTO hoy_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","तौभी याग याग नान इक आ यहूदी मोर्दकै राजभवन इन फाटक दा कुर्तकु कांळ्सतान, आग आग ईद सप्पा नान नजर दा बेकार हतोद.” ");
INSERT INTO hoy_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","आऊन हिंग्स जेरेश अदिक आऊन सप्पा संगीगोळ आऊन से अंदुर, “पचास कय ऊँचा फाँसी इन ऊंद खम्भा माळकु आगुल, अदिक व्हातर्या राजा से अनेतीर कि आऊन मा मोर्दकै लटकुसकु आगुल; आग राजा अन्द सांगुळ खुशी देल भोज दा होगेतीर.” ई मात देल प्रसन्न आगकु हामान हांग अच फाँसी इन ऊंद खम्भा माळसुसदुन. ");
INSERT INTO hoy_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","आ ईळ्लक राजा अक जप बंदीदिल, इदुरसाटी आऊन आग्या देल इतिहास इन किताब तनकु आत, अदिक वाचुसकु राजा अक केळ्‍सकु आत. ");
INSERT INTO hoy_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","अदुर्दा ईद लिख्‍सकु सिक्त, कि याग राजा क्षयर्ष उन हाकिम जो द्वारपाल भी ईरोर, आंदुर दा टु बिगताना अदिक तेरेश हेसुर इन येढ्ढ मुंदुर आऊक कोन्नोद योजना माळीदुर अदरी मोर्दकै प्रगट माळीदुन. ");
INSERT INTO hoy_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","आग राजा केळदुन, “इदुर बदला मोर्दकै अन्द येन प्रतिष्ठा अदिक बड़ाई माळकु आगीत?” राजा अन्द जो सेवक आऊन स्यावा टहल माळतोगोर, आंदुर आऊक उत्तर कोट्टुर, “अदुर साटी येनु माळकु आगीदील.” ");
INSERT INTO hoy_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","राजा केळदुन, “आंगुळ दा याव आन?” अदा समय हामान राजा अन्द भवन टु व्हार्यागोळ्द आंगुळ दा ई मनसा देल बंदीदुन कि जो खम्भा आव मोर्दकै अन साटी तयार माळसुसीदुन, अदुर मा आऊक लटकुसोद मातचीत राजा से माळुल. ");
INSERT INTO hoy_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","आग राजा अन्द सेवकगोळ आऊन से अंदुर, “आंगुळ दा रा हामान नीदुरकु आन.” राजा अंदुन, “आऊक बुळ्क कारूकु तरी.” ");
INSERT INTO hoy_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","याग हामान बुळ्क बंदुन, आग राजा आऊन से केळदुन, “या मंळसा अन्द प्रतिष्ठा राजा माळोद चाहासतान रा आऊन साटी येन माळोद उचित आदीत?” हामान ईद सोचकु, कि नान से येक्‍कुल राजा यार्द प्रतिष्ठा माळोद चाहासतीदान, ");
INSERT INTO hoy_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","राजा अक उत्तर कोट्टुन, “या मंळसा अन्द प्रतिष्ठा राजा माळोद चाहस्यान, ");
INSERT INTO hoy_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","आऊन साटी राजकीय कपळा तंदकु आगुल, जो राजा हाकतान, अदिक ऊंद घ्वाळा भी, यदुर मा राजा सवार आगतान, अदिक आऊन ताल्ला मा जो राजकीय मुकुट हाक्कु ईरतद अद भी तंदकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","बाक अव कपळा, अदिक अद घ्वाळा राजा अन्द यातोवारा धोळ हाकिम उक सौप्सकु आगुल, अदिक यार प्रतिष्ठा राजा माळोद चाहासतान, आऊक अव कपळा हाकसुसकु आगुल, अदिक आ घ्वाळा मा सवार माळकु नगर इन चौराह दा आऊक तिर्गुसकु आगुल; अदिक आऊंद मुंद मुंद ईद प्रचार माळकु आगुल, ‘यार्द प्रतिष्ठा राजा माळोद चाहासतान, आऊन सांगुळ हिंग अच माळकु आदीत.’” ");
INSERT INTO hoy_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","राजा हामान से अंदुन, “फुर्ती माळकु तान अनोद अनुसार आ कपळा अदिक आ घ्वाळा अक हुळकु, आ यहूदी मोर्दकै से जो राजभवन इन फाटक दा कुरतोगतान, हांग अच माळ. ह्यांग नी अंद अदुर्दा येनु भी कमी आगबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","आग हामान आ कपळा, अदिक आ घ्वाळा अक हुळकु, मोर्दकै अक हाकसुसदुन, अदिक आऊक घ्वाळा मा येर्सकु, नगर इन चौराह दा ई प्रकार कारूतेला तिर्गुसदुन, “यार्द प्रतिष्ठा राजा माळोद चाहासतान आऊन सांगुळ हिंग अच माळकु आदीत.” ");
INSERT INTO hoy_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","आग मोर्दकै रा राजभवन इन फाटक दा वापस होटोदुन लेकीन हामान शोक माळतेला अदिक ताल्ला मुचकु राटनेरी तान मान्नी होदुन. ");
INSERT INTO hoy_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","हामान तान हिंग्स जेरेश अदिक तान सप्पा संगीगोळ से सप्पा येनारा जो आऊन मा बितुसीत वर्णन माळदुन. आग आऊन बुद्धिमान संगीगोळ अदिक आऊन हिंग्स जेरेश आऊन से अंदुर, “मोर्दकै यारी नी नीचा तोरसोद चाहसत्या, अगर आव यहूदीगोळ्द वंश दाकळोव आन, रा नी आऊन मा प्रबल आगतीदील आऊन से पुरा रिती देल निचा अच तोर्सकु आद्या.” ");
INSERT INTO hoy_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","आंदुर आऊन सांगुळ मात अच माळतेला ईरोर कि राजा अन्द किन्नर बंदकु हामान उक एस्तेर इन माळ्द भोज दा फुर्ती देल कारूकु ओतुर. ");
INSERT INTO hoy_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","अत: राजा अदिक हामान एस्तेर रानी इन भोज दा होट बंदुर. ");
INSERT INTO hoy_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","राजा दुसरा दिशी आळी दाकळोद शयद कुडुत कुडुत एस्तेर से मात केळदुन, “हे एस्तेर रानी! नीन येन निवेदन आद? अद पुरा माळकु आदीत. नी येन बेळत्या? बेळ, अदिक आरधा राज्य ताका नीन इक कोटकु आदीत.” ");
INSERT INTO hoy_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","एस्तेर रानी उत्तर कोट्टुर, “हे राजा! अगर नी नान मा प्रसन्न आय, अदिक राजा अक ईद स्वीकार आद, रा नान निवेदन देल नानी, अदिक नान बेळदुर देल नान लॉकुर इक प्राणदान सिकुल. ");
INSERT INTO hoy_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","यतिकी ना अदिक नान जाती इन लॉकुर मारकु आग्यार, अदिक नाव सप्पा घात अदिक नष्ट माळकु आगावाळेर आयेव. अगर नाव केवल दास-दासी आगोर साटी मारकु आदेव, रा ना सुंगा ईरायदीन; चाहे आ दशा दा आ विरोधी राजा अन्द नुकसान तुम सकालुन.” ");
INSERT INTO hoy_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","आग राजा क्षयर्ष एस्तेर रानी से केळदुन, “आव याव हुन, अदिक येल आन, जो हिंग माळोद निश्चय माळदुन?” ");
INSERT INTO hoy_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","एस्तेर उत्तर कोट्टुर, “आ विरोधी अदिक दुश्मन ईवा दुष्ट हामान हुन!” आग हामान राजा-रानी इन मुंद अंजेदुन. ");
INSERT INTO hoy_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","राजा सिट्ट देल तुमकु, आळी दाकळोद शयद कुडुतेला येदकु, राजभवन इन बगीचा दा होट्ट बुट्टुन; अदिक हामान ईद नोळकु कि राजा नान हानि ठान्स कोंडीदान, एस्तेर रानी से प्राणदान बेळ्ली नीदरेदुन. ");
INSERT INTO hoy_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","याग राजा राजभवन इन बेली टु आळी दाकळोद शयद कुडोद जागा दा वापस बंदुन आग येन नोळदुन कि हामान अदा चौकी मा यदुर मा एस्तेर कुर्तकु आर बांगेत्यान; अदिक राजा अंदुन, “येन ईद मान्ना दा अच नान मुंद अच रानी से बरबस माळोद चाहासतान?” राजा अन्द बाँय देल ईद वचन होटकु उच ईरोद, कि सेवकगोळ हामान उन बाँय झाक्स बुट्टुर. ");
INSERT INTO hoy_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","आग राजा अन्द मुंद उपस्थित ईरावाळेर किन्नरगोळ दा टु हर्बोना हेसुर इन ऊंद मंळसा राजा से अंदुन, “हामान उन अल पचास कय ऊँचा फाँसी इन ऊंद खम्भा नीदुरकु आद, जो आव मोर्दकै अन्द साटी माळसुस्यान, जो राजा अन्द हित इन मात माळीदुन.” राजा अंदुन, “आऊक अदुर्द मा लटकुस बुळी.” ");
INSERT INTO hoy_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","आग हामान अदा खम्भा मा जो आव मोर्दकै अन्द साटी तयार माळसुसीदुन, लटकुस बुट्टुर. इदुर मा राजा अन्द सिट्ट ठण्डा बिदोत. ");
INSERT INTO hoy_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","अदा दिशी राजा क्षयर्ष यहूदीगोळ्द विरोधी हामान उन मान्न मकान एस्तेर रानी इक कोट्ट बुट्टुन. मोर्दकै राजा अन्द मुंद बंदुन, यतिकी एस्तेर राजा अक हेळीदुर, कि आऊन से आकिन येन नाता ईरोद. ");
INSERT INTO hoy_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","आग राजा तान अद ऊँगरा जो आव हामान से ताकोम कोंडीदुन, ईळुकु मोर्दकै अक कोट्ट बुटुन. एस्तेर मोर्दकै अक हामान उन मान्न मकान मा अधिकारी नियुक्त माळ बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","बाक एस्तेर दुसरा गन राजा से अंदुर; अदिक आऊन काल मा बिदकु, कण्ण इन नीर वाहुस वाहुसकु आऊन से गिळगिळास्कु विनती माळदुर कि अगागी वंश इनव हामान उन बुराई अदिक यहूदीगोळ्द नुकसान इन आऊन युक्ति रद्द माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","आग राजा एस्तेर उन दी व्हान्ना अन्द राजदण्ड वाळुसदुन. ");
INSERT INTO hoy_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","आग एस्तेर येदकु राजा अन्द मुंद नीदुरदुर; अदिक अनली कुरतुर, “अगर राजा अक स्वीकार इरूल अदिक आव नान से प्रसन्न आन अदिक ईद मात आऊक वळ्लीद जानस्कु बिळतद, अदिक ना भी आऊक वळ्लीद हत्तेतीन, रा जो चिट्टीगोळ हम्मदाता अगागी इन पार हामान राजा अन्द सप्पा प्रान्तगोळ्द यहूदीगोळ इक नष्ट माळोद योजना माळकु लिखसीदुर, आ चिट्टीगोळी रद्द माळोर साटी लिख्‍सकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","यतिकी ना तान कुल इन लॉकुर मा बिळावाळा आ विपत्ती इक या रीती देल नोळ सकाईन? ना तान वार्टुर्द विनाश इक ह्यांग नोळ सकाईन?” ");
INSERT INTO hoy_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","आग राजा क्षयर्ष एस्तेर रानी से अदिक मोर्दकै यहूदी से अंदुन, “ना हामान उन मान्ना मार रा एस्तेर उक कोट्ट बुट्टीन, अदिक आव फाँसी इन खम्भा मा लटकुसकु आग्यान, इदुरसाटी कि आव यहूदीगोळी कोन्नोद कोशिश माळीदुन. ");
INSERT INTO hoy_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","अत: नीव तान समझ इन अनुसार राजा अन्द हेसुर देल यहूदीगोळ हेसुर मा लिख्सी, अदिक राजा अन्द ऊँगरा अन्द छाप भी हच्ची; यतिकी जो चिट्टी राजा अन्द हेसुर देल लिख्‍सकु आगुल, अदिक अदुर मा आऊन ऊँगरा अन्द छाप हचकु आगुल, अदरी यारू रद्द माळ सकालुर.” ");
INSERT INTO hoy_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","अदा समय मतलब सीवान हेसुर इन तिसरा तिंगुळ इन तेईसवा दिन इक राजा अन्द लेखक कारूकु आदुर, अदिक या या मात इन आग्या मोर्दकै आंदरी कोटीदुन अदरी यहूदीगोळ इक अदिक अधिपतिगोळ इक अदिक भारत टु हुळकु कूश द्याश ताका, जो ऊंद सौ सत्ताईस प्रान्त आव, आ सप्पा अन्द अधिपतिगोळ अदिक हाकिमगोळ्द ऊंद ऊंद प्रान्त इन अक्षरगोळ दा अदिक ऊंद ऊंद द्याश इन लॉकुर्द भाषा दा, अदिक यहूदीगोळ इक आंदुर्द अक्षरगोळ्द अदिक भाषा दा लिख्‍सकु आत. ");
INSERT INTO hoy_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","मोर्दकै राजा क्षयर्ष उन हेसुर देल चिट्टीगोळ लिख्सकु, अदिक अऊर मा राजा अन्द ऊँगरा अन्द छाप हचकु, तेज नळावाळेर सरकारी घ्वाळागोळ अदिक खच्चरगोळ मा सवारी माळावाळेर कय दा कळु बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","ई चिट्टीगोळ दा सप्पा नगरगोळ्द यहूदीगोळ इक राजा अन्द दी टु इजाजत कोटकु आत, कि आंदुर जमा आगुल अदिक तान तान जीव ऊळसोर साटी तयार आगकु, या जाती या प्रान्त इन लॉकुर अन्याय माळकु आंदरी या आंदुर आर्तेर अदिक बाल-बच्यागोळ इक दुख कोळोद चाहस्यान, आंदरी घात अदिक नष्ट माळुल, अदिक आंदुर धन दौलत लुट्‍स कोमुल. ");
INSERT INTO hoy_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","अदिक ईद राजा क्षयर्ष इन सप्पा प्रान्तगोळ दा ऊंद अच दिन दा माळकु आगुल, मतलब अदार हेसुर इन हन्नेळवा तिंगुळ इन तेरवा दिन इक. ");
INSERT INTO hoy_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","ई आग्या अन्द लेख इन नकलगोळ, पुरा प्रान्तगोळ दा सप्पा द्याशगोळ लॉकुर्द हात्ती तेरूकु कळुकु आत; ताकी यहूदी आ दिशी तान दुश्मनगोळ से बदला ताकोमली तयार ईरूल. ");
INSERT INTO hoy_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","अत: सवारी माळावाळेर वेग देल नळसावाळेर सरकारी घ्वाळागोळ मा सवार आगकु, राजा अन्द आग्या देल फुर्ती माळकु जल्दी होटोदुर, अदिक ईद आग्या शूशन गढ़ दा कोटकु आगीत. ");
INSERT INTO hoy_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","आग मोर्दकै निळा रंग अदिक बिळीद रंग इन राजकीय कपळा हाक्कु अदिक ताल्ला मा व्हान्ना अन्द धोळ मुकुट हुळकु, अदिक मलमल इन अदिक जांभळा रंग इन चादर होदुकु राजा अन्द मुंद टु होट्टुन, अदिक शूशन नगर इन लॉकुर आनन्द देल आऊन जयजयकार माळली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","यहूदीगोळ इक आनन्द अदिक हर्ष आत अदिक आंदुर्द धोळ प्रतिष्ठा आत. ");
INSERT INTO hoy_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","अदिक या या प्रान्त, अदिक या या नगर दा, येल्यारा राजा अन्द आग्या अदिक नियम पोहचुसदव, अल अल यहूदीगोळ इक आनन्द अदिक हर्ष आत, अदिक आंदुर भोज माळकु आ दिन इक खुशी इन दिन मान्सदुर. अदिक आ द्याश इन लॉकुर दा टु हापाळ लॉकुर यहूदी बनसेदुर, यतिकी आंदुर मन दा यहूदीगोळ्द अंज्क सम्सकु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","अदार हेसुर इन हन्नेळवा तिंगुळ इन तेरवा दिन इक, या दिशी राजा अन्द आग्या अदिक नियम पुरा आगली ईरव, अदिक यहूदीगोळ्द दुश्मन आंदुर मा प्रबल आगोद आशा ईटतोगोर, लेकीन इदुर विपरीत यहूदी तान दुश्मनगोळ मा प्रबल आदुर; ");
INSERT INTO hoy_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","आ दिशी यहूदी लॉकुर राजा क्षयर्ष इन सप्पा प्रान्तगोळ दा तान तान नगर दा जमा आदुर, कि जो आंदुर नुकसान माळोद यत्न माळुल, आंदुर मा कय नळसुल. याऊ आंदुर सामना माळ सकीदील, यतिकी आंदुर अंज्क द्याश द्याश इन सप्पा लॉकुर्द मन दा समुस्कु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","उल्टा प्रान्तगोळ सप्पा हाकिमगोळ अदिक अधिपतिगोळ अदिक प्रधानगोळ अदिक राजा अन्द क्याल्सा माळावाळेर यहूदीगोळ्द मदत माळदुर, यतिकी आंदुर मन दा मोर्दकै अन्द अंज्क समुस्कु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","मोर्दकै रा राजा अन्द अल हापाळ प्रतिष्ठित ईरोन, अदिक कीर्ति सप्पा प्रान्तगोळ दा फैलुसेत; उल्टा आ गंळ्स मोर्दकै अन्द महिमा वाळुस्तेला होटोत. ");
INSERT INTO hoy_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","अत: यहूदीगोळ तान सप्पा दुश्मनगोळ इक तलवार देल कोंदकु अदिक घात माळकु नष्ट माळ बुट्टुर, अदिक तान दुश्मनगोळ से तान इच्छा अन्द अनुसार बर्ताव माळदुर. ");
INSERT INTO hoy_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","शूशन गढ़ दा यहूदीगोळ अईद सौ मंळसागोळ इक घात माळकु नष्ट माळदुर. ");
INSERT INTO hoy_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","आंदुर पर्शन्दाता, दल्पोन, अस्पाता, ");
INSERT INTO hoy_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","पोराता, अदल्या, अरीदाता, ");
INSERT INTO hoy_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","पर्मशता, अरीसै, अरीदे अदिक वैजाता, ");
INSERT INTO hoy_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","मतलब हम्मदाता अन पार यहूदीगोळ विरोधी हामान उन हत्त पारगोळ इक भी घात माळदुर; लेकीन आंदुर धन इक लुटसीदील. ");
INSERT INTO hoy_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","अदा दिशी शूशन गढ़ दा घात माळकु आत आंदुर गिनती राजा अक केळ्सकु आत. ");
INSERT INTO hoy_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","आग राजा एस्तेर रानी से अंदुन, “यहूदीगोळ शूशन गढ़ दा अच अईद सौ मंळसागोळ अदिक हामान उन हत्त पारगोळ इक भी घात माळकु नष्ट माळदुर; बाक राज्य अन्द अन्य प्रान्तगोळ दा आंदुर येन मालुम येन येन माळीदार! ईग इदुर से येक्‍कुल नीन निवेदन येन आद? अद भी पुरा माळकु आदीत. नी येन बेळत्या? अद भी नीन इक कोटकु आदीत.” ");
INSERT INTO hoy_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","एस्तेर अंदुर, “अगर राजा अक स्वीकार ईरूल रा शूशन इन यहूदीगोळ इक ईंद इन घाई नाळ भी माळोद आग्या कोटकु आगुल, अदिक हामान उन हत्तु पारगोळ फाँसी इन खम्भागोळ मा लटकुसकु आगुल.” ");
INSERT INTO hoy_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","राजा अंदुन, “हिंग अच माळकु आगुल;” ईद आग्या शूशन दा कोटकु आत, अदिक हामान उन हत्तु पारगोळ इक लटकुसकु आत. ");
INSERT INTO hoy_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","शूशन इन यहूदीगोळ अदार तिंगुळ इन चौदहवा दिन इक भी जमा आगकु शूशन दा मुर सौ गंळ्सुर्द घात माळदुर, लेकीन घन इक लुटसीदील. ");
INSERT INTO hoy_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","राज्य इन अन्य प्रान्तगोळ यहूदी जमा आगकु तान तान जीव ऊळसोर साटी नीदुरदुर, अदिक तान दुश्मनगोळ दा टु पचहत्तर हजार मंळसागोळ इक घात माळकु तान दुश्मनगोळ से आराम सिक्त; लेकीन धन लुटसीदील. ");
INSERT INTO hoy_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","ईद क्याल्सा अदार तिंगुळ इन तेरवा दिन इक माळकु आत, अदिक चौदहवा दिन इक आंदुर आराम माळकु भोज माळदुर अदिक आनन्द इन दिन ठहरूसदुर. ");
INSERT INTO hoy_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","लेकीन शूशन नगर इन यहूदी अदार तिंगुळ इन तेरवा दिन इक, अदिक अदा तिंगुळ इक चौदहवा दिन इक जमा आदुर, अदिक अदा तिंगुळ इन पंदरावा दिशी आंदुर आराम माळकु भोज इन अदिक आनन्द इन दिन ठहरूसदुर. ");
INSERT INTO hoy_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","ई कारण देहाती यहूदी जो बिना नगर इन दिवाल इन ऊरगोळ दा ईरतार, आंदुर अदार तिंगुळ इन चौदहवा दिन इक आनन्द अदिक भोज अदिक खुशी अदिक आपस दा भोजन सामग्री कळोद दिन नियुक्त माळकु मान्सतार. ");
INSERT INTO hoy_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","ई मातगोळ्द वृतांत लिख्‍सकु, मोर्दकै अन्द राजा क्षयर्ष अन्द सप्पा प्रांतगोळ्द दा, येन हात्ती येन दूर ईरावाळेर पुरा यहूदीगोळ्द हात्ती चिट्टीगोळ कळुदुन, ");
INSERT INTO hoy_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","अदिक ईद आग्या कोट्टुन, कि अदार तिंगुळ इन चौदहवा अदिक अदा तिंगुळ इन पंदरावा दिशी हर वर्ष मानसुल. ");
INSERT INTO hoy_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","इऊर दा यहूदीगोळ तान दुश्मनगोळ से आराम सिक्त, अदिक ईद तिंगुळ यदुर देल इदुर दा शोक आनन्द देल, अदिक विलाप खुशी से देल बदलुस्त; मानसुल अदिक आंदरी सामुहिक भोज अदिक आनन्द अदिक आबुर दाबुर हात्ती भोजन सामग्री कळुली अदिक गरीबगोळी दान कोळोद दिन मानसुल. ");
INSERT INTO hoy_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","अत: यहूदीगोळ जसा शुरू माळीदुर, अदिक जसा मोर्दकै आंदरी लिख्‍सकु ");
INSERT INTO hoy_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","यतिकी हम्मदाता अगागी इन पार हामान जो सप्पा यहूदीगोळव विरोधी ईरोन, आव यहूदीगोळ्द नाश माळोद योजना माळदुन, अदिक आंदरी मिटुस्ली अदिक नष्ट माळोर साटी “पूर” मतलब चिट्टी हाकदुन. ");
INSERT INTO hoy_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","लेकीन याग राजा ईद जान्स कोंडुन, आग आव आग्या कोट्टुन अदिक लिखसुसदुन कि जो दुष्ट योजना हामान यहूदीगोळ्द विरूद्ध माळीदुन अद आऊंदा ताल्ला मा पलटुस्कु बरूल, आग आव अदिक आऊन पारगोळ फाँसी इन खंभा मा लटकुसकु आदुर. ");
INSERT INTO hoy_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","ई कारण आ दिनगोळ हेसुर पूर शब्द टु पूरीम ईटकु आत. ई चिट्टी इन सप्पा मातगोळ कारण, अदिक जो येनारा आंदुर ई बारा दा नोळदुर अदिक जो येनारा आंदुर मा बितुस्त, अदुर कारण भी ");
INSERT INTO hoy_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","यहूदीगोळ तान तान साटी अदिक तान औलाद इन साटी, अदिक आ सप्पा मुंदुर साटी भी जो आंदुर दा मिलुसेगीदुर ईद अटल प्रण माळदुर, कि आ लेख इन अनुसार हर वर्ष आऊन ठहरूस्त समय दा आंदुर ईव येढ्ढ दिन मानसुल; ");
INSERT INTO hoy_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","अदिक पीढ़ी पीढ़ी, कुल कुल, प्रान्त प्रान्त, नगर नगर दा ईव दिन याद माळकु अदिक मान्सकु आदव, अदिक पूरीम हेसुर इन दिशी यहूदीगोळ दा यागलु मिटुसतीदील अदिक अऊर याद आंदुर वंश दा मिक्‍कु ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","बाक अबीहैल उन पोर एस्तेर रानी, अदिक मोर्दकै यहूदी पूरीम इन बारा दा ईद दूसरी चिट्टी धोळ अधिकार इन सांगुळ लिख्सदुर. ");
INSERT INTO hoy_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","इदुर नकलगोळ मोर्दकै क्षयर्ष इन राज्य इन ऊंद सौ सत्ताईस प्रान्तगोळ्द सप्पा यहूदीगोळ्द हात्ती शांती कोळावाळेर्द अदिक खरा मातगोळ सांगुळ ई उम्मीद देल कळुदुर, ");
INSERT INTO hoy_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","कि पूरीम इन आ दिनगोळ विशेष ठहरूस्कु समयगोळ दा मोर्दकै यहूदी अदिक एस्तेर इन रानी इन आग्या अन्द अनुसार, अदिक जो यहूदीगोळ तान अदिक तान औलाद इन साटी ठान्स कोंडीदुर, अदुर अनुसार उपवास अदिक विलाप माळकु आगुल. ");
INSERT INTO hoy_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","पूरीम इन बारा दा ईद नियम एस्तेर उन आग्या से भी स्थिर माळकु आत, अदिक अदुर चर्चा किताब दा लिख्‍सकु आत. ");
INSERT INTO hoy_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","राजा क्षयर्ष द्याश अदिक समुद्र अन्द टापू येढ्ढु मा कर हचदुर. ");
INSERT INTO hoy_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","आऊन महानता अदिक पराक्रम इन क्याल्सागोळ, अदिक मोर्दकै अन्द आ बड़ाई इन पुरा ब्योरा, जो राजा आऊन माळीदुन, येन आव मादै अदिक फारस इन राजागोळ्द इतिहास इन किताब दा लिख्‍सकु हैलेच? ");
INSERT INTO hoy_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","यहूदी मोर्दकै, क्षयर्ष राजा अन्द अच ल्‍यालमा ईरोन, अदिक यहूदीगोळ्द नजर दा धोळ ईरोन, अदिक आऊन सप्पा वार्टुर आऊन से खुश ईरोर, यतिकी आव तान लॉकुर्द भलाई इन खोज दा ईरतोगोन अदिक तान सप्पा लॉकुर से शांती इन मातगोळ अनतोगोन.");
INSERT INTO hoy_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","यरूशलेम इन राजा, दाऊद उन पार सभा-उपदेशक उन प्रवचन. ");
INSERT INTO hoy_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","उपदेशक ईद अनतान: सप्पा बेकार आद, सप्पा बेकार आद; सप्पा येनारा बेकार आद! ");
INSERT INTO hoy_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","जो मेहनत मंळसा ई धरती मा माळतान, आऊक अदुर देल येन प्राप्त आगतद? ");
INSERT INTO hoy_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","ऊंद पीढ़ी होगतद, अदिक दुसरा पीढ़ी बरतद, लेकीन पृथ्वी हांग च्या हांगा सदा ईरतद. ");
INSERT INTO hoy_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","सूर्य होळतद, अद मुळ्कतद, अदिक अद जल्दी से आ जागा अक वापस होगतद यल टु अद होळतद. ");
INSERT INTO hoy_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","हवा दक्षिण दिशा इन दी वाहुस्तद, अदिक तिर्गकु उत्तर दा होट बरतद, अदिक हिंग अद हमेशा तान जागा दा चक्कर हचतद, हवा तान जागा अन परिक्रमा माळतद. ");
INSERT INTO hoy_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","सप्पा गांगागोळ समुद्र दा मिलुसताव, लेकीन समुद्र यागलु तुमाल्द. गांगागोळ तान उगम जागा टु मात्त वाहुसताव. ");
INSERT INTO hoy_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","सप्पा मातगोळ थकुसावाळा आव, मंळसा अऊर्द वर्णन माळ सकालुन. कण्णगोळ नोळकु भी तृप्त आगालव, अदिक किवगोळ केळकु भी संतुष्ट आगालव. ");
INSERT INTO hoy_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","जो मात आगेग्याद अद मात आदीत; जो बनसेग्याद अद मात बनसीत; ई धरती मा येनु भी व्हाशोद हैलेच. ");
INSERT INTO hoy_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","येन पृथ्वी मा हिंग येनारा आद, अदुर बारा दा ईद अनकु आग सकुल, “नोळी, ईद व्हाशोद मात आद?” लेकीन अद नाम से हापाळ पयला टु आगतेला बरेत्याद. ");
INSERT INTO hoy_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","हाळोद समय मातगोळ्द येनु याद ईतीदील, अदिक आगावाळा मातगोळ्द भी याद आंदुर बाद्दा बराबाळेर इक ईरतीदील. ");
INSERT INTO hoy_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","ना सभोपदेशक, इस्त्राएल द्याश इन राजा ईरीन अदिक यरूशलेम नगर दा शासन माळीन. ");
INSERT INTO hoy_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","ई धरती मा जो आगतद, बुद्धि देल अदुर्द खोजबीन माळली अदिक अदुर्द भेद समझुसोर साटी ना तान मन हचदीन. ईद ऊंद दुख इन क्याल्सा हुन, यारी परमेश्वर मंळसागोळ इक ईदा क्याल्सा दा व्यस्त ईरोर साटी सौपस्यान. ");
INSERT INTO hoy_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","जो येनारा सूर्य अन ल्यालमा धरती मा आगतद, अद सप्पा ना नोळदीन. नानी अनुभव आत कि ईद सप्पा बेकार आद ईद मान्सी हवा अक हुडोद आद. ");
INSERT INTO hoy_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","जो बदमाश आन, आव सरका आग सकालुन, अदिक जो हई हैलेच, आव आळुकु आग सकालुन. ");
INSERT INTO hoy_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","ना तान दिल से अंदीन, “नोळ, नी हापाळ ग्यान हासील माळकोंड, ईट कि नीन ग्यान आ सप्पा से वाळुसेग्याद, जो नीन से पयले यरूशलेम दा आगीदुर. नीन इक हापाळ बुद्धि अदिक ग्यान इन अनुभव आगेग्याद.” ");
INSERT INTO hoy_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","अत: ना तान मन ईद जानसुर दा हचदीन कि बुद्धि येन हुन, पागलपन अदिक मूर्खता येन हुन. आग नान इक मालुम आत कि ईद भी हवा अक हुडोद हुन. ");
INSERT INTO hoy_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","यतिकी येक्‍कुल बुद्धि येक्कुल दुख इन जननी आद. ग्यान वाळुसावाळा तान दुखगोळी भी वाळुसतान. ");
INSERT INTO hoy_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","ना तान दिल दा अंदीन, “नळ, ईग ना नीनी आनंद इन द्वारा जाचाईन, कि आनंद येन आद, लेकीन ना ईद भी नोळदीन कि ईद भी बेकार आद.” ");
INSERT INTO hoy_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","नान इक हासी-खुशी इन बारा दा अनोद बित्त, “ईद पागलपन आद,” अदिक आनंद इन बारा दा “ईद येन क्याल्सा अन्द आद?” ");
INSERT INTO hoy_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","ना मन दा सोचदीन कि याता प्रकार देल नान बुद्धि बन्सकु ईरूल अदिक ना तान जीव इक अंगुर इन रास्सा कुडोर से याता प्रकार बहलुसाईन अदिक ह्यांग मुर्खता अक हुडुकु ईराईन, यागासताका मालुम माळ कोमालीन कि अद वळ्लीद क्याल्सा यातोद हुन यदरी मंळसा तान जीवन तीम माळतेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","ना धोळ-धोळ क्याल्सा माळदीन. ना तान साटी महल माळदीन अदिक अंगुर इन बेली हचदीन. ");
INSERT INTO hoy_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","ना तान साटी बगीचा अन्द बेली हचदीन अदिक ई बेलीगोळ दा हर प्रकार इन कायगोळ्द मार्र हचदीन. ");
INSERT INTO hoy_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","ना तान साटी क्यार्रागोळ अगुळदीन, यलीद नीर देल आळी दाकळव मार्रगोळ इक नीर कोटकु आगोद. ");
INSERT INTO hoy_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","ना दास-दासीगोळी कोंडीन. नान हात्ती आ गुलामगोळ भी ईरोर, यार्द जनम नान दा महल दा आगीत. नान हाती गोसी-वस्तागोळ्द ईट रेवड़ अदिक म्यांडा-मर्रगोळ्द ईट झुंड ईरव याट कि यरूशलेम दा यातोदु स्वामी अन हाती ईला ईरव. ");
INSERT INTO hoy_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","इदुर अलावा ना राजागोळ्द अदिक प्रदेश इन व्हान्ना, बेळ्ली अदिक धन भी तान हात्ती जमा माळकु ईटीदीन. नान दरबार दा हापाळ गायिकागोळ अदिक गायक ईरोर. नान हात्ती गंळ्सुर दिल बहलुसावाळेर हापाळ रखेल आर्तेर भी ईरोर. ");
INSERT INTO hoy_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","ई प्रकार ना तान से पयले नोर सप्पा यरूशलेम इन ईरावाळेर से येक्कुल महान अदिक धनवान आगेदीन; तरी भी नान बुद्धि नान सांगुळ बिट्टीदिल. ");
INSERT INTO hoy_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","या वस्तुगोळी नोळोद नान इच्छा आत, ना अवरी भरपुर नजर देल नोळदीन. ना यातोदु प्रकार इन आनंद देल तान ह्दय वंचित ईटीदिल, यतिकी नान ह्दय नान मेहनत इन सप्पा क्याल्सागोळ दा आनन्द ताकोमोद अदिक ईदा आनन्द नान सप्पा मेहनतगोळ्द ईनाम ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","आग ना तान क्याल्सागोळ मा विचार माळदीन, ना आ मेहनत मा भी सोचदीन जो ना आ क्याल्सागोळ मा माळीदिन. नान इक अनुभव आत कि ईव सप्पा बेकार आव, ईद मान्सी हवा अक हुडोद आद. ई धरती मा मंळसा अन्द क्याल्सा अदिक मेहनत देल येनु लाभ हैलेच. ");
INSERT INTO hoy_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","ईग ना बुद्धि, पागलपन अदिक मुर्खता मा विचार माळली कुरतीन, यतिकी उत्तराधिकारी जो राजा अन्द हिंद बंदान, आव येन माळ सकतान? सिर्फ अदा, जो आगतेला बरेत्याद? ");
INSERT INTO hoy_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","ना नोळदीन कि जसा अंधकार देल प्रकाश श्रेष्ठ आद हांग अच बुद्धि मूर्खता देल श्रेष्ठ आद. ");
INSERT INTO hoy_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","बुद्धिमान मंळसा अन्द ताल्ला दा आऊन कण्णगोळ ईरताव, अदिक आव नोळकु नळुतान, लेकीन मूर्ख मंळसा अंधकार दा टटुलस्तान. तौभी नान इक ईद अनुभव आत कि मूर्ख अदिक बुद्धिमान येढ्ढु मुंदुर दशा ऊंद घाई आगतद . ");
INSERT INTO hoy_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","ना तान दिल दा अंदीन, “जो दशा मूर्ख अन्द आगतद, अदा नांद भी आदीत. बाक ना ईट बुद्धिमान यती आदीन?” अत: ना तान दिल दा अंदीन, “मूर्ख आगोद, अथवा बुद्धिमान आगोद भी बेकार आद.” ");
INSERT INTO hoy_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","यतिकी ह्यांग मूर्ख अन स्मृति स्थायी ईराल्द हांग अच बुद्धिमान उन भी स्मृति स्थायी ईराल्द. थ्वाळासा अच दिनगोळ दा लॉकुर सप्पा मार्तोगतार. ह्‍यांग मूर्ख सायतान हांग अच बुद्धिमान भी. ");
INSERT INTO hoy_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","नान इन जीवन देल घृणा आगेत, यतिकी धरती मा माळ्द सप्पा क्याल्सा नान इक बुरा हतली कुरतव. ईव सप्पा बेकार आव, ईद मान्सी हवा हुडोद आद. ");
INSERT INTO hoy_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","ना नोळदीन कि नान इक तान मेहनत इन फल आ उत्तराधिकारी इन साटी बिटकु होगोद बिद्दीत जो ना हिंद बरावाळा आन. अत: नान इक तान पुरा मेहनत देल घृणा आगेत जो ना धरती मा माळीदिन. ");
INSERT INTO hoy_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","याव जानस्तान कि ना उत्तराधिकारी बुद्धिमान ईत्तान अथवा मूर्ख? तौभी धरती मा आव नान पुरा मेहनत इन फल इक भोगस्यान अदिक जो येनारा ना बुद्धि देल जमा माळदीन आव अदुर्द स्वामी आदान. अत: ईद भी बेकार आद. ");
INSERT INTO hoy_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","इदुरसाटी ना धरती मा माळ्द तान पुरा मेहनत इन प्रति निराश आगेदीन. अदुर देल विमुख आगेदीन. ");
INSERT INTO hoy_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","यागल्यारा हिंग भी आगतद कि मंळसा बुद्धि, ग्यान अदिक कौशल देल मेहनत माळतान लेकीन आव अदुर्द फल आ मंळसा अन्द द्वारा भोगसोर साटी बिट्ट बुळतान, जो अदुर साटी येनु भी मेहनत माळीदील. ईद भी बेकार आद अदिक हापाळ बुरा आद. ");
INSERT INTO hoy_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","धरती मा मन हचकु माळ्द मेहनत देल मंळसा अक येन लाभ? ");
INSERT INTO hoy_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","खरा केळी रा आऊन जीवन इन सप्पा दिन दुखगोळ देल तुमकु ईरताव, अदिक आऊन क्याल्सा सन्तोष हैलेच, उल्टा सन्ताप पैदा माळतान. ईळ्ल इक भी आऊन मन इक चैन सिकाल्द. ईद भी बेकार आद. ");
INSERT INTO hoy_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","मंळसा अन्द साटी इदुर से येक्‍कुल वळ्लीद मात अदिक यातु हैलेच कि आव तिनुल-कुडुल अदिक आनन्द इन सांगुळ मेहनत माळुल. लेकीन ना नोळदीन कि ईद भी परमेश्वर उन कय देल प्राप्त आगतद. ");
INSERT INTO hoy_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","यतिकी आऊन बिना याव मंळसा तिन-कुडु सकतान, अदिक आनंद माळ सकतान? ");
INSERT INTO hoy_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","या मंळसा से परमेश्वर प्रसन्न आगतान आव आऊका बुद्धि, ग्यान अदिक आनन्द प्रदान माळतान. पापी मंळसा से परमेश्वर कठोर मेहनत माळसुसतान. पापी मंळसा परमेश्वर उन प्रिय मंळसा अन्द साटी धन जमा माळतान अदिक अदरी संचित माळतान. अत: ईद भी बेकार आद, ईद मान्सी हवा अक हुडोद आद. ");
INSERT INTO hoy_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","हर ऊंद मात इन उपयुक्त मौका, अदिक धरती मा माळोद क्याल्सा अन्द निर्धारित समय ईरतद: ");
INSERT INTO hoy_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","जन्म इन समय; अदिक सायोद भी समय, बोऊसोद समय; अदिक बोऊसकु आग्याद अदरी कित्तोद भी समय आद. ");
INSERT INTO hoy_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","कोन्नोद समय, अदिक चंगा माळोद समय, ढाऊसोद समय अदिक माळोद भी समय निर्धारित आद. ");
INSERT INTO hoy_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","वर्लोद समय, अदिक नेग्गोद समय, शोक मानसोद समय, अदिक कुण्णोद भी समय आद. ");
INSERT INTO hoy_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","कल्लगोळ इक बगरूसोद समय, अदिक कल्लगोळ इक जमा माळोद समय, कुतक्या अक हचोद समय अदिक कुतक्या टु दुर ईरोद भी समय ईरतद. ");
INSERT INTO hoy_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","ढुंढसोद समय, अदिक काळोद भी समय, ईटोद समय, अदिक भीळोद भी समय निर्धारित आद. ");
INSERT INTO hoy_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","हरोद समय, अदिक अइक होलोद भी समय, सुंगा ईरोद समय, अदिक माताळोद भी समय निश्चित आद. ");
INSERT INTO hoy_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","प्यार माळोद समय, अदिक घृणा माळोद भी समय, युद्ध माळोद समय, अदिक शांती माळकु ईटोद भी समय आद. ");
INSERT INTO hoy_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","क्याल्सा माळावाळा अक ताक मेहनत देल येन लाभ आगतद? ");
INSERT INTO hoy_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","ना नोळदीन कि परमेश्वर मंळसा जाती मा याट भारी बोझ हाक्यान. ");
INSERT INTO hoy_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","आव हर ऊंद वस्तु अक आऊन साटी सही समय मा अच माळदुन, आव मंळसा अन मन दा अनन्तकाल इन एहसास इक जाग्सदुन, तरी भी मंळसा सम्स सकालुन कि परमेश्वर सुरूवात टु आखरी ताका येन माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","अत: नान इक ईद अनुभव आत कि मंळसा अन्द साटी इदुर से वळ्लीद अदिक यातु मात हैलेच कि आव जीवन-तीम सुख देल अदिक खुशी मान्सतेला ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EC3_13","022_3_13","ECC","3","13","13","ईद परमेश्वर उन वरदान आद कि हर ऊंद मंळसा व्‍हाट्टतीम तिनुल-कुडुल अदिक खुशी देल मेहनत माळुल. ");
INSERT INTO hoy_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","ना ईद जान्सतीन कि जो येनारा परमेश्वर माळतान, अद हमेशा बन्सकु ईत्तीत; अदुर्दा येनु जोळ्सकु आग सकाल्द अदिक येनु गोर्त माळकु आग सकाल्द. परमेश्वर ईद इदुरसाटी माळदुन ताकी मंळसा आऊन से अंजुल. ");
INSERT INTO hoy_vpl VALUES ("EC3_15","022_3_15","ECC","3","15","15","जो आद, अद आगेग्याद, अदिक जो आगावाळा आद, अद भी आगेग्याद. परमेश्वर आऊक ढुंढ्सतान, जो खेदाळ्सकु आग्यान. ");
INSERT INTO hoy_vpl VALUES ("EC3_16","022_3_16","ECC","3","16","16","ना सूर्य अन ल्यालमा धरती मा ईद भी नोळदीन: न्याय इन जागा मा अन्याय आगेत्याद, धार्मिकता अन जागा मा अधर्म आगेत्याद. ");
INSERT INTO hoy_vpl VALUES ("EC3_17","022_3_17","ECC","3","17","17","ना तान दिल दा अंदीन, “परमेश्वर हर ऊंद मात अदिक हर ऊंद क्याल्सा अन्द समय निश्चित माळकु ईट्यान; अत: आव धार्मिक मंळसा अदिक दुष्ट येढ्ढु मुंदुर्द न्याय माळ्यान.” ");
INSERT INTO hoy_vpl VALUES ("EC3_18","022_3_18","ECC","3","18","18","ना मंळसा अन्द औलाद इन बारा दा ईद सोचदीन : परमेश्वर आंदरी ईद सच्चाई कलसोर साटी परखुसेत्यान कि आंदुर जनावर उन अलावा येनु हैलेच. ");
INSERT INTO hoy_vpl VALUES ("EC3_19","022_3_19","ECC","3","19","19","मंळसा अदिक पशु ऊंद अच दशा अक प्राप्त आगतार. ह्यांग पशु सायतद हांग अच मंळसा भी. अऊर सप्पा मुंदुर दा ऊंद अच घाई जीव आद. मंळसा पशु से श्रेष्ट हैलेच. अत: सप्पा व्यर्थ आद. ");
INSERT INTO hoy_vpl VALUES ("EC3_20","022_3_20","ECC","3","20","20","सप्पा आखरी दा ऊंद अच जागा दा होगतार. सप्पा मुण्ण देल बनस्कु आर, अदिक मुण्ण दा अच मिलुसेदार. ");
INSERT INTO hoy_vpl VALUES ("EC3_21","022_3_21","ECC","3","21","21","याव अन सकतान कि मंळसा अन्द जीव म्याकुच होगतद अदिक जनावर इन जीव ल्यालमा दी होगकु मुण्ण दा मिलुसेगतद? ");
INSERT INTO hoy_vpl VALUES ("EC3_22","022_3_22","ECC","3","22","22","अत: नानी मालुम आत कि मंळसा अन्द साटी इदुर से येक्‍कुल वळ्लीद मात अदिक यातोदु हैलेच कि आव खुशी देल तान क्याल्सा माळुल, यतिकी क्याल्सा माळोद अच आऊन नियति आद. याव मंळसा यातोवारा मंळसा अन्द सायोद बाद्दा आऊक वापस तंदकु भविष्य अन्द मातगोळ तोर्स सकतान? ");
INSERT INTO hoy_vpl VALUES ("EC4_1","022_4_1","ECC","4","1","1","आग ना मात विचार माळदीन कि धरती मा याट अत्याचार आगतद, यार मा अत्याचार आगतद, आंदुर तान कण्ण इन नीर वाहुसतार, लेकीन आंदुर कण्ण इन नीर सिटावाळा याऊ ईरालुन. अत्याचार माळावाळेर हाती ताकत ईरोद, लेकीन कण्ण इन नीर वाहुसावाळेर हाती आंदरी दिलासा कोळावाळा भी ईला ईरोन. ");
INSERT INTO hoy_vpl VALUES ("EC4_2","022_4_2","ECC","4","2","2","अदिक ना घोषणा माळदीन कि जो पयले अच सोतोग्यार आंदुर ईग भी जित्ता आर, अदिक जित्तागोळ से येक्कुल खुश आर. ");
INSERT INTO hoy_vpl VALUES ("EC4_3","022_4_3","ECC","4","3","3","लेकीन सोतकु अदिक जीत्ता मंळसागोळ से धोड्डेव आन आव मंळसा याऊन जनम आगीदील, याव सूर्य अन ल्यालमा धरती मा माळकु आदव दुष्कर्मगोळी नोळीदील. ");
INSERT INTO hoy_vpl VALUES ("EC4_4","022_4_4","ECC","4","4","4","बाक ना नोळदीन कि सप्पा मेहनत अदिक सफल क्याल्सागोळी तान मान्ना हातळोर प्रति शत्रु-भावना देल माळकु आगतद. अत: ईद भी व्यर्थ आद, ईद मान्सी हवा अक हुडोद आद. ");
INSERT INTO hoy_vpl VALUES ("EC4_5","022_4_5","ECC","4","5","5","मूर्ख कय मा कय मंळ्सकु कुर्तकु ईरतान, आव मान्सी तान तान इक अच बरबाद माळतान. ");
INSERT INTO hoy_vpl VALUES ("EC4_6","022_4_6","ECC","4","6","6","ठ्वामा तीम मन इन चैन येढ्ढ ठ्वामा मेहनत देल श्रेष्ठ आद, जो मान्सी हवा अक हुडोद आद. ");
INSERT INTO hoy_vpl VALUES ("EC4_7","022_4_7","ECC","4","7","7","ना सूर्य अन ल्यालमा धरती मा मात्त बेकार मातगोळी नोळदीन: ");
INSERT INTO hoy_vpl VALUES ("EC4_8","022_4_8","ECC","4","8","8","यद्यपि मंळसा आबना आन, आऊन पार हैलेच, वार्ट हैलेच, तौभी आव हमेशा कमुस्तेला होगतान, आऊन मेहनत इन येनु अन्त हैलेच. आऊन कण्णगोळ धन-सम्पत्ति देल तृप्त आगालव. आव तान तान इक यागलु केळालुन, “ना ईद मेहनत यार साटी माळेतीन, अदिक येती खुद इक सुख-चैन देल वंचित माळेतीन?” ईद भी व्यर्थ आद, अदिक ऊंद दुखद कार्य व्यापार आद. ");
INSERT INTO hoy_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","ऊंद से येढ्ढ वळ्लेर आगतार, यतिकी आंदरी आंदुर्द मेहनत इन वळ्लीद फल सिकतद. ");
INSERT INTO hoy_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","अगर आंदुर दा टु ऊंद बिळतान रा दुसरा आऊक नेगु सकतान. दुख आऊक जो आबना आन! अगर आव बिदोदान रा आऊक यार नेगदार? ");
INSERT INTO hoy_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","अगर येढ्ढु मुंदुर सांगुळ मिंग्यार रा आंदुर गरम ईत्तार. लेकीन आबना मंळसा तान तान इक ह्यांग गरम माळ सकतान? ");
INSERT INTO hoy_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","प्रहार माळावाळा आबना मंळसा मा प्रबल आग सकतान, लेकीन येढ्ढ मंळसा आऊन सामना माळ सकतार. जो जाळी मुर धागागोळ देल गुंळ्सकु ईरतद, अद जल्दी हराल्द. ");
INSERT INTO hoy_vpl VALUES ("EC4_13","022_4_13","ECC","4","13","13","बुद्धिमान हारोदव पार गरीब ईत्तुर देल भी हिंग हाळाबाट्ट अदिक मूर्ख राजा से उत्तम आन, जो चेतावनी मानसालुन. ");
INSERT INTO hoy_vpl VALUES ("EC4_14","022_4_14","ECC","4","14","14","बाक चाहे हारोदव पार बंदीगृह टु होटकु राजा आगुल, चाहे आव तान राज्य दा गरीब पैदा आगुल. ");
INSERT INTO hoy_vpl VALUES ("EC4_15","022_4_15","ECC","4","15","15","ना सूर्य अन ल्यालमा धरती मा वयाळतेला सप्पा जीवगोळी आ दुसरा हारोदव मंळसा अन दी होगतेला नोळदीन, जो पयलेवाळा अन जागा ताकोंडान. ");
INSERT INTO hoy_vpl VALUES ("EC4_16","022_4_16","ECC","4","16","16","आऊन अनुगामिगोळ्द संख्या, यार्द आव नेतृत्व माळदुन, अगणित ईरोद. फिर भी बरावाळा पीढ़ी आऊन से प्रसन्न आगतीदील. अत: बिना संकोच ईद भी व्यर्थ आद, ईद मान्सी हवा अक हुडोद आद. ");
INSERT INTO hoy_vpl VALUES ("EC5_1","022_5_1","ECC","5","1","1","याग नीव परमेश्वर उन मंदिर दा होगतीर आग तान आचरण इन ध्यान ईटी. मूर्ख द्वारा येर्सकु बलि इन अपेक्षा परमेश्वर उन मंदिर दा बरोद, अदिक आऊन वचन केळोद उत्तम आद. यतिकी मूर्ख ईद जानसालुन कि जो क्याल्सा आव माळतान, अद बुरा आद. ");
INSERT INTO hoy_vpl VALUES ("EC5_2","022_5_2","ECC","5","2","2","तान बाय दा टु यातोदारा मात जल्दी तेगु बाळी, अदिक उतावली दा तान दिल इन मात परमेश्वर उन मुंद प्रकट माळबाळी, यतिकी परमेश्वर रा स्वर्ग दा आन, अदिक नीव पृथ्वी मा. अत: नीम्द शब्द थ्वाळासा अच ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EC5_3","022_5_3","ECC","5","3","3","जसा क्याल्सा अन्द अधीनता अन्द कारण मंळसा कांसा नोळतान, हांग अच हापाळ बकवास देल मूर्ख अन्द मूर्खता प्रकट आगतद. ");
INSERT INTO hoy_vpl VALUES ("EC5_4","022_5_4","ECC","5","4","4","याग नीव परमेश्वर उन साटी मन्नत मान्सतार आग अदरी पुरा माळदुर दा देरी माळबाळेतीर, यतिकी परमेश्वर मूर्खगोळ देल प्रसन्न आगालुर. जो मन्नत नीव मान्सतीर अदरी पुरा माळी. ");
INSERT INTO hoy_vpl VALUES ("EC5_5","022_5_5","ECC","5","5","5","मन्नत मान्सकु अदरी पुरा ईला माळदुर देल मन्नत इन ईला मानसोद अच वळ्लीद आद. ");
INSERT INTO hoy_vpl VALUES ("EC5_6","022_5_6","ECC","5","6","6","नीव तान बाय देल हिंग शब्द तेगुबाळी जो नीम इक पाप दा फसुसुल. स्वर्गदूत उन मुंद ईद अनबाळी कि नान से भूल आगेत. ईलारा परमेश्वर नीम्द आवाज केळकु खुश आगतीदील, अदिक आव मेहनत देल माळ्द नीम्द क्याल्सा अक नष्ट माळ बुट्टान. ");
INSERT INTO hoy_vpl VALUES ("EC5_7","022_5_7","ECC","5","7","7","याग मंळसा येक्‍कुल से येक्‍कुल कांसा नोळली कुरतान, आग आऊन व्यर्थ मातगोळ भी वाळुसतद. लेकीन नीव परमेश्वर उन अंज्क मान्सी. ");
INSERT INTO hoy_vpl VALUES ("EC5_8","022_5_8","ECC","5","8","8","अगर नीव यातोदारा प्रदेश दा गरीबगोळ मा अत्याचार आगतेला नोळीर, अगर नीव अल‍ न्याय अदिक धर्म अन्द कुतक्या घोट्सकु आगतेला नोळीर, रा आश्चर्य माळ बाळेतीर; यतिकी ऊंद अधिकारी इन म्याकुच आऊन से धोळ अधिकारी ईरतान अदिक आऊन से भी म्याकुच उच्च अधिकारी ईरतान. ");
INSERT INTO hoy_vpl VALUES ("EC5_9","022_5_9","ECC","5","9","9","केई इन फसल सप्पा मुंदुर साटी आद, लेकीन केई देल राजा अन भी क्याल्सा होट्ट बुळतद. ");
INSERT INTO hoy_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","पैस्या से प्यार माळावाळा पैस्या से यागलु संतुष्ट ईरालुन; अदिक न हिंग मंळसा, यारी धन से प्यार आद, आऊन येक्‍कुल से येक्कुल लाभ देल संतुष्ट आगतान. ईद भी व्यर्थ आद. ");
INSERT INTO hoy_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","याग सम्पत्ति वाळुस्तद आग अदरी तिनावाळेर भी वाळुसतार. अत: आऊन स्वामी इक आऊन से येन लाभ? सिर्फ ईद कि आव अदरी केवल कण्ण देल नोळुल! ");
INSERT INTO hoy_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","मजदूर उन साटी वरदान आद, सय जप, चाहे आव आरधा व्हाट्टा तिनुल चाहे व्हाट्टा तीम. लेकीन धनवान उन धन वाळुसदुर देल आऊन कण्णगोळ से जप हारेगतद. ");
INSERT INTO hoy_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","ना धरती मा ऊंद दुखद बुराई नोळदिन : धन इन स्वामी तान हानि इन साटी धन जमा माळतान. ");
INSERT INTO hoy_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","अगर आऊन धन सट्टेबाजी दा हारेगतद, अदिक आऊन मान्ना दा पार जन्म ताकोमतान रा आऊन कय दा येनु मिक्‍कु ईराल्द. ");
INSERT INTO hoy_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","जसा आव तान मोय इक गर्भ टु पैदा आगीदुन हांग अच नंगा वापस होदान, आव तान कय दा तान मेहनत इन फल वय सकालुन. ");
INSERT INTO hoy_vpl VALUES ("EC5_16","022_5_16","ECC","5","16","16","ईद दुखद बुराई आद, जसा आव बंदीदुन ठीक हांगा ईल टु वापस होदान. आऊक तान मेहनत देल येन लाभ आत? ");
INSERT INTO hoy_vpl VALUES ("EC5_17","022_5_17","ECC","5","17","17","आव व्यर्थ अच मेहनत माळदुन, आव तान पुरा जीवन उदासी अदिक दुख दा, चिन्ता अदिक रोग दा, सिट्ट दा व्यतीत माळदुन. ");
INSERT INTO hoy_vpl VALUES ("EC5_18","022_5_18","ECC","5","18","18","नोळी, जो भला मात ना अनुभव माळदीन, अदिक जो उचित भी आद, अद ईद आद : “मंळसा परमेश्वर द्वारा कोटकु आग्याद तान अल्पकाल इन जीवन दा धरती मा खुशी देल मेहनत माळुल, तिनुल अदिक कुडुल, यतिकी ईदा आऊन भाग हुन.” ");
INSERT INTO hoy_vpl VALUES ("EC5_19","022_5_19","ECC","5","19","19","हर ऊंद मंळसा, याऊक परमेश्वर धन-सम्पत्ति कोटुन अदिक आऊक भोगसोद सामर्य्थ भी कोट्टुन, आव तान भाग इक स्वीकार माळुल अदिक खुशी देल मेहनत माळुल. ईद परमेश्वर उन वरदान आद. ");
INSERT INTO hoy_vpl VALUES ("EC5_20","022_5_20","ECC","5","20","20","मंळसा तान पुरा जीवन इक हमेशा अन साटी याद ईटतीदील, यतिकी परमेश्वर मंळसा अक आ क्याल्सागोळ दा अच हचकु ईटतान, या क्याल्सागोळी माळदुर दा आ मंळसा रुची ईटतान. ");
INSERT INTO hoy_vpl VALUES ("EC6_1","022_6_1","ECC","6","1","1","ना धरती मा ऊंद अदिक बुराई नोळदीन, अदुर भार देल मंळसा वतकु ईरतान. ");
INSERT INTO hoy_vpl VALUES ("EC6_2","022_6_2","ECC","6","2","2","अद बुराई ईद हुन: परमेश्वर मंळसा अक धन-सम्पत्ति अदिक प्रतिष्ठा प्रदान माळतान, अदिक मंळसा अक तान इच्छा अन्द अनुसार सप्पा येनारा प्राप्त आगेगतद. आऊक यातोदु वस्तु अन्द अभाव ईराल्द. लेकीन आ मंळसा अक परमेश्वर धन-सम्पत्ति भोगसोद सामर्थ्य कोळाल्द; बल्‍की अनजान मंळसा आऊन धन-सम्पत्ति भोग्सतान. इदुरसाटी धन-सम्पत्ति बेकार आद, ईद भयानक दुख इ मात आद. ");
INSERT INTO hoy_vpl VALUES ("EC6_3","022_6_3","ECC","6","3","3","अगर यावारा मंळसा अन्द सौ पार पैदा आगतार, अदिक आव लम्बा उमर ताका जीत्ता ईरतान, दीर्घ आयु प्राप्त माळतान, लेकीन अगर आव जीवन इन सुखगोळ इक भोग्स सकालुन, सोतुर मा आखरी किर्या भी आऊक प्राप्त आग बाळुल, रा ना ईद अनाईन: हिंग मंळसा से अधुरा समय दा जनमुस्द सोतकु पार वळ्लेव आन. ");
INSERT INTO hoy_vpl VALUES ("EC6_4","022_6_4","ECC","6","4","4","सोतकु बच्चा ई धरती मा व्यर्थ अच बरतान, अदिक अंधकार दा लुप्त आगेगतान, अदिक आऊन हेसुर भी अंधकार दा मुच्चेगतद. ");
INSERT INTO hoy_vpl VALUES ("EC6_5","022_6_5","ECC","6","5","5","आव सूर्य अन्द प्रकाश उक नोळ सकीदील, अदिक आऊक जीवन इन येनु अनुभव आगीदील. फिर भी आऊक आ दीर्घायु वाळा मंळसा से येक्‍कुल आराम सिक्त. ");
INSERT INTO hoy_vpl VALUES ("EC6_6","022_6_6","ECC","6","6","6","चाहे मंळसा येढ्ढ हजार वर्ष जीऊसुल, लेकीन अगर आव जीवन इन आनन्द पूर्वक भोग माळालुन रा हिंग दीर्घायु देल येन लाभ? सप्पा मंळसा जीवन इन आखरी दा ऊंद अच जागा अक होगतार. ");
INSERT INTO hoy_vpl VALUES ("EC6_7","022_6_7","ECC","6","7","7","मंळसा तान व्हाट्टा अन्द साटी अच सप्पा मेहनत माळतान, तौभी आऊन व्हाट्टा यागलु तुमाल्द. ");
INSERT INTO hoy_vpl VALUES ("EC6_8","022_6_8","ECC","6","8","8","अत: बुद्धिमान मंळसा याता मात दा मूर्ख मंळसा से श्रेष्ठ आदुन? गरीब मंळसा, जो ईद जान्सतान कि जीवन दा ह्यांग आचरण माळ पायजे, आऊन से याता मात दा श्रेष्ठ सिद्ध आदुन? ");
INSERT INTO hoy_vpl VALUES ("EC6_9","022_6_9","ECC","6","9","9","कण्णगोळ देल नोळ कोमोद मन इन चंचल कामनागोळ से उत्तम आद. अत: व्हाट्टा अन्द साटी मेहनत माळोद भी बेकार आद, ईद मानसी हवा अक हुडोद आद. ");
INSERT INTO hoy_vpl VALUES ("EC6_10","022_6_10","ECC","6","10","10","जो यावारा भी मंळसा आगुल, आऊक आऊन हेसुर पयले टु अच कोटकु आगीत: मंळसा अन्द बारा दा ईद प्रकट माळकु आगेग्याद कि आव केवल मुण्ण आन. अत: आव तान से येक्‍कुल बलवान मंळसा से लळाई माळ सकालुन. ");
INSERT INTO hoy_vpl VALUES ("EC6_11","022_6_11","ECC","6","11","11","जीवन इन बारा दा याट विचार माळी, आट अच अद बेकार हततद, रा हिंग जीवन देल मंळसा अक येन लाभ? ");
INSERT INTO hoy_vpl VALUES ("EC6_12","022_6_12","ECC","6","12","12","मंळसा तान क्षणिक जीवन सावली इन घाई व्यतीत माळतान; अत: याव जानस्तान कि आऊन साटी हिंग जीवन दा उत्तम येन आद? मंळसा अक याव हेळ सकतान कि आऊन सोत्तुर बाद्दा सूर्य अन्द ल्‍यालमा धरती मा येन आदीत? ");
INSERT INTO hoy_vpl VALUES ("EC7_1","022_7_1","ECC","7","1","1","हेसुर इन सुगन्ध अनमोल अत्तर इन सुगन्ध से धोळ्द आद. सायोद दिन जनम इन दिन से उत्तम आद. ");
INSERT INTO hoy_vpl VALUES ("EC7_2","022_7_2","ECC","7","2","2","भोज इन त्योहार दा सम्मिलित आगोद अपेक्षा सायोद-शोक देल पीड़ित परिवार दा होगोद वळ्लीद आद, यतिकी सायोद अच सप्पा मंळसागोळ्द अच अन्त आद. अत: जीत्ता मंळसा गम्भीरतापूर्वक तान अन्त मा विचार माळ्यान. ");
INSERT INTO hoy_vpl VALUES ("EC7_3","022_7_3","ECC","7","3","3","नेग्गोर से वळ्लीद दुख आद; यतिकी मार्रा अन दुख दिल इन सुख आद. ");
INSERT INTO hoy_vpl VALUES ("EC7_4","022_7_4","ECC","7","4","4","बुद्धिमान मंळसा अन्द दिल शोक-पीड़ित परिवार दा हतकु ईरतद, लेकीन मूर्ख मंळसा अन्द मन आनंद माळावाळा मान्ना दा हतकु ईरतद. ");
INSERT INTO hoy_vpl VALUES ("EC7_5","022_7_5","ECC","7","5","5","मूर्खगोळ बायदेल हाळ केळोद अपेक्षा बुद्धिमान उन फटकार केळोद वळ्लीद आद. ");
INSERT INTO hoy_vpl VALUES ("EC7_6","022_7_6","ECC","7","6","6","मूर्खगोळ्द नेगोद हांग अच ईरतद जसा माळका अन्द ल्‍यालमा होततेला मुळ्लगोळ्द चरचराहट. अत: ईद भी व्यर्थ आद. ");
INSERT INTO hoy_vpl VALUES ("EC7_7","022_7_7","ECC","7","7","7","निस्सन्देह अत्याचार इन कमाई देल बुद्धिमान भी मूर्ख बनसेगतान, घुस ताकोंडुर देल बुद्धि नष्ट आगेगतद. ");
INSERT INTO hoy_vpl VALUES ("EC7_8","022_7_8","ECC","7","8","8","क्याल्सा अन्द शुरू देल अदुर्द अन्त उत्तम आद, अहंकारी गंळ्स उन अपेक्षा धीरज ईटावाळा गंळ्स श्रेष्ठ आन. ");
INSERT INTO hoy_vpl VALUES ("EC7_9","022_7_9","ECC","7","9","9","तुरन्त क्रोधित आगबाळी, यतिकी क्रोध इन वास मूर्ख उन दिल आद. ");
INSERT INTO hoy_vpl VALUES ("EC7_10","022_7_10","ECC","7","10","10","ईद अनबाळी, कि ईंद से बितुस्कु नाळ वळ्लीद आद. यतिकी ईदुर बारा दा निम्द हिंग अनोद बुद्धि द्वारा हैलेच. ");
INSERT INTO hoy_vpl VALUES ("EC7_11","022_7_11","ECC","7","11","11","बुद्धि विरासत इन घाई ऊंद वळ्लीद चीज आद, अदिक आ लॉकुर इक लाभ पहुचुसतद जो सुर्य अक नोळतार. ");
INSERT INTO hoy_vpl VALUES ("EC7_12","022_7_12","ECC","7","12","12","बुद्धि इन संरक्षण धन इन संरक्षण इन तुल्य आद. ग्यान देल ईद लाभ आद कि आव तान धारक उन जीवन सुरक्षित ईटतान. ");
INSERT INTO hoy_vpl VALUES ("EC7_13","022_7_13","ECC","7","13","13","परमेश्वर उन क्याल्सागोळ मा विचार माळी: यारी परमेश्वर वाकळा माळदुन, आऊक याव सीधा माळ सकतान? ");
INSERT INTO hoy_vpl VALUES ("EC7_14","022_7_14","ECC","7","14","14","सुख इन दिनगोळ दा खुशी मनुसी, लेकीन दुख इन दिनगोळ दा विचार माळी, यतिकी परमेश्वर सुख अदिक दुख येढ्ढु उक माळदुन, ताकी मंळसा अक ई मात इन भेद सिकबाळुल कि अदुर बाद्दा येन आगोद आद. ");
INSERT INTO hoy_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","ना तान बेकार जीवन दा ईद नोळदीन: न्यायी मंळसा तान न्यायीपन दा सायतान, लेकीन दुर्जन मंळसा दुष्कर्म माळतेला लंबा ऊमर हासील माळतान. ");
INSERT INTO hoy_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","अत: येक्‍कुल धार्मिक बन्सबाळी, अदिक येक्‍कुल बुद्धिमान! ईलारा नीव तान कालगोळ मा खुद कोळ्ली बळदीर. ");
INSERT INTO hoy_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","येक्‍कुल अधार्मिक भी बन्सबाळी, अदिक न मूर्ख. ईलारा नीव समय से पयला अच सोतोदीर. ");
INSERT INTO hoy_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","वळ्लीद ईद आद कि नीव ऊंद इक हुळकु ईटी, अदिक दुसरा अक भी तान कयगोळ से होळगोळ बाळी. जो मंळसा परमेश्वर उन भक्ति माळतान, आव ई सप्पा कठिनाईगोळ से पार आगेदान. ");
INSERT INTO hoy_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","बुद्धी इच बुद्धिमान मंळसा अक नगर इन हत्त शासकगोळ से येक्‍कुल ताकत प्रदान माळतद. ");
INSERT INTO hoy_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","निश्चय अच धरती मा याऊ हिंग न्यायी मंळसा हैलेच जो सदा भलाई अच माळतान, अदिक यागलु पाप माळालुन. ");
INSERT INTO hoy_vpl VALUES ("EC7_21","022_7_21","ECC","7","21","21","जो मातगोळ मंळसा अनतान, आ सप्पा मातगोळ मा कीव हचबाळेतीर. ईलारा नीव ईद मात केळीर कि नीम्द सेवक नीम्द बुराई माळोन. ");
INSERT INTO hoy_vpl VALUES ("EC7_22","022_7_22","ECC","7","22","22","नीम्द दिल जान्सतद कि खुद नीव भी हापाळ घन दुसरा मंळसागोळ बुराई माळीर. ");
INSERT INTO hoy_vpl VALUES ("EC7_23","022_7_23","ECC","7","23","23","“ईद सप्पा ना बुद्धि देल परखुसदीन. ना सोचदीन, ‘ना बुद्धिमान बनसाईन’, लेकीन बुद्धि नान से दूर अच ईत. ");
INSERT INTO hoy_vpl VALUES ("EC7_24","022_7_24","ECC","7","24","24","जो तत्व आव, अव हापाळ दूर आव, गहरा आव, अदिक अत्यंत गहरा आव. अदरी याव सम्स सकतान?” ");
INSERT INTO hoy_vpl VALUES ("EC7_25","022_7_25","ECC","7","25","25","ना ईद जानसोर साटी मन हचदीन कि बुद्धि येन हुन, सब इन सार तत्व येल आद अदुर देल नानी ग्यात आगुल कि मूर्खता अधर्म आद, मूर्खता पागलपन आद. ");
INSERT INTO hoy_vpl VALUES ("EC7_26","022_7_26","ECC","7","26","26","आग ना सायोद से येक्‍कुल कळा सत्य प्राप्त माळदीन : मतलब आ आर्त, आकिन दिल फंदा आद, आकिन मन जाल आद, आकिन कय जंजीर आव. केवल आवा गंळ्स आकिन से वाचुस सकतान, याऊन से परमेश्वर प्रसन्न ईरतान, ईलारा पापी गंळ्स अदुर्द शिकार आगेगतान. ");
INSERT INTO hoy_vpl VALUES ("EC7_27","022_7_27","ECC","7","27","27","उपदेशक अनतान: नोळी, याग ना सार तत्व तेगोर साटी आबुर दाबुर से मार जोळ्सदेव, आग नानी ईद तथ्य कय दा हत. ");
INSERT INTO hoy_vpl VALUES ("EC7_28","022_7_28","ECC","7","28","28","लेकीन ना यारी ढुंढ्सतेला ईत्तीन, आव नानी सिकीदिल. हजार गंळ्सुर दा येल्यारा ऊंद गंळ्स नानी सिकदुन, लेकीन अऊर दा नानी ऊंद भी आर्त सिकीदील. ");
INSERT INTO hoy_vpl VALUES ("EC7_29","022_7_29","ECC","7","29","29","नोळी, ना केवल ईद सच्चाई नोळदीन परमेश्वर मंळसा अक सीधा-सादा माळदुन, लेकीन मंळसा खुद जीवन इन हापाळ योजनागोळ ढुंढ्सकु तेगदुन. ");
INSERT INTO hoy_vpl VALUES ("EC8_1","022_8_1","ECC","8","1","1","बुद्धिमान मंळसा यार घाई आन? याव मंळसा तत्व अन्द अर्थ जानस्तान? मंळसा अन्द बुद्धी इन कारण आऊन बाय चमकुसतद, अदिक आऊन मार्रा अन्द दुख दुर आगेगतद. ");
INSERT INTO hoy_vpl VALUES ("EC8_2","022_8_2","ECC","8","2","2","ना नीनी सलाह कोळतीन कि, परमेश्वर उन मुंद ताकोम्द किर्‍या अन कारण नी राजा अन आग्या अन पालन माळ. ");
INSERT INTO hoy_vpl VALUES ("EC8_3","022_8_3","ECC","8","3","3","आऊन मुंद टु होटोगी; अगर आव यातोदु मात देल अप्रसन्न आन रा नीव अल ठहरूसबाळी; यतिकी राजा ह्यांग चाहासतान हांग माळतान. ");
INSERT INTO hoy_vpl VALUES ("EC8_4","022_8_4","ECC","8","4","4","राजा अन शब्दगोळ दा परम सत्ता ईरतद, राजा से याव केळ सकतान, “नीव ईद येन माळेतीर?” ");
INSERT INTO hoy_vpl VALUES ("EC8_5","022_8_5","ECC","8","5","5","जो मंळसा राजा अन्द आग्या अन्द पालन माळतान, आऊन हानि आगाल्द. बुद्धिमान मंळसा उपयुक्त समय अदिक उपयुक्त कार्य-विधि जानस्तान. ");
INSERT INTO hoy_vpl VALUES ("EC8_6","022_8_6","ECC","8","6","6","हर ऊंद मात इन उपयुक्त समय अदिक उपयुक्त कार्य-विधि ईरतद, इदुरसाटी मंळसा अन्द दुख आऊन साटी हापाळ भारी बिळतद. ");
INSERT INTO hoy_vpl VALUES ("EC8_7","022_8_7","ECC","8","7","7","मंळसा ईद जानसालुन कि येन आगावाळा आद, यतिकी याव मंळसा आऊक भविष्य दा घटुसावाळा मातगोळ हेळ सकतान? ");
INSERT INTO hoy_vpl VALUES ("EC8_8","022_8_8","ECC","8","8","8","हिंग याव मंळसा आन आऊन वश जीव मा नळुल, अदिक आव जीव इन होळा समय अदरी रोक्स कोमुल? सायोद दिन मा सायावाळा अन्द अधिकार ईराल्द. युद्ध देल छुटकारा सिकाल्द, अदिक न दुष्ट मंळसा तान दुष्टता अन्द कारण मृत्यु देल ऊळु सकतान. ");
INSERT INTO hoy_vpl VALUES ("EC8_9","022_8_9","ECC","8","9","9","याग ना धरती मा आगावाळा मातगोळ मा गम्भीरतापूर्वक तान मन हचदीन, आग ना ईद नोळदीन: याग ऊंद मंळसा दुसरा मंळसा मा प्रभुत्व जम्सतान आग आव खुद इन नाश माळतान. ");
INSERT INTO hoy_vpl VALUES ("EC8_10","022_8_10","ECC","8","10","10","आग ना दुष्टगोळ इक कबर दा नळ्स्तेला नोळदीन. आंदुर पवित्र जागा दा होगतेला बरतेला ईरोर. नगर दा यल आंदुर नाना प्रकार इन दुष्‍कर्म माळीदुर, आंदुर्द प्रशंसा आगतोगोद. ईद भी बेकार आद. ");
INSERT INTO hoy_vpl VALUES ("EC8_11","022_8_11","ECC","8","11","11","दुष्‍कर्म अन्द साटी मंळसा अक जल्दी दण्ड सिकाल्द, इदुरसाटी मंळसागोळ्द दिल दुष्‍कर्म माळदुर दा हतकु ईरतद. ");
INSERT INTO hoy_vpl VALUES ("EC8_12","022_8_12","ECC","8","12","12","यद्यपि पापी मंळसा सौ घन दुष्‍कर्म माळतान, अदिक आऊक दण्ड सिकाल्द, आव लम्बा उमर ताका जीत्ता ईरतान, यद्यपि ना ईद जान्सतीन कि परमेश्वर उन से अंजावाळेर्द अन्त भी भला अच आगतद. परमेश्वर आंदुर्द भला माळतान, यतिकी आंदुर आऊन से अंजतार. ");
INSERT INTO hoy_vpl VALUES ("EC8_13","022_8_13","ECC","8","13","13","लेकीन दुष्ट उन आखरी दा भला आगतीदील, अदिक आव छाया अन्द सदृश तान उमर लम्बा माळ सकतीदिल, यतिकी आव परमेश्वर से अंजालुन. ");
INSERT INTO hoy_vpl VALUES ("EC8_14","022_8_14","ECC","8","14","14","ऊंद मात अदिक : ईद भी व्यर्थ आद, अदिक पृथ्वी मा आगतद. सच्चा मंळसागोळ इक दुर्जन मंळसागोळ्द दुष्कर्मगोळ्द फल भुगतुसोद बिळतद, अदिक दुर्जन मंळसा सच्चा मंळसागोळ्द सत्कर्मगोळ्द फल प्राप्त माळतान. अत: ना अनतीन, ईद भी व्यर्थ आद. ");
INSERT INTO hoy_vpl VALUES ("EC8_15","022_8_15","ECC","8","15","15","इदुरसाटी ना लॉकुर इक सलाह कोळतीन: आनंद मनुसी. धरती मा मंळसा अन्द साटी तिनोद-कुडोद अदिक आनन्द मानसोद अलावा अदिक येनु भी वळ्लीद हैलेच. जो आयु परमेश्वर अदरी ई धरती मा प्रदान माळदुन, आऊन मेहनत दा ईदा खुशी सांगुळ ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","याग ना बुद्धि प्राप्त माळोर साटी, तथा पृथ्वी मा आगावाळा क्याल्सा व्यापार इक समसोर साटी मन हचदीन, अदिक याग ना ईद जानसोद प्रयत्न माळदीन कि ह्यांग मंळसा ईळ्ल-हागुल जागस्तेला ईरतार, ");
INSERT INTO hoy_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","आग नान इक अनुभव आत कि परमेश्वर उन पुरा क्याल्सा, जो ई धरती मा आगतद, चाहे मंळसा अदुर्द भेद जानसोर साटी याटारा अच मेहनत येती माळबाळुल, आव अदुर्द पता हच सकालुन. अगर यावारा बुद्धिमान मंळसा आऊक जानसोद दावा माळुल तौभी आव आऊन पता हच सकालुन. ");
INSERT INTO hoy_vpl VALUES ("EC9_1","022_9_1","ECC","9","1","1","ना ई सप्पा मातगोळ इक जाचदीन-परखुसदीन अदिक मन देल गम्भीरतापूर्वक विचार माळदीन. आग नान इक ग्यात आत कि न्यायी अदिक बुद्धिमान मंळसा अदिक आंदुर्द सत्कर्मगोळ्द फल परमेश्वर उन कयगोळ दा आद. मंळसा ईद जानसालुन कि परमेश्वर आऊन क्याल्सा देल प्रसन्न आन अथवा आऊक आऊन क्याल्सागोळ से घृणा आद. अत: आऊन मुंद सप्पा व्यर्थ आद. ");
INSERT INTO hoy_vpl VALUES ("EC9_2","022_9_2","ECC","9","2","2","सप्पा अन्द नियति ऊंद अच आद: न्यायी अदिक अन्यायी, भला अदिक बुरा, शुद्ध अदिक अशुद्ध, बलि येरसावाळा-बलि ईला येरसावाळा. जो नियति वळ्लेव मंळसा अन्द आद अदा पापी मंळसा अन्द आद. जो तान किर्‍या अक पुरा माळतान, आऊन नियति अदा आद, जो तान किर्‍या अन्द उल्लंघन माळतान. ");
INSERT INTO hoy_vpl VALUES ("EC9_3","022_9_3","ECC","9","3","3","जो बुराईगोळ ई धरती मा विराजमान आद अऊर दा ऊंद ईद गलत आद: सप्पा मंळसा ऊंद अच गति अक प्राप्त आगतार. मंळसागोळ्द दिल बुराई देल तुमकु आद. यागासताका आंदुर जीत्ता ईरतार, आंदुर दा पागलपन समुस्कु ईरतद. अदुर बाद्दा आंदुर सोतकु मंळसागोळ दा मिलुस्तार. ");
INSERT INTO hoy_vpl VALUES ("EC9_4","022_9_4","ECC","9","4","4","यागासताका मंळसा जीत्ता ईरतान, आऊन दिल दा आशा अन्द दिंग्या टिमटिमुस्कु ईरतद, यतिकी जीत्ता नाय सोतकु हुल्ल इन से वळ्लीद आद. ");
INSERT INTO hoy_vpl VALUES ("EC9_5","022_9_5","ECC","9","5","5","जो जीत्ता आन, आंदुर जान्सतार कि आंदरी ऊंद दिन सायोदा बिदीत, लेकीन जो सोतोग्यार, आंदुर येन जानस्तार? आंदरी प्रतिफल सिकेग्याद. आंदुर्द स्मृति मिटुसेग्याद. ");
INSERT INTO hoy_vpl VALUES ("EC9_6","022_9_6","ECC","9","6","6","आंदुर्द प्यार, आंदुर्द घृणा, आंदुर्द दुश्मनी सप्पा नष्ट आगेत. ई धरती इन क्याल्सा-व्यापार दा ईद आंदुर्द यातोदु भाग हैलेच. ");
INSERT INTO hoy_vpl VALUES ("EC9_7","022_9_7","ECC","9","7","7","तान मान्नी होगी, खुशी देल रोट्टी तीनी, अदिक दिल इन उमंग देल अंगुर इन रास्सा कुढी, यतिकी जो नीव माळतीर, अदरी परमेश्वर पयला टु तान स्वीकृति कोट्ट बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EC9_8","022_9_8","ECC","9","8","8","नीम्द कपळा हमेशा‍ स्वच्‍छ ईरूल, नीम्द ताल्ला मा हमेशा याण्णा हतकु ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EC9_9","022_9_9","ECC","9","9","9","परमेश्वर धरती मा बेकार जीवन इन यास भी दिन कोट्टुन, अऊर दा तान प्रिय हिंग्स उन सांगुळ जीवन इन आनन्द भोगसी, यतिकी जीवन दा ईदा नीम्द भाग आद. जो मेहनत नीव धरती मा माळतीर अदुर्दा नीम्द हिस्सा आद. ");
INSERT INTO hoy_vpl VALUES ("EC9_10","022_9_10","ECC","9","10","10","नीम्द कय दा जो भी क्याल्सा बरूल, अदरी पुरा ताकत देल माळी, यतिकी अधोलोक दा, यल तान सोत्तुर बाद्दा नीव होदीर, न क्याल्सा आद, न विचार. अल न ग्यान आद, न बुद्धि. ");
INSERT INTO hoy_vpl VALUES ("EC9_11","022_9_11","ECC","9","11","11","ना मात: अनुभव माळदीन कि ई धरती मा तेज ओळावाळा धावक जिक्सालुन, अदिक न बलवान योद्धा लळाई जिक्सतान. बुद्धिमान मंळसा अक भोजन सिकाल्द, अदिक न समझदारगोळ इक धन-सम्पत्ति. विद्वानगोळ मा याऊ कृपा माळालुर. ईव सप्पा समय अदिक संयोग इन वश दा आद. ");
INSERT INTO hoy_vpl VALUES ("EC9_12","022_9_12","ECC","9","12","12","मंळसा तान समय जानसालुन. जसा मेनगोळ कुटिल जाल दा फसुसतद, जसा पक्षीगोळ फंदा दा फसुसतद, हांग अच मंळसा समय इन जाल दा फसुसतान. ईद जाल अचानक आंदुर मा बिळतद. ");
INSERT INTO hoy_vpl VALUES ("EC9_13","022_9_13","ECC","9","13","13","ना धरती मा बुद्धि इन ऊंद उदाहरण नोळदीन. ईद नान इक बड़ा महत्वपूर्ण हत. ");
INSERT INTO hoy_vpl VALUES ("EC9_14","022_9_14","ECC","9","14","14","ऊंद स्यांळतुसा नगर ईरोद. अदुर दा गिना-चुना लॉकुर ईरतोगोर. ऊंद दिशी अदुर मा यावारा धोळ राजा आक्रमण माळ बुट्टुन, अदिक अदरी घेर्स कोंडुन. अदुर नाकु दी धोळ घेराबन्दी माळ बुट्टुन. ");
INSERT INTO hoy_vpl VALUES ("EC9_15","022_9_15","ECC","9","15","15","आ स्यांळतुसा नगर दा ऊंद गरीब, लेकीन बुद्धिमान मंळसा ईरोन. आव तान बुद्धि देल आ नगर इक ऊळ्सदुन. फिर भी आ गरीब उक सप्पा लॉकुर मार्तोदुर. ");
INSERT INTO hoy_vpl VALUES ("EC9_16","022_9_16","ECC","9","16","16","लेकीन गरीब मंळसा अन्द बुद्धी इन याऊ सम्मान माळीदिल, आऊन मातगोळ मा ध्यान कोटीदील तौभी ना अनतीन: बल देल बुद्धि वळ्लीद आद. ");
INSERT INTO hoy_vpl VALUES ("EC9_17","022_9_17","ECC","9","17","17","मूर्खगोळ बीच राजा अन चिळ्लासोद से आबना दा बुध्दीमान उन मातगोळ केळ कोमोद ज्यादा वळ्लीद आद. ");
INSERT INTO hoy_vpl VALUES ("EC9_18","022_9_18","ECC","9","18","18","युद्ध इन शस्त्रगोळ से बुद्धि उत्तम आद, लेकीन ऊंद पापी हापाळ भला क्याल्सागोळ इक नष्ट माळ बुळतान. ");
INSERT INTO hoy_vpl VALUES ("EC10_1","022_10_1","ECC","10","1","1","सोतकु नॉणगोळ सुगंधित याण्णा अक दुर्गंध दा बदलुस बुळताव, ईदा प्रकार थ्वाळासा मूर्खता बुद्धि अदिक मान-सम्मान मा नीर फेर्सबुळताव. ");
INSERT INTO hoy_vpl VALUES ("EC10_2","022_10_2","ECC","10","2","2","बुद्धिमान उन दिल आऊक उचित हादी इन दी माळतद, लेकीन मूर्ख उन मन बुराई इन दी आऊक प्रेरित माळतद. ");
INSERT INTO hoy_vpl VALUES ("EC10_3","022_10_3","ECC","10","3","3","“याग मूर्ख हादी मा नळुतान आग भी आऊन दा समझ इन कमी ईरतद. अदिक आंदुर सप्पा मुंदरी तोर्सतान कि, आव याट मूर्ख आन.” ");
INSERT INTO hoy_vpl VALUES ("EC10_4","022_10_4","ECC","10","4","4","अगर शासक नीन से नाराज आन रा नीव तान जागा बिळ बाळी. यतिकी धैर्य गंभीर अपराध भी सुधार्स कोमतान. ");
INSERT INTO hoy_vpl VALUES ("EC10_5","022_10_5","ECC","10","5","5","ना धरती मा ऊंद बुराई नोळदीन. ई बुराई इन जिम्मेदार शासक आन. ");
INSERT INTO hoy_vpl VALUES ("EC10_6","022_10_6","ECC","10","6","6","मूर्ख ऊंचा जागागोळ मा कुर्सकु आगतार, अदिक धनी ल्यालमा अन जागागोळ दा. ");
INSERT INTO hoy_vpl VALUES ("EC10_7","022_10_7","ECC","10","7","7","ना गुलामगोळ इक घ्वाळागोळ मा होगतेला नोळदीन, जब कि शासक गुलामगोळ घाई पैदल नळोर. ");
INSERT INTO hoy_vpl VALUES ("EC10_8","022_10_8","ECC","10","8","8","जो दुसरा मंळसा अन्द साटी खॉदरा अगुळतान, आव खुद अदुर्दा बिद्दान. जो चोरी इन साटी दीवार वोडुतान, आऊक हाव कच्चीत. ");
INSERT INTO hoy_vpl VALUES ("EC10_9","022_10_9","ECC","10","9","9","जो सीमा अन्द दिवार इन कल्लगोळ इक सरकुसतान, आऊक कल्लगोळ देल चोट हत्तीत. जो सीमा अन्द हुल्लीगोळ इक कळदान, आऊक अऊर से खतरा ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("EC10_10","022_10_10","ECC","10","10","10","अगर कोळ्ली बोथळ ईरूल, अदिक मंळसा अदुर्द धार पैना माळबाळुल, रा आऊक उपयोग माळदुर दा येक्‍कुल ताकत हचोद बिद्दीत. लेकीन बुद्धि सफलता अन्द कुंजी आद. ");
INSERT INTO hoy_vpl VALUES ("EC10_11","022_10_11","ECC","10","11","11","अगर मंत्र से पयला हाव कच्चबुळुल, रा मंत्र फुकसावाळा से येन लाभ? ");
INSERT INTO hoy_vpl VALUES ("EC10_12","022_10_12","ECC","10","12","12","बुद्धिमान मंळसा अन्द बाय इन शब्द आऊन साटी दुसरा अन्द कृपा अन्द साधन आद. लेकीन मूर्ख मंळसा अन्द टुट्टी आऊन विनाश इन कारण आद. ");
INSERT INTO hoy_vpl VALUES ("EC10_13","022_10_13","ECC","10","13","13","मूर्ख उन बाय देल होळ्त शब्द शुरू टु आखरी ताका मूर्खता देल पुरा आगताव: आऊन मात इन अन्त दुष्टतापुर्ण पागलपन आगतद. ");
INSERT INTO hoy_vpl VALUES ("EC10_14","022_10_14","ECC","10","14","14","मूर्ख मंळसा ऊंद मात इन येढ्ढ मातगोळ माळतान, इदुरसाटी याऊ जानसालुन कि भविष्य दा येन आगोद आद; अदरी याव हेळ सकतान कि आऊन बाद्दा येन आदीत. ");
INSERT INTO hoy_vpl VALUES ("EC10_15","022_10_15","ECC","10","15","15","मूर्ख अन्द मेहनत आऊक थक्सतद, ईट कि आऊक वापसी इन साटी शहर इन हादी भी समसाल्द. ");
INSERT INTO hoy_vpl VALUES ("EC10_16","022_10_16","ECC","10","16","16","हे द्याश! धिक्कार आद नीनी, अगर नीन राजा अनुभव-हीन सेवक आन; अदिक अगर नीन सामन्त प्रांत: टु अच तिनोर-कुडोद दा जुटुस्तार. ");
INSERT INTO hoy_vpl VALUES ("EC10_17","022_10_17","ECC","10","17","17","हे द्याश, धन्य आय नी, अगर नीन राजा कुलीन वंशज आन, अदिक अगर नीन सामन्त निर्धारित समय मा तिनतार-कुडुतार, ताकत प्राप्त माळोर साटी, न कि मतवालापन इन साटी. ");
INSERT INTO hoy_vpl VALUES ("EC10_18","022_10_18","ECC","10","18","18","आलस इन कारण छत बिदोगतद, सुस्ती देल मान्ना चुनुसली हततद. ");
INSERT INTO hoy_vpl VALUES ("EC10_19","022_10_19","ECC","10","19","19","भोज आनंद इन साटी माळकु आगतद, अंगुर इन रास्सा कुडदुर देल जीवन आनन्दित आगतद. रूपये देल सप्पा येनारा प्राप्त आग सकतद. ");
INSERT INTO hoy_vpl VALUES ("EC10_20","022_10_20","ECC","10","20","20","तान मन दा भी राजा अक अपशब्द अनबाळी, अदिक न तान शयन कक्ष दा धनवान उक बुरा शब्द अनबाळी. आकाश इन पक्षी नीन शब्द ओतान, उळुसावाळा जीव-जन्तु खबर माळ बुट्टीत. ");
INSERT INTO hoy_vpl VALUES ("EC11_1","022_11_1","ECC","11","1","1","नेकी माळ अदिक दरिया दा हाक्क, हापाळ दिनगोळ बाद्दा भी नी प्रतिफल प्राप्त माळ सकत्या. ");
INSERT INTO hoy_vpl VALUES ("EC11_2","022_11_2","ECC","11","2","2","येळ, ईला येठ्ठ मंळसागोळ इक भाग कोळी, यतिकी नी जानसाल्द, कि ई पृथ्वी दा याग नीन मा विपत्ति होट बरूल. ");
INSERT INTO hoy_vpl VALUES ("EC11_3","022_11_3","ECC","11","3","3","अगर बादल नीर देल तुमकु आव, रा अव खुद भूमी मा बरसुस्याव. चाहे मार्र दक्षिण इन दी बिळुल, चाहे अव उत्तर इन दी बिळुल, अव या जागा मा बिदकु आव, अव अल्या बिदकु ईत्ताव. ");
INSERT INTO hoy_vpl VALUES ("EC11_4","022_11_4","ECC","11","4","4","जो किसान हवा अक ताक्सतान, आव बींजा बोऊस सकालुन, जो बादल इन अच विचार माळतान, आव फसल कडु सकालुन. ");
INSERT INTO hoy_vpl VALUES ("EC11_5","022_11_5","ECC","11","5","5","जसा नीव जानसालीर कि गर्भवती इन व्हाट्टा अन चिग्द दा जीव ह्यांग बिळतद, हांग अच नीव परमेश्वर उन क्याल्सागोळ इन सम्स सकालीर, जो सप्पा मुंदरी माळतान. ");
INSERT INTO hoy_vpl VALUES ("EC11_6","022_11_6","ECC","11","6","6","प्रांत: काल दा तान बींजा बोऊसोद शुरू माळी, अदिक द्यावगा भी तान कय रोक्स बाळी, अदिक क्याल्सा माळतेला ईरी, यतिकी नीव जानसालीर कि नीम इक याता क्याल्सा दा सफलता सिक्कीत ई क्याल्सा दा या आ क्याल्सा दा, या येढ्ढु दा. ");
INSERT INTO hoy_vpl VALUES ("EC11_7","022_11_7","ECC","11","7","7","सूर्य अन्द प्रकाश प्रिय हततद, बिसुल कण्णगोळ इक सुख पहुचुसतद. ");
INSERT INTO hoy_vpl VALUES ("EC11_8","022_11_8","ECC","11","8","8","अगर मंळसा हापाळ वर्ष ताका जीत्ता ईरतान रा आऊक चाहास पायजे कि आव तान उमर इन सप्पा वर्षगोळ दा जीवन इन आनन्द ताकोमुल, लेकीन आव याद ईटुल कि अंधकार इन दिन भी कम आगतीदील. अत: जो येनारा आगतद, अद व्यर्थ आद. ");
INSERT INTO hoy_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","ओ हारोदवा, तान जवानी तीम आनन्द मनुस, तान जवानी इन दिनगोळ दा तान दिल आनन्द देल तुम कोमुल. या हादी मा नीन दिल नीन इक ओईल, जो हादी नीन कण्णगोळ दा उचित हतुल, अदुर मा नळु. लेकीन ईद मात जान्स कोमुल, नीन सप्पा क्याल्सागोळ्द बारा दा स्पष्टीकरण इन साटी परमेश्वर नीन इक कटघरा दा नीदरूस्यान. ");
INSERT INTO hoy_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","ओ हारोदवा! तान दिल टु परेशानी इक तेगुबुळ, मय दा दुख आगगोळ बाळ; यतिकी नीन हारोदपण, अदिक बचपन येढ्ढु व्यर्थ आव. ");
INSERT INTO hoy_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","तान हारोदपन इन दिनगोळ दा तान सृष्टीकर्ता परमेश्वर उक याद ईट, ईलारा ई दिनगोळ बाद्दा अव दिन अदिक वर्ष बंदव याग नी ईद अंद्या, “ईग जीवन दा नान इक आनन्द सिकाल्द.” ");
INSERT INTO hoy_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","आ दिनगोळ दा नीन साटी सूर्य अदिक प्रकाश, चन्द्रमा अदिक तारा अन्धकारमय आगेदव. नीर तुमकु बादल भूमी मा माळ हुळकु वापस होदव. ");
INSERT INTO hoy_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","आ दिनगोळ दा नीन रक्षा माळावाळा नळ्गली कुरतान, ताकतवर भी झुकसेदार. संख्या दा कम आगोद कारण हल्ल आमली कचोद बिट्टबुटाव. खिळकी दा टु झाकसावाळा अन्द कण्णगोळ धुंधला बिदोदव. ");
INSERT INTO hoy_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","सळक इन दी तेरावाळा कीव बन्द आगेदव. चक्की पिसुसोद आवाज धीमा आगेदीत. नी चिड़ीया अन्द चहचहासोद देल भी जप देल येदोद्या. नीन सप्पा स्वर धीमा बिदोदाव. ");
INSERT INTO hoy_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","थ्वाळासा ऊंचाई येरदुर दा नीन इक अंज्क हत्तीत. गली-कुचगोळ देल नी आतंकित आद्या. बादाम इन मार्रगोळ दा पंखुळीगोळ खिलस्याव. टिड्डी भी रेंग्सकु नळुली कुरताव. लेकीन नीन अभिलाषागोळ सोतोदाव, अदिक नी तान शाश्वत निवास जागा अक प्रस्थान माळ्‍या. भाळा अन्द वर्लावाळेर-पिटसावाळेर लॉकुर गली-कुचगोळ इक घेर्स कोंडार. ");
INSERT INTO hoy_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","बेळ्ली इन तार मुरदोदीत, व्हान्ना अन्द प्याला मुरदोदीत. झरना अन हात्ती माळका वोळदोदीत, भाँय इन हात्ती जाळी मुरदोदीत. ");
INSERT INTO hoy_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","आग मुण्ण मुण्ण दा मिलुसेदीत, अदिक आत्मा परमेश्वर उन हात्ती होटोदीत, यारी आऊक प्रदान माळीदुन. ");
INSERT INTO hoy_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","सभा-उपदेशक ईद अनतान: सप्पा बेकार आद, सप्पा बेकार आद. बिना संकोच सप्पा येनारा बेकार आद! ");
INSERT INTO hoy_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","सभा-उपदेशक बुद्धिमान रा ईरोन, आव प्रजा अक ग्यान भी कल्सतेला ईत्तुन. अदिक ध्यान हचकु अदिक जाँच-परख माळकु हापाळ सा नीतिवचन क्रम देल ईटतोगोन. ");
INSERT INTO hoy_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","उपदेशक मनोहर शब्द ढुंढ्सदुन अदिक सच्चाई इन शिक्षा कोळावाळा वचन लिख्सदुन. ");
INSERT INTO hoy_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","“बुद्धिमान मंळसा अन्द कथन अंकुश इन घाई ईरताव. सभा अन्द मुखियागोळ्द द्वारा कोटकु ईव संकलित कथन, मजबूती देल ठोक्सकु खूटिगोळ घाई आद, यतिकी इंदुर दाता ऊंद मात्र ‘चरवाह’ आन. ");
INSERT INTO hoy_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","प्रिय चेला, इंदुर अलावा अन्य शिक्षागोळ देल सावधान ईरेतीर. हापाळ किताबगोळ्द रचना-क्याल्सा अन्द अन्त आगाल्द. हापाळ वाचुसदुर देल मय थकसेगतद.” ");
INSERT INTO hoy_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","जो येनारा नीव केळदीर, अदुर्द सार ईद आद : नीव परमेश्वर उन अंज्क ईटी, अदिक आऊन आग्यागोळ्द पालन माळी; यतिकी मंळसा अन्द पुरा धर्म ईदा हुन. ");
INSERT INTO hoy_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","परमेश्वर मंळसा अन्द हर ऊंद कर्म अक, आऊन सप्पा होचकु मातगोळ इक, चाहे अव भला आगुल या बुरा, न्याय इन समय प्रस्तुत माळ्यान.");
INSERT INTO hoy_vpl VALUES ("EK1_1","027_1_1","EZK","1","1","1","तीसवा वर्ष इन चौथा तिंगुळ इन पाचवा दिशी, ना बन्दीगोळ बीच दा कबार गांगा अन किनारा मा ईरीन, आग स्वर्ग खुलसेत, अदिक ना परमेश्वर उन दर्शन नोळदीन. ");
INSERT INTO hoy_vpl VALUES ("EK1_2","027_1_2","EZK","1","2","2","यहोयाकीन राजा अन गुलामी इन पाचवा वर्ष इन चौथा तिंगुळ इन पाचवा दिशी, ");
INSERT INTO hoy_vpl VALUES ("EK1_3","027_1_3","EZK","1","3","3","कसदी अन द्याश दा कबार गांगा अन किनारा मा, यहोवा अन वचन बूजी इन पार यहेजकेल याजक उन हाती पोहचुस्त; अदिक यहोवा अन सामर्थ आऊन मा प्रगट आत. ");
INSERT INTO hoy_vpl VALUES ("EK1_4","027_1_4","EZK","1","4","4","याग ना नोळली कुरतीन, रा येन नोळतीन कि उत्तर दिशा टु धोळ्द बादल, अदिक लहरूसतेला बेक्की सांगुळ धोळ्द आंधी बरेत्याद, अदिक बादल इन नाकु दी ऊजुळ अदिक बेक्की इन बीचो-बीच टु चमकुस्द पीतल घाई येनारा कांळ्सतद. ");
INSERT INTO hoy_vpl VALUES ("EK1_5","027_1_5","EZK","1","5","5","अदिक अदुर बीच दा टु नाक जीवधारीगोळ घाई येनारा होट्टव. आंदुर रूप मंळसागोळ घाई ईरोद, ");
INSERT INTO hoy_vpl VALUES ("EK1_6","027_1_6","EZK","1","6","6","लेकीन आंदुर दा टु हर ऊंद उन नाक नाक बाय अदिक नाक नाक पंख ईरव. ");
INSERT INTO hoy_vpl VALUES ("EK1_7","027_1_7","EZK","1","7","7","आंदुर काल सीधा ईरव, अदिक आंदुर काल इन तलवा पाड्डा अन खुरगोळ घाई ईरव, अदिक अव चमकुसदव पीतल इन घाई ईरव. ");
INSERT INTO hoy_vpl VALUES ("EK1_8","027_1_8","EZK","1","8","8","अऊर नाकु दी पंख इन ल्यालमा, मंळसागोळ घाई इच कय ईरव, नाकु प्राणी गोळोव चेहरा अदिक पंख ई प्रकार ईरव: ");
INSERT INTO hoy_vpl VALUES ("EK1_9","027_1_9","EZK","1","9","9","आंदुरव पंख आबुर दाबुर से परस्पर जुळ्सकु ईरव, आंदुर नळाहोती तान कण्णगोळ दा सीधा नळोर, अदिक तिर्गोव ईला. ");
INSERT INTO hoy_vpl VALUES ("EK1_10","027_1_10","EZK","1","10","10","नाकु उन चेहरा अन रूप ई प्रकार ईरोद: सप्पा प्राणी इन चेहरा मुंदु टु मंळसा अन घाई ईरोद, ऊजवा दी हुल्ल इन घाई ईरोद, अदिक डाक्या दि वस्ता अन अदिक हिंदळोद दी गिधाळ घाई ईरव. ");
INSERT INTO hoy_vpl VALUES ("EK1_11","027_1_11","EZK","1","11","11","आंदुर चेहरा हींग अच ईरव. आंदुर बाय अदिक पंख म्याकुच इन दी अलग अलग ईरव, हर ऊंद जीवधारी इन येढ्ढ येढ्ढ पंख ईरव, जो आबुर दाबुर इन पंखगोळ से मीलुसकु ईरोर, अदिक येढ्ढ येढ्ढ पंखगोळ से आंदुर शरीर ढाप्सकु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EK1_12","027_1_12","EZK","1","12","12","अव सीधा तान तान मुंद अच नळुतोगोर; येल आत्मा होगोद चाहसोद, अव आतल्या होगोव, अदिक नळुतेला तिर्गव ईला. ");
INSERT INTO hoy_vpl VALUES ("EK1_13","027_1_13","EZK","1","13","13","जीवधारीगोळ रूप अंगारगोळ अदिक होततेला मशालगोळ घाई कांळ्सव, अदिक अद बेक्की जीवधारीगोळ बीच ईत्त आत्त नळुत वयाळ्त हापाळ ऊजोळ कोळतेला ईत्त; अदिक आ बेक्की देल बिजली होळतोगोद. ");
INSERT INTO hoy_vpl VALUES ("EK1_14","027_1_14","EZK","1","14","14","जीवधारीगोळ्द नळोद-वयाळोद बिजली घाई ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EK1_15","027_1_15","EZK","1","15","15","याग ना जीवधारीगोळ इक नोळीन, रा येन नोळदीन कि जागा मा आंदुर हाती नाकु बायगोळ गिनती इन अनुसार, ऊंद ऊंद चक्का ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EK1_16","027_1_16","EZK","1","16","16","चक्कागोळ रूप अदिक बनावट स्वर्णमणी इन घाई ईरोद, अदिक नाकु उन ऊंदा रूप ईरोद; अऊर रूप अदिक बनावट हिंग ईरोद ह्यांग ऊंद चक्का अन बीच दुसरा चक्का आगुल. ");
INSERT INTO hoy_vpl VALUES ("EK1_17","027_1_17","EZK","1","17","17","नळाहोती अव तान नाकु दी नळु सकोव, अदिक नळदुर दा तिर्गोव ईला. ");
INSERT INTO hoy_vpl VALUES ("EK1_18","027_1_18","EZK","1","18","18","आ नाकु चक्का अन घेरा हापाळ धोड्डेव अदिक अंज्क बरापरी ईरव, अदिक अऊर घेरा दा नाकु दी कण्ण अच कण्णगोळ तुमकु ईरव. ");
INSERT INTO hoy_vpl VALUES ("EK1_19","027_1_19","EZK","1","19","19","याग जीवधारी नळु तोगोव, आग चक्कागोळ भी अऊर सांगुळ नळुतोगोव; अदिक याग जीवधारी जमीन मा टु येळ तोगोव, आग चक्का भी येळ तोगोव. ");
INSERT INTO hoy_vpl VALUES ("EK1_20","027_1_20","EZK","1","20","20","यात आत्मा होगोद चाहसोद, आत्त अच अव होगोव, अदिक चक्का जीवधारीगोळ सांगुळ यळतोगोव; यतिकी अऊर आत्मा चक्का दा ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EK1_21","027_1_21","EZK","1","21","21","याग अव नळुतोगोव आग ईव भी नळुतोगोव; अदिक याग याग अव नीदरव आग ईव भी निदरव; अदिक याग अव जमीन मा टु येळतोगोव आग चक्का भी अऊर सांगुळ येळतोगोव; यतिकी जीवधारीगोळ आत्मा चक्का दा ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EK1_22","027_1_22","EZK","1","22","22","जीवधारीगोळ्द ताल्ला अन म्याकुच आकाश- मण्डल घाई- येनारा ईरोद जो बर्फ इन घाई भयानक रीती देल चमकुसोद, अदिक अद आंदुर ताल्लागोळ म्याकुच फैलुसकु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EK1_23","027_1_23","EZK","1","23","23","आकाश मण्डल इन ल्यालमा, अऊर पंख आबुर दाबुर दी सीधा फैलुसकु ईरव; अदिक हर ऊंद जीवधारी इन येढ्‌ढ येढ्ढ अदिक भी पंखगोळ ईरव यदुर देल अऊर शरीर मुचकु ईरव. ");
INSERT INTO hoy_vpl VALUES ("EK1_24","027_1_24","EZK","1","24","24","अऊर नळाहोती अऊर पंखगोळ्द फळफळाहट इन भास नानी हापाळ नीर, या सर्वशक्तिमान इन वाणी, या सेना अन हलचल इन घाई केळ बरोद; अदिक याग अव नीदुर तोगोव, आग तान पंख लटकुस बुळोव. ");
INSERT INTO hoy_vpl VALUES ("EK1_25","027_1_25","EZK","1","25","25","बाक अऊर ताल्ला अन म्याकुच जो आकाश मण्डल ईरोद, अदुर म्याकुच टु ऊंद शब्द केळ बरोद; अदिक याग अव नीदरव, आग तान पंखगोळ लटकुस बुळव. ");
INSERT INTO hoy_vpl VALUES ("EK1_26","027_1_26","EZK","1","26","26","जो आकाश मण्डल अऊर ताल्ला अन म्याकुच ईरोद, अदुर म्याकुच मान्सी येनारा नीलमणि इन घाई बन्सकु सिंहासन ईरोद; ई सिंहासन इन म्याकुच मंळसा अन घाई यावारा कांळ्सोन. ");
INSERT INTO hoy_vpl VALUES ("EK1_27","027_1_27","EZK","1","27","27","अऊर नेळु टु हुडुकु म्याकुच इन दी नानी मान्सी झलकुस्द पीतल इन घाई कांळ्सत, अदिक अदुर बुळ्क अदिक नाकु दी बेक्की घाई कांळ्सोद; बाक आ मंळसा अन नेळु टु हुडुकु ल्यालमा भी नानी बेक्की इन घाई कांळ्सोद; अदिक अदुर नाकु दी ऊजुळ ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EK1_28","027_1_28","EZK","1","28","28","ह्यांग माळ बरा दिशी बादल दा धनुष कांळ्सकु बीळतद, हांग अच नाकु दीकळोद ऊजुळ कांळ्स तोगोद. यहोवा अन रूप इन तेज हिंगा ईरोद. अदरी नोळकु, ना बाय इन भार देल बिद्दीन, आग ना ऊंद शब्द केळदीन ह्यांग कि यावारा मातगोळ माळतान. ");
INSERT INTO hoy_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","1","आव नान से अंदुन, “हे मंळसा अन पार, तान काल इन भार नीदुर, अदिक ना नीन से मात माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EK2_2","027_2_2","EZK","2","2","2","ह्यांग आव नान से ईद अंदुन, आग आत्मा नान दा समुस्कु नानी कालगोळ बल नीदरुस्त; अदिक जो नान से मातगोळ माळतोगोन ना आऊन केळदीन. ");
INSERT INTO hoy_vpl VALUES ("EK2_3","027_2_3","EZK","2","3","3","आव नान से अंदुन, “हे मंळसा अन सन्तान, ना नीनी इस्त्राएलगोळ हाती मतलब बलवा माळावाळा राज्य अन हाती कळुतीन, यार नान विरूद्‍ध बलवा माळ्यार; आंदुर पुरखा अदिक आंदुर भी ईंद इन दिन ताका ना विरूद्‍ध अपराध माळतेला बंदार. ");
INSERT INTO hoy_vpl VALUES ("EK2_4","027_2_4","EZK","2","4","4","ई पीढ़ी इन लॉकुर यार हाती ना नीनी कळुतीन, आंदुर निर्लज अदिक जीद्दी आर; ");
INSERT INTO hoy_vpl VALUES ("EK2_5","027_2_5","EZK","2","5","5","अदिक नी आंदुर से अनेत, ‘प्रभु यहोवा ईद अनतान,’ ईदुर देल आंदुर, जो बलवा माळावाळेर घरानादोर आर, बाक आंदुर केळुल या केळ बाळुल, तरी भी आंदुर ईट जान्स कोंडार कि नाम न्याड्या दा ऊंद भविष्यवक्ता प्रगट आग्यान.” ");
INSERT INTO hoy_vpl VALUES ("EK2_6","027_2_6","EZK","2","6","6","हे मंळसा अन सन्तान, नी आंदुर से अंजबाळेत; बाक नीनी मुळ्लगोळ, ऊँट कटारगोळ अदिक चेळगोळ बीच दा भी ईरोद बीद्दीत, तरी भी आंदुर वचनगोळ से अंज बाळेत, अदिक न आंदुर बाय नोळकु नीन मन कच्चा आगुल. ");
INSERT INTO hoy_vpl VALUES ("EK2_7","027_2_7","EZK","2","7","7","ईदुरसाटी बाक आंदुर केळुल या केळबाळुल; तरी भी नी नान वचन आंदुर से अनेत, आंदुर रा हापाळ झगळेलु आर. ");
INSERT INTO hoy_vpl VALUES ("EK2_8","027_2_8","EZK","2","8","8","“लेकीन हे मंळसागोळ सन्तान, जो ना नीन से अनतीन, अदरी नी केळकोम, आ विद्रोही घराना अन घाई नी भी विद्रोही आगबाळेत, जो ना नीनी कोळतीन, अदरी बाय खोल्सकु तीनकोम.” ");
INSERT INTO hoy_vpl VALUES ("EK2_9","027_2_9","EZK","2","9","9","आग ना दृष्टी माळदीन अदिक येन नोळदीन, कि नान दी ऊंद कय वाळुसकु आद अदिक अदुर दा ऊंद किताब आद. ");
INSERT INTO hoy_vpl VALUES ("EK2_10","027_2_10","EZK","2","10","10","अदरी आव नान मुंद खोल्सकु फैलुसदुन, अदिक अद येढ्ढु दी लिख्सकु ईरोद; अदिक जो अदुर दा लिख्सकु ईरोद, अव विलाप अदिक शोक अदिक दुख इन वचन ईरव. ");
INSERT INTO hoy_vpl VALUES ("EK3_1","027_3_1","EZK","3","1","1","आग आव आन से अंदुन, “हे मंळसा अन सन्तान, जो नीनी सिक्याद अदरी तीनकोम; मतलब ई किताब इक तीन, आग होगकु इस्त्राएल उन घराना से मात माळ.” ");
INSERT INTO hoy_vpl VALUES ("EK3_2","027_3_2","EZK","3","2","2","इदुरसाटी ना बाय खोल्सदीन अदिक आव अद किताब नानी तिन्सदुन. ");
INSERT INTO hoy_vpl VALUES ("EK3_3","027_3_3","EZK","3","3","3","आग आव नान से अंदुन, “हे मंळसा अन सन्तान, ईद किताब जो ना नीनी कोळतीन अदरी पचुसकोम, अदिक व्हाट्टा ईदुर देल तुम कोम.” अत: ना अदरी तीन कोंडीन; अदिक नान बाय दा अद शयद इन घाई सय हत. ");
INSERT INTO hoy_vpl VALUES ("EK3_4","027_3_4","EZK","3","4","4","बाक आव नान से अंदुन, “हे मंळसा अन सन्तान, नी इस्त्राएल उन घराना अन हाती होगकु नानव वचन केळ्स. ");
INSERT INTO hoy_vpl VALUES ("EK3_5","027_3_5","EZK","3","5","5","यतिकी नी यातोदारा अनोखा बोली या कठिन भाषावाळा राज्य अन हाती कळुकु आगाल, लेकीन इस्त्राएल अच उन घराना अन हाती कळुकु आगत्या. ");
INSERT INTO hoy_vpl VALUES ("EK3_6","027_3_6","EZK","3","6","6","नीनी ईत्ता लॉकुर इन हाती कळालीन जो अनोखा बोली माताळतार या कठिन भाषा माताळावाळेर लॉकुर आर, यार्द भाषा नी समसाल. अगर ना नीनी ईत्ता लॉकुर हाती इच कळाईदीन, रा बिना सन्देह आंदुर नान मात केळायदुर. ");
INSERT INTO hoy_vpl VALUES ("EK3_7","027_3_7","EZK","3","7","7","लेकीन इस्त्राएल उन घरानावाळेर नीन केळोर से इनकार माळ्यार; आंदुर नान भी केळोर से इनकार माळतार; यतिकी इस्त्राएल उन सारा घराना हेकळ अदिक कठोर मन इन आद. ");
INSERT INTO hoy_vpl VALUES ("EK3_8","027_3_8","EZK","3","8","8","नोळ, ना नीन बाय इक आंदुर बाय इन मुंद, अदिक नीन मस्तक इक आंदुर मस्तक इन मुंद, मजबुत माळ कोमतीन. ");
INSERT INTO hoy_vpl VALUES ("EK3_9","027_3_9","EZK","3","9","9","ना नीन मन इक चकमक कल्ल से येक्कुल कठोर माळ कोंडीन. आंदुर विद्रोही कुल इन सन्तान उर. नी आंदुर तीखा नजर देल अंजबाळेत अदिक न हतास आगेत,” ");
INSERT INTO hoy_vpl VALUES ("EK3_10","027_3_10","EZK","3","10","10","बाक आव नान से अंदुन, “हे मंळसा अन सन्तान, यास वचन ना नीन से अनाईन, अव सप्पा दिल दा ईट अदिक किवगोळ देल केळ. ");
INSERT INTO hoy_vpl VALUES ("EK3_11","027_3_11","EZK","3","11","11","अदिक आ बन्दीगोळ हाती होगकु, जो नीन राज्य अन वार्टुर हुर, आंदुर से मातगोळ माळेत अदिक अनेत, ‘प्रभु यहोवा हींग अनतान,’ बाक आंदुर केळुल या केळबाळुल.” ");
INSERT INTO hoy_vpl VALUES ("EK3_12","027_3_12","EZK","3","12","12","आग परमेश्वर उन आत्मा नानी म्याकुच नेगुत, अदिक ना तान हींद धोळ्द घळघळाहट इन सांगुळ ऊंद शब्द केळदीन: आव अंदुन, “परमेश्वर उन महिमा आशीष इन आद.” ");
INSERT INTO hoy_vpl VALUES ("EK3_13","027_3_13","EZK","3","13","13","अदिक अदुर सांगुळ अच आ जीवधारीगोळ पंखगोळ्द शब्द जो आबुर दाबुर से हत तोगोव, अदिक आंदुर सांगुळ इन चक्कागोळ्द शब्द अदिक ऊंद धोळ्द अच घळघळाहट केळ बत्त. ");
INSERT INTO hoy_vpl VALUES ("EK3_14","027_3_14","EZK","3","14","14","आग आत्मा नानी नेगुकु वोईत, अदिक ना कठिन दुख देल तुमकु, अदिक मन दा होततेला होटोदीन; अदिक यहोवा अन शक्ती नान दा प्रबल ईरोद; ");
INSERT INTO hoy_vpl VALUES ("EK3_15","027_3_15","EZK","3","15","15","अदिक आ बन्दीगोळ हाती बंदीन जो कबार गांगा अन तट मा तेलाबीब दा ईरतोगोर. अदिक अल येळ दिन ताका आंदुर बीच व्याकुल आगकु कुर्तकु ईत्तीन. ");
INSERT INTO hoy_vpl VALUES ("EK3_16","027_3_16","EZK","3","16","16","येळ दिन इन आगदुर बाद्दा यहोवा अन ईद वचन नान हाती पोहचुस्त, ");
INSERT INTO hoy_vpl VALUES ("EK3_17","027_3_17","EZK","3","17","17","“हे मंळसागोळ सन्तान, ना नीनी इस्त्राएल उन घराना अन साटी पहरेदार नियुक्त माळीन; नी नान बाय इन मात केळकु, आंदरी नान दी टु चेतावनी कोळेत. ");
INSERT INTO hoy_vpl VALUES ("EK3_18","027_3_18","EZK","3","18","18","याग ना दुष्ट से अनाईन, ‘नी सही दा सोत्या,’ अदिक अगर नी आऊक समझुसतीदील, अदिक न दुष्ट से हिंग मातगोळ अनेत कि आव समसुल अदिक तान दुष्ट हादी बिटकु जीत्ता ईरूल, रा आव दुष्ट तान अधर्म दा फसुसकु सोत्तान, लेकीन आऊन खुन इन लेखा ना नीन से अच ताकोमाईन. ");
INSERT INTO hoy_vpl VALUES ("EK3_19","027_3_19","EZK","3","19","19","लेकीन अगर नी दुष्ट उक चितुसत्या, अदिक आव दुष्टता अदिक दुष्ट हादी देल तीर्गालुन, रा आव रा तान अधर्म दा फसुसकु सोतोदान; लेकीन नी तान तान इक ऊळस्या.” ");
INSERT INTO hoy_vpl VALUES ("EK3_20","027_3_20","EZK","3","20","20","“बाक याग धर्मी मंळसा तान धर्म देल तिर्गकु कुटिल क्याल्सा माळली कुरतान, अदिक ना आऊन मुंद ठोकर ईटाईन, रा आव सोतोदान, यतिकी नी आऊक समझुसीदील, इदुरसाटी आव तान पाप दा फसुसकु सोत्तान; अदिक धर्म इन कर्म आव माळ्यान, अऊर्द सुधी ताकोमकु आगतीदील, लेकीन आऊन खुन इन लेखा ना नीन अच ताकोमाईन. ");
INSERT INTO hoy_vpl VALUES ("EK3_21","027_3_21","EZK","3","21","21","लेकीन धर्मी इक हिंग अनकु समझुस्या, कि आव पाप माळबाळुल, अदिक आव से ऊळदान, रा आव आ चितौनी इक ग्रहण माळा कारण सही दा जीत्ता ईत्तान, अदिक नी तान तान इक ऊळस्या.” ");
INSERT INTO hoy_vpl VALUES ("EK3_22","027_3_22","EZK","3","22","22","बाक यहोवा अन सामर्थ अल्या नान मा प्रगट आत, अदिक आव नान से अंदुन, “येदकु मैदान दा होग; अदिक अल नीन से मातगोळ हेळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EK3_23","027_3_23","EZK","3","23","23","आग ना येदकु मैदान दा होदीन, अदिक अल येन नोळदीन, कि यहोवा अन तेज घाई नानी कबार गांगा अन तट मा, हांग अच ईल भी कांळ्सकु बिळतद, अदिक ना बाय इन भार देल बिदोदीन. ");
INSERT INTO hoy_vpl VALUES ("EK3_24","027_3_24","EZK","3","24","24","आग आत्मा नान दा समुस्कु नानी काल इन भार देल निदरूस्त; बाक आव नान से अनली कुरतुन, “होग तान मान्ना अन बुळ्क दरवाजा बंद माळकु कुर्तकु ईर. ");
INSERT INTO hoy_vpl VALUES ("EK3_25","027_3_25","EZK","3","25","25","हे मंळसा अन सन्तान, नोळ, आ लॉकुर नीनी जाळी देल जकळुसकु कटकु ईट्यार, अदिक नी होटकु आंदुर बीच होग सकतीदील. ");
INSERT INTO hoy_vpl VALUES ("EK3_26","027_3_26","EZK","3","26","26","ना नीन ल्यालग्या नीन ताळु देल हचाईन; यदुर देल नी मौन ईतकु आंदुर दनकुसावाळा ईला, यतिकी आंदुर विद्रोही घरानानोर उर. ");
INSERT INTO hoy_vpl VALUES ("EK3_27","027_3_27","EZK","3","27","27","लेकीन याग याग ना नीन से मातगोळ माळाईन, आग आग नीन बाय इक खोलसाईन, अदिक नी आंदुर से हिंग अनेत, ‘प्रभु यहोवा हींग अनतान,’ जो केळतान आव केळ कोमुल अदिक जो केळालुन आव केळबाळुल, आंदुर रा विद्रोही घरानानोर अच उर.” ");
INSERT INTO hoy_vpl VALUES ("EK4_1","027_4_1","EZK","4","1","1","“हे मंळसा अन सन्तान, नी ऊंद ईटा हुडु अदिक अदरी तान मुंद ईटकु अदुर मा ऊंद नगर, मतलब यरूशलेम इन ऊंद चित्र तेगु; ");
INSERT INTO hoy_vpl VALUES ("EK4_2","027_4_2","EZK","4","2","2","आग अदरी घेर्स मतलब अदुर विरूद्‍ध किला माळ अदिक अदुर मुंद नालीगोळ कट; अदिक छावनी हाक, अदिक अदुर नाकु दी युध्द अन यंत्र हच. ");
INSERT INTO hoy_vpl VALUES ("EK4_3","027_4_3","EZK","4","3","3","आग नी लोहा अन तावा हुडुकु अदरी लोहा अन शहरपनाह मान्सकु तान अदिक आ नगर इन बीच नीदरूस, आग तान बाय आऊन मुंद माळकु अदुर घेराबंदी माळ, ई रीती देल; नी अदरी घेर्सकु ईटेत. ईद इस्त्राएल उन घराना अन साटी चिन्ह ठहरूसीत.” ");
INSERT INTO hoy_vpl VALUES ("EK4_4","027_4_4","EZK","4","4","4","“बाक नी ऊजवा कळ ताकोमकु इस्त्राएल उन घराना अन अधर्म तान म्याकुच ईट, यतिकी यास दिन नी ऊजवा कळ ताकोमकु मिंगतेला ईत्या, आस दिन ताका आ लॉकुर इन अधर्म इन भार सहुसतेला ईत्या. ");
INSERT INTO hoy_vpl VALUES ("EK4_5","027_4_5","EZK","4","5","5","ना आंदुर साटी अधर्म इन वर्षगोळ तुल्य नीन साटी दिनगोळ ठहरूसीन, मतलब मुर सौ नब्बे दिन; आस दिन ताका नी इस्त्राएल इन घराना अन अधर्म इन भार सहुसतेला ईर. ");
INSERT INTO hoy_vpl VALUES ("EK4_6","027_4_6","EZK","4","6","6","याग ईस दिन पुरा आगेदव, आग नी डाक्या कळ मींगकु यहूदा अन घराना अन अधर्म इन भार सहुस कोमेत; ना आंदुर साटी भी अदिक नीन साटी ऊंद वर्ष इन बदला ऊंद दिन मतलब चालीस दीन ठहरूसीन.” ");
INSERT INTO hoy_vpl VALUES ("EK4_7","027_4_7","EZK","4","7","7","नी यरूशलेम इक घेर्सोर साटी बाह तेगुकु तान बाय आत्त माळकु अदुर विरूद्‍ध भविष्यवाणी माळेत. ");
INSERT INTO hoy_vpl VALUES ("EK4_8","027_4_8","EZK","4","8","8","नोळ, ना नीनी जाळीगोळ देल जकळुसाईन, अदिक यागासताका अदुर घेर्सोद इन दिन पुरा आगाल, आगासताका नी कळ ताकोम सकतीदील. ");
INSERT INTO hoy_vpl VALUES ("EK4_9","027_4_9","EZK","4","9","9","“नी गोदी, जौ, सेम, मसूर, बाजरा, अदिक कठिया गोदी, हुडुकु ऊंद बरतन दा ईटकु अऊर देल रोट्टी माळ तोगेत. यास दिन नी कळ मा मींगकु ईत्या, आस मतलब मुर सौ नब्बे दिन ताका अदरी तीन तोगेत. ");
INSERT INTO hoy_vpl VALUES ("EK4_10","027_4_10","EZK","4","10","10","जो भोजन नी तिंद्या, अदरी आळु आळुकु तिनेत, मतलब रोज येढ्ढ सौ तीस ग्राम तीम तिन तोगेत, अदिक अदरी समय समय मा तिनेत. ");
INSERT INTO hoy_vpl VALUES ("EK4_11","027_4_11","EZK","4","11","11","नीर भी आळुकु कुडु तोगेत, मतलब हर दिशी येढ्ढ गिलास कुडेत; अदिक नी नीर निश्चित समय मा कुडेत. ");
INSERT INTO hoy_vpl VALUES ("EK4_12","027_4_12","EZK","4","12","12","तान भोजन जौ इन रोट्टीगोळ घाई माळकु तीन तोगेत, अदिक अदरी मंळसा अन ल्यांडा अन कुळ्लगोळ मा आंदुर नोळतेला बनुस तोगेत.” ");
INSERT INTO hoy_vpl VALUES ("EK4_13","027_4_13","EZK","4","13","13","बाक यहोवा अंदुन, “ईदा प्रकार देल इस्त्राएल आ राज्यगोळ बीच तान तान रोट्टी अशुध्दता देल तिंदार, यल ना आंदरी जबरदस्ती पोहचुसाईन.” ");
INSERT INTO hoy_vpl VALUES ("EK4_14","027_4_14","EZK","4","14","14","आग ना अंदीन, “हाय, यहोवा परमेश्वर नोळ, नान मन कभी अशुध्द आगीदील, अदिक ना बचपन टु हुडुकु ईगासताका खुद देल सोतकु या बीचकु आग्याद जनावर इन मास तिंदीदील, अदिक न यातोदु प्रकार इन बेकार मास नान बाय दा कभी होग्याद.” ");
INSERT INTO hoy_vpl VALUES ("EK4_15","027_4_15","EZK","4","15","15","आग आव नान से अंदुन, “नोळ, ना नीन साटी मंळसा अन ल्यांडा अन बदला सेंगळी ठहरूसीन, अदिक अदुर देला नी तान रोट्टी माळेत.” ");
INSERT INTO hoy_vpl VALUES ("EK4_16","027_4_16","EZK","4","16","16","बाक आव नान से अंदुन, “हे मंळसा अन सन्तान, नोळ, ना यरूशलेम दा अन्नरूपी आधार इक दुर माळाईन; ईदुरसाटी अलेर लॉकुर आळु आळुकु अदिक चिन्ता माळ माळकु रोट्टी तिनतोदार; अदिक आळु आळुकु अदिक दुखी आग आगकु नीर कुडुतोदार. ");
INSERT INTO hoy_vpl VALUES ("EK4_17","027_4_17","EZK","4","17","17","अदिक ईदुर देल आंदरी नीर अदिक रोट्टी इन कमी आदीत; अदिक आंदुर सप्पा च्या सप्पा घबरूस्यार, अदिक तान अधर्म दा फसुसकु वंळ्गेदार.” ");
INSERT INTO hoy_vpl VALUES ("EK5_1","027_5_1","EZK","5","1","1","“हे मंळसा अन सन्तान, ऊंद पन्यार तलवार हुडु, अदिक अदरी भाली इन उस्तरा अन घाई क्याल्सा दा तनकु तान ताल्ला अदिक दाळी इन चुट्टी तेगुकोम, आग तौलुसोद काटा हुडुकु चुट्टीगोळ्द भाग माळ. ");
INSERT INTO hoy_vpl VALUES ("EK5_2","027_5_2","EZK","5","2","2","याग नगर इन घेर्सव दिन पुरा आदव, आग नगर इन बुळ्क ऊंद तिहाई बेक्की दा हाक्कु होताकेत, अदिक ऊंद तिहाई हुडुकु नाकु दी तलवार देल बडेत; अदिक ऊंद तिहाई इक हवा दा ऊळुसेत, अदिक ना तलवार जेडुकु अदुर हिंद नळसाईन. ");
INSERT INTO hoy_vpl VALUES ("EK5_3","027_5_3","EZK","5","3","3","आग ईऊर दा टु थ्वाळासा चुट्टी हुडुकु कपळा अन क्वाना दा कटेत. ");
INSERT INTO hoy_vpl VALUES ("EK5_4","027_5_4","EZK","5","4","4","बाक ईऊर दा टु भी थ्वाळासा हुडुकु बेक्की इन बीच हाकेत कि अव बेक्की दा होत्तेगुल, आग अदुर दा टु ऊंद चिंगारी भळकुसकु इस्त्राएल इन सप्पा घराना दा फैलुसेदीत.” ");
INSERT INTO hoy_vpl VALUES ("EK5_5","027_5_5","EZK","5","5","5","“प्रभु यहोवा ईद अनतान: यरूशलेम हींग अच आद; ना अदरी अन्य राज्यगोळ बीच दा ठहरूसीन, अदिक अद नाकु दी द्याशगोळ से घेर्सकु आद. ");
INSERT INTO hoy_vpl VALUES ("EK5_6","027_5_6","EZK","5","6","6","आव नान नियमगोळ खिलाप क्याल्सा माळकु अन्य राज्यगोळ से येक्कुल दुष्टता माळ्यान, अदिक नान विधीगोळ खिलाप नाकु दिकळोर द्याश इन लॉकुर से येक्कुल बुराई माळ्यार; यतिकी आंदुर नान नियमगोळी बेकार जान्सदुर, अदिक आंदुर नान विधीगोळ मा नळदिदील. ");
INSERT INTO hoy_vpl VALUES ("EK5_7","027_5_7","EZK","5","7","7","ई कारण प्रभु यहोवा ईद अनतान: नीव लॉकुर जो तान नाकु दिकळोर राज्यगोळ से येक्कुल हुल्लळ माळतेला, अदिक न नान विधीगोळ मा नळुतार, न नान नियमगोळी मान्सतार अदिक तान नाकु दिकळोर राज्यगोळ नियमगोळ अनुसार भी माळीदिल, ");
INSERT INTO hoy_vpl VALUES ("EK5_8","027_5_8","EZK","5","8","8","ई कारण प्रभु यहोवा ईद अनतान: नोळ, ना खुद नीन खिलाप आईन; अदिक अन्य राज्यगोळ नोळतेला ना नीन बीच न्याय इन क्याल्सा माळाईन. ");
INSERT INTO hoy_vpl VALUES ("EK5_9","027_5_9","EZK","5","9","9","नीनव सप्पा घिनोना क्याल्सा अन कारण ना नीन बीच हींग माळाईन, ह्यांग ईगासताका माळीदिल, अदिक न भविष्य दा बाक माळतीदील. ");
INSERT INTO hoy_vpl VALUES ("EK5_10","027_5_10","EZK","5","10","10","ईदुरसाटी नीन न्याड्या चिकोर तान तान आप्प उन, अदिक आप्प तान तान चिकोर्द मास तिंदार; अदिक नीनी इक दण्ड कोळाईन, अदिक जो लॉकुर ऊळ्दोदार, आंदरी ना नाकु क्वानागोळ दा बगरूस बुळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EK5_11","027_5_11","EZK","5","11","11","ईदुरसाटी प्रभु यहोवा अन ईद वाणी आद, कि नान जीवन इन किर्या, ईदुरसाटी कि नी नान पवित्र जागा अक तान सप्पा घिनोना मुर्तीगोळ अदिक सप्पा घिनोना क्याल्सा देल अशुध्द माळ्या, ना नीनी घटुसाईन, अदिक नीन मा दया अन नजर माळतीदील, अदिक नीन मा येनु भी तरस तिनतीदील. ");
INSERT INTO hoy_vpl VALUES ("EK5_12","027_5_12","EZK","5","12","12","नींद आबादी इन ऊंद तिहाई रा महामारी देल सोत्तीत, अदिक नीन बीच हसु देल सोतकु मिटुसेदीत; ऊंद तिहाई नीन आस पास तलवार देल कोंदकु आदीत; अदिक ऊंद तिहाई इक ना नाकु दी तितर बितर माळाईन अदिक तलवार जेडुकु आंदुर हींद नळसाईन. ");
INSERT INTO hoy_vpl VALUES ("EK5_13","027_5_13","EZK","5","13","13","ई प्रकार देल नान क्रोध शांत आदीत, अदिक तान जलजलाहट आंदुर मा पुरा रीती देल भळकुसकु ना शांती पाऊसाईन; अदिक याग ना तान जलजलाहट आंदुर पुरा रीती देल भळकुस बुळाईन, आग आंदुर जान्स कोंडार कि ना यहोवा अच जलन दा बंदकु ईद अंदीन. ");
INSERT INTO hoy_vpl VALUES ("EK5_14","027_5_14","EZK","5","14","14","ना नीनी नीन नाकु दीकळोर राज्यगोळ बीच, सप्पा होगा-बरावाळेर नोळतेला नाश माळाईन, अदिक नीन बदनामी माळसुसाईन. ");
INSERT INTO hoy_vpl VALUES ("EK5_15","027_5_15","EZK","5","15","15","“ईदुरसाटी याग ना नीन इक कोप अदिक जलजलाहट अदिक हापाळ डाट फटकार सांगुळ दण्ड कोळाईन, आग नीन नाकु दीकळोर राज्यगोळ मुंद नामधराई, मज्याक, सजा अदिक विस्मय आदीत, यतिकी ना यहोवा ईद अंदीन. ");
INSERT INTO hoy_vpl VALUES ("EK5_16","027_5_16","EZK","5","16","16","ईद आ समय आदीत, याग ना आ लॉकुर्द नाश माळोर साटी नीम मा अकाल इनव घातक तीर नळ्सकु, नीम बीच अकाल वाळुसाईन, अदिक नीम अन्नरूपी आधार इक दुर माळाईन. ");
INSERT INTO hoy_vpl VALUES ("EK5_17","027_5_17","EZK","5","17","17","ना नीम बीच अकाल अदिक दुष्ट जन्तु कळाईन जो नीमी बे:औलाद माळेव; अदिक महामारी अदिक खुन नीम बीच नळुतेला ईत्तव; अदिक ना नीम मा तलवार नळसाईन, नानी यहोवा खुद अंदुन.” ");
INSERT INTO hoy_vpl VALUES ("EK6_1","027_6_1","EZK","6","1","1","बाक यहोवा अन ईद वचन नान हाती पोहचुस्त: ");
INSERT INTO hoy_vpl VALUES ("EK6_2","027_6_2","EZK","6","2","2","“हे मंळसा अन सन्तान, तान बाय इस्त्राएल इन पहाळीगोळ दी माळकु आंदुर खिलाप भविष्यवाणी माळ, ");
INSERT INTO hoy_vpl VALUES ("EK6_3","027_6_3","EZK","6","3","3","अदिक अन, हे इस्त्राएल इन पहाळीगोळा, प्रभु यहोवा अन वचन केळी! प्रभु यहोवा सप्पा पहाळीगोळ से, अदिक नालागोळ अदिक घाटीगोळ से ईद अनतान: नोळी ना नीम मा तलवार नळसुसाईन, अदिक नीम पुजा अन धोळ जागागोळ्द नाश माळाईन. ");
INSERT INTO hoy_vpl VALUES ("EK6_4","027_6_4","EZK","6","4","4","नीमव वेदीगोळ नाश आदव अदिक नीम सुर्य अन प्रतिमागोळ मुरकु आदव; अदिक ना नीम मृत लॉकुरी नीम ई मूर्तीगोळ मुंद भिट बुळाईन. ");
INSERT INTO hoy_vpl VALUES ("EK6_5","027_6_5","EZK","6","5","5","ना इस्त्राएलीगोळोव लाशगोळी आंदुर मूर्तीगोळ मुंद ईटाईन, अदिक आंदुर येलुगोळी नीम वेदीगोळ आसपास बगरूसाईन. ");
INSERT INTO hoy_vpl VALUES ("EK6_6","027_6_6","EZK","6","6","6","नीम यास भी बसुसकु नगर आव, अव सप्पा हिंग नाश आदव, कि नीमव पहाळी माकळव पुजा अन जागा खण्डर आगेदव, नीमव वेदीगोळ नाश आदव अदिक ध्वस्त आगेदव, नीमव मूर्तीगोळ मुरुकु आदव, नीमव सुर्य अन प्रतिमागोळ तुकळा तुकळा आगेदव, अदिक नीम सप्पा कारीगरी मिटुसकु आदव. ");
INSERT INTO hoy_vpl VALUES ("EK6_7","027_6_7","EZK","6","7","7","नीम बीच दा लाशगोळ ढेर हतकु ईत्तव. आग नीव अर्त कोंडीर कि ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("EK6_8","027_6_8","EZK","6","8","8","“तरी भी इस्त्राएलगोळा, ना नीम दा टु येनारा लॉकुरी जीत्ता बीट्ट बुळाईन. येनारा लॉकुर तलवार इन मार देल उळदोदार, अदिक आंदुर दुसरा राज्य दा तितर-बितर आगेदार. दुसरा द्याशगोळ दा बिखरूसकु आर ईंदुर अच ऊळदार. ");
INSERT INTO hoy_vpl VALUES ("EK6_9","027_6_9","EZK","6","9","9","नीमोर ऊळ्दकु लॉकुर आ राष्ट्रगोळ दा नानी याद माळ्यार, येल आंदुर बन्दी माळकु निष्कासित आगीदुर. आंदुर याद माळ्यार कि ना आंदरी दण्ड कोटीदीन, यतिकी आ दिनगोळ दा आंदुर दिल इन निष्ठा नान प्रती ईला ईरोद, अदिक आंदुर दुसरा द्यावगोळ्द मूर्तीगोळ मा कामनापूर्ण ध्यान कोट्टुर, आंदुर ईद अनुभव माळकु तान बेकार क्याल्सागोळ साटी खुद तान नजर दा बेकार ठहरूस्यार, अदिक अंदार कि आंदुर यास दुष्‍कर्म माळ्यार. ");
INSERT INTO hoy_vpl VALUES ("EK6_10","027_6_10","EZK","6","10","10","आग आंदुर जान्स कोंडार कि ना यहोवा हुईन, अदिक ना जो ईद अंदीन कि ना आंदुर्द नाश माळाईन, अद बेकार अंदिदील.” ");
INSERT INTO hoy_vpl VALUES ("EK6_11","027_6_11","EZK","6","11","11","प्रभु यहोवा ईद अनतान: “तान कय बडुकु अदिक काल आपळुसकु अन, इस्त्राएल इन घराना अन सप्पा घिनोना क्याल्सागोळ मा हाय, हाय, यतिकी आंदुर तलवार, हसु, अदिक मरी देल नष्ट आगेदार. ");
INSERT INTO hoy_vpl VALUES ("EK6_12","027_6_12","EZK","6","12","12","जो दुर आन आव मरी देल सोत्तान, अदिक जो हात्ती आन आव तलवार देल कोंदकु आदान; अदिक जो उळ्दकु नगर दा ईरतेला घेर्सकु आदान, आव हसु देल सोत्तान. ई प्रकार ना तान जलजलाहट आंदुर मा पुरा रीती देल ईळसाईन. ");
INSERT INTO hoy_vpl VALUES ("EK6_13","027_6_13","EZK","6","13","13","याग हर ऊंद धोळ्द पहाळी अदिक पहाळी इन हर ऊंद चोटी मा, अदिक हर ऊंद हिवरा मार्र इन ल्यालमा, अदिक हर ऊंद घना बांज मार्र इन सावली दा, येल येल आंदुर तान सप्पा मुरतीगोळी सुखदायक सुगन्ध द्रव्य येर्सतार, अल आंदुरोर कोंदकु आग्यार आ लॉकुर तान वेदीगोळ आसपास तान मुरतीगोळ बीच दा बिदकु ईत्तार; आग नीव लॉकुर जान्स कोंडीर कि ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("EK6_14","027_6_14","EZK","6","14","14","ना तान कय आंदुर खिलाप वाळुसकु आ द्याश इक सप्पा मान्नागोळ सांगुळ आळी टु हुडुकु रिबला ताका उजाळ उजाळ अच माळ कोमाईन. आग आंदुर जान्स कोंडार कि ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("EK7_1","027_7_1","EZK","7","1","1","बाक यहोवा अन ईद वचन नान हाती पोहचुस्त, ");
INSERT INTO hoy_vpl VALUES ("EK7_2","027_7_2","EZK","7","2","2","“हे मंळसा अन सन्तान, प्रभु यहोवा इस्त्राएल इन जागा अन बारा दा ईद अनतान: कि अन्त आत; नाकु क्वाना सांगुळ द्याश इन अन्त होट बंदाद.” ");
INSERT INTO hoy_vpl VALUES ("EK7_3","027_7_3","EZK","7","3","3","नीन अन्त भी होट्ट बंदाद, अदिक ना तान कोप नीन मा भळकुसकु नीन चाल चलन इन अनुसार नीनी दण्ड कोळाईन; अदिक नीन सप्पा घिनोना क्याल्सा अन काय नीनी कोळाईन. ");
INSERT INTO hoy_vpl VALUES ("EK7_4","027_7_4","EZK","7","4","4","नान दया दृष्टी नीन मा ईरतीदील, अदिक ना तरस तिनालीन, अदिक यागासताका नीन घिनोना पाप नीन दा बन्सकु ईत्तव आगासताका ना नीन चालचलन इन फल नीनी कोळाईन. आग नी जान्स कोंड्या कि ना यहोवा हुईन. ");
INSERT INTO hoy_vpl VALUES ("EK7_5","027_7_5","EZK","7","5","5","“प्रभु यहोवा ईद अनतान: विपत्ती आद, ऊंद धोळ्द विपत्ती आद! नोळी, अद बरतद. ");
INSERT INTO hoy_vpl VALUES ("EK7_6","027_7_6","EZK","7","6","6","अन्त होट्ट बंदाद, सप्पा मुंदुर्द अन्त बंदाद; आव नीन खिलाप जागस्यान. नोळी, आव बरतान. ");
INSERT INTO hoy_vpl VALUES ("EK7_7","027_7_7","EZK","7","7","7","हे इस्त्राएल द्याश इन ईरावाळेरा, नीम विनाश इन समय होट बंदाद! नीम साटी विनाश चक्र तिर्गेग्याद.” दिन हाती आव; पहाळीगोळ मा आनंद इन शब्द अन दिन ईला, हुल्लळ इन दिन ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("EK7_8","027_7_8","EZK","7","8","8","ईग थ्वाळासा दिनगोळ दा ना तान जलजलाहट नीन मा भळकुसाईन, अदिक नीन मा पुरा कोप रिचुसाईन अदिक नीन चालचलन इन अनुसार नीनी दण्ड कोळाईन. नीन सप्पा घिनोना क्याल्सा अन फल नीनी भुगतुसाईन. ");
INSERT INTO hoy_vpl VALUES ("EK7_9","027_7_9","EZK","7","9","9","नान दया दृष्टी नीन मा आगतीदील अदिक न ना नीन मा तरस तिनाईन. ना नीन चालचलन इन फल नीनी भुगतुसाईन, अदिक नीन घिनोना पाप नीन दा बन्सकु ईत्तव. आग नीव जान्स कोंडीर कि ना यहोवा दण्ड कोळावाळा हुईन. ");
INSERT INTO hoy_vpl VALUES ("EK7_10","027_7_10","EZK","7","10","10","नोळी, आ दिशी इक नोळी, आव बरतान, चक्र तिर्गेग्याद, अन्याय इन छळी फुलुसेग्याद, नीन घमण्ड वाळुसेग्याद. ");
INSERT INTO hoy_vpl VALUES ("EK7_11","027_7_11","EZK","7","11","11","उपद्रव वाळुस्त वाळुस्त दुष्टता अन दण्ड बनसेग्याद; आंदुर दा टु याऊ ऊळुतीदील, अदिक आंदुर भीळ भाळ, न आंदुर धन दा टु येनारा ईत्तीत; अदिक न आंदुर दा टु यारदारा साटी विलाप केळ बंदीत. ");
INSERT INTO hoy_vpl VALUES ("EK7_12","027_7_12","EZK","7","12","12","समय होट बंदाद, दिन हाती होट बंदाद; न रा कोमावाळा आनंद माळुल अदिक न मारावाळा दुख माळुल, यतिकी आंदुर सप्पा भीळ मा कोप भळकुस्याद. ");
INSERT INTO hoy_vpl VALUES ("EK7_13","027_7_13","EZK","7","13","13","चाहे आंदुर जीत्ता ईरूल, तरी भी मारावाळा मार्द वस्तु उन हात्ती कभी वापस बर सकतीदील; यतिकी सिट्ट इन ईद मात द्याश इन सप्पा भीळ मा घटुसीत, याऊ वापस होगतीदील; यावारा भी मंळसा जो अधर्म दा जीत्ता ईरतान, बल हुडु सकतीदील. ");
INSERT INTO hoy_vpl VALUES ("EK7_14","027_7_14","EZK","7","14","14","आंदुर नरसींगा ऊरदुर अदिक सप्पा येनारा तैयार माळदुर; लेकीन युध्द दा याऊ होगालुन यतिकी द्याश इन सप्पा भीळ मा नान कोप भळकुसकु आद. ");
INSERT INTO hoy_vpl VALUES ("EK7_15","027_7_15","EZK","7","15","15","“व्हार्या तलवार अदिक बुळ्क महंगा अदिक मरी आद; जो मैदान दा आन आव तलवार देल सोत्तान, अदिक जो नगर दा आन आव हसु अदिक मरी देल कोंदकु आदान. ");
INSERT INTO hoy_vpl VALUES ("EK7_16","027_7_16","EZK","7","16","16","आंदुर दा टु जो ऊळ्दकु होट्टार आंदुर ऊळदार रा सही लेकीन तान तान अधर्म दा फसुसकु ईतकु तराई दा ईरावाळेर कबूतरगोळ घाई पहाळी इन म्याकुच विलाप माळतेला ईत्तार. ");
INSERT INTO hoy_vpl VALUES ("EK7_17","027_7_17","EZK","7","17","17","सप्पा मुंदुरव कय ढीला अदिक सप्पा मुंदुरव ट्वांगरा हापाळ कमजोर आगेदव. ");
INSERT INTO hoy_vpl VALUES ("EK7_18","027_7_18","EZK","7","18","18","आंदुर नेळु मा टाट कट्यार, अदिक आंदुरव मय इनव मुळ्लगोळ नीदरेव, सप्पा अन बाय वंळ्गेव अदिक सप्पा अन ताल्ला मुंडुसकु आदव. ");
INSERT INTO hoy_vpl VALUES ("EK7_19","027_7_19","EZK","7","19","19","आंदुर ताम चांदी सळकगोळ मा भीट्टार, अदिक आंदुर व्हान्ना अशुद्ध वस्तु ठहरूसीत; यहोवा अन जलन इन दिन आंदुर व्हान्ना बेळ्ली आंदरी ऊळ्स सकतीदील, न अदुर देल आंदुर जीव संतुष्ट आदीत, न आंदुर्द व्हाट्टा तुम्मीत. यतिकी अद आंदुर्द अधर्म इन ठोकर इन कारण आग्याद.” ");
INSERT INTO hoy_vpl VALUES ("EK7_20","027_7_20","EZK","7","20","20","आंदुर्द द्याश जो शोभायमान अदिक शिरोमणि ईरोद, अदुर बारा दा आंदुर गर्व अच गर्व माळकु अदुर दा तान घृणित वस्तुगोळ मूर्तीगोळ, अदिक घृणित वस्तुगोळ माळकु ईटदुर, ई कारण ना अदरी आंदुर साटी अशुद्ध वस्तु ठहरूसीन. ");
INSERT INTO hoy_vpl VALUES ("EK7_21","027_7_21","EZK","7","21","21","ना अदरी लुटसोर साटी परदेशीगोळ कय, अदिक धन कसोर साटी धरती इन दुष्ट लॉकुर कय दा माळ कोमाईन, अदिक आंदुर अदरी अपवित्र माळ कोंडार. ");
INSERT INTO hoy_vpl VALUES ("EK7_22","027_7_22","EZK","7","22","22","ना आंदुर से मार्रा तिर्गुस बुळाईन, आग आंदुर नान रक्षीत जागा अक अपवित्र माळ्यार; डाकु अल होगकु अदरी अपवित्र माळ्यार. ");
INSERT INTO hoy_vpl VALUES ("EK7_23","027_7_23","EZK","7","23","23","“ऊंद संकली माळ कोम, यतिकी द्याश अन्याय इन हत्या देल, अदिक नगर उपद्रव देल तुमकु आद. ");
INSERT INTO hoy_vpl VALUES ("EK7_24","027_7_24","EZK","7","24","24","ना राज्य राज्य अन बुरा से बुरा लॉकुरी तराईन, जो आंदुर मान्नागोळ स्वामी आगेदार; अदिक ना ताकतवरगोळ्द गर्व मुर्द बुळाईन अदिक आंदुर पवित्र जागा अपवित्र माळकु आदव. ");
INSERT INTO hoy_vpl VALUES ("EK7_25","027_7_25","EZK","7","25","25","सत्यानाश आगदुर मा आद, आग ढुंढ्सदुर मा भी आंदरी शांती सीकतिदील. ");
INSERT INTO hoy_vpl VALUES ("EK7_26","027_7_26","EZK","7","26","26","विपत्ती मा विपत्ती बंदीत अदिक ऊळुसतेला चर्चा मा चर्चा केळ बंदीत; अदिक लॉकुर भविष्यवक्ता से दर्शन इन मात केळ्यार, लेकीन याजक उन हाती टु व्यवस्था, अदिक स्याणागोळ हाती टु सम्मति कोळोद शक्ती होगतेला ईत्तीत. ");
INSERT INTO hoy_vpl VALUES ("EK7_27","027_7_27","EZK","7","27","27","राजा रा शोक माळ्यान, अदिक रीस उदासीरूपी कपळा हाक्यार, अदिक द्याश इन लॉकुर इन कय ढीला बीद्दव. ना आंदुर चलन इन अनुसार आंदुर से बर्ताव माळाईन, अदिक आंदुर कमाई घाई आंदरी दण्ड कोळाईन; आग आंदुर जान्स कोंडार कि ना यहोवा हुईन.” ");
INSERT INTO hoy_vpl VALUES ("EK8_1","027_8_1","EZK","8","1","1","बाक सहाव्वा वर्ष इन सहाव्वा तींगुळ इन पाचवा दिन इक याग ना तान मान्या कुर्तकु ईरीन, अदिक यहूदीगोळोर स्याणागोळ नान मुंद कुर्तकु ईरोर, आग प्रभु यहोवा अन शक्ती अल्या नान मा प्रगट आत. ");
INSERT INTO hoy_vpl VALUES ("EK8_2","027_8_2","EZK","8","2","2","आग ना नोळदीन कि बेक्की इन घाई ऊंद रूप कांळ्सतद; आऊन नेळु उन ल्यालमा बेक्की आद, अदिक आऊन नेळु उन म्याकुच इन दी चमकुस्द पीतल इन झलक घाई येनारा आद. ");
INSERT INTO hoy_vpl VALUES ("EK8_3","027_8_3","EZK","8","3","3","आव कय घाई येनारा वाळुसकु नान ताल्ला अन चुट्टीगोळ हुळदुन; आग आत्मा नानी धरती अदिक आकाश इन बीच दा नेगुकु परमेश्वर उन तोर्सद दर्शनगोळ दा यरूशलेम इन मंदिर इन बुळ्क, आंगुळ इन आ फाटक इन हाती पोहचुस बुट्टुन यदुर बाय उत्तर दी आद; अदिक यदुर दा आ जलन पैदा माळवाळा प्रतिमा अन जागा ईरोद यदुर कारण द्वेश उपजुसतद. ");
INSERT INTO hoy_vpl VALUES ("EK8_4","027_8_4","EZK","8","4","4","बाल अल इस्त्राएल इन परमेश्वर उन तेज हांग अच ईरोद ह्यांग ना मैदान दा नोळीदीन. ");
INSERT INTO hoy_vpl VALUES ("EK8_5","027_8_5","EZK","8","5","5","आव नान से अंदुन, “हे मंळसा अन सन्तान, तान कण्ण उत्तर दी नेगुकु नोळ.” ना तान कण्ण उत्तर दी नेगुकु नोळदीन कि वेदी इन फाटक इन उत्तर दी अदुर प्रवेश जागा दा अच आव डाह पैदा माळावाळा प्रतिमा आद. ");
INSERT INTO hoy_vpl VALUES ("EK8_6","027_8_6","EZK","8","6","6","आग आव नान से अंदुन, “हे मंळसा अन सन्तान, येन नी नोळत्या कि ई लॉकुर येन माळीत्यार? इस्त्राएल इन घराना येन अच धोड्डेव बेकार क्याल्सा ईल माळतान, ताकी ना तान पवित्र जागा टु दुर आगेगाईन; लेकीन नी ईऊर से भी यक्कुल बेकार क्याल्सा नोळ्या.” ");
INSERT INTO hoy_vpl VALUES ("EK8_7","027_8_7","EZK","8","7","7","आग आव नानी आंगुळ इन दरवाजा मा वोतुन, अदिक ना नोळदीन, कि दीवार दा ऊंद खॉद्रा आद. ");
INSERT INTO hoy_vpl VALUES ("EK8_8","027_8_8","EZK","8","8","8","आग आव नान से अंदुन, “हे मंळसा अन सन्तान, दिवाल इक वोडु;” ईदुरसाटी ना दिवाल इक वोडुकु नोळदीन कि ऊंद दरवाजा आद. ");
INSERT INTO hoy_vpl VALUES ("EK8_9","027_8_9","EZK","8","9","9","आव नान से अंदुन, “बुळ्क होगकु नोळ कि ई लॉकुर ईल ह्यांग ह्यांग अदिक हापाळ बेकार क्याल्सा माळेत्यार.” ");
INSERT INTO hoy_vpl VALUES ("EK8_10","027_8_10","EZK","8","10","10","अत: ना बुळ्क होगकु नोळदीन कि नाकु दिकळोद दिवाल मा अलग अलग प्रकार इन रेंगसावाळा जन्तु अदिक बेकार जनावरगोळ अदिक इस्त्राएल इन सप्पा घराना अन मुर्तीगोळ चित्र तेगुकु आव. ");
INSERT INTO hoy_vpl VALUES ("EK8_11","027_8_11","EZK","8","11","11","इस्त्राएल उन घराना अन बाट्टुर दा टु सत्तर मंळसा यार बीच दा शापान उन पार याजन्याह भी आन, आंदुर आ चित्र अन मुंद नीदुरकु आर, अदिक हर ऊंद मंळसा तान कय दा धूपदान हुडुकु आन, अदिक धूप इन धुंगा अन बादल इन सुगन्ध म्याकुच येळेत्याद. ");
INSERT INTO hoy_vpl VALUES ("EK8_12","027_8_12","EZK","8","12","12","आग आव नान से अंदुन, “हे मंळसा अन सन्तान, येन नी नोळ्या कि इस्त्राएल उन घराना अन बाट्टुर तान तान नकाशीवाळा कोठरीगोळ बुळ्क मतलब अंधकार दा येन माळीत्यार? आंदुर अनतार कि यहोवा नाम इक नोळालुन; यहोवा द्याश इक त्याग्स बुटान.” ");
INSERT INTO hoy_vpl VALUES ("EK8_13","027_8_13","EZK","8","13","13","बाक आव नान से अंदुन, “नी ईंदुर से अदिक भी हापाळ बेकार क्याल्सा नोळ्या जो आंदुर माळतार.” ");
INSERT INTO hoy_vpl VALUES ("EK8_14","027_8_14","EZK","8","14","14","आग आव नानी यहोवा अन भवन इन आ फाटक इन हाती वोतुन जो उत्तर इन दी ईरोन अदिक अल आर्तेर कुर्तकु तम्मूज इन साटी वर्लोर. ");
INSERT INTO hoy_vpl VALUES ("EK8_15","027_8_15","EZK","8","15","15","आग आव नान से अंदुन, “हे मंळसा अन सन्तान, येन नी ईद नोळ्या? बाक ईऊर से भी धोड्डेव बेकार क्याल्सा नी नोळ्या.” ");
INSERT INTO hoy_vpl VALUES ("EK8_16","027_8_16","EZK","8","16","16","आग आव नानी यहोवा अन भवन इन बुळ्कळोद आंगुळ दा वोतुन; अदिक अल यहोवा अन भवन इन द्वार इन हाती हांद्रा अदिक वेदी इन बीच येनारा पच्चीस मंळसा तान बेन यहोवा अन भवन इन दी अदिक तान बाय पूर्व इन दी माळकु ईरोर; अदिक आंदुर पूर्व दिशा अन दी सूर्य अक नमस्कार माळोर. ");
INSERT INTO hoy_vpl VALUES ("EK8_17","027_8_17","EZK","8","17","17","आग आव नान से अंदुन, “हे मंळसा अन सन्तान, येन नी ईद नोळ्या? येन यहूदा अन घराना अन साटी बेकार क्याल्सा अन माळोद जो आंदुर ईल माळतार श्याण मात आद? आंदुर तान द्याश इक उपद्रव देल तुम कोंडुर, बाक ईल बंदकु नानी रिस दिलुस तोगोर. बल्की आंदुर आ डगाल इक तान मुग्ग इन मुंद हुडुकु ईरतार. ");
INSERT INTO hoy_vpl VALUES ("EK8_18","027_8_18","EZK","8","18","18","ईदुरसाटी ना भी जलजलाहट इन सांगुळ क्याल्सा माळाईन, न ना दया माळाईन अदिक न ना कोमलता माळाईन, अदिक चाहे आंदुर नान किवगोळ दा धोळ शब्द देल कारदार, तरी भी ना आंदुर मात केळतीदील.” ");
INSERT INTO hoy_vpl VALUES ("EK9_1","027_9_1","EZK","9","1","1","बाक आव नान किवगोळ दा ऊँचा शब्द देल कारकु अंदुन, “नगर इन अधिकारीगोळी तान तान कय दा नाश माळोद हतियार हुडुकु हाती तरी.” ");
INSERT INTO hoy_vpl VALUES ("EK9_2","027_9_2","EZK","9","2","2","ईदुर मा आर मंळसा, उत्तर दी ऊपरी फाटक इन हादी देल तान तान कय दा घात माळोद हतियार हुडुकु बंदुर; अदिक आंदुर बीच दा सन इन कपळा हाक्कु, नेळु मा लिखसोद दवात कटकु ऊंद अदिक मंळसा ईरोन; अदिक आंदुर सप्पा भवन इन बुळ्क होगकु पीतल इन वेदी इन हाती नीदुरदुर. ");
INSERT INTO hoy_vpl VALUES ("EK9_3","027_9_3","EZK","9","3","3","आग इस्त्राएल इन परमेश्वर उन तेज करूबगोळ मा टु, यार मा म्याकुच ईर तोगोन, भवन इन हांद्रा मा येदकु बंदीदुन; अदिक आव आ सन इन कपळा हाक्कु मंळसा अक जो नेळु मा दवात कटकु ईरोन, कारदुन. ");
INSERT INTO hoy_vpl VALUES ("EK9_4","027_9_4","EZK","9","4","4","अदिक यहोवा आऊन से अंदुन, “ई यरूशलेम नगर इन बुळ्क ईत्त आत्त होगकु यास मंळसा आ सप्पा बेकार क्याल्सा अन कारण जो अदुर दा माळकु आगताव, शोक माळतेला अदिक दुखगोळ मारा चिळ्लाळसतार, आंदुर ह्याणा मा चिन्ह हचबुळ.” ");
INSERT INTO hoy_vpl VALUES ("EK9_5","027_9_5","EZK","9","5","5","आग नान केळतेला दुसरा अंदुर, “नगर दा आंदुर हिंद हिंद नळुकु कोनतेला होगी; यारदु मा दया माळबाळेतीर अदिक न यारदारा मा तरस तिनेतीर. ");
INSERT INTO hoy_vpl VALUES ("EK9_6","027_9_6","EZK","9","6","6","बाट्टुर, हारोदोर, कुवारा पोरगोळ, चिकोर-चिण्गेर, आर्तेर, सप्पा अक कोंदकु नष्ट माळी, लेकीन यातोवारा मंळसा अन ह्याणा मा चिन्ह ईतीदाद, आऊन हाती होगबाळेतीर. नान पवित्र जागा मा टु सुरवात माळी.” अत: आंदुर आ पुराना मंळसा गोळ से सुरवात माळदुर जो भवन इन मुंद ईरोर. ");
INSERT INTO hoy_vpl VALUES ("EK9_7","027_9_7","EZK","9","7","7","बाक आव आंदुर से अंदुन, “भवन इक अशुध्द माळी, अदिक आंगुळगोळी लाशगोळ देल तुमकोमी. नळी व्हार्या होळी.” आग आंदुर नगर दा कोनली कुरतुर. ");
INSERT INTO hoy_vpl VALUES ("EK9_8","027_9_8","EZK","9","8","8","याग आंदुर कोन्नोर, अदिक ना आबना ईतोदीन, आग ना बाय इन भार देल बीद्दीन अदिक चिल्ळासकु अंदीन, “हाय प्रभु यहोवा! येन नी तान जलजलाहट यरूशलेम मा भळकुसकु इस्त्राएल इन सप्पा मीगदोर इक भी नष्ट माळ्या?” ");
INSERT INTO hoy_vpl VALUES ("EK9_9","027_9_9","EZK","9","9","9","आग आव नान से अंदुन, “इस्त्राएल अदिक यहूदा अन घरानागोळ्द अधर्म हापाळ अच यक्कुल आद, ईल ताका कि द्याश हत्या देल अदिक नगर अन्याय देल तुम्मेग्याद; यतिकी आंदुर अनतार, ‘यहोवा पृथ्वी इक त्याग्स बुटान अदिक यहोवा येनु नोळालुन.’ ");
INSERT INTO hoy_vpl VALUES ("EK9_10","027_9_10","EZK","9","10","10","ईदुरसाटी आंदुर मा दया आगतीदील, न ना तरस तिनाईन, उलटा आंदुर चाल आंदुर्दा ताल्ला वापस माळाईन.” ");
INSERT INTO hoy_vpl VALUES ("EK9_11","027_9_11","EZK","9","11","11","आग ना येन नोळदीन, कि जो मंळसा सन इन कपळा हाक्कु अदिक नेळु मा दवात कटकु ईरोन, आव ईद अनकु समाचार कोट्टुन, “ह्यांग नी आग्या कोट्ट, ना हांग अच माळदीन.” ");
INSERT INTO hoy_vpl VALUES ("EK10_1","027_10_1","EZK","10","1","1","ईदुर बाद्दा ना नोळदीन कि करूबगोळ ताल्लागोळ म्याकुच जो आकाश मण्डल आद, अदुर दा नीलमणि इन सिंहासन घाई येनारा कांळ्सकु बिळतद. ");
INSERT INTO hoy_vpl VALUES ("EK10_2","027_10_2","EZK","10","2","2","आग यहोवा आ सन इन कपळा हाक्द मंळसा से अंदुन, “तिर्गावाळा चक्का अन बीच करूबगोळ ल्यालमा होग अदिक तान येढ्ढु मुठ्ठीगोळी करूबगोळ बीच इन अंगारगोळ देल तुमकु नगर मा बगरूसबुळ.” अत: आव नान नोळतेला अच बीच दा होदुन. ");
INSERT INTO hoy_vpl VALUES ("EK10_3","027_10_3","EZK","10","3","3","याग आव मंळसा बुळ्क होदुन, आग अव करूब भवन इन दक्षिण दी निदुरकु ईरव; अदिक बादल बुळ्कळोद आंगुळ दा तुमकु ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EK10_4","027_10_4","EZK","10","4","4","आग यहोवा अन सामर्थ करूबगोळ म्याकुच टु यदकु भवन इन हांद्रा मा होट्ट बत्त; अदिक बादल भवन दा तुम्मेत; अदिक अद आंगुळ यहोवा अन सामर्थ इन ऊजुळ देल तुम्मेत. ");
INSERT INTO hoy_vpl VALUES ("EK10_5","027_10_5","EZK","10","5","5","करूबगोळ्द पंखगोळ्द शब्द व्हार्या अन आंगुळ ताका केळ बरतोगोद, अद सर्व सर्वशक्तिमान परमेश्वर उन माताळोद शब्द घाई ईरोद. ");
INSERT INTO hoy_vpl VALUES ("EK10_6","027_10_6","EZK","10","6","6","याग आव सन इन कपळा हाक्द मंळसा अन तिर्गावाळा चक्कागोळ बुळ्क करूबगोळ बीच दा टु बेक्की तरोद आग्या कोट्टुन, आग आव आंदुर बीच दा होगकु ऊंद चक्का अन हाती निदुरदुन. ");
INSERT INTO hoy_vpl VALUES ("EK10_7","027_10_7","EZK","10","7","7","आग करूबगोळ दा टु ऊंद करूब तान कय वाळुसकु, आ बेक्की दा टु जो करूबगोळ बीच दा ईरोद, येनारा नेगुकु सन इन कपळा हाक्द मंळसा अन मुठ्ठी दा कोळ्त; अदिक आव अदरी हुडुकु व्हार्या होटोदुन. ");
INSERT INTO hoy_vpl VALUES ("EK10_8","027_10_8","EZK","10","8","8","करूबगोळ पंख अन ल्यालमा रा मंळसा अन कय घाई येनारा कांळ्सोद. ");
INSERT INTO hoy_vpl VALUES ("EK10_9","027_10_9","EZK","10","9","9","आग ना नोळदीन, कि करूबगोळ हाती नाक चक्का आव; मतलब ऊंद ऊंद करूब इन हाती ऊंद ऊंद चक्का आद, अदिक चक्कागोळ्द रूप किमती चमकिला कल्ल घाई आद. ");
INSERT INTO hoy_vpl VALUES ("EK10_10","027_10_10","EZK","10","10","10","अऊर्द हिंग रूप आद कि नाकु ऊंद घाई कांळ्सताव, ह्यांग कि ऊंद चक्का अन बीच दुसरा चक्का ईरूल. ");
INSERT INTO hoy_vpl VALUES ("EK10_11","027_10_11","EZK","10","11","11","नळाहोती अव तान नाकु अलंगगोळ ताकत देल नळुताव; अदिक नळाहोती तिर्गालव, बल्की यात अऊर ताल्ला ईरतद अव आतल्या अदुर हिंद नळुताव अदिक नळाहोती अव तिर्गालव. ");
INSERT INTO hoy_vpl VALUES ("EK10_12","027_10_12","EZK","10","12","12","बेन कय अदिक पंखगोळ सांगुळ करूबगोळ पुरा शरीर अदिक जो चक्का अऊरव आव, अव भी सप्पा च्या सप्पा नाकु दी कण्णगोळ देल तुमकु आव. ");
INSERT INTO hoy_vpl VALUES ("EK10_13","027_10_13","EZK","10","13","13","नान केळतेला आ चक्कागोळी चक्कर अनकु आत, मतलब तिर्गावाळा चक्का. ");
INSERT INTO hoy_vpl VALUES ("EK10_14","027_10_14","EZK","10","14","14","ऊंद ऊंद इन नाक नाक चेहरा ईरव: ऊंद चेहरा रा करूबगोळ घाई, दुसरा मंळसा अन घाई, तिसरा हुल्ल इन घाई,