﻿USE sofia;
DROP TABLE IF EXISTS sofia.hot_vpl;
CREATE TABLE hot_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hot_vpl WRITE;
INSERT INTO hot_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Êntêk ma Yisu Kilisi anêŋ limi. Yani ma Ablaham lo Devit iniŋ lim lukmuk. ");
INSERT INTO hot_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaham habi Aisak vê, ma Aisak habi Jekop vê, ma Jekop habi Juda lôk iviyaŋ vê. ");
INSERT INTO hot_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ma Juda habi Peles lo Sela vê, ma thainiŋ talêbô Tama. Ma Peles habi Heslon vê, ma Heslon habi Lam vê. ");
INSERT INTO hot_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ma Lam habi Aminadap vê, ma Aminadap habi Nason vê, ma Nason habi Salmon vê. ");
INSERT INTO hot_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ma Salmon habi Boas vê, ma Boas talêbô Lahap. Ma Boas habi Obet vê, ma Obet talêbô Lut. Ma Obet habi Jesi vê. ");
INSERT INTO hot_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ma Jesi habi Kiŋ Devit vê. Ma Devit habi Solomon vê, ma Solomon anêŋ talêbô ma Ulia yanavi. ");
INSERT INTO hot_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ma Solomon habi Lehoboam vê, ma Lehoboam habi Abiya vê, ma Abiya habi Asa vê. ");
INSERT INTO hot_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ma Asa habi Jehosapat vê, ma Jehosapat habi Jeholam vê. Ma Jeholam ma Usaia anêŋ lim. ");
INSERT INTO hot_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ma Usaia ma Jotam anêŋ bumalô, ma Jotam habi Ahas vê, ma Ahas habi Hesekaia vê. ");
INSERT INTO hot_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ma Hesekaia habi Manasa vê, ma Manasa habi Amon vê, ma Amon habi Josaia vê. ");
INSERT INTO hot_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ma Josaia ma Jekonaia lôk iviyaŋ iniŋ bumalô. Jekonaia lôk iviyaŋ ibitak ma avômalô Babilon ik vovak ba ewa avômalô Islael i êmô Babilon. ");
INSERT INTO hot_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Avômalô Islael êmô Babilon denaŋ, ma Jekonaia habi Sialtiel vê, ma Sialtiel ma Selubabel anêŋ bumalô. Êŋ ma avômalô Islael êvôi iniŋ loŋ hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ma Selubabel ma Abiut anêŋ lim, ma Abiut ma Elaiakim anêŋ lim, ma Elaiakim ma Aso anêŋ lim. ");
INSERT INTO hot_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ma Aso ma Sadok anêŋ lim, ma Sadok ma Akim anêŋ lim, ma Akim ma Eliut anêŋ lim. ");
INSERT INTO hot_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ma Eliut ma Eleasal anêŋ lim, ma Eleasal ma Matan anêŋ lim, ma Matan ma Jekop anêŋ lim. ");
INSERT INTO hot_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ma Jekop habi Josep vê, ma Josep intu Malia yamalô. Ma Malia êŋ intu havathu Yisu. Ma Yisu êŋ atu ba elam nena “Mesia”. ");
INSERT INTO hot_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ma avômalô takatu ba ibitak anêŋ Ablaham haveŋ aleba hayô Devit, thêlô ma hatôm ôdôŋ laumiŋ ba lahavuva. Ma avômalô takatu ba ibitak anêŋ Devit aleba hayô avômalô Islael i Babilon, thêlô ma hatôm ôdôŋ laumiŋ ba lahavuva aêŋ iyom. Ma avômalô takatu ba ibitak hadêŋ waklavôŋ atu ba avômalô Islael êmô Babilon aleba hayô Mesia ma hatôm ôdôŋ laumiŋ ba lahavuva aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ma abô hathak Yisu Kilisi halêm pik aêntêk. Malia anêŋ avômalô bôk epesaŋ abô yôv ek nendom yani êndêŋ Josep. Thai miŋ ewa i ami denaŋ ma êyê nena yani hasabeŋ. Lovak Matheŋ da hêv amena êŋ. ");
INSERT INTO hot_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","20","Ma Josep, ôpatu ba enja Malia ma anyô thêthôŋ ba intu hadum ek êndô Malia. Ma hadô indum yani mama êndôk avômalô maleŋiŋ. Êŋ ma habôlêm auk ek êndô avi êŋ menaŋna ba ni. Ma doŋtom hayê niaviŋ nena Wapômbêŋ anêŋ aŋela hayô ba hanaŋ, “Josep, Devit anêŋ lim lukmuk, amena êntêk ma Lovak Matheŋ hêv hadêŋ yani. Ba intu miŋ ôkô ek onja Malia ba nu anêm unyak êtôm vônim ami. ");
INSERT INTO hot_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma tem embathu okna te ek nêm anêŋ avômalô bulubiŋ ba intu ondam anêŋ athêŋ nena Yisu.” ");
INSERT INTO hot_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma nômkama takêntêk bôk habitak ek Wapômbêŋ anêŋ abô injik anôŋ ba hanaŋ hadêŋ plopet nena, ");
INSERT INTO hot_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Avi te miŋ hêk haviŋ anyô ami denaŋ ma tem esabeŋ ba embathu okna te. Ba tem nendam anêŋ athêŋ nena Imanuel.” Abô êŋ anêŋ ôdôŋ nena, “Wapômbêŋ hamô haviŋ alalô.” ");
INSERT INTO hot_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ma Josep hayê niaviŋ êŋ yôv ma haviyô. Ma hadum hatôm atu ba Wapômbêŋ anêŋ aŋela hanaŋ ba hawa Malia ba hi anêŋ unyak hatôm yanavi. ");
INSERT INTO hot_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma miŋ hêk haviŋ ami aleba havathu amena êŋ. Ma halam nena Yisu. Havathu amena êŋ vêm ka hêk haviŋ yanavi haveŋ yam. ");
INSERT INTO hot_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Helot hatu kiŋ ma Malia hawa Yisu hêk Betlehem anêŋ loŋ Judia. Êŋ ma ŋê lôkauk hathak vuliŋ anêŋ loŋ wak hathak êlêm Jelusalem ");
INSERT INTO hot_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ma enaŋ hik liŋ, “Amena lukmuk atu ba hatu avômalô Islael iniŋ kiŋ, anêŋ talêbô havathu hêk êsê? Yêlô ayê anêŋ vuliŋ habitak loŋ wak hathak ba alêm ek nanêm yeŋ êndêŋ yani.” ");
INSERT INTO hot_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma kiŋ Helot lôk avômalô Jelusalem sapêŋ elaŋô abô êŋ ba êkô hathak. ");
INSERT INTO hot_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Êŋ ma Helot halam avômalô iniŋ ŋê bêŋbêŋ êbôk da lôk iniŋ ŋê lôkauk hathak abô balabuŋ sapêŋ ethak doŋtom. Ma hanaŋ hik thêlô liŋ, “Mesia atu tem nembathu ênjêk êsê?” ");
INSERT INTO hot_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma thêlô enaŋ viyaŋ nena, “Wapômbêŋ bôk hanaŋ ba plopet te bôk hato nena, ");
INSERT INTO hot_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘O Betlehem atu ba hômô Juda iniŋ pik, anyô bêŋ te tem imbitak anêŋ o ba eyabiŋ yenaŋ avômalô Islael êtôm boksipsip iniŋ alaŋ ba intu o miŋ malak oyaŋ te hômô pik Juda malêvôŋ ami. Mi anôŋ!’” ");
INSERT INTO hot_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yôv ma Helot halam ŋê lôkauk eyala vuliŋ menaŋna ek endaŋô nena aŋgê intu vuliŋ êŋ habitak. ");
INSERT INTO hot_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma hêv thêlô ba i Betlehem ma hanaŋ, “Môlônu nômbôlêm amena êŋ katô. Ba ôpôm ma nôlêm nonaŋ êndêŋ ya ek yana yanêm yeŋ êndêŋ yani imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Thêlô elaŋô kiŋ anêŋ abô yôv ma i. Ma êyê vuliŋ sêbôk ba habitak loŋ wak hathak. Êŋ ma thêlô leŋiŋmavi bêŋ anôŋ. Vuliŋ êŋ hamôŋ ba hi aleba hamiŋ unyak atu ba amena hêk vôv. ");
INSERT INTO hot_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Thêlô êyô unyak kapô ba i ma êyê amena lo talêbô Malia. Êŋ ma elek veŋiŋdôŋ lêlô ba êkôm ba êv yeŋ hadêŋ yani. Ma epesaŋ iniŋ nômkama mavi ba êv iniŋ leŋiŋmavi hadêŋ yani. Êv gol lôk nôm ôv mavi ju atu ba epesaŋ hathak alokwaŋ thôk. ");
INSERT INTO hot_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma êyê niaviŋ ma Wapômbêŋ hanaŋ hadêŋ thêlô nena miŋ ini ek Helot ami. Êŋ ma elom loŋôndê yaŋ ba i iniŋ loŋ hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ŋê lôkauk hathak vuliŋ etak unyak yôv, ma Josep hayê niaviŋ ba Wapômbêŋ anêŋ aŋela te hayô ba hanaŋ, “Helot tem êmbôlêm amena ek injik vônô. Aêŋ ba umbiyô onja amena lo talêbô ba ôsôv ba nu Ijip ma ômô endeba yanêm abô êndêŋ o am.” ");
INSERT INTO hot_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aêŋ ba intu Josep haviyô ma hawa amena lo talêbô hadêŋ bôlôvôŋ ba etak Betlehem ma êsôv ba i Ijip ");
INSERT INTO hot_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ma hamô aleba Helot hama. Nôm takêŋ habitak ek Wapômbêŋ anêŋ abô injik anôŋ ba hanaŋ hadêŋ plopet nena, “Yahalam yenaŋ okna hêk Ijip ba halêm.” ");
INSERT INTO hot_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ŋê lôkauk hathak vuliŋ miŋ êvôi hathak loŋbô ami ba Kiŋ Helot hayala nena esau yani. Ma laŋaŋa kambom anôŋ ma lahabi thêlôniŋ abô takatu ba bôk enaŋ hathak vuliŋ anêŋ waklavôŋ. Êŋ ma hanaŋ ek nijik apenena takatu ba iniŋ sondabêŋ hatôm lokwaŋju sapêŋ vônô anêŋ Betlehem lôk anêŋ loŋ yaô nena sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aêŋ ba Wapômbêŋ anêŋ abô hik anôŋ ba hanaŋ hadêŋ plopet Jelemaia nena, ");
INSERT INTO hot_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Voŋvoŋ bêŋ hêk Lama, asêŋ malêŋ lôk malaiŋ bêŋ, Lesel anêŋ limi lêk ema ba mi. Aêŋ ba halaŋ ba hadô nênêm yani thêvô.” ");
INSERT INTO hot_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josep hamô Ijip denaŋ ma Helot hama. Hayê niaviŋ ma Wapômbêŋ anêŋ aŋela te hayô ");
INSERT INTO hot_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ba hanaŋ nena, “Ŋê takatu ba idum ek nijik amena vônô bôk ema yôv ma umbiyô onja amena lo talêbô ba ômbônu pik Islael esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Êŋ ma Josep haviyô ma hawa amena lo talêbô ba êvôi pik Islael. ");
INSERT INTO hot_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma halaŋô nena Akelaus hawa lambô Helot anêŋ loŋ ba hatu avômalô Judia iniŋ kiŋ. Ba intu hakô ek ni loŋ êŋ. Ma hayê niaviŋ ma hasôv ba hi ");
INSERT INTO hot_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","hamô malak nate anêŋ athêŋ nena Nasalet ba hamô Galili kapô. Nom êŋ habitak ek Wapômbêŋ anêŋ abô injik anôŋ ba hanaŋ hadêŋ plopet doho nena, “Avômalô tem nendam yani nena anyô Nasalet te.” ");
INSERT INTO hot_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wak êŋ ma anyô te ba elam nena “Jon anyô hathik ŋaŋ” hayô Judia iniŋ loŋ ek enaŋ Wapômbêŋ anêŋ abô êndêŋ avômalô. Ôpêŋ hamô loŋ thiliv ");
INSERT INTO hot_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ma hanaŋ nena, “Wapômbêŋ anêŋ loŋ lôkliŋyak lêk habobo. Ba intu node kapôlômim liliŋ.” ");
INSERT INTO hot_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon êŋ ma ôpatu ba Wapômbêŋ hanaŋ hadêŋ plopet Aisaia nena, “Kaêk te halam haveŋ loŋ thiliv nena, ‘Nôpôpêk loŋôndê ek Anyô Bêŋ êlêm, ma nopesaŋ ba imbitak thêthôŋ ek yani.’” ");
INSERT INTO hot_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ma hathak hik kwêv atu ba epesaŋ hathak bok kamel vuluk ma havak bokŋgôp epesaŋ hathak bok kupik hayôhêk lamalim. Ma hathak hayaŋ kôm sopek lôk hanum biyo thôk. ");
INSERT INTO hot_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ma avômalô anêŋ Jelusalem lôk Judia anêŋ malak sapêŋ lôk loŋ takatu ba êmô habobo ŋaŋ Jolodaŋ ethak i hadêŋ Jon. ");
INSERT INTO hot_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma thêlô enaŋ iniŋ kambom bêŋ ma Jon hathik i halôk ŋaŋ Jolodaŋ. ");
INSERT INTO hot_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma hayê avômalô Islael iniŋ ŋê bêŋbêŋ takatu ba elam nena Palisi lôk Sadyusi ma hanaŋ, “Môlô ma umya kambom anêŋ nali ba osoŋ nena tem yasik môlô ek nôsôv ênjêk Wapômbêŋ anêŋ lamaniŋ e? Mi anôŋ! ");
INSERT INTO hot_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nundum ku takatu ba injik thô nena lêk ole kapôlômim liliŋ am. ");
INSERT INTO hot_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma miŋ lemimimbi auk te ba nonaŋ êndêŋ am nena, ‘Ablaham ma yêlôaniŋ bumalô. Ba intu yêlô avômalô thêthôŋ.’ Mi, yanaŋ êndêŋ môlô nena Wapômbêŋ hatôm enja valu takêntêk ba epesaŋ Ablaham anêŋ limi esak. ");
INSERT INTO hot_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kisiŋ lêk hamô alokwaŋ ôdôŋ yôv, ek alokwaŋ takatu ba miŋ hik anêŋ anôŋ mavi ami, ma tem nede lu ba nêmbôk esak atum. ");
INSERT INTO hot_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Yahathik môlô hathak ŋaŋ ek injik thô nena bôk ole kapôlômim liliŋ yôv. Ma doŋtom ôpatu ba tem embeŋ ya yam anêŋ lôklokwaŋ ma bomaŋ ek yenaŋ ba intu tem isik môlô esak Lovak Matheŋ lôk atum. Yani ma anyô lôk athêŋ bêŋ ma ya ma yaônalôk ba intu miŋ hatôm yanja anêŋ va bokŋgôp êtôm anyô ku oyaŋ ami. Mi anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yani tem isuv nôm anêŋ kupik vê ba êndô anôŋ êmô unyak kapô. Ma yavoyav takatu ba hamô piklêvôŋ ma isi ba êmbôk esak atum atu ba tem miŋ ema ami.” ");
INSERT INTO hot_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yisu hatak Galili ma hi ŋaŋ Jolodaŋ ek Jon isik yani. ");
INSERT INTO hot_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma doŋtom Jon hadum ek imiŋ yani loŋ siŋ ba hanaŋ, “Aisê ka hôlêm hadêŋ ya? Usik ya.” ");
INSERT INTO hot_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Êŋ ma Yisu hanaŋ viyaŋ nena, “Alalô nasopa loŋôndê thêthôŋ ba intu usik ya.” Ma Jon halôk ba hathik Yisu. ");
INSERT INTO hot_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ma ketheŋ oyaŋ ma haviyô hêk ŋaŋ kapô. Ma leŋ hakyav ma hayê Wapômbêŋ anêŋ Lovak Matheŋ halôk ba halêm hatôm menak bôbô ba hayô hamô yani. ");
INSERT INTO hot_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma abô te halêm anêŋ malak leŋ ba hanaŋ nena, “Intu ma yenaŋ Okna atu ba yaleŋhaviŋ videdauŋ. Ma ya kapôlôŋ mavi hathak yani.” ");
INSERT INTO hot_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yôv ma Lovak Matheŋ halom Yisu hi loŋ thiliv ek Sadaŋ êndôk yani la ek indum kambom. ");
INSERT INTO hot_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yani hatip ek nôm ba haveŋ hatôm wak lo bôlôvôŋ 40 ba intu hama kisi. ");
INSERT INTO hot_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Êŋ ma ŋgôk iniŋ anyô bêŋ hayô ek Yisu ma hanaŋ, “O Wapômbêŋ anêŋ Nakaduŋ ma onaŋ ek valu takêntêk imbitak êtôm polom.” ");
INSERT INTO hot_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma Yisu hanaŋ viyaŋ nena, “Wapômbêŋ anêŋ kapya hanaŋ nena, ‘Anyô miŋ hatôm êmô lôkmala esak nôm iyom ami. Mi. Esopa Wapômbêŋ anêŋ abô lôkthô.’” ");
INSERT INTO hot_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Vêm ma ŋgôk hawa Yisu ba hi Jelusalem loŋ bêŋ atu ba matheŋ ma hadô hamiŋ unyak matheŋ anêŋ vôv daim te. ");
INSERT INTO hot_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma hanaŋ, “O ma Wapômbêŋ anêŋ Nakaduŋ, e? Wapômbêŋ anêŋ kapya hanaŋ nena, “‘Wapômbêŋ tem nêm anêŋ aŋela ek neyabiŋ o. Ma thêlô tem netak baheŋ ek miŋ valu la embatho vemkapô ami.’ Ba intu ôsôv kisi.” ");
INSERT INTO hot_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma Yisu hanaŋ, “Abô bute hêk Wapômbêŋ anêŋ kapya aêntêk, ‘Miŋ hatôm môlô nundum mambêŋ esak Wapômbêŋ, môlônim Anyô Bêŋ ami.’” ");
INSERT INTO hot_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Vêm ma ŋgôk hawa yani hathak loŋbô ba hi dumlolê daim te. Ma hik loŋ lôk nômkama mavi lomaloma takatu ba hamô pik bêŋ êntêk lôkthô thô hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma hanaŋ hadêŋ Yisu, “Tem yanêm nôm takêntêk sapêŋ êndêŋ o. Ma doŋtom ondek vemdôŋ lêlô ba nêm yeŋ êndêŋ ya am.” ");
INSERT INTO hot_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma Yisu hanaŋ, “Sadaŋ, o vê. Wapômbêŋ anêŋ kapya hanaŋ, ‘Nêm yeŋ êndêŋ Wapômbêŋ anêm Anyô Bêŋ ma undum yanida anêŋ ku iyom.’” ");
INSERT INTO hot_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ba intu ŋgôk êŋ hatak yani ba hi ma aŋela êyô êv yani sa. ");
INSERT INTO hot_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ma Yisu halaŋô nena bôk êdô Jon hamô koladôŋ. Ba intu havôhi Galili ");
INSERT INTO hot_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ba hi hamô Kapaneam ma miŋ hamô Nasalet ami. Kapaneam êŋ hamô habobo kasukthôm te ba hamô Sebulun lo Naptali iniŋ pik. ");
INSERT INTO hot_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yani hamô loŋ êŋ ek Wapômbêŋ anêŋ abô injik anôŋ ba hanaŋ hadêŋ plopet Aisaia nena, ");
INSERT INTO hot_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun lo Naptali iniŋ pik atu hamô habobo kasukthôm, lôk pik atu ba hêk ŋaŋ Jolodaŋ anêŋ daŋ vi, Galili, loŋ atu ba avômalô loŋ buyaŋ êmô. ");
INSERT INTO hot_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Avômalô takatu ba êmô momaŋiniŋ bêŋ kapô, thêlô lêk êyê deda bêŋ te. Ba idum ek nema, ma doŋtom deda habi hayô hêk thêlô ba hêv momaŋiniŋ vê.” ");
INSERT INTO hot_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yisu hayô Kapaneam yôv ma hadum anêŋ ku môŋ ba hanaŋ Wapômbêŋ anêŋ abô hadêŋ avômalô nena, “Wapômbêŋ anêŋ loŋ lôkliŋyak lêk habobo ba node kapôlômim liliŋ.” ");
INSERT INTO hot_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yisu habup hathak kasukthôm Galili anêŋ liŋdaŋ ma hayê anyô lo yaŋ Saimon atu ba elam nena Pita lôk yaŋ molok Andulu. Thai ma ŋê ik alim ba ibi iniŋ yakseŋ halôk kasukthôm. ");
INSERT INTO hot_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma hanaŋ hadêŋ thai, “Mamu nôlêm nosopa ya! Tem yandum ba mamu nôbôv avômalô êtôm ôvôv alim halôk yakseŋ.” ");
INSERT INTO hot_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma ketheŋ oyaŋ ma thai êdô iniŋ yakseŋ hamô ma esopa Yisu. ");
INSERT INTO hot_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Habup hathak vauna ma hayê anyô loyaŋ, Jems lo Jon. Thai ma Sebedi nakaduŋ. Thêlô lôk lambô êmô yeŋ ba idu iniŋ yakseŋ. Ma Yisu halam thai. ");
INSERT INTO hot_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma ketheŋ oyaŋ ma etak lambô lôk yeŋ hamô ma esopa Yisu. ");
INSERT INTO hot_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisu hi haveŋ Galili lôbôlôbô ba hathak habitak hayô iniŋ unyak yeŋ ba hanaŋ Wapômbêŋ anêŋ Abô Mavi hathak anêŋ loŋ lôkliŋyak hadêŋ i. Ma hadum iniŋ malaiŋ lôk lijiŋ lomaloma ba ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma avômalô anêŋ plovins Silia elaŋô abô hathak Yisu anêŋ ku ma ewa iniŋ ŋê lôk lijiŋ lomaloma sapêŋ ba i hadêŋ yani. Ewa ŋê takatu ba ewa vovaŋ bêŋ lôk ŋê ŋgôk hamô haviŋ i ma ŋê ema yak lôk ŋê ivuviŋ sapêŋ i hadêŋ yani ek hêv iniŋ lijiŋ takêŋ vê. ");
INSERT INTO hot_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Avômalô bêŋ anôŋ êlêm esopa yani. Doho êlêm anêŋ Galili, ma doho êlêm anêŋ Jelusalem, ma doho êlêm anêŋ Judia. Ma doho êlêm anêŋ Dekapolis lôk loŋ takatu ba hamô ŋaŋ Jolodaŋ vi. ");
INSERT INTO hot_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yisu hayê avômalô bêŋ anôŋ êlêm ma hathak dumte ba hi hamô. Ma avômalô takatu ba esopa yani i êyô ek yani. ");
INSERT INTO hot_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma hadôŋ i ba hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ôpatu ba hayala nena yani anyô kambom anôŋ, ôpêŋ lêk hamô mavi ba tem enja Wapômbêŋ anêŋ loŋ lôkliŋyak. ");
INSERT INTO hot_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ma ôpatu ba lamalaiŋ, ôpêŋ lêk hamô mavi ba Wapômbêŋ tem nêm yani thêvô. ");
INSERT INTO hot_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ma ôpatu ba hamô maliŋyaô, ôpêŋ lêk hamô mavi ba tem enja pik sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ma ôpatu ba hama kisi lôk hathakmuniŋ ek imbitak êtôm anyô thêthôŋ, ôpêŋ lêk hamô mavi ba tem laviyak. ");
INSERT INTO hot_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ma ôpatu ba hêv kapô ek anyô yaŋ, ôpêŋ lêk hamô mavi ba Wapômbêŋ tem nêm kapô ek ôpêŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ma ôpatu ba kapô mabuŋ, ôpêŋ lêk hamô mavi ba tem ênjê Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ma ôpatu ba hêv bulubiŋ, ôpêŋ lêk hamô mavi ba tem nendam nena Wapômbêŋ anêŋ nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ma anyô thêthôŋ te hapôm vovaŋ, ôpêŋ lêk hamô mavi ba tem enja Wapômbêŋ anêŋ loŋ lôkliŋyak. ");
INSERT INTO hot_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Hosopa ya ba anyô te hanaŋ abôma hathak o lôk hêv vovaŋ hadêŋ o lôk hanaŋ abô kambom lomaloma hathak o mena hanaŋ abôyaŋ hathak o, êŋ ma lêk hômô mavi! ");
INSERT INTO hot_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","“Avômalô bôk idum aêŋ hadêŋ plopet tak sêbôk ba êmôŋ ek o. Ma Wapômbêŋ tem nêm vuli mavi bêŋ te êndêŋ o êmô malak leŋ ba intu lemmavi anôŋ ba ômbô o! ");
INSERT INTO hot_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Môlô ma pik êntêk anêŋ ŋgwêk. Ma doŋtom ŋgwêk vabô, êŋ ma lêk habitak hatôm siŋusik ma hatôm imbitak vasiŋ esak loŋbô ami ba intu nômbi ni ek avômalô nêyô nimiŋ ba nembak pesa. ");
INSERT INTO hot_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Môlô ma pik anêŋ deda. Ma malak atu ba hamô dum ba avômalô êtôm atum lam sapêŋ, thêlô êthôkwêŋ ek nêm deda ma miŋ ivuŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma miŋ othak ôtôm atum lam ba uvuŋ halôk uŋ kapô ami. Othak opesaŋ lam anêŋ deda ek imbi êyô unyak kapô lôkthô. ");
INSERT INTO hot_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","“Ma môlônim deda imbi êyô ênjêk avômalô lôkthô ek nêgê unim ku mavi takatu ba udum ek nebam môlônim lemambô atu ba hamô malak leŋ anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Môlô miŋ nosoŋ nena yahalêm ek yambuliŋ abô balabuŋ lôk plopet iniŋ abô ami. Yahalôk ba yahalêm ek abô takêŋ injik anôŋ ma miŋ yahalêm ek yanêm vê ami. ");
INSERT INTO hot_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yanaŋ avanôŋ êndêŋ môlô. Abô lêlêyaŋ yaô nena sapêŋ atu ba eto hêk kapya abô balabuŋ te tem miŋ nêm yak ami. Mi anôŋ. Abô takêŋ tem ênjêk endeba pik lo leŋ anêŋ daŋ. Ma nômkama takatu ba hamô abô balabuŋ sapêŋ tem injik anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aêŋ ba ôpatu ba hêv abô balabuŋ yaônate vê ba hadôŋ avômalô hathak tem êtôm okna hathek ênjêk Wapômbêŋ anêŋ loŋ lôkliŋyak. Ma doŋtom ôpatu ba hasopa abô balabuŋ lôk hik thô hadêŋ avômalô tem imbitak anyô lôk athêŋ bêŋ ênjêk Wapômbêŋ anêŋ loŋ lôkliŋyak. ");
INSERT INTO hot_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yanaŋ avanôŋ êndêŋ môlô. Anêm thêthôŋ miŋ hamôŋ ek Palisi lôk ŋê lôkauk hathak abô balabuŋ iniŋ ami, êŋ ma tem miŋ hatôm ôyô Wapômbêŋ anêŋ loŋ lôkliŋyak ami. ");
INSERT INTO hot_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Môlô bôk olaŋô abô takatu ba enaŋ hadêŋ bumalô thêlô nena, ‘Miŋ uŋgwik anyô vônô paliŋ ami. Ma ôpatu ba hik anyô vônô paliŋ tem êpôm abô.’ ");
INSERT INTO hot_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma doŋtom yanaŋ êndêŋ môlô. Anyô te lamaniŋ hadêŋ anyô yaŋ, ôpêŋ tem êpôm abô. Ma anyô te hanaŋ abôma hathak anyô yaŋ, ôpêŋ tem imiŋ ŋê bêŋbêŋ maleŋiŋ ek indum abô. Ma anyô te hanaŋ hadêŋ anyô yaŋ nena, ‘O anyô molo’, yakô ôpêŋ tem nimbi êndôk loŋ atum lôkmala. ");
INSERT INTO hot_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Aêŋ ba hômô loŋ êbôk da ek ômbôk anêm da, ma lemhabi nena anêm abô hêk haviŋ anyô te, ");
INSERT INTO hot_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","êŋ ma otak anêm da êmô loŋ êbôk da ma nu êndêŋ ôpêŋ. Ma opesaŋ abô imbiŋ yani vêmam ka nu ômbôk anêm da. ");
INSERT INTO hot_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ma anyô te hadum ek idum abô ek o ba mamu oveŋ loŋôndê hi denaŋ ek nôyô loŋ nindum abô, ma opesaŋ abô imbiŋ yani ketheŋ. Yakô tem etak o êndôk anyô halaŋô abô baŋ. Êŋ ma ôpêŋ tem etak o êndôk anêŋ ŋê ku baheŋiŋ ek nêndô o êmô koladôŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Odaŋô! Yanaŋ avanôŋ êndêŋ o. Tem ômô koladôŋ endeba nêm anêm vuli sapêŋ atu ba anyô bêŋ hanaŋ am. ");
INSERT INTO hot_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Môlô bôk olaŋô abô takatu ba enaŋ yôv nena, ‘Miŋ undum sek imbiŋ anyô yaŋ yanavi ami.’ ");
INSERT INTO hot_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma doŋtom yanaŋ êndêŋ môlô nena anyô te makilik hathak avi te ba hadum ek ênjêk imbiŋ yani, êŋ ma lêk hêk haviŋ avi êŋ yôv. ");
INSERT INTO hot_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Aêŋ ba malem vianôŋ hadum ba hudum kambom, êŋ ma ômbi vê ba umbini! Malem daluk doŋtom iyom, êŋ ma malaiŋ. Ma doŋtom, lemvimkupik sapêŋ êndôk loŋ atum lôkmala, êŋ ma malaiŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma bahem vianôŋ hadum ba hudum kambom, êŋ ma odabêŋ kisi ba umbini! Bahem doŋtom iyom, êŋ ma malaiŋ. Ma doŋtom lemvimkupik sapêŋ êndôk loŋ atum lôkmala, êŋ ma malaiŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Môlô bôk olaŋô yôv nena, ‘Anyô hadum ek êndô avi ma eto abô êndôk kapya ba nêm kapya êŋ êndêŋ yanavi ek nêm yani vê. Ma miŋ hatôm nêm yanavi vê oyaŋ ami.’ ");
INSERT INTO hot_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma doŋtom yanaŋ êndêŋ môlô aêntêk. Anyô te hêv yanavi vê oyaŋ ma miŋ hadum sek ami ba avi êŋ hi hawa anyô yaŋ êŋ ma ôpêŋ hadum ba avi êŋ hadum sek. Ma yamalô lukmuk êŋ hadum sek aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Môlô bôk olaŋô abô takatu ba enaŋ hadêŋ bumalô thêlô nena, ‘Hovak balabuŋ hathak Wapômbêŋ anêŋ athêŋ hathak nômla, êŋ ma undum nôm êŋ anôŋ.’ Miŋ ômbôliŋ dômim ami. ");
INSERT INTO hot_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma doŋtom yanaŋ êndêŋ môlô nena miŋ ombak balabuŋ esak nômla ami lôk miŋ ombak balabuŋ esak Wapômbêŋ anêŋ athêŋ ami ek malê nena yanida hamô malak leŋ hatôm kiŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma miŋ ombak balabuŋ esak pik ami ek malê nena pik bêŋ êntêk ma balê Wapômbêŋ da hatak vakapô hayô hamiŋ. Ma miŋ ombak balabuŋ esak Jelusalem ami ek malê nena Jelusalem ma Kiŋ Bêŋ atu anêŋ malak. ");
INSERT INTO hot_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma miŋ ombak balabuŋ esak lemkadôk ami ek malê nena o miŋ hatôm onaŋ ba lemkadôk ŋauŋ imbitak thapuk mena loŋgavu la ami. ");
INSERT INTO hot_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ba intu môlô nonaŋ abô avanôŋ iyom. Ma miŋ nonaŋ balabuŋ lomaloma ek injik thô nena onaŋ abô avanôŋ ami. Abô takêŋ habitak anêŋ Sadaŋ anêŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Môlô bôk olaŋô abô takatu ba enaŋ yôv nena, ‘Anyô te habi anyô yaŋ madaluk siŋ, êŋ ma nômbi ôpêŋ madaluk siŋ aêŋ iyom. Ma anyô te hik anyô yaŋ abôlêk kalalaŋ lu, ma uŋgwik ôpêŋ abôlêk kalalaŋ lu aêŋ iyom.’ ");
INSERT INTO hot_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma doŋtom yanaŋ êndêŋ môlô nena miŋ uŋgwik anyô yaŋ anêŋ kambom liliŋ ami. Ma anyô te hapetav malem daŋ vi, êŋ ma nuŋgwik vi liliŋ ek epetav imbiŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma anyô te hadum abô ek o ba anyô atu halaŋô abô hanaŋ nena nêm anêm kwêv êndêŋ ôpêŋ, êŋ ma nêm anêm kwêv thilibuŋ êndêŋ ôpêŋ imbiŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma anyô vovak te hanaŋ nena onja anêŋ nômkama ba nu êtôm kilomita te, êŋ ma nu êtôm kilomita ju. ");
INSERT INTO hot_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma anyô te hanaŋ hik o liŋ ek nêm nômlate êndêŋ yani, êŋ ma nêm êndêŋ yani. Ma anyô te lahaviŋ enja nômlate ênjêk o vêm ka nêm viyaŋ, êŋ ma miŋ ôpôlik ami. ");
INSERT INTO hot_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Môlô bôk olaŋô abô takatu ba enaŋ yôv nena, ‘Lemimbiŋ anêm avômalô ma ôpôlik esak ŋê takatu ba êpôlik hathak o.’ ");
INSERT INTO hot_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","Ma doŋtom yanaŋ êndêŋ môlô nena lemimimbiŋ ŋê takatu ba êpôlik hathak môlô lôk noteŋ mek esak ŋê takatu ba êv vovaŋ hadêŋ môlô ek numbitak êtôm Lemambô atu ba hamô malak leŋ anêŋ nali. Ek malê nena yanida hêv wak hadêŋ avômalô mavi lôk kambom ma hêv ôthôm ek ŋê thêthôŋ lôk ŋê lokbaŋ. ");
INSERT INTO hot_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ma môlô othak lemimhaviŋ ŋê takatu ba leŋiŋhaviŋ môlô iyom, êŋ ma nôm oyaŋ. Tem miŋ môlô noja nôm mavi te ami. Ŋê ewa takis ethak idum aêŋ haviŋ! ");
INSERT INTO hot_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma môlô othak ôêv waklêvôŋ hadêŋ môlônim avômalô iyom, môlô osoŋ nena kobom hik môlô vônô e? Ŋê daluk idum aêŋ haviŋ! ");
INSERT INTO hot_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ba intu nômô batôŋ oyaŋ êtôm Lemambô atu ba hamô batôŋ oyaŋ hamô malak leŋ.” ");
INSERT INTO hot_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Môlô noyabiŋ am! Miŋ nundum ku mavi lomaloma ek avômalô nêgê ba nebam môlô ami. Yakô Wapômbêŋ atu ba hamô malak leŋ tem miŋ nêm nôm mavi la êndêŋ môlô ami. ");
INSERT INTO hot_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Môlô udum ek nônêm avômalô siv sa, ma miŋ nundum êtôm ŋê takatu ba esau avômalô ami. Thêlô ethak êv anyô ek iyuv lavuak êmôŋ ba i unyak yeŋ. Êŋ ma thêlô êv nômlate hadêŋ avômalô siv ek avômalô nêgê ba nebam thêlô. Yanaŋ avanôŋ êndêŋ môlô nena ŋê takêŋ lêk ewa iniŋ mavi yôv ba embeŋ yam ma Wapômbêŋ tem miŋ nêm nôm mavi yaŋ êndêŋ i ami. ");
INSERT INTO hot_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma doŋtom môlô udum ek nônêm nômlate êndêŋ avômalô siv, êŋ ma nubuŋ ba nônêm ek avômalô vi miŋ nêgê ami. Nôm atu ba bahem vianôŋ hadum ma bahem vikeŋ êsôŋ paliŋ ");
INSERT INTO hot_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ek ku êŋ ênjêk loŋ kapô iyom. Ma Lemambô atu ba hayê ku takatu ba hudum hêk loŋ kapô ma tem nêm nôm mavi te êndêŋ o. ");
INSERT INTO hot_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Môlô udum ek noteŋ mek, ma miŋ nundum êtôm ŋê takatu ba esau avômalô ami. Thêlô leŋiŋhaviŋ neteŋ mek nimiŋ malaklêvôŋ lôk unyak yeŋ ek avômalô nêgê i. Odaŋô! Yanaŋ avanôŋ êndêŋ môlô. Ŋê takêŋ lêk ewa iniŋ mavi yôv ba embeŋ yam ma Wapômbêŋ tem miŋ nêm nôm mavi yaŋ êndêŋ i ami. ");
INSERT INTO hot_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma doŋtom hudum ek oteŋ mek, êŋ ma nu anêm unyak kapô ma nuŋgwik unyak abôlêk siŋ. Ma oteŋ mek êndêŋ Lemambô atu ba hamô loŋ kapô. Ma Lemambô tem ênjê ku takatu ba hudum hêk loŋ kapô ma nêm nôm mavi te êndêŋ o. ");
INSERT INTO hot_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Hudum ek oteŋ mek, ma miŋ ondela abô êtôm ŋê daluk ethak idum ami. Thêlô eteŋ mek daim ek esoŋ nena Wapômbêŋ tem endaŋô iniŋ mek daim êŋ. ");
INSERT INTO hot_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma doŋtom hudum ek oteŋ mek ma Wapômbêŋ lêk hayala anêm malaiŋ yôv ba intu miŋ osopa iniŋ bôk lo loŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ma noteŋ mek aêntêk, “‘Wakamik, hômô malak leŋ. Yêlô nambô anêm athêŋ matheŋ liŋ. ");
INSERT INTO hot_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Anêm loŋ lôkliŋyak êlêm. Yêlô nasopa anêm lemhaviŋ ênjêk pik êtôm thêlô esopa hêk malak leŋ. ");
INSERT INTO hot_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nêm nôm êndêŋ yêlô êndêŋ wak êntêk. ");
INSERT INTO hot_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ma otak kapôlôm ek yêlô êtôm atu ba yêlô atak kapôlôŋiŋ ek avômalô vi atu ba idum kambom hadêŋ yêlô. ");
INSERT INTO hot_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Miŋ otak yêlô ek nandum kambom ami. Ma nêm yêlô vê ênjêk kambom.’ ");
INSERT INTO hot_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ma notak kapôlômim ek avômalô vi, ma Lemambô atu ba hamô malak leŋ tem etak kapô ek môlô aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma hovaloŋ kapôlôm lôŋ ek avômalô vi, ma Lemambô tem embaloŋ kapô loŋ ek o aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Hutip ek nôm ek lemimbi Wapômbêŋ, ma miŋ malem tiyamtiyam êtôm ŋê esau avômalô ethak idum ami. Thêlô miŋ ithik i ba epesaŋ i katô ami ek avômalô neyala nena thêlô lêk itip ek nôm. Yanaŋ avanôŋ êndêŋ môlô nena ŋê êŋ lêk ewa iniŋ nôm mavi yôv ba embeŋ yam ma Wapômbêŋ tem miŋ nêm nôm mavi yaŋ êndêŋ i ami. ");
INSERT INTO hot_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma doŋtom hutip ek nôm ek lemimbi Wapômbêŋ, ma otak nôm lêŋlêŋ esak lemkadôk lôk usik thonam lo malem êtôm lemmavi iyom ");
INSERT INTO hot_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ek avômalô miŋ neyala nena lêk hutip ek nôm ami. Ma lemambô atu ba hamô loŋ kapô, yani iyom intu hayê anêm ku loŋ kapô êŋ ba tem nêm nôm mavi te êndêŋ o. ");
INSERT INTO hot_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Pik êntêk ma didu lo da tem nimbuliŋ nômkama lôk ŋê vani tem nijik unyak vose ba neja nômkama takêŋ vani. Ba intu miŋ nômbôlêm nômkama mavi ba nôndô êmô pik êntêk ami. ");
INSERT INTO hot_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mi, nusup nômkama malak leŋ mavimavi iyom. Êŋ ma miŋ hatôm da lo didu nimbuliŋ nômkama takêŋ lôk ŋê vani miŋ hatôm nijik anêm unyak vose ba neja anêm nômkama vani ami. ");
INSERT INTO hot_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Loŋ atu ba anyô anêŋ nômkama mavi hamô intu kapôlôŋiŋ tem êmô loŋ êŋ imbiŋ. ");
INSERT INTO hot_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Maleŋdaluk ma leŋviŋkupik anêŋ deda. Aêŋ ba malemdaluk hamô mavi, êŋ ma anêŋ deda êŋ hayabiŋ lemvimkupik sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma doŋtom maleŋdaluk kambom, êŋ ma momaŋiniŋ lêk hayabiŋ leŋviŋkupik sapêŋ. Ba deda atu ba hamô kapôlôm miŋ hadum anêŋ ku ami, ma momaŋiniŋ tem indumbak bêŋ. ");
INSERT INTO hot_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Anyô te miŋ hatôm indum anyô bêŋ ju iniŋ ku ami. Ma tem la imbiŋ anyô yaŋ ma kapô êndô yaŋ. Ma tem ma endahaliŋ anyô yaŋ ma imbuliŋ dôm ek anyô yaŋ. Môlô miŋ hatôm nosopa Wapômbêŋ lôk valuseleŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Lôkmala ma bêŋ ek nôm eyaŋ. Leŋviŋkupik ma bêŋ ek kwêv lo sup. Aêŋ ba intu yanaŋ êndêŋ môlô nena miŋ lemim imbi bêŋ anôŋ esak nômkama pik lomaloma êtôm kwêv mena nôm lôk ŋaŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ôŋgô menak. Thêlô miŋ ethak idum ku lôk elav nôm ami. Ma miŋ ethak ewa nôm ba etak hamô unyak kapô ami. Môlônim Lemambô atu ba hamô malak leŋ havakôŋ thêlô. Ma môlô ma Wapômbêŋ lahaviŋ bêŋ anôŋ hamôŋ ek menak. ");
INSERT INTO hot_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma môlô lemhikam hathak nôm pik takêŋ, ma tem nômô lôkmala wak te imbiŋ e? Mi anôŋ! ");
INSERT INTO hot_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Aisê ka môlô othak lemimhabi bêŋ anôŋ hathak kwêv? Môlô ôŋgô alokwaŋ vuak takatu ba hamô mayaliv. Thêlô ibitak aisê? Thêlô miŋ ethak idum iniŋ ku lôk idu iniŋ kwêv ami. ");
INSERT INTO hot_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aêŋ ba yanaŋ êndêŋ môlô! Solomon hathak hik anêŋ kwêv kêkêlô. Ma anêŋ kwêv sapêŋ ma nôm yaôna ek alokwaŋ vuak mavi takatu. ");
INSERT INTO hot_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Môlô ma avômalô ôêvhaviŋ yaôna lôk! Ketheŋ oyaŋ ma tem nedabêŋ kamuŋ takatu kisi ba nêmbôk esak atum! Ma doŋtom Wapômbêŋ hathak hêv kwêv hadêŋ kamuŋ takêŋ. Ba intu tem eyabiŋ môlô mavi aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Aêŋ ba môlô miŋ lemim injik am ba nonaŋ, ‘Yêlô aŋgaŋ malê lôk nanum malê?’ ma ‘Yêlôaniŋ kwêv êsê?’ Dô. ");
INSERT INTO hot_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ŋê daluk ethak elaŋviŋ ba esopa nôm takêŋ. Ma doŋtom môlônim Lemambô atu ba hamô malak leŋ hayala môlônim malaiŋ ba tem nêm nôm takêŋ êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ba intu ku môŋ ma lem injik o esak Wapômbêŋ anêŋ loŋ lôkliŋyak lôk osopa anêŋ abô ma tem nêm nôm takêŋ sapêŋ êndêŋ o. ");
INSERT INTO hot_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aêŋ ba môlô miŋ lemimmalaiŋ ek yamuŋ anêŋ nômkama ami. Yamuŋ anêŋ malaiŋ ma wak êŋ da anêŋ. Ma wak te anêŋ malaiŋ ma wak êŋ da iyom anêŋ. ");
INSERT INTO hot_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Môlô miŋ nutitiniŋ anyô vi ami. Wapômbêŋ tem ititiniŋ môlô aêŋ iyom! ");
INSERT INTO hot_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Abô takatu ba honaŋ hathak anyô vi, êŋ ma Wapômbêŋ tem enaŋ aêŋ êndêŋ o. Ma malêla takatu ba huik sam hadêŋ anyô vi ma tem nêm viyaŋ aêŋ iyom êndêŋ o. ");
INSERT INTO hot_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ma lem hik o hathak siŋusik yaô atu ba hamiŋ mamuyaŋ madaluk. Ma doŋtom aseleŋ atu ba hapalaŋaniŋ hamiŋ oda malem siŋ ma hôthôŋ paliŋ. ");
INSERT INTO hot_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ba honaŋ, ‘Aiyaŋ, yahadum ek yanêm siŋusik atu ba hamô malem daluk vê.’ Nôŋgô katô, oda anêm ma aseleŋ hapalaŋaniŋ hamiŋ malem loŋ siŋ. ");
INSERT INTO hot_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","O anyô abôyaŋ! Nêm aseleŋ atu ba hêk malem vê ek nôŋgô tak vêm ka miŋ nêm siŋusik atu ba hêk mamuyaŋ madaluk vê. ");
INSERT INTO hot_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ma miŋ noja nôm matheŋ ba nônêm êndêŋ avuŋ ami. Tem nijik liliŋ ba nesaŋ môlô mayaliv. Ma miŋ nômbi unim kômkôm mavi êndêŋ bok ami. Tem nembak pesa esak veŋiŋ kapô. ");
INSERT INTO hot_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Ŋê takatu ba enaŋ hik Wapômbêŋ liŋ, ma tem neja nômkama êtôm atu ba enaŋ. Ma anyô habôlêm nômlate, êŋ ma tem êpôm. Ma ôpatu ba hapididiŋ unyak abôlêk, ma tem injik unyak abôlêk vê ek ôpêŋ. Aêŋ ba nonaŋ injik Wapômbêŋ liŋ ma tem nêm môlônim lemimhaviŋ êndêŋ môlô. Ma môlô ôbôlêm ma tem nôpôm. Ma upididiŋ unyak abôlêk ma tem injik vê ek môlô. ");
INSERT INTO hot_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nalummalô hanaŋ hik o liŋ ek nêm polom êndêŋ yani, ma tem nêm valu te êndêŋ yani e? Mi. ");
INSERT INTO hot_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma nalummalô hanaŋ hik o liŋ ek nêm alim ŋgwêk te êndêŋ yani, ma tem nêm umya kambom te êndêŋ yani e? Mi. ");
INSERT INTO hot_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Odaŋô! Môlô ma avômalô kambom! Ma doŋtom môlô othak ôêv nômkama mavi hadêŋ nalumi. Ma môlônim Lemambô atu ba hamô malak leŋ ma Wapômbêŋ mavi anôŋ ba intu tem nêm nômkama mavi êndêŋ môlô ŋê takatu ba onaŋ hik yani liŋ. ");
INSERT INTO hot_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ma malêla takatu ba môlô lemimhaviŋ avômalô vi nindum êndêŋ môlô, ma nundum aêŋ êndêŋ i. Êŋ ma abô balabuŋ lôk plopet iniŋ abô anêŋ ôdôŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Loŋôndê bêŋ ma hi loŋ ŋama. Ma badêŋ abôlêk bêŋ te hamô loŋ êŋ ba avômalô bêŋ anôŋ ethak ibitak êyô. Ma doŋtom loŋôndê kamuŋ hi loŋ lôkmala. Ma badêŋ abôlêk yaônate hêk loŋ êŋ ba avômalô tomtom iyom ethak êpôm ba elom. Ba intu nôsôam ek numbitak nôyô badêŋ abôlêk yaôna êŋ ba unu. ");
INSERT INTO hot_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Môlô noyabiŋ am êndêŋ ŋê plopet abôyaŋ. Thêlô ma hatôm avuŋ yatap ba ivuliv i siŋ hathak boksipsip kupik ba i hadêŋ boksipsip ek nimbuliŋ i. ");
INSERT INTO hot_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aêŋ ba iniŋ anôŋ intu tem injik i thô. Yak lôkmaŋgiŋ mena kamuŋ lôk lilu ma avômalô ethak elav hatôm iniŋ nôm e? ");
INSERT INTO hot_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Alokwaŋ mavi sapêŋ hathak hik anêŋ anôŋ mavi iyom. Ma alokwaŋ kambom hathak hik anêŋ anôŋ kambom aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ba intu alokwaŋ mavi miŋ hatôm injik anêŋ anôŋ kambom ami. Ma alokwaŋ kambom miŋ hatôm injik anêŋ anôŋ mavi ami. ");
INSERT INTO hot_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Aêŋ ba alokwaŋ sapêŋ atu ba miŋ hik anêŋ anôŋ ami, ma tem nede lu ba nêmbôk esak atum. ");
INSERT INTO hot_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ba intu plopet abôyaŋ iniŋ anôŋ tem injik thêlôda thô êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Avômalô ethak elam ya nena, ‘Anyô Bêŋ, Anyô Bêŋ.’ Ma doŋtom thêlô sapêŋ miŋ hatôm nêyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ami. Ma avômalô takatu ba esopa Wakamik atu ba hamô malak leŋ anêŋ abô, thêlô êŋ iyom intu tem nêyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô. ");
INSERT INTO hot_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Waklavôŋ yandaŋô avômalô sapêŋ iniŋ abô, ma bêŋ anôŋ tem nenaŋ êndêŋ ya ‘Anyô Bêŋ, Anyô Bêŋ, yêlô athak alam anêm athêŋ ba adum anêm ku plopet. Ma yêlô athak alam anêm athêŋ ba êv ŋgôk vê lôk adum nômbithi bêŋ anôŋ hathak.’ ");
INSERT INTO hot_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Êŋ ma tem yanaŋ êndêŋ i, ‘Môlô nu! Môlô ŋê udum kambom ba yahathôŋ môlô paliŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Aêŋ ba ôpatu ba halaŋô yenaŋ abô sapêŋ ba hasopa hatôm anyô lôkauk mavi atu ba halav anêŋ unyak halôk valu. ");
INSERT INTO hot_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ma ôthôm lôk lovak bêŋ ma ŋambô hayô ba hayôkwiŋ unyak êŋ. Ma valu havaloŋ unyak êŋ loŋ lôklokwaŋ ba miŋ hapu ami. ");
INSERT INTO hot_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ma anyô halaŋô yenaŋ abô ba miŋ hasopa ami hatôm anyô auk mi ba halav anêŋ unyak halôk thathe oyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ma ôthôm malokola lôk lovak bêŋ ma ŋambô hayô ba hayôkwiŋ unyak êŋ ba hapu lôk diŋdiŋ bêŋ ba hi.” ");
INSERT INTO hot_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yisu hanaŋ abô sapêŋ yôv ma avômalô takatu ba elaŋô esoŋ kambom ba enaŋ, ");
INSERT INTO hot_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","“Yani miŋ hadôŋ alalô ba halam kêdôŋwaga bô iniŋ abô hatôm ŋê lôkauk hathak abô balabuŋ ethak idum ami. Mi. Hadôŋ alalô hatôm anyô lôk athêŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisu hatak dumlolê ba hi ma avômalô bêŋ anôŋ esopa yani. ");
INSERT INTO hot_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma anyô palê lepla te halêm hadêŋ Yisu ma halek vadôŋ lêlô ma hanaŋ, “Anyô bêŋ, odanêm lemhaviŋ ma hatôm undum ba yambitak mavi.” ");
INSERT INTO hot_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ma hatak baŋ hayô hêk ôpêŋ ma hanaŋ, “Yaleŋhaviŋ umbitak mabuŋ mavi!” Ma ketheŋ oyaŋ ma lijiŋ êŋ hêv yak ba habitak mabuŋ mavi. ");
INSERT INTO hot_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Êŋ ma Yisu hanaŋ hadêŋ yani, “Nu nuŋgwik o thô êndêŋ anyô habôk da ma nêm da êtôm sêbôk ba Mose hanaŋ ek injik thô nena anêm lijiŋ lêk hêv yak. Ma miŋ onaŋ bêŋ êndêŋ anyôla ami.” ");
INSERT INTO hot_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yisu hayô malak Kapaneam, ma anyô vovak laik te anêŋ malak bêŋ Lom halêm hadêŋ yani ");
INSERT INTO hot_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ma hanaŋ, “Anyô bêŋ, yenaŋ anyô ku hapôm lijiŋ va lo baŋ havuviŋ ba hawa vovaŋ bêŋ ba hêk unyak iyom.” ");
INSERT INTO hot_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ma Yisu hanaŋ hadêŋ yani, “Tem yasôk ek yandum ôpêŋ mavi.” ");
INSERT INTO hot_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Ma doŋtom anyô vovak laik êŋ hanaŋ, “Anyô bêŋ, ya miŋ anyô mavi ek ôlêm yenaŋ unyak ami. Yada yahamô anyô bêŋ te vibiŋ, ma yenaŋ ŋê vovak êmô ya vibiŋ. Ba yahanaŋ hadêŋ yenaŋ anyô vovak te nena, ‘Nu,’ êŋ ma hi. Mena yahanaŋ hadêŋ yaŋ nena, ‘Ôlêm,’ êŋ ma halêm. Ma yahanaŋ hadêŋ yenaŋ anyô ku nena, ‘Undum ku êntêk,’ êŋ ma hadum. Aêŋ ba yahayala nena onaŋ iyom ek yenaŋ anyô ku imbitak mavi ma tem imbitak mavi.” ");
INSERT INTO hot_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yisu halaŋô abô êŋ ba hasoŋ kambom ma hanaŋ hadêŋ avômalô takatu ba esopa yani nena, “Yanaŋ avanôŋ êndêŋ môlô. Ya miŋ bôk yahapôm anyô hêvhaviŋ bêŋ te aêntêk hamô loŋ Islael ami. ");
INSERT INTO hot_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yanaŋ êndêŋ môlô. Avômalô loŋ buyaŋ bêŋ anôŋ tem nejaŋ ba ninum imbiŋ Ablaham lo Aisak ma Jekop nêmô Wapômbêŋ anêŋ loŋ lôkliŋyak. ");
INSERT INTO hot_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sêbôk ma Wapômbêŋ lahaviŋ avômalô Islael nêyô anêŋ loŋ lôkliŋyak kapô, ma doŋtom lêk ma yani tem nêm thêlô vê ba ini loŋ momaŋiniŋ bêŋ. Loŋ êŋ ma tem thêlô nedaŋ asêŋ maleŋ ba nesaŋ veŋiŋbôlêk ôdôŋ loŋ.” ");
INSERT INTO hot_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Êŋ ma Yisu hanaŋ hadêŋ anyô vovak laik êŋ, “Nu! Ma nôm atu ba lêk hôêvhaviŋ ma tem imbitak aêŋ.” Ma ketheŋ oyaŋ ma ôpêŋ anêŋ anyô vovak atu habitak mavi. ");
INSERT INTO hot_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ma Yisu hayô Pita anêŋ unyak kapô ma hayê Pita yaŋavi hapôm lijiŋ vovaŋ ba hêk iyom. ");
INSERT INTO hot_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ma Yisu havaloŋ avi êŋ baŋ ma lijiŋ êŋ hatak yani ma haviyô hapôpêk nôm ek Yisu. ");
INSERT INTO hot_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yaŋsiŋ ma ewa ŋê lôk ŋgôk habuliŋ i doho êlêm hadêŋ Yisu. Ma Yisu hanaŋ abô iyom ma ŋgôk takêŋ etak avômalô takêŋ ba i. Ma hadum avômalô lôk lijiŋ sapêŋ ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ba intu Wapômbêŋ anêŋ abô atu ba bôk hanaŋ hadêŋ plopet Aisaia hik anôŋ nena, “Yani hapesaŋ alalôaniŋ lijiŋ mavi ma hêv alalôaniŋ vovaŋ vê.” ");
INSERT INTO hot_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yisu hayê avômalô bêŋ anôŋ êmô ma hanaŋ hadêŋ anêŋ ŋê ku nena, “Alôana kasukthôm vi tuvulu.” ");
INSERT INTO hot_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Êŋ ma ŋê lôkauk hathak abô balabuŋ te halêm hadêŋ Yisu ma hanaŋ nena, “Kêdôŋwaga, loŋ nômbêŋ atu ba hu ma tem yasopa o.” ");
INSERT INTO hot_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma Yisu hanaŋ, “Avuŋ yatap iniŋ pik abyaŋ hamô ma menak iniŋ unyak hamô, ma doŋtom ya Anyô Anêŋ Nakaduŋ atu anêŋ loŋ ênjêk ma mi.” ");
INSERT INTO hot_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma Yisu anêŋ anyô te hanaŋ, “Anyô Bêŋ, otak ya ek yana yandav wakamik vêmam.” ");
INSERT INTO hot_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma doŋtom Yisu hanaŋ hadêŋ ôpêŋ, “Dô! Ŋê ŋama da nedav iniŋ ŋama. Ma ôlêm osopa ya!” ");
INSERT INTO hot_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yôv ma Yisu hathak yeŋ ma anêŋ ŋê ku i haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Thêlô i êyô kasukthôm malêvôŋ ma ketheŋ oyaŋ ma ôthôm bêŋ lôk lovak hayô. Ma ŋaŋ budum hik ba hadum ek êyô yeŋ vôv. Ma doŋtom Yisu hêk sôm denaŋ. ");
INSERT INTO hot_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ma anêŋ ŋê ku i ik yani liŋ ba enaŋ, “Anyô Bêŋ, nêm alalô bulubiŋ! Tem alalô nama!” ");
INSERT INTO hot_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ma Yisu hanaŋ hadêŋ i, “Môlô ŋê ôêvhaviŋ yaôna lôk! Aisê ba môlô ôkô?” Êŋ ma haviyô hathaŋ lovak lôk ŋaŋ budum ba êk maliŋyaô ba thêthê mavi. ");
INSERT INTO hot_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Thêlô esoŋ kambom ba enaŋ, “Anyô aisête ba lovak lôk ŋaŋ budum elaŋô anêŋ abô ba esopa?” ");
INSERT INTO hot_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yôv ma Yisu hi kasukthôm vi tuvulu ba hayô avômalô Gadala iniŋ pik. Ma anyô lokwaŋju atu ba ŋgôk kambom hathak habuliŋ i êlêm anêŋ siô ba êpôm yani halôk loŋôndê. Anyô ju êŋ ethak ibuliŋ avômalô ba intu êkô ek nendom loŋôndê êŋ. ");
INSERT INTO hot_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ma êyê Yisu ma elam lôklala, “Wapômbêŋ anêŋ Nakaduŋ, hôlêm ek undum malê êndêŋ yêlô? Waklavôŋ nindum abô hêk denaŋ. Ma hôlêm loŋ êntêk ek nêm vovaŋ êndêŋ yêlô e?” ");
INSERT INTO hot_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma bok dum te êmô daim dokte ba eyaŋ kamuŋ êmô. ");
INSERT INTO hot_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ma ŋgôk takêŋ elaŋ lôklokwaŋ hadêŋ Yisu, “Nêm yêlô vê ni êndôk bok takêŋdaku kapô.” ");
INSERT INTO hot_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma Yisu hanaŋ hadêŋ thêlô “Môlô nu!” Êŋ ma ŋgôk takêŋ etak anyô ju êŋ ma i êlôk bok takêŋ kapô ba elaŋviŋ ketheŋ ba i hadêŋ loŋ kambom ma êv yak halôk kasukthôm ba ema. ");
INSERT INTO hot_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ŋê takatu ba eyabiŋ bok êyê nôm êŋ ma êsôv ba i êyô malak bêŋ. Ma enaŋ hadêŋ avômalô hathak nôm atu ba Yisu hadum hadêŋ bok lôk anyô ju atu ba ŋgôk habuliŋ thai. ");
INSERT INTO hot_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Êŋ ma avômalô malak lôŋ êŋ iki thô ba i hadêŋ Yisu. Thêlô êyê yani ba êkô kambom ma enaŋ nena, “Otak yêlô ba nu!” ");
INSERT INTO hot_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yôv ma Yisu hathak yeŋ ŋgwêk te ba havôhi anêŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ma anyô doho evak anyô havuviŋ te hêk yêm ba êlêm hadêŋ yani. Êŋ ma Yisu hayê thêlôniŋ êvhaviŋ ma hanaŋ hadêŋ anyô havuviŋ atu nena, “Yenaŋ okna, lem êndôk biŋ. Lêk yahêv anêm kambom sapêŋ vê.” ");
INSERT INTO hot_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ŋê lôkauk hathak abô balabuŋ doho elaŋô abô êŋ ma enaŋ hadêŋ i, “Ôpêŋ hasoŋ nena yani ma Wapômbêŋ e?” ");
INSERT INTO hot_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yisu hayala thêlôniŋ auk ma hanaŋ, “Aisê ka môlô owa auk kambom êŋ? ");
INSERT INTO hot_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Abô alê intu vumvum ek yanaŋ: ‘Lêk yahêv anêm kambom sapêŋ vê’ mena ‘Umbiyô ombeŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aêŋ ba tem yaŋgik thô êndêŋ môlô nena Anyô Anêŋ Nakaduŋ atu anêŋ athêŋ ma bêŋ ba hatôm nêm kambom vê.” Êŋ ma hanaŋ hadêŋ anyô havuviŋ atu nena, “Umbiyô umiŋ ma onja anêm yêm ba nu anêm unyak.” ");
INSERT INTO hot_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Êŋ ma ôpêŋ haviyô hamiŋ ba hi anêŋ unyak. ");
INSERT INTO hot_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ma avômalô êyê nôm êŋ ba esoŋ kambom ma êbô Wapômbêŋ atu ba hêv lôklokwaŋ lôk athêŋ bêŋ hadêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yisu hi ma hayê anyô te ba anêŋ athêŋ nena Matyu ba hamô unyak ewa takis. Ma hanaŋ hadêŋ ôpêŋ nena, “Ôlêm osopa ya,” êŋ ma haviyô ba hi hasopa yani. ");
INSERT INTO hot_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yisu hayaŋ nôm haviŋ Matyu hamô anêŋ unyak. Ma ŋê ewa takis lôk ŋê idum kambom bêŋ anôŋ êlêm eyaŋ nôm haviŋ yani lôk anêŋ ŋê ku. ");
INSERT INTO hot_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Palisi êyê ma enaŋ hik anêŋ ŋê ku liŋ, “Aisê ka môlônim kêdôŋwaga hayaŋ nôm haviŋ ŋê ewa takis lôk ŋê idum kambom?” ");
INSERT INTO hot_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yisu halaŋô abô êŋ ma hanaŋ, “Ŋê lôk lijiŋ iyom intu ethak i êyê dokta. Ma ŋê lijiŋ mi ma mi. ");
INSERT INTO hot_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Aêŋ ba môlô lemimimbi Wapômbêŋ anêŋ abô atu ba hêk kapya hanaŋ nena, “‘Yaleŋhaviŋ môlô nônêm kapôlômim êndêŋ avômalô. Ma yahapôlik hathak da.’ Ba intu yahalêm ek yandam ŋê takatu ba idum kambom. Ma miŋ yahalêm ek yandam ŋê thêthôŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jon anêŋ ŋê ku êlêm hadêŋ Yisu ma enaŋ hik yani liŋ, “Yêlô lôk ŋê Palisi athak avak balabuŋ ek nôm ek leŋiŋhabi Wapômbêŋ. Ma doŋtom anêm ŋê ku miŋ ethak idum aêŋ ami eka?” ");
INSERT INTO hot_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma Yisu hanaŋ, “Anyô te hawa avi lukmuk, êŋ ma anêŋ anyô môlô eyaŋ nôm lôk leŋiŋmavi. Ma miŋ hatôm nembak balabuŋ ek nôm ami. Ma doŋtom haveŋ yam, ba ewa yani vê hêk thêlô, êŋ ma anêŋ ŋê môlô tem nembak balabuŋ ek nôm.” ");
INSERT INTO hot_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Anyô late hatôm enja sôp lukmuk bute ba indu sôp bô anêŋ abyaŋ siŋ esak ami. Hadum aêŋ ma tem sôp lukmuk buêŋ êmô sôp bô kisi. Êŋ ma tem itip bêŋ. ");
INSERT INTO hot_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma môlô othak ôkê waiŋ lukmuk halôk kolopak epesaŋ hathak bok kupik bô e? Mi! Waiŋ lukmuk êŋ tem imbuliŋ bok kupik bô atu bôk thekthek ba tem ipup ba waiŋ eŋgasô ni. Ba intu othak ôkê waiŋ lukmuk halôk bok kupik lukmuk atu ba belap ek isiŋ mavi ma miŋ ipup ami lôk waiŋ miŋ eŋgasô ni ami.” ");
INSERT INTO hot_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisu hanaŋ abô denaŋ ma anyô bêŋ te halêm halek vadôŋ lêlô hêk yani va ma hanaŋ, “Yenaŋ avena lêk hama. Ôlêm otak bahem êyôŋgêk yani ek imbiyô esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ma Yisu lôk anêŋ ŋê ku i iviŋ yani ba i. ");
INSERT INTO hot_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Thêlô eveŋ ba i ma avi lôk lijiŋ te halêm hadêŋ Yisu dômlokwaŋ ma havaloŋ Yisu anêŋ kwêv anêŋ daŋ. Avi êŋ hapôm lijiŋ thalaleŋ halom hatôm sondabêŋ laumiŋ ba lahavuju. ");
INSERT INTO hot_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ma avi êŋ anêŋ auk nena, “Yambaloŋ anêŋ kwêv iyom, ma tem ya mavi.” ");
INSERT INTO hot_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ma Yisu hik i liliŋ ba hayê avi êŋ ma hanaŋ, “Yenaŋ avena, lem êndôk biŋ. Anêm hôêvhaviŋ hadum ba lêk hubitak mavi.” Ma ketheŋ oyaŋ ma avi êŋ habitak mavi. ");
INSERT INTO hot_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Vêm ma Yisu hi hayô anyô bêŋ atu anêŋ unyak. Ma hayê avômalô iyuv abiŋ ba elaŋ ba idum thôthô bêŋ ");
INSERT INTO hot_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ma hanaŋ, “Môlô vê! Avena hêk sôm iyom ma miŋ hama ami.” Êŋ ma thêlô emalik hathak yani. ");
INSERT INTO hot_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ma doŋtom êv avômalô vê ma Yisu habitak hayô unyak kapô ba havaloŋ avena êŋ baŋ, ma haviyô hamiŋ. ");
INSERT INTO hot_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ba intu abô hathak nôm êŋ haveŋ loŋ êŋ lôkthô. ");
INSERT INTO hot_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ma Yisu hatak loŋ êŋ ma haveŋ ba hi, ma anyô maleŋ pusip ju esopa yani ba elam kaêk nena, “Devit anêŋ Lim Lukmuk, nêm kapôlôm ek yai!” ");
INSERT INTO hot_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yisu hayô unyak kapô ba hi ma anyô ju atu i hadêŋ yani. Ma hanaŋ hik thai liŋ, “Mamu ôêvhaviŋ nena ya hatôm yandum ba mamu numbitak mavi e?” Ma thai enaŋ, “Intu êŋ. Anyô Bêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Êŋ ma yani hatak baŋ hayô hêk thai maleŋdaluk ma hanaŋ, “Mamu lêk ôêvhaviŋ ba intu tem numbitak mavi.” ");
INSERT INTO hot_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Êŋ ma maleŋiŋ daluk hakyav. Ma Yisu hêv abô lôklokwaŋ hadêŋ thai, “Miŋ nonaŋ êndêŋ anyôla esak nôm êntêk ami.” ");
INSERT INTO hot_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma doŋtom i ma enaŋ nôm atu ba Yisu hadum hadêŋ thai haveŋ loŋ êŋ lôkthô. ");
INSERT INTO hot_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Anyô ju êŋ etak Yisu ba i denaŋ, ma avômalô ewa anyô abôlêk putup te atu ba ŋgôk habuliŋ yani ba êlêm ek Yisu. ");
INSERT INTO hot_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma hêv ŋgôk êŋ vê ma ôpêŋ hanaŋ abô. Ma avômalô esoŋ kambom ba enaŋ, “Sêbôk ma miŋ nômlate aêŋ habitak Islael ami.” ");
INSERT INTO hot_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma doŋtom ŋê Palisi enaŋ, “Ŋgôk iniŋ anyô bêŋ hêv lôklokwaŋ hadêŋ ôpêŋ. Ba intu hatôm nêm ŋgôk sapêŋ vê ênjêk avômalô.” ");
INSERT INTO hot_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma Yisu haveŋ loŋ buêŋ sapêŋ ba habitak hayô avômalô iniŋ unyak yeŋ ba hadôŋ avômalô lôk hanaŋ Abô Mavi hathak Wapômbêŋ anêŋ loŋ lôkliŋyak. Ma hapesaŋ avômalô iniŋ malaiŋ sapêŋ lôk hêv iniŋ lijiŋ lomaloma sapêŋ vê. ");
INSERT INTO hot_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yisu hayê avômalô nômbêŋ atu iniŋ auk lêk mayaliv ba êmô malaiŋ kambom hatôm boksipsip anêŋ alaŋ mi. Aêŋ ba lahiki hathak i. ");
INSERT INTO hot_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ba intu hanaŋ hadêŋ anêŋ ŋê ku nena, “Nôm bêŋ anôŋ lêk hayôk ba hamô ku kapô, ma doŋtom ŋê ku ma tomtom iyom. ");
INSERT INTO hot_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aêŋ ba noteŋ mek êndêŋ ku anêŋ alaŋ ek nêm ŋê ku ba ini ek nindum anêŋ ku.” ");
INSERT INTO hot_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ma Yisu halam ŋê ku laumiŋ ba lahavuju i hadêŋ yani. Ma hêv lôklokwaŋ hadêŋ thêlô ek nênêm ŋgôk lelaik vê ênjêk avômalô ma nindum avômalô lijiŋ lôk malaiŋ lomaloma mavi. ");
INSERT INTO hot_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Êntêk ma aposel laumiŋ ba lahavuju takatu iniŋ athêŋ: anyô môŋ ma Saimon, anêŋ athêŋ yaŋ nena Pita, ma yaŋ Andulu; ma Jems loyaŋ Jon, thai ma Sebedi nali; ");
INSERT INTO hot_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ma Pilip, Batolomiu, Tomas, Matyu, anyô hawa takis; ma Jems Alpius nakaduŋ ma Tadius, ");
INSERT INTO hot_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma Saimon, anyô Selot te, ma Judas Iskaliot, ôpatu vêm ma hanaŋ Yisu bêŋ. ");
INSERT INTO hot_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisu hanaŋ abô hadêŋ anyô laumiŋ ba lahavuju takêŋ yôv ma hêv i ba i ma hanaŋ, “Avômalô Samalia iniŋ loŋ lôk avômalô loŋ buyaŋ ma miŋ unu êndêŋ i ami. ");
INSERT INTO hot_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma doŋtom unu êndêŋ boksipsip Islael takatu ba eveŋ mayaliv. ");
INSERT INTO hot_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Unu luvuluvu ba nonaŋ Wapômbêŋ anêŋ abô êndêŋ avômalô nena, ‘Dokte ma Wapômbêŋ anêŋ loŋ lôkliŋyak tem êlêm.’ ");
INSERT INTO hot_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nundum avômalô lôk lijiŋ mavi, ma uŋgwik ŋê ŋama liŋ, ma nundum ŋê lôk palê lepla mabuŋ mavi, ma nônêm ŋgôk vê ênjêk avômalô. Athêŋ bêŋ ma miŋ môlô ôêv vuli ami. Bôk yahêv oyaŋ hadêŋ môlô ba intu nundum ku takêŋ oyaŋ esak avômalô. ");
INSERT INTO hot_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Môlô u hatôm ŋê ku ba mavi ek avômalô neyabiŋ môlô ba intu nombeŋ oyaŋ. Miŋ nobek vak ami. Valuseleŋ mi. Kwêv mi. Veŋ bokŋgôp mi. Ma kôm mi. ");
INSERT INTO hot_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ma môlô ôyô loŋ te ma nômbôlêm anyô wapôm te ba nômô imbiŋ yani endeba notak loŋ êŋ ek unu buyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma ubitak ôyô anêŋ unyak kapô, ma nonaŋ êndêŋ yani lôk anêŋ avômalô nena, ‘Wapômbêŋ anêŋ lamavi êmô imbiŋ môlô.’ ");
INSERT INTO hot_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Avômalô unyak êŋ leŋiŋmavi ba ewa môlô thô, êŋ ma môlônim abô mavi êŋ tem êmô imbiŋ i. Ma doŋtom miŋ leŋiŋmavi ba ewa môlô thô ami, êŋ ma noja unim abô mavi êŋ vê ênjêk i ba unu. ");
INSERT INTO hot_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma avômalô loŋ takatu ba miŋ ewa môlô thô ami lôk êdô nedaŋô môlônim abô, ma waklavôŋ otak loŋ êŋ, ma uŋgwik voŋgovaŋ takatu ba hamô vemimkapô vê êndôk thêlô maleŋiŋ ma unu. ");
INSERT INTO hot_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yanaŋ avanôŋ êndêŋ môlô nena waklavôŋ atu ba Wapômbêŋ endelêm ek endaŋô abô, êŋ ma avômalô loŋ atu ba miŋ ewa môlô thô ami, thêlôniŋ malaiŋ tem êmôŋ ek avômalô kambom anêŋ Sodom lo Gomola. ");
INSERT INTO hot_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Odaŋô! Yahêv môlô hatôm boksipsip ba u ôlôk avuŋ yatap malêvôŋ. Aêŋ ba môlô noja umya iniŋ auk mavi ba nômô mabuŋ êtôm menak bôbô. ");
INSERT INTO hot_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aêŋ ba intu môlô noyabiŋ am ek avômalô! Thêlô tem nebaloŋ môlô ba netak êndôk iniŋ ŋê bêŋbêŋ baheŋiŋ lôk nebali môlô êmô iniŋ unyak yeŋ. ");
INSERT INTO hot_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ma môlô ma yenaŋ avômalô ba intu tem nendom môlô ba unu êndêŋ kiŋ lôk ŋê bêŋbêŋ ek nonaŋ yenaŋ Abô Mavi êndêŋ i lôk avômalô loŋ buyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Ma doŋtom evaloŋ môlô ma môlônim Lemambô anêŋ Lovak Matheŋ tem êmô imbiŋ môlô ba waklavôŋ êŋ ma tem nêm abô êndêŋ môlô ek nonaŋ. Tem miŋ môlôda nonaŋ unim abô ami. Ba intu miŋ nôkô ba nonaŋ nena, ‘Yêlô nanaŋ malê?’ mena ‘nanaŋ aisê?’ ami. ");
INSERT INTO hot_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ma anyô loyaŋ tem yaŋ enaŋ yaŋ bêŋ ek nijik vônô. Ma lambô tem indum aêŋ êndêŋ nakaduŋ. Ma avômena tem nêmbôliŋ dômiŋ êndêŋ lami lo taluvi ba nenaŋ ek nijik i vônô. ");
INSERT INTO hot_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ma môlô ma yenaŋ avômalô. Ba intu avômalô sapêŋ tem nêpôlik esak môlô. Ma doŋtom ŋê takatu ba imiŋ lôklokwaŋ aleba hayô anêŋ daŋ, ma Wapômbêŋ tem nêm i bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aêŋ ba avômalô malak te êv vovaŋ hadêŋ môlô, ma nôsôv ba unu malak yaŋ. Yanaŋ avanôŋ êndêŋ môlô, tem nundum ku êŋ embeŋ Islael denaŋ ma Anyô Anêŋ Nakaduŋ atu tem êlêm. ");
INSERT INTO hot_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Avômena ethak unyak ma miŋ bêŋ ek iniŋ kêdôŋwaga ami. Ma ŋê ku miŋ bêŋ ek iniŋ anyô bêŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Avômalô elam lambô nena, ‘Ŋgôk Bêŋ Belsebul’ êŋ ma tem nindum aêŋ esak yani anêŋ avômalô aêŋ iyom. Avômena ewa kêdôŋwaga iniŋ malaiŋ, êŋ ma hatôm. Ma ŋê ku ewa iniŋ anyô bêŋ anêŋ malaiŋ, êŋ ma hatôm. ");
INSERT INTO hot_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Aêŋ ba miŋ môlô nôkô ek ŋê takatu ba idum kambom takêŋ ami. Nôm takatu ba havuŋi hêk loŋ kapô, tem imbitak yaiŋ. Ma abô takatu ba havuŋi, tem avômalô sapêŋ neyala. ");
INSERT INTO hot_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aêŋ ba abô takatu ba yahanaŋ hadêŋ môlô hadêŋ bôlôvôŋ, êŋ ma nonaŋ êndêŋ lôkwak. Ma abô takatu ba anyô vi enaŋ thikuthik, êŋ ma numiŋ unyak vôv ba nodam ek avômalô nedaŋô. ");
INSERT INTO hot_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Miŋ nôkô ek avômalô ami. Thêlô hatôm nijik lemvimkupik iyom vônô. Ma dahôlômim ma thêlô miŋ hatôm nijik vônô ami. Aêŋ ba intu nôkô ek Anyô Bêŋ iyom! Yani hatôm imbuliŋ môlônim lemvimkupik lôk dahôlômim êndôk loŋ atum lôkmala. ");
INSERT INTO hot_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Avômalô ethak êv vuli menak yaônena hathak valuseleŋ yaô ek eyaŋ. Ma Lemambô lahiki hathak menak yaô takatu ba te hama. ");
INSERT INTO hot_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma doŋtom môlô ma Wapômbêŋ bôk hakatuŋ môlô sapêŋ lemimkadôk ŋauŋ yôv. ");
INSERT INTO hot_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aêŋ ba môlô ma bêŋ ek menak, ba intu miŋ nôkô ami. ");
INSERT INTO hot_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Aêŋ ba ôpatu ba hanaŋ hadêŋ avômalô nena hasopa ya, intu tem yanaŋ imiŋ Wakamik atu ba hamô malak leŋ ma nena, ‘Ôpêntêk ma yenaŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma ôpatu ba hanaŋ hadêŋ avômalô nena hadô esopa ya, intu tem yanaŋ êndêŋ Wakamik atu ba hamô malak leŋ nena, ‘Yahathôŋ ôpêŋ paliŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yahalêm ek yanêm kôm jaŋak êndêŋ môlô! Ba intu miŋ nosoŋ nena yahalêm ek yandum môlô kapôlômim êndôk biŋ ami ma milôk. ");
INSERT INTO hot_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yahalêm ek “‘namalô êmbôliŋ dôm êndêŋ lambô, ma nalavi êmbôliŋ dôm êndêŋ talêbô, ma namalô yanavi êmbôliŋ dôm êndêŋ yaŋavi. ");
INSERT INTO hot_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Anyô te lôk anêŋ thalaleŋ tem nêpôlik esak i.’ ");
INSERT INTO hot_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ma opalê atu ba lahaviŋ lambô lo talêbô bêŋ anôŋ hamôŋ ek ya, ôpêŋ hatôm anyô ôv vathek ba miŋ yenaŋ ami. Ma opalê atu ba lahaviŋ nali bêŋ anôŋ hamôŋ ek ya, ôpêŋ hatôm anyô ôv vathek ba miŋ yenaŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma ôpatu ba miŋ hawa anêŋ alovalaŋaŋsiŋ ba hasopa ya ami, ôpêŋ hatôm anyô ôv vathek ba miŋ yenaŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma opalê atu ba hadum ku bêŋ ek embatho anêŋ lôkmala loŋ, êŋ ma anêŋ lôkmala êŋ tem nêm yak. Ma ôpatu ba hatak anêŋ lôkmala ek hasopa ya, ôpêŋ tem embaloŋ anêŋ lôkmala loŋ. ");
INSERT INTO hot_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ma ôpatu ba hawa môlô thô, êŋ ma hawa ya thô haviŋ. Ma ôpatu ba hawa ya thô, êŋ ma hawa Ôpatu ba hêv ya ba yahalêm thô haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma ôpatu ba hayê plopet te ba hawa thô, êŋ ma tem enja nôm mavi êtôm atu ba plopet êŋ hawa. Ma ôpatu ba hayê anyô thêthôŋ te ba hawa thô, êŋ ma tem enja nôm mavi êtôm atu ba anyô thêthôŋ êŋ hawa. ");
INSERT INTO hot_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma ôpatu ba hayê anyô oyaŋ te hasopa ya ba hêv ŋaŋ thilibuŋ hadêŋ yani, yanaŋ avanôŋ biŋ êndêŋ môlô nena ôpêŋ tem enja anêŋ vuli.” ");
INSERT INTO hot_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ma Yisu hadôŋ anêŋ ŋê ku laumiŋ ba lahavuju yôv, ma hatak loŋ êŋ ma hi hanaŋ Wapômbêŋ anêŋ abô lôk hadôŋ avômalô hamô Galili anêŋ malak nenanena. ");
INSERT INTO hot_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon hamô koladôŋ ma halaŋô abô hathak ku takatu ba Kilisi hadum. Êŋ ma hêv anêŋ ŋê ku doho ba i hadêŋ yani ");
INSERT INTO hot_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ek nenaŋ injik yani liŋ, “O ma Mesia atu ba Wapômbêŋ bôk habutiŋ abô ek nêm êlêm mena yêlô nayabiŋ anyô yaŋ?” ");
INSERT INTO hot_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Êŋ ma Yisu hanaŋ viyaŋ, “Nôbônu ma nonaŋ êndêŋ Jon esak nôm takatu ba mamu olaŋô lo ôyê. Ŋê maleŋiŋ pusip êyê tak, ma ŋê veŋiŋvuviŋ eveŋ, ma ŋê palê lepla ibitak mavi, ma ŋê leŋiŋôndôŋ kôtôŋ elaŋô abô, ma ŋê ŋama iviyô hathak loŋbô, ma avômalô siv elaŋô Wapômbêŋ anêŋ Abô Mavi atu. Ba intu unu nonaŋ êndêŋ Jon esak nôm takêŋ. ");
INSERT INTO hot_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ma ŋê takatu ba êyê ya ba evaloŋ iniŋ êvhaviŋ loŋ, nêmô lôk leŋiŋmavi.” ");
INSERT INTO hot_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon anêŋ ŋê ku êvôi denaŋ, ma Yisu hanaŋ abô hathak Jon hadêŋ avômalô nena, “Bôk môlô u loŋ thiliv ek ôyê malê? Môlô u ek ôyê lovak hayuv baselak vuak e? ");
INSERT INTO hot_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mi. Ma môlô u ek ôyê malê? Môlô u ek ôyê anyô te hik kwêv kêkêlô e? Mi. Ŋê takatu ba ik kwêv kêkêlô, ma êmô kiŋ iniŋ unyak ma miŋ êmô loŋ thiliv ami. ");
INSERT INTO hot_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Môlô u loŋ thiliv ek ôyê malê? Plopet te e? Avanôŋ! Ma doŋtom yanaŋ êndêŋ môlô nena Jon ma bêŋ ek plopet sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bôk eto hathak ôpêŋ hêk Wapômbêŋ anêŋ kapya nena, “‘Odaŋô, tem yanêm yenaŋ anyô ku te êmôŋ ek o, ek enaŋ yenaŋ abô bêŋ ek êpôpêk loŋôndê ek o.’ ");
INSERT INTO hot_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Yanaŋ avanôŋ biŋ êndêŋ môlô nena Jon ma bêŋ ek avômalô pik sapêŋ. Avi te miŋ bôk havathu anyô te aêŋ ami ma mi. Ma doŋtom ôpatu ba yaôna hêk Wapômbêŋ anêŋ loŋ lôkliŋyak, ôpêŋ ma bêŋ ek Jon. ");
INSERT INTO hot_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Ma plopet sapêŋ lôk kapya balabuŋ bôk enaŋ Wapômbêŋ anêŋ abô bêŋ aleba lêk hayô Jon habitak haviŋ. Ma sêbôk aleba lêk ma ôpêŋ hanaŋ abô ma Wapômbêŋ anêŋ loŋ lôkliŋyak halêm hatôm ŋê vovak ibi thêthô i ba i aleba ik vovak ba lovak. ");
INSERT INTO hot_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma môlô lemimhaviŋ nodaŋô plopet takatu iniŋ abô ba nodaŋô! Wapômbêŋ anêŋ kapya hanaŋ nena Elia tem êlêm. Elia êŋ ma Jon. ");
INSERT INTO hot_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aêŋ ba môlô ŋê lôk lemôndôŋ ma nodaŋô abô êntêk katô! ");
INSERT INTO hot_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Yanaŋ aisê esak avômalô bôlôŋ êntêk? Thêlô ma hatôm avômena takatu ba êmô loŋ ethak doŋtom halôk ma elam hi ek avômena vi nena, ");
INSERT INTO hot_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Yêlô abi yeŋ beleŋ ek môlô nondo yeŋ, ma doŋtom miŋ olo yeŋ ami. Ma yêlô alaŋ asêŋ malêŋ ek môlô nodaŋ, ma doŋtom miŋ olaŋ ami.’ ");
INSERT INTO hot_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Ma avômalô bôlôŋ êntêk êtôm avômena takêŋ. Jon halêm ba hathak hatip ek nôm lo waiŋ. Ma môlô ôpôlik hathak yani ba onaŋ nena ŋgôk hamô haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma doŋtom Anyô Anêŋ Nakaduŋ atu halêm ma miŋ hatip ek nôm lo waiŋ ami. Ba intu avômalô êpôlik ba enaŋ, ‘Ôŋgô! Anyô êŋ hathak hayaŋ nôm lôk hanum waiŋ bêŋ anôŋ aleba intu halo molo. Yani ma ŋê idum kambom lôk ŋê ewa takis iniŋ anyô môlô.’ Aêŋ ba Wapômbêŋ anêŋ auk tem injik anôŋ mavi ba avômalô tem nêgê nena auk êŋ ma thêthôŋ anôŋ.” ");
INSERT INTO hot_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yisu bôk hadum nômbithi bêŋ anôŋ yôv hamô malak doho ma avômalô takêŋ miŋ ele kapôlôŋiŋ liliŋ ami. Ba intu Yisu hathaŋ i ");
INSERT INTO hot_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ba hanaŋ, “Alikaknena, môlô avômalô Kolasin lo Betsaida! Môlô bôk ôyê nômbithi lomaloma. Ma doŋtom bôk yandum nômbithi takêŋ êmô Taia lo Saidon malêvôŋ, êŋ ma ketheŋ oyaŋ ma tem nijik kwêv kambom lôk nesav atum ŋgavu esak leŋiŋkadôk ek nede kapôlôŋiŋ liliŋ. ");
INSERT INTO hot_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Odaŋô! Yahanaŋ avanôŋ êndêŋ môlô nena waklavôŋ atu ba Wapômbêŋ endelêm ek endaŋô abô, êŋ ma môlônim malaiŋ tem bêŋ anôŋ êmôŋ ek avômalô Taia lo Saidon iniŋ! ");
INSERT INTO hot_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ma môlô avômalô Kapaneam, tem nêmbô môlônim athêŋ esak leŋ e? Mi, môlô tem unu ŋê ŋama iniŋ loŋ! Môlô bôk ôyê nômbithi lomaloma. Ma doŋtom bôk yandum nômbithi takêŋ êmô Sodom malêvôŋ, êŋ ma tem netak iniŋ kambom ma tem nêmô denaŋ endeba lêk. ");
INSERT INTO hot_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Odaŋô! Yanaŋ avanôŋ! Waklavôŋ atu ba Wapômbêŋ endelêm ek endaŋô alalôaniŋ abô, êŋ ma môlônim malaiŋ tem bêŋ anôŋ êmôŋ ek avômalô Sodom!” ");
INSERT INTO hot_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yôv ma Yisu hanaŋ, “Wakamik, O ma pik lo leŋ anêŋ alaŋ! Lêk huvuŋ anêm auk hadêŋ ŋê lôkauk lôk ŋê bêŋbêŋ, ma huik thô hadêŋ ŋê takatu ba êtôm avômena yaônena. Ba intu yahabô anêm athêŋ! ");
INSERT INTO hot_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wakamik, avanôŋ oda hosopa anêm lemhaviŋ ba intu hudum aêŋ. ");
INSERT INTO hot_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Wakamik bôk hôêv ya auk sapêŋ yôv. Ba anyô late miŋ hayala Nalum atu ami. Mi, O Wakamik iyom. Ma anyô late miŋ hayala O Wakamik katô ami. Mi, Nalum lôk ŋê takatu ba Nalum lahaviŋ injik O thô êndêŋ i iyom. ");
INSERT INTO hot_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Môlô ŋê takatu ba udum ku bêŋ ba owa malaiŋ nôlêm êndêŋ ya ma tem yanêm lovak êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Yahathak yahatauviŋ ya hatôm anyô ku ba intu tem nômô mavi. Ma aseleŋ atu ba yahêv ma vumvum ek noja. Ma vak atu ba yahêv ek nôbô ma miŋ malaiŋ ami. Ba intu nôlêm êndêŋ ya ek noja yenaŋ auk.” ");
INSERT INTO hot_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabat te ma Yisu lôk anêŋ ŋê ku i eveŋ ku kapô te. Ma anêŋ ŋê ku ema kisi ba ewa wit doho hêk ku êŋ kapô ba eyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Palisi doho êyê ma enaŋ, “Ondaŋô! Abô balabuŋ hanaŋ nena Sabat ma miŋ hatôm nandum ku ba naja nôm ek naŋgaŋ ami. Ma doŋtom anêm ŋê ku ibuliŋ waklavôŋ êŋ!” ");
INSERT INTO hot_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma Yisu hanaŋ nena, “Môlô bôk osam abô hathak Devit lôk anêŋ ŋê môlô ema kisi ba idum e? ");
INSERT INTO hot_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yani habitak hayô Wapômbêŋ anêŋ unyak matheŋ kapô ma hayaŋ polom atu ba matheŋ anôŋ. Polom êŋ ma ŋê êbôk da iyom iniŋ ek nejaŋ ba intu habuliŋ abô balabuŋ buêŋ. ");
INSERT INTO hot_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Odaŋô abô te imbiŋ. Môlô bôk osam abô te hamô abô balabuŋ nena Sabat sapêŋ ma ŋê êbôk da idum ku ba êv da hadêŋ Wapômbêŋ. Thêlô ethak ibuliŋ abô balabuŋ bô êntêk hathak Sabat. Ma doŋtom thêlô ma kambom mi. ");
INSERT INTO hot_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aêŋ ba yanaŋ êndêŋ môlô nena nômlate lêk hamô loŋ êntêk ma nômbêŋ lôk ek unyak matheŋ. ");
INSERT INTO hot_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","Môlô bôk osam abô êŋ yôv ba hanaŋ nena, “‘Yaleŋhaviŋ môlô nônêm kapôlômim êndêŋ avômalô ma yahapôlik hathak da.’ “Ya Anyô Anêŋ Nakaduŋ atu ma Sabat anêŋ Alaŋ. Ba intu oyala abô êŋ anêŋ ôdôŋ, ma tem miŋ hatôm notak malaiŋ êyômô ôpatu ba anêŋ kambom mi ami. Mi.” ");
INSERT INTO hot_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yôv ma Yisu hatak buêŋ ma habitak hayô avômalô loŋ êŋ iniŋ unyak yeŋ kapô. Ma anyô baŋ hatyôk te hamô loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma Palisi doho êbôlêm loŋôndê ek nenaŋ Yisu bêŋ ba intu enaŋ hik yani liŋ, “Kapya balabuŋ hanaŋ aisê? Hatôm alalô nandum anyô lôk lijiŋ mavi êndêŋ Sabat mena mi e?” ");
INSERT INTO hot_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma Yisu hanaŋ, “Anyô te anêŋ boksipsip hêv yak halôk lôv hadêŋ Sabat, ma ôpêŋ tem ni edadi boksipsip êŋ imbitak yaiŋ mena mi e? ");
INSERT INTO hot_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Anyô ma bêŋ ek boksipsip. Ba intu kapya balabuŋ hanaŋ nena alalô hatôm nandum anyô mavi êndêŋ Sabat.” ");
INSERT INTO hot_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aêŋ ba Yisu hanaŋ hadêŋ ôpêŋ, “Oto bahem.” Ma hato baŋ ma baŋ vi kambom atu habitak mavi hathak loŋbô hatôm baŋ vi atu mavi. ");
INSERT INTO hot_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Êŋ ma Palisi iviyô ba i ethak doŋtom ma ekak abô ek nêpôm loŋôndê te ek nijik Yisu vônô. ");
INSERT INTO hot_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yisu hayala nôm êŋ ba intu hatak loŋ êŋ ba hi. Ma avômalô bêŋ anôŋ esopa yani ba hadum iniŋ lijiŋ sapêŋ mavi. ");
INSERT INTO hot_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma Yisu hanaŋ lôklokwaŋ hadêŋ thêlô nena miŋ nenaŋ yani bêŋ êndêŋ anyôla ami. ");
INSERT INTO hot_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yisu hanaŋ aêŋ ek Wapômbêŋ anêŋ abô injik anôŋ ba bôk hanaŋ hadêŋ plopet Aisaia nena, ");
INSERT INTO hot_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ôpêntêk ma yenaŋ anyô ku atu ba bôk yahabi yabaheŋ hayô hêk yani yôv. Ôpêŋ ma yaleŋhaviŋ yani bêŋ anôŋ, ma yakapôlôŋ mavi ek yani; tem yanêm yenaŋ Lovak Matheŋ êmô imbiŋ ôpêŋ, ma tem enaŋ bêŋ êndêŋ avômalô nena tem nêm i bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yani ma anyô bônôŋ ba miŋ hathak hanaŋ abô lôk lôklala ami, ma miŋ hathak hanaŋ abô hamô loŋ ekaksa ami. ");
INSERT INTO hot_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma tem miŋ edabêŋ baselak atu hapu ba hêk pik ami, ma miŋ imbi ayôk ŋgathiniŋ ni ami ma mi. Ma tem indum mavi iyom endeba etak kambom sapêŋ nêmô ku mavi vibiŋ am. ");
INSERT INTO hot_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ma avômalô pik sapêŋ tem nênêm maleŋiŋ êndêŋ yani.” ");
INSERT INTO hot_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Vêm ma ewa anyô te atu ŋgôk habuliŋ ba êlêm hadêŋ Yisu. Ŋgôk êŋ hadum ba ôpêŋ madaluk pusip ma abôlêk putup. Ma Yisu hadum ba ôpêŋ madaluk lôk abôlêk hakyav ba hayê tak lôk hanaŋ abô. ");
INSERT INTO hot_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ma avômalô sapêŋ esoŋ kambom ba enaŋ, “Yakô êntêk ma Devit anêŋ Lim Lukmuk atu ba Wapômbêŋ hêv halêm ek nêm alalô bulubiŋ la?” ");
INSERT INTO hot_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma Palisi elaŋô abô êŋ ma enaŋ, “Ŋgôk iniŋ anyô bêŋ Belsebul hêv lôklokwaŋ hadêŋ ôpêŋ. Ba intu hatôm nêm ŋgôk sapêŋ vê ênjêk avômalô.” ");
INSERT INTO hot_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yisu hayala thêlôniŋ auk ba hanaŋ, “Loŋ bêŋ te da iniŋ avômalô evaki vose hi ôdôŋ ju, êŋ ma loŋ bêŋ êŋ tem ênjêk ŋgathiniŋ. Ma malak te evaki vose hi ôdôŋ ju, êŋ ma tem nênêm yak. Ma ôdôŋ te evaki vose hi ôdôŋ ju, êŋ ma tem nênêm yak aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma Sadaŋ hêv anêŋ ŋgôk vê, êŋ ma hatôm evaki vose hi ôdôŋ ju. Ba anêŋ loŋ lôkliŋyak tem imiŋ majaŋ aisê? Mi. ");
INSERT INTO hot_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Môlô onaŋ nena ŋgôk bêŋ Belsebul hêv lôklokwaŋ hadêŋ ya ba yahêv ŋgôk vê. Ma môlônim avômalô idum ku êŋ haviŋ! Ma opalê intu hêv lôklokwaŋ hadêŋ thêlô ba idum ku mavi êŋ? Ŋgôk Bêŋ, e? Mi! Môlôda unim avômalô ik thô nena môlô onaŋ abôyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma doŋtom Wapômbêŋ anêŋ Lovak Matheŋ hêv lôklokwaŋ hadêŋ ya ba yahêv ŋgôk vê hêk avômalô. Aêŋ ba oyala nena Wapômbêŋ anêŋ loŋ lôkliŋyak lêk halêm yôv. ");
INSERT INTO hot_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Odaŋô abô yaŋ imbiŋ. Anyô te hatôm imbitak êyô anyô lôklokwaŋ yaŋ anêŋ unyak kapô ba enja anêŋ nômkama vani e? Mi anôŋ! Ôpêŋ embaloŋ anyô lôklokwaŋ êŋ ba ekak loŋ am, êŋ ma yani hatôm enja anêŋ nômkama vani. ");
INSERT INTO hot_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ôpatu ba miŋ lahaviŋ ya ami, yani êŋ intu hapôlik hathak ya. Ma ôpatu ba miŋ hasup avômalô ba ethak doŋtom ami, êŋ ma hatôm halupuniŋ i. ");
INSERT INTO hot_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Aêŋ ba yanaŋ êndêŋ môlô nena Wapômbêŋ tem nêm avômalô iniŋ kambom lomaloma lôk abôma takatu ba enaŋ hathak Wapômbêŋ vê. Ma doŋtom anyô te hayê Lovak Matheŋ anêŋ ku ba hanaŋ abôma nena, ‘Êntêk ma Ŋgôk Bêŋ anêŋ ku’, êŋ ma Wapômbêŋ miŋ hatôm nêm kambom êŋ vê ênjêk ôpêŋ ami. Ma mi. ");
INSERT INTO hot_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ma anyô te hanaŋ abô kambom hathak Anyô Anêŋ Nakaduŋ atu, ma Wapômbêŋ tem nêm ôpêŋ anêŋ kambom vê. Ma doŋtom anyôla hanaŋ abô kambom hathak Lovak Matheŋ, êŋ ma Wapômbêŋ tem miŋ nêm ôpêŋ anêŋ kambom êŋ vê ami ma ênjêk thêthô. ");
INSERT INTO hot_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Alokwaŋ mavi ma tem injik anôŋ mavi, ma alokwaŋ kambom ma tem injik anôŋ kambom aêŋ iyom. Ma anyô ethak êyê anêŋ anôŋ vêm ma eyala nena alokwaŋ mavi mena kambom. ");
INSERT INTO hot_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Môlô ma umya kambom anêŋ nali ba kapôlômim putup hathak nôm kambom lomaloma atu ba habitak vemimbôlêk. Ba miŋ hatôm nonaŋ abô mavi ami! ");
INSERT INTO hot_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Anyôla hapesaŋ anêŋ nômkama mavi lomaloma ba hamô yani kapô, êŋ ma tem enaŋ abô mavi iyom. Ma anyôla hapesaŋ nômkama kambom lomaloma ba hamô yani kapô, êŋ ma tem enaŋ abô kambom iyom. ");
INSERT INTO hot_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Odaŋô! Yanaŋ êndêŋ môlô! Wapômbêŋ tem êlêm ek endaŋô abô. Ba intu anyô tomtom tem nenaŋ iniŋ kambom takatu ba bôk enaŋ hadêŋ avômalô vi lôk ibuliŋ i bêŋ. ");
INSERT INTO hot_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wapômbêŋ tem endaŋô anêm abô ba enaŋ êndêŋ o nena o anyô thêthôŋ mena o anyô lokbaŋ.” ");
INSERT INTO hot_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Vêm ma Palisi lôk ŋê lôkauk hathak abô balabuŋ doho enaŋ hadêŋ Yisu, “Kêdôŋwaga, yêlô leŋiŋhaviŋ undum lavôŋiŋ te ek injik thô nena Wapômbêŋ hêv o ba hôlêm.” ");
INSERT INTO hot_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Ma Yisu hanaŋ, “Môlô avômalô bôlôŋ êntêk ma avômalô kambom ba miŋ ôêvhaviŋ ya ami. Ba intu lemimhaviŋ yandum lavôŋiŋ ek injik thô nena Wapômbêŋ bôk hêv ya ba yahalêm, ma doŋtom tem mi. Wak lô ma Jona hamiŋ alim ŋgwêk bêŋ te kapô. Ma wak lô aêŋ iyom ma tem Anyô Anêŋ Nakaduŋ atu ênjêk pik kapô. Lavôŋiŋ êŋ iyom intu tem Wapômbêŋ injik thô nena bôk hêv ya ba yahalêm. ");
INSERT INTO hot_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sêbôk ma Jona hanaŋ abô hadêŋ avômalô Ninive ba ele kapôlôŋiŋ liliŋ. Odaŋô! Nômlate lêk hamô loŋ êntêk ma bêŋ hamôŋ ek Jona. Ma môlô miŋ ôêvhaviŋ ami. Ma waklavôŋ atu ba Wapômbêŋ hatak ek nindum abô ma avômalô Ninive tem nenaŋ môlônim kambom takêŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ma sêbôk ma Siba iniŋ kwin hatak anêŋ loŋ ma halêm anêŋ loŋ daim bomaŋ ek endaŋô Solomon anêŋ auk mavi. Odaŋô! Nômlate lêk hamô loŋ êntêk ma bêŋ ek Solomon. Ma doŋtom môlô ôdô anêŋ nodaŋô. Ma waklavôŋ atu ba Wapômbêŋ hatak ek nindum abô ma tem Siba iniŋ kwin êŋ enaŋ môlônim kambom takêŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ŋgôk lelaik hatak anyô te, êŋ ma hi haveŋ loŋ thiliv ek êmbôlêm loŋ mavi te ek enja lovak ba êmô. Ma miŋ hapôm loŋ te ami, ");
INSERT INTO hot_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ma tem enaŋ nena, ‘Yatup siŋ yana unyak sêbôk esak loŋbô.’ Ma hayô ba hayê nena unyak êŋ lêk hamô oyaŋ ma epesaŋ ba lêk habitak mabuŋ mavi. ");
INSERT INTO hot_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Êŋ ma tem ni êmbôlêm ŋgôk baheŋvi ba lahavuju takatu ba iniŋ lôklokwaŋ hamôŋ ek anêŋ ba enja i imbiŋ ek nimbitak nêyô unyak êŋ kapô esak loŋbô. Êŋ ma ôpêŋ tem êmô kambom anôŋ ek yaŋ sêbôk. Ba intu môlô avômalô kambom bôlôŋ êntêk tem nôpôm malaiŋ êŋ imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisu hanaŋ abô hadêŋ avômalô denaŋ ma anêŋ talêbô lôk iviyaŋ leŋiŋhaviŋ nenaŋ abô imbiŋ yani ba intu êlêm imiŋ unyak viyaiŋ. ");
INSERT INTO hot_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma anyô te hi hanaŋ hadêŋ Yisu, “Lemtambô lôk môlôviyaŋ imiŋ yaiŋ ba thêlô leŋiŋhaviŋ nenaŋ abô imbiŋ o.” ");
INSERT INTO hot_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma Yisu hanaŋ, “Opalê intu yenaŋ wakatik lôk aiyaŋ thêlô?” ");
INSERT INTO hot_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Ma habi baŋ hayô hamiŋ anêŋ ŋê ku ba hanaŋ, “Avômalô takatu ba esopa Wakamik atu ba hamô malak leŋ anêŋ lahaviŋ, intu yenaŋ wakatik lôk aiyaŋ ma livôŋ thêlô. Ba intu môlô êntêk ma yenaŋ wakatik lôk aiyaŋ thêlô.” ");
INSERT INTO hot_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wak êŋ iyom ma Yisu hatak unyak atu ma hi hayô kasukthôm anêŋ daŋ ma halôk hamô biŋ. ");
INSERT INTO hot_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma avômalô bêŋ anôŋ ekalabu yani siŋ ba intu hathak yeŋ te ba hi hamô, ma avômalô imiŋ liŋdaŋ habup hathak. ");
INSERT INTO hot_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ma hadôŋ avômalô hathak abô loŋ kapô bêŋ anôŋ. Ba hanaŋ nena, “Anyô te hi hapaliv anêŋ yaŋvêk halôk anêŋ ku. ");
INSERT INTO hot_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yani hapaliv yaŋvêk takêŋ ma vi halôk loŋôndê. Êŋ ma menak êpôm ba eyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma doho halôk valu kikiliŋ ba intu hapup ketheŋ ek malê nena pik dokte iyom. ");
INSERT INTO hot_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma doŋtom wak habi hayô hêk ma hakapok ek malê nena anêŋ ŋgalôk ma bidoŋna. ");
INSERT INTO hot_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma vi halôk loŋ yak lôkmaŋgiŋ kapô ba yak êŋ halumbak hayô yaŋvêk takêŋ vôv. ");
INSERT INTO hot_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma doŋtom vi halôk pik mavi ba hik anôŋ ba vi hatôm 100 ma vi 60 ma vi 30. ");
INSERT INTO hot_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aêŋ ba môlô ŋê lôk lemôndôŋ ma nodaŋô abô êntêk katô!” ");
INSERT INTO hot_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yisu anêŋ ŋê ku i hadêŋ yani ma enaŋ hik yani liŋ, “Aisê ba hothak honaŋ abô loŋ kapô hadêŋ avômalô?” ");
INSERT INTO hot_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma Yisu hanaŋ viyaŋ nena, “Wapômbêŋ lêk hik anêŋ auk loŋ kapô hathak anêŋ loŋ lôkliŋyak thô hadêŋ môlô. Ma miŋ hik thô hadêŋ thêlô ami. ");
INSERT INTO hot_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ba anyô te hayala auk êŋ, ma tem Wapômbêŋ nêm auk doho imbiŋ ba imbitak bêŋ anôŋ. Ma doŋtom anyô te hathôŋ auk êŋ, ma anêŋ auk dokte atu ba ôpêŋ havaloŋ loŋ tem yani nêm vê. ");
INSERT INTO hot_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ba intu yahanaŋ abô loŋ kapô hadêŋ thêlô ba “Êyê, ma doŋtom miŋ êyê katô ami. Elaŋô, ma doŋtom miŋ elaŋô katô ba eyala abô êŋ anêŋ ôdôŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Aêŋ ba Wapômbêŋ anêŋ abô hik anôŋ hatôm bôk ba Aisaia hanaŋ, “‘Avômalô iniŋ auk bôk thekthek ba ibi leŋôndôŋ siŋ ma ivuliv maleŋiŋ siŋ. Wak nômbêŋ intu ma tem nedaŋô abô, ma doŋtom miŋ hatôm neyala anêŋ ôdôŋ ami. Ma wak nômbêŋ intu ma tem nêgê nômlate, ma doŋtom miŋ hatôm nêpôm anêŋ ôdôŋ ami. Ba intu etak kambom êŋ ma tem nêgê esak maleŋiŋ lôk nedaŋô êndôk leŋôndôŋ ma neja ênjêk iniŋ auk ma nede i liliŋ ek yandum thêlô mavi.’ ");
INSERT INTO hot_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma môlô lêk ôyê ya hathak malemim daluk lôk olaŋô ya halôk lemim ôndôŋ. Ba intu lêk ômô mavi. ");
INSERT INTO hot_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Odaŋô! Yanaŋ avanôŋ êndêŋ môlô! Sêbôk ma plopet lôk ŋê thêthôŋ bêŋ anôŋ leŋiŋhiki ek nêgê nôm êntêk ba lêk môlô ôyê, ma doŋtom miŋ êyê ami. Ma leŋiŋhiki ek nedaŋô abô takêntêk ba lêk môlô olaŋô, ma doŋtom miŋ elaŋô ami. ");
INSERT INTO hot_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Aêŋ ba tem yanaŋ abô loŋ kapô hathak epaliv yaŋvêk anêŋ ôdôŋ bêŋ êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Anyô te halaŋô abô hathak Wapômbêŋ anêŋ loŋ lôkliŋyak ma doŋtom miŋ hayala anêŋ ôdôŋ ami, êŋ ma Sadaŋ hayô ba hawa yaŋvêk atu ba Wapômbêŋ havatho halôk yani kapô vê. Êŋ ma hatôm yaŋvêk atu ba halôk loŋôndê. ");
INSERT INTO hot_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","“Ma ôpatu halaŋô abô ba hêvhaviŋ ketheŋ lôk lamavi ma doŋtom malaiŋ lôk vovaŋ hapôm yani hathak Wapômbêŋ anêŋ abô ma hatak anêŋ hêvhaviŋ ketheŋ oyaŋ, êŋ ma hatôm yaŋvêk atu ba hêv yak halôk valu kikiliŋ ba miŋ habi ŋgalôk ami. ");
INSERT INTO hot_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Anyô te halaŋô abô ma doŋtom lahiki bêŋ anôŋ hathak anêŋ lôkmala pik êntêk lôk nômkama lomaloma lôk valuseleŋ. Ma auk takêŋ intu hasivuŋ Wapômbêŋ anêŋ abô ba ôpêŋ miŋ hik anêŋ anôŋ ami. Êŋ ma hatôm yaŋvêk atu ba halôk yak lôkmaŋgiŋ kapô. ");
INSERT INTO hot_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Ma anyô halaŋô Wapômbêŋ anêŋ abô ba hayala anêŋ ôdôŋ êŋ ma tem indum ku ba injik anôŋ mavi êtôm 100 mena 60 mena 30 la. Êŋ ma hatôm yaŋvêk atu ba halôk pik mavi.” ");
INSERT INTO hot_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisu hanaŋ abô loŋ kapô yaŋ nena, “Wapômbêŋ anêŋ loŋ lôkliŋyak ma aêntêk. Anyô te havatho yaŋvêk mavi halôk anêŋ ku. ");
INSERT INTO hot_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma avômalô i êk sôm, ma ôpêŋ anêŋ anyô lamaniŋ te halêm havatho kamuŋ kambom halôk ku kapô êŋ haviŋ ma hi. ");
INSERT INTO hot_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Vêm ma nôm anôŋ hadum ek êyôk, ma kamuŋ kambom êŋ havuak haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ma ŋê eyabiŋ ku i hadêŋ ku alaŋ ma enaŋ hadêŋ yani, ‘Anyô bêŋ, bôk hovatho yaŋvêk mavi halôk anêm ku iyom. Aisê ka kamuŋ kambom habitak haviŋ?’ ");
INSERT INTO hot_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ma yani hanaŋ hadêŋ thêlô, ‘Anyô te lamaniŋ hathak ya ba hadum nôm êŋ.’ “Ma ŋê ku enaŋ hik yani liŋ, ‘Lemhaviŋ yêlô nayavovoŋ ku êŋ e?’ ");
INSERT INTO hot_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ma doŋtom ku alaŋ hanaŋ, ‘Mi. Yahakô môlô noyavovoŋ ba nosapu nôm mavi vê imbiŋ kamuŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Môlô nôndô luvi êmô endeba avômalô nedav nôm am. Êŋ ma tem yanaŋ êndêŋ ŋê ku takatu ba tem nedav nôm nena, “Môlô nusup kamuŋ kambom sapêŋ ba nokak lôkulôku ba nôndô êmô loŋ nêmbôk esak atum. Ma nusup nôm anêŋ anôŋ ba notak êmô unyak nôm hamô.” ’” ");
INSERT INTO hot_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yisu hanaŋ abô loŋ kapô te nena, “Wapômbêŋ anêŋ loŋ lôkliŋyak ma aêntêk. Anyô te hawa ava yaônate ba havatho halôk anêŋ ku kapô. ");
INSERT INTO hot_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ava êŋ ma yaôna lôk, ma doŋtom habitak alokwaŋ daim ba hamôŋ ek nômkama ku kapô vi. Ma menak ethak elav iniŋ unyak halôk anêŋ ŋauŋ.” ");
INSERT INTO hot_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yisu hanaŋ abô loŋ kapô te nena, “Wapômbêŋ anêŋ loŋ lôkliŋyak ma aêntêk. Avi te hawa yis dokte ba hayelaŋ halôk palawa bêŋ anôŋ kapô, ma haveŋ yam ma palawa sapêŋ hathiŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Abô takêntêk ba Yisu hanaŋ hadêŋ avômalô ma hanaŋ hathak abô loŋ kapô iyom ma miŋ hathak hadôŋ i hathak abô yaŋda ami ");
INSERT INTO hot_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ek Wapômbêŋ anêŋ abô injik anôŋ ba hanaŋ hadêŋ plopet nena, “Yaveŋbôlêk tem ekyav ba yanaŋ abô loŋ kapô êndêŋ môlô. Ma yanaŋ Wapômbêŋ anêŋ auk lomaloma takatu ba havuŋ hadêŋ sêbôk ba yani hapesaŋ pik êntêk aleba lêk bêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yôv ma Yisu hatak avômalô ba i ma hi unyak kapô. Ma anêŋ ŋê ku i ek yani ma enaŋ, “Nuŋgwik abô loŋ kapô atu ba hathak kamuŋ kambom habitak ku kapô anêŋ ôdôŋ thô êndêŋ yêlô.” ");
INSERT INTO hot_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Êŋ ma hanaŋ, “Ôpatu ba havatho yaŋvêk mavi, êŋ ma Anyô Anêŋ Nakaduŋ atu. ");
INSERT INTO hot_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma ku kapô ma pik êntêk, ma yaŋvêk mavi ma loŋ lôkliŋyak anêŋ avômalô, ma kamuŋ kambom ma anyô kambom anêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Anyô lamaniŋ atu ba havatho yaŋvêk kambom, yani ma Sadaŋ. Avômalô takatu ba elav nôm, thêlô êŋ ma hatôm aŋela. Nôm hayôk, êŋ ma pik lo leŋ anêŋ daŋ. ");
INSERT INTO hot_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","“Pik lo leŋ anêŋ daŋ hayô ma Anyô Anêŋ Nakaduŋ atu tem nêm anêŋ aŋela ba ini anêŋ loŋ lôkliŋyak atu ba hamô pik êntêk ek neja avômalô kambom takatu ba êvôv avômalô ek nindum kambom lôk avômalô sapêŋ atu ba ethak idum kambom ba nimbi êndôk loŋ atum lôkmala. Thêlô tem nedaŋ kambom ba nesaŋ veŋiŋbôlêk ôdôŋ loŋ. Nôm êŋ hatôm avômalô takatu ba isup kamuŋ kambom ba êbôk hathak atum. ");
INSERT INTO hot_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","“Ma doŋtom avômalô thêthôŋ tem nimbitak êtôm wak anêŋ deda ba nêmô Lambô anêŋ loŋ lôkliŋyak. Aêŋ ba môlô ŋê lôk lemôndôŋ ma nodaŋô abô êntêk katô!” ");
INSERT INTO hot_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Wapômbêŋ anêŋ loŋ lôkliŋyak ma hatôm ku kapo te ba ivuŋ nôm mavi te hamô. Ma anyô te hapôm nôm mavi êŋ. Ma havuŋ halôk loŋbô. Yani lamavi ba hêv anêŋ nômkama sapêŋ ek nênêm vuli. Ma hawa valuseleŋ ba hêv hadêŋ ku atu ba nôm mavi êŋ hamô anêŋ alaŋ ek enja ku êŋ.” ");
INSERT INTO hot_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Abô loŋ kapô te haviŋ nena Wapômbêŋ anêŋ loŋ lôkliŋyak ma aêntêk. Anyô hadum ku valuseleŋ te habôlêm kômkôm kêkêlô ek nêm vuli. ");
INSERT INTO hot_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yani habôlêm aleba hapôm kômkôm kêkêlô anêŋ dôêŋ te ba anêŋ vuli bêŋ anôŋ. Êŋ ma hi hêv anêŋ nômkama sapêŋ ek nênêm vuli. Ma hawa valuseleŋ ba hi hêv kômkôm kêkêlô êŋ hathak.” ");
INSERT INTO hot_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Abô loŋ kapô te hathak loŋbô nena Wapômbêŋ anêŋ loŋ lôkliŋyak ma hatôm aêntêk. Ŋê ibi yakseŋ halôk kasukthôm êvôv alim lomaloma aleba putup. ");
INSERT INTO hot_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Êŋ ma êvôv yakseŋ hathak liŋdaŋ. Ma êlôk êmô ma isup alim mavi halôk vak sam doho. Ma doŋtom alim kambom ma ibi hi. ");
INSERT INTO hot_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ba intu waklavôŋ pik lo leŋ anêŋ daŋ ma Wapômbêŋ tem indum aêŋ iyom. Ba anêŋ aŋela tem nêlêm neja ŋê kambom vê ênjêk ŋê thêthôŋ malêvôŋ ");
INSERT INTO hot_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ba nimbi êndôk loŋ atum lôkmala. Thêlô tem nedaŋ kambom ba nesaŋ veŋiŋbôlêk ôdôŋ loŋ.” ");
INSERT INTO hot_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ma Yisu hanaŋ hik anêŋ ŋê ku liŋ nena, “Môlô lêk oyala abô sapêŋ anêŋ ôdôŋ e?” Ma thêlô enaŋ hadêŋ yani, “Intu êŋ.” ");
INSERT INTO hot_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Êŋ ma yani hanaŋ hadêŋ thêlô, “Anyô lôkauk hathak abô balabuŋ te halaŋô abô ba hawa auk hathak Wapômbêŋ anêŋ loŋ lôkliŋyak, yani êŋ hatôm unyak te anêŋ lambô. Yani hi unyak kapô ba hawa nôm mavi lukmuk lôk bô haviŋ ba hêv hadêŋ avômalô.” ");
INSERT INTO hot_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisu hanaŋ abô loŋ kapô takêŋ yôv ma yani hatak loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma hi yanida anêŋ malak ôdôŋ. Ma hadôŋ avômalô hamô iniŋ unyak yeŋ aleba esoŋ kambom ba enaŋ, “Ôpêntêk hawa auk êntêk anêŋ êsê? Aisê ba yani hatôm idum nômbithi? ");
INSERT INTO hot_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ôpêŋ ma anyô halav unyak te anêŋ nakaduŋ ma anêŋ talêbô ma Malia. Ma anêŋ iviyaŋ ma Jems lo Josep ma Saimon lo Judas. ");
INSERT INTO hot_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma anêŋ livi êmô loŋ êntêk haviŋ. Ma aisê ka anyô êŋ hatôm idum nôm takêŋ?” ");
INSERT INTO hot_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma thêlô enaŋ aêŋ, ma êpôlik hathak yani. Ba intu Yisu hanaŋ hadêŋ thêlô, “Plopet hawa athêŋ bêŋ hêk malak yaŋ. Ma doŋtom anêŋ malak ôdôŋ lôk anêŋ thalaleŋ ma hatôm anyô athêŋ mi.” ");
INSERT INTO hot_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aêŋ ba intu miŋ hadum nômbithi bêŋ anôŋ hêk loŋ êŋ ami ek malê nena thêlô miŋ êvhaviŋ yani ami. ");
INSERT INTO hot_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wak êŋ ma Anyô Bêŋ Helot Antipas halaŋô abô hathak nôm takatu ba Yisu hadum. ");
INSERT INTO hot_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Êŋ ma hanaŋ hadêŋ anêŋ ŋê ku nena, “Ôpêŋ ma Jon anyô hathik ŋaŋ iyom intu haviyô hathak loŋbô. Ba intu yani hawa lôklokwaŋ ba hadum nômbithi takêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Sêbôk ma Helot hawa yaŋ Pilip anêŋ avi Helodias vani. Ba Jon hanaŋ hadêŋ Helot, “Lêk howa avi êntêk vani ba intu hubuliŋ abô balabuŋ.” Êŋ ma Helot hêv anêŋ ŋê ku ba i evaloŋ Jon ba ekak ma êdô hamô koladôŋ. ");
INSERT INTO hot_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Avômalô leŋiŋhabi nena Jon ma plopet te. Ba intu Helot hadum ek injik Jon vônô ma doŋtom hakô ek avômalô. ");
INSERT INTO hot_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anyô doho êlêm eyaŋ nôm haviŋ Helot ek leŋiŋhabi anêŋ waklavôŋ talêbô hawa yani. Ma Helodias nalavi halêm haloyeŋ hamiŋ thêlô malêvôŋ. Ma Helot hayê ba lamavi anêŋ dôêŋ. ");
INSERT INTO hot_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Êŋ ma Helot havak abô haviŋ yani nena, “Yanaŋ avanôŋ biŋ dake nena honaŋ hik ya liŋ hathak nômlate ek yanêm êndêŋ o, êŋ ma tem yanêm iyom.” ");
INSERT INTO hot_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ma talêbô hêv auk hadêŋ nalavi ek enaŋ nena, “Yaleŋhaviŋ Jon wakadôk êndôk belev te ba nêm êndêŋ ya!” ");
INSERT INTO hot_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Ma kiŋ halaŋô ba lamalaiŋ. Ma doŋtom bôk havak abô halôk ŋê bêŋbêŋ maleŋiŋ yôv ba intu hanaŋ hadêŋ ŋê ku ba i koladôŋ ma edabêŋ Jon laselo kisi hatôm atu ba avena hanaŋ. ");
INSERT INTO hot_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma thêlô etak Jon wakadôk halôk belev te ba ewa êlêm êv hadêŋ avi muk atu. Ma yani hawa ba hi hêv hadêŋ talêbô. ");
INSERT INTO hot_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ma Jon anêŋ ŋê ku elaŋô ma êlêm ewa anêŋ liŋkupik ba i elav. Elav vêm ma i enaŋ hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yisu halaŋô abô êŋ vêm ma hatak loŋ êŋ ma hathak yeŋ te ba hi loŋ thiliv bute. Ma avômalô bêŋ anôŋ elaŋô nena yani iyom lêk hi ba intu etak iniŋ malak ma eveŋ yani yam ba i. ");
INSERT INTO hot_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma Yisu hathak liŋ ma hayê avômalô bêŋ anôŋ lêk êmô yôv. Ma lahiki hathak thêlô ba hadum iniŋ ŋê lôk lijiŋ mavi. ");
INSERT INTO hot_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yaŋsiŋ hayô ma anêŋ ŋê ku êlêm ma enaŋ, “Lêk yaŋsiŋ ma alalô amô loŋ thiliv. Ba intu otak avômalô takêntêk ek ini malak takatu ba hamô habobo ek nênêm iniŋ nôm vuli.” ");
INSERT INTO hot_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma doŋtom Yisu hanaŋ nena, “Mi! Thêlô nêmô. Môlô da nobakôŋ i.” ");
INSERT INTO hot_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma doŋtom thêlô enaŋ, “Yêlôaniŋ polom baheŋvi ma alim ju iyom.” ");
INSERT INTO hot_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Êŋ ma Yisu hanaŋ, “Noja nôlêm.” ");
INSERT INTO hot_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma hanaŋ hadêŋ avômalô nena, “Nôndôk nômô kamuŋ takêntêk.” Ma hawa polom baheŋvi lôk alim ju atu ma hêv ma hathak leŋ ma hêv mek. Vêm ma haya polom lôk alim ba hêv hadêŋ anêŋ ŋê ku, ma ŋê ku ewa ba ibi sam ba êv hadêŋ avômalô nômbêŋ atu. ");
INSERT INTO hot_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ma avômalô sapêŋ eyaŋ ba leŋiŋviyak. Ma nôm wata vi atu ba hamô ma ŋê ku isup halôk vak sam laumiŋ ba lahavuju. ");
INSERT INTO hot_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Anyô iyom intu hatôm 5,000 ma avi lo avômena takatu ba eyaŋ nôm êŋ haviŋ miŋ ekatuŋ i ami. ");
INSERT INTO hot_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Vêm ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena nesak yeŋ ba nêmôŋ ba ini kasukthôm vi tuvulu. Ma yanida hamô ek nêm avômalô ba ini am. ");
INSERT INTO hot_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yani hêv avômalô ba i ma hathak dum te ba hi ek eteŋ mek. Bôlôvôŋ hayô ma yani hamô dum êŋ denaŋ. ");
INSERT INTO hot_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma yeŋ lêk hi kasuk malêvôŋ ma lovak hayuv ba hamô yeŋ loŋ hale hi ba intu ŋaŋ budum hik ba yeŋ êŋ halelela liliŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Habobo tem eyaŋ ma yani haveŋ kasuk anêŋ dômlê ba hi hadêŋ anêŋ ŋê ku. ");
INSERT INTO hot_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ma anêŋ ŋê ku êyê yani haveŋ kasuk anêŋ dômlê ma êkô kambom ba enaŋ nena, “Anyôla dahô!” ba elaŋ boloba. ");
INSERT INTO hot_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma ketheŋ oyaŋ ma yani hanaŋ hadêŋ thêlô nena, “Môlô miŋ nôkô ami ma nômô yaô! Ya êntêk!” ");
INSERT INTO hot_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Êŋ ma Pita hanaŋ, “O Anyô Bêŋ Yisu, ma onaŋ ek yambeŋ kasuk anêŋ dômlê ba yasôk êndêŋ o.” ");
INSERT INTO hot_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma Yisu hanaŋ, “Ôlêm.” Êŋ ma Pita hatak yeŋ ma haveŋ kasuk anêŋ dômlê ba hi. ");
INSERT INTO hot_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma doŋtom hayê lovak hayuv ba hakô. Êŋ ma hêv yak halôk kasuk kapô ma halam nena, “Anyô Bêŋ! Nêm ya sa!” ");
INSERT INTO hot_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ketheŋ oyaŋ ma Yisu havaloŋ yani. Ma hanaŋ, “O anyô hôêvhaviŋ yaôna lôk. Hosoŋ nena hatôm yayabiŋ o ami e?” ");
INSERT INTO hot_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma thai ethak yeŋ ma lovak bêŋ êŋ hama. ");
INSERT INTO hot_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aêŋ ba ŋê takatu ba êmô yeŋ elek veŋiŋdôŋ lêlô ma êkôm ba êv yeŋ ba enaŋ, “Avanôŋ biŋ! O ma Wapômbêŋ anêŋ Nakaduŋ.” ");
INSERT INTO hot_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Thêlô ethak liŋdaŋ vi tuvulu anêŋ Genesalet. ");
INSERT INTO hot_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma avômalô loŋ êŋ êyê Yisu ba eyala yani. Ma êv abô haveŋ malak loŋ êŋ sapêŋ. Ma ewa iniŋ ŋê lôk lijiŋ sapêŋ ba i hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma eteŋ Yisu ba enaŋ ek ŋê lôk lijiŋ nêsôm anêŋ kwêv anêŋ daŋ iyom. Ma sapêŋ atu ba êsôm ma ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Palisi lôk ŋê lôkauk hathak abô balabuŋ doho êlêm anêŋ Jelusalem ba i hadêŋ Yisu ma enaŋ hik yani liŋ nena, ");
INSERT INTO hot_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bumalô iniŋ abô majaŋ hanaŋ ek alalô nasik baheŋiŋ vêmam ka miŋ aŋgaŋ nôm ek indum Wapômbêŋ lamavi. Ma aisê ka anêm ŋê ku ibuliŋ abô êŋ ba miŋ ithik baheŋiŋ ami?” ");
INSERT INTO hot_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Êŋ ma Yisu hanaŋ, “Aisê ka môlô ubuliŋ Wapômbêŋ anêŋ abô balabuŋ ba osopa môlôda unim abô majaŋ? ");
INSERT INTO hot_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Hatôm Wapômbêŋ hanaŋ nena, ‘Nodovak lemami lo lemtami’ ma ‘Ôpatu ba hathaŋ lambô lo talêbô hathak abô kambom, ma nijik ôpêŋ vônô.’ ");
INSERT INTO hot_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma doŋtom môlô othak onaŋ nena anyôla hanaŋ hadêŋ lami nena, ‘Yenaŋ nômkama takatu ba hamô ek yanêm mamu sa, êŋ ma bôk yahanaŋ nena tem yanêm êndêŋ Wapômbêŋ êtôm da. ");
INSERT INTO hot_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ba intu miŋ hatôm yanêm mamu sa ami.’ Êŋ ma hatôm môlô ôvôliŋ dômim ek Wapômbêŋ anêŋ abô ba osopa libumi iniŋ bôk lo loŋ. ");
INSERT INTO hot_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Môlô ŋê kambom! Môlô udum ba avômalô esoŋ nena môlô ŋê wapôm. Ma doŋtom môlô ma ŋê paloŋ anôŋ ba plopet Aisaia anêŋ abô lêk hik anôŋ ba hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Avômalô êntêk êbô yenaŋ athêŋ hathak veŋiŋbôlêk oyaŋ. Ma doŋtom kapôlôŋiŋ ma hêk daim bô ek ya. ");
INSERT INTO hot_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Thêlô êv yeŋ oyaŋ hadêŋ ya. Ma ethak enaŋ thêlôda iniŋ abô iyom ba esau nena, “Êntêk ma Wapômbêŋ anêŋ abô.” ’” ");
INSERT INTO hot_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ma Yisu halam avômalô nômbêŋ atu ba êlêm hadêŋ yani ma hanaŋ nena, “Môlô nodaŋô ba noyala katô. ");
INSERT INTO hot_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nôm takatu ba anyô hayaŋ halôk abôlêk miŋ hadum yani habitak lelaik ami. Ma doŋtom nôm takatu ba anyô hanaŋ hale abôlêk intu hadum anyô habitak lelaik.” ");
INSERT INTO hot_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Vêm ma ŋê ku êlêm enaŋ hadêŋ Yisu nena, “Ondaŋô. Palisi elaŋô anêm abô êntêk ba lêk leŋiŋmaniŋ kambom hathak o.” ");
INSERT INTO hot_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma Yisu hanaŋ viyaŋ nena, “Wakamik atu ba hamô malak leŋ tem esapu nôm lôk ŋgalôk takatu ba miŋ yani havatho ami. ");
INSERT INTO hot_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ba miŋ môlô nodaŋô ŋê takêŋ iniŋ abô ami. Thêlô ma ŋê maleŋiŋ pusip ba idum ek nendom avômalô vi embeŋ loŋôndê. Ma anyô mapusip yaŋ halom anyô mapusip yaŋ haveŋ loŋôndê, êŋ ma tem luvi nênêm yak êndôk lôv.” ");
INSERT INTO hot_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Êŋ ma Pita hanaŋ hadêŋ Yisu nena, “Nuŋgwik abô loŋ kapô êŋ anêŋ ôdôŋ thô êndêŋ yêlô.” ");
INSERT INTO hot_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ma Yisu hanaŋ hadêŋ thêlô nena, “Môlô ôthôŋ haviŋ e? ");
INSERT INTO hot_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Odaŋô katô! Nôm takatu ba halôk anyô abôlêk ba hi hamiŋ anyô lasoam vêm ma hale yaiŋ ba hi. ");
INSERT INTO hot_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma doŋtom nôm takatu ba hamô anyô kapô ba hanaŋ hale abôlêk, êŋ ma habitak anêŋ anyô kapô ba intu hadum ôpêŋ habitak lelaik. ");
INSERT INTO hot_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nôm takêntêk intu hamô avômalô kapôlôŋiŋ ba hale yaiŋ: auk kambom lôk ik anyô vônô ma idum sek haviŋ anyô yaŋ yanavi lôk sek waliliŋ ma vani lôk enaŋ abôyaŋ hathak anyô yaŋ ba idum abô ek yani lôk enaŋ abô kambom hathak anyô vi. ");
INSERT INTO hot_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aêŋ ba anyô hayaŋ nôm ba miŋ hathik baŋ ami, nôm êŋ miŋ hadum ba yani habitak lelaik ami. Mi. Kambom takêntêk intu hadum ba ôpêŋ habitak lelaik.” ");
INSERT INTO hot_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisu hatak loŋ êŋ ma hi hamô habobo Taia lo Saidon. ");
INSERT INTO hot_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma avi Kenan te hamô loŋ êŋ ba halêm ma halam nena, “Anyô Bêŋ! Devit anêŋ Lim Lukmuk! Nêm kapôlôm ek ya! Ŋgôk habuliŋ yenaŋ avena kambom anôŋ.” ");
INSERT INTO hot_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma doŋtom yani bônôŋ iyom aleba ŋê ku êlêm ma enaŋ nena, “Avi êntêk halam kaêk haveŋ alalô yam bôsahe! Onaŋ ek yani ni!” ");
INSERT INTO hot_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Êŋ ma hanaŋ viyaŋ nena, “Wapômbêŋ hêv ya ba yahalêm hadêŋ avômalô Islael takatu ba eveŋ mayaliv iyom hatôm bôksipsip.” ");
INSERT INTO hot_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma avi atu halêm ma halek vadôŋ lêlô ma hanaŋ, “Anyô bêŋ, nêm ya sa!” ");
INSERT INTO hot_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma hanaŋ hadêŋ avi êŋ nena, “Kambom ek nakaliv avômena iniŋ nôm êndêŋ avuŋ.” ");
INSERT INTO hot_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Avi êŋ hanaŋ, “Anyô Bêŋ, êŋ ma avanôŋ. Ma doŋtom avuŋ ethak eyaŋ alaŋsi iniŋ nôm mapmap.” ");
INSERT INTO hot_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yisu hanaŋ, “O avi hôêvhaviŋ bêŋ anôŋ ba Wapômbêŋ tem êndôk esak anêm lemhaviŋ.” Ma avi êŋ nalavi habitak mavi hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ma Yisu hatak loŋ êŋ ma habup hathak kasukthôm anêŋ Galili. Vêm ma hathak dumlolê te ba hi hamô. ");
INSERT INTO hot_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma avômalô bêŋ anôŋ êlêm hadêŋ yani ma ewa ŋê veŋiŋvuviŋ, lôk ŋê maleŋiŋ pusip, lôk ŋê veŋiŋ lo baheŋiŋ thotho, lôk ŋê veŋiŋbôlêk putup, lôk ŋê lijiŋ lomaloma ba êdô i hêk Yisu valuvi. Ma yani hadum ba ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma avômalô êyê ŋê veŋiŋbôlêk putup enaŋ abô, lôk ŋê veŋiŋ lo baheŋiŋ thotho ibitak mavi, ma ŋê veŋiŋvuviŋ eveŋ, lôk ŋê maleŋiŋ pusip êyê tak. Ma thêlô esoŋ kambom ba êbô Islael iniŋ Wapômbêŋ anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisu halam anêŋ ŋê ku êlêm ma hanaŋ hadêŋ i nena, “Yaleŋ hik ya hathak avômalô nômbêŋ êntêk. Thêlô bôk êmô haviŋ ya hatôm wak lô ba iniŋ nôm lêk mi. Ma yahadô yanêm thêlô ba ini oyaŋ. Yakô tem maleŋiŋ etaba êndôk loŋôndê ba nênêm yak.” ");
INSERT INTO hot_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma anêŋ ŋê ku enaŋ nena, “Alalô amô loŋ thiliv ma avômalô bêŋ anôŋ ba intu naja nôm anêŋ êsê ba nanêm êndêŋ i?” ");
INSERT INTO hot_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma Yisu hanaŋ hik thêlô liŋ, “Môlônim polom vithê intu hamô?” Ma enaŋ nena, “Polom baheŋvi ba lahavuju lôk alim yaônena tomtom.” ");
INSERT INTO hot_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ma Yisu hanaŋ hadêŋ avômalô nômbêŋ atu nena nêndôk nêmô biŋ. ");
INSERT INTO hot_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Êŋ ma hawa polom baheŋvi ba lahavuju atu lôk alim ma hêv lamavi hadêŋ Wapômbêŋ. Ma haya polom lôk alim ba hêv hadêŋ anêŋ ŋê ku. Ma ŋê ku ewa ba ibi sam hadêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sapêŋ eyaŋ ba leŋiŋviyak ma ŋê ku isup nôm wata halôk vak sam baheŋvi ba lahavuju. ");
INSERT INTO hot_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Anyô iyom intu hatôm 4,000 ma avi lo avômena takatu ba eyaŋ nôm êŋ haviŋ miŋ ekatuŋ i ami. ");
INSERT INTO hot_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yôv ma Yisu hêv avômalô ba i ma hathak yeŋ ba hi Magadala. ");
INSERT INTO hot_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Palisi lo Sadyusi doho êlêm hadêŋ Yisu ek nesaê yani. Ba intu thêlô enaŋ hadêŋ yani nena, “Undum lavôŋiŋ te ek injik thô nena Wapômbêŋ hêv o ba hôlêm mena mi e?” ");
INSERT INTO hot_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma Yisu hanaŋ nena, “Yaŋsiŋ ma môlô othak onaŋ nena, ‘Sômuyum mavi, êŋ ma wak mavi tem ênjêk sawa daim.’ ");
INSERT INTO hot_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma lôkbôk ma môlô othak onaŋ, ‘Wak habi thapuk ba tem ôthôm.’ Môlô oyala leŋlêvôŋ anêŋ kobom katô. Ma doŋtom ku lomaloma takatu ba lêk habitak anêŋ ôdôŋ, ma môlô ôthôŋ paliŋ denaŋ. ");
INSERT INTO hot_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Môlô avômalô bôlôŋ êntêk ma avômalô kambom ba miŋ ôêvhaviŋ ya ami. Môlô lemimhaviŋ yandum lavôŋiŋ ek injik thô nena Wapômbêŋ bôk hêv ya ba yahalêm, ma doŋtom tem mi. Môlô tem nôŋgô Jona anêŋ lavôŋiŋ iyom.” Êŋ ma Yisu hatak thêlô ba hi. ");
INSERT INTO hot_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yisu lôk anêŋ ŋê ku êyô kasukthôm vi tuvulu. Ma anêŋ ŋê ku leŋiŋpaliŋ polom ba miŋ ewa haviŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma hanaŋ hadêŋ thêlô nena, “Noyabiŋ am esak Palisi lo Sadyusi iniŋ yis.” ");
INSERT INTO hot_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma ŋê ku enaŋ abô hadêŋ thêlôda nena, “Alalô miŋ awa polom ami ba intu hanaŋ abô êntêk la.” ");
INSERT INTO hot_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma doŋtom yani hayala iniŋ abô atu ba enaŋ ba hanaŋ, “Môlô ŋê ôêvhaviŋ yaôna lôk. Onaŋ hathak miŋ owa polom ami eka? ");
INSERT INTO hot_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Môlô ôthôŋ denaŋ e? Miŋ lemimhabi polom baheŋvi atu ba avômalô 5,000 bôk eyaŋ ami e? Ma vak sam vithê intu usup nôm wata halôk? ");
INSERT INTO hot_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma polom baheŋvi ba lahavuju ek avômalô hatôm 4,000, ma doŋtom vak sam vithê intu bôk usup nôm wata halôk ba lemimpaliŋ? ");
INSERT INTO hot_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“Môlô ôthôŋ yenaŋ auk denaŋ ba osoŋ nena yahanaŋ abô hathak polom e? Noyabiŋ am ek Palisi lo Sadyusi iniŋ yis!” ");
INSERT INTO hot_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Êŋ ma ŋê ku eyala Yisu anêŋ auk. Yani hanaŋ nena thêlô neyabiŋ i ek Palisi lo Sadyusi takatu ba êdôŋ avômalô hathak auk lokbaŋ. Ma miŋ hanaŋ hathak yis atu ba avômalô eŋgabôm polom hathak ami. ");
INSERT INTO hot_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisu habitak hayô Sisalia Pilipai ma hanaŋ hik ŋê ku liŋ nena, “Avômalô iniŋ auk aisê? Anyô Anêŋ Nakaduŋ atu ma opalê?” ");
INSERT INTO hot_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ma thêlô enaŋ nena, “Doho enaŋ nena o ma Jon anyô hathik ŋaŋ. Ma doho enaŋ nena o Elia. Ma vi enaŋ nena o ma Jelemaia mena plopet bô te.” ");
INSERT INTO hot_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ma hanaŋ hik thêlô liŋ, “Ma môlôda olam ya nena opalê?” ");
INSERT INTO hot_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Êŋ ma Saimon Pita hanaŋ nena, “O ma Mesia, Wapômbêŋ lôkmala anêŋ Nakaduŋ atu ba hêv ek nêm anêŋ avômalô bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma hanaŋ viyaŋ, “Saimon, Jona anêŋ nakaduŋ, lêk hômô mavi. Ek malê nena anyô pik êntêk te miŋ hik auk êŋ thô hadêŋ o ami, ma mi. Wakamik atu ba hamô malak leŋ, yani êŋ intu hik auk êntêk thô hadêŋ o. ");
INSERT INTO hot_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma yanaŋ êndêŋ o nena o ma Pita. Ma tem yandav yenaŋ avômalô takatu ba êvhaviŋ êyô êmô valu êŋ. Ma nômlate miŋ hatôm imbuliŋ avômalô ôdôŋ êŋ ba nema ami ma mi. ");
INSERT INTO hot_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tem yanêm loŋ lôkliŋyak anêŋ vovaleŋ êndêŋ o. Nôm takatu ba hubutiŋ hamô pik ma tem yambutiŋ ênjêk leŋ aêŋ iyom. Ma nôm takatu ba hopole hamô pik ma tem yapole ênjêk leŋ aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma hanaŋ lôklokwaŋ hadêŋ anêŋ ŋê ku ek miŋ nenaŋ êndêŋ anyôla nena yani ma Mesia atu ami. ");
INSERT INTO hot_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pita hanaŋ nena Yisu ma Mesia vêm ma Yisu anêŋ ku yaŋ hayô nena êndôŋ anêŋ ŋê ku, “Tem yasopa Wapômbêŋ anêŋ lahaviŋ ba yana Jelusalem. Ma Islael iniŋ ŋê bêŋbêŋ lôk ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ tem nênêm vovaŋ êndêŋ ya. Ma Wapômbêŋ tem indum ba nijik ya vônô. Ma êtôm wak lô ma tem injik ya liŋ imbiyô esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma Pita hawa yani hi daim dokte ma hathaŋ ba hanaŋ nena, “Anyô Bêŋ, mi anôŋ! Nôm êŋ miŋ hatôm êpôm o ami ma mi anôŋ!” ");
INSERT INTO hot_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yisu hik i liliŋ ma hanaŋ hadêŋ Pita, “Sadaŋ, nu daŋ! Hosopa anyô iniŋ auk iyom ma miŋ hosopa Wapômbêŋ anêŋ auk ami. Ba intu o hatôm gwasilim te atu ba elav ek enja ya êmô.” ");
INSERT INTO hot_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Êŋ ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Anyôla hadum ek esopa ya, êŋ ma êmbôliŋ dôm êndêŋ yanida ma enja anêŋ alovalaŋaŋsiŋ ba esopa ya. ");
INSERT INTO hot_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ek malê nena ôpatu ba lahabi bêŋ anôŋ hathak anêŋ lôkmala pik, anêŋ lôkmala êŋ tem nêm yak. Ma doŋtom ôpatu ba hatak anêŋ lôkmala ek hasopa ya, yani êŋ tem enja lôkmala anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Anyô te hawa nômkama pik sapêŋ ma doŋtom miŋ hasopa Wapômbêŋ anêŋ abô ami ba anêŋ lôkmala hêv yak, êŋ ma tem yani êmô mavi e? Mi anôŋ, tem enja vovaŋ. Ma anyôla hatôm nêm nômlate êndêŋ Wapômbêŋ ek enja anêŋ lôkmala esak loŋbô e? Mi anôŋ! ");
INSERT INTO hot_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Anyô Anêŋ Nakaduŋ atu tem êlêm imbiŋ aŋela ba embaloŋ Lambô anêŋ lôklokwaŋ lôk deda lôkmaŋgiŋ. Êŋ ma tem yani nêm vuli êndêŋ avômalô sapêŋ êtôm ku mavi lôk ku kambom takatu ba bôk thêlô idum yôv anêŋ vuli. ");
INSERT INTO hot_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yanaŋ avanôŋ êndêŋ môlô nena Anyô Anêŋ Nakaduŋ atu tem êlêm imbiŋ anêŋ loŋ lôkliŋyak. Ma môlô vi atu ba lêk umiŋ loŋ êntêk tem nômô lôkmala denaŋ ma ôŋgô nôm êŋ imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wak baheŋvi ba lahavute hale ba hi ma Yisu hawa Pita haviŋ anyô loyaŋ Jems lo Jon ba ethak dumlolê daim bêŋ te ba i. Ma thêlô iyom êmô dumlolê êŋ. ");
INSERT INTO hot_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Êŋ ma Yisu liŋkupik habitak yaŋda hêk thêlô maleŋiŋ. Ma thohavloma hatôm wak anêŋ deda, ma anêŋ kwêv sapêŋ habitak thapuk hatôm deda. ");
INSERT INTO hot_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma ketheŋ oyaŋ ma Mose lo Elia êyô ma enaŋ abô haviŋ Yisu ba thêlô êyê. ");
INSERT INTO hot_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Êŋ ma Pita hanaŋ hadêŋ Yisu, “Anyô Bêŋ, mavi anôŋ ek lêk alalô amô loŋ êntêk. Lemhaviŋ ma tem yandav unyak lôkkupik lokwaŋlô, te ek o ma te ek Mose ma te ek Elia?” ");
INSERT INTO hot_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita hanaŋ abô denaŋ ma buliv mabuŋ anôŋ te hayô hava thêlô siŋ. Ma abô te halêm anêŋ buliv êŋ kapô nena, “Intu ma yenaŋ Okna atu ba yaleŋhaviŋ videdauŋ. Ma ya kapôlôŋ mavi hathak yani. Ba nodaŋô anêŋ abô!” ");
INSERT INTO hot_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ŋê ku elaŋô abô êŋ ma êkô ba elaŋ boloba ba êlôk êk pik. ");
INSERT INTO hot_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma Yisu halêm ma hasôm thêlô ba hanaŋ, “Numbiyô, miŋ nôkô ami.” ");
INSERT INTO hot_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Êŋ ma thêlô esoŋ êyê ma Yisu iyom hamiŋ. Ma anyô ju atu ma mi. ");
INSERT INTO hot_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Vêm ma etak dumlolê êŋ ba êlôk ele i ma Yisu hanaŋ lôklokwaŋ nena, “Môlô miŋ nonaŋ nôm atu ba ôyê bêŋ êndêŋ anyôla ami endeba Wapômbêŋ injik Anyô Anêŋ Nakaduŋ atu liŋ imbiyô ênjêk ŋama esak loŋbô am.” ");
INSERT INTO hot_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ŋê ku enaŋ hik Yisu liŋ nena, “Aisê ka ŋê lôkauk hathak abô balabuŋ enaŋ nena Elia tem êmôŋ ba êlêm vêm ka Mesia?” ");
INSERT INTO hot_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Êŋ ma Yisu hanaŋ, “Avanôŋ! Elia tem êlêm ba indum ku ek nômkama sapêŋ imbitak mavi esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma doŋtom yanaŋ êndêŋ môlô nena Elia bôk halêm yôv. Ma avômalô êthôŋ yani paliŋ ba esopa iniŋ leŋiŋhaviŋ iyom ba idum kambom lomaloma hadêŋ yani. Ma tem nênêm vovaŋ êndêŋ Anyô Anêŋ Nakaduŋ atu aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ŋê ku elaŋô abô êŋ, ma eyala nena Yisu hanaŋ abô hathak Jon anyô hathik ŋaŋ. ");
INSERT INTO hot_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yisu thêlô i êyô ma êyê avômalô bêŋ anôŋ lêk êmô. Ma anyô te halêm hadêŋ Yisu ma halek vadôŋ lêlô hêk yani ma, ");
INSERT INTO hot_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ma hanaŋ, “Anyô Bêŋ, nêm kapôlôm ek yenaŋ okna. Yani hawa lijiŋ hama yak ba hathak hêv yak halôk ŋaŋ lôk atum. Ma vovaŋ bêŋ hathak hapôm yani. ");
INSERT INTO hot_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma yahawa hi hadêŋ anêm ŋê ku, ma doŋtom thêlô miŋ hatôm nindum yani mavi ami.” ");
INSERT INTO hot_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma Yisu hanaŋ, “Yahamô haviŋ môlô sawa daim ma doŋtom miŋ ôêvhaviŋ ami ma owa auk lokbaŋ aleba yakapôlôŋ lêk hagiap hathak môlô. Noja okna êŋ êlêm!” ");
INSERT INTO hot_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma hathaŋ ŋgôk ba ŋgôk hatak okna êŋ ma ketheŋ oyaŋ ma habitak mavi. ");
INSERT INTO hot_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ŋê ku i hadêŋ Yisu ma enaŋ, “Aisê ka yêlô miŋ hatôm nanêm ŋgôk êŋ vê ami?” ");
INSERT INTO hot_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Êŋ ma Yisu hanaŋ, “Môlô miŋ hatôm ami ek malê nena môlônim ôêvhaviŋ ma yaôna lôk ba mi! Ava yaôna ma bêŋ anôŋ ek môlônim ôêvhaviŋ! Yanaŋ avanôŋ êndêŋ môlô. Môlônim ôêvhaviŋ hatôm ava yaônate iyom, êŋ ma hatôm nonaŋ êndêŋ dumlolê êntêk, ‘Umbiyô ba nu buyaŋ’, êŋ ma tem ni. Ma môlô hatôm nundum nômbêŋ intu sapêŋ!” ");
INSERT INTO hot_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yisu lôk anêŋ ŋê ku sapêŋ ethak doŋtom halôk Galili ma hanaŋ hadêŋ i nena, “Tem nenaŋ Anyô Anêŋ Nakaduŋ atu bêŋ ba netak êndôk avômalô baheŋiŋ. ");
INSERT INTO hot_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ma tem nijik yani vônô, ma êtôm wak lô ma tem injik yani liŋ imbiyô esak loŋbô.” Ŋê ku elaŋô abô êŋ ma leŋiŋmalaiŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yisu lôk anêŋ ŋê ku i êyô Kapaneam ma ŋê ewa da unyak matheŋ êlêm ma enaŋ hik Pita liŋ, “Môlônim kêdôŋwaga hathak hêv da unyak matheŋ e?” ");
INSERT INTO hot_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma Pita hanaŋ, “Intu êŋ. Yani hathak hêv.” Ma Pita habitak hayô unyak kapô ma Yisu hanaŋ hik yani liŋ hamôŋ, “Saimon, lemhabi aisê? Pik sapêŋ iniŋ kiŋ ethak ewa da anêŋ opalêla? Thêlôdaniŋ nali mena avômalô vi?” ");
INSERT INTO hot_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ma hanaŋ, “Ewa anêŋ avômalô vi.” Aêŋ ba Yisu hanaŋ, “Nali ma miŋ ethak êv da êŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma doŋtom yahadô alalô nanêm malaiŋ êndêŋ ŋê takêŋ. Ba intu nu kasukthôm ma okaliv lôm. Alim môŋ atu ba hôvôv, êŋ ma onja ba okyav abôlêk. Ma tem nôŋgô valuseleŋ te hamiŋ kapô. Onja valuseleŋ êŋ ba nêm êndêŋ ŋê êŋ ek êtôm da unyak matheŋ.” ");
INSERT INTO hot_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wak êŋ ma ŋê ku êlêm hadêŋ Yisu ma enaŋ hik yani liŋ, “Opalê te tem imbitak anyô lôk athêŋ bêŋ êmô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô?” ");
INSERT INTO hot_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ma Yisu halam amena te halêm ma hadô hamiŋ thêlô malêvôŋ ");
INSERT INTO hot_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ma hanaŋ, “Yanaŋ avanôŋ êndêŋ môlô nena miŋ otak unim kobom ba ubitak hatôm amena êntêk ami, êŋ ma môlô tem miŋ numbitak nôyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ba unu ami. Ma mi. ");
INSERT INTO hot_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aêŋ ba anyô te hatauviŋ i aleba yaôna hatôm amena êntêk, yani êŋ tem imbitak anyô lôk athêŋ bêŋ êmô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô. ");
INSERT INTO hot_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma ôpatu ba hêvhaviŋ ya ba hawa amena te aêntêk thô, ma hatôm hawa ya thô haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ma doŋtom anyô te hadum ba yenaŋ amena atu ba hêvhaviŋ ya te hêv yak, ôpêŋ tem êpôm malaiŋ bêŋ anôŋ. Ôpêŋ tem nêsôkwêŋ valu bêŋ te esak laselo ba nimbi yani êndôk ŋgwêk makidiŋ ba ema. Malaiŋ êŋ ma yaôna ek malaiŋ atu ba yani tem êpôm embeŋ yam. ");
INSERT INTO hot_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Alikaknena môlô avômalô pik êntêk! Nôm lomaloma hamô pik êntêk ba hadum ba môlô udum kambom. Nôm takêŋ tem imbitak. Ma doŋtom ôpatu ba halom anyô vi ba idum kambom, yani êŋ tem êpôm malaiŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Bahem lo vem hadum ba hudum kambom, êŋ ma odabêŋ kisi ba umbini ek miŋ undum kambom esak loŋbô ami! Bahem lo vem vi iyom ma malaiŋ, ma doŋtom mavi ek nu malak leŋ. Ma bahem lo vem luvi hamô ba hudum kambom, êŋ ma lemvimkupik sapêŋ tem ni loŋ atum hathaŋ hamô hatôm wak nômbêŋ intu sapêŋ ba intu malaiŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma malem daluk hadum ba hudum kambom, êŋ ma ômbi vê ba okaliv ni ek miŋ undum kambom esak loŋbô ami! Malem daluk vi iyom ma malaiŋ, ma doŋtom mavi ek nu malak leŋ. Ma malem daluk luvi hamô ba hudum kambom êŋ ma lemvimkupik sapêŋ tem êndôk loŋ atum lôkmala ba intu malaiŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Aêŋ ba noyabiŋ am! Miŋ nosoŋ nena yenaŋ avômena ma nôm oyaŋ ami. Yanaŋ êndêŋ môlô nena iniŋ aŋela ethak êyê nôm takatu ba udum hadêŋ i ma i enaŋ hadêŋ Wakamik atu ba hamô malak leŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ya Anyô Anêŋ Nakaduŋ yahalêm ek yanêm avômalô takatu ba eveŋ mayaliv bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Anyô te anêŋ boksipsip hatôm 100 êmô ba te haveŋ aidoho. Lemhabi aisê? Boksipsip alaŋ tem indum malê? Tem etak 99 takatu ba nêmô dumlolê ma ni êmbôlêm ali atu ba mi. ");
INSERT INTO hot_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yanaŋ avanôŋ êndêŋ môlô! Yani hapôm ali êŋ, ma tem lamavi anêŋ dôêŋ esak ali atu ba hapôm êmôŋ ek 99 takatu ba êmô. ");
INSERT INTO hot_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ma môlônim Lemambô atu ba hamô malak leŋ hadô anyô athêŋ mi te ni loŋ atum lôkmala aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mamuyaŋ hadum kambom hadêŋ o, ma nu êndêŋ yani ma onaŋ anêŋ kambom bêŋ. Yani halaŋô o, êŋ ma mamu ômô hatôm anyô loyaŋ hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma miŋ halaŋô o ami, êŋ ma onja anyô te mena ju la imbiŋ o ba unu êndêŋ yani ma nonaŋ anêŋ kambom êŋ bêŋ esak loŋbô. Anyô ju êŋ tem nimiŋ ba nedaŋô mamunim abô êtôm atu ba Wapômbêŋ bôk hanaŋ yôv. ");
INSERT INTO hot_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yani lêndôŋ kôtôŋ denaŋ, êŋ ma nu onaŋ anêŋ kambom bêŋ êndêŋ avômalô ôdôŋ êvhaviŋ. Ma doŋtom yani lêndôŋ kôtôŋ denaŋ ba hadô endaŋô avômalô ôdôŋ êvhaviŋ iniŋ auk, êŋ ma môlô nôŋgô yani êtôm anyô daluk lôk anyô hawa takis. ");
INSERT INTO hot_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Yanaŋ avanôŋ êndêŋ môlô. Nôm takatu ba ubutiŋ hamô pik ma tem yambutiŋ êmô malak leŋ. Ma nôm takatu ba opole hêk pik ma tem yapole ênjêk malak leŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","“Odaŋô! Anyô ju mena lu la ethak doŋtom hathak yenaŋ athêŋ, êŋ ma yada tem yamô i malêvôŋ. Ba intu te mena ju la kapôlôŋiŋ doŋtom hathak nômlate ba eteŋ mek, ma yenaŋ Wakamik atu ba hamô malak leŋ tem indum nôm êŋ anôŋ.” ");
INSERT INTO hot_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Vêm ma Pita halêm ma hanaŋ hik Yisu liŋ, “Anyô Bêŋ, yenaŋ aiyaŋ hadum kambom hadêŋ ya, êŋ ma yatak yakapôlôŋ bôlôŋ vithê? Bôlôŋ baheŋvi ba lahavuju, e?” ");
INSERT INTO hot_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma Yisu hanaŋ, “Yanaŋ êndêŋ o. Otak kapôlôm ek mamuyaŋ êtôm wak nômbêŋ intu sapêŋ, ma miŋ bôlôŋ baheŋvi ba lahavuju ami! ");
INSERT INTO hot_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Wapômbêŋ anêŋ loŋ lôkliŋyak ma hatôm kiŋ te hadum ek anêŋ ŋê ku nêlêm nêwê anêŋ valuseleŋ viyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wak êŋ hayô, ma ewa anyô ku atu halêm. Ôpêŋ bôk hayaŋ kiŋ anêŋ valuseleŋ vithê ba hathôŋ paliŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yani miŋ hatôm nêm viyaŋ ami ba intu kiŋ hanaŋ nena nênêm ôpêŋ lôk veŋi lôk nali ba nimbitak êtôm anyô yaŋ anêŋ ŋê ku oyaŋ ek nênêm valuseleŋ êŋ viyaŋ. Ma nênêm anêŋ nômkama sapêŋ ba anyô vi nênêm vuli ma neja valuseleŋ esak ba nêwê kiŋ anêŋ valuseleŋ êŋ viyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Êŋ ma ôpêŋ hêv yak halôk hêk yani valuvi ma halaŋ nena, ‘Oyabiŋ vêmam! Valuseleŋ takatu ba yahawa hêk o ma tem yanêm viyaŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma kiŋ lahiki ba hanaŋ, ‘Viyaŋ dôlôk!’ Ma hatak ôpêŋ ba hi. ");
INSERT INTO hot_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Anyô ku êŋ hatak kiŋ anêŋ unyak ma hi hapôm anyô ku yaŋ ba thainiŋ ku hatôm doŋtom. Anyô yaŋ hawa valuseleŋ yaôna lôk hêk yani ba miŋ bôk hêv ami. Êŋ ma yani havaloŋ ôpêŋ ba hakakô laselo siŋ lôklokwaŋ ma hathaŋ ba hanaŋ, ‘Yenaŋ valuseleŋ êlêm!’ ");
INSERT INTO hot_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ma yaŋ êŋ hêv yak halôk hêk yani valuvi ma halaŋ nena, ‘Oyabiŋ vêmam! Tem yanêm anêm valuseleŋ êŋ viyaŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ma doŋtom ôpêŋ hapôlik hathak yaŋ êŋ anêŋ abô ba hawa ba hi hatak halôk koladôŋ endeba ôpêŋ nêm valuseleŋ êŋ viyaŋ am. ");
INSERT INTO hot_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ŋê ku vi êyê nôm atu ba ôpêŋ hadum ba esoŋ kambom ma leŋiŋmalaiŋ bêŋ ba i enaŋ hadêŋ kiŋ. ");
INSERT INTO hot_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Êŋ ma kiŋ halam ôpêŋ ba halêm ma hanaŋ, ‘O anyô kambom anôŋ! Holaŋ bêŋ hadêŋ ya aleba yahatak o ba miŋ hôwê anêm valuseleŋ viyaŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yaleŋ hik ya hathak o, ma aisê ka miŋ hudum aêŋ hadêŋ mamuyaŋ ami?’ ");
INSERT INTO hot_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma kiŋ lamaniŋ ba hatak ôpêŋ halôk ŋê takatu ba eyabiŋ koladôŋ ek thêlô nênêm vovaŋ êndêŋ yani endeba nêm valuseleŋ êŋ viyaŋ am. ");
INSERT INTO hot_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Aêŋ ba môlô tomtom lemimmavi ba notak unim kapôlômim kambom ek môlôviyaŋ. Yakô Wakamik atu ba hamô malak leŋ tem indum aêŋ êndêŋ o êtôm atu ba kiŋ hadum hadêŋ anêŋ anyô ku atu.” ");
INSERT INTO hot_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisu hanaŋ abô takêŋ vêm ma hatak Galili ma hi ŋaŋ Jolodaŋ vi tuvulu hêk Judia. ");
INSERT INTO hot_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma hamô loŋ êŋ ma avômalô bêŋ anôŋ êyô. Ma hadum ŋê lôk lijiŋ ba ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma Palisi doho êlêm hadêŋ Yisu ma idum ek nesau yani ba enaŋ hik yani liŋ, “Abô balabuŋ hanaŋ aisê? Anyô hatôm nêm yanavi vê esak ôdôŋ lomaloma mena mi e?” ");
INSERT INTO hot_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma doŋtom Yisu hanaŋ, “Môlô bôk osam Wapômbêŋ anêŋ abô atu ba hanaŋ nena, ‘Sêbôk ba môŋ anôŋ atu ba Wapômbêŋ hapesaŋ avômalô ma hapesaŋ anyô lo avi. ");
INSERT INTO hot_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ba intu Wapômbêŋ bôk hanaŋ nena, “Anyô tem etak lambô lo talêbô ma esak doŋtom imbiŋ yanavi ek thai nimbitak êtôm kupik doŋtom iyom.” ’ ");
INSERT INTO hot_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Thai miŋ ju hathak loŋbô ami ma lêk ibitak doŋtom. Aêŋ ba nôm atu ba Wapômbêŋ bôk havak loŋ hathak doŋtom ma miŋ hatôm anyôla epole vê ami.” ");
INSERT INTO hot_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma Palisi enaŋ, “Ma doŋtom Mose bôk hanaŋ nena anyô hadum ek êndô yanavi ma eto kapya nêm yanavi vê ba nêm êndêŋ yanavi ek nêm yani vê.” ");
INSERT INTO hot_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma Yisu hanaŋ, “Môlô ŋê lemimôndôŋ kôtôŋ. Ba intu Mose hik loŋôndê êŋ thô hadêŋ môlô. Môŋ anôŋ atu ba Wapômbêŋ hapesaŋ pik êntêk, ma auk êŋ miŋ hamô haviŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yanaŋ êndêŋ môlô nena anyô te yanavi miŋ hadum sek ami, ma doŋtom yamalô hadô yanavi ba hawa avi yaŋ. Anyô êŋ hadum sek haviŋ avi yaŋ êŋ.” ");
INSERT INTO hot_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ŋê ku enaŋ hadêŋ Yisu, “Aêŋ ba anyô muk hamô mavi ek anyô lôk avi.” ");
INSERT INTO hot_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma hanaŋ hadêŋ thêlô, “Anyô sapêŋ miŋ hatôm nedaŋô abô êŋ ami. Ôpatu ba Wapômbêŋ hêv lôklokwaŋ hadêŋ i iyom intu hatôm nedaŋô abô êŋ. ");
INSERT INTO hot_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Anyô doho ma taluvi ewa i ba malaiŋ hamô ba miŋ hatôm neja avi ami. Doho ma êvê iniŋ thalôk vê ek neyabiŋ kiŋ iniŋ vêŋi. Ma doho leŋiŋhaviŋ nênêm iniŋ lôklokwaŋ lôkthô ek nindum Wapômbêŋ anêŋ loŋ lôkliŋyak anêŋ ku ba intu miŋ ewa avi ami. Ôpatu ba halaŋô abô êŋ ba hasopa, ma esopa iyom.” ");
INSERT INTO hot_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Avômalô doho ewa avômena yaônena êlêm ek Yisu etak baŋ êyô ênjêk thêlô ba nêm mek esak i. Ma doŋtom anêŋ ŋê ku ethaŋ avômalô takêŋ. ");
INSERT INTO hot_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Êŋ ma Yisu hanaŋ, “Notak avômena yaônena ba nêlêm êndêŋ ya ma miŋ numiŋ thêlô loŋ siŋ ami ek malê nena avômalô takatu ba athêŋ mi ma hatôm avômena takêntêk ba Wapômbêŋ anêŋ loŋ lôkliŋyak ma thêlôniŋ.” ");
INSERT INTO hot_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Êŋ ma hatak baŋ hayôhêk i vêm ma hatak loŋ êŋ ba hi. ");
INSERT INTO hot_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Anyô te halêm hadêŋ Yisu ma hanaŋ, “Kêdôŋwaga, yandum malê mavi te ek yamô lôkmala êtôm wak nômbêŋ intu sapêŋ?” ");
INSERT INTO hot_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ma Yisu hanaŋ, “Anyô te iyom intu mavi! Ma honaŋ hik ya liŋ hathak abô ‘mavi’ êŋ eka? Lemhaviŋ onja lôkmala atu ba hamô hatôm wak nômbêŋ intu, êŋ ma osopa Wapômbêŋ anêŋ abô balabuŋ.” ");
INSERT INTO hot_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma ôpêŋ hanaŋ hik yani liŋ nena, “Yasopa abô balabuŋ alisê?” Êŋ ma Yisu hanaŋ, “‘Miŋ nuŋgwik anyô vônô ami. Miŋ undum sek imbiŋ anyô yaŋ yanavi ami. Miŋ onja vani ami. Miŋ onaŋ abôyaŋ esak anyô vi ba undum abô ek i ami. ");
INSERT INTO hot_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ondovak lemambô lo lemtambô.’ Ma ‘lemimbiŋ avômalô vi êtôm lemhaviŋ oda.’” ");
INSERT INTO hot_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma anyô muk êŋ hanaŋ, “Abô balabuŋ takêŋ, ma yahathak yahasopa. Yandum malê te imbiŋ?” ");
INSERT INTO hot_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma Yisu hanaŋ, “Lemhaviŋ nuŋgwik anêm ku anêŋ daŋ siŋ, êŋ ma nu nêm anêm nômkama sapêŋ ek avômalô nênêm vuli. Ma onja valuseleŋ sapêŋ ba nêm êndêŋ avômalô siv. Hudum aêŋ, ma tem anêm nômkama mavi lomaloma êmô malak leŋ. Ma ôlêm osopa ya.” ");
INSERT INTO hot_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Anyô muk êŋ ma anyô lôk nômkama bêŋ anôŋ. Ba intu halaŋô abô êŋ ma hêv malaiŋ bêŋ hadêŋ yani ba hi lôk lamalaiŋ. ");
INSERT INTO hot_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Êŋ ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Yanaŋ avanôŋ êndêŋ môlô nena ŋê lôk nômkama bêŋ tem nêpôm malaiŋ bêŋ ek nimbitak nêyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ba ini. ");
INSERT INTO hot_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Odaŋô! Miŋ malaiŋ bêŋ ek bok kamel imbitak êyô luvik idu sôp anêŋ abyaŋ ba ni ami, ma doŋtom malaiŋ anôŋ ek anyô lôk nômkama bêŋ te imbitak êyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô.” ");
INSERT INTO hot_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ŋê ku elaŋô abô êŋ ma esoŋ kambom ba enaŋ, “Avanôŋ e? Aêŋ ba miŋ hatôm anyôla imbitak êyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ba ni ami e?” ");
INSERT INTO hot_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma Yisu hayê thêlô lôklokwaŋ ma hanaŋ, “Wapômbêŋ iyom hatôm indum nômkama sapêŋ. Ma anyô te miŋ hatôm nêm yanida bulubiŋ ami ma mi.” ");
INSERT INTO hot_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ma Pita hanaŋ, “Yêlô bôk atak yêlôaniŋ nômkama sapêŋ ba alêm asopa o ba intu tem naja malê?” ");
INSERT INTO hot_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma Yisu hanaŋ hadêŋ i, “Yanaŋ avanôŋ êndêŋ môlô! Wak te ma Wapômbêŋ tem epesaŋ loŋ lukmuk. Ma Anyô Anêŋ Nakaduŋ atu tem êmô loŋ êŋ ba eyabiŋ anêŋ avômalô êtôm kiŋ lôkmaŋgiŋ. Ma môlô anyô ku laumiŋ ba lahavuju takatu ba osopa ya, môlô tem noyabiŋ avômalô Islael ôdôŋ laumiŋ ba lahavuju êtôm kiŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma avômalô takatu ba leŋiŋhabi ya ba etak iniŋ unyak lôk iviyaŋ ma livi lôk lami ma taluvi lôk iniŋ nali lôk iniŋ ku, êŋ ma tem Wapômbêŋ nêm bêŋ anôŋ êndêŋ i êtôm 100 êyô êmô iniŋ loŋ imbiŋ. Ma thêlô tem neja lôkmala atu ba nêmô êtôm wak nômbêŋ intu sapêŋ imbiŋ. ");
INSERT INTO hot_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Odaŋô! Ŋê lôk athêŋ bêŋ, bêŋ anôŋ tem nimbitak ŋê lôk athêŋ mi. Ma ŋê lôk athêŋ mi bêŋ anôŋ tem nimbitak ŋê lôk athêŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yisu hanaŋ, “Wapômbêŋ anêŋ loŋ lôkliŋyak ma hatôm aêntêk. Lôkbôk momaŋiniŋ ma ku te anêŋ alaŋ hi ek êmbôlêm ŋê ku ek nindum ku embeŋ anêŋ ku kapô. ");
INSERT INTO hot_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yani hapôm anyô doho ma hanaŋ hik i liŋ ek nindum anêŋ ku êtôm wak daluk te ma nêm i vuli esak valuseleŋ doŋtom ma êlôk hathak anêŋ abô. Yôv ma hêv thêlô ba i anêŋ ku kapô. ");
INSERT INTO hot_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Wak hathak leŋ ma hi loŋ ethak doŋtom halôk ma hayê anyô doho atu ba ida êmô iyom. ");
INSERT INTO hot_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma hanaŋ hadêŋ thêlô, ‘Môlô nu nundum yenaŋ ku, ma tem yanêm môlô vuli êtôm unim ku.’ ");
INSERT INTO hot_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Êŋ ma i. “Waklêvôŋ biŋ ma hi hadum aêŋ ma habobo wak êndôk ma hi hadum aêŋ hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yaŋsiŋ ma hayê anyô doho ida êmô iyom ma hanaŋ, ‘Aisê ka môlô ômô oyaŋ wak daluk êntêk?’ ");
INSERT INTO hot_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma enaŋ, ‘Anyô te miŋ hêv ku hadêŋ yêlô ami.’ “Ma ku alaŋ hanaŋ, ‘Môlô nu nundum yenaŋ ku imbiŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Bôlôvôŋ hayô ma ku alaŋ hanaŋ hadêŋ anyô hayabiŋ ku, ‘Ondam ŋê takatu ba idum ku nêlêm ek nêm i vuli. Ŋê yaŋsiŋ êmôŋ ma ŋê wak halôk êyô ênjêk vêm ma ŋê waklêvôŋ ma ŋê lôkbôk ma embeŋ yam anôŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ŋê yaŋsiŋ êlêm ma hêv i valuseleŋ doŋtom. ");
INSERT INTO hot_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma ŋê lôkbôk esoŋ nena tem neja valuseleŋ esak. Ma doŋtom mi. Ewa hatôm doŋtom. ");
INSERT INTO hot_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ewa iniŋ vuli yôv, ma thêlô enaŋ abô munuŋmunuŋ hathak ku alaŋ ba enaŋ, ");
INSERT INTO hot_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aisê ba yêlô alêm hadêŋ lôkbôk ba adum ku bêŋ lôk vovanik hamiŋ wak mathalaleŋ. Ma ŋê yaŋsiŋ idum ku yaôna lôk. Ma doŋtom ewa valuseleŋ hatôm yêlôaniŋ!’ ");
INSERT INTO hot_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Êŋ ma ku alaŋ hanaŋ hadêŋ anyô te nena, ‘Aiyaŋ, miŋ yahadum kambom hadêŋ o ami. Bôk yahanaŋ ba hôlôk nena undum ku ma tem onja valuseleŋ doŋtom iyom. ");
INSERT INTO hot_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yenaŋ yaleŋhaviŋ ba yahêv ŋê takatu ba eveŋ yam iniŋ vuli hatôm môlônim. Aêŋ ba onja anêm ba nu! ");
INSERT INTO hot_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Valuseleŋ êntêk ma yenaŋ ba intu hatôm yasopa yenaŋ yaleŋhaviŋ iyom ek yanêm. Ma môlô malemim thêlêv eka?’ ");
INSERT INTO hot_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Aêŋ ba ŋê êmôŋ tem nimbitak êtôm ŋê eveŋ yam. Ma ŋê eveŋ yam tem nimbitak êtôm ŋê êmôŋ.” ");
INSERT INTO hot_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yisu hi Jelusalem ma hawa anêŋ ŋê ku laumiŋ ba lahavuju takatu. Thêlô eveŋ ba i ma Yisu havôv thêlô i daŋ vi ma hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Odaŋô. Alalô a daku Jelusalem. Ma tem nenaŋ Anyô Anêŋ Nakaduŋ atu bêŋ ba nênêm yani êndêŋ ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ. Ma tem nenaŋ ek nijik yani vônô. ");
INSERT INTO hot_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tem nênêm ya êndêŋ avômalô loŋ buyaŋ ek nenaŋ abôma lôk nebali ya ma nijik ya vônô esak a. Ma êtôm wak lô, ma tem injik ya liŋ ba yambiyô esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Vêm ma Sebedi anêŋ nakaduŋ ju atu iniŋ talêbô halêm hadêŋ Yisu. Ma halek vadôŋ lêlô ma hadum ek enaŋ injik yani liŋ esak abô te. ");
INSERT INTO hot_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Êŋ ma Yisu hanaŋ, “Lemhaviŋ malê te?” Ma avi êŋ hanaŋ, “Tem otak yenaŋ okna ju êntêk yaŋ sê êmô bahem vianôŋ ma yaŋ sê êmô bahem vikeŋ ênjêk anêm loŋ lôkliŋyak kapô?” ");
INSERT INTO hot_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma hanaŋ hadêŋ anyô loyaŋ, “Mamu ôthôŋ nôm atu ba onaŋ hik ya liŋ paliŋ. Hatôm nunum êndôk tase atu ba tem yanum e?” Ma thai enaŋ, “Yai hatôm.” ");
INSERT INTO hot_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ma hanaŋ nena, “Avanôŋ, tase êŋ tem nunum êndôk. Ma doŋtom nêmô yabaheŋ vianôŋ lôk vikeŋ, ma miŋ yenaŋ ku ami. Mi, Wakamik da hayabiŋ ku êŋ ba bôk hatak anyô doho yôv ek nêmô loŋ êŋ.” ");
INSERT INTO hot_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ŋê ku laumiŋ takêŋ elaŋô abô êŋ ba leŋiŋŋaŋa hadêŋ Jems lo Jon. ");
INSERT INTO hot_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ma Yisu halam thêlô êlêm ethak doŋtom ma hanaŋ, “Môlô bôk oyala nena avômalô loŋ buyaŋ iniŋ kiŋ ethak ebam i ba ibuliŋ ŋê takatu ba êmô thêlô vibiŋ. Ma iniŋ ŋê bêŋbêŋ ethak ethaŋ iniŋ avômalô aêŋ iyom ek nesopa iniŋ abô. ");
INSERT INTO hot_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Odaŋô! Môlô miŋ nundum kobom êŋ ami! Môlô te lahaviŋ imbitak anyô lôk athêŋ bêŋ ênjêk môlô malêvôŋ, êŋ ma imbitak êtôm môlônim anyô ku ek nêm môlô sa. ");
INSERT INTO hot_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma ôpatu lahaviŋ imbitak êtôm môlônim anyô bêŋ, êŋ ma êmô êtôm môlônim anyô ku oyaŋ ");
INSERT INTO hot_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","hatôm ya Anyô Anêŋ Nakaduŋ atu ba yahadum aêŋ iyom. Miŋ yahalêm ek yandum ŋê bêŋbêŋ pik iniŋ kobom ba yasaŋ avômalô ek nindum yenaŋ ku ami. Mi anôŋ! Yahalêm hatôm anyô ku ek yanêm avômalô sa lôk yatak yenaŋ lôkmala ek nêm avômalô bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yisu lôk anêŋ ŋê ku etak Jeliko ba i ma avômalô bêŋ anôŋ esopa yani. ");
INSERT INTO hot_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma anyô maleŋ pusip lokwaŋju êmô loŋôndê daŋ vi, ma thai elaŋô nena Yisu halêm. Êŋ ma thai elam lôklokwaŋ nena, “Anyô Bêŋ! Devit anêŋ Lim Lukmuk! Nêm kapôlôm ek yai!” ");
INSERT INTO hot_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma avômalô ethaŋ thai ba enaŋ, “Mamu bônôŋ!” Ma doŋtom thai elam lôklala nena, “Anyô Bêŋ! Devit anêŋ Lim Lukmuk! Nêm kapôlôm ek yai!” ");
INSERT INTO hot_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Êŋ ma Yisu hamiŋ ma halam thai ba hanaŋ, “Lemimhaviŋ yandum malê êndêŋ mamu?” ");
INSERT INTO hot_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma thai enaŋ nena, “Anyô Bêŋ, yai leŋiŋhaviŋ nagê tak!” ");
INSERT INTO hot_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Êŋ ma Yisu lahiki hathak thai ba hatak baŋ hayô hêk maleŋiŋ daluk. Ma ketheŋ oyaŋ ma thai ibitak mavi ba êyê tak ma i esopa yani. ");
INSERT INTO hot_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yisu thêlô i ebobo Jelusalem ma i êyô Betpagi, malak êŋ hêk habobo Dum Oliv. Ma hêv anêŋ ŋê ku ju ba i ");
INSERT INTO hot_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma hanaŋ nena, “Mamu unu malak entuvulu. Ma ketheŋ oyaŋ ma tem ôŋgô bok doŋki te lôk nakaduŋ ba ekak luvi loŋ ba imiŋ. Nopole yak vê ma nodom luvi ba nôlêm êndêŋ ya. ");
INSERT INTO hot_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma anyôla hanaŋ abôla hadêŋ mamu, ma nonaŋ nena, ‘Anyô Bêŋ lahaviŋ indum ku te esak luvi’, êŋ ma tem êndôk ba etak luvi ek nêlêm ketheŋ.” ");
INSERT INTO hot_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nôm êŋ habitak ek Wapômbêŋ anêŋ abô injik anôŋ ba hanaŋ hadêŋ plopet nena, ");
INSERT INTO hot_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nonaŋ abô êŋ êndêŋ avômalô Saion, ‘Ôŋgô. Môlônim kiŋ lêk halêm hadêŋ môlô. Ôpêŋ anyô labali ba hayô hamô bok doŋki te. Yani hayô hamô bok doŋki nakaduŋ te ba halêm.’” ");
INSERT INTO hot_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma ŋê ku ju atu i ma idum hatôm atu ba Yisu hanaŋ. ");
INSERT INTO hot_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ma ewa doŋki talêbô lôk nakaduŋ êŋ ba i ma ibi iniŋ kwêv thilibuŋ daim thô ba eŋgava hayôhêk bok doŋki dômlokwaŋ ma Yisu hayô hamô. ");
INSERT INTO hot_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma avômalô lubuŋlubuŋ eŋgava iniŋ kwêv thilibuŋ hêk loŋôndê. Ma vi ele nôkyalô ŋauŋ ba eŋgava hêk loŋôndê. ");
INSERT INTO hot_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ma vi êmôŋ ma vi eveŋ yam ma Yisu halôk malêvôŋ ba leŋiŋmavi anôŋ ba lôk lêlô ba elam nena, “Osana ni êndêŋ Devit anêŋ Lim Lukmuk!” “Wapômbêŋ nêm lamavi êndêŋ ôpatu ba halêm hathak Anyô Bêŋ anêŋ athêŋ!” “Osana! Nambô Wapômbêŋ anêŋ athêŋ esak leŋ!” ");
INSERT INTO hot_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yisu habitak hayô Jelusalem kapô ma avômalô nômbêŋ atu ba êmô Jelusalem esoŋ kambom ba enaŋ hik liŋ mayaliv nena, “Ôpêntêk ma opalê?” ");
INSERT INTO hot_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma avômalô nômbêŋ atu ba esopa Yisu enaŋ nena, “Yani ma Yisu, plopet atu ba halêm anêŋ malak Nasalet hêk Galili.” ");
INSERT INTO hot_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yisu habitak hayô unyak matheŋ kapô anêŋ piklêvôŋ ma hayê avômalô ewa nômkama ba êdô hamô ek avômalô vi nênêm vuli. Êŋ ma halupuniŋ i ba hêv i vê hêk unyak matheŋ kapô ba ele yaiŋ ba i. Ma hale ŋê takatu ba êwê ŋê loŋ buyaŋ iniŋ valuseleŋ hathak Hiblu iniŋ valuseleŋ iniŋ balê liliŋ. Ma hadum aêŋ hadêŋ ŋê takatu ba êdô menak bôbô hamô ek avômalô vi nênêm vuli. ");
INSERT INTO hot_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma hanaŋ hadêŋ thêlô aêntêk, “Wapômbêŋ anêŋ kapya hanaŋ nena, ‘Yenaŋ unyak ma unyak neteŋ mek êndôk.’ Ma môlô lêk udum ba lêk habitak hatôm ŋê vani iniŋ loŋ ekopak êmô.” ");
INSERT INTO hot_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Vêm ma ŋê maleŋiŋ pusip lôk ŋê veŋvuviŋ i êyô unyak matheŋ anêŋ piklêvôŋ ma hadum ba ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ êyê nômbithi takatu ba Yisu hadum. Ma thêlô elaŋô avômena elam kaêk haveŋ unyak matheŋ anêŋ piklêvôŋ nena, “Osana ni êndêŋ Devit anêŋ Lim Lukmuk!” Êŋ ma thêlô leŋiŋmaniŋ ");
INSERT INTO hot_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ba enaŋ hadêŋ Yisu nena, “Ondaŋô avômena iniŋ abô!” Ma Yisu hanaŋ, “Yahalaŋô. Ma môlô bôk osam abô atu ba hêk Wapômbêŋ anêŋ kapya ba hanaŋ hathak “‘Avômena lôk amena kasek nena Wapômbêŋ bôk hatak abô mavi halôk thêlô veŋiŋbôlêk ek nêmbô anêŋ athêŋ.’” ");
INSERT INTO hot_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Vêm ma hatak avômalô takêŋ ma hi hêk Betani bôlôvôŋ te. ");
INSERT INTO hot_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lôkbôk momaŋiniŋ ma Yisu havôhi Jelusalem hathak loŋbô ma hama kisi. ");
INSERT INTO hot_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yani hayê alokwaŋ sabo te hamiŋ loŋôndê daŋ vi. Hi hadêŋ alokwaŋ êŋ, ma hayê nena ŋauŋ oyaŋ iyom hamiŋ ma anêŋ anôŋ mi. Ma hanaŋ hadêŋ alokwaŋ êŋ, “Miŋ hatôm nuŋgwik anôŋ esak loŋbô ami!” Ma ketheŋ oyaŋ ma alokwaŋ êŋ anêŋ ŋauŋ hayeŋ ba hama. ");
INSERT INTO hot_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ŋê ku êyê nôm êŋ ba esoŋ kambom ba enaŋ, “Honaŋ malê hathak alokwaŋ êntêk ba lêk hama ketheŋ?” ");
INSERT INTO hot_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma Yisu hanaŋ, “Yanaŋ avanôŋ êndêŋ môlô nena môlô ôêvhaviŋ ba miŋ kapôlômim ju ami, êŋ ma hatôm nundum êtôm atu ba yahadum hadêŋ alokwaŋ êntêk lôk hatôm nundum nômla yaŋ imbiŋ nena nonaŋ êndêŋ dumlolê êntêk, ‘Ômbi o kisi ni tamu ŋgwêk.’ Êŋ ma Wapômbêŋ tem indum ba dumlolê êŋ endaŋô môlônim abô. ");
INSERT INTO hot_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Môlô ôêvhaviŋ ba oteŋ mek, ma Wapômbêŋ tem nêm nôm takatu ba onaŋ hik yani liŋ hathak êndêŋ môlô.” ");
INSERT INTO hot_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisu habitak hayô unyak matheŋ anêŋ piklêvôŋ ma hadôŋ avômalô hamô. Êŋ ma ŋê bêŋbêŋ êbôk da lôk avômalô iniŋ ŋê bêŋbêŋ êlêm hadêŋ yani ma enaŋ, “Opalê hêv athêŋ bêŋ hadêŋ o lôk hêv ku hadêŋ o ba intu hudum nôm takêntêk?” ");
INSERT INTO hot_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma Yisu hanaŋ, “Tem yanaŋ injik môlô liŋ esak abô te aêŋ iyom. Ba onaŋ abô êŋ bêŋ hadêŋ ya, ma tem yandam ôpatu ba hêv athêŋ bêŋ hadêŋ ya êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Opalê hêv ku nisik avômalô êndôk ŋaŋ hadêŋ Jon? Wapômbêŋ leŋ? Mena anyô pik?” Ma thêlôda enaŋ hadêŋ i nena, “Alalô anaŋ nena Wapômbêŋ hêv ku êŋ hadêŋ Jon ma tem yani enaŋ, ‘Aisê ka môlô miŋ ôêvhaviŋ yani ami?’ ");
INSERT INTO hot_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma doŋtom alalô anaŋ nena, ‘Anyô pik te hêv ku êŋ,’ êŋ ma avômalô tem leŋiŋmaniŋ êndêŋ alalô. Ek malê nena thêlô sapêŋ êvhaviŋ nena Jon ma plopet te.” ");
INSERT INTO hot_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ma thêlô enaŋ hadêŋ Yisu nena, “Yêlô athôŋ paliŋ.” Êŋ ma Yisu hanaŋ hadêŋ thêlô, “Aêŋ ba miŋ hatôm yandam ôpatu ba hêv athêŋ bêŋ hadêŋ ya anêŋ athêŋ bêŋ êndêŋ môlô ami. Ma mi.” ");
INSERT INTO hot_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Lemimbi kukuthiŋ êntêk. Anyô te anêŋ nakaduŋ lokwaŋju êmô. Ma yani hi ek namalô yaŋ ma hanaŋ, ‘Yenaŋ okna! Undum yenaŋ ku embeŋ ku yak waiŋ kapô!’ ");
INSERT INTO hot_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ma namalô hanaŋ viyaŋ nena, ‘Yahadô.’ Vêm ma hik anêŋ auk liliŋ ma hi. ");
INSERT INTO hot_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Lambô hi hadêŋ namalô yaŋ ma hanaŋ abô êŋ hathak loŋbô. Ma nakaduŋ hanaŋ, ‘Wakamik, tem yana’. Ma miŋ hi ami. ");
INSERT INTO hot_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Namalô ju êŋ yaŋ sê intu hasopa lambô anêŋ abô?” Ma thêlô enaŋ, “Namalô yaŋ môŋ.” Ma Yisu hanaŋ hadêŋ thêlô, “Yanaŋ avanôŋ êndêŋ môlô. Ŋê takis lôk avi sek waliliŋ tem nimbitak nêyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô nêmôŋ ek môlô. ");
INSERT INTO hot_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon bôk halêm ba hik loŋôndê thêthôŋ thô hadêŋ môlô. Ma doŋtom môlô miŋ ôêvhaviŋ anêŋ abô ami. Ma ŋê takis lôk avi sek waliliŋ, thêlô êvhaviŋ ba bôk môlô ôyê yôv. Ma doŋtom môlô miŋ ole kapôlômim liliŋ ami. Ba intu ŋê takêŋ tem nêmôŋ ba nimbitak nêyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ba ini.” ");
INSERT INTO hot_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Môlô nodaŋô abô loŋ kapô yaŋ. Ku alaŋ te havatho anêŋ ku yak waiŋ ma havak lôk hawê haveŋ. Ma halav lôv nêyô nimiŋ waiŋ anêŋ anôŋ pesa ek neja anêŋ thôk. Ma halav unyak daim te ek anyô nêmô ek neyabiŋ ku êŋ. Vêm ma hatak ku êŋ halôk anyô doho baheŋiŋ ek neyabiŋ ek hik anôŋ ma thêlô neja anôŋ vi ma nênêm vi êndêŋ yani. Ma hatak loŋ êŋ ba hi loŋ buyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Yak waiŋ êŋ hadum ek injik anôŋ ma ku alaŋ hêv anêŋ ŋê ku ba i ek neja yak waiŋ anêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma ŋê takatu ba eyabiŋ ku evaloŋ thêlô ba epatiŋ i ma ik doho vônô ma ik doho hathak valu. ");
INSERT INTO hot_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Êŋ ma ku alaŋ hêv ŋê ku bêŋ anôŋ ba i ma ŋê eyabiŋ ku yak waiŋ ibuliŋ thêlô aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ma hasoŋ nena thêlô tem nedaŋô namalô anêŋ abô ba intu hêv yani iyom ba hi. ");
INSERT INTO hot_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ŋê eyabiŋ ku êyê ku alaŋ nakaduŋ hayô ma enaŋ hadêŋ i nena, ‘Ôpêntêk ma ku alaŋ anêŋ nakaduŋ ba tem eyabiŋ lambô anêŋ ku. Alalô ik yani vônô, ma ku êŋ tem imbitak alalôaniŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ba intu evaloŋ yani ba ewa ele ku viyaiŋ ma ik vônô. ");
INSERT INTO hot_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Aêŋ ba ku alaŋ hayô ma tem indum malê êndêŋ ŋê takatu ba eyabiŋ ku êŋ?” ");
INSERT INTO hot_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ŋê bêŋbêŋ êbôk da lôk avômalô iniŋ ŋê bêŋbêŋ enaŋ hadêŋ yani nena, “Yani tem imbuliŋ ŋê kambom takêŋ kambom anôŋ. Ma tem enja ku yak waiŋ êŋ ba nêm êndêŋ anyô vi. Yak waiŋ hik anôŋ, ma ŋê êŋ tem nênêm ku alaŋ anêŋ sam.” ");
INSERT INTO hot_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yisu hanaŋ hadêŋ thêlô nena, “Môlô bôk osam abô êntêk ba hêk Wapômbêŋ anêŋ kapya nena, “‘Valu atu ba ŋê elav unyak êpôlik hathak, ma lêk habitak landiŋ anôŋ. Anyô Bêŋ da hadum aêŋ, ma yêlô ayê nôm êŋ nena mavi anêŋ dôêŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Aêŋ ba yanaŋ êndêŋ môlô nena Wapômbêŋ tem nêm anêŋ loŋ lôkliŋyak vê ênjêk môlô ba nêm êndêŋ ŋê ôdôŋ yaŋ. Ma thêlô tem nijik anôŋ êtôm alokwaŋ mavi te hathak hik anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma ôpatu ba hêv yak hayôhêk valu êntêk, ma tem ipup nenanena. Mena valu êŋ hêv yak hayôhêk anyôla, ma tem ôpêŋ ipulusik ba imbitak malimmalim.” ");
INSERT INTO hot_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ŋê bêŋbêŋ êbôk da lôk Palisi elaŋô Yisu anêŋ abô loŋ kapô takêŋ ma eyala nena yani hanaŋ hathak thêlôda. ");
INSERT INTO hot_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Êŋ ma thêlô êbôlêm loŋôndê ek nebaloŋ yani. Ma doŋtom êkô hathak avômalô iniŋ eyala nena Yisu ma plopet te ba intu êkô. ");
INSERT INTO hot_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisu hanaŋ abô loŋ kapô yaŋ hathak loŋbô nena, ");
INSERT INTO hot_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","3","“Wapômbêŋ anêŋ loŋ lôkliŋyak ma hatôm aêntêk. Avômalô idum ek nendom avi te ni ek kiŋ te anêŋ nakaduŋ. Êŋ ma hêv abô hadêŋ avômalô doho ek nêlêm nejaŋ nôm imbiŋ thêlô. Ba haŋgabôm nôm bêŋ atu yôv ma halam avômalô ek nêlêm nejaŋ nôm ewa i êŋ imbiŋ thêlô. Ma doŋtom êdô. ");
INSERT INTO hot_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Êŋ ma hêv ŋê ku doho hathak loŋbô ba hanaŋ hadêŋ avômalô takatu ba halam nena, ‘Môlô nodaŋô! Lêk yahapôpêk nôm yôv. Yahik yenaŋ bokmaŋkao doho lôk alim dopdop doho ba yahaŋgabôm! Ba intu nôlêm!’ ");
INSERT INTO hot_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ma doŋtom miŋ elaŋô ami ma i mayaliv. Vi i iniŋ ku ma vi i idum iniŋ ku valuseleŋ. ");
INSERT INTO hot_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma vi evaloŋ kiŋ anêŋ ŋê ku ba idum kambom lomaloma hadêŋ i vêm ma iki vônô. ");
INSERT INTO hot_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kiŋ lamaniŋ kambom ba hêv ŋê vovak i ek nijik ŋê êŋ leŋkadôk liŋ lôk nêmbôk atum esaŋ loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Êŋ ma hanaŋ hadêŋ ŋê ku nena, ‘Nôm lêk yahapôpêk yôv ba hamô. Ma doŋtom avômalô takatu ba yahalam i, ma avômalô kambom ba intu êdô nêlêm. ");
INSERT INTO hot_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aêŋ ba unu malaklêvôŋ ma nodam avômalô takatu ba ôpôm i ba nêlêm ek nejaŋ nôm êntêk.’ ");
INSERT INTO hot_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ma ŋê ku i mayaliv ba eveŋ loŋôndê sapêŋ ma enaŋ kiŋ anêŋ abô hadêŋ avômalô takatu ba êpôm i. Êŋ ma elom avômalô mavi lôk avômalô kambom ba êyô aleba unyak kapô êŋ putup. ");
INSERT INTO hot_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ma kiŋ habitak hayô unyak kapô ba hi ek ênjê avômalô, ma hayê nena anyô te miŋ hapesaŋ i mavi ami. ");
INSERT INTO hot_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma hanaŋ hadêŋ ôpêŋ, ‘Aiyaŋ, miŋ huik kwêv mavi ami eka? Ma opalê hêv o ba hôlêm unyak kapô êntêk?’ Ma ôpêŋ bônôŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Êŋ ma hanaŋ hadêŋ anêŋ ŋê ku nena, ‘Nobaloŋ ôpêntêk ba nokak va lo baŋ lusu ma nônêm yani vê ba ni loŋ momaŋiniŋ. Loŋ êŋ ma tem thêlô nedaŋ kambom ba nesaŋ veŋiŋbôlêk ôdôŋ loŋ.’” ");
INSERT INTO hot_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yisu hanaŋ abô loŋ kapô êŋ yôv ma hanaŋ, “Wapômbêŋ halam avômalô bêŋ anôŋ, ma doŋtom tem enja naju iyom ek nimbitak anêŋ avômalô.” ");
INSERT INTO hot_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ma Palisi i ethak doŋtom ba ibutiŋ abô ba iniŋ abô ma hatôm elav gwasilim. Thêlô idum aêŋ ek Yisu hanaŋ abô kambom te ma nebaloŋ yani. ");
INSERT INTO hot_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Êŋ ma thêlô êv iniŋ ŋê ku doho lôk ŋê ôdôŋ te iniŋ athêŋ nena “Helotian” ba i hadêŋ Yisu. Ma enaŋ, “Kêdôŋwaga, yêlô ayala nena o ma anyô abô avanôŋ. Ma hothak huik Wapômbêŋ anêŋ abô thô hadêŋ avômalô. Ma miŋ hothak hobam anyô yaŋ ma hôdô anyô yaŋ ami. Ba intu ŋê bêŋbêŋ êdô anêm abô, ma miŋ hôkô ek i ami. ");
INSERT INTO hot_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aêŋ ba onaŋ êndêŋ yêlô. Bumalô iniŋ balabuŋ hanaŋ nena yêlô hatôm nanêm valuseleŋ êndêŋ Sisa mena mi? Ba lemhabi aisê?” ");
INSERT INTO hot_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yisu hayala iniŋ auk kambom ba intu hanaŋ, “Môlô ŋê abôyaŋ! Aisê ba môlô udum ek numbuliŋ ya? ");
INSERT INTO hot_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Uŋgwik valuseleŋ atu ba othak ôêv hadêŋ Sisa te thô êndêŋ ya.” Ma ewa valuseleŋ êŋ ba i êv hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma hanaŋ hik thêlô liŋ, “Opalê anêŋ dahô lôk anêŋ athêŋ hêk valuseleŋ êntêk?” ");
INSERT INTO hot_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma enaŋ nena, “Sisa.” Êŋ ma Yisu hanaŋ hadêŋ thêlô nena, “Sisa anêŋ nômkama ma nônêm êndêŋ Sisa da. Ma Wapômbêŋ anêŋ nômkama ma nônêm êndêŋ Wapômbêŋ da.” ");
INSERT INTO hot_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Thêlô elaŋô abô êŋ ba esoŋ kambom ma etak Yisu ba i. ");
INSERT INTO hot_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wak êŋ ma Sadyusi doho i hadêŋ Yisu. Thêlô ma ôdôŋ te atu ba enaŋ nena ŋê ŋama tem miŋ nimbiyô esak loŋbô ami. Aêŋ ba intu enaŋ hik Yisu liŋ nena, ");
INSERT INTO hot_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Kêdôŋwaga, Mose bôk hanaŋ hadêŋ alalô nena, ‘Anyô te hama ba nali mi ma anêŋ yaŋ hamô, ma enja avi tôp êŋ ek imbi yaŋ atu ba hama anêŋ nakaduŋ vê.’ ");
INSERT INTO hot_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aêŋ ba ŋê lôk iviyaŋ baheŋvi ba lahavuju êmô. Ma bôp hawa avi te ba hama ma nakaduŋ mi. Ma nôk enja avi tôp êŋ, hawa ");
INSERT INTO hot_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ba hama ma nakaduŋ mi. Ma ŋgwa enja avi tôp bô êŋ, nena hama haviŋ. Êŋ ma iviyaŋ takatu ba êmô ma nesopa kobom doŋtom êŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Vêm ma avi tôp êŋ hama haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ma waklavôŋ ŋê ŋama iviyô hathak loŋbô ma avi tôp atu ba ŋê lôk iviyaŋ baheŋvi ba lahavuju takatu ba ewa ma alisê te anêŋ avi?” ");
INSERT INTO hot_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma Yisu hanaŋ, “Môlô miŋ oyala Wapômbêŋ anêŋ lôklokwaŋ lôk anêŋ abô atu ba hêk anêŋ kapya katô ami. Ba intu onaŋ abô lokbaŋ êntêk. ");
INSERT INTO hot_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Waklavôŋ ŋê ŋama iviyô hathak loŋbô, ma anyô lo avi tem miŋ neja i esak loŋbô ami ma mi. Thêlô tem nêmô êtôm aŋela malak leŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Môlô onaŋ nena ŋê ŋama tem miŋ nimbiyô esak loŋbô ami. Ma doŋtom môlô bôk osam abô atu Wapômbêŋ bôk hanaŋ hadêŋ Mose aêntêk, ");
INSERT INTO hot_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ya ma Ablaham lo Aisak ma Jekop iniŋ Wapômbêŋ.’ Wapômbêŋ ma miŋ ŋê ŋama iniŋ Wapômbêŋ ami. Mi, yani ma ŋê lôkmala iyom iniŋ Wapômbêŋ. Ba intu yêlô ayala nena thêlô bôk ema, ma doŋtom lêk êmô lôkmala.” ");
INSERT INTO hot_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Avômalô bêŋ anôŋ elaŋô Yisu anêŋ abô êŋ ba esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Palisi elaŋô nena Yisu hik Sadyusi iniŋ auk lokbaŋ thô aleba thêlô bônôŋ iyom. Ma thêlô ethak doŋtom ba i hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma iniŋ anyô lôkauk bêŋ te hathak balabuŋ hadum ek esaê Yisu ba hanaŋ, ");
INSERT INTO hot_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kêdôŋwaga, abô balabuŋ alisê intu bêŋ ek abô balabuŋ vi?” ");
INSERT INTO hot_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Êŋ ma Yisu hanaŋ nena, “‘Lemimimbiŋ Anyô Bêŋ unim Wapômbêŋ ênjêk unim kapôlômim lôk dahôlômim ma unim auk sapêŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ma balabuŋ êntêk ma bêŋ anôŋ ba hamôŋ. ");
INSERT INTO hot_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma balabuŋ yaŋ ma hatôm balabuŋ môŋ atu iyom ba hanaŋ nena, ‘Lemimbiŋ avômalô vi êtôm lemhaviŋ oda.’ ");
INSERT INTO hot_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Abô balabuŋ sapêŋ lôk plopet iniŋ abô ma hamô balabuŋ ju êntêk kapô.” ");
INSERT INTO hot_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yôv ma Yisu hanaŋ hik Palisi takatu liŋ, ");
INSERT INTO hot_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Môlô lemimhabi aisê hathak Mesia atu? Yani ma opalê anêŋ lim lukmuk?” Ma thêlô enaŋ, “Devit anêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Ma Yisu hanaŋ hadêŋ thêlô, “Mavi. Ma doŋtom odaŋô Devit anêŋ abô te. Lovak Matheŋ hêv auk hadêŋ yani ba Devit da hanaŋ nena, “‘Anyô Bêŋ Wapômbêŋ hanaŋ hadêŋ yenaŋ Anyô Bêŋ Mesia nena, “Ômô yabaheŋ vianôŋ endeba yatak ŋê takatu ba ik vovak hadêŋ o nêmô vemkapô vibiŋ am.” ’ ");
INSERT INTO hot_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ma Devit da bôk halam Mesia nena anêŋ Anyô Bêŋ. Ma aisê ka Mesia ma yani anêŋ lim lôk anêŋ Anyô Bêŋ imbiŋ?” ");
INSERT INTO hot_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma thêlô miŋ hatôm nenaŋ viyaŋ ami. Ba intu hayô hamô wak êŋ ba hi, ma thêlô êkô ba miŋ enaŋ hik yani liŋ ek nesau yani esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yisu hanaŋ hadêŋ avômalô lubuŋlubuŋ takatu lôk anêŋ ŋê ku nena, ");
INSERT INTO hot_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ŋê lôkauk hathak abô balabuŋ lôk Palisi ma môlônim ŋê bêŋbêŋ êdôŋ môlô hathak Mose anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ba intu nosopa ŋê êŋ iniŋ abô sapêŋ. Ma doŋtom thêlôda miŋ ethak esopa iniŋ abô ami ma mi. Aêŋ ba miŋ nundum êtôm atu ba thêlô idum ami. ");
INSERT INTO hot_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Thêlô êv balabuŋ anêŋ malaiŋ lomaloma hadêŋ avômalô ek nesopa. Nôm êŋ ma hatôm vak malaiŋ kambom. Ma doŋtom thêlôda miŋ êv sa dokte ami. ");
INSERT INTO hot_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ŋê takêŋ ethak epesaŋ vak yaônena ek netak Wapômbêŋ anêŋ abô êndôk ba ibutiŋ hêk luvôŋiŋ lôk baheŋiŋ. Ma ethak ibutiŋ yak daim hamiŋ iniŋ kwêv anêŋ daŋ hêk veŋiŋ luvi ek injik thô nena ŋê êvhaviŋ Wapômbêŋ. Lôk epesaŋ iniŋ vak yaô lôk yak daim takatu ba bêŋ ek avômalô vi iniŋ ek avômalô nêgê ba nebam i. ");
INSERT INTO hot_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma avômalô eŋgabôm nôm bêŋ, ma leŋiŋhaviŋ nejaŋ nôm êmô ŋê bêŋbêŋ iniŋ loŋ ethak êmô. Lôk leŋiŋhaviŋ nêmô êtôm ŋê bêŋbêŋ êmô unyak yeŋ kapô. ");
INSERT INTO hot_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ethak i loŋ ethak doŋtom halôk ma leŋiŋhaviŋ avômalô bêŋ anôŋ nenaŋ nena, ‘Waklêvôŋ anyô bêŋ’ lôk nebam i nena ‘Kêdôŋwaga’. ");
INSERT INTO hot_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Môlônim Anyô Bêŋ ma doŋtom iyom ma môlô ma ŋê lôk iviyaŋ sapêŋ. Ba intu miŋ malemimkilik ek avômalô nebam môlô nena ŋê bêŋbêŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma môlônim lemambô ma doŋtom iyom hamô malak leŋ. Ba intu miŋ nodam anyô pik te nena môlônim lemambô ami. ");
INSERT INTO hot_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma môlônim kêdôŋwaga ma doŋtom iyom. Yani ma Mesia atu. Ba intu miŋ anyô te endam môlô nena ‘kêdôŋwaga’ ami. ");
INSERT INTO hot_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ôpatu ba hadum môlônim ku ek hêv môlô sa, yani êŋ intu tem imbitak anyô lôk athêŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma ôpatu ba habam yanida, yani êŋ tem imbitak anyô athêŋ mi. Ma ôpatu ba hatauviŋ i, yani êŋ tem nebam yani. ");
INSERT INTO hot_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Alikaknena môlô Palisi lôk ŋê lôkauk hathak abô balabuŋ! Môlô onaŋ auk mavi ma doŋtom môlô udum kambom ba uik Wapômbêŋ anêŋ loŋ lôkliŋyak anêŋ unyak abôlêk siŋ ek avômalô. Môlôda ôdô ek numbitak nôyô loŋ êŋ. Ma anyô te hadum ek imbitak êyô, êŋ ma môlô umiŋ yani loŋ siŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Alikaknena môlô Palisi lôk ŋê lôkauk hathak abô balabuŋ! Môlô onaŋ auk mavi ma doŋtom môlô udum kambom. Môlô othak owa avi tôp iniŋ unyak lôk nômkama sapêŋ! Ma doŋtom môlô othak oteŋ mek daim bêŋ ek avômalô nebam môlô. Ba intu môlônim vovaŋ tem imbitak bêŋ anôŋ ek avômalô vi iniŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Alikaknena môlô Palisi lôk ŋê lôkauk hathak abô balabuŋ! Môlô onaŋ auk mavi ma doŋtom môlô udum kambom. Môlô othak oveŋ pik lôk ŋgwêk sapêŋ ek ôdôŋ avômalô hathak môlônim auk. Ma avômalô takêŋ esopa môlônim auk ba idum kambom takêŋ ma hatôm anyô ju iniŋ kambom idum bôlôŋ ju ba tem ini loŋ atum lôkmala êtôm môlô. ");
INSERT INTO hot_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Alikaknena! Môlô ma hatôm ŋê maleŋiŋ pusip ba yaŋ halom yaŋ haveŋ loŋôndê ba othak onaŋ nena, ‘Anyô te havak balabuŋ hathak Wapômbêŋ anêŋ unyak, êŋ ma nôm yaôna ba yani hatôm êmbôliŋ dôm êndêŋ abô êŋ. Ma doŋtom anyô te havak balabuŋ hathak gol atu ba hamô Wapômbêŋ anêŋ unyak, êŋ ma nômbêŋ ba yani indum êtôm atu ba yani hanaŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Môlô ŋê molo lôk malemim pusip! Wapômbêŋ anêŋ unyak ma nômbêŋ ek gol. Ek malê nena Wapômbêŋ anêŋ unyak hadum ba gol êŋ habitak matheŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ma môlô othak onaŋ abô bute haviŋ nena, ‘Anyô te havak balabuŋ hathak loŋ êbôk da, yani êŋ hatôm êmbôliŋ dôm êndêŋ abô êŋ. Ma doŋtom anyô te hêv da ba havak balabuŋ hathak da êŋ, êŋ ma yani indum êtôm atu ba yani hanaŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Môlô ŋê malemim pusip! Loŋ êbôk da ma nômbêŋ ek nôm atu ba anyô hêv hatôm da. Ek malê nena loŋ êbôk da hadum ba da êŋ habitak matheŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Ba intu Anyô te havak balabuŋ hathak loŋ êbôk da, yani lêk havak balabuŋ hathak loŋ êbôk da lôk da atu ba hamô haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma anyô te havak balabuŋ hathak unyak matheŋ êŋ, yani êŋ lêk havak balabuŋ hathak unyak matheŋ lôk Wapômbêŋ atu ba hamô unyak matheŋ êŋ kapô haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma anyô te havak balabuŋ hathak malak leŋ, êŋ ma hatôm havak balabuŋ hathak Wapômbêŋ lôk loŋ atu ba hayô hamô ek hayabiŋ nômkama sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","24","“Alikaknena môlô ŋê lôkauk hathak abô balabuŋ lôk Palisi! Môlô lôklokwaŋ ba osopa balabuŋ yaônena ma balabuŋ bêŋ ma môlô ôthôŋ paliŋ. Môlô othak usup ava nenanena atu ba hadum nôm vasiŋ ma uik sam hi ôdôŋ laumiŋ ba ôêv te hadêŋ Wapômbêŋ hatôm da. Ma doŋtom môlô othak ubuliŋ avômalô ba miŋ udum thêthôŋ hadêŋ i ami lôk miŋ ôêv kapôlômim ek i ami. Ma miŋ môlô ôêvhaviŋ ba osopa Wapômbêŋ anêŋ abô sapêŋ ami. “Môlô othak ôêv thêmathôm vê hêk môlônim nôm, ma doŋtom bok kamel ma môlô ôtôkwêŋ paliŋ! Ba intu môlô hatôm anyô mapusip te ba halom anyô yaŋ haveŋ loŋôndê. Notak auk takêŋ ma nosopa balabuŋ bêŋbêŋ lôk balabuŋ yaônena imbiŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Alikaknena môlô Palisi lôk ŋê lôkauk hathak abô balabuŋ! Môlô osau avômalô ba othak uthik unim tase lôk belev anêŋ vidôm iyom. Ma doŋtom nôm takatu ba oŋgasô halôk ma bôk owa vani ba oaŋ paloŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ba intu môlô ŋê malemim pusip! Nusik tase lôk belev vi kapô ek viyaiŋ imbitak mabuŋ imbiŋ! ");
INSERT INTO hot_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Alikaknena môlô Palisi lôk ŋê lôkauk hathak abô balabuŋ! Môlô osau avômalô hatôm valu atu ba hamô siô ma esaba hathak nôm thapuk ek nepesaŋ mavi anôŋ. Ma doŋtom siô kapô ma putup hathak ŋê ŋama iniŋ lokwaŋ bôk hapalê hamô. ");
INSERT INTO hot_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ba intu avômalô êyê môlônim bôk lo loŋ ma thêlô esoŋ nena môlô ma ŋê thêthôŋ. Ma doŋtom môlônim kapôlômim ma putup hathak ku esau avômalô lôk auk ôdô Wapômbêŋ anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Alikaknena môlô Palisi lôk ŋê lôkauk hathak abô balabuŋ! Môlô onaŋ nena môlô ôdô kambom te. Ma doŋtom môlôda udum kambom êntêk. Môlô othak olav unyak mavi hayô plopet bô iniŋ siô ma môlô opesaŋ kamuŋ mavi hamô ŋê thêthôŋ iniŋ siô. ");
INSERT INTO hot_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma môlô othak onaŋ nena, ‘Bumalô iniŋ kambom ma bêŋ ek yêlôaniŋ. Ba intu thêlô ik plopet vônô. Ma yêlô namô imbiŋ bumalô, ma tem miŋ yêlô nadôk ek nijik plopet vônô ami.’ ");
INSERT INTO hot_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aêŋ ba lêk hik thô nena môlô ma ŋê takatu ba uik plopet vônô iniŋ limi ba intu môlô othak udum iniŋ kambom takêŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yôv! Môlônu nundum bumalô iniŋ kambom takêŋ endeba êyô anêŋ daŋ! ");
INSERT INTO hot_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Môlô umya kambom! Môlô nyaleŋ kambom anêŋ nali! Wapômbêŋ indum abô ek môlô ma tem môlônu loŋ atum lôkmala. Ma miŋ hatôm nôsôv ba unu ami. ");
INSERT INTO hot_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Ba intu tem yanêm plopet lôk ŋê lôkauk ma kêdôŋwaga doho êsôk êndêŋ môlô ma tem uŋgwik vi vônô ma vi ma uŋgwik esak alovalaŋaŋsiŋ. Ma vi ma tem nobali êndôk môlônim unyak yeŋ lôk nudupuniŋ i ba nêsôv mayaliv ba ini lomalak lomalak. ");
INSERT INTO hot_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Môlô othak osopa libumi takatu ba bôk ik ŋê thêthôŋ bêŋ anôŋ vônô. Anyô môŋ atu ba ik vônô ma Abel ma ik aêŋ habup hathak aleba hayô Sekalaia, Belekia nakaduŋ. Ik yani vônô hêk unyak matheŋ lôk loŋ êbôk da anêŋ malêvôŋ. Ba intu Wapômbêŋ tem nêm vovaŋ bêŋ êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yanaŋ avanôŋ êndêŋ môlô! Avômalô bôlôŋ êntêk tem nêpôm vovaŋ bêŋ esak limi iniŋ kambom.” ");
INSERT INTO hot_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ai, Jelusalem, Jelusalem! Môlô othak uik plopet pôpônô! Ma ŋê takatu ba Wapômbêŋ hêv halêm ma môlô uik i hathak valu! Alikaknena! Yahadum lôbôlôŋ ek yasup nalumi esak doŋtom êtôm tale tiŋ hasup nali ba êmô banik kapô. Ma doŋtom môlô ôdô. ");
INSERT INTO hot_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Odaŋô! Môlônim malak ma tem kambom ba êmô ŋgathiniŋ! ");
INSERT INTO hot_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yanaŋ avanôŋ êndêŋ môlô nena môlô tem miŋ ôŋgô ya esak loŋbô ami endeba nonaŋ nena, ‘Wapômbêŋ nêm lamavi êndêŋ ôpatu ba halêm hathak Anyô Bêŋ anêŋ athêŋ!’ am.” ");
INSERT INTO hot_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yisu hatak unyak matheŋ anêŋ piklêvôŋ ba haveŋ denaŋ ma anêŋ ŋê ku êlêm hadêŋ yani ba enaŋ nena, “Nôŋgô unyak matheŋ lôk anêŋ unyak yaônena mavi anôŋ takêntêk!” ");
INSERT INTO hot_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma Yisu hanaŋ, “Môlô ôyê nôm takêntêk ba lemimmavi hathak e? Yanaŋ avanôŋ êndêŋ môlô. Malaiŋ bêŋ tem imbitak ba ŋê vovak tem nijik nômkama mavi nômbêŋ êntêk pesa ba valu yaŋ miŋ hatôm êyômô yaŋ loŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yisu hathak Dum Oliv ba hi halôk hamô biŋ. Ma anêŋ ŋê ku iyom i hadêŋ yani ma enaŋ hik yani liŋ nena, “Aŋgê intu nôm takêŋ tem imbitak? Ma malê intu tem imbitak ek injik thô nena tem ôlêm ek pik lo leŋ anêŋ daŋ?” ");
INSERT INTO hot_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Ma Yisu hanaŋ nena, “Ŋê lomaloma tem nêlêm esak yenaŋ athêŋ ba nenaŋ nena, ‘Ya ma Mesia atu.’ Ma tem nesau avômalô bêŋ anôŋ. Ba intu noyabiŋ am. ");
INSERT INTO hot_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma môlô tem nodaŋô abô esak vovak lomaloma lôk vovak tem imbitak pik luvuluvu. Nôm takêŋ tem imbitak ma doŋtom pik lo leŋ anêŋ daŋ ma mi denaŋ. Ba intu miŋ nodowaliŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ma avômalô ôdôŋ yaŋ tem nijik vovak imbiŋ ôdôŋ yaŋ. Ma kiŋ yaŋ lôk anêŋ avômalô tem nijik vovak êndêŋ kiŋ yaŋ. Ma loŋ lomaloma ma tem bôm lôk duviaŋ bêŋ imbitak. ");
INSERT INTO hot_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nôm takêŋ ma hatôm vovaŋ môŋ atu ba hapôm avi lôk lasabeŋ ek embathu. ");
INSERT INTO hot_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ma tem nebaloŋ môlô ba netak êndôk anyô vi baheŋiŋ ek nênêm vovaŋ êndêŋ môlô lôk nijik môlô vônô. Môlô ma yenaŋ avômalô ba intu tem avômalô sapêŋ nêpôlik esak môlô. ");
INSERT INTO hot_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma avômalô takatu ba êvhaviŋ ya bêŋ anôŋ tem netak iniŋ êvhaviŋ, ma thêlôda tem nêpôlik esak i ba nenaŋ thêlôda bêŋ. ");
INSERT INTO hot_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma plopet abôyaŋ bêŋ anôŋ tem nimbitak ba nesau avômalô bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma avômalô takatu ba êdô nesopa Wapômbêŋ anêŋ abô tem nimbitak bêŋ anôŋ. Aêŋ ba avômalô iniŋ leŋiŋhaviŋ avômalô vi tem imbitak thilibuŋ. ");
INSERT INTO hot_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma doŋtom ŋê takatu ba imiŋ lôklokwaŋ aleba hayô anêŋ daŋ, ma Wapômbêŋ tem nêm i bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aêŋ ba avômalô tem nenaŋ Wapômbêŋ anêŋ Abô Mavi êntêk esak anêŋ loŋ lôkliŋyak bêŋ embeŋ pik sapêŋ ek avômalô sapêŋ nedaŋô vêm ka pik lo leŋ anêŋ daŋ tem êyô. ");
INSERT INTO hot_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","“Plopet Daniel bôk hanaŋ abô te hathak nôm kambom anôŋ atu ba tem imiŋ loŋ matheŋ anôŋ. (Aêŋ ba môlô takatu ba osam abô êntêk, ma lemimimbi katô am.) Ma môlô takatu ba ômô Judia ôyê nôm êŋ, ma nôsôv ketheŋ ba unu dumlolê. ");
INSERT INTO hot_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ma ŋê takatu ba êmô unyak vôv, miŋ hatôm nêndôk ba ini unyak kapô ek neja iniŋ nômkama ami. ");
INSERT INTO hot_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma ŋê takatu ba êmô ku kapô miŋ hatôm nendeni unyak ek neja iniŋ kwêv thilibuŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ai, kikaknena. Waklavôŋ êŋ ma tem malaiŋ bêŋ ek avi takatu ba esabeŋ lôk avi takatu ba êv sôm hadêŋ nali. ");
INSERT INTO hot_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Noteŋ mek ek malaiŋ takêŋ miŋ imbitak êndêŋ Sabat mena beleŋ simbak la ami. ");
INSERT INTO hot_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ek malê nena waklavôŋ êŋ ma tem malaiŋ bomaŋ ba êmôŋ ek malaiŋ tak sêbôk ba môŋ anôŋ aleba lêk. Ma tem miŋ imbitak aêŋ esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma miŋ hadabêŋ waklavôŋ malaiŋ takêŋ kisi ami, êŋ ma avômalô sapêŋ tem nema. Ma doŋtom lahabi avômalô takatu ba bôk halam i yôv ba intu hadabêŋ waklavôŋ êŋ hi bidoŋ. ");
INSERT INTO hot_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Waklavôŋ êŋ ma anyôla hanaŋ hadêŋ môlô nena, ‘Ôŋgô, Mesia hamô loŋ êntêk’ mena ‘hamô loŋ tamu,’ ma miŋ nônêmimbiŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Anyô doho tem nêlêm ba nenaŋ abôyaŋ nena, ‘Ya ma Mesia’ mena ‘Ya ma Wapômbêŋ anêŋ plopet te’, ma nindum lavôŋiŋ lôk nômbithi ek nesau avômalô takatu ba bôk Wapômbêŋ halam i yôv haviŋ. Ma doŋtom Wapômbêŋ bôk halam i yôv ba intu miŋ hatôm ami. ");
INSERT INTO hot_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Odaŋô! Nôm takêntêk miŋ lêk habitak ami denaŋ ma yahanaŋ nôm takêŋ bêŋ hadêŋ môlô ek môlô noyabiŋ am. ");
INSERT INTO hot_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Aêŋ ba anyô late hanaŋ hadêŋ môlô nena, ‘Ôŋgô, yani hamô loŋ thiliv,’ êŋ ma miŋ môlô unu ami. Mena hanaŋ, ‘Ôŋgô, yani hamô unyak êntêk,’ êŋ ma miŋ môlô nônêmimbiŋ ôpêŋ ami. ");
INSERT INTO hot_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nodaŋô! Damak hêv ba habi deda haveŋ loŋ lôkthô ma avômalô sapêŋ êyê. Ma Anyô Anêŋ Nakaduŋ atu tem êlêm ma avômalô sapêŋ tem nêgê yani aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Menak lambek ethak doŋtom êmô loŋ takatu ba alim palê hêk. ");
INSERT INTO hot_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Malaiŋ takêŋ hale halôk vêm ma ketheŋ oyaŋ ma “‘wak tem imbitak momaŋiniŋ, ma ayôŋ tem miŋ imbi deda ami, ma vuliŋ leŋ tem nênêm yak, ma nôm takatu ba hamô leŋ tem nedowaliŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ma wak êŋ ma Anyô Anêŋ Nakaduŋ atu anêŋ lavôŋiŋ tem imbitak ênjêk leŋ. Ma avômalô pik tem nedaŋ boloba ba nêgê Anyô Anêŋ Nakaduŋ atu tem êyô êmô buliv ba êlêm imbiŋ anêŋ lôkliŋyak lôk anêŋ deda lôkmaŋgiŋ. ");
INSERT INTO hot_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma lavuak tem endaŋ lôklokwaŋ bomaŋ, ma yani tem nêm anêŋ aŋela ba ini pik anêŋ daŋ sapêŋ ek nisup avômalô takatu ba bôk halam i yôv. ");
INSERT INTO hot_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ba intu môlô noja auk esak alokwaŋ beleŋ. Hayeŋ ba ŋauŋ lukmuk habitak, êŋ ma oyala nena tem wak mavi êyô. ");
INSERT INTO hot_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ma aêŋ iyom, môlô ôyê nôm takêntêk habitak, êŋ ma noyala nena Anyô Anêŋ Nakaduŋ atu anêŋ waklavôŋ endelêm lêk habobo ba hamiŋ unyak abôlêk. ");
INSERT INTO hot_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yanaŋ avanôŋ êndêŋ môlô nena avômalô bôlôŋ êntêk tem miŋ nema ami denaŋ, ma nôm takêntêk sapêŋ tem imbitak. ");
INSERT INTO hot_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pik lôk leŋ tem nêm yak ba ni, ma doŋtom yenaŋ abô bute miŋ hatôm nêm yak ami. ");
INSERT INTO hot_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Anyô te miŋ hayala Yisu anêŋ waklavôŋ endelêm ami. Aŋela leŋ miŋ eyala ami, ma Nakaduŋ miŋ hayala haviŋ ami. Ma Kamik iyom intu hayala. ");
INSERT INTO hot_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ma avômalô bôlôŋ êntêk tem nindum êtôm bôk idum hadêŋ Noa anêŋ waklavôŋ. Êŋ ma Anyô Anêŋ Nakaduŋ atu tem êlêm. ");
INSERT INTO hot_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Avômalô eyaŋ lo inum ma ewa i aleba êthôŋ paliŋ ma Noa hi yeŋ kapô. Êŋ ma ŋambô bêŋ hayô ba habuliŋ thêlô sapêŋ. Ma avômalô bôlôŋ êntêk tem nêsôŋ paliŋ aêŋ iyom. Ma Anyô Anêŋ Nakaduŋ atu tem êlêm. ");
INSERT INTO hot_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wak êŋ, ma anyô ju tem nêmô kulêvôŋ, ma tem enja anyô yaŋ ma yaŋ êmô. ");
INSERT INTO hot_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma avi ju tem nepesaŋ nôm êmô, ma tem enja avi yaŋ ma yaŋ êmô. ");
INSERT INTO hot_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Aêŋ ba môlô noyabiŋ am ek malê nena môlô miŋ oyala waklavôŋ atu ba môlônim Anyô Bêŋ endelêm ami. ");
INSERT INTO hot_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Môlô lemimimbi abô êntêk katô. Unyak te anêŋ alaŋ halaŋô abô nena ŋê vani tem nijik anêŋ unyak vose, êŋ ma yani hêk lêlê ek ŋê vani miŋ hatôm nijik unyak êŋ vose ami. ");
INSERT INTO hot_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ma Anyô Anêŋ Nakaduŋ atu tem endelêm ba indum môlô nosoŋ kambom. Ba intu nômô lêlê aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Aêŋ ba môlô nundum ku êtôm anyô lôkauk mavi atu ba hayabiŋ nômkama mavi. Unyak alaŋ hatak yani ek eyabiŋ anêŋ ŋê ku ba nêm nôm êndêŋ i êtôm anêŋ wakma atu ba hatak. Vêm ma hi loŋ buyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ma unyak alaŋ havôhalêm hathak loŋbô ba hayê nena anêŋ anyô ku êŋ hadum ku mavi, ma tem lamavi esak ôpêŋ. ");
INSERT INTO hot_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yanaŋ avanôŋ êndêŋ môlô nena unyak alaŋ êŋ tem etak ôpêŋ ek eyabiŋ anêŋ nômkama sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Ma doŋtom ôpêŋ ma anyô kambom, êŋ ma tem laimbi ênjêk kapô nena, ‘Lêk sawa daim ma yenaŋ anyô bêŋ miŋ havôhalêm ketheŋ ami.’ ");
INSERT INTO hot_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Êŋ ma hik ŋê ku takatu ba idum ku haviŋ yani ma hayaŋ nôm lôk hanum waiŋ bêŋ anôŋ haviŋ ŋê takatu ba ethak inum waiŋ ba elo molo. ");
INSERT INTO hot_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Hadum aêŋ ba hathôŋ paliŋ, ma unyak alaŋ tem êyô ba indum ôpêŋ esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Êŋ ma unyak alaŋ tem nêm vovaŋ bêŋ êndêŋ yani ma êndô ôpêŋ êmô imbiŋ ŋê takatu ba esau avômalô. Loŋ êŋ ma thêlô tem nedaŋ kambom ba nesaŋ veŋiŋbôlêk ôdôŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Wapômbêŋ anêŋ lôkliŋyak ma aêntêk. Avi muk laumiŋ ewa iniŋ atum ba i ek nêpôm ôpatu ba tem enja avi lukmuk. ");
INSERT INTO hot_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Avi lôkauk ma baheŋvi ma auk mi ma baheŋvi. ");
INSERT INTO hot_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Avi auk mi ewa iniŋ atum ba i, ma miŋ ewa iniŋ alokwaŋ thôk ami. ");
INSERT INTO hot_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma doŋtom avi lôkauk ewa iniŋ atum lôk alokwaŋ thôk halôk kolopak. ");
INSERT INTO hot_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Avi takêŋ eyabiŋ anyô êŋ ek êyô aleba mi ma maleŋiŋ hayaŋ ba êk sôm. ");
INSERT INTO hot_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Bôlôvôŋ biŋ ma elam, ‘Anyô hawa avi lêk hayô yôv ba alôana!’ ");
INSERT INTO hot_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Êŋ ma avi muk takêŋ iviyô ma êpôpêk iniŋ atum. ");
INSERT INTO hot_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma avi auk mi enaŋ hadêŋ avi lôkauk nena, ‘Yêlôaniŋ atum hadum ek ema ba môlô nônêm athôk doho êlêm.’ ");
INSERT INTO hot_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ma avi lôkauk enaŋ, ‘Miŋ hatôm alalô sapêŋ ami ba dô, ma unu nonaŋ êndêŋ avômalô doho ek nônêm vuli.’ ");
INSERT INTO hot_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Êŋ ma thêlô i ek nênêm iniŋ vuli. Thêlô i denaŋ ma anyô atu hayô. Ma vi atu ba lêk êpôpêk i yôv ibitak êyô unyak kapô haviŋ yani ek nejaŋ nôm ma ik unyak abôlêk siŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Vêm ma vi atu êyô ma enaŋ, ‘Anyô bêŋ, anyô bêŋ! Uŋgwik unyak abôlêk vê ek yêlô.’ ");
INSERT INTO hot_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ma doŋtom ôpêŋ hanaŋ, ‘Yanaŋ avanôŋ êndêŋ môlô nena yahathôŋ môlô paliŋ.’” ");
INSERT INTO hot_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Êŋ ma Yisu hanaŋ hadêŋ avômalô takatu ba elaŋô anêŋ abô nena, “Môlô miŋ oyala waklavôŋ atu ba Anyô Bêŋ tem endelêm ami. Ba intu noyabiŋ am.” ");
INSERT INTO hot_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nodaŋô abô doho imbiŋ. Wapômbêŋ anêŋ loŋ lôkliŋyak ma hatôm anyô te hadum ek ni loŋ buyaŋ ba halam anêŋ ŋê ku êlêm ek nêm nômkama êndêŋ i ek neyabiŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yani hik valuseleŋ sam hatôm thêlôniŋ auk lôk iniŋ ku ba hêv valuseleŋ 5,000 hadêŋ anyô te, ma 2,000 hadêŋ anyô yaŋ, ma 1,000 hadêŋ anyô te ma hi. ");
INSERT INTO hot_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ketheŋ oyaŋ ma ôpatu ba hawa 5,000 hi hadum ku hathak ma havôv 5,000 hayô hamô loŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma yaŋ atu ba hawa 2,000 hi hadum aêŋ ba havôv 2,000 hayô hamô loŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma ali atu ba hawa 1,000 hi halav lôv ba havuŋ halôk. ");
INSERT INTO hot_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Wak doho hale ba hi ma ŋê êŋ iniŋ anyô bêŋ havôhalêm. Ma halam i ek endaŋô iniŋ ku anêŋ lavôŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma ali atu ba hawa 5,000 lôk 5,000 hayô hamô loŋ haviŋ halêm ma hanaŋ, ‘Anyô bêŋ, bôk hôêv 5,000 ek yayabiŋ. Nôŋgô! Lêk yahavôv 5,000 hayô hamô loŋ haviŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ma anêŋ anyô bêŋ hanaŋ, ‘Mavi anôŋ! O anyô katô ba hudum ku mavi. Lêk hoyabiŋ nômkama yaônena mavi ba intu tem yanêm nômkama bêŋ anôŋ êndêŋ o ek oyabiŋ. Ôlêm ek alai leŋiŋmavi imbiŋ i!’ ");
INSERT INTO hot_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma ôpatu ba hawa 2,000 halêm ma hanaŋ nena, ‘Anyô bêŋ, bôk hôêv ya 2,000 ek yayabiŋ. Nôŋgô! Lêk yahavôv 2,000 hayô hamô loŋ haviŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ma anêŋ anyô bêŋ hanaŋ ‘Mavi anôŋ! O anyô katô ba hudum ku mavi. Lêk hoyabiŋ nômkama yaônena mavi ba intu tem yanêm nômkama bêŋ anôŋ êndêŋ o ek oyabiŋ. Ôlêm ek alai leŋiŋmavi imbiŋ i!’ ");
INSERT INTO hot_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Êŋ ma ali atu ba hawa 1,000 halêm ma hanaŋ, ‘Anyô bêŋ, yahayala nena o ma anyô malem thêlêv. Hothak holav nôm hêk ku kapô atu ba miŋ hovatho ami. Ma pik atu ba anyô yaŋ hapaliv yaŋvêk halôk ma hothak howa anêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yahakô ba yahavuŋ anêm 1,000 atu halôk pik. Nôŋgô! Anêm valuseleŋ êntêk.’ ");
INSERT INTO hot_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ma anyô bêŋ hanaŋ viyaŋ, ‘O anyô vau kambom! Hôyê yenaŋ ku aisê ba intu honaŋ aêŋ? ");
INSERT INTO hot_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aisê ka miŋ hotak yenaŋ valuseleŋ halôk unyak valuseleŋ ek êmbôv doho ami ek wakma atu ba yahavôhalêm hathak loŋbô ma tem yanja doho êyômô loŋ imbiŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","“‘Ôpatu ba hadum ku mavi hathak yenaŋ nômkama ba habitak bêŋ, êŋ ma tem yatak doho êyômô loŋ imbiŋ ba yanêm êndêŋ ôpêŋ ba anêŋ tem imbitak bêŋ anôŋ. Ma ôpatu ba miŋ hadum ku hathak yenaŋ nômkama ami, êŋ ma tem yanêm dokte atu ba havaloŋ loŋ vê ênjêk yani. Ba intu noja 1,000 atu vê ênjêk ôpêŋ ba nônêm êndêŋ ôpatu ba hawa 10,000. ");
INSERT INTO hot_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma nônêm ôpêŋ vê ba ni loŋ momaŋiniŋ. Loŋ êŋ ma tem nedaŋ kambom ba nesaŋ veŋiŋbôlêk ôdôŋ loŋ.’” ");
INSERT INTO hot_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Anyô Anêŋ Nakaduŋ atu ma tem êlêm imbiŋ deda lôkmaŋgiŋ lôk aŋela ma tem êndôk êmô biŋ ek endaŋô avômalô iniŋ abô êtôm kiŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tem nesak doŋtom ba ini êndêŋ yani ma embaki vose ni ôdôŋ ju êtôm boksipsip anêŋ alaŋ hathak hik boksipsip sam ba êmô buyaŋ ma bokmeme êmô buyaŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma yani tem etak boksipsip êmô baŋ vianôŋ ma bokmeme êmô baŋ vikeŋ. ");
INSERT INTO hot_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Êŋ ma tem enaŋ êndêŋ avômalô takatu ba êmô baŋ vianôŋ nena, ‘Môlô nôlêm! Wakamik bôk hadum mavi hadêŋ môlô. Nôlêm noja loŋ lôkliŋyak atu ba Wapômbêŋ lahaviŋ nêm êndêŋ môlô. Sêbôk ba yani hapesaŋ pik lukmuk, ma hapesaŋ loŋ êŋ êk môlô. ");
INSERT INTO hot_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yahama kisi ma môlô ôêv nôm hadêŋ ya, ma yahathakmuniŋ ma ôêv ŋaŋ hadêŋ ya, ma ya anyô loŋ buyaŋ ma owa ya thô. ");
INSERT INTO hot_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ya sôp mi ma ôêv sôp hadêŋ ya, yahapôm lijiŋ ma oyabiŋ ya, yahamô koladôŋ ma ôlêm ôyê ya. Aêŋ ba nôlêm noja loŋ lôkliŋyak atu!’ ");
INSERT INTO hot_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ma avômalô thêthôŋ tem nenaŋ injik liŋ, ‘Anyô Bêŋ, aŋgê te ma yêlô ayê homa kisi ba yêlô êv nôm hadêŋ o ma hothakmuniŋ ba yêlô êv ŋaŋ hadêŋ o? ");
INSERT INTO hot_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aŋgê te ma o anyô loŋ buyaŋ ba yêlô awa o thô ma o sôp mi ba yêlô êv sôp hadêŋ o? ");
INSERT INTO hot_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aŋgê te ma hôpôm lijiŋ ba yêlô ayabiŋ o lôk ayê hômô koladôŋ ba yêlô athôk ayê o?’ ");
INSERT INTO hot_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ma Kiŋ tem enaŋ êndêŋ i, ‘Yanaŋ avanôŋ êndêŋ môlô! Môlô bôk udum nôm takêŋ hadêŋ yenaŋ avômalô takatu ba athêŋ mi, êŋ ma hatôm udum hadêŋ ya.’ ");
INSERT INTO hot_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Yôv ma tem enaŋ êndêŋ avômalô takatu ba imiŋ baŋ vikeŋ nena, ‘Môlô nu! Wapômbêŋ lêk hêv malaiŋ hadêŋ môlô ba unu loŋ atum hathaŋ wak nômbêŋ intu sapêŋ. Bôk ebaŋ yôv ba hamô ek Sadaŋ lôk anêŋ ŋê ku nêndôk. ");
INSERT INTO hot_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sêbôk ba yahama kisi ma miŋ ôêv nôm hadêŋ ya ami, ma yahathakmuniŋ ma miŋ ôêv ŋaŋ hadêŋ ya ami. ");
INSERT INTO hot_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma ya anyô loŋ buyaŋ ma miŋ owa ya thô ami, ma ya sôp mi ma miŋ ôêv sôp hadêŋ ya ami. Yahapôm lijiŋ ba yahamô koladôŋ ma miŋ oyabiŋ ya ami. Ba intu môlô nu loŋ atum êŋ.’ ");
INSERT INTO hot_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma tem nenaŋ, ‘Anyô Bêŋ, aŋgê te ma yêlô ayê homa kisi, mena hothakmuniŋ mena o anyô loŋ buyaŋ, mena o sôp mi, mena hôpôm lijiŋ, mena hômô koladôŋ, ba miŋ yêlô êv o sa ami?’ ");
INSERT INTO hot_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ma tem enaŋ nena, ‘Yanaŋ avanôŋ êndêŋ môlô! Môlô miŋ bôk udum nôm takêŋ hadêŋ yenaŋ avômalô takatu ba athêŋ mi te ami. Êŋ ma hatôm udum nôm êŋ hadêŋ ya.’ ");
INSERT INTO hot_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Aêŋ ba avômalô takêŋ tem ini ek neja vovaŋ wak nômbêŋ intu sapêŋ. Ma doŋtom avômalô thêthôŋ tem ini ek neja lôkmala êtôm wak nômbêŋ intu sapêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yisu hanaŋ abô nômbêŋ êŋ yôv ma hanaŋ hadêŋ anêŋ ŋê ku nena, ");
INSERT INTO hot_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Môlô oyala nena wak ju hêk denaŋ ma waklavôŋ anêŋ athêŋ nena Hale ba Hi tem êyô. Waklavôŋ êŋ ma tem netak ya Anyô Anêŋ Nakaduŋ atu êndôk avômalô doho baheŋiŋ ek nijik ya vônô esak a.” ");
INSERT INTO hot_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ma ŋê bêŋbêŋ êbôk da lôk avômalô iniŋ ŋê bêŋbêŋ ethak doŋtom halôk anyô bêŋ habôk da Kaiapas anêŋ unyak. ");
INSERT INTO hot_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma êbôlêm loŋôndê ek nesau Yisu ba nebaloŋ ek nijik yani vônô. ");
INSERT INTO hot_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma thêlô enaŋ, “Lêk ma waklavôŋ matheŋ ba intu natak ku êŋ ênjêk vêmam. Yakô avômalô tem leŋiŋmaniŋ ba nijik vovak.” ");
INSERT INTO hot_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Wak êŋ ma Yisu hamô Saimon anêŋ unyak anêŋ Betani. Sêbôk ma ôpêŋ hapôm palê lepla ma doŋtom bôk mi. ");
INSERT INTO hot_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ma thai lôk Yisu ma anêŋ ŋê ku eyaŋ nôm denaŋ ma avi te halêm unyak kapô. Ma hawa kolopak valu te ba thapuk ba nôm ôv mavi hamô kapô ba anêŋ vuli ma bêŋ anôŋ. Ma avi atu hi haŋgasô nôm ôv mavi êŋ hayô hamô Yisu wakadôk. ");
INSERT INTO hot_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ŋê ku êyê nôm êŋ ma leŋiŋmaniŋ ba enaŋ, “Aisê ka habuliŋ nôm ôv mavi êŋ hi oyaŋ? ");
INSERT INTO hot_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Hatôm nêm ek anyô yaŋ nêm vuli ma naja valuseleŋ bêŋ esak ek nanêm avômalô siv sa.” ");
INSERT INTO hot_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yani halaŋô thêlôniŋ abô êŋ ma hanaŋ, “Aisê ka môlô ôêv malaiŋ hadêŋ avi êntêk? Yani hadum nôm mavi anôŋ hadêŋ ya. ");
INSERT INTO hot_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Avômalô siv tem nêmô imbiŋ môlô êtôm wak nômbêŋ intu sapêŋ. Ma doŋtom tem miŋ yamô imbiŋ môlô sawa daim ami. ");
INSERT INTO hot_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Avi êntêk haŋgasô nôm ôv mavi hayô hamô ya ek epesaŋ yaleŋviŋkupik ek nedav ya. ");
INSERT INTO hot_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Odaŋô! Yanaŋ avanôŋ êndêŋ môlô! Pik nômbêŋ atu ba enaŋ yenaŋ Abô Mavi bêŋ haveŋ, ma tem nenaŋ esak nôm atu ba avi êntêk lêk hadum imbiŋ ek avômalô leŋiŋimbi yani.” ");
INSERT INTO hot_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas Iskaliot ma ŋê ku laumiŋ ba lahavuju takatu te ma yani hi hadêŋ ŋê bêŋbêŋ êbôk da ");
INSERT INTO hot_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ma hanaŋ hik i liŋ, “Yanêm Yisu êndêŋ môlô, ma tem nônêm malê te êndêŋ ya?” Ma ekatuŋ valuseleŋ seleva hatôm 30 ba êv hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Êŋ ma Judas habôlêm loŋôndê ek nêm Yisu êndôk thêlô baheŋiŋ. ");
INSERT INTO hot_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Waklavôŋ anêŋ athêŋ nena Eyaŋ Polom Yis Mi anêŋ wak te môŋ hayô. Ma ŋê ku i hadêŋ Yisu ma enaŋ hik yani liŋ, “Lemhaviŋ yêlô ana unyak alê ek napôpêk nôm leŋiŋimbi waklavôŋ Hale ba Hi êndôk?” ");
INSERT INTO hot_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma yani hanaŋ, “Môlô unu malak bêŋ kapô ba ôpôm ôpatu ma nonaŋ êndêŋ yani nena, ‘Kêdôŋwaga hanaŋ nena anêŋ waklavôŋ atu ma lêk habobo. Ma yani lôk anêŋ ŋê ku tem nêlêm anêm unyak ek leŋiŋimbi waklavôŋ Hale ba Hi.’” ");
INSERT INTO hot_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ma ŋê ku idum hatôm atu ba yani hanaŋ ba thêlô i êpôpêk waklavôŋ Hale ba Hi anêŋ nôm. ");
INSERT INTO hot_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bôlôvôŋ ma Yisu hayaŋ nôm hamô haviŋ anêŋ ŋê ku laumiŋ ba lahavuju takatu ");
INSERT INTO hot_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ma hanaŋ, “Yanaŋ avanôŋ êndêŋ môlô nena môlô te tem enaŋ ya bêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ŋê ku kapôlôŋiŋ malaiŋ kambom ba thêlô tomtom enaŋ, “Anyô Bêŋ, ya mi! Aêŋ e?” ");
INSERT INTO hot_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Êŋ ma Yisu hanaŋ nena, “Ôpatu ba hatak baŋ halôk belev haviŋ ya intu tem enaŋ ya bêŋ. ");
INSERT INTO hot_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Anyô Anêŋ Nakaduŋ atu tem ni êtôm atu ba bôk eto yôv hathak yani. Ma doŋtom alikakna. Malaiŋ bêŋ ek ôpatu ba hanaŋ Anyô Anêŋ Nakaduŋ bêŋ. Talêbô miŋ bôk havathu ami, êŋ ma mavi ek ôpêŋ!” ");
INSERT INTO hot_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ma Judas, ôpatu ba tem enaŋ Yisu bêŋ, hanaŋ hik liŋ nena, “Kêdôŋwaga, ya mi! Aêŋ e?” Ma Yisu hanaŋ, “Hatôm intu honaŋ aêŋ.” ");
INSERT INTO hot_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Thêlô eyaŋ nôm hamô ma Yisu hawa polom te ma hêv lamavi. Vêm ma haya ba hêv hadêŋ anêŋ ŋê ku ma hanaŋ, “Noja ba oŋgwaŋ. Êntêk ma yenaŋ vathiap.” ");
INSERT INTO hot_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Vêm ma hawa tase lôk waiŋ ma hêv lamavi. Ma hêv hadêŋ thêlô ma hanaŋ, “Môlô sapêŋ nunum. ");
INSERT INTO hot_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Êntêk ma yenaŋ thalaleŋ atu ba tem eŋgasô ek embak tabô imbiŋ Wapômbêŋ lôk avômalô pik êntêk ek nêm avômalô bêŋ anôŋ iniŋ kambom vê. ");
INSERT INTO hot_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Odaŋô! Yanaŋ êndêŋ môlô nena tem miŋ hatôm yanum waiŋ êŋ esak loŋbô ami endeba waklavôŋ êŋ hayô ma tem yanum waiŋ lukmuk êmô Wakamik anêŋ loŋ lôkliŋyak kapô.” ");
INSERT INTO hot_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Êv yeŋ te vêm ma ethak ba i Dum Oliv. ");
INSERT INTO hot_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma Yisu hanaŋ hadêŋ anêŋ ŋê ku, “Bôk eto hêk Wapômbêŋ anêŋ kapya nena, “‘Tem yaŋgik boksipsip alaŋ vônô, ma boksipsip tem nêsôv mayaliv ba ini.’ Ba intu yaô bôlôvôŋ ma tem môlô ôŋgô nôm takatu ba tem êpôm ya. Ma môlô sapêŋ tem notak ya ma nôsôv mayaliv ba unu. ");
INSERT INTO hot_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma doŋtom hik ya liŋ hathak loŋbô, ma tem yamôŋ ba yana Galili vêm ka môlô nombeŋ ya yam.” ");
INSERT INTO hot_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma Pita hanaŋ nena, “Dô! Thêlô sapêŋ etak o ba i, ma tem yamiŋ imbiŋ o denaŋ.” ");
INSERT INTO hot_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma Yisu hanaŋ nena, “Ondaŋô! Yanaŋ avanôŋ biŋ êndêŋ o nena bôlôvôŋ êntêk ma tale miŋ halaŋ ami denaŋ, ma tem onaŋ êtôm bôlôŋ lô nena hôthôŋ ya paliŋ.” ");
INSERT INTO hot_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma Pita hanaŋ, “Mi anôŋ! Ik ya vônô, ma miŋ hatôm yanaŋ nena yahathôŋ o paliŋ ami. Milôk!” Ma ŋê ku sapêŋ enaŋ abô êŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Vêm ma Yisu lôk anêŋ ŋê ku êyô loŋ atu ba elam nena Getsemani ma hanaŋ hadêŋ i, “Môlô nômô loŋ êntêk ma yana saka ek yateŋ mek.” ");
INSERT INTO hot_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma hawa Pita lôk Sebedi nakaduŋ luvi ba i. Ma yani kapô lêk malaiŋ bomaŋ. ");
INSERT INTO hot_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma hanaŋ hadêŋ thêlô, “Yakapôlôŋ lêk malaiŋ bomaŋ hatôm lêk yahama yôv. Môlô nômô loŋ êntêk ma nônêm lêlê imbiŋ ya.” ");
INSERT INTO hot_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ma hi daim dokte ma hêv yak ba thohavloma halôk pik. Ma hateŋ mek nena, “Yenaŋ Wakamik, loŋôndê vi hamô, êŋ ma yaleŋhaviŋ onja tase êntêk vê ênjêk ya. Ma doŋtom miŋ osopa yenaŋ yaleŋhaviŋ ami. Mi, osopa oda anêm lemhaviŋ.” ");
INSERT INTO hot_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ma Yisu hale hi ma hayê ŋê ku takatu ma lêk êk sôm. Êŋ ma hanaŋ hik Pita liŋ, “Aisê? Môlô miŋ hatôm nônêm lêlê imbiŋ ya êtôm wakma te ami e? ");
INSERT INTO hot_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nômô lêlê ba noteŋ mek ek miŋ nônêm yak ba nundum kambom ami. Kapô lahaviŋ indum mavi ma doŋtom auk ma pulusikna ba miŋ hatôm indum ami.” ");
INSERT INTO hot_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ma havôhi hathak loŋbô ma hateŋ mek nena, “Wakamik, lemhaviŋ malaiŋ bêŋ êntêk êpôm ya, êŋ ma mavi. Ma tem yandum êtôm honaŋ.” ");
INSERT INTO hot_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma halehi hathak loŋbô ma hayê thêlô êk sôm denaŋ ek malê nena maleŋiŋ hayaŋ ba miŋ hatôm nêmô lêlê ami. ");
INSERT INTO hot_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma hatak thêlô ma havôhi hateŋ mek bô atu bôlôŋ te lu hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Vêm ma halehi hadêŋ anêŋ ŋê ku ma hanaŋ, “Môlô ôêk sôm ba owa lovak denaŋ e? Odaŋô. Wakma lêk habobo ek netak ya Anyô Anêŋ Nakaduŋ atu êndôk ŋê kambom baheŋiŋ. ");
INSERT INTO hot_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Aêŋ ba numbiyô ek alôana! Ôŋgô! Ôpatu ba tem enaŋ ya bêŋ lêk halêm yôv!” ");
INSERT INTO hot_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisu hanaŋ abô denaŋ ma Judas hayô. Yani ma ŋê ku laumiŋ ba lahavuju takatu te. Ma avômalô bêŋ anôŋ êlêm iviŋ yani ba ewa biŋ vovak lôk okdiba. Ŋê takêŋ ma ŋê bêŋbêŋ êbôk da lôk avômalô iniŋ ŋê bêŋbêŋ êv thêlô ba êlêm. ");
INSERT INTO hot_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ôpatu ba tem enaŋ Yisu bêŋ bôk hik lavôŋiŋ te thô hadêŋ i nena, “Ôpatu ba yahaliŋu, êŋ ma Yisu ba nobaloŋ!” ");
INSERT INTO hot_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ma ôpêŋ hi ketheŋ hadêŋ Yisu ma hanaŋ, “Kêdôŋwaga, bôlôvôŋ mavi.” Ma haliŋu yani. ");
INSERT INTO hot_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma Yisu hanaŋ, “Aiyaŋ, undum ku atu ba hôlêm hathak.” Ma ŋê takatu ba êlêm haviŋ Judas i ma evaloŋ Yisu ba ewa ba i. ");
INSERT INTO hot_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma anyô te atu ba hamiŋ haviŋ Yisu hadadi anêŋ biŋ vovak ma hale anyô bêŋ habôk da anêŋ anyô ku te limbuk vi vê. ");
INSERT INTO hot_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma Yisu hanaŋ, “Otak anêm biŋ êndôk anêŋ loŋ esak loŋbô! Ôpatu ba hik vovak hathak biŋ, ma biŋ êŋ tem enjaŋ yani vônô. ");
INSERT INTO hot_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Lemimbi! Yahalaŋ hadêŋ Wakamik ma ketheŋ ma yani tem nêm aŋela vovak ôdôŋ laumiŋ ba lahavuju ma doho imbiŋ ba nêlêm ek nênêm ya sa. ");
INSERT INTO hot_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma doŋtom abô atu ba bôk hêk Wapômbêŋ anêŋ kapya tem injik anôŋ aisê? Wapômbêŋ anêŋ kapya hanaŋ nena nôm takêŋ tem êpôm ya.” ");
INSERT INTO hot_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Êŋ ma Yisu hanaŋ hadêŋ avômalô nômbêŋ atu nena, “Ya ma anyô kambom anôŋ ba intu owa biŋ vovak lôk okdiba ba ôlêm ek nobaloŋ ya e? Aisê? Wak nômbêŋ intu ma yahadôŋ avômalô hamô unyak matheŋ anêŋ piklêvôŋ ma miŋ ovaloŋ ya ami eka? ");
INSERT INTO hot_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma doŋtom nômkama takêntêk ba lêk habitak ek plopet iniŋ abô takatu ba bôk eto injik anôŋ.” Êŋ ma anêŋ ŋê ku sapêŋ etak yani ma êsôv mayaliv ba i. ");
INSERT INTO hot_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ŋê takatu ba evaloŋ Yisu ewa ba i Kaiapas anêŋ unyak, ôpêŋ ma anyô bêŋ habôk da. Ŋê lôkauk hathak abô balabuŋ lôk ŋê bêŋbêŋ ethak doŋtom ba êmô loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma Pita hasopa Yisu haveŋ yam ma doŋtom haveŋ daim dokte. Ma habitak hayô anyô bêŋ habôk da anêŋ badêŋ kapô. Ma hi halôk hamô haviŋ sôp bidoŋ ek ênjê nena malê intu tem imbitak. ");
INSERT INTO hot_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ŋê bêŋbêŋ êbôk da lôk Sanhedlin sapêŋ êbôlêm avômalô doho ek nenaŋ abôyaŋ esak Yisu ek thêlô nindum abô esak ek nijik yani vônô. ");
INSERT INTO hot_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Anyô bêŋ anôŋ êlêm ma enaŋ abôyaŋ hathak yani, ma doŋtom thêlô miŋ êpôm Yisu anêŋ kambom te ek nijik yani vônô ami. Êŋ ma anyô ju êlêm ");
INSERT INTO hot_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ma enaŋ, “Anyô êntêk bôk hanaŋ yôv nena, ‘Yahatôm yandiniŋ Wapômbêŋ anêŋ unyak matheŋ ma êtôm wak lô iyom ma tem yandav esak loŋbô.’” ");
INSERT INTO hot_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Êŋ ma anyô bêŋ habôk da haviyô hamiŋ ma hanaŋ hik Yisu liŋ nena, “Anyô ju êntêk lêk enaŋ o bêŋ yôv ma o bônôŋ eka? O abô mi e?” ");
INSERT INTO hot_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma doŋtom Yisu bônôŋ iyom. Ma anyô bêŋ habôk da hanaŋ hadêŋ Yisu, “Yanaŋ êndêŋ o! Ondam Wapômbêŋ lôkmala atu anêŋ athêŋ ba onaŋ êndêŋ yêlô nena, ‘O ma Mesia, Wapômbêŋ anêŋ nakaduŋ atu e?’” ");
INSERT INTO hot_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma Yisu hanaŋ nena, “Oda honaŋ aêŋ. Ma yanaŋ abô te imbiŋ êndêŋ môlô sapêŋ nena wak te am ka tem môlô ôŋgô Anyô Anêŋ Nakaduŋ atu tem êmô Wapômbêŋ Lôkliŋyak Anôŋ baŋ vianôŋ ba tem êyô êmô buliv ba êlêm.” ");
INSERT INTO hot_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ma anyô bêŋ habôk da halaŋô abô êŋ ma hakakaviŋ anêŋ kwêv ma hanaŋ, “Lêk yôv! Ôpêntêk habuliŋ Wapômbêŋ anêŋ athêŋ ba hanaŋ nena yanida ma hatôm Wapômbêŋ ba môlô lêk olaŋô abô êŋ yôv! Aisê ka alalô leŋiŋhaviŋ nadaŋô abô doho imbiŋ? ");
INSERT INTO hot_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Môlônim auk aisê? Yandum malê te?” Ma thêlô enaŋ, “Yani hanaŋ abôma hathak Wapômbêŋ ba intu ema.” ");
INSERT INTO hot_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Êŋ ma thêlô êsôvwapôk hathak Yisu thohavloma ma êpêŋ yani. Ma doho epetav yani ");
INSERT INTO hot_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ba enaŋ, “O ma Mesia e? O plopet te ma onaŋ êndêŋ yêlô nena opalê intu hik o?” ");
INSERT INTO hot_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita hamô unyak atu anêŋ badêŋ kapô ma avi ku te halêm hadêŋ yani ma hanaŋ, “O êntêk intu bôk hoveŋ haviŋ Yisu anêŋ Galili.” ");
INSERT INTO hot_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma Pita hanaŋ, “Injo! Yahathôŋ abô intu ba honaŋ paliŋ!” Ma avômalô sapêŋ elaŋô anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pita hi badêŋ abôlêk ma avi ku yaŋ hayê ma hanaŋ hadêŋ avômalô, “Anyô êntêk bôk hamô haviŋ Yisu anêŋ Nasalet.” ");
INSERT INTO hot_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma Pita halam Wapômbêŋ anêŋ athêŋ ba hanaŋ hathak loŋbô, “Mi anôŋ! Yahathôŋ ôpêntu paliŋ!” ");
INSERT INTO hot_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Vêm ma ŋê takatu ba imiŋ badêŋ kapô êlêm hadêŋ Pita ma enaŋ, “Môlô lemimselo doŋtom ba intu o ma Yisu anêŋ anyô te.” ");
INSERT INTO hot_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma doŋtom Pita hanaŋ, “Ya miŋ yahanaŋ abô avanôŋ ami, êŋ ma tem Wapômbêŋ nêm vovaŋ êndêŋ ya. Yahalam Wapômbêŋ anêŋ athêŋ ba yahanaŋ nena yahathôŋ ôpêntu paliŋ!” Ketheŋ oyaŋ ma tale halaŋ. ");
INSERT INTO hot_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma Pita lahabi abô atu ba Yisu hanaŋ hadêŋ yani nena, “Tale miŋ halaŋ ami denaŋ, ma tem onaŋ êtôm bôlôŋ lô nena hôthôŋ ya paliŋ.” Êŋ ma Pita hale yaiŋ ma lahiki ba halaŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lôkbôk momaŋiniŋ ma ŋê bêŋbêŋ êbôk da sapêŋ lôk avômalô Islael iniŋ ŋê bêŋbêŋ ethak doŋtom ma ibutiŋ abô ek nijik Yisu vônô. ");
INSERT INTO hot_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ma ekak baŋ luvi lusu ma ewa ba i hadêŋ Pailat, anyô Lom atu ba hayabiŋ Judia. ");
INSERT INTO hot_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas ôpatu ba hanaŋ Yisu bêŋ halaŋô nena lêk idum abô yôv ek nijik Yisu vônô. Êŋ ma lahiki bêŋ ba hi hêv valuseleŋ 30 seleva takatu hadêŋ ŋê bêŋbêŋ êbôk da lôk avômalô iniŋ ŋê bêŋbêŋ hathak loŋbô ");
INSERT INTO hot_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ma hanaŋ, “Lêk yahadum kambom hathak yahanaŋ ôpatu ba kambom mi bêŋ.” Êŋ ma thêlô enaŋ, “Oda anêm malaiŋ ma miŋ yêlôaniŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma Judas hakaliv valuseleŋ seleva takêŋ hayô unyak matheŋ kapô ma hi havaklôk ba hama. ");
INSERT INTO hot_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma ŋê bêŋbêŋ êbôk da isup valuseleŋ seleva takêŋ ba enaŋ, “Valuseleŋ êntêk ma valuseleŋ êv ek nijik anyô vônô esak. Ba intu abô balabuŋ hanaŋ nena valuseleŋ takêŋ ma miŋ nandô êmô imbiŋ unyak matheŋ anêŋ valuseleŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma thêlô ibutiŋ abô ek nênêm anyô hapesaŋ uŋ anêŋ pik bute vuli ek nedav avômalô loŋ buyaŋ ênjêk. ");
INSERT INTO hot_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ma avômalô elam pik êŋ nena “Eŋgasô Thalaleŋ” ek malê nena ewa valuseleŋ ek nijik anyô yaŋ vônô esak. ");
INSERT INTO hot_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ba intu Wapômbêŋ anêŋ abô hik anôŋ ba hanaŋ hadêŋ plopet Jelemaia nena, “Thêlô ewa valuseleŋ ba êv anyô hapesaŋ uŋ anêŋ pik bute vuli hatôm atu ba Wapômbêŋ hanaŋ hadêŋ ya. Valuseleŋ êŋ ma avômalô Islael elam hatôm yani anêŋ vuli ba êv ek nijik yani vônô.” ");
INSERT INTO hot_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisu hamiŋ anyô bêŋ Pailat thohavloma, ma Pailat hanaŋ, “O ma avômalô Islael iniŋ kiŋ e?” Ma Yisu hanaŋ nena, “Intu êŋ, hatôm intu honaŋ.” ");
INSERT INTO hot_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ŋê bêŋbêŋ êbôk da lôk avômalô iniŋ ŋê bêŋbêŋ ibi Yisu liŋkupik hathak abô lomaloma. ");
INSERT INTO hot_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Êŋ ma Pailat hanaŋ, “Aisê! Miŋ holaŋô iniŋ abô ami ma o bônôŋ eka?” ");
INSERT INTO hot_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma doŋtom yani bônôŋ iyom ma miŋ hanaŋ iniŋ abô viyaŋ ami. Ba intu Pailat hasoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Waklavôŋ Hale ba Hi nômbêŋ intu, ma avômalô ethak elam anyô koladôŋ te anêŋ athêŋ ek Pailat nêm vê. Ma Pailat hathak hêv ôpêŋ vê. ");
INSERT INTO hot_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sondabêŋ êŋ ma anyô te anêŋ athêŋ nena Yisu Balabas hamô koladôŋ. Ma avômalô bêŋ anôŋ eyala ôpêŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aêŋ ba avômalô sapêŋ ethak doŋtom ma Pailat hanaŋ hik thêlô liŋ, “Yatak opalê te êndêŋ môlô, Balabas mena Yisu atu ba elam nena Mesia?” ");
INSERT INTO hot_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat hayala nena ŋê bêŋbêŋ êbôk da lôk ŋê bêŋbêŋ leŋiŋdaŋ hathak Yisu ba intu idum abô ek yani ba hanaŋ aêŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat halaŋô abô denaŋ ma yanavi hêv abô hadêŋ yani ba hanaŋ, “Bôkam ma yahayê niaviŋ te ba yahakô kambom. Aêŋ ba miŋ undum nômlate êndêŋ anyô thêthôŋ intu ami.” ");
INSERT INTO hot_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma doŋtom ŋê bêŋbêŋ êbôk da lôk ŋê bêŋbêŋ êlôk avômalô leŋiŋ ek nendam Balabas ma nenaŋ êndêŋ Pailat nena nijik Yisu vônô. ");
INSERT INTO hot_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aêŋ ba Pailat hanaŋ hik thêlô liŋ, “Yatak anyô ju êntêk yaŋ sê?” Ma avômalô elam, “Balabas.” ");
INSERT INTO hot_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma Pailat hanaŋ hik thêlô liŋ hathak loŋbô nena, “Ma Yisu atu ba elam nena Mesia, yandum ôpêŋ aisê?” Ma sapêŋ elam nena, “Nijik vônô esak a!” ");
INSERT INTO hot_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma Pailat hanaŋ, “Eka? Yani hadum malê kambom?” Ma doŋtom thêlô elam lôklala hathak loŋbô nena, “Nijik vônô esak a!” ");
INSERT INTO hot_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat halaŋô thêlôniŋ kaêk ma hayê nena vovak bêŋ hadum ek imbitak ba anêŋ ku êŋ tem miŋ hik anôŋ ami. Êŋ ma yani hawa ŋaŋ ma hathik baŋ hamiŋ avômalô maleŋiŋ ma hanaŋ nena, “Ôpêntêk hama, ma môlôda unim malaiŋ ma miŋ yenaŋ malaiŋ ami!” ");
INSERT INTO hot_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma avômalô sapêŋ enaŋ viyaŋ, “Yôv! Yêlô lôk yêlôaniŋ avômena iniŋ malaiŋ!” ");
INSERT INTO hot_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Êŋ ma Pailat hatak Balabas ba hi. Ma hanaŋ ek nebali Yisu esak yak lôkmaŋgiŋ vêm ma hatak halôk ŋê vovak baheŋiŋ ek nijik vônô esak a. ");
INSERT INTO hot_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailat anêŋ ŋê vovak ewa Yisu ba i Pailat anêŋ unyak badêŋ kapô. Ma elam ŋê vovak sapêŋ êlêm ethak doŋtom ba ekalabu yani siŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma ibi anêŋ nômkama thô ba hamiŋ liŋ popam. Ma ewa kiŋ anêŋ kwêv thalaleŋ daim te ma ik hathak yani. ");
INSERT INTO hot_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma ewa yak lôkmaŋgiŋ atu ba epesaŋ hatôm kiŋ iniŋ kuluŋ ma ik halôk wakadôk. Ma etak kôm halôk yani baŋ vianôŋ ba havaloŋ hatôm kiŋ iniŋ kwandiŋ. Ma thêlô elek veŋiŋdôŋ lêlô hadêŋ yani ma enaŋ abôma nena, “Waklêvôŋ mavi, avômalô Islael iniŋ kiŋ!” ");
INSERT INTO hot_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma vi êsôvwapôk hathak yani ma vi ewa kwandiŋ atu ba ik wakadôk hathak. ");
INSERT INTO hot_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ma enaŋ abôma hathak yani vêm ma ibi kwêv thalaleŋ atu thô ma ik yanida anêŋ kwêv daim hathak loŋbô. Ma elom yani ba i ek nijik vônô esak a. ");
INSERT INTO hot_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ewa ba i ma êpôm anyô Sailini te ba anêŋ athêŋ nena Saimon halôk loŋôndê. Ma êpôviŋ ôpêŋ ek enja Yisu anêŋ alovalaŋaŋsiŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Êŋ ma thêlô i êyô loŋ te anêŋ athêŋ nena Golgota, athêŋ êŋ anêŋ ôdôŋ nena Loŋ Leŋkadôk Lokwaŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Loŋ êŋ ma thêlô ewa waiŋ ba eyelaŋ nôm maniŋ te halôk ma êv hadêŋ yani ek inum ek miŋ vovaŋ bêŋ anôŋ ami. Yani hanum dokte iyom ma hadô. ");
INSERT INTO hot_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Êŋ ma thêlô ik yani loŋ hathak a. Vêm ma ibi valu ek nêgê nena opalêla intu tem neja anêŋ kwêv lo sôp. ");
INSERT INTO hot_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Vêm ma êlôk êmô ma eyabiŋ iniŋ ku êŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yani wakadôk vuliŋ ma eto abô atu ba idum anêŋ abô ŋama hathak ba eto nena, ÔPÊNTÊK MA YISU, AVÔMALÔ ISLAEL INIŊ KIŊ ");
INSERT INTO hot_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ma êthôkwêŋ anyô vani lokwaŋju haviŋ. Êthôkwêŋ yaŋ hamiŋ Yisu baŋ vianôŋ, ma yaŋ hamiŋ baŋ vikeŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma avômalô takatu ba elom loŋôndê êŋ ba i ibi abôma hathak yani lôk itutuniŋ leŋiŋkadôk ");
INSERT INTO hot_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ba enaŋ, “O atu ba honaŋ nena tem undiniŋ Wapômbêŋ anêŋ unyak matheŋ ma ondav esak loŋbô êtôm wak lô iyom e? Êŋ ma nêm oda bulubiŋ! O ma Wapômbêŋ anêŋ Nakaduŋ, e? Êŋ ma otak alovalaŋaŋsiŋ ma ôlêm pik!” ");
INSERT INTO hot_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ lôk avômalô iniŋ ŋê bêŋbêŋ, thêlô enaŋ abôma haviŋ ba enaŋ, ");
INSERT INTO hot_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ôŋgô! Yani bôk hêv avômalô vi bulubiŋ, ma doŋtom miŋ hatôm nêm yanida bulubiŋ ami eka? Yani ma Islael iniŋ kiŋ e? Êŋ ma etak alovalaŋaŋsiŋ ba êlêm pik ek alalô nagê ba nanêmimbiŋ yani! ");
INSERT INTO hot_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ôpêŋ hêvhaviŋ Wapômbêŋ ba hanaŋ, ‘Ya Wapômbêŋ anêŋ Nakaduŋ’. Yôv! Alalô nagê! Wapômbêŋ lahaviŋ nêm yani bulubiŋ e?” ");
INSERT INTO hot_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma anyô kambom ju atu ba imiŋ alovalaŋaŋsiŋ haviŋ yani enaŋ abôma haviŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Waklêvôŋ biŋ ma momaŋiniŋ hayô pik sapêŋ vôv ba hêk aleba hayô 3 kilok. ");
INSERT INTO hot_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Habobo 3 kilok ma Yisu halam lôklala nena, “Eloi, Eloi, lama sabaktani?” Abô êŋ anêŋ ôdôŋ aêntêk, “Yenaŋ Wapômbêŋ, yenaŋ Wapômbêŋ, aisê ka hôdô ya?” ");
INSERT INTO hot_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma avômalô vi atu ba imiŋ loŋ êŋ elaŋô abô êŋ ma enaŋ, “Yani halam Elia!” ");
INSERT INTO hot_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ketheŋ oyaŋ ma ŋê êŋ te hi ma hawa kapôk ba hasoŋ halôk waiŋ maniŋ. Ma hathôkwêŋ kapôk êŋ hathak apiyak te ba hêv hadêŋ yani ek inum. ");
INSERT INTO hot_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma anyô vi enaŋ, “Dô! Alalô nagê vêmam! Yakô Elia tem êlêm nêm yani bulubiŋ la?” ");
INSERT INTO hot_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma yani halam kaêk lôklala hathak loŋbô ma hatak dahô ba hi ma hama. ");
INSERT INTO hot_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma sôp bêŋ atu ba hamiŋ unyak matheŋ ek hayaŋ unyak kapô kisi ma hapup vose hi luvi hêk vuliŋ ba hayô vibiŋ. Ma duviaŋ hayôkwiŋ pik ma valu hapupup nenanena. ");
INSERT INTO hot_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Ma siô abôlêk hakyav. Ma avômalô matheŋ sêbôk atu ba ema ma Wapômbêŋ hik i liŋ ba etak siô ma iviyô hathak loŋbô. Ma eyabiŋ Yisu anêŋ haviyô hathak loŋbô, êŋ ma thêlô lôkthô i unyak matheŋ Jelusalem. Ma avômalô bêŋ anôŋ êyê i. ");
INSERT INTO hot_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma anyô vovak laik lôk ŋê vovak takatu ba eyabiŋ Yisu êmô êyê duviaŋ lôk nôm takatu ba habitak. Êŋ ma thêlô êkô kambom ba enaŋ nena, “Avanôŋ biŋ, ôpêntêk ma Wapômbêŋ anêŋ Nakaduŋ anôŋ!” ");
INSERT INTO hot_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Ma Malia anêŋ Magadala, ma Malia Jems lo Josep iniŋ talêbô, ma Sebedi anêŋ nakaduŋ luvi iniŋ talêbô, thêlô lôk avi bêŋ anôŋ imiŋ daim dokte ba êyê. Avi takêŋ bôk etak Galili ma eveŋ haviŋ Yisu ek êv yani sa. ");
INSERT INTO hot_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Yaŋsiŋ ma anyô lôk valuseleŋ bêŋ te anêŋ Alimatia ba anêŋ athêŋ nena Josep halêm hayê Pailat. Yani bôk halaŋô Yisu anêŋ abô ba hasopa ba intu hi hanaŋ hadêŋ Pailat nena, “Hatôm yanja Yisu anêŋ kupik e?” Êŋ ma Pailat hanaŋ hadêŋ ŋê vovak ba êv hadêŋ Josep. ");
INSERT INTO hot_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma Josep hawa Yisu liŋkupik ba havuliv siŋ hathak sôp thapuk mabuŋ mavi te. ");
INSERT INTO hot_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ma hawa Yisu liŋkupik ba hi hadô hêk anêŋ siô lukmuk te. Siô êŋ ma elav valu abyaŋ ba epesaŋ ek nedav ŋê ŋama êndôk. Yôv ma habubi valu bêŋ te ba hik siô abôlêk siŋ hathak ma hi. ");
INSERT INTO hot_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ma Malia anêŋ Magadala, thai lôk Malia yaŋ, êmô saku ma êyê siô êŋ. ");
INSERT INTO hot_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Waklavôŋ êpôpêk nômkama Sabat lêk hale ba hi yôv. Ma haviyô hayaŋ ma ŋê bêŋbêŋ êbôk da lôk ŋê Palisi i ek nêgê Pailat. ");
INSERT INTO hot_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma thêlô enaŋ, “Anyô bêŋ, yêlô leŋhabi nena anyô abôyaŋ atu hamô lôkmala denaŋ ma hanaŋ nena êtôm wak lô, ma tem nijik yani liŋ ba imbiyô esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","“Ba intu nêm ŋê vovak ini ek neyabiŋ siô êtôm wak lô êŋ. Yakô yanida anêŋ ŋê ku ini neja anêŋ kupik vani ma nesau avômalô nena, ‘Wapômbêŋ lêk hik yani liŋ ba haviyô hathak loŋbô.’ Abôyaŋ êŋ ma tem kambom anôŋ ek yaŋ môŋ atu.” ");
INSERT INTO hot_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Êŋ ma Pailat hanaŋ hadêŋ thêlô, “Mavi. Noja ŋê vovak doho ba unu ek nepesaŋ siô abôlêk êŋ ba majaŋ.” ");
INSERT INTO hot_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Êŋ ma thêlô i ma ebalaŋ valu atu ba hamô siô abôlêk siŋ. Yôv ma thêlô enaŋ hadêŋ ŋê vovak, “Môlô nômô ek noyabiŋ siô êntêk.” ");
INSERT INTO hot_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat hale ba hi. Ma sonda êŋ anêŋ wak te môŋ hayô. Lôkbôk momaŋiniŋ ma Malia anêŋ Magadala lôk Malia yaŋ thai i ek nêgê siô. ");
INSERT INTO hot_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma duviaŋ bêŋ hayô ek malê nena Anyô Bêŋ anêŋ aŋela te halôk anêŋ leŋ ba halêm ba habubi valu bêŋ atu vê ma hayô hamô loŋ ba hamô. ");
INSERT INTO hot_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anêŋ thohavloma hatôm damak ma anêŋ kwêv ma thapuk anêŋ dôêŋ. ");
INSERT INTO hot_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma ŋê vovak êyê ba êkô kambom ba elowaliŋ. Ba êv yak êlôk êk êtôm ŋê ŋama. ");
INSERT INTO hot_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Êŋ ma aŋela hanaŋ hadêŋ avi ju êŋ, “Miŋ nôkô ami. Yahayala nena mamu ôbôlêm Yisu, ôpatu ba ik hathak a. ");
INSERT INTO hot_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wapômbêŋ lêk hik yani liŋ yôv ba haviyô hathak loŋbô hatôm bôk ba hanaŋ. Yani miŋ hêk loŋ êntêk ami ma lêk hi yôv. Ma nôlêm ek ôŋgô loŋ atu ba yani hêk. ");
INSERT INTO hot_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mamu ketheŋ ba unu nonaŋ êndêŋ anêŋ ŋê ku nena, ‘Wapômbêŋ lêk hik yani liŋ hêk ŋama ba haviyô hathak loŋbô. Ma lêk hamôŋ ek môlô ba hi Galili. Ôyô loŋ êŋ ma tem nôpôm yani.’ Abô êntêk intu yahalêm hathak.” ");
INSERT INTO hot_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Avi ju êŋ elaŋô abô êŋ ba êkô, ma doŋtom thai leŋiŋmavi anôŋ haviŋ. Ma thai etak siô ma elaŋviŋ ketheŋ ba i ek nenaŋ abô êŋ êndêŋ anêŋ ŋê ku. ");
INSERT INTO hot_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma Yisu hapôm thai ma hanaŋ, “Lôkbôk mavi.” Ma thai i evaloŋ vakapô ma êv yeŋ hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Êŋ ma hanaŋ, “Mamu miŋ nôkô ami ma unu nonaŋ êndêŋ yenaŋ aiyaŋ thêlô nena ini Galili. Loŋ êŋ ma tem thêlô nêpôm ya.” ");
INSERT INTO hot_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Avi ju êŋ eveŋ denaŋ ma ŋê vovak doho eyabiŋ siô êyô Jelusalem. Ma thêlô i hadêŋ ŋê bêŋbêŋ êbôk da ma enaŋ abô hathak duviaŋ lôk aŋela. ");
INSERT INTO hot_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma ŋê bêŋbêŋ êbôk da lôk ŋê bêŋbêŋ ethak doŋtom ma epesaŋ abô ek nênêm valuseleŋ bêŋ anôŋ êndêŋ ŋê vovak. ");
INSERT INTO hot_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ma thêlô enaŋ hadêŋ ŋê vovak nena, “Môlô nonaŋ aêntêk êndêŋ avômalô, ‘Yêlô ek sôm ba athôŋ paliŋ ma Yisu anêŋ ŋê ku êlêm hadêŋ bôlôvôŋ ma ewa anêŋ kupik vani.’” ");
INSERT INTO hot_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma thêlô enaŋ abô doho haviŋ hadêŋ ŋê vovak nena, “Anyô bêŋ Pailat halaŋô abô hathak nôm êŋ, ma yêlô tem napesaŋ abô imbiŋ yani ek môlô miŋ nôpôm malaiŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ma ŋê vovak ewa valuseleŋ ma idum hatôm atu ba ŋê bêŋbêŋ enaŋ. Ma abô êŋ intu hi haveŋ Islael iniŋ loŋ sapêŋ ba enaŋ aêŋ aleba lêk. ");
INSERT INTO hot_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ŋê ku laumiŋ ba lahavute i Galili ma êyô dumlolê atu ba Yisu bôk hanaŋ yôv nena thêlô ini. ");
INSERT INTO hot_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Thêlô êyê Yisu ma êv yeŋ hadêŋ yani. Ma doho êthôŋ paliŋ dokte ba leŋiŋhabi nena, “Êntêk ma Yisu mena mi e?” ");
INSERT INTO hot_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Êŋ ma halêm ma hanaŋ hadêŋ i, “Wapômbêŋ hêv athêŋ bêŋ hadêŋ ya ek yayabiŋ leŋ lôk pik lôkthô. ");
INSERT INTO hot_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aêŋ ba môlô unu êtôm pik sapêŋ ma nundum avômalô sapêŋ ba nimbitak êtôm yenaŋ avômalô. Ma nusik thêlô êndôk ŋaŋ esak Wapômbêŋ lôk Nakaduŋ ma Lovak Matheŋ iniŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma nôndôŋ thêlô ek nesopa abô nômbêŋ atu ba bôk yahêv hadêŋ môlô yôv. Odaŋô! Tem yamô imbiŋ môlô êtôm wak nômbêŋ intu sapêŋ endeba pik lo leŋ anêŋ daŋ.” ");
INSERT INTO hot_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Abô Mavi êntêk ma hathak Wapômbêŋ nakaduŋ Yisu Kilisi. ");
INSERT INTO hot_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hatôm plopet Aisaia bôk hato aêntêk, “Ondaŋô! Tem yanêm yenaŋ anyô ku te ek enja abô êmôŋ ek o, ôpêŋ tem êpôpêk anêm loŋôndê. ");
INSERT INTO hot_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kaêk te halam haveŋ loŋ thiliv nena, ‘Nôpôpêk loŋôndê ek Anyô Bêŋ êlêm, ma nopesaŋ ba imbitak thêthôŋ ek yani.’” ");
INSERT INTO hot_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aêŋ ba Jon anyô hathik ŋaŋ habitak anêŋ loŋ thiliv ba hanaŋ ek avômalô nede kapôlôŋiŋ liliŋ ba nisik ŋaŋ ek Wapômbêŋ nêm iniŋ kambom vê. ");
INSERT INTO hot_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Êŋ ma avômalô Judia lo Jelusalem sapêŋ ibi thêthô ba i hadêŋ yani ek enaŋ iniŋ kambom bêŋ. Ma Jon hathik i halôk ŋaŋ Jolodaŋ. ");
INSERT INTO hot_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ma hathak hik kwêv atu ba epesaŋ hathak bok kamel vuluk ma havak bokŋgôp epesaŋ hathak bok kupik hayôhêk lamalim. Ma hathak hayaŋ kôm sopek lôk hanum biyo thôk. ");
INSERT INTO hot_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma hanaŋ nena, “Ôpatu ba tem embeŋ ya yam anêŋ lôklokwaŋ ma bomaŋ ek yenaŋ. Yani ma anyô lôk athêŋ bêŋ ma ya ma yaônalôk ba intu miŋ hatôm yakôm ba yapole anêŋ vakapô bokŋgôp anêŋ yak vê ami. ");
INSERT INTO hot_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yahathik môlô hathak ŋaŋ. Ma doŋtom yani tem isik môlô esak Lovak Matheŋ.” ");
INSERT INTO hot_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wak te ma Yisu hatak Nasalet anêŋ Galili ba halêm ma Jon hathik yani halôk ŋaŋ Jolodaŋ. ");
INSERT INTO hot_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yisu haviyô anêŋ ŋaŋ kapô ma hayê leŋ hakyav ma Lovak Matheŋ halôk ba halêm ek yani hatôm menak bôbô. ");
INSERT INTO hot_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma abô te halêm anêŋ leŋ nena, “O ma yenaŋ Okna atu ba yaleŋhaviŋ. Yaleŋmavi anôŋ hathak o.” ");
INSERT INTO hot_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma ketheŋ oyaŋ ma Lovak Matheŋ hêv Yisu vê hi loŋ thiliv. ");
INSERT INTO hot_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yisu hamô loŋ êŋ hatôm wak 40, êŋ ma Sadaŋ hayô ba halôk yani la. Yani hamô haviŋ alim bomaŋ ma aŋela eyabiŋ yani. ");
INSERT INTO hot_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Etak Jon halôk koladôŋ, êŋ ma Yisu hi Galili ma hanaŋ Wapômbêŋ anêŋ Abô Mavi bêŋ nena, ");
INSERT INTO hot_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Wakma lêk hayô yôv ba Wapômbêŋ anêŋ loŋ lôkliŋyak lêk habobo. Aêŋ ba node kapôlômim liliŋ lôk nônêmimbiŋ Wapômbêŋ anêŋ Abô Mavi!” ");
INSERT INTO hot_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yisu habup hathak kasukthôm Galili anêŋ daŋ ma hayê Saimon lo yaŋ Andulu. Thai ma ŋê ik alim ba lêk ekaliv yakseŋ haveŋ. ");
INSERT INTO hot_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma Yisu hanaŋ hadêŋ thai, “Mamu nôlêm nosopa ya. Tem yandum ba mamu nôbôv avômalô êtôm ôvôv alim halôk yakseŋ.” ");
INSERT INTO hot_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ketheŋ oyaŋ ma thai êdô iniŋ yakseŋ hamô ma esopa yani. ");
INSERT INTO hot_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yisu habup hathak vauna ma hayê Jems lo Jon. Thai ma Sebedi nali ba êmô iniŋ yeŋ ma idu iniŋ yakseŋ titip. ");
INSERT INTO hot_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hayê thai ma halam, êŋ ma êdô lambô Sebedi hamô yeŋ haviŋ anêŋ ŋê ku, ma i esopa yani. ");
INSERT INTO hot_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ma Yisu thêlô êyô Kapaneam ba êmô. Ma Sabat hayô ba Yisu hi unyak yeŋ ma hadôŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Thêlô elaŋô anêŋ abô ba esoŋ kambom ma leŋiŋhabi nena yani miŋ hadôŋ i hatôm ŋê lôkauk hathak abô balabuŋ ami. Mi, hadôŋ i hatôm anyô lôk athêŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma anyô te hamô unyak yeŋ êŋ ba ŋgôk lelaik hamô haviŋ yani. Ma halam nena, ");
INSERT INTO hot_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yisu anêŋ Nasalet, hôlêm ek udum malê êndêŋ yêlô? Hôlêm ek umbuliŋ yêlô e? Yahayala o. O ma Wapômbêŋ anêŋ Anyô Matheŋ.” ");
INSERT INTO hot_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Êŋ ma Yisu hathaŋ ŋgôk êŋ ba hanaŋ, “O bônôŋ ma otak ôpêntu!” ");
INSERT INTO hot_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma ŋgôk lelaik êŋ hayôkwiŋ ôpêŋ kambom anôŋ ba haŋgaliak ma hatak ôpêŋ ba hi. ");
INSERT INTO hot_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma avômalô sapêŋ esoŋ kambom ba enaŋ hadêŋ i, “Malê êntêk aêŋ am? Yani hadôŋ auk lukmuk hatôm anyô lôk athêŋ bêŋ. Ma hanaŋ lôklokwaŋ hadêŋ ŋgôk lelaik ma elaŋô anêŋ abô ba esopa.” ");
INSERT INTO hot_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma abô hathak Yisu halaŋviŋ haveŋ Galili iniŋ loŋ sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ma Yisu thêlô etak unyak yeŋ, ma i Saimon lo Andulu iniŋ unyak. Ma Jems lo Jon i iviŋ. ");
INSERT INTO hot_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Êyô unyak, ma enaŋ hadêŋ Yisu nena Saimon yaŋavi hapôm lijiŋ vovaŋ ba hêk. ");
INSERT INTO hot_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma Yisu hi hadêŋ avi êŋ ma havaloŋ baŋ ma hadadi haviyô. Êŋ ma lijiŋ hatak yani ma hapôpêk nôm ek thêlô. ");
INSERT INTO hot_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wak halôk abuk ma avômalô ewa ŋê lôk lijiŋ lôk ŋê takatu ba ŋgôk habuliŋ i ba êlêm ek Yisu. ");
INSERT INTO hot_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Lôk avômalô malak lôŋ êŋ sapêŋ êlêm iviŋ ba êmô unyak anêŋ piklêvôŋ. ");
INSERT INTO hot_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Êŋ ma Yisu hadum avômalô lôk lijiŋ lomaloma bêŋ anôŋ mavi. Ma hêv ŋgôk bêŋ anôŋ vê haviŋ. Ŋgôk takêŋ eyala nena yani intu opalê ba miŋ hatak i ek nenaŋ abô ami. ");
INSERT INTO hot_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lôkbôk momaŋiniŋ mi ma Yisu haviyô ba hi loŋ thiliv ek eteŋ mek. ");
INSERT INTO hot_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma Saimon thêlô i êbôlêm yani haveŋ. ");
INSERT INTO hot_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Êpôm yani ma enaŋ, “Avômalô sapêŋ êbôlêm o haveŋ.” ");
INSERT INTO hot_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Yisu hanaŋ, “Alôana buyaŋ. Alôana malak lôŋ takatu ba hamô habobo ek yanaŋ Wapômbêŋ anêŋ abô êndêŋ i imbiŋ. Hathak ôdôŋ êŋ iyom intu yahalêm.” ");
INSERT INTO hot_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma Yisu haveŋ Galili iniŋ loŋ sapêŋ ma hanaŋ Wapômbêŋ anêŋ abô hamô iniŋ unyak yeŋ lôk hêv ŋgôk bêŋ anôŋ vê hêk avômalô. ");
INSERT INTO hot_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ma anyô lepla te hi hayô ek Yisu ma halek vadôŋ lêlô ma habui hadêŋ Yisu ba hanaŋ, “Hathak oda anêm lemhaviŋ, ma hatôm undum ba yambitak mavi.” ");
INSERT INTO hot_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma Yisu lahiki hathak ôpêŋ ba hatak baŋ hayôhêk yani ma hanaŋ, “Yaleŋhaviŋ. Umbitak mabuŋ mavi.” ");
INSERT INTO hot_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Êŋ ma palê lepla êŋ hayôv ma liŋkupik habitak mabuŋ mavi. ");
INSERT INTO hot_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ma Yisu hêv ôpêŋ ba hi ketheŋ ma hanaŋ lôklokwaŋ hadêŋ yani nena, ");
INSERT INTO hot_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Miŋ onaŋ nôm êŋ bêŋ êndêŋ avômalô vi ami. Nu êndêŋ ŋê êbôk da ma nuŋgwik o thô êndêŋ i iyom. Ma osopa balabuŋ atu ba Mose bôk hato ba nêm da ek ŋê êbôk da nêgê o nena lêk hubitak mabuŋ.” ");
INSERT INTO hot_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma doŋtom ôpêŋ miŋ hasopa Yisu anêŋ abô thêthôŋ ami. Mi, hanaŋ bêŋ ba abô êŋ hi mayaliv. Ba intu Yisu miŋ hatôm ni lomalak nenanena ami. Mi, hi haveŋ loŋ thiliv, ma avômalô êlêm anêŋ luvuluvu ba êyô ek nêgê yani. ");
INSERT INTO hot_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wak doho hale ba hi ma Yisu hi Kapaneam hathak loŋbô ma avômalô elaŋô nena Yisu lêk hayô anêŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Êŋ ma avômalô bêŋ anôŋ êlêm ba êmô unyak kapô êŋ aleba putup, ma unyak abôlêk putup aêŋ iyom. Ma Yisu hanaŋ Wapômbêŋ anêŋ abô hadêŋ i. ");
INSERT INTO hot_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma anyô doho ewa anyô havuviŋ te ba êlêm ma anyô ayova evak. ");
INSERT INTO hot_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Avômalô bêŋ anôŋ ba loŋ putup ba miŋ hatôm neja ôpêŋ ba ini unyak kapô ek Yisu ami. Ba ethak unyak vôv ba êŋgô unyak vôv abyaŋ ma êlêlô ôpêŋ halôk yêm aleba habup ek Yisu. ");
INSERT INTO hot_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yisu hayê thêlôniŋ êvhaviŋ, ma hanaŋ hadêŋ anyô havuviŋ atu nena, “Yenaŋ okna, lêk yahêv anêm kambom sapêŋ vê.” ");
INSERT INTO hot_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma ŋê lôkauk hathak abô balabuŋ doho êmô haviŋ ba leŋiŋhabi nena, ");
INSERT INTO hot_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Aisê ka ôpêntêk hanaŋ aêŋ? Ôpêŋ hasoŋ nena yani ma Wapômbêŋ e? Anyô late miŋ hatôm nêm kambom vê ami ma Wapômbêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yisu hayala thêlôniŋ auk ba hanaŋ nena, “Aisê ka môlô lemimhikam hathak abô êntêk? ");
INSERT INTO hot_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Abô alê intu vumvum ek yanaŋ êndêŋ anyô havuviŋ êntêk: ‘Lêk yahêv anêm kambom sapêŋ vê’ mena ‘Umbiyô onja anêm yêm ba ombeŋ.’ ");
INSERT INTO hot_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aêŋ ba tem yaŋgik thô êndêŋ môlô nena Anyô Anêŋ Nakaduŋ atu anêŋ athêŋ ma bêŋ ba hatôm nêm kambom vê.” Êŋ ma hanaŋ hadêŋ anyô havuviŋ atu aêntêk, ");
INSERT INTO hot_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Yanaŋ êndêŋ o nena umbiyô umiŋ ma onja anêm yêm ba nu anêm unyak.” ");
INSERT INTO hot_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Êŋ ma ôpêŋ haviyô anêŋ avômalô malêvôŋ ma hawa anêŋ yêm ma hale yaiŋ ba hi. Avômalô esoŋ kambom ba êbô Wapômbêŋ anêŋ athêŋ ba enaŋ, “Yêlô miŋ bôk ayê nômlate aêntêk ami!” ");
INSERT INTO hot_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ma Yisu hatup hi kasukthôm anêŋ daŋ. Ma avômalô bêŋ anôŋ êyô ma yani hadôŋ i. ");
INSERT INTO hot_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yani habup hathak ma hayê Livai, Alpius nakaduŋ hamô unyak ewa takis. Ma hanaŋ, “Ôlêm osopa ya.” Êŋ ma haviyô ba hi hasopa yani. ");
INSERT INTO hot_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yisu hayaŋ nôm haviŋ Livai hamô anêŋ unyak. Ma ŋê ewa takis lôk ŋê idum kambom bêŋ anôŋ êyô eyaŋ nôm haviŋ yani lôk anêŋ ŋê ku ek malê nena thêlô bêŋ anôŋ esopa Yisu. ");
INSERT INTO hot_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ma Palisi doho atu ba ŋê lôkauk hathak abô balabuŋ êyê ma enaŋ hik anêŋ ŋê ku liŋ, “Yisu hayaŋ nôm haviŋ ŋê ewa takis lôk ŋê idum kambom eka?” ");
INSERT INTO hot_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yisu halaŋô iniŋ abô ma hanaŋ, “Ŋê lôk lijiŋ iyom intu ethak i êyê dokta. Ma ŋê lijiŋ mi ma mi. Ma aêŋ iyom yahalêm ek yandam ŋê takatu ba idum kambom. Ma miŋ yahalêm ek yandam ŋê thêthôŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wak te ma Jon anêŋ ŋê ku lôk Palisi esopa iniŋ kobom evak balabuŋ ek nôm ek leŋiŋhabi Wapômbêŋ. Ma avômalô doho êyô ek Yisu ma enaŋ hik liŋ, “Jon lo Palisi iniŋ ŋê ku evak balabuŋ ek nôm ma anêm ma mi eka?” ");
INSERT INTO hot_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma Yisu hanaŋ, “Anyô te hawa avi lukmuk, êŋ ma anêŋ anyô môlô eyaŋ nôm lôk leŋiŋmavi. Ma miŋ hatôm nembak balabuŋ ek nôm ami. ");
INSERT INTO hot_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma doŋtom haveŋ yam, ba ewa yani vê hêk thêlô, êŋ ma anêŋ ŋê môlô tem nembak balabuŋ ek nôm. ");
INSERT INTO hot_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Anyô late hatôm enja sôp lukmuk bute ba indu sôp bô anêŋ abyaŋ siŋ esak ami. Hadum aêŋ ma tem sôp lukmuk buêŋ êmô sôp bô kisi. Êŋ ma tem itip bêŋ. ");
INSERT INTO hot_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma môlô othak ôkê waiŋ lukmuk halôk kolopak epesaŋ hathak bok kupik bô e? Mi! Waiŋ lukmuk êŋ tem imbuliŋ bok kupik bô atu ba bôk thekthek ba tem ipup ba waiŋ eŋgasô ni. Ba intu othak ôkê waiŋ lukmuk halôk bok kupik lukmuk atu ba belap ek isiŋ mavi ma miŋ ipup ami lôk waiŋ miŋ eŋgasô ni ami.” ");
INSERT INTO hot_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat te ma Yisu lôk anêŋ ŋê ku i eveŋ ku kapô te, ma ŋê ku ewa wit doho ek nejaŋ. ");
INSERT INTO hot_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma Palisi enaŋ hadêŋ Yisu, “Ondaŋô! Abô balabuŋ hanaŋ nena Sabat ma miŋ hatôm nandum ku ba naja nôm ek naŋgaŋ ami. Ma doŋtom anêm ŋê ku ibuliŋ waklavôŋ êŋ!” ");
INSERT INTO hot_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ma Yisu hanaŋ nena, “Môlô bôk osam abô hathak Devit lôk anêŋ ŋê môlô ema kisi ba idum e? ");
INSERT INTO hot_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sêbôk atu ba Abiata hadum ku anyô bêŋ habôk da, ma Devit habitak hayô Wapômbêŋ anêŋ unyak matheŋ kapô ma hayaŋ polom atu ba matheŋ anôŋ. Polom êŋ ma ŋê êbôk da iyom iniŋ ek nejaŋ ba intu habuliŋ abô balabuŋ buêŋ. Ma doŋtom Devit hayaŋ doho ma hêv doho hadêŋ anêŋ ŋê takatu ba iviŋ yani ba eyaŋ.” ");
INSERT INTO hot_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma Yisu hanaŋ hadêŋ thêlô, “Wapômbêŋ hapesaŋ Sabat ek nêm avômalô sa ma miŋ hapesaŋ avômalô ek Sabat eyabiŋ i ami. ");
INSERT INTO hot_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aêŋ ba Anyô Anêŋ Nakaduŋ atu ma Sabat anêŋ Alaŋ.” ");
INSERT INTO hot_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ma Yisu habitak hayô unyak yeŋ kapô hathak loŋbô. Ma anyô baŋ hatyôk te hamô unyak êŋ kapô. ");
INSERT INTO hot_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma ŋê takatu ba êbôlêm loŋôndê ek nenaŋ Yisu bêŋ êmô ma ititiŋ yani nena tem indum ôpêŋ mavi êndêŋ Sabat mena mi e? ");
INSERT INTO hot_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Êŋ ma Yisu hanaŋ hadêŋ ôpatu ba baŋ hatyôk nena, “Umbiyô umiŋ ek avômalô sapêŋ nêgê o.” ");
INSERT INTO hot_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Vêm ma hanaŋ hik thêlô liŋ nena, “Alalô hatôm nandum malê ek nasopa balabuŋ Sabat? Hatôm alalô nandum mavi mena nandum kambom? Hatôm alalô nanêm anyô sa ek êmô lôkmala mena naŋgik i vônô?” Ma doŋtom sapêŋ bônôŋ. ");
INSERT INTO hot_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ma Yisu lamaniŋ ba hatitiŋ i hawê haveŋ lôk lamalaiŋ hathak thêlô evaloŋ kapôlôŋiŋ loŋ. Êŋ ma hanaŋ hadêŋ ôpatu, “Oto bahem.” Ma ôpêŋ hato baŋ ma baŋ êŋ habitak mavi hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yôv ma Palisi ethak doŋtom haviŋ avômalô Islael vi atu ba esopa Helot. Ma evak abô ek nêpôm loŋôndê te ek nijik Yisu vônô. ");
INSERT INTO hot_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yisu lôk anêŋ ŋê ku etak loŋ êŋ ba i kasukthôm anêŋ daŋ ma avômalô Galili bêŋ anôŋ esopa yani. ");
INSERT INTO hot_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Avômalô anêŋ Judia ma Jelusalem lo Idumia ma ŋaŋ Jolodaŋ vi lôk Taia ma Saidon, bêŋ anôŋ elaŋô nôm takatu ba Yisu hadum ba intu êlêm ek nêgê yani. ");
INSERT INTO hot_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ma Yisu hayê avômalô bêŋ anôŋ ba hanaŋ hadêŋ anêŋ ŋê ku nena nêpôm yeŋ te yapiŋ ek avômalô ekalabu yani siŋ ma esak yeŋ êŋ ba ni êmô. ");
INSERT INTO hot_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ek malê nena bôk hadum avômalô lôk lijiŋ bêŋ anôŋ mavi ba avômalô takatu ba idum lijiŋ denaŋ intu lôklokwaŋ ek nêsôm yani. ");
INSERT INTO hot_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma ŋgôk lelaik takatu êyê yani ma êv yak êlôk êk yani ma ba elaŋ lôklala nena, “O ma Wapômbêŋ anêŋ Nakaduŋ.” ");
INSERT INTO hot_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma doŋtom Yisu hanaŋ lôklokwaŋ hadêŋ thêlô ek miŋ nenaŋ yani bêŋ êndêŋ anyôla ami. ");
INSERT INTO hot_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ma Yisu hathak dum te ba hi ma halam ŋê takatu ba yani lahaviŋ ba i hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma habi baŋ hayô hamiŋ anyô hatôm laumiŋ ba lahavuju ma halam i nena aposel. Yani hatak i ek nêmô imbiŋ yani lôk nêm i ba ini ek nenaŋ Wapômbêŋ anêŋ abô bêŋ. ");
INSERT INTO hot_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma yani lahaviŋ nêm lôklokwaŋ êndêŋ thêlô ek nênêm ŋgôk lomaloma vê. ");
INSERT INTO hot_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Êntêk ma anyô laumiŋ ba lahavuju takatu ba Yisu halam i. Saimon atu ba halam nena Pita ma ");
INSERT INTO hot_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems lo yaŋ Jon, thai iniŋ lambô ma Sebedi. Ma halam i nena Boanegis. Boanegis anêŋ ôdôŋ nena Kakalu anêŋ Nali. ");
INSERT INTO hot_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ma Andulu lôk Pilip ma Batolomiu lo Matyu ma Tomas lo Jems Alpius nakaduŋ ma Tadius lôk Saimon anyô Selot te ");
INSERT INTO hot_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iskaliot, ôpatu vêm ma hanaŋ Yisu bêŋ. ");
INSERT INTO hot_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma Yisu lôk anêŋ ŋê ku êyô unyak te kapô ma avômalô bêŋ anôŋ êyô ba ekalabu thêlô siŋ hathak loŋbô aleba miŋ hatôm nejaŋ nôm ami. ");
INSERT INTO hot_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma Yisu anêŋ avômalô elaŋô abô hathak nôm êŋ ma êlêm ek neja yani ba ini neyabiŋ ek malê nena avômalô enaŋ nena anêŋ auk lêk molo. ");
INSERT INTO hot_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ŋê lôkauk hathak abô balabuŋ anêŋ Jelusalem êlôk ba êlêm ma enaŋ, “Belsebul hamô haviŋ yani! Ba intu hêv ŋgôk vê hathak ŋgôk iniŋ anyô bêŋ Belsebul anêŋ lôklokwaŋ.” ");
INSERT INTO hot_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ma Yisu halam thêlô êlêm ethak doŋtom ma hanaŋ abô loŋ kapô doho hadêŋ i. “Sadaŋ hatôm nêm Sadaŋ vê e? ");
INSERT INTO hot_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mi, avômalô loŋ bêŋ te evaki vose hi ôdôŋ ju, êŋ ma tem nênêm yak. ");
INSERT INTO hot_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lôk avômalô ôdôŋ te evaki vose hi ôdôŋ ju, êŋ ma tem nênêm yak aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ba intu Sadaŋ hik vovak haviŋ yanida ba havaki vose hi ôdôŋ ju, êŋ ma tem yani nêm yak ba tem miŋ êmô ami. ");
INSERT INTO hot_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Odaŋô abô yaŋ imbiŋ. Anyô te hatôm imbitak êyô anyô lôklokwaŋ yaŋ anêŋ unyak kapô ba enja anêŋ nômkama vani e? Mi anôŋ! Ôpêŋ embaloŋ anyô lôklokwaŋ êŋ ba ekak loŋ am, êŋ ma yani hatôm enja anêŋ nômkama vani. ");
INSERT INTO hot_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yanaŋ avanôŋ êndêŋ môlô nena Wapômbêŋ tem nêm avômalô iniŋ kambom lomaloma lôk abôma takatu ba enaŋ vê. ");
INSERT INTO hot_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma doŋtom anyôla hayê Lovak Matheŋ anêŋ ku ba hanaŋ abôma nena, ‘Êntêk ma Ŋgôk Bêŋ anêŋ ku’, êŋ ma Wapômbêŋ miŋ hatôm nêm kambom êŋ vê ênjêk ôpêŋ ami. Ma mi. Anêŋ kambom êŋ tem ênjêk thêthô.” ");
INSERT INTO hot_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yisu hanaŋ abô takêŋ hathak ŋê takatu ba enaŋ nena ŋgôk lelaik hamô haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma Yisu anêŋ talêbô lôk iviyaŋ êyô imiŋ yaiŋ ma êv anyô te ba hi ek enaŋ êndêŋ Yisu nena êlêm yaiŋ. ");
INSERT INTO hot_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Avômalô bêŋ anôŋ lêk ekalabu yani siŋ ba enaŋ, “Lemtambô lôk môlôviyaŋ imiŋ yaiŋ ba leŋiŋhaviŋ nêgê o.” ");
INSERT INTO hot_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma Yisu hanaŋ hik liŋ, “Opalê intu yenaŋ wakatik lôk aiyaŋ thêlô?” ");
INSERT INTO hot_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Ma Yisu hayê avômalô nômbêŋ atu ba ekalabu yani siŋ ma hanaŋ, “Avômalô takatu ba esopa Wapômbêŋ anêŋ lahaviŋ, intu yenaŋ wakatik lôk aiyaŋ ma livôŋ thêlô. Ba intu môlô êntêk ma yenaŋ wakatik lôk aiyaŋ thêlô.” ");
INSERT INTO hot_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ma Yisu hadôŋ avômalô hathak loŋbô hamô kasukthôm anêŋ daŋ. Ma avômalô bêŋ anôŋ ekalabu yani siŋ ba intu hathak yeŋ te ba hi hamô kasuk habobo liŋdaŋ ma avômalô imiŋ liŋdaŋ habup hathak. ");
INSERT INTO hot_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma hadôŋ thêlô hathak abô loŋ kapô bêŋ anôŋ. Ba hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Odaŋô! Anyô te hi hapaliv anêŋ yaŋvêk halôk anêŋ ku. ");
INSERT INTO hot_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yani hapaliv yaŋvêk takêŋ ma vi halôk loŋôndê. Êŋ ma menak êpôm ba eyaŋ. ");
INSERT INTO hot_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma doho halôk valu kikiliŋ ba intu hapup ketheŋ ek malê nena pik dokte iyom. ");
INSERT INTO hot_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma doŋtom wak habi hayô hêk ma hakapok ek malê nena anêŋ ŋgalôk ma bidoŋna. ");
INSERT INTO hot_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma vi halôk loŋ yak lôkmaŋgiŋ kapô ba yak êŋ halumbak hayô yaŋvêk takêŋ vôv. Ba intu miŋ yaŋvêk êŋ hik anôŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma doŋtom vi halôk pik mavi ba hapup ba habitak bêŋ ba hik anêŋ anôŋ. Vi hatôm 30, ma vi 60, ma vi 100.” ");
INSERT INTO hot_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yôv ma Yisu hanaŋ hadêŋ thêlô, “Môlô ŋê lôk lemôndôŋ ma nodaŋô abô êntêk katô!” ");
INSERT INTO hot_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Avômalô nômbêŋ atu etak Yisu ba i, êŋ ma yani lôk anêŋ ŋê ku laumiŋ ba lahavuju ma avômalô takatu ba eveŋ haveŋ yani iyom intu thêlô êmô. Ma thêlô enaŋ hik yani liŋ hathak abô loŋ kapô takatu ba yani hanaŋ anêŋ ôdôŋ. ");
INSERT INTO hot_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma Yisu hanaŋ, “Wapômbêŋ lêk hêv anêŋ auk loŋ kapô hathak anêŋ loŋ lôkliŋyak hadêŋ môlô. Ma doŋtom avômalô vi atu ba êmô yaiŋ ek anêŋ loŋ lôkliŋyak, thêlô ethak elaŋô abô êŋ hathak abô loŋ kapô iyom. ");
INSERT INTO hot_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Aêŋ ba, “‘thêlô tem nêgê bêŋ anôŋ, ma doŋtom tem miŋ neyala ami. Ma tem nedaŋô abô bêŋ anôŋ, ma doŋtom tem miŋ neyala abô takêŋ anêŋ ôdôŋ ami. Yakô thêlô nede kapôlôŋiŋ liliŋ, ma Wapômbêŋ nêm iniŋ kambom vê.’” ");
INSERT INTO hot_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ma Yisu hanaŋ hadêŋ thêlô, “Môlô miŋ oyala abô loŋ kapô êntêk ami e? Aêŋ ba tem môlô noyala abô loŋ kapô yaŋ aisê? ");
INSERT INTO hot_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Anyô atu ba havatho yaŋvêk, êŋ ma hatôm yani havatho Wapômbêŋ anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma avômalô vi ma êtôm yaŋvêk atu ba epaliv halôk loŋôndê. Thêlô êŋ elaŋô Wapômbêŋ anêŋ abô. Ma doŋtom ketheŋ oyaŋ ma Sadaŋ hayô ba hêv abô takatu ba evatho halôk thêlô kapôlôŋiŋ vê. ");
INSERT INTO hot_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma avômalô vi ma hatôm yaŋvêk epaliv halôk valu kikiliŋ. Thêlô elaŋô Wapômbêŋ anêŋ abô ba êvhaviŋ ketheŋ lôk leŋiŋmavi. ");
INSERT INTO hot_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma doŋtom miŋ habi ŋgalôk ami ba intu imiŋ vauna iyom. Ek malê nena malaiŋ lôk vovaŋ hapôm thêlô hathak Wapômbêŋ anêŋ abô, êŋ ma etak iniŋ êvhaviŋ ketheŋ oyaŋ. ");
INSERT INTO hot_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma avômalô vi êtôm yaŋvêk epaliv halôk loŋ yak lôkmaŋgiŋ kapô. Avômalô takêŋ elaŋô Wapômbêŋ anêŋ abô, ");
INSERT INTO hot_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma doŋtom thêlô leŋiŋhiki bêŋ anôŋ hathak iniŋ lôkmala pik êntêk lôk valuseleŋ ma maleŋiŋkilik hathak nômkama lomaloma. Auk takêŋ intu hasivuŋ Wapômbêŋ anêŋ abô ba thêlô miŋ ik iniŋ anôŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma avômalô vi ma êtôm yaŋvêk epaliv halôk pik mavi. Thêlô elaŋô ba evaloŋ loŋ hêk thêlôniŋ kapôlôŋiŋ. Doho iniŋ anôŋ atu ba hik ma hatôm 30 ma doho 60 ma doho hatôm 100.” ");
INSERT INTO hot_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma Yisu hanaŋ hik thêlô liŋ nena, “Môlô othak ôtôm atum ba osoŋ halôk uŋ kapô mena uvuŋ hamô loŋ kapô e? Mi, môlô ôtôm ba ôthôkwêŋ liŋ hamiŋ. ");
INSERT INTO hot_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nômkama nômbêŋ atu ba hamô loŋ kapô, êŋ ma vêmam ka tem imbitak yaiŋ. Ma nômkama takatu ba anyô havuŋ hêk loŋ kapô, êŋ ma vêmam ka tem imbitak deda. ");
INSERT INTO hot_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","O anyô lôk lemôndôŋ ma ondaŋô abô êntêk.” ");
INSERT INTO hot_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Vêm ma Yisu hanaŋ, “Lemimimbi abô takatu ba yahanaŋ katô. Ma olaŋô mavi, êŋ ma tem noyala katô anôŋ lôk noja auk mavi bêŋ anôŋ imbiŋ. ");
INSERT INTO hot_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ôpatu ba halaŋô Wapômbêŋ anêŋ abô, ma tem Wapômbêŋ nêm auk bêŋ anôŋ êndêŋ yani. Ma doŋtom ôpatu ba miŋ halaŋô Wapômbêŋ anêŋ abô ami, anêŋ auk mavi atu ba bôk hamô haviŋ yani, Wapômbêŋ tem nêm vê.” ");
INSERT INTO hot_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ma Yisu hanaŋ, “Wapômbêŋ anêŋ loŋ lôkliŋyak ma aêntêk. Anyô te hapaliv yaŋvêk halôk anêŋ ku kapô. ");
INSERT INTO hot_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ma hêk hadêŋ bôlôvôŋ ma haveŋ hadêŋ lôkwak. Ma doŋtom yaŋvêk da hapup ba habitak bêŋ, ba anyô êŋ miŋ hayala ami. ");
INSERT INTO hot_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pik da hadum ku ba yaŋvêk êŋ hapup ba livuk habitak ma habi ŋauŋ ba hik va hayô hamô. ");
INSERT INTO hot_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma nôm takêŋ hapôpêk i, êŋ ma anyô êŋ hawa biŋ ba hale anôŋ hathak ek malê nena waklavôŋ neja anôŋ hayô.” ");
INSERT INTO hot_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ma Yisu hanaŋ, “Yanaŋ aisê esak Wapômbêŋ anêŋ loŋ lôkliŋyak ek nêm auk êndêŋ môlô? Lôk abô loŋ kapô alê yaŋ intu tem yanaŋ? ");
INSERT INTO hot_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wapômbêŋ anêŋ loŋ lôkliŋyak ma hatôm ava yaônate ba havatho halôk anêŋ ku. Ava êŋ ma yaôna lôk. ");
INSERT INTO hot_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma doŋtom hapup ba habitak alokwaŋ daim ba hamôŋ ek nômkama ku kapô vi. Alokwaŋ êŋ anêŋ thaŋaŋ ma bêŋ ba intu loŋ kapô mavi ek menak nedav iniŋ unyak êndôk ba nêmô.” ");
INSERT INTO hot_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ma Yisu hathak hanaŋ abô loŋ kapô bêŋ anôŋ aêŋ iyom hadêŋ avômalô. Ma hadôŋ thêlô hatôm thêlôda iniŋ auk eyala nômkama. ");
INSERT INTO hot_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Avômalô bêŋ anôŋ êmô haviŋ yani, êŋ ma hathak hadôŋ i hathak abô loŋ kapô iyom. Ma yanida lôk anêŋ ŋê ku iyom êmô, êŋ ma hanaŋ anêŋ ôdôŋ bêŋ hadêŋ i. ");
INSERT INTO hot_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wak êŋ anêŋ yaŋsiŋ habôk ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Alôana kasukthôm vi tuvulu.” ");
INSERT INTO hot_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Êŋ ma thêlô etak avômalô nômbêŋ atu ma ethak yeŋ atu ba Yisu hamô ba i. Ma yeŋ doho i haviŋ. ");
INSERT INTO hot_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Êŋ ma ôthôm bêŋ lôk lovak hayô ba hayuv ŋaŋ ba ŋaŋ haŋgasô halôk yeŋ kapô ba hadum ek êmô yeŋ sesoŋ. ");
INSERT INTO hot_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yisu hayô hêk kwalim te hêk yeŋ layuk ba hêk sôm. Êŋ ma anêŋ ŋê ku êyô ik liŋ ba enaŋ, “Kêdôŋwaga, ŋaŋ tem endok alalô. Ma hosoŋ nena êŋ ma nôm oyaŋ e?” ");
INSERT INTO hot_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Êŋ ma Yisu haviyô ma hathaŋ ŋaŋ budum lôk lovak ba hanaŋ nena, “Nôŋgwêk yaô ma ômô tiŋiŋ!” Yôv ma lovak hama ma ŋaŋ hêk labalina. ");
INSERT INTO hot_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Môlô ôkô eka? Miŋ ôêvhaviŋ ami denaŋ e?” ");
INSERT INTO hot_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma ŋê êŋ elowaliŋ kambom ba enaŋ hik thêlôda liŋ, “Yani ma opalê ba intu ŋaŋ lo lovak elaŋô anêŋ abô ba esopa.” ");
INSERT INTO hot_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yisu lôk anêŋ ŋê ku i kasukthôm vi tuvulu ma êyô avômalô Gelasa iniŋ pik. ");
INSERT INTO hot_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma yeŋ hathak liŋ ma Yisu habup pik. Êŋ ma anyô lôk ŋgôk lelaik te halêm anêŋ siô ba hi hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yani hathak hamô siô ma miŋ hatôm anyô late embaloŋ yani loŋ ami. Ma miŋ hatôm nekak yani loŋ esak seŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bôk evaloŋ yani lôbôlôŋ ba ekak va lobaŋ lusu hathak seŋ ma doŋtom hathô seŋ êŋ kisi. Anyô late miŋ hatôm embaloŋ ôpêŋ ba êmô tiŋiŋ ami, milôk. ");
INSERT INTO hot_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma wak lo bôlôvôŋ sapêŋ ma hamô ba haveŋ siô lo dum ma haŋgaliak ba haŋgothe liŋkupik hathak valu. ");
INSERT INTO hot_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yani hayê Yisu halêm daim denaŋ, ma halaŋviŋ ba hi hadêŋ Yisu ma halek vadôŋ lêlô hamô Yisu ma. ");
INSERT INTO hot_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ma Yisu hanaŋ hadêŋ ôpêŋ, “Ŋgôk lelaik, otak ôpêntêk ba nu.” Ma anyô lôk ŋgôk êŋ halam lôklala bomaŋ, “Yisu, Wapômbêŋ Leŋ Anôŋ Biŋ anêŋ Nakaduŋ, hôlêm ek undum malê êndêŋ ya? Esak Wapômbêŋ anêŋ athêŋ miŋ nêm vovaŋ êndêŋ ya ami!” ");
INSERT INTO hot_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Êŋ ma Yisu hanaŋ hik ôpêŋ liŋ, “Anêm athêŋ nena?” Ma ôpêŋ hanaŋ, “Yenaŋ athêŋ nena Ŋê Vovak Lubuŋlubuŋ, ek malê nena yêlô ma bêŋ anôŋ.” ");
INSERT INTO hot_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma yani hateŋ Yisu lôbôlôŋ nena miŋ nêm thêlô vê ênjêk loŋ êŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bok bêŋ anôŋ eyaŋ nôm êmô dum te habobo loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma ŋgôk takêŋ enaŋ hik Yisu liŋ nena, “Nêm yêlô vê ni êndôk bok takêŋdaku kapô.” ");
INSERT INTO hot_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Êŋ ma Yisu halôk ba hêv thêlô vê i êlôk bok takêŋ kapô. Ma bok takêŋ elaŋviŋ ketheŋ ba i hadêŋ loŋ kambom ma êv yak halôk kasukthôm ba ŋaŋ halok sapêŋ vônô. Bok takêŋ ma hatôm 2,000. ");
INSERT INTO hot_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma ŋê takatu ba eyabiŋ bok êsôv ba i enaŋ bêŋ haveŋ malak bêŋ lôk loŋ yaô nenanena haviŋ. Êŋ ma avômalô i ek nêgê nôm atu ba lêk habitak. ");
INSERT INTO hot_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Thêlô êyô ma êyê ôpatu ba bôk ŋgôk lubuŋlubuŋ êmô iviŋ yani lêk hapuk sôp ma anêŋ auk mavi ba hamô tiŋiŋ. Êŋ ma thêlô êkô kambom. ");
INSERT INTO hot_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma ŋê takatu ba êyê nôm êŋ enaŋ abô hadêŋ avômalô hathak malê atu hapôm anyô lôk ŋgôk êŋ ma enaŋ hathak bok takatu ba elok ŋaŋ ba ema haviŋ. ");
INSERT INTO hot_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Êŋ ma avômalô eteŋ Yisu lôklokwaŋ ek etak thêlôniŋ loŋ ba ni buyaŋ. ");
INSERT INTO hot_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yôv ma Yisu hathak yeŋ, ma anyô atu ba ŋgôk bôk hamô haviŋ yani hapetenak nena, “Hatôm yasôk imbiŋ o e?” ");
INSERT INTO hot_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma doŋtom Yisu miŋ halôk hathak ôpêŋ anêŋ abô ami ba hanaŋ nena, “Nu anêm unyak lôk anêm avômalô. Ma onaŋ êndêŋ thêlô esak nômbêŋ atu ba Anyô Bêŋ hadum hathak o lôk hêv anêŋ lahaviŋ hadêŋ o.” ");
INSERT INTO hot_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Êŋ ma ôpêŋ havôhi anêŋ loŋ ma hanaŋ hathak nômbêŋ atu ba Yisu hadum hadêŋ yani haveŋ malak laumiŋ atu ba hamô Dekapolis kapô. Ma avômalô loŋ êŋ sapêŋ elaŋô ba esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisu hathak yeŋ ba hi liŋdaŋ vi tuvulu hathak loŋbô. Yani hamiŋ liŋdaŋ, ma avômalô bêŋ anôŋ isup i ethak doŋtom ba ekalabu yani siŋ. ");
INSERT INTO hot_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma anyô bêŋ hayabiŋ unyak yeŋ te halêm, anêŋ athêŋ nena Jailus. Yani hi hayê Yisu ma hêv yak halôk Yisu va luvi. ");
INSERT INTO hot_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ma hapetenak nena, “Yenaŋ avena tem ema. Ma hatôm ôlêm ba otak bahem êyôŋgêk yani ek imbitak mavi ba êmô lôkmala e?” ");
INSERT INTO hot_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Êŋ ma Yisu hi haviŋ yani. Ma avômalô bêŋ anôŋ esopa yani ba ekalabu yani siŋ. ");
INSERT INTO hot_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Avi te hamô loŋ êŋ ba hapôm lijiŋ thalaleŋ halom hatôm sondabêŋ laumiŋ ba lahavuju. ");
INSERT INTO hot_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dokta bêŋ anôŋ idum ek nênêm yani sa ma doŋtom miŋ êtôm ami ma êv vovaŋ iyom. Avi êŋ hêv anêŋ valu lôkthô hadêŋ thêlô, ma doŋtom lijiŋ êŋ miŋ hakapok dokte ami ma halom hêk denaŋ. ");
INSERT INTO hot_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma bôk halaŋô abô hathak Yisu, ba intu halôk avômalô nômbêŋ êŋ kapô ma haveŋ Yisu yam ba hasôm anêŋ sôp daŋ. ");
INSERT INTO hot_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yani lahabi nena, “Yambaloŋ anêŋ kwêv iyom ma tem ya mavi.” ");
INSERT INTO hot_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hasôm iyom ma ketheŋ oyaŋ ma anêŋ thalaleŋ hakapok ma hayala nena malaiŋ êŋ hatak yani. ");
INSERT INTO hot_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma Yisu hasaê nena anêŋ lôklokwaŋ doho hêv yak. Êŋ ma hik i liliŋ hamiŋ avômalô takêŋ malêvôŋ ma hanaŋ, “Opalê hasôm ya?” ");
INSERT INTO hot_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma anêŋ ŋê ku enaŋ, “Hôyê avômalô nômbêŋ êntêk ekalabu o siŋ ma honaŋ hik liŋ hathak opalê hasôm o eka?” ");
INSERT INTO hot_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma doŋtom Yisu hatitiŋ hawê haveŋ nena opalê intu hasôm yani. ");
INSERT INTO hot_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma avi êŋ hayala nôm atu ba lêk hapôm yani, ba intu hakô ba halowaliŋ ma hi halek vadôŋ lêlô hêk Yisu va. Ma hanaŋ nôm takêŋ bêŋ hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma Yisu hanaŋ hadêŋ yani nena, “Yenaŋ avena, anêm hôêvhaviŋ hadum ba lêk hubitak mavi. Nu lôk kapôlôm labali. Anêm lijiŋ lêk hatak o.” ");
INSERT INTO hot_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisu hanaŋ abô denaŋ ma anyô doho êlêm anêŋ Jailus anêŋ unyak ba enaŋ, “Nalum avi lêk hama yôv ba intu otak kêdôŋwaga ma miŋ nêm malaiŋ êndêŋ yani ami.” ");
INSERT INTO hot_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma doŋtom Yisu miŋ halaŋô iniŋ abô ami ma hanaŋ hadêŋ Jailus nena, “Miŋ ôkô ami, ônêmimbiŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yisu hadô avômalô ini nimbiŋ yani ba hawa Pita lo Jems ma yaŋ Jon iyom ba i haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Thêlô êyô Jailus anêŋ unyak ma hayê avômalô lêk elaŋ asêŋ malêŋ lôk thôthô bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Êŋ ma hi unyak kapô ma hanaŋ hadêŋ thêlô nena, “Olaŋ ba thôthô bêŋ êntêk eka? Amena ma hêk sôm iyom ma miŋ hama ami.” ");
INSERT INTO hot_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma thêlô emalik hathak yani. Ma Yisu hêv thêlô vê ba ele yaiŋ ba i, ma hawa amena êŋ anêŋ talêbô lo lambô ma anêŋ ŋê ku lô atu iyom iviŋ yani ba i unyak kapô atu ba amena hêk. ");
INSERT INTO hot_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Êŋ ma havaloŋ avena baŋ ma hanaŋ hathak abô Hiblu aêntêk, “Talita kum!” (Abô êŋ anêŋ ôdôŋ nena, “Yenaŋ avena, yanaŋ êndêŋ o nena umbiyô.”) ");
INSERT INTO hot_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma ketheŋ oyaŋ ma avena êŋ haviyô ba haveŋ. Yani anêŋ sondabêŋ hatôm laumiŋ ba lahavuju. Thêlô êyê ba eboloba kambom. ");
INSERT INTO hot_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma Yisu hanaŋ lôklokwaŋ hadêŋ thêlô nena miŋ nenaŋ nôm êŋ bêŋ êndêŋ anyôla ami. Ma nênêm nôm ek enjaŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisu hatak loŋ êŋ ma hi anêŋ malak ôdôŋ ma anêŋ ŋê ku i iviŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat anêŋ Waklavôŋ hayô ba Yisu hi unyak yeŋ ma hadôŋ avômalô. Ma avômalô bêŋ anôŋ elaŋô anêŋ abô ba esoŋ ma enaŋ nena, “Ôpêntêk hawa abô lôk auk takêntêk anêŋ êsê ba intu hadum nômbithi hathak? ");
INSERT INTO hot_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ôpêŋ ma anyô halav unyak e? Yani ma Malia nakaduŋ ma Jems lo Josep ma Judas lo Saimon thêlô iniŋ te bêŋ e? Ma anêŋ livi êmô loŋ êntêk haviŋ alalô e?” Thêlô enaŋ aêŋ, ma êpôlik hathak yani. ");
INSERT INTO hot_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma Yisu hanaŋ hadêŋ thêlô nena, “Plopet hawa athêŋ bêŋ hêk malak yaŋ. Ma doŋtom anêŋ malak ôdôŋ lôk anêŋ thalaleŋ ma anêŋ avômalô, ma hatôm anyô athêŋ mi.” ");
INSERT INTO hot_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aêŋ ba Yisu miŋ hatôm idum nômbithi ênjêk loŋ êŋ ami, ma hatak baŋ hayô hêk anyô lôk lijiŋ tomtom iyom ba ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma Yisu hasoŋ kambom hathak thêlô miŋ êvhaviŋ yani ami. Ma Yisu hi lomalak nenanena ma hadôŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ma halam anêŋ ŋê ku laumiŋ ba lahavuju ethak doŋtom ma habi i sam ba hêv juju ba i lôk hêv lôklokwaŋ hadêŋ thêlô ek nênêm ŋgôk lelaik vê. ");
INSERT INTO hot_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma Yisu hanaŋ hadêŋ i nena, “Nobaloŋ unim kôm kwandiŋ iyom. Ma miŋ noja nômla doho imbiŋ ami. Polom lôk vak ma valu imiŋ unim vak damaŋ ami, dô. ");
INSERT INTO hot_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ma uŋgwik vemim kapô bokŋgôp iyom, ma miŋ noja kwêv ju ami. ");
INSERT INTO hot_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma ôyô unyak te, ma nômô unyak êŋ iyom endeba notak loŋ êŋ ba unu buyaŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma loŋ takatu ba miŋ ewa môlô thô ami lôk êdô nedaŋô môlônim abô, ma waklavôŋ otak loŋ êŋ, ma uŋgwik voŋgovaŋ takatu ba hamô vemim kapô vê êndôk thêlô maleŋiŋ ek injik iniŋ kambom thô.” ");
INSERT INTO hot_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Êŋ ma Yisu anêŋ ŋê ku i lomalak ma enaŋ ek avômalô nede kapôlôŋiŋ liliŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Thêlô êv ŋgôk bêŋ anôŋ vê lôk etak nôm lêŋlêŋ hayô hamô avômalô lôk lijiŋ bêŋ anôŋ leŋiŋkadôk ba idum i ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kiŋ Helot Antipas halaŋô abô hathak Yisu ek malê nena avômalô sapêŋ bôk eyala yani katô. Doho enaŋ, “Jon anyô hathik ŋaŋ haviyô hathak loŋbô ba intu hawa lôklokwaŋ ba hadum nômbithi takêŋ.” ");
INSERT INTO hot_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma vi enaŋ, “Yani ma Elia.” Ma vi enaŋ, “Yani ma plopet te hatôm plopet tak sêbôk doho.” ");
INSERT INTO hot_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma doŋtom Helot halaŋô abô takêŋ ma hanaŋ nena, “Jon, ôpatu ba bôk yahadabêŋ laselo kisi, lêk haviyô hathak loŋbô!” ");
INSERT INTO hot_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sêbôk ma Helot hawa yaŋ Pilip anêŋ avi Helodias vani. Ba Jon hanaŋ hadêŋ Helot nena, “Lêk howa mamuyaŋ yanavi vani ba intu hubuliŋ abô balabuŋ.” Êŋ ma Helot hêv abô ek nebaloŋ Jon. Ma evaloŋ yani ba ekak loŋ ma êdô hamô koladôŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ma Helodias havaloŋ anêŋ lamaniŋ hathak Jon loŋ ba lahaviŋ nijik yani vônô, ma doŋtom miŋ hatôm ami, ");
INSERT INTO hot_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ek malê nena Helot hakô ek Jon. Yani hayala nena Jon ma anyô matheŋ lôk anyô thêthôŋ. Aêŋ ba hayabiŋ Jon mavi. Ma hathak halaŋô Jon anêŋ abô ba lahiki kambom, ma doŋtom lahaviŋ bêŋ anôŋ ek endaŋô anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Haveŋ yam ma Helodias hapôm loŋôndê te. Helot haŋgabôm nôm bêŋ ek lahabi anêŋ waklavôŋ talêbô hawa yani. Ba halam anêŋ ŋê bêŋbêŋ takatu ba ethak êv yani sa lôk ŋê vovak laik môŋ ma ŋê bêŋbêŋ anêŋ Galili. ");
INSERT INTO hot_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Thêlô eyaŋ nôm êmô ma Helodias nalavi hayô haloyeŋ ba hadum Helot lôk anêŋ ŋê bêŋbêŋ sapêŋ maleŋiŋ mavi. Êŋ ma kiŋ hanaŋ hadêŋ avena êŋ, “Lemhaviŋ malê ba honaŋ ma tem yanêm êndêŋ o.” ");
INSERT INTO hot_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma havak abô haviŋ yani nena, “Yanaŋ avanôŋ biŋ dake nena honaŋ hik ya liŋ hathak nômlate ek yanêm êndêŋ o, êŋ ma tem yanêm iyom. Ma honaŋ hadêŋ ya ek yambak yenaŋ pik lôk nômkama sapêŋ vose êndôk malêvôŋ ba yanêm vi êndêŋ o, êŋ ma hatôm.” ");
INSERT INTO hot_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Êŋ ma avena êŋ hi hanaŋ hik talêbô liŋ, “Yanaŋ aisê?” Ma talêbô hanaŋ, “Onaŋ nena, ‘Yaleŋhaviŋ Jon anyô hathik ŋaŋ wakadôk.’” ");
INSERT INTO hot_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma avena êŋ havôhi lêvôkê ma hanaŋ hadêŋ kiŋ nena, “Yaleŋhaviŋ êntêk iyom ma otak Jon anyô hathik ŋaŋ wakadôk êndôk belev te ba nêm êndêŋ ya.” ");
INSERT INTO hot_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma kiŋ halaŋô ma lamalaiŋ bêŋ, ma doŋtom bôk havak abô halôk ŋê bêŋbêŋ maleŋiŋ yôv. Ba intu hadô enaŋ nena mi. ");
INSERT INTO hot_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aêŋ ba hêv ôpatu ba hathak hik anyô vônô ba hi ek enja Jon wakadôk ba êlêm. Anyô êŋ hi koladôŋ ma hadabêŋ Jon laselo kisi. ");
INSERT INTO hot_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ma hatak halôk belev te, ma hawa ba hi hêv hadêŋ avi muk atu. Ma avi êŋ hawa ba hi hêv hadêŋ talêbô. ");
INSERT INTO hot_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma Jon anêŋ ŋê ku elaŋô abô êŋ, ma êlêm ewa anêŋ liŋkupik ba i elav halôk siô valu abyaŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposel itup êyô ek Yisu hathak loŋbô ma enaŋ hathak nôm takatu ba thêlô idum lo êdôŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma avômalô bêŋ anôŋ i ba êlêm ba Yisu lôk anêŋ ŋê ku miŋ hatôm nejaŋ nôm ami. Ba intu hanaŋ hadêŋ anêŋ ŋê ku nena, “Nôlêm ek alôana loŋ thiliv bute ek naja lovak.” ");
INSERT INTO hot_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aêŋ ba thêlôda iyom ethak yeŋ te ba i loŋ thiliv bute. ");
INSERT INTO hot_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma doŋtom avômalô bêŋ anôŋ êyê thêlô ma eyala loŋ atu ba thêlô tem ini. Ba intu avômalô anêŋ lomalak lomalak elaŋviŋ ba êyô loŋ êŋ êmôŋ vêm ka Yisu lôk anêŋ ŋê ku êyô eveŋ yam. ");
INSERT INTO hot_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma Yisu hathak liŋ ma hayê avômalô bêŋ anôŋ lêk êmô hatôm boksipsip takatu ba alaŋsi mi, ba intu lahiki hathak thêlô. Ma hadôŋ thêlô hathak nômkama bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yaŋsiŋ hayô ma anêŋ ŋê ku i hadêŋ yani ma enaŋ, “Lêk yaŋsiŋ ma alalô amô loŋ thiliv. ");
INSERT INTO hot_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ba intu otak avômalô takêntêk ek ini malak lôk loŋ takatu ba hamô habobo ek nênêm iniŋ nôm vuli ek nejaŋ.” ");
INSERT INTO hot_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma doŋtom Yisu hanaŋ nena, “Mi, môlôda nobakôŋ i.” Êŋ ma thêlô enaŋ viyaŋ, “Ai, avômalô nômbêŋ anôŋ ba intu napôm valu êtôm ku ayôŋ baheŋvi ba lahavulô anêŋ vuli ek nanêm nôm vuli esak e?” ");
INSERT INTO hot_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma Yisu hanaŋ hik thêlô liŋ, “Môlônim polom vithê? Ôŋgô am.” Ma i êyê ma enaŋ nena, “Polom baheŋvi ma alim ju.” ");
INSERT INTO hot_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Êŋ ma Yisu hanaŋ ek anêŋ ŋê ku nenaŋ êndêŋ avômalô ek nimbi i sam ni lodôŋlodôŋ nenanena ba nêndôk nêmô kamuŋ mavi atu. ");
INSERT INTO hot_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma thêlô ibi i sam hi lodôŋlodôŋ ba vi ma hatôm 100 êmô dôm te ma ôdôŋ yaŋ ma hatôm 50 êmô lodôŋlodôŋ aêŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma Yisu hawa polom baheŋvi lôk alim ju atu. Ma hêv ma hathak leŋ ma hêv mek. Vêm ma haya polom êŋ ma hêv hadêŋ anêŋ ŋê ku ek nimbi sam êndêŋ avômalô takatu ba êmô. Ma hadum aêŋ hathak alim ju atu haviŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma avômalô sapêŋ eyaŋ ba leŋiŋviyak. ");
INSERT INTO hot_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma polom lôk alim wata vi atu ba hamô ma ŋê ku isup halôk vak sam laumiŋ ba lahavuju. ");
INSERT INTO hot_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ma anyô takatu ba eyaŋ nôm êŋ ma hatôm 5,000. ");
INSERT INTO hot_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Vêm ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena nesak yeŋ ba nêmôŋ ba ini Betsaida. Ma yanida hamô ek nêm avômalô ba ini am. ");
INSERT INTO hot_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yani hêv avômalô ba i, êŋ ma yani hathak dum te ba hi ek eteŋ mek. ");
INSERT INTO hot_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hale vônô ma yeŋ atu lôk anêŋ ŋê ku êmô kasukthôm malêvôŋ biŋ ma Yisu da intu hamô liŋdaŋ denaŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma hayê lovak hayuv anêŋ ŋê ku lôk yeŋ ba hamô yeŋ loŋ hale hi. Ma thêlô lôklokwaŋ ek ivusiŋ yeŋ. Habobo tem eyaŋ ma Yisu haveŋ kasuk anêŋ dômlê ba hi hadêŋ thêlô. Yani hadum ek nêm thêlô liliŋ, ");
INSERT INTO hot_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","ma doŋtom anêŋ ŋê ku êyê yani haveŋ kasuk anêŋ dômlê ba esoŋ nena anyôla dahô. Thêlô sapêŋ êyê yani ba êkô kambom ba elaŋ boloba. Ma ketheŋ oyaŋ ma Yisu hanaŋ hadêŋ thêlô nena, “Môlô miŋ nôkô ami ma nômô yaô! Ya êntêk!” ");
INSERT INTO hot_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ma yani hathak yeŋ haviŋ thêlô ma lovak bêŋ êŋ hama. Ma thêlô esoŋ kambom ba leŋiŋhabi mayaliv. ");
INSERT INTO hot_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ek malê nena iniŋ auk ma thekthek denaŋ ba miŋ eyala polom atu ba Yisu haŋgôli anêŋ ôdôŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Thêlô ethak liŋdaŋ vi tuvulu anêŋ Genesalet ma êthô yeŋ hamô. ");
INSERT INTO hot_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Etak yeŋ ba êlôk biŋ ma avômalô êyê Yisu ba eyala yani ketheŋ. ");
INSERT INTO hot_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ba intu elaŋviŋ eveŋ loŋ sapêŋ ba ewa ŋê lôk lijiŋ halôk yêm ba i loŋ atu ba elaŋô nena Yisu tem êmô. ");
INSERT INTO hot_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Loŋ nômbêŋ atu ba yani hi, malak yaônena lôk malak bêŋbêŋ, ma avômalô ewa ŋê lôk lijiŋ ba i êdô i hêk loŋ ethak doŋtom halôk. Ma eteŋ yani ek nêsôm anêŋ kwêv daim anêŋ daŋ iyom. Ma sapêŋ atu ba êsôm ma ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ma Palisi lo ŋê lôkauk hathak abô balabuŋ doho êlêm anêŋ Jelusalem ba ekalabu Yisu siŋ. ");
INSERT INTO hot_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma thêlô êyê Yisu anêŋ ŋê ku doho eyaŋ nôm lôk baheŋ “lelaik” ma miŋ ithik baheŋiŋ hatôm Palisi iniŋ abô majaŋ hanaŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Palisi lôk avômalô Islael ethak esopa limi iniŋ kobom ba intu ethak ithik baheŋiŋ hatôm kobom atu ba limi ethak idum. Ithik aêŋ ma hatôm nejaŋ nôm, ma miŋ ithik aêŋ ami ma miŋ hatôm nejaŋ nôm ami. ");
INSERT INTO hot_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Lôk i loŋ etak nôm hamô ek nênêm vuli ba êvô êlêm ma miŋ ithik nôm takatu ba ewa hatôm iniŋ bôk lo loŋ atu ba ethak idum ami, êŋ ma miŋ hatôm nejaŋ nôm takêŋ ami. Thêlô ethak esopa limi iniŋ bôk lo loŋ ba ithik tase lôk uŋ ma belev lôk nômkama lomaloma hatôm iniŋ abô majaŋ hanaŋ.) ");
INSERT INTO hot_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Êŋ ma Palisi lôk ŋê lôkauk hathak abô balabuŋ enaŋ hadêŋ Yisu, “Aisê ka anêm ŋê ku eyaŋ nôm lôk baheŋiŋ lelaik ma miŋ esopa bumalô iniŋ abô majaŋ ami?” ");
INSERT INTO hot_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma Yisu hanaŋ hadêŋ thêlô, “Plopet Aisaia bôk hato abô avanôŋ hathak môlô ŋê takatu ba onaŋ abô mavi ma doŋtom udum kambom lomaloma ba hanaŋ nena, “‘Avômalô êntêk êbô yenaŋ athêŋ hathak veŋiŋbôlêk oyaŋ. Ma doŋtom kapôlôŋiŋ ma hêk daim bô ek ya. ");
INSERT INTO hot_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Thêlô êv yeŋ oyaŋ hadêŋ ya. Ma ethak enaŋ thêlôda iniŋ abô iyom ba esau nena, “Êntêk ma Wapômbêŋ anêŋ abô.” ’ ");
INSERT INTO hot_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Môlô ovaloŋ ŋê pik iniŋ kobom loŋ ma otak Wapômbêŋ anêŋ abô balabuŋ.” ");
INSERT INTO hot_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma Yisu hanaŋ hadêŋ thêlô nena, “Môlô ôdô Wapômbêŋ anêŋ abô balabuŋ ba osopa môlôda unim abô majaŋ. ");
INSERT INTO hot_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Hatôm Mose bôk hanaŋ aêntêk, ‘Nodovak lemami lo lemtami’ ma ‘Ôpatu ba hathaŋ lambô lo talêbô hathak abô kambom, ma nijik ôpêŋ vônô.’ ");
INSERT INTO hot_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma doŋtom môlô othak onaŋ nena anyôla hanaŋ hadêŋ lami nena, ‘Yenaŋ nômkama atu ba hamô ek yanêm mamu sa, êŋ ma bôk yahanaŋ nena tem yanêm êndêŋ Wapômbêŋ êtôm da. Ba intu miŋ hatôm yanêm mamu sa ami.’ ");
INSERT INTO hot_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Êŋ ma numiŋ yani loŋ siŋ ek nêm talêbô lo lambô sa. ");
INSERT INTO hot_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Môlô othak osopa libumi iniŋ bôk lo loŋ ba ôvôliŋ dômiŋ ek Wapômbêŋ anêŋ abô. Lôk udum kobom lomaloma aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ma Yisu halam avômalô nômbêŋ atu êlêm hadêŋ yani hathak loŋbô ma hanaŋ, “Môlô sapêŋ, nodaŋô ya lôk noyala abô takêntêk. ");
INSERT INTO hot_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nôm eyaŋ miŋ hatôm indum anyô imbitak lelaik ami. Mi. Nôm takatu ba hamô anyô kapô ba hale yaiŋ, intu hadum anyô habitak lelaik.” ");
INSERT INTO hot_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yisu hatak avômalô nômbêŋ atu ma hi unyak kapô. Êŋ ma anêŋ ŋê ku enaŋ hik yani liŋ hathak abô loŋ kapô atu ba hanaŋ. ");
INSERT INTO hot_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma Yisu hanaŋ, “Ma môlô ôthôŋ haviŋ e? Odaŋô katô! Nôm takatu ba eyaŋ, miŋ hatôm idum anyô imbitak lelaik ênjêk Wapômbêŋ ma ami. ");
INSERT INTO hot_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nôm takêŋ miŋ halôk anyô kapô ba habuliŋ iniŋ auk ami. Mi, hi hamiŋ anyô lasoam vêm ma hale yaiŋ ba hi.” (Yisu hanaŋ aêŋ ek hik thô nena nôm eyaŋ sapêŋ ma lêk mavi iyom.) ");
INSERT INTO hot_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma Yisu hanaŋ nena, “Nôm takatu ba hamô anyô kapô ba hale yaiŋ, intu hadum anyô ibitak lelaik hêk Wapômbêŋ ma. ");
INSERT INTO hot_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nôm takatu ba hamô anyô kapô ba hale yaiŋ ma aêntêk: auk kambom lôk sek waliliŋ ma vani lôk ik anyô vônô ma idum sek haviŋ anyô yaŋ yanavi lôk ");
INSERT INTO hot_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","maleŋiŋkilik ma leŋiŋhabi auk kambom hathak anyô vi lôk abôyaŋ ma idum nôm kambom hathak anyô yaŋ ma miŋ mama ami lôk leŋdaŋ hathak anyô yaŋ anêŋ nômkama ma enaŋ abôyaŋ hathak anyô yaŋ lôk êbôi hathak iniŋ athêŋ ma idum nômkama hatôm ŋê molo. ");
INSERT INTO hot_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nôm kambom takêŋ intu hamô anyô kapô ba hale yaiŋ ba hadum ôpêŋ habitak lelaik.” ");
INSERT INTO hot_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ma Yisu hatak loŋ êŋ ma hi haveŋ loŋ takatu ba habobo Taia. Ma hi unyak te kapô ma hadô ek avômalô neyala nena yani hamô loŋ êŋ. Ma doŋtom miŋ hatôm imbuŋ i ek avômalô ami. ");
INSERT INTO hot_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ma avi te atu ba ŋgôk lelaik hamô haviŋ nalavi halaŋô nena Yisu lêk hayô loŋ êŋ. Êŋ ma hi ketheŋ ma halek vadôŋ lêlô hêk Yisu ma. ");
INSERT INTO hot_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yani ma avi Glik te ba talêbô havathu hêk Ponisia hamô Silia kapô. Ba hanaŋ hik Yisu liŋ lôk kapô malaiŋ nena nêm ŋgôk atu ba hamô haviŋ nalavi vê. ");
INSERT INTO hot_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Yisu hanaŋ nena, “Alalô nanêm nôm êndêŋ avômena vêmam. Ma kambom ek nakaliv avômena iniŋ nôm êndêŋ avuŋ.” ");
INSERT INTO hot_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma avi êŋ hanaŋ, “Anyô Bêŋ, êŋ ma avanôŋ. Ma doŋtom avuŋ ethak isup avômena iniŋ nôm mapmap atu ba hêv yak halôk balê vibiŋ ba eyaŋ.” ");
INSERT INTO hot_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma Yisu hanaŋ, “Abô atu ba honaŋ ma mavi ba intu ômbônu. Ŋgôk êŋ lêk hatak nalum avi yôv.” ");
INSERT INTO hot_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma avi êŋ hayô anêŋ unyak ma hayê nena ŋgôk lêk hatak nalavi ba nalavi lêk hêk bônôŋ hêk anêŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ma Yisu hatak Taia iniŋ loŋ hêk ma hasopa Saidon habup halôk ba hi hayô Dekapolis iniŋ loŋ vêm ma havôhi kasukthôm Galili. ");
INSERT INTO hot_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Êŋ ma ewa anyô lêndôŋ lôk abôlêk putup te ba êyô ek Yisu ma enaŋ hik yani liŋ lôk kapôlôŋiŋ ek etak baŋ êyôŋgêk ôpêŋ. ");
INSERT INTO hot_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma Yisu hawa ôpêŋ ba hi daim dokte ek avômalô ma hasoŋ baŋgwasiŋ halôk ôpêŋ lêndôŋ kapô. Vêm ma hasôwapôk hathak baŋ ma hasôm ôpêŋ dahalaŋ. ");
INSERT INTO hot_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ma hayê leŋ ma hik siv auk ma hanaŋ hadêŋ ôpêŋ hathak abô Hiblu nena, “Epata!” (Anêŋ ôdôŋ nena lemôndôŋ ekyav.) ");
INSERT INTO hot_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Êŋ ma ôpêŋ lêndôŋ lo abôlêk hakyav ma hanaŋ abô halêm yaiŋ. ");
INSERT INTO hot_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma Yisu hanaŋ nena miŋ nenaŋ bêŋ êndêŋ anyôla ami. Hanaŋ aêŋ lôbôlôŋ ma doŋtom avômalô miŋ bônôŋ ami ma enaŋ bêŋ hi ba hi. ");
INSERT INTO hot_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma avômalô esoŋ kambom ba enaŋ, “Yani hadum nômkama lôkthô ma mavi anôŋ. Hadum ŋê leŋôndôŋ kôtôŋ elaŋô abô ma ŋê veŋiŋbôlêk putup enaŋ abô halêm yaiŋ.” ");
INSERT INTO hot_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ma wak te ma avômalô bêŋ anôŋ êlêm ethak doŋtom hathak loŋbô. Ma thêlô nôm mi ek nejaŋ. Êŋ ma Yisu halam anêŋ ŋê ku êlêm ma hanaŋ hadêŋ i nena, ");
INSERT INTO hot_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yaleŋ hik ya hathak avômalô nômbêŋ êntêk. Thêlô bôk êmô haviŋ ya hatôm wak lô ba iniŋ nôm lêk mi. ");
INSERT INTO hot_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Doho êlêm anêŋ loŋ daim bô ba intu yahêv i ba i oyaŋ, ma tem maleŋiŋ etaba êndôk loŋôndê ba nênêm yak.” ");
INSERT INTO hot_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma anêŋ ŋê ku enaŋ nena, “Loŋ êntêk ma loŋ thiliv ma avômalô bêŋ anôŋ. Aêŋ ba alalô naja polom anêŋ êsê ek nanêm êndêŋ i?” ");
INSERT INTO hot_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma Yisu hanaŋ hik thêlô liŋ, “Môlônim polom vithê intu hamô?” Ma enaŋ nena, “Baheŋvi ba lahavuju.” ");
INSERT INTO hot_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma Yisu hanaŋ hadêŋ avômalô nômbêŋ atu nena nêndôk nêmô biŋ. Ma hawa polom baheŋvi ba lahavuju atu ma hêv lamavi hadêŋ Wapômbêŋ. Ma haya ba hêv hadêŋ anêŋ ŋê ku ek nebani êndêŋ avômalô nômbêŋ atu ba êmô. ");
INSERT INTO hot_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma iniŋ alim yaônena tomtom hamô haviŋ. Hêv lamavi hathak vêm ma hêv hadêŋ anêŋ ŋê ku ek nebani êndêŋ avômalô imbiŋ. ");
INSERT INTO hot_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma avômalô nômbêŋ êŋ eyaŋ ba leŋiŋviyak. Ma ŋê ku isup nôm wata halôk vak sam baheŋvi ba lahavuju. ");
INSERT INTO hot_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Avômalô takêŋ ma hatôm 4,000. Yôv ma Yisu hêv thêlô sapêŋ ba i. ");
INSERT INTO hot_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma yani hathak yeŋ haviŋ anêŋ ŋê ku ba i Dalmanuta iniŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma Palisi êyô ma enaŋ hik Yisu liŋ lôklokwaŋ nena, “Undum lavôŋiŋ te ek injik thô nena Wapômbêŋ hêv o ba hôlêm mena mi e?” Thêlô enaŋ aêŋ ek nesau yani iyom. ");
INSERT INTO hot_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Êŋ ma Yisu hik siv auk ma hanaŋ, “Avômalô bôlôŋ êntêk leŋiŋhaviŋ yandum lavôŋiŋ te ek injik thô nena Wapômbêŋ bôk hêv ya ba yahalêm eka. Yanaŋ avanôŋ êndêŋ môlô nena tem miŋ yandum lavôŋiŋ ek avômalô bôlôŋ êntêk nêgê ami, ma mi.” ");
INSERT INTO hot_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yôv ma Yisu hatak thêlô ma hathak yeŋ hathak loŋbô ba hi kasukthôm vi tuvulu. ");
INSERT INTO hot_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yisu anêŋ ŋê ku leŋiŋpaliŋ ba miŋ ewa polom bêŋ anôŋ ba ethak yeŋ ami ma ewa polom doŋtom iyom. ");
INSERT INTO hot_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma Yisu hanaŋ lôklokwaŋ hadêŋ thêlô nena, “Noyabiŋ am esak Palisi lo Helot iniŋ yis.” ");
INSERT INTO hot_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma ŋê ku enaŋ hadêŋ thêlôda nena, “Betha hanaŋ hathak alalô polom mi la.” ");
INSERT INTO hot_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma doŋtom yani hayala iniŋ abô atu ba enaŋ ba hanaŋ hik thêlô liŋ, “Môlô onaŋ hathak miŋ owa polom ami eka? Môlô ôthôŋ lôk miŋ oyala ami denaŋ e? Ma unim auk ma thekthek e? ");
INSERT INTO hot_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Môlô ŋê lôk malemim ma miŋ ôyê tak ami e? Ma môlô ŋê lôk lemimôndôŋ ma miŋ olaŋô abô ami e? Ma môlô miŋ lemimhabi nôm atu ba bôk yahadum ami e? ");
INSERT INTO hot_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Yahaya polom baheŋvi ek avômalô hatôm 5,000 ma usup polom wata halôk vak sam vithê?” Ma enaŋ, “Laumiŋ ba lahavuju.” ");
INSERT INTO hot_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma yahaya polom baheŋvi ba lahavuju ek avômalô hatôm 4,000, ma usup polom wata halôk vak sam vithê?” Ma enaŋ, “Baheŋvi ba lahavuju.” ");
INSERT INTO hot_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Êŋ ma Yisu hanaŋ hadêŋ i, “Aisê, miŋ oyala ami denaŋ e?” ");
INSERT INTO hot_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ma thêlô i êyô Betsaida ma avômalô doho ewa anyô mapusip te hayô ma enaŋ hik yani liŋ lôklokwaŋ ek êsôm ôpêŋ. ");
INSERT INTO hot_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma Yisu havaloŋ anyô mapusip hamô baŋ ma hadadi ba thai etak malak bêŋ ma i daim dokte. Ma Yisu hasôwapôk hathak ôpêŋ madaluk luvi ma hatak baŋ hayô hêk ôpêŋ. Ma hanaŋ, “Hôyê nômlate mena mi e?” ");
INSERT INTO hot_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma ôpêŋ hêv ma liŋ ma hanaŋ, “Yahayê avômalô doho, ma doŋtom thêlô hatôm alokwaŋ i ba êlêm.” ");
INSERT INTO hot_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Êŋ ma Yisu hatak baŋ hayô hêk ôpêŋ madaluk hathak loŋbô. Ma ôpêŋ madaluk hakyav ba habitak mavi ma hayê nômkama sapêŋ halêm yaiŋ. ");
INSERT INTO hot_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma Yisu hanaŋ nena, “Nu oda anêm unyak ma miŋ nu malak bêŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ma Yisu lôk anêŋ ŋê ku etak loŋ êŋ ma ibup ethak malak nenanena takatu ba hamô habobo Sisalia Pilipai. Eveŋ loŋôndê denaŋ ma hanaŋ hik anêŋ ŋê ku liŋ, “Avômalô ethak elam ya nena opalê?” ");
INSERT INTO hot_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma thêlô enaŋ nena, “Doho enaŋ nena o ma Jon anyô hathik ŋaŋ ma doho enaŋ nena o ma Elia ma doho enaŋ nena o ma plopet bô te.” ");
INSERT INTO hot_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma Yisu hanaŋ hik thêlô liŋ, “Ma môlôda olam ya nena opalê?” Êŋ ma Pita hanaŋ bêŋ nena, “O ma Mesia atu ba Wapômbêŋ hêv ek nêm anêŋ avômalô bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma Yisu hanaŋ lôklokwaŋ ek miŋ nenaŋ abô êŋ bêŋ êndêŋ anyôla ami. ");
INSERT INTO hot_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma Yisu hadôŋ thêlô ba hanaŋ nena, “Anyô Anêŋ Nakaduŋ atu tem esopa Wapômbêŋ anêŋ lahaviŋ ba enja vovaŋ bêŋ anôŋ. Ma Islael iniŋ ŋê bêŋbêŋ lôk ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ tem nimbuliŋ dômiŋ êndêŋ yani. Ma Wapômbêŋ tem indum ba nijik yani vônô. Ma êtôm wak lô ma tem imbiyô esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yisu hanaŋ abô takêŋ bêŋ hadêŋ thêlô, êŋ ma Pita hawa yani hi daim dokte ma hathaŋ ba hanaŋ nena, “Miŋ onaŋ aêŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma doŋtom Yisu hik ma liliŋ ba hayê anêŋ ŋê ku vi ma hathaŋ Pita ba hanaŋ, “Sadaŋ, nu daŋ! Hosopa anyô iniŋ auk iyom ma miŋ hosopa Wapômbêŋ anêŋ auk ami.” ");
INSERT INTO hot_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Êŋ ma Yisu halam avômalô nômbêŋ atu ba êlêm iviŋ anêŋ ŋê ku ma hanaŋ, “Anyôla hadum ek esopa ya, êŋ ma êmbôliŋ dôm êndêŋ yanida ma enja anêŋ alovalaŋaŋsiŋ ba esopa ya. ");
INSERT INTO hot_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ek malê nena ôpatu ba lahabi bêŋ anôŋ hathak anêŋ lôkmala pik, anêŋ lôkmala êŋ tem nêm yak. Ma doŋtom ôpatu ba hatak anêŋ lôkmala ek hasopa ya lôk yenaŋ abô, yani êŋ tem enja lôkmala anôŋ. ");
INSERT INTO hot_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Anyô te hawa nômkama pik sapêŋ, ma doŋtom miŋ hasopa Wapômbêŋ ami ba anêŋ lôkmala hêv yak, êŋ ma tem yani êmô mavi e? Mi anôŋ, tem enja vovaŋ. ");
INSERT INTO hot_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma anyôla hatôm nêm nômlate êndêŋ Wapômbêŋ ek enja anêŋ lôkmala esak loŋbô e? Mi anôŋ! ");
INSERT INTO hot_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Avômalô bôlôŋ êntêk ma lêk idum kobom kambom lomaloma ba êdô Wapômbêŋ. Aêŋ ba anyôla mama ek ya lôk yenaŋ abô, ma embeŋ yam atu ba Anyô Anêŋ Nakaduŋ êlêm imbiŋ Lambô anêŋ deda lôkmaŋgiŋ lôk anêŋ aŋela matheŋ, ma yani tem mama ek ôpêŋ aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma Yisu hanaŋ hadêŋ thêlô, “Yanaŋ avanôŋ êndêŋ môlô nena Wapômbêŋ anêŋ loŋ lôkliŋyak tem êlêm imbiŋ anêŋ lôklokwaŋ bêŋ. Ma môlô vi atu ba umiŋ loŋ êntêk tem nômô lôkmala denaŋ, ma ôŋgô nôm êŋ imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wak baheŋvi ba lahavute hale ba hi ma Yisu hawa Pita lo Jems ma Jon iviŋ yani ba ethak dumlolê daim te ba i êmô daluk. Êŋ ma Yisu liŋkupik habitak yaŋda hêk thêlô maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ma anêŋ kwêv habitak thapuk anôŋ biŋ ba anyô pik la miŋ hatôm isik anêŋ kwêv ba imbitak thapuk aêŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma ketheŋ oyaŋ ma Elia lo Mose êyô ma enaŋ abô haviŋ Yisu ba thêlô êyê. ");
INSERT INTO hot_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma Pita hanaŋ hadêŋ Yisu, “Kêdôŋwaga, mavi anôŋ ek lêk alalô amô loŋ êntêk. Yêlô tem nadav unyak lôkkupik lokwaŋlô, te ek o ma te ek Mose ma te ek Elia.” ");
INSERT INTO hot_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Thêlô êkô kambom ba êthôŋ abô nenaŋ paliŋ ba intu Pita hanaŋ aêŋ.) ");
INSERT INTO hot_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma buliv te hayô hava thêlô siŋ, ma abô te halêm anêŋ buliv êŋ kapô nena, “Intu ma yenaŋ Okna atu ba yaleŋhaviŋ videdauŋ. Ba nodaŋô anêŋ abô!” ");
INSERT INTO hot_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma ketheŋ oyaŋ ma thêlô êyê hawê haveŋ ma Yisu iyom intu hamiŋ ma miŋ anyôla hamiŋ haviŋ yani ami. ");
INSERT INTO hot_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Vêm ma etak dumlolê êŋ ba êlôk ele i ma Yisu hanaŋ lôklokwaŋ ek miŋ nenaŋ nôm atu ba êyê bêŋ êndêŋ anyôla ami endeba Anyô Anêŋ Nakaduŋ atu ema ba imbiyô ênjêk ŋama esak loŋbô am. ");
INSERT INTO hot_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aêŋ ba thêlô ivuŋ abô êŋ hêk thêlôda ma miŋ enaŋ bêŋ ami, ma doŋtom enaŋ abô pôk bêŋ hathak “ema lo imbiyô ênjêk ŋama” anêŋ ôdôŋ ma aisê? ");
INSERT INTO hot_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma thêlô enaŋ hik Yisu liŋ, “Aisê ka ŋê lôkauk hathak abô balabuŋ enaŋ nena Elia tem êmôŋ ba êlêm vêm ka Mesia?” ");
INSERT INTO hot_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ma Yisu hanaŋ nena, “Avanôŋ! Elia tem êmôŋ ek indum nômkama sapêŋ imbitak mavi esak loŋbô. Ma doŋtom yanaŋ êndêŋ môlô nena Elia bôk halêm yôv. Ma avômalô esopa iniŋ leŋiŋhaviŋ iyom ba idum kambom lomaloma hadêŋ yani hatôm atu ba Wapômbêŋ anêŋ kapya bôk hanaŋ hathak yani. Ma doŋtom aisê ka Wapômbêŋ anêŋ kapya hanaŋ nena Anyô Anêŋ Nakaduŋ atu tem enja vovaŋ bêŋ lôk nêmbôliŋ dômiŋ êndêŋ yani?” ");
INSERT INTO hot_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yisu thêlô êyô ek ŋê ku vi ma êyê avômalô bêŋ anôŋ lêk ethak doŋtom ba êmô. Ma ŋê lôkauk hathak abô balabuŋ lôk anêŋ ŋê ku vi atu ba êmô enaŋ abô ba êkôki hathak. ");
INSERT INTO hot_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma avômalô nômbêŋ êŋ êyê Yisu, ma esoŋ kambom ba elaŋviŋ i ma ewa yani thô. ");
INSERT INTO hot_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma Yisu hanaŋ hik thêlô liŋ, “Môlô ôkôkam hathak malê?” ");
INSERT INTO hot_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma anyô te hamiŋ avômalô nômbêŋ êŋ kapô ba hanaŋ, “Kêdôŋwaga, ŋgôk te havaloŋ yenaŋ okna abôlêk loŋ ba miŋ hatôm enaŋ abô ami. Ba intu yahawa halêm ek o. ");
INSERT INTO hot_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ŋgôk hathak hayôkwiŋ yani ba habi yani halôk pik ma abôlêk wapôk thapuk hale yaiŋ ma haloŋoloŋ abôlêk kalalaŋ ma liŋ havuviŋ ba thotho. Yahanaŋ ek anêm ŋê ku nênêm ŋgôk êŋ vê ma doŋtom thêlô miŋ hatôm ami.” ");
INSERT INTO hot_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma Yisu hanaŋ viyaŋ, “Yahamô haviŋ môlô sawa daim ma doŋtom miŋ ôêvhaviŋ ami ma owa auk lokbaŋ aleba yakapôlôŋ lêk hagiap hathak môlô. Noja okna êŋ êlêm.” ");
INSERT INTO hot_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Êŋ ma ewa okna atu hi hadêŋ Yisu. Ŋgôk hayê Yisu, ma hayôkwiŋ okna êŋ kambom ba hêv yak halôk pik ba hapiki ma abôlêk thôk hêv yak. ");
INSERT INTO hot_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma Yisu hanaŋ hik lambô liŋ, “Ŋgôk habuliŋ yani hadêŋ aŋgê?” Ma lambô hanaŋ nena, “Sêbôk ba yani yaôna. ");
INSERT INTO hot_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ŋgôk êŋ habi yani halôk atum lôk ŋaŋ lôbôlôŋ ek injik yani vônô ma doŋtom mi. Aêŋ ba o hatôm undum ek ŋgôk êŋ etak yenaŋ okna, êŋ ma hôêv kapôlôm ek yai.” ");
INSERT INTO hot_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma Yisu hanaŋ, “Aisê ka honaŋ nena, ‘o hatôm’? Wapômbêŋ hatôm indum nômkama sapêŋ ek ŋê takatu ba êvhaviŋ yani.” ");
INSERT INTO hot_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma ketheŋ oyaŋ ma okna êŋ anêŋ lambô hanaŋ, “Yahêvhaviŋ ba undum ek yenaŋ auk atu ba miŋ yahêvhaviŋ ami êkôk ya liŋ ek yanêmimbiŋ!” ");
INSERT INTO hot_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ma Yisu hayê nena avômalô êvôv i ketheŋ ethak doŋtom, êŋ ma hathaŋ ŋgôk lelaik atu ba hanaŋ, “O ŋgôk vembôlêk lôk lemôndôŋ putup, yahanaŋ hadêŋ o nena otak okna êntêk ba nu ma miŋ ômbôlêm esak loŋbô ami.” ");
INSERT INTO hot_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma ŋgôk halaŋ boloba ma hayôkwiŋ okna êŋ kambom ma hale yaiŋ ba hi. Ma okna êŋ hêk inaŋ anyô ŋama ba avômalô enaŋ nena, “Lêk hama.” ");
INSERT INTO hot_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma doŋtom Yisu havaloŋ hamô baŋ vi ma havôv ba haviyô hamiŋ. ");
INSERT INTO hot_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Vêm ma Yisu lôk anêŋ ŋê ku iyom êmô unyak kapô ma thêlô enaŋ hik yani liŋ, “Aisê ka yêlô miŋ hatôm nanêm ŋgôk êŋ vê ami?” ");
INSERT INTO hot_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma Yisu hanaŋ viyaŋ hadêŋ thêlô, “Mek iyom intu hatôm nêm ŋgôk anêŋ aêŋ vê.” ");
INSERT INTO hot_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ma thêlô etak loŋ êŋ ba ibitak êyô Galili. Ma Yisu hadô avômalô neyala nena thêlô lêk êmô êsê ");
INSERT INTO hot_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ek êndôŋ anêŋ ŋê ku. Êŋ ma Yisu hanaŋ hadêŋ thêlô, “Tem nenaŋ Anyô Anêŋ Nakaduŋ atu bêŋ ba netak êndôk avômalô baheŋiŋ. Ma tem nijik yani vônô, ma êtôm wak lô ma tem imbiyô esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma anêŋ ŋê ku êthôŋ abô êŋ anêŋ ôdôŋ paliŋ lôk êkô ek nenaŋ injik yani liŋ. ");
INSERT INTO hot_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ma Yisu thêlô êyô Kapaneam ma i êmô unyak kapô te. Êŋ ma Yisu hanaŋ hik thêlô liŋ, “Môlô ôkôkam hathak malê haveŋ loŋôndê ba ôlêm?” ");
INSERT INTO hot_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Thêlô eyala nena thêlô êkôki hathak thêlô alisê intu anyô bêŋ ek Yisu anêŋ ŋê ku vi ba intu thêlô bônôŋ. ");
INSERT INTO hot_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma Yisu halôk hamô ma halam anêŋ ŋê ku laumiŋ ba lahavuju takatu ba êlêm. Ma hanaŋ, “Lemimhaviŋ numbitak anyô bêŋ, êŋ ma undum o endeba yaôna ba ôtôm avômalô lôkthô iniŋ anyô ku oyaŋ.” ");
INSERT INTO hot_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ma hawa amena te ba hadô hamiŋ thêlô malêvôŋ. Ma havaloŋ hamiŋ ma hanaŋ hadêŋ thêlô, ");
INSERT INTO hot_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ôpatu ba hêvhaviŋ ya ba hawa amena yaônate aêntêk thô, ma hatôm hawa ya thô. Ma ôpatu ba hawa ya thô, ma hatôm hawa ôpatu ba hêv ya ba yahalêm thô haviŋ.” ");
INSERT INTO hot_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ma Jon hanaŋ hadêŋ Yisu nena, “Kêdôŋwaga, yêlô ayê anyô te hêv ŋgôk vê hathak anêm athêŋ. Ma doŋtom yani ma miŋ alalô te ami, ba intu yêlô anaŋ ek yani etak ku êŋ.” ");
INSERT INTO hot_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma doŋtom Yisu hanaŋ nena, “Dô! Miŋ numiŋ yani loŋ siŋ ami. Ôpatu ba hadum nômbithi hathak yenaŋ athêŋ ma tem miŋ enaŋ abô kambom ketheŋ esak ya ami, ");
INSERT INTO hot_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ek malê nena ôpatu ba miŋ hapôlik hathak alalô ami, intu alalôaniŋ te. ");
INSERT INTO hot_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yanaŋ avanôŋ êndêŋ môlô nena anyô te hayê nena môlô ma Kilisi anêŋ avômalô ba hêv ŋaŋ hadêŋ môlô, ôpêŋ tem enja anêŋ vuli. ");
INSERT INTO hot_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ma anyô te hadum ba yenaŋ amena atu ba hêvhaviŋ ya te hêv yak, ôpêŋ tem êpôm malaiŋ bêŋ anôŋ. Ôpêŋ tem nêsôkwêŋ valu bêŋ te esak laselo ba nimbi yani êndôk ŋgwêk makidiŋ ba ema. Malaiŋ êŋ ma yaôna ek malaiŋ atu ba yani tem êpôm embeŋ yam. ");
INSERT INTO hot_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ma bahem hadum ba hudum kambom, êŋ ma odabêŋ kisi ba nêm vê ek miŋ undum kambom esak loŋbô ami! Bahem vi iyom ma malaiŋ, ma doŋtom mavi ek nu malak leŋ. Ma bahem luvi hamô ba hudum kambom, êŋ ma lemvimkupik sapêŋ tem ni loŋ atu ba atum hathaŋ ba miŋ hama ami. Ba intu malaiŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma vem hadum ba hudum kambom, êŋ ma odabêŋ kisi ba nêm vê ek miŋ undum kambom esak loŋbô ami! Vem vi iyom ma malaiŋ, ma doŋtom mavi ek nu malak leŋ. Ma vem luvi hamô ba hudum kambom, êŋ ma lemvimkupik sapêŋ tem ni loŋ atu ba atum hathaŋ ba miŋ hama ami. Ba intu malaiŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma malem daluk hadum ba hudum kambom, êŋ ma ômbi vê. Malem daluk vi iyom ma malaiŋ, ma doŋtom mavi ek nu malak leŋ. Ma malem daluk luvi hamô ba hudum kambom, êŋ ma lemvimkupik sapêŋ tem ni loŋ atu ba atum hathaŋ ba miŋ hama ami. Ba intu malaiŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Loŋ êŋ ma matiŋyak tem nejaŋ anyô liŋkupik êtôm wak nômbêŋ intu sapêŋ, ma atum tem esaŋ anyô êmô aêŋ.’ ");
INSERT INTO hot_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Atum tem êpôm avômalô sapêŋ êtôm ŋgwêk etak hathak nôm ek atum êŋ esaê thêlô. ");
INSERT INTO hot_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ŋgwêk ma nôm mavi, ma doŋtom anêŋ maniŋ hêv yak, êŋ ma opalê hatôm idum ba imbitak maniŋ esak loŋbô am? Ŋgwêk hathak hadum nôm ba vasiŋ, ba intu nômô yôhôk mavi imbiŋ am aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ma Yisu hatak loŋ êŋ ma hi haveŋ loŋ Judia lo ŋaŋ Jolodaŋ vi. Ma avômalô bêŋ anôŋ êlêm hathak loŋbô. Êŋ ma hasopa anêŋ bôk lo loŋ ba hadôŋ i. ");
INSERT INTO hot_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma Palisi doho êlêm ma idum ek nesau Yisu ba enaŋ hik yani liŋ, “Abô balabuŋ hanaŋ aisê? Anyô hatôm nêm yanavi vê mena mi e?” ");
INSERT INTO hot_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma Yisu hanaŋ viyaŋ, “Mose bôk hanaŋ aisê?” ");
INSERT INTO hot_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma thêlô enaŋ, “Mose halôk ek anyô eto kapya nêm yanavi vê ba etak êndôk yanavi baŋ ek nêm yani vê.” ");
INSERT INTO hot_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Êŋ ma Yisu hanaŋ nena, “Môlô ŋê lemôndôŋ kôtôŋ kambom ba intu Mose hato balabuŋ êŋ ba hêv hadêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma doŋtom ‘sêbôk ba môŋ anôŋ atu ba Wapômbêŋ hapesaŋ avômalô ma hapesaŋ anyô lo avi. ");
INSERT INTO hot_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ba intu Wapômbêŋ bôk hanaŋ nena, “Anyô tem etak lambô lo talêbô ma esak doŋtom imbiŋ yanavi ");
INSERT INTO hot_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ek thai nimbitak êtôm kupik doŋtom iyom.” ’ Thai miŋ ju hathak loŋbô ami ma lêk ibitak doŋtom. ");
INSERT INTO hot_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aêŋ ba nôm atu ba Wapômbêŋ bôk havak loŋ hathak doŋtom, ma miŋ hatôm anyôla epole vê ami.” ");
INSERT INTO hot_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Vêm ma Yisu lôk anêŋ ŋê ku êmô unyak kapô, ma anêŋ ŋê ku enaŋ hik yani liŋ hathak abô êŋ. ");
INSERT INTO hot_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Êŋ ma Yisu hanaŋ hadêŋ thêlô, “Anyô hadô yanavi ba hawa avi yaŋ, êŋ ma hadum sek ba habuliŋ yanavi bô. ");
INSERT INTO hot_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma avi te hadô yamalô ba hawa anyô yaŋ, êŋ ma hadum sek aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ma avômalô ewa avômena yaônena i hadêŋ Yisu ek etak baŋ êyô ênjêk thêlô. Ma doŋtom anêŋ ŋê ku ethaŋ avômalô takêŋ. ");
INSERT INTO hot_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yisu hayê nôm êŋ, ma lamaniŋ ba hanaŋ hadêŋ anêŋ ŋê ku nena, “Notak avômena yaônena ba nêlêm êndêŋ ya ma miŋ numiŋ thêlô loŋ siŋ ami ek malê nena avômalô takatu ba athêŋ mi ma hatôm avômena takêntêk ba Wapômbêŋ anêŋ loŋ lôkliŋyak ma thêlôniŋ. ");
INSERT INTO hot_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yanaŋ avanôŋ êndêŋ môlô nena ôpatu ba miŋ hawa Wapômbêŋ anêŋ loŋ lôkliŋyak hatôm avômena yaônena ami, miŋ hatôm imbitak êyô loŋ êŋ kapô ba ni ami. Ma mi.” ");
INSERT INTO hot_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma Yisu havaloŋ avômena ma hatak baŋ hayô hêk i ma hêv mek hathak thêlô. ");
INSERT INTO hot_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ma Yisu haviyô ba hi ma anyô te halaŋviŋ hadêŋ yani ma halek vadôŋ lêlô hamô valuvi ma hanaŋ, “Kêdôŋwaga mavi, yandum malê ek yamô lôkmala êtôm wak nômbêŋ intu sapêŋ?” ");
INSERT INTO hot_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma Yisu hanaŋ, “Holam ya nena mavi eka? Anyô late miŋ mavi ami ma Wapômbêŋ iyom intu ba mavi. ");
INSERT INTO hot_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Abô balabuŋ ma bôk hoyala yôv: ‘Miŋ uŋgwik anyô vônô ami. Miŋ undum sek imbiŋ anyô yaŋ yanavi ami. Miŋ onja vani ami. Miŋ onaŋ abôyaŋ esak anyô vi ba undum abô ek i ami. Miŋ onaŋ abôyaŋ ek ômbôv anyô yaŋ anêŋ nômkama ami. Ma ondovak lemambô lo lemtambô.’” ");
INSERT INTO hot_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma ôpêŋ hanaŋ, “Kêdôŋwaga, ya yaôna aleba lêk ma yahasopa abô balabuŋ takêŋ.” ");
INSERT INTO hot_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ma Yisu hayê ôpêŋ ba lahaviŋ. Ma hanaŋ, “O ma nômlate mi denaŋ. Nu nêm anêm nômkama sapêŋ ek avômalô nênêm vuli, ma onja valuseleŋ sapêŋ ba nêm êndêŋ avômalô siv. Hudum aêŋ, ma tem anêm nômkama mavi lomaloma êmô malak leŋ. Ma ôlêm osopa ya.” ");
INSERT INTO hot_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yani ma anyô lôk nômkama bêŋ anôŋ. Ba intu halaŋô abô êŋ, ma hakôm ba hi lôk lamalaiŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ma Yisu hayê hawê haveŋ ma hanaŋ hadêŋ anêŋ ŋê ku, “Ŋê lôk nômkama bêŋ tem nêpôm malaiŋ bêŋ ek nimbitak nêyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ba ini.” ");
INSERT INTO hot_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yisu anêŋ ŋê ku elaŋô ba esoŋ kambom. Ma Yisu hanaŋ hadêŋ thêlô hathak loŋbô nena, “Yenaŋ avômena, avômalô takatu ba indum ek nimbitak nêyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ba ini ma tem nêpôm malaiŋ bêŋ anôŋ! ");
INSERT INTO hot_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Miŋ malaiŋ bêŋ ek bok kamel imbitak êyô luvik idu sôp anêŋ abyaŋ ba ni ami, ma doŋtom malaiŋ anôŋ ek anyô lôk nômkama bêŋ te imbitak êyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô.” ");
INSERT INTO hot_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ma Yisu anêŋ ŋê ku esoŋ kambom anôŋ ba enaŋ hadêŋ i, “Avanôŋ e? Aêŋ ba miŋ hatôm anyôla imbitak êyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ba ni ami e?” ");
INSERT INTO hot_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma Yisu hayê thêlô lôklokwaŋ ma hanaŋ, “Wapômbêŋ iyom hatôm indum nômkama sapêŋ. Ma anyô te miŋ hatôm nêm yanida bulubiŋ ami ma mi.” ");
INSERT INTO hot_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma Pita hanaŋ hadêŋ Yisu, “Yêlô bôk atak yêlôaniŋ nômkama sapêŋ ba alêm asopa o!” ");
INSERT INTO hot_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma Yisu hanaŋ nena, “Yanaŋ avanôŋ êndêŋ môlô, anyô te lahabi ya lôk yenaŋ Abô Mavi ba hatak anêŋ unyak lôk iviyaŋ ma livi lôk talêbô lo lambô ma nali lôk anêŋ pik, ");
INSERT INTO hot_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","êŋ ma Wapômbêŋ tem nêm bêŋ anôŋ êndêŋ ôpêŋ êtôm 100 êyô êmô anêŋ loŋ imbiŋ. Ôpêŋ hamô pik denaŋ, ma tem enja nômkama bêŋ anôŋ aêntêk unyak lôk iviyaŋ ma livi lôk taluvi ma nali lôk pik, ma doŋtom avômalô vi tem nimbuliŋ yani imbiŋ. Ma embeŋ yam ma tem êmô lôkmala êtôm wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Odaŋô! Ŋê lôk athêŋ bêŋ, bêŋ anôŋ tem nimbitak ŋê lôk athêŋ mi. Ma ŋê lôk athêŋ mi bêŋ anôŋ tem nimbitak ŋê lôk athêŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yisu thêlô i Jelusalem ma Yisu hi hamôŋ. Ma anêŋ ŋê ku êyê ba esoŋ kambom ma avômalô takatu ba eveŋ yam êkô. Ma Yisu hanaŋ hadêŋ anêŋ ŋê ku laumiŋ ba lahavuju takatu ek nêlêm bidoŋ ma hanaŋ hathak nôm takatu ba tem êpôm yani. ");
INSERT INTO hot_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Odaŋô. Alalô ayô Jelusalem ma tem nenaŋ Anyô Anêŋ Nakaduŋ atu bêŋ ba nênêm yani êndêŋ ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ. Ma tem nenaŋ ek nijik yani vônô ma nênêm yani êndêŋ avômalô loŋ buyaŋ ");
INSERT INTO hot_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ek thêlô nenaŋ abôma lôk nêsôvwapôk esak yani ma nebali yani lôk nijik yani vônô. Wak lô ende ba ni ma tem imbiyô esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yôv ma Sebedi nakaduŋ luvi, Jems lo Jon, i hadêŋ Yisu ma enaŋ, “Kêdôŋwaga, yai leŋiŋhaviŋ undum nômlate ek yai.” ");
INSERT INTO hot_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma Yisu hanaŋ, “Mamu lemimhaviŋ malê?” ");
INSERT INTO hot_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma thai enaŋ nena, “Otak yai yaŋ êmô bahem vianôŋ ma yaŋ êmô bahem vikeŋ ênjêk anêm loŋ lôkmaŋgiŋ kapô.” ");
INSERT INTO hot_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma Yisu hanaŋ, “Mamu ôthôŋ nôm atu ba onaŋ hik ya liŋ paliŋ. Hatôm nunum êndôk tase atu ba tem yanum lôk nusik êndôk ŋaŋ atu ba tem yasik e?” ");
INSERT INTO hot_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma enaŋ, “Yai hatôm.” Ma Yisu hanaŋ, “Avanôŋ, tase êŋ lôk ŋaŋ êŋ tem nunum lôk nusik. ");
INSERT INTO hot_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma doŋtom nêmô yabaheŋ vianôŋ lôk vikeŋ, ma miŋ yenaŋ ku ami. Mi, Wapômbêŋ da hayabiŋ ku êŋ ba bôk hatak anyô doho yôv ek nêmô loŋ êŋ.” ");
INSERT INTO hot_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ŋê ku laumiŋ takêŋ elaŋô abô êŋ ba leŋiŋŋaŋa hadêŋ Jems lo Jon. ");
INSERT INTO hot_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma Yisu halam sapêŋ ethak doŋtom ma hanaŋ, “Môlô bôk oyala nena avômalô loŋ buyaŋ iniŋ kiŋ ethak ebam i ba ibuliŋ ŋê takatu ba êmô thêlô vibiŋ. Ma iniŋ ŋê bêŋbêŋ ethak ethaŋ iniŋ avômalô aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Odaŋô! Môlô miŋ nundum kobom êŋ ami! Môlô te lahaviŋ imbitak anyô lôk athêŋ bêŋ ênjêk môlô malêvôŋ, êŋ ma imbitak êtôm môlônim anyô ku ek nêm môlô sa. ");
INSERT INTO hot_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma ôpatu lahaviŋ imbitak êtôm môlônim anyô bêŋ, êŋ ma êmô êtôm avômalô sapêŋ iniŋ anyô ku oyaŋ ");
INSERT INTO hot_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","hatôm ya Anyô Anêŋ Nakaduŋ atu ba yahadum aêŋ iyom. Miŋ yahalêm ek yandum ŋê bêŋbêŋ pik iniŋ kobom ba yasaŋ avômalô ek nindum yenaŋ ku ami. Mi anôŋ! Yahalêm hatôm anyô ku ek yanêm avômalô sa lôk yatak yenaŋ lôkmala ek nêm avômalô bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ma Yisu lôk anêŋ ŋê ku êyô Jeliko. Idum ek netak Jeliko ma avômalô bêŋ anôŋ i haviŋ thêlô. Ma anyô madaluk pusip te anêŋ athêŋ nena Batimeas hamô loŋôndê daŋ vi ba hapetenak ek avômalô nênêm yani sa. (Batimeas anêŋ ôdôŋ nena Timeas nakaduŋ.) ");
INSERT INTO hot_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yani halaŋô nena Yisu anêŋ Nasalet halêm, ma halam kaêk lôklala nena, “Yisu, Devit anêŋ Lim Lukmuk, nêm kapôlôm ek ya!” ");
INSERT INTO hot_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma avômalô bêŋ anôŋ ethaŋ yani ba enaŋ, “O bônôŋ!” Ma doŋtom yani halam lôklala nena, “Yisu, Devit anêŋ Lim Lukmuk, nêm kapôlôm ek ya!” ");
INSERT INTO hot_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Êŋ ma Yisu hamiŋ ma hanaŋ, “Nodam yani êlêm.” Ma elam hadêŋ anyô madaluk pusip atu nena, “Lemmavi! Umbiyô ba nu! Yani halam o.” ");
INSERT INTO hot_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Êŋ ma hakaliv anêŋ kwêv thilibuŋ hi ma hasôv kisi haviyô hamiŋ ma hi hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma Yisu hanaŋ hadêŋ yani, “Lemhaviŋ yandum malê êndêŋ o?” Ma anyô madaluk pusip êŋ hanaŋ, “Kêdôŋwaga, yaleŋhaviŋ yaŋgê tak.” ");
INSERT INTO hot_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma Yisu hanaŋ, “Umbiyô ba nu. Anêm hôêvhaviŋ hadum ba hubitak mavi.” Ma ketheŋ oyaŋ ma ôpêŋ madaluk hakyav ba hayê tak, ma hasopa Yisu haveŋ loŋôndê. ");
INSERT INTO hot_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yisu thêlô i ebobo Jelusalem ma i êyô Betpagi lo Betani, malak ju êŋ hêk habobo Dum Oliv. Ma hêv anêŋ ŋê ku ju ba i ");
INSERT INTO hot_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma hanaŋ nena, “Mamu unu malak entuvulu. Ubitak ôyô kapô ba u, ma tem ôŋgô ekak bok doŋki map te loŋ ba hamiŋ. Bok êŋ ma miŋ bôk anyôla hayô hamô ami. Nopole yak vê ma nondom ba nôlêm. ");
INSERT INTO hot_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma anyôla hanaŋ hik mamu liŋ nena, ‘Udum aêŋ eka?’ ma nonaŋ êndêŋ yani nena, ‘Anyô Bêŋ lahaviŋ idum ku te esak vêmam, ka tem nêm êmbôlêm.’” ");
INSERT INTO hot_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Êŋ ma ŋê ku ju atu i ma êyê bok doŋki map atu ekak loŋ ba êthô hamô unyak abôlêk habobo loŋôndê viyaiŋ. Ma thai epole yak vê. ");
INSERT INTO hot_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ma anyô doho imiŋ loŋ êŋ êyê ba enaŋ, “Mamu udum malê ba opole bok anêŋ yak vê?” ");
INSERT INTO hot_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma thai enaŋ hatôm atu ba Yisu hanaŋ hadêŋ thai. Êŋ ma etak thai ba i. ");
INSERT INTO hot_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma ewa bok doŋki êŋ ba i hadêŋ Yisu, ma ibi iniŋ kwêv thilibuŋ daim thô ba eŋgava hayôhêk bok dômlokwaŋ ma Yisu hayô hamô. ");
INSERT INTO hot_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma avômalô bêŋ anôŋ eŋgava iniŋ kwêv thilibuŋ daim ma vi ele nôkyalô ŋauŋ hamô kamuŋ ba eŋgava hêk loŋôndê. ");
INSERT INTO hot_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma vi êmôŋ ma vi eveŋ yam ma Yisu halôk malêvôŋ ba elam nena, “Osana!” “Wapômbêŋ nêm lamavi êndêŋ ôpatu ba halêm hathak Anyô Bêŋ anêŋ athêŋ!” ");
INSERT INTO hot_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Wapômbêŋ nêm anêŋ lamavi êyô êmô bumalô Devit anêŋ lim êntêk atu ba tem eyabiŋ alalô êtôm kiŋ êtôm sêbôk ba Devit hayabiŋ! Osana! Nambô Wapômbêŋ anêŋ athêŋ esak leŋ!” ");
INSERT INTO hot_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ma hi Jelusalem ma habitak hayô unyak matheŋ anêŋ piklêvôŋ kapô ba hi. Ma hayê nômkama takatu ba hamô loŋ êŋ. Ma doŋtom wak lêk halôk jalôm, êŋ ma hatak Jelusalem ma hi Betani haviŋ anêŋ ŋê ku laumiŋ ba lahavuju takatu. ");
INSERT INTO hot_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Haviyô hayaŋ ma etak Betani ek ini Jelusalem. Ma Yisu hama kisi. ");
INSERT INTO hot_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma hayê alokwaŋ sabo te lôk ŋauŋ hamiŋ daim dokte. Êŋ ma hi hayô alokwaŋ êŋ ôdôŋ ek ênjê nena hik anôŋ mena mi. Ma doŋtom hayê ŋauŋ oyaŋ iyom ma miŋ hik ami ek malê nena miŋ anêŋ waklavôŋ injik ami. ");
INSERT INTO hot_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Êŋ ma Yisu hanaŋ hadêŋ alokwaŋ êŋ nena, “Anyô late miŋ hatôm enjaŋ anêm anôŋ esak loŋbô ami.” Ba anêŋ ŋê ku elaŋô. ");
INSERT INTO hot_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ma Yisu thêlô êyô Jelusalem. Ma habitak hayô unyak matheŋ kapô anêŋ piklêvôŋ. Ma hayê avômalô ewa nômkama ba êdô hamô ek avômalô vi nênêm vuli. Êŋ ma halupuniŋ i ba hêv i vê hêk unyak matheŋ kapô ba ele yaiŋ ba i. Ma hale ŋê takatu ba êwê ŋê loŋ buyaŋ iniŋ valuseleŋ hathak Hiblu iniŋ valuseleŋ iniŋ balê liliŋ. Ma hadum aêŋ hadêŋ ŋê takatu ba êdô menak bôbô hamô ek avômalô vi nênêm vuli. ");
INSERT INTO hot_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma hamiŋ loŋ siŋ ek avômalô miŋ neja iniŋ nômkama ba ini kapô ek nênêm vuli ami. ");
INSERT INTO hot_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma Yisu hadôŋ thêlô ba hanaŋ aêntêk, “Wapômbêŋ anêŋ kapya hanaŋ nena, ‘Yenaŋ unyak ma unyak avômalô pik sapêŋ neteŋ mek êndôk.’ Ma môlô lêk udum ba habitak hatôm ŋê vani iniŋ loŋ ekopak êmô.” ");
INSERT INTO hot_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ elaŋô abô êŋ ma êbôlêm loŋôndê ek nijik yani vônô. Ma doŋtom thêlô êkô hathak yani ek malê nena avômalô sapêŋ esoŋ kambom hathak anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yaŋsiŋ anôŋ ma Yisu thêlô etak Jelusalem ba i. ");
INSERT INTO hot_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hayaŋ lôkbôk ma Yisu thêlô êvôi ma êyê alokwaŋ sabo atu lêk hama ba hakapok hêk ŋauŋ ba hayô ôdôŋ. ");
INSERT INTO hot_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma Pita lahabi Yisu anêŋ abô ba hanaŋ nena, “Kêdôŋwaga, nôŋgô! Alokwaŋ sabo wakbôk atu ba hothaŋ ma lêk hakapok yôv.” ");
INSERT INTO hot_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma Yisu hanaŋ hadêŋ thêlô, “Nônêmimbiŋ Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yanaŋ avanôŋ êndêŋ môlô nena ôpatu ba hanaŋ hadêŋ dumlolê êntêk nena, ‘Ômbi o kisi ni tamu ŋgwêk’, ma hêvhaviŋ ba havaloŋ anêŋ abô êŋ loŋ lôklokwaŋ ma miŋ laluvi ami, êŋ ma Wapômbêŋ tem indum ba dumlolê êŋ endaŋô ôpêŋ anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Aêŋ ba intu yanaŋ êndêŋ môlô nena malê atu ba môlô onaŋ halôk unim mek, êŋ ma nônêmimbiŋ nena lêk owa yôv, ma nôm êŋ tem imbitak êtôm môlônim. ");
INSERT INTO hot_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Môlô umiŋ ba oteŋ mek, ba lemimhabi kambom atu ba anyôla bôk hadum hadêŋ o, êŋ ma notak unim kapôlômim ek ôpêŋ. Udum aêŋ ma môlônim Lemambô atu ba hamô malak leŋ tem etak kapô ek môlô aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ma Yisu thêlô i Jelusalem hathak loŋbô ba êyô unyak matheŋ anêŋ piklêvôŋ. Ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ lôk ŋê bêŋbêŋ vi i hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma enaŋ hik yani liŋ nena, “Opalê hêv athêŋ bêŋ hadêŋ o lôk hêv ku hadêŋ o ba intu hudum nôm takêntêk?” ");
INSERT INTO hot_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma Yisu hanaŋ hadêŋ i nena, “Tem yanaŋ injik môlô liŋ esak abô te aêŋ iyom. Ba onaŋ abô êŋ bêŋ hadêŋ ya ma tem yandam ôpatu ba hêv athêŋ bêŋ hadêŋ ya êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Opalê hêv ku nisik avômalô êndôk ŋaŋ hadêŋ Jon? Wapômbêŋ leŋ? Mena anyô pik? Môlô nonaŋ êndêŋ ya!” ");
INSERT INTO hot_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma thêlôda enaŋ hadêŋ i nena, “Alalô anaŋ nena Wapômbêŋ hêv ku êŋ hadêŋ Jon ma tem yani enaŋ, ‘Aisê ka môlô miŋ ôêvhaviŋ yani ami?’ ");
INSERT INTO hot_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma doŋtom alalô anaŋ nena, ‘Anyô pik te hêv ku êŋ,’ êŋ ma avômalô tem leŋiŋmaniŋ êndêŋ alalô. Ek malê nena thêlô sapêŋ êvhaviŋ nena Jon ma plopet te.” ");
INSERT INTO hot_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma thêlô enaŋ hadêŋ Yisu nena, “Yêlô athôŋ paliŋ.” Êŋ ma Yisu hanaŋ hadêŋ thêlô, “Aêŋ ba miŋ hatôm yandam ôpatu ba hêv athêŋ bêŋ hadêŋ ya anêŋ athêŋ bêŋ êndêŋ môlô ami. Ma mi.” ");
INSERT INTO hot_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ma Yisu hanaŋ abô loŋ kapô doho hadêŋ thêlô. Ba hanaŋ, “Anyô te havatho anêŋ ku yak waiŋ ma havak lôk hawê haveŋ. Ma halav lôv nêyô nimiŋ waiŋ anêŋ anôŋ pesa ek neja anêŋ thôk. Ma halav unyak daim te ek anyô nêmô ek neyabiŋ ku êŋ. Vêm ma hatak ku êŋ halôk anyô doho baheŋiŋ ek neyabiŋ ba hik anôŋ ma thêlô neja anôŋ vi ma nênêm vi êndêŋ yani. Vêm ma hatak loŋ êŋ ba hi loŋ buyaŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Waklavôŋ yak waiŋ hik anôŋ hayô ma hêv anêŋ anyô ku te ba hi hadêŋ ŋê takatu ba eyabiŋ anêŋ ku atu. Yani lahaviŋ thêlô nênêm anôŋ doho êndêŋ yani êtôm sêbôk ba thêlô evak abô haviŋ i. ");
INSERT INTO hot_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma doŋtom thêlô evaloŋ ôpêŋ loŋ ma ik yani kambom ba êv yani hi oyaŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Vêm ma hêv anyô ku yaŋ ba hi hathak loŋbô, ma doŋtom ik halôk wakadôk ma êv mama hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Êŋ ma hêv anyô ku te hathak loŋbô ma doŋtom thêlô ik yani vônô. Vêm ma hêv tomtom aêŋ habup hathak ba vi ma evali ma vi ma ik vônô. ");
INSERT INTO hot_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Hadum aêŋ aleba lêk mi ma anyô doŋtom iyom hamô. Ôpêŋ ma anêŋ namalô atu ba yani lahaviŋ. Hêv ôpêŋ hi ma lahabi nena, ‘Êntêk ma yenaŋ okna ba tem nedaŋô anêŋ abô.’ ");
INSERT INTO hot_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ma doŋtom ŋê takatu ba eyabiŋ ku êŋ êyê ôpêŋ ma enaŋ hadêŋ thêlôda aêntêk, ‘Ôpêntêk ma ku alaŋ anêŋ nakaduŋ ba tem eyabiŋ lambô anêŋ ku. Alalô ik yani vônô ma ku êŋ tem imbitak alalôaniŋ.’ ");
INSERT INTO hot_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ba intu evaloŋ yani ba ik yani vônô ma ibi anêŋ kupik hale viyaiŋ ba hi. ");
INSERT INTO hot_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Aêŋ ba ku alaŋ tem indum malê? Tem ni injik ŋê takêŋ vônô ma nêm ku êŋ êndêŋ anyô vi ek neyabiŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Môlô bôk osam Wapômbêŋ anêŋ abô bu êntêk mena mi e? “‘Valu atu ba ŋê elav unyak êpôlik hathak, ma lêk habitak landiŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anyô Bêŋ da hadum nôm êŋ, ma yêlô ayê nôm êŋ nena mavi anêŋ dôêŋ.’” ");
INSERT INTO hot_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ma Islael iniŋ ŋê bêŋbêŋ eyala nena Yisu hanaŋ abô loŋ kapô êŋ hathak thêlô ba intu êbôlêm loŋôndê ek nebaloŋ yani. Ma doŋtom êkô hathak avômalô, ba intu etak yani ma thêlô i. ");
INSERT INTO hot_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Vêm ma êv Palisi doho lôk ŋê esopa Helot doho ba i hadêŋ Yisu ek nesau yani esak abô ek nebaloŋ yani. ");
INSERT INTO hot_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Thêlô êyô ek Yisu ma enaŋ, “Kêdôŋwaga, yêlô ayala nena o ma anyô abô avanôŋ. Ma miŋ hothak hobam anyô yaŋ ma hôdô anyô yaŋ ami. Ba intu ŋê bêŋbêŋ êdô anêm abô, ma miŋ hôkô ek i ami. Ma hothak huik Wapômbêŋ anêŋ abô thô hadêŋ avômalô. Aêŋ ba lemhabi aisê? Bumalô iniŋ balabuŋ hanaŋ nena yêlô hatôm nanêm valuseleŋ êndêŋ Sisa mena mi?” ");
INSERT INTO hot_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma doŋtom Yisu hayê thêlôniŋ auk kambom thô ba hanaŋ hik thêlô liŋ, “Aisê ba môlô udum ek numbuliŋ ya? Noja valuseleŋ te êlêm ek yaŋgê.” ");
INSERT INTO hot_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Êŋ ma thêlô ewa valuseleŋ te halêm ek Yisu. Ma Yisu hanaŋ hadêŋ thêlô nena, “Opalê anêŋ dahô lôk anêŋ athêŋ hêk valuseleŋ êntêk?” Ma thêlô enaŋ, “Sisa.” ");
INSERT INTO hot_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Êŋ ma Yisu hanaŋ hadêŋ thêlô nena, “Sisa anêŋ nômkama ma nônêm êndêŋ Sisa da. Ma Wapômbêŋ anêŋ nômkama ma nônêm êndêŋ Wapômbêŋ da.” Ma thêlô elaŋô ba esoŋ kambom hathak anêŋ abô êŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma Sadyusi doho i hadêŋ Yisu. Thêlô ma ôdôŋ te atu ba enaŋ nena ŋê ŋama tem miŋ nimbiyô esak loŋbô ami. Aêŋ ba intu enaŋ hik Yisu liŋ nena, ");
INSERT INTO hot_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kêdôŋwaga, Mose bôk hato hadêŋ alalô nena, ‘Anyô te hama ba nali mi ma anêŋ yaŋ hamô, ma enja avi tôp êŋ ek imbi yaŋ atu ba hama anêŋ nakaduŋ vê.’ ");
INSERT INTO hot_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aêŋ ba ŋê lôk iviyaŋ baheŋvi ba lahavuju êmô. Ma bôp hawa avi te ba hama ma nakaduŋ mi. ");
INSERT INTO hot_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ma nôk enja avi tôp êŋ, hawa ba hama ba nakaduŋ mi. Ma ŋgwa enja avi tôp bô êŋ, nena hama haviŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Êŋ ma iviyaŋ takatu ba êmô ma nesopa kobom doŋtom êŋ iyom. Vêm ma avi tôp êŋ hama haviŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ma waklavôŋ ŋê ŋama iviyô hathak loŋbô ma avi tôp atu ba ŋê lôk iviyaŋ baheŋvi ba lahavuju takatu ba ewa ma alisê te anêŋ avi?” ");
INSERT INTO hot_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma Yisu hanaŋ hadêŋ thêlô, “Môlô miŋ oyala Wapômbêŋ anêŋ lôklokwaŋ lôk anêŋ abô atu ba hêk anêŋ kapya katô ami. Ba intu onaŋ abô lokbaŋ êntêk. ");
INSERT INTO hot_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ŋê ŋama iviyô hathak loŋbô, ma anyô lo avi tem miŋ neja i esak loŋbô ami ma mi. Thêlô tem nêmô êtôm aŋela malak leŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Môlô onaŋ nena ŋê ŋama tem miŋ nimbiyô esak loŋbô ami. Ma doŋtom môlô bôk osam Mose anêŋ kapya lôk kukuthiŋ atum hathaŋ hamô aliŋ e? Wak êŋ ma Wapômbêŋ hanaŋ hadêŋ Mose aêntêk, ‘Ya ma Ablaham lo Aisak ma Jekop iniŋ Wapômbêŋ.’ ");
INSERT INTO hot_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wapômbêŋ ma miŋ ŋê ŋama iniŋ Wapômbêŋ ami. Mi, yani ma ŋê lôkmala iyom iniŋ Wapômbêŋ. Ba intu yêlô ayala nena thêlô bôk ema, ma doŋtom lêk êmô lôkmala. Môlônim abô ma lokbaŋ anôŋ!” ");
INSERT INTO hot_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ŋê lôkauk hathak abô balabuŋ te hayô ma halaŋô Yisu lo Sadyusi êkôki. Ma halaŋô Yisu hanaŋ thêlôniŋ abô viyaiŋ mavi anôŋ. Aêŋ ba yani hanaŋ hik Yisu liŋ, “Balabuŋ alisê intu bêŋ ek balabuŋ vi?” ");
INSERT INTO hot_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Êŋ ma Yisu hanaŋ nena, “Balabuŋ môŋ hanaŋ nena, ‘Môlô Islael nodaŋô katô. Anyô Bêŋ alalôaniŋ Wapômbêŋ, yani iyom intu Anyô Bêŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lemimimbiŋ Anyô Bêŋ unim Wapômbêŋ ênjêk unim kapôlômim lôk dahôlômim ma lôklokwaŋ lôk unim auk sapêŋ.’ ");
INSERT INTO hot_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma balabuŋ yaŋ ma aêntêk: ‘Lemimbiŋ avômalô vi êtôm lemhaviŋ oda.’ Balabuŋ vi ma êmô balabuŋ bêŋ ju êntêk kapô.” ");
INSERT INTO hot_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ma anyô lôkauk hathak abô balabuŋ hanaŋ hadêŋ Yisu, “Kêdôŋwaga, honaŋ abô mavi anôŋ. Anêm abô ma avanôŋ biŋ nena Anyô Bêŋ iyom intu Wapômbêŋ ma miŋ wapômbêŋ la yaŋ hamô doho haviŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Alalô leŋiŋimbiŋ yani avanôŋ ênjêk alalôaniŋ kapôlôŋiŋ lôk auk ma lôklokwaŋ sapêŋ. Lôk leŋiŋimbiŋ avômalô vi êtôm alalô leŋiŋhaviŋ alalôda. Abô balabuŋ ju êŋ ma bêŋ ek da nômbêŋ atu ba êbôk hathak atum.” ");
INSERT INTO hot_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yisu halaŋô ôpêŋ hanaŋ viyaŋ lôkauk mavi ba intu hanaŋ hadêŋ ôpêŋ, “Miŋ hômô daim ek Wapômbêŋ anêŋ loŋ lôkliŋyak ami. Mi.” Ma avômalô sapêŋ elaŋô anêŋ abô ba êkô ma miŋ enaŋ hik yani liŋ ek nesau yani esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ma Yisu hadôŋ avômalô hamô unyak matheŋ anêŋ piklêvôŋ ma hanaŋ, “Ŋê lôkauk hathak abô balabuŋ ethak enaŋ nena Mesia ma Devit anêŋ lim lukmuk eka? ");
INSERT INTO hot_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lovak Matheŋ hêv auk hadêŋ Devit da ba hanaŋ, “‘Anyô Bêŋ Wapômbêŋ hanaŋ hadêŋ yenaŋ Anyô Bêŋ Mesia nena, “Ômô yabaheŋ vianôŋ endeba yatak ŋê takatu ba ik vovak hadêŋ o nêmô vemkapô vibiŋ am.” ’ ");
INSERT INTO hot_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ma Devit da bôk halam Mesia nena anêŋ Anyô Bêŋ. Ma aisê ka Mesia ma yani anêŋ lim lôk anêŋ Anyô Bêŋ imbiŋ?” Avômalô elaŋô Yisu anêŋ abô êŋ ba leŋiŋmavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yisu hadôŋ thêlô ba hanaŋ, “Môlô noyabiŋ am ek ŋê lôkauk hathak abô balabuŋ. Thêlô leŋiŋhaviŋ nijik kwêv daim kêkêlô ba nembeŋ ek avômalô nebam i. Lôk leŋiŋhaviŋ avômalô bêŋ anôŋ nenaŋ, ‘Waklêvôŋ anyô bêŋ’ embeŋ loŋ ethak doŋtom halôk. ");
INSERT INTO hot_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma leŋiŋhaviŋ nêmô êtôm ŋê bêŋbêŋ êmô unyak yeŋ kapô. Ma avômalô eŋgabôm nôm bêŋ, ma leŋiŋhaviŋ nejaŋ nôm êmô ŋê bêŋbêŋ iniŋ loŋ ethak êmô. ");
INSERT INTO hot_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Thêlô ethak esau avi tôp ba ewa iniŋ unyak vani lôk eteŋ mek daim bêŋ ek avômalô leŋiŋimbi nena thêlô ma ŋê thêthôŋ anôŋ. Ŋê anêŋ aêŋ ma tem nêpôm vovaŋ bêŋ êndêŋ waklavôŋ idum abô.” ");
INSERT INTO hot_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisu hi halôk hamô habobo unyak matheŋ anêŋ alapa da ma hayê avômalô lubuŋlubuŋ i ibi iniŋ da. Ma ŋê lôk valu bêŋ ekaliv valu bêŋ anôŋ halôk alapa da. ");
INSERT INTO hot_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ma avi tôp te atu ba nômkama mi anôŋ hayô ma hatak anêŋ da hatôm valuseleŋ thalaleŋ ju iyom halôk alapa da êŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma Yisu halam anêŋ ŋê ku êlêm ma hanaŋ, “Yanaŋ avanôŋ êndêŋ môlô nena avi tôp êntêk hêv valuseleŋ bêŋ anôŋ hamôŋ ek takêntêk sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Avômalô nômbêŋ êntêk iniŋ valu bêŋ anôŋ hamô ma doŋtom êv doktena iyom. Ma avi tôp êntêk ma nômkama mi anôŋ ma lêk hêv anêŋ valuseleŋ sapêŋ ba miŋ havaloŋ dokte loŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisu hatak unyak matheŋ ba hale yaiŋ ma anêŋ ŋê ku te hanaŋ hadêŋ yani, “Kêdôŋwaga, nôŋgô unyak matheŋ anêŋ lêlêyaŋ ma kêkêlô bomaŋ lôk anêŋ valu bêŋbêŋ!” ");
INSERT INTO hot_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Yisu hanaŋ nena, “Hôyê unyak bêŋbêŋ takêntêk e? Malaiŋ bêŋ tem imbitak ba ŋê vovak tem nijik nômkama mavi nômbêŋ êntêk pesa ba valu yaŋ miŋ hatôm êyômô yaŋ loŋ ami.” ");
INSERT INTO hot_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Vêm ma Yisu hamô Dum Oliv ma hayê unyak matheŋ hamô vi tuvulu. Ma Pita lo Jems ma Jon lo Andulu thêlô iyom i enaŋ hik yani liŋ, ");
INSERT INTO hot_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Onaŋ êndêŋ yêlô nena aŋgê intu nôm takêŋ tem imbitak? Lôk malê intu tem imbitak ek injik thô nena nômbêŋ êŋ lêk habobo?” ");
INSERT INTO hot_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Ma Yisu hanaŋ hadêŋ thêlô, “Ŋê lomaloma tem nêlêm esak yenaŋ athêŋ ba nenaŋ nena, ‘Ya ma Mesia atu.’ Ma tem nesau avômalô bêŋ anôŋ. Ba intu noyabiŋ am. ");
INSERT INTO hot_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma môlô olaŋô abô hathak vovak lomaloma lôk vovak tem imbitak pik luvuluvu. Nôm takêŋ tem imbitak, ma doŋtom pik lo leŋ anêŋ daŋ ma mi denaŋ. Ba intu miŋ nodowaliŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ma avômalô ôdôŋ yaŋ tem nijik vovak imbiŋ ôdôŋ yaŋ. Ma kiŋ yaŋ lôk anêŋ avômalô tem nijik vovak êndêŋ kiŋ yaŋ. Ma loŋ lomaloma ma tem duviaŋ lôk bôm bêŋ imbitak. Nôm takêŋ ma hatôm vovaŋ môŋ atu ba hapôm avi lôk lasabeŋ ek embathu. ");
INSERT INTO hot_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Aêŋ ba noyabiŋ am. Tem nebaloŋ môlô ba netak êndôk ŋê elaŋô abô baheŋiŋ. Lôk nebali môlô êmô unyak yeŋ. Hathak yenaŋ athêŋ ma tem numiŋ ŋê bêŋbêŋ lôk kiŋ maleŋiŋ ek nonaŋ yenaŋ abô bêŋ êndêŋ i. ");
INSERT INTO hot_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Avômalô pik sapêŋ tem nedaŋô yenaŋ Abô Mavi vêmam ka nôm takêŋ tem imbitak embeŋ yam. ");
INSERT INTO hot_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Thêlô ekak môlô loŋ ma ewa ba i ek nundum abô, êŋ ma miŋ nôkô ba nonaŋ nena, ‘Yêlô tem nanaŋ malê?’ Mi. Waklavôŋ êŋ ma nonaŋ auk takatu ba êv hadêŋ môlô iyom. Auk takêŋ ma Lovak Matheŋ da hanaŋ ma miŋ môlôda onaŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ma anyô loyaŋ tem yaŋ enaŋ yaŋ bêŋ ek nijik vônô. Ma lambô tem indum aêŋ êndêŋ nakaduŋ. Ma avômena tem nêmbôliŋ dômiŋ êndêŋ lami lo taluvi ba nenaŋ ek nijik i vônô. ");
INSERT INTO hot_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Môlô ma yenaŋ avômalô. Ba intu avômalô sapêŋ tem nêpôlik esak môlô. Ma doŋtom ŋê takatu ba imiŋ lôklokwaŋ aleba hayô anêŋ daŋ, ma Wapômbêŋ tem nêm i bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nôm kambom anôŋ te tem imiŋ loŋ matheŋ anôŋ ba loŋ êŋ ma miŋ hatôm imiŋ ami. (Aêŋ ba môlô takatu ba osam abô êntêk, ma lemimimbi katô am.) Ma môlô takatu ba ômô Judia ôyê nôm êŋ ma nôsôv ketheŋ ba unu dumlolê. ");
INSERT INTO hot_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma ŋê takatu ba êmô unyak vôv miŋ hatôm nêndôk ba ini unyak kapô ek neja iniŋ nômkama ami. ");
INSERT INTO hot_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma ŋê takatu ba êmô ku kapô miŋ hatôm nendeni unyak ek neja iniŋ kwêv thilibuŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ai, kikaknena. Waklavôŋ êŋ ma tem malaiŋ bêŋ ek avi takatu ba esabeŋ lôk avi takatu ba êv sôm hadêŋ nali. ");
INSERT INTO hot_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Noteŋ mek ek malaiŋ takêŋ miŋ imbitak êndêŋ waklavôŋ beleŋ simbak ami. ");
INSERT INTO hot_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ek malê nena waklavôŋ êŋ ma tem malaiŋ bomaŋ anôŋ ba êmôŋ ek malaiŋ tak sêbôk atu ba Wapômbêŋ hapesaŋ pik aleba lêk. Ma tem miŋ imbitak aêŋ esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma Anyô Bêŋ miŋ hadabêŋ waklavôŋ malaiŋ takêŋ kisi ami, êŋ ma avômalô sapêŋ tem nema. Ma doŋtom yani lahabi avômalô takatu ba bôk halam i yôv ba intu hadabêŋ waklavôŋ êŋ hi bidoŋ. ");
INSERT INTO hot_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Waklavôŋ êŋ ma anyôla hanaŋ hadêŋ môlô nena, ‘Ôŋgô, Mesia hamô loŋ êntêk’ mena ‘hamô loŋ tamu,’ ma miŋ nônêmimbiŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Anyô doho tem nêlêm ba nenaŋ abôyaŋ aêntêk, ‘Ya ma Mesia’ mena ‘Ya ma Wapômbêŋ anêŋ plopet te’, ma nindum lavôŋiŋ lôk nômbithi ek nesau avômalô takatu ba bôk Wapômbêŋ halam i yôv haviŋ. Ma doŋtom Wapômbêŋ bôk halam i yôv ba intu miŋ hatôm ami. ");
INSERT INTO hot_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Odaŋô! Nôm takêntêk miŋ lêk habitak ami denaŋ ma yahanaŋ nôm takêŋ bêŋ hadêŋ môlô ek môlô noyabiŋ am. ");
INSERT INTO hot_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Malaiŋ takêŋ hale halôk vêm, “‘ma wak tem imbitak momaŋiniŋ, ma ayôŋ tem miŋ imbi deda ami; ");
INSERT INTO hot_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ma vuliŋ leŋ tem nênêm yak ma nôm takatu ba hamô leŋ tem nedowaliŋ.’ ");
INSERT INTO hot_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ma wak êŋ ma avômalô tem nêgê Anyô Anêŋ Nakaduŋ atu tem êyô êmô buliv ba êlêm imbiŋ anêŋ lôkliŋyak lôk anêŋ deda lôkmaŋgiŋ. ");
INSERT INTO hot_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yani tem nêm anêŋ aŋela ba ini pik anêŋ daŋ sapêŋ ek nisup avômalô takatu ba bôk halam i yôv. ");
INSERT INTO hot_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ba intu môlô noja auk esak alokwaŋ beleŋ. Hayeŋ ba ŋauŋ lukmuk habitak, êŋ ma oyala nena tem wak mavi êyô. ");
INSERT INTO hot_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ma aêŋ iyom, môlô ôyê nôm takêntêk habitak, êŋ ma noyala nena Anyô Anêŋ Nakaduŋ atu anêŋ waklavôŋ endelêm lêk habobo ba hamiŋ unyak abôlêk. ");
INSERT INTO hot_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yanaŋ avanôŋ êndêŋ môlô nena avômalô bôlôŋ êntêk tem miŋ nema ami denaŋ ma nôm takêntêk sapêŋ tem imbitak. ");
INSERT INTO hot_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Pik lôk leŋ tem nêm yak ba ni, ma doŋtom yenaŋ abô bute miŋ hatôm nêm yak ami. ");
INSERT INTO hot_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Anyô te miŋ hayala Yisu anêŋ waklavôŋ endelêm ami. Aŋela leŋ miŋ eyala ami, ma Nakaduŋ miŋ hayala haviŋ ami. Ma Kamik iyom intu hayala. ");
INSERT INTO hot_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aêŋ ba noyabiŋ am ba nônêm lêlê! Môlô miŋ oyala waklavôŋ atu ba nôm êŋ tem imbitak ami. ");
INSERT INTO hot_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nôm êŋ ma hatôm anyô hatak anêŋ unyak ba hi loŋ buyaŋ. Yani hi ma hanaŋ hadêŋ anêŋ ŋê ku ek neyabiŋ anêŋ nômkama. Ma hik ku sam tomtom hatôm thêlô. Ma hanaŋ hadêŋ anyô hayabiŋ malak abôlêk nena eyabiŋ dedauŋ mavi. ");
INSERT INTO hot_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Môlô miŋ oyala waklavôŋ atu ba unyak alaŋ tem endelêm esak loŋbô ami. Tem êlêm êndêŋ yaŋsiŋ mena bôlôvôŋ biŋ mena wakma tale halaŋ mena hayaŋ wak bêŋ la. ");
INSERT INTO hot_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yakô ek êlêm ketheŋ ma ênjê nena môlô ôêk sôm denaŋ. ");
INSERT INTO hot_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma abô êntêk ba yahanaŋ hadêŋ môlô, ma lêk yahanaŋ hadêŋ avômalô sapêŋ haviŋ nena, ‘Noyabiŋ am!’” ");
INSERT INTO hot_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wak lokwaŋju hêk denaŋ ek waklavôŋ nôm bêŋ ju, yaŋ ma Hale ba Hi ma yaŋ ma Eyaŋ Polom Yis Mi. Ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ idum ek nesau Yisu ba nebaloŋ ek nijik yani vônô. ");
INSERT INTO hot_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ba enaŋ, “Lêk ma waklavôŋ matheŋ ba intu natak ku êŋ ênjêk vêmam. Yakô avômalô tem leŋiŋmaniŋ ba nijik vovak.” ");
INSERT INTO hot_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wak êŋ ma Yisu hamô Saimon anêŋ unyak anêŋ Betani. Sêbôk ma ôpêŋ hapôm palê lepla ma doŋtom bôk mi. Yisu hamô balê eyaŋ nôm hamô ma avi te halêm ma hawa kolopak valu te ba thapuk ma nôm ôv mavi hamô kapô ba anêŋ vuli ma bêŋ anôŋ. Ma hik kolopak êŋ wakadôk lu ma haŋgasô nôm ôv mavi êŋ hayô hamô Yisu wakadôk. ");
INSERT INTO hot_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma avômalô vi atu ba êmô loŋ êŋ haviŋ êyê ba leŋiŋmaniŋ ba enaŋ hadêŋ thêlôda, “Aisê ka habuliŋ nôm ôv mavi êŋ hi oyaŋ? ");
INSERT INTO hot_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hatôm nêm ek anyô yaŋ nêm vuli êtôm 300 seleva ek naja ba nanêm avômalô siv sa esak!” Êŋ ma leŋiŋmaniŋ ba ethaŋ avi êŋ. ");
INSERT INTO hot_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma doŋtom Yisu hanaŋ, “Aisê ka môlô ôêv malaiŋ hadêŋ avi êntêk? Notak yani. Yani hadum nôm mavi anôŋ hadêŋ ya. ");
INSERT INTO hot_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Avômalô siv tem nêmô imbiŋ môlô êtôm wak nômbêŋ intu sapêŋ, ba lemimhaviŋ nônêm i sa ma nônêm sa. Ma doŋtom tem miŋ yamô imbiŋ môlô sawa daim ami. ");
INSERT INTO hot_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nôm atu ba yani hatôm indum, ma lêk hadum yôv, ba haŋgasô nôm ôv mavi hayô hamô ya ba lêk hapôpêk ya yôv ek nedav. ");
INSERT INTO hot_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yanaŋ avanôŋ êndêŋ môlô nena pik nômbêŋ atu ba enaŋ yenaŋ Abô Mavi bêŋ haveŋ ma tem nenaŋ esak nôm atu ba avi êntêk lêk hadum imbiŋ ek avômalô leŋiŋimbi yani.” ");
INSERT INTO hot_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Êŋ ma Judas Iskaliot, Yisu anêŋ ŋê ku laumiŋ ba lahavuju takatu te, hi hadêŋ ŋê bêŋbêŋ êbôk da ek nêm Yisu êndôk thêlô baheŋiŋ. ");
INSERT INTO hot_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Thêlô elaŋô abô êŋ ma leŋiŋmavi anôŋ ba ibutiŋ abô ek nênêm valuseleŋ êndêŋ yani. Ba intu yani habôlêm loŋôndê ek enaŋ Yisu bêŋ. ");
INSERT INTO hot_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Waklavôŋ anêŋ athêŋ nena Eyaŋ Polom Yis Mi anêŋ wak te môŋ hayô. Wak êŋ ma ethak ik boksipsip nakaduŋ te ek leŋiŋhabi waklavôŋ Hale ba Hi. Ma Yisu anêŋ ŋê ku enaŋ hik yani liŋ, “Lemhaviŋ yêlô ana unyak alê ek napôpêk nôm leŋiŋimbi waklavôŋ Hale ba Hi êndôk?” ");
INSERT INTO hot_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma Yisu hêv anêŋ ŋê ku ju ba i ma hanaŋ, “Mamu unu malak bêŋ kapô ma tem nôpôm anyô te ba hawa ŋaŋ lôk kolopak bêŋ te halôk loŋôndê, ma nosopa yani ba unu. ");
INSERT INTO hot_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma habitak hayô unyak kapô te ba hi, ma nonaŋ êndêŋ unyak êŋ anêŋ alaŋ nena, ‘Kêdôŋwaga hanaŋ nena, “Yenaŋ unyak kapô atu ba yaŋgaŋ nôm waklavôŋ Hale ba Hi imbiŋ yenaŋ ŋê ku hamô êsê?” ’ ");
INSERT INTO hot_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Êŋ ma tem injik unyak kapô bêŋ atu ba hêk vuliŋ thô êndêŋ mamu. Unyak kapô êŋ ma nômkama sapêŋ bôk hamô yôv. Ba intu nôpôpêk alalôaniŋ nôm êmô loŋ êŋ.” ");
INSERT INTO hot_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Êŋ ma ŋê ku ju atu i êyô malak lôŋ êŋ kapô. Ma êpôm nômkama sapêŋ hatôm atu ba yani hanaŋ. Ma êpôpêk nôm waklavôŋ Hale ba Hi ek thêlô. ");
INSERT INTO hot_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yaŋsiŋ habôk ma Yisu lôk anêŋ ŋê ku laumiŋ ba lahavuju i êyô loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Thêlô eyaŋ nôm êmô ma Yisu hanaŋ, “Yanaŋ avanôŋ êndêŋ môlô nena môlô te tem enaŋ ya bêŋ. Ôpêŋ lêk hayaŋ nôm haviŋ ya.” ");
INSERT INTO hot_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma thêlô leŋiŋmalaiŋ ba tomtom enaŋ hadêŋ yani nena, “Ya mi, aêŋ e?” ");
INSERT INTO hot_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma Yisu hanaŋ hadêŋ thêlô, “Môlô laumiŋ ba lahavuju takatu te. Ôpêŋ intu hasoŋ baŋ halôk belev haviŋ ya. ");
INSERT INTO hot_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Anyô Anêŋ Nakaduŋ atu tem ni êtôm atu ba bôk eto yôv hathak yani. Ma doŋtom alikakna. Malaiŋ bêŋ ek ôpatu ba hanaŋ Anyô Anêŋ Nakaduŋ bêŋ. Talêbô miŋ bôk havathu ami, êŋ ma mavi ek ôpêŋ!” ");
INSERT INTO hot_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Thêlô eyaŋ nôm hamô ma Yisu hawa polom te ma hêv lamavi. Vêm ma haya ba hêv hadêŋ anêŋ ŋê ku ma hanaŋ, “Noja ba oŋgwaŋ. Êntêk ma yenaŋ vathiap.” ");
INSERT INTO hot_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Vêm ma hawa tase lôk waiŋ ma hêv lamavi. Ma hêv hadêŋ thêlô ba sapêŋ inum. ");
INSERT INTO hot_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma hanaŋ hadêŋ thêlô, “Êntêk ma yenaŋ thalaleŋ atu ba tem eŋgasô ek embak tabô imbiŋ Wapômbêŋ lôk avômalô pik ek nêm avômalô bêŋ anôŋ sa. ");
INSERT INTO hot_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yanaŋ avanôŋ êndêŋ môlô nena tem miŋ hatôm yanum waiŋ esak loŋbô ami endeba waklavôŋ êŋ hayô ma tem yanum waiŋ lukmuk êmô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô.” ");
INSERT INTO hot_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Vêm ma êv yeŋ te yôv ma ethak ba i Dum Oliv. ");
INSERT INTO hot_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ma Yisu hanaŋ hadêŋ thêlô, “Bôk eto hêk Wapômbêŋ anêŋ kapya nena, “‘Tem yaŋgik boksipsip alaŋ vônô, ma boksipsip tem nêsôv mayaliv ba ini.’ Ba intu môlô sapêŋ tem notak ya ma nôsôv mayaliv ba unu. ");
INSERT INTO hot_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma doŋtom hik ya liŋ hathak loŋbô, ma tem yamôŋ ba yana Galili vêm ka môlô nombeŋ ya yam.” ");
INSERT INTO hot_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma Pita hanaŋ nena, “Dô! Thêlô sapêŋ etak o ba i, ma tem yamiŋ imbiŋ o denaŋ.” ");
INSERT INTO hot_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma Yisu hanaŋ, “Yanaŋ avanôŋ biŋ êndêŋ o nena bôlôvôŋ êntêk ma tale miŋ halaŋ bôlôŋ ju ami denaŋ, ma tem onaŋ êtôm bôlôŋ lô nena hôthôŋ ya paliŋ.” ");
INSERT INTO hot_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma doŋtom Pita hanaŋ lôklokwaŋ nena, “Mi anôŋ! Ik ya vônô, ma miŋ hatôm yanaŋ nena yahathôŋ o paliŋ ami. Milôk!” Ma ŋê ku sapêŋ enaŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Vêm ma thêlô êyô loŋ atu ba elam nena Getsemani ma hanaŋ hadêŋ anêŋ ŋê ku, “Môlô nômô loŋ êntêk ma yana ek yateŋ mek.” ");
INSERT INTO hot_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ma hawa Pita lo Jems ma Jon haviŋ yani. Ma yani kapô halêlêk lôk lamalaiŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma hanaŋ hadêŋ thêlô nena, “Yakapôlôŋ lêk malaiŋ bomaŋ hatôm lêk yahama yôv. Môlô nômô loŋ êntêk ma nônêm lêlê.” ");
INSERT INTO hot_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma hi daim dokte ma hêv yak halôk pik ma hateŋ mek nena loŋôndê la hêk ek yani ma nêm malaiŋ lôk vovaŋ êntêk vê. ");
INSERT INTO hot_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma hanaŋ, “O Aba Wakamik, o hatôm undum nômkama sapêŋ. Aêŋ ba nêm tase êntêk vê ênjêk ya. Ma doŋtom miŋ osopa yenaŋ yaleŋhaviŋ ami. Mi, osopa oda anêm lemhaviŋ.” ");
INSERT INTO hot_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ma Yisu hale hi ma hayê anêŋ ŋê ku lêk êk sôm. Ma hanaŋ hadêŋ Pita, “Saimon, hôêk sôm e? O miŋ hatôm ômô lêlê wakma te ami e? ");
INSERT INTO hot_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nômô lêlê ba noteŋ mek ek miŋ nônêm yak ba nundum kambom ami. Kapô lahaviŋ indum mavi ma doŋtom auk ma pulusikna ba miŋ hatôm indum ami.” ");
INSERT INTO hot_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Vêm ma havôhi ma hateŋ mek bô atu hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ma halehi hathak loŋbô ma hayê thêlô êk sôm denaŋ ek malê nena maleŋiŋ hayaŋ ba miŋ hatôm nêmô lêlê ami. Ba intu êthôŋ nena nenaŋ malê êndêŋ yani. ");
INSERT INTO hot_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Vêm ma halehi bôlôŋ te lô ma hanaŋ hadêŋ thêlô, “Môlô ôêk sôm ba owa lovak denaŋ e? Hatôm! Odaŋô, wakma lêk hayô yôv ek netak ya Anyô Anêŋ Nakaduŋ atu êndôk ŋê kambom baheŋiŋ. ");
INSERT INTO hot_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aêŋ ba numbiyô ek alôana. Ôŋgô! Ôpatu ba tem enaŋ ya bêŋ lêk halêm yôv.” ");
INSERT INTO hot_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisu hanaŋ abô denaŋ ma Judas hayô. Yani ma ŋê ku laumiŋ ba lahavuju takatu te. Ma avômalô bêŋ anôŋ êlêm iviŋ yani ba ewa biŋ vovak lôk okdiba. Ŋê takêŋ ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ lôk ŋê bêŋbêŋ vi êv thêlô ba êlêm. ");
INSERT INTO hot_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ôpatu ba tem enaŋ Yisu bêŋ bôk hik lavôŋiŋ te thô hadêŋ i nena, “Ôpatu ba yahaliŋu, êŋ ma Yisu. Ba intu nobaloŋ loŋ ma noja ba unu.” ");
INSERT INTO hot_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ma ôpêŋ hi ketheŋ hadêŋ Yisu ma hanaŋ, “Kêdôŋwaga.” Ma haliŋu yani. ");
INSERT INTO hot_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma ŋê takatu ba i haviŋ Judas evaloŋ Yisu ba ewa ba i. ");
INSERT INTO hot_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma ŋê takatu ba imiŋ habobo te hadadi anêŋ biŋ vovak ma hale anyô bêŋ habôk da anêŋ anyô ku te limbuk vi vê. ");
INSERT INTO hot_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Êŋ ma Yisu hanaŋ hadêŋ thêlô nena, “Ya ma anyô kambom anôŋ ba intu owa biŋ vovak lôk okdiba ba ôlêm ek nobaloŋ ya e? ");
INSERT INTO hot_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aisê? Wak nômbêŋ intu ma yahamô unyak matheŋ anêŋ piklêvôŋ ba yahadôŋ môlô ma miŋ ovaloŋ ya ami eka? Ma doŋtom lêk nôm takêŋ habitak ek Wapômbêŋ anêŋ abô injik anôŋ.” ");
INSERT INTO hot_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Êŋ ma anêŋ ŋê ku sapêŋ etak yani ma êsôv mayaliv ba i. ");
INSERT INTO hot_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma anyô muk te hasopa Yisu haveŋ yam ba havuliv liŋkupik hathak sôp mavi te iyom. Ma idum ek nebaloŋ yani, ");
INSERT INTO hot_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ma doŋtom evaloŋ sôp oyaŋ ma hasôv liŋpopam ba hi. ");
INSERT INTO hot_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ma thêlô ewa Yisu ba i hadêŋ anyô bêŋ habôk da. Ma ŋê bêŋbêŋ êbôk da sapêŋ lôk ŋê bêŋbêŋ sapêŋ lôk ŋê lôkauk hathak abô balabuŋ sapêŋ ethak doŋtom. ");
INSERT INTO hot_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma Pita hasopa Yisu haveŋ yam ma doŋtom haveŋ daim dokte. Ma habitak hayô anyô bêŋ habôk da anêŋ badêŋ kapô. Ma hi hamô haviŋ sôp bidoŋ ba havuŋu atum haviŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ma ŋê bêŋbêŋ êbôk da lôk Sanhedlin sapêŋ êbôlêm avômalô doho ek nenaŋ Yisu anêŋ kambom takatu ba hadum bêŋ ek thêlô nindum abô esak ek nijik yani vônô. Ma doŋtom miŋ êpôm Yisu anêŋ kambom te ek nijik yani vônô ami. ");
INSERT INTO hot_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Avômalô bêŋ anôŋ enaŋ abôyaŋ hathak Yisu, ma doŋtom iniŋ abô takatu ba enaŋ ma miŋ hatôm doŋtom ami. ");
INSERT INTO hot_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma doho iviyô imiŋ ma enaŋ abôyaŋ hathak Yisu aêntêk, ");
INSERT INTO hot_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yêlô alaŋô yani hanaŋ nena, ‘Tem yandiniŋ unyak matheŋ êntêk ba anyô elav hathak baheŋiŋ. Ma êtôm wak lô iyom ma tem yandav lukmuk yaŋ atu ba miŋ elav hathak baheŋiŋ ami.’” ");
INSERT INTO hot_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma doŋtom iniŋ abô takatu ba enaŋ hi mayaliv ma miŋ enaŋ abô doŋtom ami. ");
INSERT INTO hot_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Êŋ ma anyô bêŋ habôk da haviyô hamiŋ thêlô maleŋiŋ ma hanaŋ hik Yisu liŋ nena, “Ŋê takêntêk lêk enaŋ o bêŋ yôv ma o bônôŋ eka? O abô mi e?” ");
INSERT INTO hot_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma doŋtom Yisu bônôŋ iyom ma miŋ hanaŋ abôla ami. Ma anyô bêŋ habôk da hanaŋ hik Yisu liŋ hathak loŋbô nena, “O ma Mesia, Anyô Bêŋ Matheŋ atu anêŋ Nakaduŋ e?” ");
INSERT INTO hot_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma Yisu hanaŋ nena, “Ya êŋ êntêk. Ma tem ôŋgô Anyô Anêŋ Nakaduŋ atu tem êmô Wapômbêŋ Lôkliŋyak Anôŋ baŋ vianôŋ ba tem êyô êmô buliv ba êlêm.” ");
INSERT INTO hot_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma anyô bêŋ habôk da halaŋô abô êŋ ma hakakaviŋ anêŋ kwêv ma hanaŋ, “Lêk yôv. Aisê ka alalô leŋiŋhaviŋ nadaŋô abô doho imbiŋ? ");
INSERT INTO hot_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Lêk alaŋô yôv nena habuliŋ Wapômbêŋ anêŋ athêŋ ba hanaŋ nena yanida ma hatôm Wapômbêŋ. Ba intu lemimhabi aisê?” Ma thêlô sapêŋ enaŋ nena, “Hadum kambom ba intu ema.” ");
INSERT INTO hot_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Vêm ma doho êsôvwapôk hathak yani. Ma vi ivuliv ma siŋ hathak sôp ma êpêŋ yani ba enaŋ nena, “O plopet te ma onaŋ nena opalê intu hik o?” Ma sôp bidoŋ evaloŋ yani ba ik haviŋ. ");
INSERT INTO hot_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita hamô tamu unyak atu anêŋ badêŋ kapô, ma anyô bêŋ habôk da anêŋ avi ku te halêm. ");
INSERT INTO hot_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma hayê Pita havuŋu atum hamô. Ma hatitiŋ yani ba hanaŋ, “O êntêk intu bôk hoveŋ haviŋ Yisu, anyô Nasalet atu.” ");
INSERT INTO hot_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Êŋ ma Pita hanaŋ, “Mi, yahathôŋ abô intu ba honaŋ paliŋ.” Ma hale ba hi habobo badêŋ abôlêk. Ma tale te halaŋ. ");
INSERT INTO hot_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma avi ku atu hayê Pita hathak loŋbô ma hanaŋ hadêŋ anyô takatu ba imiŋ habobo yani aêntêk, “Ôpêntêk ma ŋê takatu iniŋ anyô te.” ");
INSERT INTO hot_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma doŋtom yani hanaŋ hathak loŋbô, “Mi.” Vêm ma ŋê takatu ba imiŋ habobo yani enaŋ hadêŋ Pita hathak loŋbô, “Avanôŋ biŋ nena o ma anyô Galili te ba intu o ma anêŋ anyô te.” ");
INSERT INTO hot_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma doŋtom Pita hanaŋ nena, “Ya miŋ yahanaŋ abô avanôŋ ami, êŋ ma tem Wapômbêŋ nêm vovaŋ êndêŋ ya. Yahalam Wapômbêŋ anêŋ athêŋ ba yahanaŋ nena yahathôŋ ôpêntu ba onaŋ abô hathak paliŋ.” ");
INSERT INTO hot_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ketheŋ oyaŋ ma tale halaŋ bôlôŋ yaŋ, êŋ ma Pita lahabi abô atu ba Yisu hanaŋ hadêŋ yani nena, “Tale miŋ halaŋ bôlôŋ ju ami denaŋ, ma tem onaŋ êtôm bôlôŋ lô nena hôthôŋ ya paliŋ.” Êŋ ma Pita hakôm ba halaŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Lôkbôk momaŋiniŋ ma Sanhedlin sapêŋ ethak doŋtom. Thêlô ma ŋê bêŋbêŋ êbôk da lôk avômalô iniŋ ŋê bêŋbêŋ lôk ŋê lôkauk hathak abô balabuŋ. Ma ibutiŋ abô hathak doŋtom vêm ma ekak baŋ luvi lusu ma ewa ba i hadêŋ Pailat. ");
INSERT INTO hot_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma Pailat hanaŋ hik Yisu liŋ aêntêk, “O ma avômalô Islael iniŋ kiŋ e?” Ma Yisu hanaŋ nena, “Intu êŋ, hatôm intu honaŋ.” ");
INSERT INTO hot_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ma ŋê bêŋbêŋ êbôk da ibi Yisu liŋkupik hathak abô lomaloma. ");
INSERT INTO hot_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma Pailat hanaŋ hadêŋ Yisu hathak loŋbô, “O abô mi e? Thêlô ibi lemvimkupik hathak abô lomaloma.” ");
INSERT INTO hot_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma doŋtom Yisu bônôŋ iyom. Ba intu Pailat hasoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Waklavôŋ Hale ba Hi nômbêŋ intu, ma avômalô ethak elam anyô koladôŋ te anêŋ athêŋ ek Pailat nêm vê. Ma Pailat hathak hêv ôpêŋ vê. ");
INSERT INTO hot_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sondabêŋ êŋ ma anyô te anêŋ athêŋ nena Balabas hamô koladôŋ. Yani hamô koladôŋ haviŋ ŋê takatu ba thêlô ik vovak hadêŋ Lom ba ik anyô doho vônô. ");
INSERT INTO hot_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Êŋ ma avômalô i hadêŋ Pailat ma elam ek nêm anyô koladôŋ te vê êtôm hathak hadum lôbôlôŋ. ");
INSERT INTO hot_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma Pailat hanaŋ hadêŋ thêlô nena, “Lemimhaviŋ yatak môlô avômalô Islael unim kiŋ êntêk e?” ");
INSERT INTO hot_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat hayala nena ŋê bêŋbêŋ êbôk da leŋiŋdaŋ hathak Yisu ba intu idum abô ek yani ba hanaŋ aêŋ. ");
INSERT INTO hot_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma doŋtom ŋê bêŋbêŋ êbôk da ik avômalô kapôlôŋiŋ liŋ ek nendam nena netak Balabas ba ni ma nebaloŋ Yisu loŋ. ");
INSERT INTO hot_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma Pailat hanaŋ hik thêlô liŋ hathak loŋbô nena, “Yandum malê êndêŋ ôpatu ba môlô olam nena Islael iniŋ kiŋ?” ");
INSERT INTO hot_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma sapêŋ elam nena, “Nijik vônô esak a!” ");
INSERT INTO hot_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma Pailat hanaŋ, “Eka? Yani hadum malê kambom?” Ma doŋtom thêlô elam lôklala hathak loŋbô nena, “Nijik vônô esak a!” ");
INSERT INTO hot_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma Pailat lahaviŋ nêm leŋiŋmavi êndêŋ avômalô nômbêŋ atu ba intu hatak Balabas ba hi. Ma hanaŋ ek nebali Yisu esak yak lôkmaŋgiŋ vêm ma hatak halôk ŋê vovak baheŋiŋ ek nijik vônô esak a. ");
INSERT INTO hot_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Vêm ma ŋê vovak ewa Yisu ba i Pailat anêŋ unyak badêŋ kapô. Ma elam ŋê vovak sapêŋ ba êlêm ethak doŋtom. ");
INSERT INTO hot_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma ewa kiŋ anêŋ kwêv thalaleŋ daim te ma ik hathak Yisu ma ewa yak lôkmaŋgiŋ atu ba epesaŋ hatôm kiŋ iniŋ kuluŋ ma ik halôk wakadôk. ");
INSERT INTO hot_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma iviyô ma êv baheŋ hathak leŋ ma enaŋ, “Waklêvôŋ mavi, avômalô Islael iniŋ kiŋ!” ");
INSERT INTO hot_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma ik wakadôk hathak alokwaŋ te lôbôlôŋ ma êsôvwapôk hathak yani. Vêm ma elek veŋiŋdôŋ lêlô hadêŋ yani lôk êbô anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma enaŋ abôma hathak yani vêm ma ibi kwêv thalaleŋ atu thô ma ik yanida anêŋ kwêv daim hathak loŋbô. Ma elom yani ba i ek nijik vônô esak a. ");
INSERT INTO hot_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma anyô te anêŋ athêŋ nena Saimon anêŋ Sailini halêm anêŋ buyaŋ ba hadum ek ni Jelusalem. Yani ma Aleksanda lo Lupus iniŋ lambô. Ma ŋê vovak êpôm yani ba êpôviŋ ek enja Yisu anêŋ alovalaŋaŋsiŋ. ");
INSERT INTO hot_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Êŋ ma ewa Yisu ba i loŋ te anêŋ athêŋ nena Golgota. Athêŋ êŋ anêŋ ôdôŋ nena Loŋ Leŋkadôk Lokwaŋ. ");
INSERT INTO hot_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma ewa waiŋ ba eyelaŋ haviŋ alokwaŋ te anêŋ thôk ba êv hadêŋ yani ek inum ek etauviŋ vovaŋ. Ma doŋtom hadô. ");
INSERT INTO hot_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Êŋ ma thêlô ik yani loŋ hathak a. Vêm ma ibi valu ek nêgê nena opalêla intu tem neja anêŋ kwêv lo sôp. ");
INSERT INTO hot_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wakma hatôm 9 kilok lôkbôk ma ik Yisu loŋ hathak a. ");
INSERT INTO hot_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Alovalaŋaŋsiŋ anêŋ vuliŋ ma eto abô atu ba enaŋ hathak Yisu aêntêk, AVÔMALÔ ISLAEL INIŊ KIŊ ");
INSERT INTO hot_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ma êthôkwêŋ anyô vani lokwaŋju haviŋ. Êthôkwêŋ yaŋ hamiŋ Yisu baŋ vianôŋ, ma yaŋ hamiŋ baŋ vikeŋ. ");
INSERT INTO hot_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma avômalô takatu ba elom loŋôndê êŋ ba i ibi abôma hathak yani lôk itutuniŋ leŋiŋkadôk ba enaŋ, “Ai! O atu ba honaŋ nena tem undiniŋ Wapômbêŋ anêŋ unyak matheŋ ma ondav esak loŋbô êtôm wak lô iyom e? ");
INSERT INTO hot_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Êŋ ma oda nêm oda bulubiŋ ba otak alovalaŋaŋsiŋ ma ôlêm pik!” ");
INSERT INTO hot_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ enaŋ abôma haviŋ. Ba enaŋ hadêŋ i nena, “Ôŋgô! Yani bôk hêv avômalô vi bulubiŋ, ma doŋtom miŋ hatôm nêm yanida bulubiŋ ami eka? ");
INSERT INTO hot_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yani ma Mesia, Islael iniŋ kiŋ e? Êŋ ma etak alovalaŋaŋsiŋ ba êlêm pik ek alalô nagê ba nanêmimbiŋ!” Ma anyô ju atu ba imiŋ alovalaŋaŋsiŋ haviŋ yani enaŋ abôma haviŋ. ");
INSERT INTO hot_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Waklêvôŋ biŋ ma momaŋiniŋ hayô pik sapêŋ vôv ba hêk aleba hayô 3 kilok. ");
INSERT INTO hot_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma 3 kilok ma Yisu halam lôklala aêntêk, “Eloi, Eloi, lama sabaktani?” Abô êŋ anêŋ ôdôŋ nena, “Yenaŋ Wapômbêŋ, yenaŋ Wapômbêŋ, aisê ka hôdô ya?” ");
INSERT INTO hot_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma avômalô vi atu ba imiŋ loŋ êŋ elaŋô abô êŋ ma enaŋ, “Odaŋô, yani halam Elia.” ");
INSERT INTO hot_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma anyô te hi bôlôŋ doŋtom ma hawa kapôk ba hasoŋ halôk waiŋ maniŋ. Ma hathôkwêŋ kapôk êŋ hathak apiyak te ba hêv hadêŋ Yisu ek inum. Ma ôpêŋ hanaŋ, “Dô! Alalô nagê vêmam. Yakô Elia tem êlêm enja yani vê ênjêk alovalaŋaŋsiŋ la?” ");
INSERT INTO hot_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma Yisu halam kaêk lôklala ma hama. ");
INSERT INTO hot_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma sôp bêŋ atu ba hamiŋ unyak matheŋ ek hayaŋ unyak kapô kisi ma hapup vose hi luvi hêk vuliŋ ba hayô vibiŋ. ");
INSERT INTO hot_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma anyô vovak laik atu ba hamiŋ habobo Yisu hayê kobom atu ba Yisu hama hathak, êŋ ma hanaŋ, “Avanôŋ biŋ, ôpêntêk ma Wapômbêŋ anêŋ Nakaduŋ anôŋ.” ");
INSERT INTO hot_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Avi doho imiŋ daim dokte ba êyê imiŋ. Thêlô êŋ te ma Malia anêŋ Magadala. Ma te ma Malia, Jems yaô lo Josep iniŋ talêbô. Ma te ma Salome. ");
INSERT INTO hot_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sêbôk ba Yisu hamô Galili ma avi takêŋ esopa yani ba êv yani sa. Ma avi bêŋ anôŋ êmô haviŋ ba iviŋ Yisu ba i Jelusalem. ");
INSERT INTO hot_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wak ik Yisu vônô, êŋ ma waklavôŋ avômalô ethak êpôpêk iniŋ nômkama ek Sabat. Ma wak êŋ anêŋ yaŋsiŋ bôlôvôŋ ma tem Sabat. ");
INSERT INTO hot_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ba intu wak hamiŋ denaŋ ma Josep anêŋ Alimatia hayô. Yani ma Sanhedlin iniŋ anyô bêŋ te. Yani hathak hêv ma ek Wapômbêŋ anêŋ loŋ lôkliŋyak atu tem êlêm. Ma miŋ hakô ami ma hi hadêŋ Pailat ma hanaŋ ek enja Yisu anêŋ kupik. ");
INSERT INTO hot_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma Pailat halaŋô nena Yisu lêk hama yôv ba hasoŋ kambom ma halam anyô vovak laik halêm. Ma hanaŋ hik ôpêŋ liŋ nena, “Yisu lêk hama yôv mena mi e?” ");
INSERT INTO hot_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma halaŋô anyô vovak laik anêŋ abô yôv ma halôk ek Josep enja anêŋ kupik. ");
INSERT INTO hot_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Êŋ ma Josep hêv sôp daim mavi te vuli ma hawa Yisu liŋkupik vê hêk alovalaŋaŋsiŋ ma havuliv siŋ hathak sôp atu. Ma hi hadô hêk siô valu abyaŋ atu ba elav ek nedav ŋê ŋama êndôk. Ma habubi valu bêŋ te ek hik siô abôlêk siŋ hathak. ");
INSERT INTO hot_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malia anêŋ Magadala lôk Malia, Josep anêŋ talêbô, imiŋ ma êyê loŋ atu ba etak Yisu anêŋ kupik hêk. ");
INSERT INTO hot_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat hale ba hi ma Malia anêŋ Magadala lôk Malia, Jems anêŋ talêbô, ma Salome êv vuli nôm ôv mavi ek neja ba ini ek netak esak Yisu kupik. ");
INSERT INTO hot_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ma sonda êŋ anêŋ wak te môŋ anêŋ lôkbôk momaŋiniŋ ma thêlô iviyô ba i siô. ");
INSERT INTO hot_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ma enaŋ hadêŋ i nena, “Opalê tem ibubi valu atu ba hamô lôv abôlêk vê ek alalô am?” ");
INSERT INTO hot_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Êyô siô ma êyê nena valu bêŋ atu ma lêk ibubi hi hamô daŋ. ");
INSERT INTO hot_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Thêlô ibitak êyô valu abyaŋ kapô ma êyê anyô muk lôk kwêv thapuk daim te hamô thêlô baheŋ vianôŋ. Thêlô êyê ma esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma doŋtom ôpêŋ hanaŋ, “Miŋ nosoŋ ami. Yahayala nena ôbôlêm Yisu anêŋ Nasalet atu ba ik hathak a. Yani lêk haviyô ba hi ma miŋ hêk loŋ êntêk ami. Ôŋgô loŋ atu ba êdô yani hêk êntêk. ");
INSERT INTO hot_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ma unu nonaŋ êndêŋ anêŋ ŋê ku lôk Pita nena, ‘Yani lêk hamôŋ ek môlô ba hi Galili. Ôyô loŋ êŋ ma tem nôpôm yani êtôm atu ba bôk hanaŋ yôv hadêŋ môlô.’” ");
INSERT INTO hot_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma avi takêŋ êkô ba elowaliŋ kambom ma etak siô ba êsôv ele yaiŋ ba i. Thêlô êkô ba bônôŋ iyom ma miŋ enaŋ abô êŋ hadêŋ anyôla ami. ");
INSERT INTO hot_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yisu haviyô hadêŋ sonda te anêŋ wak te môŋ. Ma hik i thô môŋ hadêŋ Malia Magadala, avi atu ba bôk Yisu hêv ŋgôk baheŋvi ba lahavuju vê hêk yani. ");
INSERT INTO hot_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Êŋ ma Malia hi hanaŋ hadêŋ ŋê takatu ba bôk eveŋ haviŋ yani. Ŋê takêŋ leŋiŋmalaiŋ ba elaŋ êmô. ");
INSERT INTO hot_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma elaŋô nena Yisu lêk hamô lôkmala ba Malia lêk hayê yani, ma doŋtom miŋ êvhaviŋ abô êŋ ami. ");
INSERT INTO hot_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Haveŋ yam ma Yisu anêŋ ŋê ku ju etak malak bêŋ ba i loŋ yaŋ. Ma Yisu habitak yaŋda ba hik i thô hadêŋ thai. ");
INSERT INTO hot_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma ele i enaŋ abô êŋ hadêŋ ŋê ku vi, ma doŋtom miŋ êvhaviŋ iniŋ abô ami. ");
INSERT INTO hot_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yôv ma Yisu anêŋ ŋê ku laumiŋ ba lahavute eyaŋ nôm êmô, ma Yisu da hayô ek thêlô. Ma hathaŋ thêlô hathak iniŋ kapôlôŋiŋ thekthek ba miŋ êvhaviŋ ŋê takatu ba êyê nena yani lêk haviyô yôv iniŋ abô ami. ");
INSERT INTO hot_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Êŋ ma Yisu hanaŋ hadêŋ thêlô, “Unu êtôm pik sapêŋ ma nonaŋ Abô Mavi atu ba hathak ya bêŋ êndêŋ avômalô sapêŋ. ");
INSERT INTO hot_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ŋê takatu ba êvhaviŋ ba ithik ŋaŋ ma tem Wapômbêŋ nêm i bulubiŋ. Ma ŋê takatu ba miŋ êvhaviŋ ami, ma tem nêpôm Wapômbêŋ anêŋ abô atu nena ini nêndôk loŋ atum. ");
INSERT INTO hot_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wapômbêŋ tem etak lavôŋiŋ lomaloma êndôk ŋê êvhaviŋ baheŋiŋ aêntêk. Esak yenaŋ athêŋ, ma tem nênêm ŋgôk vê lôk nenaŋ abô masôm lukmuk. ");
INSERT INTO hot_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma nebaloŋ umya kambom êmô baheŋiŋ lôk ninum nôm atu ba injik anyô vônô ma doŋtom tem nêmô mavi. Ma netak baheŋiŋ êyôŋgêk ŋê lôk lijiŋ, ma tem nimbitak mavi.” ");
INSERT INTO hot_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Anyô Bêŋ Yisu hanaŋ abô haviŋ thêlô yôv ma ewa yani hathak leŋ ba hi hamô Wapômbêŋ baŋ vianôŋ. ");
INSERT INTO hot_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Vêm ma anêŋ ŋê ku i enaŋ Abô Mavi êŋ haveŋ loŋ sapêŋ. Ma Anyô Bêŋ hadum ku haviŋ thêlô ba hik iniŋ abô loŋ hathak lavôŋiŋ takatu ba idum. ");
INSERT INTO hot_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Anyô bêŋ Tiapilus, avômalô bêŋ anôŋ eto kapya hathak nôm takatu ba bôk hik anôŋ hêk yêlô malêvôŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Thêlô eto abô hatôm atu ba anyô vi êyê Yisu hadum ba hanaŋ. Ŋê êŋ êmô hatôm Wapômbêŋ anêŋ ŋê ku ek enaŋ abô hadêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aêŋ ba yaleŋmavi anôŋ ba yahato kapya êntêk hadêŋ o hathak nôm takêŋ ek malê nena yada yahadum ku bêŋ anôŋ ek yahanaŋ hik abô takêŋ liŋ hathak Yisu anêŋ ku sapêŋ ek yenaŋ abô êŋ imbitak êtôm loho mavi. ");
INSERT INTO hot_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yahato abô takêŋ ek nêm o sa ek oyala abô takatu ba bôk holaŋô, êŋ ma abô avanôŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sêbôk atu ba Kiŋ Helot hayabiŋ avômalô Judia ma anyô habôk da te hamô ba anêŋ athêŋ nena Sekalaia. Yani hadum ku habôk da haviŋ ŋê ôdôŋ atu ba iniŋ athêŋ nena Abiya. Ma yanavi Elisabet habitak anêŋ Alon anêŋ limi haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Thai êmô thêthôŋ mavi hêk Wapômbêŋ ma, ma ethak esopa abô balabuŋ lôk Anyô Bêŋ anêŋ abô sapêŋ ba iniŋ kambom mi. ");
INSERT INTO hot_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma doŋtom Elisabet ma avi yamu ba intu thai avômena mi, ma êmô aleba eyalôv. ");
INSERT INTO hot_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wak te ma ôdôŋ Abiya iniŋ waklavôŋ nindum ku êmô unyak matheŋ. Ma etak Sekalaia ek indum ku êŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Thêlô esopa ŋê êbôk da iniŋ kobom ba ibi valu ek nêgê nena opalê intu tem imbitak êyô Anyô Bêŋ anêŋ unyak matheŋ ba ni ek êmbôk kamuŋ ôv mavi. Êŋ ma Sekalaia anêŋ athêŋ habitak ba yani hi Wapômbêŋ anêŋ unyak ek êmbôk da. ");
INSERT INTO hot_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma Sekalaia habôk da ôv mavi ba avômalô bêŋ anôŋ imiŋ unyak viyaiŋ ba eteŋ mek imiŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Êŋ ma Anyô Bêŋ anêŋ aŋela te hayô ek Sekalaia ba hamiŋ loŋ êbôk da ôv mavi anêŋ loŋ vianôŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekalaia hayê aŋela, êŋ ma hasoŋ ba hakô kambom. ");
INSERT INTO hot_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma doŋtom aŋela hanaŋ, “Sekalaia, miŋ ôkô ami. Anêm mek ma Wapômbêŋ halaŋô. Vônim Elisabet tem embathu nalum malô te ba ondam anêŋ athêŋ nena Jon. ");
INSERT INTO hot_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ma tem lemmavi bêŋ anôŋ. Amena êŋ habitak ma avômalô bêŋ anôŋ tem leŋiŋmavi ");
INSERT INTO hot_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ek malê nena yani tem imbitak anyô lôk athêŋ bêŋ imiŋ Anyô Bêŋ ma. Yani miŋ hatôm inum yak waiŋ lôk ŋaŋ maniŋ vi ami. Hamiŋ talêbô la denaŋ ma tem Lovak Matheŋ êmbôlô yani kapô siŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma tem endom avômalô Islael bêŋ anôŋ ba ini êndêŋ Anyô Bêŋ, thêlôniŋ Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma yani tem êmôŋ ek Anyô Bêŋ ma anêŋ lôklokwaŋ lôk ku lo loŋ ma tem êtôm Elia anêŋ. Ma tem indum ba lami lôk nali nimbitak kapôlôŋiŋ doŋtom. Lôk indum ŋê leŋôndôŋ kôtôŋ leŋôndôŋ ekyav ek nedaŋô ŋê thêthôŋ iniŋ auk mavi. Ma yani tem indum aêŋ ek avômalô nêpôpêk i ba neyabiŋ Anyô Bêŋ anêŋ êyô.” ");
INSERT INTO hot_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma Sekalaia hanaŋ hadêŋ aŋela, “Yai luvi bôk ayalôv yôv ba yanêmimbiŋ abô êŋ aisê?” ");
INSERT INTO hot_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma doŋtom aŋela hanaŋ viyaŋ nena, “Ya Gebliel, ba yahamiŋ Wapômbêŋ thohavloma. Ba intu yanida hêv ya ba yahalêm ek yanaŋ abô mavi êntêk êndêŋ o. ");
INSERT INTO hot_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yôv ma ondaŋô, miŋ hôêvhaviŋ yenaŋ abô ami. Aêŋ ba vembôlêk tem putup ba miŋ hatôm onaŋ abô ami endeba yenaŋ abô êntêk injik anôŋ êtôm waklavôŋ atu ba Wapômbêŋ hanaŋ am.” ");
INSERT INTO hot_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Avômalô eyabiŋ Sekalaia aleba mi ma leŋiŋhabi nena malê te lêk hapôm Sekalaia hamô unyak matheŋ kapô am? ");
INSERT INTO hot_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma Sekalaia hale yaiŋ ma abôlêk putup. Ba hik nômkama thô hathak baŋ iyom ma miŋ hanaŋ abô ami. Aêŋ ba thêlô eyala nena yani lêk hayê wêŋ te hêk unyak matheŋ kapô. ");
INSERT INTO hot_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekalaia hadum anêŋ ku yôv ma yani havôhi anêŋ unyak. ");
INSERT INTO hot_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Haveŋ yam ma Sekalaia yanavi Elisabet hasabeŋ. Ma havuŋ i hatôm ayôŋ baheŋvi. ");
INSERT INTO hot_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma hanaŋ nena, “Anyô Bêŋ lamavi ba hadum nôm êŋ ek ya ba hêv yenaŋ mama vê hêk avômalô maleŋiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet hasabeŋ hatôm ayôŋ baheŋvi ba lahavute, ma Wapômbêŋ hêv aŋela Gebliel ba hi hayô malak Nasalet hêk Galili kapô. ");
INSERT INTO hot_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yani hi hadêŋ avi muk te anêŋ athêŋ nena Malia. Malia anêŋ avômalô bôk epesaŋ abô yôv ek nendom yani êndêŋ anyô te anêŋ athêŋ nena Josep. Josep ma Kiŋ Devit anêŋ lim. ");
INSERT INTO hot_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aŋela hi hadêŋ Malia ma hanaŋ, “Waklêvôŋ mavi o! Anyô Bêŋ hêv lamavi anôŋ hadêŋ o ba hamô haviŋ o.” ");
INSERT INTO hot_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ma Malia halaŋô abô êŋ ma hasoŋ kambom ba lahabi nena abô êntêk ma aisê am. ");
INSERT INTO hot_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ma doŋtom aŋela hanaŋ hadêŋ yani, “Malia, miŋ ôkô ami. Lêk hôpôm Wapômbêŋ anêŋ lamavi. ");
INSERT INTO hot_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ondaŋô, tem osabeŋ ba onja okna te ba ondam anêŋ athêŋ nena Yisu. ");
INSERT INTO hot_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yani ma tem imbitak anyô lôk athêŋ bêŋ. Ma tem nendam yani nena Wapômbêŋ Leŋ anêŋ Nakaduŋ. Ma tem Anyô Bêŋ Wapômbêŋ nêm lim Devit anêŋ ku kiŋ êndêŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma tem êmô êtôm Jekop anêŋ avômalô iniŋ kiŋ wak nômbêŋ intu sapêŋ. Ma anêŋ ku eyabiŋ anêŋ avômalô hatôm nêm yak ami ma mi anôŋ.” ");
INSERT INTO hot_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma Malia hanaŋ hadêŋ aŋela aêntêk, “Nôm êŋ tem imbitak aisê am? Miŋ bôk yahêk haviŋ anyô te ami.” ");
INSERT INTO hot_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma aŋela hanaŋ nena, “Lovak Matheŋ tem êlêm êndôk o ma Wapômbêŋ Leŋ anêŋ lôklokwaŋ tem êyô o vôv. Ba amena atu ba hovathu ma tem matheŋ ba nendam nena Wapômbêŋ Anêŋ Nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ondaŋô. Yatam avi Elisabet bôk avôdôŋna ba elam yani nena avi yamu, ma doŋtom lêk hasabeŋ ba anêŋ ayôŋ baheŋvi ba lahavute ba tem embathu amena te. ");
INSERT INTO hot_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nômlate miŋ malaiŋ ek Wapômbêŋ indum ami.” ");
INSERT INTO hot_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma Malia hanaŋ, “Ya ma Anyô Bêŋ anêŋ avi ku. Ba indum êndêŋ ya êtôm intu honaŋ.” Êŋ ma aŋela hatak Malia ba hi. ");
INSERT INTO hot_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma Malia hatak anêŋ loŋ ma hi ketheŋ ba hayô malak te atu ba hêk loŋ dumlolê anêŋ Judia. ");
INSERT INTO hot_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ma habitak hayô Sekalaia anêŋ unyak kapô ma hanaŋ waklêvôŋ mavi hadêŋ Elisabet. ");
INSERT INTO hot_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma Elisabet halaŋô anêŋ abô ma amena hapundik hamiŋ yani la kapô ba Lovak Matheŋ havôlô yani kapô siŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Êŋ ma Elisabet halam kaêk lôk lamavi ba hanaŋ, “Wapômbêŋ hêv lamavi bêŋ anôŋ hadêŋ o hamôŋ ek avi vi. Ba tem indum mavi êndêŋ o imbiŋ amena intu ba hamiŋ o kapôlôm. ");
INSERT INTO hot_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma doŋtom ya avi alê te ba yenaŋ Anyô Bêŋ anêŋ talêbô halêm ek ênjê ya? ");
INSERT INTO hot_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ondaŋô, yahalaŋô anêm waklêvôŋ, êŋ ma amena êntêk hamiŋ yaleŋsoam lamavi ba hapundik. ");
INSERT INTO hot_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bôk holaŋô Wapômbêŋ anêŋ abô ba hôêvhaviŋ nena tem indum aêŋ. Ba intu ômô lôk lemmavi!” ");
INSERT INTO hot_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma Malia hanaŋ, “Yakapôlôŋ habô Anyô Bêŋ anêŋ athêŋ, ");
INSERT INTO hot_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma yadahôlôŋ lamavi hadêŋ Wapômbêŋ atu ba hêv ya bulubiŋ ");
INSERT INTO hot_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ek malê nena yani hayê ba lahabi anêŋ avi oyaŋ atu ba hadum anêŋ ku. Avômalô sapêŋ tem nenaŋ nena Wapômbêŋ hêv lamavi hadêŋ ya hatôm wak nômbêŋ intu sapêŋ ");
INSERT INTO hot_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ek malê nena Wapômbêŋ Lôklokwaŋ Anôŋ hadum nômbêŋ ek ya. Ma anêŋ athêŋ ida ênjêk matheŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yani hathak hêv kapô hadêŋ ŋê takatu ba elaŋô anêŋ abô hadêŋ sêbôk ma êntêk ma embeŋ yam imbiŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yani hadum ku bêŋbêŋ hathak yani anêŋ lôklokwaŋ. Ma hathak havaloŋ avômalô takatu ba êbôi ma habi i hi. ");
INSERT INTO hot_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ma hathak hamô ŋê bêŋbêŋ iniŋ lôklokwaŋ lu. Ma hêv athêŋ bêŋ hadêŋ ŋê athêŋ mi. ");
INSERT INTO hot_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ma hathak havakôŋ avômalô takatu ba ema kisi hathak nôm mavi anôŋ ba leŋiŋviyak. Ma doŋtom ŋê lôk nômkama bêŋ, ma hathak hêv i vê ba i oyaŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ma yani hathak hêv anêŋ avômalô ku Islael sa, ma lahabi anêŋ abô atu ba bôk havak haviŋ Ablaham lôk anêŋ limi sapêŋ nena tem laimbi i ba nêm i sa wak nômbêŋ intu sapêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Êŋ ma Malia hamô haviŋ Elisabet hatôm ayôŋ lô vêm ma halehi anêŋ loŋ hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ma Elisabet anêŋ waklavôŋ embathu hayô ba havathu okna te. ");
INSERT INTO hot_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Êŋ ma Elisabet anêŋ thalaleŋ lôk anêŋ avômalô elaŋô nena Anyô Bêŋ hêv kapô bêŋ hadêŋ yani ba intu êbôi lôk leŋiŋmavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ma amena êŋ hamô hatôm wak baheŋvi ba lahavulô, ma anêŋ avômalô êlêm ek neŋgothe anêŋ kupik. Ma leŋiŋhaviŋ nênêm lambô Sekalaia da anêŋ athêŋ êndêŋ okna êŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma doŋtom talêbô hanaŋ nena, “Mi. Alalô nandam nena Jon.” ");
INSERT INTO hot_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma thêlô enaŋ hadêŋ yani nena, “Libumi la miŋ bôk ewa athêŋ Jon ami.” ");
INSERT INTO hot_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Êŋ ma thêlô enaŋ hik lambô liŋ hathak baheŋiŋ nena nendam anêŋ athêŋ aisê? ");
INSERT INTO hot_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aêŋ ba hanaŋ hathak baŋ nena neja aseleŋ te êlêm. Ma hato nena, “Okna êŋ anêŋ athêŋ ma Jon.” Ma thêlô sapêŋ êyê athêŋ êŋ ba esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma ketheŋ oyaŋ ma Sekalaia hanaŋ abô hathak loŋbô ba habô Wapômbêŋ anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma avômalô malak êŋ êyê nôm êŋ ba êkô kambom. Ma abô êŋ hi haveŋ Judia iniŋ loŋ takatu ba hamô dumlolê sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma thêlô enaŋ hadêŋ i nena, “Anyô Bêŋ anêŋ lôklokwaŋ hamô haviŋ amena êntêk ba embeŋ yam ka tem imbitak aisê?” ");
INSERT INTO hot_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yôv ma Lovak Matheŋ hayô halôk Jon lambô Sekalaia kapô ba hanaŋ abô plopet aêntêk, ");
INSERT INTO hot_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Anyô Bêŋ, Islael iniŋ Wapômbêŋ, lêk halêm ek nêm anêŋ avômalô vê ênjêk iniŋ malaiŋ. Ba intu nanêm athêŋ bêŋ êndêŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yani hêv Anyô Lôklokwaŋ te habitak anêŋ anyô ku Devit anêŋ thalaleŋ ek nêm alalô bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yani hadum aêŋ hatôm sêbôk ba hanaŋ hadêŋ anêŋ plopet matheŋ ba enaŋ nena ");
INSERT INTO hot_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","tem Wapômbêŋ nêm alalô bulubiŋ ênjêk ŋê vovak lôk ŋê takatu ba bôk êpôlik hathak alalô. ");
INSERT INTO hot_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aêŋ ba yani hêv kapô ek alalôaniŋ bumalô lôk lahabi anêŋ tabô matheŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Abô atu ba yani bôk havak balabuŋ haviŋ alalôaniŋ kamik Ablaham nena ");
INSERT INTO hot_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tem nêm alalô bulubiŋ ênjêk ŋê vovak iniŋ lôklokwaŋ ek alalô nandum anêŋ ku ma miŋ nakô ami ");
INSERT INTO hot_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ek namô matheŋ lôk thêthôŋ ênjêk Wapômbêŋ ma êtôm wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aêŋ ba, yenaŋ okna, tem ômôŋ ek ôpôpêk Anyô Bêŋ anêŋ loŋôndê ek êlêm ba intu tem nendam o nena Wapômbêŋ Leŋ anêŋ plopet. ");
INSERT INTO hot_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Lôk ôndôŋ anêŋ avômalô ek neyala nena Wapômbêŋ tem nêm i bulubiŋ esak hêv iniŋ kambom vê. ");
INSERT INTO hot_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Alalôaniŋ Wapômbêŋ lahiki bêŋ anôŋ ba intu hêv kapô ba tem indum nôm êŋ lôk nêm anêŋ wak êlêm anêŋ leŋ ");
INSERT INTO hot_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ek nêm deda êndêŋ avômalô takatu ba bôk ema ba êmô momaŋiniŋ bêŋ kapô. Lôk anêŋ deda êŋ tem nêm alalô sa ek nambeŋ loŋôndê labali mavi.” ");
INSERT INTO hot_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma Jon halumbak bêŋ ma habitak lôklokwaŋ hathak hêvhaviŋ. Êŋ ma hi hamô loŋ thiliv ba hayabiŋ anêŋ waklavôŋ êlêm yaiŋ ek indum anêŋ ku ênjêk avômalô Islael maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Waklavôŋ êŋ ma Sisa Ogastus havak abô majaŋ ek neja avômalô pik takatu ba Lom eyabiŋ i iniŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wak êŋ ma môŋ anôŋ ek gavman hawa avômalô iniŋ athêŋ. Ma Kulinius ma hamô hatôm plovins Silia iniŋ gavman bêŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Êŋ ma avômalô sapêŋ i iniŋ malak ôdôŋ nenanena ek neja iniŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep habitak anêŋ Kiŋ Devit anêŋ thalaleŋ. Ba intu hatak Nasalet anêŋ Galili ma hi Devit anêŋ malak ôdôŋ Betlehem anêŋ Judia. ");
INSERT INTO hot_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yani hi haviŋ Malia ek neto thainiŋ athêŋ. Avi êŋ bôk epesaŋ anêŋ abô yôv ek nendom êndêŋ Josep. Ma wak êŋ ma Malia hasabeŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Êmô Betlehem denaŋ ma Malia anêŋ waklavôŋ hayô ek embathu. ");
INSERT INTO hot_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma havathu namalô bôp ba havuliv hathak sôp ba hadô hêk bokmaŋkao iniŋ kabum ek malê nena unyak atu ba hêk ek avômalô nêjêk ma lêk putup ba mi. ");
INSERT INTO hot_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma ŋê eyabiŋ boksipsip doho êmô loŋ êŋ viyaiŋ ba eyabiŋ iniŋ bok hadêŋ bôlôvôŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma Anyô Bêŋ anêŋ aŋela te hayô ek thêlô lôk Anyô Bêŋ anêŋ deda lôkmaŋgiŋ habi hayôhêk thêlô ba êkô kambom. ");
INSERT INTO hot_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma doŋtom aŋela hanaŋ nena, “Miŋ nôkô ami. Odaŋô! Yahawa abô mavi halêm ek môlô ba tem indum avômalô sapêŋ leŋiŋmavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lêk êntêk hêk Devit anêŋ malak ma avi te havathu okna te atu ba tem nêm môlô bulubiŋ. Yani ma Anyô Bêŋ, Mesia atu ba Wapômbêŋ bôk hatak ek nêm anêŋ avômalô bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Môlô tem ôŋgô amena kasek te ivuliv hathak sôp ba êdô hêk bokmaŋkao iniŋ kabum. Nôm êŋ ma hatôm lavôŋiŋ ek môlô ôŋgô.” ");
INSERT INTO hot_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aŋela hanaŋ yôv ma ketheŋ oyaŋ ma aŋela bêŋ anôŋ anêŋ leŋ êlêm iviŋ yani. Ma êbô Wapômbêŋ anêŋ athêŋ ba enaŋ aêntêk, ");
INSERT INTO hot_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nômbô Wapômbêŋ anêŋ athêŋ lôkmaŋgiŋ esak leŋbum. Ma pik ma anêŋ labali êmô imbiŋ avômalô takatu ba Wapômbêŋ lamavi hathak.” ");
INSERT INTO hot_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aŋela etak thêlô ba i malak leŋ ma ŋê eyabiŋ bok enaŋ hadêŋ i, “Alôana ek nagê nôm atu ba Anyô Bêŋ hanaŋ hadêŋ alalô nena lêk habitak Betlehem.” ");
INSERT INTO hot_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Êŋ ma thêlô i ketheŋ ma êpôm Malia lo Josep ma amena kasek atu ba hêk bokmaŋkao iniŋ kabum. ");
INSERT INTO hot_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Thêlô êyê yôv ma enaŋ abô takatu ba aŋela hanaŋ hadêŋ i hathak amena êŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma avômalô elaŋô ŋê eyabiŋ bok iniŋ abô êŋ ba esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Malia lahabi abô takêŋ ba havaloŋ loŋ hêk kapô. ");
INSERT INTO hot_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma ŋê eyabiŋ boksipsip ele i ma êbô Wapômbêŋ lôk leŋiŋmavi anôŋ hadêŋ Wapômbêŋ hathak nôm takatu ba thêlô êyê lo elaŋô hatôm atu ba aŋela hanaŋ hadêŋ i. ");
INSERT INTO hot_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wak baheŋvi ba lahavulô hale ba hi ma eŋgothe okna êŋ anêŋ kupik ba elam anêŋ athêŋ nena Yisu. Athêŋ êŋ ma Malia miŋ hasabeŋ ami denaŋ ma aŋela te bôk halam yôv. ");
INSERT INTO hot_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Josep lo Malia iniŋ waklavôŋ nimbitak mabuŋ ênjêk Wapômbêŋ ma hayô hatôm balabuŋ atu ba Mose bôk hato. Êŋ ma ewa Yisu ba i Jelusalem ek nênêm êndêŋ Anyô Bêŋ ");
INSERT INTO hot_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","hatôm anêŋ balabuŋ bôk hanaŋ yôv nena, “Nônêm anyô môŋ sapêŋ êndêŋ Wapômbêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Lôk i ek nêmbôk da hatôm Anyô Bêŋ anêŋ balabuŋ bôk hanaŋ nena, “menak bôbô lokwaŋju mena thabiyom muk lokwaŋju.” ");
INSERT INTO hot_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma anyô te hamô Jelusalem ba anêŋ athêŋ nena Simeon. Yani ma anyô thêthôŋ ba hasopa abô balabuŋ dedauŋ mavi. Yani hayabiŋ Mesia atu ba tem nêm Islael thêvô. Ma Lovak Matheŋ hamô haviŋ Simeon. ");
INSERT INTO hot_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ma Lovak Matheŋ bôk hanaŋ hadêŋ yani yôv nena tem miŋ ema ami ma êmô endeba ênjê Anyô Bêŋ anêŋ Mesia vêmam. ");
INSERT INTO hot_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ma Lovak Matheŋ halom yani ba hi Wapômbêŋ anêŋ unyak matheŋ. Yani hamô denaŋ ma Josep lo Malia ewa Yisu ba êlêm ek nesopa abô balabuŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ma Simeon hasip okna hamô baŋ ma habô Wapômbêŋ ba hanaŋ aêntêk, ");
INSERT INTO hot_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Anyô Bêŋ Wapômbêŋ, ya anêm anyô ku. Lêk yahayê yôv ba tem yama lôk yaleŋmavi êtôm atu ba bôk hovak abô haviŋ ya. ");
INSERT INTO hot_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Lêk yamaleŋ hayê nôm atu ba hôêv ek nêm yêlô bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Hôpôpêk nôm êŋ hêk avômalô sapêŋ maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nôm êŋ ma hatôm deda ek avômalô loŋ buyaŋ nêgê, ma tem nêm athêŋ lôkmaŋgiŋ êndêŋ anêm avômalô Islael.” ");
INSERT INTO hot_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yisu anêŋ lambô lo talêbô elaŋô Simeon anêŋ abô atu ba hanaŋ hathak okna êŋ ba esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Êŋ ma Simeon hêv mek hadêŋ thêlô ma hanaŋ hadêŋ Malia aêntêk, “Wapômbêŋ hatak okna êntêk ek indum avômalô Islael bêŋ anôŋ nênêm yak ma bêŋ anôŋ nimbiyô nimiŋ. Yani tem êmô êtôm Wapômbêŋ anêŋ lavôŋiŋ te ma doŋtom avômalô bêŋ anôŋ tem miŋ nênêmimbiŋ yani ami. ");
INSERT INTO hot_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Êŋ ma avômalô bêŋ anôŋ iniŋ auk loŋ kapô tem imbitak loŋ yaiŋ. Ma tem kapôlôm indiŋ o êtôm biŋ vovak hadabêŋ bimdaluk kisi.” ");
INSERT INTO hot_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ma plopet avi te hamô haviŋ ba anêŋ athêŋ nena Ana. Yani ma Panuel anêŋ nalavi ba habitak anêŋ Asel anêŋ ôdôŋ. Yani bôk avôdôŋna ba anêŋ sondabêŋ hatôm 84. Sêbôk ba yani avi muk ma hawa anyô ba hamô haviŋ yamalô hatôm sondabêŋ baheŋvi ba lahavuju. ");
INSERT INTO hot_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Vêm ma yamalô hama ma yani hamô hatôm avi tôp sondabêŋ bêŋ anôŋ. Wak lo bôlôvôŋ ma miŋ hatak unyak matheŋ ami, ma hathak hatak nôm ek nêm yeŋ lo eteŋ mek. ");
INSERT INTO hot_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma Simeon hanaŋ abô denaŋ, ma avi êŋ hi habobo thêlô ma hêv lamavi hadêŋ Wapômbêŋ. Ma hanaŋ abô hathak okna êŋ hadêŋ avômalô takatu ba êmô ek eyabiŋ waklavôŋ atu ba Wapômbêŋ nêm avômalô Islael vê ênjêk iniŋ malaiŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep lo Malia idum nômkama sapêŋ hatôm atu ba Anyô Bêŋ anêŋ balabuŋ hanaŋ vêm ma ele i iniŋ malak Nasalet hêk Galili. ");
INSERT INTO hot_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma okna halumbak ba habitak lôklokwaŋ. Ma anêŋ auk mavi bêŋ anôŋ. Ma Wapômbêŋ anêŋ wapôm hamô haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sondabêŋ nômbêŋ intu ma Yisu anêŋ talêbô lo lambô i Jelusalem ek nêgê waklavôŋ anêŋ athêŋ nena Hale ba Hi. ");
INSERT INTO hot_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma Yisu anêŋ sondabêŋ hatôm laumiŋ ba lahavuju, ma thêlô idum aêŋ ba ethak ba i Jelusalem ek nêgê waklavôŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Waklavôŋ bêŋ êŋ hale halôk ma thêlô ele i iniŋ loŋ. Ma okna Yisu ma hamô Jelusalem denaŋ. Ma talêbô lo lambô êthôŋ ba i. ");
INSERT INTO hot_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ma esoŋ nena lêk haviŋ anêŋ avômalô vi ba hi la. Ba eveŋ wak daluk te vêm ma êyê mi, êŋ ma i êbôlêm yani haveŋ iniŋ avômalô malêvôŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma doŋtom miŋ êpôm ami, êŋ ma êvôi Jelusalem hathak loŋbô ek nêmbôlêm yani. ");
INSERT INTO hot_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wak lô hale ba hi yôv ma êpôm yani hamô unyak matheŋ kapô. Yani hamô haviŋ kêdôŋwaga doho ba halaŋô iniŋ abô ma hanaŋ hik thêlô liŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Avômalô takatu ba elaŋô anêŋ abô lôk anêŋ auk bêŋ ma esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Êŋ ma lambô lo talêbô êyê yani ba esoŋ kambom haviŋ. Ma talêbô hanaŋ, “Yenaŋ okna, hudum malê aêŋ? Yai akô kambom ba abôlêm o.” ");
INSERT INTO hot_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma Yisu hanaŋ viyaŋ nena, “Mamu ôbôlêm ya eka? Miŋ oyala nena tem yamô Wakamik anêŋ unyak ami e?” ");
INSERT INTO hot_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma doŋtom êthôŋ anêŋ abô êŋ anêŋ ôdôŋ paliŋ. ");
INSERT INTO hot_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yôv ma hi haviŋ talêbô lo lambô ba i Nasalet. Ma halaŋô iniŋ abô ba hasopa. Ma talêbô havaloŋ abô takêŋ loŋ hêk kapô. ");
INSERT INTO hot_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yisu habitak bêŋ ma anêŋ auk mavi anôŋ. Ma Wapômbêŋ lôk avômalô leŋiŋmavi hathak yani. ");
INSERT INTO hot_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Hadêŋ sondabêŋ laumiŋ ba labaheŋvi atu ba kiŋ Sisa Taibelias hayabiŋ Lom, ma Pontius Pailat hayabiŋ Judia, ma Helot hayabiŋ Galili, ma yaŋ molok Pilip hayabiŋ Itulia lo Takonitis, ma Lisanias hayabiŋ Abilene, ");
INSERT INTO hot_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ma Anas lo Kaiapas êmô hatôm anyô bêŋ êbôk da. Hadêŋ wak êŋ ma Sekalaia nakaduŋ Jon hamô loŋ thiliv, ma Wapômbêŋ hêv anêŋ abô hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Êŋ ma Jon hi haveŋ loŋ takatu ba hamô habobo ŋaŋ Jolodaŋ ma hanaŋ ek avômalô nede kapôlôŋiŋ liliŋ ba nisik ŋaŋ ek Wapômbêŋ nêm iniŋ kambom vê. ");
INSERT INTO hot_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hatôm plopet Aisaia bôk hato halôk anêŋ kapya nena, “Kaêk te halam haveŋ loŋ thiliv nena, ‘Nôpôpêk loŋôndê ek Anyô Bêŋ êlêm, ma nopesaŋ ba imbitak thêthôŋ ek yani. ");
INSERT INTO hot_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nusivuŋ kolosoŋ sapêŋ siŋ ma node dumlolê sapêŋ pesa ba imbitak kalôŋ mavi. Ma nopesaŋ loŋôndê lokbaŋ ba imbitak thêthôŋ, ma loŋôndê kekela ma nopesaŋ ba imbitak thêthê mavi. ");
INSERT INTO hot_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma avômalô pik sapêŋ tem nêgê Wapômbêŋ anêŋ kobom atu ba hêv avômalô bulubiŋ.’” ");
INSERT INTO hot_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Avômalô bêŋ anôŋ i hadêŋ Jon ek isik thêlô ma hanaŋ hadêŋ i, “Môlô ma umya kambom anêŋ nali ba osoŋ nena tem yasik môlô ek nôsôv ênjêk Wapômbêŋ anêŋ lamaniŋ e? Mi anôŋ! ");
INSERT INTO hot_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ma nundum kobom takatu ba injik thô nena lêk ole kapôlômim liliŋ. Ma miŋ lemimimbi auk takatu ba nonaŋ êndêŋ am nena, ‘Ablaham ma yêlôaniŋ bumalô. Ba intu yêlô ma avômalô thêthôŋ.’ Mi, yanaŋ êndêŋ môlô nena Wapômbêŋ hatôm enja valu takêntêk ba epesaŋ Ablaham anêŋ limi esak. ");
INSERT INTO hot_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kisiŋ lêk hamô alokwaŋ ôdôŋ yôv ek alokwaŋ takatu ba miŋ hik anôŋ mavi ami ma tem nede lu ba nêmbôk esak atum.” ");
INSERT INTO hot_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ma avômalô nômbêŋ atu ba elaŋô anêŋ abô enaŋ hik yani liŋ, “Yêlô nandum malê?” ");
INSERT INTO hot_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma Jon hanaŋ nena, “Anyô anêŋ kwêv ju hamô ma nêm yaŋ êndêŋ anyô yaŋ atu ba kwêv mi. Ma anêŋ nôm hamô ma nêm aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma ŋê ewa takis doho êlêm ek Jon isik thêlô imbiŋ ba enaŋ hik yani liŋ nena, “Kêdôŋwaga, yêlô nandum malê?” ");
INSERT INTO hot_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma Jon hanaŋ, “Môlô noja takis êtôm atu ba Lom iniŋ anyô bêŋ hanaŋ iyom ma miŋ noja vi oyaŋ ami.” ");
INSERT INTO hot_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma ŋê vovak doho enaŋ hik yani liŋ haviŋ nena, “Ma yêlô nandum malê?” Ma hanaŋ nena, “Miŋ o mathalaleŋ êndêŋ avômalô ek noja iniŋ valuseleŋ oyaŋ ami. Lôk miŋ osau ŋê idum abô ek onja anyô yaŋ anêŋ nômkama ami. Ma lemimimbi nena môlônim ku anêŋ vuli ma hatôm môlô.” ");
INSERT INTO hot_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Avômalô Islael ethak êv maleŋiŋ ek Mesia nena tem êlêm. Ba êyê Jon hadum ku takêŋ ma esoŋ nena yani ma Mesia la. ");
INSERT INTO hot_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Êŋ ma Jon hanaŋ hadêŋ i nena, “Yahathik môlô hathak ŋaŋ, ma doŋtom ôpatu ba tem embeŋ ya yam anêŋ lôklokwaŋ ma bomaŋ ek yenaŋ. Yani ma anyô lôk athêŋ bêŋ ma ya ma yaônalôk ba intu miŋ hatôm yapole anêŋ vakapô bokŋgôp anêŋ yak vê ami. Yani tem isik môlô esak Lovak Matheŋ lôk atum. ");
INSERT INTO hot_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yani tem isuv nôm anêŋ kupik vê ba êndô anôŋ êmô unyak kapô. Ma yavoyav takatu ba hamô piklêvôŋ ma isi ba êmbôk esak atum atu ba tem miŋ ema ami.” ");
INSERT INTO hot_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma Jon hanaŋ abô bêŋ anôŋ haviŋ ek imbi avômalô leŋiŋ liŋ ba hathak kobom êŋ ma hanaŋ Wapômbêŋ anêŋ Abô Mavi bêŋ hadêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Vêm ma Jon hathaŋ Galili iniŋ Anyô Bêŋ Helot hathak anêŋ kambom takatu ba hadum ba hanaŋ te bêŋ nena, “Aisê ka howa mamuyaŋ molok yanavi Helodias hatôm vônim?” ");
INSERT INTO hot_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Êŋ ma Helot hadum kambom yaŋ hathak loŋbô nena hatak Jon hamô koladôŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon hathik avômalô bêŋ anôŋ halôk ŋaŋ aleba hathik Yisu haviŋ. Hathik vêm ma Yisu hamiŋ ba hateŋ mek ma leŋ hakyav. ");
INSERT INTO hot_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ma Lovak Matheŋ halôk ba halêm hatôm menak bôbô ba hayô hamô yani. Ma kaêk te halêm anêŋ leŋ ba hanaŋ nena, “O ma yenaŋ okna atu ba yaleŋhaviŋ videdauŋ. Ma yaleŋmavi anôŋ hathak o.” ");
INSERT INTO hot_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisu hadum anêŋ ku môŋ haveŋ avômalô maleŋiŋ, ma anêŋ sondabêŋ ma habobo 30. Ma avômalô esoŋ nena yani ma Josep nakaduŋ. Ma Josep ma Heli nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ma Heli ma Matat nakaduŋ. Matat ma Livai nakaduŋ. Livai ma Melki nakaduŋ. Melki ma Janai nakaduŋ. Janai ma Josep nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep ma Matatias nakaduŋ. Matatias ma Amos nakaduŋ. Amos ma Nahum nakaduŋ. Nahum ma Esli nakaduŋ. Esli ma Nagai nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ma Mat nakaduŋ. Mat ma Matatias nakaduŋ. Matatias ma Semen nakaduŋ. Semen ma Josek nakaduŋ. Josek ma Joda nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ma Joanan nakaduŋ. Joanan ma Lesa nakaduŋ. Lesa ma Selubabel nakaduŋ. Selubabel ma Sealtiel nakaduŋ. Sealtiel ma Neli nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli ma Melki nakaduŋ. Melki ma Adi nakaduŋ. Adi ma Kosam nakaduŋ. Kosam ma Elmadam nakaduŋ. Elmadam ma El nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El ma Josua nakaduŋ. Josua ma Eliesel nakaduŋ. Eliesel ma Jolim nakaduŋ. Jolim ma Matat nakaduŋ. Matat ma Livai nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai ma Simeon nakaduŋ. Simeon ma Juda nakaduŋ. Juda ma Josep nakaduŋ. Josep ma Jonam nakaduŋ. Jonam ma Eliakim nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ma Melea nakaduŋ. Melea ma Mena nakaduŋ. Mena ma Matata nakaduŋ. Matata ma Natan nakaduŋ. Natan ma Devit nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit ma Jesi nakaduŋ. Jesi ma Obet nakaduŋ. Obet ma Boas nakaduŋ. Boas ma Salmon nakaduŋ. Salmon ma Nason nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ma Aminadap nakaduŋ. Aminadap ma Atmin nakaduŋ. Atmin ma Alni nakaduŋ. Alni ma Heslon nakaduŋ. Heslon ma Peles nakaduŋ. Peles ma Juda nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ma Jekop nakaduŋ. Jekop ma Aisak nakaduŋ. Aisak ma Ablaham nakaduŋ. Ablaham ma Tela nakaduŋ. Tela ma Naho nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho ma Seluk nakaduŋ. Seluk ma Leu nakaduŋ. Leu ma Pelek nakaduŋ. Pelek ma Ebel nakaduŋ. Ebel ma Sela nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ma Kainan nakaduŋ. Kainan ma Alpaksat nakaduŋ. Alpaksat ma Sem nakaduŋ. Sem ma Noa nakaduŋ. Noa ma Lamek nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ma Metusela nakaduŋ. Metusela ma Inok nakaduŋ. Inok ma Jalet nakaduŋ. Jalet ma Mahalalel nakaduŋ. Mahalalel ma Kenan nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ma Inos nakaduŋ. Inos ma Set nakaduŋ. Set ma Adam nakaduŋ. Adam ma Wapômbêŋ nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Lovak Matheŋ hadum ku lôklokwaŋ hamô Yisu kapô, êŋ ma hatak ŋaŋ Jolodaŋ hêk. Ma Lovak Matheŋ halom yani ba hi loŋ thiliv. ");
INSERT INTO hot_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma hamô loŋ êŋ hatôm wak 40 ek Sadaŋ êndôk yani la ek indum kambom. Ma miŋ hayaŋ nôm ami aleba hama kisi. ");
INSERT INTO hot_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma Sadaŋ hanaŋ hadêŋ yani, “Avanôŋ, o Wapômbêŋ anêŋ Nakaduŋ ma onaŋ ek valu êntêk imbitak êtôm polom.” ");
INSERT INTO hot_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma doŋtom Yisu hanaŋ viyaŋ, “Wapômbêŋ anêŋ kapya hanaŋ, ‘Anyô miŋ hatôm êmô lôkmala esak polom iyom ami.’” ");
INSERT INTO hot_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Vêm ma Sadaŋ halom Yisu ba hathak dumlolê bêŋ te ba hi daku anêŋ dum. Ketheŋ oyaŋ ma hik pik êntêk anêŋ loŋ lôkliŋyak sapêŋ thô hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma hanaŋ hadêŋ Yisu, “Tem yanêm loŋ takêŋ iniŋ athêŋ bêŋ lôk iniŋ lôkmaŋgiŋ sapêŋ êndêŋ o ek oyabiŋ. Nôm takêŋ ma yenaŋ ba yaleŋhaviŋ yanêm êndêŋ opalê, êŋ ma tem yanêm. ");
INSERT INTO hot_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aêŋ ba hôêv yeŋ hadêŋ ya, ma tem yanêm nômkama takêntêk sapêŋ êndêŋ o.” ");
INSERT INTO hot_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Yisu hanaŋ, “Wapômbêŋ anêŋ kapya hanaŋ, ‘Nêm yeŋ êndêŋ Wapômbêŋ anêm Anyô Bêŋ lôk undum yani iyom anêŋ ku.’” ");
INSERT INTO hot_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yôv ma Sadaŋ halom ba hi Jelusalem ma hatak yani hamiŋ unyak matheŋ anêŋ vôv. Ma hanaŋ, “Avanôŋ, o ma Wapômbêŋ anêŋ Nakaduŋ ma ôsôv kisi nu tamu pik ");
INSERT INTO hot_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ek malê nena bôk eto yôv nena, “‘Yani tem nêm anêŋ aŋela ek neyabiŋ o mavi ");
INSERT INTO hot_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","lôk nisip o ek miŋ hatôm valu la embatho vemkapô ami.’” ");
INSERT INTO hot_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma Yisu hanaŋ, “Wapômbêŋ anêŋ kapya hanaŋ nena, ‘Miŋ osaê Wapômbêŋ anêm Anyô Bêŋ ami.’” ");
INSERT INTO hot_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sadaŋ halôk Yisu la ek indum kambom takêŋ vêm ma hatak yani ba hi ma hayabiŋ wak yaŋ. ");
INSERT INTO hot_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Hathak Lovak Matheŋ anêŋ lôklokwaŋ ma Yisu hale hi Galili hathak loŋbô. Ma abô hathak yani haveŋ loŋ takêŋ sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma hadôŋ thêlô hamô iniŋ unyak yeŋ ba avômalô sapêŋ ebam yani. ");
INSERT INTO hot_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ma Yisu hi Nasalet, loŋ êŋ intu anêŋ loŋ halumbak bêŋ hamô. Ma Sabat ma hi unyak yeŋ hatôm anêŋ kobom hathak hadum. Haviyô hamiŋ ek esam Wapômbêŋ anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ma êv plopet Aisaia anêŋ kapya hadêŋ yani, ma hakak ma hapôm abô bute hanaŋ aêntêk, ");
INSERT INTO hot_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anyô Bêŋ anêŋ Lovak Matheŋ hamô haviŋ ya ek malê nena Anyô Bêŋ hatak ya ek yanaŋ anêŋ Abô Mavi êndêŋ avômalô siv. Ma hêv ya ba yahalêm ek yanaŋ bêŋ êndêŋ ŋê takatu ba êmô koladôŋ ek nede yaiŋ lôk yanaŋ êndêŋ ŋê maleŋiŋ pusip ek nêgê tak esak loŋbô ma yanja ŋê takatu ba anyô vi êv vovaŋ hadêŋ i vê ");
INSERT INTO hot_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","lôk yanaŋ nena lêk ma Anyô Bêŋ anêŋ waklavôŋ hik anêŋ lamavi thô.” ");
INSERT INTO hot_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Êŋ ma hik kapya siŋ ma hêv hadêŋ ôpatu ba hayabiŋ kapya ma halôk hamô biŋ. Ma avômalô sapêŋ ititiŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma hanaŋ nena, “Abô êntêk ba hêk Wapômbêŋ anêŋ kapya ba olaŋô intu lêk hik anôŋ.” ");
INSERT INTO hot_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma thêlô sapêŋ esoŋ ba enaŋ nena anêŋ abô ma mavi anôŋ. Ma doŋtom enaŋ, “Yani ma Josep anêŋ nakaduŋ iyom, aêŋ e?” ");
INSERT INTO hot_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma Yisu hanaŋ hadêŋ thêlô, “Yahayala nena môlô tem nonaŋ abô loŋ kapô te êndêŋ ya aêntêk, ‘Dokta, oda undum lemvimkupik mavi am. Yêlô bôk alaŋô nôm takatu ba hudum hêk Kapaneam. Ba intu undum aêŋ ênjêk anêm malak ôdôŋ imbiŋ.’” ");
INSERT INTO hot_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma hanaŋ, “Yanaŋ avanôŋ êndêŋ môlô nena plopet te hi anêŋ malak ôdôŋ ma anêŋ avômalô miŋ ethak ewa yani thô ami. ");
INSERT INTO hot_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yanaŋ avanôŋ biŋ êndêŋ môlô nena sêbôk atu ba Elia hamô pik ma Islael iniŋ avi tôp bêŋ anôŋ êmô. Ma Wapômbêŋ hadum ba ôthôm mi hatôm sondabêŋ lô ma wata te haviŋ ba bôm bêŋ habitak loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma doŋtom Wapômbêŋ miŋ hêv Elia ba hi hadêŋ avi Islael te ami, ma mi. Ma hêv hi hadêŋ avi tôp te atu ba hamô Salepat Saidon iniŋ pik. ");
INSERT INTO hot_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Ma sêbôk atu ba plopet Elisa hamô ma avômalô Islael bêŋ anôŋ êpôm palê lepla. Ma doŋtom thêlô te miŋ mavi ami, ma mi. Ma Elisa hêv anyô loŋ buyaŋ Naiman anêŋ Silia iyom sa. ");
INSERT INTO hot_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","“Ma avômalô takatu ba êmô unyak yeŋ elaŋô abô takêŋ ba leŋiŋmaniŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ma iviyô imiŋ ma êv Yisu vê hêk anêŋ malak. Ma êmô yani siŋ hi hadêŋ dumlolê atu ba elav iniŋ malak hamô anêŋ dum. Ma êmô siŋ hadêŋ loŋ kambom te ek nêsô yani pôŋêŋ êndôk. ");
INSERT INTO hot_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma doŋtom Yisu hêv i vê hêk thêlô malêvôŋ ba haveŋ ba hi.” ");
INSERT INTO hot_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Vêm ma Yisu halôk ba hi Kapaneam anêŋ Galili. Ma Sabat ma hadôŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Thêlô elaŋô anêŋ abô ba esoŋ kambom ek malê nena anêŋ abô ma lôklokwaŋ bomaŋ. ");
INSERT INTO hot_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma unyak yeŋ êŋ, ma anyô te atu ba ŋgôk lelaik hamô haviŋ yani hamô. Ma yani halam kaêk lôklala aêntêk, ");
INSERT INTO hot_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei. Yisu anêŋ Nasalet, hôlêm ek undum malê te êndêŋ yêlô? Hôlêm ek umbuliŋ yêlô e? Yahayala o. O ma Wapômbêŋ anêŋ Anyô Matheŋ.” ");
INSERT INTO hot_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma doŋtom Yisu hathaŋ ŋgôk êŋ ba hanaŋ, “O bônôŋ ma otak ôpêntu.” Ma ŋgôk êŋ hadum ba ôpêŋ hêv yak halôk pik hêk thêlô malêvôŋ ma hatak ôpêŋ ba hi ma miŋ habuliŋ ôpêŋ dokte ami. ");
INSERT INTO hot_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ma avômalô sapêŋ esoŋ kambom ba enaŋ hadêŋ thêlôda nena, “Malê êntêk aêŋ am? Yani hanaŋ hadêŋ ŋgôk lelaik hatôm anyô lôk athêŋ bêŋ ma anêŋ abô ma lôklokwaŋ bomaŋ ba ŋgôk elaŋô ba ele yaiŋ ba i.” ");
INSERT INTO hot_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma abô hathak yani hi haveŋ loŋ bêŋ êŋ sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ma Yisu hatak unyak yeŋ ma hi Saimon anêŋ unyak. Ma Saimon yaŋavi hapôm lijiŋ vovaŋ kambom. Ma thêlô enaŋ ek Yisu nêm yani sa. ");
INSERT INTO hot_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Êŋ ma Yisu hi habobo avi êŋ ma hathaŋ lijiŋ êŋ ma lijiŋ êŋ hatak yani. Ma ketheŋ oyaŋ ma haviyô ba hapôpêk nôm ek thêlô. ");
INSERT INTO hot_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wak halôk jalôm ma avômalô ewa ŋê lôk lijiŋ lomaloma êyô ek Yisu. Ma hatak baŋ hayô hêk tomtom ma sapêŋ ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma hadum ba ŋgôk etak avômalô bêŋ anôŋ ba ele yaiŋ ma elam lôklala nena, “O ma Wapômbêŋ Anêŋ Nakaduŋ.” Ŋgôk takêŋ eyala nena yani intu Mesia ba intu hathaŋ i ek bônôŋ. ");
INSERT INTO hot_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lôkbôk momaŋiniŋ ma Yisu hatak loŋ êŋ hêk ma hi loŋ thiliv. Ma avômalô êbôlêm yani aleba êpôm. Ma idum ek nebaloŋ yani loŋ ek miŋ etak thêlô ba ni loŋ buyaŋ ami. ");
INSERT INTO hot_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma doŋtom hanaŋ, “Wapômbêŋ hêv ya ba yahalêm ek yandum ku êŋ ba intu yana ek yanaŋ Abô Mavi esak Wapômbêŋ anêŋ loŋ lôkliŋyak êndêŋ avômalô malak yaŋ imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Êŋ ma hi Judia iniŋ unyak yeŋ tomtom ma hanaŋ Wapômbêŋ anêŋ abô bêŋ hadêŋ i. ");
INSERT INTO hot_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wak te ma Yisu hamiŋ kasukthôm Genesalet anêŋ daŋ ma avômalô bêŋ anôŋ imiŋ ba elaŋô Wapômbêŋ anêŋ abô ba ililiŋ yani siŋ hawê haveŋ. ");
INSERT INTO hot_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma hayê ŋê ik alim etak iniŋ yeŋ luvi hamô liŋdaŋ ma i ithik iniŋ yakseŋ. ");
INSERT INTO hot_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Êŋ ma hi hathak yeŋ êŋ yaŋ, yeŋ êŋ ma Saimon anêŋ. Ba intu hanaŋ hadêŋ Saimon nena, “Ôlêm ususuniŋ yeŋ dokte ni tovola kasuk.” Ma halôk hamô ma hadôŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yani hadôŋ avômalô yôv ma hanaŋ hadêŋ Saimon nena, “Onja yeŋ ba nu kasuk malêvôŋ ma otak yakseŋ êndôk kasuk ek ômbôv alim.” ");
INSERT INTO hot_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma Saimon hanaŋ, “Anyô bêŋ, bôkam bôlôvôŋ daim ma yêlô atak yakseŋ halôk kasuk aleba miŋ avôv alim te ami ma mi anôŋ. Ma doŋtom lêk honaŋ ba intu tem yêlô natak yakseŋ êndôk kasuk.” ");
INSERT INTO hot_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Thêlô idum aêŋ ma êvôv alim bêŋ anôŋ ba yakseŋ hadum ek itip. ");
INSERT INTO hot_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Êŋ ma ik kaiyav hadêŋ yeŋ yaŋ atu ba thêlô idum ku êvôv alim haviŋ i nena nêlêm ek nênêm thêlô sa. Êŋ ma êlêm ba etak alim halôk yeŋ luvi ba hayô siŋ ba hadum ek êmô yeŋ luvi sesoŋ. ");
INSERT INTO hot_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Saimon Pita lôk ŋê takatu ba êmô haviŋ yani êyê alim nômbêŋ atu ba êvôv ma esoŋ kambom. Êŋ ma Saimon halek vadôŋ lêlô hamô Yisu va luvi ma hanaŋ nena, “Anyô Bêŋ, otak ya ba nu. Ya anyô yahadum kambom.” ");
INSERT INTO hot_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma Sebedi anêŋ nakaduŋ Jems lo Jon atu ba thêlô idum ku êvôv alim haviŋ i êyê nôm êŋ ba esoŋ kambom haviŋ. Ma Yisu hanaŋ hadêŋ Saimon, “Miŋ ôkô ami. Vêm ka tem ômbôv anyô êtôm lêk hôvôv alim.” ");
INSERT INTO hot_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Êŋ ma ewa yeŋ ba i ethak liŋdaŋ. Ma etak iniŋ nômkama sapêŋ hamô ma i esopa Yisu. ");
INSERT INTO hot_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wak te ma Yisu hamô malak lôŋ te ma anyô palê lepla hatêtô liŋkupik te halêm. Hayê Yisu ma halek vadôŋ lêlô ba hakôm halôk pik. Ma hanaŋ, “Anyô Bêŋ, lemhaviŋ ma hatôm opesaŋ ya ek yenaŋ kupik imbitak thêthê mavi.” ");
INSERT INTO hot_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Êŋ ma Yisu hasôm ôpêŋ ma hanaŋ, “Yaleŋhaviŋ. Umbitak mabuŋ mavi.” Ma ketheŋ oyaŋ ma palê lepla hatak ôpêŋ ma ôpêŋ habitak liŋsiŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ma Yisu hanaŋ hadêŋ ôpêŋ nena, “Miŋ onaŋ nôm êntêk bêŋ ami. Ma nu nuŋgwik o thô êndêŋ anyô habôk da lôk nêm da êndêŋ Wapômbêŋ hatôm Mose bôk hanaŋ yôv. Ma ŋê êbôk da tem nenaŋ êndêŋ avômalô sapêŋ nena lêk o mabuŋ mavi.” ");
INSERT INTO hot_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma doŋtom abô hathak Yisu hi mayaliv. Ba intu avômalô bêŋ anôŋ êlêm ek nedaŋô anêŋ abô lôk indum iniŋ lijiŋ mavi. ");
INSERT INTO hot_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma doŋtom wak bêŋ anôŋ ma Yisu hatak avômalô hamô ma hi loŋ thiliv ek eteŋ mek. ");
INSERT INTO hot_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wak te ma Yisu hadôŋ avômalô. Ma ŋê Palisi lôk ŋê lôkauk hathak abô balabuŋ êlêm anêŋ Jelusalem lôk malak takatu ba hamô Galili lôk Judia kapô. Ma Anyô Bêŋ anêŋ lôklokwaŋ hamô haviŋ Yisu ek indum avômalô lôk lijiŋ nimbitak mavi. ");
INSERT INTO hot_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma anyô doho etak anyô havuviŋ te halôk hêk yêm ba ewa ba êyô. Thêlô idum ek neja yani ba ini unyak kapô ek netak ênjêk ebobo Yisu. ");
INSERT INTO hot_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ma doŋtom avômalô bêŋ anôŋ ba loŋ putup ba miŋ hatôm neja yani ba ini unyak kapô ami. Êŋ ma ethak unyak vôv ma êŋgô unyak vôv abyaŋ ba êlêlô ôpatu halôk avômalô malêvôŋ aleba hayô Yisu thohavloma. ");
INSERT INTO hot_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yisu hayê thêlôniŋ êvhaviŋ ma hanaŋ hadêŋ anyô havuviŋ atu nena, “Aiyaŋ, lêk yahêv anêm kambom sapêŋ vê.” ");
INSERT INTO hot_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma Palisi lôk ŋê lôkauk hathak abô balabuŋ elaŋô abô êŋ ma leŋiŋhabi nena, “Ôpêntêk ma opalê ba hasoŋ nena yani ma Wapômbêŋ e? Anyô late miŋ hatôm nêm kambom vê ami ma Wapômbêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yisu hayala thêlôniŋ auk ba hanaŋ nena, “Aisê ka môlô lemimhikam hathak abô êntêk? ");
INSERT INTO hot_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Abô alê intu vumvum ek yanaŋ: ‘Lêk yahêv anêm kambom sapêŋ vê’ mena ‘Umbiyô ombeŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aêŋ ba tem yaŋgik Anyô Anêŋ Nakaduŋ atu thô êndêŋ môlô nena anêŋ athêŋ ma bêŋ ba hatôm nêm kambom vê.” Êŋ ma Yisu hanaŋ hadêŋ anyô havuviŋ atu aêntêk, “Yanaŋ êndêŋ o nena umbiyô umiŋ ma onja anêm yêm ba nu anêm unyak.” ");
INSERT INTO hot_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ketheŋ oyaŋ ma ôpêŋ haviyô hamiŋ avômalô malêvôŋ ma hawa anêŋ yêm. Ma hi anêŋ unyak ba habô Wapômbêŋ anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma avômalô sapêŋ esoŋ kambom ba êbô Wapômbêŋ anêŋ athêŋ haviŋ. Ma êkô ba enaŋ nena, “Lêk êntêk ma alalô ayê nômbithi anôŋ te.” ");
INSERT INTO hot_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Vêm ma Yisu hi hayê anyô hawa takis te ba anêŋ athêŋ nena Livai ba hamô unyak ewa takis. Ma hanaŋ hadêŋ ôpêŋ nena, “Ôlêm osopa ya.” ");
INSERT INTO hot_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Êŋ ma Livai haviyô ba hatak nômkama sapêŋ hamô ma hi hasopa yani. ");
INSERT INTO hot_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ma Livai hi haŋgabôm nôm bêŋ hamô anêŋ malak ek Yisu enjaŋ. Ma ŋê ewa takis bêŋ anôŋ lôk avômalô vi eyaŋ nôm haviŋ thai. ");
INSERT INTO hot_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma Palisi lôk ŋê lôkauk hathak abô balabuŋ doho atu ba êmô Palisi kapô êyê ba enaŋ abô diŋdiŋ hadêŋ anêŋ ŋê ku nena, “Môlô oaŋ ba unum haviŋ ŋê takis lôk ŋê idum kambom eka?” ");
INSERT INTO hot_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Êŋ ma Yisu hanaŋ nena, “Ŋê lôk lijiŋ iyom intu ethak i êyê dokta. Ma ŋê lijiŋ mi ma mi. ");
INSERT INTO hot_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma aêŋ iyom yahalêm ek yandam ŋê takatu ba idum kambom ek nede kapôlôŋiŋ liliŋ. Ma miŋ yahalêm ek yandam ŋê thêthôŋ ami.” ");
INSERT INTO hot_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma thêlô enaŋ hadêŋ Yisu aêntêk, “Wak bêŋ anôŋ ma Jon anêŋ ŋê ku evak balabuŋ ek nôm ek leŋiŋhabi Wapômbêŋ, ma Palisi iniŋ ŋê ku idum aêŋ iyom. Ma aisê ka anêm ŋê ku eyaŋ nôm wak nômbêŋ intu sapêŋ?” ");
INSERT INTO hot_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ma Yisu hanaŋ nena, “Anyô te hawa avi lukmuk, êŋ ma anêŋ anyô môlô eyaŋ nôm lôk leŋiŋmavi. Ma miŋ hatôm nembak balabuŋ ek nôm ami. ");
INSERT INTO hot_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma doŋtom haveŋ yam ba ewa yani vê hêk thêlô, êŋ ma anêŋ ŋê môlô tem nembak balabuŋ ek nôm.” ");
INSERT INTO hot_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma Yisu hanaŋ abô loŋ kapô te aêntêk, “Anyô te miŋ hatôm edabêŋ sôp lukmuk ek indu sôp bô anêŋ abyaŋ siŋ esak ami. Hadum aêŋ ma habuliŋ sôp lukmuk lôk sôp bô iniŋ lêlêyaŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Ma môlô othak ôkê waiŋ lukmuk halôk kolopak epesaŋ hathak bok kupik bô e? Mi! Waiŋ lukmuk êŋ tem imbuliŋ bok kupik bô atu ba bôk thekthek ba tem ipup ba waiŋ eŋgasô ni. ");
INSERT INTO hot_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ba intu othak ôkê waiŋ lukmuk halôk bok kupik lukmuk atu ba belap ek isiŋ mavi ma miŋ ipup ami lôk waiŋ miŋ eŋgasô ni ami. ");
INSERT INTO hot_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Ma doŋtom ŋê takatu ba inum waiŋ bô yôv ma ethak êpôlik ek waiŋ lukmuk. Ba enaŋ, ‘Waiŋ bô ma vasiŋ mavi ek waiŋ lukmuk.’” ");
INSERT INTO hot_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat te ma Yisu lôk anêŋ ŋê ku i eveŋ ku kapô te. Ma anêŋ ŋê ku eveŋ haviŋ yani. Ma ewa wit anêŋ va ba ekamithiŋ hamô baheŋiŋ kapô ek anêŋ kupik nêm yak ek nejaŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma Palisi doho êyê ba enaŋ, “Abô balabuŋ hanaŋ nena Sabat ma miŋ hatôm nandum ku ba naja nôm ek naŋgaŋ ami. Ma doŋtom anêm ŋê ku ibuliŋ waklavôŋ êŋ!” ");
INSERT INTO hot_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ma Yisu hanaŋ nena, “Môlô bôk osam abô hathak Devit lôk anêŋ ŋê môlô ema kisi ba idum e? ");
INSERT INTO hot_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yani habitak hayô Wapômbêŋ anêŋ unyak matheŋ kapô ba hawa polom matheŋ atu ba matheŋ anôŋ. Polom êŋ ma ŋê êbôk da iyom iniŋ ek nejaŋ ba intu habuliŋ abô balabuŋ buêŋ. Ma doŋtom Devit hayaŋ ma hêv doho hadêŋ anêŋ ŋê takatu ba eveŋ haviŋ yani ba eyaŋ.” ");
INSERT INTO hot_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Êŋ ma Yisu hanaŋ hadêŋ thêlô, “Anyô Anêŋ Nakaduŋ atu ma Sabat anêŋ Alaŋ.” ");
INSERT INTO hot_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat yaŋ ma Yisu habitak hayô unyak yeŋ te ba hi ma hadôŋ avômalô. Ma anyô te hamô loŋ êŋ ba baŋ vianôŋ hatyôk. ");
INSERT INTO hot_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma ŋê Palisi lôk ŋê lôkauk hathak abô balabuŋ doho êmô ba ititiŋ Yisu ek nêgê nena tem indum avômalô lôk lijiŋ mavi êndêŋ Sabat mena mi e? Thêlô êbôlêm loŋôndê ek nanaŋ yani bêŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma doŋtom hayala thêlôniŋ auk ba hanaŋ hadêŋ anyô baŋ hatyôk atu nena, “Umbiyô umiŋ ek avômalô sapêŋ nêgê o.” Êŋ ma ôpêŋ haviyô hamiŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma Yisu hanaŋ, “Yahadum ek yanaŋ injik môlô liŋ. Alalô hatôm nandum malê ek nasopa Sabat anêŋ balabuŋ? Hatôm nandum mavi mena kambom? Hatôm nanêm anyô sa ek êmô lôkmala mena nambuliŋ i ek nema?” ");
INSERT INTO hot_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ma Yisu hatitiŋ thêlô sapêŋ hawê haveŋ ma hanaŋ hadêŋ ôpatu nena, “Oto bahem.” Êŋ ma ôpêŋ hadum aêŋ ma baŋ habitak mavi hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ma doŋtom ŋê lôkauk hathak abô balabuŋ lôk Palisi leŋiŋmaniŋ kambom ba enaŋ hadêŋ i hi ba halêm nena, “Alalô nandum malê êndêŋ Yisu?” ");
INSERT INTO hot_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wak te ma Yisu hathak dum te ba hi ek eteŋ mek. Ma bôlôvôŋ êŋ aleba hayaŋ ma hateŋ mek iyom hadêŋ Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hayaŋ ma halam ŋê takatu ba esopa yani ethak doŋtom. Ma habi baŋ hayô hamiŋ tomtom hatôm laumiŋ ba lahavuju ma halam i nena aposel. ");
INSERT INTO hot_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ma halam Saimon ba hêv athêŋ lukmuk nena Pita hadêŋ yani ma yaŋ molok Andulu ma Jems lo Jon ma Pilip lo Batolomiu ");
INSERT INTO hot_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ma Matyu lo Tomas ma Jems Alpius nakaduŋ ma Saimon ba elam yani nena Selot ");
INSERT INTO hot_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma Judas Jems nakaduŋ ma Judas Iskaliot, ôpatu vêm ma hanaŋ Yisu bêŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yôv ma Yisu lôk anêŋ ŋê ku êlôk ba i kalôŋ bute. Ma avômalô nômbêŋ atu ba bôk esopa yani êmô loŋ êŋ lôk avômalô bêŋ anôŋ êlêm anêŋ Judia lo Jelusalem ma avômalô ŋgwêk Taia lo Saidon êlêm haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Thêlô êlêm ek nedaŋô anêŋ abô lôk indum iniŋ ŋê lôk lijiŋ mavi. Ma ŋê lôk ŋgôk lelaik ma Yisu hêv ŋgôk takêŋ vê ba ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma avômalô bêŋ anôŋ idum ek nêsôm yani ek malê nena anêŋ lôklokwaŋ bêŋ anôŋ habitak ba hi ba hathak thêlô ma tem thêlô nimbitak mavi. ");
INSERT INTO hot_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ma Yisu hayê avômalô takatu ba esopa yani ma hanaŋ hadêŋ i nena, “Môlô avômalô siv, môlô lêk ômô mavi ba Wapômbêŋ anêŋ loŋ lôkliŋyak ma tem môlônim. ");
INSERT INTO hot_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ma môlô takatu ba lêk oma kisi, môlô lêk ômô mavi ba tem lemimviyak. Ma môlô takatu ba lêk olaŋ, môlô lêk ômô mavi ba tem nomalik. ");
INSERT INTO hot_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ma avômalô êyê môlô takatu ba osopa Anyô Anêŋ Nakaduŋ atu, ba êpôlik lôk êvôliŋ dômiŋ ma enaŋ abôma nena môlônim athêŋ ma nôm ôvathek kambom. ");
INSERT INTO hot_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Êŋ ma lemimmavi lôk nodam kaêk lôklala ek malê nena môlônim nôm mavi bêŋ lêk hamô malak leŋ. Sêbôk ma iniŋ bumalô idum aêŋ hadêŋ plopet lôkthô. ");
INSERT INTO hot_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ma doŋtom kikaknena môlô ŋê lôk nômkama bêŋ anôŋ, lêk owa unim nômkama lôk lemimmavi yôv. ");
INSERT INTO hot_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ma kikaknena môlô takatu ba lêk lemimviyak, tem noma kisi. Ma kikaknena môlô takatu ba lêk omalik, tem lemimmalaiŋ kambom ba nodaŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ma kikaknena môlô takatu ba lêk avômalô sapêŋ êbô môlô. Sêbôk ma môlônim bumalô êbô plopet abôyaŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ma doŋtom yanaŋ êndêŋ môlô takatu ba othak olaŋô yenaŋ abô nena lemimimbiŋ ŋê takatu ba ik vovak hadêŋ môlô ma nundum kobom mavi êndêŋ ŋê êpôlik hathak môlô. ");
INSERT INTO hot_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma nonaŋ êndêŋ Wapômbêŋ ek indum mavi êndêŋ ŋê takatu ba enaŋ nena Wapômbêŋ imbuliŋ môlô. Ma noteŋ mek ek Wapômbêŋ indum mavi êndêŋ ŋê takatu ba idum kambom hadêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma anyô te hapetav malem daŋ vi, ma nuŋgwik vi liliŋ ek epetav imbiŋ. Ma anyô te havôv anêm kwêv daim vê, êŋ ma otak yani ek enja anêm kwêv yaŋ imbiŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma anyô te hanaŋ hik o liŋ hathak nômkama, êŋ ma nêm iyom. Ma anyô te hawa anêm nômkama, êŋ ma miŋ onaŋ lôklokwaŋ ek nêm endelêm ami. Dô. ");
INSERT INTO hot_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ma kobom atu ba lemhaviŋ anyô yaŋ indum êndêŋ o, êŋ ma undum aêŋ êndêŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Môlô lemimhaviŋ ŋê takatu ba leŋiŋhaviŋ môlô iyom, êŋ ma osoŋ nena môlô avômalô mavi e? Mi anôŋ, ŋê idum kambom ethak idum aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma môlô othak udum kobom mavi hadêŋ ŋê takatu ba idum kobom mavi hadêŋ môlô iyom, êŋ ma osoŋ nena môlô avômalô mavi e? Mi anôŋ, ŋê idum kambom ethak idum aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma môlô ôêv nômkama hadêŋ ŋê takatu ba lemimhabi nena tem nênêm viyaŋ iyom, êŋ ma osoŋ nena môlô avômalô mavi e? Mi anôŋ, ŋê idum kambom ethak idum aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ma doŋtom lemimhaviŋ nundum kobom mavi, êŋ ma lemimimbiŋ ŋê êpôlik hathak môlô ba nundum kobom mavi lôk nônêm nômkama oyaŋ êndêŋ i. Udum aêŋ ma embeŋ yam ma tem noja vuli bêŋ, ma tem nômô êtôm Wapômbêŋ Leŋ anêŋ nali ek malê nena osopa yani anêŋ bôk lo loŋ. Yani hathak hadum kobom mavi hadêŋ ŋê paloŋ lôk avômalô idum kambom haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ma môlô kapôlômim injik am esak avômalô lôkthô êtôm môlônim Lemambô kapô hiki hathak avômalô pik sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Môlô miŋ notatale anyô vi ami. Wapômbêŋ tem etatale môlô aêŋ iyom! Ma miŋ nonaŋ êndêŋ anyô vi nena vovaŋ bêŋ tem êpôm yani ami. Wapômbêŋ tem enaŋ êndêŋ môlô aêŋ iyom. Ma anyô te hadum kambom hadêŋ o, ma otak kapôlôm ek ôpêŋ. Êŋ ma tem Wapômbêŋ nêm anêm kambom vê aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ma ôêv nômkama hadêŋ avômalô vi, ma tem Wapômbêŋ nêm nômkama êndêŋ môlô. Yani tem nêm bêŋ anôŋ. Ma doŋtom yani hathak hasopa môlônim kobom. Môlô udum paloŋ ma tem yani indum aêŋ. Ma udum wapôm, ma tem Wapômbêŋ indum aêŋ iyom êndêŋ môlô.” ");
INSERT INTO hot_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Vêm ma Yisu hanaŋ abô loŋ kapô te hadêŋ thêlô aêntêk, “Hatôm anyô mapusip yaŋ endom anyô mapusip yaŋ e? Mi anôŋ. Thai luvi tem nênêm yak êndôk lôv. ");
INSERT INTO hot_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Avômena ethak unyak ma miŋ bêŋ ek iniŋ kêdôŋwaga ami. Ma doŋtom ethak unyak vêm ma tem nimbitak êtôm iniŋ kêdôŋwaga. ");
INSERT INTO hot_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Aisê ka hôyê siŋusik hamô mamuyaŋ madaluk ma miŋ lemhabi aseleŋ atu ba hapalaŋaniŋ hêk malemdaluk ami? ");
INSERT INTO hot_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma aisê ka honaŋ hadêŋ mamuyaŋ, ‘Aiyaŋ, yaleŋhaviŋ yanêm siŋusik vê ênjêk malem?’ O anyô abôyaŋ, nêm aseleŋ atu ba hapalaŋaniŋ hêk malem vê ek nôŋgô katô am ka nêm siŋusik atu ba hamô mamuyaŋ madaluk vê.” ");
INSERT INTO hot_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Alokwaŋ mavi ma miŋ hathak hik anôŋ kambom ami. Ma alokwaŋ kambom miŋ hathak hik anôŋ mavi ami. ");
INSERT INTO hot_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ma anyô ethak êyê alokwaŋ anêŋ anôŋ ma eyala nena alokwaŋ mavi mena alokwaŋ kambom. Ma anyô miŋ hatôm enja ŋgôbêŋ mena bada êmô yak lôkmaŋgiŋ kapô ami. Milôk. ");
INSERT INTO hot_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aêŋ ba anyô iniŋ kobom tem injik iniŋ kapôlôŋiŋ thô. Auk mavi hamô anyôla kapô ma tem indum nômkama mavi. Ma doŋtom auk kambom hamô anyôla kapô ma tem indum nômkama kambom. Aêŋ ba malêla takatu ba hamô anyô kapô siŋ intu tem enaŋ ende abôlêk.” ");
INSERT INTO hot_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Aisê ka olam ya nena, ‘Anyô Bêŋ’ ma miŋ osopa yenaŋ abô ami? ");
INSERT INTO hot_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ma ôpatu ba halêm hadêŋ ya ba halaŋô yenaŋ abô ba hasopa, êŋ ma tem yaŋgik ôpêŋ anêŋ bôk lo loŋ thô êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yani ma hatôm ôpatu ba halav anêŋ unyak landiŋ halôk pik lôk valu ba havaloŋ loŋ majaŋ. Ma ŋambô bêŋ hayô ba hayôkwiŋ unyak êŋ, ma doŋtom miŋ hapu ami ek malê nena pik lôk valu havaloŋ loŋ majaŋ. ");
INSERT INTO hot_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma doŋtom ôpatu ba halaŋô yenaŋ abô ma miŋ hasopa ami, êŋ ma hatôm halav anêŋ unyak hayô hamô pik pulusik. Ma ŋambô bêŋ hayô ba hayôkwiŋ unyak êŋ, ma hapu ketheŋ oyaŋ ba mi.” ");
INSERT INTO hot_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisu hanaŋ abô takêŋ hadêŋ avômalô vêm ma hi Kapaneam. ");
INSERT INTO hot_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma anyô vovak laik te anêŋ Lom hamô ba yani lamavi hathak anêŋ anyô ku te, ma doŋtom anêŋ anyô ku êŋ hapôm lijiŋ kambom ba hadum ek ema. ");
INSERT INTO hot_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Anyô vovak laik atu halaŋô nena Yisu lêk hamô loŋ êŋ, êŋ ma yani hêv Islael iniŋ ŋê bêŋbêŋ doho ba i hadêŋ Yisu ek nenaŋ injik yani liŋ ek êlêm indum anêŋ anyô ku êŋ mavi. ");
INSERT INTO hot_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Thêlô êyô ek Yisu ma enaŋ, “Ôpêntêk ma anyô mavi ba intu mavi ek nêm yani sa. ");
INSERT INTO hot_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ôpêŋ hathak lahaviŋ alalô avômalô Islael ba bôk hêv yêlô sa ek alav unyak yeŋ.” ");
INSERT INTO hot_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","8","Êŋ ma Yisu hi haviŋ thêlô. Thêlô ebobo anêŋ unyak ma anyô vovak laik êŋ hêv anêŋ anyô môlô doho ba i hadêŋ Yisu ma enaŋ, “Anyô Bêŋ, ya miŋ anyô mavi ek ôlêm yenaŋ unyak kapô ami ba intu dô. Ma aêŋ iyom ma ya miŋ anyô mavi ek yasôk yaŋgê o ami. Yada yahamô anyô bêŋ te vibiŋ ma yenaŋ ŋê vovak êmô ya vibiŋ aêŋ iyom. Ba yahanaŋ hadêŋ yenaŋ ŋê vovak te nena, ‘Nu’, ma hi. Mena yahanaŋ hadêŋ yaŋ nena, ‘Ôlêm,’ ma halêm. Ma yahanaŋ hadêŋ anyô ku te, ‘Undum ku êntêk,’ ma hadum. Ba intu humiŋ daim ba honaŋ ek yenaŋ anyô ku imbitak mavi ma tem mavi.” ");
INSERT INTO hot_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yisu halaŋô ôpêŋ anêŋ abô ba hasoŋ kambom ma hik i liliŋ havôhi ma hanaŋ hadêŋ avômalô nômbêŋ atu ba eveŋ yani yam nena, “Yanaŋ êndêŋ môlô nena miŋ bôk yahayê anyô te anêŋ pik Islael anêŋ hêvhaviŋ hatôm ôpêntêk ami!” ");
INSERT INTO hot_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma ŋê takatu ba enaŋ abô haviŋ Yisu êvôi unyak ma êyê nena anyô lôk lijiŋ atu lêk habitak mavi. ");
INSERT INTO hot_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kasana ma Yisu hi malak te anêŋ athêŋ nena Nain. Ma anêŋ ŋê ku lôk avômalô bêŋ anôŋ i haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Thêlô ebobo malak êŋ anêŋ badêŋ abôlêk ma avômalô malak êŋ ewa anyô ŋama te ba ele yaiŋ ba i. Yani ma avi tôp te anêŋ nakaduŋ doŋtom êŋ iyom. Ma avômalô malak êŋ bêŋ anôŋ i haviŋ avi tôp lôk nakaduŋ ŋama atu ba i ek nedav. ");
INSERT INTO hot_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yisu hayê avi êŋ ma lahiki ba hanaŋ hadêŋ yani nena, “Miŋ ondaŋ andô.” ");
INSERT INTO hot_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ma Yisu hi ma hatak baŋ hayôhêk alapa, ma ŋê takatu ba evak ôpêŋ imiŋ tiŋiŋ. Ma Yisu hanaŋ, “Anyô muk, yanaŋ êndêŋ o, umbiyô!” ");
INSERT INTO hot_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma anyô ŋama êŋ haviyô hamô ma hanaŋ abô, ma Yisu hêv ôpêŋ hadêŋ talêbô. ");
INSERT INTO hot_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma avômalô sapêŋ êyê ba êkô ma êbô Wapômbêŋ anêŋ athêŋ ba enaŋ, “Plopet bêŋ te lêk habitak alalô malêvôŋ. Ma Wapômbêŋ lêk halêm ek nêm anêŋ avômalô sa.” ");
INSERT INTO hot_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Êŋ ma abô hathak Yisu anêŋ ku atu ba hadum hi haveŋ avômalô Judia iniŋ loŋ sapêŋ lôk pik buyaŋ takatu ba habobo haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon anêŋ ŋê ku enaŋ hadêŋ yani hathak nôm takatu ba Yisu hadum. ");
INSERT INTO hot_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ma halam anêŋ anyô ju êlêm ma hêv i ba i ek nenaŋ injik Yisu liŋ, “O ma Mesia atu ba Wapômbêŋ bôk habutiŋ abô ek nêm êlêm mena yêlô nayabiŋ anyô yaŋ?” ");
INSERT INTO hot_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Anyô ju êŋ êyô ek Yisu ma enaŋ, “Jon anyô hathik ŋaŋ hêv yai ba alêm ek nanaŋ injik o liŋ nena, ‘O ma Mesia atu ba Wapômbêŋ bôk habutiŋ abô ek nêm êlêm mena yêlô nayabiŋ anyô yaŋ?’” ");
INSERT INTO hot_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Thai êyô ma êyê Yisu hadum avômalô lôk lijiŋ lomaloma mavi lôk hêv ŋgôk kambom bêŋ anôŋ vê hêk avômalô. Ma hadum ŋê maleŋiŋ pusip bêŋ anôŋ êyê tak. ");
INSERT INTO hot_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Vêm ma hanaŋ hadêŋ thai aêntêk, “Nôbônu ma nonaŋ êndêŋ Jon esak nôm takatu ba mamu ôyê lo olaŋô. Ŋê maleŋiŋ pusip êyê tak, ma ŋê veŋiŋvuviŋ eveŋ, ma ŋê palê lepla ibitak mavi, ma ŋê leŋiŋôndôŋ kôtôŋ elaŋô abô, ma ŋê ŋama iviyô hathak loŋbô ma ŋê siv elaŋô Wapômbêŋ anêŋ Abô Mavi atu. Ba intu unu nonaŋ êndêŋ Jon esak nôm takêŋ. ");
INSERT INTO hot_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ma ŋê takatu ba êyê ya ba evaloŋ iniŋ êvhaviŋ loŋ, nêmô lôk leŋiŋmavi.” ");
INSERT INTO hot_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ma Jon anêŋ anyô ku êvôi ma Yisu hanaŋ abô hathak Jon hadêŋ avômalô nena, “Bôk môlô u loŋ thiliv ek ôyê malê? Môlô u ek ôyê lovak hayuv baselak vuak e? ");
INSERT INTO hot_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mi. Mena u ek ôyê anyô te hik kwêv kêkêlô ba hayaŋ nôm mavi lomaloma e? Mi, ŋê takatu ba ik kwêv kêkêlô ma êmô kiŋ anêŋ unyak ma miŋ êmô loŋ thiliv ami. ");
INSERT INTO hot_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Môlô u loŋ thiliv ek ôyê malê? Plopet te e? Avanôŋ! Ma doŋtom yanaŋ êndêŋ môlô nena Jon ma bêŋ ek plopet sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bôk eto hathak ôpêŋ hêk Wapômbêŋ anêŋ kapya nena, “‘Odaŋô, tem yanêm yenaŋ anyô ku te êmôŋ ek o, ek enaŋ yenaŋ abô bêŋ ek êpôpêk loŋôndê ek o.’ ");
INSERT INTO hot_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Yanaŋ êndêŋ môlô nena Jon ma bêŋ ek avômalô pik sapêŋ. Avi te miŋ bôk havathu anyô te aêŋ ami ma mi. Ma doŋtom ôpatu ba yaôna hêk Wapômbêŋ anêŋ loŋ lôkliŋyak, ôpêŋ ma bêŋ ek Jon.” ");
INSERT INTO hot_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Sêbôk ma Jon hathik avômalô lôk ŋê ewa takis haviŋ ba intu elaŋô abô atu ba Yisu hanaŋ hathak Jon ma enaŋ, “Wapômbêŋ anêŋ kobom ma thêthôŋ anôŋ.” ");
INSERT INTO hot_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma doŋtom ŋê Palisi lôk ŋê lôkauk hathak abô balabuŋ êdô ek Jon isik thêlô ba intu êvôliŋ dômiŋ hadêŋ loŋôndê atu ba Wapômbêŋ hik thô hadêŋ i.) ");
INSERT INTO hot_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma Yisu hanaŋ, “Yanaŋ aisê esak avômalô bôlôŋ êntêk? Ma thêlô hatôm malê? ");
INSERT INTO hot_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Thêlô ma hatôm avômena takatu ba êmô loŋ ethak doŋtom halôk ba elam hi ek avômena vi nena, “‘Yêlô abi yeŋ beleŋ ek môlô nondo yeŋ, ma doŋtom miŋ olo yeŋ ami. Ma yêlô alaŋ asêŋ malêŋ ek môlô nodaŋ, ma doŋtom miŋ olaŋ ami.’ ");
INSERT INTO hot_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Ma avômalô bôlôŋ êntêk êtôm avômena takêŋ. Jon anyô hathik ŋaŋ halêm ma hatip ek nôm lôk waiŋ. Ma môlô ôpôlik hathak yani ba onaŋ nena ŋgôk hamô haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma doŋtom Anyô Anêŋ Nakaduŋ atu halêm ma miŋ hatip ek nôm lo waiŋ ami. Ba intu môlô onaŋ, ‘Ôŋgô, anyô êŋ hathak hayaŋ nôm lôk hanum waiŋ bêŋ anôŋ aleba intu halo molo. Yani ma ŋê idum kambom lôk ŋê ewa takis iniŋ anyô môlô.’ ");
INSERT INTO hot_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aêŋ ba Wapômbêŋ anêŋ auk tem injik anôŋ mavi ba avômalô tem nêgê nena auk êŋ ma thêthôŋ anôŋ.” ");
INSERT INTO hot_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palisi te halam Yisu hi ek enjaŋ nôm imbiŋ yani. Êŋ ma yani hi hayô ôpêŋ anêŋ unyak ma halôk hamô ek enjaŋ nôm. ");
INSERT INTO hot_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma avi sek te anêŋ loŋ êŋ halaŋô nena Yisu lêk hayaŋ nôm hamô Palisi atu anêŋ unyak. Êŋ ma hawa nôm ôv mavi halôk kolopak valu te ba thapuk ba hi unyak êŋ. ");
INSERT INTO hot_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma halêm hamiŋ Yisu dôm habobo valuvi ma halaŋ ba mathôk hêv yak hayô hamô Yisu vakapô. Ma hathav mathôk vê hathak yanida wakadôk ŋauŋ. Ma haliŋu Yisu vakapô lôbôlôŋ ma hawa nôm lêŋlêŋ ôv mavi atu ba hathik Yisu vakapô hathak. ");
INSERT INTO hot_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Palisi atu hayê nôm êŋ ma lahabi nena, “Yisu ma miŋ plopet te ami. Yani plopet ma tem eyala nena avi atu ba hasôm yani ma avi sek te ba tem êpôlik.” ");
INSERT INTO hot_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yisu hayala ôpêŋ anêŋ auk ma hanaŋ, “Saimon, yenaŋ abô te hêk ek yanaŋ êndêŋ o.” Ma Saimon hanaŋ, “Kêdôŋwaga, onaŋ.” ");
INSERT INTO hot_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ma Yisu hanaŋ, “Anyô ju bôk ewa valuseleŋ hêk anyô bêŋ te. Anyô yaŋ hawa hatôm 500, ma yaŋ hawa hatôm 50 ba iniŋ viyaŋ hêk. ");
INSERT INTO hot_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma thai miŋ hatôm nênêm valuseleŋ êŋ viyaŋ ami. Ma anyô bêŋ êŋ hanaŋ hadêŋ thai luvi nena, ‘Dô, hatôm.’” Yisu hanaŋ abô loŋ kapô êŋ yôv ma hanaŋ hik Saimon liŋ nena, “Lemhabi nena anyô ju êŋ yaŋsê intu lahaviŋ ôpêŋ bêŋ anôŋ?” ");
INSERT INTO hot_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma Saimon hanaŋ viyaŋ nena, “Yaŋ atu ba hawa valu bêŋ la.” Ma Yisu hanaŋ, “Anêm auk ma mavi.” ");
INSERT INTO hot_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ma Yisu hik i liliŋ ma hayê avi êŋ ma hanaŋ hadêŋ Saimon, “Nôŋgô avi êntêk. Yahabitak hayô anêm unyak kapô ma miŋ hôêv ŋaŋ ba yahathik yaveŋ ami. Ma doŋtom avi êntêk hathik yaveŋ hathak yanida mathôk ma haya vê hathak yanida wakadôk ŋauŋ. ");
INSERT INTO hot_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma miŋ huliŋu ya ami, ma doŋtom avi êntêk haliŋu yaveŋkapô lôbôlôŋ. ");
INSERT INTO hot_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma miŋ howa nôm lêŋlêŋ ba hoŋgasô hayô hamô yaleŋkadôk ami, ma doŋtom avi êntêk hawa nôm lêŋlêŋ ôv mavi ba haŋgasô hayô hamô yaveŋkapô. ");
INSERT INTO hot_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aêŋ ba yanaŋ êndêŋ o nena avi êntêk lahaviŋ ya bêŋ anôŋ ba intu alalô ayala nena anêŋ kambom bêŋ anôŋ bôk hêv yak yôv. Ma doŋtom avômalô takatu ba esoŋ nena iniŋ kambom takatu ba Wapômbêŋ hêv vê ma dokte iyom, êŋ ma leŋiŋhaviŋ yani dokte aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ma Yisu hanaŋ hadêŋ avi êŋ nena, “Anêm kambom sapêŋ lêk hêv yak yôv.” ");
INSERT INTO hot_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma avômalô takatu ba êmô Saimon anêŋ unyak elaŋô abô êŋ ma enaŋ hadêŋ i nena, “Ôpêntêk ma opalê ba intu hêv kambom vê?” ");
INSERT INTO hot_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ma Yisu hanaŋ hadêŋ avi êŋ, “Anêm hôêvhaviŋ hêv o bulubiŋ. Nu lôk lemmavi.” ");
INSERT INTO hot_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yôv ma Yisu hi haveŋ malak lôbôlôbô ba hanaŋ Abô Mavi hathak Wapômbêŋ anêŋ loŋ lôkliŋyak. ");
INSERT INTO hot_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ŋê ku laumiŋ ba lahavuju lôk avi takatu ba bôk hêv iniŋ ŋgôk lôk lijiŋ vê eveŋ haviŋ yani. Avi takatu te ma Malia anêŋ Magadala sêbôk ba ŋgôk baheŋvi ba lahavuju etak yani. ");
INSERT INTO hot_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ma avi yaŋ ma Joana, Kusa yanavi. Kusa ma ôpatu ba hayabiŋ Helot anêŋ unyak. Ma te ma Susana lôk avi bêŋ anôŋ haviŋ. Avi takêŋ ethak êv Yisu thêlô sa hathak nômkama. ");
INSERT INTO hot_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Avômalô bêŋ anôŋ ibi thêthô hêk lomalak lomalak ba êlêm ethak doŋtom ek nêgê Yisu. Ma Yisu hanaŋ abô loŋ kapô te nena, ");
INSERT INTO hot_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Anyô te hi hapaliv yaŋvêk halôk anêŋ ku. Ma hapaliv yaŋvêk takêŋ ma vi halôk loŋôndê ba avômalô evak pesa lôk menak êpôm ba eyaŋ. ");
INSERT INTO hot_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ma doho halôk pik lôk valu ba hapup. Ma doŋtom pik êŋ moma ba yaŋvêk êŋ hayeŋ ba hama. ");
INSERT INTO hot_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma vi halôk loŋ yak lôkmaŋgiŋ kapô ba yak êŋ halumbak hayô yaŋvêk takêŋ vôv. ");
INSERT INTO hot_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma doŋtom vi halôk pik mavi ba hapup ba habitak bêŋ ma hik anôŋ ba hatôm 100.” Yisu hanaŋ abô takêŋ yôv ma halam nena, “Môlô ŋê lôk lemôndôŋ ma nodaŋô abô êntêk katô.” ");
INSERT INTO hot_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ma Yisu anêŋ ŋê ku enaŋ hik yani liŋ hathak abô loŋ kapô êŋ anêŋ ôdôŋ. ");
INSERT INTO hot_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma yani hanaŋ nena, “Wapômbêŋ lêk hik anêŋ auk loŋ kapô hathak anêŋ loŋ lôkliŋyak thô hadêŋ môlô yôv. Ma doŋtom avômalô vi ma yahathak yahanaŋ hathak abô loŋ kapô iyom. Ba intu “‘thêlô êyê, ma doŋtom miŋ êyê katô ami. Ma thêlô elaŋô, ma doŋtom miŋ eyala anêŋ ôdôŋ katô ami.’” ");
INSERT INTO hot_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ma Yisu hanaŋ nena, “Abô loŋ kapô êŋ anêŋ ôdôŋ ma aêntêk. Yaŋvêk ma hatôm Wapômbêŋ anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yaŋvêk takatu ba halôk loŋôndê ma hatôm avômalô takatu ba elaŋô Wapômbêŋ anêŋ abô, ma haveŋ yam ma Sadaŋ hayô ma hêv Wapômbêŋ anêŋ abô vê hêk thêlô kapôlôŋiŋ ek miŋ nênêmimbiŋ ami. Ba intu Wapômbêŋ miŋ hatôm nêm thêlô bulubiŋ ami. ");
INSERT INTO hot_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma yaŋvêk takatu ba halôk pik lôk valu ma hatôm avômalô takatu ba elaŋô Wapômbêŋ anêŋ abô ba evaloŋ lôk leŋiŋmavi. Ma doŋtom iniŋ ŋgalôk miŋ halôk pik kapô ba hi ami. Ba intu êvhaviŋ bidoŋna iyom ma malaiŋ hayô ma etak iniŋ êvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ma yaŋvêk takatu ba halôk yak lôkmaŋgiŋ kapô ma hatôm avômalô takatu ba elaŋô Wapômbêŋ anêŋ abô, ma doŋtom thêlô êmô dokte ba pik êntêk anêŋ malaiŋ lôk anêŋ nômkama lôk anêŋ nôm mavi hathivuŋ Wapômbêŋ anêŋ abô siŋ ba thêlô miŋ ik anôŋ ami ma mi. ");
INSERT INTO hot_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma doŋtom yaŋvêk takatu ba halôk pik mavi ma hatôm avômalô takatu ba kapôlôŋiŋ mavi ba maleŋ lêlê. Thêlô elaŋô Wapômbêŋ anêŋ abô ba evaloŋ loŋ majaŋ. Êŋ ma hatôm imiŋ lôklokwaŋ ba ik anôŋ mavi. ");
INSERT INTO hot_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Anyô miŋ ethak êtôm atum lam ba êdô hamô uŋ kapô mena ivuŋ hamô loŋ kapô te ami. Thêlô ethak êthôkwêŋ hamiŋ ek avômalô takatu ba êyô unyak kapô ma nêgê deda. ");
INSERT INTO hot_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nômkama takatu ba ivuŋ hêk loŋ kapô ma tem nimbitak loŋ yaiŋ. Ma nômkama takatu ba ivuŋ i êmô loŋ momaŋiniŋ ma tem nimbitak yaiŋ ek sapêŋ neyala i. ");
INSERT INTO hot_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aêŋ ba môlô nodaŋô yenaŋ abô êntêk katô. Ôpatu ba hayala yenaŋ abô katô ma tem Wapômbêŋ indum ba yani eyala nômkama doho imbiŋ. Ma doŋtom ôpatu ba miŋ hayala yenaŋ abô ami, ma tem Wapômbêŋ enja auk takatu ba ôpêŋ hasoŋ nena bôk hawa yôv vê ênjêk ôpêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ma Yisu anêŋ talêbô lôk iviyaŋ êlêm ek nêgê yani, ma doŋtom avômalô bêŋ anôŋ imiŋ loŋ siŋ ba miŋ hatôm nêgê yani ami. ");
INSERT INTO hot_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Êŋ ma anyô te hanaŋ hadêŋ Yisu nena, “Lemtambô lôk môlôviyaŋ imiŋ yaiŋ ba leŋiŋhaviŋ nêgê o.” ");
INSERT INTO hot_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Êŋ ma Yisu hanaŋ, “Yenaŋ wakatik lôk aiyaŋ thêlô ma ŋê takatu ba elaŋô Wapômbêŋ anêŋ abô ba esopa.” ");
INSERT INTO hot_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wak te ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Alôana kasukthôm vi tuvulu.” Êŋ ma ewa yeŋ ba i. ");
INSERT INTO hot_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Thêlô i ma Yisu hêk sôm. Ma ôthôm bêŋ lôk lovak hayô ba hayuv kasuk ba hik halôk yeŋ kapô ba hadum ek êmô thêlô sesoŋ êndôk kasuk kapô ba ini. ");
INSERT INTO hot_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Êŋ ma i ik Yisu liŋ ba enaŋ, “Anyô bêŋ, anyô bêŋ, alalô tem nama ba mi!” Ma Yisu haviyô ma hathaŋ lovak lôk kasuk budum bêŋ takatu ba ema ba êk tiŋiŋ. ");
INSERT INTO hot_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma Yisu hanaŋ hadêŋ thêlô, “Môlônim ôêvhaviŋ hamô êsê?” Ma thêlô êkô ba esoŋ kambom ba enaŋ hi ba halêm nena, “Ôpêntêk ma opalê ba intu hanaŋ abô hadêŋ kasuk lo lovak ba elaŋô anêŋ abô ba esopa?” ");
INSERT INTO hot_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ma thêlô ewa yeŋ êŋ ba ibup êyô kasuk ba i avômalô Gelasa iniŋ pik. Loŋ êŋ hêk Galili vi tuvulu. ");
INSERT INTO hot_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ma thêlô ethak liŋ ma Yisu hatak yeŋ ba hi, ma anyô te atu ba ŋgôk hamô haviŋ yani anêŋ loŋ êŋ halêm ba hapôm Yisu. Ôpêŋ bôk hatak anêŋ malak ma hi hamô siô ba haveŋ kôlôlôŋ. ");
INSERT INTO hot_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ŋê loŋ êŋ ethak ekak ôpêŋ baŋ lo va lusu hathak seŋ ma êv anyô te ek eyabiŋ, ma doŋtom ŋgôk êŋ hayô ba hayôkwiŋ ôpêŋ ma hamô seŋ êŋ kisi. Ma habi ôpêŋ vôkê ma hi hamô loŋ thiliv. Ma anyô êŋ hayê Yisu ma halaŋ boloba ba hêv yak halôk pik habobo Yisu valuvi. Êŋ ma Yisu hanaŋ hadêŋ ŋgôk lelaik atu nena, “Otak ôpêntêk ba nu.” Êŋ ma ôpêŋ halam lôklala bomaŋ nena, “Yisu, o ma Wapômbêŋ Leŋ Anôŋ Biŋ anêŋ Nakaduŋ, lemhaviŋ undum malê êndêŋ ya? Miŋ nêm vovaŋ êndêŋ ya ami!” ");
INSERT INTO hot_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Êŋ ma Yisu hanaŋ hik ôpêŋ liŋ, “Anêm athêŋ nena?” Ma ôpêŋ hanaŋ, “Yenaŋ athêŋ nena Ŋê Vovak Lubuŋlubuŋ” ek malê nena ŋgôk bêŋ anôŋ êmô yani kapô. ");
INSERT INTO hot_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma ŋgôk takêŋ enaŋ lôbôlôŋ hadêŋ Yisu nena, “Miŋ ômbi yêlô êndôk Viv atu ami. ");
INSERT INTO hot_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nêm yêlô ni êndôk bok takêŋdaku ba êmô dum endaku.” Êŋ ma Yisu halôk hathak iniŋ auk. ");
INSERT INTO hot_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ma ŋgôk takêŋ etak ôpêŋ ma i êlôk bok takêŋ kapô. Ma bok takêŋ elaŋviŋ ketheŋ ba i hadêŋ loŋ kambom ma êv yak halôk kasukthôm ba ŋaŋ halok sapêŋ vônô. ");
INSERT INTO hot_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ma ŋê takatu ba eyabiŋ bok êyê nôm êŋ ma êsôv ba i enaŋ mayaliv haveŋ lomalak. ");
INSERT INTO hot_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma avômalô êlêm ek nêgê nena malê te habitak loŋ êŋ. Thêlô êyô ma êyê Yisu lôk ôpatu ba ŋgôk bêŋ anôŋ bôk êmô haviŋ yani ba lêk anêŋ auk habitak mavi ba hapuk sôp ma hamô habobo Yisu valuvi. Avômalô êyê ba êkô kambom. ");
INSERT INTO hot_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma ŋê takatu ba êyê nôm êŋ enaŋ hadêŋ avômalô hathak nôm takatu ba hadum ba anyô lôk ŋgôk atu habitak mavi. ");
INSERT INTO hot_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ma avômalô Gelasa sapêŋ êkô ba elowaliŋ kambom ba enaŋ ek Yisu etak i ba ni buyaŋ. Aêŋ ba Yisu hathak yeŋ ma thêlô êvôi Galili hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma anyô lôk ŋgôk atu lêk mavi ba hanaŋ lôklokwaŋ hadêŋ Yisu nena, “Hatôm yasôk imbiŋ o e?” Ma doŋtom Yisu hêv ek êmbôni anêŋ loŋ ba hanaŋ, ");
INSERT INTO hot_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Onaŋ êndêŋ avômalô esak nômbêŋ atu ba Wapômbêŋ hadum hathak o.” Êŋ ma havôhi anêŋ loŋ ma hanaŋ hadêŋ avômalô sapêŋ hathak nômbêŋ atu ba Yisu hadum hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yisu hale hi kasukthôm vi tuvulu hathak loŋbô ma avômalô bêŋ anôŋ lêk eyabiŋ yani êmô liŋdaŋ ba ewa yani thô. ");
INSERT INTO hot_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma anyô bêŋ hayabiŋ unyak yeŋ te halêm ma anêŋ athêŋ nena Jailus. Yani halek vadôŋ lêlô habobo Yisu valuvi ma hanaŋ hik yani liŋ lôk kapô malaiŋ ek Yisu imbiŋ yani ba ini anêŋ unyak. ");
INSERT INTO hot_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ek malê nena anêŋ amena ma doŋtom iyom ba hapôm lijiŋ ba hadum ek ema. Amena êŋ anêŋ sondabêŋ ma hatôm laumiŋ ba lahavuju. Êŋ ma Yisu hi haviŋ yani ma avômalô bêŋ anôŋ ekalabu yani siŋ. ");
INSERT INTO hot_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma avi te hamô loŋ êŋ ba hapôm lijiŋ thalaleŋ halom hatôm sondabêŋ laumiŋ ba lahavuju. Ma anyôla miŋ hatôm idum yani mavi ami. ");
INSERT INTO hot_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Avi êŋ halêm habobo Yisu dômlokwaŋ ma hasôm Yisu anêŋ kwêv daim anêŋ daŋ iyom ma ketheŋ oyaŋ ma thalaleŋ êŋ hakapok. ");
INSERT INTO hot_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Êŋ ma Yisu hanaŋ hik thêlô liŋ, “Opalê hasôm ya?” Ma thêlô sapêŋ enaŋ nena thêlô mi. Ma Pita hanaŋ, “Anyô Bêŋ, avômalô bêŋ anôŋ ekalabu o siŋ ba intu êsôm o.” ");
INSERT INTO hot_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma doŋtom Yisu hanaŋ, “Anyôla hasôm ya ba yahasaê nena yenaŋ lôklokwaŋ doho hêv yak.” ");
INSERT INTO hot_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ma avi êŋ hayê nena miŋ hatôm imbuŋ i ami. Ba intu hakô ba halowaliŋ ba hi halek vadôŋ lêlô habobo Yisu va. Ma hanaŋ hathak hasôm yani ma ketheŋ oyaŋ ma anêŋ thalaleŋ atu hakapok ba avômalô nômbêŋ atu elaŋô. ");
INSERT INTO hot_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma Yisu hanaŋ hadêŋ avi êŋ, “Yenaŋ avena, anêm hôêvhaviŋ hadum ba lêk hubitak mavi. Nu lôk kapôlôm labali.” ");
INSERT INTO hot_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yisu hanaŋ abô hamiŋ denaŋ ma anyô te halêm anêŋ Jailus anêŋ unyak ba hanaŋ, “Nalum avi lêk hama yôv ba intu otak kêdôŋwaga ma miŋ nêm malaiŋ êndêŋ yani ami.” ");
INSERT INTO hot_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yisu halaŋô abô êŋ ma hanaŋ hadêŋ Jailus, “Miŋ ôkô ami. Nêmimbiŋ iyom ma tem nalum avi mavi esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Yisu hayô Jailus anêŋ unyak ma avômalô êmô ba elaŋ asêŋ malêŋ lôk leŋiŋmalaiŋ bêŋ hathak yani. Ma Yisu hanaŋ, “Asêŋ dô. Yani hêk sôm iyom ma miŋ hama ami.” Thêlô eyala nena lêk hama yôv ba intu emalik hathak Yisu. Ma Yisu hadô avômalô ini imbiŋ yani ba hawa Pita lo Jon ma Jems lôk amena êŋ talêbô lo lambô iyom ba i unyak kapô haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Êŋ ma havaloŋ avena hamô baŋ ma halam nena, “Avena, umbiyô!” ");
INSERT INTO hot_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma avena êŋ anêŋ dahô hayô halôk kupik hathak loŋbô ma ketheŋ oyaŋ ma haviyô. Ma Yisu hanaŋ ek nênêm nôm êndêŋ avena êŋ ek enjaŋ. ");
INSERT INTO hot_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma anêŋ talêbô lo lambô esoŋ kambom. Ma doŋtom Yisu hanaŋ lôklokwaŋ nena miŋ nenaŋ nôm êŋ bêŋ êndêŋ anyôla ami. ");
INSERT INTO hot_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisu halam anêŋ ŋê ku laumiŋ ba lahavuju ethak doŋtom ma hêv lôklokwaŋ lôk athêŋ bêŋ hadêŋ i ek nênêm ŋgôk sapêŋ vê lôk nindum avômalô lijiŋ mavi. ");
INSERT INTO hot_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma yani hêv thêlô ba i ek nenaŋ abô esak Wapômbêŋ anêŋ loŋ lôkliŋyak lôk nindum avômalô lôk lijiŋ mavi. ");
INSERT INTO hot_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma Yisu hanaŋ hadêŋ thêlô, “Môlô nu lomalak lomalak. Ma miŋ noja kôm lo vak ma nôm lo valuseleŋ imbiŋ ami. Uŋgwik kwêv doŋtom ma miŋ noja kwêv yaŋ imbiŋ ami. ");
INSERT INTO hot_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Unyak alêla takatu ba môlô ôyô, ma nômô unyak êŋ iyom endeba notak loŋ êŋ ek unu buyaŋ. ");
INSERT INTO hot_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma doŋtom loŋ takatu ba miŋ ewa môlô thô ami, ma waklavôŋ otak loŋ êŋ, ma uŋgwik voŋgovaŋ takatu ba hamô vemimkapô vê êndôk thêlô maleŋiŋ ek injik iniŋ kambom thô.” ");
INSERT INTO hot_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yôv ma thêlô i eveŋ lomalak lomalak ba enaŋ Wapômbêŋ anêŋ Abô Mavi lôk idum avômalô lôk lijiŋ mavi. ");
INSERT INTO hot_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Anyô Bêŋ Helot halaŋô nôm takatu ba Yisu hadum ba lahabi bêŋ anôŋ hathak ek malê nena anyô doho enaŋ aêntêk, “Jon haviyô hêk ŋama hathak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ma anyô doho enaŋ, “Elia halêm,” ma doho enaŋ, “Plopet tak sêbôk te haviyô hathak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Êŋ ma Helot hanaŋ nena, “Bôk yahadabêŋ Jon laselo kisi yôv, ma doŋtom Yisu ma opalê ba yahalaŋô avômalô enaŋ abôkama hathak yani?” Êŋ ma yani hadum ek ênjê Yisu. ");
INSERT INTO hot_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma Yisu anêŋ aposel êyô, ma enaŋ hathak nôm takatu ba thêlô idum bêŋ hadêŋ Yisu. Yôv ma Yisu halom thêlôda iyom ba i malak te anêŋ athêŋ nena Betsaida. ");
INSERT INTO hot_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma doŋtom avômalô bêŋ anôŋ eyala nena Yisu lêk hi. Êŋ ma thêlô esopa yani ba i. Thêlô i êyô ek Yisu ma yani hawa thêlô thô. Yôv ma yani hanaŋ abô hathak Wapômbêŋ anêŋ loŋ lôkliŋyak ba hadum avômalô lôk lijiŋ ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma yaŋsiŋ bôlôvôŋ ma Yisu anêŋ ŋê ku êlêm ma enaŋ hadêŋ yani nena, “Lêk yaŋsiŋ ma alalô amô loŋ thiliv. Ba intu otak avômalô takêntêk ek ini malak lôk loŋ takatu ba hamô habobo ek nêmbôlêm iniŋ nôm lôk loŋ nêjêk.” ");
INSERT INTO hot_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ma doŋtom Yisu hanaŋ nena, “Mi, môlôda nobakôŋ i.” Ma thêlô enaŋ, “Yêlôaniŋ nôm ma polom baheŋvi ma alim ju iyom hamô ba miŋ hatôm ami. Aêŋ ba yêlô ana nanêm nôm vuli ek avômalô nômbêŋ êntêk êŋ la?” ");
INSERT INTO hot_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Thêlô enaŋ abô êŋ ek malê nena anyô bêŋ anôŋ ba hatôm 5,000 la intu êmô. Ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Môlô nonaŋ êndêŋ avômalô nena nesak doŋtom êtôm aêntêk 50 dum te, ma 50 dum yaŋ êtôm 5,000.” ");
INSERT INTO hot_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ŋê ku idum aêŋ hadêŋ avômalô ba sapêŋ êlôk êmô biŋ. ");
INSERT INTO hot_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ma Yisu hawa polom baheŋvi lôk alim ju atu ba hêv ma hathak leŋ ma hateŋ mek. Vêm ma haya hi lôbôlôbô ma hêv hadêŋ anêŋ ŋê ku ba ibi sam hadêŋ avômalô nômbêŋ atu. ");
INSERT INTO hot_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ma avômalô sapêŋ eyaŋ ba leŋiŋviyak. Ma nôm wata vi atu ba hamô ma ŋê ku isup halôk vak sam laumiŋ ba lahavuju. ");
INSERT INTO hot_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wak te ma Yisu hateŋ mek ma anêŋ ŋê ku iyom êmô haviŋ yani. Ma Yisu hanaŋ hik thêlô liŋ nena, “Avômalô ethak elam ya nena opalê?” ");
INSERT INTO hot_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma thêlô enaŋ nena, “Doho enaŋ nena o ma Jon anyô hathik ŋaŋ. Ma doho enaŋ nena o ma Elia, ma doho enaŋ nena o ma plopet bô te intu haviyô hathak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma Yisu hanaŋ hik thêlô liŋ, “Ma môlôda olam ya nena opalê?” Ma Pita hanaŋ viyaŋ nena, “O ma Mesia atu ba Wapômbêŋ hêv ek nêm anêŋ avômalô bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Êŋ ma Yisu hanaŋ lôklokwaŋ hadêŋ thêlô ek miŋ nenaŋ abô êŋ bêŋ êndêŋ anyôla ami. ");
INSERT INTO hot_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma yani hanaŋ nena, “Anyô Anêŋ Nakaduŋ atu tem esopa Wapômbêŋ anêŋ lahaviŋ ba enja vovaŋ bêŋ anôŋ. Ma Islael iniŋ ŋê bêŋbêŋ lôk ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ tem nêmbôliŋ dômiŋ êndêŋ yani. Ma Wapômbêŋ tem indum ba nijik yani vônô. Ma êtôm wak lô ma tem injik yani liŋ imbiyô esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma yani hanaŋ hadêŋ avômalô sapêŋ nena, “Anyôla hadum ek esopa ya, êŋ ma êmbôliŋ dôm êndêŋ yanida ma enja anêŋ alovalaŋaŋsiŋ êtôm wak nômbêŋ intu sapêŋ ba esopa ya. ");
INSERT INTO hot_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ek malê nena ôpatu ba lahabi bêŋ anôŋ hathak anêŋ lôkmala pik ma anêŋ lôkmala êŋ tem nêm yak. Ma doŋtom ôpatu ba hatak anêŋ lôkmala ek hasopa ya, yani êŋ tem enja lôkmala anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Anyô te hawa nômkama pik sapêŋ, ma doŋtom miŋ hasopa Wapômbêŋ ami ba anêŋ lôkmala hêv yak, êŋ ma tem yani êmô mavi e? Mi anôŋ, tem enja vovaŋ. ");
INSERT INTO hot_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma anyôla mama ek ya lôk yenaŋ abô, ma embeŋ yam atu ba ya Anyô Anêŋ Nakaduŋ yandealêm imbiŋ yenaŋ deda lôkmaŋgiŋ lôk lambô ma aŋela matheŋ iniŋ deda lôkmaŋgiŋ, ma tem ya mama ek ôpêŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aêŋ ba yanaŋ avanôŋ êndêŋ môlô nena Wapômbêŋ anêŋ loŋ lôkliŋyak tem êlêm. Ma môlô vi atu ba umiŋ loŋ êntêk tem nômô lôkmala denaŋ ma ôŋgô nôm êŋ imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ma Yisu hanaŋ abô êŋ yôv ma wak baheŋvi ba lahavulô hale ba hi. Ma Yisu hathak dumlolê te ba hi ek eteŋ mek ma hawa Pita lo Jems ma Jon iviŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yisu hateŋ mek denaŋ ma thohavloma habitak yaŋda ba anêŋ kwêv habitak thapuk hatôm damak hêv. ");
INSERT INTO hot_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ma ketheŋ oyaŋ ma anyô lokwaŋju lôk deda bêŋ imiŋ ba enaŋ abô haviŋ yani, yaŋ ma Mose ma yaŋ ma Elia. Thai enaŋ abô hadêŋ Yisu hathak nôm takatu ba Yisu tem indum ba injik anôŋ êmô Jelusalem endeba yani etak pik êntêk ba ni. ");
INSERT INTO hot_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ma Pita lo Jems ma Jon thêlô maleŋ hatulak ba êk sôm. Ma thêlô iviyô ma êyê Yisu anêŋ deda bêŋ lôk anyô ju imiŋ iviŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma thai idum ek ini ma Pita hanaŋ hadêŋ Yisu aêntêk, “Anyô bêŋ, mavi anôŋ ek lêk alalô amô loŋ êntêk. Yêlô nadav unyak lôkkupik lokwaŋlô, te ek o ma te ek Mose ma te ek Elia.” Pita hathôŋ abô atu ba enaŋ ba intu hanaŋ aêŋ. ");
INSERT INTO hot_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita hanaŋ abô denaŋ ma buliv te hayô hava thêlô siŋ ba thêlô êkô. ");
INSERT INTO hot_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma abô te halêm anêŋ buliv êŋ kapô nena, “Intu ma yenaŋ Okna ba bôk yahatak yani yôv ek indum yenaŋ ku. Ba nodaŋô anêŋ abô.” ");
INSERT INTO hot_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Abô êŋ habitak yôv ma thêlô êyê Yisu iyom hamiŋ. Pita lo Jems ma Jon miŋ enaŋ hadêŋ anyôla hathak nôm takatu ba êyê lo elaŋô ami. ");
INSERT INTO hot_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Haviyô hayaŋ ma Yisu thêlô etak dumlolê hêk ma êlôk ba i, ma avômalô bêŋ anôŋ i êpôm yani. ");
INSERT INTO hot_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma anyô te halam aêntêk, “Kêdôŋwaga, hatôm nêm kapôlôm ek yenaŋ okna ba nêm yani sa ek malê nena yenaŋ okna doŋtom iyom. ");
INSERT INTO hot_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ŋgôk te hathak hayôkwiŋ yani ba ketheŋ oyaŋ ma yani halaŋ boloba ba halowaliŋ kambom ba wapôk habitak abôlêk. Ŋgôk êŋ habuliŋ yani liŋkupik kambom anôŋ ba miŋ hathak hatak yani dokte ami. ");
INSERT INTO hot_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yahanaŋ hik anêm ŋê ku liŋ lôklokwaŋ ek nênêm ŋgôk kambom êŋ vê, ma doŋtom thêlô miŋ hatôm ami.” ");
INSERT INTO hot_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ma Yisu hanaŋ viyaŋ nena, “Yahamô haviŋ môlô sawa daim ma doŋtom miŋ ôêvhaviŋ ami ma owa auk lokbaŋ aleba yakapôlôŋ lêk hagiap hathak môlô. Onja okna êŋ êlêm.” ");
INSERT INTO hot_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ma okna êŋ haveŋ denaŋ, ma ŋgôk êŋ habi vôkê halôk pik ba hadum ba okna halowaliŋ kambom. Ma doŋtom Yisu hathaŋ ŋgôk lelaik êŋ, ma hadum okna êŋ ba habitak mavi ma hêv hi hadêŋ lambô hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma avômalô sapêŋ esoŋ kambom hathak Wapômbêŋ anêŋ lôklokwaŋ bêŋ. Avômalô sapêŋ leŋiŋhabi abô bêŋ anôŋ hathak nôm takatu ba Yisu hadum, ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, ");
INSERT INTO hot_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Môlô nodaŋô abô êntêk katô. Tem nenaŋ Anyô Anêŋ Nakaduŋ atu bêŋ ba netak êndôk avômalô baheŋiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma anêŋ ŋê ku êthôŋ abô êŋ anêŋ ôdôŋ paliŋ ek malê nena havuŋ ek thêlô. Ma êkô ek nenaŋ injik yani liŋ ek enaŋ anêŋ ôdôŋ bêŋ êndêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ma Yisu anêŋ ŋê ku êkôki nena thêlô alisê intu bêŋ ek ŋê ku vi. ");
INSERT INTO hot_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma Yisu hayala thêlôniŋ auk êŋ. Ma hawa amena te ba hadô hamiŋ habobo yani. ");
INSERT INTO hot_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ma hanaŋ hadêŋ anêŋ ŋê ku nena, “Ôpatu ba hêvhaviŋ ya ba hawa amena nate aêntêk thô, ma hatôm hawa ya thô. Ma ôpatu ba hawa ya thô, ma hatôm hawa ôpatu ba hêv ya ba yahalêm thô haviŋ. Ma ôpatu ba hadum i aleba yaôna hamô môlô malêvôŋ intu anyô bêŋ ek môlô.” ");
INSERT INTO hot_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma Jon hanaŋ nena, “Anyô Bêŋ, yêlô ayê anyô te hêv ŋgôk vê hathak anêm athêŋ. Ma doŋtom yani ma miŋ alalô te ami ba intu yêlô anaŋ ek yani etak ku êŋ.” ");
INSERT INTO hot_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma doŋtom Yisu hanaŋ nena, “Dô! Miŋ numiŋ yani loŋ siŋ ami. Ôpatu ba miŋ hapôlik hathak alalô ami, intu alalôaniŋ te.” ");
INSERT INTO hot_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Waklavôŋ Wapômbêŋ enja Yisu ni leŋ lêk habobo, êŋ ma yani lavidoŋ ek ni Jelusalem. ");
INSERT INTO hot_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma yani hêv anyô doho ba i malak te hêk Samalia ek nêpôpêk nômkama êmôŋ ek yani. ");
INSERT INTO hot_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma doŋtom avômalô loŋ êŋ êdô neja yani thô ek malê nena hi Jelusalem. ");
INSERT INTO hot_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma ŋê ku Jems lo Jon êyê nôm êŋ ma enaŋ hik yani liŋ aêntêk, “Anyô Bêŋ, yai nandam atum êndôk ba êlêm anêŋ leŋ ek esaŋ thêlô e?” ");
INSERT INTO hot_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma doŋtom Yisu hik i liliŋ ma hayanda thai. ");
INSERT INTO hot_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma thêlô i malak yaŋ. ");
INSERT INTO hot_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Thêlô eveŋ loŋôndê ba i ma anyô te hanaŋ nena, “Loŋ nômbêŋ atu ba hu ma tem yasopa o.” ");
INSERT INTO hot_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma Yisu hanaŋ, “Avuŋ yatap iniŋ pik abyaŋ hamô ma menak iniŋ unyak hamô aliŋ, ma doŋtom ya Anyô Anêŋ Nakaduŋ atu ma yenaŋ loŋ yaŋgêk ma mi.” ");
INSERT INTO hot_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma Yisu hanaŋ hadêŋ anyô yaŋ nena, “Osopa ya.” Ma doŋtom ôpêŋ hanaŋ, “Anyô Bêŋ, otak ya ek yana yandav wakamik vêmam.” ");
INSERT INTO hot_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma Yisu hanaŋ hadêŋ yani, “Dô, ŋê ŋama da nedav iniŋ ŋama. Ma nu onaŋ abô esak Wapômbêŋ anêŋ loŋ lôkliŋyak bêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma anyô yaŋ hanaŋ hadêŋ Yisu nena, “Anyô Bêŋ, tem yasopa o, ma doŋtom otak ya ek yanaŋ waklêvôŋ êndêŋ yenaŋ avômalô vêmam.” ");
INSERT INTO hot_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma Yisu hanaŋ viyaŋ nena, “Ôpatu ba haveŋ loŋôndê ma hik ma liliŋ miŋ hatôm indum ku ênjêk Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ami ma mi.” ");
INSERT INTO hot_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yôv ma Anyô Bêŋ hatak avômalô yaŋda hatôm 72 ba hêv i juju ba êmôŋ ek yani ba i hadêŋ malak lôŋ sapêŋ atu ba yani tem ni. ");
INSERT INTO hot_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma yani hanaŋ hadêŋ thêlô nena, “Nôm bêŋ anôŋ lêk hayôk ba hamô ku kapô, ma doŋtom ŋê ku ma tomtom iyom. Aêŋ ba noteŋ mek êndêŋ ku anêŋ alaŋ ek nêm ŋê ku ba ini ek nindum anêŋ ku. ");
INSERT INTO hot_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Môlô nu. Yahêv môlô ba u hatôm boksipsip nali i êmô avuŋ yatap malêvôŋ. ");
INSERT INTO hot_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ma miŋ môlô noja valuseleŋ lôk vak lôk bokŋgôp imbiŋ ami. Ma miŋ nonaŋ abô pôk embeŋ loŋôndê ami ma unu nundum ku êŋ ketheŋ. ");
INSERT INTO hot_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Môlô ôyô unyak te kapô, ma nonaŋ êndêŋ thêlô aêntêk, ‘Wapômbêŋ hatôm indum ba môlô nômô yôhôk mavi.’ ");
INSERT INTO hot_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Anyô yôhôk te hamô unyak êŋ ba hêvhaviŋ, êŋ ma tem môlônim abô mavi êŋ êmô imbiŋ thêlô. Ma mi, ma tem abô êŋ êmbôlêm ek môlôda esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ma môlô nômô unyak êŋ iyom. Ma môlô oŋgwaŋ ba nunum êtôm atu ba êv hadêŋ môlô iyom ek malê nena môlô ma ŋê ku ba mavi ek avômalô neyabiŋ môlô. Ma miŋ môlô unu nosak unyak mayaliv ami. ");
INSERT INTO hot_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Môlô ôyô malak lôŋ te ba ewa môlô thô ba êv nôm hadêŋ môlô, êŋ ma môlôŋgaŋ. ");
INSERT INTO hot_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma môlô nundum thêlôniŋ avômalô lôk lijiŋ nimbitak mavi, ma môlô nonaŋ aêntêk, ‘Wapômbêŋ anêŋ loŋ lôkliŋyak lêk halêm habobo môlô.’ ");
INSERT INTO hot_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma doŋtom miŋ ewa môlô thô ami, êŋ ma môlô unu numiŋ loŋôndê ma nonaŋ nena, ");
INSERT INTO hot_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yêlô ik voŋgovaŋ veŋiŋkapô vê halôk môlô malemim ek injik môlônim kambom thô. Ba intu môlô lemim imbi katô nena Wapômbêŋ anêŋ loŋ lôkliŋyak lêk halêm habobo môlô.’ ");
INSERT INTO hot_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yanaŋ êndêŋ môlô nena waklavôŋ atu ba Wapômbêŋ endelêm ek endaŋô abô, êŋ ma avômalô loŋ atu ba miŋ ewa môlô thô ami, thêlôniŋ malaiŋ tem êmôŋ ek avômalô kambom anêŋ Sodom. ");
INSERT INTO hot_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Alikaknena, môlô avômalô Kolasin lo Betsaida! Môlô bôk ôyê nômbithi lomaloma. Ma doŋtom bôk yandum nômbithi takêŋ êmô Taia lo Saidon malêvôŋ, êŋ ma ketheŋ oyaŋ ma tem nijik kwêv kambom lôk nesav atum ŋgavu esak leŋiŋkadôk ek nede kapôlôŋiŋ liliŋ. ");
INSERT INTO hot_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Waklavôŋ atu ba Wapômbêŋ endelêm ek endaŋô abô, êŋ ma môlônim malaiŋ tem bêŋ anôŋ êmôŋ ek avômalô Taia lo Saidon iniŋ! ");
INSERT INTO hot_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma môlô avômalô Kapaneam, tem nêmbô môlônim athêŋ esak leŋ e? Mi, môlô tem unu ŋê ŋama iniŋ loŋ! ");
INSERT INTO hot_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Anyô halaŋô môlônim abô, êŋ ma yani halaŋô yenaŋ abô haviŋ. Ma anyô havôliŋ dôm hadêŋ môlô, êŋ ma yani havôliŋ dôm hadêŋ ya haviŋ. Ma anyô havôliŋ dôm hadêŋ ya, êŋ ma yani havôliŋ dôm hadêŋ Ôpatu ba hêv ya ba yahalêm haviŋ.” ");
INSERT INTO hot_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ŋê ku 72 takatu êvôlêm hathak loŋbô ma leŋiŋmavi bêŋ anôŋ ba enaŋ, “Anyô Bêŋ, yêlô adum ku lomaloma lôk êv ŋgôk vê hathak anêm athêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma Yisu hanaŋ aêntêk, “Yahayê Sadaŋ hêv yak anêŋ leŋ hatôm damak. ");
INSERT INTO hot_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Odaŋô, yahêv lôklokwaŋ hadêŋ môlô ek nombak umya lo daŋgaviŋ pesa. Ma môlô hatôm nômô Sadaŋ ôpatu ba lamaniŋ hathak môlô anêŋ lôklokwaŋ sapêŋ lu. Ma nômlate miŋ hatôm imbuliŋ môlô ami ma mi. ");
INSERT INTO hot_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ma môlô miŋ lemimmavi bêŋ anôŋ esak ŋgôk elaŋô môlônim abô ami ma mi, ma doŋtom môlô lemimmavi esak Wapômbêŋ bôk hato môlônim athêŋ hêk leŋ.” ");
INSERT INTO hot_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yôv ma Lovak Matheŋ hadum Yisu anêŋ kapô lamavi ba hanaŋ, “Wakamik, O ma leŋ lo pik anêŋ alaŋ! Lêk huvuŋ anêm auk hadêŋ ŋê lôkauk lôk ŋê bêŋbêŋ ma huik thô hadêŋ ŋê takatu ba êtôm avômena yaônena. Ba intu yahabô anêm athêŋ! Wakamik, avanôŋ oda hosopa anêm lemhaviŋ ba intu hudum aêŋ. ");
INSERT INTO hot_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Wakamik bôk hôêv ya auk sapêŋ yôv. Ba anyô late miŋ hayala Nalum atu ami. Mi, O Wakamik iyom. Ma anyô late miŋ hayala O Wakamik katô ami. Mi, Nalum lôk ŋê takatu ba Nalum lahaviŋ injik O thô êndêŋ i iyom.” ");
INSERT INTO hot_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ma Yisu hik i liliŋ ba hanaŋ hadêŋ anêŋ ŋê ku iyom nena, “Wapômbêŋ hadum mavi hadêŋ môlô ba môlô ôyê nôm takatu. ");
INSERT INTO hot_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yanaŋ êndêŋ môlô nena sêbôk ma plopet lôk kiŋ bêŋ anôŋ leŋiŋhaviŋ nêgê nôm êntêk ba lêk môlô ôyê, ma doŋtom miŋ êyê ami. Ma leŋiŋhaviŋ nedaŋô abô takêntêk ba lêk môlô olaŋô, ma doŋtom miŋ elaŋô ami.” ");
INSERT INTO hot_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wak te ma anyô lôkauk hathak abô balabuŋ hayô hamiŋ ba hadum ek esaê Yisu ba hanaŋ, “Kêdôŋwaga, yandum malê ek Wapômbêŋ nêm lôkmala atu ba nêmô êtôm wak nômbêŋ intu sapêŋ êndêŋ ya?” ");
INSERT INTO hot_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma Yisu hanaŋ hik yani liŋ aêntêk, “Abô balabuŋ hanaŋ malê? Êŋ ma oda osam abô êŋ ba lemimbi nena abô êŋ hanaŋ aisê?” ");
INSERT INTO hot_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma yani hanaŋ nena, “Lemimimbiŋ Anyô Bêŋ unim Wapômbêŋ ênjêk unim kapôlômim lôk dahôlômim ma lôklokwaŋ lôk unim auk sapêŋ. Ma lemimbiŋ anêm avômalô êtôm lemhaviŋ oda.” ");
INSERT INTO hot_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma Yisu hanaŋ nena, “Avanôŋ. Undum aêŋ ma tem ômô lôkmala.” ");
INSERT INTO hot_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma doŋtom yani hadum ek avômalô nêgê nena anêŋ auk ma mavi, aêŋ ba yani hanaŋ nena, “Yenaŋ avômalô êŋ ma opalêla?” ");
INSERT INTO hot_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma Yisu hanaŋ viyaŋ aêntêk, “Anyô te hatak Jelusalem ma halôk ba hi Jeliko. Êŋ ma ŋê vani êpôm yani ba ik yani ba hamayak hêk loŋôndê ma ewa anêŋ nômkama vani ba i. ");
INSERT INTO hot_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma anyô habôk da te hasopa loŋôndê êŋ ba halôk ba hi. Êŋ ma yani hayê anyô êŋ, ma doŋtom yani habup halôk loŋôndê vi hale ba hi. ");
INSERT INTO hot_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aêŋ iyom ma Livai te halôk loŋôndê bô êŋ hale ma hayê ôpêŋ, ma ketheŋ oyaŋ habup halôk loŋôndê vi atu hale ba hi. ");
INSERT INTO hot_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma doŋtom anyô Samalia te halom loŋôndê êŋ ba hi ma hayê ôpêŋ ba lahiki. ");
INSERT INTO hot_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Êŋ ma yani hi hadêŋ ôpêŋ ma haŋgasô waiŋ lôk nôm lêŋlêŋ hathak ôpêŋ anêŋ palê ma hasum. Yôv ma yani hawa ôpêŋ ba hatak hayô hamô anêŋ bok doŋki ma halom ba hi unyak atu ba êv vuli ba êk. Ma yanida hayabiŋ ôpêŋ. ");
INSERT INTO hot_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma haviyô hayaŋ ma yani hêv valuseleŋ seleva ju hadêŋ unyak alaŋ ma hanaŋ nena, ‘Oyabiŋ anyô lijiŋ êntêk mavi. Ma valu êntêk miŋ hatôm ami ba wak yaŋ atu ba yahalehalêm ma tem yanêm doho imbiŋ.’” ");
INSERT INTO hot_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yisu hanaŋ abô loŋ kapô êŋ yôv ma hanaŋ hik anyô lôkauk êŋ liŋ aêntêk, “Lemhabi aisê? Ôpatu ba ŋê kambom ik ma opalê hêv yani sa hatôm yanida anêŋ avômalô te?” ");
INSERT INTO hot_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma anyô lôkauk hanaŋ viyaŋ nena, “Ôpatu ba hêv kapô hadêŋ yani.” Ma Yisu hanaŋ hadêŋ ôpêŋ nena, “Nu ma undum aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yisu lôk anêŋ ŋê ku eveŋ ba i ma Yisu habitak hayô malak lôŋ te ba hi. Ma avi te anêŋ athêŋ nena Mata hawa Yisu thô ba hi hamô anêŋ unyak. ");
INSERT INTO hot_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata anêŋ yaŋ molok Malia hamô habobo Anyô Bêŋ valuvi ba halaŋô anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma doŋtom Mata hadum ku bêŋ anôŋ ek hapôpêk nôm. Êŋ ma yani hi hadêŋ Yisu ma hanaŋ, “Anyô Bêŋ, lemhabi aisê? Yahadum ku bêŋ anôŋ ma yenaŋ aiyaŋ molok miŋ hêv ya sa dokte ami. Ba intu otak yani êlêm ek nêm ya sa.” ");
INSERT INTO hot_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma doŋtom Anyô Bêŋ hanaŋ viyaŋ hadêŋ yani nena, “Mata, Mata, aisê ka lem hik o ba kapôlôm malaiŋ hathak nômkama lomaloma? ");
INSERT INTO hot_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ma doŋtom nômlate iyom intu ba nômbêŋ ma Malia lêk hawa nôm êŋ yôv ba anyô te miŋ hatôm enja nôm êŋ vê ênjêk yani ami ma mi.” ");
INSERT INTO hot_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wak te ma Yisu hateŋ mek hamô bute. Ma hateŋ mek yôv ma anêŋ ŋê ku te hanaŋ hadêŋ yani nena, “Anyô Bêŋ, ôndôŋ yêlô ek yêlô nateŋ mek êtôm sêbôk ba Jon hadôŋ anêŋ ŋê ku.” ");
INSERT INTO hot_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ma Yisu hanaŋ, “Môlô noteŋ mek aêntêk, “‘Wakamik, anêm athêŋ ênjêk matheŋ. Ma anêm loŋ lôkliŋyak êlêm êtôm loŋ lôkthô. ");
INSERT INTO hot_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ma nêm wak tomtom anêŋ nôm êndêŋ yêlô. ");
INSERT INTO hot_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma yêlô êv avômalô iniŋ kambom takatu ba idum hadêŋ yêlô vê, ba intu nêm yêlôaniŋ kambom vê aêŋ iyom. Lôk miŋ otak yêlô êndôk nôm atu ba esau yêlô ami.’” ");
INSERT INTO hot_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yôv ma Yisu hanaŋ abô loŋ kapô te hadêŋ thêlô aêntêk, “Bôlôvôŋ biŋ te ma hu hadêŋ anêm anyô môlô te anêŋ unyak ma honaŋ, ‘Aiyaŋ, yenaŋ anyô môlô te halêm anêŋ loŋ daim ba lêk hamô yenaŋ unyak ba hama kisi ma ya nôm mi. Ba hatôm nêm polom lokwaŋlô ek yani e?’ ");
INSERT INTO hot_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma anêm anyô môlô atu hamô unyak kapô tem enaŋ viyaŋ nena, ‘Yahadô. Yêlô lêk êk sôm ba unyak abôlêk lêk putup yôv ba tem miŋ yanêm nôm êndêŋ o ami ma mi.’ ");
INSERT INTO hot_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yani hadô ek nêm anêŋ anyô môlô sa. Ma doŋtom yahanaŋ hadêŋ môlô nena oteŋ lôbôlôŋ, êŋ ma tem yani mama ba imbiyô ba nêm nôm êtôm atu ba hoteŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","“Ba intu yahanaŋ hadêŋ môlô nena ŋê takatu ba enaŋ hik Wapômbêŋ liŋ, ma tem neja nômkama êtôm atu ba enaŋ. Ma êbôlêm nômlate ma tem nêpôm. Ma ipididiŋ unyak abôlêk ma tem injik vê ek i. Aêŋ ba onaŋ hik Wapômbêŋ liŋ ma tem nêm môlônim lemimhaviŋ êndêŋ môlô. Ma ôbôlêm ma tem nôpôm. Ma upididiŋ unyak abôlêk ma tem injik vê ek môlô. ");
INSERT INTO hot_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Môlô avômena iniŋ lami, nalum hanaŋ hik o liŋ ek enjaŋ alim ma tem nêm umya kambom te êndêŋ yani e? Ma mi! ");
INSERT INTO hot_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mena yani hanaŋ ek enjaŋ menak daluk, êŋ ma tem nêm ŋgalivaŋ te e? Ma mi! ");
INSERT INTO hot_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Môlô avômalô pik unim bôk lo loŋ ma kambom, ma doŋtom môlô othak ôêv nômkama mavi hadêŋ nalumi. Aêŋ ba môlô noyala katô nena môlônim Lemambô Bêŋ atu ba hamô malak leŋ yani lamavi anôŋ ek nêm Lovak Matheŋ êndêŋ ŋê takatu ba enaŋ hik yani liŋ.” ");
INSERT INTO hot_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yisu hêv ŋgôk vê hêk anyô abôlêk putup te. Ma ŋgôk êŋ hatak ôpêŋ ba hi ma ôpêŋ hanaŋ abô ba avômalô sapêŋ êyê ba esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma doŋtom avômalô doho enaŋ, “Ŋgôk iniŋ anyô bêŋ Belsebul hêv lôklokwaŋ hadêŋ ôpêŋ. Ba intu hatôm nêm ŋgôk sapêŋ vê ênjêk avômalô.” ");
INSERT INTO hot_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma avômalô doho idum ek nesau Yisu ba enaŋ hik yani liŋ nena, “Undum lavôŋiŋ te ek injik thô nena Wapômbêŋ hêv o ba hôlêm mena mi e?” ");
INSERT INTO hot_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma doŋtom Yisu hayala thêlôniŋ auk ba hanaŋ abô loŋ kapô te hadêŋ thêlô nena, “Avômalô malak lôŋ te evaki vose hi ôdôŋ ju, êŋ ma tem malak lôŋ êŋ ŋgathiniŋ ba bapu ipup imbitak. Ma avômalô ôdôŋ te evaki vose hi ôdôŋ ju ma tem thêlôda nênêm yak. ");
INSERT INTO hot_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aêŋ ba Sadaŋ anêŋ ŋgôk vi evaki vose hi ôdôŋ ju, êŋ ma Sadaŋ anêŋ loŋ lôkliŋyak tem imiŋ majaŋ aisê? Mi. Ma aisê ka môlô onaŋ nena yahêv ŋgôk vê hathak Belsebul anêŋ lôklokwaŋ? ");
INSERT INTO hot_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Môlô onaŋ nena ŋgôk bêŋ Belsebul hêv lôklokwaŋ hadêŋ ya ba yahêv ŋgôk vê. Ma môlônim avômalô idum ku êŋ haviŋ! Ma opalê intu hêv lôklokwaŋ hadêŋ thêlô ba idum ku mavi êŋ? Ŋgôk Bêŋ, e? Mi! Môlôda unim avômalô ik thô nena môlô onaŋ abôyaŋ. ");
INSERT INTO hot_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wapômbêŋ da hêv lôklokwaŋ hadêŋ ya ba yahêv ŋgôk vê hêk avômalô. Aêŋ ba oyala nena Wapômbêŋ anêŋ loŋ lôkliŋyak lêk halêm yôv. ");
INSERT INTO hot_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Anyô lôklokwaŋ te havaloŋ nômkama vovak ba hayabiŋ anêŋ loŋ, êŋ ma anêŋ nômkama tem êmô mavi. ");
INSERT INTO hot_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma doŋtom anyô vovak laik môŋ hayô ba hik vovak hadêŋ ôpêŋ aleba hamô lu, êŋ ma yani tem enja ôpêŋ anêŋ nômkama vovak takatu ba bôk hadum ôpêŋ ba habitak lôklokwaŋ vê. Aêŋ ba ôpatu ba lovak ma tem imbi yaŋ atu ba hêv yak anêŋ nômkama sam. ");
INSERT INTO hot_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Anyôla miŋ hêv ya sa ek yai naŋgik vovak êndêŋ Sadaŋ ami, ôpêŋ hatôm haviŋ Sadaŋ ba thai ik vovak hadêŋ ya. Ma anyô miŋ hêv ya sa ba hasup avômalô hathak doŋtom ami, êŋ ma hatôm halupuniŋ i ba êsôv mayaliv.” ");
INSERT INTO hot_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ŋgôk lelaik hatak anyô te, êŋ ma hi haveŋ loŋ thiliv ek êmbôlêm loŋ mavi te ek enja lovak ba êmô. Ma miŋ hapôm loŋ te ami ma tem enaŋ nena, ‘Yatup siŋ yana unyak sêbôk esak loŋbô.’ ");
INSERT INTO hot_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma hayô ba hayê nena unyak êŋ lêk epesaŋ ba habitak mabuŋ mavi. ");
INSERT INTO hot_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Êŋ ma tem ni êmbôlêm ŋgôk baheŋvi ba lahavuju takatu ba iniŋ lôklokwaŋ hamôŋ ek anêŋ ba enja i imbiŋ ek nimbitak nêyô unyak êŋ kapô esak loŋbô. Êŋ ma ôpêŋ tem êmô kambom anôŋ ek yaŋ sêbôk.” ");
INSERT INTO hot_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yisu hanaŋ abô takêŋ hamô denaŋ ma avi te hamiŋ avômalô nômbêŋ êŋ malêvôŋ ma halam aêntêk, “Avi atu ba havathu o ba hêv sum hadêŋ o, yani êŋ êmô lôk lamavi.” ");
INSERT INTO hot_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma doŋtom Yisu hanaŋ, “Ôpatu ba halaŋô Wapômbêŋ anêŋ abô ba hasopa, yani êŋ êmô lôk lamavi anôŋ.” ");
INSERT INTO hot_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Avômalô bêŋ anôŋ êyô ek Yisu. Êŋ ma Yisu hanaŋ, “Avômalô bôlôŋ êntêk ma avômalô kambom. Thêlô enaŋ ek yandum lavôŋiŋ ek injik thô nena Wapômbêŋ bôk hêv ya ba yahalêm, ma doŋtom tem mi. Thêlô tem nêgê Jona anêŋ lavôŋiŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sêbôk ma Jona habitak hatôm lavôŋiŋ ek avômalô Ninive. Ma lêk Anyô Anêŋ Nakaduŋ atu tem imbitak aêŋ iyom êndêŋ avômalô bôlôŋ êntêk. ");
INSERT INTO hot_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Sêbôk ma Siba iniŋ kwin hatak anêŋ loŋ ma halêm anêŋ pik anêŋ daŋ ek endaŋô Solomon anêŋ auk mavi. Odaŋô! Nômlate hamô loŋ êntêk ma bêŋ ek Solomon. Ma doŋtom môlô ôdô anêŋ nodaŋô. Ma waklavôŋ atu ba Wapômbêŋ hatak ek nindum abô ma Siba iniŋ kwin êŋ tem enaŋ môlônim kambom takêŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma sêbôk ba avômalô Ninive elaŋô Jona anêŋ abô ba ele kapôlôŋiŋ liliŋ. Ma nômlate lêk hamô loŋ êntêk ma bêŋ ek Jona. Ma doŋtom môlô ôdô anêŋ nodaŋô. Ma waklavôŋ atu ba Wapômbêŋ hatak ek nindum abô ma tem avômalô Ninive nimiŋ ba nenaŋ môlônim kambom takêŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Anyô miŋ ethak êtôm atum ba ivuŋ hamô lôŋ kapô mena êdô hamô uŋ kapô ami ma mi. Thêlô êthôkwêŋ hamiŋ ek avômalô takatu ba êyô unyak kapô tem nêgê deda. ");
INSERT INTO hot_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Malem daluk ma hatôm atum ek nêm deda êndêŋ lemvimkupik. Malem daluk mavi ma tem deda êmô lemvimkupik sapêŋ. Ma doŋtom malem daluk kambom ma tem momaŋiniŋ bêŋ ênjêk lemvimkupik. ");
INSERT INTO hot_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aêŋ ba nôŋgô katô nena anêm deda ma deda anôŋ ek malê nena deda doho ma hatôm momaŋiniŋ. ");
INSERT INTO hot_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ma deda hamô lemvimkupik sapêŋ, ma momaŋiniŋ miŋ hêk bute ami. Êŋ ma lemvimkupik sapêŋ tem imbitak deda êtôm atum habi malem loŋ.” ");
INSERT INTO hot_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisu hanaŋ abô yôv ma Palisi te hanaŋ hik Yisu liŋ ek enjaŋ nôm êmô imbiŋ yani. Êŋ ma Yisu hi hayô ôpêŋ anêŋ unyak kapô. ");
INSERT INTO hot_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma Palisi êŋ hayê Yisu halôk hamô ek enjaŋ nôm ma miŋ hathik i ami. Êŋ ma yani hasoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma Yisu hanaŋ hadêŋ yani nena, “Môlô ŋê Palisi, môlô othak uthik unim tase lôk belev anêŋ vidôm iyom, ma doŋtom môlônim kapôlômim putup hathak kobom vani lo kobom kambom. ");
INSERT INTO hot_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Môlô ŋê molo, Wapômbêŋ hapesaŋ viyaiŋ lôk vikapô haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ma doŋtom môlônim nômkama takatu ba hamô ma môlô nônêm êndêŋ ŋê nômkama mi ek nêm thêlô sa. Môlô nundum aêŋ ma tem môlônim nômkama sapêŋ êmô mabuŋ mavi ênjêk Wapômbêŋ ma. ");
INSERT INTO hot_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Alikaknena môlô ŋê Palisi, vovaŋ bêŋ tem êpôm môlô. Môlô othak usup ava takatu ba hadum nôm vasiŋ ba uik sam hi ôdôŋ laumiŋ ba ôêv ôdôŋ te hadêŋ Wapômbêŋ hatôm da. Kobom êŋ ma nôm yaôna. Ma doŋtom môlô otak kobom thêthôŋ lôk kobom lemimimbiŋ Wapômbêŋ. Kobom êntêk ma nômbêŋ! Nodaŋô! Môlô nosopa abô balabuŋ bêŋ takêntêk lôk abô balabuŋ yaônena imbiŋ! ");
INSERT INTO hot_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Alikaknena môlô ŋê Palisi, vovaŋ bêŋ tem êpôm môlô! Môlô lemimhaviŋ nômô êtôm ŋê bêŋbêŋ êmô unyak yeŋ kapô lôk lemimhaviŋ avômalô nenaŋ, ‘Waklêvôŋ anyô bêŋ’ êndôk loŋ ethak doŋtom halôk. ");
INSERT INTO hot_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Alikaknena, vovaŋ bêŋ tem êpôm môlô. Môlô lelaik hatôm ŋama te atu ba bôk elav bô ma lêk miŋ anyôla hayala ami. Ba intu avômalô êyô imiŋ ba ibitak lelaik hamô Wapômbêŋ ma. Aêŋ ba avômalô takatu ba ele ebobo môlô ma ibitak lelaik aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ŋê eyala abô balabuŋ te halaŋô abô êŋ ma hanaŋ hadêŋ Yisu aêntêk, “Kêdôŋwaga, honaŋ abô êŋ hadêŋ ŋê Palisi ma huik yêlô susu haviŋ.” ");
INSERT INTO hot_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Yisu hanaŋ, “Alikaknena môlô ŋê lôkauk hathak abô balabuŋ haviŋ, vovaŋ bêŋ tem êpôm môlô. Môlô ôêv balabuŋ anêŋ malaiŋ lomaloma hadêŋ avômalô ek nesopa. Nôm êŋ ma hatôm vak malaiŋ kambom ek thêlô. Ma doŋtom môlô miŋ ôêv thêlô sa dokte ami. ");
INSERT INTO hot_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“Alikaknena, vovaŋ bêŋ tem êpôm môlô. Môlônim libumi bôk ik plopet bêŋ anôŋ vônô ma môlô oyabiŋ iniŋ siô dedauŋ mavi. Aêŋ ba hik thô nena môlô ôlôk hathak libumi iniŋ bôk lo loŋ takatu ba idum. ");
INSERT INTO hot_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ba intu Wapômbêŋ anyô lôkauk bêŋ bôk hanaŋ aêntêk, ‘Tem yanêm plopet lo aposel bêŋ anôŋ êndêŋ thêlô, ma tem thêlô nindum kambom êndêŋ doho ba nijik doho vônô.’ ");
INSERT INTO hot_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aêŋ ba avômalô bôlôŋ êntêk tem neja vovaŋ bêŋ esak plopet takatu ba ik vônô hadêŋ waklavôŋ Wapômbêŋ hapesaŋ pik aleba lêk. ");
INSERT INTO hot_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Plopet môŋ atu ba ik vônô ma Abel ma ik aêŋ habup hathak aleba hayô Sekalaia ma anêŋ daŋ. Ik yani vônô hêk unyak matheŋ lôk loŋ êbôk da anêŋ malêvôŋ. Avanôŋ, yanaŋ êndêŋ môlô, vuli kambom hathak bôk lo loŋ takêŋ tem imbitak êpôm avômalô bôlôŋ êntêk. ");
INSERT INTO hot_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Alikaknena môlô ŋê uik abô majaŋ thô, vovaŋ bêŋ tem êpôm môlô! Môlô umiŋ auk mavi anêŋ loŋôndê loŋ siŋ. Môlôda miŋ oveŋ loŋôndê êŋ ami ma umiŋ siŋ ek avômalô takatu ba leŋiŋhaviŋ nesopa ma miŋ hatôm nesopa ami.” ");
INSERT INTO hot_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yôv ma Yisu hatak unyak êŋ ma ŋê lôkauk hathak abô balabuŋ lôk ŋê Palisi leŋiŋŋaŋa kambom ba enaŋ ik yani liŋ lomaloma. ");
INSERT INTO hot_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Thêlô idum aêŋ ek neja yani êndôk adêk esak anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Avômalô bêŋ anôŋ bomaŋ ethak doŋtom ba êyô imiŋ i pesa. Ma Yisu hanaŋ hadêŋ anêŋ ŋê ku aêntêk, “Noyabiŋ am esak Palisi iniŋ kobom kambom. Thêlô idum hatôm ŋê mavi êmô avômalô malêvôŋ, ma doŋtom auk lomaloma hêk iniŋ kapôlôŋiŋ. Nôm êŋ ma hatôm yis ba tem êmbôv avômalô bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nôm takatu ba havuŋi hêk loŋ kapô ma tem imbitak loŋ yaiŋ. Ma abô takatu ba havuŋi ma tem avômalô sapêŋ neyala. ");
INSERT INTO hot_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aêŋ ba abô takatu ba môlô onaŋ hadêŋ bôlôvôŋ ma tem avômalô nedaŋô êndêŋ lôkwak. Ma abô takatu ba môlô onaŋ thikuthik halôk unyak kapô, êŋ ma tem nimiŋ unyak vôv ba nendam bêŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Yenaŋ avômalô, yanaŋ êndêŋ môlô nena miŋ nôkô ek avômalô ami. Thêlô hatôm nijik lemvimkupik iyom vônô. Ma embeŋ yam ma tem miŋ hatôm nindum nômlate ami. ");
INSERT INTO hot_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Odaŋô tem yaŋgik ôpatu ba môlô nôkô esak thô: Nôkô ek Anyô Bêŋ. Yani hatôm injik môlô lemvimkupik vônô vêm ma imbi êndôk atum lôkmala. Ba intu nôkô ek yani iyom. ");
INSERT INTO hot_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Avômalô ethak êv vuli menak yaônena hathak valuseleŋ yaô ek eyaŋ. Ma doŋtom Wapômbêŋ miŋ hathôŋ thêlô te ami, mi. ");
INSERT INTO hot_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yani bôk hakatuŋ môlô sapêŋ lemimkadôk ŋauŋ yôv. Aêŋ ba môlô ma bêŋ ek menak, ba intu miŋ nôkô ami. ");
INSERT INTO hot_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Yanaŋ êndêŋ môlô nena ôpatu ba hanaŋ hadêŋ avômalô nena hasopa ya ma tem ya Anyô Anêŋ Nakaduŋ atu yanaŋ imiŋ Wapômbêŋ ma ba aŋela nedaŋô nena, ‘Ôpêntêk ma yenaŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma ôpatu ba hanaŋ hadêŋ avômalô nena hadô esopa ya, intu tem yanaŋ imiŋ Wapômbêŋ ma ba aŋela nedaŋô nena, ‘Yahathôŋ ôpêŋ paliŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ma anyô te hanaŋ abô kambom hathak Anyô Anêŋ Nakaduŋ atu, ma Wapômbêŋ tem nêm ôpêŋ anêŋ kambom vê. Ma doŋtom anyôla hayê Lovak Matheŋ anêŋ ku ba hanaŋ abôma nena, ‘Êntêk ma Ŋgôk Bêŋ anêŋ ku’, êŋ ma Wapômbêŋ tem miŋ nêm ôpêŋ anêŋ kambom êŋ vê ami. ");
INSERT INTO hot_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Avômalô evaloŋ môlô loŋ ba u unyak yeŋ mena êdô môlô hamiŋ ŋê bêŋbêŋ mena ŋê loŋ buyaŋ iniŋ ŋê bêŋbêŋ maleŋiŋ, êŋ ma miŋ nôkô ba nonaŋ nena, ‘Yêlô tem nanaŋ malê?’ mena ‘nanaŋ viyaŋ aisê?’ ami. Mi. ");
INSERT INTO hot_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Lovak Matheŋ tem nêm auk êndêŋ môlô ek nonaŋ.” ");
INSERT INTO hot_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anyô te hamiŋ avômalô nômbêŋ atu kapô ma hanaŋ hadêŋ Yisu aêntêk, “Kêdôŋwaga, wakamik bôk hama yôv ba onaŋ ek aiyaŋ bêŋ imbi anêŋ nômkama sam ba nêm ôdôŋ te ek ya.” ");
INSERT INTO hot_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma doŋtom Yisu hanaŋ hik ôpêŋ liŋ, “Aisête? Opalê te hatak ya ek yambitak anyô bêŋ ek yambi môlônim nômkama sam?” ");
INSERT INTO hot_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma Yisu hanaŋ hadêŋ avômalô aêntêk, “Noyabiŋ am katô ek miŋ malemimkilik ek nômkama lomaloma ami. Anyô miŋ hamô lôkmala hathak nômkama ami.” ");
INSERT INTO hot_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ma Yisu hanaŋ abô loŋ kapô te hadêŋ thêlô aêntêk, “Anyô lôk nômkama bêŋ te anêŋ nômkama hik anôŋ bêŋ anôŋ hamiŋ ku. ");
INSERT INTO hot_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Êŋ ma yani lahabi aêntêk, ‘Yatak yenaŋ nôm êmô êsê? Yenaŋ unyak kapô sapêŋ putup ba mi.’ ");
INSERT INTO hot_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ma yani hanaŋ, ‘Aêŋ ba dô ma yandum aêntêk. Yaseŋ yenaŋ unyak sapêŋ thô ma yandav unyak lukmuk bêŋbêŋ ek yandô yenaŋ nôm lôk nômkama sapêŋ êmô kapô. ");
INSERT INTO hot_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma yada yanaŋ êndêŋ ya aêntêk, “Ya ma anyô lôkmaŋgiŋ kambom. Yenaŋ nômkama bêŋ anôŋ hamô. Ba tem yaŋgaŋ lo yanum ma yamô mavi iyom êtôm wak nômbêŋ intu sapêŋ. Ma miŋ hatôm yandum ku te ami.” ’ ");
INSERT INTO hot_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ma doŋtom Wapômbêŋ hanaŋ hadêŋ ôpêŋ aêntêk, ‘O anyô molo! Bôlôvôŋ êntêk ma tem yanja anêm lôkmala vê ba oma, ma opalê tem enja nômkama takatu ba hopesaŋ ek oda?’ ");
INSERT INTO hot_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Noyabiŋ am! Avômalô takatu ba êpôm nômkama bêŋ anôŋ ek thêlôda ba leŋiŋpaliŋ Anyô Bêŋ hatôm ôpêntêk, thêlô êŋ ma nômkama mi anôŋ hêk malak leŋ.” ");
INSERT INTO hot_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Ma Yisu hanaŋ hadêŋ anêŋ ŋê ku aêntêk, “Lôkmala ma bêŋ ek nôm eyaŋ. Ma leŋviŋkupik ma bêŋ ek kwêv lo sup. Aêŋ ba intu yanaŋ êndêŋ môlô nena miŋ lemimimbi bêŋ anôŋ esak nômkama pik lomaloma êtôm kwêv mena nôm ami. ");
INSERT INTO hot_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Môlô lemimimbi menak yelam. Thêlô ku kapô mi. Ma miŋ ethak ewa nôm ba etak hamô unyak kapô ek waklavôŋ nôm mi ami. Ma doŋtom Wapômbêŋ havakôŋ thêlô. Ma môlô ma Wapômbêŋ lahaviŋ bêŋ anôŋ hamôŋ ek menak ba intu tem eyabiŋ môlô. ");
INSERT INTO hot_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma hatôm anyô te hamô ba hakôki ek êmô pik êntêk, êŋ ma tem kobom êŋ nêm yani sa ek êmô lôkmala dokte imbiŋ e? Ma mi anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Môlô miŋ hatôm nundum nôm yaôna aêŋ ami. Aêŋ ba aisê ka môlô lemimhabi bêŋ anôŋ hathak nômkama takêŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Lemimimbi alokwaŋ vuak. Thêlô miŋ idum ku lôk epesaŋ sôp ami. Ma doŋtom yanaŋ êndêŋ môlô nena alokwaŋ vuak takêŋ iniŋ lêlêyaŋ hamôŋ ek Kiŋ Solomon anêŋ nômkama mavi sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aêŋ ba Wapômbêŋ hêv sôp mavi anôŋ hadêŋ alokwaŋ vuak lo kamuŋ lomaloma atu ba êmô bidoŋ, êŋ ma anyô ethak ele ba êbôk hathak atum. Aêŋ ba môlô oyala nena Wapômbêŋ lahaviŋ bêŋ anôŋ ek nêm sôp êndêŋ môlô imbiŋ. Alikaknena, môlônim ôêvhaviŋ miŋ bêŋ ami. ");
INSERT INTO hot_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ba miŋ kapôlômim injik am esak oŋgwaŋ malê mena nunum malê ami. ");
INSERT INTO hot_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ŋê daluk ethak leŋiŋhiki ba êbôlêm nôm takêŋ, ma doŋtom môlônim Lemambô hayala môlônim malaiŋ ba tem nêm nôm takêŋ êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Aêŋ ba môlô lemim injik am ek nômbôlêm Wapômbêŋ anêŋ loŋ lôkliŋyak. Êŋ ma tem yani nêm nôm takêŋ sapêŋ êndêŋ môlô imbiŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Môlô boksipsip ôdôŋ yaôna, miŋ nôkô ami. Lemambô lamavi ek nêm loŋ lôkliŋyak êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ma môlô owa vuli hathak unim nômkama ma nônêm êndêŋ ŋê siv. Noja vak valuseleŋ atu ba tem miŋ kambom ami, ma nusup nômkama kêkêlô lomaloma ek môlô ênjêk leŋ. Loŋ êŋ ma ŋê vani lo didu mi, ba intu unim nômkama valova tem êmô. ");
INSERT INTO hot_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ma loŋ atu ba môlônim nômkama kêkêlô hamô, loŋ êŋ iyom intu tem môlônim lemimhaviŋ êmô imbiŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Môlô nôpôpêk am ek nundum ku ba intu nupuk unim sôp ma nôtôm unim atum lam ba noyabiŋ nômô ");
INSERT INTO hot_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","êtôm avômalô ku takatu ba eyabiŋ iniŋ anyô bêŋ. Thêlôniŋ anyô bêŋ bôk hi hayaŋ nôm ewa avi vêm ma tem êmbôlêm esak loŋbô. Yani havôhalêm anêŋ loŋ ba hapididiŋ unyak abôlêk ma tem nijik unyak abôlêk vê ketheŋ ba neja yani thô. ");
INSERT INTO hot_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Anyô bêŋ êŋ hayô ba hayê nena anêŋ ŋê ku eyabiŋ yani ba êmô lêlê, êŋ ma tem yani lamavi ma thêlô nêmô lôk leŋiŋmavi. Yanaŋ avanôŋ êndêŋ môlô nena anyô bêŋ êŋ tem ipuk anêŋ sôp ku ma enaŋ ek thêlô nêndôk nêmô biŋ ma yani nêm nôm êndêŋ thêlô êtôm anyô ku te. ");
INSERT INTO hot_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anyô bêŋ hale halêm hadêŋ bôlôvôŋ biŋ mena lôkbôk momaŋiniŋ ba hayê anêŋ ŋê ku miŋ êk sôm ami ma eyabiŋ yani iyom, êŋ ma tem nêm anêŋ lamavi êndêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Môlô lemimimbi abô êntêk katô. Unyak te anêŋ alaŋ halaŋô abô nena ŋê vani tem nijik anêŋ unyak vose, êŋ ma yani hêk lêlê ek ŋê vani miŋ hatôm nijik unyak êŋ vose ami. ");
INSERT INTO hot_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ma Anyô Anêŋ Nakaduŋ atu tem endelêm ba indum môlô nosoŋ kambom. Ba intu nômô lêlê aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ma Pita hanaŋ aêntêk, “Anyô Bêŋ, hôêv abô loŋ kapô êntêk hadêŋ yêlô iyom mena hôêv hadêŋ avômalô sapêŋ haviŋ e?” ");
INSERT INTO hot_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Êŋ ma Anyô Bêŋ hanaŋ nena, “Yahanaŋ hadêŋ ŋê takatu ba idum iniŋ anyô bêŋ anêŋ ku mavi êtôm anyô lôkauk bêŋ atu ba hayabiŋ nômkama mavi. Unyak alaŋ hatak yani ek eyabiŋ anêŋ ŋê ku vi ba nêm nôm êndêŋ i êtôm anêŋ wakma atu ba hatak. Vêm ma hi loŋ buyaŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ma unyak alaŋ havôhalêm hathak loŋbô ma hayê nena anyô ku êŋ hadum ku mavi, ma tem lamavi esak ôpêŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yanaŋ avanôŋ êndêŋ môlô nena unyak alaŋ êŋ tem etak ôpêŋ ek eyabiŋ anêŋ nômkama sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma doŋtom anyô ku êŋ lahabi hêk kapô nena, ‘Lêk sawa daim ma yenaŋ anyô bêŋ miŋ havôhalêm ketheŋ ami.’ Êŋ ma hik anyô lo avi ku vi ma hayaŋ nôm lôk hanum waiŋ bêŋ anôŋ aleba halo molo. ");
INSERT INTO hot_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Hadum aêŋ ba hathôŋ paliŋ ma unyak alaŋ tem êyô ba indum ôpêŋ esoŋ kambom. Êŋ ma unyak alaŋ tem nêm vovaŋ bêŋ êndêŋ yani ma êndô ôpêŋ êmô imbiŋ ŋê takatu ba miŋ êvhaviŋ ami. ");
INSERT INTO hot_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Anyô ku atu ba hayala anêŋ anyô bêŋ anêŋ lahaviŋ ma doŋtom miŋ hapesaŋ nômkama ba hasopa anêŋ anyô bêŋ anêŋ lahaviŋ ami ma tem enja vovaŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma doŋtom anyô ku atu ba miŋ hayala anêŋ anyô bêŋ anêŋ lahaviŋ ami ma hadum nômkama kambom ma tem enja vovaŋ yaô. “Ôpatu ba Wapômbêŋ hêv auk bêŋ hadêŋ yani, êŋ ma Wapômbêŋ lahaviŋ yani indum ku bêŋ esak. Ma ôpatu ba Wapômbêŋ hêv auk bêŋ anôŋ hadêŋ yani, êŋ ma Wapômbêŋ lahaviŋ yani indum ku bêŋ anôŋ esak. ");
INSERT INTO hot_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Yahalêm ek yambi atum êndôk pik. Yaleŋhaviŋ lôklokwaŋ nena atum êŋ bôk hathaŋ yôv. ");
INSERT INTO hot_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tem yanja vovaŋ bêŋ ba intu yakapôlôŋ malaiŋ kambom endeba anêŋ daŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Môlô osoŋ nena yahalêm ek yandum avômalô kapôlôŋiŋ êndôk biŋ e? Mi anôŋ! Yanaŋ êndêŋ môlô nena yahalêm ek yambak i vose. ");
INSERT INTO hot_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yaô lôk embeŋ yam ma avômalô baheŋvi anêŋ unyak te tem nembaki vose ni ôdôŋ ju ba lokwaŋlô tem nêmbôliŋ dômiŋ êndêŋ lokwaŋju ma lokwaŋju tem nêmbôliŋ dômiŋ êndêŋ lokwaŋlô. ");
INSERT INTO hot_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tem thêlô nembak i vose, ba lambô tem êmbôliŋ dôm êndêŋ nakaduŋ, ma namalô tem êmbôliŋ dôm êndêŋ lambô, ma talêbô tem êmbôliŋ dôm êndêŋ nalavi, ma nalavi tem êmbôliŋ dôm êndêŋ talêbô, ma yaŋavi tem êmbôliŋ dôm êndêŋ namalô yanavi, ma namalô yanavi tem êmbôliŋ dôm êndêŋ yaŋavi.” ");
INSERT INTO hot_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ma Yisu hanaŋ hadêŋ avômalô nômbêŋ atu aêntêk, “Môlô ôyê buliv loŋgavu hamô loŋ wak halôk, êŋ ma môlô onaŋ nena, ‘Ôthôm tem êyô.’ Êŋ ma ôthôm hik hayô. ");
INSERT INTO hot_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma lovak halêm anêŋ loŋ vovaŋ, êŋ ma môlô onaŋ nena, ‘Tem vovaŋ kambom.’ Êŋ ma tak vovaŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Môlô avômalô abôyaŋ. Môlô ôyê leŋ lo pik ma oyala anêŋ ôdôŋ, ma doŋtom waklavôŋ êntêk ma môlô ôthôŋ anêŋ ôdôŋ paliŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Aisê ka môlô miŋ lemimhabi katô nena yenaŋ abô ma thêthôŋ mena mi e? ");
INSERT INTO hot_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nodaŋô! Anyô te hadum ek idum abô ek o ba hawa o ba hi unyak nindum abô. Mamu oveŋ loŋôndê denaŋ, êŋ ma opesaŋ abô imbiŋ yani ketheŋ. Ma miŋ honaŋ abô mavi hadêŋ yani ami, êŋ ma tem ôpêŋ êmbôv o lôklokwaŋ kambom ba ni êndêŋ anyô halaŋô abô. Ma anyô bêŋ êŋ tem nêm o ni êndêŋ sôp bidoŋ. Ma sôp bidoŋ tem êmbôv o kisi ba ni etak o êndôk koladôŋ. ");
INSERT INTO hot_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yanaŋ êndêŋ o nena tem ômô koladôŋ endeba nêm anêm vuli sapêŋ am. Aêŋ ba lemimbi katô am!” ");
INSERT INTO hot_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yôv ma anyô doho êyô ba enaŋ hadêŋ Yisu hathak ŋê Galili doho êbôk iniŋ da ma Pailat hik thêlô vônô ba iniŋ thalaleŋ haŋgasô hathak iniŋ da. ");
INSERT INTO hot_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma Yisu hanaŋ viyaŋ nena, “Môlô osoŋ nena ŋê Galili êŋ iniŋ kambom hamôŋ ek avômalô Galili vi ba malaiŋ êŋ hapôm thêlô e? ");
INSERT INTO hot_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma mi. Ma doŋtom môlô miŋ ole kapôlômim liliŋ ami, êŋ ma malaiŋ tem êpôm môlô imbiŋ êtôm wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma anyô hatôm 18 takatu ba unyak daim anêŋ Siloam haŋgôli ba hik thêlô vônô, êŋ ma môlô osoŋ nena thêlôniŋ kambom hamôŋ ek avômalô Jelusalem iniŋ kambom e? ");
INSERT INTO hot_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma mi. Ma doŋtom môlô miŋ ole kapôlômim liliŋ ami, êŋ ma malaiŋ tem êpôm môlô imbiŋ êtôm wak nômbêŋ intu sapêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ma Yisu hanaŋ abô loŋ kapô te aêntêk, “Alokwaŋ sabo te hamiŋ anyô te anêŋ ku kapô. Ma wak te ma yani hi ku kapô ek ênjê nena hik mena mi e? Ma doŋtom mi. ");
INSERT INTO hot_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Êŋ ma yani hanaŋ hadêŋ anêŋ anyô ku nena, ‘Ondaŋô. Sondabêŋ lokwaŋlô ma yahalêm ek yaŋgê a êntêk anêŋ va ma doŋtom mi. Alokwaŋ êŋ habuliŋ yenaŋ pik anêŋ lêŋlêŋ, ba dô ma onde lu.’ ");
INSERT INTO hot_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ma anyô ku êŋ hanaŋ viyaŋ nena, ‘Anyô bêŋ, otak imiŋ sondabêŋ te vêmam ek yandav pik lo bok la esak ôdôŋ. ");
INSERT INTO hot_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Êŋ ma tem injik anôŋ êndêŋ sondabêŋ yaŋ endake. Nena mi, ma onde lu.’” ");
INSERT INTO hot_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat te ma Yisu hanaŋ abô hadêŋ avômalô halôk unyak yeŋ. ");
INSERT INTO hot_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma avi te hamô ba ŋgôk bôk hêv lijiŋ hadêŋ avi êŋ hatôm sondabêŋ 18. Avi êŋ anêŋ dômlokwaŋ lokbaŋ kambom ba miŋ hatôm imiŋ tibum dokte ami ma mi. ");
INSERT INTO hot_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Ma Yisu hayê avi êŋ ma halam “Ôlêm.” Ma avi êŋ halêm ma Yisu hatak baŋ hayôhêk yani ma hanaŋ, “Avi, yahêv anêm lijiŋ vê.” Êŋ ma ketheŋ oyaŋ ma avi êŋ hamiŋ tibum mavi ma habô Wapômbêŋ anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma doŋtom anyô bêŋ atu ba hayabiŋ unyak yeŋ lamaniŋ hathak Yisu hadum avi êŋ mavi hadêŋ Sabat. Êŋ ma anyô bêŋ atu hanaŋ hadêŋ avômalô aêntêk, “Wak baheŋvi ba lahavute ma wak nindum ku. Ma môlô nôlêm êndêŋ wak takêŋ ek nêm môlônim lijiŋ vê, ma Sabat ma dô.” ");
INSERT INTO hot_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma Anyô Bêŋ hanaŋ ôpêŋ anêŋ abô viyaŋ nena, “Môlô ŋê abôyaŋ. Môlô sapêŋ othak opole unim bokmaŋkao lôk doŋki ba i inum ŋaŋ hadêŋ Sabat mena mi e? ");
INSERT INTO hot_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Avi êntêk ma Ablaham anêŋ lim te. Sadaŋ hakak yani loŋ hathak lijiŋ hatôm sondabêŋ 18. Ma kambom ek yapole anêŋ yak vê êndêŋ Sabat e? Mi anôŋ. Êŋ ma nôm mavi.” ");
INSERT INTO hot_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yisu hanaŋ abô êŋ ma ŋê takatu ba êpôlik hathak yani elaŋô ba mama kambom, ma avômalô sapêŋ leŋiŋmavi hathak nômbêŋ atu ba Yisu hadum. ");
INSERT INTO hot_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Vêm ma Yisu hanaŋ, “Wapômbêŋ anêŋ loŋ lôkliŋyak ma aisê ba hatôm malê? ");
INSERT INTO hot_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Êŋ ma hatôm ava yaônate. Ma anyô te hawa ba havatho halôk anêŋ ku kapô. Ma haveŋ yam ma ava êŋ halumbak bêŋ hatôm alokwaŋ ba menak elav iniŋ unyak halôk anêŋ thaŋaŋ.” ");
INSERT INTO hot_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma Yisu hanaŋ hik thêlô liŋ hathak loŋbô, “Wapômbêŋ anêŋ loŋ lôkliŋyak, êŋ ma hatôm malê? ");
INSERT INTO hot_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Êŋ ma hatôm yis. Avi te hawa yis dokte ba hayelaŋ halôk palawa bêŋ anôŋ kapô, ma haveŋ yam ma palawa sapêŋ hathiŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yisu hi Jelusalem ma haveŋ malak lodôŋlodôŋ nenanena ba hadôŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma anyô te hanaŋ hik yani liŋ nena, “Anyô Bêŋ, Wapômbêŋ tem nêm anyô tomtom iyom bulubiŋ e?” Ma Yisu hanaŋ hadêŋ thêlô nena, ");
INSERT INTO hot_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Môlô majaŋ anôŋ ek numbitak nôyô unyak abôlêk yaôna. Yanaŋ êndêŋ môlô nena tem anyô bêŋ anôŋ leŋiŋhaviŋ nimbitak nêyô, ma doŋtom thêlô miŋ hatôm ami. ");
INSERT INTO hot_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Unyak alaŋ tem imbiyô injik unyak abôlêk siŋ, êŋ ma môlô tem numiŋ viyaiŋ ma nupididiŋ unyak abôlêk ba nodam nena, ‘Anyô bêŋ, nuŋgwik unyak abôlêk vê ek yêlô.’ “Ma doŋtom yani tem enaŋ viyaŋ nena, ‘Yahathôŋ môlô paliŋ. Môlô ôlêm anêŋ êsê?’ ");
INSERT INTO hot_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ma môlô tem nonaŋ êndêŋ yani nena, ‘Bôk yêlô aŋ nôm haviŋ o ma hôdôŋ yêlô hamô yêlôaniŋ loŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ma doŋtom yani tem enaŋ nena, ‘Yahathôŋ môlô paliŋ. Môlô ôlêm anêŋ êsê? Môlô ŋê kambom ba unu daim ek ya!’ ");
INSERT INTO hot_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","“Ma avômalô loŋ buyaŋ tem netak pik luvuluvu sapêŋ ma ini nejaŋ nôm bêŋ nêmô Wapômbêŋ anêŋ loŋ lôkliŋyak. Êŋ ma môlô tem ôŋgô Ablaham lo Aisak ma Jekop lôk plopet sapêŋ tem nêmô loŋ êŋ. Ma doŋtom Wapômbêŋ tem nêm môlô vê ba môlô tem nodaŋ asêŋ malêŋ ba nosaŋ vemimbôlêk ôdôŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Odaŋô, anyô yaô doho ma tem nimbitak anyô bêŋ. Ma anyô bêŋ doho ma tem nimbitak anyô yaô.” ");
INSERT INTO hot_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yisu hanaŋ abô yôv ma Palisi doho êlêm ma enaŋ hadêŋ Yisu nena, “Otak loŋ êntêk ma nu buyaŋ ek malê nena Helot hadum ek injik o vônô.” ");
INSERT INTO hot_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma Yisu hanaŋ viyaŋ nena, “Unu nonaŋ êndêŋ avuŋ yatap êŋ aêntêk, ‘Ondaŋô, yaô lo yamuŋ ma tem yanêm ŋgôk kambom vê lôk yandum avômalô lôk lijiŋ mavi. Ma êtôm wak lô ma tem yaŋgik yenaŋ ku anêŋ daŋ siŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aêŋ ba yaô lo yamuŋ ma yaŋ ma tem yambeŋ ba yana Jelusalem ek malê nena kambom ek plopet ema ênjêk loŋ yaŋda. ");
INSERT INTO hot_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ai, Jelusalem, Jelusalem! Môlô othak uik plopet pôpônô. Ma ŋê takatu ba Wapômbêŋ hêv halêm ma môlô uik i hathak valu! Alikaknena! Yahadum lôbôlôŋ ek yasup nalumi esak doŋtom êtôm tale tiŋ hasup nali ba êmô banik kapô. Ma doŋtom môlô ôdô! ");
INSERT INTO hot_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Odaŋô! Môlônim malak ma tem kambom ba êmô ŋgathiniŋ! Yanaŋ avanôŋ êndêŋ môlô nena môlô tem miŋ ôŋgô ya esak loŋbô ami endeba nonaŋ nena, ‘Wapômbêŋ nêm lamavi êndêŋ ôpatu ba halêm hathak Anyô Bêŋ anêŋ athêŋ!’ am.” ");
INSERT INTO hot_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat te ma Yisu hi hayaŋ nôm hamô Palisi iniŋ anyô bêŋ te anêŋ unyak ma thêlô ititiŋ yani lôklokwaŋ. ");
INSERT INTO hot_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Anyô te hathiŋ kambom ba hamô haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma Yisu hanaŋ hik ŋê Palisi lôk ŋê lôkauk hathak abô balabuŋ liŋ nena, “Alalôaniŋ abô balabuŋ te hanaŋ nena alalô hatôm nandum anyô lôk lijiŋ mavi êndêŋ Sabat mena mi e?” ");
INSERT INTO hot_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma doŋtom thêlô bônôŋ iyom. Êŋ ma yani hawa anyô lijiŋ êŋ ba hadum yani mavi ma hatak yani ba hi. ");
INSERT INTO hot_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ma Yisu hanaŋ hadêŋ thêlô nena, “Môlônim nalumi mena bokmaŋkao la hêv yak halôk lôv hadêŋ Sabat, ma môlô tem ketheŋ unu nodadi imbitak yaiŋ mena mi e?” ");
INSERT INTO hot_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma thêlô miŋ hatôm nenaŋ abô êŋ viyaŋ ami. ");
INSERT INTO hot_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yisu hayê avômalô êlêm ek nejaŋ nôm ma thêlô leŋiŋhaviŋ nêndôk nêmô ŋê bêŋbêŋ iniŋ loŋ iyom. Aêŋ ba yani hanaŋ abô loŋ kapô te hadêŋ thêlô nena, ");
INSERT INTO hot_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Anyô te hapôpêk anêŋ nôm bêŋ ba halam o ma miŋ nu ômô ŋê bêŋbêŋ iniŋ loŋ ami. Yakô thêlô bôk netak loŋ êŋ ek anyô lôk athêŋ bêŋ te la. ");
INSERT INTO hot_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma nôm anêŋ alaŋ tem êyô ma enaŋ, ‘O vê ek anyô êntêk enja anêm loŋ.’ Êŋ ma tem o mama kambom ba nu ômô ŋê yaô iniŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aêŋ ba anyô te halam o ba hu ek noŋgwaŋ nôm, êŋ ma nu ômô anyô yaô iniŋ loŋ. Hudum aêŋ ma nôm anêŋ alaŋ tem êlêm ma enaŋ, ‘Aiyaŋ, ôlêm ômô imbiŋ ŋê bêŋbêŋ.’ Yani hadum aêŋ ma tem onja athêŋ bêŋ ênjêk ŋê nômbêŋ atu ba êlêm eyaŋ nôm êŋ. ");
INSERT INTO hot_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anyô habô anêŋ athêŋ hathak leŋ ma tem Wapômbêŋ etauviŋ yani. Ma doŋtom anyô hatauviŋ i aleba yaôna ma Wapômbêŋ tem nêm athêŋ bêŋ êndêŋ yani.” ");
INSERT INTO hot_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ma Yisu hanaŋ hadêŋ unyak anêŋ alaŋ nena, “Hudum ek ôpôpêk nôm bêŋ ma miŋ ondam anêm avômalô môlô lôk anêm thalaleŋ ma avômalô lôkmaŋgiŋ ami. Embeŋ yam ma thêlô tem nendam o ba nu noŋgwaŋ nôm êndôk thêlôniŋ unyak aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma doŋtom hôpôpêk nôm bêŋ, ma ondam ŋê siv ma ŋê baheŋiŋ kambom lôk ŋê veŋiŋ kambom ma ŋê maleŋiŋ pusip. ");
INSERT INTO hot_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ŋê anêŋ aêŋ ma miŋ hatôm nênêm anêm nôm viyaŋ ami. Êŋ ma tem lemmavi ek malê nena embeŋ yam ma tem Wapômbêŋ nêm anêm nôm êŋ viyaŋ êndêŋ waklavôŋ atu ba ŋê thêthôŋ mavi iviyô hêk ŋama.” ");
INSERT INTO hot_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Anyô te atu ba hayaŋ nôm hamô haviŋ Yisu halaŋô abô êŋ ma hanaŋ hadêŋ Yisu nena, “Avômalô takatu ba tem nejaŋ nôm nêmô Wapômbêŋ anêŋ loŋ lôkliŋyak anêŋ leŋ nêmô lôk leŋiŋmavi.” ");
INSERT INTO hot_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma Yisu hanaŋ viyaŋ nena, “Anyô te hatak waklavôŋ te ek êpôpêk anêŋ nôm bêŋ ma hêv abô hadêŋ avômalô bêŋ anôŋ ek nêlêm nejaŋ. ");
INSERT INTO hot_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Waklavôŋ hayô ma yani hêv anêŋ anyô ku ba hi hadêŋ avômalô takatu ba bôk hanaŋ yôv hadêŋ i ma hanaŋ nena, ‘Môlô nôlêm, lêk yêlô apesaŋ nôm yôv.’ ");
INSERT INTO hot_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ma doŋtom avômalô takêŋ maleŋ baki iyom. Anyô te hanaŋ, ‘Lêk yahêv pik te vuli yôv ba yana ek yaŋgê. Alikakna, ku êŋ havaloŋ ya loŋ ba tem miŋ hatôm yasôk ami.’ ");
INSERT INTO hot_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ma anyô yaŋ hanaŋ, ‘Lêk yahêv bokmaŋkao laumiŋ vuli ek nindum yenaŋ ku ba tem yana ek yasaê i ek yaŋgê. Alikakna, ku êŋ havaloŋ ya loŋ ba tem miŋ hatôm yasôk ami.’ ");
INSERT INTO hot_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ma anyô yaŋ hanaŋ, ‘Lêk yahawa avi lukmuk ba miŋ hatôm yasôk ami.’ ");
INSERT INTO hot_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Êŋ ma anyô ku hawa abô takêŋ ba hi hadêŋ anêŋ anyô bêŋ. Ma unyak anêŋ alaŋ lamaniŋ kambom ba hanaŋ hadêŋ ôpêŋ nena, ‘Nu ketheŋ êndêŋ malak lôŋ anêŋ loŋôndê bêŋ lôk loŋôndê yaô ma onja ŋê siv lôk ŋê baheŋiŋ kambom ma ŋê maleŋiŋ pusip lôk ŋê veŋiŋ kambom ba ôlêm yenaŋ unyak kapô.’ ");
INSERT INTO hot_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Haveŋ yam ma anyô ku êŋ hanaŋ, ‘Anyô bêŋ, lêk yahadum hatôm honaŋ, ma doŋtom unyak miŋ putup ami denaŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ma anyô bêŋ hanaŋ hadêŋ anyô ku nena, ‘Otak malak lôŋ ênjêk ma nu ku kapô lôk unyak kudum lôk ŋaŋ onaŋ sapêŋ ba onaŋ lôklokwaŋ nena thêlô nêlêm. Yaleŋhaviŋ yenaŋ unyak putup am. ");
INSERT INTO hot_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yanaŋ êndêŋ môlô nena ŋê takatu ba maleŋiŋ baki, thêlô miŋ hatôm nejaŋ yenaŋ nôm dokte ami ma mi anôŋ.’” ");
INSERT INTO hot_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Avômalô bêŋ anôŋ i haviŋ Yisu. Ma yani hik i liliŋ ma hanaŋ hadêŋ thêlô nena, ");
INSERT INTO hot_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Anyô hadum ek esopa ya ma doŋtom miŋ hatak lambô lo talêbô ma yanavi lôk nali ma iviyaŋ lôk livi ma anêŋ lôkmala haviŋ ami ma miŋ hatôm imbitak yenaŋ anyô ku ami. ");
INSERT INTO hot_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma ôpatu ba miŋ hawa anêŋ alovalaŋaŋsiŋ ba hasopa ya ami ma miŋ hatôm imbitak yenaŋ anyô ku ami. ");
INSERT INTO hot_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Môlônim anyô te lahaviŋ endav unyak bêŋ te, ma êmô ba laimbi katô nena hatôm endav unyak êŋ ba injik siŋ e. ");
INSERT INTO hot_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ma miŋ lahabi aêŋ ami ma tem endav landiŋ iyom ma miŋ hatôm injik siŋ ami. Ma avômalô sapêŋ tem nêgê ba nemalik esak yani ");
INSERT INTO hot_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ba nenaŋ nena, ‘Halav landiŋ iyom ma miŋ hatôm injik unyak siŋ ami!’ Ba intu hudum ek osopa ya ma lemimbi katô am. ");
INSERT INTO hot_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ma kiŋ te lahabi injik vovak êndêŋ kiŋ yaŋ, êŋ ma êmô ba laimbi katô êŋa anêŋ ŋê vovak ma 10,000 iyom ba hatôm nijik vovak êndêŋ kiŋ yaŋ atu ba anêŋ 20,000 e? ");
INSERT INTO hot_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma mi, ma nêm abô ni ek kiŋ yaŋ atu ba hamô daim denaŋ ek thai nepesaŋ abô ek vovak dô. ");
INSERT INTO hot_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Ma aêŋ iyom ma môlô te lahaviŋ imbitak yenaŋ anyô ku, êŋ ma etak anêŋ nômkama sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ŋgwêk ma nôm mavi. Ma doŋtom ŋgwêk doho thilibuŋ kambom ma tem nindum aisê ek anêŋ vasiŋ êmô esak loŋbô? Mi anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma anêŋ ku lêk mi ba dô ma nubini. Ŋê lôk leŋôndôŋ ma nodaŋô abô êntêk katô.” ");
INSERT INTO hot_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ŋê ewa takis lôk ŋê idum kambom, thêlô êlêm ek nedaŋô Yisu anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma doŋtom ŋê Palisi lôk ŋê lôkauk hathak abô balabuŋ enaŋ abô munuŋmunuŋ nena, “Ôpêntêk hawa ŋê kambom thô ba hayaŋ nôm hamô haviŋ thêlô.” ");
INSERT INTO hot_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aêŋ ba Yisu hanaŋ abô loŋ kapô hadêŋ thêlô aêntêk, ");
INSERT INTO hot_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Môlônim anyô te anêŋ boksipsip hatôm 100 ba te mi, êŋ ma tem yani etak 99 ba nejaŋ kamuŋ nêmô ma ni ek êmbôlêm ali atu ba mi endeba êpôm am. ");
INSERT INTO hot_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma hapôm boksipsip êŋ, ma tem ekaliv ênjêk vakôk lôk lamavi ba ni. ");
INSERT INTO hot_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ma hayô anêŋ unyak ma tem endam anêŋ avômalô ma enaŋ nena, ‘Yaleŋmavi anêŋ dôêŋ hathak lêk yahapôm yenaŋ boksipsip hathak loŋbô ba nôlêm ek alalô leŋiŋmavi imbiŋ i.’ ");
INSERT INTO hot_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Yanaŋ êndêŋ môlô nena Wapômbêŋ lamavi hathak avômalô thêthôŋ hatôm 99 takatu ba bôk ele kapôlôŋiŋ liliŋ yôv. Ma doŋtom anyô kambom te hale kapô liliŋ ma tem avômalô malak leŋ leŋiŋmavi anôŋ êtôm ôpatu ba hapôm boksipsip atu ba mi.” ");
INSERT INTO hot_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma Yisu hanaŋ, “Avi te anêŋ valuseleŋ seleva laumiŋ hamô ma doŋtom te mi. Êŋ ma yani tem indum malê? Yani tem êtôm atum ba injik unyak kapô kisi ba êmbôlêm endeba êpôm am. ");
INSERT INTO hot_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Êŋ ma yani halam anêŋ avômalô ba hanaŋ hadêŋ thêlô, ‘Yaleŋmavi anêŋ dôêŋ ek malê nena lêk yahapôm yenaŋ valuseleŋ hathak loŋbô ba alalô leŋiŋmavi.’ ");
INSERT INTO hot_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yanaŋ êndêŋ môlô nena leŋiŋmavi anêŋ aêŋ iyom habitak Wapômbêŋ anêŋ aŋela malêvôŋ hathak anyô kambom te hale kapô liliŋ.” ");
INSERT INTO hot_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma Yisu hanaŋ, “Anyô te anêŋ nakaduŋ bôp lo nôk êmô. ");
INSERT INTO hot_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wak te ma nôk hanaŋ hadêŋ lambô aêntêk ‘Wakamik, ômbi anêm nômkama sam ba nêm ôdôŋ yaŋ êndêŋ ya.’ Êŋ ma lambô hik nômkama sam hi ôdôŋ ju. ");
INSERT INTO hot_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nôk hamô vauna ma hêv anêŋ nômkama ba êv vuli ma yani hawa valuseleŋ sapêŋ ba hi loŋ buyaŋ. Ma yani hadum kambom lomaloma ba habuliŋ anêŋ nômkama sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Êŋ ma yani anêŋ valuseleŋ lêk thô, ma bôm bêŋ hayô loŋ êŋ. Ba yani hama kisi kambom. ");
INSERT INTO hot_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ma nôk hi hayô ek anyô loŋ êŋ te ma ôpêŋ hêv ku ni ek embakôŋ anêŋ bok. Ku êŋ ma lelaik kambom hêk Islael maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma nôk hama kisi ba lahaviŋ enjaŋ bok iniŋ nôm, ma doŋtom thêlô miŋ êv nôm dokte hadêŋ yani ami. ");
INSERT INTO hot_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Êŋ ma yani hawa auk mavi ma hanaŋ, ‘Ai, Wakamik anêŋ ŋê ku sapêŋ eyaŋ nôm mavi bêŋ anôŋ. Ma doŋtom yahamô loŋ êntêk ba yahama kisi kambom ba tem yama! ");
INSERT INTO hot_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yambiyô ba yana ek wakamik ma yanaŋ êndêŋ yani aêntêk, “Wakamik, yahadum kambom bêŋ hadêŋ o lôk Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya miŋ anyô mavi hatôm ondam ya nena nalum ami. Otak ya êtôm anêm anyô ku te.” ’ ");
INSERT INTO hot_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Yôv ma yani haviyô ba hi hadêŋ lambô. Ma hamiŋ daim denaŋ ma lambô hayê ba lahiki kambom hathak yani. Ma halaŋviŋ ba hi hadêŋ namalô ma havaloŋ ba halaŋ hathak. ");
INSERT INTO hot_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ma nakaduŋ hanaŋ hadêŋ lambô aêntêk, ‘Wakamik yahadum kambom bêŋ hadêŋ o lôk Wapômbêŋ. Ya miŋ anyô mavi hatôm ondam ya nena nalum ami.’ ");
INSERT INTO hot_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ma doŋtom lambô halam hadêŋ anêŋ ŋê ku nena, ‘Ketheŋ! Noja kwêv daim mavi te êlêm ek naŋgik esak yenaŋ okna. Ma notak mote êndôk baŋgwasiŋ ma uŋgwik va bokŋgôp esak vakapô. ");
INSERT INTO hot_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ma môlô unu noja bokmaŋkao dopdop te êlêm ma uŋgwik ek alalô aŋgaŋ lôk leŋiŋmavi. ");
INSERT INTO hot_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ek malê nena yenaŋ okna êntêk bôk hama yôv, ma doŋtom lêk hamô lôkmala hathak loŋbô. Yani bôk mi, ma doŋtom lêk apôm yani hathak loŋbô.’ Êŋ ma thêlô eŋgabôm nôm bêŋ ba eyaŋ lôk leŋiŋmavi. ");
INSERT INTO hot_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ma namalô bôp haveŋ ku denaŋ. Ma haveŋ yam ma yani hale halêm anêŋ ku kapô ba habobo unyak ma halaŋô avômalô eloyeŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Êŋ ma yani halam anyô ku te halêm ma hanaŋ hik yani liŋ, ‘Idum malê?’ ");
INSERT INTO hot_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma anyô ku hanaŋ hadêŋ yani nena, ‘Mamuyaŋ molok hale halêm hathak loŋbô ba lemambô hik bokmaŋkao dopdop te ek malê nena yani hamô mavi ba halêm.’ ");
INSERT INTO hot_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Bôp halaŋô abô êŋ ma lamaniŋ kambom ba hadô ni unyak kapô. Êŋ ma lambô hale yaiŋ ma hadum ek indum yani lamavi. ");
INSERT INTO hot_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","30","Ma doŋtom yani hanaŋ hadêŋ lambô aêntêk, ‘Ondaŋô! Aisê ba huik bok siŋ mavi ek nalum atu ba hadô o ba hi buyaŋ. Yani habuliŋ anêm nômkama sapêŋ ba hêv hadêŋ avi idum sek waliliŋ. Ma ya ma yahayabiŋ o mavi ba yahalaŋô anêm abô hatôm sondabêŋ nômbêŋ intu sapêŋ. Yahadum anêm ku hatôm anyô oyaŋ. Ma doŋtom miŋ bôk huik bok nate ek ya lôk yenaŋ ŋê môlô ami.’ ");
INSERT INTO hot_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ma lambô hanaŋ hadêŋ yani nena, ‘Yenaŋ okna, wak nômbêŋ intu ma hômô haviŋ ya ba yenaŋ nômkama sapêŋ ma o iyom anêm. ");
INSERT INTO hot_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ma doŋtom lêk ma alalô leŋiŋmavi ek malê nena mamuyaŋ molok bôk mi ma lêk alalô apôm yani hathak loŋbô. Alalô asoŋ nena bôk hama ma doŋtom lêk hamô lôkmala hathak loŋbô.’” ");
INSERT INTO hot_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Anyô lôkmaŋgiŋ te hatak anyô te ek eyabiŋ anêŋ ku. Ma haveŋ yam ma halaŋô nena ôpêŋ habuliŋ anêŋ nômkama. ");
INSERT INTO hot_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ba intu halam yani ba hanaŋ, ‘Yahalaŋô nena hubuliŋ yenaŋ nômkama. Ba oto anêm ku anêŋ lavôŋ êlêm ek yaŋgê. O miŋ hatôm oyabiŋ yenaŋ ku esak loŋbô ami.’ ");
INSERT INTO hot_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ma anyô ku lahabi aêntêk, ‘Yenaŋ anyô bêŋ tem nêm ya vê ênjêk anêŋ ku, aêŋ ba yandum malê. Ya miŋ anyô lôklokwaŋ hatôm yandum ku êmô ku kapô ami. Lôk ya mama ek yapetenak ek avômalô nênêm ya sa. ");
INSERT INTO hot_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ai! Yahayala nôm atu ba yandum ek avômalô leŋiŋmavi ba neja ya thô êndêŋ waklavôŋ atu ba ya ku mi.’ ");
INSERT INTO hot_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Aêŋ ba yani halam ŋê takatu ba bôk ewa anyô bêŋ anêŋ nômkama ba anêŋ viyaŋ hêk denaŋ. Anyô môŋ hayô ba yani hanaŋ hik ôpêŋ liŋ, ‘Howa yenaŋ anyô bêŋ anêŋ nômkama vithê ba anêŋ viyaŋ hêk?’ ");
INSERT INTO hot_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ma hanaŋ, ‘Yahawa nôm lêŋlêŋ lôk uŋ hatôm 100.’ Êŋ ma anyô ku hanaŋ, ‘Onja kapya atu ba bôk ato anêm nômkama halôk êlêm ma oto 50 iyom.’ ");
INSERT INTO hot_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Yôv ma hanaŋ hadêŋ yaŋ atu ba haveŋ yam, ‘Anêm viyaŋ ma vithê?’ “Êŋ ma ôpêŋ hanaŋ, ‘Yahawa wit lôk vak hatôm 100.’ “Ma anyô ku hanaŋ, ‘Onja kapya atu ba bôk ato anêm nômkama halôk êlêm ma oto 80 iyom.’ ");
INSERT INTO hot_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ma haveŋ yam ma anyô lôkmaŋgiŋ atu hayê nôm atu ba anêŋ anyô ku hadum. Êŋ ma hanaŋ nena ôpêŋ ma anyô kambom ma doŋtom hadum nômkama hatôm anyô lôkauk bêŋ. Avanôŋ, ŋê pik eyala kobom pik mavi anôŋ hamôŋ ek avômalô takatu ba esopa deda. ");
INSERT INTO hot_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Yanaŋ êndêŋ môlô nena noja nômkama pik ba nônêm êndêŋ avômalô vi ek thêlô leŋiŋmavi êndêŋ môlô. Ma waklavôŋ atu ba nômkama mi, êŋ ma tem Wapômbêŋ enja môlô thô ba unu unyak atu ba tem nômô mavi wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ôpatu ba hayabiŋ nôm yaônena mavi ma hatôm eyabiŋ nômbêŋ mavi aêŋ iyom. Ma ôpatu ba hayabiŋ nôm yaônena kambom ma tem eyabiŋ nômbêŋ kambom aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aêŋ ba oyabiŋ nômkama pik êntêk kambom, êŋ ma opalê tem nêm nômkama anôŋ êndêŋ môlô? Mi. ");
INSERT INTO hot_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma oyabiŋ anyô yaŋ anêŋ nômkama kambom, êŋ ma opalê tem nêm nômkama ek môlôda? Milôk. ");
INSERT INTO hot_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Anyô ku te miŋ hatôm indum anyô bêŋ ju iniŋ ku ami. Ma tem la imbiŋ anyô yaŋ ma kapô êndô yaŋ. Ma tem ma endahaliŋ anyô yaŋ ma imbuliŋ dôm ek anyô yaŋ. Môlô miŋ hatôm nosopa Wapômbêŋ lôk valuseleŋ ami.” ");
INSERT INTO hot_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ŋê Palisi takatu ba leŋiŋhaviŋ valuseleŋ elaŋô Yisu anêŋ abô takêŋ ba maleŋ thêlêv hathak Yisu. ");
INSERT INTO hot_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ma Yisu hanaŋ hadêŋ thêlô, “Môlô udum ek avômalô leŋiŋimbi nena môlô ŋê thêthôŋ mavi. Ma doŋtom Wapômbêŋ hayala môlônim kapôlômim. Nôm takatu ba avômalô leŋiŋhabi nena nôm mavi anôŋ, êŋ ma Wapômbêŋ hayê nena nôm ôvathek. ");
INSERT INTO hot_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Abô balabuŋ lôk plopet iniŋ abô iyom hayabiŋ avômalô aleba hayô Jon anêŋ waklavôŋ. Ma lêk yahanaŋ Abô Mavi bêŋ hathak Wapômbêŋ anêŋ loŋ lôkliŋyak. Ba avômalô bêŋ anôŋ lôklokwaŋ ek nimbitak nêyô loŋ lôkliŋyak êŋ kapô ba ini. ");
INSERT INTO hot_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pik lo leŋ hatôm nêm yak. Ma doŋtom Wapômbêŋ anêŋ abô balabuŋ bunate miŋ hatôm nêm yak ami. ");
INSERT INTO hot_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Anyô te hadô yanavi ba hawa avi yaŋ, êŋ ma hadum sek. Ma anyô te hawa avi atu ba yamalô bôk hadô, êŋ ma hadum sek haviŋ.” ");
INSERT INTO hot_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Anyô lôkmaŋgiŋ te hamô ba wak nômbêŋ intu sapêŋ ma yani hik kwêv thapuk lo sôp thalaleŋ kêkêlô ba hayaŋ nôm mavi lomaloma lôk lamavi bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma anyô siv te anêŋ athêŋ nena Lasalus hêk ôpêŋ anêŋ malak badêŋ abôlêk. Ma palê hatêtô liŋkupik lôkthô. ");
INSERT INTO hot_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma yani lahaviŋ enjaŋ ôpêŋ anêŋ nôm mapmap atu ba ibi hi, ma doŋtom mi. Yani hamô ma avuŋ ethak êlêm elami anêŋ palê. ");
INSERT INTO hot_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Haveŋ yam ma anyô siv hama, ma aŋela ewa yani ba i êdô hamô habobo Ablaham. Ma anyô lôkmaŋgiŋ êŋ hama haviŋ ba elav. ");
INSERT INTO hot_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Anyô lôkmaŋgiŋ hamô ŋê ŋama iniŋ loŋ ba hawa vovaŋ bêŋ. Yani hêv ma liŋ ba hayê Ablaham lo Lasalus êmô daim bô. ");
INSERT INTO hot_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Êŋ ma yani halam nena, ‘Wakamik Ablaham, lem ek ya ba nêm Lasalus ek etak baŋgwasiŋ kupik êndôk ŋaŋ ba etak êyô êmô yadahalaŋ ek thilibuŋ ek malê nena yahawa vovaŋ bêŋ anôŋ hamô atum êntêk.’ ");
INSERT INTO hot_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ma doŋtom Ablaham hanaŋ viyaŋ nena, ‘Yenaŋ okna, sêbôk ba hômô pik ma howa anêm nôm mavi yôv ma Lasalus hawa anêŋ kambom. Ma doŋtom lêk yêlô êv yani thêvô ma o ma lêk howa vovaŋ. ");
INSERT INTO hot_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma Wapômbêŋ bôk hatak kolosoŋ bêŋ te hêk malêvôŋ ek yêlô ma môlô. Ba intu miŋ hatôm môlô nôlêm êndêŋ yêlô ma yêlô nasôk êndêŋ môlô ami.’ ");
INSERT INTO hot_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma ôpêŋ hanaŋ, ‘Aêŋ ba wakamik, hatôm nêm Lasalus ba endeni wakamik anêŋ unyak ");
INSERT INTO hot_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ma enaŋ abô lôklokwaŋ êndêŋ yenaŋ aiyaŋ baheŋvi takatu ek miŋ nêlêm loŋ vovaŋ bêŋ êntêk imbiŋ ya ami.’ ");
INSERT INTO hot_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ma doŋtom Ablaham hanaŋ, ‘Mose lo plopet iniŋ abô hêk ba thêlô nedaŋô ba nesopa.’ ");
INSERT INTO hot_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ma ôpêŋ hanaŋ, ‘Wakamik Ablaham, miŋ hatôm ami. Ma doŋtom anyô ŋama te ni êndêŋ thêlô, êŋ ma tem thêlô nede kapôlôŋiŋ liliŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ma doŋtom Ablaham hanaŋ hadêŋ yani nena, ‘Thêlô miŋ elaŋô Mose lo plopet iniŋ abô ami. Êŋ ma anyô ŋama te haviyô hathak loŋbô, ma tem miŋ nedaŋô anêŋ abô imbiŋ ami.’” ");
INSERT INTO hot_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Nôm lomaloma tem êndôk avômalô leŋiŋ ek nindum kambom. Ma doŋtom vovaŋ bêŋ tem êpôm opalêla takatu ba indum nôm êŋ. ");
INSERT INTO hot_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma anyô te hadum ba yenaŋ amena atu ba hêvhaviŋ ya te hêv yak, ôpêŋ tem êpôm malaiŋ bêŋ anôŋ. Ôpêŋ tem nêsôkwêŋ valu bêŋ te esak laselo ba nimbi yani êndôk ŋgwêk makidiŋ ba ema. Malaiŋ êŋ ma yaôna ek malaiŋ atu ba yani tem êpôm embeŋ yam. ");
INSERT INTO hot_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aêŋ ba noyabiŋ am. “Mamuyaŋ hadum kambom hadêŋ o, êŋ ma nu opesaŋ abô imbiŋ yani. Ma yani hale kapô liliŋ, êŋ ma nêm anêŋ kambom êŋ vê. ");
INSERT INTO hot_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wak te iyom ma mamuyaŋ hadum kambom hadêŋ o hatôm bôlôŋ baheŋvi ba lahavuju, ma bôlôŋ baheŋvi ba lahavuju havôhalêm hanaŋ hadêŋ o nena, ‘Alikakna, yahadum kambom’, êŋ ma nêm anêŋ kambom vê.” ");
INSERT INTO hot_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ma aposel enaŋ hadêŋ Anyô Bêŋ nena, “Undum yêlôaniŋ êvhaviŋ indumbak bêŋ!” ");
INSERT INTO hot_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma Anyô Bêŋ hanaŋ, “Môlônim ôêvhaviŋ ma yaôna hatôm ava yaônate, êŋ ma hatôm nonaŋ êndêŋ alokwaŋ sabo êntêk, ‘Osapu oda ba nu umiŋ ŋgwêk,’ êŋ ma tem endaŋô môlônim abô.” ");
INSERT INTO hot_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ma Yisu hanaŋ, “Môlô othak ôêv ku nêpôpêk nôm hadêŋ malak lôŋ te. Êŋ ma ŋê bêŋbêŋ tem nenaŋ êndêŋ thêlô nena nejaŋ nôm êmôŋ e? Mi. ");
INSERT INTO hot_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ŋê bêŋbêŋ tem nenaŋ êndêŋ thêlô nena, ‘Nôpôpêk yêlôaniŋ nôm êmôŋ ma môlônim embeŋ yam.’ ");
INSERT INTO hot_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma tem ŋê bêŋbêŋ nenaŋ leŋiŋmavi bêŋ êndêŋ malak lôŋ êŋ e? Mi, thêlô idum iniŋ ku iyom. ");
INSERT INTO hot_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ma môlô aêŋ iyom, môlô udum ku sapêŋ atu ba Anyô Bêŋ hêv hadêŋ môlô yôv, êŋ ma nonaŋ, ‘Yêlô ma ŋê ku iyom ba adum yêlôaniŋ ku iyom.’” ");
INSERT INTO hot_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisu hi Jelusalem denaŋ ba hasopa loŋôndê atu ba haveŋ Samalia lo Galili iniŋ pik malêvôŋ. ");
INSERT INTO hot_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma hi habobo malak te ma ŋê lepla laumiŋ êlêm êpôm yani. Thêlô imiŋ daim dokte ");
INSERT INTO hot_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma elam nena, “Anyô Bêŋ Yisu, lem ek yêlô.” ");
INSERT INTO hot_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ma Yisu hayê thêlô ma hanaŋ, “Môlô unu uŋgwik am thô êndêŋ ŋê êbôk da.” Êŋ ma thêlô eveŋ ba i denaŋ ma leŋviŋkupik habitak mavi. ");
INSERT INTO hot_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ma thêlô êŋ te hayê nena liŋkupik lêk habitak mavi ma halehi ma halam kaêk lôk habô Wapômbêŋ anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma hayô ma halek vadôŋ lêlô ba thohavloma halôk pik habobo Yisu valuvi ma hêv lamavi hadêŋ yani. Ôpêŋ ma anyô Samalia te. ");
INSERT INTO hot_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma Yisu hanaŋ, “Yahadum anyô laumiŋ mavi. Ma anyô baheŋvi ba lahavuva êmô êsê? ");
INSERT INTO hot_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aisê ka anyô loŋ buyaŋ iyom hale halêm ek habô Wapômbêŋ anêŋ athêŋ?” ");
INSERT INTO hot_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma Yisu hanaŋ hadêŋ ôpêŋ aêntêk, “Umbiyô ba nu, anêm hôêvhaviŋ hadum ba o mavi.” ");
INSERT INTO hot_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ŋê Palisi enaŋ hik Yisu liŋ nena, “Aŋgê ka tem Wapômbêŋ anêŋ loŋ lôkliŋyak êlêm?” Ma Yisu hanaŋ viyaŋ nena, “Wapômbêŋ anêŋ loŋ lôkliŋyak halêm ma tem miŋ êlêm lôk lavôŋiŋ ek avômalô nêgê ami. ");
INSERT INTO hot_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aêŋ ba tem miŋ nenaŋ nena, ‘Ôŋgô, Wapômbêŋ anêŋ loŋ lôkliŋyak êntêk aêŋ’ mena ‘Endaku aêŋ’ ami. Mi, Wapômbêŋ anêŋ loŋ lôkliŋyak lêk hamô môlô malêvôŋ.” ");
INSERT INTO hot_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Wak te tem êyô ba môlô tem lemimimbiŋ bêŋ anôŋ ek ôŋgô Anyô Anêŋ Nakaduŋ atu, ma doŋtom môlô tem miŋ ôŋgô ami. ");
INSERT INTO hot_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma avômalô tem nenaŋ êndêŋ môlô nena, ‘Ôŋgô, yani hamiŋ loŋ êntêk!’ mena ‘hamiŋ loŋ endaku!’ Êŋ ma môlô nômô maliŋyaô ma miŋ nosopa thêlô ami ");
INSERT INTO hot_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ek malê nena Anyô Anêŋ Nakaduŋ atu anêŋ waklavôŋ ma tem avômalô sapêŋ nêgê êtôm damak hêv ba habi deda haveŋ leŋ lôkthô. ");
INSERT INTO hot_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma doŋtom tem yanja vovaŋ lomaloma ma môlô ŋê bôlôŋ êntêk tem nômbôliŋ dômim êndêŋ ya vêmam. ");
INSERT INTO hot_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Anyô Anêŋ Nakaduŋ atu anêŋ waklavôŋ tem êtôm sêbôk ba Noa anêŋ waklavôŋ. ");
INSERT INTO hot_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Avômalô eyaŋ lo inum ma ewa i aleba êthôŋ paliŋ ma Noa hi yeŋ kapô. Êŋ ma ŋambô bêŋ hayô ba habuliŋ thêlô sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aêŋ ba hatôm aêsêbôk ba Lot anêŋ waklavôŋ. Avômalô eyaŋ ba inum ma êv vuli lôk ewa vuli ma evatho ku lôk elav iniŋ unyak. ");
INSERT INTO hot_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma doŋtom wak atu ba Lot hatak Sodom ba hi ma atum lôk valu vovaŋ solpa halôk anêŋ leŋ ba habuliŋ thêlô sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Waklavôŋ atu ba Anyô Anêŋ Nakaduŋ atu injik i thô ma tem imbitak ketheŋ oyaŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Wak êŋ ma anyô te hamô unyak vôv ma anêŋ nômkama hamô unyak kapô, êŋ ma miŋ ni unyak kapô ek enja anêŋ nômkama ami. Mi, êsôv ba ni iyom. Ma aêŋ iyom ma anyôla hamiŋ ku kapô ma miŋ endeni unyak ami. Mi, êsôv ba ni iyom. ");
INSERT INTO hot_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Môlô lemim imbi Lot yanavi! ");
INSERT INTO hot_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Anyô te hadum ek embaloŋ yanida anêŋ lôkmala loŋ ma anêŋ lôkmala tem nêm yak. Ma doŋtom anyô te hatak anêŋ lôkmala ma anêŋ lôkmala tem êmô mavi. ");
INSERT INTO hot_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Yanaŋ êndêŋ môlô nena bôlôvôŋ êŋ ma anyô ju tem nêjêk yêm doŋtom ma tem neja anyô yaŋ ma yaŋ ênjêk. ");
INSERT INTO hot_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ma avi ju tem nepesaŋ iniŋ palawa ma tem neja avi yaŋ ma yaŋ êmô.” ");
INSERT INTO hot_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ŋê ku enaŋ hik Yisu liŋ nena, “Anyô Bêŋ, nôm êŋ tem imbitak êsê?” Ma Yisu hanaŋ viyaŋ nena, “Menak lambek ethak doŋtom ba êmô loŋ takatu ba alim hapalê hêk.” ");
INSERT INTO hot_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yisu hanaŋ abô loŋ kapô te hadêŋ thêlô ek neteŋ mek êtôm wak nômbêŋ intu sapêŋ ma miŋ kapôlôŋiŋ eŋgiap ami. ");
INSERT INTO hot_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aêŋ ba yani hanaŋ aêntêk, “Malak lôŋ te ma anyô bêŋ halaŋô avômalô iniŋ abô hamô. Yani ma miŋ hakô Wapômbêŋ ami ma hapôlik ek avômalô iniŋ abô haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma avi tôp te hamô lôŋ êŋ. Ma yani hi hadêŋ anyô bêŋ êŋ lôbôlôŋ ma hanaŋ, ‘Anyô te habuliŋ ya. Ma ôlêm ondaŋô yenaŋ abô ba opesaŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ma doŋtom anyô bêŋ hadô avi tôp êŋ anêŋ abô hatôm wak bêŋ anôŋ. “Haveŋ yam ma anyô bêŋ êŋ lahabi nena, ‘Miŋ yahalaŋô Wapômbêŋ anêŋ abô ami ma yakapôlôŋ hadô avômalô iniŋ abô haviŋ, ");
INSERT INTO hot_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ma doŋtom yahadô ek avi tôp êntêk êlêm wak nômbêŋ intu sapêŋ ba imbuliŋ yenaŋ auk. Aêŋ ba yandaŋô yani anêŋ abô ba yapesaŋ ketheŋ ek yani êmô tiŋiŋ.’” ");
INSERT INTO hot_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma Anyô Bêŋ Yisu hanaŋ, “Noja auk esak anyô bêŋ kambom êntêk anêŋ kobom. ");
INSERT INTO hot_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aêŋ ba Wapômbêŋ tem endaŋô anêŋ avômalô takatu ba bôk hatak i yôv iniŋ asêŋ atu ba elaŋ bôlôvôŋ ba wak mena mi e? Tem endaŋô. Ma tem yani endaŋô yaôyaô e? ");
INSERT INTO hot_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mi anôŋ! Yanaŋ avanôŋ biŋ nena yani tem endaŋô ketheŋ ma tem epesaŋ. Ma doŋtom Anyô Anêŋ Nakaduŋ atu halêm pik hathak loŋbô, êŋ ma tem êpôm nena avômalô êvhaviŋ doho êmô mena mi e?” ");
INSERT INTO hot_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ma Yisu hanaŋ abô loŋ kapô te hadêŋ avômalô takatu ba leŋiŋhabi nena thêlô ma avômalô thêthôŋ iyom ba êyê avômalô vi kambom. Êŋ ma Yisu hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Anyô ju i unyak matheŋ ek neteŋ mek. Anyô yaŋ ma Palisi ma yaŋ ma anyô hawa takis. ");
INSERT INTO hot_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Palisi êŋ da hamiŋ ba hateŋ mek nena, ‘Wapômbêŋ, mavi anôŋ ek ya anyô mavi ma ya miŋ hatôm anyô vi ami. Thêlô ma ŋê vani lôk ŋê kambom lôk ŋê idum sek haviŋ anyô yaŋ yanavi. Ma ya ma mi anôŋ, ya ma miŋ hatôm anyô hawa takis endaku ami. ");
INSERT INTO hot_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sonda te anêŋ wak ju ma yahavak balabuŋ ek nôm. Ma nômkama nômbêŋ atu ba yahawa ma yahabi sam hi ôdôŋ laumiŋ ba yahêv ôdôŋ te hadêŋ o.’ ");
INSERT INTO hot_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ma doŋtom anyô hawa takis hamiŋ daim ma hakô ek ênjê leŋ. Ma yani hakôm ba hatak baŋ luvi hêk madaluk siŋ ma hanaŋ, ‘Wapômbêŋ, ya anyô kambom ba nêm kapôlôm ek ya.’” ");
INSERT INTO hot_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma Yisu hanaŋ, “Yanaŋ êndêŋ môlô nena anyô hawa takis havôhi anêŋ unyak ma lêk anyô thêthôŋ hêk Wapômbêŋ ma. Ma anyô yaŋ ma mi. Ôpatu ba hêv anêŋ athêŋ liŋ ma tem Wapômbêŋ etauviŋ anêŋ athêŋ. Ma doŋtom ôpatu ba hatauviŋ i ma tem Wapômbêŋ nêm anêŋ athêŋ liŋ.” ");
INSERT INTO hot_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Avômalô ewa iniŋ avômena yaônena i hadêŋ Yisu ek etak baŋ êyô ênjêk thêlô. Ma anêŋ ŋê ku êyê ma ethaŋ i. ");
INSERT INTO hot_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma doŋtom Yisu halam avômena êlêm ma hanaŋ nena, “Notak avômena yaônena ba nêlêm êndêŋ ya ma miŋ numiŋ loŋ siŋ ami ek malê nena avômalô takatu ba athêŋ mi hatôm avômena takêntêk ma Wapômbêŋ anêŋ loŋ lôkliŋyak ma thêlôniŋ. ");
INSERT INTO hot_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yanaŋ avanôŋ êndêŋ môlô nena ôpatu ba miŋ hawa Wapômbêŋ anêŋ loŋ lôkliŋyak hatôm avômena yaônena ami ma miŋ hatôm imbitak êyô loŋ êŋ kapô ba ni ami. Ma mi.” ");
INSERT INTO hot_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Anyô bêŋ te hanaŋ hik Yisu liŋ nena, “Kêdôŋwaga mavi, ma yandum malê ek yamô lôkmala êtôm wak nômbêŋ intu sapêŋ?” ");
INSERT INTO hot_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma Yisu hanaŋ, “Holam ya nena mavi eka? Anyô late miŋ mavi ami ma Wapômbêŋ iyom intu ba mavi. ");
INSERT INTO hot_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Abô balabuŋ ma bôk hoyala yôv: ‘Miŋ undum sek imbiŋ anyô yaŋ yanavi ami. Miŋ nuŋgwik anyô vônô ami. Miŋ onja vani ami. Miŋ onaŋ abôyaŋ esak anyô vi ba undum abô ek i ami. Ma ondovak lemambô lo lemtambô.’” ");
INSERT INTO hot_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ma anyô bêŋ êŋ hanaŋ, “Ya yaôna aleba lêk ma yahasopa abô balabuŋ takêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma Yisu halaŋô ma hanaŋ hadêŋ ôpêŋ nena, “Mavi anôŋ, ma doŋtom nômlate hamô denaŋ. Nu nêm anêm nômkama sapêŋ ek avômalô nênêm vuli ma onja valuseleŋ sapêŋ ba nêm êndêŋ ŋê siv. Êŋ ma tem anêm nômkama mavi lomaloma êmô malak leŋ. Ma ôlêm osopa ya.” ");
INSERT INTO hot_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yani ma anyô lôk nômkama bêŋ anôŋ. Ba intu halaŋô abô êŋ ma hêv malaiŋ bêŋ hadêŋ yani ba hi lôk lamalaiŋ. ");
INSERT INTO hot_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yisu hayê yani lamalaiŋ ma hanaŋ, “Ŋê lôk nômkama bêŋ tem nêpôm malaiŋ bêŋ ek nimbitak nêyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ba ini. ");
INSERT INTO hot_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Avanôŋ biŋ nena miŋ malaiŋ bêŋ ek bok kamel imbitak êyô luvik idu sôp anêŋ abyaŋ ba ni ami, ma doŋtom malaiŋ anôŋ ek anyô lôk nômkama bêŋ te imbitak êyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô.” ");
INSERT INTO hot_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Avômalô elaŋô abô êŋ ma enaŋ nena, “Avanôŋ e? Aêŋ ba miŋ hatôm anyôla imbitak êyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô ba ni ami e?” ");
INSERT INTO hot_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma Yisu hanaŋ, “Nôm takatu ba anyô miŋ hatôm nindum ami, intu Wapômbêŋ hatôm indum.” ");
INSERT INTO hot_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma Pita hanaŋ, “Yêlô bôk atak yêlôaniŋ nômkama sapêŋ ba alêm asopa o.” ");
INSERT INTO hot_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ma Yisu hanaŋ hadêŋ thêlô nena, “Yanaŋ avanôŋ nena avômalô takatu ba leŋiŋhabi Wapômbêŋ anêŋ loŋ lôkliŋyak ba etak iniŋ unyak lo avi ma iviyaŋ lôk lami ma nali, ");
INSERT INTO hot_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ma thêlô êmô pik denaŋ ma Wapômbêŋ tem nêm iniŋ nômkama lôkthô êndêŋ i ba tem nêm bêŋ anôŋ êyô êmô iniŋ loŋ imbiŋ ma embeŋ yam ma tem nêm lôkmala atu ba nêmô êtôm wak nômbêŋ intu sapêŋ êndêŋ i imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yisu hawa ŋê ku laumiŋ ba lahavuju takatu hathak doŋtom ma hanaŋ, “Nodaŋô. Alalô ana daku Jelusalem ma abô tak sêbôk ba plopet eto hathak Anyô Anêŋ Nakaduŋ atu tem imbitak avanôŋ. ");
INSERT INTO hot_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tem nênêm yani êndôk ŋê loŋ buyaŋ Lom baheŋiŋ. Ma tem nemalik esak yani ba nenaŋ abô lomaloma esak yani ma nêsôvwapôk êyômô yani. ");
INSERT INTO hot_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ma nebali yani ba nijik yani vônô. Ma êtôm wak lô ma tem yani imbiyô esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma doŋtom ŋê ku miŋ eyala abô takêŋ ami. Abô êŋ anêŋ ôdôŋ ma havuŋ ek thêlô ba thêlô miŋ eyala ami ma êthôŋ paliŋ. ");
INSERT INTO hot_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yisu hayô habobo Jeliko ma anyô mapusip te hamô loŋôndê daŋ vi ba hapetenak ek avômalô nênêm yani sa. ");
INSERT INTO hot_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yani halaŋô avômalô bêŋ anôŋ ele ba i ma hanaŋ hik thêlô liŋ nena, “Malê?” ");
INSERT INTO hot_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma thêlô enaŋ hadêŋ yani nena, “Yisu anêŋ Nasalet halêm.” ");
INSERT INTO hot_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Êŋ ma anyô mapusip halam nena, “Yisu, Devit anêŋ Lim Lukmuk, nêm kapôlôm ek ya!” ");
INSERT INTO hot_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Avômalô takatu ba êmôŋ ethaŋ yani ba enaŋ, “O bônôŋ.” Ma doŋtom yani halam lôklala nena, “Devit anêŋ Lim Lukmuk, nêm kapôlôm ek ya!” ");
INSERT INTO hot_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Êŋ ma Yisu hamiŋ ma hanaŋ ek thêlô neja ôpêŋ êlêm. Yani hayô ma Yisu hanaŋ hik yani liŋ nena, ");
INSERT INTO hot_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Lemhaviŋ yandum malê êndêŋ o?” Ma ôpêŋ hanaŋ, “Anyô Bêŋ, yaleŋhaviŋ yaŋgê tak.” ");
INSERT INTO hot_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma Yisu hanaŋ hadêŋ ôpêŋ nena, “Nôŋgô tak. Anêm hôêvhaviŋ hadum ba hubitak mavi.” ");
INSERT INTO hot_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma ketheŋ oyaŋ ma ôpêŋ madaluk hakyav ba hayê tak. Ma yani hasopa Yisu lôk habô Wapômbêŋ anêŋ athêŋ. Ma avômalô nômbêŋ atu ba i haviŋ yani êyê nôm êŋ ba êbô Wapômbêŋ anêŋ athêŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisu hayô Jeliko ma hi iyom. ");
INSERT INTO hot_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma anyô lôk valuseleŋ bêŋ te hamô. Yani ma anyô bêŋ hawa takis ba anêŋ athêŋ nena Sakius. ");
INSERT INTO hot_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yani lahaviŋ ênjê nena Yisu ma opalê, ma doŋtom avômalô bêŋ anôŋ ma Sakius anyô bidoŋ ba miŋ hatôm ênjê ami. ");
INSERT INTO hot_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Êŋ ma yani halaŋviŋ hamôŋ ba hi ma hathak alokwaŋ sabo te ba hamô ek ênjê Yisu. ");
INSERT INTO hot_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yisu hayô loŋ êŋ ma hêv ma hathak leŋ ma hanaŋ, “Sakius, ôndôk ba ôlêm ketheŋ. Yaô ma tem yamô anêm unyak.” ");
INSERT INTO hot_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Êŋ ma ketheŋ oyaŋ ma Sakius halôk ma hawa Yisu thô lôk lamavi. ");
INSERT INTO hot_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ma avômalô sapêŋ êyê ba kapôlôŋiŋ diŋdiŋ ba enaŋ nena, “Yani hi hamô haviŋ anyô kambom te.” ");
INSERT INTO hot_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma doŋtom Sakius haviyô hamiŋ ma hanaŋ hadêŋ Anyô Bêŋ nena, “Anyô Bêŋ, ondaŋô. Tem yambi yenaŋ nômkama sam ni ôdôŋ ju ba yanêm yaŋ êndêŋ ŋê siv. Ma bôk yahasau anyôla ba yahawa anêŋ valuseleŋ doho vani, êŋ ma tem yanêm valuseleŋ êtôm dum ayova êyômô loŋ imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma Yisu hanaŋ hadêŋ yani nena, “Lêk ma Wapômbêŋ hêv avômalô unyak êntêk êŋ bulubiŋ ek malê nena yani ma Ablaham anêŋ nakaduŋ te. ");
INSERT INTO hot_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Anyô Anêŋ Nakaduŋ atu halêm ek êmbôlêm ŋê takatu ba êv yak ek nêm i bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Avômalô elaŋô abô êŋ yôv ma Yisu hanaŋ abô loŋ kapô te haviŋ ek malê nena yani lêk habobo Jelusalem. Ma avômalô takêŋ leŋiŋhabi nena yani hayô Jelusalem, êŋ ma Wapômbêŋ anêŋ loŋ lôkliŋyak tem imbitak êmô pik. ");
INSERT INTO hot_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Êŋ ma Yisu hanaŋ nena, “Anyô bêŋ te anêŋ namalô tem ni loŋ buyaŋ ek enja athêŋ lôk kuluŋ kiŋ vêmam ka êmbôlêm anêŋ malak ôdôŋ esak loŋbô ek eyabiŋ anêŋ avômalô. Loŋ êŋ ma daim kambom. ");
INSERT INTO hot_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Vêm ma yani halam anêŋ ŋê ku laumiŋ hathak doŋtom ma hêv valuseleŋ hatôm 100 hadêŋ thêlô tomtom sapêŋ. Ma hanaŋ aêntêk, ‘Môlô noja valuseleŋ êntêk ba nundum ku esak endeba yambô alêm esak loŋbô am.’ Yôv ma hatak thêlô ba hi. ");
INSERT INTO hot_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ma doŋtom yanida anêŋ avômalô kapôlôŋiŋ agiap ek yani. Êŋ ma yani hi loŋ buyaŋ ma thêlô êv anyô doho ba esopa yani ek nenaŋ aêntêk, ‘Yêlô adô anyô êntêk imbitak êtôm yêlôaniŋ kiŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ma doŋtom yani habitak kiŋ yôv ma havôhalêm ma hanaŋ aêntêk, ‘Nodam ŋê ku takatu ba bôk yahêv valuseleŋ hadêŋ i ek yayala nena thêlô tomtom bôk êvôv valuseleŋ vithê haviŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Êŋ ma anyô te hamôŋ hi ma hanaŋ, ‘Anyô bêŋ, yahadum ku hathak anêm valuseleŋ êŋ ba yahavôv valuseleŋ hatôm 1,000.’ ");
INSERT INTO hot_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ma anêŋ anyô bêŋ hanaŋ nena, ‘Mavi anôŋ! O anyô katô ba hudum ku mavi. Hoyabiŋ nôm yaôna dedauŋ mavi ba intu oyabiŋ malak lôŋ laumiŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Yôv ma anyô yaŋ halêm ma hanaŋ, ‘Anyô bêŋ, hathak anêm valuseleŋ, yahavôv valuseleŋ hatôm 500.’ ");
INSERT INTO hot_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ma anêŋ anyô bêŋ hanaŋ hadêŋ yani, ‘Oyabiŋ malak lôŋ baheŋvi.’ ");
INSERT INTO hot_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Yôv ma anyô ku te lô halêm ma hanaŋ, ‘Anyô bêŋ, anêm valuseleŋ atutêk. Yahavuvi halôk sôp ba yahadô hamô ");
INSERT INTO hot_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ek malê nena yahakô ek o. O ma anyô malem thêlêv. Hothak hôvôv anyô vi iniŋ nômkama ba howa hatôm anêm. Ma pik atu ba anyô yaŋ hapaliv yaŋvêk halôk ma hothak howa anêŋ anôŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Êŋ ma anêŋ anyô bêŋ hanaŋ, ‘O anyô ku mi kambom ba oda anêm abô intu hanaŋ o bêŋ. Bôk hoyala yôv nena ya hathak yahavôv anyô vi iniŋ nômkama ba yahawa hatôm yenaŋ. Lôk pik atu ba anyô yaŋ hapaliv yaŋvêk halôk ma ya hathak yahawa anêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ma aisê ka miŋ hotak yenaŋ valuseleŋ halôk unyak valuseleŋ ek êmbôv doho ami ek wakma atu ba yahavôhalêm hathak loŋbô ma tem yanja doho êyômô loŋ imbiŋ?’ ");
INSERT INTO hot_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Êŋ ma hanaŋ hadêŋ ŋê takatu ba imiŋ habobo nena, ‘Môlô noja anêŋ valuseleŋ hatôm 100 vê ênjêk yani ba nônêm êndêŋ ôpatu ba hawa 1,000.’ ");
INSERT INTO hot_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ma thêlô enaŋ hadêŋ yani nena, ‘Anyô bêŋ, yani anêŋ 1,000 bôk hamô yôv.’ ");
INSERT INTO hot_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ma yani hanaŋ, ‘Yanaŋ êndêŋ môlô nena ôpatu ba hadum ku mavi hathak yenaŋ nômkama ba habitak bêŋ, êŋ ma tem yatak doho êyômô loŋ imbiŋ ba yanêm êndêŋ ôpêŋ. Ma doŋtom ôpatu ba miŋ hadum ku hathak yenaŋ nômkama ami, êŋ ma tem yanêm dokte atu ba havaloŋ loŋ vê ênjêk yani.’ ");
INSERT INTO hot_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Ma doŋtom ŋê takatu leŋiŋmaniŋ hathak ya ba êdô ek yambitak iniŋ kiŋ, ‘Noja i êlêm loŋ êntêk ma uŋgwik i pôpônô ênjêk yamaleŋ.’” ");
INSERT INTO hot_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisu hanaŋ abô êŋ yôv ma hamôŋ ba hi Jelusalem. ");
INSERT INTO hot_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yisu habobo Betpagi lo Betani, malak ju êŋ hêk habobo Dum Oliv. Ma hêv anêŋ ŋê ku ju ba i ma hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mamu unu malak entuvulu. Ma numbitak nôyô ma tem ôŋgô ekak bok doŋki map te loŋ ba hamiŋ. Bok êŋ ma miŋ bôk anyôla hayô hamô ami. Ma nopole yak vê ma nondom ba nôlêm. ");
INSERT INTO hot_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma anyôla hanaŋ nena, ‘Mamu opole eka’, êŋ ma nonaŋ viyaŋ nena, ‘Anyô Bêŋ lahaviŋ indum ku te esak.’” ");
INSERT INTO hot_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yisu hêv thai ba i ma êyê nômkama sapêŋ hatôm atu ba yani hanaŋ. ");
INSERT INTO hot_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Thai epole bok doŋki êŋ anêŋ yak vê ma bok anêŋ alaŋsi enaŋ hadêŋ thai nena, “Mamu opole eka?” ");
INSERT INTO hot_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ma thai enaŋ, “Anyô Bêŋ lahaviŋ indum ku te esak.” ");
INSERT INTO hot_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Êŋ ma thai ewa bok doŋki ba i êv hadêŋ Yisu. Ma thai ibi iniŋ kwêv thilibuŋ daim thô ba eŋgava hayôhêk bok doŋki dômlokwaŋ, ma thai êv Yisu sa ek hathak hayô hamô bok êŋ. ");
INSERT INTO hot_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma Yisu hi ma avômalô eŋgava iniŋ kwêv thilibuŋ hêk loŋôndê. ");
INSERT INTO hot_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yani halôk Dum Oliv ek ni vi tuvulu Jelusalem. Ma avômalô nômbêŋ atu ba esopa yani leŋiŋmavi hathak nômbithi nômbêŋ atu ba bôk thêlô êyê. Ba êbô Wapômbêŋ ba elam nena, ");
INSERT INTO hot_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Wapômbêŋ nêm lamavi êndêŋ kiŋ atu ba halêm hathak Anyô Bêŋ anêŋ athêŋ! Avômalô malak leŋ leŋiŋmavi ma alalô nanêm athêŋ lôkmaŋgiŋ êndêŋ Wapômbêŋ esak leŋ ba ni.” ");
INSERT INTO hot_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma Palisi doho imiŋ avômalô takêŋ kapô ba enaŋ hadêŋ Yisu aêntêk, “Kêdôŋwaga, osaŋ anêm ŋê ku takêntêk.” ");
INSERT INTO hot_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma Yisu hanaŋ viyaŋ nena, “Yanaŋ êndêŋ môlô nena thêlô bônôŋ ma tem valu nendam kaêk.” ");
INSERT INTO hot_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yisu habobo Jelusalem ma hayê vi tuvulu ba halaŋ hathak avômalô Jelusalem ");
INSERT INTO hot_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ba hanaŋ, “Yaleŋhaviŋ lêk oyala nôm takatu ba nundum ek Wapômbêŋ indum môlô kapôlômim ênjêk yaô. Ma doŋtom mi, nôm takêŋ hamô loŋ kapô ba môlô miŋ hatôm ôŋgô ami. ");
INSERT INTO hot_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aêŋ ba waklavôŋ hayô ma ŋê vovak tem nêyô ba nedav badêŋ êwê embeŋ Jelusalem sapêŋ ba nêmô kapô ba nindum ek nijik môlô vônô. ");
INSERT INTO hot_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Thêlô tem nimbuliŋ môlônim loŋ sapêŋ ba nijik môlô takatu ba ômô unim badêŋ kapô vônô. Ma valu atu ba olav unyak hathak ma tem miŋ êyômô yaŋ loŋ ami. Nôm malaiŋ êŋ tem êlêm ek malê nena môlô miŋ oyala waklavôŋ atu ba Wapômbêŋ halêm pik ek nêm môlô bulubiŋ ami.” ");
INSERT INTO hot_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Vêm ma Yisu habitak hayô Wapômbêŋ anêŋ unyak matheŋ anêŋ piklêvôŋ. Ma hayê avômalô ewa nômkama ba êdô hamô ek avômalô vi nênêm vuli. Êŋ ma halupuniŋ i ba hêv i vê hêk unyak matheŋ kapô ba ele yaiŋ ba i. Ma hanaŋ hadêŋ thêlô aêntêk, ");
INSERT INTO hot_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Wapômbêŋ anêŋ kapya hanaŋ nena, ‘Yenaŋ unyak ma unyak neteŋ mek êndôk.’ Ma môlô lêk udum ba habitak hatôm ŋê vani iniŋ loŋ ekopak êmô.” ");
INSERT INTO hot_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma wak nômbêŋ intu ma yani hadôŋ avômalô halôk unyak matheŋ. Ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ lôk Islael iniŋ ŋê bêŋbêŋ, thêlô êbôlêm loŋôndê ek nijik Yisu vônô. ");
INSERT INTO hot_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma doŋtom thêlô miŋ hatôm nêpôm loŋôndê te ami ek malê nena avômalô sapêŋ leŋiŋmavi bêŋ ek Yisu ba êmô ek nedaŋô anêŋ abô sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wak te ma Yisu hadôŋ avômalô hamô Wapômbêŋ anêŋ unyak matheŋ anêŋ piklêvôŋ ba hanaŋ Wapômbêŋ anêŋ Abô Mavi hadêŋ i. Ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ ethak doŋtom haviŋ ŋê bêŋbêŋ ba i hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma thêlô enaŋ, “Opalê hêv athêŋ bêŋ hadêŋ o lôk hêv ku hadêŋ o ba intu hudum nôm takêntêk?” ");
INSERT INTO hot_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma Yisu hanaŋ viyaŋ nena, “Tem yanaŋ injik môlô liŋ esak abô te aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Opalê hêv ku nisik avômalô êndôk ŋaŋ hadêŋ Jon? Wapômbêŋ leŋ? Mena anyô pik?” ");
INSERT INTO hot_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma thêlôda enaŋ hadêŋ i nena, “Alalô anaŋ nena Wapômbêŋ hêv ku êŋ hadêŋ Jon ma tem yani enaŋ, ‘Ma aisê ka môlô miŋ ôêvhaviŋ yani ami?’ ");
INSERT INTO hot_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma doŋtom alalô anaŋ nena, ‘Anyô pik te hêv ku êŋ,’ êŋ ma avômalô tem nijik alalô esak valu ek malê nena thêlô êvhaviŋ nena Jon ma plopet te.” ");
INSERT INTO hot_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ma thêlô enaŋ hadêŋ Yisu nena, “Yêlô athôŋ paliŋ.” ");
INSERT INTO hot_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Êŋ ma Yisu hanaŋ hadêŋ thêlô, “Aêŋ ba miŋ hatôm yandam ôpatu ba hêv athêŋ bêŋ hadêŋ ya anêŋ athêŋ bêŋ êndêŋ môlô ami. Ma mi.” ");
INSERT INTO hot_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ma Yisu hanaŋ abô loŋ kapô te hadêŋ avômalô, “Anyô te havatho anêŋ ku yak waiŋ ma hêv hadêŋ ŋê ku doho ek neyabiŋ ba hanaŋ nena, ‘Waklavôŋ yak waiŋ hik anôŋ ma nombak vose ni ôdôŋ ju ba nônêm vi êndêŋ ya ma noja vi êtôm môlônim vuli.’ Ma hi hamô loŋ buyaŋ sawa daim. ");
INSERT INTO hot_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ma waklavôŋ yak waiŋ hik anôŋ hayô ma hêv anêŋ anyô ku te ba hi hadêŋ thêlô ek enja anêŋ sam. Ma doŋtom thêlô ik yani kambom ba êv yani hi oyaŋ. ");
INSERT INTO hot_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Êŋ ma ku anêŋ alaŋ hêv anyô ku yaŋ ba hi hadêŋ thêlô, ma doŋtom thêlô idum kobom kambom hadêŋ yani lôk ik yani ma êv yani vê oyaŋ ba hi. ");
INSERT INTO hot_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yôv ma hêv anyô ku te lô ba hi, ma doŋtom ŋê ku takêŋ ibuliŋ yani ma êvôv yani ba ibi yani hi. ");
INSERT INTO hot_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Aêŋ ba ku alaŋ hanaŋ hadêŋ yanida nena, ‘Yandum malê? Tem yanêm yenaŋ okna atu ba yaleŋhaviŋ bêŋ anôŋ. Yahadum aêŋ ma tem nedaŋô anêŋ abô.’ ");
INSERT INTO hot_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ma doŋtom ŋê ku êyê namalô hayô ma enaŋ hadêŋ i nena, ‘Ôpêntêk ma ku alaŋ anêŋ nakaduŋ ba tem eyabiŋ lambô anêŋ ku. Alalô ik yani vônô ma ku êŋ tem imbitak alalôaniŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ba intu evaloŋ yani ba êvôv hale yaiŋ ma ik yani vônô. “Aêŋ ba ku anêŋ alaŋ tem indum malê êndêŋ thêlô? ");
INSERT INTO hot_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tem ni injik ŋê ku takêŋ vônô ma nêm ku êŋ êndêŋ anyô vi ek neyabiŋ.” Ma avômalô elaŋô abô loŋ kapô êŋ ma enaŋ, “Yêlô adô abô loŋ kapô êŋ injik anôŋ!” ");
INSERT INTO hot_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma doŋtom Yisu hatitiŋ thêlô lôklokwaŋ ma hanaŋ, “Ma bôk eto abô êntêk aêŋ eka? “‘Valu atu ba ŋê elav unyak êpôlik hathak, ma lêk habitak landiŋ anôŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ma avômalô takatu ba êv yak hayôhêk valu êntêk, ma tem nipup nenanena. Mena valu êŋ hêv yak hayôhêk anyôla, ma tem ipulusik ba imbitak malimmalim.” ");
INSERT INTO hot_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ eyala nena Yisu hanaŋ abô loŋ kapô êŋ hathak thêlô. Ba intu êbôlêm loŋôndê ek nebaloŋ yani, ma doŋtom êkô hathak avômalô. ");
INSERT INTO hot_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yôv ma ŋê bêŋbêŋ maleŋ hadahaliŋ Yisu ek nebaloŋ yani esak anêŋ abô. Ma thêlô êv ŋê kambom doho vuli ek nimbitak êtôm ŋê thêthôŋ ek nesau Yisu. Thêlô elav gwasilim ek nebaloŋ Yisu anêŋ abô êndôk ba nênêm yani êndêŋ Lom iniŋ anyô bêŋ Pailat. ");
INSERT INTO hot_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Êŋ ma thêlô enaŋ hadêŋ Yisu nena, “Kêdôŋwaga, yêlô ayala nena anêm abô sapêŋ ma abô avanôŋ iyom. Ma hudum kobom doŋtom hadêŋ avômalô sapêŋ lôk hôdôŋ avômalô hathak Wapômbêŋ anêŋ abô ma thêthôŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aêŋ ba lemhabi aisê? Bumalô iniŋ balabuŋ hanaŋ nena yêlô hatôm nanêm valuseleŋ êndêŋ Sisa mena mi e?” ");
INSERT INTO hot_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yisu hayala thêlôniŋ auk ba hanaŋ hadêŋ thêlô, ");
INSERT INTO hot_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Môlô uŋgwik valuseleŋ te thô ek yaŋgê. Opalê anêŋ dahô lôk athêŋ hêk valuseleŋ êntêk?” Ma thêlô enaŋ, “Sisa.” ");
INSERT INTO hot_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Êŋ ma Yisu hanaŋ hadêŋ thêlô nena, “Sisa anêŋ nômkama ma nônêm êndêŋ Sisa da. Ma Wapômbêŋ anêŋ nômkama ma nônêm êndêŋ Wapômbêŋ da.” ");
INSERT INTO hot_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yisu hanaŋ aêŋ ba avômalô sapêŋ elaŋô. Ba intu ŋê êŋ miŋ hatôm nebaloŋ yani esak anêŋ abô ami. Ma esoŋ kambom hathak anêŋ abô ba thêlô bônôŋ. ");
INSERT INTO hot_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ma Sadyusi doho i hadêŋ Yisu. Thêlô ma ôdôŋ te atu ba enaŋ nena ŋê ŋama tem miŋ nimbiyô esak loŋbô ami. Aêŋ ba intu enaŋ hik Yisu liŋ nena, ");
INSERT INTO hot_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Kêdôŋwaga, Mose hato hadêŋ alalô nena, ‘Anyô te hama ba nali mi ma anêŋ yaŋ hamô, ma enja avi tôp êŋ ek imbi yaŋ atu ba hama anêŋ nakaduŋ vê.’ ");
INSERT INTO hot_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aêŋ ba ŋê lôk iviyaŋ baheŋvi ba lahavuju êmô. Ma bôp hawa avi te ba hama ma nakaduŋ mi. ");
INSERT INTO hot_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma nôk enja avi tôp êŋ, hawa ba hama ba nakaduŋ mi. ");
INSERT INTO hot_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ma ŋgwa aêŋ iyom. Ma iviyaŋ takatu ba êmô ma nesopa kobom doŋtom êŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Vêm ma avi tôp êŋ hama haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ma waklavôŋ ŋê ŋama iviyô hathak loŋbô ma avi tôp atu ba ŋê lôk iviyaŋ baheŋvi ba lahavuju takatu ba ewa ma alisê te anêŋ avi?” ");
INSERT INTO hot_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma Yisu hanaŋ viyaŋ hadêŋ thêlô nena, “Avômalô pik ethak ewa i, ");
INSERT INTO hot_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ma doŋtom avômalô takatu ba Wapômbêŋ hêv i bulubiŋ ba ewa lôkmala hathak loŋbô, thêlô êŋ miŋ hatôm neja i esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Thêlô ma tem nêtôm aŋela ba intu tem miŋ nema ami. Wapômbêŋ bôk hik thêlô liŋ yôv hêk ŋama ba intu hik thô nena thêlô ma yani anêŋ nali. ");
INSERT INTO hot_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Mose da anêŋ abô hik thô nena ŋê ŋama tem nimbiyô esak loŋbô. Sêbôk ba Mose hayê atum hathaŋ hamô alokwaŋ liŋ ma halam Anyô Bêŋ nena ‘Ablaham lo Aisak ma Jekop iniŋ Wapômbêŋ.’ ");
INSERT INTO hot_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Alalô ayala nena Wapômbêŋ ma miŋ ŋê ŋama iniŋ Wapômbêŋ ami. Mi, yani ma ŋê lôkmala iyom iniŋ Wapômbêŋ ek malê nena yani hayala nena avômalô lôkthô ma êmô lôkmala.” ");
INSERT INTO hot_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ŋê lôkauk hathak abô balabuŋ doho elaŋô abô êŋ ma enaŋ hadêŋ Yisu aêntêk, “Êê, Kêdôŋwaga, anêm abô ma mavi anôŋ!” ");
INSERT INTO hot_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma avômalô sapêŋ elaŋô anêŋ abô ba êkô ma miŋ enaŋ hik yani liŋ ek nesau yani esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yôv ma Yisu hanaŋ hadêŋ thêlô nena, “Avômalô ethak enaŋ nena Mesia ma Devit anêŋ lim lukmuk eka? ");
INSERT INTO hot_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Hêk Kapya Yeŋ kapô ma Devit da hanaŋ aêntêk, “‘Anyô Bêŋ Wapômbêŋ hanaŋ hadêŋ yenaŋ Anyô Bêŋ Mesia nena, “Ômô yabaheŋ vianôŋ ");
INSERT INTO hot_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","endeba yatak ŋê takatu ba ik vovak hadêŋ o nêmô vemkapô vibiŋ am.” ’ ");
INSERT INTO hot_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ma Devit da bôk halam Mesia nena anêŋ Anyô Bêŋ. Ma aisê ka Mesia ma yani anêŋ lim lôk anêŋ Anyô Bêŋ imbiŋ?” ");
INSERT INTO hot_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Avômalô elaŋô Yisu anêŋ abô imiŋ denaŋ ma Yisu hanaŋ hadêŋ anêŋ ŋê ku aêntêk, ");
INSERT INTO hot_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Môlô noyabiŋ am ek ŋê lôkauk hathak abô balabuŋ. Thêlô leŋiŋhaviŋ nijik kwêv daim kêkêlô ba nembeŋ ek avômalô nebam i. Ma leŋiŋhaviŋ avômalô nenaŋ nena, ‘Waklêvôŋ anyô bêŋ’ êmô loŋ ethak doŋtom halôk. Ma leŋiŋhaviŋ nêmô êtôm ŋê bêŋbêŋ êmô unyak yeŋ kapô. Ma avômalô eŋgabôm nôm bêŋ ma leŋiŋhaviŋ nejaŋ nôm êmô ŋê bêŋbêŋ iniŋ loŋ ethak êmô. ");
INSERT INTO hot_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Thêlô esau avi tôp ek neja iniŋ unyak ba eteŋ mek daim bomaŋ ek avômalô nêgê. Wapômbêŋ tem nêm vovaŋ kambom êndêŋ i.” ");
INSERT INTO hot_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisu hamô Wapômbêŋ anêŋ unyak ba hayê ŋê lôk nômkama bêŋ etak iniŋ valuseleŋ halôk alapa da. ");
INSERT INTO hot_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma avi tôp te atu ba nômkama mi anôŋ hayô ma hatak anêŋ da hatôm valuseleŋ thalaleŋ ju iyom halôk alapa da êŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yisu hayê ma hanaŋ nena, “Yanaŋ avanôŋ biŋ êndêŋ môlô nena avi tôp êntêk hêv valuseleŋ bêŋ anôŋ hamôŋ ek avômalô takêntêk sapêŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Avômalô nômbêŋ êntêk iniŋ valu bêŋ anôŋ hamô ma doŋtom êv doktena iyom. Ma avi tôp êntêk ma nômkama mi anôŋ ma lêk hêv anêŋ valuseleŋ sapêŋ ba miŋ havaloŋ dokte loŋ ami.” ");
INSERT INTO hot_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ŋê ku doho enaŋ abô hathak valu kêkêlô lôk nôm da mavi anôŋ atu ba etak hathak unyak matheŋ ek anêŋ lêlêyaŋ mavi anôŋ. Êŋ ma Yisu hanaŋ, ");
INSERT INTO hot_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Odaŋô katô. Nôm takêntêk ba lêk môlô ôyê, malaiŋ bêŋ tem imbitak ba ŋê vovak tem nijik nômkama mavi nômbêŋ êntêk pesa ba valu yaŋ miŋ hatôm êyômô yaŋ loŋ ami.” ");
INSERT INTO hot_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma thêlô enaŋ hik Yisu liŋ nena, “Kêdôŋwaga, aŋgê intu nôm takêŋ tem imbitak? Ma malê intu tem imbitak ek injik thô nena nôm takêŋ lêk habobo?” ");
INSERT INTO hot_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma Yisu hanaŋ, “Noyabiŋ am, avômalô tem nindum ek nesau môlô. Ŋê lomaloma tem nêlêm esak yenaŋ athêŋ ba nenaŋ nena, ‘Ya ma Mesia atu’. Lôk nenaŋ nena, ‘Waklavôŋ pik lo leŋ anêŋ daŋ lêk habobo tem êyô.’ Ma doŋtom miŋ nônêmimbiŋ iniŋ abô ba nosopa ami. ");
INSERT INTO hot_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Môlô olaŋô vovak bêŋ ba avômalô iki vônô, êŋ ma miŋ nôkô ami. Nôm takêŋ tem imbitak êmôŋ, ma doŋtom pik lo leŋ anêŋ daŋ tem miŋ imbitak ketheŋ oyaŋ ami.” ");
INSERT INTO hot_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Êŋ ma Yisu hanaŋ, “Ma avômalô ôdôŋ yaŋ tem nijik vovak imbiŋ ôdôŋ yaŋ. Ma kiŋ yaŋ lôk anêŋ avômalô tem nijik vovak êndêŋ kiŋ yaŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma loŋ lomaloma ma duviaŋ lôk bôm ma lijiŋ bêŋ tem êyô injik avômalô bêŋ anôŋ vônô. Lavôŋiŋ lôkmaŋgiŋ lomaloma tem ênjêk leŋlêvôŋ ba indum avômalô nêkô kambom anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma nôm takêŋ tem miŋ imbitak ami denaŋ ma tem nebaloŋ môlô ba nindum kambom êndêŋ môlô. Ma tem nenaŋ môlô bêŋ imiŋ unyak yeŋ lôk nindum abô ek netak môlô êndôk koladôŋ. Môlô osopa ya ba intu tem neja môlô ba unu numiŋ kiŋ lôk iniŋ ŋê bêŋbêŋ maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma nôm êŋ tem imbitak êtôm loŋôndê ek nonaŋ yenaŋ Abô Mavi bêŋ êndêŋ i. ");
INSERT INTO hot_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma miŋ lemimimbi nena, ‘Dokte ka yêlô nanaŋ aisê êndêŋ thêlô’ ami. ");
INSERT INTO hot_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ek malê nena yada tem yanêm abô lôkauk mavi êndêŋ môlô. Ma ŋê takatu ba idum abô ek môlô ma miŋ hatôm nijik abô êŋ pesa ami. ");
INSERT INTO hot_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Avômalô tem nenaŋ môlô bêŋ ba tem nijik môlô doho vônô ma môlônim lemami lôk môlôviyaŋ lôk anêm thalaleŋ lôk anêm anyô môlô tem nindum aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Môlô ma yenaŋ avômalô ba intu avômalô sapêŋ tem nêpôlik esak môlô. ");
INSERT INTO hot_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma doŋtom Wapômbêŋ tem eyabiŋ môlô ba lemimkadôk ŋauŋ te miŋ hatôm nêm yak ami. ");
INSERT INTO hot_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ma môlô numiŋ lôklokwaŋ ma tem noja lôkmala êtôm wak nômbêŋ intu sapêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ma Yisu hanaŋ, “Môlô ôyê nena ŋê vovak lodôŋlodôŋ êyô eveŋ Jelusalem luvi, êŋ ma môlô noyala nena tem nimbuliŋ malak lôŋ êŋ ketheŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aêŋ ba môlô takatu ba ômô Judia kapô, ma nôsôv ba unu dumlolê. Ma môlô takatu ba ômô Jelusalem kapô, ma unu viyaiŋ ketheŋ. Ma môlô takatu ba ômô Jelusalem viyaiŋ, ma miŋ unu kapô ami. ");
INSERT INTO hot_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ek malê nena waklavôŋ êŋ ma Wapômbêŋ anêŋ wakma nêm vovaŋ viyaŋ ek abô takatu ba hêk Wapômbêŋ anêŋ kapya ma tem injik anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ai, kikaknena. Waklavôŋ êŋ ma tem malaiŋ bêŋ ek avi takatu ba esabeŋ lôk avi takatu ba êv sôm hadêŋ nali ek malê nena malaiŋ lôk vovaŋ bêŋ tem imbitak Islael iniŋ pik êntêk, ma Wapômbêŋ anêŋ lamaniŋ tem êyô êmô avômalô pik êŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ŋê vovak tem ini Jelusalem ma iniŋ biŋ vovak tem injik avômalô Jelusalem pôpônô. Ma tem neja avômalô Jelusalem vi ba ini pik lomaloma. Ma avômalô loŋ buyaŋ tem nêyô nêmô Jelusalem ba neyabiŋ Jelusalem endeba ŋê loŋ buyaŋ iniŋ waklavôŋ anêŋ daŋ am.” ");
INSERT INTO hot_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ma lavôŋiŋ tem êpôm wak lo ayôŋ ma vuliŋ. Ma ŋgwêk budum tem injik ba pôk lôklala bomaŋ ba avômalô pik sapêŋ tem nedaŋô ba nêkô kambom anôŋ ba iniŋ auk tem ni mayaliv. ");
INSERT INTO hot_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ma nôm takatu ba hamô leŋ tem nedowaliŋ ba avômalô tem nêkô ba nemayak esak malaiŋ bêŋ atu ba tem imbitak pik. ");
INSERT INTO hot_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ma wak êŋ ma tem thêlô nêgê Anyô Anêŋ Nakaduŋ atu tem êyô êmô buliv ba êlêm imbiŋ anêŋ lôkliŋyak lôk anêŋ deda lôkmaŋgiŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nômkama takêŋ hadum ek imbitak ma numiŋ ba nônêm malemim esak leŋ ek malê nena waklavôŋ Wapômbêŋ nêm môlô vê ênjêk unim malaiŋ lêk habobo.” ");
INSERT INTO hot_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma Yisu hanaŋ abô loŋ kapô te hadêŋ thêlô aêntêk, “Lemimimbi esak alokwaŋ beleŋ lôk alokwaŋ vi imbiŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ôyê nena alokwaŋ takêntêk habi ŋauŋ belap, êŋ ma oyala nena wak mavi lêk habobo. ");
INSERT INTO hot_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ma aêŋ iyom, môlô ôyê nôm takêŋ habitak, êŋ ma noyala nena Wapômbêŋ anêŋ loŋ lôkliŋyak tem êyô ketheŋ. ");
INSERT INTO hot_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Yanaŋ avanôŋ êndêŋ môlô nena avômalô bôlôŋ êntêk tem miŋ nema ami denaŋ ma nôm takêntêk sapêŋ tem imbitak. ");
INSERT INTO hot_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Pik lo leŋ tem nêm yak ba ni, ma doŋtom yenaŋ abô bute miŋ hatôm nêm yak ami. ");
INSERT INTO hot_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Môlô noyabiŋ am. Anyô Anêŋ Nakaduŋ tem êlêm esak loŋbô ba tem êpôm avômalô pik sapêŋ. Môlô udum pik anêŋ kobom ba unum waiŋ ba olo molo lôk lemimhikam hathak nômkama pik, ma wak êŋ tem enja môlô ketheŋ êtôm gwasilim ba tem nosoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aêŋ ba wak nômbêŋ intu ma môlô noyabiŋ am lôklokwaŋ ba noteŋ mek ek Wapômbêŋ nêm môlô sa ek numiŋ lôklokwaŋ ek nôm takêntêk miŋ hatôm imbuliŋ môlô ami. Êŋ ma môlô hatôm numiŋ Anyô Anêŋ Nakaduŋ atu ma.” ");
INSERT INTO hot_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wak nômbêŋ intu ma Yisu hadôŋ avômalô hamô Wapômbêŋ anêŋ unyak matheŋ. Ma bôlôvôŋ ma yani hathak hi hamô Dum Oliv. ");
INSERT INTO hot_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma lôkbôk momaŋiniŋ ma avômalô sapêŋ ethak i unyak matheŋ ek elaŋô Yisu anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Waklavôŋ anêŋ athêŋ nena Eyaŋ Polom Yis Mi lêk habobo ba thêlô elam waklavôŋ êŋ nena Hale Ba Hi. ");
INSERT INTO hot_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ êbôlêm loŋôndê ek nijik Yisu vônô ek malê nena thêlô êkô ek avômalô. ");
INSERT INTO hot_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma Sadaŋ halôk Judas Iskaliot la. Yani ma ŋê ku laumiŋ ba lahavuju takatu te. ");
INSERT INTO hot_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yani hi ba hanaŋ abô haviŋ ŋê bêŋbêŋ êbôk da lôk unyak matheŋ iniŋ sôp bidoŋ nena yani tem enaŋ Yisu bêŋ aisê? ");
INSERT INTO hot_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ŋê êŋ leŋiŋmavi ma thêlô evak abô ek nênêm valuseleŋ êndêŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Êŋ ma Judas halôk hathak thêlôniŋ abô ba hadum ek nêm Yisu êndôk thêlô baheŋiŋ êndêŋ wak te atu ba avômalô miŋ êmô haviŋ Yisu ami. ");
INSERT INTO hot_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Waklavôŋ anêŋ athêŋ nena Eyaŋ Polom Yis Mi hayô. Wak êŋ ma thêlô ik boksipsip nakaduŋ te vônô ek leŋiŋhabi waklavôŋ anêŋ athêŋ nena Hale ba Hi. ");
INSERT INTO hot_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Êŋ ma Yisu hêv Pita lo Jon ba i ma hanaŋ, “Mamu unu nôpôpêk nôm waklavôŋ Hale ba Hi ek alalô aŋgaŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma thai enaŋ hik Yisu liŋ, “Yai napôpêk nôm êmô êsê?” ");
INSERT INTO hot_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ma Yisu hanaŋ hadêŋ thai nena, “Odaŋô. Mamu unu malak bêŋ kapô ma tem nôpôm anyô te hawa ŋaŋ lôk uŋ. Ma nosopa yani ba numbitak nôyô unyak atu ba yani habitak hayô ba hi. ");
INSERT INTO hot_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Êŋ ma nonaŋ êndêŋ unyak anêŋ alaŋ nena, ‘Kêdôŋwaga hanaŋ hik o liŋ nena unyak kapô atu ba yaŋgaŋ nôm waklavôŋ Hale ba Hi imbiŋ yenaŋ ŋê ku hamô êsê?’ ");
INSERT INTO hot_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Êŋ ma tem injik unyak kapô bêŋ atu ba hêk vuliŋ thô êndêŋ mamu. Unyak kapô êŋ ma nômkama sapêŋ bôk hamô yôv. Ba intu nôpôpêk nôm êmô loŋ êŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Êŋ ma thai i ma êpôm nômkama sapêŋ hatôm atu ba yani hanaŋ. Êŋ ma thai êpôpêk waklavôŋ Hale ba Hi anêŋ nôm. ");
INSERT INTO hot_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wakma nejaŋ nôm hayô ma Yisu hayaŋ nôm hamô haviŋ anêŋ aposel. ");
INSERT INTO hot_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma Yisu hanaŋ hadêŋ thêlô nena, “Ya vovaŋ ek yaŋgaŋ nôm waklavôŋ Hale ba Hi imbiŋ môlô vêm ka yanja vovaŋ. ");
INSERT INTO hot_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yahanaŋ avanôŋ nena tem miŋ yaŋgaŋ nôm êntêk esak loŋbô ami endeba waklavôŋ Hale ba Hi injik anôŋ ênjêk Wapômbêŋ anêŋ loŋ lôkliŋyak am.” ");
INSERT INTO hot_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ma yani hawa waiŋ lôk tase ma hêv lamavi ma hanaŋ, “Noja ba nunum imbiŋ am. ");
INSERT INTO hot_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yanaŋ êndêŋ môlô nena tem miŋ hatôm yanum waiŋ esak loŋbô ami endeba Wapômbêŋ anêŋ loŋ lôkliŋyak êlêm am.” ");
INSERT INTO hot_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ma yani hawa polom te ma hêv lamavi ma haya ba hêv hadêŋ thêlô ma hanaŋ, “Êntêk ma yenaŋ vathiap atu ba yahêv ek nêm môlô sa. Nundum aêŋ ek lemimimbi ya.” ");
INSERT INTO hot_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Eyaŋ vêm ma hadum aêŋ hathak tase lôk waiŋ ma hanaŋ, “Êntêk ma tabô lukmuk atu ba yahavak hathak yenaŋ thalaleŋ ba tem yaŋgasô ek nêm môlô sa. ");
INSERT INTO hot_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ma doŋtom odaŋô. Ôpatu ba tem enaŋ ya bêŋ lêk hayaŋ nôm haviŋ ya. ");
INSERT INTO hot_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Anyô Anêŋ Nakaduŋ atu tem indum êtôm atu ba Wapômbêŋ bôk hanaŋ yôv, ma doŋtom alikakna. Malaiŋ bêŋ ek ôpatu ba hanaŋ yani bêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ŋê ku elaŋô abô êŋ ma thêlôda enaŋ hik i liŋ nena, “Opalê te tem indum nôm êŋ?” ");
INSERT INTO hot_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma Yisu anêŋ ŋê ku êkôki nena thêlôniŋ opalê tem êtôm thêlôniŋ anyô bêŋ êmô loŋ lôkliŋyak atu ba tem imbitak embeŋ yam. ");
INSERT INTO hot_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma Yisu hanaŋ hadêŋ thêlô nena, “Avômalô daluk iniŋ kiŋ ethak ebam i ba ibuliŋ ŋê takatu ba êmô thêlô vibiŋ. Ma ŋê lôk athêŋ leŋiŋhaviŋ avômalô nebam thêlô nena ‘Ŋê wapôm mavi’. ");
INSERT INTO hot_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ma doŋtom môlô miŋ nundum aêŋ ami. Môlônim anyô lôk athêŋ indum êtôm anyô athêŋ mi. Ma môlônim anyô bêŋ indum ku êtôm anyô ku oyaŋ. ");
INSERT INTO hot_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Opalê te ma anyô bêŋ, ôpatu ba halôk hamô ba hayaŋ nôm mena ôpatu ba hapôpêk nôm? Ôpatu ba halôk hamô ba hayaŋ nôm, aêŋ e? Ma doŋtom yahamô haviŋ môlô hatôm anyô ku te. ");
INSERT INTO hot_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Môlô takatu ba malaiŋ lomaloma habitak ma doŋtom ômô haviŋ ya denaŋ. ");
INSERT INTO hot_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Ma yahêv athêŋ ‘kiŋ’ hadêŋ môlô hatôm wakamik hêv hadêŋ ya ek môlô tem oŋgwaŋ nôm lôk nunum ŋaŋ imbiŋ ya êmô yenaŋ loŋ lôkliŋyak. Ma môlô tem nôtôm kiŋ ek noyabiŋ avômalô Islael ôdôŋ laumiŋ ba lahavuju takatu.” ");
INSERT INTO hot_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ma Yisu hanaŋ, “Saimon, Saimon, ondaŋô. Sadaŋ hanaŋ hik Wapômbêŋ liŋ ek yani êyôkwiŋ môlô êtôm lovak hayôkwiŋ alokwaŋ te ek ênjê nena o lôklokwaŋ mena mi e? ");
INSERT INTO hot_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma doŋtom lêk yahateŋ mek yôv ek anêm hôêvhaviŋ miŋ nêm yak ami. Ma hole o liliŋ, êŋ ma ombatho môlôviyaŋ loŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma doŋtom Pita hanaŋ, “Anyô Bêŋ, ya anyô lôklokwaŋ ba ya hatôm yamô koladôŋ ba yama imbiŋ o.” ");
INSERT INTO hot_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma doŋtom Yisu hanaŋ nena, “Pita, yanaŋ êndêŋ o nena bôlôvôŋ êntêk ma tale miŋ halaŋ ami denaŋ, ma tem onaŋ êtôm bôlôŋ lô nena hôthôŋ ya paliŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yôv ma Yisu hanaŋ hadêŋ thêlô aêntêk, “Bôk yahêv môlô ba u ma miŋ môlô owa valuseleŋ lôk vak lôk vemimkapô bokŋgôp haviŋ môlô ami. Wak êŋ ma môlô nômkama mi e?” Ma thêlô enaŋ, “Mi, hamô.” ");
INSERT INTO hot_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma Yisu hanaŋ hadêŋ thêlô nena, “Ma doŋtom lêk anêm valuseleŋ lôk vak hamô ma noja. Ma o biŋ vovak mi, ma nêm anêm kwêv daim ek nênêm vuli ma onja biŋ vovak esak. ");
INSERT INTO hot_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ek malê nena Wapômbêŋ anêŋ kapya hanaŋ aêntêk, ‘Thêlô tem nêgê yani êtôm anyô kambom te.’ Abô êŋ tem injik anôŋ esak ya ma nômkama sapêŋ atu ba hathak ya ma anêŋ daŋ tem êyô.” ");
INSERT INTO hot_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma thêlô enaŋ, “Anyô Bêŋ, nôŋgô yêlôaniŋ biŋ vovak ju êntêk hamiŋ.” Ma Yisu hanaŋ hadêŋ thêlô nena, “Yôv.” ");
INSERT INTO hot_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yisu hatak Jelusalem ma hi Dum Oliv hatôm hathak hadum, ma ŋê ku esopa yani. ");
INSERT INTO hot_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yisu hayô loŋ êŋ ma hanaŋ hadêŋ thêlô nena, “Noteŋ mek ek miŋ nônêm yak ba nundum kambom ami.” ");
INSERT INTO hot_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ma hatak thêlô ba hi daim dokte. Ma halek vadôŋ lêlô ma hateŋ mek aêntêk, ");
INSERT INTO hot_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Wakamik, lemhaviŋ nêm tase êntêk vê ênjêk ya, ma nêm vê. Ma doŋtom miŋ osopa yenaŋ yaleŋhaviŋ ami. Mi, osopa oda anêm lemhaviŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma aŋela te anêŋ leŋ hayô ek yani ma havatho yani loŋ. ");
INSERT INTO hot_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yisu kapô malaiŋ kambom ba hateŋ mek lôklokwaŋ ba vovanik hatektek halôk pik hatôm thalaleŋ. ");
INSERT INTO hot_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yani hateŋ mek yôv ma haviyô hamiŋ ma hi hadêŋ anêŋ ŋê ku ma hayê thêlô êk sôm ek malê nena thêlôniŋ kapôlôŋiŋ malaiŋ kambom. ");
INSERT INTO hot_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma hanaŋ hadêŋ thêlô, “Môlô ôêk sôm eka? Numbiyô noteŋ mek ek miŋ nônêm yak ba nundum kambom ami.” ");
INSERT INTO hot_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yisu hanaŋ abô denaŋ ma avômalô bêŋ anôŋ êyô. Ôpatu ba elam nena Judas, yani ma ŋê ku laumiŋ ba lahavuju takatu te, intu halom thêlô ba êlêm. Yani hayô ek indiŋu Yisu, ");
INSERT INTO hot_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ma doŋtom Yisu hanaŋ hik ôpêŋ liŋ aêntêk, “Judas, hudum ek undiŋu Anyô Anêŋ Nakaduŋ atu ek onaŋ yani bêŋ e?” ");
INSERT INTO hot_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Êŋ ma ŋê ku eyala nôm atu ba tem imbitak ba intu enaŋ, “Anyô Bêŋ, yêlô naŋgik thêlô esak biŋ vovak e?” ");
INSERT INTO hot_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Êŋ ma thêlôniŋ anyô te hale anyô bêŋ habôk da anêŋ anyô ku te limbuk vianôŋ vê. ");
INSERT INTO hot_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma Yisu hayê ma hanaŋ, “Dô.” Ma hatak baŋ hayôhêk ôpêŋ limbuk ma habitak mavi hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Êŋ ma Yisu hanaŋ hadêŋ ŋê bêŋbêŋ êbôk da lôk unyak matheŋ iniŋ sôp bidoŋ lôk ŋê bêŋbêŋ takatu ba êlêm ek nebaloŋ yani aêntêk, “Ya ma anyô kambom anôŋ ba intu owa biŋ vovak lôk okdiba ba ôlêm ek nobaloŋ ya e? ");
INSERT INTO hot_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aisê? Wak nômbêŋ intu ma yahamô unyak matheŋ anêŋ piklêvôŋ haviŋ môlô ma miŋ ovaloŋ ya ami eka? Ma doŋtom lêk ma momaŋiniŋ hayabiŋ pik ba intu môlônim waklavôŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ma evaloŋ Yisu ba ewa ba i êyô anyô bêŋ habôk da anêŋ unyak. Ma Pita hasopa haveŋ yam ma doŋtom haveŋ daim dokte. ");
INSERT INTO hot_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Anyô doho ebaŋ atum hamô unyak êŋ anêŋ badêŋ kapô, ma Pita hi halôk hamô haviŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita hamô atum deda ma avi ku te hatitiŋ yani ma hanaŋ, “Anyô êntêk ma hathak hamô haviŋ Yisu.” ");
INSERT INTO hot_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma doŋtom Pita hanaŋ, “Livôŋ, yahathôŋ ôpêŋ paliŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kasana ma anyô yaŋ hayê yani ma hanaŋ, “O ma ŋê takatu iniŋ anyô te.” Ma doŋtom Pita hanaŋ, “Mi anôŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yani hamô hatôm wakma te ma anyô yaŋ hanaŋ lôklokwaŋ hathak loŋbô nena, “Avanôŋ biŋ, yani ma anyô Galili te. Aêŋ ba yani ma Yisu anêŋ anyô ku te.” ");
INSERT INTO hot_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma Pita hanaŋ, “Aiyaŋ, yahathôŋ anêm abô paliŋ!” Pita hanaŋ denaŋ ma tale halaŋ. ");
INSERT INTO hot_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma Anyô Bêŋ hik i liliŋ ma hatitiŋ Pita ma Pita lahabi anêŋ abô atu ba hanaŋ, “Tale miŋ halaŋ ami denaŋ ma tem onaŋ êtôm bôlôŋ lô nena hôthôŋ ya paliŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Êŋ ma Pita hale yaiŋ ma lahiki ba halaŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ŋê takatu ba evaloŋ Yisu enaŋ abôma hathak yani ma ik yani. ");
INSERT INTO hot_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Thêlô ivuliv thohavloma siŋ ma ik yani ba enaŋ nena, “O plopet te ma onaŋ nena opalê intu hik o?” ");
INSERT INTO hot_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma enaŋ abô kambom lomaloma hadêŋ yani haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Haviyô hayaŋ ma avômalô Islael iniŋ ŋê bêŋbêŋ ethak doŋtom ek elaŋô abô. Ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ êmô. Ma thêlô ewa Yisu ba enaŋ hik yani liŋ, ");
INSERT INTO hot_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Onaŋ êndêŋ yêlô nena o ma Mesia e?” Ma Yisu hanaŋ hadêŋ thêlô nena, “Yanaŋ abô êŋ êndêŋ môlô, êŋ ma môlô tem miŋ nônêmimbiŋ ami. ");
INSERT INTO hot_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma yanaŋ injik môlô liŋ, ma tem miŋ môlô nonaŋ viyaŋ ami. ");
INSERT INTO hot_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma doŋtom yaô ma Anyô Anêŋ Nakaduŋ atu tem êyô êmô Wapômbêŋ lôklokwaŋ anêŋ baŋ vianôŋ êtôm wak nômbêŋ intu sapêŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma thêlô sapêŋ enaŋ hik yani liŋ, “Aêŋ ba oda ma Wapômbêŋ anêŋ Nakaduŋ e?” Ma Yisu hanaŋ hadêŋ thêlô, “Môlôda oyala ba onaŋ.” ");
INSERT INTO hot_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Êŋ ma thêlô enaŋ, “Aisê ka alalô leŋiŋhaviŋ nadaŋô abô doho imbiŋ? Yani hanaŋ yanida bêŋ ba alalô lêk alaŋô yôv.” ");
INSERT INTO hot_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma ŋê bêŋbêŋ takatu iviyô ma ewa Yisu ba i ek Pailat. ");
INSERT INTO hot_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Êŋ ma enaŋ yani bêŋ aêntêk, “Ôpêntêk habuliŋ yêlôaniŋ avômalô. Yani hadô môlô Lom noyabiŋ yêlô ba hanaŋ ek miŋ nênêm takis êndêŋ Sisa ami. Ma hanaŋ nena yani ma Mesia. Mesia anêŋ ôdôŋ nena kiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma Pailat hanaŋ hik Yisu liŋ, “O ma avômalô Islael iniŋ kiŋ e?” Ma Yisu hanaŋ nena, “Intu êŋ, hatôm intu honaŋ.” ");
INSERT INTO hot_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Êŋ ma Pailat hanaŋ hadêŋ ŋê bêŋbêŋ êbôk da lôk avômalô nômbêŋ atu nena, “Miŋ yahapôm yani anêŋ kambom la ami.” ");
INSERT INTO hot_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma doŋtom enaŋ lôklokwaŋ nena, “Yani hadôŋ avômalô ba halela iniŋ auk haveŋ Judia lôkthô. Môŋ hêk Galili aleba hayô loŋ êntêk.” ");
INSERT INTO hot_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat halaŋô abô êŋ ma hanaŋ hik thêlô liŋ, “Ôpêŋ ma anyô Galili e?” ");
INSERT INTO hot_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pailat halaŋô nena Yisu halêm anêŋ Galili, êŋ ma hêv yani hi hadêŋ Helot ek malê nena yani hayabiŋ loŋ êŋ. Wak êŋ ma Helot hamô Jelusalem haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ma Helot hayê Yisu ba lamavi bêŋ anôŋ. Yani bôk halaŋô abô hathak Yisu ba lahaviŋ ênjê yani ma doŋtom mi aleba lêk hayê ma lahaviŋ Yisu indum lavôŋiŋ te ek yani ênjê. ");
INSERT INTO hot_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ba intu Helot hanaŋ hik Yisu liŋ bêŋ anôŋ, ma doŋtom yani bônôŋ iyom. ");
INSERT INTO hot_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ma ŋê bêŋbêŋ êbôk da lôk ŋê lôkauk hathak abô balabuŋ takatu ba imiŋ loŋ êŋ enaŋ abô lôklokwaŋ ba ibi yani liŋkupik hathak abô lomaloma. ");
INSERT INTO hot_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Êŋ ma Helot lôk anêŋ ŋê vovak ewa kiŋ anêŋ kwêv thalaleŋ daim te ma ik hathak Yisu ma enaŋ abôma ba emalik hathak yani. Vêm ma Helot hêv yani ba hi ek Pailat hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bôk Helot lo Pailat êpôlik hathak i, ma doŋtom lêk ma thai ibitak ŋê môlô. ");
INSERT INTO hot_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yôv ma Pailat halam ŋê bêŋbêŋ êbôk da lôk ŋê bêŋbêŋ lôk avômalô ba ethak doŋtom. ");
INSERT INTO hot_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma hanaŋ, “Môlôwa anyô êntêk halêm hadêŋ ya ma môlô onaŋ nena anyô êntêk hanaŋ abôyaŋ hadêŋ avômalô ek thêlô nêndô Lom eyabiŋ thêlô. Ma môlô ômô ma yahanaŋ hik ôpêŋ liŋ hathak nôm takêŋ. Yôv ma môlô odaŋô. Miŋ yahapôm ôpêntêk anêŋ kambom takatu ba môlô onaŋ yani bêŋ hathak ami. ");
INSERT INTO hot_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma Helot anêŋ auk aêŋ iyom ba intu hêv ôpêntêk halêm hadêŋ alalô hathak loŋbô. Odaŋô. Anyô êntêk miŋ hadum kambom te ek yanaŋ nena nijik yani vônô ami. ");
INSERT INTO hot_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Aêŋ ba yambali yani ma yatak yani ba ni.” ");
INSERT INTO hot_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma doŋtom avômalô sapêŋ elam kaêk lôklala aêntêk, “Nijik ôpêntu vônô ma netak Balabas ba êlêm êndêŋ yêlô.” ");
INSERT INTO hot_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Balabas ma ôpatu ba hik vovak hadêŋ gavman Lom hamô Jelusalem kapô ba hik anyô te vônô ba êdô yani hamô koladôŋ.) ");
INSERT INTO hot_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Yôv ma Pailat hadum ek etak Yisu ba ni. Êŋ ma yani halam hadêŋ avômalô hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma doŋtom thêlô elam lôbôlôŋ aêntêk, “Nijik vônô esak a! Nijik vônô esak a!” ");
INSERT INTO hot_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yôv ma Pailat hanaŋ bôlôŋ te lô hadêŋ thêlô nena, “Eka? Yani hadum malê kambom? Ôdôŋ te miŋ hamô ek yaŋgik yani vônô ami. Aêŋ ba tem yambali yani ma yatak yani ba ni.” ");
INSERT INTO hot_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma doŋtom thêlô lôklokwaŋ kambom ba elam kaêk nena Pailat injik Yisu esak a. Thêlôniŋ kaêk êŋ ma bêŋ anôŋ ba Pailat halaŋô. ");
INSERT INTO hot_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aêŋ ba Pailat hasopa thêlôniŋ abô ");
INSERT INTO hot_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ba hatak Balabas hadêŋ thêlô ma hêv Yisu hadêŋ ŋê vovak hatôm iniŋ leŋiŋhaviŋ. ");
INSERT INTO hot_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Thêlô ewa Yisu ba i ma êpôm anyô Sailini te halôk loŋôndê ba anêŋ athêŋ nena Saimon. Yani halêm anêŋ loŋ buyaŋ ba hadum ek ni Jelusalem. Ma ŋê vovak evaloŋ yani ba êv Yisu anêŋ a ba hawa ba haveŋ Yisu yam. ");
INSERT INTO hot_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma avômalô bêŋ anôŋ eveŋ Yisu yam, lôk avi doho elaŋ asêŋ malêŋ ba eveŋ yani yam. ");
INSERT INTO hot_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ma doŋtom Yisu hik i liliŋ ma hanaŋ hadêŋ thêlô aêntêk, “Môlô avi Jelusalem, miŋ nodaŋ ek ya ami. Mi, nodaŋ ek amda lôk nalumi. ");
INSERT INTO hot_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Odaŋô, malaiŋ bêŋ tem êyô ma tem avômalô nenaŋ aêntêk, ‘Avi yamu atu ba avômena mi lôk miŋ bôk êv sum ami, thêlô nêmô mavi ek malê nena iniŋ avômena miŋ hatôm nêpôm vovaŋ ami.’ ");
INSERT INTO hot_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wak êŋ ma avômalô tem nenaŋ êndêŋ dumlolê nena, ‘Upu ba usivuŋ yêlô.’” ");
INSERT INTO hot_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ma Yisu hanaŋ abô loŋ kapô te aêntêk, “Lêk ma idum kambom hadêŋ alokwaŋ lôkmala ma tem nindum malê êndêŋ alokwaŋ kapok?” ");
INSERT INTO hot_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma thêlô ewa anyô kambom ju haviŋ ek nijik vônô imbiŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Thêlô i êyô loŋ te ba anêŋ athêŋ nena Leŋkadôk Lokwaŋ. Loŋ êŋ ma thêlô êthôkwêŋ Yisu lôk anyô kambom ju atu hathak a. Êthôkwêŋ yaŋ hamiŋ Yisu baŋ vianôŋ ma yaŋ hamiŋ baŋ vikeŋ. ");
INSERT INTO hot_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma Yisu hanaŋ, “Wakamik, nêm thêlôniŋ kambom vê ek malê nena thêlô êthôŋ paliŋ ba idum.” Vêm ma ŋê vovak ibi valu ek nêgê nena opalêla intu tem neja anêŋ kwêv lo sôp. ");
INSERT INTO hot_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Avômalô imiŋ ba êyê iyom. Ma ŋê bêŋbêŋ ibi yani liliŋ ba enaŋ, “Yani bôk hêv avômalô vi bulubiŋ. Yani ma Mesia, ôpatu ba Wapômbêŋ bôk hatak yôv ek nêm avômalô bulubiŋ, êŋ ma nêm yanida bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma ŋê vovak êyô haviŋ ba enaŋ abôma ma êv waiŋ maniŋ hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma enaŋ, “O ma avômalô Islael iniŋ kiŋ e? Êŋ ma nêm oda bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma eto abô te hamiŋ Yisu vuliŋ aêntêk, AVÔMALÔ ISLAEL INIŊ KIŊ ");
INSERT INTO hot_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Anyô kambom ju atu ba êthôkwêŋ haviŋ Yisu ma yaŋ hanaŋ abôma hadêŋ Yisu nena, “O ma Mesia e? Êŋ ma nêm oda bulubiŋ lôk yai imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma doŋtom yaŋ halaŋô abô êŋ ma hathaŋ yaŋ êŋ ba hanaŋ, “Alalô tem nama ba miŋ hôkô ek Wapômbêŋ ami e? ");
INSERT INTO hot_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Alai adum kambom bêŋ anôŋ ba intu êv vovaŋ hadêŋ alai, ma doŋtom ôpêntêk ma miŋ hadum kambom te ami.” ");
INSERT INTO hot_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Êŋ ma hanaŋ, “Yisu, hôyô anêm loŋ lôkliŋyak ma lemimbi ya.” ");
INSERT INTO hot_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma Yisu hanaŋ, “Yanaŋ avanôŋ êndêŋ o nena yaô ma tem ômô imbiŋ ya êmô malak leŋ.” ");
INSERT INTO hot_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Habobo waklêvôŋ biŋ ma momaŋiniŋ hayô pik sapêŋ vôv ba hêk aleba hayô 3 kilok. Ma sôp bêŋ atu ba êthôkwêŋ hamiŋ unyak matheŋ kapô hapup hi luvi. ");
INSERT INTO hot_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma Yisu halam kaêk lôklala nena, “Wakamik, oyabiŋ yadahôlôŋ.” Yani hanaŋ aêŋ ma auk habitak ba hi ma hama. ");
INSERT INTO hot_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Anyô vovak laik hayê nôm êŋ ma yani habô Wapômbêŋ anêŋ athêŋ ba hanaŋ, “Avanôŋ biŋ, ôpêntêk ma anyô thêthôŋ mavi.” ");
INSERT INTO hot_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma avômalô takatu ba ethak doŋtom ba imiŋ ek êyê, thêlô êyê nôm êŋ ba kapôlôŋiŋ malaiŋ kambom ba ik biŋ daluk ba êvôi. ");
INSERT INTO hot_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma doŋtom Yisu anêŋ avômalô sapêŋ lôk avi takatu ba eveŋ haviŋ yani hêk Galili ba êlêm imiŋ daim dokte ma êyê nôm takatu ba habitak. ");
INSERT INTO hot_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Josep ma anyô Alimatia te anêŋ Judia. Yani hayabiŋ waklavôŋ atu ba Wapômbêŋ anêŋ loŋ lôkliŋyak tem êlêm pik. Yani ma anyô thêthôŋ mavi te ma Sanhedlin iniŋ anyô bêŋ te. Ma miŋ halôk hathak Sanhedlin iniŋ auk atu ba ik Yisu vônô ami. ");
INSERT INTO hot_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ba intu hi hadêŋ Pailat ma hanaŋ hik liŋ ek enja Yisu anêŋ kupik. ");
INSERT INTO hot_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Êŋ ma hawa Yisu liŋkupik vê ma havuliv siŋ hathak sôp, ma hawa ba hi hadô hêk siô lukmuk atu ba ekolop valu ba abyaŋ ek nedav ŋê ŋama êndôk. Ma miŋ bôk êdô anyô ŋama la hêk ami. ");
INSERT INTO hot_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","55","Avi takatu ba esopa Yisu hêk Galili ba êlêm, ma esopa Josep ba i êyê valu abyaŋ atu ba êdô Yisu hêk. Wak êŋ ma waklavôŋ atu ba avômalô Islael nêpôpêk i ek nêgê Sabat. ");
INSERT INTO hot_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aêŋ ba avi takêŋ i iniŋ unyak ma êpôpêk nôm ôv mavi lôk nôm lêŋlêŋ. Sabat hayô ma ewa lovak hatôm balabuŋ hanaŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sonda êŋ anêŋ wak te môŋ anêŋ lôkbôk momaŋiniŋ ma avi ewa nôm ôv mavi takatu ba bôk epesaŋ yôv ba i siô. ");
INSERT INTO hot_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Thêlô êyô ma êyê valu atu ba hamô lôv abôlêk lêk ibubi hi hamô daŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ma thêlô ibitak êyô kapô, ma doŋtom thêlô miŋ êpôm Anyô Bêŋ Yisu anêŋ kupik ami. ");
INSERT INTO hot_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma thêlô leŋiŋhabi bêŋ anôŋ imiŋ denaŋ ma ketheŋ oyaŋ ma anyô ju lôk kwêv thapuk hatôm damak hêv imiŋ haviŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Êŋ ma avi takêŋ êkô ba êkôm ba êyê pik. Ma doŋtom thai enaŋ hadêŋ thêlô aêntêk, “Aisê ka môlô ôlêm ôbôlêm anyô lôkmala haveŋ ŋê ŋama iniŋ loŋ? ");
INSERT INTO hot_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yani miŋ hêk loŋ êntêk ami, ma yani lêk haviyô yôv. Ma môlô lemimbi abô sêbôk ba yani hanaŋ hadêŋ môlô hêk Galili. ");
INSERT INTO hot_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Yani hanaŋ aêntêk, ‘Tem nênêm Anyô Anêŋ Nakaduŋ atu êndôk ŋê kambom baheŋiŋ ba nijik yani vônô esak a ma êtôm wak lô ma tem imbiyô esak loŋbô.’” ");
INSERT INTO hot_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Êŋ ma thêlô leŋiŋhabi abô êŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Êŋ ma thêlô etak siô ba êvôi ma enaŋ abô takêŋ sapêŋ hadêŋ ŋê ku laumiŋ ba lahavute lôk avômalô vi atu ba êmô haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Avi takêŋ te ma Malia anêŋ Magadala, ma Joana lo Jems anêŋ talêbô Malia, lôk avi doho haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ma aposel elaŋô avi takêŋ iniŋ abô ba esoŋ nena enaŋ abô molo la ba miŋ êvhaviŋ ami. ");
INSERT INTO hot_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma doŋtom Pita haviyô ma halaŋviŋ ba hi siô ma hakôm ba hayê sôp iyom hamô. Yôv ma yani hale hi anêŋ unyak hathak loŋbô ma lahabi bêŋ anôŋ hathak nôm takatu ba lêk habitak. ");
INSERT INTO hot_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wak êŋ iyom ma anyô ku ju i malak Emeus. Loŋ êŋ hamô daim dokte hatôm 11 kilomita ek Jelusalem. ");
INSERT INTO hot_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Thai eveŋ loŋôndê ba i ma enaŋ hathak nôm takatu ba habitak. ");
INSERT INTO hot_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Thai enaŋ abô bêŋ anôŋ, ma Yisu da halêm haveŋ haviŋ thai, ");
INSERT INTO hot_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ma doŋtom Yisu hik thai maleŋ loŋ ba miŋ eyala yani ami. ");
INSERT INTO hot_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma yani hanaŋ hik thai liŋ, “Mamu onaŋ malê?” Êŋ ma thai imiŋ ma idum hatôm thai elaŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Anyô yaŋ anêŋ athêŋ nena Kelopas hanaŋ hik yani liŋ, “Êê, avômalô Jelusalem sapêŋ eyala nôm atu ba lêk habitak hêk loŋ êntêk, ma hoveŋ êsê ba miŋ hoyala ami?” ");
INSERT INTO hot_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma Yisu hanaŋ hik thai liŋ, “Malê?” Ma thai enaŋ hadêŋ yani nena, “Nôm takatu ba habitak hapôm Yisu anêŋ Nasalet. Yani ma plopet te ba hadum ku bêŋbêŋ ba anêŋ abô ma lôkliŋyak kambom hamiŋ Wapômbêŋ ma lôk avômalô sapêŋ maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Ma yêlô leŋiŋhabi nena Yisu ma Mesia atu ba Wapômbêŋ hêv ek nêm Islael vê ênjêk iniŋ malaiŋ. Ma doŋtom alalôaniŋ ŋê bêŋbêŋ lôk ŋê bêŋbêŋ êbôk da enaŋ yani bêŋ hadêŋ Lom iniŋ anyô bêŋ ba halôk hathak iniŋ abô ba intu ik vônô hathak a. Ma lêk ma wak te lô. ");
INSERT INTO hot_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma yêlôaniŋ avi doho elela yêlôaniŋ auk. Hadêŋ lôkbôk momaŋiniŋ ma thêlô i siô ");
INSERT INTO hot_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ma miŋ êpôm Yisu anêŋ kupik ami. Ma thêlô êvô êlêm ma enaŋ nena thêlô êyê wêŋ aŋela doho ba enaŋ nena Yisu hamô lôkmala. ");
INSERT INTO hot_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma yêlôaniŋ anyô doho i siô ma êyê nôm takeŋ hatôm atu ba avi enaŋ, ma doŋtom thêlô miŋ êyê Yisu ami.” ");
INSERT INTO hot_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma Yisu hanaŋ hadêŋ thai nena, “Mamu ŋê auk mi lôk kapôlômim pulusikna ba intu miŋ ôêvhaviŋ plopet iniŋ abô ami! ");
INSERT INTO hot_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Thêlô bôk enaŋ yôv nena Mesia tem enja vovaŋ takêŋ vêm ka tem enja anêŋ athêŋ lôkmaŋgiŋ ênjêk leŋ.” ");
INSERT INTO hot_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Vêm ma yani hawa Wapômbêŋ anêŋ abô takatu ba bôk eto hathak yanida sa hadêŋ thai. Môŋ ma hanaŋ hathak Mose anêŋ kapya vêm ma plopet sapêŋ iniŋ abô takatu ba bôk eto hathak yani haviŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma thêlô êyô malak Emeus ma Yisu hadum ek ni thêthô. ");
INSERT INTO hot_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma doŋtom thai enaŋ lôklokwaŋ, “Lêk yaŋsiŋ habôk ba tem bôlôvôŋ ba dô ma ômô imbiŋ yai.” Êŋ ma yani hi unyak kapô ek ênjêk imbiŋ thai. ");
INSERT INTO hot_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yôv ma thêlô êmô ek nejaŋ nôm ma yani hawa polom ba hêv mek ma haya ba hêv hadêŋ thai. ");
INSERT INTO hot_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Thai êyê ma maleŋ hakyav ba eyala yani. Ma ketheŋ oyaŋ ma yani mi. ");
INSERT INTO hot_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma thai enaŋ hadêŋ i nena, “Êê, avanôŋ biŋ. Alai aveŋ loŋôndê ma yani hik Wapômbêŋ anêŋ abô thô ba alaianiŋ kapôlôŋiŋ hatôm atum hathaŋ.” ");
INSERT INTO hot_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ma bôlôŋ doŋtom ma thai etak loŋ êŋ ma ele i Jelusalem hathak loŋbô. Thai êyô ma êpôm ŋê ku laumiŋ ba lahavute lôk anyô doho ethak doŋtom haviŋ ba êmô. ");
INSERT INTO hot_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma thêlô enaŋ hadêŋ thai aêntêk, “Avanôŋ biŋ nena Anyô Bêŋ haviyô hathak loŋbô ba yani hik i thô hadêŋ Saimon.” ");
INSERT INTO hot_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yôv ma anyô ju êŋ enaŋ nôm takatu ba hapôm thai halôk loŋôndê lôk polom atu ba yani haya, êŋ ma thai eyala nena Yisu. ");
INSERT INTO hot_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ŋê ku enaŋ abô êmô denaŋ ma Yisu hamiŋ thêlô malêvôŋ ma hanaŋ, “Môlô kapôlômim ênjêk labali!” ");
INSERT INTO hot_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma thêlô esoŋ nena ŋgôk anyô dahô ba êkô kambom. ");
INSERT INTO hot_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma doŋtom Yisu hanaŋ, “Môlô osoŋ ba unim auk hêv yak eka? ");
INSERT INTO hot_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ôŋgô yabaheŋ lo yaveŋ. Yada êŋ êntêk ba nobaloŋ yaleŋviŋkupik. Ma ŋgôk liŋkupik mi, ma doŋtom yenaŋ ma hamô.” ");
INSERT INTO hot_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Êŋ ma Yisu hik va lo baŋ thô hadêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Thêlô êyê yani ma leŋiŋmavi, ma doŋtom thêlôniŋ auk mayaliv ba miŋ êvhaviŋ ami. Êŋ ma Yisu hanaŋ, “Nôm doho hamô e?” ");
INSERT INTO hot_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Êŋ ma êv alim êbôk kabuk te vi, ");
INSERT INTO hot_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ma yani hawa ba hayaŋ ma thêlô êyê. ");
INSERT INTO hot_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma Yisu hanaŋ hadêŋ thêlô, “Bôk yahamô lôkmala haviŋ môlô, ma yahanaŋ nena abô takatu ba bôk eto hathak ya ba hêk Mose anêŋ Abô Balabuŋ lôk Kapya Plopet ma Kapya Yeŋ tem injik anôŋ.” ");
INSERT INTO hot_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ma yani hik iniŋ auk liŋ ek neyala Wapômbêŋ anêŋ kapya ");
INSERT INTO hot_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ba hanaŋ, “Wapômbêŋ anêŋ kapya hanaŋ nena Mesia tem enja vovaŋ ba ema ma êtôm wak lô ma tem imbiyô ênjêk ŋê ŋama iniŋ loŋ esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma esak anêŋ athêŋ ma tem nenaŋ êndêŋ ŋê Jelusalem lôk Islael ma avômalô loŋ buyaŋ sapêŋ nena nede kapôlôŋiŋ liliŋ ek Wapômbêŋ nêm iniŋ kambom vê. ");
INSERT INTO hot_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Môlô lêk ôyê nôm takêŋ yôv ba intu nonaŋ lôkthô bêŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Odaŋô! Tem yanêm nôm atu ba Wakamik bôk havak abô ek nêm êyômô môlô. Aêŋ ba nômô Jelusalem endeba lôklokwaŋ anêŋ leŋ êndôk êyômô môlô am.” ");
INSERT INTO hot_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ma Yisu halom thêlô ba hi hayô Betani iniŋ loŋ ma hêv baŋ liŋ ba hêv mek hadêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hêv mek denaŋ ma hatak thêlô ma ewa yani hathak leŋ ba hi. ");
INSERT INTO hot_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Êŋ ma thêlô êbô yani ma ele i Jelusalem lôk leŋiŋmavi bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma wak nômbêŋ intu sapêŋ ma êbô Wapômbêŋ êmô unyak matheŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sêbôk atu ba môŋ anôŋ ma Abô hamô. Ma Abô êŋ hamô haviŋ Wapômbêŋ ba Wapômbêŋ da intu abô êŋ ");
INSERT INTO hot_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ba hamô haviŋ Wapômbêŋ hadêŋ sêbôk ba môŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Abô êŋ intu Wapômbêŋ hapesaŋ nômkama sapêŋ hathak. Nômlate atu ba miŋ habitak ami, êŋ ma miŋ yani hapesaŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Abô êŋ hadum ba nômkama sapêŋ habitak lôkmala. Ma lôkmala êŋ ma avômalô iniŋ deda. ");
INSERT INTO hot_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Deda êŋ habi hayô hêk momaŋiniŋ. Ma momaŋiniŋ êŋ hathôŋ paliŋ ba miŋ hatôm ênjêk deda êŋ loŋ siŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ma Wapômbêŋ hêv anyô te halêm ba anêŋ athêŋ nena Jon. ");
INSERT INTO hot_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yani halêm ek injik Abô deda êŋ thô ek avômalô sapêŋ nedaŋô ba nênêmimbiŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yanida ma miŋ deda êŋ ami ma halêm ek injik thô iyom. ");
INSERT INTO hot_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Deda êŋ halêm pik ba habi hayô hêk avômalô. Deda êŋ ma deda anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wapômbêŋ bôk hapesaŋ avômalô hathak Abô êŋ ba halêm pik. Ma doŋtom êthôŋ paliŋ denaŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yani hi ek anêŋ avômalô, ma miŋ ewa yani thô ami. ");
INSERT INTO hot_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma avômalô takatu ba ewa yani thô lôk êvhaviŋ ma hatak avômalô takêŋ ek nimbitak Wapômbêŋ anêŋ nali. ");
INSERT INTO hot_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Avômena takêŋ ma Wapômbêŋ da hapesaŋ loŋôndê ba intu ibitak yanida anêŋ nali. Ma miŋ ibitak hatôm avômalô pik sapêŋ atu ba ibitak ami. Lôk anyô te miŋ habi thêlô vê ami. Ma taluvi lo lami miŋ idum ba ibitak ami lôk miŋ ibitak hathak lami iniŋ leŋiŋhaviŋ ami. Mi. ");
INSERT INTO hot_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Abô êŋ intu habitak anyô ba halêm hamô haviŋ yêlô ba bôk ayê nena anyô lôkmaŋgiŋ anôŋ. Yani ma wapôm anêŋ ôdôŋ biŋ ba hik nômkama avanôŋ thô hadêŋ avômalô. Yani ma Lambô anêŋ Nakaduŋ doŋtom êŋ iyom ba intu Lambô hêv lôkmaŋgiŋ êŋ hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon hik anyô êŋ thô ba halam, “Bôk yahanaŋ yôv hathak anyô êntêk êŋ nena, ‘Anyô te tem embeŋ ya yam. Ma doŋtom yani hamô hadêŋ sêbôk ba miŋ yahabitak ami. Ba intu yani ma bêŋ ek ya.’” ");
INSERT INTO hot_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yani ma lôkmaŋgiŋ anôŋ ba anêŋ wapôm hêv liŋ siŋ ba halêm ek alalô lôbôlôŋ ");
INSERT INTO hot_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","aêntêk nena sêbôk ma hêv abô balabuŋ hadêŋ Mose lôk alalô. Yôv ma Yisu Kilisi halêm ba hik Lambô lôk anêŋ wapôm thô. ");
INSERT INTO hot_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Anyô te miŋ bôk hayê Wapômbêŋ ami. Ma doŋtom Wapômbêŋ anêŋ Nakaduŋ doŋtom êŋ iyom intu Wapômbêŋ ba hamô haviŋ Lambô ma hik Lambô thô hadêŋ alalô. ");
INSERT INTO hot_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Islael iniŋ ŋê bêŋbêŋ takatu ba êmô Jelusalem êv ŋê êbôk da lôk avômalô Livai doho ba i hadêŋ Jon ma enaŋ hik yani liŋ nena, “O ma opalê?” ");
INSERT INTO hot_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma yani miŋ bônôŋ ami ma hanaŋ bêŋ nena, “Ya ma miŋ Mesia atu ba Wapômbêŋ hêv ek nêm avômalô bulubiŋ ami. Mi anôŋ.” ");
INSERT INTO hot_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Êŋ ma enaŋ hik yani liŋ, “Sêbôk ma enaŋ nena Elia tem êmôŋ vêm ka Mesia embeŋ yam. O êŋ êntêk e?” Ma hanaŋ, “Mi.” “Sêbôk ma Mose hanaŋ nena plopet te tem êlêm. O êŋ êntêk e?” Ma hanaŋ viyaŋ, “Mi.” ");
INSERT INTO hot_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Aêŋ ba o opalê? Onaŋ aisê esak oda? Onaŋ viyaŋ ek yêlô ana nanaŋ êndêŋ ŋê bêŋbêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Êŋ ma Jon hawa plopet Aisaia anêŋ abô ba hanaŋ, “Ya ma kaêk atu ba halam halêm anêŋ loŋ thiliv nena, ‘Nopesaŋ loŋôndê ek Anyô Bêŋ êlêm.’” Hasam Aisaia anêŋ abô êŋ yôv ma hanaŋ, “Ya êŋ êntêk.” ");
INSERT INTO hot_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Vêm ma Palisi takatu ba êlêm haviŋ ŋê bêŋbêŋ ");
INSERT INTO hot_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","enaŋ hik yani liŋ, “O ma miŋ Mesia lôk plopet ma Elia ami. Aisê ka huthik avômalô halôk ŋaŋ?” ");
INSERT INTO hot_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma Jon hanaŋ viyaŋ, “Yahathik thêlô hathak ŋaŋ, ma doŋtom anyô te hamô môlô malêvôŋ ba môlô ôthôŋ ôpêŋ paliŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yani ma ôpatu ba tem embeŋ ya yam. Yani ma anyô lôk athêŋ bêŋ ma ya ma yaônalôk ba intu miŋ hatôm yapole anêŋ vakapô bokŋgôp anêŋ yak vê ami.” ");
INSERT INTO hot_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nôm êŋ habitak anêŋ Betani hêk Jolodaŋ vi, loŋ atu ba Jon hathak hathik avômalô halôk ŋaŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Haviyô hayaŋ ma Jon hayê Yisu halêm. Ma hanaŋ, “Ôŋgô, ôpêŋ ma Wapômbêŋ anêŋ Boksipsip Nakaduŋ atu ba hêv ek nêm avômalô pik iniŋ kambom vê. ");
INSERT INTO hot_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yani ma ôpatu ba bôk yahanaŋ nena, ‘Anyô te tem embeŋ ya yam. Ma doŋtom yani hamô hadêŋ sêbôk atu ba miŋ yahabitak ami denaŋ. Ba intu yani ma bêŋ ek ya.’ ");
INSERT INTO hot_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yada ma yahathôŋ ôpêŋ anêŋ ku paliŋ. Ma doŋtom yahalêm yahathik avômalô halôk ŋaŋ ek yaŋgik ôpêŋ thô êndêŋ avômalô Islael.” ");
INSERT INTO hot_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Êŋ ma Jon hanaŋ hathak nômlate atu ba bôk yani hayê yôv. Yani hanaŋ nena, “Sêbôk ma yahathôŋ ôpêŋ anêŋ ku paliŋ. Ma doŋtom Wapômbêŋ hêv ya ba yahalêm ek yasik avômalô êndôk ŋaŋ. Ma yani hanaŋ hadêŋ ya nena, ‘Tem nôŋgô Lovak Matheŋ êlêm anêŋ leŋ ba êyô êmô anyô te. Ma ôpêŋ intu tem isik avômalô esak Lovak Matheŋ.’ Wapômbêŋ bôk hanaŋ abô êŋ hadêŋ ya. Êŋ ma yahayê Lovak Matheŋ hatak leŋ ma halôk ba halêm hatôm menak bôbô ba hayô hamô ôpêŋ. Yada yahayê nôm êŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Avanôŋ! Yada bôk yahayê nôm êŋ. Ma yahanaŋ nena anyô êntêk ma Wapômbêŋ anêŋ Nakaduŋ.” ");
INSERT INTO hot_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Haviyô hayaŋ ma Jon lôk anêŋ ŋê ku ju êmô loŋ atu hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ma hayê Yisu halêm ma hanaŋ, “Ôŋgô, Wapômbêŋ anêŋ Boksipsip Nakaduŋ atu intu.” ");
INSERT INTO hot_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ŋê ku ju êŋ elaŋô abô êŋ ma i esopa Yisu. ");
INSERT INTO hot_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Êŋ ma yani hik i liliŋ ma hayê thai esopa yani ma hanaŋ hik thai liŋ, “Mamu lemimhaviŋ malê?” Ma thai enaŋ, “Labai, hôêk êsê?” (“Labai” anêŋ ôdôŋ nena “Kêdôŋwaga”.) ");
INSERT INTO hot_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma Yisu hanaŋ, “Mamu nôlêm nôŋgô.” Êŋ ma thai i êyê loŋ atu ba yani hamô. Nôm êŋ habitak hadêŋ yaŋsiŋ hatôm 4 kilok. Ma thai êmô haviŋ yani aleba bôlôvôŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andulu ma Saimon Pita anêŋ yaŋ, yani ma Jon anêŋ anyô ku te atu ba halaŋô Jon anêŋ abô ba hi hasopa Yisu. ");
INSERT INTO hot_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yani hayê Yisu vêm ma hi ketheŋ ba hapôm yaŋ Saimon ma hanaŋ, “Yêlô lêk ayê Mesia.” (Mesia anêŋ ôdôŋ nena “Kilisi, ôpatu ba Wapômbêŋ hêv ek nêm avômalô bulubiŋ”.) ");
INSERT INTO hot_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma Andulu hawa Saimon ba hi hadêŋ Yisu. Yisu hayê ma hanaŋ, “O Saimon, Jon nakaduŋ. O ma tem nendam nena Sipas.” (Athêŋ “Sipas” êŋ ma hatôm “Pita”. Ma athêŋ ju êŋ anêŋ ôdôŋ nena “valu”.) ");
INSERT INTO hot_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Haviyô hayaŋ ma Yisu hadum ek ni Galili ba hapôm Pilip ma hanaŋ, “Ôlêm osopa ya.” ");
INSERT INTO hot_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip ma anyô Betsaida. Betsaida êŋ ma Andulu lo Pita iniŋ malak ôdôŋ. ");
INSERT INTO hot_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Yani hapôm Nataniel ma hanaŋ nena, “Sêbôk ma Mose hato abô te hêk kapya balabuŋ hathak anyô te. Ma plopet doho bôk eto abô hathak ôpêŋ haviŋ. Ma yêlô lêk ayê yani yôv. Ôpêŋ ma Yisu anêŋ Nasalet, Josep nakaduŋ.” ");
INSERT INTO hot_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma Nataniel hanaŋ nena, “Malê mavi te tem imbitak Nasalet?” Ma Pilip hanaŋ, “Ôlêm nôŋgô.” Êŋ ma thai i. ");
INSERT INTO hot_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ma Yisu hayê Nataniel halêm ma hanaŋ, “Avanôŋ! Ôpêntêk ma anyô Islael mavi te. Yani ma abôyaŋ mi.” ");
INSERT INTO hot_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ma Nataniel hanaŋ, “Hoyala ya aisê?” Ma Yisu hanaŋ, “Pilip miŋ halam o ami denaŋ. Ma yahayê hômô alokwaŋ avi te ôdôŋ ba yahayala o.” ");
INSERT INTO hot_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel halaŋô abô êŋ ma hanaŋ, “Kêdôŋwaga, o ma Wapômbêŋ anêŋ Nakaduŋ ma avômalô Islael iniŋ Kiŋ.” ");
INSERT INTO hot_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ma Yisu hanaŋ, “Thatu yahayê hômô alokwaŋ ôdôŋ ba intu hôêvhaviŋ e? Ondaŋô! Nôm êŋ ma yaôna ek yaŋ atu ba tem embeŋ yam.” ");
INSERT INTO hot_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma hanaŋ abô doho haviŋ nena, “Yanaŋ avanôŋ biŋ êndêŋ môlô. Tem môlô ôŋgô leŋ ekyav ma aŋela nesak ba nêndôk ek ya Anyô Anêŋ Nakaduŋ.” ");
INSERT INTO hot_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wak ju hale ba hi ma anyô te hawa avi te anêŋ Kena. Malak Kena êŋ hêk Galili kapô. Ma Yisu anêŋ talêbô hi haviŋ. ");
INSERT INTO hot_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma elam Yisu lôk anêŋ ŋê ku ba i haviŋ. ");
INSERT INTO hot_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Avômalô inum waiŋ aleba thô. Ma Yisu anêŋ talêbô hanaŋ hadêŋ Yisu nena, “Nôŋgô! Thêlôniŋ waiŋ lêk thô.” ");
INSERT INTO hot_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma Yisu hanaŋ, “Avi bêŋ, honaŋ abô êŋ hadêŋ ya eka? Yenaŋ waklavôŋ mi denaŋ.” ");
INSERT INTO hot_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma Yisu talêbô hanaŋ hadêŋ ŋê takatu ba eyabiŋ nôm nena, “Nodaŋô anêŋ abô ba nundum êtôm atu ba hanaŋ.” ");
INSERT INTO hot_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ma uŋ valu baheŋvi ba lahavute hamô habobo thêlô. Uŋ te hatôm embaloŋ ŋaŋ êtôm 100 lita la. Avômalô Islael ethak ithik halôk ek nênêm leŋiŋmavi êndêŋ Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Êŋ ma Yisu hanaŋ hadêŋ ŋê eyabiŋ nôm nena, “Noŋgasô ŋaŋ êndôk uŋ sapêŋ.” Ma eŋgasô halôk aleba hayô abôlêk siŋ. ");
INSERT INTO hot_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yôv ma hanaŋ hadêŋ thêlô, “Noja doho ba nônêm êndêŋ anyô bêŋ atu hayabiŋ nôm.” Ma ŋê ku ewa ba i êv hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Anyô bêŋ êŋ hanum ŋaŋ atu ba Yisu hik liliŋ ba habitak waiŋ. Ma doŋtom miŋ hayala ami. Ŋê takatu ba ethakôv iyom intu eyala. Yani hanum ba hasoŋ kambom ma halam anyô hawa avi ba thai i daim dokte ");
INSERT INTO hot_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma hanaŋ, “Ethak êv waiŋ vasiŋ mavi hamôŋ ek avômalô inum aleba maleŋiŋ hataba êŋ ma miŋ êv waiŋ maniŋ haveŋ yam. Ma doŋtom waiŋ êntêk anêŋ vasiŋ ma vasiŋ anôŋ ek waiŋ yaŋ atu ba hamôŋ.” ");
INSERT INTO hot_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yisu hadum nôm êŋ hamô Kena anêŋ Galili. Nôm êŋ ma lavôŋiŋ môŋ anôŋ atu ba hadum ek hik anêŋ lôkmaŋgiŋ thô. Ma anêŋ ŋê ku êvhaviŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Vêm ma Yisu lôk iviyaŋ ma talêbô etak Kena ma êlôk ba i Kapaneam. Ma ŋê ku iviŋ thêlô ba i êmô loŋ êŋ hatôm wak doho. ");
INSERT INTO hot_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Avômalô Islael iniŋ waklavôŋ te habobo anêŋ athêŋ nena Hale ba Hi. Ma Yisu hi daku Jelusalem ek ênjê waklavôŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yani hi unyak matheŋ anêŋ piklêvôŋ ma hayê avômalô etak bokmaŋkao lôk sipsip ma menak bôbô ek nênêm vuli ek nêmbôk êtôm da lôk ŋê takatu ba êwê ŋê loŋ buyaŋ iniŋ valuseleŋ hathak Hiblu iniŋ valuseleŋ êmô. ");
INSERT INTO hot_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Êŋ ma havuvi yak balawa te ba halupuniŋ i lôk iniŋ boksipsip lo bokmaŋkao ma hêv i vê hêk unyak matheŋ ba i. Ma hakayaŋ ŋê êŋ iniŋ balê ba valuseleŋ hagililiŋ mayaliv. ");
INSERT INTO hot_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma hanaŋ hadêŋ ŋê takatu ba etak menak bôbô ek nênêm vuli nena, “Noja unim menak ba unu! Wakamik anêŋ unyak ma loŋ netak nômkama êmô ek nênêm vuli e?” ");
INSERT INTO hot_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma Yisu anêŋ ŋê ku êyê nôm êŋ ma leŋiŋhabi hathak abô te hêk Wapômbêŋ anêŋ kapya nena, “Yahêv lêlê ek anêm unyak ma yaleŋhaviŋ unyak êŋ bêŋ anôŋ.” ");
INSERT INTO hot_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Islael iniŋ ŋê bêŋbêŋ êyê ma enaŋ, “Undum lavôŋiŋ te ek injik o thô nena Wapômbêŋ halam o ba hudum nôm êŋ!” ");
INSERT INTO hot_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma Yisu hanaŋ viyaŋ, “Nundiniŋ unyak matheŋ êntêk, ma êtôm wak lô iyom ma tem yandav esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma ŋê bêŋbêŋ enaŋ, “Avômalô idum ku hatôm sondabêŋ 46 ek elav unyak êntêk ma doŋtom mi denaŋ! Ma hatôm ondav wak lô iyom e?” ");
INSERT INTO hot_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Unyak matheŋ atu ba Yisu hanaŋ hathak êŋ ma yanida liŋkupik. ");
INSERT INTO hot_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ba Yisu haviyô hathak loŋbô hêk ŋama ma anêŋ ŋê ku leŋiŋhabi abô atu ba bôk hanaŋ. Êŋ ma êvhaviŋ abô atu ba hêk Wapômbêŋ anêŋ kapya lôk Yisu da hanaŋ. ");
INSERT INTO hot_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yani hamô Jelusalem ma hayê waklavôŋ atu ba anêŋ athêŋ nena Hale ba Hi. Ma avômalô bêŋ anôŋ êyê lavôŋiŋ takatu ba hadum ba êvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma doŋtom Yisu miŋ hêvhaviŋ i ami. Hayala anyô sapêŋ iniŋ auk. ");
INSERT INTO hot_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Anyô te miŋ hêv auk hadêŋ yani hathak avômalô iniŋ kobom ami. Mi, bôk hayala avômalô sapêŋ iniŋ kapôlôŋiŋ. ");
INSERT INTO hot_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Islael iniŋ anyô bêŋ te anêŋ athêŋ nena Nikodimus. Yani ma Palisi te. ");
INSERT INTO hot_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Bôlôvôŋ ma hi hadêŋ Yisu ma hanaŋ, “Kêdôŋwaga, hothak hudum lavôŋiŋ lomaloma ba intu yêlô ayala nena Wapômbêŋ hêv o ba hôlêm hatôm kêdôŋwaga. Ma Wapômbêŋ miŋ hamô haviŋ anyô te ami, êŋ ma miŋ hatôm indum lavôŋiŋ êtôm atu ba hudum ami.” ");
INSERT INTO hot_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ma Yisu hanaŋ viyaŋ, “Yanaŋ avanôŋ biŋ êndêŋ môlô. Ôpatu ba evathu hathak loŋbô iyom intu tem êyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô.” ");
INSERT INTO hot_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma ôpêŋ hanaŋ, “Aisê ka nembathu ôpatu ba bôk hayalôv yôv? Yani tem êndôk talêbô kapô ba nembathu esak loŋbô e? Ma mi!” ");
INSERT INTO hot_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ma Yisu hanaŋ viyaŋ nena, “Yanaŋ avanôŋ biŋ êndêŋ môlô. Ôpatu ba Wapômbêŋ hathik hathak ŋaŋ lôk Lovak Matheŋ hatôm evathu hathak loŋbô, ôpêŋ iyom intu tem imbitak êyô Wapômbêŋ anêŋ loŋ lôkliŋyak kapô. ");
INSERT INTO hot_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Avômalô pik ibitak hathak lami ibi i vê. Ma Wapômbêŋ anêŋ avômalô ibitak hathak Lovak Matheŋ habi i vê. ");
INSERT INTO hot_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma aisê ka hosoŋ hathak abô êntêk ba yahanaŋ hadêŋ o nena ‘nimbi o vê esak loŋbô.’ ");
INSERT INTO hot_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lovak da hathak hayuv hatôm anêŋ lahaviŋ ma holaŋô anêŋ diŋdiŋ iyom. Ma doŋtom hôthôŋ nena halêm anêŋ êsê ba hi êsê. Ma ŋê takatu ba Lovak Matheŋ havathu i ma aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma ôpêŋ hanaŋ hik liŋ hathak loŋbô, “Nôm takêŋ tem imbitak aisê?” ");
INSERT INTO hot_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma Yisu hanaŋ, “Ai! O Islael iniŋ kêdôŋwaga bêŋ ma hôthôŋ nôm êntêk paliŋ, e? ");
INSERT INTO hot_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","13","Ya Anyô Anêŋ Nakaduŋ iyom intu yahatak malak leŋ ba yahalêm. Ma anyôla miŋ bôk hi loŋ êŋ ba hale halêm hathak loŋbô ami. Yanaŋ avanôŋ biŋ êndêŋ môlô. Yêlô anaŋ hathak nôm takatu ba bôk ayala. Ma anaŋ bêŋ hathak nôm takatu ba bôk ayê. Ma môlô miŋ olaŋô yêlôaniŋ abô ami. Lêk yahanaŋ abô doho hathak nômkama pik ek oyala Wapômbêŋ anêŋ auk. Ma môlô miŋ ôêvhaviŋ ami. Ba intu nômkama malak leŋ tem miŋ nônêmimbiŋ aêŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sêbôk ma avômalô Islael êmô loŋ thiliv ma umya bêŋ anôŋ ethaŋ i. Êŋ ma Mose hathôkwêŋ umya dahô te hathak kôm ba hêv liŋ hamiŋ leŋ ek avômalô nêgê ba nimbitak mavi. Wapômbêŋ anêŋ lahaviŋ ba tem nêsôkwêŋ ya Anyô Anêŋ Nakaduŋ ba nênêm liŋ aêŋ iyom ");
INSERT INTO hot_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ek avômalô takatu ba êvhaviŋ tem neja lôkmala anôŋ atu ba nêmô êtôm wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Wapômbêŋ lahaviŋ avômalô pik bêŋ anôŋ ba intu hêv Nakaduŋ doŋtom êŋ halêm ek ôpatu ba hêvhaviŋ tem enja lôkmala anôŋ atu ba êmô êtôm wak nômbêŋ intu sapêŋ. Ma tem miŋ ema ami. ");
INSERT INTO hot_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wapômbêŋ hêv Nakaduŋ halêm pik ek nêm avômalô bulubiŋ. Ma miŋ hêv ek indum abô ek injik avômalô vônô ami. ");
INSERT INTO hot_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ôpatu ba hêvhaviŋ Nakaduŋ êŋ ma Wapômbêŋ miŋ hathak hadum abô ek injik yani vônô ami. Ma ôpatu ba miŋ hêvhaviŋ Nakaduŋ doŋtom êŋ ami ma ôpêŋ lêk hama yôv ek malê nena Wapômbêŋ bôk hadum abô hathak yani yôv. ");
INSERT INTO hot_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wapômbêŋ hadum abô hathak avômalô pik aêntêk. Deda bôk halêm pik yôv. Ma avômalô idum kambom lomaloma ba intu leŋiŋhaviŋ momaŋiniŋ ma êdô deda êŋ. ");
INSERT INTO hot_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Deda tem injik avômalô iniŋ kambom thô ma tem thêlô mama ba intu ŋê kambom ethak êpôlik ba miŋ ibitak êyô deda kapô ami. ");
INSERT INTO hot_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma doŋtom ôpatu ba halaŋô Wapômbêŋ anêŋ abô nena avanôŋ, yani êŋ ma hatôm hamiŋ deda ba avômalô sapêŋ êyê anêŋ ku takatu ba hadum ma Wapômbêŋ da hêv yani sa.” ");
INSERT INTO hot_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yôv ma Yisu lôk anêŋ ŋê ku i Judia anêŋ loŋ kamuŋ ma hamô haviŋ anêŋ ŋê ku wak doho. Ma thêlô ithik avômalô halôk ŋaŋ. ");
INSERT INTO hot_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ainon hêk habobo Salim. Loŋ êŋ ma ŋaŋ bêŋ anôŋ hêk ba avômalô ibi thêthô i loŋ êŋ. Jon miŋ hamô koladôŋ ami denaŋ, ba intu hamô loŋ êŋ ek isik thêlô. ");
INSERT INTO hot_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma anêŋ ŋê ku lôk anyô Islael te êkôki hathak auk nimbitak mabuŋ ênjêk Wapômbêŋ ma. ");
INSERT INTO hot_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Êŋ ma ŋê ku i hadêŋ Jon ma enaŋ, “Kêdôŋwaga! Ôpatu sêbôk ba hamô haviŋ o hamô Jolodaŋ vi ba honaŋ abô bêŋ anôŋ hathak yani. Ondaŋô! Ôpêŋ lêk hathik avômalô halôk ŋaŋ ba avômalô sapêŋ i hadêŋ yani!” ");
INSERT INTO hot_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma Jon hanaŋ, “Wapômbêŋ da anêŋ lahaviŋ ba nômlate habitak aêŋ hadêŋ anyô te ma yôv. ");
INSERT INTO hot_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Môlôda bôk olaŋô abô atu ba yahanaŋ. ‘Ya ma ôpatu ba Wapômbêŋ hêv hamôŋ ek yanaŋ êndêŋ avômalô nena Mesia tem êlêm. Ya miŋ Mesia ami.’ ");
INSERT INTO hot_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Anyô te hawa avi te, êŋ ma tem enja êtôm yanida anêŋ. Ma doŋtom yapmalô ma tem êtôm ôpêŋ anêŋ anyô môlô atu ba imiŋ ek embatho yani loŋ. Ba halaŋô ôpêŋ anêŋ abô ma tem lamavi iyom. Ma yada intu hatôm yapmalô êŋ. Ba intu lêk yaleŋmavi bêŋ anôŋ hamô yakapôlôŋ siŋ. ");
INSERT INTO hot_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wapômbêŋ anêŋ lahaviŋ ba yani habitak anyô bêŋ, ma yada yahabitak anyô oyaŋ.” ");
INSERT INTO hot_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ôpêŋ bôk hamô leŋ ba halêm, yani ma bêŋ anôŋ ek avômalô pik sapêŋ. Ôpatu ba hamô pik êntêk, ôpêŋ ma anyô pik ba intu hanaŋ abô hathak nômkama pik iyom. Avanôŋ! Ôpatu ba halêm anêŋ malak leŋ, ôpêŋ ma bêŋ anôŋ ek avômalô pik sapêŋ. ");
INSERT INTO hot_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yani hanaŋ hathak nôm takatu ba yanida bôk hayê lo halaŋô bêŋ. Ma avômalô miŋ êvhaviŋ abô êŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Wapômbêŋ bôk hêv Lovak Matheŋ ba hamô ôpêŋ kapô siŋ ba halêm hanaŋ Wapômbêŋ anêŋ abô. Ba intu ôpatu ba hêvhaviŋ yani ma hik thô nena Wapômbêŋ ma hanaŋ abô avanôŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lambô lahaviŋ Nakaduŋ ba hêv nômkama sapêŋ ek eyabiŋ. ");
INSERT INTO hot_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ôpatu ba hêvhaviŋ Nakaduŋ lêk hawa lôkmala atu ba tem nêmô êtôm wak nômbêŋ intu sapêŋ. Ma ôpatu ba havôliŋ dôm hadêŋ Nakaduŋ ma Wapômbêŋ bôk hadum abô yôv ba ôpêŋ lêk hawa vovaŋ. Ba intu tem miŋ enja lôkmala ami.” ");
INSERT INTO hot_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Yisu da miŋ hathak hathik avômalô ami. Avômalô takatu ba leŋiŋhaviŋ nesopa Yisu i hadêŋ anêŋ ŋê ku ek nisik i êndôk ŋaŋ. Ma Palisi elaŋô nena avômalô bêŋ anôŋ i hadêŋ Yisu ek isik i. Ma Jon anêŋ lêk auviŋna. ");
INSERT INTO hot_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yisu halaŋô abô êŋ ma hayê nena Palisi lêk ititiŋ anêŋ ku ba intu hatak Judia ma havôhi Galili. ");
INSERT INTO hot_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma loŋôndê atu ba hi Galili ma hi Samalia haviŋ. ");
INSERT INTO hot_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Êŋ ma yani haveŋ ba hi hayô Samalia iniŋ malak lôŋ te ba elam nena Sika. Loŋ êŋ ma habobo pik sêbôk ba Jekop hêv hadêŋ nakaduŋ Josep. ");
INSERT INTO hot_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma Jekop bôk halav ŋaŋ lôv te hamô loŋ êŋ. Yisu haveŋ aleba waklêvôŋ biŋ ma hayô ŋaŋ lôv êŋ ma yani lêk vau ba halôk hamô biŋ. ");
INSERT INTO hot_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ŋê ku lêk i malak ek nênêm vuli nôm. Ma avi Samalia te halêm ek enja ŋaŋ. Ma Yisu hanaŋ hadêŋ avi êŋ, “Ŋaŋ ek yanum.” ");
INSERT INTO hot_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Avômalô Islael ethak êpôlik ek avômalô Samalia ba intu avi êŋ hanaŋ, “O ma Islael ma ya ma avi Samalia. Ma aisê ka honaŋ nena ŋaŋ êlêm ek unum?” ");
INSERT INTO hot_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma Yisu hanaŋ hadêŋ avi êŋ, “Hoyala nôm mavi atu ba Wapômbêŋ hêv lôk hoyala ôpatu ba hanaŋ, ‘Ŋaŋ ek yanum’, êŋ ma tem onaŋ injik yani liŋ ek nêm ŋaŋ lôkmala êndêŋ o.” ");
INSERT INTO hot_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma avi êŋ hanaŋ hadêŋ yani, “Anyô Bêŋ, lôv êntêk ma daim ba anêm uŋ onja ŋaŋ êsê? Ma ŋaŋ lôkmala êŋ tem onja anêŋ êsê? ");
INSERT INTO hot_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yêlôaniŋ bumalô Jekop hêv ŋaŋ lôv êntêk hadêŋ yêlô. Ma yanida lôk nali lôk anêŋ bokmaŋkao sapêŋ inum halôk ŋaŋ lôv êntêk. Ma anêm ŋaŋ ma mavi anôŋ ek ŋaŋ êntêk lôk o ma bêŋ ek Jekop e?” ");
INSERT INTO hot_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma Yisu hanaŋ, “Ŋaŋ êntêk ba inum ma tem nesakmuniŋ esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma doŋtom ôpatu ba hanum ŋaŋ atu ba yahêv ma miŋ hatôm esakmuniŋ esak loŋbô ami. Lôk ŋaŋ êŋ ma tem imbitak êtôm ŋaŋ onaŋ te ênjêk o kapôlôm ba nêm lôkmala anôŋ atu ba tem êmô êtôm wak nômbêŋ intu sapêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma avi êŋ hanaŋ hadêŋ Yisu, “Anyô bêŋ, nêm ŋaŋ êŋ êndêŋ ya ek miŋ yasakmuniŋ esak loŋbô ami. Lôk miŋ yalêm loŋ êntêk ek yanja ŋaŋ esak loŋbô ami.” ");
INSERT INTO hot_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma Yisu hanaŋ hadêŋ yani, “Nu ondam vônim êlêm.” ");
INSERT INTO hot_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma avi êŋ hanaŋ, “Ya anyô mi.” Ma Yisu hanaŋ hadêŋ yani, “Lêk honaŋ avanôŋ nena o anyô mi. ");
INSERT INTO hot_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sêbôk ma vônim baheŋvi. Ba anyô atu ba lêk hômô haviŋ yani ma miŋ vônim ami. Lêk honaŋ abô avanôŋ!” ");
INSERT INTO hot_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma avi êŋ hanaŋ hadêŋ yani, “Anyô bêŋ, lêk yahayala nena o ma plopet te. ");
INSERT INTO hot_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yêlôaniŋ bumalô ethak êv yeŋ halôk dumlolê êntêk. Ma doŋtom môlô avômalô Islael onaŋ nena Wapômbêŋ lahaviŋ alalô nanêm yeŋ êndôk Jelusalem.” ");
INSERT INTO hot_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma Yisu hanaŋ, “Livôŋ! Ondaŋô! Wak te ma tem miŋ môlô nônêm yeŋ ek Wakamik êndôk dumlolê êntêk lo Jelusalem ami. ");
INSERT INTO hot_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Môlô avômalô Samalia ma ôthôŋ ôpatu ba ôêv yeŋ hadêŋ. Ma Wapômbêŋ hêv anyô Islael te ek nêm avômalô bulubiŋ ba intu yêlô avômalô Islael ayala ôpatu ba yêlô êv yeŋ hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","“Wapômbêŋ ma lôkmala anêŋ ôdôŋ. Ba intu Wapômbêŋ habôlêm avômalô takatu ba êv yeŋ ek injiki thô nena thêlô bôk ewa Wapômbêŋ anêŋ lôkmala anôŋ yôv. Aêŋ ba avômalô takatu ba êvhaviŋ Wapômbêŋ intu nênêm yeŋ aêŋ. Ma waklavôŋ atu ba nôm êŋ imbitak intu tem imbitak. Ma lêk hayô yôv.” ");
INSERT INTO hot_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma avi êŋ hanaŋ hadêŋ Yisu, “Yahayala nena Mesia tem êlêm ma tem injik nômkama sapêŋ thô êndêŋ alalô.” (Ma “Mesia” êŋ intu elam nena “Kilisi”.) ");
INSERT INTO hot_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma Yisu hanaŋ hadêŋ yani, “Ôpatu ba hanaŋ abô hadêŋ o ma yani êŋ.” ");
INSERT INTO hot_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Enaŋ abô denaŋ ma Yisu anêŋ ŋê ku êvô êlêm hathak loŋbô ma êyê Yisu hanaŋ abô haviŋ avi êŋ ba esoŋ kambom. Ma doŋtom thêlô bônôŋ ma miŋ enaŋ hik yani liŋ nena, “Lemhaviŋ malê?” mena “Honaŋ abô haviŋ avi êntêk eka?” ");
INSERT INTO hot_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Êŋ ma avi êŋ hatak anêŋ uŋ hawa ŋaŋ hamô ma havôhi malak ôdôŋ hathak loŋbô. Ma hanaŋ hadêŋ avômalô nena, ");
INSERT INTO hot_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Môlô nôlêm ôŋgô anyô te! Nôm takatu ba bôk yahadum yôv ma yani hayala ba hanaŋ bêŋ hadêŋ ya. Betha yani ma Mesia atu la.” ");
INSERT INTO hot_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Avômalô elaŋô abô êŋ ma etak malak ba i hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Avi Samalia hamô malak denaŋ ma ŋê ku enaŋ hadêŋ Yisu nena, “Kêdôŋwaga, noŋgwaŋ nôm.” ");
INSERT INTO hot_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma hanaŋ, “Yenaŋ nôm hamô ek yaŋgaŋ ma môlô ôthôŋ nôm êŋ paliŋ.” ");
INSERT INTO hot_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Êŋ ma ŋê ku enaŋ hadêŋ thêlôda nena, “Betha anyôla lêk hêv nôm hadêŋ yani la?” ");
INSERT INTO hot_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma Yisu hanaŋ hadêŋ thêlô, “Yenaŋ nôm êntêk. Tem yasopa Wapômbêŋ anêŋ lahaviŋ ba yandum anêŋ ku lôkthô atu ba hêv ya ba yahalêm. ");
INSERT INTO hot_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Môlô othak onaŋ, ‘Ayôŋ ayova iyom hêk, êŋ ma tem nôm injik anôŋ ba alalô naja.’ Yanaŋ êndêŋ môlô! Malemim ekyav ba ôŋgô ku katô! Nôm lêk hik anôŋ yôv! ");
INSERT INTO hot_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ôpatu ba halav nôm ma hawa anêŋ vuli. Yani halav nôm anôŋ ek nôm sapêŋ êŋ neja lôkmala anôŋ atu ba tem nêmô êtôm wak nômbêŋ intu sapêŋ ek anyô havatho nôm lôk anyô halav nôm thai luvi leŋiŋmavi. ");
INSERT INTO hot_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Aêŋ ba abô êntêk ma abô avanôŋ. ‘Anyô yaŋ habaŋ ku ba havatho ma anyô yaŋ halav anêŋ anôŋ.’ ");
INSERT INTO hot_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yahêv môlô ba u ek noja nôm êmô ku atu ba miŋ bôk môlô udum ku êŋ ami. Anyô vi idum ku êŋ. Ma môlô u olav anôŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Avômalô Samalia bêŋ anôŋ êmô malak êŋ ba elaŋô avi êŋ hanaŋ, “Nôm takatu ba bôk yahadum yôv ma yani hayala ba hanaŋ bêŋ hadêŋ ya!” Ba intu thêlô êvhaviŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Êŋ ma ŋê Samalia takêŋ êlêm enaŋ hik yani liŋ, “Ômô imbiŋ yêlô wak doho!” Ma yani hamô haviŋ thêlô hatôm wak ju. ");
INSERT INTO hot_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma hanaŋ abô haviŋ i ba intu bêŋ anôŋ êvhaviŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma thêlô enaŋ hadêŋ avi êŋ nena, “Sêbôk yêlô alaŋô anêm abô ba êvhaviŋ. Ma lêk yêlôda alaŋô anêŋ abô ma ayala nena avanôŋ. Ôpêŋ ma ôpatu ba tem nêm avômalô pik bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","45","Wak ju hale ba hi ma hatak loŋ êŋ ma hi Galili. Ma avômalô Galili doho bôk êmô Jelusalem hadêŋ waklavôŋ Hale ba Hi ba intu êyê nôm takatu ba hadum. Aêŋ ba hayô Galili ma ewa yani thô. Ma doŋtom ewa yani thô oyaŋ hathak nêgê nômbithi iyom ba intu hatôm abô atu ba Yisu hanaŋ nena plopet ma athêŋ mi hêk iniŋ malak ôdôŋ. ");
INSERT INTO hot_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hamô Galili vêm ma havôhi Kena loŋ atu ba bôk hadum ŋaŋ ba habitak waiŋ. Kena ma hamô Galili kapô. Ma anyô bêŋ te hamô Kapaneam ba namalô hapôm lijiŋ ba hadum ek ema. ");
INSERT INTO hot_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ôpêŋ halaŋô nena Yisu bôk hatak Judia ma lêk hamô Galili. Êŋ ma hi hadêŋ Yisu ba halaŋ hadêŋ yani nena ni indum namalô mavi. ");
INSERT INTO hot_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aêŋ ba Yisu hathaŋ yani aêntêk, “Môlô lemhaviŋ yandum lavôŋiŋ lôk nômbithi lomaloma ek môlô nônêmimbiŋ ya e?” ");
INSERT INTO hot_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Êŋ ma anyô bêŋ êŋ hanaŋ hadêŋ Yisu, “Anyô bêŋ, ôlêm ketheŋ! Yenaŋ okna tem ema!” ");
INSERT INTO hot_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma Yisu hanaŋ hadêŋ yani, “Ondenu! Nalummalô tem êmô lôkmala.” Yôv ma ôpêŋ hêvhaviŋ Yisu anêŋ abô ba hi ");
INSERT INTO hot_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ma anêŋ ŋê ku êpôm yani ba enaŋ nena, “Nalummalô hamô lôkmala.” ");
INSERT INTO hot_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Êŋ ma yani hanaŋ hik thêlô liŋ nena wakma alê intu okna êŋ mavi. Ma enaŋ, “Wakbôk yaŋsiŋ hatôm 1 kilok ma lijiŋ êŋ hatak yani.” ");
INSERT INTO hot_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma lambô lahabi nena wakbôk atu ba hatôm wakma êŋ ma Yisu hanaŋ hadêŋ yani nena, “Nalummalô tem êmô lôkmala.” Ba intu yani lôk anêŋ avômalô sapêŋ êvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yisu bôk hatak Judia ba hi Galili ma hadum lavôŋiŋ yaŋ êŋ ek hik thô nena Wapômbêŋ hêv yani ba halêm. ");
INSERT INTO hot_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Vêm ma Yisu hi daku Jelusalem ek ênjê avômalô Islael iniŋ waklavôŋ te. ");
INSERT INTO hot_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kasuk te hêk Jelusalem ba avômalô Islael elam nena Betesda. Kasuk êŋ hêk habobo Jelusalem anêŋ badêŋ abôlêk atu ba elam nena Sipsip iniŋ Unyak Abôlêk. Ba kapo daŋ êyô êmô baheŋvi hêk loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ma ŋê lôk lijiŋ hatôm ŋê maleŋiŋ pusip lôk ŋê veŋiŋ kambom ma ŋê ivuviŋ ethak êk kapo daŋ takêŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma anyô te hawa lijiŋ havuviŋ ba hêk kapo daŋ êŋ te hatôm sondabêŋ 38. ");
INSERT INTO hot_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yisu hayê ôpêŋ ma hayala nena lijiŋ bôk hamô bô ba hanaŋ hik yani liŋ, “Lemhaviŋ umbitak mavi e?” ");
INSERT INTO hot_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma ôpêŋ hanaŋ viyaŋ, “Anyô bêŋ, kasuk hathak liŋaliŋ ma anyôla miŋ hamô ek nêm ya sa ami. Yahadum ek yandôk êmôŋ ma doŋtom anyô vi êlôk êmôŋ ek ya.” ");
INSERT INTO hot_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Êŋ ma Yisu hanaŋ hadêŋ yani, “Umbiyô umiŋ! Ma onja anêm yêm ba nu!” ");
INSERT INTO hot_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ketheŋ oyaŋ ma yani habitak mavi ba hawa anêŋ yêm ba hi. Wak êŋ ma Sabat. ");
INSERT INTO hot_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ba intu Islael iniŋ ŋê bêŋbêŋ enaŋ hadêŋ anyô havuviŋ atu ba lêk habitak mavi nena, “Lêk ma Sabat! Abô balabuŋ hatip ek miŋ onja yêm ba ombeŋ ami.” ");
INSERT INTO hot_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma ôpêŋ hanaŋ viyaŋ, “Ôpatu ba hadum ya mavi hanaŋ nena, ‘Onja anêm yêm ba nu.’” ");
INSERT INTO hot_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma thêlô enaŋ hik yani liŋ, “Opalê intu hanaŋ nena onja anêm yêm ba nu?” ");
INSERT INTO hot_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Avômalô bêŋ anôŋ êmô loŋ êŋ ba Yisu hêv i vê menaŋna ba hi. Ba intu ôpêŋ hathôŋ nena opalê. ");
INSERT INTO hot_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yôv ma Yisu habitak hayô unyak matheŋ anêŋ piklêvôŋ ma hayê ôpêŋ hamô ma hanaŋ, “Ondaŋô. O lêk mavi hathak loŋbô ba otak anêm kambom. Yakô malaiŋ bêŋ yaŋ tem êpôm o.” ");
INSERT INTO hot_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Êŋ ma ôpêŋ hi hanaŋ hadêŋ Islael iniŋ ŋê bêŋbêŋ, “Yisu ma ôpatu ba hadum ya mavi.” ");
INSERT INTO hot_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yisu hadum nôm takêŋ hadêŋ Sabat. Ba intu Islael iniŋ ŋê bêŋbêŋ ethaŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma Yisu hanaŋ, “Wakamik hathak hadum ku wak nômbêŋ intu sapêŋ ba hadum ku takêŋ denaŋ. Ba intu ya tem yandum ku aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Islael iniŋ ŋê bêŋbêŋ elaŋô abô êŋ ma êyê nena Yisu lêk habuliŋ abô balabuŋ hathak Sabat ba hadum ku. Ma halam Wapômbêŋ nena Lambô ma yanida hadum i hatôm Wapômbêŋ. Ba intu leŋiŋmaniŋ kambom ba êbôlêm auk ek nijik yani vônô. ");
INSERT INTO hot_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma Yisu hanaŋ hadêŋ ŋê bêŋbêŋ, “Yanaŋ avanôŋ biŋ êndêŋ môlô. Ya ma Nakaduŋ. Ma malê atu ba Lambô hadum ma tem Nakaduŋ indum aêŋ iyom. Ya miŋ hatôm yandum nômlate êtôm yenaŋ auk ami. Aêŋ ba nômkama sapêŋ atu ba yahayê Wakamik hadum ma tem yasopa. ");
INSERT INTO hot_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wakamik lahaviŋ ya anêŋ Nakaduŋ ba hik nômkama takatu ba yani hadum thô hadêŋ ya. Aêŋ ba Nakaduŋ hatôm indum nôm takatu ba Lambô hadum. Ma tem injik ku mavi bêŋ anôŋ thô êndêŋ Nakaduŋ ba indum môlô nosoŋ kambom ek ku yaŋ sêbôk. ");
INSERT INTO hot_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wakamik hathak hik ŋê ŋama liŋ ba hêv lôkmala hadêŋ i. Ma aêŋ iyom ma ya Nakaduŋ tem yanêm lôkmala êndêŋ avômalô êtôm yada yaleŋhaviŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ma wakamik hatak ku nedaŋô avômalô iniŋ abô halôk yabaheŋ. Ma yanida miŋ hadum ku êŋ ami. Aêŋ ba lôkmala atu ba Wakamik hêv ma tem yanêm aêŋ iyom ");
INSERT INTO hot_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ek avômalô takatu ba elovak Nakaduŋ vibiŋ intu elovak Lambô aêŋ iyom. Ma ŋê takatu ba êpôlik ek ya intu êpôlik ek Wakamik atu ba hêv ya ba yahalêm. ");
INSERT INTO hot_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Yanaŋ avanôŋ biŋ êndêŋ môlô. Ôpatu ba halaŋô yenaŋ abô ba hêvhaviŋ Wakamik atu ba hêv ya ba yahalêm ma lêk hawa lôkmala atu ba tem êmô êtôm wak nômbêŋ intu sapêŋ yôv. Ma Wapômbêŋ tem miŋ indum abô ek yani ba ema ami. Yani bôk hatak ŋama yôv ba lêk hamô lôkmala anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yanaŋ avanôŋ biŋ êndêŋ môlô. Avômalô ŋama tem nedaŋô ya Wapômbêŋ anêŋ Nakaduŋ anêŋ abô. Ma avômalô takatu ba esopa ma tem nêmô lôkmala. Wak te ma nôm takêŋ tem imbitak. Ma wak êŋ lêk hayô yôv. ");
INSERT INTO hot_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","“Wakamik ida hamô lôkmala ba hadum ba ya Nakaduŋ yahamô lôkmala aêŋ iyom. Ba intu hatôm yanêm lôkmala êŋ êndêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma ya ma Anyô Anêŋ Nakaduŋ atu. Aêŋ ba hatak ya ek yandum ku yandaŋô avômalô iniŋ abô. ");
INSERT INTO hot_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Môlô miŋ nosoŋ esak yenaŋ abô êntêk ami. Wak te am ka tem ŋê ŋama nedaŋô ya Nakaduŋ yaleŋselo ");
INSERT INTO hot_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ba nimbiyô esak loŋbô. Ma thêlô takatu ba bôk idum mavi ma tem nêmô lôkmala. Ma vi atu ba bôk idum kambom ma tem nêpôm abô ba nema. ");
INSERT INTO hot_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yada miŋ hatôm yandum nômlate êtôm yada yenaŋ auk ami. Yahasopa Wakamik anêŋ auk atu ek yandaŋô avômalô iniŋ abô ek yanêm lôkmala mena ŋama êndêŋ i la. Yahasopa Wakamik anêŋ lahaviŋ, ôpatu ba hêv ya ba yahalêm. Ma yada miŋ yahasopa yenaŋ yaleŋhaviŋ ami. Ba intu yenaŋ abô yahadum ma thêthôŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Yahavatho yenaŋ abô loŋ êŋ ma tem miŋ avômalô nênêmimbiŋ ya ami. ");
INSERT INTO hot_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma doŋtom anyô yaŋ bôk havatho yenaŋ abô loŋ yôv. Ma yahayala nena anêŋ abô atu ba hanaŋ hathak ya ma avanôŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Sêbôk ma môlô onaŋ hik Jon liŋ hathak ya ba yani bôk hanaŋ abô avanôŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ma anyô pik te hatôm embatho yenaŋ abô loŋ e? Yahanaŋ hathak Jon anêŋ abô êŋ ek môlô noja bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ma hatôm atum lam atu ba êtôm ba hêv deda. Ma môlô othak ôlêlêk am hathak anêŋ deda êŋ sawa bidoŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ma doŋtom yahadum ku takatu ba Wakamik hêv hadêŋ ya ba intu hik thô nena Wakamik hêv ya ba yahalêm. Ba ku êŋ ma hamôŋ ek Jon anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Wakamik atu ba hêv ya ba yahalêm intu hik ya thô. Ma môlô miŋ ôêvhaviŋ ya ami. Aêŋ ba môlô miŋ bôk olaŋô Wakamik laselo lôk ôyê yani thohavloma ami ma anêŋ abô miŋ hêk haviŋ môlô ami aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Môlô othak utitiŋ Wapômbêŋ anêŋ kapya ba osoŋ nena tem nêm lôkmala atu ba nêmô êtôm wak nômbêŋ intu sapêŋ êndêŋ môlô. Abô êŋ ma hik ya thô, ");
INSERT INTO hot_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ma doŋtom môlô ôdô nosopa ya ek noja lôkmala anôŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ya miŋ yahanaŋ abô êŋ ek avômalô nebam ya ami. ");
INSERT INTO hot_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma doŋtom yahayala môlô! Môlô miŋ lemimhaviŋ Wapômbêŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wakamik hêv ya ba yahalêm ek yanaŋ anêŋ abô bêŋ. Ma môlô ôpôlik hathak ya. Ma doŋtom anyô te halêm ba hanaŋ yanida anêŋ abô, êŋ ma môlô othak owa yani thô! ");
INSERT INTO hot_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Môlô othak ôêv athêŋ lôkmaŋgiŋ hadêŋ ôpatu ba lahaviŋ môlô. Ma doŋtom miŋ môlô malemkilik hathak Wapômbêŋ doŋtom atu anêŋ lamavi ami. Êŋ ma tem nônêmimbiŋ aisê? ");
INSERT INTO hot_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Môlô othak ôêv malem hadêŋ Mose. Ma doŋtom tem enaŋ môlô bêŋ. Ba intu miŋ môlô lemimimbi nena tem yanaŋ môlô bêŋ imiŋ Wakamik ma ami. Mi anôŋ! ");
INSERT INTO hot_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mose bôk hato abô hathak ya yôv. Aêŋ ba môlô ôêvhaviŋ Mose anêŋ abô, êŋ ma tem nônêmimbiŋ ya imbiŋ. ");
INSERT INTO hot_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma doŋtom môlô miŋ ôêvhaviŋ abô atu ba yani hato ami. Ba intu môlô miŋ ôêvhaviŋ yenaŋ abô haviŋ ami.” ");
INSERT INTO hot_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yôv ma Yisu hi kasukthôm Galili anêŋ daŋ vi. Kasuk êŋ anêŋ athêŋ yaŋ nena Taibelias. ");
INSERT INTO hot_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma avômalô bêŋ anôŋ bôk êyê lavôŋiŋ takatu ba hadum hathak avômalô lijiŋ ba intu esopa yani. ");
INSERT INTO hot_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yisu hathak dum ba hi ma halôk hamô biŋ haviŋ anêŋ ŋê ku. ");
INSERT INTO hot_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Avômalô Islael iniŋ waklavôŋ elam nena Hale ba Hi habobo. ");
INSERT INTO hot_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ma Yisu hayê avômalô bêŋ anôŋ êlêm ma hanaŋ hadêŋ Pilip, “Alalô nanêm vuli polom embeŋ êsê ek nabakôŋ avômalô takêntêk?” ");
INSERT INTO hot_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yani hayala nôm atu ba tem yani indum ba intu hanaŋ ek eyala Pilip anêŋ auk iyom. ");
INSERT INTO hot_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma Pilip hanaŋ viyaŋ, “Alalô nandum ku êtôm ayôŋ baheŋvi ba lahavulô la anêŋ vuli ma miŋ hatôm nanêm polom vuli ek avômalô tomtom nejaŋ dokte dokte ami!” ");
INSERT INTO hot_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Êŋ ma ŋê ku te anêŋ athêŋ nena Andulu, Saimon Pita anêŋ yaŋ molok, hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nôŋgô okna êntêk anêŋ polom bali yaônena baheŋvi lôk alim yaôna lokwaŋju. Ba nôm êŋ hatôm avômalô nômbêŋ êntêk e?” ");
INSERT INTO hot_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ma Yisu hanaŋ, “Nonaŋ êndêŋ avômalô ek nêndôk nêmô biŋ.” Kamuŋ bêŋ anôŋ hamô loŋ êŋ ba anyô sapêŋ êlôk êmô. Thêlô hatôm 5,000. ");
INSERT INTO hot_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Êŋ ma Yisu hawa polom ma hateŋ mek ba havani hatôm thêlôniŋ leŋiŋhaviŋ vêm ma hadum aêŋ hathak alim ju atu haviŋ. ");
INSERT INTO hot_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Thêlô eyaŋ ba leŋiŋviyak ma Yisu hanaŋ hadêŋ anêŋ ŋê ku nena, “Môlô nusup nôm wata sapêŋ esak doŋtom ma miŋ nômbi ni ami.” ");
INSERT INTO hot_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Êŋ ma isup polom wata ba etak halôk vak sam hatôm laumiŋ ba lahavuju. ");
INSERT INTO hot_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ma avômalô êyê lavôŋiŋ êŋ ba enaŋ, “Avanôŋ! Sêbôk ma enaŋ nena plopet te tem êlêm. Ma êntêk lêk halêm yôv.” ");
INSERT INTO hot_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Êŋ ma idum ek nebaloŋ yani ek imbitak êtôm iniŋ kiŋ. Ma hayala iniŋ auk êŋ, ba intu hatak loŋ êŋ ma havôhi dum atu hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yaŋsiŋ ma anêŋ ŋê ku i tamu kasukthôm anêŋ daŋ. ");
INSERT INTO hot_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bôlôvôŋ ma miŋ Yisu hayô ek thêlô ami. Ma thêlô iyom ethak yeŋ ba i tuvulu Kapaneam. ");
INSERT INTO hot_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ma lovak bêŋ te hayuv ba kasuk hik bêŋ. ");
INSERT INTO hot_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Thêlô ivusiŋ yeŋ ba i hatôm 6 kilomita la. Ma êyê Yisu haveŋ kasukthôm anêŋ dômlê ba halêm habobo yeŋ ba hadum thêlô êkô kambom. ");
INSERT INTO hot_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma Yisu hanaŋ hadêŋ thêlô nena, “Yada êntêk! Miŋ nôkô ami.” ");
INSERT INTO hot_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Êŋ ma thêlô leŋiŋmavi ba êlôk ek yani ni yeŋ kapô. Ma kasana ma yeŋ hi hathak liŋdaŋ. ");
INSERT INTO hot_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Haviyô hayaŋ ma avômalô takatu ba êmô kasukthôm anêŋ daŋ vi tuvulu eyala nena wakbôk ma yeŋ doŋtom iyom hamô ba ŋê ku iyom ethak yeŋ êŋ ba i. Ma Yisu miŋ hathak yeŋ êŋ haviŋ anêŋ ŋê ku ba hi ami ma mi. ");
INSERT INTO hot_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Êŋ ma avômalô Taibelias iniŋ yeŋ doho êlêm ebobo loŋ atu ba Anyô Bêŋ hava polom liŋ halôk ba thêlô eyaŋ. ");
INSERT INTO hot_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma avômalô êyê nena Yisu lôk anêŋ ŋê ku miŋ êmô ami. Êŋ ma thêlô ethak yeŋ ba i Kapaneam ek nêmbôlêm Yisu. ");
INSERT INTO hot_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Avômalô i êpôm Yisu hêk loŋ atu ma enaŋ, “Kêdôŋwaga, aŋgê te intu hôlêm loŋ êntêk?” ");
INSERT INTO hot_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma Yisu hanaŋ nena, “Yanaŋ avanôŋ biŋ êndêŋ môlô. Môlô bôk oaŋ polom aleba lemimviyak. Ba intu môlô ôbôlêm ya. Ma lavôŋiŋ ma môlô bôk ôyê ma doŋtom ôthôŋ paliŋ denaŋ. ");
INSERT INTO hot_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nundum ku ek noja nôm atu ba tem nêm lôkmala ba nêmô êtôm wak nômbêŋ intu sapêŋ. Wakamik Wapômbêŋ bôk havak sêk hayô hêk ya Anyô Anêŋ Nakaduŋ ba tem nêm lôkmala êŋ êndêŋ môlô. Ma miŋ malemkilik esak nôm atu ba tem epalê ami!” ");
INSERT INTO hot_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Êŋ ma thêlô enaŋ, “Wapômbêŋ lahaviŋ yêlô nandum ku malê?” ");
INSERT INTO hot_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma Yisu hanaŋ, “Wapômbêŋ anêŋ ku nena nônêmimbiŋ ôpatu ba yani hêv ba halêm.” ");
INSERT INTO hot_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Êŋ ma thêlô enaŋ hik yani liŋ, “Undum lavôŋiŋ te ek yêlô nagê ma tem nanêmimbiŋ anêm abô. Mose bôk hêv mana hadêŋ yêlôaniŋ bumalô ba eyaŋ hamô loŋ thiliv ba eto aêntêk, ‘Yani hêv polom anêŋ malak leŋ hadêŋ avômalô ba eyaŋ.’ Ma o, tem undum lavôŋiŋ alê yaŋ?” ");
INSERT INTO hot_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","Ma Yisu hanaŋ, “Yanaŋ avanôŋ biŋ êndêŋ môlô nena Anyô Bêŋ hêv anyô te ba halêm anêŋ malak leŋ ba hêv lôkmala hadêŋ avômalô hatôm polom anôŋ. Ba intu Wakamik iyom hêv nôm anôŋ anêŋ malak leŋ hadêŋ môlô. Ma miŋ Mose hêv ami.” ");
INSERT INTO hot_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Êŋ ma thêlô enaŋ, “Anyô Bêŋ, wak nômbêŋ intu sapêŋ ma nêm polom êŋ êndêŋ yêlô.” ");
INSERT INTO hot_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Êŋ ma Yisu hanaŋ, “Ya ma polom lôkmala. Ôpatu ba halêm hadêŋ ya ma tem miŋ ema kisi ami. Ma ôpatu ba hêvhaviŋ ya ma tem miŋ esakmuniŋ ek inum ŋaŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ma doŋtom bôk yahanaŋ hadêŋ môlô yôv. Môlô lêk ôyê ya ma miŋ môlô ôêvhaviŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","40","Lêk yahalêm anêŋ malak leŋ ek yasopa ôpatu ba hêv ya ba yahalêm anêŋ lahaviŋ. Ma miŋ yahalêm ek yasopa yada yenaŋ yaleŋhaviŋ ami. Avômalô takatu ba êyê ya Nakaduŋ ba êvhaviŋ ma tem neja lôkmala anôŋ atu ba nêmô êtôm wak nômbêŋ intu sapêŋ. Ma pik lo leŋ anêŋ daŋ ma tem yaŋgik thêlô liŋ. Êntêk ma Wakamik anêŋ lahaviŋ. Ba intu miŋ hatôm yatak avômalô takatu ba Wakamik hêv hadêŋ ya te ami. Milôk. Pik lo leŋ anêŋ daŋ ma tem yaŋgik thêlô liŋ. Êntêk ma yani atu ba hêv ya ba yahalêm anêŋ lahaviŋ. Ba intu avômalô takatu ba Wakamik hêv hadêŋ ya ma tem nêlêm êndêŋ ya. Ma opalê atu ba halêm hadêŋ ya ma tem miŋ yandupuniŋ yani ami.” ");
INSERT INTO hot_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Avômalô Islael elaŋô Yisu anêŋ abô êŋ “Ya ma nôm atu ba halôk anêŋ malak leŋ ba halêm.” Êŋ ma enaŋ abô munuŋmunuŋ ");
INSERT INTO hot_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","nena, “Anyô êntêk ma Yisu, Josep anêŋ nakaduŋ! Ma alalô ayala talêbô lo lambô! Ma aisê ka hanaŋ nena halôk anêŋ malak leŋ ba halêm?” ");
INSERT INTO hot_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma Yisu hanaŋ, “Môlô bônôŋ! ");
INSERT INTO hot_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wakamik hêv ya ba yahalêm ba ôpatu ba halom hadêŋ ya iyom intu tem enja lôklokwaŋ ek êlêm êndêŋ ya. Ma pik lo leŋ anêŋ daŋ ma tem yaŋgik avômalô takêŋ liŋ nimbiyô esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Plopet te bôk hato abô halôk kapya aêntêk, “‘Wapômbêŋ tem nêm auk êndêŋ avômalô sapêŋ.’ Avômalô takatu ba elaŋô Wakamik anêŋ abô ba ewa auk, thêlô tem nêlêm ek ya. ");
INSERT INTO hot_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Anyô te miŋ bôk hayê Wakamik ami. Ôpatu ba hamô haviŋ Anyô Bêŋ ba halêm iyom intu hayê. ");
INSERT INTO hot_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yanaŋ avanôŋ biŋ êndêŋ môlô. Anyô hêvhaviŋ ya ma lêk hawa lôkmala anôŋ atu ba êmô êtôm wak nômbêŋ intu sapêŋ yôv. ");
INSERT INTO hot_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ya ma polom lôkmala. ");
INSERT INTO hot_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Môlônim bumalô takatu ba eyaŋ mana hamô loŋ thiliv bôk ema yôv. ");
INSERT INTO hot_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma polom atu ba halêm anêŋ malak leŋ ba avômalô eyaŋ tem miŋ nema ami. ");
INSERT INTO hot_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yada intu polom lôkmala ba yahalêm anêŋ malak leŋ. Anyô te hayaŋ, êŋ ma tem êmô lôkmala êtôm wak nômbêŋ intu sapêŋ. Polom êŋ ma yenaŋ vathiap ek yanêm ek avômalô pik neja lôkmala.” ");
INSERT INTO hot_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma avômalô Islael elaŋô abô êŋ ma kapôlôŋiŋ ŋôŋô ba enaŋ nena, “Anyô êntêk hatôm nêm anêŋ vathiap êndêŋ alalô ba aŋgaŋ aisê?” ");
INSERT INTO hot_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma Yisu hanaŋ, “Yanaŋ avanôŋ biŋ êndêŋ môlô. Môlô miŋ oaŋ ya Anyô Anêŋ Nakaduŋ atu anêŋ vathiap lôk unum anêŋ thalaleŋ ami, ma tem miŋ noja lôkmala ami. ");
INSERT INTO hot_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","55","Yenaŋ vathiap ma nôm anôŋ biŋ ek nejaŋ, ma yenaŋ thalaleŋ ma nôm anôŋ biŋ ek ninum. Ba intu anyô hayaŋ yenaŋ vathiap lôk hanum yenaŋ thalaleŋ ma yani hawa lôkmala atu ba nêmô êtôm wak nômbêŋ intu sapêŋ. Ma pik lo leŋ anêŋ daŋ ma tem yaŋgik yani liŋ. ");
INSERT INTO hot_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ôpatu ba hayaŋ yenaŋ vathiap lôk hanum yenaŋ thalaleŋ intu hamô haviŋ ya ma yahamô haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wakamik ida hamô lôkmala ba hêv ya ba yahalêm ba intu yada yahamô lôkmala aêŋ iyom. Aêŋ ba ôpatu ba hayaŋ ya ma tem êmô lôkmala aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Êntêk ma polom atu ba lêk halêm anêŋ malak leŋ. Sêbôk ma bumalô eyaŋ mana ba bôk ema ba mi. Ma ôpatu ba hayaŋ polom êŋ, ma tem enja lôkmala anôŋ atu ba êmô êtôm wak nômbêŋ intu sapêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisu hamô unyak yeŋ anêŋ Kapaneam ma hadôŋ avômalô hathak auk takêŋ. ");
INSERT INTO hot_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Avômalô takatu ba esopa Yisu elaŋô abô takêŋ ma bêŋ anôŋ êpôlik ba enaŋ, “Abô êntêk ma abôma ba opalê hatôm endaŋô?” ");
INSERT INTO hot_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yisu hayala nena thêlô enaŋ abô munuŋmunuŋ hathak abô atu. Êŋ ma hanaŋ, “Abô êntêk habuliŋ môlô e? ");
INSERT INTO hot_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ma môlô ôyê ya Anyô Anêŋ Nakaduŋ atu havôhi daku loŋ sêbôk atu ba yani hamô, êŋ ma tem môlô lemimimbi aisê? ");
INSERT INTO hot_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lovak Matheŋ da hêv lôkmala hadêŋ avômalô. Ma avômalô pik miŋ êtôm ami. Abô takatu ba yahanaŋ hadêŋ môlô ma ida hamô lôkmala ba halêm anêŋ Lovak Matheŋ ba hêv lôkmala êŋ hadêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Ma doŋtom môlô doho miŋ ôêvhaviŋ ami. Ba intu bôk yahanaŋ hadêŋ môlô nena ôpatu ba Wakamik halom hadêŋ ya iyom intu tem enja lôklokwaŋ ek êlêm êndêŋ ya.” Aêŋ ba môŋ anôŋ ma Yisu hadôŋ avômalô ba hayala ŋê takatu ba miŋ êvhaviŋ ami. Ma hayala ôpatu ba tem enaŋ yani bêŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Êŋ ma avômalô bêŋ anôŋ elaŋô abô êŋ ma êpôlik hathak yani ba miŋ esopa yani hathak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yisu hanaŋ hik ŋê ku laumiŋ ba lahavuju takatu liŋ, “Ma môlô lemimhaviŋ unu imbiŋ e?” ");
INSERT INTO hot_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma Saimon Pita hanaŋ viyaŋ, “Anyô Bêŋ, yêlô ana êndêŋ opalê am? Anêm abô iyom intu hêv lôkmala atu ba tem nêmô êtôm wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma yêlô êvhaviŋ ba ayala katô nena o ma Wapômbêŋ anêŋ Anyô Matheŋ.” ");
INSERT INTO hot_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma Yisu hanaŋ, “Bôk yahatak môlô laumiŋ ba lahavuju ek numbitak yenaŋ ŋê ku. Ma doŋtom môlônim anyô te ma ŋgôk.” ");
INSERT INTO hot_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yani hanaŋ hathak Judas, Saimon Iskaliot anêŋ nakaduŋ. Yani ma ŋê ku laumiŋ ba lahavuju takatu te ma doŋtom wak te am ka tem yani enaŋ Yisu bêŋ. ");
INSERT INTO hot_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Vêm ma Islael iniŋ ŋê bêŋbêŋ idum ek nijik Yisu vônô. Ba intu hadô ek ni Judia ma hi haveŋ Galili lôbôlôbô iyom. ");
INSERT INTO hot_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma avômalô Islael iniŋ waklavôŋ te habobo ba elam nena Elav Unyak Alôkŋauŋ. ");
INSERT INTO hot_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Êŋ ma Yisu anêŋ iviyaŋ ibi yani liliŋ ba enaŋ, “Waklavôŋ Elav Unyak Alôkŋauŋ lêk hayô ba otak loŋ êntêk ma nu Judia ek anêm avômalô takatu ba esopa o tem nêgê lavôŋiŋ takatu ba hothak hudum. ");
INSERT INTO hot_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Lemhaviŋ avômalô sapêŋ neyala o, êŋ ma miŋ umbuŋ o ami. Bôk huik o thô yôv ba intu nu yaiŋ ek avômalô sapêŋ neyala o!” ");
INSERT INTO hot_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yisu anêŋ iviyaŋ miŋ êvhaviŋ yani ami ba intu enaŋ aêŋ. ");
INSERT INTO hot_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma Yisu hanaŋ viyaŋ, “Yenaŋ waklavôŋ yana Jelusalem ma mi denaŋ. Ma môlô ma wak sapêŋ ma mavi. ");
INSERT INTO hot_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Avômalô pik miŋ hatôm nêpôlik ek môlô ami. Ma yahik avômalô pik iniŋ kambom thô ba intu êpôlik hathak ya. ");
INSERT INTO hot_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Môlô nu ôŋgô waklavôŋ atu. Ma yenaŋ waklavôŋ yana Jelusalem miŋ lêk hayô ami denaŋ ba intu tem miŋ yana daku ami.” ");
INSERT INTO hot_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Êŋ ma hamô Galili. ");
INSERT INTO hot_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aêŋ ba anêŋ iviyaŋ êmôŋ ba i ek nêgê waklavôŋ êŋ. Ma yani haveŋ i yam ma doŋtom miŋ hik i thô ami. ");
INSERT INTO hot_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ma Islael iniŋ ŋê bêŋbêŋ takatu ba êyê waklavôŋ êmô Jelusalem êbôlêm Yisu ba enaŋ, “Anyô êntêk hamô êsê?” ");
INSERT INTO hot_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma avômalô nômbêŋ êŋ enaŋ abô thikuthik bêŋ anôŋ hadêŋ i hathak yani. Vi enaŋ, “Yani anyô mavi anôŋ.” Ma vi enaŋ, “Mi. Yani hasau avômalô.” ");
INSERT INTO hot_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma avômalô êkô ek iniŋ ŋê bêŋbêŋ ba intu miŋ imiŋ piklêvôŋ ek nenaŋ iniŋ auk bêŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Waklavôŋ Elav Unyak Alôkŋauŋ anêŋ wak te malêvôŋ hayô. Ma Yisu hi unyak matheŋ anêŋ piklêvôŋ ba hêv auk hadêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Islael iniŋ ŋê bêŋbêŋ elaŋô Yisu anêŋ abô êŋ ma esoŋ kambom ba enaŋ, “Aisê ka ôpêntêk hawa auk hathak alalôaniŋ abô balabuŋ? Kêdôŋwaga te miŋ hadôŋ yani ami.” ");
INSERT INTO hot_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ma Yisu hanaŋ viyaŋ, “Auk atu ba yahêv hadêŋ môlô halêm anêŋ ôpatu ba hêv ya ba yahalêm ma miŋ yada yenaŋ auk ami. ");
INSERT INTO hot_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ôpatu ba hadum ek esopa Wapômbêŋ anêŋ lahaviŋ, yani tem eyala nena yenaŋ auk êŋ halêm anêŋ Wapômbêŋ mena halêm anêŋ yada yenaŋ auk iyom. ");
INSERT INTO hot_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ôpatu ba habam yanida hadum aêŋ ek enja athêŋ lôkmaŋgiŋ. Ma doŋtom ôpatu ba hadum ku ek avômalô nebam anyô atu ba hêv yani ba halêm, ôpêŋ ma hanaŋ abô avanôŋ. Ma miŋ hasau avômalô ami. ");
INSERT INTO hot_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose bôk hêv abô balabuŋ hadêŋ môlô yôv. Ma doŋtom môlônim anyô te miŋ hasopa abô balabuŋ takêŋ ami! Ma môlô udum ek uŋgwik ya vônô eka?” ");
INSERT INTO hot_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ma avômalô enaŋ viyaŋ, “Ŋgôk hamô haviŋ o. Opalê te hadum ek injik o vônô?” ");
INSERT INTO hot_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ma Yisu hanaŋ, “Bôk yahadum ku te hadêŋ Sabat nena yahadum anyô havuviŋ atu mavi. Êŋ ma hadum ba môlô osoŋ kambom! ");
INSERT INTO hot_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Odaŋô! Môlô osoŋ nena Mose hêv abô balabuŋ neŋgothe anyô kupik hadêŋ môlô. Ma doŋtom mi. Bumalô da êv. Ba intu ku êŋ habitak hadêŋ Sabat ma môlô othak osopa aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Abô balabuŋ neŋgothe kupik ma bêŋ ek abô balabuŋ Sabat. Ba intu môlô oŋgothe okna kupik hadêŋ Sabat ek môlô miŋ numbuliŋ Mose anêŋ abô balabuŋ atu ami. Ma nindum anyô mavi ma bêŋ ek neŋgothe kupik! Aêŋ ba yahatôm yandum anyô te liŋkupik lôkthô mavi êndêŋ Sabat. Ma môlô lemimmaniŋ eka? ");
INSERT INTO hot_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Noja auk thêthôŋ esak ku lo loŋ vêmam. Ma miŋ ôŋgô iyom ma nundum abô esak ami.” ");
INSERT INTO hot_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Êŋ ma avômalô Jelusalem doho enaŋ, “Ôpêntêk intu ba ŋê bêŋbêŋ idum ek nijik vônô, e? ");
INSERT INTO hot_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ôŋgô, yani hanaŋ abô hamiŋ piklêvôŋ ma ŋê bêŋbêŋ êyê iyom. Yakô ek thêlô neyala nena ôpêŋ ma Mesia la. ");
INSERT INTO hot_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma doŋtom ôpêntêk ma ayala anêŋ malak ôdôŋ. Ma Mesia atu halêm ma tem miŋ nayala anêŋ malak ôdôŋ ami.” ");
INSERT INTO hot_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yisu hamiŋ unyak matheŋ anêŋ piklêvôŋ ma halaŋô thêlôniŋ abô. Êŋ ma halam, “Môlô oyala ya lôk yenaŋ malak ôdôŋ e? Ôpatu ba hêv ya ba yahalêm ma Wapômbêŋ anôŋ atu ba môlô ôthôŋ yani paliŋ ba miŋ yahalêm hatôm yadanaŋ auk ami. ");
INSERT INTO hot_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yahalêm anêŋ yani atu ba hêv ya ba yahalêm. Ba intu yada yahayala yani.” ");
INSERT INTO hot_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Thêlô elaŋô abô êŋ ba idum ek nebaloŋ yani ma doŋtom anêŋ waklavôŋ miŋ hayô ami denaŋ. Ba intu miŋ hatôm anyôla embaloŋ yani ami. ");
INSERT INTO hot_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Avômalô nômbêŋ atu ba êmô ma êyê. Bêŋ anôŋ ma êvhaviŋ yani ba enaŋ thikuthik, “Anyôla tem miŋ embeŋ yam ba indum lavôŋiŋ bêŋ anôŋ êmôŋ ek ôpêntêk ami. Yakô yani ma Mesia atu la.” ");
INSERT INTO hot_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ŋê Palisi elaŋô thêlôniŋ abô. Êŋ ma thêlô lôk ŋê bêŋbêŋ êbôk da êv thêlôniŋ sôp bidoŋ ba i ek nebaloŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma Yisu hanaŋ, “Sawa bidoŋ ma tem yamô imbiŋ môlô vêm ma tem yambôna êndêŋ ôpatu ba hêv ya ba yahalêm. ");
INSERT INTO hot_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ma môlô tem nômbôlêm ya, ma doŋtom tem miŋ hatôm nôpôm ya ami lôk miŋ hatôm unu loŋ atu ba yahamô ami.” ");
INSERT INTO hot_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma Islael iniŋ ŋê bêŋbêŋ enaŋ hadêŋ thêlôda, “Tem ni êsê ba miŋ hatôm alalô napôm ami? Yani ni loŋ atu ba alalôaniŋ avômalô sêbôk ba ilupuniŋ i ba lêk êmô haviŋ ŋê daluk ek êndôŋ thêlô e? ");
INSERT INTO hot_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yani anêŋ auk aisê ba intu hanaŋ aêŋ, ‘Tem môlô nômbôlêm ya, ma doŋtom tem miŋ hatôm nôpôm ya ami lôk miŋ hatôm unu loŋ atu ba yahamô ami.’” ");
INSERT INTO hot_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Waklavôŋ bêŋ êŋ anêŋ daŋ ma bêŋ ek wak vi. Ma Yisu haviyô hamiŋ unyak matheŋ kapô ma halam, “Anyô te hathakmuniŋ ek inum ŋaŋ ma êlêm êndêŋ ya. ");
INSERT INTO hot_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Abô te hêk Wapômbêŋ anêŋ kapya ba hanaŋ, ‘Ŋaŋ atu ba hêv lôkmala tem endaŋviŋ êndôk avômalô takatu ba êvhaviŋ ya iniŋ kapôlôŋiŋ ba endaŋ endeba ni.’” ");
INSERT INTO hot_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisu hanaŋ abô êŋ hathak Lovak Matheŋ atu ba tem nêm êndêŋ avômalô takatu ba êvhaviŋ. Yani miŋ hama ba haviyô ami denaŋ ba intu Lovak Matheŋ miŋ halêm ami. ");
INSERT INTO hot_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Avômalô doho elaŋô Yisu anêŋ abô êŋ ma enaŋ, “Avanôŋ biŋ! Alalô ayabiŋ plopet te! Ôpêŋ êntêk êŋ!” ");
INSERT INTO hot_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Ma vi enaŋ, “Yani ma Mesia!” Ma vi enaŋ, “Mi. Wapômbêŋ anêŋ kapya hanaŋ, ‘Mesia ma tem imbitak anêŋ Devit anêŋ thalaleŋ anêŋ malak Betlehem.’ Ma doŋtom yani ma anyô Galili te.” ");
INSERT INTO hot_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aêŋ ba avômalô evak i vose hi ôdôŋ ju. ");
INSERT INTO hot_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Anyô doho leŋiŋ haviŋ nebaloŋ yani, ma doŋtom miŋ evaloŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Êŋ ma ŋê bêŋbêŋ iniŋ sôp bidoŋ êvôi ek ŋê bêŋbêŋ êbôk da lôk ŋê Palisi. Ma thêlô enaŋ, “Aisê ba môlô miŋ ovaloŋ yani ba owa ba ôlêm ami?” ");
INSERT INTO hot_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma sôp bidoŋ takêŋ enaŋ, “Anyô êŋ hanaŋ abô atu ba miŋ anyô la bôk hanaŋ ami.” ");
INSERT INTO hot_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma Palisi ethaŋ thêlô ba enaŋ, “Ôpêŋ bôk hasau avômalô bêŋ anôŋ. Ma lêk hasau môlô haviŋ e? ");
INSERT INTO hot_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ma alalôaniŋ ŋê bêŋbêŋ lôk Palisi takêntêk iniŋ anyô te hêvhaviŋ yani e? ");
INSERT INTO hot_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ma mi! Avômalô alonaŋ takêŋ êthôŋ Mose anêŋ abô balabuŋ paliŋ. Ba intu Wapômbêŋ tem injiki vônô!” ");
INSERT INTO hot_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimus, anyô Palisi atu sêbôk ba hi hadêŋ Yisu halaŋô abô takêŋ ma hanaŋ hadêŋ thêlô, ");
INSERT INTO hot_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Alalôaniŋ abô balabuŋ hanaŋ nena nijik anyô te vônô oyaŋ e? Mi. Nadaŋô anêŋ abô ba nayala nôm takatu ba hadum vêmam.” ");
INSERT INTO hot_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ma thêlô enaŋ viyaŋ, “O Galili hatôm ôpêŋ e? Osam abô atu ba hêk Wapômbêŋ anêŋ kapya katô ma tem oyala nena plopet te tem miŋ êlêm anêŋ Galili ami.” ");
INSERT INTO hot_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yôv ma avômalô i iniŋ unyak. ");
INSERT INTO hot_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ma Yisu hi Dum Oliv. ");
INSERT INTO hot_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Haviyô hayaŋ wak hapup ma Yisu havôhi unyak matheŋ anêŋ piklêvôŋ. Ma avômalô êlêm êdêŋ yani, ma yani halôk hamô ma hêv auk hadêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ŋê Palisi lôk ŋê lôkauk hathak abô balabuŋ êpôm avi sek te ma ewa yani ba êlêm êdô hamiŋ ŋê bêŋbêŋ maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma enaŋ hik Yisu liŋ, “Kêdôŋwaga, lêk yêlô ayê avi êntêk hêk haviŋ anyô lôk avi te. ");
INSERT INTO hot_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ma Mose anêŋ abô balabuŋ hanaŋ nena avi anêŋ aêŋ ma nijik vônô esak valu. Ba lemhabi aisê?” ");
INSERT INTO hot_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iniŋ auk êŋ ma hatôm gwasilim ek neja yani êmô ek nenaŋ yani bêŋ. Ma doŋtom Yisu hakôm ba hato abô hêk pik hathak baŋgwasiŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma enaŋ hik liŋ mathalaleŋ aleba yani haviyô hamiŋ ma hanaŋ hadêŋ thêlô, “Môlô te hayala nena miŋ hadum kambom te ami êŋ ma enja valu ba injik avi êntêk esak êmôŋ.” ");
INSERT INTO hot_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Êŋ ma hakôm ba hato abô hêk pik hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Thêlô elaŋô abô êŋ ma thêlô tomtom etak loŋ êŋ ba i. Ŋê iniŋ sondabêŋ bêŋ anôŋ êmôŋ ba i. Ma anyô vi eveŋ yam aleba Yisu lo avi êŋ iyom êmô. ");
INSERT INTO hot_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ma Yisu haviyô hamiŋ ma hanaŋ hadêŋ yani, “Livôŋ, ŋê takatu ma lêk i êsê ba mi? Ma opalê lêk hadum abô ek nijik o vônô?” ");
INSERT INTO hot_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma avi êŋ hanaŋ, “Anyô Bêŋ, anyô mi.” Êŋ ma Yisu hanaŋ, “Ya miŋ yahadum abô ek nijik o vônô ami. Nu! Ma otak anêm kambom êŋ!” ");
INSERT INTO hot_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yisu hanaŋ abô hadêŋ avômalô hathak loŋbô nena, “Ya ma hatôm avômalô pik iniŋ deda. Ôpatu ba hasopa ya tem enja deda atu ba nêm lôkmala anôŋ ma tem miŋ embeŋ loŋ momaŋiniŋ ami. Milôk.” ");
INSERT INTO hot_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma Palisi enaŋ, “Oda hovatho anêm abô loŋ ba abô êŋ ma miŋ abô avanôŋ ami.” ");
INSERT INTO hot_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ma hanaŋ viyaŋ, “Avanôŋ, lêk yahavatho yenaŋ abô loŋ. Ma yahayala loŋ atu ba yahamô ba yahalêm lôk loŋ atu ba tem yana. Ba intu yenaŋ abô ma avanôŋ. Ma doŋtom môlô ôthôŋ loŋ atu ba yahamô ba yahalêm lôk loŋ atu ba tem yana paliŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Môlô othak osopa avômalô pik iniŋ auk ba udum abô aêntêk, ‘anyô êntêk ma mavi’ mena ‘avi êntêk ma kambom’. Ma doŋtom yada miŋ aêŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yai lôk Wakamik atu ba hêv ya ba yahalêm, yai adum ku êŋ haviŋ i. Ma miŋ yahadum abô hathak yada yenaŋ auk ami ma mi. Ba intu yahadum ek yandum abô, ma yenaŋ abô ma avanôŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Môlôda unim abô balabuŋ hanaŋ aêntêk, ‘Anyô lokwaŋju idum abô ba enaŋ abô te iyom êŋ ma abô avanôŋ.’ ");
INSERT INTO hot_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ma yada yahavatho yenaŋ abô loŋ. Ma Wakamik atu ba hêv ya ba yahalêm intu havatho yenaŋ abô loŋ haviŋ.” ");
INSERT INTO hot_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Êŋ ma ŋê Palisi enaŋ hik yani liŋ, “Lemambô hamô êsê?” Ma Yisu hanaŋ viyaŋ, “Môlô oyala ya, êŋ ma tem noyala Wakamik imbiŋ. Ma doŋtom môlô ôthôŋ ya ba intu ôthôŋ Wakamik haviŋ.” ");
INSERT INTO hot_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisu hanaŋ abô takêŋ lôk hadôŋ avômalô hamô unyak matheŋ anêŋ piklêvôŋ hamô habobo loŋ êv da halôk. Ma anêŋ waklavôŋ miŋ lêk hayô ami denaŋ ba intu miŋ evaloŋ yani ami. ");
INSERT INTO hot_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yisu hanaŋ hathak loŋbô. “Tem yana. Ma môlô tem nômbôlêm ya ba unim kambom atu ôthôŋ ya paliŋ tem injik môlô vônô ba miŋ hatôm unu loŋ atu ba yaha ami.” ");
INSERT INTO hot_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Islael iniŋ ŋê bêŋbêŋ elaŋô abô êŋ ma thêlôda enaŋ hadêŋ i nena, “Aisê ka yani hanaŋ, ‘Môlô miŋ hatôm unu loŋ atu ba yaha ami’? Yakô yanida injik i vônô la?” ");
INSERT INTO hot_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma doŋtom Yisu hanaŋ hadêŋ thêlô, “Môlônim loŋ ma pik êntêk. Ma yenaŋ loŋ ma malak leŋ. Môlô ma avômalô pik ma doŋtom ya ma miŋ anyô pik êntêk ami. ");
INSERT INTO hot_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ma miŋ môlô ôêvhaviŋ abô êntêk ‘Yada Yahamô’ ami, êŋ ma tem noma. Ba intu bôk yahanaŋ hadêŋ môlô yôv nena môlô othak udum kambom lomaloma ba tem noma.” ");
INSERT INTO hot_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Thêlô enaŋ hik yani liŋ, “O ma opalê?” Ma Yisu hanaŋ, “Sêbôk ba môŋ anôŋ ma yahanaŋ hadêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yahatôm yanaŋ môlônim kambom lomaloma bêŋ. Ma doŋtom Wakamik atu ba hêv ya ba yahalêm, yani ma avanôŋ. Ba yahalaŋô anêŋ abô ba yahanaŋ hadêŋ avômalô pik.” ");
INSERT INTO hot_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Thêlô êthôŋ Yisu anêŋ abô atu ba hanaŋ hathak Lambô. ");
INSERT INTO hot_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aêŋ ba yani hanaŋ hadêŋ thêlô, “Wak te am ka tem môlô nôsôkwêŋ ya Anyô Anêŋ Nakaduŋ atu. Êŋ ma tem noyala nena Yada Yahamô ba yahanaŋ abô takatu ba Wakamik hik thô hadêŋ ya ma miŋ yahadum nômlate hatôm yada yenaŋ auk ami. ");
INSERT INTO hot_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma ôpatu ba hêv ya ba yahalêm intu hamô haviŋ ya. Yahadum nômkama hatôm anêŋ lahaviŋ. Aêŋ ba miŋ hatak ya ba yahamô daluk ami.” ");
INSERT INTO hot_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Avômalô bêŋ anôŋ elaŋô Yisu anêŋ abô êŋ ba êvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yisu hanaŋ hadêŋ avômalô Islael takatu ba êvhaviŋ yani nena, “Môlô ovaloŋ yenaŋ abô loŋ lôklokwaŋ, êŋ ma môlô ma yenaŋ ŋê ku anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma tem noyala nôm avanôŋ. Ma nôm avanôŋ êŋ tem epole yak atu ba havuvi môlô loŋ vê.” ");
INSERT INTO hot_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ma thêlô enaŋ viyaŋ, “Aisê! Yêlô ma Ablaham anêŋ limi ba anyôla ma miŋ yêlôaniŋ alaŋ ami. Ma honaŋ aêŋ eka?” ");
INSERT INTO hot_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ma Yisu hanaŋ viyaŋ, “Yanaŋ avanôŋ biŋ êndêŋ môlô nena ŋê takatu ba ethak idum kambom, êŋ ma hatôm yak havaloŋ i loŋ ba intu kambom habitak thêlôniŋ alaŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ma ŋê takatu ba ewa hêk loŋ buyaŋ ma iniŋ alaŋ hamô. Ba intu ŋê êŋ ma miŋ unyak alaŋ anêŋ thalaleŋ te ami. Nakaduŋ iyom intu unyak alaŋ anêŋ avômalô wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aêŋ ba ya Nakaduŋ yahapole môlônim yak vê, ma yak êŋ tem miŋ embaloŋ môlô loŋ esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yahayala nena môlô ma Ablaham anêŋ limi, ma doŋtom yenaŋ abô ma miŋ hamô môlônim kapôlômim ami. Ba intu udum ek uŋgwik ya vônô. ");
INSERT INTO hot_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yahathak yahanaŋ abô hathak nômkama takatu ba Wakamik hathak hik thô hadêŋ ya. Ma môlô othak udum hatôm atu ba olaŋô hêk lemimambô.” ");
INSERT INTO hot_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Thêlô enaŋ viyaŋ, “Ablaham ma yêlôaniŋ wakamik.” Ma Yisu hanaŋ hadêŋ thêlô, “Môlô ma Ablaham anêŋ limi, êŋ ma tem nosopa anêŋ bôk lo loŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Odaŋô! Wapômbêŋ hanaŋ abô avanôŋ hadêŋ ya ba yahanaŋ abô êŋ hadêŋ môlô. Ma lêk môlô udum ek uŋgwik ya vônô! Ablaham miŋ hadum aêŋ ami. Ma môlô aisê? ");
INSERT INTO hot_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Môlô osopa lemambô iyom.” Ma thêlô enaŋ, “Yêlô miŋ avômena loŋ sawa ami. Wapômbêŋ da intu yêlôaniŋ wakamik. Ma o?” ");
INSERT INTO hot_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ma Yisu hanaŋ, “Yahalêm anêŋ Wapômbêŋ ba êntêk yahamô. Yani hêv ya ba yahalêm ma miŋ yada yahalêm hathak yenaŋ auk ami. Ba intu Wapômbêŋ môlônim Lemambô, êŋ ma tem môlô lemimimbiŋ ya aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Môlô ôdô yenaŋ abô. Ba intu môlô ôthôŋ yenaŋ abô denaŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sêbôk ba môŋ anôŋ ma Sadaŋ anyô hik avômalô vônô mayaliv ba êntêk hadum aêŋ haveŋ denaŋ. Nôm avanôŋ te miŋ hamô haviŋ yani ami. Ba intu hadô nôm avanôŋ sapêŋ. Yani ma anyô abôyaŋ lôk abôyaŋ anêŋ alaŋ. Aêŋ ba abôyaŋ ma anêŋ abô anôŋ ba intu hanaŋ abôyaŋ iyom. Ma môlônim lemambô ma Sadaŋ êŋ ba anêŋ nali ma môlô ba intu osopa anêŋ lahaviŋ. ");
INSERT INTO hot_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ma ya anyô loŋ buyaŋ ba yahanaŋ abô avanôŋ. Ba intu môlô miŋ ôêvhaviŋ ya ami. ");
INSERT INTO hot_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Môlô te hatôm injik yenaŋ kambom thô e? Yakô yenaŋ abô ma avanôŋ ma aisê ba miŋ môlô ôêvhaviŋ ya ami? ");
INSERT INTO hot_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wapômbêŋ anêŋ nali ma ethak elaŋô anêŋ abô. Môlô ma miŋ Wapômbêŋ anêŋ nali ami. Ba intu miŋ olaŋô anêŋ abô ami.” ");
INSERT INTO hot_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Avômalô Islael enaŋ Yisu anêŋ abô viyaŋ, “Avanôŋ! O anyô Samalia te ba ŋgôk hamô haviŋ o!” ");
INSERT INTO hot_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ma Yisu hanaŋ, “Ŋgôk miŋ hamô haviŋ ya ami. Yahalovak Wakamik vibiŋ. Ma môlô miŋ olovak ya vibiŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Miŋ yada yahadum ek avômalô nebam ya ami. Mi. Anyô te intu hamô. Ba intu hadum ek avômalô nebam ya ma tem endaŋô avômalô iniŋ abô. ");
INSERT INTO hot_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yanaŋ avanôŋ biŋ êndêŋ môlô. Ôpatu ba hasopa yenaŋ abô ma tem miŋ ema ami. Mi anôŋ.” ");
INSERT INTO hot_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Avômalô Islael enaŋ, “Yêlô lêk ayala nena ŋgôk hamô haviŋ o. Ablaham lôk plopet sapêŋ bôk ema yôv. Ma doŋtom oda honaŋ, ‘Ôpatu ba hasopa yenaŋ abô ma tem miŋ ema ami.’ ");
INSERT INTO hot_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","O bêŋ ek yêlôaniŋ bumalô Ablaham, e? Yani bôk hama yôv! Ma plopet sapêŋ bôk ema haviŋ. Ma hosoŋ nena o anyô bêŋ e?” ");
INSERT INTO hot_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Êŋ ma Yisu hanaŋ, “Yahabam yada, êŋ ma nôm oyaŋ. Wakamik atu ba môlô olam nena unim Wapômbêŋ, yani êŋ intu habam ya. ");
INSERT INTO hot_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ma doŋtom môlô miŋ oyala yani ami ma mi. Ya ma yahayala yani katô ba yahanaŋ nena yahathôŋ yani paliŋ, êŋ ma tem yambitak anyô abôyaŋ êtôm môlô. Aêŋ ba yahayala yani ba intu yahasopa anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Môlônim bumalô Ablaham bôk hayala nena tem yalêm ba lamavi anôŋ. Ma hayê yenaŋ waklavôŋ êŋ ma hadum yani lamavi anêŋ dôêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Avômalô Islael enaŋ hadêŋ Yisu, “Anêm sondabêŋ miŋ hatôm 50 ami denaŋ ma honaŋ nena bôk hôyê Ablaham. Hosau!” ");
INSERT INTO hot_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ma Yisu hanaŋ, “Yanaŋ avanôŋ biŋ êndêŋ môlô. Ablaham miŋ habitak ami denaŋ, ma yada bôk yahamô yôv.” ");
INSERT INTO hot_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Thêlô elaŋô abô êŋ ma ewa valu ek nijik yani esak. Ma doŋtom Yisu hêv i vê menaŋna hêk unyak matheŋ anêŋ piklêvôŋ ba hi. ");
INSERT INTO hot_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yisu haveŋ ba hi ma hayê anyô mapusip te. Sêbôk ba talêbô havathu ma mapusip. ");
INSERT INTO hot_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma anêŋ ŋê ku enaŋ hik yani liŋ, “Kêdôŋwaga, opalê intu hadum kambom ba talêbô hawa ôpêntêk ba mapusip? Ôpêŋ da anêŋ kambom mena lambô lo talêbô iniŋ e?” ");
INSERT INTO hot_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma Yisu hanaŋ, “Wapômbêŋ hadum ku êŋ hathak ôpêŋ ek avômalô pik nêgê. Ma miŋ ôpêŋ mena lambô lo talêbô iniŋ kambom ami. Mi. ");
INSERT INTO hot_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Deda hêk denaŋ ba alalô nandum ôpatu ba hêv ya ba yahalêm anêŋ ku. Bôlôvôŋ tem êyô ba miŋ hatôm anyô nindum ku ami. ");
INSERT INTO hot_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yahamô pik ma ya ma avômalô pik iniŋ deda.” ");
INSERT INTO hot_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Êŋ ma yani hasôwapôk hathak pik ma hayelaŋ aleba habitak malim. Ma hawa ba hatak hathak anyô mapusip êŋ madaluk. ");
INSERT INTO hot_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma hanaŋ hadêŋ yani, “Nu usik o êndôk kasuk Siloam.” (Athêŋ Siloam êŋ anêŋ ôdôŋ nena, “Êv yani ba hi.”) Ma ôpêŋ hi hathik i. Ma hale halêm hathak loŋbô ma lêk hayê tak mavi. ");
INSERT INTO hot_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yanida anêŋ avômalô lôk avômalô takatu ba bôk eyala yani êyê ôpêŋ ma enaŋ, “Êntêk ma anyô petenak sêbôk e?” ");
INSERT INTO hot_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ma doho enaŋ, “Ôpêŋ intu.” Ma vi enaŋ, “Mi, anyô yaŋ ba hatôm ôpêŋ.” Ma doŋtom ôpêŋda hanaŋ, “Ya êŋ êntêk.” ");
INSERT INTO hot_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma thêlô enaŋ hik yani liŋ, “Aisê ba malem daluk hakyav?” ");
INSERT INTO hot_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma hanaŋ, “Ôpatu ba elam nena Yisu, hayelaŋ pik haviŋ wapôk aleba hatôm pik malim ma hatak hathak yamaleŋ. Yôv ma hanaŋ nena, ‘Nu kasuk Siloam ma usik o.’ Êŋ ma yaha yahathik ma yamaleŋ hakyav.” ");
INSERT INTO hot_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma thêlô enaŋ hik yani liŋ, “Ôpêŋ hamô êsê?” Ma yani hanaŋ, “Yahathôŋ paliŋ.” ");
INSERT INTO hot_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Êŋ ma thêlô ewa anyô madaluk pusip atu ba lêk mavi hi ek Palisi. ");
INSERT INTO hot_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lêk Sabat ma Yisu hadum ku êŋ. ");
INSERT INTO hot_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Aêŋ ba Palisi enaŋ hik yani liŋ hatôm atu ba avômalô enaŋ hik yani liŋ, “Malem hakyav aisê?” Ma yani hanaŋ, “Ôpêŋ hatak pik malim hathak yamaleŋ ma yahathik ma lêk yahayê tak.” ");
INSERT INTO hot_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma Palisi doho enaŋ, “Anyô êŋ miŋ halêm anêŋ Wapômbêŋ ami ek malê nena habuliŋ Sabat.” Ma doŋtom vi enaŋ, “Anyô kambom hatôm indum lavôŋiŋ anêŋ aêŋ e?” Ma thêlô evak i vose hi ôdôŋ ju. ");
INSERT INTO hot_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yôv ma thêlô enaŋ hik anyô madaluk pusip êŋ liŋ hathak loŋbô, “Yani hadum anêm malem ba hakyav. Ma honaŋ aisê hathak yani?” Ma ôpêŋ hanaŋ, “Yani ma plopet te.” ");
INSERT INTO hot_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma Islael iniŋ ŋê bêŋbêŋ miŋ êvhaviŋ nena sêbôk ma yani mapusip ma doŋtom lêk habitak mavi ami. Ba intu elam lambô lo talêbô ba êlêm. ");
INSERT INTO hot_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma enaŋ hik thai liŋ, “Mamunim nalum êntêk e? Talêbô bôk havathu ba mapusip e? Aisê ka lêk hayê tak?” ");
INSERT INTO hot_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma talêbô lo lambô enaŋ, “Avanôŋ! Ôpêntêk ma yaianiŋ okna. Talêbô hawa ma bôk mapusip yôv. ");
INSERT INTO hot_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma doŋtom madaluk hakyav lôk opalê hadum yani madaluk mavi, êŋ ma yai athôŋ paliŋ. Yani bôk anyô muk yôv ba nonaŋ injik yanida liŋ.” ");
INSERT INTO hot_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Islael iniŋ ŋê bêŋbêŋ bôk enaŋ nena anyôla hanaŋ nena Yisu ma Mesia, êŋ ma tem nênêm ôpêŋ vê. Aêŋ ba intu thai êkô ");
INSERT INTO hot_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ba enaŋ, “Yani bôk anyô muk yôv ba nonaŋ injik yanida liŋ.” ");
INSERT INTO hot_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yôv ma elam ôpatu ba madaluk mavi hathak loŋbô ma enaŋ, “Ondam Wapômbêŋ anêŋ athêŋ ma onaŋ abô avanôŋ! Ôpêŋ ma anyô kambom! Aêŋ e?” ");
INSERT INTO hot_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma yani hanaŋ, “Injo! Ôpêŋ anyô mavi mena anyô kambom la! Nôm atu ba yahayala katô, sêbôk ma yamaleŋ pusip ma lêk yamaleŋ hakyav!” ");
INSERT INTO hot_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma enaŋ hik yani liŋ, “Yani hadum malê hadêŋ o ba malem hakyav?” ");
INSERT INTO hot_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma yani hanaŋ, “Lêk yahanaŋ yôv hadêŋ môlô, ma môlô lemimôndôŋ kôtôŋ. Môlô udum ek nodaŋô esak loŋbô ek numbitak anêŋ ŋê ku e?” ");
INSERT INTO hot_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Êŋ ma Palisi enaŋ abôma lôk ethaŋ yani nena, “Oda intu hosopa ôpêŋ! Ma yêlô ma asopa Mose iyom! ");
INSERT INTO hot_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Alalô ayala nena Wapômbêŋ bôk hanaŋ abô hadêŋ Mose. Ma doŋtom ôpêŋ anêŋ loŋ ma yêlô athôŋ paliŋ.” ");
INSERT INTO hot_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma ôpêŋ hanaŋ, “Aêŋ e? Môlô ôthôŋ ôpêŋ anêŋ loŋ, e? Odaŋô! Yani hadum yamaleŋ mavi. ");
INSERT INTO hot_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wapômbêŋ hathak halaŋô ŋê idum kambom iniŋ abô e? Mi. Halaŋô ŋê thêthôŋ atu ba esopa anêŋ abô iyom. ");
INSERT INTO hot_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sêbôk aleba lêk ma miŋ ayê anyô te hadum ba anyô mapusip te habitak mavi ami. ");
INSERT INTO hot_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wapômbêŋ miŋ hêv ôpêŋ ba halêm ami, êŋ ma miŋ hatôm indum nômlate ami.” ");
INSERT INTO hot_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Palisi elaŋô aêŋ ba enaŋ, “Waklavôŋ lemtambô havathu o, ma hubup lôk kambom ma aisê ka hudum ek ôndôŋ yêlô? Dô!” Êŋ ma ilupuniŋ ôpêŋ. ");
INSERT INTO hot_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yisu halaŋô nena ilupuniŋ ôpêŋ ba intu hi ek êmbôlêm yani. Hapôm ma hanaŋ, “Hôêvhaviŋ Anyô Anêŋ Nakaduŋ atu e?” ");
INSERT INTO hot_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma yani hanaŋ, “Anyô bêŋ, anyô êŋ ma opalê? Onaŋ êndêŋ ya ek yanêmimbiŋ yani.” ");
INSERT INTO hot_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma Yisu hanaŋ hadêŋ yani, “Bôk hôyê yani yôv. Ondaŋô! Yani êŋ êntêk ba hanaŋ abô haviŋ o.” ");
INSERT INTO hot_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma ôpêŋ hanaŋ, “Anyô Bêŋ, yahêvhaviŋ.” Êŋ ma yani halek vadôŋ lêlô hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ma Yisu hanaŋ, “Yahalêm pik ek yanaŋ avômalô iniŋ kambom bêŋ ek ŋê maleŋiŋ pusip tem nêgê tak ma ŋê êyê tak tem maleŋiŋ pusip.” ");
INSERT INTO hot_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ma Palisi doho êmô ba elaŋô abô êŋ. Ma enaŋ hik yani liŋ, “Aisê! Yêlô ma ŋê maleŋiŋ pusip haviŋ e?” ");
INSERT INTO hot_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma Yisu hanaŋ, “Maleŋiŋ pusip, êŋ ma kambom mi. Ma doŋtom môlô othak onaŋ, ‘Yêlô athak ayê tak.’ Ba intu môlônim kambom havaloŋ môlô loŋ denaŋ.” ");
INSERT INTO hot_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yisu hanaŋ, “Yanaŋ avanôŋ biŋ êndêŋ môlô. Ôpatu ba hasôv lôk kisi ma miŋ habitak hayô kola abôlêk ek enja bôksipsip ami, yani ma anyô vani lôk anyô kambom. ");
INSERT INTO hot_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma anyô hathak habitak hayô kola abôlêk ba hi, intu boksipsip iniŋ alaŋ. ");
INSERT INTO hot_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Anyô hayabiŋ kola halate abôlêk vê ek boksipsip alaŋ enja anêŋ bok. Halam tomtom iniŋ athêŋ ma elaŋô ba halom i hi yaiŋ. ");
INSERT INTO hot_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yani hawa anêŋ boksipsip sapêŋ ele yaiŋ yôv ma hamôŋ ma boksipsip eveŋ yam. Boksipsip eyala alaŋsi leŋselo ba intu esopa i. ");
INSERT INTO hot_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma anyô yaŋ ma êthôŋ ôpêŋ laselo paliŋ ba intu êsôv ma miŋ ethak esopa ami.” ");
INSERT INTO hot_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisu havuŋ abô ba miŋ eyala anêŋ ôdôŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aêŋ ba Yisu hanaŋ hathak loŋbô nena, “Avanôŋ! Yanaŋ êndêŋ môlô nena yada ma hatôm kola abôlêk ek boksipsip nêyô kola kapô. ");
INSERT INTO hot_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Avômalô sapêŋ atu ba êmôŋ ek ya ma ŋê vani lôk ŋê kambom. Ma doŋtom boksipsip miŋ elaŋô thêlô leŋiŋselo ami. ");
INSERT INTO hot_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yada ma kola abôlêk. Anyô te halêm hadêŋ ya ba hayô kola kapô ma Wapômbêŋ tem nêm yani bulubiŋ. Ôpêŋ tem ni ba êlêm êmô kola kapô ma tem êpôm nôm mavi ek enjaŋ. ");
INSERT INTO hot_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Anyô vani halêm ek enja boksipsip vani lôk injik i vônô lôk imbuliŋ i. Ma doŋtom yahalêm ek neja lôkmala atu ba êmô thêlô kapôlôŋiŋ siŋ. ");
INSERT INTO hot_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ya ma boksipsip iniŋ alaŋ mavi ba yahatak yenaŋ lôkmala ek nêm boksipsip sa. ");
INSERT INTO hot_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Alaŋ anêŋ ŋê ku ma miŋ boksipsip iniŋ alaŋ ami. Ba êyê avuŋ yatap te halêm ma tem netak boksipsip nêmô ma nêsôv ba ini. Ma avuŋ yatap tem indupuniŋ i ba nêsôv mayaliv. ");
INSERT INTO hot_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Alaŋ anêŋ ŋê ku ma leŋiŋhaviŋ vuli iyom ma miŋ leŋiŋhiki hathak boksipsip ami. Ba intu thêlô êsôv ba i. ");
INSERT INTO hot_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Yada iyom intu boksipsip iniŋ alaŋ mavi. Yahayala yenaŋ boksipsip ma thêlô eyala ya ");
INSERT INTO hot_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","hatôm atu ba Wakamik hayala ya ma yahayala Wakamik. Ma yahatak yenaŋ lôkmala ek nêm boksipsip sa. ");
INSERT INTO hot_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yenaŋ boksipsip doho miŋ êmô kola êntêk kapô ami. Ma yahalam i ma tem nedaŋô yaleŋselo ma tem yandom i ba ni nêyô kola kapô ek nimbitak ôdôŋ doŋtom lôk alaŋ doŋtom iyom. ");
INSERT INTO hot_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Wakamik lahaviŋ ya ba intu yaleŋhaviŋ yani ek yatak yenaŋ lôkmala ma tem yanja esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Anyôla miŋ hatôm nêm yenaŋ lôkmala vê ami. Mi. Yada yenaŋ yaleŋhaviŋ ek yatak yenaŋ lôkmala. Yahatôm yatak ma yahatôm yanja esak loŋbô. Wakamik hanaŋ ek yandum aêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Avômalô Islael elaŋô abô êŋ ma evak i vose hi ôdôŋ ju hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ma bêŋ anôŋ enaŋ nena, “Ŋgôk kambom hamô haviŋ yani ba anêŋ auk molo. Aisê ka môlô olaŋô anêŋ abô?” ");
INSERT INTO hot_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma doŋtom vi enaŋ, “Mi! Anyô lôk ŋgôk te miŋ hatôm enaŋ abô takêŋ ami. Ma ŋgôk kambom miŋ hatôm indum maleŋ pusip mavi ami. Mi.” ");
INSERT INTO hot_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Waklavôŋ Êv Mek Ek Unyak Matheŋ hayô ba avômalô Islael i Jelusalem ek nêgê. Lêk ma beleŋ simbak ");
INSERT INTO hot_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ba Yisu haveŋ unyak matheŋ anêŋ kapo daŋ te ba elam nena Solomon Anêŋ Kapo Daŋ. ");
INSERT INTO hot_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ma avômalô Islael ekalabu yani siŋ ma enaŋ, “Huvuŋ abô ba aŋgê ka tem onaŋ nena o ma opalê? O ma Mesia atu e? Êŋ ma onaŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ma Yisu hanaŋ viyaŋ nena, “Bôk yahanaŋ yôv hadêŋ môlô lôk lavôŋiŋ takatu ba yahadum hathak Wakamik anêŋ athêŋ hik ya thô hadêŋ môlô. Ma miŋ ôêvhaviŋ ya ami. ");
INSERT INTO hot_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ek malê nena môlô ma miŋ yenaŋ boksipsip ami ba intu miŋ ôêvhaviŋ ya ami. ");
INSERT INTO hot_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yenaŋ boksipsip ma ethak elaŋô yaleŋselo. Yahayala thêlô ma thêlô ethak esopa ya. ");
INSERT INTO hot_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yahêv lôkmala atu ba tem nêmô êtôm wak nômbêŋ intu sapêŋ hadêŋ yenaŋ avômalô ek miŋ nema ami lôk miŋ hatôm anyôla enja i vê ênjêk yabaheŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wakamik hêv i hadêŋ ya, ma yani ma bêŋ ek nômkama sapêŋ ba miŋ hatôm anyôla nêm thêlô vê ênjêk Wakamik baŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yai lôk Wakamik ma doŋtom iyom.” ");
INSERT INTO hot_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Avômalô Islael ewa valu hathak loŋbô ba idum ek nijik Yisu vônô. ");
INSERT INTO hot_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma Yisu hanaŋ hadêŋ thêlô, “Môlô bôk ôyê lavôŋiŋ mavi bêŋ anôŋ atu ba yahadum yôv. Ku êŋ ma Wakamik hêv hadêŋ ya. Ma lavôŋiŋ alisê intu yenaŋ kambom ba udum ek uŋgwik ya esak valu?” ");
INSERT INTO hot_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma thêlô enaŋ viyaŋ, “Yêlô adum ek naŋgik o esak valu ek malê nena honaŋ abôma hathak Wapômbêŋ nena oda ma Wapômbêŋ. Ma doŋtom o ma anyô pik iyom. Ma miŋ yêlô leŋiŋhabi lavôŋiŋ la ami. Mi.” ");
INSERT INTO hot_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ma Yisu hanaŋ, “Môlô da unim abô balabuŋ te hanaŋ nena, ‘Wapômbêŋ da halam môlô nena wapômbêŋ.’ ");
INSERT INTO hot_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Odaŋô! Abô atu ba hêk Wapômbêŋ anêŋ kapya ma avanôŋ ba bôk hêv hadêŋ avômalô takatu ba halam i nena, ‘wapômbêŋ’. ");
INSERT INTO hot_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma hatak ya hatôm anêŋ anyô ek yalêm pik êntêk ba intu ya ma wapômbêŋ hatôm môlô. Ma doŋtom ya ma nakaduŋ ba intu ya ma bêŋ ek môlô. Aêŋ ba yahanaŋ nena, ‘Ya ma Wapômbêŋ Nakaduŋ’ ma yahanaŋ abôma hathak Wapômbêŋ aisê ba intu onaŋ ya bêŋ? ");
INSERT INTO hot_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yahadum ku takatu ba Wakamik hadum ba intu nônêmimbiŋ ya. ");
INSERT INTO hot_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma ôdô nônêmimbiŋ ya, êŋ ma nônêmimbiŋ lavôŋiŋ iyom. Nônêmimbiŋ yenaŋ ku takatu ek êndôŋ môlô ek noyala katô nena Wakamik hamô ya kapô ma yahamô Wakamik kapô.” ");
INSERT INTO hot_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Êŋ ma idum ek nebaloŋ yani esak loŋbô. Ma doŋtom hêv i vê hêk thêlô ba hi. ");
INSERT INTO hot_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma habup hayô ŋaŋ Jolodaŋ ba hi ma hamô loŋ sêbôk ba Jon hathik avômalô halôk ");
INSERT INTO hot_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ma avômalô bêŋ anôŋ i hadêŋ yani ma enaŋ, “Avanôŋ! Jon miŋ hadum lavôŋiŋ te ami. Ma doŋtom abô takatu ba yani hanaŋ hathak ôpêntêk ma avanôŋ.” ");
INSERT INTO hot_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma avômalô loŋ êŋ bêŋ anôŋ êvhaviŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Anyô te hapôm lijiŋ ba anêŋ athêŋ nena Lasalus. Yani ma anyô Betani. Betani êŋ ma avi loyaŋ Malia lo Mata iniŋ malak ôdôŋ. ");
INSERT INTO hot_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malia êŋ atu ba yani haŋgasô nôm ôv mavi hayô hamô Anyô Bêŋ va ma haya lopali vê hathak wakadôk ŋauŋ. Anyô lijiŋ êŋ ma Lasalus, Malia atu limalô. ");
INSERT INTO hot_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ma avi lo yaŋ êv abô hadêŋ Yisu nena, “Anyô bêŋ, anêm anyô môlô hapôm lijiŋ.” ");
INSERT INTO hot_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yani halaŋô abô êŋ ma hanaŋ nena, “Lijiŋ êŋ anêŋ anôŋ ma miŋ ŋama ami. Lijiŋ êŋ habitak ek injik Wapômbêŋ anêŋ lôkmaŋgiŋ thô. Ma lôkmaŋgiŋ êŋ tem injik ya Nakaduŋ anêŋ lôkmaŋgiŋ thô aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yani lahaviŋ Mata lo yaŋ Malia ma Lasalus bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ma doŋtom yani halaŋô nena Lasalus hapôm lijiŋ ma miŋ hi ketheŋ ami ma hamô loŋ êŋ hatôm wak ju. ");
INSERT INTO hot_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Êŋ ma hanaŋ hadêŋ ŋê ku, “Alalô nabôana Judia.” ");
INSERT INTO hot_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma thêlô enaŋ, “Kêdôŋwaga, loŋ êŋ ma waksêŋyôk ma avômalô Islael idum ek nijik o vônô esak valu! Ma hudum ek ômbônu eka?” ");
INSERT INTO hot_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma hanaŋ, “Wakma laumiŋ ba lahavuju hadêŋ wak te, aêŋ e? Ma pik êntêk êŋ anêŋ deda habi ba anyô êyê tak. Ma tem miŋ nêndôk ami. ");
INSERT INTO hot_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma bôlôvôŋ ma deda mi ba anyô eveŋ ma tem nêndôk.” ");
INSERT INTO hot_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Vêm ma hanaŋ, “Alalôaniŋ anyô môlô Lasalus hêk sôm ba tem yana ek yaŋgik liŋ.” ");
INSERT INTO hot_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma ŋê ku enaŋ, “Anyô Bêŋ, dô! Hêk sôm ek lijiŋ etak yani ba imbitak mavi.” ");
INSERT INTO hot_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Thêlô esoŋ nena hanaŋ hathak Lasalus hêk sôm la. Ma doŋtom mi. Hanaŋ hathak Lasalus anêŋ ŋama. ");
INSERT INTO hot_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ba intu hanaŋ bêŋ nena, “Lasalus lêk hama ");
INSERT INTO hot_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ba miŋ yahamô haviŋ ami ba intu yaleŋmavi. Ma tem yanêm môlô sa ek nônêmimbiŋ. Alôana i!” ");
INSERT INTO hot_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Êŋ ma Tomas anêŋ athêŋ yaŋ nena Didimus hanaŋ hadêŋ ŋê ku vi nena, “Alôana imbiŋ yani ek nijik alalô vônô imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yisu thêlô êyô Betani ma yani halaŋô nena Lasalus bôk hêk siô hatôm wak ayova. ");
INSERT INTO hot_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Loŋ êŋ hamô habobo Jelusalem ba hatôm kilomita lô iyom. ");
INSERT INTO hot_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma avômalô Islael bêŋ anôŋ êlêm ek nênêm Malia lo Mata thêvô. ");
INSERT INTO hot_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata halaŋô nena Yisu lêk halêm êŋ ma hi ek ênjê. Malia ma hamô unyak. ");
INSERT INTO hot_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ma Mata hanaŋ, “Anyô Bêŋ, hômô loŋ êntêk ma yenaŋ livôŋ tem miŋ ema ami. ");
INSERT INTO hot_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma doŋtom yahayala nena malêla takatu ba honaŋ hik Wapômbêŋ liŋ, êŋ ma tem yani indum.” ");
INSERT INTO hot_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma Yisu hanaŋ, “Livôm tem imbiyô esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma Mata hanaŋ, “Avanôŋ! Pik lo leŋ anêŋ daŋ ba avômalô iviyô ma tem yani imbiyô imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma hanaŋ, “Yada ma anyô yahik avômalô liŋ lôk yahêv lôkmala hadêŋ i. Ma ôpatu ba hama ma doŋtom hêvhaviŋ ya, ôpêŋ tem êmô lôkmala. ");
INSERT INTO hot_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Avômalô takatu ba êvhaviŋ intu ewa lôkmala anôŋ ma tem miŋ nema ami. Hôêvhaviŋ abô êntêk mena mi e?” ");
INSERT INTO hot_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma Mata hanaŋ, “Anyô Bêŋ! Avanôŋ! Yahêvhaviŋ nena o ma Mesia lôk Wapômbêŋ Nakaduŋ atu ba bôk hanaŋ nena tem êlêm pik êntêk.” ");
INSERT INTO hot_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Êŋ ma Mata hi hanaŋ yaôna hadêŋ Malia, “Kêdôŋwaga hayô ba halam o.” ");
INSERT INTO hot_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malia halaŋô abô êŋ ma haviyô ketheŋ ba hi ek ênjê. ");
INSERT INTO hot_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yisu hamô loŋ atu ba Mata hapôm yani halôk ma miŋ hayô malaklêvôŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Avômalô Islael takatu ba êmô unyak haviŋ Malia ek nênêm yani thêvô êyê haviyô ketheŋ ba hi yaiŋ ma esopa ba i. Thêlô esoŋ nena hi ek endaŋ embeŋ siô la. ");
INSERT INTO hot_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Malia hi hayô loŋ atu ba Yisu hamô ma hayê yani. Ma halek vadôŋ lêlô habobo Yisu valuvi ma hanaŋ, “Anyô Bêŋ, hômô loŋ êntêk ma tem miŋ livôŋ ema ami.” ");
INSERT INTO hot_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yani halaŋô Malia lôk avômalô iniŋ asêŋ malêŋ ba lamalaiŋ lôk lahiki bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma hanaŋ, “Môlô ôdô yani hêk êsê?” Ma thêlô enaŋ, “Anyô Bêŋ, ôlêm nôŋgô.” ");
INSERT INTO hot_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Enaŋ aêŋ ma halaŋ. ");
INSERT INTO hot_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma avômalô Islael takêŋ enaŋ, “Alikak! Yani lahaviŋ ôpêntêk bêŋ anôŋ.” ");
INSERT INTO hot_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma doŋtom doho enaŋ, “Anyô êŋ hadum ba ŋê maleŋiŋ pusip êyê tak. Ma tem indum aêŋ iyom êndêŋ ôpêntêk ba miŋ hatôm ema ami.” ");
INSERT INTO hot_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yisu lamalaiŋ ba lahiki bêŋ anôŋ hathak loŋbô aleba hi hayô siô. Siô êŋ ma valu abyaŋ te ba epesaŋ hêk dumlolê. Ma valu te hamô lôv abôlêk siŋ. ");
INSERT INTO hot_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma hanaŋ, “Nônêm valu vê!” Mata, anyô ŋama êŋ anêŋ livavi, hanaŋ, “Anyô Bêŋ, bôk hêk siô hatôm wak ayova ba kupik bôk ôvpalê.” ");
INSERT INTO hot_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma hanaŋ, “Lêk yahanaŋ hadêŋ o yôv! Hôêvhaviŋ, ma tem nôŋgô Wapômbêŋ anêŋ lôkmaŋgiŋ.” ");
INSERT INTO hot_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Êŋ ma thêlô êv valu vê. Ma hayê leŋ ma hanaŋ, “Wakamik! Hothak holaŋô yenaŋ abô ba yaleŋmavi. ");
INSERT INTO hot_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yada yahayala yôv nena wak nômbêŋ intu ma holaŋô yenaŋ abô. Ma doŋtom yahanaŋ abô êntêk ek nêm avômalô takêntêk sa ek nênêmimbiŋ nena hôêv ya ba yahalêm.” ");
INSERT INTO hot_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Êŋ ma halam lôklala nena, “Lasalus, ôlêm yaiŋ!” ");
INSERT INTO hot_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ma hatak siô ba hale yaiŋ. Ivuvi va lo baŋ hathak sôp seleŋ ma thohavloma ma ivuliv hathak sôp. Ma Yisu hanaŋ hadêŋ thêlô, “Nopole sôp vê ek ni.” ");
INSERT INTO hot_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ma avômalô Islael takatu ba elaŋ haviŋ Malia êyê nôm atu ba Yisu hadum ba bêŋ anôŋ êvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma doŋtom vi i hadêŋ ŋê Palisi ma enaŋ hathak nôm takatu ba yani hadum. ");
INSERT INTO hot_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Êŋ ma ŋê bêŋbêŋ êbôk da lôk ŋê Palisi takatu ba elam nena Sanhedlin elam sa te ba enaŋ nena, “Ôŋgô! Anyô êntêk hadum lavôŋiŋ bêŋ anôŋ. Ma alalô ayê loŋ eka? ");
INSERT INTO hot_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Atak yani ba hadum ku êŋ, ma tem avômalô sapêŋ nênêmimbiŋ. Êŋ ma Lom tem nêlêm nimbuliŋ alalôaniŋ unyak matheŋ lôk avômalô sapêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma thêlôniŋ anyô te anêŋ athêŋ nena Kaiapas. Ma sondabêŋ êŋ ma yani hatôm anyô bêŋ habôk da ba hanaŋ hadêŋ thêlô nena, “Môlô molo e? ");
INSERT INTO hot_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Odaŋô! Môlô ôthôŋ auk êntêk paliŋ e? Anyô te hama êŋ ma nôm yaôna. Ma avômalô Islael sapêŋ ema êŋ ma malaiŋ bêŋ. Aêŋ ba mavi ek anyô te iyom ema ek nêm avômalô bêŋ anôŋ sa.” ");
INSERT INTO hot_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Sondabêŋ êŋ ma Kaiapas hatôm anyô bêŋ habôk da. Ba intu hanaŋ abô loŋ kapô atu ba tem injik anôŋ nena Yisu tem ema ek nêm avômalô Islael sa lôk isup Wapômbêŋ anêŋ nali takatu ba êmô mayaliv esak doŋtom ek malê nena miŋ hama ek nêm avômalô Islael iyom sa ami. Ma Kaiapas miŋ hanaŋ abô êŋ hatôm yanida anêŋ auk ami. ");
INSERT INTO hot_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ŋê bêŋbêŋ elaŋô Kaiapas anêŋ abô ma êbôlêm loŋôndê ek nijik Yisu vônô. ");
INSERT INTO hot_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Êŋ ma Yisu hatak avômalô Islael ma hi Eplaim atu hamô habobo loŋ thiliv ek êmô imbiŋ anêŋ ŋê ku doho ba intu miŋ haveŋ Islael malêvôŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Avômalô Islael iniŋ waklavôŋ Hale ba Hi habobo. Ma avômalô lomalak bêŋ anôŋ i daku Jelusalem ek nêpôpêk i ek nêgê waklavôŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ma thêlô imiŋ unyak matheŋ anêŋ piklêvôŋ ek nêmbôlêm Yisu. Ma thêlôda enaŋ hadêŋ i, “Môlô lemhabi aisê? Yani tem êlêm ênjê waklavôŋ êntêk imbiŋ mena mi e?” ");
INSERT INTO hot_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ma doŋtom ŋê bêŋbêŋ êbôk da lôk ŋê Palisi enaŋ lôklokwaŋ hadêŋ avômalô, “Anyô te hayê nena Yisu hamô êsê êŋ ma enaŋ bêŋ ek nebaloŋ yani.” ");
INSERT INTO hot_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wak baheŋvi ba lahavute hêk denaŋ ek êyô waklavôŋ Hale ba Hi. Ma Yisu hi Betani, Lasalus anêŋ loŋ, ôpatu ba yani hik liŋ hathak loŋbô hêk ŋama. ");
INSERT INTO hot_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Êŋ ma thêlô eŋgabôm nôm leŋiŋmavi ek yani. Mata hathô nôm ma Lasalus hamô haviŋ ŋê takatu ba eyaŋ nôm haviŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma Malia hawa kolopak nôm ôv mavi hamô kapô ba anêŋ vuli ma bêŋ anôŋ ba haŋgasô hayô hamô Yisu va kapô luvi. Ma hathav lôthôk vê hathak yanida wakadôk ŋauŋ. Ma nôm ôv mavi atu anêŋ ôv haveŋ unyak kapô êŋ sapêŋ. ");
INSERT INTO hot_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma Yisu da anêŋ ŋê ku te elam nena Judas Iskaliot ôpatu ba tem enaŋ yani bêŋ hayê ba hanaŋ, ");
INSERT INTO hot_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nôm ôv mavi êŋ ma anyô hadum ku sondabêŋ daluk te ek nêm vuli! Ma lêk eŋgasô oyaŋ iyom! Nanêm nôm êŋ ek anyô vi nênêm vuli ba naja valuseleŋ ek nanêm êndêŋ avômalô siv.” ");
INSERT INTO hot_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas anêŋ ku hayabiŋ avômalô êvhaviŋ iniŋ valuseleŋ ma doŋtom anyô vani te ba hathak hawa vi vani hatôm yanida anêŋ lahaviŋ. Ba intu hanaŋ aêŋ. Ma miŋ lahiki hathak avômalô siv ba hanaŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ma Yisu hanaŋ, “Notak yani. Avi êŋ hapôpêk yenaŋ ŋama. ");
INSERT INTO hot_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Avômalô siv tem nêmô imbiŋ môlô êtôm wak nômbêŋ intu sapêŋ. Ma doŋtom tem miŋ yamô imbiŋ môlô sawa daim ami.” ");
INSERT INTO hot_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Avômalô Islael bêŋ anôŋ elaŋô nena Yisu hamô Betani. Êŋ ma i ek nêgê yani. Thêlô miŋ i ek nêgê yani iyom ami. Mi. Leŋiŋhaviŋ nêgê Lasalus imbiŋ, ôpatu ba Yisu hik liŋ hathak loŋbô hêk ŋama. ");
INSERT INTO hot_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ba intu avômalô Islael bêŋ anôŋ êvhaviŋ ba esopa Yisu. Ma ŋê bêŋbêŋ êbôk da evak abô ek nijik Lasalus vônô imbiŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Haviyô hayaŋ ma avômalô nômbêŋ atu ba bôk i Jelusalem ek nêgê waklavôŋ Hale ba Hi elaŋô nena Yisu haveŋ ba hi Jelusalem. ");
INSERT INTO hot_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ma ewa nôkyalô thaŋaŋ ba i êpôm Yisu ma elam kaêk nena, “Osana!” “Wapômbêŋ nêm lamavi êndêŋ ôpatu ba halêm hathak Anyô Bêŋ anêŋ athêŋ!” “Wapômbêŋ nêm lamavi êndêŋ avômalô Islael iniŋ Kiŋ!” ");
INSERT INTO hot_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yisu hawa bok doŋki map te ba hayô hamô hatôm atu ba bôk eto halôk Wapômbêŋ anêŋ kapya nena, ");
INSERT INTO hot_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Môlô avômalô Saion miŋ nôkô ami. Ôŋgô! Unim kiŋ halêm! Yani hayô hamô bok doŋki nakaduŋ te ba halêm!” ");
INSERT INTO hot_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ŋê ku êyê nôm takêŋ ma doŋtom êthôŋ anêŋ ôdôŋ paliŋ. Ma Yisu hama ba haviyô hathak loŋbô ma miŋ leŋiŋhabi abô takatu ba bôk eto halôk Wapômbêŋ anêŋ kapya. Êŋ ma eyala nena abô êŋ eto hathak Yisu da lôk leŋiŋhabi nôm takatu ba idum hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Avômalô takatu ba bôk êyê Yisu halam Lasalus hêk siô ba hik liŋ hathak loŋbô enaŋ haveŋ denaŋ ba abô êŋ hi mayaliv. ");
INSERT INTO hot_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aêŋ ba avômalô bêŋ anôŋ elaŋô nena Yisu bôk hadum lavôŋiŋ êŋ. Ba intu etak Jelusalem ba i ek nêpôm yani. ");
INSERT INTO hot_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ŋê Palisi êyê ma thêlôda enaŋ hadêŋ i, “Ôŋgô! Avômalô sapêŋ lêk esopa yani ba alalôaniŋ ku anôŋ mi.” ");
INSERT INTO hot_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Avômalô loŋ buyaŋ doho i daku Jelusalem ek nêgê waklavôŋ Hale ba Hi ba nênêm yeŋ imbiŋ avômalô Islael. ");
INSERT INTO hot_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ma i hadêŋ Pilip, anyô Betsaida anêŋ Galili. Ma enaŋ hik yani liŋ, “Anyô bêŋ, yêlô adum ek nagê Yisu.” ");
INSERT INTO hot_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Êŋ ma Pilip hi hanaŋ hadêŋ Andulu ba thai i enaŋ hadêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma Yisu hanaŋ, “Wakma lêk hayô yôv ek injik Anyô Anêŋ Nakaduŋ anêŋ lôkmaŋgiŋ thô. ");
INSERT INTO hot_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yanaŋ avanôŋ biŋ êndêŋ môlô. Yaŋvêk te miŋ evatho halôk pik ami, êŋ ma tem miŋ injik anôŋ ami. Tem ida êmô aêŋ. Ma doŋtom yaŋvêk atu ba evatho halôk pik, êŋ ma hama ba tem injik anêŋ anôŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Anyô te lahaviŋ anêŋ lôkmala bêŋ anôŋ êŋ ma anêŋ lôkmala êŋ tem nêm yak ba mi. Ma anyô te hapôlik hathak anêŋ lôkmala pik êntêk êŋ ma tem embaloŋ anêŋ lôkmala êŋ loŋ wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ôpatu ba hadum ek indum yenaŋ ku ma esopa ya ba loŋ atu ba yahamô ma tem êmô imbiŋ. Ma Wakamik tem enaŋ abô mavi esak ôpêŋ. ");
INSERT INTO hot_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Lêk yaleŋmalaiŋ bêŋ ba hatôm yanaŋ nena, ‘Wakamik, nêm ya bulubiŋ.’ Dô! Yahalêm ek yandum ku êŋ. ");
INSERT INTO hot_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Wakamik, nuŋgwik anêm lôkmaŋgiŋ thô!” Êŋ ma kaêk te halam anêŋ malak leŋ nena, “Bôk yahik yenaŋ lôkmaŋgiŋ thô yôv. Ma tem yandum esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Avômalô nômbêŋ atu imiŋ loŋ êŋ elaŋô abô êŋ ba enaŋ, “Kakalu!” Ma doho enaŋ, “Aŋela te hanaŋ abô hadêŋ yani!” ");
INSERT INTO hot_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma Yisu hanaŋ nena, “Kaêk êŋ halêm ek nêm môlô sa. Yani miŋ halam ek nêm ya sa ami ma mi. ");
INSERT INTO hot_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ku nenaŋ avômalô pik bêŋ lêk hayô yôv. Ba tem nimbi pik êntêk anêŋ anyô bêŋ kambom atu ni. ");
INSERT INTO hot_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma tem nênêm ya liŋ êtôm sêbôk ba Mose hathôkwêŋ umya dahô hathak a ek endom avômalô sapêŋ nêlêm êndêŋ ya.” ");
INSERT INTO hot_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yisu hanaŋ abô êŋ ek injik loŋôndê atu ba tem nijik yani vônô esak alovalaŋaŋsiŋ thô. ");
INSERT INTO hot_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ma avômalô nômbêŋ atu enaŋ, “Abô balabuŋ hanaŋ nena Mesia atu tem êmô êtôm wak nômbêŋ intu sapêŋ ba yêlô ayala abô êŋ. Ma honaŋ nena nêsôkwêŋ o Anyô Anêŋ Nakaduŋ esak a. Anyô Anêŋ Nakaduŋ êŋ ma opalê?” ");
INSERT INTO hot_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ma Yisu hanaŋ, “Sawa bidoŋ iyom ma deda tem êmô imbiŋ môlô. Ba ôpatu haveŋ momaŋiniŋ ma hathôŋ nena tem ni êsê. Aêŋ ba intu môlô nombeŋ yapiŋ êŋa tem momaŋiniŋ êyô môlô vôv! ");
INSERT INTO hot_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Deda hamô haviŋ môlô denaŋ. Aêŋ ba nônêmimbiŋ yani ek môlô tem numbitak deda anêŋ avômalô.” Yisu hanaŋ abô êŋ yôv ma hatak thêlô ba hi hakopak. ");
INSERT INTO hot_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yisu bôk hadum lavôŋiŋ lomaloma hêk avômalô maleŋiŋ. Ma doŋtom miŋ êvhaviŋ yani ami ");
INSERT INTO hot_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ek plopet Aisaia anêŋ abô injik anôŋ nena, “Anyô Bêŋ, opalê lêk hêvhaviŋ alalôaniŋ abô? Ma opalê lêk hayê anêm lôklokwaŋ atu ba bôk huik thô? Mi anôŋ.” ");
INSERT INTO hot_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Avômalô iniŋ lôklokwaŋ mi ek nêmimbiŋ ba intu plopet Aisaia bôk hanaŋ hêk Wapômbêŋ anêŋ kapya aêntêk, ");
INSERT INTO hot_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yani habi thêlô maleŋiŋ siŋ ma hik thêlôniŋ auk siŋ ek miŋ nêgê esak maleŋiŋ lôk neyala ênjêk iniŋ auk ba nêmbô nêlêm êndêŋ ya ek yandum thêlô mavi ami.” ");
INSERT INTO hot_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia bôk hayê Yisu anêŋ lôkmaŋgiŋ. Aêŋ ba yani hanaŋ abô êŋ hathak Yisu. ");
INSERT INTO hot_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ma avômalô Islael iniŋ ŋê bêŋbêŋ doho êvhaviŋ Yisu ma doŋtom miŋ enaŋ iniŋ êvhaviŋ bêŋ ami. Thêlô êkô ek Palisi nênêm i vê ");
INSERT INTO hot_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ba intu leŋiŋhaviŋ avômalô pik iniŋ leŋiŋmavi bêŋ anôŋ hamôŋ ek Wapômbêŋ anêŋ lamavi. ");
INSERT INTO hot_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ma Yisu halam kaêk nena, “Ôpatu ba hêvhaviŋ ya ma hêvhaviŋ ôpatu ba hêv ya ba yahalêm haviŋ. Miŋ hêvhaviŋ ya iyom ami. ");
INSERT INTO hot_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ôpatu ba hayê ya, êŋ ma hatôm hayê ôpatu ba hêv ya ba yahalêm. ");
INSERT INTO hot_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yahalêm hatôm deda hamô pik ek opalêla takatu ba êvhaviŋ ya ma tem miŋ nêmô momaŋiniŋ esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Yahalêm ek yanêm avômalô pik bulubiŋ. Ma miŋ yahalêm ek yandum abô ek avômalô pik ami. Aêŋ ba opalêla takatu ba elaŋô yenaŋ abô ba miŋ esopa ami ma tem miŋ yandum abô ek i ami. ");
INSERT INTO hot_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Abô takêntêk ba yahanaŋ êŋ iyom intu tem êtôm abô nindum abô esak êndêŋ pik lo leŋ anêŋ daŋ ba opalê atu ba hadô ya ba miŋ halaŋô yenaŋ abô ami, êŋ ma tem yani indum abô. ");
INSERT INTO hot_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ma Wakamik atu ba hêv ya ba yahalêm intu hêv abô êŋ ba yahanaŋ. Miŋ yada yahanaŋ yenaŋ abô ami. Ba intu tem nindum abô esak abô êŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma yahayala nena Wakamik anêŋ abô tem nêm lôkmala atu ba nêmô êtôm wak nômbêŋ intu sapêŋ. Aêŋ ba yahanaŋ abô takatu ba Wakamik hêv hadêŋ ya iyom.” ");
INSERT INTO hot_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Avômalô Islael iniŋ waklavôŋ Hale ba Hi habobo. Ma Yisu hayala nena anêŋ waklavôŋ etak pik ba ni ek Lambô lêk hayô. Yani hathak lahaviŋ anêŋ avômalô takatu ba êmô pik aleba hayô wakma hatak i. Ma dokte ma tem injik anêŋ lahaviŋ anêŋ anôŋ thô êndêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yaŋsiŋ ma thêlô eyaŋ nôm êmô. Ma Sadaŋ bôk halôk Judas la yôv ek enaŋ Yisu bêŋ. Judas êŋ ma Saimon Iskaliot nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ma Yisu hayala nena Wapômbêŋ hatak nômkama sapêŋ halôk yanida baŋ. Lôk hayala nena yanida halêm anêŋ Wapômbêŋ ba tem êmbôni êndêŋ Wapômbêŋ esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Êŋ ma hatak nôm hamô. Ma habi anêŋ kwêv thô hatôm anyô athêŋ mi ma hawa sôp te ba havuvi hayô haveŋ lamalim. ");
INSERT INTO hot_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ma haŋgasô ŋaŋ halôk belev te ba hathik anêŋ ŋê ku veŋiŋ kapô. Ma haya vê hathak sôp atu ba havak hawê haveŋ lamalim. ");
INSERT INTO hot_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yani hathik anyô vi iniŋ yôv ma hadum ek isik Saimon Pita anêŋ. Ma Pita hanaŋ, “Anyô Bêŋ, hudum ek usik yaveŋkapô e?” ");
INSERT INTO hot_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma hanaŋ, “Hôthôŋ nôm atu ba lêk yahadum. Wak te am ka tem oyala.” ");
INSERT INTO hot_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ma Pita hanaŋ, “Dô! Miŋ usik yaveŋkapô ami. Mi anôŋ.” Ma hanaŋ viyaŋ, “Miŋ yahathik o ami ma tem miŋ umbitak yenaŋ avômalô te ami.” ");
INSERT INTO hot_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ma Saimon Pita hanaŋ, “Anyô Bêŋ, êŋ ma usik yabaheŋ lôk yaleŋkadôk imbiŋ ma miŋ usik yaveŋkapô iyom ami.” ");
INSERT INTO hot_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ma yani hanaŋ hadêŋ ôpêŋ nena, “Anyô bôk hathik i yôv, ma miŋ isik i esak loŋbô ami. Isik va iyom ek malê nena liŋkupik ma mabuŋ. Ma môlô ma mabuŋ. Ma doŋtom miŋ sapêŋ mabuŋ ami.” ");
INSERT INTO hot_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yisu lêk hayala ôpatu ba tem enaŋ yani bêŋ. Ba intu hanaŋ, “Miŋ sapêŋ mabuŋ ami.” ");
INSERT INTO hot_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yani havôkwiŋ thêlô veŋiŋ yôv ma hik anêŋ kwêv hathak loŋbô ma halôk hamô. Ma hanaŋ hik thêlô liŋ, “Môlô oyala nôm atu ba lêk yahadum anêŋ ôdôŋ e? ");
INSERT INTO hot_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ya môlônim Kêdôŋwaga lôk môlônim Anyô Bêŋ ba intu môlô udum mavi ba olam ya nena ‘Kêdôŋwaga’ lôk ‘Anyô Bêŋ’. ");
INSERT INTO hot_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ôŋgô! Ya ma môlônim Anyô Bêŋ lôk Kêdôŋwaga ma doŋtom lêk yahathik môlô vemim hatôm anyô athêŋ mi. Aêŋ ba môlô sapêŋ nusik môlônim avômalô vi veŋiŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yahik ku êŋ thô hadêŋ môlô ek nosopa yaveŋgwam ba nundum êtôm atu ba lêk yahadum hadêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yanaŋ avanôŋ biŋ êndêŋ môlô. Anyô ku ma miŋ bêŋ ek anêŋ anyô bêŋ ami. Ma anyô atu ba hi ma miŋ bêŋ ek ôpatu ba hêv yani ba hi ami. ");
INSERT INTO hot_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lêk môlô oyala auk takêŋ. Ba udum aêŋ ma tem Wapômbêŋ lamavi esak môlô. ");
INSERT INTO hot_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ma miŋ yahanaŋ abô êŋ hathak môlô sapêŋ ami. Yahayala môlô ŋê takatu ba yahalam yôv unim auk. Ma doŋtom abô atu ba hêk Wapômbêŋ anêŋ kapya tem injik anôŋ aêntêk, ‘Ôpatu ba hayaŋ nôm haviŋ ya ma tem nêm vaŋgwam liŋ ek embak ya esak.’ ");
INSERT INTO hot_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Nôm êŋ habitak ami denaŋ ma lêk yahanaŋ hadêŋ môlô yôv ek waklavôŋ atu ba nôm êŋ habitak ma môlô tem nônêmimbiŋ ya nena Yada Yahamô. ");
INSERT INTO hot_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yanaŋ avanôŋ biŋ êndêŋ môlô nena ôpatu ba hawa anyô te atu ba yahêv hathôk thô, yani hawa ya thô haviŋ. Ma ôpatu ba hawa ya thô, hawa Ôpatu ba hêv ya ba yahalêm thô haviŋ.” ");
INSERT INTO hot_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yisu hanaŋ yôv ma lamalaiŋ kambom. Ma hanaŋ bêŋ nena, “Yanaŋ avanôŋ biŋ êndêŋ môlô. Môlô te tem enaŋ ya bêŋ!” ");
INSERT INTO hot_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ma ŋê ku êthôŋ nena thêlô alisê intu tem indum nôm êŋ ba ititiŋ i mayaliv. ");
INSERT INTO hot_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ŋê ku ali atu ba Yisu hathak lahaviŋ bêŋ anôŋ hamô habobo yani. ");
INSERT INTO hot_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma Saimon Pita hik thô hathak wakadôk nena, “Onaŋ injik yani liŋ nena yani hanaŋ hathak opalê.” ");
INSERT INTO hot_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Êŋ ma ôpêŋ hanaŋ thikuthik nena, “Anyô Bêŋ, honaŋ hathak opalê?” ");
INSERT INTO hot_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ma Yisu hanaŋ, “Tem yatak polom te êndôk thôk ba yahêv hadêŋ môlô te. Êŋ ma ôpêŋ.” Ma hatak polom seleŋ êŋ halôk thôk ma hêv hadêŋ Judas, Saimon Iskaliot nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas hawa polom êŋ ma Sadaŋ halôk yani kapô. Ma Yisu hanaŋ hadêŋ yani, “Nu undum anêm ku ketheŋ.” ");
INSERT INTO hot_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ŋê takatu ba eyaŋ nôm haviŋ Yisu elaŋô ma doŋtom êthôŋ anêŋ abô atu ba hanaŋ hathak Judas anêŋ ôdôŋ paliŋ. ");
INSERT INTO hot_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ma anyô hayabiŋ valuseleŋ. Aêŋ ba doho esoŋ nena Yisu hanaŋ ek ni nêm nômkama vuli ek nêgê waklavôŋ Hale ba Hi mena ni nêm nômkama êndêŋ ŋê siv la. ");
INSERT INTO hot_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas hawa polom êŋ yôv ma hatak thêlô ba hi. Ma lêk bôlôvôŋ. ");
INSERT INTO hot_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas hi yôv ma Yisu hanaŋ, “Dokte ma avômalô tem nêgê ya Anyô Anêŋ Nakaduŋ atu anêŋ lôkmaŋgiŋ thô. Ma lôkmaŋgiŋ êŋ tem injik Wapômbêŋ anêŋ lôkmaŋgiŋ anôŋ thô. ");
INSERT INTO hot_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma kasana Wapômbêŋ tem injik ya Anyô Anêŋ Nakaduŋ atu anêŋ lôkmaŋgiŋ thô aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Yenaŋ avômena, tem yamô vauna imbiŋ môlô. Ma môlô tem nômbôlêm ya. Ma doŋtom môlô miŋ ôtôm unu loŋ atu ba tem yana ami. Bôk yahanaŋ abô êŋ hadêŋ avômalô Islael ma lêk yahanaŋ abô bô êŋ hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ma yahêv balabuŋ lukmuk te hadêŋ môlô nena lemimimbiŋ am êtôm atu ba lêk yaleŋhaviŋ môlô. ");
INSERT INTO hot_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Môlô lemimhaviŋ am aêŋ ma tem avômalô sapêŋ nêgê môlô nena yenaŋ avômalô takatu ba esopa ya.” ");
INSERT INTO hot_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita hanaŋ hik Yisu liŋ, “Anyô Bêŋ, nu êsê?” Ma Yisu hanaŋ, “Loŋ atu ba tem yana ma miŋ hatôm osopa ya ami. Ma doŋtom wak te am ka tem osopa ya.” ");
INSERT INTO hot_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ma Pita hanaŋ, “Anyô Bêŋ, aisê ba miŋ hatôm yasopa o êndêŋ yaô ami? Tem yatak yenaŋ lôkmala ek yanêm o sa!” ");
INSERT INTO hot_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma Yisu hanaŋ, “Avanôŋ e? Lemhaviŋ otak anêm lôkmala ek nêm ya sa e? Yanaŋ avanôŋ biŋ êndêŋ o nena tale miŋ halaŋ ami denaŋ ma tem onaŋ êtôm bôlôŋ lô nena hôthôŋ ya paliŋ.” ");
INSERT INTO hot_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Môlô miŋ kapôlômim malaiŋ ami. Nônêmimbiŋ Wapômbêŋ lôk nônêmimbiŋ ya. ");
INSERT INTO hot_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Unyak lokapô lokapô hêk Wakamik anêŋ unyak ba yaha ek yapôpêk môlônim loŋ. Abô êŋ ma abôyaŋ, ma tem miŋ yanaŋ aêŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yaha ek yapôpêk môlônim loŋ. Êŋ ma tem yandealêm ek yanja môlô ek nômô loŋ êŋ imbiŋ ya. ");
INSERT INTO hot_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma bôk oyala loŋôndê atu ba hi loŋ atu ba tem yana.” ");
INSERT INTO hot_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas hanaŋ, “Anyô Bêŋ, yêlô athôŋ loŋ atu ba tem nu paliŋ ma tem nayala loŋôndê êŋ aisê?” ");
INSERT INTO hot_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma Yisu hanaŋ, “Yada intu loŋôndê lôk abô avanôŋ ma lôkmala. Ma anyô te miŋ hatôm esak loŋôndê yaŋ ba ni ek Wakamik ami. Mi. Ya iyom. ");
INSERT INTO hot_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Môlô oyala ya katô, êŋ ma tem noyala Wakamik aêŋ iyom. Avanôŋ! Bôk ôyê lôk oyala yani yôv!” ");
INSERT INTO hot_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma Pilip hanaŋ hadêŋ Yisu, “Anyô Bêŋ, nuŋgwik Lemambô thô êndêŋ yêlô. Êŋ ma hatôm.” ");
INSERT INTO hot_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma hanaŋ viyaŋ, “Pilip, bôk yahamô haviŋ môlô sawa daim ma miŋ hoyala ya ami denaŋ e? Anyô hayê ya ma hayê Wakamik. Ma honaŋ nena yaŋgik Wakamik thô eka? ");
INSERT INTO hot_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ma miŋ hôêvhaviŋ nena yahamô Wakamik kapô ma Wakamik hamô yakapô ami e? Abô atu ba yahanaŋ hadêŋ môlô ma Wakamik hamô ya kapô ba hathak hadum anêŋ ku. Miŋ yada yahanaŋ hathak yenaŋ auk ami. ");
INSERT INTO hot_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nônêmimbiŋ abô êntêk! Wakamik hamô ya kapô ma yahamô yani kapô. Ma môlô ôdô nônêmimbiŋ abô êntêk, êŋ ma lemimimbi ku takatu ba yahadum ek nêm môlô sa ek nônêmimbiŋ! ");
INSERT INTO hot_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yanaŋ avanôŋ biŋ êndêŋ môlô. Anyô hêvhaviŋ ya ma tem indum ku lomaloma êtôm yahadum. Ma yaha ek Wakamik. Aêŋ ba ôpatu ba hêvhaviŋ tem indum ku mavi lomaloma êmôŋ ek ku takatu ba yahadum. ");
INSERT INTO hot_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nôm takatu ba môlô onaŋ hathak yenaŋ athêŋ ek yandum ma tem yandum ek Nakaduŋ injik Lambô anêŋ lôkmaŋgiŋ thô. ");
INSERT INTO hot_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ma nôm takatu ba môlô onaŋ hik liŋ hathak yenaŋ athêŋ ma tem yandum.” ");
INSERT INTO hot_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Môlô lemimhaviŋ ya, êŋ ma tem nosopa abô takatu ba yahanaŋ. ");
INSERT INTO hot_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma tem yanaŋ injik Wakamik liŋ ek nêm anyô yaŋ ek embatho môlô loŋ. ");
INSERT INTO hot_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ma anyô êŋ tem êmô imbiŋ môlô êtôm wak nômbêŋ intu sapêŋ. Ôpêŋ ma Lovak Matheŋ ba hathak hik Wapômbêŋ thô. Ma tem êmô imbiŋ môlô ba êmô môlô kapôlômim ek noyala yani. Ma doŋtom avômalô pik miŋ êyê lo eyala ami. Ba intu tem miŋ neja ami. ");
INSERT INTO hot_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tem yandealêm esak loŋbô ba miŋ hatôm yatak môlô êtôm avômena bilak ami. ");
INSERT INTO hot_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dokte ma avômalô pik tem nêsôŋ ya paliŋ. Ma doŋtom môlô tem ôŋgô ya. Yahamô lôkmala. Ba intu tem môlô nômô lôkmala imbiŋ. ");
INSERT INTO hot_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wak êŋ ma tem môlô noyala nena yahamô Wakamik kapô, ma môlô ômô ya kapô, ma yahamô môlô kapôlômim. ");
INSERT INTO hot_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ma ôpatu ba halaŋô yenaŋ abô balabuŋ ba hasopa, ôpêŋ lahaviŋ ya. Ma ôpatu ba lahaviŋ ya ma Wakamik tem laimbiŋ yani. Ma aêŋ iyom tem yaleŋimbiŋ yani ma tem yaŋgik ya thô êndêŋ yani.” ");
INSERT INTO hot_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Êŋ ma Judas yaŋ, miŋ Iskaliot ami, yani hanaŋ, “Anyô Bêŋ, aisê ba lemhaviŋ nuŋgwik oda thô êndêŋ yêlô ma avômalô pik mi?” ");
INSERT INTO hot_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ma Yisu hanaŋ, “Ôpatu ba lahaviŋ ya tem esopa yenaŋ abô. Ma Wakamik tem laimbiŋ ôpêŋ, ma tem yai ana namô imbiŋ yani. ");
INSERT INTO hot_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma ôpatu ba miŋ lahaviŋ ya ami tem miŋ esopa yenaŋ abô ami. Abô êntêk ba môlô olaŋô ma miŋ yenaŋ abô ami. Mi. Abô takêŋ ma Wakamik atu ba hêv ya ba yahalêm anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Yahamô denaŋ ma yahanaŋ abô takêŋ hadêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma Wakamik tem nêm anyô te ba êlêm esak yenaŋ athêŋ ek embatho môlô loŋ. Ôpêŋ ma Lovak Matheŋ ba tem êndôŋ môlô esak nôm takêŋ sapêŋ. Ma tem indum ba môlô lemimimbi abô taksêbôk ba yahanaŋ. ");
INSERT INTO hot_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yenaŋ labali yahêv lôk yahadô hamô haviŋ môlô. Êŋ ma yada yenaŋ. Miŋ avômalô pik hatôm nênêm êndêŋ môlô ami. Lemim êndôk biŋ ma miŋ nôkô ami. ");
INSERT INTO hot_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ma lêk olaŋô abô êntêk ba yahanaŋ hadêŋ môlô, ‘Yaha. Ma tem yandealêm esak loŋbô.’ Êŋ ma môlô lemimmalaiŋ. Wakamik ma bêŋ ek ya. Ma môlô lemimimbiŋ ya, ma tem môlô lemimmavi ek yaha hadêŋ Wakamik. ");
INSERT INTO hot_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nôm êŋ miŋ habitak ami denaŋ ma lêk yahanaŋ hadêŋ môlô ek wak êŋ hayô ma môlô nônêmimbiŋ. ");
INSERT INTO hot_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Dokte ma pik êntêk anêŋ anyô bêŋ tem êlêm ba intu miŋ hatôm yanaŋ abô pôk bêŋ anôŋ ami. Ma miŋ hatôm indum nômla esak ya ami. ");
INSERT INTO hot_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma doŋtom yahadum ek avômalô pik neyala nena yaleŋhaviŋ Wakamik ba yahasopa nôm takatu ba yani hanaŋ hadêŋ ya katô. Yôv ma nôlêm ek alôana i.” ");
INSERT INTO hot_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yisu hanaŋ, “Ya ma yak lokwaŋ ta anôŋ. Ma Wakamik ma ku kapô anêŋ alaŋ. ");
INSERT INTO hot_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yenaŋ thaŋaŋ sapêŋ atu ba miŋ hik anôŋ ami ma Wakamik hathak halo vê. Ma thaŋaŋ sapêŋ atu ba hik anôŋ ma hêv katôŋ vê ek injik limamôk. ");
INSERT INTO hot_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Abô atu ba yahanaŋ hadum ba môlô ubitak mabuŋ. ");
INSERT INTO hot_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Môlô odahaliŋ ya êŋ ma tem yandahaliŋ môlô. Yak thaŋaŋ da miŋ hatôm injik anêŋ anôŋ ami. Thaŋaŋ hadahaliŋ yak lokwaŋ ta ek injik limamôk. Aêŋ ba môlô miŋ odahaliŋ ya ami, êŋ ma tem miŋ uŋgwik anôŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yada ma hatôm yak lokwaŋ ta. Ma môlô ma thaŋaŋ. Ôpatu ba hadahaliŋ ya ma yahadahaliŋ yani ba intu hik limamôk. Ma miŋ yahêv môlô sa ami, ma môlô miŋ hatôm nundum nômlate ami. ");
INSERT INTO hot_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma anyô te miŋ hadahaliŋ ya ami ma hatôm thaŋaŋ atu ba ibi halôk pik ba hakapok ba isup ek nêmbôk esak atum. ");
INSERT INTO hot_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma môlô odahaliŋ ya ba yenaŋ abô hêk môlô kapô ba onaŋ hik ya liŋ hathak malêla takatu ba môlô lemimhaviŋ, êŋ ma tem noja. ");
INSERT INTO hot_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ma avômalô takatu ba ethak ik anôŋ limamôk intu tem nêgê i nena yenaŋ. Êŋ ma uik Wakamik anêŋ lôkmaŋgiŋ thô. ");
INSERT INTO hot_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Yaleŋhaviŋ môlô hatôm atu ba Wakamik lahaviŋ ya. Nômô yenaŋ yaleŋhaviŋ êŋ kapô. ");
INSERT INTO hot_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Môlô osopa yenaŋ abô ma tem môlô nômô yenaŋ yaleŋhaviŋ kapô hatôm atu ba yahasopa Wakamik anêŋ abô ba yahamô yani anêŋ lahaviŋ kapô. ");
INSERT INTO hot_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yahanaŋ abô takêntêk ek yenaŋ yaleŋmavi êmô imbiŋ môlô lôk êmô môlô kapôlômim siŋ. ");
INSERT INTO hot_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yanaŋ abô balabuŋ te êndêŋ môlô nena môlô tomtom lemimimbiŋ am êtôm atu ba bôk yaleŋhaviŋ môlô yôv. ");
INSERT INTO hot_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ma anyô te hatak anêŋ lôkmala ek hêv anêŋ anyô môlô bulubiŋ, êŋ ma lahaviŋ êŋ hamôŋ ek leŋiŋhaviŋ vi. ");
INSERT INTO hot_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Môlô udum aêŋ êŋ ma môlô ma yenaŋ anyô môlô. ");
INSERT INTO hot_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sêbôk ma yahalam môlô nena anyô ku. Anyô ku ma miŋ hayala anyô bêŋ anêŋ auk ami. Ma doŋtom lêk yahik auk nômbêŋ atu ba Wakamik bôk hêv hadêŋ ya thô hadêŋ môlô ba intu yahalam môlô tomtom nena anyô môlô. Ma miŋ ŋê ku hathak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Môlô miŋ bôk olam ya ami. Mi. Yahalam môlô lôk yahatak yabaheŋ hayô hêk môlô ba hathak yenaŋ athêŋ nonaŋ injik Wakamik liŋ esak unim lemimhaviŋ ma tem yanêm lemimhaviŋ takêŋ êndêŋ môlô ek unu uŋgwik anôŋ atu ba tem êmô êtôm wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yenaŋ abô balabuŋ ma môlô lemimimbiŋ am.” ");
INSERT INTO hot_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yisu hanaŋ, “Avômalô pik êpôlik ek môlô, êŋ ma môlô lemimimbi nena bôk êpôlik hathak ya aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Môlô ma pik anêŋ ma tem avômalô pik leŋiŋimbiŋ môlô êtôm atu ba leŋiŋ haviŋ thêlôda iniŋ avômalô. Ma doŋtom môlô ma miŋ avômalô pik êntêk ami. Bôk yahalam môlô yôv ek notak avômalô takêŋ ba intu êpôlik hathak môlô. ");
INSERT INTO hot_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Môlô lemimimbi abô êntêk ba yahanaŋ hadêŋ môlô katô. ‘Anyô ku miŋ bêŋ ek anêŋ anyô bêŋ ami.’ Avômalô pik êntêk bôk êv vovaŋ hadêŋ ya ba intu tem nindum aêŋ iyom êndêŋ môlô. Ma aêŋ iyom doho bôk elaŋô yenaŋ abô ba intu tem nedaŋô môlônim abô imbiŋ. ");
INSERT INTO hot_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Môlô ma yenaŋ avômalô. Ma avômalô pik êthôŋ ôpatu ba hêv ya ba yahalêm paliŋ. Ba intu tem nênêm vovaŋ êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma miŋ yahalêm ba yahêv abô hadêŋ avômalô takêŋ ami, êŋ ma tem miŋ neja vuli esak iniŋ kambom ami. Ma doŋtom lêk miŋ hatôm nenaŋ abô te ami. ");
INSERT INTO hot_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ôpatu ba hapôlik hathak ya ma hapôlik hathak Wakamik aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma ya miŋ yahamô thêlô malêvôŋ ba yahadum ku atu ba miŋ bôk anyô te hadum ami êŋ ma thêlôniŋ kambom mi. Ma doŋtom bôk êyê yôv ma êdô yai lôk Wakamik. ");
INSERT INTO hot_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aêŋ ba thêlôda iniŋ abô balabuŋ bute hik anôŋ aêntêk, ‘Thêlô êdô ya oyaŋ.’ ");
INSERT INTO hot_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Tem yanêm anyô te êlêm anêŋ Wakamik ek embatho môlô loŋ. Ôpêŋ ma Lovak Matheŋ atu ba Wakamik tem nêm ek injik Wapômbêŋ thô. Ma tem enaŋ yenaŋ abô bêŋ. ");
INSERT INTO hot_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma yenaŋ ku anêŋ môŋ ma môlô sapêŋ bôk ômô haviŋ ya aleba lêk. Êŋ ma môlô nonaŋ yenaŋ abô bêŋ imbiŋ. ");
INSERT INTO hot_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Yahanaŋ abô takêŋ ek môlô miŋ notak unim ôêvhaviŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","3","Êthôŋ yai lôk Wakamik paliŋ ba intu tem nênêm môlô vê lôk nijik môlô vônô ba nesoŋ nena êŋ ma êv yeŋ hadêŋ Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Lêk yahanaŋ abô takêŋ yôv hadêŋ môlô ek waklavôŋ nôm takêŋ habitak, êŋ ma tem lemimimbi nena bôk yahanaŋ yôv. Sêbôk ma yada yahamô haviŋ môlô ba intu miŋ yahanaŋ abô êŋ hadêŋ môlô ami. ");
INSERT INTO hot_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","“Ma doŋtom yaha ek yani atu ba hêv ya ba yahalêm. Ma yahanaŋ abô takêntêk hadêŋ môlô ba intu hadum môlô lemimmalaiŋ kambom ba miŋ onaŋ hik ya liŋ nena ‘tem nu êsê’ ami e? ");
INSERT INTO hot_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yanaŋ avanôŋ êndêŋ môlô nena yaha ek Wakamik ek nêm môlô sa. Yaha ami êŋ ma Lovak Matheŋ, ôpatu ba embatho môlô loŋ tem miŋ êlêm ami. Ba intu tem yana ek yanêm yani ba êlêm êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yani tem êlêm ek enaŋ avômalô pik iniŋ kambom lokwaŋlô bêŋ aêntêk: iniŋ kambom atu idum bêŋ lôk auk atu elela auk thêthôŋ ma iniŋ auk lôkbaŋ hathak waklavôŋ idum abô. ");
INSERT INTO hot_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ku môŋ ma tem enaŋ avômalô iniŋ kambom atu ba miŋ êvhaviŋ ya ami bêŋ. ");
INSERT INTO hot_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma ku yaŋ ma avômalô pik esoŋ nena ya miŋ anyô thêthôŋ ami. Ma doŋtom yaha ek Wakamik ba tem miŋ môlô nôŋgô ya ami ba intu ya ma anyô thêthôŋ. Aêŋ ba tem êlêm ek injik auk thêthôŋ êŋ thô. ");
INSERT INTO hot_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma ku te lô nena avômalô pik esopa anyô môŋ atu ba hayabiŋ pik êntêk ba esoŋ nena tem miŋ nindum abô ami. Ma doŋtom ôpêŋ bôk hamô loŋ idum abô yôv ek ema ba intu thêlô tem nindum abô imbiŋ. Aêŋ ba Lovak Matheŋ tem injik auk êŋ thô êndêŋ i imbiŋ. ");
INSERT INTO hot_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Yaleŋhaviŋ yanêm abô bêŋ anôŋ imbiŋ êndêŋ môlô ma môlô miŋ hatôm nobaloŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma doŋtom Lovak Matheŋ ôpatu ba hik Wapômbêŋ thô tem êlêm ek eyabiŋ môlônim auk ek noyala Wapômbêŋ lôk enaŋ abô esak nôm takatu ba tem imbitak embeŋ yam. Yani tem enaŋ abô atu ba halaŋô iyom ma tem miŋ enaŋ abô êtôm yanida anêŋ auk ami. ");
INSERT INTO hot_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yani tem enja yenaŋ auk ba enaŋ bêŋ êndêŋ môlô ma tem injik yenaŋ lôkmaŋgiŋ thô êndêŋ môlô imbiŋ. ");
INSERT INTO hot_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wakamik anêŋ auk ma hatôm yenaŋ. Ba intu yahanaŋ nena Lovak Matheŋ tem enja yenaŋ auk ba injik thô êndêŋ môlô.” ");
INSERT INTO hot_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yisu hanaŋ, “Dokte ma tem môlô nôsôŋ ya paliŋ. Ma vêm ka tem ôŋgô ya esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ma ŋê ku doho enaŋ hadêŋ thêlôda, “Aisê ka yani hanaŋ nena dokte ma tem alalô nasôŋ yani paliŋ? Ma vêm ka tem nagê yani esak loŋbô lôk ni ek Lambô? Alalô athôŋ abô takêŋ paliŋ.” ");
INSERT INTO hot_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma thêlô enaŋ lôbôlôŋ, “‘Dokte’ anêŋ ôdôŋ aisê? Alalô athôŋ abô êŋ paliŋ.” ");
INSERT INTO hot_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yisu hayala nena idum ek nenaŋ injik yani liŋ esak abô êŋ. Aêŋ ba hanaŋ, “Yahanaŋ ‘Dokte ma tem nôsôŋ ya paliŋ. Ma vêm ka tem ôŋgô ya esak loŋbô.’ Ba intu môlô onaŋ hik môlôda liŋ hathak abô atu ba yahanaŋ anêŋ ôdôŋ e? ");
INSERT INTO hot_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yanaŋ avanôŋ biŋ êndêŋ môlô. Avômalô pik tem leŋiŋmavi. Ma doŋtom môlô tem nodaŋ asêŋ malêŋ. Môlô tem kapôlômim malaiŋ. Ma doŋtom môlô lemimmalaiŋ êŋ tem imbitak lemimmavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Avi anêŋ waklavôŋ embathu hayô êŋ ma hawa vovaŋ ek embathu. Ma lêk havathu yôv ma miŋ lahabi vovaŋ êŋ hathak loŋbô ami. Amena lêk habitak yôv ba intu lamavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ma môlô aêŋ iyom. Lêk môlô kapôlômim malaiŋ. Ma doŋtom tem yaŋgê môlô esak loŋbô ba intu tem lemim mavi. Ma miŋ hatôm anyô la nêm lemim mavi êŋ vê ênjêk môlô ami. ");
INSERT INTO hot_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Yanaŋ avanôŋ biŋ êndêŋ môlô. Tem yana ba nôm takatu ba môlô onaŋ hik Wakamik liŋ hathak yenaŋ athêŋ ma tem yani nêm êndêŋ môlô. Ma môlô tem miŋ nonaŋ injik ya liŋ esak nômlate ami. ");
INSERT INTO hot_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ya ma Nakaduŋ ba intu nonaŋ injik yani liŋ esak yenaŋ athêŋ ek noja lemimmavi bêŋ anôŋ êmô môlô kapôlômim siŋ. Sêbôk aleba lêk ma miŋ môlô onaŋ hik yani liŋ hathak nômlate hathak yenaŋ athêŋ ami.” ");
INSERT INTO hot_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yisu hanaŋ, “Bôk yahavuŋ abô ba yahanaŋ abô sapêŋ hatôm abô loŋ kapô hadêŋ môlô. Ma wak te am ka tem yanaŋ abô avanôŋ êndêŋ môlô esak Wakamik ba tem yanaŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wak êŋ ma môlôda tem nodam yenaŋ athêŋ ba nonaŋ injik Wakamik liŋ. Ma miŋ yada yanja môlônim abô ba yanaŋ injik yani liŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Avanôŋ! Môlô lemimhaviŋ ya lôk ôêvhaviŋ nena yahalêm anêŋ Wapômbêŋ. Aêŋ ba intu Wakamik da lahaviŋ môlô ba môlôda tem nonaŋ injik yani liŋ esak unim lemimhaviŋ. ");
INSERT INTO hot_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yahatak Wakamik ba yahalêm pik. Ma lêk yahatak pik ba yahavôha ek Wakamik.” ");
INSERT INTO hot_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Êŋ ma Yisu anêŋ ŋê ku enaŋ, “Lêk honaŋ abô êŋ bêŋ ma miŋ huvuŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lêk yêlô ayala nena hoyala nômkama sapêŋ. Miŋ yêlô anaŋ hik o liŋ ami denaŋ ma hoyala yêlôaniŋ abô ba honaŋ bêŋ. Ba intu yêlô êvhaviŋ nena hôlêm anêŋ Wapômbêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yisu hanaŋ, “Lêk môlô ôêvhaviŋ e? ");
INSERT INTO hot_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Odaŋô! Avômalô tem nidupuniŋ môlô tomtom ba nôsôv mayaliv ba unu unim loŋ. Ma môlô tem notak ya ba yada tem yamô thiliv. Ma doŋtom Wakamik hamô haviŋ ya. Aêŋ ba tem miŋ yamô daluk ami. Wak te am ka nôm êŋ tem imbitak. Ma wak êŋ lêk habitak yôv. ");
INSERT INTO hot_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Lêk yahanaŋ abô takêŋ ek môlô nodahaliŋ ya ba nômô yaô. Môlô tem nôpôm malaiŋ êmô pik êntêk. Ma doŋtom numiŋ lôklokwaŋ! Ya bôk yahamô pik êntêk anêŋ lôklokwaŋ lu yôv.” ");
INSERT INTO hot_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","2","Yisu hanaŋ abô takêŋ yôv ma hêv ma hathak leŋ ma hateŋ mek nena, “Wakamik, wakma lêk hayô yôv. Bôk hotak ya yôv ek yayabiŋ avômalô takatu ba bôk hôêv hadêŋ ya ek yanêm lôkmala atu ba nêmô êtôm wak nômbêŋ intu sapêŋ êndêŋ i. Ba nuŋgwik Nalum anêŋ lôkmaŋgiŋ thô ek yaŋgik anêm lôkmaŋgiŋ thô aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Êntêk ma lôkmala atu ba tem nêmô êtôm wak nômbêŋ intu sapêŋ. Neyala nena O ma Wapômbêŋ avanôŋ biŋ doŋtom lôk ya ma Yisu Kilisi, ôpatu ba O Wapômbêŋ hôêv ba halêm. ");
INSERT INTO hot_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","5","Wakamik, lêk yahik anêm lôkmaŋgiŋ thô hamô pik êntêk hathak ku takatu ba hôêv hadêŋ ya aleba lêk anêŋ daŋ. Ma nêm mavi lôk athêŋ bêŋ êndêŋ ya esak loŋbô êtôm sêbôk atu ba pik miŋ habitak ami denaŋ ma yahawa athêŋ bêŋ êŋ haviŋ o ba yahamô mavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Bôk yahik o thô hadêŋ avômalô pik takatu ba hôêv hadêŋ ya yôv. Sêbôk atu ba thêlô ma anêm avômalô ba hôêv hadêŋ ya ba lêk esopa anêm abô. ");
INSERT INTO hot_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Yahêv abô sapêŋ atu ba hôêv hadêŋ ya hadêŋ i ba esopa. Thêlô eyala katô nena yahatak o ba yahalêm pik lôk êvhaviŋ nena hôêv ya ba yahalêm. Aêŋ ba lêk eyala nena nôm takatu ba hôêv hadêŋ ya ma halêm anêŋ o iyom. ");
INSERT INTO hot_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Yahateŋ ek avômalô takatu ba bôk hôêv hadêŋ ya yôv. Thêlô ma anêm avômalô ba intu yahateŋ mek ek i. Ma miŋ yahateŋ mek ek avômalô pik ami. ");
INSERT INTO hot_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Avômalô takatu ba yenaŋ êŋ ma anêm. Ma avômalô takatu ba anêm êŋ ma yenaŋ. Ma thêlô êŋ intu ik yenaŋ lôkmaŋgiŋ thô. ");
INSERT INTO hot_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tem yatak pik ba yana ma tem miŋ yamô pik esak loŋbô ami. Ma thêlô tem nêmô pik. Wakamik, o ma matheŋ! Ba oyabiŋ i esak anêm athêŋ atu ba bôk hôêv hadêŋ ya ek thêlô kapôlôŋiŋ doŋtom êtôm alai kapôlôŋiŋ doŋtom. ");
INSERT INTO hot_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bôk yahamô haviŋ thêlô ba yahayabiŋ i hathak athêŋ atu ba hôêv hadêŋ ya. Ma kambom te miŋ habuliŋ i ami lôk thêlô te miŋ hatak o ami. Mi. Anyô te iyom intu tem ni loŋ atum ek abô atu ba bôk hêk anêm kapya tem injik anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ma doŋtom yahamô pik denaŋ ba yahanaŋ abô êŋ ek yenaŋ yaleŋmavi bêŋ anôŋ êmô thêlô kapôlôŋiŋ siŋ ek malê nena tem yasôk. ");
INSERT INTO hot_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Bôk yahêv anêm abô yôv hadêŋ i. Ma ya miŋ anyô pik êntêk ami. Ma thêlô aêŋ iyom. Ba intu avômalô êpôlik hathak i. ");
INSERT INTO hot_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Wakamik yahanaŋ hik o liŋ nena umiŋ anyô kambom loŋ siŋ ek thêlô ma miŋ onja i vê ênjêk pik êntêk ami. ");
INSERT INTO hot_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ya miŋ anyô pik êntêk ami ma thêlô aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Otak anêm abô êndôk thêlô kapôlôŋiŋ ba undum i ek nimbitak anêm avômalô ku matheŋ. Anêm abô êŋ ma avanôŋ. ");
INSERT INTO hot_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Yahêv thêlô ba i pik êntêk hatôm atu ba hôêv ya ba yahalêm. ");
INSERT INTO hot_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma yahêv yada hadêŋ o ek thêlô nimbitak anêm avômalô ku matheŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Miŋ yahateŋ mek hathak ŋê ku takêŋ iyom ami. Mi. Yahateŋ mek hathak avômalô takatu ba tem nedaŋô ŋê ku takêŋ iniŋ abô ba nênêmimbiŋ ya ");
INSERT INTO hot_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ek thêlô sapêŋ nêmô kapôlôŋiŋ doŋtom êtôm atu ba hômô yakapô ma yahamô o kapô. Wakamik, thêlô tem nêmô alai kapô imbiŋ ek avômalô pik nênêmimbiŋ nena hôêv ya ba yahalêm. ");
INSERT INTO hot_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bôk hôêv ya hatôm anyô lôkmaŋgiŋ ba lêk yahik lôkmaŋgiŋ êŋ thô hadêŋ thêlô ek thêlô kapôlôŋiŋ doŋtom êtôm alai kapôlôŋiŋ doŋtom. ");
INSERT INTO hot_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yahamô thêlô kapôlôŋiŋ ma hômô ya kapô. Undum ba thêlô lôkthô nimbitak kapôlôŋiŋ doŋtom ek avômalô pik neyala nena hôêv ya ba yahalêm lôk neyala nena lemhaviŋ thêlô hatôm atu ba lemhaviŋ ya. ");
INSERT INTO hot_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Wakamik, yaleŋhaviŋ avômalô takêntêk ba hôêv hadêŋ ya nêmô imbiŋ ya êmô loŋ atu ba yahamô ek nêgê yenaŋ lôkmaŋgiŋ. Pik miŋ habitak ami denaŋ ma lemhaviŋ ya ba intu hôêv lôkmaŋgiŋ êŋ hadêŋ ya. ");
INSERT INTO hot_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Wakamik, o ma thêthôŋ. Avômalô pik êthôŋ o paliŋ ma doŋtom ya ma yahayala o. Ma yenaŋ avômalô takêntêk eyala nena hôêv ya ba yahalêm. ");
INSERT INTO hot_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Bôk yahik o thô hadêŋ thêlô. Ma tem miŋ yatak ku êŋ ami ek yada yamô thêlô kapôlôŋiŋ ek leŋiŋimbiŋ avômalô vi êtôm atu ba lemhaviŋ ya.” ");
INSERT INTO hot_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yisu hateŋ mek yôv ma lôk anêŋ ŋê ku ibup êyô ŋaŋ Kidlon. Ŋaŋ êŋ vi ma ku alokwaŋ oliv te hêk ba thêlô i loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Loŋ êŋ ma thêlô ethak i lôbôlôŋ. Ba intu Judas, ôpatu ba tem enaŋ Yisu bêŋ, hayala loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Êŋ ma Judas halom ŋê vovak Lom dumte lôk Palisi lôk ŋê bêŋbêŋ êbôk da ma iniŋ ŋê bêŋbêŋ ba i loŋ êŋ. Thêlô ewa atum lam lôk atum abiŋ kapok ma nômkama nijik vovak. ");
INSERT INTO hot_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yisu hayala nôm takatu ba tem êpôm yani ba hi yaiŋ ma hanaŋ, “Môlô ôbôlêm opalê?” ");
INSERT INTO hot_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ma thêlô enaŋ, “Yisu anêŋ Nasalet.” Ma yani hanaŋ, “Ya êŋ êntêk.” Judas, ôpatu ba tem enaŋ Yisu bêŋ intu hamiŋ haviŋ ŋê êŋ. ");
INSERT INTO hot_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Thêlô elaŋô Yisu hanaŋ, “Ya êŋ êntêk.” Êŋ ma ele i ma êv yak halôk pik. ");
INSERT INTO hot_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ma yani hanaŋ hik thêlô liŋ hathak loŋbô, “Môlô ôbôlêm opalê?” Ma thêlô enaŋ, “Yisu anêŋ Nasalet.” ");
INSERT INTO hot_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ma hanaŋ, “Lêk yahanaŋ hadêŋ môlô yôv nena ya êŋ êntêk. Lêk ôpôm ya yôv ba notak ŋê êntêk ba ini.” ");
INSERT INTO hot_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hanaŋ aêŋ ek abô bôsêbôk tem injik anôŋ nena miŋ hatôm etak avômalô takatu ba Lambô hêv hadêŋ yani te ami. ");
INSERT INTO hot_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Êŋ ma Saimon Pita hawa biŋ vovak ma hale anyô bêŋ habôk da anêŋ anyô ku te limbuk vianôŋ vê. Anyô ku êŋ anêŋ athêŋ nena Malukus. ");
INSERT INTO hot_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma Yisu hanaŋ hadêŋ Pita, “Otak anêm biŋ êndôk anêŋ kupik esak loŋbô! Tem yandum ku malaiŋ atu ba Wakamik hêv hadêŋ ya.” ");
INSERT INTO hot_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Êŋ ma Lom iniŋ ŋê vovak lôk anyô vovak laik lôk avômalô Islael iniŋ sôp bidoŋ evaloŋ Yisu ba ekak hathak yak. ");
INSERT INTO hot_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Thêlôniŋ ku môŋ ma ewa yani ba i hadêŋ Anas, yani ma Kaiapas anêŋ yaŋmalô. Kaiapas ma anyô bêŋ habôk da hadêŋ sondabêŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yani anyô sêbôk atu ba hik auk thô hadêŋ Islael iniŋ ŋê bêŋbêŋ nena, “Mavi ek anyô te iyom ema ek nêm avômalô Islael bêŋ anôŋ sa.” ");
INSERT INTO hot_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita lôk anyô ku yaŋ esopa Yisu ba i. Anyô ku êŋ ma anyô bêŋ habôk da anêŋ anyô môlô te ba intu hasopa Yisu habitak hayô badêŋ abôlêk ba hi. ");
INSERT INTO hot_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ma Pita hamiŋ badêŋ viyaiŋ. Ma anyô ku yaŋ atu ba anyô bêŋ habôk da anêŋ anyô môlô havôhi ma hanaŋ abô hadêŋ avi atu ba hayabiŋ badêŋ abôlêk ba hawa Pita hayô badêŋ kapô. ");
INSERT INTO hot_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Avi atu ba hayabiŋ unyak abôlêk hanaŋ hik Pita liŋ, “E! O ma ôpatu anêŋ anyô ku te e?” Ma Pita hanaŋ, “Mi.” ");
INSERT INTO hot_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Loŋ lêk thilibuŋ. Ma ŋê ku lôk ŋê êbôk da iniŋ sôp bidoŋ ebaŋ atum ba ivuŋu imiŋ. Ma Pita hamiŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ma anyô bêŋ habôk da hanaŋ hik Yisu liŋ hathak anêŋ ŋê ku lôk abô takatu ba hanaŋ ba hadôŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ma Yisu hanaŋ, “Yahathak yahamiŋ piklêvôŋ ba yahanaŋ abô hadêŋ avômalô. Ma yahadôŋ avômalô hamô unyak yeŋ lôk unyak matheŋ ma loŋ atu ba avômalô Islael ethak doŋtom halôk. Ma miŋ yahavuŋ abô ami. ");
INSERT INTO hot_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ma aisê ka honaŋ hik ya liŋ? Avômalô takatu ba elaŋô abô takatu ba yahanaŋ, thêlô eyala abô êŋ katô. Ba intu onaŋ injik i liŋ.” ");
INSERT INTO hot_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hanaŋ aêŋ ma ŋê êbôk da iniŋ sôp bidoŋ atu ba hamiŋ habobo hapetav Yisu ba hanaŋ, “E! Honaŋ aêŋ hadêŋ anyô bêŋ habôk da eka?” ");
INSERT INTO hot_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ma Yisu hanaŋ, “Yahanaŋ abô kambom, êŋ ma onaŋ abô êŋ bêŋ. Yahanaŋ abô avanôŋ, ma aisê ka huik ya?” ");
INSERT INTO hot_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Êŋ ma Anas hêv Yisu ba hi hadêŋ Kaiapas, anyô bêŋ habôk da. Ma yak atu ba ekak yani hamô denaŋ. ");
INSERT INTO hot_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita havuŋu atum hamiŋ ma enaŋ hik yani liŋ, “O ma ôpêŋ anêŋ ŋê ku te e?” Ma Pita hanaŋ, “Mi.” ");
INSERT INTO hot_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Êŋ ma anyô bêŋ habôk da anêŋ ŋê ku te hanaŋ, “Yahayê humiŋ alokwaŋ oliv kapô haviŋ yani.” Anyô ku êŋ ma ôpatu ba Pita haŋgasiv limbuk vê anêŋ thalaleŋ te. ");
INSERT INTO hot_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ma Pita hanaŋ hathak loŋbô, “Mi.” Kasana ma tale halaŋ. ");
INSERT INTO hot_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ewa Yisu hêk Kaiapas anêŋ unyak ba i anyô bêŋ Lom atu anêŋ unyak. Waklavôŋ Hale ba Hi anêŋ lôkbôk momaŋiniŋ lêk hayô ba Islael iniŋ ŋê bêŋbêŋ leŋiŋhaviŋ nêmô mabuŋ ênjêk Wapômbêŋ ma ek nêgê waklavôŋ êŋ. Ba intu êdô nimbitak nêyô anyô loŋ buyaŋ bêŋ êŋ anêŋ unyak. ");
INSERT INTO hot_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ma Pailat hi viyaiŋ ma hanaŋ, “Ôpêŋ hadum malê ba môlô udum abô ek yani?” ");
INSERT INTO hot_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ma enaŋ, “Aisê! Yani miŋ anyô kambom ami, êŋ ma tem miŋ yêlô naja yani êlêm êndêŋ o ami!” ");
INSERT INTO hot_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ma Pailat hanaŋ, “Yôv! Môlôda noja yani ba nundum abô esak môlôda unim abô balabuŋ.” Ma enaŋ, “Môlô avômalô Lom unim abô balabuŋ hanaŋ nena yêlô avômalô Islael miŋ hatôm naŋgik ôpatu ba hadum kambom vônô ami.” ");
INSERT INTO hot_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Enaŋ aêŋ ek abô sêbôk atu ba Yisu hanaŋ hathak loŋôndê atu ba tem ema esak tem injik anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Aêŋ ba Pailat hi unyak kapô hathak loŋbô ma halam Yisu halêm ma hanaŋ hik yani liŋ, “O ma avômalô Islael iniŋ kiŋ e?” ");
INSERT INTO hot_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma Yisu hanaŋ, “Oda anêm auk ba honaŋ abô êŋ mena anyôla hanaŋ hadêŋ o e?” ");
INSERT INTO hot_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma Pailat hanaŋ, “Hosoŋ nena ya anyô Islael e? Hudum malê ba oda anêm avômalô lôk ŋê bêŋbêŋ êbôk da ewa o ba êlêm hadêŋ ya?” ");
INSERT INTO hot_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ma Yisu hanaŋ, “Loŋ lôkliŋyak atu ba yahayabiŋ ma miŋ anêŋ pik êntêk ami. Yayabiŋ loŋ lôkliŋyak pik êntêk ma yenaŋ ŋê ku tem nijik vovak ek miŋ anyô te etak ya êndôk Islael iniŋ ŋê bêŋbêŋ baheŋiŋ ami. Ba intu yenaŋ loŋ lôkliŋyak ma miŋ hamô pik êntêk ami.” ");
INSERT INTO hot_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aêŋ ba Pailat hanaŋ, “O ma kiŋ!” Ma Yisu hanaŋ “Intu êŋ. Ya ma kiŋ. Wakamik hêv ya ba yahalêm pik êntêk ma avi havathu ya ek yaŋgik abô avanôŋ thô. Ma ôpatu ba hayala abô avanôŋ êŋ intu halaŋô yenaŋ abô.” ");
INSERT INTO hot_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ma Pailat hanaŋ, “Abô avanôŋ, êŋ ma malê te?” Yôv ma hale unyak viyaiŋ ba hi hadêŋ avômalô Islael hathak loŋbô ma hanaŋ, “Lêk yahalaŋô abô ba ôpêntêk ma anêŋ kambom mi. ");
INSERT INTO hot_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma yahathak yahasopa môlônim lemimhaviŋ nena sondabêŋ nômbêŋ intu anêŋ waklavôŋ Hale ba Hi ma yahatak anyô koladôŋ te ba hi hadêŋ môlô. Aêŋ ba lemimhaviŋ yatak môlô avômalô Islael unim kiŋ êntêk e?” ");
INSERT INTO hot_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ma elam lôklala, “Yani mi. Otak Balabas!” Balabas ma anyô sêbôk atu ba hik vovak hadêŋ ŋê bêŋbêŋ anêŋ Lom takatu ba eyabiŋ avômalô Islael. ");
INSERT INTO hot_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yôv ma Pailat hanaŋ ba evali Yisu. ");
INSERT INTO hot_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma ŋê vovak ewa yak lôkmaŋgiŋ atu ba epesaŋ hatôm kiŋ iniŋ kuluŋ ma ik halôk wakadôk. Ma ewa kiŋ anêŋ kwêv thalaleŋ daim te ma ik hathak yani. ");
INSERT INTO hot_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ma i hadêŋ yani ma enaŋ mathalaleŋ, “Waklêvôŋ mavi, avômalô Islael iniŋ kiŋ!” ma epetav yani. ");
INSERT INTO hot_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma Pailat hale yaiŋ hathak loŋbô ma hanaŋ hadêŋ avômalô, “Odaŋô! Tem yanja yani ende yaiŋ ek yaŋgik thô êndêŋ môlô nena lêk yahalaŋô abô yôv ba ôpêntêk ma anêŋ kambom mi.” ");
INSERT INTO hot_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Êŋ ma Yisu hale yaiŋ ma kuluŋ yak lôkmaŋgiŋ hamô wakadôk ma kwêv thalaleŋ atu hamô liŋkupik. Ma Pailat hanaŋ, “Ôŋgô yani atu êntêk!” ");
INSERT INTO hot_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Êŋ ma ŋê bêŋbêŋ êbôk da lôk iniŋ sôp bidoŋ êyê ma elam nena, “Nijik vônô esak a! Nijik vônô esak a!” Ma Pailat hanaŋ, “Lêk yahalaŋô abô yôv ba ôpêntêk anêŋ kambom mi! Aêŋ ba môlôda noja ba uŋgwik vônô esak a!” ");
INSERT INTO hot_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ma enaŋ viyaŋ, “Anyô êntêk hanaŋ nena yani ma Wapômbêŋ anêŋ Nakaduŋ. Ma yêlôaniŋ abô balabuŋ te hanaŋ nena naŋgik anyô anêŋ aêŋ vônô.” ");
INSERT INTO hot_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat halaŋô abô êŋ ba liŋhaka. ");
INSERT INTO hot_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ma hi unyak kapô ma hanaŋ hik Yisu liŋ, “Hôlêm anêŋ êsê?” Ma doŋtom Yisu bônôŋ iyom. ");
INSERT INTO hot_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ma Pailat hanaŋ, “Hôdô onaŋ yenaŋ abô viyaŋ e? Ondaŋô! Ya ma anyô lôk athêŋ ba ya hatôm yanaŋ ek nijik o vônô esak a mena yatak o ba nu la. Lêk holaŋô e?” ");
INSERT INTO hot_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ma hanaŋ, “Wapômbêŋ miŋ hêv athêŋ bêŋ êŋ hadêŋ o ami êŋ ma miŋ hatôm undum nômlate êndêŋ ya ami. Ba intu ôpatu ba hatak ya halôk bahem hathak yanida anêŋ auk intu anêŋ kambom ma bêŋ anôŋ ek anêm.” ");
INSERT INTO hot_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat halaŋô abô êŋ ma habôlêm loŋôndê ek etak Yisu ba ni. Ma doŋtom Islael iniŋ ŋê bêŋbêŋ elam lôklala, “Hotak ôpêntu ba hi, o ma miŋ kiŋ Lom iniŋ anyô te ami! Ôpatu ba hanaŋ nena yani kiŋ, êŋ ma hapôlik hathak Lom iniŋ kiŋ.” ");
INSERT INTO hot_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat halaŋô abô êŋ ma hawa Yisu hale yaiŋ ma halôk hamô anêŋ loŋ idum abô. Loŋ êŋ elam nena Loŋ Valu. Ma avômalô Hiblu elam loŋ êŋ nena “Gabata”. ");
INSERT INTO hot_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Habobo waklêvôŋ biŋ hadêŋ wak atu ba avômalô ethak epesaŋ i ek nêgê waklavôŋ Hale ba Hi. Ma Pailat hawa Yisu hale yaiŋ ma hanaŋ hadêŋ avômalô Islael, “Ôŋgô, môlônim kiŋ êntêk.” ");
INSERT INTO hot_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma thêlô elam lôklala, “Nônêm yani vê ek nijik esak a!” Ma Pailat hanaŋ, “Yaŋgik môlônim kiŋ esak alovalaŋaŋsiŋ e?” Ma ŋê bêŋbêŋ êbôk da enaŋ, “Yêlôaniŋ kiŋ intu Lom iniŋ kiŋ!” ");
INSERT INTO hot_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Êŋ ma Pailat hatak Yisu halôk ŋê vovak baheŋiŋ ek nijik vônô esak alovalaŋaŋsiŋ ma ewa ba i. ");
INSERT INTO hot_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yisu da hawa anêŋ alovalaŋaŋsiŋ ba hi malak viyaiŋ ba hayô loŋ te atu ba elam nena Leŋkadôk Lokwaŋ. Ma avômalô Hiblu elam nena Golgota. ");
INSERT INTO hot_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Loŋ êŋ ma thêlô êthôkwêŋ Yisu lôk anyô lokwaŋju hathak alovalaŋaŋsiŋ. Anyô yaŋ hamiŋ vi ma yaŋ hamiŋ vi ma Yisu hamiŋ malêvôŋ. ");
INSERT INTO hot_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat hanaŋ ba eto abô te hathak aseleŋ te ba ik loŋ hathak alovalaŋaŋsiŋ aêntêk, YISU ANÊŊ NASALET, AVÔMALÔ ISLAEL INIŊ KIŊ ");
INSERT INTO hot_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Eto abô êŋ hathak abô Hiblu lôk abô Lom, ma abô Glik ba intu avômalô bêŋ anôŋ êyê ba esam abô êŋ. Loŋ atu ba êthôkwêŋ Yisu ma habobo malak lôŋ. Ma loŋôndê êŋ ma avômalô bêŋ anôŋ ethak elom ba intu esam. ");
INSERT INTO hot_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Islael iniŋ ŋê bêŋbêŋ êbôk da êyê ma enaŋ hadêŋ Pailat, “Oto aêntêk, ‘Ôpêntêk hanaŋ nena yanida intu Islael iniŋ kiŋ.’ Ma miŋ oto nena, ‘Islael iniŋ kiŋ’ ami.” ");
INSERT INTO hot_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ma Pailat hanaŋ, “Dô, abô atu ba lêk yahato yôv ma ênjêk aêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ŋê vovak takatu ba ik Yisu hathak alovalaŋaŋsiŋ ewa anêŋ kwêv lôk sôp ba ibi sam hi ôdôŋ ayova. Ma ŋê vovak ewa tomtom ma kwêv te hamô denaŋ. Kwêv êŋ ma idu hathak sôp doŋtom iyom ma miŋ idu hathak sôp doho haviŋ ami. ");
INSERT INTO hot_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ma ŋê vovak enaŋ, “Alalô nato athêŋ esak valu ba natak êndôk tase ma nayôkwiŋ ek nagê nena opalê enja kwêv êntêk. Ma miŋ nakakaviŋ ami.” Thêlô idum aêŋ ek abô atu ba hêk Wapômbêŋ anêŋ kapya hik anôŋ nena, “Thêlô ibi yenaŋ kwêv sam ba ewa, ma ibi valu ek neja yenaŋ kwêv daim.” Aêŋ ba intu ŋê vovak idum aêŋ. ");
INSERT INTO hot_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ma avi doho imiŋ habobo alovalaŋaŋsiŋ atu ba êthôkwêŋ Yisu hathak. Yisu anêŋ talêbô lôk talêbô yaô ma Malia Kelopas yanavi, ma Malia anêŋ Magadala. ");
INSERT INTO hot_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ma anyô ku atu ba Yisu lahaviŋ bêŋ anôŋ hamiŋ habobo. Ma hayê talêbô lo anyô ku êŋ ma hanaŋ, “Wakatik, ôpêntu ma nalum.” ");
INSERT INTO hot_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ma hanaŋ hadêŋ anyô ku atu nena, “Avi intu ma lemtambô.” Aêŋ ba ôpêŋ hayabiŋ Malia hatôm anêŋ thalaleŋ te hamô yanida anêŋ unyak. ");
INSERT INTO hot_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ma Yisu hayala nena lêk hadum anêŋ ku yôv ma hanaŋ, “Yahathakmuniŋ” ek abô atu ba hamô Wapômbêŋ anêŋ kapya injik anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kolopak waiŋ maniŋ te hamô ba ewa nômlate hatôm kapôk ba esoŋ halôk waiŋ aleba lôthôk. Ma etak hathak alokwaŋ thaŋaŋ te anêŋ athêŋ nena “isop” ba êv halôk Yisu abôlêk. ");
INSERT INTO hot_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Hanum vêm ma hanaŋ, “Ku lêk yôv.” Êŋ ma laselo haŋgôli ma hatak dahô ba hi ma hama. ");
INSERT INTO hot_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wak êŋ ma wak nêpôpêk nômkama ek nêgê Sabat. Ma Sabat êŋ ma waklavôŋ bêŋ te ba Islael iniŋ ŋê bêŋbêŋ êdô ek ŋê takatu iniŋ kupik imiŋ alovalaŋaŋsiŋ. Ba intu enaŋ hik Pailat liŋ nena nijik veŋiŋlokwaŋ lu ek nema ketheŋ ek nênêm iniŋ kupik vê. ");
INSERT INTO hot_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Êŋ ma ŋê vovak i ma ik anyô yaŋ atu ba êthôkwêŋ haviŋ Yisu valokwaŋ lu. Yôv ma idum aêŋ hadêŋ anyô yaŋ. ");
INSERT INTO hot_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","34","Ma êyô ek Yisu ma êyê nena lêk hama yôv ba intu anyô vovak te habi bayavi hathak kôm ma ketheŋ oyaŋ ma thalaleŋ lôk ŋaŋ haŋgasô. Ma miŋ ik valokwaŋ lu ami. ");
INSERT INTO hot_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ôpatu ba hayê nôm êŋ hanaŋ abô avanôŋ ba hayala nena anêŋ abô ma avanôŋ ba intu hanaŋ bêŋ ek môlô nônêmimbiŋ. ");
INSERT INTO hot_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nôm takêŋ habitak ek abô te atu ba bôk hêk Wapômbêŋ anêŋ kapya injik anôŋ nena, “Tem miŋ nijik yani lokwaŋ te lu ami.” ");
INSERT INTO hot_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma “Tem thêlô nêgê anyô atu ba ibi.” ");
INSERT INTO hot_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Josep anêŋ Alimatia bôk halaŋô Yisu anêŋ abô ba hasopa. Ma doŋtom hakô ek Islael iniŋ ŋê bêŋbêŋ ba intu havuŋ anêŋ hêvhaviŋ. Ik Yisu hathak alovalaŋaŋsiŋ yôv ma hi hanaŋ hik Pailat liŋ ek enja anêŋ liŋkupik. Ma Pailat halaŋô anêŋ abô ba halôk ma yani hi hawa. ");
INSERT INTO hot_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimus hi haviŋ Josep. Yani ma anyô sêbôk atu ba hi hayê Yisu hadêŋ bôlôvôŋ. Yani hawa kamuŋ ôv mavi ju ba hatak hathak doŋtom ba anêŋ malaiŋ hatôm 30 kilo la. ");
INSERT INTO hot_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Thai epesaŋ ŋama êŋ ba esopa avômalô Islael iniŋ kobom ba ewa Yisu liŋkupik ba etak kamuŋ ôv mavi êŋ hathak ma ivuliv siŋ hathak sôp seleŋ. ");
INSERT INTO hot_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ku te hêk habobo loŋ atu ba êthôkwêŋ Yisu hathak. Ku êŋ ma valu abyaŋ lukmuk te hêk ba miŋ bôk êdô ŋama la hêk ami. ");
INSERT INTO hot_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Wak êŋ ma waklavôŋ atu ba avômalô Islael nêpôpêk i ek nêgê Sabat. Ma valu abyaŋ êdô ŋama hêk habobo. Aêŋ ba thai ewa Yisu anêŋ kupik ba i êdô hêk valu abyaŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sonda êŋ anêŋ wak te môŋ anêŋ lôkbôk momaŋiniŋ ma Malia anêŋ Magadala hi siô ma hayê nena lêk ibubi valu atu ba hamô lôv abôlêk vê. ");
INSERT INTO hot_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ma halaŋviŋ ba hi hadêŋ Saimon Pita thai lôk anyô ku atu ba Yisu lahaviŋ bêŋ anôŋ ma hanaŋ, “Anyôla ewa Anyô Bêŋ anêŋ kupik vê hêk siô ba yêlô athôŋ nena êdô yani hêk êsê.” ");
INSERT INTO hot_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Êŋ ma thai iviyô ba i siô. ");
INSERT INTO hot_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Thai luvi elaŋviŋ ba i ma anyô ku yaŋ atu hamôŋ ek Pita ba hayô siô môŋ. ");
INSERT INTO hot_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yani hakôm ba hayê lôv kapô ma hayê sôp seleŋ takatu ba ivuliv hathak iyom intu hamô. Ma miŋ habitak hayô valu abyaŋ kapô ami. ");
INSERT INTO hot_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ma Saimon Pita haveŋ yam hayô ma habitak hayô valu abyaŋ kapô ba hi. Ma hayê sôp seleŋ takatu ba ivuliv hathak ");
INSERT INTO hot_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","lôk sôp ivuliv thohavloma siŋ hathak intu hamô. Sôp ju êŋ intu lêk epesaŋ ba êdô yaŋ hamô buyaŋ ma yaŋ hamô buyaŋ. ");
INSERT INTO hot_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Êŋ ma anyô ku yaŋ atu ba hayô siô môŋ hi kapô ma hayê ba hêvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma doŋtom thai êthôŋ abô atu ba bôk hanaŋ hêk Wapômbêŋ anêŋ kapya nena tem injik Yisu liŋ imbiyô ênjêk ŋama esak loŋbô paliŋ. ");
INSERT INTO hot_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yôv ma ŋê ku ju êŋ êvôi malak. ");
INSERT INTO hot_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia halaŋ hamiŋ valu abyaŋ viyaiŋ ma hakôm ba hayê lôv kapô. ");
INSERT INTO hot_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma hayê aŋela ju ba iniŋ kwêv thapuk. Thai êmô loŋ bu atu ba Yisu anêŋ kupik hêk. Yaŋ hamô wakadôk ma yaŋ hamô valuvi. ");
INSERT INTO hot_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ma thai enaŋ hik Malia liŋ, “Livôŋ, holaŋ eka?” Ma hanaŋ, “Anyôla hawa yenaŋ Anyô Bêŋ anêŋ kupik vê ba miŋ yahayala loŋ atu ba êdô hêk ami.” ");
INSERT INTO hot_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hanaŋ aêŋ ma hik i liliŋ ma hayê Yisu hamiŋ ma doŋtom hathôŋ yani paliŋ. ");
INSERT INTO hot_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma Yisu hanaŋ, “Livôŋ, holaŋ eka? Ma hôbôlêm opalê?” Malia hasoŋ nena yani ma anyô hayabiŋ ku kapô ba hanaŋ, “Livôŋ, howa anêŋ kupik ba hôdô hêk êsê ma onaŋ ek yana yanja.” ");
INSERT INTO hot_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ma Yisu hanaŋ, “Malia.” Ma hasoŋ losauk ba hik i liliŋ ma hanaŋ hathak abô Hiblu nena, “Laboni!” Abô êŋ anêŋ ôdôŋ nena “Kêdôŋwaga.” ");
INSERT INTO hot_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ma Yisu hanaŋ, “Miŋ yahavôha ek Wakamik ami denaŋ ba intu otak ya ma nu êndêŋ yenaŋ ŋê ku ma onaŋ êndêŋ i, ‘Yana ek Wakamik ma môlônim Lemambô. Ma yana ek yenaŋ Wapômbêŋ ma môlônim Wapômbêŋ.’” ");
INSERT INTO hot_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yôv ma Malia anêŋ Magadala hi ma hanaŋ hadêŋ ŋê ku nena, “Lêk yahayê Anyô Bêŋ.” Ma abô takatu ba Yisu hanaŋ hadêŋ yani ma hanaŋ hadêŋ thêlô haviŋ. ");
INSERT INTO hot_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sonda êŋ anêŋ bôlôvôŋ ma ŋê ku ethak doŋtom. Thêlô êkô ek Islael iniŋ ŋê bêŋbêŋ ba intu ik unyak abôlêk siŋ. Ma Yisu halêm hamiŋ thêlô malêvôŋ ma hanaŋ, “Môlô kapôlômim ênjêk labali!” ");
INSERT INTO hot_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ma hik baŋ kapô lôk baya thô hadêŋ thêlô. Ŋê ku êyê Anyô Bêŋ ba leŋiŋmavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma hanaŋ hathak loŋbô, “Môlô kapôlômim ênjêk labali! Yahêv môlô ba u hatôm atu ba Wakamik hêv ya ba yahalêm.” ");
INSERT INTO hot_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Êŋ ma hayuv auk hathak thêlô ma hanaŋ, “Noja Lovak Matheŋ. ");
INSERT INTO hot_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ma môlô ôêv anyô iniŋ kambom vê êŋ ma iniŋ kambom tem nêm yak. Ma miŋ ôêv anyô iniŋ kambom vê ami êŋ ma iniŋ kambom tem êmô.” ");
INSERT INTO hot_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas ma ŋê ku laumiŋ ba lahavuju takatu te ba anêŋ athêŋ yaŋ nena Didimus. Yisu hayô ek ŋê ku vi ma yani miŋ hamô ami. ");
INSERT INTO hot_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Êŋ ma ŋê ku vi atu enaŋ hadêŋ yani, “Yêlô lêk ayê Anyô Bêŋ yôv!” Ma Tomas hanaŋ, “Miŋ yahayê anêŋ pôpô atu ba hamô baŋ lôk yahatak yabaheŋgwasiŋ halôk yani baya êŋ ami ma tem miŋ yanêmimbiŋ ami ma milôk.” ");
INSERT INTO hot_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sonda te hale ba hi ma Yisu anêŋ ŋê ku ethak doŋtom hathak loŋbô ba êmô unyak kapô. Ma Tomas hamô haviŋ. Thêlô ik unyak abôlêk siŋ ma doŋtom Yisu halêm hamiŋ thêlô malêvôŋ ma hanaŋ, “Môlô kapôlômim ênjêk labali.” ");
INSERT INTO hot_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ma hanaŋ hadêŋ Tomas, “Nôŋgô yabaheŋ! Ma ôsôm pôpô êntêk! Ma otak bahemgwasiŋ êndôk ya baya ek nôŋgô kôm lavôŋ. Otak auk thekthek lôk nôŋgô esak malem, ma nêmimbiŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ma Tomas hanaŋ, “Yenaŋ Anyô Bêŋ lôk Wapômbêŋ!” ");
INSERT INTO hot_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma Yisu hanaŋ, “Lêk hôyê ba intu hôêvhaviŋ e? Wapômbêŋ tem lamavi esak avômalô takatu ba miŋ êyê ami ma doŋtom êvhaviŋ.” ");
INSERT INTO hot_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yisu hadum lavôŋiŋ bêŋ anôŋ haviŋ ba anêŋ ŋê ku êyê. Ma doŋtom miŋ yahato abô takêŋ halôk kapya êntêk ami. ");
INSERT INTO hot_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yahato abô takêntêk ek môlô nônêmimbiŋ nena Yisu ma Mesia atu lôk Wapômbêŋ anêŋ Nakaduŋ. Lôk yahato ek môlô nônêmimbiŋ ba noja lôkmala esak anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yôv ma ŋê ku êmô kasukthôm atu anêŋ athêŋ nena Taibelias ma Yisu hik i thô hadêŋ i hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita lo Tomas, anêŋ athêŋ yaŋ nena Didimus, ma Nataniel anêŋ Kena hêk Galili, ma Sebedi anêŋ nakaduŋ luvi, ma Yisu anêŋ ŋê ku lokwaŋju, thêlô sapêŋ êmô loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ma Saimon Pita hanaŋ, “Yana yaŋgik alim.” Ma enaŋ, “Yêlô nasôk nambiŋ o.” Êŋ ma thêlô i ethak yeŋ te ma bôlôvôŋ êŋ ma êvôv alim te ami. ");
INSERT INTO hot_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wak hapup ma Yisu hamiŋ kasukthôm anêŋ daŋ. Ma anêŋ ŋê ku êyê yani ma doŋtom miŋ eyala ami. ");
INSERT INTO hot_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ma Yisu halam, “Aiyaŋ thêlô! Môlô alim mi, aêŋ e?” Ma enaŋ, “Intu êŋ.” ");
INSERT INTO hot_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma hanaŋ, “Notak yakseŋ êndôk yeŋ vianôŋ ma tem môlô noja alim doho.” Idum aêŋ ma ewa alim bêŋ anôŋ ba intu miŋ hatôm nêbôv yakseŋ esak ami. ");
INSERT INTO hot_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Anyô ku atu ba Yisu lahaviŋ bêŋ anôŋ hanaŋ hadêŋ Pita, “Intu ma Anyô Bêŋ!” Pita êŋ intu bôk habi anêŋ kwêv thilibuŋ thô ek indum ku. Ma halaŋô ôpêŋ anêŋ abô êŋ ma hik hathak loŋbô ma hasôv kisi halôk kasukthôm ba hayam ba hi. ");
INSERT INTO hot_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Thêlô ebobo kasukthôm daŋ hatôm 90 mita la ma ŋê ku vi êmô yeŋ ba êvôv yakseŋ haveŋ yam ma Pita hayam hamôŋ. ");
INSERT INTO hot_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Thêlô êlêm ethak liŋdaŋ ma êyê atum te hathaŋ hamô ma Yisu habôk alim lôk polom. ");
INSERT INTO hot_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma Yisu hanaŋ, “Alim doho êlêm!” ");
INSERT INTO hot_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ma Saimon Pita hayô hathak yeŋ ma havôv yakseŋ halêm hathak liŋdaŋ. Yakseŋ êŋ putup hathak alim daim lomaloma hatôm 153. Ma yakseŋ miŋ hatip ami. ");
INSERT INTO hot_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ma Yisu hanaŋ, “Nôlêm oŋgwaŋ alim!” Thêlô lêk eyala nena yani ma Anyô Bêŋ ba êkô ba te miŋ hanaŋ nena, “O ma opalê?” ami. ");
INSERT INTO hot_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ma Yisu hawa polom ba hi hêv hadêŋ thêlô ma hadum aêŋ hathak alim. ");
INSERT INTO hot_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Êntêk ma bôlôŋ te lô atu ba haviyô hathak loŋbô ba hik i thô hadêŋ anêŋ ŋê ku. ");
INSERT INTO hot_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Eyaŋ nôm yôv ma Yisu hanaŋ hadêŋ Saimon Pita, “Saimon, Jon anêŋ nakaduŋ, anêm lemhaviŋ ya ma bêŋ hamôŋ ek ŋê ku vi mena mi e?” Ma Pita hanaŋ, “Intu êŋ. Anyô Bêŋ, hoyala nena yaleŋhaviŋ o bêŋ anôŋ.” Ma Yisu hanaŋ, “Ombakôŋ yenaŋ boksipsip nali sapêŋ.” ");
INSERT INTO hot_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ma hanaŋ hathak loŋbô, “Saimon, Jon anêŋ nakaduŋ, lemhaviŋ ya e?” Ma Pita hanaŋ, “Intu êŋ. Anyô Bêŋ, hoyala nena yaleŋhaviŋ o.” Ma Yisu hanaŋ, “Oyabiŋ yenaŋ boksipsip.” ");
INSERT INTO hot_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ma hanaŋ bôlôŋ te lô “Saimon, Jon anêŋ nakaduŋ, lemhaviŋ ya e?” Yisu lêk hanaŋ hik Pita liŋ hatôm bôlôŋ lô nena “Lemhaviŋ ya e?” ba Pita kapô malaiŋ ma hanaŋ, “Anyô Bêŋ, o hoyala nômkama sapêŋ ba hoyala nena yaleŋhaviŋ o.” Ma Yisu hanaŋ, “Ombakôŋ yenaŋ boksipsip. ");
INSERT INTO hot_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yanaŋ avanôŋ biŋ êndêŋ o. Sêbôk ba hômô anyô muk denaŋ ma oda hothak huik kwêv ma hu hatôm odanêm lemhaviŋ. Ma doŋtom hoyalôv ma tem nêm bahem ek anyô yaŋ injik anêm kwêv ma endom o ek nu loŋ atu ba miŋ lemhaviŋ nu ami.” ");
INSERT INTO hot_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yisu hanaŋ abô êŋ ek injik loŋôndê atu ba Pita tem ema esak ek nêm athêŋ lôkmaŋgiŋ êndêŋ Wapômbêŋ. Yôv ma Yisu hanaŋ hadêŋ Pita, “Osopa ya!” ");
INSERT INTO hot_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita hik i liliŋ ma hayê anyô ku atu ba Yisu lahaviŋ bêŋ anôŋ hasopa thai. Ôpatu ba hayaŋ nôm hamô ma hakithiŋ Yisu ba hanaŋ, “Anyô Bêŋ, opalê intu tem enaŋ o bêŋ?” ");
INSERT INTO hot_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ma Saimon Pita hayê ôpêŋ ma hanaŋ, “Anyô Bêŋ, anyô êntêk tem êpôm malê?” ");
INSERT INTO hot_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ma Yisu hanaŋ, “Yaleŋhaviŋ nena ôpêŋ tem êmô endeba yandealêm am, o Pita miŋ anêm nômlate ami. Mi. Osopa ya iyom.” ");
INSERT INTO hot_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ma abô êŋ hi mayaliv ba ŋê takatu ba esopa Yisu elaŋô haviŋ ba esoŋ nena anyô ku êŋ tem miŋ ema ami. Yisu hanaŋ nena êmô endeba yani endelêm am, ma miŋ Pita anêŋ nômla ami. Ma doŋtom miŋ hanaŋ hathak ôpêŋ anêŋ ŋama ami. ");
INSERT INTO hot_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Anyô ku atu ba hanaŋ nôm takêŋ bêŋ ba hato halôk kapya êntêk intu yêlô ayala nena anêŋ abô ma avanôŋ. ");
INSERT INTO hot_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yisu hadum ku lomaloma bêŋ anôŋ haviŋ. Pik ma yaôna ba yakô miŋ hatôm nêndô kapya nômbêŋ atu ba eto lôkthô êmô ami. ");
INSERT INTO hot_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiapilus, bôk yahato kapya te hadêŋ o hathak nôm takatu ba bôk Yisu hadum lo hadôŋ, ");
INSERT INTO hot_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","môŋ anôŋ aleba hayô waklavôŋ hathak leŋ ba hi. Hamô pik denaŋ ma hathak Lovak Matheŋ anêŋ lôklokwaŋ ma hêv abô ku hadêŋ anêŋ aposel takatu ba bôk halam i yôv. ");
INSERT INTO hot_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yani hawa vovaŋ ba hama vêm ma haviyô hathak loŋbô ma hik i thô hadêŋ anêŋ ŋê takêŋ. Lôk hadum nômkama bêŋ anôŋ ek hik thô nena yani hamô lôkmala hathak loŋbô. Wak hatôm 40 ma hik i thô lôbôlôŋ hadêŋ thêlô ba hanaŋ abô hathak Wapômbêŋ anêŋ loŋ lôkliŋyak. ");
INSERT INTO hot_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wak te ma hayaŋ nôm haviŋ thêlô ma hanaŋ, “Noyabiŋ nôm atu ba Wakamik bôk havak abô yôv ek nêm êndêŋ môlô hatôm atu ba bôk yahanaŋ ba olaŋô yôv. Ma miŋ notak Jelusalem ami. ");
INSERT INTO hot_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon bôk hathik avômalô halôk ŋaŋ ma kasana ma tem nisik môlô esak Lovak Matheŋ.” ");
INSERT INTO hot_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ma aposel êmô haviŋ Yisu ma enaŋ hik yani liŋ nena, “Anyô Bêŋ, lêk êntêk ma tem undum ek alalô avômalô Islael naja alalôaniŋ kiŋ esak loŋbô e?” ");
INSERT INTO hot_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma Yisu hanaŋ, “Êŋ ma miŋ môlô unim nômla ek noyala waklavôŋ atu ba Kamik hatak ami. Hathak anêŋ lôklokwaŋ yanida hayabiŋ wak êŋ. ");
INSERT INTO hot_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ma Lovak Matheŋ hayô hamô môlô, ma tem noja lôklokwaŋ. Ma tem nonaŋ yenaŋ abô imiŋ Jelusalem lôk Judia sapêŋ ma Samalia lôk ni endeba êndôk pik anêŋ daŋ.” ");
INSERT INTO hot_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hanaŋ abô êŋ yôv, ma ewa yani hathak leŋ ba hi. Thêlô êyê imiŋ ma buliv hava yani siŋ ba êthôŋ. ");
INSERT INTO hot_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Thêlô ititiŋ leŋ denaŋ ma ketheŋ oyaŋ ma anyô ju lôk nômkama thapuk ba imiŋ thêlô malêvôŋ. ");
INSERT INTO hot_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma enaŋ, “Ŋê Galili, umiŋ ba utitiŋ leŋ eka? Yisu doŋtom êntêk lêk Lambô hawa vê hêk môlô ba hi leŋ ma tem endelêm aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Vêm ma thêlô etak Dum Oliv ma ele i Jelusalem. Dum Oliv êŋ hêk habobo Jelusalem hatôm kilomita te iyom. ");
INSERT INTO hot_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Êyô Jelusalem ma i unyak kapô vuliŋ atu ba ethak êmô. Thêlô iniŋ athêŋ ma Pita lo Jon ma Jems lo Andulu ma Pilip lo Tomas ma Batolomiu lo Matyu ma Jems, Alpius nakaduŋ, lôk Saimon anyô Selot te, ma Judas, Jems nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wak sapêŋ ma thêlô ethak doŋtom ba eteŋ mek hi ba hi. Ma avi doho lôk Malia, Yisu talêbô, lôk anêŋ iviyaŋ êmô haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ma wak te ma Pita haviyô hamiŋ ŋê êvhaviŋ hatôm 120 malêvôŋ ma hanaŋ, ");
INSERT INTO hot_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Aiyaŋ thêlô, abô te hêk Wapômbêŋ anêŋ kapya ba lêk hik anôŋ. Abô êŋ ma Lovak Matheŋ bôk hanaŋ hale Devit abôlêk hathak Judas, ôpatu ba hik Yisu thô hadêŋ ŋê takatu ba evaloŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yani ma alalô te atu ba bôk hadum ku êntêk haviŋ alalô.” ");
INSERT INTO hot_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas hêv pik bute vuli hathak valuseleŋ atu ba hadum kambom ba hawa. Êŋ ma hêv yak halôk pik buêŋ ba lasoam hapup ba la haŋgasô hale yaiŋ. ");
INSERT INTO hot_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Avômalô Jelusalem sapêŋ elaŋô abô êŋ ba intu elam pik buêŋ hathak iniŋ abô nena “Akeldama”. Anêŋ ôdôŋ nena, “Pik atu ba thalaleŋ hathaŋ.”) ");
INSERT INTO hot_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Êŋ ma Pita hanaŋ, “Hatôm bôk eto hêk Kapya Yeŋ nena, “‘Anêŋ unyak tem ŋgathiniŋ; ma miŋ notak anyôla ek êmô ami.’ Ma buyaŋ hanaŋ nena, “‘Anyô yaŋ enja anêŋ loŋ lôk anêŋ ku.’ ");
INSERT INTO hot_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Aêŋ ba alalô natak anyô te atu ba Anyô Bêŋ Yisu hamô haviŋ alalô denaŋ ma yani hamô haviŋ alalô wak nômbêŋ intu sapêŋ, ");
INSERT INTO hot_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","môŋ ma waklavôŋ atu ba Jon hathik Yisu halôk ŋaŋ aleba hayô wakma Lambô hawa yani vê hêk alalô ba hi malak leŋ. Anyô êŋ tem imbiŋ alalô ek enaŋ Yisu anêŋ haviyô hathak loŋbô bêŋ êndêŋ avômalô.” ");
INSERT INTO hot_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yôv ma etak anyô lokwaŋju. Yaŋ ma Josep, elam nena Balsabas, ma athêŋ yaŋ ma Jastas. Ma anyô yaŋ ma Matias. ");
INSERT INTO hot_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ma eteŋ mek nena, “Anyô Bêŋ, hoyala avômalô sapêŋ iniŋ kapôlôŋiŋ. Nuŋgwik thô nena hotak anyô ju êntêk yaŋ sê ");
INSERT INTO hot_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ek enja ku aposel atu ba bôk Judas hatak ba hi anêŋ loŋ.” ");
INSERT INTO hot_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yôv ma ibi valu ek nêgê nena athêŋ yaŋ sê habitak. Êŋ ma etak Matias ek imbitak aposel imbiŋ thêlô laumiŋ ba lahavute takatu. ");
INSERT INTO hot_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Waklavôŋ Pentikos hayô, êŋ ma avômalô êvhaviŋ ethak doŋtom ba êmô unyak te. ");
INSERT INTO hot_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ma ketheŋ oyaŋ ma nômlate diŋdiŋ halêm anêŋ leŋ ba anêŋ pôk ma hatôm lovak bêŋ te ba hayô hamô unyak atu ba thêlô êmô siŋ. ");
INSERT INTO hot_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma êyê nômlate hatôm atum dahalaŋ hatakalek ba hayô hamô thêlô tomtom. ");
INSERT INTO hot_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma Lovak Matheŋ hayô hava thêlô sapêŋ kapôlôŋiŋ siŋ ba enaŋ abô masôm lomaloma hatôm Lovak Matheŋ hêv hadêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Avômalô Islael takatu ba êmô Wapômbêŋ vibiŋ bôk etak pik lôbôlôbô takatu ba êmô ma êlêm Jelusalem ek Pentikos. ");
INSERT INTO hot_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma elaŋô diŋdiŋ ba êlêm ethak doŋtom. Ma eboloba kambom hathak elaŋô ŋê êŋ enaŋ abô hathak thêlô tomtom da iniŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ma esoŋ kambom ba enaŋ hik thêlôda liŋ, “Thêlô ma ŋê Galili iyom. Malê te aêŋ am? ");
INSERT INTO hot_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Aisê ba alalô alaŋô thêlô enaŋ abô hathak alalôaniŋ abô tomtom? ");
INSERT INTO hot_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Alalô ma anêŋ Patia lo Midia ma Ilam lo Mesopotemia ma Judia lo Kapadosia ma Pontus lo Esia ");
INSERT INTO hot_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma Plijia lo Pampilia ma Ijip lôk Libia bute atu habobo Sailini ma ŋê doho anêŋ Lom. ");
INSERT INTO hot_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Ma vi ma avômalô Islael, ma vi ma avômalô loŋ buyaŋ takatu ba ibitak êyô Islael iniŋ êvhaviŋ kapô.) Ma doho anêŋ Klit lo Alebia. Ma doŋtom alalô alaŋô thêlô enaŋ abô hathak nômbêŋ atu ba Wapômbêŋ hadum hathak alalôaniŋ abô tomtom.” ");
INSERT INTO hot_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ma avômalô sapêŋ esoŋ kambom ba itutuniŋ leŋiŋkadôk ma enaŋ hik thêlôda liŋ nena, “Nôm êŋ anêŋ ôdôŋ ma aisê?” ");
INSERT INTO hot_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma doŋtom vi ibi thêlô liliŋ ba enaŋ, “Inum waiŋ bêŋ anôŋ ba elo molo.” ");
INSERT INTO hot_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Êŋ ma Pita haviyô hamiŋ aposel laumiŋ ba lahavute malêvôŋ ma halam lôklokwaŋ nena, “Môlô avômalô Islael lôk avômalô takêntêk ba lêk ômô Jelusalem, nodaŋô yenaŋ abô katô. Tem yanaŋ nôm êŋ anêŋ ôdôŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Lêk ma lôkbôk denaŋ hatôm 9 kilok. Ba intu miŋ nosoŋ nena ŋê êntêk inum waiŋ ba elo molo ami. ");
INSERT INTO hot_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mi, nôm êŋ ma hatôm plopet Joel bôk hanaŋ, ");
INSERT INTO hot_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘Wapômbêŋ hanaŋ nena habobo pik lo leŋ anêŋ daŋ ma tem yaŋgasô yenaŋ Lovak Matheŋ êyômô avômalô sapêŋ. Ma nalumi anyô lo avi tem yanêm yenaŋ abô êndêŋ i ba nenaŋ abô êtôm plopet. Ma môlônim apenena tem netulak ba nêgê wêŋ. Ma môlônim anyô boŋnena tem nêgê niaviŋ. ");
INSERT INTO hot_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ma tem yaŋgasô yenaŋ Lovak Matheŋ êyômô yenaŋ anyô lo avi ku êndêŋ waklavôŋ êŋ ma tem yanêm yenaŋ abô êndêŋ i ba nenaŋ abô êtôm plopet. ");
INSERT INTO hot_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma tem yandum nômbithi ênjêk leŋ, ma yandum lavôŋiŋ ênjêk pik. Thalaleŋ lôk atum ma atum yova bêŋ tem imbitak. ");
INSERT INTO hot_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ma wak tem ende i liliŋ ba imbitak momaŋiniŋ, ma ayôŋ tem ende i liliŋ ba imbitak êtôm thalaleŋ. Vêm ma Anyô Bêŋ anêŋ waklavôŋ lôkmaŋgiŋ bêŋ atu tem êlêm. ");
INSERT INTO hot_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma avômalô takatu ba elam Anyô Bêŋ anêŋ athêŋ, tem nêm i bulubiŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Avômalô Islael, nodaŋô abô êntêk. Wapômbêŋ bôk hadum ku lôklokwaŋ anôŋ lôk nômbithi ma lavôŋiŋ hathak Yisu anêŋ Nasalet anêŋ baŋ hamô môlô malêvôŋ ba hik thô nena yanida hêv ôpêŋ ba halêm. Ba bôk oyala nôm takêŋ yôv. ");
INSERT INTO hot_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ma Wapômbêŋ hatak yani halôk môlô bahemim hatôm bôsêbôk ba lahabi lôk anêŋ auk ek nôm takêŋ imbitak aêŋ. Ma môlô udum ba ŋê kambom ik yani loŋ hathak alovalaŋaŋsiŋ ba hama. ");
INSERT INTO hot_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ma doŋtom Wapômbêŋ hik yani liŋ ba haviyô hathak loŋbô ba hawa yani vê hêk ŋama anêŋ vovaŋ bêŋ ek malê nena ŋama miŋ hatôm embaloŋ yani loŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Devit bôk hanaŋ hathak yani nena, “‘Yahayê Anyô Bêŋ hamô haviŋ ya wak nômbêŋ intu sapêŋ. Yani hamô habobo ya ba intu miŋ hatôm nômlate esale ya thô ami. ");
INSERT INTO hot_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Aêŋ ba yaleŋmavi anôŋ ba yahabôya. Ma yaleŋviŋkupik hêv ma. ");
INSERT INTO hot_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ek malê nena tem miŋ ôndô ya êmô ŋê ŋama iniŋ loŋ ami, ma tem miŋ otak anêm Anyô Matheŋ ek epalê ênjêk siô ami. ");
INSERT INTO hot_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bôk huik loŋôndê lôkmala thô hadêŋ ya yôv, ma tem yamô imbiŋ o ba undum yaleŋmavi anêŋ dôêŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Aiyaŋ thêlô, yahanaŋ avanôŋ biŋ nena bumalô Devit bôk hama ba elav yôv. Ma anêŋ siô êntêk hêk denaŋ aleba lêk. ");
INSERT INTO hot_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ma doŋtom Devit ma plopet te ba hayala nena Wapômbêŋ bôk havak abô nena embeŋ yam ma tem etak lim lukmuk te ek imbitak kiŋ êtôm yanida. ");
INSERT INTO hot_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit bôk hayala nôm atu ba tem imbitak embeŋ yam ba hanaŋ hathak Mesia atu ba Wapômbêŋ tem nêm lôkmala êndêŋ yani ba imbiyô esak loŋbô. Ba intu hanaŋ nena tem miŋ nêndô yani êmô ŋê ŋama iniŋ loŋ ba kupik epalê ami. ");
INSERT INTO hot_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ôpêŋ ma Yisu atu ba Wapômbêŋ bôk hik yani liŋ. Ma yêlô sapêŋ ayê nôm êŋ haviŋ ba êntêk anaŋ bêŋ hadêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ma Wapômbêŋ hawa Yisu ba hatak yani hamô baŋ vianôŋ yôv. Ma hêv Lovak Matheŋ atu ba bôk havak abô ek nêm êndêŋ yani ma êntêk lêk haŋgasô hayô hamô yêlô ba intu lêk ôyê lo olaŋô. ");
INSERT INTO hot_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit da miŋ hi malak leŋ hatôm Yisu ami, ma doŋtom hanaŋ, “‘Anyô Bêŋ Wapômbêŋ hanaŋ hadêŋ yenaŋ Anyô Bêŋ Mesia nena, “Ômô yabaheŋ vianôŋ ");
INSERT INTO hot_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","endeba yatak ŋê takatu ba ik vovak hadêŋ o nêmô vemkapô vibiŋ am.” ’ ");
INSERT INTO hot_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Aêŋ ba môlô avômalô Islael sapêŋ, noyala abô êntêk katô. Yisu atu ba môlô uik hathak a, Wapômbêŋ hadum ba habitak Anyô Bêŋ lôk Mesia.” ");
INSERT INTO hot_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Thêlô elaŋô Pita anêŋ abô takêŋ ma habi thêlô kapôlôŋiŋ vose. Ma enaŋ hadêŋ yani lôk aposel vi nena, “Aiyaŋ thêlô, yêlô nandum malê?” ");
INSERT INTO hot_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ma Pita hanaŋ, “Môlô tomtom node kapôlômim liliŋ ba nusik ŋaŋ esak Yisu Kilisi anêŋ athêŋ ek Wapômbêŋ nêm môlônim kambom vê ma nêm Lovak Matheŋ êndêŋ môlô êtôm anêŋ wapôm. ");
INSERT INTO hot_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Havak abô êŋ ek avômalô takatu ba alalôaniŋ Wapômbêŋ tem endam i, môlô lôk unim avômena ma avômalô takatu ba êmô daimbô.” ");
INSERT INTO hot_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ma Pita hanaŋ abô bêŋ anôŋ haviŋ hadêŋ thêlô ba hanaŋ nena, “Noyabiŋ am. Nônêm amda sa ba nôsôv ênjêk avômalô kambom takêŋ ek miŋ nôpôm vovaŋ atu ba tem êpôm i ami.” ");
INSERT INTO hot_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aêŋ ba ŋê takatu ba ewa Pita anêŋ abô intu ithik ŋaŋ. Ma wak êŋ ma avômalô hatôm 3,000 êlêm haviŋ avômalô takatu ba bôk êvhaviŋ yôv. ");
INSERT INTO hot_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ma thêlô lôklokwaŋ ek nedaŋô aposel iniŋ abô lôk ethak doŋtom haviŋ i ma eyaŋ polom lo inum waiŋ matheŋ atu ba Yisu bôk hêv lôk eteŋ mek haviŋ i. ");
INSERT INTO hot_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ma aposel idum lavôŋiŋ lôk nômbithi bêŋ anôŋ ba avômalô sapêŋ êyê ba esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma avômalô êvhaviŋ sapêŋ ethak doŋtom haviŋ i ma miŋ leŋvi iniŋ nômkama ami. Iniŋ nômkama lôkthô ma êdô hamô ek hêv thêlô sapêŋ sa. ");
INSERT INTO hot_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Thêlô ethak êv iniŋ pik lôk nômkama ek nênêm vuli ma ewa vuli takêŋ ba êv avômalô takatu ba nômkama vi mi sa. ");
INSERT INTO hot_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ma wak nômbêŋ intu ma thêlô ethak doŋtom êmô unyak matheŋ anêŋ piklêvôŋ. Ma ethak eyaŋ nôm haviŋ i lôk leŋiŋmavi ma kapôlôŋiŋ labalina. ");
INSERT INTO hot_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Lôk êbô Wapômbêŋ anêŋ athêŋ. Êŋ ma avômalô sapêŋ leŋiŋmavi anôŋ hathak i. Ma wak nômbêŋ intu sapêŋ ma Anyô Bêŋ hêv avômalô doho bulubiŋ ba hêv i ibitak êyô ŋê êvhaviŋ kapô haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wak te ma Pita lo Jon i unyak matheŋ hadêŋ wakma eteŋ mek. Wakma êŋ ma hatôm 3 kilok yaŋsiŋ. ");
INSERT INTO hot_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Êyô ma êyê ewa anyô va kambom te ba êlêm. Bôk evathu yani aêŋ. Ma wak nômbêŋ intu ma ewa yani ba i êdô hamô unyak matheŋ anêŋ badêŋ abôlêk atu ba elam nena Loŋ Kêkêlô. Êdô yani hamô loŋ êŋ ek epetenak ek avômalô takatu ba i unyak matheŋ anêŋ piklêvôŋ ek nênêm valu êndêŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ôpêŋ hayê Pita lo Jon êlêm ek ini unyak matheŋ kapô, êŋ ma halam ek thai nênêm valu êndêŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita lo Jon ititiŋ yani lôklokwaŋ. Ma Pita hanaŋ, “Nôŋgô yai!” ");
INSERT INTO hot_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Êŋ ma ôpêŋ hik i liliŋ hadêŋ thai ma hasoŋ nena tem nênêm nômla êndêŋ yani la. ");
INSERT INTO hot_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma Pita hanaŋ, “Ya valu mi. Ma doŋtom nôm atu ba yahawa ma tem yanêm êndêŋ o. Hathak Yisu Kilisi anêŋ Nasalet anêŋ athêŋ, umbiyô ombeŋ.” ");
INSERT INTO hot_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ma Pita havaloŋ ôpêŋ baŋ vianôŋ ba havôv yani haviyô. Ma ketheŋ oyaŋ ôpêŋ vagigiŋ lôk vakapô habitak lôklokwaŋ. ");
INSERT INTO hot_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Êŋ ma yani hasôv kisi ma haveŋ. Ma hi unyak matheŋ anêŋ piklêvôŋ haviŋ thai. Ma haveŋ ba hasôv kisi hathak loleŋ loleŋ ba habô Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ma avômalô sapêŋ êyê yani haveŋ ba habô Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ma eyala nena ôpêŋ ma anyô petenak atu ba hathak hamô unyak matheŋ abôlêk atu ba elam nena Loŋ Kêkêlô, êŋ ma eboloba ba dahôlôŋiŋ hi. ");
INSERT INTO hot_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ma anyô petenak atu havaloŋ Pita lo Jon, êŋ ma avômalô sapêŋ esoŋ kambom ba elaŋviŋ êlêm hadêŋ thêlô halôk kapo daŋ atu ba elam nena Solomon anêŋ Kapo Daŋ. ");
INSERT INTO hot_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita hayê ma hanaŋ hadêŋ thêlô nena, “Avômalô Islael, osoŋ kambom ba utitiŋ yai lôklokwaŋ eka? Osoŋ nena yai adum ôpêntêk mavi hathak yaidaniŋ lôklokwaŋ lôk kobom matheŋ e? Mi anôŋ! ");
INSERT INTO hot_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ablaham lo Aisak ma Jekop lôk alalôaniŋ bumalô thêlô iniŋ Wapômbêŋ iyom intu hadum nôm êŋ ek nêm athêŋ lôkmaŋgiŋ êndêŋ anêŋ anyô ku Yisu. Môlô bôk otak ôpêŋ ek nijik vônô. Ma Pailat lahaviŋ etak yani, ma doŋtom môlô ôvôliŋ dômim hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Avanôŋ, môlô ôvôliŋ dômim hadêŋ Anyô Matheŋ lôk Anyô Thêthôŋ atu ma onaŋ hik Pailat liŋ ek etak ôpatu ba bôk hik anyô vônô êlêm êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ôpatu ba lôkmala anêŋ ôdôŋ ma uik vônô. Ma doŋtom Wapômbêŋ hik yani liŋ hathak loŋbô hêk ŋama. Ma yai bôk ayê nôm takêŋ ba êntêk lêk anaŋ abô hathak. ");
INSERT INTO hot_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Êvhaviŋ hathak Yisu anêŋ athêŋ iyom hadum ba ôpatu ba ôyê lo oyala lêk hawa lôklokwaŋ. Yani habitak mavi anôŋ hatôm ôyê hathak Yisu anêŋ athêŋ lôk êvhaviŋ atu ba halêm anêŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Aiyaŋ thêlô, yahayala nena môlô lôk unim avaka miŋ oyala ôpêŋ katô ami ba intu udum kambom hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma doŋtom sêbôk ma Wapômbêŋ hanaŋ hadêŋ plopet sapêŋ ba eto nena anêŋ Mesia tem enja vovaŋ. Aêŋ ba unim kambom atu udum ma Wapômbêŋ anêŋ abô êŋ lêk hik anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Aêŋ ba node kapôlômim liliŋ ba nosopa Wapômbêŋ ek nêm môlônim kambom vê lôk nêm lovak êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ma nêm anêŋ Mesia atu ba bôk hatak ek nêm êndêŋ môlô. Mesia êŋ ma Yisu atu. ");
INSERT INTO hot_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ma lêk yani hamô malak leŋ ba hayabiŋ waklavôŋ atu ba Wapômbêŋ bôk hatak ek nômkama sapêŋ imbitak lukmuk esak loŋbô êtôm sêbôk atu ba yani havak abô ba hanaŋ ba anêŋ plopet matheŋ enaŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hatôm Mose bôk hanaŋ, ‘Wapômbêŋ unim Anyô Bêŋ tem etak plopet te êtôm ya ba imbitak anêŋ môlô malêvôŋ. Ba intu nodaŋô anêŋ abô takatu ba hanaŋ bêŋ hadêŋ môlô katô. ");
INSERT INTO hot_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ma ôpatu ba miŋ halaŋô plopet êŋ anêŋ abô ami, ma tem nênêm yani vê ênjêk anêŋ avômalô ba nimbuliŋ yani vi dedauŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Samuel lôk plopet takatu ba ibitak eveŋ yam bôk enaŋ hathak waklavôŋ atu ba lêk habitak. ");
INSERT INTO hot_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Môlô ma plopet takêŋ iniŋ nali. Ma abô atu ba Wapômbêŋ bôk havak haviŋ libumi yôv, abô êŋ êntêk havaloŋ môlô loŋ denaŋ. Hatôm bôk hanaŋ hadêŋ Ablaham, ‘Hathak anêm libumi, ma tem avômalô pik sapêŋ neja mek mavi.’ ");
INSERT INTO hot_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ba intu Wapômbêŋ hik anêŋ anyô ku liŋ ma hêv halêm hadêŋ môlô hamôŋ ek nêm mek mavi êndêŋ môlô lôk ende môlô tomtom liliŋ ênjêk unim kambom takatu ba udum.” ");
INSERT INTO hot_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita lo Jon enaŋ abô hadêŋ avômalô imiŋ denaŋ, ma ŋê êbôk da lôk unyak matheŋ anêŋ sôp bidoŋ iniŋ anyô vovak laik ma Sadyusi doho êyô ek thai. ");
INSERT INTO hot_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Thêlô leŋiŋmaniŋ hathak thai êdôŋ avômalô nena Yisu bôk haviyô hêk ŋama ba intu avômalô ŋama sapêŋ tem nimbiyô esak loŋbô aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Lêk yaŋsiŋ habôk ba intu evaloŋ thai ba êdô hamô koladôŋ aleba hayaŋ wak bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma doŋtom avômalô bêŋ anôŋ elaŋô thai iniŋ abô ba êvhaviŋ. Ba ŋê takatu ba êvhaviŋ lêk halumbak hi habobo 5,000. ");
INSERT INTO hot_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Haviyô hayaŋ ma ŋê bêŋbêŋ eyabiŋ avômalô lôk ŋê bêŋbêŋ ma ŋê lôkauk hathak abô balabuŋ ethak doŋtom êmô Jelusalem. ");
INSERT INTO hot_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas, anyô bêŋ habôk da, lôk Kaiapas ma Jon lo Aleksanda lôk anyô bêŋ habôk da anêŋ thalaleŋ vi êmô haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ma ewa thai êlêm ma enaŋ hik thai liŋ nena, “Lôklokwaŋ lôk athêŋ alê intu udum ôpêŋ mavi hathak?” ");
INSERT INTO hot_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ma Lovak Matheŋ hava Pita kapô siŋ ba hanaŋ hadêŋ thêlô nena, “Ŋê bêŋbêŋ lôk ŋê eyabiŋ avômalô, nodaŋô yenaŋ abô! ");
INSERT INTO hot_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yai êv anyô va kambom êntêk sa ba intu udum ek nonaŋ yai bêŋ lôk lemimhaviŋ noyala nena yai adum yani mavi aisê e? ");
INSERT INTO hot_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Aêŋ ba môlô lôk avômalô Islael sapêŋ noyala katô nena anyô va kambom êntêk lêk habitak mavi ba hamiŋ môlô malemim hathak Yisu Kilisi anêŋ Nasalet anêŋ athêŋ. Bôk uik yani vônô hathak a, ma doŋtom Wapômbêŋ hik yani liŋ hêk ŋama. ");
INSERT INTO hot_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yani ma “‘valu atu ba môlô ŋê olav unyak ôpôlik hathak, ma lêk habitak valu landiŋ anôŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yisu da iyom anêŋ athêŋ hatôm nêm alalô bulubiŋ. Ma athêŋ yaŋ miŋ hêk pik lo leŋ sapêŋ ek nêm alalô bulubiŋ ami. Mi.” ");
INSERT INTO hot_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ma thêlô êyê Pita lo Jon imiŋ lôklokwaŋ ma kô mi, ma eyala nena thai ma ŋê oyaŋ ba miŋ bôk ethak unyak ami. Êŋ ma thêlô esoŋ kambom ba leŋiŋhabi nena bôk êmô haviŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma êyê anyô va kambom atu lêk mavi ba hamiŋ haviŋ thai ba intu thêlô abô mi ek nenaŋ. ");
INSERT INTO hot_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Êŋ ma enaŋ ek neja Pita lo Jon vê ênjêk Sanhedlin anêŋ unyak ma nede yaiŋ ba ini. Ma ele yaiŋ ba i ma thêlô êbôlêm auk. ");
INSERT INTO hot_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ba enaŋ, “Alalô nandum malê esak anyô ju êntêk? Avômalô Jelusalem sapêŋ lêk eyala yôv nena thai idum lavôŋiŋ bêŋ te ba miŋ hatôm alalô nasi ami. ");
INSERT INTO hot_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma doŋtom alalô napôm loŋôndê te ek abô êŋ miŋ ni mayaliv ênjêk avômalô malêvôŋ ami. Aêŋ ba nanaŋ lôklokwaŋ êndêŋ thai nena miŋ nenaŋ abô esak athêŋ êŋ êndêŋ avômalô la esak loŋbô ami.” ");
INSERT INTO hot_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yôv ma elam thai êlêm hathak loŋbô ma enaŋ lôklokwaŋ nena miŋ nenaŋ abô êŋ lôk nêndôŋ avômalô esak Yisu anêŋ athêŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ma doŋtom Pita lo Jon enaŋ viyaŋ, “Malê intu ba mavi hêk Wapômbêŋ ma ek yai nandum? Nasopa môlônim abô mena Wapômbêŋ anêŋ abô? ");
INSERT INTO hot_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yai miŋ hatôm bônôŋ esak nôm takatu ba ayê lo alaŋô ami.” ");
INSERT INTO hot_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ma Sanhedlin enaŋ lôklokwaŋ ek thai nêmô bônôŋ, êŋ ma etak thai ba i. Avômalô sapêŋ êbô Wapômbêŋ anêŋ athêŋ hathak nôm atu ba lêk idum ba intu miŋ hatôm nêpôm loŋôndê la ek nênêm vovaŋ êndêŋ thai ami. ");
INSERT INTO hot_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ek malê nena ôpatu ba habitak mavi ma anêŋ sondabêŋ hatôm 40. Ba intu eyala nena Wapômbêŋ iyom hatôm indum nôm êŋ. ");
INSERT INTO hot_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Etak Pita lo Jon ba i hadêŋ avômalô êvhaviŋ. Ma enaŋ abô takatu ba ŋê bêŋbêŋ êbôk da lôk ŋê bêŋbêŋ enaŋ hadêŋ thai. ");
INSERT INTO hot_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Thêlô elaŋô aêŋ ma lôkthô êv veŋiŋbôlêk liŋ ba eteŋ mek hadêŋ Wapômbêŋ nena, “Anyô Bêŋ, nômkama sapêŋ anêŋ alaŋ, bôk hopesaŋ pik lo leŋ ma ŋgwêk lôk nômkama sapêŋ atu ba êmô kapô. ");
INSERT INTO hot_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sêbôk ma honaŋ abô hathak Lovak Matheŋ hale anêm anyô ku ma yêlôaniŋ bumalô Devit abôlêk. Ba hanaŋ aêntêk, “‘Avômalô pik sapêŋ leŋiŋŋaŋa eka? Lôk ibutiŋ abôyaŋ ek nijik vovak êndêŋ Wapômbêŋ eka? ");
INSERT INTO hot_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pik iniŋ kiŋ lôkthô êpôpêk i ek nijik vovak. Lôk ŋê bêŋbêŋ pik sapêŋ ethak doŋtom ek nêmô Anyô Bêŋ lôk anêŋ Mesia lu.’ ");
INSERT INTO hot_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Avanôŋ biŋ, Helot Antipas lo Pontius Pailat ma ŋê loŋ buyaŋ lôk avômalô Islael bôk ethak doŋtom êmô malak lôŋ êntêk ba idum ek nêmô anêm anyô ku matheŋ Yisu lu, ôpatu ba bôk holam yôv ek imbitak anêm Mesia. ");
INSERT INTO hot_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Thêlô idum nômkama sapêŋ hatôm anêm auk lôk lôklokwaŋ atu ba bôk lemhabi nena tem imbitak aêŋ. ");
INSERT INTO hot_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Anyô Bêŋ, lemimbi abô takatu ba evak ba enaŋ ek indum yêlô nakô ba intu nêm yêlô anêm ŋê ku sa ek nanaŋ anêm abô lôklokwaŋ ma miŋ nakô ami. ");
INSERT INTO hot_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ma otak bahem êyôŋgêk avômalô lôk lijiŋ ba undum i mavi lôk undum lavôŋiŋ lôk nômbithi lomaloma esak anêm anyô ku matheŋ Yisu anêŋ athêŋ.” ");
INSERT INTO hot_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Thêlô eteŋ mek yôv ma loŋ atu ba êmô halowaliŋ. Ma Lovak Matheŋ hayô hava thêlô lôkthô kapôlôŋiŋ siŋ. Ba enaŋ Wapômbêŋ anêŋ abô bêŋ ma miŋ êkô ami. ");
INSERT INTO hot_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ma ŋê êvhaviŋ sapêŋ iniŋ auk lôk kapôlôŋiŋ doŋtom iyom. Ma iniŋ nômkama sapêŋ ma hatôm thêlô lôkthô iniŋ ma miŋ evasiŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ma aposel ethak enaŋ Yisu anêŋ haviyô hathak loŋbô bêŋ ba iniŋ abô êŋ anêŋ lôklokwaŋ ma bomaŋ. Ma Wapômbêŋ habi anêŋ wapôm hayô hamô thêlô lôkthô. ");
INSERT INTO hot_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ma thêlô vi iniŋ pik lo unyak hamô ba ethak êv ba avômalô vi êv vuli. Ma ewa valu takêŋ ");
INSERT INTO hot_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ba êv hadêŋ aposel ek neyabiŋ. Ma aposel ibi valuseleŋ takêŋ sam hadêŋ avômalô takatu ba êv yak hathak nômkama. Ba intu thêlô te miŋ hêv yak hathak nôm lôk nômkama ami. ");
INSERT INTO hot_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ma thêlô êŋ te ma Josep ba anêŋ loŋ ma ŋgavithôm Saiplus ma habitak anêŋ ôdôŋ Livai. Ma aposel ethak elam yani nena Banabas, athêŋ êŋ anêŋ ôdôŋ nena, “Anyô hathak havatho avômalô kapôlôŋiŋ loŋ.” ");
INSERT INTO hot_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yani hêv anêŋ pik bute ek nênêm vuli. Ma hawa valu hathak pik êŋ ba hi hêv hadêŋ aposel. ");
INSERT INTO hot_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ma anyô yaŋ hamô ba anêŋ athêŋ nena Ananaias ma yanavi ma Sapaila. Thai êv iniŋ pik bute ba êv vuli. ");
INSERT INTO hot_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ma hawa valu pik êŋ vi ek thaida ma hêv vi hadêŋ aposel ma hasau i nena, “Valu lôkthô êntêk yahawa ba yahalêm.” Ma yanavi hayala nôm atu ba yamalô hadum. ");
INSERT INTO hot_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ma Pita hanaŋ nena, “Ananaias, hotak Sadaŋ ba hava kapôlôm siŋ ma hosau Lovak Matheŋ, ba huvuŋ anêm valu pik êŋ vi eka? ");
INSERT INTO hot_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Miŋ bôk êv vuli pik êŋ ami denaŋ, êŋ ma anêm pik. Ma bôk êv vuli yôv, valu êŋ ma anêm aêŋ iyom. Ma doŋtom howa auk kambom êŋ anêŋ êsê ba honaŋ abôyaŋ? Hosau ŋê pik lôk Wapômbêŋ haviŋ.” ");
INSERT INTO hot_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias halaŋô abô êŋ ma hêv yak halôk biŋ ba hama. Ma avômalô takatu ba elaŋô abô êŋ êkô ba biŋdaluk havali kambom. ");
INSERT INTO hot_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Êŋ ma apenena muk êlêm ma ivuliv anêŋ kupik ma ewa ba i elav. ");
INSERT INTO hot_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wakma lô hale ba hi ma yanavi halêm hayô ma hathôŋ nôm atu ba habitak paliŋ. ");
INSERT INTO hot_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ma Pita hanaŋ hik avi êŋ liŋ, “Valu êntêk ma hatôm vuli pik atu ba êv vuli e?” Ma avi êŋ hanaŋ, “Intu êŋ, vuli êŋ intu hatôm.” ");
INSERT INTO hot_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Êŋ ma Pita hanaŋ hadêŋ avi êŋ, “Aisê ka mamu ubutiŋ abô ek nosaê Anyô Bêŋ anêŋ Lovak Matheŋ? Nôŋgô! Ŋê takatu ba lêk elav vônim yôv, êntêk lêk imiŋ unyak abôlêk ba tem neja o ba ini nedav imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ma ketheŋ oyaŋ ma avi êŋ hêv yak halôk hêk Pita valuvi ba hama. Ma apenena muk takatu ba ibitak êyô unyak kapô. Ma êyê avi êŋ lêk hama. Êŋ ma ewa ba i elav yani hêk yamalô vi. ");
INSERT INTO hot_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yôv ma avômalô êvhaviŋ sapêŋ lôk avômalô takatu ba elaŋô abô êŋ, lôkthô êkô kambom. ");
INSERT INTO hot_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ma aposel idum lavôŋiŋ lôk nômbithi lomaloma hêk avômalô maleŋiŋ. Ma ŋê êvhaviŋ sapêŋ ethak doŋtom lôbôlôŋ halôk unyak matheŋ anêŋ kapo daŋ atu ba elam nena Solomon anêŋ Kapo Daŋ. ");
INSERT INTO hot_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ma avômalô vi atu ba miŋ êvhaviŋ ami êkô ek nesak doŋtom imbiŋ thêlô, ma doŋtom avômalô sapêŋ êyê thêlô nena ŋê mavi. ");
INSERT INTO hot_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ma anyô lo avi bêŋ anôŋ ethak êvhaviŋ Anyô Bêŋ ba ibitak êyô avômalô êvhaviŋ kapô. ");
INSERT INTO hot_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Êŋ ma avômalô ethak ewa iniŋ ŋê lôk lijiŋ hayô hêk balê lo yêm ba i ililiŋ hêk loŋôndê anêŋ daŋ ek Pita haveŋ loŋôndê, êŋ ma dahô imbi êyôŋgêk i ek nimbitak mavi esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ma avômalô bêŋ anôŋ êlêm anêŋ lomalak takatu ba habobo Jelusalem ba êlêm ethak doŋtom. Ma ewa iniŋ ŋê lôk lijiŋ lôk ŋê takatu ba ŋgôk lelaik habuliŋ i ma lôkthô ibitak mavi hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ma anyô bêŋ habôk da lôk ŋê idum ku haviŋ yani, thêlô sapêŋ ma Sadyusi ba êyê nôm takatu ba aposel idum ba leŋiŋdaŋ hathak i. ");
INSERT INTO hot_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ba evaloŋ aposel ma etak i halôk malak lôŋ anêŋ koladôŋ. ");
INSERT INTO hot_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma bôlôvôŋ êŋ ma Anyô Bêŋ anêŋ aŋela hik koladôŋ abôlêk vê ma hawa i ele yaiŋ. Ma hanaŋ, ");
INSERT INTO hot_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Unu numiŋ unyak matheŋ anêŋ piklêvôŋ ma nonaŋ abô sapêŋ esak lôkmala lukmuk êntêk êŋ bêŋ.” ");
INSERT INTO hot_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aposel elaŋô abô êŋ ba lôkbôk momaŋiniŋ ma i unyak matheŋ anêŋ piklêvôŋ. Ma êdôŋ avômalô. Ma anyô bêŋ habôk da lôk anêŋ ŋê môlô êlêm ma elam ŋê Sanhedlin lôk Islael iniŋ ŋê bêŋbêŋ sapêŋ. Ma êv abô hadêŋ koladôŋ ek neja aposel ba nêlêm. ");
INSERT INTO hot_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Êŋ ma ŋê koladôŋ iniŋ sôp bidoŋ i ek neja aposel ma doŋtom miŋ êmô ami. Ma êvôi ma enaŋ nena, ");
INSERT INTO hot_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Yêlô ayê koladôŋ anêŋ abôlêk putup ma ŋê takatu ba eyabiŋ imiŋ habobo. Ma doŋtom yêlô ik koladôŋ abôlêk vê ma miŋ apôm anyô late hamô kapô ami.” ");
INSERT INTO hot_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Unyak matheŋ anêŋ sôp bidoŋ iniŋ anyô vovak laik lôk ŋê bêŋbêŋ êbôk da elaŋô abô êŋ ba leŋiŋhabi bêŋ anôŋ hathak ba enaŋ, “Malê te tem imbitak?” ");
INSERT INTO hot_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ma anyô te hayô ma hanaŋ hadêŋ i, “Nodaŋô! Ŋê takatu ba otak i hamô koladôŋ, lêk imiŋ unyak matheŋ anêŋ piklêvôŋ ba êdôŋ avômalô.” ");
INSERT INTO hot_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Êŋ ma anyô vovak laik lôk anêŋ sôp bidoŋ i ewa thêlô. Êkô ek avômalô nijik i esak valu ba intu miŋ êpôviŋ thêlô ami. ");
INSERT INTO hot_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ewa aposel êyô ma etak i hamiŋ Sanhedlin maleŋiŋ ek anyô bêŋ habôk da enaŋ injik thêlô liŋ. ");
INSERT INTO hot_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Yêlô bôk anaŋ lôklokwaŋ hadêŋ môlô nena miŋ nôndôŋ avômalô esak ôpêŋ anêŋ athêŋ ami. Ma doŋtom lêk unim abô êŋ halaŋviŋ haveŋ Jelusalem mayaliv. Lôk lêk udum ek nonaŋ nena yêlô intu aŋgasô ôpêŋ anêŋ thalaleŋ.” ");
INSERT INTO hot_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ma doŋtom Pita lôk aposel vi enaŋ hadêŋ i nena, “Yêlô nasopa Wapômbêŋ anêŋ abô iyom ma miŋ anyô iniŋ abô ami. ");
INSERT INTO hot_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Môlô bôk uik Yisu vônô hathak a. Ma doŋtom bumalô thêlô iniŋ Wapômbêŋ hik yani liŋ. ");
INSERT INTO hot_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wapômbêŋ bôk hawa yani hathak ba hi daku leŋ ba hadô hamô baŋ vianôŋ hatôm Anyô Môŋ lôk Anyô hêv alalô bulubiŋ ek nêm alalô Islael sa ek nande kapôlôŋiŋ liliŋ lôk nêm alalôaniŋ kambom vê. ");
INSERT INTO hot_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yêlô ma ŋê takatu ba bôk ayê nôm takêŋ ba lêk anaŋ abô êŋ bêŋ. Ma Lovak Matheŋ atu ba Wapômbêŋ hêv hadêŋ avômalô takatu ba esopa anêŋ abô hik nôm takêŋ loŋ haviŋ.” ");
INSERT INTO hot_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sanhedlin elaŋô abô êŋ ma leŋiŋmaniŋ kambom ba leŋiŋhaviŋ nijik aposel vônô. ");
INSERT INTO hot_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ma doŋtom Gameliel haviyô hamiŋ Sanhedlin malêvôŋ. Yani ma anyô Palisi lôk anyô lôkauk hathak abô balabuŋ ma hadum ku Sanhedlin haviŋ. Avômalô sapêŋ ethak êv athêŋ bêŋ hadêŋ yani. Yani hamiŋ ba hanaŋ ek netak aposel takêŋ ba ini yaiŋ dokte vêmam. ");
INSERT INTO hot_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Êŋ ma hanaŋ hadêŋ thêlô, “Môlô ŋê Islael, lemimimbi katô nena tem nundum malê êndêŋ ŋê takêntêk vêmam. ");
INSERT INTO hot_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sêbôk ma Teudas habitak anyô lôk athêŋ ba hanaŋ, ‘Ya anyô bêŋ’. Ma anyô hatôm 400 esopa yani. Ma doŋtom Lom ik yani vônô ma anêŋ ŋê ku êsôv mayaliv. Ma anêŋ abô êŋ hêv yak. ");
INSERT INTO hot_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Vêm ma waklavôŋ ewa avômalô iniŋ athêŋ, êŋ ma Judas anêŋ Galili habitak anyô lôk athêŋ ba havôv avômalô bêŋ anôŋ ek nijik vovak êndêŋ gavman. Ma doŋtom ik yani vônô, ma anêŋ ŋê ku êsôv mayaliv aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ba intu yahanaŋ hadêŋ môlô Sanhedlin: Notak ŋê takêntêk. Miŋ nundum nômla esak i ami. Ku takatu ba idum halêm anêŋ ŋê pik iniŋ hatôm Teudas lo Judas, êŋ ma iniŋ ku takêŋ tem nêm yak. ");
INSERT INTO hot_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma doŋtom ku takatu ba halêm anêŋ Wapômbêŋ, ma môlô miŋ hatôm numiŋ i loŋ siŋ ami. Yahakô tem uŋgwik vovak ni ba ni, êŋ ma tem ôŋgô nena uik vovak êŋ hadêŋ Wapômbêŋ.” ");
INSERT INTO hot_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yôv ma thêlô êlôk hathak Gameliel anêŋ abô. Ba elam aposel êlêm ma evali i. Ma enaŋ lôklokwaŋ hadêŋ thêlô nena miŋ nenaŋ abô esak Yisu anêŋ athêŋ ami. Êŋ ma etak i ba i. ");
INSERT INTO hot_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposel etak Sanhedlin ba ele yaiŋ ma thêlô leŋiŋmavi hathak Wapômbêŋ hayê thêlô nena ŋê mavi ek ewa mama hathak Yisu anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma wak nômbêŋ intu ma thêlô i unyak matheŋ anêŋ piklêvôŋ lôk lounyak lounyak ma êdôŋ avômalô ba enaŋ Abô Mavi bêŋ nena Yisu ma Mesia atu. ");
INSERT INTO hot_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Avômalô êvhaviŋ ilumbak ba êv liŋ siŋ, êŋ ma avômalô Islael vi atu ba êvhaviŋ ba enaŋ abô Glik, etatale avômalô Islael vi atu ba êvhaviŋ ba enaŋ abô Hiblu. Ba enaŋ, “Wak nômbêŋ intu ba ibi nôm sam ma miŋ evani yêlôaniŋ avi tôp iniŋ sam ami.” ");
INSERT INTO hot_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Êŋ ma aposel laumiŋ ba lahavuju takatu elam ŋê êvhaviŋ sapêŋ ethak doŋtom ma enaŋ, “Miŋ mavi ek yêlô natak ku nanaŋ Wapômbêŋ anêŋ abô ma nandum ku nambi nôm sam ami. ");
INSERT INTO hot_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Aêŋ ba, aiyaŋ thêlô, nômbôlêm môlônim anyô lôkauk baheŋvi ba lahavuju takatu ba Lovak Matheŋ hava kapôlôŋiŋ siŋ ek nanêm ku êŋ êndêŋ i. ");
INSERT INTO hot_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Êŋ ma tem yêlô hatôm namô tiŋiŋ ek nateŋ mek lôk nanaŋ Wapômbêŋ anêŋ abô lôk nandôŋ avômalô.” ");
INSERT INTO hot_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Avômalô sapêŋ elaŋô abô êŋ ma leŋiŋmavi. Ma etak Stiven, yani anyô hêvhaviŋ lôklokwaŋ lôk Lovak Matheŋ hava yani kapô siŋ, ma Pilip lôk Plokolus ma Nikano lo Timon ma Pamenas lo Nikolas, yani ma anyô Antiok atu bôk habitak hayô avômalô Islael iniŋ êvhaviŋ kapô vêm ma hêvhaviŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ewa ŋê êŋ ba i hadêŋ aposel. Ma aposel etak baheŋiŋ hayô hêk i ma eteŋ mek hathak i. ");
INSERT INTO hot_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Aêŋ ba Wapômbêŋ anêŋ abô hi ba hi. Ma avômalô anêŋ Jelusalem takatu ba êvhaviŋ ilumbak hi ba hi. Ma ŋê êbôk da bêŋ anôŋ êvhaviŋ ba esopa Yisu haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ma Wapômbêŋ habi anêŋ wapôm sam ba hêv lôklokwaŋ bêŋ anôŋ hadêŋ Stiven. Ba intu Stiven hathak hadum nômbithi lôk lavôŋiŋ lomaloma hêk avômalô malêvôŋ. ");
INSERT INTO hot_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma doŋtom ŋê doho êpôlik hathak yani. Ŋê êŋ iniŋ unyak yeŋ ma elam nena, “Ŋê takatu ba bôk iniŋ alaŋ hêv athêŋ ku vê hêk i ma êmô oyaŋ haviŋ i”. Thêlô sapêŋ ma avômalô Islael, doho anêŋ Sailini ma doho anêŋ Aleksandlia ma doho anêŋ plovins Silisia lo Esia. Ma ŋê takêŋ êkôki hathak Stiven anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ma doŋtom Lovak Matheŋ hêv auk mavi hadêŋ Stiven ba miŋ hatôm nêmô anêŋ abô lu ami. ");
INSERT INTO hot_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Êŋ ma thêlô eyenak ba i ibi anyô doho leŋiŋ liŋ ek nenaŋ nena, “Yêlô bôk alaŋô ôpêŋ hanaŋ abôma hathak Mose lo Wapômbêŋ.” ");
INSERT INTO hot_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Aêŋ ba thêlô ibi avômalô lôk ŋê bêŋbêŋ ma ŋê lôkauk hathak abô balabuŋ leŋiŋ liŋ. Ma i evaloŋ Stiven ba ewa ba i êdô hamiŋ Sanhedlin maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ma êv anyô doho ek nenaŋ abôyaŋ esak yani. Ba enaŋ, “Wak nômbêŋ intu ma ôpêntêk hathak hanaŋ abô kambom hathak unyak matheŋ lôk Mose anêŋ balabuŋ. ");
INSERT INTO hot_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yêlô alaŋô yani hanaŋ, ‘Yisu anêŋ Nasalet tem indiniŋ unyak matheŋ êntêk ma injik Mose anêŋ kobom sêbôk ba hêv hadêŋ alalô liliŋ.’” ");
INSERT INTO hot_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ma ŋê nômbêŋ atu ba êmô Sanhedlin ititiŋ Stiven lôklokwaŋ ma êyê thohavloma lêk hatôm aŋela te. ");
INSERT INTO hot_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ma anyô bêŋ habôk da hanaŋ, “Abô takêŋ ma avanôŋ e?” ");
INSERT INTO hot_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ma Stiven hanaŋ, “Aiyaŋ thêlô lo wakamik thêlô, nodaŋô yenaŋ abô! Sêbôk atu ba alalôaniŋ bumalô Ablaham hamô Mesopotemia denaŋ ma miŋ hi Halan ami, ma Wapômbêŋ lôkmaŋgiŋ hayô ek yani. ");
INSERT INTO hot_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ma hanaŋ, ‘Otak anêm pik lôk avômalô ma nu pik atu ba tem yaŋgik thô êndêŋ o.’ ");
INSERT INTO hot_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Êŋ ma hatak Kaldia iniŋ pik ba hi hamô Halan. Vêm ba lambô hama ma Wapômbêŋ hêv yani ba halêm pik êntêk atu lêk alalô amô. ");
INSERT INTO hot_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ma wak êŋ ma Wapômbêŋ miŋ hêv pik bute ek yani ami, milôk. Ma doŋtom havak abô nena embeŋ yam ma tem yani lôk anêŋ limi neja pik bêŋ êŋ lôkthô. Waklavôŋ atu ba Wapômbêŋ hanaŋ abô takêŋ ma Ablaham nakaduŋ mi denaŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ma doŋtom Wapômbêŋ hanaŋ nena, ‘Anêm libumi tem nêmô êtôm ŋê masôm êmô malak yaŋ iniŋ pik. Ma ŋê pik êŋ tem nimbitak thêlôniŋ alaŋ ba nênêm malaiŋ êndêŋ i êtôm sondabêŋ 400. ");
INSERT INTO hot_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Vêm ma tem yanêm vovaŋ êndêŋ alaŋ takêŋ. Ma embeŋ yam ma tem netak pik yaŋ êŋ ma nêbônêlêm pik êntêk ma nênêm yeŋ êndêŋ ya.’ ");
INSERT INTO hot_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Vêm ma Wapômbêŋ havak abô haviŋ Ablaham ba hêv tabô neŋgothe kupik vê hadêŋ yani. Ma haveŋ yam ma Ablaham habitak Aisak anêŋ lambô ma hatôm wak baheŋvi ba lahavulô ma haŋgothe Aisak anêŋ kupik vê. Vêm ma Aisak habitak Jekop anêŋ lambô, ma Jekop habitak hatôm bumalô laumiŋ ba lahavuju takatu iniŋ lambô. Ma thêlô sapêŋ esopa tabô atu ba hêv. ");
INSERT INTO hot_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Bumalô thêlô leŋiŋdaŋ hathak Josep ba intu êv hadêŋ ŋê loŋ buyaŋ ba êv vuli ba intu anyô Ijip te habitak Josep anêŋ alaŋ. Ma doŋtom Wapômbêŋ hamô haviŋ yani ba ");
INSERT INTO hot_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","hêv yani bulubiŋ hathak malaiŋ lomaloma. Ba hêv auk mavi hadêŋ Josep ek indum Ijip iniŋ kiŋ Pelo lamavi esak yani. Ba intu hatak yani ek imbitak anyô bêŋ ek eyabiŋ Ijip lôk anêŋ unyak lôkmaŋgiŋ sapêŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Haveŋ yam ma bôm bêŋ lôk malaiŋ lomaloma habitak Ijip lo Kenan iniŋ loŋ sapêŋ ba bumalô thêlô miŋ hatôm nêpôm nôm ami. ");
INSERT INTO hot_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ma Jekop halaŋô nena nôm hamô Ijip. Êŋ ma hêv bumalô thêlô ba i môŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ma i bôlôŋ yaŋ, ma Josep hanaŋ yanida bêŋ hadêŋ iviyaŋ. Ma Pelo halaŋô nena Josep anêŋ lambô lôk iviyaŋ êmô. ");
INSERT INTO hot_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Êŋ ma Josep hêv abô ek lambô Jekop lôk anêŋ avômalô sapêŋ nêlêm. Thêlô hatôm 75. ");
INSERT INTO hot_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ma Jekop halôk ba hi Ijip ba hamô aleba hama ma bumalô thêlô ema haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ma ewa iniŋ kupik ba i elav hêk malak Sekem. Siô êŋ ma Ablaham bôk hêv vuli hêk Hamol anêŋ nali. ");
INSERT INTO hot_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Waklavôŋ atu ba Wapômbêŋ bôk havak abô haviŋ Ablaham lêk habobo injik anôŋ, êŋ ma alalôaniŋ avômalô lêk ilumbak ba êv liŋsiŋ êmô Ijip. ");
INSERT INTO hot_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Vêm ma kiŋ yaŋ habitak anêŋ Ijip ba hathôŋ Josep paliŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ôpêŋ hasau alalôaniŋ avômalô ba hêv malaiŋ hadêŋ bumalô thêlô lôk hanaŋ lôklokwaŋ nena neja avômena kasek ende yaiŋ ma nimbi i ni ek nema. ");
INSERT INTO hot_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Êŋ ma Mose talêbô havathu yani, ma yani amena mavi hêk Wapômbêŋ ma. Ma hatôm ayôŋ lô ma eyabiŋ yani hamô lambô anêŋ unyak. ");
INSERT INTO hot_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Vêm ma êdô yani hamô yaiŋ ma Pelo nalavi hawa ba hi hayabiŋ yani hatôm anêŋ namalô. ");
INSERT INTO hot_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ma Mose hathak unyak ba êdôŋ yani hathak avômalô Ijip iniŋ auk mavi sapêŋ. Anêŋ abô lôk ku ma lôklokwaŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mose anêŋ sondabêŋ hatôm 40 ma lahaviŋ ni ek ênjê anêŋ avômalô Islael. ");
INSERT INTO hot_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ma hayê Ijip te habuliŋ Islael yaŋ. Êŋ ma hêv Islael êŋ sa ba hik anyô Ijip atu anêŋ kambom liliŋ ba hik ôpêŋ vônô. ");
INSERT INTO hot_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ma lahabi nena tem anêŋ avômalô neyala nena Wapômbêŋ hêv yani ek nêm thêlô bulubiŋ. Ma doŋtom mi. ");
INSERT INTO hot_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Haviyô hayaŋ ma Mose hi ma hayê anyô Islael ju ik i. Ma hadum ek nêm thai thêvô ek leŋiŋimbiŋ i ba hanaŋ, ‘Ai, mamu ŋê loyaŋ. Ma uik am eka?’ ");
INSERT INTO hot_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ma doŋtom ôpatu ba habuliŋ yaŋ hathô Mose pôŋêŋ ba hanaŋ, ‘Opalê hatak o hatôm yêlôaniŋ anyô bêŋ lôk anyô nindum abô esak? ");
INSERT INTO hot_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tem nuŋgwik ya vônô êtôm wakbôk ba huik Ijip alaŋ vônô e?’ ");
INSERT INTO hot_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mose halaŋô abô êŋ ma hasôv ba hi hamô Midian iniŋ pik hatôm anyô masôm. Ma hawa nakaduŋ ju. ");
INSERT INTO hot_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Sondabêŋ 40 hale ba hi ma aŋela te hayô ek Mose hêk loŋ thiliv habobo dum Sainai. Aŋela êŋ hamô atum atu ba hathaŋ hamô alokwaŋ yaônate kapô. ");
INSERT INTO hot_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose hayê ma hasoŋ kambom. Ma hi habobo ek ênjê katô, êŋ ma Anyô Bêŋ hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ya libumi iniŋ Wapômbêŋ, Ablaham lo Aisak ma Jekop iniŋ Wapômbêŋ.’ Êŋ ma Mose hakô kambom ba halowaliŋ ba miŋ hatôm ênjê ami. ");
INSERT INTO hot_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ma Anyô Bêŋ hanaŋ hadêŋ yani, ‘Ômbi anêm vem bokŋgôp thô. Loŋ êntêk ba humiŋ ma loŋ matheŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yahayê kambom takatu ba Ijip idum hathak yenaŋ avômalô. Ma lêk yahalaŋô iniŋ asêŋ ba êntêk yahalêm ek yanêm thêlô vê. Aêŋ ba ôlêm ek yanêm o ba ondenu Ijip esak loŋbô.’ ");
INSERT INTO hot_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mose intu bôk thêlô êpôlik hathak ba enaŋ nena, ‘Opalê hatak o hatôm yêlôaniŋ anyô bêŋ lôk anyô nindum abô esak?’ Ma doŋtom hathak aŋela atu ba Mose hayê hatôm atum ba hathaŋ hamô alokwaŋ thaŋaŋ, Wapômbêŋ da hatak yani ek imbitak iniŋ anyô bêŋ lôk nêm thêlô bulubiŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mose hawa thêlô vê hêk Ijip ba hi ma hadum nômbithi lôk lavôŋiŋ hêk Ijip lôk Ŋgwêk Thalaleŋ ma loŋ thiliv hatôm sondabêŋ 40. ");
INSERT INTO hot_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Êntêk ma Mose atu ba hanaŋ hadêŋ avômalô Islael nena, ‘Wapômbêŋ tem etak môlôda te ba imbitak plopet. Ma tem enaŋ Wapômbêŋ anêŋ abô êtôm êntêk ba lêk yahanaŋ hadêŋ môlô.’ ");
INSERT INTO hot_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yani êŋ intu hamô haviŋ bumalô takatu ba ethak doŋtom êmô loŋ thiliv. Ma hathak ba hi dum Sainai ma aŋela hanaŋ abô hadêŋ yani. Ma hawa Wapômbêŋ anêŋ abô takatu ba hêv lôkmala ek nêm êndêŋ alalô. ");
INSERT INTO hot_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ma doŋtom bumalô thêlô êpôlik hathak anêŋ abô. Lôk êdô yani ma ik kapôlôŋiŋ liliŋ hale hi Ijip hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ma enaŋ hadêŋ Alon nena, ‘Opesaŋ ŋgôk doho ek endom yêlô. Mose atu ba hawa yêlô vê hêk Ijip ba alêm lêk hi doho ba yêlô athôŋ paliŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Aêŋ ba intu epesaŋ bokmaŋkao map te anêŋ dahô ba êv da hadêŋ yani. Ma eŋgabôm nôm lôk eloyeŋ bêŋ ek êv athêŋ bêŋ hadêŋ nôm atu ba epesaŋ hathak baheŋiŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ba intu Wapômbêŋ havôliŋ dôm hadêŋ thêlô ba hatak thêlô ek nênêm yeŋ êndêŋ wak lo ayôŋ ma vuliŋ. Hatôm bôk eto hêk plopet iniŋ kapya nena, “‘Sêbôk atu ba môlô Islael ômô sondabêŋ 40 hamô loŋ thiliv, osoŋ nena uik bokmaŋkao lôk boksipsip ba ôêv hatôm da hadêŋ ya e? Milôk. ");
INSERT INTO hot_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Môlô bôk owa unim ŋgôk Molek anêŋ malak yeŋ lôk ŋgôk Lepaŋ anêŋ vuliŋ dahô, ma ŋgôk dahô takatu ba opesaŋ ek nônêm yeŋ êndêŋ. Aêŋ ba intu tem yanêm môlô vê ba unu Babilon vidôm doho.’ ");
INSERT INTO hot_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Sêbôk atu ba bumalô thêlô êmô loŋ thiliv ma malak yeŋ hamô haviŋ thêlô hatôm tabô. Thêlô elav malak yeŋ êŋ hatôm Wapômbêŋ hanaŋ hadêŋ Mose nena endav aêŋ, lôk hatôm dahô atu ba Mose hayê. ");
INSERT INTO hot_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Vêm ma Josua halom thêlô ba ewa avômalô takatu ba Wapômbêŋ haliti i ba i iniŋ pik. Ma iniŋ bumalô bôk êv malak yeŋ êŋ hadêŋ i ba ewa ba i pik lukmuk êŋ haviŋ i. Ma êmô pik êŋ aleba Devit habitak. ");
INSERT INTO hot_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wapômbêŋ lamavi hathak Devit. Ma Devit hateŋ mek ek endav malak yeŋ ek Jekop anêŋ Wapômbêŋ êmô. ");
INSERT INTO hot_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ma doŋtom nakaduŋ Solomon halav unyak êŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ma Wapômbêŋ Lôkmaŋgiŋ miŋ hathak hamô unyak atu ba anyô elav ami. Hatôm plopet te bôk hanaŋ: ");
INSERT INTO hot_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Wapômbêŋ hanaŋ nena, ‘Leŋ ma yenaŋ balê atu ba yahayô hamô hatôm kiŋ, ma pik ma yenaŋ balê yaôna ek yahatak yaveŋkapô hayô hamiŋ. Ma môlô udum ek nodav unyak alê te ek ya? Ma tem yamô êsê ek yanja lovak? ");
INSERT INTO hot_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ek malê nena yada yahapesaŋ nômkama takêŋ sapêŋ. Avanôŋ e?’ ");
INSERT INTO hot_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Môlô ŋê lemimôndôŋ kôtôŋ. Môlô kapôlômim ma thekthek hatôm ŋê daluk. Wak nômbêŋ intu ma môlô ôpôlik hathak Lovak Matheŋ anêŋ abô hatôm libumi taksêbôk. ");
INSERT INTO hot_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Môlônim libumi bôk idum kambom hadêŋ plopet sapêŋ! Ma plopet takatu ba bôk enaŋ nena Anyô Thêthôŋ atu tem êlêm ma ik i pôpônô haviŋ. Ma lêk môlô onaŋ ôpêŋda bêŋ haviŋ ba uik vônô. ");
INSERT INTO hot_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Môlô ma ŋê takatu ba bôk owa Wapômbêŋ anêŋ abô balabuŋ takatu ba aŋela êv, ma doŋtom miŋ osopa ami.” ");
INSERT INTO hot_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Thêlô elaŋô abô êŋ ma leŋiŋmaniŋ kambom hadêŋ Stiven ma ethaŋ veŋiŋbôlêk lokwaŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma doŋtom Lovak Matheŋ hadum ku lôklokwaŋ hamô Stiven kapô ba yani hayê leŋ lôklokwaŋ ma hayê Wapômbêŋ anêŋ deda lôkmaŋgiŋ lôk Yisu hamiŋ Wapômbêŋ baŋ vianôŋ. ");
INSERT INTO hot_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Êŋ ma hanaŋ nena, “Ôŋgô! Yahayê leŋ abyaŋ ba Anyô Anêŋ Nakaduŋ atu hamiŋ Wapômbêŋ baŋ vianôŋ.” ");
INSERT INTO hot_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Êŋ ma thêlô ibi leŋiŋôndôŋ siŋ ma elam kaêk lôklala bomaŋ ma elaŋviŋ ba i evaloŋ Stiven. ");
INSERT INTO hot_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ma êvôv yani hale malak lôŋ viyaiŋ ma ik yani hathak valu. Ŋê takatu ba bôk enaŋ yani bêŋ, ibi iniŋ kwêv daim thô ba êdô hamô anyô muk te anêŋ valuvi ek eyabiŋ. Ôpêŋ anêŋ athêŋ nena Sol. ");
INSERT INTO hot_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ik Stiven hathak valu ma yani hateŋ mek nena, “Anyô Bêŋ Yisu, onja yadahôlôŋ.” ");
INSERT INTO hot_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma yani hêv yak ba habi vadôŋ halôk pik ma halam nena, “Anyô Bêŋ, miŋ ombaloŋ iniŋ kambom êntêk viyaŋ loŋ ami.” Halam aêŋ ma hama. ");
INSERT INTO hot_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ma Sol hayê nena ik Stiven vônô ma hêv lamavi. Ma ŋê vi atu ba esopa Wapômbêŋ anêŋ lahaviŋ elav yani lôk kapôlôŋiŋ malaiŋ kambom. Hadêŋ wak êŋ ba hi ma êv malaiŋ lomaloma hadêŋ avômalô êvhaviŋ anêŋ Jelusalem. Êŋ ma êsôv mayaliv ba i hadêŋ loŋ bêŋ Judia lo Samalia. Ma aposel iyom êmô Jelusalem denaŋ. ");
INSERT INTO hot_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Êŋ ma Sol hadum ek imbuliŋ avômalô êvhaviŋ. Yani hi lounyak lounyak ba havaloŋ anyô lo avi ba havôv i ba hatak i hamô koladôŋ. ");
INSERT INTO hot_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ma avômalô takatu ba êsôv mayaliv ba i ma enaŋ Wapômbêŋ anêŋ Abô Mavi haveŋ loŋ nômbêŋ atu ba êyô. ");
INSERT INTO hot_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ma Pilip hi hayô malak bêŋ te anêŋ Samalia ba hanaŋ abô hathak Yisu nena yani ma Mesia atu. ");
INSERT INTO hot_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Avômalô bêŋ anôŋ elaŋô Pilip anêŋ abô ba êyê lavôŋiŋ lôk nômbithi takatu ba hadum, ba intu elaŋô anêŋ abô takatu ba hanaŋ katô. ");
INSERT INTO hot_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ma Pilip hêv ŋgôk kambom bêŋ anôŋ vê hêk avômalô, ma ŋgôk takêŋ elaŋ ba eŋgaliak lôklokwaŋ ba ele yaiŋ ba i. Ma hadum ŋê ivuviŋ lôk ŋê veŋiŋ kambom bêŋ anôŋ mavi hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Aêŋ ba avômalô malak bêŋ êŋ leŋiŋmavi bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Anyô te hamô malak bêŋ êŋ ba anêŋ athêŋ nena Saimon. Yani ma anyô lôk ŋgôk soŋgoŋ ba hadum anêŋ aloyak hamô loŋ êŋ sondabêŋ bêŋ anôŋ ba avômalô Samalia êyê ba esoŋ kambom. Ma yani hathak habam yanida nena, “Ya anyô lôk athêŋ.” ");
INSERT INTO hot_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ma avômalô lôk athêŋ bêŋ lôk athêŋ yaô ethak ititiŋ yani ba enaŋ nena, “Yani intu ma Wapômbêŋ anêŋ lôklokwaŋ atu ba elam nena Lôklokwaŋ Bêŋ.” ");
INSERT INTO hot_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wak bêŋ anôŋ ma yani hadum nôm takêŋ ba intu avômalô esopa yani ek êyê anêŋ aloyak takatu ba hadum ba nômbithi hathak habitak lôbôlôŋ. ");
INSERT INTO hot_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ma doŋtom Pilip hayô ba hanaŋ Abô Mavi hathak Wapômbêŋ anêŋ loŋ lôkliŋyak lôk Yisu Kilisi anêŋ athêŋ. Êŋ ma anyô lo avi bêŋ anôŋ êvhaviŋ ba ithik ŋaŋ. ");
INSERT INTO hot_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ma Saimon hêvhaviŋ haviŋ ba ithik yani halôk ŋaŋ. Ma hasopa Pilip haveŋ loŋ nômbêŋ atu ba yani hi ek hayê lavôŋiŋ lôk nômbithi lomaloma takatu ba Pilip hadum. Êŋ ma hasoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposel anêŋ Jelusalem elaŋô nena avômalô Samalia lêk êvhaviŋ Wapômbêŋ anêŋ abô. Êŋ ma êv Pita lo Jon ba i hadêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Thai êyô ma elaŋô nena avômalô Samalia takatu ba bôk êvhaviŋ lo ithik ŋaŋ hathak Anyô Bêŋ Yisu anêŋ athêŋ, ma doŋtom miŋ ewa Lovak Matheŋ ami. Êŋ ma thai eteŋ mek ek thêlô neja Lovak Matheŋ. ");
INSERT INTO hot_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Etak baheŋ hayô hêk thêlô, ma Lovak Matheŋ hayô hamô i. ");
INSERT INTO hot_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon hayê aposel ju atu etak baheŋiŋ hayô hêk avômalô ma Lovak Matheŋ hayô hamô i. Êŋ ma hadum ek nêm valuseleŋ êndêŋ thai ba hanaŋ, ");
INSERT INTO hot_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nônêm lôklokwaŋ intu êndêŋ ya imbiŋ ek yahatak yabaheŋ hayô hêk anyô te, ma ôpêŋ tem enja Lovak Matheŋ.” ");
INSERT INTO hot_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ma Pita hanaŋ nena, “Aisê? Hosoŋ nena hatôm nêm Wapômbêŋ anêŋ wapôm vuli e? O nêm yak ba nu loŋ atum imbiŋ anêm valu! ");
INSERT INTO hot_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","O miŋ hatôm undum Wapômbêŋ anêŋ ku êntêk imbiŋ yêlô ami. Mi anôŋ! Kapôlôm miŋ thêthôŋ hêk Wapômbêŋ ma ami. ");
INSERT INTO hot_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Aêŋ ba onde kapôlôm liliŋ ma otak anêm kambom êŋ. Ma oteŋ mek êndêŋ Anyô Bêŋ ek etak anêŋ kapô esak anêm kambom takatu ba havuŋi hêk kapôlôm. ");
INSERT INTO hot_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yahayê nena kapôlôm putup hathak kambom lomaloma ma kambom anêŋ lôklokwaŋ havaloŋ o loŋ majaŋ bomaŋ.” ");
INSERT INTO hot_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ma Saimon hanaŋ nena, “Noteŋ mek êndêŋ Anyô Bêŋ esak ya ek malaiŋ takatu ba honaŋ miŋ êpôm ya ami.” ");
INSERT INTO hot_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ma Pita lo Jon enaŋ Anyô Bêŋ anêŋ abô bêŋ lôk enaŋ hathak nôm takatu ba bôk êyê. Vêm ma êvôi Jelusalem hathak loŋbô ba enaŋ Abô Mavi bêŋ haveŋ Samalia iniŋ malak nenanena. ");
INSERT INTO hot_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ma Anyô Bêŋ anêŋ aŋela hanaŋ hadêŋ Pilip, “Umbiyô ma ôndôk ba nu tamu loŋôndê atu ba hatak Jelusalem ma hi Gasa, loŋ êŋ ma loŋ thiliv.” ");
INSERT INTO hot_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Êŋ ma Pilip haviyô ma hasopa loŋôndê êŋ ma hayê anyô Itiopia te, yani ma anyô bêŋ atu ba hayabiŋ Itiopia iniŋ kwin Kandas anêŋ valuseleŋ. Ôpêŋ bôk êvê thalôk vê ek indum anêŋ ku. Ma hi Jelusalem ek hêv yeŋ hadêŋ Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Vêm ma hale hi anêŋ loŋ hathak loŋbô. Ma hathak anêŋ kalis ba hi ma hasam kapya atu ba plopet Aisaia bôk hato. ");
INSERT INTO hot_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ma Lovak Matheŋ hanaŋ hadêŋ Pilip, “Nu bidoŋ ek kalis intu ma ombeŋ imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Êŋ ma Pilip halaŋviŋ ba hi habobo kalis ma halaŋô ôpatu hasam plopet Aisaia anêŋ kapya. Ma Pilip hanaŋ hik liŋ, “Hoyala abô intu ba hosam anêŋ ôdôŋ e?” ");
INSERT INTO hot_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ma ôpêŋ hanaŋ, “Tem yayala aisê? Anyôla miŋ hamô ek enaŋ anêŋ ôdôŋ bêŋ êndêŋ ya ami.” Êŋ ma hanaŋ nena Pilip esak anêŋ kalis ba ni êmô imbiŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ma Wapômbêŋ anêŋ abô atu ba ôpêŋ hasam ma aêntêk, “Elom yani hatôm boksipsip atu ba elom hi ek nijik vônô. Lôk hatôm boksipsip nakaduŋ atu ba ekapiŋ vuluk vê ba bônôŋ iyom, lôk miŋ halaŋ ba hanaŋ abô te ami. ");
INSERT INTO hot_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Thêlô êv mama bêŋ hadêŋ yani, ma miŋ idum abô thêthôŋ hathak yani ami. Thêlô ik yani vônô, ba intu limi mi.” ");
INSERT INTO hot_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ma anyô êŋ hanaŋ hik Pilip liŋ, “Plopet êŋ hanaŋ hathak yanida, mena anyô yaŋ?” ");
INSERT INTO hot_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Êŋ ma Pilip hanaŋ Abô Mavi bêŋ anôŋ hathak Yisu hadêŋ ôpêŋ, môŋ ma Aisaia anêŋ abô atu ba lêk hasam vêm ma hanaŋ Wapômbêŋ anêŋ abô vi haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Thai eveŋ loŋôndê aleba êyô ŋaŋ te, ma ôpêŋ hanaŋ hadêŋ Pilip, “Nôŋgô, ŋaŋ êntêk hêk. Hatôm usik ya mena mi e?” ");
INSERT INTO hot_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Êŋ ma ôpêŋ hanaŋ ek nebaloŋ kalis loŋ. Ma thai lôk Pilip ibup ŋaŋ ma Pilip hathik yani. ");
INSERT INTO hot_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Etak ŋaŋ ma ketheŋ oyaŋ ma Anyô Bêŋ anêŋ Lovak Matheŋ hawa Pilip vê. Ma ôpêŋ miŋ hayê Pilip hathak loŋbô ami. Ma hi lôk lamavi. ");
INSERT INTO hot_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ma Pilip hasoŋ kambom ek lêk habitak hayô Asotas. Êŋ ma hi lomalak lomalak ba hanaŋ Abô Mavi bêŋ haveŋ aleba hayô Sisalia. ");
INSERT INTO hot_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma Sol hanaŋ abô lôklokwaŋ denaŋ nena tem imbuliŋ lôk injik avômalô takatu ba esopa Anyô Bêŋ Yisu vônô. Ma hi hadêŋ anyô bêŋ habôk da ");
INSERT INTO hot_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ek eto kapya êndêŋ ŋê bêŋbêŋ takatu ba eyabiŋ Islael iniŋ unyak yeŋ takatu hamô Damaskas. Kapya êŋ hanaŋ nena Sol hapôm avômalô la esopa Yisu anêŋ loŋôndê, anyô mena avi, êŋ ma embaloŋ i ba enja ba êlêm Jelusalem êtôm ŋê koladôŋ. ");
INSERT INTO hot_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Êŋ ma hatak Jelusalem ma hi Damaskas. Ma habobo Damaskas ma ketheŋ oyaŋ ma deda bêŋ te anêŋ leŋ hatôm damak hêv ba habi hayô hêk yani. ");
INSERT INTO hot_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ma hêv yak halôk pik ma halaŋô abô te halam hadêŋ yani aêntêk, “Sol, Sol, hubuliŋ ya eka?” ");
INSERT INTO hot_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ma Sol hanaŋ, “Anyô Bêŋ, o opalê?” Ma ôpêŋ hanaŋ, “Ya Yisu ôpatu ba hubuliŋ. ");
INSERT INTO hot_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Umbiyô ba nu malak lôŋ kapô. Ma tem nenaŋ êndêŋ o esak nôm atu ba undum.” ");
INSERT INTO hot_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ma ŋê takatu ba eveŋ haviŋ Sol imiŋ bônôŋ iyom. Thêlô elaŋô abô, ma doŋtom miŋ êyê anyôla ami. ");
INSERT INTO hot_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Êŋ ma Sol haviyô ma doŋtom miŋ hatôm ênjê tak ami. Ba intu evaloŋ yani baŋ ma edadi ba i Damaskas. ");
INSERT INTO hot_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Hatôm wak lô ma yani mapusip ba miŋ hayaŋ nôm lo hanum ŋaŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yisu anêŋ anyô ku te hamô Damaskas ba anêŋ athêŋ nena Ananaias. Ma hayê wêŋ te atu ba Anyô Bêŋ hanaŋ hadêŋ yani nena, “Ananaias!” Ma yani hanaŋ, “Anyô Bêŋ, ya êntêk yahamô.” ");
INSERT INTO hot_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ma Anyô Bêŋ hanaŋ hadêŋ yani, “Umbiyô ba nu Judas anêŋ unyak hêk loŋôndê atu anêŋ athêŋ nena Thêthôŋ. Ma onaŋ injik liŋ nena, ‘Sol anêŋ Tasus hamô mena mi e?’ Yani lêk hateŋ mek. ");
INSERT INTO hot_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ma hatulak ma hayê wêŋ te nena anyô te anêŋ athêŋ nena Ananaias halêm hatak baŋ hayô hêk yani ek ênjê tak esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ma Ananaias hanaŋ viyaŋ nena, “Anyô Bêŋ, yahalaŋô abô bêŋ anôŋ hathak ôpêŋ. Yani hadum nôm kambom lomaloma hadêŋ anêm avômalô matheŋ anêŋ Jelusalem. ");
INSERT INTO hot_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma ŋê bêŋbêŋ êbôk da êv lôklokwaŋ hadêŋ yani ba halêm loŋ êntêk ek embaloŋ avômalô takatu ba êvhaviŋ anêm athêŋ.” ");
INSERT INTO hot_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ma doŋtom Anyô Bêŋ hanaŋ hadêŋ Ananaias nena, “Nu. Bôk yahatak ôpêŋ yôv ek imbitak yenaŋ anyô ku ba enja yenaŋ athêŋ ba ni ek avômalô loŋ buyaŋ lôk iniŋ kiŋ ma avômalô Islael imbiŋ. ");
INSERT INTO hot_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma tem yaŋgik malaiŋ lomaloma takatu ba tem êpôm yani esak yenaŋ athêŋ thô êndêŋ yani.” ");
INSERT INTO hot_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Êŋ ma Ananaias hi unyak atu kapô ma hatak baŋ hayô hêk Sol ma hanaŋ, “Aiyaŋ Sol, Anyô Bêŋ Yisu atu ba hapôm o halôk loŋôndê hêv ya ba yahalêm ek nôŋgô tak esak loŋbô lôk Lovak Matheŋ êmbôlô kapôlôm siŋ.” ");
INSERT INTO hot_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ma ketheŋ oyaŋ ma nômla hatôm alim anêŋ kalak hagililiŋ hêk Sol madaluk. Ma hayê tak hathak loŋbô. Haviyô ma Ananaias hathik yani. ");
INSERT INTO hot_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Vêm ma hayaŋ nôm doho ma hawa lôklokwaŋ hathak loŋbô. Sol hamô haviŋ Yisu anêŋ ŋê ku takatu ba êmô Damaskas hatôm wak doho. ");
INSERT INTO hot_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Vêm ma hi Islael iniŋ unyak yeŋ takatu ba hamô loŋ êŋ, ma hanaŋ bêŋ nena Yisu ma Wapômbêŋ anêŋ Nakaduŋ. ");
INSERT INTO hot_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Avômalô takatu ba elaŋô anêŋ abô esoŋ kambom ba enaŋ, “Ôpêntêk ma ôpatu ba bôk habuliŋ avômalô takatu ba êvhaviŋ Yisu anêŋ athêŋ anêŋ Jelusalem e? Ma lêk halêm loŋ êntêk ek embaloŋ thêlô êtôm ŋê koladôŋ ba enja ba ni ek ŋê bêŋbêŋ êbôk da, aêŋ e?” ");
INSERT INTO hot_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ma doŋtom Sol anêŋ lôklokwaŋ halumbak hi ba hi. Ma anêŋ abô hik thô hadêŋ avômalô Islael takatu ba êmô Damaskas nena Yisu ma Mesia atu. Ma thêlô esoŋ kambom ba miŋ hatôm nenaŋ abôla ami. ");
INSERT INTO hot_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wak bêŋ anôŋ hale ba hi ma avômalô Islael anêŋ loŋ êŋ ethak doŋtom ba ibutiŋ abô ek nijik Sol vônô. ");
INSERT INTO hot_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ma doŋtom Sol halaŋô abô hathak iniŋ auk êŋ. Wak lo bôlôvôŋ ma ŋê takêŋ eyabiŋ malak lôŋ êŋ anêŋ badêŋ abôlêk ek nijik yani vônô. ");
INSERT INTO hot_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ma doŋtom bôlôvôŋ te ma Sol anêŋ ŋê ku ewa yani ba etak halôk vak sam bêŋ te kapô. Ma êlêlô halôk badêŋ anêŋ loŋ lovak te ba hi tamu badêŋ viyaŋ. ");
INSERT INTO hot_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Vêm ma Sol hi Jelusalem. Hayô ma lahaviŋ êmô imbiŋ avômalô êvhaviŋ, ma doŋtom thêlô sapêŋ êkô ek yani lôk miŋ êvhaviŋ nena yani ma Yisu anêŋ anyô ku te ami. ");
INSERT INTO hot_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ma doŋtom Banabas hawa Sol ba hi hayô ek aposel. Ma hanaŋ abô hathak Sol nena bôk hayê Anyô Bêŋ halôk loŋôndê ma Anyô Bêŋ hanaŋ abô hadêŋ yani. Ma hanaŋ nena Sol hamô Damaskas ma hanaŋ abô lôklokwaŋ hathak Yisu anêŋ athêŋ ma miŋ hakô ami. Ma aposel êvhaviŋ anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aêŋ ba Sol hamô haviŋ i. Ma hi ba halêm hamô Jelusalem kapô ma hanaŋ abô bêŋ hathak Anyô Bêŋ anêŋ athêŋ ma kô mi. ");
INSERT INTO hot_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma yani hi hanaŋ abô haviŋ avômalô Islael takatu ba ethak enaŋ abô Glik. Ma hawa iniŋ auk vose ek nênêmimbiŋ Yisu. Ma doŋtom thêlô leŋiŋmaniŋ ba idum ek nijik yani vônô. ");
INSERT INTO hot_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ma abô êŋ hi hapôm ŋê êvhaviŋ. Ba intu ewa yani ba i Sisalia ma etak halôk yeŋ te ek ni Tasus. ");
INSERT INTO hot_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Êŋ ma avômalô êvhaviŋ anêŋ Judia lo Galili ma Samalia êmô labali ba miŋ anyôla hêv malaiŋ hadêŋ i ami. Ma thêlô ibitak lôklokwaŋ ma Lovak Matheŋ havatho thêlô kapôlôŋiŋ loŋ. Thêlô êmô Anyô Bêŋ vibiŋ ma êbô anêŋ athêŋ. Ma avômalô êvhaviŋ ilumbak hi ba hi. ");
INSERT INTO hot_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita hi haveŋ lomalak lomalak. Ma wak te ma hi ek ênjê avômalô matheŋ anêŋ Lida. ");
INSERT INTO hot_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Loŋ êŋ ma hapôm anyô te ba anêŋ athêŋ nena Ainias. Yani kupik bôk havuviŋ ma hêk biŋ iyom hatôm sondabêŋ baheŋvi ba lahavulô. ");
INSERT INTO hot_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma Pita hanaŋ, “Ainias, Yisu Kilisi lêk hadum o mavi. Umbiyô ma umbuvi anêm yêm.” Ma ketheŋ oyaŋ ma haviyô. ");
INSERT INTO hot_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Êŋ ma avômalô Lida lôk Salon sapêŋ êyê yani, ma ele i liliŋ ba esopa Anyô Bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Anêŋ Jopa ma avi êvhaviŋ te ba anêŋ athêŋ nena Tabita, ma hathak abô Glik nena Dokas. Wak nômbêŋ intu ma yani hadum kobom mavi lomaloma lôk hêv avômalô siv sa. ");
INSERT INTO hot_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pita hamô Lida denaŋ ma Dokas hapôm lijiŋ ba hama. Ma ithik anêŋ kupik ba êdô hêk unyak kapô te atu ba hêk daku vuliŋ. ");
INSERT INTO hot_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa hamô habobo Lida ba intu avômalô êvhaviŋ elaŋô nena Pita lêk hamô Lida, êŋ ma êv anyô ju ba i hadêŋ yani ma enaŋ lôklokwaŋ nena, “Ôlêm ketheŋ!” ");
INSERT INTO hot_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Êŋ ma Pita hi haviŋ thai ba êyô Jopa. Ma ewa yani ba i unyak kapô ali atu ba hêk daku vuliŋ. Avi tôp bêŋ anôŋ êmô unyak kapô êŋ ba elaŋ. Thêlô ekalabu Pita siŋ ma ewa iniŋ kwêv thilibuŋ lôk sôp takatu ba Dokas bôk hamô ma hadu ba hêv hadêŋ i ma ik thô hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ma Pita hanaŋ ba avômalô sapêŋ ele yaiŋ ba i. Ma halek vadôŋ lêlô ma hateŋ mek. Vêm ma hik i liliŋ hadêŋ avi ŋama êŋ ma hanaŋ, “Tabita, umbiyô.” Ma madaluk hakyav ba hayê Pita ma haviyô hamô. ");
INSERT INTO hot_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ma Pita havaloŋ baŋ ma hêv yani liŋ haviyô hamiŋ. Ma halam avômalô matheŋ lôk avi tôp takatu ba êlêm. Ma hik thô nena yani lêk haviyô lôkmala hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Abô hathak nôm atu ba Pita hadum halaŋviŋ haveŋ Jopa iniŋ loŋ sapêŋ ba avômalô bêŋ anôŋ êvhaviŋ Anyô Bêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma Pita hamô Jopa sonda doho haviŋ Saimon, ôpatu ba hapesaŋ nômkama hathak alim kupik. ");
INSERT INTO hot_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Anyô Lom te hamô Sisalia ba anêŋ athêŋ nena Konilias. Yani ma anyô vovak laik te ba hayabiŋ ŋê vovak ôdôŋ te hatôm 100 takatu ba êmô Lom iniŋ ŋê vovak kapô ba elam i nena Ŋê Vovak Itali. ");
INSERT INTO hot_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yani ma anyô hêv lêlê ek esopa Wapômbêŋ anêŋ lahaviŋ. Ba yani lôk vêŋi lôk nali ethak êmô Wapômbêŋ vibiŋ. Yani hathak hêv valuseleŋ bêŋ anôŋ hadêŋ Islael iniŋ avômalô siv, ma wak nômbêŋ intu ma hathak hateŋ mek. ");
INSERT INTO hot_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wak te hatôm 3 kilok yaŋsiŋ ma hayê wêŋ te nena Wapômbêŋ anêŋ aŋela te halêm ma hanaŋ, “Konilias!” ");
INSERT INTO hot_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ma Konilias hatitiŋ aŋela êŋ lôklokwaŋ ba hakô kambom ma hanaŋ, “Anyô Bêŋ, aisê?” Ma aŋela hanaŋ, “Anêm mek nômbêŋ atu ba hoteŋ lôk wapôm takatu ba hôêv hadêŋ avômalô siv, lêk habitak hatôm da mavi hêk Wapômbêŋ ma. ");
INSERT INTO hot_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Aêŋ ba nêm anyô doho ba ini Jopa ek neja anyô te anêŋ athêŋ nena Saimon, ma athêŋ yaŋ nena Pita ba nêlêm. ");
INSERT INTO hot_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ôpêŋ hamô haviŋ anêŋ wase Saimon, ôpatu ba hapesaŋ nômkama hathak alim kupik. Anêŋ unyak hamô habobo ŋgwêk daŋ.” ");
INSERT INTO hot_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aŋela hanaŋ abô takêŋ yôv ma hi. Êŋ ma Konilias halam anêŋ anyô ku ju lôk anyô vovak te atu ba hêk lêlê ek esopa Wapômbêŋ. Ôpêŋ ma Konilias anêŋ anyô hamô haviŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ma Konilias hanaŋ abô takêŋ sapêŋ hadêŋ thêlô yôv, ma hêv i ba i Jopa. ");
INSERT INTO hot_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Haviyô hayaŋ anêŋ waklêvôŋ biŋ ma thêlô lêk ebobo nêyô malak bêŋ Jopa. Ma wakma êŋ iyom ma Pita hathak unyak vôv atu ba kalôŋ ek eteŋ mek. ");
INSERT INTO hot_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ma hama kisi ba lahaviŋ enjaŋ nôm. Ma doŋtom êpôpêk nôm denaŋ ba ma hatulak ma hayê wêŋ te aêntêk. ");
INSERT INTO hot_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Leŋ abyaŋ ma nômla hatôm sôp bêŋ te ba ibutiŋ anêŋ daŋ ayova loŋ ma êlêlô halôk ba halêm. ");
INSERT INTO hot_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sôp êŋ kapô ma alim lomaloma hamô. Alim doho eveŋ hathak veŋiŋ lo baheŋiŋ ma vi êyêyê hathak bôbôŋiŋ ma vi ma menak leŋlêvôŋ. ");
INSERT INTO hot_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ma abô te halêm hadêŋ yani nena, “Pita, umbiyô. Nuŋgwik ba noŋgwaŋ.” ");
INSERT INTO hot_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma Pita hanaŋ, “Anyô Bêŋ, ya milôk. Nôm takêŋ ma balabuŋ hanaŋ nena lelaik ba miŋ bôk yahaŋ ami.” ");
INSERT INTO hot_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ma abô êŋ hanaŋ hathak loŋbô nena, “Nôm takatu ba Wapômbêŋ hadum ba habitak mabuŋ ma miŋ onaŋ nena lelaik ami.” ");
INSERT INTO hot_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nôm êŋ habitak hatôm bôlôŋ lô ma ketheŋ oyaŋ ma sôp lôk alim takêŋ hathak leŋ hathak loŋbô ba hi. ");
INSERT INTO hot_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ma Pita lahabi wêŋ êŋ anêŋ ôdôŋ denaŋ ma ŋê takatu ba Konilias hêv i ba êlêm êyô. Thêlô êbôlêm Saimon anêŋ unyak aleba êyô imiŋ unyak abôlêk. ");
INSERT INTO hot_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ma elam nena Saimon atu ba elam nena Pita hamô mena mi e? ");
INSERT INTO hot_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ma Pita lahabi wêŋ atu denaŋ ma Lovak Matheŋ hanaŋ, “Ondaŋô, anyô lokwaŋlô êbôlêm o eveŋ. ");
INSERT INTO hot_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ba intu nu tamu pik. Ma miŋ ôkô ek nu imbiŋ thêlô ami. Mi, yahêv thêlô ba êlêm ba intu nu imbiŋ i.” ");
INSERT INTO hot_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ma Pita habup ma hanaŋ, “Ya ôpatu ba môlô ôbôlêm êŋ êntêk. Môlô ôlêm eka?” ");
INSERT INTO hot_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ma thêlô enaŋ, “Konilias hêv yêlô ba alêm. Yani ma Lom iniŋ anyô vovak laik te. Yani ma anyô thêthôŋ ba hathak hamô Wapômbêŋ vibiŋ. Ma avômalô Islael takatu ba eyala yani êyê nena yani ma anyô mavi te. Ma aŋela matheŋ te hanaŋ hadêŋ yani ek endam o ba nu anêŋ unyak ek endaŋô abô takatu ba tem onaŋ.” ");
INSERT INTO hot_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita halaŋô iniŋ abô ma hanaŋ ek ini nêmô unyak kapô imbiŋ yani. Lôkbôk ma Pita hi haviŋ thêlô ma ŋê êvhaviŋ doho anêŋ Jopa i haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Thêlô eveŋ aleba êk loŋôndê, ma haviyô hayaŋ ma i ba êyô Sisalia. Ma Konilias hêv ma ek thêlô. Ma halam anêŋ avômalô lôk anêŋ ŋê môlô ba thêlô ethak doŋtom êmô anêŋ unyak kapô ba eyabiŋ Pita. ");
INSERT INTO hot_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita hayô unyak kapô ma Konilias halek vadôŋ lêlô hamô valuvi ma habô yani. ");
INSERT INTO hot_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ma doŋtom Pita hanaŋ nena, “Umbiyô, ya ma anyô pik hatôm o.” ");
INSERT INTO hot_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ma Pita hanaŋ abô haviŋ yani ma hi unyak kapô ma hayê nena avômalô bêŋ anôŋ lêk ethak doŋtom ba êmô. ");
INSERT INTO hot_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ma hanaŋ hadêŋ thêlô, “Môlô oyala nena Islael iniŋ balabuŋ hanaŋ lôklokwaŋ nena yêlô Islael miŋ hatôm namô imbiŋ avômalô loŋ buyaŋ ba nambitak nayô iniŋ unyak kapô ami. Ma doŋtom Wapômbêŋ hik thô hadêŋ ya nena miŋ hatôm yandam anyô te nena lelaik mena kambom ami. ");
INSERT INTO hot_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ba intu ôêv anyô ba êlêm ek neja ya, ma miŋ yahanaŋ abôla ami. Mi, yahalêm iyom. Aêŋ ba hatôm onaŋ anêm auk atu ba holam ya ba yahalêm hathak bêŋ êndêŋ ya mena mi e?” ");
INSERT INTO hot_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ma Konilias hanaŋ, “Wak ayova hale ba hi ma yahamô yenaŋ unyak kapô ba yahateŋ mek hadêŋ wakma êntêk hatôm 3 kilok yaŋsiŋ. Êŋ ma anyô te hamiŋ yamaleŋ ba anêŋ kwêv lôk sôp ma thapuk anôŋ oyaŋ. ");
INSERT INTO hot_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ma hanaŋ, ‘Konilias, Wapômbêŋ lêk halaŋô anêm mek lôk wapôm takatu ba hôêv hadêŋ ŋê siv. ");
INSERT INTO hot_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Aêŋ ba nêm abô ni Jopa ek Saimon atu ba elam nena Pita. Yani hamô haviŋ anêŋ wase Saimon ôpatu ba hapesaŋ nômkama hathak alim kupik. Anêŋ unyak hamô habobo ŋgwêk daŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aêŋ ba yahêv abô ketheŋ ek o, ma hudum nôm mavi ba lêk hôlêm yôv. Lêk yêlô sapêŋ athak doŋtom ba amô Wapômbêŋ ma ek nadaŋô abô takatu ba Anyô Bêŋ hanaŋ hadêŋ o ek onaŋ êndêŋ yêlô.” ");
INSERT INTO hot_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Êŋ ma Pita hanaŋ abô hadêŋ thêlô nena, “Avanôŋ biŋ, lêk yahayala nena Wapômbêŋ hadum kobom doŋtom hadêŋ avômalô lodôŋlodôŋ. Ma miŋ lamavi hathak ôdôŋ te iyom ami. ");
INSERT INTO hot_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mi, yani lamavi hathak avômalô lodôŋlodôŋ sapêŋ atu ba elovak yani vibiŋ ba idum nôm takatu ba thêthôŋ. ");
INSERT INTO hot_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Môlô oyala abô atu ba Wapômbêŋ hêv hadêŋ yêlô avômalô Islael. Abô êŋ hanaŋ hathak Abô Mavi atu ba hadum ek avômalô nêmô yôhôk imbiŋ yani hathak Yisu Kilisi anêŋ ku. Yani ma avômalô sapêŋ iniŋ Anyô Bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ma môlô bôk oyala nômbêŋ atu ba habitak Islael iniŋ loŋ yôv. Môŋ ma habitak anêŋ Galili ba Jon anyô hathik ŋaŋ hanaŋ ek avômalô nisik ŋaŋ. ");
INSERT INTO hot_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Lôk oyala nena Wapômbêŋ bôk hêv Lovak Matheŋ lôk lôkliŋyak bêŋ hadêŋ Yisu anêŋ Nasalet hatôm mek ek indum ku. Ma hi lomalak lomalak ma hadum mavi. Wapômbêŋ hamô haviŋ yani ba intu hadum avômalô takatu ba êmô Sadaŋ anêŋ lôklokwaŋ vibiŋ ibitak mavi hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ma yêlô aposel anaŋ hathak nôm takatu ba yêlô ayê yani hadum haveŋ Jelusalem lôk Islael iniŋ loŋ sapêŋ bêŋ hadêŋ avômalô. Thêlô ik yani hathak a ba hama, ");
INSERT INTO hot_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ma doŋtom wak te lô ma Wapômbêŋ hik yani liŋ hathak loŋbô ek injik i thô êndêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Avômalô sapêŋ miŋ êyê yani ami. Mi, yêlô ŋê takatu ba bôk halam yôv ek nanaŋ nôm takêntêk bêŋ intu aŋ lo anum haviŋ yani hadêŋ waklavôŋ haviyô hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma yani hanaŋ hadêŋ yêlô ek yêlô nanaŋ anêŋ Abô Mavi bêŋ êndêŋ avômalô lôk nanaŋ bêŋ aêntêk, ‘Wapômbêŋ bôk hatak yani yôv ek endaŋô avômalô lôkmala lôk ŋama iniŋ abô.’ ");
INSERT INTO hot_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Plopet bô sapêŋ bôk enaŋ nena avômalô takatu ba êvhaviŋ yani ma tem Wapômbêŋ nêm iniŋ kambom vê esak anêŋ athêŋ.” ");
INSERT INTO hot_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita hanaŋ abô êŋ denaŋ ma Lovak Matheŋ hayô hamô avômalô takatu ba elaŋô anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Ma Islael iniŋ ŋê êvhaviŋ takatu ba iviŋ Pita ba i, elaŋô thêlô enaŋ abô masôm lôk êbô Wapômbêŋ anêŋ athêŋ. Ba intu esoŋ kambom ba enaŋ nena, “Wapômbêŋ hêv Lovak Matheŋ hadêŋ avômalô loŋ buyaŋ hatôm alalô.” Êŋ ma Pita hanaŋ, ");
INSERT INTO hot_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Thêlô ewa Lovak Matheŋ hatôm alalô ŋê Islael. Ma opalê hatôm imiŋ thêlô loŋ siŋ ek nisik ŋaŋ?” ");
INSERT INTO hot_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Êŋ ma hanaŋ nena, “Môlô nusik ŋaŋ esak Yisu Kilisi anêŋ athêŋ.” Ŋê takêŋ ithik ŋaŋ yôv ma enaŋ ek Pita êmô wak doho imbiŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposel lôk avômalô êvhaviŋ takatu ba êmô Judia elaŋô nena avômalô loŋ buyaŋ lêk ewa Wapômbêŋ anêŋ abô haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Vêm ma Pita havôhi Jelusalem hathak loŋbô ma ŋê êvhaviŋ takatu ba lôklokwaŋ ek neŋgothe kupik, ethaŋ yani ");
INSERT INTO hot_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ba enaŋ, “Hu ŋê loŋ buyaŋ takatu ba miŋ eŋgothe kupik ami iniŋ unyak ma hoaŋ nôm haviŋ i eka?” ");
INSERT INTO hot_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Êŋ ma Pita hanaŋ hathak nômkama takatu ba habitak ba hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yahamô malak bêŋ Jopa ba yahateŋ mek hamô, êŋ ma yahatulak ma yahayê wêŋ te aêntêk. Nômlate hatôm sôp bêŋ te ba ibutiŋ anêŋ daŋ ayova loŋ ma êlêlô anêŋ leŋ halôk ba halêm habup ek ya. ");
INSERT INTO hot_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ma sôp êŋ kapô ma yahayê alim pik lomaloma takatu ba eveŋ hathak veŋiŋ lo baheŋiŋ ma alim kamuŋ kambom lôk alim vi atu ba êyêyê hathak bôbôŋiŋ ma menak leŋlêvôŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Êŋ ma yahalaŋô abô te halam hadêŋ ya nena, ‘Pita, umbiyô, nuŋgwik ba noŋgwaŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ma doŋtom yahanaŋ, ‘Anyô Bêŋ, ya milôk. Nôm takêŋ ma balabuŋ hanaŋ nena lelaik ba miŋ bôk yahaŋ dokte ami.’ ");
INSERT INTO hot_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Êŋ ma abô anêŋ leŋ hanaŋ hathak loŋbô nena, ‘Nôm takatu ba Wapômbêŋ hadum ba habitak mabuŋ, ma miŋ onaŋ nena lelaik ami.’ ");
INSERT INTO hot_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Abô êŋ habitak hatôm bôlôŋ lô. Ma nôm takêŋ hathak leŋ hathak loŋbô ba hi. ");
INSERT INTO hot_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Êŋ ma ketheŋ oyaŋ ma anyô lokwaŋlô êyô imiŋ unyak atu ba yahamô. Thêlô ma anyô bêŋ te anêŋ Sisalia hêv i ba êlêm ek ya. ");
INSERT INTO hot_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ma Lovak Matheŋ hanaŋ hadêŋ ya, ‘Nu umbiŋ thêlô ma miŋ ôkô ba lemluvi ami.’ Ma aiyaŋ baheŋvi ba lahavute anêŋ Jopa atu ba bôk i haviŋ ya êntêk lêk êlêm. Ma yêlô lôkthô abitak ayô ôpêŋ anêŋ unyak kapô. ");
INSERT INTO hot_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ma ôpêŋ hanaŋ nena yani hayê aŋela hayô anêŋ unyak kapô ba hanaŋ, ‘Nêm anyô doho ba ini Jopa ek neja Saimon, anêŋ athêŋ yaŋ nena Pita ba êlêm. ");
INSERT INTO hot_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yani tem enaŋ abô êndêŋ môlô. Ma hathak abô êŋ ma Wapômbêŋ tem nêm o lôk anêm avômalô bulubiŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Aêŋ ba yahadum ek yanaŋ abô êndêŋ thêlô ma ketheŋ oyaŋ ma Lovak Matheŋ halôk ba halêm hayô hamô thêlô hatôm sêbôk ba môŋ anôŋ ma hayô hamô alalô. ");
INSERT INTO hot_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Êŋ ma yaleŋhabi Anyô Bêŋ anêŋ abô atu ba bôk hanaŋ nena, ‘Jon hathik avômalô hathak ŋaŋ, ma doŋtom Wapômbêŋ tem isik esak Lovak Matheŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Thêlô êvhaviŋ Anyô Bêŋ Yisu Kilisi hatôm alalô bôk aêvhaviŋ yani. Êŋ ma Wapômbêŋ hêv anêŋ Lovak Matheŋ hatôm wapôm hadêŋ thêlô hatôm bôk ba hêv hadêŋ alalô. Ba intu ya opalê ba hatôm yaŋgêk Wapômbêŋ anêŋ lahaviŋ loŋ siŋ?” ");
INSERT INTO hot_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Thêlô elaŋô abô êŋ ma bônôŋ ba êbô Wapômbêŋ anêŋ athêŋ ba enaŋ, “Intu êŋ, avômalô takatu ba ele kapôlôŋiŋ liliŋ ma Wapômbêŋ tem enja thêlô ba nêm lôkmala êndêŋ i ma alalô Islael lôk ŋê loŋ buyaŋ imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ma ik Stiven vônô ma êv malaiŋ hadêŋ avômalô êvhaviŋ vi haviŋ. Ba intu ŋê êvhaviŋ bêŋ anôŋ anêŋ Jelusalem êsôv ba i luvuluvu. Vi i Ponisia ma vi i ŋgavithôm Saiplus ma vi i Antiok. Ma enaŋ Yisu anêŋ Abô Mavi hadêŋ avômalô Islael takatu ba êmô loŋ takêŋ iyom, ma ŋê loŋ buyaŋ ma mi. ");
INSERT INTO hot_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma doŋtom ŋê êvhaviŋ doho anêŋ Saiplus lo Sailini, i Antiok ma enaŋ Anyô Bêŋ Yisu anêŋ Abô Mavi hadêŋ avômalô Glik haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ma Anyô Bêŋ anêŋ lôkliŋyak hamô haviŋ thêlô. Ba intu avômalô bêŋ anôŋ êvhaviŋ ba ik kapôlôŋiŋ liliŋ hadêŋ Anyô Bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Êŋ ma avômalô êvhaviŋ anêŋ Jelusalem elaŋô abô hathak nôm takatu ba habitak Antiok ma êv Banabas ba hi loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ma hi hayô ma hayê Wapômbêŋ hêv anêŋ wapôm hadêŋ thêlô, ma yani lamavi. Ma hik thêlô sapêŋ iniŋ auk liŋ ek nesopa Anyô Bêŋ ênjêk kapôlôŋiŋ êtôm wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas ma anyô mavi ba hêvhaviŋ lôkliŋyak. Ma Lovak Matheŋ hadum ku lôklokwaŋ hamô yani kapô. Ma avômalô bêŋ anôŋ anêŋ loŋ êŋ êvhaviŋ Anyô Bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Vêm ma Banabas hi Tasus ek êmbôlêm Sol. ");
INSERT INTO hot_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hapôm yani ma hawa ba hi Antiok hathak loŋbô ba thai êmô hatôm sondabêŋ te haviŋ avômalô êvhaviŋ anêŋ Antiok ma êdôŋ avômalô bêŋ anôŋ hathak Wapômbêŋ anêŋ abô. Antiok ma loŋ môŋ anôŋ atu ba elam avômalô êvhaviŋ nena Kilisi anêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Banabas lo Sol êmô Antiok denaŋ ma plopet doho etak Jelusalem ba i tamu Antiok. ");
INSERT INTO hot_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ma thêlô te, anêŋ athêŋ nena Agabas, hamiŋ ba hanaŋ hathak Lovak Matheŋ anêŋ lôklokwaŋ nena bôm bêŋ tem imbitak pik sapêŋ. (Hadêŋ waklavôŋ Klodias hamô hatôm Lom iniŋ kiŋ ma abô êŋ hik anôŋ.) ");
INSERT INTO hot_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aêŋ ba avômalô êvhaviŋ evak abô ek nênêm valuseleŋ ni ek iviyaŋ takatu ba êmô Judia ek nêm thêlô sa. Ŋê êvhaviŋ tomtom êv valuseleŋ hatôm atu ba thêlô êpôm. ");
INSERT INTO hot_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Thêlô isup yôv ma êv hadêŋ Banabas lo Sol ek nênêm êndêŋ avaka takatu ba eyabiŋ avômalô êvhaviŋ anêŋ Jelusalem. ");
INSERT INTO hot_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Waklavôŋ atu ba nôm takêŋ habitak ma Kiŋ Helot Aglipa havaloŋ avômalô êvhaviŋ doho ek nêm vovaŋ êndêŋ i imbiŋ. ");
INSERT INTO hot_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ma hanaŋ ba edabêŋ Jon anêŋ yaŋ Jems laselo kisi hathak biŋ vovak ba hama. ");
INSERT INTO hot_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ma hayê nena avômalô Islael leŋiŋmavi hathak nôm êŋ, êŋ ma evaloŋ Pita haviŋ. Yani hadum nôm êŋ hadêŋ waklavôŋ Eyaŋ Polom Yis Mi. ");
INSERT INTO hot_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Havaloŋ Pita, êŋ ma hadô hamô koladôŋ ma hatak yani halôk ŋê vovak ôdôŋ ayova baheŋiŋ. Ŋê vovak ôdôŋ ayova êŋ iniŋ ŋê vovak hatôm ayova ayova eyabiŋ yani. Helot lahabi nena waklavôŋ Hale ba Hi anêŋ daŋ, ma tem enja Pita ende yaiŋ ba imiŋ avômalô maleŋiŋ ek enaŋ yani bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita hamô koladôŋ ma avômalô êvhaviŋ eteŋ mek lôklokwaŋ ek Wapômbêŋ nêm yani sa. ");
INSERT INTO hot_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ma bôlôvôŋ te ma Pita hêk sôm hêk ŋê vovak lokwaŋju malêvôŋ. Ma ekak baŋ luvi hathak seŋ ju ba êthô hathak anyô vovak ju atu baheŋiŋ. Ma sôp bidoŋ vi eyabiŋ koladôŋ abôlêk. Helot bôk hanaŋ yôv nena biyamôŋ lôkbôk ma tem neja yani ende yaiŋ ek indum abô. ");
INSERT INTO hot_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ma ketheŋ oyaŋ ma deda bêŋ habi halôk koladôŋ kapô ma Anyô Bêŋ anêŋ aŋela te hayô. Ma hapetav Pita baya vi ma hik liŋ ba hanaŋ, “Umbiyô ketheŋ!” Ma seŋ ju atu hêv yak hêk Pita baŋ. ");
INSERT INTO hot_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Êŋ ma aŋela hanaŋ hadêŋ yani, “Umbuliv o siŋ esak anêm sôp ma nuŋgwik anêm bokŋgôp.” Ma Pita hadum aêŋ ma aŋela hanaŋ, “Nuŋgwik anêm kwêv daim ba osopa ya.” ");
INSERT INTO hot_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Êŋ ma Pita hasopa aŋela ba thai i, ma doŋtom hasoŋ nena yani hayê wêŋ ma miŋ nôm avanôŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Thai ele ba i ma êv ŋê eyabiŋ koladôŋ abôlêk lokwaŋju atu liliŋ ba ele ba i. Êŋ ma thai i êyô badêŋ abôlêk atu ba epesaŋ hathak aeŋ, ma badêŋ abôlêk êŋ da hakyav ma thai ele yaiŋ ba i malak bêŋ. Ma esopa loŋôndê te ba i. Ma ketheŋ oyaŋ ma aŋela hatak Pita ba hi. ");
INSERT INTO hot_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Yôv ma Pita anêŋ auk hathak ba hanaŋ, “Lêk yahayala avanôŋ nena Anyô Bêŋ hêv anêŋ aŋela ba halêm hawa ya vê hêk Helot baŋ lôk nômkama sapêŋ atu ba avômalô Islael esoŋ nena tem nindum aêŋ esak ya.” ");
INSERT INTO hot_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Yani lahabi abô êŋ yôv ma hi Jon talêbô Malia anêŋ unyak. Jon anêŋ athêŋ yaŋ nena Mak. Avômalô bêŋ anôŋ lêk ethak doŋtom ba eteŋ mek êmô. ");
INSERT INTO hot_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ma Pita hapididiŋ unyak abôlêk hamiŋ viyaiŋ ma avi ku te ba anêŋ athêŋ nena Loda, hi ek injik unyak abôlêk vê. ");
INSERT INTO hot_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ma doŋtom halaŋô Pita laselo katô, êŋ ma lamavi anôŋ ba halaŋviŋ hi unyak kapô hathak loŋbô ma miŋ hik unyak abôlêk vê ami. Ma hanaŋ hadêŋ thêlô, “Pita hamiŋ unyak abôlêk!” ");
INSERT INTO hot_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ma thêlô miŋ êvhaviŋ yani ami ba enaŋ, “O avi molo.” Ma doŋtom yani lôklokwaŋ ba hanaŋ, “Mi anôŋ, yanida intu hamiŋ.” Êŋ ma enaŋ nena, “Betha Pita anêŋ aŋela la.” ");
INSERT INTO hot_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ma doŋtom Pita hapididiŋ unyak abôlêk hamiŋ denaŋ. Êŋ ma thêlô ik unyak abôlêk vê ma êyê Pita ba esoŋ kambom. ");
INSERT INTO hot_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ma Pita hik thô hathak baŋ nena thêlô bônôŋ ma hanaŋ hathak nôm takatu ba Anyô Bêŋ hadum ba hawa yani vê hêk koladôŋ. Ma hanaŋ, “Nonaŋ abô êntêk êndêŋ Jems lôk ŋê êvhaviŋ vi imbiŋ.” Ma hatak i ba hi buyaŋ. ");
INSERT INTO hot_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Haviyô hayaŋ ma ŋê vovak takatu ba eyabiŋ koladôŋ êyê nena Pita miŋ hamô ami. Êŋ ma eboloba ba enaŋ mayaliv, “Pita hamô sê?” ");
INSERT INTO hot_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ma Helot hêv ŋê vovak ba i ek nêmbôlêm Pita, ma doŋtom miŋ êpôm ami. Êŋ ma hanaŋ hik ŋê takatu ba eyabiŋ Pita hamô koladôŋ liŋ lôklokwaŋ nena idum aisê? Ma doŋtom thêlô enaŋ nena injo. Êŋ ma Helot hanaŋ ek nijik sapêŋ vônô. Vêm ma Helot hatak Judia ma halôk ba hi hamô Sisalia. ");
INSERT INTO hot_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ma Helot bôk lamaniŋ hathak avômalô Taia lo Saidon. Ba hi hamô Sisalia, êŋ ma thêlô evak abô ek ini nepesaŋ abô imbiŋ yani ek malê nena thêlô ethak ewa nôm halêm anêŋ kiŋ anêŋ loŋ. Ba intu thêlô enaŋ abô haviŋ Blastas ôpatu ba hayabiŋ Helot anêŋ unyak kapô ma yani halôk ek nêm thêlô sa. Êŋ ma hatak wakma te ek thêlô nepesaŋ abô imbiŋ kiŋ. ");
INSERT INTO hot_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ma wakma êŋ hayô ma Helot hik kiŋ iniŋ nômkama kêkêlô ma hi hamô anêŋ loŋ kiŋ. Êŋ ma hanaŋ abô hadêŋ avômalô takêŋ. ");
INSERT INTO hot_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ma elam aêntêk, “Abô êntêk ma miŋ anyô leŋselo ami. Mi, wapômbêŋ te laselo.” ");
INSERT INTO hot_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ma Helot halaŋô iniŋ abô ba lamavi hathak i ma miŋ habam Wapômbêŋ anêŋ athêŋ ami. Ba intu ketheŋ oyaŋ ma Anyô Bêŋ anêŋ aŋela hik yani ba matiŋyak yaônena eyaŋ yani ba hama. ");
INSERT INTO hot_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Malaiŋ lomaloma hapôm avômalô êvhaviŋ, ma doŋtom Wapômbêŋ anêŋ abô halumbak ba halaŋviŋ ba hi luvuluvu. ");
INSERT INTO hot_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ma Banabas lo Sol ik iniŋ ku atu ba êv hadêŋ thai daŋ siŋ halôk Jelusalem, ma ele i Antiok hathak loŋbô. Ma ewa Jon atu ba elam nena Mak ba hi haviŋ thai. ");
INSERT INTO hot_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Êntêk ma plopet lôk ŋê êdôŋ Wapômbêŋ anêŋ abô takatu ba êmô Antiok iniŋ athêŋ: Banabas lo Simeon elam nena Niga ma Lusius anêŋ Sailini lo Sol ma Manain bôk ba thai lôk Kiŋ Helot Antipas yaôna ma eveŋ haviŋ i. ");
INSERT INTO hot_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wak te ma thêlô ethak doŋtom ba evak balabuŋ nôm ek neteŋ mek ma êv yeŋ hadêŋ Anyô Bêŋ. Êŋ ma Lovak Matheŋ hanaŋ nena, “Notak Banabas lo Sol ek nindum ku takatu ba yahalam thai ek nindum.” ");
INSERT INTO hot_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Êŋ ma thêlô evak balabuŋ ek netak nôm lôk neteŋ mek esak loŋbô. Vêm ma etak baheŋiŋ hayô hêk thai ma êv thai ba i ek nindum ku takatu ba Lovak Matheŋ hanaŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ma Lovak Matheŋ hêv thai ba i ibup tamu malak Selusia, ma ethak yeŋ te ba i ŋgavithôm Saiplus. ");
INSERT INTO hot_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Thai ethak malak Salamis ma enaŋ Wapômbêŋ anêŋ Abô Mavi hamô Islael iniŋ unyak yeŋ takatu ba êmô loŋ êŋ. Ma Jon Mak haveŋ haviŋ thai ek nêm thai sa. ");
INSERT INTO hot_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Thai eveŋ ŋgavithôm Saiplus anêŋ lomalak nenanena aleba êyô Papos. Loŋ êŋ ma thai êyê anyô Islael te atu ba hathak hadum ŋgôk soŋgoŋ. Yani ma plopet abôyaŋ haviŋ. Ba anêŋ athêŋ nena Ba-Yisu. ");
INSERT INTO hot_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yani hathak hamô haviŋ Lom iniŋ anyô bêŋ atu ba hayabiŋ loŋ êŋ, ba anêŋ athêŋ nena Segius Polus. Segius Polus ma anyô lôk auk mavi. Yani lahaviŋ endaŋô Wapômbêŋ anêŋ abô ba intu halam Banabas lo Sol ba êlêm. ");
INSERT INTO hot_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ma doŋtom Ba-Yisu hadum ek esale thai iniŋ abô thô ma lahaviŋ injik Lom iniŋ anyô bêŋ anêŋ auk liliŋ ek miŋ nêmimbiŋ thai iniŋ abô ami. (Ba-Yisu anêŋ athêŋ hathak abô Glik nena Elimas ma anêŋ ôdôŋ ma anyô lôk ŋgôk soŋgoŋ.) ");
INSERT INTO hot_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Êŋ ma Lovak Matheŋ hava Sol atu ba elam nena Pol kapô siŋ, ma hatitiŋ Elimas lôklokwaŋ ma hanaŋ nena, ");
INSERT INTO hot_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“O ma Sadaŋ anêŋ nakaduŋ ba intu hôpôlik hathak kobom takatu ba thêthôŋ! Kapôlôm hayô siŋ hathak abôyaŋ lôk kambom lomaloma sapêŋ. Wak nômbêŋ intu ma hothavuthiŋ Anyô Bêŋ anêŋ abô thêthôŋ ba habitak hatôm abôyaŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Aêŋ ba ondaŋô! Anyô Bêŋ anêŋ baŋ tem epetav o êndêŋ êntêk. Ba malem tem pusip ba miŋ hatôm nôŋgô wak anêŋ deda ami ma tem ômô aêŋ dokte vêmam.” Ma ketheŋ oyaŋ ma Elimas hayê nômlate hatôm buliv lôk momaŋiniŋ hava madaluk siŋ. Ma yani havaloŋ nômkama yakyak ek êpôm anyô te ek embaloŋ yani baŋ ba endom yani ba ni. ");
INSERT INTO hot_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Anyô bêŋ Lom atu hayê nôm êŋ ma hasoŋ kambom hathak Anyô Bêŋ anêŋ abô atu ba thai enaŋ ma hêvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ma Pol thêlô etak Papos ma ewa yeŋ ba i Pega anêŋ plovins Pampilia. Ma doŋtom Jon Mak hatak thêlô ba havôhi Jelusalem hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Êŋ ma etak Pega ma i Antiok anêŋ Pisidia. Ma Sabat ma thêlô i êyô avômalô Islael iniŋ unyak yeŋ ma êlôk êmô. ");
INSERT INTO hot_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Esam abô balabuŋ lôk plopet iniŋ abô yôv, êŋ ma unyak yeŋ iniŋ ŋê bêŋ êv abô hadêŋ Pol thêlô ba enaŋ, “Aiyaŋ thêlô, unim abôla hamiŋ ek nobatho avômalô iniŋ kapôlôŋiŋ loŋ, êŋ ma nonaŋ.” ");
INSERT INTO hot_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ma Pol haviyô hamiŋ ma hik thô hathak baŋ ba hanaŋ, “Môlô avômalô Islael lôk ŋê loŋ buyaŋ takatu ba ôêv yeŋ hadêŋ Wapômbêŋ, nodaŋô ya! ");
INSERT INTO hot_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Sêbôk ma Islael iniŋ Wapômbêŋ halam alalôaniŋ bumalô thêlô ba etak iniŋ loŋ ba i êmô Ijip ma habi anêŋ wapôm sam hadêŋ i ba ibitak lôkmaŋgiŋ. Ma haveŋ yam ma halom thêlô vê hêk Ijip hathak anêŋ lôklokwaŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ma êmô loŋ thiliv hatôm sondabêŋ 40 ba idum kambom lomaloma, ma doŋtom hayabiŋ thêlô mavi. ");
INSERT INTO hot_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ma yani hêv avômalô Kenan ôdôŋ baheŋvi ba lahavuju vê ma hêv iniŋ pik hadêŋ avômalô Islael ba evaloŋ hatôm iniŋ pik. ");
INSERT INTO hot_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nôm takêŋ bôk habitak ba hale ba hi hatôm sondabêŋ 450. “Vêm ma Wapômbêŋ hatak ŋê doho ek neyabiŋ avômalô Islael. Ma hatak tomtom da iniŋ waklavôŋ neyabiŋ endeba êyô plopet Samuel anêŋ waklavôŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Vêm ma avômalô Islael enaŋ hik Wapômbêŋ liŋ ek nêm kiŋ êndêŋ thêlô ma Wapômbêŋ hatak Sol ek imbitak kiŋ. Yani ma Kis nakaduŋ ba habitak anêŋ Benjamin anêŋ ôdôŋ. Yani hayabiŋ Islael hatôm sondabêŋ 40. ");
INSERT INTO hot_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Vêm ma Wapômbêŋ hêv yani vê ma hatak Devit habitak thêlô iniŋ kiŋ. Ma hanaŋ hathak Devit aêntêk, ‘Yahayê Jesi nakaduŋ Devit kapô ma hatôm yada yakapôlôŋ. Yani tem indum nômkama sapêŋ êtôm yenaŋ yaleŋhaviŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ma Devit anêŋ limi ma Wapômbêŋ hêv Yisu ôpatu ba nêm Islael bulubiŋ hatôm bôk ba habutiŋ abô haviŋ i. ");
INSERT INTO hot_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yisu miŋ bôk hadum anêŋ ku ami denaŋ ma Jon hanaŋ ek avômalô Islael nede kapôlôŋiŋ liliŋ ba nisik ŋaŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon anêŋ ku anêŋ daŋ lêk habobo ma hanaŋ, ‘Môlô lemimhabi aisê hathak ya? Ya ma miŋ Mesia atu ba môlô oyabiŋ ek nêm môlô bulubiŋ ami. Mi, yani tem embeŋ ya yam. Yani ma anyô lôk athêŋ ma ya ma yaônalôk ba intu miŋ hatôm yakôm ba yapole anêŋ vakapô bokŋgôp anêŋ yak vê ami.’ ");
INSERT INTO hot_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Aiyaŋ thêlô, môlô takatu ba Ablaham anêŋ limi lôk môlô takatu ba ŋê loŋ buyaŋ ba ômô Wapômbêŋ vibiŋ, odaŋô. Abô takatu ba hathak bulubiŋ, êŋ ma Wapômbêŋ hêv ek alalô sapêŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Avômalô Jelusalem lôk iniŋ ŋê bêŋbêŋ miŋ eyala Yisu êŋ ami. Ba intu thêlô enaŋ ek nijik yani vônô, êŋ ma esopa plopet iniŋ abô takatu ba esam hadêŋ Sabat sapêŋ ba abô takêŋ intu hik anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Thêlô miŋ êpôm anêŋ kambom la ek nijik yani vônô ami, ma doŋtom enaŋ hik Pailat liŋ ek injik yani vônô. ");
INSERT INTO hot_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Thêlô idum nômkama sapêŋ hatôm bôk ba plopet eto hathak yani, êŋ ma êv yani vê hêk alovalaŋaŋsiŋ ma êdô yani hêk siô. ");
INSERT INTO hot_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ma doŋtom Wapômbêŋ hik yani liŋ haviyô hêk ŋama hathak loŋbô, ");
INSERT INTO hot_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ma wak bêŋ anôŋ ma anêŋ avômalô takatu ba bôk eveŋ haviŋ yani anêŋ Galili ba i Jelusalem êyê yani. Ma ŋê takatu ba bôk êyê nôm takêŋ intu lêk enaŋ bêŋ hadêŋ alalôaniŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Ma lêk yêlô anaŋ Abô Mavi êntêk bêŋ hadêŋ môlô nena Wapômbêŋ lêk hik Yisu liŋ hêk ŋama ba intu abô takatu ba Wapômbêŋ bôk havak haviŋ bumalô thêlô ma lêk hik anôŋ hathak iniŋ nali alalô. Hatôm bôk eto hêk Kapya Yeŋ anêŋ abô ju nena, “‘O ma yenaŋ Okna, lêk yahabitak anêm Lemambô.’ ");
INSERT INTO hot_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Wapômbêŋ hik yani liŋ hêk ŋama ba miŋ hatôm ema esak loŋbô ba kupik epalê ami. Hatôm bôk eto nena, “‘Yahanaŋ avanôŋ biŋ nena tem yanêm mek matheŋ mavi êndêŋ môlô êtôm bôk ba yahabutiŋ ek yanêm êndêŋ Devit.’ ");
INSERT INTO hot_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Ma bôk ik auk êntêk thô hêk buyaŋ nena, “‘Ma tem miŋ ôdô anêm Anyô Matheŋ anêŋ kupik ênjêk siô ba epalê ami.’ ");
INSERT INTO hot_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Devit miŋ hato abô êŋ hathak yanida ami. Mi, Wapômbêŋ halam yani ek indum anêŋ ku êtôm anêŋ waklavôŋ atu ba hamô lôkmala vêm ma hama. Ma elav yani haviŋ limi ba anêŋ kupik hapalê. ");
INSERT INTO hot_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ma doŋtom ôpatu ba Wapômbêŋ hik liŋ, miŋ kupik hapalê ami. ");
INSERT INTO hot_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Aêŋ ba aiyaŋ thêlô, nodaŋô katô. Lêk yêlô anaŋ hadêŋ môlô nena hathak Yisu ma Wapômbêŋ tem nêm môlônim kambom vê. ");
INSERT INTO hot_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Anyôla miŋ hatôm esopa Mose anêŋ abô balabuŋ lôkthô ek Wapômbêŋ endam yani nena anyô thêthôŋ ami. Mi anôŋ, ma doŋtom lêk avômalô takatu ba êvhaviŋ Yisu, Wapômbêŋ hayê thêlô nena ŋê thêthôŋ ba miŋ lahabi iniŋ kambom hathak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Noyabiŋ am ek abô takatu ba plopet bôk enaŋ miŋ injik anôŋ imiŋ môlô ami. Thêlô bôk enaŋ aêntêk, ");
INSERT INTO hot_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Môlô ŋê obi Wapômbêŋ liliŋ, nodaŋô katô! Tem yandum nômla bêŋ te imbitak ênjêk môlô malêvôŋ. Ba anyôla hanaŋ nôm atu ba tem imbitak bêŋ hadêŋ môlô, ma tem miŋ nônêmimbiŋ ami. Ba intu tem indum môlô nosoŋ kambom lôk yambuliŋ môlô ba noma.’” ");
INSERT INTO hot_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol hanaŋ abô yôv ma thai lôk Banabas idum ek nede yaiŋ ma avômalô enaŋ nena, “Sabat yaŋ endake ma mamu nonaŋ abô esak nôm takêntêk esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sa anêŋ daŋ ma avômalô Islael lôk ŋê loŋ buyaŋ takatu ba ibitak êyô Islael iniŋ êvhaviŋ kapô esopa Pol lo Banabas. Thai enaŋ abô doho haviŋ hadêŋ thêlô ek injik thêlôniŋ auk liŋ ek nesopa Wapômbêŋ anêŋ lahaviŋ ba nimiŋ lôklokwaŋ ek anêŋ wapôm embatho thêlô loŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ma Sabat atu hayô ma habobo avômalô Antiok sapêŋ êyô ek nedaŋô Wapômbêŋ anêŋ abô takatu ba thai tem nenaŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ma doŋtom ŋê bêŋbêŋ Islael vi êyê avômalô nômbêŋ êŋ ba leŋiŋdaŋ ba enaŋ abôma hathak abô takatu ba Pol hanaŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Êŋ ma Pol lo Banabas miŋ êkô ami ma enaŋ hadêŋ thêlô nena, “Wapômbêŋ hêv yai ba alêm ek nanaŋ anêŋ abô êndêŋ môlô ŋê Islael êmôŋ. Ma doŋtom môlô ôpôlik hathak abô êŋ. Môlô ôdô lôkmala atu ba tem nêmô êtôm wak nômbêŋ intu sapêŋ e? Aêŋ ba yai lêk atak môlô ba a ek avômalô loŋ buyaŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Hatôm atu ba Anyô Bêŋ hanaŋ hadêŋ yai nena, “‘Yahatak o hatôm deda ek avômalô loŋ buyaŋ ek onaŋ Abô Mavi esak bulubiŋ atu ba tem yanêm êndêŋ avômalô embeŋ pik bêŋ êntêk endeba êyô anêŋ daŋ.’” ");
INSERT INTO hot_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Avômalô loŋ buyaŋ elaŋô abô êŋ ba leŋiŋmavi ba enaŋ nena Anyô Bêŋ anêŋ abô ma mavi anôŋ. Ma avômalô takatu ba Wapômbêŋ bôk hatak i yôv ek nêmô lôkmala êtôm wak nômbêŋ intu sapêŋ, lôkthô êvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ma Anyô Bêŋ anêŋ abô halilup haveŋ loŋ êŋ sapêŋ. ");
INSERT INTO hot_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ma doŋtom ŋê Islael doho i hadêŋ malak êŋ anêŋ ŋê bêŋbêŋ lôk avi bêŋbêŋ takatu ba ethak êmô Wapômbêŋ vibiŋ ma ik iniŋ auk liŋ ek nimbuliŋ Pol lo Banabas. Êŋ ma thêlô evatho avômalô malak êŋ loŋ ek nênêm vovaŋ êndêŋ thai. Idum aêŋ vêm ma êv thai vê hêk iniŋ loŋ ba i. ");
INSERT INTO hot_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Êŋ ma thai ik voŋgovaŋ vê hêk veŋiŋkapô ek injik thô nena thêlô idum kambom ma thai etak i ba i malak Aikoniam. ");
INSERT INTO hot_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma doŋtom ŋê êvhaviŋ anêŋ Antiok leŋiŋmavi anôŋ ba Lovak Matheŋ hava thêlô kapôlôŋiŋ siŋ. ");
INSERT INTO hot_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol lo Banabas êyô malak Aikoniam ma esopa iniŋ kobom ba i Islael iniŋ unyak yeŋ. Ma thai enaŋ abô mavi anôŋ ba intu avômalô Islael lôk ŋê loŋ buyaŋ bêŋ anôŋ êvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ma doŋtom ŋê Islael takatu ba miŋ êvhaviŋ ami ik avômalô loŋ buyaŋ iniŋ kapôlôŋiŋ liŋ ba idum thêlô leŋiŋmaniŋ kambom hadêŋ avômalô êvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Aêŋ ba thai êmô loŋ êŋ sawa daim ma enaŋ Anyô Bêŋ anêŋ abô bêŋ ma kô mi. Ma Anyô Bêŋ havatho thai loŋ ek nindum lavôŋiŋ lôk nômbithi lomaloma. Hathak nôm êŋ ma hik thô hadêŋ avômalô nena anêŋ wapôm takatu ba hêv ek nêm avômalô bulubiŋ ma avanôŋ biŋ. ");
INSERT INTO hot_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Êŋ ma avômalô malak êŋ evak i vose hi ôdôŋ ju. Ôdôŋ yaŋ imiŋ haviŋ avômalô Islael takatu ba miŋ êvhaviŋ ami ma yaŋ imiŋ haviŋ aposel. ");
INSERT INTO hot_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Vêm ma avômalô loŋ buyaŋ lôk avômalô Islael takatu ba êpôlik ek thai evak abô ek nimbuliŋ thai ba nitu thai vônô esak valu. ");
INSERT INTO hot_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ma doŋtom thai elaŋô abô êŋ ma êsôv ba i malak Listla lo Debi hêk Likonia kapô lôk loŋ vi atu ba hêk habobo loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ma thai eveŋ loŋ takêŋ ba enaŋ Abô Mavi hadêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Malak Listla ma anyô vavuviŋ te hamô. Sêbôk ba talêbô havathu yani ma miŋ bôk haveŋ dokte ami. ");
INSERT INTO hot_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wak te ma Pol hanaŋ Abô Mavi hadêŋ avômalô ma yani halaŋô anêŋ abô. Ma Pol hatitiŋ yani ma hayê nena anêŋ hêvhaviŋ hatôm indum yani mavi. ");
INSERT INTO hot_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Êŋ ma Pol halam nena, “Umbiyô umiŋ.” Ma ketheŋ oyaŋ ma ôpêŋ haviyô hamiŋ ba haveŋ. ");
INSERT INTO hot_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ma avômalô takatu ba êmô loŋ êŋ êyê nôm atu ba Pol hadum. Ma elam hathak iniŋ abô Likonia nena, “Lêk wapômbêŋ lokwaŋju êwê i hatôm anyô ju êntêk ba êlôk ba êlêm ek alalô!” ");
INSERT INTO hot_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Thêlô iniŋ wapômbêŋ môŋ ma Sus ba intu elam Banabas nena Sus. Ma elam Pol nena Helmes ek malê nena Helmes ma iniŋ wapômbêŋ atu ba hathak hanaŋ abô hamôŋ. ");
INSERT INTO hot_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Wapômbêŋ Sus anêŋ malakba hamô malak bêŋ viyaiŋ. Ma anêŋ anyô habôk da lôk avômalô sapêŋ leŋiŋhaviŋ nênêm da êndêŋ thai. Aêŋ ba Sus anêŋ anyô habôk da hawa bokmaŋkao malô doho lôk alokwaŋ vuak atu idu hathak yak ma ele malak bêŋ anêŋ badêŋ abôlêk ek nênêm da êndêŋ thai. ");
INSERT INTO hot_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ma doŋtom aposel Banabas lo Pol elaŋô abô êŋ, ma ekakaviŋ iniŋ kwêv ma elaŋviŋ ba i imiŋ avômalô nômbêŋ atu malêvôŋ ma elam, ");
INSERT INTO hot_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Avômalô Listla! Môlô udum aêŋ eka? Yai ma anyô pik hatôm môlô. Yai alêm ek nanaŋ Abô Mavi êndêŋ môlô ek notak nôm oyaŋ takêntêk atu ba ôêv yeŋ hadêŋ i ma unu êndêŋ Wapômbêŋ lôkmala. Yani hapesaŋ pik lo leŋ ma ŋgwêk lôk nômkama sapêŋ atu ba hamô kapô. ");
INSERT INTO hot_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Sêbôk ma yani hatak avômalô sapêŋ ek nesopa thêlôda iniŋ auk. ");
INSERT INTO hot_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ma doŋtom hathak lavôŋiŋ ma yani hadum ek avômalô neyala yani. Yani hathak hadum mavi hadêŋ môlô ba hêv ôthôm lôk hadum ba unim nôm ku kapô hik anôŋ. Ma hêv nôm bêŋ anôŋ hadêŋ môlô lôk hadum ba môlô lemimmavi anôŋ.” ");
INSERT INTO hot_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Thai enaŋ abô takêŋ, ma doŋtom avômalô nômbêŋ êŋ iniŋ auk ma mayaliv ba idum lôklokwaŋ ek nênêm da êndêŋ thai. ");
INSERT INTO hot_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Vêm ma ŋê Islael doho anêŋ Antiok lo Aikoniam êyô ma enaŋ abô bêŋ anôŋ hadêŋ avômalô Listla aleba ik iniŋ auk liliŋ ba êyê Pol lo Banabas nena ŋê kambom. Êŋ ma ik Pol hathak valu ma êvôv yani hale malak bêŋ viyaiŋ ba hi ba esoŋ nena lêk hama yôv. ");
INSERT INTO hot_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ma doŋtom ŋê êvhaviŋ êyô ba ekalabu yani siŋ, êŋ ma yani haviyô ma havôhi malak bêŋ kapô hathak loŋbô. Haviyô hayaŋ ma thai lôk Banabas i malak Debi. ");
INSERT INTO hot_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Thai enaŋ Abô Mavi haveŋ malak bêŋ Debi. Ma idum ba avômalô bêŋ anôŋ ibitak ŋê êvhaviŋ. Vêm ma êvôi Listla lôk Aikoniam ma Antiok hathak loŋbô ");
INSERT INTO hot_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ek evatho ŋê êvhaviŋ iniŋ kapôlôŋiŋ loŋ lôk enaŋ nena nebaloŋ iniŋ êvhaviŋ loŋ lôklokwaŋ. Ma enaŋ haviŋ nena, “Alalô tem naja malaiŋ lomaloma ek nasopa Wapômbêŋ anêŋ loŋ lôkliŋyak anêŋ loŋôndê.” ");
INSERT INTO hot_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ma Pol lo Banabas etak avaka hatôm lomalak lomalak ek neyabiŋ avômalô êvhaviŋ. Êv mek hathak thêlô ma etak i halôk Anyô Bêŋ atu ba thêlô êvhaviŋ baŋ. Vêm ma thêlô sapêŋ evak balabuŋ ek nôm ma eteŋ mek ek Anyô Bêŋ embaloŋ thêlô loŋ. ");
INSERT INTO hot_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ma thai i plovins Pampilia ma elom hêk loŋôndê atu hêk plovins Pisidia ba i êyô Pampilia. ");
INSERT INTO hot_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Êŋ ma thai enaŋ Yisu anêŋ abô hadêŋ avômalô Pega anêŋ Pampilia. Vêm ma êlôk ba i Atalia. ");
INSERT INTO hot_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ma anêŋ Atalia ma ethak yeŋ ba i Antiok anêŋ Silia, loŋ sêbôk atu ba ewa mek ek Wapômbêŋ nêm anêŋ wapôm êndêŋ thai esak ku takatu ba idum aleba lêk anêŋ daŋ. ");
INSERT INTO hot_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Êyô Antiok ma isup avômalô êvhaviŋ ethak doŋtom ma enaŋ hathak nôm takatu ba Wapômbêŋ hêv thai sa ba idum bêŋ. Lôk enaŋ nena, “Wapômbêŋ hakyav ŋê loŋ buyaŋ iniŋ unyak abôlêk êvhaviŋ vê ba vi dedauŋ lêk êvhaviŋ.” ");
INSERT INTO hot_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ma thai êmô loŋ êŋ sawa daim haviŋ avômalô êvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ma ŋê Judia doho êlôk ba i Antiok ma êdôŋ avômalô êvhaviŋ ba enaŋ nena, “Môlô miŋ oŋgothe kupik vê hatôm bôk ba Mose hanaŋ ami, êŋ ma Wapômbêŋ tem miŋ nêm môlô bulubiŋ ami.” ");
INSERT INTO hot_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol lo Banabas elaŋô iniŋ abô takatu ba enaŋ ma miŋ êlôk hathak iniŋ auk êŋ ami. Ba intu thêlô êkôki bêŋ anôŋ. Êŋ ma ŋê êvhaviŋ elam Pol lo Banabas lôk ŋê êvhaviŋ doho ek ini Jelusalem ek nepesaŋ abô êŋ imbiŋ aposel lôk avaka vi. ");
INSERT INTO hot_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ba intu êv i ba i. Ma eveŋ Pinisia lo Samalia malêvôŋ ba enaŋ hadêŋ avômalô êvhaviŋ anêŋ lomalak nenanena hathak nôm takatu ba Wapômbêŋ bôk hadum ba avômalô loŋ buyaŋ ele kapôlôŋiŋ liliŋ ba êvhaviŋ Wapômbêŋ. Ma avômalô êvhaviŋ takêŋ elaŋô abô êŋ ma leŋiŋmavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Êyô Jelusalem ma avômalô êvhaviŋ lôk iniŋ avaka doho lôk aposel ewa thêlô thô. Ma Pol lo Banabas enaŋ hathak nôm takatu ba Wapômbêŋ hêv thai sa ba idum bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Êŋ ma Palisi vi atu ba êvhaviŋ Yisu iviyô imiŋ ma enaŋ, “Avômalô loŋ buyaŋ takatu ba êvhaviŋ, êŋ ma nêmô Mose anêŋ abô balabuŋ vibiŋ lôk neŋgothe anyô iniŋ kupik vê. Ma êdô ma dô.” ");
INSERT INTO hot_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aêŋ ba aposel lôk avaka takatu ba êmô ethak doŋtom ek nekaksa esak abô êŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Thêlô enaŋ abô pôk bêŋ anôŋ aleba Pita haviyô hamiŋ ma hanaŋ, “Aiyaŋ thêlô, môlô oyala nena sêbôk ma Wapômbêŋ halam ya hêk môlô malêvôŋ ek yanaŋ Abô Mavi êndêŋ avômalô loŋ buyaŋ ek nedaŋô ba nênêmimbiŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wapômbêŋ hayala avômalô kapôlôŋiŋ. Ma hêv anêŋ Lovak Matheŋ hadêŋ avômalô loŋ buyaŋ hatôm hêv hadêŋ alalô ek hik thô nena yani lamavi ek enja thêlô imbiŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wapômbêŋ miŋ hadum nômlate hadêŋ alalô avômalô Islael ma hadum nômla yaŋ hadêŋ thêlô ami. Mi, thêlô êvhaviŋ yani ba intu yani havôkwiŋ thêlô kapôlôŋiŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ma alalô lôk bumalô thêlô miŋ hatôm naja malaiŋ takatu ba Mose anêŋ balabuŋ hanaŋ ami. Ma aisê ka môlô udum ek nônêm malaiŋ êndêŋ avômalô loŋ buyaŋ takatu ba êvhaviŋ? Môlô udum aêŋ ek nômbi Wapômbêŋ la liŋ e? ");
INSERT INTO hot_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ma doŋtom alalô êvhaviŋ nena Wapômbêŋ hêv alalô bulubiŋ hathak Anyô Bêŋ Yisu anêŋ wapôm. Ma thêlô aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita hanaŋ yôv ma Pol lo Banabas iviyô enaŋ abô ma lôkthô elaŋô ba bônôŋ iyom. Thai enaŋ abô hathak lavôŋiŋ lôk nômbithi lomaloma takatu ba Wapômbêŋ hatak halôk thai baheŋiŋ ba idum haveŋ avômalô loŋ buyaŋ malêvôŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Thai enaŋ yôv ma Jems hanaŋ, “Aiyaŋ thêlô, nodaŋô yenaŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon lêk hanaŋ hadêŋ alalô yôv nena Wapômbêŋ hik anêŋ lahaviŋ thô hathak hawa avômalô loŋ buyaŋ vi ek nimbitak êtôm anêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ma plopet iniŋ abô bôk enaŋ aêŋ iyom. Ba te bôk hato nena, ");
INSERT INTO hot_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘Embeŋ yam ma tem yandealêm, ma yapesaŋ Devit anêŋ loŋ lôkliŋyak atu ba bôk hapu yôv ek imbitak lôklokwaŋ esak loŋbô. Ma loŋ lôkliŋyak êŋ anêŋ nômkama takatu ba bôk kambom, ma tem yapesaŋ lukmuk esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ek avômalô takatu ba êmô denaŋ lôk avômalô loŋ buyaŋ takatu ba bôk yahêv yenaŋ athêŋ hadêŋ i hatôm nêpôm Anyô Bêŋ. Ya Anyô Bêŋ atu ba tem yandum nôm takêntêk, intu yahanaŋ aêŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ma nôm takêŋ intu bôk yahik thô hadêŋ yenaŋ avômalô.’ ");
INSERT INTO hot_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Aêŋ ba yenaŋ auk ma aêntêk. Avômalô loŋ buyaŋ takatu ba bôk ele kapôlôŋiŋ liliŋ ba i hadêŋ Wapômbêŋ ma miŋ nanêm malaiŋ êndêŋ i ami. ");
INSERT INTO hot_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mi, alalô nato kapya êndêŋ thêlô ma nanaŋ ek miŋ nejaŋ nôm takatu ba anyô êv hatôm da hadêŋ ŋgôk dahô ami, nôm êŋ intu lelaik hêk Wapômbêŋ ma. Lôk netak sek waliliŋ, ma miŋ nejaŋ alim takatu ba evak laselo siŋ ba thalaleŋ hamô kapô siŋ lôk ninum thalaleŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Êŋ ma hatôm. Ek malê nena sêbôk aleba lêk ma enaŋ Mose anêŋ abô bêŋ haveŋ lomalak lomalak lôk esam hamô Islael iniŋ unyak yeŋ hadêŋ Sabat sapêŋ. Ba intu ŋê loŋ buyaŋ hatôm neyala.” ");
INSERT INTO hot_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Êŋ ma aposel lôk avaka ma avômalô êvhaviŋ sapêŋ ibutiŋ abô nena nendam iniŋ anyô doho ek ini Antiok imbiŋ Pol lo Banabas. Ma elam iniŋ anyô bêŋ ju. Yaŋ ma Judas, anêŋ athêŋ yaŋ nena Balsabas, ma yaŋ ma Silas. ");
INSERT INTO hot_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ma eto kapya te ba êv hadêŋ thêlô. Kapya êŋ hanaŋ aêntêk. Yêlô avaka lôk aposel, môlônim môlôviyaŋ, yêlô ato kapya êntêk hadêŋ môlô avômalô loŋ buyaŋ takatu ba ôêvhaviŋ ba ômô malak Antiok lôk plovins Silia lôk Silisia. Aiyaŋ thêlô, waklêvôŋ mavi. ");
INSERT INTO hot_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Yêlô alaŋô yôv nena yêlôaniŋ avômalô doho bôk êthôk ba ibuliŋ môlônim auk ba êv malaiŋ hadêŋ môlô hathak abô takatu ba enaŋ. Yêlô miŋ êv i ba êthôk ami. Mi, thêlôda êthôk. ");
INSERT INTO hot_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ba intu yêlô alôk ek nanêm anyô doho ba nêsôk imbiŋ Pol lo Banabas, thai atu ba yêlô leŋiŋhaviŋ bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Thai bôk etak iniŋ lôkmala ek nindum Yisu Kilisi anêŋ ku. ");
INSERT INTO hot_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aêŋ ba yêlô êv Judas lo Silas ek nepesaŋ abô ek embatho kapya êntêk loŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Yêlô lôk Lovak Matheŋ adô nanêm malaiŋ êndêŋ môlô. Ba intu yêlô leŋiŋhaviŋ môlô nosopa abô takêntêk iyom. ");
INSERT INTO hot_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Miŋ oŋgwaŋ nôm takatu ba anyô êv hatôm da hadêŋ ŋgôk dahô ami. Lôk miŋ nunum thalaleŋ ami ma miŋ oŋgwaŋ alim takatu ba ekak leŋselo siŋ ba thalaleŋ hamô kapô ami, lôk notak sek waliliŋ. Môlô udum aêŋ, ma mavi. Waklêvôŋ mavi môlô lôkthô. ");
INSERT INTO hot_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Eto kapya êŋ yôv ma êv hadêŋ thêlô ba ewa ba i tamu Antiok. Êyô Antiok ma elam avômalô êvhaviŋ ethak doŋtom ma êv kapya êŋ hadêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ma avômalô Antiok esam kapya êŋ, ma kapya êŋ havatho thêlô loŋ ba thêlô leŋiŋmavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas lo Silas, thai ma plopet. Ba enaŋ abô bêŋ anôŋ ek evatho ŋê êvhaviŋ loŋ lôk idum thêlô nimbitak lôklokwaŋ. ");
INSERT INTO hot_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Êmô loŋ êŋ wak doho vêm ma avômalô êvhaviŋ anêŋ loŋ êŋ êv mek labali hadêŋ thai ma êv thai ba êvôi hadêŋ ŋê taksêbôk ba êv thai ba êlêm. ");
INSERT INTO hot_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ma doŋtom Pol lo Banabas êmô Antiok ma idum ku haviŋ avômalô bêŋ anôŋ ek enaŋ lo êdôŋ avômalô hathak Anyô Bêŋ anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Wak doho hale ba hi ma Pol hanaŋ hadêŋ Banabas, “Alai ana ek nagê avômalô êvhaviŋ embeŋ malak nenanena taksêbôk ba alai anaŋ Anyô Bêŋ anêŋ abô hadêŋ i. Ma nagê nena thêlô êmô mavi mena mi e?” ");
INSERT INTO hot_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ma Banabas lahaviŋ enja Jon atu ba elam nena Mak imbiŋ thai, ");
INSERT INTO hot_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ma doŋtom Pol hanaŋ nena, “Ôpêŋ bôk hatak alai halôk plovins Pampilia ma miŋ haviŋ alai ba hadum ku ami. Ba intu dô.” ");
INSERT INTO hot_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Thai êkôki mathalaleŋ aleba thai evaki vose. Ba Banabas hawa Mak haviŋ yani ba thai ethak yeŋ ba i ŋgavithôm Saiplus. ");
INSERT INTO hot_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ma Pol hawa Silas haviŋ yani. Êŋ ma avômalô êvhaviŋ anêŋ Antiok êv mek ek Wapômbêŋ anêŋ wapôm êmô imbiŋ thai. Vêm ma etak i ");
INSERT INTO hot_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ba i plovins Silia lôk Silisia iniŋ malak nenanena ba evatho avômalô êvhaviŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol hi hayô Debi lo Listla. Loŋ êŋ ma anyô hêvhaviŋ te hamô ba anêŋ athêŋ nena Timoti. Talêbô ma avi Islael te atu ba hêvhaviŋ. Ma lambô ma anyô Glik te. ");
INSERT INTO hot_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ma avômalô êvhaviŋ anêŋ Listla lo Aikoniam enaŋ nena Timoti ma anyô mavi. ");
INSERT INTO hot_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Aêŋ ba Pol lahaviŋ ôpêŋ ni imbiŋ yani. Ma doŋtom lahabi nena avômalô Islael takatu ba êmô loŋ êŋ eyala nena Timoti anêŋ lambô ma anyô Glik te. Ba intu hawa Timoti ba hi ek neŋgothe anêŋ kupik vê. ");
INSERT INTO hot_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ma thêlô eveŋ ba i lomalak lomalak ma enaŋ abô takatu ba aposel lôk avaka bôk evak anêŋ Jelusalem ek avômalô nesopa. ");
INSERT INTO hot_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Aêŋ ba avômalô êvhaviŋ ibitak lôklokwaŋ hathak iniŋ êvhaviŋ ba wak nômbêŋ intu ma êvôv avômalô lukmuk êyô ba ilumbak hi ba hi. ");
INSERT INTO hot_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ma Lovak Matheŋ miŋ halôk ek Pol thêlô ini nenaŋ Wapômbêŋ anêŋ abô embeŋ plovins Esia ami. Ba intu i Plijia lo Galesia iniŋ malak nenanena. ");
INSERT INTO hot_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ma êyô pik Misia anêŋ daŋ ma idum ek ini plovins Bitinia, ma doŋtom Yisu anêŋ Lovak Matheŋ miŋ halôk ek ini loŋ êŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ba intu thêlô êv Misia liliŋ ma i tamu Tloas. ");
INSERT INTO hot_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ma bôlôvôŋ ma Pol hatulak ma hayê wêŋ te nena anyô plovins Masedonia te hamiŋ ma hapetenak nena, “Ôlêm Masedonia ek nêm yêlô sa.” ");
INSERT INTO hot_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol hayê wêŋ êŋ yôv ma yêlô apesaŋ i ketheŋ ek ana Masedonia. Yêlô ayala nena Wapômbêŋ halam yêlô ek ana nanaŋ Abô Mavi êŋ bêŋ êndêŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Vêm ma yêlô athak yeŋ te hêk Tloas ba a nôŋnôŋ hadêŋ ŋgavithôm Samotles ma wak yaŋ ma a Niapolis. ");
INSERT INTO hot_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Vêm ma yêlô a Pilipai. Malak êŋ ma Masedonia iniŋ malak bêŋ ma avômalô Lom takatu ba eyabiŋ pik takêŋ ethak êmô loŋ êŋ. Ma yêlô amô wak doho hamô loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ma Sabat hayô ma yêlô ale malak bêŋ anêŋ badêŋ abôlêk ba a ŋaŋ te hêk viyaiŋ. Yêlô leŋiŋhabi nena loŋ eteŋ mek hêk habobo ŋaŋ êŋ la. Ma ŋaŋ êŋ ma yêlô ayê avi doho ethak doŋtom ba êmô. Êŋ ma yêlô alôk amô haviŋ thêlô ma anaŋ abô hadêŋ i. ");
INSERT INTO hot_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ma avi Taiataila te halaŋô abô êŋ, ba anêŋ athêŋ nena Lidia. Avi êŋ hadum ku valu hathak sôp thalaleŋ ek avômalô êv vuli ma hathak hêv yeŋ hadêŋ Wapômbêŋ. Anyô Bêŋ hik avi êŋ anêŋ kapô liliŋ ek halaŋô Pol anêŋ abô ba hêvhaviŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Vêm ma yani lôk avômalô takatu ba êmô anêŋ unyak sapêŋ ithik ŋaŋ. Êŋ ma yani hanaŋ hadêŋ yêlô, “Môlô lêk ôyê ya hatôm avi yahêvhaviŋ Anyô Bêŋ, êŋ ma nôlêm nômô yenaŋ unyak.” Ma yani haŋgasi yêlô aleba yêlô a anêŋ unyak. ");
INSERT INTO hot_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wak te ma yêlô a loŋ neteŋ mek ma avi te atu ba anêŋ alaŋsi êmô hapôm yêlô. Yani ma avi lôk ŋgôk ba anêŋ ŋgôk hathak hêv yani sa ek hayala nôm takatu ba tem imbitak embeŋ yam ba hanaŋ bêŋ. Yani hathak havôv valu bêŋ hathak anêŋ ku êŋ ba hêv hadêŋ anêŋ alaŋsi. ");
INSERT INTO hot_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yani hasopa yêlô lôk Pol ma halam kaêk lôbôlôŋ aêntêk, “Ŋê êntêk êŋ ma Wapômbêŋ Leŋ Anôŋ Biŋ anêŋ ŋê ku. Ba lêk enaŋ hathak malêla takatu ma nundum ek Wapômbêŋ nêm môlô bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wak bêŋ anôŋ ma yani hathak halam aêŋ aleba habuliŋ Pol kapô kambom anôŋ. Ba intu hik i liliŋ ma hanaŋ hadêŋ ŋgôk êŋ nena, “Hathak Yisu Kilisi anêŋ athêŋ ma yanaŋ êndêŋ o nena otak avi intu ba nu!” Ma ketheŋ oyaŋ ma ŋgôk êŋ hatak avi êŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ma avi êŋ anêŋ alaŋsi êyê nena iniŋ loŋôndê nêbôv valuseleŋ lêk mi, êŋ ma evaloŋ Pol lo Silas ba êvôv thai ba i malak lôŋ êŋ anêŋ loŋ ethak doŋtom halôk ek nimiŋ ŋê idum abô hathak maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","Ewa thai ba êyô ek ŋê takatu ba idum abô hathak ba enaŋ, “Anyô ju êntêk ma ŋê Islael. Thai enaŋ ek avômalô nesopa kobom takatu ba kambom ek alalô avômalô Lom. Ba intu ibi avômalô malak bêŋ êntêk leŋiŋ liŋ ba leŋiŋŋaŋa mayaliv.” ");
INSERT INTO hot_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ma avômalô bêŋ anôŋ enaŋ abô lôk leŋiŋmaniŋ hathak thai haviŋ. Êŋ ma ŋê takatu ba idum abô hathak enaŋ ek nimbi iniŋ kwêv thô ma nebali thai esak yak wabeŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Evali thai kambom anôŋ vêm ma ibi thai halôk koladôŋ kapô. Ma enaŋ hadêŋ ôpatu ba hayabiŋ koladôŋ nena eyabiŋ thai dedauŋ mavi. ");
INSERT INTO hot_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ôpêŋ halaŋô abô êŋ, ma hawa thai ba halôk ba hi hadô hamô tamu koladôŋ kapô ali atu ba hêk vibiŋ anôŋ ma esoŋ veŋiŋ halôk alokwaŋ abyaŋ ba hadahaliŋ veŋiŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ma bôlôvôŋ biŋ ma Pol lo Silas eteŋ mek ba êv yeŋ hadêŋ Wapômbêŋ, ma ŋê koladôŋ vi elaŋô. ");
INSERT INTO hot_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ma ketheŋ oyaŋ ma duviaŋ bêŋ te hayô ba hayôkwiŋ koladôŋ anêŋ landiŋ. Ma koladôŋ abôlêk sapêŋ hakyav ma seŋ takatu ba ibutiŋ thêlô veŋiŋ lo baheŋiŋ sapêŋ hêv yak. ");
INSERT INTO hot_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ma ôpatu ba hayabiŋ koladôŋ haviyô ma hayê koladôŋ anêŋ abôlêk sapêŋ lêk abyaŋ. Ma lahabi nena ŋê koladôŋ sapêŋ lêk êsôv ba i, ba intu hadadi anêŋ biŋ vovak ek embatho yanida vônô esak. ");
INSERT INTO hot_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ma doŋtom Pol halam lôklokwaŋ, “Miŋ ômbi o vônô ami! Yêlô sapêŋ êntêk amô!” ");
INSERT INTO hot_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Êŋ ma ôpêŋ halam ek neja atum êlêm ma halaŋviŋ ba hi koladôŋ kapô, ma hakô ba halowaliŋ ba hêv yak halôk Pol lo Silas maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Vêm ma hawa thai ba hi yaiŋ ma hanaŋ, “Anyô bêŋ luvi, yandum malê ek yanja bulubiŋ?” ");
INSERT INTO hot_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ma thai enaŋ viyaŋ, “Ônêmimbiŋ Anyô Bêŋ Yisu ma tem Wapômbêŋ nêm o lôk anêm avômalô bulubiŋ.” ");
INSERT INTO hot_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Êŋ ma thai enaŋ Anyô Bêŋ anêŋ abô hadêŋ yani lôk avômalô takatu ba êmô anêŋ unyak kapô. ");
INSERT INTO hot_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Bôlôvôŋ denaŋ ma yani hawa thai ba hi hathik iniŋ palê. Vêm ma Pol lo Silas ithik ôpêŋ lôk anêŋ avômalô sapêŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ma yani hawa thai ba hi anêŋ unyak ma hêv nôm hadêŋ thai. Yani lôk anêŋ avômalô sapêŋ leŋiŋmavi anôŋ ek lêk êvhaviŋ Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Haviyô hayaŋ lôkbôk ma ŋê takatu ba idum abô hathak êv iniŋ sôp bidoŋ ba i hadêŋ ôpatu ba hayabiŋ koladôŋ ma enaŋ nena, “Otak anyô ju intu ba ini.” ");
INSERT INTO hot_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ma ôpatu ba hayabiŋ koladôŋ hi hanaŋ hadêŋ Pol nena, “Ŋê takatu ba idum abô hathak enaŋ nena mamu lôk Silas notak koladôŋ ba unu. Ba intu unu lôk kapôlômim labali.” ");
INSERT INTO hot_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ma doŋtom Pol hanaŋ hadêŋ sôp bidoŋ takêŋ nena, “Yai ma ŋê Islael ma Lom haviŋ. Ma doŋtom ik yai oyaŋ ma miŋ enaŋ yaianiŋ kambom bêŋ ami. Ma ibi yai halôk koladôŋ kapô. Ma Lom iniŋ balabuŋ hanaŋ nena miŋ hatôm nindum aêŋ êndêŋ ŋê Lom ami. Ma lêk ekopak ba idum ek netak yai menaŋna ba ana e? Mi anôŋ! Thêlôda nêlêm ma neja yai vê ênjêk koladôŋ.” ");
INSERT INTO hot_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ma sôp bidoŋ ewa abô êŋ ba i enaŋ hadêŋ ŋê takatu ba idum abô hathak. Ma elaŋô nena thai ma ŋê Lom haviŋ, êŋ ma thêlô êkô kambom. ");
INSERT INTO hot_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ma thêlô i ma ibui hadêŋ Pol lo Silas ma ewa thai ele yaiŋ. Ma enaŋ nena, “Hatôm mamu notak loŋ êntêk ba unu e?” ");
INSERT INTO hot_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Êŋ ma thai etak koladôŋ ma ele yaiŋ ma i Lidia anêŋ unyak. Ma êyê avômalô êvhaviŋ ma enaŋ abô doho ek embatho iniŋ kapôlôŋiŋ loŋ. Vêm ma etak i ba i. ");
INSERT INTO hot_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol lo Silas êv malak Ampipolis lo Apolonia liliŋ ma i thêthô ba êyô Tesalonaika. Ma Islael iniŋ unyak yeŋ te hamô loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Sabat te lô ma Pol hasopa anêŋ kobom ba habitak hayô unyak yeŋ êŋ kapô. Ma hadôŋ avômalô hathak Wapômbêŋ anêŋ kapya. ");
INSERT INTO hot_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ma hik thô nena kapya êŋ ma hanaŋ nena Mesia tem enja vovaŋ ba ema ma imbiyô esak loŋbô. Êŋ ma Pol hik thô nena, “Yisu atu ba yahanaŋ hadêŋ môlô, ôpêŋ intu Mesia êŋ.” ");
INSERT INTO hot_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ma avômalô Islael doho lôk avômalô Glik bêŋ anôŋ atu ba êmô Wapômbêŋ vibiŋ lôk avi lôk athêŋ bêŋ doho elaŋô ma êvhaviŋ ba i iviŋ Pol lo Silas. ");
INSERT INTO hot_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ma doŋtom avômalô Islael leŋiŋdaŋ ba ewa ŋê kambom doho anêŋ loŋ ethak doŋtom halôk ba isup avômalô bêŋ anôŋ ethak doŋtom ek nijik avômalô malak êŋ iniŋ kapôlôŋiŋ liŋ. Ma thêlô elaŋviŋ ba i Jeson anêŋ unyak ek nêmbôlêm Pol lo Silas ek nebaloŋ thai ba neja ende yaiŋ ba ini nênêm êndêŋ avômalô nômbêŋ atu. ");
INSERT INTO hot_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ma doŋtom miŋ êpôm thai ami, êŋ ma êvôv Jeson lôk ŋê êvhaviŋ doho ba ewa i hi hadêŋ ŋê bêŋbêŋ loŋ êŋ maleŋiŋ ma elam aêntêk, “Ŋê êntêk êŋ idum nôm kambom haveŋ pik lôkthô aleba lêk êyô loŋ êntêk. ");
INSERT INTO hot_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ma Jeson hawa thêlô thô ba hadô i hamô anêŋ unyak. Ŋê takêŋ êdô nêmô Lom iniŋ Kiŋ Sisa anêŋ abô majaŋ vibiŋ ba enaŋ nena, ‘Kiŋ yaŋ hamô ba anêŋ athêŋ nena Yisu.’” ");
INSERT INTO hot_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ŋê bêŋbêŋ lôk avômalô nômbêŋ atu elaŋô abô êŋ ma esoŋ kambom ba kapôlôŋiŋ haliŋ i kambom. ");
INSERT INTO hot_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yôv ma malak êŋ anêŋ ŋê bêŋbêŋ enaŋ hadêŋ Jeson thêlô nena, “Nônêm valuseleŋ ek injik thô nena tem miŋ nundum kambom êŋ esak loŋbô ami. Ba ômô tiŋiŋ, ma tem noja unim valu esak loŋbô.” Êŋ ma êv valu ma etak i ba i. ");
INSERT INTO hot_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bôlôvôŋ êŋ iyom ma ŋê êvhaviŋ êv Pol lo Silas vê hêk Tesalonaika ba i Belia. Êyô Belia ma i Islael iniŋ unyak yeŋ. ");
INSERT INTO hot_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Avômalô Belia iniŋ kobom ma mavi anôŋ ek avômalô Tesalonaika iniŋ. Thêlô elaŋô Pol lo Silas iniŋ abô lôk kapôlôŋiŋ mavi ba wak nômbêŋ intu ma êyê Wapômbêŋ anêŋ kapya ek nêgê nena iniŋ abô ma avanôŋ mena mi. ");
INSERT INTO hot_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Êŋ ma avômalô Islael bêŋ anôŋ êvhaviŋ ma avi Glik lôk athêŋ bêŋ doho lôk anyô Glik bêŋ anôŋ êvhaviŋ aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Vêm ma avômalô Islael anêŋ Tesalonaika elaŋô nena Pol hanaŋ Wapômbêŋ anêŋ abô hadêŋ avômalô Belia. Êŋ ma thêlô i loŋ êŋ ma elela iniŋ auk ek thêlô leŋiŋmaniŋ. ");
INSERT INTO hot_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ketheŋ oyaŋ ma ŋê êvhaviŋ anêŋ Belia êv Pol ba hi ŋgwêk daŋ, ma Silas lo Timoti iyom êmô Belia. ");
INSERT INTO hot_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ma ŋê takatu ba elom Pol ba i ma iviŋ yani ba i Atens. Ma etak Pol ek nêbôni, ma hêv abô hadêŋ i ek nenaŋ êndêŋ Silas lo Timoti nena ini ketheŋ. ");
INSERT INTO hot_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol hayabiŋ thai hamô Atens ma hayê nena ŋê lôŋ êŋ iniŋ ŋgôk dahô bêŋ anôŋ êmô ba kapô malaiŋ kambom. ");
INSERT INTO hot_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Aêŋ ba yani hi avômalô Islael iniŋ unyak yeŋ kapô ma hanaŋ abô haviŋ avômalô Islael lôk avômalô loŋ buyaŋ takatu ba êmô Wapômbêŋ vibiŋ. Ma wak nômbêŋ intu ma yani hathak hi loŋ ethak doŋtom halôk ek enaŋ abô imbiŋ avômalô takatu ba êmô loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ma ŋê lôkauk ôdôŋ ju êmô, yaŋ iniŋ athêŋ nena Epikulian ma yaŋ ma Stoik. Thêlô elaŋô Pol hanaŋ Abô Mavi hathak Yisu lôk anêŋ haviyô hathak loŋbô. Ba intu thêlô lôk Pol êkôki. Ma vi enaŋ, “Anyô abô mayaliv êntêk hadum ek enaŋ malê?” Ma vi enaŋ, “Yani hanaŋ hathak wapômbêŋ masôm doho.” ");
INSERT INTO hot_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Yôv ma thêlô ewa Pol ba i êdô hamô Aliopagas, loŋ atu ba avômalô ethak doŋtom ek enaŋ abô hathak auk lomaloma anêŋ ôdôŋ. Ma thêlô enaŋ, “Yêlô leŋiŋhaviŋ nayala auk lukmuk takatu ba honaŋ hadêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Abô takatu ba honaŋ ma hatôm abô masôm ek yêlô. Aêŋ ba yêlô leŋiŋhaviŋ nayala anêŋ ôdôŋ.” ");
INSERT INTO hot_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Wak nômbêŋ intu ma avômalô Atens lôk avômalô loŋ buyaŋ takatu ba êmô Atens ethak doŋtom ek nedaŋô abô esak auk lukmuk takatu ba hayô ek nenaŋ abô pôk esak. Ma miŋ idum nômla yaŋ haviŋ ami. Ba intu leŋiŋhaviŋ nedaŋô Pol anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","23","Êŋ ma Pol haviyô hamiŋ Aliopagas maleŋiŋ ma hanaŋ, “Môlô ŋê Atens, lêk yahaveŋ môlônim loŋ ba yahayê nôm takatu ba môlô ôêv yeŋ hadêŋ. Ma yahapôm loŋ êbôk da te ba abô te hanaŋ nena, ‘Loŋ êntêk ma wapômbêŋ te atu ba yêlô athôŋ paliŋ anêŋ loŋ êbôk da.’ Ba intu yahayala nena môlô udum nôm lomaloma ek ôêv athêŋ bêŋ hadêŋ unim wapômbêŋ lomaloma. Ma wapômbêŋ atu ba môlô ôthôŋ paliŋ ba ôêv yeŋ hathak, êntêk tem yanaŋ bêŋ êndêŋ môlô. ");
INSERT INTO hot_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Wapômbêŋ atu ba hapesaŋ pik lôk anêŋ nômkama sapêŋ, ma yani ma pik lo leŋ iniŋ alaŋ. Ma miŋ hamô unyak matheŋ atu ba elav hathak baheŋiŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Yanida hêv lovak kapôlôŋiŋ lôk lôkmala ma nômkama sapêŋ hadêŋ avômalô lôkthô. Ma yani miŋ hêv yak hathak nômlate ek anyôla nêm yani sa ami, ma mi. ");
INSERT INTO hot_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hathak anyô doŋtom iyom ma yani habi avômalô lodôŋlodôŋ sapêŋ vê ek nêmô pik bêŋ êntêk sapêŋ. Yanida hatak iniŋ waklavôŋ lôk iniŋ loŋ takatu ba nêmô. ");
INSERT INTO hot_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Wapômbêŋ hadum nôm takêŋ ek avômalô sapêŋ nêgê ba nêmbôlêm yani atu ba êthôŋ. Ma doŋtom miŋ hamô daim ek alalô tomtom ami. ");
INSERT INTO hot_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“Mi, hatôm anyô lôkauk te bôk hato nena, ‘Yani habibôm hayô hêk alalô vôv ba awa lôkmala lôk aveŋ ma lôkmala anêŋ ôdôŋ ma halêm anêŋ yani iyom.’ Ma unim ŋê lôkauk te bôk hato nena, ‘Alalô ma yani anêŋ nali.’ ");
INSERT INTO hot_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Avanôŋ biŋ nena alalô ma Wapômbêŋ anêŋ nali ba intu miŋ mavi ek leŋiŋimbi nena yani ma hatôm dahô takatu ba epesaŋ hathak gol lo seleva ma valu ami. Mi, dahô takêŋ ma anyô epesaŋ hathak baheŋiŋ lôk iniŋ auk iyom. ");
INSERT INTO hot_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Sêbôk ma avômalô êthôŋ Wapômbêŋ paliŋ ba intu yani miŋ hêv kambom êŋ anêŋ viyaŋ hadêŋ i ami. Ma doŋtom yani lêk hanaŋ lôklokwaŋ hadêŋ avômalô pik sapêŋ nena nede kapôlôŋiŋ liliŋ. ");
INSERT INTO hot_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Yani bôk hatak waklavôŋ te yôv ek nindum abô. Ma bôk hatak anyô te ek indum ku êŋ thêthôŋ. Ôpêŋ bôk hama ma Wapômbêŋ hik liŋ hêk ŋama ek injik thô nena yani tem endaŋô avômalô sapêŋ iniŋ abô.” ");
INSERT INTO hot_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Thêlô elaŋô Pol anêŋ abô hathak anyô haviyô hêk ŋama, êŋ ma vi ibi anêŋ abô êŋ liliŋ ma doŋtom vi enaŋ, “Yêlô leŋiŋhaviŋ nadaŋô anêm abô esak nôm êntêk esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Vêm ma Pol hatak thêlô ba hi. ");
INSERT INTO hot_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Thêlô doho êvhaviŋ ba esopa yani. Thêlô êŋ te ma Dionisius, yani ma Aliopagas iniŋ anyô te, lôk avi te ba anêŋ athêŋ nena Damalis, ma doho haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Vêm ma Pol hatak Atens ma hi Kolin. ");
INSERT INTO hot_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ma hapôm anyô Islael te ba anêŋ athêŋ nena Akwila. Yani anêŋ malak ôdôŋ ma plovins Pontus. Bôk lovêŋ Plisila êmô malak Lom anêŋ Itali vêm ma Kiŋ Klodias hanaŋ ek avômalô Islael sapêŋ netak Lom ba ini. Aêŋ ba thai i Kolin. Ba intu Pol hi ek ênjê thai. ");
INSERT INTO hot_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Thai ethak idum ku epesaŋ unyak hathak alim kupik ek nênêm vuli. Ku êŋ ma Pol anêŋ ku hathak hadum ba intu hamô haviŋ thai ba hadum ku êŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabat sapêŋ ma Pol hi Islael iniŋ unyak yeŋ ma hanaŋ abô haviŋ thêlô ek injik avômalô Islael lôk Glik iniŋ auk liliŋ ek nênêmimbiŋ. ");
INSERT INTO hot_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ma Silas lo Timoti etak Masedonia ma êlôk ba i Kolin, êŋ ma Pol hatak anêŋ ku epesaŋ sôp ma hanaŋ Wapômbêŋ anêŋ abô iyom. Ba hanaŋ bêŋ hadêŋ avômalô Islael nena, “Yisu ma Mesia atu.” ");
INSERT INTO hot_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Vêm ma thêlô êpôlik hathak Pol ma enaŋ abôma hathak yani. Êŋ ma yani hik voŋgovaŋ vê hêk anêŋ kwêv ek injik Wapômbêŋ anêŋ lamaniŋ thô ma hanaŋ hadêŋ thêlô, “Malaiŋ atu ba tem êpôm môlô, êŋ ma môlôda unim kambom ma miŋ yenaŋ kambom ami. Ma lêk yahatak môlô avômalô Islael ma yaha ek avômalô loŋ buyaŋ.” ");
INSERT INTO hot_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Êŋ ma Pol hatak unyak yeŋ hêk ma hi hamô Titius Jastas anêŋ unyak. Ôpêŋ ma anyô loŋ buyaŋ atu ba hathak hêv yeŋ hadêŋ Wapômbêŋ ba anêŋ unyak hamô habobo unyak yeŋ atu. ");
INSERT INTO hot_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ma Klispus, anyô bêŋ atu ba hayabiŋ Islael iniŋ unyak yeŋ, lôk anêŋ avômalô takatu ba êmô anêŋ unyak êvhaviŋ Anyô Bêŋ. Ma avômalô Kolin bêŋ anôŋ elaŋô Pol anêŋ abô ba êvhaviŋ ma ithik ŋaŋ. ");
INSERT INTO hot_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ma bôlôvôŋ te ma Pol hayê wêŋ ma Anyô Bêŋ hanaŋ hadêŋ yani nena, “Onaŋ abô takêŋ bêŋ ma miŋ ôkô ba o bônôŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Yahamô haviŋ o ba miŋ hatôm anyô late êyô ba imbuliŋ o ami. Mi, yenaŋ avômalô bêŋ anôŋ êmô malak êntêk.” ");
INSERT INTO hot_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Aêŋ ba Pol hamô Kolin ba hadôŋ avômalô hathak Wapômbêŋ anêŋ abô hatôm sondabêŋ te lôk ayôŋ baheŋvi ba lahavute haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Waklavôŋ Galio hayabiŋ plovins Akaia, êŋ ma avômalô Islael anêŋ Kolin ethak doŋtom ba idum leŋiŋŋaŋa hathak Pol ba ewa yani ba i loŋ idum abô. ");
INSERT INTO hot_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Êŋ ma thêlô enaŋ, “Ôpêntêk hadôŋ avômalô ek nênêm yeŋ êndêŋ Wapômbêŋ hathak loŋôndê yaŋda atu ba habuliŋ abô balabuŋ.” ");
INSERT INTO hot_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol hadum ek enaŋ abô êŋ viyaŋ, êŋ ma Galio hanaŋ hadêŋ avômalô Islael takatu nena, “Môlô avômalô Islael, môlô ôyê nena ôpêntêk hadum nômlate ba habuliŋ Lom iniŋ abô majaŋ mena hadum kambom bêŋ te, êŋ ma mavi ek yandaŋô môlônim abô. ");
INSERT INTO hot_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ma doŋtom abô takatu ba môlô onaŋ hathak ôpêntêk ma hathak abô lôk athêŋ doho ma môlô Islael da unim abô balabuŋ. Ba intu tem miŋ yandaŋô abô êŋ ami. Mi, môlôda nopesaŋ abô êŋ.” ");
INSERT INTO hot_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ba intu hêv thêlô vê hêk loŋ idum abô. ");
INSERT INTO hot_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Êŋ ma thêlô evaloŋ Islael iniŋ unyak yeŋ anêŋ anyô bêŋ te anêŋ athêŋ nena Sostenes hêk ba ik yani habobo loŋ atu ba idum abô viyaiŋ. Ma Galio hayê ma hadum hatôm hathôŋ paliŋ. ");
INSERT INTO hot_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol hamô Kolin sawa daim dokte. Vêm ma hatak ŋê êvhaviŋ ma hi tamu Senklia ek enja yeŋ ba ni Silia. Ma Plisila lo Akwila iviŋ yani ba i. Pol bôk havak abô haviŋ Wapômbêŋ hathak nômlate ba intu miŋ hakapiŋ wakadôk ŋauŋ ami aleba hayô Senklia. Êŋ ma abô êŋ anêŋ daŋ ba intu hakapiŋ wakadôk ŋauŋ vê. ");
INSERT INTO hot_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","21","Vêm ma ethak yeŋ te ba i Epesus. Ma Pol hi Islael iniŋ unyak yeŋ ma hanaŋ abô haviŋ avômalô Islael. Ma thêlô enaŋ ek yani êmô imbiŋ thêlô wak doho vêmam, ma doŋtom yani miŋ halôk hathak iniŋ abô ami. Ba hathak yeŋ ma hanaŋ hadêŋ thêlô nena, “Wapômbêŋ anêŋ lahaviŋ ma tem yambôalêm êndêŋ môlô esak loŋbô.” Êŋ ma yani hatak Epesus ba hi. Ma hadô Plisila lo Akwila êmô Epesus. ");
INSERT INTO hot_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ma yeŋ hi Sisalia ma Pol hatak yeŋ êŋ ma hathak ba hi Jelusalem ek ênjê avômalô êvhaviŋ anêŋ loŋ êŋ. Vêm ma halôk ba hi Antiok hamô Silia kapô. ");
INSERT INTO hot_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol hamô wak doho hamô Antiok vêm ma hi plovins Galesia lo Plijia iniŋ malak nenanena ek embatho avômalô êvhaviŋ kapôlôŋiŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ma anyô Islael te anêŋ athêŋ nena Apolo hi hayô Epesus. Yani anêŋ malak ôdôŋ ma Aleksandlia. Yani ma anyô lôkauk bêŋ ba hayala Wapômbêŋ anêŋ abô dedauŋ mavi. ");
INSERT INTO hot_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bôk êdôŋ yani hathak Anyô Bêŋ anêŋ loŋôndê ba intu kapô lôklokwaŋ ek êdôŋ avômalô esak auk thêthôŋ êŋ. Ma hanaŋ abô thêthôŋ hathak Yisu anêŋ bôk lo loŋ vi. Ma doŋtom hayala ŋaŋ atu ba Jon hathik avômalô hathak iyom. ");
INSERT INTO hot_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yani hi avômalô Islael iniŋ unyak yeŋ ma hanaŋ abô hathak Yisu ma miŋ hakô ami. Ba Plisila lo Akwila elaŋô anêŋ abô ma elam yani ba hi iniŋ unyak ma ewa Wapômbêŋ anêŋ abô atu ba miŋ hayala ami sa hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Vêm ma Apolo lahaviŋ ni plovins Akaia, ma avômalô êvhaviŋ anêŋ Epesus evatho yani anêŋ auk loŋ ek indum aêŋ. Ba eto kapya hadêŋ avômalô êvhaviŋ anêŋ Akaia ek neja yani thô. Hi hayô Akaia, êŋ ma hêv avômalô takatu ba êvhaviŋ Wapômbêŋ hathak anêŋ wapôm sa bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yani hamiŋ lôklokwaŋ ba hanaŋ avômalô Islael iniŋ abô viyaŋ hêk avômalô sapêŋ maleŋiŋ. Ma hawa Wapômbêŋ anêŋ kapya sa ba hik thô nena Yisu ma Mesia atu ba Wapômbêŋ bôk havak abô yôv ek nêm êlêm. ");
INSERT INTO hot_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo hamô Kolin denaŋ ma Pol hi haveŋ plovins Galesia lo Plijia kapô ba haveŋ aleba hayô Epesus. Loŋ êŋ ma hapôm avômalô êvhaviŋ doho ");
INSERT INTO hot_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ma hanaŋ hik thêlô liŋ, “Bôk ôêvhaviŋ ba owa Lovak Matheŋ e?” Ma thêlô enaŋ, “Mi, yêlô miŋ bôk alaŋô abô te hathak Lovak Matheŋ ami.” ");
INSERT INTO hot_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Êŋ ma Pol hanaŋ, “Ŋaŋ malê intu bôk môlô uthik?” Ma enaŋ, “Jon anêŋ ŋaŋ.” ");
INSERT INTO hot_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ma Pol hanaŋ, “Jon bôk hathik avômalô hathak ŋaŋ nede kapôlôŋiŋ liliŋ ma hanaŋ ek avômalô nênêmimbiŋ ôpatu ba haveŋ yani yam. Ôpêŋ ma Yisu.” ");
INSERT INTO hot_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Thêlô elaŋô abô êŋ, ma ithik ŋaŋ hathak Anyô Bêŋ Yisu anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ma Pol hatak baŋ hayô hêk thêlô, êŋ ma Lovak Matheŋ hayô hamô thêlô ba enaŋ abô masôm lôk abô plopet. ");
INSERT INTO hot_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ŋê takêŋ ma hatôm laumiŋ ba lahavuju la. ");
INSERT INTO hot_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Êŋ ma Pol hi hamô Epesus hatôm ayôŋ lô. Ma hathak hi avômalô Islael iniŋ unyak yeŋ ma hanaŋ abô hathak Wapômbêŋ anêŋ loŋ lôkliŋyak ek thêlô nênêmimbiŋ ma miŋ hakô ami. ");
INSERT INTO hot_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ma doŋtom thêlô doho evaloŋ kapôlôŋiŋ loŋ ba miŋ êvhaviŋ ami ma enaŋ abôma hathak Anyô Bêŋ anêŋ loŋôndê bêŋ ek avômalô sapêŋ nedaŋô. Aêŋ ba Pol hatak thêlô ma hawa ŋê êvhaviŋ ba i Tailanus anêŋ kapo ekaksa halôk. Ma wak nômbêŋ intu ma thêlô enaŋ abô hamô loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol hadum aêŋ hatôm sondabêŋ ju. Aêŋ ba intu avômalô Islael lôk avômalô Glik takatu ba êmô plovins Esia elaŋô Anyô Bêŋ anêŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Wapômbêŋ hêv lôklokwaŋ hadêŋ Pol ba hadum nômbithi yaŋda lomaloma. ");
INSERT INTO hot_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ba intu sôp seleŋ lo sôp daŋ takatu ba Pol hasôm, ewa ba i ethav hathak avômalô lôk lijiŋ ba ibitak mavi ma ŋgôk etak i ba i. ");
INSERT INTO hot_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ma avômalô Islael doho idum ku nênêm ŋgôk vê ba ethak i lomalak lomalak. Ma thêlô doho idum ku êŋ, ma elam Anyô Bêŋ Yisu anêŋ athêŋ hayô ŋê lôk ŋgôk takêŋ vôv ba enaŋ, “Hathak Yisu atu ba Pol hanaŋ abô hathak anêŋ athêŋ, yahanaŋ nena otak ôpêntêk ba nu.” ");
INSERT INTO hot_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ma Islael iniŋ ŋê bêŋbêŋ êbôk da te anêŋ athêŋ nena Skeva namalô baheŋvi ba lahavuju idum aêŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ma wak te ma ŋgôk hawê iniŋ abô viyaŋ ba hanaŋ, “Yahayala Yisu, ma yahayala Pol, ma môlô ma opalê?” ");
INSERT INTO hot_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Êŋ ma ôpatu ba ŋgôk havaloŋ loŋ hasôv kisi hayô hêk i ba hik i mayav bomaŋ aleba thêlô sapêŋ ewa thalaleŋ ba êsôv leŋviŋpopam ele unyak viyaiŋ ba i. ");
INSERT INTO hot_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ma avômalô Islael lo Glik anêŋ Epesus elaŋô abô êŋ, ma êkô kambom ba êv athêŋ bêŋ hadêŋ Anyô Bêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ma avômalô êvhaviŋ bêŋ anôŋ êlêm ma enaŋ iniŋ kambom lomaloma bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Thêlô vi êbôk siniŋ ma vi idum aloyak, aêŋ ba isup iniŋ kapya aloyak sapêŋ hathak doŋtom ma êbôk hathak atum hêk avômalô maleŋiŋ. Ekatuŋ kapya takêŋ ba anêŋ vuli hatôm 50,000 seleva. ");
INSERT INTO hot_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Hathak kobom êŋ ma Anyô Bêŋ anêŋ abô halaŋviŋ ba hi mayaliv ma anêŋ lôklokwaŋ halumbak bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nôm takêŋ habitak vêm ma Pol lahabi ni Jelusalem ba halom hêk loŋôndê yaŋ atu hi plovins Masedonia lo Akaia. Ma hanaŋ, “Yaha Jelusalem vêm ma tem yana Lom imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ma yani hêv Timoti lo Elastus, anyô ju atu ba idum ku haviŋ yani, ba i Masedonia. Ma yanida hamô plovins Esia dokte vêmam. ");
INSERT INTO hot_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wak êŋ ma avômalô ethaŋ i hathak Yisu anêŋ loŋôndê ba ŋgalakŋgalak bêŋ habitak. ");
INSERT INTO hot_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Anyô atu ba hadum ba nôm êŋ habitak anêŋ athêŋ nena Demitlius. Ôpêŋ ma anyô hapesaŋ nômkama hathak seleva. Ba hathak hapesaŋ ŋgôkba avi Atemis anêŋ malakba anêŋ dahô ek avômalô nêndô êmô iniŋ unyak kapô. Yani lôk anyô doho ethak êvôv valu bêŋ hathak iniŋ ku êŋ. ");
INSERT INTO hot_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Wak te ma ôpêŋ halam ŋê ku êŋ sapêŋ ethak doŋtom ba hanaŋ, “Aiyaŋ thêlô, odaŋô. Môlô oyala nena alalô avôv valu bêŋ hathak alalôaniŋ ku êntêk. ");
INSERT INTO hot_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ma doŋtom lêk ôyê lo olaŋô abô hathak nôm atu ba Pol hadum. Ôpêŋ hathak hanaŋ nena ŋgôk takatu ba anyô epesaŋ hathak baheŋiŋ, êŋ ma miŋ wapômbêŋ anôŋ ami. Yani hanaŋ aêŋ ba avômalô bêŋ anôŋ êvhaviŋ anêŋ abô ba etak alalôaniŋ ŋgôkba Atemis. Yani hadum aêŋ hamô Epesus ma bidoŋ oyaŋ ma tem anêŋ abô êŋ endaŋviŋ embeŋ plovins Esia sapêŋ. ");
INSERT INTO hot_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nôm êŋ tem indum ba avômalô nêgê alalôaniŋ ku êtôm nôm kambom. Lôk nêgê ŋgôk lôk athêŋ bêŋ ŋgôkba avi Atemis anêŋ malakba êtôm nôm oyaŋ. Ma ŋgôk avi êŋ atu ba avômalô plovins Esia lôk avômalô pik bêŋ êntêk sapêŋ ethak êv yeŋ hathak, yanida anêŋ athêŋ tem nêm yak.” ");
INSERT INTO hot_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Thêlô elaŋô abô êŋ ma leŋiŋmaniŋ kambom ba elam kaêk lôklala nena, “Atemis anêŋ Epesus ma ŋgôkba lôkmaŋgiŋ anôŋ!” ");
INSERT INTO hot_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Bidoŋ oyaŋ ma ŋgalakŋgalak bêŋ êŋ haveŋ Epesus sapêŋ. Ma avômalô evaloŋ Gaius lo Alistakas, thai ma ŋê Masedonia ju atu ba ethak eveŋ haviŋ Pol, ma elaŋviŋ hathak doŋtom ba i iniŋ loŋ evaloŋ sa bêŋbêŋ halôk. ");
INSERT INTO hot_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ma Pol lahaviŋ ni loŋ êŋ kapô ek enaŋ abô êndêŋ avômalô nômbêŋ êŋ, ma doŋtom ŋê êvhaviŋ imiŋ yani loŋ siŋ. ");
INSERT INTO hot_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ma ŋê bêŋbêŋ doho anêŋ plovins Esia takatu ba êmô Epesus, thêlô ma Pol anêŋ ŋê môlô ba êv abô hadêŋ Pol ba enaŋ nena, “Miŋ ôyô kapô ami. Tem nijik o vônô ba dô.” ");
INSERT INTO hot_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ma avômalô nômbêŋ atu ba êmô loŋ êŋ kapô iniŋ auk hêv yak ba elam kaêk lomaloma. Ma bêŋ anôŋ miŋ eyala iniŋ ethak doŋtom êŋ anêŋ ôdôŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ma avômalô Islael isisuŋ iniŋ anyô te anêŋ athêŋ nena Aleksanda ek ni imiŋ avômalô nômbêŋ atu maleŋiŋ ek enaŋ abô esak malaiŋ êŋ. Êŋ ma Aleksanda hêv baŋ hathak leŋ ek avômalô bônôŋ ek enaŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ma doŋtom avômalô nômbêŋ êŋ êyê nena yani ma anyô Islael te, êŋ ma thêlô êvôlô veŋiŋbôlêk hathak doŋtom ba elam lôklala nena, “Atemis anêŋ Epesus ma ŋgôkba lôkmaŋgiŋ anôŋ!” Elam aêŋ halôk ba halôk hatôm wakma lokwaŋju. ");
INSERT INTO hot_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Vêm ma Epesus iniŋ anyô bêŋ hapesaŋ kapya hanaŋ ek avômalô lôkthô bônôŋ. Êŋ ma hanaŋ, “Avômalô Epesus, avômalô pik sapêŋ eyala nena Epesus ma malak bêŋ atu ba hayabiŋ ŋgôkba lôkmaŋgiŋ Atemis anêŋ malakba lôk anêŋ valu matheŋ atu ba hêv yak halôk leŋ ba habup. ");
INSERT INTO hot_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Auk êŋ ma hêk yaiŋ ba avômalô pik sapêŋ eyala. Ba intu môlô bônôŋ ma noyabiŋ am ek miŋ nundum nômlate mayaliv ami. ");
INSERT INTO hot_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Môlô ovaloŋ anyô ju êntêk ba owa ba ôlêm, ma doŋtom miŋ enaŋ abôma hathak alalôaniŋ ŋgôkba avi mena ewa malakba anêŋ nômla vani ami. Mi. ");
INSERT INTO hot_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ma alalôaniŋ unyak nedaŋô abô lôk anêŋ ŋê bêŋbêŋ nindum abô esak i intu êmô. Aêŋ ba Demitlius lôk ŋê takatu ba epesaŋ nômkama hathak seleva iniŋ malaiŋ la hêk, êŋ ma neja ba ini ek ŋê idum abô hathak. ");
INSERT INTO hot_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Aêŋ ba abô yaŋ hamiŋ denaŋ, êŋ ma waklavôŋ atu ŋê idum abô hathak ethak doŋtom, ma nêm êndêŋ i. ");
INSERT INTO hot_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Noyabiŋ am mavi. Ŋê bêŋ Lom idum abô ek alalô hathak nôm ŋgalakŋgalak takatu ba lêk habitak, êŋ ma tem alalô abô mi ek malê nena nôm ŋgalakŋgalak êŋ anêŋ ôdôŋ mi.” ");
INSERT INTO hot_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Yani hanaŋ abô êŋ yôv ma hêv avômalô ba i iniŋ loŋ mayaliv. ");
INSERT INTO hot_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ŋgalakŋgalak bêŋ êŋ lêk yôv, ma Pol halam avômalô êvhaviŋ ethak doŋtom. Ma hanaŋ abô doho ek embatho thêlô loŋ. Vêm ma hanaŋ waklêvôŋ hadêŋ i ma hatak Epesus ba hi Masedonia. ");
INSERT INTO hot_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Yani haveŋ loŋ êŋ anêŋ lomalak nenanena ma hanaŋ abô bêŋ anôŋ ek embatho i loŋ aleba hayô Glis. ");
INSERT INTO hot_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Êŋ ma hamô loŋ êŋ ayôŋ lô. Ma hadum ek enja yeŋ ba ni Silia, ma doŋtom halaŋô nena avômalô Islael ibutiŋ abô nena hathak yeŋ ma thêlô nesak imbiŋ ek nijik yani vônô. Aêŋ ba Pol lahabi nena êmbôni endom plovins Masedonia esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Êntêk ma ŋê takatu ba ethak eveŋ haviŋ Pol iniŋ athêŋ: Sopata anêŋ Belia, yani ma Pailas anêŋ nakaduŋ, ma Alistakas lo Sekandas anêŋ Tesalonaika, ma Gaius anêŋ Debi, ma Tikikus lo Tlopimas anêŋ plovins Esia, ma Timoti. ");
INSERT INTO hot_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ŋê takêntêk êmôŋ ba i eyabiŋ yêlô êmô Tloas. ");
INSERT INTO hot_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ma yêlô a amô Pilipai aleba avômalô Islael iniŋ waklavôŋ Eyaŋ Polom Yis Mi hale ba hi. Êŋ ma yêlô atak Pilipai ma athak yeŋ ba aveŋ hatôm wak baheŋvi ma yêlô athak Tloas ma apôm thêlô. Ma yêlô amô Tloas hatôm sonda te. ");
INSERT INTO hot_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","9","Sonda te anêŋ wak môŋ ma yêlô lôk ŋê êvhaviŋ athak doŋtom ek naŋgaŋ Anyô Bêŋ anêŋ polom matheŋ. Yêlô athak unyak daim te ba amô kapô bôlô te lô atu hêk vuliŋ ma avômalô êtôm atum lam bêŋ anôŋ ba êthôkwêŋ haveŋ. Pol lahabi etak thêlô êndêŋ lôkbôk ba intu hanaŋ abô daim aleba bôlôvôŋ biŋ. Ma anyô muk te anêŋ athêŋ nena Yutikas hamô unyak abôlêk lovak ma halaŋô Pol anêŋ abô aleba ma hayaŋ ma hêk sôm. Êŋ ma hêv yak ba hi tamu pik. Ma thêlô i ek neja yani, ma doŋtom lêk hama yôv. ");
INSERT INTO hot_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ma Pol halôk ba hi ma hayô hêk ôpêŋ ma havaloŋ yani ma hanaŋ, “Môlô miŋ noboloba ami. Yani hêk lôkmala.” ");
INSERT INTO hot_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Vêm ma Pol thêlô êvôi unyak vuliŋ hathak loŋbô ma eyaŋ Anyô Bêŋ anêŋ polom matheŋ. Êŋ ma Pol hanaŋ abô bêŋ anôŋ hathak loŋbô aleba hayaŋ wak bêŋ ma hi. ");
INSERT INTO hot_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ma anyô muk atu ba Pol hik liŋ anêŋ avômalô ewa yani ba i unyak lôk leŋiŋmavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pol lahaviŋ embeŋ pik ba ni Asos ma hanaŋ ek yêlô nasak yeŋ ba ana napôm yani êndôk loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pol hapôm yêlô halôk Asos ma yêlô awa yani hathak yeŋ ba a Mitilini. ");
INSERT INTO hot_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ma haviyô hayaŋ ma atak Mitilini ma yêlô a ŋgavithôm Kios ma doŋtom miŋ athak liŋ ami. Ma hayaŋ hathak loŋbô ma yêlô a ayô apôm ŋgavithôm Samos. Ma hayaŋ te ma yêlô ayô Miletus. ");
INSERT INTO hot_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol lahaviŋ ênjê waklavôŋ Pentikos êndôk Jelusalem ba intu lahaviŋ ni ketheŋ. Aêŋ ba hadô ni Epesus ek malê nena hi loŋ êŋ ma tem êmô plovins Esia sawa daim. ");
INSERT INTO hot_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pol hamô Miletus ma hêv abô hadêŋ Epesus nena avômalô êvhaviŋ iniŋ avaka sapêŋ ini êndêŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Thêlô êyô ma yani hanaŋ, “Môlô oyala ku takatu ba yahayô Esia môŋ anôŋ ma yahamô haviŋ môlô ba yahadum aleba lêk. ");
INSERT INTO hot_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Avômalô Islael ethak êv malaiŋ lomaloma hadêŋ ya lôk ibutiŋ abô ek nimbuliŋ ya lôbôlôŋ. Ma doŋtom yahatauviŋ ya aleba yaôna ma yahadum Anyô Bêŋ anêŋ ku lôk yamaleŋ thôk. ");
INSERT INTO hot_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ma oyala nena abô alêla takatu ba hêv môlô sa, êŋ ma yahanaŋ abô takêŋ bêŋ lôk yaleŋvidoŋ iyom. Ma yahadôŋ môlô hamô loŋ yaiŋ lôk haveŋ môlônim unyak nenanena haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ma yahanaŋ abô doŋtom êntêk hadêŋ avômalô Islael lôk avômalô loŋ buyaŋ nena nede kapôlôŋiŋ liliŋ êndêŋ Wapômbêŋ ba nênêmimbiŋ alalôaniŋ Anyô Bêŋ Yisu. ");
INSERT INTO hot_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ma lêk Lovak Matheŋ hakak ya ek yana Jelusalem. Ma miŋ yahayala nena malê intu tem êpôm ya anêŋ loŋ êŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nôm doŋtom intu yahayala ma aêntêk. Malak nômbêŋ atu ba yahayô ma Lovak Matheŋ hanaŋ hadêŋ ya nena, “Tem malaiŋ lomaloma êpôm o lôk ômô koladôŋ.” ");
INSERT INTO hot_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ma miŋ yaleŋ hik ya hathak nôm takêŋ ami. Lôk miŋ yahayê yaleŋviŋkupik hatôm nômbêŋ ek ya ami. Mi, yenaŋ auk bêŋ ma yamiŋ lôklokwaŋ ba yandum ku takatu ba Anyô Bêŋ Yisu hêv hadêŋ ya endeba êyô anêŋ daŋ am. Ku êŋ ma aêntêk: yanaŋ Abô Mavi bêŋ esak Anyô Bêŋ anêŋ wapôm. ");
INSERT INTO hot_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ma môlô takatu ba bôk yahamô haviŋ ba yahanaŋ abô hathak Wapômbêŋ anêŋ loŋ lôkliŋyak, ondaŋô. Lêk yahayala nena môlô te tem miŋ ênjê yamaleŋ esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Aêŋ ba yahanaŋ bêŋ hadêŋ môlô nena anyôla hadô Wapômbêŋ anêŋ abô ba hapôm malaiŋ, êŋ ma miŋ yenaŋ kambom ami. ");
INSERT INTO hot_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ek malê nena yahanaŋ Wapômbêŋ anêŋ loŋôndê sapêŋ bêŋ hadêŋ môlô ma miŋ yahakô ami. ");
INSERT INTO hot_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Noyabiŋ am lôk avômalô takatu ba bôk Lovak Matheŋ hêv hadêŋ môlô ek noyabiŋ i. Ma noyabiŋ Wapômbêŋ anêŋ avômalô êvhaviŋ takatu ba yani bôk hêv i vuli hathak yanida anêŋ thalaleŋ. ");
INSERT INTO hot_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Yahayala nena yahatak môlô ba yaha, êŋ ma kêdôŋwaga abôyaŋ tem nêlêm êtôm avuŋ yatap ek nimbuliŋ boksipsip. ");
INSERT INTO hot_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ma môlôda doho tem nonaŋ abôyaŋ ba nunduviŋ abô avanôŋ ek nôbôv ŋê êvhaviŋ vi ek nesopa i. ");
INSERT INTO hot_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Aêŋ ba noyabiŋ am ma lemimimbi nena hatôm sondabêŋ lô anêŋ wak lo bôlôvôŋ ma yahanaŋ abô hadêŋ môlô lôk yamaleŋ thôk ek yambatho môlô lôŋ. ");
INSERT INTO hot_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ma lêk yahatak môlô halôk Wapômbêŋ baŋ lôk anêŋ abô hathak anêŋ wapôm. Abô êŋ ma hatôm embatho môlô loŋ ba nêm loŋ ênjêk malak leŋ ek môlô imbiŋ ŋê matheŋ takatu ba bôk êmô yôv. ");
INSERT INTO hot_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ma miŋ yamaleŋkilik hathak anyôla anêŋ seleva lo gol ma sôp ami. ");
INSERT INTO hot_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ma môlôda oyala nena yada yahadum ku hathak yabaheŋ ek yahêv yada sa lôk ŋê takatu ba idum ku iviŋ ya. ");
INSERT INTO hot_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ku takatu ba yahadum hik thô hadêŋ môlô nena mavi ek alalô nandum ku bêŋ ek nanêm avômalô siv sa. Ma lemimimbi abô takatu ba Anyô Bêŋ Yisu bôk hanaŋ nena, ‘Anyô yaŋ hêv nômlate ek hêv o sa, ma tem lemmavi. Ma doŋtom hôêv nômlate ek nêm anyô yaŋ sa, êŋ ma tem lemmavi anôŋ.’” ");
INSERT INTO hot_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol hanaŋ abô takêŋ yôv, ma halek vadôŋ lêlô ma hateŋ mek haviŋ thêlô. ");
INSERT INTO hot_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ma thêlô sapêŋ evaloŋ yani ba iliŋu ma elaŋ bêŋ hathak yani. ");
INSERT INTO hot_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Êŋ ma thêlô ewa yani ba i etak hathak yeŋ. Thêlô leŋiŋmalaiŋ kambom hathak abô takatu ba bôk hanaŋ nena tem miŋ nêgê yani ma esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Yêlô atak thêlô lôk kapôlôŋiŋ malaiŋ, ma yeŋ hatak ŋgwêk daŋ anêŋ Miletus ba hi nôŋnôŋ hadêŋ ŋgavithôm Kos. Haviyô hayaŋ ma yêlô ayô ŋgavithôm Lodes vêm ma a Patala. ");
INSERT INTO hot_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ma yêlô atak yeŋ êŋ ma apôm yeŋ yaŋ atu ba tem ni Pinisia, êŋ ma yêlô athak yeŋ êŋ ba a. ");
INSERT INTO hot_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ma yêlô a aleba ayê ŋgavithôm Saiplus hamô vituvulu baheŋvi keŋ ma yêlô alom baheŋvi anôŋ aleba ayô Taia hêk plovins Silia. Loŋ êŋ ma yeŋ hadum ek etak anêŋ nômkama êndôk biŋ. ");
INSERT INTO hot_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Êŋ ma yêlô apôm ŋê êvhaviŋ anêŋ loŋ êŋ ba amô haviŋ thêlô hatôm sonda daluk te. Ma hathak Lovak Matheŋ ma thêlô enaŋ lôklokwaŋ hadêŋ Pol nena miŋ ni Jelusalem ami. ");
INSERT INTO hot_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ma doŋtom sonda daluk êŋ anêŋ daŋ, ma yêlô a ek nasak yeŋ esak loŋbô. Ma ŋê êvhaviŋ lôk vêŋi lôk nali elom yêlô ibup ŋgwêk daŋ. Ma ŋgwêk daŋ ma yêlô alek veŋiŋ lêlô ma ateŋ mek. ");
INSERT INTO hot_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Vêm ma ekam yêlô ma yêlô athak yeŋ ba a ma thêlô êvôi iniŋ loŋ hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ma yeŋ hatak Taia ma hi aleba hayô Tolemes. Ma anêŋ Tolemes ma yêlô a ek nagê ŋê êvhaviŋ ba namô imbiŋ thêlô êtôm wak te. ");
INSERT INTO hot_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Haviyô hayaŋ ma yêlô athak yeŋ ba a ayô Sisalia. Ma yêlô amô Pilip anêŋ unyak. Yani ma anyô hanaŋ Anyô Bêŋ anêŋ abô bêŋ. Bôk etak ŋê baheŋvi ba lahavuju ek nênêm aposel sa ba Pilip ma ŋê êŋ te. ");
INSERT INTO hot_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yani anêŋ nali avi muk ayova êmô. Thêlô ethak enaŋ abô hatôm plopet. ");
INSERT INTO hot_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yêlô amô wak doho ma plopet te anêŋ athêŋ nena Agabas hatak Judia ma halôk ba halêm Sisalia. ");
INSERT INTO hot_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yani halêm hayô ek yêlô ma hawa Pol anêŋ bokŋgôp ba hakak yanida baŋ lo va loŋ hathak ma hanaŋ, “Lovak Matheŋ hanaŋ nena, ‘Avômalô Islael anêŋ Jelusalem tem nekak bokŋgôp êntêk anêŋ alaŋ aêŋ iyom ba nênêm yani êndôk avômalô loŋ buyaŋ baheŋiŋ.’” ");
INSERT INTO hot_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Yêlô alaŋô abô êŋ, ma yêlô lôk avômalô loŋ êŋ alaŋ ba anaŋ hadêŋ Pol nena miŋ ni Jelusalem ami. ");
INSERT INTO hot_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Êŋ ma Pol hanaŋ nena, “Môlô olaŋ ba ômô yabiŋdaluk lu eka? Ya lêk yahapesaŋ ya yôv ek yamô koladôŋ mena ik ya vônô halôk Jelusalem hathak Anyô Bêŋ Yisu anêŋ athêŋ la. Êŋ ma hatôm.” ");
INSERT INTO hot_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Yêlô ayê nena yani miŋ hatôm endaŋô yêlôaniŋ abô ami ba intu yêlô atak auk êŋ ma anaŋ, “Anyô Bêŋ anêŋ lahaviŋ injik anôŋ.” ");
INSERT INTO hot_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Vêm ma yêlô apesaŋ i ek ana Jelusalem. ");
INSERT INTO hot_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ma ŋê êvhaviŋ doho anêŋ Sisalia elom yêlô ba i Neson anêŋ unyak ek namô. Yani ma anyô Saiplus te atu ba bôk hêvhaviŋ môŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yêlô ayô Jelusalem ma ŋê êvhaviŋ ewa yêlô thô lôk leŋiŋmavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Haviyô hayaŋ ma yêlô lôk Pol a ek nagê Jems ma avômalô êvhaviŋ iniŋ avaka sapêŋ êmô haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ma Pol hakam thêlô ma hanaŋ hathak nôm takatu ba Wapômbêŋ hadum hathak yani hêk avômalô loŋ buyaŋ malêvôŋ. ");
INSERT INTO hot_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Thêlô elaŋô abô êŋ, ma êbô Wapômbêŋ. Ba enaŋ hadêŋ Pol, “Aiyaŋ, ondaŋô. Avômalô Islael lubuŋlubuŋ bôk êvhaviŋ Yisu yôv ba thêlô lôklokwaŋ ek nesopa Mose anêŋ balabuŋ. ");
INSERT INTO hot_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ma thêlô bôk elaŋô yôv nena hôdôŋ avômalô Islael takatu ba êmô ŋê loŋ buyaŋ malêvôŋ nena netak Mose anêŋ balabuŋ lôk miŋ neŋgothe nali iniŋ kupik vê ami lôk miŋ nebaloŋ yêlôaniŋ kobom ami. ");
INSERT INTO hot_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tem nedaŋô nena lêk hôlêm ba alalô nandum malê? ");
INSERT INTO hot_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Osopa yêlôaniŋ auk êntêk. Yêlôaniŋ anyô ayova êmô ba bôk ibutiŋ abô haviŋ Wapômbêŋ ek nindum nômlate ek nimbitak matheŋ. ");
INSERT INTO hot_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Onja ŋê takêntêk ba nu unyak matheŋ ma umbiŋ thêlô esak loŋôndê atu ba esopa ek indum thêlô nimbitak mabuŋ ênjêk Wapômbêŋ ma. Ma nêm valu ek thêlô nênêm êtôm iniŋ da vêm ma neŋgulu leŋiŋkadôk ŋauŋ sapêŋ vê. Undum aêŋ ma tem avômalô sapêŋ neyala nena abô takatu ba elaŋô ma abôyaŋ. Ma oda hôwê balabuŋ vibiŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ma hathak avômalô loŋ buyaŋ takatu ba êvhaviŋ, yêlô bôk ato kapya hadêŋ thêlô yôv ek nenaŋ abô takatu ba alalô bôk abutiŋ nena thêlô miŋ nejaŋ alim takatu ba êv hatôm da hadêŋ ŋgôk dahô ami, lôk miŋ ninum thalaleŋ ami, ma miŋ nejaŋ alim takatu ba ekak leŋselo siŋ ami, ma netak sek waliliŋ.” ");
INSERT INTO hot_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Haviyô hayaŋ ma Pol lôk ŋê ayova atu i unyak matheŋ ba esopa loŋôndê atu ba indum thêlô nimbitak mabuŋ ênjêk Wapômbêŋ ma. Vêm ma hi unyak matheŋ kapô ma hanaŋ hadêŋ ŋê êbôk da nena wak baheŋvi ba lahavuju hale ba hi, ma tem iniŋ waklavôŋ nêmô mabuŋ anêŋ daŋ ba intu tem nêlêm esak loŋbô ek nêmbôk thêlôda tomtom iniŋ da. ");
INSERT INTO hot_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wak baheŋvi ba lahavuju atu habobo anêŋ daŋ ma avômalô Islael anêŋ plovins Esia êyê Pol hamiŋ unyak matheŋ. Êŋ ma ibi avômalô nômbêŋ atu leŋiŋ ba evaloŋ Pol. ");
INSERT INTO hot_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ma elam kaêk aêntêk, “Môlô ŋê Islael, nônêm yêlô sa! Anyô êntêk ma ôpatu ba hathak hanaŋ abô kambom hathak alalô lôk abô balabuŋ ma unyak matheŋ êntêk haveŋ lomalak nenanena ba hadôŋ avômalô sapêŋ hathak auk êŋ. Ma nômla yaŋ haviŋ aêntêk. Yani halom ŋê loŋ buyaŋ doho ba ibitak êyô unyak matheŋ êntêk kapô ba idum loŋ matheŋ habitak lelaik.” ");
INSERT INTO hot_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Thêlô enaŋ aêŋ ek malê nena bôk êyê Tlopimas anêŋ Epesus hamô Jelusalem haviŋ Pol ba esoŋ nena bôk Pol halom yani ba hi unyak matheŋ kapô. ");
INSERT INTO hot_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Êŋ ma avômalô Jelusalem sapêŋ leŋiŋŋaŋa kambom ba elaŋviŋ ethak doŋtom ma evaloŋ Pol ba êvôv hale unyak matheŋ viyaiŋ ba hi. Ma ketheŋ oyaŋ ma ik unyak matheŋ anêŋ badêŋ abôlêk siŋ ek miŋ ini kapô esak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Thêlô idum ek nijik yani vônô haveŋ denaŋ, ma abô halaŋviŋ hi hayô Lom iniŋ anyô vovak laik môŋ nena avômalô Jelusalem sapêŋ idum pôk lili bêŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Êŋ ma yani hawa ŋê vovak lôk ŋê vovak laik doho ba elaŋviŋ ba i hadêŋ avômalô nômbêŋ atu. Avômalô êyê anyô vovak laik môŋ lôk anêŋ ŋê vovak êlêm, êŋ ma etak Pol ba miŋ ik yani hathak loŋbô ami. ");
INSERT INTO hot_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Anyô vovak laik môŋ hayô ma havaloŋ Pol ma hanaŋ hadêŋ ŋê vovak nena nekak Pol loŋ esak seŋ ju. Ma hanaŋ hik avômalô liŋ nena, “Yani ma opalê ba hadum malê te?” ");
INSERT INTO hot_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ma avômalô vi elam abô te ma vi elam abô yaŋ. Pôk lili bêŋ habitak ba anyô vovak laik môŋ miŋ hatôm êpôm malaiŋ êŋ anêŋ ôdôŋ ami. Ba intu hanaŋ hadêŋ ŋê vovak ek neja Pol imbitak êyô iniŋ loŋ êmô. ");
INSERT INTO hot_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Thêlô ewa Pol êyô loŋ êŋ anêŋ alêlê ma avômalô leŋiŋŋaŋa kambom ek nijik yani vônô ba intu ŋê vovak êv Pol liŋ hathak leŋ ek miŋ hatôm nijik yani ami. ");
INSERT INTO hot_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ma avômalô nômbêŋ atu ba eveŋ yam elam mathalaleŋ nena, “Uŋgwik yani vônô! Uŋgwik yani vônô!” ");
INSERT INTO hot_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ma ŋê vovak ebobo iniŋ loŋ êmô, êŋ ma Pol hanaŋ hathak abô Glik hadêŋ anyô vovak laik môŋ nena, “Hatôm yanaŋ abô te êndêŋ o e?” Ma anyô vovak laik môŋ hasoŋ ba hanaŋ, “Hoyala abô Glik, e? ");
INSERT INTO hot_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Yahasoŋ nena o anyô Ijip sêbôk ba huik vovak hadêŋ Lom ba howa ŋê kambom takatu ba ik anyô vônô hatôm 4,000 ba hu loŋ thiliv la.” ");
INSERT INTO hot_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ma Pol hanaŋ, “Mi. Ya anyô Islael te ba yenaŋ loŋ ma Tasus hêk plovins Silisia. Yenaŋ loŋ ma loŋ lôk athêŋ. Hatôm yanaŋ abô dokte êndêŋ avômalô takêntêk e?” ");
INSERT INTO hot_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ma anyô vovak laik môŋ halôk, ma Pol hamiŋ alêlê ma hêv baŋ hathak leŋ ek avômalô bônôŋ. Thêlô bônôŋ, êŋ ma Pol hanaŋ abô hadêŋ thêlô hathak abô Hiblu. ");
INSERT INTO hot_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ba hanaŋ nena, “Aiyaŋ thêlô lo wakamik thêlô, nodaŋô. Tem yanaŋ nôm êŋ bêŋ êndêŋ môlô.” ");
INSERT INTO hot_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ma elaŋô Pol hanaŋ abô hathak abô Hiblu, êŋ ma thêlô imiŋ tiŋiŋ. Êŋ ma Pol hanaŋ, ");
INSERT INTO hot_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ya anyô Islael. Wakatik havathu ya hêk Tasus anêŋ plovins Silisia, ma doŋtom yahalumbak bêŋ hamô loŋ êntêk. Ma Gameliel bôk hadôŋ ya dedauŋ mavi hathak bumalô iniŋ balabuŋ. Ma ya bôk lôklokwaŋ bomaŋ ek yasopa Wapômbêŋ hatôm môlô êntêk lêk udum. ");
INSERT INTO hot_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Bôk yahêv vovaŋ hadêŋ ŋê takatu ba esopa Yisu anêŋ loŋôndê ba yahatak anyô lo avi halôk koladôŋ lôk yahanaŋ ek nijik thêlô vônô. ");
INSERT INTO hot_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Anyô bêŋ habôk da lôk Islael iniŋ ŋê bêŋbêŋ eyala nôm takêntêk. Thêlô eto kapya te hadêŋ iniŋ iviyaŋ anêŋ Damaskas ek nijik ku takatu tem yandum thô êndêŋ thêlô. Ku êŋ ma yambaloŋ ŋê takatu ba esopa Yisu anêŋ loŋôndê ba yanja i ba yalêm Jelusalem ek nênêm vovaŋ êndêŋ i. ");
INSERT INTO hot_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Yaha ek yandum ku êŋ ba hatôm waklêvôŋ biŋ ma yahabobo Damaskas. Ma ketheŋ oyaŋ ma deda bêŋ te anêŋ leŋ habi hayô hêk ya. ");
INSERT INTO hot_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ma yahêv yak halôk pik ma yahalaŋô abô te hanaŋ hadêŋ ya, ‘Sol, Sol, aisê ka hubuliŋ ya?’ ");
INSERT INTO hot_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ma yahanaŋ viyaŋ, ‘Anyô Bêŋ, o ma opalê?’ “Ma hanaŋ nena, ‘Ya Yisu anêŋ Nasalet, ôpatu ba hôêv vovaŋ hadêŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ŋê takatu ba iviŋ ya êyê deda êŋ, ma doŋtom miŋ elaŋô ôpatu anêŋ abô atu ba hanaŋ hadêŋ ya ami. ");
INSERT INTO hot_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ma yahanaŋ, ‘Anyô Bêŋ, yandum malê?’ “Ma Anyô Bêŋ hanaŋ nena, ‘Umbiyô ba nu Damaskas ma anyô te tem enaŋ êndêŋ o esak ku takatu ba bôk yahatak yôv ek undum.’ ");
INSERT INTO hot_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Deda bêŋ êŋ habi yamaleŋ siŋ ba miŋ hatôm yaŋgê loŋ ami. Aêŋ ba ŋê takatu iviŋ ya evaloŋ yabaheŋ ba edadi ya hi Damaskas. ");
INSERT INTO hot_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ma anyô te anêŋ athêŋ nena Ananaias hamô loŋ êŋ ba halêm ek ênjê ya. Yani hathak hasopa abô balabuŋ dedauŋ mavi, ma avômalô Islael takatu ba êmô Damaskas ethak elam yani nena anyô mavi. ");
INSERT INTO hot_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yani hamiŋ habobo ya ma hanaŋ, ‘Aiyaŋ Sol, nôŋgô tak esak loŋbô!’ Ma ketheŋ oyaŋ ma yahayê yani. ");
INSERT INTO hot_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ma hanaŋ, ‘Bumalô thêlô iniŋ Wapômbêŋ hatak o ek oyala anêŋ lahaviŋ lôk nôŋgô anêŋ Anyô Thêthôŋ Yisu lôk ondaŋô laselo. ");
INSERT INTO hot_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tem umbitak êtôm anêŋ anyô onaŋ anêŋ abô bêŋ êndêŋ avômalô sapêŋ esak nôm takatu ba hôyê lo holaŋô. ");
INSERT INTO hot_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lêk aisê, hoyabiŋ malê? Umbiyô ma usik o êndôk ŋaŋ lôk ondam anêŋ athêŋ ek êmbôkwiŋ anêm kambom sapêŋ vê.’ ");
INSERT INTO hot_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Vêm ma yahaleha Jelusalem ma wak te ma yahateŋ mek hamô unyak matheŋ kapô ma yahatulak ba yahayê wêŋ te. ");
INSERT INTO hot_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ma yahayê Anyô Bêŋ hanaŋ abô hadêŋ ya ba hanaŋ, ‘O ketheŋ, otak Jelusalem ba nu. Ek malê nena avômalô loŋ êntêk tem miŋ nedaŋô anêm abô takatu ba honaŋ hathak ya ami.’ ");
INSERT INTO hot_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ma yahanaŋ, ‘Anyô Bêŋ, thêlô eyala nena bôk yahaveŋ avômalô Islael iniŋ unyak yeŋ nenanena takatu ba hamô lomalak ek yanja avômalô takatu ba êvhaviŋ o ek yambali thêlô ba yatak i êndôk koladôŋ. ");
INSERT INTO hot_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ma ik Stiven anêm anyô atu ba hanaŋ anêm abô bêŋ vônô ma lêk yahamiŋ loŋ êŋ haviŋ ba intu yahalôk hathak auk êŋ ba yahayabiŋ ŋê ik yani vônô iniŋ sôp.’ ");
INSERT INTO hot_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Êŋ ma Wapômbêŋ hanaŋ hadêŋ ya, ‘Nu, tem yanêm o êndêŋ avômalô loŋ buyaŋ takatu ba êmô daimbô.’” ");
INSERT INTO hot_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Avômalô Islael elaŋô Pol anêŋ abô aleba hanaŋ bute nena, “Wapômbêŋ hêv yani ba hi ek ŋê loŋ buyaŋ”, êŋ ma thêlô elam lôklala nena, “Uŋgwik yani vônô! Miŋ notak yani ek êmô lôkmala ami.” ");
INSERT INTO hot_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ma thêlô elam lôklala ba ibi iniŋ kwêv daim thô ma ibi voŋgovaŋ hathak leŋ ek injik thô nena leŋiŋmaniŋ hathak abô takatu ba Pol hanaŋ. ");
INSERT INTO hot_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Êŋ ma anyô vovak laik môŋ hanaŋ ek ŋê vovak neja Pol ba ini iniŋ loŋ. Ma hanaŋ nena nebali yani esak yak wabeŋ lôk nenaŋ injik yani liŋ ek neyala nena avômalô leŋiŋŋaŋa hathak malê ba elam kaêk lôklala. ");
INSERT INTO hot_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Thêlô eto Pol va lo baŋ thêthôŋ ma ekak loŋ ek nebali yani, êŋ ma Pol hanaŋ hadêŋ anyô vovak laik atu ba hamiŋ habobo yani nena, “Lom iniŋ balabuŋ hanaŋ aisê hathak avômalô Lom da? Hatôm nobali anyô Lom te atu ba miŋ hadum abô ba êpôm anêŋ kambom ami denaŋ e?” ");
INSERT INTO hot_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Anyô vovak laik halaŋô abô êŋ ma hi hanaŋ hadêŋ anyô vovak laik môŋ nena, “Hudum malê? Ôpêntêk ma anyô Lom te.” ");
INSERT INTO hot_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ma anyô vovak laik môŋ hi hadêŋ Pol ma hanaŋ hik yani liŋ, “O ma anyô Lom te e?” Ma Pol hanaŋ, “Intu êŋ.” ");
INSERT INTO hot_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ma anyô vovak laik môŋ hanaŋ, “Bôk yahêv valuseleŋ bêŋ anôŋ hadêŋ Lom ek yambitak anyô Lom te.” Ma Pol hanaŋ, “Ya mi, wakamik ma anyô Lom ba intu yahabitak anyô Lom haviŋ.” ");
INSERT INTO hot_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Êŋ ma ŋê takatu ba idum ek nenaŋ injik yani liŋ, etak yani ba i ketheŋ. Ma anyô vovak laik môŋ hasoŋ kambom ek malê nena hakak Pol anyô Lom te baŋ lo va lusu hathak seŋ. ");
INSERT INTO hot_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ma anyô vovak laik môŋ lahaviŋ eyala katô nena avômalô Islael enaŋ Pol bêŋ hathak malê. Aêŋ ba haviyô hayaŋ ma hapole seŋ vê hêk Pol ma hêv abô hadêŋ ŋê bêŋbêŋ êbôk da lôk Sanhedlin ek nesak doŋtom. Êŋ ma hawa Pol ba hi hadô hamiŋ thêlô maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol hatitiŋ Sanhedlin ma hanaŋ, “Aiyaŋ thêlô, yahadum Wapômbêŋ anêŋ ku dedauŋ mavi hêk Wapômbêŋ ma ba yakapôlôŋ miŋ hanaŋ ya bêŋ hathak nômlate ami aleba lêk.” ");
INSERT INTO hot_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Êŋ ma anyô bêŋ habôk da Ananaias hanaŋ hadêŋ ŋê takatu ba imiŋ habobo yani ek nepetav yani abôlêk. ");
INSERT INTO hot_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ma Pol hanaŋ, “Lemvimkupik ma thêthê mavi, ma doŋtom kapôlôm ma lôŋgôlôŋ ba Wapômbêŋ tem epetav o. Hômô loŋ êntêk ek onaŋ ya bêŋ esak balabuŋ, ma doŋtom oda huik balabuŋ pesa ba honaŋ nena nepetav ya.” ");
INSERT INTO hot_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ma ŋê takatu ba imiŋ habobo yani enaŋ, “Honaŋ abô kambom hathak Wapômbêŋ anêŋ anyô bêŋ habôk da eka?” ");
INSERT INTO hot_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ma Pol hanaŋ, “Aiyaŋ thêlô, miŋ yahayala nena yani ma anyô bêŋ habôk da ami. Hatôm bôk eto nena, ‘Miŋ nonaŋ abô kambom esak anyô bêŋ atu ba hayabiŋ anêm avômalô ami.’” ");
INSERT INTO hot_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ma Pol hayala nena avômalô Sanhedlin vi ma Sadyusi ma vi ma Palisi. Ba intu yani halam hadêŋ thêlô nena, “Aiyaŋ thêlô, wakamik ma anyô Palisi ma ya aêŋ iyom. Ba yahêvhaviŋ nena ŋê takatu ba bôk ema tem nimbiyô esak loŋbô, ma hathak abô êŋ ma lêk udum abô ek ya.” ");
INSERT INTO hot_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Yani hanaŋ abô êŋ ma Palisi lôk Sadyusi enaŋ i aleba evak i vose hi ôdôŋ ju. ");
INSERT INTO hot_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Evak i vose ek malê nena ŋê Sadyusi iniŋ auk nena ŋê ŋama tem miŋ nimbiyô esak loŋbô ami, lôk enaŋ nena aŋela lôk ŋgôk miŋ êmô ami. Ma doŋtom Palisi êvhaviŋ nena nôm takêŋ ma avanôŋ. ");
INSERT INTO hot_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Êŋ ma pôk lili bêŋ habitak ma ŋê lôkauk hathak abô balabuŋ doho atu ba Palisi, iviyô imiŋ ma enaŋ lôklala nena, “Yêlô miŋ lêk apôm ôpêntêk anêŋ kambom la ami. Betha ŋgôk mena aŋela te hanaŋ abô êŋ hadêŋ yani la.” ");
INSERT INTO hot_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ma leŋiŋmaniŋ halumbak hi bêŋ ba anyô vovak laik môŋ hakô nena tem nêbôv Pol endeba itip ni loviaŋ. Ba intu hanaŋ hadêŋ ŋê vovak nena nêbôv Pol vê ênjêk i ba neja ba ini iniŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Wak êŋ anêŋ bôlôvôŋ ma Anyô Bêŋ hamiŋ habobo Pol ma hanaŋ, “Umiŋ lôklokwaŋ ma miŋ ôkô ami! Bôk honaŋ abô hathak ya bêŋ hamiŋ Jelusalem ma tem onaŋ imiŋ Lom aêŋ iyom.” ");
INSERT INTO hot_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Haviyô hayaŋ ma avômalô Islael doho ethak doŋtom ma evak abô hathak Wapômbêŋ anêŋ athêŋ nena, “Alalô miŋ hatôm naŋgaŋ nôm lo nanum ŋaŋ ami endeba naŋgik Pol vônô am.” ");
INSERT INTO hot_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ŋê takatu ba evak abô êŋ, ma hatôm 40 ba havôhi. ");
INSERT INTO hot_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ma thêlô i êyô ŋê bêŋbêŋ êbôk da lôk ŋê bêŋbêŋ Islael ma enaŋ, “Yêlô avak abô hathak Wapômbêŋ anêŋ athêŋ nena miŋ hatôm aŋgaŋ nôm lo nanum ŋaŋ ami endeba naŋgik Pol vônô am. ");
INSERT INTO hot_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Aêŋ ba môlô lôk Sanhedlin nônêm abô êndêŋ anyô vovak laik môŋ ba nosau yani nena neja Pol êlêm êndêŋ môlô ek nonaŋ injik yani liŋ ek enaŋ anêŋ abô doho anêŋ ôdôŋ bêŋ. Ek malê nena yêlô lêk apesaŋ i yôv ek naŋgik yani vônô êndôk loŋôndê.” ");
INSERT INTO hot_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ma doŋtom Pol livavi anêŋ namalô halaŋô abô takatu ba thêlô ibutiŋ. Ma hi ŋê vovak iniŋ loŋ kapô ma hanaŋ hadêŋ Pol. ");
INSERT INTO hot_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pol halaŋô anêŋ abô, êŋ ma halam anyô vovak laik te halêm ma hanaŋ, “Ondom anyô muk êntêk ni anyô vovak laik môŋ ek enaŋ anêŋ abô te êndêŋ yani.” ");
INSERT INTO hot_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Êŋ ma anyô vovak laik êŋ hawa yani ba hi hadêŋ anyô vovak laik môŋ ma hanaŋ, “Pol anyô koladôŋ halam ya ek yanja anyô muk êntêk êlêm êndêŋ o. Ek malê nena anêŋ abô te hêk ek enaŋ imbiŋ o.” ");
INSERT INTO hot_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Êŋ ma anyô vovak laik môŋ havaloŋ anyô muk atu baŋ ba halom yani hi daim dokte ma hanaŋ hik yani liŋ, “Hudum ek onaŋ malê êndêŋ ya?” ");
INSERT INTO hot_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ma ôpatu hanaŋ, “Avômalô Islael lêk evak abô ek nenaŋ injik o liŋ nena yamuŋ ma nêm Pol êndêŋ Sanhedlin. Thêlô esau nena tem nenaŋ injik Pol liŋ esak anêŋ abô doho anêŋ ôdôŋ. ");
INSERT INTO hot_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ma miŋ ondaŋô iniŋ abô ami. Thêlô ma hatôm 40 ba havôhi evak abô majaŋ hathak Wapômbêŋ anêŋ athêŋ nena miŋ hatôm nejaŋ nôm lo ninum ŋaŋ ami endeba nijik Pol vônô am. Ma lêk epesaŋ i yôv ba êmô loŋôndê ek nijik yani vônô, ma doŋtom eyabiŋ o ek ôndôk esak iniŋ abô am.” ");
INSERT INTO hot_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ma anyô vovak laik môŋ hatak anyô muk atu ba hi ma hanaŋ lôklokwaŋ nena, “Miŋ onaŋ êndêŋ anyôla nena honaŋ abô êntêk hadêŋ ya ami.” ");
INSERT INTO hot_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Êŋ ma anyô vovak laik môŋ halam ŋê vovak laik ju ma hanaŋ, “Nusup ŋê vovak êtôm 200 takatu ba eveŋ pik lôk 70 takatu ba êyô êmô bokhos ma 200 takatu ba ik vovak hathak kôm jaŋak ek nêpôpêk i ek dokte bôlôvôŋ êtôm 9 kilok ma ini Sisalia. ");
INSERT INTO hot_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ma nopesaŋ bokhos doho ek Pol ek noja yani dedauŋ mavi endeba notak êndôk Peliks anyô bêŋ atu ba hayabiŋ Judia baŋ.” ");
INSERT INTO hot_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Lôk hato kapya te aêntêk: ");
INSERT INTO hot_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ya Klodias Lisias, yahato kapya êntêk hadêŋ o Peliks, O ma anyô bêŋ mavi atu ba hoyabiŋ Judia. Waklêvôŋ mavi o! ");
INSERT INTO hot_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ŋê Islael evaloŋ anyô êntêk ba idum ek nijik yani vônô, ma doŋtom bôk yahalaŋô yôv nena yani ma anyô Lom te. Ba intu ya lôk yenaŋ ŋê vovak ayô aêv yani sa. ");
INSERT INTO hot_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ma yaleŋhaviŋ yandaŋô nena avômalô Islael leŋiŋdaŋ ba enaŋ ôpêntêk bêŋ hathak malê. Ba intu yahawa yani hi hadêŋ iniŋ Sanhedlin. ");
INSERT INTO hot_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ma iniŋ abô takatu ba enaŋ hathak yani ma hathak Islael da iniŋ balabuŋ, ma miŋ yahapôm abôla hatôm naŋgik yani vônô mena nandô yani êmô koladôŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ma yahalaŋô nena ŋê Islael doho evak abô ek nijik yani vônô, ba intu yahêv yani ketheŋ oyaŋ ba hathôk ek o. Ma yahanaŋ hadêŋ ŋê takatu ba enaŋ yani bêŋ nena thêlôda nenaŋ abô êŋ bêŋ êndêŋ o. ");
INSERT INTO hot_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Hato kapya êŋ yôv, ma hêv hadêŋ anêŋ ŋê vovak. Ma thêlô esopa anêŋ abô takêŋ ma ewa Pol ba i malak Antipatlis hadêŋ bôlôvôŋ. ");
INSERT INTO hot_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ma haviyô hayaŋ ma ŋê êyô êmô bokhos iyom ewa Pol ba i Sisalia. Ma ŋê vovak vi êvôi iniŋ loŋ hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ma ŋê bokhos êyô Sisalia, êŋ ma êv kapya atu lôk Pol hadêŋ anyô bêŋ hayabiŋ Judia. ");
INSERT INTO hot_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ma hasam kapya êŋ ma hanaŋ hik Pol liŋ, “O anêŋ plovins alê?” Ma Pol hanaŋ, “Ya anêŋ Silisia.” ");
INSERT INTO hot_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ma ôpêŋ hanaŋ, “Ŋê takatu ba idum abô ek o êyô, ma tem yandaŋô anêm abô.” Ma hanaŋ ek ŋê vovak doho neyabiŋ Pol êmô unyak bêŋ atu ba Helot bôk halav bô. ");
INSERT INTO hot_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Wak baheŋvi hale ba hi, ma Ananaias anyô bêŋ habôk da lôk Islael iniŋ ŋê bêŋbêŋ doho ma Tetulus ôpatu ba ewa hatôm iniŋ anyô indum abô, thêlô sapêŋ êlôk ba i Sisalia. Ma enaŋ Pol bêŋ hadêŋ Peliks anyô bêŋ atu ba hayabiŋ avômalô Judia. ");
INSERT INTO hot_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Ewa Pol ba êyô loŋ nedaŋô abô. Êŋ ma Tetulus hanaŋ Pol anêŋ kambom bêŋ ba hanaŋ nena, “Anyô bêŋ Peliks, o anyô mavi anôŋ. Hoyabiŋ yêlô mavi anôŋ ba intu yêlô amô labali mavi. Ma hathak anêm auk mavi hopesaŋ nôm takatu ba bôk hêv malaiŋ hadêŋ yêlô ba lêk habitak mavi hathak loŋbô. Aêŋ ba yêlô lôk avômalô lomalak nenanena sapêŋ anaŋ leŋiŋmavi anôŋ hathak nôm takêŋ hatôm wak nômbêŋ intu sapêŋ. ");
INSERT INTO hot_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ma kambom ek yambaloŋ o loŋ bêŋ anôŋ lôk nanêm malaiŋ êndêŋ o ba intu lem ek yêlô ba ondaŋô yêlôaniŋ abô bidoŋna êntêk. ");
INSERT INTO hot_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Ôpêntêk hêv malaiŋ bêŋ anôŋ hadêŋ yêlô ba hik avômalô Islael kapôlôŋiŋ liŋ haveŋ pik sapêŋ. Yani ma anyô bêŋ ek ôdôŋ lukmuk te atu ba esopa anyô Nasalet atu anêŋ abô kambom. ");
INSERT INTO hot_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Ma yani hadum ek imbuliŋ yêlôaniŋ unyak matheŋ ba imbitak lelaik ênjêk Wapômbêŋ ma. Ba intu yêlô avaloŋ yani. Oda onaŋ injik ôpêŋ liŋ ma tem oyala nena abô takatu ba yêlô anaŋ hathak yani ma avanôŋ.” ");
INSERT INTO hot_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tetulus hanaŋ abô takêŋ yôv ma avômalô Islael takatu ba iviŋ yani ik Tetulus anêŋ abô loŋ haviŋ ba enaŋ nena abô takatu ba hanaŋ ma avanôŋ. ");
INSERT INTO hot_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ma anyô bêŋ atu habi baŋ hadêŋ Pol nena enaŋ anêŋ abô. Êŋ ma Pol hanaŋ viyaŋ, “Yahayala nena hoyabiŋ avômalô Judia sondabêŋ bêŋ anôŋ ba holaŋô iniŋ abô ba hopesaŋ thêthôŋ. Ba intu yaleŋmavi ek yanaŋ yenaŋ abô bêŋ êndêŋ o ek opesaŋ. ");
INSERT INTO hot_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ma onaŋ injik anyô doho liŋ ma tem ôpôm nena wak laumiŋ ba lahavuju iyom intu hale ba hi ma yaha Jelusalem ek yanêm yeŋ. ");
INSERT INTO hot_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ma wak êŋ ma ŋê Islael takatu ba enaŋ ya bêŋ miŋ êyê yahanaŋ abô lôk vovak hadêŋ anyôla hamô unyak matheŋ ami, lôk miŋ yahabi avômalô leŋiŋ hamô malak yeŋ la mena loŋ la hamô malak bêŋ Jelusalem haviŋ ami. Mi. ");
INSERT INTO hot_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Abô kambom takatu ba enaŋ hathak ya, abôla miŋ hêk ek injik thô nena iniŋ abô ma avanôŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ma doŋtom abô êntêk ma abô avanôŋ: Yahêv yeŋ hadêŋ bumalô thêlô iniŋ Wapômbêŋ ba yahasopa Yisu anêŋ loŋôndê atu ba elam nena loŋôndê lokbaŋ. Ma yahêvhaviŋ Mose anêŋ balabuŋ lôk plopet iniŋ abô takatu ba bôk eto. ");
INSERT INTO hot_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ma ya hatôm ŋê takêntêk ba yahêv yamaleŋ ek Wapômbêŋ injik avômalô taksêbôk ba bôk ema yôv liŋ, avômalô thêthôŋ lôk avômalô kambom. ");
INSERT INTO hot_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Aêŋ ba wak nômbêŋ intu sapêŋ ma ya lôklokwaŋ ek yakapôlôŋ ênjêk mabuŋ ma kambom mi ênjêk Wapômbêŋ lo avômalô maleŋiŋ. ");
INSERT INTO hot_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Bôk yahatak Jelusalem sondabêŋ doho ma lêk yahavôhalêm ek yanêm wapôm êndêŋ yenaŋ avômalô Islael takatu ba êv i sêkêya lôk yambôk da êndêŋ Wapômbêŋ. ");
INSERT INTO hot_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Yaha unyak matheŋ anêŋ piklêvôŋ ma yahadum nôm êŋ lôk yahasopa kobom yambitak mabuŋ ênjêk Wapômbêŋ ma. Êŋ ma thêlô êpôm ya. Avômalô bêŋ anôŋ miŋ êmô haviŋ ya ami lôk miŋ yahadum thôthô bêŋ ami. Mi. ");
INSERT INTO hot_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Avômalô Islael doho anêŋ plovins Esia iniŋ abôla hamiŋ ek nenaŋ ya bêŋ, êŋ ma mavi ek thêlô nêlêm nimiŋ malem ma nenaŋ ya bêŋ. Ma doŋtom ŋê êŋ la miŋ halêm ami. ");
INSERT INTO hot_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ba intu onaŋ ek ŋê takatu ba lêk êmô nenaŋ yenaŋ kambom takatu ba bôk êpôm hadêŋ waklavôŋ atu ba idum abô ek ya hamiŋ Sanhedlin maleŋiŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Betha thêlô êpôm yenaŋ kambom doŋtom iyom la. Kambom êŋ ma bôk yahalam hamiŋ thêlô maleŋiŋ nena, ‘Yahêvhaviŋ nena Wapômbêŋ tem injik avômalô ŋama liŋ esak loŋbô. Ma hathak nôm êŋ iyom intu lêk môlô udum abô ek ya.’” Pol hanaŋ aêŋ. ");
INSERT INTO hot_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Peliks bôk halaŋô abô bêŋ anôŋ hathak avômalô takatu ba esopa Yisu anêŋ loŋôndê. Ba intu hakak abô daŋ siŋ ba hanaŋ nena, “Anyô vovak laik môŋ Lisias halêm hayô ma tem yanaŋ yenaŋ auk bêŋ esak anêm abô.” ");
INSERT INTO hot_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ma hanaŋ hadêŋ sôp bidoŋ nena etak yani êndôk koladôŋ, ma doŋtom nepole yak sêŋ vê ênjêk yani baŋ ek êmô oyaŋ ma anêŋ ŋê môlô êyô ma netak i ek nênêm yani sa. ");
INSERT INTO hot_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Wak doho hale ba hi ma Peliks lôk yanavi Dlusila, yani ma avi Islael te, i êyô iniŋ loŋ ekaksa halôk. Ma Peliks halam Pol halêm ma halaŋô Pol hanaŋ abô hathak anêŋ hêvhaviŋ Yisu Kilisi. ");
INSERT INTO hot_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ma hanaŋ abô hathak loŋôndê thêthôŋ lôk bôk lo loŋ nipuk i loŋ lôk waklavôŋ Wapômbêŋ tem indum abô, êŋ ma Peliks hakô ba hanaŋ, “Lêk hatôm, ma nu. Ma wakla ya ku mi, ma tem yanêm abô ek ôlêm esak loŋbô.” ");
INSERT INTO hot_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Peliks lahabi nena Pol tem nêm valu doho êndêŋ yani ek indum yani lamavi ek nêm Pol sa. Ba intu halam Pol lôbôlôŋ ek thai nenaŋ abô. ");
INSERT INTO hot_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Sondabêŋ ju hale ba hi ma Posias Pestas hawa Peliks anêŋ ku. Ma Peliks lahaviŋ indum avômalô Islael leŋiŋmavi ba intu hadô Pol hamô koladôŋ denaŋ. ");
INSERT INTO hot_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pestas hawa ku eyabiŋ Judia ba hamô Sisalia hatôm wak lô. Vêm ma hi Jelusalem. ");
INSERT INTO hot_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Êŋ ma ŋê bêŋbêŋ êbôk da lôk ŋê bêŋbêŋ Islael i hadêŋ yani ma enaŋ Pol bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ba enaŋ nena, “Lemmavi hathak yêlô, êŋ ma nêm ôpêntêk ba êlêm Jelusalem ek indum abô.” Ma doŋtom iniŋ auk loŋ kapô ma bôk evak abô ek netak anyô doho ek nekopak êmô loŋôndê ek nijik Pol vônô. ");
INSERT INTO hot_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ma Pestas hanaŋ iniŋ abô viyaŋ nena, “Pol ma eyabiŋ hamô Sisalia. Ma tem yana Sisalia esak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ba intu nônêm unim ŋê bêŋbêŋ doho nêlêm imbiŋ ya ek nenaŋ kambom takatu ba onaŋ nena bôk hadum bêŋ êndôk loŋ êŋ.” ");
INSERT INTO hot_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestas hamô haviŋ thêlô hatôm wak baheŋvi ba lahavulô mena laumiŋ la vêm ma halôk ba hi Sisalia hathak loŋbô. Ma haviyô hayaŋ ma hi loŋ idum abô ma hanaŋ ek neja Pol ba ini loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pol hayô, êŋ ma ŋê Islael takatu ba êlêm anêŋ Jelusalem ekalabu yani siŋ ma enaŋ yani bêŋ hathak abô malaiŋ lomaloma, ma doŋtom iniŋ abô miŋ hatôm injik nômla thô nena iniŋ abô ma avanôŋ ami. ");
INSERT INTO hot_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Êŋ ma Pol hanaŋ iniŋ abô viyaŋ nena, “Miŋ yahadum kambom la hathak Islael iniŋ balabuŋ lôk iniŋ unyak matheŋ ma Sisa anêŋ abô majaŋ ami. Milôk.” ");
INSERT INTO hot_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ma doŋtom Pestas lahaviŋ indum avômalô Islael leŋiŋmavi ba hanaŋ hadêŋ Pol, “Lemmavi ek nu Jelusalem ek yandaŋô anêm abô takêntêk êndôk loŋ êŋ e?” ");
INSERT INTO hot_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ma Pol hanaŋ, “Unyak êntêk lêk yahamiŋ, êŋ ma Sisa anêŋ unyak idum abô halôk. Ya ma anyô Lom ba intu loŋ êntêk ma thêthôŋ ek yandum abô êndôk. Ma oda hoyala nena miŋ yahadum nômla kambom hadêŋ avômalô Islael ami. ");
INSERT INTO hot_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ma yahadum nômla kambom ba abô majaŋ hanaŋ nena yama, êŋ ma mavi ek nijik ya vônô. Ma doŋtom abô takêntêk ba thêlô enaŋ hathak ya miŋ avanôŋ ami, êŋ ma miŋ mavi ek otak ya êndôk thêlô baheŋiŋ ami. Ba intu yaleŋhaviŋ Sisa da endaŋô yenaŋ abô êndôk Lom.” ");
INSERT INTO hot_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Pestas halaŋô abô êŋ ma hanaŋ abô haviŋ anêŋ ŋê lôkauk vêm ma hanaŋ bêŋ nena, “Holam Sisa ek endaŋô anêm abô ba intu tem nu ek Sisa endaŋô.” ");
INSERT INTO hot_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Wak doho hale ba hi ma Kiŋ Aglipa lo livavi Benaisi êlêm Sisalia ek nênêm leŋiŋmavi êndêŋ Pestas. ");
INSERT INTO hot_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Thai êmô loŋ êŋ wak bêŋ anôŋ ma wak te ma Pestas hanaŋ abô hathak Pol hadêŋ kiŋ ba hanaŋ nena, “Anyô te hamô loŋ êntêk ba Peliks bôk hatak yani halôk koladôŋ. ");
INSERT INTO hot_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Wak atu ba yaha Jelusalem ma ŋê bêŋbêŋ êbôk da lôk Islael iniŋ ŋê bêŋbêŋ enaŋ ôpêntêk anêŋ kambom bêŋ, ba enaŋ ek yandum abô ba yanaŋ nena hadum kambom ek batu nijik yani vônô. ");
INSERT INTO hot_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ma yahanaŋ hadêŋ i nena, ‘Yêlô Lom iniŋ abô majaŋ hanaŋ aêntêk, yêlô miŋ hatôm naŋgik anyô te vônô oyaŋ ami. Mi, môŋ ma imiŋ ŋê takatu ba idum abô hathak yani maleŋiŋ ek endaŋô iniŋ abô. Vêm ma enaŋ iniŋ abô viyaŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Thêlô iviŋ ya ba êlêm, êŋ ma miŋ yahayabiŋ wak doho ami. Mi, haviyô hayaŋ ma yaha loŋ idum abô ba yahanaŋ ek neja Pol ba nêlêm. ");
INSERT INTO hot_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ma ŋê takatu ba idum abô ek yani iviyô imiŋ ma yahasoŋ nena tem nenaŋ yani anêŋ kambom anôŋ la bêŋ, ma doŋtom mi. ");
INSERT INTO hot_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Thêlô enaŋ hathak loŋôndê takatu ba nesopa iniŋ Wapômbêŋ ba enaŋ nena Pol miŋ hasopa loŋôndê êŋ thêthôŋ ami. Lôk enaŋ hathak anyô ŋama te anêŋ athêŋ nena Yisu atu ba Pol hanaŋ nena hamô lôkmala. ");
INSERT INTO hot_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Miŋ yahapôm loŋôndê la hatôm yapesaŋ malaiŋ êŋ ami. Ba intu yahanaŋ hik yani liŋ nena, ‘Lemhaviŋ nu Jelusalem ek yandaŋô anêm abô êŋ êndôk loŋ êŋ e?’ ");
INSERT INTO hot_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ma doŋtom yani hanaŋ nena yani lahaviŋ Sisa endaŋô anêŋ abô êndôk Lom. Ba intu yahanaŋ hadêŋ yenaŋ ŋê vovak nena neyabiŋ yani endeba yanêm yani ni Lom ek ênjê Sisa.” ");
INSERT INTO hot_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Êŋ ma Aglipa hanaŋ hadêŋ Pestas, “Yaleŋhaviŋ yandaŋô ôpêŋ da anêŋ abô.” Ma Pestas hanaŋ viyaŋ, “Mavi, biyamôŋ ma tem ondaŋô.” ");
INSERT INTO hot_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Haviyô hayaŋ ma Aglipa lo Benaisi ik iniŋ nômkama kêkêlô ba i malak bêŋ atu ethak elaŋô abô halôk. Ma ŋê vovak laik môŋ lôk ŋê bêŋbêŋ malak êŋ êlêm haviŋ thai. Ma Pestas hanaŋ ba ewa Pol halêm. ");
INSERT INTO hot_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ma Pestas hanaŋ, “Kiŋ Aglipa lôk môlô avômalô takatu ba lêk ômô haviŋ yêlô. Ôpêntêk ma avômalô Islael sapêŋ anêŋ Jelusalem lôk loŋ êntêk bôk elam lôklala hadêŋ ya ek yandôk esak iniŋ abô ba yanaŋ ek nijik ôpêntêk vônô. ");
INSERT INTO hot_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ma doŋtom miŋ yahapôm ôpêntêk anêŋ kambomlate hatôm yanaŋ ek nijik yani vônô ami. Ma yanida lahaviŋ ni ek Sisa endaŋô anêŋ abô ba intu tem yanêm yani ni ek ênjê Sisa. ");
INSERT INTO hot_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ma doŋtom yato malê esak yani êndôk kapya êntêk êndêŋ anyô bêŋ Sisa? Ba intu yahawa yani halêm ek o, Kiŋ Aglipa, lôk môlô sapêŋ ek alalô nadaŋô anêŋ abô katô ek apôm ôpêŋ anêŋ malaiŋ anêŋ ôdôŋ bêŋ, êŋ ma tem yato êndôk kapya êntêk. ");
INSERT INTO hot_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Yanêm anyô koladôŋ te oyaŋ ni êndêŋ Sisa ma miŋ yahato abô atu ba enaŋ yani bêŋ hathak halôk kapya ami, êŋ ma kambom.” ");
INSERT INTO hot_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Êŋ ma Aglipa hanaŋ hadêŋ Pol, “Yahêv thalek ek onaŋ anêm abô.” Ma Pol hêv baŋ liŋ ma hanaŋ anêŋ abô nena, ");
INSERT INTO hot_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kiŋ Aglipa, tem yaŋgik thô nena ŋê Islael iniŋ abô takatu ba enaŋ hathak ya ma miŋ abô avanôŋ ami. Yaleŋmavi anôŋ ek yanaŋ abô êŋ imiŋ malem ");
INSERT INTO hot_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ek malê nena o ma anyô lôkauk bêŋ hathak yêlô Islael iniŋ kobom sapêŋ. Ma hoyala abô takatu ba yêlô avak i vose hathak. Aêŋ ba yahalaŋ hadêŋ o nena ondaŋô yenaŋ abô vêmam. ");
INSERT INTO hot_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Avômalô Islael sapêŋ bôk eyala yenaŋ bôk lo loŋ takatu ba yahasopa hadêŋ sêbôk atu ba ya yaôna ba yahamô yenaŋ loŋ aleba lêk. Lôk eyala loŋôndê takatu ba yahasopa hamô Jelusalem haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Thêlô bôk eyala ya bô ba hatôm nenaŋ nena ya ma Palisi te. Palisi ethak esopa Wapômbêŋ lôk anêŋ balabuŋ lôklokwaŋ ba êmôŋ ek Islael iniŋ ôdôŋ vi. ");
INSERT INTO hot_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ma yahathak yahêv yamaleŋ ek malêla takatu ba Wapômbêŋ bôk havak abô haviŋ bumalô thêlô ek nêm. Ma hathak ôdôŋ êŋ, ma lêk idum abô ek ya. ");
INSERT INTO hot_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Yêlô ma lodôŋlodôŋ hatôm laumiŋ ba lahavuju, ma wak lo bôlôvôŋ ma athak aêv yeŋ lôklokwaŋ hadêŋ Wapômbêŋ lôk aêv maleŋ ek nôm takatu ba yani bôk havak ek nêm injik anêŋ anôŋ. Kiŋ, yahêv yamaleŋ ek nôm takêŋ ba intu lêk avômalô Islael enaŋ ya bêŋ. ");
INSERT INTO hot_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Aisê ka môlô doho lemimhabi nena Wapômbêŋ miŋ hatôm injik ŋê ŋama liŋ esak loŋbô ami e? ");
INSERT INTO hot_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Sêbôk ma yenaŋ auk thekthek ek yandum nômkama bêŋ anôŋ ek yamiŋ avômalô takatu ba esopa Yisu anêŋ Nasalet loŋ siŋ ek miŋ nesopa ami. ");
INSERT INTO hot_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ma bôk yahadum aêŋ haveŋ Jelusalem. Ŋê bêŋbêŋ êbôk da anêŋ loŋ êŋ bôk êv athêŋ hadêŋ ya ba intu yahavaloŋ avômalô matheŋ bêŋ anôŋ ba yahadô i hamô koladôŋ. Ma ik i vônô ma yahalôk hathak iniŋ auk êŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ma wak bêŋ anôŋ ma yaha unyak yeŋ nenanena ek yanêm vovaŋ êndêŋ i. Lôk yahabi thêlô leŋiŋ liŋ ek nenaŋ abôma esak Yisu. Yaleŋmaniŋ kambom anôŋ hathak thêlô ba intu yaha malak lôŋ takatu ba êmô loŋ buyaŋ ek yanêm malaiŋ êndêŋ i imbiŋ. ");
INSERT INTO hot_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Wak te ma yaha Damaskas ek yambuliŋ ŋê êvhaviŋ ma ŋê bêŋbêŋ êbôk da êv athêŋ lôk lôklokwaŋ hadêŋ ya ek yandum ku êŋ. ");
INSERT INTO hot_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kiŋ, hatôm waklêvôŋ biŋ ma yahabup hathak loŋôndê denaŋ ma deda lôkmaŋgiŋ anôŋ te anêŋ leŋ habi hayô hêk ya lôk ŋê takatu ba eveŋ haviŋ ya. Wak anêŋ deda ma yaôna lôk ek deda êŋ anêŋ. ");
INSERT INTO hot_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ma yêlô lôkthô êv yak halôk pik ma yahalaŋô abô te halêm hadêŋ ya hathak abô Hiblu nena, ‘Sol, Sol, hubuliŋ ya eka? O hatôm bokmaŋkao atu ba habôi ba miŋ hasopa anêŋ alaŋ anêŋ lahaviŋ ami ba hapam i velevele hathak kôm damoma ba hawa vovaŋ.’ ");
INSERT INTO hot_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ma yahanaŋ, ‘Anyô Bêŋ, o opalê?’ “Ma Anyô Bêŋ hanaŋ, ‘Ya ma Yisu atu ba hubuliŋ. ");
INSERT INTO hot_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Umbiyô umiŋ. Yahik ya thô hadêŋ o ek yatak o ek umbitak yenaŋ anyô ku. Ma tem onaŋ abô esak nôm takatu ba lêk hôyê lôk nôm takatu ba tem yaŋgik thô êndêŋ o embeŋ yam bêŋ êndêŋ avômalô. ");
INSERT INTO hot_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ma tem yanêm o bulubiŋ ênjêk anêm avômalô lôk avômalô loŋ buyaŋ baheŋiŋ. Ma yanêm o êndêŋ thêlô ");
INSERT INTO hot_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ek okyav thêlô maleŋiŋ lôk nuŋgwik i liliŋ ênjêk momaŋiniŋ ni êndêŋ deda. Ma nuŋgwik thêlô liliŋ ênjêk Sadaŋ anêŋ lôklokwaŋ ni êndêŋ Wapômbêŋ anêŋ lôklokwaŋ ek yanêm iniŋ kambom vê lôk neja loŋ imbiŋ avômalô takatu ba bôk ibitak matheŋ hathak iniŋ êvhaviŋ ya.’ ");
INSERT INTO hot_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Aêŋ ba, Kiŋ Aglipa, wêŋ atu ba yahayê anêŋ leŋ ma yahawê anêŋ abô vibiŋ. ");
INSERT INTO hot_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ma yahanaŋ Abô Mavi hadêŋ avômalô ek nede kapôlôŋiŋ liliŋ êndêŋ Wapômbêŋ ma nindum kobom thêthôŋ ek injik thô nena avanôŋ lêk ele kapôlôŋiŋ liliŋ yôv. Môŋ ma yahanaŋ abô êŋ halôk Damaskas vêm ma Jelusalem lôk Judia sapêŋ aleba yahanaŋ abô êŋ hadêŋ ŋê loŋ buyaŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Aêŋ ba intu avômalô Islael evaloŋ ya hêk unyak matheŋ anêŋ piklêvôŋ ma idum ek nijik ya vônô. ");
INSERT INTO hot_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ma doŋtom Wapômbêŋ hêv ya sa aleba lêk. Ba intu yahamiŋ loŋ êntêk ba yahanaŋ abô hadêŋ ŋê athêŋ mi lôk ŋê athêŋ bêŋ haviŋ. Ma abô takatu ba yahanaŋ ma miŋ abô yaŋda ami. Mi, abô êŋ iyom intu plopet lo Mose bôk enaŋ nena tem imbitak. ");
INSERT INTO hot_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ba enaŋ Mesia tem enja vovaŋ ba ema, ma tem imbiyô môŋ ek avômalô ŋama sapêŋ ba enaŋ abô esak deda êndêŋ anêŋ avômalô Islael lôk avômalô loŋ buyaŋ imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol hanaŋ abô denaŋ ma Pestas halam lôklala nena, “Pol, anêm auk lêk hêv yak! Auk bêŋ takatu ba howa ma lêk hadum o hubitak anyô molo.” ");
INSERT INTO hot_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ma Pol hanaŋ, “Anyô bêŋ Pestas, abô takatu ba yahanaŋ ma thêthôŋ ma avanôŋ biŋ. Ma miŋ ya molo ami. ");
INSERT INTO hot_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ma nôm takêŋ ma hêk loŋ yaiŋ ma miŋ hêk loŋ kapô ami. Ba intu Kiŋ Aglipa miŋ hatôm êsôŋ ami. Mi, yani bôk hayala nôm takêŋ yôv ba intu yahanaŋ abô takêŋ bêŋ hadêŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kiŋ Aglipa, hôêvhaviŋ plopet iniŋ abô takatu ba bôk eto bô mena mi e? Yahayala nena hôêvhaviŋ.” ");
INSERT INTO hot_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ma Aglipa hanaŋ hadêŋ Pol, “Hosoŋ nena sawa bidoŋ êntêk hatôm undum ba yambitak Kilisi anêŋ anyô te e?” ");
INSERT INTO hot_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ma Pol hanaŋ, “Sawa bidoŋ mena sawa daim, ma doŋtom yaleŋhabi nôm doŋtom iyom ba intu yahateŋ mek hadêŋ Wapômbêŋ nena o lôk avômalô takatu ba lêk elaŋô yenaŋ abô, môlô lôkthô numbitak êtôm ya. Ma doŋtom yahadô seŋ embaloŋ môlô loŋ êtôm êntêk lêk havaloŋ ya loŋ.” ");
INSERT INTO hot_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pol hanaŋ abô êŋ, ma Kiŋ Aglipa lôk anyô bêŋ hayabiŋ Judia ma Benaisi lôk ŋê takatu ba êmô haviŋ thêlô, lôkthô iviyô imiŋ ");
INSERT INTO hot_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ma etak loŋ êŋ ba i. Ma thêlôda enaŋ hadêŋ i nena, “Anyô êntêk miŋ hadum nômlate kambom ek nijik yani vônô mena nêndô êmô koladôŋ ami. Mi.” ");
INSERT INTO hot_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ma Aglipa hanaŋ hadêŋ Pestas nena, “Ôpêntêk bôk halam Sisa yôv ek endaŋô anêŋ abô. Ma mi, ma tem nanêm yani vê ba ni.” ");
INSERT INTO hot_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Haveŋ yam ma thêlô epesaŋ abô ek Pol lôk ŋê koladôŋ doho neja yeŋ ba ini pik bêŋ Itali. Ma etak thêlô halôk anyô vovak laik te baŋ, yani anêŋ athêŋ nena Julias. Yani hayabiŋ Sisa anêŋ ŋê vovak ôdôŋ takatu ba lôkmaŋgiŋ anôŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Thêlô ethak yeŋ te ma yai lôk anyô Tesalonaika te anêŋ athêŋ nena Alistakas athak yeŋ êŋ haviŋ ba yêlô a. Tesalonaika ma hamô plovins Masedonia kapô. Yeŋ êŋ halêm anêŋ loŋ Adlamitiam ma hadum ek ni lomalak nenanena takatu ba hamô plovins Esia kapô. ");
INSERT INTO hot_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Haviyô hayaŋ ma yêlô athak Saidon ma Julias hadum mavi hadêŋ Pol ba hatak yani ek ni ênjê anêŋ avômalô môlô ek nênêm yani sa esak nômkama takatu ba yani mi. ");
INSERT INTO hot_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Yêlô atak Saidon ba a ma lovak bêŋ te hayuv yêlô vôkê ba intu yêlô asopa Ŋgavithôm Saiplus vidôm. ");
INSERT INTO hot_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ma yeŋ halom hêk ŋgwêk malêvôŋ biŋ hêk plovins Silisia lo Pampilia aleba athak Maila anêŋ plovins Lisia. ");
INSERT INTO hot_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Loŋ êŋ ma anyô vovak laik atu hayê yeŋ te halêm anêŋ Aleksandlia ba hadum ek ni Itali. Ba hawa yêlô hathak yeŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ma lovak hayuv kambom ba intu yeŋ hi yaôyaô hatôm wak bêŋ anôŋ ba hêv malaiŋ bêŋ ek yeŋ ni esak Naidas. Hayô habobo Naidas, êŋ ma lovak bêŋ hayuv ba yeŋ miŋ hatôm esopa yeŋ anêŋ loŋ atu ba hathak halom ba hi Itali ami. Ba intu yeŋ hik i liliŋ ba halom hêk Ŋgavithôm Klit anêŋ viyaiŋ ba hi habobo loŋ te anêŋ athêŋ nena Salmoni. ");
INSERT INTO hot_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Yeŋ anêŋ ŋê ku idum ku bêŋ ba yêlô asopa ŋgwêk daŋ iyom aleba ayô loŋ atu elam nena Loŋ Mavi Ek Yeŋ Êmô. Loŋ êŋ hamô habobo malak Lasia. ");
INSERT INTO hot_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Wak bêŋ anôŋ bôk hale ba hi yôv lôk Islael iniŋ waklavôŋ Evak Balabuŋ Ek Nôm bôk hale ba hi haviŋ ba intu lêk ma waklavôŋ kambom ek yeŋ embeŋ ŋgwêk. Êŋ ma Pol hanaŋ hadêŋ thêlô, ");
INSERT INTO hot_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Aiyaŋ thêlô, yahayala nena alalô a ma malaiŋ bêŋ tem êpôm alalô ba imbuliŋ yeŋ lôk nômkama takatu ba hamô yeŋ ma alalô bêŋ anôŋ tem nama imbiŋ.” ");
INSERT INTO hot_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ma doŋtom anyô vovak laik hasopa anyô hawa yeŋ lôk yeŋ anêŋ alaŋ iniŋ abô, ma miŋ hasopa Pol anêŋ abô ami. ");
INSERT INTO hot_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Loŋ Mavi Ek Yeŋ Êmô êŋ ma miŋ mavi ek yeŋ êmô êndêŋ waklavôŋ ŋgwêk beleŋ lokwaŋ hik ami. Ba intu avômalô bêŋ anôŋ leŋiŋhabi nena yêlô natak loŋ êŋ ma ana Piniks ek namô loŋ êŋ endeba ŋgwêk beleŋ lokwaŋ ende êndôk am. Piniks ma Ŋgavithôm Klit anêŋ loŋ te atu ba havova hêk ŋgwêk malêvôŋ ba intu loŋ mavi ek yeŋ êmô êndêŋ waklavôŋ ôthôm beleŋ lokwaŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yêlô amô aleba lovak yaônate hayuv ma thêlô esoŋ nena hatôm yêlô ana mavi. Êŋ ma êvôv aŋga hathak ma idum ek nesopa Klit anêŋ ŋgwêk daŋ ba ini Piniks. ");
INSERT INTO hot_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ma miŋ yêlô a daim ami ma lovak lôklokwaŋ bêŋ te hayuv yêlô vôkê hêk liŋdaŋ ba yeŋ hi ŋgwêk malêvôŋ biŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Lovak hayuv lôklokwaŋ bomaŋ ba yeŋ miŋ hatôm imbup êndôk ŋgwêk daŋ ami. Ba intu yêlô atak ma yeŋ hasopa lovak anêŋ lahaviŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Lovak hayuv yêlô vôkê aleba ayô ŋgavithôm yaônate atu elam nena Kauda vidôm. Ma Kauda hêk lovak loŋ siŋ dokte. Ba intu yêlô avôv yêlôaniŋ yeŋ yaôna hathak ba halêm. Ma doŋtom yêlô avôv mathalaleŋ kambom ek malê nena lovak bêŋ hayuv denaŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Thêlô êvôv yeŋ yaô ba etak halôk yeŋ bêŋ kapô ma ibutiŋ yeŋ lokwaŋ loŋ hathak yak balawa doho ek embaloŋ yeŋ loŋ. Thêlô êkô kambom nena lovak tem iyuv thêlô endeba nesak thathe atu ba hamô ŋgwêk malêvôŋ habobo Siltis anêŋ Aplika. Ba intu ibi aŋga halôk ŋgwêk ek embaloŋ yeŋ loŋ ek ni yaôyaô dokte. ");
INSERT INTO hot_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Haviyô hayaŋ ma lovak lôk ŋgwêk hik yêlô kambom, ba ibi nômkama takatu ba yeŋ hawa doho halôk ŋgwêk ba hi. ");
INSERT INTO hot_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ma wak te lô ma evaloŋ yeŋ anêŋ alokwaŋ havaloŋ sôp loŋ lôk anêŋ yak ba ibi halôk ŋgwêk ba hi. ");
INSERT INTO hot_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Wak bêŋ anôŋ ma yêlô miŋ ayê wak lo vuliŋ ami ek malê nena lovak lôk ôthôm bêŋ hayuv denaŋ ba hadum ba yêlô sapêŋ akô kambom nena tem nama. ");
INSERT INTO hot_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Wak bêŋ anôŋ ma yêlô sapêŋ miŋ aŋ nôm ami, êŋ ma Pol halam thêlô hathak doŋtom ma hanaŋ, “Aiyaŋ thêlô, bôk yahanaŋ nena miŋ alalô natak Klit ami, ma namô vêmam. Êŋ ma tem miŋ napôm malaiŋ êntêk lôk miŋ hatôm nômkama la nêm yak ami. ");
INSERT INTO hot_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ma doŋtom lêk ma yanaŋ êndêŋ môlô nena numiŋ lôklokwaŋ ma miŋ nôkô ami ek malê nena anyôla tem miŋ ema ami. Mi, yeŋ iyom intu tem kambom. ");
INSERT INTO hot_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Bôkam ma yenaŋ alaŋ Wapômbêŋ atu ba yahadum anêŋ ku anêŋ aŋela hamiŋ habobo ya ma hanaŋ, ");
INSERT INTO hot_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Pol, miŋ ôkô ami. Tem umiŋ Sisa ma ek undum abô. Aêŋ ba ondaŋô. Wapômbêŋ lêk halaŋô anêm mek ba ŋê takatu ba êmô yeŋ haviŋ o, sapêŋ tem nêmô lôkmala.’ ");
INSERT INTO hot_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Aêŋ ba numiŋ lôklokwaŋ ma miŋ nôkô ami! Yahêvhaviŋ Wapômbêŋ nena tem indum ba nômkama sapêŋ tem imbitak êtôm atu ba anêŋ aŋela hanaŋ hadêŋ ya. ");
INSERT INTO hot_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Yeŋ tem esak ŋgavithôm te anêŋ liŋdaŋ ma alalô sapêŋ tem namô lôkmala.” ");
INSERT INTO hot_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ma wak te laumiŋ ba lahavuva anêŋ bôlôvôŋ ma lovak hayuv yêlô lôklokwaŋ denaŋ ba yêlô amô Ŋgwêk Adliatik. Ma habobo bôlôvôŋ biŋ ma ŋê ku yeŋ elaŋô nena yeŋ lêk habobo ŋgwêk daŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Aêŋ ba thêlô ililu yeŋ anêŋ lavôŋiŋ ma êyê nena ŋgwêk anêŋ daim ma lêk hatôm 37 mita. Ma yêlô a dokte ma ililu hathak loŋbô ma êyê nena lêk hatôm 27 mita. ");
INSERT INTO hot_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Êŋ ma thêlô êkô kambom nena tem yêlô nasak valu ba ibi yeŋ anêŋ aŋga ayova halôk yeŋ layuk ma eteŋ mek ek eyaŋ wak bêŋ ketheŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ma yeŋ anêŋ ŋê ku idum ek nêsôv ba ini. Ba intu etak yeŋ yaô atu halôk ŋgwêk ma esau nena imbi aŋga doho halôk yeŋ anêŋ thohav. ");
INSERT INTO hot_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ma doŋtom Pol hanaŋ hadêŋ anyô vovak laik lôk anêŋ ŋê vovak nena, “Ŋê takêntêk etak yeŋ ba i, ma tem môlô sapêŋ noma.” ");
INSERT INTO hot_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Êŋ ma ŋê vovak edabêŋ yeŋ yaô anêŋ yak kisi ba hêv yak halôk ŋgwêk. ");
INSERT INTO hot_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Habobo eyaŋ wak bêŋ ma Pol hasoŋ thêlô lokwaŋ ba hanaŋ ek thêlô sapêŋ nejaŋ nôm. Ma hanaŋ nena, “Wak laumiŋ ba lahavuva bôk hale ba hi yôv ma môlô ômô lôk kapôlômim daluk ba miŋ oaŋ nôm ami. ");
INSERT INTO hot_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ma lêk yahanaŋ hadêŋ môlô nena tem miŋ malaiŋ la êpôm môlô ami. Mi. Ba intu yahasoŋ môlô lokwaŋ nena oŋgwaŋ nôm dokte ek embatho môlô loŋ ek nômô mavi.” ");
INSERT INTO hot_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Yani hanaŋ aêŋ vêm ma hawa polom ba hêv lamavi hadêŋ Wapômbêŋ hamiŋ thêlô maleŋiŋ. Ma haŋgôli polom atu ba hayaŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Êŋ ma anyô sapêŋ leŋiŋ halôk biŋ ma ewa nôm ba eyaŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Yêlô sapêŋ atu ba amô yeŋ ma hatôm 276. ");
INSERT INTO hot_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Eyaŋ nôm takatu ba leŋiŋhaviŋ yôv, ma ibi wit halôk ŋgwêk ek yeŋ vumvum. ");
INSERT INTO hot_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Lu hayaŋ wak bêŋ hayô, ma thêlô êyê liŋdaŋ, ma doŋtom êthôŋ loŋ êŋ paliŋ. Ma êyê loŋ mavi te hêk ek yeŋ êmô ba loŋ êŋ ma loŋ thathe mavi. Ba intu leŋiŋhabi nena nimbusiŋ yeŋ ba ni nôŋnôŋ êndêŋ loŋ êŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Êŋ ma thêlô edabêŋ yeŋ anêŋ aŋga takatu ba havaloŋ yeŋ loŋ kisi ba êv yak halôk ŋgwêk kapô. Ma epole yak balawa takatu ba havaloŋ yeŋ anêŋ nôm nimbusiŋ vê. Ma thêlô êthôkwêŋ yeŋ anêŋ sôp lovak hathak ma lovak hayuv yeŋ hi ek esak liŋdaŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ma doŋtom yeŋ halaŋviŋ ba hi hathak thathe atu ba hamô ŋgwêk malêvôŋ ba havaloŋ yeŋ loŋ lôklokwaŋ. Ma ŋgwêk budum bêŋ hik yeŋ layuk aleba hapup nenanena. ");
INSERT INTO hot_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ma ŋê vovak leŋiŋhabi nena nijik ŋê koladôŋ sapêŋ vônô ek miŋ neyam ba nêsôv ami. ");
INSERT INTO hot_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ma doŋtom anyô vovak laik lahaviŋ nêm Pol sa ba intu hêk thêlô loŋ siŋ. Ma hanaŋ hadêŋ ŋê takatu ba eyala neyam nena nêsôv kisi êndôk ŋgwêk êmôŋ ba neyam ba ini liŋ. ");
INSERT INTO hot_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ma takatu ba êthôŋ neyam, êŋ ma vi nêyô nêjêk aseleŋ ma vi neja yeŋ anêŋ nômkama takatu hapup loseleŋ loseleŋ ba nêyô nêjêk seleŋ tomtom ba neyam ba ini liŋdaŋ. Thêlô idum aêŋ ma sapêŋ ethak liŋ mavi. ");
INSERT INTO hot_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Yêlô sapêŋ athak liŋ mavi vêm ma ayala nena ŋgavithôm êŋ ma elam nena Molta. ");
INSERT INTO hot_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ma avômalô ŋgavithôm êŋ ewa yêlô thô ba idum kobom mavi anôŋ hadêŋ yêlô. Ôthôm hik ba loŋ lêk thilibuŋ kambom ba intu thêlô ebaŋ atum ek yêlô nabuŋu. ");
INSERT INTO hot_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ma Pol hasup ayôk doho ba habaŋ hathak atum ma umya kambom te hêk ayôk kapô ba atum haliŋ ba vovaŋ. Êŋ ma hale yaiŋ ma hathaŋ Pol baŋ. ");
INSERT INTO hot_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ma avômalô loŋ êŋ êyê umya hakêlô hamiŋ Pol baŋ ma enaŋ hadêŋ thêlôda nena, “Avanôŋ biŋ, ôpêntêk ma anyô hik anyô vônô la. Ma doŋtom ŋgwêk miŋ halok yani vônô ami ba intu umya hadum ek injik loŋôndê thêthôŋ thô.” ");
INSERT INTO hot_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ma doŋtom Pol havali baŋ ma umya êŋ hêv yak hayô hêk atum ma miŋ nômla hapôm yani ami. ");
INSERT INTO hot_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Avômalô loŋ êŋ leŋiŋhabi nena Pol liŋkupik tem isiŋ bêŋ mena nêm yak ba ema la. Ma doŋtom thêlô eyabiŋ aleba lêk sawa daim ma miŋ nômlate hapôm yani ami. Êŋ ma thêlô ik iniŋ auk liliŋ ma enaŋ, “Yani ma ŋgôk te la.” ");
INSERT INTO hot_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Anyô loŋ êŋ te anêŋ athêŋ nena Publias ma yani ma ŋgavithôm êŋ iniŋ anyô bêŋ. Ma anêŋ loŋ hamô habobo loŋ atu ba yeŋ hathak. Ôpêŋ hawa yêlô ba hi anêŋ unyak ma hayabiŋ yêlô mavi anôŋ hatôm wak lô. ");
INSERT INTO hot_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ôpêŋ anêŋ lambô bôk hapôm lijiŋ liŋkupik vovaŋ lôk habopakla ba hêk iyom. Ma Pol hi ek ênjê yani. Hayô ma hateŋ mek vêm ma hatak baŋ hayô hêk yani ma hadum ôpêŋ habitak mavi hathak loŋbô. ");
INSERT INTO hot_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Avômalô ŋgavithôm êyê nôm êŋ, ma iniŋ avômalô lôk lijiŋ sapêŋ i hadêŋ Pol ma yani hadum ba thêlô sapêŋ ibitak mavi. ");
INSERT INTO hot_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Thêlô êv athêŋ bêŋ hadêŋ yêlô hathak kobom mavi lomaloma. Aêŋ ba yêlô apôpêk i ek ana ma êv yêlô sa hathak nômkama takatu ba yêlô mi. ");
INSERT INTO hot_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Yêlô amô ŋgavithôm êŋ hatôm ayôŋ lô, êŋ ma yêlô athak yeŋ te atu ba bôk hamô loŋ êŋ hadêŋ waklavôŋ ŋgwêk beleŋ lokwaŋ. Yeŋ êŋ halêm anêŋ malak Aleksandlia. Ma yeŋ thohav ma etak ŋgôkba lopopek dahô hamô, ŋgôkba yaŋ anêŋ athêŋ nena Kasto ma yaŋ ma Polaks. Êŋ ma yêlô athak yeŋ êŋ ba a. ");
INSERT INTO hot_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Yêlô a aleba athak malak Silakius ma amô loŋ êŋ hatôm wak lô. ");
INSERT INTO hot_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ma yêlô atak loŋ êŋ ma a aleba athak malak Legiam. Ma haviyô hayaŋ ma yêlô a, ma lovak mavi hayuv ba wak yaŋ ma yêlô athak malak Puteoli. ");
INSERT INTO hot_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ma loŋ êŋ ma yêlô apôm ŋê êvhaviŋ doho ba ewa yêlô thô ma enaŋ ek yêlô namô imbiŋ i êtôm sonda te. Vêm ma yêlô atak i ma aveŋ pik ba a Lom. ");
INSERT INTO hot_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ma avômalô êvhaviŋ anêŋ Lom elaŋô nena yêlô aveŋ loŋôndê ek nayô Lom, êŋ ma etak Lom ba i ek nêpôm yêlô êndôk loŋôndê. Doho i malak te anêŋ athêŋ nena “Apias Anêŋ Loŋ Êv Vuli Nômkama”, ma doho i malak yaŋ ba anêŋ athêŋ nena “Unyak Lô Ek Vathi”. Pol hayê thêlô ma hêv lamavi hadêŋ Wapômbêŋ ma kapô halôk biŋ. ");
INSERT INTO hot_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Yêlô ayô Lom ma enaŋ nena Pol ênjêk unyak te êtôm yani da anêŋ lahaviŋ. Ma anyô vovak te eyabiŋ yani. ");
INSERT INTO hot_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Wak lô hale ba hi ma Pol halam Islael iniŋ ŋê bêŋbêŋ takatu ba êmô Lom ethak doŋtom ma hanaŋ, “Aiyaŋ thêlô, miŋ yahadum nômla kambom hadêŋ alalôaniŋ avômalô mena yahabuliŋ bumalô thêlô iniŋ kobom ami. Ma doŋtom anêŋ Jelusalem ma evaloŋ ya ba etak ya halôk Lom baheŋiŋ. ");
INSERT INTO hot_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ma avômalô Lom elaŋô yenaŋ abô ma enaŋ nena miŋ yahadum nômlate kambom ek nijik ya vônô ami. Ba intu thêlô leŋiŋhaviŋ nênêm ya vê ênjêk koladôŋ. ");
INSERT INTO hot_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ma doŋtom avômalô Islael êdô ba imiŋ lôklokwaŋ aleba ya loŋôndê mi ba intu yahalam ek Sisa endaŋô yenaŋ abô. Miŋ yahadum aêŋ ek yanaŋ thêlô bêŋ êndêŋ Sisa esak kambom takatu ba idum hadêŋ ya ami. Mi. ");
INSERT INTO hot_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ba intu yahalam môlô ek nôlêm ek yaŋgê môlô lôk yanaŋ abô imbiŋ môlô. Miŋ yahadum kambom la ami, ma doŋtom seŋ havaloŋ ya loŋ. Ek malê nena yahêv yamaleŋ hathak nôm doŋtom atu ba avômalô Islael ethak êv maleŋiŋ hathak. Nôm êŋ ma Mesia.” ");
INSERT INTO hot_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ma enaŋ viyaŋ, “Miŋ anyô Judia la hato kapya hadêŋ yêlô ba hanaŋ abôla hathak o mena ŋê Islael takatu ba êlêm loŋ êntêk, miŋ enaŋ abô kambom la hathak o ami. Mi. ");
INSERT INTO hot_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ma doŋtom yêlô ayala nena loŋ nômbêŋ intu sapêŋ ma avômalô enaŋ abô kambom hathak loŋôndê nênêmimbiŋ Yisu. Ba intu yêlô leŋiŋhaviŋ nadaŋô anêm auk nena honaŋ aisê hathak loŋôndê êŋ.” ");
INSERT INTO hot_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Êŋ ma etak wak yaŋ ek nesak doŋtom imbiŋ yani. Wak êŋ hayô ma avômalô Islael bêŋ anôŋ êyô unyak atu ba Pol hamô. Lôkbôk hi aleba bôlôvôŋ ma Pol hanaŋ abô hadêŋ thêlô. Ma hik Wapômbêŋ anêŋ loŋ lôkliŋyak anêŋ ôdôŋ thô hadêŋ i. Ma hik iniŋ auk liŋ hathak Mose anêŋ balabuŋ lôk plopet iniŋ abô ek thêlô nênêmimbiŋ nena Yisu ma Mesia atu. ");
INSERT INTO hot_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ma thêlô doho êvhaviŋ abô takatu ba hanaŋ ma doho ma mi. ");
INSERT INTO hot_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ma thêlôda enaŋ abô lôk vovak ba evak i vose hi ôdôŋ ju. Ba idum ek ini ma Pol hanaŋ abô te haveŋ yam nena, “Lovak Matheŋ bôk hanaŋ abô avanôŋ hadêŋ libumi halôk plopet Aisaia ba hanaŋ aêntêk, ");
INSERT INTO hot_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“‘Nu êndêŋ avômalô takêntêk ba onaŋ êndêŋ i nena, “Wak nômbêŋ intu ma tem nodaŋô abô, ma doŋtom tem miŋ hatôm noyala anêŋ ôdôŋ ami; Ma wak nômbêŋ intu ma tem ôŋgô nômlate, ma doŋtom miŋ hatôm nôpôm anêŋ ôdôŋ ami.” ");
INSERT INTO hot_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ek malê nena avômalô takêŋ iniŋ auk ma thekthek, ma ibi leŋiŋôndôŋ siŋ, lôk ivuliv maleŋiŋ siŋ. Ma mi, ma tem nêgê tak esak maleŋiŋ, lôk nedaŋô êndôk leŋiŋôndôŋ, lôk neja ênjêk iniŋ auk ma tem nede kapôlôŋiŋ liliŋ ek yandum thêlô ba nimbitak mavi.’ ");
INSERT INTO hot_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Aêŋ ba noyala katô nena Wapômbêŋ hêv anêŋ abô hathak anêŋ bulubiŋ hadêŋ avômalô loŋ buyaŋ ba tem thêlô neja thô.” ");
INSERT INTO hot_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pol hanaŋ abô êŋ yôv, êŋ ma avômalô Islael etak yani ba i. Ma êkôki hathak anêŋ abô takatu. ");
INSERT INTO hot_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Hatôm sondabêŋ ju ma Pol hamô unyak atu ba yanida hêv vuli ma hawa avômalô takatu ba êlêm ek nêgê yani thô lôk lamavi. ");
INSERT INTO hot_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ma yani hamiŋ lôklokwaŋ ma kô mi ma hanaŋ abô hathak Wapômbêŋ anêŋ loŋ lôkliŋyak ma hadôŋ avômalô hathak Anyô Bêŋ Yisu Kilisi. Ma anyôla miŋ hamiŋ yani loŋ siŋ ami. ");
INSERT INTO hot_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ya Pol, Yisu Kilisi anêŋ anyô ku, yahato kapya êntêk. Wapômbêŋ bôk halam ya ek yambitak aposel ma hatak ya ek yanaŋ anêŋ Abô Mavi êŋ bêŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Abô Mavi êŋ ma bôk habutiŋ ek nêm ba anêŋ plopet bôk enaŋ bêŋ hêk kapya matheŋ atu. ");
INSERT INTO hot_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Abô Mavi êŋ ma hanaŋ hathak anêŋ Nakaduŋ atu ba halêm pik hatôm anyô ba habitak anêŋ Kiŋ Devit anêŋ thalaleŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Wapômbêŋ hik yani liŋ hêk ŋama ba hathak Lovak Matheŋ hik yani thô nena Wapômbêŋ Nakaduŋ Lôklokwaŋ. Yani ma Yisu Kilisi, alalôaniŋ Anyô Bêŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Hathak yani, Wapômbêŋ habi anêŋ wapôm sam hadêŋ yêlô ba hadum yêlô abitak anêŋ aposel ek nandom avômalô loŋ buyaŋ lôkthô ek nênêmimbiŋ ba nesopa yani ek nênêm athêŋ bêŋ êndêŋ yani. ");
INSERT INTO hot_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ma halam môlô aêŋ iyom ek numbitak Yisu Kilisi anêŋ imbiŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Yahato kapya êntêk hadêŋ môlô takatu ba Wapômbêŋ lahaviŋ anêŋ Lom. Yani halam môlô ek numbitak anêŋ avômalô matheŋ. Alalôaniŋ Kamik Wapômbêŋ lôk Anyô Bêŋ Yisu Kilisi iniŋ wapôm lôk labali êmô imbiŋ môlô. ");
INSERT INTO hot_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Abô takatu ba yahadum ek yanaŋ êmôŋ ma avômalô pik bêŋ êntêk lôkthô enaŋ hathak unim ôêvhaviŋ. Ba intu yaleŋhabi môlô ba yahêv yaleŋmavi hadêŋ yenaŋ Wapômbêŋ hathak Yisu Kilisi anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Yahathak yahadum Wapômbêŋ anêŋ ku lôk yakapôlôŋ lôkthô ba intu yahanaŋ Abô Mavi hathak Nakaduŋ bêŋ. Ma yanida hayala nena yahathak yahateŋ mek velevele ek môlô ");
INSERT INTO hot_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ma miŋ yaleŋpaliŋ ami. Bôk yahateŋ mek bôbô ba yahanaŋ hik anêŋ lahaviŋ liŋ hatôm êpôm loŋôndê te ek yasôk yaŋgê môlô mena mi e? ");
INSERT INTO hot_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Yahêk lêlê ek yaŋgê môlô ek yanêm môlô Lovak Matheŋ anêŋ mek mavi doho ek embatho môlônim ôêvhaviŋ loŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ek batu môlônim ôêvhaviŋ embatho yenaŋ loŋ ma yenaŋ embatho môlônim loŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Aiyaŋ thêlô, noyala katô nena wak bêŋ anôŋ yaleŋhabi yasôk yaŋgê môlô, ma doŋtom nôm lomaloma habitak ba havasiŋ ya. Yahadum ku lomaloma haviŋ avômalô loŋ buyaŋ ba yahayê ku takêŋ anêŋ anôŋ habitak. Ba intu yaleŋhaviŋ yasôk ek yandum ku imbiŋ môlô ek anêŋ anôŋ imbitak aêŋ iyom. ");
INSERT INTO hot_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Wapômbêŋ hêv ku hadêŋ ya ek yanaŋ anêŋ Abô Mavi êndêŋ avômalô sapêŋ, avômalô ŋgwêk lôk avômalô alonaŋ, ma ŋê lôkauk lôk ŋê thôŋôthôŋ. Ba intu miŋ hatôm yatak ku êŋ ami. ");
INSERT INTO hot_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Aêŋ ba yahapôviŋ ya ek yanaŋ Wapômbêŋ anêŋ Abô Mavi êndêŋ môlô avômalô Lom imbiŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Abô Mavi ma Wapômbêŋ anêŋ lôklokwaŋ ek nêm avômalô sapêŋ atu ba êvhaviŋ bulubiŋ. Ba intu ya miŋ mama ek yanaŋ abô êŋ bêŋ ami. Môŋ ma hêv avômalô Islael bulubiŋ vêm ma avômalô loŋ buyaŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Abô Mavi êŋ intu hik Wapômbêŋ anêŋ loŋôndê atu ba endam avômalô nena thêthôŋ thô. Loŋôndê êŋ ma êvhaviŋ iyom, ma miŋ loŋôndê yaŋ hêk ek nimbitak thêthôŋ ênjêk Wapômbêŋ ma ami. Hatôm bôk eto nena, “Avômalô takatu ba êvhaviŋ Wapômbêŋ, ma tem endam i nena avômalô thêthôŋ ek nêmô lôkmala.” ");
INSERT INTO hot_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Wapômbêŋ leŋ lêk hik anêŋ lamaniŋ thô hadêŋ avômalô lôkthô atu ba êvôliŋ dômiŋ hadêŋ yani ba idum kambom lomaloma. Iniŋ kambom takêŋ intu haluviŋ abô avanôŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Bôk Wapômbêŋ hik auk anôŋ hathak yanida thô hadêŋ avômalô sapêŋ ba intu bôk eyala yôv hêk kapôlôŋiŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Anyôla miŋ hatôm ênjê Wapômbêŋ esak ma ami. Ma doŋtom yani hapesaŋ pik lo leŋ ma hathak nôm takêŋ, thêlô hatôm neyala nena yani ma yaŋda ek malê nena yani ma Wapômbêŋ. Ma anêŋ lôklokwaŋ bôk hamô bô ba tem êmô êtôm wak nômbêŋ intu sapêŋ. Aêŋ ba avômalô lôkthô bôk eyala yôv, ba miŋ hatôm nesavuthiŋ ba nenaŋ nena êthôŋ Wapômbêŋ ami. ");
INSERT INTO hot_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Avanôŋ, thêlô bôk eyala Wapômbêŋ ma doŋtom miŋ êbô anêŋ athêŋ lôk êv leŋiŋmavi hadêŋ yani ami. Mi, iniŋ auk hi mayaliv ba êtôm ŋê molo ba intu momaŋiniŋ havaloŋ iniŋ auk molo êŋ loŋ denaŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Thêlô esoŋ nena thêlô ma ŋê lôkauk bêŋ ma doŋtom mi, thêlô lôkthô ibitak ŋê molo. ");
INSERT INTO hot_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ba intu miŋ êv yeŋ hadêŋ Wapômbêŋ lôkmaŋgiŋ atu ida hamô aêŋ ami. Mi, êv yeŋ hadêŋ dahô takatu ba epesaŋ hatôm ŋê pik takatu ba êmô vauna lôk menak ma alim lôk umya. ");
INSERT INTO hot_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Aêŋ ba Wapômbêŋ hatak thêlô ek nindum sek lôŋgôlôŋ lomaloma hatôm iniŋ thethaŋak habi alak ba intu thêlô êv mama hadêŋ thêlôda leŋviŋkupik. ");
INSERT INTO hot_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Thêlô êdô neja auk anôŋ esak Wapômbêŋ ba ethavuthiŋ hathak abôyaŋ. Ma êv yeŋ hadêŋ nôm takatu ba Wapômbêŋ hapesaŋ ba idum iniŋ ku, ma nômkama lôkthô anêŋ alaŋ atu ba hapesaŋ ma mi. Wapômbêŋ êŋ intu nambô wak nômbêŋ intu sapêŋ. Avanôŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Aêŋ ba Wapômbêŋ hatak thêlô ek nesopa iniŋ thethaŋak mama takêŋ. Ba intu iniŋ avi êdô auk mavi atu nêjêk imbiŋ anyô ma êwê hathak auk lokbaŋ. ");
INSERT INTO hot_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ma anyô aêŋ iyom êdô auk mavi nêjêk imbiŋ avi ba iniŋ thethaŋak haliŋ i ek nêndêŋ i. Ba intu idum nôm mama bêŋ hathak anyô yaŋ ba ewa kambom êŋ anêŋ vuli viyaŋ hathak thêlôda leŋviŋkupik. ");
INSERT INTO hot_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Thêlô êdô neyala Wapômbêŋ ba intu hatak i ek nesopa iniŋ auk ôvathek takêŋ ek nindum nôm takatu ba miŋ mavi ami. ");
INSERT INTO hot_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Thêlô kapôlôŋiŋ putup hathak kambom lomaloma lôk lokbaŋ ma paloŋ lôk leŋiŋdaŋ. Ma maleŋkilik lôk nijik anyô vônô ma nijik vovak ma abôyaŋ lôk ewa auk kambom hathak anyô vi. Ma etatale avômalô ");
INSERT INTO hot_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","lôk enaŋ abôma hathak anyô yaŋ. Ma êpôlik ek Wapômbêŋ, ma epek hathak avômalô vi, ma leŋiŋhabi nena thêlôda iyom intu mavi. Ma ethak ebam thêlôda, ma êbôlêm kambom lukmuk lomaloma ek nindum, ma miŋ êwê taluvi lo lami iniŋ abô vibiŋ ami. ");
INSERT INTO hot_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Thêlô ma ŋê auk mi, lôk miŋ esopa iniŋ abô ami, ma leŋiŋhaviŋ mi, lôk miŋ ethak êv kapôlôŋiŋ ami. ");
INSERT INTO hot_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Thêlô eyala abô thêthôŋ takatu ba Wapômbêŋ bôk hanaŋ nena ŋê takatu ba idum nôm takêŋ tem nêpôm ŋama. Ma doŋtom idum havôhi thêthô lôk leŋiŋmavi ek vi atu ba idum nôm takêŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Môlô doho lêk lemimhabi nena, “Avanôŋ biŋ, avômalô takêŋ ma ŋê kambom.” Ma doŋtom yahanaŋ nena môlô ma ŋê kambom aêŋ iyom ba intu môlô bônôŋ. Otatale thêlô ma hatôm otatale amda ek malê nena môlô udum hatôm atu ba thêlô idum. ");
INSERT INTO hot_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Wapômbêŋ halaŋô abô, êŋ ma hêv malaiŋ hadêŋ avômalô takatu ba idum kambom. Ma alalô ayala nena yani hayala nômkama sapêŋ ba intu anêŋ hadum abô ma thêthôŋ iyom. ");
INSERT INTO hot_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ma tem endaŋô iniŋ abô ba nêm malaiŋ êndêŋ i esak iniŋ kambom. Ma môlô udum kambom aêŋ iyom ba osoŋ nena tem miŋ endaŋô môlônim abô ba nêm malaiŋ êndêŋ môlô imbiŋ ami e? Mi. ");
INSERT INTO hot_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Wapômbêŋ hadum mavi anôŋ hathak alalô ba intu hamô maliŋyaô ba miŋ hêv kambom anêŋ vuli viyaŋ ketheŋ ami. Hosoŋ nena êŋ ma nôm oyaŋ e? Miŋ hoyala nena Wapômbêŋ hadum mavi êŋ ek hêv thalek hêk ek môlô node kapôlômim liliŋ ba nosopa yani ami e? ");
INSERT INTO hot_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ma doŋtom môlônim auk ma thekthek kambom ba miŋ ole kapôlômim liliŋ ami. Aêŋ ba môlô usup Wapômbêŋ anêŋ lamaniŋ hathak amda ba tem êpôm môlô êndêŋ anêŋ waklavôŋ endaŋô abô. Wak êŋ ma anêŋ lamaniŋ atu ba thêthôŋ tem êlêm yaiŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ma tem nêm anyô tomtom iniŋ vuli êtôm nôm takatu ba bôk idum. ");
INSERT INTO hot_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ŋê takatu ba idum mavi havôhi thêthô ek neja lôkmaŋgiŋ lôk athêŋ bêŋ ma lôkmala atu ba anêŋ daŋ mi ma Wapômbêŋ tem nêm lôkmala atu ba nêmô êtôm wak nômbêŋ intu sapêŋ êndêŋ i. ");
INSERT INTO hot_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ma doŋtom ŋê takatu ba idum paloŋ lôk êpôlik hathak abô avanôŋ ma idum kambom thêthô ma tem nêpôm Wapômbêŋ anêŋ lamaniŋ lôk vovaŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Avanôŋ biŋ, avômalô lôkthô atu ba idum kambom thêthô ma Wapômbêŋ tem nêm malaiŋ lôk vovaŋ êndêŋ i, avômalô Islael êmôŋ ma avômalô loŋ buyaŋ nembeŋ yam. ");
INSERT INTO hot_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ma doŋtom avômalô lôkthô atu ba idum mavi ma tem neja lôkmaŋgiŋ lôk athêŋ bêŋ ma kapôlôŋiŋ ênjêk yaô, avômalô Islael êmôŋ ma avômalô loŋ buyaŋ nembeŋ yam. ");
INSERT INTO hot_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ek malê nena Wapômbêŋ hadum kobom doŋtom hadêŋ avômalô lôkthô, avômalô Islael lôk avômalô loŋ buyaŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Avômalô loŋ buyaŋ idum kambom ma tem Wapômbêŋ indum abô ba nêm vovaŋ êndêŋ i. Thêlô miŋ eyala Mose anêŋ balabuŋ ami ba intu Wapômbêŋ tem miŋ enja balabuŋ êŋ ba indum abô ek i ami. Aêŋ iyom ma avômalô Islael idum kambom ma tem Wapômbêŋ indum abô ba nêm vovaŋ êndêŋ i. Thêlô eyala Mose anêŋ balabuŋ ba intu tem Wapômbêŋ enja balabuŋ êŋ ba indum abô ek i. ");
INSERT INTO hot_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ek malê nena ŋê takatu ba elaŋô abô balabuŋ ma miŋ êwê vibiŋ ami ma Wapômbêŋ miŋ halam i nena ŋê thêthôŋ ami. Mi, ŋê takatu ba êwê vibiŋ iyom, intu Wapômbêŋ halam i nena ŋê thêthôŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Avômalô loŋ buyaŋ miŋ eyala Mose anêŋ abô balabuŋ ami, ma doŋtom doho esopa abô balabuŋ êŋ vi hathak ida iniŋ leŋiŋhabi. Ba intu hik thô nena eyala malê atu ba mavi lo kambom. ");
INSERT INTO hot_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Aêŋ ba iniŋ kobom hik thô nena eyala Wapômbêŋ anêŋ balabuŋ hêk kapôlôŋiŋ. Ma wak doho ma iniŋ auk hanaŋ thêlôda bêŋ, ma wak doho ma iniŋ auk hanaŋ nena thêlô idum mavi. ");
INSERT INTO hot_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Nôm takêŋ tem imbitak êndêŋ waklavôŋ atu ba Wapômbêŋ hatak ek Yisu Kilisi endaŋô abô. Ma tem indum abô esak avômalô iniŋ auk loŋ kapô. Abô Mavi atu ba yahanaŋ intu hanaŋ aêŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Môlô vi olam am nena Islael. Môlô lemimhabi nena owa Mose anêŋ abô balabuŋ ba intu Wapômbêŋ tem enja môlô thô. Lôk obam am nena, “Yêlô ma Wapômbêŋ anêŋ avômalô.” ");
INSERT INTO hot_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ma Wapômbêŋ anêŋ abô bôk hadôŋ môlô ba intu oyala malêla takatu ba Wapômbêŋ lahaviŋ ma malêla takatu ba mavi anôŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","20","Ma môlô lemimhabi nena abô balabuŋ ma môlô unim ba oyala auk lôk abô avanôŋ sapêŋ. Ba intu lemimhabi nena hatôm nondom ŋê maleŋiŋ pusip lôk nônêm deda êndêŋ avômalô takatu ba êmô momaŋiniŋ lôk uŋgwik auk thô ek avômalô auk thôŋôthôŋ lôk auk pulusik e? ");
INSERT INTO hot_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Avanôŋ, ôdôŋ avômalô vi, ma aisê ka miŋ ôdôŋ amda ami? Ma onaŋ nena avômalô miŋ neja vani ami. Ma môlôda? ");
INSERT INTO hot_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ma onaŋ nena miŋ nindum sek imbiŋ anyô yaŋ yanavi ami, ma môlôda udum mena mi e? Ma ôdô ŋgôk, ma doŋtom owa iniŋ nômkama vani hayô iniŋ malak matheŋ e? ");
INSERT INTO hot_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ma obam am hathak abô balabuŋ ma doŋtom ômô lu êŋ ma hatôm otauviŋ Wapômbêŋ anêŋ athêŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Hatôm bôk eto nena, “Môlô Islael udum kambom ba intu avômalô loŋ buyaŋ enaŋ abôma hathak Wapômbêŋ anêŋ athêŋ.” ");
INSERT INTO hot_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Môlô osopa balabuŋ, êŋ ma tabô neŋgothe anyô iniŋ kupik ma nôm mavi. Ma doŋtom ômô balabuŋ lu, êŋ ma ubitak hatôm ŋê takatu ba miŋ eŋgothe iniŋ kupik ami. ");
INSERT INTO hot_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ma aêŋ iyom ma ŋê takatu ba miŋ eŋgothe iniŋ kupik ami ma doŋtom esopa balabuŋ, êŋ ma Wapômbêŋ tem ênjê i êtôm ŋê eŋgothe kupik haviŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Avanôŋ, môlô avômalô Islael owa Wapômbêŋ anêŋ kapya balabuŋ ba oŋgothe unim kupik vê. Ma doŋtom ômô balabuŋ lu ba avômalô loŋ buyaŋ takatu ba miŋ eŋgothe iniŋ kupik vê ami ma esopa abô balabuŋ tem nenaŋ môlônim kambom bêŋ. ");
INSERT INTO hot_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","29","Ôpatu ba habitak anêŋ Islael ba eŋgothe anêŋ kupik vê, ma doŋtom kapô lôk auk miŋ hamô haviŋ Wapômbêŋ ami, miŋ Islael anôŋ ami. Mi, Islael anôŋ ma ôpatu ba anêŋ kapô hamô haviŋ Wapômbêŋ. Ma tabô eŋgothe kupik anôŋ ma miŋ kupik viyaiŋ hatôm balabuŋ hanaŋ ami. Mi, tabô eŋgothe kupik anôŋ ma Lovak Matheŋ da haŋgothe tabô êŋ hêk anyô kapô. Ôpêŋ ma avômalô miŋ ebam ami. Mi, Wapômbêŋ da habam yani. ");
INSERT INTO hot_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Aêŋ ba malê mavi te intu hêk ek avômalô Islael? Ma eŋgothe kupik, ma malê mavi te tem êpôm i? ");
INSERT INTO hot_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Mavi lomaloma bêŋ anôŋ hêk! Nôm môŋ ma Wapômbêŋ bôk hêv anêŋ abô halôk thêlô baheŋiŋ ek neyabiŋ. ");
INSERT INTO hot_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ma doŋtom ŋê Islael doho miŋ êvhaviŋ ami. Ba intu nôm êŋ hatôm indum ba Wapômbêŋ etak anêŋ balabuŋ e? ");
INSERT INTO hot_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Mi anôŋ! Avômalô lôkthô ma avômalô abôyaŋ, ma doŋtom Wapômbêŋ da hanaŋ abô avanôŋ ba hasopa anêŋ abô iyom. Hatôm bôk eto nena, “Abô takatu ba honaŋ, ma tem nêgê nena abô avanôŋ iyom. Ma avômalô idum abô ek o, ma tem ômô i lu.” ");
INSERT INTO hot_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Yêlôaniŋ kambom hik Wapômbêŋ anêŋ thêthôŋ thô halêm yaiŋ. Aêŋ ba avômalô pik doho enaŋ nena, “Wapômbêŋ hik anêŋ lamaniŋ thô ba hêv vovaŋ viyaŋ hathak yêlôaniŋ kambom, êŋ ma hadum kambom.” ");
INSERT INTO hot_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Êŋ ma lokbaŋ! Wapômbêŋ miŋ thêthôŋ ami, ma tem indum abô thêthôŋ aisê esak avômalô pik sapêŋ? ");
INSERT INTO hot_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ma anyôla tem enaŋ nena, “Yenaŋ abôyaŋ hik thô nena Wapômbêŋ anêŋ abô ma avanôŋ ba nanêm athêŋ lôkmaŋgiŋ êndêŋ yani. Ma doŋtom, aisê ka Wapômbêŋ hayê ya nena anyô kambom ba hanaŋ ya bêŋ?” ");
INSERT INTO hot_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Abô êŋ ma hatôm abô kambom atu ba bôk doho enaŋ, “Alalô nandum kambom ek nôm mavi imbitak.” Ma avômalô doho esau nena yahanaŋ abô êŋ. Aêŋ ba malaiŋ takatu ba tem êpôm i ma thêthôŋ. ");
INSERT INTO hot_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Aêŋ ba alalô nanaŋ aisê? Avômalô Islael iyom intu mavi hêk Wapômbêŋ ma, ma avômalô loŋ buyaŋ ma mi e? Mi, bôk yahanaŋ yôv nena alalô lôkthô ma amô kambom vibiŋ, avômalô Islael lôk avômalô loŋ buyaŋ haviŋ. ");
INSERT INTO hot_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Hatôm bôk eto nena, “Anyô thêthôŋ la miŋ hamô ami. Mi anôŋ. ");
INSERT INTO hot_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ma anyô lôkauk mavi la miŋ hamô ami. Lôk anyôla miŋ habôlêm Wapômbêŋ ami. ");
INSERT INTO hot_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Avômalô lôkthô êvôliŋ dômiŋiŋ hadêŋ Wapômbêŋ ba intu ibitak êtôm nôm oyaŋ. Ma miŋ anyôla hadum mavi ami, milôk. ");
INSERT INTO hot_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Abô takatu ba hale thêlô veŋiŋbôlêk ma ôvpalê hatôm elav anyô ŋama iniŋ lôv abôlêk vê. Thêlô ethak enaŋ abôyaŋ bêŋ anôŋ hale veŋiŋbôlêk. Ma iniŋ abô hatôm umya kambom anêŋ siniŋ. ");
INSERT INTO hot_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Wak nômbêŋ intu ma thêlô enaŋ abôma lôk leŋiŋŋaŋa. ");
INSERT INTO hot_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ma elom eveŋ ek nijik anyô vônô. ");
INSERT INTO hot_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Loŋ takatu ba thêlô i, ma ibuliŋ avômalô ba êv malaiŋ hadêŋ i. ");
INSERT INTO hot_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ma êthôŋ bôk lo loŋ nêmô labali imbiŋ avômalô vi paliŋ. ");
INSERT INTO hot_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ma miŋ êkô dokte ek Wapômbêŋ ami.” ");
INSERT INTO hot_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Alalô bôk ayala yôv nena abô balabuŋ takêŋ ma hanaŋ hathak avômalô Islael takatu ba êmô balabuŋ vibiŋ. Ba intu avômalô Islael lôk avômalô pik sapêŋ bônôŋ iyom hathak Wapômbêŋ hanaŋ iniŋ kambom bêŋ. ");
INSERT INTO hot_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Aêŋ ba anyôla miŋ hatôm esopa balabuŋ ba imbitak thêthôŋ ênjêk Wapômbêŋ ma ami. Mi, balabuŋ hathak hik alalôaniŋ kambom thô hadêŋ alalôda. ");
INSERT INTO hot_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ma doŋtom lêk Wapômbêŋ hik loŋôndê yaŋda thô hadêŋ alalô ek nambitak thêthôŋ ênjêk yani ma. Ma Mose lôk plopet bôk enaŋ hathak loŋôndê êŋ yôv. Ma loŋôndê êŋ miŋ hanaŋ hathak nesopa balabuŋ ami. Mi. ");
INSERT INTO hot_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Loŋôndê êŋ ma aêntêk. Wapômbêŋ halam avômalô takatu ba êvhaviŋ Yisu Kilisi nena thêthôŋ. Avômalô Islael lôk avômalô loŋ buyaŋ sapêŋ ma imbitak thêthôŋ hathak loŋôndê doŋtom êŋ iyom. ");
INSERT INTO hot_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ek malê nena lôkthô idum kambom ba êv yak ba miŋ hatôm nêmô lôkmaŋgiŋ êtôm Wapômbêŋ ami. ");
INSERT INTO hot_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Aêŋ ba intu Wapômbêŋ habi anêŋ wapôm sam ba hapesaŋ loŋôndê ek avômalô nimbitak thêthôŋ. Hadum aêŋ hathak lôkmala atu ba Yisu Kilisi hêv ek hapole ŋê takatu ba êvhaviŋ iniŋ kambom anêŋ malaiŋ vê. ");
INSERT INTO hot_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Wapômbêŋ hatak Yisu Kilisi hêk avômalô maleŋiŋ ek ema ba eŋgasô anêŋ thalaleŋ êtôm da ek enja alalôaniŋ kambom anêŋ vovaŋ. Ba intu alalô aêvhaviŋ, êŋ ma Wapômbêŋ tem etak anêŋ lamaniŋ atu hathak alalô. Êŋ ma hik thô nena yani bôk hadum thêthôŋ hathak avômalô takatu ba bôk êmô hamôŋ vêm ka Kilisi hama hathak a. Thêlô idum kambom, ma miŋ hadum abô ketheŋ ek i ami. Mi, havaloŋ lôkthô iniŋ kambom loŋ aleba hatak hayô hamô Yisu iyom. ");
INSERT INTO hot_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ma lêk hik thô nena yanida ma thêthôŋ ba hapesaŋ loŋôndê ek halam avômalô takatu ba êvhaviŋ Yisu nena thêthôŋ