﻿USE sofia;
DROP TABLE IF EXISTS sofia.hopNT_vpl;
CREATE TABLE hopNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hopNT_vpl WRITE;
INSERT INTO hopNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","I’ tutuveni it Jesus Christ hakiy ahpiy sinotiqat tuawi’ta. Pam Abraham‐nit pu David pumuy amuhpiy aniwhti. ");
INSERT INTO hopNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ura Abraham Isaac náata; noqw pam Jacob náata; noqw pam Judas‐nit pu tupkomuyatuy pumuy náamu. ");
INSERT INTO hopNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Noqw Judas Phares‐nit pu Zarat pumuy náamu; (Thamar pumuy yúamu); noqw Phares Esrom náata; noqw pam Aram náata: ");
INSERT INTO hopNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Noqw pam Aminadab náata; noqw pam Naasson náata; noqw pam Salmon náata; ");
INSERT INTO hopNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Noqw pam Booz náata, (Rachab put yúata); noqw Booz Obed náata, (Ruth put yúata); noqw Obed Jesset náata. ");
INSERT INTO hopNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Noqw pam David it moṅwit náata; noqw pam Solomon náata, (hakiy Urias nȫmaatniṅwuqa put yúata). ");
INSERT INTO hopNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Noqw Solomon Roboam náata; noqw pam Abiat náata; noqw pam Asat náata. ");
INSERT INTO hopNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Noqw pam Josaphat náata; noqw pam Joram náata; noqw pam Ozias náata. ");
INSERT INTO hopNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Noqw pam Joatham náata; noqw pam Achaz náata; noqw pam Ezekias náata. ");
INSERT INTO hopNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Noqw pam Manasses náata; noqw pam Amon náata; noqw pam Josias náata. ");
INSERT INTO hopNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Noqw pam Jechonias‐nik̇aṅw pu tupkomuyatuy pumuy náamu, sinom Babylon aqw tsāmiwyaqat ephaqamo. ");
INSERT INTO hopNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Noqw pumuy Babylon aqw tsāmiwyaqw put atsva Salathiel tihtiwa. Pam hak Jechonias tíata. Noqw pam Zorobabel náata. ");
INSERT INTO hopNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Noqw pam Abiud náata; noqw pam Eliakim náata; noqw pam Azor náata. ");
INSERT INTO hopNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Noqw pam Sadoc náata; noqw pam Achim náata; noqw pam Eliud náata. ");
INSERT INTO hopNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Noqw pam Eleazar náata; noqw pam Matthan náata; noqw pam Jacob náata. ");
INSERT INTO hopNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Noqw pam Joseph náata. Noqw Joseph Maryt kōñaata. Noqw Maryt hapi ahpiy Jesus, Christ yan túṅwantiwhqa tihtiwa. ");
INSERT INTO hopNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Noqw ōviy Abraham aṅqw David aw pahsavo sohsoyam nānaṅk qatsívaptuyaqam pakwt nālöq sihk̇ay’tasikipwatya; noqw pu David aṅqw Babylon aqw tsāmiwyaqat aw pahsavo pakwt nālöq sihk̇ay’tasikip nānaṅk qatsívaptuya; noqw pu Babylon aqw tsāmiwyaqat aṅqw Christ aw pahsavo pakwt nālöq sihk̇ay’tasikip nānaṅk qatsívaptuya. ");
INSERT INTO hopNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Noqw yantaqat ahpiy Jesus Christ hapi tihtiwa: Put yuat Mary Joseph aw awiniwtaqw, nāt pumuy qa nāmatiqw, pam Qahováriwtaqat Hikwsit eṅem nö’yiwk̇aṅw mātaqti. ");
INSERT INTO hopNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Noqw put siwatwaat Joseph suan hintaqe, put nuhtutpik hamanhintsanniqey qa suhtaq’ewnihqe, pay as put turs nanauyve mātapniqey unaṅwti. ");
INSERT INTO hopNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Noqw nāt pam pan wūwank̇aṅw tūmoklawhq, meh, pi Tutuyqawhqat hoṅviayaat put aw mātaqtiqe, aw paṅqawu: Joseph, um David tíata, pay um qa nānaphin wūwantat, uhmantuway Maryt nāmi távini; pay put ahsonve aniwhtiqa Qahováriwtaqat Hikwsit eṅemi. ");
INSERT INTO hopNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Noqw pam tiyohyat tihtani; noqw um hapi put Jesus yan túṅwani, ispi pam sinomuy qaanhtipuyamuy aṅqw ayo óyaniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Ura Tutuyqawhqa lavay’ayay ahpiy yan lavayhti: Meh, nāt qanawhvalni’taqa māna nö’yiltini; nen tiyohyat tihtani. Noqw puma put Emmanuel yan tuṅwáyani, pam hapi Tutuyqawhqa itamuma, i’nihqe pam’i. Noqw īi yantaqa sohsoy yaniwhtiqw, i’ hisat lavaytiwhqa aw antsaniwa. ");
INSERT INTO hopNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pahsat pu Joseph tātayhqe, Tutuyqawhqat hoṅviayaat hin put aw tutaptaqat anhtiqe, mantuway nāmi távi; ");
INSERT INTO hopNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nihqe pas pam put qa aw hintsana, pas pam susmohti tiy tihtaniqat aw pahsavoo. Noqw pam tiyohyat tihtaqw, Joseph put Jesus yan tuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Noqw hak Moṅwi Herod moṅw’iwtaqw, Jesus Judea‐tutskwat ep Bethlehem‐kitsókit ep tihtiwa. Noqw meh, hakim pas wuwni’yuṅqam hōpahaqaqw Jerusalem ep ökihqe paṅqaqwa: ");
INSERT INTO hopNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ya Jew‐sinmuy amumi moṅw’iwtaniqe tihtiwhqa hak háqamo? Pi itam hōpaq sōhut put tuawi’taqat tutwaqe put hakiy aw naokiwlalwaniqe ōviy aṅqwya. ");
INSERT INTO hopNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Noqw Moṅwi Herod it navotqe tusitaqe pas hinhaqam unaṅway’ta, pu sohsoyam Jerusalem ep yesqam pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Noqw ōviy pam Tutuyqawhqat awwat mohpeq momṅwituy‐nik̇aṅw pu sinmuy amuṅaqw tutavot tūtutuqaynayaqamuy sohsokmuy tsovalaqe, haqam Christ tihtiwniqat pumuy tūviṅta. ");
INSERT INTO hopNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Noqw puma put aw paṅqaqwa: Judeat ep Bethlehem ep’e; pi Tutuyqawhqat lavay’ayaat yan pēna: ");
INSERT INTO hopNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Pu úmaa, uma Judat‐tutskwat ep Bethlehem‐kitsókit ep sínomu, pas uma Judat ep pavansinmuy amuṅaqw qa hin’eway’omu; pi umuṅaqw hak moṅw’iwtaniqa wunuptuni; nen pam isinomuy amumi tunatyawmani, Israel‐sinmuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pahsat pu Herod pumuy hakimuy pas wuwni’yuṅqamuy nanauyve wáṅwayhqe, hisatniqw sōhu mātaqtiqat pumuy pās tūviṅta, ");
INSERT INTO hopNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nit pumuy Bethlehem aw hōnaqe amumi paṅqawu: Uma awye’, tsākw pās hepyani, nen ason uma tutwe’ aṅqw nuy āawnawisni; noqw nu tuwat awnen put pas hihtatani. ");
INSERT INTO hopNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Noqw puma moṅwit aṅqw yan nanaptat ahpiyya; noqw meh, ura sōhu hōpaq pumuy amumi mātaqtiqa pumuy amupyeve hinmaqe, haqam tiyohyat qátuhqat aw pítuhqe atsve huruhti. ");
INSERT INTO hopNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Noqw puma sōhut tutwaqe, pas hinhaqam hahlayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Noqw puma kīhut aw yuṅqe, pep tiyohyat yuyat Maryt enaṅ tutwa; nihqe puma tiyohyat atpipo tamötshoṅvat pas hihtatota; nit pu hihta eṅem hinvayaqey aṅ hötahtotaqe, put hihta huytota, sik̇avalasivata, pu frankincense, nit pu myrrh. ");
INSERT INTO hopNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Noqw pay puma Herod aw qa áhoyyaniqey God aṅqw tumoknanaptaqe, pay pas háqe’wat ahoy tutskway aqwya. ");
INSERT INTO hopNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Noqw pumuy ahpiyyaqw, pi meh, Joseph tūmoklawhq, Tutuyqawhqat hoṅviayaat put aw mātaqtiqe aw paṅqawu: Meh, Herod tiyohyat pās hepni, put nīnaniqee. Noqw ōviy um qatuptut, tiyohyat, yuyat enaṅ wikk̇aṅw, Egypt‐tutskwat aqw wāyani; nen pas ason nu hisat uṅ hin āawnaniqat pahsavo um hāk pepeq qátuni. ");
INSERT INTO hopNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Noqw ōviy pam qatuptut, tiyohyat yuyat enaṅ wikk̇aṅw, míhikpuva Egypt aqw’a; ");
INSERT INTO hopNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nihqe pas ason hisat Herod mokqat aw pahsavo pam pepeq qatu. Ura Tutuyqawhqa lavay’ayay ahpiy yan lavayhti: Nu Egypt aqw itiy wáṅwayi. Noqw yan hapi i’ hisat lavayhtiwhqa aw antsaniwa. ");
INSERT INTO hopNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Noqw ima a’nö wuwni’yuṅqam ahpiyyaqw, Herod māmatsq kurs puma paysoq put yūyuyhnaya. Noqw ōviy pas pam a’nö itsívutiqe, hakimuy hōnaqe, puma totimhoymuy Bethlehem ep yesqamuy sohsokmuy qöqyaniqat ayata, pu ahsupoq qalava yesqamuyu, lȫq yahsaṅwni’yuṅqamuy ahpiy nāt tsātsakwmuy aqw pahsavoo. Ura pam pas wuwni’yuṅqamuy pās tūviṅtaqe hisat paniwhtiqat navotqey put ahpiy panhti. ");
INSERT INTO hopNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pahsat pu Tutuyqawhqat lavay’ayaat Jeremy hin lavayhtiqat aw antsaniwa; ura paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramat ep hakiy tönaat nanaptiwa; hak paktöqnuma, a’nö paknuma, pas pavan hinhtiqey pan paknuma. Rachel timuy ōviy paknumqe, pas qa okniqey nāwakna, puma súlawhtiqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Noqw ason hisat Herod mokq, meh, Joseph Egypt epeq tūmoklawhq, Tutuyqawhqat hoṅviayaat put aw mātaqtiqe aw paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Um qatuptut tiyohyat, yuyat enaṅ wikk̇aṅw, Israel‐sinmuy tutskwayamuy aqw áhoyni; pay put nīnayaniqey anyuṅqam qa yēse. ");
INSERT INTO hopNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Noqw pahsat pu pam qatuptut, tiyohyat yuyat enaṅ wikk̇aṅw, Israel‐sinmuy tutskwayamuy aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Noqw yaw Archelaus nay Herod qeniyat ep Judeat aw moṅw’iwtaqat pam navotqe, paṅsoniqey tusita; nit pay pam God aṅqw tumoknavotqe, Galileet ep haqamiwat aw lahsi. ");
INSERT INTO hopNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nihqe pam pep pítuhqe kitsókit Nazareth yan mātsiwhqat ep qatuptu. Yan Tutuyqawhqat lavay’aymat hin lavayhtotiqat aw anhti; ura paṅqaqwa: Pam Nazareth‐sino yan túṅwantiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Noqw ephaqam hak tāqa John yan mātsiwhqa sinmuy kūyit akw tuvoylalawhqa Judeat ep qayēsiwhpuve yuaataqe, ");
INSERT INTO hopNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Paṅqawlawu: Uma nāp umuhtunatyay aṅqw lasyani; taq ōveqatsit aṅqw moṅwtunatya aw hayhk̇alti. ");
INSERT INTO hopNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ura Tutuyqawhqat lavay’ayaat Esaias yan lavayhti: Hakiy tönaat qayēsiwhpuve tsa’tinumqa navotniwa; nihqe yan lalvaya: Uma Tutuyqawhqat eṅem pöhut aw hintsatsnani, pam háqe’niqat aw suwiptotani. Noqw John ep i’ hisatlavayhtiwhqa aw antsaniwa. ");
INSERT INTO hopNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Noqw i’ John hihta pohkot pȫlay’taqat pöhöyat aṅqw yukiwtaqat yuwsi’k̇aṅw, kolāsat kwewta; noqw pam mātuy tūmoyta; pu piw haqam mōmohtuy tsāme’, momospalayamuy enaṅ tūmoytaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pahsat pu Jerusalem aṅqw sinom put aw ökiwta, noqw pu Judeat sohsovik aṅq’ö, pu ahsupoq tutskwat pāyut Jordan nöyakiwtaqat aṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nihqe qaanhtipuy nahostotat, John ahpiy pāyut Jordan aqw kūyit akw tuvoylatoti. ");
INSERT INTO hopNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Noqw k̇aysiwhqam Pharisee‐sinom‐niqw, pu Sadducee‐sinom put ahpiy kūyit akw tuvoylatotiniqe ep ökiqw, pam pumuy túwahqe amumi paṅqawu: Is úmaa! Ya uma hinoqw tsūtsu’tuy amún itsívut nātoniqat aṅqw watqa? Ya hak umuy āawna? ");
INSERT INTO hopNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kurs uma pas antsa nāp umuhtunatyay aṅqw lasye’, uma alöṅöt qatsit ahpiy tutmalat hintsatsk̇ani. ");
INSERT INTO hopNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pu uma qa pan wūwank̇ahk̇aṅw, umuh’unaṅwpeq paṅqaqwani: Abraham hapi itanaa, kitotani. Taq nu umumi paṅqawni: God it o’wat aṅqw Abraham eṅem sinmuy aniwnaniqey tuwi’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Noqw pay hapi pik̇aiṅwa himutsotskit ṅayat tsahqaniqey na’sas’iwta; noqw ōviy himuwa tsoki lomasipalat qa himuy’vaṅwuqa tsaqniwe’ qȫhit aqw tūviwni. ");
INSERT INTO hopNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Pay as pi pas antsa nu umuy kūyit akw tuvoylalawu; uma nāp umuhtunatyay aṅqw lasyaqat tuawi’taniqee. Nīk̇aṅw aṅqw inuṅknihqa inuhpenihqe pas pavan öqala; noqw soon nu yan’ewaynīk̇aṅw put tōtsiyat yawmani; ason pam Qahováriwtaqat Hikwsit akw umuy tuvoylalawni, pu qȫhit akw’a. ");
INSERT INTO hopNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pam wuhihpiy yawta, nihqe murivihk̇ay ep pās wuwhini; nen söhövosit koyohtani; nīk̇aṅw pam qȫhit pas qa tokniqat akw tsihput taqtsokni. ");
INSERT INTO hopNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Noqw pahsat pu Jesus John ahpiy kūyit akw tuvoylatiniqe Galileet aṅqw Jordan aw pitu. ");
INSERT INTO hopNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Noqw John put qa nakwhanaqe aw paṅqawu: Soon as qa nu uhpiy kūyit akw tuvoylatiwni. Noqw piw kurs um aṅqaqw inumii? ");
INSERT INTO hopNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Noqw pay Jesus lavayhtiqe put aw paṅqawu: Pay soon tis qa pantani; itam pan hapi God tunatyayat aṅ ahsupoq aw antsanni. Noqw pahsat pu pam put nakwhana. ");
INSERT INTO hopNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Noqw Jesus kūyit akw tuvoylatiwht, pahsat pay pāṅaqw yama; noqw meh, tokpela hötsíltiqw, God Hikwsiat höwit antaqa aṅqw hawhqe, put atsmi tsokiltiqw, pam aw yori. ");
INSERT INTO hopNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Noqw meh, hakiy tönaat ōṅaqw paṅqawu: I’ hapi pas aw iunaṅwa Itii; it nu pas hahlayi. ");
INSERT INTO hopNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pahsat pu Qahováriwtaqa Hikwsi qayēsiwhpumi haqami Jesus wīki, Nukpanat ahpiy aw unaheviwniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Noqw pam lȫp sunát‐sikis talöṅvaqat pu tōkilat aṅ qa nösqe, put atsve tsöṅmoki. ");
INSERT INTO hopNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Noqw Unatwi’taqa put aw pítuhqe aw paṅqawu: Kurs um pas antsa God Tíatnen um it o’wat pölavikiniwhtiniqat aw paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Noqw pam lavayhtiqe put aw paṅqawu: Sóoni, pi ura yan pey’ta: Sino qa pölavikit‐sa akw qátut, sohsok lavayit God moaṅaqw nȫṅantaqat akw qátuni. ");
INSERT INTO hopNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pahsat pu Nukpana pas āantsawat kitsókit aqw ōmiq Jesus wikqe, God kīyat ep suswupakits’omiq put tsok̇a, ");
INSERT INTO hopNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nit aw paṅqawu: Kurs um pas antsa God Tíatnen um atk̇amiq tsóokni; pi ura yan pey’ta: Pam hoṅviaymuy ayataqw ūmi tunatyaltotini. Nen puma may akw uṅ hölölni’yuṅwni, taq k̇a um owat aqw uhkukuy sáviknani. ");
INSERT INTO hopNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Noqw Jesus put aw paṅqawu: Sóoni, pi ura yan pey’ta: Um God Uhtutuyqawhqay aw qa tuwanlawni. ");
INSERT INTO hopNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pu piw Nukpana haqami pas wupatukwit aqw put wīki; nihqe tūwaqatsit aṅ ahsupoq moṅwqeqnit, piw put aṅ hihta susnukṅwat put aw mahtakna; ");
INSERT INTO hopNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nihqe put aw paṅqawu: Iit sohsok nu ūmi nóani, um inutpipo tamötswunuptut, inumi naokiwhtaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pahsat pu Jesus put aw paṅqawu: Sóoni, yupa Satan, pi yan pey’ta: Um Uhtutuyqawhqay God aw naokiwlawni, pu um put‐sa eṅem tumalay’tani. ");
INSERT INTO hopNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pahsat pu Nukpana put mātavi; noqw meh, ōṅaqw hoṅvia’yam put aw ökihqe aw unaṅwtapya. ");
INSERT INTO hopNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Noqw yaw John sivikimi panayaqw Jesus navotqe paṅqw Galileet aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nihqe pam Nazareth‐kitsókit aṅqw ahpiynihqe Capernaum‐kitsókit ep pítuhqe pep huruhti. Pam kitsóki wuhkovatuphat qalaveq’a, Zabulon‐nik̇aṅw pu Nephthalim pumuy tutskwayamuy qalavoo. ");
INSERT INTO hopNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yan Tutuyqawhqat lavay’ayaat Esaias hin lavayhtiqat aw anhti; ura paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zebulon tutskwayat pu Nephthalim tutskwayat wuhkovatuphat aqw pihk̇at pāyut Jordan yupqöyve qa‐Jew‐sinmuy tutskwayamuy Galileet ep ");
INSERT INTO hopNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hakim sinom qatalpuve yesqam qaan’ewakw tālat tutwa; noqw mokiwuy qalava, pu kihsiwniyat aṅ yesqamuy amumi tālawva. ");
INSERT INTO hopNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pahpiy haqahpiy pu’ Jesus nuhtumi yuaativaqe paṅqawlawu: Uma nāp umuhtunatyay aṅqw lasyani, taq ōveqatsit aṅqw moṅwtunatya aw hayhk̇alti. ");
INSERT INTO hopNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Noqw Jesus wuhkovatuphat Galilee yan túṅwantiwhqat qalavaqe hinmak̇aṅw, hakimuy lȫqmuy nātupkomuy tuwa, hakiy Simon, Peter yan piw túṅwantiwhqat‐nik̇aṅw, pu tupkoyat Andrew púmuyu. Puma pakiwmaqtutsayat pāmiq pahpana, puma pakiwmahk̇atnihqey akw qátuhqee. ");
INSERT INTO hopNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nihqe pam pumuy amumi paṅqawu: Uma inuṅk hinmani. Noqw nu umuy tutuwnaqw, uma sinmuy kwihkwisnani, uma pāvakiwhtuy hin kwihkwisnaqey pan’i. ");
INSERT INTO hopNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Noqw pahsat pay puma tutsayay tatamhtat, put aṅki. ");
INSERT INTO hopNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pu pam pahpiynik̇aṅw, piw hakimuy lȫqmuy nātupkomuy tuwa, hakiy Zebedeet tímuyatuyu, hakiy James‐nik̇aṅw pu tupkoyat John púmuyu; puma nay Zebedeet amum pākihut aṅqw pakiwk̇aṅw, pakiwmaqtutsayay aw yuyku; noqw pam pumuy wáṅwayi. ");
INSERT INTO hopNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Noqw pahsat pay puma pākihut nay enaṅ mātapt, put aṅki. ");
INSERT INTO hopNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Noqw Jesus tutskwat‐Galileet aṅ ahsupoq waynumqe, tsotsvalkiyamuy aṅ sinmuy tutuqaynatinuma; nihqe lomatuawit moṅwtunatyat yuaataqat nuhtumi yuaatinumk̇aṅw, sinmuy amuhpa’ sohsokmuy hihta akw ȫpuiwyuṅqamuy, pu tūtuyyaqamuy qalaptsintima. ");
INSERT INTO hopNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Noqw put ahpiy pam ahsupoq Syriat aṅ nanaptiwa. Noqw puma sohsokmuy hihta tūyat akw ȫpuiwyuṅqamuy, pu k̇ānavoti’yuṅqamuy put aw tsamvanta, pu hakimuy nukpanhihikwsimuy akw tuyqawiwyuṅqamuyu, pu homimitutuyyaqamuyu, pu amuhpa’ qatāyuṅqamuyu; noqw pam pumuy qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Noqw qaan’ewakw hintaqam sinom Galileet aṅqw put aṅk hinnumya, pu Decapolis aṅq’ö, pu Jerusalem aṅq’ö, pu Judeat aṅq’ö, pu Jordan yupqöyṅaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Noqw pam qaan’ewakw hintaqamuy sinmuy amumi yórikqe, tsomomiq wupqe, epeq qatuptuqw, put aw nánatuwnayaqam put aw öki. ");
INSERT INTO hopNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Noqw pam lavayhtiqe, pumuy tutuqaynativaqe, amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Aṅ okiw’unaṅway’yuṅqam hahlayhpit epya; pi puma hapi ōveqatsit ep moṅwtunatyat himuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pas aṅ tsaykitaqam hahlayhpit epya; pi puma okyani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aṅ pasi’naṅway’yuṅqam pas hahlayhpit epya; pi puma tūwaqatsit makiway’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aṅ suan hinwisniqey tuṅlay’yuṅqam, hak nȫsiwhqat, pu kūyit hin tuṅlay’taqat pan suan hinwisniqey tunatyawyuṅqam pas hahlayhpit epya; pi puma tunatyay aw yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aṅ nun’okwat hahlayhpit epya; pi God pumuy ōkwatuwni. ");
INSERT INTO hopNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aṅ suan unaṅway’yuṅqam hahlayhpit epya; pi puma God aw yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aṅ namivöhikit tumalay’yuṅqam hahlayhpit epya; pi puma God tímatnihqey pan túṅwantiwyani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aṅ suan hinwisqey ep okiwsahsanwaqam hahlayhpit epya; pi puma hapi ōveqatsit aṅqw moṅwtunatyat himuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Sinom inutsviy umumiq hīhiṅqaqwak̇ahk̇aṅw, umuy okiwsahsanyak̇aṅw, sohsok hīhihta qalolmat umuy atsátotoynayaqw, uma hahlayhpit epyani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Uma hahlayhtote’ pas hinhaqam hahlayyani; ispi uma ōveqatsit ep qaan’ewakw ahsatit makiwyaniqee; pi pay puma Tutuyqawhqat lavay’aymuyatuy umupyeveyaqamuy pan okiwsasna. ");
INSERT INTO hopNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Uma hapi tūwaqatsit ep ȫṅat anyuṅwa. Nīk̇aṅw pi ȫṅa suhuviwe’, sen hihta akw piw suhutiwni? Pi pam pāpu qa hihta ápiynihqe maspiwhq, sinom aw wukukuykuyani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Uma hapi sinmuy amumi tālat anyuṅwa. Tsomoveq kitsóki wúnuhqa kurs hin tupkiltiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ya sen sinom wihqöhit úwiknaye’, hihta sīvut akw put kuhtayaṅwu? Qae. Puma put tsotsókpiyat epeq tsok̇ayaqw, pam kīve yesqamuy sohsokmuy amumi talni’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Noqw pan hapi uma sinmuy amumi talni’yuṅwni; noqw puma umuhtutmalay lolmat aw tāyuṅwe’, ōveqatsit ep Umunay pas hihtatotani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Uma qa yan inumi wūwayani: Pam k̇a tutavot piw Tutuyqawhqat lavay’aymuyatuy lavayiyamuy ayo yúkuniqe ōviy pitu. Nu qa paniqw ōviy pitu; pi nu put aw antsanniqe ōviy pitu. ");
INSERT INTO hopNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nu hapi umumi pas súaṅqawni: Pay tokpela, pu tūwaqatsit nātoniqw, soon tutavot ep hihsay tsohkokpu alöṅtini; soon sushihsay pey’taqa put aṅqw súlawhtini, pas aṅ ahsupoq tunatyaat aw antsaniwniqat aw pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Paniqw hapi ōviy hak haqam it tutavot ep hihta sushihsakwhoyat ayo yukut, pan tūtutuqaynaqa ōveqatsit aṅqw moṅwtunatyat ep susqahimunihqey pan túṅwantiwni; pu hak haqam put an hinmaqa pan tūtutuqaynaqa hapi ōveqatsit ep moṅwtunatyat ep pas pávannihqey pan túṅwantiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pas uma soon qa imuy tutavot tutuqaynayaqamuy‐nik̇aṅw pu Pharisee‐sinmuy, pumuy amuhpenihqe pavan suan hinwisni. Uma qa panwise’, pas soon ōveqatsit ep moṅwtunatyat aw yuṅni. ");
INSERT INTO hopNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Uma nanaptaqw ura hisatsinom yan lavayhtoti: Um qa hakiy nīnani, kitota; pu hakiy nīnaqa hin yukuniwniqey aw unahinhtimantani, kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Noqw nu’ hapi umumi paṅqawni: Hakiy sinoat hakiy ehpewi qa hihta ep qaanhtiqw, hak put ep itsívuiwtaqa hapi hin yukuniwniqey aw unahinhtimantani; pu hak sinoy pas qa hihtataqa nawus moṅwtsovawtaqamuy amumi taviwmantani; pu hak haqam Um núanhimuu, hakiy aw kitahqa maskiveq qȫhit sivihpit aqw unahinhtimantani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Paniqw ōviy kurs um hom’oyvihk̇at ep uhkuwahtipuy kwusivat, ura uhsino ūmi hihta ep unaṅway’taqat u’ne’, ");
INSERT INTO hopNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Um pep uhkuwahtipuy mātapt, ahpiynen, put amum namivöhikt, pu’ pahsat awnen, uhkuwahtipuy távimantani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Um uhpew’iwtaqat īts amum namivöhikmantani, nāt amum aqwnik̇aṅwo; taq nāp hisat sen pam hakiy hin yukunaṅwuqat aw uṅ mātapq, pam uṅ solāwat aw noaqw, pam uṅ sivivanani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nu umumi pas antsa paṅqawni: Pas um soon paṅqw yámakni, pas ason um hisat uhpöiy sohsok ep sisve’, pep pu’ paṅqw yámakni. ");
INSERT INTO hopNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Uma nanaptaqw ura hisatsinom yan lavayhtoti: Um hakiy qa nāp uhhimuy qa kwaṅwáy’ni ");
INSERT INTO hopNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Noqw nu’ hapi umumi paṅqawni: Wuhtit aw nuvö’tay’taqa hapi pay unaṅwpeq put kwaṅwáy’ṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Noqw ōviy kurs putvaqwat uhposi uṅ qalomáhintsanqw um put hóroknat nahpiy tūvani. Pay pi tatam uhposi súlawhtiqw, um pank̇aṅw ōveqatsit aṅqw moṅwtunatyat aw pákini, hikis pi as um uhtokoy pasiwk̇aṅw qȫhit sivihpit aqw tūviwni. ");
INSERT INTO hopNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pu kurs putvaqwat uhma uṅ qalomáhintsanqw, um put ayo tuk̇e’ nahpiy tūvani. Pay pi tatam uhma súlawhtiqw, um pank̇aṅw ōveqatsit aṅqw moṅwtunatyat aw pákini, hikis pi as um uhtokoy pasiwk̇aṅw qȫhit sivihpit aqw tūviwni. ");
INSERT INTO hopNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Pu ura piw paṅqaqwa: Nȫmay mātapniqa pan tutuvenyukit put máqamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Noqw nu’ hapi umumi paṅqawni: Hak wuhti tokoy qa hovalaqw, put kōñaat put mātave’, pay yoñayqatsit aw put mātapṅwu. Noqw hak tāqa put ámumtiqa pay tokot sokoptaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Pu uma piw nanaptaqw ura hisatsinom yan lavayhtoti: Um hihta lavayvasiwne’, put qa atsátamantani; pu um Tutuyqawhqat aw lavayvasiwne’, put anhtini, kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Noqw nu hapi umumi paṅqawni: Uma hihta lavayvasiwnaye’ qa hihta akw put öqaltoynayani. Uma qa ōveqatsit akw öqallavayhtotini, taq pam God moṅw’atsvewaata. ");
INSERT INTO hopNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Pu piw qa tūwaqatsit akw’a, taq pam put wuwukpiata, pu piw qa Jerusalem akw’a, taq pam a’nö Moṅwit wuhkokitsokiata. ");
INSERT INTO hopNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Piw um qa uhqötöy akw uhlavayiy pavan öqalat pasiwnamantani, taq um soon sūkw hȫmit qȫtsatani, piw qömvitani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nīk̇aṅw uma pay Owi, kitotani, sen Qae. Nen uma hin lavayhtote’ panhtotimantani. Taq öqallavayi Nukpanat ahpiy nȫṅanta. ");
INSERT INTO hopNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Uma nanaptaqw ura hisatsinom yan lavayhtoti: Hak hakiy pōsiyat tūhote’, nawus pam pōsiy akw put ep aw ahoytamantani; pu hak hakiy tamayat tūve’, nawus tamay akw put ep aw ahoytamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Noqw nu’ hapi umumi paṅqawni: Uma hakiy qalolmat aw qa rohomtotimantani; nīk̇aṅw nāphaqawa putvaqwat uhtayway wuvahtaqw, pay um piw ayaṅqwat put aw namtöknamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pu kurs haqawa tutavot aw yank̇aṅw uhnapnay himtaqw, pay um piw aw uh’usimniy mātapmantani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Noqw kurs solāwa mōkiy uṅ īkwiltoynat, um sūkw tutskwatuwanit put ámumniqat uṅ tusoq’ayataqw, um lȫq tutskwatuwanit pahsavo put ámumni. ");
INSERT INTO hopNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hak ūmi hihta tūviṅtaqw um put máqamantani; pu hak ūmi hihta nasimok̇ahtaniqat um nasimokmaqani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Uma nanaptaqw ura yan lavayhtotiwa: Um uhsinosṅway aw unaṅway’tani, pu um uhtuwqay aw qa suhtaq’ewni, kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Noqw nu’ hapi umumi paṅqawni: Uma umuhtuwqamuy amumi unaṅway’yuṅwni; umuy qalomásavitotaqamuy uma amumi lomalvayhtotimantani; umumi qa suhtaq’ewyaqamuy uma amumi lolmat hintsatsk̇ani; pu umuy qalomáhintsahtsanyaqamuy, pu umuy okiwsahsanyaqamuy amuṅem uma nāwakintotani. ");
INSERT INTO hopNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nen uma kurs pas antsa Umunay ōveqatsit ep qátuhqat tímatni; pi pam aṅ qalōlolmatuy‐nik̇aṅw pu lōlolmatuy amuṅem tāwat yámaknaṅwu; pu súanyuṅqamuy‐nik̇aṅw pu qasuanyuṅqamuy amumi yoknaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ispi uma umumi unaṅway’yuṅqamuy‐sa amumi unaṅway’yuṅwe’ ya uma hihta ahsati’yuṅwni? Ya hikis pi moṅwit eṅem sīvat ömalalwaqam qa panyuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pu kurs uma umuhsinomuy‐sa amumi yuaatote’ ya uma mimuy amuhpenihqe hihta alöṅöt hintsatsk̇ani? Ya hikis pi moṅwit eṅem sīvat ömalalwaqam qa panyuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Paniqw ōviy uma pās pasiwyuṅwni, ōveqatsit ep Umuna pās pasiwtaqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Uma tunatyaltotini. Sinom umuy tsok̇anayaniqat uma qa tuṅlay’k̇ahk̇aṅw, hakiy hihta akw ōkwatuwyamantani. Uma panyuṅwe’ Umunay ōveqatsit ep qátuhqat ahpiy soon hihta ahsati’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Uma navoti’yuṅqw imuy pavansinmuy amuṅaqw haqawat yantsatsk̇a: Himuwa hakiy hihta akw ōkwatuwnik, aṅwu pay nāpyeve hakiy ayataqw, pam ahsavo tsotsvalkive, pu kihsonve put tunvotnaṅwu. Puma pay nawip’ew hintsatsk̇a; puma pay sinmuy amuṅaqw tayawinpit tuṅlay’yuṅwa. Noqw uma qa amún hintsatsk̇ani. Taq nu umumi pas súaṅqawni: Puma pay ahsatiy ömahtota. ");
INSERT INTO hopNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Uma qa panyuṅwt nanauyve hihta kuwahtotimantani. Uma haqawa hakiy hihta akw ōkwatuwnik hikis pas aw uh’unaṅway uhkwatsiy qa āawnani. Noqw Una sohsok hihta qamātaqpuvenihqat tuway’taqa pas nāp uṅ nuhtutpik tuwat tayawnamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Pu um ōveqatsit ep Unay aw nāwakne’ imuy nawip’ew hinyuṅqamuy qa amúntamantani; soq sinom pumuy amumi tāyuṅwniqat ōviy puma tsotsvalkiva, pu kitpik tūtuyqava hoṅk̇ahk̇aṅw okiwlalwaniqey pas nānawakna. Nu umumi pas antsa paṅqawni: Pay puma ahsatiy ömahtota. ");
INSERT INTO hopNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ason um tuwat nāwakne’ haqami uh’ahpaviy aw pakit, naṅk uhtat, pahsat um Unay qamātaqpuvenihqat aw nāwaknamantani; noqw Una sohsok hihta qamātaqpuvenihqat tuway’taqa uṅ nuhtutpik hihta akw tayawnamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nīk̇aṅw uma nānawakne’, aṅ qatuptsiwni’yuṅqamuy qa amún paysoq pūvut‐sa yuaatotani; taq puma yan wūwantota: Itam qatsá’ lavayhtotiqw, suyan pi God itamuy hu’wani. ");
INSERT INTO hopNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Paniqw ōviy uma pumuy qa amunyuṅwni, pi pay Umuna umuy hihta haqni’yuṅqw put navoti’taṅwu nāt umuy aw qa tūviṅtotaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Noqw ōviy uma yan nānawaknamantani: Itanaa, ōveqatsit ep qátuhqa, nam uhnatṅwani pas k̇aptsi’tiwaa. ");
INSERT INTO hopNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nam uhmoṅwtunatyay aw pituu; nam uhtunatya tūwaqatsit ep aniwhtii, ōveqatsit ep hin aniwhtiqey pan’i. ");
INSERT INTO hopNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Um okiw pu’ talöṅvaqat ep itamuy itahtunösmakiway huytani. ");
INSERT INTO hopNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pu um okiw itahpöiy itamuhpiy ayo yúkuni, itam itamumi pöiwyuṅqamuy amuhpiy put ayo yuki’wisqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pu okiw um itamuy unaheppit qa aṅ tsāmi’mat, hakiy qalolmat aṅqw itamuy ayo ōoyhtimani. Pi um hapi pas Móṅwinihqe öqalay’ta. Um‐sa lolmat tālawṅway’ta, sutsép‐sa aqwhaqamii. Nam antani. ");
INSERT INTO hopNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pi hakim umuhpewi qaanhtotiqw, uma put ep pö́hikyaqw, pep pu’ ōveqatsit ep Umuna tuwat umuhqaanhtipuy umuhpiy ayo yukut, umumi pö́hikni. ");
INSERT INTO hopNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nīk̇aṅw kurs uma pumuy amumi qa pö́hikyaqw, pep pu’ ōveqatsit ep Umuna tuwat umumi qa pö́hikni. ");
INSERT INTO hopNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Pu ōviy piw uma nānapwale’, uma nawip’ew hinyuṅqamuy qa amún hinyuṅwni; taq puma qahahlayyaqey pan pitsáṅway’yuṅwniqe ōviy tayway nukushintsanyaṅwu; noqw sinom sohsoyam pumuy nānapwalaqat nanaptaṅwu. Nu umumi pas antsa paṅqawni: Pay puma ahsatiy ömahtota. ");
INSERT INTO hopNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pu um’i, um napwale’, uhqötöy wihkuyit akw lelwimantani, pu posimavaqtamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Noqw pep pu’ um napwalaqat sinom qa nanaptaqw, Una qamātaqpuvenihqa put navoti’tani; noqw Una sohsok hihta qamātaqpuvenihqat tuway’taqa uṅ nuhtutpik tayawnamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Uma yep qatsit ep nenṅem hihta qa k̇ahaktaṅalalwani; yep kwahkwahyam pu hihta sik̇aṅputaṅwuqa hihta hovalaṅwu, pu uuyiṅwt hötaye’, hihta ūuyyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Uma qa panyuṅwt, ōveqatsit ep nenṅem hihta k̇ahaktaṅalalwani; pep kwahya pu hihta sik̇aṅputaṅwuqa hihta qa hovalaṅwu, piw uuyiṅwt qa hötayaṅwu, piw hihta qa ūuyyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pi hakiy k̇ahakhimuat háqamniqw hakiy unaṅwaat piw pepniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Hakiy pōsiat hakiy aw talni’taṅwu. Noqw ōviy kurs hakiy pōsiat pasiwtaqw, pay tokoyat aṅ ahsupoq talni. ");
INSERT INTO hopNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nīk̇aṅw kurs hakiy pōsiat qa pasiwtaqw pay tokoyat aṅ ahsupoq qatalni; noqw ōviy kurs tāla uhsonvenihqa súlawuqw, is uti pas qatālani. ");
INSERT INTO hopNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Soon hak haqam lȫqmuy móṅwituy amuṅem tumalay’tani; ispi soon pam qa sukwat aw pay qa yan unaṅway’k̇aṅw sukwat‐sa pas hahlayni; sen pay hihtawat‐sa aw pas yuki’k̇aṅw pu sukwat pay qa himuni. Kurs hin uma k̇āhakiwuy ōviy tumalay’k̇ahk̇aṅw, piw God eṅem tumalay’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Paniqw ōviy nu umumi paṅqawni: Uma hin yesniqey qa nānaphin wūwantotani, hihta nȫnösaniqeyu, pu hihta hikwyaniqeyu, pu piw umuhtokoy éṅem’i, hihta yuwsiyaniqeyu. Puyaw hakiy qatsíat nȫsiwhqat epnihqe qa pavan pas hímuu? Pu hakiy tokoat yuwsit epnihqe qa pavan pas hímuu? ");
INSERT INTO hopNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Uma súmawuy aṅ masay’yuṅqamuy amumi tāyuṅwni; puma qa ūuyyaṅwu, piw qa höqyaṅwu, piw hihta qa koyohtotaṅwu; noqw yanyuṅqw ōveqatsit ep Umuna pumuy nopni’ta. Noqw ya pam umuy pumuy amuhpenihqe qa pavan pas k̇ahk̇awna? ");
INSERT INTO hopNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ya sen umuṅaqw haqawa pan wūwantaqa hin nāwuṅwnaniqey ṅas’ew tuwi’ta? ");
INSERT INTO hopNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Noqw hinoqw pas piw uma yuwsit ōviy nānaphin wūwantota? Uma tutskwat aṅ sishut aw wūwayani, hin puma wuṅw’iwwisqata. Puma qa tumalay’yuṅwa, piw qa tontotaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Noqw nu umumi paṅqawni: Hikis pi Solomon sohsok hihta nukṅwat yuwsi’k̇aṅw qa hihtawat it sihut an lomayuwsi’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yan hapi God tutskwava tūsaqat lomayuwsina; pay pi pam hihsavo panyuṅq’ö. Pu’ pam as panyuṅwt, qāvotiqw pay qöpqömiq maspiwni. Puyaw hinoqw tis pam umuy qa pas pavan yuwsinani, okiw uma öwituptsiwni’yuṅqamu? ");
INSERT INTO hopNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Paniqw ōviy uma qa nānaphin wūwantotani paṅqawk̇ahk̇aṅwo: Sen itam hihta nȫnösani? ya sen itam hihta hikwyani? ya sen itam hihta nāyuwsinayani? kitotani. ");
INSERT INTO hopNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pi pay sohsok it yantaqat qatuptsiwni’yuṅqam tunatyawyuṅwa. Pi ōveqatsit ep Umuna umuy sohsok it hihta haqni’yuṅqat pay navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nīk̇aṅw uma mohti God moṅwtunatyayat tunatyaltotimantani, pu suan hinwisniqeyu; noqw sohsoy īi himu umumi enaṅ noiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Paniqw ōviy uma pu’ talöṅvaqat ep qavomi hintaniqat ep qa nānaphin wūwantotani. Pay pi qāvoniqa hihta hintaniqat aw nāp tunatyaltimantaniq’ö. Pay pi uma pu’ talöṅvaqat ep hiniwhtiqat‐sa aw tunatyaltotimantani. ");
INSERT INTO hopNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Uma qa tūovelantotani, nen uma qa pantsaniwyani. ");
INSERT INTO hopNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Taq uma tūovelantote’ pay piw pan pantsaniwyani; pu uma hihsa’haqam hakiy eṅem tuwantotaqw, pay piw pan umuṅem tuwantiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Noqw hinoqw um uhtupkoy posmiq hihta hihsaq tuway’k̇aṅw, pas nāp uhposeq lestavit pakiwtaqat aw qa unaṅwtavi’ta? ");
INSERT INTO hopNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Noqw pantaqw um hin uhtupkoy aw paṅqawni: Himu as nu uhposkiy hóroknani, kítani, susmataqpi uhposveq lestavi pakiwtaqö’? ");
INSERT INTO hopNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Um nawip’ew hinmaqa, um mohti uhposṅaqw lestavit hórokne’, pahsat pu um suyan tālat tayk̇aṅw, uhtupkoy poskiyat hóroknani. ");
INSERT INTO hopNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Uma hihta God aw noiwhqat qa popkotuy amumi taviyamantani, taq k̇a puma umuy ṅúaye’, tutkitotani; pu uma umuhpearl‐túkwaviy qa pitsōtimuy amutpipo tūvayani, taq k̇a puma put aw wukukuykuyani. ");
INSERT INTO hopNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Uma hihta ōviy tūviṅtotani, nen uma put makiwyani; pu uma hihta hepyani, nen tutwani; pu uma pöṅöṅöykinayani, noqw umumi hötsíltini. ");
INSERT INTO hopNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pi hak hihta ōviy tūviṅtaqa makiwṅwu; pu hihta hepqa túwaṅwu; pu pöṅöṅöykinaqat aw hötsíltimantani. ");
INSERT INTO hopNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Noqw kurs umuy haqawat tiat nay aw pölaviktuviṅtaqw ya sen pam put owat máqani? ");
INSERT INTO hopNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hal ya sen pam pākiwuy ōviy tūviṅtaqw soq put tsūat máqani? ");
INSERT INTO hopNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Noqw kurs pay as uma qalomáhink̇ahk̇aṅw umuhtimuy hihta nukṅwat huylalwaniqey tuwi’yuṅqw, puyaw tis ōveqatsit ep Umuna put aw tūviṅtotaqamuy hihta nukṅwat huytani? ");
INSERT INTO hopNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sinom umuy pāsyaniqat uma pan nānawakne’ pay uma piw pan sinmuy pāsyamantani. Pi yan hapi Moses Tutuyqawhqat lavay’aymuyatuy amumum itamumi tutapta. ");
INSERT INTO hopNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Uma hihsa’ qenit hötsiwat aṅ yuṅni. Taq mokiwuy aqw hötsiwa wuhkoqni, pu aqw pöhu a’nö pūtsi; noqw k̇aysiwhqam paṅsoq nātsamya. ");
INSERT INTO hopNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pi qatsit aw hötsíwa hihsaq qéniniqw, pu aqw pöhu hihsaq pūtsiniqw, ōviy híkiyom put tuway’numya. ");
INSERT INTO hopNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Uma hakimuy Tutuyqawhqat lavay’aymatnihqey pan nātuṅwantotaqamuy ep tunatyaltotini. Taq haqawat pan atsáy’k̇ahk̇aṅw umumi ökiwtani. Puma kanelmuy amún okiw’unaṅway’yuṅqey ank̇ahk̇aṅw, kwēkwewhtuy amún tūhovalayaniqey tunatyawyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pay uma pumuy hintsakpiyamuy mātsi’yuṅwni. Ya sinom ōvat yöṅötskit aṅqw mawyaṅwu? Sen nönvospalat hihta kūtay’yuṅqat aṅqw mawyaṅwu? Pay qa panta. ");
INSERT INTO hopNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Noqw ōviy haqam lomasipaltsoki nukṅwat sipalay’vaṅwu; noqw pay qalomásipaltsoki qa nukṅwat sipalay’vaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pas lomasipaltsoki soon hin’ewakw sipalay’vaṅwu; pu qalomásipaltsoki soon nukṅwat sipalay’vaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Qalomásipaltsoki qa nukṅwat aniwnaṅwuqa tsaqniwe’ qȫhit aqw maspiwṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pantaqw ōviy uma pumuy aniwniyamuy akw pumuy mātsi’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Qa sohsoyam inumi Tutuyqawhqa, Tutuyqawhqa, kitiwisqam ōveqatsit ep Ina moṅw’iwtaqat aw yuṅni; pi ōveqatsit ep Inay tunatyayat aṅ hinmaqa hapi paṅso pákini. ");
INSERT INTO hopNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ason aw pituqw pep pu’ k̇aysiwhqam inumi paṅqaqwani: Tutuyqawhqa, Tutuyqawhqa, ya itam qa uhnatṅwaniy aw yank̇ahk̇aṅw uṅem yuaaykuya? pu uhnatṅwaniy aw yank̇ahk̇aṅw nukpanhihikwsimuy nuhtuṅaqw ipwaya? pu uhnatṅwaniy aw yank̇ahk̇aṅw nihtiwtaqat k̇ātutmalat tumaltota? ");
INSERT INTO hopNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pahsat pu nu amumi pas paṅqawni: Nu qa hisat umuy tuwi’ta; huvam inuhpiy ahpiyyaa, nukpantuwit hintsatsk̇aqamu. ");
INSERT INTO hopNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Paniqw ōviy haqawa ilavayiy aw tūqayk̇aṅw put an hinmaqa tāqat wuwni’taqat antaqat nu paṅqawni. Pam owat atsve kīta. ");
INSERT INTO hopNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Noqw yokvaqw, wukomunva, pu hukvaqe kīhut aṅ a’nö yēvanta; noqw pam qa sahpu, pam owat ep kīiwtaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pu haqawa ilavayiy aw tūqayk̇aṅw qaanhinmaqa hakiy qa wuwni’taqat antani. Pam hak pisave kīta. ");
INSERT INTO hopNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Noqw yokva, wukomunva, pu hukvaqe kīhut aṅ a’nö yēvanta; noqw pam sahpu, nihqe pam kīhu qaan’ewakw kīqöti. ");
INSERT INTO hopNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Noqw Jesus pas öqalat pasiwk̇aṅw, pan pumuy tutuqayna, tutavot tūtutuqaynayaqamuy qa amun’i. Noqw pam yan yuaataqe yukuqw, sinom put hin tutuqaynaqat ep aw k̇ātayuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pu pam tsomoṅaqw hawhq, sinom qaan’ewakw hintaqam put aṅkya. ");
INSERT INTO hopNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Noqw meh, hak tokoplelet tūtuyhqa pituhqe, put aw naokiway’taqe aw paṅqawu: Tutuyqawhqa, um suhtaq’ewnen soon nuy qa powatani. ");
INSERT INTO hopNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Noqw Jesus put aw māvuyaltiqe aw toṅokt paṅqawu: Pay nu suhtaq’ewa; powaltii. Noqw pahsat pay put aṅ tokoplele súlawhti. ");
INSERT INTO hopNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Noqw Jesus put aw paṅqawu: Um hapi qa hakiy aw haqam lavayhtini; pay um ahpiynen God awwat moṅwit aw nāmahtaknani, nen Moses hin tutaptaqw um kuwahtiput God aw nóani. Um yan powaltiqey nuhtumi tuawi’tani. ");
INSERT INTO hopNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Noqw Jesus Capernaum aw pakiqw, hak solāwamuy amumi moṅwi put aw pituhqe, put aw qa nātusitaqe, ");
INSERT INTO hopNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Paṅqawu: Tutuyqawhqa, ihoṅviaya ikiy ep tuyhqatsq, put ahpa’ qatāyuṅqw, pam pas k̇ānanvotk̇aṅw okiwhinta. ");
INSERT INTO hopNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Noqw Jesus put aw paṅqawu: Pay nu aqwnen put qalaptsinani. ");
INSERT INTO hopNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Noqw solāwamoṅwi lavayhtiqe put aw paṅqawu: Tutuyqawhqa, soon pi um nuy yan’ewakwniqw ikiy aw papkini. Pay um panis lavayhtiqw, pay ihoṅviaya qalaptuni. ");
INSERT INTO hopNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pi nu sukwat aw maqaptsi’k̇aṅw qatu. Noqw solāwam inumi piw maqaptsi’yuṅwa. Noqw nu sukw aw, Yupa, kitaqw pam haqaminiṅwu; pu sukwat aw, Pew’i, kitaqw pam inuminiṅwu; pu ituwikiy aw, Yanhtii, kitaqw pam panhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Noqw Jesus put navotqe pas aw k̇ātaytaqe put aṅkyaqamuy amumi paṅqawu: Nu umumi pas antsa paṅqawni: Pas nu qa haqam pas yan tuptsiwnit tuwa, hikis Israel‐sinmuy amuhpee. ");
INSERT INTO hopNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Noqw nu umumi paṅqawni: Nāt k̇aysiwhqam hōpaqw, pu tavaṅqw ökini; nen Abraham, pu Isaac, pu Jacob, pumuy amumum ōveqatsit ep tunösvoñat aw yesvani. ");
INSERT INTO hopNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Noqw ima as paṅsoq yuṅniqam ihpo qatalpumi maspiwyani. Pep pu’ tsaykitiwni, pu tama ṅuritiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Noqw Jesus solāwamoṅwit aw paṅqawu: Pay pi um aqwni. Pay um hin tuptsiwhq nam antaa. Noqw put hoṅviayaat pay pahsatniqw qalaptu. ");
INSERT INTO hopNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pu Jesus Peter kīyat aw pakiqw kurs put nȫmayat yuat mukituyat akw tuyhqatsi. ");
INSERT INTO hopNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Noqw Jesus put māyat aw toṅokq, mukituya put mātavi; noqw wuhti qatuptuqe pumuy amumi unaṅwtavi. ");
INSERT INTO hopNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Noqw tapkiqw, sinom k̇aysiwhqamuy nukpanhihikwsimuy akw tuyqawiwyuṅqamuy put aw tsamvaya; noqw pam lavayiy akw sinmuy amuṅaqw nukpanhihikwsimuy ipwa; nihqe sohsokmuy tūtuyyaqamuy qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yan Tutuyqawhqat lavay’ayayat Esaias lavayiat aw antsaniwa, pam ura paṅqawu: Pam itamuy hihta akw ȫpuiwyuṅqat nāmi nahlaknak̇aṅw, itahtuyay īkwilta. ");
INSERT INTO hopNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Noqw Jesus sinmuy qaan’ewakw hintaqamuy put aw ṅöyakiwtaqw túwahqe, put aw nánatuwnayaqamuy wuhkovatuphat yupqöymiyaniqat amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Noqw hak tutavot tūtutuqaynaqa Jesus aw pítuhqe put aw paṅqawu: Tūtutuqaynaqa, nu uṅ haqaminiqw úmummantani. ");
INSERT INTO hopNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Noqw Jesus put aw paṅqawu: Ima sisik̇ahtayht haqe’ qölöy’yuṅwa, noqw súmawuy aṅ masay’yuṅqam totokpi’yuṅwa; noqw nu’ Sinot Tiat haqam iqötöy nāsuṅwnaniqey ṅastaa. ");
INSERT INTO hopNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pu piw suhk̇a put aw nánatuwnaqa put aw paṅqawu: Tutuyqawhqa, um nuy nakwhanaqw, nu mohti inay amht, pu’ uṅkni. ");
INSERT INTO hopNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Noqw Jesus put aw paṅqawu: Um inuṅkni; ason pi so’pum pumuy amuṅaqw so’pumuy amyani. ");
INSERT INTO hopNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pu pam pākihut aqw pakiqw, put aw nánatuwnayaqam put aṅk aqw yuṅa. ");
INSERT INTO hopNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Noqw meh, wuhkovatuphat aṅqe’ qaan’ewakw hukvaqe, pas qaöwíhuhukq, ōviy pākihut pāhut hoṅvantaqat akw nȫmilti; noqw pantaqw Jesus pūwi. ");
INSERT INTO hopNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Noqw put aw nánatuwnayaqam put aw ökihqe, tātaynayaqe aw paṅqaqwa: Tutuyqawhqa, itamuy ayo óyaa; itam súlawhtini. ");
INSERT INTO hopNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Noqw pam pumuy amumi paṅqawu: Ya uma hinoqw pas tsawiniwyuṅwa, okiw uma öwituptsiwni’yuṅqamu? Pahsat pu pam wunuptut, hūhuk̇aṅwtuy mēwa, pu pāhuta. Noqw wukosutmakma. ");
INSERT INTO hopNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Noqw tuwat tahtaqt k̇atayuṅqe paṅqaqwa: Ya sen i’ hak himuniqw, ōviy hikis pi hūhuk̇aṅw, pu pāhu put hiṅqawhq anhtoti? ");
INSERT INTO hopNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Noqw pam wuhkovatuphat ayoqwat Gergese‐sinmuy tutskwayamuy aw pituqw, pepeq hakim lȫyöm tāqatuy nukpanhihikwsimuy akw tuyqawiwtaqamuy tuamaqölṅaqw yámakqe, put ahsawva; hakim nuhtsel’ewayomniqw, ōviy soon hak paṅqe’ hinnumni. ");
INSERT INTO hopNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Noqw meh, puma a’nö töqtiqe paṅqawu: Ya um itamuy hinhtiniqat nāwakna Jesus, um God Táita? Ya um nāt aw qa pituqw pay itamuy okiwsanniqe ōviy pitu? ");
INSERT INTO hopNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Noqw pep pumuy amuṅaqw yāp pitsōtim wukotonawtaqam nōnova. ");
INSERT INTO hopNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Noqw ōviy nukpanhihikwsim put aw ö’qalyaqe paṅqaqwa: Kurs um itamuy ipwe’, itamuy pitsōtimuy amumi yuṅniqat itamuy nakwhanani. ");
INSERT INTO hopNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Noqw pam amumi paṅqawu: Yúpave. Noqw puma nöṅakqe, pitsōtimuy amumi yuña. Noqw sohsoyam pitsōtim tuhpelat aṅ pāmiq a’nö yuhtukqe, pāmiq paöysoa. ");
INSERT INTO hopNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Noqw pumuy nopni’yuṅqam watqaqe, kīmiyaqe, hin hiniwhtiqat lavayhta, pu ima hakim nukpanhihikwsimuy akw tuyqawiwtaqam hin hinhtiqata. ");
INSERT INTO hopNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Noqw sohsoyam pep kitsókit ep ki’yuṅqam paṅqw Jesus ahsawvawisa; nihqe put tutwaqe pay pam pumuy tutskwayamuy aṅqw ahpiyniqat put aw ö’qalya. ");
INSERT INTO hopNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pu Jesus pākihut aqw pakit, wuhkovatuphat yámakqe, nāp kitsókiy aw pitu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Noqw meh, hakim hakiy ahpa’ qataytaqat tūtuyhqat ahpat aṅ wáökiwtaqat Jesus aw wikvaya. Noqw pam pumuy qapēvewniyamuy amumi túwahqe, it tūtuyhqat aw paṅqawu: Itii, um qa hin unaṅway’tani; pay uhqaanhtipu uhpiy ayo yukiwa. ");
INSERT INTO hopNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Noqw hakim tutavot tūtutuqaynayaqam pep yesqam unaṅwpeq paṅqaqwa: I’ tāqa God aqw hiṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Noqw Jesus pumuy wuwniyamuy mātsi’taqe amumi paṅqawu: Ya uma hinoqw umuh’unaṅwpeq qalomáwuwantota? ");
INSERT INTO hopNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ya hinwat lavayhtiniqw qa pas pas hinta? sen Uhqaanhtipu uhpiy ayo yukiwa, kitaniqö’? sen Wunuptut, nakwsuu, kitaniqö’? ");
INSERT INTO hopNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Noqw pay pi nu’ Sinot Tiat yep qatsit ep hakiy ahpiy qaanhtipuyat ayo yúkuniqey aw öqalat pasiwtaqat uma it akw nanaptani‐pu pam it hakiy ahpa’ qataytaqat aw paṅqawu: Wunuptut, uh’ahpay kwusut, um nímani. ");
INSERT INTO hopNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Noqw pam wunuptut, kiy aw’i. ");
INSERT INTO hopNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Noqw k̇aysiwhqam sinom put aw tāyuṅqe, God pas hihtatota, pam hakiy sinot pas panhaqam öqalat máqahqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Noqw Jesus paṅqw ahpiynihqe, hakiy tāqat Matthew yan mātsiwhqat haqam moṅwit eṅem sīvat ömalalwaqat ep qatuqw tuwa; nihqe put aw paṅqawu: Um inuṅkni. Noqw pam wunuptut put aṅki. ");
INSERT INTO hopNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Noqw ahpiy pantaqw, Jesus put aw nánatuwnayaqamuy amumum Matthewt kīyat ep ökihqe, pep tunösvoñat aw yesq, k̇aysiwhqam moṅwit eṅem sīvat ömalalwaqam‐niqw pu qaanhinwisqam paṅso ökihqe, pumuy amumum put aw yesva. ");
INSERT INTO hopNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Noqw Pharisee‐sinom put aw tātayyaqe, put aw nánatuwnayaqamuy amumi paṅqaqwa: Noqw umuy tutuqaynaqa hinoqw moṅwit eṅem sīvat ömalalwaqamuy‐nik̇aṅw, pu qaanhinwisqamuy amumum tūmoyta? ");
INSERT INTO hopNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Noqw Jesus put navotqe, pumuy amumi paṅqawu: Pay aṅ qahinyuṅqam tūhik̇at qa haqni’yuṅwa; nawus pi tūtuyyaqam put haqni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Uma yaṅqw ahpiyye’, tutuvenit aṅ pupriye’, pahsat pu it lavayyukit māmatsyani: Uma tūookwatuwyaniqat nu put tuṅlay’ta; noqw uma soq hom’oyit‐sa inumi noaya, it’a. Pi nu aṅ súanhinwisqamuy qa pumuy wáṅwayniqe ōviy pitu; pi nu imuy qaanhinwisqamuy nāp tunatyay aṅqw lasyaniqat aw wáṅwayniqw ōviy pitu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pahsat pu John aw nánatuwnayaqam Jesus aw ökihqe aw paṅqaqwa: Itam‐niqw pu Pharisee‐sinom piép nānapwalaṅwu. Noqw ya hintaqw ōviy ūmi nánatuwnayaqam qa pantsatsk̇a? ");
INSERT INTO hopNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Noqw Jesus pumuy amumi paṅqawu: Ya sen haqam mö’wit ep sinoiwyuṅqam möönaṅwuy pumuy amumumniqw napwalni’yuṅwni? Nīk̇aṅw pay ason hisat aw pituqw, möönaṅw pumuy nawhkiwni; noqw pep pu’ puma nānapwalani. ");
INSERT INTO hopNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Qa hak sino puhutsatsakwmötsaput yewaskwit aw pihtaknaṅwu. Ispi hak panhtiqw, put ep pihtakqa yuwsit aṅqw tsikq, pu’ pas pāpu wukoprokṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Piw qa haq pi hak puk̇awikorot sakwíiwmaqat aṅ puhuovavalat kuhkuya; pi hakiy panhtiqw, ovavala pēke’ wiwkorot patomnani, nen aṅqw kūyiwtaqa wehemhtini, noqw wiwkoro sakwitotini. Pi puma puhuovavalat puhuwiwkorot aṅ kukyaṅwu; noqw pam qa hinhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Noqw nāt pam pumuy amumi yan yuaataqw, meh, hak moṅwi pítuhqe, Jesus aw naokiwtat, aw paṅqawu: Okiw iti māna nāt pas pu’ mōki. Noqw um as awnen, aw uhmay akw toṅokq pam ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Noqw Jesus wunuptut put aṅki, pu put aw nánatuwnayaqamu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Noqw pam aqwniqw, hak wuhti pakwt lȫq sihk̇ay’taqat yahsaṅwuy aṅ uṅway qa huruhtaqey akw tūtuyhqa put ahkwayñaqw aw pítuhqe, yuwsiyat qalawṅwayat aw toṅo, ");
INSERT INTO hopNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pam unaṅwpeq paṅqawhqe ōviy’o: Ṅas’ew pi nu as yuwsiyat aw tóṅok̇e’, pay soon qa qaluptuni. ");
INSERT INTO hopNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Noqw pam panhtiqw, Jesus namtökt, put túwahqe aw paṅqawu: Itii, pay um qahin unaṅway’tani; pay uhqapevewni uṅ qalaptsina. Noqw pahsat pay wuhti qalaptu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pu Jesus moṅwit kīyat aw pákihqe, lēlenyaqamuy pu k̇aysiwhqamuy sinmuy pep saáatotaqamuy amumi yórikqe, ");
INSERT INTO hopNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Paṅqawu: Huvam ayoyaay! Pay māna qa mōki, pi pūwi. Noqw puma put aw tutsíwtsuyhti. ");
INSERT INTO hopNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pu ōviy pam sinmuy paṅqw nöṅaknat, ahpami pákihqe, mānat māyat ṅuaqw, pam qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Noqw pam pep paniwhtiqa put tutskwat aṅ ahsupoq yuaatiwa. ");
INSERT INTO hopNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Noqw Jesus paṅqw ahpiyniqw, hakim lȫyöm qapostalqam put aṅk tsa’timaqe paṅqawma: David tíata, okiw itamuy ōkwatuwaa! ");
INSERT INTO hopNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Noqw pam kīmi pakiqw, qapostalqam put aw pitu. Noqw Jesus pumuy amumi paṅqawu: Ya nuy panhtiniqey tuwi’taqat uma tuptsiwa? Noqw puma put aw paṅqawu: Owi Tutuyqawhqa. ");
INSERT INTO hopNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pahsat pu pam pōsiyamuy aw toṅo paṅqawk̇aṅwo: Pay uma hinhaqam qapēvewnaqat pan umuṅem hintani. ");
INSERT INTO hopNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Noqw pumuy pōsiam tālawva; noqw Jesus pumuy pās mēwaqe paṅqawu: Uma hapi tunatyaltiqw, qa hak it navotni. ");
INSERT INTO hopNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Noqw tuwat soq puma paṅqw ahpiynihqe, pam pumuy pantsanqat put tutskwat aṅ ahsupoq kúrukna. ");
INSERT INTO hopNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Noqw pumuy paṅqw yámaktoqw, meh, hakim hakiy qayuáataqat nukpanhikwsit akw tuyqawiwtaqat Jesus aw wikvaya. ");
INSERT INTO hopNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Noqw nukpanhikwsit put aṅqw ayo tūviwhq, qayuáataqa yuaayku. Noqw sinom suhpantaqam k̇ātayuṅqe paṅqaqwa: Pas qa hisat Israel‐sinmuy amuhpe yan hiniwhtiqw hak aw yori, kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Noqw tuwat Pharisee‐sinom paṅqaqwa: Pam nukpanhihikwsimuy moṅwíyamuy aw yank̇aṅw, nukpanhihikwsimuy ipwanta. ");
INSERT INTO hopNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Noqw Jesus paṅ wuhkokitsokit aṅ‐nik̇aṅw pu pay kitsókit aṅ nakwsuqe pumuy tsotsvalkiyamuy aṅ pumuy tutuqaynatinuma; pu moṅwtunatyat ahpiy lomatuawit yuaatinuma; pu sinmuy amuhpa’ sohsokmuy tūtuyyaqamuy qalaptsintinuma, pu sohsok hihta akw ȫpuiwyuṅqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nihqe pam k̇aysiwhqamuy sinmuy amumi yórikqe pumuy ökwatuwa, maṅwúiwyuṅqw ōviy’o, pas kanelmuy amumi qa hak tunatyawtaqw puma ahtsavaliwyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pahsat pu pam put aw nánatuwnayaqamuy amumi paṅqawu: Pas hapi as ūyi qaan’ewakw tukwsiwta, noqw tsovalayaniqam híkiyomu. ");
INSERT INTO hopNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Oviy uma ūyi’taqat aw nānawaknaqw, pam hakimuy ūyiy aw ayatani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pu pam pakwt löq sihk̇ay’taqamuy put aw nánatuwnayaqamuy wáṅwayhqe, pumuy tuyoy’e’wakw hīhikwsimuy amumi öqalat huyta, pumuy nuhtuṅaqw ipwanwisniqat ōviy’o; pu sohsokmuy hihta akw tūtuyyaqamuy, pu ȫpuiwyuṅqamuy qalaptsintiwisniqat aw pumuy öqalmaqa. ");
INSERT INTO hopNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Noqw pakwt löq sihk̇ay’taqam ayaiwyuṅqam yan mātsiwya: I’ mohti’maqa Simon, Peter yan piw túṅwantiwhqa, noqw pu put tupkoat Andrew; pu Zebedeet tiat James‐niqw pu tupkoat John; ");
INSERT INTO hopNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pu Philip‐niqw, pu Bartholomew, pu Thomas‐niqw, pu moṅwit eṅem sīvat ömalawhqa Matthew; pu Alphaeus tiat James‐niqw, pu Lebbaeus, hak Thaddaeus yan piw mātsiwhqa; ");
INSERT INTO hopNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Pu Simon sinomuy amuṅem qa nātusi’taqa‐niqw, pu Judas Iscariot, momṅwituy amumi Jesus mātapniqa. ");
INSERT INTO hopNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Noqw Jesus imuy pakwt löq sihk̇ay’taqamuy ayataqe, amumi tutaptaqe paṅqawu: Uma hapi imuy qa‐Jew‐sinmuy qa amuhpa’yani; pu Samariat ep sinmuy kitsókiyamuy qa haqamiwat aw yuṅni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Uma qa paṅyat, Israel‐sinmuy amuhpa’yani. Taq okiw puma kanelmuy amún haqami hiniwhtoti. ");
INSERT INTO hopNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pu uma aṅqe’ye’, yan yuaatinumyani: Oveqatsit aṅqw moṅwtunatyat aw pitsíwiwta, kitotani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Uma tūtayyaqamuy qalaptsintiwisni; tokoplelet tūtuyyaqamuy powatiwisni; so’pumuy tātaynatíwisni; nuhtuṅaqw nukpanhihikwsimuy ipwanwisni. Uma hapi öqalat paysoq makiwya; ōviy uma pan piw paysoq tūvaaṅwantiwisni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Uma palasivat, qötsásivat, pu sik̇avalasivat qa sivamokyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Piw qa tukput mask̇ay’wisni; piw qa lȫq napnay’wisni, piw qa tōtsita, piw qa natöṅpita. Pay tumal’aya nösniqey ahsataṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pu uma haqami wuhkokitsokimi, sen pay kitsókimi yuñe’, hak pep k̇aptsitiwhqat tūviṅtotamantani. Nen uma hisat paṅqw ahpiyyaniqey pahsavo pep yesmantani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pu uma haqami kīmi yuñe’, amumi paṅqaqwamantani: Uma kwakwhat yesni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pu kurs pep kīvit pay umuhkwakwhay hihk̇ay’yuṅqw, umuhkwakwha pep hūrstimantani. Pu kurs pay puma put qa hihk̇ay’yuṅqw, pay umuhkwakwha umumi ahoy pítumantani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pu hakim umuy qa pās o’yat, piw umuhlavayiy qa aw tūqayyuṅqw, uma paṅqw kīṅaqw aṅqw ahpiyye’, umuhkukuy aṅ qöat ayo tsatswiyamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nu umumi pas antsa paṅqawni: Hisat hin yukiltiniqat aw pituqw, imuy umuy qa pās o’yaqamuy amuṅem pas is óhini. Puma Sodom‐nik̇aṅw pu Gomorrhat ep sinmuy amuhpenihqe pas pavan amuṅem nuhtsel’ewayhtini. ");
INSERT INTO hopNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nu’ hapi umuy aṅhqe ayatani. Noqw uma kanelmuy amún hakimuy kwēkwewhtuy amunyuṅqamuy amuhpa’ hinnumyani. Oviy uma tsūtsu’tuy amún qaūunatni, pu höwihtuy amún ṅasta nukpanay’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nīk̇aṅw uma tunatyawk̇ahk̇aṅw hinnumyani. Taq sinom moṅwtsovawtaqamuy amumi umuy tsamvayani; nen tsotsvalkiy aṅ umuy a’nö wuvahtotani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pu uma inutsviy momṅwituy‐nik̇aṅw pu pas susmomṅwituy amumi tsamvaniwyani. Nen uma pumuy amumi nuy tuawi’yuṅwni, pu qa‐Jew‐sinmuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nīk̇aṅw ason puma umuy nuhtumi mātapyaqw, uma hin hihta yuaaykuyaniqey qa wuwanvisoqtotini. Pay ason uma hihta yuaaykuyaniqa pep umumi noiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pi qa uma yuaatotani. Pi ōveqatsit ep Umunay Hikwsiat umupqölpa yuaatani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Pu nātupkomuy amuṅaqw suhk̇a sukwat mokiwuy aw nóamantani; pu naat tiy pay piw pantsanni. Pu timat nay, pu yuy, pumuy amuhpewhtote’, pumuy mokiwuy aw pitsínayamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pu sinom sohsoyam umumi qasuhtaq’ewyani, uma isinomniqw ōviy’o. Nīk̇aṅw ason so’ṅwamiq aṅ kuytaqa hapi ayo yámakiwtamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nīk̇aṅw ason puma yep it kitsókit ep umuy okiwsahsanyaqw, uma haqamiwat aw watqani. Pi nu umumi pas antsa paṅqawni: Soon nāt uma Israel‐sinmuy kitsókiyamuy aṅ ahsupoq kūkuyvaqw, pay nu’ Sinot Tiat pítuni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Pay tutuqayhqa put tutuqaynaqat epnihqe qa pavan pasniṅwu. Pu piw hoṅviaya moṅwiy epnihqe qa pavan pasniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pay tutuqayhqa put tutuqaynaqat ante’, pay pam put ep tsuyakmantani, pu hoṅviaya piw moṅwiy an’i. Noqw kurs sinom ki’taqat Beelzebub yan tuṅwáye’, pay kurs pi hin tis puma sinomuyatuy qa pan túṅwantotani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Noqw ōviy uma pumuy qa mamqasyani. Pi qa himu āmiwtaqa qa mātaktini; pu qa himu tupkiwtaqa qa nanaptiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nu hihta qatulpuve umumi lavayhtiwhq, uma put tālat ep yuaaykuyamantani. Pu himu umuhnaqvumiq lavayhtiwhq, uma kits’oṅaqw put tsa’lalwani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Uma sinmuy qa mamqasyani. Puma pi hakiy tokoyat‐sa nīnayaniqey aw öqalay’yuṅwa; nīk̇aṅw kurs hin hakiy hikwsiyat nīnayani. Uma qa panyuṅwt, God mamqasyani. Pam pi hakiy tokoyat pu hikwsiyat sivihpit qȫhit akw hovalaniqey aw öqalay’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Puyaw qa lȫyöm kwevewhyat sūkw palavotōnat ōviy huyiwṅwu? Noqw qa himuwa puma Umunay qa tunatyayat ahpiy tutskwami posṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Noqw hikis pi umuhqötöva umuhhömi sohsoy pohtoylaniwta. ");
INSERT INTO hopNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Paniqw ōviy uma qa tsawiniwyuṅwni. Umuna umuy k̇aysiwhqamuy kwekwévewhyamuy amuhpenihqe pas k̇ahk̇awna. ");
INSERT INTO hopNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hak haqam isinonihqey nuhtumi paṅqawhq, nu piw tuwat put isinoynihqat ōveqatsit ep Inay aw paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nīk̇aṅw hak haqam qa isinonihqey nuhtumi paṅqawhq, nu piw tuwat put qa isinoynihqat ōveqatsit ep Inay aw paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Uma qa inumi yan wūwantotani: Pam k̇a sinmuy qa hin unaṅwat yesniqat amuṅem yúkuniqe ōviy pitu. Qae. Nu qa paniqw pitu. Pi sinom inutsviy nātsikyani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Pi nu tāqat nay ehpewtaniqe pitu, pu māna yuy ehpewii, pu mö’wi kōñay yuyat ehpewhtiniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Pu hak pas nāp sinomuy tuwqamuy’vani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Inumi unaṅway’taqey lalvayk̇aṅw, nay pu yuy pumuy amumi pas unaṅway’taqa pay nawus qa isinoni. Pu inumi unaṅway’taqey lalvayk̇aṅw, timuy amumi pas unaṅway’taqa hapi pay nawus qa isinoni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pu nahoylehtsit qa kwusut, pu qa inuṅknihqa hapi pay nawus qa isinoni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Qatsiy k̇ahk̇awnaqa put kwayhni. Pu inuṅem tunatyat ep qatsiy kwayhqa put túwani. ");
INSERT INTO hopNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Umuy pās óyahqa hapi nuy pās távini; pu nuy pās távihqa hapi Inay nuy aṅqw távihqat pās távini. ");
INSERT INTO hopNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kurs Tutuyqawhqat lavay’ayaat hakiy aw pituqw, pam Tutuyqawhqat tunatyayat ōviy put pās tave’, pam lavay’ayat amum hihta ahsatiyat makiwni. Noqw kurs sino súantaqa hakiy aw pituqw, pam put súanmaqat ōviy put pās tave’, pam put amum hihta makiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Noqw kurs imuy inumi puhutuptsiwni’yuṅqam haqawa hakiy aw kuyhtuviṅtaqw, pam inumi tutuqayhq paniqw put kuyne’, pas soon qa ahsatiy makiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pu Jesus pakwt löq sihk̇ay’taqamuy put aw nánatuwnayaqamuy amumi tutaplawhqe yukut, pu kitsókinawit sinmuy tutuqaynak̇aṅw amumi yuaataniqe ōviy paṅqw nakwsu. ");
INSERT INTO hopNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Noqw John sivikive pakiwk̇aṅw, Christ hintsakpiyat navotqe, pam löqmuy put aw nánatuwnaqamuy Jesus aw ayata. ");
INSERT INTO hopNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Noqw puma Jesus aw paṅqawu: Ya um hak Tutuyqawhqat lavay’ayaat pas pávannihqa hisat pítuniqa? Sen pi itam nāto hakiy pas sukwat nuhtayyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Noqw Jesus lavayhtiqe, pumuy amumi paṅqawu: Uma ahpiynen, hihta navotqey, pu aw yórikqey put John āawnani. ");
INSERT INTO hopNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Qapostalyaqam pōsiy tālawnaya; pu tutuhapt nankwusa; tokoplelet tūtuyyaqam powatoti; pu nanaqsöpt nanapta; so’pum ahoy tātayya; aṅ ōokiwyaqam lomatuawit nanapta. ");
INSERT INTO hopNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Noqw i’ hak inuhpe qa unaṅwmokqa hapi hahlayhpit ep’e. ");
INSERT INTO hopNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Noqw pumuy ahpiyniqw, Jesus sinmuy amumi John yuaataqe paṅqawu: Ya uma qayēsiwhpumihaqami hihta aw kuyvawisa? Sen pāqavit hūk̇aṅwuy akw wayayataqat awi’? ");
INSERT INTO hopNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Noqw ya uma hihta aw kuyvawisa, sen hakiy lomayuwsi’taqat awi’? Meh, pi lomayuwsi’yuṅqam momṅwituy kīkiyamuy aṅ yēse. ");
INSERT INTO hopNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Noqw ya uma hihta aw kuyvawisa? Sen pi Tutuyqawhqat lavay’ayayat awi’? Owi, nu umumi paṅqawni: Pam Tutuyqawhqat lavay’ayayat epnihqe pas pávani. ");
INSERT INTO hopNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Pi it hapi tutuveni lavayhtiqe paṅqawu: Meh, nu hapi upyeve ituaw’ayay ayatani; noqw pam uhsavo uṅ háqe’niqat aṅ qenitani, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nu umumi pas antsa paṅqawni: Pas qa haqam momoymuy amuhpiy tihtiwyaqamuy amuṅaqw John kūyit akw tūtuvoylalawhqat epnihqe pas pávannihqa wunuptu. Noqw pay as pi pantaqw, ōveqatsit aṅqw moṅwtunatyat ep sushin’ewaynihqa put epnihqe pas pávani. ");
INSERT INTO hopNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Noqw kūyit akw tūtuvoylalawhqat John hintsaktivaqat aṅqw pew pahsavo sinom ōveqatsit aṅqw moṅwtunatyat nānaqaslalwa; noqw a’nöyaqam öqalay akw put tuyqawvanta. ");
INSERT INTO hopNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pi sohsoyam Tutuyqawhqat lavay’aymat‐niqw pu tutavo John aw pahsavo hin hintaniqat yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Noqw uma nānakwhaniqw, i’ hapi Elias, ura hak pituniqa. ");
INSERT INTO hopNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tuqayvastotaa. Pi uma naqvuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Noqw ya sen nu pu’ qatsívaptsiwyuṅqamuy hihta enaṅ namimahtaknani? Puma tsātsakwmuy kihsonve yesqamuy amunyuṅwa. Puma suṅwámuy amumi paṅqaqwa: ");
INSERT INTO hopNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Itam umumi lēlenyaqw, uma qa tīva; itam umumi tsaykitaqw, uma qa tsayku. ");
INSERT INTO hopNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Oviy pi John pítuhqe qa tūmoyk̇aṅw, piw qa hīhikq, puma paṅqaqwa: Pam nukpanhikwsit akw tuyqawiwta, kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Noqw nu’ Sinot Tiat pítuhqe tūmoyk̇aṅw, pu hīhikq, puma piw paṅqaqwa: Is uti hunuk̇a, wine pas qa öyṅwu, moṅwit eṅem sīvat ömalalwaqamuy‐nik̇aṅw pu qaanhinwisqamuy kwātsiamu, kitota. Noqw pay God unaṅwtalwuwniat aniwniy akw súantaqey mahtakni’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ura Jesus kitsókinawit suswuhaq k̇ātataypit tumalta. Noqw as pi panhtiqw, paṅ sinom nāp tunatyay aṅqw qa hin lasyaniqey pan unaṅwtoti. Noqw ōviy pam pumuy qöhqöytiva, ");
INSERT INTO hopNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","22","Nihqe paṅqawu: Is ohi, úmaa, Chorazin ep sínomu! Is ohi úmaa, Bethsaidat ep sínomu! Taq nu as umuhpa’ qatsá’ k̇ātatayhpit tumaltaqw uma nāp umuhtunatyay aṅqw qa lasya. Nu umumi paṅqawni: Hisat hin yukiltiniqat aw pituqw, umuṅem pas is óhini! Pep pu’ imuy Tyre ep sinmuy amuṅem‐nik̇aṅw pu Sidon ep sinmuy amuṅem umuhpenihqe pay soon pas nuhtsel’ewayni. Pi nu as pumuy amuhpa’ hisat k̇ātatayhpit tumaltaqw, puma soon qa anahaat yūyaht, qöhtsaptsomova yesvani; pan puma namtaknayani nāp tunatyay aṅqw lasyaniqeyu. ");
INSERT INTO hopNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Noqw úmaa, Capernaum ep sínomu, ya uma ōmiq nātsok̇aya? Uma nāt maskimiq maspiwyani. Taq nu as qatsá’ k̇ātatayhpit umuhpa’ tumaltaqw, uma qa tuptsiwya. Noqw kurs as nu Sodom‐kitsókit ep pan tumaltaqw, puma inumi tuptsiwyaniqw, kitsókiam nāt pewhaqami pahsavo wúnuni. ");
INSERT INTO hopNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Noqw nu umumi paṅqawni: Hisat hin yukiltiniqat aw pituqw, pep pu’ Sodom ep sinmuy amuṅem umuhpenihqe pay soon pas nuhtsel’ewayni. ");
INSERT INTO hopNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ep pu’ Jesus lavayhtiqe paṅqawu: Kwakwhay Inaa, ōveqatsit aw‐nikaṅw pu tūwaqatsit aw Tutuyqawhqa. Kwakwhat pi um īit yantaqat aṅ wuwni’yuṅqamuy, pu qaūunatuy amumi tupki’k̇aṅw, titipostuy amunyuṅqamuy amumi put mahtakna. ");
INSERT INTO hopNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pantani, Inaa, pam hapi uṅniqw súanta. ");
INSERT INTO hopNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sohsoy himu Inay aṅqw inumi noiwa. Noqw hakiy God Tíyatnihqat qa hak navoti’ta, pas Náat‐saa; piw qa hak Naat hákiynihqat navoti’ta, pas nu’ put Tiat‐saa, pu Tiat hakiy aw put mahtaktaniqw pam pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Huvam sohsoyam pew inumiyaa, uma aṅ hihta akw maqsoni’yuṅqamu, pu putuiwyuṅqamu; nen uma inumi yank̇ahk̇aṅw nānasuṅwnayani. ");
INSERT INTO hopNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uma itumalsuṅwamatniwhtote’, inuhpiy tuwi’vayani; pi nu nānakwhani’k̇aṅw, okiw’unaṅway’ta. Nen uma umu’naṅwpeq uyiwaltotini. ");
INSERT INTO hopNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pi itumalṅöṅönpi qa anahaa, pu iikwilni umuṅem qa pútuni. ");
INSERT INTO hopNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Noqw Jesus nasuṅwintalöṅnit ep söhövos’uyit aṅ yámakto; noqw put aw nánatuwnayaqam tsöṅso’qe talayat mawtiwisk̇ahk̇aṅw put nōnoptiwisa. ");
INSERT INTO hopNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Noqw Pharisee‐sinom amumi yórikyaqe, Jesus aw paṅqaqwa: Meh, ūmi nánatuwnayaqam nasuṅwintalöṅnit ep hihta mewniwtaqat hintsatsk̇a. ");
INSERT INTO hopNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Noqw pam amumi paṅqawu: Ya ura David suṅwámuy amumum tsöṅmokqe hinhtiqw uma put aṅ qa tuṅwáya? ");
INSERT INTO hopNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ura pam Tutuyqawhqat kīyat aw pákihqe pölavikit God aw noiwhqat sowa. Ura soon nāp hak put aṅqw nösṅwu, pas God awwat momṅwit‐saa. ");
INSERT INTO hopNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hal ya uma tutavot aṅ it qa tuṅwáya, ura God awwat momṅwit put kīyat ep nasuṅwintalöṅnit qa hihtatotat pay qa hinhtoti? ");
INSERT INTO hopNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Noqw nu umumi paṅqawni: Suhk̇a Tutuyqawhqat kīyat epnihqe pas pávannihqa yep’e. ");
INSERT INTO hopNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ura yan pey’ta: Uma tūookwatuwyaniqat nu put tuṅlay’ta; noqw uma soq hom’oyit‐sa inumi noaya, yan’i. Noqw kurs uma put māmatsye’, soon hakimuy qa hihta ep qaanhtotiqamuy tukopnayani. ");
INSERT INTO hopNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pi nu’ Sinot Tiat hikis pi nasuṅwintalöṅnit aw moṅwi. ");
INSERT INTO hopNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pu pam paṅqw ahpiynihqe, pumuy tsotsvalkiyamuy aw paki. ");
INSERT INTO hopNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Noqw meh, hak tāqa lakput may’taqa pep nuhtuma. Noqw momṅwit hihta ep put nēveltoyanyaniqe ōviy put tūviṅtotaqe aw paṅqaqwa: Ya pay hak nasuṅwintalöṅnit ep hakiy qalaptsinaniqw pam súanta? kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Noqw pam pumuy amumi paṅqawu: Kurs haqawa umuṅaqw sūkw kanelvokoy’taqw, pam nasuṅwintalöṅnit ep haqami hötsit aqw posq, ya pam put qa paṅqw hóroknani? ");
INSERT INTO hopNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Noqw puyaw sino kanēlot epnihqe qa pas himuu? Paniqw ōviy hak nasuṅwintalöṅnit aṅ lolmat hintsakniqw pam súanta. ");
INSERT INTO hopNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pahsat pu pam tāqat aw paṅqawu: Uhmay tsihkwaa! Noqw pam put tsihkwa; noqw pam ayaṅqwat māyat an pās powalti. ");
INSERT INTO hopNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pahsat pu Pharisee‐sinom aṅqw ahpiyyaqe, hin as put nīnayaniqey ankiwakw yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Noqw pay Jesus put navoti’taqe paṅqw ahpiy’o. Noqw qaan’ewakw hintaqam sinom put aṅkya; noqw pam sohsokmuy tūtuyyaqamuy qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nihqe puma put qa tunvotnayaniqat pam amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yan Tutuyqawhqat lavay’ayayat Esaias hin lavayhtiqat aw antsaniwa; pam ura paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Kurs huvam itumal’ayay inamoray aw yórikyaa. Put hapi nu aw unaṅway’ta; nu put pas hahlayi. Nu put aw ihikwsiy távini. Noqw pam imuy qa‐Jew‐sinmuy amumi haqe’ súanhintaqat mahtaknani. ");
INSERT INTO hopNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pam qa nāṅwuy’tani; piw qa tsa’tinumni. Soon hak put tönayat kitpik navotni. ");
INSERT INTO hopNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pam hopaqat muhtsikput soon qöhiknani; pu wihqöhit híhin uwiwitaqat soon pam tōk̇ani. Hisat súanqatsit tūwaqatsit aṅ ahsupoq kúrukmaqw, paṅso pahsavo pam pan hinmani. ");
INSERT INTO hopNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Noqw ima qa‐Jew‐sinom put aw yanyuṅwni. Yan ura pey’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Noqw pahsat pu hak nukpanhikwsit akw tuyqawiwtaqa qapostalk̇aṅw qayuáataqat put aw wikvaya. Noqw pam put qalaptsinaqw, ōviy pam yuaaykuk̇aṅw pu pōsiy tālawna. ");
INSERT INTO hopNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Noqw sinom sohsoyam k̇ātayuṅqe paṅqaqwa: Ya qa i’ David Tíata? ");
INSERT INTO hopNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Noqw pay Pharisee‐sinom put nanaptaqe paṅqawu: I’ nukpanhihikwsimuy moṅwíyamuy Beelzebub aw yank̇aṅw nukpanhihikwsimuy nuhtuṅaqw ipwanta. ");
INSERT INTO hopNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Noqw Jesus pumuy wuwniyamuy mātsi’taqe, amumi paṅqawu: Haqam moṅwtunatya nehpewhtiqa soon qa kīqötini; pu kitsóki, sen kīvit nehpewhtotiqam soon hoṅni. ");
INSERT INTO hopNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Noqw kurs Satan ayo nāhorokne’, pam pep nehpew’iwtani; noqw pahsat pu moṅwtunatyaat hin wúnuni? ");
INSERT INTO hopNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Noqw kurs nu Beelzebub aw yank̇aṅw nukpanhihikwsimuy ipwantaqw ya umumi nánatuwnayaqam hakiy aw yank̇ahk̇aṅw pumuy ipwantota? Ason puma umuy atsáṅhkiye’, umuy suhputsnayani. ");
INSERT INTO hopNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nīk̇aṅw kurs nu God Hikwsiyat öqalayat aw yank̇aṅw pumuy ipwantaqw, pay hapi pas God moṅwtunatyaat umumi pitsíwiwta. ");
INSERT INTO hopNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ya sen hin hak hakiy a’nö hoṅvit kīyat aw pak̇e’ hihta himuyat put aṅqw nawhkini? Pam mohti put some’, pahsat pu pam put kīyat kīqötani. ");
INSERT INTO hopNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Qa inumumnihqa hapi inuhpew’iwta; pu qa inumum tsovalantaqa tatslakinta. ");
INSERT INTO hopNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Paniqw ōviy nu umumi paṅqawni: Hak hihta ep qaanhtiniqw, sen nuhtumiq hiṅqawniqw, pam pantaqa put ahpiy ayo yukiwmantani. Nīkaṅw hak haqam Qahováriwtaqat Hikwsit aqw hiṅqawniqw, pam pantaqa pas soon hisat put ahpiy ayo yukiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pu hak haqam nuy Sinot Tiyat aqw hiṅqawhq pay pam put ahpiy ayo yukiltini. Nīk̇aṅw hak haqam Qahováriwtaqat Hikwsit aqw hiṅqawhq pam pas soon hisat put ahpiy ayo yukiltini, it qatsit ep’e, pu qatsit nātoniqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Hak lolmat sipaltsokit ūye’, lomasipalat aniwnaṅwu. Pu hak sipaltsokiy aw qa tunatyawtaqw, pam nukushinhte’, qalomásipalat aniwnaṅwu. Pi sipaltsoki aniwniy akw mātsiwtaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Is uti, uma hakim tsūtsu’tuy amunyuṅqamu! Ya uma hin qalomátunatyay’k̇ahk̇aṅw hihta lolmat yuaatotani? Pi hakiy unaṅwpeq himu ohpokiwtaqw, put hapi hakiy moat yuaataṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lolmat tunatyawtaqa sino unaṅwṅaqw hihta lolmat nȫṅantoynaṅwu. Pu qalomátunayawtaqa sino piw unaṅwṅaqw hihta qalolmat nȫṅantoynaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Noqw nu umumi paṅqawni: Sinom hihta an’ewakw lavayhtote’, hisat hin yukiltiniqat aw pituqw, pep pu’ nawus nenṅem hin lavayhtotini. ");
INSERT INTO hopNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pi God hakiy lavayiyat ep hakiy hin yukynani, sen put súantaqat paṅqawni, sen qasúantaqata. ");
INSERT INTO hopNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Noqw pahsat pu hakim tutavot tūtutuqaynayaqam Pharisee‐sinmuy amumum aw lavayhtotiqe paṅqaqwa: Tūtutuqaynaqa, um as k̇ātatayhpit hihta tuawi’taqat itamumi mahtaknani. ");
INSERT INTO hopNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Noqw pam lavayhtiqe amumi paṅqawu: Ima pu’ qatsívaptsiwyuṅqam nukpansinomu, tusk̇apsinomu. Puma k̇ātatayhpit hihta tuawi’taqat aw yórikyaniqey nānawakna. Nīk̇anw pay puma soon k̇ātatayhpit aw yórikyani, hal pas sūkw k̇ātatayhpit‐saa. Pam Tutuyqawhqat lavay’ayayat Jonas qatsiyat ep hiniwhtiqat an aw yukiltini. ");
INSERT INTO hopNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ura Jonas wukovakiwuy ponoveq pāyis tālat aṅ‐nik̇aṅw pu pāyis tōkilat aṅ pakiwta. Noqw pay pan piw nu’ Sinot Tiat tutskwat ahsonve pāyis tālat aṅ‐nik̇aṅw pu pāyis tōkilat aṅ pakiwtani. ");
INSERT INTO hopNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Hisat hin yukiltiniqat aw pituqw, Nineveht aṅqw sinom pu’ qatsívaptsiwyuṅqamuy amumum hoṅve’, pumuy qatuptsiwniyamuy ep suhputsnayani; ispi Jonas pumuy amumi yuaaykuqw, puma nāp tunatyay aṅqw lasyaq’ö. Noqw meh, Jonas epnihqe pas pávannihqa yep umumum wunu. ");
INSERT INTO hopNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hisat hin yukiltiniqat aw pituqw, tatk̇aqw móṅwi‐wuhti pu’ qatsívaptsiwyuṅqamuy amumum wunupte’, pumuy qatuptsiwniyamuy ep suhputsnani; ispi pam Solomon a’no wuwniyat aw tūqaytaniqe ōviy tūwaqalṅahaqaqw put aw pitu. Noqw meh, Solomon epnihqe pas pávannihqa yep’e. ");
INSERT INTO hopNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tuyoy’eway hikwsi sinot aṅqw yámak̇e’, haqe’ qa pay’taqat aṅ hinnumṅwu, haqam nāsuṅwnaniqe ōviy’o; nit qa túwaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nen pahsat pu paṅqawṅwu: Han pi pay nu ikiy aṅqw yámakqey aw áhoy’i, kítaṅwu. Pu pam ep pituqw qa hak epniqw, pās maspiwtaqw, aṅ himu lomahinyuṅqw, pantaqat yórikṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nen pahsat pu pam ahpiynen, pētuy tsáṅe’nihqamuy hīhikwsimuy nahpenihqe pas nūnukpantuy aw tsamṅwu; noqw puma aw yuñe’ pep ki’yuṅṅwu. Noqw hakiy qatsiat aṅknihqa mohtiwat epnihqe pu’ pas qalomáhinhtiṅwu. Noqw pan hapi imuy pu’ qatsivaptsiwyuṅqamuy qalomáhinyuṅqamuy amuṅem hintani. ");
INSERT INTO hopNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Noqw nāt pam sinmuy amumi yuaataqw, meh, put tupkomat yuyat amum ihpaq hoṅk̇ahk̇aṅw, put aw yuaaykuyaniqey nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Noqw haqawa put aw paṅqawu: Meh, uhtupkom uṅuy amum ihpaq hoṅk̇ahk̇aṅw, ūmi yuaaykuyaniqey nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Noqw pam lavayhtiqe, put āawnaqat aw paṅqawu: Noqw ya hak íṅuu? Pu ya hakim itupkomya? ");
INSERT INTO hopNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pu pam put aw nánatuwnayaqamuy amumi māmasat, paṅqawu: Huvam iṅuy, pu itupkomuy amumi yórikyaa. ");
INSERT INTO hopNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pi hak haqam Inay ōveqatsit ep qátuhqat tunatyayat aṅ hinmaqa hapi itupko, pu isiwa, pu iṅuu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Noqw ép tāwat ep Jesus kīṅaqw yámakqe, wuhkovatuphat qalaveq qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Noqw qaan’ewakw hintaqam sinom put aw tsovalti. Noqw ōviy pam pākihut aqw pákihqe pepeq qatuptu; noqw sinom sohsoyam pāhut qalavaqe hōñi. ");
INSERT INTO hopNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Noqw pam tūtuwutsit akw pumuy hīhihta tutuqaynaqe amumi paṅqawu: Meh, hak tāqa uyto. Poshumit tsálakintaniqe pan uylawu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Noqw pam uylawhq, pēhu poshumi pöhpava löhö; noqw masay’yuṅqam ökihqe, aṅ put soswa. ");
INSERT INTO hopNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Noqw pēhu pik̇aqlöva qa pas pisay’taqat aṅ löhö; nihqe pay suhkuyva, aṅ tutskwa qa pȫṅalaniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nit tāwat yamakq, pay kólaki; noqw pay pi pam qa ṅay’yuṅqe ōviy aṅ tsakya. ");
INSERT INTO hopNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Noqw pēhu kutqölpa löhö; noqw kūta aṅ kuyvaqe put lakna. ");
INSERT INTO hopNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Noqw pēhu lolmat tutskwat aṅ löhökqe hihta aniwna; pēhu tsivót‐sikip sunat aw hóyokput aniwna, pu pēhu payhp sunát‐sikipo, pu pēhu sunat pakwt sihk̇ay’tasikipo. ");
INSERT INTO hopNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tuqayvastotaa! Pi uma naqvuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Noqw put aw nánatuwnayaqam put aw ökihqe, aw paṅqaqwa: Ya um hinoqw pumuy amumi tūtuwutsit akw yuaata? ");
INSERT INTO hopNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Noqw pam lavayhtiqe amumi paṅqawu: Oveqatsit aṅqw moṅwtunatyat ahpiy navoti tupkiwta pew pahsavoo. Nīk̇aṅw pu’ hapi pam umumiwat susmataq’a; nīk̇aṅw ímuywatuy qatuptsiwni’yuṅqamuy amumi qa mahtaq’a. ");
INSERT INTO hopNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pi hihta himuy’taqat hapi aw piw noiwni; noqw pam hóyokiwtaqat himuy’tani; noqw pay ṅastanihqat hikis pi hihta himuy’taqw pam put aṅqw nawhkiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Paniqw hapi ōviy nu pumuy amumi tūtuwutsit akw yuaata, puma as aw tayk̇ahk̇aṅw qa tutwaqw ōviy’o, pu tūqayk̇ahk̇aṅw qa nanapta, pu qa māmatsya. ");
INSERT INTO hopNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Noqw pumuy hapi amuhpe Esaias nāt hintaniqa lavayiat aw antsaniwa. Ura pam Tutuyqawhqat eṅem yan lavayhti: Uma as aw tūqayk̇ahk̇aṅw nanaptat, qa māmatsyani; pu uma as aw tayk̇ahk̇aṅw tutwat, qa māmatsyani. ");
INSERT INTO hopNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Pi imuy sinmuy unaṅwaam pās tunaiwyuṅwa, pu naqvuam qa nanvotya, pu puma uviyuṅwa, nāp hisat pi k̇a puma pōsiy akw tutwak̇aṅw, naqvuy akw nanaptak̇aṅw pu unaṅway akw māmatsye’, inumi ahoy nánamtök̇aqw, nu pumuy qalaptsinani, kita. ");
INSERT INTO hopNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nīk̇aṅw uma hapi hahlayhpit epya, ispi umuhposi tālat aw tāyuṅqw ōviy’o, piw umuhnaqvuy aṅ hötsíltoti. ");
INSERT INTO hopNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nu umumi pas antsa paṅqawni: Pas as k̇aysiwhqam Tutuyqawhqat lavay’aymatniqw, pu súanhinwisqam umuy hihta aw yórikyaqat as aw yórikyaniqey nānawaknak̇aṅw hapi qa aw yórikya, pu umuy hihta nanaptaqat as nanaptanik̇aṅw qa nanapta. ");
INSERT INTO hopNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kurs huvam tuqayvastotaa. I’ tūwutsi hihta tuawi’taqat uma nanaptani. ");
INSERT INTO hopNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hak haqam moṅwtunatyat ahpiy lavayit navotk̇aṅw, put qa māmatsq, pahsat pay Nukpana aw pite’, put unaṅwpeq lavayit ūyiwhqat paṅqw ipwaṅwu. I’ hapi pöhpava yēvayaqat anta. ");
INSERT INTO hopNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pu i’ pik̇aqlöva yēvayaqa hapi it hakiy anta. Hak lavayit navote’, hahlayk̇aṅw āpiy put kwúsuṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Noqw pay lavayi hakiy unaṅwpeq qa ṅay’taqw, pay ōviy as pam hihsavo aṅ kuytaṅwu. Nīk̇aṅw ason lavayit ep k̇ānanvotpit, pu okiwsahsaniwuy aw pituqw, hihsavoniqw pay pam sóonhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pu i’ kutqölpa yēvayaqa hapi it hakiy anta. Hak lavayit as navotat, yep qatsit‐sa aw tunatyalte’, pu k̇āhakiwuy tuṅlay’k̇aṅw put akw ūnatiqe, soq lavayit qa aw tunatyaltiṅwu. Noqw ōviy lavayi put ahsonve qa hihta aniwnaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pu tuwat i’ lomatutskwat aṅ yēvayaqa hapi imuy amunta. Hakim lavayit nanapte’, māmatsyaṅwu. Noqw lavayi wuṅwe’, hihta aniwnaṅwu, pēhu tsivót‐sikip sunát‐sikip hóyokput himuy’vaya; pu pēhu payhp sunát‐sikipo, pu pēhu sunat pakwt sihk̇ay’tasikipo. ");
INSERT INTO hopNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Pu pam piw tūwutsit hihta tuawi’taqat akw pumuy tutuqaynaqe amumi paṅqawu: Oveqatsit aṅqw moṅwtunatya hapi hak pāsay aṅ lomavoshumit uyhqat anta. ");
INSERT INTO hopNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Noqw pam puwhq, put tuwqaat pítuhqe, söhövosit amuhtsava söhövostusaqat uyht, ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Noqw ūyi nahpi’vaqe talay’vaqw, pahsat pu söhövostusaqa piw mātaqti. ");
INSERT INTO hopNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Noqw ōviy ki’taqat tumal’aymat put aw ökihqe, aw paṅqawu: Moṅwi, ya um as qa lomavoshumit uhpasay aṅ ūya? Noqw pam haqam söhövostusaqata? ");
INSERT INTO hopNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Noqw pam pumuy amumi paṅqawu: Pay ituwqa panhti. Noqw tumal’aymat put aw paṅqaqwa: Noqw itam awye’, aṅ tsovalayaniqat um nāwakna? ");
INSERT INTO hopNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Noqw pam pumuy amumi paṅqawu: Qae, taq k̇a uma söhövostusaqat aṅ tsovalantote’, söhövosit énaṅyani. ");
INSERT INTO hopNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pay pi hāk aṅ sohsoy wúṅwiwmani hisat tsovalaniwniqat aw pahsavoo. Noqw ason höqyaniqw, pep pu’ nu höqyaniqamuy amumi paṅqawni: Uma aṅ söhövostusaqat mohti tsovalayani, nen put somhtotat taqtsokyani; pu’ ason uma söhövosit ikoyohkiy aw taṅatotani. ");
INSERT INTO hopNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Pu piw pas sukw tūwutsit akw amumi yuaaykuqe paṅqawu: Oveqatsit aṅqw moṅwtunatya mustard‐uyit sivosiyat anta. Put hak pāsay ep ūya. ");
INSERT INTO hopNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pam pas sohsok hihta pōvoshumit amuṅaqw sushihsay’o; nīk̇aṅw pam wuṅwe’, sohsok tusaqtsotskit amuhpenihqe suswuyoqtiṅwuniqe pas himutskiniwhtiṅwu. Noqw ōviy súmawuy aṅ masay’yuṅqam ök̇e’, put nantaqayat aṅ yesvaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pu piw pam sukw tūwutsit akw pumuy amumi yuaaykuqe paṅqawu: Oveqatsit aṅqw moṅwtunatya pēk̇enit anta; put wuhti kwúsuhqe, payhp tuwanit ṅumnit enaṅ namiqwrilaṅwu; noqw pam sohsok put pēk̇enaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iit yantaqat sohsok Jesus sinmuy amumi tūwutsit akw yuaata; nihqe pam tūwutsit qa akw yuaatanik, pay amumi qa yuaataṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yan Tutuyqawhqat lavay’ayaat hin lavayhtiqa aw antsaniwa; pam ura paṅqawu: Nu tūwutsit hihta tuawi’taqat akw yuaatani; nu tūwaqatsit hisat yukiltiqat aṅqaqw hihta tupkiwyuṅqat paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pahsat pu Jesus sinmuy aṅqe’ hōnat, kīmi paki. Noqw put aw nánatuwnayaqam aw ökihqe, aw paṅqaqwa: Um as söhövostusaqat hihta tuawi’taqat itamuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Noqw pam hu’waqe amumi paṅqawu: I’ lolmat poshumit uyhqa hapi nūu, Sinot Tíata. ");
INSERT INTO hopNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Noqw pāsa hapi yep qatsi. Lomavoshumi hapi moṅwtunatyat aṅqw sinoiwtaqamu; noqw sohövostusaqa hapi hakiy qalolmat sinomatu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Pu tuwqa, pumuy uyhqa hapi i’ Nukpana; yep qatsit so’ṅwamiq pituqw, pahsat pu höhöqsattiqat antani, noqw aṅ tsovalayaniqam hapi ōveqatsit aṅqw hoṅvia’yamu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Noqw ōviy hapi söhövostusu tsovalaniwht, qȫhit akw taqtsokiwhq, pay pan hapi yep qatsit so’ṅwaveq hintani. ");
INSERT INTO hopNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nu Sinot Tiat ihoṅviaymuy ayataqw, puma imoṅwtunatyay aṅqw sohsokmuy lasnayaqamuy, pu qaanhinwisqamuy tsovalayani; ");
INSERT INTO hopNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nen pumuy qöpqömiq qȫhit aqw maspayani. Pep a’nö tsaykitiwni, pu tama ṅuritiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Noqw pep pu’ hakim súanyuṅqam Nay moṅwtunatyayat ep tāwat an tālawṅway’yuṅwni. Tuqayvastotaa! Pi uma naqvuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Pu i’ pīwu: Oveqatsit aṅqw moṅwtunatya himu a’nö hihk̇ay’taqat pasve tupkiwtaqat anta. Put hak tāqa túwahqe, ahoy amht, put ep kwaṅwtoynaqe, ahpiynihqe sohsok hihta himuy húyahqe, put pāsat tui. ");
INSERT INTO hopNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Pu i’ pīwu: Oveqatsit aṅqw moṅwtunatya hakiy huhyaqat lolmat pearl hepnumqat anta. ");
INSERT INTO hopNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pam hak sūkw pearl pas a’nö hihk̇ay’taqat túwahqe, ahpiynihqe sohsok hihta himuy húyahqe, put tui. ");
INSERT INTO hopNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Pu i’ pīwu: Oveqatsit aṅqw moṅwtunatya pakiwmaktutsayat anta. Pam wuhkovatuphamiq tūviwhqe, sohsok hinyuṅqamuy pāvakiwhtuy inhta. ");
INSERT INTO hopNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Put aw ohpokq, puma pāhut qalavoq put láṅaknayaqe, pep yesvat, pu aṅ nūnukṅwatuy pāvakiwhtuy hihta aqw taṅatotat, pu pay hin’ewakwmuy maspayaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Noqw pan hapi hintani yep qatsit so’ṅwaveq’a. Oveqatsit aṅqw hoṅvia’yam nankwuse’, aṅ nūnukpantuy lomasinmuy amuṅaqw tsīk̇ayani, ");
INSERT INTO hopNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nen pumuy qöpqömiq qȫhit aqw maspayani. Pep a’nö tsaykitiwni, pu tama ṅuritiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pu Jesus pumuy amumi paṅqawu: Ya uma īit sohsok māmatsya? Noqw puma aw paṅqaqwa: Owi, Tutuyqawhqa. ");
INSERT INTO hopNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Noqw pam pumuy amumi paṅqawu: Sohsoyam tutuvenit tuwi’yuṅqam ōveqatsit aṅqw moṅwtunatyat ahpiy tutaqayhpit tuwi’vayaqam hapi hakiy k̇ahaktaqat anyuṅwa. Puma tutuvenit aṅqw hisattutuqayhpit sinmuy tutuqaynaya, pu pūhut tutuqayhpit pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Noqw Jesus yan tutuqaynaqey yukut, paṅqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Noqw pam nāp kitsókiy ep pítuhqe, pumuy tsotsvalkiyamuy aṅ pumuy tutuqayna. Noqw put aw tūqayyuṅqam aw k̇ātayyuṅqe, nātuviṅlalwaqe paṅqaqwa: Ya sen i’ haqaqw it wuwantuwit makiwa? Is uti, pu it k̇ātutmalat haqaqw öqalmakiwa? ");
INSERT INTO hopNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ya qa i’ wunavutsit tumaltuwi’taqat tíata? Ya yuat qa Mary yan mātsiwa, pu put tupkomat James‐niqw, pu Joses‐niqw, pu Simon‐niqw, pu Judas. ");
INSERT INTO hopNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pu siwamat, ya qa puma sohsoyam itamumya? Noqw ya sen i’ haqaqw īit hihta makiwa? kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nihqe puma put ep qaan’unaṅwtoti. Noqw Jesus pumuy amumi paṅqawu: Pay pi Tutuyqawhqat lavay’ayaat sohsovik k̇aptsi’tiwṅwu, hal pay nāp kitsókiy‐sa ep’e, pu pas nāp kiy ep pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Noqw puma qa tuptsiwni’yuṅqw, ōviy pay pam pep qa a’nö hihta tumalta. ");
INSERT INTO hopNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Noqw ephaqam Moṅwi Herod Jesus hihta hintsakqat navota; ");
INSERT INTO hopNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nihqe tumal’aymuy amumi paṅqawu: I’ John kūyit akw tūtuvoylalawṅwuqa. Pas hapi pay pam hakton mokiwuy aṅqw ahoy tātayi; nihqe ōviy k̇ātatayhpit hintsaki. ");
INSERT INTO hopNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod pi nȫmay Herodias unaṅwve hinhtiniqe, hakimuy ayataqw, puma John ṅuayaqe somyat, sivikimi panaya. Ura Herod tupkoy Philip nömanawhki. ");
INSERT INTO hopNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Noqw John Herod aw paṅqawu: Soon as um uhtupkoy nömanawhkinik̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Noqw pam as put nīnaniqey anhtik̇aṅw, piw sinmuy maqasti; puma put Tutuyqawhqat lavay’ayayatnihqat pan aw tāyuṅqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Noqw Herod tihtiwhpuyat aw pituqw, pam nōviwhqat aw k̇aysiwhqamuy sinmuy tūtsama. Noqw pumuy nōnovaqw, Herodias tiat māna ep pákihqe, pumuy amuhpewi wunimaqw, Herod put aw nahyoṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Noqw ōviy pam pas öqalat pasiwniy akw put aw paṅqawhqe, pam nāp hihta ōviy tūviṅtaqw put máqaniqey aw paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Noqw pam yuy tutavoyatnihqe put aw paṅqawu: Um kūyit akw tūtuvoylalawhqat John qötöyat tsaqaptat ep íniwtaqat nuy máqani. ");
INSERT INTO hopNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Noqw pas as Moṅwi qahahlayhtik̇aṅw, pay nuṅwu pas aw qaöwílvayhtiqe, nawus put máqaniqey paṅqawu, ispi k̇aysiwhqam sinom put amum yesqam lavayiyat nanaptaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nihqe hakiy ayataqw, pam sivikiminihqe, John qötöyat ayo tuku; ");
INSERT INTO hopNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nihqe put qötöyat tsaqaptat ep íniwtaqat kwusivaqe, mānat aw tavi; noqw pam put yuy aw yawma. ");
INSERT INTO hopNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Noqw put aw nánatuwnayaqam ökihqe, tokoyat haqami amwisa; nit ahpiyyaqe, Jesus āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Noqw Jesus put navotqe, pay nāla pākihut akw haqamii, haqam pas qa hak waynumqat paṅsoo. Noqw sinom put nanaptaqe hāhaqaqw kitsókit aṅqw nāp put aṅkya. ");
INSERT INTO hopNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Noqw Jesus paṅqw yámakqe, qaan’ewakw hintaqamuy sinmuy tuwa; nihqe pumuy ōkwatuwhqe, pumuy amuṅaqw tūtuyyaqamuy qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Noqw tapkiwmaqw, put aw nánatuwnayaqam put awyaqe aw paṅqaqwa: Yep qayēsiwhq, pas hapi hísatniqwti. Um as sinmuy hōnaqw, puma aṅqe’ kitsókiva nankwuse’, nenṅem hihta tunöstuy’yani. ");
INSERT INTO hopNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Noqw pay Jesus pumuy amumi paṅqawu: Soon as puma ahpiyyani. Uma nopnayani. ");
INSERT INTO hopNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Noqw puma put aw paṅqaqwa: Itam panis tsivot pölaviki’yuṅwa, pu lȫqmuy pākiwhtuyu. ");
INSERT INTO hopNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Noqw pam paṅqawu: Pew kiwisaa. ");
INSERT INTO hopNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pu sinom tūsaqat aṅ yesvaniqat pam amumi paṅqawu, nit pu pam tsivot pölavikit ömahtat, pu pākiwhtuy kwusut, pu ōmiq tayk̇aṅw, put ep God aw hahlayhti; nit yōṅoytat, put aw nánatuwnayaqamuy amumi put oya; noqw puma sinmuy amuhpa’ o’ya. ");
INSERT INTO hopNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Noqw puma sohsoyam nȫnösaqe ȫöya; noqw puma akwsiṅwqat yōṅoyhput pölavikit tsovalayaqe, pakwt lȫq sihk̇ay’taqat hoaput aṅ opomnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Noqw nȫnösaqam tsivót‐sikip sōmorit pahsa’haqam tahtaqtya, noqw pu momoyam‐niqw pu tsātsayom pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pahsat pay Jesus put aw nánatuwnayaqamuy pākihut aqw yuñe’, pay ahsavo wuhkovatuphat ayoqwatyaniqat pumuy tusoq’ayata nāto pam sinmuy niman’ayalawhqee. ");
INSERT INTO hopNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Noqw pam sinmuy hōnat, nāwaknaniqe nāla tsomomiq’a; nihqe mihikq, pam pepeq súnalaa. ");
INSERT INTO hopNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Noqw pahsat pākihu wuhkovatuphat nāsaveq hinnumk̇aṅw, pāhut wuṅwnuptuqat akw wawaöklawu, amuhpewi hūhukq ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Noqw talhahayiṅqw, Jesus pāvaqe waymak̇aṅw pumuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Noqw put aw nánatuwnayaqam put pāvaqe waymaqw tutwaqe, tsātsawnaqe paṅqaqwa: Pam tualaṅw’u, kitota; nihqe tsātsawnaqe a’nö hiṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Noqw pahsat pay Jesus pumuy amumi lavayhtiqe, paṅqawu: Uma qa hin unaṅway’yuṅwni; pay nūu; uma qa tsawiniwyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Noqw Peter lavayhtiqe aw paṅqawu: Tutuyqawhqa, kurs pay pas umnen, nuy pāvaqe ūminiqat um paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Noqw pam paṅqawu: Pew’i. Pahsat pu Peter pākihut aṅqw yámakqe, Jesus aw pāvaqe wayma. ");
INSERT INTO hopNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nit pas a’nö hūhukq pam navotqe pahsat pay tsawna, nihqe pakitoqe a’nö paṅqawu: Tutuyqawhqa, nuy ayo távii. ");
INSERT INTO hopNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Noqw Jesus pahsat pay put aw māvuyaltiqe ṅuat, aw paṅqawu: Is okiw um öwituptsiwni’taqa, ya um hinoqw pēvewinhti? ");
INSERT INTO hopNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Noqw puma pākihut aqw pakiqw, hūk̇aṅw qe’ti. ");
INSERT INTO hopNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Noqw ima pākihut aṅqw taṅawtaqam Jesus aw ökihqe, pas hihtatotaqe aw paṅqaqwa: Kurs um pas antsa God Tíata. ");
INSERT INTO hopNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pu puma ayoqwat nöṅakqe, haqam tutskwat Gennesaret aw öki. ");
INSERT INTO hopNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Noqw pep sinom put pituqw nanaptaqe, pep aṅqe’ tutskwat aṅ ahsupoq hakimuy ayatotaqe, sohsokmuy tūtuyyaqamuy put aw tsamvaya; ");
INSERT INTO hopNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nihqe pay ṅas’ew puma put yuwsiyat qalavaqe nömökput aw tóṅokyaniqey put aw nānawakna, noqw hakim hihsa’nihqam put aw tóṅokyaqam pās qalaptuya. ");
INSERT INTO hopNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pahsat pu hakim tutavot tūtutuqaynayaqam Pharisee‐sinom amumum Jerusalem aṅqwyaqam Jesus aw ökihqe aw paṅqaqwa: ");
INSERT INTO hopNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ya hinoqw ūmi nánatuwnayaqam wūwukwmuy navotiyamuy qaanhinwisa? Oviy pi puma nōnovanik qa māvaqtotaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Noqw pam lavayhtiqe, amumi paṅqawu: Noqw ya hinoqw ōviy piw uma umuhnavotiy akw God tutavoyat qahihtatota? ");
INSERT INTO hopNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pi God tutaptaqe paṅqawu: Um unay, pu uṅuy pumuy k̇aptsi’tani. Pu hak nay, pu yuy pumuy qalomálavayhtiqa pas pay mokmantani, ura kita. ");
INSERT INTO hopNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Noqw úmawat paṅqaqwa: Hak nay, pu yuy pumuy amumi paṅqawni: Nu as umuy hihta akw paaṅwanik̇aṅw, God aw put sohsok noa, kite’, pay tutavot aṅqw mātaviwṅwu, uma kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nen pam pumuy paaṅwaniqey qe’tik̇aṅw, pay qa hihta ep qaanhtiniqat uma kitota. Yan uma God tutavoyat ayo yuykuya, umuhnavotiy akw’a. ");
INSERT INTO hopNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Uma nawip’ew hinyuṅqamu, pas pi ōviy Esaias Tutuyqawhqat lavay’ayaat umuy súaṅqawhqe paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ima sinom moay akw inumi ökiwta, pu lavayiy akw nuy k̇aptsilalwa; noqw pi unaṅwaam inuṅaqw haq’ursvehaq’a. ");
INSERT INTO hopNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Piw haktonsa inumi okiwlalwa. Puma pi sinmuy tutavoyamuy pas antsa tutuqayhpinihqat pan put tūtutuqaynaya, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pu pam sinmuy nāmi wáṅwayhqe, amumi paṅqawu: Inumi tūqayyuṅwaa, nen uma māmatsyani. ");
INSERT INTO hopNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Himu hakiy moamiq pak̇e’, qa pam hakiy tuyoy’ewakwtaṅwu. Pi hakiy moaṅaqw nȫṅataqa hapi hakiy tuyoy’ewakwtaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pahsat pu put aw nánatuwnayaqam put awyaqe aw paṅqaqwa: Ya Pharisee‐sinom it yantaqat nanaptaqe qatsúyhtiqw um qa navota? ");
INSERT INTO hopNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Noqw pam lavayhtiqe paṅqawu: Pay pi Ina ōveqatsit ep qátuhqa himutskit qa uyhq pam himutski ṅáipwaniwni. ");
INSERT INTO hopNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pay pi panyuṅwni. Pay pi puma qapostalyaqam qapostalyaqamuy tsamya. Noqw kurs qapostalqa qapostalqat wīki’maqw, puma nāma haqami pövamiq posni. ");
INSERT INTO hopNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pahsat pu Peter lavayhtiqe, put aw paṅqawu: Kurs i’ lavayi hihta tuawi’taqat itamuy āawnaa. ");
INSERT INTO hopNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Noqw Jesus paṅqawu: Ya uma piw nāt pas qa mātsi’yuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ya himu sinot moayat aqw pak̇e’, ahpiy ponomiq pak̇e’, kwayñave tūviwṅwuqat uma pas nāt qa mātsi’yuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pi himu sinot moayat aṅqw nöṅakqa unaṅwayat aṅqwniṅwu; nihqe pam hapi sinot tuyoy’ewakwtaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pi hak qalomáhintsakqa unaṅwpeq qalomátunatyay’taqey mahtakni’ta. Pam tuqwyantunatyay’ta; nömaqtsit sokoptimaniqey tunatyay’ta; qahopqatsit aṅ hinmaniqey tunatyay’ta; uyiṅwtunatyay’ta; hakiy hihta atsátoynaniqey tunatyay’ta; nuhtumiq hiṅqawlawniqey tunatyay’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hak pan hinmaqa nātuyoy’ewakwtaṅwu. Noqw hak qa māvaqtat, nösqa qa put akw tuyoy’ewayhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pahsat pu Jesus paṅqw ahpiynihqe, Tyre‐nik̇aṅw, pu Sidon pumuy amuqlavohaqamii. ");
INSERT INTO hopNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Noqw meh, hak Canaan‐tutskwat aṅqw wuhti paṅqw yámakqe, put aw tsa’lawhqe aw paṅqawu: Um okiw nuy ōkwatuwni, Tutuyqawhqa, David Tíata! Okiw iti māna nukpanhikwsit akw tuyqawiwtaqe okiwhinta. ");
INSERT INTO hopNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Noqw Jesus put aw qa ṅas’ew hiṅqawu. Noqw put aw nánatuwnayaqam put awyaqe, aw öqaltotiqe paṅqaqwa: Put ahpiy hōnaa; taq pam panis itamuṅk tsa’tinuma. ");
INSERT INTO hopNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Noqw pam lavayhtiqe paṅqawu: Pay nu Israel‐sinmuy amumi‐sa ayatiwa. Puma pi kanelmuy amún haqami hiniwhtotiq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pahsat pu wuhti put awnihqe, aw naokiwhtaqe, paṅqawu: Tutuyqawhqa, okiw inumi unaṅwtavii. ");
INSERT INTO hopNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Noqw Jesus lavayhtiqe, put aw paṅqawu: Pas hapi hak tsātsakwmuy nȫsiwhqamuy nawhkit, put popkotuy amumi maspaniqw, pam qa súanta. ");
INSERT INTO hopNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Noqw pam paṅqawu: Pas antsaa, Tutuyqawhqa, noqw pi popkot moṅwímuy nönöspiyamuy aṅqw hihta piṅput löhöhötaqat nōnovaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pahsat pu Jesus lavayhtiqe, put aw paṅqawu: Is uti um hak wuhti! pas uhtuptsiwni qaöwíewa; pay uṅ hin nāwaknaqw uṅem pantani. Noqw put tiat pay pahsat qalaptu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pu Jesus paṅqw ahpiynihqe, wuhkovatuphat Galileet ep ahoy pitu; nihqe tsomomiqnihqe pepeq qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Noqw sinom qaan’ewakw hintaqam hakimuy qayaktaqamuy, qapostalyaqamuy, qayuáatotaqamuy, qapasíwyuṅqamuy, pu k̇aysiwhqamuy tūtuyyaqamuy put aw tsamvaya; nihqe pumuy Jesus atpipo o’ya; noqw pam pumuy qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Noqw sinom pas k̇ātayuṅwa, imuy qayuáatotaqam yuaaykuyaq’ö, pu qapasíwyuṅqam qalaptuyaq’ö, qayaktaqam nankwusaq’ö, pu qapostalyaqam tālawnayaq’ö; nihqe puma God Israel‐sinmuy Tutuyqawhqayamuy pas hihtatota. ");
INSERT INTO hopNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pahsat pu Jesus put aw nánatuwnayaqamuy nāmi wáṅwayhqe, amumi paṅqawu: Pas nu sinmuy ōkwatuwa, puma pu’ pāyis talqat aṅ inumumyaqw, nȫsiwhqaam súlawhtiq’ö. Noqw soon nu pumuy qa ö́yiwyuṅqamuy hōnani; taq nāp hisat sen puma kiy qa aṅ ökit māmaṅuani. ");
INSERT INTO hopNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Noqw put aw nánatuwnayaqam put aw paṅqaqwa: Kurs pi itam haqam amuptsiwtaqat pölavikit tuiyani? Pi itam qayēsiwhpuveya. Pas k̇a itam soon imuy qaan’ewakw hintaqamuy sinmuy öynayani. ");
INSERT INTO hopNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Noqw Jesus pumuy amumi paṅqawu: Ya uma hihsa’haqam pölaviki’yuṅwa? Noqw puma paṅqaqwa: Tsáṅee, pu piw híkikwmuy pāvakiwhtuyu. Noqw puma pay hiṅsayhohyamu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Noqw sinom tutskwava yesvaniqat pam amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nit pu pam tsaṅe pölavikit ömahta, pu pāvakiwhtuyu; nit put ep God aw hahlayhtit, yōṅoyhtat, put aw nánatuwnayaqamuy amumi put oya; noqw puma sinmuy amuhpa’ put o’ya. ");
INSERT INTO hopNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Noqw sohsoyam nȫnösaqe ȫöya. Noqw puma akwsiṅqat tsovalayaqe, tsaṅe’ hoaput aṅ opomnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Noqw nȫnösaqam nālöp sōmorit pahsa’ tahtaqtya, pu momoyam tsātsakwmuy amumum nāto pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pu pam sinmuy aṅqe’ hōnat, pākihut aqw pakit, Magdala‐kitsókit qalavoq pitu. ");
INSERT INTO hopNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Noqw hakim Pharisee‐sinom Sadducee‐sinmuy amumum ökihqe, Jesus aw tuwantota; pam ōveqatsit aṅqw k̇ātatayhpit hihta tuawi’taqat pumuy amumi mahtaknaniqat aw ö’qalya. ");
INSERT INTO hopNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Noqw pam lavayhtiqe, amumi paṅqawu: Uma tapkiqw paṅqaqwaṅwu: Kurs qāvo kwaṅwqatni, ōviypi tokpela pālaṅwpu, kitotaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pu talavay uma paṅqaqwaṅwu: Kurs pu’ hin sóniwni, ōviypi tokpela pālaṅpu, piw aṅqe’ himu ohpokiwta. Uma nawip’ew hinyuṅqamu, pay as uma tokpelat pitsáṅwayat māmatsyaṅwunik̇aṅw, uma soon qatsi haqe’ qalawmaqat hihta tuawi’taqat māmatsyani. ");
INSERT INTO hopNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Is uma pu’ qatsívaptsiwyuṅqam nukpansinomu, tusk̇apsinomu! Uma k̇ātatayhpit hihta tuawi’taqat aw yórikyaniqey nānawakna. Nīk̇aṅw uma soon k̇ātatayhpit aw yórikyani, hal pas sūkw k̇ātatayhpit aw uma yórikyani. Pam Tutuyqawhqat lavay’ayayat Jonas qatsíyat ep hiniwhtiqat an aw yukiltini. Noqw pam paṅqw nakwsuqe ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Noqw put aw nánatuwnayaqam wuhkovatuphat ayoqwat nöṅak‐wisk̇aṅw, kurs puma nitk̇ay suhtokya. ");
INSERT INTO hopNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Noqw pahsat pu Jesus pumuy amumi paṅqawu: Uma Pharisee‐sinmuy pu Sadducee‐sinmuy pēk̇eniyamuy ep tunatyaltotini. ");
INSERT INTO hopNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Noqw puma nānami yuaatotaqe paṅqaqwa: Itam itahnitk̇ay qa kivayaqw, ōviy itamumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Noqw Jesus put navotqe, amumi paṅqawu: Is okiw uma öwituptsiwni’yuṅqamu. Ya uma hinoqw qa nitk̇a’vayaqey nānami yuaatota? ");
INSERT INTO hopNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ya uma nāt pas qa mātsi’yuṅwa? Ura nu tsivot pölavikit tsivót‐sikip sōmorit pahsa’nihqamuy tahtaqtuy nopna. Noqw uma akwsiṅwput tsovalayaqe, hihsa’ hoaput aṅ opomnaya? Ya uma pas qa ṅas’ew put u’ni’yuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pu ura piw nu tsaṅe’ pölavikit nālöp sōmorit pahsa’nihqamuy tahtaqtuy nopna. Noqw uma akwsiṅwput tsovalayaqe, hihsa’ hoaput aṅ opomnaya? Ya uma pay put suhtokya? ");
INSERT INTO hopNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Noqw ya uma hinoqw qa māmatsya? Nu qa pölavikit umumi yuaata. Uma Pharisee‐sinmuy‐nik̇aṅw pu Sadducee‐sinmuy pēk̇eniyamuy ep tunatyaltotinaqat nu kita. ");
INSERT INTO hopNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pahsat pu puma māmatsyaqw, kurs pam qa pölavikit pēk̇eniyat paṅqawht, kurs puma Pharisee‐sinmuy tutuqayhpiyamuy‐nik̇aṅw pu Sadducee‐sinmuy tutuqayhpiyamuy ep nāmi tunatyaltotinaqat amumi lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pu Jesus Caesarea Philippi ahayhpo pítuhqe, put aw nánatuwnayaqamuy tūviṅtaqe, amumi paṅqawu: Ya nu’ Sinot Tiat hákiynihqat sinom paṅqaqwa? ");
INSERT INTO hopNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Noqw puma aw paṅqaqwa: Um yaw kūyit akw tūtuvoylalawhqat John‐nihqat haqawat paṅqaqwa; noqw haqawatuyniqw yaw um Elias; pu pētuyniqw yaw um Jeremias, sen pay yaw um suhk̇a Tutuyqawhqat lavay’ayaata. ");
INSERT INTO hopNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Noqw pam pumuy amumi paṅqawu: Noqw úmuyniqw nu’ hak’i? ");
INSERT INTO hopNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Noqw Simon Peter lavayhtiqe, put aw paṅqawu: Um hapi Christ, God aṅqw Moṅw’asi’taqa, God qátuhqat Tíata. ");
INSERT INTO hopNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Noqw Jesus lavayhtiqe, put aw paṅqawu: Pas um Simon Jonat tiat hahlayhpit ep’e; pi qa hak sino ūmi it mātakta; pi Ina ōveqatsit ep qatuhqa pam hapi uṅ put āawna. ");
INSERT INTO hopNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Um hapi Peter. Noqw nu isinomuy tsovalat, it pik̇aqlöt ep soñawnen pumuy akw nēṅem kītani. ");
INSERT INTO hopNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Noqw nu’ hapi ōveqatsit aṅqw moṅwtunatyat aw hötahpit ūmi óyani; noqw um yep qatsit ep hihta hakiy aw uhtaqw, pam ōveqatsit put aw uhtsiltimantani; pu um yep qatsit ep hihta hu’wanaqw, pam ōveqatsit ep hu’waniwni. ");
INSERT INTO hopNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pahsat pu pam put aw nánatuwnayaqamuy pās mēwaqe, pam hapi Jesus Christ‐nihqat qa hakiy āawnayaniqat amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pahpiy pu Jesus put aw nánatuwnayaqamuy hihta hiniwhtiniqat awintivaqe, amumi paṅqawu: Itam Jerusalem aqwyaqw, God awwat mohpeq momṅwit‐niqw, pu wukw’a’yam‐niqw, pu tutavot tūtutuqaynayaqam nuy ṅuayat, okiwsahsanyat, nuy nīnayani. Noqw ahpiy pāyis talq nu ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pahsat pu Peter put ṅuat, qöhqöyaqe aw paṅqawu: Soon pantani, Tutuyqawhqa. Soon um pantsaniwni. ");
INSERT INTO hopNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Noqw pam namtökt, Peter aw paṅqawu: Yupa ayohaqamii, Satan; um inumi sus’itsi. Um qa God tunatyayat yuaata, nīk̇aṅw sinmuy tunatyayamuyu. ");
INSERT INTO hopNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pahsat pu Jesus put aw nánatuwnayaqamuy amumi paṅqawu: Inuṅkniqey nāwaknaqa nātatamtat, nahoylehtsiy kwusut, inuṅkmantani. ");
INSERT INTO hopNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Taq qatsiy k̇ahk̇awnaqa put kwayhni; pu itunatyay ōviy qatsiy kwayhqa put túwani. ");
INSERT INTO hopNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ispi puyaw as sino tūwaqatsit sohsok himuy’vak̇aṅw, pas nāp qatsiy kwahe’, hin pam put akw moṅwvasni? Hal ya sen sino hihta akw qatsiy ahoy nāptini? ");
INSERT INTO hopNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pi nu Sinot Tiat nāt Inay tālawṅwayat pasiwk̇aṅw, ihoṅviaymuy tsamk̇aṅw pítuni; nen pahsat pu nu sohsokmuy sinmuy hin tumaltotaqat pan amumi ahoytani. ");
INSERT INTO hopNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nu umumi pas antsa paṅqawni: Soon pas hisat nu’ Sinot Tiat imoṅwtunatyay yank̇aṅw pítuni. Noqw ima yep hoṅqam haqawat nāt mokiwuy qa aw ök̇e’, puma put aw yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Noqw ahpiy navaysikis talq, Jesus Peter‐nit, James‐nit, pu put tupkoyat John pumuy tsamk̇aṅw, haqami wupatukwit aqw puma yayva. Noqw pumuy pepeq nánaltyaqe, ");
INSERT INTO hopNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pumuy tāyuṅqw, pam alöṅti; noqw pas put taywaat tāwat an tālawṅway’va; pu yuwsiat tālat an qȫtsati. ");
INSERT INTO hopNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Noqw meh, pepeq Moses Elias amum pumuy amumi mātaqtiqe, put amum yuaata. ");
INSERT INTO hopNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Noqw Peter lavayhtiqe, Jesus aw paṅqawu: Tutuyqawhqa, pas hapi itam yépeqyaqw pam lolma. Uṅ pan nāwaknaniqw, itam yepeq payhkomuy kistotani, sukw úṅemnit, pu sukwat Moses éṅemnit, pu sukwat Elias éṅem’i. ");
INSERT INTO hopNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Noqw pam nāt yuaataqw, meh, pi ōmaw suyan talqa pumuy nākwapna; noqw hakiy tönaat ōmawuy aṅqaqw paṅqawu: I’ hapi pas aw iunaṅwa Itii; pas nu put hahlayhti. Uma aw tūqayyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Noqw put aw nánatuwnayaqam put nanaptaqe, tayway akw tutskwami yēvaya, pas tsātsawnaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Noqw Jesus amuminihqe, amumi toṅokt, paṅqawu: Huvam hoṅvaa; uma qa tsawiniwyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Noqw puma kwuhpukyat, aṅqe’ yórikyaqe, pay qa hakiy tutwa, pay Jesus‐saa. ");
INSERT INTO hopNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Noqw puma tūkwiṅaqw hanwisq, Jesus pumuy mēwaqe, amumi paṅqawu: Uma hapi hin yórikyaqey qa hakiy āawnayani, hisat nu’ Sinot Tiat mokiwuy aṅqw ahoy tātayniqat pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Noqw put aw nánatuwnayaqam put tūviṅtotaqe, aw paṅqaqwa: Ya hintaqw ōviy tutavot tutuqaynayaqam Elias mohti pítuniqat paṅqaqwa? ");
INSERT INTO hopNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Noqw Jesus lavayhtiqe, pumuy amumi paṅqawu: Pay antsa Elias pas suyan mohti pítuni; nen sohsok hihta haqe’ hintaniqat aw antsantani. ");
INSERT INTO hopNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Noqw nu umumi paṅqawni: Pay Elias pitu; noqw puma put qa māmatsyaqe, pas tunatyay an put hintsatsna. Noqw pan hapi nu’ Sinot Tiat piw pumuy amuhpiy okiwsaniwni. ");
INSERT INTO hopNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pahsat pu put aw nánatuwnayaqam māmatsyaqw, kurs pam kūyit akw tūtuvoylalawṅwuqat John pumuy amumi lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Noqw puma sinmuy amumi ökiqw, hak Jesus aw pítuhqe, aw tamötswunuptut, paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tutuyqawhqa, um as okiw itiy ōkwatuwni; taq pam okiw homimitutuyhqe okiwhinta; nihqe pam piép qȫhit aqw posṅwu, pu pāmiq’a. ");
INSERT INTO hopNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Noqw nu as ūmi nánatuwnayaqamuy amumi put wikvaqw, puma kurs hin put powatotani. ");
INSERT INTO hopNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Pahsat pu Jesus lavayhtiqe paṅqawu: Is ohi uma qatuptsiwni’yuṅqamu, nukushinyuṅqamu, pu’ qatsívaptsiwyuṅqamu, ya nu hihsavohaqam umumum yantani? ya nu hihsavohaqam umuy maqsonlawni? Pew wikyaa. ");
INSERT INTO hopNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Noqw Jesus nukpanhikwsit mēwa; noqw pam put aṅqw yamakq, tiyo pahsat pay powalti. ");
INSERT INTO hopNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pahsat pu Jesus aw nánatuwnayaqam pay nánaltyak̇aṅw put aw ö́kihqe, aw paṅqaqwa: Ya hintaqw ōviy itam kurs hin put hóroknayani? ");
INSERT INTO hopNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Noqw Jesus pumuy amumi paṅqawu: Ispi uma qa tuptsiwni’yuṅqee; pi nu umumi pas antsa paṅqawni: Kurs uma pay híhin tuptsiwni’uyṅwe’ (nāmahin pi as pam mustard‐uyit sivosiyat an pay hihsayhoyaniqw) uma it tūkwit: Yaṅqw ayo nahlakuu, aw kitotaqw, pam soon qa nahlakni. Pu qa himu umuṅem qa pasiwtani. ");
INSERT INTO hopNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nīk̇aṅw hak qa napwalni’k̇aṅw qa nāwakink̇aṅw pas soon it yantaqat qalomáhikwsit hakiy aṅqw ayo hóroknani. ");
INSERT INTO hopNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Noqw nāt pumuy Galileet ep yesq Jesus pumuy amumi paṅqawu: Nu’ Sinot Tiat sinmuy amumi mātaviwni. ");
INSERT INTO hopNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Noqw puma nuy nīnayani; noqw ahpiy pāyis talq nu ahoy tātayni. Noqw puma it nanaptaqe, pas qahahlayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Noqw puma Capernaum ep ökiqw, hakim God kīyat eṅem siviwuy tsovalantotaqam Peter aw ökihqe, aw paṅqaqwa: Ya umuy tutuqaynaqa God kīyat aw sīvat ōoywaqat qa sivima? ");
INSERT INTO hopNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Noqw pam paṅqawu: As’a. Nit pam kimi pakiqw, Jesus pay mohti lavayhtiqe paṅqawu: Simon, ya um hin it aw wūwa? Ya tūwaqatsit ep momṅwit hakimuy amuṅaqw tax ömalalwa, pu nahpe sívita? Ya sen nāp sinomuy amuṅaqw put ömalalwa? Sen pay hakimuy a’löṅtuy amuṅaqö’? ");
INSERT INTO hopNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Noqw Peter put aw paṅqawu: Pay a’löṅtuy amuṅaq’ö. Noqw Jesus aw paṅqawu: Noqw pay kurs sinomat qeniveya. ");
INSERT INTO hopNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Noqw pay itam pumuy qa unaṅwmoknaniqw, ōviy um wuhkovatuphat awnen, aqw huhuwhpit tūvani; nen um hihtawat mohti hórokne’, ṅúani; nit tsaṅwtapne’, aṅqw hihsaqw sīvat túwani; um put aṅqw hóroknat, nēṅem‐nik̇aṅw pu inuṅem momṅwituy amumi sisvini. ");
INSERT INTO hopNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Noqw ephaqam Jesus aw nánatuwnayaqam put aw ökihqe, paṅqaqwa: Ya hak ōveqatsit aṅqw moṅwtunatyat ep pas suspavanni? ");
INSERT INTO hopNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Noqw Jesus hakiy tsākwhoyat wáṅwayhqe, put amuhsonmi tavi; ");
INSERT INTO hopNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nit paṅqawu: Nu umumi pas antsa paṅqawni: Pas uma nāp umuhtunatyay aṅqw qa lasye’, tsātsakwmuy qa amuntote’, soon ōveqatsit aṅqw moṅwtunatyat aw yuṅni. ");
INSERT INTO hopNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Paniqw hapi ōviy haqam it tsākwhoyat an qanāhihtataqa pam hapi ōveqatsit aṅqw moṅwtunatyat ep suspavanni. ");
INSERT INTO hopNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pu haqawa inatṅwaniy aṅ yan tsākw pās távihqa hapi nuy pās távini. ");
INSERT INTO hopNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nīk̇aṅw hapi hak haqam imuy tsātsakwmuy inumi tuptsiwni’yuṅqam hihtawat lasnaqw, put eṅem pas is óhini? Pay pi tatam put kwapk̇aqe mata hāyiltiqw, pam wuhkovatuphat a’nö hötsit aqw paöymokq, pam put eṅem lolmani. ");
INSERT INTO hopNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Is ohi sinmuy amuṅem’i, hakimuy hīhihta akw lomavöhut aṅqw lasyaqamuy amuṅem’i. Taq sinmuy lasnayaqam pas soon haqami peveltini. Nīk̇aṅw pantsatsk̇aqamuy amuṅem pas is óhini! ");
INSERT INTO hopNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Paniqw hapi ōviy kurs uhma, sen uhkuku uṅ lasnaniqw, um put ayo tukut, nāṅaqw ayo tūvani; pay pi um tatam qa pasiwk̇aṅw qatsit aw pákini, hikis pi as um pās pasiwk̇aṅw, qȫhit qa súlawhtiṅwuqat aqw túviwni. ");
INSERT INTO hopNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pu kurs uhposi uṅ lasnaniqw, um put ayo hóroknat, nāṅaqw ayo tūvani. Pay pi um tatam sūkw pōsi’k̇aṅw qatsit aw pákini, hikis pi as um pās lȫqmuy pōsi’k̇aṅw maskimiq qȫhit aqw tūviwni. ");
INSERT INTO hopNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Uma tunatyaltote’ qa hihtawat imuy tsātsakwmuy paysoqtotani; taq nu umumi paṅqawni: Pumuy tuwalan’aymat Inay ōveqatsit ep qátuhqat taywayat aw sutsep tāyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pi nu’ Sinot Tiat haqami hiniwhtotiqamuy ayo óyaniqe ōviy pitu. ");
INSERT INTO hopNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ya uma hin wūwantota? As kurs hak haqam tsivót‐sikip sunat kanelmuy pokmuy’taqw, suhk̇a pumuy amuṅaqw haqaminiqw, pam hinhtini? Pam púmuywatuy mātapt, tsotsmomihaqaminen, it haqaminihqat heptoni. ");
INSERT INTO hopNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nu umumi pas antsa paṅqawni: Pam put tuwe’, put ep pas hahlayhtini, imuy nālöp sunat pakwt pept sihk̇ay’taqamuy qa haqami hiniwhtotiqamuy amuhpenihqee. ");
INSERT INTO hopNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Noqw pan hapi piw Umuna ōveqatsit ep qátuhqa imuy tsātsakwmuy himuwat súlawhtiniqat qa nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Pu ōviy kurs piw umún tuptsiwni’taqa hihta ep ūmi qaanhtiqw, um put awnen, pay umuy nālaniqw put öwihiniwhtipuyat aw pónaknani; noqw kurs pam ūmi tuqayvastaqw, pahsat hapi um put pay ahoy tuyqawvani. ");
INSERT INTO hopNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ason kurs pam ūmi qa tuqayvastaqw, pahsat pu um sūkw, sen lȫqmuy wikk̇aṅw awni; noqw lȫqmuy, sen payhkomuy tūqayyuṅqw, pep hin lavayhtiwhqa pasiwtamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Noqw kurs pam pumuy amumi qa tuqayvastaqw, pahsat pu um inumi tuptsiwni’yuṅqamuy tsovawtaqw, pumuy put āawnani. Pu kurs pam pumuy amumi qa tuqayvaste’, pam nawus úmuyniqw qatuptsiwni’taqat antamantani, sen moṅwit eṅem sīvat ömalawhqat an’i. ");
INSERT INTO hopNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nu umumi pas antsa paṅqawni: Uma tūwaqatsit ep hihta somyaqw, pam ōveqatsit ep sómiltimantani; pu uma tūwaqatsit ep hihta ṅahyaqw, pam ōveqatsit ep ṅāhiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pu nu piw umumi paṅqawni: Kurs uma lȫyöm tūwaqatsit ep hihta ōviy Inay aw tūviṅtaniqey ep sun unaṅwtiqw, ōveqatsit ep Ina umeṅem put aw antsantamantani. ");
INSERT INTO hopNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pi haqam lȫyöm, sen pahyom inatṅwaniy aw yank̇ahk̇aṅw haqam tsovawtaqw, pep nu pumuy amumumni. ");
INSERT INTO hopNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pahsat pu Peter put awnihqe aw paṅqawu: Tutuyqawhqa, kurs itupko inumi qa sūs qaanhtiqw, ya nu hihsakis put ep aw pöhikni? Sen tsaṅé’sikisi? ");
INSERT INTO hopNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Noqw Jesus put aw paṅqawu: Tsaṅe’sikisi nu hapi ūmi qa kita, pas payhp sunat aṅqw pakwt sihk̇ay’tasikip tsaṅe’sikisi, (tsaṅe’sikip pakwt tsaṅe’sikis navitaṅhtiqat pahsaa). ");
INSERT INTO hopNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Panta hapi. Oveqatsit aṅqw moṅwtunatya hak moṅwi tumal’aymuy amumi sīvat ep pohtaniqey nāwaknaqat anta. ");
INSERT INTO hopNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nihqe pam put aṅ purivaqw, hak wūhak sōmorit sīvat put aw pöiwtaqa aw wikvaniwa. ");
INSERT INTO hopNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Noqw pay kurs pam hihta sisviniqw, pam huyiwniqat moṅwiat paṅqawu, pu nȫmaata, pu timatu, pu sohsoy himu himuata, noqw pöiyat ep sisviwni. ");
INSERT INTO hopNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Noqw ōviy tumal’aya put atpipo nātuvaqe, okiw aw naokiwtaqe paṅqawu: Moṅwi, pay um okiw inumi qa pas k̇ānavotitaqw, pay nu soon ūmi qa sohsok sisvini. ");
INSERT INTO hopNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pahsat pu moṅwi put ōkwatuwhqe mātavi; nihqe sohsok pöiyat ayo yuku. ");
INSERT INTO hopNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Noqw pay pam tumal’aya paṅqw yamakt, sukw tumalsuṅway put aw sunat sīvat pöiwtaqat tuwa; nihqe pam put tönhpe ṅuat, aw paṅqawu: Um inumi pöiwtaqey sisvini. ");
INSERT INTO hopNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Noqw put tumalsuṅwaat put kukmiq nātuvaqe, put aw naokiwtaqe paṅqawu: Pay um qa pas okiw inumi k̇ānavotitaqw, pay nu soon ūmi qa sohsok sisvini. ");
INSERT INTO hopNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Noqw pam qa nakwhaqe, put sivikimi tūva, hisat pöiy sisviniqat pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Noqw ōviy put tumalsuṅwamat hin hiniwhtiqat aw yórikyaqe, pas qa hahlayhtoti; nihqe moṅwiy aw ökihqe, sohsok put āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pahsat pu moṅwiat tumal’ayay wáṅwayhqe, aw paṅqawu: Is ohi um hak nukpantumal’aya, um inumi pan nāwaknaqw, ōviy nu sohsok uhpöiy uhpiy ayo yuku. ");
INSERT INTO hopNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Noqw puyaw nu uṅ hin ōkwatuwhq, soon um tuwat qa pan uhtumalsuṅway ōkwatuwni? ");
INSERT INTO hopNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Noqw moṅwi pas itsívutiqe, hakiy okiwsanyaṅwuqamuy amumi put mātavi, pas hisat put aw pöiwtaqey sohsok put aw sisviniqat pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Noqw kurs umún tuptsiwni’taqa umuhpewi qaanhtiqw, uma umuh’unaṅṅaqw qa aw pöhikyaqw, pay ōveqatsit ep Ina piw tuwat umuy pan hintsanni. ");
INSERT INTO hopNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Noqw Jesus yan yuaataqe yukut, Galileet aṅqw ahpiynihqe, Jordan yupqöymi Judeat qalavoq pitu. ");
INSERT INTO hopNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Noqw qaan’ewakw hintaqam sinom put aṅkya; noqw pam pumuy pepeq qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Noqw Pharisee‐sinom nuhtum put aw ökihqe, put unahepyaqe aw paṅqaqwa: Ya tāqa pay nāphihta ep nȫmay mātapniqw pam súanta? ");
INSERT INTO hopNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Noqw pam lavayhtiqe amumi paṅqawu: Ya uma it aṅ qa tuṅwaya: Ura God yayhniwhqat epeq pumuy yúkuhqe, pumuy tāqat‐nit pu wuhtit yuku, it’a? ");
INSERT INTO hopNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nihqe pumuy yúkuhqe paṅqawu: Yantaqw hapi ōviy tāqa nay, pu yuy pumuy mātapt, nȫmay aw hūrstimantani; noqw puma sūk̇a tókomantani. ");
INSERT INTO hopNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Panta hapiniqw, ōviy puma pāpu qa lȫyömnit, sūk̇a tókoniwhtiṅwu. Paniqw ōviy God hihta namitsk̇aqw, qa hak put nāhoy távini. ");
INSERT INTO hopNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Noqw puma put aw paṅqaqwa: Noqw hinoqw pantaqw hak nāmataviwuy pēnat, pu nȫmay nahpiy lālaymantaniqat Moses tutapta? ");
INSERT INTO hopNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Noqw pam pumuy amumi paṅqawu: Ispi uma anahaat unaṅway’yuṅqw ōviy pay hak nȫmay mātapmantaniqat Moses umuy hu’wana. Nīk̇aṅw pas as yayhniwhqat aṅqw qa panta. ");
INSERT INTO hopNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Noqw nu hapi umumi paṅqawni: Tāqa nȫmay qa hintsakq, put mātave’, piw sukw amum qatupte’, tokot ūuyṅwu; pu wuhtit mātaviwhqat amum qatuptuqa tokot ūuyṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Noqw put aw nánatuwnayaqam aw paṅqaqwa: Kurs tāqat pu nȫmayat amuṅem pan hintaniqw, pay kurs k̇a qa nȫmataniqw pam pay lolmani. ");
INSERT INTO hopNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Noqw pam pumuy amumi paṅqawu: Pay qa sohsoyam tahtaqt namituyqawi’yuṅwa; nihqe ōviy kurs hin it tutavot kwusuyani. Noqw God pētuy‐sa öqalmaqaqw ōviy puma namituyqawi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pi haqawat nömaqtsit aw qa pasiwyuṅqam pay pas pank̇ahk̇aṅw tihtiwya; noqw haqawat panyuṅqam pay sinmuy amuhpiy pan yukiltoti; pu haqawat pas pay ōveqatsit aṅqw moṅwtunatyat tunatyawyuṅqey ōviy qa nȫmatota. Haqawa it aṅ hinmaniqa nam panhtii. ");
INSERT INTO hopNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pahsat pu hakim put aw tsātsakwmuy tsamvaya, pam pumuy amumi may akw toṅokt nāwaknaniqat ōviy’o. Noqw put aw nánatuwnayaqam pumuy mēwaya. ");
INSERT INTO hopNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Noqw Jesus paṅqawu: Uma tsātsakwmuy inumiyaniqat nakwhanayani; uma qa mēwantotani; pi panyuṅqam hapi ōveqatsit aṅqw moṅwtunatyat ep sinoiwyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pu pam pumuy amumi matyawht, paṅqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Noqw pahsat pu hak tiyo Jesus aw pituhqe, aw paṅqawu: Lomatutuqaynaqa, ya nu hihta lolmat hinhte’, qatsit qaso’taqat himuy’vani? ");
INSERT INTO hopNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Noqw pam put aw paṅqawu: Ya um hinoqw nuy lolmalawu? Pi qa hak lolma, pas sūk̇aa, i’ God. Noqw pay pi um qatsit aw pákinik, um hin tutaptiwhqat aṅ hinmani. ");
INSERT INTO hopNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Noqw pam put aw paṅqawu: Hihtawata? Noqw Jesus paṅqawu: Um hakiy qa nīnani, um qa nāp úhimuy tokot qa sokoptani; um hihta qa ūuyni, um hakiy hihta qa atsátoynani; ");
INSERT INTO hopNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Um unay, pu uṅuy pumuy k̇aptsi’tani; pu um pas hin nāmi unaṅway’taqey pan uhsinosṅway aw unaṅway’tani. ");
INSERT INTO hopNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Noqw pam Jesus aw paṅqawu: Pay nu itsákoy aṅqaqw pan tutavot sohsok aṅ hinma. Noqw ya nu haqam hihta nāt qaanhti? ");
INSERT INTO hopNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Noqw Jesus put aw paṅqawu: Pay pi um pas pasiwtaniqey nāwakne’, um ahpiynen, hihta úhimuy huyahtani; nen aṅ ōokiwyaqamuy put huytani; nen um ōveqatsit ep hihta nukṅwat himuy’tani; nit um aṅqwnen inuṅkni. ");
INSERT INTO hopNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Noqw pam put navotqe qahahlayk̇aṅw ahpiy’o, pam hihta nihti’taqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pahsat pu Jesus put aw nánatuwnayaqamuy amumi paṅqawu: Nu umumi pas antsa paṅqawni: Pas k̇ahaksino ōveqatsit aṅqw moṅwtunatyat aw pákiniqw eṅem qa tūvosi. ");
INSERT INTO hopNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Noqw nu nāt piw umumi paṅqawni: Pay himu pohko pȫlay’taqa tsakomostat aṅ pórokput aṅ yámakniniqw, pam pay qa pas qa tūvosi. Noqw pay k̇ahaksino ōveqatsit aṅqw moṅwtunatyat aw pákiniqw, pam put eṅem pas qa tūvosi. ");
INSERT INTO hopNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Noqw put aw nánatuwnayaqam put nanaptaqe, hin kurs wūwayaqe paṅqaqwa: Noqw pantaniqw, hak sen ayo yámakiwtani? ");
INSERT INTO hopNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Noqw Jesus pumuy amumi paṅqawu: Pay i’ sinmuyniqw kurs hin pasiwtani; nīk̇aṅw pay God‐niqw sohsoy himu pasiwta. ");
INSERT INTO hopNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pahsat pu Peter lavayhtiqe, put aw paṅqawu: Meh, itam hapi sohsok hihta mātapyat, uṅk nankwusa; noqw itam panhtotiqw, itamuṅem hintani? ");
INSERT INTO hopNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Noqw Jesus pumuy amumi paṅqawu: Nu umumi pas antsa paṅqawni: Hisat qatsit nātoniqat aw pituqw, Nu’ Sinot Tiat k̇aptsi’tiwk̇aṅw imoṅw’atsveway ep qátuni. Noqw pep pu’ uma inuṅk hinnumyaqam piw tuwat pakwt löq sihk̇ay’taqat moṅw’atsvewat aṅ yesk̇ahk̇aṅw, Israel‐sinmuy pakwt löq sihk̇ay’tasikivo sinoiwtaqamuy amumi moṅw’iwyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hak haqam inatṅwaniy ōviy sinomuy, sen nāp himuy hihta tatamhtat, yep qatsit ep tsivót‐sikip sunat aw hóyokiwtaqat ömahtani, sen pam kiy tatamhtani, sen pāvamuy, tupkomuy, qȫqamuy, siwamuyu, sen nay pu yuy, sen nȫmay pu timuy, sen pāvasayu. Pu qatsit nātoniqat ep pam qatsit qaso’taqat makiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nīk̇aṅw k̇aysiwhqam mohti’wisqam nuhtuṅkyani, pu nuhtuṅkyaqam mohti’wisni. ");
INSERT INTO hopNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Pi ōveqatsit aṅqw moṅwtunatya hak tāqa ovauyi’taqat anta. Pam hak suits talavay tumal’aymuy wáṅwayi. ");
INSERT INTO hopNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Noqw puma sūkw yālit ōviy tapkinayaniqey hu’wayaqw, pam ovauyiy aw pumuy ayata. ");
INSERT INTO hopNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Noqw wukotöṅvaqw, i’ ūyi’taqa haqe’ waynumk̇aṅw, hakimuy piw tuwa. Puma huhyankive hoṅnumya qahintsatsk̇aqee. ");
INSERT INTO hopNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Noqw pam pumuy amumi paṅqawu: Pay uma iovauyiy awyani. Noqw pay ason hin súantaqw, nu pan umumi sisvini. Noqw puma awya. ");
INSERT INTO hopNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Noqw tāwanasaptiqw, pu tāwat atvelpetiqw, pam aṅqe’ nakwsuqe piw anhti. ");
INSERT INTO hopNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Noqw pu kanel’ökisat, piw pam huhyankiminihqe, piw hakimuy tahtaqtuy tuwa, ep hoṅnumyaq’ö, nihqe amumi paṅqawu: Ya uma hinoqw paysoq tēvep hoṅnumya? ");
INSERT INTO hopNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Pu suhk̇a aw paṅqawu: Ispi qa hak itamuy tumal’ayhtaq’ö. Noqw pam amumi paṅqawu: Uma turs piw iovauyiy awyani, amumi kita. ");
INSERT INTO hopNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Noqw pu tapkiqw, ovauyi’taqa tumalmoṅwiy aw paṅqawu: Um tumalay’yuṅqamuy wáṅwayni; nen pumuy amumi sisvini. Um nuhtuṅk ökihqamuy aṅqw hoyoyoykuk̇aṅw, mohtimaqat aqw yúkuni. ");
INSERT INTO hopNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Noqw ima pas pay tumalqe’totiniqw ökihqamuy amumi suskomuy yālit sisvi. ");
INSERT INTO hopNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nīk̇aṅw mohti ökihqam puma wūhaq ömahtotaniqey wūwaya; nit puma pay amún sohsoyam suskomuy yālit ömahtota. ");
INSERT INTO hopNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Noqw puma ahsatiy ömahtotaqe, ūyi’taqat aw qa tsúyak‐unaṅway hiṅqaqwaqe, ");
INSERT INTO hopNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Paṅqaqwa: Ima nuhtuṅk ökihqam panis sūs tāwat qöniltiqat aṅ tumaltota; noqw itam tēvep tumalay’yuṅwa, pu itam utuhuut k̇ānanapta. Noqw um sun itamumi sisvi. ");
INSERT INTO hopNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Noqw pam sukwat aw paṅqawu: Ikwátsi, pay nu qa hin qasuanhti. Ya um qa sūkw yālit ōviy tumaltaniqey inumum pan yuku? ");
INSERT INTO hopNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Taa, uh’ahsatiy um yawk̇aṅw nimani. Pay nu sohsokmuy umumi sun sisviniqey nāwakna, umuy tēvep tumalay’yuṅqamuy‐nik̇aṅw pu imuy nuhtuṅk ökihqamuy pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ya nu hihta nāp isivay hintsanniqey nāwakne’ panhtiniqw, pam qasuanta? Ya nuy qa unáṅwawniqw, ōviy um inumi qa kwaṅwátayta? ");
INSERT INTO hopNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Noqw ōviy nuhtuṅkyaqam mohti’wisni, pu mohti’wisqam nuhtuṅktotini. Pi k̇aysiwhqam as wáṅwayniwya, nik̇aṅw hikiyom namorstiwya. ");
INSERT INTO hopNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Noqw pumuy Jerusalem aqwyaqw, Jesus imuy pakwt löq sihk̇ay’taqamuy put aw nánatuwnayaqamuy nanaltyaqw, amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Meh, itam Jerusalem hapi aqwya. Noqw nu’ Sinot Tiat God awwat mohpeq momṅwituy‐nik̇aṅw pu tutavot tutuqaynayaqamuy amumi noiwni; noqw puma nuy nīnayaniqey pasiwnayani. ");
INSERT INTO hopNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pu nuy qa‐Jew‐sinmuy amumi noayaqw, puma inumi tututsiwyani; nuy wuvahtotani; pu nahoylehtsit aw nuy muayani. Nīk̇aṅw pāyis talq nu ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Noqw pahsat pu Zebedeet timat yuy amum Jesus aw pitu. Noqw yuam put pas hihtatak̇aṅw aw okiwlawu, hihta tuṅlay’k̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Noqw Jesus put aw paṅqawu: Ya um hihta nāwakna? Noqw pam put aw paṅqawu: Ason um uhmoṅwqeniy ep qatuptuqw, as imuy itimuy amuṅaqw haqawa uhputvaqe qátuniqw, pu suhk̇awa uhsuyvaqe qátuniqat um itamuy hu’wani. ");
INSERT INTO hopNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Noqw Jesus tíyotuy amumi paṅqawu: Uma hihta ōviy tūviṅlawhqey qa mātsi’ta. Ya pay uma nuy k̇ānavotpit aṅqw yúkuniqat aṅqw yúkuniqey suhtaq’ewa? Ya sen uma nuy hin tuvoylaiwtaqat pan tuvoylatiwniqe ōviy’o? Noqw puma put aw paṅqawu: Owi, pay itam suhtaq’ewa. ");
INSERT INTO hopNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Noqw Jesus pumuy amumi paṅqawu: Pay nu kānavotpit aṅqw yúkuniqat uma as soon qa yúkuni; piw nuy hin tuvoylaiwtaqat pan uma tuvoylatiwni. Nīk̇aṅw pay nu hakiy iputvaqe, sen isuyvaqe qátuniqat paṅqawniqey aw qa tutuyqawi. Nīk̇aṅw pay ason pas pam hakimuy amuṅem na’sastiwhq pam pumuy amumi noiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Noqw ima pakwtnihqam put nanaptaqe, pumuy nātupkomuy amumi qa yan unaṅwtoti. ");
INSERT INTO hopNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Noqw Jesus pumuy nāmi wáṅwayhqe, amumi paṅqawu: Uma navoti’yuṅqw imuy qa‐Jew‐sinmuy moṅwimat pumuy amumi tutuyqawya, noqw pavansinom öqalay pumuy nanvotnatiwisa. ");
INSERT INTO hopNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nīk̇aṅw uma hapi qa panyuṅwni. Pay umuṅaqw haqawa pas pávanniqey nāwaknaqa umuy nawus tumalay’tani. ");
INSERT INTO hopNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pu uma haqawa sustutuyqawniqey nāwaknaqa nawus piw sohsokmuy tūwikiamni. ");
INSERT INTO hopNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hikis pi nu’ Sinot Tiat qa hihta tu’yalawniqe ōviy pitu; pi nu nuhtumi unaṅwtapniqe ōviy pitu, piw sinmuy k̇aysiwhqamuy amuṅem iqatsiy táve’, pumuy ayo óyaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Noqw pumuy Jerichot aṅqw ahpiyyaqw, qaan’ewakw hintaqam sinom Jesus aṅkya. ");
INSERT INTO hopNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Noqw meh, lȫyöm qapostalqat tāqat pöqlave qatuk̇aṅw, Jesus aṅqe’niqw navotqe, tsa’lawhqe paṅqawu: Is okiw itamuy ōkwatuwaa, Tutuyqawhqa, um David tiat! ");
INSERT INTO hopNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Noqw sinom pumuy mēwayaqe, qa hiṅqawlawniqat amumi paṅqaqwa. Noqw pahsat pu puma pas pāpu a’nö paṅqawu: Is okiw itamuy ōkwatuwaa, Tutuyqawhqa, um David tiat! ");
INSERT INTO hopNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Noqw Jesus pep wunuptut, pumuy wáṅwayhqe, amumi paṅqawu: Ya nu umuy hintsanniqat uma nāwakna? ");
INSERT INTO hopNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Noqw puma put aw paṅqawu: Tutuyqawhqa, um as okiw itahposiy tālawnani. ");
INSERT INTO hopNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Pu Jesus pumuy ōkwatuwhqe, pumuy pōsiyamuy aw hintsana; noqw pahsat pay pumuy pōsiam tālawva; noqw puma put aṅki. ");
INSERT INTO hopNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Noqw puma Jerusalem aw hayiṅwnayaqe, Olive‐tsomot aw öki, Bethphage‐kitsókit aw’i. Noqw Jesus lȫqmuy put aw nánatuwnaqamuy ayataqe, ");
INSERT INTO hopNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Amumi paṅqawu: Uma umupyeve kitsókit awnen; uma pep mōrot som’iwtaqw tiyat ámumnihqat túwani. Uma pumuy ṅaht, aṅqw inumi wikni. ");
INSERT INTO hopNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pu ason kurs hak umumi hiṅqawhq, uma aw paṅqawni: Tutuyqawhqa imuy nāwakna, kítani; noqw pahsat pay pam pumuy aṅqw lālayni. ");
INSERT INTO hopNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yan Tutuyqawhqat lavay’ayaat hin lavayhtiqat aw antsaniwa; ura pam paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Uma Sion ep sinmuy āawnayani: Meh, umuhmoṅwi aṅqw umumii, okiw’unaṅway’k̇aṅw mōrot akw tsokiwma, morohyat akw’a. ");
INSERT INTO hopNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Noqw put aw nánatuwnaqam ahpiynihqe, Jesus hin amumi lavayhtiqat anhti; ");
INSERT INTO hopNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nihqe mōrot wikva, pu morohyata. Noqw sinom yuwsiy amutsmi ahpatota; noqw Jesus aqw wūvi. ");
INSERT INTO hopNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Noqw sinom pas qaan’ewakw hintaqam pönawit yuwsiy ahpatota; pu pētu himutsotskit nantaqayat tsahqayaqe pönawit o’ya. ");
INSERT INTO hopNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Noqw ima mohti’wisqam amuṅkyaqamuy amumum tsa’tiwisqe paṅqawwisa: Öqawmaṅwu, David tíata! Uma Tutuyqawhqat natṅwaniyat aṅ pitutoqat pas hihtatotani. Nam God Sus’oveqnihqa put öqalaa! ");
INSERT INTO hopNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Noqw pam Jerusalem ep pituqw, kīve sinom hin mowawaykuqe paṅqaqwa: Ya pam hak’i? ");
INSERT INTO hopNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Noqw sinom paṅqaqwa: I’ Tutuyqawhqat lavay’ayaata, Jesus, Galileet ep Nazareth aṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Noqw pu Jesus God kīyat aw pítuhqe, ep ihpove huhyayaqamuy, pu hihta tuhtuy’yaqamuy sohsokmuy paṅqw tusoqlalayi, nit sīvat nāhoyṅwantotaqamuy huhyanpiyamuy takumna, pu höwihtuy huhyayaqamuy atsvewayamuy énaṅ’a; ");
INSERT INTO hopNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nihqe amumi paṅqawu: Ura Tutuyqawhqat lavay’ayaat put eṅem yan pēna: Iki nāwakinpikihu yan túṅwantiwni. Noqw tuwat soq uma put uuyiṅwtuy kivatoynaya. ");
INSERT INTO hopNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Noqw hakim qapostalyaqam, pu qayaktaqam God kīyat ep put aw öki, noqw pam pumuy qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Noqw tsātsayom God kīyat ep saáataqe, paṅqaqwa: Öqawmaṅwu, David Tiat! Noqw God awwat mohpeq momṅwit‐niqw pu tutavot tutuqaynayaqam it nanapta. Pu puma pas nāp yórikya Jesus k̇ātutmalat hintsakq’ö; nīk̇aṅw tuwat a’nö itsívutotiqe, ");
INSERT INTO hopNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesus aw paṅqaqwa: Ya um imuy hiṅqaqwaqw qa navota? Noqw pam amumi paṅqawu: As’a. Noqw ya uma it tutuvenit qa hisat aṅ tuṅwáya: Um titipostuy, pu yōyoṅyaqamuy moayamuy ahpiy pas suyan tayawintiwni, it aṅ’a? ");
INSERT INTO hopNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pu pam pumuy mātapt, kitsókit Bethanyt awnihqe, pep talöṅna. ");
INSERT INTO hopNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Noqw talavay pam ahoy kīminik̇aṅw, tsöṅmoki. ");
INSERT INTO hopNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nit pam pöhut qalave nönvospaltsokit túwahqe, aw last, qa hihta ep tuwa, pay nahpit‐saa, nihqe aw paṅqawu: Pay um pas yahpiy qa hisat sipalay’vani, kita. Noqw pahsat pay nönvospaltsoki lāki. ");
INSERT INTO hopNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Noqw put aw nánatuwnayaqam put tutwaqe, k̇ātayuṅqe paṅqaqwa: Is uti! Nönvospaltsoki súlaki. ");
INSERT INTO hopNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus lavayhtiqe, pumuy amumi paṅqawu: Nu umumi pas antsa paṅqawni: Pas uma qapēvewnayak̇ahk̇aṅw qa wiwsiye’ nuy nönvospaltsokit hintsanqat uma piw pan hintsak‐wisni. Hikis put epnihqe hóyokput uma hintsak‐wisni. Uma it tūkwit nahlak̇e’ wuhkovatuphamiq tūviwniqat aw paṅqaqwaqw, pam kurs hin qa panhtini. ");
INSERT INTO hopNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pu uma qapēvewni’k̇ahk̇aṅw Inay aw hihta ōviy tūviṅtote’, soon qa put makiwyani. ");
INSERT INTO hopNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Noqw pam God kīyat aw pákihqe, sinmuy tutuqaynaqw, ima God awwat mohpeq momṅwit, pu sinmuy amuṅaqw wukw’a’yat put aw ökihqe, aw paṅqaqwa: Ya um hihta öqalat aw yank̇aṅw īit hintsaki? Hak uṅ it öqalat maqa? ");
INSERT INTO hopNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Noqw Jesus lavayhtiqe amumi paṅqawu: Kurs nu tuwat umuy sukw hihta tūviṅtani; noqw kurs uma nuy put āawnayaqw, nu tuwat hihta öqalat aw yank̇aṅw īit hintsakqey umuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ura John kūyit akw tūtuvoylalawu. Pam pantsakniqey haqaqw makiwa? sen ōveqatsit aṅqö’? sen sinmuy amuṅaqö’? Noqw puma nānami yuaatotaqe paṅqaqwa: Ya sen itam Oṅaq’ö, kitotani? Soon qa pam itamumi paṅqawni: Noqw hinoqw uma put aw qa tūtuptsiwa? ");
INSERT INTO hopNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ya sen itam sinmuy amuṅaq’ö kitotani? Nīk̇aṅw itam sinmuy mamqasya. Pi sinom sohsoyam John Tutuyqawhqat lavay’ayaatnihqat pan mātsi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Noqw puma lavayhtotiqe Jesus aw paṅqaqwa: Kurs itam hin paṅqaqwani; noqw pam umumi paṅqawu: Pay nu ōviy piw soon hihta öqalat aw yank̇aṅw īit hintsakqey umuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Noqw ya uma hin wūwantota? Hak tāqa lȫqmuy tiyotimuy’ta; nihqe pam mohti’maqat awnihqe aw paṅqawu: Itii, um pu’ iovauyiy ep tumalay’tani. ");
INSERT INTO hopNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Noqw pam lavayhtiqe nay aw paṅqawu: Sóoni, kitat, pay hihsavoniqw wuwniy alöṅtaqe aw haqamii. ");
INSERT INTO hopNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pu pam aṅknihqat awnihqe aw piw án lavayhti. Noqw pam hu’waqe nay aw paṅqawu: Nu awni, itanaa, kitat pay qa aw’i. ");
INSERT INTO hopNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Noqw ya úmuyniqw imuy lȫqmuy amuṅaqw himuwa nay tunatyayat anhti? Noqw puma aw paṅqaqwa: Pay mohti’maqa. Noqw Jesus amumi paṅqawu: Nu umumi pas antsa paṅqawni: Ima moṅwit eṅem sīvat ömalalwaqam, pu tokoy huhyayaqam momoyam umupyeve pay God moṅwtunatyayat aw yuṅta. ");
INSERT INTO hopNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pi John súantaqat pöhut umuy āawnaniqe umumi pituqw uma put aw qa tūtuptsiwa; noqw aṅwu pi moṅwit eṅem sīvat ömalalwaqam, pu tokoy huhyayaqam put aw tūtuptsiwa. Noqw as uma aw yórikyat umuhtunatyay aṅqw qa lasya, uma as aw tūtuptsiwanik̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Huvam inumi tuqayvastotaa. Noqw nu umuy tūwutsit āawnani. Hak tāqa ōvat uyht, put aw ṅöyakna, nit haqam ōvat pālayat yuykuyaniqat eṅem qölötat, tuwalankihut kīta; nit ūyit tumalay’yuṅqamuy amumi put mātapt, yāvoqhaqamii. ");
INSERT INTO hopNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pu ōviy kwaṅwtinisavotiqw pam tumal’aymuy ūyit tumalay’yuṅqamuy amumi hōna, aniwnit ömahtotaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Noqw ūyit tumalay’yuṅqam put ayamuyatuy ṅuahtotaqe, sukwat wuvahtota, pu sukwat nīnaya, pu sukwat tatatupya. ");
INSERT INTO hopNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pu piw pam pētuy tumal’aymuy mohti aqwyaqamuy amuhpenihqe hóyokiwtaqamuy amumi ayata. Noqw puma pumuy mohti’ ökihqamuy amún hintsatsna. ");
INSERT INTO hopNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pahsat pu pam nuhtuṅk pas tiy pumuy amumiq tavi paṅqawhqee: Puma pay itiy soon qa k̇aptsi’totani, yan wūwaqee. ");
INSERT INTO hopNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Noqw soq ūyit tumalay’yuṅqam tiyat tutwaqe nānami paṅqaqwa: I’ hapi nay akpetaniqa. Taa, itam nīnayani, nen itam hihta himuyat himhtotani, kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nihqe puma put ṅuayat, ovauyit aṅqw qalavo tūvayat, nīnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Taay, noqw ya ōvat ūyi’taqa pite’, ūyit tumalay’yuṅqamuy hintsanni? ");
INSERT INTO hopNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Noqw puma put aw paṅqaqwa: Soon qa pam pumuy qahopihtuy qöyani, nit pas pētuy tumal’ayhtani; noqw puma put kwaṅwtiqw put aw kiwismantani, kitota. ");
INSERT INTO hopNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Noqw Jesus pumuy amumi paṅqawu: Ya uma qa hisat it tutuvenit aṅ tuṅwáya? Owa kīlalwaqamuy amuhpiy qalavo tūviwhqa hapi tuyqaatniwhti. Tutuyqawhqa it tumaltaqw, itamuyniqw k̇ātatayhpi, it’a? ");
INSERT INTO hopNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yaniqw ōviy nu umumi paṅqawni: God moṅwtunatyaat umuṅaqw nawhkiwht, pu hihtuywatuy sinmuy amumi noiwni. Noqw puma hapi moṅwtunatyat ep sinoiwyuṅqamuy amún hinwisni. ");
INSERT INTO hopNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Noqw it owat ep posqa hapi yóṅoyhtimantani; nīk̇aṅw ason pam owa hakiy aw pohse’ put pās tostani. ");
INSERT INTO hopNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Noqw God awwat mohpeq momṅwit, pu Pharisee‐sinom, puma put lavayiyat aw tūqayyuṅqe māmatsyaqw, kurs pay pam pumuy yuaata. ");
INSERT INTO hopNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nihqe puma as put ṅuayaniqey unaṅwtotit, piw sinmuy maqastoti, púmuyniqw pam Tutuyqawhqat lavay’ayaatniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Noqw Jesus tūwutsit hihta tuawi’taqat akw pumuy amumi lavayhtiqe paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Oveqatsit aṅqw moṅwtunatya hakiy moṅwit tiat nāaptsinaqw eṅem nōvatiwhqat anta. ");
INSERT INTO hopNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Put naat nōviwhqat aw tūtsamiwyuṅqamuy wáṅwayyaniqat ōviy ayamuy aṅqe’ ayata. Noqw tūtsamiwyuṅqam awyaniqey qa nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pahsat pu piw pam pētuy tumal’aymuy ayataqe amumi paṅqawu: Uma tūtsamiwyaṅqamuy amumi paṅqaqwani: Taay, nōva pās yukilti; nu iwakasvokmuy, pu iwakashoymuy wi’yuṅqamuy qöya; noqw shosoy himu pās yukiwta. Uma nāaptsinaqat ep nōviwhqat awyani. ");
INSERT INTO hopNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Noqw puma put paysoqtotaqe, haqe’ nankwusa, suhk̇a pāsay aw’i, pu suhk̇a huhyanpiy aw’i. ");
INSERT INTO hopNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Noqw pētu tumal’aymuyatuy ṅuahtotat, pumuy okiwsasnat, qöqya. ");
INSERT INTO hopNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Noqw moṅwi put navotqe itsivuti; nihqe pumuy amumi solāwamuy ayataqw, puma tumal’aymuyatuy qöqyaqamuy tuwat qöqya; nit kitsókiyamuy taqtsokya. ");
INSERT INTO hopNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Noqw pahsat pu moṅwi tumal’aymuy amumi paṅqawu: Pas nāaptsiniwhqat ep nōviwhqat pās yukiwta; noqw kurs tūtsamiwyaqam qahopitu. Noqw ōviy soon pumuy amuṅaqw haqawa nōviwhqat aṅqw nösni. ");
INSERT INTO hopNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Taay, uma aṅqe’ pöhut aṅ nankwuse’, hakimuy hihsa’nihqamuy tutwe’, uma pumuy nōviwhqat aw tūtsamtotani. ");
INSERT INTO hopNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Noqw ōviy puma tumal’a’yat aṅqe’ pöhut aṅ nankwusaqe, hakimuy hihsa’nihqamuy tutwaqe, paṅso tsovalaya, qalomásinmuyu, pu lomasinmuyu. Noqw haqam nāaptsiniwhqat ep sinom ohpo. ");
INSERT INTO hopNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Noqw moṅwi tūtsamiwyuṅqamuy amumi kuyvatoqe, ep pákihqe, hakiy tāqat nāaptsiniwhqat ep yuwsit qa yuwsi’taqat tuwa. ");
INSERT INTO hopNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nihqe pam put aw paṅqawu: Ikwátsi, ya um hin nāaptsiniwhqat ep yuwsit qa yuwsi’k̇aṅw pew paki? Noqw kurs pam hiṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pahsat pu moṅwi tumal’aymuy amumi paṅqawu: Huvam māyat, pu hok̇ayat somyat ayo’haqami ihpomi qalālat aw uma tūvayani. Pep tsaykitiwni, pu tama ṅuritiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pay as k̇aysiwhqam wáṅwayniwya; nīk̇aṅw pay híkiyom namorstiwya. ");
INSERT INTO hopNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pahsat pu Pharisee‐sinom ahpiyyaqe, hin as put lavayiyat akw núansanyaniqey ōviy namivavasiwnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nihqe puma hakimuy pumuy amumi nánatuwnayaqamuy pu Herod aṅqw wīsiwtaqamuy Jesus aw hōnayaqw, puma paṅqaqwa: Tūtutuqaynaqa, itam ūmi navoti’yuṅqw, um pas qaatsatnihqat hintsaki; nihqe um God tuwiyat suan tūtutuqayna; pu um qa sinonuiña, ispi um sinmuy wuwniyamuy qa k̇aptsi’taqee. ");
INSERT INTO hopNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Um kurs ōviy itamuy āawnani, Ya um hin wūwanta? Ya pay itam hihta aṅ sivit Caesar aw ōoyyaniqw pam súanta? Sen qa súanta? ");
INSERT INTO hopNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Noqw Jesus pumuy nukpantunatyayamuy tuway’taqe, amumi paṅqawu: Ya uma hinoqw nuy unaheptota, nawip’ew hintsatsk̇aqamu? ");
INSERT INTO hopNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kurs tax ep sīvat inumi mahtaknayaa. Noqw puma put aw put mahtaknaya. ");
INSERT INTO hopNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Noqw pam amumi paṅqawu: Ya i’ hakiy taywaata? Pu hakiy tuṅwniat aṅ pey’ta? ");
INSERT INTO hopNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Noqw puma put aw paṅqaqwa: Caesar hapi. Pahsat pu pam amumi paṅqawu: Panta hápiniqw; ōviy uma Caesar himuyat Caesar aw noayani; pu uma God himuyat God aw noayani. ");
INSERT INTO hopNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Noqw puma yan nanaptaqe, kurs hiṅqaqwaqe, k̇ātayuṅt, put mātapyat, ahpiyya. ");
INSERT INTO hopNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Noqw pay put tālat ep hakim Sadducee‐sinom, yaw so’pum pay ahoy qa yesvaniqat paṅqaqwaqam, put aw ökihqe tūviṅtotaqe, ");
INSERT INTO hopNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Aw paṅqaqwa: Tūtutuqaynaqa, ura Moses hapi paṅqawu: Kurs tāqa qa tímuy’k̇aṅw mokq, put pāvaat, sen tupkoat put nȫmayatniṅwuqat amum qatupte’, put eṅem tíoymantani. ");
INSERT INTO hopNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Noqw ura as hakim tsáṅe’nihqam nānatupkom yēse. Noqw amuṅaqw suspavaam as nȫmatat, qa tímuy’vat, pay mōki; nihqe tupkoy aw nȫmay mātavi. ");
INSERT INTO hopNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Noqw aṅknihqa pay piw anhti; noqw pu amuṅknihqa pay piw amunhti. Noqw puma as tsáṅe’nihqam put nȫmatotaqw, qa hihtawat eṅem wuhti ti’va. ");
INSERT INTO hopNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Noqw nuhtuṅk pu’ wuhti tuwat mōki. ");
INSERT INTO hopNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Noqw ya ōviy sinmuy ahoy yesvaqw, pam hihtawat pumuy tsáṅe’nihqamuy nȫmaatni? Pi puma sohsoyam put nȫmatota. ");
INSERT INTO hopNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Noqw Jesus amumi paṅqawu: Suyan pi uma tutuvenit‐nik̇aṅw pu God öqalayat qa tuwi’yuṅwa. Nihqe paniqw hapi ōviy uma qa suan wūwaya. ");
INSERT INTO hopNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pi sinom ahoy yesve’, soon nȫmalalwani, piw soon puwsuṅwlalwani; pas puma ōveqatsit ep God hoṅviaymuyatuy amunyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Noqw kurs uma so’qam ahoy yesvaniqat ep tūviṅtotaqw‐ya uma qa hisat tutuvenit aṅ it tuṅwáya: Ura God umumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nu hapi Abraham, pu Isaac, pu Jacob, pumuy Tutuyqawhqaamu, it’a? (Noqw ōviy puma nāto yēse.) Oviy pi God qa so’pumuy amumi tutuyqawi, pi yesqamuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Noqw sinom it nanaptaqe, put tutuqayhpiyat ep k̇ātayuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Noqw yaw pam Sadducee‐sinmuy moavöltaqat Pharisee‐sinom nanaptaqe, puma sumitsovalti. ");
INSERT INTO hopNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Noqw pumuy amuṅaqw suhk̇a tutavot aw tuvoti’taqa put unahepqe, tūviṅtaqe aw paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tūtutuqaynaqa, ya tutavot ep himuwa pas suspavani? ");
INSERT INTO hopNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Noqw Jesus put aw paṅqawu: Um God Uhtutuyqawhqay aw sohsok uh’unaṅway akw unaṅway’tani, pu sohsok uhhikwsiy akw’a, pu sohsok uhwuwniy akw’a. ");
INSERT INTO hopNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","I’ hapi susmohti‐nik̇aṅw pu suswuyoq tutavo. ");
INSERT INTO hopNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Noqw aṅknihqa pay piw put anta: Um pas nāmi hin unaṅway’taqey pan uhsinosṅway aw unaṅway’tani. ");
INSERT INTO hopNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pi sohsoy tutavo pu Tutuyqawhqat lavay’aymuyatuy lavayiam imuy lȫqmuy tutavot hapi ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Noqw nāt Pharisee‐sinom tsovawtaqw, Jesus pumuy tūviṅtaqe, ");
INSERT INTO hopNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Amumi paṅqawu: Ya uma hin Christ aw wūwantota? Ya pam hakiy tíata? Noqw puma put aw paṅqaqwa: David hapi pam tíata. ");
INSERT INTO hopNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Noqw pam pumuy amumi paṅqawu: Noqw pantaqw hinoqw David Qahováriwtaqat Hikwsit ahpiy put Moṅwílawu? Oviy pi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tutuyqawhqa Imoṅwiy aw paṅqawu: Um hāk iputvaqewat qátuni, hisat nu uhtuwqamuy áṅwutaqw, puma ūmi maqaptsi’yuṅwniqat pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Noqw kurs David put Moṅwílawhq, hin pam put tíatni? ");
INSERT INTO hopNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Noqw soon kurs hak put hu’wani. Piw pāpu qa hak pahpiy put hihta tūviṅtaniqey aw unasaki. ");
INSERT INTO hopNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pahsat pu Jesus sinmuy‐nik̇aṅw pu put aw nánatuwnayaqamuy amumi lavayhtiqe, ");
INSERT INTO hopNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Paṅqawu: Tutavot tūtutuqaynayaqam Pharisee‐sinmuy amumum Moses qeniyat ep hōñi. ");
INSERT INTO hopNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Paniqw ōviy uma pumuy lavayiyamuy aw tūqayyuṅwi, pu umuy hinhtotiniqat umumi paṅqaqwaqw uma panhtotimantani; nīk̇aṅw uma pumuy qa tututsk̇anayani. Taq puma as nuhtumi yuaatiwisk̇ahk̇aṅw, lavayiy qa an hinwisa. ");
INSERT INTO hopNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Taq puma soñawnen hihta s’nö putut mok̇ahtotat, hakiy īkwiltoynayaṅwu; nīk̇aṅw soon ṅas’ew put paaṅwayaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nihqe nāp hihta hintsatsk̇aqey mahtakni’yuṅwniqey ōviy pantsatsk̇a. Puma God lavayiyat hihta aṅ pey’yuṅqat put qötösosomhpi’yuṅṅwu, pu may aṅ pīwu, pu yuwsiy wupatsamimhtoynaya. ");
INSERT INTO hopNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pu haqe’ nōviwhqat aṅ mohk̇aqe qeqnit tuṅlay’yuṅṅwu, pu tsotsvalkiva qenit pas pávanyaqat pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pu sinom kīsonva pumuy pas hihtay’yuṅwniqat nānawakna, pu Tutuqaynaqa yan túṅwantiwyaniqey tuṅlay’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Noqw uma hapi Tutuqaynaqa qa yan túṅwantiwyani; pi sūk̇a umuy tutuqaynaqa, Christ; noqw uma sohsoyam nānatupkomu. ");
INSERT INTO hopNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pu uma tūwaqatsit ep qa hakiy nálalwani; pi sūk̇a Umunaa, ōveqatsit ep qátuhqa. ");
INSERT INTO hopNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pu piw uma Tūtsami’wisqey qa yan túṅwantiwyani; pay pi sūk̇a umuy tsāmi’maqa, Christ. ");
INSERT INTO hopNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pay umuṅaqw pas suspavannihqa umuy tumalay’mani. ");
INSERT INTO hopNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Haqawa pavan nāhihtataqa hapi qahimuniwhtini; pu nāqahihtataqa hapi a’nö hímuniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nīk̇aṅw is ohi uma tutavot tutuqaynayaqamu, pu Pharisee‐sínomu, nawip’ew hinyuṅqamu! pi uma ōveqatsit aṅqw moṅwtunatyat aw sinmuy uhtsi’yuṅwa; uma as qa aw yuṅtak̇aṅw, aw yuṅniqamuy qa nakwhantoynaya. ");
INSERT INTO hopNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Is ohi uma tutavot tutuqaynayaqamu, pu Pharisee‐sínomu, nawip’ew hinyuṅqamu! uma koṅnanalvutuy kīkiyamuy nawhkilalwa; pu uma nawip’ew nānawakne’, sutsépyuaaykuyaṅwu. Paniqw hapi ōviy uma pas pavan qalomáyukuniwyaniqey aqw hoyta. ");
INSERT INTO hopNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Is ohi, uma tutavot tutuqaynayaqamu, pu Pharisee‐sínomu, nawip’ew hinyuṅqamu! Pas pay uma hakiy umuhtuptsiwniy aw tuptsiwnayaniqe ōviy pātuwaqatsit, pu tūwaqatsit aṅ ahsupoq nankwusaṅwu. Noqw uma put aw tuyqawvayaqw, pam umuhpenihqe pas qalomáhintsakṅwu. Noqw ōviy God nawus maskive qȫhit aqw put sivintoynani, umuhpenihqe hóyokiwtaqata. ");
INSERT INTO hopNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Is ohi uma tūtsamyaqam qapostalyaqamu! Oviy pi uma paṅqaqwa: Hak lavayhte’: Nam ilavayi God kīyat hin hūrs wúnuhqat pan wúnuni kite’, pam soñawnen qa hinwat lavayhtiṅwu. Nīk̇aṅw kurs pam Ilavayi it sik̇avalasivat God kīyat epnihqat an pasiwtani kite’, pam nawus lavayiy kurs hin qa anhtini. ");
INSERT INTO hopNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Uma ṅasta wuwni’yuṅqamu qapostalya! Ya himuwa pas pávanniqw ōviy’o? sen sik̇avalasiva? sen God kīata? Pi put kīat hapi sik̇avalasivat pas hihtataṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Uma piw pan tūtutuqaynaya: Hak lavayhte’: Nam ilavayi God kīyat ep hom’oyvihk̇at an pasiwtani, kite’, pam soñawnen qa hinwat lavayhtiṅwu. Nīk̇aṅw hak lavayhte’: Nam ilavayi hom’oyvihk̇at ep kuwahtiput an pasiwtani, kite’, nawus pam lavayiy kurs hin qa anhtini. ");
INSERT INTO hopNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Uma núanhihtu qapostalyaqamu! Ya himuwa pas pávanniqw ōviy’o? sen kuwahtipu? Sen hom’oyvihk̇a? Pi pam hapi kuwahtiput pas hihtataṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Paniqw ōviy hom’oyvihk̇at akw öqalat lavayiy pasiwnaqa piw kuwahtiput pep oyiwhqat akw pan lavayhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Piw God kīyat akw öqalat lavayiy pasiwnaqa piw God pep ki’taqat akw pan lavayhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pu hak ōveqatsit akw öqalat lavayiy pasiwnaqa hapi God moṅw’atsvewayat akw pan lavayhtiṅwu, pu put ep tsokiwtaqat akw’a. ");
INSERT INTO hopNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Is ohi uma tutavot tūtutuqaynayaqamu, pu Pharisee‐sínomu, nawip’ew hinyuṅqamu! uma pi umuh’uyiy aṅqw nēnevenit pakwút‐sikivo sun oyit God aw noayaṅwu; nīk̇aṅw soq God tutavoyat pas pávanyaqat uma ayo yuykuya; uma sinmuy amuṅem suan hin yukuyaniqey qe’toti; uma ṅasta núokway’yuṅwa; uma qa suan hinwisa. Uma as pávanyaqat tutavot aṅ ahsupoq hinwisnik̇aṅwo, pu it qa pas qatuvosnihqat aṅ pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Uma hihtu qapostalk̇ahk̇aṅw tūtsamyaqamu! pas uma totophohyat ōviy kūyit tsahkwakink̇ahk̇aṅw, it himuvohkot pȫlay’taqat kwukwú’ya. ");
INSERT INTO hopNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Is ohi uma tutavot tūtutuqaynayaqamu, pu Pharisee‐sínomu, nawip’ew hinyuṅqamu! Uma kuyapkuyit, sen tsaqaptat ōvaqe‐sa kwaṅw’ewakwnihqat anyuṅwa, nīk̇aṅw soq hihta tukwhanayaniqey‐sa tunatyawyuṅwa, Pu uma qanamítuyqawi’yuṅṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Um qapostal Pharisee‐sino, um mohti uhkuyapiy ahsonṅaqw kwaṅw’ewakwtaqw, pam ōvaqe piw kwaṅw’ewayni. ");
INSERT INTO hopNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Is ohi uma tutavot tūtutuqaynayaqamu, pu Pharisee‐sínomu, nawip’ew hinyuṅqamu! Uma tūtuamit qötsálwiwyuṅqat anyuṅwa. Pay as antsa pi pam ōvaqe lomasosniwa; noqw pi ahsonve sinmuy ȫqaam aṅ opom’iwyuṅwa, pu sohsoy himu toyoy’eway’o. ");
INSERT INTO hopNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Noqw pan uma suovaam pay suan hinyuṅqey nuhtumi namtaknaya; nīk̇aṅw uma pan atsáy’k̇ahk̇aṅw qa súanhinwisa. ");
INSERT INTO hopNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Is ohi uma tutavot tūtutuqaynayaqamu, pu Pharisee‐sínomu, nawip’ew hinyuṅqamu! Uma pi Tutuyqawhqat lavay’aymuyatuy amuṅem tuamhqölöt lomahinyuṅqat yuykuya, pu aṅ hakimuy súanyuṅqamuy haqe’ tūam’iwyuṅqat aṅ aw nukwáṅwsonilantotaqe, ");
INSERT INTO hopNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Paṅqaqwaṅwu: Pas as itam itanamuy qatsíyamuy ep yēse’, soon amumum Tutuyqawhqat lavay’aymuyatuy qöqyani. ");
INSERT INTO hopNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yan uma Tutuyqawhqat lavay’aymuyatuy qöqyaqamuy tímatnihqey nāsuhputsni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Taay! Huvam umunamuy hihta yayhnayaqat aw antsatsnaa. ");
INSERT INTO hopNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Uma lölöqaṅhtuy amunyuṅqamu, uma tsūtsu’tuy aniwnimatu! ya uma hin qȫhit aqw maspiwyaniqey aṅqw ayo nöṅakni? ");
INSERT INTO hopNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pantaqw ōviy meh! Nu hapi umumi lavay’a’yatuy hōnani, pu suan wuwni’yuṅqamuyu; pu tūtutuqaynayaqamuy nu umumi ayatani. Noqw haqawatuy uma qöqyani; pu haqawatuy nahoylehtsit aw múayani; pu haqawatuy uma umuhtsotsvalkiy aṅ a’nö wuvahtotani, nen aṅ aqwhaqami kitsókinawit pumuy okiwsahsanyani. ");
INSERT INTO hopNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Noqw God umuy hapi tukopani, sohsokmuy suan hinwisqamuy umunam qöqyaqat ahpiy’o, it súantaqat Abel qatsíyat ep’e, pu aṅk yesqamuy pīwu, pu Barachias tiyat Zacharias yan mātsiwhqat qatsíyat ep’e. Ura uma God kīyat‐nik̇aṅw pu hom’oyvihkat pumuy amuhtsave put nīnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pas antsa nu umumi paṅqawni: God pu’ qatsívaptsiwyuṅqamuy amumi sohsok it yantaqat ep nāoyni. ");
INSERT INTO hopNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Is ohi úmaa, Jerusalem ep sínomu! Is ohi umuṅemi! Uma Tutuyqawhqat lavay’aymuyatuy qöyantotaqamu, pu umumi ayatiwyaqamuy tatatupqöyantotaqamu! Pas as nu hihsakishaqam umuy tsovalani, kowakowuhti timuy masay atpik̇aqe taṅataṅwuqat pan’i; noqw uma qa nānakwha. ");
INSERT INTO hopNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Meh! God umuhkiy pay tatamhta. ");
INSERT INTO hopNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pi nu umumi paṅqawni: Pay uma yahpiy haqahpiy soon inumi yórikyani. Nīk̇aṅw ason hisat aw pituqw, uma paṅqaqwani: Tutuyqawhqat natṅwaniyat aṅ pitutoqa nam tayawintiwaa, uma kitotani; nen pep pu’ uma inumi piw yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pu Jesus paṅqw yamakt, God kīyat aṅqw ahpiy’o; noqw put aw nánatuwnayaqam God kīyat ep aṅ kīiwyuṅqat put aw mahtaknayaniqe put aw öki. ");
INSERT INTO hopNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Noqw Jesus pumuy amumi paṅqawu: Ya uma sohsok it aṅ qa tāyuṅwa? Pas antsa nu umumi paṅqawni: Pay nāt pas qa haqam i’ owa nāp qeniy epni. Pas sohsoy sahpukniwni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Noqw pam tsomot Olivet epeq qatuqw, put aw nánatuwnayaqam pay nanalt put aw ökihqe aw paṅqaqwa: Um itamuy āawnani: Ya īi hisat yaniwhtini? Pu uṅ hisat pítuniqat himu put tuawi’tani, pu qatsit sohtiniqata? ");
INSERT INTO hopNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Noqw Jesus lavayhtiqe pumuy amumi paṅqawu: Uma tunatyaltotini; noqw qa hak umuy ūnatoynani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Taq nāt k̇aysiwhqam inatṅwaniy aw yank̇ahk̇aṅw ök̇e’, paṅqaqwani: Nu’ hapi Christ kitotani, nen k̇aysiwhqamuy ūnatoynayani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pu uma nāqöyiwuy yāvaqnihqat nanvotyani, pu umuhhayhk̇e’ nāqöytaqw uma nanaptani. Nīk̇aṅw uma qa hin unaṅwtotini. Pi pay pam pāvantaqa pas soon qe’ni. Nīk̇aṅw pay hapi nāt qa pep so’ṅwamiq pítuni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pi aṅqe’ hihtuwat sinom hihtuywatuy sinmuy amumi wuṅkuyamantani. Pu moṅwtunatya sukw moṅwtunatyat ehpewhtimantani. Pu hāhaqe’ tsöṅösqatsini, wukotuyhqatsini, pu tutskwa tayayaykuni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ii hapi hīhihta k̇ānanvotpit yayhniata. ");
INSERT INTO hopNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Noqw sinom sohsoyam umumi qa suhtaq’ewyani, uma isinomniqw ōviy’o. Noqw puma umuy okiwsahsanyat, umuy qöqyani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Noqw pahsat pu k̇aysiwhqam tuptsiwniy aṅqw lasye’, nānami qa suhtaq’ewyani. Noqw sūk̇a sukw momṅwituy aw mātapni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Noqw k̇aysiwhqam hoṅve’, Tutuyqawhqat lavay’aymatnihqey atsáy’k̇ahk̇aṅw k̇aysiwhqamuy ūnatoynayani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ephaqam qaanhtipu tūwaqatsit aṅ ahsupoq kúrukiwmani, noqw ōviy k̇aysiwhqam nami’naṅway aṅ peveltotini. ");
INSERT INTO hopNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Noqw pay yūmosa aṅ kuytaqa hapi ayo yámakni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Noqw isinom tūwaqatsit aṅ ahsupoq it lomatuawit yuaatotaqw, sinom sohsoyam nanaptani. Noqw pep pu’ so’ṅwamiq pítuni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ura Tutuyqawhqat lavay’ayaat Daniel yan lavayhti: Hak nuhtsel’ewaynihqa tūkiqötaniqa wunuptuni. Aṅ túṅwantaqa māmatsni. Noqw ōviy ason uma put God kīyat pas himunihqat ep wúnuhqat aw yórikyaqw, ");
INSERT INTO hopNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pep pu’ ima Judeat aṅ yesqam tuhtukwimiq watqani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pu i’ hak kits’oveqnihqa paṅqw hāwe’, nawus soon hihta ōviy ahpami papkini, súwayaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Pu i’ hak pasve hinnumqa soon yuwsiy ōviy kīmini. ");
INSERT INTO hopNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Noqw hisat aw pituqw, pep hapi pu’ haqawat aṅ nö’yiwyuṅqamuy, pu yōyoṅnayaqamuy kurs hin watqaniqamuy amuṅem pas is óhini. ");
INSERT INTO hopNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Noqw pas pay okiw uma qa tömö’ watqaniqey ōviy Umunay aw tūviṅlalwani, piw qa nasuṅwintalöṅnit ep’e. ");
INSERT INTO hopNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Taq pep aw pituqw, qaan’ewakw k̇ānavotpini, pas tūwaqatsit hisat yukiltiqat aṅqw pew pahsavo qa hisat pan hiniwhtiqat pan’i, pas qae, piw soon hisat pāpu paniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Noqw as talöṅwintiwhqa qa pelvotiqw, soon hak ayo yámakni. Noqw pay hapi Tutuyqawhqat namoramuyatuy amuṅem tunatyat ahpiy pam pelvotini. ");
INSERT INTO hopNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pep pu’ ason kurs hak umumi, Meh, yep Christ kitaqw, sen Ayamo, kitaqw uma qa tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Taq nāt hakim Christ‐nihqey nātsok̇ani’yuṅqam mātaqtotini; pu Tutuyqawhqat lavay’aymatnihqey nātsok̇ani’k̇ahk̇aṅw hoṅvani, qa púmayak̇aṅwo; nen hīhihta k̇ātatayhpit hihta tuawi’taqat hintsatsk̇ani, pas qaöwíhintaniqw ōviy kurs as hin pasiwtaniqw hikis pi aṅ Tutuyqawhqat namoramuyatuy ūnatoynayani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Noqw meh, uma hapi pay nanapta, ispi nu aṅwu pay umuy put āawnaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Paniqw ōviy kurs puma umumi Meh, taq pam qayēsiwhpuve qatu, kitotaqw, uma qa awhaqamiyani; sen Meh, pam yūpaveq qatu, kitotaqw, uma qa tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pi hōpaq talwihpiki tēveṅehaqami mātaqtiṅwu; noqw pay hapi pantani hisat Nu, Sinot Tiat, pítuniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pi haqam himu mokput tokoatniqw, paṅso wiwsokt tsovaltiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Noqw pahsat put k̇ānavotpit atsve āpiy pay tāwa qa tālawvani, pu mūyawuy aṅqw qa talni, pu sōtu tokpelat aṅqw löhöhöykuni, pu ōvaqe hīhimu öqala tayayaykuni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Noqw pahsat pu himu tokpelat epeq mātsiltini, nuy Sinot Tiyat pítuniqat tuawi’taniqee. Noqw pahsat pu tūwaqatsit ep sohsoyam nanāpwat sinom tsaykitani; noqw pu Nu, Sinot Tiat, öqalat yank̇aṅw, qaan’ewakw son’iwk̇aṅw, ōvaqe ōomawhtuy akw hawtoqw, puma nuy tutwani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Noqw itötöqpi a’nö töqtiqw, nu ihoṅviaymuy aṅqe’ ayatani; noqw puma inamoramuy tūwaqalvoqhaqami yesqamuy nānan’ivaqw tsovalayani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Taay, kurs uma nönvospaltsokit hihta tuawi’taqat nanaptani. Put nantaqaat palmokte’ sákwawsate’, nahpi’wisq, kurs tal’aṅwhayiṅwtiqat uma nanaptaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Noqw pan hapi uma sohsok īit hihta aw yórikye’, soon pas nu hisat pítuniqat uma nanaptani. Pep hapi nu soñawnen hötsíwhpeq wúnuhqat uma nanaptani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pas antsa nu umumi paṅqawni: Soon nāt ima sinom tūtuwayaqw, pay īi sohsoy yaniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pay tokpela, pu tūwaqatsi tūwayani; nīk̇aṅw ilavayi hapi pas soon tūwayani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nīk̇aṅw hisat aw pítuniqat, pu haqe’ qalawmaqwhaqamniqat hapi qa hak navoti’ta. Pas qae, ōveqatsit ep hoṅvia’yam hikis qa navoti’yuṅwa. Pas Ina nāla put navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noqw ura Noet qatsíyat ep hin hiniwhtiqat pay hapi piw pantani hisat Nu, Sinot Tiat pítuniqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pay ura nāt qa pātsikq, sinom nōnova, pu hīhikwya; nȫmalalwa, pu puwsuṅwlalwa, hisat Noet pākihut aqw pákihqat aw pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nihqe puma qanavoti’yuṅqe pātsikq, puma sohsoyam súlawhti. Noqw pay piw hapi pantani hisat nu’ Sinot Tiat pítuniqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pep pu’ hakim lȫyöm haqam pasveni; suhk̇a wīkiwhq, suhk̇a akwsiṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pu hakim lȫyöm wuhtit ṅúmantani; suhk̇a wīkiwhq, suhk̇a akwsiṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Pantaqw ōviy uma tunatyawyuṅwni, taq Umuhtutuyqawhqa hisat pítuniqat uma qa navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Noqw uma it navoti’yuṅwni: Pi as ki’taqa uyiṅwut hísatniqw pítuniqat navoti’te’, soon qa tūwalani, nen soon put kīyat haqe’ aw pákiniqw pam pánani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Paniqw ōviy uma pās moṅwvas’iwyuṅwni; taq uma nāt qa pan wūwantotaqw, nu’, Sinot Tiat pítuni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Taa. Ya hak haqam hihta aṅ suan hinmaqa suan wuwni’taqa tumal’aya? Put hapi moṅwi tumalsuṅwamuyatuy amumi moṅwtapq, pam pumuy aṅsakis tunöshuylawni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kurs moṅwi hisat ahoy pite’, put nāt suan tumalay’maqat aw yorikq, pam hahlayhpit epni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pas antsa nu umumi paṅqawni: Put moṅwíat pas soon put qa sohsok hihta himuy aw moṅwtapni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nīk̇aṅw kurs as pam tumal’aya qahopinen, pam unaṅwpeq paṅqawni: Imoṅwi pítuniqey pas nāt haqami tavi’ma, kítani. ");
INSERT INTO hopNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nen pu’ tumalsuṅwamuy wuvahtivak̇aṅw, pu honaqkuyit akw hōnaq’iwyuṅqamuy amumum tūmoyk̇aṅw, pu hīhikwni. ");
INSERT INTO hopNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pu pam qa hin pan wūwank̇aṅw, moṅwiy qa nuhtay’taqw, ");
INSERT INTO hopNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pam pite’ put pavan pas a’nö sivintoynani. Noqw pam nawip’ew hinyuṅqamuy amumum nātuwiwni. Pep a’nö tsaykitiwni, pu tama ṅuritiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Pahsat pu ōveqatsit aṅqw moṅwtunatya hakimuy pakwtnihqamuy mámanhtuy amuntani. Puma wihqöhiy ömahtota, möönaṅwhtiniqat ahsawvawisa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Noqw pumuy amuṅaqw tsívotnihqam wuwni’yuṅqw, pu tsívotnihqam qa wuwni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Qa wuwni’yuṅqam wihqöhi’wisk̇ahk̇aṅw, tövukuyit qa mask̇ay’wisa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Noqw wuwni’yuṅqam wihqöhi’wisk̇ahk̇aṅw, tövukuyit hihta aṅ kūyi’wisa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Noqw möönaṅw nawutsnaqw, puma sohsoyam puwso’qe tokva. ");
INSERT INTO hopNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Noqw suhtokihaq hak a’nö paṅqawu: Meh, möönaṅw aṅq’ö, huvam ahsawvawisaa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pahsat pu puma mamanht sohsoyam hoṅvaqe, wihqöhiy aw hintsatsna. ");
INSERT INTO hopNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Noqw qa wuwni’yuṅqam wuwni’yuṅqamuy amumi paṅqaqwa: Itamuy umuhtövukuyiy aṅqw maqayaa, taq itahwihqöhi tōkiwwisa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Noqw wuwni’yuṅqam lavayhtotiqe paṅqaqwa: Sóoni, taq k̇a itamumi nan’ivo qa aptsiwtani, tis pi uma huhyayaqamuy amumiye’, nenṅem tuiyani. ");
INSERT INTO hopNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Noqw pumuy nāt tuiwisq möönaṅw pitu; noqw ima moṅwvas’iwyuṅqam put amum nāṅuiwniqat ep nōviwhqat aw yuña, noqw ihpoq uhtsilti. ");
INSERT INTO hopNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Atsve pu’ mimawat mamanht piw tuwat ökihqe, paṅqaqwa: Moṅwi, Moṅwi, itamuṅem hötaa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Noqw pay pam lavayhtiqe paṅqawu: Nu umumi pas antsa paṅqawni: Nu umuy hakimuy qa tuwi’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yantaqw ōviy uma tunatyawyuṅwni, pi uma hisat talöṅvaqat, pu haqe’ qalawmaqw nu’ Sinot Tiat pítuniqat qa navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Pi nu hakiy haqami yāvoqnihqat antani. Pam hak tumal’aymuy wáṅwayhqe, amumi hihta himuy noa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nihqe sukw aw tsivót‐sikip sōmorit sīvat oya, nit pu sukw aw lȫp sōmorit sīvata, nit pu sukw aw sūp sōmorit sīvata, hin nanāpwat akw moṅwvastotiniqat pan pakwámna; nit pahsat pay haqami nakwsu. ");
INSERT INTO hopNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pahsat pu i’ tsivot‐sikip sōmorit sīvat ömahtaqa ahpiynihqe, put akw huhyaqe, put aw tsivót‐sikip sōmorit sīvat hóyokna. ");
INSERT INTO hopNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pu i’ lȫp sōmorit sīvat ömahtaqa piw put anhtiqe, lȫp sōmorit sīvat put aw hóyokna. ");
INSERT INTO hopNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Noqw pu sūp sōmorit sīvat ömahtaqa ahpiynihqe, tutskwave haṅwat, paṅsoq moṅwiy sīvayat tupk̇a. ");
INSERT INTO hopNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pu ahpiy wūyavotiqw, pumuy moṅwíam pítuhqe, pumuy amumi put ep pohta. ");
INSERT INTO hopNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Noqw ōviy i’ tsivót‐sikip sōmorit sīvat ömahtaqa pituhqe, piw tsivót‐sikip sōmorit sīvat kívahqe, paṅqawu: Moṅwi, ura as um tsivót‐sikip sōmorit sīvat inumi noa, noqw meh, nu put aw tsivót‐sikip sōmorit sīvat hóyokna. ");
INSERT INTO hopNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Noqw put moṅwíat aw paṅqawu: Um súanhti, um lolma qa paysoq hintsakqa tumal’aya, um tsa’ tuwanit ep qa paysoq hintsaki. Noqw ōviy nu uṅ pavan wūhaq tuwanit aw moṅwtapni. Um uhmoṅwiy amum hahlayni. ");
INSERT INTO hopNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pu tuwat i’ lȫp sōmorit sīvat ömahtaqa pítuhqe aw paṅqawu: Moṅwi, ura as um lȫp sōmorit sīvat inumi noa; noqw meh, nu lȫp sōmorit sīvat put aw hóyokna. ");
INSERT INTO hopNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Noqw put moṅwíat aw paṅqawu: Um súanhti, um lolma qa paysoq hintsakqa tumal’aya; um tsa’ tuwanit ep qa paysoq hintsaki. Noqw ōviy nu uṅ pavan wūhaq tuwanit aw moṅwtapni. Um uhmoṅwiy amum hahlayni. ");
INSERT INTO hopNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pahsat pu i’ sūp sōmorit sīvat ömahtaqa pituhqe, paṅqawu: Moṅwi, nu ūmi navoti’taqw, um a’nö unaṅway’ta; nihqe um haqam qa uyht ep höqṅwu, pu haqe’ poshumit qa tsalakin’uyht aṅ hihta tsovalaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Noqw nu uṅ mamqasqe, ōviy ahpiynihqe, uhsivay tutskwave tupk̇a; noqw meh, yep uhsiva. ");
INSERT INTO hopNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Noqw put moṅwíat lavayhtiqe put aw paṅqawu: Is okiw um hak qahopi, naöntumal’aya! Pas as um inumi navoti’taqw, nu haqam qa uyht ep höqṅwunik̇aṅw, pu haqe’ poshumit qa tsalakin’uyht paṅ tsovalaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Himu pi um sīvat aw tunatyawyuṅqamuy amumi isivay óyanik̇aṅwo; noqw nu hisat pite’, isivay ep sivit enaṅ ömahtani. ");
INSERT INTO hopNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pahsat pu tumal’aymuy amumi paṅqawu: Huvam sīvat nawhkiyaa, nen pakwút‐sikip sōmorit himuy’taqat put maqayaa. ");
INSERT INTO hopNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pi hakiy himuy’taqat aw himu noiwmantani, noqw pam hihta nihti’tamantani; nīk̇aṅw hihta öwihimuy’taqw, hikis pam put nawhkiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pu uma it ṅasta apit tumal’ayat ihpo qatālat awhaqami tūvayani; pep tsaykitiwni, pu tāma ṅuritiwni. ");
INSERT INTO hopNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ason nu’ Sinot Tiat sohsokmuy ihoṅvia’yamuy tsamk̇aṅw, lolma tālawṅway’k̇aṅw pite’, pep pu’ nu pas k̇aptsi’tiwk̇aṅw, imoṅw’atsveway ep qatuptuni. ");
INSERT INTO hopNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Noqw sohsoyam hihtu nanāpwat sinom inutpipo tsovaltini; noqw nu pumuy pep nāhoy tsīk̇ani, lālayhqa kanelmuy kakapirstuy amuṅaqw tsīk̇aṅwuqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nen nu kanelmuy iputvaqewat óyani, pu kakapirstuy isuyvaqewata. ");
INSERT INTO hopNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nen nu iputvaqewat tsovawtaqamuy amumi paṅqawni: Huvam pewyaa, Inay aṅqw hahlaywaqamu; nen uma umuhmoṅwiy umeṅem hihta na’sastaqat makiwyani, tūwaqatsit hisat yukiltiqat aṅqaqw umuṅem na’sastiwhqat put’a. ");
INSERT INTO hopNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pi ura nu tsöṅmokiwtaqw, uma nuy nopnaya; nu pānaqmokiwtaqw, uma nuy hikwnaya; nuy kurs hákiyniqw, uma nuy pās taviya; ");
INSERT INTO hopNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nuy qa yuwsi’taqw, uma nuy yuwsinaya; nuy tūtuyhq, pu sivikive pakiwtaqw, uma nuy pohtaya. ");
INSERT INTO hopNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pahsat pu ima suan hinyuṅqam lavayhtote’, paṅqaqwani: Moṅwi ya hisat uṅ tsöṅmokiwtaqw, itam uṅ tutwaqe nopnaya; uṅ pānaqmokiwtaqw, itam uṅ hikwnaya? ");
INSERT INTO hopNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ya hisat um kurs hákiyniqw, itam uṅ tutwaqe pās taviya, uṅ qa yuwsi’taqw, uṅ yuwsinaya? ");
INSERT INTO hopNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pu ya hisat um tūtuyhq, pu sivikive pakiwtaqw, itam uṅ tutwaqe uṅ pohtaya? ");
INSERT INTO hopNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Noqw nu lavayhte’, amumi paṅqawni: Pas antsa nu umumi paṅqawni: Pay uma imuy itupkomuy amuṅaqw hihtawat sushin’ewakw aw pan unaṅwtapye’, uma inumi unaṅwtapyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Pahsat pu nu imuy isuyvaqewat tsovawtaqamuy amumi paṅqawni: Huvam inuṅaqw ahpiyaa, uma God itsivuyat akw nankiwakw hinhtotiqamu. Qȫhit qa tsohtso’ṅwuqat aqw uma maspiwyani, it qȫhit Nukpanat éṅem‐nik̇aṅw pu hoṅviaymuyatuy amuṅem na’sastiwhqat aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pi ura nu tsöṅmokiwtaqw, uma nuy qa nopnaya; nuy pānaqmokiwtaqw, uma nuy qa hikwnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ura nu kurs hákiyniqw, uma nuy qa pās taviya; qa yuwsi’taqw, uma nuy qa yuwsinaya; nuy tūtuyhq, pu sivikive pakiwtaqw, uma nuy qa pohtaya. ");
INSERT INTO hopNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pahsat pu puma tuwat lavayhtote’, paṅqaqwani: Moṅwi, ya hisat um tsöṅmokiwtaqw, pu pānaqmokiwtaqw, sen kurs hákiyniqw, sen qa yuwsi’taqw, sen tūtuyhq, sen sivikive pakiwtaqw, itam uṅ tutwak̇aṅw ūmi qa unaṅwtapya? ");
INSERT INTO hopNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pahsat pu nu lavayhte’, amumi paṅqawni: Pas antsa nu umumi paṅqawni: Pay uma imuy amuṅaqw sushin’ewakw aw qa unaṅwtapye’, uma inumi qa unaṅwtapyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Noqw ima hapi sivihpit sútsepniqat aqwyani; noqw suan hinwisqam qatsit qaso’taqat awyani. ");
INSERT INTO hopNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Noqw Jesus yan lavayiy yúkuhqe, pahsat pu pam put aw nánatuwnayaqamuy amumi paṅqawu; ");
INSERT INTO hopNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Uma navoti’yuṅqw lötok hapi ura amutsva‐yūmosanihqat ep nōviwniqat aw pítuni. Noqw ep hapi nu’ Sinot Tiat momṅwituy amumi mātaviwhq, puma nahoylehtsit aw nuy muayani, kita. ");
INSERT INTO hopNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Noqw ephaqam hakim pavansinom hakiy Caiaphas kīyat ep tsovalti, God awwat susmohpeq moṅwit kīyat ep’e‐ímaa: God awwat mohpeq momṅwit‐niqw, pu tutavot tutuqaynayaqam‐niqw, pu sinmuy amuṅaqw wukw’a’yamu. ");
INSERT INTO hopNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nihqe hin as puma nanauyve Jesus ṅuaye’ nīnayaniqey pavasiwnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nit pay paṅqaqwa: Pay qa nōviwhqat epni, taq k̇a sinom qaunáṅwtalawvayani. ");
INSERT INTO hopNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Noqw Jesus Bethany ep hakiy tokoplelet tūtuyṅwuqat Simon kīyat epniqw, ");
INSERT INTO hopNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Pumuy nōnovaqw, hak wuhti wihkuyit kwaṅwáhovaqtuqat a’nö hihk̇ay’taqat hihta aṅ kūyiwtaqat yawk̇aṅw ep paki, wikorot hihta owat alabaster aṅqw yukiwtaqa aṅ kūyiwtaqata; nihqe wikorot yōhaqe, Jesus qötöyat aw wihkuyit wūta. ");
INSERT INTO hopNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Noqw Jesus aw nánatuwnayaqam aw yórikyaqe, qayan unaṅwtotiqe paṅqaqwa: Ya i’ wihkuyi hinoqw paysoq hovalniwa? ");
INSERT INTO hopNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aṅwu k̇a as pam wūhak ōviy huyiwe’, aṅ ōokiwyuṅqamuy amumi noiwnik̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Noqw Jesus hiṅqaqwaqat navoti’taqe, ōviy pumuy amumi paṅqawu: Ya uma hinoqw wuhtit unaṅwmokintota? Pam inumi lolmat tumalta. ");
INSERT INTO hopNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Uma pi pay ōokiwyuṅqamuy sutsep oyi’yuṅwa; nīk̇aṅw uma nuy qa sutsep tavi’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pam nuy ásnaniqe ōviy it wihkuyit itokoy aw wūta, nuy tūamiltiniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nu umumi pas antsa paṅqawni: Tūwaqatsit aṅ ahsupoq haqam i’ lomatuawi yuaatiwhq, pep i’ wuhti yep hinhtiqw pam piw yuaatiwni. Sinom it akw put u’ni’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pahsat pu pakwt löq sihk̇ay’taqam put aw nánatuwnayaqamuy amuṅaqw suhka, Judas Iscariot yan mātsiwhqa, God awwat mohpeq momṅwituy amumii, ");
INSERT INTO hopNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nihqe amumi paṅqawu: Ya uma nuy hihta maqayani, nu put umumi mātapq’ö? Noqw puma sunat pakwt sihk̇ay’taqat qötsásivat put maqayaniqey aw pasiwnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Noqw pahpiy pu’ pam put amumi mātapniqey qenihevi’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Noqw qapek̇en’oyvut pölavikit nōviwniqat sūs talöṅni’taqw, Jesus aw nánatuwnayaqam put aw ö́kihqe aw paṅqaqwa: Ya itam haqam aw hintsatsnaqw, um pep ura Amutsva Yūmosanihqat ep nōviwniqat nösniqey nāwakna? ");
INSERT INTO hopNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Noqw pam paṅqawu: Uma kīminen it hakiy tāqat aw paṅqawni: Tūtutuqaynaqa yan lavayhti: Ituwaniy aw pitu. Noqw nu as uhkiy ep amutsva‐yūmosanihqat ep nōviwniqat inumi nánatuwnayaqamuy amumum nösni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Noqw lȫyöm put aw nánatuwnaqam awnihqe, Jesus amumi hin tutaptaqat anhti; nihqe puma ura Amutsva Yūmosanihqat ep hintsatskiwhqat pās aw hintsana. ");
INSERT INTO hopNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Noqw tapkiqw, pam pakwt löq sihk̇ay’taqamuy put aw nánatuwnayaqamuy amumum tunösvoñat aw qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Noqw pumuy nōnovaqw, pam paṅqawu: Nu umumi pas antsa paṅqawni: Uma haqawa nuy momṅwituy amumi mātapni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pahsat puma pas qahahlayhtotiqe, nanāp put aw paṅqaqwa: Tutuyqawhqa, ya nu’ni? ");
INSERT INTO hopNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Noqw pam lavayhtiqe paṅqawu: Inumum tsaqaptat aqw may morstoynaqa hapi nuy momṅwituy amumi mātapni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Pi tutuveni Sinot Tiyat hin lalvayhqat nu pan yep qatsit aṅqw ahpiyni. Noqw pay i’ hak momṅwituy amumi nuy mātapniqat eṅem pas is óhini. Pay pi as tatam pam qa tihtiwhq put eṅem lolmani. ");
INSERT INTO hopNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Noqw i’ Judas put momṅwituy amumi mātapniqa lavayhtiqe paṅqawu: Tūtutuqaynaqa, ya nu’ni? Noqw Jesus put aw paṅqawu: Um súaṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Noqw pumuy nōnovaqw, Jesus pölavikit kwusut, put ep hahlayhtit, yoṅoytat, aw nánatuwnayaqamuy put huytat paṅqawu: Huvam īt ömahtote’ nȫnösaa; i’ hapi itoko. ");
INSERT INTO hopNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pu pam kuyapkuyit kwusut, ep hahlayhtit, pumuy amumi put tavi, nihqe amumi paṅqawu: Uma sohsoyam it aṅqw hikwyani. ");
INSERT INTO hopNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","I’ hapi iuṅwa; pam k̇aysiwhqamuy amuṅem puhuvasiwnit pasiwnaniqe munvaniwa, pu pumuy qaanhtipuyamuy ayo yúkuniqee. ");
INSERT INTO hopNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nīk̇aṅw nu umumi paṅqawni: Pas nu soon yep qatsit ep ovauyit aniwniyat aṅqw hikwni. Nīk̇aṅw qatsit nātoniqat aw pituqw, Inay moṅwtunatyayat ep nu umumum puhuovavalat aṅqw hikwni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Noqw puma tayawinpit tawlalwat, paṅqw nöṅa, Olivet tsomot aqwyaniqee. ");
INSERT INTO hopNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pahsat pu Jesus pumuy amumi paṅqawu: Pu’ tōkilat ep uma sohsoyam inutsviy unaṅwso’ni; pi ura Tutuyqawhqat lavay’ayaat yan put eṅem pēna. Nu kanelmuy tumalay’taqat nīnani; noqw kanēlom ahtsavalni, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nīk̇aṅw ason nu ahoy tātaye’, aṅwu pay umuhsavo Galileet aqwni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Noqw Peter lavayhtiqe, put aw paṅqawu: Pay nāmahin sohsoyam utsviy unaṅwso’q, pas nu’ soon panhtini. ");
INSERT INTO hopNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Noqw Jesus put aw paṅqawu: Nu ūmi pas antsa paṅqawni: Pay pu’ tōkilat ep nāt taqakowāko qa töqtiqw, um nuy qa tuwi’taqey pāyis paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Noqw Peter put aw paṅqawu: Nāmahin pi nu umum mokni nu uṅ qa tuwi’taqey pas soon paṅqawni. Noqw sohsoyam Jesus aw nánatuwnayaqam put an lavayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Noqw pam pumuy tsamk̇aṅw, haqami Gethsemane yan mātsiwhqat aw pitu, nihqe pam pumuy amumi paṅqawu: Uma hāk inuhsavo yep yesq, nu ayohaqaminen Inay aw nāwaknani. ");
INSERT INTO hopNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pu pam Peter‐nit, pu Zebedeet tiyotimuyatuy tsamk̇aṅw, ahpiynihqe, pahsat pu pas qa hahlay’iwmak̇aṅw, pavan putuiwma; ");
INSERT INTO hopNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nihqe pumuy amumi paṅqawu: Pas iunaṅwa qahahlayi, pas mómokqat pan’i. Uma hāk yepye’, inumum tunatyawyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pu pam ahpiy híhin yūmonit, pep tayway aqw tutskwani yēvat, nāwaknaqe paṅqawu: Taay, Inaa, kurs pay hin pasiwtaniqw, pay i’ k̇ānavotpi inuhpiy ayoni. Nīk̇aṅw pay qa nuy hin nāwaknaqw pantani; pay uhtunatya antani. ");
INSERT INTO hopNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pu pam put aw nánatuwnayaqamuy amuminihqe, pumuy tokqamuy tuwa; nihqe Peter aw paṅqawu: Is ohi! Ya pas uma soon tāwat aṅqe’ sūs qöniltiqat pahsavo inumum tunatyawyuṅwni? ");
INSERT INTO hopNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Uma tunatyawk̇ahk̇aṅw nānawaknani, nen qa unaheviwyani. Pay as hakiy tunatyaat pas antsa su’qawtaṅwu; noqw pay tokoat nánahtsovi. ");
INSERT INTO hopNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pu pam paṅqw ahpiynihqe, nāwaknaqe paṅqawu: Kurs i’ k̇ānavotpi pas soon inuhpiy ayoniniqw, nuy put aṅ kuyvaniqat um pan nāwaknaqw, pay nam uhtunatya antani. ");
INSERT INTO hopNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pu pam amumi pituqw, pay piw tōk̇a, pumuy pōsiam putuiwyuṅqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Noqw pam pumuy mātapt, piw ahpiynihqe, pāyisni’mak̇aṅw nāwaknaqe, pay piw án lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pahsat pu pam put aw nánatuwnayaqamuy amuminihqe, amumi paṅqawu: Pay pi uma tōk̇e’, nānasuṅwnani. Pay aw pitu; noqw nu’ Sinot Tiat qaanhinwisqamuy amumi mātaviwni. ");
INSERT INTO hopNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Huvam hoṅvaa; itam áṅwuyani; meh, nuy momṅwituy amumi mātapniqa pitu. ");
INSERT INTO hopNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Noqw nāt pam yuaataqw Judas, imuy pakwt löq sihk̇ay’taqamuy amuṅaqw suhk̇a pitu; noqw sinom qaan’ewakw hintaqam sipwuvahpi’k̇ahk̇aṅw, pu murikhoy’k̇ahk̇aṅw put amum öki, God awwat mohpeq momṅwit‐niqw pu sinmuy amuṅaqw wukw’a’yam pumuy ayatotaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Noqw i’ hak pumuy amumi put mātapqa pumuy amumi paṅqawu: Nu hapi hakiy tsohtsonaqw, pam hápini. Uma put hūrs ṅuayani, kita. ");
INSERT INTO hopNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nit pahsat pay pam Jesus awnihqe aw paṅqawu: Tūtutuqaynaqa, kitat put tsohtsona. ");
INSERT INTO hopNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Noqw Jesus put aw paṅqawu: Ikwatsi, ya um hinoqw aṅqö’? Pahsat pu puma Jesus awyaqe, put hūrs ṅuaya. ");
INSERT INTO hopNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Noqw meh, imuy Jesus ámumyaqamuy amuṅaqw haqawa sipwuvahpi’k̇aṅw, put aw yohtokqe, put hóroknat, God awwat sus mohpeq moṅwit tūwikiyat aw sáviknaqe, naqvuyat ayo tuku. ");
INSERT INTO hopNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Noqw pahsat pu Jesus put aw paṅqawu: Uhsipwuvahpiy tukpuyat aqw pánaa; taq hakim sipwuvahpit akw hintsatsk̇aqam sipwuvahpit akw súlawhtotini. ");
INSERT INTO hopNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nuy pan Inay aw tūviṅtaqw, pam āpiy pay pakwt löq sihk̇ay’tasikip sōmorit amuhpenihqe hóyokiwtaqamuy hoṅviaymuy inumi óyani. Ya um it pēvewna? ");
INSERT INTO hopNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nīk̇aṅw kurs nu panhtiniqw, tutuveni hin aw antsaniwni? ");
INSERT INTO hopNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Noqw pahsat pu Jesus sinmuy amumi paṅqawu: Ya uma hakiy uyiṅwut awyaqe ōviy pas piw sipwuvahpi’k̇ahk̇aṅw, pu murikhoy’k̇ahk̇aṅw nuy ṅuawisa? Ura nu nāqavo God kīyat ep tūtutuqaynaqw, uma nuy qa ṅuaya? ");
INSERT INTO hopNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Noqw Tutuyqawhqat lavay’aymuyatuy pēniam soon qa antaniqw, ōviy sohsoy īi yaniwhti. Pahsat pu put aw nánatuwnayaqam sohsoyam put tatamhtotat watqa. ");
INSERT INTO hopNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Noqw Jesus ṅuayaqam God awwat susmohpeq moṅwit, Caiaphas yan mātsiwhqat, aw put wikya. Noqw tutavot tūtutuqaynayaqam‐niqw pu wukw’a’yam piw pep tsovawta. ");
INSERT INTO hopNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Noqw Peter yāvaqw Jesus aṅk hinma, God awwat susmohpeq moṅwit kīyat aw pahsavoo; nihqe hoṅvia’yatuy amumum ihpovewat qatuptu, hin hintaniqat yórikniqee. ");
INSERT INTO hopNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Noqw ima God awwat mohpeq momṅwit‐niqw, pu wukw’a’yat‐niqw, pu sohsoyam pep tsovawtaqam Jesus nīnayaniqey anyuṅwa; nihqe ōviy as put hihta atsátoynayaniqey hevi’yuṅwa, ");
INSERT INTO hopNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nihqe qa hihta tutwa. Pi as k̇aysiwhqam put hihta atsátoynayaniqe ökik̇aṅw, qa sun lavayhtoti. Noqw nawis’ew hakim lȫyöm put hin atsátoynaniqe pitu; ");
INSERT INTO hopNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nihqe paṅqawu: I’ hapi paṅqawu: Nu God kīyat sahpuknat, pāyis tālat aṅ ahoy put aw yúkuni, kita. ");
INSERT INTO hopNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pu God awwat susmohpeq moṅwi wunuptuqe, put aw paṅqawu: Ya pay um qa hin it ep lavayhtini? Ya ima hihta uhpewi yuaata? ");
INSERT INTO hopNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Noqw pay Jesus qa hiṅqawu. Noqw God awwat susmohpeq moṅwi lavayhtiqe, put aw paṅqawu: Nu hapi ūmi pas paṅqawni: Um pas God Qátuhqat atpip itamumi súaṅqawni: Ya uma pas antsa Christ God Tíata, i’ moṅw’asi’taqa? ");
INSERT INTO hopNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Noqw Jesus put aw paṅqawu: Pay um súaṅqawu. Noqw nu ūmi paṅqawni: Yahpiy pu’ nu Sinot Tiat Sus’öqaltutuyqawhqat putvaqewat qatuptuni, pu tokpelat aṅ ōomawhtuy akw nu hawhtoqw uma inumi yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pahsat pu God awwat susmohpeq moṅwi itsivutiqe, yuwsiy tsīk̇at paṅqawu: Pam Hakiy pas k̇aptsitiwhqat aqw qalomáhiṅqawuy! Ya hinoqw pas piw nāt hak hin yuaatani? Meh, uma qalomálvayhtiqw aw tūqayyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Uma hin wūwaya? Noqw puma lavayhtotiqe paṅqaqwa: Pam mokiwuy hihk̇ay’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pahsat pu puma put taywami töhtota, pu may pölölni’k̇ahk̇aṅw wuvalalwa; noqw pētu mapqölöy akw put wuvalalwak̇aṅw, ");
INSERT INTO hopNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Aw paṅqaqwa: Taay, um Christ, um itamuy āawnani, Ya hak uṅ wuvahta? ");
INSERT INTO hopNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Noqw Peter moṅwkit ihpaq tukwṅöyakiwtaqat ep qatu; noqw hak māna tumal’aya put aw pítuhqe, aw paṅqawu: Um pi piw Jesus Galilee aṅqwnihqat ámuma. ");
INSERT INTO hopNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Noqw pam sohsokmuy amutpik qa nakwhaqe paṅqawu: Kurs um hiṅqawlawu. ");
INSERT INTO hopNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pu pam tuhööt aw yamakq, piw suhk̇a māna put túwahqe, pep yesqamuy amumi paṅqawu: I’ pi piw Jesus Nazareth aṅqwnihqat ámuma. ");
INSERT INTO hopNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Noqw piw pay pam qa nakwhaqe, pas öqalat lavayit akw paṅqawu: Pay nu pas put tāqat qa tuwi’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pu ahpiy hihsavoniqw, put aqlaq hoṅqam Peter awyaqe aw paṅqaqwa: Pay pi um pas suyan piw pumuy amumuma, ōviy pi uhlavayiy uṅ suhputsni’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pahsat pu Peter pas öqalat lavayhtiqe paṅqawu: Pay nu pas put tāqat qa tuwi’ta, kita. Noqw pahsat pay taqakowāko töqti. ");
INSERT INTO hopNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Noqw Peter Jesus lavayiyat u’na; ura pam put aw paṅqawu: Nāt taqakowāko qa töqtiqw, um pāyis nuy qa tuwi’taqey paṅqawni. Nihqe pam paṅqw yámakqe, nāp hin nāvak’öyna. ");
INSERT INTO hopNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Noqw qavoṅvaqw, sohsoyam God awwat mohpeq momṅwit, sinmuy amuṅaqw wukw’aymuyatuy amumum Jesus ankiwakw yuaatota, put nīnayaniqee. ");
INSERT INTO hopNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Noqw puma put somyaqe, pahpiy wikyaqe, pep tutskwat aw moṅwit, Pontius Pilate yan mātsiwhqat, aw put noaya. ");
INSERT INTO hopNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pahsat pu Judas, momṅwituy amumi put mātapqa, Jesus tūviwhq pan yórikqe pi ason qahahlayhtiqe, God awwat mohpeq momṅwituy amumi‐nik̇aṅw pu wukw’a’yamuy amuminihqe, sunat pakwt sihk̇ay’taqat qötsásivat ahoy kívaqe, ");
INSERT INTO hopNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Amumi paṅqawu: Pas kurs nu hakiy qa hihta ep hinhtiqat umumi mātapqe qaanhti. Noqw puma paṅqaqwa: Noqw hinhtini? Pam pi pay uhpee. ");
INSERT INTO hopNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Noqw pam God kīyat ep qötsásivat tsálaknat, ahpiynihqe, haqam nāhaya. ");
INSERT INTO hopNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Noqw God awwat mohpeq momṅwit qötsásivat aṅ pohpoñaqe paṅqaqwa: Itam sivatataṅpimiq put taṅatote’, qa súanhtotini, taq ura itam hakiy qatsíyat put akw tuiya. ");
INSERT INTO hopNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nihqe puma put yuaaykuyaqe, haqe’ tutskwat Tsaqavotlawhqat Tutskwaat yan túṅwantiwhqat sīvat akw tuiya, pep hakimuy qa pep sinmuy ōoyyaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Noqw ōviy pam tutskwa Uṅwat akw Tuiwhpu nāto yan túṅwantiwa. ");
INSERT INTO hopNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Noqw yan hapi Tutuyqawhqat lavay’ayayat Jeremyt lavayiyat aw anhti; ura pam paṅqawu: Pu puma sīvat ömahtota, it pakwt sunat sihk̇ay’taqat qötsásivat hakiy qatsíyat ep sisviyaqeyu. Pan hapi ima Israel‐sinom put qatsíyat hihkatoynaya. ");
INSERT INTO hopNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nihqe put akw hakiy tsaqavotlawhqat tutskwayat tuiya, Tutuyqawhqa inumi hin tutaptaqat pan’i. Yan ura pey’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Noqw Jesus pep tutskwat aw moṅwit atpip wunuwta. Noqw moṅwi put tūviṅtaqe aw paṅqawu: Ya um Jew‐sinmuy moṅwiamu? Noqw Jesus put aw paṅqawu: Um súaṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Noqw God awwat mohpeq momṅwit‐niqw pu wukw’a’yam put hin nēveltoynayaqw, pam qa hiṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pahsat pu Pilate put aw paṅqawu: Ya ima hihsa’ hihta uṅ tsotsk̇anayaqw, um qa navota? ");
INSERT INTO hopNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Noqw pay pas pam qa hiṅqawu. Noqw ōviy moṅwi put ep pas hin kurs wūwa. ");
INSERT INTO hopNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Noqw put nōviwhqat aw pituqw moṅwi sinmuy amumi hakiy sivilawhqat mātapṅwu, hakiy nānawaknaqw put’a. ");
INSERT INTO hopNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Noqw piw ép puma hakiy pas qahopímataknihqat sivivani’yuṅwa, hakiy Barabbas yan mātsiwhqata. ");
INSERT INTO hopNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Noqw ōviy puma sumitsovaltiqw, Pilate pumuy amumi paṅqawu: Ya nu hakiy umumi mātapniqat uma nānawakna‐sen Barabbas, sen it Jesus, Christ yan túṅwantiwhqata? ");
INSERT INTO hopNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Suyan pi puma qatsutsúyhqe ōviy put aw Jesus noayaqw, pam mātsi’taqe ōviy paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Noqw pam Jesus eṅem hin yúkuniqey wūwank̇aṅw, moṅw’atsveway ep qatuqw, put nȫmaat put aw hakiy ayataqe paṅqawu: Um put tāqat súantaqat qa aw hintsakni; taq nu tōki tūmoklawhqe, put atsviy hīhihta k̇ānavota. ");
INSERT INTO hopNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Noqw God awwat mohpeq momṅwit wukw’a’yamuy amumum sinmuy pan unaṅwtoynayaqw, puma Barabbas tuhtui’ya, pu Jesus nīnayaniqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Noqw moṅwi lavayhtiqe, pumuy amumi paṅqawu: Noqw nu hihtawat imuy lȫqmuy amuṅaqw umumi mātapniqat uma nānawakna? Noqw puma paṅqaqwa: Barabbas awúy! ");
INSERT INTO hopNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Noqw Pilate amumi paṅqawu: Noqw nu panhte’, Jesus Christ yan túṅwantiwhqat hintsanni? Noqw puma sohsoyam sáakmaqe, aw paṅqaqwa: Nahoylehtsit aw múaa! ");
INSERT INTO hopNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Noqw moṅwi paṅqawu: Ya hínoq’ö? Ya hihta qalomáhinhtiqw ōviy’o? Pahsat pu puma pas sáakmaqe paṅqaqwa: Nahoylehtsit aw múaa! ");
INSERT INTO hopNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Noqw pay Pilate pumuy kurs hintsanniqw, nuṅwu pay sinom pas qa unaṅwtalawvayaqw, pahsat pu pam kuyht, sinmuy amutpik mävaqtat, paṅqawu: Nu hapi it tāqat qa hintaqat qatsíyat ep qa tukopniwtani. Uma pi put hin yukuyani. ");
INSERT INTO hopNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Noqw pahsat pu sinom sohsoyam lavayhtotiqe paṅqaqwa: Pay pi ason itam put qatsíyat ep tukopniwyani, pu itahtimu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Noqw ōviy pam pumuy amumi Barabbas mātavi. Nīk̇aṅw pam solāwat aw Jesus mātapq, pam put qa sūs wuvahta. Noqw pahsat pu Pilate put nahoylehtsit aw muiltiniqat ōviy pumuy amumi put mātavi. ");
INSERT INTO hopNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pahsat pu moṅwit solāwamat pavasiwhkimi Jesus wikyaqe, sohsokmuy suṅwámuy put aw tsovalaya. ");
INSERT INTO hopNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nihqe puma put yuwsiyat nawhkiyat, palausimnit put usihtoynaya. ");
INSERT INTO hopNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pu puma hihta kūtay’taqat ṅölatotaqe, put qötösomtoynaya; nit pu putvaqw hopaqat matsvoṅtoynayat, put aw tamötshoṅvank̇aṅw, tututsiwyaqe, put aw paṅqaqwa: Öqawmaṅwu Jew‐sinmuy moṅwíamu! ");
INSERT INTO hopNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pu puma put aw töhtota, pu hopaqat kwusuyaqe, put akw put qötöyat wuvalalwa. ");
INSERT INTO hopNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yan puma put aw tututsiwyat, put usimnit nawhkiyat, nāp yuwsiyat put yuwsinayat, put nahoylehtsit aw muayaniqe ōviy ahpiy wikya. ");
INSERT INTO hopNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Noqw puma kīṅaqw nöṅakwisk̇ahk̇aṅw, hakiy Cyrene aṅqw tāqat Simon yan mātsiwhqat tutwa; noqw pam Jesus nahoylehtsiyat īkwiwtaniqat puma put tusoq’ayatota. ");
INSERT INTO hopNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pu puma haqami Golgotha yan túṅwantiwhqat aw öki. Pam Masqötvihk̇a i’nihqe pam’i. ");
INSERT INTO hopNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Noqw puma pep ökiqw, solāwam wine hihta a’nö tsīvot enaṅ namiqwriwtaqat put hikwnayaniqw, pam put aṅqw yúkuhqe, hikwniqey qa nakwha. ");
INSERT INTO hopNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pep puma put nahoylehtsit aw muaya; pu puma yuwsiyat ōviy nanavö’ya. Yan Tutuyqawhqat lavay’ayaat hin lavayhtiqat aw antsaniwa; ura pam paṅqawu: Puma iyuwsiy nāhuyva, pu iusimniy ōviy nanavö’ya. ");
INSERT INTO hopNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pahsat puma pep yesvaqe put tūtuwala. ");
INSERT INTO hopNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nihqe put hin nēveltoyniwhqat pey’taqat put qötöyat atsve tsok̇aya. Noqw yan hapi pey’ta: I’ HAPI JESUS, JEW‐SINMUY MOṄWIAMU. ");
INSERT INTO hopNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Noqw puma piw lȫqmuy uyiṅwutuy put ahsaq nīnaya, nānap nahoylehtsit aw muayaqee. Suhk̇a putvaqeniqw, pu suhk̇a suyvaqee. ");
INSERT INTO hopNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Noqw aṅ sasqayaqam put aw tututsiwya, qötöy wīlank̇ahk̇aṅwo; ");
INSERT INTO hopNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nihqe paṅqaqwa: Taay, um God kīyat sahpuknat, pāyis tālat aṅ ahoy aw kītaniqa, ayo nātavii! Pas pi um antsa God Tíatnen nahoylehtsit aṅqw hawni. ");
INSERT INTO hopNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Noqw amún God awwat mohpeq momṅwit‐niqw, pu tutavot tūtutuqaynayaqam‐niqw, pu wukw’a’yam put aw tututsiwyaqe paṅqaqwa: ");
INSERT INTO hopNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Pas as pam pētuy ayo oyat, kurs hin ayo nātapni. Pas pi antsa pam Israel‐sinmuy moṅwíamnen, nahoylehtsit aṅqw hawhq, itam aw tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kurs pi pam God aw yanta; pay pi God putnik, put ayo távini; himu pi paṅqawu: Nu God Tíata. ");
INSERT INTO hopNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Noqw ima uyiṅwut put amum nahoylehtsit aw muiltiqam pay piw amún put aw hiṅqawlawu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Noqw tāwanasaptiqw, aṅ ahsupoq qatālawva, tāwat atvelpetiqw aw pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pu tāwat atvelpetiqw, Jesus pas tönay aṅqe’ a’nö paṅqawu: Eli, Eli, lama sabachthani! Pam God, Itutuyqawhqa, ya um hinoqw nuy tatamhta? i’nihqe pam’i. ");
INSERT INTO hopNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Noqw haqawat pep hoṅqam put nanaptaqe paṅqaqwa: Taq pam Elias wáṅwaylawu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Noqw pahsat pay pumuy amuṅaqw haqawa wárikqe, hihta söyatkoy’taqat (sponge) vinegar akw tsehkweknat, hopaqat epeq söṅnat, put hikwniniqw maqa. ");
INSERT INTO hopNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Noqw pay haqawat paṅqaqwa: Pay pantani; mātaqpi kurs Elias put ayo távinik pítuni. ");
INSERT INTO hopNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pu Jesus piw a’nö hiṅqawht, sohsok hikwsu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Noqw meh, God kīyat ep mötsáp’uhtsi ōṅaqw atk̇amiq tsīki, noqw tutskwa tayayayku, pu o’wa kwanamhti. ");
INSERT INTO hopNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pu tūtuami hötsiltotiqw, k̇aysiwhqam God sinomat so’qam ahoy yesvaqe, tūamit aṅqw nöṅa. ");
INSERT INTO hopNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nihqe Jesus ahoy tātayhq, put atsve puma pas āantsawat kitsókit aw yuṅqw, sinom k̇aysiwhqam amumi yórikya. ");
INSERT INTO hopNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Noqw solāwamoṅwi‐niqw pu ima put amum Jesus tūtuwalaqam tutskwat tayayaykuqw, pu hin hiniwhtiqat aw yórikyaqe, pavan pas tsātsawnaqe, paṅqaqwa: Pas antsa kurs as i’ God Tíata. ");
INSERT INTO hopNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Noqw k̇aysiwhqam momoyam pep yāvaqw aw tāyuṅwa. Puma Galileet aṅqw Jesus aṅk hinnumyaqe, eṅem hihta hintsatsk̇a. ");
INSERT INTO hopNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Noqw pumuy amuṅaqw Mary Magdalene, pu Mary, James‐nik̇aṅw pu Joses pumuy yúamu, piw Zebedeet timuyatuy yuámu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Noqw Jesus aw tuptsiwni’yuṅqamuy amuṅaqw haqawa Joseph yan mātsiwa. Pam Arimathaea‐kitsókit aṅq’ö, nihqe a’nö hihta himuy’ta. ");
INSERT INTO hopNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Noqw tapkiwtaqw, pam Pilate aw pítuhqe Jesus tokoyat tuhtui. Noqw put tokoat put aw noiwniqat Pilate paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Noqw tokoyat Joseph yawmaqe, kwaṅw’ewakw tusaqtontsatsakwmötsaput akw put mok̇ahta; ");
INSERT INTO hopNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nit pu pam haqam owat ep puhutuamhqölöt himuy’taqey ep put tavi, nit tūamit hötsíwmiq wuko’wat hóyoknat, ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Noqw Mary Magdalene‐niqw, pu suhk̇awa Mary tūamit ehpewi qatu. ");
INSERT INTO hopNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Noqw totok̇at qavoṅvaqw, God awwat mohpeq momṅwit‐niqw, pu Pharisee‐sinom Pilate aw ökihqe, aw paṅqaqwa: ");
INSERT INTO hopNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Moṅwi, itam u’nayaqw, ura i’ nuhtumi hīhihta átsalawhqa nāto qátuhqe paṅqawu: Nu ahpiy pāyis talq ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Taay, noqw ōviy um paṅqawhq, tūamit pāyis tālat aw pahsavo qaöwíhintani; taq k̇a put aw nánatuwnayaqam mihikq ök̇e’, put tokoyat haqami ūuyi’wist, nuhtumi paṅqaqwani: Pam mokiwuy aṅqw ahoy tātayi, kitotani. Noqw pantaniqw, tis pas mohtiwat epnihqe qalomáhintani. ");
INSERT INTO hopNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Noqw Pilate pumuy amumi paṅqawu: Uma pi tuwalan’aymuy’yuṅwa; uma ahpiyye’, aw qaöwíyukuyani. ");
INSERT INTO hopNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Noqw ōviy puma ahpiyyaqe, tūamit qaöwihintsatsnayaqe, tuvoylat akw owat uhtayat, ep hakimuy tuwalan’o’ya. ");
INSERT INTO hopNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Noqw nasuṅwintalöṅnit aṅ ruhpakq, Sundayt aw pituqw, nāt qöyaṅwnuptsiwtaqwhaqam Mary Magdalene, sukwat Maryt amum tūamit aw kuyvato. ");
INSERT INTO hopNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Noqw meh, pas tutskwa a’nö tayayayku; pi Tutuyqawhqat hoṅviayaat ōṅaqw hawhqe, hötsíwat aṅqw owat ayo mūmat, atsveq qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Noqw pas taywaat talwihpikit anta; pu pas yuwsiat nūvat an qȫtsa. ");
INSERT INTO hopNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Noqw tūtuwalaqam put mamqasyaqe, pavan tururuykuyaqe, pas so’qey panhtoti. ");
INSERT INTO hopNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Noqw hoṅviaya lavayhtiqe, wuhtituy amumi paṅqawu: Uma qa tsawiniwtani. Pay nu navoti’taqw, uma Jesus ura nahoylehtsit aw muiltiqat hepnuma. ");
INSERT INTO hopNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pam qa yep’e; pi pam ahoy tātayi, ura pan lavayhti. Kurs huvam pewnen, Tutuyqawhqat as haqe’ qatsqat uma aw yórikni. ");
INSERT INTO hopNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nen uma yaṅqw k̇aktaye’, pam mokiwuy aṅqw ahoy tātayhqat put aw nánatuwnayaqamuy āawnani; Noqw meh, pay pam hapi aṅwu umupyeve Galileet aqwni. Ason pepeq uma aw tātayyani. Meh, nu hapi umuy āawna, kita. ");
INSERT INTO hopNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Noqw puma tsawiniwk̇aṅw, piw pas hahlayk̇aṅw, tūamit aṅqw ahpiy k̇aktayhqe, put aw nánatuwnayaqamuy amumi tūawmaqe wari. ");
INSERT INTO hopNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Noqw puma paṅsoniqw pi meh, Jesus pas nāp pumuy amuhsawvaqe paṅqawu: Hakim hahlayṅwu. Noqw puma put awnihqe, hok̇ayat mavoqtat, aw naokiwhta. ");
INSERT INTO hopNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pahsat pu Jesus amumi paṅqawu: Uma qa tsawiniwtani. Uma yahpiynen, itupkomuy amumi paṅqawhq, puma Galileet aqwyani; nen ason pepeq inumi yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Noqw puma nāto paṅsoniqw, meh, haqawat tūtuwalaqam kīve ökihqe, hin hiniwhtiqat God awwat mohpeq momṅwituy sohsok āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Noqw puma wukw’a’yatuy amumum tsovaltiqe, hinhtotiniqey yuaatota; nihqe nihtiwtaqat sīvat solāwamuy huytota, ");
INSERT INTO hopNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Paṅqawk̇ahk̇aṅwo: Uma hapi kitotani: Itamuy tokq, put aw nánatuwnayaqam mihikq ökihqe, put tokoyat haqami ūuyi’wisa. ");
INSERT INTO hopNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Noqw ason kurs tutskwat aw moṅwi it navotq, itam aw tūtuyqawve’, umuṅem qeni’totani. ");
INSERT INTO hopNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Noqw ōviy puma sīvat ömahtotaqe, amumi hin tutaptotaqat anhtoti. Noqw i’ yan lavayi nāt Jew‐sinmuy amuhpa’ yuaatiwa pewhaqami pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pahsat pu pakwt sūkw sihk̇ay’taqam Jesus aw nánatuwnayaqam Galileet aqwya, haqam tsomot Jesus pumuy amumi tutaptaqat paṅsoq’a. ");
INSERT INTO hopNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","18","Noqw Jesus pumuy amumi pituqw, puma put aw yórikyaqe pas hihtatota. Noqw pay haqawat soq pēvewinhtoti. Noqw pam amumi paṅqawu: Ina sohosk hihta ōveqatsit ep‐nik̇aṅw pu tūwaqatsit epnihqat aw nuy moṅwtavi. ");
INSERT INTO hopNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Noqw ōviy uma aṅqe’ nankwuse’, sopk̇awtaqamuy sinmuy tutuqaynayani, pu kūyit akw pumuy tuvoylatiwisni, Inay, pu Tiyat, pu Qahováriwtaqat Hikwsit, pumuy natṅwaniyamuy aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nen puma itutavoy aṅ ahsupoq aṅ hinwisniqat uma pumuy tutuqaynayani. Noqw nu’ hapi yūmosa umumum hinmani, yep qatsíso’ṅwamiqhaqamii. Okiw antani.");
INSERT INTO hopNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","I’ lomatuawi Jesus Christ God Tiyat yuaataqa yan yayhniwa. ");
INSERT INTO hopNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God lavay’aymuyatuy pēniyamuy aṅ yan ura pey’ta: Meh, nu hapi upyeve ituaw’ayay ayatani; noqw pam hapi upyeve uṅem pöhut aṅ qenitani. ");
INSERT INTO hopNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hakiy tönaat qayēsiwhpuve tsa’tinumqa navotniwa; nihqe yan lalvaya: Uma Tutuyqawhqat eṅem pöhut aw hintsatsnani, pam háqe’niqat aw suwiptotani. ");
INSERT INTO hopNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Hak tāqa John yan mātsiwhqa qayēsiwhpuve kūyit akw tūtuvoylalawu; nihqe sinmuy amumi paṅqawu: Uma nāp umuhtunatyay aṅqw lasye’, kūyit akw tuvoylatotini. Noqw God umuhqaanhtipuy umuhpiy ayo yúkuni. ");
INSERT INTO hopNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Noqw tutskwat Judeat aṅ ahsupoq sinom sohsoyam put aw ökiwta, pu Jerusalem aṅq’ö; nihqe qaanhtipuy nahostotat, John ahpiy pāyut Jordan aqw tuvoylatoti. ");
INSERT INTO hopNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Noqw i’ John hihta pohkot pȫlay’taqat pöhöyat aṅqw yukiwtaqat yuwsi’k̇aṅw, kolāsat kwewta. Noqw pam mātuy tūmoyta; pu piw haqam mómohtuy tsāme’, momospalayamuy enaṅ tūmoytaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nihqe pam yuaataqe paṅqawlawu: Hak inuhpenihqe pas pavan öqalay’taqa inuṅkni; noqw soon nu yan’ewaynīk̇aṅw pay ṅas’ew put tots‐sosompiyat ṅahnik aw motoltini. ");
INSERT INTO hopNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Pay nu pas antsa kūyit akw umuy tuvoylalawu. Nīk̇aṅw ason pam Qahováriwtaqat Hikwsit akw umuy tuvoylalawni. ");
INSERT INTO hopNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Noqw ephaqam Jesus Galilee‐tutskwat ep kitsókit Nazareth aṅqwniqw, John pāyut Jordan aqw put tuvoylata. ");
INSERT INTO hopNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Noqw Jesus pāṅaqw yámakq, pahsat pay tokpela hötsiltiqw Qahováriwtaqa Hikwsi höwit ank̇aṅw put aqw hawhtoqat pam aw yori. ");
INSERT INTO hopNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Noqw hakiy tönaat ōṅaqw paṅqawu: Um hapi pas aw iunaṅwa Itii, pas nu uṅ hahlayi. ");
INSERT INTO hopNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Noqw pahsat pay Qahováriwtaqa Hikwsi qayēsiwhpumi haqami put lālayi. ");
INSERT INTO hopNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Noqw pam pep qayēsiwhpuve lȫp sunat tālat aṅ tūtuvosiptuy amumum yanta. Noqw Satan put unaheplawu; noqw ōṅaqw hoṅvia’yat put aw unaṅwtavi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Noqw John sivikive pakiwtaqw, Jesus Galilee‐tutskwat ep pituhqe, lomatuawit God moṅwtunatyayat yuaataqat yuaatinuma, ");
INSERT INTO hopNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Paṅqawk̇aṅwo: Pay hapi aw pitu, God moṅwtunatyayat aw hayhk̇alti. Uma nāp umuhtunatyay aṅqw lasye’, lomatuawit aw tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Noqw pam wuhkovatuphat Galilee yan mātsiwhqat qalavaqe hinmak̇aṅw, hakiy Simon tupkoyat Andrewt enaṅ tuwa. Puma pakiwmaqtutsayay pāmiq pahpana, puma pakiwmahk̇atnihqey akw qátuhqee. ");
INSERT INTO hopNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Noqw Jesus pumuy amumi paṅqawu: Uma inuṅk hinmani; noqw nu umuy tutuwnaqw, uma sinmuy kwihkwisnani, uma pāvakiwhtuy hin kwihkwisnaqey pan’i. ");
INSERT INTO hopNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Noqw pahsat pay puma tutsáyay tatamhtat, put aṅki. ");
INSERT INTO hopNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Noqw pam pahpiy hihsavo nakwsuqe, hakiy Zebedeet tímuyatuy James pu John pumuy tuwa. Puma tuwat pākihut aṅqw pakiwk̇aṅw, tutsáyay aw yuyku. ");
INSERT INTO hopNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Noqw pam āpiy pay pumuy wáṅwayi. Noqw puma nay Zebedeet tumal’aymuy enaṅ pākihut ep mātapt, put aṅk nakwsu. ");
INSERT INTO hopNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Noqw puma Capernaum‐kitsókit ep öki. Noqw nasuṅwintalöṅnit aw pituqw, āpiy pay pam tsotsvalkimi pákihqe, sinmuy tutuqaynativa. ");
INSERT INTO hopNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Noqw puma put hin tutuqaynaqat ep pas aw k̇ātayyuṅwa, pas pam öqalat pasiwtaqey pan pumuy tutuqaynaqw öviy’o, imuy tutavot tutuqaynayaqamuy qa pumuy amun’i. ");
INSERT INTO hopNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Noqw hak tāqa tuyoy’ewakw hikwsit akw tuyqawiwtaqa pumuy tsotsvalkiyamuy ep nuhtuma. Nihqe pam tsa’lawhqe, ");
INSERT INTO hopNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Paṅqawu: Um itamumi qa hintsakni. Ya um itamuy hinhtotiniqat nāwakna, um Nazareth aṅqw Jesus? Ya um itamuy hovalaniqe ōviy aṅqaqö’? Pay um hákiyniqw nu uṅ tuwi’ta. Um hapi God aṅqw pas Qahováriwtaqa. ");
INSERT INTO hopNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Noqw Jesus hikwsit mēwaqe, aw paṅqawu: Qa hiṅqawlawht, aṅqw yámakuu. ");
INSERT INTO hopNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Noqw tuyoy’eway hikwsi tāqat homimikinat, a’nö töqtit, aṅqw yama. ");
INSERT INTO hopNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Noqw sinom sohsoyam k̇ātayuṅqe, nātuviṅlalwaqe paṅqaqwa: Hin pa i’ hintani? sen pay puhututuqayhpi? Pas pi pam öqalat pasiwk̇aṅw, ōviy hikis pi pas tuyoy’e’wakw hīhikwsimuy mēwaqw, puma put aw tuqayvastotaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Noqw pas pay pahsat Jesus pep hintsakq, Galilee‐tutskwat aṅ ahsupoq pay pan yuaatiwa. ");
INSERT INTO hopNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Noqw panis puma tsotsvalkiṅaqw nöṅakt, hakiy Simon‐nit, pu Andrew, pumuy kīyamuy aw yuña, ima James pu John pumuy amumumniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Noqw Simon nȫmayat yuat mukituyat akw qātsi. Noqw āpiy pay puma put Jesus āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Noqw pam put awnihqe, māyat ṅuat, qatuptsinaqw, pahsat pay mukituyat put mātavi. Noqw wuhti pumuy amumi unaṅwtavi. ");
INSERT INTO hopNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Noqw tāwat pakiqw, sinom Jesus aw sohsokmuy hihta akw tūtuyyaqamuy tsamvaya, pu nukpanhihikwsimuy akw tuyqawiwyuṅqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Noqw pep kitsókit ep sinom sohsoyam hötsiwmiq tsovalti. ");
INSERT INTO hopNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Noqw pam k̇aysiwhqamuy hīhihta akw tūtuyyaqamuy qalaptsinta, piw k̇aysiwhqamuy nukpanhihikwsimuy nuhtuṅaqw ayo ipwaqe, pumuy hiṅqaqwaniqw qa nakwhana, puma put hákiyniqw tuwi’yuṅqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pu qavoṅvaqw, nāt qa hin tālawvaniqw, Jesus qatuptuqe, kīṅaqw yama; nihqe haqami súnalkominihqe, pephaqam God aw okiwlawu. ");
INSERT INTO hopNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Noqw Simon pu put suṅwámat puma put aṅkya. ");
INSERT INTO hopNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Noqw puma put tutwaqe, aw paṅqaqwa: Sinom sohsoyam uṅ hepnumya. ");
INSERT INTO hopNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Noqw pam pumuy amumi paṅqawu: Tuma yuhk̇e’ kitsókinawit nankwusa; noqw nu paṅ piw yuaatinumni; pi nu paniqw aṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pu pam Galilee‐tutskwat aṅ ahsupoq sinmuy tsotsvalkiyamuy aṅ yuaatinumqe, nukpanhihikwsimuy nuhtuṅaqw ipwannuma. ");
INSERT INTO hopNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Noqw hak hihta tokoplelet akw tūtuyhqa put aw pituhqe, okiw aw tamötswunuptut paṅqawu: Um suhtaq’ewnen soon nuy qa powatani. ");
INSERT INTO hopNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Noqw Jesus put ōkwatuwhqe, aw māvuyaltiqe, aw toṅokt paṅqawu: Pay nu suhtaq’ewa; powaltii. ");
INSERT INTO hopNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Noqw panis pam paṅqawhq, pahsat pay tokoplele put aṅ súlawhti; noqw pam powalti. ");
INSERT INTO hopNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Noqw Jesus put pās mēwat, pahsat pay nahpiy put hōnaqe, ");
INSERT INTO hopNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Aw paṅqawu: Um tunatyalte’, qa hakiy it āawnani; nīk̇aṅw um ahpiynen, God awwat moṅwit aw namtaknani; nen Moses hin tutaptaqat um pan powaltiqey ep kuwahtiput távini. Um yan powaltiqey tuawi’tani. ");
INSERT INTO hopNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Noqw tuwat soq pam paṅqw ahpiynihqe, aṅqe’ put a’nö yuaatinumqe, ahsupoq tunvotna. Noqw ōviy Jesus kurs hin pāpu kitsókimi mātaqpuva pákiniqe, pay qalavehaqam tutskwava hinnuma; noqw sohsokivaqw sinom put aw ökiwta. ");
INSERT INTO hopNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Noqw ahpiy hihsakis talq, Jesus piw Capernaum‐kitsókit aw paki. Noqw yaw pam kīve pakiwtaqat sinom paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Noqw pahsat pay sinom k̇aysiwhqam paṅso tsovalti, pas k̇aysiwhqe ōviy kurs haqe’ yesni, pas qa ṅas’ew hötsiwhpeq qeni, pas qae. Noqw pam pumuy amumi God lavayiyat yuaata. ");
INSERT INTO hopNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Noqw hakim nālöyöm hakiy tāqat ahpa’ qataytaqat tūtuyhqat tsöpk̇ahk̇aṅw put aw öki. ");
INSERT INTO hopNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Noqw ep huru’pokiwtaqw, ōviy kurs hin puma put aw ökini. Nihqe pahsat puma put háqamnihqat atsve kīamit yāhayaqe, póroknayat, it hakiy tūtuyhqat ahpat aṅ wáökiwtaqat paṅ put aw hawnaya. ");
INSERT INTO hopNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Noqw Jesus pumuy qapēvewnayaqat amumi túwahqe, it tāqat aṅ qataytaqat aw paṅqawu: Itii, pay uhqaanhtipu uhpiy ayo yukiwa. ");
INSERT INTO hopNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Noqw haqawat tutavot tutuqaynayaqam pep yēse; nihqe pan unaṅwpeq wūwaya: ");
INSERT INTO hopNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ya hinoqw i’ God aqw hiṅqawlawu? Ya hak sen hakiy qaanhtipuyat ayo yúkuni, hal pas God‐saa? ");
INSERT INTO hopNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Noqw kurs puma unaṅwpeq pan wūwantotaqw, Jesus panis unaṅwpeq māmatst, amumi paṅqawu: Ya uma hinoqw umuh’unaṅwpeq pavan wūwantota? ");
INSERT INTO hopNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ya hak hakiy aṅ qataytaqat tūtuyhqat aw hinwat lavayhtiniqw qa pas pas hinta, Sen Uhqaanhtipu uhpiy ayo yukiwa, kitaniqö’? sen Wunuptut, uh’ahpay kwusut, nakwsuu, sen kitaniqö’? ");
INSERT INTO hopNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Noqw pay pi nu’ Sinot Tiat yep qatsit ep hakiy ahpiy qaanhtipuyat ayo yúkuniqey aw öqalat pasiwtaqat uma it akw nanaptani‐pu pam it tāqat aṅ qataytaqat aw paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Oviy nu ūmi paṅqawni: Qatuptut, uh’ahpay kwusut, uhkiy aw’i. ");
INSERT INTO hopNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Noqw pahsat pay pam wunuptut, ahpay kwusut, pumuy sohsokmuy amutpik nakwsu. Noqw ōviy puma sohsoyam k̇ātayuṅqe, God pas hihtatota, paṅqawk̇ahk̇aṅwo: Pas itam qa hisat hihta yanhaqamnihqat aw yórikya. ");
INSERT INTO hopNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pu pam paṅqw piw wuhkovatuphat qalávohaqamii. Noqw sinom sohsoyam put aw tsovalti; noqw pam pumuy tutuqayna. ");
INSERT INTO hopNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Noqw pam paṅmak̇aṅw, hakiy Alphaeus tiyat Levi moṅwit eṅem sīvat ömalawk̇aṅw haqam qatuhqat túwahqe, aw paṅqawu: Um inuṅkni. Noqw pam wunuptut, put aṅki. ");
INSERT INTO hopNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Noqw Jesus put aw nánatuwnayaqamuy amumum put kīyat ep ökihqe, pep tunösvoñat aw yesq, k̇aysiwhqam moṅwit eṅem sīvat ömalalwaqam‐niqw pu qaanhinwisqam paṅso ökihqe, pumuy amumum put aw yesva; pi put aṅk hinwisqam pas k̇aysiwhqee. ");
INSERT INTO hopNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Noqw pam moṅwit eṅem sīvat ömalalwaqamuy‐nik̇aṅw pu qaanhinwisqamuy amumum tūmoytaqw, ima tutavot tutuqaynayaqam Pharisee‐sinmuy amumum put aw tātayyaqe, put aw nánatuwnayaqamuy amumi paṅqaqwa: Ya pam hinoqw moṅwit eṅem sīvat ömalalwaqamuy‐nik̇aṅw pu qaanhinwisqamuy amumum tūmoyta, piw hīhiko? kitota. ");
INSERT INTO hopNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Noqw Jesus put navotqe, pumuy amumi paṅqawu: Pay aṅ qahinyuṅqam tūhik̇at qa haqni’yuṅwa; nawus pi tūtuyyaqam put haqni’yuṅwa. Pi nu aṅ súanhinwisqamuy qa pumuy wáṅwayniqe ōviy pitu; pi nu imuy qaanhinwisqamuy nāp tunatyay aṅqw lasyaniqat aw wáṅwayniqe ōviy pitu. ");
INSERT INTO hopNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Noqw ima pi John aw nánatuwnayaqam‐nik̇aṅw pu Pharisee‐sinmuy amumi nánatuwnayaqam napwalni’yuṅwa. Noqw ōviy sinom Jesus aw ökihqe aw paṅqaqwa: Meh, John aw nánatuwnayaqam‐nik̇aṅw pu Pharisee‐sinmuy amumi nánatuwnayaqam napwalni’yuṅwa. Noqw ya hinoqw ūmi nánatuwnayaqam qa pantsatsk̇a? ");
INSERT INTO hopNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Noqw Jesus pumuy amumi paṅqawu: Ya sen haqam mö’wit sinomat nāt möönaṅwuy amumum yantaqw, napwalni’yuṅwni? Soon pi möönaṅw pumuy amumum yantaqw puma napwalni’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nīk̇aṅw pay ason hisat aw pituqw, möönaṅw’am pumuy amuṅaqw ahpiyniqw, pep pu’ puma nānapwalni. ");
INSERT INTO hopNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Qa hak sino puhutsatsakwmötsaput yewaskwit aw pihtaknaṅwu. Ispi hak panhtiqw, put ep pihtakqa yuwsit aṅqw tsikq, pu’ pas pāpu wukoprokṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Noqw qa hak sino puk̇awiwkorot sakwiiwmaqat aṅ puhuovavalat kuyṅwu. Ispi hakiy panhtiniqw, puhuovavala pēke’, wiwkorot patomnaqw, ovavala wehemhtini. Noqw wiwkoro sakwítotini. Soon pi puhuovavala qa puhuwiwkorot aṅ kūyiltiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Noqw ahpiy pantaqw, puma nasuṅwintalöṅnit ep söhövos’uyit aṅ nöṅakwisq, put aw nánatuwnayaqam söhövosit talayat mawtiwisa. ");
INSERT INTO hopNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Noqw Pharisee‐sinom Jesus aw paṅqaqwa: Meh, ya puma hinoqw nasuṅwintalöṅnit ep himu mewniwtaqat hintsatsk̇a? ");
INSERT INTO hopNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Noqw pam pumuy amumi paṅqawu: Ya uma qa hisat David hinhtiqat aṅ tuṅwáya? Ura pam‐niqw, pu suṅwámat puma hihta haqni’yuṅqe tsöṅsoq, ");
INSERT INTO hopNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pam God kiyat aw pákihqe, pölavikit God aw noiwtaqat aṅqw nȫsat, suṅwámuy aṅ huyta, Abiathar God awwat mohpeq moṅw’iwtaq’ö. Pam pölaviki moṅw’iwyuṅqamuy‐sa amuṅem nōvatiwṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pu pam pumuy amumi paṅqawu: Nasuṅwintalöṅni hapi sinmuy amuṅem yukiwa, qa sinom nasuṅwintalönnit éṅem yukiwa. ");
INSERT INTO hopNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Paniqw hapi ōviy nu’ Sinot Tiat nasuṅwintalönnit híkis aw tutuyqawi. ");
INSERT INTO hopNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pu piw pam tsotsvalkimi paki; noqw hak tāqa lakput may’taqa pep nuhtuma. ");
INSERT INTO hopNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Noqw mātaqpi kurs Jesus nasuṅwintalöṅnit ep put qalaptsinaniqat ōviy momṅwit put aw tunatyawyuṅwa, puma as hihta ep put nēveltoynayaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Noqw pam lakput may’taqat aw paṅqawu: Kurs nuhtutpik wunuptuu, kita. ");
INSERT INTO hopNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pahsat pu pam pumuy amumi paṅqawu: Ya hak nasuṅwintalöṅnit ep lolmat hinhtiniqw pam súanta, sen qalolmat hinhtiniqö’? sen qatsit ayo táviniqö’? sen nīnaniqö? Noqw puma qa hiṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pu pam hin unaṅwtiqe, pumuy a’nö unaṅwayamuy ep kwaṅwáitsivutiqe, amuhpa’ yorkit, tāqat aw paṅqawu: Uhmay tsihkwaa. Noqw pam put tsihkwa; noqw māat ayaṅqwat māyat an pās powalti. ");
INSERT INTO hopNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pahsat pu Pharisee‐sinom aṅqw ahpiyyaqe, āpiy pay Herod aṅk wīsiwtaqamuy amumum hin as put nīnayaniqey put ankiwakw yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Noqw pay Jesus put aw nánatuwnayaqamuy amumum sinmuy amuṅaqw ahpiynihqe, wuhkovatuphat aqw’a. Noqw sinom qaan’ewakw hintaqam put aṅkya, Galilee‐tutskwat aṅq’ö, pu Judea‐tutskwat aṅq’ö, ");
INSERT INTO hopNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pu Jerusalem‐kitsókit aṅq’ö, pu Idumaea‐tutskwat aṅq’ö, pu pāyut Jordan yupqöyṅaq’ö, pu ima Tyre‐nik̇aṅw pu Sidon‐kitsókit aṅqe’ yesqam pīwu. Puma put k̇ātumaltaqat nanaptaqe, aw öki. ");
INSERT INTO hopNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Noqw pam put aw nánatuwnayaqamuy amumi paṅqawhq, puma put eṅem tsākw pākihut mask̇atota, taq nāp hisat sinom qaan’ewakw hinhte’, put aw hūrs hómikmani. ");
INSERT INTO hopNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pi pam k̇aysiwhqamuy sinmuy qalatsintaqw, ōviy sohsoyam hihta akw tūtuyyaqam put aw tóṅokyaniqey put aw nānaqasya. ");
INSERT INTO hopNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Noqw aṅsakis tuyoy’e’wayom hīhikwsim put aw tātayyaqe atpipo nawhitotak̇ahk̇aṅw, k̇ēew paṅqaqwa: Um hapi God Tíata. ");
INSERT INTO hopNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Noqw puma put tunvotnayaniqw, pam pumuy tusoqmewa. ");
INSERT INTO hopNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pu pam tsomomiqnihqe, hakimuy namorstat, pumuy wáṅwayi. Noqw puma put awya. ");
INSERT INTO hopNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Noqw pam pakwt löq sihk̇ay’taqamuy namorsta, puma put amum hinnumyaniqat ōviy’o, pu pam pumuy aṅqe’ lomatuawit yuaatinumyaniqat ayataniqee. ");
INSERT INTO hopNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Pu puma hīhihta akw tūtuyyaqamuy qalaptsintiwisniqat aw öqalat pam pumuy pasiwna, pu nuhtuṅaqw nukpanhihikwsimuy ayo ipwanwisniqat aw’i. ");
INSERT INTO hopNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Pam imuy tavi: Simon, pam piw Peter yan put tuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Pu Zebedeet tiyat James‐nit, pu tupkoyat John, pumuy pīwu. Pam piw Boanerges yan pumuy tuṅwa; pam Yoy’umukit antaqamu, i’nihqe pam’i. ");
INSERT INTO hopNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pu Andrewt, pu Philip, pu Bartholomewt, pu Matthewt, pu Thomas, pu Alphaeus tiyat James, pu Thaddaeus, pu Simon sinomuy amuṅem qa nātusi’taqata, ");
INSERT INTO hopNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Pu momṅwituy amumi put mātapniqat hakiy Judas Iscariot pīwu. Noqw puma haqam kīve öki. ");
INSERT INTO hopNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Noqw pay piw sinom qaan’ewakw hintaqam amumi tsovaltiqw, ōviy soon kurs puma ṅas’ew nȫnösani. ");
INSERT INTO hopNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Noqw Jesus sinomat put nanaptaqe, put ṅuayaniqe awya paṅqawk̇ahk̇aṅwo: Pam okiw qanavóti’numa. ");
INSERT INTO hopNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Noqw hakim tutavot tutuqaynayaqam Jerusalem aṅqw ökihqe paṅqaqwa: Pam Beelzebub akw tuyqawiwta. Pam nukpanhihikwsimuy moṅwiyamuy aw yank̇aṅw nuhtuṅaqw nukpanhihikwsimuy ipwanta. ");
INSERT INTO hopNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Noqw pam sinmuy wáṅwayhqe, tūwutsit hihta tuawi’taqat akw pumuy amumi paṅqawu: Ya sen Satan Satan ayo hóroknani? ");
INSERT INTO hopNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Haqam moṅwtunatya nehpewhte’, pas soon wúnuni. ");
INSERT INTO hopNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pu kurs haqam kīvit nehpewhtote’ soon hoṅni. ");
INSERT INTO hopNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Noqw kurs Satan nāp nāmi mamk̇e’, pu nātsik̇e’, soon pam wúnuni; panis pi pam sohtini. ");
INSERT INTO hopNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Soon hak hakiy a’nö hoṅvit kīyat aw pak̇e’, hihta himuyat put aṅqw nawhkini, hal pas mohti put some’‐saa, nen pahsat pu pam put kīyat kīqötani. ");
INSERT INTO hopNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nu umumi pas antsa paṅqawni: Hak hihta ep qaanhtiniqw, sen nuhtumiq hiṅqawniqw, pam pantaqa put ahpiy ayo yukiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nīk̇aṅw hak haqam Qahováriwtaqat Hikwsit aqw hiṅqawniqw, pam pantaqa pas soon hisat put ahpiy ayo yukiwni. Panhtiqa pas sūs tūviwniqey aqw nāvitsinani. ");
INSERT INTO hopNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ura puma paṅqaqwa: Pam tuyoy’ewakw hikwsit akw tuyqawiwta, kitotaqw, ōviy pam yan lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Noqw pahsat pu put tupkomat, yuy amum, put aw ökihqe, ihpaq hoṅk̇ahk̇aṅw, put aw hakiy ayatotaqe, put wáṅwayya. ");
INSERT INTO hopNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Noqw sinom k̇aysiwhqam put aqlap yesqam put aw paṅqaqwa: Meh, uhtupkom, uṅuy amum, ihpaq uṅ wáṅwayya. ");
INSERT INTO hopNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Noqw pam lavayhtiqe, amumi paṅqawu: Ya hak íṅuu? Pu ya hakim itupkomya? ");
INSERT INTO hopNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pu pam put aqle’ yesqamuy amuhpa’ yorikt, paṅqawu: Kurs iṅuy, pu itupkomuy amumi yórikyaa. ");
INSERT INTO hopNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pi hak haqam God tunatyayat aṅ hinmaqa hapi itupko, isiwa, pu íṅuu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pu piw pam wuhkovatuphat qalaveq sinmuy tutuqaynativa; noqw sinom qaan’ewakw hintaqam pep put aw tsovalti; noqw ōviy pam pākihut pāhut ep pāyawnumqat aqw pákihqe epeq qatuptu; noqw sinom sohsoyam wuhkovatuphat qalava tutskwava yēse. ");
INSERT INTO hopNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Noqw pam tūwutsit hihta tuawi’taqat akw pumuy hīhihta tutuqayna; nihqe pumuy amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Kurs huvam tuqayvastotaa. Hak tāqa tsalakin’uylawniqe pasmii. ");
INSERT INTO hopNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Noqw pam uylawhq, pēhu poshumi pöhpava löhö. Noqw súmawuy aṅ masay’yuṅqam ö́kihqe aṅ put soswa. ");
INSERT INTO hopNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pu pēhu pik̇aqlöva qa pas pisay’taqat aṅ löhö. Noqw aṅ qa pȫṅalaniqw, ōviy pay āpiy kūkuyva. ");
INSERT INTO hopNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nīk̇aṅw tāwat ōvetiqw, pay ūyi kólaki; nihqe pam qa pas pas ṅay’taqe, ōviy tsahkwi. ");
INSERT INTO hopNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pu pēhu kutqölpa löhö; noqw kutqölö wuṅqe, put laknaqw, pam qa hihta himuy’va. ");
INSERT INTO hopNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pu pēhu lolmat tutskwat aṅ löhökqe kuyvaya; pu wuṅqe, hihta himuy’va, pēhu sunat pakwt sihk̇ay’tasikip aw hóyokput aniwnaya, pu pēhu payhp sunát‐sikipo, pu pēhu tsivót‐sikip sunát‐sikipo. ");
INSERT INTO hopNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pu pam pumuy amumi paṅqawu: Tuqayvastotaa, uma pi naqvuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Noqw puma nánaltyaqw, ima put aqlaqyaqam pakwt löq sihk̇ay’taqamuy amumum it lavayit hihta tuawi’taqat put tūviṅtota. ");
INSERT INTO hopNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Noqw pam pumuy amumi paṅqawu: God moṅwtunatyayat ahpiy navoti tupkiwta pew pahsavoo. Nīk̇aṅw pu’ hapi pam umumiwat susmataq’a; nīk̇aṅw imuywatuy qatuptsiwni’yuṅqamuy amumi qa mahtaq’a. Nīk̇aṅw pam tūwutsit‐sa akw yuaatiwa. ");
INSERT INTO hopNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Puma as aw tayk̇ahk̇aṅw, tutwat, qa māmatsyaniqat ōviy’o, pu aw tūqayk̇ahk̇aṅw nanaptat, qa māmatsyaniqata; taq nāp hisat sen puma ahoy nánamtök̇aqw, pumuy qaanhtipuam pumuy amuhpiy ayo yukiwni. ");
INSERT INTO hopNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pu pam pumuy amumi paṅqawu: Ya uma it tūwutsit hihta tuawi’taqat qa mātsi’yuṅwa? Noqw ya hin tis uma sohsok tūwutsit mātsi’yuṅwni? ");
INSERT INTO hopNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Uylawhqa hapi God lavayiyat uylawu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Noqw lavayi pöhpava löhökqa imuy amunta. Hakim lavayit as nanaptaqw, āpiy pay Satan pite’, pumuy unaṅwpeq lavayit ūyiwhqat paṅqw ipwaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Pu pay piw pan pik̇aqlöva löhökqa hapi imuy amunta. Hakim lavayit nanapte’, hahlayk̇ahk̇aṅw āpiy pay put kwusuyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Noqw lavayi pumuy unaṅwayamuy ep qa hūrs ṅapkiwtaqw, ōviy puma pay hihsavo as aṅ kūyuṅṅwu. Noqw pay lavayit ep k̇ānavotpit, sen okiwsahsaṅwaqat aw pituqw, pahsat pay puma unaṅwmokyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Noqw pu kutqölpa löhökqa hapi imuy amunta. Hakim lavayit as nanaptat, ");
INSERT INTO hopNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Yep qatsit‐sa aw tunatyaltote’, pu k̇āhakiwuy akw ūnatote’, pu hīhihta tuṅlay’k̇ahk̇aṅw, soq lavayit aw qa tunatyaltotiṅwu. Noqw ōviy lavayi pumuy unaṅwpeq qa hihta himuy’vaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Noqw pu lomatutskwat aṅ ūyiwhqa hapi imuy amunta. Hakim lavayit nanapte’, kwusuye’, hihta himuy’vayaṅwu; pētu sunat pakwt sihk̇ay’tasikip hóyokput himuy’vayaṅwu, pu pētu payhp sunát‐sikipo, pu pētu tsivót‐sikip sunát‐sikipo. ");
INSERT INTO hopNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pu pam pumuy amumi paṅqawu: Ya sen hak wihqöhit úwiknat, sīvut sen puvuwhpit atpipoq távini, as pam tsotsókpit ep put tsoki’tanīk̇aṅwo? ");
INSERT INTO hopNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pi sohsoy himu tupkiwtaqa pay mātaqtiniqe ōviy pantaṅwu, piw sohsoy himu nanauyve hiniwhtiqa aṅqe’ nanaptiwniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tuqayvastotaa, uma pi naqvuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pu pam pumuy amumi paṅqawu: Uma hihta aw tūqayyuṅqey ep tunatyaltotimantani. Pi uma hihsa’haqam hakiy eṅem tuwantotaqw, pay piw pan umuṅem tuwantiwmantani; pu uma aṅ nanaptaqamuy amumi piw nāt wūhaq noiwni. ");
INSERT INTO hopNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pi himuy’taqat aw piw pēhu noiwni; pu ṅastanihqa híkispi as hihta himuy’taqey kwayhni. ");
INSERT INTO hopNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Pu pam paṅqawu: God moṅwtunatyaat hakiy tāqat pasva poshumit uyhqat anta. ");
INSERT INTO hopNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pam uyht, mihikq puwṅwu; pu qavoṅvaqw qatuptuṅwu. Nīk̇aṅw poshumi ṅahkuyvak̇aṅw, pu wuṅqw, hin pam panhtiqat pam qa navoti’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pi tutskwa nāp hihta aniwnaṅwu; mohti nahpi’vaṅwu, pu sihkuyvaṅwu, pu timuy tukwsinaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pu himu aniwhtiqw, pahsat pu ūyi’taqa put tsahqaṅwu, pi höhöqyaniqat aw pítuṅwuniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pu pam paṅqawu: Ya sen itam God moṅwtunatyaat hihta antaqat paṅqaqwani? Ya sen itam hihta enaṅ put namimahtaknayani? ");
INSERT INTO hopNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pam mustard‐uyit pōsiyat anta. Pam tutskwave ūyiwhqe as tūwaqatsit ep pōvoshumit amuṅaqw sushihsayhoya. ");
INSERT INTO hopNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nīk̇aṅw pam ūyiwe’, wuṅwe’, sohsok hihta tusaqtsotskit amuhpenihqe yahsayoqtiṅwu; nen wukonantaqay’vaṅwu. Noqw ōviy súmawuy aṅ masay’yuṅqam put atpik kihsit aṅ yesvaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yanhaqam pam tūwutsit hihta tuawi’taqat akw nuhtumi hīhihta yuaataṅwu, pay puma hin put kwusi’wisqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pam tūtuwutsit‐sa akw pumuy amumi yuaata. Nihqe pay ason pumuy nánaltyaqw pam put aw nánatuwnayaqamuy amumi put sohsok namtömnaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Noqw pay ép tapkiqw, pam put aw nánatuwnayaqamuy amumi paṅqawu: Tuma wuhkovatuphat yupqömiya. ");
INSERT INTO hopNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Noqw puma sinmuy suhpantaqamuy aṅqe’ hōnayat, puma pākihut aqw yuña, Jesus haqam qátuhqat aqw’a. Noqw puma paṅqw ahpiyya. Noqw pētu pākihu piw pumuy amumumya. ");
INSERT INTO hopNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Noqw wukohukvaqw, pāhu walalataqe, pākihut aqw a’nö yēvantaqe, nuṅwu pay aqw kūyi ohpo. ");
INSERT INTO hopNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Noqw Jesus pākihut yūpaqwat epeq qötöpay’k̇aṅw pūwi. Noqw puma put tātaynayaqe aw paṅqaqwa: Tutuqaynaqa, ya itamuy so’niqw um pas qa hin unaṅwtini? ");
INSERT INTO hopNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Noqw pam tātayht, hūk̇aṅwuy mēwaqe, pāhut aw paṅqawu: Uyiwalte’, sun yúkuu, kita. Noqw hūk̇aṅw qe’tiqw, qaan’ewakw sutmakma. ");
INSERT INTO hopNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pu pam pumuy amumi paṅqawu: Ya uma hinoqw tsawiniwyuṅwa? Ya hintaqw ōviy uma qa tuptsiwni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Noqw puma pas k̇ātayuṅqe nānami paṅqaqwa: Ya sen i’ hak himuniqw, ōviy hīkispi pas hūk̇aṅw, pu pāhu put aw tuqayvasta? ");
INSERT INTO hopNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pu puma wuhkovatuphat yupqöymi Gádara‐sinmuy tutskwayamuy ep öki. ");
INSERT INTO hopNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Noqw Jesus pākihut aṅqw yamakq, pahsat pay hak tāqa tuyoy’ewakw hikwsit akw tuyqawiwtaqa o’wat ep tuamtuhsöt aṅqwnik̇aṅw put ahsawva. ");
INSERT INTO hopNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Pam tūamit ep okiw ki’ta. Noqw soon kurs hak put sómi’tani, pas sóoni, nāmahin pi hikis pas sivanamiqlölöt akw’a. ");
INSERT INTO hopNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hikis as pam qa sūs hok̇asosomhpit, pu sivanamiqlölöt akw sómiltiṅwu. Nīk̇aṅw pay pam sivanamiqlölöt nāhoy tutkitaṅwu; pu hok̇asosomhpit pīñaṅwu. Pu soon kurs hak put áṅwuy’tani. ");
INSERT INTO hopNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Noqw pam tōkilnawit, pu tāwanawit tsotsmova, pu tūtuamit aṅ hinnumṅwu, a’nö hiṅqawk̇aṅwo, pu o’wat akw nātutkitinumṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Noqw pam Jesus yāvoq túwahqe, aqw wárikqe, pas put aw naokiwlawhqe, ");
INSERT INTO hopNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","A’nö tönay aṅqe’ paṅqawu: Ya um nuy hinhtiniqat nāwaknaka, um Jesus God Sus’oveqnihqat Tíata? Nu God atpip ūmi paṅqawni: Um okiw nuy qa okiwsanni. ");
INSERT INTO hopNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Jesus pay put aw paṅqawu: Tuyoy’eway hikwsi, tāqat aṅqw yámakuu, kita. Noqw ōviy tāqa pan lavayhti.) ");
INSERT INTO hopNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Noqw Jesus put tūviṅtaqe aw paṅqawu: Ya um hin mātsiwa? Noqw pam put hu’waqe aw paṅqawu: Nu Qaan’ewakw hintaqamu yan mātsiwa. Itam qaan’ewakw hintaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Noqw pam pep tutskwat aṅqw pumuy qa lālayniqat ōviy tāqat put aw pas qaatsat nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Noqw pep tsotsmot áhayhk̇e pitsōtim wuhkotonawtaqam nōnova. ");
INSERT INTO hopNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Noqw sohsoyam nukpanhihikwsim put aw qa nātusitotaqe paṅqaqwa: Itamuy pitsōtimuy amumi hōnaqw, itam amumi yuṅni. ");
INSERT INTO hopNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Noqw pahsat pay Jesus pumuy hu’wa. Noqw tuyoy’e’way hīhikwsim tāqat aṅqw nö́ṅakqe, pitsōtimuy amumi yuṅqw, puma tōnawtaqam wuhpatpelat aṅ wuhkovatuphamiq a’nö yuhtukqe, pāmiq paöysoa, (lȫp sōmorit pahsa’haqamo.) ");
INSERT INTO hopNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Noqw pumuy nopni’yuṅqam watqaqe, kīve put tūawvaya, pu aṅqe’ tutskwavaa. Noqw sinom hin hiniwhtiqat aw kuyvawisqe, ");
INSERT INTO hopNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus aw öki; nihqe it tāqat as nukpanhikwsit akw tuyqawiwtaqat, hal qaan’ewkw hintaqamuy hīhikwsimuy akw tuyqawiwtaṅwuqat puma tutwa. Pam yuwsi’k̇aṅw, suyan unaṅway’k̇aṅw pep qatu. Noqw puma put aw yórikyaqe, pas tsātsawna. ");
INSERT INTO hopNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Noqw hakim it nukpanhikwsit akw tuyqawiwtaṅwuqat hin hintsaniwhqat aw yórikyaqam aw kuyvawisqamuy put āawna, pu pitsōtimuy hinhtotiqata. ");
INSERT INTO hopNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Noqw pay as pam pumuy tutskwayamuy aṅqw ahpiyniqat puma Jesus aw ö’qalya. ");
INSERT INTO hopNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Noqw pam pākihut aqw pakitoqw, i’ tāqa nukpanhikwsit akw tuyqawiwtaṅwuqa as put ámumniqey aw ö’qala. ");
INSERT INTO hopNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Noqw pay Jesus put qa nakwhanaqe aw paṅqawu: Um uhsinomuy amuminen, Tutuyqawhqa uṅ ōkwatuwhqe, uṅem hihta qaöwíhinhtiqat pumuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Noqw pam ahpiynihqe, aṅqe’ put yuaatinuma, Decapolis aṅ ahsupoq’a. (Pam pakwt kitsóki i’nihqe pam’i.) Noqw nanaptaqam sohsoyam k̇ātayuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Noqw Jesus pākihut akw ayoqwat piw yamakq, sinom qaan’ewakw hintaqam put aw tsovalti; noqw pam wuhkovatuphat qalaveq wunu. ");
INSERT INTO hopNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Noqw meh, hak tāqa tsotsvalkive moṅw’iwtaqa Jairus yan mātsiwhqa pitu; nihqe pam Jesus túwahqe, kukmiq nātuvaqe, ");
INSERT INTO hopNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Okiw aw naokiwhtaqe, paṅqawu: Okiw imanawhya mómoki. Noqw um as okiw inumumnen, uhmay akw put aw toṅokq, pam qalapte’, qátuni. ");
INSERT INTO hopNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Noqw Jesus put ámuma. Noqw sinom k̇aysiwhqam put aṅkyaqe, aw hūrs homimitiwisa. ");
INSERT INTO hopNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Noqw hak wuhti pakwt löq sihk̇ay’taqat yahsaṅwuy aṅ uṅwáy’taqa pep nuhtuma. ");
INSERT INTO hopNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Okiw pam k̇aysiwhqamuy tūtuhiktuy amutsviy as hīhihta aṅ k̇ānavotk̇aṅw, sohsok hihta himuy amuhpa’ sohsoko; nit qa ṅas’ew hihin qalaptut, tuwat soq pas qalomáhinhti. ");
INSERT INTO hopNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nihqe pam Jesus hintsakqat navotqe, nuhtukwayñaṅaqw sinsonṅaq put aw pítuhqe, yuwsiyat aw toṅo, ");
INSERT INTO hopNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Paṅqawhqe ōviy’o: Ṅas’ew pi nu as put yuwsiyat aw tóṅok̇e’ pay soon qa qalaptuni. ");
INSERT INTO hopNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Noqw pahsat pay put aṅqw uṅwa súlawhti; noqw pam tūyay qalaptuqey nahpe sunvota. ");
INSERT INTO hopNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Noqw kurs öqala nāṅaqw yámakqat Jesus sunvotqe, sinmuy amumi namtökt, paṅqawu: Ya hak iyuwsiy aw toṅo? ");
INSERT INTO hopNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Noqw put aw nánatuwnayaqam aw paṅqaqwa: Meh, sinom ūmi homimitota. Noqw hinoqw pas piw hak ūmi tóṅokqat um kita? ");
INSERT INTO hopNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Noqw pam hakiy panhtiqat aw yórikniqe, ōviy aṅqe’ yori. ");
INSERT INTO hopNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Noqw wuhit napqölpe hinhtiqat navotqe, okiw tsawinneveq tururutik̇aṅw, put aw pítuhqe, atpipo nātuvat, sohsok suan put āawna. ");
INSERT INTO hopNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Noqw pam put aw paṅqawu: Itii, pay uhqapēvewni uṅ qalaptsina. Pay um hahlayk̇aṅw qa hin’unaṅway’k̇aṅw, nīmani. Pay um uhtuyay aṅqw pās qalaptsiwtani: ");
INSERT INTO hopNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Noqw nāt pam yuaataqw, hakim moṅwit kīyat aṅqw ö́kihqe, put aw paṅqaqwa: Pay okiw uhti mōki. Noqw pas um piw nāt Tutuqaynaqat aw nunuiña? ");
INSERT INTO hopNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Noqw puma paṅqaqwaqw, Jesus panis navotqe, moṅwit aw paṅqawu: Um qa hin unaṅwtini; pay um pánis‐sa tuptsiwni’tani. ");
INSERT INTO hopNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Noqw pay qa hak put ámumniqat Jesus nakwhana, hal pay Peter‐niqw pu James‐niqw, pu tupkoat John, púma‐saa. ");
INSERT INTO hopNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pu pam moṅwit kīyat aw pítuhqe, sinmuy mowawatotaqamuy amumi tātayi. Puma hiṅqawk̇ahk̇aṅw, tsaykita. ");
INSERT INTO hopNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Noqw pam aw pákihqe, pumuy amumi paṅqawu: Ya uma hinoqw yanhaqam mowawatota, piw tsaykita? Pay manawhya qa mōki; pi pūwi. ");
INSERT INTO hopNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Noqw puma put aw tutsíwtsuyhti. Noqw pam pumuy sohsokmuy paṅqw lālayht, manawhyat náyat‐nik̇aṅw pu yuyat‐nik̇aṅw pu put ámumyaqamuy tsamk̇aṅw, manawhyat haqam qatsqat aw paki. ");
INSERT INTO hopNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Noqw pam put māyat ṅuat aw paṅqawu: Talitha cumi. Manawhya, qatuptuu, nu ūmi paṅqawu, i’nihqe pam’i. ");
INSERT INTO hopNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Noqw pahsat pay manawhya qatuptuqe nakwsu. (Pam pakwt löq sihk̇ay’tasikip yahsaṅwni’ta.) Noqw pas puma pavan k̇ātayuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Noqw pam pumuy pās mēwaqe qa hak put navotniqat amumi paṅqawu; pu puma manawhyat hihta nopnayaniqat amumi tutapta. ");
INSERT INTO hopNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pu pam paṅqw ahpiynihqe, nāp tutskway aw pitu; noqw put aw nánatuwnayaqam put ámumya. ");
INSERT INTO hopNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pu nasuṅwintalöṅnit aw pituqw, pam tsotsvalkive sinmuy tutuqaynativa. Noqw k̇aysiwhqam put aw tūqayyuṅqe, put aw k̇ātayyuṅqe paṅqaqwa: Ya sen i’ haqam īit hihta tuwi’va? Pu ya sen i’ súanwuwni put aw noiwtaqa hímuu? Is uti pam may akw qaan’ewakw k̇ātumalta! ");
INSERT INTO hopNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Puyaw qa i’ wunavutsit tumaltuwi’taqa, it Maryt tíata, imuy James, nit Joses, nit pu Judat, nit pu Simon, pumuy pāvaamu? Puyaw siwamat qa yep itamumya? Kitotaqe, put aw qaán unaṅwtoti. ");
INSERT INTO hopNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Noqw Jesus pumuy amumi paṅqawu: Pay God lavay’ayaat soon qa k̇aptsitiwṅwu, hal pay nāp tutskway ep‐saa, pu sinomuy amuhpaa, pu nāp kiy ep’e. ");
INSERT INTO hopNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Noqw pay pam kurs hin pep a’nö hihta tumaltaniqe, ōviy pay panis pam híkikwmuy tūtuyyaqamuy amumi may akw tóṅokqe qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nihqe pam pumuy qatuptsiwniyamuy ep amumi k̇ātayta. Pu pam paṅ kitsókinawit sinmuy tutuqaynatinuma. ");
INSERT INTO hopNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pu pam pakwt löq sihk̇ay’taqamuy wáṅwayhqe, pahsat pumuy lȫlöqmuy aṅqe’ ayativa; nihqe tuyoy’e’wakw hīhikwsimuy amumi pumuy öqalat huyta. ");
INSERT INTO hopNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nihqe pay pumuy qa hihta hinwisniqat amumi paṅqawu. Pay panis natöṅpi’wisni, qa tukpuy’wisni, qa nitk̇ay’wisni, qa sivamoki’wisni. ");
INSERT INTO hopNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pu puma tōtsi’wisni; pu qa löq napnay’wisni. ");
INSERT INTO hopNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pu pam pumuy amumi paṅqawu: Umuṅaqw lȫyöm haqam kīmi pak̇e’, hisat pep kitsókit aṅqw ahpiyniqey pahsavo qátumantani. ");
INSERT INTO hopNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pu ason kurs haqawat umuy qa pās taviyat, umumi qa tūqayyuṅqw, uma paṅqw ahpiynen, umuhkukqölṅaqw qöat ayo tsatswimantani, pumuy amunkiwakw hihta sutuawi’tani. Nu umumi pas antsa paṅqawni: Hisat hin yukiltiniqat aw pituqw, pep kitsókit ep sinmuy amuṅem pas is óhini. Puma Sodom‐nik̇aṅw pu Gomorrhat ep sinmuy amuhpenihqe pas pavan amuṅem nuhtsel’ewayhtini. ");
INSERT INTO hopNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Noqw puma paṅqw ahpiyyaqe, sinmuy tunatyay aṅqw lasyaniqat amumi yuaatinumya. ");
INSERT INTO hopNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pu puma sinmuy amuṅaqw k̇aysiwhqamuy nukpanhihikwsimuy ipwanwisa, pu k̇aysiwhqamuy tūtuyyaqamuy wihkuyit akw lelwiyat, qalaptsintiwisa. ");
INSERT INTO hopNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Noqw Jesus natṅwaniat ahsupoq nanaptiwhq, pep tutskwat ep Moṅwi, Herod yan mātsiwhqa, put navotqe paṅqawu: I’ hapi kūyit akw tūtuvoylalawhqa John. Pam mokiwuy aṅqw ahoy tātayhqe, ōviy pas pavan öqaltumalat hintsaki. ");
INSERT INTO hopNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Noqw sinom pētu paṅqaqwa: Pam Elias, piw pētu paṅqaqwa: Pam God lavay’ayaata, imuy lavay’aymuyatuy hisatṅahaqaqw yesqamuy amuni. ");
INSERT INTO hopNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Noqw Herod put navotqe paṅqawu: Ura nu John qötötkuqw, i’ pam’i; kurs pam mokiwuy aṅqw ahoy tātayi. ");
INSERT INTO hopNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","I’ Herod pi ura tupkoy Philip nȫmayat hakiy Herodias amum qatuptuqw, John put aw paṅqawu: Um uhtupkoy nömanawhkiqw pam pas qa suanta. Noqw ōviy Herodias pas John ṅȫyi’ta. Noqw Herod put unaṅwve hinhtiniqe, John aw hakimuy hōnaqw, puma put ṅúayaqe, sivikimi panaya. Noqw Herodias as John nīnaniqey ank̇aṅw, Herod atsviy kurs hin panhtini. ");
INSERT INTO hopNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Pi Herod John aw tunatyawmaq’ö. Pi John súanhinmak̇aṅw pās unaṅway qatu. Noqw Herod put aw navoti’taqe, put k̇aptsi’ta; nihqe put aw tūqaytaqe, nāmi soon unaṅwti. Nīkaṅw pam hahlayk̇aṅw put aw tūqaytaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Noqw hisat nukwáṅw’ew Herod tihtiwhpuyat aw pituqw, pam nuhtumi moṅw’iwyuṅqamuy nōviwhqat aw tūtsama, imuy pavan solāwamomṅwituyu, pu Galilee‐tutskwat ep pavansinmuy pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Noqw Herodias tiat māna ep pákihqe, wunimaqw, Herod put aw nahyoṅwa, pu put amum yesqamu. Noqw Moṅwi mānat aw paṅqawu: Um hihta nāwakne’, put ōviy inumi tūviṅtaqw, nu uṅ put máqani, kita. ");
INSERT INTO hopNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nihqe pas pam put aw qaöwílvayhtiqe paṅqawu: Pay um pas nāp hihta ōviy inumi tūviṅtaqw, soon nu uṅ qa máqani, hikis pas imoṅwtunatyay nāsamiq yantaqata. ");
INSERT INTO hopNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Noqw pam paṅqw ahpiynihqe, yuy aw paṅqawu: Ya nu hihta ōviy tūviṅtani? Noqw pam aw paṅqawu: Pay aw kūyit akw tūtuvoylalawhqat John qötöyat awu. ");
INSERT INTO hopNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Noqw pahsat pay pam k̇aktayk̇aṅw, Moṅwit aw pákihqe, aw paṅqawu: Um kūyit akw tūtuvoylalawhqat John qötöyat inpit ep íniwtaqat pay pu’ nuy máqaniqat nu nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Noqw pas as Moṅwi qahahlayhtik̇aṅw pay nuṅwu pi pas aw qaöwílvayhtiqe, pu imuy pep put amum yesqamuy tuway’taqe, ōviy kurs hin nawus qa hu’wanani. ");
INSERT INTO hopNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nihqe pahsat pay hakiy nīnaṅwuqa put qötöyat kwistoniqat Moṅwi aw paṅqawu. Noqw pam ahpiynihqe, sivikive put qötöyat ayo túkuhqe, ");
INSERT INTO hopNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Inpit ep íniwtaqat kwusivaqe mānat aw put tavi. Noqw māna yuy put maqa. ");
INSERT INTO hopNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Noqw John aw nánatuwnayaqam put nanaptaqe, ep ö́kihqe, tokoyat haqami taviwisa. ");
INSERT INTO hopNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Noqw ima ayaiwyuṅqam Jesus aw natsvalayaqe, hihta hinhtotiqey, pu hihta tūtutuqaynayaqey sohsok put āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Noqw pam pumuy amumi paṅqawu: Túmai, nuhtuṅaqw haqami qayēsiwhpumiya. Nen itam hihsavo pep nāsuṅwnayani. Pas pi sinom k̇aysiwhqam ökiwk̇ahk̇aṅw, ahpiy sasqayaqw, ōviy soon kurs hisat qenitiqw puma ṅas’ew nȫnösani. ");
INSERT INTO hopNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pu ōviy puma pay nanalt pākihut akw haqami qayēsiwhpumiya. ");
INSERT INTO hopNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Noqw pumuy ahpiyyaqw, sinom k̇aysiwhqam amumi tāyuṅqe, Jesus tuwi’yuṅqe, sohsokivaqw kitsókit aṅqw paṅso nāp yuhtukqe, amuhpeqtotaqe, aw tsovalti. ");
INSERT INTO hopNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Noqw Jesus pākihut aṅqw yámakqe, sinmuy qaan’ewakw hintaqamuy túwahqe, pumuy ōkwatuwa, soñawnen pi puma kanelmuy amumi qa hak tunatyawtaqat panyuṅqw ōviy’o. Nihqe pahsat pu pam pumuy hīhihta tutuqaynativa. ");
INSERT INTO hopNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Noqw pay nuṅwu tapkiwmaqw, put aw nánatuwnayaqam put awyaqe aw paṅqaqwa: Pas hapi yep qayēsiwa; noqw hapi pay pas hísatniqti. ");
INSERT INTO hopNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Um as sinmuy hōnaqw, puma aṅqe’ tutskwava nankwusani, pu kitsókinawita; nen nenṅem hihta tunöstuiyani; taq puma qa hihta nitk̇ay’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Noqw pam lavayhtiqe amumi paṅqawu: Huvam nopnayaa. Noqw puma put aw paṅqaqwa: Ya itam haqami huhyawise’, lȫp sunat sīvat akw pölavikit tuiye’, pumuy nopnayani? ");
INSERT INTO hopNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Noqw pam pumuy amumi paṅqawu: Ya uma hihsa’haqam pölaviki’yuṅwa? Kurs aw pohtayaa. Noqw puma nanaptaqe paṅqaqwa: Tsivot pölavikita, pu lȫqmuy pākiwhtuyu. ");
INSERT INTO hopNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Noqw puma sinmuy sakwátusaqat aṅ tōnawyuṅqamuy yesvanayaniqat pam amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Noqw sinom nānan’ik tōnawk̇ahk̇aṅw yesva, hahqe’ tsivót‐sikip susnatya, pu hahqe’ lȫp sunat pakwt sihk̇ay’yuṅqamu. ");
INSERT INTO hopNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Noqw pam tsivot pölavikit pākiwhtuy enaṅ ömahtat, ōmiq tayk̇aṅw, put ep hahlayhtit, pölavikit yóṅoyhtat, put aw nánatuwnayaqamuy amumi put oya. Noqw puma sinmuy amuhpa’ o’ya. Pu pam lȫqmuy pākiwhtuy sohsokmuy aṅ huyta. ");
INSERT INTO hopNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Noqw sinom sohsoyam nȫnösaqe ȫöya. ");
INSERT INTO hopNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Noqw puma pölavikit akwsiṅput tsovalayaqe, pakwt löq sihk̇ay’taqat hoaput aqw opomnaya, pu pākiwhtuy akwsiṅput pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Noqw tahtaqt pölavikit aṅqw nȫnösaqam tsivot‐sikip sōmorit pahsa’haqamo. ");
INSERT INTO hopNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Noqw nāt pam sinmuy aṅqe’ hōnantaqw, put aw nánatuwnayaqam pay aṅwu pākihut aqw yuñe’, put ahsavo ayoqwat Bethsaidat aqwyaniqat pam pahsat pay pumuy tusoqhona. ");
INSERT INTO hopNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pu ōviy pam sinmuy aṅqe’ hōnaqe, nāwaknaniqe tsomomiq’a. ");
INSERT INTO hopNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Noqw masiphiqw, pākihu wuhkovatuphat nāsavaqe hinma; noqw pam tutskwava nālaa. ");
INSERT INTO hopNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Noqw pumuy amuhpewi hūhukq, ōviy puma aṅqe’ kwetstiwisqe pas qa nātusi’wisa. Noqw Jesus pumuy pantsakwisq amumi tātayhqe, tālawiwmaqw pāvaqe waymak̇aṅw, pumuy amumi pituto; nihqe as pay soon pumuy amuhpeq qa yūmosani. ");
INSERT INTO hopNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Noqw puma put pāvaqe waymaqw tutwaqe, pay himu tualaṅwnihqat wūwayaqe, a’nö hiṅqaqwa, ");
INSERT INTO hopNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ispi puma sohsoyam put tutwaqe tsātsawnaqee. Noqw pahsat pay pam pumuy amumi yuaaykuqe paṅqawu: Pay uma qa hin unaṅway’yuṅwni. Pay nūu. Uma qa tsawiniwyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pu pam pumuy amumiq pākihut aqw wūvi; noqw hūk̇aṅw qe’ti. Noqw puma hīhin wūwank̇ahk̇aṅw k̇ātayyuṅwa, ");
INSERT INTO hopNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Puma a’nö unaṅway’k̇ahk̇aṅw pölavikit ep k̇ātumaltiwhqat qa mātsi’yuṅqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Noqw puma ayoqwat nö́ṅakqe, haqami tutskwat Gennesaret aw ö́kihqe, pāhut qalavoq hoyoyotota. ");
INSERT INTO hopNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Noqw puma pākihut aṅqw nöṅakq, pahsat pay sinom Jesus māmatsya. ");
INSERT INTO hopNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nihqe tutskwat aṅ ahsupoq yuhtukqe, hakim tūtuyyaqamuy ahpat aṅ qatsyaqamuy put háqamnihqat nanaptaqe, paṅso pumuy tsamvanta. ");
INSERT INTO hopNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Noqw pam haqami kitsókimi pituqw, sen pas wuhkokitsokit, sen tutskwave kitsókit aw pituqw, sinom ȫöputuy kīsonve o’yaqw, pay ṅas’ew yuwsiyat qalawṅwayat aw tóṅokyaniqey put aw ö’qalya. Noqw hakim hihsa’nihqam aw tóṅokyaqam qalaptuya. ");
INSERT INTO hopNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pahsat pu ima Pharisee‐sinom hakimuy tutavot tutuqaynayaqamuy Jerusalem aṅqw ö́kihqamuy amumum Jesus aw tsovalti. ");
INSERT INTO hopNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Noqw Jesus aw nánatuwnayaqam qa māvaqtotat, nȫsiwhqat nōnovaqw, haqawat amumi tāyuṅqe, pay umumi qaantaqat tutwa. ");
INSERT INTO hopNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ima pi Pharisee‐sinom‐niqw pu sohsoyam Jew‐sinom wūwukwmuy lavayiyamuy aṅ hinwisqe, ōviy qa māvaqtote’, qa nȫnösaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pu puma huhyankiṅaqw ök̇e’, qa māvaqtote’, qa nȫnösaṅwu. Pu ahpiy hīhihta aṅ hinwisniqat tutaptiwhqat puma aw tunatyawwisa. Puma yan hintsak‐wisa: Puma kukyapit, pu sīsivut pās kuksiyaṅwu, pu sik̇asivat aṅqw tsatsqaptat yukiwyuṅqata, pu nönöspita. ");
INSERT INTO hopNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Noqw ōviy Pharisee‐sinom, tutavot tutuqaynayaqamuy amumum Jesus tūviṅtotaqe aw paṅqaqwa: Ya ūmi nánatuwnayaqam hinoqw wūwukwmuy tutavoyamuy qa an hinwisqe, soq qa māvaqtotat, nōnovaṅwu? ");
INSERT INTO hopNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Noqw pam pumuy amumi paṅqawu: Ura Esaias aṅwu pay umuy nawip’ew hinyuṅqamuy pas súaṅqawhqe yan pēna: Ima sinom moay akw nuy k̇aptsilalwa, noqw pi unaṅwaam inuṅaqw yāvahaq’a. ");
INSERT INTO hopNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Piw haktonsa inumi okiwlalwak̇ahk̇aṅw, sinmuy tutavoyamuy pas antsa tutuqayhpinihqat pan put tūtutuqaynaya, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Uma pi God tutavoyat ayo yuki’k̇ahk̇aṅw sinmuy wukwnavotiyamuy pas pas’i’yuṅqe ṅuy’yuṅwa, sīsivut pu kukyapit pās kuksiyak̇ahk̇aṅwo. Pu ahpiy pāvan’e’wakw hīhihta uma hinwisa. ");
INSERT INTO hopNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Pu pahsat pam pumuy amumi paṅqawu: Pas pi ōviy uma tutuhisnik̇aṅw umuhwukwnavotiy aṅ hinwisniqey ōviy God tutavoyat qa hímuya. ");
INSERT INTO hopNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Oviy pi Moses ura paṅqawu: Um unay pu uṅuy pumuy k̇aptsi’tani. Pu hak nay, sen yuy aqw qalomáhiṅqawhqa pay as mokmantani, ura kita. ");
INSERT INTO hopNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Noqw úmawat pi paṅqaqwa: Pu kurs sen hak haqam nay, sen yuy aw paṅqawni: Pay as k̇a um ihimuy akw moṅwvastiniqw, piw pam Corban (pam God aw noiwa, i’nihqe pam’i) kite’, pay qa hintamantani. ");
INSERT INTO hopNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nihqe yan uma hakiy nay, sen yuy eṅem hihta hinhtiniqw aw uhtayaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yan uma umuhwukwnavotiy nuhtumi mātapyaqe God lavayiyat ayo yuki’yuṅwa, pu ahpiy yāyantaqat uma hinwisa. ");
INSERT INTO hopNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pu pam sohsokmuy sinmuy wáṅwayhqe, amumi paṅqawu: Uma sohsoyam inumi tūqayyuṅwe’, māmatsyani. ");
INSERT INTO hopNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Himu sinot qa ahsonvenik̇aṅw put ahsonmi pak̇e’, soon put tuyoy’ewakwtani. Pi sinot unaṅwayat aṅqw nȫṅantaqa hapi put tuyoy’ewakwtaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tuqayvastotaa, uma pi naqvuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Noqw pam sinmuy amuṅaqw kīmi pakiqw, put aw nánatuwnayaqam it lavayit hihta tuawi’taqat put tūviṅtota. ");
INSERT INTO hopNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Noqw pam pumuy amumi paṅqawu: Puyaw uma piw pas qa mātsi’yuṅwa? Puyaw himu sinot qa ahsonvenik̇aṅw put ahsonmi pak̇e’, soon put tuyoy’ewakwtaniqw uma put qa mātsi’yuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ispi pam put unaṅwayat qa aqw pakit, ponoyat aqw pak̇e’ kwayñavehaqam maspiwṅwu. Yan pam lavayhtiqe, sohsok nȫsiwhqat kwaṅw’ewaynihqat paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pu pam paṅqawu: Pi himu sinot unaṅṅaqw nö́ṅakqa hapi put tuyoy’ewakwtaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pi īi himu sinmuy unaṅwayamuy aṅqw nȫnanta: Qalomátunatya, nömaqtsit sokoptunatya, tokot sokoptunatya, tuqwyantunatya, ");
INSERT INTO hopNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Uyiṅwtunatya, tuṅlay’tunatya, nukpantunatya, unatwi, qaunáṅwtalqatsi, unaṅwtuya, nuhtumiq qalomálvayi, kwivi’naṅwa, honaq’unaṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ii hapi qalomáhimu sinot unaṅṅaqw nȫṅantaqa hapi put tuyoy’ewakwtaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pu pam piw paṅqw ahpiynihqe, Tyre‐kitsókit, pu Sidon‐kitsókit pumuy aqlavoo, nihqe kīmi pákihqe qa hak navotniqat nāwakna; nik̇aṅw soon kurs qa navotniwtani. ");
INSERT INTO hopNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pi hakiy wuhtit tiat manawhya tuyoy’ewakw hikwsit akw tuyqawiwtaqw, yuat Jesus hintsakqat navotqe, ep pítuhqe, kukmiq nātuva. ");
INSERT INTO hopNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","I’ hak wuhti pep tutskwat ep sínonik̇aṅw, Greek‐sinmuy lavayiyamuy yuaata; nihqe as pam put tiyat aṅqw nukpanhikwsit hóroknaniqat okiw aw nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Noqw Jesus put aw paṅqawu: Ason tsātsayom mohti ȫöyani, taq soon pi hak tsātsakwmuy nȫsiwhqayamuy ömahtat, pu popkotuy amumi maspaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Noqw pam lavayhtiqe aw paṅqawu: Pas antsaa, Tutuyqawhqa; noqw pay pi popkot nönöspit atpik̇aqe tsātsakwmuy nōvayamuy piṅput nōnovaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Noqw Jesus put aw paṅqawu: Pay um yan lavayhtit nímani. Pay nukpanhikwsi uhtiy aṅqw yama. ");
INSERT INTO hopNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Noqw wuhti kiy ep pituqw pay kurs nukpanhikwsi put tiyat aṅqw yama; noqw pam ahpay aṅ wáökiwta. ");
INSERT INTO hopNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pu piw Jesus Tyre‐nik̇aṅw pu Sidon pumuy qalaṅaqw ahpiynihqe, Decapolist tutskwat qalavaqe hinmak̇aṅw, Galileet ep wuhkovatuphat ep pitu. ");
INSERT INTO hopNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Noqw hakim hakiy naqsöp’iwk̇aṅw huhrulqat yuaataqat put aw wikvayaqe, as pam put aw hintsanniqat aw nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Noqw pam suhpantaqamuy sinmuy amuṅaqw put qalavo wikt, put naqvumiq malatsiy panat, töhakt, leniyat aw toṅo, ");
INSERT INTO hopNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nit pu ōmiq yorikt, wupahikwsut, put aw paṅqawu: Ephphatha, (hötsíltii, i’nihqe pam’i). ");
INSERT INTO hopNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Noqw pahsat pay put naqvuat hötsíltiqw, pu leñiat ṅāhiwa. Noqw pam suyan yuaativa. ");
INSERT INTO hopNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Noqw pam pumuy mēwaqe put pantaqat qa hakiy āawnayaniqat amumi paṅqawu. Noqw tuwat soq pam pumuy pās mēwaqw pahsat pas puma aṅqe’ tunvotnaya. ");
INSERT INTO hopNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pas pi puma k̇ātayyuṅqe, ōviy paṅqaqwa: Pas sohsok hihta qaöwíhinhti; pas nanaqsöptuy naqvuyamuy hötahta, pu qayuáatotaqamuy yuaaykina. ");
INSERT INTO hopNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Noqw ephaqam sinom wukotsovawk̇aṅw, qa hihta nitk̇ay’yuṅqw, Jesus put aw nánatuwnayaqamuy wáṅwayhqe, amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Pas nu sinmuy ōkwatuwa, pu’ pāyis tēvep inumumyak̇ahk̇aṅw, okiw kurs hihta nōnovani. ");
INSERT INTO hopNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Noqw nu pumuy qa ȫyiwyuṅqamuy kīkiyamuy aṅqe’ hōnaqw, soon puma qa māmaṅuani, pi pētu yāvaqhaqaqw öki. ");
INSERT INTO hopNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Noqw put aw nánatuwnayaqam lavayhtotiqe put aw paṅqaqwa: Puyaw sen hak haqam nȫsiwhqatnen imuy sinmuy yep qayēsiwhpuve haqam öynani? ");
INSERT INTO hopNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Noqw pam pumuy tūviṅta: Ya uma hihsa’haqam pölaviki’yuṅwa? Noqw puma paṅqaqwa: Tsáṅee. ");
INSERT INTO hopNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pu pam sinmuy tutskwava yesvaniqat amumi paṅqawu. Nit pu pam tsaṅe’ pölavikit ömahtat, put ep hahlayhti, nit put yōṅoyhtat, pu put aw nánatuwnayaqamuy amumi put oya, sinmuy nopnayaniqat ōviy’o. Noqw puma panhtoti. ");
INSERT INTO hopNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Noqw puma hikikw hiṅsakwmuy pāvakiwhtuy kinumya. Noqw pam pumuy ep hahlayhtit, pu put aw nánatuwnayaqam sinmuy piw nopnayaniqat amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pu ōviy puma nȫnösaqe ȫöya. Noqw puma yóṅoyhput akwsiṅqat tsovalayaqe, tsaṅe’ hoaput aṅ opomnaya. ");
INSERT INTO hopNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Noqw ima nȫnösaqam nālöp sōmorit pahsa’haqamo. Noqw pam pumuy aṅqe’ hōna. ");
INSERT INTO hopNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nit pahsat pay pam put aw nánatuwnayaqamuy amumum pākihut aqw pakit, Dalmanutha‐tutskwat ep pitu. ");
INSERT INTO hopNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Noqw hakim Pharisee‐sinom put aw ö́kihqe, amum nāṅwuy’yuṅqe, put aw tuwantota; nihqe as pam ōṅaqw k̇ātatayhpit hihta tuawi’taqat mahtaknaniqat put aw ö’qalya. ");
INSERT INTO hopNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Noqw pam unaṅwpeq öykitat paṅqawu: Ya hinoqw pu’ qatsívaptsiwyuṅqam k̇ātatayhpi hihta tuawi’taqat aw yórikyaniqey‐sa nānawakna? Pas antsa nu umumi paṅqawni: Pay soon k̇ātatayhpi hihta tuawi’taqa pu’ qatsívaptsiwyuṅqamuy amumi mahtakiwni. ");
INSERT INTO hopNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pu pam pumuy amuṅaqw nakwsut, pākihut aqw piw paki, wuhkovatuphat yupqöymiq yámakniqee. ");
INSERT INTO hopNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Noqw put aw nánatuwnayaqam kurs pölavikit suhtokya; pay puma pākihut aṅqw pas panis sūkw pölaviki’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Noqw pam pumuy u’nanaqe, amumi paṅqawu: Uma tunatyaltote’, Pharisee‐sinmuy pēk̇eniyamuy ep qa ūnaiwyuṅwni, pu Herod pēk̇eniyat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Noqw puma nānami paṅqaqwa: Itam qa nitk̇ay’wisq, ōviy paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Noqw Jesus put navotqe, pumuy amumi paṅqawu: Ya uma hinoqw qa pölaviki’wisqey lavayta? Puyaw uma nāt a’nö unaṅway’yuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ya uma pōsi’k̇ahk̇aṅw qa tāyuṅwa, piw naqvuy’k̇ahk̇aṅw, qa nanvotya? Ya uma qa u’ni’yuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ura nu tsivót‐sikip sōmorit pahsa’nihqamuy tahtaqtuy amuhpa’ tsivot pölavikit yóṅoyhtaqw, uma akwsiṅqat tsovalayaqe, hihsakip hoaput opomnaya? Noqw puma put aw paṅqaqwa: Pakwt löq sihk̇ay’taqata. ");
INSERT INTO hopNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Pu ura nu nālöp sōmorit pahsa’nihqamuy sinmuy amuhpa’ tsaṅe’ pölavikit yóṅoyhtaqw, uma akwsiṅqat tsovalayaqe, hihsakip hoaput opomnaya? Noqw puma paṅqaqwa: Tsáṅee. ");
INSERT INTO hopNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Noqw pam pumuy amumi paṅqawu: Noqw ya hintaqw ōviy uma nāto qa māmatsya? ");
INSERT INTO hopNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pu pam Bethsaidat ep pitu. Noqw hakim hakiy qapostalqat put aw wikvayaqe, pam put aw hintsanniqat aw nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Noqw pam qapostalqat māyat ṅuat, kīṅaqw qalavo put wīki; nit put posmiq töhakt, pu lȫvaqw may akw put aw toṅokt, sen pam hihta túwahqat tūviṅta. ");
INSERT INTO hopNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Noqw pam kwuhpukt, paṅqawu: Pay nu sinmuy himutsotskit anyuṅqamuy yaktaqw tuwa. ");
INSERT INTO hopNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Noqw pahsat pu piw pam put posmiq lȫvaqw may akw hintsanqw, put pōsiat tālawva. Noqw pam powaltiqe, pas suyan sohsokmuy tuwa. ");
INSERT INTO hopNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pu Jesus put kīyat aw hōna paṅqawk̇aṅwo: Um qa kīmini; piw um qa hakiy kīve it āawnani. ");
INSERT INTO hopNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pu Jesus put aw nánatuwnayaqamuy amumum paṅqw ahpiynihqe, Caesarea Philippi aṅ kitsókinawit nakwsu. Noqw pumuy paṅsoyaqw, pam put aw nánatuwnayaqamuy tūviṅtaqe amumi paṅqawu: Ya sinom nuy hákiynihqat paṅqaqwa? ");
INSERT INTO hopNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Noqw puma paṅqaqwa: Yaw um kūyit kw tūtuvoylalawhqa John‐nihqat paṅqaqwa. Pu yaw um Elias‐nihqat pētu paṅqaqwa. Pu haqawatuyniqw yaw um himuwa God lavay’ayaata. ");
INSERT INTO hopNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pahsat pu pam pumuy amumi paṅqawu: Noqw úmuyniqw nu hak’i? Noqw Peter hu’waqe, put aw paṅqawu: Um hapi Christ, (God ahpiy moṅw’asi’taqa). ");
INSERT INTO hopNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Noqw pam pumuy pās mēwaqe, puma put pantaqat qa hakiy āawnayaniqat amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pahsat pu pam yuaativaqe, pumuy amumi paṅqawu: Pas nu’ Sinot Tiat kurs hin hīhihta aṅ qa k̇ānavotni. Noqw ima wukw’a’yat‐niqw, pu God awwat mohpeq momṅwit‐niqw, pu tutavot tutuqaynayaqam nuy tūvayani, piw nuy nīnayani. Noqw pāyis talq nu ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Noqw pam it pas suyan paṅqawhq, ōviy Peter put qalavo láṅaknat mēwa. ");
INSERT INTO hopNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Noqw pam namtökqe, put aw nánatuwnayaqamuy amuhpa’ tātayht, Peter u’nanaqe aw paṅqawu: Inuhkwayñavoo, Satan! taq um qa God tunatyayat wūwantat, tuwat soq sinmuy tunatyayamuyu. ");
INSERT INTO hopNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pu pam sinmuy put aw nánatuwnayaqamuy enaṅ wáṅwayhqe amumi paṅqawu: Inuṅkniqey nāwaknaqa nāqahihtatat, nahoylehtsiy īkwiltat, inuṅk nakwsumantani. ");
INSERT INTO hopNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pi qatsiy k̇ahk̇awnaqa hapi put kwayhni; pu inuṅem tunatyat, pu lomatuawit ōviy qatsiy kwayhqa hapi put tuyqawvani. ");
INSERT INTO hopNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ispi puyaw as sino tūwaqatsit sohsok himuy’vak̇aṅw nāp qatsiy kwahe’, hin pam put akw moṅwvastini? ");
INSERT INTO hopNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ya sen sino hihta akw qatsiy ahoy nāptini? ");
INSERT INTO hopNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Paniqw hapi ōviy haqawa pu’ tusk̇ap’iwyuṅqamuy, qaanhinwisqamuy qatsívaptsiwyuṅqamuy amutpip nuy, ilavayiy enaṅ hahmanqw, nu’ Sinot Tiat put hapi tuwat hahmanni, nu hisat ihoṅviaymuy qahováriwyuṅqamuy tsamk̇aṅw, Inay lolmat tālawṅwayat yank̇aṅw pītee. ");
INSERT INTO hopNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pu pam pumuy amumi paṅqawu: Pas antsa nu umumi paṅqawni: Soon pas hisat God moṅwtunatyaat öqalat yank̇aṅw pítuni. Noqw ima yep hoṅqamuy amuṅaqw haqawat nāt mokiwuy qa aw ök̇e’ put aw yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pu ahpiy navaysikis talq, Jesus Peter‐nit, James, pu John, púmuy‐sa tsamk̇aṅw, haqami wupatukwit aqwnihqe, pepeq pumuy amutpik alöṅti. ");
INSERT INTO hopNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Noqw yuwsiat nūvat an qȫtsatiqe pavan pas talqaqsala; noqw pas soon hak tūwaqatsit ep tsatsákmötsaput hintsakqa put an pas pavan qȫtsatani. ");
INSERT INTO hopNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Noqw pahsat pu Elias, Moses amum pumuy amumi mātaqtiqe, Jesus amum yuaata. ");
INSERT INTO hopNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Noqw Peter lavayhtiqe, Jesus aw paṅqawu: Tutuqaynaqa, pas hapi itam yépeqyaqw lolma. Himu as ōviy itam payhp kistotani, suk‐wat úṅemnit, pu suk‐wat Moses éṅemnit, pu suk‐wat Elias éṅemi. ");
INSERT INTO hopNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pay pam kurs hiṅqawniqe ōviy paṅqawu, pas puma tsātsawnaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Noqw ōmaw pepeq pumuy amumi kihsiwnaqw, aṅqaqw hakiy tönaat paṅqawu: I’ hapi pas aw iunaṅwa Itii; put uma aw tuqayvahsi’wisni. ");
INSERT INTO hopNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Noqw āpiy pay puma aṅqe’ yórikyat, qa hakiy tutwa; pay Jesus nāla pumuy amumuma. ");
INSERT INTO hopNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Noqw puma tūkwiṅaqw hanwisq, pam pumuy pās mēwaqe, amumi paṅqawu: Ason pas nu’ Sinot Tiat hisat mokiwuy aṅqw ahoy tātayniqat aw pahsavo uma hin yórikyaqey qa hakiy āawnayani. ");
INSERT INTO hopNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Noqw puma put lavayiyat ṅuy’yuṅwa; nihqe pam mokiwuy aṅqw ahoy tātayniqey hiṅqawhqat nātuviṅlalwa. ");
INSERT INTO hopNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Noqw puma put tūviṅtotaqe aw paṅqaqwa: Ya hinoqw tutavot tutuqaynayaqam Elias soon qa mohti pítuniqat lavayta? ");
INSERT INTO hopNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Noqw pam pumuy hu’waqe amumi paṅqawu: Pay Elias pas antsa mohti pite’, sohsok hihta aṅ ahoy aw antsantani. Noqw Sinot Tiat hin pey’taqw, pan kurs nu hin qa hīhihta aṅ kānavote’, qa hímuniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Noqw nu umumi paṅqawni: Pay as Elias pas antsa pitu. Noqw puma hin nānawaknaqey an put hintsatsna, hin pam pey’taqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Noqw pam put aw nánatuwnayaqamuy amumi pítuhqe, sinom qaan’ewakw hintaqam pumuy amumi tsovawtaqamuy amumi yóri. Noqw tutavot tutuqaynayaqam pumuy amumum hīhihta yuaatotaqe, pumuy tūviṅlalwa. ");
INSERT INTO hopNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Noqw sinom sohsoyam Jesus tutwaqe, pas aw k̇ātayyuṅqe, pahsat pay aw yuhtukqe aw hahlayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Noqw pam tutavot tutuqaynayaqamuy amumi paṅqawu: Ya uma hihta pumuy amumum yuaatota? ");
INSERT INTO hopNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Noqw sinmuy amuṅaqw haqawa lavayhtiqe aw paṅqawu: Tutuqaynaqa, nu as itiy tiyot ūmi wikva, hikwsi hakiy lavayiyat nawhkiṅwuqat akw okiw pam tuyqawiwtaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hikwsi put haqam ṅue’ okiw tutskwamiq put tūvaṅwu; noqw qötmokṅwu, pu tamay ṅuriritik̇aṅw nawhtaṅwu. Noqw as ūmi nánatuwnayaqam put aṅqw put ayo hóroknayaniqat nu amumi paṅqawhq, pay puma kurs hin panhtotini. ");
INSERT INTO hopNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Noqw pam lavayhtiqe, put aw paṅqawu: Is ohi uma pu’ qatsívaptsiwyuṅqam qatuptsiwni’yuṅqamu, ya nu hihsavohaqam umumum yantani? Ya nu hihsavohaqam umuy maqsonlawni? Pew wikyaa. ");
INSERT INTO hopNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Noqw puma put aw put wikya. Noqw hikwsi Jesus tuwaqw, tiyo homimiykuqe, okiw pam tutskwamiq yēvaqe, qötmokiwk̇aṅw aṅqe’ waöötinuma. ");
INSERT INTO hopNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Noqw Jesus put nayat tūviṅtaqe, aw paṅqawu: Ya i’ hísathaqam it aw pitu? Noqw pam paṅqawu: Pay tsayṅahaqaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Noqw pam piép as it hovalanik qȫhit aqw tūvaṅwu, pu pāhut aqw’a. Noqw kurs um hihta tuwi’te’, um okiw itamuy ōkwatuwni, nen itamuy paaṅwani. ");
INSERT INTO hopNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Noqw Jesus put aw paṅqawu: Pay um tuptsiwhq’ö; tuptsiwhqat eṅem sohsoy himu pasiwta. ");
INSERT INTO hopNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pahsat pu tsākw naat okiw pakk̇aṅw paṅqawu: Tutuyqawhqa, nu tuptsiwa, um okiw iöwituptsiwniy ep nuy paaṅwani. ");
INSERT INTO hopNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Noqw sinom put aw yuyutyaqw, Jesus amumi yórikqe, tuyoy’ewakw hikwsit mēwaqe, aw paṅqawu: Um hikwsi hakiy lavayiyat nawhkiṅwuqa pu naqvuyat uhtaṅwuqa, nu ūmi pas paṅqawni: Um put aṅqw yámakni; nen pāpu qa hisat aw pákini. ");
INSERT INTO hopNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Noqw hikwsi a’nö hiṅqawht, put homimiykunat, aṅqw yama. Noqw pay sumataq pas mokq, ōviy wūhaknihqam paṅqaqwa: Pay mōki. ");
INSERT INTO hopNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Noqw Jesus put mayat ṅuat, láṅaknaqw, pam wunuptu. ");
INSERT INTO hopNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Noqw pam ahpami pakiqw, put aw nánatuwnayaqam pay nanaltyak̇ahk̇aṅw put tūviṅtotaqe aw paṅqaqwa: Ya hintaqw ōviy itam kurs hin put hóroknayani? ");
INSERT INTO hopNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Noqw pam pumuy amumi paṅqawu: Pay i’ yantaqa pas nāwakinpit akw‐nik̇aṅw pu napwalnit‐sa akw ayo hórokniwṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Noqw puma paṅqw ahpiyyaqe, Galilee‐tutskwat aṅ ayo nöṅa; noqw qa hak put navoti’taniqat pam nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Pi pam put aw nánatuwnayaqamuy tutuqaynaqe, amumi paṅqawu: Nu’ Sinot Tiat sinmuy öqalayamuy aw mātaviwni. Noqw puma nuy nīnayani. Noqw ason nu nīniwe’, payis talqat ep ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Noqw puma put hiṅqawhqat qa māmatsyak̇aṅw, piw put tūviṅtotaniqey nánahtsopya. ");
INSERT INTO hopNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pu pam Capernaum ep pitu. Nihqe pam ahpavenik̇aṅw pumuy yan tūviṅta: Ya uma aṅqwyaqe hihta nānami pas pavan yuaatiwisa? ");
INSERT INTO hopNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Noqw puma qa hiṅqaqwa; puma pi aṅqwyaqe haqawa pa pas suspavanniqat nānami yuaatiwisa. ");
INSERT INTO hopNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Noqw pam qatuptut pakwt löq sihk̇ay’taqamuy wáṅwayhqe, amumi paṅqawu: Mohpeqniqey nāwaknaqa hapi sohsokmuy amuṅaqw nuhtuṅkmantani, pu sohsokmuy tumalay’tamantani. ");
INSERT INTO hopNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pu pam hakiy tsākw paṅso wikqe, amuhsonve tavit, put tsöpahtat, pumuy amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Haqawa inuṅem yan hihtawat tsākw pās távihqa hapi nuy pās távimantani, pu haqawa nuy pās távihqa hapi qa nuy pās tavit, aṅqw nuy pew távihqat pās távimantani. ");
INSERT INTO hopNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Noqw John lavayhtiqe, paṅqawu: Tutuqaynaqa, hak itamum qa hinmaqa uhnatṅwaniy aw yank̇aṅw nukpanhihikwsimuy ipwanta. Noqw itam aw yórikyaqe put mēwaya, qa itamum hinnumqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Noqw Jesus paṅqawu: Uma qa mēwantotani. Soon pi hak haqam inatṅwaniy aw yank̇aṅw k̇ātatayhpit hintsakqa nuy paysoq qalomáyuaatani. ");
INSERT INTO hopNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Qa itamuhpew’iwtaqa hapi itamuma. ");
INSERT INTO hopNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pas antsa nu umumi paṅqawni: Hak haqam inuṅem umuy Christ sinomatniqw ōviy umuy kuyapkuynaqa pas soon qa ahsatiy ömahtani. ");
INSERT INTO hopNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Pu kurs haqawa imuy tsātsakwmuy hihtawat inumi tuptsiwni’taqat lasnaqw, pay pi tatam put kwapk̇aqe wukomata hāyiltiqw pam wuhkovatuphamiq tūviwhq, pam pantaqa put eṅem pay ṅas’ewni. ");
INSERT INTO hopNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Noqw ōviy kurs uhma uṅ lasnaqw, um put ayo túkuni. Pay pi um tatam qa pasiwk̇aṅw qatsit aw pákini, hikis pi as um lȫqmuy may’k̇aṅw maskiveq qȫhit pas qa tokṅwuqat aqw pákini. ");
INSERT INTO hopNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Pepeq ātu pumuy sówantotaqam qa so’ṅwu, piw qȫhi pas qa tokṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pu kurs uhkuku uṅ lasnaqw, um put ayo túkuni; Pay pi um tatam qa pasiwk̇aṅw qatsit aw pákini, hikis pi as um lȫqmuy kuhkuy’k̇aṅw maskiveq qȫhit pas qa tokṅwuqat aqw tūviwni. ");
INSERT INTO hopNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Pepeq ātu pumuy sówantotaqam qa so’ṅwu, piw qȫhi pas qa tokṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pu kurs uhposi uṅ lasnaqw, um put ayo hóroknani. Pay pi um tatam sūkw pōsi’k̇aṅw God moṅwtunatyayat aw pákini, hikis pi as um lȫqmuy pōsi’k̇aṅw maskiveq qȫhit pas qa tokṅwuqat aqw tūviwni. ");
INSERT INTO hopNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Pepeq ātu pumuy sówantotaqam qa so’ṅwu, piw qȫhi pas qa tokṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Pi sohsoyam qȫhit akw suhutiwyani, pu sohsoy hom’oyi ȫṅat akw suhutiwni. ");
INSERT INTO hopNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Öṅa as lolma. Nīk̇aṅw kurs as pam suhuviwniqw, ya sen uma hihta akw put suhutotani? Uma suhupkiwyuṅwni, nen uma qa nānami hin unaṅway’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pu pam paṅqw nakwsuk̇aṅw, Jordan pāyut yupqöyve Judea‐tutskwat aqlavo pitu. Noqw sinom qaan’ewakw hintaqam piw put aw öki. Noqw pay pi pam panhtiṅwunihqe piw pumuy tutuqaynativa. ");
INSERT INTO hopNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Noqw Pharisee‐sinom put aw ö́kihqe, unahepyaqe, tūviṅtotaqe aw paṅqaqwa: Ya tāqa nȫmay mātapniniqw pam súanta? ");
INSERT INTO hopNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Noqw pam lavayhtiqe amumi paṅqawu: Ya Moses umumi hin tutapta? ");
INSERT INTO hopNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Noqw puma paṅqaqwa: Hak nȫmay mātapninik pan put eṅem tutuventat, put hōnamantaniqat Moses sinmuy pan nakwhana. ");
INSERT INTO hopNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Noqw Jesus lavayhtiqe amumi paṅqawu: Pay pi uma a’nö unaṅway’yuṅqw, ōviy Moses it tutavot umuṅem pēna. ");
INSERT INTO hopNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Noqw pi as yayhniwhqat aṅqaqw hisat hīhihta yukiltiqat pepeq God tāqat pu wuhtit pumuy yuku. ");
INSERT INTO hopNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Paniqw hapi ōviy tāqa nay, pu yuy mātapt, nȫmay aw huruhtimantani. ");
INSERT INTO hopNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Noqw puma lȫyömnik̇aṅw sūkw tokot antamantani. Noqw ōviy hapi puma pāpu qa lȫyömnit sūk̇a tókoniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Paniqw ōviy God hakimuy namitsak̇aqat qa hak nāhoy távini. ");
INSERT INTO hopNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Noqw put aw nánatuwnayaqam ahpave pay piw nāt put tūviṅtota. ");
INSERT INTO hopNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Noqw pam pumuy amumi paṅqawu: Hak nȫmay mātapt, piw sukw amum qatupte’, tokot sokoptaqey akw nȫmay ehpewi qaanhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pu kurs wuhti kōñay mātapt, piw sukw amum qatupte’, pam tokot sokoptaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Noqw hakim tsātsakwmuy tsamk̇ahk̇aṅw, Jesus aw ö́kihqe, as pam pumuy amumi hintsanniqat aw paṅqaqwa. Noqw put aw nánatuwnayaqam pumuy tusoqmewaya. ");
INSERT INTO hopNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Noqw Jesus put túwahqe, qa yan unaṅwtiqe, amumi paṅqawu: Uma tsātsakwmuy inumi nakwhanayani; uma qa mēwantotani. Pi panyuṅqam hapi God moṅwtunatyayat ep sinoiwyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pas nu umumi súaṅqawni: Hak God moṅwtunatyayat tsākw qa an kwúsuhqa pas soon paṅso pákini. ");
INSERT INTO hopNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pu pam pumuy tsöpalawk̇aṅw, amumi mámatyawht, öqalanta. ");
INSERT INTO hopNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Noqw pam paṅqw ahpiyniqw, hak tiyo aṅqaqw wárikiwtaqe put atpipo tamötswunuptut, aw tūviṅtaqe paṅqawu: Lomatutuqaynaqa, ya nu hihta hinhte’, qatsit qa so’taqat himuy’vani? ");
INSERT INTO hopNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Noqw Jesus put aw paṅqawu: Ya um hinoqw nuy lolmalawu? Pi qa hak lolma, hal pas God‐saa. ");
INSERT INTO hopNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pay pi um hinwisniqat tutavot navoti’ta: Um tokot qa sokoptani; um hakiy qa nīnamantani; um hihta qa ūuymantani; um hakiy hihta qa atsátoynamantani; um unay, pu uṅuy, pumuy k̇aptsi’tamantani, it’a. ");
INSERT INTO hopNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Noqw pam lavayhtiqe aw paṅqawu: Tutuqaynaqa, pay nu pas itsákoy aṅqaqw put sohsok aṅ hinma. ");
INSERT INTO hopNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pahsat pu Jesus put aw taynumqe, aw unaṅway’ta; nihqe aw paṅqawu: Um sūpwat hihta ep qa pasiwta. Um ahpiynen hihta uhhimuy húyani; nen aṅ ōokiwyaqamuy sīvat huytani. Nen um ōveqatsit ep hihta hihk̇ay’taqat himuy’vani. Pu um aṅqwnen nahoylehtsit kwusut inuṅkni. ");
INSERT INTO hopNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Noqw pam put lavayit ep unaṅwmokqe, qahahlayk̇aṅw paṅqw ahpiy’o; pam hihta nihti’taqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pu Jesus aṅqe’ yorikt, put aw nánatuwnayaqamuy amumi paṅqawu: Pas k̇ahaksinmuy amuṅem qatuvoshinta God moṅwtunatyayat aw yuṅwniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Noqw put aw nánatuwnayaqam put lavayiyat ep hin kurs wūwaya. Noqw Jesus piw lavayhtiqe amumi paṅqawu: Tōtimu, pas k̇āhakiwuy aw yanyuṅqamuy amuṅem qatuvoshinta God moṅwtunatyayat aw yuṅwniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pay himu pohko pȫlay’taqa tsakomostat aṅ pórokput aṅ yámakniniqw pam pay qa pas qa tūvosi. Noqw pay k̇ahaksino God moṅwtunatyayat aw pákiniqw pam put eṅem pas qatūvosi. ");
INSERT INTO hopNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Noqw pahsat puma tis pas kurs hin wūwayaqe, nānami paṅqaqwa: Noqw pantaniqw, hak sen ayo yámakni? ");
INSERT INTO hopNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Noqw Jesus pumuy amuhpa’ tayk̇aṅw paṅqawu: Pay sinmuyniqw i’ kurs hin pasiwtani. Nīk̇aṅw God‐niqw qa panta. Pi God‐niqw sohsoy himu pasiwta. ");
INSERT INTO hopNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pahsat pu Peter yuaaykuqe aw paṅqawu: Meh, itam hapi sohsok hihta tatamhtotat, uṅk nankwusa. ");
INSERT INTO hopNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Noqw Jesus lavayhtiqe paṅqawu: Pas antsa nu umumi paṅqawni: Pas qa hak paysoq kiy, sen pāvamuy, sen tupkomuy, sen qȫqamuy, sen siwamuy, sen nay, sen yuy, sen nȫmay, sen timuy, sen pāvasay inuṅem tunatyat‐nik̇aṅw pu lomatuawit eṅem tunatyat ōviy mātavi. ");
INSERT INTO hopNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Nīk̇aṅw pam tuwat it qatsit ep tsivót‐sikip sunát‐sikip hóyokiwtaqat himuy’vani: Kīkihuta, pāvamuyu, tupkomuyu, qȫqamuyu, siwamuyu, yúmuyu, tímuyu, pu pāvasata, pu okiwsahsanpit énaṅa; pu piw qatsit nātoniqat ep qatsit qaso’taqata. ");
INSERT INTO hopNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nīk̇aṅw hapi k̇aysiwhqam mohti’wisqam nuhtuṅktotini; pu nuhtuṅkyaqam mohti’wisni. ");
INSERT INTO hopNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Noqw puma paṅ Jerusalem aqwyaqw, Jesus pumuy amupyeve hinma; noqw puma hin kurs wūwank̇ahk̇aṅw, maqasneveq aṅk hinwisa. Noqw pam pakwt löq sihk̇ay’taqamuy piw namitsovalat, hin pam hintsaniwniqey pumuy āwintiva; ");
INSERT INTO hopNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nihqe amumi paṅqawu: Meh, itam hapi Jerusalem aqwya. Noqw nu’ Sinot Tiat God awwat mohpeq momṅwituy‐nik̇aṅw pu tutavot tūtutuqaynayaqamuy amumi mātaviwni. Noqw puma nuy mokiwuy hihk̇ay’taqat paṅqaqwani; nen imuy qa‐Jew‐sinmuy amumi nuy noayani. ");
INSERT INTO hopNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Noqw puma inumi tututsiwyat, nuy wuvalalwat, inumi töhtotani; nen nuy nīnayani. Noqw pāyis talq nu ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Noqw hakiy Zebedeet timat James‐niqw pu John, puma Jesus aw pítuhqe, aw paṅqawu: Tutuqaynaqa, um as itamuy hin nāwaknaqw pan itamuy hintsanni. ");
INSERT INTO hopNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Noqw pam pumuy amumi paṅqawu: Ya nu hihta umuṅem hinhtiniqat uma nāwakna? ");
INSERT INTO hopNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Noqw puma put aw paṅqawu: Ason um moṅwqatuptuqw, as itamuṅaqw haqawa uhputvaqe qatuqw, pu suhk̇awa uhsuyvaqe qátuniqat um itamuy hu’wanani. ");
INSERT INTO hopNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Noqw Jesus pumuy amumi paṅqawu: Uma hihta ōviy tūviṅlawhqey qa mātsi’ta. Ya pay nuy k̇ānavotpit aṅqw yúkuniqat aṅqw uma yúkuniqey suhtaq’ewa? Ya sen uma nuy hin tuvoylaiwtaqat pan tuvoylatiwniqe ōviy’o? ");
INSERT INTO hopNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Noqw puma put aw paṅqawu: Owi, pay itam soon qa panhtini. Noqw Jesus pumuy amumi paṅqawu: Pay nu kānavotpit aṅqw yúkuniqat uma as soon aṅqw qa yúkuni; pu nu hin piw tuvoylatiwhqat uma soon as qa pan tuvoylatiwyani. ");
INSERT INTO hopNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nīk̇aṅw pay nu hakiy iputvaqe sen isuyvaqe qátuniqat paṅqawniqey öqalat qa pasiwta. Nīk̇aṅw pay ason pas pam hakimuy amuṅem na’sastiwhq, pumuy amumi pam noiwni. ");
INSERT INTO hopNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Noqw ima pakwtnihqam put nanaptaqe, James‐nik̇aṅw pu John, pumuy amumi qa yan unaṅwtoti. ");
INSERT INTO hopNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Noqw Jesus pumuy wáṅwayhqe, amumi paṅqawu: Pay uma navoti’yuṅqw, imuy qa‐Jew‐sinmuy amumi moṅw’iwyuṅqey yan túṅwantiwyaqam pumuy amumi tutuyqawya; pu pumuy amuhpa’ pavansinom öqalay pumuy nanvotnatiwisa. ");
INSERT INTO hopNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nīk̇aṅw uma hapi qa panhtotimantani; pay umuṅaqw haqawa pas pāvanniqey nāwaknaqa umuy tumalay’tani. ");
INSERT INTO hopNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pu uma haqawa pas susmohpeqniqey nāwaknaqa sohsokmuy tūwikiamni. ");
INSERT INTO hopNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hikis pi nu’ Sinot Tiat qa hihta tu’yalawniqe ōviy pitu; pi nu nuhtumi unaṅwtapniqe ōviy pitu, piw sinmuy k̇aysiwhqamuy amuṅem iqatsiy táviniqee, pumuy ayo óyaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pu puma Jericho aw öki. Noqw pam put aw nánatuwnayaqamuy‐nik̇aṅw pu sinmuy k̇aysiwhqamuy amumum Jericho aṅqw ahpiyniqw, hak qapostalqa Bartimaeus yan mātsiwhqa, hakiy Timaeus tiat, pöhut qalave qatuk̇aṅw, okiw nuhtumi hihta tuṅlay’ta. ");
INSERT INTO hopNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Noqw yaw hak Nazareth aṅqw tāqa Jesus paṅnihqat pam navotqe, put aw tsa’lawhqe paṅqawu: Um Jesus, David Tíata, okiw nuy ōkwatuwaa. ");
INSERT INTO hopNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Noqw hakim wūhaqnihqam put mēwayaqe, qa hiṅqawlawniqat aw paṅqaqwa. Noqw pahsat pu pam ōvaqe tsa’lawhqe paṅqawlawu: Um David Tíata, okiw nuy ōkwatuwaa. ");
INSERT INTO hopNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Noqw Jesus pep huruhtit, puma put wáṅwayyaniqat amumi paṅqawu. Noqw puma qapostalqat wáṅwayyaqe aw paṅqaqwa: Hahlayhtit, wunuptuu; pam uṅ wáṅwaylawu. ");
INSERT INTO hopNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Noqw pam usimniy ayohaqami tūvat, wunuptut, Jesus aw nakwsu. ");
INSERT INTO hopNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Noqw Jesus lavayhtiqe, put aw paṅqawu: Ya nu uṅ hintsanniqat um nāwakna? Noqw qapostalqa put aw paṅqawu: Tutuyqawhqa, um as okiw ivosiy tālawnani. ");
INSERT INTO hopNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Noqw Jesus put aw paṅqawu: Taa, pay um nímani; uhqapevewni uṅ powata. Noqw pahsat pay pam pōsiy tālawnaqe, pahpiy pöhpava Jesus aṅki. ");
INSERT INTO hopNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Noqw puma Jerusalem ahayhp ökiwisa, tsomot Ólivet aw’i. Pep hapi Bethphage‐kitsóki‐nik̇aṅw pu Bethany‐kitsóki wunu. Noqw pumuy paṅso ökiqw, Jesus lȫqmuy put aw nánatuwnayaqamuy ayataqe, ");
INSERT INTO hopNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Amumi paṅqawu: Uma kitsókit umupyeve wúnuhqat awni. Nen uma panis ep pak̇e’, pay morohyat pas nāt qa hisat hak aqw wupqat sómiwtaqat túwani. Uma put ṅaht, aṅqw wikni. ");
INSERT INTO hopNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pu ason kurs hak umuy hinoqw pantsakqat paṅqawhq, uma put aw paṅqawni: Itahtutuyqawhqa put haqni’ta, uma aw kítani. Noqw pahsat pay pam aṅqw put lālayni. ");
INSERT INTO hopNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Noqw puma ahpiynihqe, haqam ihp pönalsive hötsíwat aqlap morohyat sómiwtaqat tuwa; nihqe puma put ṅaha. ");
INSERT INTO hopNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Noqw pumuy pantsakq, hakim pep hoṅqam pumuy amumi paṅqaqwa: Ya uma hinoqw morohyat ṅáṅaha? ");
INSERT INTO hopNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pu ōviy Jesus pumuy amumi hin tutaptaqat puma pan amumi lavayhti. Noqw puma pumuy mātapya. ");
INSERT INTO hopNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Noqw puma Jesus aw morohyat wikvaqe, put aqw yuwsiy ahpata. Noqw pam aqw wūvi. ");
INSERT INTO hopNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Noqw k̇aysiwhqam pö́nawit yuwsiy ahpatota. Noqw pētu himutsotskit nantaqayat tsahqayaqe, put pö́nawit ahpatota. ");
INSERT INTO hopNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pu ima mohti’wisqam‐niqw pu amuṅkyaqam tsa’tiwisqe paṅqawwisa: Öqawmaṅwu! Nam Tutuyqawhqat natṅwaniyat aw yank̇aṅw pitutoqa tayawintiwaa. ");
INSERT INTO hopNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nam itanay David moṅwtunatyaat Tutuyqawhqat natṅwaniyat aṅ pitutoqa tayawintiwaa. Nam God Sus’oveqnihqa put öqalaa! ");
INSERT INTO hopNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Noqw Jesus Jerusalem aw pákihqe, God kīyat awnihqe, sohsok hihta aṅ yori. Noqw pay pas hísatniqtiqw, ōviy pam pakwt löq sihk̇ay’taqamuy amumum paṅqw Bethany‐kitsókit aw’i. ");
INSERT INTO hopNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Noqw qavoṅvaqw puma Bethanyt aṅqwyaqw, pam tsöṅmokqe, ");
INSERT INTO hopNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yāvo nönvospaltsokit nahpi’taqat túwahqe, put aw’i, nāphisat sen put ep aniwnit túwaniqe ōviy’o. Noqw pam aw pítuhqe qa hihta tuwa, pay panis nahpiyat‐saa, nāt nönvospala hisat aniwhtiṅwuqat qa aw pituqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Noqw Jesus lavayhtiqe aw paṅqawu: Nam turs yahpiy qa hak ūṅaqw hihta nösni. Noqw put aw nánatuwnayaqam nanapta. ");
INSERT INTO hopNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pu puma Jerusalem aw öki. Noqw Jesus God kīyat aw ṅö́yak’iwpuyat aw pákihqe, pahsat pu pep hakimuy huhyayaqamuy paṅqw ihpomiq lālayi, pu hihta tuhtuy’yaqamuyu, pu sīvat nāhoyṅwantotaqamuy huhyanpiyamuy takuminva, pu imuy hö́wihtuy huhyayaqamuy atsvewayamuy pīwu. ");
INSERT INTO hopNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nihqe hakiy pep ṅö́yakpuva haqami hihta yawmaniqat pas qa nakwha. ");
INSERT INTO hopNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Noqw pam tutuqaynaqe, pumuy amumi paṅqawu: Ura God lavay’ayaat put eṅem yan pēna: Iki hapi nāwakinkihunihqey pan sohsokmuy sinmuy amuhpiy túṅwantiwni. Noqw soq tuwat uma put uuyiṅwtuy kīyat pan yukuya. ");
INSERT INTO hopNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Noqw tutavot tutuqaynayaqam God awwat mohpeq momṅwituy amumum put nanaptaqe, hin as put nīnayaniqey wūwanvaya, sinom sohsoyam put tutuqayhpiyat aw k̇ātayyuṅq’ö. Noqw ōviy puma put mamqasya. ");
INSERT INTO hopNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pu tapkiqw pam kīṅaqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pu qavoṅvaqw puma aṅqwyaqw, kurs nönvospaltsoki ṅay aqwhaqami lāki. ");
INSERT INTO hopNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Noqw Peter u’naqe, Jesus aw paṅqawu: Tutuqaynaqa, meh ura um nönvospaltsokit aw qalomálavayhtiqw, kurs pam lāki. ");
INSERT INTO hopNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Noqw Jesus lavayhtiqe, pumuy amumi paṅqawu: God aw tūtuptsiwaa. ");
INSERT INTO hopNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pas antsa nu umumi paṅqawni: Haqawa it tsomot nahlak̇e’ wuhkovatuphamiq tūviwniqat aw paṅqawhqa pas unaṅwpeq qa pēvewnak̇aṅw, hin lavayhtiqey pas soon qa anhtiniqat tuptsiwe’, hin lavayhtiqey pas soon aw qa yórikni. ");
INSERT INTO hopNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Paniqw ōviy nu umumi paṅqawni: Uma nānawaknak̇ahk̇aṅw, hihta ōviy tūviṅlalwe’, uma pas soon put qa ömahtotaniqey qa pēvewnaye’, put makiwyamantani. ");
INSERT INTO hopNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pu uma hoṅk̇ahk̇aṅw nānawakne’, kurs hakiy aw hihta ep hinyuṅwe’, put ayo yukuyamantani. Noqw Umuna, ōveqatsit ep qátuhqa umuy mewnit ep qaanhtotiqat tuwat umuhpiy put ayo yúkumantani. ");
INSERT INTO hopNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nīk̇aṅw kurs uma hakiy ahpiy put qa ayo yukuyaqw, pay soon Umuna ōveqatsit ep qátuhqa umuy mewnit ep qaanhtotiqat tuwat umuhpiy ayo yúkumantani. ");
INSERT INTO hopNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pu puma piw Jerusalem aw öki. Noqw Jesus God kīyat ep waynumqw, hakim God awwat mohpeq momṅwit‐niqw, pu tutavot tutuqaynayaqam, pu wukw’a’yat put aw ö́kihqe, ");
INSERT INTO hopNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aw paṅqaqwa: Ya um hakiy öqalayat aw yank̇aṅw īit hintsaki? Ya hak uṅ īit hintsakniqat uṅ öqalmaqa? ");
INSERT INTO hopNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Noqw Jesus lavayhtiqe, amumi paṅqawu: Kurs nu piw tuwat umuy sūkw hihta tūviṅtani. Noqw ason kurs uma put nuy āawnayaqw, pu’ nu tuwat piw hihta öqalat aw yank̇aṅw īit hintsakqey umuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ura John kūyit akw tūtuvoylalawu. Ya pam pantsakniqey haqaqw makiwa? sen ōveqatsit aṅqö’? sen sinmuy amuṅaqö’? Uma nuy āawnayani. ");
INSERT INTO hopNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Noqw puma nānami put yuaatotaqe paṅqaqwa: Pas k̇a itam, Oṅaq’ö kitotaqw, kurs hin pam qa paṅqawni: Noqw ya hinoqw pantaqw uma put aw qa tūtuptsiwa? kītani. ");
INSERT INTO hopNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pu as k̇a itam Sinmuy amuṅaq’ö kitotanik̇aṅw‐pi puma sinmuy mamqasya, sinom sohsoyam John pas antsa God lavay’ayaatnihqat pan mātsi’yuṅqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Noqw ōviy puma lavayhtotiqe, Jesus aw paṅqaqwa: Pay kurs itam hin paṅqaqwani. Noqw Jesus lavayhtiqe, amumi paṅqawu: Pay nu tuwat soon hihta öqalat aw yank̇aṅw īit hintsakqey umuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pahsat pu pam lavayit hihta tuawi’taqat yuaativaqe, pumuy amumi paṅqawu: Hak tāqa ōvat uyht, put aw ṅö́yaknat, haqam ōvat pālayat yuykuyaniqat eṅem qölötat, tuwalankihut kītat, hakimuy tumalay’yuṅqamuy amumi put mātavi. Nit pahsat pu pam yāvoqhaqamii. ");
INSERT INTO hopNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nihqe hisat kwaṅwtiniqat aw pituqw, pam ovauyit tumalay’yuṅqamuy amumi tumal’ayay hōna, amuṅaqw aniwnit makiway ömahtaniqey ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Noqw puma put ṅuayaqe a’nö wuvahtotat, qa hihta hintaqat ahoy lālayya. ");
INSERT INTO hopNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pu piw ūyi’taqa suk‐wat tumal’ayay pumuy amumiq hōna. Noqw puma putwat tatatupyaqe qötöyat wuvahtotat, hamanhintsatsnat lālayya. ");
INSERT INTO hopNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pu piw pam suk‐wat amumi hōna. Noqw puma putwat nīnaya. Noqw pam wūhaqnihqamuy amumiq hōna. Noqw puma pētuy wuvahtota, pu haqawatuy qöqya. ");
INSERT INTO hopNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Noqw pam sūkw tiy pas aw unaṅway nāt tavi’taqe, pu nuhtuṅk pumuy amumiq put tavi paṅqawk̇aṅwo: Pay soon puma itiy qa k̇aptsitotani. ");
INSERT INTO hopNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Noqw tuwat soq ovauyit tumalay’yuṅqam nānami paṅqaqwa: I’ hapi nay akpetaniqa. Taa, itam nīnayani; noqw himu aw noiltiniqa itahhimuniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pu puma put ṅuayaqe, nīnayat, ovauyit aṅqw qalavohaqami tūvaya. ");
INSERT INTO hopNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Taa, noqw ōvat ūyi’taqa it ep sen hinhtini? Pam pite’, ovauyit tumalay’yuṅqamuy qö́yani. Nen pam a’löṅtuy amumi ovauyit nóani. ");
INSERT INTO hopNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Noqw ya uma yan pey’taqat qa hisat aṅ tuṅwáya? Owa kīlalwaqamuy amuhpiy qalavo tūviwhqa hapi tuyqaatniwhti. ");
INSERT INTO hopNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tutuyqawhqa it tumaltaqw, itamuy‐niqw k̇ātatayhpi, it’a? ");
INSERT INTO hopNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Noqw suyan pi pam pumuy amuhpewi yan lavayhtiqw, ōviy puma put ṅuayaniqey unaṅwtoti. Nīk̇aṅw puma sinmuy mamqasya; nihqe put mātapyat paṅqw ahpiyya. ");
INSERT INTO hopNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Noqw hisnen as puma put lavayiyat akw núansanyaniqe ōviy hakimuy Pharisee‐sinmuy, Herod aṅk wīsiwtaqamuy enaṅ put aw hōnaya. ");
INSERT INTO hopNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Noqw puma put aw ö́kihqe aw paṅqaqwa: Tutuqaynaqa, itam ūmi navoti’yuṅqw um pas qa atsat aṅ hinma; piw um qa hakiy mamqasi, ispi um sinmuy wuwniyamuy qa k̇aptsi’k̇aṅw, God tuwiyat suan tūtutuqaynaqee. Ya itam moṅwit eṅem hihta aṅ sivit Caesar aw siviwisniqw pam súanta, sen pay qa súanta? ");
INSERT INTO hopNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sen itam sisviyani, sen pay itam qa sisviyani? Noqw kurs puma paysoq hintsatsk̇aqw pam amumi mātsi’taqe amumi paṅqawu: Ya uma hinoqw nuy unaheplalwa? Pew yālit yawwisq nu aw yórikni. ");
INSERT INTO hopNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Noqw puma aw put taviya. Noqw pam pumuy tūviṅtaqe amumi paṅqawu: Ya hakiy pitsáṅwaat ep pey’ta? pu ya hakiy tuṅwniat aṅ pey’ta? Noqw puma put aw paṅqaqwa: Caesar pitsáṅwaata. ");
INSERT INTO hopNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Noqw Jesus lavayhtiqe, amumi paṅqawu: Uma turs Caesar hihta himuyat Caesar aw siviwisni, pu uma God hihta himuyat God aw noayani. Noqw puma put aw k̇ātayuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pahsat pu hakim Sadducee‐sinom, yaw sinmuy qa ahoy yesvaniqat paṅqaqwaqam put aw ö́kihqe, put tūviṅtotaqe aw paṅqaqwa: ");
INSERT INTO hopNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tutuqaynaqa, ura Moses itamuṅem yan pēna: Kurs hak tāqa tupkoy’taqa qa tímuy’k̇aṅw mok̇e’, yep nȫmay mātapq, put tupkoat wuhtit amum qatupte’, pāvay eṅem tíoymantaniqat paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Taa, ura hakim tsáṅe’nihqam nānatupkom as yēse. Noqw mohti’maqat nö́matat, qa hihta ti’k̇aṅw pay mōki. ");
INSERT INTO hopNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Noqw pu aṅknihqa put nȫmayat amum qatuptut, qa ti’k̇aṅw mōki; noqw pu amuṅknihqa pay piw amunti. ");
INSERT INTO hopNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Noqw puma as tsáṅe’nihqam put nȫmatota; nit qa hihta tío’ya. Noqw nuhtuṅk pu wuhti tuwat mōki. ");
INSERT INTO hopNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Taa, noqw ya ōviy ahoy yesvaniwniqat aw pituqw, pumuy tātayyaqw, pam pumuy hihtawat nȫmaatni, pi puma tsáṅe’nihqam put nȫmatota? ");
INSERT INTO hopNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Noqw Jesus lavayhtiqe, pumuy amumi paṅqawu: Suyan pi uma tutuvenit‐nik̇aṅw pu God öqalayat qa tuwi’yuṅwa. Ya qa paniqw ōviy uma qa suan wūwaya? ");
INSERT INTO hopNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pi puma mokiwuy aṅqw tātayye’ qa nȫmalalwani, piw qa puwsuṅwlalwani; pi puma ōveqatsit ep yesqamuy God hoṅviaymuyatuy amunyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Noqw kurs uma so’qam ahoy yesvaniqat tūviṅlalwaqw‐Ya uma Moses pēniyat ep it qa hisat aṅ tuṅwáya? Ura pam himutskit yuaataqe yan pēna: Ura God put aw paṅqawu: Nu hapi Abraham, pu Isaac, pu Jacob, pumuy Tutuyqawhqaamu, it’a? ");
INSERT INTO hopNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Oviy pi God qa so’pumuy amumi tutuyqawi, pi yesqamuy amumii. Oviy uma pas qahin aw suan wūwaya. ");
INSERT INTO hopNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Noqw hak tutavot tutuqaynaqa amumi pítuhqe, puma hihta yuaatotaqat navota; noqw pas Jesus pumuy amumi súaṅqawhq navotqe, put tūviṅtaqe aw paṅqawu: Ya tutavot sohsok amuṅaqw himuwa pas suspavani’? ");
INSERT INTO hopNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Noqw Jesus put hu’waqe aw paṅqawu: Sohsok tutavot amuṅaqw suspavannihqa hapi ii. Tuqayvastotaa, Israel‐sínomu. Tutuyqawhqa hapi aw itahyantaqa. Pam hapi pas nāla Tutuyqawi. ");
INSERT INTO hopNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Noqw ōviy hapi uma sohsok umuh’unaṅway akw God Umuhtutuyqawhqay aw unaṅway’yuṅwni, pu sohsok umuhhikwsiy akw’a, pu sohsok umuhwuwniy akw’a, pu sohsok umuh’öqalay akw’a. I’ hapi pas suspavannihqa tutavo. ");
INSERT INTO hopNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Noqw aṅknihqa piw put anta. Um nāmi hin unaṅway’taqey pas pan uhsinosṅway aw unaṅway’tani. Qa himu hapi tutavo imuy amuhpenihqe pas pávan’i. ");
INSERT INTO hopNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Noqw tutavot tutuqaynaqa paṅqawu: Pas antsaa, Tutuqaynaqa, um súaṅqawu. Pi God pas sūk̇aa, qa hak pīwu, pas pam‐saa. ");
INSERT INTO hopNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Piw hak God eṅem wākasit tataqtsok̇e’, sen put aw hihta noe’ súantsakṅwu. Noqw pay hak sohsok unaṅway, pu sohsok wuwniy, pu sohsok hikwsiy, pu sohsok öqalay akw put aw unaṅway’k̇aṅw, nāmi hin unaṅway’taqey pan sinosṅway aw unaṅway’taqa hapi put epnihqe pas pavan súanhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Noqw pas pam put aw súaṅqawhq Jesus navotqe, put aw paṅqawu: Pay um God moṅwtunatyayat aṅqw qa yāpo. Noqw pahpiy pu’ pāpu qa hak hisat put hihta tūviṅtaniqey unahintsaki. ");
INSERT INTO hopNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Noqw Jesus God kīyat ep tūtutuqaynak̇aṅw, lavayhtiqe paṅqawu: Ya hintaqw ōviy tutavot tutuqaynayaqam Christ David tíatnihqat paṅqaqwa? ");
INSERT INTO hopNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pi ura David Qahováriwtaqat Hikwsit ahpiy pas nāp paṅqawu: Tutuyqawhqa Imoṅwiy aw paṅqawu: Um hāk iputvaqewat qátuni, nu hisat uhtuwqamuy áṅwutaqw, puma ūmi maqaptsi’yuṅwniqat pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Noqw ōviy hapi David pas nāp put Moṅwílawhq, ya hin pam put tíatni? Noqw söqavuṅwsinom put nanaptaqe, hahlayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Pu pam pumuy tutuqaynak̇aṅw amumi paṅqawu: Uma tutavot umuy tutuqaynayaqamuy wupayuwsi’numyaniqey nānawaknak̇ahk̇aṅw, kitpik pas k̇aptsi’tiwyaniqey tuṅlay’yuṅqamuy amuhpe qa nāunay’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Puma tsotsvalkiva pas mohk̇aqe atsvewat tuṅlay’yuṅwa, pu nōviwhqat aṅ mohk̇aqe qeqnita. ");
INSERT INTO hopNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Puma koṅnanalvutuy kīkiyamuy tusoqkwahank̇ahk̇aṅw, nānawakne’, nawip’ew sutsépyuaatotaṅwu. Ima hapi pas pavan qaöwíhintsaniwyani. ");
INSERT INTO hopNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Noqw Jesus sivatataṅpit ayaṅqwat qatuk̇aṅw, sinmuy paṅsoq sīvat ōoyaqw, amumi tayta. Noqw k̇aysiwhqam k̇ahaksinom aqw nihtiwtaqat taṅalalwa. ");
INSERT INTO hopNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Noqw hak koṅnalavu ōokiwhqa pítuhqe lȫq hihsaq votōnat paṅso pana. Puma lȫyömnen sūk̇a palávotōnaniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Noqw Jesus put aw nánatuwnayaqamuy wáṅwayhqe, amumi paṅqawu: Pas antsa nu umumi paṅqawni: Pas i’ koṅnalavu ōokiwnihqa imuy sivatataṅpit aqw ōoyaqamuy amuhpenihqe aqw suswuhaq oya. ");
INSERT INTO hopNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Puma pi pay qa rūrumnayak̇ahk̇aṅw hihta akwsiṅqat paṅsoq ōoya. Noqw i’ pi rūrumnak̇aṅw pas sohsok himuy, pas hihta akw qátuhqey sohsok paṅsoq oya. ");
INSERT INTO hopNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Noqw Jesus God kīyat aṅqw yámaktoqw, haqawa put aw nánatuwnaqa put aw panqawu: Tutuqaynaqa, meh, is uti pavan pas o’wa! pu pavan pas kīkuhu! ");
INSERT INTO hopNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Noqw Jesus lavayhtiqe put aw paṅqawu: Ya um īit qaan’ewakw kīkihut aw tayta? Pay nāt qa haqam owa qeniy ep akwsiṅwni; pas sohsoy sahpukiwni. ");
INSERT INTO hopNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Noqw pam God kīyat ayaṅqwat tsomot Olivet epeq qatuqw, Peter‐niqw, pu James‐niqw, pu John‐niqw, pu Andrew, puma pay nánaltyak̇ahk̇aṅw put tūviṅtotaqe, aw paṅqaqwa: ");
INSERT INTO hopNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Um kurs itamuy āawnani: Ya hisat īi himu yaniwhtini? Pu hisat īi sohsoy hiniwhtiniqw himu put tuawi’tani? ");
INSERT INTO hopNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Noqw Jesus pumuy hu’waqe, amumi yan lavayhti: Uma tunatyaltotini, taq nāphisat hak umuy ūnatoynani. ");
INSERT INTO hopNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nāt k̇aysiwhqam inatṅwaniy aṅ ö́kini; nen paṅqaqwani: Nu Christ, kitotani; nen k̇aysiwhqamuy ūnatoynayani. ");
INSERT INTO hopNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pu uma nāqöyiwuy yāvaqnihqat nanvotyani, pu umuhhayhk̇e’ nāqöytaqw uma nanaptani. Nīk̇aṅw uma qa hin unaṅwtotini. Pi pay pam pāvantaqat pas soon qe’ni. Nīk̇aṅw pay hapi nāt qa pep so’ṅwamiq pítuni. ");
INSERT INTO hopNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pi aṅqe’ hihtuwat sinom hihtuywatuy sinmuy amumi wuṅkuyamantani. Pu moṅwtunatya sukw moṅwtunatyat ehpewhtimantani. Pu hāhaqe’ tutskwa tayáyaykuni, pu tsöṅösqatsini, pu koyanisqatsini. Ii hapi hīhihta k̇ānavotpit yayhniata. ");
INSERT INTO hopNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Noqw pay uma nānami tunatyaltotini. Nāto hakim haqe’ moṅwtsovawyuṅqamuy amumi umuy noayani. Pu uma tsotsvalkiva wuvimuyiwyani, pu nuhtumi momṅwituy, pu pas momṅwituy amutpipo tsamvaniwyani. Noqw uma pumuy amumi nuy tuawi’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Noqw lomatuawi hapi pas soon qa mohti sohsokmuy sinmuy amumi yuaatiwni. ");
INSERT INTO hopNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nīk̇aṅw ason puma umuy tsamye’, momṅwituy amumi mātatveqw, uma aṅwu pay hihta yuaaykuyaniqey qa wūwantotamantani; piw uma qa yēwalalwamantani. Pi ason aw pituqw, Qahováriwtaqa Hikwsi umuy hin tutuqaynaqw, pan uma yuaaykuyani. Pi qa uma yuaaykuyamantani; pi Qahováriwtaqa Hikwsi hapi umuhpiy yuaaykuni. ");
INSERT INTO hopNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Noqw hapi nātupkom nāmi nukpanhtiqw, himuwa sukw mokiwuy aw mātapni, pu nāam tīmuyu. Pu tímat namuy, yumuy amuhpewhtote’, tuqwyantotaqamuy amumi pumuy noayani. ");
INSERT INTO hopNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pu sinom sohsoyam umumi qa suhtaq’ewyani, uma isinomniqw ōviy’o. Noqw pay yūmosa aṅ kuytaqa hapi ayo yámakni. ");
INSERT INTO hopNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ura God lavay’ayaat Daniel yan lavayhti: Hak nuhtsel’ewaynihqa tūkiqötaniqa wunuptuni. Aṅ túṅwantaqa māmatsni. Noqw ōviy ason pam haqam as qe’niqey ep wunuqw, uma aw yórikyaqw, pep pu’ ima Judeat aṅ yesqam tuhtukwimiq watqani. ");
INSERT INTO hopNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pu i’ hak kíts’oveqnihqa paṅqw ahpami qa hāhawni, piw hihta ōviy paṅso qa papkini. ");
INSERT INTO hopNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pu i’ hak pasve hinnumqa qa kīmi yuwsiy ōviyni. ");
INSERT INTO hopNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Noqw hisat aw pituqw, pep hapi pu’ haqawat aṅ nö’yiwyuṅqamuy, pu yōyoṅnayaqamuy kurs hin watqaniqamuy amuṅem pas is óhini. ");
INSERT INTO hopNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Noqw uma qa tömö’ watkiwnumyaniqey ōviy God aw nānawaknani. ");
INSERT INTO hopNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ispi aw pituqw k̇ānanvotpininiq’ö, pas hisat God hihta yúkuhqat pahpiy pew pahsavo qa hisat pan haqam hiniwhtiqat pan’i; piw pas soon hisat pāpu paniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Noqw as Tutuyqawhqa pan talöṅwintiwhqat qa pelvotaqw, soon hak ayo yámakni. Nīk̇aṅw pay hapi pam hakimuy namorstaqey pumuy tunatyawk̇aṅw, pan talöṅwintiwhqat pay pelvotaniqey tunatyawta. ");
INSERT INTO hopNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pep pu’ ason kurs hak umumi Meh, yep Christ, sen kítani, sen meh, pam áyamo, kitaqw, uma qa tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pi nāto hakim atsáy’k̇ahk̇aṅw Christ‐yaqey, pu God lavay’aymatnihqey pan nātsok̇ani’yuṅqam hoṅvani; nen k̇ātatayhpit hihta tuawi’yuṅqat poṅalalwani, sen pay hin pasiwtaniqw hikis pi pas namorstiwyaqamuy lasnayaniqey ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Noqw uma hapi tunatyaltotini. Meh, nu hapi sohsok hihta umuy aṅwu pay āawna. ");
INSERT INTO hopNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Noqw ephaqam, put k̇ānavotpit atsve tāwa qa tālawvani; pu mūyawuy aṅqw qa talni. ");
INSERT INTO hopNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Pu tokpelat aṅqe’ sótu löhöhöykuni, pu tokpelat aṅqe’ hīhimu öqala tayayaykuni. ");
INSERT INTO hopNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Noqw pahsat pu nu’ Sinot Tiat qaan’ewakw öqalat pasiwk̇aṅw a’nö sóniwk̇aṅw, ōomawhtuy akw hawtoqw, sinom inumi yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Noqw pep pu’ nu ihoṅviaymuy aṅqe’ ayatani. Noqw puma nānan’ivaqw inamoramuy tsovalayani, tūwaqatsit susqalawṅwayat aṅqw it tokpelat susqalawṅwayat aṅqee. ");
INSERT INTO hopNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Taa, noqw uma nönvospaltsokit hihta tuawi’taqat nanaptani; nāt put nantaqaat qa húrunen nahpi’wisq, kurs tal’aṅw hayiṅwnaqat uma nanaptaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Noqw pan hapi uma īit yantaqat hiniwmaqw aw yórikye’, pay pas aw pitsíwtaqat nanaptani, hikis pi pay pāpu pas hötsíwhpeqnihqata. ");
INSERT INTO hopNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pas antsa nu umumi paṅqawni: Ima sinom soon tūtuwayaqw, pay īi sohsoy yaniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tokpela, pu tūwaqatsi pay tūwayani; nīk̇aṅw ilavayi hapi pas soon tūwayani. ");
INSERT INTO hopNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nīk̇aṅw hisat aw talöṅvaniqat, pu haqe’, qalawmaniqat qa hak navoti’ta. Pas qae, ōveqatsit ep hoṅvia’yam qa navoti’yuṅwa, pu piw Tíata. Pas Ina nāla put navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Uma tunatyaltotini; nen qa ūnaiwk̇ahk̇aṅw nāwakintotani. Taq uma hisat aw pítuniqat qa navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pi nu’ Sinot Tiat hakiy haqam yāvoqnihqat anta. Pam hak kiy aṅqw ahpiyniqe tumal’aymuy amumi himuy noat, nanāp pumuy tumalhuytat, pu tuwalan’ayat tūwalaniqat aw paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Paniqw ōviy uma tunatyawyuṅwni. Taq uma ki’taqat hisat pítuniqat qa navoti’yuṅwa, sen tapkiqwniqata, sen tōkilnasaveqniqata, sen kowāko tȫtöqw pahsatniqata, sen talavayniqata. ");
INSERT INTO hopNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Taq nāphisat sen pam suptuqw, uma tokk̇aṅw put ahpiy núansaniwyani. ");
INSERT INTO hopNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Noqw nu umumi hiṅqawhqey nu hapi sohsokmuy amumi paṅqawni: Uma tunatyawyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pu’ hapi ura amutsva yūmosanihqat ep nōviwhqat aw lȫs tāla pēti, pu qa pek̇en’oyiwhput pölavikit nȫnösaṅwuqat aw’i. Noqw God awwat mohpeq momṅwit, tutavot tutuqaynayaqamuy amumum hin as Jesus ūnatoynaye’ nīnayaniqey wūwantota. ");
INSERT INTO hopNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nihqe paṅqaqwa: Pay qa nōviwhqat epni, taq k̇a sinom pas qaunáṅwtalawvayani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Noqw Jesus Bethany‐kitsókit ep hakiy tokoplelet tūtuyṅwuqat Simon kīyat ep tunösvoñat aw qatuqw, hak wuhti tataṅpit hihta owat alabaster yan túṅwantiwhqat aṅqw yukiwtaqat aṅ tusaqwihkuyit kwaṅwáhovaqtuqat kūyik̇aṅw ep paki; nihqe tataṅpit yōhaqe, Jesus qötöyat aw wihkuyit wihta. Pam wihkuyi nard yan túṅwantiwa; noqw pam a’nö hihk̇ay’ta. ");
INSERT INTO hopNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Noqw haqawat pep yesqam itsívutotiqe, unaṅwpeq paṅqaqwa: Ya hinoqw i’ wihkuyi paysoq hovalniwa? ");
INSERT INTO hopNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aṅwu k̇a as pam payhp sunat sīvat epnihqe hóyokiwtaqat ōviy huyiwe’, ōokiwyaqamuy amumi noiwnik̇aṅwo. Noqw puma qayan unaṅway wuhtit aqw hiṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Noqw Jesus paṅqawu: Uma qa aw hiṅqaqwani. Ya uma hinoqw unaṅwmokintota? Pi pam inuhpe lolmat tumalta. ");
INSERT INTO hopNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Uma pi pay ōokiwyaqamuy sutsep oyi’yuṅwa, nihqe uma hisat pan unaṅwtote’, pumuy pāsyamantani. Nīk̇aṅw uma nuy qa sutsep tavi’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Pay pam hihta aw nuhtsaknihqey tumalta; pam hisat nuy āmiwniqat aw aṅwu pay wihkuyit akw itokoy lelwiniqe pitu. ");
INSERT INTO hopNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pas antsa nu umumi paṅqawni: Tūwaqatsit aṅ ahsupoq haqam i’ lomatuawi yuaatiwhq, pep i’ wuhti hinhtiqat pam yuaatiwmantani. Sinom it akw put u’ni’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Noqw Judas Iscariot, pakwt löq sihk̇ay’taqamuy amumum tōnawtaqa God awwat mohpeq momṅwituy amumi Jesus mātapniqe pumuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Noqw puma put nanaptaqe hahlayhtotiqe, put sīvat maqayaniqey aw paṅqaqwa. Noqw pam hisat nukwáṅ’ewhtiqw pumuy amumi put mātapniqey qeni’hevi’ta. ");
INSERT INTO hopNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Noqw qa pek̇en’oyiwhput pölavikit ep nōviwhqat ep sūs talni’taqw, ura ep hapi sinom amutsva yūmosanihqat ep mañat nīnayaṅwuniqw, Jesus aw nánatuwnayaqam put aw paṅqaqwa: Ya itam haqam hihta aw hintsatsnaqw, um pep ura amutsva yūmosanihqat ep nōviwhqat nösniqey nāwakna? ");
INSERT INTO hopNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Noqw pam lȫqmuy put aw nánatuwnaqamuy pahpiy ayataqe amumi paṅqawu: Uma kīmini; nen hak tāqa kuysivut akw kūyi’k̇aṅw umuhsawvaqw uma aṅkni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nen ason pam haqami pakiqw, uma pep ki’taqat aw paṅqawni: Tutuqaynaqa yan lavayhti: Ya um haqam yeyespi’ta? Nu as pep inumi nánatuwnayaqamuy amumum ura amutsva yūmosanihqat ep nōviwhqat nösni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Noqw pam tupatsveq wukoahpave pās himu pasiwtaqat umuy āawnani. Pepeq uma itamuṅem hihta aw hintsanni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Noqw put aw nánatuwnaqam paṅqw ahpiynihqe, kīve pítuhqe, pam hin pumuy amumi lavayhtiqat pan yori; nihqe amutsva yūmosanihqat ep nōviwhqat aw hintsana. ");
INSERT INTO hopNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Noqw tapkiqw, Jesus pakwt löq sihk̇ay’taqamuy amumum paṅsoo. ");
INSERT INTO hopNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Noqw puma aw yesk̇ahk̇aṅw nōnovaqw, Jesus paṅqawu: Pas antsa nu umumi paṅqawni: Uma haqawa inumum tūmoytaqa momṅwituy amumi nuy mātapni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Noqw pahsat puma qahahlayhtotiqe, nanāp put aw paṅqaqwa: Ya nūu? Pu piw suhk̇a paṅqawṅwu: Ya nūu? ");
INSERT INTO hopNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Noqw pam lavayhtiqe amumi paṅqawu: Pay pakwt löq sihk̇ay’taqamuy amuṅaqw haqawa inumum novaoyit aqw morstoynaqani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pi Sinot Tiat hin pey’taqat pas kurs hin nu qa yep qatsit aṅqw ahpiyni. Noqw pay i’ hak momṅwituy amumi Sinot Tiyat mātapniqat eṅem pas is óhini. Pay pi as tatam pam qa tihtiwhq, pam put eṅem lolmani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Noqw pumuy nōnovaqw, Jesus pölavikit kwusut, put ep hahlayhtit, yōṅoyhtat, pumuy put huytat paṅqawu: Huvam it ömahtote’, nȫnösaa; i’ hapi itoko. ");
INSERT INTO hopNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pu pam kuyapkuyit kwusut, put ep hahlayhtit, pumuy amumi put tavi. Noqw puma sohsoyam put aṅqw hikwya. ");
INSERT INTO hopNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Pu pam amumi paṅqawu: I’ hapi iuṅwa k̇aysiwhqamuy amuṅem munvaniwhqa, amuṅem pūhut pasiwnaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Pas antsa nu umumi paṅqawni: Pas nu soon yep qatsit ep ovauyit aniwniyat aṅqw hikwni. Nīk̇aṅw hisat God moṅwtunatyayat aw pituqw, pep pu’ nu puhuovavalat aṅqw hikwni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pu puma tayawinpit tawlalwat, paṅqw haqami tsomot Olivet awya. ");
INSERT INTO hopNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Noqw Jesus pumuy amumi paṅqawu: Pu’ mihikq hapi uma sohsoyam inutsviy unaṅwso’ni; pi ura pan pey’ta: Nu kanelmuy amumi tunatyawtaqat nīnani. Noqw kanēlom ahtsavalani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nīk̇aṅw ason nu ahoy tātayniwe’, aṅwu pay umuhsavo Galileet aqwni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Noqw Peter put aw paṅqawu: Pay as pi nāmahin sohsoyam unaṅwso’niqw, pay nu’ pas soon panhtini. ");
INSERT INTO hopNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Noqw Jesus put aw paṅqawu: Pas antsa nu ūmi paṅqawni: Pay pu’ it tālat ep mihikq, nāt taqakowāko qa lȫs töqtiqw, um nuy qa tuwi’taqey pāyis paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Noqw pahsat pu pam pas öqalat paṅqawu: Pay nāmahin pi as kurs nu umum moknik̇aṅw, pay nu uṅ qa tuwi’taqey pas soon paṅqawni. Noqw puma sohsoyam put an lavayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pu puma haqami Gethsemane yan túṅwantiwhqat aw öki. Noqw Jesus put aw nánatuwnayaqamuy amumi paṅqawu: Uma hāk inuhsavo yep yesq, nu nāwaknani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pu pam Peter‐nit, pu James‐nit, pu John pumuy pahpiy tsamhqe, pahsat pu suyhtsepṅwat qahahlay’iwmaqe hin unaṅwti. ");
INSERT INTO hopNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nihqe amumi paṅqawu: Nu hapi sumataq mokni; pas iunaṅwa qahahlayi. Uma hāk yepye’, tunatyawyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pu pam ahpiy hihin yūmonit, tutskwami nātuvat, pep okiwlawu; nihqe kurs pay hin pasiwtaniqw, i’ tuwani put ahpiy ruhpakniqat nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nihqe paṅqawu: Abba, Inaa, pay uṅniqw sohsoy himu pasiwta. Um as it k̇ānavotpit inuhpiy ayo yúkuni. Nīk̇aṅw pay qa nuy hin nāwaknaniqw, pantani; pay uhtunatyay antani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pu pam amuminihqe, pumuy tokqamuy túwahqe, Peter aw paṅqawu: Simon, ya um pūwi? Ya pas um soon tāwat aṅqe’ sūs qöniltiqat pahsavo tunatyawtani? ");
INSERT INTO hopNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Uma tunatyawk̇ahk̇aṅw nānawaknani, taq nāp hisat sen uma ūnatiwyani. Pay as hakiy tunatyaat pas antsa su’qawta; noqw pay tokoat nuksiwa. ");
INSERT INTO hopNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pu pam ahpiynihqe nāwaknaqe, pay piw án lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pu pam ahoy amuminihqe, pay piw pumuy tokqamuy tuwa; puma pi puwmaṅw’iwyuṅwa. Noqw puma kurs put aw hiṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pu pam pāyisni’mak̇aṅw pítuhqe, amumi paṅqawu: Pay pi uma tōke’, nānasuṅwnani. Hapí, tuwanit aw pitu. Meh, nu’ Sinot Tiat hapi qaanhinwisqamuy öqalayamuy aw mātaviwa. ");
INSERT INTO hopNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Huvam hoṅvaa, itam awyani. Meh, nuy momṅwituy amumi mātapniqa pew pituto. ");
INSERT INTO hopNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Noqw pam nāt yuaataqw, Judas imuy pakwt löq sihk̇ay’taqamuy amuṅaqw suhk̇a pitu. Noqw sinom qaan’ewakw hintaqam sipwuvahpi’k̇ahk̇aṅw, pu murikhoy’k̇ahk̇aṅw put amum öki, God awwat mohpeq momṅwit‐niqw pu sinmuy amuṅaqw wukw’a’yam pumuy ayatotaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Noqw i’ pumuy amumi put mātapniqa amumi hihta tuwantaqe paṅqawu: Nu hapi hakiy tsohtsonaqw, pamni. Uma put ṅuaye’, pās aw tunatyawk̇ahk̇aṅw wikyani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nihqe ōviy panis pam ep pitut, pay yūmosa Jesus awnihqe, aw paṅqawu: Tutuqaynaqa, Tutuqaynaqa, kitat put tsohtsona. ");
INSERT INTO hopNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pahsat pu puma put aw may’yuṅqe put ṅuaya. ");
INSERT INTO hopNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Noqw pumuy pep hoṅqamuy amuṅaqw haqawa sipwuvahpiy hóroknaqe, God awwat mohpeq moṅwit tūwikiyat sáviknaqe, naqvuyat ayo tuku. ");
INSERT INTO hopNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Noqw Jesus lavayhtiqe, sinmuy amumi paṅqawu: Ya uma hakiy uyiṅwut ehpewi aṅqaqwyaqe, ōviy pas piw sipwuvahpi’k̇ahk̇aṅw murikhoy’k̇ahk̇aṅw nuy wik‐wisa? ");
INSERT INTO hopNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Himu nu nāqavo God kīyat ep umumum hinnumk̇aṅw tūtutuqaynaqw, uma nuy qa ṅuaya. Noqw pay sam pi tutuveni soon qa antani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Noqw put aw nánatuwnayaqam sohsoyam put tatamhtotat watqa. ");
INSERT INTO hopNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Noqw hak tiyo qa yuwsi’k̇aṅw tusaqtontsatsakmötsaput usk̇aṅw put aṅkniqw, tōtim put ṅuaya. ");
INSERT INTO hopNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Noqw pam usimniy ayo tūvat, qa yuwsi’k̇aṅw amuṅaqw wāya. ");
INSERT INTO hopNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Noqw solāwam God awwat susmohpeq moṅwit kīyat aw Jesus wikya. Noqw ima God awwat mohpeq momṅwit‐niqw, pu wukw’a’yat‐niqw, pu tutavot tutuqaynayaqam sohsoyam pep tsovawta. ");
INSERT INTO hopNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Noqw Peter yāvaqw Jesus aṅk hinmak̇aṅw, God awwat mohpeq moṅwit kīyat ihpoviyat aw pahsavo pitu; nihqe tumal’a’yatuy amumum qatuk̇aṅw, qȫhit aw nāmukinta. ");
INSERT INTO hopNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Noqw God awwat mohpeq moṅwi, sohsokmuy pep tsovawtaqamuy amumum as Jesus nīnayaniqey ōviy hakiy hihta qalolmat put nēveltoynaniqat heptotat, qa hakiy tutwa. ");
INSERT INTO hopNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pay as pi k̇aysiwhqam put hīhihta atsátoynayaqw, pumuy lavayiam qa sunyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Noqw haqawat wunuptuqe, put hihta atsátoynaqe, paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Itam it aw tūqaytaqw paṅqawu: Nu it God kīyat sinmuy māyamuy akw yukiwhqat sahpuknat, sukwat pas qa sinmuy māyamuy akw yukiwhqat pāyis tālat aṅ kītani, kita. ");
INSERT INTO hopNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Noqw pay piw pumuy lavayiam qa súnanta. ");
INSERT INTO hopNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pahsat pu God awwat mohpeq moṅwi pumuy amuhsonve wunuptut, Jesus tūviṅtaqe aw paṅqawu: Ya pay um qa hiṅqawni? Ya ima hihta uhpewi yuaata? ");
INSERT INTO hopNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Noqw pam qa hiṅqawhqe, pay amumi qa hinwat lavayhti. Noqw pu piw God awwat mohpeq moṅwi put tūviṅtaqe aw paṅqawu: Ya pas pay um Christ, Tayawintiwhqat Tíata? ");
INSERT INTO hopNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Noqw Jesus put aw paṅqawu: Nu’ pam’i. Pay nāt nu’ Sinot Tiat Sus’öqaltutuyqawhqat putvaqe qátuk̇aṅw tokpelat ep ōomawhtuy akw hawtoqw, uma inumi yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pahsat pu God awwat mohpeq moṅwi itsívutiqe, yuwsiy tsīk̇at paṅqawu: Ya hinoqw pas piw nāt hakim put ehpewi hiṅqaqwani? ");
INSERT INTO hopNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pi uma qak̇aptsi’lavayiyat aw tūqayyuṅwa. Uma hin wūwantota? Noqw puma sohsoyam put mokiwuy hihk̇ay’taqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pahsat pu haqawat put aw töhtivaya, piw put taywayat nākwapnayaqe, may pölölni’k̇ahk̇aṅw akw put wuvahtivayaqe, aw paṅqaqwa: Kurs hákiynihqat paṅqawuu! Pu ima tumal’a’yat mapqölöy akw put wuvalalwa. ");
INSERT INTO hopNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Noqw Peter pep moṅwkit ihpoviyat epniqw, haqawa God awwat mohpeq moṅwit tumal’aymuyatuy mámanhtuy amuṅaqw pítuhqe, ");
INSERT INTO hopNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peter nāmukintaqw túwahqe, aw taynumt, paṅqawu: Um pi piw it Jesus Nazareth aṅqw sinot ámuma. ");
INSERT INTO hopNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Noqw pam qa nakwhaqe paṅqawu: Nu put qa tuwi’ta; piw um hiṅqawhq nu qa māmatsi. Nit pam yámakqe, hötsíwat aw wunuqw, taqakowāko töqti. ");
INSERT INTO hopNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Noqw māna piw put túwahqe, pahsat pep hoṅqamuy amumi paṅqawu: I’ pi pumuy amumuma. ");
INSERT INTO hopNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Noqw piw pam qa nakwha. Pu hihin hihsavoniqw, ima pep hoṅqam piw Peter aw paṅqaqwa: Pay um pas antsa pumuy amumum hinnuma. Um pi Galilee‐sino; ōviy pi uhlavayi panta. ");
INSERT INTO hopNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Noqw pahsat pu pam God atpip amumi pas qa atsátaniqey amumi paṅqawu; nihqe pas öqalat paṅqawu: Pay nu pas umuy hakiy yuaatotaqat qa tuwi’ta. ");
INSERT INTO hopNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Noqw pahsat pay taqakowāko piw töqti; noqw pahsat pu Peter Jesus put aw hin lavayhtiqat u’na; ura pam paṅqawu: Nāt taqakowāko qa lȫs töqtiqw, um nuy qa tuwi’taqey pāyis paṅqawni, ura kita. Noqw pam put aṅ wūwaqe, pahsat paklawu. ");
INSERT INTO hopNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pu panis tālawvaqw, pay ima God awwat mohpeq momṅwit, pu wukw’a’yat‐nik̇aṅw pu tutavot tutuqaynayaqam wuwan’a’yatuy sohsokmuy amumum hin hintaniqat yuaaykuyaqe, Jesus somyat, ahpiy wikyaqe, pep tutskwat aw moṅwi, Pilate yan mātsiwhqat, aw put noaya. ");
INSERT INTO hopNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Noqw Pilate put tūviṅtaqe aw paṅqawu: Ya um Jew‐sinmuy moṅwíamu? Noqw pam hu’waqe aw paṅqawu: Um súaṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Noqw God awwat mohpeq momṅwit put hīhihta nēveltotoynayaqw, pam qa hiṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Noqw Pilate piw put tūviṅtaqe aw paṅqawu: Ya pay um pas qa hiṅqawni? Meh, ima hīhihta uhpewi yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Noqw piw nāt Jesus qa hiṅqawu. Noqw ōviy Pilate hin kurs wūwa. ");
INSERT INTO hopNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Noqw put nōviwhqat ep pi pam hakiy sivilawhqat hihtawat nuhtumi mātapṅwu, pumuy hakiy nānawaknaqw put’a. ");
INSERT INTO hopNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Noqw hak tāqa Barabbas yan mātsiwhqa pētuy amumum sivikit ep sómiwta. Ura puma put amum moṅwit ehpewi hoṅva; nihqe panhtotiqe hakiy nīnaya. ");
INSERT INTO hopNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Noqw sinom qaan’ewakw hintaqam Pilate aw sa’taqe, pam hin yúkuṅwuqey pan piw amuṅem hinhtiniqat ö’qalya. ");
INSERT INTO hopNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Noqw Pilate lavayhtiqe amumi paṅqawu: Noqw ya nu Jew‐sinmuy moṅwíyamuy amumi mātapniqat uma nānawakna? ");
INSERT INTO hopNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Suyan pi God awwat mohpeq momṅwit qatsutsúyyaqe ōviy put aw Jesus noayaqw, pam mātsi’taqe ōviy paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Noqw God awwat mohpeq momṅwit sinmuy pan unaṅwtoynaya, as pam Barabbas pumuy amumi mātapniqata. ");
INSERT INTO hopNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Noqw Pilate lavayhtiqe piw amumi paṅqawu: Noqw ya nu it umuhpiy Jew‐sinmuy moṅwíyamuy yan túṅwantiwhqat hintsanni? Ya uma hin nānawakna? ");
INSERT INTO hopNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Noqw puma piw sáakmaqe aw paṅqaqwa: Nahoylehtsit aw múaa! ");
INSERT INTO hopNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pahsat pu Pilate amumi paṅqawu: Ya hínoqö’? Pam hihta qalomáhinhtiqw ōviy’o? Noqw pahsat puma tis pas pavan sáakmaqe paṅqaqwa: Nahoylehtsit aw múaa! ");
INSERT INTO hopNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Noqw Pilate sinmuy pas pay unaṅwveniqe, pumuy Barabbas mātapt, Jesus wuvahtiwniqat paṅqawht, nahoylehtsit aw muiwniqat ōviy solāwamuy amumi put mātavi. ");
INSERT INTO hopNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Noqw solāwam pavasiwhkit Pretorium yan túṅwantiwhqat aw put wikyaqe, suṅwámuy sohsokmuy sūmi tsovalaya. ");
INSERT INTO hopNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pu puma put palasakwat usimnit usihtoynayat, hihta kūtay’taqat kwitetotaqe, put qötösomtoynaya. ");
INSERT INTO hopNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nit pahsat pu put pas hihtalalwaqe, paṅqaqwa: Öqawmaṅwu, Jew‐sinmuy moṅwíamu! ");
INSERT INTO hopNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pu puma hopaqat akw put qötöyat wuvalalwak̇ahk̇aṅw, aw töhtota; pu aw tamötshoṅvank̇ahk̇aṅw, put pas hihtalalwa. ");
INSERT INTO hopNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pu ōviy puma put aw tututsiwyaqey yukuyaqe, palasakwat usimnit oyanayat, pu pas nāp yuwsiyat put yuwsinaya, nit nahoylehtsit aw put muayaniqe ahpiy wikya. ");
INSERT INTO hopNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Noqw hak Cyrene‐tutskwat aṅqw tāqa, Simon yan mātsiwhqa, hakimuy Alexander‐nik̇aṅw, pu Rufus pumuy naam, haqaqw pitutoqe paṅqee. Noqw pam Jesus nahoylehtsiyat eṅem īkwiwtaniqat solāwam put tusoq’ayatota. ");
INSERT INTO hopNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Noqw puma haqami Golgothat aw Jesus wikya; pam Masqötvihk̇a i’nihqe pam’i. ");
INSERT INTO hopNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Noqw puma wine hihta a’nö sik̇at enaṅ namiqwriwtaqat put hikwnayaniqw, pam qa nakwha. ");
INSERT INTO hopNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pu puma put nahoylehtsit aw muayaqe, yuwsiyat nāhoy o’ya, put ōviy nanavö’yak̇ahk̇aṅwo, mātaqpi hak hihtawatmantaniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wukotöṅvaniwtaqw‐haqam puma nahoylehtsit aw put muaya. ");
INSERT INTO hopNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Noqw pam hihta nēveltoyniwhq, pam put atsva pēniwa; nihqe yan pey’ta: JEW‐SINMUY MOṄWIAMU. ");
INSERT INTO hopNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Noqw puma piw hakimuy lȫqmuy uyiṅwutuy put ahsaq nīnaya, nānap nahoylehtsit aw muayaqee, suhk̇awa put putvaqeniqw pu suk̇awa put suyvaqee. ");
INSERT INTO hopNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Noqw pep pu’ tutuvenit an hiniwhti, ura yan pey’ta: Pam qaanhtotiqamuy amumum pohtoylaniwa, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Noqw ima aṅ sasqayaqam aw tututsiwyaqe, qötöy wīlank̇ahk̇aṅw paṅqaqwa: Hē! um God kīyat sahpuknat pāyis tālat aṅ aw kītaniqey tuwi’taqa, ");
INSERT INTO hopNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ayo nātave’, nahoylehtsit aṅqw hāwii. ");
INSERT INTO hopNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Noqw God awwat mohpeq momṅwit piw amún put aw tututsiwyaqe, tutavot tutuqaynayaqamuy amumum nānami paṅqaqwa: Pas as pam ayo tūooyk̇aṅw, kurs hin ayo nātapni. ");
INSERT INTO hopNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Pay pas Christ Israel‐sinmuy moṅwíamnen nahoylehtsit aṅqw hawni, noqw itam aw tāyuṅwe’ tūtuptsiwani. Noqw ima put amum nahoylehtsit aw muiltiqam put aw tutsíwhiṅqawlawu. ");
INSERT INTO hopNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Noqw tāwanasaptiqw ahsupoq tūwaqatsit aṅ qatālawva, tāwat atvelpetiqw pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Noqw tāwat atvelpetiqw, Jesus a’nö paṅqawu: Eloi, Eloi, lama sabachthani. Pam God, Itutuyqawhqa, ya um hinoqw nuy tatamhta? i’nihqe pam’i. ");
INSERT INTO hopNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Noqw haqawat pep hoṅqam nanaptaqe paṅqaqwa: Meh, taq pi pam Elias wáṅwaylawu. ");
INSERT INTO hopNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Noqw haqawa wárikqe, hihta söyatkoy’taqat (sponge) vinegar aqw móroknat, hopaqat epeq söṅnat, put hikwna paṅqawk̇aṅwo: Pay pantani; mātaqpi kurs Elias aṅqwnen put hawnani. ");
INSERT INTO hopNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Noqw Jesus a’nö hiṅqawht, sohsok hikwsu. ");
INSERT INTO hopNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Noqw God kīyat ep mötsáp’uutspi ōṅaqw atk̇amiq nāhoy tsīki. ");
INSERT INTO hopNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Noqw solāwamoṅwi Jesus ayaṅqwat aw wúnuhqa put pan hiṅqawht, sohsok hikwsuqw yórikqe paṅqawu: Pay kurs pas antsa i’ tāqa God Tíata. ");
INSERT INTO hopNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Noqw hakim momoyam piw yāvaq tāyuṅwa. Noqw ima nuhtumya‐i’ Mary Magdalene, pu Mary hakiy James tsaywatnihqat‐nik̇aṅw pu Joses, pumuy yúamu, noqw pu Salome. ");
INSERT INTO hopNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ura as Jesus Galilee‐tutskwat ep hinnumqw, ima momoyam put aṅk hinnumyaqe, put tumalay’yuṅwa. Pu piw wūhaqnihqam momoyam put amum Jerusalem aqwyaqam pep hōñi. ");
INSERT INTO hopNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Noqw nasuṅwintalöṅnit totok̇ayat ep tapkiqw, ");
INSERT INTO hopNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Hak tāqa Arimathea‐kitsókit aṅqwnihqa, Joseph yan mātsiwhqa, ep pítuhqe, qa tuhtusk̇aṅw Pilate aw pákihqe, Jesus tokoyat tuhtui. Pam hak wuwan’aya k̇aptsiwtaqa, nuhtum God moṅwtunatyayat nuhtayta. ");
INSERT INTO hopNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Noqw pay sen Jesus mokqat Pilate wūwaqe, solāwamoṅwit wáṅwayhqe, put tūviṅta. ");
INSERT INTO hopNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nihqe yaw put pay mokqat pam solāwamoṅwit aṅqw navotqe, pahsat put tokoyat Joseph maqa. ");
INSERT INTO hopNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Noqw pam suphiṅput tusaqtontsatsakwmötsaput tui; nit Jesus tokoyat hawnaqe, put akw put mok̇ahta; nit owat ep tuamhqölö tuhsöiwtaqat aqw put panat, hötsiwmiq owat mūma. ");
INSERT INTO hopNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Noqw Mary Magdalene‐niqw, pu Joses yuat Mary, puma haqam put taviwhqat aw yori. ");
INSERT INTO hopNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pu nasuṅwintalöṅnit aṅ ayo ruhpakq, Mary Magdalene‐niqw, pu James yuat Mary‐niqw, pu Salome, puma hīhihta kwaṅwáhovaqtuqat tuiya, tūamit awye’, put akw Jesus lelwiyaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pu ōviy Sundayt aw pituqw, puma suits talavay tāwat yámaktoqw tūamit aw ökiwisa. ");
INSERT INTO hopNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nihqe nānami paṅqawwisa: Ya sen hak itamuṅem tūamit hötsíwat aṅqw ayo owat mūmani? ");
INSERT INTO hopNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nit puma aw yórikyaqw, kurs owa pay ayo mūmaniwa, pas pi qaan’eway yahsayoq’a. ");
INSERT INTO hopNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Noqw puma tūamit aqw yuṅqw, kurs hak tiyo wūpat qȫtsat yuwsi’k̇aṅw put putvaqe qatu. Noqw puma put tutwaqe pas tsātsawna. ");
INSERT INTO hopNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Noqw pam hak pumuy amumi paṅqawu: Uma qa tsawiniwyuṅwni. Pay uma as Jesus Nazareth aṅqw sino nahoylehtsit ep muiltiqat hepwisa. Pam ahoy tātayi, pam qa yep’e. Kurs huvam haqam pam taviwhqat aw yórikyaa. ");
INSERT INTO hopNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Noqw yupave, uma put aw nánatuwnayaqamuy‐nik̇aṅw pu Peter, pumuy amumi yan tuawwisni: Pam umuhsavo Galilee aqwni. Ason pep uma put aw yórikyani. Pay ura umumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Noqw puma paṅqw nöṅaṅayku; nihqe hin unaṅwtotiqe, tururuti’k̇ahk̇aṅw watqa. Pas pi puma tsawiniwyuṅqe, ōviy qa hakiy haqam aw hiṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Noqw Sundayt aw pituqw, suits talavay Jesus ahoy tātayhqe, mohti Mary Magdalene aw namtakna. Ura pam put aṅqw tsaṅe’ nukpanhihikwsimuy ipwa. ");
INSERT INTO hopNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Noqw pam ahpiynihqe, Jesus ámumyaṅwuqamuy put āawna, pumuy qahahlayyak̇ahk̇aṅw tsaykitaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Noqw yaw pam piw qátuhqe, pu Maryt aw namtaknaqat puma nanaptak̇aṅw qa tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pantaqat atsve pu’ pumuy amuṅaqw haqawat lȫyöm haqami tutskwamiq waymaqw, pam piw pas hinwat hink̇aṅw pumuy amumi namtakna. ");
INSERT INTO hopNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Noqw puma ahoy kīminihqe, mímuywatuy put āawna. Noqw pay piw puma pumuy lavayiyamuy qa tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pantaqat atsva pu’ pakwt sūkw sihk̇ay’taqamuy nōnovaqw, Jesus amumi namtaknaqe, pumuy qatūtuptsiwaqat, pu a’nö unaṅwayamuy ep qöhqöya, puma put ahoy tātayhqat aw yórikyaqamuy lavayiyamuy qa tūtuptsiwaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pu pam pumuy amumi paṅqawu: Uma tūwaqatsit aṅ ahsupoq nankwusani. Pu uma sohsokmuy sinmuy amumi lomatuawit yuaatotani. ");
INSERT INTO hopNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lomatuawit qa tuptsiwhqa hapi maskimiq tūviwtaniqw, pam put eṅem yukiwni. Nīkaṅw tuptsiwht, kūyit akw tuvoylatiqa hapi ayo yámakiwtani. ");
INSERT INTO hopNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Pu īi himu tuawi’yuṅqa aṅ tuptsiwni’yuṅqamuy amumi énaṅhtini: Puma inatṅwaniy aw yank̇ahk̇aṅw nukpanhihikwsimuy nuhtuṅaqw ipwanwisni; pu piw himuhkwa yuaatotani. ");
INSERT INTO hopNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kurs puma tsūtsu’tuy ṅuaye’, pu sen kurs puma hihta qöyanpit hikwye’, pas soon put akw hinhtotini. Puma tūtuyyaqamuy amumi hintsatsnaqw, puma qalaptuyamantani. ");
INSERT INTO hopNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Noqw Tutuyqawhqa pumuy amumi yan yuaaykut, ōmi wīkiwa; nihqe God putvaqe qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Noqw puma paṅqw nankwusaqe, sohsovik yuaatinumyaqw, Tutuyqawhqa pumuy amumum tumalay’k̇aṅw, k̇ātatayhpit hihta tuawi’taqat akw lavayit öqalanma. Yantani.");
INSERT INTO hopNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Pas as k̇aysiwhqam itamuhpa’ hihta hiniwhtiqat pās oyiwtaqat pēnayaniqey tuwantota. ");
INSERT INTO hopNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ima hakim aṅ ahsupoq Jesus hihta hintsakmaqat aw yórikyat, lomatuawit yuaatotaqam itamumi hin mātapyaqat pan put pēnayaniqey aw may’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Noqw ōviy nu put yayhniwhpuyat aṅqaqw sohsok hihta aṅ pās puprikqe, put pās pasiwtaqat ūmi pēnaniqey unaṅwti, um hak pavan Theophilus. ");
INSERT INTO hopNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Noqw pep pu’ sohsoy himu ūmi mātaviwhqa pas antsanihqat um pas suyan navoti’tani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hakiy Herod tutskwat Judeat ep moṅw’iwtaqw, hak God awwat moṅwi, Zacharias yan mātsiwhqa qatu, hakiy Abiat paptsiyat ep nuhtum wúnuhqa. Noqw put nȫmaat Elizabeth yan mātsiwhqa piw hakiy Aaron ahpiyvi. ");
INSERT INTO hopNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Puma nāma God atpip súank̇aṅw, Tutuyqawhqat hin lavayyukuhqat pu hin tutaptaqat aṅ ahsupoq qaöwíhinma. ");
INSERT INTO hopNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nīk̇aṅw puma qa ti’ta, Elizabeth qa tílawhq ōviy’o. Noqw puma nāma pāpu pas wuyoiwta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Noqw ephaqam i’ Zacharias suṅwámuy amumum God kīyat ep tumalay’taniqat aw pitsíwta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Noqw puma hin hinhtotiniqe hihta akw tuwantotaqe, pan tumalat nāhuyvaya. Noqw Zacharias God kīyat ep put eṅem hihta kwaṅwáhovaqtuqat taqtsokniqw pan put eṅem yukiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Noqw pam panhtiniqat aw pituqw, sinom sohsoyam ihk̇aqe hoṅk̇ahk̇anw, God aw nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Noqw pam paṅso pakiqw, Tutuyqawhqat hoṅviayaat put aw mātakti; pam kwaṅwáhovaqtuqat eṅem qöqöhpit putvaqe wunuwta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Noqw Zacharias put túwahqe, pas tsawnaqe, hin unaṅwti. ");
INSERT INTO hopNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Noqw hoṅviaya put aw paṅqawu: Um qa tsawnani, Zacharias. God uhnawakinpiy navota. Noqw ōviy uhwuhti Elizabeth uṅem tiyohyat tihtani. Noqw ason um put John yan túṅwani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Um put tihtiwhqat ep pas hinhaqam hahlayhtini; noqw k̇aysiwhqam umum hahlayhtotini. ");
INSERT INTO hopNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pi pam Tutuyqawhqat atpip a’nö hímuni. Nihqe ōviy pam ovavalat, pu honaqkuyit qa hīhikwni. Pi pas pam tihtiwhpuy aṅqaqw Qahováriwtaqat Hikwsit akw tuyqawiwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pam Israel‐sinmuy amumi ö’qalaqw, puma ahoy Tutuyqawhqay God aw nánamtök̇ani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pam Elias antani, numiy aṅ’a, pu öqalay aṅ’a. Nihqe pam Tutuyqawhqat ahsavo hinmaqw, namat timuy amumi unaṅway’vayani; noqw aṅ qatuqáyvahsi’yuṅqam súanhinwisqamuy amún súan unaṅwtalwuwni’vaye’, súanhinwisni. Noqw pam Tutuyqawhqat ahsavo put sinomuyatuy unaṅwayamuy put eṅem moṅwvastani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Noqw Zacharias hoṅviayat aw paṅqawu: Noqw nu hin uṅ súaṅqawhqat navoti’tani? Pi nu’ wuhtaqa, pu iwuhti pāpu pas wuyoiwta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Noqw hoṅviaya lavayhtiqe put aw paṅqawu: Nu Gabriel yan mātsiwa; noqw nu God atpip wunu. Noqw nu it lomatuawit uṅ āawnaniqat ōviy pam nuy aṅqw ūmi ayata. ");
INSERT INTO hopNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Noqw meh, um hapi ilavayiy qa tuptsiwa. Noqw ōviy uhlavayi nawus ūṅaqw nawhkiwhq, kurs um hin yuaatani, pas hisat ilavayiy aw antsaniwhqat aw pahsavoo. Noqw hisat aw pituqw, God ilavayiy aw antsanni. ");
INSERT INTO hopNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Noqw sinom Zacharias nuhtayyuṅwa. Hinoqw pam God kīyat ep pas nawutsnaqw, puma put ep hin wūwantota. ");
INSERT INTO hopNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Noqw pam yāmakqe, pay kurs hin pumuy amumi hiṅqawni. Noqw puma māmatsyaqw, sumataq pam God kīyat ep hihta aw yori; ōviy pi pam amumi māsank̇aṅw, pay pas qa hiṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Noqw ōviy pam panis paptsiy aṅ kuyvat, pahsat pay nima. ");
INSERT INTO hopNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Noqw ahpiy pantaqw, put nȫmaat Elizabeth nö’yiltiqe, tsivot mūmuyawhtuy aṅ haqam nātupki’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nihqe paṅqawu: Yanhaqam Tutuyqawhqa nuy hintsana, nuy ōkwatuwhqee. Nu as qa tiylawhq ōviy sinom as inumi tutsíwhiṅqaqwaqw, askwal pi God put pantaqat aṅqw nuy ayo tavi. ");
INSERT INTO hopNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Noqw navay mūmuyawhtuy súlawhtiqw, God hoṅviayay Gabriel Galilee‐tutskwat ep haqami kitsókit Nazareth yan mātsiwhqat aw ayata, ");
INSERT INTO hopNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hakiy mānat nāt qanāhovalni’taqat Mary yan mātsiwhqat aw’i. Pam hak hakiy tāqat Joseph yan mātsiwhqat, David ahpiyvit aw noiwniqat eṅem nawiniwta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Noqw hoṅviaya put aw pákihqe, aw paṅqawu: Um hahlayni, Tutuyqawhqa úmuma. Pam núokway ūmi pas qaöwínoa. Um momoymuy amuṅaqw pas hahlayhpit ep’e. ");
INSERT INTO hopNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Noqw Mary put aw yórikqe, lavayiyat ep hin kurs wūwa; nihqe hihta pa pam lavayhtiqat pam wūwanta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Noqw hoṅviaya put aw paṅqawu: Pay um qa tsawiniwtani Mary, God núokway ūmi pas qaöwínoa. ");
INSERT INTO hopNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Noqw meh, um nö’yilte’, tiyohyat tihtani. Nen um put Jesus yan túṅwani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pam a’nö hímuni; pu Pas Sus’oveqnihqat Tíatnihqey yan túṅwantiwni. Noqw Tutuyqawhqa God put nayat David moṅqeniyat put máqani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Noqw pam Jacob ahpiy sinoiwtaqamuy amumi sutsep moṅw’iwtani. Pu put moṅwtunatyaat pas qa haqami so’tani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Pahsat pu Mary hoṅviayat aw paṅqawu: Noqw hin i’ pasiwtani. Pi nu qa hisat haqam hakiy tāqat ámuma. ");
INSERT INTO hopNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Noqw hoṅviaya lavayhtiqe put aw paṅqawu: Pay ason Qahováriwtaqa Hikwsi ūmi pítuni; pu Sus’oveqnihqa öqalay akw uṅ nākwapnani. Paniqw ōviy ason pam tsāy qahováriwtaqa uhpiy tihtiwniqa God Tíatniqey yan túṅwantiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Noqw meh, ūṅaqwvi Elizabeth as qa tílawhqat paṅqaqwaṅwuqw, pam wuyovehaq nö’yilti. Noqw pu’ hapi pam navay mūmuyawhtuy aṅ panta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pi God‐niqw pay qa himu qa pasiwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pahsat pu Mary paṅqawu: Taa, pay pi nu Tutuyqawhqat tūwikiata. Pay nam um hin lavayhtiqw antani. Noqw hoṅviaya put aṅqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Noqw ephaqam Mary paṅqw nakwsuqe, haqami tsotsmoy’yuṅqat aqwhaqami k̇aktayi, Judeat‐tutskwat ep kitsókit aw’i; ");
INSERT INTO hopNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nihqe Zacharias kīyat aw pákihqe, Elizabeth aw yuaayku. ");
INSERT INTO hopNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Noqw Elizabeth Maryt lavayiyat navotq, put ponoveq tiposi tsoomhti. Noqw Elizabeth Qahováriwtaqat Hikwsit akw tuyqawiwk̇aṅw, ");
INSERT INTO hopNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A’nö paṅqawu: Ṅaspi um momoymuy amuṅaqw namorstiwa! Pu uhpiy tihtiwniqa pas hahlayhpit epni. ");
INSERT INTO hopNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Noqw nuy yan’ewayniqw ōviy kurs piw Itutuyqawhqay yuat aṅqaqw inumii? ");
INSERT INTO hopNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Oviy pi meh, panis uhlavayi inaqvumiq töqtiqw, pahsat pay tiposi hahlayhtiqe, ivonoveq tsoomhti. ");
INSERT INTO hopNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Um God aw tuptsiwhqe, pas hahlayhpit ep’e, ispi Tutuyqawhqa ūmi hin lavaytiqey pas kurs hin qa anhtiniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Noqw Mary tuwat paṅqawu: Oviy nu iunaṅṅaqw Tutuyqawhqat pas hihtay’tani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ihikwsiy akw nu God nuy ayo távihqat aw hahlayhtini, ");
INSERT INTO hopNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ispi pam manhtuwikiy okiwhqatsiyat aw tātayhq’ö. Noqw meh, yahpiy haqahpiy yantani: Sohsoyam haqami nānaṅk yesniqam nuy hahlayhpit epnihqat paṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pi pam nuy qaöwítumalta, i’ hak Sus’öqaltutuyqawhqa, Qahováriwtaqa yan túṅwantiwhqa. ");
INSERT INTO hopNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pam put k̇aptsi’yuṅqamuy óokwatuwa, Sohsokmuy hakimuy nānaṅk yesqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Is uti! Pam hinurs öqalay’ta! May akw aṅ kwivi’naṅway’yuṅqamuy tatslakna. Piw pumuy tunatyayamuy sóontsana. ");
INSERT INTO hopNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pam aṅ ö’qaltuy qeniyamuy aṅqw hanna, Nit aṅ ókiwyaqamuy momiq oya. ");
INSERT INTO hopNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pam aṅ tsöṅsoiwtaqamuy hihta nukṅwat öyna, Nit k̇ahaksinmuy súmavuyawyuṅqamuy aṅqe lālayi. ");
INSERT INTO hopNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Pam tumal’ayay Israel aw unaṅwtavi, Itanamuy amumi hin lavayhtiqey hapi panhti. Pam Abraham timuyatuy ōkwatuwa, Pu ahpiy aniwhtotiqamuy sohsokmuyu, Nihqe pam yūmosa panmani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Noqw Mary payhkomuy mūmuyawhtuy aṅ Elizabeth amum qatut, pu ahoy kiy aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Noqw Elizabeth tihtaniqat aw pituqw, pam tiyohyat tihta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Noqw put kisṅwamat, pu sinomat nanaptaqw, yaw Tutuyqawhqa put qa an’ewakw ōkwatuwa. Nihqe puma put amum hahlayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Noqw put nanalsikis talni’taqw, puma tsākw poṅotkuyaniqe öki. Nihqe puma put Zacharias yan tuṅwáya, nayat tuṅwniyat an’i. ");
INSERT INTO hopNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Noqw put yuat paṅqawa: Qae, pam John yan mātsiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Noqw puma put aw paṅqaqwa: Noqw pi qa hak uhsino pan mātsiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pu puma put nayat aw māmasaya, hin pam put túṅwaniqey nāwaknaqat tūviṅtota. ");
INSERT INTO hopNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Noqw pam hihta aṅ pēnaniqey tuhtuy’qe, aṅ pēna: Pam John yan mātsiwa. Noqw puma sohsoyam hin kurs wūwaya. ");
INSERT INTO hopNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Noqw pahsat pay put moaat hötsíltiqw, leñiat ṅāhiwa. Noqw pam yuaaykuqe, God aw hahlayhti. ");
INSERT INTO hopNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Noqw pumuy kisṅwamat pas kurs hin wūwaya. Noqw sohsoyam Judeat ep tsotsmova yesqam pep hin hiniwhtiqat nānami lavayta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Noqw sohsoyam put nanaptaqam unaṅwpeq put wūwank̇ahk̇aṅw paṅqaqwa: Hin pa i’ tsay hintani? Noqw Tutuyqawhqat maat put aw unaṅwtavi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Noqw put naat Zacharias Qahováriwtaqat Hikwsit akw tuyqawiwk̇aṅw, hin hintaniqat lavayhtiqe paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Nam God Israel‐sinmuy Tutuyqawhqaam tayawintiwaa; Pam sinomuy pohtaqe, pumuy qenivo oya. ");
INSERT INTO hopNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pam hakiy a’nö öqalay’taqat wunuptsina, Itamuy ayo ōoyniqata, Tumal’ayay David amuhpiyviyatuy amuṅaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ura pam hisatṅahaqaqw itanamuy amumi pan lavayhti, Hakimuy pas hihtuy lavay’aymuy moayamuy ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Itahtuwqamuy māyamuy aṅqw itamuy ayo óyaniqey paṅqawu, Pu sohsokmuy itamumi qa suhtaq’ewyaqamuy öqalayamuy aṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pam itanamuy amumi núokway mahtakna, Amumi hin lavayhtiqey aw antsana, Amumi pas qa paysoq pasiwnaqey pam u’na. ");
INSERT INTO hopNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ura pam itanay Abraham aw pas qaöwílvayhti; ");
INSERT INTO hopNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Itahtuwqamuy māyamuy aṅqw itamuy ayo óyaniqeyu, Itam qa tsawiniwk̇ahk̇aṅw, put eṅem hintsatsk̇aniqata. ");
INSERT INTO hopNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Noqw itam itahqatsiy aṅ ahsupoq put atpip hinwisni, Sohsok hihta akw pasiwk̇ahk̇aṅw, súank̇ahk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Noqw ūm’i, ítii, ya uṅem hintani? Um Sus’oveqnihqat lavay’ayaatni; Pan hapi um túṅwantiwni. Um Tutuyqawhqat apyeve hinmani; Pu put eṅem pöhut aṅwu aṅ qenitani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Um God sinomuyatuy hin ayo nö́ṅakniqat āawnani; Pumuy qaanhtipuyamuy ayo yukiltiq’ö. God pumuy qaanhtipuyamuy ayo yuk̇e’, pumuy ayo óyani. ");
INSERT INTO hopNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kwakwhat pi God aw itahyantaqa itamuy ōkwatuwa, Kwakwhat pi ōṅaqw itamumi tālawva. ");
INSERT INTO hopNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Qatalpuve yesqamuy amumi tālawnani, Mokiwuy kihsiwniyat aṅ yesqam tālat aw yórikyani. Noqw itam tālat aw tāyuṅwe’, pasi’naṅway’k̇ahk̇aṅw, hinwisni. Yan Zacharias lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Noqw tsāy wūyoq’iwmaqw, tunatyaat suyhtsepṅwat öqawi’ma; nihqe haqam qayēsiwhpuve qatu, hisat pam Israel‐sinmuy amumi namtaknaniqey pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Noqw ephaqam sopk̇awtaqam sinom nāvenayaniqat Caesar Augustus yan tutapta. ");
INSERT INTO hopNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Noqw hak Cyrenius Syria‐tutskwat ep moṅw’iwtaqw, sinom mohti yan nāvenaya. ");
INSERT INTO hopNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Noqw sohsoyam nāvenayaniqe nanāp kitsókiy aṅ nankwusa. ");
INSERT INTO hopNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Noqw ōviy Joseph Galilee‐tutskwat ep Nazareth‐kitsókit aṅqwnihqe, Judea‐tutskwat aqw’a, haqami kitsókit, Bethlehem yan mātsiwhqat aqw’a. Ura David Bethlehem ep tihtiwa. Noqw Joseph David ahpiyvinihqe, ōviy nāvenaniqe paṅsoq’a. ");
INSERT INTO hopNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Noqw Mary put nömamkiwaat put ámuma, pas páy tihtanik̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Noqw pumuy pépeqniqw, pam tihtaniqat aw pitu. ");
INSERT INTO hopNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Noqw pam nāt sūs tihtaqe tiyohyat tihta; nihqe muhpiwṅwat akw muhpiknat, haqaqw tumalvopkot nȫnösaṅwuqat paṅqe’ put tavi, qa haqam yeyespive amuṅem qéniniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Noqw pep tutskwat ep hakim lalay’a’yat haqam tutskwave yesqe, mihikq kanelvokmuy tūtuwala. ");
INSERT INTO hopNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Noqw meh, Tutuyqawhqat hoṅviayaat pumuy amumi mātaktiqw, Tutuyqawhqat lolma tālaṅwaat pumuy ahsupoq amuqlaq tālawva. Noqw pavan pas puma tsawinwuhpukya. ");
INSERT INTO hopNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Noqw hoṅviaya pumuy amumi paṅqawu: Uma qa tsawiniwyuṅwni. Meh, pi nu lomatuawit umuy āawnani; noqw put ep sopk̇awtaqam sinom pas hinhaqam hahlayyani. ");
INSERT INTO hopNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pi pu’ hapi it talöṅvaqat ep David kitsókiyat ep Ayo Tūooyhqa umuṅem tihtiwa, Tutuyqawhqa, Christ, God aṅqw moṅw’asi’taqa. ");
INSERT INTO hopNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Noqw it akw uma put māmatsyani: Tiposit muhpiwṅwat akw muhpiwk̇aṅw haqaqw tumalvopkot nȫnösaṅwuqat aṅqe’ qatsqat uma tutwani. ");
INSERT INTO hopNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Noqw pahsat pay qaan’ewakw hintaqam ōve yesqam kurs hoṅviayat ámumyaqe God tayawintotaqe paṅqaqwa: ");
INSERT INTO hopNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Nam God Sus’oveqnihqa tayawintiwaa; pam pi tūwaqatsit ep sinmuy hahlayk̇aṅw amuṅem yukuqw, puma kwakwhat yesni. ");
INSERT INTO hopNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Noqw hoṅvia’yat tawlalwaqe yukuyat, ahoy ōmiqhaqamiya. Noqw pahsat pu lālayṅwut nānami paṅqaqwa: Taa, tuma kurs Bethlehem awye’, it yan hiniwhtiqat, Tutuyqawhqa itamumi mahtaknaqat aw yórikwisa. ");
INSERT INTO hopNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pu puma paṅso k̇aktayyaqe, ep ö́kihqe, Maryt‐nit pu Joseph pumuy tutwa, pu haqaqw tumalvopkot nȫnösaṅwuqat aṅqe’ tiposhoyat qatsqata. ");
INSERT INTO hopNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Noqw puma put aw yórikyaqe, hoṅviaya it tsākw hin lavayhtiqat aṅqe’ tunvotnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Noqw sohsoyam put nanaptaqam lālayṅwut pumuy hin āawnayaqat aṅ wūwantota. ");
INSERT INTO hopNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Noqw Mary tuwat sohsok īit aw wūwank̇aṅw, unaṅwpeq pās oya. ");
INSERT INTO hopNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Noqw lālayṅwut hoṅviaya amumi hin hiṅqawhqat sohsok nanaptaqe, pu aw yórikyaqe, ahoy kanelvokmuy amumiya; nihqe put pantaqat ep puma God pas hihtatiwisk̇ahk̇aṅw, tayawintiwisa. ");
INSERT INTO hopNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Noqw nanalsikis talöṅvaqat ep tsākw poṅotkuyaniqat aw pituqw, naat put Jesus yan tuṅwa. Pan hapi ura hoṅviaya put tuṅwa, put yuyat nāt qa nö’yiltiq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Noqw put yuat Moses tutavoyat anwat tiyqatskuyvaqw, puma tsākw Tutuyqawhqat aw nóaniqe, Jerusalem ep wikva. ");
INSERT INTO hopNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ura pi yan Tutuyqawhqat tutavoyat aṅ pey’ta: Aṅsakis haqam hak wuhti pas mohtitiyohyat tihtapq, pam Tutuyqawhqat awwat noiwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Noqw tutavot aṅ hin pey’taqat pan puma Tutuyqawhqat aw hihta hom’oya. Yan ura pey’ta: Hak lȫqmuy masihöwituy, sen lȫqmuy qötsáhöwituy Tutuyqawhqat aw hom’oymantani. ");
INSERT INTO hopNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Noqw meh, hak tāqa, Simeon yan mātsiwhqa, Jerusalem ep qatu. Pam hak súank̇aṅw God pas k̇aptsi’ta; nihqe hak Israel‐sinmuy Ayo Oyatoqat nuhtayta. Noqw Qahováriwtaqa Hikwsi put amum hinma. ");
INSERT INTO hopNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Noqw ason yaw pam pas Tutuyqawhqat aṅqw moṅw’asi’taqat aw yorikt, pu’ hisat ahpiyniqat Qahováriwtaqa Hikwsi put pan āawna. ");
INSERT INTO hopNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Noqw Hikswi pan put unaṅwtoynaqw, pam God kīyat ep paki. Noqw Jesus yuat puwsuṅway amum tutavot hin yuykiwhqat tsākw Jesus eṅem hinhtiniqe ōviy pep put wikva. ");
INSERT INTO hopNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Noqw Simeon put tsöpahtaqe, God aw hahlayhtit, paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tutuyqawhqa, taay, um uhlavayiy aw antsanni, Um uhtumal’ayay qa hin unaṅway’k̇aṅw yaṅqw ahpiyniqat aw nakwhanani. ");
INSERT INTO hopNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Pi nu ivosiy akw hak Ayo Tūoyaniqat ūṅaqwnihqat aw yori. ");
INSERT INTO hopNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Put pantaqat hapi um sohsokmuy sinmuy amutpik na’sasta. ");
INSERT INTO hopNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Soñawnen pam qa‐Jew‐sinmuy amumi tālawnani; pu uhsinmuy, Israel‐sinmuy ōmi tsok̇anani. ");
INSERT INTO hopNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Noqw Joseph put yuyat amum pam hin tsākw lavayhtiqat aw k̇ātuqayta. ");
INSERT INTO hopNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Noqw Simeon pumuy öqalaqe, put yuyat Maryt aw paṅqawu: Meh, i’ tsāy God ahpiy namorstiwa. Noqw put atsviy Israel‐sinmuy amuṅaqw k̇aysiwhqam munumhtini, pu piw k̇aysiwhqam hoṅvani. Pam hihta tuawi’taqw, sinom put aqw hīhiṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Pantani hapi. Noqw soñawnen uh’unaṅwa sipwuvahpit akw tūhotiwni. Noqw k̇aysiwhqamuy tunatyaam tupkiwyuṅqa mātaktotini. ");
INSERT INTO hopNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Noqw hak God lavay’ayaat, Anna yan mātsiwhqa, pep qatu, hakiy Phanuel tíata, Asert ahpiyvi. Pam hak wuhtiharsku; nihqe pam manhqatsiy ahpiy puwsuṅway amum tsaṅe’ yahsaṅwuy aṅ qatu. ");
INSERT INTO hopNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Noqw pam koṅnalavu nālöp sunat aṅqw nālöp sihk̇ay’taqat pahsa’haqam yahsaṅwni’ta. Noqw pas pam God kīyat aṅqw qa ahpiyniṅwu. Nīk̇aṅw mimhikqat, pu talöṅwiwmaqat aṅ napwalni’k̇aṅw, nāwakink̇aṅw God eṅem tumalay’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Noqw Simeon nāt yuaataqw, i’ wuhti ep pákihqe, Tutuyqawhqat aw hahlayhti, nit sohsokmuy amumi put tsākw yuaata, Jerusalem ep sinmuy Qenivo Oyaniqat ōviy maqaptsi’yuṅqamuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Noqw Joseph, put yuyat amum Tutuyqawhqat hin tutaptaqat an sohsok hinhtit, ahoy Galilee‐tutskwat aqw’a, nāp kitsókiy Nazareth aw’i. ");
INSERT INTO hopNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Noqw tsāy wuyoq’iwmaqe suyhtsepṅwat tunatyay aṅ öqawi’ma; piw unaṅwtalwuwnit aṅ’a, nihqe God núokwayat aṅ hinma. ");
INSERT INTO hopNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Noqw Joseph, put yuyat amum aṅsakis yahsaṅwuy aṅ Jerusalem aqwniṅwu, ura Amutsva Yūmosanihqat ep nōviwhqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Noqw Jesus pakwt löq sihk̇ay’tasikis yahsaṅwni’taqw, Jew‐sinom hin hintsatsk̇aṅwuqat ōviy naat yuyat amum Jerusalem aqw’a, Jesus wikk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Noqw puma aṅ kuyvaqe, nāp kitsókimiq áhoyniqw, tsāy Jesus pumuy qa amumumnihqe, Jerusalem epeq huruhti, noqw puma put qa navota. ");
INSERT INTO hopNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nihqe pay pam pumuy amumumyaqamuy amumumnihqat puma wūwaqe, ep tāwanawit aṅ haqami pahsavo nakwsu; nihqe puma sinomuy‐nik̇aṅw, pu tuwimuy amuhpa’ put hēva. ");
INSERT INTO hopNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nit puma put qa túwahqe, namtökt ahoy Jerusalem aqw’a, put heptoqee. ");
INSERT INTO hopNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Noqw pāyis talqw, puma God kīyat ep put tuwaqw, pam tūtutuqaynayaqamuy amuhsonve qatuk̇aṅw, pumuy amumi tūqayk̇aṅw, pu pumuy hihta tūviṅlawu. ");
INSERT INTO hopNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Noqw sohsoyam aw tūqayyuṅqam put hin hihta mātsi’maqat, pu hihta hin ahoy hu’wanmaqat ep k̇ātayuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Noqw puma put túwahqe hin kurs wūwa. Noqw yuat put aw paṅqawu: Itii, ya um hinoqw itamuy yanhaqam hintsana? Okiw nu’ unay amum k̇ānavoti’k̇aṅw uṅ hepnuma. ");
INSERT INTO hopNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Noqw pam pumuy amumi paṅqawu: Ya uma hinoqw nāpi nuy hepnuma? Ya nu Inay hihta himuyat hintsakniqat uma put qa navoti’taqe ōviy’o? ");
INSERT INTO hopNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Noqw pay puma put lavayiyat qa māmatsi. ");
INSERT INTO hopNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pu pam pumuy amumumnihqe, Nazareth ep pitu; nihqe pumuy amumi tūqayk̇aṅw qatu. Noqw tuwat put yuat īit lavayit sohsok unaṅwpeq pās oyi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Noqw Jesus suyhtsepṅwat wuwni’mak̇aṅw wūyoq’iwma; pu suyhtsepṅwat God‐nik̇aṅw pu sinmuy tayawni’ma. ");
INSERT INTO hopNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Noqw hak Tiberius Caesar pakwt tsivot sihk̇ay’taqat yahsaṅwuy aṅ moṅw’iwtaqw, pu Pontius Pilate Judea‐tutskwat ep moṅw’iwtaqw, pu Herod Galilee‐tutskwat aw moṅw’iwtaqw, pu tupkoat Phillip Iturea‐tutskwat ep sinmuy amumi‐nik̇aṅw pu Trachonitis‐tutskwat ep sinmuy amumi moṅw’iwtaqw, pu Lysanias Abilene‐tutskwat ep moṅw’iwtaqw, ");
INSERT INTO hopNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Pu Annas‐niqw pu Caiphas, puma God awwat mohpeq moṅw’iwtaqw, ephaqam God lavayhti, Zacharias tiyat John aw’i, pam qayēsiwhpuveniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Noqw pam pāyut Jordan aṅ ahsupoq tutskwat aṅ nakwsuqe, sinmuy amumi yuaataqe paṅqawu: Uma nāp umuhtunatyay aṅqw lasye’, kūyit akw tuvoylatotini. Noqw God umuhqaanhtipuy umuhpiy ayo yúkuni, amumi kita. ");
INSERT INTO hopNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ura hakiy God lavay’ayayat Esaiast lavayiyat aṅ yan pey’ta: Hakiy tönaat qayēsiwhpuve tsa’tinumqa navotniwa; nihqe yan lalvaya: Uma Tutuyqawhqat eṅem pöhut aw hintsatsnani; pam háqe’niqat aw suwiptotani. ");
INSERT INTO hopNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sohsovik sisk̇at aṅ otsómhtini, pu sohsovik tuhtukwi, pu tsotsmo tutskwatiwni, pu aṅ nukushinyuṅqa súwiptotini, pu haqe’ anahaiwyuṅqa pöhiṅputiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Noqw sinom sohsoyam God hin ayo tūooyhqat aw yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pahsat pu sinom put ahpiy kūyit akw tuvoylatiwyaniqe ōviy put aw ökiwtaqw, pam pumuy amumi yan lalvaya: Is ohi, uma hakim tsūtsu’tuy amunyuṅqamu, ya hak umuy itsívut nātoniqat aṅqw watqaniqat umumi paṅqawu? ");
INSERT INTO hopNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kurs uma pas antsa umuhtunatyay aṅqw lasye’, uma alöṅöt qatsit ahpiy tutmalat hintsatsk̇ani. Pu uma umuh’unaṅwpeq qa pan lavaytani: Abraham hapi itanaa, kitotani; taq nu umumi paṅqawni: God it o’wat aṅqw Abraham eṅem sinmuy aniwnaniqey tuwi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Noqw pay soñawnen ōviy piw pik̇aiṅwa himutsokit ṅayat tsahqaniqey na’sas’iwta. Noqw ōviy himuwa tsoki lomasipalat qa himuy’vaṅwuqa tsaqniwe’, qȫhit aqw tūviwni. ");
INSERT INTO hopNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Noqw sinom put tūviṅtotaqe aw paṅqaqwa: Noqw itam hinhtotini? ");
INSERT INTO hopNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Noqw pam lavayhtiqe amumi paṅqawu: Lȫqmuy wukonapnay’taqa ṅastanihqat sūkw máqani; pu nȫsiwhqay’taqa piw pay anhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Noqw moṅwit eṅem sīvat ömalalwaqam piw kūyit akw tuvoylatotiniqe ö́kihqe, put aw paṅqaqwa: Tūtutuqaynaqa, ya itam hinhtotini? ");
INSERT INTO hopNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Noqw pam pumuy amumi paṅqawu: Pay hihsa’haqam umuṅem tuwantiwhqat epnihqe qa hóyokput uma nuhtuṅaqw ömahtiwisni. ");
INSERT INTO hopNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Noqw pu solāwam piw tuwat put tūviṅtotaqe aw paṅqaqwa: Noqw ítamwat hinhtotini? Noqw pam amumi paṅqawu: Uma qa tūyuyuyhnayani. Piw qa hakiy hihta atsátotoynayani; pu uma hin ahsalalwe’, pay put ep nakwhani’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Noqw nāt sinom sumataq hintaniqat maqaptsi’yuṅqw, sohsoyam unaṅwpeq John aw hin wūwantota, sen pi pam Christ‐nihqata, sen pi pay qa pamnihqata. ");
INSERT INTO hopNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Noqw John lavayhtiqe, sohsokmuy amumi paṅqawu: Pay nu’ pi as pas antsa umuy kūyit akw tuvoylalawu. Nīk̇aṅw pay suhk̇a inuhpenihqe pas pavan öqala aṅq’ö. Noqw soon nu yan’ewaynīk̇aṅw pay ṅas’ew put tots‐sosomhpiyat ṅahni. Ason pam Qahováriwtaqat Hikwsit akw umuy tuvoylatani, pu qȫhit akw’a. ");
INSERT INTO hopNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Soñawnen pam wuhihpiy yawta, nihqe murivihk̇ay ep pās qeni’tani, nen söhövosiy koyohkiy aw taṅatani, nit pam ason tsihput qȫhit qatokṅwuqat akw taqtsokni. ");
INSERT INTO hopNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yan pam hīhihta akw pumuy ökwhank̇aṅw, amumi lomatuawit yuaata. ");
INSERT INTO hopNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Noqw John Moṅwit Herod qöhqöya, tupkoyat Philip nȫmayat Herodius ep’e, pu sohsok hihta ep qaanhtiqat ep pīwu. ");
INSERT INTO hopNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Noqw Herod pay nāt piw qaanhtit, John sivikimi pana. ");
INSERT INTO hopNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Noqw pam nāt qa sivikive pakiwtaqw, sinom sohsoyam kūyit akw tuvoylatiwyaqw, pu Jesus piw kūyit akw tuvoylatiqe, nāwakintaqw ōmi hötsílti. ");
INSERT INTO hopNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Noqw Qahováriwtaqa Hikwsi höwit an tokoy’k̇aṅw put atsmi hāwi. Noqw ōṅaqw hakiy tönaat hiṅqawhqe paṅqawu: Um hapi pas aw iunaṅwaa Itii. Nu uṅ pas hahlayi. ");
INSERT INTO hopNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Noqw Jesus tumalay hintsaktiva, sunat pakwt sihk̇ay’taqat pahsa’haqam yahsaṅwni’k̇aṅwo. Noqw sinom wūwantotaqw, Jesus Joseph tíata. Noqw pam Helit tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Noqw pam Matthat tíata, noqw pam Levit tíata, noqw pam Melchit tíata, noqw pam Jannat tíata, noqw pam Joseph tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Noqw pam Mattathias tíata, noqw pam Amos tíata, noqw pam Naum tíata, noqw pam Eslit tíata, noqw pam Nagget tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Noqw pam Maath tíata, noqw pam Mattathias tíata, noqw pam Semeit tíata, noqw pam Joseph tíata, noqw pam Judat tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Noqw pam Joannat tíata, noqw pam Rhesat tíata, noqw pam Zorobabel tíata, noqw pam Salathiel tíata, noqw pam Nerit tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Noqw pam Melchit tíata, noqw pam Addit tíata, noqe pam Cosam tíata, noqw pam Elmodam tíata, noqw pam Er tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Noqw pam Joset tíata, noqw pam Eliezer tíata, noqw pam Jorim tíata, noqw pam Matthat tíata, noqw pam Levit tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Noqw pam Simeon tíata, noqw pam Judat tíata, noqw pam Joseph tíata, noqw pam Jonan tíata, noqw pam Eliakim tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Noqw pam Meleat tíata, noqw pam Menan tíata, noqw pam Mattathat tíata, noqw pam Nathan tíata, noqw pam David tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Noqw pam Jesset tíata, noqw pam Obed tíata, noqw pam Booz tíata, noqw pam Salmon tíata, noqw pam Naasson tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Noqw pam Aminadab tíata, noqw pam Aram tíata, noqw pam Esrom tíata, noqw pam Phares tíata, noqw pam Judat tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Noqw pam Jacob tíata, noqw pam Isaac tíata, noqw pam Abraham tíata, noqw pam Tharat tíata, noqw pam Nachor tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Noqw pam Saruch tíata, noqw pam Ragaut tíata, noqw pam Phalec tíata, noqw pam Heber tíata, noqw pam Salat tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Noqw pam Cainan tíata, noqw pam Arphaxad tíata, noqw pam Sem tíata, noqw pam Noet tíata, noqw pam Lamech tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Noqw pam Mathusalat tíata, noqw pam Enoch tíata, noqw pam Jared tíata, noqw pam Maleleel tíata, noqw pam Cainan tíata; ");
INSERT INTO hopNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Noqw pam Enos tíata, noqw pam Seth tíata, noqw pam Adam tíata, noqw pam God tíata. ");
INSERT INTO hopNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Noqw Jesus Qahováriwtaqat Hikwsit akw tuyqawiwk̇aṅw, pāyut Jordan aṅqw ahoy pitu, nihqe Hikwsit ahpiy qayēsiwhpumi wīkiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Noqw Nukpana lȫp sunat tālat aṅ pep put aw unaheplawu; noqw pam pahsa’ talönvaqat aṅ qa nȫsa, nihqe aṅ ruhpakq pam tsöṅmoki. ");
INSERT INTO hopNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Noqw Nukpana put aw paṅqawu: Kurs um pas antsa God Tíatnen, um it owat pölavikiniwhtiniqat aw paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Noqw Jesus lavayhtiqe aw paṅqawu: Sóoni, pi ura yan pey’ta: Sino qa pölavikit‐sa akw qátut, pas God lavayiyat sohsok akw qátuni. ");
INSERT INTO hopNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pu Nukpana haqami pas wupatukwit aqw put wikqe, tūwaqatsit aṅ ahsupoq moṅwqeqnit put aw súmahtakna. ");
INSERT INTO hopNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nihqe aw paṅqawu: It hapi öqalat nu uṅ sohsok máqani, pu hihta aṅ susnunukṅwata, pi pam inumi noiwta. Noqw nu hakiy put máqanik máqaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Noqw ōviy kurs um inumi naokiwtaqw, pay pam sohsoy uhhimuni. ");
INSERT INTO hopNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Noqw Jesus lavayhtiqe put aw paṅqawu: Sóoni, yupa ayo haqamii, Satan, pi yan pey’ta: Um God Uhtutuyqawhqay aw naokiwlawni, pu um put‐sa eṅem tumalay’tani. ");
INSERT INTO hopNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pu Nukpana put Jerusalem ep wikvaqe, God kīyat ep suswupakits’omiq put tsók̇at, pu aw paṅqawu: Kurs um pas antsa God Tíatnen, yaṅqw atk̇amiq nātuvani; ");
INSERT INTO hopNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pi ura yan pey’ta: Pam hoṅviaymuy ayataqw, ūmi tunatyaltotini; ");
INSERT INTO hopNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nen puma may akw uṅ hölölni’yuṅwni, taq nāp hisat sen um uhkukuy owat aqw sáviknani. ");
INSERT INTO hopNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Noqw Jesus lavayhtiqe put aw paṅqawu: Sóoni, pi ura yan pey’ta: Um God Uhtutuyqawhqay aw qa tuwanlawni. ");
INSERT INTO hopNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Noqw Nukpana sohsok unaheppit akw put aw tuwantaqe yúkuhqe, hihsavo put aṅqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Noqw Jesus Qahováriwtaqat Hikswit öqalayat pasiwk̇aṅw, Galilee ep ahoy pitu. Noqw sinom aṅ ahsupoq put lavayta. ");
INSERT INTO hopNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Noqw pam pumuy tsotsvalkiyamuy aṅ pumuy tutuqaynatinuma, sohsokmuy amuhpiy k̇aptsiwk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pu pam haqam wuṅhqey Nazareth aw pitu. Nihqe pam hin tuwi’taqey anhtiqe, nasuṅwintalöṅnit ep tsotsvalkimi paki, nihqe tutuvenit aṅ túṅwantaniqe wunuptu. ");
INSERT INTO hopNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Noqw pep God lavay’ayayat Esaias tutuveniat put aw taviwa. Noqw pam tutuvenit púruknaqe, haqe’ yan pey’taqat tuwa: ");
INSERT INTO hopNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Tutuyqawhqat Hikwsiat nuy tuyqawi’ta, nu aṅ ókiwyaqamuy amumi lolmat yuaaykuniqat ōviy nuy asnaqee; pu aṅ unaṅwsoiwtaqamuy suyan unaṅwtoynaniqat ōviy nuy ayata, aṅ tūwik’iwyuṅqamuy nuy mātaviwyaniqat amumi yuaaykuniqat ōviy’o, pu aṅ qatālat pōsi’yuṅqamuy pōsiyamuy tālawnayaniqat amumi yuaaykuniqata, pu aṅ okiwsaniwyaqamuy qeniveyaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pu i’ Tutuyqawhqa ayo tūooyniqat aw pitsíwtaqat tunvotnaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yan pam aṅ tuṅwat, tutuvenit mupipiykinat, aw tunatyawtaqat aw put ahoy tavit qatuptu. Noqw tsotsvalkive taṅawtaqam put aw‐sa tāyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pahsat pu pam pumuy amumi paṅqawu: Umuy hapi aw tūqayyuṅqw, i’ yan pey’taqa it talöṅvaqat ep aw antsaniwa. ");
INSERT INTO hopNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Noqw sohsoyam put aw tūqayyuṅqe, moaṅaqw lavayit lolmat nö́ṅakqat aw k̇āwuwantotaqe, paṅqaqwa: Ya qa i’ Joseph tíata? ");
INSERT INTO hopNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Noqw pam pumuy amumi paṅqawu: Pay kurs hin uma inumi yan lavayit qa paṅqaqwani: Tūhik̇a, nāqalaptsinaa, it’a. Um yaw Capernaum ep hīhihta tumalta; um yep nāp uhtutskway ep piw panhtinikaṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Noqw pam paṅqawu: Pas antsa nu umumi paṅqawni: Qa hak God lavay’ayaat nāp tutskway ep pāsniwa. ");
INSERT INTO hopNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Noqw nu umumi súaṅqawni: Ura Elias qatsíyat ep payhkomuy yahsaṅwuy aṅqw navay mūmuyawhtuy aṅ qa yokva; noqw ura tutskwat aṅ ahsupoq tsö́ṅösti. Noqw ephaqam Israel‐sinmuy tutskwayamuy ep k̇aysiwhqam koṅnanalvut yēse. ");
INSERT INTO hopNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Noqw pay ura pas Elias pumuy qa haqawatuy amumi ayatiwht, pay ura Sidon ep kitsókit Sareptat ep hakiy koṅnalavut aw’i. ");
INSERT INTO hopNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pu God lavay’ayayat Eliseus qatsíyat ep as Israel‐sinmuy amuṅaqw k̇aysiwhqam tokoplelet tūtuyya; noqw pay ura puma pas qa haqawa powalti, pay hak Syria‐sino hak Naaman yan mātsiwhqa‐saa, amumi kita. ");
INSERT INTO hopNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Noqw sohsoyam tsotsvalkive taṅawtaqam it nanaptaqe, pas itsívutoti; ");
INSERT INTO hopNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nihqe hoṅvaqe, put kīṅaqw tūvaya. Pumuy kitsókiam haqam tsomoveq wunu. Noqw ōviy pep tumpok puma put wikya, paṅqw put tūvayaniqey unaṅwtotiqee. ");
INSERT INTO hopNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Noqw pay pam amuhsonṅaqw hinmak̇aṅw, paṅqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nihqe pam Galilee ep kitsókit Capernaum aqwnihqe, nasuṅwintalöṅnit aṅ sinmuy tutuqayna. ");
INSERT INTO hopNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Noqw pas puma put hin tutuqaynaqat ep aw k̇ātuqayyuṅwa, pas pam a’nö lay’taqat yuaataqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Noqw hak tāqa tuyoy’ewakw nukpanhikwsit okiw akw tuyqawiwtaqa tsotsvalkive pakiwta, nihqe pam a’nö hiṅqawhqe paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Itamumi qa hintsakii. Ya itam uṅ hintsatsnani, Jesus Nazareth aṅqwnihqa? Ya um itamuy kīqötaniqe ōviy aṅqaqö’? Pay um hákiyniqw nu uṅ tuwi’ta. Um God aṅqw pas Qahováriwpu. ");
INSERT INTO hopNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Noqw Jesus put mēwaqe, aw paṅqawu: Qa hiṅqawlawht, put aṅqw yámakuu. Noqw nukpanhikwsi sinmuy amutpipo put tūvat, put aṅqw yama, nit pay put qa hintsana. ");
INSERT INTO hopNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Noqw puma sohsoyam k̇ātayyuṅqe nānami paṅqaqwa: Is uti, pavan pas lavayi! Pas pi qananahtsopk̇aṅw, öqalat akw tuyoy’ewakw hīhikwsimuy amumi paṅqawhq, puma nuhtuṅaqw nö́ṅakṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Noqw pam pep hin yukuqw, pam pantaqa put tutskwat aṅ ahsupoq yuaatiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Noqw pam tsotsvalkiṅaqw yámakqe Simon kīyat aw paki. Noqw Simon nȫmay yuat a’nö mukitutuya; noqw puma put eṅem Jesus aw taqa’naṅwtoti. ");
INSERT INTO hopNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Noqw pam put aw wunuptut, mukituyat mēwa; noqw pam put mātavi, Noqw pahsat pay pam wuhti wunuptut, pumuy amumi unaṅwtavi. ");
INSERT INTO hopNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Noqw tāwat pakitoqw, sohsokmuy hihta akw tūtuyyaqamuy, puma Jesus aw tsamvanta, noqw pam pumuy sohsokmuy amumi may akw hintsanqe pumuy qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Noqw nukpanhihikwsim k̇aysiwhqamuy amuṅaqw nȫṅa, a’nö hiṅqaqwak̇ahk̇aṅwo, nihqe paṅqaqwa: Um Christ, God Tíata! Noqw pam pumuy tusoqmewaqe, pumuy hiṅqaqwaniqw qa nakwhana, puma put Christ‐nihqat tuwi’yuṅqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pu tālawvaqw pam ahpiynihqe, haqami qayēsiwhpumii; noqw sinom put hepya, nihqe put aw ö́kihqe as put huruhtapnayani, pam as pumuy amuṅaqw qa ahpiyniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Noqw pam pumuy amumi paṅqawu: Pas nu soon qa God moṅwtunatyayat hin hintaqat aye’ kitsókinawit piw yuaatinumni, pi nu paníqw aṅqw ayatiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nihqe pam Galileet ep haqe’ tsotsvalkit aṅ yuaatinuma. ");
INSERT INTO hopNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Noqw sinom God lavayiyat nanaptaniqe put aw hūrs tsovawtaqw, pam wuhkovatuphat Gennesaret yan mātsiwhqat qalaveq wunu. ");
INSERT INTO hopNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nihqe pam lȫqmuy pākihut patuphat qalaveq wúnuhqat tuwa, noqw kurs pakiwmamahk̇am pumuy aṅqw nö́ṅakqe, pakiwmaqtutsayay tūvahomtota. ");
INSERT INTO hopNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Noqw pam pākihut hakiy Simon himuyat aqw paki; nihqe pam tutskwat aṅqw híhin yūmo hóyoknaniqat aw paṅqawu; noqw pam pepeq qatuptuqe, pākihut aṅqw sinmuy tutuqayna. ");
INSERT INTO hopNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pu ōviy pam yuaataqe yukut, Simon aw paṅqawu: Uma pavan hötsit aw hóyok̇e’, pāvakiwhtuy inhtaniqe ōviy umuhtutsayay pāmiq pánani. ");
INSERT INTO hopNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Noqw Simon lavayhtiqe put aw paṅqawu: Moṅwi, itam as tōk̇ep tumalay’tat, qa hihta kwisna, noqw pay pi um paṅqawhq ōviy nu tutsayat pāmiq pánani. ");
INSERT INTO hopNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Noqw puma panhtiqe, pahsat pu qaan’ewakw hintaqamuy pāvakiwhtuy inhta; noqw pumuy tutsáyaam tsīkiwma. ");
INSERT INTO hopNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Noqw suṅwámat sukwat pākihut aṅqw taṅawtaqw, puma pumuy amumi māmasa pumuy paaṅwaniqat ōviy’o. Noqw puma pituqw, puma lȫqmuy pākihut akw ohpoknayaqw, pahsat pay puma pākihut pakito. ");
INSERT INTO hopNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Noqw Simon Peter put aw yórikqe, Jesus tamöyat aw nātuvat paṅqawu: Inuṅaqw ahpiy’o, taq nu okiw qaanhinmaqa, Tutuyqawhqa. ");
INSERT INTO hopNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pi pam‐niqw, pu sohsoyam put ámumyaqam puma pāvakiwhtuy inhtotaqey ep kātayyuṅqw, ōviy pam yan lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Noqw piw hakiy Zebedeet timat James‐niqw pu John, Simon suṅwámatnihqam, puma pumuy amún nātsawina. Noqw Jesus Simon aw paṅqawu: Um qa tsawiniwtani, um yahpiy haqahpiy pāpu sinmuy kwīkwisnani. ");
INSERT INTO hopNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Noqw puma pākihuy tutskwami pitsínayaqe, sohsok tatamhtotat, Jesus aṅkya. ");
INSERT INTO hopNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pu piw pam haqam kitsókiveniqw, hak tāqa ahsupoq tokoplelet tūtuya, nihqe pam Jesus túwahqe, tayway akw atpipo munukt, aw nāwaknaqe paṅqawu: Tutuyqawhqa, um suhtaq’ewnen soon nuy qa powatani. ");
INSERT INTO hopNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Noqw pam put aw māvuyaltiqe, aw toṅokt, paṅqawu: Pay nu suhtaq’ewa; powaltii. Noqw pahsat pay tokoplele put mātavi. ");
INSERT INTO hopNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Noqw pam qa hakiy put āawnaniqat pam aw paṅqawu. Nīk̇aṅw pay um ahpiynen God awwat moṅwit aw nāmahtaknani; nen Moses hin tutaptaqat anwat um powaltiqey ep kuwahtiput távini. Um pan powaltiqey nuhtumi tuawi’tani, yan aw lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Noqw tuwat soq pahsat pu pas ahsupoq pam hin hinhtiqa yuaatiwa, noqw sinom qaan’ewakw hintaqam Jesus aw tūqayyuṅwniqe sūmitsovalti; pu hīhihta tūtuyyaqam put ahpiy qalaptuyaniqe ōviy put aw ökiwta. ");
INSERT INTO hopNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Noqw pay pam haqami qayēsiwhpuminen, God aw nāwakintaniqey ōviy kīṅaqw ahpiyniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pu Jesus hisat sinmuy tutuqaynaqw ima Pharisee‐sinom, tutavot tutuqaynayaqamuy amumum pep yēse. Puma Galileet aṅ ahsupoq kitsókit aṅqwya, pu Judeat aṅq’ö, pu Jerusalem aṅq’ö. Noqw pumuy pep yesq, Jesus Tutuyqawhqat aw yank̇aṅw tūqalaptsintaniqey öqalay’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Noqw meh, hakim hakiy tāqat ahpa’ qataytaqat tūtuyhqat ahpay aṅ qatsqat Jesus aw wikvaya; noqw puma as hin put panaye’, Jesus atpipo taviyaniqey tuwantota. ");
INSERT INTO hopNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Noqw ep huru’pokiwtaqw hin puma put panayaniqey qa tutwa; nihqe ōviy kits’omiq wupnayaqe, tsöqa’wa kīamit póroknayaqe paṅ put ahpayat enaṅ sinsonmi Jesus atpipo hawnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Noqw puma qapēvewnayaqat Jesus amumi túwahqe paṅqawu: Tāqa, uhqaanhtipu uhpiy ayo yukiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Noqw tutavot tutuqaynayaqam Pharisee‐sinmuy amumum put ep wūwantotaqe paṅqaqwa: Ya i’ haknihqe pas God qa k̇aptsilawu? Ya hak hakiy qaanhtipuyat ayo yúkuni, hal pas God‐saa? ");
INSERT INTO hopNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Noqw Jesus pumuy wuwniyamuy māmatsqe, lavayhtiqe amumi paṅqawu: Ya uma hihta umuh’unaṅwpeq wūwantota? ");
INSERT INTO hopNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ya hak hakiy aw hinwat lavayhtiniqw qa pas hinta, Sen, Uhqaanhtipu uhpiy ayo yukiwa kítaniqö’? sen pi wunuptut, nakwsuu, kítaniqö’? ");
INSERT INTO hopNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Noqw pay pi nu’ Sinot Tiat yep qatsit ep hakiy ahpiy qaanhtipuyat ayo yúkuniqey aw öqalat pasiwtaqat uma it akw nanaptaniqw‐pu pam it hakiy ahpa’ qataytaqat aw paṅqawu: Oviy nu ūmi paṅqawni: Wunuptut, uh’ahpay kwusut, nimaa. ");
INSERT INTO hopNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Noqw pahsat pay pam pumuy amutpik wunuptut, hihta aṅ wáökiwtaqey kwusut, paṅqw nima, God pas hihtatimak̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Noqw sinom sohsoyam k̇ātayuṅqe, God pas hihtatota, nihqe puma nātsawini’yuṅqe paṅqaqwa: Pas itam pu’ hihta qatuptsiwni’ewakw aw yórikya. ");
INSERT INTO hopNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","It yantaqat atsve pam nakwsukaṅw, hakiy moṅwit eṅem sīvat ömalawhqat, Levit yan mātsiwhqat aw yori, haqam put ömalawṅwuqat ep qátuq’ö, nihqe aw paṅqawu: Um inuṅkni. ");
INSERT INTO hopNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Noqw pam sohsok mātapt, wunuptut, put aṅki. ");
INSERT INTO hopNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Noqw Levi put eṅem wukonovata; noqw k̇aysiwhqam sīvat ömalalwaqam‐niqw pu hakim pumuy amumum pep nopyesva. ");
INSERT INTO hopNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Noqw Pharisee‐sinom‐niqw, pu pumuy amuṅaqw tutavot tutuqaynayaqam, puma put aw nánatuwnayaqamuy amumi qayan unaṅway hiṅqaqwaqe paṅqaqwa: Ya uma hinoqw moṅwit eṅem sīvat ömalalwaqamuy‐nik̇aṅw pu qaanhinwisqamuy amumum nōnovak̇ahk̇aṅw hīhikwya? ");
INSERT INTO hopNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Noqw Jesus lavayhtiqe amumi paṅqawu: Pay aṅ qahinyuṅqam tūhik̇at qa haqni’yuṅwa, nawus pi tūtuyyaqam put haqni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pi nu aṅ súanhinwisqamuy qa pumuy wáṅwayniqe ōviy pitu; pi nu imuy qaanhinwisqamuy nāp tunatyay aṅqw lasyaniqat aw wáṅwayniqe ōviy pitu. ");
INSERT INTO hopNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Noqw puma put aw paṅqawu: John aw nánatuwnayaqam pas nanapwalk̇ahk̇aṅw nānawaknaṅwu, noqw Pharisee‐sinmuy amumi nánatuwnayaqam amún hinwisa. Noqw hintaqw ōviy ūmi nánatuwnayaqam nōnovak̇ahk̇aṅw hīhikwya? ");
INSERT INTO hopNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Noqw pam pumuy amumi paṅqawu: Ya hak sen haqam mö’wit ep sinoiwyuṅqamuy, möönaṅwuy pumuy amumumniqw napwaltoynani? Soon’i. ");
INSERT INTO hopNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nīk̇aṅw ason hisat aw pituqw, möönaṅw’am pumuy amuṅaqw ahpiyniqw, pep pu’ puma nānapwalani. ");
INSERT INTO hopNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Noqw pam piw pumuy amumi lavayit hihta antaqat akw yuaaykuqe paṅqawu: Qa haq pi hak puhuyuwsit aṅqw hihsaqat tukut, sakwit aw pihtakna. Taq hak panhtinik puhut sakwítani, piw pūhu soon sakwit amum súnantani. ");
INSERT INTO hopNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pu qa haq pi hak puk̇awiwkorot sakwíiwmaqat puhuovavalat kuhkuya; taq hakiy pantiniqw, puhuovavala pēke’, wiwkorot patomnani, nen aṅ kūyiwtaqa wehemhtini, noqw wiwkorot sakwítini. ");
INSERT INTO hopNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Soon pi puhuovavala qa puhuwiwkorot aṅ kūyiltiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Piw qa hak pi hak ovavalat hísatwaiwhput hikwt, pay pahsat pūhutwat piw nāwaknaṅwu; nīk̇aṅw paṅqawṅwu: Pay hísatwat pas nukṅwa, kītaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Noqw nasuṅwintalöṅnit aw pituqw, Jesus put aw nánatuwnayaqamuy amumum söhövos’uyit aṅ nö́ṅakwisa. Noqw put aw nánatuwnayaqam söhövosit talayat mawtiwisk̇ahk̇aṅw, put mapqölpeq murik̇ahk̇aṅw nōnoptiwisa. ");
INSERT INTO hopNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Noqw hakim Pharisee‐sinom pumuy amumi paṅqawu: Ya uma hinoqw nasuṅwintöṅnit ep hihta mewniwtaqat hintsatsk̇a? ");
INSERT INTO hopNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Noqw Jesus lavayhtiqe pumuy amumi paṅqawu: Ya ura hisat David suṅwámuy amumum tsöṅmokqe hinhtiqat uma put pantaqat pas aṅ qa ṅas’ew tuṅwáya? ");
INSERT INTO hopNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ura pam God kīyat aw pákihqe, pölavikit God aw noiwhqat ömahtat, aṅqw nöst, pu ámumyaqamuy put huyta; pas ura God awwat momṅwit‐sa put aṅqw nȫnösaṅwuqat put’a. ");
INSERT INTO hopNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pu Jesus pumuy amumi paṅqawu: Pay nu’ Sinot Tiat piw nasuṅwintalöṅnit aw móṅw’iwta. ");
INSERT INTO hopNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pu hisat pam nasuṅwintalöṅnit ep tsotsvalkimi pákihqe ep tūtutuqayna. Noqw hak tāqa putvaqw mālakiwtaqa pep nuhtuma. ");
INSERT INTO hopNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Noqw tutavot tutuqaynayaqam Pharisee‐sinmuy amumum Jesus aw tunatyawyuṅwa, mātaq pi kurs pam nasuṅwintalöṅnit ep put qalaptsinaniqw ōviy’o; nen puma hihta ep put nēveltoynayani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Noqw pay pam pumuy tunatyayamuy amumi mātsi’taqe, lākiwtaqat may’taqat aw paṅqawu: Wunuptut, sinsonve wunuwtaa. Noqw pam panhti. ");
INSERT INTO hopNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pahsat pu Jesus pumuy amumi paṅqawu: Kurs nu umuy hihta tūviṅtani. Ya hak nasuṅwintalöṅvaqat ep hihta lolmat, sen qalolmat hinhtiniqw pam súanta? Sen qatsit ayo táviniqö’, sen hovalaniqö’? ");
INSERT INTO hopNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pu pam pumuy sohsokmuy amuhpa’ yorikt, tāqat aw paṅqawu: Uhmay tsihkwaa. Noqw pam panhti; noqw māat put ayaṅqwat māyat an pās powalti. ");
INSERT INTO hopNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Noqw puma itsívuhonaqtotiqe, hin as Jesus hintsatsnaniqey nānami yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Noqw pay ephaqam piw pam nāwaknaniqe haqami tsomomiq’a; nihqe tōk̇ep God aw nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Noqw tālawvaqw, pam put aw nánatuwnayaqamuy wáṅwayhqe, pumuy amuṅaqw pakwt lȫq sihk̇ay’taqamuy namorsta; nihqe pam pumuy Ayaiwyuṅqamuy yan tuṅwa, ");
INSERT INTO hopNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Imuyu: Simon, ura pam put Peter yan túṅwa, pu tupkoyat Andrewt, pu James‐nit pu John, pu Philip‐nit pu Bartholomewt, ");
INSERT INTO hopNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Pu Matthewt‐nit pu Thomas, pu Alpheus tiyat James‐nit pu Simon, Zelotes yan túṅwantiwhqata, ");
INSERT INTO hopNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Pu James tupkoyat Judas‐nit pu Judas Iscariot Jesus momṅwituy amumi kurs mātapniqata. ");
INSERT INTO hopNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pu pam pumuy tsamk̇aṅw, paṅqw hawhqe, haqam suntutskway’taqat ep wunu, k̇aysiwhqamuy put aw nánatuwnayaqamuy amumuma. Noqw qaan’ewakw hintaqam sinom put aw tūqayyuṅwniqe, pu hīhihta tūyay aṅqw qalaptuyaniqe öki, Judeat aṅqw‐nik̇aṅw, pu Jerusalem aṅqw sohsokivaq’ö, pu pātuwaqatsit qalaveq Tyre aṅqw‐nīk̇aṅw pu Sidon aṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pu ima tuyoy’ewakw hīhikwsimuy akw okiwhinyuṅqam piw ö́kihqe powaltoti. ");
INSERT INTO hopNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Noqw sinom sohsoyam as put aw tóṅokyaniqey nānawakna, pas pi put aṅqw suyan öqala yámakiwtaqe sohsokmuy qalaptsintaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Noqw pam put aw nánatuwnayaqamuy amuhpa’ yorikt, amumi paṅqawu: Pas uma aṅ ōokiwyaqam hahlayhpit epya, pi uma God moṅwtunatyayat himuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Uma aṅ pu’ tsöṅsoiwtaqam hahlayhit epya, pi uma nāt ȫöyyani; pas uma aṅ pu’ tsaykitaqam hahlayhpit epya, pi uma nāt tsutsúyni. ");
INSERT INTO hopNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ason sinom nuy Sinot Tiyat atsviy umumi qa suhtaq’ewye’, nahpiy umuy lālayye’, umumiq hīhiṅqaqwe’, umuhnatṅwaniy himu itséheetnihqat pan ayo tūvayaqw, uma hahlayhpit epyani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hisat panhtotiqw, uha hahlayhtote’, pas hahlaytso’tinumyani, ispi meh, uma ōveqatsit ep qaan’ewakw ahsatit makiwyaniqee; pi pay pan pumuy namat hapi God lavay’aymuyatuy hintsatsna. ");
INSERT INTO hopNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nīk̇aṅw is ókiwa, uma aṅ k̇ahaksinomu, pi uma umuhhahlayhpiy pay ömahtota. ");
INSERT INTO hopNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Is ókiwa, uma aṅ ȫyiwyuṅqamu, pi uma nāt tsöṅso’ni; is ókiwa, uma aṅ pu’ tsutsúyyaqamu, pi uma nāt qahahlayk̇ahk̇aṅw tsaykitani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pas sinom sohsoyam umuy lomayuaatotaqw, umuṅem is óhini; pi pay pan hapi pumuy namat hakimuy nawip’ew God lavay’aymuyatuy yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nīk̇aṅw nu umuy inumi tūqayyuṅqamuy umumi paṅqawni: Uma umuhtuwqamuy amumi unaṅway’yuṅwni; sinom umumi qa suhtaq’ewyaqamuy uma lolmat amuṅem hintsatsk̇ani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sinom umuy qalomáyuaatotaqw, uma pumuy amumi lomayuaatotani; pu umuy qaanhintsahtsanyaqw, amuṅem uma nāwakinwisni. ");
INSERT INTO hopNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ason hak uhtayway sutsvaqw wuvahtaqw, um ayaṅqwat piw aw ītamantani; pu hak uh’usimniy uṅ nawhk̇e’, uhnapnay enaṅ nāwaknaqw, um qa aw rohomnumni. ");
INSERT INTO hopNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hakiy ūmi hihta tūviṅtaqw, um put máqamantani, pu hihta uhhimuy kímahqat um aw ahoy qa tūviṅtamantani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pu sinom umuy pāsyaniqat uma nānawakne’, pay uma piw pan pumuy pāsyani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ispi kurs pay uma umumi unaṅway’yuṅqamuy‐sa amumi unaṅway’yuṅqw, hak sen put ep umuy hahlayhtini? Pay pi qaanhinwisqam pumuy amumi unaṅway’yuṅqamuy amumi tuwat unaṅway’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pu kurs hak umuṅem hihta lolmat hintsakq, uma tuwat put eṅem lolmat hintsatsk̇aqw ya sen hak put ep umuy hahlayhtini? Pay pi aṅ qaanhinwisqam piw pan hintsatsk̇a. ");
INSERT INTO hopNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pu kurs pay um hakiy aṅqw hihta ömahtaniqey wūwank̇aṅw, hakiy sīvat nasimokmaqaqw hak put ep ūmi hahlayhtini? Pay pi aṅ qaanhinwisqam piw qaanhinwisqamuy nasimokhuylalwa, piw aw ahsatit ömahtotaniqey tuṅlay’k̇ahkaṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tis pi uma umuhtuwqamuy amumi unaṅway’yuṅwni; nen lolmat hintsatsk̇ani; pu tūnasimokhuylalwani, qa hihta put ep tuṅlay’k̇ahk̇aṅwo. Nen uma qaan’ewakw ahsatit makiwyani; piw Sus’oveqnihqat tímatni. Pi pam aṅ qa tsúyakyaṅwuqamuy, qalōlolmatuy enaṅ pās’i. ");
INSERT INTO hopNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Paniqw ōviy uma nun’okwatni, Umunay hin núokwaniqw pan’i. ");
INSERT INTO hopNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Uma qa tūovelantotani; nen uma qa pantsaniwyani. Uma hakiy qa paysoqtotani, nen qa pantsaniwyani. Ason hak umuhpe qaanhtiqw, uma put pantaqat ep aw pöhikyamantani, noqw sinom tuwat umumi pö́hikyani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Uma hihta kuwahtotimantani, noqw pu tuwat umumi himu kuwahtiwni. Sinom wukotuwanit aṅqw móo’taqat hihta kuytotat, put hūrs aqw ṅúṅuyvut, pu wīlaniwhput, pu pas aṅ wahohotaqat umumi o’yamantani. Pi uma hakiy eṅem hin tuwantotaqw, pay piw pan umuṅem tuwantiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Noqw pam tūwutsit hihta tuawi’taqat lavayhtiqe, amumi paṅqawu: Ya sen hak qapostalqa hakiy qapostalqat haqami wikni? Ya puma qa nāma haqami pövamiq posni? ");
INSERT INTO hopNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pay hakiy aw tutuqayhqa put tutuqaynaqat epnihqe qa pavan pasniṅwu. Nīk̇aṅw ason pam pās tutuqaye’, pep pu’ pam put tutuqaynaqat pay antani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Noqw ya um hinoqw uhtupkoy posmiq hihta hihsaq tuway’k̇aṅw, uhposveq lestavit pakiwtaqat qa aw unaṅwtavi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Noqw pantaqw um hin uhtupkoy aw paṅqawni: Itupko, nu as uhposkiy uṅem hóroknani, kítani, susmataqpi uhposveq lestavi pakiwtaqö’? Um nawip’ew hinmaqa, um mohti uhposṅaqw lestavit hórokne’, pahsat pu um suyan tālat tayk̇aṅw, uhtupkoy poskiyat hóroknani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Pi lomasipaltsoki soon hin’ewakw sipalat himuy’vaṅwu; piw qalomásipaltsoki soon nukṅwat sipalat himuy’vaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sinom himutsokit hímunihqat aniwniyat akw tuwi’yuṅwa. Soon hihta kūtay’taqat aṅqw nönvospalat hak mawni; soon hak yöṅötskit aṅqw ōvat tsovalani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sino lolma lomatunatyawtaqa unaṅṅaqw hihta lolmat nȫṅantoynaṅwu; noqw pam piw hak qalolma qalomátunatyawtaqa unaṅṅaqw hihta qalolmat nȫṅantoynaṅwu. Pi hak hin tunatyay’te’, pan hapi yuaataṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Uma nuy Tutuyqawhqa, Tutuyqawhqa, yan túṅwantota. Nīk̇aṅw uma hinoqw ilavayiy qa aṅ hinwisa? ");
INSERT INTO hopNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Inuminihqa ilavayiy aw tūqayk̇aṅw put aṅ hinmaqa hakiy antaqat nu umuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pam hakiy tāqat anta. Pam hak a’nö háṅwahqe owat ep kīhut yayhna. Noqw a’nö wukomunvaqw, pāhu kīhut aqw a’nö yēvantak̇aṅw, soon put wayáyaykinani, pam owat ep wunuqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pu i’ hak navotk̇aṅw put qa aṅ hinmaqa hakiy tāqat anta. Pam hak qa qaqatspitaqat, pisave kīta. Noqw mūnaṅw put kīhut aqw a’nö yēvantaqw, pam āpiy sahpu; noqw pam kīhu qaan’ewakw kīqöti. ");
INSERT INTO hopNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Noqw Jesus nuhtumi yuaataqe yúkut, Capernaum aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Noqw hakiy tsivót‐sikip sunat solāwamuy amumi moṅwit tumal’ayaat tūtuyhtiqe, pāpu pay mómoki. Noqw put moṅwíat put pas k̇ahk̇awna. ");
INSERT INTO hopNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nihqe pam Jesus tumalayat navotqe, Jew‐sinmuy wukw’aymuyatuy put aqw ayata, okiw as pam aqwnen put tumal’ayayat qalaptsinaniqat puma put aw nānawaknaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Noqw puma Jesus aw ö́kihqe, pahsat pay qa nātusitotaqe paṅqaqwa: Um put eṅem yanhte’, súanhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Pas pam itamuy Jew‐sinmuy hahlayhqe, itamuṅem tsotsvalkit yuku. ");
INSERT INTO hopNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pahsat pu Jesus pumuy amumum aqw’a. Nihqe pam put kīyat aw hayiṅwnaqw, i’ hak solāwamoṅwi kwatsmuy put aw hōnaqe aw paṅqawu: Tutuyqawhqa, pay um qa pas pew ö’qalni; soon nu yan’ewakniqw um ikiy aw papkini. ");
INSERT INTO hopNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Paniqw ōviy nu soon yan’ewaynīk̇aṅw nāp ūminiqey antani. Pay um panis lavayhtiqw, pay itumal’aya qalaptuni. ");
INSERT INTO hopNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pi pay nu sukwat amumi maqaptsi’k̇aṅw qatu; noqw solāwam inumi maqaptsi’yuṅwa. Noqw nu hihtawat aw Yupa kitaqw, pam ahpiyniṅwu; pu hihtawat aw Pew’i kitaqw, pam inuminiṅwu; pu ituwikiy aw Yanhtii kitaqw, pam panhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Noqw Jesus put navotqe, put aw k̇ātayta; nihqe namtökt, put aṅk hinnumyaqamuy amumi paṅqawu: Nu umumi pas paṅqawni: Pas nu qa haqam Israel‐sinmuy amuhpe yan qapēvewnit tuwa, pas qae. ");
INSERT INTO hopNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Noqw ima ayatiwyaqam ahoy kīve ökiqw, kurs pay tumal’aya tūtuyhqa pās qalaptu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Noqw qavoṅvaqw pam haqami kitsókit Nain yan mātsiwhqat aw’i; noqw wūhaknihqam put aw nánatuwnayaqam put ámumya, pu k̇aysiwhqam sínomu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Noqw pam kitsókit tuhpelayat aw hötsíwmi hayiṅwnaqw, pi hakim hakiy tāqat mokput tūamwisa, put yuat put‐sa tiyoti’ta; noqw pam koṅnalavu. Noqw sinom k̇aysiwhqam kīṅaqw wuhtit ámumya. ");
INSERT INTO hopNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Noqw Tutuyqawhqa put túwahqe put ōkwatuwhqe, aw paṅqawu: Qa pakmumuyaa. ");
INSERT INTO hopNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pu pam mokput awnihqe, hihta akw taviwisqat aw toṅo; noqw put yawwisqam sun hoṅva. Noqw pam paṅqawu: Tiyo, nu hapi ūmi paṅqawni: Qatuptuu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Noqw i’ hak as mokpu qatuptuqe, pahsat yuaativa. Noqw Jesus put yuyat aw put mātavi. ");
INSERT INTO hopNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Noqw puma sohsoyam tsawinhinhtotiqe, God pas hihtatotaqe, paṅqaqwa: Pas hak pavan God lavay’ayaat itamumi pitsíwta; pu’ hapi piw God sinomuy pohta, kitota. ");
INSERT INTO hopNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Noqw yan pam hinhtiqa Judea‐tutskwat aṅ ahsupoq yuaatiwa, pu Galilee‐tutskwat aṅ ahsupoq pīwu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Noqw John aw nánatuwnayaqam īit sohsok John āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Noqw John put aw nánatuwnaqamuy lȫqmuy nāmi wáṅwayhqe, amumi paṅqawu: Uma Jesus awnen aw paṅqawni: Ya um hak God lavay’ayaat pas pávannihqa hisat pítuniqa, hal sen pi itam hakiy sukw nuhtayyuṅwa? kítani. ");
INSERT INTO hopNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Noqw ōviy puma Jesus aw pítuhqe, John amumi hin tutaptaqat pan Jesus aw paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Noqw piw suhpahsat pam k̇aysiwhqamuy tūtuyyaqamuy qalaptsinta, pu hīhihta akw qa kwaṅwáhinyuṅqamuyu; pu nukpanhihikwsimuy akw tuyqawiwyuṅqamuy powata; pu qa postalyaqamuy k̇aysiwhqamuy pōsiyamuy tālawna, ");
INSERT INTO hopNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pahsat pu Jesus lavayhtiqe, John aw nánatuwnaqamuy amumi paṅqawu: Pay uma áhoynen, hihta aw yórikqey, pu navotqey John āawnani. Ima qapostalyaqam pōsiy tālawnaya; qayaktaqam nankwusa; tokoplelet tūtuyyaqam powaltoti; nanaqsöpt nanapta; so’pum ahoy tātayya; pu aṅ ókiwyaqam lomatuawit nanapta. ");
INSERT INTO hopNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Noqw inuhpe qa unaṅwmokqa hapi pas hahlayhpit epni. ");
INSERT INTO hopNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Noqw John tuaw’aymat ahpiyniqw, pahsat pu Jesus sinmuy amumi John yuaativaqe paṅqawu: Ya uma qayēsiwhpumi haqami hihta aw kuyvawisa, sen pi pāqavit hūk̇aṅwuy akw wayayataqat aw’i? ");
INSERT INTO hopNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Noqw ya uma hihta aw kuyvawisa, sen hakiy lomayuwsi’taqat aw’i? Meh, lolmat yuwsi’yuṅqam, qarurúmyesqam pi momṅwituy kīyamuy aṅ yēse. ");
INSERT INTO hopNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Noqw ya uma hihta aw kuyvawisa, sen hakiy God lavay’ayayat aw’i? Owi, noqw nu umumi paṅqawni: Pam hapi God lavay’ayayat epníhqe pas pávani. ");
INSERT INTO hopNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","It hapi pey’taqe pan lalvaya: Meh, nu hapi upyeve ituaw’aya ayatani; noqw pam uhsavo uṅ háqe’niqat aṅ qenitani, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Pi nu umumi paṅqawni: Pas momoymuy amuhpiy tihtiwyaqamuy amuṅaqw John kūyit akw tūtuvoylalawhqa pas pávani. Qa hak God lavay’ayaat put epnihqe pas pávani. Noqw pay God moṅwtunatyayat ep pas susqahimunihqa put epnihqe pas pávani. ");
INSERT INTO hopNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pi sohsoyam put aw tūqayyuṅqam, moṅwit eṅem sīvat ömalalwaqamuy amumum pay God‐sa súantaqat paṅqaqwa; nihqe John tuwiyat anwat kūyit akw tuvoylatoti. ");
INSERT INTO hopNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Noqw ima Pharisee‐sinom, tutavot aw tuvoti’yuṅqamuy amumum God tunatyayat qa kwusuyaqe, John ahpiy qa tuvoylatoti. ");
INSERT INTO hopNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Noqw Jesus paṅqawu: Ya sen nu pu’ qatsívaptsiwyuṅqamuy hihta enaṅ namimahtaknani? Ya puma hihta anyuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Puma tsātsakwmuy kihsonve yesqamuy amunyuṅwa. Puma nānami paṅqaqwa: Itam umuṅem lēlenyaqw, uma qa tīva; itam umuṅem tsaykitaqw, uma qa tsayku, kitota. ");
INSERT INTO hopNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Oviy pi John kūyit akw tūtuvoylalawhqa pítuhqe, pölavikit qa tūmoyta; piw ovavalat qa hīhiko; noqw uma paṅqaqwa: Pam nukpanhikwsit akw tuyqawiwta. ");
INSERT INTO hopNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Noqw nu’ Sinot Tiat pítuhqe tūmoyk̇aṅw, pu hīhikq, uma paṅqaqwa: Is uti hunuk̇a, wine pas qa öyṅwu, moṅwit eṅem sīvat ömalalwaqamuy, pu qaanhinwisqamuy kwatsiamu! kitota. ");
INSERT INTO hopNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Noqw pay pi suan unaṅwtalwuwni aniwniy ahpiy lolmat namtakni’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Noqw haqawa Pharisee‐sino Jesus tūtsama. Noqw pam put kīyat aw pákihqe, tunösvoñat aw qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Noqw meh, hak pep kitsókive wuhti qaanhinmaqa yaw Jesus Pharisee‐sinot kīyat ep tunösvoñat aw qátuhqat navota. Pahsat pu pam tataṅpit aṅ kwaṅwáhovaqtuqat wihkuyit kūyiwtaqat kwusiva. Pam tataṅpi hihta alabaster‐owat aṅqw yukiwta. ");
INSERT INTO hopNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Noqw wuhti okiw pakk̇aṅw, put kukveq wunuk̇aṅw, pahsat posvalay akw put kukyat pāhomhtivak̇aṅw hȫmiy akw put aṅ hönta, nit kukyat tsohtsonat, wihkuyit akw put lelwi. ");
INSERT INTO hopNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Noqw Pharisee‐sino put tūtsamqa put aw tātayhqe, unaṅwpeq paṅqawu: Pas k̇a as i’ tāqa God lavay’ayaatnen, i’ wuhti put aw tóṅokqa hákiynihqat, pu hin hak hintaqat soon qa navotni; pam pi qaanhinmaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Noqw Jesus lavayhtiqe, put tūtsamqat aw paṅqawu: Simon, nu as ūmi hiṅqawni. Noqw pam paṅqawu: Tūtutuqaynaqa, paṅqawuu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Noqw pam paṅqawu: Ura hak tāqa sīvat tūnasimokhuylawu. Noqw hakim lȫyöm put aw hihta pöiwta; suhk̇a put aw tsivót‐sikip sunat sīvat pöiwta; noqw suhk̇a pakwt sīvata. ");
INSERT INTO hopNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Noqw puma kurs hihta sisviniqw pam pumuy lȫqmuy amumi put pantaqat qe’wataqe paysoq ayo yuku. Taay, kurs nuy āawnaa, Ya uṅniqw pumuy amuṅaqw sen himuwa put pas pavan aw unaṅway’tani? ");
INSERT INTO hopNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Noqw Simon lavayhtiqe aw paṅqawu: Pas nuyniqw soon k̇a qa pam suswuhak ayo yúkuhqat pamwani. Noqw Jesus put aw panqawu: Um suan aw wūwa. ");
INSERT INTO hopNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pu pam wuhtit aw namtökt, Simon aw paṅqawu: Ya um it wuhtit aw qa tayta? Nu uhkiy aw pakiqw, um ikukuy eṅem nuy qa kuyna; noqw i’ pi pas posvalay akw ikukuy pāhomht, hȫmiy akw aṅ hȫna. ");
INSERT INTO hopNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Um nuy qa tsohtsona, noqw i’ wuhti nuy pakiqw, qa sūs ikukuy tsohtsona. ");
INSERT INTO hopNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Um iqötöy wihkuyit akw qa lelwi; noqw i’ wuhti ikukuy wihkuyit kwaṅwáhovaqtuqat akw lelwi. ");
INSERT INTO hopNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Noqw ōviy nu ūmi paṅqawni: Put qaantsakpiat nihtiwtaqa put ahpiy ayo yukilti, kurs pam inumi pas unaṅway’taqw ōviy’o. Nīk̇aṅw hakiy aw qa wūhak qe’watiwk̇aṅw ayo yukiltiqw, pam pay qa pas God aw unaṅway’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pu pam wuhtit aw paṅqawu: Pay uhqaanhtipu uhpiy ayo yukiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Noqw ima put amum tunösvoñat aw yesqam pahsat unaṅwpeq paṅqaqwa: Ya i’ haknihqe, hikis hakiy qaanhtipuyat put ahpiy ayo yúkuniqey anta. ");
INSERT INTO hopNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Noqw pam wuhtit aw paṅqawu: Uhqapevewni uṅ ayo tavi. Um qa hin unaṅway’k̇aṅw nímani. ");
INSERT INTO hopNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pu it ahpiy pantaqw pam, tutskwat aṅ ahsupoq nakwsu, wuhkokitsókinawita, pu pay kitsókinawita; nihqe God mönwtunatyayat ahpiy lomatuawit nuhtumi yuaatinuma. Noqw ima pakwt lȫq sihk̇ay’taqam put aw nánatuwnayaqam put ámumya. ");
INSERT INTO hopNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Noqw hakim mómoyam piw put amum hinnumya. Pumuy amuṅaqw haqawatuy amuhpiy pam qalomáhihikwsimuy ipwa, pu haqawatuy hihta akw qa pasiwyuṅqw, pam pumuy qalaptsina. Pu pam hakiy wuhtit Mary yan mātsiwhqat aṅqw tsáṅe’nihqamuy nukpanhihikwsimuy ipwa. Pam hak wuhti Magdala‐kitsókit ep sinoiwta. Noqw pam put amum hinma. ");
INSERT INTO hopNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Pu hak Joana, Moṅwi Herod hihta himuyat aw tunatyawtaqat Chuzat nȫmaata, pu hak Susana, noqw pu ahpiy wūhaknihqamu. Ima mómoyam hihta himuy akw put paaṅwantota. ");
INSERT INTO hopNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Noqw k̇aysiwhqam sinom put aw tsovalti; pu ahsupoq kitsókit aṅqw sinom put aw öki. Noqw tūwutsit hihta tuawi’taqat yuaaykuqe amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Hak tāqa tsalakin’uyto. Nihqe pam uylawhq, pēhu poshumi pöhpava yēvaya. Noqw sinom put atsmi wukukuykuyaqw, pu súmawuy aṅ masay’yuṅqam put soswa. ");
INSERT INTO hopNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Noqw pēhu pik̇aqlöva yēvaya; nihqe panis kuyvat, pay tsahkwi, qa halasaminiqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Noqw pēhu kutqölpa yēvaya. Noqw kūta amum aṅ kuyvaqe, put lakna. ");
INSERT INTO hopNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Noqw pēhu lomatutskwava lö́hö, nihqe kūkuyvaqe, tsivót‐sikip sunat hóyokiwtaqat aniwnaya. Yan pam lavayhtit, pu a’nö paṅqawu: Tuqayvastotaa, uma pi naqvuy’yuṅwa! ");
INSERT INTO hopNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Noqw put aw nánatuwnayaqam put tūviṅtotaqe, aw paṅqaqwa: Noqw ya i’ tūwutsi hihta tuawi’ta? ");
INSERT INTO hopNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Noqw pam paṅqawu: Uma hapi God moṅwtunatyayat ep himu tupkiwyuṅqat māmatsyaniqat pam pantaqa umuṅem yukiwta. Nīk̇aṅw imuy pay amumi pam tūwutsit akw yuaatiwa. Puma as aw tayk̇ahk̇aṅw, soon tutwani; pu tūqayk̇ahk̇aṅw, soon māmatsyani. ");
INSERT INTO hopNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Noqw tūwutsi it hapi tuawi’ta: Poshumi hapi God lavayiata. ");
INSERT INTO hopNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Noqw pöhpava lö́hökqa hapi imuy amunyuṅwa. Hakim lavayit as nanaptaqw, āpiy pay Nukpana pite’, unaṅwayamuy aṅqw put ipwaṅwu, nāphisat k̇a puma put tūtuptsiwe’, ayo nö́ṅakniniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Noqw pik̇aqlöva lö́hökqam hapi imuy amunyuṅwa. Hakim lavayit nanapte’, hahlayk̇ahk̇aṅw put kwusuyaṅwu. Noqw pay lavayi pumuy unaṅwayamuy aṅ qa hūrs ṅapkiwtaqw, puma as hihsavo tuptsiwni’yuṅt, unaheppit aw ök̇e’, pay ayo lasyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Noqw kutqölpa lö́hökqa hapi imuy amunyuṅwa. Hakim lavayit nanaptaqe, pahpiy aṅ hinwisa. Nihqe puma yep qatist aw tunatyawk̇ahk̇aṅw, pu hihta himuy‐nik̇aṅw pu kwaṅwáewhpit ep hahlayk̇ahk̇aṅw, lavayit qa aw tunatyawyuṅqw, pam qa hihta aniwnaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Noqw lomatutskwava lö́hökqa hapi imuy amunyuṅwa. Hakim lavayit nanapte’, lomaunaṅway’k̇ahk̇aṅw, qa paysoq put kwusuyaṅwu. Noqw puma nakwhani’yuṅqw, lavayi unaṅwayamuy epeq hihta aniwnaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Qa haq pi hak wihqöhit úwiknat, tsaqaptat aqw kuhtaṅwu, pu sen puvuwhpiy atpipoq put pánaṅwu. Pam qa panhtit, tsotsókpiyat aqw put tsok̇aṅwu, ep yuṅtaqam tālat aw tāyuṅwniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pi qa himu tupkiwtaqa qa mātaqtini; piw qa himu tupkiwtaqa qa nanaptiwe’, aṅqe’ kúrukni. ");
INSERT INTO hopNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Paniqw ōviy uma tunatyawk̇ahk̇aṅw tūqayyuṅwni. Pi himuy’taqat hapi aw himu noiwni; noqw pay ṅastanihqa sohsok himuy kwayhni, hikis as pay suhpan hihta himuy’taqeyu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pahsat pu put tupkomat yuy amum pep öki; nīk̇aṅw kurs hin put aw ökini, sinom aw hūrs tsovawtaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Noqw hakim put āawnayaqe paṅqaqwa: Uhtupkom uṅuy amum ihpaq hoṅk̇ahk̇aṅw, as ūmi hiṅqaqwaniqey nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Noqw pam lavayhtiqe pumuy amumi paṅqawu: Ima hakim God lavayiyat aw tūqayk̇ahk̇aṅw, put aṅ hinwisqam hapi itupkomu, pu íṅuu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Noqw pam hisat aw nánatuwnayaqamuy amumum pākihut aqw pákihqe, amumi paṅqawu: Itam kurs wuhkovatuphat ayoqwat aqw nö́ṅakni noqw puma paṅqw hoyóyoykuya. ");
INSERT INTO hopNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Noqw pumuy pāvaqe hoyóyoytotaqw, pam puwva. Noqw patuphavaqe a’nö hukvaqw, amumiq pāhu ohpokq, puma tusiewhtoti. ");
INSERT INTO hopNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Noqw puma Jesus awyaqe, tātaynayaqe, paṅqaqwa: Moṅwi, Moṅwi, itam so’ni. Pahsat pu pam qatuptut, hūk̇aṅwuy, pāhut a’nö hoṅvantaqat enaṅ mēwa. Noqw pam qe’tiqw pas sutmakma. ");
INSERT INTO hopNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Noqw pam pumuy amumi paṅqawu: Uma hinoqw qa tuptsiwni’yuṅwa? Noqw puma tsātsawnaqe, k̇ātayyuṅqe nānami paṅqawu: Is uti i’ hak himu tāqa! Hikis pi pas hūkaṅwuy pāhut enaṅ mēwaqw, puma aw tūqayyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pahsat pu puma Galileet ayaṅqwat Gadaret ep sinmuy tutskwayamuy ep öki. ");
INSERT INTO hopNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Noqw pam tutskwat aw yamakq, hak tāqa kīṅaqw put ahsawva. Pam hak wūyavo nukpanhihikwsimuy akw tuyqawiwtaqe qa yuwsi’ta; piw qa kīve qatut, tuamtuhsöt aṅ ki’tinuma. ");
INSERT INTO hopNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Noqw pam hak Jesus túwahqe, a’nö hiṅqawht, put atpipo nātuvat, pas tönay aṅqe’ paṅqawu: Ya um nuy hinhtiniqat nāwakna, Jesus, uma pas Sus’oveqnihqat God Tíata? Um okiw nuy qa hintsanni. ");
INSERT INTO hopNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Tuyoy’ewakw hikwsit tāqat aṅqw yámakniqat Jesus aw paṅqawhq, ōviy yan lavayhti.) As sivanamiqlölöt akw put somyat, put hok̇asomyat pu tūtuwala. Noqw pay nukpanhikwsi qa sūs tāqat tuyqawve’, somhpiyat tutkitat, qayēsiwhpumihaqami put lālayṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Noqw Jesus put tūviṅtaqe aw paṅqawu: Ya um hin mātsiwa? Noqw pam paṅqawu: Qaan’ewakw hintaqamu, yan’i. Pi k̇aysiwhqam nuhpanhihikwsim tāqat ahsonmi yuña. ");
INSERT INTO hopNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nihqe pam pumuy haqami a’nö hötsit qa aqw lālayniqat puma Jesus aw nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Noqw pep tsomot ep qaan’ewakw hintaqam pitsōtim nōnova. Noqw pitsōtimuy amuhsonmi yuṅniqat pam nakwhaniqat ōviy puma Jesus aw ö’qala. Noqw pam pumuy nakwhana. ");
INSERT INTO hopNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Noqw pahsat pu nukpanhihikwsim tāqat aṅqw nöṅakt, pitsōtimuy amumi yuña; noqw puma pan tōnawtaqam a’nö yuhtukqe, wuhpatpelat aṅ patuphamiq tsotsó’yaqe paöysoa. ");
INSERT INTO hopNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Noqw pumuy nopni’yuṅqam hiniwhtiqw aw yórikyaqe, watqaqe, kīve put tūawvaya, pu aṅqe’ tutskwavaa. ");
INSERT INTO hopNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Noqw pahsat pu sinom hiniwhtiqat aw kuyvawisa. Nihqe puma Jesus aw ö́kihqe, tāqat tutwa, kurs nukpanhihikwsim put aṅqw nöṅakq, pam yuwsi’k̇aṅw, suyan wuwni’k̇aṅw Jesus kukveq qatu. Noqw puma pas tsātsawna. ");
INSERT INTO hopNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Noqw hakim hiniwhtiqat aw yórikyaqam i’ hak as nukpanhihikwsimuy akw tuyqawiwtaqa hin qalaptuqat aw kuyvawisqamuy āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pahsat pu sohsoyam Gadara‐sinmuy tutskwayamuy aṅ ahsupoq yesqam pam pumuy amuṅaqw ahpiyniqat Jesus aw ö’qalya, puma pas pavan wuhpukyaqe ōviy pan lavayhtoti. Noqw pam pākihut aqw wūvi, haqaqw pítuhqey aqw áhoyniqee. ");
INSERT INTO hopNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Noqw i’ tāqa as nukpanhihikwsimuy akw tuyqawiwtaṅwuqa as Jesus ámumniqey aw ö’qala. Noqw pay pam put hōnaqe aw paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Um uhkiy awnen, God uṅem hihta qaöwíhinhtiqat lalvayni. Noqw pam ahpiynihqe, hin Jesus put aṅem hihta qaöwíhinhtiqat kitsókive ahsupoq tunvotna. ");
INSERT INTO hopNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pu Jesus ahoy pituqw, sinom hahlayk̇ahk̇aṅw put ahsawvaya, puma put nuhtayyuṅqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Noqw meh, hak tāqa Jairus yan mātsiwhqa, tsotsvalkive moṅw’iwtaqa, Jesus aw pítuhqe, put kukmiq nātuvat, pam kīyat awniqat put aw ö’qala. ");
INSERT INTO hopNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pam sūkw manti’taqw, pam okiw mómoki. Māna pakwt lȫq sihk̇ay’taqat pahsa’haqam yahsaṅwni’ta. Noqw Jesus put ámumniqw sinom put aṅqw hūrs homimitiwisa. ");
INSERT INTO hopNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Noqw hak wuhti pakwt lȫq sihk̇ay’taqat yahsaṅwuy aṅ uṅwáy’taqa pep nuhtuma. Okiw pam as tūtuhiktuy amuhpa’ sohsok hihta himuy sohsoko. Noqw qa hak put qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Noqw pam hak wuhti Jesus ahkwayñavo aw pítuhqe, yuwsiyat qalawṅwayat aw toṅo. Noqw pahsat pay put uṅwáat súlawhti. ");
INSERT INTO hopNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Noqw Jesus paṅqawu: Ya hak inumi toṅo? Noqw sohsoyam qa púmayaqey paṅqaqwaqw, pu Peter suṅwámuy amumum put aw paṅqawu: Moṅwi, pi sinom k̇aysiwhqam ūmi homimitotaqw, pas piw hak ūmi tóṅokqat um tūviṅlawu? ");
INSERT INTO hopNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Noqw Jesus paṅqawu: Pay pas hak inumi toṅo; ōviy pi inuhpiy öqala yamakq, nu navota. ");
INSERT INTO hopNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Noqw wuhti pas kurs hin qa nātuwiwniqey navotqe, okiw tururutik̇aṅw, awnihqe, put atpipo nātuvat, aw paṅqawu; hinoqw pam put aw tóṅokqey sohsokmuy sinmuy amutpik put āawna, pu hin pam suqlaptuqeyu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Noqw Jesus put aw paṅqawu: Itii, pay um hahlayhtini. Pay uhqapevewni uṅ pās qalaptsina. Um qa hin unaṅway’k̇aṅw nímani. ");
INSERT INTO hopNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Noqw nāt pam yuaataqw, hak tsotsvalkit aw moṅwit kīyat aṅqw pítuhqe, moṅwit aw paṅqawu: Pay okiw uhti mōki; pay um Tutuqaynaqat qa aw nunuiṅni. ");
INSERT INTO hopNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Noqw pay Jesus put navotqe, aw paṅqawu: Pay um qa hin unaṅway’tani; pay um panis‐sa tuptsiwni’tani; pay soon pam qa qalaptuni. ");
INSERT INTO hopNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Noqw pam kīmi pákihqe, sinmuy yuṅniqat pumuy mēwa. Hal pay Peter, pu James, pu John, pu mānat náat‐nit pu yuat, puma aw yuṅniqat paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Noqw kīve pay yuṅqam sohsoyam tsaykik̇ahk̇aṅw ókiwlalwa. Noqw pam amumi paṅqawu: Uma qa tsaykitani, Pam qa mōki; pi pam pūwi, kita. ");
INSERT INTO hopNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Noqw puma aw tutsíwtsuyhti, suyan pi mokpuniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Noqw pam sohsokmuy paṅqw lālayht, mānat māyat ṅuat, aw paṅqawu: Māna, wunuptuu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Noqw put hikwsiat ahoy aw pituqw, pay pahsat pam qatuptu. Noqw puma hihta put nopnayaniqat pam amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Noqw put naat yuyat amum k̇ātayta. Noqw Jesus pay puma pep hiniwhtiqat pas qa hakiy āawnaniqat amumi qaöwítutapta. ");
INSERT INTO hopNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pahsat pu pam pakwt lȫq sihk̇ay’taqamuy put aw nánatuwnayaqamuy sūmi wáṅwayhqe, sohsokmuy nukpanhihikwsimuy amumi pumuy öqalhuyta, pumuy amumi tuyqawi’yuṅwniqata; pu puma hīhihta akw tūtuyyaqamuy qalaptsintotaniqat pumuy pan öqala. ");
INSERT INTO hopNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nihqe pam pumuy God moṅwtunatyayat yuaatinumyaniqat aṅqe’ ayata, pu tūtuyyaqamuy qalaptsintiwisniqata. ");
INSERT INTO hopNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nihqe pam pumuy amumi paṅqawu: Uma qa hihta hink̇ahk̇aṅw, aṅqe’ nankwusani. Qa natöṅpi’wisni, qa tukpuy’wisni, qa nitk̇ay’wisni, qa sīvay’wisni; uma qa lȫqmuy napnay’wisni. ");
INSERT INTO hopNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pu uma haqami kīmi yuñe’, pep yesmantani, nit pu paṅqw ahpiyyamantani. ");
INSERT INTO hopNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pu hak umuy qa pās oyaqw, uma put kitsókit aṅqw ahpiyye’, umuhkukuy aṅqw qöat tsatswiyamantani. Pam pumuy amunkiwakw hihta sutuawi’tani. ");
INSERT INTO hopNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Noqw puma aṅqe’ kitsókinawit nankwusaqe, lomatuawit yuaatinumya, pu sohsovik sinmuy qalaptsintiwisa. ");
INSERT INTO hopNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Noqw Jesus hīhihta hinhtiqat Moṅwi Herod navotqe, kurs hinhtini, yaw John mokiwuy aṅqw ahoy tātayhqat haqawat paṅqaqwaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Noqw pētuyniqw yaw Elias mātakti; pu pētuyniqw yaw hisat God lavay’aymuyatuy amuṅaqw himuwa ahoy tātayi. ");
INSERT INTO hopNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Noqw Herod paṅqawu: Ura nu John qötötku; noqw ya i’ hákiyniqw nu īit navota? Nihqe ōviy as pam put aw yórikniqey nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Noqw ayaiwyuṅqam ahoy ö́kihqe, hihta hinhtotiqey sohsok Jesus āawnaya. Noqw pam pumuy tsamk̇aṅw kitsókit Bethsaida yan mātsiwhqat aqlavo qayēsiwhpumi haqamii. ");
INSERT INTO hopNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Noqw sinom put nanaptaqe aṅkya; noqw pam pumuy amumi unaṅwtapqe, God moṅwtunatyayat amumi yuaata, pu okiw as qalaptuyaniqey tunatyawyuṅqamuy qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Noqw tapkiwmaqw ima pakwt lȫq sihk̇ay’taqam put awyaqe aw paṅqaqwa: Um sinmuy aṅqe’ hōnaqw, puma kitsókiva nankwusani, pu tutskwavaa; nen paṅqe yesve’, hihta tunöstutwani; taq itam yep qayēsiwhput epya. ");
INSERT INTO hopNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Noqw pam pumuy amumi paṅqawu: Huvam pumuy nopnayaa. Noqw puma paṅqaqwa: Itam panis tsivot pölavikit mumriṅput oyi’yuṅwa, pu lȫqmuy pākiwhtuyu. Pay panis pi as itam imuy sohsokmuy amuṅem tunöstuiwise’‐sa pi panhtotini. ");
INSERT INTO hopNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Puma tsivót‐sikip sōmorit pahsa’haqam tahtaqtyaqw ōviy’o. Noqw pam put aw nánatuwnayaqamuy amumi paṅqawu: Uma lȫp‐sunat pakwt sihk̇ay’taqamuy yesvanayani, pu aqwhaqami paṅsa’ uma yesvanayani. ");
INSERT INTO hopNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Noqw puma panhtotiqe, sohsokmuy pan yesvanaya. ");
INSERT INTO hopNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pahsat pu pam tsivot pölavikit lȫqmuy pākiwhtuy enaṅ ömahtat, ōmiq tayk̇aṅw, put ep hahlaytit, yóṅoyhtat, put aw nánatuwnayaqamuy amumi oya; noqw puma sinmuy amuhpa’ o’ya. ");
INSERT INTO hopNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Noqw puma nȫnösaqe sohsoyam ȫöya. Noqw puma aṅ yóṅoyhput akwsiṅqat tsovalayaqe, pakwt lȫq sihk̇ay’taqat hoaput aṅ opomnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Noqw pay ephaqam pam put aw nánatuwnayaqamuy amumum haqam nālanik̇aṅw, God aw nāwakna. Nihqe pam yúkuhqe, pumuy tūviṅtaqe amumi paṅqawu: Ya sinom nuy hákiynihqat paṅqaqwa? ");
INSERT INTO hopNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Noqw puma lavayhtotiqe paṅqaqwa; Um yaw John kūyit akw tūtuvoylalawhqanihqat haqawat paṅqaqwa; noqw haqawatuyniqw yaw um Elias; noqw pētu paṅqaqwaqe, yaw hisat God lavay’aymatniṅwuqamuy amuṅaqw himuwa mokiwuy aṅqw ahoy tātayhqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Noqw pam pumuy amumi paṅqawu: Noqw úmuyniqw nu’ hak’i? Noqw Peter lavayhtiqe aw paṅqawu: Um hapi Christ, God aṅqw Moṅw’asi’taqa. ");
INSERT INTO hopNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Noqw pam pumuy pās mēwaqe, puma qa hakiy put āawnayaniqat amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pu amumi paṅqawu: Nu’ Sinot Tiat pas kurs hin hīhihta aṅ qa k̇ānavotni. Ima wukw’a’yat pi nuy tūvayani, God awwat mohpeq momṅwituy amumum‐nik̇aṅw, pu tutavot tūtutuqaynayaqamuy amumuma; nen nuy nīnayani; noqw pāyis tālat ep nu ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pu pam sohsokmuy amumi paṅqawu: Inuṅk hinmaniqey nāwaknaqa nawus soon qa nātatamhtat, talöṅwiwmaqat aṅ nahoylehtsiy īkwiltat, inuṅkmantani. ");
INSERT INTO hopNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Taq hak qatsiy ayo táviniqey nāwaknaqa hapi put kwayhni; pu ason hak haqam inuṅem qatsiy kwayhqa tuyqawvani. ");
INSERT INTO hopNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Puyaw as sino tūwaqatsit sohsok himuy’vak̇aṅw, nāp qatsiy kwahe’, pu sen tūviwe’, hin pam put akw moṅvastini? ");
INSERT INTO hopNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ispi hak nuy Sinot Tiyat, pu ilavayiy hahmanqw put hapi nu hahmanni, hisat nu pite’, pas hímunihqey pan namtaknee, pu Ina, qahováriwyuṅqamuy hoṅvia’yatuy amumum nuy pas k̇aptsi’taq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nīk̇aṅw nu umumi pas súaṅqawni: Ima haqawat yep hoṅqam soon nāt mokiwuy ep ökit, pay God moṅwtunayayat aw yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","It ahpiy nanalsikishaqam talq, pam Peter‐nit, John, pu James, pumuy tsamk̇aṅw, nāwaknaniqe haqami tūkwimiq’a. ");
INSERT INTO hopNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Noqw nāt pam nāwakintaqw, pitsáṅwaat alöṅti; noqw yuwsiat qȫtsatiqe pas talqaqsala. ");
INSERT INTO hopNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Noqw meh, hakim lȫyöm tāqat pepeq put amum yuaata, hak Moses‐niqw pu Elias; ");
INSERT INTO hopNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ima hakim lolmat tālawṅwat pitsáṅway’k̇aṅw mātaqtiqe, Jesus amum yuaata. Pam hin Jerusalem‐kitsókit epeq God tunatyayat aw antsane’, yaṅqw qatsit ahpiyniqat yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Noqw Peter‐niqw pu put ámumyaqam pūwiwuy akw maṅuiwyuṅwa, nīk̇aṅw puma havivok̇alyaqe put lolmat pitsáṅwayat aw yórikya, pu lȫqmuy tāqatuy put amum wunuwtaqamuy amumi. ");
INSERT INTO hopNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Noqw puma pay put aṅqw nakwsuniqw, Peter Jesus aw paṅqawu: Tūtutuqaynaqa, pas hapi itam yépeqyaqw pam itamuṅem lolma. Himu as ōviy itam payhp kistotani sukw úṅem‐nit, sukw Moses éṅem‐nit, pu sukwat Elias éṅemi, pam kíta, hiṅqawhqey qa mātsi’k̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Noqw nāt pam yan hiṅqawlawhq, ōmaw pumuy nākwapnaqw puma tsawiniwk̇ahk̇aṅw, ōmawuy aw yuña. ");
INSERT INTO hopNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Noqw ōmawuy aṅqaqw hakiy tönaat paṅqawu: I’ hapi pas aw iunaṅwa Itii; put uma aw tuqayvahsi’wisni. ");
INSERT INTO hopNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Noqw hakiy lavayyuk̇uqw, pay Jesus pep nālaniqw puma aw yórikya. Noqw pay puma put pas qa lavaytaqe, hin yórikyaqey pas qa hakiy āawnaya ephaqamo. ");
INSERT INTO hopNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Noqw qavoṅvaqw, pumuy tūkwiṅaqw hanqw, k̇aysiwhqam sinom Jesus ahsawvaya. ");
INSERT INTO hopNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Noqw meh, hak tāqa sinmuy amuṅaqw tsa’lawhqe paṅqawu: Tutuqaynaqa, um as itiy tiyot ókwatuwni; taq nu pas put‐sa ti’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Noqw meh, qalomáhikwsi put ṅuaqw, pam pahsat pay a’nö töqtit, homimiykuk̇aṅw moaṅaqw qötmokiwtaṅwu. Noqw pam put okiwsane’, pēp qa mātapṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Noqw as ūmi nánatuwnayaqam hikwsit tiyot aṅqw ayo hóroknayaniqat nu amumi nāwaknaqw, pay puma kurs soon panhtotini, kita. ");
INSERT INTO hopNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Noqw Jesus lavayhtiqe paṅqawu: Is ohi, uma qatuptsiwni’yuṅqam nukushinyunqamu! Ya nu hihsavohaqam umumum yank̇aṅw umuy maqsonlawni? Pew uhtiy wīkii. ");
INSERT INTO hopNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Noqw nāt pam awniqw pay nukpanhikwsi tiyot tūvaqe, put a’nö homimiykuna. Noqw Jesus tuyoy’ewakw hikwsit mēwaqe, tsākw qalaptsinat, nayat aw put ahoy tavi. ");
INSERT INTO hopNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Noqw puma sohsoyam God a’nö öqalayat ep aw k̇ātayyuṅwa. Noqw nāto puma nanáp sohsok hihta Jesus hinhtiqat ep k̇āwuwantotaqw, pam put aw nánatuwnayaqamuy amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Uma īit lavayit hapi u’ni’yuṅwni. Nu’ Sinot Tiat hapi nāt sinmuy öqalayamuy aw mātaviwni. ");
INSERT INTO hopNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Noqw pay puma it lavayit qa māmatsya. Pam pumuy amumi tupkiwtaqw, ōviy kurs hin puma put mātsi’yuṅwni. Noqw puma as Jesus put tūviṅtotanik̇aṅw nánahtsopya. ");
INSERT INTO hopNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Noqw puma yuaatotaqe, pumuy amuṅaqw haqawa pas pávanihqat ep nāṅwuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Noqw Jesus pumuy unaṅwpeq tunatyayamuy mātsi’taqe, hakiy tsākw tsöpahtat, naqlap tavi; ");
INSERT INTO hopNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nit pumuy amumi paṅqawu: Hak hapi inatṅwaniy aṅ it tsākw pās távihqa nuy hapi pās távini; pu nuy pās távihqa nuy aṅqw távihqat hapi pās távini. Pi umuṅaqw qanāhihtay’taqa hapi suspavanni. ");
INSERT INTO hopNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Noqw John lavayhtiqe paṅqawu: Moṅwi, itam hakiy tāqat tutwa. Kurs pam uhnatṅwaniy aw yank̇aṅw nukpanhihikwsimuy nuhtuṅaqw ipwanta; noqw itam put mēwaya, pam qa itamum uṅk hinnumqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Noqw Jesus put aw paṅqawu: Uma qa mēwantotani; pay qa itamuhpew’iwtaqa itamumniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Noqw pam ōmi wīkiwniqat aw pítutoqw, pam Jerusalem aqw sutuktaniqey su’qalti. ");
INSERT INTO hopNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nihqe pam aṅwu tuaw’aymuy napyeve aqw ayata; noqw puma ahpiyyaqe, Samariat ep sinmuy haqam kitsókiyamuy aw öki, haqam eṅem qenitotaniqee. ");
INSERT INTO hopNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Noqw pay sinom put qa tsúyakya, sumataq pam Jerusalem aqw tunatyawmaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Noqw lȫyöm put aw nánatuwnaqam, James‐niqw, pu John, puma pan yórikqe paṅqawu: Tutuyqawhqa, um as itamuy pan nakwhanaqw, itam Elias anhte’ paṅqawhq, ōṅaqw ūwiṅw hāwe’ pumuy taqtsoknani. ");
INSERT INTO hopNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Noqw pam namtökt pumuy qöhqöyhqe, amumi paṅqawu: Uma hihta hikwsit aṅ hinmaqey qa mātsi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pi nu’ Sinot Tiat sinmuy qatsíyamuy qa hovalaniqe pitu, pi nu pumuy ayo óyaniqe ōviy pitu, kita. Noqw puma ahpiy sutsvo kitsókimiya. ");
INSERT INTO hopNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Noqw pumuy ahpiy haqamiyaqw, hak put aw paṅqawu: Tutuyqawhqa, nu uṅ haqaminiqw uṅkmantani. ");
INSERT INTO hopNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Noqw Jesus put aw paṅqawu: Pay ima sisik̇ahtayht haqe’ qölöy’yuṅwa, pu súmawuy aṅ masay’yuṅqam totokpi’yuṅwa; noqw pi nu’ Sinot Tiat haqam iqötöy nāsuṅwnaniqey ṅastaa. ");
INSERT INTO hopNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pu pam sukwat aw paṅqawu: Inuṅki. Noqw pam paṅqawu: Tutuyqawhqa, um nuy nakwhanaqw, nu mohti inay amht, pu’ uṅkni. ");
INSERT INTO hopNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Noqw Jesus put aw paṅqawu: Pay pi so’qamuy amunyuṅqam ason amuṅaqw so’pumuy amyani. Noqw um ahpiynen God moṅwtunatyayat yuaatinumni. ");
INSERT INTO hopNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pu piw suhk̇a put aw paṅqawu: Tutuyqawhqa, nu uṅk hinmani. Noqw um nuy nakwhanaqw, nu mohti ikiy ep yesqamuy amuminen öqalat, pu’ uṅkni. ");
INSERT INTO hopNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Noqw Jesus put aw paṅqawu: Hak pāsay qöritivat, ahoy taymaqa God moṅwtunatyayat aw qa ápiyniqey anta. ");
INSERT INTO hopNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","It atsve pu’ Tutuyqawhqa hakimuy payhp sunat pakwt sihk̇ay’taqamuy namorstaqe, lȫlöqmuy aṅqe’ ayata, puma kitsókinawit nankwusaniqata, pu tutskwavaa, Jesus haqaminiqey tunatyawmaqat paṅsoq haqamii. ");
INSERT INTO hopNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Noqw pam pumuy amumi paṅqawu: Pas as ūyi tukwsiwtaqa a’nöniqw, tumal’a’yat híkiyomu. Oviy uma Uyi’taqat aw pan nānawaknaqw, pam hakimuy tsovalayaniqat aw ayatani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Taay, uma aṅqe’ nankwusani. Meh, nu hapi umuy aṅqe’ ayatani. Noqw uma mamñatuy amún hakimuy kwēkwewhtuy amúnyuṅqamuy amuhpa’ hinnumyani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Uma qa sivamoki’wisni; piw qa tukpuy’wisni; qa totsmask̇ay’wisni. Uma qa sȫwu haqam hakiy aw yuaatotamantani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pu umuṅaqw lȫyöm haqam kīmi pake’, mohti paṅqawmantani: Nam yep kīvit kwakwhat yēsee. ");
INSERT INTO hopNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Noqw ason kurs hak pan tunatyawtaqa pep qatuqw, pay umuhkwakwha pep huruhtimantani. Pu kurs qa pantaqw, pay pam umumi áhoymantani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nen uma pep kīve qate’, hihta umuy nopnayaqw, put uma nösmantani, pu hikwmantani. Pay tumalay’taqa ahsatiy hihk̇ay’taṅwu. Uma qa paysoq kīnawit kīkinumtinumni. ");
INSERT INTO hopNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pu uma haqami kitsókimi pakiqw, umuy pās taviye’, hihta umumi tunösvoñahtotaqw, put uma nösmantani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nen uma pep tūtuyyaqamuy qalaptsintamantani; nen amumi paṅqawmantani: God moṅwtunatyaat umumi hayiṅw’iwta. ");
INSERT INTO hopNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pu kurs uma haqami kitsókit aw pakiqw, umuy qa pās taviyaqw, pep kitpiponen paṅqawmantani: ");
INSERT INTO hopNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Hikis pi umuhkitsokiy ep qöat itamumi hūrstiqat itam umunkiwakw tsatswiya. Noqw pay uma it navoti’yuṅwni: Pas as God moṅwtunatyaat umumi hayiṅw’iwta. ");
INSERT INTO hopNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Noqw nu umumi paṅqawni: Hisat God sinmuy amuṅem hin yukuqw, pep pu’ pep kitsókit ep sinmuy amuṅem is óhini. Put talöṅvaqat ep pep kitsókit ep sinom pas k̇ānanaptani, Sodom kitsókit ep sinmuy amuhpenihqee. ");
INSERT INTO hopNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","14","Nihqe pam paṅqawu: Is ohi, úmaa, Chorazin ep sínomu! Is ohi úmaa, Bethsaidat ep sínomu! Nu as umuhpa’ qatsá’ k̇ātatayhpit tumaltaqw, uma nāp umuhtunatyay aṅqw qa lasya. Oviy hisat hin yukiltiniqat aw pituqw umuṅem pas is óhini! Pep pu’ imuy Tyre ep sinmuy amuṅem‐nik̇aṅw pu Sidon ep sinmuy amuṅem umuhpenihqe pay soon pas nuhtsel’ewayni. Pi nu as pumuy amuhpa’ hisat k̇ātatayhpit tumaltaqw, puma soon qa anahaat yūyaht, qöhtsaptsomove yesvani. Pan puma namtaknayani, nāp tunatyay aṅqw lasyaqeyu. ");
INSERT INTO hopNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Noqw úmaa, Capernaum ep sínomu, ya uma ōmiq nātsok̇aya? Uma nāt maskimiq tūviwyani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nihqe pam put aw nánatuwnayaqamuy amumi paṅqawu: Umumi tūqaytaqa inumi hapi tūqaytani; pu umuy qahihtataqa nuy hapi qahihtatani; pu nuy qahihtataqa nuy aṅqw távihqat hapi qahihtata. ");
INSERT INTO hopNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Noqw ima payhp sunat pakwt sihk̇ay’taqam aṅqe’ nankwusaqe, hahlayk̇ahk̇aṅw ahoy ö́kihqe paṅqaqwa: Tutuyqawhqa, hikis pi pas nukpanhihikwsim itamumi tuqayvastota, itam uhnatṅwaniy aw yank̇ahk̇aṅw amumi paṅqaqwaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Noqw pam pumuy amumi paṅqawu: Nu Satan talwihpikit an ōṅaqw posqw tuwa. ");
INSERT INTO hopNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nu hapi imuy tsūtsu’tuy‐nik̇aṅw, pu putskohmokyuṅqamuy amumi wukukuykuyaniqat aw umuy öqalmaqa, pu tuwqat öqalayat sohsok aw’i. Noqw ōviy soon himu umuy tūhotani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nīk̇aṅw hīhikwsim umumi tuqayvastotaqat qa put ep uma hahlayyani. Pi umuhnatṅwani ōveqatsit ep pey’yuṅwa. Tis pi uma put hapi ep hahlayyani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Noqw pahsat Jesus hikwsiy aṅ hahlayhtiqe, paṅqawu: Kwakwhay Inaa, ōveqatsit‐nik̇aṅw pu tūwaqatsit aw Tutuyqawhqa, Kwakwhat pi um īit yantaqat aṅ wuwni’yuṅqamuy, pu qaūunatuy amumi tupki’tat, titipostuy amunyuṅqamuy amumi mahtakta. Pantani Inaa, pam hapi uṅniqw súanta. ");
INSERT INTO hopNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sohsoy himu Inay aṅqw inumi noiwa. Noqw hakiy God Tíyatnihqat qa hak navoti’ta, pas Náat‐saa; pu Naat hákiynihqat qa hak navoti’ta, pas put Tíat‐saa, pu Tiat, hakiy put mahtaktaniqw pam pīwu. ");
INSERT INTO hopNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pu pam put aw nánatuwnayaqamuy amumi namtökt, pay púmuy‐sa amumi paṅqawu: Hakim umuy hihta aw yórikyaqat aw yórikyaqam hahlayhpit epya. ");
INSERT INTO hopNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pi nu umumi súaṅqawni: K̇aysiwhqam God lavay’aymatniqw pu aṅ momṅwit umuy hihta aw yórikyaqat as aw yórikyaniqey nānawaknak̇ahk̇aṅw hapi qa aw yórikya, pu umuy hihta nanaptaqat as nanaptanik̇aṅw qa nanapta. ");
INSERT INTO hopNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Noqw meh, hak tutavot aw tuvoti’taqa wunuptut, put aw tuwantaniqe aw paṅqawu: Tūtutuqaynaqa, ya nu hihta hinhte’, qatsit qaso’taqat himuy’vani? ");
INSERT INTO hopNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Noqw Jesus put aw paṅqawu: Ya tutavot aṅ hin pey’ta? Um hin aṅ túṅwanta? ");
INSERT INTO hopNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Noqw pam lavayhtiqe paṅqawu: Um God Uhtutuyqawhqay sohsok uh’unaṅway akw aw unaṅway’tani, pu sohsok uhhikwsiy akw’a, pu sohsok uh’öqalay akw’a, pu sohsok uhwuwniy akw’a. Pu pas hin nāmi unaṅway’taqey pan uhsinosṅway aw unaṅway’tani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Noqw Jesus put aw paṅqawu: Pay um súaṅqawu. Yan um hinme’, soon qa qátuni. ");
INSERT INTO hopNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Noqw pay pam nēṅem qenitaniqey nāwaknaqe, Jesus aw paṅqawu: Noqw hak isinosṅwa? ");
INSERT INTO hopNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Noqw Jesus lavayhtiqe paṅqawu: Hak tāqa Jerusalem aṅqw Jerichot aqwniqw, hakim uuyiṅt put ṅuaya, pu put aṅ yuwsiyat poswayat, ȫputotat, ahpiyya, hihin taytaqat mātapyaqee. ");
INSERT INTO hopNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Noqw piw hak God awwat moṅwi paṅsoo; nihqe pam put aw yórikqe, pay put ehpeq yūmosaa. ");
INSERT INTO hopNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Noqw hak Levit ahpiy sino piw put an paṅso pítuhqe, put aw tātayht, pay piw ehpeq yūmosaa. ");
INSERT INTO hopNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Noqw hak Samariat aṅqw sino haqaminik̇aṅw, put haqam qatsqa aw pitu. Nihqe pam put túwahqe, put ōkwatuwa; ");
INSERT INTO hopNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nihqe put awnihqe, haqe’ hintsanyaqat aṅ somhta, wihkuyit wine enaṅ wutsk̇aṅwo; nihqe put nāp moropkoy aqw tsok̇at, pu yeyespimi put wīki; nihqe aw unaṅwtavi. ");
INSERT INTO hopNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pu ōviy qavoṅvaqw pam ahpiynik̇aṅw, sunat sīvat hóroknat, ki’taqat maqat, put aw paṅqawu: Um it tāqat aw tunatyaltini. Nen ason kurs um it epnihqe hóyokiwtaqat sohsokniqw, nu piw pite’, put ahoy ūmi sisvini, pam kita. ");
INSERT INTO hopNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Taay, ya uṅniqw imuy payhkomuy amuṅaqw himuwa tāqat tūhototaqat sinosṅwaata? ");
INSERT INTO hopNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Noqw pam paṅqawu: Pay hapi put ōkwatuwhqa. Pahsat pu Jesus put aw paṅqawu: Taa, Yupa, um put an hinmani. ");
INSERT INTO hopNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Noqw pumuy paṅ haqamiyaqw, Jesus haqami kitsókimi paki. Noqw hak wuhti, Martha yan mātsiwhqa, kiy ep put pās tavi. ");
INSERT INTO hopNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Noqw pam hakiy Mary yan mātsiwhqat tupkoy’ta. Noqw pam hak Jesus atpip qatuk̇aṅw put yuaataqw aw tūqayta. ");
INSERT INTO hopNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Noqw Martha hihta qaa’saqalqe qa suyan unaṅway’taqe, Jesus awnihqe aw paṅqawu: Tutuyqawhqa, pay itupko nuy mātapq, nu nāla hihta aw hintsaki. Noqw ya pam uṅniqw qa hinta? Um ōviy aw paṅqawhq, inumi unaṅwtapni. ");
INSERT INTO hopNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Noqw Jesus lavayhtiqe put aw paṅqawu: Martha, Martha, pas um hīhihta pis’oqhintaqe qa suyan unaṅway’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pay hak sūkw hihta aw tunatyaltimantani. Noqw Mary put nukṅwat namorsta. Soon pam put nawhkiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Noqw hisat pam haqam nāwaknaqe yukuqw, suhk̇a put aw nánatuwnaqa aw paṅqawu: Tutuyqawhqa, um as itamuy hin nāwakintotaniqat itamuy tutuwnani, ura John put aw nánatuwnayaqamuy hin tutuwnaqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Noqw pam pumuy amumi paṅqawu: Uma nānawakne’, kitotamantani: Itanaa, ōveqatsit ep qátuhqa, nam uhnatṅwani pas k̇aptsi’tiwaa. Nam uhmoṅwtunatyay aw pítuu. Nam uhtunatya tūwaqatsit ep pasiwhtii, ōveqatsit ep hin pasiwhtiqey pan’i. ");
INSERT INTO hopNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Um okiw nāqavo itamuy itahtunösmakiway huylawni. ");
INSERT INTO hopNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pu um okiw itahqaanhtipuy itamuhpiy ayo yúkuni; pay itam sohsokmuy itamuhpewi qaanhtotiqamuy amuhpiy put ayo yuykutiwisa. Pu um okiw itamuy unaheppit qa aṅ tsāmi’mat, hakiy qalolmat aṅqw itamuy ayo ōoyhtimani, pay yan’i. ");
INSERT INTO hopNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pu pam pumuy amumi paṅqawu: As kurs haqawa umuṅaqw kwātsi’te’ suhtokihaq put awnen, aw paṅqawni: Ikwatsi, um as payhkomuy pölavikit nuy nasimokmaqani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Taq ikwátsi waynumqe inuhpe pituqw, kurs nu hihta put nopnani, kítani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Noqw pam ahpaṅaqw lavayhte’ paṅqawni: Um nuy qa soontsahtsanni. Pay ikiy uhtsiwta; noqw itim inumum tōk̇a. Kurs nu hin uṅ máqaniqe ōviy qaqtuptuni, kítani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nu umumi paṅqawni: Pay soq pi pam put kwātsiatniqw, pam put qa máqani. Nīkaṅw pam put aw qatūqayhq, nawus pam qatupte’, put hihsa’haqam hintsanniqat pahsa’ put máqani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Noqw nu umumi paṅqwni: Uma hihta ōviy tūviṅtotani; nen uma put makiwyani. Uma hihta hepyani; nen tutwani. Uma pöṅö́ṅöykinayani; noqw umumi hötsíltini. ");
INSERT INTO hopNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pi hak hihta tūviṅtaqa hihta makiwṅwu; pu hepqa túwaṅwu; pu pöṅö́ṅöykinaqat aw hötsíltimantani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sen uma haqawa hakiy náatniqw, uhti ūmi pölavikit tūviṅtaqw, ya sen um put owat máqani? Sen pākiwuy ōviy tūviṅtaqw, ya sen um tsūat put máqani? ");
INSERT INTO hopNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Hal sen pi pam nöhut ōviy tūviṅtaqw, sen um putskohmoktaqat put āawnani? ");
INSERT INTO hopNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Noqw kurs pay as uma qalomáhink̇ahk̇aṅw umuhtimuy hihta nukṅwat huytotaniqey tuwi’yuṅwa. Noqw tis pas Umuna ōveqatsit ep qátuhqa put aw Qahováriwtaqat Hikwsit ōviy tūviṅtotaqamuy soon qa máqani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Noqw Jesus nukpanhikwsit hakiy lavayiyat nawhkiṅwuqat put aṅqw hórokna. Noqw nukpanhikwsi put aṅqw yamakq, qayuáataṅwuqa yuaayku; noqw sinom k̇ātayyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Noqw pay pumuy amuṅaqw haqawat paṅqaqwa: Pam nukpanhihikwsimuy moṅwíyamuy Beelzebub aw yank̇aṅw nukpanhihikwsimuy ipwanta. ");
INSERT INTO hopNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Noqw pētu put aw tuwantotaqw, pam k̇ātatayhpit hihta tuawi’taqat ōṅaqw pumuy amumi mahtaknaniqat put aw nānawkna. ");
INSERT INTO hopNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Noqw pay pam pumuy tunatyayamuy mātsi’taqe amumi paṅqawu: Haqam moṅwtunatya nehpewhtiqa soon qa kīqötini; pu kīvit nehpewhtotiqam nātsik̇e’, soon haqami ö́kini. ");
INSERT INTO hopNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Noqw ōviy kurs Satan nehpewhtiqw, ya hin put moṅwtunatyaat wúnuni? ");
INSERT INTO hopNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Noqw kurs nu Beelzebub aw yank̇aṅw nukpanhihikwsimuy ipwantaqw, ya umumi nánatuwnayaqam hakiy aw yank̇ahk̇aṅw pumuy ipwantota? Ason puma umuy atsáṅhkiye’, umuy suhputsnayani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nīk̇aṅw kurs pay nu God öqalayat akw nukpanhihikwsimuy ipwantaqw, suyan hapi God moṅwtunatyaat umumi pitsíwiwta. ");
INSERT INTO hopNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Pi tāqa hoṅvi tunipi’k̇aṅw kiy tūwale’, hihta himuy pās oyi’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nīk̇aṅw ason put epnihqe pavan hoṅvi pite’, put aṅwute’, pam sohsok naqöyyuwsiyat aw taqa’naṅwayat nawhk̇e’, hihta himuyat kwatsmuy huytaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Qa inumumnihqa hapi inuhpewiwta; pu qa inumum tsovalantaqa tatslakinta. ");
INSERT INTO hopNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tuyoy’eway hikwsi sinot aṅqw yámak̇e’, haqe’ qa pay’taqat aṅ hinnumṅwu, haqam nāsuṅwnaniqe ōviy’o; nit qa tuwe’ paṅqawṅwu: Han pi pay nu ikiy aṅqw yámakqey aw áhoy’i, kítaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pu pam ep pite’, pās maspiwk̇aṅw lomahintaqat túwaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Pahsat pu pam ahpiynen tsáṅe’nihqamuy hīhikwsimuy nahpenihqe pas núnukpantuy aw tsamṅwu. Noqw puma aw yuñe’, ep ki’yuṅṅwu. Noqw hakiy qatsíat aṅknihqa mohtiwat epnihqe pu’ pas qalomáhintaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Noqw pam yan yuaataqw, hak wuhti sinmuy amuṅaqw k̇ēew hiṅqawhqe aw paṅqawu: Ṅaspi hak uṅ tihta. Piw pīhuy akw uṅ yōyoṅna. ");
INSERT INTO hopNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Noqw pam put aw paṅqawu: As um yan lavayhtinikaṅwo: Ṅaspi hakim God lavayiyat aw tūqayk̇ahk̇aṅw aṅ hinwisa, puma hapi hahlayhpit epyani, um kítanik̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Noqw pan sinom sūmi hūrs tsovawmaqw, Jesus yuaativaqe amumi paṅqawu: Ima pu’ qatsívaptsiwyuṅqam nukpansinomu. Puma k̇ātatayhpit hihta tuawi’taqat aw yórikyaniqey nānawakna, Nīk̇aṅw puma soon k̇ātatayhpit aw yórikyani, hal pas sūkw k̇ātatayhpit‐saa. Pam Tutuyqawhqat lavay’ayayat Jonas qatsíyat ep hiniwhtiqat an aw yukiltini. ");
INSERT INTO hopNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pi ura Nineve‐kitsókit ep sinom Jonas qatsíyat ep hiniwhtiqat akw hihta tuwi’vaya. Noqw pay ōviy hapi piw pan nu’ Sinot Tiat pu’ qatsívaptsiwyuṅqamuy amumi hihta tuawi’tani, iqatsiy ep hiniwhtiqat akw’a. ");
INSERT INTO hopNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Hisat hin yukiltiniqat aw pituqw, tatk̇aqw moṅwi‐wuhti pu’ qatsívaptsiwyuṅqamuy amumum wunupte’, pumuy qatuptsiwniyamuy ep suhputsnani. Ispi pam Solomon wuwniyat aw tūqaytaniqe ōviy pas tūwaqalṅahaqaqw pítu. Noqw meh, hak Solomon epnihqe pas pávannihqa yep’e. ");
INSERT INTO hopNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ason hin yukiltiniqat aw pituqw, Ninevet ep sinom pu’ qatsívaptsiwyuṅqamuy amumum hoṅve’, pumuy qatuptsiwniyamuy ep suhputsnayani; ispi puma Jonas lavayiyat nanaptaqe nāp tunatyay aṅqw lasyaqee. Noqw meh, hak Jonas epnihqe pas pávannihqe yep’e. ");
INSERT INTO hopNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Qa haq pi hak wihqöhit úwiknat, haqam qamātaqpuve put tavi, sen hihta sīvut akw put kuhta. Pi pam put tsotsókpiyat ep tsok̇aqw, ep yuṅtaqam tālat tāyuṅṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hakiy pōsiat tokoyat aw talni’taṅwu. Noqw ōviy kurs hakiy pōsiat pasiwtaqw, pay tokoyat aṅ ahsupoq talṅwu; pu kurs hakiy pōsiat qa pasiwtaqw, pay tokoyat aṅ ahsupoq qatalṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Oviy um tunatyaltiqw, uhpe tāla qa qömawvani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Paniqw ōviy kurs uhtokoy aṅ ahsupoq talq, qahaqam qatālaniqw, pam sohsoy ahsupoqhaqami talni, wihqöhi suyan tālat talni’te’, ūmi talni’taṅwuqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Noqw pam yuaataqw, hak Pharisee‐sinom put tūtsama. Noqw pam kīyat ep pákihqe, qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Noqw pam mohti qa māvaqtat tūmoytaqw, Pharisee‐sino put aw tātayhqe, aw hin wūwa. ");
INSERT INTO hopNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Noqw Tutuyqawhqa put aw paṅqawu: Uma Pharisee‐sinom kukyapit, pu tsatsqaptat anyuṅwa. Uma suovaam kwaṅw’ewayhtotit tukwhanayaniqey‐sa tunatyawyuṅwa, pu qalomáhintsatsk̇aniqeyu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Uma núanhihtuu, puyaw ōvaqenihqat yúkuhqa ahsonṅaqwnihqat qa enaṅ yukuqw ōviy’o? ");
INSERT INTO hopNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tis pi uma hihta himuy’yuṅwe’, put akw tūookwatuwyanik̇ahk̇aṅwo; noqw pep pu’ amuhpa’ ahsupoq kwaṅw’ewayni. ");
INSERT INTO hopNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nīk̇aṅw is ohi uma Pharisee‐sínomu! uma pi umuh’uyiy aṅqw nēnevenit pakwút‐sikivo sun oyit God aw noayaṅwu; nik̇aṅw uma soq sinmuy amuṅem suan hin yukuyaniqey qe’toti; uma God qa aw unaṅway’yuṅwa. Uma as pávanyaqat tutavot aṅ ahsupoq hinwisni; pu it qa pas qatuvosnihqat aṅ pīwu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Is ohi uma Pharisee‐sínomu! Uma pi tsotsvalkiva mohk̇aqe tsotsókpit pas hahlayya, pu sinom kitpik umuy k̇aptsi’k̇ahk̇aṅw umumi yuaatotaniqata. ");
INSERT INTO hopNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Is ohi uma tutavot tūtutuqaynayaqam, pu Pharisee‐sínomu! nawip’ew hinyuṅqamu! Uma pi tūtuamit qa mātaqyaqat anyuṅwa; noqw sinom put atsva yaktaqam pumuy paṅyaqw qa tuway’numya. ");
INSERT INTO hopNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pahsat pu haqawa tutavot aw tuvoti’taqa lavayhtiqe, put aw paṅqawu: Tutuyqawhqa, um paṅqawhqe itamumiq enaṅ hiṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Noqw pam paṅqawu: Pay panta. Is ohi uma tutavot aw tuvoti’yuṅqamu! uma pi soñawnen hihta a’nö putut mok̇ahtotat, hakiy īkwiltoynayaṅwu; nīk̇aṅw uma soq soon ṅas’ew pumuy paaṅwayaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Is ohi úmaa! Uma pi God lavay’aymuyatuy tūamiyamuy aw pūhulalwa; noqw pi umanam pumuy qöqya. ");
INSERT INTO hopNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pas pi ōviy uma umunamuy hiniwhtipuyamuy navoti’k̇ahk̇aṅw amún unaṅway’yuṅqey mahtakni’yuṅwa, ispi puma pumuy qöqyaq’ö; noqw uma pumuy tūamiyamuy aw pūhulalwa. ");
INSERT INTO hopNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Paniqw hapi ōviy God suan wuwni’k̇aṅw yan lavayhti: Nu pumuy amumi ilavay’aymuy hōnani, pu ituaw’a’yatuyu. Noqw puma pētuy yūyuyhnaye’ qöqyani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Noqw God pu’ qatsívaptsiwyuṅqamuy hapi tukopnani, sohsokmuy put lavay’aymuyatuy tūwaqatsit yayhniwhqat aṅqaqw qöyaniwyaqat ahpiy’o, ");
INSERT INTO hopNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","It Abel qatsiyat ep’e, pu aṅk yesqamuy qatsíyamuy ep pīwu, nit pu Zacharias qatsíyat ep’e. Ura pam God kīyat‐nik̇aṅw pu hom’oyvihk̇at amuhtsave nīniwa. Nu umumi súaṅqawni: God umuy put sohsok ep tukopnani. ");
INSERT INTO hopNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Is ohi uma tutavot aw tuvoti’yuṅqamu! Uma pi navotit aw hötahpit yawwisa. Uma aw qa yuṅk̇ahk̇aṅw, aw yuṅtaqamuy aw u’taya. ");
INSERT INTO hopNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Noqw pam pumuy amumi yan lavayhtiqw, tutavot tutuqaynayaqam Pharisee‐sinmuy amumum put aw pās ö’qaltivayaqe, pam hīhihta lavayhtiniqat ōviy aw qa tūtuqayya. ");
INSERT INTO hopNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Hísatniqw unahiṅqawhq nanapte’, put nēveltoynayaniqe ōviy moqmani’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Noqw aṅwu sinom pas qaan’ewakw hintaqam sūmi tsovaltiqe nuṅwu pay nānami wukukutotaqw, Jesus put aw nánatuwnayaqamuy amumi mohti paṅqawu: Uma Pharisee‐sinmuy pēk̇eniyamuy nawip’ew hintsakpit ep qa ūnaiwyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pi qa himu āmiwtaqa qa mātaqtini, piw tupkiwtaqa qa nanaptiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pantaqw ōviy hihta qamātakpuve haqawa lavayhtiqw, pam tālat ep nanaptiwmantani; pu uma hihta yūyupavaqe hakiy naqvumiq sawiwiykuyaqw, pam kihkits’ova tsa’lalwiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Noqw nu umumi paṅqawni ikwátsimu: Uma qa sinmuy mamqasyani. Puma pi pay hakiy tokoyat‐sa nīnayaṅwu; pu pahpiy kurs hinhtotiṅwu pīwu. ");
INSERT INTO hopNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nīk̇aṅw uma hakiy mamqasyaniqat nu umuy āawnani. Uma God hapi mamqasyani. Pi pam hakiy nīnat, hakiy qȫhit aqw tūvaniqey aw öqalay’ta. Noqw nu’ piw umumi paṅqawni: Uma put hapi mamqasyani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Puyaw qa tsivot kwekwévewhyam lȫq palavotōnat ōviy huyiwyaṅwu? Noqw qa himuwa God ahpiy suhtokiwṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hikis pi pas umuhqötöva umuhhömi sohsoy pohtoylaniwta. Oviy uma qa nalmamqasyani; God kwekwévewhyamuy k̇aysiwhqamuy amuhpenihqe umuy pas k̇ahk̇awna. ");
INSERT INTO hopNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Pu nu piw umumi paṅqawni: Hak isinonihqey nuhtumi paṅqawhq, nu’ Sinot Tiat tuwat put isinonihqat God hoṅviaymuyatuy amumi paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nīk̇aṅw hak qa isinonihqey nuhtumi paṅqawhq, nu tuwat put qa isinonihqat God hoṅviamuyatuy amumi paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ason kurs hak nuy Sinot Tiyat ehpewi lavayhtiqw, pam pantaqa put ahpiy ayo yukiwmantani. Nīk̇aṅw ason kurs hak Qahováriwtaqat Hikwsit ehpewi qak̇aptsilavayhtiqw, pam pantaqa soon put ahpiy ayo yukiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pu ason sinom umuy tsotsvalkiva, sen momṅwituy, sen öqalat pasiwyuṅqamuy amumi tsamvayaqw, uma hin yuaatotaniqey, sen hihta lavayhtotiniqey qa wūwantotamantani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pay ason aw pituqw, Qahováriwtaqa Hikwsi umuy hin lavayhtotiniqat umuy tutuwnamantani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Noqw haqawa sinmuy amuṅaqw put aw paṅqawu: Tutuqaynaqa, um as ivavay aw paṅqawhq, pam hihta itahmakiway aṅqw nuy máqani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Noqw Jesus put aw paṅqawu: Tāqa, ya hak nu hihta ep hin yúkuniqat, pu sen umuy hihta namqananiqat aw nuy tavi? ");
INSERT INTO hopNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pu pam pumuy amumi paṅqawu: Uma tunatyaltote’, hihta qa umuhhimuy tuṅlay’yuṅwniqey qe’yani. Pay sino hihta nihti’taniqe qa paniqw ōviy qatu. ");
INSERT INTO hopNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pu pam hihta tūwutsit akw pumuy amumi yuaaykuqe paṅqawu. Hakiy k̇ahaktaqat pāsaat a’nö hihta aniwna. ");
INSERT INTO hopNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Noqw pam unaṅwpeq wūwantaqe paṅqawu: Ya sen nu hinhtini? Kurs nu haqami inatwaniy koyotani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pu pam paṅqawu: Han pi yanhti: Nu hāhaqe’ ikoyokiy tsawimnat, pas wūkoq kītani. Pu nu paṅso sohsok inatwaniy, pu hihta ihimuy taṅatani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nit pu iunaṅway aw paṅqawni: Iunaṅwa, um hihta nihtiwtaqat wūhak yahsaṅwuy aqw pitsíwtaqat taṅata. Taa, um nāsuṅwni’k̇aṅw, tūmoytani, hīhikwni; nen um hahlayni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Noqw pay God put aw paṅqawu: Um núanhimu ṅasta wuwni’taqa, it tōkilat ep nu uhhikwsi ūmi tuhtuy’ni. Noqw pahsat pu himu uhpiy na’sastiwhqa hakiy himuatni? ");
INSERT INTO hopNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Noqw pan hapi i’ hak nēṅem‐sa hihta tsovalantaqa hintani. Yep qatsit ep k̇a hihta nihti’tani, nīk̇aṅw ōveqatsit ep God atpip pas ōokiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pu pam put aw nánatuwnayaqamuy amumi paṅqawu: Paniqw ōviy nu umumi paṅqawni: Uma hin yesniqey qa nānaphin wūwantotani, hihta nȫnösaniqeyu, piw umuhtokoy éṅem’i, hihta yuwsiyaniqeyu. ");
INSERT INTO hopNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pi hakiy qatsíat nȫsiwhqat epnihqe pas pavan hihk̇ay’ta, pu hakiy tokoat yuwsit epnihqe pas pavan hihk̇ay’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kurs huvam aaṅwustuy amumi wūwayaa. Puma qa ūuyyaṅwu, piw qa höqyaṅwu. Puma qa koyoki’yuṅwa, piw qa tuoyhki’yuṅṅwu. Noqw God pumuy nōnopna. Nihqe tis pi pam masay’yuṅqamuy amuhpenihqe umuy pas k̇ahk̇awna! ");
INSERT INTO hopNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ya sen hak pan tunatyawtaqa hin nāwuṅwnaniqey tuwi’ta? ");
INSERT INTO hopNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Noqw kurs uma hihta sus’öwihintaqat kurs panhtotinik, ya uma hinoqw pas piw ahpiy pēhut hinyaniqey tunatyawyuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kurs huvam sishut hin wuṅw’iwwisqat aw wūwayaa. Puma qa tumalay’yuṅwa; qa tontotaṅwu. Noqw nu umumi paṅqawni: Solomon sohsok hihta nukṅwat yuwsi’k̇aṅw qa ṅas’ew imuy amumi hayawtaqat yuwsi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sumataqpi God tūsaqat pās yūyuwsina, nāmahin pi pam pay hihsavo tayta. Pu’ pam tutskwavanik̇aṅw, qāvo pam qöpqömiq maspiwni. Noqw ya pam tis umuy qa pavan pas yūyuwsinani, uma öwituptsiwni’yuṅqamu? ");
INSERT INTO hopNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Oviy uma hihta nȫnösaniqey, pu hihta hikwyaniqey qa tunatyawyuṅwni, piw uma qa wiwsiyani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pi sinom yep qatsit tunatyayat aṅ hinwisqam sohsok īit hihta tunatyawyuṅwa. Noqw Umuna umumi navoti’ta, uma sohsok īit hihta haqni’yuṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nīk̇aṅw tis pi uma God moṅwtunatyayat tunatyawyuṅwni; noqw sohsoy īi himu umumi noiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Uma qa tsawiniwyuṅwni tōnawhohyamu; pi Umuna umuy moṅwtunatyat máqaniqey moṅwvasi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Uma hihta himuy’yuṅwe’ put huyayani; nen akw sinmuy ōokwatuwyani. Uma umuhk̇ahakiwuy ōveqatsit aw taṅatotani. Pan uma soñawnen umuhsivamoktukpuy qa sakwíiwṅwuqat nenṅem tutwani. Pi ōveqatsit aw uyiṅwu qa pákiṅwu, piw kwahya qa hihta hovalaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pi hakiy k̇ahakhimuat háqamniqw, hakiy unaṅwaat piw pepniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","37","Hakim tahtaqt moṅwiy haqam nāṅuiwhqat aṅqw áhoyniqat nuhtayyuṅqamuy amún uma kwewk̇ahk̇aṅw, umuhqöhiy úwikni’yuṅwni. Noqw ason pam ahoy pite’, pöṅö́ṅöykinaqw, puma nuhtayyuṅwe’, eṅem súhötaye’, pas hahlayhpit epyani. Pas antsa nu umumi paṅqawni: Soon pam qa hihta akw namuptat, amumi tunösvoñahtat, pumuy nopni’tani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Noqw kurs pam suhtokilnasavehaqam, sen talhahayiṅqw pite’, puma put nuhtayyuṅqat tuwaqw, pas puma tumal’a’yat hahlayhpit epyani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pu meh yanta, pi as ki’taqa hísatniqw uyiṅwu pítuniqat navoti’te’, soon qa tūwalani, nen soon put kīyat aw pákiniqw, pam pánani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pantaqw ōviy uma piw pās moṅwvas’iwyuṅwni. Taq uma nāt qa pan wūwantotaqw, nu’ Sinot Tiat pítuni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pahsat pu Peter put aw paṅqawu: Tutuyqawha, ya um it lavayit itamumi‐sa lavayhti, sen pay pas sohsokmuy amumii? ");
INSERT INTO hopNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Noqw Tutuyqawhqa paṅqawu: Noqw ya sen hak hakiy tumal’ayaat suan hinmaqat suan wuwni’taqa? Put moṅwíat haqaminiqe sohsok hihta himuy aw tunatyawtaniqat aw put tavit, tumalsuṅwamuyatuy aw put moṅwtapq, pam pumuy aṅsakis tunösmakiwayamuy pumuy huytani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Noqw kurs put moṅwiat pite’, put nāt suan hinmaqw put tuwaqw, pam tumal’aya pas hahlayhpit epni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pas antsa nu umumi paṅqawni: Pas soon put moṅwíat qa sohsok hihta himuy aw put moṅwtapni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nīk̇aṅw kurs pam tumal’aya moṅwiat qa īts pítuniqat unaṅwpeq paṅqawe’, pahsat pay tumalsuṅwamuy, tahtaqtuy, pu momoymuy wuvahtivani; pu tūmoyk̇aṅw, hīhikwtive’, honaqkuyit akw hōnaq’iwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pu pam qa hin pan wūwank̇aṅw, moṅwiy qa nuhtay’taqw, pam pite’, put tumal’ayay ayo tūvani. Noqw pam nawus qatuptsiwni’yuṅqamuy amumum k̇ānavotni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pi i’ tumal’aya moṅwiy tunatyayat as navoti’k̇aṅw, hintaniqey qa pantsakt, piw tunatyayat qaan hintsak̇e’, hapi nawus wūhakis wuvahtiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nīk̇aṅw i’ hak put tunatyayat qa navoti’k̇aṅw, qaan hinme’, pay qa wūhakis wuvahtiwmantani. Pi i’ hak wūhaq hihta makiwhq, sinom tuwat put aw wūhaq tuṅlay’yuṅwni. Pu sinom hakiy aw hihta wūhaq noaye’, put aw wūhaq tuhtuiyamantani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Soñawnen nu tūwaqatsit aw qȫhit tūvaniqe pitu. Noqw is as pay pam uwiwitani! ");
INSERT INTO hopNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nīk̇aṅw nawus nu nāt soñawnen hihta akw tuvoylatiwni. Nīk̇aṅw nu nāt put qa aṅ kuyve’, pas pavan sóontsaniwni. ");
INSERT INTO hopNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ya uma inumi yan wūwantota: Pam k̇a sinmuy qa hin unaṅwat yesniqat ōviy pitu, pan’i? Uma qa pan wūwantotani. Pi sinom qa súnahpa’yaniqat ōviy nu pitu. ");
INSERT INTO hopNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pi yahpiy haqahpiy hapi haqam sūkw kīve tsívotnihqam nātsikiwtamantani. Pahyom lȫqmuy amuhpewiniqw, pu lȫyöm payhkomuy amuhpewii. ");
INSERT INTO hopNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Hakiy naat tiy ehpewhtimantani; pu tiat nay ehpewhtimantani. Yuat tiy mānat ehpewhtimantani; pu māna yuy ehpewhtimantani. Pu mö’wi’taqa mö’wiy ehpewhtimantani, pu’ mö’wi puwsuṅway yuyat ehpewhtimantani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pu piw pam sinmuy amumi paṅqawu: Uma tāvaṅqw ōmawuy kuyvaqw tutwe’, āpiy pay paṅqaqwaṅwu: Aṅqw yōyaṅ’u, kitotaṅwu; noqw antsa pantaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pu tatk̇aqw hūhukq uma paṅqaqwaṅwu: Kurs utuhuuni, kitotaṅwu; noqw antsa pantaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Uma nawip’ew hinyuṅqamu, pay as uma tokpelat aṅ‐nik̇aṅw, pu tūwaqatsit aṅ hin sóniwhqat māmatsyaṅwunik̇aṅw, ya hintaqw ōviy haqe’ qalawmaqat uma qa māmatsya? ");
INSERT INTO hopNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Pu ya hinoqw uma hihta umuhhintsakpiy qa aw suan wūwaya? ");
INSERT INTO hopNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Um hakiy uhpew’iwtaqat amum moṅwit awnen, nāt umuy awniqw um hin put amum namivöhikniqey qanātusi’tamantani; taq k̇a pam hakiy hin yukunaṅwuqat aw uṅ lölökintaqw, pam uṅ solāwamoṅwit aw noaqw, pam uṅ sivikimi pánani. ");
INSERT INTO hopNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nu ūmi paṅqawni: Pas um soon paṅqw yámakni; pas ason um hisat uhpöiy sohsok ep sisve’, pep pu’ paṅqw yámakni. ");
INSERT INTO hopNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Noqw ephaqam hakim Jesus awyaqe, aw paṅqaqwa: Yaw hakim Galileet aṅqw God eṅem kanēlot nīnayaqw, Pilate solāwamat pumuy qöqyaqw, uṅwaam kanēlot uṅwáyat enaṅ namiqwrilti. ");
INSERT INTO hopNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Noqw Jesus lavayhtiqe pumuy amumi paṅqawu: Ya uma wūwantotaqw, ima Galileet aṅqw sinom sohsokmuy Galileet aṅqw sinmuy amuhpenihqe pas sus qaanhinwisqe, ōviy pas panhaqam hintsaniwya? ");
INSERT INTO hopNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nu umumi paṅqawni: Qae. Pi uma umuhtunatyay qa aṅqw lasye’, soon qa sohsoyam pumuy amún súlawhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ura Siloam ep wupaki sahpukqe, hakimuy pakwt nanal sihk̇ay’taqamuy sinmuy qöya. Noqw ya úmuyniqw puma Jerusalem ep ki’yuṅqamuy sohsokmuy amuhpenihqe pas sus qaanhinwisa? ");
INSERT INTO hopNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nu umumi paṅqawni: Qae. Pi uma umuhtunatyay qa aṅqw lasye’, soon qa sohsoyam pumuy amún súlawhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pu Jesus piw tūwutsit hihta tuawi’taqat lavayhtiqe nuhtumi paṅqawu: Hak tāqa ūyiy ep nönvospaltsokit ūyi’ta. Nihqe pam as aw sipalat hept, qa hihta tuwa. ");
INSERT INTO hopNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nihqe pam ūyit aw tunatyawtaqat aw paṅqawu: Meh, pu’ hapi pāyis yahsaṅwuy aṅ nu it nönvospaltsokit aw sipalhept, qa hihta tuwa. Tsahqaa. Pam paysoq tutskwat hovalni’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Noqw ūyit aw tunatyawtaqa lavayhtiqe put aw paṅqawu: Moṅwi, pay hāk pam piw it yahsaṅwuy ep pantani. Noqw nu aṅhqe haṅwe’, aṅhqe kwitatoynani. ");
INSERT INTO hopNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Noqw ason kurs pam himuy’vaqw, pay lolmani. Kurs qa hihta himuy’vaqw, pay pi nu tsahqani, kita. ");
INSERT INTO hopNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Noqw Jesus nasuṅwintalöṅnit ep háqamwat tsotsvalkive tūtutuqayna. ");
INSERT INTO hopNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Noqw meh, hak wuhti himu hikwsit hakiy ȫputaṅwuqat akw tuyqawiwtaqa pep nuhtuma. Okiw pam pakwt nanal sihk̇ay’taqat yahsaṅwuy aṅ tūtuyhqe, hūrs moto’taqe pas kurs hin kwuhpukni. ");
INSERT INTO hopNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Noqw Jesus put túwahqe, put wáṅwayhqe, aw paṅqawu: Wuhti, pay um uhtuyay aṅqw mātaviwni, kita. ");
INSERT INTO hopNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Noqw pam may akw put aw toṅokq, pahsat pay wuhti tsikqe, pas God hihtata. ");
INSERT INTO hopNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Noqw Jesus nasuṅwintalöṅnit ep put qalaptsinaqw, ōviy tsotsvalkive moṅwi itsívutiqe, sinmuy amumi paṅqawu: Sinom hapi navaysikis talöṅnit aṅ tumalay’yuṅwni. Oviy uma put aṅ pewye’, qalaptuyani; nen qa nasuṅwintalöṅvaqat epyani. ");
INSERT INTO hopNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Noqw Tutuyqawhqa pahsat put aw lavayhtiqe paṅqawu: Um nawip’ew hintaqa! Ya uma qa nanap nasuṅwintalöṅnit ep umuhwakasvohkoy, sen umuhmoropkoy haqam pakiwtaqat aṅqw mātapye’, put hikwnawisṅwu? ");
INSERT INTO hopNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Noqw meh, Satan it wuhtit, Abraham tíyatnihqat pay pakwt nanal sihk̇ay’tasikis yahsaṅwuy aṅ it tūyat akw sōma. Noqw puyaw nu nasuṅwintalöṅnit ep put mātapqe, ōviy pas qalomáhinhti? ");
INSERT INTO hopNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Noqw pam yan lavayhtiqw, put ehpew’iwyuṅqam sohsoyam hamanhtoti. Noqw sinom sohsoyam pas hinhaqam hahlayhtoti, pam sohsok hīhihta qaöwítumaltaqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pu Jesus paṅqawu: Ya God moṅwtunatyaat hihta anta? Ya sen pam hihta antaqat nu paṅqawni? ");
INSERT INTO hopNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pam mustard‐ūyit pōsiyat anta. Put hak tāqa kwúsuhqe, pāsay ep ūya. Noqw pan wuṅwqe, pas wukotskiniwhti. Noqw masay’yuṅqam put nantaqayat aṅ yesva. ");
INSERT INTO hopNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Pu piw pam paṅqawu: Ya nu God moṅwtunatyayat hihta antaqat paṅqawni? ");
INSERT INTO hopNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pam pēk̇enit anta. Put hak wuhti kwúsuhqe payhp tuwanit ṅumnit enaṅ namiqwrilaqw, pam sohsoy pēk̇e, kita. ");
INSERT INTO hopNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pu pam kitsókinawit hinmakaṅw, sinmuy tutuqaynatima, Jerusalem aqw hoyhtak̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pahsat pu hak put aw paṅqawu: Tutuyqawhqa, ya pay pas híkiyom ayo nö́ṅakni? Noqw pam pumuy amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Uma hihsa’ qenit hötsiwat aṅ yuṅniqey qa nātusitotani. Taq nu umumi pas paṅqawni: Pay as k̇aysiwhqam aw yuṅniqey tuwantotanik̇aṅw, pay kurs hinyani. ");
INSERT INTO hopNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hisat ki’taqa wunupte’, hötsiwmiq uhtaqw, pahsat pu as uma ihpaqw hoṅk̇ahk̇aṅw, uutspit pöṅö́ṅöytoynayani, paṅqawk̇ahk̇aṅwo: Tutuyqawhqa, Tutuyqawhqa, itamumi hö́taa, kitotani. Noqw pam lavayhte’, umumi paṅqawni: Umuy háqaqwyaqat nu qa navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pahsat pu uma paṅqawtivayani: Ura itam utpip nȫnösa, pu hikwya; pu um itahkitpik itamuy tutuqayna. ");
INSERT INTO hopNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Noqw pay pam paṅqawni: Pay nu umumi paṅqawu: Nu umuy háqaqwyaqat qa navoti’ta. Huvam inuṅaqw ahpiyyaa, sohsoyam nukpantuwit hintsatsk̇aqamu. ");
INSERT INTO hopNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pep pu’ uma tsaykitani, umuhtamay ṅuritotani. Noqw Abraham, pu Isaac, pu Jacob, pu sohsoyam God lavay’aymat, puma God moṅwtunatyayat ep taṅawtaqw uma amumi yórikyani. Nīk̇aṅw úmawat ihpoq maspiwyani. ");
INSERT INTO hopNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pu sinom hōpaqw ö́kini, pu tāvaṅq’ö, pu kwiniṅaq’ö, pu tatk̇aq’ö; nen God moṅwtunatyayat ep yesvani. ");
INSERT INTO hopNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Noqw meh, haqawat nuhtuṅkyaqam mohti’wisni, pu mohti’wisqam nuhtuṅkyani. ");
INSERT INTO hopNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Noqw ép tāwat ep hakim Pharisee‐sinom Jesus aw ö́kihqe, aw paṅqaqwa: Um yámak̇e’, yaṅqw ahpiyni. Taq Herod uṅ nīnaniqey nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Noqw pam pumuy amumi paṅqawu: Yúpave, awye’ put īsawuy aw paṅqaqwaa: Meh, nu hapi nukpanhihikwsimuy nuhtuṅaqw ipwanta, pu tūqalaptsinta, pūu, pu piw qāvoo, pu pāyis talqat ep imakiway aṅ nu kuyvani. ");
INSERT INTO hopNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nīk̇aṅw pay nu nawus pu’ Jerusalem aqw hoyhtani, pu qāvoo, pu lȫtoki. Ispi soon God lavay’ayaat Jerusalem aṅqw nāp haqam súlawhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Is ohi uma Jerusalem ep sínomu! Is ohi umuṅemi! Uma pi God lavay’aymuyatuy qö́yantota, pu umumi ayatiwyaqamuy tatatupqöyantota. Pas as nu hihsakishaqam umuy tsovalani, kowākowuhti timuy masay atpik̇aqe taṅataṅwuqat pan’i; noqw uma hapi qa nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Meh, God umuhkiy pay tatamhta. Noqw nu umumi pas antsa paṅqawni: Pay uma yahpiy haqahpiy soon inumi yórikyani. Nīk̇aṅw hisat aw pituqw, uma paṅqaqwani: Tutuyqawhqat natṅwaniyat aṅ pitutoqa nam tayawintiwaa, kitotani. Noqw pep pu’ uma inumi piw yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pu hisat nasuṅwintalöṅnit ep Jesus Pharisee‐sinmuy amuṅaqw hakiy pas mohpeqnihqat kīyat ep tūmoyta. Noqw puma put aw pās tunatyawyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Noqw meh, hak tāqa pāmoktuyat tūtuyhqa Jesus apyeve qatu. ");
INSERT INTO hopNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Noqw Jesus lavayhtiqe tutavot aw tuvoti’yuṅqamuy‐nik̇aṅw pu Pharisee‐sinmuy amumi paṅqawu: Ya pay hak nasuṅwintalöṅnit ep hakiy qalaptsinaniqw pam súanta? ");
INSERT INTO hopNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Noqw puma qa hiṅqaqwa. Noqw Jesus put ṅuahqe, qalaptsinat, mātavi; ");
INSERT INTO hopNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nit pumuy amumi paṅqawu: Kurs uma haqawa moropkoy’tani, sen wakasvokoy’tani. Noqw kurs pok’at nasuṅwintalöṅnit ep hötsit aqw posni. Ya sen put pohkoy’taqa qa āpiy pay paṅqw pu hóroknani, nāmahin pi nasuṅwintalöṅniniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Noqw puma kurs hiṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pu pam tūtsamiwyaqamuy amumi tātayhq, kurs puma núnukṅwat qenit namorstotaqw, pam amumi tutaptaqe, amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ason hak nāṅuiwhqat ep nōviwhqat ep uṅ tūtsamq, um qa pas susnukṅwat qenit ep qátuptuni, taq nāp hisat pi sen uṅ tūtsamqa uhpenihqe hakiy pas pavan sinot tūtsamht, ");
INSERT INTO hopNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Uminen ūmi paṅqawni: It qenitoynaa, kítani. Noqw pahsat pu um hamanhtini, susqalaveq qatuptuniqee. ");
INSERT INTO hopNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Um qa panhtiqw, ason hak uṅ tūtsamq, um susqalaveq qatuptumantani. Noqw uṅ tūtsamqa pite’, ūmi paṅqawni: Ikwatsi, um pavan ayo nukṅwat aw hóyokni, kítani. Noqw pep pu’ umum nōnovaqam uṅ k̇aptsi’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Taq haqawa pavan nāhihtataqa hapi qahimuniwhtini; pu nāqahihtataqa hapi a’nö hímuniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pu Jesus piw put tūtsamqat aw paṅqawu: Um wukonovate’, qa uhkwatsmuy tūtsammantani, piw uhsinomuyu, piw uqlaq k̇ahaksinmuyu; taq k̇a puma soon qa uṅ tūtsamyaqw, pay pam ūmi ahoytiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ason um tūnopnanik, aṅ ōokiwyaqamuy tūtsammantani, pu qapasiwyuṅqamuyu, pu qayaktaqamuyu, pu qapostalyaqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nen um hahlayhpit epni. Pi puma kurs hin ūmi put aṅ ahoytotaniq’ö. Pay ason aṅ súanyuṅqam ahoy yesvaniwhq, pep pu’ God ūmi put ep ahoytani. ");
INSERT INTO hopNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Noqw put amum nōnovaqamuy amuṅaqw haqawa it navotqe, put aw paṅqawu: Pas hak God moṅwtunatyayat ep nösniqa hahlayhpit epni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Noqw pam put aw paṅqawu: Hak tāqa wukonovataqe, k̇aysiwhqamuy tūtsama. ");
INSERT INTO hopNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nihqe nonopsattiqw, tūtsamiwyaqamuy amumi tumal’ayay hōnaqw, pam amumi paṅqawu: Huvam pewyaa; pay sohsoy himu yukiwta. ");
INSERT INTO hopNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Noqw puma sohsoyam sun hihta akw qe’yaniqey pan unaṅwtoti. Noqw mohti’maqa put aw paṅqawu: Piw nu hihsaq tutskwat túihqe, pas soon qa aw kuyvatoni. Himu nu as pay qa awni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Noqw suhk̇a paṅqawu: Piw nu tsivót‐sikip nanasṅwamuy tumalwawakastuy túihqe, pas piw soon amumi qa pohtani. Himu nu as pay qa awni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Noqw suhk̇a paṅqawu: Piw nu nȫmataqe, ōviy kurs hin awni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Noqw ōviy pam tumal’aya pítuhqe, īit moṅwiy āawna. Pahsat pu ki’taqa itsívutiqe, tumal’ayay aw paṅqawu: Yupa k̇aktayii, kīmii, kihkisonva, pu kīkisk̇at aw’i; nen um aṅ ōokiwyaqamuy, pu hihta akw qapasiwyuṅqamuy, pu qayaktaqamuy, pu qapostalyaqamuy aṅqw tsamni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Noqw tumal’aya panhtiqe paṅqawu: Moṅwi, pay um hintaniqat paṅqawhq, nu as anhti; noqw pay nāt ep qeni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Noqw moṅwi tumal’ayay aw paṅqawu: Yupa, kurs pö́nawita, pu kwiyauy’uhtsit aw’i, nen um aṅqw sinmuy tusoqtsamhq, ikiy ep ohpokni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pi nu ūmi paṅqawni: Imuy tahtaqtuy as tūtsamiwyaqamuy amuṅaqw qa haqawa inovay aṅqw nösni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Noqw sinom qaan’ewakw hintaqam Jesus ámumya. Noqw pam namtökqe amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Inuminihqa nawus nay, pu yuy, pu nȫmay, pu timuy, pu pāvamuy, pu tupkomuy, pu qȫqamuy, pu siwamuy, pu hikis pas nāp qatsiy enaṅ aw qa suhtaq’ewni. Hak qa panhtinik, soon inuṅk wīsiwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pu nahoylehtsiy qa yank̇aṅw inuṅknihqa pas soon inuṅk wīsiwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kurs uma haqawa ōmi wupakitaniqey tunatyawte’, ya sen pam qa mohti qatupte’, hin hihk̇ayat aṅ wūwani, sen aw aptsi’nitaqeyu? ");
INSERT INTO hopNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nāphisat pi pam as qaqatspiyat yukut, pay kurs hin put aw yúkuniniqw, aw yorstotaqam sohsoyam akw tututsiwtivaye’, ");
INSERT INTO hopNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Paṅqaqwani: I’ as kītivat, pay kurs hin aw yúkuni. ");
INSERT INTO hopNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Hal kurs hak haqam moṅwi sukwat moṅwit aqw kihpokte’, ya sen pam qa mohti qatupte’ aṅ wūwani, sen pay pam pakwút‐sikip sōmorit pahsa’ sinoy’k̇aṅw, put ahsawvatoqat áṅwutaniqeyu, pam sunát‐sikip sōmorit pahsa’ sinoy’taq’ö? ");
INSERT INTO hopNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Noqw kurs pay hinniniqw, nāt mi’ pas yāvaqwniqw, pam aqw hakiy tuaw’ayhte’, pay hintaqat akw puma qa nāmi may’taniqat aw tūviṅtani. ");
INSERT INTO hopNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Noqw ōviy pay pan hapi kurs uma haqawa sohsok hihta himuy qa tatamhte’, pas soon inuṅk wīsiwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Öṅa as lolma; nīk̇aṅw kurs pam suhuviwe’, sen hihta akw suhutiwni? ");
INSERT INTO hopNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pam tutskwat aw qa nukṅwa, piw kwitatsvalnit aw’i. Pay pánis‐sa pi hakim put maspayaṅwu. Tuqayvastotaa! Uma pi naqvuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pahsat pu moṅwit eṅem sīvat ömalalwaqam, qaanhinwisqamuy amumum sohsoyam put aw tūqayyuṅwniqe aw hóyokya. ");
INSERT INTO hopNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Noqw Pharisee‐sinom, tutavot tutuqaynayaqamuy amumum Jesus aw qayan unaṅway’yuṅqe paṅqaqwa: Tuwat i’ tāqa qaanhinwisqamuy pas amu’puñalk̇aṅw, amumum tunöshomhta. ");
INSERT INTO hopNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Noqw pam tūwutsit hihta tuawi’taqat akw amumi lavayhtiqe paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","As kurs umuṅaqw haqawa tsivót‐sikip sunat kanelvokmuy’taqw suhk̇a kurs haqamini. Ya pam nālöp sunat pakwt pept sihk̇ay’taqamuy haqam tutskwave qa mātapt, pu haqaminihqat heptoni, pas túwaniqe pahsavoo? ");
INSERT INTO hopNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pu pam put tuwe’, hahlayk̇aṅw sukpa’ tsoki’k̇aṅw, ");
INSERT INTO hopNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kiy ep pite’, kwatsmuy, pu kisṅwamuy tsovale’, amumi paṅqawni: Huvam inumum hahlayyaa, nu ikanelvohkoy kurs haqaminihqat tuwa, kitani. ");
INSERT INTO hopNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nu umumi paṅqawni: Noqw pan hapi hak sūk̇a qaanhinmaqa tunatyay aṅqw lasq, put ep ōveqatsit ep yesqam hahlayhtotiṅwu; sinom nālöp sunat pakwt pept sihk̇ay’taqam súanhinwisqam kurs hihta aṅqw lasyaniqw, puma pumuy amuhpe qa pan hahlayhtotiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pu sen kurs hak wuhti pakwt qötsásivat himuy’k̇aṅw, sukw haqami hintsanni. Puyaw pam wihqöhit qa úwiknat, ahpave maspe’, pās hepni, pas ason put túwaniqey pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pu pam put tuwe’, kwatsmuy, pu kisṅwamuy tsovale’, paṅqawni: Huvam inumum hahlayyaa; nu sīvat haqami hintsanqey ahoy tuwa, kítani. ");
INSERT INTO hopNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nu umumi paṅqawni: Noqw pan hapi hak suhk̇a qaanhinmaqa tunatyay aṅqw lasq, put ep God hoṅviaymat pas hahlayhtotiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pu pam paṅqawu: Hak tāqa lȫqmuy tiyotimuy’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Noqw tsāywa nay aw paṅqawu: Inaa, as um hihta úhimuy aṅqw imakiway nuy máqani. Noqw pam hihta akw qátuhqey tiyotimuy namqana. ");
INSERT INTO hopNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Noqw ahpiy qa wūhakis talq, pay tsāywa sohsok hihta himuy tsovalat, yāvoqhaqamii; nihqe pepehaq qahopqatuhqe, hihta himuy paysoq hintsana. ");
INSERT INTO hopNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nihqe pam put sohsokq, pep tutskwat ep wukotöṅösti; noqw put ahpa’ himu súlawhti. ");
INSERT INTO hopNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Noqw pam pep tutskwat ep hakiy sinot aw nātuwikta. Noqw pam haqe’ pāsay aw put hōnaqw, pam pitsōtivokmuyatuy lālayi. ");
INSERT INTO hopNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Noqw pitsōtim hihta pahpuyat nōnovaqw, as pam put öyniqe amumi kwaṅwáy’tuswaqw, pas qa hak put hihta maqa. ");
INSERT INTO hopNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Noqw pam unaṅwtalawvaqe paṅqawu: Istáthihi! K̇aysiwhqam inay eṅem hihta ōviy tumalay’yuṅqam nȫsiwhqat qarūrumnayaqe, akwsiṅwni’yuṅqw, nu yephaqam tsöṅmomoki. ");
INSERT INTO hopNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Han pi inay aqwnen, aw paṅqawu: Inaa, pas nu Oveqatsit ep Qátuhqat ehpewi qaanhti, piw uhpewii. ");
INSERT INTO hopNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nihqe soon nu yan’ewaynīkanw uhtinihqey pan túṅwantiwni. Pay um nuy tumal’ayatani, nu kítani. ");
INSERT INTO hopNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pu ōviy pam wunuptut, nay aqw’a. Noqw pam nāt yāvaqniqw, naat put túwahqe, ehpewi wárikqe, kwapk̇aqe súmavoktat, put tsohtsona. ");
INSERT INTO hopNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Noqw tiat put aw paṅqawu: Inaa, pas nu Oveqatsit ep Qátuhqat ehpewi qaanhti, pu uhpewii, nihqe soon nu yan’ewaynīk̇aṅw uhtinihqey pan túṅwantiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Noqw pay naat tumal’aymuy amumi paṅqawu: Uma pew yuwsit susnukṅwat yawwise’, put yuwsinayani. Pu uma taṅapsomnayat, totsvaknayani. ");
INSERT INTO hopNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nen uma wakashoyat wívakiwtaqat pew wikye’, nīnayani; noqw itam nōnove’, hahlayyani. ");
INSERT INTO hopNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","I’ iti as soñawnen mokt ahoy tātayi; i’ as kurs haqaminit ahoy nātuwiwa. Noqw pahsat pu puma hahlayhtivaya. ");
INSERT INTO hopNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Noqw tiat wūyoqwa pasvehaqam tumalay’ta. Nit pam kīmi hayiṅwnaqw, ep lēlenyaqat, pu tīvaqw, pam navota. ");
INSERT INTO hopNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nihqe pam sukwat tumal’ayat wáṅwayhqe, puma hinoqw pantsatsk̇aqat put tūviṅta. ");
INSERT INTO hopNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Noqw pam put aw paṅqawu: Uhtupko pitu; noqw una wakashoyat wívakiwtaqat put eṅen nīna, pam put qahintaqat suphelawtaqat pitsínaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Noqw pay pāvaat itsívutiqe, aw pákiniqey qa nakwha. Noqw ōviy naat aw yámakqe, aw kuwawayku. ");
INSERT INTO hopNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Noqw pam lavayhtiqe nay aw paṅqawu: Istáthihi! Nu hihsa’haqam yahsaṅwuy aṅ uṅem tumalay’ta; piw nu qa hisat uhtutavoy hihtawat qaanhti. Noqw nu ikwátsmuy amumum hahlayniniqw, um qa hisat nuy kapirshoyat maqa. ");
INSERT INTO hopNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Noqw i’ uhti tuwat nāhuhyayaqamuy amuhpa’ uṅ hihta akw qátuhqat sohsok’o. Noqw pam ahoy pituqw, āpiy pay um put eṅem wakashoyat wívakiwtaqat nīna. ");
INSERT INTO hopNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Noqw naat put aw paṅqawu: Itii, pay pi um sutsep inumum yanta; noqw sohsok himu ihimu úhimuu. ");
INSERT INTO hopNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pay pi tatam itam qatsítote’, hahlayyani. Pi i’ uhtupko as soñawnen mokt, ahoy tātayi, kurs haqaminit ahoy nātuwiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pu piw pam put aw nánatuwnayaqamuy amumi paṅqawu: Hak k̇ahaktaqa hakiy put eṅem hihta himuyat aw tunatyawtaniqat aw tavi. Noqw yaw put himuyat aw tunatyawtaqa put himuyat hovalantaqat moṅwíyat āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Noqw pam wáṅwayhqe, put aw paṅqawu: Ya nu it hihta navota? Um hin hihta ihimuy as tunatyawtaqey nuy āawnani; pay um soon pāpu hihta ihimuy aw tunatyawtani. ");
INSERT INTO hopNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pu pahsat pam hak hihta aw tunatyawtaqa unaṅwpeq paṅqawu: Ya sen nu hinhtini? Imoṅwi itumalay nuy nawhkiniq’ö. Kurs nu hin pasva tumalay’tani; nu hihta tuṅlay’taniqey hahmana. ");
INSERT INTO hopNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hal kurs nu yanhtini. Noqw hisat nu itumalmakiway aṅqw ayo tūviwhq, sinom nuy kiy ep pās taviyani. ");
INSERT INTO hopNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kítahqe, ōviy pam moṅwíyat aw pöiwyuṅqamuy nānap wáṅwayhqe, mohti’maqat aw paṅqawu: Um hihsa’haqam imoṅwiy aw pöiwta? ");
INSERT INTO hopNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Noqw pam paṅqawu: Pay tsivót‐sikip sunat tuwanit wihkuyita. Noqw pam put aw paṅqawu: Uhpöiy pey’taqat kwusut, ayam suqtuptut, lȫq sunat pakwt sihk̇ay’taqat pēnaa. ");
INSERT INTO hopNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pahsat pu pam piw sukwat aw paṅqawu: Noqw umwa hihsa’haqam pöiwta? Noqw pam paṅqawu: Pay tsivót‐sikip sunat tuwanit söhövosita. Noqw pam put aw paṅqawu: Uhpöiy pey’taqat kwusut, nālöp sunat pēnaa. ");
INSERT INTO hopNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Noqw put moṅwíat put ep put aw tayawinlavayhti, pas pam tuhishinhtiqw ōviy’o, nāmahin pi as pam qa súan hinhtiq’ö. Pi yep qatsit tunatyayat aṅ hinwisqam nāp sinomuy amumiwat pas qa ūunatu. Noqw pay tālat aṅ hinwisqam qa pumuy amún tutuhistu. ");
INSERT INTO hopNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Noqw nu umumi paṅqawni: Uma yep qatsit ep hihta umuhimuy akw nenṅem tūkwatslalwani; noqw ason umuhimu súlawhtiqw, puma umuy haqam sutsep yesniqat aw ökinayani. ");
INSERT INTO hopNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Hak sustsa’ ep qa paysoq hintsakqa piw nihtiwtaqat ep qa paysoq hintsakṅwu; pu sustsa’ ep paysoq hintsakqa piw nihtiwtaqat ep paysoq hintsakṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Paniqw ōviy kurs uma yep qatsit ep hímuy’tiwhqat paysoq hintsatsne’, ya sen hak hihta hihk̇ay’taqat pas antsanihqat umumi nóani? ");
INSERT INTO hopNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pu uma hihta qa umuhimuy aw qa suan tunatyawwisq, ya sen hak hihta pas umuhimuyniniqat umumi nóani. ");
INSERT INTO hopNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kurs hin tumal’aya lȫqmuy moṅwímuy amuṅem tumalay’tani; ispi soon pam qa sukwat aw pay qa yan unaṅway’k̇aṅw, súkwat‐sa pas hahlayni; sen pay hihtawat‐sa aw pas yuki’k̇aṅw, pu sukwat pay qa hímuni. Kurs hin uma k̇āhakiwuy ōviy tumalay’k̇ahk̇aṅw, piw God eṅem tumalay’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Noqw Pharisee‐sinom sīvat tuṅlay’yuṅqam sohsok it nanapta; nihqe put aw tututsiwya. ");
INSERT INTO hopNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Noqw pam pumuy amumi paṅqawu: Uma pi sinmuy amumi lolmat nālavaytaṅwu; noqw pi God umumi umuh’unaṅway navoti’ta. Pi himu sinmuyniqw pas hímunihqa God‐niqw tuyoy’eway’o. ");
INSERT INTO hopNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Hisat John pítuhqat aw pahsavo hin hinwisniqa tutavo yuaatiwa, pu God lavay’aymuyatuy lavayiam pīwu. Noqw pahpiy pu’ God moṅwtunatyayat yuaatiwhq, sinom sohsoyam aqw nānaqasya. ");
INSERT INTO hopNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pay tokpela, pu tūwaqatsi tūwayaniqw, pam pantaqa qa pas hinta; noqw pay tutavot ep sushihsay pey’taqa alöṅtiniqw, pam pantaqa pas qatuvosi. ");
INSERT INTO hopNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nȫmay mātapqa piw sukw amum qatupte’, tokot sokoptaṅwu; pu puwsuṅway aṅqw mātaviwhqat amum qatuptuqa tokot sokoptaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Hak k̇ahaktaqa tsatsákwmötsaput a’nö hihk̇ay’taqat yuwsi’k̇aṅw, nāqavo hihta nasani’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Noqw pu piw hak okiw hihta nuhtumi tuṅlay’taqa, Lazarus yan mātsiwhqa put hötsíwat epeq taviwa, u’yasanīk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nihqe pay okiw as ṅas’ew pam k̇ahaktaqat nönöspiyat aṅqw hihta piṅput tūmoytaniqey nāwakna. Noqw popkot ök̇e’, okiw put uyayat aṅ leñitsmitotaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Noqw ahpiy pantaqw, i’ okiwsino mōki, Noqw God hoṅviaymat put ōmiq wikyaqw, pam Abraham aqlap qatuptu. Noqw pu tuwat k̇ahaktaqa mokqe āmiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nihqe maskiveq k̇ānavoti’k̇aṅw, kwuhpukqe, Abraham yāvoq tuwa, pu Lazarus put aqlap qátuhqata. ");
INSERT INTO hopNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pu pam tsa’lawhqe paṅqawu: Inaa, Abraham, um okiw nuy ōkwatuwe’, peqw Lazarus hōnaqw, pam malatsiy tsukuyat kūyit aqw móroknat, ileñiy huk̇anani; taq nu yepeq ūwiṅwuy ep pas okiw k̇ānavoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Noqw Abraham paṅqawu: Itii, pay ura um uhqatsiy ep hihta úhimuy lolmat ömahta; noqw pu pan piw Lazarus hihta qalolmat ömahta. Nit pu’ pam suyan unaṅwtiqw, umwa tuwat k̇ānavoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pu piw pi itamuhtsave a’nö tupqa yukilti; pantaqw ōviy as yaṅqw umumiqyaniqam kurs hinyani; pu piw as umuṅaqw peqwyaniqam kurs hinyani. ");
INSERT INTO hopNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pahsat pu pam paṅqawu: Inaa, um as turs inay kīyat aw put hōnani. ");
INSERT INTO hopNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Taq nu tsivot tupkomuy’ta. Noqw pam hin yórikqey pumuy āawnaqw, puma qa tuwat peqw k̇ānanvotpit aqwyani. ");
INSERT INTO hopNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Noqw Abraham put aw paṅqawu: Pay pi puma Moses‐nik̇aṅw pu God lavay’ayamuyatuy lavayiyamuy oyi’yuṅwa. Pay ason pumuy amumi tūqayyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Noqw pam paṅqawu: Qae, Ina Abraham, pay hak so’pumuy amuṅaqw amuminiqw, soon puma tunatyay aṅqw qa lasyani. ");
INSERT INTO hopNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Noqw pam put aw paṅqawu: Pay pi puma Moses‐nik̇aṅw pu God lavay’aymuyatuy lavayiyamuy qa aw tūqayyuṅwe’, nāmahin pi hak so’pumuy amuṅaqw ahoy tātayhq soon tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Pahsat pu Jesus put aw nánatuwnayaqamuy amumi paṅqawu: Pas soon sinmuy lomavöhut aṅqw lasnayaqam haqami peveltini. Nīk̇aṅw pumuy amuṅem pas is’óhini. ");
INSERT INTO hopNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kurs hak imuy tsātsakwmuy hihtawat ayo lasnaqw, put eṅem pas is’ohini. Pay pi tatam māta put kwapk̇aqe hāyiltiqw pam wuhkovatuphamiq tūviwhq, pam put eṅem lolmani. ");
INSERT INTO hopNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Uma nānami tunatyaltotini, kurs uhpava, sen uhtupko ūmi qaanhtiqw, um put u’nanani. Noqw kurs pam qaanhtipuy ep qahahlayhtiqw, pay um put pantaqat put ahpiy ayo yúkuni. ");
INSERT INTO hopNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pu kurs pam tāwat ep tsaṅe’sikis ūmi qaanhte’ put tāwat ep tsaṅe’sikis ūminen, qahahlayhtiqey paṅqawhq, um hapi put pantaqat put ahpiy ayo yúkumantani. ");
INSERT INTO hopNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Noqw ayaiwyuṅqam Tutuyqawhqat aw paṅqaqwa: Um okiw itahtuptsiwniy aw hóyoknani. ");
INSERT INTO hopNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Noqw Tutuyqawhqa paṅqawu: Kurs uma pay hihin tuptsiwni’yuṅwe’, nāmahin pi pam mustard‐uyit pōsiyat an tsāyniqw, uma it sycamine‐tsokit ṅáipwaniwe’, wuhkovatuphaveq kwihpiwniqat paṅqaqwaqw, soon pam umuhlavayiy qa anhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kurs uma haqawa tumal’ayay’taqw pam haqam tutskwat qöritani, sen wāwakastuy nopni’tani. Ason pam pasṅaqw pituqw, ya um put aw yan lavayhtini: Taay, um tunösvoñat aw qatuptuni, aw kítani? ");
INSERT INTO hopNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sóoni. Um yanwat put aw layayhtini: Um namuptat inuṅem nōvatat, nuy nopnani. Noqw nu tūmoytani, pu hikwni. Ason pay um inuṅk nösni, pu hikwni, kítani. ");
INSERT INTO hopNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ya sen um put aw kwakwhatani, pam hin ayatiwhqey anhtiqat ep’e? Pay k̇a sóon’i. ");
INSERT INTO hopNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Noqw pay pan hapi ōviy piw uma tuwat hin ayatiwye’, sohsok anhtote’ paṅqaqwani: Pay itam okiw qa hihta apitoti. Pi pay itam itah’ayaway‐sa anhtoti, kitotani. ");
INSERT INTO hopNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Noqw pam Jerusalem aqwnihqe, Samaria‐tutskwat, pu Galileet‐tutskwat paṅ qaqlavaqa paṅsoq’a. ");
INSERT INTO hopNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nihqe pam haqam kitsókimi pituqw, hakim pakwt tahtaqt tokoplelet tūtuyyaqam put ahsawvayaqe yāvaqw hōñi. ");
INSERT INTO hopNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nihqe puma paṅqw tsa’lalwaqe paṅqaqwa: Jesus, Moṅwi, um okiw itamuy ōkwatuwni. ");
INSERT INTO hopNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Noqw pam pumuy túwahqe, amumi paṅqawu: Huvam God awwat momṅwituy amumi nāmahtaknawisaa. Noqw puma nāto aqwyak̇ahk̇aṅw, pay powaltoti. ");
INSERT INTO hopNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Noqw pumuy amuṅaqw sūk̇a qalaptuqey navotqe, ahoy namtökt, pu pas tönay aṅqe’ God pas hihtata. ");
INSERT INTO hopNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nihqe pam Jesus kukmiq nātuvaqe put aw put ep hahlayhti. Noqw pam hak Samariat aṅqw sino. ");
INSERT INTO hopNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Noqw Jesus lavayhtiqe paṅqawu: Ya qa pakwtnihqam powaltoti? Noqw ya ima peptnihqam haqamiya? ");
INSERT INTO hopNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ya pay qa hak God pas hihtataniqe pitu, hal pay i’ qa‐Jew‐sino‐saa? kita. ");
INSERT INTO hopNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pu pam put aw paṅqawu: Wunuptut, aqwhaqamii. Pay um qapēvewnaqe qalaptu. ");
INSERT INTO hopNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Noqw hisat God moṅwtunatyayat aw pítuniqat ima Pharisee‐sinom Jesus tūviṅtota. Noqw pam umumi paṅqawu: Pi God moṅwtunatyaat qa susmataqpuva pítuni. ");
INSERT INTO hopNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Soon hak paṅqawni: Meh, pam ep’e, sen Meh, pam ayamo, kítani. Ispi meh, God moṅwtunatyaat yep umuhsonveniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pu pam put aw nánatuwnayaqamuy amumi paṅqawu: Pay uma nāto nuy Sinot Tiyat as ṅas’ew sūs talöṅvaqat ep umumumniqat nānawaknaniqw, soon pam antani. ");
INSERT INTO hopNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Noqw ephaqam sinom umumi paṅqaqwani: Meh, pam yep’e! sen Meh, ayamo! kitotani. Noqw uma hapi qa aqwyani; piw qa amuṅkyani. ");
INSERT INTO hopNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pi talwihpiki tokpelat aṅ ahsupoq tālawvaṅwu. Noqw pay hapi pan piw nu Sinot Tiat italöṅiy ep hinhtini, hisat pítee. ");
INSERT INTO hopNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nīk̇aṅw pay mohti pu’ qatsívaptsiwyuṅqam nuy hīhihta akw okiwsasnayani, pu nuy tūvayani. ");
INSERT INTO hopNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noqw ura Noat qatsíyat ep hin yēsiwhq, pay hapi pan piw hintani, hisat nu’ Sinot Tiat ahoy pítuq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ura puma nōnova, hīhikwya, nȫmalalwa, puwsuṅwlalwa, hisat Noa pākihut aqw pákihqat aw pahsavoo. Noqw pātsikq, puma sohsoyam súlawhti. ");
INSERT INTO hopNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pu pay ura piw pan Lot qatsíyat ep hinta. Sinom nōnova, hīhikwya, hihta tuhtuy’ya, hihta huyalalwa, uylalwa, pu kīlalwa. ");
INSERT INTO hopNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Noqw ura hisat Lot Sodom aṅqw ahpiyniqw, ep tāwat ep ūwiṅw hihta sik̇ahpik owat enaṅ ōṅaqw löhöhöykuqe sohsokmuy kīqöta. ");
INSERT INTO hopNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Noqw nāt hapi pantani, hisat nu’ Sinot Tiat mātaqtiq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Put talöṅvaqat ep kits’oveqnihqa paṅqw hāwe’, nawus soon hihta himuy ōviy ahpami papkini, súwayaniqe ōviy’o. Pu piw pasvenihqa qa kīmii. ");
INSERT INTO hopNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Uma Lot nȫmayat u’ni’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Qatsiy ayo táviniqey tunatyawtaqa put kwayhni; pu qatsiy kwayhqa hapi put ayo távini. ");
INSERT INTO hopNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nu umumi paṅqawni: Put tōkilat ep hakim lȫyöm sūkw puvuwhpit aṅ qatsni. Suhk̇a wīkiwhq, suhk̇a akwsiṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hakim lȫyöm wuhtit nāma ṅúmantani. Suhk̇a wīkiwhq, suhk̇a akwsiṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hakim lȫyöm pasve hinnumni. Suhk̇a wīkiwhq, suhk̇a akwsiṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Noqw puma lavayhtotiqe put aw paṅqaqwa: Háqamni, Tutuyqawhqa? Noqw pam pumuy amumi paṅqawu: Pay haqam himu mokputniqw, paṅso hapi wiwisokt sumitsovaltiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Noqw sinom sutsep nānawakne’, qa naṅ’eknayaniqat Jesus pumuy tutuqaynaniqey nāwakna. Nihqe ōviy pam it tūwutsit akw umumi lavayhtiqe, ");
INSERT INTO hopNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Paṅqawu: Haqam kitsókit ep hak tāqa qatu. Pam hak sinmuy amuṅem hin yuykuṅwu; nīk̇aṅw God qa mamqasi, piw sinmuy qa k̇aptsi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Noqw pu piw pay pep hak koṅnalavu qatu. Noqw pam hak wuhti tāqat aw pítuhqe aw paṅqawu: Um inuṅem ituwqay aw nāoyni. ");
INSERT INTO hopNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Noqw pay as pam hihsavo qa nakwha; nit pay unaṅwpeq paṅqawu: Pay as pi nu God qa mamqasi, piw sinmuy qa k̇aptsi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Noqw i’ koṅnalavu inumi sus’itsq, pay ōviy nu eṅem nāoyni. Taq pam aṅk sasqe, nuy puhtsemoknani, kita. ");
INSERT INTO hopNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pu Tutuyqawhqa paṅqawu: Taay, kurs huvam sinmuy amuṅem hin yuykuṅwuqa qa súanhinmaqa hin lavayhtiqat nanaptaa. ");
INSERT INTO hopNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Noqw puyaw God pas aṅ nāp namoramuy put aw tālö’nik̇aṅw, pu tōkilat aṅ tsaykitaqamuy amuṅem qa nāoyni? Ya pam sȫwuni? ");
INSERT INTO hopNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nu umumi paṅqawni: Pas soon pam pumuy amuṅem qa súnaoyni. Noqw pay pi as pantaqw ason nu’ Sinot Tiat hisat pite’, ya nu sinmuy qapēvewni’yuṅqamuy túwani? ");
INSERT INTO hopNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Noqw haqawat suan hinyuṅqey qanāvevewnayaqam ayam pētuy qahihtay’yuṅwa. Noqw Jesus pumuy amumi it tūwutsit lavayhti: ");
INSERT INTO hopNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Hakim lȫyöm tāqat nāwaknaniqe God kīyat aw paki. Suhk̇a Pharisee‐sínoniqw, pu suhk̇a moṅwit eṅem sīvat ömalawhqa. ");
INSERT INTO hopNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Noqw Pharisee‐sino wunuwk̇aṅw, nāwaknaqe yan nāyuaata: Kwakwhay God. Kwakwhat pi nu sinmuy qa amunta‐hihta tukwhantota, qa suan hinyuṅwa, qa nāp himuy amum hinwisa, hal hikis yep moṅwit eṅem sīvat ömalawhqat an’i. ");
INSERT INTO hopNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nu tsaṅe’sikis talöṅwintiwhqat aṅ lȫs napwalaṅwu. Nu sohsok hihta ihimuy pakwút‐sikivo sun oyiwtaqat aṅqw sūp oyit ūmi nóaṅwu, kita. ");
INSERT INTO hopNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Noqw moṅwit eṅem sīvat ömalawhqa pay ayam haqam wunuwk̇aṅw, soon ṅas’ew ōmi kwuhpukniqe okiw tawitsqay wuvahtik̇aṅw paṅqawlawu: God, um okiw nuy qaanhinmaqat ōkwatuwni, kita. ");
INSERT INTO hopNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nu umumi súaṅqawni: I’wa qenive wunuwk̇aṅw, nima; noqw mi’wa qa pank̇aṅw ahpiy’o. Pi nāhihtataqa qahimuniwhtini; noqw nāqahihtataqa pas pavan hímuniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Noqw sinom Jesus aw titipostuy tsamvaya, pam amumi tóṅokniqat ōviy’o. Noqw put aw nánatuwnayaqam amumi yórikyaqe, pumuy mēwa. ");
INSERT INTO hopNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Noqw pay Jesus pumuy wáṅwayhqe paṅqawu: Uma tsātsakwmuy inumiyaniqat nakwhanayani, nen qa mēwantotani. Pi puma hapi God moṅwtunatyayat aw yuṅni. ");
INSERT INTO hopNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pas antsa nu umumi paṅqawni: Pas God moṅwtunatyayat tsākw qa an kwúsuhqa soon paṅso pákini. ");
INSERT INTO hopNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Noqw hak pavansino Jesus tūviṅtaqe aw paṅqawu: Lolma Tutuyqawhqa, ya nu hihta hinhte’, qatsit qaso’taqat himuy’vani? ");
INSERT INTO hopNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Noqw Jesus put aw paṅqawu: Ya hinoqw um nuy lolmalawu? pi qa hak lolma, pas sūk̇aa, God. ");
INSERT INTO hopNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pay um hin hinwisniqat tutavot navoti’ta: Um tokot qa sokoptani; um qa hakiy nīnani; um qa hihta ūuyni; um hakiy qa atsátoynani; um unay, pu uṅuy pumuy k̇aptsi’tani, it’a. ");
INSERT INTO hopNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Noqw pam paṅqawu: Pas nu itsákoy aṅqaqw īit aṅ ahsupoq hinma. ");
INSERT INTO hopNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Noqw Jesus it navotqe, put aw paṅqawu: Nīk̇aṅw um sūpwat qaanma. Um hihta úhimuy sohsok huye’, aṅ ōokiwyaqamuy put huytani. Nen um ōveqatsit ep hihta nukṅwat soon qa himuy’vani. Nit um aṅqwnen inuṅkni. ");
INSERT INTO hopNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Noqw pam it navotqe, pas qahahlayhti, pas pam qaan’ewakw k̇āhaknihqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Noqw Jesus put pas qahahlayhtiqw navotqe paṅqawu: Pas aṅ hihta akw k̇āhak’iwyuṅqam God moṅwtunatyayat aw yuṅwniniqw amuṅem qa tūvoshinta. ");
INSERT INTO hopNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pay himu pohko pȫlay’taqa tsakomostat aṅ pórokput aṅ pákiniqw, pam pantaqa pas qa tūvosi. Nīk̇aṅw k̇ahaktaqa God moṅwtunatyayat aw pákiniqw, pam put epnihqe pas qa tūvosi. ");
INSERT INTO hopNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Noqw hakim put nanaptaqam paṅqaqwa: Noqw pantaqw hak sen ayo yámakni? ");
INSERT INTO hopNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Noqw pam paṅqawu: Pay aṅ himu sinmuyniqw pas kurs hin pasiwtaniqa pay God‐niqw pasiwta. ");
INSERT INTO hopNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pahsat pu Peter paṅqawu: Meh, itam hapi sohsok hihta tatamhtotat uṅk nankwusa. ");
INSERT INTO hopNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Noqw Jesus pumuy amumi paṅqawu: Pas antsa nu umumi paṅqawni: Pas qa hak haqam paysoq God moṅwtunatyayat ōviy kiy, sen nay, sen yuy, sen pāvamuy, sen tupkomuy, sen qȫqamuy, sen siwamuy, sen nȫmay, sen timuy tatamhta. ");
INSERT INTO hopNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Pi pam yep qatsit ep pay a’nö hóyokput ömahtani, pu qatsit nātoniqat ep qatsit qaso’taqata. ");
INSERT INTO hopNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pahsat pu pam pakwt lȫq sihk̇ay’taqamuy nāmi tsovalaqe, amumi paṅqawu: Meh, itam hapi Jerusalem aqwya. Noqw God lavay’aymat Sinot Tiyat hin pēnayaqw, pam pantaqa sohsoy aw antsaniwni. ");
INSERT INTO hopNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pi nu qa‐Jew‐sinmuy amumi mātaviwhq, puma nuy tututsiwnayani; nuy okiwsasnani; pu inumi töhtotani; ");
INSERT INTO hopNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pu puma nuy wuvahtotani; pu nuy nīnani. Noqw pāyis talq nu ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Noqw pam hiṅqawhqat puma qa mātsi’yuṅwa, put lavayiat pumuy amumi tupkiwtaqw ōviy’o. Pu pam hihta paṅqawhqat puma qa māmatsya. ");
INSERT INTO hopNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pu ahpiy pantaqw pam Jericho‐kitsókit aw hayiṅwnaqw, hak qapostalqa pöhut qalave qatuk̇aṅw, okiw hihta nuhtumi tuṅlay’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Noqw sinmuy qaan’ewakw hintaqamuy paṅ haqamiyaqe mowawatiwisq, pam navotqe, put tūviṅta. ");
INSERT INTO hopNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Noqw yaw Jesus Nazareth aṅqw sínonihqa haqaminihqat puma put āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Noqw pam tsa’lawhqe paṅqawu: Jesus, um David Tíat, um okiw nuy ōkwatuwni. ");
INSERT INTO hopNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Noqw ima mohti’wisqam put mēwayaqe, pay qa hiṅqawlawniqat aw paṅqaqwa. Noqw pahsat pu pas pam tuwat pavan k̇ēew paṅqawu: Um David Tiat, um okiw nuy ōkwatuwni. ");
INSERT INTO hopNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Noqw Jesus huruhtiqe puma put aw wikyaniqat paṅqawu. Noqw pam put aw pituqw, Jesus put tūviṅtaqe, ");
INSERT INTO hopNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Aw paṅqawu: Ya nu uṅ hintsanniqat um nāwakna? Noqw pam paṅqawu: Tutuyqawhqa, um as okiw ivosiy tālawnani. ");
INSERT INTO hopNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Noqw Jesus put aw paṅqawu: Pay nam uhposiy tālawnaa. Pay um qapēvewnaqe ayo taviwa. ");
INSERT INTO hopNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Noqw pahsat pay pam pōsiy tālawna; nihqe Jesus aṅki, God pas hihtatimak̇aṅwo. Noqw sinom sohsoyam put aw yórikyaqe, God pas tayawnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Noqw Jesus Jerichot aw pítuhqe, aṅ yámakto. ");
INSERT INTO hopNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Noqw hak tāqa Zacchaeus yan mātsiwhqa pep qatu. Pam hak moṅwit eṅem sīvat ömalalwaqamuy amuṅaqw mohpeq’a; nihqe k̇āhak’i. ");
INSERT INTO hopNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Noqw pam Jesus hákiynihqat as aw yórikniqey tuwanta; noqw sinom hūrs hintaqw, pay pam kurs hin aw yórikni, hak tsāvanihqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nihqe ōviy pam amupyeve wárikqe, pas pay aw yórikniqe sycamore‐tsokit aṅ wūvi, pam paṅniniqw ōviy’o, ");
INSERT INTO hopNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Noqw Jesus put háqamniqw aw pítuhqe, ōmi tātayht, put túwahqe, aw paṅqawu: Zacchaeus, pis’oqtit hāwii, taq nu pu’ pas pay soon uhkiy ep qa huruhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pu pam pis’oqtiqe, paṅqw hawht, hahlayk̇aṅw, kiy aw put pitsína. ");
INSERT INTO hopNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Noqw sinom put aw yórikyaqe, sohsoyam qayan unaṅway paṅqaqwa: Yaw pam hakiy tāqat qaanhinmaqat kiyavaqwviatniqe ōviy ámumnihqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Noqw Zacchaeus wunuptuqe, Tutuyqawhqat aw paṅqawu: Tutuyqawhqa, nu hihta ihimuy nāsamiq yantaqat ōokiwyaqamuy huytani. Pu kurs nu hakiy sivit ep hihta paysoq nawhk̇e’, nu nālös hóyokiwtaqat put aw ahoytani. ");
INSERT INTO hopNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Noqw Jesus put aw paṅqawu: Pu’ hapi it talöṅvaqat ep um, pu umum yesqam ayo nöṅa, pay pi um Abraham ahpiy aniwhtiqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pi nu’ Sinot Tiat haqami hiniwhtotiqamuy hēve’, ayo óyaniqe pitu. ");
INSERT INTO hopNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Noqw pumuy īit nanaptaqw, Jesus qa lavayyukut, pumuy amumi hihta tūwutsit akw yuaayku, pam Jerusalem aqw pitutoqe ōviy’o. Noqw k̇a God moṅwtunatyaat āpiy pay mātaqtiniqat sinom pan wūwantota. ");
INSERT INTO hopNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Noqw ōviy pam paṅqawu: Hak pavansino moṅwtunatyat makiwniqe ōviy yāvoqhaqamii, pay nāt piw ahoy pítunikaṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nihqe pam tumal’aymuy pakwtnihqamuy wáṅwayht, amumi pakwút‐sikip sunat sīvat oyat, amumi paṅqawu: Uma inuhsavo it apitoyni’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Noqw put amum sinoiwtaqam put aw qa suhtaq’ewyaqe aṅk hakiy hōnaqe paṅqaqwa: Itam it itamumi moṅw’iwtaniqat qa nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Noqw ahpiy pantaqw pam moṅwtunatyat makiwhqe, ahoy pitu. Nihqe pahsat pu imuy tumal’a’yatuy amumi sīvat óyahqey pumuy wáṅwayniwyaniqat pam paṅqawu, puma huhyayaqw, hihsa’haqam pi hak aw hóyoknaṅwuqat navotniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Noqw pahsat pu mohti’maqa pítuhqe aw paṅqawu: Moṅwi, ura um inumi sunat sīvat noaqw, nu put aw pakwút‐sikip sunat sīvat hóyokna. ");
INSERT INTO hopNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Noqw pam put aw paṅqawu: Um súanhti, lomatumal’aya. Um hihta qa hímunihqat ep qa paysoq hintsana, ōviy um pakwút‐sikip wuhkokitsokit aw moṅw’iwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pahsat pu aṅknihqa pítuhqe aw paṅqawu: Moṅwi, ura um inumi sunat sīvat noaqw, nu put aw tsivót‐sikip sunat hóyokna. ");
INSERT INTO hopNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Noqw moṅwi put aw piw an lavayhtiqe paṅqawu: Pay ōviy piw um tsivót‐sikip wuhkokitsokit aw moṅw’iwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Pu piw suhk̇a pítuhqe put aw paṅqawu: Moṅwi, taay, yep uhsiva. Nu uṅ mamqasqe, ōviy nu it höhönpit ep put mōki’ta. Um pi a’nö unaṅway’taqe, haqam hihta qa tavit ep kwúsuṅwu; pu um hihta qa uyht put höqṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Noqw moṅwi put aw paṅqawu: Nu nāp uhlavayiy akw uṅ hin yukunani, um nukpantumal’aya. Kurs um nuy a’nö unaṅway’taqw put navoti’ta. Kurs nu haqam hihta qa tavit ep kwúsuṅwu, pu hihta qa uyht put höqṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ya hinoqw um nuy pantaqw tis nāpi isivay sivakimi qa pana? Pi um panhtiqw, nu pite’, ihimuy‐nik̇aṅw pu put ep ahsatit enaṅ ömahtani. ");
INSERT INTO hopNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pu pam aqlaq hoṅqamuy amumi paṅqawu: Uma put sīvayat nawhkiyat pakwút‐sikip sunat sīvat himuy’taqat put maqayani. ");
INSERT INTO hopNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Noqw puma put aw paṅqawu: Moṅwi, pay pam pakwút‐sikip sunat sīvay’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Noqw pam amumi paṅqawu: Nu umumi paṅqawni: Aṅ himuy’yuṅqam piw hihta makiwyani. Pu ṅastanihqa hikis as pay hihta himuy’taqey kwayhni. ");
INSERT INTO hopNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pu imuy ituwqamuy nu amumi moṅw’iwtaniqat qa nānawaknaqamuy uma pew tsamye’, inutpip qöqyani, ");
INSERT INTO hopNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Noqw Jesus yan lavayhtit, sinmuy amupyeve Jerusalem aqwat nakwsu. ");
INSERT INTO hopNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nihqe pam haqam tsomot, Olivet yan mātsiwhqat, aw pitu, Bethphage‐kitsókit‐nik̇aṅw, pu Bethanyt‐kitsókit, pumuy hayiṅwnaqee. Nihqe pam lȫqmuy put aw nánatuwnaqamuy ayataqe, ");
INSERT INTO hopNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Amumi paṅqawu: Uma umupyeve kitsókit awni. Nen uma ep pak̇e’, morohyat sómiwtaqat túwani. Nāt pas qa hisat hak aqw wūvi. Uma put ṅaht, aṅqw wikni. ");
INSERT INTO hopNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Noqw ason kurs hak umuy hinoqw put ṅáṅahqat tūviṅtaqw, uma yan lavayhtini: Tutuyqawhqa it nāwaknaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Noqw ima ayaiwhqam ahpiynihqe, hin pam pumuy amumi lavayhtiqat an yori. ");
INSERT INTO hopNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Noqw puma morohyat ṅaṅahq, pohkoy’yuṅqam amumi paṅqaqwa: Ya uma hinoqw morohyat ṅáṅaha? ");
INSERT INTO hopNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Noqw puma paṅqawu: Itahtutuyqawhqa it nāwaknaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nihqe puma put Jesus aw wikvaqe, yuwsiy morohyat aqw ahpatat, put aqw Jesus tsok̇a. ");
INSERT INTO hopNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pu pam paṅ nakwsuqw, sinom pö́nawit yuwsiy ahpatota. ");
INSERT INTO hopNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pu ōviy pam kitsókimi hayiṅwnaqe, pāpu pay tsomot Olivet aṅ pihpoqniqw, pahsat pu sohsoyam put aṅk wīsiwtaqam pas tönay aṅqe’ God tayawintivaya, pu pam sohsok hihta qaöwítumaltaqw, put ep puma put pas hihtativaya; ");
INSERT INTO hopNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nihqe paṅqawtiwisa: Nam Moṅwi, Tutuyqawhqat natṅwaniyat aṅ pitútoqa tayawintiwaa. Nam ōveqatsit ep kwakwhat yēsiwaa. Nam Sus’ovenihqa, k̇aptsitiwaa. ");
INSERT INTO hopNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Noqw haqawat Pharisee‐sinom sinsonṅaqw Jesus aw paṅqaqwa: Tutuqaynaqa ūmi nánatuwnayaqamuy mēwaa. ");
INSERT INTO hopNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Noqw pam lavayhtiqe amumi paṅqawu: Nu umumi súaṅqawni: Pas imuy qa hiṅqaqwaniqw, soon yaṅ o’wa qa sáakmani. ");
INSERT INTO hopNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Noqw pam Jerusalem aw hayiṅwnaqe aw tātayhqe, put ep paklawu, paṅqawkaṅwo: ");
INSERT INTO hopNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Is as uma yepehaq pu’ kwakwhat yēsiwniqat haqe’ qatsqat māmatsyani! Noqw núṅwupi umuhposi qatālawva. ");
INSERT INTO hopNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pi nāt hisat aw pituqw, umuhtuwqam namurulnit akw umuhkitsokiy póṅokni, nānan’ivaqw put uhtayani. ");
INSERT INTO hopNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nen put tutskwami sahpuknayani, uma pep ki’yuṅqamuy énaṅa. Noqw pep qa haqam owa nāp qeniy ep akwsiṅwni, ispi Sus’oveqnihqa umumi pohtaqw, uma put qa mātsi’yuṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pu pam God kīyat aw pákihqe, pep hihta huhyayaqamuy, pu tuhtuy’yaqamuy paṅqw ipwanva; ");
INSERT INTO hopNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nihqe amumi paṅqawu: Ikiy ep nāwakintotamantani. Noqw uma soq put uuyiṅtuy kivatoynaya. ");
INSERT INTO hopNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pu pam nāqavo God kīyat ep tūtutuqayna. Noqw pay God awwat mohpeq momṅwit‐niqw, pu tutavot tūtutuqaynayaqam‐niqw, pu sinmuy amuṅaqw pavansinom, puma hin as put nīnayaniqey hēvi’yuṅwa; ");
INSERT INTO hopNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nit hinhtotiniqey qa tutwa, sinom sohsoyam put aw pās tūqayyuṅqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pu hisat pam God kīyat ep sinmuy tutuqaynaqe lomatuawit yuaata. Noqw God awwat mohpeq momṅwit‐niqw, pu tutavot tūtutuqaynayaqam, wukw’a’yatuy amumum put aw ö́kihqe, ");
INSERT INTO hopNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Aw paṅqaqwa: Kurs itamuy hihta āawnaa. Ya um hihta öqalat aw yank̇aṅw īit hintsaki? Ya hak uṅ it öqalat maqa? ");
INSERT INTO hopNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Noqw pam lavayhtiqe amumi paṅqawu: Kurs nu tuwat umuy sūkw hihta tūviṅtani. Noqw uma nuy āawnayani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ura John kūyit akw tūtuvoylalawu. Ya pam haqaqw put makiwa? Sen ōveqatsit aṅqö’? Sen sinmuy amuṅaqö’? ");
INSERT INTO hopNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Noqw puma put nānami yuaatotaqe paṅqaqwa: Ya sen itam Oṅaq’ö, kitotani? Soon qa pam itamumi paṅqawni: Noqw hinoqw uma put aw qa tūtuptsiwa? ");
INSERT INTO hopNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ya sen itam Sinmuy amuṅaq’ö kitotani? Noqw soon sinom sohsoyam itamuy qa tatatupqöqyani. Pi púmuyniqw John pas antsa God lavay’ayaata. ");
INSERT INTO hopNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Noqw ōviy puma lavayhtotiqe aw paṅqaqwa: Pay kurs pi hin put háqaqwnihqat itam paṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Noqw Jesus pumuy amumi paṅqawu: Pay ōviy nu piw soon hihta öqalat aw yank̇aṅw īit hintsakqey umuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pahsat pu pam tūwutsit hihta tuawi’taqat sinmuy amumi yuaativaqe amumi paṅqawu: Hak tāqa ōvat uyht, tumalay’yuṅqamuy amumi put mātapt, wūyavo yāvoqhaqamii. ");
INSERT INTO hopNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pu ōvat kwaṅwtinisavotiqw, pam ovauyit tumalay’yuṅqamuy amumi hoṅviayay hōna, puma aniwniyat aṅqw put maqayaniqat ōviy’o. Noqw tuwat soq ovauyit tumalay’yuṅqam put wuvahtotat, qa hihta hintaqat paṅqw hōnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pu piw pam sukw hoṅviayay pumuy amumi hōna. Noqw pay puma piw put wuvahtotat, hamanhintsatsnat, qa hihta hintaqat paṅqw lālayya. ");
INSERT INTO hopNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pu amuṅk pu’ pam piw sukw pumuy amumi hōna. Noqw piw pay puma put ȫputotat, qalavohaqami tūvaya. ");
INSERT INTO hopNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pahsat pu ovauyit himuy’taqa paṅqawu: Ya sen nu hinhtini? Han pi amumi pas aw iunaṅway itiy tavi. Pay k̇a as puma put aw yórikye’, k̇aptsitotani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Noqw ovauyit tumalay’yuṅqam put tutwaqe, nānami lavayhtotiqe paṅqawa: I’ hapi nay akpetani. Taay, itam nīnayaqw, himu himuatniqa itahhimuniwhtini, kitota. ");
INSERT INTO hopNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pu ōviy puma ovauyit aṅqw qalavohaqami put wikyat, nīnaya. Taay, noqw ya ovauyi’taqa it ep sen pumuy hintsanni? ");
INSERT INTO hopNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pam pite’, imuy tumalay’yuṅqamuy qöye’, pas pētuy amumi ovauyit noani, pam kita. Noqw puma put nanaptaqe paṅqaqwa: Soon pantani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Noqw pam pumuy amumi tātayht, paṅqawu: Ura yan pey’ta: Owa kīlalwaqamuy amuhpiy qalavo tūviwhqa hapi tuyqaatniwhti, yan’i. Noqw ya pam lavayi hihta lavayhti? ");
INSERT INTO hopNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Put owat ep yēvaqa yoyhni. Nīk̇aṅw ason pam hakiy aw yēve’, tostani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Noqw God awwat mohpeq momṅwit, tutavot tūtutuqaynayaqamuy amumum put lavayiyat māmatsya, suyan pi pam pumuy amunkiwakw sōmokyuaaykuq’ö; nihqe ōviy puma āpiy put ṅuayaniqey anhtotik̇aṅw, sinmuy mamqastoti. ");
INSERT INTO hopNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Noqw ōviy puma put aw pās tūqayyuṅwa, piw hakim put mokmani’yuṅwniqat put aw hōnaya, puma hakim suan hinyuṅqey as nawip’ew hinyuṅq’ö. Nen puma put lavayiyat unahepye’, pep tutskwat ep öqalayat, pu tunatyayat aw put mātapyani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Noqw puma put tūviṅtotaqe aw paṅqaqwa: Tutuqaynaqa, itam ūmi navoti’yuṅqw, um suan yuaatak̇aṅw hihta súantaqat sinmuy tutuqayna. Pu um qa hakiy pas hihtay’k̇aṅw, pas qa atsat God tunatyayat tūtutuqayna. ");
INSERT INTO hopNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ya pay itam hihta aṅ sivit Caesar aw ōoyyaniqw, pam súanta, sen qa súanta? ");
INSERT INTO hopNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Noqw pay pam pumuy unatwiyamuy māmatsqe, amumi paṅqawu: Ya uma hinoqw nuy unaheptota? ");
INSERT INTO hopNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kurs inumi votōnat mahtaknayaa. Ya i’ hakiy pitsáṅwaat ep pey’ta? Pu hakiy tuṅwniat aṅ pey’ta? Noqw puma lavayhtotiqe, paṅqawu: Caesar pitsaṅwaata. ");
INSERT INTO hopNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Noqw pam pumuy amumi paṅqawu: Turs uma hihta Caesar himuyat Caesar aw noayani. Pu God himuyat uma God aw noayani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Noqw pay puma kurs hin sinmuy amutpip put lavayiyat ep hintsatsnani. Nihqe puma put lavayiyat ep k̇ātayuṅqe, pay qa hiṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pahsat pu hakim Sadducee‐sinom, yaw so’pum pay ahoy qa yesvaniqat paṅqaqwaqam put aw öki; nihqe put tūviṅtotaqe, ");
INSERT INTO hopNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Aw paṅqaqwa: Tutuqaynaqa, Moses itamumi tutaptaqe yan pēna: Kurs tāqa nȫmay’taqa qa tímuy’k̇aṅw mokq, put pāvaat, sen tupkoat put nȫmayatniṅwuqat amum qatupte’, put eṅem tíoymantani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Noqw ura as hakim tsáṅe’nihqam nānatupkom yēse. Noqw amuṅaqw suspavaam as nȫmatat, qa tímuy’vat pay mōki. ");
INSERT INTO hopNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Noqw aṅknihqa put nȫmayatniṅwuqat amum qatuptut, tuwat qa tímuy’k̇aṅw mōki. ");
INSERT INTO hopNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Noqw pu amuṅknihqa pay piw amunhti. Noqw puma as tsáṅe’nihqam put nȫmatotaqw, qa hihtawat eṅem wuhti ti’va. ");
INSERT INTO hopNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Noqw nuhtuṅk pu’ wuhti tuwat mōki. ");
INSERT INTO hopNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Noqw ya ōviy sinmuy ahoy yesvaqw, pam hihtawat pumuy tsáṅe’nihqamuy nȫmaatni? Pi puma sohsoyam put nȫmatota? ");
INSERT INTO hopNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Noqw Jesus lavayhtiqe amumi paṅqawu: Sinom yep qatsit ep nȫmalalwa, piw puwsuṅwlalwa. ");
INSERT INTO hopNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Noqw pay ima hakim mokiwuy aṅqw ahoy yesve’, qatsit nātoniqat ep ö́kiniqey pay ep pávanyaqamuy qa nȫmalalwani, piw qa puwsuṅwlalwani. ");
INSERT INTO hopNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Piw soon puma pāpu so’ni. Pi puma God hoṅvi’aymuyatuy pas amunyuṅwni. Puma ahoy yesve’, God tímatni. ");
INSERT INTO hopNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Noqw kurs uma so’qam ahoy yesvaniqat ep tūviṅtotaniqw‐ya Moses himutskit lavayhtiqe hin pēnaqe hihta lavayhti? Ura God Abraham Tutuyqawhqaatnihqat paṅqawu, pu Isaac Tutuyqawhqaata, pu Jacob Tutuyqawhqaata, ");
INSERT INTO hopNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ispi pam qa so’pumuy Tutuyqawhqaamu, pi yesqamuyu; pi putniqw sohsoyam yēse. ");
INSERT INTO hopNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pahsat pu tutavot tūtutuqaynayaqamuy amuṅaqw haqawa lavayhtiqe paṅqawu: Tutuyqawhqa, pas um súaṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pahpiy pāpu puma put hihta tūviṅtotaniqey aw qa unahintsatsk̇a. ");
INSERT INTO hopNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pu pam pumuy amumi paṅqawu: Ya hintaqw ōviy uma Christ David tíatnihqat paṅqaqwa? ");
INSERT INTO hopNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Noqw pi David Tātawit pey’taqat ep nāp paṅqawu: Tutuyqawhqa, Imoṅwiy aw paṅqawu: Um hāk iputvaqewat qatuqw ");
INSERT INTO hopNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Nu uhtuwqamuy áṅwutaqw, puma ūmi maqaptsi’yuṅwniqat pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Noqw ōviy hapi David put Moṅwílawu; noqw hin pam put tíata? ");
INSERT INTO hopNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pahsat pu sinom sohsoyam tūqayyuṅqw, pam put aw nánatuwnayaqamuy amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Uma tutavot tūtutuqaynayaqamuy amuhpe qa nāunay’yuṅwni. Puma wupausit usnumyaniqey nānawakna, pu kitpik amumi hahlaykwa yuaatiwniqata; pu tsotsvalkiva mohk̇aqe tsotsókpit tuṅlay’yuṅwa, pu nōviwhqat aṅ nukṅwat qeqnita. ");
INSERT INTO hopNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ima hapi koṅnanalvutuy kīyamuy tusoqkwahanni’yuṅwa. Puma nawip’ew hink̇ahk̇aṅw, nānawakne’ sutsépyuaativayaṅwu. Puma hapi pas pavan qaöwíhintsaniwyani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pu pam kwuhpukqe k̇ahksinmuy kuwahtipuy sivatataṅpit aqw taṅalalwaqamuy amumi yori. ");
INSERT INTO hopNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Noqw pu piw pam hakiy ōokiwhqat koṅnalavut paṅsoq lȫqmuy palavotōnat pahpaṅqw tuwa. ");
INSERT INTO hopNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nihqe pam paṅqawu: Pas antsa nu umumi paṅqawni: I’ ōokiwhqa koṅnalavu imuy sohsokmuy amuhpenihqe hóyokiwtaqat paṅsoq pana. ");
INSERT INTO hopNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ima pi pay sohsoyam qarūrumnayak̇ahk̇aṅw, hihta akwsiṅqat aṅqw God eṅem kuwahtiput paṅsoq taṅatota. Noqw i’ pi okiw hihta rūrumnak̇aṅw, pas hihta akw qátuhqey sohsok paṅsoq pana. ");
INSERT INTO hopNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Noqw haqawat God kīyat yuaatotaqe paṅqaqwa: Is uti! pam lomao’wat akw lomasniwa, pu hīhihta kuwahtiput akw’a. Noqw Jesus pumuy amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ya uma īit yaṅ o’wat aw tāyuṅwa? Pay nāt hisat aw pituqw, pep pu’ qa haqam owa nāp qeniy ep akwsiṅwni. Pam sohsoy sahpumhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Noqw puma put tūviṅtotaqe aw paṅqaqwa: Tutuqaynaqa, noqw ya īi hisat yaniwhtini? Pu hisat paniwhtiniqw himu put tuawi’tani? ");
INSERT INTO hopNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Noqw pam paṅqawu: Uma tunatyaltote’ qa ūnatoyniwyani. Taq k̇aysiwhqam inatṅwaniy aṅ ök̇e’ paṅqaqwani: Nu’ Christ, kitotani; pu piw Aw hayiṅwti, kitotani. Noqw ōviy hapi uma qa amuṅkyani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sinom nāqöytivayani, piw qanamítuqayvahsi’yuṅwni. Noqw pay uma put nanapte’ qa tsawiniwyuṅwni. Pi īi yantaqa pas soon qa mohti yaniwhtini. Nīk̇aṅw hapi pay nāt qa pep so’ṅwamiq pítuni. ");
INSERT INTO hopNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pahsat pu pam pumuy amumi paṅqawu: Haqam hihtuwat sinom hihtuywatuy sinmuy amumum nehpewi hoṅvani. Pu moṅwtunatya sup moṅwtunatyat ehpewhtimantani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pu hāhaqe’ tutskwa a’nö tayayaykuni; pu tsö́ṅöstini; pu hīhimu wukotuyani; pu sinom hīhihta nuhtsel’e’wakw aw yórikyani; noqw tokpelat aṅ hīhimu hihta tuawi’taqat mātaktotini. ");
INSERT INTO hopNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nīk̇aṅw hapi nāt īit qa yayhniwhq, sinom umumi may’yuṅwe’, umuy okiwsahsantivayani, tsotsvalkiva momṅwituy amumi umuy mātaplalwani; pu sivikimi umuy taṅalalwani. Noqw uma kitsókimi moṅw’iwyuṅqamuy amumi‐nik̇aṅw pu tutskwat aw moṅw’iwyuṅqamuy amumi tsamvaniwyani, uma isinomnihqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Noqw uma umuhtuptsiwniy tunvotnayaniqat aw umuṅem qenitiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Paniqw ōviy uma pep hin lavayhtotiniqey aṅwu pay wūwantotaniqey qe’yaniqey umuh’unaṅwpeq yuki’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Pay ason nu hapi umuy lavaymaqamantani, pu súanwuwnitoynamantani. Noqw sohsoyam umuhpew’iwyuṅqam soon put ep umuy yumoṅwaltotani, piw áṅwuy’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pu umunam, umuṅum, umuhpavam, umuhtupkom, pu umuṅaqwvim, pu umuhkwatsim umuy nuhtumi mātaplalwaqw, puma umuy haqawatuy qöqyani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pu sinom sohsoyam umumi qa suhtaq’ewyani, uma isinomnihqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nīk̇aṅw hapi pay pas soon umuhqötöva umuhhömi himuwa súlawhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Uma qa naṅ’eknaye’, qatsit himuy’vayani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pu ason Jerusalem solāwamuy akw nö́yakiwtaqw, uma aw yórikye’, pahsat uma put kīqötiwhqat aw hayiṅtiqw uma nanaptani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pep pu’ ima Judeat ep yesqam tuhtukwimiq watqani, pu kīveyaqam paṅqw ahpiyyani, pu haqe’ tutskwava hinnumyaqam qa paṅso ahoy yuṅni. ");
INSERT INTO hopNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pi ep hapi God sinmuy amumi nāoyni. Noqw tutuvenit aṅ hin pey’taqat sohsok aṅ aw antsaniwni. ");
INSERT INTO hopNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nīk̇aṅw hisat aw pituqw aṅ nö’yiwyuṅqamuy, pu aṅ yōyoṅnayaqamuy kurs hin watqaniqamuy amuṅem pas is óhini! Taq sinom pavan pas k̇ānanaptani. Pi God itsívuat pumuy amumi hūrs töṅaniwtani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Noqw puma sipwuvahpit qalayat akw súlawhtini. Noqw tuwqaam pumuy tūwiktote’, hāhaqe’ tutskwat aw pumuy tsamyani. Noqw qa‐Jew‐sinom Jerusalem atsva wukukuykuyani, pumuy paptsiy aṅ kūkuyvaniqat aqw pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Pu tāwat, mūyawuy, pu sōtuy aṅ himu hihta tuawi’yuṅwni. Noqw hīhihtu sinom sóonhtote’, kurs hin wūwantotani, pātuwaqatsi a’nö hoṅvantak̇aṅw sȫykitaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Noqw sinom hihta tūwaqatsit aw pítuniqat aw‐sa tāyuṅwe’, tsawiniwk̇ahk̇aṅw, unaṅwso’ni, pi ōvaqe öqala tayayaykuniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pep pu nu’ Sinot Tiat öqalat pasiwk̇aṅw, qaan’ewkw tālawṅway’k̇aṅw ōmawuy akw hawtoqw, sinom inumi tātayyani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Noqw ason īi yantaqa hiniwmaqw, uma kwuhpukye’, ōmiq tāyuṅwni; ispi uma soon pas hisat ayo nö́ṅakiwtaniqee. ");
INSERT INTO hopNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pu pam pumuy amumi himu hihta antaqat lavayit akw yuaaykuqe paṅqawu: Uma nönvospaltsokit aw wūwayani, pu hīhihta himutsotskita. ");
INSERT INTO hopNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Puma sipölöy’vayaqw, uma aw tātayye’, pay tal’aṅwhayiṅwiwtaqat nanaptaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Noqw pay pan hapi ōviy uma ason īit yantaqat hiniwmaqw aw tātayye’, pay God moṅwtunatyaat aw pitsíwtaqat nanaptani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Pas antsa nu umumi paṅqawni: Yep sinom pas soon tūtuwayaqw, pay sohsoy it yaniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Pay as tokpela, pu tūwaqatsit tūwayani. Noqw ilavayi hapi pas soon tūwayani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nīk̇aṅw uma nānami tunatyaltotini. Taq k̇a uma hihta nasani’yuṅwe’, pu honaqkuyit akw hōnaq’iwyuṅwe’, yep qatsit ep hihta tunatyat‐sa aw tunatyawyuṅwe’ qa unaṅwtalawvayani. Nen uma qa navoti’k̇ahk̇aṅw, put talöṅnit aw suy’kini. ");
INSERT INTO hopNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Pi sopk̇awtaqam sinom tūwaqalvoqhaqami yesqam put aw ök̇e’, soñawnen wivosit aqw kwisyani. ");
INSERT INTO hopNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Paniqw ōviy uma tunatyawk̇ahk̇aṅw, yūmosa nāwakinwisni. Nen uma īit yaniwhtiniqat aṅqw ayo nö́ṅakniqey aw öqawi’k̇ahk̇aṅw, nuy Sinot Tiyat inutpip hoṅni. ");
INSERT INTO hopNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Noqw Jesus nāqavo God kīyat ep sinmuy tutuqayna; nit mihikq paṅqw yámak̇e’ tsomot, Olivet yan mātsiwhqat aqwnen, epeq talöṅnaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Noqw qavoṅvaqw sinom sohsoyam suits God kīyat ep put aw öki, aw tūqayyuṅwniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Noqw qa pek̇en’oyvut pölavikit nōviwniqat, Amutsva Yūmosanihqa yan túṅwantiwhqat aw pituto. ");
INSERT INTO hopNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Noqw God awwat mohpeq momṅwit tutavot tutuqaynayaqamuy amumum hin as Jesus nīnayaniqey hēvi’yuṅwa, Nīk̇aṅw puma sinmuy mamqasya. ");
INSERT INTO hopNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Noqw pahsat pu Satan, Judas Iscariot yan piw túṅwantiwhqat, imuy pakwt lȫq sihk̇ay’taqamuy amumum tōnawtaqat pan unaṅwtoynaqw, ");
INSERT INTO hopNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pam ahpiynihqe, God awwat mohpeq momṅwituy‐nik̇aṅw pu solāwamomṅwituy amumum pasiwna, hin as pam pumuy amumi Jesus mātapniqey ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Noqw puma hahlayhtotiqe, put sīvat maqayaniqey aw pasiwnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Noqw pam panhtiniqey paṅqawhqe, hisat sinom Jesus qa ámumyaqw, momṅwituy amumi put mātapniqey qenihevi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pahsat pu ōviy qa pek̇en’oyvut pölavikit ep nōviwniqat aw pitu. Ep hapi pu’ Jew‐sinom Amutsva Yūmosanihqat ep mañat nīnayaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Noqw Jesus Peter‐nit, pu John, pumuy ayataqe, amumi paṅqawu: Uma ahpiynen, Amutsva Yūmosanihqat ep nōviwniqat hin hintaṅwuqat itamuṅem aw hintsanni. Noqw itam nȫnösani. ");
INSERT INTO hopNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Noqw puma put aw paṅqawu: Ya itam haqam put aw hintsanniqat um nāwakna? ");
INSERT INTO hopNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Noqw pam pumuy amumi paṅqawu: Meh, uma kīmi pakiqw, pep hak tāqa kuysivut akw kūyi’k̇aṅw umuhsawvani. Uma put haqami kīmi pakiqw, aṅk aw pákini. ");
INSERT INTO hopNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pu ason uma ki’taqat aw paṅqawni: Itamuy tutuqaynaqa ūmi paṅqawu: Ya haqam yeyespi? Pep nu as inumi nánatuwnayaqamuy amumum Amutsva Yūmosanihqat ep nōviwhqat nösni. ");
INSERT INTO hopNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Noqw pam tupatsveq wukoahpavit ep pās himu yukiwtaqat umumi mahtaknani. Pep uma hihta aw hintsanni. ");
INSERT INTO hopNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Noqw puma ahpiynihqe, Jesus amumi hin lavayhtiqat an yori. Nihqe puma Amutsva Yūmosanihqat ep nōviwhqat hin hintaṅwuqat aw hintsana. ");
INSERT INTO hopNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pu ōviy aw pituqw, pam tunösvoñat aw qatuptu; noqw ima pakw lȫq sihk̇ay’taqam ayaiwyuṅqam put ámumya. ");
INSERT INTO hopNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Noqw pam pumuy amumi paṅqawu: Nu it Amutsva Yūmosanihqat ep nōviwhqat umumum nösniqey pas nāwakna, nu nāt qa k̇ānavotat’a. ");
INSERT INTO hopNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pi nu umumi paṅqawni. Pay nu soon put aṅqw piw nösni, pay ason pas hisat God moṅwtunatyayat ep pam aw antsaniwhq, pep pu’ nu piw nösni, pam kita. ");
INSERT INTO hopNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pu pam kuyapkuyit kwusut, put ep hahlayhtit, paṅqawu: Huvam it kwusuyat nāhuyvaa. ");
INSERT INTO hopNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pi nu umumi paṅqawni: Pas nu soon pāpu ovauyit aniwniyat aṅqw hikwni, pay ason pas hisat God moṅwtunatyayat aw pítuniqat aw pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pu pam pölavikit kwusut, put ep hahlayhtit, yōhat, pumuy put maqa paṅqawk̇aṅwo. I’ hapi itoko umuṅem taviwa. Yan uma hintsak‐wise’, akw nuy u’ni’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pu pay piw an pumuy nȫnösaqw, pam kuyapkuyit kwusut paṅqawu: I’ kuyapkuyi hapi iuṅwa. Pam umuṅem puhuvasiwnit pasiwnaniqe ōviy munvaniwni. ");
INSERT INTO hopNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nīk̇aṅw meh, hak momṅwituy amumi nuy mātapniqa inumum tunösvoñat aw may’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Noqw pay pi pas antsa Sinot Tiyat eṅem hin yukiwhqat pan nu yaṅqw ahpiyni. Noqw i’ hak momṅwituy amumi nuy mātapniqat eṅem pas is óhini. ");
INSERT INTO hopNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pahsat pu haqawa puma yanhaqam hinhtiniqat puma nātuviṅtivaya. ");
INSERT INTO hopNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Noqw puma pi piw nāṅwuy’yuṅwa, haqawa pa pas suspavanniqey mātaqtiniqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Noqw Jesus pumuy amumi paṅqawu: Qa‐Jew‐sinmuy moṅwímat pi pumuy amumi pas tutuyqawya; noqw pu ima pumuy amumi moṅw’iwyuṅqam pumuy amumi unaṅwtavi’yuṅqey pan túṅwantiwya. ");
INSERT INTO hopNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Noqw uma hapi qa panyuṅwni. Pay umuṅaqw pas suspavannihqa sustsākwnihqat pantani; pu i’ moṅw’iwtaqa suṅwámuy amuṅem tumalay’tani. ");
INSERT INTO hopNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ya himuwa pas pávanniqö’, sen tunösvoñat aw qátuhqa, sen nopni’taqa? Soon qa tunösvoñat aw qátuhqaniṅwu. Noqw pi nu nuhtuṅem hihta hintsakqey pank̇aṅw umumum yanta. ");
INSERT INTO hopNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Inumi tuwantiwhq, uma hapi inumum aṅ kūkuyva. ");
INSERT INTO hopNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Noqw ōviy nu hapi umuy moṅw’oyni, Ina nuy moṅwtapqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Noqw uma inumum tunösvoñat aw yesve’, inumum nōnovat, hīhikwyani. Pu uma moṅw’atsvewat aṅ yesk̇ahk̇aṅw, Israel‐sinmuy pakwt lȫq sihk̇ay’tasikip sinoiwtaqamuy amumi moṅw’iwyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Pu Tutuyqawhqa paṅqawu: Simon, Simon, meh, Satan as umuy tuṅlayhti, umuy söhövosit an tsātsayaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Noqw pay nu uṅem nāwakna, uhtuptsiwni qa sóonhtiniqat ōviy’o. Noqw ason um ahoy inumi namtök̇e’, uhtupkomuy öqalani. ");
INSERT INTO hopNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Noqw pam put aw paṅqawu: Tutuyqawhqa, pay nu umum sivikimi pákiniqey pas suhtaq’ewa, hikis nu umum mokniqeyu. ");
INSERT INTO hopNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Noqw Jesus put aw paṅqawu: Nu ūmi súaṅqawni, Peter: Pay ason pas um pāyis nuy qa tuwi’taqey paṅqawhq, pu’ taqakowāko töqtini. ");
INSERT INTO hopNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pu pam pumuy amumi paṅqawu: Ura nu umuy sīvat‐nit, pu tukput‐nit, pu totsit qa kiwisk̇ahk̇aṅwyaniqat aṅqe’ ayata. Noqw uma hihta haqtota? Noqw puma paṅqaqwa: Qa hihtaa. ");
INSERT INTO hopNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pahsat pu pam pumuy amumi paṅqawu: Taay, nīk̇aṅw pu’ hapi sivamoktukpuy’taqa put yawmani, pu pay tukpuy’taqa piw put yawmani. Pu sipwuvahpit ṅastanihqa pay pi pösālay huye’, sipwuvahpit túini. ");
INSERT INTO hopNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pi nu umumi paṅqawni: Ura yan pey’ta: Pam qaanhinwisqamuy amumum pohtoylaniwta, yan’i. Noqw soon pam tutuveni qa iqatsiy aṅ aw antsaniwni. Pas antsaa. Noqw tutuvenit aṅ hin nuy lavayhtiqa soon pas hisat yukiltini. ");
INSERT INTO hopNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Noqw puma paṅqaqwa: Tutuyqawhqa, itam lȫqmuy sipwuvahpi’yuṅwa. Noqw pam paṅqawu: Pay pahsa’ni. ");
INSERT INTO hopNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pu pam paṅqw yamakt, pay hin hinhtiṅwuqey anhtiqe, tsomot Olivet aqw’a. Noqw put aw nánatuwnayaqam piw put ámumya. ");
INSERT INTO hopNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pu pam epeq pítuhqe, pumuy amumi paṅqawu: Uma nānakawne’, qa unaheviwyani. ");
INSERT INTO hopNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pu pam hihsavohaqami hak owat tūvaṅwuniqat, pam pahsavohaqami pumuy amuṅaqw ahpiynihqe, pep tamötswunuptut, nāwaknaqe paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Inaa, pay pi um kurs nāwakne’, um it k̇ānavotpit inuṅaqw ayo távini. Nīk̇aṅw pay qa itunatyay annit, uhtunatyay an um hinhtini. ");
INSERT INTO hopNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Noqw ōveqatsit aṅqw hoṅviaya put aw mātaqtiqe, put öqalmaqa. ");
INSERT INTO hopNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Noqw pas pam k̇ānavoti’taqe, pahsat pu pas pavan nāwaknaqw, pālaat uṅwat an tutskwami wukotsölölöta. ");
INSERT INTO hopNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pu pam nāwaknaqe, wunuptut, put aw nánatuwnayaqamuy amumi pítu. Noqw puma qahahlayhpit akw māmaṅwuy’qe kurs tokva. ");
INSERT INTO hopNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Noqw pam amumi paṅqawu: Ya uma hinoqw tōk̇a? Uma yesvat nāwakintotani, taq uma unaheviwyani. ");
INSERT INTO hopNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Noqw pam nāt yuaataqw, pay k̇aysiwhqam sinom amumi öki. Noqw i’ hak Judas yan mātsiwhqa sinmuy amutpipo pítuhqe, Jesus awnihqe, tsohtsona. Ura as pam imuy pakwt lȫq sihk̇ay’taqamuy amumum tōnawta. ");
INSERT INTO hopNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Noqw Jesus put aw paṅqawu: Judas, ya um nuy tsohtsonaqe, pan nuy Sinot Tiyat nuhtumi mātapni? ");
INSERT INTO hopNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Noqw ima Jesus ámumyaqam hiniwhtiqat nanaptaqe, put aw paṅqaqwa: Tutuyqawhqa, ya itam sipwuvahpit akw rohomhtotini? ");
INSERT INTO hopNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Noqw pumuy amuṅaqw haqawa God awwat mohpeq moṅwit tūwikiyat wuvahtaqe, putvaqwat naqvuyat tuku. ");
INSERT INTO hopNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Noqw Jesus lavayhtiqe paṅqawu: Hapi, pay pahsa’ni. Pu pam put naqvuyat aw tóṅokqe qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pahsat pu Jesus God mohpeq momṅwituy amumi paṅqawu, pu God kīyat ep solāwamomṅwituy amumi‐nik̇aṅw, pu wukw’a’yatuy put aw ö́kihqamuy amumii: Ya uma aṅqaqw hakiy uyiṅwut awyaqe, ōviy pas piw sipwuvahpi’k̇ahk̇aṅw, pu murikhoy’wisa? kita. ");
INSERT INTO hopNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Himu pi nu nāqavo God kīyat ep umumum hinnumqw, uma nuy qa ṅuaya? Noqw pay pu’ hapi uma qatalpuve hintsatskiwhqat hinhtotiniqw umuṅem qeniti. ");
INSERT INTO hopNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pahsat pu puma put ṅuayaqe, pahpiy wikyaqe, God awwat susmohpeq moṅwit kīyat ep wikvaya. Noqw Peter yāvaq put aṅk hinma. ");
INSERT INTO hopNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Noqw puma ihk̇aqe aw nö́yakiwtaqat nāsave qöhyaqe aw yesvaqw, Peter amumum qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Noqw hak māna tūwiki put qȫhit aqlap qatuqw túwahqe, put aw taynumt paṅqawu: I’ tāqa piw put ámuma. ");
INSERT INTO hopNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Noqw pam put qa nakwhaqe paṅqawu: Wuhti, nu put qa tuwi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pu ahpiy hihsavoniqw, piw suhk̇a put túwahqe paṅqawu: Pay um piw pumuy amumi tōnawta. Noqw Peter paṅqawu: Tāqa, qa hin pi. ");
INSERT INTO hopNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Noqw ahpiy k̇a tāwat aṅqe’ sūs qöniltiqw, piw suhk̇a pas qa nánahtsopk̇aṅw paṅqawu: Pay pi pas suyan i’ piw put ámuma. Oviy pi pam Galileet aṅqw sino. ");
INSERT INTO hopNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Noqw Peter paṅqawu: Tāqa, nu uṅ hiṅqawhq qa māmatsi. Noqw pahsat pay nāt pam yuaataqw, taqakowāko töqti. ");
INSERT INTO hopNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Noqw Tutuyqawhqa namtökt, Peter aw tātayi. Noqw Peter Tutuyqawhqat lavayiyat u’na, ura pam put aw paṅqawu: Nāt taqakowāko qa tōqtiqw, um nuy qa tuwi’taqey pāyis paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Noqw Peter paṅqw yámakqe nāvakhuruhta. ");
INSERT INTO hopNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Noqw tahtaqt Jesus ṅuy’yuṅqam put aw tututsiwya, pu wuvalalwa. ");
INSERT INTO hopNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pu puma hihta akw put pos’uhtayaqe taywayat wuvalalwak̇ahk̇aṅw, tūviṅlalwaqe paṅqaqwa: Kurs paṅqawuu. Ya hak uṅ wuvahta? ");
INSERT INTO hopNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pu puma hīhin pu ehpewi qalomáyuaatota. ");
INSERT INTO hopNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pu ōviy panis tālawvaqw, sinmuy amuṅaqw wukw’a’yat‐niqw, pu God awwat mohpeq momṅwit‐niqw, pu tutavot tutuqaynayaqam sumitsovaltiqw, Jesus pumuy amumi wīkiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Noqw puma put tūviṅtotaqe aw paṅqaqwa: Kurs itamuy āawnaa. Ya um pas antsa God aṅqw moṅw’asi’taqa? Noqw pam pumuy amumi paṅqawu: Nu umuy āawnaqw, soon uma tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pu kurs nu as piw tuwat umuy hihta tūviṅtaqw, soon uma nuy āawnayani, piw soon uma nuy mātapyani. ");
INSERT INTO hopNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Noqw yahpiy haqahpiy nu’ Sinot Tiat God Sus’öqaltutuyqawhqat putvaqe qátuni. ");
INSERT INTO hopNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pahsat pu puma sohsoyam paṅqaqwa: Um pa God Tíata! Noqw pam pumuy amumi paṅqawu: Uma súaṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pahsat pu puma paṅqaqwa: Ya hinoqw pas nāto piw hak hin hihta tsok̇anani? Pi itam hapi pas nāp moayat ahpiy put nanapta. ");
INSERT INTO hopNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pahsat pu pep tsovawtaqam sohsoyam hoṅvaqe, pep tutskwat ep moṅwi Pilate yan mātsiwhqat aw Jesus wikya. ");
INSERT INTO hopNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pu puma put hīhihta nēveltotoynayaqe paṅqaqwa: Itam it aw nanaptaqw, itamuy Jew‐sinmuy nukushintsahtsana; pu itam hihta aṅ sivit Caesar aw qa ōoyyaniqat itamumi paṅqawlawu, yaw pam pas nāp moṅw’asi’taqey paṅqawlawhqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Noqw Pilate put tūviṅtaqe aw paṅqawu: Ya um Jew‐sinmuy moṅwiam? Noqw pam hu’waqe, aw paṅqawu: Um súaṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pahsat pu Pilate God awwat mohpeq momṅwituy‐nik̇aṅw pu sinmuy amumi paṅqawu: Pay kurs i’ qa haqam hihta ep qaanhti. ");
INSERT INTO hopNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Noqw pahsat pu pas puma qa tūtuqayyaqe paṅqaqwa: Noqw pi pam sinmuy hin u’naṅwna, nihqe ahsupoq Jew‐sinmuy amuhpa’ tūtutuqaynatinuma, Galileet aṅqw hoyóyoykuk̇aṅw pew pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Noqw Pilate put navotqe, tūviṅta sen pam Galileet aṅqwnihqata. ");
INSERT INTO hopNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Noqw kurs pam Herod moṅwvihk̇ayat aṅqwnihqat navotqe, āpiy pay Herod aw put hōna, pam piw ephaqam Jerusalem ep qatuqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Noqw Herod Jesus aw yórikqe, pas hinhaqam hahlayhti, pam as hisat put aw yórikniqey nāwaknaqe ōviy’o. Pam pi put hīhihta hintsakq navotqe, sakiqw as pam hihta k̇ātumaltaqw aw yórikniqey wūwanta. ");
INSERT INTO hopNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pahsat pu pam put hīhihta tūviṅlawu. Noqw pay Jesus pas qa lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Noqw God awwat mohpeq momṅwit, tutavot tutuqaynayaqamuy amumum aṅ hoṅk̇ahk̇aṅw, a’nö put hihta nēveltotoynaya. ");
INSERT INTO hopNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Noqw Herod‐niqw pu sōlawamat put qahihtatotaqe, aw tututsiwya; nihqe hihta lolmat yuwsinayat, ahoy Pilate aw lālayya. ");
INSERT INTO hopNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Noqw ep talöṅnit ep Pilate Herod amum nākwatsta, puma as hihta ep nehpew’iwtaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Noqw Pilate God awwat mohpeq momṅwituy, pu sinmuy amumi moṅw’iwyuṅqamuy‐nik̇aṅw, pu sinmuy sohsokmuy tsovalaqe, ");
INSERT INTO hopNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Amumi paṅqawu: Uma as it tāqat inumi wikvaya; nihqe yaw pam sinmuy nukushintsahtsanqat inumi paṅqaqwa. Noqw meh, nu umutpik put puprikq, kurs uma put hīhihta nēveltoynayaqw pas qa panta. ");
INSERT INTO hopNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pas qae, pu Herod pīw pan tuwa. Pi nu umuy put aw hōna. Noqw meh, pay kurs pam qa haqam hihta mokiwuy hihk̇ay’taqat hinhti. ");
INSERT INTO hopNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pay nu ōviy put a’nö wuvahtat, mātapni. ");
INSERT INTO hopNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Put nōviwhqat ep pam pas pay soon hihtawat pumuy amumi qa mātapṅwunihqe ōviy pan lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Noqw puma sūsaq sáakmaqe paṅqaqwa: It ayo tūvat, itamumi Barabbas mātavii, kitota. ");
INSERT INTO hopNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(I’ Barabbas as kīve sinmuy qaunáṅwtalawnaqe, hakiy nīna. Nihqe ōviy sivikimi tūviwa.) ");
INSERT INTO hopNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pahsat pu ōviy Pilate as Jesus mātapniqey nāwaknaqe, piw sinmuy amumi yuaayku. ");
INSERT INTO hopNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Noqw puma sáakmaqe paṅqaqwa: Nahoylehtsit aw múaa, nahoylehtsit aw núaa. ");
INSERT INTO hopNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Noqw pam pumuy amumi pu’ pāyis paṅqawu: Ya hínoq’ö? Ya pam hihta qalomáhinhtiqw ōviy’o? Pay pi nu qa hihta mokiwuy hihk̇ay’taqat put aw tuwa. Pay nu ōviy wuvahtat mātapni. ");
INSERT INTO hopNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Noqw pay puma pas tönay aṅqe’ sa’taqe, pay pam pas nahoylehtsit aw muiwniqat nānawakna. Noqw sinom God awwat mohpeq momṅwituy amumum sáakmaqe, nawis’ew tūtuyqawvaya. ");
INSERT INTO hopNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Noqw pahsat pu ōviy pumuy hin nānawaknaqw pantaniqat Pilate pan yuku. ");
INSERT INTO hopNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pahsat pu pam it hakiy sinmuy qaunáṅwtalawnaqe hakiy nīnaqe sivikimi tūviwtaqat mātavi, sinmuy hin nānawaknaqat pan’i. Nit pam Jesus pumuy tunatyayamuy anhtiniqe amumi put noa. ");
INSERT INTO hopNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Noqw puma Jesus pahpiy wikk̇ahk̇aṅw, hakiy Simon Cyrene aṅqw sino tutskwaṅahaqaqw pitutoqat ṅuayaqe, put nahoylehtsit īkwiltoynaya, Noqw pam Jesus aṅk put īkwiwta. ");
INSERT INTO hopNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Noqw sinom qaan’ewakw hintaqam Jesus aṅkya, pu hakim momoyam put aṅk ókiwa kitiwisk̇ahk̇aṅw, tsaykiwisa. ");
INSERT INTO hopNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Noqw Jesus pumuy amumi namtökt paṅqawu: Uma Jerusalem aṅqw momoyamu, uma qa inuṅem tsaykitani; uma nenṅem, pu umuhtimuy amuṅem tsaykitanik̇ahk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Taq meh, nāto aw pituqw, pu’ sinom paṅqaqwani: Naspi haqawat aṅ qa tílalwaqamu; pu ṅaspi haqawat qa hisat nö’yiltotiqamu, pu pīhuy akw qa hakiy yōyoṅnayaqamu. ");
INSERT INTO hopNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pep pu sinom tuhtukwimi paṅqawtivayani: Itamumi sahpukuu; pu tsotsmot aw paṅqaqwani: Itamuy āmaa, kītotani. ");
INSERT INTO hopNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kurs puma soñawnen himutskit nāto qehput yan hintsatsnat, puyaw tis lakput hintsatsnani? ");
INSERT INTO hopNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Noqw hakim lȫyöm hihta ep qaanhtiqam nīniwniqe put amum wīkiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pu ōviy puma haqami, Calvary yan mātsiwhqat, aw ö́kihqe, pep put nahoylehtsit aw muaya, pu hihta ep qaanhtiqamuy pīwu, suhk̇a put putvaqewatniqw pu suhk̇a put suyvaqewata. ");
INSERT INTO hopNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pahsat pu Jesus paṅqawu: Inaa, pay um okiw it yantaqat pumuy amuhpiy ayo yúkuni, puma hintsatsk̇aqey qa mātsi’yuṅqw ōviy’o. Noqw puma put yuwsiyat nāhoy o’yaqe, put ōviy nanavö’ya. ");
INSERT INTO hopNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Noqw sinom hoṅk̇ahk̇aṅw aw tāyuṅwa. Noqw momṅwit nuhtum put aqw tutsiwhiṅqaqwaqe paṅqaqwa: Pam pētuy ayo oya, pu’ pi nāp ayo nātapnik̇aṅwo. Kurs pas pay pam God aṅqw moṅw’asi’taqa namorstiwhqanen ayo nātapni. ");
INSERT INTO hopNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Noqw solāwam piw nuhtum put aw tututsiwyak̇ahk̇aṅw put awyaqe vinegar put mamqaya, ");
INSERT INTO hopNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Paṅqawk̇ahk̇aṅwo: Kurs pay um pas Jew‐sinmuy moṅwíamnen um ayo nātapni. ");
INSERT INTO hopNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Noqw put atsva himu pey’ta, Greek‐sinmuy‐nik̇aṅw, pu Latin‐sinmuy‐nik̇aṅw, pu Hebrew‐sinmuy penhtuwiyamuy akw’a. Noqw yan hapi pey’ta: I’ HAPI JEW‐SINMUY MOṄWIAMU. ");
INSERT INTO hopNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Noqw qaanhtiqam put amum hāyiwtaqamuy amuṅaqw suhk̇a put aw tutsíwhiṅqawlawhqe paṅqawu: Kurs pay pas um Christ‐nen, um ayo nātapni, pu itamuyu. ");
INSERT INTO hopNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Noqw pay suhk̇awa put u’nanaqe aw paṅqawu: Puyaw pay um God pas qa mamqasi? Susmataq pi um pay put an mokniqat uṅem yukuya. ");
INSERT INTO hopNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Itam pi pay a’tsipnaqe pay itahhintsakpiy ahsatiyat ömahta. Noqw i’ tāqa pas qa haqam hihta ep qaanhti. ");
INSERT INTO hopNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pu pam Jesus aw paṅqawu: Tutuyqawhqa, ason um moṅw’iwk̇aṅw ahoy pite’, okiw nuy u’nani. ");
INSERT INTO hopNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Noqw Jesus put aw paṅqawu: Nu ūmi pas antsa paṅqawni: Pay pu’ it tālat ep um inumum lomaqatsit ep nātuwiwni. ");
INSERT INTO hopNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Noqw tāwanasavehaqam tūwaqatsit aṅ ahsupoq qatālawva, tāwat atvelpetiqat aw pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Noqw tāwa qatālawva, noqw God kīyat ep mötsáp’uhtsi nāsavaqe tsīki. ");
INSERT INTO hopNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Noqw Jesus a’nö hiṅqawhqe paṅqawu: Inaa, nu ihikwsiy uhmapqölmiq mātavi. Yan pam hiṅqawht, sohsok hikwsu. ");
INSERT INTO hopNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Noqw solāwamoṅwi hin hiniwhtiqat aw yórikqe, God pas hihtataqe paṅqawu: Pay kurs pas as antsa i’ tāqa súanta. ");
INSERT INTO hopNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Noqw sohsoyam sinom pep hiniwhtiqat aw yórikyaqe, tawitsqay wuvahtiwisk̇ahk̇aṅw, paṅqw ahoy ninma. ");
INSERT INTO hopNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Noqw sohsoyam put tuwimat‐niqw pu momoyam Galileet aṅqw put ámumyaqam yāvaqw hoṅk̇ahk̇aṅw, īit aw tāyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Noqw piw hak tāqa, Joseph yan mātsiwhqa, Aramathaea‐kitsókit ep ki’taqa, sinmuy amumi moṅw’iwta. Pam hak tāqa lolma, piw súantaqe, nuhtum God moṅwtunatyayat kwaṅwtoynak̇aṅw nuhtayta. Pam hak momṅwituy pasiwniyamuy, pu hintsakpiyamuy ep qa amumum pan yuki’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I’ hak Pilate awnihqe Jesus tokoyat put aw tuhtui. ");
INSERT INTO hopNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nihqe pam put hawnaqe, tusaqtontsatsakwmötsaput akw put mok̇ahta; nit put haqam owatpelpe tuamqölot ep put tavi. Pay qa hak hisat pep tuamhqölöt ep nāto taviwa. ");
INSERT INTO hopNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Noqw ep nasuṅwintalöṅnit aw totok̇ay’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Noqw piw ima momoyam Jesus amum Galileet aṅqw ö́kihqam put aṅkyaqe, tuamhqölöt aw yórikya, pu put tokoyat hin taviwhqata. ");
INSERT INTO hopNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pu puma ninmaqe, hihta hovaqtuqat, pu ṅaṅhut na’sastota; nit nasuṅwintalöṅnit ep nāsuṅwni’yuṅwa, Moses nuhtumi hin tutaptaqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Noqw Sundayt aw pituqw ima momoyam suits talavay tūamit aqwya hīhihta kwaṅwáhovaqtuqat na’sastotaqey kiwisk̇ahk̇aṅwo. Noqw haqawat pumuy amumumya. ");
INSERT INTO hopNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Noqw kurs tūamit aṅqw owa ayo mūmaniwhq, puma pantaqat tutwa. ");
INSERT INTO hopNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Noqw puma aqw yuṅqe, Tutuyqawhqat Jesus tokoyat qa tutwa. ");
INSERT INTO hopNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Noqw puma kurs hinhtotiniqw nāto panyuṅqw, hakim lȫyöm tāqat tālawṅway’taqat yuwsi’k̇aṅw pumuy amuqlap wunuwta. ");
INSERT INTO hopNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Noqw puma tsātsawnaqe, tutskwami yōkoltotiqw, tāqat pumuy amumi paṅqawu: Ya uma hinoqw so’pumuy amuhpa’ hakiy taytaqat hepnumya? ");
INSERT INTO hopNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Pam qa yep’e, pam tātayhqe, ahoy qatuptu. Pay ura pam nāt Galileet epnihqe umumi pan lavayhtiqe, ");
INSERT INTO hopNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Paṅqawu: Nu’ Sinot Tiat hapi pas pay soon qa qaanhinwisqamuy öqalayamuy aw noiwni, nen nahoylehtsit aw muiltini. Nit pāyis tālat ep nu ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Noqw puma put lavayiyat u’naya, ");
INSERT INTO hopNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nihqe tūamit aṅqw áhoyyaqe, pakwt sūkw sihk̇ay’taqamuy Jesus aw nánatuwnayaqamuy sohsok īit āawnaya, pu ahpiy put kwātsmuyatuy sohsokmuyu. ");
INSERT INTO hopNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Noqw i’ Mary Magdala‐kitsókit aṅqwnihqa, pu Joana‐niqw, pu James yuat Mary‐niqw pu haqawat momoyam pumuy amumumyaqam ayaiwyuṅqamuy īit āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Noqw púmuyniqw pumuy lavayiam an’eway hímuu. Noqw pumuy lavayiyamuy qa tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pahsat pu Peter wunuptut, tuamit aw wari; nihqe aqw motoltiqe, tusaqtontsatsakwmötsaput pay nāp sup óyihqat tuwa. Nihqe pam paṅqw ahpiynihqe, pep hin hiniwhtiqat aw wūwanma. ");
INSERT INTO hopNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Noqw ep talöṅnit ep pumuy amuṅaqw hakim lȫyöm Emmaus‐kitsókit aqw’a. Pam Jerusalem aṅqw navay tutskwatuwanit pahsavohaqamo. ");
INSERT INTO hopNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Noqw puma sohsok īit hiniwhtiqat nāmi yuaatima. ");
INSERT INTO hopNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Noqw ōviy nāto puma nāmi yuaatimaqe aṅ wūwanmaqw, Jesus pas nāp pumuy amumi pítuhqe, pahpiy pumuy amumuma. ");
INSERT INTO hopNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Noqw pay puma put qa māmatsniqat ōviy puma pos’uhtsiltiqat panta. ");
INSERT INTO hopNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Noqw pam pumuy amumi paṅqawu: Ya uma hihta pas nāmi yuaatimaqe, pas qahahlayk̇aṅw kwilalata? ");
INSERT INTO hopNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Noqw suhk̇a, Cleopas yan mātsiwhqa, put hu’waqe aw paṅqawu: Pas um k̇a nāla Jerusalem ep kiyavaqvinihqe pep pu’ hiniwhtiqat qa navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Noqw pam pumuy amumi paṅqawu: Ya himu hiniwhti? Noqw puma put aw paṅqawu: Itam hakiy Jesus Nazareth aṅqwnihqat yuaatima. Pas as pam God lavay’ayaata; God atpip‐nik̇aṅw pu sohsokmuy sinmuy amutpik hihta qaöwíhintsaki, piw a’nö lay’taqat lavayi’ta. ");
INSERT INTO hopNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Noqw ima God awwat mohpeq momṅwit‐niqw, pu itahmomṅwit put mokiwuy hihk̇ay’taqat paṅqaqwaqe, tutskwat ep moṅwit aw put noayaqw, nahoylehtsit aw put muaya. ");
INSERT INTO hopNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Noqw itam put aw yanyuṅqw, sakiqw pay k̇a as pam hak ura Israel‐sinmuy Rome‐sinmuy amuṅaqw mātapniqat itam pan wūwantota. Noqw piw pi it yaniwhtiqat atsva pu’ pāyis tāla. ");
INSERT INTO hopNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pu piw pi ōviy hakim itamuṅaqw momoyam pas itamuy hin unaṅwtoynaya. Puma suits talavay pam haqam taviwhqat ep ö́kihqe, ");
INSERT INTO hopNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yaw put tokoyat qa tutwaqey itamuy āawnaya. Pu yaw puma ōṅaqw hoṅvia’yatuy tūawtotaqw, yaw pam qátuhqat puma pumuy amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Noqw haqawat itamuṅaqw tūamit aw haqamiyaqe momoyam hin lavaytaqat pan yórikya, Nīk̇aṅw Jesus pay puma qa aw yórikya. ");
INSERT INTO hopNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pahsat pu pam pumuy amumi paṅqawu: Is uma ṅasta wuwni’taqamu. Uma sȫwu God lavay’aymuyatuy lavayiyamuy sohsok tuptsiwni’taniqey qa pan unaṅwti! ");
INSERT INTO hopNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Puyaw pay nawus Christ soon qa mohti īit hihta aṅ kānavot, pep pu’ pas hímuniwhtini? ");
INSERT INTO hopNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pu pam Moses lavayiyat aṅqw hoyóyoykuqe, God lavay’amuyatuy lavayiyamuy pumuy navotna. Pu tutuvenit aṅ pam hin lavayhtiwhqey sohsok pam pumuy amumi namtöminta. ");
INSERT INTO hopNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Noqw puma haqami kitsókit awyaqey aw hayiṅwnayaqw, pay pam yūmosaniqey anhti. ");
INSERT INTO hopNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Noqw puma put aw öqaltiqe, aw paṅqawu: Pay um itamum huruhtinik̇aṅwo. Taq pi pay tapkiwmaqw nuṅwu pay pas hísatniqti. Noqw pam amumum huruhtiniqe aw paki. ");
INSERT INTO hopNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Noqw ōviy pam pumuy amumum tunösvoñat aw qatuptut, pölavikit kwusut, put ep hahlayhtit, yōhat, pumuy maqa. ");
INSERT INTO hopNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Noqw pumuy pōsiam tālawvaqw, puma put māmatsi. Noqw pay pam pumuy amuhpiy haqami kurs hiniwhti. ");
INSERT INTO hopNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Noqw puma nāmi paṅqawu: Pi ōviy itamuy aṅqwyaqw pam itamumi yuaatimaqe, itamumi tutuvenit namtöminmaqw, pas itam hin unaṅway’ma! ");
INSERT INTO hopNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Noqw puma pahsat pay wunuptut, ahoy Jerusalem aqwnihqe pakwt sūkw sihk̇ay’taqamuy tsovawtaqw, pumuy amumi pitu, pu hakimuy pumuy amumumyaqamuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Noqw puma pumuy amumi paṅqaqwa: Pay kurs Tutuyqawhqa pas antsa ahoy tātayhqe, Simon aw namtakna. ");
INSERT INTO hopNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Noqw pahsat pu ima lȫyöm tuwat pumuy Emmaus aqwniqw, hin hiniwhtiqat pumuy āawna, pu hin puma Jesus māmatsqeyu, pam pölavikit yōhaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Noqw pumuy nāt yan yuaatotaqw, Jesus pas nāp pumuy amuhsonve wunuptuqe, amumi paṅqawu: Nam uma kwakwhat yēsee. ");
INSERT INTO hopNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Noqw puma wuhpukyat, tsātsawnaqe, pay tūawtotaqey wūwaya. ");
INSERT INTO hopNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Noqw pam pumuy amumi paṅqawu: Ya uma hinoqw hin unaṅway’yuṅwa? Uma hinoqw umuh’unaṅwpeq hin wūwantota? ");
INSERT INTO hopNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Huvam imay, ikukuy enaṅ aw yórikyaa. Pi pay nūu. Inumi hintsatsnat nanaptaa. Hakiy hikwsiat pi qa tokoy’taṅwu, piw qa ȫqay’taṅwu. Noqw uma nuy pantaqat aw tāyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yan pam lavayhtit, amumi lȫvaq may, pu kuhkuy mahtakna. ");
INSERT INTO hopNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Noqw nāt puma hahlayhtotiqe qa tūtuptsiwaqe wūwantotaqw, pam pumuy amumi paṅqawu: Uma qa hihta yep nōvay’yuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Noqw puma hihsakw pakiwhtuhpet momospalat enaṅ put maqaya. ");
INSERT INTO hopNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Noqw pam put kwúsuhqe, pumuy amuhpewi put tūmoyta. ");
INSERT INTO hopNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pahsat pu pumuy amumi paṅqawu: Ura nu nāto umumumnihqe yan umumi lavayhti: Moses tutavoyat aṅ hin nuy lalvayhqa soon qa antani, pu God lavay’aymuyatuy lavayiyamuy aṅ’a, pu Tātawit aṅ’a, ura nu kita. Noqw yan hapi ilavayi aw antsaniwa. ");
INSERT INTO hopNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pahsat pu pam pumuy wūwniyamuy tālawnaqe, tutuvenit pumuy māmatsna; ");
INSERT INTO hopNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nihqe amumi paṅqawu: Yan hapi pey’ta. Noqw ōviy pay Christ nawus soon qa pan k̇ānavot, pu mokt, pu pāyis talq mokiwuy aṅqw ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Noqw uma soon qa sinmuy amumi yuaatinumyani amumi paṅqawk̇ahk̇aṅwo: Uma umuhtunatyay aṅqw lasyaqw, umuhqaanhtipu umuhpiy ayo yukiwni, Jesus Christ natṅwaniyat aṅ’a, kitotani, Uma Jerusalem aṅqw hoyóyoykuyak̇aṅw sohsokmuy hihtuy sinmuy amumi yan yuaatiwisni. ");
INSERT INTO hopNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pi uma hapi pas īit aw yóriki’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Noqw meh, Ina umumi hakiy awini’taqat nu aṅqw távini. Nīk̇aṅw pay uma hāk yep kitsókit ep yesni, hisat ōṅaqw öqalat makiwyaniqey pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pu pam pumuy Bethanyt pahsavo tsamht, māvuyaltit, amuṅem nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nihqe nāto pam pumuy amuṅem nāwakink̇anw pumuy amuṅaqw tukiwhqe, ōmiqatsit aw wīkiwa. ");
INSERT INTO hopNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Noqw puma put pas hihtatotat, pas hinhaqam hahlayk̇ahk̇aṅw ahoy Jerusalem awya. ");
INSERT INTO hopNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nihqe puma sutsep God kīyat ep hinnumya, God tayawink̇ahk̇aṅw aw hahlayk̇ahk̇aṅwo.");
INSERT INTO hopNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ayáq yayhniwhqat epeq God Lavayiat pay ep’e; pu Lavayi God ámuma; pu pay Lavayi God. ");
INSERT INTO hopNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pu pay pam hak piw yayhniwhqat epeq God amum yanta. ");
INSERT INTO hopNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sohsoy himu put ahpiy yukilti; pu qa himu yukiwtaqa put qa ahpiy yukilti. ");
INSERT INTO hopNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pam nāp nahpiy qatsit pasiwta; pu pay pam qatsi sinmuy amumi tālat anta. ");
INSERT INTO hopNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Noqw tāla qatālat ep tālawva; noqw qatāla put qa tōk̇a. ");
INSERT INTO hopNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Noqw hak tāqa God aṅqw ayatiwa; nihqe John yan mātsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pam hak hihta tuawi’taniqe ōviy pitu, Tālat tuawi’taniqee, sohsoyam put ahpiy tūtuptsiwaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pay pam qa pas pas pám himu Tāla; pam put Tālat tuawi’taniqe ayatiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","I’ Tāla pas antsanihqa sohsokmuy sinmuy amumi talni’taniqe it tūwaqatsit aw pituto. ");
INSERT INTO hopNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pam as pay tūwaqatsit ep sinmuy amuhpe hinnuma; pu sinom put ahpiy yukiltoti; noqw sinom put qa tuwi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pam as pas nāp sinomuy amumi pituqw, sinomat put qa kwusuya. ");
INSERT INTO hopNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nīk̇aṅw hakim hihsa’nihqam put kwusuyaqam put aw tūtuptsiwaqam God tímatniqat pam pan pumuy amuṅem yuku. ");
INSERT INTO hopNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Puma hakim qa sinot ahpiy pu’ pas tihtiwya, piw qa tokot tuṅlayiyat ahpiy’o, piw qa tāqat tunatyayat ahpiynit pas God ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Noqw Lavayi sínoniwhtiqe, itamuhsonve qatuptu; noqw itam lolmat qatsíyat aw yórikya, pas Nay sūkw Tíatníhqat pan lolmat qatsíyat aw’i. Pas pam itamuy ōkwatuwa, nihqe itamumi qaatsat lalvaya. ");
INSERT INTO hopNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John put hákiynihqat tuawi’taqe, pan tsahtsa’lawu: Ura nu it tāqat hapi lavayhtiqe paṅqawu: Tāqa aṅqw inuṅknihqa inuhpenihqe pas pávani, sam pi pam inuhpenihqe mohtinihqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Noqw itam sohsoyam put qarūrumniyat aṅqw ömahtota, pu nānaṅumo núokwayata. ");
INSERT INTO hopNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pi itamuy hin hinwisniqat God Moses ahpiy itamumi tutapta; noqw Jesus Christ núokwat, lavayit pas antsanihqat enaṅ itamumi kwusiva. ");
INSERT INTO hopNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Qa haq hapi hak sino God aw yori. Nay pas sūk̇a Tiat put aw unaṅwaat hapi put tunvotna. ");
INSERT INTO hopNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Noqw Jew‐sinom hakim God awwat momṅwituy, Levit ahpiyviyatuy enaṅ Jerusalem aṅqw ayatota. Noqw puma John aw ókihqe yan put tūviṅtota: Ya um hak’i? kitota. Noqw John yan nālavayhtiqe, ");
INSERT INTO hopNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Haknihqey súaṅqawhqe, qa tupki’tat paṅqawu: Nu’ qa Christ. ");
INSERT INTO hopNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Noqw puma put tūviṅtotaqe aw paṅqaqwa: Noqw hinta? Ya um Elias? Noqw pam paṅqawu: Nu qa pam’i. Noqw ya um God lavay’ayaat pas pávannihqa? Noqw pam lavayhtiqe paṅqawu: Qae. ");
INSERT INTO hopNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pahsat puma put aw paṅqaqwa: Noqw um hak’i? taq as itam itamuy ayatotaqamuy amumi soon qa hin tūawvayani. Ya um hímunihqey nāmi wūwanta? ");
INSERT INTO hopNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Noqw pam paṅqawu: Nu hapi Tsahtsa’lawhqa, nihqe qayēsiwhpuve yan tsa’tinuma: Tutuyqawhqa aṅqw pituto. Soñawnen put eṅem pöhut súwiptotani. Pan ura God lavay’ayaat Esaias lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Noqw ima hakim ayatiwyaqam Pharisee‐sinmuy amumum tōnawtaqamu. ");
INSERT INTO hopNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Noqw puma put tūviṅtotaqe aw paṅqaqwa: Noqw kurs as um qa Christ‐nik̇aṅw, pu piw qa Elias‐nikaṅw, pu piw qa God lavay’ayaat pas pavannihqat‐nik̇aṅw, ya um hinoqw sinmuy kūyit akw tuvoylalawu? ");
INSERT INTO hopNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Noqw John lavayhtiqe amumi paṅqawu: Nu sinmuy kūyit akw tuvoylalawu; nīk̇aṅw suhk̇a umuhsonve wunuwtaqw, uma put qa tuwi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pam as inuṅk pítuk̇aṅw, inuhpenihqe pas pávani; noqw soon nu yan’ewaynīk̇aṅw nas’ew put tots‐sosompiyat ṅahni. ");
INSERT INTO hopNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Noqw John Bethabarat ep sinmuy kūyit akw tuvoylalawhq, i’ yaniwhti, Jordan pāyut yupqöyveq’a. ");
INSERT INTO hopNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Qavoṅvaqw John Jesus put awniqw túwahqe paṅqawu: Meh, i’ hapi mañat God aw taviwhqat anta, pam sinmuy qaanhtipuyamuy ayo yúkuni. ");
INSERT INTO hopNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ura nu it tāqat lavayhtiqe paṅqawu: I’ tāqa aṅqw inuṅknihqa inuhpenihqe pas pávani, pam inuhpenihqe mohtinihqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Noqw nu as put qa tuwi’ta; nīk̇aṅw as pam Israel‐sinmuy amumi mātaqtiniqat ōviy nu pítuhqe, sinmuy kūyit akw tuvoylalawu. ");
INSERT INTO hopNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Noqw John hin yórikqey tuawi’taqe paṅqawu: Hikwsi höwit antaqa ōṅaqw hawhqe, put ep qatuptuqw, nu aw yóri. ");
INSERT INTO hopNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Noqw nu as put qa tuwi’ta; noqw i’ hak nuy sinmuy kūyit akw tuvoylataniqat aw ayataqa inumi yan lavayhti: Hikwsi hawte’ hakiy ep qatuptuni. Ason um pan tuwe’ navoti’taqw, pam hapi sinmuy Qahováriwtaqat Hikwsit akw tuvoylalawni. Yan hapi God inumi lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Noqw nu hapi aw yórikqe, ōviy pay pas pam hapi God Tíatnihqat yan tuawi’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pu piw qavoṅvaqw John lȫqmuy put aw nánatuwnaqamuy amumum wunuwk̇aṅw, ");
INSERT INTO hopNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesus paṅ waymaqw, pam aw taytaqe paṅqawu: Meh, i’ hapi mañat God aw taviwhqat anta. ");
INSERT INTO hopNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Noqw put aw nánatuwnaqam put paṅqawhq navotqe, Jesus aṅk’i. ");
INSERT INTO hopNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pahsat pu Jesus namtökqe, puma put aṅkniqw túwahqe, amumi paṅqawu: Ya uma hihta nāwakna? Noqw puma aw paṅqawu: Rabbi, (pam Tutuqaynaqa i’nihqe pam’i) ya um haqam qatu? ");
INSERT INTO hopNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Noqw pam amumi paṅqawu: Uma inumumnen, aw yórikni; noqw ōviy puma ep pituhqe, put haqam qátuhqat aw yórikqe, put amum huruhti, pay tāwa pas atk̇aqtiqw ōviy’o, (tāwa pakwút‐sikishaqam aṅhqe qöniltiq’ö). ");
INSERT INTO hopNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Noqw ima lȫyöm John hiṅqawhq navotqe Jesus aṅknihqamuy amuṅaqw suhk̇a Andrew yan mātsiwa, Simon Peter tupkoata. ");
INSERT INTO hopNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Noqw pam mohti pāvay Simon túwahqe, aw paṅqawu: Itam Messias tuwa; (pam moṅw’asi’taqa, i’nihqe pam’i). ");
INSERT INTO hopNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nihqe pam put Jesus aw wikva; noqw Jesus put aw tātayhqe aw paṅqawu: Um Simon Jonat tíata; um yahpiy haqahpiy Cephas yan túṅwantiwni, pam Owa, i’nihqe pam’i. ");
INSERT INTO hopNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Qavoṅvaqw Jesus Galileet aqwniqey unaṅwtiqe, Philip túwahqe, aw paṅqawu: Um inuṅkni. ");
INSERT INTO hopNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Noqw Philip pi Bethsaidat aṅqw sino, imuy Andrew nit pu Peter pumuy kitsókiyamuy aṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Noqw Philip Nathanael túwahqe, aw paṅqawu: Itam Messias tuwa, hakiy Jesus, Joseph tiyat, Nazareth aṅqw tāqata. Ura Moses tutavot ep put pēna, pu ima God lavay’aymat lavayiyamuy aṅ piw put pēnaya. ");
INSERT INTO hopNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Noqw Nathanael put aw paṅqawu: Ya sen himu nukṅwa Nazareth aṅqw yámakni? Noqw Philip aw paṅqawu: Um inumumnen aw yórikni. ");
INSERT INTO hopNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Noqw Nathanael aṅqwniqw, Jesus túwahqe put yan lavayhti: I’ hapi pas antsa Israel‐sino; it ep unatwi súlawu. ");
INSERT INTO hopNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Noqw Nathanael put aw paṅqawu: Ya um haqam nuy tuwi’va? Noqw Jesus lavayhtiqe aw paṅqawu: Nāt Philip uṅ qa wáṅwayhq, um nönvospaltsokit atpipniqw, nu uṅ tuwa. ");
INSERT INTO hopNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael lavayhtiqe aw paṅqawu: Rabbi, um kurs God Tíata, um Israel‐sinmuy moṅwiamu. ");
INSERT INTO hopNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus lavayhtiqe aw paṅqawu: Um nönvospaltsokit atpipniqw, nu uṅ túwahqey paṅqawhq, ya um paniqw tuptsiwa? Um nāt it epnihqe pas pávanyaqat aw yórikni. ");
INSERT INTO hopNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pu pam put aw paṅqawu: Pas antsaa, pas antsa nu ūmi paṅqawni: Yahpiy hapi ōveqatsit aw hötsíltiqw, uma aw tāyuṅwni. Noqw God hoṅviaymat nuy Sinot Tiyat ep ōmi yayvantak̇aṅw aw hantani. ");
INSERT INTO hopNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ahpiy pāyis talq hakim Galilee‐tutskwat ep kitsókit Canat ep nāṅuani; noqw Jesus yuat pep nuhtuma. ");
INSERT INTO hopNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Noqw Jesus put aw nánatuwnayaqamuy amumum nāṅuiwniqat aw tūtsamiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Noqw ovavalat súlawhtiqw, Jesus yuat put aw paṅqawu: Puma okiw ovavalat ṅastaya. ");
INSERT INTO hopNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Noqw Jesus yuy aw paṅqawu: Wuhti, ya um hinoqw hiṅqawlawu? Pay ituwaniy nāto qa aw pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Noqw put yuat tumal’a’yatuy amumi paṅqawu: Umumi hiṅqawhq, uma anhtotini. ");
INSERT INTO hopNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Noqw pep navay owakuyhpi oyi, nanap lȫp sen payhp wukokuyhpit aṅ ohpokit pan tūtukwa. Sinom kūyit akw nākwaṅw’ewakwtotaniqat ōviy pāvam pep oyi, imuy Jew‐sinmuy hapi pam tuwiamu. ");
INSERT INTO hopNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Noqw Jesus tumal’a’yatuy amumi paṅqawu: Uma kuyhpit aṅ kūyit opomnayani. Noqw puma put aṅ tsīkilaya. ");
INSERT INTO hopNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pu pam pumuy amumi paṅqawu: Taa, uma aṅqw kukye’, tūnopni’taqat aw kūyi’wisni; noqw puma aw kūyi’wisa. ");
INSERT INTO hopNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Noqw tūnopni’taqa kūyit ovavalaniwhtiqat aṅqw hikwt, put háqamyaqat qa navoti’ta. Pay tumal’a’yat put kukyaqam‐sa navoti’yuṅwa. Noqw ōviy tūnopni’taqa möönaṅwuy wáṅwayhqe, ");
INSERT INTO hopNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Aw paṅqawu: Pas hapi as soon hak qa nukṅwat ovavalat tūnopnaṅwu, nen ason pay sinmuy pavan ȫöyaqw, pahsat pu pay hin’ewakwniṅwu; noqw kurs um tuwat pas nukṅwat ovavalt waranhta. ");
INSERT INTO hopNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yan Jesus Galileet ep Canat ep k̇ātatayhpit pas susmohti tumaltaqe, a’nö hímunihqey pan namtakna; noqw put aw nánatuwnayaqam put aw tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yantaqat atsve pu’ pam Capernaum aqw’a; pam‐niqw, pu yuat‐niqw, pu tupkomatu, noqw pu put aw nánatuwnayaqamu, nihqe puma pepeq pay qa wūhakis yēse. ");
INSERT INTO hopNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Noqw Jew‐sinmuy hintsakpiam amutsva yūmosanihqat ep nōviwhqat aw pitsíwta, noqw Jesus Jerusalem aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nihqe God kīyat ep pakit, wāwakastuy, pu kanelmuy, pu hö́wihtuy huhyayaqamuy pepeq tuwa, pu sīvat nāhoyṅwantotaqamuy pep yesqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nihqe pam sosompihohyat wuvahpitat, pumuy sohsokmuy God kīyat aṅqw ihpoq lālaya, pu kanelmuyu, pu wāwakastuyu; nit pu sīvat nāhoyṅwantotaqamuy sīvayamuy siwumnat, huhyanpiyamuy takumna; ");
INSERT INTO hopNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nit hö́wihtuy huhyayaqamuy amumi paṅqawu: Uma imuy ayo’haqami tsamyani; uma Inay kīyat qa huhyankitotani. ");
INSERT INTO hopNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Noqw put aw nánatuwnayaqam u’nayaqw, ura yan pey’ta: Nu uhkiy eṅem qanātusi’taqey ep nīnaniwni. ");
INSERT INTO hopNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pahsat pu Jew‐sinom lavayhtotiqe put aw paṅqaqwa: Noqw um hihta aw yank̇aṅw īit hintsaki; um hihta akw uh’öqalay itamumi poñahtani? ");
INSERT INTO hopNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus lavayhtiqe amumi paṅqawu: Uma it God kīyat sahpuknayaqw, nu pāyis tālat aṅ put ahoy wunuptsinani. ");
INSERT INTO hopNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pahsat pu Jew‐sinom paṅqaqwa: Lȫp sunat aṅqw navay sihk̇ay’taqat yahsaṅwuy aṅ i’ kītiwhq, ya um pāyis tālat aṅ put aw ahoy wunuptsinani? ");
INSERT INTO hopNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Noqw pay pam nāp tokoy God kīyatnihqat paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Noqw ōviy pam mokiwuy aṅqw ahoy tātayhq, ura pam yan amumi lavayhtiqat put aw nánatuwnayaqam u’naya; nihqe puma hin pey’taqat tútuptsiwa, pu Jesus yan amumi hin lavayhtiqata. ");
INSERT INTO hopNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Noqw Amuhtsva‐yūmosanihqat ep nōviwhq, Jesus Jerusalem epniqw, sinom hīhihta k̇ātutmalayat aw yórikyaqe, put aw tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Noqw pay Jesus pumuy amumi qa tuptsiwa, sohsokmuy amumi navoti’taqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Noqw soon pas piw hak Jesus put āwintani; pi himu sinot unaṅwpeqniqw pam navoti’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pu hak Pharisee‐sinmuy amuṅaqw tāqa Nicodemus yan mātsiwhqa qatu, Jew‐sinmuy amuṅaqw moṅwi. ");
INSERT INTO hopNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","I’ hak míhikpuva Jesus aw pítuhqe, aw paṅqawu: Rabbi, itam hapi pas suyan uṅ God aṅqw sinmuy tutuqaynaniqe pítuhqat mātsi’yuṅwa; ispi kurs God qa úmumniqw, um k̇ātatayhpit hintsakqey kurs hin hintsakniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Noqw Jesus lavayhtiqe put aw paṅqawu: Pas antsaa, pas antsa nu ūmi paṅqawni: Pas qa piw tihtiwhqa soon God moṅwtunatyayat aw yórikni. ");
INSERT INTO hopNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Noqw Nicodemus put aw paṅqawu: Noqw hak wuynīk̇aṅw hin piw tihtiwmantani? Ya sen pam yuy ponoyat aqw pak̇e’, piw tihtiwmantani? ");
INSERT INTO hopNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Noqw Jesus put aw paṅqawu: Pas antsaa, pas antsa nu ūmi paṅqawni: Hak kūyit‐nik̇aṅw pu piw Qahováriwtaqat Hikwsit qa akw tihtiwhqa pas soon God moṅwtunatyayat aw pákini. ");
INSERT INTO hopNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sinot ahpiy tihtiwhqa sinoniṅwu; pu Hikwsit ahpiy tihtiwhqa put ahpiy qatsit himuy’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pas uma soon qa pu’ piw tihtiwyaniqat nu ūmi paṅqawhqat um ep qa pas hin wūwantani. ");
INSERT INTO hopNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hūk̇aṅw haqami hūhuknik paṅsoq hūhukṅwu, noqw as um söykitaqw navotṅwu; nīk̇aṅw háqaqwnik̇aṅw pu haqaminihqat um qa mātsi’taṅwu; noqw pan hapi Qahováriwtaqa Hikwsi put ahpiy tihtiwyaqamuy unaṅwayamuy ep tumalay’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Noqw Nicodemus lavayhtiqe put aw paṅqawu: Noqw īi hin pasiwtani? ");
INSERT INTO hopNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Noqw Jesus lavayhtiqe put aw paṅqawu: Ya um as Israel‐sinmuy tutuqaynaqanik̇aṅw īit qa navoti’ta? ");
INSERT INTO hopNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pas antsaa, pas antsa nu ūmi paṅqawni: Itam hihta navoti’yuṅqey yuaatota, pu hihta aw yórikyaqey tuawi’yuṅwa, noqw uma itahtuawiy qa ömahtota. ");
INSERT INTO hopNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Noqw kurs nu pay yep qatsit ep hihta hinyuṅqat umuy āwintaqw uma qa tūtuptsiwe’, puyaw tis nu ōveqatsit ep hihta hinyuṅqat umuy āawnaqw uma hin put tūtuptsiwani? ");
INSERT INTO hopNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Qa hak hapi hisat ōmiqatsit aw wūvi, pas ōveqatsit aṅqw hawhqa‐saa, i’ Sinot Tiat ōveqatsit ep qátuhqa. ");
INSERT INTO hopNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Noqw ura Moses qayēsiwhpuve tsūat himutsokit ep hāyaqw, pan hapi Nu Sinot Tiat pas soon hihta ep qa hāyiwni. ");
INSERT INTO hopNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Noqw nāp hak inumi tuptsiwhqa qa hovalniwht qatsit qaso’taqat makiwni. ");
INSERT INTO hopNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pi God sinmuy amumi pas unaṅway’k̇aṅw k̇ahk̇awnaqe, ōviy pas sūkw tiy tavi, nāp hak put aw tuptsiwhqa qa hovalniwht, qatsit qaso’taqat himuy’vani. ");
INSERT INTO hopNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pi God Tiy sinmuy ayo óyaniqat ōviy put aṅqw tavi, sinmuy hin yukunaniqat qa paniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pi God put Tiyat aw tūtuptsiwaqamuy amuṅem qa hinwat yukut, pumuy mātavi; nīk̇aṅw pam put qa aw tūtuptsiwaqamuy sivintoyniwyaniqat pay pan amuṅem yuku, puma put sūkw Tiyat qa aw tūtuptsiwhq ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pay i’ Tāla tūwaqatsit aw pituqw, sinom put qa nānawaknat, soq qatālat ep hahlayya, puma qalomáhintsatsk̇aqe ōviy’o. Noqw paniqw hapi ōviy God pumuy sivintoynaniqey amuṅem yuku. ");
INSERT INTO hopNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pi haqam qalomáhintsakqa tālat qa hahlayṅwu, piw tālat qa awniṅwu, taq nāphisat k̇a hintsakpiat suhputsniwniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Noqw pi i’ hak pas qaatsat hinmaqa tālat awniṅwu; nihqe pam God öqalayat ahpiy tumaltaqey tunvotnaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Iit atsve pu’ Jesus put aw nánatuwnayaqamuy amumum Judea‐tutskwat ep pitu; nihqe pep pumuy amumum qátuhqe, sinmuy kūyit akw tuvoylalawu. ");
INSERT INTO hopNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Noqw Salem ahayhp Aenon ep a’nö pāhuniqw, ōviy John pep piw sinmuy kūyit akw tuvoylalawu, ");
INSERT INTO hopNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Pam nāt sivikimi qa tūviwhqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Noqw John aw nánatuwnayaqam hakiy hin kwaṅw’ewayhtiniqat ep Jew‐sinmuy amumum nāṅwuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Noqw puma John aw ö́kihqe, aw paṅqaqwa: Rabbi, ura i’ Jordan yupqöyve úmumnihqa sinmuy kūyit akw tuvoylalawu; noqw sinom sohsoyam put aw ökiwta. Ura um put hakiy lalvaya. ");
INSERT INTO hopNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Noqw John lavayhtiqe paṅqawu: Kurs hak öqalat makiwhqa kurs hin qa ōṅaqw put makiwni. ");
INSERT INTO hopNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pi uma nāp inumi navoti’yuṅqw ura nu paṅqawu: Nu’ qa Christ, pay ura nu put apyeve ayatiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kwusi’taqa hapi möönaṅwniṅwu; nopw put kwātsiat wunuk̇aṅw aw tūqayte’, put tönayat ep pas hinhaqam hahlayhtiṅwu. Noqw ōviy hapi ihahlayhpi pas hin hintaniqey anhti. ");
INSERT INTO hopNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Pam soon qa suyhtsepṅwat öqawi’mani; noqw nu pay soon qa pevewmani. ");
INSERT INTO hopNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Pi ōṅaqw pítuhqa hapi pas sohsokmuy amupyevee, noqw i’ tūwaqatsit aṅqwnihqa yep qatsit tunatyawta, nihqe yep qatsit tunatyayat yuaataṅwu. Oṅaqw pítuhqa hapi pas sohsokmuy amupyevee. ");
INSERT INTO hopNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nihqe pam hihta aw yórikk̇aṅw, pu navotqey put yuaata; noqw qa hak put tuawiyat kwusu. ");
INSERT INTO hopNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tuawiyat kwúsuhqa put hapi akw God pas antsanihqat paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pi God aṅqw ayatiwhqa God lavayiyat yuaata; pi God put pas qa tuwanit Hikwsit maki’taq’ö. ");
INSERT INTO hopNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pi Naat Tiy aw unaṅway’taqe, ōviy sohsok hihta aw put öqalmaqa. ");
INSERT INTO hopNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","God Tiyat aw tuptsiwhqa hapi pay qatsit qaso’taqat himuy’ta; pu God Tiyat aw qa tuptsiwhqa hapi pas soon qatsit aw yórikni; pánis‐sa pi God itsívuat put aw huruiwta. ");
INSERT INTO hopNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Noqw ima Pharisee‐sinom nanaptaqw, yaw Jesus John epnihqe wūhaqnihqamuy sinotak̇aṅw, pumuy kūyit akw tuvoylalawu. ");
INSERT INTO hopNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pay as pi Jesus qa nāp sinmuy kūyit akw tuvoylalawu, pay put aw nánatuwnayaqam pantsatsk̇a. ");
INSERT INTO hopNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Noqw yaw pumuy yan nanaptaqat Jesus navotqe, Judea‐tutskwat mātapt, pu Galilee‐tutskwat aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Noqw pas pam kurs hin qa Samaria‐tutskwat aṅni. ");
INSERT INTO hopNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nihqe ōviy pam Samariat ep kitsókit Sycar yan mātsiwhqat aw pitu, ura Jacob tiy Joseph hihsaq tutskwat máqahqat áhayhpnihqat aw’i. ");
INSERT INTO hopNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Noqw Jacob nöṅanvatñiat pep’e. Noqw Jesus waynumqe māṅuiwk̇aṅw, patñive qatuptu tāwanasavehaqamo (tāwa navaysikishaqam aṅhqe qöniwmaq’ö) ");
INSERT INTO hopNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Noqw hak Samariat ep wuhti kuytoqe ep pitu, noqw Jesus put aw paṅqawu: Okiw nuy kuynaa. ");
INSERT INTO hopNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Put aw nánatuwnayaqam kīmihaqami tunöstuiwisa.) ");
INSERT INTO hopNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Noqw pahsat pu Samariat ep wuhti put aw paṅqawu: Ya hintaqw ōviy um Jew‐sinonik̇aṅw inumi kuyhtuviṅlawu, susmataqpi nuy Samariat ep wuhtiniqö’? Ima Jew‐sinom pi Samariat‐sinmuy amumum qa hintsatsk̇aqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Noqw Jesus lavayhtiqe put aw paṅqawu: As um God kuwahtipuyat mātsi’te’, pu hak ūmi kuyhtuviṅtaqat hákiynihqat tuwi’tani. Nen um put aw tūviṅtaqw, soon pam uṅ kūyit taytaqat qa máqani. ");
INSERT INTO hopNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Noqw wuhti put aw paṅqawu: Meh, tāqa, noqw pi um hihta akw kuyniqey ṅastaa, noqw patñi hinurs hötsi. Noqw um put kūyit taytaqat háqamnihqe ōviy’o? ");
INSERT INTO hopNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ya um itanay Jacob epnihqe hak pas pávani? Pam pi ura itamuy pay hísathaqam it patñit maqa; nihqe ura nāp put aṅqw hīhiko, pu tímatu, pu pokmatu. ");
INSERT INTO hopNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus lavayhtiqe put aw paṅqawu: It pāhut aṅqw hikwqa pay piw pānaqmokmantani. ");
INSERT INTO hopNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nīk̇aṅw ason nu’ hakiy kūyit maqaqw, put aṅqw hikwqa soon hisat pānaqmokni; noqw nu’ hakiy kūyit maqaqw, pam kūyi hakiy ahsonve pāhut yamamataqat antani, nen qatsit qaso’taqat aaniwnani. ");
INSERT INTO hopNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Noqw wuhti put aw paṅqawu: Meh, tāqa, himu as um nuy it kūyit maqaqw, nu pāpu qa pānaqmokni, piw qa aṅqw kuytomantani. ");
INSERT INTO hopNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Noqw Jesus put aw paṅqawu: Yupa uhpuwsuṅway wiktoo, noqw uma aṅqwni. ");
INSERT INTO hopNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Noqw wuhti lavayhtiqe put aw paṅqawu: Nu ṅasta puwsuṅway’ta. Noqw Jesus aw paṅqawu: Pas um súaṅqawhqe Nu ṅasta puwsuṅway’ta, kita. ");
INSERT INTO hopNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pi um as tsívotnihqamuy puwsuṅwta; noqw i’ pu’ umum qátuhqa pay qa uhpuwsuṅwa. Um paṅqawhqe súaṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Noqw wuhti put aw paṅqawu: Meh tāqa, kurs um hak God lavay’ayaata. ");
INSERT INTO hopNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Noqw itanam pi it tūkwit ep God aw nānawakna; noqw úmuyniqw pi as sinom soon qa Jerusalem ep God aw nānawaknani. ");
INSERT INTO hopNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Noqw Jesus put aw paṅqawu: Wuhti, um nuy tuptsiwni, pay nāt uma qa it tūkwit, piw qa Jerusalem ep Inay aw nānawaknaniqat aw pituto. ");
INSERT INTO hopNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Uma hihta aw nānawaknaqey haknihqat qa navoti’yuṅwa; itam pi hakiy aw nānawaknaqey navoti’yuṅwa, pi God Jew‐sinmuy amuhpiy sinmuy ayo ōoyaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nīk̇aṅw pay nāt aw pituto, híkispi pas aw pitsíwta, pep pu’ hakim aṅ pas antsa Inay aw nāwakinwisqam unaṅway aṅqw pas antsay’k̇ahk̇aṅw put aw nāwakinwisniqat aw’i. Pi pan hapi hakim Inay aw nāwakinwisnihqamuy pam tuṅlay’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pi God hapi Hikwsi; noqw put aw nāwakinwisqam pas soon qa unaṅway aṅqw pas antsay’k̇ahk̇aṅw put aw nāwakinwisni. ");
INSERT INTO hopNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Noqw wuhti put aw paṅqawu: Antsa yaw hak Messias Christ yan túṅwantiwhqa God aṅqw pítuniqat nu navoti’ta; ason yaw pam hak pite’, itamuy sohsok hihta āawnani. ");
INSERT INTO hopNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Noqw Jesus put aw paṅqawu: Pay nu ūmi yuaataqa hapi pam Messias. ");
INSERT INTO hopNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Noqw pahsat pu put aw nánatuwnayaqam ö́kihqe, pam wuhtit amum yuaataqw aw k̇āwuwaya; noqw qa haqawa put hihta tūviṅtaqat, pu sen pam hinoqw put aw yuaataqat put tūviṅta. ");
INSERT INTO hopNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Noqw pahsat pu wuhti wikoroy pep mātapt, kīminihqe, ep sinmuy amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Kurs huvam inumum pāmiye’, it hakiy tāqat nuy aṅqaqw hihta hinhtiqat sohsok nuy āawnaqat aw uma yórikyani; ya sen qa i’ hak Christ? ");
INSERT INTO hopNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pahsat pu puma kīṅaqw nö́ṅakqe, put aw öki. ");
INSERT INTO hopNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Noqw put ahkwayñap Jesus aw nánatuwnayaqam put aw ö’qalyaqe paṅqaqwa: Nȫsaa, Tutuqaynaqa. ");
INSERT INTO hopNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Noqw pam umumi paṅqawu: Pay nu nōvat nösniqey himuy’taqw, uma put qa tuwi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Noqw ōviy put aw nánatuwnayaqam nānami paṅqaqwa: Ya sen pay hak eṅem nōvay’va? ");
INSERT INTO hopNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Noqw Jesus amumi paṅqawu: Nu hakiy nuy aṅqw távihqat tunatyayat hintsak̇e’, put tumalayat yúkiniqw pam pantaqa inuṅem nȫsiwhqat anta. ");
INSERT INTO hopNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Noqw ya uma qa paṅqaqwa: Pay nāt nālöq mūmuyawhtuy ep pu’ natwani tsovalniwni, kitota? Meh, nu umumi paṅqawni: Kurs huvam kwuhpukye’, pāvasat aṅ yórikyaa; pi pay tukwsiwyuṅqe tsovalniwniqat aw pitsíwta. ");
INSERT INTO hopNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Noqw hö́hökqa ahsalawṅwu, nihqe soñawnen sinmuy tsovalaqw, puma qatsit qa so’taqat himuy’vayani. Noqw uyhqaniqw, pu hökqa puma nāma hahlayhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Noqw yep hapi yan yuaatiwhqa pas antsaa: Suhk̇a uyhq, pu suhk̇a hȫqö, ii. ");
INSERT INTO hopNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Uma haqe’ qa maqsontotat aṅ höqyaniqat nu aw umuy ayata. Pay pētu aṅ tumaltotaqw, uma amumum sumitumalay’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Noqw k̇aysiwhqam Samariat ep sinom pep kīve yesqam wuhtit lavayiyat ahpiy Jesus aw tūtuptsiwa, ura pam paṅqawu: Pas nu aṅqaqw hihta hinhtiqat pam nuy sohsok āawna. ");
INSERT INTO hopNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Noqw ōviy Samariat ep sinom Jesus aw ö́kihqe, pam pumuy amumum huruhtiniqat put aw nānawakna; noqw pam lȫs tāwat aṅ pep qatu. ");
INSERT INTO hopNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Noqw piw nāt pētu k̇aysiwhqam pas nāp lavayiyat ahpiy put aw tūtuptsiwa; ");
INSERT INTO hopNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nihqe wuhtit aw paṅqawu: Pu’ hapi itam tūtuptsiwa, qa uhlavayiy ahpiy’o, pi itam pas nāp aw tūqayyuṅqe, pas suyan i’ hak sinmuy ayo ōoyhqa Christnihqat itam nanapta. ");
INSERT INTO hopNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Noqw ahpiy lȫs talq pam paṅqw ahpiynihqe, Galileet aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pi God lavay’ayaat nāp tutskway ep qa k̇aptsiwtaṅwuqat Jesus nāp paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Noqw pam Galilee‐tutskwat ep pituqw, Galilee‐sinom put pās taviya, puma pi nuhtum Jerusalem ep nōviwhqat épeqyaqe, put hihta hinhtiqat sohsok aw yórikyaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Noqw Jesus Galileet ep Canat aw piw pitu; pep ura pam kūyit aṅqw ovavalat yuku. Noqw hak pas pavan sinot tiat tiyo Capernaum ep tūtuya. ");
INSERT INTO hopNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Noqw yaw Jesus Judeat aṅqw Galileet ep pítuhqat naat navota; noqw pam as put ámumnen tiyotiyat qalaptsinaniqat pam aw nāwakna, pam okiw mokíwuy aqw pitsíwtaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pahsat pu Jesus put aw paṅqawu: Pas uma aṅ k̇ātatayhpit hihta tuawi’yuṅqat aw qa yórike’ soon tūtuptiwani. ");
INSERT INTO hopNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Noqw pas pavan tāqa put aw paṅqawu: Tāqa, um okiw itiy nāt qa mokq aqwni. ");
INSERT INTO hopNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Noqw Jesus put aw paṅqawu: Pay um aqwni, pay uhti qatu. Noqw Jesus put aw hin lavayhtiqat tāqa tuptsiwhqe, paṅqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nihqe ōviy pam pahsat atk̇amiqniqw, tumal’aymat ahsawvayaqe āawnayaqe aw paṅqaqwa: Pay uhti qa mokqe qatu. ");
INSERT INTO hopNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pahsat pu pam hísatniqw aṅqwtiqat pam pumuy tūviṅta; noqw puma paṅqaqwa: Tāvok tāwanasaproyaqw (tāwa aṅhqe tsaṅe’sikis qöniwmaqw) pam mukihoya. ");
INSERT INTO hopNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Noqw naat navoti’taqw, ura pahsat Jesus put aw paṅqawu: Pay uhti qatu, kita. Nihqe ōviy pam nāp tuptsiwa, pu kīyat sohsoyam ep yesqamu. ");
INSERT INTO hopNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Noqw Jesus Judeat aṅqw Galileet ep pitut yan k̇ātatyhpit tumaltaqe pas hímunihqey pahsat lȫs namtakna. ");
INSERT INTO hopNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","It atsve pu Jew‐sinmuy nōviwhqayamuy aw pitu; noqw Jesus Jerusalem aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Noqw Jerusalem epeq haqam kanelhötsiwat yan túṅwantiwhqat aqlap patuphaiwta; pam Hebrew‐sinmuy amuhkwa Bethesda yan mātsiwhqa; noqw pam tsivót‐sikivo tuhööy’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Noqw okiw hakim ȫöyput, pu qapostalyaqam, qayaktaqam pu amuhpa’ súmokput tūtuyyaqam qaan’ewakw hintaqam paṅ qatsya, pāhut poniniykuniqat maqaptsi’k̇ahk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Pi haqe’ qalawmaqw, ōveqatsit aṅqw hoṅviaya pāmiq hāwe’, put poniniykinaṅwuniqw ōviy’o; noqw pāhut poniniykuqw, hak aqw mohti pak̇e’ tūyay qalaptuṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Noqw hak tāqa sunat pakwt nanal sihk̇ay’taqat yahsaṅwuy aṅ hihta tūtuyhqa okiw pep qatu. ");
INSERT INTO hopNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Noqw pam wáökiwtaqw Jesus túwahqe, pam hisat pantaqw navoti’taqe aw paṅqawu: Ya um qa qalaptuniqey nāwakna? ");
INSERT INTO hopNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Noqw tūtuyhqa lavayhtiqe put aw paṅqawu: Tāqa, pi pāhu poniniykuqw, kurs hak okiw nuy aqw pánaṅwu. Okiw nāt nuy aqw hoytaqw, pay haqawa inupyeve aqw pákiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Noqw Jesus put aw paṅqawu: Wunuptut, uh’ahpay ömahtat, nakwsuu. ");
INSERT INTO hopNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Noqw pahsat pay tāqa qalaptuqe, ahpay ömahtat, nakwsu. Noqw ép nasuṅwintalönwiwta. ");
INSERT INTO hopNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Noqw ōviy Jew‐sinom qalaptuqat aw paṅqaqwa: Pu’ hapi nasuṅwintalöṅni, um uh’ahpay kinumniqw pam qa súanta. ");
INSERT INTO hopNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Noqw pam lavayhtiqe amumi paṅqawu: Pi hak nuy qalaptsinaqa inumi paṅqawu: Uh’ahpay ömahtat, nakwsuu, kita. ");
INSERT INTO hopNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pahsat pu puma put tūviṅtotaqe, aw paṅqaqwa: Noqw ya hak um uh’ahpay ömahtat nakwsuniqat ūmi paṅqawu? ");
INSERT INTO hopNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Noqw i’ hak qalaptuqa put hákiyniqw qa navoti’ta; sinom pep suhpantaqw Jesus pay ahpiyniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ahpiy pantaqw Jesus God kīyat ep put túwahqe aw paṅqawu: Meh, um hapi qalaptu; um pāpu qaanhtiput qaaṅ hinmani, taq nāp hisat k̇a um hihta pas pāpu qalolmat aw pítuni. ");
INSERT INTO hopNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Noqw tāqa ahpiynihqe kurs Jesus put qalaptsinaqat Jew‐sinmuy āawna. ");
INSERT INTO hopNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Noqw paniqw ōviy Jew‐sinom Jesus aw wuktota; nihqe aw put haqami hintsanyaniqey tunatyawyuṅwa, pam nasuṅwintalöṅnit ep it tumaltaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Noqw Jesus pumuy amumi paṅqawu: Nāt Ina pew pahsavo tumalay’ta, noqw ōviy nu’ piw tumalay’ta, kita. ");
INSERT INTO hopNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yantaqat ahpiy Jew‐sinom Jesus nīnayaniqey pas pāpuwat tunatyawyuṅwa, pam nasuṅwintalöṅnit qa hihtata; nit qa put‐saa, pas piw pam God put náatnihqat paṅqawhqe pas God‐nihqey paṅsoq nātsok̇a. ");
INSERT INTO hopNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Pahsat pu Jesus lavayhtiqe, amumi paṅqawu: Pas antsaa, pas antsa nu umumi paṅqawni? Pas soon Tiat hihta nāp nahpiy hintsakṅwu, pas Naat hihta hintsakq, aw tayte’ pam put hintsakṅwu; pi pam hihta hintsakq Tiat piw put an hintsakṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pi Naat Tiy aw unaṅway’ta, nihqe hihta hintsakqey sohsok put aw mahtakinta; nihqe pam īit tutmalat epnihqe nāt pas pávanyaqat put aw mahtaknaqw, uma k̇ātayyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pi Ina so’pumuy ahoy tātaynaṅwu, pu qatsíhuytaṅwu; noqw pan hapi piw nu’ put Tiat hakiy tātaynanik panhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pi Ina qa hakiy hinwat yuykuna; pam put sohsok pantaqat nuy put Tiy aw mātavi, ");
INSERT INTO hopNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Sohsoyam nuy k̇aptsi’yuṅwniqat ōviy’o, pas Inay hin k̇aptsi’yuṅqey pan’i; hak nuy qa k̇aptsi’taqa piw Inay nuy aṅqw távihqat qa k̇aptsi’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Pas antsaa, pas antsa nu umumi paṅqawni: Ilavayiy navotqa, pu Inay nuy aṅqw távihqat aw tuptsiwhqa hapi qatsit qaso’taqat himuy’ta; noqw God pas soon put hinwat yukunani; pi pam mokiwuy aṅqw qatsit aw yámakiwtaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Pas antsaa, pas antsa nu umumi paṅqawni: Ima so’pum God Tiyat tönayat nanaptaniqat aw pituto, hikis pi pay aw pitsíwta; noqw nanaptaqam yesvani. ");
INSERT INTO hopNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Pi Ina pas nāp nahpe qatsit pasiwtaqe, pan piw nu put Tiat pas nāp nahpe qatsit pasiwtaniqat pam inuṅem yuku. ");
INSERT INTO hopNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nihqe nu hin hihta ep yúkumantaniqat nuy öqalmaqa, nu hapi Sinot Tíatniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Uma it aw qa pas k̇āwuwantotani; nāt tūamit aṅ taṅawtaqam sohsoyam itönay nanaptaniqat aw pituto. ");
INSERT INTO hopNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Noqw puma paṅqw nö́ṅakni; ima lolmat tumaltotaqam qatsit aw yesvani; noqw pu qalolmat tumaltotaqam hovalniwyaniqey aw yesvani. ");
INSERT INTO hopNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Soon nu nāp nahpiy hihta hintsakni; nu hin navote’, put ahpiy hin yúkuṅwu, noqw nu hihta suan yúkuṅwu, ispi nu qa itunatyay hinhtiniqey tunatyawtat, pas nuy aṅqw távihqat Inay tunatyayat nu hinhtiniqey tunatyawtaṅwuniqee. ");
INSERT INTO hopNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kurs nu pay nāp nātuawi’taniqw, ituawi hapi qa antsani. ");
INSERT INTO hopNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pay nuy hákiynihqat pas suhk̇a tuawi’ta; noqw nu navoti’taqw pam nuy suan tuawi’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ura uma John aw hakimuy ayatota; noqw pam nuy súan tuawi’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nīk̇aṅw pay nu sinot nuy hin tuawiyat qa pas antsataṅwu; noqw pi as uma ayo nö́ṅakniqat ōviy nu yan lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John pi as pas kopitsoki uwiwitaqa talni’taqat panta; noqw as uma put talniyat ep hahlayyaniqey hihsavo suhtaq’ewya. ");
INSERT INTO hopNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nīk̇aṅw pay John tuawiyat epnihqe himu pas pávannihqa nuy tuwi’ta. Itumala nuy Inay aṅqw taviwhqat mahtakna. Ina nuy hihta hinhtiniqey yúkuniqat ōviy ayataqw, nu put hapi tumalay’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ina nuy aṅqw távihqa pas nāp nuy hákiynihqat paṅqawu: Uma pi qa hisat put tönayat nanapta, piw hin son’iwhqat aw yórikya. ");
INSERT INTO hopNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Noqw put lavayiat umuh’unaṅway qa aw tuyqawi’ta, ōviy pi pam hapi aṅqw taviqw, uma put aw qa tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Uma tutuvenit ahpiy qatsit qa so’taqat tuway’yuṅqey wūwantotaqe, ōviy put aṅ puritota; noqw pi pam nuy hákiynihqat tuawi’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Noqw uma inumiye’ qatsit makiwyaniqey qa nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nu sinmuy tayawinpiyamuy qa nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pi nu umumi navoti’taqw uma umuh’unaṅwpeq God aw qa unaṅway’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nu Inay tuṅwniyat aw yank̇aṅw pituqw, uma nuy qa kwusuya; pay ason hak pas nāp tuṅwniy aw yank̇aṅw pituqw uma pay soon put qa kwusayani. ");
INSERT INTO hopNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ya uma hin tūtuptsiwani? Oviypi uma nānaṅaqw tayawinpit tuṅlay’k̇ahk̇aṅw tayawinpit God‐sa aṅqwnihqat qa tunatyawyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Uma umuh’unaṅwpeq qa pan wūwantotani: Pam Nay aw itamuy qaantaqat ep tūkopanani. Pay suhk̇a umuy pantsakni, aw umuhtaqa’naṅwa, Moses. ");
INSERT INTO hopNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pi uma as Moses tūtuptsiwe’, soon nuy qa tūtuptsiwani, pi pam nuy pēna. ");
INSERT INTO hopNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nīk̇aṅw kurs uma put pēniyat qa tūtuptsiwe’, ya uma hin ilavayiy tūtuptsiwani? ");
INSERT INTO hopNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Iit atsve pu’ Jesus Galileet ep wuhkovatuphat Tiberias yan piw túṅwantiwhqat ayoqwat yama. ");
INSERT INTO hopNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Noqw sinom qaan’ewakw hintaqam put aṅkya, pam tūtuyyaqamuy amuhpa’ k̇ātatayhpiy tumaltaqw aw yórikyaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Noqw Jesus tsomomiq wupqe, put aw nánatuwnayaqamuy amumum pepeq qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Noqw Jew‐sinmuy tuiwiam Amutsva‐Yūmosanihqat ep nōviwhqat aw hayiṅwiwta. ");
INSERT INTO hopNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Noqw Jesus kwuhpukqe, sinmuy qaan’ewakw hintaqamuy put aw ökiwtaqamuy amumi yórikqe, Philip aw paṅqawu: Ya itam sen haqam tunöstuiyaqw ima nȫnösani? ");
INSERT INTO hopNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Noqw pay pam put aw hin hepqe ōviy kita, pay pi as pam hinhtiniqey nāp navoti’taqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Noqw Philip put aw paṅqawu: Pay as pi kurs itam lȫp sunat sīvat akw pölavikit tuiye’, itam nāto kurs hin pumuy sohsokmuy hiṅsakw nopnayani. ");
INSERT INTO hopNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Noqw suhk̇a put aw nánatuwnaqa Andrew, it Simon Peter tupkoat, Jesus aw paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Hak yep tiyohya tsivot söhövosvölavikit nitkay’va, pu lȫqmuy tsākw pākiwhtuyu; noqw ya pam sinmuy k̇aysiwhqamuy amumi hímuu? ");
INSERT INTO hopNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Noqw Jesus paṅqawu: Uma sinmuy yesvanayani. Noqw pep a’nö tūsaqa; noqw ōviy sinom paṅ yesva, tsivót‐sikip sōmorit pahsa’haqam tahtaqtu. ");
INSERT INTO hopNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pu Jesus pölavikit ömahtaqe, put ep hihlayhtit, put aw nánatuwnayaqamuy amumi put oya; noqw puma aṅ yesqamuy amuhpa put o’ya, pu pākiwhtuy pīwu, hihsa’haqam nānawaknaqat pahsaa. ");
INSERT INTO hopNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Noqw pumuy ȫöyaqw, pam put aw nánatuwnayaqamuy amumi paṅqawu: Uma yóṅoyhput akwsiṅwqat tsovalayani, noqw qa himu hovalniwni. ");
INSERT INTO hopNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Noqw ōviy puma tsivot söhövosvölavikit aṅqw yóṅoyhput nȫnösaqamuy akwsiṅwpuyamuy tsovalayaqe, pakwt lȫq sihk̇ay’taqat tutsáysivut aṅ opomnaya. ");
INSERT INTO hopNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Noqw Jesus k̇ātatayhpit tumaltaqw, sinom aw yórikyaqe, paṅqaqwa: Pay kurs pas antsa i’ tāqa God lavay’ayaat tūwaqatsit aw pitúniqa. ");
INSERT INTO hopNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Noqw puma put awye’, pas öqalay akw put moṅwtapyaniqat Jesus māmatsqe pay nāla piw tsomot aqwhaqamii. ");
INSERT INTO hopNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Noqw tapkiqw put aw nánatuwnayaqam wuhkovatuphat aw hanhqe, ");
INSERT INTO hopNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pākihut aqw yuṅt pāvaqe Capernaum aqwya; noqw nuṅwu qatālawvaqw, nāt Jesus qa pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Noqw pumuy panwisq, a’nö hukvaqw pāhu a’nö hoṅvanta. ");
INSERT INTO hopNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Noqw ōviy puma pāhut aṅqe’ kwetstiwisqe payhp, sen nālöp tutskwatuwanit pahsavohaqami hoyóyoykuyaqw, Jesus pāvaqe waymak̇aṅw pākihut aw hayiṅwna. Noqw pam panmaqw, puma put tutwaqe pas tsātsawna. ");
INSERT INTO hopNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Noqw pam pumuy amumi paṅqawu: Pay nūu, uma qa tsawiniwyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pahsat pu puma hahlayhtotiqe, put pākihut aqw panaya; noqw pahsat pay pākihu pumuy haqami hoyóyototaqat aqw pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Noqw qavoṅvaqw sinom wuhkovatuphat ayaqwat huruhtotiqam ura pay suhk̇a pākihu pápiqniqw put u’naya; noqw ura Jesus aw nánatuwnayaqam put aqw yuṅqw, pay ura Jesus pumuy qa amumum put aqw paki, noqw pay puma nanalt ahpiyya. ");
INSERT INTO hopNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Noqw pay pētu pākihu Tiberius aṅqwyaqam paṅso öki, ura Tutuyqawhqa haqam pölavikit ep hahlayhtit tūnopnaqat paṅsoo. ");
INSERT INTO hopNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Noqw sinom Jesus‐nik̇aṅw pu put aw nánatuwnayaqamuy pep qa tutwaqe, pākihut aṅ yuṅt, Jesus hepwisqe Capernaum ep öki. ");
INSERT INTO hopNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nihqe puma wuhkovatuphat yupqöyveq put tutwaqe, aw paṅqaqwa: Tutuqaynaqa, ya um hisat peqw pitu? ");
INSERT INTO hopNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus lavayhtiqe pumuy amumi paṅqawu: Pas antsaa, pas antsa nu umumi paṅqawni: Uma k̇ātutmalat aw yórikyaqey qa paniqw nuy hepnumya, pi uma pölavikit nȫnösaqe ȫöyaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Uma nȫsiwhqat pay súlawhtiṅwuqat qa put ōviy tumalay’yuṅwni. Uma nȫsiwhqat qatsit qaso’taqat aniwnaqat ōviy tumalay’yuṅwni; put hapi nu’ Sinot Tiat umuy máqani. Pi Ina God öqalay akw nuy tuvoylata. ");
INSERT INTO hopNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Noqw puma put aw paṅqaqwa: Noqw itam hihta tumalat hintsatsk̇e’ God tayawnayani? ");
INSERT INTO hopNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus lavayhtiqe amumi paṅqawu: Uma hapi hakiy God aṅqw távihqat aw tūtuptsiwe’, yan God tayawnayani. ");
INSERT INTO hopNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pahsat pu puma put aw paṅqaqwa: Noqw ya um hihta akw put pantaqat itamumi mahtaknaqw itam aw yórikye’ ūmi tūtuptsiwani? Um hihta tumalay’ta? ");
INSERT INTO hopNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Itanam pi ura qayēsiwhpuve hihta mennat nōnova; ōviy pi yan pey’ta: Pam ōveqatsit aṅqw pumuy tunösmaqa, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Pahsat pu Jesus pumuy amumi paṅqawu: Pas antsaa, pas antsa nu umumi paṅqawni: Qa Moses pút pölavikit ōveqatsit aṅqw umuy maqa; noqw Ina hapi pas antsa pölavikit ōveqatsit aṅqwnihqat umuy maqa. ");
INSERT INTO hopNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pi ōveqatsit aṅqw hawhqa hapi God aṅqw pölavikit anta, pam hapi sinmuy qatsit huylawu. ");
INSERT INTO hopNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pahsat pu puma put aw paṅqaqwa: Tutuyqawhqa, um okiw sutsep itamuy it pölavikit huylawni. ");
INSERT INTO hopNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Noqw Jesus amumi paṅqawu: Nu hapi pölaviki hakiy qatsit máqaṅwuqa; inumi pítuhqa soon hisat tsöṅmokni, pu inumi tuptsiwhqa soon hisat pānaqmokni. ");
INSERT INTO hopNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Noqw pi nu ura umumi paṅqawu: Uma as inumi yórikyak̇ahk̇aṅw qa tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sohsoyam Inay aṅqw inumi noiwyaqam inumiyani, noqw ason hak inuminiqw, soon nu put ayo tūvani. ");
INSERT INTO hopNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nu qa nāp itunatyay hintsakniqe ōveqatsit aṅqw hāwi, nu Inay nuy aṅqw távihqat tunatyayat hintsakniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Noqw i’ hapi Inay nuy aṅqw távihqat tunatyaata: Nu sohsokmuy hakimuy put ahpiy inumi noiwyaqamuy qa hihtawat kwayht, nuhtuṅk talöṅvaqat ep pumuy ahoy tātaynani. ");
INSERT INTO hopNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Noqw i’ hapi nuy aṅqw távihqat tunatyaata: Sohsoyam Tiyat aw yórikyak̇ahk̇aṅw, put aw tūtuptsiwaqam qatsit qaso’taqat makiwyani; noqw nu nuhtuṅk talöṅvaqat ep pumuy ahoy tātaynani. ");
INSERT INTO hopNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pahsat pu Jew‐sinom put aw qayan unaṅway hiṅqaqwa, pam pölaviki ōveqatsit aṅqw hawhqey ura paṅqawhq ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nihqe puma paṅqaqwa: Ya qa i’ Jesus, it Joseph tíata? Itam put náyat‐nik̇aṅw pu yuyat pumuy tuwi’yuṅwa. Noqw ya hintaqw ōviy pam ōveqatsit aṅqw hawhqey paṅqawlawu? ");
INSERT INTO hopNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Noqw ōviy Jesus lavayhtiqe amumi paṅqawu: Uma qa nānahpa’ qaán umuh’unaṅway hiṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Pas Ina nuy aṅqw távihqa hakiy pan unaṅwtoynaqw, pam‐sa inumini; noqw nu nuhtuṅk talöṅvaqat ep put ahoy tātaynani. ");
INSERT INTO hopNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pi ura God lavay’aymuyatuy pēniyamuy aṅ yan pey’ta: Pu puma sohsoyam God aṅqw tutuqayyani, yan’i. Paniqw ōviy sohsoyam Inay aṅqw nanaptak̇aṅw pu tūqayyaqam inumi ökiwta. ");
INSERT INTO hopNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pay k̇a hak hisat Inay aw yórikqat nu qa paṅqawu, hal i’ hak God aṅqw pítuhqa, pam‐sa Inay aw yóriki’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Pas antsaa, pas antsa nu umumi paṅqawni: Inumi tuptsiwhqa hapi qatsit qaso’taqat pay makiway’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nu hapi pölaviki sinmuy qatsit máqaṅwuqa. ");
INSERT INTO hopNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pay as pi umanam qayēsiwhpuve hihta mennat nȫnösat, pay qa yēse. ");
INSERT INTO hopNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nu hapi i’ pölaviki ōveqatsit aṅqw hawhqa, it pölavikit aṅqw nösqa qa mokniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nu hapi taytaqa pölaviki ōveqatsit aṅqw hāwi; it pölavikit aṅqw nösqa sutsep qátuni. Noqw nu pölavikit lavayhtiqe itokoy paṅqawu; put hapi nu sinmuy amuṅem távini, puma yesniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Noqw ōviy Jew‐sinom put ep nāṅwuy’yuṅqe, paṅqaqwa: Ya sen i’ hin itamuy tokoy nopnani? ");
INSERT INTO hopNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Pahsat pu Jesus amumi paṅqawu: Pas antsaa, pas antsa nu umumi paṅqawni: Pas uma Sinot Tiyat tokoyat qa nȫnösak̇aṅw, pu put uṅwáyat qa hikwye’ uma umuh’unaṅwpeq qatsit ṅastayani. ");
INSERT INTO hopNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Itokoy tūmoytak̇aṅw, pu iuṅway hīhikwqa hapi qatsit qa so’taqat pay himuy’ta, noqw nu nuhtuṅk talöṅvaqat ep put ahoy tātaynani. ");
INSERT INTO hopNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pi itoko pas antsa nȫsiwhqa, pu iuṅwa pas antsa hīhikwaqa. ");
INSERT INTO hopNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Itokoy tūmoytak̇aṅw pu iuṅway hīhikwqa inuhpe qatu; noqw nu put ep qatu. ");
INSERT INTO hopNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Pi Ina qátuhqa nuy aṅqw tavi; noqw nu put ahpiy qatu; noqw pay pan hapi hak nuy tūmoytaqa nuy akw qátuni. ");
INSERT INTO hopNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","I’ hapi pám himu pölaviki ōveqatsit aṅqw hāwi; pam it mennat umunamuy amuhpiy nȫsiwhqat qa panta; ura puma put aṅqw nȫnösat, pay qa sutsep yēse. It pölavikit aṅqw nösqa hapi pas sutsep qátuni. ");
INSERT INTO hopNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Pam Capernaum ep tsotsvalkive sinmuy tutuqaynak̇aṅw, yan lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Noqw ōviy k̇aysiwhqam put aw nánatuwnayaqam it nanaptaqe paṅqaqwa: Pam hihta pas nuhtsel’ewakw itamuy tutuqayna; ya sen hak aṅ kuytani? kitota. ");
INSERT INTO hopNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Noqw put aw nánatuwnayaqam it ep qaan’unaṅway hiṅqaqwaqw, Jesus unaṅwpeq navoti’taqe, amumi paṅqawu: Ya i’ umumi qalomátöqti? ");
INSERT INTO hopNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Noqw tis kurs k̇a nu Sinot Tiat ōveqatsit ep qátuṅwuqey aqw wuptoqw, uma aw yórikye’, pahsat uma hin wūwayani? ");
INSERT INTO hopNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pi Hikwsi hapi hakiy taytoynaṅwu; hakiy tokoat qa hihta ápiniṅwu; nu umumi hihta lavayhtiqw, pam pantaqa hikwsit aṅqwnihqe sinmuy qatsíhuylawu. ");
INSERT INTO hopNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Noqw pi uma haqawat qa tūtuptsiwa. Pi hakim put aw qa tuptsiwni’yuṅqat Jesus pay navoti’ta, pu hak momṅwituy amumi put mātapniqata. Pam sinmuy tutuqaynativaqey aṅqaqw pūvut sohsok navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pahsat pu pam paṅqawu: Paniqw hapi ōviy nu ura umumi paṅqawu: Pas Ina hakiy qa pan unaṅwtoynaqw, soon pam hak inumini. ");
INSERT INTO hopNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yantaqat atsve put aw nánatuwnayamuy amuṅaqw wūhaqnihqam put mātatve; nihqe pāpu qa amum hinnumya. ");
INSERT INTO hopNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Noqw pahsat pu Jesus imuy pakwt lȫq sihk̇ay’taqamuy amumi paṅqawu: Noqw ya uma nuhtum inuṅaqw ahpiyyani? ");
INSERT INTO hopNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Noqw pahsat pu Simon Peter lavayhtiqe paṅqawu: Tutuyqawhqa, noqw itam hakiy awyani? Pi um pi lavayit qatsit qaso’taqat aniwnaqat lalvaya. ");
INSERT INTO hopNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Noqw pay itam tūtuptsiwaqe, um pas pam hak Christ God qátuhqat Tíatnihqat qapēvewnaya. ");
INSERT INTO hopNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Noqw Jesus amumi paṅqawu: Ya nu umuy pakwt lȫq sihk̇ay’taqamuy qa namorsta? Noqw uma haqawa Nukpanat akw tuyqawiwta. ");
INSERT INTO hopNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pam hakiy Simon tiyat Judas Iscariot paṅqawu. Pam hapi as imuy pakwt lȫq sihk̇ay’taqamuy amumum tōnawk̇aṅw Jesus momṅwituy amumi mātapniniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yantaqat atsve pu’ Jesus Galileet ep hinnuma, Jew‐sinmuy put nīnayaniqey tunatyawyuṅqw, ōviy pam Judeat ep qa hinnumniqee. ");
INSERT INTO hopNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Noqw Jew‐sinom hisat nanalt talöṅvaqat aṅ kihsit aṅ yesṅwuqat aw pituto. ");
INSERT INTO hopNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Noqw ōviy Jesus tupkomat put aw paṅqaqwa: Yupa, Judeat aqw’a, noqw ūmi nánatuwnayaqam uṅ hihta hintsakqat aw nuhtum tāyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Qa haq pi hak nātuwiwniqey nāwaknaqa nanauyve tumalay’taṅwu. Kurs um pas antsa īit hintsak̇e’, um nuhtumi nāmahtaknani. ");
INSERT INTO hopNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hikis pi put tupkomat put aw qa tuptsiwni’yuṅqe ōviy yan aw lavayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pahsat pu Jesus pumuy amumi paṅqawu: Pay nāt ituwaniy aw qa pitu; nawus pi umuhtuwaniy aw sutsep pitsíwta. ");
INSERT INTO hopNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Pay yep qatsit tunatyayat aṅ hinwisqam soon qa umumi unaṅway’yuṅwni; inumi pi qayan unaṅway’yuṅwa, puma qalomáhintsatsk̇aqat nu paṅqawlawhq ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pay pi uma nōviwhqat aqwyani, nu’ pay nāt qa aqwni, nāt ituwaniy aw qa pas pas pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yan pam pumuy amumi lavayhtit, pay hāk Galileet ep huruhti. ");
INSERT INTO hopNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nīk̇aṅw ason put tupkomat pas aqwyaqw, pahsat pu pam tuwat nōviwhqat aqw’a, nīk̇aṅw pay qa nuhtumnit pay hihin nanauyvee. ");
INSERT INTO hopNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Noqw ōviy Jew‐sinom nōviwhqat epeq put hepnumyaqe paṅqaqwa: Ya pam háqamo? ");
INSERT INTO hopNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Noqw sinom put hīhin lavayta; noqw haqawat paṅqaqwa: Pas as pam lolma; noqw pētu paṅqaqwa: Qae, pam nuhtumi yēlawu. ");
INSERT INTO hopNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Noqw pay puma nanayuve put lavayta, puma Jew‐sinmuy mamqasyaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Noqw nōviwhqat nālös talöṅni’maqw, Jesus God kīyat awnihqe, pep sinmuy tutuqayna. ");
INSERT INTO hopNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Noqw Jew‐sinom k̇ātayyuṅqe paṅqaqwa: Ya i’ qa tutuqayṅwunik̇aṅw hin tutuvenit tuwi’ta? ");
INSERT INTO hopNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Noqw Jesus lavayhtiqe pumuy amumi paṅqawu: Pay itutuqayhpi qa inuhpiy’o, pam nuy aṅqw távihqat ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Put tunatyayat hinmaniqey tunatyawtaqa itutuqayhpiy háqaqwnihqat māmatsni, sen pam God aṅqwnihqata, sen pay nu nāp nahpiy yuaataqata. ");
INSERT INTO hopNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kurs nu nāyuaate’, k̇a nu tayawniwniqey tuṅlay’tani; nīk̇aṅw kurs nu Inay nuy aṅqw távihqat tayawniwniqat tunatyawte’, pahsat pu nu pas soon atsátani, noqw himu qasuantaqa inuhpe súlawni. ");
INSERT INTO hopNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Puyaw umuy hin hinwisniqat Moses umumi qa tutapta? Noqw uma qa haqawa put tutavoyat an hinma. Uma pi nuy nīnayaniqey anyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Noqw sinom lavayhtotiqe aw paṅqaqwa: Kurs um nukpanhikwsit akw tuyqawiwta. Ya hak uṅ nīnaniqey anta? ");
INSERT INTO hopNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus amumi paṅqawa: Ura nu sūs nasuṅwintalöṅnit ep hihta tumaltaqw, uma sohsoyam k̇ātayyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pu ōviy pi piw tiyohya poṅotkiwmantaniqat Moses umumi tutapta. (Pam qa Moses ahpiy panta, pas itanamuy amuhpiy pan yukiwta.) Noqw uma nasuṅwintalöṅnit ep hakiy poṅotkuyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Noqw uma Moses tutavoyat anhtotiniqey nānawaknaqe, nasuṅwintalöṅnit ep hakiy poṅotkuyanik pantsatsnaṅwu. Noqw kurs uma pantotinik, uma hinoqw inumi tu’qawyuṅwa, nu nasuṅwintalöṅnit ep hakiy qalaptsinaq’ö? ");
INSERT INTO hopNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Uma pay hihta hin son’iwhqat pan put hin yukunayaṅwu, as uma pam hin pas antsa hintaqat pan put yukunayanik̇ahk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pahsat pu haqawat Jerusalem ep ki’yuṅqam paṅqaqwa: Ya puma qa it nīnayaniqey tunatyawyuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Noqw meh, pam qa tuhtusk̇aṅw yuaataqw, puma aw qa hiṅqaqwa. Ya sen momṅwit pay it Christnihqat suyan navoti’yuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Qae. Pi itam it tāqat háqaqwniqw navoti’yuṅwa; noqw pi Christ pituqw, qa hak put haqaqw pituqw navoti’tani. ");
INSERT INTO hopNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pahsat pu Jesus God kīyat ep sinmuy tutuqaynak̇aṅw, k̇ēew paṅqawu: Uma nuy tuwi’yuṅwa, pu nuy háqaqwnihqat navoti’yuṅwa. Noqw nu’ hapi qa nāp itunatyay pitu. Pi i’ hak pas antsanihqa nuy aṅqw tavi. Noqw put hakiy uma qa tuwi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Noqw nu’ pi put tuwi’ta; pi nu’ put aṅqw pítuhqee; noqw pam nuy aṅqw tavi. ");
INSERT INTO hopNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pahsat puma as put ṅuayaniqey anhtoti. Noqw pay qa hak aw may’ta, nāt tuwaniyat aw qa pituqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Noqw pay sinmuy amuṅaqw k̇aysiwhqam put aw tūtuptsiwaqe paṅqaqwa: Ya sen Christ hisat pite’, it tāqat tutmalayat epnihqe pas pavan k̇āhintsakni? ");
INSERT INTO hopNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Noqw yaw sinom nānahpa’ nauyhiṅqaqwaqat Pharisee‐sinom nanaptaqe, God awwat mohpeq momṅwituy amumum hoṅviaymuy put aw hōnaya, put ṅuayaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pahsat pu Jesus pumuy amumi paṅqawu: Pay nāt nu hihsavo umumum yantat, nuy aṅqw távihqat awni. ");
INSERT INTO hopNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Noqw uma as nuy hepyat, soon nuy tutwani; pu nuy haqaminiqw uma kurs hin paṅsoyani. ");
INSERT INTO hopNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pahsat pu Jew‐sinom nānami paṅqaqwa: Ya sen i’ haqamini? Ya hintaqw itam kurs hin put tutwani? Ya sen pam pay qa‐Jew‐sinmuy amuhpa’ itahsinmuy ahtsavaliwtaqamuy amuminen, qa‐Jew‐sinmuy tutuqaynani? ");
INSERT INTO hopNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ya sen hiṅqawhqe paṅqawu: Uma as nuy hepyanik̇ahk̇aṅw, soon nuy tutwani; pu piw nuy haqaminiqw uma kurs hin paṅsoyani, kita? ");
INSERT INTO hopNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Noqw nōviwhqat ep nuhtuṅk wukotalöṅvaqat ep Jesus wunuptut, pas k̇ēew paṅqawu: Pānaqmokiwtaqa inuminen hikwni. ");
INSERT INTO hopNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Inumi tuptsiwni’taqat ahsonṅaqw kūyi taytaqa munvamantani; tutuvenit hin lavayhtiqat pan’i, pam kita. ");
INSERT INTO hopNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Pam yan lavayhtiqe it Hikwsit paṅqawu, put hapi hakim Jesus aw tuptsiwyaqam ason makiwyani. Qahováriwtaqa Hikwsi nāt nuhtumi qa noiwa, nāt Jesus qa pas pas hímuniwhtiqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Noqw ōviy k̇aysiwhqam sinom it yan lavayit nanaptaqe paṅqaqwa: Pay kurs pas antsa i’ hapi God lavay’ayaat pas pávannihqa. ");
INSERT INTO hopNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Noqw pētu paṅqaqwa: Pay i’ pas pam Christ. Noqw haqawat paṅqaqwa: Ya Christ yaw Galileet aṅqw yámakni? ");
INSERT INTO hopNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Puyaw tutuveni qa pan lalvaya: Ura Christ David ahpiy aniwhtini, pu Bethlehem kitsókit aṅqw yámakni, ura David haqam qátuṅwuqat aṅqö’? ");
INSERT INTO hopNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Noqw ōviy sinom Jesus ep nātsiki. ");
INSERT INTO hopNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Noqw haqawat as put ṅuayaniqey nānawaknaqw, pay qa hak put aw may’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pahsat pu ima hoṅvia’yat God awwat mohpeq momṅwituy amumi‐nik̇aṅw, pu Pharisee‐sinmuy amumi ökiqw, puma pumuy amumi paṅqaqwa: Ya uma hinoqw qa wikvaya? ");
INSERT INTO hopNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Noqw hoṅvia’yat paṅqaqwa: Pas qa hak tāqa hisat it tāqat an yuaata. ");
INSERT INTO hopNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pahsat pu Pharisee‐sinom pumuy amumi paṅqaqwa: Noqw ya uma nuhtum ūnatoti? ");
INSERT INTO hopNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ya hakim momṅwituy sen Pharisee‐sinmuy amuṅaqw put aw tūtuptsiwa? ");
INSERT INTO hopNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ima söqavuṅwsinom tutavot qa tuwi’yuṅqam pi pay qalolmat makiway’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Noqw Nicodemus, ura Jesus aw mihikq pítuhqa, pumuy amumum sinoiwtaqa amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Hakim nāt hakiy aw qa tūqayyuṅwt, pu put hihta hinhtiqat nāt qa nanaptat, pay eṅem hin yukuyamantaniqat ya itahtutavo pan yukiwta? ");
INSERT INTO hopNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Noqw puma lavayhtotiqe put aw paṅqaqwa: Noqw ya um piw Galileet aṅqw sino? Tutuvenit aṅ pupre’, um navotni, qa hak God lavay’ayaat Galileet aṅqw yámakni. ");
INSERT INTO hopNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Noqw sohsoyam nanap kiy aṅqe’ya. ");
INSERT INTO hopNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Noqw Jesus tsomot Olivet yan mātsiwhqat aw’i. ");
INSERT INTO hopNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pu suits talavay pam piw God kīyat aw paki, noqw sinom sohsoyam put aw ökiqw, pam qatuptuqe pumuy tutuqayna. ");
INSERT INTO hopNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Noqw tutavot tutuqaynayaqam Pharisee‐sinmuy amumum hakiy wuhtit qa nāp himuy amum hintsakk̇aṅw núansaniwhqat put aw wikvaya; nihqe puma put nāsave taviyat, ");
INSERT INTO hopNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesus aw paṅqaqwa: I’ wuhti qa nāp himuy amum hintsakk̇aṅw núansaniwa, nāt pas hintsakk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Noqw Moses hapi tutavot ep itamuy pas ayataqe, hakim hakiy pan hintsakqat tatatupninayaniqat paṅqawu. Noqw uṅniqw hintani? ");
INSERT INTO hopNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pay puma Jesus aw hin hepyaqe, aw put hihta nēveltoynayaniqey ōviy yan lavayhtoti. Noqw pay Jesus motoltit, malatsiy akw tutskwava penta, suhpan qa navotqey pan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Noqw ōviy puma put pas tūviṅlalwaqw, pam kwuhpukqe amumi paṅqawu: Pay pi haqawa umuṅaqw pas qa hihtakw hintaqa put mohti owat aw tūvani, kitat, ");
INSERT INTO hopNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pu piw motoltiqe, tutskwava penta. ");
INSERT INTO hopNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Noqw nanaptaqam qaanhinwisqey unaṅwpeq sunvoti’k̇ahk̇aṅw, nānap paṅqw nȫṅantiva, suswukoqw aṅqw hoyoyoykuyakaṅw nuhtuṅknihqat aqw pahsavoo, noqw Jesus wuhtit nāsave wúnuhqat amum nāla akwsiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Noqw Jesus kwuhpukqe, pay wuhtit nāla epniqw, pam put aw paṅqawu: Wuhti, ya uṅ hihta nēveltoynayaqam haqamiya? Ya qa hak uṅ mokniqat uṅem hin yuku? ");
INSERT INTO hopNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Noqw pam put aw paṅqawu: Pay qa hak’i, Tutuyqawhqa. Noqw Jesus aw paṅqawu: Pay nu piw uṅem qa pan yuku; um ahpiynen, pāpu qaanqatsit qe’ni. ");
INSERT INTO hopNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pahsat pu Jesus piw pumu amumi paṅqawu: Nu hapi sinmuy amumi tāla; inuṅk hinmaqa qatalpuva soon hinmani; pam qatsit aw tālat aṅ hinmani. ");
INSERT INTO hopNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Noqw ōviy Pharisee‐sinom put aw paṅqaqwa: Um nātuawi’ta; uhtuawi qa súanta. ");
INSERT INTO hopNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus lavayhtiqe amumi paṅqawu: Pay as pi nu nāp nātuawi’taqw, pay ituawi súanta; pi nu haqaqw pítuk̇aṅw pu haqaminiqey navoti’ta. Noqw uma pi nuy haqaqw pítuhqat, pu nuy haqaminiqat qa navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Uma pay sinmuy amún hihta hin yukuyaṅwu, nu qa hakiy eṅem hin yuyku. ");
INSERT INTO hopNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pu nāmahin pi as kurs nu hakiy eṅem hin yuk̇e’, nu suan yúkuṅwu, pi nu qa nālaa, Inay nuy aṅqw távihqa inumuma. ");
INSERT INTO hopNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Noqw ura kurs pi lȫyöm hihta tuawi’taqw, tuawiam súantaṅwuqat umuhtutavoy aṅ pan pey’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Noqw nu suhk̇a nātuawi’ta, noqw pu Ina nuy aṅqw távihqat nuy hákiynihqat tuawi’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pahsat pu puma put aw paṅqaqwa: Noqw una háqamo? Noqw Jesus amumi paṅqawu: Uma itamuy qa tuwi’yuṅwa‐nūyu, pu Inayu; pi as uma nuy tuwi’yuṅwe’, soon piw Inay qa tuwi’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yan Jesus sivatataṅpit ep yuaayku, God kīyat ep sinmuy tutuqaynak̇aṅwo; noqw qa hak put aw may’ta, nāt tuwaniyat aw qa pituqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pahsat pu Jesus piw amumi paṅqawu: Nu ahpiyni; noqw uma as nuy hepyani, nīk̇aṅw uma umuhqaanhtipuy aṅ hinwisk̇ahk̇aṅw so’ni. Nuy haqaminiqat uma kurs hin paṅsoyani. ");
INSERT INTO hopNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pahsat pu Jew‐sinom paṅqaqwa: Ya pam hinoqw itam kurs hin put haqaminiqat paṅsoyaniqat paṅqawu? Ya sen pam nāninani? kitota. ");
INSERT INTO hopNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pu pam amumi paṅqawu: Uma yaṅqw tūwaqatsit aṅqwya; nu ōṅaq’ö; uma yep qatsit ahpiyya, nu qa yep qatsit ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Paniqw hapi ōviy nu umumi paṅqawu: Uma umuhqaanhtipuy aṅ hinwisk̇ahk̇aṅw so’ni; pi uma nuy haknihqey paṅqawhqat qa tūtuptsiwe’, uma umuhqaanhtipuy aṅ hinwisk̇ahk̇aṅw so’ni. ");
INSERT INTO hopNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pahsat pu puma put aw paṅqaqwa: Ya um hak hímuu? Noqw Jesus amumi paṅqawu: Pay nu ura mohtihaq umuy put āawna. ");
INSERT INTO hopNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nu as nihtiwhtaqat hihta ep umuy hin lavayhtini, pu umumiq hiṅqawni; noqw i’ hak nuy aṅqw távihqa pas qa atsa; noqw nu put aṅqw hihta navotqey nuhtumi yuaata. ");
INSERT INTO hopNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pam pumuy amumi Nay lavayhtiqat puma qa māmatsya. ");
INSERT INTO hopNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pahsat pu Jesus amumi paṅqawu: Ason uma nuy Sinot Tiyat nahoylehtsit ep hahye’, pep pu’ uma nuy hákiynihqat nanaptani, pu nu qa nāp nahpiy hihta hintsakqata; Ina inumi hin tutaptaqat nu pan hintsaki. ");
INSERT INTO hopNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Pu nuy aṅqw távihqa inumuma. Ina nuy qa naltavi, nu yūmosa unaṅwve hinmaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yan pam lavayhtiqw, k̇aysiwhqam put aw tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pahsat pu Jesus Jew‐sinmuy put aw tūtuptsiwaqamuy amumi paṅqawu: Uma ilavayiy aṅ hinwise’, pep pu’ uma pas antsa inumi nánatuwnayaqamyani. ");
INSERT INTO hopNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nen uma navotit pas antsanihqat tuwi’yuṅwni, noqw pam navoti umuy qenivo óyani. ");
INSERT INTO hopNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Puma lavayhtotiqe put aw paṅqaqwa: Itam Abraham tímatu; nihqe itam qa hisat hakiy aw tūwik’iwyuṅwa; noqw hintaqw ōviy itam qenive oyiwyuṅwniqat um paṅqawu? ");
INSERT INTO hopNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus lavayhtiqe amumi paṅqawu: Pas antsaa, pas antsa nu umumi paṅqawni: Qaantsakqa hapi qaanhtiput aw tūwikiniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Noqw tūwiki pi qa sutsep kīve ki’taṅwu, pi ki’taqat tiat pep pas sutsep ki’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Noqw ōviy kurs Tiat umuy qenivo oyaqw, uma hapi pas antsa qeniveyani. ");
INSERT INTO hopNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Pas as pi uma Abraham tímatniqw nu navoti’ta; noqw pi uma nuy nīnayaniqey tunatyawyuṅwa, ilavayi umuh’unaṅwpeq qa haqam qeni’taqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pi nu Inay amum qátuhqe, hihta aw yórikqey umumi yuaata; noqw pu uma umunay amum yesk̇aṅw pam hihta hintsakqat uma aw yórikyaqey put tuwat hintsatsk̇a. ");
INSERT INTO hopNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Puma lavayhtotiqe aw paṅqaqwa: Abraham itanaa. Jesus amumi paṅqawu: Pi as uma Abraham tímatnen, soon qa Abraham hintsakpiyat hintsatsk̇ani. ");
INSERT INTO hopNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Noqw uma soq tuwat nuy nīnayaniqey tunatyawyuṅwa, ispi nu God aṅqw lavayit pas antsanihqat navotqey umuy āawnaq’ö. Abraham pi qa pan hinhti. ");
INSERT INTO hopNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Uma umunay hintsakpiyat hintsatsk̇a. Pahsat pu pumuy put aw paṅqaqwa: Itam qa tusk̇apqatsit ahpiy tihtiwya, itam sūkw nay’yuṅwa, it God. ");
INSERT INTO hopNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Noqw Jesus amumi paṅqawu: Pi as God umunayniqw soon uma inumi qa unaṅway’yuṅwni, pi nu God aṅqw yámakqe put aṅqw pitu; pi nu qa nāp itunatyay aṅq’ö; pi God nuy aṅqw tavi. ");
INSERT INTO hopNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ya uma hinoqw ilavayiy qa māmatsya? Ispi kurs hin uma ilavayiy aw tuqayvastotaniqee. ");
INSERT INTO hopNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Uma umunay Nukpanat ahpiy aniwhti, nihqe uma umunay tunatyayat hintsatsk̇aniqey nānawakna. Pam yayhniwhqat aṅqaqw tuqwyanta; himu pas antsanihqa put ep súlawniqw, ōviy pam antsanihqat ep qa huruhti; pam atsáte’, nāp himuy lavayhtiṅwu; pam a’nö átsanihqee, pas atsat aaniwnaqa. ");
INSERT INTO hopNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Noqw pay soq pi nu umumi pas qa atsat lavayhtiqw, ōviy uma nuy qa tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Haqawa uma nuy hihta ep qaanhtiqat pas súaṅqawni? Noqw kurs nu pas qa atsat umumi lavayhtiqw, ya hinoqw uma nuy qa tūtuptsiwa? ");
INSERT INTO hopNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","God ahpiynihqa God lavayiyat navotṅwu’, noqw paniqw ōviy uma put qa nanapta, uma qa God ahpiy aniwhtiqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pahsat pu Jew‐sinom lavayhtotiqe put aw paṅqaqwa: Noqw pay itam súaṅqaqwaqe, um Samariat aṅqw sínonihqe nukpanhikwsit akw tuyqawiwtaqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Noqw Jesus lavayhtiqe amumi paṅqawu: Nu qa nukpanhikwsit akw tuyqawiwta; nu Inay k̇aptsi’taqw uma nuy qa k̇aptsi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pu nu inumi k̇ātayyuṅwniqat qa tunatyawta; pay ason pas suhk̇a put tunatyawta; nihqe pam itamuhtsave hinwat yúkuni. ");
INSERT INTO hopNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Pas antsaa, pas antsa nu umumi paṅqawni: Ilavayiy an hinmaqa soon mokiwuy ep pítuni. ");
INSERT INTO hopNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pahsat pu Jew‐sinom put aw paṅqaqwa: Pu’ hapi itam pas suyan nanaptaqw um nukpanhikwsit akw tuyqawiwta. Abraham mōki; pu God lavay’aymat piw soa; noqw um piw nāt paṅqawu: Ilavayiy an hinmaqa soon mokiwuy ep pítuni. ");
INSERT INTO hopNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ya um itanay Abraham epnihqe hak pas pávani? Pam pi pay qa qatu; pu God lavay’aymat piw qa yēse. Ya um hak hímunihqey nāmi wūwanta? ");
INSERT INTO hopNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Noqw Jesus lavayhtiqe paṅqawu: Kurs nu pay nāp nātsok̇ananiqw pay pam qa hihta hihk̇ay’tani; noqw pi Ina nuy tsok̇anaṅwu; noqw uma put aw yanyuṅqey paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Noqw pi uma put qa tuwi’yuṅwa; noqw nu put tuwi’ta; nihqe ōviy kurs nu put qa tuwi’taqey paṅqawe’, nu umún átsani; noqw pi nu put tuwi’taqe, put lavayiyat an hinma. ");
INSERT INTO hopNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Umuna Abraham iqatsiy aw yórikniqey put ep hahlayi; nihqe pam aw yórikqe hahlayhti. ");
INSERT INTO hopNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pahsat pu Jew‐sinom put aw paṅqaqwa: Um nāt qa lȫp sunat pakwt sihk̇ay’taqat yahsaṅwni’k̇aṅw, ya pay um Abraham aw yori? ");
INSERT INTO hopNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus amumi paṅqawu: Pas antsaa, pas antsa nu umumi paṅqawni: Nāt Abraham qa háqamniqw pay nu qatu, kita. ");
INSERT INTO hopNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pahsat pu puma put tatatupyaniqe o’wat ömahtota; noqw pay Jesus nauyhtaqe God kīyat aṅqw yámakqe pumuy amuhsonṅaqw hinmak̇aṅw paṅqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Noqw Jesus haqaminik̇aṅw, hakiy tāqat pas tihtiwhqey aṅqaqw qapostalqat aw tātayi. ");
INSERT INTO hopNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Noqw Jesus aw nánatuwnayaqam put tūviṅtotaqe aw paṅqaqwa: Tutuqaynaqa, ya hakiy qaanhtiqw, ōviy i’ qapostalk̇aṅw tihtiwa, sen ii, sen náata, sen yúata? ");
INSERT INTO hopNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Noqw Jesus paṅqawu: Pay i’ qa hakiy qaanhtipuyat ep pank̇aṅw tihtiwa, qa nāp qaanhtiqey ep’e, pu qa nay, yuy qaanhtipuyamuy ep’e; pi pay God tumalaat put ep mātaktiniqw ōviy pam pank̇aṅw tihtiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nāt tālö’niqw nu soon nuy aṅqw távihqat tumalayat qa tumalay’tani; taq mihikq soon hak tumalay’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nu nāt tūwaqatsit ep hinnumqe nu hapi sinmuy amumi tāla. ");
INSERT INTO hopNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yan pam lavayhtit, tutskwami tö́hakqe, tutsvalay akw tsöqataqe, put qapostalqat pōsiyat aṅhqe lelwi; ");
INSERT INTO hopNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nit put aw paṅqawu: Yupa, nen um patuphat Siloam aqw posimavaqtani, kita. (Siloam hōniwa, i’nihqe pam’i.) Noqw ōviy pam awnihqe, aqw posimavaqtaqe, tālat tayk̇aṅw ahoy pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Noqw ōviy kisṅwamat‐niqw pu haqawat put qapostalṅwuniqw aw yorstotaqam paṅqaqwa: Ya qa i’ haqam qátuk̇aṅw hihta tuṅlay’taṅwuqa? ");
INSERT INTO hopNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Noqw haqawat paṅqaqwa: Pay i’ pam’i; noqw pētu paṅqaqwa: Pay i’ put an sóniwa. Noqw pam tāqa paṅqawu: Pay nu’ pam’i. ");
INSERT INTO hopNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Noqw ōviy puma put tūviṅtotaqe aw paṅqaqwa: Noqw uhposi hin tālawva? ");
INSERT INTO hopNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Noqw pam lavayhtiqe paṅqawu: Pay hak tāqa Jesus yan mātsiwhqa tsöqataqe, ivosvaqe put lelwit, inumi paṅqawu: Um patuphat Siloam awnen, aqw posimavaqtani; noqw ōviy nu awnihqe posimavaqtaqe, ivosiy tālawna. ");
INSERT INTO hopNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pahsat puma put aw paṅqaqwa: Noqw pam hak háqamo? Noqw pam paṅqawu: Pīyi. ");
INSERT INTO hopNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pahsat pu puma qapostalṅwuqat Pharisee‐sinmuy amumi wikya. ");
INSERT INTO hopNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Noqw piw nasuṅwintalöṅnit ep Jesus tsöqataqe put pōsiyat tālawna. ");
INSERT INTO hopNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pahsat pu Pharisee‐sinom pam hin pōsiy tālawnaqat tuwat put tūviṅtota. Noqw pam pumuy amumi paṅqawu: Pam ivosiy aṅhqe tsöqat lelwi; noqw nu posimavaqtaqe, ivosiy tālawna. ");
INSERT INTO hopNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pahsat pu ōviy haqawat Pharisee‐sinom paṅqaqwa: Pay pi i’ tāqa qa pas God aṅq’ö, ōviy pi nasuṅwintalöṅnit qa k̇aptsi’ta. Noqw pētu paṅqaqwa: Pas soon hak qaanhinmak̇aṅw yanhaqam k̇ātutmalat hintsakni. Noqw yan puma nātsiki. ");
INSERT INTO hopNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pahsat pu puma qapostalṅwuqat aw piw paṅqaqwa: Ya uhposiy tālawnaqa uṅniqw hak hímuu? Noqw pam amumi paṅqawu: Pam God lavay’ayaata. ");
INSERT INTO hopNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Noqw as qapostalṅwuqa pōsiy tālawnaqat Jew‐sinom qa tūtuptsiwa. Noqw ōviy puma put nayat yuyat enaṅ wáṅwayyaqe, ");
INSERT INTO hopNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tūviṅtotaqe amumi paṅqaqwa: Ya pas pay i’ umuhti qapostalk̇aṅw tihtiwhqat uma paṅqawlawu? Noqw pam pantaṅwunik̇aṅw hin pu’ tālat tayta? ");
INSERT INTO hopNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Noqw put naat yuyat amum lavayhtiqe amumi paṅqawu: Pay pi i’ pas itahtinihqat itam navoti’ta, pu i’ qapostalk̇aṅw tihtiwhqata. ");
INSERT INTO hopNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nīk̇aṅw hin pi pam pu’ tālat taytaqw itam qa navoti’ta; piw hak put pōsiyat tālawnaqat itam qa navoti’ta; pi wūyoq’a; uma tūviṅtotani; pam pi nēṅem hin lavayhtini. ");
INSERT INTO hopNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Put naat yuyat amum Jew‐sinmuy mamqasqe ōviy yan lavayhti; yaw kurs hak Jesus pas Christ‐nihqat paṅqawhq, Jew‐sinom aw tōnawtaqamuy aṅqw put ayo tūvayaniqey pasiwni’yuṅqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Paniqw ōviy puma paṅqawu: Pay wūyoq’a, uma tūviṅtotani, kita. ");
INSERT INTO hopNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pahsat pu piw ōviy puma qapostalṅwuqat wáṅwayyaqe aw paṅqaqwa: Um God pas hihtatani; itam navoti’yuṅqw, i’ tāqa qaanhinma. ");
INSERT INTO hopNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Noqw pam lavayhtiqe paṅqawu: Pay k̇a pi as sen pam qaánhinma, sen pay qa panmaqw, nu put qa navoti’ta; pay it‐sa pi pas sūkw nu suyan navoti’ta, nu as ura qapostalṅwu, nīk̇aṅw nu pu’ tālat tayta. ");
INSERT INTO hopNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pahsat pu puma piw put aw paṅqaqwa: Ya pam uṅ hintsana? Hin pam uhposiy tālawna? ");
INSERT INTO hopNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Noqw pam lavayhtiqe amumi paṅqawu: Pay pi nu umuy āawnaqw uma qa nanapta. Ya uma hinoqw pas pu’ piw put nanaptaniqey nānawakna? Ya uma tuwat put aw tutuqayyaniqe ōviy’o? ");
INSERT INTO hopNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pahsat pu puma pas tutsíw’unaṅway hiṅqaqwaqe put aw paṅqaqwa: Um pi put aw tutuqayi, itam pi Moses aw tutuqayya. ");
INSERT INTO hopNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God pi pas suyan Moses aw yuaaykuqat itam navoti’yuṅwa; i’ pi pay hak tuwat háqaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Noqw tāqa lavayhtiqe amumi paṅqawu: Is uti pas as uma put háqaqwniqw qa navoti’yuṅqw, piw pam ivosiy tālawna. ");
INSERT INTO hopNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Noqw pi itam navoti’yuṅqw God qaanhinwisqamuy lavayiyamuy qa navotṅwu; pi hak haqam God k̇aptsi’k̇aṅw tunatyayat hinmaqw put pam navotṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hisat qatsit yayhniwhqat aṅqaqw qa hak haqam hakiy qapostalk̇aṅw tihtiwhqat posiyat tālawniqat itam navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Pi as i’ tāqa qa God aṅqwnen soon hihta hintsakni. ");
INSERT INTO hopNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Puma lavayhtotiqe aw paṅqaqwa: Pas as um qaanhtiput aṅ tihtiwk̇aṅw, ya pas piw um itamuy tutuqayna? kitotaqe put paṅqw ayo tūvaya. ");
INSERT INTO hopNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Noqw yaw put tūvayaqat Jesus navotqe put túwahqe aw paṅqawu: Ya um God Tiyat aw tuptsiwni’ta? ");
INSERT INTO hopNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Noqw pam lavayhtiqe aw paṅqawu: Ya pam hak’i, tāqa? Nu hakiy aw tuptsiwni? ");
INSERT INTO hopNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Noqw Jesus put aw paṅqawu: Pay um aw yori; noqw pam hapi ūmi yuaata. ");
INSERT INTO hopNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Noqw pam paṅqawu: Tutuyqawhqa, nu tuptsiwa; pam kitat put aw naokiwhta. ");
INSERT INTO hopNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Noqw Jesus paṅqawu: Nu hapi yep hin hintaniqat ōviy pew tūwaqatsit aw pitu, ima aṅ qa tayyuṅqam pōsiy tālawnayaniqat ōviy’o, pu aṅ tālat tayyuṅqam pōsiy qatālawnayaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Noqw haqawat Pharisee‐sinom put ámumyaqam īit nanaptaqe put aw paṅqaqwa: Noqw itam piw qapostalya? ");
INSERT INTO hopNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Noqw Jesus amumi paṅqawu: Pay pi as uma qapostalye’, soon qaanhtiput hinyuṅwni; noqw pi uma postalyaqey kitotaqw, ōviy umuhqaanhtipu umuhpe hūrsti. ");
INSERT INTO hopNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Pas antsaa, pas antsa nu umumi paṅqawni: Hak qa hötsíwhpa kanelkimi pakit, pay nāp haqe’ aqw pákihqa hapi uyiṅwuniṅwu, pu hakiy hihta tusoqnawhkilawhqaniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Hötsíwhpa pákihqa hapi kanelmuy tumalay’taqaniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Noqw hötsíwat aw tunatyawtaqa put aw hö́taṅwu, noqw kanēlom tönayat nanaptaṅwu; noqw pam pumuy túṅwniyamuy akw wáṅwaylawṅwu, nen pumuy paṅqw haqami tsamṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pu pam pokmuy nö́ṅakne’ amupyeve hinmaṅwu; noqw kanēlom tönayat tuwi’yuṅqe ōviy put aṅkyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nīk̇aṅw puma a’löṅtuy tönayamuy qa tuwi’yuṅqe ōviy hakiy alöṅöt qa aṅkyat, tuwat soq put apyeve watqaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yan Jesus tūwutsit aṅ pumuy amumi hihta mahtakna; noqw puma put hihta lavayhtiqat qa māmatsya. ");
INSERT INTO hopNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pahsat pu Jesus piw amumi paṅqawu: Nu hapi kanelkimiq hötsíwat anta. ");
INSERT INTO hopNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Inupyeve mohti ö́kihqam sohsoyam uuyiṅwtu, pu hihta tūnawhkilalwaqamu; noqw ikanelvohkom pumuy amumi qa tūqayyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nu hapi hötsíwa; inuhpa’ pákihqa hapi ayo yámakni, nen aw papkik̇aṅw pu piw aṅqw yaymak̇aṅw nȫsiwhqey tuway’numni. ");
INSERT INTO hopNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Pi uyiṅwu ūuyniksa pítuṅwu, pu hihta nīnaniksaa, pu hihta hovalaniksaa; noqw nu tuwat pumuy yesniqat ōviy pitu, puma nukṅwat qatsit qaöwíhinyuṅwniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nu hapi kanelmuy amumi suan tunatyawmaqa. Suan kanelmuy amumi tunatyawmaqa hapi pumuy amuṅem qatsiy táviṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Náwuspi i’ ayaiwtaqa, kanelmuy qa pokmuy’taqe amumi qa suan tumalay’taṅwu; nīk̇aṅw haqaqw kwéwuniqw put tuwe’, kanelmuy tatamhtat, wāyaṅwu; noqw kwewu kanelmuy qö́yaṅwu, pu piw tatslaknaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ayaiwtaqa wāyaṅwu, pam pi pay ahsatiy ōviyniṅwunihqe kanelmuy qa hin amumi tunatyawtaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nu hapi kanelmuy amumi suan tunatyawmaqa; nihqe nu ikanelvokmuy tuwimuy’ta; noqw ivokom nuy tuwi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Pas Ina nuy hin tuwi’taqw nu pan piw Inay tuwi’ta, nihqe nu ikanelvokmuy amuṅem iqatsiy távini. ");
INSERT INTO hopNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Pu nu piw nāt pētuy kanelmuy qa it kanelkit ep yesqamuy pokmuy’ta; pumuy nu soon qa tsamni, noqw puma itönay nanaptani; noqw puma sūp tōnawtaqw sūk̇a pumuy amumi tunatyawtani. ");
INSERT INTO hopNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Noqw nu hapi iqatsiy tave’ put ahoy kwúsuniqat ōviy Ina inumi unaṅway’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Soon hak nuy iqatsiy nawhkini, nu nāp put távini; nu put táviniqey aw öqalat pasiwta, pu nu put ahoy kwúsuniqey aw’i; yan hapi Ina imumi tutapta. ");
INSERT INTO hopNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Noqw yan it lavayit ep pay piw Jew‐sinom nātsiki. ");
INSERT INTO hopNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Noqw k̇aysiwhqam paṅqaqwa: Pam nukpanhikwsit akw tuyqawiwtaqe ōviy pas qa navoti’numa. Ya uma hinoqw aw tūqayyuṅwa? ");
INSERT INTO hopNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Noqw pētu paṅqaqwa: Nukpanhikwsit akw tuyqawiwtaqa qa yan yuaataṅwu. Ya sen nukpanhikwsi qapostalyaqamuy pōsiyamuy tālawnani? ");
INSERT INTO hopNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Noqw Jew‐sinom Jerusalem epeq ura hisat namat God kīyat powatotaqat éphaqam u’nantota, tö́möhaqamo. ");
INSERT INTO hopNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Noqw Jesus God kīyat ep haqam Solomon tuhööyat aṅ waynuma. ");
INSERT INTO hopNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Noqw Jew‐sinom put aw tsovaltiqe aw paṅqaqwa: Taay, ya hihsavohaqam itam ūmi a’nö wūwantotani? Kurs pay um pas Christ‐nen itamuy suyan put āawnani. ");
INSERT INTO hopNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Noqw Jesus amumi paṅqawu: Pay pi nu umuy āawnaqw uma qa tūtuptsiwa. Nu Inay tuṅwniyat aw yank̇aṅw īit tutmalat hintsakq, pam nuy hákiynihqat tuawi’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Noqw uma qa tūtuptsiwa, ispi uma qa nuhtum ikanelvohkomyaqee; pay pi nu ura umumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ikanelvohkom itönay nanaptaṅwu; noqw nu pumuy tuwimuy’ta; noqw puma inuṅk hinwisa. ");
INSERT INTO hopNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Noqw nu pumuy qatsit qaso’taqat huylawu; noqw soon puma hovalniwyani, piw soon hak pumuy imapqölṅaqw tusoq’ipwani. ");
INSERT INTO hopNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ina nuy pumuy máqahqa sohsokmuy amuhpenihqe pas pávani; noqw qa hak pumuy Inay mapqölṅaqw tusoq’ipwaniqey aw öqala. ");
INSERT INTO hopNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ina‐niqw pu nūu, itam sūk̇aa. ");
INSERT INTO hopNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pahsat pu Jew‐sinom put tatatupyaniqe pay piw o’wat ömahtota. ");
INSERT INTO hopNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Noqw Jesus lavayhtiqe amumi paṅqawu: Nu nihtiwtaqat lolmat tumalat Inay aṅqw umumi mahtakna. Noqw ya uma hihtawat tumalat ep nuy tatatupyani? ");
INSERT INTO hopNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Noqw Jew‐sinom put aw paṅqaqwa: Pay itam lolmat tumalat qa ép uṅ tatatupyani, pi um God qak̇aptsi’lavayhtiq’ö; pu um pay sínonik̇aṅw pas God‐nihqey paṅqawhqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Noqw Jesus amumi paṅqawu: Puyaw umuhtutavoy ep qa yan pey’ta: Nu paṅqawu: Uma pas hihtuya, yan’i? (Noqw pas soon tutuveni alöṅtini.) ");
INSERT INTO hopNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Noqw pep hapi pam hakimuy put lavayiyat ömahtotaqamuy pas hihtuyaqat amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Noqw hintaqw ōviy uma nuy qak̇aptsi’lavayhtiqat paṅqaqwa, nu Pas Hímunihqat Tiatnihqey lavayhtiqö’? Pi Ina pas nāp nuy supwataqe tūwaqatsit aw tavi. ");
INSERT INTO hopNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ason pi nuy qa Inay tumalayat hintsakq, uma nuy qa tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nīk̇aṅw kurs pay nu pas put hintsakq, nāmahin pi as uma nuy qa tūtuptsiwanik̇ahk̇aṅw uma hīhihta tumaltiwhqat tūtuptsiwani; nen Ina inuhpeniqw, pu nu put epnihqat uma māmatsye’ tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yantaqat ep pu as ōviy piw puma put ṅuayaniqey antotiqw, pam pumuy māyamuy aṅqw ayo yámakqe, ");
INSERT INTO hopNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jordan yupqöymi paṅsonihqe huruhti, ura John pay mohti kūyit akw tūtuvoylalawhqat paṅsoo. ");
INSERT INTO hopNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Noqw k̇aysiwhqam put aw ökiwtaqe nānami lavayta: John pi qa hihta k̇ātumalta; nīk̇aṅw John pi it tāqat hin lavayhtiqw pas pam sohsoy antsaa. ");
INSERT INTO hopNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Noqw pepeq k̇aysiwhqam put aw tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Noqw hak tāqa Lazarus yan mātsiwhqa Bethany kitsókit ep ki’ta, it Maryt‐nik̇aṅw pu qȫqayat Marthat kitsókiyamuy ep’e; noqw pam hak okiw tūtuyhti. ");
INSERT INTO hopNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(I’ Mary hapi put atsve hihta kwaṅwáhovaqtuqat wihkuyit akw Tutuyqawhqat lelwit, pu hȫmiy akw kukyat aṅ hȫna; noqw put tupkoat Lazarus tūtuya.) ");
INSERT INTO hopNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Paniqw ōviy put qȫqamat hakiy Jesus aw ayataqw, pam paṅqawu: Tutuyqawhqa, meh, pas aw uh’unaṅwa okiw tūtuya. ");
INSERT INTO hopNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Noqw Jesus put navotqe paṅqawu: I’ tūya put mokniqat qa pániq’ö, pi God pas a’nö hímuniwhtiniqat ōviy’o, noqw God Tiat put ahpiy pas pavan hímuniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Noqw Jesus Marthat aw unaṅway’ta, pu tupkoyat Maryt‐nik̇aṅw pu Lazarus pumuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Noqw ōviy pam put navotqe pay hāk pepeq lȫs talöṅna. ");
INSERT INTO hopNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nit it atsve pu’ pam put aw nánatuwnayaqamuy amumi paṅqawu: Tuma piw Judeat aqwya. ");
INSERT INTO hopNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Noqw puma put aw paṅqaqwa: Tutuqaynaqa, nāt pūnat pu’ Jew‐sinom uṅ tatatupninayaniqey anhtotiqw, ya um pay piw aqwni? ");
INSERT INTO hopNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Noqw Jesus lavayhtiqe paṅqawu: Ya talöṅvaqat ep tāwa aṅhqe qa pakwt lȫq sihk̇ay’tasikis qöniltiṅwu? Tālö waynumqa qa wíwakṅwu, pam qatsit aw tālat aw taymaṅwunihqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mihikq waynumqa hihta ep wíwakṅwu, put ep tāla súlawniṅwuniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yan pam lavayhtit amumi paṅqawu: Itahkwatsi Lazarus pūwi, noqw pay nu aqwnen tātaynani. ");
INSERT INTO hopNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Pahsat pu put aw nánatuwnayaqam put aw paṅqaqwa: Tutuqaynaqa, pay pi pūwe’ soon qa öqawhtani. ");
INSERT INTO hopNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Noqw pam mokqat Jesus paṅqawhq, suhpan as pay pam puwhqe nāsuṅwni’taqw put paṅqawhqat puma wūwaya. ");
INSERT INTO hopNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pahsat pu Jesus pumuy amumi pas suyan paṅqawu: Lazarus mōki. ");
INSERT INTO hopNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Noqw nu qa épeqniqw pam panhtiqw pas nu put ep umuṅem hahlayhti, uma nuy hinhtiniqat aw yórikye’ inumi tūtuptsiwaniqat ōviy’o. Pay itam aqwyani. ");
INSERT INTO hopNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pahsat pu Thomas, Didimus yan túṅwantiwhqa, suṅwámuy amumi paṅqawu: Itam amum aqwye’, amum so’ni. ");
INSERT INTO hopNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Noqw Jesus pepeq pituqw, pay kurs pam āmiwhqe, nālös talni’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Noqw Bethany Jerusalem áhayhpo, sukw aṅqw nāsamiq tutskwatuwanit pahsaphaqamo. ");
INSERT INTO hopNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Noqw Jew‐sinom k̇aysiwhqam Marthat pu Maryt pumuy tupkoyamuy ep pumuy qahahlayhpiyamuy ep amumi unaṅwtapyaniqe kurs ep öki. ");
INSERT INTO hopNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Noqw yaw Jesus aṅqwnihqat Martha navotqe, paṅqw nakwsuqe put ahsawva, noqw Mary pay nāt kiy ep qatu. ");
INSERT INTO hopNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pahsat pu Martha Jesus aw paṅqawu: Tutuyqawhqa, pas as um yepniqw soon itupko mokni. ");
INSERT INTO hopNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Noqw pay nu navoti’taqw nāmahin pi yahsathaqam um God aw hihta tūviṅtaqw soon pam uṅ qa máqani. ");
INSERT INTO hopNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Noqw Jesus put aw paṅqawu: Pay uhtupko ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Noqw Martha put aw paṅqawu: Antsa nu navoti’taqw nuhtuṅk talöṅvaqat epeq sinom ahoy yesvaniqw pam nuhtum ahoy tātayni. ");
INSERT INTO hopNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Noqw Jesus put aw paṅqawu: Nu hapi hakiy mokiwuy aṅqw ahoy tātaynaṅwuqa, pu qatsíhuytaṅwuqa; inumi tuptsiwhqa as nāmahin mokni, nīk̇aṅw pay pam qátuni. ");
INSERT INTO hopNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Pu hak qatuk̇aṅw inumi tuptsiwni’taqa pas soon hisat mokni. Ya um it tūptsiwa? ");
INSERT INTO hopNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Noqw pam put aw paṅqawu: Owi, Tutuyqawhqa, pay um pas Christ, God Tíatnihqat nu tuptsiwa; ura kurs pi pam hak tūwaqatsit aw pítuni. ");
INSERT INTO hopNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Yan pam lavayhtit ahpiynihqe tupkoy Maryt nauywaṅwayhqe aw paṅqawu: Tutuyqawhqa pitu, nihqe uṅ wáṅwaylawu. ");
INSERT INTO hopNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Noqw panis pam put navot suṅwnuptut, put aw’i. ");
INSERT INTO hopNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Noqw Jesus nāt kīmi qa pítuhqe, haqam Martha put ahsawvaqat pay nāt pep’e. ");
INSERT INTO hopNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Noqw Jew‐sinom Maryt amum ahpave taṅawk̇ahk̇aṅw put aw unaṅwtavi’yuṅqam put suṅwnuptut yámakmaqw aw tayyuṅqe aṅkya paṅqawk̇ahk̇aṅwo: Pam sumataq tūamit ep pakmumuyniqe ōviy paṅsoo, kitota. ");
INSERT INTO hopNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pahsat pu Mary nāt Jesus haqam wunuqw túwahqe aw pitu, nihqe put atpipo tamötswunuptut aw paṅqawu: Tutuyqawhqa, pas as um yepniqw soon itupko mokni. ");
INSERT INTO hopNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Noqw pam pakmumuyhq, pu Jew‐sinom put amum ö́kihqam piw tsaykitaqw Jesus amumi yórikqe unaṅwpeq ōkwavakqe, ");
INSERT INTO hopNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Paṅqawu: Uma haqam put taviya? Noqw puma paṅqaqwa: Tutuyqawhqa, um awnen aw tātayni. ");
INSERT INTO hopNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Noqw pahsat pu Jesus paklawu. ");
INSERT INTO hopNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pahsat pu Jew‐sinom paṅqaqwa: Meh, pas kurs aw unaṅway’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Noqw haqawat paṅqaqwa: Ya sen i’ qapostalqat pōsiyat tālawnaqa soon hinwat yukuqw soon as k̇a mokni? ");
INSERT INTO hopNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pu ōviy Jesus nāt qa suyan unaṅway’k̇aṅw tūamit aw pitu. Noqw tuhsöṅaqw tūamiwta, noqw aqw owa uhtsiwta. ");
INSERT INTO hopNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Noqw Jesus paṅqawu: Uma owat ayo taviyani. Noqw mokqat qȫqaat Martha put aw paṅqawu: Tutuyqawhqa, pay soon pi okiw qa hovaqtuni; pi pay nālös talöṅni’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Noqw Jesus put aw paṅqawu: Ya ura um tuptsiwe’, God öqalayat lolmat aw yórikniqat nu ūmi qa paṅqawu? ");
INSERT INTO hopNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pahsat pu mokpu haqe’ qatsqat aṅqw puma ayo owat taviya. Noqw Jesus ōmiq tātayht paṅqawu: Inaa, kwakwhay um nuy navota. ");
INSERT INTO hopNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Pay pi as um sutsep nuy navotṅwuniqw nu put navoti’ta; nīk̇aṅw pay ima sinom yaṅ hoṅqam um nuy aṅqw távihqat tūtuptsiwaniqw ōviy nu paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yan pam lavayhtit, pahsat pu a’nö paṅqawu: Lazarus, yámakuu! ");
INSERT INTO hopNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Noqw i’ mokqa paṅqw yama; noqw maat kukyat amum masyuwsit akw tōnaniwta, pu taywaat höhönpit akw nȫmiwta. Noqw Jesus pumuy amumi paṅqawu: Uma ṅahyat mātapyani. ");
INSERT INTO hopNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pahsat pu k̇aysiwhqam Jew‐sinom Maryt aw ökihqam Jesus hihta tumaltaqat aw tātayyaqe put aw tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Noqw pay pumuy amuṅaqw haqawat Pharisee‐sinmuy amumiyaqe, Jesus hīhihta tumaltaqat pumuy āawnaya. ");
INSERT INTO hopNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pahsat pu God awwat mohpeq momṅwit Pharisee‐sinmuy amumum yuaatotaniqe tsovalti, nihqe paṅqaqwa: Ya itam hinhtotini? pas hapi i’ tāqa hīhihta k̇ātutmalat hintsaki. ");
INSERT INTO hopNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Pas itam qa aw hintsatsk̇aqw, pam pantsakq kurs hin qa sohsoyam put aw tūtuptsiwani; noqw Rome aṅqw sinom ök̇e’ itahkiy kīqötotani, pu itamuy sinmuy haqami hintsatsnani. ");
INSERT INTO hopNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Noqw pumuy amuṅaqw haqawa Caiphas yan mātsiwhqa put yahsaṅwuy ep God awwat mohpeq moṅw’iwtaqe pumuy amumi paṅqawu: Uma qa hihta navoti’yuṅwa; ");
INSERT INTO hopNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Piw it aṅ qa wūwaya: Pay hak sūk̇a tāqa sinmuy amuṅem mokniniqw pam itamuṅem lomahintani. Noqw pep pu’ sinom soon pas sohsoyam súlawhtotini. ");
INSERT INTO hopNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pam qa nāp nahpiy yan lavayhti; nīk̇aṅw pam ephaqam God awwat mohpeq moṅw’iwtaqe hihta nātoniqat paṅqawu. Pam yan lavayhtiqe Jesus pep tutskwat ep sohsokmuy sinmuy amuṅem mokniqat aṅwu pay lavayhti; ");
INSERT INTO hopNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nīk̇aṅw pep tutskwat ep sinmuy qa púmuy‐sa amuṅem‐nit, pas sohsokmuy God tímuyatuy aṅqe’ ahtsavaliwyuṅqamuy piw amuṅem mokni, pam pumuy sohsokmuy sūmi tsovalaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pahpiy pu puma put hin nīnayaniqey nanawinya. ");
INSERT INTO hopNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Noqw ōviy Jesus Jew‐sinmuy amuhpa’ pāpu qa pas mātaqpuva hinnuma; nihqe pam paṅqw haqami kitsókit Ephraim yan mātsiwhqat aqw’a, tutskwat qayēwiwhpuve qalavoq’a. Nihqe pam put aw nánatuwnayaqamuy amumum pepeq qatu. ");
INSERT INTO hopNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Noqw Jew‐sinmuy nōviwhqaam Amutsva Yūmosanihqat yan túṅwantiwhqat aw pituto. Noqw nāto nōviwhqat aw qa pituqw, k̇aysiwhqam aṅ tutskwava yesqam napwatotaniqe Jerusalem ep öki. ");
INSERT INTO hopNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nihqe puma Jesus ōviy taynumyaqe God kīyat ep hoṅk̇ahk̇aṅw nānami paṅqaqwa: Ya uma hin wūwantota? Ya sen pam nōviwniqat qa awni? ");
INSERT INTO hopNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Noqw ima God awwat mohpeq momṅwit Pharisee‐sinmuy amumum put ṅuayaniqey anhtoti; nihqe ōviy kurs hak put háqamnihqat tuway’te’ paṅqawniqat pan yukuya. ");
INSERT INTO hopNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Noqw pu Amutsva Yūmosanihqat ep nōviwniqat aw navaysikis tālat pētiqw, Jesus Bethany ep pitu; pep Lazarus ura as mokqa qatu; ura Jesus put mokqat ahoy tātayna. ");
INSERT INTO hopNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Noqw Lazarus sinomat pep Jesus eṅem tapkiqw nōvatota; noqw Martha tūnopni’ta; noqw Lazarus nuhtum put amum tunösvoñat aw qatu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pahsat pu qȫqaat Mary wihkuyit kwaṅwáhovaqtuqat sūp tuwanit pan putu kwusut, Jesus kukyat lelwi, nit hȫmiy akw put kukyat hȫna. Pam wihkuyi nard yan túṅwantiwhqe a’nö hihk̇ay’ta. Noqw pam pantsakq kīve wihkuyit hovalaṅwuat tuyqawva. ");
INSERT INTO hopNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pahsat pu suhk̇a put aw nánatuwnaqa, momṅwituy amumi put mātapniqa, Judas Iscariot, it Simon tiat paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ya hinoqw tis nāpi kwaṅwáhovaqtuqa wihkuyi qa payhp sunat sīvat ōviy huyiwhqe ōokiwyaqamuy amumi qa noiwa? ");
INSERT INTO hopNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yan pam hiṅqawu, qa pas pi pas antsa ōokiwyaqamuy tunatyawk̇aṅwo, pi pam uyiṅwunik̇aṅw sivamokit aw tunatyawtaqe, hihta paṅsoq taṅatiwhq put kímaṅwuniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Noqw ōviy Jesus paṅqawu: Uma qa wuhtit aw hiṅqaqwani; pam nuy hisat tūamiwniqat aw it warani’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Himu pi aṅ ōokiwyaqam umumum sutsep yanyuṅwa; noqw pay nu qa sutsep umumum yantani. ");
INSERT INTO hopNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Noqw ōviy k̇aysiwhqam Jew‐sinom yaw Jesus pep qátuhqat nanapta; nihqe puma qa Jesus‐sa ōviy ep öki, puma it Lazarus ura pam mokiwuy aṅqw ahoy tātaynaqat aw yórikyaniqey ōviy pīwu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Noqw ōviy God awwat mohpeq momṅwit pay Lazarus piw enaṅ nīnayaniqey nānami yuaatota, ");
INSERT INTO hopNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Yaw put atsviy k̇aysiwhqam Jew‐sinom lasyaqe Jesus aw tūtuptsiwaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Noqw qavoṅvaqw sinom qaan’ewakw hintaqam nōviwhqat ep ökihqam yaw Jesus Jerusalem aw pitutoqat nanaptaqe, ");
INSERT INTO hopNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Puma palm‐tsotskit nantaqayat ūyitotaqe, pank̇ahk̇aṅw put ahsawvawisa paṅqawk̇ahk̇aṅwo: Öqawmaṅwu! Israel‐sinmuy moṅwíam Tutuyqawhqat natṅwaniyat aṅ pitutoqa pas k̇aptsitiwaa. ");
INSERT INTO hopNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Noqw Jesus mōrot puhuwuṅwiwtaqat túwahqe, epeq evetskilti; pi ura pan pey’ta: ");
INSERT INTO hopNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Uma qa tsawiniwyuṅwni, Zion ep sínomu; meh, umuhmoṅwi mōrot tiyat akw tsokiwmak̇aṅw aṅqw pituto, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Noqw put aw nánatuwnayaqam as mohti īit qa māmatsya; nīk̇aṅw Jesus a’nö hímuniwhtiqw pahsat pu puma ura pam yan pēniwhqat u’naya, pu yan put yukunayaqata. ");
INSERT INTO hopNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Noqw sinom put ámumyaqw pam tūamit aqw Lazarus wáṅwayhqe mokiwuy aṅqw ahoy tātaynaqw aw tayyuṅqam put tuawi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Paniqw ōviy sinom piw put ahsawvawisa, yaw pam it k̇ātumalat tumaltaqat nanaptaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Noqw ōviy Pharisee‐sinom nānami paṅqaqwa: Meh, itam qa hihta aniwni’wisa; sinom sohsoyam put aṅkya. ");
INSERT INTO hopNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Noqw hakim Greek‐sinom okiwlalwaniqe nuhtum nōviwhqat ep öki. ");
INSERT INTO hopNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nihqe puma Philip Galileet ep kitsókit Bethsaidat aṅqwnihqat aw ö́kihqe paṅqaqwa: Tāqa, itam as Jesus aw yórikyaniqey nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Noqw Philip Andrew awnihqe put āawna; noqw Andrew Philip amum Jesus put āawna. ");
INSERT INTO hopNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Noqw Jesus lavayhtiqe amumi paṅqawu: Nu Sinot Tiat pas hímuniwhtiniqat hapi aw pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Pas antsaa, pas antsa nu umumi paṅqawni: Pas söhövosi tutskwami qa pohse’, qa hovare’, sutsep sūk̇aniṅwu; pas pam hovare’, pep‐sa a’nö aniwnaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Qatsiy k̇ahk̇awnaqa put kwayhni; pu yep qatsit ep pas nāp qatsiy aw qa suhtaq’ewnihqa hapi qatsit qaso’taqat himuy’vani. ");
INSERT INTO hopNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Inuṅem tumalay’taniqey nāwaknaqa pas kurs hin qa inuṅkni, nen nuy háqamniqw itumal’aya piw pepni. Pu inuṅem tumalay’taqa Inay ahpiy k̇aptsi’tiwni. ");
INSERT INTO hopNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Pas nu hin unaṅwti. Ya sen nu hiṅqawni? Inaa, um it tuwanit aṅqw nuy ayo távini, sen nu kítani? Noqw pi nu yaniqw it tuwanit aw pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Inaa, um pas hímunihqey namtaknani, nu kítani. Pahsat pu ōveqatsit aṅqw hakiy tönaat paṅqawu: Nu pas hímunihqey pay namtakna, nihqe nāt nu piw panhtini. ");
INSERT INTO hopNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Noqw ōviy sinom pep hoṅqam put nanaptaqe úmukqat paṅqaqwa; noqw haqawat paṅqaqwa: God hoṅviayaat put aw yuaayku, kitota. ");
INSERT INTO hopNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Noqw Jesus lavayhtiqe paṅqawu: I’ hakiy tönaat qa inuṅem töqti, pi umuṅem’i. ");
INSERT INTO hopNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pu’ hapi it qatsit tunatyayat aṅ hinwisqamuy amuṅem hin yukiltini; pu’ hapi yep qatsit aw moṅwi ayo tūviwni. ");
INSERT INTO hopNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Noqw nūu, ason nu nahoylehtsit ep hāyiwe’, nu sinmuy sohsokmuy nāmi tsovalani. ");
INSERT INTO hopNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yan pam hin mokniqey lavayhtiqe paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Noqw sinom lavayhtotiqe put aw paṅqaqwa: Pi itam tutavot aṅqw nanaptaqw yaw Christ sutsep qátuni; noqw hinoqw Sinot Tiat pas kurs hin qa nahoylehtsit ep hāyiltiniqat um paṅqawu? Ya i’ Sinot Tiat hak hímuu? ");
INSERT INTO hopNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Pahsat pu Jesus pumuy amumi paṅqawu: Pay nu tālat ank̇aṅw umumum hihsavo yantani; nāt tālat umumum yantaqw uma kwilalatotani, noqw qatāla umuy qa wihkini; taq qatalpuva kwilalataqa haqaminihqey qa navoti’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nu nāt umumum yantaqw uma inumi tūtuptsiwe’, talpuva hinwisni; nen uma tālat ep sinoiwyuṅwni. Yan Jesus lavayhtit ahpiynihqe pumuy amuṅaqw nātupk̇a. ");
INSERT INTO hopNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Noqw pay as pi nāmahin pam pumuy amutpik nihtiwtaqat hihta k̇ātumalat mahtaknaqw puma put aw qa tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yan God lavay’ayaat Esaias hin lavayhtiqat aw antsaniwa. Ura pam paṅqawu: Tutuyqawhqa, ya hak itahtuawiy tuptsiwa? Ya Tutuyqawhqa hakiy aw öqalay mahtakna. ");
INSERT INTO hopNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yanta; noqw ōviy soon put tūtuptsiwani, ura Esaias piw paṅqawhq ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Pam pumuy pōsiyamuy qatālawna, pu pumuy unaṅwayamuy owata, taq k̇a puma pōsiy akw tutwak̇ahk̇aṅw, pu unaṅway akw māmatsye’, ahoy nánamtökyaqw, nu pumuy qalaptsinani. ");
INSERT INTO hopNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yan ura Esaias lavayhti God pitsáṅwayat lolmat aw yórikqee, nihqe put hakiy lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Noqw pay as pi nāmahin yantaqw pay imuy mohpeq momṅwituy amuṅaqw k̇aysiwhqam nuhtum put aw tūtuptsiwa; nīk̇aṅw pay Pharisee‐sinmuy amutsviy put qa paṅqaqwa, hakton sen puma tsotsvakikimi pumuy amumi uhtayaniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Puma pi sinmuy amuṅaqw tayawinpit nānawaknaqe, God aṅqw tayawinpit qa hihtatota. ");
INSERT INTO hopNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Noqw pu’ Jesus tsa’lawhqe paṅqawu: Inumi tuptsiwni’taqa hapi qa inumi tuptsiwni’tat, hakiy aṅqw nuy távihqat aw tuptsiwni’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Pu inumi taytaqa hapi nuy aṅqw távihqat aw tayma. ");
INSERT INTO hopNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nu tāla sinmuy amumi pitu, inumi tuptsiwni’taqa haqe’ qatālat qa aṅ hinmaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nu sinmuy amuṅem hin yukunaniqe qa paniqw pew pitu, pi nu sinmuy ayo óyaniqe pitu. Nihqe ōviy nāmahin pi hak ilavayiy navotk̇aṅw put qa tuptsiwhq nu qa put hinwat yúkuṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Hak nuy qa nakwhak̇aṅw ilavayiy qa ömahtaqa hihta akw hinwat yukuniwni. Ilavayi hapi so’ṅwamiq put hin yukunani. ");
INSERT INTO hopNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Pi nu qa nāp nahpiy yuaata. Ina nuy aṅqw távihqa hapi pas nāp nuy hihta hiṅqawniqat inumi tutapta, pu hihta hin lavayhtiniqat pīwu. ");
INSERT INTO hopNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Noqw nu navoti’taqw Ina hihta tutaptaqe sinmuy qatsit qaso’taqat himuy’vayaniqat ōviy put tutapta. Noqw paniqw hapi ōviy pam inumi hin tutaptaqat nu panwat sohsok yuaayku. ");
INSERT INTO hopNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Noqw Amutsva Yūmosanihqat ep nōviwniqat nāt aw qa pituqw, Jesus yep it qatsit aṅqw Nay awniqey navoti’ta; nihqe sinomat it qatsit ep hinnumyaqamuy amumi unaṅway’taqe pam yūmosa so’ṅwamiq pumuy amumi unaṅway’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Noqw tapkiqw pumuy nȫnösaqw, Nukpana Simon tiyat Judas Iscariot Jesus momṅwituy amumi mātapniqat pan unaṅwtoyna. ");
INSERT INTO hopNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Noqw Jesus navoti’taqw, Naat sohsok hihta aw öqalat put aw noa; noqw pam God aṅqw pítuhqe piw God aw áhoyniqey navoti’k̇aṅw, ");
INSERT INTO hopNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tunösvoñat aṅqw wunuptut, napnay tavi; nit höhönpit kwusut, put kwewhta; ");
INSERT INTO hopNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nit pu tsaqaptat aqw kuyht, pahsat pu put aw nánatuwnayaqamuy kukyamuy pāhomhtivat, nihqe höhönpit kwewhtaqey akw kukyamuy hönhta. ");
INSERT INTO hopNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pu ōviy pam Simon Peter aw pituqw, Peter put aw paṅqawu: Tutuyqawhqa, ya pas pay um ikukuy pāhomni? ");
INSERT INTO hopNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Noqw Jesus lavayhtiqe aw paṅqawu: Pay nu hihta hintsakq um nāt qa mātsi’ta; pay ason um soon qa māmatsni. ");
INSERT INTO hopNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Noqw Peter put aw paṅqawu: Pay um pas soon hisat ikukuy pāhomni. Noqw Jesus put aw paṅqawu: Pas nu uhkukuy qa pāhomqw pay nawus um qa isinoni. ");
INSERT INTO hopNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter put aw paṅqawu: Tutuyqawhqa, turs qa ikukuy‐sa‐nit imay iqötoy enaṅ pīw um pāhomni. ");
INSERT INTO hopNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Noqw Jesus put aw paṅqawu: Pay pāhom’iwhqa soon pas sohsovik pāhom’iwni, pay kuk’at‐sani, pi pay sohsovik kwaṅw’eway’o. Noqw uma hapi kwaṅw’e’wayomu, nīk̇aṅw pay qa sohsoyamu. ");
INSERT INTO hopNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Pam hakiy momṅwituy amumi put mātapniqat navoti’taqe ōviy paṅqawu: Uma qa sohsoyam kwaṅw’e’wayomu, kita. ");
INSERT INTO hopNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pu ōviy pam pumuy kukyamuy pāhomt, pu napnay aṅ pakit, pu qatuptut, amumi paṅqawu: Ya nu umuy hintsanqat uma māmatsya? ");
INSERT INTO hopNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Uma nuy Tutuqaynalalwak̇ahk̇aṅw pu Tutuyqawhqalalwa; nihqe uma súaṅqaqwa, pi nu’ pam’i. ");
INSERT INTO hopNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Noqw kurs nu umumi tutuyqawhqa, pu umuy tutuqaynaqa umuhkukuy pāhomqw, soon tis uma umuhkukuy nāhoy qa nāvahomnayamantani. ");
INSERT INTO hopNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Pi nu umuy hinyaniqat umumi mahtakna, nu umuy hin yúkunaqw pan uma hinwisni. ");
INSERT INTO hopNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Pas antsaa, pas antsa nu umumi paṅqawni: Pay tūwiki moṅwiy epnihqe qa pavan pasniṅwu, pu ayatiwhqa put ayataqat epnihqe qa pavan pasniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Noqw uma īit navoti’k̇ahk̇aṅw aṅ hinwise’ hahlayyani. ");
INSERT INTO hopNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nu umuy qa sohsokmuy lavayhti; nu hakimuy namorstaqey tuwimuy’ta. Noqw pay pi tutuvenit anhtiniqw ōviy i’ hak inumum tūmoytaqa inumi nukpanhtini. ");
INSERT INTO hopNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Noqw nāt put qa aw pituqw nu aṅwu pay umuy āawna. Noqw hisat put paniwhtiqw, nu Christ‐nihqat uma tuptsiwyani. ");
INSERT INTO hopNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Pas antsaa, pas antsa nu umumi paṅqawni: Ason nu hakiy haqami ayataqw, hak put pās távihqa hapi nuy pās távini; pu nuy pās távihqa hapi nuy aṅqw távihqat pās távini. ");
INSERT INTO hopNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yan Jesus lavayhtit, qahahlayhtiqe paṅqawu: Pas antsaa, pas antsa nu umumi paṅqawni: Uma haqawa momṅwituy amumi nuy mātapni. ");
INSERT INTO hopNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pahsat pu put aw nánatuwnayaqam haqawat pa pam paṅqawhqat wūwantotaqe nānahpa’ yoyrikya. ");
INSERT INTO hopNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Noqw suhk̇a put aw nánatuwnaqa pep Jesus tawitsqayat aw tahtsikiwta, pas Jesus aw unaṅwaata. ");
INSERT INTO hopNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Noqw Jesus hakiy paṅqawhqat pam put tūviṅtaniqat Simon Peter put aw māmasa. ");
INSERT INTO hopNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pu ōviy pam Jesus tawitsqayat aw tahtsikiwk̇aṅw put aw paṅqawu: Tutuyqawhqa, ya hakni? ");
INSERT INTO hopNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus hu’waqe aw paṅqawu: Pay nu nōvat móroknat, hakiy put maqaqw pamni. Pu pam nōvat móroknaqe, Simon tiyat Judas Iscariot put maqa. ");
INSERT INTO hopNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Noqw pam panhtiqw, pahsat pu Satan put unaṅwmiq paki. Noqw pahsat pu Jesus put aw paṅqawu: Um hihta hinhtiniqey īts panhtini. ");
INSERT INTO hopNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Noqw qa haqawa tunösvoñat aw qátuhqa put hinoqw pan lavayhtiqat māmatsi. ");
INSERT INTO hopNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas pi sivamokit tavi’ta; noqw suhpan pam pumuy nōviwhqat ep hihta hinhtotiniqat Jesus put aw paṅqawhqat haqawat wūwaya, pu sen pam ōokiwyaqamuy hihta huytaniqat paṅqawhqata. ");
INSERT INTO hopNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Noqw ōviy pam nōvat mórokput sowat, pahsat pay paṅqw yama. Noqw míhikiwta. ");
INSERT INTO hopNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pu ōviy pam yámakmaqw, Jesus paṅqawu: Pu’ hapi nu’ Sinot Tiat pas pavan hímuniwhtini; noqw God piw inuhpiy panhtini. ");
INSERT INTO hopNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Noqw kurs God inuhpiy hímuniwhte’, pay soon pam tuwat qa nahpiy nuy pas pavan hihtatani; nihqe soon qa pay put panhtini. ");
INSERT INTO hopNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Itimu, nāt nu hihsavo umumum yantani. Noqw uma as nuy hepyani; noqw ura nu Jew‐sinmuy amumi hin lavayhtiqe pay nu hapi piw pan umumi lavayhtini: Nuy haqaminiqw soon uma paṅsoyani, ura nu kita. ");
INSERT INTO hopNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nu umumi pūhut tutaptani: Uma nānami unaṅway’yuṅwni; nu umumi hin unaṅway’taqat pan piw uma nānami unaṅway’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Umuy nānami unaṅway’yuṅqw pantaqat ahpiy sinom sohsoyam uma inumi nánatuwnayaqat nanaptani. ");
INSERT INTO hopNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter put aw paṅqawu: Tutuyqawhqa, ya um haqamii? Jesus lavayhtiqe aw paṅqawu: Pay nuy haqaminiqw um kurs hin nāt inuṅkni; nīk̇aṅw pay ason um soon qa inuṅkni. ");
INSERT INTO hopNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter put aw paṅqawu: Tutuyqawhqa, ya hinoqw nu soon pay pu’ uṅkni? Nu uṅem iqatsiy táviniqey suhtaq’ewa. ");
INSERT INTO hopNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus lavayhtiqe aw paṅqawu: Haw um inuṅem uhqatsiy táviniqey suhtaq’ewa? Pas antsaa, pas antsa nu ūmi paṅqawni: Pay ason pas um nuy qa tuwi’taqey pāyis paṅqawhq pu’ taqákowāko töqtini. ");
INSERT INTO hopNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Uma qa hin unaṅway’yuṅwni, uma God aw tuptsiwni’yuṅwa; uma piw inumi tuptsiwni’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Inay kīyat ep yeyespi qaöwíewa, pi as qa pantaqw soon nu umuy qa āawnani. Nu umuṅem qenitato. ");
INSERT INTO hopNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Noqw nu ahpiynen umuṅem qenite’, nu piw aṅqwni; nen umuy nāmi ökínani; noqw nuy háqamniqw uma piw pepyani. ");
INSERT INTO hopNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Pu nuy haqaminiqw uma navoti’yuṅwa; pu uma aqw pöhut tuwi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas put aw paṅqawu: Tutuyqawhqa, um haqaminiqw itam qa navoti’yuṅwa; noqw ya itam hin aqw pöhut tuwi’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Noqw Jesus put aw paṅqawu: Nu hapi God aqw pöhu, pu navoti pas antsanihqa, pu qatsi. Soon hak Inay awni, pas inuhpanen‐saa. ");
INSERT INTO hopNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pi as uma nuy tuwi’yuṅwe’ soon uma Inay piw qa tuwi’yunwni; noqw yahpiy haqahpiy uma put tuwi’yuṅwa; nihqe uma aw yórikya. ");
INSERT INTO hopNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Noqw Philip put aw paṅqawu: Tutuyqawhqa, um Unay itamumi mahtaknaqw itam paṅso uyiwaltotini. ");
INSERT INTO hopNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Noqw Jesus put aw paṅqawu: Pas as nu wūyavo umumum yantaqw, ya um nāto nuy qa tuwi’ta, Philip? Inumi yórikqa hapi Inay aw yori; noqw piw um nuy umumi Inay mahtaknaniqat inumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ya nu Inay amum sūk̇anihqat um qa tuptsiwa? Soñawnen pi nu put epniqw pu pam inuhpee. Nu umumi hihta lavayhte’, qa nāp nahpiy lavayhtiṅwu; pi Ina inuhpe qátuhqa tumalat hintsaki. ");
INSERT INTO hopNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nu Inay epniqw pu Ina inuhpenihqat uma tūtuptsiwani; hal kurs uma qa pantotinik, ṅas’ew uma itumalay ahpiy inumi tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Pas antsaa, pas antsa nu umumi paṅqawni: Inumi tuptsiwhqa nuy hīhihta hintsakqat piw hintsakni, pu īit epnihqe pas pávanyaqat pam hintsakni, nu Inay awniniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pu uma ituṅwniy aw yank̇ahk̇aṅw nāphihta ōviy tūviṅtotaqw, nu put panhtimantani; noqw Ina Tiy ahpiy pas pavan hímuniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Uma ituṅwniy aw yank̇ahk̇aṅw nāphihta ōviy tūviṅtotaqw nu put panhtimantani. ");
INSERT INTO hopNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kurs uma inumi unaṅway’yuṅwe’, itutavoy aṅ hinwisni. ");
INSERT INTO hopNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pu nu Inay aw nāwaknani, noqw piw pam sukw umumi unaṅwtavi’taqat umumi távini, it Qahováriwtaqat Hikwsita. Noqw pam umumum sutsep yante’, ");
INSERT INTO hopNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Umuy hihta pas antsanihqat tutuqaynani. Put hapi ima yep qatsit tunatyayat aṅ hinwisqam kurs hin kwusuyani, puma put qa tuway’yuṅqe ōviy’o, piw qa tuwi’yuṅwa. Noqw uma pi put tuwi’yuṅwa, pam umumum yantaqw ōviy’o, nihqe nāt pam umuh’unaṅwpeq qátuni. ");
INSERT INTO hopNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Pay nu soon umuy nal’oyni; pay nu nāt piw aṅqw umumini. ");
INSERT INTO hopNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nāt hihsavoniqw pay yep qatsit tunatyayat aṅ hinwisqam inumi qa yórikyani, nīk̇aṅw uma inumi yórikyani. Pi nuy qatuqw ōviy piw uma yesni. ");
INSERT INTO hopNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Noqw pep pu’ uma nuy Inay epnihqat nanaptani; pu pan piw uma inuhpeyani, pu nu umuhpeni. ");
INSERT INTO hopNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Itutavoy oyi’k̇aṅw aṅ hinmaqa hapi inumi unaṅway’tani; pu inumi unaṅway’taqat aw Ina unaṅway’tani; noqw nu put aw unaṅway’tani, nen aw namtaknani. ");
INSERT INTO hopNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Noqw suhk̇a Jesus aw nánatuwnaqa Judas yan mātsiwa. Qa pam momṅwituy amumi Jesus mātavi. Noqw pam Jesus aw paṅqawu: Tutuyqawhqa, ya hintaqw ōviy um itamumi namtaknat, yep qatsit tunatyayat aṅ hinwisqamuy amumi qa namtaknani? ");
INSERT INTO hopNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Noqw Jesus lavayhtiqe put aw paṅqawu: Pay inumi unaṅway’taqa soon ilavayiy qa aṅ hinmani; noqw Ina put aw unaṅway’tani; noqw itam put awnen unaṅwayat ep qátuni. ");
INSERT INTO hopNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Inumi qa unaṅway’taqa hapi soon ilavayiy aṅ hinmani. Noqw nu umumi lavayit yuaataqw pam qa inuhpiy’o, pam nuy aṅqw távihqat Inay ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Noqw nu nāt umumumnik̇aṅw īit umumi yuaayku. ");
INSERT INTO hopNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Noqw nu pan Inay aw nāwaknaqw, pam umumi unaṅwtavi’taqat Qahováriwtaqat Hikwsit umumi távini. Noqw pam umuy sohsok hihta tutuqaynani; nen nuy hihta umumi lavayhtiqat umuy sohsok ahoy u’nanani. ");
INSERT INTO hopNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Uma suyan unaṅway’yuṅwni, nuy suyan unaṅway’taqat pan’i. Yep qatsit tunatyayat hinwisqam hakiy suyan unaṅway’taqat paysoq lavaytaṅwu; noqw nu qa panwat umumi yuaata. Uma qa hin unaṅway’yuṅwni, piw umuh’unaṅwa qa tsawiniwyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Uma nanaptaqw ura nu umumi paṅqawu: Nu ahpiynit piw aṅqw umumini. Pi uma inumi unaṅway’yuṅwe’ soon inumum qa hahlayhtotini, nu Inay awniqey paṅqawhqat ep’e, pi Ina inuhpenihqe pas pávani. ");
INSERT INTO hopNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Noqw nāt hapi aw qa pituqw, pay nu aṅwu umuy āawna, hisat aw pituqw uma tūtuptsiwaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yahpiy hapi nu pāpu soon pas umumi yuaatani, taq Nukpana, yep qatsit ep moṅw’iwtaqa aṅq’ö, noqw pam qahaqam hihta ep inumi tuyqawi’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Noqw Ina inumi hin tutaptaqw nu pan hinma. Noqw put pantaqat akw yep qatsit tunatyayat aṅ hinwisqam nu Inay aw unaṅway’taqat nanaptani. Huvam hoṅvaa; itam yaṅqw ahpiyyani. ");
INSERT INTO hopNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nu hapi ovauyit pas antsanihqat anta, Noqw Ina hapi ūyi’taqa. ");
INSERT INTO hopNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Inuhpiy hohtakiwtaqa qa hímuy’vaṅwuqat pam ayo túkuṅwu; pu pölöy’vaṅwuqat pam papsiṅwu, noqw pahsat pu pam wūhaq aniwnaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Noqw uma hapi it lavayit nu umumi lavayhtiqat akw kwaṅw’e’way’iwyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Uma inumi wiwyuṅwni, noqw nu umumi wiwtani; soon ovauyit ahpiy hohtakiwtaqa nāp natsviy hihta himuy’vaṅwu, pas pam kopölvuy aw wiwte’sa hihta aniwnaṅwu; noqw pan hapi uma inumi qa wiwyuṅwe’, soon hihta aniwnayani. ");
INSERT INTO hopNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nu hapi ovauyi; noqw uma hapi ahpiy hohtakiwyuṅqamu. Nu hakiy aw wiwtaqw pam inumi wiwte’ a’nö himuy’vamantani; pi uma qa inutsviye’, soon hihta apitotini. ");
INSERT INTO hopNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Inumi qa wiwtaqa lakput hohtakiwtaqat an ayo tūviwṅwu; noqw sinom put tsovalaye’, qȫhit aqw maspaye’, put taqtsokyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kurs uma inumi wiwyuṅwe’, piw ilavayiy umuh’unaṅwpeq pani’yuṅwe’, pep pu’ uma hihta nānawakne’, put ōviy tūviṅtotamantani; noqw pam umumi antsaniwmantani. ");
INSERT INTO hopNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Uma a’nö aniwnaye’, yan Inay pas pavan mātaktotani; pu piw yan uma pas antsa inumi nánatuwnayaqamyani. ");
INSERT INTO hopNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nu hapi pas Inay inumi hin unaṅway’taqat pan nu umumi unaṅway’ta; uma suan hinwisq nu umumi unaṅway’tani. ");
INSERT INTO hopNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Uma itutavoy aṅ hinwisq pan nu umumi unaṅway’tani, pas nu Inay tutavoyat aṅ hinmaqw pam inumi unaṅway’taqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Noqw uma pas hinhaqam hahlayhtotiniqat ōviy nu umumi yan lavayhti; nu pas hinhaqam hahlayhtiqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Noqw nu yan umumi tutaptani: Uma nānami unaṅway’yuṅwni, pas nuy hin umumi unaṅway’taqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kurs hak tāqa kwatsmuy amuṅem qatsiy tave’ suyan pi pam pumuy amumi pas pavan unaṅway’taqe ōviy panhtini. Noqw qa hak put tāqat epnihqe pas pavan nuhtumi unaṅway’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Uma nuy umumi hin tutaptaqat aṅ hinwise’ ikwátsimyani. ");
INSERT INTO hopNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yahpiy hapi nu pāpu umuy qa tūwiktuṅwantani, taq tūwiki moṅwiy hihta hintsakq put qa navoti’taṅwu. Nīk̇aṅw nu umuy ikwátsimyaqat pan túṅwanta; pi nu Inay aṅqw hihta navotqey umuy sohsok āawna. ");
INSERT INTO hopNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Qa uma hapi nuy namorstota, pi nu hapi umuy namorstaqe umuy sinmuy tsovalayaniqat ōviy ayata; noqw tsovalniwyaqam qa hovalniwyani; noqw uma ituṅwniy aw yank̇ahk̇aṅw Inay aw hihta tūviṅtotaqw pam umuy put máqamantani. ");
INSERT INTO hopNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nu umumi yan tutaptani: Uma nānami unaṅway’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kurs yep qatsit tunatyayat aṅ hinwisqam umumi qa suhtaq’ewyaqw pay ura puma inumi mohti qa suhtaq’ewyaqat uma u’ni’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pi as uma yep qatsit tunatyayat aṅ hinwisq, pay put aṅ hinwisqam soon umuy qa hahlayyani; noqw uma pi yep qatsit tunatyayat qa aṅ hinwisq nu umuy put aṅqw namorsta; noqw ōviy yep qatsit tunatyayat aṅ hinwisqam umumi qa suhtaq’ewya. ");
INSERT INTO hopNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ura nu umumi lavayhtiqw uma put u’ni’yuṅwni; pay tūwiki moṅwiy epnihqe qa pavan pasniṅwu; noqw kurs sinom nuy okiwsasne’ soon umuy piw qa okiwsasnani; kurs ilavayiy aṅ hinwise’ pay soon piw umuhlavayiy qa aṅ hinwisni. ");
INSERT INTO hopNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nīk̇aṅw pay uma isinomniqw ōviy puma umuy yan hintsatsnani, nuy aṅqw távihqat qa tuwi’yuṅqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Pay nu pítuhqe pumuy amumi yuaaykuqw puma inumi qa tuptsiwyaqe qaanhtoti. Kurs puma ilavayiy qa nanapte’ pay soon pas qaanhtotini. Nihqe pu’ hapi puma kurs hihta akw qaanhtipuy tupk̇ayani. ");
INSERT INTO hopNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Inumi qa suhtaq’ewnihqa hapi piw Inay aw qa suhtaq’ewa. ");
INSERT INTO hopNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nu pumuy amutpik nihtiwhtaqat k̇ātutmalat hinhti. Qa hak inuhpenihqe hihta k̇ātumalta. Kurs puma itutmalay aw qa yórikye’ pay soon pas qaanhtotini; noqw pi as puma put aw yórikyak̇ahk̇aṅw inumi qa suhtaq’ewya, pu Inay piw aw’i. ");
INSERT INTO hopNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ura pumuy tutuveniyamuy aṅ yan pey’ta: Nuy qa hinhtiqw puma inumi qa suhtaq’ewya, yan’i. Noqw puma hin pey’taqat anhtoti. ");
INSERT INTO hopNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nīk̇aṅw ason nu umumi unaṅwtavi’taqat Qahováriwtaqat Hikwsit Inay aṅqw ayataqw, pam hihta pas antsanihqat umuy tutuqaynat, nuy hákiynihqat sinmuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pu uma piw pas nāp hihta aw yórikyaqey tuawi’yuṅwni, uma yayhniwhqat aṅqaqw inumum hinnumyaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Uma qa hin unaṅwtotiniqat ōviy nu umumi yan lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nāt sinom hihta aw tōnawyuṅqey aṅqw umuy ayo ipwayani; tis pi nāt ōviy puma umuy qöqyaniqat aw pítuni; noqw panhtiqa God eṅem tumaltaqey wūwamantani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Puma hapi Inay nuy enaṅ qa tuwi’yuṅqe ōviy umuy panhtotini. ");
INSERT INTO hopNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nīk̇aṅw ason hisat aw pituqw ura nu umuy aṅwu pay put āawnaqat uma u’nayaniqw ōviy nu umumi yan lavayhti, náwuspi nāt nu umumumnihqe ōviy qa mohtihaq umumi īit yuaayku. ");
INSERT INTO hopNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Noqw pu’ hapi nu Inay nuy aṅqw távihqat ahoy awni. Noqw uma qa haqawat nuy haqaminiqat tūviṅta. ");
INSERT INTO hopNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Noqw pay pi nu umumi īit lavayhtiqw ōviy umuh’unaṅwa pas qa hahlayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Noqw pay nu umumi pas qaatsat paṅqawni: Pas nuy ahpiyniniqw pam umuṅem lomahintani; pi nuy qa ahpiyniqw umumi Unaṅwtavi’taqa soon umumi pítuni, pi nu ahpiyen aṅqw put umumi távini. ");
INSERT INTO hopNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ason pam pite’ yep qatsit tunatyayat aṅ hinwisqamuy qaanhtotiqat pumuy navotnani, pu hakiy hin suan hinmaqat pumuy māmatsnani, pu God sinmuy hin yukunaniqat amumi mahtaknani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pam pumuy inumi qa tuptsiwyaqe qaanhtotiqat pumuy navotnani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Piw nuy suan hinmaqat pumuy māmatsnani, Inay awnihqat akw’a; noqw uma pāpu inumi qa yórikyani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Piw God sinmuy hin yukunaniqat amumi mahtaknani, pi pam yep qatsit aw moṅwit pay eṅem yúkuqe pas qahihtata. ");
INSERT INTO hopNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nāt nu nihtiwhtaqat hihta umumi yuaaykuniqw, uma kurs hin nāt put sohsok ömahtotani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nīk̇aṅw ason i’ Hikwsi pas antsanihqa pite’, pam sohsok antsanihqat umuy māmatstoynani; pam qa nāp nahpiynihqat yuaataniqee. Pam hihta navote’ put yuaaykumantani, pu pam hīhihta nātoyaniqat umuy āwintani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ason pam nuy pas pavan hihtatani, pi pam itutuqayhpiy ömahtat, put umuy āwintani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Inay tutuqayhpiat sohsoy piw itutuqayhpi, paniqw ōviy nu paṅqawu: Pam ason itutuqayhpiy ömahtat, put umuy āwintani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nāt hihsavoniqw pay uma inumi qa yórikyani, pu piw pay hihsavoniqw uma inumi yórikyani, nu Inay awniniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Pahsat pu put aw nánatuwnayaqam haqawat nānami paṅqaqwa: Ya sen pam hihta itamumi lavayhtiqe paṅqawu: Nāt hihsavoniqw pay uma inumi qa yórikyani, pu piw pay hihsavoniqw uma inumi yórikyani, pu Nu Inay awniniqw ōviy’o, kita? ");
INSERT INTO hopNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Noqw ōviy puma paṅqaqwa: Ya sen pam hihta paṅqawhqe Hihsavoniq’ö, kita? Itam hihta paṅqawhqat aw māmatsya. ");
INSERT INTO hopNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Noqw puma as put tūviṅtotaniqey nānawaknaqw Jesus navoti’taqe amumi paṅqawu: Ya nu umumi Pay hihsavoniqw uma inumi qa yórikyani, pu piw pay hihsavoniqw uma inumi yórikyani, kítahqat uma nātuviṅlalwa? ");
INSERT INTO hopNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Pas antsaa, pas antsa nu umumi paṅqawni: Nāt uma tsaykitani, pu pas hihta ep qahahlayhtotiqey pan hiṅqaqwani; noqw tuwat yep qatsit tunatyayat aṅ hinwisqam hahlayyani, noqw úmawat qahahlayyani; nīk̇aṅw pay umuhqahahlayhpi hahlayhpiniwhtini. ");
INSERT INTO hopNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wuhti tihtatutuyne’ qahahlayṅwu, tuwaniyat aw pítuṅwuniqw ōviy’o; nīk̇aṅw ason pam tihte’ pahsat k̇ānavotpiy pāpu qa u’ni’taṅwu, sino tūwaqatsit aw tihtiwhq put ep hahlayṅwunihqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Noqw pan uma qahahlayyani; nīk̇aṅw pay nu nāt piw umumi pohtani, noqw umuh’unaṅwa hahlayhtotini, pu umuhhahlayhpiy soon himu sohtapnani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pu hisat aw pituqw uma soon pāpu nuy hihta tūviṅlawni. Pas antsaa, pas antsa nu umumi paṅqawni: Uma ituṅwniy aw yank̇ahk̇aṅw Inay aw nāp hihta ōviy tūviṅtotaqw pam umuy put máqamantani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yuk pahsavo hapi uma qa hisat nāt ituṅwniy aw yank̇ahk̇aṅw hihta ōviy tūviṅtota. Uma aw tūviṅtote’ ömahtotani, nen pas hinhaqam hahlayhtotini. ");
INSERT INTO hopNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yan nu pay tupkiwtaqat umumi yuaayku; ason hisat aw pituqw pep pu’ nu soon pāpu ilavayiy tupkitat, umuy Inay pas suyan āawnani. ");
INSERT INTO hopNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ason pep pu’ uma ituṅwniy aw yank̇ahk̇aṅw hihta ōviy tūviṅlalwani. Noqw nu umuṅem Inay aw tūviṅtaniqey hapi qa paṅqawu; ");
INSERT INTO hopNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pi Ina pas nāp umumi unaṅway’taqw ōviy’o, ispi uma inumi unaṅway’yuṅq’ö, nihqe nu God aṅqw pítuhqat uma tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nu Inay aṅqw yámakqe, tūwaqatsit aw pitu; nit pu’ nu tūwaqatsit mātapt, Inay awni. ");
INSERT INTO hopNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Noqw put aw nánatuwnayaqam put aw paṅqaqwa: Meh, pu’ hapi um pas suyan yuaaykuqe, pāpu qa sómokit lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pu’ hapi itam uṅ sohsok hihta navoti’taqat tūtuptsiwa; noqw soon kurs pas hak sȫwu hihta tūviṅlawni. It akw pu’ itam uṅ God aṅqw pítuhqat tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Noqw Jesus lavayhtiqe pumuy amumi paṅqawu: Ya uma pu’ tūtuptsiwa? ");
INSERT INTO hopNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Meh, aw hapi pituto, híkis pay aw pitsíwta, uma tatslak̇e’, nanāp umuhkiy aṅhqe nankwuse’, nuy nalmatapyaniqat aw’i. Nīk̇aṅw pay nu qa nālaa, pi Ina inumuma. ");
INSERT INTO hopNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Uma inuhpe kwakwhaiwyuṅwniqat ōviy nu umumi yan lavayhti. Uma tūwaqatsit ep k̇ānanvotyani; nīk̇aṅw pay uma su’qawyuṅwni, nu hapi yep qatsit áṅwuta. ");
INSERT INTO hopNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yan Jesus lavayhtit, ōmiq tātayht, paṅqawu: Inaa, aw hapi pitu; um Uhtiy pas hímunihqat pan nuhtumi mātaktani, noqw Uhti tuwat uṅ pan mātaktani. ");
INSERT INTO hopNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pi um Uhtiy sohsokmuy sinmuy amumi öqalat maqa, nihqe hakimuy hihsa’nihqamuy put aw noaqw, pam qatsit qaso’taqat amumi nóaniqat um pan put eṅem yuku. ");
INSERT INTO hopNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Noqw hak uṅ pas suhk̇a antsa God‐nihqat tuwi’te’ pu Jesus Christ uhpiy taviwhqat piw tuwi’te’ qatsit qaso’taqat himuy’vani. ");
INSERT INTO hopNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nu tūwaqatsit ep uṅ pas hímunihqat nuhtumi mātakta; um nuy hihta tumalat ayataqat hapi nu yuku. ");
INSERT INTO hopNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Noqw taay, Inaa, ura tūwaqatsit nāt qa háqamniqw nu úmumnihqe lolmat tālawṅwat pitsáṅway’ta. Noqw ōviy nu ūmi pituqw um piw pan nuy lomavitsaṅwtoynani. ");
INSERT INTO hopNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Um sinmuy amuṅaqw hakimuy inumi noaqw nu uṅ hákiynihqat pumuy āawna; puma as úhimumyaqw um pumuy inumi noa, noqw puma uhlavayiy aṅ hinwisa. ");
INSERT INTO hopNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nihqe um hihta inumi noaqw pam sohsoy ūṅaqwnihqat puma nanapta. ");
INSERT INTO hopNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pi um it lavayit inumi mātapq nu amumi put mātavi; noqw puma put ömahtota, nihqe nu ūṅaqw yámakqat pas suyan nanaptaqe pay um pas nuy aṅqw távihqat tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nu pumuy amuṅem okiw nāwakinta; nu yep qatsit tunatyayat aṅ hinwisqamuy qa pumuy amuṅem nāwakinta; um hakimuy inumi noaqw nu pumuy amuṅem nāwakinta, puma uhsinomniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Noqw sohsoyam isinom uhsinomu, pu sohsoyam uhsinom isinomu, noqw nu amuhpiy pas hímuniwhti. ");
INSERT INTO hopNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Noqw nu hapi pāpu qa tūwaqatsit ep hinnuma, noqw ima nāt tūwaqatsit epya; noqw nu yaṅqw ūmii. Qahováriwhpu Inaa, um hakimuy inumi nóahqey pumuy pas nāp uhtuṅwniy öqalayat akw oyi’tani, noqw puma sūk̇ayani, itamuni. ");
INSERT INTO hopNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nu nāt tūwaqatsit ep pumuy amumum hinnumqe uhtuṅwniy aṅ pumuy oyi’ta; um hakimuy inumi noaqw nu pumuy pās oyi’taqw qa himuwa haqami hiniwhti, pay i’ súlawhtiniqey namorstiwhqa‐saa, hin pey’taqat anhtiniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Noqw nu yahsatniqw yaṅqw ūmii, nihqe okiw pas pay imuy unaṅwpeq ihahlayhpiy aniwni’yuṅwniqat ōviy nu tūwaqatsit ep yan hiṅqawlawu. ");
INSERT INTO hopNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nu amumi uhlavayiy mātavi, noqw yep qatsit tunatyayat aṅ hinwisqam pumuy amumi qa suhtaq’ewya, puma qa yep sinoiwyuṅqw ōviy’o, nuy qa pep sinoiwtaqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Um as tūwaqatsit aṅqw pumuy ipwaniqat nu qa pan ūmi tūviṅlawu, um qalolmat aṅqw okiw pumuy ayo oyi’taniqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Puma inún qa yep qatsit ep sinoiwyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Um uhlavayiy pas antsanihqat akw pumuy nēṅem qenivo ōyani; uhlavayi pas antsaa. ");
INSERT INTO hopNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Um nuy sinmuy amumi tavi, noqw ōviy pay hapi nu piw pan nuhtumi pumuy ayata. ");
INSERT INTO hopNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nihqe nu pumuy tunatyawk̇aṅw qenivo nātavi, puma as pas antsa piw qenivo oyiwyuṅwniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pu nu qa ímuy‐sa amuṅem tūviṅlawu, nāt hakim pumuy lavayiyamuy ahpiy inumi tūtuptsiwaniqamuy amuṅem pīwu. ");
INSERT INTO hopNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Okiw as puma sohsoyam sūk̇ayaniqat nu tūviṅlawu, um Ina inuhpeniqw pu nu uhpenihqat pan piw itamuhpe sūk̇ayaniqata; noqw pep pu’ tūwaqatsit ep sinom um nuy aṅqw távihqat tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Noqw um hin nuy k̇aptsi’taqw pan piw nuy pumuy k̇aptsi’ta, puma itamun sūk̇ayaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nu pumuy amuhpeniqw pu um inuhpee, noqw puma itamuhpe pās pasiwyuṅwni, noqw sinom nanaptaqw um nuy aṅqw tavi, nihqe pas hin inumi unaṅway’taqey pan piw amumi unaṅway’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Inaa, um imuy hakimuy nuy maqaqw puma as nuy háqamnihqat pep inumumyaniqat nu nāwakna, nen it lolmat tālawṅwat um nuy máqahqat puma aw tayyuṅwni, pi um nāt tūwaqatsit qa yukiwhq pay pepeq inumi unaṅway’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Súantaqa Inaa, yep qatsit tunatyayat aṅ hinwisqam uṅ qa tuwi’yuṅwa, noqw nu uṅ tuwi’ta, noqw ima hapi um nuy aṅqw távihqat navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Noqw nu hapi uṅ pumuy āawna. Noqw okiw as um inumi hin unaṅway’taqw pan hapi pumuy nānami unaṅway’yuṅwniqat ōviy nu soon nāt qa uṅ pumuy āwintani. Nen nu pas antsa amuhpe yantani. ");
INSERT INTO hopNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yan Jesus lavayhtit put aw nánatuwnayaqamuy tsamk̇aṅw pahpiy nakwsuqw, puma haqe’ sik̇a Cedron yan mātsiwhqat yupqöymi nöṅa; noqw pam haqami olive qölmi pítuhqe, put aw nánatuwnayaqamuy amumum paṅso paki. ");
INSERT INTO hopNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Noqw put momṅwituy amumi mātapqa Judas piw put háqamnihqat tuwi’ta, Jesus put aw nánatuwnayaqamuy tsamk̇aṅw qa sūs paṅsoniṅwuniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Noqw God awwat mohpeq momṅwit Pharisee‐sinmuy amumum tuwalan’a’yatuy hoṅvia’yatuy enaṅ Judas aw mātavi; noqw puma wihqöhi’wisk̇aṅw, kopitsoki’wisk̇aṅw, tunipi’wisk̇ahk̇aṅw put amum paṅsoya. ");
INSERT INTO hopNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Noqw ōviy Jesus hin hintsaniwniqey sohsok navoti’taqe amumi nakwsuhqe paṅqawu: Ya uma hakiy hepnumya? ");
INSERT INTO hopNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Noqw puma lavayhtotiqe aw paṅqaqwa: Itam hakiy Nazareth aṅqw tāqa Jesus hepnumya. Noqw Jesus amumi paṅqawu: Nu’ pam’i. Noqw Judas amumi put mātapqa pumuy amumum wunu. ");
INSERT INTO hopNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Noqw pam panis pamnihqey amumi paṅqawhq pahsat pay puma áhoywat hohyok̇at, tutskwami pataṅmunumhti. ");
INSERT INTO hopNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pahsat pu piw pam pumuy tūviṅtaqe amumi paṅqawu: Ya uma hakiy hepnumya? Noqw puma paṅqaqwa: Itam hakiy Nazareth aṅqw tāqat Jesus hepnumya. ");
INSERT INTO hopNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus lavayhtiqe paṅqawu: Pay pi nu pamnihqey umumi paṅqawu; noqw ōviy kurs uma nuy hepnumye’, uma imuy mātapyani. ");
INSERT INTO hopNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ura pam hiṅqawhq put anhtiniqw ōviy’o, ura pam paṅqawu: Imuy hakimuy um inumi noaqw nu qa hihtawat kwahi, it’a. ");
INSERT INTO hopNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pahsat pu Simon Peter sipwuvahpi’taqe put hóroknat, God awwat mohpeq moṅwit tūwikiyat wuvahtaqe, putvaqw naqvuyat ayo tuku. Noqw i’ hak tūwiki Malchus yan mātsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pahsat pu Jesus Peter aw paṅqawu: Uhsipwuvahpiy tukpuyat aqw pánaa. Ina inuṅem okiwsanhpit kuyapkuyhq pay nu soon qa put hikwni. ");
INSERT INTO hopNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pahsat pu sohsoyam tuwalan’a’yam‐niqw pu moṅwíam, hoṅviaymuyatuy amumum Jesus ṅuayaqe put somya; ");
INSERT INTO hopNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nit mohti Annas aw put wikya, pam pi Caiphas möönaṅwuy’ta; noqw Caiphas put yahsaṅwuy ep God awwat mohpeq moṅw’iwta. ");
INSERT INTO hopNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","I’ Caiphas hapi ura Jew‐sinmuy amumi paṅqawu pay ura hak sūk̇a sinmuy amuṅem mokq pam ṅas’ewniqata. ");
INSERT INTO hopNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Noqw Simon Peter Jesus aṅki, pu suhk̇a put aw nánatuwnaqa; pamwat God awwat mohpeq moṅwit tuwi’ta; nihqe pam Jesus amum God awwat mohpeq moṅwit kīyat aw paki. ");
INSERT INTO hopNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Noqw Peter pay hötsíwat ihpaq wunu. Noqw pahsat pu suhk̇a Jesus aw nánatuwnaqa God awwat mohpeq moṅwit tuwi’taqa yámakqe, hötsíwat aw tunatyawtaqat mānat aw yuaaykuqe Peter pana. ");
INSERT INTO hopNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pahsat pu māna hötsíwat aw tunatyawtaqa Peter aw paṅqawu: Ya qa um piw it tāqat aw nánatuwnaqa? Noqw pam paṅqawu: Qae. ");
INSERT INTO hopNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Noqw iyohooniqw, ōviy tūtuwikt hoṅvia’yatuy amumum tövumsit hoveyelayaqe aw hoṅk̇ahk̇aṅw nāmukintota. Noqw Peter pumuy amumum aw wunuwk̇aṅw nāmukinta. ");
INSERT INTO hopNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pahsat pu God awwat mohpeq moṅwi Jesus tūviṅtaqe put aw nánatuwnayaqam hákimyaqat put tūviṅta, pu hihta pam pumuy tutuqaynaqata. ");
INSERT INTO hopNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Noqw Jesus lavayhtiqe aw paṅqawu: Nu nuhtumi susmataq yuaata. Nu tsotsvalkive sutsep tutuqayna, pu God kīyat ep’e, paṅso Jew‐sinom sutsep tsotsvalya; nu qa hihta nanauyve lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Noqw um hinoqw nuy tūviṅlawu? Nu hihta yuaaykuqat um inumi tūqayyuṅqamuy tūviṅtanik̇aṅwo; meh, puma nuy hiṅqawhq navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Noqw yan pam lavayhtiqw, pu suhk̇a hoṅiaya put aqlap wúnuhqa mapqölöy akw Jesus wuvahta, paṅqawk̇aṅwo: Ya um hinoqw God awwat mohpeq moṅwit aw panhaqam hiṅqawu? ");
INSERT INTO hopNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Noqw Jesus put aw paṅqawu: Pay pi kurs nuy qalolmat lavayhtiqw um put paṅqawni; kurs pay nuy súaṅqawhq ya um hinoqw nuy wuvahta? ");
INSERT INTO hopNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Noqw Annas put somt, God awwat mohpeq moṅwit Caiphas aw hōna. ");
INSERT INTO hopNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Noqw Simon Peter pep wunuwk̇aṅw nāmukinta; noqw haqawat pep hoṅqam put aw paṅqaqwa: Ya qa um piw put aw nánatuwnaqa? Noqw pam qa nakwhaqe paṅqawu: Qae. ");
INSERT INTO hopNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Noqw haqawa God awwat mohpeq moṅwit tūwikiat Peter aw paṅqawu: Puyaw qa um oliveqölpe put ámumniqw nu ūmi qa tātayi? Pam hapi Malchus aṅqwvi, it hakiy naqvuyat Peter ayo tukuqw put’a. ");
INSERT INTO hopNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pahsat pu Peter piw nāt qa nakwha, noqw pahsat pay taqakowako töqti. ");
INSERT INTO hopNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pahsat pu puma Caiphas aṅqw Jesus haqami Rome aṅqw moṅwit kīyat aw wikya; noqw súitsi; noqw puma pay moṅwkimi qa yuña, taq k̇a Amutsva Yūmosanihqat ep nōviwhqat aṅqw nȫnösaniqey qa hu’waniwyani. ");
INSERT INTO hopNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pahsat pu Rome aṅqw moṅwi Pilate yan mātsiwhqa yámakqe amumi paṅqawu: Ya uma hihta it nēveltotoynaya? ");
INSERT INTO hopNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Noqw puma lavayhtotiqe aw paṅqaqwa: Pay pi as i’ tāqa qa nukpananiqw soon itam ūmi put wikvayani. ");
INSERT INTO hopNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pahsat pu Pilate amumi paṅqawu: Pay pi uma put wikye’ umumi hin tutavot an put yukunayani, kita. Noqw ōviy Jew‐sinom put aw paṅqaqwa: Itam hakiy nīnayaniqey mewniwta. ");
INSERT INTO hopNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ura Jesus hin mokniqey lavayhtiqat anhtiniqw ōviy puma paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pahsat pu Pilate piw pavasiwhkimi pakit, Jesus wáṅwayhqe aw paṅqawu: Ya um Jew‐sinmuy moṅwiamu? ");
INSERT INTO hopNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Noqw Jesus lavayhtiqe put aw paṅqawu: Ya pay um pas nāp it lavayhti? sen pay hakim nuy pamnihqat uṅ āawnaya? ");
INSERT INTO hopNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Noqw Pilate lavayhtiqe aw paṅqawu: Ya nu Jew‐sino? Pi nāp uhsinom God awwat mohpeq momṅwituy amumum uṅ inumi mātapya. Ya um hihta hinhti? ");
INSERT INTO hopNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus lavayhtiqe aw paṅqawu: Pay imoṅwtunatya qa yep qatsit ahpiy’o, pi as imoṅwtunatya it qatsit ahpiyniqw soon itumal’a’yam as qa rohomhtotini; noqw nu Jew‐sinmuy amumi qa noiwni; noqw pi imoṅwtunatya qa yaṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Noqw ōviy Pilate put aw paṅqawu: Noqw um moṅwi? Jesus lavayhtiqe aw paṅqawu: Um súaṅqawu. Pi nu yaniqw tihtiwa; nihqe nu it hihta pas antsanihqat tuawi’taniqe ōviy tūwaqatsit aw pitu. Pas antsanihqat aṅ hinwisqam sohsoyam itönay nanaptaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Noqw Pilate put aw paṅqawu: Ya himu pas antsaa? Pam kitat, piw Jew‐sinmuy amumi yámakqe, amumi paṅqawu: Pas nu qa haqam qaanhtiqat put aw tuwa. ");
INSERT INTO hopNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Noqw pay pi Amutsva Yūmosanihqat ep nōviwhqat aw pituqw nu hakiy umumi mātapmantaniqat uma pan tuwi’yuṅwa. Noqw nu Jew‐sinmuy moṅwíyamuy umumi mātapniqat uma nānawakna? ");
INSERT INTO hopNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pahsat pu puma sohsoyam piw nāt sáakmaqe paṅqaqwa: Qa i’ni, Barabbasni. Noqw i’ Barabbas pi hihta tūnawhkilawu. ");
INSERT INTO hopNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pahsat pu Pilate solāwamuy pan ayataqw puma Jesus haqami wikyaqe wuvahpit akw put qa sūs wuvahtota. ");
INSERT INTO hopNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pahsat pu puma hihta kūtay’taqat kwitetotaqe put wihk̇at yukuyat put Jesus qötösomtoynaya, nit pu hihta palasakwat usimnit put usihtoynayaqe, ");
INSERT INTO hopNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Aw paṅqaqwa: Öqawmaṅwu, Jew‐sinmuy moṅwíamu! Pu puma may akw wuvalalwa. ");
INSERT INTO hopNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pu ōviy Pilate piw yámakqe sinmuy amumi paṅqawu: Meh, nu hapi qa haqam qaantaqat it aw túwahqe umuy navotnaniqey ōviy nu umumi put hórokna. ");
INSERT INTO hopNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pahsat pu Jesus kūtat akw qötösomiwk̇aṅw palasakwat usimnit usk̇aṅw paṅqw yama. Noqw Pilate umumi paṅqawu: Taa, yep tāqa. ");
INSERT INTO hopNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Noqw ōviy God awwat mohpeq momṅwit hoṅvia’yatuy amumum put aw yórikyaqe sáakmaqe paṅqaqwa: Nahoylehtsit aw múaa! Nahoylehtsit aw múaa! Noqw Pilate amumi paṅqawu: Uma pi wikye’ put nahoylehtsit aw muayani, nu pi qa hihta qaantaqat put aw tuwa. ");
INSERT INTO hopNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Noqw Jew‐sinom lavayhtotiqe paṅqaqwa: Itam hihta ep yukuyamantaniqe tutavot pasiwyuṅwa; noqw itahtutavoyniqw pi soon pam qa mokni, pam God Tíatnihqey paṅqawhqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Noqw ōviy Pilate pan lavayit navotqe pu’ pas maqasti. ");
INSERT INTO hopNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nihqe pavasiwhkimi piw pákihqe Jesus aw paṅqawu: Ya um hak háqaqö’? Noqw Jesus aw qa hiṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pahsat pu Pilate put aw paṅqawu: Noqw ya um inumi qa hinwat lavayhtini? Nu uṅ mātapniqey, sen nahoylehtsit aw muiwniqat uṅem yúkuniqey aw öqalat pasiwta. Ya um qa it navoti’ta? ");
INSERT INTO hopNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Noqw Jesus lavayhtiqe aw paṅqawu: Pay as öqalat qa ōṅaqw ūmi noiwhq soon um inumi öqalani. Pantaqw ōviy i’ hak nuy ūmi mātapqa uhpenihqe pas wukoqaanhti. ");
INSERT INTO hopNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pahpiy pu Pilate as put mātapniqey tunatyalti; noqw Jew‐sinom sáakmaqe paṅqaqwa: Um it tāqat mātave’ pay Caesar qa kwātsiatni, hak haqam nāmoṅwlawhqa pan Caesar aqw hiṅqawṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Noqw ōviy Pilate it navotqe Jesus wikk̇aṅw ihpo yama, nit pu haqam Owaqantupha yan túṅwantiwhqat ep moṅw’atsvewat ep qatuptu, haqam Hebrew‐sinmuy amuhkwanihqe Gabatha yan mātsiwhqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Noqw Amutsava Yūmosanihqat ep nōviwniqat totok̇ay’yuṅwa, noqw tāwanasavehaqamo. Noqw Pilate Jew‐sinmuy amumi paṅqawu: Taay, yep umuhmoṅwi! ");
INSERT INTO hopNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Noqw puma sáakmaqe paṅqaqwa: Tūvaay, tūvaay! Nahoylehtsit aw múaay! Noqw Pilate amumi paṅqawu: Noqw ya nu umuhmoṅwiy nahoylehtsit aw muiwniqat eṅem yúkuni? Noqw God awwat mohpeq momṅwit paṅqaqwa: Itam qa hakiy moṅwí’yuṅwa, pas Caesar‐saa. ");
INSERT INTO hopNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pahsat pu puma put nahoylehtsit aw muayaniqat ōviy pam amumi put mātavi; noqw puma ṅuayaqe ahpiy wikya. ");
INSERT INTO hopNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Noqw pam nahoylehtsiy īkwiwk̇aṅw haqami Masqötvihk̇a yan túṅwantiwhqat aw’i; pam Hebrew‐sinmuy amuhkwa Golgotha yan túṅwantiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pep pu’ puma hakimuy lȫqmuy put enaṅ nahoylehtsit aw muaya, nan’ik̇aqee, noqw Jesus amuhtsavee. ");
INSERT INTO hopNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Noqw pam hak hímunihqat Pilate pēnaqe nahoylehtsit atsve mua; noqw yan pey’ta: JESUS NAZARETH AṄQWNIHQA JEW‐SINMUY MOṄWIAMU. ");
INSERT INTO hopNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Noqw Jesus haqam nahoylehtsit aw muiwhq pam kīṅaqw qa yāpo; noqw ōviy k̇aysiwhqam Jew‐sinom it atsva yan pey’taqat aṅ tuṅwáya. Noqw pam Hebrew‐sinmuy amuhkwa pey’ta, pu Greek‐sinmuyu, pu Latin‐sinmuyu. ");
INSERT INTO hopNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pahsat pu Jew‐sinmuy amuṅaqw God awwat mohpeq momṅwit Pilate aw paṅqaqwa: Jew‐sinmuy moṅwíamu, um qa yan pēnat, pam Jew‐sinmuy moṅwíamnihqey pam kítahqat um pēnani. ");
INSERT INTO hopNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Noqw Pilate lavayhtiqe paṅqawu: Pay pi nu hin pēnaqw pay pi pantani. ");
INSERT INTO hopNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pahsat pu solāwam Jesus nahoylehtsit aw muayaqe yuwsiyat nālövo o’yaqe nāhuyva; noqw ahtöqö’napnaat qa tūihiwtaqe ahsupoq pöqniwta. ");
INSERT INTO hopNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Noqw ōviy puma nānami paṅqaqwa: Itam qa tsīk̇ayat, put ōviy nanavö’yani, mātaqpi hak putni, kitota. Yan puma tutuvenit antsanhtota, ura pan pey’ta: Puma iyuwsiy nāhuyvayaqe inapnay ōviy nanavö’ya. Noqw ōviy solāwam panhtoti. ");
INSERT INTO hopNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Noqw pep Jesus nahoylehtsiyat aqlap put yuat wunuwta, pu yuyat tupkoat Mary, hakiy Cleopas nȫmaata, noqw pu Mary Magdalene. ");
INSERT INTO hopNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Noqw Jesus yuy tuwa, pu put aw nánatuwnaqat pas aw unaṅway pep wúnuwtaqata, nihqe yuy aw paṅqawu: Wuhti, ayam uhtii. ");
INSERT INTO hopNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pahsat pu pam put aw nánatuwnaqat aw paṅqawu: Ayam úṅuu. Noqw pahpiy put aw nánatuwnaqa put kiy aw wīki. ");
INSERT INTO hopNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yantaqat atsva pu’ Jesus tumalay pay sohsok yúkuhqey navoti’taqe paṅqawu: Nu pānaqmoki, kita, hin pey’taqat antaniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Noqw pep tsaqaptat aṅqw ovavala a’nö sik̇a kūyiwta; noqw puma hihta söyatkot put aqw móroknayat, pu himu hisop yan mātsiwhqat kohoyat epeq söṅnayat put moami ītaya. ");
INSERT INTO hopNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pu ōviy Jesus ovavalat aṅ yúkuhqe paṅqawu: Yukilti, kitat yōkoltit sohsok hikwsu. ");
INSERT INTO hopNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Noqw ép nasuṅwintalöṅnit pas k̇aptsitiwhqat ep totok̇ay’yuṅwa. Noqw pumuy tokoam nāt nasuṅwintalöṅnit ep nahoylehtsit aṅ hāyiwyuṅwniqat ima Jew‐sinom qa nānawakna. Noqw ōviy puma Pilate awyaqe aw paṅqaqwa: Um as solāwamuy ayataqw, puma hok̇ayamuy qöqhitote’ pumuy haqami hintsatsnani. ");
INSERT INTO hopNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pahsat pu ōviy solāwam ö́kihqe mohti’maqat‐nik̇aṅw pu mitwat put amum nahoylehtsit aw muiltiqat pumuy lȫvaq hok̇ayamuy qöqhitota. ");
INSERT INTO hopNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nit puma Jesus aw ökiqw pay kurs pam mōki, noqw ōviy pay puma put hok̇ayat qa qö́hiknaya. ");
INSERT INTO hopNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nīk̇aṅw suhk̇a solāwa lansay akw put suyvaqewat söhkwiknaqw pahsat aṅqw uṅwa kūyit enaṅ munva. ");
INSERT INTO hopNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Noqw nu hapi it aw yori, nihqe hihta navoti’taqey pas suyan tuawi’ta; nu qa atsálawu, noqw uma kurs hin qa tūtuptsiwani. ");
INSERT INTO hopNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Hin pey’taqat hapi anhtiniqw ōviy īi yaniwhti, ura yan pey’ta: Qa himuwa put ȫqaat qöhikiwni, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pu piw sutsk̇e’ yan pey’ta: Puma hakiy söhkwiknayaqey aw yórikyani, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yantaqat atsva pu’ hak tāqa Aramatheat aṅqwnihqa Joseph yan mātsiwhqa Pilate awnihqe Jesus tokoyat haqami hintsanniqey put aw maqaptsi’ta; noqw Pilate put hu’wa. Noqw ōviy pam pítuhqe Jesus tokoyat haqami yawma. Pam hak as nuhtum Jesus aw tuptsiwa; nīk̇aṅw Jew‐sinmuy mamqasqe ōviy qa hakiy put āawna. ");
INSERT INTO hopNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Noqw pu piw Nicodemus hihta myrrh aloes enaṅ namiqwriwtaqat tsivót‐sikip sunat pututuwanit pahsa’haqam kimak̇aṅw ep pitu. Ura pam hak mohtihaqam míhikiwtaqw Jesus aw pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pu ōviy puma Jesus tokoyat haqami távihqe kwaṅwáhovaqtuqat tōsit atsva put siwuwuykinat tsatsákwmötsaput linen yan mātsiwhqat akw put mok̇ahta, hin Jew‐sinom hakiy masyuwsinayaṅwuqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Noqw pam haqam nahoylehtsit ep muiltiqat ep himuqölö; noqw pep puhutuamtuhsö; noqw nāt pas qa hak hisat paṅsoq taviwa. ");
INSERT INTO hopNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Noqw Jew‐sinom totok̇ay’yuṅqw ōviy puma pep Jesus tavi, pam tuamtuhsö áhayhpniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Noqw Sundayt aw pituqw, suits talavay nāt qa talq, Mary Magdalene tūamit aw’i; noqw kurs owa tūamit aqw ūtsiwtaṅwuqa ayo taviwa. ");
INSERT INTO hopNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pahsat pu pam wárikqe, Simon Peter‐nit pu nuy, Jesus aw unaṅwayat yan túṅwantiwhqat, itamumi paṅqawu: Taq kurs Tutuyqawhqat tūamit aṅqw hóroknaya; nihqe haqami pi put hintsatsna. ");
INSERT INTO hopNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pu ōviy nu Peter amum tūamit aqw wari. ");
INSERT INTO hopNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Noqw nu Peter ehpeqtaqe pay mohti paṅso pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nihqe nu motoltiqe ahpamiq tātayhqe tsatsákwmötsaput ep oyiqw tuwa; nīk̇aṅw pay nu qa aqw paki. ");
INSERT INTO hopNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pahsat pu Simon Peter inuṅk pitu; nihqe tūamit aqw pákihqe, tsatsákwmötsaput ep oyaqw tuwa. ");
INSERT INTO hopNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pu höhönpi put qötöyat akw as mōkiwtaqa pay tsatsákwmötsaput qa enaṅ qatsk̇aṅw pay nāla suphaqam qātsi. ");
INSERT INTO hopNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pahsat pu nu tuwat aqw paki, nihqe nu yórikqe tuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pam mokiwuy aṅqw pas soon ahoy qa tātayniqat pan pey’taqat nāt itam qa mātsi’yuṅqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pahsat pu itam ahoy paṅqw nima. ");
INSERT INTO hopNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Noqw Mary tūamit ihpaq wunuwk̇aṅw okiw pakmumuya; nihqe ōviy pam pan hiṅqawk̇aṅw, motoltit, tūamit aqw yori; ");
INSERT INTO hopNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nihqe hakimuy lȫqmuy hoṅviayatuy qȫtsat yuwsi’taqamuy pepeq qatuqw tuwa, haqe’ Jesus tokoat as qatsqat pep suhk̇a qötöveniqw, pu suhk̇a kukveq’a. ");
INSERT INTO hopNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Noqw puma hakim put aw paṅqawu: Wuhti, ya um hinoqw pakmumuya? Noqw pam amumi paṅqawu: Ispi kurs puma Itutuyqawhqay haqami hintsatsnaqe, haqam put taviyaqw nu qa navoti’taqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yan pam hiṅqawht, ahoy namtökk̇aṅw Jesus pep wunuqw tuwa; nit pam Jesus‐niqw qa māmatsi. ");
INSERT INTO hopNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Noqw Jesus put aw paṅqawu: Wuhti, ya um hinoqw pakmumuya? Ya um hakiy hepnuma? Noqw pay pam ūyit tumalay’taqanihqat pam wūwahqe aw paṅqawu: Tāqa, kurs um put haqami hintsane’, um haqam put távihqey nuy āawnani; noqw nu haqami hintsanni. ");
INSERT INTO hopNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Noqw Jesus put aw paṅqawu: Mary. Noqw pam aw namtökt, put aw paṅqawu: Rabboni, kita. (Pam Tūtutuqaynaqa i’nihqe pam’i.) ");
INSERT INTO hopNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus put aw paṅqawu: Um nuy qa ṅuṅ’ani, taq nu nāt Inay aw qa wūvi. Um itupkomuy amuminen amumi paṅqawni: Nu God Inay aw wupni, pu pay pam piw Umunaa, pu Umuhtutuyqawhqa. ");
INSERT INTO hopNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Noqw Mary Magdalene Tutuyqawhqat aw yórikqey put aw nánatuwnayaqamuy amumi tūawva, pu pam yan put aw lavayhtiqata. ");
INSERT INTO hopNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Noqw ép Sundayt ep tapkiqw put aw nánatuwnayaqam haqam tsovawtaqe, okiw Jew‐sinmuy mamqasyaqe ōviy hötsíwhpa’ uhtsi’yuṅqw, Jesus pítuhqe, amuhsonve wunuwk̇aṅw paṅqawu: Uma kwakwhat unaṅway’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yan pam lavayhtit, tokoy haqami söhkwiknayaqat pumuy amumi mahtakna may énaṅa. Noqw put aw nánatuwnayaqam Tutuyqawhqat aw yórikyaqe hahlayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Pahsat pu Jesus piw amumi paṅqawu: Uma kwakwhat unaṅway’yuṅwni. Nu hapi hin Inay nuy ayataqat pan piw tuwat umuy aṅqe’ ayata. ");
INSERT INTO hopNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yan pam lavayhtit, amumi hikwsut paṅqawu: Huvam Qahováriwtaqat Hikwsit kwusuyaa. ");
INSERT INTO hopNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Uma hakiy qaanhtipuyat ayo yukuyaqw pam ayo yukiwṅwu; pu uma hakiy qaanhtipuyat qa ayo yukiwniqat paṅqaqwaqw pam qa ayo yukiwṅwu. ");
INSERT INTO hopNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Noqw imuy pakwt lȫq sihk̇ay’taqamuy amuṅaqw hak Thomas, Didimus yan túṅwantiwhqa, qa amumumniqw Jesus pitu. ");
INSERT INTO hopNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Noqw ōviy mímawat Jesus aw nánatuwnayaqam put aw paṅqaqwa: Itam Tutuyqawhqat aw yórikya. Noqw pam amumi paṅqawu: Pas nu māyat ep muahpit akw pey’vaqat aw qa yórikk̇aṅw pu imalatsiy akw put aw qa hintsank̇aṅw, pu put tokoyat haqam söhkwiknayaqat aqw imay qa pane’ soon tuptsiwni. ");
INSERT INTO hopNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Noqw ahpiy nanalsikis talq put aw nánatuwnayaqam piw haqam ahpave tsovawta, noqw Thomas pumuy amumuma. Noqw hösíwa uhtsiwtaqw Jesus pítuhqe amuhsonve wunuk̇aṅw paṅqawu: Uma kwakwhat unaṅway’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pahsat pu pam Thomas aw paṅqawu: Kurs uhmalatsiy aqw pew hintsanaa, pu imay aw yórikuu; pu pew māvuyalte’, itokoy haqam söhkwiknayaqat aqw uhmay pánaa, nit um pāpu qapēvewnat tuptsiwni’tani. ");
INSERT INTO hopNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Noqw Thomas put aw paṅqawu: God, Itutuyqawhqa. ");
INSERT INTO hopNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Noqw Jesus put aw paṅqawu: Thomas, paysoq pi um inumi yórikqe ōviy tuptsiwa; inumi qa yórikyat tūtuptsiwaqam pas hihlayhpit epyani. ");
INSERT INTO hopNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Noqw Jesus put aw nánatuwnayaqamuy amumumnik̇aṅw pas qa tsa’ k̇ātatayhpit hihta tuawi’taqat tumalta; noqw pāvam qa sohsoy it tutuvenit aṅ pey’ta. ");
INSERT INTO hopNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Noqw pay hapi pas Jesus Moṅw’asi’taqanihqat, pu God Tíatnihqat uma tūtuptsiwaniqw ōviy īi yantaqa pēniwa, pu uma tūtuptsiwe’ put ahpiy qatsit tutwani. ");
INSERT INTO hopNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Iit atsve pu Jesus wuhkovatuphat Tiberias yan mātsiwhqat ep put aw nánatuwnayaqamuy amumi piw namtakna; noqw pam hin namtaknaqat nu umuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ima yahsa’hakim haqam sūpya: Simon Peter, pu Thomas, Didimus yan túṅwantiwhqa, pu Galileet ep Canat aṅqw tāqa Nathanael, pu Zebedeet tímat‐niqw, pu hakim lȫyöm piw put aw nánatuwnaqamu. ");
INSERT INTO hopNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Noqw Simon Peter pumuy amumi paṅqawu: Nu pakiwmaqto; noqw puma aw paṅqaqwa: Itam úmumyani. Noqw ōviy puma ahpiyyaqe āpiy pākihut aqw yuña, nit ep mihikq puma qa hihta kwisnaya. ");
INSERT INTO hopNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Noqw qavoṅvaqw talavay Jesus patuphat qalaveq wunu; noqw put aw nánatuwnayaqam put Jesus‐niqw qa māmatsya. ");
INSERT INTO hopNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pahsat pu Jesus pumuy amumi paṅqawu: Tōtimu, ya uma qa hihta kwisnaya? Noqw puma put aw paṅqaqwa. Qae. ");
INSERT INTO hopNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Pu pam amumi paṅqawu: Uma pākihut putvaqewat umuhtutsayay pāmiq tūvaye’ tutwani. Noqw puma panhtotiqe, pas antsa pāvakiwhtuy qaan’ewakw hintaqamuy intotaqe qa k̇ātoti. ");
INSERT INTO hopNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Paniqw ōviy nu Jesus pas aw unaṅwayat yan túṅwantiwhqa Peter aw paṅqawu: Taq Tutuyqawhqa. Noqw Simon Peter Tutuyqawhqat‐nihqat navotqe, napnay aṅ paki, qa yuwsi’taqe ōviy’o, nit pu pāmiq tsoo. ");
INSERT INTO hopNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Noqw mímawat put aw nánatuwnayaqam tutsáyat ep pāvakiwhtuy íniwyuṅqamuy pay pākihut akw lölökink̇ahk̇aṅw öki, puma tutskwat aṅqw qa yāpyaqe ōviy’o, pay tsivót‐sikip sunat kwílakit pahsaphaqamo. ");
INSERT INTO hopNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pu ōviy puma panis tutskwami ökit, pep tȫvut hoveyeliwtaqat tutwa. Noqw pāvakiwht put aṅ oyi. Pu pölavikit piw tutwa. ");
INSERT INTO hopNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Noqw Jesus pumuy amumi paṅqawu: Uma pāvakiwhtuy umuhtunimuy aṅqw pew kiwisni. ");
INSERT INTO hopNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Noqw Simon Peter put aqw wupqe yaṅsakoqmuy pāvakiwhtuy tutsáyat ep íniwtaqamuy tutskwami lölökinta, tsaṅe’sikip sunat‐sik̇aṅw aṅqw pakwt payhkomuy sihk̇ay’taqamuyu (153); noqw pas as qaan’ewakw hintaqw piw tutsaya qa tsīki. ");
INSERT INTO hopNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Noqw Jesus pumuy amumi paṅqawu: Huvam pewye’ nȫnösaa. Noqw soon kurs haqawa put aw nánatuwnayaqam pam haknihqat tūviṅtani, suyan pi pam Tutuyqawhqaniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Pahsat pu Jesus amuminihqe pölavikit kwusut, pumuy put huyta, pu pāvakiwhtuy pīwu. ");
INSERT INTO hopNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","It akw hapi pu’ Jesus put aw nánatuwnayaqamuy amumi pāyis nāmahtakna, mokiwuy aṅqw ahoy tātayht’a. ");
INSERT INTO hopNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pu ōviy pumuy nȫnösat, Jesus Simon Peter aw paṅqawu: Simon Jonas tíata, ya um imuy amuhpenihqe inumi pas unaṅway’ta? Noqw pam put aw paṅqawu: Owi, Tutuyqawhqa, pay nu uṅ hahlayhq um navoti’ta. Noqw pam put aw paṅqawu: Imamñatuy nopni’taa. ");
INSERT INTO hopNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pu aṅqw piw pam put aw paṅqawu: Simon, Jonas tíata, ya um inumi unaṅway’ta? Noqw pam paṅqawu: Owi Tutuyqawhqa, pay nu uṅ hahlayhq um navoti’ta. Noqw pam paṅqawu: Ikanelvokmuy amumi tunatyawtaa. ");
INSERT INTO hopNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pu pam pāyisni’mak̇aṅw put aw paṅqawu: Simon, Jonas tíata, ya um nuy hahlayi? Noqw pahsat pu Peter pas qahahlayhti, pam pu’ Ya um nuy hahlayi put aw kítaqw ōviy’o. Noqw pam put aw paṅqawu: Tutuyqawhqa, pay pi um sohsok hihta navoti’ta; nu uṅ hahlayhq um navoti’ta. Jesus put aw paṅqawu: Ikanelvokmuy nopni’taa. ");
INSERT INTO hopNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Pas antsaa, pas antsa nu ūmi paṅqawni: Um tsaynihqe nāyuwsinat haqami unaṅwte’ paṅso haqaminiṅwu; nīk̇aṅw pay ason um wúyokte’ uhmay hohtaknani; noqw pu suhk̇a uṅ yuwsinani, nit pu uṅ haqami qa nāwaknaqw uṅ paṅso wikni. ");
INSERT INTO hopNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pam yan lavayhtiqe put hin mokniqat paṅqawu. Noqw pam mokiwuy akw God pas pavan mātaktani. Pu pam yan lavayhtit put aw paṅqawu: Um inuṅk hinmani. ");
INSERT INTO hopNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Noqw Peter namtökqe nuy pumuy amuṅkniqw tuwa. Nu hapi Jesus aw unaṅwayat túṅwantiwhqe ura tapkiqw nōnovaqw put tawitsqayat aw tahtsikiwk̇aṅw aw paṅqawu: Ya hak uṅ momṅwituy amumi mātapni? ");
INSERT INTO hopNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Noqw Peter nuy túwahqe Jesus aw paṅqawu: Tutuyqawhqa, noqw i’ tuwat hinhtini? ");
INSERT INTO hopNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Noqw Jesus aw paṅqawu: Pay pi as pas nuy hisat pítuniqat aw pahsavo pam qátuniqat nu nāwaknaniqw, ya um put hintsanni? Um inuṅk hinmani. ");
INSERT INTO hopNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Pantaqat ahpiy pu’ yaw nu pay qa mokniqat mímawat nánatuwnayaqam yan lavayta. Noqw pi Jesus put aw qa paṅqawu: Pam qa mokni, qa kita; nīk̇aṅw Pay pi as pas nuy hisat pítuniqat aw pahsavo pam qátuniqat nu nāwaknaniqw, ya um hintsanni? kita. ");
INSERT INTO hopNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nu hapi put aw nánatuwnaqa īit tuawi’ta, nihqe īit pēna. Noqw uma navoti’yuṅqw ituawi pas qaatsa. ");
INSERT INTO hopNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Pu piw pas as nihtiwtaqat Jesus tumalta; noqw k̇a as pam sohsoy pēniwniniqw hikis pi k̇a tūwaqatsit ep soon tutuvenit pēniwniqat eṅem qénini. Pas antsaa.");
INSERT INTO hopNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ura nu mohtihaqam pēna, Theophilus; nihqe ura Jesus sohsok hihta hintsaktivaqat, pu tūtutuqaynativaqat nu yuaata, ");
INSERT INTO hopNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Hisat ōmi wīkiwhqat pahsavoo. Ura pam ayaiwyuṅqamuy namorstaqey amumi Qahováriwtaqat Hikwsit aṅ tutaptat, paṅso wīkiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pu piw pam k̇ānavot, put atsve hīhihta qaöwíhintaqat akw pumuy amumi pas suyan taytaqey mahtakna; lȫp sunat tālat aṅ pumuy amumi nāmataqlawu; nihqe God moṅwtunatyaat hin hintaqat pumuy amumi yuaata. ");
INSERT INTO hopNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Noqw ura pam pumuy amumum tsovawtaqe, puma Jerusalem aṅqw qa ahpiyyaniqat amumi tutaptaqe, Nayat aṅqw pumuy amumi hakiy awinit ōviy maqaptsi’yuṅwniqat paṅqawu. Ura uma inuhpiy put nanapta, pam kita. ");
INSERT INTO hopNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Pay as pi John pas antsa kūyit akw tūtuvoylalawu; nīk̇aṅw uma hapi yahpiy qa wūhakis talq Qahováriwtaqat Hikwsit akw tuvoylatiwyani. ");
INSERT INTO hopNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Noqw ōviy puma tsovaltiqe, put tūviṅtotaqe aw paṅqaqwa: Tutuyqawhqa, ya um pu’haqam Israel‐sinmuy amumi moṅwtunatyat ahoy pitsínani? ");
INSERT INTO hopNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Noqw pam amumi paṅqawu: Pay pam hísatniqat, pu haqe’ qalawmaqw aw pítuniqat Ina pas nāp öqalay akw yuki’taqat pay qa uma put navoti’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pay ason uma öqalat makiwyani, Qahováriwtaqat Hikwsit umumi pítuq’ö; nen uma nuy hin navoti’yuṅqey tuawi’yuṅwni Jerusalem ep’e, pu sohsovik Judeat aṅ’a, pu Samariat aṅ’a, pu ahpiy tūwaqalavoqhaqamii. ");
INSERT INTO hopNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yan pam lavayhtiqw, puma aw tāyuṅqw, pam ōmi wīkiwa; noqw ōmaw put wikqe, pumuy amutpik tupk̇a. ");
INSERT INTO hopNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Noqw pam ōmi wuptoqw, puma aṅk‐sa tāyuṅqw, hakim lȫyöm tāqat qȫtsat yuwsi’k̇aṅw pumuy amumi suptuqe, amuqlap wunuptu; ");
INSERT INTO hopNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nihqe paṅqawu: Uma Galileet aṅqw tahtaqtu, ya uma hinoqw pas ōmiq‐sa tayk̇ahk̇aṅw hōñi? Pay hapi i’ Jesus umuṅaqw ōmi wīkiwhqat uma aw tāyuṅqw, hin pam ōmi wupqey pan piw ahoy pítuni. ");
INSERT INTO hopNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pahsat pu puma tsomot Olivet yan mātsiwhqat aṅqw ahoy Jerusalem awya. (Pam tsomo Jerusalem aṅqw hak nasuṅwintalöṅnit ep haqami pahsavo nakwsumantaniqat pahsaphaqamo.) ");
INSERT INTO hopNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Noqw puma ep ö́kihqe, tupatsveq ahpami yuña; pepeq ima yēse: I’ Peter, pu James, pu John, pu Andrew, pu Philip, pu Thomas, pu Bartholomew, pu Matthew, pu James, hakiy Alphaeus tíata, noqw pu Simon Zelotes, noqw pu Judas it James tupkoata. ");
INSERT INTO hopNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ima sohsoyam sun unaṅway nāwakintota; pu pas okiwlalwa qa qé’iwwisk̇ahk̇aṅwo, hakimuy momoymuy amumuma, pu Jesus yuyat Maryt‐nik̇aṅw pu Jesus tupkomuyatuy amumuma. ");
INSERT INTO hopNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Noqw ephaqam Peter tuptsiwni’yuṅqamuy amuṅaqw wunuptu, (ima tsovawtaqam navaysikip sunat pahsa’haqamya) ");
INSERT INTO hopNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nihqe amumi paṅqawu: Tahtaqtu, isinomu, ura Qahováriwtaqa Hikwsi David moayat ahpiy tutuvenyukit aṅ aṅwu pay hin lavayhtiqw pas soon pam qa antani; pam Jesus ṅuawisqamuy put aw tsamqat Judas paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Pam as ura itamum tōnawta; nihqe itamum it yan tumalat aw taviwa. ");
INSERT INTO hopNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Noqw i’ tāqa ura qalomáhinhtiqe, ahsatiy akw tutskwat tui; nihqe kopaṅvosqe nāsavaqe pahtokq, sohsoy sīsihuat nöṅaṅayku. ");
INSERT INTO hopNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Noqw sohsoyam Jerusalem ep ki’yuṅqam put nanapta; noqw ōviy pep tutskwa pumuy amuhkwa Aceldama yan túṅwantiwa; pam tutskwa uṅwat akw tuiwhpu i’nihqe pam’i. ");
INSERT INTO hopNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pay ura Tātawit aṅ yan pey’ta: Nam kīat kīqötiwaa; nam qa hak aṅ qátuu, yan’i; pu piw yan’i: Nam tumalmakiwaat pas suhk̇a makiwaa. ");
INSERT INTO hopNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Imuy yep yesqamuy amuṅaqw haqawat Jesus qatsíyat aṅ ahsupoq itamum hinnumya, John hisat Jesus kūyit akw tuvoylataqat ahpiy’o, pu put itamuṅaqw ōmiq wīkiwhqat aw pahsavoo. Noqw ōviy itam pumuy amuṅaqw haqawat namorstotaqw, pam itamum Jesus mokiwuy aṅqw ahoy tātayhqat yuaatani. ");
INSERT INTO hopNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Noqw ōviy puma hakimuy lȫqmuy taviya, hakiy Joseph, Barsabas yan túṅwantiwhqat, pam hak piw Justus yan mātsiwhqat, nik̇aṅw pu hakiy Matthias pīwu. ");
INSERT INTO hopNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nit puma nānawaknaqe paṅqaqwa: Taay, Tutuyqawhqa, um sohsokmuy amumi unaṅwayamuy navoti’ta; um imuy tāqatuy himuwat namorstaqey mahtaknani. ");
INSERT INTO hopNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Noqw pam it tumalat ep wúnupte’, itamun aṅqe’ ayaiwtani. Ura Judas qaanhtiqe put aṅqw ayo yama, pas nāp qeniy awniqee, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pu puma pumuy amuhpe hihta akw tuwantotaqw, pam Matthias ep yēva. Noqw pam pakwt sukw sihk̇ay’taqamuy ayaiwyuṅqamuy amumum pohtoylaniwa. ");
INSERT INTO hopNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Noqw talöṅnit Pentecost yan mātsiwhqat aw pituqw, tuptsiwni’yuṅqam sohsoyam sun unaṅway haqam sūp tsovawta. ");
INSERT INTO hopNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Noqw nāt pumuy panyuṅqw, pahsat pay himu wukohuk̇aṅwuy an söykitaqa ōṅaqw pítuhqe, pumuy haqam kīve taṅawtaqw, pep pās ohpo. ");
INSERT INTO hopNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Noqw pep himu ūwiṅwuy antaqa amumi mātaqtiqe, nāhoy tsihtsiktiqe, leñit anhtiqe nānap amuhpa’ kwāvilti. ");
INSERT INTO hopNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Noqw puma sohsoyam Qahováriwtaqat Hikwsit akw tuyqawiwyuṅqe, pahsat pu hīhihtuy amuhkwa yuaaykuya, hin Hikwsi pumuy lavayhuytaqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Noqw ephaqam k̇aysiwhqam Jew‐sinom God pas k̇aptsi’yuṅqam Jerusalem ep tsovawta. Puma nānan’ivaqw tutskwat aṅqw öki. ");
INSERT INTO hopNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Noqw i’ yantaqa aṅqe’ nanaptiwhq, sinom qaan’ewakw hintaqam sūmi tsovaltiqe, hin kurs wūwaya, puma nanāp amumi tūqayyuṅqw, amuhkwa yuaatotaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Noqw puma sohsoyam pas hin unaṅwtotiqe k̇ātayuṅqe nānami paṅqaqwa: Meh, ya ima yuaatotaqam qa sohsoyam Galileet aṅqw sinomu? ");
INSERT INTO hopNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Noqw hintaqw ōviy itam nanāp hin lavaymakiway’k̇ahk̇aṅw, tihtiwyaqey pan pumuy yuaatotaqw nanvotya? ");
INSERT INTO hopNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parthian‐sínomu, Mede‐sínomu, Elamite‐sínomu, pu Mesopotamiat aṅ yesqamu, pu Judeat aṅ’a, pu Cappadociat aṅ’a, pu Pontus aṅ’a, pu Asiat aṅ’a, ");
INSERT INTO hopNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pu Phrygiat aṅ’a, pu Pamphyliat aṅ’a, pu Egypt aṅ’a, pu Cyrenet ánan’ik Lybiat aṅ hāhaqe’ yesqamu, pu Rome aṅqw yaktaqamu, Jew‐sínomu, pu Jew‐sinmuy amún tuptsiwni’yuṅqamu, ");
INSERT INTO hopNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Crete‐sínomu, pu Arabia‐sínomu, puma God k̇ātutmalayat itamuhkwa yuaatotaqw, itam sohsoyam nanvotya, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nihqe puma sohsoyam pas hin unaṅwtotiqe hin kurs hinhtotiniqe paṅqaqwa: Hin pa i’ hintani? ");
INSERT INTO hopNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Noqw pētu tututsiwyaqe paṅqaqwa: Ima puhut wine akw hōnaq’iwyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Noqw Peter pakwt sukw sihk̇ay’taqamuy amumum wunuk̇aṅw, lavayhtiqe sinmuy amumi paṅqawu: Uma Judeat ep yesqamu, pu sohsoyam Jerusalem ep ki’yuṅqamu, nu umuy it āawnani; uma ilavayiy aw tuqayvastotani. ");
INSERT INTO hopNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Itam qa hōnaq’iwyuṅqw uma pan itamumi wūwantota, nāt pu’ töṅva. ");
INSERT INTO hopNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pi i’ hapi God lavay’ayayat Joel aṅ lavayhtiwa, ura paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Pu so’ṅwamiq hapi yantani, kita God, nu sohsokmuy sinmuy amumi Ihikwsiy wūtani. Noqw umuhtim tōtim pu mamant inuṅem yuaatotani; pu umuhtahtaqt su’peyaqam tuawyorstotani, pu umuhwuwuyom tahtaqt tumokyorstotani. ");
INSERT INTO hopNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Pu ep nu imuy itutuwiktuy tahtaqtuy pu momoyamuy amumi Ihikwsiy wūtani. Noqw puma inuṅem yuaatotani. ");
INSERT INTO hopNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pu nu ōvaqe tokpelat aṅqe’ k̇ātatayhpit poñalawni, pu atpik tūwaqatsit aṅ hihta tuawi’yuṅqata, úṅwata, pu ūwiṅwuyu, pu kwits’ohpokita. ");
INSERT INTO hopNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tāwa qatālawvani, pu mūyaw uṅwat anhtini nāt Tutuyqawhqat wukotalöṅniyat pas qaöwíhintaqat aw qa pítuq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pep pu’ ason hak Tutuyqawhqat aw taqa’naṅwtiqa ayo yámakmantani, kita úrai. ");
INSERT INTO hopNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Uma Israel‐sinom tahtaqtu, uma it lavayit aw tuqayvastotani. I’ Nazareth aṅqw tāqa Jesus God aṅqw hahlaywa. Noqw God öqalay akw put ahpiy k̇ātumalat, pu kātatayhpit hihta tuawi’yuṅqat tumalta. Yan pam put hahlayhqey umumi mahtakna. Noqw uma hapi pas nāp put navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Put hapi uma God pasiwniyat, pu aṅwu pay hihta navotiyat akw put ṅuayaqe, qaanhinwisqamuy amumi put mātatveqw, puma nahoylehtsit aw put muayaqe, nīnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Noqw God put ahoy tātayna, mokiwuy öqalayat aṅqw put mātapqee, kurs hin pam put ṅui’taniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pi David ura put yan lavayhti: Pas nu sutsep inutpipo Tutuyqawhqat tuway’ta; pi pam iputvaqe wúnuq’ö. Noqw ōviy soon nu hin unaṅway’tani. ");
INSERT INTO hopNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Paniqw ōviy iunaṅwa hahlayhti, pu ileñi pas hahlayhti, pu ōviy piw itoko ūmi yank̇aṅw nāsuṅwni’tani. ");
INSERT INTO hopNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ispi um soon ihikwsiy maskiveq mātapniq’ö; piw um soon uhtumal’ayay Qahováriwtaqat hovahtiniqw nakwhani. ");
INSERT INTO hopNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Um qatsit haqe’ qatsqat nuy āawna; um inumum yantak̇aṅw nuy hahlayhtapnani, kita úrai. ");
INSERT INTO hopNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tahtaqtu, isinomu, kurs nu pas qatuhtusk̇aṅw umumi itahwu’yay David lavayhtini; ura pam mokqe āmilti, noqw put tūamiat nāt itamum yanta. ");
INSERT INTO hopNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ura David God lavay’ayaatnihqe navoti’taqw, ura God put aw qaöwívasiwnaqe, pam put aniwniyat aṅqw Christ wunuptsinat, put moṅw’atsvewayat ep qatuptsinaniqey yan lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Noqw pam it yantaqat aṅwu pay tuway’taqe, Christ ahoy tātayniqat lavayhti, pu put hikwsiat maskiveq qa mātaviwa, piw tokoat qa hovahti. ");
INSERT INTO hopNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","It Jesus hapi God ahoy tātayna, noqw itam hapi pas nāp put aw yóriki’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Noqw God hapi put momi távihqe, putvaqe put qatuptsina; nihqe it awinit Hikwsit put aw noa. Noqw pam it wūtaqw, uma put pantaqat hapi pu’ aw yórikya, pu nanapta. ");
INSERT INTO hopNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David pi ōmi qa wūvi, nīk̇aṅw pam ura pas nāp paṅqawu: Tutuyqawhqa Imoṅwiy aw paṅqawu: Um hāk iputvaqewat qátuni, ");
INSERT INTO hopNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Nu hisat uhtuwqamuy áṅwutaqw, puma ūmi maqaptsi’yuṅwniqat pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Noqw ōviy Israel‐sinom sohsoyam it pas suyan nanaptani: Uma hapi it Jesus nahoylehsit aw muaya. Noqw God hapi put Tutuyqawhqanihqat pan yuku, piw put Christ, yan tuṅwa. (Pam Moṅw’asi’taqa i’nihqe pam’i.) ");
INSERT INTO hopNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Noqw puma it yantaqat nanaptaqe pavan pas unaṅwmokyaqe, Peter‐nik̇aṅw pu mimuy ayaiwyuṅqamuy amumi paṅqaqwa: Tahtaqtu, itahpavamu, noqw itam hinhtotini? ");
INSERT INTO hopNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pahsat pu Peter amumi paṅqawu: Uma umuhtunatyay aṅqw lasyani. Nen uma sohsoyam Jesus Christ natṅwaniyat aṅ kūyit akw tuvoylatotini, umuhqaanhtipu ayo yukiltiniqat ōviy’o; nen uma Qahováriwtaqat Hikwsit kuwahtiwhqat makiwyani. ");
INSERT INTO hopNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pi awini hapi umuṅemi; pu umuhtimuy amuṅemi, pu sohsokmuy yāvaqyaqamuy amuṅemi, hihsa’nihqam hakimuy Itahtutuyqawhqa God wáṅwayniqamuy amuṅemi. ");
INSERT INTO hopNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pu pay wūhaq lavayit akw pam amumi hin hintaqat yuaataqe, amumi ö’qalqe paṅqawu: Uma pu’ qatsívaptsiwyuṅqamuy nukusyesqamuy qa amumum hinwisni; taq k̇a uma amún súlawhtini. ");
INSERT INTO hopNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pahsat pu k̇aysiwhqam hahlayk̇ahk̇aṅw, put lavayiyat kwusuyaqe, kūyit akw tuvoylatoti; noqw put tāwat ep payhp sōmorit pahsa’haqam sinom pumuy amumi tōnalti. ");
INSERT INTO hopNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nihqe puma su’qawk̇ahk̇aṅw, yūmosa ayaiwyuṅqam pumuy hin tutuqaynayaqat aṅ tutuqayya, pu sūp hinwisk̇ahk̇aṅw, Jesus u’nik̇ahk̇aṅw pölavikit yóṅoylalwa, piw nāwakinwisa. ");
INSERT INTO hopNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Noqw sinom sohsoyam maqastoti; noqw God ayaiwyuṅqamuy amuhpiy hīhihta k̇ātatayhpit hihta tuawi’yuṅqat nihtiwtaqat hintsaki. ");
INSERT INTO hopNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Noqw ima tuptsiwni’yuṅqam sūp hinnumya; nihqe sohsok hihta sūmi himuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nihqe puma hihta himuy huyaye’, hihta hihsa’ ömahtotaqey nāhuytaṅwu, hin pumuy hihta haqni’yuṅqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Noqw puma nāqavo sun tunatyawk̇ahk̇aṅw God kīyat ep hinnumya, pu haqam hakiy kīyat ep pölavikit yóṅoyhtotaṅwu; pu puma hahlayk̇ahk̇aṅw nȫsiwhqay nōnova, sun unaṅway’k̇ahk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pu puma God tayawink̇ahk̇aṅw sohsokmuy amuhpiy hahlaywa. Pu Tutuyqawhqa ayo nȫṅantaqamuy akw nāqavo put aw tōnawtaqamuy amumi hóyokinta. ");
INSERT INTO hopNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Noqw hísatniqw nānawaknaṅwuniqw, tāwat atvelpeniqw, Peter John amum God kīyat aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Noqw hakim hakiy tāqat tihtiwhpuy aṅqaqw tuhapiwtaqat tsöpwisa; puma nāqavo God kīyat aw hötsíwat Lomasniwa yan túṅwantiwhqat epeq put tahtapya, pam God kīyat aw yuṅtaqamuy amumi okiw hihta tuṅlaytaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Noqw ōviy pam Peter‐nik̇aṅw pu John pumuy God kīyat aw pakitoqw túwahqe, amumi hihta tuhtui. ");
INSERT INTO hopNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Noqw Peter John amum put aw taynumt, aw paṅqawu: Kurs itamumi tātayii. ");
INSERT INTO hopNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Noqw pam pumuy amuṅaqw hihta makiwniqey wūwank̇aṅw, amumi‐sa tayta. ");
INSERT INTO hopNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pahsat pu Peter paṅqawu: Nu sīvat ṅastaa; nīk̇aṅw nu hihta himuy’taqw uṅ máqani; nu Jesus Christ natṅwaniyat aw yank̇aṅw ūmi paṅqawni: Wunuptut nakwsuu, kitat, ");
INSERT INTO hopNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Put putvaqw māyat ṅuat, wunuptsinaqw, pahsat pay put kuk’at, pu kuktupk̇aqe hoṅviti. ");
INSERT INTO hopNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Noqw pam suṅwnuptut, nakwsuqe, pumuy amumum God kīyat aw paki, waymak̇aṅw, tso’tik̇aṅw, God pas hihtalawk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Noqw pam waymak̇aṅw God hihtalawhq sinom sohsoyam aw tāyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Noqw puma māmatsyaqw, pay as pam God kīyat aw hötsíwat Lomasniwa yan túṅwantiwhqat epeq qatuk̇aṅw, nuhtumi hihta tuṅlay’taṅwu; noqw pam hintsaniwhqat ep puma kātayuṅqe, hin kurs wūwaya. ");
INSERT INTO hopNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Noqw tāqa tuhap’iwtaṅwuqa powatiqa Peter John enaṅ hūrs ṅuy’taqw, sinom haqam Solomon Tuhööata yan mātsiwhqat aw sohsoyam pumuy amumi yuyutya. ");
INSERT INTO hopNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Noqw kurs sinom kātayuṅqw, Peter māmatsqe, amumi paṅqawu: Uma Israel‐sinom tahtaqtu, ya uma hinoqw it ep pas kātayuṅwa? Ya uma hinoqw pas itamumi‐sa tāyuṅwa suhpan k̇a itam pas nāp itah’öqalay, pu itahlomaqatsiy ahpiy it nakwsunaqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","I’ hapi hak Abraham, pu Isaac, pu Jacob itahwu’yamuy aw yantaqaam, God Tiy Jesus pas pavan sinota. Put hapi uma Pilate aw mātatveqe qa putyaniqey atpip paṅqaqwa, pas as pam put mātapniqey su’qawtaq’ö, ");
INSERT INTO hopNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nihqe uma it hakiy Qahováriwtaqat, pu Súantaqat qa nānakwhaqe, tuwat soq hak hakiy nīnaqat umumi noiwniqat uma nānawakna; ");
INSERT INTO hopNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nihqe Qatsit aw Tūtsamhqat nīnaya; noqw God put so’pumuy amuṅaqw ahoy tātayna; noqw itam hapi it pas suyan aw yóriki’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Noqw i’ tāqa put natṅwaniyat qapēvewnaqe, put natṅwaniyat aw yank̇aṅw hoṅvita. Uma hapi put aw tāyuṅwa, piw put tuwi’yuṅwa. Pay pas panta. Pam Jesus aw tuptsiwni’k̇aṅw sohsokmuy umutpik pās powiwk̇aṅw wunu. ");
INSERT INTO hopNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Noqw taay, isinomu, pay nu navoti’taqw uma hintsatsk̇aqey qa mātsi’yunwa, umuhmomṅwituy amun’i. ");
INSERT INTO hopNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Noqw pay hapi God sohsokmuy lavay’aymuy moayamuy ahpiy hin hintaniqat lavaytiqey aw antsana, ura Christ okiwsaniwniqat pam kita. ");
INSERT INTO hopNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Oviy uma umuhtunatyay aṅqw lasye’, God aw lasyani; noqw umuhqaanhtipu umuhpiy ayo hȫniwni, noqw Tutuyqawhqa umuy suyan unaṅwtoynani. ");
INSERT INTO hopNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Noqw pam Jesus Christ, umumi mohti yuaatiwhqat aṅqw tavini. ");
INSERT INTO hopNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Put hapi ōveqatsit pas pay soon qa kwúsuni, hisat sohsoy himu ahoy pūhutiniqat aw pahsavoo. Put hapi ura God qatsit yayhniwhqat pahpiy sohsokmuy pas hihtuy lavay’aymuy amuhpiy lavayhti. ");
INSERT INTO hopNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ura Moses itanamuy amumi pas suyan paṅqawu: God Umuhtutuyqawhqa umuhsinomuy amuṅaqw umuṅem lavay’ayay wunuptsinani, nuy hímunihqat pan’i. Ason pam umumi hin lavayhtiqw, uma sohsok aṅ aw tūqayyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pu ason hak haqam put lavay’ayat aw qa tuqayvastaqa hapi sinmuy amuṅaqw súlawhtimantani. ");
INSERT INTO hopNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Owí, pi sohsoyam God lavay’aymat, Samuel ahpiy hihsa’nihqam lavayhtotiqam yepehaq hin hintaniqat lavayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Uma hapi God lavay’aymuyatuy timatu, pu itanamuy amumi God pasiwniyat oyi’yuṅqamu; ura pam Abraham aw paṅqawu: Pu ason hapi uhnatkoy ep tūwaqatsit aṅ sopk̇awtaqam sinom hahlayhpit ep ö́kini. ");
INSERT INTO hopNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Noqw God hapi Tiy Jesus ahoy tātaynaqe umumi put mohti hōna, umuhnukpanay aṅqw umuy lasne’, hahlayhpit aw umuy ökinaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Noqw nāto puma sinmuy amumi yuaataqw, pay God awwat momṅwit‐niqw, pu God kīyat ep tuwalanmoṅwi‐niqw, pu Sadducee‐sinom pumuy amumi pas kipok’unaṅway öki, ");
INSERT INTO hopNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ayaiwtaqam nuhtumi yuaataqe, so’pum Jesus ahpiy ahoy tātayyaniqat tūtutuqaynaqw, put ep qa salayhtotiqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Noqw pay nuṅwu pas tapkiqw, ōviy puma ason qāvo hintaniqat tunatyawk̇ahk̇aṅw, pumuy sivikimi panaya. ");
INSERT INTO hopNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Noqw pay k̇aysiwhqam lavayit nanaptaqam tūtuptsiwa; noqw tahtaqt tsivót‐sikip sōmorit pahsa’haqam aw öki. ");
INSERT INTO hopNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pu ōviy qavoṅvaqw pumuy moṅwímat‐niqw, wukw’aymat‐niqw, tutavot tutuqaynayaqam‐niqw, ");
INSERT INTO hopNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pu God awwat mohpeq moṅwi Annas‐niqw, pu Caiphas‐niqw, John‐niqw, pu Alexander‐niqw, pu ahpiy hakim hihsa’nihqam God awwat mohpeq moṅwit sinomat Jerusalem awwat sūmi tsovalti. ");
INSERT INTO hopNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pu ōviy puma pumuy nāsami taviyaqe tūviṅtotaqe amumi paṅqaqwa: Ya uma hihta öqalat akw it yantsaki; hal ya uma hakiy natṅwaniyat aw yank̇aṅw panhti? ");
INSERT INTO hopNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Noqw pahsat Peter Qahováriwtaqat Hikwsit akw tuyqawiwk̇aṅw amumi paṅqawu: Uma aṅ sinmuy amuṅaqw momṅwitu, pu Israel‐sinmuy amuṅaqw wukw’a’yatu, ");
INSERT INTO hopNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kurs k̇a pi itam pu’ it tālat ep tūviṅtiwni, hin it tāqat qapasiwtaqat ep lolma tumaltiwhqata, pu hin pam qalaptuqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Noqw ōviy hapi nu sohsokmuy umumi paṅqawni; pu sohsokmuy Israel‐sinmuy amumii: Uma hapi it Jesus Christ Nazareth aṅqw tāqat nahoylehtsit aw muayaqw, God so’pumuy amuṅaqw put ahoy tātayna; noqw i’ tāqa put ahpiy yep umutpik pasiwk̇aṅw wunu. ");
INSERT INTO hopNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesus Christ owat ánk̇aṅw, umuy kīlalwaqamuy amuhpiy ayo tūviwhqa tuyqaveq paki. ");
INSERT INTO hopNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Pi itam put natṅwaniyat‐sa ahpiy ayo nö́ṅakni, qa hakiy sukw ahpiy’o; pi tūwaqalvoqhaqami qa suhk̇a hak God ahpiy ayo Tūooyhqa yan túṅwantiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Noqw puma Peter‐nik̇aṅw pu John pumuy amumi nanaptaqw, kurs pay puma qa haqam pas tutuqayk̇aṅw, söqapñatnik̇aṅw, pas qa tuhtusk̇aṅw yuaataqw, puma kātayuṅwa; nihqe amumi māmatsyaqw, kurs puma Jesus amum hinnumṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pu tāqa qalaptuqa pumuy amumum wunuqw, puma aw tāyuṅqe kurs put ep hiṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Noqw puma pumuy tsovawtaqamuy amuṅaqw yámakniqat puma amumi paṅqaqwat, pahsat put yuaatotaqe, ");
INSERT INTO hopNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Paṅqaqwa: Ya sen itam imuy tāqatuy hintsanyani? Suyan pi puma a’nö hihta tumaltaqw pam pantaqa Jerusalem ep ki’yuṅqamuy sohsokmuy amumi mātakti. Noqw kurs itam hin pumuy qa panhtiqat paṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Noqw pay i’ qa pas sinmuy amuhpa’ kúrukniqat ōviy itam pumuy pavan tsāwinayaqw, puma pāpu qa hakiy aw it natṅwanit aṅ yuaatani, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pu puma pumuy wáṅwayyaqe mēwaya; nihqe pāpu puma Jesus natṅwaniyat aṅ qa yuaataniqat, pu qa tūtutuqaynaniqat amumi paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Noqw Peter John amum lavayhtiqe, amumi paṅqawu: Huvupatpi úmuyniqw himuwa God atpip súanta, sen itam umumi pas tūqaytani, sen itam it God awwat tūqaytani? ");
INSERT INTO hopNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kurs pi hin tis itam hihta aw yórikqey, pu navotqey qa yuaatani, kita. ");
INSERT INTO hopNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Noqw pay puma sinmuy amumi tuhtusyaqe, hin kurs pumuy sisvinayani; nihqe ōviy puma piw pumuy tsāwinayat, mātapya, sinom sohsoyam hin hiniwhtiqat ep God pas hihtalalwaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Pi it hakiy tāqat ep himu hihta tuawi’taqa tumaltiwhq qalaptuqw, pam hak lȫp sunat ep hóyokiwtaqat yahsaṅwi’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Noqw puma mātaviwhqe sinomuy amumii; nihqe ima God awwat momṅwit wukw’a’yatuy amumum pumuy hintsatsnaqat puma pumuy sohsok āawna. ");
INSERT INTO hopNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Noqw puma put nanaptaqe, sun unaṅway God aw lavayhtotiqe paṅqaqwa: Tutuyqawhqa, God, um hapi ōveqatsit yuku, pu tūwaqatsita, pu pātuwaqatsita, pu sohsok put aṅ hihta hinyuṅqata. ");
INSERT INTO hopNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ura um uhtumal’ayay David moayat ahpiy paṅqawu: Ya hīhihtu sinom hinoqw itsívutoti; pu sinom hihta an’e’wakw tunatyaltoti? ");
INSERT INTO hopNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tūwaqatsit ep momṅwit hoṅva, pu nuhtumi momṅwit Tutuyqawhqat ehpewi natsvalaya, pu Moṅw’asniyat ehpewii. ");
INSERT INTO hopNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Pay pas antsa i’ Herod, pu Pontus Pilate, puma imuy pay qa‐Israel‐sinmuy‐nik̇aṅw pu pas Israel‐sinmuy amumum Jesus Uhtiy Qahováriwtaqat ehpewi sūmi tsovalti, Uhmoṅw’asniy ehpewii, ");
INSERT INTO hopNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Um aṅwu pay hisat uhmay, pu uhwuwniy akw hin pasiwnaqat anhtotiniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Taay, Tutuyqawhqa, um pumuy tsatsáwinpiyamuy aw yórikni; noqw uhtumal’a’yam qanalmaqasyak̇ahk̇aṅw uhlavayiy yuaatotaniqat um amuṅem pan yúkuni. ");
INSERT INTO hopNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Um uhmay akw nuhtumi unaṅwtave’ tūqalaptsintani; pu k̇ātatayhpit hihta tuawi’yuṅqat, Jesus Uhtiy Qahováriwtaqat natṅwaniyat aṅ tumalay’tani, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Noqw puma nānawaknaqe yukuyaqw, pumuy haqam tsovawtaqat ep tayayayku; noqw puma sohsoyam Qahováriwtaqat Hikwsit akw tuyqawiwk̇ahk̇aṅw, qanalmamqasyak̇ahk̇aṅw, God lavayiyat yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Noqw ima tuptsiwni’yuṅqam sohsoyam sun unaṅway’yuṅwa, pu sun tunatyawyuṅwa; piw qa hak amuṅaqw hihta himuy pas himuy’taqe paṅqawlawu; puma sohsok hihta sūmi himuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Noqw ayaiwyuṅqam Tutuyqawhqat Jesus ahoy tātayhqat a’nö lay’taqat yuaatota; noqw pumuy sohsokmuy amumi ōkwalni qaöwivitsiwta. ");
INSERT INTO hopNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Piw qa hak pumuy amuṅaqw hihta akw okiwhinta; puma hihsa’nihqam aṅqe’ tutskwat, pu kīkihut himuy’yuṅqam put huyantivayaqw, huyiwhqat hihk̇ayat kīvantaqe, ");
INSERT INTO hopNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ayaiwyuṅqamuy amutpipo put ōoya; noqw hak hihta ṅastaniqw puma put maqayaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Noqw hak Joses ayaiwyuṅqamuy amuhpiy Barnabas yan túṅwantiwhqa (pam Tsākw‐ep‐suyan‐unaṅwa i’nihqe pam’i) Levi‐wuṅwa, Cyprus aṅqw sino, ");
INSERT INTO hopNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tútskway’taqe put húyaqe, sīvat kívahqe ayaiwyuṅqamuy amutpipo put oya. ");
INSERT INTO hopNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Noqw hak tāqa Ananias yan mātsiwhqa nȫmay Sapphirat amum tutskway huya; ");
INSERT INTO hopNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nit soq hihk̇ayat hihsa’ nēṅemta; noqw nȫmaat amum put navoti’ta; nihqe pay qa sohsok kívahqe, ayaiwyuṅqamuy amutpipo put oya. ");
INSERT INTO hopNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Noqw Peter paṅqawu: Ananias, ya um hinoqw Qahováriwtaqat Hikwsit aw atsátaniqat, pu tutskwat hihk̇ayat hihsa’ nēṅemtaniqat Satan uṅ pan unaṅwtoyna? ");
INSERT INTO hopNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Puyaw pam nāt qa huyiwhqe, qa uhhimu; pu pam huyiwhqe ya qa um hihk̇ayat aw moṅwi? Ya um hinoqw yanhaqam uh’unaṅwpeq tunaltyalti? Um qa sinmuy amumi atsáta; pi um God aw atsáta. ");
INSERT INTO hopNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Noqw Ananias yan lavayit navotqe, aṅqe’ minukt mōki; noqw sohsoyam it nanaptaqam pas maqastoti. ");
INSERT INTO hopNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Noqw hakim tōtim hoṅvaqe put mok̇ahtotat, ihpo hóroknayaqe haqam tavimaya. ");
INSERT INTO hopNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pu ahpiy k̇a tāwa aṅhqe pāyis qöniltiqw, pahsa’haqam nȫmaat hiniwhtiqat qa navoti’k̇aṅw ep paki. ");
INSERT INTO hopNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Noqw Peter lavayhtiqe put aw paṅqawu: Kurs nuy āawnaa, ya pay uma pas yahsa’ ōviy tutskwat huya? Noqw pam paṅqawu: Owi, pay pahsa’ ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pahsat pu Peter put aw paṅqawu: Ya hintaqw ōviy uma Tutuyqawhqat Hikwsiyat aw hepniqey sun unaṅwti? Meh, uhpuwsuṅway tavimayaqam hötsiwmi ökiwiwta; nihqe puma uṅ yaṅqw haqami taviwisni. ");
INSERT INTO hopNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Noqw pahsat pay pam put kukmiq munukt mōki; noqw tōtim ö́kihqe put mokput tutwa; nihqe paṅqw put hóroknayaqe, puwsuṅwayat ehpeq taviya. ");
INSERT INTO hopNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Noqw sohsoyam Jesus aw tōnawtaqam put ep pas tsātsawna, pu’ hakim hihsa’nihqam it nanaptaqam pīwu. ");
INSERT INTO hopNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Noqw ayaiwyuṅqamuy māyamuy ahpiy k̇ātatayhpi hihta tuawi’yuṅqa sinmuy amuhpa’ tumalay’tiwa. (Noqw puma sun unaṅway haqam Solomon tuhöoyat ep tsovawta. ");
INSERT INTO hopNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pu ahpiy mimuy amuṅaqw soon hak pumuy amumi tōnaltiniqey kurs suhtaq’ewni; noqw sinom pumuy pas hihtay’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Noqw tūtuptsiwaqam Tutuyqawhqat aw wūhaq’iwma, k̇aysiwhqam tahtaqtu, pu momoyamu.) ");
INSERT INTO hopNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Noqw ōviy sinom tūtuyyaqamuy kisk̇ami tsamvantaqe, ahpat, pu puvuwhpit aṅ ōoyya, hísatniqw Peter paṅqe’niqw ṅas’ew kihsiwniat hihtawat ep kistamantaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pu Jerusalem ahpiy hāhaqe’ kitsókit aṅqw qaan’ewakw hintaqam sinom tūtuyyaqamuy tsamk̇ahk̇aṅw ökiwta, pu hakimuy tuyoy’e’wakw hīhikwsimuy akw qa kwaṅwáhinyuṅqamuyu; noqw puma sohsoyam qalaptuya. ");
INSERT INTO hopNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pahsat pu God awwat mohpeq moṅwi wunuptu, pu put an tunatyawyuṅqamu, ima Sadducee‐sinom tōnawtaqamu, nihqe puma itsívutotiqe, ");
INSERT INTO hopNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ayaiwyuṅqamuy amumi may’yuṅqe, pumuy sumisivikit aw taṅatota. ");
INSERT INTO hopNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Noqw pay Tutuyqawhqat hoṅviayaat mihikq sivikit uutspiyat hötahtat, pumuy paṅqw ipwaqe, amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Yupavé, uma God kīyat ep hoṅk̇ahk̇aṅw, it qatsit hin hintaqat nuhtumi sohsok yuaatotani. ");
INSERT INTO hopNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Noqw puma yan nanaptaqe, suits talavay God kīyat aw yuṅqe, pep sinmuy tutuqaynaya. Noqw God awwat mohpeq moṅwi pitu, pu put ámumyaqamu, nihqe wuwan’aymuy tsovala, pu sohsokmuy Israel‐sinmuy amuṅaqw wukw’a’yamuyu; nihqe sivikimi pumuy tsamwisniqat hakimuy ayatota. ");
INSERT INTO hopNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Noqw ayaiwyaqam ep ö́kihqe, pumuy sivikive qa tutwat puma áhoyyaqe tūawvaya; ");
INSERT INTO hopNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Nihqe paṅqaqwa: Pay as pas sivikimi hūrs uhtsiwta; noqw tūtuwalaqam ihk̇aqe hötsíwhpa hōñi. Noqw itam aw hötayaqe, ahpave qa hakiy tutwa. ");
INSERT INTO hopNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Noqw God awwat susmohpeq moṅwi, pu God kīyat ep tuwalanmoṅwi, pu God awwat mohpeq momṅwit it nanaptaqe, hin i’ haqami hiniwhtiniqat wūwantota. ");
INSERT INTO hopNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Noqw pahsat hak pítuhqe pumuy āawnaqe paṅqawu: Meh, ura uma imuy tahtaqtuy sivikimi taṅatotaqw, puma God kīyat ep hoṅk̇ahk̇aṅw sinmuy tutuqaynaya. ");
INSERT INTO hopNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pahsat pu tuwalanmoṅwi, hoṅvia’yatuy tsamk̇aṅw amuminihqe pumuy paṅqw pās tsāma, sinmuy mamqasqe ōviy’o, taq k̇a puma pumuy tatatupyaniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pu ōviy puma pumuy moṅwtsovawtaqamuy amutpipo tsamvaya. Noqw God awwat susmohpeq moṅwi pumuy amumi paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ura itam umuy pās mēwayaqe, uma Jesus natṅwaniyat qa aṅ tūtutuqaynayaniqat umumi paṅqaqwa, nōqa? Noqw meh, tuwat soq uma Jerusalem ep umuhtutuqayhpiy aṅqe’ kúruknayaqe, it tāqat qatsíyat itamuy tukopnayaniqey anyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pahsat pu Peter mímuywatuy ayaiwyuṅqamuy amumum lavayhtiqe paṅqawu: Pay kurs pi hin itam God qa awwat tuqayvastotamantani, qa sinot aw’i. ");
INSERT INTO hopNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Itanamuy aw yantaqaam God as Jesus wunuptsinaqw, uma put himutskit ep hahyaqe nīnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Noqw God put putvaqe momi tavi, pam motisinoniqat, pu ayo Tūooyniqat ōviy’o, Israel‐sinmuy nāp tunatyay aṅqw lasne’, pumuy qaanhtipuyat ayo yúkuniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Noqw itam hapi īit navoti’yuṅqe, put tuawi’yuṅwa, pu i’ Qahováriwtaqat Hikwsit pīwu, put hapi God put tunatyayat aṅ hinwisqamuy amumi nóaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Noqw puma put nanaptaqw, pavan unaṅwaam tuyvaqw, puma pumuy qöqyaniqey nānami yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pahsat pu hak Pharisee‐sino Gamaliel yan mātsiwhqa, tutavot tūtutuqaynaqa pumuy tsovawtaqamuy amuṅaqw wunuptu; pam hak sohsokmuy amuhpiy k̇aptsiwta; nihqe ima ayaiwyuṅqam pay hāk hihsavo nö́ṅakniqat paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pahsat pu pam tsovawtaqamuy amumi paṅqawu: Uma Israel‐sinom tahtaqtu, uma imuy hintsatsnaniqey wūwantotaqey ep tunatyaltotini. ");
INSERT INTO hopNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Taq pay nāt ura qa pew pituqw, hak Theudas mātaktiqe pas himunihqey pan nāyuaata. Noqw ura put hakiy aw tahtaqt sunát‐sikip sunat pahsa’haqam natsk̇aya. Noqw ura pam nīniwhq, sohsoyam put aw tuqayvastotaqam tatslakqe, qa háqamtoti. ");
INSERT INTO hopNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pu it tāqat aṅk ura hak Galileet aṅqw Judas nāmataqta, nāventiwhqat ep’e, nihqe k̇aysiwhqamuy naṅk wīsila; pamwa piw mokq, sohsoyam put aw tuqayvastotaqam ahtsavala. ");
INSERT INTO hopNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Noqw ōviy nu umumi paṅqawni: Uma imuy sinmuy amumi qa hintsatsk̇ani, uma qa amumi may’yuṅwni; pay i’ yan tunatya, pu tumala kurs pay sinmuy amuhpiynen pay soon aniwhtini; ");
INSERT INTO hopNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Taq k̇a pam pantaqa God ahpiy hintaniqw soon uma put símoknayani, taq nāphisat k̇a uma God aw rohomnumyani, kita. ");
INSERT INTO hopNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Noqw puma put lavayiyat kwusuya; nihqe ayaiwyuṅqamuy wáṅwayyaqe, a’nö wuvahtotat, pāpu puma Jesus natṅwaniyat aṅ qa yuaatotaniqat amumi paṅqaqwat mātapya. ");
INSERT INTO hopNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Noqw puma hahlayk̇ahk̇aṅw moṅwtsovawtaqamuy amuṅaqw ahpiyya, kurs puma nuhtum put natṅwaniyat ep hamanhintsaniwyaniqey hihk̇ay’vayaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Noqw puma nāqavo God kīyat ep‐nik̇aṅw pu sohsovik kīnawit Jesus pas Christ‐nihqat tūtutuqaynayaqey, pu yuaatotaqey qa qe’iwwisa. ");
INSERT INTO hopNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Noqw ephaqam tuptsiwni’yunqam wūhaq’iwmaqw, Greek‐sinmuy amuhkwa yuaatotaqam Hebrew‐sinmuy amumiq qayan unaṅway hiṅqaqwa, puma nāqavo hihta akw tūvaaṅwank̇ahk̇aṅw pumuy amuṅaqw koṅnanalvutuy tatami’yuṅqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Pahsat pu pakwt lȫq sihk̇ay’taqam ayaiwyuṅqam sohsokmuy tuptsiwni’yuṅqamuy tsovalayaqe, amumi paṅqaqwa: Soon tis pi itam God lavayiyat mātavi’k̇ahk̇aṅw tūnopni’yuṅqw pam súantani. ");
INSERT INTO hopNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Oviy uma umuṅaqw hakimuy tsaṅe’ tahtaqtuy amumi lomanavotit namorstotani, hakim Qahováriwtaqat Hikwsit akw tuyqawiwyuṅqamuyu, pu suan wuwni’yuṅqamuyu. Noqw puma it yantaqat aw tunatyawyuṅwniqat itam ep pumuy o’yani. ");
INSERT INTO hopNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nīk̇aṅw itamwat nāwakinpit, pu lavayit tumalay’yuṅwniqey aw‐sa yuki’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Noqw i’ yan lavayi sohsokmuy sinmuy amumi lomatöqti. Noqw ōviy puma hakiy Stephen qapēvewnit, pu Qahováriwtaqat Hikwsit akw tuyqawiwtaqat namorstota, pu Philip, pu Prochorus, pu Nicanor, pu Timon, pu Parmenias, pu Nicolas, pam hak Antioch aṅqwnihqe qa‐Jew‐sínonik̇aṅw Jew‐sinmuy amún tuptsiwni’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nihqe puma ayaiwyuṅqamuy amutpipo pumuy o’ya. Noqw puma amumi matyawk̇ahk̇aṅw, amuṅem nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Noqw God lavayiat suyhtsepṅwat öqawi’ma, noqw wūhaqti; noqw God awwat momṅwituy amuṅaqw k̇aysiwhqam it tuptsiwnit kwusuyaqe aṅ hinwisa. ");
INSERT INTO hopNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Noqw Stephen qapēvewnit, pu öqalat akw qaöwíhink̇aṅw sinmuy amuhpa’ hīhihta k̇ātatayhpit hintsaki, pu hihta supsiwyuṅqata. ");
INSERT INTO hopNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Noqw tsotsvalki Mātaviwyaqamuy Tsotsvalkiamu yan túṅwantiwhqat aṅqw hakim hoṅvaqe Stephen amum nāṅwuy’yuṅwa, pu Cyreniat aṅqw sínomu, pu Alexandriat aṅq’ö, pu Ciliciat‐nik̇aṅw Asiat aṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Noqw Stephen Hikwsit ahpiy suan lavayhtiṅwuniqw, puma kurs hin put áṅwutotani. ");
INSERT INTO hopNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pahsat pu puma hakimuy tahtaqtuy pan unaṅwtoynayaqw, puma paṅqaqwa: Itam aw tūqayyuṅqw Moses aqw qalomáhiṅqawu, pu God aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kitotaqe sinmuy hin unaṅwtoynaya, pu wukw’a’yatuyu, pu tutavot tutuqaynayaqamuyu. Noqw puma Stephen aw ö́kihqe, ṅuayaqe, moṅwtsovawtaqamuy amumi wikvaya. ");
INSERT INTO hopNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nihqe hakim put ehpewi hihta atsátotaniqamuy momi o’yaqw puma paṅqaqwa: Pas i’ tāqa panis tuwat it pas k̇aptsiwtaqat kīhut, pu hin hinwisniqat tutavot aqw qalomáhiṅqawlawu; ");
INSERT INTO hopNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Oviy pi itam aw tūqayyuṅqw, paṅqawu: Yaw i’ Jesus Nazareth aṅqw tāqa it kīhut sahpuknani, pu yaw Moses itamumi itahhintsakpiy tutaptaqat aw alöṅtani. ");
INSERT INTO hopNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Noqw moṅwtsovawtaqam sohsoyam Stephen aw tāyuṅqw, pas pitsáṅwaat hakiy God hoṅviayayat taywayat anta. ");
INSERT INTO hopNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pahsat pu God awwat mohpeq moṅwi Stephen aw paṅqawu: Ya pas pay ima hiṅqaqwaqw panta? ");
INSERT INTO hopNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Noqw pam paṅqawu: Tahtaqtu, isinomu, itanamu, kurs huvam tuqayvastotaa! Ura itana Abraham nāt Charran ep qa qátuhqe, Mesopotamiat ep qatuqw, God lolmat tālawṅwat pitsáṅway’taqa put aw mātakti; ");
INSERT INTO hopNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nihqe aw paṅqawu: Um uhtutskway, pu uhsinomuy amuṅaqw ahpiyni; nen nu tutskwat uṅ āawnaniqat um aqwni. ");
INSERT INTO hopNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pahsat pu pam Chaldia‐sinmuy tutskwayamuy aṅqw ahpiynihqe, Charran‐tutskwat ep qatuptu. Noqw put naat mokq paṅqw pu God it tutskwat uma ep pu’ yesqat aw put nahlakna. ");
INSERT INTO hopNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nīk̇aṅw pam pep hihsaqhaqam himuy’taniqat pam put qa maqa; pas qae, qa ṅas’ew haqami wuhkukniqat pahsaq’a; nīk̇aṅw pam put pas máqaniqey aw paṅqawu pu’ aṅk put ahpiy sinototiniqamuyu. Noqw puma put himuy’yuṅwni, put aw kita, nāt pam qa ti’taq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nihqe God yan lavayhti: Yaw put ahpiy aniwhtotiqam haqam qa nāp tutskway ep hinnumyani; noqw yaw pep sinom pumuy tusoqtuwiktotani; nen súnat‐sikip sunat yahsaṅwuy aṅ pumuy okiwsahsanyani. ");
INSERT INTO hopNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pu ason hihtuwat sinom pumuy tusoqtuwiki’yuṅqw nu pumuy amuṅem hinwat yúkuni, kita God; pu ason pantaqat atsva puma paṅqw nóṅak̇e’, yep nuy tumalay’yuṅwi. ");
INSERT INTO hopNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Noqw God put aw pasiwnaqe, poṅotkituvoyla put tuawi’taniqat pan put aw yuku; noqw ōviy Isaac tihtiwhq, Abraham nanalsikis talqat ep put poṅotku; noqw Isaac Jacob pantsana; noqw Jacob pakwt lȫq sihkay’taqamuy timuy piw pantsanhta. Noqw puma hapi itahwu’yamu. ");
INSERT INTO hopNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Noqw wūwuyom Joseph atsviy unaṅtuyvayaqe, Egypt aqw put huyaya; noqw God put amum yantaqe, ");
INSERT INTO hopNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Sohsok kānanvotpiyat aṅqw put ayo tavi’ma; pu Egypt epeq moṅwit Pharoaht aw put lomamataqta, pu súanwuwnitoyna. Noqw pam put Egypt aw moṅwtavi, pu put amum ki’yuṅqamuy sohsokmuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Noqw Egypt aṅ ahsupoq tsö́ṅösti, pu Chanaan aṅ’a, noqw sinom okiwhtoti; noqw itanam qa tunöstutwa. ");
INSERT INTO hopNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Noqw yaw Egypt epeq söhövosi óyihqat Jacob navotqe, mohti itanamuy paṅsoq hōna. ");
INSERT INTO hopNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nit pu piw yaw Joseph haknihqey pāvamuy āawna; noqw Joseph sinomat hákimyaqey Pharaoht āawniwa. ");
INSERT INTO hopNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pahsat pu Joseph nay Jacob wáṅwayi, pu sohsokmuy sinomuyu, payhp sunat‐nik̇aṅw aṅqw pakwt tsivot sihk̇aytaqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Noqw ōviy Jacob Egypt aqw’a; nihqe pam pepeq mōki, pam’i pu itanamu. ");
INSERT INTO hopNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Noqw pumuy tokoyamuy Sychem aw kiwisqe, pep tuamqölöt aqw taṅatota, ura Abraham Sychem ep hakiy Emmor tímuyatuy amuṅaqw sīvat akw put tuihqat paṅsoq’a. ");
INSERT INTO hopNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Noqw hihta awinit God Abraham aw qaöwívasiwnaqat aw hayiṅwtiqw, sinom Egypt epeq natkototaqe suhpanti. ");
INSERT INTO hopNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Noqw pas suhk̇a moṅwi Joseph qa tuwi’taqa moṅwqenit ep wunuptu. ");
INSERT INTO hopNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nihqe pam hak itanamuy amumi tutuhistivaqe pumuy okiwsahsanqw, yaw timat qa yesniqat ōviy puma titipostuy ihk̇e tatamlalwaniqat pam nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Pan yēsiwhq, Moses tihtiwa; nihqe yaw súhimu; nihqe payhkomuy mūmuyawhtuy aṅ nay kīyat ep aw unaṅwtaviwta. ");
INSERT INTO hopNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Noqw pam haqami tūviwhq, Pharaoht tiat māna put wikqe, put nēṅem wuṅwna. ");
INSERT INTO hopNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Noqw Moses Egypt epeq sinmuy hihta wuwantuwiyamuy aṅ sohsok tuwi’taqe, a’nö lay’taqat lavayi’ta, pu hintsakpit’a. ");
INSERT INTO hopNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Noqw pam lȫp sunat yahsaṅwni’k̇aṅw, pas nāp sinomuy, Israel‐sinmuy, amumi kurs pohtaniqey unaṅwti. ");
INSERT INTO hopNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Noqw suhk̇a qaanhintsahtsaniwhq, pam túwahqe eṅem lavayhti; nihqe eṅem nāoyhqe Egypt‐sinot nīna. ");
INSERT INTO hopNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Suhpan as God put ahpiy put sinomuyatuy ayo óyaniqat puma māmatsyaniqat pam wūwaqe ōviy’o. Noqw puma qa māmatsya. ");
INSERT INTO hopNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pu qavoṅvaqw hakim nāyawhq, pam amumi pítuhqe as piw pumuy nāmi pö́hiknaniqey wūwaqe amumi paṅqawu: Soh, tāqatu, uma nātupkomu; ya uma hinoqw nāyuyuyhna? ");
INSERT INTO hopNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Noqw sinosṅway qaanhintsahtsanqa Moses ayo naatsqöqna paṅqawk̇aṅwo: Ya hak uṅ itamumi moṅwtavi? Puyaw hak uṅ itamuy hin yukunaniqat aw uṅ tavi? ");
INSERT INTO hopNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ya um tāvok Egypt‐sinot nīnaqe, nuy piw nīnaniqe ōviy’o? ");
INSERT INTO hopNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yan pam hiṅqawhq, pahsat pu Moses Egypt aṅqw wāyaqe, Madian‐tutskwat ep qatuptu; nihqe pam pep lȫqmuy tīyotuy tímuy’va. ");
INSERT INTO hopNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Noqw lȫp sunat yahsaṅwuy aṅ ruhpakq, pep pu’ qayēsiwhpuve tūkwit Sinat ep Tutuyqawhqat hoṅviayaat himutskit uwiwitaqat aṅqw put aw mātakti. ");
INSERT INTO hopNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Noqw Moses put túwahqe, pep himu hintaqat aw wūwantaqe, as aw tātayniqe, ōviy aw nakwsuqw, Tutuyqawhqat tönaat put aw paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nu hapi umunamuy aw yantaqaam God, Abraham aw yantaqaata, pu Isaac, pu Jacob aw yantaqaamu. Pahsat pu Moses tsawnaqe tururuykuqe, kurs hin aw tātayni. ");
INSERT INTO hopNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pahsat pu Tutuyqawhqa put aw paṅqawu: Um uhtotsiy óyani, taq um pas hihta ep wunu. ");
INSERT INTO hopNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Pay nu pas Egypt epeq isinmuy okiwhinyuṅqat antsa yori; pu nu pumuy eykitotaqw navota. Nihqe nu pumuy put aṅqw qenivo oyaniqe ōviy hāwi. Noqw taa, nu uṅ Egypt aqw hōnani. ");
INSERT INTO hopNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","It Moses hapi ura puma qanānakwhaqe aw paṅqaqwa: Ya hak uṅ itamumi moṅwtavi? Puyaw hak uṅ itamuy hin yukunaniqat aw uṅ tavi? Ura kitota. Noqw pay God put moṅwtavi; piw pam sinomuyatuy amumi put ayata, pam hoṅviayat himutskit aṅqw put aw mātaqtiqat māyat ahpiy pumuy ayo ōoyniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Pam hapi Egypt epeq hīhihta k̇ātatayhpit hihta tuawi’yuṅqat tumaltat, pumuy paṅqw ipwa, pu patuphat Pālaṅpu yan mātsiwhqat aṅqee, pu qayēsiwhpuvee, lȫp sunat yahsaṅwuy aṅ’a. ");
INSERT INTO hopNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","I’ Moses hapi ura Israel‐sinmuy amumi paṅqawu: God Umuhtutuyqawhqa umuhsinomuy amuṅaqw umuṅem lavay’ayat wunuptsinani, nuy hímunihqat pan’i; uma put aw tūqayyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","I’ hapi qayesiwhpuve tsovawtaqamuy amumum hinnuma, pu tūkwit Sinat epeq put aw yuaaykuqat hoṅviayat ámuma, pu itanamuy amumuma. I’ hapi hak taytaqat lavayit itamumi mātapniqey ōviy put makiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Noqw itanam put aw qa tuqayvastotaniqey nānawaknaqe, put nahpiy ayo tūvayaqe, unaṅwpeq ahoy Egypt aw namtökya; ");
INSERT INTO hopNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nihqe Aaron aw paṅqaqwa: Itamuy hihtuy amumi yanyuṅwniqamuy itamuṅem yukuhtaa; noqw puma itamupyeve hinwisni. Pay pi itamuy Egypt aṅqw nö́ṅaknaqa Moses kurs haqamii, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nihqe ép puma wakashoyat yukuyaqe, wutsit aw hom’ooyyak̇ahk̇aṅw, nāp may akw hihta tumaltotaqey ep hahlayya. ");
INSERT INTO hopNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pahsat pu God pumuy amuṅaqw ayo namtökqe, ōvaqe hihtuy qaan’ewakw hintaqamuy amumi nāwakinwisniqat aw pumuy mātavi; pay pi ura God lavay’aymuyatuy pēniyamuy aṅ yan pey’ta: Ya pas antsa pay uma lȫp sunat yahsaṅwuy aṅ qayēsiwhpuve inumi hihtuy qö́yank̇ahk̇aṅw, hom’ooyya, uma Israel‐sinomu? ");
INSERT INTO hopNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Qa hin’i; uma Moloch mötsápkiyat yawnumya, pu aw umuhyantaqay Remphan sōhuyata; uma hihtuy pumuy amún sosniwyaqamuy yukuhtota amumi nāwakintotaniqe ōviy’o. Noqw ōviy nu umuy Babylon yupqöymiq tsamni, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Itanam pi ura qayēsiwhpuve hihta tuawi’taqat mötsápkit pasiwyuṅwa, hin pam Moses aw tutaptaqat pan’i. Nihqe ura Moses aw paṅqawu pam hin yukiwtaqat aw yórikqey pan put yúkuniqata. ");
INSERT INTO hopNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Noqw pu amuṅk itanam Joshuat amum hīhihtuy sinmuy tutskwayamuy kwahanayaqe, ep put kwusivaya, ura God itanamuy amupyeve pumuy haqami lālayi; noqw mötsápkihu David qatsíyat aw pahsavo pep wunu. ");
INSERT INTO hopNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Noqw pam God aṅqw paaṅwaniwhq, as Jacob aw yantaqayat God eṅem kītaniqey unaṅwti. ");
INSERT INTO hopNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Noqw Solomon hapi put eṅem kīta. ");
INSERT INTO hopNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Noqw pu pas Sus’oveqnihqa kīkihut sinmuy māyamuy akw yukiltotiqat qa aṅ qatu; pi ura God lavay’ayay ahpiy paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Oveqatsi imoṅw’atsvewa, pu tūwaqatsi iwuwukpi. Ya uma inuṅem kīhut yukuyani? kita Tutuyqawhqa. Ya sen nu pep nāsuṅwnani? ");
INSERT INTO hopNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ya īi himu qa sohsoy imay akw yukilti? ");
INSERT INTO hopNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Is uma hihtu qa ṅöyaltotiṅwuqamu, a’nö unaṅway’yuṅqamu, pu naqsöp’iwyuṅqamu! uma sutsep Qahováriwtaqat Hikwsit aw rohomnumya; uma umunamuy hinyuṅqw amunyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ya umunam God lavay’aymuyatuy hihtawat qa okiwsasna? Pu ura hak Súantaqa pituniqat hakim aṅwu pay lavayhtotiqamuy puma qöqya; noqw yepehaq uma put nuhtumi mātapyaqe nīnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Uma as ōveqatsit aṅqw hoṅvia’yatuy amuhpiy tutavot ömahtotak̇aṅw, qa aṅ hinwisa, kita. ");
INSERT INTO hopNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Noqw puma it nanaptaqe, pavan pas unaṅwso’qe, tamay ṅuritota. ");
INSERT INTO hopNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Noqw pam Qahováriwtaqat Hikwsit akw tuyqawiwk̇aṅw ōveqatsit aqwhaqami taytaqe, God lolmat tālawṅwayat‐nik̇aṅw pu Jesus God putvaqe wunuqw tuwa; ");
INSERT INTO hopNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nihqe paṅqawu: Meh, nu ōveqatsit aw hötsíltiqw tuwa; noqw Sinot Tiat God putvaqe wunu. ");
INSERT INTO hopNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pahsat pu puma a’nö hiṅqawk̇ahk̇aṅw, naqvuy útatotat, sūsaq put aw yuhtukqe, ");
INSERT INTO hopNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Put kīṅaqw haqami tūvayaqe, tatatupya. Noqw put ehpewi hiṅqaqwaqam hakiy puhuwuṅwiwtaqat Saul yan mātsiwhqat kukmiq yuwsiy o’ya. ");
INSERT INTO hopNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Noqw puma Stephen tatatupyaqw, pam God aw okiw taqa’naṅwtiqe paṅqawu: Tutuyqawhqa Jesus, um okiw ihikwsiy kwusuni, kita. ");
INSERT INTO hopNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pu pam tamötswunuptuqe, pas tönay aṅqe’ paṅqawu: Tutuyqawhqa, um okiw it qaanhtiput pumuy qa tukopnani, kita. Yan pam lavayhtit mōki. ");
INSERT INTO hopNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Noqw puma put nīnantotaqw, Saul amún unaṅway’ta. Noqw put tāwat ep Jerusalem epeq Jesus aw tōnawtaqamuy amumi qaan’ewakw hintsaktivayaqe, pumuy okiwsahsantivaya. Noqw puma sohsoyam Judeat, pu Samariat aṅ ahsupoq hāhaqe’ ahtsavalya, pay ima ayaiwyuṅqam‐sa qe’ya. ");
INSERT INTO hopNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Noqw hakim unaṅwvastahtaqt Stephen haqami taviwisqe, okiw put ep a’nö tsaykita. ");
INSERT INTO hopNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Noqw tuwat Saul Jesus aw tōnawtaqamuy amumi hintsaktivaqe, sohsovik kīnawit papkinuma, nihqe tahtaqtuy, pu momoymuy sivikimi lölökinlawhqe, taṅatima. ");
INSERT INTO hopNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Noqw ōviy aṅqe’ ahtsavalyaqam sohsovik nuhtumi lavayit yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pahsat pu Philip Samariat ep wuhkokitsokit aqwnihqe, nuhtumi Christ yuaata. ");
INSERT INTO hopNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Noqw pam hihta yuaataqw, sinom aw tūqayk̇ahk̇aṅw sun unaṅway put aw unaṅwtavi’yuṅwa, hihta k̇ātatayhpit supsiwyuṅqat hintsakqat aw tayk̇ahk̇aṅwo, ");
INSERT INTO hopNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pas qalomáhihikwsim pumuy akw tuyqawiwyuṅqamuy k̇aysiwhqamuy amuṅaqw a’nö hiṅqawk̇ahk̇aṅw, nȫṅantaqw ōviy’o; pu k̇aysiwhqam amuhpa’ qataytaqat tūtuyyaqam, pu qayaktaqam qalaptuya. ");
INSERT INTO hopNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Noqw pep kitsókit ep sinom pas pavan hinhaqam hahlayya. ");
INSERT INTO hopNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Noqw hak tāqa Simon yan mātsiwhqa pay hisat mohti pep kitsókit ep tuhisay hintsaki; nihqe Samariat ep sinmuy pas hintsani’ta; pas a’nö hímunihqey anta. ");
INSERT INTO hopNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Noqw sohsoyam put aw tūqayyuṅwa, sushin’ewakw aṅqw suspavannihqat aqw pahsavoo, paṅqawk̇ahk̇aṅwo: I’ tāqa God a’nö öqalaata, kitota; ");
INSERT INTO hopNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nihqe puma put k̇aptsi’yuṅwa, pam hisatṅahaqaqw tuhisay akw pumuy hintsani’taqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Noqw Philip God moṅwtunatyayat, pu Jesus Christ yuaataqw puma tūtuptsiwaqe, kūyit akw tuvoylatoti, tahtaqtu, pu momoyamu. ");
INSERT INTO hopNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Noqw Simon tuwat pas nāp tuptsiwhqe, kūyit akw tuvoylatiwa; nihqe Philip amum hinnuma. Noqw pam hīhihta kātatayhpit hihta tuawi’yuṅqat hintsakq aw taytaqe k̇ātayta. ");
INSERT INTO hopNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Noqw yaw Samariat ep sinom God lavayiyat kwusuyaqat ayaiwyuṅqam Jerusalem epeq yesqam nanaptaqe, Peter John enaṅ pumuy amumiq hōnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Noqw puma pumuy amumiqnihqe, puma Qahováriwtaqat Hikwsit kwusuyaniqat ōviy amuṅem nāwakna, ");
INSERT INTO hopNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Pay nāt pam pumuy qa haqawat aw pituqw ōviy’o, pay panis puma Tutuyqawhqat natṅwaniyat‐sa aṅ kūyit akw tuvoylatoti. ");
INSERT INTO hopNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pahsat pu puma pumuy amumi may akw toṅokq puma Qahováriwtaqat Hikwsit makiwya. ");
INSERT INTO hopNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Noqw ayaiwtaqam hakiy aw may akw toṅokq Qahováriwtaqat Hikwsit put aw noiwṅwuqat Simon pan yórikqe pumuy sīvat āawna, ");
INSERT INTO hopNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Paṅqawk̇aṅwo: Uma piw nuy enaṅ it öqalat maqaqw, nu hakiy aw imay akw toṅokq pam Qahováriwtaqat Hikwsit makiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Noqw Peter put aw paṅqawu: Pay nam uhsiva umum súlawhtii, God kuwahtipuat pay sīvat akw tuiwṅwuqat um pan wūwantaqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Um qa haqam it yantaqat ep qeni’ta, piw makiway’ta, pi uh’unaṅwa God atpip qa súanta. ");
INSERT INTO hopNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Oviy um it yan uhnukpanay aṅqw lasni; nen God aw nāwaknani; noqw hisnen uh’unaṅwpeq uhtunatyay qaantaqat ep ūmi pö́hikiwni. ");
INSERT INTO hopNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Taq kurs um qanut a’nö tsīvot anta; um nukpantunatyat akw sóontsaniwta. ");
INSERT INTO hopNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pahsat pu Simon lavayhtiqe paṅqawu: Uma okiw inuṅem Tutuyqawhqat aw nāwaknani; noqw uma īit hihta lavayhtiqw, okiw pam qa himuwa inumi pítuni. ");
INSERT INTO hopNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pu puma pas suyan hin navoti’taqey lavayhtit, Tutuyqawhqat lavayiyat nuhtumi yuaaykut, ahoy Jerusalem aqw’a; nihqe Samariat ep hāhaqe’ sinmuy kitsókiyamuy aṅ lomatuawit yuaatima. ");
INSERT INTO hopNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Noqw Tutuyqawhqat hoṅviayaat Philip aw paṅqawu: Um wunuptut tātöqni, Jerusalem aṅqw Gazat aqw pöhut aqw’a, kita. Pam paṅqe’ qayēwiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Noqw pam wunuptut aqw’a. Noqw meh, hak Ethiopiat aṅqw tāqa okiwlawniqe Jerusalem epeq pitumaqa paṅqe’ áhoynik̇aṅw, karētay aṅqw tsokiwma. Pam nömaqtsit aw qa awiwa, Ethiopiat epeq sinmuy moṅwíyamuy wuhtit Candacet aṅqw öqalat qaöwívasiwk̇aṅw, put sohsok hihta nukṅwayat aw tunatyawta. Pu pam God lavay’ayayat Esaias pēniyat aṅ túṅwanma. ");
INSERT INTO hopNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pahsat pu Hikwsi Philip aw paṅqawu: Um pas awnen karētat ámumni, kita. ");
INSERT INTO hopNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Noqw ōviy Philip put aw wárikqe, navotq pam God lavay’ayayat Esaias pēniyat aṅ túṅwanma. Noqw Philip put aw paṅqawu: Ya um hihta aṅ túṅwanmaqey mātsi’ta? ");
INSERT INTO hopNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Noqw pam paṅqawu: Pay kurs pi hin’i, hal pay hak pas nuy tutuqaynaqw‐saa, pam kítahqe, Philip put aqw wūve’, amum tsokiwmaniqat pam nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Noqw tutuvenit aṅ haqe’ yan pey’taqat pam aṅ túṅwanma: Kanēlo haqam nīniwniqey aw wīkiwhqat pam pan wīkiwa, pu mañat ārilantaqat pam atpip qa hiṅqawṅwuniqw pan pam qa hiṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pam qa hímuniwhtiqw, eṅem suan lavayiniqa ayo yukiwa; noqw hak sen put natkomuyatuy pohtoylani? Pi qatsíat tūwaqatsit aṅqw haqami hintsaniwa. ");
INSERT INTO hopNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Noqw nömaqtsit aw qa awiwa Philip aw paṅqawu: Taa, um as okiw nuy āawnani: Ya God lavay’ayaat hakiy yuaata, sen nāyuaata, sen pay hakiy paṅqawu? ");
INSERT INTO hopNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pahsat pu Philip lavayhtiqe, haqe’ pan pey’taqat pahpiy yuaativa; nihqe put aw Jesus yuaata. ");
INSERT INTO hopNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Noqw puma ahpiy panmak̇aṅw haqami pāmi pitu; noqw nömaqtsit aw qa awiwa paṅqawu: Meh, yep pāhu; ya nu kūyit akw tuvoylatiwniqw himu nuy put aw uhtsi’tani? ");
INSERT INTO hopNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Noqw Philip paṅqawu: Pay pi um pas sohsok uh’unaṅway akw tuptsiwe’, panhtini, kita. Noqw pam lavayhtiqe paṅqawu: Pay Jesus Christ God tíatnihqat nu tuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pahsat pu pay karēta hāk huruhtiniqat pam paṅqawu; noqw puma nāma pāmiq paki, Philip‐niqw pu nömaqtsit aw qa awiwa; noqw pam put kūyit akw tuyoylata. ");
INSERT INTO hopNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Noqw puma pāṅaqw yamakq, pahsat pay Tutuyqawhqat Hikwsiat Philip haqami wīki; noqw nömaqtsit aw qa awiwa pāpu aw qa yori; nīk̇aṅw pam pahpiy hahlayhk̇aṅw, nakwsu. ");
INSERT INTO hopNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Noqw Philip Azotus ep nātuwiwhqe, ahsupoq kitsókit aṅ lomatuawit yuaatinumk̇aṅw, Caesareat ep pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Noqw Saul nāt pas itsívuhihkwisk̇aṅw, Tutuyqawhqat aw tuptsiwni’yuṅqamuy pavan pas hintsanniqey, pu pas qö́yaniqey tunatyawk̇aṅw, God awwat susmohpeq moṅwit aw’i; ");
INSERT INTO hopNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Nihqe Damascus ep aṅqe’ tsotsvalkit aṅ sinmuy amumi put eṅem pēnayaniqat nāwakna; noqw kurs pam hakimuy tahtaqtuy, sen momoymuy Jesus aw tuptsiwni’yuṅqamuy tuwe’, pumuy somhtat, Jerusalem aqw tsamni. ");
INSERT INTO hopNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Noqw ōviy pam paṅsoqnihqe, Damascus aw hayiṅwnaqw, ōṅaqw tāla put ánan’ik suhtalawva; ");
INSERT INTO hopNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Noqw pam tutskwami posqe, hakiy tönayat navotq, put aw paṅqawu: Saul, Saul, ya um hinoqw nuy okiwsahsana? ");
INSERT INTO hopNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Noqw pam paṅqawu: Ya um hak’i, Tutuyqawhqa? Noqw Tutuyqawhqa paṅqawu: Nu Jesus, um nuy hapi okiwsahsana. Um sökwíkinpit aqw horarataqw, pam uṅem anahaa. ");
INSERT INTO hopNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Noqw pam tsawnaqe, tururutik̇aṅw, pas hin unaṅway’k̇aṅw paṅqawu: Tutuyqawhqa, noqw nu hinhtiniqat um nāwakna? Noqw Tutuyqawhqa put aw paṅqawu: Um wunuptut, kīmini; noqw ason um hinhtiniqat uṅ pep āawnayani. ");
INSERT INTO hopNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Noqw tahtaqt put ámumyaqam qa hiṅqawk̇ahk̇aṅw aṅqe’ hōñi; hakiy as tönayat nanvotyak̇ahk̇aṅw hakiy qa tuway’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Pahsat pu Saul tutskwaṅaqw wunuptuqe, as pōsiy púruknat, qa hihta tuwa; noqw puma put māyat ṅuy’wisqe, Damascus ep wikvaya. ");
INSERT INTO hopNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Noqw pam pāyis tālat aṅ kurs hin hihta túwani, piw qa nȫsa, qa hīko. ");
INSERT INTO hopNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Noqw hak tuptsiwni’taqa Ananias yan mātsiwhqa Damascus ep qatu. Noqw pam tuawyorikq, Tutuyqawhqa put aw paṅqawu: Ananias, Noqw pam paṅqawu: Yep nūu, Tutuyqawhqa. ");
INSERT INTO hopNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Noqw Tutuyqawhqa put aw paṅqawu: Um wunuptut, Sūwipo kisk̇at yan mātsiwhqat awni; nen Judas kīyat ep hakiy Tarsus aṅqwnihqat Saul yan mātsiwhqat ōviy tūvintani; taq meh, pam okiwlawu, ");
INSERT INTO hopNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nihqe tuawyorikq hak tāqa Ananias yan mātsiwhqa ep pákihqe, put aw may akw toṅo pōsiy tālawnaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Pahsat pu Ananias lavayhtiqe paṅqawu: Tutuyqawhqa, pas yaw i’ tāqa Jerusalem epeq uhsinmuy okiwsahsanqat nu k̇aysiwhqamuy amuṅaqw navota. ");
INSERT INTO hopNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Noqw yaw pam yep uhnatṅwaniy aw tatqa’naṅwyaqamuy sohsokmuy somhtaniqey God awwat mohpeq momṅwituy öqalat pasiwk̇aṅw pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Noqw pay Tutuyqawhqa put aw paṅqawu: Um awni, taq pam pas inamors’awiwa; pam qa‐Jew‐sinmuy, pu pas momṅwituy‐nik̇aṅw, pu Israel‐sinmuy amumi inatṅwaniy tūawmani. ");
INSERT INTO hopNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Pu nāt pam inatṅwaniy ep hīhihta aṅ qaan’ewakw okiwsaniwniqat nu put āawnani, kita. ");
INSERT INTO hopNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Noqw ōviy Ananias awnihqe, kīmi pákihqe, put aw may akw toṅot, paṅqawu: Itupko Saul, Tutuyqawhqa Jesus uṅ aṅqaqwniqw ūmi mātaktiqa nuy aṅqw hōna, umuhposiy tālawnaniqat ōviy’o, pu Qahováriwtaqat Hikwsit akw tuyqawiwtaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Noqw pahsat pay himu nasiṅwput antaqa put pōsiyat aṅqw löhökq, pam pōsiy tālawnaqe wunuptu; nihqe kūyit akw tuvoylatit, nösqe, öqawhta. ");
INSERT INTO hopNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pahsat pu Saul Damascus ep tuptsiwni’yuṅqamuy amumum hihsavo qatu, ");
INSERT INTO hopNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nihqe āpiy tsotsvalkiva i’ Jesus God Tíatnihqat yuaatinuma. ");
INSERT INTO hopNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Noqw sohsoyam put aw tūqayyuṅqam hin kurs wūwantotaqe paṅqaqwa: Ya qa i’ Jerusalem epeq it natṅwanit aw tatqa’naṅwyaqamuy hovalaqe, hakimiy panyuṅqamuy somhte’ God awwat mohpeq momṅwituy amumi tsamniqe ōviy pew pitsíwta? kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Noqw tuwat Saul pas suyhtsepṅwat öqawi’maqe, Damascus ep Jew‐sinmuy yumoṅwaltaqe, pay Jesus pas antsa Christ‐nihqat amumi mātaqlawu. ");
INSERT INTO hopNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Noqw ōviy ahpiy wūyavotiqw, Jew‐sinom put nīnayaniqey nanawinya. ");
INSERT INTO hopNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nihqe puma put nīnayaniqe ōviy tālö‐nik̇aṅw, pu tōkilat aṅ höhtsiwat aw tunatyawyuṅwa. Noqw yaw puma put moqmani’yuṅqw Saul navota. ");
INSERT INTO hopNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pahsat pu tuptsiwni’yuṅqam míhikiwtaqw put tuhpelat aṅ tutsáyat akw hawnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Noqw Saul Jerusalem epeq pítuhqe, as tuptsiwni’yuṅqamuy amumumtiniqey anhtiqw, puma sohsoyam put mamqasyaqe, pam pas antsa tuptsiwni’taqat qa tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Noqw Barnabas put aw unaṅwtapqe, ayaiwyuṅqamuy amumi put wikva; nihqe hin pam Damascus aqwniqw, Tutuyqawhqa put aw namtaknaqe, put aw yuaaykuqat pam pumuy āawna, pu hin Paul Damascus epeq qa tuhtusk̇aṅw, Jesus natṅwaniyat aṅ nuhtumi yuaataqata. (Noqw pep pu’ puma put kwusuya.) ");
INSERT INTO hopNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Noqw Paul Jerusalem epeq pumuy amumum hinnumqe, ");
INSERT INTO hopNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Qa tuhtusk̇aṅw Tutuyqawhqat Jesus natṅwaniyat aṅ nuhtumi yuaata; nihqe Greek‐sinmuy amuhkwa yuaatotaqamuy amumum put ep nāṅwuy’taqw puma put nīnayaniqey tunatyawyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Noqw tuptsiwni’yuṅqam put nanaptaqe, Caesareat aqw put wikyaqe paṅqw put Tarsus aqw taviya. ");
INSERT INTO hopNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pahsat pu Jesus aw tōnawtaqam Judeat, pu Galileet, pu Samariat aṅ ahsupoq yesqam suyan unaṅwtotiqe, öqawhtota; nihqe Tutuyqawhqat k̇aptsi’k̇ahk̇aṅw wūhaq’iwma, Qahováriwtaqa Hikwsi amumi unaṅwtapq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Noqw Peter aṅqe’ sohsovik nakwsuqe, Lyddat epeq God sinomuyatuy amumi hāwi. ");
INSERT INTO hopNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nihqe pepeq pam hakiy tāqat Aeneas yan mātsiwhqat tuwa, put hakiy ahpa qa taytaqw, pam okiw nanal yahsaṅwuy aṅ tuyhqatsi. ");
INSERT INTO hopNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Noqw Peter put aw paṅqawu: Aeneas, Jesus Christ uṅ qalaptsina. Wunuptut, uh’ahpay tsovalaa, kita. Noqw pahsat pay pam wunuptu. ");
INSERT INTO hopNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Noqw sohsoyam Lyddat pu Saron ep ki’yuṅqam put aw yórikyaqe Tutuyqawhqat awwat lasya. ");
INSERT INTO hopNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Noqw hak Joppat ep tuptsiwni’taqa Tabitha yan mātsiwa, pam Dorcas (Tsöviwmana) i’nihqe pam’i. Noqw i’ hak wuhti lolmat tumalay’ta, pu hīhihta akw tūvaaṅwanta. ");
INSERT INTO hopNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Noqw pam ephaqam tūtuyhtiqe mōki; noqw puma put pāhomyaqe tupatsveq taviya. ");
INSERT INTO hopNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Noqw pay pi Lydda Joppat áhayhpo; noqw yaw Peter pep qátuhqat tuptsiwni’yuṅqam nanaptaqe, hakimuy lȫqmuy tāqatuy paṅso ayatotaqw, pam qa sȫwunit, pumuy amuminiqat puma nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pahsat pu Peter nakwsuqe, pumuy amumuma. Noqw ōviy pam pituqw, puma put tupatsmiq wupnaya; noqw sohsoyam koṅnanalvut okiw put aqlap hoṅqe, tsaykik̇ahk̇aṅw nāt Dorcas pumuy amumum qátuhqe kwakwsat, pu yūyuwsit yukuhtaqat puma put aw matamintota. ");
INSERT INTO hopNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Noqw pay Peter pumuy sohsokmuy paṅqw ipwat, tamötswunuptut nāwakna; nit pahsat put tokoyat aw namtökt paṅqawu: Tabitha, qatuptuu. Noqw pam pōsiy púruknaqe, Peter túwahqe, pahsat qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Noqw pam put aw māvuyaltiqe, wunuptsinaqe, God sinomuyatuy koṅnanalvutuy enaṅ wáṅwayhqe, pumuy put āawna, kurs pam taytaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Noqw i’ yantaqa Joppat aṅ ahsupoq nanaptiwhq, k̇aysiwhqam Tutuyqawhqat aw tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Noqw Peter Joppat ep hakiy pūvuk̇at pöhiwantaqat Simon amum wūhakis qatu. ");
INSERT INTO hopNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Noqw hak tāqa Cornelius yan mātsiwhqa, tsivót‐sikip sunat solāwamuy Italian‐sínomu yan túṅwantiwyaqamuy amumi moṅwi, Caesareat ep ki’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Pam hak pās unaṅway qatu; noqw sohsoyam timat put amum God k̇aptsi’yuṅwa; pu pam hihta himuy akw sinmuy paaṅwank̇aṅw, sutsep God aw nāwakinma. ");
INSERT INTO hopNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pam hak tāwat atvelpeniqwhaqam pas suyan tūawtaqw, God hoṅviayaat put aw pákihqe, aw paṅqawu: Cornelius. ");
INSERT INTO hopNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Noqw pam put aw yórikqe, tsawnaqe, paṅqawu: Ya hímuu, Tutuyqawhqa? Noqw pam put aw paṅqawu: Uhnawakinpi, pu uhnuoktutmala ōmi yayvaniwhq, God put soon suhtokni. ");
INSERT INTO hopNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Noqw ōviy um hakimuy tahtaqtuy Joppat aqw ayataqw, hakiy Simon, Peter yan piw mātsiwhqat, wáṅwayyani. ");
INSERT INTO hopNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Pam hakiy pūvuk̇at pöhiwantaqat Simon amum qatuqw, put kīat pātuwaqatsit qalaveq wunu. Ason pam hin hintaniqat ūmi paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pu ōviy hoṅviaya Cornelius aw yuaaykuqa ahpiyniqw, pam lȫqmuy kiy ep tumal’aymuy wáṅwayi, pu solāwam put eṅem hihtayaniqe sutsep aw maqaptsi’yuṅqamuy amuṅaqw hak God k̇aptsi’taqat solāwa pīwu. ");
INSERT INTO hopNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nihqe pam pumuy sohsok īit āawnat, Joppat aqw hōna. ");
INSERT INTO hopNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Noqw qavoṅvaqw puma aqwyaqe, kīmi hayiṅwni’wisq, Peter nāwaknaniqe tāwanasave kits’omiq wūvi. ");
INSERT INTO hopNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Noqw pas pam tsöṅmokqe, as hihta nösniqey antaqw, nāto novalalwaqw, pam pay sawitoqwhinhti; ");
INSERT INTO hopNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nihqe ōmi hötsíltiqw tuwaqw, aṅqw himu wuyaqmötsapueway nālövaq tsukuveq som’iwk̇aṅw put aw hawtoqe, tutskwami hāwi. ");
INSERT INTO hopNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Noqw sohsoy hihtu tūwaqatsit aṅ nālöq hok̇ay’yuṅqam put ep íniwyuṅwa, pu tūtuvosiptu, pu hihtu hoyoyotinumyaqam pīwu, pu masay’yuṅqamu. ");
INSERT INTO hopNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Noqw hakiy tönaat put aw paṅqawu: Wunuptuu, Peter, um qöye’ nösni. ");
INSERT INTO hopNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Noqw Peter paṅqawu: Sóoni, Tutuyqawhqa; taq nu qa haq hihta pay qa pas hihtanihqat, pu qa powaiwtaqat nȫsa. ");
INSERT INTO hopNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Noqw hakiy tönaat piw put aw paṅqawu: God hihta powataqw, pam pay qa pas hímunihqat um qa paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Noqw i’ pāyis panhtiqw, himu mötsápueway ahoy ōmiq haqami wūvi. ");
INSERT INTO hopNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Noqw Peter hihta tuawyorikqey mātaq kurs pam hímunihqat pan wūwantaqw, ima tahtaqt Cornelius aṅqw ayatiwyaqam Simon haqam ki’taqat hakimuy tūviṅtotaqe, ihk̇aqe ṅö́yaknit aw hötsíwhpeq hōñi, ");
INSERT INTO hopNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nihqe sen hak Simon, Peter yan piw mātsiwhqat, pep qátuhqat tūviṅlalwa. ");
INSERT INTO hopNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Noqw nāt Peter tuawyorikiy aṅ wūwantaqw, Qahováriwtaqa Hikwsi put aw paṅqawu: Meh, hakim pahyom tahtaqt uṅ hepnumya. ");
INSERT INTO hopNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Oviy um wunuptut hāwe’, amumumni qa hin wūwank̇aṅwo; pay nu pumuy aṅqw hōna. ");
INSERT INTO hopNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pahsat pu Peter hakimuy Cornelius aṅqw put aw ayatiwyaqamuy amumi hawqe, paṅqawu: Taay, pay uma nuy hepnumya; sen hihta ōviy uma öki. ");
INSERT INTO hopNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Noqw puma paṅqaqwa: I’ Cornelius tsivót‐sikip súnatnihqamuy solāwamuy amumi moṅwi God aṅqw hoṅviayat pas hímunihqat ahpiy navota, yaw pam uṅ kiy aw wáṅwaye’, uṅ hin lavayhtiqw, put aw tūqaytaniqat hoṅviaya put aw paṅqawu. Pam tāqa súanta, pu God k̇aptsi’ta, pu Jew‐sinmuy sohsokmuy amuhpiy aw lomanavotiwta. ");
INSERT INTO hopNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pahsat pu pam pumuy taṅataqe pās oya; pu qavoṅvaqw pumuy amumum aqw’a; noqw haqawat tuptsiwni’yuṅqam Joppat aṅqw put ámumya. ");
INSERT INTO hopNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pu ōviy qavoṅvaqw puma Caesareat ep öki. Noqw Cornelius pumuy nuhtaytaqe, kurs sinomuy‐nik̇aṅw pu aṅ pas kwatsmuy tsovala. ");
INSERT INTO hopNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Noqw Peter aw pakitoqw, Cornelius ahsawvaqe, atpipo tamötswunuptut, pas put hihtata. ");
INSERT INTO hopNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Noqw pay Peter put wunuptsina, paṅqawk̇aṅwo: Wunuptuu, pay nu piw un sino. ");
INSERT INTO hopNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pu ōviy pam put amum yuaatak̇aṅw, aw pakiqw, sinom k̇aysiwhqam tsovawta. ");
INSERT INTO hopNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Noqw pam pumuy amumi paṅqawu: Pay pi uma navoti’yuṅqw, soon as hak Jew‐sínonik̇aṅw ayam supwat hihtuy sinmuy amu’puñalṅwu, piw amuminiṅwu. Noqw pay nu’ qa hakiy pay qa hímunihqat, pu qa powaiwtaqat paṅqawlawniqat God inumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Noqw ōviy nu qa rohomnumt, panis nuy wiktamayaqw, pay nu aṅq’ö; noqw hinoqw pi uma nuy wáṅwayya? ");
INSERT INTO hopNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Noqw Cornelius paṅqawu: Nālötok nu pew pahsavohaqam napwalni’taqe, tāwat atvelpetiqw nu ikiy ep nāwaknaqw, hak tāqa talqaqsalqat yuwsi’k̇aṅw inutpip wunuptu; ");
INSERT INTO hopNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nihqe paṅqawu: Cornelius, uhnawakinpi navotniwa; noqw God soon uhnuoktutmalay suhtokni. ");
INSERT INTO hopNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Um ōviy Joppat aqw hakimuy ayataqw, hakiy Simon, Peter yan piw mātsiwhqat, wáṅwayyani. Pam hakiy pūvuk̇at pöhiwantaqat kīyat ep qatu, pātuwaqatsit qalaveq’a; ason pam pite’, ūmi hin lavayhtini, kita. ");
INSERT INTO hopNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Noqw ōviy nu qa sȫwunit uṅ wáṅwayi; noqw um súanhtiqe pitu. Noqw ōviy hapi itam sohsoyam yep God atpip yēse, hin pam ūmi tutaptaqat sohsok nanaptaniqee. ");
INSERT INTO hopNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pahsat pu Peter lavayhtiqe paṅqawu: Pay kurs pas suyan God qa sinonuiña. ");
INSERT INTO hopNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pay kurs pas sohsokmuy hihtuy sinmuy amuṅaqw hak haqam put k̇aptsi’k̇aṅw súanhinmaqa put aw súantaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","God hapi Israel‐sinmuy amumi lavayiy távihqe, Jesus Christ ahpiy namivöhikiwuy yuaata. (Pam hapi sohsokmuy amumi tutuyqawi.) ");
INSERT INTO hopNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Pay uma put lavayit navoti’yuṅwa. Ura John kūyit akw tuvoylatiwyaniqat nuhtumi yuaataqw, pahpiy pam lavayi Galileet aṅqw hoyoyoykuk̇aṅw, Judeat aṅ ahsupoq yuaatiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ura God Nazareth aṅqw tāqat Jesus Qahováriwtaqat Hikwsit akw tuvoylataqe öqalmaqa. Ura pam sinmuy amuhpa’ lolmat tumalay’numa, pu Nukpanat ahpiy sóon’iwyuṅqamuy sohsokmuy powatima, God put ámumniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Noqw pam Jew‐sinmuy tutskwayamuy epnik̇aṅw, pu Jerusalem epeq hihta tumaltaqat itam hapi sohsok aw yóriki’yuṅqe, navoti’yuṅwa; noqw pay sinom himutskit ep put hahyaqe nīnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Noqw God pāyis talqat ep put ahoy tātaynaqe, put susmatakpuva mahtakna, ");
INSERT INTO hopNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nīk̇aṅw pay qa sohsokmuy sinmuy amumii, pay hakimuy aṅwu pay God namorstaqey pumuy amumii, itam put tuawi’yuṅwniqat ōviy’o. Noqw itam put mokiwuy aṅqw ahoy tātayhqat atsva put amum nōnova, pu hikwya. ");
INSERT INTO hopNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Noqw yaw itam sinmuy amumi put yuaatotaniqat pam itamuy ayata, pay yaw pas pam imuy yesqamuy, pu so’pumuy hinwat yukunaniqey God ahpiy aw taviwhqat itam yuaatotaniqata. ");
INSERT INTO hopNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Noqw put hapi sohsoyam God lavay’aymat yuaatotaqe paṅqaqwa, yaw hak put aw tupsiwhq, put qaanhtipuat Jesus natṅwaniyat akw put ahpiy ayo yukiwmantani. ");
INSERT INTO hopNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Noqw nāt Peter yan yuaataqw, pay Qahováriwtaqa Hikwsi lavayit nanaptaqamuy sohsokmuy amumi pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Noqw Jew‐sinmuy amuṅaqw tuptsiwni’yuṅqam Peter amum ö́kihqam hin kurs wūwaya, Qahováriwtaqa Hikwsi qa‐Jew‐sinmuy amumi enaṅ noiwhq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Puma hīhihtuy sinmuy amuhkwa yuaatotaqe, God pas hihtalalwaqw amumi tūqayyuṅqee. Pahsat pu Peter lavayhtiqe paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ya hak imuy kūyit akw tuvoylatiwyaniqw imuy amumi u’tani? Pay pi puma piw itamun Qahováriwtaqat Hikwsit makiwya. ");
INSERT INTO hopNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pu puma Tutuyqawhqat natṅwaniyat aṅ kūyit akw tuvoylatotiniqat pam amumi paṅqawu. Pahsat pu pam hihsavo pumuy amumum qátuniqat puma put aw nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Noqw yaw qa‐Jew‐sinom nuhtum God lavayiyat kwusuyaqat ayaiwyuṅqam, tuptsiwni’yuṅqamuy amumum Judeat ep yesqam nanapta. ");
INSERT INTO hopNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Noqw Peter Jerusalem aqwniqw, Jew‐sinmuy amuṅaqw tuptsiwni’yuṅqam put aqw hiṅqaqwaqe, ");
INSERT INTO hopNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Paṅqaqwa: Yaw um qa‐Jew‐sinmuy amumi pákihqe, amumum nȫsa. ");
INSERT INTO hopNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Noqw Peter pumuy amumi lavayhtiqe, aṅqaqw hin hiniwhtiqat nānaṅk pasiwtaqat pumuy amumi tuawi’taqe, paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ura nu kitsókit Joppat ep qátuk̇aṅw nāwakna; nihqe nu sawitoqhinhtiqe tuawyorikq, himu wuyaqmötsaput antaqa tsutskuy epeq sómiwk̇aṅw ōṅaqw hawtoqe, pas inumi pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Noqw nu aw yórikqe, pās tātayhq, pi tūwaqatsit ep hihtu popkot nālöq hok̇ay’yuṅqam put ep iniwyuṅwa, pu tūtuvostiptu, pu hihtu hoyoyotinumyaqamu, pu masay’yuṅqamu. ");
INSERT INTO hopNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Noqw nu hakiy tönayat navotq inumi paṅqawu: Wunuptuu, Peter, um qöye’ nösni. ");
INSERT INTO hopNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Noqw nu paṅqawu: Sóoni, Tutuyqawhqa; taq nu qa haq hihta pay nāp hihta, pu qa powaiwtaqat nȫsa. ");
INSERT INTO hopNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Noqw ōveqatsit aṅqw hakiy tönaat inumi piw paṅqawu: God hihta powataqw, pay pam qa pas hímunihqat um qa paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Noqw pāyis panhtiqw, pay sohsoy piw ōmiq láṅakniwa. ");
INSERT INTO hopNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Noqw pahsat pay kurs hakim pahyom tahtaqt Caesareat aṅqw inumi ayatiwyaqam nuy haqam kīve qátuhqat ep öki. ");
INSERT INTO hopNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Noqw pay nu qa hin wūwank̇aṅw, pumuy amumumniqat Qahováriwtaqa Hikwsi inumi paṅqawu. Noqw ima navay tuptsiwni’yuṅqam inumum aqwya; noqw itam tāqat kīyat aw yuña. ");
INSERT INTO hopNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Noqw yaw pam kiy ep hoṅviayat aw yorikq, yaw pam wunuk̇aṅw, put aw paṅqawhqat itamuy āawna. Um hakimuy tahtaqtuy Joppat aqw ayataqw, hakiy Simon, Peter yan piw mātsiwhqat, wáṅwayyani. ");
INSERT INTO hopNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ason pam uṅ lavayit āawnaqw, um put akw ayo yámakni, um’i, pu uhtimu, yaw hoṅviaya put aw kita. ");
INSERT INTO hopNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Noqw nu yuaativaqw, pay Qahováriwtaqa Hikwsi pumuy amumi pitu, ura mohti itamumi pítuhqey pan’i. ");
INSERT INTO hopNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Noqw pahsat pu nu Tutuyqawhqat lavayiat u’na, ura itamumi paṅqawu: Pay as pi John pas antsa kūyit akw tūtuvoylalawu; nīk̇aṅw uma hapi nāt it Qahováriwtaqat Hikwsit akw tuvoylatiwyani. ");
INSERT INTO hopNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Noqw puma Tutuyqawhqat Jesus Christ aw tūtuptsiwaqw, pep God hin itamuy put máqahqey, pay pan piw pumuy put maqa. Noqw ya nu hak hímunihqe God aw rohomnumni? ");
INSERT INTO hopNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Noqw puma it nanaptaqe, pay qa hiṅqaqwaqe, God pas hihtatotaqe, paṅqaqwa: Noqw yaw kurs qa‐Jew‐sinom nāp tunatyay aṅqw lasye’ yesniqat God piw amuṅem pan yuku. ");
INSERT INTO hopNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Noqw hakim Stephen nīniwhqat ahpiy tūokiwsahsantivayaqw aṅqe’ ahtsavalyaqam Phenicet aqw pahsavo öki, pu Cyprus aqw’a, pu Antioch aqw’a, nihqe pay Jew‐sinmuy‐sa amumi lavayit yuaatiwisa. ");
INSERT INTO hopNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Noqw pumuy amuṅaqw haqawat tahtaqt Cyprus aṅqwya, pu Cyrenet aṅq’ö; noqw puma Antioch epeq ö́kihqe, hakimuy Greek‐sinmuy amumi yuaaykuyaqe, Tutuyqawhqat Jesus lavayta. ");
INSERT INTO hopNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Noqw Tutuyqawhqat öqalaat pumuy amumumniqw, ōviy k̇aysiwhqam tūtuptsiwaqe, Tutuyqawhqat awwat lasya. ");
INSERT INTO hopNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Noqw Jerusalem epeq Jesus aw tōnawtaqam it nanaptaqe, puma Barnabas Antioch aqw hōnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Noqw pam epeq pituqw, kurs God núokwaat pumuy amuhpa’ tumalay’taqw, pam pan yórikqe, hahlayhtiqe, pas puma unaṅṅaqw su’qawk̇aṅw Tutuyqawhqat aw hūrs’iwyuṅwniqat pumuy öqalanta. ");
INSERT INTO hopNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Pam hak tāqa lolma, nihqe Qahováriwtaqat Hikwsit akw pās tuyqawiwta, pu qapēvewnit akw’a; noqw k̇aysiwhqam Tutuyqawhqat awwat sinototi. ");
INSERT INTO hopNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pahsat pu Barnabas Saul heptoqe Tarsust aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pu ōviy pam put túwahqe Antioch ep wikva. Noqw pantaqat atsve puma Jesus aw tōnawtaqamuy amumum sūkw yahsaṅwuy aṅ pep tsotsvalqe, k̇aysiwhqamuy sinmuy tutuqayna. Noqw tuptsiwni’yuṅqam Antioch epeq susmohti Christian‐sinom yan túṅwantiwya. ");
INSERT INTO hopNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Noqw ephaqam hakim God lavay’aymat Jerusalem aṅqwyaqe, Antioch epeq öki. ");
INSERT INTO hopNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Noqw pumuy amuṅaqw haqawa Agabus yan mātsiwhqa wunuptuqe, yaw tūwaqatsit aṅ ahsupoq wukotsöṅöstiniqat Qahováriwtaqat Hikwsit ahpiy paṅqawu. Noqw pam pantaqa hakiy Claudius Caesar moṅw’iwtaqw paniwhti. ");
INSERT INTO hopNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pahsat pu tuptsiwni’yuṅqam tuptsiwni’yuṅqamuy Judeat epeq ki’yuṅqamuy amumiq paaṅwnit o’yaniqey unaṅwtoti; hak hin hihta tuway’nume’ pan hihta kuwahtimantani. ");
INSERT INTO hopNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nihqe ōviy puma panhtotiqe, Barnabas‐nik̇aṅw, pu Saul pumuy aṅ pepeq wukw’a’yatuy amumiq put o’ya. ");
INSERT INTO hopNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Noqw ephaqam moṅwi Herod Jesus aw tōnawtaqamuy haqawatuy hintsanniqe amumi may’ta, ");
INSERT INTO hopNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nihqe pam John pāvayat James sipwuvahpit akw nīna. ");
INSERT INTO hopNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Noqw kurs pam panhtiqe, Jew‐sinmuy unaṅwve hinhtiqey navotqe, pahsat piw Peter ṅuaniqey anhti. (Noqw qapek̇én’oyiwhput ep nōviwniqat aw pitsíwiwta.) ");
INSERT INTO hopNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pu ōviy pam put ṅúahqe, sivikimi pánahqe, solāwamuy nālöp nānalöqmuy tōnawtaqamuy amumi put mātavi, put tūtuwalaniqat ōviy’o, ason pay pas Amutsva Yūmosanihqat ep nóviwniqat yukiltiqw, pep pu sinmuy amumi put hóroknaniqey tunatyawtaqee. ");
INSERT INTO hopNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Noqw ōviy puma Peter sivikive pani’yuṅwa. Noqw Jesus aw tōnawtaqam put eṅem God aw nāwakintotaqe qa nātusi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pu Herod qāvo put hóroknaniqey ep mihiqw, Peter lȫqmuy sivanamiqlölöt akw sómiwk̇aṅw lȫqmuy solāwatuy amuhtsava pūwi; noqw tuwalan’a’yat ihpaq tūtuwala. ");
INSERT INTO hopNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Noqw meh, Tutuyqawhqat hoṅviayaat pituqw, sivikive sohsovik tālawva; noqw pam Peter sutsṅaqwat pálaknaqe, put tātaynat, aw paṅqawu: Suqtuptuu. Noqw sivanamiqlölö put māyat aṅqw löhö. ");
INSERT INTO hopNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Noqw hoṅviaya put aw paṅqawu: Kwewhtat totsvakii; noqw pam panhti. Pu pam paṅqawu: Um usíhtat, inuṅkni. ");
INSERT INTO hopNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Noqw pam yámakqe put aṅk’i; nihqe pay pas antsa hoṅviaya put pantsanhqat pam qa suyan navoti’ma; suhpan pay tūawtaqey pam wūwanma. ");
INSERT INTO hopNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Noqw puma mohpeq tūwalaqamuy‐nik̇aṅw pu amuṅk tūwalaqamuy amuhpiy ruhpakqe, kīmi hötsíwat aqw sivauutspit aw pituqw, pam nāp amumi hötsílti. Noqw pam paṅqw yámakqe, haqe’ kisk̇at aṅ yamakq, pahsat pu hoṅviaya put aṅqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Noqw Peter suyan unaṅwtiqe paṅqawu: Pu’ hapi nu pas suyan navoti’taqw, pay kurs pas antsa Tutuyqawhqa hoṅviayay ayataqe, nuy Herod māyat aṅqw ayo tavi, pu Jew‐sinom nuy hintsatsnayaniqey tunatyawyuṅqat aṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pu ōviy pam it aṅ pās wūwaqe, pahsat pu hakiy John, Mark yan piw mātsiwhqat yuyat Maryt kīyat aw’i, noqw k̇aysiwhqam pep tsovawk̇aṅw nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Noqw Peter ihk̇aqe ṅö́yakiwtaqat ep hötsíwat aw pöṅö́ṅöykinaqw, hak māna Rhoda yan mātsiwhqa put aqw kuyvato. ");
INSERT INTO hopNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nihqe pam Peter töṅayat māmatsqe, pas hin unaṅwtiqe aqw qa hötat, ahpami wárikqe, Peter hötsíwhpeq wúnuhqat pumuy āawna. ");
INSERT INTO hopNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Noqw puma aw paṅqaqwa: Um qa navoti’numa. Noqw pam qatūqayk̇aṅw, pas antsa Peter pep wúnuhqat amumi paṅqawu. Noqw pahsat puma paṅqaqwa: Pay soon qa put tumalay’maqa hoṅviayani. ");
INSERT INTO hopNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Noqw pas Peter pöṅö́ṅöytoynaqw, ōviy puma aqw hötayaqe, put aw tātayyaqe, pas hin unaṅwtoti. ");
INSERT INTO hopNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Noqw pay puma qa hiṅqaqwaniqat pam amumi māmasaqw, pahsat pu Tutuyqawhqa hin put sivikiṅaqw hóroknaqat pam pumuy amumi lalvaya; nihqe paṅqawu: Uma īit yantaqat James aw tūawwisni, pu tuptsiwni’yunqamuy amumii, kita; nit paṅqw ahpiynihqe haqamiwat aw’i. ");
INSERT INTO hopNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pu ōviy panis tālawvaqw, pas solāwam hin unaṅwtoti, Peter kurs haqaminiqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Noqw as Herod put hept, qa túwahqe tūtuwalaqamuy amumi put ep hēva; nihqe pay pas puma so’niqat paṅqawu. Panhtit pam Judeat aṅqw Caesareat aqwnihqe, pepeq huruhti. ");
INSERT INTO hopNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Noqw Herod Tyre‐nik̇aṅw pu Sidon ep sinmuy amumi hihta ep qayan unaṅway’ta; noqw puma sun unaṅway put aw ö́kihqe, hakiy pas moṅwit tumalay’taqat Blastus yan mātsiwhqat pan unaṅwtoynayaqe, puma nānami qahin unaṅway’yuṅwniqat moṅwit aw nānawakna, puma pep tutskwat ep sinom moṅwit tutskwayat aṅqw nōnovaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Noqw hisat aw talöṅvaqw, Herod pavan pas moṅwyuwsi’k̇aṅw moṅw’atsveway ep qatuptuqe, pahsat pu sinmuy amumi pavan pas lavayhtuwiy pan yuaayku. ");
INSERT INTO hopNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Noqw sinom sáakmaqe paṅqaqwa: Pas pam pavan hihta tönaata, qa sínota. ");
INSERT INTO hopNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Noqw pahsat pay Tutuyqawhqat hoṅviayaat put wuvahta, pam God qa hihtataqw ōviy’o; noqw pam āvutiqe súlawhti. ");
INSERT INTO hopNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Noqw tuwat God lavayiat öqawhtaqe, suyhtsepṅwat aṅqe’ kúrukiwma. ");
INSERT INTO hopNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Noqw Barnabas Saul amum hin ayatiwhqey yúkuhqe, hakiy John, piw Mark yan mātsiwhqat wikk̇aṅw, Jerusalem aṅqw ahoy pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Noqw Antioch epeq Jesus aw tōnawtaqamuy amuṅaqw hakim God lavay’aymat yēse, pu tūtutuqaynayaqamu, i’ hak Barnabas, pu Simeon Niger yan túṅwantiwhqa, pu Cyrenet aṅqw hak Lucias; pu Manaen, Moṅwi Herod amum wuṅwqa; noqw Saul. ");
INSERT INTO hopNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Noqw nāt puma Tutuyqawhqat aw okiwlalwak̇ahk̇aṅw, nānapwalaqw, Qahováriwtaqa Hikwsi amumi paṅqawu: Nu Barnabas‐nik̇aṅw pu Saul hihta tumalat aw pumuy wáṅwayhq, uma pumuy inuṅem ayo taviyani. ");
INSERT INTO hopNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Noqw puma nānapwalaqe, amuṅem nānawaknat, pumuy qötömi matyawyat, pahpiy pumuy lālayya. ");
INSERT INTO hopNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Noqw ōviy puma Qahováriwtaqat Hikwsit ahpiy ayatiwhqe, Seleuciat aw’i, nit paṅqw pu pāvaqe Cyprus aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Noqw puma Salamis ep pítuhqe, Jew‐sinmuy tsotsvalkiyamuy ep God lavayiyat nuhtumi yuaata. Noqw puma John tu’sawwiknuma. ");
INSERT INTO hopNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Noqw puma it tutskwat pāṅaqw kuytaqat aṅ ahsupoq nankwusaqe, Paphos aw ö́kihqe, hakiy Jew‐sinot Bar‐Jesus yan mātsiwhqat tutwa. Pam hak tuhisay akw tūhintsakni’ta, pu God lavay’ayaatnihqey pan atsáy’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Pam hak pep tutskwat aw moṅw’iwtaqat, Sergius Paulus, pas qa ūnat amum hinnuma; noqw moṅwi Barnabas Saul enaṅ wáṅwayhqe, God lavayiyat navotniqey nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Noqw hak Elamus tuhisa (put natṅwaniat Tuhisa i’nihqe pam’i) pumuy amumi rohomhtiqe, moṅwit lomatuawit aw tuptsiwnit aṅqw ayo lasnaniqey anhti. ");
INSERT INTO hopNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pahsat pu Saul (piw Paul yan mātsiwhqa) Qahováriwtaqat Hikwsit akw tuyqawiwk̇aṅw put aw taynumt, ");
INSERT INTO hopNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Aw paṅqawu: Is ohi, um hak sohsok unatwit, pu nukpantuwit akw ahsaliwtaqa, Nukpanat tíata, sohsok súantsakpit tuwqaata! Ya pas um soon Tutuyqawhqat haqe’ suan pöhtaviyat nukushintsahtsanqey qe’tini? ");
INSERT INTO hopNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Taay, Tutuyqawhqa hapi ūmi may’ta; noqw uhposi qatālawvaqw, um hihsavo tāwat qa tuway’tani. Noqw pahsat pay put aṅ himu pamös’ohpoqw, pōsiat qatālawva. Noqw as hak put ṅuy’maniqat ōviy pam aṅqe’ may’numa. ");
INSERT INTO hopNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pahsat pu moṅwi hin hiniwhtiqw yórikqe tuptsiwa, hin Paul put Tutuyqawhqat tutuqaynaqat ep k̇ātuqaytaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Noqw Paul suṅwámuy amumum Paphos aṅqw ahpiynihqe, pāvaqe Pamphiliat ep Pergat aw pitu; noqw John pumuy mātapt, ahoy Jerusalem aqwhaqamii. ");
INSERT INTO hopNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Noqw puma Pergat aṅqw ahpiynihqe, Pisidiat ep Antioch aw pítuhqe, nasuṅwintalöṅnit ep tsotsvalkimi pakit, ep qatuptu. ");
INSERT INTO hopNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Noqw hak tutavot aṅ‐nik̇aṅw pu God lavay’aymuyatuy pēniyamuy aṅ túṅwantaqe yukuqw, tsotsvalkit ep momṅwit pumuy amumi hakiy ayatotaqe paṅqaqwa: Uma tāqat itahsinomu, uma sinmuy amumi hihta lavayhte’, öqalanik panhtini. ");
INSERT INTO hopNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pahsat pu Paul wunuptut, amumi māmasat, paṅqawu: Uma Israel‐sinom tahtaqtu, pu uma itamun God aw nāwakinwisqamu, kurs uma inumi tuqayvastotani. ");
INSERT INTO hopNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","I’ hapi Israel‐sinmuy aw yantaqaam God hakimuy itanamuy namorstaqe, pumuy pas pavan sinota, nāt puma haqam Egypt epeq hinnumyaq’ö; nihqe öqalay pas qaöwíhintaqat akw pumuy paṅqw nö́ṅakna; ");
INSERT INTO hopNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nihqe lȫp sunat yahsaṅwuy pahsavohaqam qayēsiwhpuve pumuy qatsíyamuy aṅ maqsonlawu. ");
INSERT INTO hopNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nihqe pam Chanaan tutskwat ep tsaṅe’sikipwat hihtuy sinmuy kīqötaqe, tutskwayamuy sinomuy amumi noa. Noqw puma hihta navöewakw antaqat akw tutskwat nāhuyta. ");
INSERT INTO hopNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Pantaqat atsve pu’ pam pumuy amumi qaqlehtaqtuy moṅw’oya, sunat‐sikip sunat‐nik̇aṅw aṅqw lȫp sunat pakwt sihk̇ay’taqat (450) yahsaṅwuy pahsavohaqamii, lavay’ayay Samuel aw pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Pantaqat aṅk pu’ puma hakiy pas moṅwit moṅwí’yuṅwniqey tuṅlayhtoti. Noqw God hakiy Kish tiyat Saul yan mātsiwhqat, Benjamin ahpiyvinihqat, pumuy amumi moṅwtavi, lȫp sunat yahsaṅwuy pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nit pu pam put moṅwqenit aṅqw ayo távihqe, hakiy David pumuy amumi moṅwtavi; nihqe put pam yan lavayhti: Pas nu Jesset tiyat David iunaṅwve hintaqat tuwa; noqw pam sohsok itunatyay aṅ aw antsanni. ");
INSERT INTO hopNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","It tāqat hapi ahpiyviyatuy amuhpiy God Israel‐sinmuy Ayo Oyaniqat wunuptsina, it Jesus, hin lavayhtiqey pan’i. ");
INSERT INTO hopNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nāt pam qa pituqw, hak tāqa John yan mātsiwhqa sohsokmuy Israel‐sinmuy amumi yuaataqe paṅqawu: Uma umuhtunatyay aṅqw ayo lasye’, kūyit akw tuvoylatotini. ");
INSERT INTO hopNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Noqw pam ayaway aṅ kuyvani’maqe paṅqawu: Uma k̇a nu God lavay’ayaat pas hímunihqat pan wūwantota. Nu qa pam’i. Noqw pay nāt suhk̇a aṅqw inuṅki; noqw soon nu yan’ewaynīk̇aṅw pay ṅas’ew put tōtsiyat ṅahni, John amumi kita. ");
INSERT INTO hopNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Uma tahtaqtu, isinomu, Abraham natkomatu, pu uma itamun God aw nāwakinwisqamu. Nu pu’ umuy hin ayo nö́ṅakniqat umuy āawnani. Put lavayit nu umumi mātapni. ");
INSERT INTO hopNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem epeq ki’yuṅqam moṅwímuy amumum Jesus qa māmatsya. Nihqe ōviy God lavayiyat aw antsanyaqe put tūvaya, puma pi put lavayit qa mātsi’yuṅqee, nāmahin pi aṅsakis nasuṅwintalöṅnit aṅ God lavay’aymuyatuy lavayiyamuy aṅqw hak pumuy amumi aṅ as túṅwantaṅwuniq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Puma put mokniqey hihk̇ay’taqat kurs hin pas antsa paṅqaqwani. Nīk̇aṅw puma Pilate put nīnaniqat aw qatūqayya. ");
INSERT INTO hopNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ura tutuvenit aṅ puma pan put hintsatsnaniqat pan pey’ta. Noqw puma yan tutuvenit an sohsok hinhtotiqw, hakim nahoylehtsit aṅqw put hawnayat, tuamhtuhsömiq put panaya. ");
INSERT INTO hopNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Noqw God mokiwuy aṅqw put ahoy tātayna. ");
INSERT INTO hopNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Noqw hakim tahtaqt put amum hinnumya, Galileet aṅqw Jerusalem aqw pahsavoo. Noqw pam ahoy tātayhq, puma wūhakis tālat aṅ put aw yorstota. Nihqe puma hapi hin yórikyaqey sinmuy amumi tuawi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Noqw itam hapi it lomatuawit umuy āawnaniqe ōviy pitu. Ura God itanamuy amumi hin pasiwnaqey ");
INSERT INTO hopNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Pu’ hapi itamuy pumuy tímuyatuy itamuṅem put aṅ aw antsana, Jesus ahoy tātaynaqee. Ura tāwit mohti’maqat aṅknihqat aṅ yan pey’ta: Um hapi Itii. It talöṅvaqat ep hapi nu únaniwhti, yan’i. ");
INSERT INTO hopNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Pu God mokiwuy aṅqw put ahoy tātaynaqe pāpu qa hovahtiniqat lavayhtiqe, yan hiṅqawu: Nu David pas suyan ōkwatuwniqey put aw pasiwnaqey pan nu uṅem yúkuni. ");
INSERT INTO hopNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yantaqw hapi ōviy ura pam piw sukw tāwit aṅ paṅqawu: Um soon Uhtumal’ayay Qahováriwtaqat hovahtiniqat nakwhanani. ");
INSERT INTO hopNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David pi God tunatyayat ahpiy qatsívaptsiy ep apitiqe, mokqe, namuy amumum taviwa, nihqe hovahti. ");
INSERT INTO hopNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Noqw God it tāqat hapi ahoy tātaynaqw, pam qa hovahti. ");
INSERT INTO hopNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Noqw ōviy uma it nanaptani, tahtaqtu, isinomu: It tāqat hapi ahpiy God itamumi pö́hi, itahqaanhtipuy ep’e. ");
INSERT INTO hopNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ura Moses tutavoyaat kurs hin itahqaanhtipuy itamuhpiy ayo yúkuni. Nīk̇aṅw kurs itam Jesus aw tūtuptsiwhq, pam sohsok put itamuhpiy ayo yúkuni. ");
INSERT INTO hopNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Ura God lavay’aymuyatuy pēniyamuy aṅ yan pey’ta: Kurs huvam yórikyaa, hihta aṅ tutsiw’unaṅway’yuṅqamu. Nen uma k̇ātayuṅwt, súlawhtini. Nu hapi umuhqatsiy ep hihta hintsakni; noqw soon uma put tūtuptsiwani, nāmahin pi as hak umuy put āwintani. Taay, noqw ōviy uma tunatyaltotini; taq nāphisat sen uma put lavayit an súlawhtini. ");
INSERT INTO hopNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Noqw pam lavayyukuqw, Jew‐sinom tsotsvalkiṅaqw nöṅakq, pay ayo’wat nasuṅwintalöṅnit ep piw Paul amumi yuaataniqat qa‐Jew‐sinom nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Noqw tsovawtaqam nāmatatveqw, k̇aysiwhqam Jew‐sinom‐niqw pu pumuy amún tuptsiwni’yuṅqam Paul‐nik̇aṅw, pu Barnabas pumuy amuṅkya; noqw puma pumuy amumi yuaaykuqe, God nuokwayat aṅ yūmosa hinwisniqat aṅ öqalanta. ");
INSERT INTO hopNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pu ayo’wat nasuṅwintalöṅnit aw pituqw, pēp pas sohsoyam kīve ki’yuṅqam God lavayiyat aw tūqayyuṅwniqe tsovalti. ");
INSERT INTO hopNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Noqw Jew‐sinom qaan’ewakw hintaqamuy sinmuy amumi yórikyaqe, pay qa tsuyhtiqe, Paul hihta lavayhtiqat ehpewi nānaphin yuaativaya. ");
INSERT INTO hopNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pahsat pu Paul Barnabas amum a’nö unaṅwtiqe paṅqawu: Pay as pi God lavayiat kurs hin qa umumi mohti yuaatiwni; noqw pi uma put nahpiy tūvayaqe, qatsit qa so’taqat qa hihk̇ay’yuṅqey pan nāyukunayaqw, ōviy itam hapi qa‐Jew‐sinmuy amumiwat yuaatani. ");
INSERT INTO hopNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Pi pan hapi Tutuyqawhqa itamumi tutapta pi pam Jesus yan lavayhtiqe paṅqawu: Um hapi qa‐Jew‐sinmuy amuṅem tālaniqat nu uṅ ayata, tūwaqalvoqhaqami yesqam sinom uhpiy ayo nö́ṅakiwniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Noqw qa‐Jew‐sinom it nanaptaqe, hahlayk̇ahk̇aṅw God lavayiyat pas hihtatota; noqw hakim hihsa’nihqam qatsit qa so’taqat aw himuy’vayaniqey namorstiwyaqam tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Noqw Tutuyqawhqat lavayiat pep tutskwat aṅ ahsupoq yuaatiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Noqw pay Jew‐sinom pavansinmuy tahtaqtuy, pu ima momoyam God pas k̇aptsi’yuṅqamuy hin unaṅtoynayaqe, Paul‐nik̇aṅw pu Barnabas pumuy okiwsahsantivaya, nihqe tutskway aṅqw pumuy lālayya. ");
INSERT INTO hopNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Noqw puma kuhkuy aṅ qöat pumuy amunkiwakw tsatswit, Iconium aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Noqw Antioch ep tuptsiwni’yuṅqam yūmosa hahlayya, pu Qahováriwtaqat Hikwsit akw tuyqawiwyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Noqw puma Iconium ep Jew‐sinmuy tsotsvalkiyamuy aw nāma pákihqe, pas pavan yuaataqw, ōviy k̇aysiwhqam Jew‐sinom Greek‐sinmuy amumum tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Noqw pay qa tuptsiwni’yuṅqam Jew‐sinom qa‐Jew‐sinmuy hin unaṅwtoynayaqe, aṅ tuptsiwni’yuṅqamuy amuhpewi pumuy qalomáwuwnitoynaya. ");
INSERT INTO hopNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Noqw ōviy puma pep wūyavo qátuhqe, Tutuyqawhqat aw yank̇aṅw, qa tuhtusk̇aṅw yuaata; noqw pam lavayi put núokwayat yuaataqa pas antsanihqat Tutuyqawhqa mahtakni’ta, pumuy māyamuy ahpiy k̇ātatayhpit hihta tuawi’yuṅqat hintsakqee. ");
INSERT INTO hopNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Noqw kīve sinom nātsiki, pētu Jew‐sinmuy amumumyaqw, pu pētu ayaiwtaqamuy amumumya. ");
INSERT INTO hopNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Noqw qa‐Jew‐sinom‐niqw, pu Jew‐sinom, moṅwímuy amumum pumuy okiwsasnaniqey, pu tatatupninayaniqey pasiwnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Noqw ayaiwtaqam put navotqe Lyconiat ep kitsókituy Lystrat‐nit pu Derbyt pumuy aw wāya, pu ahpiy ánan’ik tutskwat aw’i, ");
INSERT INTO hopNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nihqe paṅ puma lomatuawit yuaatinuma. ");
INSERT INTO hopNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Noqw hak tāqa Lystrat ep qatu; pam hak kukveq hintaqe qa hisat nakwsu, pay yaw pas pam pank̇aṅw tihtiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Noqw Paul yuaataqw, i’ tāqa put aw tūqayta. Noqw Paul put aw‐sa tayk̇aṅw, qalaptsiniwniqey qapēvewnaqat put aw túwahqe, ");
INSERT INTO hopNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pahsat put aw a’nö paṅqawu: Wunuptuu, kita; noqw pam suṅwnuptut nakwsu. ");
INSERT INTO hopNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Noqw Paul pep put hintsanqw, sinom aw tātayyaqe, pahsat pu Lyconiat ep sinmuy amuhkwa a’nö paṅqaqwa: Kurs itam hīhihtuy amuhpa’ nāwakinwisq, puma sinmuy amún tokoy’k̇aṅw itamumi hāwi, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nihqe puma Barnabas Jupiter yan tuṅwáya, nit Paul Mercurius yan’i, pamwa pas yuaataqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pahsat pu kitsókit hötsíwhpeq Jupiter awwat moṅwi wakastahtaqtuy tsamk̇aṅw, sinṅölat hötsíwhpeq kívahqe, as sinmuy amumum ayaiwtaqamuy amumi hom’oyni. ");
INSERT INTO hopNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Noqw ayaiwtaqam Barnabas pu Paul puma put navotqe nahpa’ yuwsiy tsīk̇at sinmuy amuhpa’ wawarstinumk̇aṅw, ");
INSERT INTO hopNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","A’nö paṅqawnuma: Soh, tahtaqtu, Ya uma hinoqw yanhaqam hintsatsk̇a? Pay itam piw sínotnik̇aṅw umuntaqat unaṅway’ta, nihqe uma it āan’ewakw aṅqw it God taytaqat aw lasyaniqat itam umumi yuaata, ōveqatsit, pu tūwaqatsit, pu pātuwaqatsit‐nik̇aṅw pu aṅhqe sohsokmuy hihtuy yesqamuy yúkuhqat aw’i. ");
INSERT INTO hopNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pay as pi pam hisatṅahaqaqw aṅ sohsokmuy nanāpwatuy sinmuy tuwiy aṅ hinwisniqat aw noi’ta, ");
INSERT INTO hopNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nīk̇aṅw pam hak hímunihqat himu put tuawi’taniqat pam ayo qa yúkuhqe ōviy lolmat hintsaki, nihqe itamuṅem ōṅaqw yoknaṅwu, pu itamuṅem tal’aṅwnawit hihta aniwnaṅwu, nen itah’unaṅway nȫsiwhqat, pu hahlayhpit akw hahlaytapnaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yan puma hiṅqawk̇aṅw híhinhaqam pumuy áṅwutaqw, ōviy puma pumuy amumi qa hom’o’ya. ");
INSERT INTO hopNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Noqw hakim Jew‐sinom Antioch aṅqw‐nik̇aṅw pu Iconium aṅqw ö́kihqe, sinmuy hin unaṅwtoynayaqe, Paul tatatupya; nihqe kīṅaqw put haqami lölökintota, mokqat wūwayaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Noqw tuptsiwni’yuṅqam okiw put aw ṅö́yakiwk̇ahk̇aṅw aṅ hoṅqw, pam wunuptuqe kīmii. Nihqe qavoṅvaqw pam Barnabas amum paṅqw Derbet aw’i, ");
INSERT INTO hopNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nihqe puma pep kitsókit ep nuhtumi lomatuawit yuaataqe k̇aysiwhqamuy tutuqaynat, ahoy Lystrat aw’i, pu Iconium aw’i, pu Antioch aqw’a; ");
INSERT INTO hopNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nihqe tuptsiwni’yuṅqamuy unaṅwayamuy hūrs hōñinmak̇aṅw, puma qapēvewnit aṅ yūmosa hinwisniqat pumuy öqalanma, nāmahin pi as puma put ep k̇ānanvotyaniq’ö. Pi pan hapi itam God moṅwtunatyayat aw yuṅni, amumi kita. ");
INSERT INTO hopNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pu puma Jesus aw tōnawtaqamuy amuhpa’ ahsupoq nakwsuqe, hakim pumuy wukw’aymatniqat aṅ pumuy oyahtat, napwalni’k̇aṅw, nāwaknaqw, Tutuyqawhqat aw pumuy mātavi, hakiy aw tuptsiwyaqat aw’i. ");
INSERT INTO hopNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pu puma Pisidiat aṅ kuyvaqe, Pamphyliat ep pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nit puma Pergat ep lavayit nuhtumi yuaatat, pahpiy Attaliat aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nit paṅqw pu puma pāvaqe Antioch aqw’a. Paṅqw ura puma God núokwayat aw mātaviwa, it tumalat pu’ aṅ kuyvaqe hinhtiniqey ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Noqw puma pepeq pítuhqe, Jesus aw tōnawtaqamuy tsovala; nihqe God pumuy akw hihta tumaltaqat sohsok pumuy amumi tuawi’ta, pu hin pam qa‐Jew‐sinmuy amuṅem tuptsiwnit aw hötahqata, ");
INSERT INTO hopNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nihqe pepeq puma tuptsiwni’yuṅqamuy amumum wūyavo qatu. ");
INSERT INTO hopNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Noqw hakim Judeat aṅqw ö́kihqe, tuptsiwni’yuṅqamuy tutuqaynayaqe paṅqaqwa: Pas uma Moses tuwiyat an poṅotkit akw qa tuvoylatote’, soon ayo nö́ṅakni, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Noqw Paul Barnabas amum pumuy pas qa amuhpa’taqe, amumum put ep pas nāmi heptaqw, yaw turs Paul‐niqw pu Barnabas, puma pētuy amumum it ep Jerusalem aqwyani, ayaiwyuṅqamuy‐nik̇aṅw, pu wukw’a’yatuy amumiq’a. ");
INSERT INTO hopNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pu ōviy Jesus aw tōnawtaqam paṅqw hihsavo pumuy amumumyaqw, puma pahpiy Phenicet aṅ hinwisa, pu Samariat aṅ’a; nihqe qa‐Jew‐sinom Tutuyqawhqat aw lasyaqat nuhtumi yuaatiwisqe, sohsokmuy tuptsiwni’yuṅqamuy pas pavan hahlayhtapnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Noqw puma Jerusalem epeq ökiqw, Jesus aw tōnawtaqam pumuy pās o’ya, pu ayaiwyuṅqamu, pu wukw’a’yatu; noqw God pumuy amuhpa’ hihta tumaltaqat puma sohsok pumuy āawna. ");
INSERT INTO hopNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Noqw haqawat tūtuptsiwaqam pi Pharisee‐sinmuy amuṅaqwya. Nihqe puma hoṅvaqe, pas kurs hin ima qa‐Jew‐sinom poṅotkit akw qa tuvoylatotiniqat paṅqaqwa, pu pay pas puma Moses tutavoyat aṅ hinwisniqat amumi paṅqaqwaniqata. ");
INSERT INTO hopNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Noqw ayaiwyuṅqam‐niqw, pu wukw’a’yat it aw hin wūwayaniqe tsovalti. ");
INSERT INTO hopNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Noqw it yantaqat ep nan’ivaqw wūyavo yuaatotaqw, pahsat pu Peter wunuptuqe, pumuy amumi paṅqawu: Uma tahtaqtu, isinomu, pay pi uma navoti’yuṅqw, ura God itamuṅaqw nuy namorstaqw, pay ahpiy wūyavoti, ura qa‐Jew‐sinom inuhpiy it lomatuawit nanapte’, tūtuptsiwaniqata. ");
INSERT INTO hopNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Noqw God aṅ u’naṅwat aw navoti’taqa pumuy hahlayhtiqey mahtaknaqe, it Qahováriwtaqat Hikwsit pumuy maqa, put itamuy hin máqahqey pan’i. ");
INSERT INTO hopNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nihqe pam sun nan’ivo itamuy tumaltaqe, tuptsiwniyamuy ahpiy pumuy unaṅwayamuy kwaṅw’ewakwta. ");
INSERT INTO hopNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Taay, noqw ya uma hinoqw God aw heptota? Soñawnen pi uma tuptsiwni’yuṅqamuy hihta a’nö putut īkwiltotoynaya, pay pi itanam, pu itam put aṅ qa kūyuṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pay itam piw pumuy amún Tutuyqawhqat Jesus Christ núokwayat ahpiy ayo nö́ṅakniqey tuptsiwni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pahsat pu sohsoyam tsovawtaqam qa hiṅqaqwaqe pās tūqayyuṅqw, Barnabas Paul amum tuawi’taqe, hin God qa‐Jew‐sinmuy amuhpa’ k̇ātatayhpit hihta tuawi’yuṅqat tumaltaqat pumuy amumi lalvaya. ");
INSERT INTO hopNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pu ōviy puma yuaataqe yukuqw, James lavayhtiqe paṅqawu: Tahtaqtu, isinomu, kurs huvam inumi tuqayvastotaa. ");
INSERT INTO hopNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","God qa‐Jew‐sinmuy amuṅaqw nēṅem sinmuy wáṅwayniqe ōviy pay mohti amuhpe pítuhqat Simeon paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Noqw pan hapi God lavay’aymat hin lavayhtotiqe, yan pēnaya: ");
INSERT INTO hopNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ason it atsva pu’ nu pite’, David tímuyatuy kīhut sahpukiwtaqat anyuṅqamuy aw ahoy yúkuni; pu nu kīqöyat aw ahoy kītani; pu nu put ahoy wunuptsinani. ");
INSERT INTO hopNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Noqw ahpiy mímawat sinom Tutuyqawhqat hepyani, pu sohsoyam qa‐Jew‐sínomu. Pi nu pumuy isinomniwhtotiniqat umuy enaṅ namorsta, kita Tutuyqawhqa sohsok īit hihta hintsakqa. ");
INSERT INTO hopNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Pi God hintsakniqey qatsit yayhniwhqat paṅqaqw sohsok aṅwu pay tuway’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Noqw ōviy nuyniqw pay itam qa‐Jew‐sinmuy amuṅaqw God aw lasyaqamuy qa hin u’naṅwnayani. ");
INSERT INTO hopNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nīk̇aṅw pay itam amumi pēnayaqw, puma nȫsiwhqat nāp yukit aw noiwhqey akw hovarsqat qa aw hintsatsk̇ani, pu tokot qa sokoplalwani, pu hihta hikwísmokqat qa aṅqw nȫnösani, pu úṅwat qe’yani. ");
INSERT INTO hopNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Taq hisatṅahaqaqw ahsupoq kitsókit aṅ hakim Moses tutavoyat yuaatotaṅwu. Aṅsakis nasuṅwintalöṅnit ep tsotsvalkiva put pēniyat aṅ tuṅwáyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pahsat pu ima ayaiwyuṅqam, wukw’a’yatuy‐nik̇aṅw pu sohsokmuy Jesus aw tōnawtaqamuy amumum nāṅaqw hakimuy namorstotaqe, puma Barnabas‐nik̇aṅw pu Paul pumuy amumum Antioch aqwnihqat puma pan yukuya; nihqe imuy namorstota: it hakiy Judas, Barsabas yan piw mātsiwhqata, pu piw Silas, hakim tuptsiwni’yuṅqamuy amuṅaqw pávannihqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Noqw puma yan tutuvenit pumuy amuhpiy yawma: Ima ayaiwyuṅqam, pu wukw’a’yat, pu tuptsiwni’yuṅqam, Jerusalem ep tsovawtaqam, ayam Antioch, pu Syriat, pu Ciliciat ep qa‐Jew‐sinmuy amuṅaqw tuptsiwni’yuṅqamuy öqalaya. ");
INSERT INTO hopNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Itam nanaptaqw, yaw hakim itamuṅaqw nankwusaqam lavayit akw umuy hin u’naṅwnayaqe, umuh’unaṅway lahsintota paṅqaqwaqee: Pas uma kurs hin poṅotkit akw qa tuvoylatiwyani, pu Moses tutavoyat aṅ hinwisni, kitota. Pay as pi itam amumi qa pan tutaptota. ");
INSERT INTO hopNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Noqw itam tsovaltiqe, yan sun wūwaya: Itam hakimuy namorstotaqe, aw itah’unaṅwamuy Barnabas‐nik̇aṅw pu Paul pumuy enaṅ umumiq taviyaniqw pam itamuyniqw súanta. ");
INSERT INTO hopNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ima tāqat Itahtutuyqawhqay Jesus Christ eṅem qatsiy tatamhta. ");
INSERT INTO hopNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Noqw ōviy itam Judas, Silas enaṅ umumiq taviya; ason puma pas nāp umuy put pantaqat āawnani. ");
INSERT INTO hopNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Pay itam it hihta pas soon qe’niqat put‐sa umumi tutaptotaniqw, pam pantaqa Qahováriwtaqat Hikwsit aw súanta, pu itamumii, ");
INSERT INTO hopNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","It’a: Uma hihta nȫsiwhqat nāp yukit aw noiwhqat qe’yani, pu úṅwata, pu hihta hikwísmokqata, pu tokot qa sokoplalwani. Uma yan hinwise’ suan hinwisni. Hakim ö’qalyaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Noqw ōviy puma paṅqw ayatiwyaqe, Antioch epeq öki; nihqe sinmuy tsovalayaqe, amumi tutuvenit taviya. ");
INSERT INTO hopNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Noqw puma put aṅ tuṅwáyaqe hahlayhtoti, pumuy öqalayaqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Noqw Judas, Silas amum, pay piw pas nāp God lavay’aymatnihqe wūhaq lavayit akw tuptsiwni’yuṅqamuy u’nanaqe pumuy hūrs hoṅna. ");
INSERT INTO hopNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pu ōviy puma pepeq hihsavo qatuqw, tuptsiwni’yuṅqam pumuy öqalayat, ayaiwyuṅqamuy amumiq hōnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Noqw pay Silas hāk pep huruhtiniqey nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Noqw Paul Barnabas amum Antioch epeq piw huruhtiqe, Tutuyqawhqat lavayiyat tūtutuqayna, pu nuhtumi yuaata, hakimuy wūhaqnihqamuy amumuma. ");
INSERT INTO hopNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pu ahpiy pantaqw, Paul Barnabas aw paṅqawu: Himu as kurs itam haqe’ kitsókiva Tutuyqawhqat lavayiyat yuaaykuqey aṅqw itahtupkomuy amuhpa’ pohtani, hinpi aṅqe’ hinyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Noqw Barnabas John, Mark yan piw mātsiwhqat, wikniqey pas su’qawta. ");
INSERT INTO hopNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Noqw Paul u’naqw, ura pam Pamphyliat ep pumuy mātapqe, ahpiy qa amumum tumalay’ta. Noqw ōviy piw puma put wikniniqw putniqw pam qa súanta. ");
INSERT INTO hopNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Noqw pas puma put ep nāma soon kurs ṅöyaltini; nihqe pay nawus nāṅaqw lahsi; noqw Barnabas Mark wikqe, pāvaqe Cyprus aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Noqw Paul Silas namorsta. Noqw tuptsiwni’yuṅqam God núokwayat aw pumuy noayaqw, puma pank̇aṅw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nihqe puma Syriat, pu Ciliciat aṅ ahsupoq nakwsuqe, Jesus aw tōnawtaqamuy öqalanma. ");
INSERT INTO hopNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pahsat pu pam Derbet ep pitu, pu Lystrat ep’e. Noqw hak tuptsiwni’taqa Timotheus yan mātsiwhqa pep qatu, hakiy tuptsiwni’taqat wuhtit Jew‐sinot tíata, nīk̇aṅw hakiy Greek‐sinot nay’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Noqw Lystrat ep‐nik̇aṅw, pu Iconium ep tuptsiwni’yuṅqam put aw lomanavoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Noqw as pam Paul ámumniqat pam nāwaka. Nīk̇aṅw pam Jew‐sinmuy paṅ yesqamuy tuway’taqe, ōviy put wikqe, poṅotku, put naat Greek‐sínoniqw sohsoyam put navoti’yuṅqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Noqw puma paṅ kitsókinawit hinwisqe, Jerusalem epeq ayaiwyuṅqam, pu wukw’a’yat yesqam hin yukuyaqat mātaptiwisa, pumuy aṅ hinwisniqata. ");
INSERT INTO hopNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Noqw ōviy Jesus aw tōnawtaqam tuptsiwnit aṅ öqawhtotaqe, nāqavo aw wūhaq’iwma. ");
INSERT INTO hopNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Noqw puma tutskwat Phrygiat, pu Galatiat aṅ ahsupoq kūkuyvat, Asiat ep lavayit yuaaykuyaniqw, Qahováriwtaqa Hikwsi pumuy mēwa. ");
INSERT INTO hopNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Noqw ōviy puma Mysiat aw ö́kihqe, as Bithyniat awyaniqey anhtoti; noqw pay Hikwsi pumuy qa nakwhana. ");
INSERT INTO hopNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Noqw ōviy pay puma Mysiat aṅ yūmosa Troas aqwya. ");
INSERT INTO hopNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Noqw Paul mihikq tuawyorikq, hak Macedoniat aṅqw tāqa wunuk̇aṅw okiw put aw paṅqawlawu: Um Macedoniat aqwnen itamumi unaṅwtapni. ");
INSERT INTO hopNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Noqw ōviy pam pan tuawyorikq, pahsat pay itam Macedoniat aqwyaniqey anhtoti, suyan pi itam pumuy amumi lomatuawit yuaaykuyaniqat ōviy Tutuyqawhqa itamuy wáṅwayhqat itam pan wūwayaqee. ");
INSERT INTO hopNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pu ōviy itam Troas aṅqw ahpiyyaqe, yūmosa pāvaqe Samothraceat aqwyaqe pep öki; nit qavoṅvaqw pu itam Neapolis ep öki. ");
INSERT INTO hopNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Paṅqw pu itam Philippit awya, pam Macedoniat ep pas pavan mohpeq kitsóki Rome aṅqw kwihpiwhpu. Nihqe itam pep kitsókive hihsakishaqam yēse. ");
INSERT INTO hopNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pu itam nasuṅwintalöṅnit ep kīṅaqw nö́ṅakqe, mūnat qalavoya, haqam sinom nānawaknaṅwuqat paṅsoo; noqw itam pep yesvaqe, momoymuy pep tsovaltiqamuy amumi yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Noqw hak wuhti Lydia yan mātsiwhqa, tsatsákwmötsaput a’nö hihk̇ay’taqat huhyaqa, itamumi tūqayta. Pam Thyatira‐kitsókit aṅqw sino; noqw pam God aw nāwakinma. Noqw Tutuyqawhqa put pan unaṅwtoynaqw pam Paul lavayiyat aw unaṅwtavi. ");
INSERT INTO hopNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Noqw pam‐niqw, pu amum ki’yuṅqam kūyit akw tuvoylatotiqw, pam itamumi öqaltiqe paṅqawu: Kurs nu úmuyniqw pas antsa tuptsiwhqe, Tutuyqawhqat aw pas qa paysoq hintsakq, uma ikiy awye’, ep yesni, kítahqe itamumi tuyqawva. ");
INSERT INTO hopNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Noqw itam hisat haqam nānawaknaṅwuqat awyaqw, hak māna núantuwiki qalomáhikwsit akw tuyqawiwtaqa itamuhsawva; pam hakiy hihta hintaniqat āawnaṅwu. Nihqe pantsakqey akw moṅwímuy amuṅem sīvat nihtilawu. ");
INSERT INTO hopNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pam māna Paul‐nik̇aṅw pu itamuṅk tsa’tinumqe a’nö paṅqawnuma: Ima tahtaqt God Sus’oveqnihqat tumal’aymatu; nihqe itam hin ayo nö́ṅakniqat itamuy āwintota, kitinuma. ");
INSERT INTO hopNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nihqe pam wūhakis tālat aṅ yan hiṅqawnumq, Paul puhtsemokqe, namtökt, hikwsit aw paṅqawu: Nu Jesus Christ natṅwaniyat aw yank̇aṅw ūmi paṅqawni: Put aṅqw yámakuu, kita. Noqw pahsat pay hikwsi put aṅqw yama. ");
INSERT INTO hopNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Noqw put himuy’yuṅqam nanaptaqe, kurs hin puma pāpu put atsviy yesni. Nihqe ōviy puma Paul Silas enaṅ ṅuayaqe, kīsonmi momṅwituy amumi pumuy lölökinyuṅwa; ");
INSERT INTO hopNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nihqe momṅwituy amumi wikvayaqe paṅqaqwa: Ima tāqat Jew‐sínomnik̇aṅw itahkitsokiy ep sinmuy qalomáhintsahtsanhqe, sóontsahtsana; ");
INSERT INTO hopNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nihqe nāp tuwiy tūtutuqayna. Noqw pi itam Rome aṅqw sínomnihqe, soon put kwusuye’, aṅ hinwisni, ");
INSERT INTO hopNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Noqw sinom suhpantaqam ayaiwtaqamuy amuhpewi hoṅva; noqw momṅwit pumuy amuhpa’ yuwsiyamuy tsihtsiktotat, pumuy kohot akw wuvahtotaniqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Noqw ōviy puma pumuy wūhakis wuvahtotat, sivikimi tūvayaqe, sivilalwaqamuy oyi’taqa pumuy qaöwítavi’taniqat aw paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Noqw yan put pas qaöwítutaptotaqw, ōviy pam pumuy pas yūmoq pánahqe, siviawiwat aṅ porom’iwtaqat aṅ pumuy kukyamuy hūrs taṅata. ");
INSERT INTO hopNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Noqw tōkilnasaveq Paul Silas amum nāwaknaqe, God aw tayawinpit tawlawu, noqw sivilalwaqam nanapta. ");
INSERT INTO hopNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Noqw nāt puma panyuṅqw, pay tutskwa tayayativa, pu sivikit qaqatspiat pīwu. Noqw, pahsat pay sohsovik hötsíwa hötsíltotiqw, sohsokmuy somiam rupamhtoti. ");
INSERT INTO hopNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Noqw sivilalwaqamuy oyi’taqa tātayhqe, sivikit aṅ hötsíwyuṅqw túwahqe, pahsat as pay nāninaniqe sipwuvahpiy hórokna, sivilalwaqam watqaqat wūwaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Noqw Paul aw tsa’lawhqe paṅqawu: Um qa nāhintsanni; pay itam sohsoyam yepya. ");
INSERT INTO hopNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pahsat pu pam qȫhit tuhtuy’qe amumiq supkiqe, tururutik̇aṅw, Paul‐nit pu Silas pumuy amutpiq nātuva; ");
INSERT INTO hopNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nihqe pam pumuy aṅqw hóroknaqe amumi paṅqawu: Tāqatu, ya nu hinhte’ ayo yámakni? ");
INSERT INTO hopNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Noqw puma aw paṅqawu: Tutuyqawhqat Jesus Christ aw um tuptsiwani; nen um ayo yámakni, pu uhtim pīwu. ");
INSERT INTO hopNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pu puma put aw Tutuyqawhqat lavayiyat yuaata, pu sohsokmuy kīyat ep yesqamuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Noqw pam ep mihikq, hísatniqw paniwhtiqw, pahsat pay pumuy wikqe haqe’ wuvahtiwhqat aṅ pāhoma, nit pahsat pay kūyit akw tuvoylati, pam’i, pu tímatu. ");
INSERT INTO hopNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Noqw pam pumuy kiy ep wikvaqe, amumi tunösvoñahta; nihqe puma sohsoyam God aw tūtuptsiwaqe hahlayya. ");
INSERT INTO hopNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Noqw tālawvaqw momṅwit sivilalwaqamuy oyi’taqat aw solāwamuy ayatotaqw, paṅqaqwa: Pay um tāqatuy mātapni, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Noqw sivilalwaqamuy oyi’taqa Paul aw paṅqawu: Yaw uma mātaviwniqat ōviy momṅwit hakimuy aṅqw ayatota; ōviy uma yámak̇e’, qahin unaṅway’k̇aṅw ahpiyni. ");
INSERT INTO hopNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Noqw Paul pumuy amumi paṅqawu: Puma itamuy Rome aṅqw sinoiwtaqamuy qa tūviwtaqamuy nuhtutpik wuvahtotat, sivikimi tūvayak̇aṅw, ya puma yephaqam itamuy nanauyve hóroknayaniqey anyuṅwa? Sóoni; nāp aṅqwye’, itamuy hóroknayani. ");
INSERT INTO hopNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Noqw solāwam momṅwituy amumi it tūawvayaqw, puma kurs Rome aṅqw sinoiwtaqatniqw puma nanaptaqe nēṅem tusitota. ");
INSERT INTO hopNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nihqe ōviy puma amumi ö́kihqe, pās amumi yuaaykuyaqe, paṅqw hóroknaya; nihqe puma kíṅaqw ahpiyniqat amumi naokiway’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Noqw puma sivikiṅaqw yamakt, Lydiat kīyat aw paki; nihqe pep tuptsiwni’yuṅqamuy amumi yórikqe, pumuy öqalat, amuṅaqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Noqw puma Amphipolis‐nik̇aṅw pu Apolloniat aṅ kuyvaqe, Thessalonicat ep pitu; noqw pep Jew‐sinmuy tsotsvalkiam wunu. ");
INSERT INTO hopNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Noqw Paul tuwiy anhtiqe pumuy amumi pákihqe, pāyis nasuṅwintalöṅnit aṅ pumuy amumum tutuvenit aṅqw yuaata. ");
INSERT INTO hopNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nihqe pas Christ kurs hin qa okiwsaniwniqat, pu mokiwuy aṅqw ahoy tātayniqat pam amumi yuaataqe paṅqawlawu: Nu it Jesus umumi yuaata pam hapi Christ, pam kitalawu. ");
INSERT INTO hopNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Noqw haqawat tūtuptsiwaqe, Paul‐nik̇aṅw pu Silas pumuy amumumtoti, pu Greek‐sinom Jew‐sinmuy amún tuptsiwni’yuṅqam amuṅaqw wūhaknihqamu, pu momoymuy pavansinmuy amuṅaqw qa tsa’ya. ");
INSERT INTO hopNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Noqw Jew‐sinom qa tuptsiwni’yuṅqam qa tsuyhtiqe, hakimuy qa hihta a’pituy qahopihtuy nāmi tsovalaya. Noqw puma kīve sohsokmuy sinmuy nāwahoynayaqe, Jason kīyat aw kihpokyaqe as ayaiwyuṅqamuy sinmuy amumi ipwayaniqey tuwantota. ");
INSERT INTO hopNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nit puma pumuy qa tutwaqe, Jason‐nit pu haqawatuy tuptsiwni’yuṅqamuy kīve momṅwituy amumi lölökinyuṅwa tsa’tik̇ahk̇aṅwo: Hakim tūwaqatsit ep qatsit tahkuknayaqam kurs pew pu’ öki. ");
INSERT INTO hopNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Noqw Jason pumuy pās oya. Ima sohsoyam Caesar tutavoyat ehpewi hintsatsk̇a; yaw hak suhk̇a móṅwinihqat paṅqaqwa, yaw hak Jesus. ");
INSERT INTO hopNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Yan puma hiṅqaqwaqw, sinom kīve momṅwituy amumum it nanaptaqe hin unaṅwtoti. ");
INSERT INTO hopNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Noqw Jason suṅwámuy amumum sivaoye’, put akw puma mātaviwyaniqat momṅwit pumuy amuṅem pan yukuya. Noqw puma put ömahtotat, pumuy mātapya. ");
INSERT INTO hopNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Noqw pahsat pay tuptsiwni’yuṅqam míhikiwtaqw, Paul Silas enaṅ Bereat aqw hōnaya. Noqw puma epeq pítuhqe, Jew‐sinmuy tsotsvalkiyamuy aw paki. ");
INSERT INTO hopNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Noqw ima sinom Thessalonicat ep sinmuy qa amuntotit, nāqavo tutuvenit aṅ puritota, su’qawk̇ahk̇aṅw lavayit kwusuya, mātaqpi kurs īi himu pas antsa pantaqw nanaptaniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Noqw ōviy puma wūhaknihqam tūtuptsiwa, pu aṅ Greek‐sinmuy amuṅaqw momoyam pavansinom qa tsa’ya, pu tahtaqt pīwu. ");
INSERT INTO hopNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Noqw yaw Paul Bereat ep God lavayiyat yuaataqat Thessalonicat ep Jew‐sinom nanaptaqe, pay piw paṅsoyaqe, sinmuy hin unaṅwtoynaya. ");
INSERT INTO hopNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Noqw pahsat pay tuptsiwni’yuṅqam Paul pātuwaqatsit aṅhqe haqami taviya. Noqw pay Silas Timotheus amum hāk pep huruhti. ");
INSERT INTO hopNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Noqw Paul wikyaqam put Athens epeq wikvaya; noqw yaw Silas Timotheus amum put aqw k̇aktayniqat Paul pumuy amumi tutaptaqw, puma paṅqw ahpiyya. ");
INSERT INTO hopNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Noqw Paul Athens epeq pumuy nuhtayk̇aṅw, navotq pas sinom hīhihtuy wutsit aw nāwakinwisqey aw‐sa yuki’yuṅqw, pas pam unaṅwpeq qahahlayhti. ");
INSERT INTO hopNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nihqe ōviy pam tsotsvalkive Jew‐sinmuy amumum hīhihta nātuviṅlawu, pu Jew‐sinmuy amún tuptsiwni’yuṅqamuy amumuma, pu nāqavo kīsonve put aw ökiwtaqamuy amumuma. ");
INSERT INTO hopNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Noqw haqawat hihta aṅ wuwni’yuṅqam Epicureas lavayiyat ṅuy’yuṅqam‐niqw pu Stoic‐sinmuy lavayiyamuy ṅuy’yuṅqam Paul aw lavayhtoti. Noqw haqawat paṅqaqwa: Ya i’ hak himu qalaváyhtuwi’taqa as hiṅqawlawu? kitota. Noqw haqawat paṅqaqwa: I’ sumataq sinom hihta alöṅöt aw nāwakinwisniqat tūtutuqayna, kitota, pam pumuy amumi Jesus yuaataqw ōviy’o, pu sinmuy ahoy yesvaniqata. ");
INSERT INTO hopNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Noqw puma put ṅuayaqe, Areopagus epeq wikvayaqe, aw paṅqaqwa: Ya soon itam uṅ hihta puhututuqayhpit yuaataqat aw tūqayyuṅwni? ");
INSERT INTO hopNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Pas um hihta alöṅöt itamumi yuaata. Noqw ōviy as itam īi’ hímunihqat nanaptaniqey nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Pas pi Athens ep sinom, pu hāhaqaqw sinom amumi ökiwtaqam, puma qa hihta a’pitu; panis hakiy hihta āawnayaniqey, pu hihta nanaptaniqey‐sa tunatyawyuṅwa). ");
INSERT INTO hopNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pahsat pu Paul Mars tsomoyat epeq nāsaveq wunuptut paṅqawu: Uma Athens ep tahtaqtu, pas kurs uma sohsok hihta nāwakintiwhqat k̇aptsi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Oviypi nu aṅ waynumk̇aṅw, uma hin hihta aṅ nāwakinwisqat aṅ taymaqe, haqam tūtusk̇at aṅ yan pey’taqat nu aw yori: IT HAKIY ITAM QA TUWI’KAHKAṄW AW NAWAKINTOTAQAT EṄEM’I. Noqw ōviy uma hakiy qa tuwi’k̇ahk̇aṅw aw nāwakintotaqat nu umuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","I’ hapi God tūwaqatsit yuku, pu put aṅ sohsok hihta hinyuṅqata; pam hapi ōveqatsit‐nikaṅw pu tūwaqatsit aw móṅwinihqe, kīkihut sinot māyat akw yukiwyuṅqat qa aṅ ki’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Oviy soon hak may akw hihta ep put paaṅwani; pi pam qa hihta haqni’ta, piw may akw pi pam sohsokmuy sinmuy qatsit huylawu, pu hikwsita, pu sohsok hihtaa, ");
INSERT INTO hopNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nihqe pam sopk̇awtaqamuy nanapwatuy sinmuy sūkw uṅwat aṅqw yuku, ahsupoq tūwaqatsit aṅ yesniqat ōviy’o; nihqe haqam qatsivaptuyaniqat, pu tūwaqatsit aṅ haqami pahsavo yesniqat aṅwu pay pās yuku, ");
INSERT INTO hopNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Puma Tutuyqawhqat hepyaniqat tunatyawk̇aṅwo. Hisnen may akw put hepye’ tutwani, pay as pi pam sohsokmuy itamuṅaqw qa yāpo. ");
INSERT INTO hopNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Pi itam put atsviy tāyuṅwa, pu poninitota, piw yēse. Oviypi haqawat pas nāp umuṅaqw yēwalalwaqam ura paṅqaqwa: Pay itam piw put ahpiy aniwhti, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Noqw ōviy hapi itam God ahpiy aniwhtiqe, soon pi itam pam hak pas hímunik̇aṅw, hihta sik̇avalasivat, sen qötsásivat, sen owat aṅqw yukiwhqat antaqat pan wūwantotani. Pam sinot tuhisayat, pu wuwantuwiyat ahpiy yukiwtaqat qa pan wūwantotani. ");
INSERT INTO hopNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Noqw pay God yūpahaqaqw yan ṅastanavotit aṅ hinwisqamuy hintsakpiyamuy qa aw tunatyawta. Nīk̇aṅw pu’ hapi pam sohsokmuy sinmuy sohsovik yesqamuy amumi tutaptaqe, qaantunatyay aṅqw lasyaniqat amumi pas paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pi pam hisat sinmuy amuṅem hin yúkuniqey pay tokiltaqe, hakiy tāqat put eṅem suan yúkuniqat aw pay tavi. Nihqe pay pas pam soon qaantaniqat sohsokmuy navotna, mokiwuy aṅqw put ahoy tātaynaqee. ");
INSERT INTO hopNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Noqw puma ahoy yesvaniwniqat nanaptaqw haqawat tutsíwhiṅqaqwa; noqw pētu paṅqaqwa: Pas ason itam it yantaqat ūṅaqw piw nanaptani. ");
INSERT INTO hopNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Yantaqat atsve pu’ Paul pumuy amuṅaqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Noqw pay haqawat tahtaqt put qa mātapyaqe tūtuptsiwa. Noqw panhtotiqamuy amuṅaqw hak Dionysius yan mātsiwa, Areopagus epeq momṅwituy amuṅaq’ö, noqw hak wuhti Damaris yan mātsiwhqa; noqw pu piw pētu pumuy amumumya. ");
INSERT INTO hopNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yantaqat atsve pu’ Paul Athens aṅqw ahpiynihqe, Corinth ep pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nihqe pep pam hakiy Jew‐sinot Pontus‐tutskwat ep tihtiwhqat Aquila yan mātsiwhqat tuwa. Pam hak pūnat nȫmay Priscillat amum Italyt aṅqw pitu, hak Claudius sohsokmuy Jew‐sinmuy Rome aṅqw ahpiyyaniqat amumi paṅqawhq ōviy’o. Noqw Paul pumuy amumi pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Nihqe pam pumuy tumaltuwiyamuy tuwi’taqe, amumum huruhtiqe, amumum tumalay’ta; puma mötsápkit tumaltuwi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Noqw pam aṅsakis nasuṅwintalöṅvaqat ep tsotsvalkive yuaataṅwu; nihqe Jew‐sinmuy, pu Greek‐sinmuy tuptsiwna. ");
INSERT INTO hopNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Noqw Silas Timotheus amum Macedoniat aṅqw pituqw, Paul pan unaṅwtiqe, pay Jesus pas antsa Christ‐nihqat Jew‐sinmuy amumi pan yuaataqey aw‐sa yuki’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Noqw pay puma ehpewhtotiqe, aqw nānap hiṅqaqwaqw, pam yuwsiy tsatswit, amumi paṅqawu: Kurs uma súlawhte’, uma pas nāp put ep tukopniwyani. Soon God nuy tukopnani, umuhqatsiy ep’e; yahpiy hapi pu’ nu qa‐Jew‐sinmuy amumi yuaatani. ");
INSERT INTO hopNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pu pam paṅqw ahpiynihqe, hakiy Justus yan mātsiwhqat God aw nāwakinmaqat kīyat ep pitu; put hakiy kīat tsotsvalkit aw pikta. ");
INSERT INTO hopNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Noqw hak tsotsvalkive mohpeq moṅwi Crispus yan mātsiwhqa, sohsokmuy timuy yank̇aṅw, Tutuyqawhqat aw tuptsiwa. Noqw k̇aysiwhqam Corinth ep ki’yuṅqam nanaptaqe, tūtuptsiwaqe, kūyit akw tuvoylatoti. ");
INSERT INTO hopNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pahsat pu Paul mihikq tuawyorikq, Tutuyqawhqa put aw paṅqawu: Um qa hihta mamqast yuaatani; um uhlavayiy qa ṅuy’tani. ");
INSERT INTO hopNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nu úmuma; noqw soon hak uṅ hintsannik ūmi may’tani. Pi nu k̇aysiwhqamuy kīve sinomuy’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Noqw ōviy pam sūkw yahsaṅwuy‐nik̇aṅw aṅqw navay mūmuyawhtuy aw pahsavo God lavayiyat pumuy tutuqaynatinuma. ");
INSERT INTO hopNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Noqw Gallio Achiat ep moṅw’iwtaqw, Jew‐sinom sun unaṅwtotiqe, Paul ṅuayaqe haqam hin yukiltiṅwuqat kīhut paṅso put wikya, ");
INSERT INTO hopNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Paṅqawk̇ahk̇aṅo: I’ hin tutaptiwhqat qa panwat God aw nāwakintiwniqat sinmuy amumi ö’qala. ");
INSERT INTO hopNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Noqw Paul as lavayhtiniqey anhtiqw, Gallio Jew‐sinmuy amumi paṅqawu: Pay pi as himu haqam pas qa súantak̇aṅw, qahopihintaqw, soon nu umumi qa unaṅwtapni, uma Jew‐sínomu. ");
INSERT INTO hopNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nīk̇aṅw kurs pay uma lālavayit, pu nānatṅwanit, pu umuhtutavoy ep hintsatsk̇e’, pay uma nāp put hin yukuyani; pay nu soon put pantaqat aw hintsakni. ");
INSERT INTO hopNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Pam kitat, haqam hin yukiltiṅwuqat kīhut aṅqw pumuy lālayi. ");
INSERT INTO hopNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Pahsat pu sohsoyam Greek‐sinom hakiy tsotsvalkive moṅwit Sosthenes ṅuayaqe, haqam kīve hin yukíltiṅwuqat atpip put wuvahtota. Noqw Gallio īit ep qa hin unaṅwti. ");
INSERT INTO hopNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","It atsve pu’ Paul pep wūyavo qatut, aṅ tuptsiwni’yuṅqamuy mātapt, paṅqw Syriat aqw’a. Noqw Priscilla‐niqw pu Aquila puma put ámuma. Noqw pam pi Cenchreat ep tal’arilti, pay hihta ep God aw pasiwniyat aṅ ruhpakq ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Noqw pam Ephesus ep pítuhqe, pumuy pep mātavi; nit pam pas nāp tsotsvalkimi pákihqe, pep Jew‐sinmuy amumum nātuviṅvewat yuaata. ");
INSERT INTO hopNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Noqw as pam pumuy amumum wūyavo qátuniqat puma nānawaknaqw, pam qa nakwhaqe, ");
INSERT INTO hopNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Paṅqw ahpiynik̇aṅw, pumuy öqalaqe paṅqawu: Pay nu pas Jerusalem epeq nōviwniqat aw pitutoqat soon qa pepeq hinhtini. Nīk̇aṅw pay nu ason soon amumi ahoy qa pítuni, God pan inuṅem yuki’taniq’ö; pu pam Ephesus aṅqw pāvaqe ahpiy’o ");
INSERT INTO hopNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nihqe pam Caesareat ep pitut, Jerusalem aqwnihqe, Jesus aw tōnawtaqamuy amumi yuaaykut, pahpiy Antioch aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pu pam pep hihsavo qatut, paṅqw ahpiynihqe Galatiat, pu Phrygiat aṅ ahsupoq pās nānaṅumo aṅ kuyva, sohsokmuy tuptsiwni’yuṅqamuy öqalanmak̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Noqw hak Jew‐sino Apollos yan mātsiwhqa, Alexandriat ep tihtiwhqa, Ephesus ep pitu. Pam hak pās hopi, nihqe tutuvenyukit aṅ a’nö tuwi’ta; ");
INSERT INTO hopNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Pu Tutuyqawhqat tunatyayat aṅ pās tuwi’vaqe, Tutuyqawhqat aṅqw hihta hintaqat pas qa nātusi’taqe tūtutuqayna; nīk̇aṅw pay pam John ahpiy kūyit akw tuvoylat hintsatskiwhqat‐sa navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nihqe pam pas qa nánahtsopk̇aṅw tsotsvalkive yuaativa. Noqw Aquila Priscillat amum put aw tūqaytaqe put wikqe, pahsat pu God tunatyayat put pas suan āawna. ");
INSERT INTO hopNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Noqw pam Achaiat aqwniqey unaṅwtiqw, Ephesus ep tuptsiwni’yuṅqam pepeq tuptsiwni’yuṅqamuy amumi pēnayaqe, puma put pās taviyaniqat amumi paṅqaqwa. Noqw pam pítuhqe, núokwat ahpiy pumuy amumi a’nö unaṅwtavi, ");
INSERT INTO hopNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Pi pam nuhtutpik Jew‐sinmuy qaöwítuptsiwna; nihqe pay Jesus pas antsa Christ‐nihqat tutuvenyukit aṅqw pumuy amumi mātaktima. ");
INSERT INTO hopNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Noqw Apollos nāt Corinth epniqw, Paul Antioch aṅqw tutskwava hinmak̇aṅw, Ephesus ep pitu; nihqe pep hakimuy tuptsiwni’yuṅqamuy túwahqe ");
INSERT INTO hopNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Amumi paṅqawu: Uma tūtuptsiwaqe, ya Qahováriwtaqat Hikwsit makiwya? Noqw puma aw paṅqaqwa: Itam Qahováriwtaqat Hikwsit hákiyniqw pas put qa ṅas’ew nanapta. ");
INSERT INTO hopNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Noqw pam pumuy amumi paṅqawu: Noqw uma hinoqw kūyit akw tuvoylatiwya? Noqw puma paṅqaqwa: Ura John sinmuy kūyit akw tuvoylata. Noqw ōviy itam pay pan piw tuvoylatoti. ");
INSERT INTO hopNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pahsat pu Paul paṅqawu: Ura John pas antsa sinmuy kūyit akw tuvoylata, puma nāp tunatyay aṅqw lasyaqat tuawi’taniqee. Nīk̇aṅw piw puma Jesus Christ put aṅk pítuniqat aw tūtuptsiwaniqat pam amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Noqw puma it nanaptaqe, Jesus natṅwaniyat aṅ kūyit akw tuvoylatoti. ");
INSERT INTO hopNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Noqw Paul pumuy amumi may akw matyawhq, Qahováriwtaqa Hikwsi amumi pitu; noqw puma himuhkwa yuaativayaqe, God eṅem yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Noqw puma tahtaqt pakwt lȫq sihk̇ay’taqat pahsa’haqamya. ");
INSERT INTO hopNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Noqw Paul tsotsvalkimi pákihqe, payhkomuy múmuyawhtuy aṅ God moṅwtunatyayat qa nánahtsopk̇aṅw yuaataqe, pumuy tuptsiwna. ");
INSERT INTO hopNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Noqw haqawat töhsaptotiqe, qa tūtuptsiwa; nihqe it pūhut pöhut nuhtutpik qalomáyuaativayaqw, Paul pumuy amuṅaqw ahpiynihqe, tuptsiwni’yuṅqamuy tsamk̇aṅw, hakiy Tyrannus tutuqayhkiyat ep nāqavo pumuy amumum put yuaata. ");
INSERT INTO hopNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nihqe pam lȫq yahsaṅwuy pahsavohaqam pep pantsaki; noqw ōviy sohsoyam Asiat aṅ yesqam Tutuyqawhqat Jesus Christ lavayiyat nanapta, Jew‐sínomu, pu Greek‐sínomu. ");
INSERT INTO hopNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Noqw God Paul māyat ahpiy hihta pas qa paysoq k̇ātatayhpit hintsaki. ");
INSERT INTO hopNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Noqw ōviy hakiy hihta akw tūtuyhq, hak Paul aṅqw höhönhpit, sen nanamokpit tūtuyhqat aw taviqw, tūya put mātapṅwu. Pu k̇aysiwhqam qalomáhihikwsim sinmuy amuṅaqw nȫṅa. ");
INSERT INTO hopNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pahsat pu hakim pōvost Jew‐sinom yaktaqam qalomáhihikwsimuy akw tuyqawiwyuṅqamuy amumi Tutuyqawhqat Jesus natṅwaniyat tuṅwáyaniqey anhtotiqe paṅqaqwa hīhikwsimuy amumii: Itam Jesus Paul ahpiy yuaatiwhqat aw yank̇aṅw umuy mēwaya, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Noqw hak Jew‐sino God awwat momṅwituy amuṅaqw mohpeqnihqa Sceva yan mātsiwhqa tsaṅe’ tiyotimuy’taqw, puma piw panhtoti. ");
INSERT INTO hopNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Noqw qalomáhikwsi rohomhtiqe paṅqawu: Nu Jesus tuwi’ta, pu nu Paul tuwi’ta; noqw ya uma hakim hihtuu? ");
INSERT INTO hopNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Noqw tāqa qalomáhikwsit akw tuyqawiwtaqa pumuy amumi tsoomhtiqe, áṅwutaqe, pumuy a’nö hintsana. Noqw puma qa yuwsi’k̇ahk̇aṅw, tūhototik̇ahk̇aṅw, put apyeve kīṅaqw watqa. ");
INSERT INTO hopNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Noqw Ephesus ep Jew‐sinom pu Greek‐sinom sohsoyam it nanaptaqe maqastoti. Noqw Tutuyqawhqat Jesus natṅwaniat pas k̇aptsitiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Noqw k̇aysiwhqam tuptsiwni’yuṅqam ö́kihqe, nātuhtualyaqe hintsakpiy pohtaṅwnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Pu ōviy piw k̇aysiwhqam pumuy amuṅaqw tuhisay hintsatsk̇aqam tutuveniy tsovalayaqe, sohsokmuy sinmuy amutpik put taqtsokya. Noqw puma hihk̇ayat pohtoylayaqw, kurs lȫp sunat aṅqw pakwt sihk̇ay’tasikip sōmorit pahsa’haqam sīvat hihk̇ay’taqat aqw pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Yan God lavayiat a’nö öqawi’maqe, aṅqe’ sinmuy amuhpa’ kúrukma. ");
INSERT INTO hopNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Yantaqat atsva pu’ Paul pay ason Macedoniat‐nik̇aṅw pu Achaiat pumuy aṅ kuyve’, pep pu’ Jerusalem aqwniqey Hikwsit ahpiy tunatyalti, paṅqawk̇aṅwo: Ason nu pepeq pite’, put atsve pas pay soon piw Rome qa aqw pohtani. ");
INSERT INTO hopNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pu ōviy pam lö́qmuy put aw unaṅwtavi’taqamuy Macedoniat aqw hōna, Timotheus‐nit, pu Erastus púmuyu, nit pay pam hāk Asiat ep hihsavo huruhti. ");
INSERT INTO hopNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Noqw ephaqam it yaṅ pöhut ep a’nö hintsatskiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Hak tāqa Demetrius yan mātsiwhqa, qötsásivat siplawhqa, Dianat kīyat anyuṅqat hiṅsakwhohyat qötsásivat aṅqw yukulawhqe, put tumaltuwi’yuṅqamuy a’nö k̇āhaktotoyna. ");
INSERT INTO hopNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","I’ hak pumuy‐nik̇aṅw, pu amún hintsatsk̇aqamuy sūmi wáṅwayhqe, amumi paṅqawu: Tahtaqtu, uma navoti’yuṅwa; itam it yan tumalat ahpiy hihta tuway’numya. ");
INSERT INTO hopNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pu uma piw aṅ tayk̇ahk̇aṅw navoti’yuṅqw, qa Ephesus ep‐sa‐nit, pas pēp sohsovik Asiat aṅ ahsupoq i’ Paul k̇aysiwhqamuy tuptsiwnaqe, lasna paṅqawk̇aṅwo: Yaw hihtuy aw nāwakintiwyaqam sinmuy māyamuy akw yukiwyuṅqam pay qa pas antsa hihtuu. ");
INSERT INTO hopNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Noqw ōviy k̇a itahtumala qahaqamhtini, pu it Dianat aw nāwakintiwhqat kīat piw qahaqamhtini. Noqw aw itam yanwisqa qahimuniwhtini. Pi Asiat ep sinom‐niqw pu sohsoyam tūwaqatsit aṅ yesqam put hapi aw nāwakintota. ");
INSERT INTO hopNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Noqw puma put nanaptaqe pavan pas itsívutotiqe paṅqaqwa: Pay pas Ephesus ep qátuhqa Diana a’nö hímuu, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Noqw kīve sinom sohsoyam Gaius‐nit, pu Aristarchus ṅuaya, Macedoniat aṅqw tāqatuy Paul amum waynumqamuyu; nihqe pumuy wikk̇aṅw, wukotsotsvalkimi sun unaṅway yuhtu. ");
INSERT INTO hopNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Noqw Paul as sinmuy amumi pákiniqw, tuptsiwni’yuṅqam put qa naqwhanaya. ");
INSERT INTO hopNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Noqw hakim Asiat ep pavansinom Paul kwatsmat put aw hakimuy hōnayaqw, pay pam ahpami qa unahintsakniqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Noqw haqawat yanwat hiṅqaqwa, pu pētu panwat sutsk̇e’wat hiṅqaqwa; pas sinom hintsatsk̇aqey qa navoti’numya, noqw suswuhaqnihqam hihta ōviy tsovaltiqey qa navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Noqw Jew‐sinom hakiy Alexander momi taviyaqe, pam lavayhtiniqat puma aw öqaltoti. Noqw pam sinmuy amumi māmasaqe, as nēṅem hin lavayhtini. ");
INSERT INTO hopNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Noqw kurs pam Jew‐sínoniqw puma māmatsyaqe, pahsat tāwat aṅqe lȫs qöniltiqat pahsavohaqam sūsaq sáakmaqe paṅqaqwa: Pay pas Ephesus ep qátuhqa Diana a’nö hímuu. ");
INSERT INTO hopNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Noqw kīve tutuven’aya sinmuy uyiwaqe, amumi paṅqawu: Ephesus ep tahtaqtu. Ephesus ep sinom it pas pavan Dianat pas hihta’yuṅwa, pu put an sóniwhqat Jupiter aṅqw posqata. Noqw qa hak qa put navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Soon pi hak haqam put aqw hiṅqawniqat uma navoti’yuṅqe, pay uma qa pas hiṅqaqwanik̇ahk̇aṅwo, nen qa hihta pay an’ewakw hinhtotinik̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Taq uma imuy tāqatuy pew wikvaya. Noqw puma pas āantsawat kīkihut qa hovalanta, piw aw umuhyantaqay Dianat aqw qa hiṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Pay pi ason kurs Demetrius‐niqw, pu put amum sūp tumalay’yuṅqam hakiy aw hihta ep hinyuṅwniqw, pay pi moṅwkive himu hin yukiltiṅwuqat aw hötsi, pu momṅwit eṅem hihta ep hoṅqam yēse; pay ason puma pep hihta ep nēnehpewi hiṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ason pi kurs uma hihtawat pas nātuviṅlalwaniqw, pay ason hisat tsovaltiṅwuqey ep tsovaltiqw, pep pam ason hin yukiltini. ");
INSERT INTO hopNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Taq k̇a itam pu’ a’nö hiniwhtiqat ep tūviṅtiwyaniqey aw unahinhtoti, kurs itam hihta aw yank̇ahk̇aṅw, pu yep yanhaqam hinhtotiqey paṅqaqwaniqee. ");
INSERT INTO hopNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Yan pam lavayhtit, pep tsovawtaqamuy mātavi. ");
INSERT INTO hopNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Noqw a’nö hiniwhtiqat aṅ ruhpakq, Paul tuptsiwni’yuṅqamuy wáṅwayhqe, öqalát, mavoktat, paṅqw Macedoniat aqw nakwsu. ");
INSERT INTO hopNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pu ōviy pam paṅ ahsupoq nakwsuqe, pumuy pavan öqalanmak̇aṅw, Greece ep pítuhqe, ");
INSERT INTO hopNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pep payhkomuy mūmuyawhtuy aṅ qatu. Noqw as pam pāvaqe Syriat aqwniniqw Jew‐sinom put moqmani’yuṅqw, pay pam Macedoniat aṅ ahoy aqwniqey wūwa. ");
INSERT INTO hopNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Noqw hak Bereat aṅqw tāqa Sopater put amum Asiat aw’i, noqw Thessalonicat ep sinmuy amuṅaqw hak Aristarchus, pu Secundus, noqw Derbet aṅqw Gaius, pu Timotheus, pu Asiat aṅqw Tychicus‐niqw pu Trophimus. ");
INSERT INTO hopNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ima pay itamuhsavoyaqe Troas ep itamuy nuhtayyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Noqw qapek̇én’oyiwhput nōviwhqat aṅ ruhpakq, itam Philippi aṅqw pāvaqe hoyoyoykuyaqe, tsivot talq Troas ep pumuy amuṅk pitu; noqw itam pep tsaṅe’ tālat aṅ yēse. ");
INSERT INTO hopNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Noqw Sundayt aw pituqw, tuptsiwni’yuṅqam pölavikit yóṅoyhtotaniqe sumitsovaltiqw, Paul qāvo ahpiynik̇aṅw, pumuy amumi yuaataqe, tōkilat nāsamiq pahsavo yuaata. ");
INSERT INTO hopNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Noqw puma tupatsveq tsovawtaqw, pepeq qȫhiwyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Noqw hak tiyo Eutychus yan mātsiwhqa poksöve tsokiwk̇aṅw huruvuwva; noqw pas Paul sutsépyuaataqw, pam qaunáṅwtalawvaqe, payhp natsve kīhut aṅqw posq, puma put súmokq put tsöpahtota. ");
INSERT INTO hopNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Noqw Paul aqw hawhqe, aw suqtuptut, mavoktaqe, nuhtumi paṅqawu: Pay uma qa hin unaṅway’yuṅwni, pay pam nāt tayta. ");
INSERT INTO hopNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pu ōviy pam ahoy aqw wupqe, pölavikit yóṅoyhtat, aṅqw nöst, ahpiy piw nāto tālawvaniqwsavo yuaata; nihqe paṅqw pu ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Noqw puma tiyot taytaqat wikvayaqe, suyan unaṅwtoti. ");
INSERT INTO hopNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Noqw itam aṅwu pay pākihut awyaqe, pāvaqe Assos awya, pay ason itam pep Paul panayaniqey wūwank̇ahk̇aṅwo, pan pam yukuqw ōviy’o, pam aqw nāpniqey wūwaqee. ");
INSERT INTO hopNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pu ōviy pam Assos ep itamumi pituqw, itam panayaqe, Mitylene ep öki. ");
INSERT INTO hopNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Paṅqw pu itam pāvaqe ahpiyyaqe, qavönvaqw Chios aqlavo öki, nihqe Trogyllium ep huruhtoti; nit pu qavoṅvaqw itam Miletus ep öki, ");
INSERT INTO hopNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul pay Ephesus ehpeq yūmosaniqey nāwaknaqw ōviy’o; pas as Asiat ep söwhtiniqey qa nāwakna, taq as hin pasiwtaniqw, pam Pentecost talöṅniyat ep Jerusalem épeqniqey ōviy k̇aktayi. ");
INSERT INTO hopNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Noqw pam Miletus aṅqw Ephesus aw hakimuy ayataqe pep Jesus aw tōnawtaqamuy wukw’aymuyatuy wáṅwayi. ");
INSERT INTO hopNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Noqw puma ökiqw pam amumi paṅqawu: Pay nu hisat Asiat ep pítuhqe, pahpiy yūmosa umumum hin qátuhqat uma navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nu qa kwivi’naṅway’k̇aṅw okiw pakk̇aṅw Tutuyqawhqat eṅem tumalay’ta, Jew‐sinom inumi hepyaqe, nuy moqmani’yuṅq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pu uma hihta akw moṅvastotiniqat nu qa hihta umumi k̇ahk̇awnat, umuy put āawna; nihqe ura nu umuy nuhtutpik tutuqayna, pu kīnawita. ");
INSERT INTO hopNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nihqe nu Jew‐sinmuy amuminik̇aṅw, pu Greek‐sinmuy amumi lalvayhqe, tunatyay aṅqw lasye’ God aw namtökyaniqat amumi paṅqawlawu, pu Itahtutuyqawhqay Jesus Christ qapēvewnayaniqata. ");
INSERT INTO hopNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Noqw meh, Qahováriwtaqa Hikwsi nuy pan unaṅwtoynaqw, nu Jerusalem aqw hoyhta, hin pepeq hintsaniwniqey qa navoti’k̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Pay panis pi Qahováriwtaqa Hikwsi ahsupoq kitsókinawit nuy āwinma, yaw nu sivihpit, pu k̇ānanvotpit aw pítuniqata. ");
INSERT INTO hopNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nīk̇aṅw pay qa himuwa i’ nuy hin unaṅwtoyna. Piw nu iqatsiy qa nēṅem k̇ahk̇awna, pas pay nu okiw hahlayk̇aṅw inuṅem pöhtavit aṅ kuyvaniqey ōviy’o, Ura Itahtutuyqawhqa Jesus nuy God núokwayat tuawi’taniqat aw ayata. Noqw ōviy nu put hintsakniqey pas kwaṅwtoya. ");
INSERT INTO hopNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Noqw taa, pew pahsavo nu sohsokmuy umuhpa’ God moṅwtunatyayat yuaatinuma. Noqw yahpiy haqahpiy uma soon pāpu inumi yórikyaniqat nu navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Oviy uma it tālat ep inumi nanaptani: Nu hapi qa hakiy qatsíyat ep tukopniwta. ");
INSERT INTO hopNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Pi nu qahaqam pay qa suhtaqhink̇aṅw God tunatyayat umuy sohsok āawna. ");
INSERT INTO hopNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Oviy uma nānami tunatyaltotini, pu sohsokmuy God aw tōnawtaqamuy amumii; uma hapi pumuy amumi tunatyawyuṅwniqat ōviy Qahováriwtaqa Hikwsi umuy pumuy amumi oya, uma God aw tōnawtaqamuy nopni’yuṅwniqat ōviy’o; pam pumuy pas nāp uṅway akw tui. ");
INSERT INTO hopNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Pi nu navoti’taqw, nuy ahpiyniqw, hakim kwēkwewhtuy amún qa nun’okwat umumum namiqwriltini; nen kanelmuy qa pētotani. ");
INSERT INTO hopNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Pu híkispi pas nāp umuṅaqw haqawat hoṅve’, qasuantaqat lavayit akw nāmi sinototani. ");
INSERT INTO hopNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Oviy uma tunatyawyuṅwni, nen it u’ni’yuṅwni; ura nu payhkomuy yahsaṅwuy aṅ mimhikqat pu talöṅwintiwhqat aṅ okiw pakk̇aṅw umuy u’nantoynaqe qa qé’iwma. ");
INSERT INTO hopNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Noqw taa, isinomu, nu hapi umuy God aw mātavi, pu núokwlavayiyat aw’i. Pam hapi umuy wuṅwnaniqey aw öqala, pu umuy hihta máqaniqeyu, sohsokmuy sinomuy énaṅ’a. ");
INSERT INTO hopNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nu hapi qa hakiy sīvayat tuṅlay’ta, pu yuwsiyata. ");
INSERT INTO hopNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Owi, uma nāp navoti’yuṅqw, ura nu imay akw tumalay’taqe hihta tuway’numa, nēṅem’i, pu inumumyaqamuy amuṅem’i. ");
INSERT INTO hopNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Pi nu sohsok umumi mahtakna, hin uma tumalay’yuṅwe’, aṅ ōokiwyaqamuy amumi unaṅwtapyaniqata, pu Tutuyqawhqat Jesus lavayiyat u’ni’yuṅwniqata; ura pam paṅqawu: Hak hakiy hihta máqahqa pam hihta ömahtaqat epnihqe pas hahlayni. ");
INSERT INTO hopNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Yan pam lavayhtit, tamötswunuptut, pumuy sohsokmuy amumum nāwakna. ");
INSERT INTO hopNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Noqw puma okiw sohsoyam tsaykuqe, Paul kwapk̇aqe, mamavokyak̇ahk̇aṅw tsōnantota, ");
INSERT INTO hopNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Soon pāpu puma put aw yórikyaniqey ep pas qa hahlayhtotiqe ōviy’o; nihqe pahpiy puma put amum pākihut awya. ");
INSERT INTO hopNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pu ōviy nawis’ew itam pumuy amuhpiynihqe, itam yūmosa Coos aqwya, pu qavoṅvaqw Rhodes aw’i; nit paṅqw pu itam Patarat aqwya. ");
INSERT INTO hopNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Noqw itam pākihut Pheniciat aqwnihqat tutwaqe, put aqw yayvat, pāvaqe hoyoyoykuya. ");
INSERT INTO hopNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Noqw itam Cyprus tutwaqe, suyvaqe ehpeq yūmosaya; nihqe Syria‐tutskwat ep Tyre ep huruhtoti, pep pākihu hoiy óyaniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Noqw itam hakimuy tuptsiwni’yuṅqamuy tutwaqe, tsaṅe’sikis tālat aṅ pep yēse. Noqw pay Paul Jerusalem qa aqwniqat puma Qahováriwtaqat Hikwsit ahpiy put aw paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Noqw ōviy itam pahsavohaqami yest, pahpiy haqamiyaqey aqwya; noqw puma sohsoyam nȫmamuy pu timuy amumum kīhut qalavo itamuy tsamya; noqw itam pāhut qalaveq tamötshoṅvaqe, nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Oviy itam nāmatapyaqw, pahsat pu itam pākihut aqw yayva; noqw puma ahoy kīmiya. ");
INSERT INTO hopNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Noqw itam Tyre aṅqw ökit, Ptolemais aw ökihqe, aṅ tuptsiwni’yuṅqamuy amumi yuaaykuyaqe, sūkw tāwat aṅ amumum pep yēse. ");
INSERT INTO hopNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Pu qavoṅvaqw itam Paul ámumyaqam paṅqw ahpiyyaqe, Caesareat ep öki. Nihqe itam hakiy lomatuawit yuaataqat Philip kīyat aw yuṅqe, put amum huruhtoti; pam hak imuy tsáṅe’nihqamuy aṅ ókiwyaqamuy paaṅwantotaniqey aw oyiwhqamuy amuṅaqw suhk̇aa. ");
INSERT INTO hopNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Noqw i’ hak nālöqmuy mámanhtuy pas qanawhvalni’yuṅqamuy tímuy’taqw, puma God eṅem yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Noqw itamuy pep wūyavo yesq, hak God lavay’ayaat Agabus yan mātsiwhqa Judeat aṅqw pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nihqe pam itamumi pítuhqe, Paul kwekwéwhpiyat kwusut, put akw may, pu kuhkuy somt paṅqawu: Yan hapi Qahováriwtaqa Hikwsi lavayhti: Jew‐sinom Jerusalem epeq yesqam hakiy it kwekwéwhpit himuy’taqat yan somyani; nen qa‐Jew‐sinmuy amumi mātapyani. ");
INSERT INTO hopNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Noqw itam it nanaptaqe, pay pam pas Jerusalem qa aqwniqat itam aw ö’qalya, pu pep yesqamu. ");
INSERT INTO hopNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pahsat pu Paul lavayhtiqe paṅqawu: Ya uma hin wūwantotaqe, tsaykitaqe, nuy hin unaṅwtoynaya? Pi nu Tutuyqayhqat Jesus natṅwaniyat ep Jerusalem epeq sómiltiniqey suhtaq’ewa; pu qa pániqw‐saa; pi nu eṅem mokniqey suhtaq’ewa. ");
INSERT INTO hopNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Noqw pay kurs pas soon pam tūqayniniqw, itam ṅöyaltotiqe paṅqaqwa: Pay nam Tutuyqawhqat tunatyaat antaa. ");
INSERT INTO hopNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ahpiy pantaqw itam hihta hinnumyaqey ömahtotat, Jerusalem aqwya. ");
INSERT INTO hopNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Noqw Caesareat ep tuptsiwni’yuṅqamuy amuṅaqw haqawat itamumyaqe, hakiy Cyprus aṅqw sinot Mnason yan mātsiwhqat wikya; pam hak pay wūyavo tuptsiwni’taqw, yaw itam put amum kīyat ep huruhtotini. ");
INSERT INTO hopNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Noqw itam Jerusalem epeq ökiqw, tuptsiwni’yuṅqam itamuy hahlayhtoti. ");
INSERT INTO hopNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Qavoṅvaqw Paul itamum James aw’i. Noqw wukw’a’yam sohsoyam pep yēse. ");
INSERT INTO hopNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Noqw pam pumuy amumi hahlayhtit; pahsat pu God hin put tumalayat ahpiy qa‐Jew‐sinmuy amuhpa’ hihta tumaltaqat pās nanap hin hiniwhtiqat pam pumuy amumi tuawi’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Noqw puma put nanaptaqe, Tutuyqawhqat pas hihtatota; nihqe Paul aw paṅqaqwa: Pay pi um navoti’ta, itupko: Jew‐sinom qaan’ewakw hintaqam tuptsiwni’yuṅwa; noqw puma sohsoyam Moses tutavoyat pas antsay’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Noqw puma nanaptaqw, yaw um sohsokmuy Jew‐sinmuy qa‐Jew‐sinmuy amuhpa’ yesqamuy tutuqaynaqe, pay yaw puma Moses tutavoyat ayo yukuyaniqat yaw um paṅqawlawu; yaw timuy poṅokit akw qa tuvoylalalwani; pu piw yaw Jew‐sinmuy tuwiyamuy aṅ qa hinwisni. ");
INSERT INTO hopNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Noqw hintani? Pay kurs pi hin sinom qa tsovaltini, pi uṅ pítuhqat soon qa nanaptaniqee. ");
INSERT INTO hopNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Pay ōviy itam ūmi hiṅqaqwaqw um panhtini. Hakim itamuṅaqw nālöyöm tahtaqt Tutuyqawhqat aw hihta pasiwni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Taa. Um pumuy tsāme’, amumum napwatani; nen um amuṅem sisvini, noqw puma āriltotini. Um panhte’, sohsokmuy amumi mahtaknani, uṅ hin lavayhtiwhqa qa antsanihqata, pay kurs um pas nāp pās qatuk̇aṅw, tutavot aṅ hinmaqata. ");
INSERT INTO hopNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pu imuy qa‐Jew‐sinmuy tuptsiwni’yuṅqamuy itam amumi yanwat pēnayaqe, pay puma put hihta pantaqat qa aṅ hinwisniqat pan yukuya, pay panis nȫsiwhqa nāp yukit aw noiwhqat qe’yaniqata, pu úṅwata, pu hihta hikwísmokqata, pu tokot qa sokoplalwaniqata. ");
INSERT INTO hopNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pahsat pu Paul pumuy tahtaqtuy tsāma; nihqe qavoṅvaqw pumuy amumum napwataqe, God kīyat aw paki; nihqe hisat puma put aṅ kūkuyvaqw pumuy nanāp amuṅem himu nākwahiwniqat paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Noqw tsaṅe’sikis tālat pas pay súlawhtiniqw, hakim Asiat aṅqw Jew‐sinom God kīyat ep Paul tutwa; nihqe sohsokmuy sinmuy hin unaṅwtoynayaqe put aw may’yuṅwa, ");
INSERT INTO hopNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","A’nö paṅqawk̇ahk̇aṅwo: Israel‐tahtaqtu, huvam unaṅwtapyaa! I’ tāqa hapi hāhaqe’ sohsokmuy sinmuy imuy pas sinmuy amuhpewi tutuqayna, pu tutavot ehpewii, pu it kīhut ehpewii. Pu ōviy piw pam Greek‐sinmuy God kīyat aw taṅataqe, it kīhut pas hihtanihqat tuyoy’ewakta. ");
INSERT INTO hopNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Puma pi pūnathaqam hakiy Ephesus aṅqw tāqat Trophimus yan mātsiwhqat Paul amum kīveniqw aw tātayya; nihqe k̇a Paul put God kīyat aw pánahqat wūwayaqe, ōviy yan lavayta. ");
INSERT INTO hopNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Noqw kīve sinom sohsoyam hin unaṅwtotiqe, sūvo yuhtuqe, Paul ṅuayat, God kīyat aṅqw ihpoq lölökinyuṅwa; nihqe pahsat pay hötsíwat uhtaya. ");
INSERT INTO hopNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Noqw nāt puma put nīnantotaqw, yaw Jerusalem ep sinom a’nö hiniwmanayaqat pan mohpeq solāwamoṅwit aw tūawvaya. ");
INSERT INTO hopNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Noqw pahsat pay pam solāwamuy‐nik̇aṅw, pu tsivót‐sikip súnatnihqamuy solāwmuy amumi moṅw’wyuṅqamuy tsamk̇aṅw, pumuy amumiq wari. Noqw puma mohpeq solāwamoṅwit solāwamuy enaṅ tutwaqe, pahsat pay Paul wuvalalwaqe qe’toti. ");
INSERT INTO hopNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Pahsat pu mohpeq solāwamoṅwi awnihqe, put ṅuat, puma löqmuy sivanamiqlölöt akw put somyaniqat paṅqawu; nit pu pam hak hímunihqat, pu hihta hinhtiqat tūviṅta. ");
INSERT INTO hopNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Noqw sinmuy qaan’ewakw hintaqamuy amuṅaqw pētu yanwat hiṅqaqwa, pu pētu piw hinwat lavayta. Noqw pas sinom mowawatotaqw, kurs pam hin pas suyan navotniqe, ōviy pay put solāwakimiq wikyaniqat pam paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Noqw puma tutuveṅpa wupniniqw, solāwam Paul tsöpwisa, pas sinom a’nöyaqw ōviy’o, ");
INSERT INTO hopNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Sinom pi pumuy amuṅk hinwisk̇ahk̇aṅw paṅqawwisa: Tūvaay! kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Noqw puma Paul solāwakimi wikyaniqw, pam mohpeq solāwamoṅwit aw paṅqawu: Ya nu soon ūmi hiṅqawni? Noqw pam paṅqawu: Ya um Greek‐lavayit tūqayta? ");
INSERT INTO hopNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ya qa um hak Egypt aṅqw tāqa ura hisat sinmuy hin unaṅwtoynaqe, nālöp sōmorit pahsa’nihqamuy tuqwyantotaqamuy qayēsiwhpumi tsāma? ");
INSERT INTO hopNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Noqw Paul paṅqawu: Qae. Nu Jew‐sino; nu Ciliciat ep qa pay hin’ewakw wuhkokitsokit Tarsus ep tihtiwa. Noqw himu as nu sinmuy amumi lavayhtiniqat um nuy nakwhani. ");
INSERT INTO hopNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Noqw pam hu’waqw, Paul tutuveṅat ep wunuk̇aṅw, sinmuy amumi māmasa. Noqw sinom sutmakmaqw, pahsat pu pam pumuy amumi Hebrew‐sinmuy amuhkwa yuaata. ");
INSERT INTO hopNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Nihqe Paul sinmuy amumi paṅqawu: Tahtaqtu, isinomu, námatu, nu yahsatniqwhaqam umutpik nēṅem hin lavayhtiniqw kurs uma inumi tūqayyuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","(Noqw pam pumuy amumi Hebrew‐sinmuy amuhkwa yuaaykuqw, puma nanaptaqe pahsat pu pas qa hiṅqaqwa; noqw pam paṅqawu). ");
INSERT INTO hopNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Nu pas antsa Jew‐sino; nihqe nu Ciliciat ep wuhkokitsokit Tarsus ep tihtiwa. Nīk̇aṅw nu yep kīve Gamaliel ahpiy itanamuy tutavoyamuy pas aṅhqe qatsqat tutuqayi; nihqe nu God eṅem pas qaatsay’ta, uma pu’ it tāwat ep panyuṅqat pan’i. ");
INSERT INTO hopNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nihqe nu it yaṅ pöhut aṅ hinwisqamuy pas qa yesniqat ōviy tahtaqtuy pu momoymuy okiwsahsanqe, somlawk̇aṅw sivikimi taṅatima. ");
INSERT INTO hopNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Noqw God awwat mohpeq moṅwi sohsokmuy wukw’ayamuy amumum inumi navoti’ta; pu nu piw pumuy amuṅaqw itahsinmuy amumi tutuvenit ömahtaqe, Damascus aqw’a, nu Jesus aw tuptsiwni’yuṅqamuy pepeq yesqamuy sivintoyne’, pumuy somhtat, Jerusalem aqw tsamniqee. ");
INSERT INTO hopNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Noqw nu paṅsoqnīk̇aṅw, tāwanasavehaqam Damascus aw hayiṅwnaqw, ōṅaqw inunan’ik qaan’ewakw suhtalawva. ");
INSERT INTO hopNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Noqw nu tutskwami posqe, hakiy tönayat navotq, inumi paṅqawu: Saul, Saul, ya um hinoqw nuy okiwsahsana? ");
INSERT INTO hopNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Noqw nu lavayhtiqe paṅqawu: Ya um hak’i Tutuyqawhqa? Noqw pam inumi paṅqawu: Nu Nazareth aṅqw Jesus; pi um nuy hapi okiwsahsana. ");
INSERT INTO hopNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Noqw ima inumumyaqam tālat tutwaqe, tsātsawna; nīk̇aṅw puma hakiy inumi hiṅqawhqat tönayat qa nanapta. ");
INSERT INTO hopNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Noqw nu paṅqawu: Noqw nu hinhtini, Tutuyqawhqa? Noqw Tutuyqawhqa inumi paṅqawu: Um wunuptut Damascus awni. Noqw ason pep um hihta tumaltaniqat uṅem yukiwtaqat suhk̇a uṅ sohsok āawnani. ");
INSERT INTO hopNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Noqw pas tāla a’nö talq, ivosiy qatālawvaqw, ōviy ima inumumyaqam imay ṅuy’wisk̇aṅw Damascus aw nuy wikya. ");
INSERT INTO hopNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Noqw hak hin tutaptiwhqat an God pas k̇aptsi’taqa Ananias sohsokmuy Jew‐sinmuy pep ki’yuṅqamuy amuhpiy aw lomanavoti ");
INSERT INTO hopNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Inumi pítuhqe wunuk̇aṅw inumi paṅqawu: Itupko Saul, uhvosiy tālawnaa. Noqw nu pahsat pay ivosiy tālawna. ");
INSERT INTO hopNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Noqw pam paṅqawu: Itanamuy aw yantaqaam God uṅ namorstaqe Tiy pas súantaqat ūmi mātaknaqw, um put moayat aṅqw lavayit navota, um put tunatyayat mātsi’taniqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Pi um hin yórikqey, pu navotqey sohsokmuy sinmuy amumi put eṅem tuawi’tani. ");
INSERT INTO hopNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Taay, um hinoqw sȫwuu? Um wunupte’, kūyit akw tuvoylatini; nen Tutuyqawhqat natṅwaniyat aw taqa’naṅway’k̇aṅw, uhqaanhtipuy ayo pāhomni. ");
INSERT INTO hopNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Noqw ura nu piw Jerusalem ep pítuhqe God kīyat ep nāwaknak̇aṅw, tuawyori; ");
INSERT INTO hopNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nihqe Jesus tuwaqw, pam inumi paṅqawu: Písoqtii, nen um Jerusalem aṅqw īts ahpiyni, taq puma uṅ hin nuy tuawi’taqat soon kwusuyani. ");
INSERT INTO hopNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Noqw nu paṅqawu: Tutuyqawhqa, puma navoti’yuṅqw, nu ura as ūmi tuptsiwni’yuṅqamuy sivikimi taṅatinuma, pu ahsupoq tsotsvalkiva pumuy wuvahtinuma. ");
INSERT INTO hopNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pu uṅ tuawi’taqat Stephen uṅwáat munvaniwhq, nu nuhtum aqlap wunuk̇aṅw, nīnantotaqamuy súamun unaṅwti; nihqe nu nīnantotaqamuy yuwsiyamuy tūwala. ");
INSERT INTO hopNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Noqw pam inumi paṅqawu: Um ahpiyni, taq nu uṅ yaṅqw yāvoqhaqami imuy qa‐Jew‐sinmuy amumi távini. ");
INSERT INTO hopNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Noqw puma it lavayit aw pahsavo put aw tūqayyuṅwt, pu sáakmaqe paṅqaqwa: Tūvayaa! Nīnayaa! Pay pi put qa qatuqw lolmani. ");
INSERT INTO hopNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Noqw puma kwanonotik̇ahk̇anw, yuwsiy akw savinumyak̇aṅw qöat ōmiq tsaltoynaya. ");
INSERT INTO hopNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Noqw pahsat pu solāwamoṅwi put solāwakimi panayaniqat solāwamuy amumi paṅqawu. Uma put wuvahtotat, pās tūviṅtotani. Noqw hinoqw sinom pas panhaqam put ehpewi hiṅqaqwaqat itam nanaptani, amumi kita. ");
INSERT INTO hopNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Noqw puma put tuyqat akw sohsomyaqw, Paul solāwamoṅwit pep wúnuhqat aw paṅqawu: Ya pay um hakiy Roman‐sinot qa tūviwtaqat wuvahtaniqw pay pam súanta? ");
INSERT INTO hopNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Noqw solāwamoṅwi put navotqe ahpiynihqe mohpeq solāwamoṅwit aw paṅqawu: Um hintsakqey ep tunatyaltini, taq kurs i’ Roman‐sino. ");
INSERT INTO hopNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Pahsat pu mohpeq solāwamoṅwi pítuhqe put aw paṅqawu: Kurs nuy āawnaa, ya um Roman‐sino? Noqw pam paṅqawu: Owí. ");
INSERT INTO hopNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Noqw mohpeq solāwamoṅwi paṅqawu: Nu a’nö sisvit, Rome aqw sinoti. Noqw Paul paṅqawu: Noqw pi nu pay pas pamnīk̇aṅw tihtiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pahsat pay ima as put aw hepyaniqam ahpiyya. Noqw pam Roman‐sínonihqat mohpeq solāwamoṅwi navotqe tusita, put somqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Noqw Jew‐sinom put hihta neveltotoynayaqat pam pas suyan navotniqey nāwaknaqe, qavoṅvaqw put ṅāha; nihqe God awwat mohpeq momṅwit sohsokmuy moṅwtsovawtaqamuy amumum tsovaltiniqat pam paṅqawu; nit Paul hawnaqe, put pumuy amutpipo tavi. ");
INSERT INTO hopNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pahsat pu Paul moṅwtsovawtaqamuy amuhpa’ taynumt paṅqawu: Tahtaqtu, isinomu, nu pew pahsavohaqami God atpip iunaṅway pasiwk̇aṅw qatu. ");
INSERT INTO hopNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Noqw put aqlap hoṅqam put moava wuvahtotaniqat God awwat mohpeq moṅwi Ananias pumuy amumi paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Noqw pahsat pu Paul paṅqawu: God uṅ wuvahtani, um tumalwiwhput antaqa; pas as um nuy tutavot an yukunaniqe ōviy pep qatuk̇aṅw, ya um hinhtiqw tutavot hin lavayhtiqat qa anhtiqe soq nuy wuvahtiwniqat paṅqawu? ");
INSERT INTO hopNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Noqw aṅ hoṅqam paṅqaqwa: Ya um hinoqw God awwat mohpeq moṅwit aw panhaqam hiṅqawu? ");
INSERT INTO hopNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pahsat pu Paul paṅqawu: Nu put God awwat mohpeq móṅwitniqw qa navoti’taqe ōviy paṅqawu isinomu; pi ura yan pey’ta: Um uhsinmuy amumi moṅwit qa aqw hiṅqawlawni. ");
INSERT INTO hopNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Noqw Paul māmatsq, kurs pētu Sadducee‐sínomyaqw, pu pētu Pharisee‐sínomyaqw, pahsat pam tsovawtaqamuy amumi k̇ēew paṅqawu: Tahtaqtu, isinomu, nu Pharisee‐sino, nu Pharisee‐sinot tíata; nu hapi hihta ṅȫyit‐nik̇aṅw pu so’pum ahoy tātayyaniqat tuptsiwni’taqey ep pu’ tūviṅtiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Yan pam hiṅqawhq, pahsat ima Pharisee‐sinom Sadducee‐sinmuy amumum qa súnahpa’totiqw sinom nātsiki. ");
INSERT INTO hopNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadducee‐sínmuyniqw pi sinom pas soon ahoy yesvani, pu yaw ōṅaqw hoṅviaya qa háqamo, pu yaw hakiy hikwsiat qa háqamo. Noqw Pharisee‐sinom put sohsok tuptsiwni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Noqw pas sinom a’nö mowawatota; noqw ima tutavot tūtutuqaynayaqam Pharisee‐sinmuy amún unaṅwtotiqam hoṅvaqe a’no nāṅwuy’yuṅqe paṅqaqwa: Pay itamuyniqw i’ taqa qa hinta; tis pi kurs k̇a antsa hikwsi, sen hoṅviaya put aw yuaaykuniqw, pay itam God aw qa rohomnumyani. ");
INSERT INTO hopNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Noqw pas puma nānami a’nö hiṅqaqwaqe, sumataq put nāhoy tutkitotaniqat mohpeq solāwamoṅwi tusitaqe, pumuy amumi solāwamuy hōna, puma pumuy Paul nawhkiye’, solāwakimi wikyaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Noqw ep mihikq, Tutuyqawhqa put ehpeq wunuk̇aṅw aw paṅqawu: Pay um qa hin unaṅway’tani, Paul. Pay um nuy Jerusalem ep hin lavayhtiqey pan nāt piw Rome epeq lavayhtini. ");
INSERT INTO hopNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Noqw tālawvaqw, haqawat Jew‐sinom nāwinyaqe nankiwakw pasiwnaya, ason pas puma Paul nīnayat, pu’ nȫnösaniqey, pu hikwyaniqey paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Noqw hakim lȫp sunat epnihqe hóyokiwtaqam pan pasiwnaya. ");
INSERT INTO hopNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Pu ōviy puma God awwat mohpeq momṅwituy‐nik̇aṅw, pu wukw’a’yatuy amumi ö́kihqe paṅqaqwa; Itam nēṅem pasiwnayaqe kítota: Pas ason itam Paul nīnayat, pu’ nȫnösani. ");
INSERT INTO hopNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Oviy uma moṅwtsovawtaqamuy amumum mohpeq solāwamoṅwit aw paṅqaqwaqw, pam qāvo pew umumi put wikni, suhpan uma put pas pavan hin nanaptaniqey pan hink̇ahk̇aṅwo; noqw pay nāt put pew qa pituqw, itam nīnayaniqey pasiwni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Noqw puma put moqmani’yuṅqat Paul tiw’ayaat navotqe, solāwakimi pákihqe, Paul put āawna. ");
INSERT INTO hopNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pahsat pu Paul solāwamuy amumi moṅw’iwyuṅqamuy sukwat wáṅwayhqe aw paṅqawu: Um it tiyot mohpeq solāwamoṅwit aw wikni. I’ put hihta āawnani. ");
INSERT INTO hopNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Pu ōviy pam mohpeq solāwamoṅwit aw put wikqe paṅqawu: Paul, siviṅuiwtaqa nuy wáṅwayhqe, nu it tiyot ūmi wikniqat inumi paṅqawu. Yaw pam nu hihta āawnani. ");
INSERT INTO hopNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Pahsat pu mohpeq solāwamoṅwi put māyat ṅuat, qalavo wikqe, tūviṅtaqe aw paṅqawu: Ya um hihta nuy āawnani. ");
INSERT INTO hopNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Noqw pam paṅqawu: Um yaw qāvo moṅwtsovawtaqamuy amumi Paul wikniqat Jew‐sinom ūmi öqaltotiniqey sun unaṅwtoti, suhpan k̇a yaw puma put pas pavan hin nanaptaniqey nānawaknaqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Noqw um hapi amumi qa ūnatini; taq pumuy amuṅaqw lȫp sunat epnihqe hóyokiwtaqam tahtaqt nankiwakw pasiwni’yuṅqam put moqmani’yuṅwa paṅqawk̇ahk̇aṅwo: Ason pas yaw put nīnayat, pu nȫnösani, pu hikwyani; nihqe ōviy pas yukiwk̇ahk̇aṅw, uṅ panhtiniqey paṅqawniqat ōviy maqaptsi’yuṅwa, pam aw kita. ");
INSERT INTO hopNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Noqw ōviy mohpeq solāwamoṅwi tiyot mātavi paṅqawk̇aṅwo: Um hapi nuy it āawnaqey qa hakiy aw paṅqawni. ");
INSERT INTO hopNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Pu pam solāwamoṅwit aw paṅqawu: Uma pakwút‐sikip sunat solāwamuy mihikq, Caesareat aqwyaniqat na’sastani, pu kawaymuy akwyaqamuy payhp sunat aṅqw pakwt sihk̇ay’taqamyuy, pu pakwút‐sikip súnat lansay’yuṅqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pu puma Paul hihtuy akwniqat na’sastotani, nen uma tutskwat aw moṅwit Felix aqw put pās wikyani. ");
INSERT INTO hopNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Pu pam yan pēna: ");
INSERT INTO hopNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Nu’ Claudius Lysias it pas pavan Felix tutskwat aw moṅwit öqala. ");
INSERT INTO hopNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","It tāqat Jew‐sinom ṅuayaqe, soon as qa nīnayaniqw, nu solāwamuy tsamk̇aṅw amuminihqe, it pumuy nawhki, yaw pam Roman‐sínonihqat nu navotqe ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Noqw puma hihta put nēveltotoynayaqat nu pas suyan navotniqey nāwaknaqe, pumuy amuṅaqw moṅwtsovawtaqamuy amumi put wikva. ");
INSERT INTO hopNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Noqw kurs pay puma tutavoy ep hinhtotiqe pay qa hihta mokiwuy, pu sivihpit hihk̇ay’taqat put tsok̇anaya. ");
INSERT INTO hopNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Noqw yaw Jew‐sinom put moqmani’yuṅqat nuy āawnayaqw, pahsat pay nu put ūmiq hōnaqe, put hihta tsotsk̇anayaqam put aw hinyuṅqey utpip paṅqawu. Hak öqawmaṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Pahsat pu solāwam amumi hin tutaptiwhqat anhtotiqe Paul wikyaqe, míhikpuva Antipatris ep wikvaya. ");
INSERT INTO hopNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Pu qavoṅvaqw ima nāpyaqam Paul mātapyat, paṅqw Jerusalem ahoy aqwya. Noqw ima kawaymuy akwyaqam pahpiy put ámumya. ");
INSERT INTO hopNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nihqe puma Caesareat ep ö́kihqe, tutskwat aw moṅwit tutuvenit maqaya, nit put aw Paul noaya. ");
INSERT INTO hopNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Noqw moṅwi tutuvenit aṅ túṅwahqe, pam haqaqwat tutskwat aṅqwnihqat put tūviṅta. Noqw kurs pam Cilicat aṅqwnihqat pam navotqe ");
INSERT INTO hopNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Paṅqawu: Ason uṅ hin tsok̇ani’yuṅqam tuwat ökiqw, nu uṅem hin yúkuni, kita. Nihqe pam Herod pavasiwhkiyat ep taviwniqat pam paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pu ahpiy tsivót‐sikis talq God awwat mohpeq moṅwi Ananias wukw’a’yatuy tsamk̇aṅw pitu, hakiy lavayhtuwi’taqat Tertullus yan mātsiwhqat wikk̇aṅwo; noqw pam tutskwat ep moṅwit aw yuaayku Paul ehpewii. ");
INSERT INTO hopNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pu ōviy Paul tuṅwáyaqw, pahsat Tertullus put ehpewi yuaaykuqe paṅqawu: Itam hapi uhpiy uyiwawtaqat qatsit nāvok̇awinta, pu sohsovik sutsep uhtunatyay ahpiy himu qaöwíhintaqa imuy sinmuy amuṅem hintsatskiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Noqw itam put tsúyakiwyuṅwa, um hak pas pavan Felix. ");
INSERT INTO hopNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Noqw pay nu ūmi qa sus’itsniqat ōviy um as okiw hihsavo itamumi tūqaytani. ");
INSERT INTO hopNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Taq itam it tāqat aw nanaptaqw, i’ sokovi. Pam it Nazareth aṅqw tāqat aw tōnawtaqamuy moṅwíamu. Noqw put atsviy tūwaqatsit aṅ ahsupoq Jew‐sinom Caesar ehpewi hoṅvanta. ");
INSERT INTO hopNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Pu hikis pi as ōviy i’ piw God kīyat sokoptaniqey anhti; noqw itam put ṅuayaqe, soon as itamumi hin tutaptiwhqat qa anwat put hin yukunayani. ");
INSERT INTO hopNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Noqw pay mohpeq solāwamoṅwi Lysias itamumi suptuqe, öqalay akw put itamuy nawhki, ");
INSERT INTO hopNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nihqe hihta put nēveltotoynayaqam ūmiyaniqat paṅqawu. Noqw um nāp put aw pohte’, itam hihta put qalománeveltotoynayaqat sohsok navotni. ");
INSERT INTO hopNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Noqw Jew‐sinom put amum sunyaqe, pay pas pantaqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Pahsat pu moṅwi Paul yuaaykuniqat aw māmasaqw, pam lavayhtiqe paṅqawu: Nu’ navoti’taqw um hisatṅahaqaqw imuy sinmuy amuṅem hihta aṅ hin wūwanma, noqw ōviy nu tuwat hahlayk̇aṅw, nēṅem hin lavayhtini. ");
INSERT INTO hopNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ispi um it navotniq’ö, nu okiwlawniqe Jerusalem aqwniqw, nāt pu’ ahpiy pakwt lȫq sihk̇ay’tasikis tāla. ");
INSERT INTO hopNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Piw nu qa haqam hakiy amum nāṅwuy’taqw puma inumi tāyuṅwa, pu sinmuy hin u’naṅwnaq’ö, sen God kīyat ep’e, sen tsotsvalkivee, sen pay kīvee. ");
INSERT INTO hopNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Piw puma hihta nuy tsotsk̇anayaqey soon suyan paṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nīk̇aṅw it pay nu ūmi pas súaṅqawni: Nu hapi púmuyniqw qasuan God aw nāwakinma, iwu’yamuy aw yantaqayamuy aw’i, tutavot aṅ hin pey’taqat, pu God lavay’aymuyatuy pēniyamuy aṅ hin pey’taqat sohsok tuptsiwni’k̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nihqe ima súanyuṅqam, pu qasuanyuṅqam so’pum ahoy tātayyaniqat, nu ep God qapēvewna; noqw pay puma piw put pantaqat lavayta. ");
INSERT INTO hopNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Paniqw hapi ōviy nu yūmosa suyan unaṅway’taniqey tuwanlawu, qa hihta ep qaanhtiqey navoti’taqee, sen God ep’e, sen sinmuy amuhpee. ");
INSERT INTO hopNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Pu ahpiy wūhakis yahsaṅwvaqw, nu isinmuy amumi ahoy pitu, hihta akw ōkwatuwiwyaniqat kuwahtiwhqat‐nik̇aṅw, pu Tutuyqawhqat aw himu noiwhqat yank̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Pantaqat atsve hakim Asiat aṅqw Jew‐sinom nuy God kīyat ep napwataqw tutwa, nu qa k̇aysiwhqamuy sinmuy amumumniq’ö, piw hin qaqtsinayaqamuy amumuma. ");
INSERT INTO hopNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Puma pi as yep utpipye’, rohomtotinik̇ahk̇aṅwo, kurs hihta inuhpewi hinyuṅwee. ");
INSERT INTO hopNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Hal pay pi ima yepyaqam paṅqaqwani, nāt nu moṅwtsovawtaqamuy amutpip wunuqw hihta inumi qalomátutwee. ");
INSERT INTO hopNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Hal sen pi nu amuhsonve wunuk̇aṅw it supwat paṅqawhqat ep’e: Nu hapi so’pum ahoy tātayyaniqat tuptsiwni’taqey ep pu’ it tāwat ep umuhpiy hin tūviṅtiwa, kítahqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Noqw Felix it navotqe, paṅwat pöhut pas suan navoti’taqe pumuy pay hāktaqe amumi paṅqawu: Ason mohpeq solāwamoṅwi Lysias pituqw, nu uṅ hinhtiqat pas sohsok navotni. ");
INSERT INTO hopNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pu tsivot‐sikip sunat solāwamuy amumi moṅwi Paul tavi’taniqat pam put aw paṅqawu. Nīk̇aṅw pay qa pas pas hūrs tavi’tat, pay tuwimat hihta akw put paaṅwayaniqw, sen put awyaniqw, pam pumuy qa mēwantani. ");
INSERT INTO hopNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Noqw ahpiy hihsakis talq Felix hakiy Jew‐sinot nȫmay Drusillat amum pitu; nihqe Paul wáṅwayhqe, Christ aw qapēvewnit put ahpiy aw tūqayta. ");
INSERT INTO hopNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Noqw Paul put aw paṅqawu: Itam soon qa suan hinwise’, namituyqawi’yuṅwni. Taq God itamuṅem hin yúkuni. Noqw Paul yan yuaataqw, Felix tsawnaqe, tururuyku; nihqe paṅqawu: Pay um hāk pu’ ahpiyni; ason hisat inuṅem aw lomahinhtiqw, nu uṅ wáṅwayni, kita Paul aw’i. ");
INSERT INTO hopNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Noqw as sakiqw Paul put sīvat maqaqw pam put mātapniqey wūwanta. Nihqe ōviy pam piép put wáṅwaye’, amum yuaataṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Noqw pay ahpiy lȫs yahsaṅwvaqw, Porcius Festus Felix qeniyat ep paki; noqw Felix Jew‐sinmuy tayawnaniqey nāwaknaqe, Paul nāto sómiwtaqw ahpiy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Noqw Festus tutskwamakiway ep pítuhqe, ahpiy pāyis talq Caesareat aṅqw Jerusalem aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Noqw pahsat pu God awwat mohpeq móṅwi‐niqw, pu Jew‐sinmuy amuṅaqw pavansinom put aw Paul lavayta. ");
INSERT INTO hopNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Nihqe as pam put ehpewi pumuy amuṅem hihta hinhtiniqat aw nānawaknaqe pam put wáṅwayhq, Jerusalem aqwniqat aw ö’qalya, puma haqam put moqmaye’ nīnayaniqey tunatyawk̇ahk̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Noqw Festus lavayhtiqe, pay Paul Caesareat epeq qátuniqat paṅqawu, pay pam soon pas hisat nāp paṅsoqniqey paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Oviy amuṅaqw haqawat ö’qalt inumumyani, kita. Nen kurs it tāqat ep himu qalomáhintaniqw paṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Noqw pam pumuy amumum pakwút‐sikis haqam talöṅnat, Caesareat aqw’a; nihqe qavoṅvaqw, pam haqam hin yukiltiṅwuqat ep qatuptuqe, Paul wik‐wisniqat paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Noqw pam pituqw, Jew‐sinom Jerusalem aṅqw ö́kihqam put aqlaq hoṅk̇ahk̇aṅw, hīhihta nuhtsel’e’wakw nihtiwhtaqat Paul ehpewi yuaatota; nit pay put pas suyan pantaqat kurs hin paṅqaqwani. ");
INSERT INTO hopNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Noqw pam nēṅem lavayhtiqe paṅqawu: Nu qa haqam Jew‐sinmuy tutavoyamuy ehpewi hinhti, piw God kīyat ehpewii, pu Caesar ehpewii. ");
INSERT INTO hopNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Noqw tuwat pay Festus Jew‐sinmuy unaṅwve hinhtiniqey nāwaknaqe, Paul aw paṅqawu: Ya um qa Jerusalem aqwnen, pepeq inutpip īit yantaqat ep hin aw pohtiwniqey nāwakna? ");
INSERT INTO hopNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pahsat pu Paul paṅqawu: Nu Caesar pavasiwhkiyat ep wunu, pi nu pep hin yukuniwni; pi nu qa haqam hihta ep Jew‐sinmuy amumi qalomáhinhtiqw um suyan navoti’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Pi as nu haqam hihta ep hinhte’, sen mokiwuy hihk̇ay’taqat hinhte’ soon nu moknik rohomnumni; nīk̇aṅw kurs pay ima nuy hīhihta qalomátsotsk̇anayaqw pam qa himuwa pas antsaniqw, soon hak nuy pumuy amumi nóani. Nu Caesar aw taqa’naṅwti. ");
INSERT INTO hopNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Pahsat pu Festus wuwan’ayamuy amumum hin hintaniqat yuaaykuqe put aw lavayhtiqe paṅqawu: Noqw um Caesar aw taqa’naṅwti? Pay um soon Caesar qa aqwni. ");
INSERT INTO hopNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Noqw ahpiy hihsakishaqam talq, Moṅwi Agrippa Bernice amum Festus aw hahlayhtiniqe Caesareat ep pitu. ");
INSERT INTO hopNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Pu ōviy Festus Agrippat aw Paul lalvayhqe paṅqawu: Felix ahpiynihqe, hakiy tāqat sómiwtaqat mātavi. ");
INSERT INTO hopNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Noqw ura nu Jerusalem épeqniqw, God awwat mohpeq momṅwit Jew‐sinmuy wukw’aymuyatuy amumum nuy put hin āawnayaqe, eṅem qalomáyukiltiniqat nānawakna. ");
INSERT INTO hopNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Noqw nu pumuy amumi lavayhtiqe paṅqawu: Kurs uma hihta ep put qalomátsok̇anayaqw, pay pam umuhpewinen nēṅem hin lavayhtiniqat put eṅem qenitiwni. Noqw kurs pam pas antsa hihta mokiwuy hihk̇ay’taqat hinhte’, pep pu’ pam mokiwuy aw noiwni. Pu pam nāto qa nēṅem hin lavayhtiqw, kurs nu hin put tūvani. Pan hapi Rome aṅqw sinmuy tuwiamu. ");
INSERT INTO hopNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Noqw ōviy pumuy ökiqw, nu qa sȫwunit, qavoṅvaqw haqam hin yukiltiṅwuqat ep qatuptuqe, put tāqat wik‐wisniqat paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Noqw ima put hihta qalomátsok̇anayaqam hoṅvaqe, qa hin iwuwniy an put hihta tsok̇anaya. ");
INSERT INTO hopNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Pay tuwat soq kurs pas nāp tuptsiwniy ep put amum nenṅem hinyuṅwa, pu hakiy Jesus mokqat ep’e. Noqw pay Paul put pay suyan qátuhqat paṅqawlawhqat ep’e. ");
INSERT INTO hopNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Noqw nu pūvut pantaqat ep wiwsiqe, sen pam Jerusalem aqwnen pepeq īit hihta ep aw pohtiwniqat put tūvinta. ");
INSERT INTO hopNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Noqw pay ason pas Moṅwi Augustus Paul aw hihta ep hin navotniqat pam paṅqawhq, ōviy nu ason hisat put Caesar aqw táviniqat aw pahsavo pay hāk put pani’yuṅwniqat nu paṅqawu. ");
INSERT INTO hopNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Noqw Agrippa Festus aw paṅqawu: Is as tuwat aw tūqayta. Um qāvo aw tūqaytani, pam kita. ");
INSERT INTO hopNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Qavoṅvaqw Agrippa Bernice amum pas pavan k̇āhink̇aṅw, haqam hihta yuaatotaṅwuqat aw paki, aṅ pas pavan solāwmomṅwituy‐nik̇aṅw pu kitsókive pas pavansinmuy tsamk̇aṅwo; pu ōviy Festus paṅqawhq, Paul wikvaya. ");
INSERT INTO hopNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Noqw Festus paṅqawu: Moṅwi Agrippa, pu uma sohsoyam tahtaqt itamumyaqamu, uma it tāqat aw tāyuṅqw, it hapi ep sohsoyam Jew‐sinom inumi ökiwta, Jerusalem epeq’a, pu yep’e; nihqe pay pāpu pas pam qa qátuniqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Noqw nu navotq, kurs pay pam qa haqam hihta mokiwuy hihk̇ay’taqat hinhti. Pu piw pam pas nāp Augustus aw taqa’naṅwtiqw, ōviy nu put aqw táviniqey pan yuku. ");
INSERT INTO hopNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Noqw pas nu imoṅwiy aqw kurs hin pas suyan hihta put pēnani; nihqe ōviy nu paniqw it umutpipo wikva, tis pi ōviy pas utpipoo, Moṅwi Agrippa; ason put aw pohtiwhq, pep pu’ pay k̇a nu sen hin pēnani. ");
INSERT INTO hopNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ispi hak hakiy sivilawhqat paṅsoq távinik̇aṅw, hihta ep qaantaqat qa paṅqawniqw, pam pay nuyniqw qa wuwni’hinta. ");
INSERT INTO hopNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Pahsat pu Agrippa Paul aw paṅqawu: Taay, pay pi um nēṅem hin lavayhtini. Pahsat pu Paul māvuyaltit, nēṅem lavayhtiqe paṅqawu: ");
INSERT INTO hopNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Pas nu nánapnihqe sakina, Moṅwi Agrippa, kurs nu pu’haqam Jew‐sinmuy amuhpiy sohsok hihta tsok̇aniwhqey ep utpip tuwat hin lavayhtiniqey ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Tis pi Jew‐sinmuy sohsok hintsakpiyamuy‐nik̇aṅw, pu hīhihta aṅ qa súnahpay’yaqw, it um pās navoti’taqw, nu put navoti’ta. Noqw ōviy as um okiw inumi pās tūqaytani. ");
INSERT INTO hopNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Pay nu itsákoy aṅqaqw mohti imuy pas nāp isinmuy amumum Jerusalem epeq hin qatuqw, sohsoyam Jew‐sinom put navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Nihqe puma paṅqaqw inumi navoti’yuṅqe, as suhtaq’ewye’ paṅqaqwanik̇aṅwo. Ura nu itahtuptsiwniy pas aṅqe’ hinwisqamuy amumum pantaqe, Pharisee‐sínoniṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Noqw God itanamuy hihta āawnaqw, put aw yantaqey ep nu pu’ yep tūviṅtiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Noqw put awinit hapi itahsinom pakwt lȫq sihk̇ay’tasikip himuñam okiw as aw ö́kiniqey tunatyawk̇ahk̇anw aṅqaqw nāqavo pu tōkilat aṅ God tumalay’yuṅwa. Noqw nu’ hapi put ṅȫyit ep Jew‐sinmuy amuhpiy hihta qalomátsok̇aniwa, Moṅwi Agrippa. ");
INSERT INTO hopNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ya hinoqw God so’pumuy ahoy tātaynaniqw pam pantaqa úmuyniqw qa tuptsiwnieway’o? ");
INSERT INTO hopNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","As pi nu pas antsa hisat nāp pan wūwantaṅwu, pas Nazareth aṅqw tāqat Jesus natṅwaniyat soon ehpewi hīhihta qa hintsakniqeyu. ");
INSERT INTO hopNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nihqe ōviy nu Jerusalem epeq panhtiqe, k̇aysiwhqamuy put sinomuyatuy sivikimi taṅata, awwat mohpeq momṅwituy amuṅaqw öqalat makiwhqee; nihqe nu pumuy qöqyaniqw amunkiwakw lavayhtiṅwu. ");
INSERT INTO hopNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nihqe puma as pas qalomáhiṅqaqwaniqat ōviy nu ahsupoq tsotsvalkiva pumuy sivintotoynatinuma, pu nu pas pumuy amumi itsívuiwtaqe a’löṅöt kitsókit aṅ enaṅ pumuy okiwsahsana. ");
INSERT INTO hopNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Pank̇aṅw nu God awwat mohpeq momṅwituy amuṅaqw öqalat pasiwk̇aṅw Damascus aqw’a. ");
INSERT INTO hopNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Noqw meh, Moṅwi, nu paṅsoqniqw, tāwanasave ōṅaqw tāla tāwat epnihqe pas suyan tālat inuqlap‐nik̇aṅw, pu inumumyaqamuy amuqlaq tālawvaqw nu tuwa. ");
INSERT INTO hopNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Noqw itam sohsoyam tutskwami löhökq, nu hakiy inumi hiṅqawhqat tönayat navotq, Hebrew‐sinmuy amuhkwa inumi paṅqawu: Saul Saul, ya um hinoqw nuy okiwsahsana? Um tsutskuy’yuṅqat aqw horarataqw pam uṅem anahaa. ");
INSERT INTO hopNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Noqw nu paṅqawu: Ya um hak’i, Tutuyqawhqa? Noqw pam paṅqawu: Nu Jesus; um nuy hapi okiwsahsana. ");
INSERT INTO hopNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nīk̇aṅw pay um qatuptut, uhkukuy akw wunuwtani; pi nu yaniqw ūmi nāmataqta, um inuṅem hintsakniqat nu pan uṅ yukuniqey ōviy’o, pu um īit hihta aw yórikqey, pu nāt nu hīhihta aṅ ūmi mātaktiniqat tuawi’taniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nu uṅ imuy pas sinmuy amuṅaqw ayo tahtaptimani, pu qa‐Jew‐sinmuy amuṅaq’ö. Nu hapi pumuy amumi uṅ pu’ ayataqw, ");
INSERT INTO hopNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Um pumuy pōsiyamuy tālawnani, pu qatālat aṅqw tālat aw lasnani, pu Satan öqalayat aṅqw God aw’i, pumuy qaanhtipuam amuhpiy ayo yukiwniqat ōviy’o, pu inumi tūtuptsiwe’, isinomuy amumum hihta makiwyaniqat ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Yaniwhti, Monwi Agrippa, noqw ōviy nu hihta ōṅaqwnihqat aw yórikqey aw qa rohomnumt, ");
INSERT INTO hopNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mohti Damascus ep yesqamuy put āawna, pu Jerusalem epeq yesqamuyu, pu Judeat qaqlavaqe yesqamuyu, nit aṅk pu qa‐Jew‐sinmuyu. Puma qaantunatyay aṅqw lasye’, God awwat nánamtök̇aniqat nu amumi yuaata, nen aw hayawtaqat yesni. ");
INSERT INTO hopNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yāyantaqat ep Jew‐sinom God kīyat ep nuy ṅuayaqe, as nuy nīnayaniqey anhtoti. ");
INSERT INTO hopNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Noqw nu God paaṅwniyat akw yukhaqami pitsíwiwta, aṅ söqavuṅwsinmuy, pu pavansinmuy amumi nan’ivo put yuaataqe, God lavay’aymat‐niqw, pu Moses puma nāt hin hintaniqat lavayhtotiqat nu aṅqw qa hihta alöṅöt yuaata, ");
INSERT INTO hopNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ura kurs pi Christ okiwsaniwniqata, pu pam hakimuy so’pumuy amuṅaqw pas mohti tātayniqata; nen imuy Jew‐sinmuy amumi tālawnani, pu pay qa‐Jew‐sinmuy amumii. ");
INSERT INTO hopNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Yan pam nēṅem yuaataqw, Festus a’nö paṅqawu: Paul, um hōnaq’iwta, um hīhihta navoti’taqe put akw hōnaq’iwta. ");
INSERT INTO hopNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Noqw pam paṅqawu: Nu qa hōnaq’iwta, um pas pavan Festus; pi nu suyan unaṅway’k̇aṅw īit pas qaatsat yuaata. ");
INSERT INTO hopNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Pi Moṅwi Agrippa sohsok īit navoti’ta; noqw nu qa nánahinkinak̇aṅw put atpip yuaata; pi nu nātuptsinaqw pas k̇a īi’ qa himu put aw tupkiwta; pi i’ qa nanauyve hiniwhti. ");
INSERT INTO hopNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Moṅwi Agrippa, ya um God lavay’aymuyatuy lavayiyamuy tuptsiwni’ta? Pay um suyan tuptsiwni’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Pahsat pu Agrippa Paul aw paṅqawu: Pas nuy Christian‐tiniqat um pēp aw nuy áṅwuta. ");
INSERT INTO hopNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Noqw Paul paṅqawu: Pas hapi um’i, pu sohsoyam inumi tūqayyunqam aṅ ahsupoq inunyuṅwniqat nu God aw nāwakna, hal qa som’iwtaniqat‐saa. ");
INSERT INTO hopNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Yan pam lavayhtiqw, pahsat Moṅwi Agrippa wunuptu, pu tutskwat aw moṅwi, pu Bernice, pu pumuy amumum yesqamu. ");
INSERT INTO hopNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nihqe puma qalavoyaqe, pep put yuaatotaqe paṅqaqwa: Pay kurs as i’ tāqa qa hihta mokiwuy hihk̇ay’taqat hintsaki, pu sivihpita. ");
INSERT INTO hopNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Pahsat pu Agrippa Festus aw paṅqawu: Pas as i’ tāqa Caesar aqw qa taqa’naṅwte’, pay soon qa mātaviwni. ");
INSERT INTO hopNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Noqw itam pāvaqe Italyt aqwyaniqat pan yukiltiqw, puma hakiy Julius yan mātsiwhqat aw Paul pētuy sivilalwaqamuy enaṅ noaya; pam hak Augustus solāwamuyatuy amuṅaqw tsivót‐sikip sunat amumi moṅwi. ");
INSERT INTO hopNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Noqw itam pākihut Adramyttium aṅqwnihqat aqw yuṅqe, Asiat qaqlavaqe hinwisniqey tunatyawk̇ahk̇aṅw, pāvaqe hoyoyoykuya; noqw hak Aristarchus, Macedoniat ep Thessalonicat aṅqw sino, itamuma. ");
INSERT INTO hopNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Qavoṅvaqw itam Sidon ep öki. Noqw Julius Paul aw su’panihqe, pay kwatsmuy amuminen, suyan unaṅwtiniqat put nakwhana. ");
INSERT INTO hopNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Noqw itam paṅqw ahpiyyaqe Cyprus ehpeq hoyoyotota, Cyprus itamuhsa’ hukw’uhtsiwtaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Noqw itam Ciliciat‐nik̇aṅw Pamphyliat pumuy qalavaqe pātuwaqatsit aṅqe’ hoyóyototak̇aṅw, Lyciat ep wuhkokitsokit Myra yan mātsiwhqat aw öki. ");
INSERT INTO hopNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Noqw pep Alexandriat aṅqw pākihu Italyt aqwniqat solāwamoṅwi túwahqe, itamuy paṅsoq taṅata. ");
INSERT INTO hopNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Noqw itam wūhakis tālat aṅ pāvaqe híhin hoyóyototaqe, k̇ānanaptat, Cnidus aqlavo öki; noqw hūk̇aṅw itamuy qa nakwhanaqw, ōviy itam Crete yoñiyat aṅhqe Salmonat ehpeqya. ");
INSERT INTO hopNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nihqe itam híhinhaqam put ruhpakyaqe haqam Lomayoñipsö yan mātsiwhqat aw öki; put aqlap kitsóki Lasea yan mātsiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Noqw wūyavotiqw, pay napwaltalöṅnit aṅ ayo ruhpakq, ōviy pāvaqe nuhtsel’ewayhinhtiqw, pahsat pu Paul hintaniqat pumuy āawnaqe, ");
INSERT INTO hopNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Amumi paṅqawu: Tōtimu, sumataq itam yaṅhqe haqamiyak̇aṅw, a’nö hinhtotini; pas himu a’nö súlawhtini, qa umuhhoi‐saa, pu qa pākihu‐saa, pas itahqatsi pīwu. ");
INSERT INTO hopNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Noqw pay solāwamoṅwi pākihut wárikni’maqat aw‐nik̇aṅw pu put himuy’taqat púmuy‐sa amumi tuqayvasta, qa Paul lavayiyat aw’i. ");
INSERT INTO hopNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Noqw pep pösö qalomáhintaqw, kurs hin hak pep kwaṅwátömölaniqw, pay ōviy suswuhaqnihqam paṅqw ahpiyyaniqey nānawakna, pay sen as puma Phenicet aw ök̇e’, pep tömölayaniqey ōviy’o; pam Crete ep hötsiwa, tātöq‐tēveṅe qātsi, pu kwiniwiq‐tēveṅee. ");
INSERT INTO hopNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Noqw tatk̇aqw sūmawvaqw, puma tunatyay aw yórikyaqey wūwayaqe, wiwamniy rupamnayaqe, pahpiy hoyóyoykuyaqe, Crete áhayhk̇e’ pāyawwisa. ");
INSERT INTO hopNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Noqw pay nāt ahpiy qa wūyavotiqw, kwiniñaqw, pu hōpaqw amuhtsava wukohukva itamuhpewii. ");
INSERT INTO hopNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Noqw pākihu sóonhtiqe, kurs hin hūk̇aṅwuy ehpewi yūmo hóyokniqw, itam náwustotaqw pam huhukhoya. ");
INSERT INTO hopNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Noqw itam pāṅaqw tutskwat kuytaqat Clauda yan matsiwhqat yoñiyat aṅqe’ huhukhoyyaqe k̇ānanaptat, pākihut mask̇ay’wisqey áṅwutota. ");
INSERT INTO hopNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Noqw puma put wupnayaqe, hihta mask̇ay pākihut kwewtoynaya; nāphisat k̇a sen puma tsivohk̇at aqw huhukhoyyaniqe, puma mötsápvuyalnit hawnayaqe pahpiy huhukhoyya. ");
INSERT INTO hopNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Noqw pas itam hūk̇aṅwuy akw paysoq nāhoy tutuptiwyaqw, ōviy qavoṅvaqw puma pākihut aṅqw putuyat pētsaṅwaya. ");
INSERT INTO hopNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Pu aṅk talöṅvaqat ep itam nāp itahmay akw pākihut hihta a’wiwayat maspaya. ");
INSERT INTO hopNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Noqw wūhakis talöṅvaqat aṅ tāwa, pu sōtu pas qa mātsiltotiqw, pas itamumi qaan’ewakw hūhukq, pahsat pu itam pay hin ayo nö́ṅakniqey naṅ’eknaya. ");
INSERT INTO hopNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Noqw pas puma wūhakis qa nȫnösaqw, pahsat pu Paul pumuy amuhsonve wunuptuqe paṅqawu: Tōtimu, pas as uma inumi tuqayvastote’, Crete aṅqw qa ahpiyyanik̇aṅwo, nen qa yanhaqam okiwhinhtotini, pu hihta kwayhyani. ");
INSERT INTO hopNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Noqw pay nu umumi paṅqawni: Uma hahlayyani, pay qa haqawa umuṅaqw qatsiy kwayhni; pay pākihu‐sa súlawhtini. ");
INSERT INTO hopNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Pi nu God sinoatnik̇aṅw put eṅem tumalay’ta. Noqw put hoṅviayaat pu’ it tōkilat ep inuhpeq wunuk̇aṅw, ");
INSERT INTO hopNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Inumi paṅqawu: Pay um qa tsawiniwtani, Paul; pay um pas soon Caesar atpipo qa wīkiwni; noqw meh, God hapi utsviy sohsokmuy umum hoyóyototaqamuy ayo óyani. ");
INSERT INTO hopNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Noqw ōviy’o, tōtimu, uma qa hin unaṅway’yuṅwni; pi nu God qapēvewnaqw, pas inumi hin lavayhtiqw, soon pam qa antani. ");
INSERT INTO hopNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nīk̇aṅw pay itam haqam pāṅaqw tutskwat kuytaqat soon aw qa hukhoyyani. ");
INSERT INTO hopNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Noqw pakwt nālöq sihk̇ay’tasikis míhikqat ep itam Adriat aṅqe’ nāhoy huhukhoylalwaqw, tōkilnasaveqhaqam ima pākihut tumalay’yuṅqam yaw sumataq haqami tutskwat aw hayiṅwnayaqey wūwaya; ");
INSERT INTO hopNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Nihqe pāmiq hötsítuwantotaqe, sunát‐sikip mamkit pan hötsit nanapta; nit pu ahpiy híhin yūmoyat piw tuwantotaqw, pahsat pay pakwt tsivot sihk̇ay’tasikip mamki. ");
INSERT INTO hopNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Pahsat pu k̇a sen itam o’wat aqw óṅokyaniqw, puma pākihut ahkwayñavoqw nālöq putuhaynit pāmiq maspayat, tālawvaniqat maqaptsi’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Noqw pākihut tumalay’yuṅqam watqaniqey tunatyawyuṅqe, pākihut moṅaqw putuhaynit maspayaniqey atsáy’k̇ahk̇aṅw, tsākw pākihut pāmiq hāhawnayaqw, ");
INSERT INTO hopNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paul solāwamoṅwi aw‐nik̇aṅw pu solāwamuy amumi paṅqawu: Pas ima pākihut ep qa huruhtotiqw, soon uma ayo nö́ṅakni. ");
INSERT INTO hopNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Pahsat pu solāwam tsākw pākihut somiyat tutkitotaqw, pam pohsi. ");
INSERT INTO hopNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Noqw tālawiwmaqw, puma sohsoyam nȫnösaniqat Paul amumi öqalti paṅqawk̇aṅwo: Pu’ hapi pakwt nālöq sihk̇ay’taqat tālat aṅ uma tusiiwyuṅqe, nātsöṅkwayni’yuṅwa, qa hihta nȫnösaqee. ");
INSERT INTO hopNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Noqw ōviy nu umumi paṅqawni: Uma nȫnösani, nen öqawi’yuṅwni; pay soon umuy haqawat qötöyat aṅqw sūk̇a hȫmi súlawhtini. ");
INSERT INTO hopNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Yan pam lavayhtit, pölavikit kwusuhqe, pumuy sohsokmuy amutpik put ep God aw hahlayhtit, yōhaqe tūmoyva. ");
INSERT INTO hopNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Pahsat pu puma hahlayhtotiqe tuwat nōnova. ");
INSERT INTO hopNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Noqw itam pākihut aṅqw sūmiyaqe (276) pakwt payhkomuy sihk̇ay’tasikip súnatnik̇aṅw aṅqw pakwt nāvay sihk̇ay’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Noqw ōviy puma ȫöyaqe, pahsat pākihut putuyat pētsaṅwantotaqe, pāmiq söhövosit maspitota. ");
INSERT INTO hopNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Noqw tālawvaqw, puma tutskwat qa māmatsya; noqw haqami pösöy’taqat aṅ tutskway’taqw, pay k̇a as hin pasiwtaniqw puma paṅsoq pākihut panayaniqey wūwaya. ");
INSERT INTO hopNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Pu puma putuhaynit yayvanayaqe pāmiq nātatamhtotaqe, ponilanpiyat hihta akw sómiwtaqat ṅáṅahtotat, mohpeq mötsápvuyalnit hūk̇anwuy aqwwat pūyaknayat, pāhut qalavoq öqaltoti. ");
INSERT INTO hopNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nihqe puma haqam pāhu namiptsiwtaqat aw huhukwhoyyaqe pākihut tsivoktota; noqw móṅaqwnihqa hūrstiqe pas qa poninita; noqw yūmoqnihqa pāhut hoṅvantaqat a’nö öqalayat akw sakwíiwma. ");
INSERT INTO hopNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Noqw solāwamuy wuwniamniqw as pay puma sivilalwaqamuy qöqyani, taq k̇a himuwa qalavo momorstime’ wāyaniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Noqw solāwamoṅwi as Paul ayo táviniqey nāwaknaqe, pumuy tunatyayamuy aṅqw ahoy ṅuy’ta; nihqe momorstuwi’yuṅqam mohti pāmiq tsotsó’ye’ tutskwami nö́ṅakniqat paṅqawu, ");
INSERT INTO hopNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Pu ahpiy haqawat wunavutsit pu pākihut sakwítiqat aṅqw hiṅsaq hihta hinyuṅqat aṅ tsokiwk̇ahk̇aṅwyaniqata. Noqw pan puma sohsoyam qa hinhtotit tutskwami nȫṅa. ");
INSERT INTO hopNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Noqw puma ayo nö́ṅakqe, nanaptaqw kurs pam tutskwa Melita yan mātsiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Noqw pep hakim sinom itamuy pās o’ya; nihqe aw qöhyaqe, sohsokmuy itamumi unaṅwtapya yōyokk̇aṅw iyohooniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Noqw Paul kohot tsovalat, qȫhit aqw ōoyhq, tsūa qȫhit aṅqw yámakqe, put māyat kūkiqe, qa mātavi. ");
INSERT INTO hopNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Noqw tsūa put māyat aṅqw hāyiwtaqw, pep ki’yuṅqam aw yórikyaqe, nānami paṅqaqwa: Pas k̇a i’ tāqa hakiy nīna. Noqw pam pāmiq qa mokq, pas hihtu put aw nāoyyaniqe put qátuniqat qa nakwhanaya, kitota. ");
INSERT INTO hopNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Noqw Paul tsūat qȫhit aqw wipk̇alat, pay qa hinhti. ");
INSERT INTO hopNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Noqw suhpan as soon pam qa pöstiniqat, sen aṅqe’ múnuk̇e’ súmokniqat, puma wūwank̇ahk̇aṅw aw tāyuṅwa; nit pay pas wūyavo aw tāyuṅqw, pam qa hinhtiqw, pahsat puma wuwniy alöṅtotaqe, pam pas hímunihqat paṅqaqwa. ");
INSERT INTO hopNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Noqw pumuy háqamyaqw hak pep tutskwat ep mohpeq sino haqe’ hihta himuy’taqa Pulbius yan mātsiwa; noqw pam hak itamuy hahlayhtiqe, pāyis tālat aṅ itamuy kiy ep pās oyi’ta. ");
INSERT INTO hopNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Noqw kurs Publius naat mukitutuyk̇aṅw uṅwat pavakwutsqe, tuyhqatsi. Noqw Paul put aw pákihqe, eṅem nāwaknat, may akw aw hintsahqe qalaptsina. ");
INSERT INTO hopNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Panhtiqw, haqawat put tutskwat ep ki’yuṅqam hihta tūtuyyaqam ökiwtaqe, tūyay qalaptuya. ");
INSERT INTO hopNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nihqe puma tuwat hīhihta akw itamuy tayawnaya. Noqw itamuy ahpiyyaniqw, puma itamuy haqam hihta hinhtotiniqat itamuṅem hoahtota. ");
INSERT INTO hopNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Noqw itam pep payhkomuy mūmuyawhtuy aṅ yest, pākihut Alexandriat aṅqwnihqat akw paṅqw ahpiyya; pam pep pāṅaqw kuytaqat tutskwat ep tömöla, Castor‐nik̇aṅw pu Pollux pumuy tuvoylay’k̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Noqw itam Syracuse ep ö́kihqe, pep pāyis yēse, ");
INSERT INTO hopNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nit paṅqw pu itam poniwwisk̇ahk̇aṅw, Rhegium ep öki; nihqe ahpiy sūs talq tatk̇aqw hukvaqw, qavoṅvaqw itam Puteolit ep öki. ");
INSERT INTO hopNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nihqe pep itam tuptsiwni’yuṅqamuy tutwa; noqw itam pep pumuy amumum tsaṅe’sikis yesniqat puma itamumi ö’qalya. Yan itam hinwisk̇ahk̇aṅw, Rome epeq öki. ");
INSERT INTO hopNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Noqw pepeq tuptsiwni’yuṅqam yaw itamuy aṅqwyaqat nanaptaqe, haqami Appii pihk̇ayat‐nik̇aṅw pu Payhp Yeyespit aw pahsavo itamuhsawvawisa. Noqw Paul pumuy túwahqe God aw hahlayhtiqe, a’nö unaṅwti. ");
INSERT INTO hopNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Noqw itam Rome epeq ökiqw, solāwamoṅwi tuwalan’a’yatuy moṅwíyamuy aw sivilalwaqamuy noa; nīk̇aṅw pay Paul hakiy put tūwalaqat solāwat amum haqam nāla qátuniqat pan yuku. ");
INSERT INTO hopNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pu ōviy ahpiy pāyis talq Paul Jew‐sinmuy amuṅaqw mohpeqyaqamuy sūmi wáṅwayhqe, tsovaltiqw, amumi paṅqawu: Tahtaqtu, isinomu, pay as pi nu itahsinmuy‐nik̇aṅw, pu itanamuy tuwiyamuy ehpewi qa haqam hihta qaanhtit siviṅuiwk̇aṅw, Jerusalem aṅqw Rome‐sinmuy öqalayamuy aw mātaviwa. ");
INSERT INTO hopNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Noqw as puma inumi pohtayaqe, pay as nuy mātapyani, qa haqam himu mokiwuy hihk̇ay’taqa inuhpeniqw ōviy’o. ");
INSERT INTO hopNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Noqw Jew‐sinom put pantaqat ehpewi hiṅqaqwaqw, nu nawus Moṅwit Caesar aqw taqa’naṅwti, pay as nu qa hihta ep isinmuy amuhpewi hinhtik̇aṅwo. ");
INSERT INTO hopNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Noqw yaniqw nu umuy wáṅwayi, nu umumi yórikniqee, pu nu umumi yuaaykuniqee. Pi nu hapi Israel‐sinmuy ṅȫyiyamuy tunatyawtaqey ep it sivanamiqlölöt akw sómiwta. ");
INSERT INTO hopNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Noqw puma put aw paṅqaqwa: Itam Judeat aṅqw tutuvenit uṅ hin yuaataqat qa hihta kwusuya; piw itahsinom paṅqw ö́kihqam qa haqawa uṅ itamuy hin āawna, piw qalomáyuaayku. ");
INSERT INTO hopNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Noqw hin pi um wūwantaqw, itam as put nanaptaniqey nānawakna; pi itam navoti’yuṅqw imuy sutsvo tōnawtaqamuy amumi sohsovik qalomáyuaatiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Noqw puma put aw tokiltotaqe, k̇aysiwhqam put haqam qátuhqat ep öki. Noqw pam pumuy amumi God moṅwtunatyayat pās namtömink̇aṅw āwinta, it Moses tutavoyat aṅ‐nik̇aṅw, pu God lavay’aymuyatuy pēniyamuy aṅ hin Jesus yuaatiwhqat pam aw pumuy áṅwulawu, talavayṅahaqaqw tapkimiq pahsavoo. ");
INSERT INTO hopNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Noqw haqawat hin lavayhtiqat tūtuptsiwa; noqw pētu pay qa tūtuptsiwa. ");
INSERT INTO hopNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Noqw puma qa súnahpa’totiqe, ahpiy nankwusta Paul amumi sūkw lavayhtiq’ö: Pay kurs pas i’ Qahováriwtaqa Hikwsi God lavay’ayayat Isaias aṅ itanamuy amumi suan lavayhtiqe, ");
INSERT INTO hopNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Paṅqawu: Um imuy sinmuy amuminen, amumi paṅqawni: Uma as tūqayk̇ahk̇aṅw, nanaptat, qa māmatsyani, pu aw tayk̇ahk̇aṅw, tutwat, qa māmatsyani. ");
INSERT INTO hopNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Pi imuy sinmuy unaṅwaam tunaiwyuṅwa, pu puma naqsöp’iwyuṅwa, pu puma pōsiy uhtaya; taq nāphisat k̇a puma pōsiy akw tutwani, pu naqvuy akw nanaptani, pu unaṅway akw māmatsyani; nen ahoy namtökyaqw nu pumuy powatani. ");
INSERT INTO hopNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Oviy uma it nanaptani: God qa‐Jew‐sinmuy ayo óyaniqey pumuy āawnani; noqw puma soon qa nanaptani. ");
INSERT INTO hopNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Yan pam lavayhtiqw, Jew‐sinom ahpiyyaqe, nānami a’nö hihta yuaatota. ");
INSERT INTO hopNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Noqw Paul kīhut nasimok̇ahtaqey ep sivimaqe lȫq yahsaṅwuy aṅ pep qátuhqe, put aw ökiwtaqamuy sohsokmuy pās ōoyk̇aṅw, ");
INSERT INTO hopNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Amumi God moṅwtunatyayat yuaata; pu haqe’ Tutuyqawhqat Jesus Christ hin yuaataqat qa nánahtsopk̇aṅw tūtutuqaynaqw, qa hak put mēwanta.");
INSERT INTO hopNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nu’ Paul, Jesus Christ tūwikiat, it penta. God nuy wáṅwayhqe nuy ayata. Noqw ōviy nu put aṅqw lomatuawit yuaatinuma. ");
INSERT INTO hopNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ura pay hisat pam lavay’aymuy lomatuawit aṅwu pay āawnaqw puma tutuveniyat aṅ put pēnaya. ");
INSERT INTO hopNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Puma God Tiyat Jesus Christ Itahtutuyqawhqay lavayta. Put Tiat sinot anwat pítuhqe David ahpiy aniwhti. ");
INSERT INTO hopNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Noqw pay Qahováriwtaqa Hikwsi pam God Tíatnihqe öqalay’taqat nuhtumi tuawi’ta, ispi pam mokiwuy aṅqw ahoy tātayhq’ö. ");
INSERT INTO hopNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Noqw pam hapi nuy núokway akw tuaw’ayata. Noqw ōviy nu put tuṅwniyat aw yank̇aṅw sopk̇awtaqamuy sinmuy amumi lomatuawit yuaate’, haqawatuy tuyqawvani; noqw pep pu’ itahtuptsiwniy aṅ hinwisni. ");
INSERT INTO hopNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Noqw nu umumi piw ayatiwa; nāmahin pi Jesus Christ umuy pay nāmi wáṅwayi. ");
INSERT INTO hopNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nu umuy Rome epeq God sinomuyatuy öqalanta. God umumi unaṅway’taqe uma put sinomatniqat ōviy umuy wáṅwayi. Nam pam umuy núokwat, pu kwakwhat unaṅwat máqani, Itahtutuyqawhqay Jesus Christ ámuma. ");
INSERT INTO hopNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Pas nu sohsokmuy umuhpe hahlayhtima, Itanay God aw’i, Jesus Christ Itahtutuyqawhqay aṅ’a. Kwakwhat pi umuhtuptsiwni tūwaqatsit aṅ ahsupoq lomayuaatiwa. ");
INSERT INTO hopNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nu yūmosa umuṅem tūviṅtima. God pas nāp nuy súaṅqawhqat navoti’ta. Put hapi eṅem nu iunaṅṅaqw tumalay’ma. Nu put eṅem lomatuawit Tiyat yuaataqat sinmuy āwinta. ");
INSERT INTO hopNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Pas as okiw God pan tunatyawtaqw nāp hisat yepehaqtiqw nu qa haqam hinhte’ umumiq pohtaniqey ōviy nu put aw tūviṅtima. ");
INSERT INTO hopNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Pas nu as umumi yórikniqey nāwakna, nen hihta Hikwsit aṅqw tutuqayhqey umumi mātapq uma öqawhtotani. ");
INSERT INTO hopNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","It nu paṅqawu: Nu umumum yantaqw itam na’qalayani‐umuhtuptsiwniy aṅ‐nik̇aṅw pu ituptsiwniy aṅ’a. ");
INSERT INTO hopNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Noqw pay nu umuy it navotnaniqey nāwakna, itupkomu: Nu as piép umumiqniqey unaṅwtiṅwu; nīk̇aṅw nu pewhaqami pahsavo hihta akw sóontiṅwu. Nu umuhpa’ as hakimuy piw ayo óyaniqey nāwakna, ayaṅ haqe’ qa‐Jew‐sinmuy amuhpa’ hakimuy ayo óyahqey pan’i. ");
INSERT INTO hopNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Pi nu lomatuawit aw taviwat, aw ayatiwhqe, ōviy nu soon qa sohsokmuy sinmuy put āawnani, imuy Greek‐sinmuy‐nik̇aṅw pu qa‐Greek‐sinmuyu, a’nö wuwni’yuṅqamuy‐nik̇aṅw pu piw qa wuwni’yuṅqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Noqw ōviy nu suhtaq’ewnihqe kwaṅwtoynak̇aṅw umuy Rome epeq sinmuy amumi enaṅ lomatuawit yuaatani. ");
INSERT INTO hopNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Pi nu lomatuawit Christ yuaataqat qa hahmana, ispi God lavayiat öqalanihqe sohsokmuy tuptsiwyaqamuy ayo óyaṅwu. Pam imuy Jew‐sinmuy amumi mohti yuaatiwa, nit pahsat pu imuy qa‐Jew‐sinmuy amumi pīwu. ");
INSERT INTO hopNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Pi lomatuawi itamuy āawnaqw hak hin God aw súantaniqat itam navoti’yuṅwa. Hak qapēvewne’ put aw súantaṅwu; piw hak tuptsiwni’k̇aṅw suan hinmaṅwu. Pi ura pan pey’ta: Suan hinmaqa qapēvewnit akw qatsítuwani. ");
INSERT INTO hopNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Pi God sinmuy put qa k̇aptsi’wisqamuy amuhpewi itsívuat ōṅaqw mahtakiwa, pu qaanhinwisqamuy sohsokmuy amuhpewii. Puma hakim qaanhinwisqey akw God aṅqw navotit pas antsanihqat ahoy ṅuy’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Puma pi put pas sūkw Godnihqat yūmosa öqalay’taqat unaṅwpeq navoti’yuṅwa, pi God amumi put mātaktaq’ö. ");
INSERT INTO hopNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Noqw nāmahin pi as pam pantaqa qamātaqpuveniqw tūwaqatsit hisat yukiltiqat aṅqaqw sinom put māmatsya, yaṅ himu yukiltiqat ahpiy’o; nihqe ōviy kurs hin ayo naymakni’yuṅwni. ");
INSERT INTO hopNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ispi as puma God tuwi’k̇ahk̇aṅw put qa k̇aptsi’tota, piw qa tsúyakya; nit tuwat soq nānaphin hihta wūwanvaya. Paniqw ōviy unaṅwaam an’e’wakw akw qatālawva. ");
INSERT INTO hopNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Puma pas a’nö wuwni’yuṅqey namiwuwantota; nīk̇aṅw pay kurs núanhihtuniwhtoti. ");
INSERT INTO hopNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Nihqe puma God pas hímunihqat sutsep qátuhqat aw nānawaknaqey qe’totit, sinot pay súlawhtiṅwuqat an hihta yukiwhqat aw nāwakintivaya, pu hihtuy masay’yuṅqamuy amún yukiwyuṅqamuyu, pu nālöq hok̇ay’yuṅqamuyu, pu hihtuy hoyóyotinumyaqamuyu. ");
INSERT INTO hopNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Paniqw ōviy God pumuy tuyoy’ewakw qatsit aw mātavi, nāp unaṅway tuṅlayiyat aṅ hinwisniqat ōviy’o, nānami tokoy qahihtatotaniqat aw’i. ");
INSERT INTO hopNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ima hapi God pas antsanihqat pay wutsit enaṅ nāhoyṅwaya; nihqe pay hihta God ahpiy yukiwhqat aw nāwakintivayaqe eṅem tumaltivaya, God sohsok hihta yukuhqat tatamtotat’a. Pam hapi sutsep tayawintiwaa; pay nam antaa. ");
INSERT INTO hopNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Yantaqat ahpiy pu’ God pumuy tuyoy’ewakw tusk̇aptunatyat aw mātavi. Oviy hikis pi momoymat tahtaqtuy amumum namitumalat qe’totit nāp nāmi qaantsaktivaya. ");
INSERT INTO hopNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Pu pay ōviy piw amún tahtaqt momoymuy amumum hin tumalay’yuṅqey mātatvet, pu pas nānami nuvö’naṅway akw qaunaṅwtalawvaya, tāqa sukw tāqat amum hihta nāmiq tumalay’taṅwu, nihqe nāp tokoy ep qaanhtipuy ahpiy sivilalwa; noqw pam pantaqa pay pumuy nāp himuamu. ");
INSERT INTO hopNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Pu pay puma God navoti’yuṅwniqey qa nānawaknaqw, pahsat pu God pumuy an’e’wakw wuwnit aw mātavi; noqw puma as hihta qa hintsatsk̇aniqey hintsaktivaya, God put aw pumuy mātaviq’ö. ");
INSERT INTO hopNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Puma hihta qaantsatskiwhqat akw ahsaliwyuṅwa. Puma tokot sokoptiwisniqey tunatyawyuṅwa; qalomátunatyawyuṅwa; k̇an’ewtunatyawyuṅwa; hakiy tūhototaniqey tunatyawyuṅwa; unaṅwtuyat akw ahsaliwyuṅwa; tukwyantunatyawyuṅwa; nāṅwuy’tunatyawyuṅwa; unatwi’yuṅwa; nukpantunatyawyuṅwa; kolilitiwisa; ");
INSERT INTO hopNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Tūatsatotoynaya; God aw qa suhtaq’ewya; tūunaṅwmokintota; kwīkwivitu; hihta kwiviyuaatota; hihta qalolmat yēwalalwa; yumuy, namuy qa k̇aptsi’yuṅwa; ");
INSERT INTO hopNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Hihta qa mātsi’yuṅwa; namiyukit tutkilalwa; tūqahahlayya; a’nö unaṅway’yuṅwa; qanun’okwatu. ");
INSERT INTO hopNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Noqw hakim pan hinwisqam hovalniwyaniqey ep ö́kiniqat yan God amuṅem yuku. Noqw ima it navoti’k̇ahk̇aṅw pan hinwisa, piw pan hinwisqamuy amuhpa nāhahlaynaya. ");
INSERT INTO hopNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yantaqw ōviy uma hakim nuhtumiq hiṅqaqwaqam kurs hin ayo nö́ṅakiwtani; pi uma hakiy aqw hiṅqaqwe’ napsiwnayaṅwu; pi uma nuhtumiq hiṅqaqwaqam pay piw pan hinwisa. ");
INSERT INTO hopNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Noqw suyan pi God hakimuy panyuṅqamuy amuṅem suan hin yukuni’maqw itam navoti’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Noqw uma hakim nuhtumiq hiṅqawk̇ahk̇aṅw pay piw amún hinwisqamu, hisat God nuhtuṅem suan hin yúkunaqw, ya uma hin ayo nö́ṅakiwtaniqey wūwantota? ");
INSERT INTO hopNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Pi God umuy pas ōkwatuwhqe ōviy umumi qa suy’tsipti. Ya uma pay pas put paysoqlalwa? Pam umuy umuhnukusqatsiy aṅqw ayo lasnaniqe ōviy umuy pāsi. Ya uma pay pas qa ṅas’ew it aw wūwaya? ");
INSERT INTO hopNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Uma umuhnukusqatsiy aṅqw ayo qa lasyat soq umuh’unaṅway owatotaqe soñawnen God itsívuyat nenṅem waranhtota. Noqw ason God sinmuy amuṅem suan yuk̇e’ pep pu’ pam umuy pas pavan sivintoynani. ");
INSERT INTO hopNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Pi God sinmuy sohsokmuy nānap hintsakpiyamuy an amumi ahoytani. ");
INSERT INTO hopNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ima hakim lolmat tunatyawk̇ahk̇aṅw aṅ ahsupoq suan hinwisqamuy pam pumuy qatsit qaso’taqat máqani. Puma pi God aṅqw tayawinpit, pu k̇aptsi’tiwhqat, pu qatsit tunatyawyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Nīk̇aṅw pay hakim nenṅem‐sa hinwist God lavayiyat pas antsanihqat aw qa tuqayvastotat qaanhinwisq pam pumuy amumi itsívuy mahtaknani. ");
INSERT INTO hopNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Sohsoyam qaanhinwisqam k̇ānanaptani, pas pavan hihta ep okiwhinhtotini, ima Jew‐sinom mohtii, pu ima qa‐Jew‐sinom pīwu. ");
INSERT INTO hopNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Nīk̇aṅw sohsoyam suan hinwisqam God tālayat ep yesni, k̇aptsi’tiwyani, kwakwhat unaṅway’vayani, ima Jew‐sinom mohtii, pu ima qa‐Jew‐sinom pīwu. ");
INSERT INTO hopNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Pi God qa sinonuiña. ");
INSERT INTO hopNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Pi ima qa‐Jew‐sinom Moses tutuvoyat qa navoti’yuṅwa; nīk̇aṅw pay nāmahin pi tutavot qa pasiwk̇ahk̇aṅw qaanhtote’ hovalniwyani; noqw pay Jew‐sinom Moses tutavoyat navoti’k̇ahk̇aṅw qaanhtote’ tutavot an yukuniwyani. ");
INSERT INTO hopNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Pi Moses tutavoyat nanaptaqam qa puma God aw súanyuṅwa; pi put aṅ hinwisqam hapi put aw súanyuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Pi ima qa‐Jew‐sinom Moses tutavoyat qa tuwi’yuṅwa; nīk̇aṅw nāp hin tutaptiwhqat aṅ mamavisya. Yanwisqey akw nāp tutavoy aṅ hinwisqey namtakni’yuṅwa. ");
INSERT INTO hopNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Pi pan hinmaqa unaṅwpeq tutavot pasiwtaqey mahtakni’ta; nihqe pam qaanhte’ unaṅwpeq sunvoti’taṅwu, pu piw súanhte’ navoti’taṅwu. ");
INSERT INTO hopNT_vpl VALUES ("RM2_16","075_2_16","