﻿USE sofia;
DROP TABLE IF EXISTS sofia.hnsNT_vpl;
CREATE TABLE hnsNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hnsNT_vpl WRITE;
INSERT INTO hnsNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ie sab naam Jiesoe Kriest ke baap-daada log ke hai. Oe Daawied aur Aabraaham ke aulaad hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aabraaham Iesaak ke baap raha. Iesaak Jaakob ke baap raha. Jaakob Joeda aur okar bhaai log ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Joeda Peres aur Serah ke baap raha aur oelogke maai Taamar raha. Peres Hesron ke baap raha aur Hesron Aaram ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aaram Aamienaadab ke baap raha. Aamienaadab Nahson ke baap raha. Nahson ke beta Saalmon raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saalmon Boas ke baap raha djaun ke maai Raahab raha. Boas Obed ke baap raha aur okar maai Roet raha. Obed Jesai ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesai raadja Daawied ke baap raha. Daawied Saalomo ke baap raha aur Saalomo ke maai Oeria ke aurat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saalomo Rehaabeam ke baap raha. Rehaabeam Aabia ke baap raha. Aabia Aasa ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasa Josaafat ke baap raha. Josaafat Joram ke baap raha. Joram Oesia ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oesia Jotam ke baap raha. Jotam Aahas ke baap raha. Aahas Heskia ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Heskia Maanase ke baap raha. Maanase Aamon ke baap raha. Aamon Josia ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia Jekonia ke aur okar bhaai ke baap raha oe samai djab Israel ke djaatie log Baabielonia ke des me djabar-djastie se ledjaawal gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ekare baad Jekonia ke beta Sealtiejel paida bhail. Sealtiejel Seroebaabal ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Seroebaabal Aabioed ke baap raha. Aabioed Eljaakem ke baap raha. Eljaakem Aasor ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aasor Saadok ke baap raha. Saadok Aahem ke baap raha. Aahem Elioed ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elioed Eleaasar ke baap raha. Eleaasar Matan ke baap raha. Matan Jaakob ke baap raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jaakob Josaf ke baap raha. Josaf Maria ke aadmie raha, aur Maria Jiesoe ke maai raha. Jiesoe bhie Kriest bolaawal dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aabraaham se Daawied talak tjauda pierahie hai. Aur bhie tjauda pierahie hai Daawied se leike djab talak djanta ke Baabielonia des me djaai ke paral. Aur djab se oesab Baabielonia se lautke aail Kriest ke djanam talak bhie tjauda palwaar hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ab ham bataab Jiesoe Kriest ke djanam kaise bhail. Maria ke tjhekaai Josaf se hoi gail raha. Aur oesabke biaah howe se pahiele aise bhail kie Maria ke Pawietr Aatma dwaara larka howat. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maria ke hone waala patie ek bhala aadmie raha aur oe na maangat raha kie Maria ke saram pahoetje. Ohie se oe aapan man me sotjies Maria ke biena haltjal matjaawe tjhor dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bakie djab oe aisan bietjaar karat raha tab oe ekgo sapana me dekhies kie ek Parmeswar ke parie okar paas aail aur bolies: „He Josaf, Daawied ke aulaad, toe na sotj kar Maria se biaah kare ke. Oe Larka to Pawietr Aatma ke dwaara paida hoi. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria ke ek beta hoi aur toe okar naam Jiesoe dharaihe. Oe aapan djaatie ke paap me se batjaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ie sab hoiga djeme Parmeswar ke baat poera howe djaun oe dher dien pahiele aapan sanesia Jasaaja ke dwaara djanaais raha. Oe ose bolies raha: ");
INSERT INTO hnsNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Soen, kania ke ek beta paida hoiga. Aur okar naam Emaanoewel rahiega. Ie naam ke matlab hai: Parmeswar hamlogke saath hai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Djab Josaf djaag gail tab oe karies djaise Prabhoe ke parie ose bolies raha. Oe Maria ke aapan ghare legail. ");
INSERT INTO hnsNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bakie oe okar saath na soetal djab talak okar beta na paida bhail. Aur oe Larka ke naam Jiesoe dharaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jiesoe Betlehem me paida bhail aur oe sahar Joedea ke diehaat me hai. Oe samai hoewa ke raadja ke naam Herodes raha. Tab okare baad koetjh boeddhiemaan poerab kait se aail djaaha soeroedj oege hai aur oelog Jeroesaalem ke sahar me pahoetjal. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tab oesab hoewa ke manai log se poetjhies kie: „Israel ke raadja djaun ab paida bhail hai, oe kaaha rahe hai? Hamlog poerab kait me rahiela aur hoewa par hamlog okar tarai dekhlie hai. Ohie khaatien hamlog ailie hai oke poedje.” ");
INSERT INTO hnsNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tab raadja Herodes soenke bahoet ghabaraail aur sab Jeroesaalem ke manai log bhie. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tab raadja sab barka agwan aur dharam ke parhal waalan ke bolwaaike oesabse poetjhies kie: „Kriest ke djanam kaaha hoi?” ");
INSERT INTO hnsNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tab oesab bolies: „Betlehem sahar Joedea diehaat me. Aise pahiele Parmeswar ke sanesia Mieka liekhies raha kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘He Joedea diehaat ke Betlehem sahar, toe ek tjhota sahar baate. Tabbo tore me ek barka aadmie paida hoiga. Oe hamaar Israel ke djaatie ke ek attjha tjaraawe waala ghat rahiega. Ohie se toe sab se tjhota sahar na baate!’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tab raadja Herodes boeddhiemaan log ke tjoeppe se aapan paas bolwaaike oesabse poetjhies kie: „Hamse bataaw, toelog oe tarai kab dekhle baate?” Tab oesab bataais. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tab oe oesabke Betlehem sahar pathaais aur bolies: „Dja larka ke khodj. Aur djab toelog oke paihe tab aaike hamse bataihe. Tab ham bhie djaab oke poedje.” ");
INSERT INTO hnsNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ekare baad oesab tjal gail. Aur dekh, oe tarai djaun oesab poerab kait se dekhies raha, oesabke aage aage tjale lagal oe djagaha talak djaaha Larka raha aur hoewa par roek gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Oesab tarai dekhke bahoet khoesie bhail! ");
INSERT INTO hnsNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tab djab oesab ghar me gail tab Larka aur okar maai ke paais. Oelog Larka ke aage gaathie par gierke oke poedjies. Aur aapan djhorie kholke oke sona ke tjiedj, lohbaan aur mahakauwa taufa deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tab ek sapana me Parmeswar oesabse bolies kie: „Raadja Herodes ke paas lautke na djaihe.” Ohie khaatien oesab ek doesar rasta se aapan des laut gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Djab boeddhiemaan log tjal gail raha tab Josaf bhie ek sapana dekhies. Ek Parmeswar ke parie ose bolies: „Oethke Larka aur okar maai ke leike Egypte des me bhaag dja, nahie to raadja Herodes Larka ke marwaai dhaarie. Ohie se hoewa rahiehe djab talak ham tose na bolab.” ");
INSERT INTO hnsNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josaf bietj raat me oethke Larka aur okar maai ke leike Egypte me bhaag gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aur djab talak raadja Herodes na mar gail oesab hoewa raha. Aisane poera bhail djaun Parmeswar aapan sanesia Hosea dwaara bolies raha kie: „Ham aapan Beta ke Egypte ke des me se bolailie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Raadja Herodes djab dekhies kie boeddhiemaan log okar baat na soene hai, tab oe bahoet goessaail. Aur oe hoekoem deis kie Betlehem sahar me aur okare aas-paas ke sab laundan doei baries tak marwaai dhaare ke. Oe boeddhiemaan log se to poetjhies raha kie Jiesoe kab paida bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aisane dekhaail kie Parmeswar ke sanesia Jeremia ke baat poera hoi gail. Oe bolies raha: ");
INSERT INTO hnsNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","„Raama sahar me soena hai kie Raahel aapan larkan khaatien piet-pietke rowe hai aur koi na oke samdjhaai sake hai. Oesab to mar gail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josaf log Egypte des me rahat raha djab talak raadja Herodes na maral. Tab Josaf phien se ek sapana me ek Parmeswar ke parie okar paas aawat dekhies. Parie bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","„Dje maangat raha Larka ke maar dhaare, oesab mar gail. Ohie se Larka aur okar maai ke leike phien se Israel des me dja.” ");
INSERT INTO hnsNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josaf oethke Larka aur okar maai ke leike hoewa phien laut gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bakie djab oe soenies kie Herodes ke beta Arkelaajoes ab Joedea ke diehaat ke raadja hai, tab oke dar lagal hoewa djaai ke. Tab ek doesar sapana me oe raai paais Gaalielea ke diehaat me djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Djab oesab hoewa par pahoetjal tab Naasaaret sahar me rahe lagal. Aisane poera bhail djaun Parmeswar ke sanesia log Kriest ke biese me bolies raha: „Oe ek Naasaaret waala bolaawal djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Koetjh dien baad Johaanas dopoe kare waala Joedea ke maidaan me partjaar kare lagal aur bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","„Bhaai log, swarag ke raadj nagietj aai gail hai! Aapan paap pastaaike Parmeswar ke rasta par tjal!” ");
INSERT INTO hnsNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sanesia Jasaaja pahiele ehie Johaanas ke baare me bolies raha kie: „Maidaan me koi djor se boliega: ‘Parmeswar khaatien rasta tajaar kar djeme oe siedha rasta par tjal sake!’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johaanas oet ke baar waala kapra pahienat raha. Oe ekgo tjamra ke tjamotie aapan karhiaaw me lagaawat raha. Oe phatienga khaat raha aur maidaan me madh tjaatat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tab Jeroesaalem sahar aur sab Joedea diehaat aur Jordaan nadie ke galie ke log okar paas aail. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aur oesab okar baat maanke bolies kie: „Hamlog paapie baatie.” Aur oelog apane ke Jordaan nadie me Johaanas se dopoe karwaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tab dher Fariesie aur Sadoesie log bhie aail dopoe lewe khaatien. Bakie djab Johaanas oelogke dekhies tab oesabke daate lagal aur bolies: „Are, dhokhaabaadj log! Ke toelogse bataais hai kie toelog Parmeswar ke goessa me se batj sake hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bestar hai kie toelog aapan tjaal-tjalan se dekhaihe kie toelog maange hai aapan djiewan badale aur bietaawe djaise Parmeswar ke parsand howe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Toelog na sotjiehe kie: ‘Hamlog Parmeswar ke bieswaasie Aabraaham ke aulaad baatie, ohie se hamlog Parmeswar ke goessa me se batj djaab.’ Ham toelogse boliela kie Parmeswar Aabraaham khaatien ie patthar se aulaad banaai sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Taanga per ke lage rakhaai gail. Djab ek per attjha phal na dewe hai, tab oe kaatal djaai aur aagie me djaraawal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ham toelogke paanie se dopoe kariela dekhaawe khaatien kie toelog aapan paap pastaaike ek naawa djiewan soeroe karle hai. Bakie hamare baad ek Aadmie aaiga djaun ke hamse djaada saktie hai. Ham okar djoeta oethaawe laaik na baatie. Oe toelogke Pawietr Aatma aur aagie se dopoe kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Oe iensaan logan ke faisala kariega djaise ek khetiar dhaan osaaike bakhaar me rakhie aur paija ke aagie me djaraai dei. Aur oe aagie kabhie na boetiega.” ");
INSERT INTO hnsNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tab Jiesoe Gaalielea ke diehaat tjhorke Johaanas ke paas gail Jordaan nadie me apane ke dopoe karwaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bakie Johaanas na maangat raha aur bolies: „Toe hamare paas aile? Hamke tjaahie tose dopoe karwaawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tab Jiesoe bolies: „Hamlogke tjaahie Parmeswar ke sab hiettjha poera kare ke. Ohie se toe hamme dopoe kar.” Tab Johaanas oke dopoe karies. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Toerant Jiesoe dopoe hoike paanie me se nieksal. Aur dekh, swarag khoel gail aur Johaanas dekhies kaise Parmeswar ke Aatma ek kaboettar ke roep me oetarke Jiesoe ke oeppar aawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aur swarag me se bhie ek aawaadj soenaail. Pieta Parmeswar bolies: „Ie hamaar pjaara Beta hai aur hamme bahoet parsand howe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ekare baad Pawietr Aatma Jiesoe ke maidaan me legail djeme saitaan oke adjmaaike dekh sake kie oe Parmeswar ke baat soene hai kie na. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jiesoe tjaalies dien aur raat bhoekha raha. Tab ant me oke bhoekh lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ohie tem par saitaan aail aur ose bolies kie: „Djab toe Parmeswar ke Beta baate tab oe patthar se bol de kie bret hoi djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bakie Jiesoe bolies: „Parmeswar ke poestak me liekhal hai: ‘Ek iensaan na khaalie khaaik se djiega, bakie bhie Parmeswar ke sab baat dwaara.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tab saitaan oke Jeroesaalem sahar me legail aur Parmeswar ke mahal par thara karwaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Oe bolies: „Parmeswar ke poestak me liekhal hai kie: ‘Parmeswar aapan parie log se boliega tor rakhwaala kare ke. Oesab toke aapan haath par rok leiga djeme tor gor ieta me na lage.’ Ohie se djab toe Parmeswar ke Beta baate tab toe nietje koed dja.” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Bakie Jiesoe bolies: „Parmeswar ke poestak me bhie liekhal hai kie: ‘Parmeswar tor Prabhoe hai, ohie se toe oke na adjmaaw.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tab oe oke ek bahoet oetja pahaar par legail aur hoewa se doenia bhar ke raadj-paat aur okar soendarta dekhaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bolies: „Ham toke ie sab dei deb djab toe aapan gaathie par gierke hamme poedjiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tab Jiesoe bolies: „Parmeswar ke poestak me liekhal hai kie: ‘Parmeswar tor Prabhoe hai, toe khaalie okar poedja kar.’ Saitaan, toe hia se tjal dja.” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Saitaan oke tjhorke tjal gail. Aur toerant Parmeswar ke parie log aaike Jiesoe ke sewa kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Djab Jiesoe ke pata mielal kie Johaanas dopoe kare waala pakaraaike djahal me band hai, tab oe Gaalielea ke diehaat me tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Oe Naasaaret sahar tjhorke Kaapernaum sahar me gail rahe. Oe sahar Gaalielea samoendar ke kienaare hai Seboelon aur Naftaalie ke galie me. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aisane Parmeswar ke sanesia Jasaaja ke baat poera bhail. Oe Jiesoe ke biese me hoewa ke manai log se bolies raha kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","„He Seboelon aur Naftaalie ke diehaat log, toelog samoendar ke kienaare rahe hai. Aur Jordaan ke nadie ke oepaar rahane waalan, aur Gaalielea ke diehaat ke dher manai log, ");
INSERT INTO hnsNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","toelog ekdam se andhiaar me rahe hai. Bakie toelog ek biesaal djotie dekhiehe. Aur andjor hoi djaaiga oe manai log khaatien djaun ek andhiaar des me rahe hai djaaha maut raadj kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Oe tem se Jiesoe partjaar kare lagal. Oe bolies kie: „Swarag ke raadj nagietj aai gail. Ohie se aapan paap pastaaw aur Parmeswar ke rasta par tjal.” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ek dien Jiesoe Gaalielea ke samoendar ke kienaare kienaare tjalat djaat raha. Tab hoewa par doei bhaai ke dekhies. Oesab aapan djaal paanie me bahaawat raha. Oelogke naam Siemon aur Andreas hai. Siemon bhie Petras bolaawal dja hai. Aur ie doeno matjhar marwa raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tab Jiesoe oesabse bolies: „Aaw tjal hamaar saathe, tab ham toelogke siekhaabe kaise manai log ke bolaawe ke Parmeswar khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Oesab toerant aapan djaal tjhorke okar saath tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tab hoewa se aage tjalke phien se doei bhaai ke dekhies. Oesab Sebedeas ke betwan raha. Aur oesabke naam Jaakobas aur Johaanas raha. Oesab aapan baap ke saathe bot me baithke djaal setiaawat raha. Tab Jiesoe oe doeno bhaai ke bhie apane paas bolaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aur oesab toerant aapan baap aur bot tjhorke okar saathe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jiesoe Gaalielea ke diehaat bhar me ghoem ghoemke partjaar ke ghar me khoes khabar ailaan karat raha kie Parmeswar manai log ke diel me maange hai raadj tjalaawe. Aur oe bhie har ek rakam bemaria log ke attjha karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sieria des bhar me manai log okare baare me bhie soenies. Tab oelog aapan kharaab bemarian ke okar paas laais. Oelogke har ek rakam ke bemaarie aur piera raha, ketane ke bhoet pakaries raha, miergie aawat raha aur loendj log ke. Aur Jiesoe ie sab ke attjha karies. ");
INSERT INTO hnsNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Djhoend bhar manai log okar paatjhe paatjhe tjalat raha. Oesab Gaalielea ke diehaat ke raha aur bhie Das-sahar-ke galie, Dekaapoles diehaat, Jeroesaalem sahar, Joedea diehaat aur Jordaan nadie ke habara ke raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jiesoe oe barka djhoend ke dekhke pahaar par baith gail. Aur okar tjela log okar paas gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tab oe siekhaawe lagal kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","„Soekhie hai djekar diel garieb hai. Oe swarag ke raadj me bhiettar djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Soekhie hai dje oedaas hai. Parmeswar oke tieha deiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Soekhie hai dje sadhaaran hai. Dhartie oelogke khaatien rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Soekhie hai dje diel bhar se maange hai kie Parmeswar ke hiettjha poera howe. Okar hiettjha ekdam poera hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Soekhie hai dje daajaaloe hai. Oke Parmeswar ke daaja mieliega. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Soekhie hai dje safa diel se Parmeswar ke maane hai. Oe Parmeswar ke dekhiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Soekhie hai dje doesman log ke ek karwaawe hai. Oe Parmeswar ke larka bolaawal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Soekhie hai dje Parmeswar ke baat maane ke dwaara sataawal dja hai. Oe swarag ke raadj me bhiettar djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Soekh me rahiehe djab manai log toelogke niendara karie, sataai aur hamaar baat soene ke dwaara toelogke baare me har ek rakam djhoeth bolie. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Aisane Parmeswar ke sanesia logan pahiele bhie sataawal gail. Swarag me toelogke barka ienaam mielie. Ohie se hardam khoesie rahoe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jiesoe bolies: „Toelog doenia khaatien djaise niemak baate. Aur djab niemak me taagat aur sawaad na hai, tab kaun tjiedj se khaaik sawaad dei sake hai? Oe to be-kaamiel hoi gail hai aur phekal djaaiga djaaha manai log gor se katjariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","15","Toelog doenia me djaise djotie baate. Koi na tjieraag baarke top dewe hai, bakie oke oetja dhar dewe hai, tab ghar bhar thiek se dekh paawe hai. Aur ek pahaar par ke sahar bhie thiek se dekha hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aisane toelog aapan djotie manai log khaatien tjamkaaw djeme oelog dekhke toelogke swarag ke Pieta Parmeswar ke goen gaawe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jiesoe bhie bolies: „Toelog na sotjiehe kie ham ailie hai Parmeswar ke kaanoen aur okar sanesian ke baat toere. Ham na ailie hai toere bakie poera kare. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ham toelogse satj boliela kie djab lek ie dhartie aur swarag rahiega Parmeswar ke kaanoen ke ek attjhar na badaliega. Aur doenia aur swarag ke samaap howe se pahiele Parmeswar ke sab baat poera hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dje okar kaanoen ke ek tjhota toekkara toerie aur manai logan ke aise siekhaai, oe swarag ke raadj me bahoet tjhota maanal djaaiga. Bakie dje ie kaanoen ke baat maaniega aur doesare ke bhie siekhaaiga, oe swarag ke raadj me barka bolaawal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ham toelogse boliela kie djab toelog aapan djiewan dharam ke parhal waalan aur Fariesie logan se auro safa se na bietaihe tab toelog swarag ke raadj me kabhie na bhiettar djaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jiesoe samdjhaaike bolies: „Toelog soenle hai kie Mosas toelogke baap-daada log se bolies raha: ‘Koi ke na maar dhariehe. Dje ek doesare ke maar dhaariega, djadj oke sadja deiga.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ie satj hai, bakie ham toelogse boliela kie dje ek doesare se moeh phoelaaike rahe hai, djadj ke tjaahie ohoeke sadja dewe ke. Dje goessa me bole hai: ‘Toe gadaha baate,’ oke tjaahie djadj ke sab se barka sadja miele ke. Aur dje bole hai: ‘Toe paagal baate,’ oe narak ke aagie me pahoetjiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ohie se djab toe djaihe Parmeswar ke koetjh baliedaan kare aur hoewa par toke jaad bhail kie koi tor oeppar goessaail hai, ");
INSERT INTO hnsNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tab toke tjaahie aapan daan hoewa par tjhorke ose phien ek howe ke. Tab toe aaike Parmeswar ke aapan daan dei sakiehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Djab toe koi ke koetjh dharta baate, tab ose kaida se agahie se batia le, nahie to oe toke djadj ke hawaale kar dei aur toe djahal katiehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ham toelogse satj boliela kie toelog djahal me se na niekar paihe djab lek ek ek sies na bhariehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Toelog soenle hai kie Mosas toelogke baap-daada log se bolies raha kie: ‘Aapan biaah ke waada na toer.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ie satj hai, bakie ham toelogse boliela kie dje ek doesar koi ke aurat ke taake hai aur oke maange hai rakhe, oe aapan diel me aapan biaah ke waada toer tjoekal hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","Ohie se djab tor dahiena aakhie tose kharaabie karwaaiga, tab toke tjaahie oke niekaarke bieg dewe ke. Aur djab tor dahiena haath kharaabie karwaaiga tab oke kaatke bieg de. Bestar hai kie toe ek dehie ke toekkara kamtie leike swarag me djaihe nahie to dehie bhar leike narak me pahoetjiehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Bhie bolal gail hai kie: ‘Dje aapan aurat ke tjhore hai, oke tjaahie oke ek kaagadj dewe ke djaun par liekhal hai kie ab se oelogke tjhoettie-tjhoetta hoi gail hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bakie ham toelogse boliela kie dje aapan aurat ke tjhor dewe hai djaun doesar aadmie se kharaabie na karies hai, oe aapan aurat ke kharaabie karwaawe hai djab aurat phien se biaah kariega. Aur djaun aadmie ose biaah kariega, oe bhie ose kharaabie kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Toelog bhie soenle hai kie Mosas toelogke baap-daada log se bolies raha kie: ‘Aapan kasam na toeriehe, bakie Prabhoe ke aage aapan kasam poera kariehe.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bakie ham toelogse boliela kie kabhie na kasam khaihe. Toelog swarag ke naam leike kasam na khaihe. Hoewa par Parmeswar rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aur dhartie par Parmeswar aapan gor dhare hai, ohie se dhartie ke naam leike bhie na kasam khaihe. Aur Jeroesaalem ke naam leike bhie na kasam khaihe. Oe sahar Parmeswar ke hai aur oe sab se barka maahaaraadja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aur toelogke bhie na tjaahie aapan moerie par haath dharke kasam khaai ke. Toelog aapan ek moerie ke baar na oeddjar kie to karia kar sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Toelogke tjaahie hardam aapan djabaan poera kare ke. Tor moeh ke ‘ha’ ha rahe aur tor ‘na’ na rahe. Aur djab koi djabaan dei aur bhie kasam kha hai, tab hoewa par koetjh garbar hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Toelog bhie soenle hai kie Mosas bolies raha kie: ‘Djab koi doesare ke aakhie phor dei, tab okar aakhie bhie tjaahie phor dewe ke. Aur djab koi doesar ke daat toer dei, tab okar daat bhie tjaahie toer dewe ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bakie ham toelogse boliela kie boeraai ke badala boeraai na kar. Djab koi tor dahiena gaal par maariega, tab ekwa kait bhie maaran deihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aur djab koi toke djadj ke paas ledjaaike tor soth maangie, tab aapan djaakiet bhie dei deihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aur djab koi tose djabar-djastie se ek kilometer aapan bodjha dhowaai, tab toe doei kilometer okar saath tjaliehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aur djab tose koi koetjh maangie, tab oke dei deihe. Aur djab koi tose koetjh oedhaar maangiega, tab oke dei deihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Toelog soenle hai kie manai log bole hai: ‘Aapan sanghatian ke pjaar kar aur aapan doesman ke djaran kar.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bakie ham boliela kie: Aapan doesman ke pjaar kar aur praatna kar oesab khaatien djaun toelogke sataawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Djab toelog aise aapan djiewan bietaihe tab toelog aapan swarag ke Pieta ghat rahiehe. Oe soeroedj oegaawe hai aur barkha barsaawe hai kharaab aur bhala aadmie ke oeppar. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Djab toelog khaalie prem kariehe djaun toelogse prem kare hai, tab toelogke kaun ienaam mielie? Kharaab manai log djaise baimaan paisa bharwaawe waalan to bhie aapan sanghatian ke tjaahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aur djab toe khaalie aapan bhaai log ke bolkaare hai, tab toe na sotjiehe kie toe bara biesaal kaam kare hai. Djaun log Parmeswar ke baat kabhie na soenies hai, oesab aisane bhie kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Toelogke tjaahie ekdam safa diel se aapan sab kaam poera taur se kare ke djaise toelogke swarag ke Pieta bhie kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jaad kar kie toelog bhalaai na kariehe ek doesare ke dekhaawe khaatien. Djab toe aise kariehe tab toelogke aapan swarag ke Pieta lage ienaam na mielie. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Toelog koi ke bhalaai karke na djaihe tjaaro or bole djaise dekhaawe waalan kare hai. Oelog partjaar ke ghar me aur rasta par djaaike ie sab kare hai manai ke aadar paawe khaatien. Ham toelogse satj boliela kie ie rakam se oelog aapan ienaam paai tjoekal hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bakie djab toelog ek doesare ke koetjh sahaaita kariehe tab tor baawa haath ke na tjaahie djaane ke kie tor dahiena haath ka kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ie rakam se tor daan tjhiepal rahie. Tor swarag ke Pieta sab tjhiepal tjiedj dekhe hai, aur oe toke ienaam deiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Naklie dharmie logan praatna kare hai doesare ke dekhaawe khaatien. Bakie toelog aise na kariehe. Oesabke attjha lage hai partjaar ke ghar me aur sahar ke kona kona me thara hoike praatna kare ke. Ham toelogse satj boliela kie oelog aapan ienaam paai tjoekal hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bakie djab toelog praatna kariehe tab aapan kamra me djaaike kamaarie band kar deihe. Tab hoewa par praatna kariehe aapan swarag ke Pieta se. Oe sab tjhiepal tjiedj dekhe hai, aur oe toke ienaam deiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Be-bieswaasie logan dher dher baat bolke praatna kare hai, bakie toelog aise na kariehe. Oelog sotje hai kie djab derie talak praatna kariega, tab Parmeswar oelogke praatna soeniega. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Toelog aise na kariehe. Toelogke maange se pahiele Pieta Parmeswar djaane hai kie toelogke kaun tjiedj djaroerie hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Toelog ie rakam se praatna kariehe: Hamlogke swarag ke Pieta, sab koi aapke naam pawietr maane, ");
INSERT INTO hnsNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","aapke raadj aawe, aur djaise tor hiettjha swarag me poera howe hai, oisane dhartie par bhie howe. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hamlogke aadj ke khaana deihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Djaise hamlog aapan kasoerwaar waalan ke maaf kariela, oisane aap hamlogke kasoer maaf kar deihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hamlogke laalietj me na paran de aur boeraai me se batjaaw. Aap raadj tjalaawe hai aur aapke saktie aur mahiemma hai sada ke lieje. Aisahie to hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Djab toe doesare ke maaf kariehe, tab tor swarag ke Pieta toke bhie tjhama kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bakie djab toe ek doesar ke tjhama na kariehe tab Pieta Parmeswar toke tjhama bhie na kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Bolies: „Djab toelog rodja kie to bhoekha rahiehe, tab aapan tjehera na oedaas kariehe djaise koi koi kare hai. Oelog oe dien na sapare hai aur oedaas hoike doesare ke dekhaawe hai kie oelog rodja kie to bhoekha hai. Bakie ham toelogse satj boliela kie oelog aapan ienaam paai tjoekal hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Djab toelog rodja kie to bhoekha rahiehe, tab aapan moerie par tel lagaaw aur moeh dhow djaise toe hardam kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ie rakam se manai log na dekhie kie toelog rodja kie to bhoekha baate, bakie toelogke swarag ke Pieta dekhiega. Oe sab tjhiepal tjiedj dekhe hai, aur oe toelogke ienaam deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Oe bolies: „Toelog doenia me dhan na bator. Hoewa dewka pare hai aur moertjaai dja hai aur tjor ghoeske tjoraai lewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bakie toelog swarag ke dhan bator. Hoewa par koetjh me kierwa na pare hai, koetjh na moertja hai aur tjor na ghoes sakie. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Djaaha tor dhan hai, hoewa tor man bhie rahie. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ek iensaan ke aakhie djaise okar andar ke tjieraag hai. Djab oe safa tjiedj maange hai dekhe, tab okar man ekdam se andjor hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bakie djab oe aapan dhiaan kharaab tjiedj par lagaawe hai, tab okar man ketana andhiaar hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Koi doei maaliek ke na maan sake hai, nahie to oe ek ke djarie aur ekwa ke tjaahie. Aisane toelog aapan dhiaan Parmeswar par aur saathe saath aapan dhan-daulat par na lagaai sakiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ohie se ham toelogse boliela kie toelog khaaik-paanie aur kapra-latta ke biese me sotj-phiekier na kar. Djiewan to khaaik-paanie se aur dehie kapra-latta se djaada hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tjierai log ke dekh. Oesab na bowe hai, na kaate hai, aur koetjh na batorke bakhaar me rakhe hai. Tabbo toelogke swarag ke Pieta oelogke khaaik dewe hai. Aur toelog oelogse djaada baate. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ke sotj-phiekier karke aapan aajoe barhaai sake hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tab toelog kaahe ke kapra-latta ke sotj-phiekier kare hai? Ghaas ke phoel ke dekh. Oesab kaam par na dja hai aur kapra na banaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aur ham toelogse boliela kie raadja Saalomo tjaahe etana dhanie raha, tabbo okar kapra ghaas ke phoel se soendar na raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Djab Parmeswar ghaas ke etana soendar se banaawe hai, tjaahe aadj hai aur biehaan kaatke djaraai dewal dja hai, tab oe toelogke aur soendar na pahienaai sake hai? Dje ie baat na bieswaas kare hai, oe kam-bieswaasie hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Be-bieswaasie logan ie sab tjiedj ke biese me sotj-phiekier kare hai. Bakie toelogke swarag ke Pieta djaane hai kie toelogke kaun tjiedj djaroerie hai. Ohie se toelog sotj-phiekier na kar aur na bol kie: ‘Hamlog ka khaabe aur piebe? Aur kaun tjiedj hamlog pahienab?’ ");
INSERT INTO hnsNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Toelog pahiela dardja par aapan dhiaan Parmeswar ke raadj par lagaaw. Tab djaun djaroerie hai, ie sab toelogke miel djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ohie se toelog biehaan ke tjienta aadj na kar. Aadj ke moesiebat aadj ke lieje bahoet hai. Biehaan to dekhal djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Doesare ke oeppar faisala na kariehe, tab tor faisala bhie na hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Djaise toe doesare ke tauliehe aur napiehe, oisane toe taulal aur naapal djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Toe doesare ke aakhie me ke phaitj dekh lewe hai djaun tjhota galtie hai, bakie aapan aakhie me ke laathie ke na dekh paawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Djab tor aakhie me ek laathie hai, tab kaise toe aapan bhaai se bol sake hai kie: ‘Laaw ham tor aakhie me ke phaitj niekaar dei’? ");
INSERT INTO hnsNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Are, dhokhaabaadj log! Pahiele aapan laathie ke niekaar de, tab toe thiek se dekh paihe okar aakhie ke phaitj ke niekaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Pawietr tjiedj koettan ke na deihe, aur aapan nag aur gahana soewar log ke na de, nahie to oesab gor se katjarke aur ghoemke toke tjier-phaar dhaarie. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Praatna kar, tab toke mielie. Khodj, tab toe paihe. Aur khoet-khoetaaw, tab tor khaat kholal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dje praatna karat rahie, oke mieliega. Dje khodjat rahie, oe paaiga. Aur dje khoet-khoetaawat rahie, okar khaat kholal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Djab tor larka tose bret maangie tab toe oke thoro ieta deihe? ");
INSERT INTO hnsNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aur djab oe matjharie maangie tab toe oke thoro saap deihe? ");
INSERT INTO hnsNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Manai logan kharaab hai aur tabbo aapan larkan ke attjha tjiedj djaane hai dewe. Bakie tor swarag ke Pieta poera hai. Tab djab koi ose koetjh praatna karke maange hai tab oe ketana djaada attjha tjiedj deiga! ");
INSERT INTO hnsNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Djaise toe maange hai kie manai log tor sanghe rahe, oisane toe oesabke sanghe rahoe. Ie Mosas ke aur bhie Parmeswar ke doesar sanesia log ke baat tjhota roep me hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jiesoe bolies: „Djaun phaatak dwaara aur rasta ke alang toe barbaad hoi djaihe, oesab tjaura aur tjakala hai. Aur bahoet log opar tjale hai. Bakie djaun phaatak aur rasta se toe sattja djiewan paihe, oesab tjhota aur paatar hai. Aur dher manai log oe rasta na paawe hai. Ohie se paatar phaatak me se Parmeswar ke raadj me bhiettar dja. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Naklie sanesia log se batjaaike rahiehe. Oesab djaise ek bhola-bhaala bhera dekha hai, bakie sattje me djaise ek bara khatarnaak djanaawar hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ek per aapan phal se pahietjaanal dja hai, oisane toelog naklie sanesia log ke oesabke tjaal-tjalan se pahietjaan paihe. Toe ek kaata ke per me se thoro aam kie to amroed toer sake hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Aisane ek attjha per attjha phal dewe hai aur ek kharaab per kharaab phal. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ekgo barhia per kharaab phal na dei sake hai, aur ek kharaab per barhia phal na dei sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Har ek per djaun barhia phal na dewe hai, oe kaatke aagie me djaraai dewal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aisane toelog sanesia log ke tjaal-tjalan se pahietjaan djaihe kie oesab Parmeswar ke baat satj bataawe hai kie na. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Tjaahe dher manai log hamme Prabhoe bolaawe hai, tabbo na sab koi Parmeswar ke raadj me djaaiga. Khaalie dje hamaar swarag ke Pieta ke man waala kare hai, oe Parmeswar ke raadj me bhiettar djaai sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Oe dien djab sab koi ke faisala karal djaaiga, tab dher log hamse boliega kie: ‘He Prabhoe, hamlog tor naam se sanesa pathailie. Aur hamlog tor naam se to bhoet log ke niekarlie aur atjambho kaam karlie.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bakie ham oelogse kholke bol deb kie: ‘Toelog hamaar sanesia na rahiele. Toelog khaalie aapan man waala karle. Hamaar lage se tjal dja!’ ");
INSERT INTO hnsNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Har ek djaun hamaar baat soenke kare hai, oe samadjhdaar hai djaise ek manai djaun aapan ghar ek barka patthar par banaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tab barkha djor se barse lagal aur nadie tjahar gail aur hauwa kaske tjale lagal. Bakie oe ghar to patthar par banaawal raha, ohie se oe na gieral. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bakie djab koi hamaar baat khaalie soene hai aur na kare hai, tab oe bhoettjar hai djaise ek manai djaun aapan ghar santie par banaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tab barkha djor se barsal aur nadie tjahar gail aur hauwa kaske tjale lagal. Aur oe ghar gierke ekdam se naas hoi gail.” ");
INSERT INTO hnsNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Djab Jiesoe ie sab baat partjaar kar tjoekal raha tab manai log ie baat soenke bahoet atjambho bhail. ");
INSERT INTO hnsNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Oe to na dharam ke parhal waalan ghat siekhaawat raha, bakie Parmeswar ke hoekoem se. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ekare baad Jiesoe pahaar par se oetaral aur djhoend okar pietjhe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tab ek korhia okar paas aaike gaathie par gierke ose bolies: „Prabhoe djie, djab toe maange hai tab toe hamme attjha kar sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tab Jiesoe aapan haath barhaaike oke tjhoeis aur bolies: „Ham maangiela kie toe attjha hoi dja.” Ohie laage oe manai attjha aur safa hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Oe bhie bolies kie: „Toe koi se koetjh na bataihe. Dja apane ke ekgo agwa ke dekhaaw kie toe attjha hoi gaile hai. Mosas ke hoekoem me to liekhal hai kie djab ekgo korhia phien se attjha hoi gail hai, tab koetjh baliedaan kare ke tjaahie. Ie kaam kar, tab oesab djaan djaaiga kie toe sattje ke attjha hoi gaile hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Djab Jiesoe Kaapernaum ke sahar me bhiettar gail, tab okar paas ekgo Roma ke soerdjaatie ke barkwa aail ose koetjh bientie kare aur bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","„Prabhoe djie, hamaar ghare ek naukar loendj hoi gail aur oke bahoet piera hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tab Jiesoe poetjhies: „Toe maange hai kie ham aaike oke attjha karie?” Bakie barkwa bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","„Prabhoe djie, ham oe laaik na hai kie aap hamaar ghare aawo. Aap khaalie ek baat bol de, aur hamaar naukar attjha hoi djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ham aapan barkwa ke nietje hai aur hamaar nietje doesar soerdjaatie hai. Aur djab ham koi ke hoekoem deila: ‘Dja!’ tab oe dja hai. Aur djab ham ek doesar se boliela: ‘Aaw!’ tab oe aawe hai. Aur ek goelaam se boliela: ‘Ie kar!’ tab oe kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tab Jiesoe ie baat soenke atjambho bhail aur hoewa ke manai log se bolies kie: „Ham satj boliela kie ham Israel me koi ke paas etana barka bieswaas na pailie hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Doenia bhar me se dher doesar djaatie log aaiga aur Israel log ke baap-daada Aabraaham, Iesaak aur Jaakob ke saath swarag ke raadj ke nauta me bhodjan kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aur tjaahe Israel ke djaatie log ke pahiela dardja par oe nauta me djaai ke tjaahat, tabbo oelog me se dher log hoewa na djaai paaiga. Oelog bahare andhiaar me khaderal djaaiga. Hoewa par oesab haai-haai karke roi aur daat piesiega.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aur Jiesoe soerdjaatie ke barkwa se bolies kie: „Toe ghare dja. Djaise toe bieswaas kare hai, oisane tor hiettjha poera hoi.” Aur ohie tem par okar naukar attjha hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Djab Jiesoe Petras ke ghare pahoetjal tab dekhies kie okar saas hoewa bokhaar me paral hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bas oe okar haath pakaries aur bokhaar oke pataai gail. Tab aurat toerant oethke okar sewa kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Oe raat me hoewa ke djanta dher manai log ke Jiesoe ke paas laais djaun ke bhoet pakaries raha. Bas oe ek baat se bhoet-paret ke niekaarke bahaar karies. Aur oe sab bemarian ke bhie attjha kar deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ie sab kaam ke dwaara Parmeswar ke sanesia Jasaaja ke baat poera bhail. Oe dher dien pahiele bolies raha kie: „Oe hamlogke bemaarie aapan oeppar lei leis hai, aur hamlogke doekh kaaties hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ek dien Jiesoe djab dekhies kie okar paas ek djhoend manai hai, tab oe aapan tjela log se bolies: „Aaw tjalie samoendar ke oepaar.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tab djaai se pahiele ek dharam ke parhal aadmie okar paas aaike bolies kie: „Maastar djie, tjaahe djaaha toe djaihe, ham tor sanghe tjalab.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tab oe bolies: „Djanaawar log ke biel hai aur tjierai log ke khota, bakie iensaan ke Beta ke ek takia na hai aapan moerie dhare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tab ek tjela ose bienaai karies kie: „Prabhoe djie, hamme djaain deihe djab tak hamaar baap ke mattie na parie.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bakie oe bolies: „Toe hamaar paatjhe tjal. Aur be-bieswaasie logan ke aapan palwaar ke mattie dewan de.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tab Jiesoe ek bot me gail aur okar tjela log okar saathe saath gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tab etana barka aandhie tjale lagal kie halfa bot me djaai lagal. Aur Jiesoe bot me soetal raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tab okar tjela log okar paas djaaike oke djagaais aur bolies: „Prabhoe djie! Hamlogke batjaaw! Hamlog doebiela!” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tab Jiesoe bolies: „Toelog kaahe ke dera hai? Toelogke bieswaas etana tjhota hai?” Bas oe oethke hauwa aur halfa ke daatke bolies kie: „Roek dja!” Aur paanie ekdam se dhiera hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tab sab koi atjambho hoike bole lagal kie: „Ie kaisan aadmie hai kie hauwa aur halfa bhie ekar baat maane hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tab oesabhan samoendar ke habara hoike Gadara des me pahoetjal. Tab hoewa ke kabarsthaan me se doei aadmie oelogke paas aail. Oelogke bhoet pakaries raha aur oelog etana khatarnaak raha kie koi ke hiemmat na raha hoewa paas howe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tab oesab tjiellaaike bole lagal kie: „He Parmeswar ke Beta, tose aur hamlogse kaun kaam hai? Toe faisala ke dien se pahiele aile hai hamlogke sataawe ke?” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Oe tem par koetjh doer me ek barka djhoend soewar tjarat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tab bhoet log Jiesoe se bientie kare lagal kie: „Djab toe hamlogke niekariehe tab oe soewar log ke oeppar pathaai deihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Bas oe bolies: „Dja!” Aur bhoet log oe doeno aadmie ke oeppar se oetarke soewar log ke oeppar tjal gail. Tab oe saara djhoend toerant pahaar par se dhaurke paanie me koed paral aur sab doeb gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tab soewar ke tjaraawe waalan hoewa se bhaagal. Aur sahar me djaaike sab se bataais soewar log se ka bhail raha aur bhie oe doeno bhoet waala aadmie ke biese me. ");
INSERT INTO hnsNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tab oe sahar bhar ke manai log Jiesoe ke paas gail aur ose bientie karke bolies: „Toe hia se tjal dja.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ekare baad Jiesoe phien se bot me djaaike habara kaaties aur oe sahar me pahoetjal djaaha oe rahat raha. Tab koetjh manai log ek tjataai par ek loendj ke leike okar paas aail. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tab Jiesoe oesabke bieswaas dekhke loendj se bolies kie: „Beta, hiemmat baanh! Tor paap tjhama hoi gail.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tab ekaat dharam ke parhal aadmie log apane me sotje lagal kie: „Ie to Parmeswar ke bedjatie kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Bakie Jiesoe oesabke sotj-bietjaar djaan gail aur bolies: „Toelog kaahe ke boeraai sotje hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kaun tjiedj auro sahadj hai, ie aadmie se bole ke: ‘Tor paap tjhama hoi gail,’ kie: ‘Oethke aur tjal’? ");
INSERT INTO hnsNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ham toelogke dekhaab kie iensaan ke Beta ke saktie hai doenia par paap ke tjhama kare ke.” Oe loendj se bolies kie: „Oeth aur aapan tjataai leike ghare dja.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aur aadmie oethke aapan ghare tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tab djhoend ie dekhke ghabaraai gail aur Parmeswar ke aadar kare lagal kie oe iensaan logan ke aisan saktie deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hoewa se Jiesoe aur aage gail. Tab oe djoetie bhare ke ghar lage ek aadmie ke baithal dekhies. Okar naam Mateas raha. Tab oe ose bolies: „Aaw tjalie hamaar saath.” Aur Mateas oethke okare sanghe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tab Jiesoe aur okar tjela log okar ghare gail bhodjan kare. Aur dher baimaan djoetie bharwaawe waalan aur doesar paapie log oesabke saath bhie bhodjan karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tab Fariesie log tjela log se poetjhies: „Toelogke maastar kaahe ke ie kharaab aadmie aur doesar paapie log ke saath bhodjan kare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tab Jiesoe ie baat soenke oesabse bolies kie: „Attjha manai log ke daaktar ke djaroerie na hai, khaalie bemarian ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Parmeswar bolies hai: ‘Ham toelogke baliedaan na maangiela, bakie toelog ek doesare ke daaja kar.’ Dja aur ie baat ke matlab siekh. Ham na ailie baatie dharmie logan khaatien, bakie paapie logan khaat.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ek dien Johaanas dopoe kare waala ke tjela log Jiesoe ke paas aail aur poetjhies kie: „Maastar djie, hamlog aur Fariesie log kabhie kabhie rodja kie to bhoekha rahiela. Kaahe ke tor tjela log aise na kare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tab oe bolies: „Ek biaah me nautaharie log oedaas na howe hai djab lek doelaha oesabke sanghe hai. Aisane hamaar tjela log rodja kie to bhoekha na rahie djab lek ham oesabke saath baatie. Bakie ek dien aaiga kie ham oelogke saath na rahab. Tab oesab rodja kie to bhoekha rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Dekh, koi na ek naawa tjaktie ek poeraan kapra par lagaawe hai, nahie to kapra auro phat djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aur koi na naawa wien poeraana tjamra ke basta me dhare hai. Poeraan tjamra karer hai aur naawa wien phoeliega. Ie rakam se basta to phat djaai aur wien bahie djaai. Bakie djab naawa wien naawa tjamra ke basta me dharal djaai tab doeno batj djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jiesoe ie sab baat-tjiet abbe karat raha tab ek partjaar ke ghar ke barkwa okar paas aaike aur aapan gaathie par gierke ose bolies kie: „Maastar djie, hamaar bietia abbe abbe mar gail. Bakie djab toe aaike aapan haath okare oeppar dhariehe tab oe phien se djie djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tab Jiesoe oethke okar saathe gail aur okar tjela log bhie. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Hoewa par ek aurat raha. Oke baara baries se khoen gierat raha. Oe apane me bietjaar karies kie: „Djab ham khaalie Jiesoe ke kapra tjhoei leb tab ham attjha hoi djaab.” Tab oe paatjhe se aaike okar kapra ke djhalarie ke tjhoei leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tab Jiesoe ghoemke oke taakies aur bolies: „Betie, hiemmat baanh. Tor bieswaas dwaara toe batj gaile hai.” Aur oe tem se aurat attjha hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tab djab Jiesoe barkwa ke ghare pahoetjal aur dekhies kaise manai log baasoerie badjaawe hai aur rona-pietana howe hai, tab oelogse bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","„Ie larkie na maral bakie soetal hai. Toelog tjal dja.” Tab oesabhan oke hase lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Djab sab koi hoewa se niekaaral gail tab Jiesoe bhiettar gail. Bas oe larkie ke haath pakaries aur larkie oeth gail! ");
INSERT INTO hnsNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aur djaun bhail, oe saara diehaat me phail gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jiesoe hoewa se djaat raha. Tab doei andha okar pietjhe pietjhe tjale lagal. Oesab tjiellaaike bolies kie: „He raadja Daawied ke Aulaad! Hamlog par daaja kar!” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Djab Jiesoe ek ghar me bhiettar gail tab oesab okar lage gail. Tab oe poetjhies: „Toelog bieswaas kare hai kie ham toelogke attjha kar sakiela?” Tab oesab bolies: „Djie-ha, Prabhoe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tab oe oesabke aakhie tjhoeike bolies: „Djaise toelog bieswaas kare hai, oisane howe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aur oesab dekhe lagal. Tab Jiesoe oesabke bahoet mienaahie karies kie: „Koi na djaane paawe!” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bakie oesab djaaike galie galie me tabbo ie baat phailaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Djab Jiesoe aur okar tjela log hoewa se djaat tab manai log okar paas ek goenga ke laais. Oke bhoet-paret pakaries raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Djaise Jiesoe ie bhoet ke niekaaries, oisane goenga batiaai lagal. Aur manai log atjambho hoike bolies: „Aisan tjiedj hamlog aapan des me kabhie na dekhlie!” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bakie Fariesie log bolies: „Ie saktie oke sab se barka saitaan dewe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aur aisane Jiesoe sahar sahar aur gaaw gaaw djaat raha aur sagaro partjaar ke ghar me siekhaawat raha. Oe khoes khabar ailaan karat raha kie Parmeswar maange hai manai log ke diel me raadj tjalaawe. Aur oe sab bemarian ke attjha karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Djhoend ke dekhke oke bahoet daaja lagat raha. Oesab djaise ek djhoend bhera biena ek tjaraawe waala se bahoet thakal-thoekal dekhaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tab oe aapan tjela log se bolies kie: „Ie djhoend djaise pakkal dhaan hai. Oke tjaahie kaate ke, bakie kamkartan kamtie hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Parmeswar djaise khet ke maaliek hai. Ohie se praatna kar kie oe kaate waalan ke bhedje ie kaam kare khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ek dien Jiesoe aapan baara tjela log ke apane paas bolaaike aur oesabke saktie deis bhoet log ke niekaare ke aur har ek rakam bemarian ke attjha kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ie baara pathaawal waalan ke naam raha: Siemon djaun ke doesar naam Petras raha, okar bhaai Andreas, Jaakobas aur okar bhaai Johaanas. Oe doeno Sebedeas ke betwan raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fielepas, Baartolomeas, Tomaas, Mateas. Oe pahiele djoetie ke paisa bharwaawe waala raha. Alfeas ke beta Jaakobas, Tadeas, ");
INSERT INTO hnsNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Siemon kamaasoet waala, aur Joedaas Eskaariot. Oe Jiesoe ke doesman ke haath me saup deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tab Jiesoe ie baaraago ke des bhar me pathaais aur bolies: „Toelogke na tjaahie doesar djaatie log ke paas djaai ke. Aur Saamaaria log ke sahar me bhie na djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Toelog khaalie Israel log ke paas djaihe. Oelog Parmeswar ke tjhor deis hai aur heraail bhera ghat hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dja, oesabse ailaan kar de kie swarag ke raadj nagietj aai gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bemarian ke attjha kar, maral logan ke djie oethaaw, korhian ke attjha aur safa kar aur bhoet-paret ke niekaar. Ie saktie toelogke moeft me paile hai, ohie se ie sab kaam biena paisa ke kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Oe bhie bolies kie: „Ek kamkarta ke hak hai khaana piena paawe ke. Ohie se toelog paisa, djhorie, kapra, djoeta aur tjale khaat danda na ledjaihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Djab toelog ek gaaw kie to sahar me pahoetjiehe tab ek attjha manai ke khodjke okar ghare rahiehe djab lek toelog oe sahar me rahiehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Djab toelog koi ke ghare djaihe tab oe ghar waalan ke aasier-baat deihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Djab oesab toelogke barhia se oethaai baithaai, tab toelogke aasier-baat oelogke oeppar rahiega. Bakie djab oelog aise na karie tab toelogke aasier-baat toelogke paas laut aaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Djab ek sahar kie to ghar ke manai log toelogke na maangie bhiettar lewe aur toelogke sanesa bhie na maangie soene, tab oe ghar kie to sahar tjhorke tjal djaihe. Tab aapan gor ke dhoer bhie djhaar deihe dekhaawe khaatien kie toelog oelogke paap oesabke oeppar tjhor deile hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ham toelogse satj boliela kie tjaahe Sodom aur Gomora sahar ke manai log bahoet kharaab raha, tabbo Parmeswar ke faisala ke dien par oelog ie manai log se kamtie sadja paaiga! ");
INSERT INTO hnsNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Dekh, ham toelogke bhera ghat oe manai log ke paas pathaaila djaun khatarnaak djanaawar ghat hai. Toelog saap ghat hoesiaar rahiehe aur kaboettar ghat bhola-bhaala. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Manai logan se bahoet batjaaike rahiehe. Oesab toelogke djadj ke aage ledjaaiga aur aapan partjaar ke ghar me pietwaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Toelog hamaar tjela baate aur ohie se manai log toelogke oeppar goessaaike laat aur raadja ke aage ledjaaiga. Aise toelogke mauka mieliega oesabke aur sab djaat ke aage hamaar biese me gawaahie dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Aur djab oesab toelogke doesman ke haath me saup deiga, tab toelogke na batiaai ke parie, bakie Pieta Parmeswar ke Aatma toelogke dwaara batiaaiga. Ohie se sotj-phiekier na kariehe kie toelog ka boliehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","Toelog hamaar tjela baate, ohie se sab koi toelogke dekhke djariega. Aur manai log aapan sagge bhaai ke dhokha deike marwaai dhaariega. Aur baap log aapan larkan se aisane bhie kariega. Aur larkan aapan maai-baap ke doesman hoike oesabke maar dhaariega. Bakie dje ant talak hiemmat baanhke hamaar rasta par tjaliega, oe batjaawal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Djab manai logan toelogke ek sahar me sataaiga tab doesar sahar me bhaag djaihe. Ham toelogse satj boliela kie toelogke Israel ke sab sahar me bhaag djaai se pahiele iensaan ke Beta lautke aaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ek tjela aapan maastar se na barka hai aur ek goelaam aapan sardaar se na. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ek tjela ke tjaahie khoesie rahe ke djab oe aapan maastar ner hoi djaai, aur ek goelaam djab oe aapan sardaar ner hoi djaai. Manai log hamke sab se barka saitaan Bejelsaboel ke naam dewe hai, tab oesab toelogke ketana auro na gariaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Koetjh na topaail hai djaun na khoelaail djaaiga. Aur koetjh na tjhiepal hai djaun na djanaai djaaiga. Ohie khaatien toelog manai logan ke na deraihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Djaun baat ham khaalie toelogse bataaila, toelogke tjaahie djaaike sab koi se ailaan kare ke. Aur djaun ham khaalie toelogke siekhaaila, djaaike sagaro siekhaihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Manai logan tor dehie ke maar dhaar sake hai, bakie tor djiew ke na. Bestar hai kie toe Parmeswar ke goessa ke dera. Oe dehie aur djiew ke narak me bhie naas kar sake hai. Ohie se manai logan ke na deraihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Toelog djaane hai kie doei tjhota tjierai ek paan dabal me bieka hai. Tabbo Parmeswar ke be-djaane ekko na dhartie par gier sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Oe hamlogke etana barhia se sewa kare hai kie oe djaane hai hamlogke moerie par kaigo baar hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Toelog to tjierai se bahoet barka baate. Ohie se toelog na dera. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Har ek djaun manai log se boliega kie oe hamme tjaahe hai, ham aapan swarag ke Pieta se bhie bolab kie oe manai ke ham tjaahiela. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bakie dje manai ke aage hamme nahakaar deiga, oke ham bhie nahakaarab aapan swarag ke Pieta ke aage. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Toelog na sotj kie ham doenia par sjaantie lailie hai. Ham sjaantie na lailie bakie doesmanie. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Hamaar aane se baap aur beta, maai aur bietia, saas aur patoh alag alag hoi, aur palwaar log apane apane me doesman hoi djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Dje aapan maai-baap ke hamse aur djaada tjaahe hai, oe hamaar tjela na rahie sake hai. Aur bhie dje aapan betie beta ke hamse auro djaada tjaahe hai, oe hamaar tjela bhie na rahie sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dje na maange hai hamaar sanghe doekh oethaaike hamaar rasta par tjale, ohoe hamaar tjela na rahie sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dje hamme nahakaarke aapan praan batjaaiga, oe hamaar saath na rahie sakiega. Bakie dje hamaar khaatien aapan praan tjhorie, oe hamaar sanghe rahiega sada ke lieje. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Dje toelogke hamaar tjela ghat aapan ghar me leiga, oe hamme bhiettar leiga. Aur dje hamme bhiettar leiga, oe Pieta Parmeswar ke bhiettar leiga. Oe to hamme pathaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dje djaane hai kie koi Parmeswar ke sanesia hai aur ohie se oke bhiettar leiga, oke ek sanesia ke ienaam mieliega. Aur dje djaane hai kie koi Parmeswar ke baat soene hai aur ohie se oke bhiettar leiga, oke Parmeswar ke baat maane waala manai ke ienaam mieliega. ");
INSERT INTO hnsNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ham toelogse satj boliela kie dje toelog me se sab se tjhota iensaan ke hamaar tjela maanke ek gielaas thandha paanie piaaiga, Parmeswar oke djaroer ienaam deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Djab Jiesoe aapan baara tjela log ke ie sab baat siekhaaike don hoi gail raha, tab hoewa se tjal gail doesar Israel ke sahar sahar me siekhaawe aur partjaar kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Johaanas dopoe kare waala abbe talak djahal me raha aur oke sanesa mielal kie Kriest ka ka kare hai. Tab oe aapan ekaatgo tjela ke okar paas pathaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Oesab Jiesoe ke paas djaaike poetjhies: „Maastar djie, tohie Parmeswar ke aane waala baate, kie ek doesar waala aaiga?” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tab oe bolies kie: „Toelog Johaanas ke paas djaaike bataai de kie toelog hia ka dekhle aur soenle hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Andha log phien se dekhe lage hai, loendj log tjale lage hai, korhia log attjha hoi dja hai, bahier log soene lage hai, maral logan djie oethaawal dja hai, aur garieb doekhian khoes khabar soene hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Soekhie hai djaun manai begar bhoen-bhoenaaike hamare me bieswaas kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tab djab Johaanas ke tjela log tjal gail raha, tab Jiesoe hoewa ke manai log se Johaanas ke biese me baat-tjiet kare lagal. Oe poetjhies: „Toelog djangal me gaile rahiele Johaanas ke dekhe. Ka, toelog kaun rakam aadmie sotjle rahiele paawe ke? Ek aisan-oisan manai djaun narai ghat hauwa se iedhar se oedhar hielaawal dja hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na, oe aisan na hai. Tab kaun rakam aadmie toelog gaile khodje? Toelog sotjle rahiele kie oe barhia barhia kapra pahiene hai? Biesaal kapra waalan to raadja ke mahal me rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tab kaun rakam aadmie toelog sotjle rahiele dekhe ke? Ek Parmeswar ke sanesia? Ha, oe oisan aadmie hai. Aur ham toelogse boliela kie oe Parmeswar ke bahoet barka sanesia hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ohieke biese me Parmeswar ke poestak me liekhal hai kie: ‘Ham aapan sanesia ke tose aage pathaaila rasta tajaar kare khaatien.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ham toelogse satj boliela kie sab iensaan me se Johaanas dopoe kare waala sab se barka sanesa partjaar karies hai. Bakie tabbo swarag ke raadj me hamaar sab se tjhota tjela ose barka hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Djab se Johaanas soeroe karies hai partjaar kare ke tab se swarag ke raadj djor-tor se barhat dja hai. Aur dje ke barka bieswaas hai, oe apana leiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sab Parmeswar ke sanesian Mosas se leike Johaanas talak partjaar karies hai kie Parmeswar maange hai manai log ke diel me raadj tjalaawe. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aur djab toelog maange hai maane: Johaanas Elia ghat hai. Okare biese me ek sanesia bolies raha kie oe lautke aaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aur djab toelogke kaan hai tab hamaar baat thiek se soen le.” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jiesoe oelogse bhie bolies kie: „Ham toelogke kaise samdjhaai kie ie tem ke manai log kaun rakam hai? Oesab djaise larkan hai djaun daam par khele hai. Tab ek larka ekwan se bole hai: ");
INSERT INTO hnsNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Hamlog toelogke khaatien baadja badjailie, bakie toelog na mangle naatje. Tab hamlog marnie ke giet gailie, bakie toelog na roile.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Oe bolies: „Johaanas kamtie khaat raha aur khaalie paanie piejat raha. Tab manai log bolies: ‘Eke bhoet pakaries hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tab iensaan ke Beta aail, aur oe dja hai manai ke paas bhodjan kare aur wien pieje. Tab sab koi bole hai: ‘Dekh, ek khabboe aur piejekkar. Aur okar sanghatian baimaan paisa bharwaawe waalan aur doesar paapie log hai.’ Sattja gjaanie okar phal se pahietjaanal dja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tab Jiesoe oe sahar waalan ke daate lagal djaaha oe sab se atjambho kaam karies raha aur tabbo oelog aapan djiewan na badalies raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Oe bolies: „Are, Koraasien aur Betsaaida ke manai log! Djab ham Tieras aur Siedon ke sahar me ehie sab atjambho kaam karle hoitie djaun ham toelogke hia karlie hai, tab tjaahe hoewa ke aadmie bahoet kharaab manai log raha, tabbo oesab dher dien pahiele aapan boeraai pastaat aur ek safa djiewan bietaawat. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bakie ham toelogse boliela kie Parmeswar ke faisala ke dien par toelog Tieras aur Siedon ke manai log se djaada sadja paihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aur oe Kaapernaum ke sahar ke manai log se bolies kie: „Ka, toelog sotje hai kie toelog etana attjha manai log baate kie swarag me oethaai lewal djaihe? Na, toelog maral manai ke djagaha me daaral djaihe! Djab Sodom ke sahar me ie sab atjambho kaam howat djaise ham tor sahar me karlie hai, tab oe sahar naas na howat bakie aadj talak rahat. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bakie ham toelogse boliela kie Parmeswar ke faisala ke dien par Sodom ke manai log toelogse kamtie sadja paaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Oe samai Jiesoe praatna kare lagal aur bolies: „Pieta djie, toe swarag aur doenia ke Prabhoe baate, aur ham toke dhanbaad deila kie toe ie sab baat biedwaan aur parhal log ke khaatien tjhiepaai deile, bakie larkan ke samdjhaile hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ha Pieta, aise aapke sab se attjha lage hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jiesoe hoewa ke manai log se bolies: „Pieta Parmeswar sab tjiedj hamaar haath me saup deis hai. Koi na djaane hai kie ham Ke baatie, khaalie oe. Aur koi na djaane hai kie hamaar Baap Ke hai, khaalie ham oke djaaniela aur dje ke ham maangiela djanaawe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Oe bolies: „Djiewan ke thakal-thoekal waalan, aaw hamaar paas, aur ham toke sjaantie deb. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Hamaar bodjha aapan oeppar le aur hamse siekh. Ham dhieradj baatie aur ham ghamandie na hai. Tab toe aapan man me sjaantie paihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Hamaar sanghe kaam kare ke na kara hai aur hamaar bodjha halloek hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ek sabat ke dien par Jiesoe aur okar tjela log ekgo khet lage se paas howat raha. Okar tjela log ke bhoekh lagal aur oesab koetjh toerke tjhielke khaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tab Fariesie log dekhke Jiesoe se bolies: „Dekh, ie kaam sabat ke dien par mienaahie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tab oe bolies: „Ka, toelog na parhle hai kie raadja Daawied aur okar saathie log ka karies djab oelogke bhoekh lagal raha? ");
INSERT INTO hnsNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Oesab Parmeswar ke ghar me djaaike hoewa ke dekhaawe waala bret leike khaai leis. Aur eke to khaalie agwa log ke khaai ke hoekoem raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Toelog Mosas ke poestak me na parhle hai kie agwa log sabat ke rodj Parmeswar ke mahal me djaaike aapan kaam kare hai aur aise sabat ke kaanoen toere hai, aur tabbo be-kasoerie hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aur ham toelogse boliela kie hia Parmeswar ke mahal se koi auro barka hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Parmeswar bolies hai kie: ‘Ham toelogke baliedaan na maangiela, bakie kie toelog ek doesare ke daaja kar.’ Toelog ie baat na samdjhe hai, ohie se toelog be-kasoer tjela log ke kasoer deile. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iensaan ke Beta sabat ke dien ke Prabhoe hai, ohie se oke hoekoem hai bole ke kie kaun tjiedj mienaahie hai aur kaun tjiedj na.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tab Jiesoe hoewa se tjal gail aur partjaar ke ghar me gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hoewa ek aadmie raha djaun ke ek haath na kamaat raha. Koetjh manai log maangies dekhe kie Jiesoe Israel ke dharam ke kaanoen toere hai kie na. Tab oesab oke kasoer dei paawat. Ohie se oelog ose poetjhies kie: „Thiek hai koi ke sabat ke dien par attjha kare ke kie na?” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tab oe bolies: „Maan le kie tor bhera sabat ke dien par petie me gier djaat, tab toe oke na niekarte? ");
INSERT INTO hnsNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ek iensaan ek bhera se ketana djaada hai. Ohie khaatien attjha hai ek sabat ke dien par bhalaai kare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aur oe aadmie se bolies: „Aapan haath barhaaw.” Aadmie barhaais aur okar haath ekdam attjha hoi gail djaise ekwa. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tab Fariesie log hoewa se tjal gail apane me sotj-bietjaar kare khaatien kaise Jiesoe ke maar dhaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bakie Jiesoe oesabke bietjaar djaanke hoewa se tjal gail aur dher manai log okar paatjhe bhie tjalal. Aur djaaha oe djaat raha, oe sab bemarian ke attjha karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aur oesabke bahoet mienaahie karies koi se bataawe ke kie oe Ke hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aise Jasaaja ke baat poera bhail. Oe to Parmeswar ke sanesa deis raha kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","„Dekh, ehie hamaar sewak hai. Ham oke tjoenlie hai hamaar kaam kare ke. Ie hamaar doelarwa hai, hamaar diel ke ek toekkara. Oke ham aapan Aatma se bharab, aur oe sab djaatie log ke siekhaaiga kaise koi hamaar sadja me se batj sakiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Oe djhagara na kariega aur tjiellaaike na batiaaiga. Rasta par okar aawaadj na soenaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Oe toete waala narai na toeriega aur boete waala battie na boetaaiga. Oe ie karat rahiega djab talak oe djietke sab iensaan ke oeppar faisala na kariega aur dher manai okar sadja me se batj djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aur har ek djaat okar naam par bharosa kariega.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tab manai log Jiesoe ke paas ek aadmie legail djaun ke bhoet andha aur goenga karies raha. Tab Jiesoe oke attjha kar deis aur aadmie batiaai aur dekhe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sab manai log dekhke bara atjambho bhail aur bolies: „Saait ehie raadja Daawied ke Aulaad hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bakie Fariesie log ie baat soenke bolies: „Ie aadmie khaalie sab se barka saitaan Bejelsaboel ke saktie se bhoet ke niekaare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jiesoe oesabke sotj-bietjaar djaanat raha aur bolies: „Djab ek raadj me ekta na hai, tab naas hoi djaaiga. Aur har ek sahar kie to palwaar djaaha manai apane me djhagara kare hai, oesab bhie naas hoi djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aur djab saitaan saitaan ke niekaarke bahaar kare hai, tab okar raadj me ekta na hai. Tab okar raadj kaise rahie sakie? ");
INSERT INTO hnsNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Toelog bole hai kie ham Bejelsaboel ke saktie se bhoet niekaariela. Tab toelogke tjela logan kekar saktie se ie kaam kare hai? Aise oelog dekhaaiga kie toelog ketana kharaab baate. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bakie djab ham Parmeswar ke Aatma ke saktie se bhoet niekaariela, tab ekar matlab hai kie okar raadj aail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Koi ek pahalwaan ke ghar me ghoeske kaise okar tjiedj tjoraai sake hai? Pahiele oke tjaahie ose larke djietke aur baanh dewe ke, tab oe okar ghar ke tjiedj tjoraai sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Dje hamaar sanghe na hai, oe hamme rokaawe hai. Aisane dje hamaar sanghe bhera log ke ekattha na kare hai, oe oesabke bhagaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ohie se ham toelogse boliela kie har ek boeraai aur bedjatie kare khaatien manai log ke tjhama miel sake hai. Bakie dje Parmeswar ke Pawietr Aatma ke bedjatie kariega, oke kabhie na tjhama mieliega. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Djab koi iensaan ke Beta ke biese me koetjh kharaabie boliega, tab oke tjhama miel sake hai. Bakie djab koi Parmeswar ke Pawietr Aatma ke biese me koetjh kharaabie boliega, tab oke ie djoeg me aur aane waala djoeg me bhie tjhama na miel sakiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Djab ek per attjha hai tab okar phal bhie attjha hai. Aur ek kharaab per kharaab phal dewe hai. Phal se per pahietjaanal dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Are, saap ke battja log! Toelog kharaab manai baate. Tab kaise toelog ek barhia tjiedj bol sake hai? Djaun tjiedj se diel bharal hai, ohie moeh me se niekare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ek bhala manai ke diel me se attjha tjiedj niekare hai, aur ek kharaab manai ke diel me se kharaab tjiedj. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Bakie ham toelogse boliela kie Parmeswar ke faisala ke dien par har ek ke tjaahie aapan sab kharaab baat ke biese me samdjhaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Har ek manai aapan baat se kasoerie kie to be-kasoerie maanal djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tab ekaat dharam ke parhal aadmie aur Fariesie log Jiesoe se bolies: „Maastar djie, hamlog maangiela ek atjambho kaam dekhe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bakie oe bolies: „Toelog kharaab baate aur Parmeswar ke tjhor deile hai. Aur toelog maange hai kie ham barka kaam dekhaai. Bakie ham toelogke khaalie Parmeswar ke sanesia Jona ke jaad karwaaila. Djaun ose bhail raha, oe atjambho kaam hai, aur ham toelogke ek doesar barka kaam na dekhaab. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Djaise Jona tien raat aur dien ek barka matjharie ke pet me raha, oisane iensaan ke Beta tien rodj maral manai log ke bietj me dhartie ke gahieraai me rahie. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Parmeswar ke faisala ke dien par Nienafe sahar ke manai log aaike dekhaaiga kie toelog kasoerie baate. Djab Jona oesab khaatien gail partjaar kare, tab oesab aapan paap pastaai lagal aur aapan djiewan badal deis. Ham Jona se barka baatie, aur ham toelogke khaat partjaar kariela. Bakie tabbo toelog aapan paap na pasta hai aur aapan djiewan na badale hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Skeba des ke raanie bhie dekhaaiga kie toelog kasoerie baate. Oe etana doer des se aail raha Parmeswar ke baare me raadja Saalomo se gjaan siekhe ke, aur oe okar sab baat maan leis raha. Aur ham raadja Saalomo se barka baatie, tabbo toelog hamaar baat na maane hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Djab ek bhoet manai me se niekare hai, tab oe dja hai ek doesar djagaha khodje rahe khaatien. Bakie oe khodjat khodjat djagaha na paawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tab oe sotje hai kie: ‘Aaw, ham laut tjalie oe manai ke paas djaun me se ham niekarlie hai.’ Aur djab oe lautke aawe hai tab dekhe hai kie oe aadmie ke andar djaise ek safa karal waala ghar hai. Hoewa par sab tjiedj aapan aapan djagaha par dharal hai, bakie eman koi na rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tab oe djaaike saatgo ose kharaab kharaab bhoet ke laaike oe manai me rahe lage hai. Tab aadmie ke haal pahiele se aur kharaab hoi dja hai. Aisane toelogse bhie hoiga. Toelog to kharaab aadmie baate.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Djab Jiesoe baat-tjiet karte raha tab okar maai aur bhaai log aail oke dekhe. Oesab bahare thara raha aur maangat raha ose batiaai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tab koi Jiesoe se bolies: „Tor maai aur bhaai log bahare thara hai aur maange hai toke dekhe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tab oe bolies: „Toe djaane hai hamaar maai aur bhaai log ke hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aur oe aapan tjela log ke or dekhaaike bolies: „Dekh, iesab hamaar maai aur bhaai log hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dje hamaar swarag ke Pieta ke man waala kare hai, oesab hamaar bhaai, bahien aur maai hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ohie dien Jiesoe ghar me se niekarke gail samoendar ke kienaare baithe. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tab hoewa par ek djhoend manai okar paas aail. Tab Jiesoe oethke ek bot me gail baithe aur sab manai paanie ke kienaare thara raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tab oe dher tjiedj matlab ke kaahaanie se bataawe lagal aur bolies: „Ek khetiar raha. Ek dien oe gail bia tjhiete. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tjhietat me koetjh bia daam par gier gail. Tab tjierai aaike sab bia khaai leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aur koetjh bia djamien par gier gail djaaha par dher patthar aur kamtie mattie raha. Hoewa bia haalie se djam gail, ");
INSERT INTO hnsNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","bakie dher djar na dharies. Tab djab opar ghaam lagal, tab oe sab djhoeraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aur koetjh bia kaata waala djhalaasie me gieral. Tab kaata ke per djamke attjha bia ke dabaai deis, aur sab mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aur djaun bia batjal raha, oesab attjha djamien par gieral. Aur ie sab barhal aur kauno sau goena, kauno saath goena aur kauno ties goena phal deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aur dje ke kaan hai soene ke, oke tjaahie ie kaahaanie ke matlab samdjhe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tab Jiesoe ke tjela log okar paas aaike poetjhies kie: „Maastar djie, toe djhoend se kaahe ke kaahaanie kahe hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tab oe bolies: „Parmeswar maange hai kie ham toelogke okar raadj ke baare me kholke samdjhaai bakie djhoend ke kaahaanie soenaai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Dje ke samadjh hai, oe aur djaada samdjhiega. Bakie dje ke samadjh na hai, okar samadjh ose tjhien lewal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ohie khaatien ie manai log se ham kaahaanie kahiela. Aur oelog tjaahe dekhe hai aur soene hai, tabbo koetjh na samdjhe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ie rakam se Parmeswar ke sanesia Jasaaja ke baat poera howe hai. Oe bolies raha kie: ‘Toelog kaan se soeniehe bakie na samadjhiehe. Toelog takiehe bakie koetjh na dekhiehe.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Parmeswar ose bolies raha: ‘Ie djaatie log hamaar oeppar aapan dhiaan na lagaawe hai. Oesab na maange hai aakhie se dekhe, kaan se soene, aur akkiel kaam me laawe, djeme oelog aapan man na badale, aur ham oesabke diel attjha karie.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Oe bolies: „Bakie toelog aapan aakhie se dekh paawe hai aur aapan kaan se soen paawe hai. Ohie se toelog soekhie hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aur ham toelogse satj boliela kie dher Parmeswar ke sanesian aur bhala manai log maangat raha dekhe aur soene djaun ham kariela aur toelogke siekhaaila. Bakie oelogke na mielal ie dekhe aur soene ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ab toelog bia ke kaahaanie ke matlab soen. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Djaun bia daam par gieral raha, oe ekgo manai ke diel me gieral. Oe Parmeswar ke raadj ke khoes khabar soene hai bakie na samdjhe hai. Tab saitaan aaike oe baat okar diel me se tjhien lewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Djaun bia kamtie mattie par gieral raha, oe bhie ekgo manai ke diel me gieral. Oe Parmeswar ke baat soene hai aur djoerte khoesiaalie se maan lewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bakie oe bahoet dhiaan na lagaawe hai. Aur djab oke moesiebat oethaawe ke pare hai, kie to doesar log oke sataawe hai okar bieswaas khaatien, tab oe haalie se aapan bieswaas tjhor dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Oe bia djaun kaata ke djhalaasie me gieral raha, oe aisan manai ke diel me gieral djaun Parmeswar ke baat soene hai, bakie aapan dhiaan doenia ke tjienta par aur dhan ke laalietj par lagaawe hai. Aur ie sab tjienta Parmeswar ke baat okar djiewan me boetaai dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Djaun bia attjha djamien par gieral raha, oe aisan manai log ke diel me gieral djaun Parmeswar ke baat soene hai aur bhie samdjhe hai. Aur iesabke djiewan djaise ekgo per hai djaun sau, saath kie to ties goena phal dewe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jiesoe oesabke ek auro kaahaanie soenaawe lagal kie: „Swarag ke raadj hai djaise koi aapan khet me attjha bia tjhieties. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bakie raat ke djab sab koi soetal raha, tab okar doesman aaike oe khet me ghaas ke bia tjhietke tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tab djab attjha bia djame lagal aur phal dewe lagal, tab ghaas bhie djame lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tab khetiar ke goelaam log okar paas aaike poetjhies: ‘E barkwa, toe aapan khet me attjha bia na tjhietle rahiele? Hoewa kaise ghaas djam gail?’ ");
INSERT INTO hnsNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tab oe bolies: ‘Ek doesman oe bia tjhiet deis hai.’ Tab goelaam log poetjhies: ‘Hamlog ghasian oekhaar dhaarie?’ ");
INSERT INTO hnsNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tab oe bolies: ‘Na, abbe rahan de. Djab toelog ghaas oekhariehe tab hoi sakie kie attjha per bhie oekhar djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Attjha per ghaas ke sanghe djame de katnie talak. Djab katnie ke samai aai tab ham kaate waalan se bolab: Dja pahiele ghaas kaatke bodjha baanhke djaraai de. Tab pakkal per kaatke hamaar bakhaar me dhar deihe.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Oe ek auro kaahaanie kahies kie: „Swarag ke raadj hai djaise koi ek sarso ke bia leike aapan khet me boi deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Oe sab se tjhota bia hai, bakie djab barhe hai tab oe khet ke sab per se barka hai kie tjierai log aaike okar daarhie par khota lagaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Oe ek auro kaahaanie soenaais kie: „Swarag ke raadj hai djaise ek aurat djaun tien koerha piesaan taulies. Tab oe thora se khatta piesaan leike oman mielaaike saan deis aur sab piesaan phoel gail.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jiesoe manai log ke ie sab kaahaanie soenaawat raha, aur oe begar kaahaanie se koetjh na siekhaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ie rakam se Parmeswar ke ek pahiele ke sanesia ke baat poera bhail. Oe bolies raha kie: „Ham kaahaanie se siekhaabe. Aur ham oe sab tjiedj bataabe djaun doenia howe se pahiele ab talak tjhiepal raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tab Jiesoe manai log ke pathaaike tjal gail ghare. Tab okar tjela log okar paas aaike poetjhies: „Maastar djie, toe hamlogke ghaas ke kaahaanie ke matlab bataai sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tab oe bolies: „Attjha bia tjhiete waala iensaan ke Beta hai. Oe khetiar ghat attjha bia tjhiete hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aur khet ke matlab doenia hai. Attjha bia ke matlab Parmeswar ke larkan hai, aur ghaas saitaan ke saathie log hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Doesman ke matlab saitaan hai aur oe ghaas ke bia tjhieties raha. Katnie ke tem djaise djoeg ke ant hai. Aur kaate waalan Parmeswar ke parie log hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Djaise ghaas ie kaahaanie me batorke aagie me djaraawal gail, oisane djoeg ke ant me hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Iensaan ke Beta aapan parie log ke bhedjiega, aur oelog kharaabie karwaawe waala log aur sab doesar paapie log ke aapan raadj me se batoriega ");
INSERT INTO hnsNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","aur aagie me daariega. Hoewa par oelog daat pies pieske roiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bakie be-kasoerie logan Pieta Parmeswar ke raadj me khoesiaalie se djaise soeroedj tjamkiega. Dje ke kaan hai, oke tjaahie thiek se soene ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Swarag ke raadj hai djaise ek dhan djaun ek khet me gaaral raha. Tab koi khodat me paais aur top deis. Tab oe bahoet khoesie hoike aapan sab tjiedj betj dhaaries, aur oe khet kien leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Swarag ke raadj bhie lage hai djaise ek sonaar djaun soendar se soendar nag khodje hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tab ek rodj oe ek bahoet mahanga nag dekhies. Tab oe djaaike aapan sab tjiedj betjke oe nag ke kien leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Swarag ke raadj hai djaise matjhar marwa log aapan djaal samoendar me biege hai, tab oman har ek rakam ke matjharie aawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Djab djaal bhar dja hai, tab oelog oke kienaare ghaitje hai. Tab oesab baithke sab attjha matjharie bienke baskieta me bator lewe hai aur sab kharaab matjharie ke phek dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aisane djoeg ke ant me hoiga. Tab Parmeswar ke parie log kasoerie aur be-kasoerie log ke alag alag kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aur kasoerie log narak ke aagie me bieg dewal djaaiga. Hoewa par oelog daat pies pieske roiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Oe aapan tjela log se poetjhies: „Toelog ie sab kaahaanie samadjhle hai?” Tab oesab bolies: „Djie-ha.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tab oe bolies: „Djab ek dharam ke parhal aadmie hamaar tjela hoi gail hai, tab oe djaise ek ghar ke maaliek hai. Oe aapan pahiele ke aur naawa sotj-bietjaar kaam me laawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jiesoe ie sab kaahaanie soenaaike hoewa se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Oe gail oe sahar me djaaha oe posaail raha. Tab oe hoewa ke partjaar ke ghar me siekhaawe lagal. Aur oe aisan rakam siekhaawat raha kie manai log bahoet atjambho hoike poetjhe lagal: „Ie aadmie kaaha se etana gjaan aur saktie paais hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ie ghar banaawe waala ke betwa hai kie na? Okar maai to Maria hai aur hamlog okar bhaiwan Jaakobas, Josaf, Siemon aur Joedaas ke bhie djaaniela. ");
INSERT INTO hnsNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aur okar bahienian sab hamlogke sahar me rahe hai. Tab oe ie sab tjiedj kaise djaan sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aur oelog Jiesoe ke baat tanko na maangat raha soene. Tab Jiesoe oelogse bolies: „Ek Parmeswar ke sanesia ke tjaaro or aadar howe hai. Khaalie okar sahar waalan aur okar palwaar oke tjhota maane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ohie se oe hoewa par dher atjambho kaam na kar paais. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Oe same par raadja Herodes soenies kie manai log Jiesoe ke baare me ka bole hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tab oe aapan kamkartan se bolies: „Oe aadmie djaroer Johaanas dopoe kare waala hai. Oe to maut me se djie oethal, ohie se oe etana atjambho kaam kare hai!” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Koetjh dien hoi gail raha kie raadja aapan bhaai Fielepas ke aurat tjhien leis raha. Oe aurat ke naam Herodias raha. Tab Johaanas raadja se bolies raha kie: „Tor hak na hai aapan bhaai ke aurat ke tjhiene ke.” Tab raadja Johaanas ke pakarwaaike djahal me band karwaai deis raha. Aur oe oke bhie maangat raha marwaai dhaare, bakie oe djanta ke deraat raha. Oesab Johaanas ke Parmeswar ke ek sanesia ghat maanat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tab raadja Herodes ke djanam dien par Herodias ke betie nautaharie khaatien naatjat raha, aur naatj raadja ke bahoet attjha lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ohie se oe kasam khaaike larkie se bolies: „Toe tjaahe djaun tjiedj mangiehe, ham toke deb.” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tab oe larkie gail aapan maai se raai lewe. Tab okar maai ose bolies kie: „Dja bol: ‘Hamme ek paletie par Johaanas dopoe kare waala ke moerie de.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ie baat soenke raadja oedaas hoi gail. Bakie oe sab nautaharie ke aage kasam khaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tab oe djahal me Johaanas ke moerie katwaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tab oesab moerie ek paletie par laais aur larkie ke deis, aur oe ledjaaike aapan maai ke deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tab Johaanas ke tjela log lahaas ke ledjaaike okar mattie deis. Tab oesab gail Jiesoe se bataawe ka bhail raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Djab Jiesoe ie baat soenies tab oe ek bot me djaaike ek soen-saan djagaha me tjal gail thora der akel rahe khaatien. Bakie dher manai log djaan gail aur oelog sahar tjhorke samoendar ke kienaare kienaare okar paatjhe tjalal. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tab djab Jiesoe bot me se nieksal tab oe dekhies kie ek djhoend manai hoewa par thara hai. Tab oke daaja lagal aur sab bemarian ke attjha kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tab djab sandjha bhail tab okar tjela log aaike ose bolies: „Maastar djie, hia to ekko ghar na hai aur abbe andhiaar hoi djaai. Bestar hai kie toe manai log ke pathaai dei kie oesab gaaw me djaaike koetjh khaaik kien lewe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bakie oe bolies: „Ielogke djaai ke na djaroerie hai. Oesabke toelog khaaik deihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tab oesab bolies: „Hamlogke hia par khaalie paatj bret aur doei matjharie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tab oe bolies: „Sab hamaar paas laaw.” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Oe djhoend se bolies: „Sab koi ke tjaahie ghaas par baithe ke.” Tab oe paatj bret aur doei matjharie ke leike swarag ke or taakke Parmeswar ke dhanbaad deis. Tab oe bret ke toekkara toekkara toerke aapan tjela log ke deis baate khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aur sab koi pet bharke khaais. Aur oesabhan baara baskieta bhar batjal-koetjal batories. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aurat larkan tjhorke hoewa par lagbhag paatj hadjaar mardaana raha. Aur sab koi bhodjan karies raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tab Jiesoe aapan tjela log ke bot me baithaaike aage pathaai deis. Aur oe djhoend ke ghare pathaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tab oe pahaar par tjaharke gail praatna kare. Raat hoi gail raha aur oe akele raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Oe samai okar tjela log koetjh doer samoendar par pahoetj gail raha. Hoewa oelta hauwa tjalat raha aur barka halfa maarat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tab tjaar badje saberaha Jiesoe oesabke paas paanie par tjalke aawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tab tjela log djab oke dekhies tab bahoet ghabaraai gail aur dar ke maare tjiellaai lagal: „Ek bhoet!” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tab Jiesoe toerant oelogse bolies: „Hiemmat dhar! Ham baatie. Na dera.” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tab Petras bolies: „Prabhoe djie, djab toe baate tab hamke hoekoem de paanie par tjalke tor paas aawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tab Jiesoe bolies: „Aaw!” Aur Petras bot me se niekarke paanie par Jiesoe ke or tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bakie djab oe dekhies kie hauwa etana djor se tjale hai tab oe deraail aur ohie laage doebe lagal. Tab oe tjiellaaike bolies: „Prabhoe! Hamme batjaaw!” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tab Jiesoe toerant aapan haath barhaaike oke pakar leis aur bolies: „Kam-bieswaasie. Kaahe ke toe doebdha kare lagale?” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tab djab oelog bot me gail tab hauwa ekdam se dhiera hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tab sab tjela log Jiesoe ke aage aapan gaathie par gierke bole lagal kie: „Satj-moetj, toe Parmeswar ke Beta baate!” ");
INSERT INTO hnsNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Djab oesab samoendar ke oepaar hoi gail tab Genesaaret ke diehaat me pahoetjal. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tab djaise hoewa ke aadmie log Jiesoe ke pahietjaanies, taise tjaaro or sanesa pathaai deis. Tab manai log har ek ke djaun bahoet bemaar raha, oke okar paas laais. ");
INSERT INTO hnsNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Oelog ose bientie karies kie bemarian okar kapra ke djhalarie khaalie tjhoei sake djeme oesab attjha howe. Aur dje dje oke tjhoeis, oesab batj gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ek rodj ekaatgo Fariesie aur dharam ke parhal log Jeroesaalem ke sahar se Jiesoe ke paas aaike poetjhies: ");
INSERT INTO hnsNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","„Tor tjela log bret khaai se pahiele haath na dhowe hai. Oesab kaahe ke hamlogke baap-daada log ke nem na maane hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tab oe bolies: „Toelog aapan nem maane khaatien kaahe ke Parmeswar ke kaanoen toere hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Oe to bolies hai: ‘Aapan maai-baap ke aadar kar.’ Aur bhie: ‘Dje aapan maai-baap ke saraapiega, oke tjaahie maar dhaare ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bakie toelog bole hai: ‘Dje aapan paisa Parmeswar ke kaam me lagaawe hai, oke djaroerat na hai aapan maai-baap ke sahaaita kare ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ie rakam se toelog aapan nem banaaike Parmeswar ke baat be-kaamiel kar deile hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dhokhaabaadj log! Parmeswar ke sanesia Jasaaja sattje ke toelogke baare me bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ie djaatie log hamme khaalie aapan moeh se maane hai, bakie oelog aapan diel me hamaar baat tanko na maane hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Oelogke kaanoen khaalie manai ke banaawal nem hai, ohie se oelogke dharam be-kaamiel hai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tab Jiesoe djhoend ke apane paas bolaaike bolies kie: „Hamaar baat thiek se soen aur samadjh! ");
INSERT INTO hnsNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Djaun khaaik ek manai ke moeh me bhiettar dja hai, oe oke na kharaab kare hai. Bakie djaun baat okar man aur moeh me se niekse hai, oe oke kharaab kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tab okar tjela log okar paas aaike bolies: „Maastar djie, toe djaane hai kie Fariesie log tor baat soenke goessa hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tab oe bolies: „Har ek per djaun hamaar swarag ke Pieta na bois hai, oe oekhaaral djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Oesabke na dera. Oelog djaise andha hai djaun andha log ke tjalaawe hai. Djab ek andha doesar andha ke tjalaawe hai, tab doeno petie me gier djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tab Petras poetjhies: „Hamlogke ie baat ke matlab bataai sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tab oe bolies: „Tohoelog abbe lek na samadjh paawe hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Toelog djaane hai kie khaaik moeh me se pet me dja hai, tab aapan djagaha me djaaike phien bahare niekar dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bakie djaun baat manai ke moeh me se niekare hai, oe okar diel me se niekare hai. Aur ohie ek iensaan ke kharaab kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ek iensaan ke diel me se kharaab sotj-bietjaar, djaan maare, biaah toere, ek doesar ke aurat kie to aadmie ke rakhe, tjorie, djhoeth, aur niendara niekare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ie sab tjiedj ek iensaan ke kharaab kare hai. Bakie biena haath dhowe bhodjan kare oke kharaab na kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tab Jiesoe hoewa se tjal gail aur Tieras aur Siedon sahar ke aas-paas gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tab ekgo Kaanaan djaatie ke aurat okar paas aail. Oe bolaais: „Prabhoe djie! Daawied ke Aulaad! Hamaar oeppar daaja kar! Hamaar betie ke bhoet sataawe hai aur okar haal bahoet kharaab hai!” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bakie Jiesoe koetjh na bolies. Tab okar tjela log aaike bolies: „Prabhoe, oke pathaai de. Oe hamlogke paatjhe khaalie tjiella hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Bakie oe bolies: „Parmeswar hamme pathaais hai khaalie Israel log ke paas. Oesab bhatkal bhera ghat hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tab aurat aaike okar aage aapan gaathie par gierke bientie karies: „He Prabhoe, hamaar sahaaita kar.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bakie oe bolies: „Na thiek hai larkan ke bret leike koetta ke dewe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tab aurat bolies: „Ie satj baat hai, Prabhoe. Bakie koetta to bhie toekkara toekkara kha hai djaun tafra par se gier dja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tab oe bolies: „Betie, tor bieswaas bahoet barka hai. Djaise toe maange hai, oisahie poera hoi.” Aur okar bietia ohie laage attjha hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tab Jiesoe hoewa se Gaalielea ke samoendar ke kienaare gail. Hoewa par oe ek pahaar par tjaharke gail baithe. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tab dher manai okar paas aail. Oesab loendj, langara, andha, goenga log aur dher doesar bemarian ke leike okar aage dharies. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aur oe oesabke attjha karies. Tab manai log djab dekhies kie goenga log batiaai lage hai, loendj log tjale lage hai, langara log attjha hoi dja hai aur andha log dekhe lage hai, tab oesab bahoet atjambho bhail aur Israel ke Parmeswar ke aadar kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tab Jiesoe aapan tjela log ke aapan paas bolaaike bolies: „Hamme ie manai log par bahoet daaja lage hai. Oelog parso se hia par hai aur oesabke khaaik na hai. Ham na maangiela oelogke bhoekhe ghare pathaawe. Hoi sake hai kie oelog ghar talak na pahoetj paai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tab tjela log poetjhies: „Ie maidaan me hamlog kaaha etana bret paabe ie djhoend manai ke pet bhar khawaawe ke?” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tab oe poetjhies: „Toelogke lage kaigo bret hai?” Tab oelog bolies: „Saat bret aur ekaatgo tjhota matjharie.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tab oe manai log se bolies: „Sab koi djamien par baith dja.” ");
INSERT INTO hnsNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bas oe saat bret aur matjharie leike Parmeswar ke dhanbaad deis aur sab toekkara toekkara toerke aapan tjela log ke deis. Aur oesab manai log ke baat deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aur sab koi pet bharke khaais. Tab sabhan batjal toekkara batorke saat baskieta bharies. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aurat larkan tjhorke hoewa tjaar hadjaar mardaana log raha. Aur sab koi bhodjan karies raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tab Jiesoe oelogke hoewa se ghare pathaai deis aur bot me djaaike aapan tjela log ke saath Magadan diehaat me tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ek dien ekaat Fariesie aur Sadoesie log Jiesoe ke paas aail. Oesab maangies okar ek atjambho kaam dekhe djaane khaat kie Parmeswar oke sattje ke pathaais hai kie na. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bakie oe bolies: „Djab sandjha howe hai tab toelog baadar dekhke bole hai: ‘Badarie na hai, barkha na barsiega.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aur sabere djab badarie lagal hai, tab toelog bole hai: ‘Dekh, barkha barsiega.’ Baadar dekhke toelog bataai sake hai kaisan dien hoi. Bakie toelog na dekhe hai kie toelog ab kaun tem me rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Toelog kharaab baate aur Parmeswar ke tjhor deile hai. Aur toelog maange hai kie ham ek atjambho kaam karie. Bakie ham toelogke khaalie jaad karwaaila kie Jona se ka bhail raha.” Aur oe ie sab baat bolke hoewa se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ek dien Jiesoe aapan tjela log ke saath nadie ke habara kaaties. Tab tjela log ke khiaal bhail kie oesab bret bhoelaai gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Oe same par Jiesoe oelogse bolies: „Fariesie aur Sadoesie log ke khatta piesaan se batjaaike rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tab tjela log apane me batiaai lagal kie: „Hamlog bret bhoelaai gailie, ohie se oe aise bole hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tab Jiesoe djab soenies tab bolies: „Kam-bieswaasie log! Toelog kaahe ke sotj kare hai kie toelogke bret tjhoet gail? ");
INSERT INTO hnsNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Toelog abbe talak na samdjhe hai? Aur toelogke jaad na hai ka bhail raha djab paatj bret paatj hadjaar aadmie ke baatal gail raha? Aur kai baskieta batjal raha? ");
INSERT INTO hnsNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aur toelog bhoelaai gaile djab saat bret tjaar hadjaar aadmie ke baatal gail raha, tab kai baskieta batjal raha? ");
INSERT INTO hnsNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Toelog kaahe ke na samdjhe hai kie ham bret ke biese me na batiaaila? Ham toelogse bollie: ‘Fariesie aur Sadoesie log ke khatta piesaan se batjaaike rahiehe.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tab tjela log samadjh gail kie bret ke khatta piesaan se na batjaaike rahe ke tjaahie, bakie Fariesie aur Sadoesie log ke partjaar se. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ek rodj djab Jiesoe aapan tjela log ke saath Sesaarea Fielepie ke diehaat me pahoetjal tab oe oesabse poetjhies: „Manai logan bole hai kie iensaan ke Beta ke hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tab oesab bolies: „Koi koi bole hai kie toe Johaanas dopoe kare waala baate. Aur koi koi bole hai kie toe Elia baate. Aur doesar log bhie bole hai kie toe Jeremia baate kie to Parmeswar ke ek doesar pahiele ke sanesia.” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tab oe poetjhies: „Aur toelog ka bole hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tab Siemon Petras bolies: „Toe Kriest, jaane djienda Parmeswar ke Beta baate.” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tab oe bolies: „Jona ke beta Siemon, toe soekhie baate. Ek iensaan toke na djanaais, bakie hamaar swarag ke Pieta. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tor naam Petras hai aur ekar matlab ‘patthar’ hai. Djaise ek ghar ekgo patthar par khoeb djabar se banaawal dja hai, aisane ham aapan samaadj ie patthar par banaabe. Aur maut ke saktie ie samaadj ke na djiet paai. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Djaise koi ek tjaabhie se kamaarie khole hai, aisane toe doesar logan ke dekhaihe kie oesab kaise swarag ke raadj me bhiettar djaai sakiega. Djaun toe dhartie par baanh deihe, oe swarag me bhie baanhal rahiega. Aur djaun toe doenia par khol deihe, oe swarag me bhie khoelal rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aur oe ekdam se mienaahie kar deis kie: „Koi se na bataihe kie ham Kriest baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Oe tem se Jiesoe Kriest aapan tjela log ke samdjhaawe lagal kie: „Hamke tjaahie Jeroesaalem sahar me djaai ke. Aur hoewa ke barkwan aur barka agwa log aur dharam ke parhal log hamke bahoet doekh deiga. Tab oesab hamke marwaai dhaariega, bakie tiesara dien ham phien se maut me se djie oethaawal djaab.” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tab Petras oke kienaare ledjaaike daate lagal. Oe bolies: „Prabhoe djie, ie Parmeswar na howan dewe. Aise tore sanghe kabhie na howe!” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Bakie Jiesoe ghoemke ose bolies: „Saitaan, hamaar paatjhe se tjal dja. Toe maange hai hamme bharmaawe. Tor baat Parmeswar ke sotj-bietjaar na hai bakie iensaan ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Oe aapan sab tjela log se bolies: „Dje maange hai hamaar tjela banke hamaar rasta par tjale, oke na tjaahie aapan soekh khodje ke, bakie oke hamaar sanghe doekh oethaawe ke parie aur oke tjaahie hamaar pietjhe tjale ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dje na maange hai aapan djiewan hamaar khaatien bietaawe, oe sattja djiewan na paaiga. Bakie dje aapan soekh tjhorke hamaar rasta par tjaliega, oe sattja djiewan paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Djab ek manai doenia bhar ke tjiedj paaike tabbo hamesa ke lieje Parmeswar se alag rahie, tab oke kaun faida mielie? Parmeswar ke saath rahe ke koi na kien sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Iensaan ke Beta aapan parie log ke saath aapan Baap ke mahiemma se aaiga. Tab oe har ek ke okar kaam ke madjoerie deiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ham toelogse satj boliela kie toelog me se koetjh manai na mariega djab lek oelog oke ek maahaaraadja ghat na aawat dekhie.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tjhau dien baad Jiesoe Petras aur Jaakobas aur okar bhaai Johaanas ke leike ek oetja pahaar par gail djaaha koi na raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tab hoewa par oesabke aakhie ke saamne okar soerat badale lagal. Okar tjehera djaise soeroedj tjamke lagal, aur okar kapra bhie ekdam oeddjar tjamke lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tab oesab Mosas aur Elia ke dekhies aur oesab Jiesoe se batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tab Petras Jiesoe se bolies: „Prabhoe djie, bhale hamlog hia baatie. Djab toe maang tab ham tien marai banaai, ekgo tor khaat, ekgo Mosas khaat aur ekgo Elia khaat.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tab batiaite me ek oeddjar tjamkat baadar aaike oesabke tjhaai leis. Tab baadar me se ek aawaadj soenaail. Koi bolies: „Ie hamaar pjaara Beta hai aur oe hamme parsand hai. Okar baat soen.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Djab tjela log soenies tab dar ke maare moehe ke bhale djamien par gier gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tab Jiesoe aaike oesabke tjhoeis aur bolies: „Oeth aur na dera.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tab oesab taakies aur khaalie Jiesoe ke dekhies. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Djab Jiesoe aapan tieno tjela ke saath pahaar par se oetarat raha tab oesabse bolies: „Djaun toelog aadj dekhle hai, oe koi se na boliehe djab talak iensaan ke Beta maut me se na djie oethaawal djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tab tjela log poetjhies: „Dharam ke parhal logan kaise bol sake hai kie Kriest ke aawe se pahiele Parmeswar ke sanesia Elia phier se aaiga?” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tab oe bolies: „Ha, Elia pahiele aaiga manai logan ke Parmeswar se ek kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aur ham toelogse boliela kie oe aai tjoekal hai. Bakie manai logan okar baat na maanies. Oesabhan oke sataais djaise oelog maangies. Aisane oesab iensaan ke Beta ke bhie dher doekh deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tab tjela log samadjh gail kie Jiesoe ie sab baat Johaanas dopoe kare waala ke biese me bolies hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Djab Jiesoe aapan tjela log ke saath pahaar par se oetaral tab djhoend me se ekgo aadmie okar paas aaike aapan gaathie par gier paral ");
INSERT INTO hnsNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","aur bolies: „Prabhoe djie, hamaar beta ke daaja kar! Oke miergie ke bemaarie hai aur okar haal bahoet kharaab hai. Oe hardam aagie aur paanie me giere hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ham oke tor tjela log ke paas legailie, bakie oesab oke na attjha kar paais.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tab oe bolies: „Ie tem ke manai log ketana be-bieswaasie aur kharaab log hai! Ham kab lek toelogke paas rahab? Aur ham kab lek toelogke kam-bieswaas sahab?” Oe bolies: „Oe larka ke hia laaw.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tab oe bhoet ke daaties. Bhoet niekar gail, aur larka toerant attjha hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ekare baad djab tjela log Jiesoe ke sanghe akele raha, tab poetjhies: „Hamlog bhoet ke kaahe ke na niekaar pailie?” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tab oe bolies: „Toelogke bieswaas bahoet tjhota hai, ohie se toelog na kar paile. Ham toelogse satj boliela kie djab toelogke bieswaas sarso ke bia ghat tjhota rahat, tab toelog ie pahaar se bol sakte kie: ‘Hia se hoewa dja!’ aur oe tjal djaat. Toelog sab tjiedj kar sakte.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aur oe bhie bolies: „Toelog ie rakam bhoet log ke khaalie niekaar sakiehe djab toelog praatna kariehe aur bhoekha rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jiesoe aapan tjela log ke saath Gaalielea ke diehaat me raha. Tab oe bolies kie: „Iensaan ke Beta manai ke haath me saupal djaaiga ");
INSERT INTO hnsNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","aur oelog oke maar dhaarie. Tab tiesara dien oe djie oethaawal djaaiga.” Tab tjela log ie baat soenke bahoet oedaas hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Djab oesab Kaapernaum sahar me pahoetjal tab hoewa ke djoetie bharwaawe waalan Petras ke paas aaike poetjhies: „Tor maastar Parmeswar ke mahal ke djoetie bhariega kie na?” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tab Petras bolies: „Ha, djaroer.” Djaise Petras ghare pahoetjal oisane Jiesoe ose poetjhies: „Siemon, toe ka sotje hai, doenia ke raadja logan paisa pardesie logan se maange hai kie aapan betwan se?” ");
INSERT INTO hnsNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tab Petras bolies: „Pardesie logan se.” Tab oe bolies: „Thiek. Ekar matlab hai kie betwan ke djoetie ke paisa na bhare ke parie. ");
INSERT INTO hnsNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tabbo hamlog ie paisa bharab. Hamlog na maangiela kie bharwaawe waalan ghoermoesaai. Toe samoendar ke paas dja aur katia lagaaw. Tab pahiela matjharie ke moeh me toe ek tjaanie ke paisa paihe. Ie paisa leike hamlog doeno miela khaatien Parmeswar ke mahal ke djoetie bhar de.” ");
INSERT INTO hnsNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Oe samai Jiesoe ke tjela log okar paas aaike poetjhies: „Ke swarag ke raadj me sab se barka hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tab oe ek tjhota larka ke bolaaike tjela log ke bietj me khara kar deis, ");
INSERT INTO hnsNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aur oelogse bolies kie: „Ham toelogse satj boliela kie djab toelog aapan man na badalke ek tjhota larka ghat hoihe, tab toelog swarag ke raadj me kabhie na pahoetjiehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dje apane ke ie larka ghat tjhota maane hai, oe swarag ke raadj me sab se barka hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aur dje aisan larka ke hamaar naam se apanaawe hai, oe hamme apanaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Bakie haai oe aadmie djaun hamaar aisan tjhota bieswaasie se paap karwaai. Okare khaat bestar rahat djab koi okar gatai me ek barka ieta baanhke oke samoendar me phek dewat. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ie doenia me dher tjiedj manai log se paap karwaawe hai, aur eke koi na badal sake hai. Bakie haai oe manai ke djaun ek doesare se paap karwaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ohie se djab toe aapan haath kie to gor se paap kare hai, tab bestar hai kie toe oke kaatke phek de. Ka, toe maange hai doeno haath aur gor leike narak djaai, kie ek haath aur gor se swarag me pahoetje? ");
INSERT INTO hnsNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aur djab toe aapan aakhie se paap kare hai tab toke tjaahie oke notjke phek dewe ke. Bestar hai kie toe ek aakhie leike swarag me pahoetj dja, nahie to toe doei aakhie leike narak me pahoetj djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Batjaaike rahiehe kie toelog aisan tjhota larka ke nietja na maniehe. Ham toelogse boliela kie iesabke rakhwaala kare waala parie log rodj hamaar swarag ke Pieta ke lage aawe dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Iensaan ke Beta doenia me aail hai batjaawe ke djaun manai log Parmeswar se alag karal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Djab ek aadmie ke sau bhera hai aur oman se ekgo heraai djaai, tab toelog ka sotje hai kie oe kariega? Oe niennaanabe (99) ke pahaar par tjhorke heraail bhera ke djaaiga khodje. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aur ham toelogse satj boliela kie djab oke paai djaaiga tab oke ose auro khoesiaalie hoiga ekwan se. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aise tor swarag ke Pieta na maange hai kie aisan ek tjhota waala ose alag karal djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Djab toe dekhiehe kie ek bieswaasie bhaai paap kare hai, tab oke akele me bolaaike datiehe. Djab oe tor baat maan leiga tab toe oke batjaai leile. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bakie djab oe tor baat na maaniega, tab toe ek kie doei manai leike oke phien se samdjhaaw. Oesab tor gawaahian rahie. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Djab oe ielogke baat bhie na maaniega, tab toelog samaadj bhar se bataihe. Aur djab oe samaadj log ke baat bhie na soeniega, tab toelog oke samaadj me se niekaar deihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ham toelogse satj boliela kie sab koetjh djaun toelog doenia par baanh deihe, oe swarag me bhie baanhal rahie. Aur sab koetjh djaun toelog dhartie par kholiehe, oe swarag me bhie khoelal rahie. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ham toelogse bhie boliela kie djab doenia par doei djane ek hoike koetjh khaatien praatna karie, tab hamaar swarag ke Pieta toelogke praatna poera kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Djab doei kie tien manai hamaar naam me bieswaas karke ekattha hoiga, tab ham oelogke bietj me rahab.” ");
INSERT INTO hnsNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tab Petras aaike poetjhies kie: „Prabhoe djie, djab hamaar bhaai hamaar sanghe ber ber boeraai karie tab ham oke kai dafe tjhama karab? Saat dafe talak?” ");
INSERT INTO hnsNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tab oe bolies: „Ham tose boliela na saat dafe talak, bakie sattar dafe saat talak.” ");
INSERT INTO hnsNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aur oe ek kaahaanie kahe lagal swarag ke raadj ke biese me. Oe bolies: „Ekgo raadja raha. Ek dien oe aapan kamkartan se maangat raha paisa ke baare me lekha lewe. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Djab oe soeroe karies tab oesab ek kamkarta ke laais djaun okar das hadjaar mohar kardja raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bakie oe kardja kabhie na bhar sakat raha. Ohie se raadja aapan kamkartan ke hoekoem deis oke aur okar aurat larkan aur okar sab tjiedj betjke kardja bhare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tab aadmie raadja ke gor gieral aur bientie kare lagal kie: ‘He raadja, dhieradj kar! Ham aapke sab kardja bhar deb!’ ");
INSERT INTO hnsNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tab raadja ke daaja lagal aur bolies: ‘Toe dja, ham tor sab kardja maaf kar deila.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tab djab aadmie baahar gail, tab oke ek doesar kamkarta bhetaail djaun ekar thora se kardja raha. Tab oe okar gatai dabaaike bolies: ‘Ehie laage hamaar kardja bhar!’ ");
INSERT INTO hnsNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tab ie kamkarta okare aage gierke ose bientie kare lagal kie: ‘Dhieradj kar! Ham toke sab bhar deb!’ ");
INSERT INTO hnsNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bakie ie na maangies soene aur djaaike oke band karwaai deis djab talak oe na bhar paai. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tab raadja ke ekwa kamkartan djab ie haal dekhies tab oesabke bahoet doekh bhail aur oelog gail raadja se sab tjiedj bataawe. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tab raadja oe kamkarta ke apane paas bolaaike bolies: ‘Niemakharaam! Toe hamse bientie karle kie: Dhieradj kar! Aur ham tor sab kardja maaf kar deilie. ");
INSERT INTO hnsNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Toke tjaahat raha ekwa se aisane kare ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Raadja bahoet goessaail. Aur oe aapan kamkartan se bolies: ‘Ie aadmie ke djahal me sadja dewe waalan ke dwaara marwaaw djab lek oe aapan kardja na bharie.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Djab Jiesoe ie kaahaanie kahe tjoekal raha tab samdjhaais kie: „Aisane djab toelog aapan bieswaasie bhaai ke paap aapan diel bhar se tjhama na kariehe tab hamaar swarag ke Pieta toelogke paap ke tjhama bhie na kariega.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jiesoe ie sab baat bolke Gaalielea ke diehaat se tjal gail. Tab oe Jordaan nadie ke oepaar Joedea diehaat me gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dher manai okar pietjhe tjalal. Aur oe hoewa par sab bemarian ke attjha karies. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tab ekaatgo Fariesie aail oke phasaawe khaatien. Oesab poetjhies: „Ek aadmie aapan aurat ke tjhor sake hai tjaahe djaun tjiedj khaatien, kie na?” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tab oe bolies: „Ka, toelog Parmeswar ke baat na parhle hai? Djab oe saara sansaar banaais tab soeroe se oe aadmie aur aurat ke ek djora banaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ohie se ek mardaana ke tjaahie aapan maai-baap se alag hoike aapan aurat ke sanghe ek howe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Aise oesab na doei dehie bakie ek dehie hai. Aur djab Parmeswar doei paraanie ke ekattha kare hai, tab koi ke na tjaahie oesabke tjhorwaawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tab Fariesie log bolies: „Mosas tab kaahe ke bolies hai kie ek aadmie djab oe aapan aurat ke tjhor dewe hai, tab oke tjaahie oke ek kaagadj dewe ke djaun me liekhal hai kie ab se oe okar biehautie na hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tab oe bolies: „Mosas djaanat raha kie toelog khaalie aapan man waala kare hai, ohie se oe aise bolies. Bakie doenia ke soeroe me aise na raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ham toelogse boliela kie dje aapan aurat ke tjhor deiga aur ek doesar aurat se biaah kariega, oe aapan biaah ke waada toere hai. Khaalie djab okar aurat ek doesar aadmie ke rakhe hai, tab oe oke tjhor sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tab tjela log bolies: „Djab aisan hai tab bestar hai kie koi aapan biaah na kare.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bakie oe bolies: „Djaun baat ham ab toelogse bolab sab koi na samadjh paai, khaalie dje ke Parmeswar samdjhaai deiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Koetjh manai log hai djaun paidaais se aisan hai kie oelogke biaah na hoi sake hai. Aur koetjh manai log hai djaun doesar log ke dwaara aise banaawal gail hai. Aur bhie koetjh manai log aapan biaah na karies djeme oesab swarag ke raadj khaatien auro attjha se kaam kar sake. Dje ie baat samadjh paawe hai, oke tjaahie bhie maan lewe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ek dien koetjh maai-baap log aapan larkan ke Jiesoe ke paas legail. Oelog maangat raha kie oe aapan haath oelogke oeppar dharke praatna kare. Tab Jiesoe ke tjela log aaike oelogke daatke bolies kie: „Toelog dja hia se.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bakie Jiesoe bolies: „Oesabke na rok! Oe larkan ke hamare paas aawan de. Swarag ke raadj oesabke khaatien hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tab oe larkan par haath dharke praatna karies aur hoewa se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ek dien ekgo aadmie Jiesoe ke paas aaike poetjhies kie: „Maastar djie, kaun bhalaai ham karie hardam Parmeswar ke saath rahe khaatien?” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tab oe bolies: „Toe hamse kaahe ke bhalaai ke biese me poetjhe hai? Khaalie ek bhalaai kare Waala hai. Aur djab toe sada khaatien okar saath maange rahe, tab toke tjaahie okar hoekoem maane ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tab naudjawaan poetjhies: „Kaun hoekoem?” Tab oe bolies: „Koi ke djaan na maar, aapan biaah ke waada na toer, tjorie na kar, djhoettha gawaahie na de, ");
INSERT INTO hnsNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","aapan maai-baap ke ieddjat kar aur ek doesar ke pjaar kar djaise toe apane ke pjaar kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tab naudjawaan bolies: „Ie sab hoekoem ham ab talak maaniela aur ham kaun tjiedj auro karie?” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tab oe bolies: „Djab toe maange hai poera howe tab dja aapan sab dhan-daulat betjke garieb log ke dei de. Tab toke swarag me dhan mieliega. Tab aaike hamaar sanghe tjal.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ie sab baat soenke naudjawaan bahoet oedaas hoike tjal gail. Oke bahoet dhan-daulat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tab Jiesoe aapan tjela log se bolies: „Ham toelogse satj boliela kie ek dhanwaan khaatien moeskiel hai swarag ke raadj me bhiettar djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ekgo oet khaatien moeskiel hai ekgo soei ke hol me ghoese ke. Aur ham toelogse boliela kie ek dhanwaan khaatien auro moeskiel hai Parmeswar ke raadj me bhiettar djaai ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tab tjela log ie sab baat soenke bahoet oedaas hoi gail aur poetjhies: „Tab bhala ke batj sakie?” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tab oe oesabke taakke bolies: „Iensaan ie na kar sakie, bakie Parmeswar sab koetjh kar sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tab Petras bolies: „Dekh, hamlog sab koetjh tjhorke tor sanghe tjale lagalie. Tab hamlogke ka mieliega?” ");
INSERT INTO hnsNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tab oe bolies: „Soen. Toelog hamaar rasta par tjale hai. Aur ham toelogse satj boliela kie aane waala djoeg me djab iensaan ke Beta aapan mahiemma se gaddie par baithke raadj tjalaaiga, tab tohoelog baara gaddie par baithiehe Israel ke baara koel ke oeppar faisala kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aur har ek djaun ghar-dwaar, bhaai-bahien, maai-baap, larkan aur khet ke tjhoriega hamaar rasta par tjale khaatien, oke dhartie par ie sab dher dafe mieliega aur oe bhie sada ke lieje Parmeswar ke saath rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bakie dher manai log djaun ab pahiela hai, oesab pietjhar djaaiga, aur djaun paatjhe hai, oesab agar djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ie baat samdjhaawe khaat Jiesoe swarag ke raadj ke biese me ekgo matlab ke kaahaanie kahies: „Ek aadmie raha aur oke ekgo agoer ke khet raha. Ek dien oe sabere sabere gail kamkartan khodje okare khet me kaam kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tab oe ekaat aadmie paais aur oesab tajaar hoi gail ek rodj ekgo tjaanie ke paisa khaat kaam kare ke. Oe oesabke aapan khet me pathaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tab lagbhag nau badje oe phien se bahare gail aur dekhies badjaar me ekaat aadmie begar kaam ke thara hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Oe bolies: ‘Toelog aaw hamaar khet me kaam kar aur ham toelogke ek attjha madjoerie debe.’ Aur oelog bhie gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tab baara badje aur tien badje oe phien se bahare djaaike aisane karies. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tab paatj badje sandjha ke oe phien se bahare gail aur dekhies kie ekaat aadmie abbe talak begar kaam ke thara hai. Tab oelogse poetjhies: ‘Toelog kaahe ke hia dien bhar be-kaam ke thara baate?’ ");
INSERT INTO hnsNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tab oelog bolies: ‘Hamlogke kaam na mielal.’ Tab oe bolies: ‘Tohoelog dja hamaar khet me kaam kar.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tab djab raat bhail tab djamiendaar aapan mandjha se bolies: ‘Kamkartan ke bolaaike oesabke madjoerie dei de. Djaun pietjhe aail hai, oesabke pahiele deihe, tab pahiela waalan ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tab djaun kamkartan paatj badje kaam par gail raha, oesab pahiele aail aur oesabke ek tjaanie ke paisa mielal. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tab djab sabere waala kamkartan aage aail, tab oesab sotjies kie oesabke ek tjaanie ke paisa se djaada mieliega. Bakie ohoesabke ek tjaanie ke paisa mielal. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tab oesab ie paisa leike djamiendaar ke oeppar bhoen-bhoenaai lagal aur bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ie paatjhe waalan khaalie ek ghanta kaam karies aur toe iesabke hamlogke baraabar paisa deile. Aur hamlog dien bhar kara ghaam me garhoe kaam karlie.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tab djamiendaar oman se ekgo ke djabaab deis kie: ‘Bhaai, ham tor tjorie thoro karlie hai? Toe hamse to ek bhaile rahiele ek tjaanie ke paisa khaatien kaam kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Toe aapan paisa leike tjal dja. Ham maangiela iesab ke tor baraabar dewe. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ham aapan paisa se to kar sakiela djaise ham maangiela. Kaahe ke toelog djaran kare hai kie ham bhalaai kariela?’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aur Jiesoe samdjhaais kie: „Aise djaun manai log pahiela hai, oesab pietjhar djaai, aur dje dje paatjhe hai, oesab agar djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ekare baad djab Jiesoe Jeroesaalem sahar ke or djaat raha, tab oe aapan baara tjela log ke ekwan se alag karke bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","„Dekh, hamlog djaaila Jeroesaalem. Aur hoewa par iensaan ke Beta barka agwan aur dharam ke parhal logan ke haath me saup dewal djaaiga aur oke maut ke sadja mieliega. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tab oesab oke pardesie logan ke haath me saup deiga. Oelog okar hasie oeraai aur oke maariega aur khiella se kroes par thokke maar dhaariega. Tab tiesara rodj Parmeswar oke maut me se djie oethaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Baad me ekgo aurat aail. Oe Johaanas aur Jaakobas ke maai raha. Oelogke baap Sebedeas raha. Oe aurat aapan doeno betwan ke leike Jiesoe ke paas aail aur okar aage djhoekke ose koetjh maangat raha poetjhe. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tab oe poetjhies: „Toe ka maange hai?” Tab aurat bolies: „Djab toe raadj tjalaihe tab hamaar doei betwan tor doeno bagal baith sakiega?” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tab oe bolies: „Toelog na samdjhe hai kie toelog ka maange hai. Toelog oe doekh oethaai paihe djaun hamke oethaawe ke parie?” Tab oesab bolies: „Djie-ha, hamlog oethaai paabe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tab oe bolies: „Toelog hamaar paatjhe bhie doekh oethaihe. Bakie hamaar kaam na hai sallaah kare ke kie ke hamaar doeno bagal baith sakiega. Hamaar Pieta ie dardja deiga dje ke oe maange hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tab ekwan tjela log djab soenies kie ie doeno ka maange hai tab oelog bahoet goessaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Bakie Jiesoe oesabke apane paas bolaaike bolies: „Toelog djaane hai kie doenia ke mantrie log doesare ke oeppar hoekoem tjalaawe hai, aur barka manai log doesare ke oeppar barkwa khele hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bakie toelog apane me aise na kariehe. Dje toelog me se maange hai barkwa howe, oke tjaahie doesare ke kamkarta bane ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aur dje maange hai sab se barka dardja paawe, oke tjaahie doesare ke goelaam bane ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aisane iensaan ke Beta na aail hai apane ke sewa karwaawe, bakie doesar log ke kamkarta howe khaatien aur aapan djaan dewe se dher manai log ke tjhoetkaara dewe khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Djab Jiesoe aapan tjela log ke saath Jerieko sahar me se djaat raha, tab ek djhoend manai oesabke paatjhe tjalal. ");
INSERT INTO hnsNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Doei andha aadmie daam ke kienaare baithal raha. Tab djab oesab soenies kie Jiesoe paas howe hai, tab tjiellaai lagal aur bolies: „He Prabhoe djie, Daawied ke Aulaad! Hamlog par daaja kar!” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tab hoewa ke manai log oelogke daatke bolies: „Tjoep!” Bakie oelog auro tjiellaaike bolies: „He Prabhoe! He Daawied ke Aulaad! Hamlog par daaja kar!” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tab Jiesoe roek gail aur oelogke bolaaike poetjhies: „Toelog ka maange hai kie ham karie?” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tab oelog bolies: „Prabhoe djie, hamlogke aakhie attjha kar de!” ");
INSERT INTO hnsNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tab oke bahoet daaja lagal aur oelogke aakhie tjhoeis. Bas doeno toerant dekhe lagal. Aur oelog okar sanghe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Djab oelog Jeroesaalem ke nagietj aai gail tab oesab Betfaage lage pahoetjal. Oe gaaw Djaitoen pahaar se doer na hai. Tab Jiesoe aapan tjela log me se doeigo ke tjoenke bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","„Oe gaaw me dja djaun tor aage hai. Tab toelog toerant hoewa par ek gadahie ke baanhal paihe, aur okar battja hoewa bhie hai. Oke kholke hamaar paas laihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aur djab koi koetjh poetjhie, tab bol deihe: ‘Prabhoe ke eke kaam hai aur oe abbe pathaai dei.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ie sab tjiedj dwaara Parmeswar ke sanesia Sakaaria ke baat poera bhail. Oe bolies raha kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","„Sion ke aurat log se bataai de kie: ‘Dekh, toelogke Raadja toelogke paas aaiga. Oe bahoet dhiera aadmie hai aur ek gadahie ke battja par baithke tjale hai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Oe doei tjela log djaaike karies djaise Jiesoe bolies raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Oesab gadahie aur battja ke Jiesoe ke paas legail aur aapan kapra okar oeppar dharies aur Jiesoe opar baithal. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tab Jiesoe ke aadar kare khaatien dher manai log aapan kapra rasta par bietjhaawe lagal. Doesar log per ke daarhie kaat-kaatke bhie rasta par bietjhaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aur djaun log okar aage aur paatjhe tjalat raha, oesab tjiellaaike bolies kie: „Daawied ke Aulaad! Hamlog tor aadar kariela! Oe soekhie hai aur Prabhoe ke naam se aawe hai! Hamlog swarag talak okar aadar kariela!” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Djab Jiesoe Jeroesaalem me bhiettar gail tab sahar bhar me haltjal-matj gail. Aur manai log poetjhe lagal: „Ie ke hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tab djhoend bolies: „Ie Parmeswar ke sanesia Jiesoe hai. Oe Gaalielea ke diehaat Naasaaret sahar me ke hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jiesoe Parmeswar ke mahal ke angana me gail. Tab oe sab kiene-betje waalan ke lakhetke baahar karies. Oe paisa toeraawe waala log ke tafra oeloet deis aur kaboettar betje waalan ke koersie bhie. Aur oesabse bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","„Parmeswar liekhwaais hai kie: ‘Hamaar ghar ek djagaha rahe ke tjaahie praatna kare khaatien, bakie toelog eke daakoe ke ghar banaai deile.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hoewa par koetjh andha aur loendj manai log Jiesoe ke paas aail aur oe sab ke attjha kar deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bakie barka agwa log aur dharam ke parhal log djab ie atjambho kaam dekhies aur djab soenies kaise larkan Parmeswar ke mahal ke angana me tjiellaaike bole hai kie: „Daawied ke Aulaad! Hamlog tor aadar kariela!”, tab oesab goessaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Oesab Jiesoe se bolies kie: „Toe na soene hai kie larkan ka bole hai?” Tab oe bolies: „Ha, ham soeniela. Bakie toelog Parmeswar ke poestak me na parhle hai kie: ‘Aap tjhota larkan aur doedh pieje waalan ke moeh se aapan aadar karwaawe hai?’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tab oe oesabke tjhorke tjal gail. Oe Betaania gaaw me gail raat bhar rahe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sabere sabere djab Jiesoe phien se Jeroesaalem sahar djaat raha, tab oke bhoekh lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tab oe daam ke kienaare ekgo adjier ke per dekhies aur okar lage gail. Bakie oman khaalie patta raha. Tab oe ose bolies: „Aadj se toe kabhie na ek phal deihe.” Aur per toerant djhoeraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tab tjela log ie dekhke bahoet atjambho bhail aur poetjhies: „Kaise per toerant djhoeraai gail?” Tab oe bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","„Ham toelogse satj boliela kie djab toelogke bieswaas hai aur toelogke doebdha na hai, tab toelog na khaalie kariehe djaun ie per se bhail hai, bakie toelog hoewa ke pahaar se bol sakiehe: ‘Oeth aur samoendar me gier dja!’ aur aisane hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aur tjaahe djaun tjiedj toelog bieswaas karke praatna me Parmeswar se mangiehe, oe toelogke mieliega.” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tab Jiesoe phien se Parmeswar ke mahal ke angana me gail aur hoewa par siekhaawe lagal. Tab barka agwa log aur djaatie ke barkwan okar paas aaike poetjhies kie: „Toe ie sab tjiedj kekar hoekoem se kare aur siekhaawe hai? Tose ke bolies hai aise kare ke?” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tab oe bolies: „Pahiele ham ek baat poetjhab. Djab toelog hamke djabaab deihe tab ham toelogse bhie bataab kie ham ie sab tjiedj kekar hoekoem se kariela. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ke Johaanas dopoe kare waala ke hoekoem deis raha manai logan ke dopoe kare ke? Oke Parmeswar hoekoem deis raha kie manai logan?” Tab agwa aur doesar barkwan apane me sallaah karke bolies: „Djab hamlog bolab: ‘Oke Parmeswar hoekoem deis raha,’ tab oe boliega: ‘Tab toelog kaahe ke Johaanas ke baat na bieswaas karle hai?’ ");
INSERT INTO hnsNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bakie djab hamlog bolab: ‘Oke manai logan ie hoekoem deis raha,’ tab djhoend hamlogke oeppar goessaai djaaiga. Sab koi to bieswaas kare hai kie Johaanas ekgo Parmeswar ke sanesia raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tab oesab Jiesoe se bolies kie: „Hamlog na djaaniela kie ke oke hoekoem deis raha.” Tab oe bolies: „Tab ham toelogse bhie na bataab kekar hoekoem se ham ie sab kaam kariela.” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tab Jiesoe kahe lagal kie: „Ek aadmie ke doei beta raha. Ek dien oe gail barkwa ke paas aur bolies: ‘Beta, aadj toe dja agoer ke khet me kaam kar.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tab oe bolies: ‘Ha baap’. Bakie oe na gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tab baap gail doesarkwa ke paas aur ohoese ehie baat bolies. Tab ie waala bolies: ‘Na, ham na djaab.’ Bakie ekare baad pastaaike tabbo gail kaam kare.” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aur Jiesoe dharam ke barkwan se poetjhies: „Toelog ka sotje hai, ie doeno me se ke aapan baap ke baat maanies?” Tab oesab bolies: „Doesarkwa.” Tab oe bolies: „Ham toelogse satj boliela kie baimaan djoetie ke paisa bharwaawe waalan aur tjhatjhoendar logan toelogse auro sahadj Parmeswar ke raadj me bhiettar djaai sakiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Johaanas siekhaais kie toelogke kaise tjaahie Parmeswar ke aage rahe ke, tabbo toelog okar baat na manle. Bakie baimaanie waalan aur tjhatjhoendar logan okar baat bieswaas karies. Tabbo toelog ie dekhke aapan boeraai na pastaile aur okar baat na manle. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ek doesar matlab ke kaahaanie soen. Ekgo djamiendaar raha. Oe ekgo khet tajaar karies aur agoer ke per bois. Tab oe khet ke gherke djamien me ekgo petie banaais oman agoer gor se katjare khaatien. Aur oe ek oetja dardja banaais djaaha se tjaaro or dekhaat raha. Tab oe aapan khet ek doesare ke bhaara karke par-des tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tab djab tem aail phal toere ke, tab oe aapan goelaam log ke hoewa pathaais aapan hiessa lewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bakie khetiar log oesabke pakarke pieties, doesar ke maar dhaaries aur tiesara ke patthar bieg-biegke maar dhaaries. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tab djamiendaar auro goelaam log ke pathaais. Bakie khetiar log iesabse oisane karies. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tab ant me oe aapan beta ke pathaais. Oe sotjies: ‘Oelog oke koetjh na kariega.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bakie khetiar log djab djamiendaar ke beta ke aawat dekhies, tab apane me sallaah kar leis kie: ‘Ie hakdaar hai! Aaw hamlog eke bhie maar dhaarie. Tab ekar sab hak hamlogke hoi djaaiga!’ ");
INSERT INTO hnsNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aur oesab oke pakarke khet ke bahare karke maar dhaaries.” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aur Jiesoe poetjhies: „Djamiendaar aaike khetiar log se ka kariega?” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tab manai log bolies: „Oe aaike ie niemakharaam log ke djaan se marwaai dhaarie aur khet doesare ke bhaara kar deiga dje oke okar hiessa phal tem par deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","44","Tab oe bolies: „Parmeswar toelogke mauka deis hai okar raadj me bhiettar djaai ke. Bakie ham toelogse boliela kie oe ie mauka toelogse tjhien leiga aur ek doesar djaatie ke deiga. Oesab oke okar hak deiga. Toelog Parmeswar ke poestak me parhle hai kie: ‘Djaun ieta ghar banaawe waalan be-kaamiel maanies raha, oe sab se kaamiel ieta maanal gail hai. Ie Parmeswar ke kaam hai, aur ie sab dekhke hamlog atjambho hoila. Bakie dje ieta par gieriega, kie to dje par ieta gieriega, oe naas hoi djaaiga.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tab barka agwan aur Fariesie log ie kaahaanie soenke samadjh gail kie Jiesoe oelogke biese me batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Oesab maangat raha oke pakare, bakie djhoend ke deraat raha. Manai log oke to Parmeswar ke sanesia ghat maanat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jiesoe swarag ke raadj ke biese me samdjhaawe ke auro matlab ke kaahaanie kahies: ");
INSERT INTO hnsNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","„Ekgo raadja raha. Ek dien oe maangat raha aapan beta ke biaah kare. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tab djab tem aail tab oe aapan goelaam log ke pathaais nautaharie log ke bolaawe khaatien. Bakie oelog na maangies aawe. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tab oe doesar goelaam log se sanesa pathaais. Oelog gail bole: ‘Dekh, ham sab khaaik tajaar karlie, khasie-osie gieral, aur sab koetjh tajaar hai. Aawo nauta karo.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bakie nautaharie log dhiaan na lagaais. Kauno gail aapan khete, kauno gail aapan kaar-baar dekhe, ");
INSERT INTO hnsNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","aur kauno raadja ke goelaam log ke pakarke natiedja karies aur maar dhaaries. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tab raadja bahoet goessaail, aur aapan soerdjaatie se ie djaanmarwa log ke marwaai dhaaries, aur oelogke sahar me aagie lagwaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tab oe aapan goelaam log se bolies kie: ‘Sab tjiedj tajaar hai, bakie nautaharie nauta laaik na raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Toelog dja rasta ke kona kona par aur sab koi ke bola laaw nauta kare khaatien.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Goelaam log rasta par djaaike dher manai ke ekattha karies, kharaab aur attjha waalan, sab ke. Aur raadja ke mahal nautaharie log se bhar gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Djab raadja bhiettar aail aapan nautaharie log se bhet kare, tab oe ek aadmie ke dekhies djaun nauta ke kapra na pahienies raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tab raadja ose poetjhies: ‘Bhaai, toe biena nauta ke kapra se kaise bhiettar aile hai?’ Bakie aadmie koetjh na bolies. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tab raadja aapan naukar log se bolies: ‘Ekar haath gor baanhke oke bahare andhiaar me bieg de. Oe hoewa par pastaaike daat pies-pieske khaalie roiga.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jiesoe bolies: „Dher manai bolaawal gail, bakie kamtie manai tjoenal gail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tab Fariesie log djaaike apane me baat-tjiet karies kaise Jiesoe ke tjalaakie se baat se phasaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tab oesab aapan tjela log aur bhie raadja Herodes ke ekaat saathie log ke Jiesoe ke paas pathaais. Oesab djaaike ose bolies: „Maastar djie, hamlog djaaniela kie toe sattja aadmie baate. Aur tjaahe dje djaun bole hai, tabbo toe moeh na dekhe hai aur sattjaai se siekhaawe hai Parmeswar ke rasta par tjale ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ohie se toe hamlogke bataaw kie hamlogke tjaahie Roma ke maahaaraadja ke djoetie ke paisa bhare ke kie na? Toe ka sotje hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bakie Jiesoe oelogke tjalaakie djaanat raha aur bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","„Dhokhaabaadj log, toelog hamke ka adjmaawe hai? Hamke ek paisa dekhaaw djaun se djoetie bharal dja hai.” Oesab ek paisa laais. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tab oe poetjhies: „Epar kekar moertie aur naam hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tab oelog bolies: „Maahaaraadja ke.” Tab oe bolies: „Maahaaraadja ke de djaun okar hai, aur Parmeswar ke bhie de djaun okar hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tab sabhan ie djabaab soenke bahoet atjambho bhail aur oke sanne tjhorke tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ohie rodj ekaat Sadoesie Jiesoe ke paas aail. Oesab siekhaawe hai kie koi maut me se na djie oeth sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Oelog aaike Jiesoe se poetjhies kie: „Maastar djie, Mosas bolies hai kie djab ek aadmie mar djaai aur oke larkan na rahie, tab okar bhaai ke tjaahie okar aurat se biaah karke larkan djalmaawe ke aapan maral bhaai khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Soen. Saat bhaai raha. Pahielkwa biaah karke mar gail biena larkan djalmaawe. Ohie se okar bhaai oe aurat se biaah karies. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aisane doesarkwa aur tiesarkwa satwa talak ose biaah karke begar larkan djalmaawe mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tab ant me aurat bhie mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ab hamlog maangiela djaane kie djie oethe ke dien par aurat kekar rahiega? Oe to saat aadmie ke aurat raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tab oe bolies: „Toelog Parmeswar ke baat aur okar saktie na djaane hai, ohie se toelog khaalie oelta-phoelta sotje hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Djie oethe ke baad koi na biaah kariega. Manai logan djaise swarag ke parie logan rahiega. Oesab biaah bhie na kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aur djie oethe ke baare me, toelog na parhle hai kie Parmeswar toelogke baap-daada log ke biese me ka bolies hai? Oe bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ham Aabraaham, Iesaak aur Jaakob ke Parmeswar baatie.’ Oe maral logan ke Parmeswar thoro hai, bakie djienda manai logan ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tab manai log ie sab gjaan soenke bahoet atjambho bhail. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Djab Fariesie log soenies kie Jiesoe Sadoesie log ke moeh band kar deis hai, tab oesab ekattha hoike okar lage aail. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Oesab me se ekgo dharam ke kaanoen ke parhal waala maangies oke baat se phasaawe. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Oe poetjhies: „Maastar djie, Parmeswar ke kaanoen me sab se barka hoekoem kaun hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tab Jiesoe bolies: „Prabhoe tor Parmeswar hai aur toke tjaahie oke diel bhar se, tan-man se aur aapan sab boeddhie se prem kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ie sab se barka aur pahiela hoekoem hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Doesara hoekoem ohie ke baraabar hai. Toke tjaahie ek doesare ke apane ghat tjaahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Parmeswar ke saara kaanoen aur okar sanesian ke sab liekhal baat ie doei hoekoem ke biese me hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Djab Fariesie log ekattha raha tab Jiesoe oelogse poetjhies: ");
INSERT INTO hnsNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","„Toelog ka sotje hai Kriest ke baare me? Oe kekar aulaad hai?” Tab oelog bolies: „Raadja Daawied ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tab oe bolies: „Attjha. Bakie Daawied Pawietr Aatma ke dwaara kaise oke aapan Prabhoe bolaai sakat raha? Oe to bolies hai: ");
INSERT INTO hnsNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Parmeswar hamaar Prabhoe se bolies hai kie: Aaw hamaar dahiena bagal baith djab lek ham tor doesman ke tor gor ke nietje na kar debe.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Daawied oke Prabhoe bolaawe hai, tab oe kaise okar aulaad bhie hoi sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ie baat par koi na djabaab dei paais aur ohie dien se koi ke hiemmat na paral phien se oke adjmaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jiesoe djhoend manai aur aapan tjela log se bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","„Dharam ke parhal waalan aur Fariesie log Mosas ke dardja par baithke Parmeswar ke baat aur okar dharam ke kaanoen siekhaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Toelog oesabke baat poera taur se soeniehe aur kariehe. Bakie oelogke tjaal-tjalan na apanaihe. Oelog djaun bole hai apane na kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Oelog aapan hoekoem aur nem djaise garhoe bodjha baanhke manai log ke kandha par laad dewe hai, bakie oelog koetjh na kare hai manai log ke sahaaita kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Oelog aapan har ek kaam khaalie kare hai manai ke dekhaawe khaat. Oelog aapan praatna ke tjamotie khoeb tjakala banaaike pahiene hai. Aur oesab aapan kapra ke djhalarie auro lamba banaawe hai dekhaawe khaatien kie oesab ketana bhaktie waala hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Oelog partjaar ke ghar me maange hai aage baithe, aur djab oesab kahoe bhodjan kare hai tab maange hai sab se attjha dardja par baithe. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aur badjaar me oesabke bahoet attjha lage hai djab sab koi oelogke ‘maastar djie’ bolaawe hai aur oelogke barka maanke poetjhe hai: ‘Aap kaise rahielo?’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Oe bhie bolies: „Bakie toelog apane ke ‘maastar’ na bolwaihe. Toelogke khaalie ek Maastar hai, aur toelog sab koi bhaai-bhaai baate. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Toelog doenia me koi ke aapan baap na banaihe. Toelogke khaalie ek Baap hai, aur oe tor swarag ke Pieta hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Apane ke barkwa bhie na bolwaihe. Toelogke khaalie ek Barkwa hai, aur oe Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bakie dje toelog me se sab koi ke naukar ghat rahiega, oe sab se barka rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dje apane ke oetja maane hai, oe tjhota karal djaaiga. Aur dje apane ke tjhota kare hai, oe barka karal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Haai dharam ke parhal waalan aur Fariesie log, dhokhaabaadj logan! Toelog manai log khaatien moeskiel karle baate swarag ke raadj me bhiettar djaai ke. Toelog apane na djaihe, aur dje kausies kare hai, oke toelog mauka na dewe hai hoewa par pahoetje ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Haai dharam ke parhal waalan aur Fariesie log, dhokhaabaadj logan! Toelog wiedhwa log ke paisa aur ghar-or tjalaakie se tjhien lewe hai aur dekhaawe khaat derie talak praatna kare hai. Ehie khaatien toelogke kara sadja mieliega. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Haai dharam ke parhal waalan aur Fariesie log, dhokhaabaadj logan! Toelog samoendar aur des bhar ghoem dhaare hai ek manai khodje ke oke aapan tjaal par tjalaawe ke. Aur djab oe aisane kare hai tab toelog oke narak ke rasta dekhaawe hai aur oe toelogse doegana kharaab howe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Haai dharam ke parhal waalan! Toelogan andha rasta dekhaawe waalan baate! Toelog siekhaawe hai kie djab koi Parmeswar ke mahal ke naam par kasam kha hai, tab ie koetjh na hai. Bakie djab koi oe mahal ke sona ke naam par kasam kha hai, tab oke tjaahie aapan baat poera kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Toelog bhoettjar aur andha baate. Kaun tjiedj auro barka hai, sona kie Parmeswar ke mahal djaun sona ke pawietr kare hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aur toelog siekhaawe hai kie djab koi baliedaan djaraawe ke tafra ke naam par kasam kha hai, tab ie koetjh na hai. Bakie dje baliedaan ke naam par kasam kha hai, oke tjaahie aapan baat poera kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Are, andha log! Toelog kaise doesare ke Parmeswar ke rasta dekhaai sakiehe? Kaun tjiedj auro barka hai, maral djanaawar, kie baliedaan djaraawe ke tafra djaun oke pawietr kare hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dje baliedaan djaraawe ke tafra ke naam par kasam kha hai, oe bhie sab baliedaan ke naam par kasam kha hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aur dje Parmeswar ke mahal par kasam kha hai, oe opar aur Parmeswar par kasam kha hai djaun oman rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aur dje swarag ke naam leike kasam kha hai, oe Parmeswar ke gaddie par kasam kha hai aur Parmeswar par djaun opar baithal hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Haai dharam ke parhal waalan aur Fariesie log, dhokhaabaadj logan! Toelog aapan martja, lesoen aur djiera ke ek daswa hiessa Parmeswar ke dewe hai, bakie okar kaanoen ke sab se barka baat na maane hai djaise sattjaai se faisala aur daaja kare ke aur bharosaadaar rahe ke. Ek daswa hiessa dewe ke thiek hai, bakie toelogke bhie tjaahie Parmeswar ke hoekoem maane ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Andha log! Toelog pieje ke paanie me se ekgo tjhota maskieta ke tjhaan lewe hai, bakie ek barka oet ke liel lewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Haai dharam ke parhal waalan aur Fariesie log, dhokhaabaadj logan! Toelog djaise bartan baate aur khaalie bahare dhowe hai, bakie bhiettar me toelog tjorie tjandaalie se bharal baate. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Andha Fariesie log, pahiele bhiettar dhow, tab bahare bhie safa hoi djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Haai dharam ke parhal waalan aur Fariesie log, dhokhaabaadj logan! Toelog djaise oeddjar rangal kabar baate. Oe bahare se tjiekkan dekha hai, bakie oman khaalie haddie-goeddie aur maila-koetjaila hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aise toelog sattja aur be-kasoerie log ghat dekha hai, bakie sattje me toelog dhokhaabaadj baate aur toelog Parmeswar ke kaanoen tanko na maane hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Haai dharam ke parhal waalan aur Fariesie log, dhokhaabaadj logan! Toelog Parmeswar ke sanesian khaatien barhia kabar banaawe hai aur bhala manai ke mare ke baad ieddjat kare khaatien tjienha sadjaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aur toelog bole hai kie: ‘Hamlogke baap-daada log Parmeswar ke sanesian ke maar dhaaries hai. Bakie djab hamlog oe tem me djietie, tab hamlog aisan kharaabie kabhie na kartie.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ie rakam se toelog apane gawaahie dewe hai kie toelog djaanmarwa ke aulaad baate. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Toelog aapan baap-daada log ke boeraai poera kar de! ");
INSERT INTO hnsNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Are, saap aur saap ke battjan! Toelog kaise narak ke sadja se batj sakiehe? ");
INSERT INTO hnsNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dekh, ham toelogke paas sanesian ke aur boeddhiemaan log ke aur dharam ke parhal waalan ke pathaaila. Toelog oesab me se koi ke maar dhariehe, koetjh log ke kroes par thokwaai deihe, koi koi ke partjaar ke ghar me pietwaihe aur doesar log ke sataihe kie oesabke ie sahar se oe sahar talak bhaage ke parie. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ohie se ant me toelog sadja katiehe sab be-kasoerie log ke djaan lewe khaatien. Ie boeraai dhartie par soeroe bhail djab Aabal biena kasoer ke maar dhaaral gail. Tab toelogke baap-daada log auro djaada be-kasoerie log ke maar dhaaries. Aur ant me oelog Berekja ke beta Sakaaria ke Parmeswar ke mahal aur baliedaan djaraawe ke tafra ke bietj me bhie biena kasoer ke maar dhaaries. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ham toelogse satj boliela kie iesabke sadja toelogke oeppar pariega.” ");
INSERT INTO hnsNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jiesoe bhie bolies: „He Jeroesaalem ke manai log! Toelog hardam Parmeswar ke sanesian ke maar dhaare hai. Aur toelog patthar bieg biegke maar dhaare hai dje ke oe toelogke paas pathaais hai. Ham kai dafe manglie toelogke aapan paas batore djaise ek moergie aapan battja ke aapan pakhna ke nietje bator lewe hai! Bakie toelog na maangat rahiele. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Parmeswar ke mahal ke dekh. Ab oe oke tjhor deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aur ham toelogse bataaila kie ab se toelog hamme na dekhiehe djab talak toelog boliehe kie: ‘Oe soekhie hai aur Prabhoe ke naam se aawe hai!’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tab Jiesoe Parmeswar ke mahal ke angana me se niekar gail. Aur okar tjela log okar paas aaike dekhaais kie mahal ketana barka aur soendar hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bakie oe bolies kie: „Ka, ie toelogke attjha lage hai? Ham toelogse satj boliela kie ie sab naas hoi djaaiga aur har ek ieta toeraai djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tab djab oe Djaitoen pahaar par gail aur hoewa par baithal, tab khaalie okar tjela log okar paas aail aur poetjhies: „Toe hamlogse bataai sake hai kie ie sab kab hoiga? Aur djab toe lautke aihe tab hamlog kaun tjienha dekhab, aur kab ie djoeg ke ant hoiga?” ");
INSERT INTO hnsNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tab oe bolies: „Batjaaike rahiehe kie toelogke koi na bhatkaawe. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Dher djhoettha log hamaar naam leike aaiga aur boliega: ‘Ham Kriest baatie.’ Aise bolke oesab dher manai log ke bhatkaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Toelog soeniehe kaise hia hoewa ek djaatie doesar djaatie se laraai kare hai aur kie auro laraai hoiga. Toelog na ghabaraihe. Ie sab howe ke tjaahie. Bakie djoeg ke ant abbe na hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ek djaatie doesar djaatie se laraai kariega aur ek raadj doesar raadj se bhie. Aur hia hoewa manai log khaai biena aur bhoeidol se mar djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ie sab tjiedj se aane waala doekh soeroe hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ekare baad manai logan toelogke sataaiga aur maar dhaariega. Aur hamaar naam me bieswaas kare ke kaaran sab djaatie logan toelogke djariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tab dher manai log aapan bieswaas tjhor deiga. Aur oesab djaran ke maare ek doesare ke pakarwaai deiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aur dher doesar log djhoetthe ke Parmeswar ke sanesia banke aur dher manai log ke bhatkaai deiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aur dher manai log kaanoen ke toerat djaaiga, ohie se oesabke pjaar kamtie howat djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bakie dje ant talak hiemmat baanhke hamare me bieswaas karte rahiega, oe batj djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aur pahiele khoes khabar Parmeswar ke raadj ke biese me doenia bhar me soenaawal djaaiga. Aise har ek djaat ke pata miel djaaiga, tab djoeg ke ant aai djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Parmeswar ke sanesia Daaniejel bol tjoekal raha kie ek ghienna naas kare waala tjiedj Jeroesaalem ke pawietr djagaha me thara karal djaaiga. Tab oe djagaha ekdam se naas karal djaaiga. Dje ie baat parhiega, oke tjaahie epar dhiaan lagaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Djab toelog ie tjiedj howat dekhiehe tab dje Joedea diehaat me rahiega, oke tjaahie pahaar par bhaag djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aur dje bahare baithal rahiega, oke na tjaahie ghar me bhiettar djaaike aapan tjiedj batore ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aur dje khete me rahiega, oke na tjaahie ghare djaaike kapra lewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Haai oe tem ke aurat djaun ke larka hoiga aur dje aapan larka ke doedh piaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Praatna kar kie toelogke thandha ke tem me kie to ek sabat ke dien par na bhaage ke parie. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Oe samai par iensaan ke etana kathien doekh aur moesiebat oethaawe ke pariega djaun doenia par aadj talak kabhie na bhail hai aur kabhie na hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bakie Parmeswar oe doekh ke samai tjhota kariega nahie to sab koi naas hoi djaaiga. Oe aise kariega aapan tjoenal waalan khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Djab koi toelogse boliega kie: ‘Dekh, oe manai Kriest hai,’ kie to: ‘Kriest hia hai,’ tab toelog ie baat na bieswaas kariehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Koetjh manai log aaike djhoetthe ke boliega kie oelog Kriest kie to ek Parmeswar ke sanesia hai. Oesab barka aur atjambho kaam kariega. Aur djab hoi sakat, tab oesab Parmeswar ke tjoenal waalan ke bhie bahakaai lewat. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Soen, ham toelogse ie sab baat aage se bataai deilie, ohie se batjaaike rahiehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Djab oe samai me koi bolie kie: ‘Kriest hoewa maidaan me hai,’ tab na djaihe dekhe. Aur djab koi bolie kie: ‘Oe bhiettar kamra me loekaail hai,’ tab ie baat bhie na bieswaas kariehe. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Djaise biedjalie dhartie ke ie kait se oe kait dekha hai, oisahie hoiga djab iensaan ke Beta lautke aaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Djaaha lahaas hai, hoewa par giedh bhie ekattha howe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ie moesiebat aur doekh ke baad toerant soeroedj andhiaar hoi djaaiga aur tjaan andjor na deiga. Tarai nietje gieriega aur aasmaan ke saktie hieliega. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tab aasmaan me iensaan ke Beta ke tjienha dekhaaiga. Tab doenia bhar ke djaatie log piet-pietke roiga. Aur sab koi iensaan ke Beta ke baadar par aawat dekhiega bahoet saktie aur bara mahiemma ke saath. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aur oe aapan parie log ke doenia bhar me pathaaiga. Oesab djor se toerahie badjaaiga aur tjaaro or okar tjoenal waalan ke batoriega. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Adjier ke per dekhke koetjh siekh. Djab toelog dekhiehe kie oe naawa patta dewe hai, tab toelog djaan dja hai kie garam ke tem aawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aisane ie sab tjiedj dekhke toelogke tjaahie djaane ke kie hamaar lautana nagietj aai gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aur ham toelogse satj boliela kie djaun manai logan ie sab dekhiega, oelog na mariega djab talak ie sab baat na poera hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Swarag aur dhartie miet djaaiga, bakie hamaar baat kabhie na mietiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kaun dien aur ghanta ie sab tjiedj poera hoiga koi na djaane hai. Swarag ke parie logan na djaane hai aur tjaahe ham Parmeswar ke Beta baatie, ham bhie na djaaniela. Khaalie Pieta Parmeswar djaane hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Djaise Noah ke tem me bhail raha, oisane hoiga djab iensaan ke Beta lautke aaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Doenia doebe se pahiele djab talak Noah djahaadj me na gail manai logan khaat piejat raha aur biaah karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Oesabke koetjh andaadj na mielal. Ohie se oesab paanie me doebal. Aur djab iensaan ke Beta lautke aaiga tab aisane hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Oe tem par doei djane sanghe khet me rahiega, tab ekgo ledjaawal djaaiga aur ekwa tjhor dewal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aur doei aurat djaata se perat rahiega, tab ekgo ledjaawal djaaiga, bakie ekwa tjhoet djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Toelog na djaane hai kaun dien toelogke Prabhoe aaiga. Ohie se toelogke tjaahie tajaar rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Toelog samdjhe hai kie djab ek ghar ke maaliek djaanat kie tjor kai badje aaiga, tab oe djaagke aapan ghar ke rakhwaala karat aur tjorie na hoi paawat. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aisane iensaan ke Beta bhie aaiga djab koi na sotjie. Ohie se toelogke tjaahie tajaar rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Oe tem me dekhaaiga kekar oeppar bharosa kar sake hai, aur ke djaise ek bharosaadaar aur samadjhdaar goelaam rahiega djaun ke maaliek doesar naukar log ke barkwa banaais raha oesabke tem par khaaik dewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tab djab maaliek aaike oke kaam karat dekhiega, tab goelaam soekhie rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aur ham toelogse satj boliela kie maaliek aapan sab dhan-daulat okar haath me saup dei. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bakie maan le kie goelaam kharaab aadmie hai. Tab oe aapan man me sotje hai: ");
INSERT INTO hnsNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Hamaar maaliek abbe na lautke aai.’ Tab oe soeroe karie doesarkwan ke sataawe ke aur piejekkar ke saath khaai pieje ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tab atjakke me okar maaliek laut aai djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bas maaliek oke khoeb marwaaike oe djagaha me khader deiga djaaha dhokhaabaadj log ke djaai ke parie. Hoewa par oe daat pieske roiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Oe tem me swarag ke raadj dekhaaiga djaise das larkie djaun aapan aapan tjieraag leike gail doelaha se aadha rasta par bhet kare. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Oman se paatjgo bhoettjar raha aur paatjgo samadjhdaar raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bhoettjar larkie log tjieraag tel se bharke legail, bakie aur besie na leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bakie samadjhdaar waalan tjieraag bharke aur ek bartan me bhie koetjh tel leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Doelaha ke agorat derie howe lagal, tab sabhan ke onghaai lagal aur sab soet gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tab bietj raat me aawaadj soenaail kie: ‘Dekh! Doelaha aawe hai! Dja ose bhet kar!’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tab sab larkie oethke aapan aapan tjieraag ke samhaare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tab bhoettjar larkie log samadjhdaar waalan se bolies kie: ‘Aapan tel me se hamahoelogke de. Hamlogke tjieraag boete hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bakie oesab bolies: ‘Na, tab hamlogke na atiega. Bestar toelog doekaan me djaaike kien le.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tab djab oesab tel gail kiene tab etane me doelaha aai gail. Aur dje dje tajaar raha, oelog okar saath nauta ke ghar me gail, aur kamaarie band hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Koetjh der me bhoettjar larkie log bhie pahoetjal aur bolaais: ‘Bhaai! He bhaai djie! Hamlogke khaat khol deihe!’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bakie doelaha bolies: ‘Ham satj boliela kie ham toelogke na tjienhiela.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aur Jiesoe bolies kie: „Toelog na djaane hai kie ham kaun dien kie to raat ke lautke aabe. Ohie se tajaar rahoe. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Parmeswar ke raadj bhie hai djaise ek aadmie djaun doesar des djaai se pahiele aapan goelaam log ke bolaaike aapan dhan saup deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ekgo ke oe paatj hadjaar mohar deis, doesarkwa ke doei hadjaar aur tiesara ke ek hadjaar. Djetana oesab samhaar paawat, otane deike oe doesar des tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Djaun ke paatj hadjaar mohar mielal raha, oe toerant paisa leike opar doegana kamaai leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Djaun ke doeigo mielal raha, ohoe djaaike aisane doegana kamaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bakie djaun ke ek mohar mielal raha, oe djaaike djamien khodke aapan maaliek ke paisa loekwa deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tab dher dien baad oelogke maaliek lautke aail aur iesabse lekha lewe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Aur oe naukar djaun paatj hadjaar mohar paais raha, oe aaike auro paatj hadjaar liaail aur bolies: ‘Bhaai djie, toe hamme paatj hadjaar mohar sauple rahiele. Dekh, ham ose doegana kamailie hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tab maaliek bolies: ‘Toe bahoet barhia karle. Toe ek attjha aur iemaandaar goelaam baate. Thora par toe bharosaadaar rahiele, ohie se ham tor oeppar dher saupab. Aaw hamaar hia nauta kar.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tab djaun ke doei hadjaar mohar mielal raha, oe aaike bolies: ‘Bhaai djie, toe hamme doei hadjaar mohar sauple rahiele. Dekh, ham ose doegana kamailie hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tab maaliek bolies: ‘Toe bahoet barhia karle. Toe ek attjha aur iemaandaar goelaam baate. Thora par toe bharosaadaar rahiele, ohie se ham tor oeppar dher saupab. Toe bhie aaw nauta kare.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ab djaun ek hadjaar mohar paais raha, oe bhie aail aur bolies: ‘Bhaai djie, ham djaaniela kie toe daajaaloe na baate. Toe kaate hai djaaha toe na boile hai aur toe batore hai djaaha par toe na tjhietle hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ohie se ham dar ke maare djaaike tor paisa djamien me gaar deilie. Le aapan paisa.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tab maaliek bolies: ‘Toe kharaab aur leskatta baate! Toe djaanat rahiele kie ham kaatiela djaaha par ham na boilie hai, aur batoriela djaaha par ham na tjhietlie hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tab toke tjaahat raha hamaar paisa kardja dewe waala ke paas ledjaai ke. Tab ham aaike aapan paisa aur okar biaadj niekaar leitie.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Oe aapan doesar naukar log se bolies: ‘Okar paisa tjhien le aur oe aadmie ke dei de djaun ke das hadjaar mohar hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dje ke koetjh hai aur thiek se kaam me laawe hai, oke tjhappar phaarke rahie. Bakie dje aapan mielal tjiedj se koetjh na kare hai, ose ohoe tjhienaai djaaiga djaun okar hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aur ie be-kaamiel goelaam ke bahare andhiaar me kar de. Hoewa par oe daat pieske khaalie roiga.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Djab iensaan ke Beta aapan mahiemma me aapan parie log ke saath aaiga, tab oe aapan raadja ke gaddie par baithiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aur doenia ke djaatie okare aage ekattha karal djaaiga. Tab djaise ek tjaraawe waala bhera aur khasie alag alag kare hai, oisane iensaan ke Beta sab djaatie se kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Oe bhera log ke aapan dahiena bagal kariega aur khasie log ke aapan baawa bagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tab oe dahiena kait waalan se boliega: ‘Hamaar Pieta toelogke aasier-baat deis hai. Aaw hamaar saath okar raadj me bhaag le. Ie to doenia ke soeroe se toelogke khaatien tajaar karal gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Djab ham bhoekhaail rahielie tab toelog hamme khaaik deile. Ham piaasal rahielie aur toelog hamme piaile. Ham ek pardesie rahielie aur toelog hamme thiekaana deile rahiele. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ek dien hamke kapra na raha, tab toelog hamme kapra deile. Ham bemaar rahielie aur toelog hamme aile dekhe. Ham djahal me rahielie aur toelog hamaar paas aile.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tab attjha waalan poetjhiega: ‘Prabhoe djie, hamlog toke kab bhoekhaail dekhlie aur khaaik deilie, kie to piaasal dekhlie aur piailie? ");
INSERT INTO hnsNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hamlog kab toke ek pardesie ghat dekhlie aur thiekaana deilie, kie to be-kapra ke aur toke kapra pahienailie? ");
INSERT INTO hnsNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hamlog toke kab bemaar kie to djahal me dekhlie aur tore paas ailie?’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tab oe boliega: ‘Ham toelogse satj boliela kie aise toelog hamaar tjaahe djaun sab se tjhota bhaai ke khaat karle hai, toe hamaar khaat karle hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aur kharaab waalan se oe boliega: ‘Hamaar lage se tjal dja. Toelog saraapal gaile baate. Dja aagie me djaun kabhie na boetiega aur saitaan aur okar parie log ke khaat tajaar karal gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ham bhoekhaail rahielie bakie toelog hamme khaaik na deile. Aur ham piaasal rahielie bakie toelog hamme na piaile. ");
INSERT INTO hnsNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ham ek pardesie rahielie bakie toelog hamme thiekaana na deile. Ham be-kapra ke rahielie bakie toelog hamme kapra na pahienaile. Ham bemaar aur djahal me rahielie bakie toelog hamme na aile dekhe.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tab ohoelog poetjhiega: ‘Prabhoe djie, hamlog toke kab bhoekhaail kie to piaasal, ek pardesie ghat, be-kapra ke, bemaar, kie to djahal me dekhlie aur tor sewa na karlie?’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tab oe oelogke djabaab deiga kie: ‘Ham toelogse satj boliela kie djab toelog hamaar sab se nietja waala bhaai-bahien ke sewa na karle, tab toelog hamaar khaat bhie na karle hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aur ielog sada ke lieje sadja paaiga. Bakie attjha waalan hardam khaatien Parmeswar ke saath djaai rahe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Djab Jiesoe ie sab baat bol tjoekal raha tab aapan tjela log se bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","„Toelog djaane hai kie doei rodj baad Paasan ke tiewhaar hai. Tab iensaan ke Beta saup dewal djaaiga kroes par maar dhaare khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Etane me barka agwan aur Israel ke barkwan sab se barka agwa Kaajaafas ke mahal me ekattha bhail. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Oesab baat-tjiet karat raha kaise Jiesoe ke tjalaakie se pakarwaaike maar dhaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Oelog bolies: „Bakie hamlog oke tiewhaar me na maar dharwaawe k'hoi, nahie to sahar me haltjal-matj djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Djab Jiesoe Betaania gaaw me raha tab oe ek aadmie ke ghare gail djaun korhie ke bemaarie se attjha hoi gail raha. Oe aadmie ke naam Siemon raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tab bhodjan karte me ek aurat aaike ek alabastar ke botal bahoet mahanga mahake waala tel leike aur sab tel Jiesoe ke moerie par oedjhiel deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tab tjela log ie dekhke bahoet goessaaike poetjhies: „Aisan naksaanie se kaun bhalaai hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ie mahakauwa mahanga me betjke garieb logan ke dewal djaai sakat.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bakie Jiesoe ie soenke bolies: „Toelog ekare oeppar kaahe ke bhoen-bhoena hai? Oe hamaar khaat ek bahoet barhia kaam karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Garieb logan hardam toelogke paas rahiega, bakie ham toelogke paas sada na rahab. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ie aurat mahake waala tel hamaar oeppar oedjhielke hamaar dehie mattie dewe khaatien tajaar kar deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ham toelogse satj boliela kie djab doenia ke tjaaro or ie khoes khabar partjaar karal djaaiga, tab ie aurat ke baare me bhie bataawal djaaiga kie oe kaun bhala kaam karies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tab baara tjela log me se ekgo oethke tjal gail barka agwan ke paas. Okar naam Joedaas Eskaariot raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Oe hoewa par djaaike bolies: „Djab ham Jiesoe ke toelogke haath me saup debe, tab toelog hamme ka deihe?” Tab oelog oke ties tjaanie ke paisa deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Oe tem se oe mauka khodje lagal oke oesabke haath me saup dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Biena-khatta-piesaan-ke-bret ke tiewhaar se ek rodj pahiele tjela log Jiesoe ke paas aaike poetjhies: „Hamlog tor khaatien Paasan ke bhodjan kaaha tajaar karie?” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tab oe bolies: „Sahar me dja aisan-aisan manai ke paas aur ose bol de: ‘Maastar bolies hai kie: Hamaar tem aai gail hai. Ham tor hia aapan tjela log ke saath Paasan ke tiewhaar manaabe.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Djaise Jiesoe hoekoem deis raha oisane tjela log djaaike tiewhaar ke bhodjan tajaar karies. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Djab raat bhail tab Jiesoe aapan baara tjela log ke saath bhodjan karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Khaite me oe bolies: „Ham satj boliela kie toelog me se ekgo hamke tjoegalie kar deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tab sabhan bahoet oedaas hoike har ek poetjhe lagal kie: „Maastar djie, ham to na baatie?” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tab oe bolies kie: „Ek manai djaun aapan bret hamaar saath ie kobba me bore hai, ohie hamke tjoegalie kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iensaan ke Beta mariega djaise okar baare me Parmeswar ke poestak me liekhal hai. Bakie haai oe aadmie ke dje oke pakarwaaiga. Oe manai khaat bestar rahat kie oe kabhie na paida howat.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tab Joedaas djaun Jiesoe ke tjoegalie karat, oe poetjhies: „Maastar djie, toe hamme to na bolle hai?” Tab oe bolies: „Toe apane bolle hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tab khaite me Jiesoe ek bret leike Parmeswar se praatna karke oke dhanbaad deis. Tab oe bret toekkara toekkara toerke tjela log ke deis aur bolies: „Le, khaai le, ie hamaar dehie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aisane oe ek gielaas wien leike Parmeswar ke dhanbaad deike tjela log ke deis aur bolies: „Sab koi eman se pie le. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ie hamaar khoen hai. Paap ke tjhama dewe khaatien hamaar khoen bahiega, aur aise Parmeswar ke waada poera hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Soen, ab se ham tanko wien na piebe djab talak ham aapan Pieta ke raadj me toelogke sanghe naawa wien piebe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tab sabhan Parmeswar ke aadar kare khaat Paasan ke gaana gaais, tab hoewa se Djaitoen pahaar lage tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Djaite me Jiesoe aapan tjela log se bolies: „Parmeswar ke poestak me liekhal hai kie: ‘Ham bhera tjaraawe waala ke maarab aur sab bhera tjaaro or bhaag djaaiga.’ Ohie se ham djaaniela kie aadj raat ke toelog sab koi hamme tjhorke bhaag djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bakie djab ham djie oethaawal djaab, tab ham toelogse pahiele Gaalielea ke diehaat me tjal djaabe. Hoewa par hamlogke phier se bhet hoiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tab Petras bolies: „Tjaahe sab koi toke tjhorke bhaag djaai, ham kabhie na bhaagab.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Bakie oe bolies: „Ham djaaniela kie ehie raat ke moerga ke bole se pahiele toe tien dafe djhoeth boliehe kie toe hamme na djaane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tab Petras bolies: „Tjaahe hamke tor saath mare ke parie, tabbo ham kabhie na bolab kie: ‘Ham oke na djaaniela.’ ” Aisane ekwan bhie bolat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tab Jiesoe aapan tjela log ke saath ek Getsemaane naam ke djagaha gail. Hoewa par oe bolies: „Toelog hia par baith. Ham thora doer par djaaila praatna kare.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Oe Petras aur Sebedeas ke doei betwan ke legail. Oe tem par oke oedaasie tjhaai leis aur oe ghabaraai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tab oelogse bolies: „Hamme bahoet dar lage hai. Toelog hia par hamaar saath djagte rahoe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tab oe thora aage djaaike moeh ke bhale djamien par gierke praatna kare lagal aur bolies: „He Pieta djie, djab hoi sakie tab ie doekh hamse hataai de. Tabbo na hamaar hiettjha bakie aapke hiettjha poera howe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tab oe gail aapan tieno tjela ke paas aur oelogke soetal paais. Tab oe Petras se bolies: „Toelog hamaar saath ek ghanta na djaag sake hai? ");
INSERT INTO hnsNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Djaag aur praatna kar, nahie to toelog bahakaawal djaihe. Aatma tajaar hai bakie dehie latjaar hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tab oe doesara dafe djaaike praatna karke bolies kie: „He Pieta djie, djab ie doekh na hat sakie tab aise howe djaise aapke attjha lage hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tab oe phien se lautke aail aapan tien tjela log ke paas aur oesabke phien soetal paais. Oesabke bahoet onghaai lagal raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tab oesabke tjhorke oe tiesara dafe gail praatna kare aur ohie sab baat bolies. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tab ant me oe laut aail aur bolies: „Attjha, ab toelog soet aur soestaai sake hai. Dekh, ab tem aai gail hai kie kharaab log iensaan ke Beta ke pakariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Oeth, aaw tjalie. Dekh, tjoegalie kare waala aawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Abbe oe batiaite raha tab Joedaas aai gail djaun baara tjela me ke raha. Aur okar saath ek djhoend mardaana aail talwaar aur danda leike. Oesabke barka agwan aur dharam ke barkwan pathaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Joedaas oe djhoend se bolies raha kie: „Dje ke ham gale lagaab, ohie Jiesoe hai. Ohieke toelog pakariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tab oe toerant Jiesoe ke lage gail aur bolies: „Maastar djie, toe kaise baate?” Aur aapan gale lagaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Bakie Jiesoe bolies: „Bhaija, toe ka kare aile hai?” Tab sabhan aage barhke oke pakar leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ohie laage ek Jiesoe ke tjela aapan talwaar niekaaries aur sab se barka agwa ke goelaam ke kaan kaatke niekaar deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tab Jiesoe bolies: „Aapan talwaar okar djagaha par dhar de. Dje talwaar kaam me laaiga, oe talwaar dwaara mariega. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka, toe sotje hai kie ham aapan Baap se sahaaita na maang sakiela? Djab ham ose poetjhtie tab oe djoerte hamaar khaat baara laakh se djaada parie log pathaai dewat. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tab Parmeswar ke liekhal baat kaise poera hoi?” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aur oe djhoend se bolies kie: „Toelog talwaar aur laathie leike aile hai hamme djaise daakoe pakare. Rodj-nieth ham Parmeswar ke mahal ke angana me siekhaawat rahielie, tabbo toelog hamme na pakarle. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bakie ie sab howe ke tjaahie djeme Parmeswar ke sanesian ke liekhal baat poera howe.” Tab sab tjela Jiesoe ke akele tjhorke bhaag gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Djaun log Jiesoe ke pakaries raha, oesab oke Kaajaafas ke ghare legail. Oe sab se barka agwa raha. Hoewa par dharam ke parhal waalan aur doesar barkwan ekattha bhail raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aur Petras doerie se Jiesoe ke pietjhe pietjhe gail sab se barka agwa ke angana me. Tab oe hoewa djaaike naukar log ke bietj me baithal dekhe khaatien kaise sab bietiega. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tab barka agwan aur sabha bhar kausies karies doei aadmie paawe ke djaun Jiesoe ke baare me ekahie djhoeth gawaahie dewat. Aise oelog oke marwaai sakat. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bakie tjaahe dher djhoettha gawaahia raha, tabbo oesabhan aisan doei manai na paais. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tab ant me doei djane aail. Oesab bolies kie: „Ie aadmie bolies raha: ‘Ham Parmeswar ke mahal ke toerke tien rodj me phien se bana debe.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tab sab se barka agwa oethke Jiesoe se poetjhies kie: „Toe soene hai iesab tore biese me kaun baat bole hai? Toe djabaab na deihe?” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bakie oe koetjh na bolies. Tab sab se barka agwa bolies: „Toe hamlogke djienda Parmeswar ke aage bata de kie toe Kriest, jaane Parmeswar ke Beta baate kie na.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tab Jiesoe bolies: „Toe to apane bol deile. Aur ham toelogse boliela kie ab se toelog iensaan ke Beta maahaan waala Parmeswar ke dahiena bagal baithal aur baadar par aawat dekhiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tab sab se barka agwa ie baat soenke goessa ke maare aapan kapra tjier-phaar deis aur djor se bolies: „Ab kaun gawaahie ke djaroerie hai? Toelog soenle hai kie oe kaise Parmeswar ke bedjatie karies. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Toelog ka bole hai?” Tab oesabhan bolies: „Ie to maut ke laaik hai!” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tab oelog Jiesoe ke moeh par thoek deis aur oke maare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Koetjh log okar moeh par maaries aur bolies: „Ab bata de toke ke maaries hai aur dekhaaw kie toe Kriest baate.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petras angana me baithal raha. Tab okar paas ek goelaam aurat aaike bolies: „Tohoe to Jiesoe Gaalielea Waala ke saath rahiele.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bakie oe bolies: „Na, ham na djaaniela kie toe ka bole hai.” Aur sab koi soenies kie oe ka bolies. ");
INSERT INTO hnsNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tab oe dwaar ke alang se djaai lagal. Bakie hoewa par ek doesar goelaam aurat oke dekhies aur sab aas-paas ke manai log se bol deis: „Ie Jiesoe Naasaaret Waala ke sanghe raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tab oe phien se bolies: „Ham kasam khaaila kie ham oke na djaaniela.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Thore der me koetjh log djaun hoewa raha, oesab Petras ke paas djaaike bolies: „Toe sattje ke okar tjela me ke baate. Tor bolie toke pakarwaai deis.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tab oe apane ke saraape lagal aur kasam khaaike bolies kie: „Oe adamia ke ham na djaaniela.” ");
INSERT INTO hnsNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tab ohie laage ek moerga bole lagal. Tab Petras ke jaad bhail kie Jiesoe bolies raha: „Ham djaaniela kie moerga bole se pahiele toe tien dafe boliehe kie toe hamke na djaane hai.” Tab oe bahare djaaike khoeb rowe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sabere sabere sab barka agwan aur djanta ke barkwan Jiesoe ke baare me sallaah karies kie oke tjaahie maar dhaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tab sabhan oke banhwaaike ledjaaike Pielaatas ke haath me saup deis. Pielaatas Roma ke maahaaraadja ke laat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tab Joedaas djaun Jiesoe ke tjoegalie karies raha, djab oe dekhies kie Jiesoe maut ke sadja paais hai tab oe pastaai lagal. Aur oe ties tjaanie ke paisa ke barka agwan aur doesar barkwan ke gail lautaare. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Oe bolies: „Ham paap karlie. Ham ek be-kasoerie ke tjoegalie karlie hai.” Tab oesab bolies: „Ose hamlogse koetjh kaam na hai. Toe apane djaan.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tab Joedaas tjaanie ke paisa Parmeswar ke mahal ke angana me phek deis aur djaaike phaasie laga leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tab barka agwa log paiswa ke batories aur bolies: „Ie khoen ke paisa hai. Ie hamlog Parmeswar ke daan na dei sakiela.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aur oesab sallaah karke oe paisa se ek pandohie ke djamien kienies pardesie log ke mattie dewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ohie se aadj talak oe djamien „‘khoen ke djamien”’ bolaawal dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ie rakam Parmeswar ke sanesia Jeremia ke baat poera bhail. Oe dher dien pahiele bolies raha kie: „Oesab ties tjaanie ke paisa leis, djetana Israel log oke taharaais, ");
INSERT INTO hnsNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aur ese pandohie ke djamien kienies. Aisane Prabhoe hamse bolies raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tab oesab Jiesoe ke leike laat ke aage legail. Tab laat ose poetjhies: „Toe Israel logan ke Raadja baate?” Tab oe bolies: „Toe apane bolle hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tab barka agwan aur djaatie ke barkwan oke kasoer dewe lagal, bakie oe ekko djabaab na deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tab laat bolies: „Toe na soene hai kie iesab tore biese me ka bole hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bakie oe koetjh na bolies. Tab laat bahoet atjambho bhail. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Har Paasan ke tiewhaar par laat ek djahalia ke tjhorat raha dje ke djanta maangat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oe samai hoewa ek bahoet kharaab aadmie djahal me raha. Okar naam Baaraabaas raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hoewa dher manai djoetal raha, ohie se laat sabhan se poetjhies kie: „Toelog kaun waala ke maange hai kie ham tjhorie? Baaraabaas ke kie Jiesoe ke, djaun Kriest bolaawal dja hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Oe djaanat raha kie Israel ke barkwan Jiesoe ke djaran ke maare pakarwaai deis raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ohie same par djab laat faisala karat raha, tab okar aurat okar paas ek sanesa pathaais. Oe bolies kie: „Ie be-kasoerie ke koetjh na kariehe. Aadj ham ek sapana me okare khaat bahoet doekh oethailie.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Etane me barka agwan aur barkwan sab manai log se bol deis kie: „Toelog boliehe: ‘Baaraabaas ke tjhor de aur Jiesoe ke marwaai dhaar.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tab laat oesabse phien se poetjhies: „Ie doeno me se toelog maange hai kie ham ke ke tjhorie?” Tab sabhan bolies: „Baaraabaas ke!” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tab laat poetjhies: „Tab ham Jiesoe se ka karie djaun Kriest bolaawal dja hai?” Tab sabhan ek moeh hoike bolies: „Oke kroes par tjaharaai de!” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tab oe poetjhies: „Oe kaun kharaabie karies hai?” Tab sabhan auro tjiellaaike bolies kie: „Oke kroes par tjaharaai de!” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Djab laat dekhies kie ie rakam se oe koetjh na kar sake hai aur djanta log auro haltjal matjaawe hai, tab oe paanie leike sab koi ke aage aapan haath dhoi leis aapan be-kasoer dekhaawe khaat. Oe bolies: „Ie aadmie ke maut hamaar kasoer na hai. Toelog apane djaniehe ka hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tab sab djanta bolies kie: „Ekar maut ke kasoer hamlogke aur hamlogke aulaad ke oeppar parie.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tab oe Baaraabaas ke tjhor deis aur Jiesoe ke pietwaaike soerdjaatie ke haath me saup deis kroes par tjaharaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tab Roma ke soerdjaatie log Jiesoe ke laat ke mahal me legail aur sab doesar soerdjaatie ke bhie bolaais. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tab sabhan okar kapra oetaarke aur oke ek laal kapra pahienaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tab sabhan ek kaata waala lattie goethke okar moerie par dharies aur okar dahiena haath me ek danda pakaraai deis. Tab oesab okar aage aapan gaathie par gierke thatha oeraawe lagal aur bolies: „He Israel ke Raadja, aap kaise rahiele?” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tab oesab okar oeppar thoek deis aur danda tjhienke okar moerie par maaries. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tab oesab oe laal kapra niekaar leis aur okar kapra phien pahienaaike oke legail kroes par tjaharaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Rasta par oesabke ek Sierene des ke aadmie bhetaail. Okar naam Siemon raha. Tab oesab oke djabar-djastie se kroes ke khambha deis ledjaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aisane oesab ek djagaha par pahoetjal djaun ke naam Golgota raha. Ekar matlab „‘Khoprie ke djagaha”’ hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tab oesab wien me koetjh bieta dawaai mielaaike Jiesoe ke deis pieje ke, bakie oe tjiekhke tjhor deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tab oelog oke tjaharaaike khiella se kroes par thok deis aur okar kapra djoewa khelke baat leis. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aur hoewa baithke oesab okar rakhwaala kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Okar moerie ke oeppar liekhal raha kie oe kaahe khaat kroes ke sadja paais raha. Oesab liekhies raha kie: IE ISRAEL KE RAADJA JIESOE HAI. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tab Jiesoe ke doeno bagal doei daakoe bhie ek ek kroes par tjaharaawal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aur djetana log hoewa se paas howat raha Jiesoe ke bedjatie karat raha, aur moerie hielaaike bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","„Toe to Parmeswar ke mahal toerke tien rodj me banaai deite? Djab toe Parmeswar ke Beta baate tab apane ke batjaai le aur kroes par se oetar aaw.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aisane barka agwan, dharam ke parhal waalan aur djaatie ke barkwan mielke okar thatha oeraawat raha aur bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","„Oe doesar log ke batjaais raha, bakie apane ke na batjaai paawe hai. Djab oe Israel ke Raadja hai tab oke tjaahie ab kroes par se oetare ke. Tab hamlog okar oeppar bieswaas karab. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ie aapan bharosa Parmeswar par rakhies hai. Djab oe eke tjaahe hai tab oke tjaahie eke batjaai lewe ke. Oe to bolies hai kie: ‘Ham Parmeswar ke Beta baatie.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ehie rakam oe doei daakoe bhie okar thatha oeraawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tab baara badje se tien badje talak des bhar me ekdam andhiaar hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tab lagbhag tien badje Jiesoe djor se bolies: „Elie, Elie, laama saabaktaanie?” Ekar matlab hai: „Hamaar Parmeswar, hamaar Parmeswar, toe hamme kaahe ke tjhor deile hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tab koetjh hoewa ke manai log ie soenke bolies: „Oe Elia ke bolaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tab ek aadmie toerante djaaike koetjh khatta wien me bhiedjaaike ek daarhie me bhokke oke deis tjoese ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bakie ekwan bolies: „Agor! Dekhie dja kie Elia aawe hai oke batjaawe kie na.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bas Jiesoe phien se djor se tjiellaais aur aapan praan tjhor deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aur dekh, ohie tem par Parmeswar ke mahal ke pawietr djagaha ke parda oeppar se nietje talak phat gail, dhartie hiele lagal, aur barka patthar phate lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aur koetjh kabar khoel gail aur dher bieswaasie maral log djie oethal. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aur djab Jiesoe djie oeth gail raha tab oesab kabar me se niekarke Jeroesaalem me gail aur hoewa par dher manai log oesabke dekhies. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Djab rakhwaala log aur oelogke barkwa bhoeidol dekhies aur ka ka bhail, tab oesab bahoet ghabaraai gail aur bolies: „Ie aadmie satj-moetj Parmeswar ke ek Beta raha!” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hoewa par bhie dher aurat log raha. Oesab doerie se thara hoike taakat raha ka howe hai. Iesab Gaalielea ke diehaat se Jiesoe ke sanghe aail raha okar sewa kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Eman Magdaala sahar ke Maria aur Jaakobas aur Josaf ke maai Maria raha, aur Jaakobas aur Johaanas ke maai bhie. Oe Sebedeas ke aurat hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sandjha ke ek dhanie aadmie aail. Oe Aariematea sahar me rahat raha aur okar naam Josaf raha. Oe bhie Jiesoe ke tjela hoi gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tab oe laat ke paas gail aur Jiesoe ke lahaas maangies. Tab laat hoekoem deis oke dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tab Josaf lahaas leike ek safa sapet kapphan me lapetke ");
INSERT INTO hnsNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ek naawa kabar me rakh deis. Oe kabar apane khaat pahaar me banwaais raha. Tab oe ek barka patthar kabar ke dwaar ke aage dhakelke aur tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aur Magdaala ke Maria aur ekwa Maria kabar ke aage baithal raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Biehaan bhaile, tiewhaar tajaar kare ke dien ke baad barka agwan aur Fariesie log sanghe laat ke paas gail aur bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","„Laat djie, hamlogke jaad hai kie oe bharmaawe waala aadmie bolies raha kie: ‘Ham tien dien ke baad djie oethab.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Toe hoekoem dei sakiehe kie okar kabar tien dien talak taala karke rakhwaala karal djaai? Nahie to okar tjela log aaike okar lahaas ke tjoraai lei aur djanta se bolie kie: ‘Oe maut me se djie oethal hai.’ Aur ie dhokha pahiela waala se auro kharaab hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tab laat bolies: „Ie rakhwaala log ke leike dja aur kabar ke taala kar djaise toelog maange hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Oesab djaaike kabar me taala lagaais aur soerdjaatie ke dhar deis rakhwaala kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat ke dien ke baad djab hapta ke pahiela rodj bhail tab Magdaala ke Maria aur ekwa Maria gail kabar ke dekhe. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tab atjakke me ek barka bhoeidol bhail aur Parmeswar ke ek parie swarag me se oetaral. Oe kabar ke paas aaike dwaar ke patthar hataaike opar baith gail. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Okar tjehera djaise biedjalie tjamkat raha aur okar kapra ekdam oeddjar raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tab rakhwaalan etana djor deraail kie hoewa par gier gail djaise ek moerda. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bakie swarag ke parie aurat log se bolies: „Toelog na dera. Ham djaaniela kie toelog Jiesoe ke khodje hai djaun kroes par maral hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Oe hia na hai. Oe djie oethaawal gail hai djaise oe bolies raha. Aaw djagaha ke dekh djaaha okar lahaas rakhal raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aur bolies: „Toelog haalie se djaaike okar tjela log se bol de kie oe maut me se djie oethal hai. Aur oe toelogke aage Gaalielea ke diehaat me djaaike toelogse bhet kariega. Ehie sanesa hamme dewe ke raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aurat log toerant hoewa se tjal gail. Oelogke man me dar aur khoesiaalie saathe saath raha. Oesab haalie haalie tjalal Jiesoe ke tjela log se bataawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bas atjakke me Jiesoe apane aaike iesabse bhet karke bolies: „Toelogke sjaantie rahe.” Tab oelog auro nagietj aaike gaathie par gierke okar gor pakar leis aur oke poedje lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tab oe bolies: „Na dera. Dja hamaar bhaai log se bol de kie oelogke tjaahie hia se Gaalielea me djaai ke, tab hoewa oesabse bhet hoiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Djab aurat log tjal gail tab soerdjaatie log sahar me djaaike barka agwa log se sab koetjh bataai deis. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tab barka agwan aur djanta ke barkwan ekattha hoike apane me sallaah karke soerdjaatie ke dher paisa deis ");
INSERT INTO hnsNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aur bolies kie: „Toelog sab koi se boliehe kie: ‘Raat ke djab hamlog soetal rahielie tab okar tjela log aaike okar lahaas tjoraai legail.’ ");
INSERT INTO hnsNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aur djab laat ie baat soeniega tab hamlog ose ie baat thiek kar leb djeme toelogke sadja na miele.” ");
INSERT INTO hnsNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soerdjaatie log paisa leike karies djaise oelogse bolal gail raha. Aur ie djhoeth baat aadj talak Israel logan ke bietj me phailaawal dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tab gjaara tjela log Gaalielea ke diehaat me oe pahaar par gail djaaha Jiesoe oelogke bolaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tab djab oesab hoewa par oke dekhies tab gaathie par gierke oke poedje lagal. Bakie kauno kauno ke man me doebdha raha. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tab Jiesoe nagietj aaike bolies: „Pieta Parmeswar hamme swarag me aur dhartie par sab saktie deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ohie se toelog dja aur doenia ke sab djaatie ke hamaar tjela banaaw. Oesabke dopoe kar Pieta Parmeswar ke, okar Beta ke aur Pawietr Aatma ke naam me. Aur oesabke har ek baat siekhaaw djaun ham toelogke hoekoem deilie hai kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aur soen, ham djoeg ke ant talak rodj toelogke saath rahab.”");
INSERT INTO hnsNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ie poestak me khoes khabar Jiesoe Kriest ke biese me liekhal hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Parmeswar ke sanesia Jasaaja ke poestak me liekhal hai kaise Pieta Parmeswar koi ke biese me aapan Betwa se bolies kie: „Dekh, oe hamaar sanesia hai. Eke ham tor aage pathaaila manai logan ke diel tore khaatien tajaar kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Soen! Koi maidaan me gohoraawe hai: ‘Prabhoe khaat rasta tajaar aur sodjha kar kie oe opar aai sake.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aisane Johaanas maidaan me partjaar karat raha aur manai log se bolies: „Aapan paap pastaaw aur kharaabie tjhor de. Tab Parmeswar toke tjhama deiga. Aur apane ke dopoe karwaai le.” Tab oe manai log ke dopoe karies. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Joedea diehaat ke sab djanta log Johaanas ke lage tjalat djaat raha, aur Jeroesaalem sahar ke log bhie. Oesab aapan sab kharaabie bataais, tab Jordaan ke nadie me dopoe leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johaanas oet ke rowa ke kapra pahienat raha, aur okar karhiaaw me ek tjamra ke tjamotie lagal raha. Oe phatienga khaat raha aur djangalie baraija ke madh tjaatat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Oe ailaan karat raha kie: „Koetjh dien baad ek doesar aadmie aaiga. Aur oe hamse bahoet barka hai. Ham okar laaik na baatie kie ham niehoerke okar djoeta kholab. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ham toelogke paanie se dopoe kariela, bakie oe toelogke Pawietr Aatma se dopoe kariega.” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ohie tem par Jiesoe Naasaaret sahar Gaalielea diehaat me se hoewa bhie aail. Tab oe Jordaan nadie me apane ke Johaanas se dopoe leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Djaise oe paanie me se niekaral, taise oe dekhies kie swarag khoel gail aur Parmeswar ke Aatma kaboettar ke roep me nietje aaike okare oeppar baith gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tab swarag me se ekgo aawaadj soenaail aur koi bolies: „Toe hamaar pjaara Beta baate, toe hamme bahoet parsand howe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tab Parmeswar ke Aatma toerant oke hoewa se maidaan me legail. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aur hoewa par oe tjaalies rodj raha. Oe tem par saitaan oke adjmaawat raha. Jiesoe maidaan ke djanaawar log ke bietj me rahat raha aur swarag ke parie log aaike okar sewa karat raha. Tab oe hoewa se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ekare baad djab Johaanas dopoe kare waala pakaraail raha, tab Jiesoe Gaalielea diehaat me lautke gail Parmeswar ke khoes khabar partjaar kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Oe bolies: „Tem aai gail hai kie Parmeswar soeroe kariega raadj tjalaawe ke. Aapan kharaab djiewan badal de aur ie khoes khabar bieswaas kar.” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ek rodj oe Gaalielea ke samoendar ke kienaare kienaare djaat raha. Tab oe dekhies kaise doei matjhar marwan paanie me thara hoike aapan djaal samoendar me biege hai. Oesab bhaai bhaai raha aur oelogke naam Siemon aur Andreas raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tab Jiesoe oe doeno se bolies: „Aaw tjal hamaar saath. Ham toelogke siekhaabe ek doesar rakam matjharie pakare ke. Ham toelogke dekhaabe kaise Parmeswar khaat manai log ke djiete ke, djeme oesab ose ek hoi djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bas toerant oesab aapan djaal tjhor deis aur okar saathe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tab djab oesab koetjh doer gail, tab oe phien doeigo matjhar marwan ke dekhies. Oesabke naam Johaanas aur Jaakobas raha aur oelogke baap Sebedeas raha. Oesab bot me djaal setiaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Djaise Jiesoe oesabke dekhies, taise oe doeno ke bhie bolaais. Tab oelog toerant okar sanghe tjal gail aur oelogke baap aur kamkartan bot me rahie gail. Oe doeno bhie maangat raha Jiesoe ke tjela howe. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tab sabhan Kaapernaum sahar me pahoetjal. Tab djaise sabat ke dien bhail, taise Jiesoe partjaar ke ghar me gail aur hoewa par Parmeswar ke baat siekhaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Manai log hardam soenat raha kaise dharam ke parhal waalan biena hoekoem se siekhaawat raha. Bakie Jiesoe hoekoem se partjaar karat raha. Ohie khaatien sab manai log okar siektjha soenke atjambho hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Oe tem par partjaar ke ghar me ekgo aadmie raha djaun ke bhoet pakaries raha. Tab oe tjiellaaike Jiesoe se bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","„He, Naasaaret ke Jiesoe! Tose aur hamlogse kaun kaam hai? Toe aile hamlog ke naas kare khaatien? Ham djaaniela kie toe ke baate. Toe Parmeswar ke Pawietr Waala baate!” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tab Jiesoe oke daatke bolies: „Tjoep, aur okare me se niekar dja!” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bhoet adamia ke djhakdjhorke aur tjiellaaike okar me se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tab sab manai log bahoet atjambho hoi gail aur apane me batiaai lagal: „Are baapre! Dekhle? Oe ek dafe bolies aur bhoet okar baat soen leis! Oke saktie hai! Aur oe ek naawa rakam se siekhaawe hai!” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Thora dien me Gaalielea diehaat me sagaro phail gail kie Jiesoe ka karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jiesoe aapan tjela log ke sanghe partjaar ke ghar me se niekarke toerant Siemon aur Andreas ke ghare gail. Jaakobas aur Johaanas bhie oelogke sanghe raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hoewa par Siemon ke saas bokhaar me paral raha. Djaise Jiesoe hoewa pahoetjal, taise oesab ose bataais. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tab oe gail okar lage aur okar haath pakarke oke thara karwaais. Tab bokhaar pataai gail aur aurat oesabke sewa kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Oe raat ke djab soeroedj doeb gail raha, tab hoewa ke manai logan dher bemarian ke Jiesoe ke paas legail, aur bhie djaun log ke bhoet-paret pakaries raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sahar bhar ke manai log oe ghar ke dwaar par saamiel hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tab oe dher bemarian ke attjha karies, tjaahe djaun kharaab bemaarie oelogke raha. Oe bhie dher manai log me se bhoet ke bhagaais. Oesab djaanat raha kie oe ke hai, ohie khaat Jiesoe oelogke koetjh na bolan deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Biehaan bhare sabere sabere djab abbe andhiaar raha, tab Jiesoe akele bahare gail praatna kare. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tab thore der baad Siemon aur okar sanghatian gail dekhe kie oe kaaha hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aur djab oke paais tab bolies: „Sab koi toke khodje hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bakie oe bolies: „Aaw tjalie doesar gaaw aur sahar me, tab ham hoewa par Parmeswar ke khoes khabar bhie ailaan kar sakab. Ohie khaatien ham ailie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aisane oe tjaaro or Gaalielea diehaat bhar me djaaike hoewa ke partjaar ke ghar me siekhaawat raha. Aur bhie dher manai log me se bhoet-paret bhagaais. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ek dien ekgo aadmie Jiesoe ke lage gail. Oke korhia ke bemaarie raha. Tab oe Jiesoe ke gor gierke aur bolies: „Djab aap mangieho tab hamke attjha kar sakieho.” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tab Jiesoe oke daaja karke aapan haath barhaaike oke tjhoeis aur bolies: „Ham maangiela kie toe attjha hoi dja!” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aur ohie laage bemaria attjha aur safa hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tab Jiesoe bolies kie: „Koi se na bataihe kie toe kaise attjha bhaile.” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Oe bolies: „Toe ehie laage agwa lage dja aur dekha de kie toe attjha hoi gaile baate. Tab baliedaan karwaihe djaise Mosas liekhies raha kie howe ke tjaahie djab koi korhia ke bemaarie se attjha bhail hai. Tab sab koi dekh sakie kie toe sattje ke attjha hoi gaile hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bakie aadmie djaaike sab koi se ailaan kare lagal kie Jiesoe oke attjha kar deis. Ohie khaatien Jiesoe oe tem se apane ke ekko sahar me na dekhaai sakat raha bakie sahar ke bahare rahat raha. Hoewa par dher manai na rahat raha. Tabbo tjaaro alang se manai log okar paas aawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Oelog phien se laut gail Kaapernaum sahar me. Ekaat rodj baad hoewa ke manai log ke pata miel gail kie Jiesoe aapan ghare aai gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tab oe ghar etana dher aadmie se bhar gail aur manai log bhie bahare talak thara raha kie koi bhiettar na djaai sakat raha. Aur Jiesoe Parmeswar ke baat bataawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tab koetjh aadmie ek loendj ke leike angana me aail. Tjaar aadmie oke tjataai par laais. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Oesab maangat raha oke Jiesoe ke paas ledjaai, bakie dwaar to manai se bharal raha. Ohie se oesab sierhie par se plaata tjhat par gail, tab oesab ek toekkara daakwa niekaaries djaaha Jiesoe raha aur loendj ke tjataai par nietje oetaar deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tab djab Jiesoe dekhies kie oelogke bieswaas ketana barka hai, tab oe loendj se bolies: „Beta, tor paap tjhama hoi gail.” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hoewa par bhie ekaatgo Israel ke dharam ke parhal waalan baithal raha. Tab ie baat soenke oesab sotje lagal kie: ");
INSERT INTO hnsNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","„Oe kaise ie baat bol sake hai? Khaalie Parmeswar to paap ke tjhama kar sake hai. Ie aadmie Parmeswar ke bedjatie kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tab Jiesoe toerant djaan gail kie oesab ka sotjat raha aur bolies: „Toelog kaahe ke aise sotje hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bolies: „Ham ie aadmie se bol sakiela kie: ‘Toke paap ke tjhama miel gail hai,’ aur ham bhie bol sakiela: ‘Oeth aur aapan tjataai leike dja.’ Toelog ka sotje kie kaun tjiedj aur sahadj hai? ");
INSERT INTO hnsNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ham maangiela kie toelog djaan dja kie Parmeswar iensaan ke Beta ke saktie deis hai doenia me paap ke tjhama dewe ke.” Oe loendj se bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","„Ham boliela: oeth aur aapan tjataai leike ghare dja.” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aadmie oethke toerant tjataai leike sab manai ke bietj me se tjal gail. Tab sab koi bahoet atjambho hoi gail aur soeroe karies Parmeswar ke aadar kare ke. Oesab bolies: „Parmeswar ketana maahaan hai! Aisan tjiedj hamlog kabhie na dekhlie rahielie!” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ekare baad Jiesoe sahar tjhorke phien se samoendar ke or gail. Dher aadmie okar sanghe tjalat raha aur oe Parmeswar ke baat bataawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tab oe djoetie bhare ke ghar lage ekgo aadmie ke baithal dekhies. Okar naam Lewie raha aur oe Alfeas ke beta raha. Tab Jiesoe ose bolies: „Aaw tjalie hamaar saath.” Lewie oethke okare sanghe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tab djab Jiesoe aur okar tjela log Lewie ke ghare bhodjan karat raha, tab dher baimaan djoetie ke paisa bharwaawe waalan aur doesar paapie log okar sanghe bhodjan karat raha. Oesab maangat raha Jiesoe ke sanghe rahe. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aur hoewa bhie ekaatgo Parmeswar ke baat ke parhal waalan aail dekhe. Oesab Fariesie ke koel ke raha. Tab djab oesab dekhies Jiesoe kaun rakam aadmie ke sanghe khaai pieje hai, tab okar tjela log se bolies: „Oe kaahe ke aisan kharaab manai log ke saath bhodjan kare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tab Jiesoe soenke bolies: „Ek daaktar tjangga manai log ke na attjha kare hai, bakie bemarian ke. Aisane ham na ailie baatie be-kasoerie log ke apane paas bolaawe khaatien bakie paapie log ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Oe tem par Johaanas dopoe kare waala ke aur bhie Fariesie ke tjela log kabhie kabhie rodja kie bhoekha rahat raha. Tab oelog me se ekaat miela Jiesoe se aail poetjhe: „Johaanas ke aur Fariesie ke tjela log kaahe khaatien rodja kie to bhoekha rahe hai, bakie tor tjela log aise na kare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tab oe bolies: „Djab koi ke biaah howe hai, tab nautaharie thoro bhoekha kie to rodja rahe hai djab talak baraat na dja hai? Djab talak doelaha oesabke sanghe rahie oesab to khoesiaalie manaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bakie ek tem aai kie doelaha tjal djaai, tab oesab oedaasie ke maare rodja kie to bhoekha rahie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Oe samdjhaais kie dharam ke nem aur okar naawa partjaar na sanghe tjal sake hai. Oe bolies: „Koi na ek toekkara naawa kapra poeraana kapra me djore hai, nahie to djab dhowal djaai tab naawa kapra tjahier djaai. Tab poeraana kapra auro phaat djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aur koi na naawa wien poeraana tjamra ke basta me dhare hai, nahie to wien phoel djaai aur basta phat djaai. Tab doeno naksaan hoi djaai. Ohie se naawa wien naawa basta me rakhe ke tjaahie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ekgo sabat ke dien par Jiesoe aur okar tjela log khet ke alang djaat raha. Tab okar tjela log djaite me doei tien lartjha toeries aur oman se bia leike khaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tab koetjh Fariesie log Jiesoe se bolies: „Dekh oesab ka kare hai. Oe kaam sabat ke dien par mienaahie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tab oe bolies: „Toelog to parhle hai Daawied ka karies raha djab oe aur okar saathie log moesiebat me raha. Oesabke bhoekh lagal aur khaaik na raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Oe tem me Abjaatar sab se barka agwa raha. Tab Daawied Parmeswar ke ghar me djaaike pawietr bret paais aur khaai lagal. Aur okar saathie log bhie khaais, tjaahe khaalie agwa logan ie bret khaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Oe bolies: „Parmeswar sabat ke dien manai log khaatien dharies, aur na manai log sabat ke dien khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aur iensaan ke Beta sabat ke dien ke Prabhoe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ek doesar sabat ke dien par Jiesoe phien se partjaar ke ghar me gail. Hoewa par ekgo aadmie raha djekar ek haath na kamaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Koetjh manai log Jiesoe ke oeppar khoeb thiek se aakhie garaawat raha. Oesab maangat raha dekhe kie oe oke sabat ke dien par attjha kare kie na. Djab karat, tab oesab okar oeppar naalies kar sakat. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tab oe aadmie se bolies: „Aaw hia bietj me thara how.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aur oe ekwan se poetjhies kie: „Ka, thiek hai sabat ke dien par bhalaai kare ke kie kharaabie kare ke? Thiek hai ek manai ke batjaawe ke kie maar dhaare ke?” Bakie oesab koetjh na bolies. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Oesabke patthar diel dekhke oe oedaas hoike oesabke goessa me taakies. Tab oe aadmie se bolies: „Aapan haath barhaaw.” Aadmie barhaais, aur okar haath ekdam attjha hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tab Fariesie log hoewa se tjal gail. Oesab toerant raadja Herodes ke manai log ke saath ekattha bhail aur baat-tjiet kare lagal kaise Jiesoe ke marwaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tab Jiesoe aapan tjela log ke leike samoendar lage gail. Aur Gaalielea diehaat ek djhoend manai okar sanghe djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Joedea diehaat, Jeroesaalem sahar, Iedoemea diehaat, Jordaan nadie ke habara se aur Tieras aur Siedon sahar ke galie se dher djane okar barka kaam soenke bhie aail dekhe. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Oe dher bemarian ke attjha karat raha. Aur dher doesar bemarian bhie maangat raha oke tjhoeike tjangga howe. Bahoet thelat-thaalat howat raha kie oesab Jiesoe ke katjar-watjar dewat. Ohie khaatien oe aapan tjela log se bolies: „Hamaar lage ek bot laaw.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aur manai djaun me bhoet log raha, djab oke dekhies tab okar gor gierke tjiellaai lagal kie: „Aap Parmeswar ke Beta baate!” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bakie Jiesoe daatke oelogke doharaaike mienaahie karies kie: „Toelog na bataaw kie ham ke baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ek dien Jiesoe pahaar par gail aur koetjh aadmie tjoenke apane paas bolaais. Aur oesab aail. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tab oe baaraago se bolies pahiele okar sanghe rahe khaatien aur ekare baad oe maangat raha oesabke pathaawe Parmeswar ke baat manai log se bataawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Aur oelogke saktie mielat manai log me se bhoet log ke niekaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Jiesoe baaraago aadmie ke tjoenies. Oesabke naam raha Siemon djaun ke oe bhie Petras bolaawat raha, tab Sebedeas ke betwan Jaakobas aur Johaanas. Jiesoe oe doeno ke Boanerges naam dharaais. Ekar matlab hai: „‘Gardje ke betwan.”’ ");
INSERT INTO hnsNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Tab oe bhie Andreas ke bolaais aur Fielepas, Baartolomeas, Mateas, Tomaas, Alfeas ke beta Jaakobas, Tadeas, Siemon kamaasoet waala aur Joedaas Eskaariot djaun oke tjoegalie karat. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ekare baad Jiesoe ekgo ghar me gail. Tab phien etana dher manai log okare lage aail kie oe aur okar tjela log ke mauka na mielal bret khaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tab djab okar palwaar log ie soenies tab gail oke lewe aur bolies: „Okar moerie kharaab hoi gail.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ekaatgo Israel ke dharam ke parhal waalan Jeroesaalem sahar se aail raha. Aur oesab ie dekhke bolies: „Oke bhoet ke barkwa Bejelsaboel pakaries hai aur oe oke saktie dewe hai oesabke niekaare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bakie Jiesoe oesabke aapan lage bolaais aur ekgo matlab ke kaahaanie se samdjhaawe lagal. Bolies: „Saitaan kaise saitaan log ke niekaar sake hai? ");
INSERT INTO hnsNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Djab ek des me manai log apane me laraai karie, tab oe des na tjaliega. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aur djab ghar ke palwaar apane me djhagara karie, tab ie manai log tjaaro or tjhiettier-biettier hoi djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aisane djab saitaan aur okar saamiel waalan baatal rahat, tab okar raadj na tjalat.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Oe bolies: „Koi na ek djabar manai ke ghar me djaai sakiega okar hiera-motie tjoraawe khaatien. Khaalie dje oe aadmie se djabar hai, oe oke baanhke okar sab tjiedj tjoraai sakie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Oesab Jiesoe ke baare me bolies raha kie: „Okare me bhoet raadj tjalaawe hai.” Ohie se oe bolies: „Ham toelogse satj boliela kie manai log tjaahe djaun kharaabie karie, aur tjaahe djetana Parmeswar ke bedjatie karie, tabbo oesabke paap ke tjhama miel sakie. Bakie dje Pawietr Aatma ke bedjatie karie, oe kabhie paap ke tjhama na paai. Oe Parmeswar ke aage sada ke lieje kasoerwaar rahie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Etane me okar maai aur bhaai log aail. Oesab bahare thara raha aur Jiesoe ke bolwaais. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tab aas-paas ke manai log ose bolies: „Dekh, tor maai aur bhaai-bahien log toke khodje hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tab oe bolies: „Toelog djaane hai hamaar maai aur bhaai-bahien ke hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aur oe ek ek djane ke taakke bolies: „Dekh, hamaar maai aur bhaai-bahien hia hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dje Parmeswar ke baat maane hai, oe djaise hamaar bhaai, bahien aur maai hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ekare baad Jiesoe phieno samoendar ke kienaare Parmeswar ke baat siekhaawe lagal. Aur etana dher manai aail soene kie oe ekgo bot me gail. Aisahie oe bot me baithal raha aur manai log kienaare thara raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Oe matlab ke kaahaanie kaam me leike oesab ke dher tjiedj siekhaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Aisane oe ie kaahaanie kahe lagal kie: „Thiek se soen. Ekgo khetiar raha. Ek rodj oe gail bia tjhiete. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tjhietat me koetjh bia rasta par gier gail aur tjierai aaike khaai leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tab koetjh bia gier paral djaaha thora se mattie aur nietje patthar raha. Hoewa par bia haldie se djam gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bakie djab kara ghaam bhail, tab tjhota plansoe komalaaike mar gail. Oe plansoe ke sor to oeppare raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Koetjh bia gieral djaaha kaata waala djhalaasie ke bia bhie raha aur doeno sanghe djam gail. Tab kaata waala djhalaasie barhke ekwa ke dabaais. Aisane bhail kie barhia bia phal na deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aur koetjh bia barhia djagaha par gieral aur djam gail, barka bhail aur phal deis. Kauno bia ties phal deis, kauno saathgo aur kauno saugo.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Oe bolies: „Dje ke kaan hai, oke tjaahie soene ke aur na tel daarke baithe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Djab manai log tjal gail raha aur khaalie Jiesoe ke baara tjela aur ekaatgo doesar tjela batjal raha, tab sabhan ose poetjhies: „Ie kaahaanie ke matlab hamlog se bataai sakiehe?” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tab oe bolies: „Pahiele Parmeswar koi se na bataais raha kie oe kaise raadj tjalaawe hai, bakie ab oe toelogke djanaawe hai. Aur doesarkwan khaalie matlab ke kaahaanie soenie. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ie rakam se oesab taakie bakie na dekh paai. Aur oesab soenat rahie, bakie tabbo hamaar baat na samadjh paai. Djab aise na rahat tab oesab aapan paap pastaaike tjhama paai sakat.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Oe bolies: „Djab toelog ie matlab ke kaahaanie na samadjh paawe hai, tab kaun waala samadjh paihe? ");
INSERT INTO hnsNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Attjha, ab ham toelogke samdjhaabe. Djaise ek khetiar aapan khet me bia tjhiete hai, oisane Parmeswar ke baat sagaro phailaawal dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Koetjh manai log ke diel djaise rasta hai djaun par bia gier gail. Djaise oesab khoes khabar soene hai, taise saitaan aaike baat me laat maare hai aur oesab khoes khabar ekdam se bhoelaai dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Koetjh doesar manai log ke diel djaise ek djagaha hai djaaha khaalie thora se mattie patthar par hai. Djab oesab Parmeswar ke khoes khabar soene hai, tab oesab toerant khoesiaalie se apanaai lewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bakie oesabke bieswaas djaise ekgo oeppare djamal waala plansoe hai. Oesabke diel me baat ekdam se na samaail hai. Tab djab doesar log oesabke sataawe lagie aur oesabke doekh oethaawe ke parie, tab oesab halieje se aapan bieswaas tjhor dei. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Aur koetjh doesar log ke diel djaise ekgo djagaha hai djaaha kaata waala djhalaasie djame hai. Oesab khoes khabar soene hai, bakie rodj ke kaar-baar aur doenia ke dhan-daulat ke haahie aur bhie doesar tjiedj ke laalietj oesabke aur barhia lage hai. Aise oesabke bieswaas na barh sake hai aur niepata hoi djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bakie koetjh manai log ke diel djaise barhia djagaha hai. Oesab Parmeswar ke khoes khabar soene hai, tab oesab aapan diel me lei lewe hai, tab oelogke tjaal-tjalan attjha, kie to barhia, kie to bahoet biesaal hoi dja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Oe bhie bolies: „Djab raat ke ekgo tjieraag bariehe, tab oke thoro baltie se top deihe, kie to bedie ke nietje dhar deihe? Na, oke oeppar dhariehe. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aisane ek dien sab tjhiepal kaam aur loekwaawal tjiedj dekhaai djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dje ke kaan hai, oke na tjaahie tel daarke baithe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Oe bolies: „Hamaar baat par dhiaan lagaaw. Djetana toe Parmeswar ke baat soeniehe, oe toke ese djaada samdjhaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dje hamaar baat koetjh samdjhe hai, oe aur dher samdjhiega. Bakie dje kausies na kare hai hamaar baat samdjhe ke, aur sotje hai kie oe Parmeswar ke biese me djaan gail hai, oe ek dien dekhie kie oe koetjh na djaane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Oe auro siekhaais kie: „Djab Parmeswar soeroe kare hai raadj tjalaawe ke, tab ie djaise ekgo khetiar hai djaun aapan khet me bia tjhiete hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","28","Oe rodj soetke djaage hai aur aapan kaam-dhaam kare hai. Aur bia phoete hai, djame hai, tab phal dewe hai. Bakie khetiar na djaane hai ie sab kaise howe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tab djab phal pak djaaiga tab oe toerant hasoewa se katwaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Oe bolies: „Ham kaun rakam se toelog ke samdjhaai Parmeswar kaise raadj tjalaawe hai? Aur ham kaun kaahaanie kaam me laai? ");
INSERT INTO hnsNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Okar raadj me dja hai djaise ek sarso ke bia se howe hai. Oe sab se tjhota bia hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bakie djab bowal dja hai, tab djame hai aur ek bahoet barka per howe hai. Aur barka daarhie howe hai kie tjierai oman khota lagaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jiesoe aisan kaahaanie kaam me laaike Parmeswar ke khoes khabar manai log se bataawat raha, djetana oesab samadjh paawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Oe khaalie kaahaanie se manai log ke Parmeswar ke baat siekhaawat raha. Bakie djab oe aapan tjela log ke saath akel rahat raha, tab oe sab kaahaanie ke matlab samdjhaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Oe dien djab derie hoi gail, tab Jiesoe aapan tjela log se bolies: „Aaw tjalie samoendar ke habara.” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Oe bot me raha. Tab oesab manai log ke tjhorke bot me djaaike okar sanghe tjal gail. Aur ekaatgo doesar bot bhie oelogke saath djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tab atjakke me aandhie-toefaan tjale lagal aur barka barka halfa maare lagal. Aur bot me etana dher paanie bhar gail kie doebe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jiesoe paatjhe bot me ek takia par soetal raha. Tab sabhan oke djagaais aur bolies: „Maastar djie, dekh hamlogse ka howe hai. Toke na boedjha hai kie hamlog doebiela?” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tab djab oe djaagal tab aandhie-toefaan ke daaties aur halfa se bolies: „Tjoep! Roek dja!” Aur aandhie-toefaan roek gail aur paanie ekdam dhiera hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tab oe aapan tjela log se bolies: „Toelog kaahe etana deraat rahiele? Toelogke bieswaas kaaha hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tab tjela log ie sab dekhke bahoet ghabaraai gail, aur apane me batiaai lagal: „Ie kaun rakam aadmie hai? Dekh, aandhie-toefaan aur halfa okar baat soen leis!” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tab sabhan samoendar kaatke Geraasa log ke des me pahoetj gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Djaise Jiesoe bot me se niekaral, taise kabarsthaan me se ekgo aadmie okar lage aail. Oke bhoet pakaries raha, ");
INSERT INTO hnsNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","aur oe pahaar ke hol me rahat raha djaaha maral manai logan ke mattie parat raha. Aur koi na oke pakarke baanh paawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Oesab kai dafe okar haath gor ketie se baanhies raha, bakie oe ketie toer dhaarat raha. Koi na oke samhaar paawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Oe raat dien pahaar par aur kabarsthaan me dawwaat raha. Oe hardam tjiellaat raha aur apane ke patthar se maarat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tab djab oe Jiesoe ke doer me dekhies, tab dhaurke aail aur okar gore gier paral. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Tab Jiesoe bolies: „Bhoet-paret, ie aadmie me se bhaag dja!” Tab oe tjiellaaike bolies: „Jiesoe! Toe sab se maahaan Parmeswar ke Beta baate! Tose aur hamse kaun kaam hai? Parmeswar ke naam se ham tose maangiela kie toe hamme piera na deihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tab oe poetjhies: „Tor ka naam hai?” Tab oe bolies: „Hamaar naam Dher hai. Hamlog dher djane se baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Oe ose bientie karies: „Hamlogke hia se doer na khaderiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hoewa par ek djhoend soewar pahaar par tjarat raha, lagbhag doei hadjaar. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tab bhoet-paret log Jiesoe se bientie karies: „Hamlogke soewarwan me djaain de.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tab oe bolies: „Dja!” Bhoet log aadmie me se niekarke gail soewar ke oeppar phaat paral. Tab djhoend bhar pahaar par se dhaure lagal aur samoendar me gierke doebke mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tab soewar ke tjaraawe waalan bhaag gail sahar aur gaaw me sab koi se bataawe ke. Tab dher manai log aail dekhe kie ka howe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tab djab oesab Jiesoe lage aail tab dekhies kie bhoet-paret waala aadmie sadhaaran se baithal hai aur kapra pahienies hai aur okar moerie thiek hoi gail. Tab oesab ghabaraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tab djaun aadmie log sab tjiedj dekhies raha, oesab bataais Jiesoe kaise bhoet-paret log ke bhagaais aur soewar log se ka bhail. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tab hoewa ke manai logan Jiesoe se bientie karies kie: „Toe hia se bestar tjal dja.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tab djab Jiesoe bot me gail, tab aadmie djaun attjha hoi gail raha, oe bolies: „Ham maangiela tor sanghe djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bakie oe bolies: „Toe dja ghare aapan palwaar lage. Aur sabhan se bataihe kie Prabhoe daaja karke tore khaat kaun biesaal kaam karies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aadmie tjal gail aur Dekaapoles galie me sab koi se bataawe lagal kie Jiesoe kaun barka kaam karies hai. Aur sab koi moeh baaike soenat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tab Jiesoe aur okar tjela log phieno samoendar ke habara kaaties. Tab oke pahoetjat der na lagal aur dher manai okar lage aail. Ohie khaatien oe samoendar lage rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tab ekgo aadmie aage aail. Oe ek partjaar ke ghar ke barkwa raha, aur okar naam Jaairas raha. Tab djab oe Jiesoe ke dekhies, tab okar gore gieral, ");
INSERT INTO hnsNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aur bientie karies kie: „Hamaar bietia mare par atkal hai. Ham bahoet maangiela kie toe aaike aapan haath okar oeppar dharieho. Tab oe batj djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tab Jiesoe okar sanghe tjale lagal. Aur dher manai oke thelat-thaalat djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Oman bhie ekgo aurat raha. Oke baara baries lek khaalie khoen gierat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Oe dher daaktar ke lage gail raha aur oesab oke bahoet doekh katwaais raha. Oe aapan sab paisa oman laga deis raha, bakie tabbo aur kharaab hoi gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Oe Jiesoe ke baare me soenies raha kie oe kaun barka kaam kare hai. Tab oe apane me sotjies: „Djab ham khaalie okar kapra tjhoei leb tab ham attjha hoi djaabe.” Tab oe sab manai ke thelat-thaalat Jiesoe ke paatjhe gail aur okar kapra tjhoei leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ohie laage khoen ekdam se band hoi gail. Oe djaan gail kie oe attjha hoi gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jiesoe toerant djaan gail kie okar saktie kaam me lewal gail hai. Tab oe ghoemke poetjhies: „Hamaar kapra ke tjhoeis hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tab okar tjela log bolies: „Toe to dekhe hai manai log kaise dhakele hai. Tab toe kaise ie poetjh sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bakie oe taakies kie ke oke tjhoeis hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tab aurat dar ke maare kaape lagal aur aage gail. Oe djaanat raha kie okar sanghe ka bhail hai. Tab oe Jiesoe ke gore gierke sab tjiedj bataais. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tab oe bolies: „Betie, toe hamare me bieswaas karle hai, ohie se toe batj gaile. Attjha se djaihe aur tjangga rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Abbe oe batiaite raha tab barkwa ke ek ghar waala aail aur aapan sardaar se bolies: „Tor bietia mar gail. Ab maastar djie ke moesiebat na de.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bakie Jiesoe ie baat par dhiaan na lagaais. Oe barkwa se bolies: „Na ghabara, khaalie hamare me bieswaas kar.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Oe na maangat raha kie dher manai okar saath djaai. Oe khaalie Petras, Jaakobas aur okar bhaai Johaanas ke legail. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Djab sabhan barkwa ke ghar lage pahoetjal tab Jiesoe dekhies kie hoewa ke manai log oedaasie ke maare piet-pietke rowe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tab Jiesoe aur ekwan bhiettar gail aur bolies: „Oe larkie na maral hai, oe soete hai. Toelog etana na row.” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tab sabhan oke hase lagal. Bakie oe sab koi ke bahare karies. Tab oe maai baap aur tieno tjela log ke leike larkie ke kamra me gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Oe maral larkie ke haath pakarke bolies: „Taalieta koem!” Ekar matlab hai: „Betie, ham tose boliela: Oethke thara how!” ");
INSERT INTO hnsNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aur larkie toerant thara hoike tjale lagal. Oe baara baries ke raha. Okar maai baap aur tjela log dekhke bahoet atjambho bhail! ");
INSERT INTO hnsNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tab Jiesoe oelogke mienaahie karies kie: „Koi se na bataaw kie kaun tjiedj bhail hai.” Oe bhie bolies: „Koetjh khaaik oke dei de.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tab Jiesoe hoewa se tjal gail. Oe Naasaaret sahar me gail djaaha oe posaail raha. Okar tjela log okar sanghe bhie gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tab djab sabat ke dien bhail, tab oe partjaar ke ghar me Parmeswar ke baat siekhaawe lagal. Tab dher manai log soenke atjambho hoi gail aur apane me bolies: „Ie sab tjiedj oe kaaha se djaane hai? Etana gjaan oe kaise paais hai? Aur ie sab barka kaam oe kaise kar paawe hai? ");
INSERT INTO hnsNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Oe to ghar banaawe waala hai, aur Maria ke betwa hai. Oe Jaakobas, Josaf, Joedaas aur Siemon ke bhaai hai, aur okar bahien log to bhie hia rahe hai.” Aur manai oke djaran kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tab Jiesoe oelogse bolies: „Ekgo Parmeswar ke sanesia sagaro barka maanal dja hai, bakie aapan sahar aur palwaar me na.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aur oe khaalie ekaatgo bemarian ke oeppar haath dharke attjha karies. Bakie hoewa par oe barka atjambho kaam na kar sakat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aur oe hoewa ke manai log ke be-bieswaas dekhke atjambho bhail. Tab Jiesoe aur okar tjela log ie gaaw me se oe gaaw djaat raha aur sagaro oe Parmeswar ke baat siekhaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tab ek rodj oe aapan baara tjoenal waala tjela log ke bolaais. Tab oelogke saktie deis bhoet-paret manai log me se niekaare ke aur doei doei djane ke pathaais khoes khabar djanaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Oe bolies: „Dher tjiedj na ledjaihe, khaalie ekgo ghoeme khaatien danda. Khaaik-paanie aur paisa bhie na ledjaihe. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Toelogan dalaila pahien sakiehe, bakie kapra na ledjaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aur bolies: „Djab toke koi apane ghare bolaai, tab hoewa par rahiehe djab talak toe doesar sahar na djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bakie djab toe kahoe djaihe aur hoewa ke manai log toke aapan ghare na bolaai aur tor baat par dhiaan na lagaai, tab hoewa se tjal djaihe. Tab toelogke tjaahie hoewa ke dhoer aapan gor me se djhaar dewe ke. Aise karke toelog dekhaihe kie toelogke kasoer na hai djab oesab Parmeswar ke aage kasoerwaar rahie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tab tjela log tjal gail aur sagaro ailaan karies kie: „Aapan paap pastaaw aur kharaab tjalaawa tjhor de.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Oelog dher manai me se bhoet-paret ke niekaarat raha aur tel lagaaike dher bemarian ke attjha karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Raadja Herodes Jiesoe ke baare me bhie soenies raha kie oe kaun partjaar aur atjambho kaam kare hai. Koetjh manai log Jiesoe ke biese me bolat raha: „Johaanas dopoe kare waala djie oethaawal gail hai. Ohie khaatien oe etana maahaan kaam kar paawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Koetjh doesar manai log bolat raha: „Oe Parmeswar ke sanesia Elia hai.” Aur koi koi bolat raha: „Ie aadmie ekgo Parmeswar ke sanesia hai djaise dher dien pahiele hamlogke des me bhie raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tab raadja Herodes djab ie baat soenies, tab bolies: „Ham Johaanas ke moerie katwaai deilie rahielie aur ab oe djie oethaawal gail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Raadja aapan bhaai Fielepas ke aurat tjhienke ose biaah karies raha. Oe aurat ke naam Herodias raha. Tab Johaanas raadja se bolies raha kie: „Parmeswar ke bahoet kharaab lage hai kie toe aapan bhaai ke aurat se biaah karle hai.” Ohie khaatien oe Johaanas ke pakarwaaike djahal me band kar dewaais raha. Aurat goessaai gail raha Johaanas ke oeppar aur maangat raha oke marwaai dhaare, bakie oe na kar paawat raha. Raadja Herodes Johaanas ke barka maanat raha aur maangat raha oke batjaawe. Oe djaanat raha kie Johaanas ek bhala aadmie raha aur Parmeswar khaatien alag karal raha. Oe kabhie kabhie oke bolwaaike okar partjaar soenat raha aur okar baat oke bahoet attjha lagat raha. Bakie tabbo oe ghabaraai djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tab ek rodj aurat ke mauka mielal Johaanas ke marwaai dhaare khaatien. Oe dien raadja aapan djanam dien manaawat raha. Oe Gaalielea diehaat ke barka aur dhanie manai log aur bhie soerdjaatie ke barkwan ke nauta deis raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tab aurat ke bietia bhiettar aaike aur sab koi ke aage naatje lagal. Oesabke etana attjha lagal kie raadja ose bolies: „Toe tjaahe djaun tjiedj mangiehe, ham toke debe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aur oe kasam khaaike bolies: „Djaun tjiedj toe mangiehe, taun ham toke deb, tjaahe hamaar aadha raadj.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tab larkie gail aapan maai lage aur poetjhies: „Ham kaun tjiedj maangie?” Tab okar maai bolies: „Dja Johaanas dopoe kare waala ke moerie maang!” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Larkie toerant raadja ke paas lautke gail aur bolies: „Ham maangiela kie toe ehie laage Johaanas ke moerie paletie par rakhke hamme deihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tab raadja ie baat soenke oke bahoet sotj maaries. Bakie oe aapan pahoena ke aage kasam khaais raha, ohie khaatien oe na maangat raha aapan waada toere. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tab oe toerant ekgo soerdjaatie ke pathaais Johaanas ke moerie kaatke laawe ke. Soerdjaatie djahal me gail aur okar moerie kaat leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tab oe moerie paletie par dharke laais aur larkie ke deis. Tab larkie moerie leike aapan maai lage gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Djab Johaanas ke tjela logan ie baat soenies, tab sabhan aaike okar mattie deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ek dien Jiesoe ke pathaawal tjela log lautke aail aur ose bataawe lagal oesab kaun tjiedj karies aur siekhaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bakie hoewa par etana dher manai aawat djaat raha kie oesabke tem na raha koetjh khaai ke. Ohie se Jiesoe oelogse bolies: „Aaw tjalie ek djagaha djaaha koi na hai. Tab toelog soestaai sakiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Oelog sab manai ke tjhorke bot leike tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bakie dher manai log oelogke djaat dekhies aur djaan gail sabhan kaaha dja hai. Tab oelog sab gaaw aur sahar me se haldie se gore gore bhie hoewa djaai lagal. Aur oelog bot se pahiele pahoetj gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tab Jiesoe djab hoewa pahoetjal tab djhoend dekhke oke haat lagal. Oelog to ek djhoend bhera ghat dekhaat raha aur oelogke tjaraawe waala na raha. Tab oe soeroe karies oesabke dher baat siekhaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tab djab sandjha howe lagal tab okar tjela log aaike ose bolies: „Maastar djie, hia par ekko ghar na hai aur ab to sandjha hoi gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bestar hai kie toe sab manai ke hia ke aas-paas ke gaaw me pathaai de. Tab oesab koetjh khaaik kien sakie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bakie oe bolies: „Tohielog iesabke khaaik deihe.” Tab oelog bolies: „Ie sab manai khaat bret kiene ke ketana paisa lagie? Ek manai ke aath mahienna ke kamaai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tab oe poetjhies: „Toelogke lage kaigo bret hai? Dja dekh.” Oesab gail dekhe aur aaike bolies: „Paatjgo bret, aur doeigo matjharie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tab oe bolies kie: „Sab manai ke doei-tien palwaar ke ek lage ghaas par baithaai de.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Koetjh der baad manai log baith gail, aur patjaas kie sau manai ek ek lage baith gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tab Jiesoe paatj bret aur doei matjharie leike oeppar taakke Parmeswar ke dhanbaad deis. Tab oe bret toer toerke tjela log ke deis baate ke. Aisane oe doei matjharie ke bhie toerke batwaais. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aur sab koi pet bharke khaais. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tab sabhan batjal bret batorke baara baskieta bharies. Aur koetjh matjharie bhie batjal raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aurat larkan tjhorke hoewa paatj hadjaar mardaana log raha, aur sab manai hoewa bhodjan karies raha! ");
INSERT INTO hnsNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ekare baad Jiesoe aapan tjela log se bolies: „Bot me dja aur habara kaatke Betsaaida sahar dja. Ham baad me aabe. Pahiele ham sab manai log ke ghare pathaai debe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tab oe sab koi se bhet karke tjal gail pahaar par praatna kare. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Djab raat bhail tab tjela log samoendar ke bietj me raha, aur Jiesoe akel pahaar par raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tab djab tien badj ke paas hoi gail raha tab oe dekhies kaise oelog mehenat se khewe hai. Bahoet hauwa raha. Tab oe paanie par tjalke aail aur maangat raha bot lage se paas howe. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tab tjela log djab koi ke samoendar par tjalat dekhies tab bahoet deraai gail. Oesab sotjies kie bhoet hai, aur dar ke maare tjiellaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bakie Jiesoe djor se bolies: „Na dera! Ham baatie!” ");
INSERT INTO hnsNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tab oe bot me gail, bas hauwa roek gail. Tjela log na djaanies kie oesab kaun tjiedj dekhies, tjakkariaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Oesab tjaahe okar bret ke barka kaam dekhies raha, tabbo na samadjh paais kie oe ke hai. Oelogke diel to kharaab raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tab djab oesabhan samoendar ke oepaar pahoetjal tab Genesaaret ke sahar ke nagietj aai gail. Hoewa par oesab bot baanh deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Djaise oesab bot me se niekarke gail oisane hoewa ke manai log Jiesoe ke tjienh leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tab oelog galie bhar me gail bemarian ke tjataai par okar paas laawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aur tjaahe djaun gaaw kie to sahar oe djaat raha, sab koi aapan aapan bemarian ke daam ke lage dhar dewat raha. Aur oesab ose bientie karies kie bemarian khaalie okar kapra ke djhalarie tjhoei sake hai. Aur dje dje oke tjhoeis, oesab ekdam se attjha hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ek rodj ekaatgo Fariesie log aur dharam ke parhal waalan Jeroesaalem sahar me se Jiesoe ke lage ekattha bhail. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tab oesab dekhies kie okar koetjh tjela log biena haath dhowe bret kha hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Israel logan, aur bieses karke Fariesie logan ke dharam ke nem hai khaai se pahiele haath dhowe ke. Oelogke baap-daada logan aisahie bhie karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aur djab oesab badjaar se ghare aawe hai tab khaai se pahiele naha hai. Oesab auro dharam ke nem maane hai, djaise kaam me laawe se pahiele bartan phien se khanghaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ohie se djab Fariesie log aur dharam ke parhal log dekhies kie koetjh tjela log biena haath dhowe kha hai, tab sabhan Jiesoe se poetjhies: „Tor tjela log kaahe ke biena haath dhowe bret kha hai, aur hamlogke baap-daada logan ke nem na maane hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tab oe bolies: „Are, dhokhaabaadj logan! Parmeswar ke sanesia Jasaaja ke baat toelogke baare me satj hai. Oe to liekhies raha kie: ‘Parmeswar bole hai: Ie djaatie log aapan moeh se hamaar aadar kare hai, bakie oesab hamke aapan diel se na maane hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Djaun baat oesabhan siekhaawe hai khaalie iensaan ke hoekoem hai. Ohie se oelogke ieddjat hamaar lieje koetjh na hai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Oe auro bolies: „Toelog manai log ke nem pakar leile hai, bakie Parmeswar ke baat tjhor deile hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Toelog Parmeswar ke hoekoem barhia se ek alang kar deile hai aapan dharam ke nem pakare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Aisane Mosas Parmeswar ke hoekoem se bolies: ‘Aapan maai-baap ke barka maan.’ Aur bhie bolies: ‘Dje aapan maai-baap ke saraapie, oke djaan se maar dhaare ke tjaahie.’ ");
INSERT INTO hnsNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bakie toelog siekhaawe hai kie dje aapan maai-baap se bole hai kie: ‘Ham aapan sab dhan-daulat Parmeswar ke daan debe,’ ");
INSERT INTO hnsNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","oe oelogke madat na kare ke pare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aisan baat siekhaaike toelog Parmeswar ke baat ek kait tjhor dewe hai. Ie khaalie ek tjiedj hai, bakie toelog auro rakam se aapan nem Parmeswar ke hoekoem se barka maane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tab Jiesoe phien se ekwan ke bolaaike siekhaais kie: „Sab koi soen aur hamaar baat par thiek se dhiaan dhar. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Koetjh na hai djaun manai ke bhiettar djaaike oke kharaab kare hai. Bakie djaun tjiedj okar moeh me se niekare hai, ohie oke kharaab kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dje ke kaan hai, oke tjaahie soene ke aur na tel daarke baithe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tab djab oe manai log ke tjhorke ghare tjal gail, tab okar tjela log ose ie tjhiepal baat ke matlab poetjhies. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tab oe bolies: „Ka, toelog bhie na dekhe hai? Toelog na samdjhe hai kie djaun tjiedj ek manai me bhiettar dja hai, oe oke kharaab na banaawe hai? ");
INSERT INTO hnsNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Oe khaaik okar diel me na dja hai, bakie pet me. Tab okare baad dehie me se niekar dja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aisahie oe siekhaais kie manai logan sab khaana khaai sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Oe bhie bolies: „Djaun baat manai ke moeh me se niekare hai, ohie oke kharaab banaawe hai. Ie sab baat okar diel me se niekare hai. Hoewa se sab kharaab sotj-bietjaar oetpan howe hai. Iensaan logan tjhatjhoendaraipan kare hai, tjorie kare hai, djaan marwa hai, aapan biaah ke waada toere hai, haahie hai, goessaha hai, dhokhaabaadj hai, apane ke na samhaare hai, djarantoeha hai, Parmeswar ke bedjatie kare hai, ghamandie hai aur biena sotj-bietjaar se kaam kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ie sab tjiedj manai ke diel me se niekare hai aur ohie oke kharaab kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tab Jiesoe hoewa se tjalke Tieras sahar ke galie gail. Hoewa par oe ekgo ghar me gail. Oe na maangat raha kie koi djaane oe kaaha hai, bakie tabbo koetjh manai djaan gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Hoewa par ekgo aurat raha. Okar bietia ke bhoet pakaries raha. Djab oe Jiesoe ke baare me soenies tab toerant okar paas gail. Oe Israel djaat ke aurat na raha, bakie oe Griek ke aurat raha aur Feniesia galie me Sieria des me rahat raha. Tab djab oe Jiesoe lage pahoetjal tab okar gore gierke aur poetjhies: „Toe hamaar bietia me se bhoet niekaar sakiehe?” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tab oe bolies: „Larkan ke pahiele pet bhar khaain de. Na thiek hai oelogke bret leike koetta ke khawaawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tab aurat bolies: „Djie-ha, Prabhoe, bakie djab koetjh bret gier dja hai, tab koetta log to khaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tab oe bolies: „Toe ie baat thiek bolle hai, ohie se toe ghare djaai sake hai. Ham tor bietia me se bhoet ke khader deilie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aurat gail ghare aur dekhies kie okar bietia attjha se bedie par letal hai aur bhoet tjal gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tab Jiesoe aur okar tjela log Tieras me se Siedon sahar gail aur hoewa se Dekaapoles diehaat me lautke gail Gaalielea ke samoendar lage. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tab ekaat manai log ek bahiera ke okar paas laais. Oe aadmie thiek se bhie na batiaai paawat raha. Oesab Jiesoe se bientie karies kie oe aapan haath okar oeppar dharke oke attjha kare. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tab oe oke manai log me se ek alang legail. Tab oe aapan angoerie okar kaan me daaries, aur thoekies, tab okar djieb tjhoeis. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tab oe oeppar taakke aur saas leike aapan bhaasa me bolies: „Efaata!” Ekar matlab hai: „Khoel dja!” ");
INSERT INTO hnsNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ohie laage aadmie soene lagal aur barhia se batiaai paais. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tab Jiesoe hoewa ke manai log se bolies: „Koi se na bataihe.” Bakie tjaahe oe doharaaike bolies, tabbo manai log sagaro bataais ka bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Oesab bahoet atjambho raha aur bolies: „Dekhle ketana biesaal kaam oe karies hai? Oe bahiera logan ke ekdam se attjha kar dewe hai aur goenga logan batiaai lage hai!” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Ek dien dher manai log phien se Jiesoe lage ekattha bhail raha. Bakie oesab ke khaaik na raha. Tab oe aapan tjela log ke bolaaike bolies: „Ie sab manai tien rodj se hia par hai aur ab oesabke khaaik don hoi gail hai. Hamke oesabke haat lage hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aur ham oesabke bhoekhe pet ghare to na pathaai sakiela. Ekaatgo bahoet doer rahe hai, oesab be-dam hoi djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tab tjela log bolies: „Hamlog etana dher manai khaatien kaaha se bret kienke laai? Hia koi na rahe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tab oe poetjhies: „Toelogke lage kaigo bret hai?” Tab oesab bolies: „Saatgo.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tab oe bolies: „Attjha, sab koi ke tjaahie djamien par baithe ke.” Tab oe saato bret leike Parmeswar ke dhanbaad deis. Tab oe bret ke toekkara toekkara toerke tjela log ke deis manai log ke baate ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aur oesabke bhie ekaatgo tjhota matjharie raha. Tab oe ekare khaat bhie dhanbaad karies aur tjela log se bolies: „Eke manai log ke bhie baat de.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aur sab koi pet bharke khaais. Tab djetana batjal-koetjal raha sabhan ekattha karies, saat barka baskieta bhar. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hoewa par lagbhag tjaar hadjaar manai logan bhodjan karies raha. Tab Jiesoe oesabse bolies: „Ab toelog ghare djaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tab oe toerant aapan tjela log ke leike bot me djaaike Dalmaanoeta ke galie tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ek rodj ekaatgo Fariesie log Jiesoe lage aaike moeh laraawe lagal. Oesab maangat raha djaane kie oe aapan kaam kekar saktie se karat raha. Tab oesab bolies: „Ekgo atjambho kaam kar, tab hamlog dekhab kie Parmeswar toke saktie dewe hai kie na.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tab Jiesoe aktaaike bolies: „Aadj-kaal ke manai log kaahe khaatien maange hai kie ham atjambho kaam karke dekhaai kie Parmeswar hamme pathaais hai? Ham toelogse satj boliela kie ham aisan kaam toelogke khaatien tanko na karab.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tab oe oesabke hoewa par tjhor deis aur aapan tjela log ke sanghe phieno bot me gail aur samoendar ke habara tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Djaite me tjela log dekhies kie oelog bret bhoelaai gail hai. Oesabke lage khaalie ekgo bret raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Etane me Jiesoe oesabse bataawe lagal: „Fariesie log aur raadja Herodes ke khatta karal piesaan se batjaaike rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tab tjela log apane me batiaai lagal kie oesab bret bhoelaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Bakie Jiesoe djaan gail aur bolies: „Toelog kaahe ke oe bret ke baare me batia hai? Toelog abbe talak na samadjhle hai? Toelogke boeddhie na hai? Toelog kaahe ke etana bhoettjar baate? ");
INSERT INTO hnsNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Toelog hamaar kaam aapan aakhie se dekhle aur kaan se soenle hai. Tab kaahe ke na samadjhle hai? ");
INSERT INTO hnsNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","20","Djab ham paatj bret toerke paatj hadjaar manai ke deilie khaai ke, tab kai baskieta bret batjal raha? Toelogke jaad na hai?” Tab oesab bolies: „Baaraago.” Tab oe bolies: „Aur djab ham saat bret me se tjaar hadjaar manai ke khawailie, tab ketana batorle rahiele?” Tab oesab bolies: „Saat baskieta.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tab oe bolies: „Ka, toelog ab talak na samadjhle ham kaun tjiedj kar sakiela?” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tab oesab Betsaaida sahar me djaaike pahoetjal. Tab koetjh manai ek andha ke laais, aur Jiesoe se poetjhies: „Aap eke tjhoeike attjha kar sako ho?” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tab oe okar haath pakarke gaaw me se legail. Tab okar aakhie par thoekies aur aapan haath okar oeppar rakhies aur poetjhies: „Ab toe koetjh dekhe hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tab aadmie aas-paas taake lagal aur bolies: „Hamme manai djaise tjalat per dekha hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tab oe phien se aapan haath okar aakhie par rakhies. Tab djab oe hataais tab aadmie barhia se dekhe lagal. Okar aakhie ekdam se attjha hoi gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tab oe bolies: „Ab gaaw me lautke na djaihe bakie dja ghare.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Koetjh dien baad Jiesoe aur okar tjela log Sesaarea Fielepie sahar ke aas-paas ke gaaw me gail. Tab tjalte me Jiesoe poetjhies: „Manai logan hamaar biese me ka bole hai kie ham ke baatie?” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tab oesab bolies: „Koi koi bole hai kie toe Johaanas dopoe kare waala baate. Aur ekwan sotje hai kie toe Parmeswar ke sanesia Elia baate. Aur koetjh log bole hai kie toe ekgo doesar pahiele ke sanesia baate.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tab oe poetjhies: „Aur toelog ka bole hai kie ham ke baatie?” Tab Petras bolies: „Toe Parmeswar ke Kriest baate.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tab oe oesabke mienaahie karies aur bolies: „Koi se na bataihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tab oe samdjhaawe lagal kie: „Iensaan ke Beta ke bahoet doekh oethaawe ke parie. Barkwan, barka agwan aur dharam ke parhal waalan oke na maangiega aur oke marwaai dhaariega. Aur tien rodj baad oe phieno djie oethiega.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Oe ie sab baat kholke bolies. Tab Petras oke ek kait legail aur oke daate lagal aur bolies: „Maastar djie, aise na bol.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tab oe ghoemke doesar tjela log ke aage oke daatke bolies: „Saitaan, hamaar paatjhe se bhaag dja! Toe iensaan ghat sotje hai aur na Parmeswar ghat.” ");
INSERT INTO hnsNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tab oe aapan tjela log ke aur bhie ekwan manai logan ke aapan paas bolaaike bolies: „Dje hamaar rasta par maange hai tjale, oke tjaahie aapan rasta tjhor dewe ke, aur djab okar bieswaas dwaara oke doekh oethaawe ke parie, tabbo oke tjaahie hamaar paatjhe tjale ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dje maange hai aapan djiewan apane khaatien bietaawe, okar djiewan Parmeswar ke aage djhoetthe ke hoi djaai. Bakie dje aapan djiewan hamaar khaatien bietaaiga aur hamaar khoes khabar phailaaiga, oe sattja djiewan paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Djab koi doenia ke sab tjiedj harap lei, aur oe Parmeswar se doer pahoetj djaai, tab oke kaun faida hoi? ");
INSERT INTO hnsNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Iensaan Parmeswar ke kaun tjiedj dei sake hai sattja djiewan paawe ke? ");
INSERT INTO hnsNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Koetjh manai kharaab hai aur Parmeswar ke tjhor deis hai. Oesab hamaar baat aur hamse sarma hai. Bakie djab iensaan ke Beta aapan Baap ke maahaanta me pawietr parie log ke sanghe aaiga, tab oe bhie oelogse sarmaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Oe bhie bolies: „Sattje ke, hia ke koetjh manai mare se pahiele dekhiega kie Parmeswar kaise iensaan ke diel me aapan barka saktie se raadj tjalaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tjhau dien baad Jiesoe Petras, Johaanas aur Jaakobas ke legail ek oetja pahaar par. Hoewa par doesar manai na raha. Tab oe doesar rakam dekhaai lagal aur ");
INSERT INTO hnsNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","okar kapra oeddjar tjamke lagal. Doenia me koi na kapra etana oeddjar dhoi sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tab oesab Elia aur Mosas ke dekhies, aur oe doeno Jiesoe se batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tab Petras bolies: „Maastar djie, barhia hai kie hamlog hia baatie. Hamlog tiengo marai banaabe, ekgo tor khaatien, ekgo Mosas khaatien aur ekgo Elia khaat.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tjela log bahoet ghabaraai gail raha, ohie khaat Petras ie and-band baat bolies. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tab baadar oesabke tjhaais aur oman se ekgo aawaadj soenaail. Koi Jiesoe ke baare me bolies: „Ie hamaar pjaara Beta hai. Okar baat soeniehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tab atjakke me tjela log sagaro taakies aur Mosas aur Elia ke na dekhies. Oesab alop hoi gail raha aur khaalie Jiesoe oelogke lage raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Koetjh der baad djab oesab pahaar se nietje djaat raha tab oe bolies: „Djab talak iensaan ke Beta maral manai me se na djie oethiega toelog koi se na bataihe hia ka bhail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ohie khaatien oelog ie sab tjiedj ke baare me na batiaat raha. Bakie oesab apane me poetjhies: „Maral manai me se djie oethe ke matlab ka hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tab oesab ose poetjhies: „Dharam ke parhal logan kaahe ke bole hai kie Kriest se pahiele Elia aaiga?” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tab oe bolies: „Ha, Elia pahiele aaiga aur sab tjiedj phien se attjha kariega. Aur dekh iensaan ke Beta ke baare me ka liekhal hai. Oke tjaahie dher doekh oethaawe ke aur manai log oke nietja maaniega. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Bakie ham toelogse boliela kie Elia aai tjoekal hai. Aur manai log okar natiedja karies djaise oesab maangat raha. Parmeswar ke poestak me liekhal gail raha kie aisahie ose hoiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Djab Jiesoe aur okar tien tjela log ekwa tjela log ke lage lautke aail raha, tab dekhies kie oelog ekaat dharam ke parhal waalan se moeh laraawe hai. Dher doesar manai oesabke aas-paas thara raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Djab djhoend log Jiesoe ke aawat dekhies tab oesab bahoet atjambho hoi gail aur haldie se tjalke okar lage gail aur bolies: „Maastar djie, aap kaise baato?” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tab oe bolies: „Attjha,” aur poetjhies: „Toelogan kaun tjiedj ke baare me baat-tjiet karat rahiele?” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tab djhoend me se ek djane bolies: „Maastar djie, ham aapan beta tor lage lailie. Oke ekgo bhoet pakaries hai, ohie khaatien oe na batiaai paawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Djab bhoet oke djiet lewe hai, tab oke nietje patak dewe hai. Okar moeh me se phetjkoer niekare hai, oe aapan daat kierkieraawe hai aur okar dehie ekdam karer hoi dja hai. Ham tor tjela log se poetjhlie bhoet ke niekaare ke, bakie oesab na niekaar paais.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tab Jiesoe hoewa ke manai log se bolies: „Are, be-bieswaasie logan! Hamke kai dien talak toelogke sanghe rahe ke parie? Ham kab talak toelogke be-bieswaas sahab?” Aur bolies: „Attjha, larka ke hia laaw.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Oesab oke laais. Tab djab bhoet Jiesoe ke dekhies tab larka ke dehie karer kar deis. Tab oe nietje gierke lote lagal aur phetjkoer okar moeh me se niekare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tab Jiesoe okar baap se poetjhies: „Kai dien se aise howe hai?” Tab baap bolies: „Tjhotahie se. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Oe oke bhie dher dafe aagie aur paanie me gieraais hai oke maar dhaare khaat. Djab toe ekare khaatien koetjh kar sakiehe tab toe hamlog par daaja kar aur oke attjha kar deihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tab oe bolies: „Toe kaahe khaat bole hai: ‘Djab toe koetjh kar sakiehe’? Dje Parmeswar me bieswaas kare hai, oe sab koetjh kar sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tab aadmie toerant bolies: „Ham to bharosa kariela, bakie hamaar bieswaas tjhota hai. Hamke sahaaita kar auro bieswaas kare ke!” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tab djab Jiesoe dekhies kie auro manai aawe hai, tab oe bhoet ke daaties djaun launda ke bahier aur goenga karies raha. Oe bolies: „Niekar dja aur oke ab se kabhie na pakariehe!” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tab bhoet djor se tjiellaaike, aur launda ke khoeb djhakdjhorke tjhor deis. Aur larka djaise maral paral raha. Tab manai logan bole lagal kie: „Oe mar gail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bakie Jiesoe okar haath pakarke thara karies. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Koetjh der baad djab Jiesoe aur okar tjela log ekgo ghar me gail raha aur ekwa manai tjal gail raha, tab tjela log ose poetjhies: „Kaise bhoetwa ke hamlog na bhagaai pailie?” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tab oe bolies: „Ie rakam bhoet khaalie praatna se bhagaawal djaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jiesoe aur okar tjela log hoewa se Gaalielea diehaat gail. Oe na maangat raha kie manai log djaane oe kaaha dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Oe maangat raha khaalie aapan tjela log ke siekhaawe. Oe bolies: „Iensaan ke Beta doesman ke haath me saup dewal djaaiga aur oesab oke maar dhaarie. Tab tien rodj baad oe phien se djie oethiega.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bakie tjela log okar baat na samadjh paais aur oesab dar ke maare na poetjhies. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tab oesab Kaapernaum sahar me aail. Djab oelog ghare pahoetjal tab Jiesoe oesabse poetjhies: „Toelog rasta par kaun tjiedj ke baare me batiaat rahiele?” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bakie oesab koetjh na bolies. Oesab to apane me takaraar karat raha kie oelog me se barkwa ke hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tab Jiesoe gail baithe, aur tjela log se bolies: „Dje maange hai barkwa howe, oke tjaahie apane ke sab se tjhota maane ke aur naukar ghat banke rahe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tab oe ekgo larka ke bolaaike oelogke bietj me laais aur oke dapkaaike oelogse bolies: ");
INSERT INTO hnsNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","„Dje aisan tjhota larka ke hamaar hoekoem par apana lewe hai, oe hamke apanaawe hai. Aur dje aise kare hai, oe na khaalie hamke apana lewe hai, bakie bhie oke djaun hamme pathaais hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tab Johaanas bolies: „Maastar djie, hamlog dekhlie kaise ek aadmie tor naam leike bhoet logan ke khaderat raha. Bakie oe hamlog me ke na hai, ohie khaat hamlog maangat rahielie oke mienaahie kare.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bakie oe bolies: „Oke na rokiehe. Dje hamaar naam leike atjambho kaam karie, oe na oelte hamaar niendara kar sakiega. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Dje hamaar rasta par koi ke na rokaai, oe hamlog me ke hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ham toelogse satj boliela kie djab koi djaane hai kie toelog Kriest me saamiel baate aur ohie khaat toelogke ek gielaas paanie dei, Parmeswar oke djaroer ienaam deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Oe larka ke dekhaaike bolies: „Dje aisan tjhota bieswaasie se paap karwaaiga, okare lieje auro barhia rahat djab ekgo barka ieta gatai me baanhke oe samoendar me biegal djaat. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Djab tor haath tose paap karwaawe hai, tab oke kaatke bieg de. Bestar hai ek haath se Parmeswar lage djaai ke aur na doeno leike narak me pahoetje ke. Hoewa par aagie me djariehe djaun kabhie na boetiega.  ");
INSERT INTO hnsNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Hoewa par hardam kierwa pariega aur aagie kabhie na boetiega. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Djab tor gor toke kharaab rasta par ledja hai, tab kaatke bieg de. Bestar hai kie toe langaraate Parmeswar ke paas pahoetj djaihe aur na doei gor leike narak me phekal djaihe.  ");
INSERT INTO hnsNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Hoewa par hardam kierwa pariega aur aagie kabhie na boetiega. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aur djab tor ek aakhie tose paap karwaawe hai, tab notjke bieg de. Bestar hai kie toe ek aakhie leike Parmeswar ke raadj me djaihe nahie to doeno aakhie leike narak me khaderal djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hoewa par hardam kierwa pariega aur aagie kabhie na boetiega. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Har ek ke tjaahie djaise aagie se adjmaawal djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Niemak ek barhia tjiedj hai, bakie djab oman sawaad na rahie, tab kaun tjiedj se sawaad miel sakie? Toelog tjatak niemak ghat aur apane me miel-djoelke rahoe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tab Jiesoe oethke hoewa se tjal gail aur aapan tjela log ke leike Joedea galie aur bagal ke diehaat Jordaan nadie ke habara gail. Aur phien se dher manai log okar paas aail. Aur djaise oe hardam Parmeswar ke baare me siekhaawat raha, oisane oe hoewa par bhie soeroe karies siekhaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tab ekaatgo Fariesie aaike maangat raha dekhe kie oe Parmeswar ke baat oelta siekhaawe hai kie na. Oesab ose poetjhies: „Toe ka sotje hai, djab ekgo aadmie aapan aurat ke tjhor dewe hai, tab oe Mosas ke kaanoen toere hai kie na?” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tab oe poetjhies: „Mosas ie tjiedj ke baare me ka liekhies raha?” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tab oesab bolies: „Oe liekhies raha kie ekgo aadmie ke tjaahie ekgo kaagadj par liekhe ke: ‘Ab ham ie aurat ke tjhor deilie hai.’ Tab oe aapan biehautie ke oe kaagadj deike tjhor sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tab oe bolies: „Toelogke diel bahoet kharaab hai, ohie khaatien Mosas ke tjaahat raha ie hoekoem liekhe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bakie djab Parmeswar sansaar banaais tab oe mardaana aur aurat ke ek doesare khaatien banaais. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ohie khaat ekgo mardaana ke tjaahie aapan maai-baap ke tjhorke aapan aurat ke saath rahe ke. Oe doeno ek rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aisahie oesab na doei djane bakie ek rahie. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dje ke Parmeswar ek karies hai, oke iensaan ke na tjaahie alag kare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tab ghare aaike tjela log ie baat ke baare me phien se poetjhe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tab oe bolies: „Dje aapan aurat ke tjhor dewe hai aur doesar se biaah kar lewe hai, oe aapan biaah ke waada toere hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aur djab ekgo aurat aapan aadmie ke tjhor dewe hai aur doesare se biaah kar lewe hai, tab oe bhie aapan biaah ke waada toere hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ek rodj manai log Jiesoe ke paas koetjh larkan laais. Oesab maangat raha kie Jiesoe oesabke tjhoeike aasier-baat dewe. Tab tjela log ie dekhke oelogke mienaahie karies. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bakie ie baat Jiesoe ke tanko na attjha lagal. Oe bolies: „Tjhor de, oe larkan ke aawan de. Parmeswar ke raadj aisan manai log khaatien hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ham toelogse satj boliela kie khaalie dje ek tjhota larka ghat Parmeswar ke raadj aapan diel me na tjalwaai, oe okar raadj me bhiettar na djaai sakiega.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tab oe larkan ke aapan godie me leis aur har ek ke oeppar aapan haath dharke oesabke aasier-baat deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Djab oe hoewa se djaai lagal tab ekgo aadmie dhaurke aail aur okar gore gierke poetjhies: „Attjha maastar djie, ham ka karie hardam khaatien Parmeswar ke saath rahe ke?” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tab oe bolies: „Toe kaahe ke hamme attjha bolaawe hai? Khaalie Parmeswar attjha hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aur bolies: „Toe djaane hai kie Parmeswar kaun hoekoem deis hai: Koi ke djaan na maar, aapan biaah ke waada na toer, tjorie na kar, djhoeth gawaahie na de, baimaanie na kar, aur aapan maai-baap ke aadar kar.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tab aadmie bolies: „Ham tjhotahie se ie sab baat maaniela.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tab oe oke bahoet pjaar se taakke bolies: „Tabbo toe ek tjiedj auro kar sakiehe. Dja aapan sab tjiedj betjke garieb logan ke daan kar de, tab toke swarag ke dhan mielie. Tab aaike hamaar paatjhe tjaliehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tab ie baat soenke aadmie bahoet oedaas hoike tjal gail. Oe to bahoet dhanie raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tab Jiesoe aapan tjela log ke taakke bolies: „Dhanie log ke khaat ketana moeskiel hai Parmeswar ke raadj me djaai ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tab oesab ie baat soenke thak hoi gail. Bakie oe phien se bolies: „Bhaai log, Parmeswar ke raadj me bhiettar djaai ke ketana moeskiel hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ek barka djanaawar djaise oet khaatien moeskiel hai ekgo soei ke hol me ghoese ke. Aur dhanie aadmie khaatien Parmeswar ke raadj me bhiettar djaai ke auro moeskiel hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tab oesab ekdam oedaas hoi gail aur bolies: „Tab ke batj sakiega?” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tab oe oesabke taakke bolies: „Manai log khaatien moeskiel hai, bakie Parmeswar sab koetjh kar sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tab Petras bolies: „Hamlogan aapan sab tjiedj tjhor deilie hai tor saath tjale khaat.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tab oe bolies: „Ham toelogse koetjh bataabe. Dje aapan ghar-dwaar, bhaai-bahien, maai-baap, larkan kie to khet hamare aur hamaar khoes khabar bataawe khaatien tjhor dewe hai, ");
INSERT INTO hnsNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","oke ie tem me sau dafe djaada ghar-dwaar, bhaai-bahien, maai, larkan aur khet mieliega. Bakie oe sataawal djaai. Aur aane waala djoeg me oe sada ke lieje Parmeswar ke sanghe rahie. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bakie dher pahiela waalan pietjhar djaai aur paatjhe waalan agar djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ek dien dher manai log Jeroesaalem sahar ke or djaat raha. Jiesoe aage tjalat raha. Okar tjela log atjambho raha kie oe hoewe dja hai, aur djaun manai log okar paatjhe tjalat raha, oesab deraat raha kie barkwan oke maar dhaariega. Tab oe aapan baara tjela ke alag bolaaike phien se bataawe lagal kaun tjiedj okar sanghe hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Oe bolies: „Soen, hamlog Jeroesaalem djaaila. Hoewa par iensaan ke Beta barka agwa log aur dharam ke parhal waalan ke haath me saup dewal djaaiga. Tab oesabhan oke pardesie log ke haath me saupiega aur hoekoem deiga oke maar dhaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pahiele oesab okar thatha oeraai, thoekie, aur khoeb maariega. Tab ant me oesab oke maar dhaariega. Bakie tien rodj baad oe phieno djie oethiega.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tab Sebedeas ke betwan Jaakobas aur Johaanas Jiesoe ke lage aaike bolies: „Maastar djie, hamlog tose ek baat poetjh sakiela?” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tab oe poetjhies: „Ham toelogke khaat kaun tjiedj karie?” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tab doeno bolies: „Djab toe maahaan Raadja ghat aapan des ke oeppar raadj tjalaihe, tab hamlog maangiela tor sab se barka mandjha ghat raadj tjalaawe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bakie oe bolies: „Ka, toelog djaane hai kie toelog ka bole hai? Hamaar doekh djaise djahar rahie pieje ke. Toelog pie sakiehe djaise ham piebe? Aur toelog maut me dopoe lei sakiehe djaise ham lebe?” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tab oesab bolies: „Djie-ha, hamlog kar paabe.” Tab oe bolies: „Toelog doekh katiehe aur maut me dopoe leihe djaise ham. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bakie manai log ke oetja dardja dewe ke djab ham raadj tjalaabe, oe hamaar kaam na hai. Pieta Parmeswar sallaah kar tjoekal hai kie oe ke ke deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tab djab ekwan soenies kie Jaakobas aur Johaanas ka maange hai, tab oesab goessaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tab Jiesoe oesabhanke apane paas bolaaike bolies: „Toelog djaane hai kie doenia ke barkwan manai log ke oeppar raadj tjalaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bakie toelog apane me aise na kariehe. Dje toelog me barkwa maangie rahe, oke tjaahie doesare ke naukar banke rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aur dje toelog me se maangie sab se oetja dardja paawe, oke tjaahie sab koi ke goelaam banke rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Iensaan ke Beta na aail hai apane ke sewa karwaawe, bakie ekwan ke sewa kare aur aapan maut ke dwaara dher manai log ke batjaawe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tab tjalte tjalte Jiesoe aur okar tjela log Jerieko sahar me pahoetjal. Tab koetjh der baad djab oesab aur dher doesar logan sahar me se djaat raha, tab sabhan ekgo andha ke dekhies. Oe daam lage baithke bhiekhmaangat raha. Oe Tiemeas ke beta Baartiemeas raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tab djab oe soenies kie Naasaaret sahar ke Jiesoe aawe hai, tab oe tjiellaai lagal: „He Jiesoe, raadja Daawied ke aulaad! Hamme daaja kar!” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tab dher manai log oke daaties aur bolies: „Tjoep!” Bakie oe auro kaske tjiellaais: „Raadja Daawied ke aulaad, hamme daaja kar!” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tab Jiesoe hoewa roek gail aur bolies: „Oke bola laaw.” Tab oesab andha se bolies: „Hiemmat kar aur oethke aaw! Oe toke bolaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tab andha aapan koerta biegke haalie se koedke Jiesoe lage gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tab Jiesoe ose poetjhies: „Ham tor khaat kaun tjiedj karie?” Tab andha bolies: „Raboenie, Maastar djie, ham maangiela dekhe!” ");
INSERT INTO hnsNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tab oe bolies: „Toe hamare me bieswaas kare hai, ohie se ham tor aakhie attjha kariela. Toe djaai sake hai djaaha toe mangiehe.” Aadmie toerant dekhe lagal aur Jiesoe ke paatjhe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Tab Jiesoe aur ekwan Jeroesaalem sahar ke nagietj pahoetjal. Hoewa par Djaitoen pahaar lage Betfaage aur Betaania ke gaaw raha. Tab Jiesoe aapan tjela me se doeigo se bolies: „Dja oe gaaw me djaun sodjhe dekha hai. Djaise toelog hoewa pahoetjiehe taise toelog ekgo madjhielka gadaha baanhal dekhiehe. Abbe koi opar na baithal hai. Oke kholke hamaar lage laihe. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aur djab koi toelogse poetjhie: ‘Toe ka kare hai?’ tab bol deihe: ‘Prabhoe ke eke kaam hai, aur oe abbe pathaai deiga.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Oe doeno hoewa gail aur daam par ekgo kamaarie lage gadaha ke paais. Oesab okar tatai khole lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hoewa par koetjh log thara raha. Tab koi poetjhies: „Toe ka kare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tab tjela log bataais djaun Jiesoe bolies raha. Tab manai log oesabke ledjaain deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Aur tjela log oke Jiesoe ke paas legail. Tab oesab gadaha par aapan kapra bietjhaais aur oe opar baith gail aur sabhan sanghe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tab dher manai log okar khaat aapan kapra rasta par bietjhaais, aur doesar log khet me se patta toerke laaike bietjhaais Jiesoe ke aadar kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tab manai log okare aage paatjhe tjalat raha aur djor se bolat raha: „Parmeswar ke barka maan! Ie soekhie Manai Prabhoe ke naam se aawe hai! ");
INSERT INTO hnsNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Oe soekh me raadj tjalaaiga djaise hamlogke baap-daada raadja Daawied bhie karat raha! Parmeswar oke aasies dewe. Hamlog swarag talak oke barka maaniela!” ");
INSERT INTO hnsNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aisahie Jiesoe gadaha par baithke Jeroesaalem sahar me pahoetjal. Tab oe Parmeswar ke mahal ke angana me gail aur dekhies kie hoewa par ka howe hai. Derie hoi gail raha, ohie se oe aapan baara tjela log ke leike phien se Betaania gaaw me laut gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tab djab saber bhail tab sabhan Betaania gaaw se djaat raha. Aur Jiesoe ke bhoekh lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tab koetjh doer me oe ekgo adjier ke per dekhies. Oe gail per me dekhe kie oman phal hai kie na, bakie koetjh na paais. Oman khaalie patta raha. Adjier ke phal ke tem na raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tab oe per se bolies kie: „Toe ab se kabhie phal na deihe!” Aur okar tjela log soenies kie oe ka bole hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tab djab Jiesoe aur okar tjela log Jeroesaalem sahar me pahoetjal, tab oesab phien se Parmeswar ke mahal ke angana me gail. Hoewa par dher manai kienat betjat raha. Ohie se Jiesoe djaaike oesabke khadere lagal. Oe paisa toeraawe waala log ke tafra oeloet deis aur kaboettar betje waalan ke koersie bhie. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Oe manai log ke bhie rokies djaun maangat raha har ek rakam tjiedj angana me laawe. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Oe oesabke daatke bolies: „Ka, toelog na djaane hai kie Parmeswar ke poestak me liekhal hai: ‘Hamaar mahal ke tjaahie ekgo praatna kare ke djagaha rahe ke doenia ke djaatie log khaatien.’ Bakie toelog eke daakoe ke djagaha banaile hai!” ");
INSERT INTO hnsNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tab djab barka agwan aur dharam ke parhal waalan soenies kie oe ka kare hai, tab oesab ekgo mauka khodje lagal oke marwaai dhaare khaatien. Bakie djaatie log okar siektjha biesaal maanat raha, ohie khaat barkwan deraat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tab djab sandjha howe lagal tab Jiesoe aur okar baara tjela log sahar me se phieno tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Biehaan bhaile djab sabhan adjier ke per lage se paas bhail, tab dekhies kie oe per ekdam se djhoeraai gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tab Petras jaad karies kie Jiesoe kaun baat bolies raha. Oe ose bolies: „Maastar, dekh, kalhia toe perwa ke saraple rahiele aur aadj oe djhoeraai gail! Oe kaise hoi sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tab oe bolies: „Parmeswar me bieswaas kar. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Soen, dje aapan diel bhar se Parmeswar me bieswaas kare hai aur dje ke doebdha na hai, oe hia ke pahaar se bol sake hai: ‘Oekhar, aur samoendar me gier dja!’ aur Parmeswar ose aise karwaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ohie se ham toelogse boliela kie djab toe praatna me Parmeswar se tjaahe djaun tjiedj mangiehe, tab toke tjaahie bieswaas kare ke kie toe paai tjoekale hai. Tab Parmeswar tor praatna soeniega. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Bakie praatna karte me djab toe koi ke oeppar goessaail baate, tab toke tjaahie oke tjhama dewe ke. Tab tor swarag ke Pieta tor paap bhie tjhama karie.  ");
INSERT INTO hnsNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bakie djab toe doesar koi ke na mangiehe tjhama kare, tab tor swarag ke Pieta toke bhie tjhama na karie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tab Jiesoe aur okar tjela log phieno Jeroesaalem sahar me aail. Tab djab oe Parmeswar ke mahal ke angana me ghoemat raha, tab barka agwan aur dharam ke parhal logan aur doesar barkwan okar lage aail. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Oesab poetjhies kie: „Toe aapan kaam kekar naam se kare hai? Kalhia toe manai log ke kekar hoekoem se khaderle?” ");
INSERT INTO hnsNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tab oe bolies: „Ham toelogse pahiele ek baat poetjhab. Djab toelog djabaab deihe, tab ham toelogse bataabe kie ham ie sab kaam kekar hoekoem se karlie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Oe poetjhies: „Johaanas Parmeswar ke kie manai log ke hoekoem se dopoe karat raha? Toelog ka bole hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tab barkwan apane me baat-tjiet karke bolies: „Hamlog ka bolie? Djab hamlog bolab: ‘Parmeswar ke’ tab oe bolie: ‘Tab toelog kaahe ke okar baat na bieswaas karle hai?’ ");
INSERT INTO hnsNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bakie djab hamlog bolab: ‘Manai log ke hoekoem se,’ tab djaatie log hamlogke oeppar goessaai djaai.” Dher manai log to Johaanas ke ek Parmeswar ke sanesia ghat barka maanat raha, aur barkwan oesabke deraat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ohie khaat oesab Jiesoe se bolies: „Hamlog na djaaniela.” Tab oe bolies: „Tab ham toelogse bhie na bataab kie ham kekar hoekoem se ie sab kaam kariela.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tab oe barkwan se ek matlab ke kaahaanie bataawe lagal aur bolies: „Ekgo aadmie raha. Ek rodj oe soeroe karies khetie kare ke. Oe agoer ke per lagaais. Tab oe khet ke gheries aur ek barka garha khodies phal ke ras gaare khaatien. Tab oe bhie ekgo oetja djagaha banaais khet ke rakhwaala khaatien. Tab oe khet ke bhaara karke par-des tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tab djab katnie ke tem aail tab oe ekgo goelaam ke pathaais aapan hiessa laawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bakie khetiar log oke pakarke khoeb maaries aur djhoere haathe lautaar deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tab oe ekgo doesar goelaam ke pathaais. Bakie ohoe ke sabhan moerie par maarke aur bedjatie karke lautaar deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tab oe tiesara kamkarta ke pathaais, bakie sabhan oke maar dhaaries. Aur aisahie oe dher kamkartan ke pathaais, bakie khetiar log kauno kauno ke maaries aur kauno kauno ke maar dhaaries. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tab khaalie ek djane batjal, aur oe okar pjaara beta raha. Tab oe apane me sotjies: ‘Oesab hamaar pjaara betwa ke djaroer maan-djaan karie.’ Aur oke pathaais. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bakie khetiar log djab beta ke aawat dekhies tab bolies: ‘Dekh, maaliek ke beta aawe hai. Koetjh dien ke baad khet okar naam par hoi djaai. Tjalie oke maar dhaarie dja, tab khet hamlogke hoi djaai.’ ");
INSERT INTO hnsNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tab sabhan oke pakarke maar dhaaries aur okar lahaas khet me se bieg deis.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Aur Jiesoe bolies: „Toelog ka sotje hai? Djamiendaar khetiar log se ka karie? Oe apane aaike oesab ke maar dhaarie. Aur khet ke doesar koi ke oeppar saup deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Oe bolies: „Toelog to Parmeswar ke poestak me ie sab baat parhle hai: ‘Oe ieta djaun ghar banaawe waalan be-kaamiel maanat raha, oe aisan djagaha par dharal gail kie oe sab ekwan ieta ke rasta dekhaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ie kaam Prabhoe karies hai, aur hamlogke khaat bahoet maahaan hai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Barkwan samadjh gail raha kie Jiesoe oesabke baare me batiaat raha. Ohie se oesab maangat raha oke pakare. Bakie oesab deraat raha kie djhoend log goessaai djaai. Tab oesab oke tjhorke tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Koetjh der baad barkwan ekaatgo Fariesie log ke aur raadja Herodes ke koetjh saamiel waalan ke Jiesoe ke paas pathaais. Oesab maangat raha oke koetjh oelta bolwaaike phasaawe. Tab oesab oke pakar sakat. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tab djab oesab okar lage pahoetjal tab bolies: „Maastar djie, hamlog djaaniela kie toe sattja aadmie baate aur doei moeh se na batia hai. Toe manai ke moeh na dekhe hai, bakie khaalie Parmeswar ke sattjaai siekhaawe hai. Ab hamlog maangiela tose ek baat poetjhe. Thiek hai Roma ke maahaaraadja ke djoetie ke paisa bhare ke, kie na?” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bakie oe oesabke kharaab sotj-bietjaar djaanat raha. Oe bolies: „Toelog kaahe ke maange hai hamke phasaawe?” Oe bolies: „Laaw hamke ekgo tjaanie ke paisa dekhaaw.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Oesab dekhaais. Tab oe poetjhies: „Epar kekar moertie aur liekhal baat dekhe hai?” Tab oesab bolies: „Maahaaraadja ke.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tab oe bolies: „Attjha, tab maahaaraadja ke de djaun okar hak hai aur Parmeswar ke djaun Parmeswar ke hai.” Tab oesabhan ie barhia baat se ekdam atjambho hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tab ekaatgo Sadoesie Jiesoe lage aail. Oesab bole hai kie iensaan log maut me se na djie oethiega. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tab oesab ose bolies: „Maastar djie, toe djaane hai Mosas kaun Parmeswar ke hoekoem liekhies raha biaah kare ke baare me. Djab ekgo aadmie mar djaai aur oke larkan na rahie, tab okar bhaai ke tjaahie okar aurat se biaah kare ke. Tab pahiela betwa maral bhaai ke naam paai. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Maan le kie saatgo bhaai raha. Tab pahiela waala ke biaah bhail, tab oe mar gail aur oke larkan na raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Tab ek doesar bhaai auratia se biaah karies. Tab oe bhie mar gail biena larkan ke. Aur aisahie tiesara waala aurat se biaah karies, aur ekwan bhie, bakie sab mar gail aur ekko bhaai se larkan na bhail. Tab ant me aurat bhie mar gail.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Oesab bolies: „Ab hamlog maangiela tose koetjh poetjhe. Djab ie manai log djie oethie, tab aurat kekar rahie? Sab saato aadmie to okar biehauta raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tab oe bolies: „Toelog Parmeswar ke baat aur okar saktie na djaane hai. Ohie khaatien toelogan oelta baat poetjhe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Djab iensaan logan djie oethiega tab oesab djaise swarag ke parie logan biaah na kariega.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Oe bolies: „Aur djie oethe ke biese me, toelog to Mosas ke kaahaanie parhle hai, kie oe kaise djarat djhalaasie me ekgo aawaadj soenies raha. Parmeswar hoewa par ose bolies raha: ‘Ham tor baap-daada Aabraaham ke Parmeswar baatie, okar beta Iesaak ke, aur okar pota Jaakob ke bhie.’ ");
INSERT INTO hnsNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Oe thoro maral manai ke Parmeswar hai? Okar khaatien maral manai log djienda hai.” Oe bolies: „Toelog Parmeswar ke baat ekdam se oelta samdjhe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hoewa par ekgo dharam ke parhal waala raha, aur oe soenies raha kaise Sadoesie log Jiesoe se moeh laraawat raha. Oke attjha lagal kaise Jiesoe oesabke djabaab deis raha. Tab oe ose poetjhies: „Parmeswar ke sab se barka hoekoem kaun hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tab oe bolies: „Sab se barka waala hai: ‘E Israel log, soen. Hamlogke Prabhoe ekahie Parmeswar hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Toke tjaahie oke aapan diel bhar, tan-man aur sab boeddhie aur saktie se pjaar kare ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aur doesara barka hoekoem hai: ‘Djaise toe apane ke tjaahe hai, oisane ek doesare ke pjaar kar.’ Ie doeno se auro barka hoekoem na hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tab parhal aadmie bolies: „Ha, maastar, toe satj bolle hai. Prabhoe ekahie Parmeswar hai, oke tjhorke ekko doesar na hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Oke sab rakam daan dewe aur baliedaan kare ke attjha hai. Bakie oke aapan diel bhar se, sab boeddhie aur saktie se pjaar kare ke, aur doesare ke tjaahe ke djaise apane ke auro barhia hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Oe dekhies kie aadmie sab baat thiek se samdjhe hai. Tab bolies: „Toe Parmeswar ke raadj se doer na baate.” Ohie dien se koi na maangies oke baat par pakare. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Djab Jiesoe Parmeswar ke mahal ke angana me manai log ke siekhaawat raha, tab oe poetjhies: „Dharam ke parhal logan toelogke siekhaawe hai kie Parmeswar ke aane waala Kriest Daawied ke aulaad hai. Toelog ka sotje hai, ekar matlab ka hai? ");
INSERT INTO hnsNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daawied to Pawietr Aatma ke dwaara Kriest ke biese me bolies raha kie: ‘Prabhoe Parmeswar hamaar Prabhoe se bolies: Aaw hamaar dahiena bagal baith dja djab talak ham tor doesman log ke tor gor ke nietje na karab.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Oe bolies: „Djab Daawied Kriest ke aapan Prabhoe bolaawat raha, tab dekha hai kie oe na khaalie okar aulaad hai, bakie ese djaada.” Dher manai logan ke Jiesoe ke baat bahoet attjha lagat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jiesoe oesabke aur aage siekhaais kie: „Dharam ke parhal logan ke tjaal-tjalan dekhke apane ke dhokha na khawaaw. Oesabke barhia lage hai ghoem ghoemke aapan lamba kapra se aapan oetja dardja dekhaawe ke. Oesab khoesie howe hai djab badjaar me manai log oesabke barka maanke paalagie kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aur djab oesab partjaar ke ghar kie to nauta dja hai, tab oesabke attjha lage hai sab se barhia djagaha par baithe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Oesab wiedhwa log ke ghar-dwaar tjalaakie se harap lewe hai. Aur oesab der talak praatna kare hai dekhaawe khaat kie oesab ketana bhaktie hai. Bakie Parmeswar oesabke ekwan se djaada sadja deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jiesoe paisa ke baakas ke nagietj baithal raha. Eman manai logan paisa daarat raha Parmeswar khaatien. Oe dhiaan lagaaike taakat raha kaise manai log aawat djaat raha aur kopro ke paisa oman daarat raha. Dher dhanie logan tjaanie ke paisa daaries. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tab ekgo garieb wiedhwa bhie aail, aur oe doeigo kopro ke paisa baakas me daaries. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tab Jiesoe aapan tjela log ke sankiaaike bolies: „Dekhle? Ham toelogse boliela kie ie garieb wiedhwa oe sab dhanie log se djaada daaries hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Oesab to aapan dher me se thora se deis, bakie wiedhwa ke thora se raha, tabbo sab deis. Ie okar sab sauda paanie ke paisa raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Djab Jiesoe aur okar tjela log Parmeswar ke mahal ke angana me se djaat raha, tab oman se ekgo bolies: „He Maastar, dekh mahal ketana biesaal hai! Ketana barka barka ieta!” ");
INSERT INTO hnsNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tab oe bolies: „Toke ie barka mahal attjha lage hai? Ham tose bataaila kie ie sab ekdam se naas kar dewal djaai, aur toe ekko ieta tarke oeppar na dekhiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ekare baad djab oelog Djaitoen pahaar par pahoetjal, tab Jiesoe Parmeswar ke mahal ke sodjhe djaaike baith gail. Okar lage khaalie Petras, Jaakobas, Johaanas aur Andreas raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tab oelog poetjhies: „Toe hamlogse bataai sakiehe kie tor baat kab poera hoiga? Aur hamlog kaise djaan sakab kie ie sab tjiedj kab poera hoiga?” ");
INSERT INTO hnsNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tab oe siekhaawe lagal kie: „Batjaaike rahiehe kie toelogke koi na bahakaawe. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Dher manai aaiga hamaar naam leike boliega kie: ‘Ham Kriest baatie.’ Aur oesab dher djane ke bahakaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aur djab toelog soeniehe kie soerdjaatie log laraai kare hai, tab toelog na deraihe. Ie sab howe ke tjaahie, bakie djoeg ke ant abbe na rahie. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Djaatie logan doesar djaatie log se laraai kariega aur ek raadj doesar raadj logan ke sataaiga. Hia hoewa bhoeidol hoiga aur manai log khaai biena mariega. Ie sab tjiedj se djoeg ke ant ke moesiebat soeroe hoiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Oe bolies: „Bahoet batjaaike rahiehe. Toelog hamaar rasta par tjale hai, ohie se manai log toelogke djabar-djastie se djadj ke aage ledjaai. Aur Israel ke partjaar ke ghar me oesab toelogke tjamotie se maariega. Toelogke laat aur raadja logan ke aage thara howe ke parie djaise toelog hamaar tjela baate. Oe mauka par toelog oesabse hamare baare me bataihe. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Aur djoeg ke ant se pahiele doenia bhar ke djaatie log ke khoes khabar hamaar biese me soene ke tjaahie. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Djab koi toelogke pakarke djadj ke aage ledjaai, tab sotj-phiekier na kariehe kie toe hoewa par ka boliehe. Toe baat na bataihe, bakie tor dwaara Pawietr Aatma sab baat bataaiga. Ohie aapan baat tose bolwaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dje hamaar rasta par tjaliega, okar bhaai oke pakarwaaike marwaai dhaarie, aur baap logan bhie aapan larkan sanghe ohie kaam karie. Larkan apane maai-baap ke doesman hoike oesabke marwaai dhaariega. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Toelog hamare me bieswaas kare hai, ohie khaat sab koi toelogke djaran kariega. Bakie dje ant talak aapan bieswaas pakarle rahie, oke Parmeswar batjaai leiga.” ");
INSERT INTO hnsNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Oe bhie bolies: „Ek ghienna naas kare waala tjiedj thara karal djaaiga djaaha mienaahie hai. Dje ie baat parhiega, oke tjaahie ekar matlab pahietjaane ke. Djab toelog oe tjienha dekhiehe tab Joedea diehaat ke manai log ke tjaahie pahaar lage bhaag djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dje aapan tjhat par rahie, oke na tjaahie pahiele ghar me djaaike aapan tjiedj lewe khaatien bakie toerant bhaag djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aur dje aapan khet me rahie, oke bhie na tjaahie ghare djaai ke kapra lewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Djaun aurat logan ke larka hoiga aur djaun aapan larka ke doedh piaawat rahie, oesabke khaat oe tem par auro moeskiel rahie. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Praatna kar kie toelogke thandha ke tem me bhaage ke na parie. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Djab se Parmeswar doenia banaais hai ab talak etana kharaab moesiebat na bhail hai, aur kabhie na rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Djab Parmeswar na sallaah karies raha ie doekh ke tem tjhota kare ke, tab koi na batj sakat. Bakie aapan tjoenal manai logan khaatien Parmeswar oe tem kamtie kariega. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Djab oe tem par koi toelogse bolie: ‘Are, dekh, Kriest aai gail!’ kie to: ‘Dekh, oe hoewa hai!’ tab na bieswaas kariehe. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Koetjh manai log aaike djhoetthe ke bolie kie: ‘Ham Kriest baatie,’ kie to ‘Ham Parmeswar ke ek sanesia baatie.’ Oelog sab rakam tjienha dekhaaiga aur barka kaam kariega. Aur djab hoi sakat tab oesab Parmeswar ke tjoenal manai log ke bhie bahakaawat. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ohie se batjaaike rahiehe. Ham ie sab baat howe se pahiele toelogse bataai deila.” ");
INSERT INTO hnsNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Jiesoe aur aage bataais: „Djab ie moesiebat ke tem biet djaai, tab aasmaan ke saktie hieliega. Soeroedj aur tjaan na dekhaaiga aur tarai aasmaan me se gier djaai. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tab manai logan iensaan ke Beta ke aawat dekhiega. Oe baadar par aapan barka saktie aur maahaanta leike aaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tab oe aapan parie log ke pathaaiga aapan tjoenal manai log ke doenia ke tjaaro kona aur aasmaan ke tjaaro or se ekattha kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Adjier ke per ke dekh aur ie baat jaad kar. Djab daarie patta biege lage hai, tab toelog djaan djaihe kie garam ke tem aawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aisane djab toelog dekhiehe kie hamaar baat poera howe hai, tab toelog djaan djaihe kie djoeg ke ant aawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ham toelogse satj boliela kie djaun manai log ie sab tjiedj howat dekhiega, oesab djienda rahiega djab talak hamaar sab baat na poera hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ek dien aasmaan aur dhartie miet djaaiga, bakie hamaar baat kabhie na mietiega. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Koi na djaane hai kie ie sab tjiedj kaun dien par aur kai badje hoiga. Swarag ke parie log na djaane hai, aur tjaahe ham Parmeswar ke Beta baatie, tabbo ham bhie na djaaniela. Khaalie Pieta Parmeswar ie baat djaane hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ohie se batjaaike rahiehe aur praatna karte rahiehe. Toelog na djaan sake hai ham kab aabe. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ham lautke aabe djaise ekgo aadmie djaun doesar des gail. Tab oe djaai se pahiele ghar-dwaar aapan goelaam log ke oeppar saup deis. Oe har ek ke kaam deis kare ke, aur oe rakhwaala se bolies: ‘Tjaaro or aakhie garaai rahiehe.’ Tab oe tjal gail.” ");
INSERT INTO hnsNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Oe bolies: „Ohie se toelogke bhie tjaahie tajaar rahe ke. Ham ghar ke maaliek ghat baatie, aur toelog na djaane hai kie ham kab lautke aabe. Hoi sakie kie ham raat ke, kie to bietj raat ke, kie to djab moerga tjiella hai, kie to saberaha aabe. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tajaar rahiehe nahie to ham atjakke me aaike toelog ke soetal paai. ");
INSERT INTO hnsNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Djaise ham toelogse boliela, aisane ham sab koi se bolab: Na soetiehe bakie batjaaike rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Doei rodj rahie gail raha Paasan ke tiewhaar ke aur Biena-khatta-piesaan-ke-bret ke tiewhaar ke. Barka agwan aur dharam ke parhal waalan mauka khodjat raha Jiesoe ke pakarwaaike marwaai dhaare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Oesab bolies: „Tiewhaar ke tem par na kare k'hoi, nahie to manai log halla matjaai dei.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Oe dien par Jiesoe Betaania gaaw me raha. Oe ekgo aadmie ke ghar me bhodjan karat raha. Oe aadmie Siemon Korhia waala bolaawal djaat raha. Tab ekgo aurat bahoet mahanga poera nardas ke mahakauwa leike Jiesoe ke paas aail. Mahakauwa ekgo alabastar ieta ke botal me raha. Tab oe botal ke kholies aur sab mahakauwa Jiesoe ke moerie par oedjhoel deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tab koetjh manai log ie dekhke goessaai lagal aur bolies: „Kaahe ke auratia etana mahanga tjiedj naksaan kare hai? ");
INSERT INTO hnsNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bestar oe betj dewat, tab tien sau tjaanie ke paisa se djaada garieb logan khaatien bator sakat.” Aisahie oesab oke daaties. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bakie Jiesoe bolies: „Oke tjhor de. Toelog kaahe ke okar oeppar goessa hai? Oe hamaar khaat bahoet barhia kaam karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Garieb logan sada rahie, aur djab toelog mangiehe tab hardam bhalaai kar sakiehe. Bakie ham sada ke lieje toelogke sanghe na rahab. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ie aurat karies hai djaun oe kar paais. Oe hamaar moerie par mahakauwa oedjhlies hamaar dehie tajaar kare ke mattie dewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aur ham toelogse satj boliela kie doenia bhar me djaaha khoes khabar hamare biese me ailaan karal djaai, hoewa par manai log okar baare me bhie batiaaiga kie oe ka karies hai. Aisahie dher manai log oke jaad kariega.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Joedaas Eskaariot Jiesoe ke baaraago tjoenal tjela me se ekgo raha. Bas oe barka agwan ke lage gail baat-tjiet kare kaise oesab Jiesoe ke pakar sakat. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tab oelog bahoet khoesie bhail aur oke koetjh paisa waada karies. Aur oe mauka khodje lagal Jiesoe ke baare me tjoegalie kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tab Biena-khatta-piesaan-ke-bret ke tiewhaar aail. Pahiela dien par sab Israel ke djaatie logan Paasan ke tiewhaar manaawe khaatien bhie ekgo bhera ke battja maarke bhoedjke khaat raha. Tab Jiesoe ke tjela log ose poetjhies: „Toe kaaha maange hai Paasan ke bhodjan kare? Tab hamlog hoewa par tajaar karab.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tab oe aapan tjela log me se doeigo se bolies: „Dja sahar, tab toelog ekgo aadmie ke dekhiehe djaun ek gogliet paanie ledjaat rahie. Okar pietjha kariehe. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aur djaaha oe bhiettar djaai, oe ghar ke maaliek se poetjhiehe: ‘Hamlogke maastar maange hai djaane kie oe hamlogke sanghe kaun kamra me Paasan ke bhodjan kar sakie.’ ");
INSERT INTO hnsNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tab maaliek toelogke ghar me ek barka oeppar kamra dekhaai. Hoewa par sab tjiedj toelogke khaat rakhal rahie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tab oe doeno sahar me gail aur djaise Jiesoe bolies raha, oisahie sab bhail. Aur oesab Paasan ke bhodjan tajaar karies. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tab djab sandjha bhail tab Jiesoe aapan tjela log ke sanghe kamra me gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tab khaite me oe bolies: „Ham toelogse satj boliela kie toelog me se koi hamlogke sanghe bhodjan kare hai djaun hamke tjoegalie karie.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tab tjela log ke sotj maar deis aur sab poetjhe lagal: „Ham thoro baatie?” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tab oe bolies: „Baaraago me se ek djane aise kariega, tjaahe oe hamaar sanghe bret soerwa me borke kha hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Djaise Parmeswar ke poestak me liekhal hai, aisane iensaan ke Beta mariega. Bakie tjoegalie kare waala ke oeppar bahoet kathien moesiebat pariega. Bestar rahat kie oe kabhie na paida howat.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Djab sabhan baithke bhodjan karat raha tab Jiesoe bret leike Parmeswar ke dhanbaad deis aur toekkara toekkara toerke aapan tjela log ke baaties. Oe bolies: „Khaai le, ie hamaar dehie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tab oe ekgo gielaas wien oethaais, Parmeswar ke phien se dhanbaad deis aur aapan tjela log ke deis. Aur har ek thora se pies. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tab oe bolies: „Ie hamaar khoen hai. Ese Parmeswar ke baat-tjiet poera hoiga, aur dher manai log khaatien bahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Oe bolies: „Ham toelogse satj boliela kie ham tanko wien na piebe djab talak ham naawa rakam se Parmeswar ke raadj me piebe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tab sabhan gaana gaais Parmeswar ke aadar kare khaatien. Ekare baad oesab Djaitoen pahaar par gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tab Jiesoe bolies: „Parmeswar to aapan poestak me liekhwaais hai: ‘Ham bhera ke tjaraawe waala ke maarab, aur sab bhera tjaaro or bhaag djaaiga.’ Ohie se ham djaaniela kie toelog sab koi hamke tjhor deihe. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bakie djab ham djie oethaawal djaab tab ham toelogse pahiele Gaalielea diehaat djaab.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tab Petras ose bolies: „Saait ielog toke tjhor dei, bakie ham na.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tab oe bolies: „Ham to djaaniela kie aadj raat ke moerga ke doei dafe bole se pahiele toe tien dafe boliehe kie toe hamke na djaane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bakie Petras auro djor se bolies: „Tjaahe hamke tor sanghe mare ke parie, tabbo ham aisan baat kabhie na bolab.” Aur ekwan bhie aisahie bolies. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tab sabhan Getsemaane naam ke djagaha me gail. Tab Jiesoe bolies: „Toelog hia baith, aur ham djaaila praatna kare.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Oe Petras, Jaakobas aur Johaanas ke legail. Tab oke bahoet ghabaraahat aur dar lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Oe bolies: „Ham etana oedaas baatie kie ham mar djaai saktie. Toelog hia rahiehe aur na soetiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tab oe aur aage gail aur djamien par gierke praatna kare lagal. Oe bolies: „Pieta djie, djab hoi sake hai tab hamke aane waala doekh me se batjaai le. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Abba, he Pieta, toe sab koetjh kar sake hai. Ie doekh hataai de. Bakie aapan man waala kar, na hamaar waala.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tab djab oe lautke aail tab dekhies kie tieno tjela soetal hai. Tab oe Siemon Petras se bolies: „E Siemon, soet gaile? Ek ghanta onghaai na rok paile? ");
INSERT INTO hnsNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Djaagal rahoe aur praatna kar nahie to toelog bahakaawal djaihe. Aatma tajaar hai bakie dehie latjaar hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tab oe phieno tjal gail aur ohie baat doharaaike praatna karies. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tab djab oe lautke aail tab oesabke phieno soetal paais. Oesabke bahoet onghaai lagal raha aur oesab na djaanat raha kie ose ka bole. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tab djab oe tiesara dafe lautke aail tab bolies: „Ab toelog soetke soestaai sakiehe. Ham don hoi gailie. Attjha, ab oesab hamme pakariega. Iensaan ke Beta kharaab manai ke haath me saup dewal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Oeth, tjoegalie kare waala aawe hai, tjalie dja okar lage.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Abbe Jiesoe batiaite raha tab etane me Joedaas aai gail. Oe Jiesoe ke baara tjela log me se ekgo raha. Ek djhoend mardaana log talwaar aur danda leike okare sanghe aail. Barka agwan, dharam ke parhal waalan aur Israel ke barkwan oesabke pathaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Joedaas oelogse bolies raha: „Ham ose bhet karke tjoemma debe. Ohieke pakariehe aur oke na bhaagan deihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tab oe toerant Jiesoe lage gail aur bolies: „Maastar djie, toe kaise baate?” Aur oe oke tjoemma deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tab oesab Jiesoe ke pakar leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tab ekgo tjela aapan talwaar oethaaike sab se barka agwa ke goelaam ke kaan kaat leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Aur Jiesoe oesabse bolies: „Ka, toelog talwaar aur danda leike aile hamke pakare khaat? Ham daakoe thoro baatie? ");
INSERT INTO hnsNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ham rodj Parmeswar ke mahal ke angana me toelogke siekhaawat rahielie, bakie toelog hamme na pakarle. Parmeswar ke poestak me liekhal hai kie toelog aapan kaam hamaar sanghe ie rakam kariehe. Aur ab ie baat poera howe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bas sab tjela log oke akele tjhorke bhaag gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hoewa par bhie ekgo naudjawaan raha. Oe khaalie bietjhauna lapetke Jiesoe ke paatjhe gail raha. Tab aadmie log ohoeke pakar leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Bakie oe aapan bietjhauna tjhorke nange bhaagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tab oesab Jiesoe ke sab se barka agwa ke ghare legail. Hoewa par sab barka agwan, Israel ke barkwan aur dharam ke parhal logan ekattha bhail. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petras doer se Jiesoe ke paatjhe tjalat raha. Aisahie oe sab se barka agwa ke ghar ke angana me pahoetjal. Aur oe gail rakhwaalan ke bietj me baithe aur aagie ke lage garmaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ohie tem par ghar me barka agwan aur sabha bhar maangat raha Jiesoe ke kasoer dewe. Tab oesab oke marwaai sakat. Bakie oesab koetjh na sotjke bol paais. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dher manai log okar biese me djhoeth bolies, bakie oesabke gawaahie ek na raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tab ekaatgo djhoettha log oethke bolies: „Hamlog soenlie hai kie oe Parmeswar ke mahal ke biese me kharaabie bolies hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Oe to bolies hai kie: ‘Ie mahal manai log banaais hai. Bakie ham oke toer dhaarab, tab tien rodj baad ham ekgo doesar banaabe, aur oe manai ke banaawal na rahie.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bakie djhoettha log ie gawaahie ke biese me bhie ek na raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tab sab se barka agwa aage djaaike thara bhail. Oe Jiesoe se poetjhies: „Toe soene hai ie manai log toke kaun kasoer dewe hai? Toe djabaab na deihe?” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bakie Jiesoe koetjh na bolies. Tab oe poetjhies: „Toe maahaan Parmeswar ke tjoenal waala Kriest aur okar Beta baate?” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tab Jiesoe bolies: „Ha, ham ohie baatie, aur toelog iensaan ke Beta ke sab se maahaan Waala ke dahiena bagal baithal aur baadar par swarag me se aawat dekhiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bas oe goessa ke maare aapan kapra tjierke aur bolies: „Hamlogke doesar gawaahie djaroerie na hai! ");
INSERT INTO hnsNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Toelog soenle baate kaise oe apane ke Parmeswar ke baraabar karke okar bedjatie kare hai. Toelog ka bole hai?” Tab sab bolies: „Oe maut ke sadja laaik hai!” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tab kauno kauno okar oeppar thoeke lagal. Oesab okar aakhie kapra se baanh deis, tab oke ghoesa se maarke poetjhies: „Dekhaaw kie toe sab djaane hai. Ab bataaw ke toke maaries hai.” Aur rakhwaalan bhie okar moeh par maaries. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ohie tem par Petras nietje ghar ke angana me baithal raha. Tab sab se barka agwa ke ekgo goelaam aurat hoewa aail. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Djab oe Petras ke dekhies kie oe apane ke garmaawat raha, tab oke taakke bolies: „Toe bhie Naasaaret waala Jiesoe sanghe rahiele.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bakie Petras bolies: „Na, ham na djaaniela aur na samdjhiela toe ka bole hai.” Aur oe dwaar lage djaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tab naukaraanie oke phien se dekhies aur hoewa ke manai logan se bolies: „Ie bhie okar djhoend me ke hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tab oe phieno bolies: „Na, ham na baatie.” Tab koetjh der baad hoewa ke manai log ose bolies: „Ha, oe sattje bole hai, toe ohie me ke ekgo baate. Toe to bhie Gaalielea diehaat ke baate.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bakie oe apane ke saraape lagal aur kasam khaaike bolies kie: „Djaun aadmie ke baare me toelog batia hai, ham oke na djaaniela.” ");
INSERT INTO hnsNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bas ohie laage doesara dafe moerga bolies. Tab oe jaad karies Jiesoe ose ka bolies raha kie: „Ham to djaaniela kie moerga ke doei dafe bole se pahiele toe tien dafe boliehe kie toe hamme na djaane hai.” Tab Petras rowe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Djab saber bhail tab barka agwa log, doesar barkwan, dharam ke parhal log aur sab doesar sabha waalan Jiesoe ke baare me sallaah kar tjoekal raha. Tab oesab okar haath baanhke aur oke laat Pielaatas ke paas ledjaaike okar haath me saup deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tab oe khod khodke Jiesoe se poetjhies: „Toe Israel ke raadja baate?” Tab oe bolies: „Toe apane bolle hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tab barka agwan oke dher tjiedj ke biese me kasoer dewe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tab Pielaatas ose bolies: „Dekh oesab ketana kharaab baat tor biese me bole hai. Toe apane ke na batjaihe?” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bakie oe koetjh na bolies. Tab Pielaatas thak hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aise raha kie har ek tiewhaar me Pielaatas ekgo djahalia ke tjhor dewat raha dje ke manai logan maangat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ohie tem par djahal me ekgo aadmie raha. Oe doesar log ke sanghe Roma soerdjaatie se laraai karke koi ke maar dhaaries raha. Okar naam Baaraabaas raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tab djhoend logan aaike Pielaatas se bole lagal: „Hamlog maangiela kie toe ekgo djahalia ke tjhor deihe.” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tab oe poetjhies: „Toelog maange hai kie ham Israel ke raadja ke tjhor dei?” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Oe to djaan gail kie barka agwan Jiesoe ke djaran ke maare okar haath me saup deis raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bakie barka agwan djhoend ke siekhaais Baaraabaas ke tjhorwaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tab oe manai log se poetjhies: „Tab ham ie aadmie se ka karie? Toelog to oke Israel ke raadja bolaawe hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tab manai logan tjiellaaike bolies: „Oke kroes par tjaharaai de!” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tab oe phieno poetjhies: „Kaahe khaat? Oe kaun kharaab tjiedj karies hai?” Tab oesab auro kaske tjiellaaike bolies: „Kroes par tjaharaai de!” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tab oe sotjies kie: „Bestar ham manai log ke hiettjha poera kar dei.” Tab oe Baaraabaas ke tjhorwaai deis. Aur oe Jiesoe ke tjamotie se marwaaike soerdjaatie ke haath me saup deis kroes par tjaharaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tab soerdjaatie logan Jiesoe ke laat ke mahal ke angana me legail. Hoewa par laat hardam djadj ke kaam karat raha. Oesab bhie sab doesar soerdjaatie log ke bolaais. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tab oesab oke ekgo laltjhau koerta pahienaai deis djaise ekgo raadja ke. Aur oesab bhie ek kaata waala lattie goethke ekgo raadja ke moekoet ghat okar moerie par dhar deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tab oesab thatha oeraaike ose bolies: „He Israel ke raadja, aap kaise rahielo?” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tab oesab ekgo narai se okar moerie par maaries aur bhie okar oeppar thoekies. Oesab djhoetthe ke gaathie par gier paral okar aadar kare khaat. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tab djab oesab don hoi gail tab laltjhau kapra oetaarke aur okar kapra pahienaai deis. Tab oesab oke sahar ke bahare legail kroes par tjaharaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Djaite me soerdjaatie log ekgo aadmie ke djabar-djastie kroes ke khambha dhowaais. Okar naam Siemon raha aur oe Sierene sahar ke raha. Oe Aaleksaandar aur Roefoes ke baap raha. Oe khet alang se Jeroesaalem sahar me aawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aisahie oesab Jiesoe ke ekgo Golgota naam ke djagaha par legail. Ie naam ke matlab hai „‘Khoprie ke djagaha.”’ ");
INSERT INTO hnsNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tab oesab oke wien deis pieje ke. Oman mere dawaai ghoral raha piera patwaawe khaatien. Bakie oe na maangat raha pieje. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tab oesab oke kroes par thok deis. Aur oesab okar kapra oetaarke djoewa khelke baat leis. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Oe tem par nau badjal raha sabere. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Okar moerie ke oeppar dekhaat raha kaun kaaran se oe maar dhaaral gail. Hoewa par liekhal raha: ISRAEL KE RAADJA. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oe tem par doeigo daakoe Jiesoe ke agal-bagal bhie ek ek kroes par thokal gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ie rakam se Parmeswar ke ekgo liekhal baat poera bhail. Oe dher dien pahiele liekhwaais raha: „Oesab oke badmaas manai log ke sanghe gienies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Djaun manai log hoewa se paas howat raha, oesab okar bedjatie karat raha. Oesab moerie hielaaike bolies: „Dekh, Parmeswar ke mahal toere waala! Toe to tien rodj me oke phien se banaai deite? ");
INSERT INTO hnsNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tab kroes par se oetarke apane ke batjaai le.” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aur barka agwan aur dharam ke parhal waalan bhie tiebolie maarat raha. Oesab apane me bolies: „Oe doesar log ke batjaais hai, bakie apane ke na batjaai paawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ie apane ke Kriest, kie to Israel ke raadja banaais hai. Djab hamlog oke kroes par se oetarat dekhab tab hamlog okare me bieswaas karab.” Aisahie bhie kroes par ke daakoe log oke tiebolie maarat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tab baara badje des bhar me andhiaar hoi gail tien badje talak. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ohie tem par Jiesoe gohoraais: „Eloi, Eloi, laama saabaktaanie?” Ekar matlab hai: „Hamaar Parmeswar, hamaar Parmeswar, toe hamke kaahe ke tjhor deile hai?” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tab hoewa ke koetjh manai log ie baat soenke bolies: „Soen! Oe Elia ke bolaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tab koi koetjh laaike aur khatta wien se bhiedjaaike ekgo daarhie par lagaaike oke tjoesaais. Oe ekwan se bolies: „Agorie dja, dekhe k'hoi kie Elia aawe oke batjaawe kie na.” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tab ekare baad Jiesoe kaske tjiellaais aur aapan praan tjhor deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ohie tem par Parmeswar ke mahal ke sab se pawietr djagaha ke parda ekdam se oeppar se nietje talak phat gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kroes ke sodjhe soerdjaatie ke barkwa thara raha. Djab oe dekhies kie Jiesoe kaise mare hai, tab bolies: „Sattje ke, ie aadmie Parmeswar ke ek Beta raha!” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Doerie me ekaat aurat bhie taakat raha. Oman Magdaala sahar ke Maria raha, aur tjhota Jaakobas aur Josas ke maai Maria aur Saalome bhie. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Oesab hardam Jiesoe ke sanghe tjalat raha aur okar sewa karat raha djab oe Gaalielea diehaat me raha. Aur dher doesar aurat Jiesoe ke sanghe Jeroesaalem sahar aail raha. Oesab bhie hoewa thara raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Oe dien Israel ke djaatie log sab tjiedj tajaar karat raha sabat ke dien khaatien djaun biehaan bhare howat. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tab ekgo aadmie aail. Oe Aariematea sahar ke raha. Israel ke barkwan me ke oe ekgo oetja dardja waala raha. Oe Parmeswar ke aane waala raadj agorat raha. Okar naam Josaf raha. Aur oe hiemmat baanhke laat Pielaatas ke paas gail Jiesoe ke lahaas maange khaat. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tab Pielaatas thak hoi gail kie oe etana haalie se mar gail hai. Oe soerdjaatie ke barkwa ke bolaais aur poetjhies: „Oe sattje ke mar gail hai?” Tab barkwa bolies: „Djie ha.” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tab oe Josaf se bolies: „Toe okar lahaas ledjaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tab Josaf tjal gail kapphan kiene. Oe Jiesoe ke lahaas kroes par se oetaarke aur kapphan me lapeties, tab ledjaaike ekgo kabar me dharies. Oe kabar djaise ekgo tjhota kothrie ghat pahaar me banaawal raha. Tab oe ekgo gola ieta dhakelke kothrie ke dwaar band kar deis. ");
INSERT INTO hnsNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdaala ke Maria aur Josas ke maai dekhies kie Jiesoe ke lahaas kaaha dharal dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Djab sabat ke dien biet gail raha, tab Magdaala sahar ke Maria aur Jaakobas ke maai aur Saalome koetjh mahakat dawaai kienies Jiesoe ke lahaas me lagaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tab hapta ke pahiela dien djab ghaam oegal tab sabhan gail kabar lage. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Rasta me oesab apane me poetjhies: „Ke hamlog khaatien kabar ke ieta hataai sake hai?” Oe to bahoet barka ieta raha. Tab djab oesab hoewa pahoetjal tab dekhies ieta hataawal hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tab oesab kabar ke bhiettar gail, aur dekhies dahiena kait ekgo naudjawaan oeddjar kapra pahienke baithal hai. Tab oesab tjauk gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tab naudjawaan bolies: „Na dera. Toelog Naasaaret ke Jiesoe ke khodje hai djaun kroes par maar dhaaral gail. Oe hia na hai, oe djie oethaawal gail. Dekh, oesab oke hia dharies raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Oe bolies: „Dja okar tjela log aur Petras se bataai deihe kie oe toelogse pahiele Gaalielea diehaat djaaiga. Hoewa par toelog oke bhetaihe djaise oe bolies raha.” ");
INSERT INTO hnsNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Auratian dar ke maare kaapat raha aur kabar me se niekarke haalie se bhaag gail. Oesab koi se koetjh na bolies, oesab to etana tjauk gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Djab Jiesoe hapta ke pahiela dien par djie oethal, tab pahiele oe apane ke Magdaala sahar ke Maria ke dekhaais. Oe okar oeppar se saatgo bhoet niekaaries raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tab aurat djaaike ekwan se bataais djaun hardam Jiesoe ke saath tjalat raha. Oesab abbe talak rowat raha aur sokh manaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tab oe bolies kie: „Prabhoe djieje hai aur ham oke dekhlie baatie!” Bakie oesab bieswaas na karies. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ekare baad doei doesar tjela log Jeroesaalem sahar se diehaat me tjalat djaat raha. Tab Jiesoe apane ke oesabke dekhaais. Oe doesar rakam dekhaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tab djab oe doeno djaan gail kie ohie hai, tab oelog sahar laut gail aur ekwan se bataais. Bakie oesab phien se na maangies bieswaas kare. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ekare baad Jiesoe apane ke aapan gjaara tjela ke dekhaais djab oesab bhodjan karat raha. Oe oesabke daatke bolies kie: „Toelog be-bieswaasie baate aur toelogke diel na khoelal hai. Koi koi dekhies hai kie ham djie oethaawal baatie, aur tabbo toelog oesabke baat na maangat rahiele bieswaas kare.” ");
INSERT INTO hnsNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Oe bhie bolies kie: „Dja doenia bhar me khoes khabar hamaar baare me sab koi se bataai deihe. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dje toelogke baat bieswaas karie aur dopoe lei, oe batj djaai. Bakie dje na bieswaas karie, oe Parmeswar ke sadja paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aur Parmeswar bieswaasie log ke koetjh tjienha deiga dekhaawe khaat kie oe oesabke sanghe hai. Oesab hamaar naam se bhoet bhagaaiga, oesab bhaasa batiaai sakiega djaun kabhie na soenies hai. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Djab saap oesabke kaat lei aur djab oesab koetjh djahar pie lei, tab oesabke koetjh na hoi. Aur djab oesab bemarian par haath rakhie, tab oelog attjha hoi djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tab djab Jiesoe ie sab baat bataai tjoekal raha, tab oe swarag me lewal gail. Aur oe Parmeswar ke gaddie par okar dahiena bagal baith gail. ");
INSERT INTO hnsNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tab okar tjela log djaaike sagaro khoes khabar ailaan kare lagal. Aur Prabhoe oesabke sahaaita karat raha. Oelogse atjambho kaam karwaaike oe dekhaawat raha kie oesabke baat satj hai.");
INSERT INTO hnsNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bhaai Teofielas djie, Dher djane maangat raha oe tjiedj ke biese me liekhe djaun Jiesoe Kriest hamlogke bietj me poera karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Aur okar saathie log soeroe se okar sab kaam dekhke aur okar baat soenaaike hamlogse ie sab tjiedj bataais hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ohie se hamahoe faisala karlie sab tjiedj soeroe se barhia se khodjke aapke khaatien ek poestak me liekhe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ham maangiela kie aap ekdam se samadjh djaiho kaisan sattja partjaar siekhlo hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Oe tem djab raadja Herodes Joedea diehaat me raadj tjalaawat raha, tab ekgo Israel djaatie ke agwa raha. Oe Aabia ke dal ke raha aur okar naam Sakaarias raha. Okar aurat sab se barka agwa Aaron ke aulaad raha aur okar naam Eliesaabet raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ie doeno aapan djiewan bietaawat raha djaise Prabhoe Israel ke djaatie log ke hoekoem deis raha. Ohie se oesab okar aakhie me bhala manai raha aur oesabke biese me koi koetjh kharaabie na bol sakat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aurat baadjhien raha aur ab oe doeno poerania hoi gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ek dien Aabia dal ke same aail Parmeswar ke mahal me agwa ke kaam kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tab agwa log ek rakam baadjie lagaaike Sakaarias ke tjoenies Prabhoe ke mahal me bhiettar djaaike lohbaan soelgaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sab djaatie log mahal ke angana me praatna karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tab lohbaan soelgaawe ke tafra ke dahiena bagal Sakaarias ke ekgo Parmeswar ke parie dekhaail. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Parie ke dekhke oe tjauk gail aur oke dar lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tab parie bolies: „Sakaarias, na dera, Parmeswar tor praatna soen leis. Tor aurat ke ekgo beta paida hoi aur toe okar naam Johaanas dharaihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Okar paidaais toke aur dher doesar manai logan ke bahoet khoesiaalie deiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ie larka Parmeswar ke aakhie me bara aadmie rahiega. Oke wien aur daaroe pieje ke mienaahie rahiega aur okar paidaais se pahiele oe Pawietr Aatma se bharal rahie. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Oe Israel djaatie me se dher djane ke phier se oesabke Prabhoe Parmeswar ke rasta par laaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Oe ose pahiele aaiga Parmeswar ke sanesia Elia ke aatma aur saktie se. Oe Israel djaatie ke baap aur beta log ke ek karwaaiga. Aur dje Parmeswar ke baat na maange hai soene, oesabke oe lautaarke barhia rasta par laaiga. Aisane oe ie djaatie ke tajaar kariega Prabhoe ke baat maan lewe khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tab Sakaarias poetjhies: „Ham kaise djaan sakab kie ie sab tjiedj sattje ke hoiga? Hamlog to doeno miela poerania hoi gailie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tab oe bolies: „Ham Gaabriejel baatie aur ham hardam Parmeswar ke aage thara rahiela. Oe hamme pathaais hai toke ie khoes khabar soenaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aur soen, toe hamaar baat na bieswaas karle, ohie se tor bolie band rahiega djab talak ie sab baat na poera hoiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Etane me bahare djanta log Sakaarias ke agorat raha. Oesab apane apane me poetjhe lagal kie: „Oe kaaha hoi etana derie lek?” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tab djab oe niekarke bahare aail, tab na batiaai paais. Aisahie oesabhan djaan gail kie pawietr djagaha me Parmeswar oke koetjh dekhaais hai. Bas oe maangies aapan haath se oesabke koetjh djanaawe, bakie okar moeh me se ekko bolie na niekaral. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ekare baad, djab okar kaam Jeroesaalem sahar me don hoi gail raha, tab oe Joedea diehaat me aapan ghare tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Koetjh same baad okar aurat ke larka paida howat, aur paatj mahienna khaatien oe aapan ghar me rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Oe bolies: „Aisane to Parmeswar hamme daaja karies hai hamaar saram mietaawe ke kie hamke larkan na raha.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tjhau mahienna baad Parmeswar aapan parie Gaabriejel ke Gaalielea diehaat me Naasaaret sahar pathaais. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Oe sanesa laais ek larkie khaatien djekar tjhekaai ek Josaf naam ke aadmie se bhail raha. Oe aadmie raadja Daawied ke aulaad raha. Larkie ke naam Maria raha aur oe kania raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Djab parie okar ghar me bhiettar gail tab bolies: „Maria, toe soekhie baate. Parmeswar tore saath hai aur oe toke bahoet bhalaai kariega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Larkie djab ie baat soenies, tab ghabaraai gail aur sotje lagal kie: „Ekar matlab ka hoi?” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tab parie bolies: „Maria, toe na deraihe. Parmeswar ke bhalaai tore sanghe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Soen, toke larka hoiga. Okar naam Jiesoe dharaihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Oe bara aadmie rahie aur sab se maahaan Parmeswar ke Beta bolaawal djaaiga. Prabhoe Parmeswar oke okar baap-daada Daawied ke raadj deiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Oe sab djoeg khaatien Jaakob ke aulaad logan par raadj tjalaaiga aur sada ke lieje raadja rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tab Maria poetjhies: „Ie kaise hoiga? Ham to kania baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tab oe bolies: „Pawietr Aatma sab se maahaan Parmeswar ke saktie se tore oeppar aaiga. Ohie khaatien djaun pawietr djiew tore me djanam paaiga, oe Parmeswar ke Beta bolaawal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aur soen, tor palwaar Eliesaabet ke boerhaapa par bhie ek beta paida hoiga. Oe tjaahe baadjhien aurat bolaawal djaat raha, tabbo iesaait tjhatwa mahienna me hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Parmeswar ke sab baat hardam poera howe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tab Maria bolies: „Ham Parmeswar ke goelaam aurat baatie. Djaise aap bolle hai, oisane hamse howe.” Tab parie okar lage se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Koetjh dien baad Maria apane ke haalie se tajaar karke Joedea diehaat ke pahaar ke ek sahar gail djaaha Sakaarias aur Eliesaabet rahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Djab oe oelogke ghare pahoetjal tab Eliesaabet se poetjhies: „Toelogan kaise baate?” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tab Eliesaabet djab Maria ke aawaadj soenies, tab larka okar pet me koede lagal. Oe same par Eliesaabet Pawietr Aatma se bhar gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tab oe khoesiaalie se bolies: „Toe sab se soekhie aurat baate! Aur Parmeswar tor larka ke bhie aasier-baat deiga! ");
INSERT INTO hnsNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bahoet biesaal hai kie hamaar Prabhoe ke maai hamaar paas aail! ");
INSERT INTO hnsNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Djaise ham tor aawaadj soenlie, oisane hamaar pet me larka khoesiaalie se koede lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Toe Prabhoe ke sanesa bieswaas karle, ohie se toe soekhie aurat baate. Parmeswar ke parie ke sab baat poera hoi djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tab Maria gaawe lagal kie: „Ham aapan diel bhar se Prabhoe ke goen gaaila. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Aur hamaar aatma Parmeswar ke biese me khoesiaalie manaawe hai. Oe hamaar batjaawe Waala hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Tjaahe ham okar nietja naukaraanie baatie, tabbo oe hamme jaad karies. Sab se maahaan Parmeswar hamaar khaatien bahoet biesaal kaam karies hai. Ohie se sab djoeg ke manai log hamme soekhie aurat bolaaiga. Okar naam pawietr hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Oe hardam daaja kariega dje okar aadar kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Oe aapan barka saktie dekhaais hai. Ghamandie logan ke oe khaderke baahar kar deis aur aisane oesabke bietjaar toerke ant kar deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Raadj tjalaawe waalan ke oe gieraai deis aur nietja waalan ke oetja karwaai deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bhoekha waalan ke oe attjha tjiedj se bhar deis aur dhanie waalan ke djhoere haath se pathaai deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Oe hamlogke baap-daada Aabraaham aur okar aulaad ke waada karies raha oesabke hardam ke lieje daaja kare ke. Ohie se oe Israel ke djaat ke sahaaita karies hai. Oesab to okar sewak logan hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria tien mahienna Eliesaabet hia rahie gail, tab aapan ghare laut gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tab djab Eliesaabet ke tem aai gail raha, tab oke ek beta paida bhail. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aur djab agal-bagal waalan aur palwaar soenies kie Parmeswar okare khaatien ketana barka daaja karies hai, tab oesab bahoet khoesie raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tab athwa rodj sabhan aail larka ke hakiekat kare aur maangat raha oke okar baap ke naam dharaawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bakie okar maai bolies: „Na, okar naam Johaanas rahie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tab oesab bolies: „Tor palwaar me ie naam koi ke na hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aur oelog okar baap ke sankiaaike poetjhies kie: „Toe larka ke kaun naam dharaihe?” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tab baap koetjh maangies liekhe khaatien aur liekhies: „Okar naam Johaanas hai.” Tab sabhan bahoet atjambho hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Toerante baap batiaai paais aur Parmeswar ke goen gaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tab oe gaaw ke manai ghabaraai gail aur sab Joedea ke pahaar waala diehaat ke log ie tjiedj ke biese me batiaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aur dje dje soenies, oesab sotje lagal kie: „Ie larka kaisan aadmie hoiga?” Oelog to samadjh gail kie Parmeswar ke saktie okare saath hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Oe same par larka ke baap Pawietr Aatma se bhar gail aur aagam bataawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Bolies: „Israel ke Prabhoe Parmeswar ke aadar howe. Oe aail aapan djaatie ke batjaawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Okar sewak Daawied ke aulaad me se oe hamlog khaatien ek maahaan batjaawe Waala ke djalmaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Prabhoe pahiele aapan pawietr sanesia log dwaara waada karies raha ");
INSERT INTO hnsNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kie oe hamlogke sab doesman ke saktie aur sab djarantoehan ke bas me se batjaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Oe hamlogke baap-daada log ke daaja karies aur jaad kare hai kie oe kasam khaaike Aabraaham se kaun pawietr baat waada karies raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Oe ose bolies raha kie: ‘Ham tor aulaad logan ke doesman ke haath me se batjaabe, djeme oesab be-dar se aapan djiewan hamaar khaatien bietaai. Tab oesab hamaar aakhie me pawietr aur bhala manai rahiega.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Baap aapan larka se bolies: „Beta soen, toe sab se maahaan Waala ke sanesia bolaawal djaihe. Toe to Prabhoe ke aage djaihe okar rasta tajaar kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Aur toe Israel ke djaatie log ke djanaihe kie Parmeswar oesabke paap ke tjhama deike batjaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Oe Jiesoe Kriest ke biese me bolies kie: „Parmeswar aapan diel bhar se hamlogke daaja kare hai. Ohie khaatien oeppar se Koi hamlogke lage aaiga. Oe djaise sabere ke soeroedj rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Oe aaiga oe manai log ke djotie dewe khaatien djaun andhiaar me hai aur maut ke bas me rahe hai. Aur bhie hamlogke Parmeswar ke rasta par sjaantie se tjalwaawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Larka djab barka howat raha, tab okar aatma ke auro saktie mielat djaat raha. Aur naudjawaan hoike oe djangal me gail rahe djab talak oe apane ke Israel ke djaatie ke na dekhaail. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Koetjh dien baad Roma ke maahaaraadja Agastas hoekoem deis kie: „Har ek des me sab koi ke tjaahie aapan naam liekhwaawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ie hoekoem dewal gail djab Kwierienias Sieria des ke oeppar raadj tjalaawat raha. Ie pahiela dafe raha kie sab manai ke tjaahat raha aapan naam liekhwaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sab aadmie ke tjaahat raha oe sahar djaai ke djaaha oelogke baap-daada rahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Aisane Josaf Naasaaret sahar Gaalielea diehaat se Joedea diehaat me Betlehem sahar gail. Hoewa par raadja Daawied paida bhail raha, aur Josaf okar ek aulaad raha. Oe aapan hone waala patie Maria ke legail djaun ke larka howat. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Tab djab oesab hoewa pahoetjal, tab Maria ke pahiela betwa paida bhail. Tab oe oke kapra me lapetke ekgo tjarahie me dhar deis. Oesabke khaat to doesar djagaha na raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Betlehem sahar ke bahare ekaatgo bhera tjaraawe waalan raha. Ohie raat ke oesab maidaan me aapan bhera log ke tjaraawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tab atjakke me ekgo Parmeswar ke parie oesabke lage thara bhail aur Prabhoe ke biesaal djotie dekhaail. Oelog bahoet deraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tab parie bolies kie: „Toelog na dera! Ham ailie hai ekgo khoes khabar bataawe aur sab djaatie bahoet khoesie rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aadj Daawied ke sahar me batjaawe Waala paida bhail hai. Oe Prabhoe aur Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Toelog ekgo tjhota larka paihe djaun kapra se lapetal hai aur tjarahie me dharal hai. Aisane toelog djaan djaihe kie ohie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tab atjakke me parie lage ek djhoend swarag ke parie raha. Oesab Parmeswar ke goen gaawe lagal kie: ");
INSERT INTO hnsNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Sab se oeppar waala swarag me Parmeswar ke aadar howe, aur dhartie par manai log ke sjaantie rahe. Oesabke to Parmeswar ke bhalaai mielal.” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tab djab parie log swarag me lautke gail raha, tab tjaraawe waalan apane me bolies kie: „Aaw tjalie Betlehem me dekhe djaun tjiedj Parmeswar hamlogke djanaais hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tab sabhan haalie se gail aur Maria, Josaf aur tjarahie me Larka ke paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tab djab oesab oelogke dekhies, tab bataais kie parie Larka ke biese me ka bolies hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aur hoewa ke manai log soenke bahoet atjambho bhail. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria ie sab baat attjha se jaad karies aur sotjies kie: „Ekar matlab ka hoi?” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tab tjaraawe waalan lautke gail aapan bhera lage. Oesab etana biesaal tjiedj dekhies aur soenies raha kie Parmeswar ke goen gaawat djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Athwa dien par Larka ke hakiekat bhail. Tab okar naam Jiesoe dharaawal gail, djaise parie okar djanam se pahiele Maria se bolies raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Djab Jiesoe tjaalies dien ke raha, tab okar maai-baap oke Jeroesaalem sahar me legail. Oe dien okar maai Parmeswar ke mahal me koetjh baliedaan karke safa karal gail. Aise Parmeswar aapan kaanoen me Mosas se liekhwaais raha. Oe baliedaan doeigo tjhota kaboettar raha. Oelog aapan Larka ke bhie legail Prabhoe ke dekhaawe khaatien. Kaanoen me liekhal hai kie sab betwan djaun pahiela larka hai, oesab Prabhoe khaatien hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jeroesaalem me ek Siemeon naam ke boerhwa rahat raha. Oe bhala aadmie aur bhaktia raha aur Pawietr Aatma okar oeppar raha. Oe Israel ke djaatie ke tieha dewe Waala ke agorat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pawietr Aatma ose bolies raha kie: „Mare se pahiele toe Prabhoe ke Kriest ke dekhiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tab ohie samai par djab Jiesoe ke maai-baap Larka ke Parmeswar ke mahal ke angana me legail kaanoen poera kare khaatien, tab Pawietr Aatma Siemeon ke bhie hoewa par legail. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tab boerhwa Larka ke godie me leike Parmeswar ke goen gaawe lagal. Oe bolies: ");
INSERT INTO hnsNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","„He Prabhoe, ham aapan aakhie se tor batjaawe Waala ke dekhiela. Ab ham sjaantie se mar sakab. Toe aapan waada aapan goelaam khaatien poera karle hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Toe oke pathaile hai doenia bhar ke djaatie log ke dekhaawe ke kaise paap me se batj djaai sakie. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Oe manai log ke djotie deiga djaun tore biese me na djaane hai. Aur Israel djaatie ke biesaal soekh mieliega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tab ie baat soenke maai-baap bahoet atjambho bhail. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tab boerhwa oesabke aasier-baat deis aur Larka ke maai se bolies: „Khoeb thiek se soen. Ie Larka Israel me dher ghamandie logan ke gieraaiga aur nietja logan ke oethaaiga. Okare dwaara Parmeswar Israel ke djaatie ke dekhaaiga kie oelog kaise okar goessa me se batj sakiega. Bakie dher log okar baat par laat maariega. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ie sab tjiedj dwaara dher manai log ke kharaab bietjaar dekhaawal djaaiga. Aur tor diel me bahoet doekh aaiga, djaise talwaar kaate hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tab ekgo auro Parmeswar ke sanesia aail. Oe boerhia raha aur okar naam Aana raha. Okar baap Faanoewel raha aur oelog Aasar ke koel me ke raha. Aana ke biaah hoi gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tab saat baries baad oe wiedhwa hoi gail, aur ab oe tjaurasie (84) baries ke hai. Oe hardam Parmeswar ke mahal ke angana me raha aur raat dien bhoekha rahieke ose praatna karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ohie samai par oe oesabke lage aail aur bhie Parmeswar ke goen gaawe lagal. Oe Jiesoe ke biese me sab manai logan se bataawe lagal djaun agorat raha djab talak Parmeswar Jeroesaalem waalan ke tjhoetkaara na deiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tab djab Larka ke maai-baap sab tjiedj kar tjoekal raha djaun Parmeswar ke kaanoen me liekhal hai, tab oesab Naasaaret sahar Gaalielea diehaat me lautke gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Larkwa djab barka howat raha, tab okar taagat aur gjaan barhat djaat raha aur Parmeswar ke bhalaai okar oeppar raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Har baries okar maai-baap Jeroesaalem djaat raha Paasan ke tiewhaar manaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aur djab Jiesoe baara baries ke bhail, tab oelog oke hoewa legail. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tab djab sabhan tiewhaar manaaike ghare djaat raha, tab Jiesoe hoewe rahie gail bakie okar maai-baap na djaanies. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Oesab sotjat raha kie oe palwaar log ke saath ghare dja hai. Ohie khaat sabhan ek rodj tjalke gail oke rasta par khodje aur bhie palwaar aur tjienhaar se poetjhies. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bakie djab oke na paais, tab oesab lautke khodjat khodjat ekdam sahar talak pahoetj gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tab tiesara rodj oelog oke Parmeswar ke mahal ke angana me paais. Hoewa par oe dharam ke parhaawe waalan ke bietj me baithke oesabke siektjha soenat raha aur sawaal poetjhat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aur sab hoewa ke manai bahoet atjambho bhail okar boeddhie aur djabaab se. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tab djab okar maai-baap oke dekhies, tab oesab bahoet tjakkariaai gail aur maai bolies kie: „E beta, toe kaahe ke hamlogse ie kaam karle baate? Ham aur tor baap bahoet sotj me toke sagaro khodjat rahielie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tab oe bolies: „Kaahe ke hamme khodjat rahiele? Toelog to djaane hai kie hamme tjaahie aapan Baap ke kaam me rahe ke?” ");
INSERT INTO hnsNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bakie oelog ie baat ke matlab na samadjh paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tab oe oesabke saath Naasaaret sahar gail aur oelogke baat soenat raha. Okar maai sab baat bahoet thiek se jaad karke aapan diel me rakhies. ");
INSERT INTO hnsNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Djab Jiesoe auro barka bhail, tab okar gjaan bhie barhat djaat raha. Parmeswar ke bhalaai okar oeppar raha aur manai log oke bhie tjaahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Djab Roma ke maahaaraadja Tieberias pandra baries raadj tjalaawat raha, tab Pontias Pielaatas Joedea diehaat ke laat raha. Oe tem me Herodes Gaalielea diehaat me raadj tjalaawat raha, okar bhaai Fielepas Ietoerea aur Traakonietas diehaat me, aur Liesaanias Aabielene des me. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aanaas aur Kaajaafas Jeroesaalem me sab se barka agwa raha. Aur Sakaarias ke beta Johaanas maidaan me Jordaan nadie ke kienaare raha. Hoewa par Parmeswar oke aapan baat bataais. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tab oe soeroe karies hoewa ke aas-paas me ailaan kare ke kie manai log ke tjaahie aapan paap pastaai ke aur aapan kharaab tjalaawa tjhor dewe ke djeme oesab dopoe lei sake aur paap ke tjhama paawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ie partjaar ke biese me Parmeswar ke sanesia Jasaaja ke poestak me liekhal hai: „Soen, maidaan me ek aawaadj soena hai. Koi bole hai: ‘Aapan diel safa kar aur Parmeswar ke aage siedha rasta par tjal! ");
INSERT INTO hnsNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Aapan djiewan me har khaala djagaha oetja aur sab pahaar khodke baraabar kar! Terha djagaha bhie sodjha kar aur garha rasta bhaat! ");
INSERT INTO hnsNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tab sab iensaan dekhiega kaise Parmeswar manai log ke batjaawe hai!’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dher manai Johaanas lage djoetat raha dopoe karwaawe khaatien. Bakie oe bolies kie: „Are, saap ke battjan! Ke toelogke dhokha deis hai kie toelog Parmeswar ke aane waala goessa me se batj sake hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Begar paap pastaaike aur kharaab rasta tjhor dewe ke koi na batj sakiega. Toelogke djiewan ke tjaahie Parmeswar ke barhia lage ke. Aur na sotjiehe kie: ‘Hamlogke baap-daada bieswaasie Aabraaham hai, ohie se hamlog djaroer batjab.’ Aise na hai. Parmeswar ie patthar me se Aabraaham khaatien larkan djalmaai sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Taanga per lage thariaawal hai. Har ek per djaun barhia phal na dewe hai, oe kaatke aagie me phek dewal djaai. Toelogke tjaahie batjaaike rahe ke, nahie to toelogse aisane hoiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tab ie baat soenke manai log poetjhies kie: „Hamlog ab ka karie?” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tab oe bolies: „Dje ke doei soth hai, oke tjaahie ekgo koi ke dewe ke djaun ke ekko na hai. Aur dje ke khaaik hai, oke tjaahie aisane kare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Djoetie ke paisa ke bharwaawe waalan bhie aail dopoe lewe khaatien aur poetjhies kie: „Maastar djie, hamlogke tjaahie ka kare ke?” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tab oe bolies: „Toelogke na tjaahie djaada paisa lewe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aur soerdjaatie log poetjhies kie: „Hamlog ka karie?” Tab oe bolies: „Toelog aadmie ke paisa na tjhien aur koi se koetjh karaai se na le, bakie aapan kamaai se santokh kar.” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Oe tem me sab koi sotjat raha kie Kriest halieje aaiga. Ohie se oesab Johaanas ke biese me sotje lagal kie: „Saait ohie hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tab Johaanas bolies kie: „Ham paanie se dopoe kariela, bakie ek Djane aaiga djaun ke hamse djaada saktie hai. Ham okar djoeta khole laaik na baatie. Oe toelogke Pawietr Aatma aur aagie se dopoe kariega. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Djaise ek khetiar paija niekaare khaatien soepela haath me lewe hai, oisane oe tajaar hai manai log ke alag alag kare ke. Oe dhaan aapan bakhaar me dhariega aur paija aagie se djaraaiga. Aur oe aagie kabhie na boet paaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aisane oe Parmeswar ke khoes khabar bataawat raha aur oe dher baat se manai log ke soedhaar lewat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Oe bhie raadja Herodes ke daaties. Raadja to aapan bhaai ke aurat apana leis raha aur doesar kharaabie karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tab oe ek aur kharaab kaam karies. Oe Johaanas ke djahal me band karwaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Oe samai djab Johaanas dopoe karat raha aur sab aadmie okar lage aail dopoe howe khaatien aur Jiesoe bhie dopoe hoike praatna kare lagal, tab swarag khoel gail ");
INSERT INTO hnsNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aur Pawietr Aatma kaboettar ke roep me oetarke okar oeppar aail. Tab ekgo aawaadj bhie swarag me se soenaail kie: „Toe hamaar pjaara Beta baate. Aur tor tjaal-tjalan hamme bahoet attjha lage hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Djab Jiesoe partjaar ke kaam soeroe karies, tab oe lagbhag ties baries ke raha. Sab manai sotjat raha kie oe Josaf ke beta raha. Aur Josaf Elie ke beta raha, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elie Matat ke, Matat Lewie ke, Lewie Melkie ke, Melkie Janai ke, Janai Josaf ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josaf Matatias ke, Matatias Aamos ke, Aamos Naajam ke, Naajam Heslie ke, Heslie Nagai ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maahat ke, Maahat Matatias ke, Matatias Semejen ke, Semejen Josek ke, Josek Joda ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda Jowaanan ke, Jowaanan Resa ke, Resa Seroebaabal ke, Seroebaabal Sealtiejel ke, Sealtiejel Nerie ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerie Melkie ke, Melkie Adie ke, Adie Kosam ke, Kosam Elmaadan ke, Elmaadan Er ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josoewa ke, Josoewa Eliejeser ke, Eliejeser Joram ke, Joram Matat ke, Matat Lewie ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewie Siemeon ke, Siemeon Joeda ke, Joeda Josaf ke, Josaf Jonan ke, Jonan Eljaakem ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eljaakem Melea ke, Melea Mena ke, Mena Matata ke, Matata Naatan ke, Naatan Daawied ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daawied Jesai ke, Jesai Obed ke, Obed Boas ke, Boas Salma ke, Salma Nahson ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahson Aamienaadab ke, Aamienaadab Admen ke, Admen Arnie ke, Arnie Hesron ke, Hesron Peres ke, Peres Joeda ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Joeda Jaakob ke, Jaakob Iesaak ke, Iesaak Aabraaham ke, Aabraaham Terah ke, Terah Naahor ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naahor Seroeg ke, Seroeg Rehoe ke, Rehoe Peleg ke, Peleg Hebar ke, Hebar Selah ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selah Kenan ke, Kenan Arpaksad ke, Arpaksad Sem ke, Sem Noah ke, Noah Laamek ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laamek Metoesala ke, Metoesala Henok ke, Henok Jered ke, Jered Maahaalaalel ke, Maahaalaalel Kenan ke, ");
INSERT INTO hnsNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan Enos ke, Enos Set ke, Set Aadam ke aur Aadam Parmeswar ke beta raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Djab Jiesoe ke dopoe hoi gail raha tab oe Jordaan nadie lage se tjal gail. Okar diel Pawietr Aatma se bharal raha. Tab Pawietr Aatma oke maidaan me legail. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hoewa par saitaan oke tjaalies rodj talak adjmaais. Oe same me Jiesoe koetjh na khaat raha aur ant me oke bhoekh lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tab saitaan ose bolies kie: „Djab toe Parmeswar ke Beta baate, tab ie patthar se boliehe: ‘Bret hoi dja.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tab Jiesoe bolies: „Parmeswar ke poestak me liekhal hai kie: ‘Iensaan na khaalie bret se djiega.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tab oe oke ekgo oetja djagaha par legail aur tjhien bhar me doenia ke sab des ke raadj dekhaai deis ");
INSERT INTO hnsNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","aur bolies kie: „Ham toke ie sab des ke raadj aur biesaal tjiedj debe. Hamme to ie sab raadj mielal aur ham debe dje ke ham maangab. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Djab toe hamme poedjiehe, tab ie sab raadj tor hoi djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tab Jiesoe bolies: „Parmeswar ke poestak me liekhal hai: ‘Toke tjaahie khaalie Prabhoe ke poedje ke aur okar rasta par tjale ke. Oe tor Parmeswar hai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tab oe oke Jeroesaalem sahar me ledjaaike Parmeswar ke mahal ke daak par thara karwaais aur bolies kie: „Djab toe Parmeswar ke Beta baate, tab hia se nietje koed dja. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Parmeswar ke poestak me to liekhal hai: ‘Oe aapan parie log se boliega: Oke batjaai de. Aur bhie: ");
INSERT INTO hnsNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Oesab toke aapan haath par rok leiga djeme toke tjot na lage.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tab Jiesoe bolies: „Parmeswar ke poestak me bhie liekhal hai: ‘Aapan Prabhoe Parmeswar ke na adjmaihe.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aur djab saitaan oke sab rakam se adjmaais raha, tab koetjh tem khaatien tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tab Jiesoe Gaalielea lautke gail aur Pawietr Aatma oke saktie dewat raha. Tab djab oe hoewa pahoetjal, tab sab aas-paas ke manai logan okare biese me batiaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Oe partjaar ke ghar me Parmeswar ke biese me siekhaawat raha aur sab koi okar goen gaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Aisane partjaar karte Jiesoe Naasaaret ke sahar gail djaaha oe barka bhail. Okar nem raha sabat ke dien par partjaar ke ghar djaai ke. Ohie se djab pahoetjal, tab oe hoewa ke partjaar ke ghar me gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aur djab oe oethal Parmeswar ke poestak parhe khaatien, tab oesab oke Parmeswar ke sanesia Jasaaja ke poestak deis. Tab djab oe kholies, tab paais djaaha liekhal hai: ");
INSERT INTO hnsNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","„Prabhoe ke Aatma hamaar oeppar hai. Oe to hamme aapan Pawietr Aatma deis hai oe manai logan ke khoes khabar soenaawe khaatien djaun ke diel tjhota hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dher manai djaise djahal me baanhal hai, aur oe hamke pathaais hai oelogse bataawe ke kie: ‘Toelog tjhoetkaara paihe!’ Aur andha waalan se bataawe ke kie: ‘Toelog dekhiehe!’ Oe hamme bhie pathaais hai dabaawal waalan ke tjhoraawe khaatien aur har ek se bole ke kie: ‘Parmeswar ke bhalaai ke tem aai gail hai!’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Djab oe ie sab baat parh tjoekal raha, tab poestak band karke lautaar deis aur baith gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aur sab koi khoeb dhiaan se oke taakat raha. Tab oe bolies kie: „Djaun baat ham abbe parhlie, oe aadj poera hoi gail.” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tab oesab bolies: „Okar baat satj hai!” Aur sab apane apane me batiaai lagal kie: „Oe ketana bhalaai ke biese me batia hai! Oe to Josaf ke betwa hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tab oe bolies: „Toelog djaroer se hamse boliehe: ‘Daaktar, apane ke attjha kar.’ Aur bhie boliehe: ‘Hamlog soenlie baatie kie toe Kaapernaum sahar me ka karle. Ie atjambho kaam hamlogke sahar me bhie kar. Toe hia par posal gaile hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bakie ham toelogse bataaila kie ekko Parmeswar ke sanesia ke sahar waalan okar baat me bieswaas na kare hai. Aur ie baat satj hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ka, toelog na djaane hai kie Parmeswar ke sanesia Elia ke tem me kaun tjiedj bhail raha? Sarhe tien baries khaatien barkha na barsal raha. Aisane Israel des bhar me bhoekha ke tem hoi gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hoewa par dher wiedhwa raha, tabbo Parmeswar Elia ke oesabke paas na pathaais. Oe oke Siedon des Saarepta sahar me pathaais ek hoewa ke wiedhwa hia rahe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aur Parmeswar ke sanesia Eliesa ke tem me Israel des me dher korhia ke bemarian raha. Tabbo Parmeswar ekko ke na attjha aur safa karies. Bakie djab Naaman Sieria des se aail, tab Eliesa oke attjha karies.” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tab sab koi ie baat soenke goessaail. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aur oethke oesab oke hoewa se pahaar ke ant talak dhakel deis. Naasaaret sahar pahaar par hai. Oesab maangat raha oke oeppar se gieraawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bakie Jiesoe ghoemke oesabke bietj me se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tab Jiesoe pahaar par se oetarke Gaalielea diehaat Kaapernaum sahar me gail. Hoewa par oe soeroe karies har sabat ke dien partjaar ke ghar me siekhaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Manai log partjaar soenke atjambho bhail. Oe etana hoekoem se bataawat raha kie sab koi ke tjaahat raha maane ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Etane me partjaar ke ghar me ekgo aadmie raha. Oke bhoet pakaries raha aur oe tjiellaaike bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","„He Naasaaret ke Jiesoe, tose hamlogse kaam na hai! Toe aile hamlogke naas kare khaatien? Ham djaaniela kie toe Parmeswar ke pawietr Waala baate.” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tab oe oke daatke bolies: „Tjoep! Aur okar me se niekar dja!” Bhoet adamia ke sab manai ke bietj me patak deis aur okare me se niekar gail begar oke koetjh kare. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tab sab koi ghabaraai gail aur apane me batiaai lagal kie: „Ie kaisan baat hai? Oe bhoet log ke aapan maahaan saktie se hoekoem dewe hai bhaage ke aur oesab baat soene hai!” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aur hoewa ke sab gaaw ke manai log ke okare biese me pata miel gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tab djab Jiesoe partjaar ke ghar me se niekaral, tab gail okar ek tjela Siemon ke ghare. Siemon ke saas hoewa par raha aur bokhaar me paral raha. Ohie se oesab Jiesoe se poetjhies oke attjha kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bas oe moerwaarie bedie lage gail aur bokhaar ke mienaahie karies. Bokhaar aurat ke tjhor deis. Tab oe toerant oethke Jiesoe aur okar tjela log ke sewa kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tab djab soeroedj doebe lagal, tab sab koi aapan bemarian leike okar paas aail. Oesabke rakam rakam ke bemaarie raha. Tab Jiesoe har ek ke oeppar aapan haath rakhke sabke attjha kar deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aur bhoet bhie dher miela ke oeppar se oetarke tjiellaai lagal kie: „Toe Parmeswar ke Beta baate!” Oesab djaanat raha kie oe Parmeswar ke waada karal waala Kriest hai. Bakie Jiesoe oesabke daaties aur koetjh na bolan deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tab saber bhaile oe gail djaaha koi na rahat raha aur dher miela oke khodje lagal. Tab djab sabhan oke paais, tab na maangat raha kie oe hoewa se djaai. ");
INSERT INTO hnsNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tab oe bolies kie: „Ham pathaawal gailie baatie Parmeswar ke khoes khabar sab sahar me partjaar kare khaatien. Ohie se hamme bhie tjaahie doesar sahar djaai ke djeme sab koi djaan djaai kie Parmeswar maange hai manai ke diel me raadj tjalaawe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tab oe Joedea diehaat gail hoewa ke sab partjaar ke ghar me ie baat ailaan kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ek dien Jiesoe Genesaaret samoendar ke kienaare partjaar karat raha. Dher manai dhakelat raha. Oesab maangat raha aur nagietje howe soene khaatien kie Parmeswar ka bole hai. Tab Jiesoe hoewa par doei bot dekhies. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Matjhar marwan bot me se niekarke aur aapan djaal dhowat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tab oe Siemon ke bot me gail baithe aur ose poetjhies: „Siemon, toe bot tanie se aur aage paanie me ledjaai sake hai?” Tab oe bot me se manai log ke siekhaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tab djab oe batiaai tjoekal, tab Siemon se bolies: „Gahiera paanie me dja aur aapan djaal bieg de.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tab Siemon bolies: „Maastar djie, hamlog raat bhar bahoet kausies karlie aur koetjh na pailie. Bakie ab tor baat soenke hamlog djaal biegab.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tab djab sabhan djaal biegies, tab dher matjharie paais aur oesabke djaal phate phate howe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tab sabhan ekwa bot ke matjhar marwan ke bolaais kie: „Aaw, hamlogke ek haath de!” Tab oesab aail aur sanghe doeno bot me etana matjharie bhar leis kie bot doebe doebe hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tab Siemon Petras dekhke okar gor gierke bolies kie: „Prabhoe djie, ham paapie baatie. Ham aapke lage na rahie sakiela.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ekwan matjhar marwan bhie bahoet atjambho bhail kie oesab ketana dher matjharie paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Siemon ke saathie Sebedeas ke betwan Johaanas aur Jaakobas raha. Oesab bhie ghabaraai gail. Tab Jiesoe Siemon se bolies: „Na ghabara, ab se toelog matjharie na pakariehe, bakie Parmeswar khaatien manai log ke djietiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tab djab sabhan doeno bot aur sab matjharie leike samoendar ke kienaare pahoetjal, tab aapan sab tjiedj tjhorke oesab Jiesoe ke sanghe tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ek dien djab Jiesoe ek Gaalielea diehaat ke sahar me raha, tab ekgo aadmie okar paas aail. Okar dehie bhar korhia ke bemaarie raha. Djab oe Jiesoe ke dekhies, tab okar gor gierke poetjhies kie: „Maastar djie, djab toe mangiehe, tab toe hamme attjha kar sakiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tab oe aapan haath barhaaike oke tjhoeis aur bolies: „Ham maangiela kie toe safa hoi dja.” Bemaria toerant attjha aur safa hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tab oe bolies: „Koi se koetjh na boliehe, bakie dja apane ke agwa ke dekhaaw. Aur baliedaan poera karwaaw djaun Parmeswar ke sanesia Mosas bolies raha kie korhia ke bemarian ke tjaahie kare ke djab safa hoi gail. Ie ekgo gawaahie rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tabbo dher miela Jiesoe ke biese me djaan gail raha aur aail okar partjaar soene aur aapan bemaarie se attjha howe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bakie oe ante gail djaaha koi na raha. Oe gail praatna kare. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ek doesar dien djab Jiesoe ekgo ghar me partjaar karat raha, tab ekaatgo Fariesie aur dharam ke kaanoen ke parhal waalan bhie baithke soenat raha. Oesab Gaalielea aur Joedea ke gaaw gaaw se aur Jeroesaalem sahar se aail raha. Aur Prabhoe ke saktie Jiesoe ke sanghe raha manai logan ke attjha kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tab ekaatgo aadmie ek loendj ke tjataai par laais. Oesab kausies karies oke bhiettar ledjaaike Jiesoe ke aage dhare ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bakie dwaar lage etana dher manai djoetal raha kie oesab na djaai paais. Tab tjaharke aur ghar ke tjhaawal oekhaarke oesab bemaria ke sab koi ke bietj me Jiesoe ke aage nietje oetaar deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tab Jiesoe djab dekhies kie oelogke bieswaas ketana barka hai, tab loendj se bolies: „Beta, ham toke paap ke tjhama kar deila.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tab dharam ke parhal waalan aur Fariesie log ie baat soenke sotjies kie: „Ie Parmeswar ke bedjatie kare hai! Khaalie Parmeswar paap ke tjhama dei sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bakie oe djaanies kie oesab ka sotje hai. Tab oe poetjhies: „Toelog kaahe ke aapan man me aise sotje hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kaun tjiedj aur sahadj hai ose bole ke: ‘Ham toke paap ke tjhama kar deila,’ kie ‘Oethke tjal’? ");
INSERT INTO hnsNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bakie ham oke bhie attjha karab djeme toelog djaan dja kie iensaan ke Beta ke saktie hai doenia me paap ke tjhama dewe ke.” Aur oe loendj se bolies: „Oeth, tjataai leike ghare dja.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aadmie toerant oethke sab koi ke aage aapan tjataai leike ghare djaai lagal aur rasta par tjalte Parmeswar ke goen gaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tab sab koi tjakkariaaike bhie Parmeswar ke goen gaawe lagal. Oesabke diel ieddjat se bhar gail aur oelog bolies: „Aadj hamlog ek atjambho kaam dekhlie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ekare baad Jiesoe djab sahar me se djaat raha, tab ekgo djoetie ke paisa bharwaawe waala ke dekhies. Okar naam Lewie raha. Oe ek ghar lage baithal raha djaaha djoetie bharaat raha. Tab Jiesoe ose bolies: „Hamaar saath tjal.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewie oethke sab tjiedj tjhorke okar saath tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tab oe Jiesoe khaatien aapan ghare bhodjan tajaar karwaais. Oe dher djoetie lewe waalan aur doesar aadmie log ke bhie bolaais. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tab Fariesie log aur dharam ke parhal waalan barbaraai lagal aur Jiesoe ke tjela log se bolies kie: „Toelog kaahe ke baimaan djoetie ke bharwaawe waalan aur doesar paapie log ke saath bhodjan kare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tab Jiesoe bolies: „Attjha manai ke daaktar ke djaroerie na hai, bakie bemarian ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ham na ailie baatie bhala manai logan ke bolaawe, bakie paapie logan ke, djeme oesab aapan paap pastaaike aapan djiewan badale.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tab oesab bolies: „Johaanas dopoe kare waala ke tjela log praatna ke tem par hardam bhoekha kie to rodja rahe hai, aur Fariesie ke tjela log bhie. Bakie tor waalan to khaai pieje hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tab oe bolies: „Ka, toelog sotje hai kie nautaharian bhoekhe rahie sake hai djab doelaha oelogke saath hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Djab doelaha oesabke lage se hataawal djaaiga, tab oesab bhoekhe rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Oe ek matlab ke kaahaanie bataawe lagal kie: „Koi na ek toekkara naawa kapra phaarke poeraan waala par djore hai. Aur djab koi tabbo karat, tab na khaalie naawa kapra phaatat, bakie naawa toekkara poeraan kapra par na sobhat. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aur koi bhie na naawa wien poeraan tjamra ke basta me oedjhlie. Djab koi tabbo karie, tab naawa wien djab phoeliega, tab basta phaatke wien bahie djaai aur basta barbaad hoi djaai. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Naawa wien tjaahie naawa basta me oedjhlaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aur djab koi attjha wien pies hai, tab doesar waala na maange hai. Attjha waala oke to barhia lage hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ek sabat ke dien par Jiesoe aapan tjela log ke saath khet me ghoemat raha. Tjela log koetjh djaise makai toerke bokla niekaarke khaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ekaatgo Fariesie bhie hoewa raha aur djab oesab dekhies kie Jiesoe ke tjela log ka kare hai, tab bolies: „Ka howe hai? Ie kaam to sabat ke dien par mienaahie hai!” ");
INSERT INTO hnsNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tab Jiesoe bolies: „Ka, toelog na djaane hai kie Daawied kaun tjiedj karies raha? ");
INSERT INTO hnsNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ek dien djab oke bhoekh lagal raha, tab oe Parmeswar ke ghar me gail aur pawietr bret leike aapan saathie log ke sanghe khaais, tjaahe khaalie agwa logan oe bret khaai sakat raha.” ");
INSERT INTO hnsNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Oe bhie bolies: „Iensaan ke Beta sabat ke dien ke Prabhoe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ek doesar sabat par Jiesoe partjaar ke ghar me gail siekhaawe. Hoewa ke manai me ek aadmie ke dahiena haath na kamaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dharam ke parhal waalan aur Fariesie log thiek se taakat raha kie Jiesoe aadmie ke sabat ke dien par attjha karat kie na. Tab oesab oke kasoer dei sakat. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bakie oe oesabke kharaab sotj-bietjaar djaanat raha. Tab oe bemaria se bolies: „Aaw bietj me khara how.” Aadmie oethke khara bhail. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tab oe sab koi se bolies kie: „Ka, toelog sotje hai kie hamlogke tjaahie sabat ke dien par bhala kie kharaab kaam kare ke? Aur koi ke barbaad kare kie batjaawe ke tjaahie?” ");
INSERT INTO hnsNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Oe sab koi ke taakies, tab aadmie se bolies: „Aapan haath lapkaaw.” Aadmie lapkaais aur haath attjha hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bas Fariesie log aur dharam ke parhal waalan bahoet goessaai gail aur apane me baat kare lagal kie oesab Jiesoe se ka karie. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Thora rodj ke baad Jiesoe pahaar par gail praatna kare aur raat bhar Parmeswar se batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tab djab dien bhail tab oe sab tjela log ke bolaais aur oman se baaraago ke tjoenies. Oe dien se oe iesabke pathaawal waalan bolaais. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Oesabke naam raha: Siemon djaun ke Jiesoe bhie Petras bolaawat raha aur okar bhaai Andreas. Aur bhie Jaakobas, Johaanas, Fielepas, Baartolomeas, ");
INSERT INTO hnsNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateas, Tomaas, Alfeas ke beta Jaakobas, Siemon kamaasoet waala, ");
INSERT INTO hnsNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jaakobas ke beta Joedaas, aur Joedaas Eskaariot. Oe Jiesoe ke tjoegalie karat. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tab Jiesoe aapan baara pathaawal waalan ke saath pahaar par se oetaral. Hoewa par okar dher tjela log raha aur dher manai Joedea diehaat aur Jeroesaalem sahar se aur bhie samoendar ke kienaare ke Tieras aur Siedon sahar se aail raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","19","Oesab maangat raha okar partjaar soene aur apane ke attjha karwaawe. Okare me Parmeswar ke saktie raha aur oe sabke attjha karies. Ohie se sab koi maangat raha oke tjhoewe. Aur dje ke bhoet sataawat raha, oesab tjhoetkaara paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tab Jiesoe aapan tjela log ke taakke bolies: „Soekhie rahie djekar diel garieb hai. Parmeswar toelogke raadj tjalaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Soekhie rahiehe djab toelogke diel bhoekh se rahe hai. Parmeswar toelogke diel bhariega. Aur djab toelog ab rowe hai, tab toelog bhie soekhie hai. Baad me toelog hasiehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Djab manai log toelogke iensaan ke Beta ke tjela howe ke kaaran djaran karke khaderie, gariaai aur tor bedjatie karie, tab toelog soekhie rahiehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Oesabke baap-daada logan Parmeswar ke sanesian se aisane karies raha. Toelogke swarag me biesaal ienaam mieliega. Ohie se oe dien par bahoet khoesie rahiehe! ");
INSERT INTO hnsNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Dhanie logan, batjaaike rahoe. Toelogke abbe sab tjiedj hai. Bakie ek dien toelog doekh me rahiehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Djab toelogke diel doenia ke tjiedj se bharal hai, tab toelog baad me bhoekha rahiehe. Aur djaun log ab hase hai, toelog doekh ke tem me roihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Djab sab koi tor biese me barhia batiaai, tab batjaaike rahoe. Oesabke baap-daada logan djhoettha sanesia log ke biese me bhie barhia se batiaat raha. Bakie oelogke oeppar moesiebat aai gail.” ");
INSERT INTO hnsNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jiesoe bolies: „Djab toelog hamaar baat soeniehe tab aapan doesman ke pjaar kar aur dje toke djare hai, okar bhalaai kar. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aasier-baat de dje toke saraape hai, aur okar khaat praatna kar djaun tor bedjatie kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Djab koi tor gaal par ek djhaapar maarie, tab ekwa alang bhie maaran deihe. Aur djab koi tor ek djora kapra lei lei, tab ekwa djora bhie dei deihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dje tose koetjh maangie, oke dei deihe. Aur djab koi tor koetjh lei lei, tab phien se na mangiehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Djaise toe maange hai kie manai log tore saath rahe, oisane toke tjaahie oesabke saath rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Djab toe khaalie oe manai log ke tjahiehe djaun toke tjaahe hai, tab toe attjha kaam na kare hai. Paapie logan to bhie tjaahe hai djaun log oesabke pjaar kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aur djab toe khaalie bhalaai kariehe djaun tor bhalaai kare hai, tab toe bhala kaam na kare hai. Paapie logan to bhie khaalie bhalaai kare hai djaun oesabke aisane kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aur djab toe koi se lena-dena kariehe otane paawe khaatien, tab toe koetjh barhia kaam na kare hai. Paapie logan to aisane kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bakie toelogke tjaahie aapan doesman ke pjaar kare ke aur sahaara dewe ke. Toelogke tjaahie lena-dena kare ke biena koetjh paawe khaatien. Tab toelogke dher ienaam mieliega aur toelog sab se maahaan Parmeswar ke larkan rahiehe. Oe niemakharaam aur kharaab manai ke bhalaai kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ek doesare ke daaja kar djaise Pieta Parmeswar bhie daaja kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Koi ke oeppar faisala na kar, tab toelogke oeppar koi na faisala kariega. Koi ke kasoer na de, tab koi toelogke kasoer na deiga. Doesare ke maaf kar de, tab toelogke bhie tjhama mieliega. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Doesar koi ke dher deihe, tab toke ose djaada mieliega. Djetane toelog koi ke naapke deihe, oisane toelogke mieliega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jiesoe ek matlab ke kaahaanie bataawe lagal kie: „Ek andha djab doesar andha ke tjalaaiga, tab doeno petie me gier djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ekgo tjela aapan barkwa se barka thoro hai? Bakie djab oe sab tjiedj siekh tjoekiega, tab oe aapan barkwa ghat rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Djab toelog aapan bhaai ke aakhie me ekgo phaitj dekhe hai, tab kaahe ke aapan aakhie ke tjaila na dekhe hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Djab tor aakhie me ekgo tjaila hai, tab toe aapan bhaai se na bol sake hai: ‘Laaw ham tor aakhie me se phaitj niekaar dei.’ Dhokhaabaadj logan! Pahiele aapan aakhie me ke tjaila niekaar, tab toe aapan bhaai ke aakhie me ke phaitj niekaare sakiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Oe bhie bolies: „Ekgo barhia per kharaab phal aur ekgo kharaab per barhia phal na dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Toe ekgo per ke okar phal se tjienh sake hai. Ekgo kaata waala per me se to amroed kie to aam na toera hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aisane bhie ekgo barhia aadmie ke diel me se barhia tjiedj nieksie, aur ekgo kharaab manai ke diel me se kharaabie. Djaun tjiedj se koi ke diel bharal hai, ohie okar moeh me se nieksie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Oe bolies: „Toelog kaahe ke hamme ‘Prabhoe djie’ bolaawe hai aur tabbo hamaar baat na soene hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Har ek djaun hamaar lage aai aur hamaar baat soenke karie, ham toelogke dekhaab oe kekar ghat lage hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Oe ekgo aadmie ghat hai djaun gahier khodke aapan ghar ek barka patthar par banaais raha. Tab djab nadie tjahar gail aur halfa ghar par maaries, tab ghar na gieral. Oe to bahoet djabar se banaawal raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bakie dje hamaar baat soenke aur na karie, oe ekgo aadmie ghat hai djaun aapan ghar djabar se na banaais hai. Tab djab nadie ke halfa okar ghar par maaries, tab ghar ekdam se naas hoi gail.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tab djab Jiesoe ie sab baat bol tjoekal raha, tab oe Kaapernaum sahar me gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hoewa par ek Roma ke soerdjaatie ke barkwa rahat raha. Okar ekgo goelaam bahoet bemaar raha aur mare par raha. Barkwa oke bahoet tjaahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tab djab oe Jiesoe ke biese me soenies, tab ekaatgo sahar ke barkwan ke pathaais poetjhe ke kie: „Prabhoe djie, aap aai sake hai hamaar goelaam ke batjaawe khaatien?” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tab djab oesab Jiesoe ke paas pahoetjal, tab bolies kie: „Oe bhaai bahoet attjha aadmie hai. Hamlog bientie kariela kie toe okar goelaam ke attjha karo. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Oe hamlogke djaatie ke pjaar kare hai aur hamlogke partjaar ke ghar banwaais hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tab Jiesoe oesabke saath gail. Bakie djab oe abbe ghar lage na pahoetjal raha, tab barkwa ekaatgo sanghatian ke pathaais bole ke: „Prabhoe djie, aap na aawo. Ham ie laaik na baatie kie aap hamaar ghar me aaw. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hamme hiau na hai aapke paas aawe ke. Khaalie ek baat bol de, tab hamaar goelaam attjha hoi djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hamse auro oetja dardja waalan hai aur hamaar nietje bhie soerdjaatie hai. Ham ekgo se boliela: ‘Dja!’ tab oe dja hai, aur ekwa se: ‘Aaw!’ tab oe aawe hai. Aur ham aapan goelaam se boliela: ‘Ie tjiedj kar’ tab oe kare hai. Ohie se ham djaaniela kie tor ek baat se hamaar goelaam attjha hoi djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tab Jiesoe ie baat soenke atjambho hoi gail aur ghoemke manai log se bolies: „Ham toelogse bataaila kie ham Israel ke djaatie me aisan bieswaas kabhie na pailie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aur djab barkwa ke sanghatian okar ghare lautke aail, tab dekhies kie goelaam ekdam attjha hoi gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Thora dien baad Jiesoe Naain sahar gail. Okar tjela log aur dher doesar manai okare saath gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tab djab oe sahar ke nagietj pahoetjal, tab dekhies kie sabhan ekgo naudjawaan ke lahaas sahar se bahare ledja hai. Oe ekahie betwa raha aur maai wiedhwa raha. Dher manai log okare saath sahar me se djaat raha mattie dewe. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tab djab Prabhoe maai ke rowat dekhies, tab oke bahoet daaja lagal aur ose bolies: „Na row.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aur oe nagtjaaike tjieta tjhoeis. Tab tjieta ledjaawe waalan roek gail. Tab oe naudjawaan se bolies: „Beta, ham tose boliela, oeth.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Naudjawaan oethke baith gail aur batiaai lagal. Tab Jiesoe oke okar maai ke saup deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tab sab manai ghabaraai gail aur Parmeswar ke goen gaawe lagal kie: „Parmeswar hamlogke khaatien ekgo barka sanesia pathaais hai! Oe aapan djaatie ke jaad kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ie baat Israel des bhar me aur aas-paas me phail gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Johaanas dopoe kare waala ke tjela log gail ose ie sab tjiedj bataawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tab oe doeigo ke bolaaike pathaais Prabhoe Jiesoe se poetjhe ke kie: „Tohie Parmeswar ke aane Waala baate, kie ek doesar waala aaiga?” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Oe doeno Jiesoe ke paas aaike bolies: „Johaanas dopoe kare waala poetjhe hai kie tohie aane Waala baate, kie hamlogke tjaahie doesar koi ke agore ke?” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ohie tem par Jiesoe dher bemarian ke attjha karat raha aur oesabke doekh aur bhoet se tjhoetkaara dewat raha. Oe bhie dher andha ke aakhie attjha karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tab oe bolies: „Dja Johaanas se bataai de kie toelog kaun tjiedj dekhle aur soenle hai. Andha log dekhe lage hai, loendj waalan tjale hai, korhia log safa karal dja hai, bahiera log soene lage hai, maral log djienda hoi dja hai. Aur dje dje djaane hai kie biena Parmeswar se oelog diel ke garieb hai, oelog khoes khabar soene hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aur ose bol de kie: „Dje aapan bieswaas hamare me pakarle rahiega, oe soekhie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tab djab Johaanas ke sanesia logan laut gail raha, tab Jiesoe manai log se Johaanas ke biese me bataawe lagal. Oe bolies: „Djab toelog maidaan me gaile rahiele Johaanas ke partjaar soene, tab kaun rakam aadmie ke maangat rahiele dekhe? Djaun narai ghat hauwa se hiele hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Toelog ke ke djaat rahiele dekhe? Ekgo aadmie ke djaun biesaal kapra pahiene hai? Djaroer na! Manai log djaun biesaal kapra pahiene hai aur dhan me rahe hai, oelog maidaan me na rahe hai, bakie raadja ke mahal me. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tab toelog kaisan aadmie ke maangat rahiele dekhe? Ek Parmeswar ke sanesia ke? Ha, ham toelogse boliela kie toelog ek Parmeswar ke sanesia se auro barka aadmie ke dekhle hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Johaanas ke biese me Parmeswar ke poestak me liekhal hai kie: ‘Ham aapan kamkarta tore aage pathaabe manai log ke diel tajaar kare ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ab talak Johaanas se auro barka koi na paida bhail hai. Bakie djab se Parmeswar soeroe karies hai manai ke diel me raadj tjalaawe ke, tab se tjhotkwan ose auro barka hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Djab sab djaatie log aur bhie baimaan djoetie ke paisa lewe waalan Johaanas ke partjaar soenies, tab oelog dopoe karwaais. Oelog sotjies: ‘Oe Parmeswar ke baat batia hai aur okar baat satj hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bakie Fariesie log aur dharam ke kaanoen ke parhal waalan na maangat raha Johaanas ke partjaar soene aur ose dopoe karwaawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Toelog djaane hai kie ie tem ke manai logan kaisan hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Oesab djaise tjhota larkan hai, djaun badjaar me baithke apane apane me gohoraawe hai: ‘Hamlog baadja badjailie aur toelog na mangle naatje. Tab hamlog marnie ke giet gailie aur toelog na mangle rowe!’ ");
INSERT INTO hnsNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aisane Johaanas dopoe kare waala aail aur kamtie khaat raha aur khaalie paanie piejat raha. Tab toelog bolle: ‘Okare oeppar bhoet hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tab iensaan ke Beta aail aur khaai piejat raha djaise toelog. Tab toelog bolle: ‘Dekh, oe ketana khabboe aur piejekkar hai. Aur oe baimaan djoetie ke paisa lewe waalan aur doesar paapie log ke sanghatia hai!’ ");
INSERT INTO hnsNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bakie dje Parmeswar me bieswaas karie, oe aapan tjaal-tjalan dwaara okar gjaan dekhaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ek dien ekgo Siemon naam ke Fariesie Jiesoe ke bolaais bhodjan kare khaatien. Jiesoe okar ghare gail aur ekgo pierha par let gail tafra ke lage. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tab oe sahar ke ek tjhatjhoendar aail. Djaise oe soenies kie Jiesoe Fariesie ke ghar me hai, oisane oe ek alabastar ke botal mahakauwa leike bhiettar aail. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tab oe Jiesoe ke gor lage khara hoike rowe lagal. Oe aapan aas se okar gor bhiedjaai deis, tab aapan baar se potjhe lagal. Aur gor par tjoemma deis aur mahakauwa lagaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Djab Siemon dekhies kie ka howe hai, tab oe sotjies kie: „Djab Jiesoe Parmeswar ke sanesia rahat, tab oe djaanat kie auratia paapie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tab Jiesoe ose bolies: „Siemon, ham maangiela tose ek baat bataawe.” Tab oe bolies: „Maastar djie, bolo.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tab oe ek tjhota khiessa kahe lagal kie: „Doeigo aadmie ekgo dhanie aadmie ke lage kardja raha. Ekgo ke tjaahat raha paan sau tjaanie ke paisa bhare ke aur ekwa ke patjaas. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bakie oesabke otana paisa na raha. Ohie khaatien dhanie aadmie bolies: ‘Ab toelog aapan kardja na bhariehe.’ ” Aur oe Siemon se poetjhies kie: „Oe doeno me se kaun waala dhanie aadmie ke auro djaada tjaahiega?” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tab Siemon bolies: „Hamme djana hai djekar kardja dher raha.” Tab oe bolies: „Toe thiek bolle.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tab oe ghoemke aurat ke taakies aur Siemon se bolies: „Toe oke dekhe hai? Djab ham tor ghare ailie, tab toe hamaar gor na dhowaile, bakie ie aapan aas se hamaar gor bhiedjaaike aapan baar se potjhies hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aur djab ham tor dwaar par ailie, tab toe hamme aapan gale na lagaile. Bakie djab se ham bhiettar ailie, ie aurat eksoer hamaar gor par tjoemma dewat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Toe hamaar moerie me tel na lagaile, bakie ie aurat mahanga tel hamaar gor me lagaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ham tose boliela kie oke sab paap ke tjhama miel gail hai. Ohie se oe hamke etana pjaar dekhaais. Bakie dje ke kamtie tjhama mielal hai, oe kamtie prem dekhaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aur oe aurat se bolies: „Toke tjhama miel gail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tab nautaharian aapan man me sotje lagal kie: „Ie ke hai paap ke tjhama dewe waala?” ");
INSERT INTO hnsNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bakie Jiesoe aurat se bolies: „Tor bieswaas dwaara toe batj gaile hai. Soekh se djaihe aur sjaantie me rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Koetjh dien hoi gail tab Jiesoe aapan baara tjela ke saath sahar sahar aur gaaw gaaw djaat raha khoes khabar bataawe kie Parmeswar maange hai manai ke diel me raadj tjalaawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Oesabke saath bhie koetjh aurat raha. Oman se ekaat djane bhoet se tjhoetkaara paais raha, aur ekwan bemaarie se attjha hoi gail raha. Jiesoe Magdaala sahar ke Maria ke oeppar se saatgo bhoet hataais raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Aur Koesaas ke aurat Johaana bhie oesabke saath raha. Okar aadmie raadja Herodes ke dhan-daulat ke kaar-baar karat raha. Ekgo Soesaana naam ke aurat raha aur dher doesar waalan. Oelog Jiesoe aur okar baaraago tjela ke aapan samaan se sewa karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ek dien djab har ek sahar se dher manai log Jiesoe ke paas aail raha, tab oe ekgo matlab ke kaahaanie bataawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Bolies: „Ekgo khetiar raha. Ek dien oe gail dhaan tjhiete. Tab djab koetjh bia rasta par gieral, tab katjaraai gail aur tjierai log kha leis. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Koetjh patthar waala djamien par gieral. Ghaam bahoet tedj raha, aur djab bia djame lagal, tab komalaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Koetjh djhalaasie me gieral aur okare sanghe barka howe lagal. Tab djhalaasie tjhota plansoe ke dabaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aur koetjh bia barhia djamien par gieral. Djab barhal aur pakal, tab sau goena phal deis.” Aur Jiesoe gohoraaike bolies: „Dje ke kaan hai oke tjaahie soene ke!” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tab okar tjela log poetjhies: „Ie kaahaanie ke matlab ka hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tab oe bolies: „Parmeswar toelogke deis hai samdjhe ke kaise oe doenia me aapan raadj tjalaawe hai. Bakie doesarkwan khaatien ie sab baat matlab ke kaahaanie me tjhiepal hai djeme oesab dekhe aur soene, bakie na samdjhe. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Attjha, soen. Bia djaise Parmeswar ke baat hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Rasta par ke tjhietal bia manai ke diel me gieral djaun Parmeswar ke sanesa soene hai. Bakie saitaan toerant aaike oe sanesa niekaar lewe hai. Oe na maange hai kie oesab Parmeswar me bieswaas kare aur okar goessa me se batj djaai. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aur patthar djamien hai djaise manai djaun Parmeswar ke sanesa khoesiaalie se soene hai. Bakie oesabke bieswaas tjhota hai. Patthar par khaalie thora se mattie hai. Ohie se oesab thora dien khaatien bieswaas kare hai, aur djab oesab adjmaawal djaaiga, tab aapan bieswaas tjhor dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Djhalaasie hai djaise manai ke diel djaun Parmeswar ke baat soene hai aur koetjh dien khaatien kare hai. Bakie oesab rodj ke kaar-baar, dhan-daulat aur maudj manaawe me aapan dhiaan lagaawe hai. Ie rakam se oesabke bieswaas be-kaamiel hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Barhia djamien par tjhietal bia manai ke diel me gieral djaun Parmeswar ke baat soene hai aur sattja diel se pakarle rahe hai. Aur oelogke tjaal-tjalan attjha hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jiesoe ekgo doesar matlab ke kaahaanie bataais. Bolies: „Koi na tjieraag baarke tope hai loekwaawe khaatien, bakie oeppar dhare hai djeme sab koi ke dekhaai. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Koetjh na topal hai djaun na dekhaai djaaiga. Aur koetjh na tjhiepal hai djaun na djanaai djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ohie khaatien toelogke tjaahie dhiaan lagaaike hamaar baat soene ke. Dje thiek se soenies hai, Parmeswar oke auro gjaan deiga. Aur dje na thiek se soenies hai, djaun tjiedj oe sotje hai kie oe samdjhe hai, ohoe tjhienaai djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Djab Jiesoe aapan tjela log ke ie sab tjiedj siekhaawat raha, tab okar maai aur bhaai log aail. Oesab maangat raha oke dekhe. Bakie hoewa par etana dher manai log raha kie oelog okar lage na djaai paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tab ek djane ose bolies: „Tor maai aur bhaai log bahare khara hai aur maange hai toke dekhe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tab oe bolies: „Hamaar maai aur bhaai log hai djaun Parmeswar ke baat aapan kaan se soene hai aur bhie kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ek dien Jiesoe aapan tjela log ke saath ekgo bot me gail, aur oesabse bolies: „Aaw tjalie nadie ke oepaar.” Oesabhan gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Djaite me Jiesoe bot me soet gail. Tab atjakke me ekgo etana barka aandhie aail kie bot me paanie bhar gail, aur tjela log ke bahoet dar lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tab oesab Jiesoe ke djagaawe lagal aur bolies: „Maastar djie, djaago, hamlog doebiela!” Tab oe djaagal aur oethke aandhie aur halfa ke daatke bolies: „Roek dja!” Aandhie-toefaan roek gail aur paanie dhiera hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aur Jiesoe aapan tjela log se bolies: „Toelogke bieswaas kaaha hai?” Bakie sabhan ghabaraaike aur atjambho hoike apane me poetjhe lagal kie: „Ie aadmie ke hai kie aandhie-toefaan aur paanie ke mienaahie kare hai, aur oesab okar baat soen lewe hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tab Jiesoe aapan tjela log ke sanghe samoendar ke habara kaatke Geraasa des me pahoetjal. Oe des Gaalielea diehaat ke oepaar hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Djab oe bot me se niekaral tab ekgo aadmie oke bhetaail. Oke bhoet log pakaries raha. Oe dher rodj se koerta na pahienat raha aur bhie ghar me na rahat raha, bakie pahaar ke kabar ke hol me. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Bhoet log oke dher dafe kahoe ghietj leis raha. Tab gaaw ke manai log okar haath gor baanhke oke rakhaawat raha. Bakie oe hardam ketie ke toer dewat raha, aur bhoet log oke djabar-djastie se soen-saan djagaha me ledjaat raha. Tab djab oe Jiesoe ke dekhies, tab tjiellaaike okare aage gier paral. Tab Jiesoe bhoet log se bolies: „Aadmie ke tjhor de!” Tab aadmie bolies: „Toe sab se maahaan Parmeswar ke Beta Jiesoe baate! Hamse aur tose kaun kaam hai? Ham bienaai kariela kie toe hamme na sataaw.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tab oe poetjhies: „Tor ka naam hai?” Tab aadmie bolies: „Dher.” Okar oeppar to dher bhoet log raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aur oesab Jiesoe se bienaai karies: „Hamlogke gahiera petie me na band kar!” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Oe tem par pahaar par dher soewar khaana khodjat raha. Tab bhoet log Jiesoe se bienaai karke poetjhies: „Hamlogke soewar me djaain de.” Tab oe hoekoem deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tab bhoet log aadmie ke oeppar se niekarke soewarwan ke oeppar gail. Bas soewar pahaar par se dhaurke paanie me gierke mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tab soewar ke tjaraawe waalan djab dekhies kie ka howe hai, tab haalie se bhaagke gail sahar me aur hoewa ke aas-paas me bataais kie ka bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tab manai log soenke Jiesoe lage aail aur aadmie ke dekhies djaun me se bhoet log niekar gail raha. Oe Jiesoe ke gor lage baithal raha. Okar moerie thiek raha aur oe kapra pahienies raha. Ie tjiedj dekhke sahar ke manai ghabaraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tab djaun manai dekhies raha, oesab bataais Jiesoe kaise aadmie ke attjha karies raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tab djab hoewa ke manai soenies, tab etana deraai gail kie Jiesoe se bolies: „Toe hia se tjal djaai sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tab aadmie djaun attjha hoi gail raha, oe Jiesoe se poetjhies: „Maastar djie, ham tor saath djaai sakiela?” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Bakie oe bolies: „Na, dja aapan ghare aur hoewa par sab koi se bataai de kie Parmeswar tor khaatien ka karies hai.” Aadmie gail aur sahar bhar me bataais. Aur Jiesoe bot me gail laute khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tab djab Jiesoe Gaalielea diehaat me pahoetjal, tab hoewa par dher manai oke agorat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ekgo Jaairas naam ke aadmie bhie aail raha. Oe hoewa ke partjaar ke ghar ke ekgo barkwa raha. Oe Jiesoe se bolies: „Ham tor gor gieriela, aaw hamaar ghare tjal. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Hamke khaalie ek bietia hai. Oe baara baries ke hai aur mare mare hoi gail hai.” Jiesoe toerant okar saath djaai lagal, bakie manai log okar rasta tjhaup leis. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Djhoend me ekgo bemaar aurat raha. Oke baara baries se khoen gierat raha. Ekko daaktar oke na attjha kar paawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tab oe paatjhe se Jiesoe ke kapra tjhoei leis aur toerant okar khoen band hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tab Jiesoe bolies: „Ke hamke tjhoeis hai?” Tab djab sab koi bole lagal: „Ham na tjhoeilie,” tab Petras bolies: „Maastar djie, sab alang se manai log toke dhakele hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bakie oe bolies: „Na, kauno hamme tjhoeis hai attjha howe khaatien. Hamare me se to saktie niekaral hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tab djab aurat samdjhies kie Jiesoe djaan gail, tab kaapat okar paas aail. Aur okar gor gierke sab koi ke aage bataawe lagal oe kaahe ke oke tjhoeis raha aur kaise ohie samai par oe ekdam se attjha hoi gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tab oe bolies: „Betie, na ghabara, tor bieswaas dwaara toe attjha bhaile hai. Sjaantie se dja.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tab djab Jiesoe abbe batiaite raha, tab Jaairas ke ghar se koi aaike ose bolies: „Tor bietia mar gail hai. Ab Maastar djie se bol de aur aage kausies na kare.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bakie Jiesoe ie baat soenke bolies: „Bhaai, na dera. Khaalie bieswaas kar aur tor bietia batj djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tab oesabhan aaike marnie ke ghare pahoetjal. Hoewa par Jiesoe khaalie Petras, Johaanas, Jaakobas aur larkie ke maai-baap ke apane sanghe bhiettar lei leis. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hoewa par dher miela piet-pietke rowat raha. Bakie oe bolies: „Toelog aise na row. Larkie na maral hai, oe soete hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tab sabhan ke hasie aail. Oesab to djaanat raha kie larkie mar gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bakie Jiesoe okar haath pakarke gohoraais: „Betie, oeth!” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Larkie ke praan phien okare me aail aur oe toerant khara hoi gail. Tab Jiesoe bolies: „Oke koetjh khaaik dei de.” ");
INSERT INTO hnsNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Okar maai-baap bahoet ghabaraai gail. Bakie Jiesoe oesabse bolies: „Toelog koi se na bataihe ka bhail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ekaat rodj baad Jiesoe aapan baara pathaawal waalan ke apane lage bolaais. Oe oelogke saktie aur hoekoem deis manai log se bhoet ke hataawe ke aur bemarian ke attjha kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tab oesabke bhedjaais Parmeswar ke raadj ke ailaan kare ke aur bemarian ke attjha kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Oe bolies: „Djab toelog djaihe tab apane sanghe danda, thailie, bret aur paisa na leihe, koetjh na. Aur doesara soth bhie na leihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Djab toelog ek ghar me pahoetjiehe, tab hoewa rahiehe djab talak oe sahar me se na djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aur djab ek sahar ke manai toelogke na maangie, tab hoewa ke dhoer aapan gor me se djhaarke oe sahar me se tjal djaihe. Tab oelog samdjhiega kie oelogke kasoer hai kie oesab Parmeswar ke baat na maange hai soene.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pathaawal waalan tjal gail aur gaaw gaaw sahar sahar gail Parmeswar ke khoes khabar bataawe aur bhie bemarian ke attjha kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Oe tem Herodes Gaalielea diehaat me raadj tjalaawat raha. Djab oe soenies kie Jiesoe aur okar baara pathaawal waalan kaun kaam kare hai, tab na djaanies ka sotje ke. Koi to bolies kie: „Jiesoe Johaanas dopoe kare waala hai. Oe djie oethal hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aur koi bolies kie: „Parmeswar ke sanesia Elia lautke aail hai.” Phier doesar koi bolies: „Parmeswar ke ek doesar sanesia djie oethal hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Bakie Herodes bolies: „Johaanas dopoe kare waala ke ham gatai katwailie hai, tab ie kaun hai djaun ke biese me ham etana atjambho tjiedj soeniela?” Aur oe kausies karat raha Jiesoe se bhet kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tab baara pathaawal waalan lautke aail aur Jiesoe se bataais kaun tjiedj karies raha. Tab Jiesoe oelogke Betsaaida sahar lage legail oelogke sanghe akele rahe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bakie manai log djaan gail aur okare pietjha pakaries. Tab djab oe dekhies, tab oesabke aapan lage bolaais aur Parmeswar ke raadj ke biese me samdjhaais. Aur oe bemarian ke attjha karies. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tab djab sandjha howe lagal, tab tjela log okar lage djaaike bolies kie: „Maastar djie, toke tjaahie ie sab manai ke pathaai dewe ke koetjh doer gaaw me. Saait sabhan hoewa par khaaik-paanie aur rahe ke djagaha paai. Hia par to koi na rahe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bakie oe bolies: „Oesabke toelog khaaik de.” Tab oesab bolies: „Hamlogke khaalie paatjgo bret aur doeigo matjharie hai. Ka, toe maange hai kie hamlog djaai khaaik kienlaai ie sab manai khaatien?” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hoewa par lagbhag paatj hadjaar aadmie raha. Tab oe aapan tjela log se bolies: „Manai log ke patjaas patjaasgo ekattha baithaai de.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Oesab aisane karies. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tab oe paatj bret aur doei matjharie leike oeppar taakke Parmeswar ke dhanbaad deis. Tab bret aur matjharie toer toerke tjela log ke deis baate khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tab djab sab koi pet bhar khaai tjoekal, tab sabhan baara baskieta batjal bret batories. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ek dien Jiesoe kahoe gail raha praatna kare khaatien. Okar tjela log okare sanghe raha. Tab oe poetjhies: „Manai logan ka bole hai kie ham ke baatie?” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tab oesab bolies: „Dher log sotje hai kie toe Johaanas dopoe kare waala baate. Aur doesar log bole hai Elia, aur phier koi koi sotje hai kie Parmeswar ke ekgo doesar pahiele ke sanesia djie oethal hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tab oe poetjhies: „Aur toelog ka sotje hai kie ham ke baatie?” Tab Petras bolies: „Toe Parmeswar ke Kriest baate.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tab oe bolies: „Soen! Ie baat koi se na bataihe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Oe bolies: „Iensaan ke Beta ke dher doekh sahe ke pariega. Djaatie ke barkwan aur barka agwan aur dharam ke parhal waalan oke na maangiega. Oesab oke marwaai dhaariega aur tiesara rodj oe phier se djie oethaawal djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aur oe sab se bolies kie: „Djab koi hamaar saath maangie aawe, tab oke na tjaahie apane ke sotje ke, bakie rodj hamaar sanghe aapan doekh oethaawe ke aur hamaar rasta par tjale ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dje maange hai aapan djiewan apane khaatien bietaawe, oe barbaad hoi djaai. Bakie dje aapan djiewan hamaar khaatien bietaai, oe batjaawal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ek aadmie ke kaun faida hai djab doenia bhar okar hoi djaai aur baad me oe Parmeswar se doer pahoetj djaai? ");
INSERT INTO hnsNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Dje hamaar aur hamaar baat ke biese me sarmaai, okar khaat iensaan ke Beta ke bhie saram aai djab oe aapan aur Pieta Parmeswar ke aur okar pawietr parie log ke biesaal maahaanta me lautke aai. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aur ham toelogse satj boliela kie hia ke ekaat miela na mariega djab talak oesab na dekhiega kie Parmeswar raadj tjalaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ek hapta baad Jiesoe Petras, Johaanas aur Jaakobas ke leike pahaar par gail praatna kare. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Praatna karte me okar soerat badal gail aur okar kapra ekdam se oeddjar tjamke lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bas atjakke me doei aadmie bahoet biesaal andjor me dekhaail aur Jiesoe se batiaai lagal. Oe doeno Parmeswar ke pahiele ke sanesian Mosas aur Elia raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Oesab aapan maahaanta me dekhaail aur apane apane me batiaat raha kaise Jiesoe Jeroesaalem sahar ke bahare mar djaat. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Otane der me Petras aur ekwan tjela soet gail raha. Tab djab djaagal, tab Jiesoe ke biesaal maahaanta aur doei aadmie ke dekhies. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tab djab oe doeno djaai lagal, tab Petras bolies: „Maastar djie, thiek hai kie hamlog hia baatie. Laaw hamlog haldie se tiengo marai banaai, ekgo tor khaatien, ekgo Mosas khaatien aur ekgo Elia khaatien.” Oe ie baat biena sotj-bietjaar karke bolies. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Batiaite me oesabke ek toekkara baadar tjhaai leis aur djab oe doeno baadar me tjal gail tab tjela log deraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tab baadar me se ekgo aawaadj soenaail: „Ie hamaar Beta hai. Ham oke tjoenlie hai aur toelog okar baat soeniehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Djab aawaadj soenaail tab khaalie Jiesoe hoewa raha. Koetjh dien lek tjela log koi se na bataais oesab kaun biesaal tjiedj dekhies raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Biehaan bhaile oesab pahaar par se oetaral. Tab ek djhoend manai log Jiesoe ke bhetaail. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Oman se ekgo aadmie djor se bolies kie: „Maastar djie, ham tor gor gieriela hamaar beta ke aaike dekh de. Oe hamaar ekahie larka hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hardam ekgo bhoet okar oeppar aai dja hai. Tab oke tjielwaaike karer kar dewe hai. Aur phetjkoer okar moeh me se niekare hai. Saitaan oke na maange hai tjhore. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ham tor tjela log se bientie karlie hai oke niekaare ke, bakie oesabhan na kar paais.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tab oe bolies: „Toelog ketana be-bieswaasie baate aur toelogke sotj ekdam oelta hoi gail hai. Hamke tjaahie kab talak toelogke saathe rahe ke aur toelogke tjaal-tjalan sahe ke?” Oe aadmie se bolies: „Hia laaw aapan beta ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tab djab baap aapan larka ke liaais, tab bhoet oke karer karke patak deis. Bakie Jiesoe saitaan ke daatke bhagaai deis aur larka ke attjha karke okar baap ke dei deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sab koi ghabaraai gail kie Parmeswar ketana maahaan hai. Tab djab oesab etana atjambho hoi gail raha, tab Jiesoe aapan tjela log se bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","„Toelogke tjaahie ie baat aapan man me dhar lewe ke kie iensaan ke Beta manai ke haath me saup dewal djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bakie tjela log ie baat ke matlab na samadjh paais aur oesabke hiau na paral Jiesoe se poetjhe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tjela log me soemmat na raha kie oelog me se kaun waala sab se barka hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bakie Jiesoe djaanat raha kie oesab ka sotje hai aur aapan lage ekgo tjhota larka khara karies. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tab oe bolies: „Dje aisan tjhota larka ke apana lei, oe hamme apana lei. Aur dje hamme apana lewe hai, oe hamaar pathaawe Waala ke apana lewe hai. Dje toelog me se maange hai sab se nietja waala rahe, ohie barka hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tab Johaanas bolies: „Maastar djie, hamlog dekhlie kie ekgo aadmie tor naam leike bhoet niekaare hai. Bakie oe tor saath na tjale hai. Ohie se hamlog oke datlie kie: ‘Ie tjiedj toke na tjaahie kare ke.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bakie oe bolies: „Oke karan de. Dje hamlogke kaam me laat na maare hai, oe hamlogke saath dewe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Djab Jiesoe ke tem nagtjaail swarag me lei lewal djaai ke, tab oe djaanke Jeroesaalem sahar djaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Oe ekaat sanesia ke agwe se pathaai deis raha. Oesab djaaike ekgo Saamaaria des ke gaaw me pahoetjal aur gail ek djagaha khodje djaaha Jiesoe raat me rahie sakat. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bakie hoewa ke manai na maangat raha oke djagaha dewe rahe khaatien. Oesab bolies kie: „Oe Jeroesaalem dja hai, oe hia na rahie sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tab Johaanas aur Jaakobas bolies: „Maastar djie, toe maange hai kie hamlog swarag ke aagie oelogke oeppar gieraai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bakie oe ghoemke oe doeno ke mienaahie karies. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tab oesab ek doesar gaaw me gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Rasta par koi Jiesoe se bolies: „Tjaahe djaaha toe djaihe, ham maangiela tor saath rahe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tab oe bolies: „Djanaawar ke biel hai aur tjierai ke khota hai. Bakie iensaan ke Beta ke ekko rahe ke djagaha na hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Oe ek doesar aadmie se bolies: „Hamaar saath aaw.” Tab aadmie bolies: „Maastar djie, ham pahiele aapan baap ke mattie dei sakiela?” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tab oe bolies: „Bestar kie be-bieswaasie logan maral waalan ke mattie dewe hai. Bakie toe djaaike sagaro partjaar kar kie Parmeswar maange hai manai ke diel me raadj tjalaawe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Phien tiesara waala bolies: „Maastar djie, ham tor saath djaabe, bakie ham pahiele ghare djaai sakiela bataawe kie ham djaaila?” ");
INSERT INTO hnsNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tab oe bolies: „Soen, dje soeroe karie har djote ke aur pietjhe taake hai, okar kaam kabhie siedha na djaai. Aisan aadmie Parmeswar ke raadj me kaam kare khaatien be-kaamiel hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ekare baad Prabhoe Jiesoe sattargo (70) tjela ke tjoenke doei-doei djane se aage pathaai deis sab sahar aur gaaw me djaaha oe apane maangat raha djaai. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Oe bolies kie: „Dher manai maange hai Parmeswar ke djaane, bakie dher manai na partjaar kare hai. Ie djanta log djaise pakkal dhaan hai, bakie bakhaar me laawe khaatien kamkartan kamtie hai. Ohie se Parmeswar se praatna kar kie oe auro kamkartan ke aapan khet me pathaawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ab toelog dja, ham toelogke bhera ke battja ghat khatarnaak djanaawar ke bietj me pathaaila. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Paisa ke thailie aur djhorie na ledjaihe aur dalaila bhie na. Aur toelogke na tjaahie rasta par haal-tjaal poetjhat roeke ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Aur djab toe kahoe bhiettar aihe, tab boliehe: ‘Ie ghar ke manai log ke sjaantie miele.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aur djab hoewa ke koi sjaantie me maangie rahe, tab sjaantie okar saath rahie. Bakie djab oe na maangie, tab sjaantie tor lage laut aai. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ohie ghar me rahiehe djaaha ghar waalan tor sjaantie apana leis hai. Hoewa khaihe aur piehe djaun tjiedj oelog toke dei. Ekgo kamkarta ke to tjaahie aapan kamaai paawe ke. Ohie se djaun tjiedj paihe khoesie se lei leihe. Aur ie ghar se oe ghar na djaihe rahe khaat. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Djab toe ekgo sahar me aihe djaaha manai log toke maangie aapan ghare ledjaai, hoewa khaihe djaun toke mielie. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hoewa ke bemarian ke attjha kariehe aur oe sahar ke manai se boliehe: ‘Iesab barka kaam se Parmeswar toelogke dekhaawe hai kie oe maange hai toelogke diel me raadj tjalaawe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bakie djab toe ekgo sahar me pahoetjiehe djaaha manai log toelogke aapan ghar me na maangie, tab rasta par thara hoike boliehe kie: ");
INSERT INTO hnsNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Toelog na maangat rahiele hamlogke partjaar soene. Ohie se hamlog ie sahar ke dhoer aapan gor se djhaar deila dekhaawe ke kie hamlogse aur toelogse kaam na hai. Tabbo toelogke tjaahie djaane ke kie Parmeswar ie sahar me barka kaam maangat raha kare samdjhaawe ke kie oe halieje se doenia par raadj tjalaaiga.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aur ham toelogse boliela kie faisala ke dien par Sodom sahar ke manai log ie sahar se otana dher sadja na paai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jiesoe bolies: „He Koraasien sahar ke djanta log, toelog Parmeswar ke sadja paihe! Aur Betsaaida waalan bhie! Ham toelogke sahar me dher atjambho kaam karlie hai. Aur djab ham ie kaam Tieras aur Siedon me kartie, tab hoewa ke manai ohie laage bahoet pastaat aur aapan djiewan badal dewat. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ohie se faisala ke dien par oe doei sahar ke manai toelogse otana dher sadja na paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aur Kaapernaum ke djanta log, toelog sotje hai kie swarag me ekgo oetja dardja paihe? Tanko na! Toelog maral logan ke djagaha me djaihe!” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aur oe aapan tjela log se bolies kie: „Dje toelogke baat maane hai, oe bhie hamaar baat maaniega. Aur dje toelogke baat na soenie, oe hamaar baat bhie na soeniega. Aur dje hamme aisane nahakaarie, oe hamaar pathaawe Waala ke bhie nahakaarie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tab djab sattargo tjela lautke aail, tab oesabhan bahoet khoesie raha aur Jiesoe se bolies: „Maastar djie, djab hamlog tor naam kaam me leilie, tab bhoet logan hamlogke baat maan leis.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tab oe bolies: „Ham dekhlie kaise saitaan biedjalie ghat swarag me se giere hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Saitaan aur bhoet logan djaise saap aur biettjhie hai. Aur soen, ham toelogke hoekoem deilie hai oelogke aur oesabke saathie log ke oeppar djeme oesab toelogke gor ke tare rahe. Ohie se toelogke koetjh na hoi paai. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tabbo ie sab se barka tjiedj na hai. Bakie khoesie rahiehe kie toelogke naam swarag me Parmeswar ke poestak me liekhal hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ohie same Pawietr Aatma dwaara oke bahoet khoesiaalie mielal. Oe bolies: „Pieta djie, aap swarag ke aur dhartie ke Prabhoe baate aur ham toke bahoet dhanbaad deila. Aap ie sab baat biedwaan aur parhal aadmie khaatien tjhiepaile, bakie an-parh manai ke dekhaile. Oesab tjhota larkan ghat hai. Ha, Pieta djie, aap to aisane maangat rahiele.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aur oe manai log se bolies kie: „Hamaar Baap sab tjiedj hamaar oeppar saup deis hai aur koi na djaane hai kie ham ke baatie. Khaalie hamaar Baap djaane hai. Koi bhie na djaane hai kie hamaar Baap ke hai, khaalie ham djaaniela. Aur dje ke ham maangiela aapan Baap ke djanaawe, oe bhie djaan djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Oe aapan tjela log se bolies: „Dje hamaar kaam dekhie aur hamaar baat soenie djaise toelog, oe soekh me rahie. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Dher Parmeswar ke pahiele ke sanesian aur raadja logan maangat raha hamaar kaam dekhe, bakie oesab na dekhies. Aur oelog maangat raha hamaar partjaar soene, bakie na soenies.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tab ek dharam ke kaanoen ke parhal waala oethke poetjhies: „Maastar djie, hardam Parmeswar ke saath rahe khaatien hamme ka kare ke tjaahie?” Oe ie baat poetjhies djaane khaatien kie Jiesoe kaise parhaawat raha. Oe maangat raha oke baat par phasaawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tab oe bolies: „Kaanoen me ekare biese me kaise liekhal hai? Toelog kaun rakam se parhe hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tab parhal waala bolies: „Toke tjaahie Prabhoe Parmeswar ke diel bhar, tan-man aur sab saktie se pjaar kare ke, aur aapan tjienhaar ke apane ghat tjaahe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tab oe bolies: „Toe thiek bolle hai. Djab ie tjiedj kariehe, tab toe hardam Parmeswar ke sanghe rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bakie aadmie maangat raha apane ke batjaawe aur poetjhies kie: „Hamaar tjienhaar ke hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tab oe ek matlab ke kaahaanie se djabaab deis. Bolies: „Ekgo aadmie raha. Oe Jeroesaalem se Jerieko sahar djaat raha. Tab atjakke me daakoe log oke gherke okar sab tjiedj tjhienke oke khoeb maaries. Tab djab aadmie adhmara hoi gail, tab sabhan oke tjhorke bhaag gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Etane me ekgo Israel ke dharam ke agwa ohie rasta par se djaat raha. Djab oe nagietje aail aur aadmie ke dekhies, tab ekwa kait se paas hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tab ekgo Lewie ke koel ke aadmie bhie paas bhail. Aur djab oe betjaara ke dekhies, tab ohoe ekwa kait se paas hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ekare baad ekgo Saamaaria des ke aadmie paas bhail. Aur djab oe adhmara aadmie ke dekhies, tab oke bahoet daaja lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Bas oe okar paas gail, okar ghaaw wien se safa karies aur tel lagaaike baanh deis. Tab oke oethaaike aapan gadaha par ek ghar me legail djaaha oe ek raat kaaties. Hoewa par oe oke dekh-bhaal karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Biehaan bhaile oe doei tjaanie ke paisa ghar ke barkwa ke deis aur bolies: ‘Toe oke sewa kariehe. Aur djab auro paisa lagie, tab djab ham lautab, tab ham toke bharab.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aur Jiesoe poetjhies: „Toe ka sotje hai, ie tieno me se ke okar tjienhaar raha?” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tab parhal waala aadmie bolies: „Djaun okar sewa satkaar karies hai.” Tab oe bolies: „Attjha, dja aur toe aisane kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ek dien djab Jiesoe aur okar tjela log Jeroesaalem djaat raha, tab oesab ek gaaw me pahoetjal. Hoewa par doei bahien rahat raha. Barka bahien ke naam Maarta raha aur tjhotkwa ke naam Maria raha. Tab Maarta Jiesoe ke aapan ghar me bolaais. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Djab Prabhoe Jiesoe oesabke ghar me raha, tab tjhotkwa okar gor lage djaaike baith gail okar partjaar soene khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bakie Maarta sewa kare me bhieral raha. Tab oe Jiesoe lage djaaike bolies kie: „Maastar djie, toke barhia lage hai kie hamaar bahien sab kaam hamaar par tjhor deis hai? Aap samdjhaai de kie oke tjaahie hamme haath dewe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tab Prabhoe bolies kie: „Are, Maarta, toe dher tjiedj ke biese me sotj kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bakie kamtie, kie to ekahie tjiedj kaamiel hai. Tor bahien ohie tjoenies djaun ose koi na tjhien paaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ek dien djab Jiesoe praatna karat raha, tab ekare baad okar ek tjela ose poetjhies kie: „Prabhoe djie, hamlogke siekhaaw praatna kare ke djaise Johaanas dopoe kare waala aapan tjela log ke bhie siekhaais hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tab oe bolies: „Attjha. Djab toelog praatna kariehe tab boliehe kie: ‘Pieta djie, sab koi aapke naam pawietr maane, aur aapke raadj aawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hamlogke aadj ke khaana deihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Djaise hamlog aapan kasoerwaar waalan ke maaf kariela, oisane aap hamlogke paap maaf kar deihe. Aur hamlogke laalietj me na paran deihe.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Oe praatna ke biese me ek kaahaanie bataawe lagal. Bolies: „Maan le kie tor sanghatia bietj raat me aaike tose poetjhie: ‘E bhaai, hamare hia doerie se pahoena aai gail hai aur hamke khaaik na hai. Toe hamme tiengo bret na dei sakiehe?’ ");
INSERT INTO hnsNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tab maan le kie toe ghar me se boliehe kie: ‘Hamlog sab koi soetal baatie. Kamaarie band hai. Ham na oeth sakiela.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ham toelogse boliela kie ant me toe aapan saram laatj batjaawe khaatien oethke bret dei deihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Aur ham toelogse bhie boliela kie djab toelog Parmeswar se praatna me koetjh mangiehe, tab oe deiga. Khodjat rahiehe, tab toelog paihe. Hardam khoet-khoetaaw, tab oe kamaarie kholiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Har ek djaun praatna karat rahiega, oke mieliega. Dje khodjat rahiega, oe paaiga. Aur djaun manai log khoet-khoetaawat rahiega, oelog khaat kamaarie kholal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Djab ek larka koetjh matjharie maangiega, tab okar baap oke thoro ek saap deiga? ");
INSERT INTO hnsNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aur djab oe ek anda maangiega, tab okar baap oke thoro ek biettjhie deiga? ");
INSERT INTO hnsNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Toelog tjaahe kharaab baate, tabbo aapan larkan ke attjha tjiedj djaane hai dewe. Toelogke swarag ke Baap tab ketana auro djaada Pawietr Aatma deiga djab koi praatna karke ose maange hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ek dien Jiesoe ekgo aadmie me se ek bhoet niekaaries. Djaise bhoet niekaral, oisane aadmie batiaai lagal. Bhoet oke to na batiaai dewat raha. Tab manai log dekhke bahoet atjambho bhail. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bakie ekaat djane bolies kie: „Oke bhoet ke barkwa Bejelsaboel sahaaita kare hai. Ohie khaatien oe bhoet ke niekaar sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Doesarkwan oke adjmaawe lagal aur khaalie maangies kie oe Parmeswar ke saktie se koetjh atjambho kaam kare. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bakie oe oesabke kharaab bietjaar djaan gail aur bolies kie: „Har ek raadj djaun baatal hai, oe barbaad hoi djaai. Aisan raadj me sahar ke ek ghar ekwa par gierie. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tab toelog kaise bol sake hai kie ham Bejelsaboel ke sahaaita se bhoet ke niekaariela? Djab saitaan aapan bhoet ke niekarwaawe hai, tab kaise okar raadj thiek se tjalie? ");
INSERT INTO hnsNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aur djab ham okar saktie se ie kaam kariela, tab toelogke tjela log kekar saktie se bhoet niekaare hai? Ohie se oesab toelogke kasoer deiga aisan kharaab bietjaar par. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bakie djab ham bhoet ke Parmeswar ke saktie se niekaariela, tab dekha hai kie oe soeroe karies hai raadj tjalaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Djab ek djabar aadmie hattiaar leike aapan ghar thiek se rakhwaala kariega, tab okar dhan-daulat me koi haath na lagaai sakiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bakie djab ekgo auro djabar waala oke maarke djiet leiga, tab oe aapan hattiaar par bharosa karke eke kaam me leike okar sab tjiedj baat deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Oe bolies: „Dje hamare alang na hai, oe hamme djare hai. Aur dje hamaar sanghe bhera na ekattha laaiga, oe oesabke khaderiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jiesoe ekgo matlab ke kaahaanie bataawe lagal. Bolies: „Djab ek bhoet ek manai me se niekare hai, tab oe djangal me djaaike araam khodjiega. Aur djab oe na paaiga, tab sotjiega kie: ‘Phier se oe aadmie ke oeppar aaw tjalie. Oe to hamaar rahe ke djagaha raha.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tab djab hoewa pahoetjiega, tab dekhiega kie oe djagaha safa karal waala ghar ghat hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tab djaaiga aur saatgo auro kharaab bhoet bolaaike aur oesab mielke aadmie me rahiega. Tab oe manai ke haal pahiele se auro kharaab hoi djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tab djab Jiesoe ie baat bol tjoekal raha, tab manai log me se ek aurat djor se bolies: „Tor maai soekhie hai! Toe to okare me djanam paile aur oe toke doedh piaaike barka karies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tab oe bolies: „Ha, aur dje Parmeswar ke baat soenke aur attjha se jaad karke apanaawe hai, oesab soekhie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tab djab auro manai log djoete lagal, tab Jiesoe bolies kie: „Ie tem ke manai kharaab hoi gail hai. Oesab maange hai ek atjambho kaam dekhe, bakie Parmeswar aapan sanesia Jona dwaara ek tjienha dekhaai tjoekal hai, aur ab thiek hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona se ek barka tjiedj bhail raha, aur ekare dwaara Nienafe ke manai log dekhies kie Parmeswar ketana maahaan hai. Aisane iensaan ke Beta ab ke tem ke manai khaatien Parmeswar ke saktie dekhaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Etiopia des ke raanie bahoet doer se aail raha raadja Saalomo ke gjaan siekhe aur oe okar baat maanies. Parmeswar ke faisala ke dien par oe ab ke tem ke manai ke sanghe djie oethiega. Bakie oesab na maange hai hamaar baat soene. Ohie se raanie dekhaaiga kie oesab kasoerwaar hai. Aur ham Saalomo se gjaanie baatie. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Oe dien par Nienafe ke sahar waalan bhie djie oethiega. Djab oelog Jona ke partjaar soenies, tab paap pastaaike aapan kharaab djiewan badal deis. Bakie ab ke tem ke manai logan aise na kare hai. Ohie se Nienafe ke manai logan dekhaaiga kie oesabke kasoer hai. Aur ham to Jona se barka baatie! ");
INSERT INTO hnsNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Koi na tjieraag baarke ek djagaha par dhariega djaaha na dekhaaiga, bakie aisane dhariega kie sab koi bhiettar aaike dekh paai. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ek iensaan ke aakhie djaise okar andar ke tjieraag hai. Djab oe khaalie safa tjiedj maange hai dekhe, tab okar andar me ekdam se andjor hai. Bakie djab oe aapan dhiaan kharaab tjiedj ke oeppar lagaawe hai, tab okar andar ekdam se andhiaar hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ohie khaatien batjaaike rahiehe kie tor andar andhiaar na howe. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Djab toelogke andar ekdam se andjor hai aur tanko andhiaar na hai, tab djaise ekgo tjieraag rahiega djaun toelogke oeppar andjor dewe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tab djab Jiesoe batiaai tjoekal raha, tab ek Fariesie oke nauta deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tab oe dekhies kie Jiesoe khaai se pahiele aapan haath na dhois aur oe tjakkariaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bakie Prabhoe Jiesoe ie nem ke biese me bolies kie: „Are, Fariesie logan, toelog manai ghat baate djaun aapan bartan bhiettar na dhowe hai, khaalie bahare kaitie. Toelogke andar bahoet dalieddar aur doesar kharaab tjiedj se bharal hai, tabbo toelog khaalie aapan haath dhowe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bhoettjar logan! Dje hamlogke dehie banaais hai, oe hamlogke andar bhie banaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Toelogke tjaahie ek safa diel se daan kare ke, tab sab koetjh thiek hoi djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Fariesie log, toelogke bahoet doekh mieliega! Toelog Parmeswar ke tjhota tjiedj djaise lesoen, martja aur piaadj me se ek daswa hiessa dewe hai, bakie toelogke man na hai bhala manai rahe ke aur oke pjaar kare ke. Aur ie to sab se barka tjiedj hai. Daswa hiessa dewe ke thiek hai, bakie sab se barka tjiedj kare ke na bhoelaaw. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Fariesie logan, khabardaar! Toelog maange hai partjaar ke ghar me aage baithe aur toelogke attjha lage hai djab rasta me dher manai toelogke barka maane hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Khabardaar Fariesie logan! Toelog djaise tjhiepal kabar baate. Aur dje opar tjale hai, oe na djaane hai kie oe tjhoet hoi gail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tab ekgo dharam ke kaanoen ke parhal waala bolies kie: „Maastar djie, ie sab baat se toe hamlogke bhie bedjatie kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tab oe bolies: „Ha, tohoelog khabardaar rahiehe! Toelog aapan kaanoen dwaara manai log ke aisan bodjha dewe hai oethaawe ke kie oesab na oethaai sake hai. Aur toelog angoerie na dolaawe hai kaanoen poera karwaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Khabardaar rahiehe! Toelogan barhia kabar banaawe hai Parmeswar ke sanesian khaatien. Aur toelogke baap-daada oesabke marwaai dhaaries hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aisane dekha hai kie toelog aapan baap-daada se ek baate. Oesabhan betjaaran ke marwaai dhaaries aur toelog oesabke kabar sadjaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ohie se Parmeswar aapan barka gjaan se bolies hai kie: ‘Ham oesabke khaatien auro sanesian aur pathaawal waalan ke bhedjab. Aur oelog oman se ekaat djane ke maar dhaariega aur kauno ke sataaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tab ie tem ke manai sadja paaiga sab Parmeswar ke sanesia ke khoen khaatien djaun doenia ke soeroe se bahaawal hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Djab se Aabal ke khoen bahal tab talak agwa Sakaarias Parmeswar ke mahal aur baliedaan djaraawe ke tafra ke bietj me maar dhaaral gail toelog Parmeswar ke sanesian ke maar dharle hai. Aur ie tem ke manai log sab sadja paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Are, kaanoen ke parhal waalan, khabardaar! Djaise koi ghar band karke tjaabhie bieg deis hai, oisane toelog Parmeswar ke baat tjhiepaaike ek kantie dharle hai. Toelog ie baat na maange hai djaane aur dje maange hai samdjhe, oke toelog na djaanan dewe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tab djab oe ie sab baat bol tjoekal raha, tab hoewa se tjal gail. Kaanoen ke parhal waalan aur Fariesie logan okar oeppar bahoet goessaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Oe same se oelog sab rakam ke sawaal poetjhe lagal oke koetjh baat par badjhaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Etane me hadjaaran manai Jiesoe lage djoetal, aur thelat-thaalat karat raha oke dekhe khaatien. Tab oe aapan tjela log ke siekhaawe lagal kie: „Toelogke tjaahie Fariesie logan ke bietjaar se batjaaike rahe ke. Ie to djaise khatta karal piesaan hai. Djab naawa piesaan me dariehe, tab ohoe khatta hoiga. Ohie se oesabke bietjaar se doer rahiehe! ");
INSERT INTO hnsNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sab iensaan ke tjhiepaawal baat Parmeswar ke andjor me dekhaai djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ohie se sab andhiaar me batiaawal baat andjor me soenaai djaai. Aur djaun baat kothrie me kaan me batiaile, oe rasta par soenaai djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Oe bolies: „Hamaar sanghatian, toelog manai log ke na deraihe. Oesab khaalie iensaan ke dehie maar sake hai aur ekare baad koetjh na kar paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bakie Parmeswar ke saktie hai koi ke djaan leike aur oke narak me bahaai dewe ke. Ohie se khaalie oke deraihe! ");
INSERT INTO hnsNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Jaad kar kie paatj tjhota tjierai bahoet sasta me bieka hai. Tabbo Parmeswar iesab par aapan aakhie tjaharaai rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aur oe bhie djaane hai toelogke moerie par kaigo baar hai. Ohie khaatien sotj-phiekier na kariehe. Toelog to sab tjierai se maahaan baate.” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Oe bolies: „Djab koi doesar manai log ke aage kholke boliega kie ham okar Prabhoe baatie, tab iensaan ke Beta Parmeswar ke parie ke aage bhie kholke boliega kie oe okar tjela hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bakie dje hamme manai ke aage nahakaariega, oke ham Parmeswar ke parie ke aage bhie nahakaarab. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Aur dje iensaan ke Beta ke bedjatie kariega, oke maafie mieliega. Bakie dje Pawietr Aatma ke bedjatie kariega, oke maafie na miel sakiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Aur djab toelog partjaar ke ghar ke barkwan ke aage ledjaawal djaihe kie to djadj aur laat ke aage, tab toelogke na tjaahie sotje ke kaise apane ke batjaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Oe same par Pawietr Aatma toelogke djanaai deiga kaise tjaahie batiaai ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Etane me djhoend me se koi bolies: „Maastar djie, hamaar barka bhaai se bol de to baap ke tjhoral dhan hamaar saath baate ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tab oe bolies: „Ham kaise toelogke dhan batwaai sakiela? Koi hamke thoro djadj banaais hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Oe sab koi se bolies kie: „Toelogke na tjaahie hardam dher tjiedj maange ke. Tjaahe toe djetana dhanie hoi djaihe, tabbo tor djiewan tor na hoi sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aur oe ek matlab ke kaahaanie kahe lagal. Bolies: „Ekgo dhanie aadmie ke khet me se dher sauda niekarat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tab oe aapan man me sotjies kie: ‘Ham ka karab? Hamme dher djagaha na hai etana sauda dhare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ab ham djaaniela. Ham aapan bakharwan toerwaaike auro barka waala banwaabe. Tab eman aapan sab sauda dhar sakab. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tab ham bol sakab: Attjha, ab hamme dhan hai dher dien djieje khaatien. Ab se kaam na kare ke parie, khaalie khaai pieje aur maudj manaawe ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bakie Parmeswar ose bolies kie: ‘Tor bietjaar na thiek hai. Aadj raat ke ham tor djaan lebe. Tab tor dhan ke paai?’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aur Jiesoe bolies: „Dje khaalie dhan batore hai aur na maange hai lewe djaun sattja dhan Parmeswar oke dewe hai, ose aisane bhie hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jiesoe aapan tjela log se bolies kie: „Ohie khaatien toelog khaai-pieje aur pahiene-orhe ke biese me sotj-phiekier na kariehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Djiewan to khaaik se aur dehie kapra se barka hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tjierai ke dekh. Oesab thoro sauda bowe aur kaate hai? Aur oesabke bakhaar bhie na hai. Tabbo Parmeswar oesabke khaaik dewe hai. Tab thiek se sotj, toelog to tjierai se maahaan baate. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tjaahe toelog djetana sotj kariehe, tabbo aapan djiewan ekko ghanta khaatien na barhaai paihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Djab toelog etana tjhota tjiedj na kar paawe hai, tab kaahe ke sotj oethaawe hai kapra aur khaaik ke biese me? ");
INSERT INTO hnsNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Aur phoel ke dekh. Oesab kapra na banaawe hai, tabbo oesab raadja Saalomo se auro barhia dekha hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tjhota bieswaasie logan! Djab Parmeswar phoel ke etana barhia se banaawe hai, tjaahe oesab sabere phoela hai aur sandjha ke djaraawal dja hai, tab oe toelogke kapra na deiga? ");
INSERT INTO hnsNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Toelog khaai pieje ke biese me na hardam sotjiehe aur aapan man me na poetjhiehe: ‘Ham ie sab tjiedj kaaha paabe?’ ");
INSERT INTO hnsNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Be-bieswaasie logan aisane sotje hai. Bakie toelog Parmeswar ke larkan baate aur oe djaane hai kie toelogke khaai pieje ke tjaahie. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pahiele oke aapan diel me raadj tjalaawan deihe, tab oe toelogke ie sab tjiedj deiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Toelog ek tjhota djhoend bhera ghat baate, tabbo na deraihe. Pieta Parmeswar toelogke Baap hai. Oe maange hai kie toelog okar aane waala raadj me bhaag leihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aapan tjiedj betjke aur paisa garieb logan ke dei deihe. Aise toe swarag me dhan batoriehe. Hoewa par oe kabhie na kharaab kie to don hoi sakiega aur tjor aur dewka na pahoetj paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Djaaha tor dhan hai, hoewa tor dhiaan bhie rahiega!” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Jiesoe bolies: „Djaise goelaam log tjieraag baarke aapan maaliek ke agore hai djab talak oe biaah ke nauta se lautke na aawe hai, oisane toelog hamme agoriehe. Tab djab goelaam log ke maaliek aaiga aur kamaarie par khoet-khoetaai, tab oesab ohie laage khol deiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Djaun naukar log agorte rahiega, oesab soekh me rahiega. Maaliek oesabhanke bolaaike khaana piena deiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Djab oe bietj raat me aaiga kie to auro derie me aur oesabke agorte paaiga, tab oesab soekh me rahiega! ");
INSERT INTO hnsNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Bakie thiek se sotj. Djab koi djaanie kie tjor kaun tem par aaiga, tab thoro soetiega? Na, oe djagte rahiega djeme tjor bhiettar na aai sake. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aisane koi na djaane hai kab iensaan ke Beta lautke aaiga. Oe atjakke me aaiga. Ohie se tajaar rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tab Petras poetjhies kie: „Prabhoe djie, ie sab baat khaalie hamlogke khaatien hai, kie doesar manai khaat bhie?” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tab oe bolies: „Ie baat ekgo bharosaadaar aur samadjhdaar kamkarta khaatien hai. Ghar ke maaliek oke sab doesar goelaam ke barkwa banaais oelogke rodj dewe ke djaun oesabke djaroerie hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tab djab maaliek lautke aaiga aur oke aisane kaam karat paaiga, tab oe soekhie rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ham toelogse satj boliela kie oe aapan sab dhan-daulat okar oeppar saup deiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bakie maan le kie barkwa apane me bolie kie: ‘Hamaar maaliek abbe na lautke aai,’ aur soeroe karie goelaam log ke maare ke aur khaai pieje aur nasa me tjoer howe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tab djab okar maaliek atjakke me aaike pahoetj djaai, tab oe okar dardja lei lei aur oe niemakharaam ke bahoet kathien sadja dei. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Djaun goelaam djaane hai kie okar maaliek ka maange hai, tabbo na karie, oe bahoet sadja paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bakie dje aapan maaliek ke hiettjha na djaane hai aur koetjh karies djaun ke khaatien oke tjaahie sadja miele ke, oe kamtie paaiga. Dje ke dher mielal hai, ose bhie dher poetjhal djaai aur djekar oeppar dher saupal hai, ose djaada maangal djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jiesoe bolies: „Ham dhartie par ailie aagie lagaawe aur ham ka karab djab oe bare tjoekie? ");
INSERT INTO hnsNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pahiele hamaar oeppar bahoet doekh aaiga, aur ham bahoet tjienta kariela djab talak ham aapan kaam na poera karab. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ka, toelog sotjle rahiele kie ham doenia me ailie hai manai logan me ekta karwaawe? Na, aise na hai. Hamare dwaara oesab baatal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ab se ek ghar ke paatj miela baatal rahiega, doei se tien kie to tien se doei djane se. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baap aapan beta se aur beta baap se, maai aapan betie se aur betie maai se, saas aapan patoh se aur patoh saas se ek na rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jiesoe manai log se bolies kie: „Djab toelog dekhe hai kie samoendar ke oeppar baadar karia howe hai, tab bole hai: ‘Dekh, barkha barsiega!’ Aur oisane howe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aur djab hauwa datjhien or se tjale hai, tab toelog bole hai kie: ‘Barka garmie aaiga!’ Aur oisane howe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Are, dhokhaabaadj log! Djab toelog baadar me aur dhartie par taake hai, tab toelog djaan dja hai kaun tjiedj hoiga. Tab kaahe ke ie tem ke tjiedj na tjienh paawe hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aur toelogan kaahe ke na sallaah kare hai kaun tjiedj satj hai aur ka kare ke tjaahie? ");
INSERT INTO hnsNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Djab toe koi ke koetjh kardja baate, tab kausies kar halieje se ose ek howe ke, nahie to oe toke djadj ke aage ledjaai aur toe djahal me pahoetj djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ham toelogse boliela kie djab talak toelog aapan sab kardja na bhariehe, tab talak hoewa se na niekar paihe!” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Oe tem par koetjh manai aail aur Jiesoe se bataawe lagal kie Jeroesaalem sahar me ka bhail raha. Hoewa par Roma ke laat Pielaatas ekaat Gaalielea diehaat waalan ke Parmeswar ke mahal ke angana me baliedaan karat me marwaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tab Jiesoe poetjhies: „Ka, toelog sotje hai kie oe betjaaran sab doesar Gaalielea waalan se auro kharaab raha aur kie oesabke ohie khaatien etana doekh oethaawe ke tjaahat raha? ");
INSERT INTO hnsNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ham toelogse boliela kie aise na hai. Bakie djab toelog aapan paap pastaaike aapan djiewan na badaliehe, tab tohoelog bhie naas karal djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aur oe atthaara manai log ke jaad kar djaun par Sielowam ke lage ek oetja ghar gier gail raha. Ka, toelog sotje hai kie oesabhan Jeroesaalem ke doesar log se auro kasoerwaar raha? ");
INSERT INTO hnsNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aise na hai! Bakie djab toelog aapan paap pastaaike aapan djiewan na badaliehe, tab tohoelog bhie naas hoi djaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ie sab baat samdjhaawe khaatien Jiesoe ek matlab ke kaahaanie bataawe lagal kie: „Koi aapan parnaasie me ek adjier ke per bowaais raha. Tab djab phare ke tem aail, tab oe gail phal toere, bakie koetjh na paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tab ek dien oe parnaasie ke kamkarta se bolies kie: ‘Dekh, ham tien baries se aaila phal toere, bakie kabhie koetjh na paaila. Bestar oke kaat de. Oe to khaalie djagaha lewe hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bakie kamkarta bolies kie: ‘Maaliek djie, ek baries auro tjhor de, tab ham per ke aas-paas djamien gorke mes dharwaai debe. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tab saait phal dei. Bakie djab na deiga, tab katwaai deihe.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ek sabat ke dien par Jiesoe ekgo partjaar ke ghar me Parmeswar ke baat siekhaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hoewa par ekgo aurat raha. Oke otana taagat na raha. Atthaara baries se okar piethie terha raha. Oe sodjha na thara hoi paawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Djab Jiesoe oke dekhies, tab aapan paas bolaaike bolies: „Betie, toke phier se taagat miel gail.” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Oe aapan haath okar oeppar rakhies, tab aurat toerant thara hoi gail aur Parmeswar ke goen gaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bakie partjaar ke ghar ke barkwa goessaai gail kie oe aurat ke ek sabat ke dien par attjha karies raha. Ohie khaatien oe hoewa ke manai se bolies kie: „Ek hapta me tjhau dien kaam kare ke tjaahie, ie sab dien par aihe apane ke attjha karwaawe khaatien, bakie na sabat ke dien par.” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tab Jiesoe bolies: „Are, dhokhaabaadj logan! Toelogan aapan gaai-goroe to sabat ke dien par khole hai aur paanie piaawe hai. Ka, ie kaam na hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ie aurat Aabraaham ke aulaad me ke hai aur saitaan oke atthaara baries se sataawat raha. Tab hamke to tjaahat raha eke sabat ke dien par tjhoetkaara dewe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ie baat se okar doesman log ke bahoet saram lagal, bakie djhoend log okar barhia kaam dekhke khoesie raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tab Jiesoe bolies kie: „Parmeswar ke raadj kaisan hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Oe ek tjhota sarso ke bia ghat hai. Oke koi leike aapan khet me boi deis. Tab djamke etana barka per hoi gail kie tjierai aaike okar daar par khota banaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Oe bolies: „Parmeswar ke raadj kaun tjiedj ghat bhie lage hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oe tien kobba piesaan ghat hai djaun me ek aurat koetjh khatta karal piesaan aur tien kobba piesaan mielaaike saan deis. Tab sab piesaan phoel gail.” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jiesoe ie sahar se oe sahar partjaar karte Jeroesaalem djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ek dien koi ose poetjhies kie: „Prabhoe djie, kamtie manai log batjaawal djaaiga kie dher?” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tab oe ekgo matlab ke kaahaanie kahe lagal. Bolies: „Toelog bahoet kausies karke Parmeswar ke raadj ke saket kamaarie dwaara bhiettar djaihe. Dher log to maangie bhiettar djaai, bakie na djaai paai. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Djab ghar ke maaliek oethke kamaarie band kar deis hai, tab toelog soeroe kariehe khoet-khoetaaike bole ke kie: ‘Prabhoe, hamlogke khaatien khol de!’ Tab oe boliega: ‘Ham na djaaniela toelog kaaha se aile baate.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tab toelog boliehe kie: ‘Hamlog aapke sanghe khailie pielie hai aur aap hamlogke gaaw me partjaar karlo!’ ");
INSERT INTO hnsNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tabbo oe boliega: ‘Ham na djaaniela toelog kaaha se aile hai. Are, kharaab logan, toelog hia se tjal dja!’ ");
INSERT INTO hnsNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tab djab toelog Aabraaham, Iesaak aur Jaakob Parmeswar ke sab sanesian ke sanghe okar raadj me dekhiehe aur toelog bahare rahiehe, tab toelog ketana daat pieske roihe! ");
INSERT INTO hnsNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Oe dien doenia bhar me se koetjh manai aaiga Parmeswar ke raadj me bhodjan kare. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aur thiek se soen. Koetjh pahiela waalan patjhar djaaiga aur koetjh patjharal waalan pahiela waalan hoiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Oe same par ekaatgo Fariesie Jiesoe ke paas aaike bolies: „Raadja Herodes toke maange hai marwaawe. Toke hia se bhaage ke parie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tab oe bolies: „Dja oe saap se bol de kie aadj aur biehaan ham bhoet niekaarab aur bemarian ke attjha karab, aur tiesara dien par ham aapan kaam poera karab. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hamke tjaahie aadj, biehaan aur parso Jeroesaalem me pahoetj djaai ke. Ek Parmeswar ke sanesia ke tjaahie Jeroesaalem me maar dhaaral djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Are, Jeroesaalem log, Jeroesaalem log! Toelog hardam Parmeswar ke sanesian ke maar dhaare hai aur okar pathaawal waalan par patthar bieg biegke maar dhaare hai! Ham kai dafe manglie tor larkan ke batore djaise ekgo moergie aapan battjan ke aapan pakhna ke batore hai. Bakie toelog na mangle! ");
INSERT INTO hnsNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dekh, Parmeswar aapan mahal tjhor deis hai! Bakie ham boliela kie toelog hamme na dekhiehe djab talak toelog boliehe: ‘Soekh me rahe oe djaun Parmeswar ke naam se aawe hai!’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ekgo sabat ke dien par Jiesoe ke nauta mielal ekgo Fariesie ke barkwa ke ghare bhodjan kare ke. Tab djab oe bhiettar gail, tab sab nautaharie log oke khoeb thiek se taakat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Okar aage ek bemaar aadmie thara hoi gail. Okar dehie bhar phoelal raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tab Jiesoe dharam ke kaanoen ke parhal waalan aur Fariesie log se poetjhies kie: „Sabat ke dien par koi ke attjha kare ke tjaahie, kie na?” ");
INSERT INTO hnsNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bakie koi na maangat raha koetjh bole. Tab oe bemaria ke haath pakarke oke attjha kar deis aur bolies: „Ab toe ghare djaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aur oe manai log se bolies kie: „Djab sabat ke dien par toelogke beta kie to bail ek petie me gier djaai, tab toelog oke toerant na niekariehe?” ");
INSERT INTO hnsNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ie baat par oesab koetjh na bol paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jiesoe dekhies kaise nautaharie log sab se barhia djagaha khodje hai baithe khaat. Ohie se oe soeroe karies oesabke ek matlab ke kaahaanie bataawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Oe bolies: „Djab toelogke biaah ke nauta mieliega, tab sab se barhia djagaha par na baithiehe. Hoi sake hai kie tose auro oetja dardja waala ke nauta mielal hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tab ghar ke maaliek aaike tose bolie kie: ‘Bhaai, toe ie djagaha oe aadmie ke dei sake hai?’ Tab toke sarmaaike ekdam se paatjhe djaai ke parie. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bakie djab toke nauta mieliega, tab hardam paatjhe baithiehe. Tab ghar ke maaliek toke dekhke bol sakie: ‘Bhaai, aaw auro aage baitho.’ Aur doesar nautaharie log dekh sakie kaise tor aadar howe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dje apane ke baraai kariega, okar nietjaai hoi aur dje tjhota banke rahie, okar baraai hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jiesoe oe ghar ke maaliek se bolies kie: „Soen, djab tor ghare nauta rahie, tab aapan sanghatian, bhaai, palwaar, nahie to dhanie parosian ke na bolaihe. Oesab toke bhie nauta deiga, tab toke oesabke bhodjan mieliega. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bakie djab toe nauta kariehe, tab toe bhiekhmangan, langar, loendj aur andha logan ke bolwaihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aise karke toe soekhie rahiehe. Oesab toke to koetjh na lautaarke dei sakiega. Bakie djab be-kasoer waalan djie oethiega, tab Parmeswar toke ienaam deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ie baat soenke nautaharie log me se koi Jiesoe se bolies kie: „Soekh me rahie dje Parmeswar ke raadj me bhodjan kariega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tab oe oke ek matlab ke kaahaanie se djabaab deis. Oe bolies: „Ek aadmie raha. Ek dien oe barka nauta karies aur dher manai log ke bolwaais. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tab djab tem aai gail bhodjan kare khaatien, tab oe nau ke pathaais nautaharian se bole ke kie: ‘Aawo, bhodjan karo. Ab sab khaaik tajaar hoi gail hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bakie sab ek na ek bahaana kare lagal. Pahiela waala nau se bolies kie: ‘Dekh, ham ek khet kienlie hai aur hamme tjaahie djaaike dekhe ke. Hamme maaf kar de. Ham na aai paabe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Doesarkwa bolies kie: ‘Ham abbe dasgo bail kienlie hai aur ham djaaila dekhe kie oesab barhia hai kie na. Hamme maaf kar deihe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Aur tiesara waala bolies kie: ‘Hamaar biaah halieje bhail hai. Ohie khaatien ham na aai paabe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tab nau lautke gail aur aapan maaliek se ie sab baat bataais. Maaliek djab soenies tab bahoet goessaail aur bolies: ‘Haalie se dja phien sahar me aur bhiekhmangan, langar, loendj aur andha log ke rasta par se nauta me laihe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nau djaaike laut aail. Bolies: ‘Maaliek djie, djaun toe hamse bolle kare ke ham kar tjoekalie aur nauta me abbe djagaha batjal hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tab maaliek bolies: ‘Dja ab diehaat aur djangal ke sab rasta rasta, aur hoewa ke manai ke djaroer se nauta me laaw djeme ghar bhar djaai. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aur ham tose boliela kie pahiela bolaawal waalan me se ekko na hamaar khaaik tjiekh paai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tab djab Jiesoe ie kaahaanie bataai tjoekal raha, tab oe aur aage Jeroesaalem ke or tjalal. Ek barka djhoend manai okare sanghe djaat raha. Tab oe ghoemke oesabse bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","„Dje aapan maai-baap, aurat, larkan, bhaai-bahien ke aur bhie aapan djiewan ke hamse djaada pjaar kare hai, oe hamaar tjela na ban sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aur dje hamaar khaat na maange hai doekh oethaawe, oe hamaar tjela bhie na ban sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Aisane djab koi maange hai ek oetja ghar banaawe, tab oe pahiele baithke sotjiega ketana paisa eman lagiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Hoi sakie kie oe aadha par roek djaai. Tab manai log haske bolie: ");
INSERT INTO hnsNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Are, dekh, oe maangat raha ghar banaawe, bakie adhwe par se roek gail!’ ");
INSERT INTO hnsNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aisane bhie hai djaise ek raadja djaun ke das hadjaar soerdjaatie hai aur oke tjaahie ek doesar raadja se laraai kare ke djaun ke bies hadjaar hai. Oe pahiele aapan mantrie log se baat-tjiet kariega kie oe djiet paai kie na. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aur djab baat-tjiet me pata paai kie oe na djiet paaiga, tab oe ekwa raadja ke doerieje se sanesian ke pathaaiga sjaantie maange ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ohie khaatien dje aapan sab tjiedj na maange hai tjhore, oe hamaar tjela na ban sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Oe bhie bolies: „Niemak to bahoet barhia tjiedj hai. Bakie djab oman sawaad na hai, tab kaise sawaad miel sakie? ");
INSERT INTO hnsNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tab be-kaamiel hoi djaai. Khetiar to mes ghat aapan khet me bhie na dhar sakiega. Ohie se bahaai dewal djaai. Dje ke kaan hai, oke tjaahie thiek se soenke hamaar baat ke matlab samdjhe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sab baimaan djoetie ke paisa lewe waalan aur bhie dher doesar paapie log Jiesoe ke paas aawat raha okar partjaar soene khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ohie se Fariesie log aur dharam ke parhal waalan Jiesoe ke oeppar goessaail aur apane me bolies kie: „Oe paapie log ke prem se bhiettar lewe hai aur oelogke sanghe kha hai!” ");
INSERT INTO hnsNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tab Jiesoe oesabse ekgo matlab ke kaahaanie bataawe lagal kie: ");
INSERT INTO hnsNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","„Sotj kie toelog me se koi ke sau bhera rahie aur oman se ekgo heraai djaai. Tab oe niennaanabe (99) maidaan me tjhorke djaaiga ekwa ke khodje djab talak oke na paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Djab oke paai djaai, tab khoesie se oethaaike kandha par laad lei. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aur djab ghare pahoetjie, tab aapan sanghatian aur parosien logan ke bolaaike bolie: ‘Aaw, hamlog sanghe khoesiaalie manaai dja. Ham to aapan bhera ke phien se paai gailie!’ ");
INSERT INTO hnsNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ham toelogse boliela kie djab ek paapie aapan paap pasta hai, tab swarag me niennaanabe (99) bhala manai se auro djaada khoesiaalie rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Oe ek aur kaahaanie bataais. Bolies: „Sotj kie ek aurat ke dasgo tjaanie ke paisa raha aur ekgo laas hoi gail. Tab oe tjieraag baarke ghar-bhar me tjaaro bagal djhaarke khodjiega djab talak na paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aur djab paai djaai tab gaaw ke sab aurat ke bolaaike bolie: ‘Aaw, khoesiaalie manaai dja. Ham to aapan paisa paai gailie djaun laas hoi gail raha!’ ");
INSERT INTO hnsNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Aisane Parmeswar ke parie log bhie khoesiaalie manaaiga ekgo paapie khaat djaun aapan paap pastaaiga!” ");
INSERT INTO hnsNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Oe bhie ie kaahaanie bataais kie: „Ekgo aadmie raha, oke doei betwa raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ek dien tjhotkwa aapan baap se bolies kie: ‘Baap, hamlogke dhan me se hamaar hiessa hamme dei de.’ Okar baap aapan dhan doeno betwan ke baat deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tab ekaat rodj baad tjhotkwa aapan sab tjiedj betjke doer des tjal gail. Bas hoewa par oe aapan sab paisa naksaan kar dhaaries. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tab djab okar sab koetjh don hoi gail raha, tab oe des me akaal paral aur oke koetjh na raha khaai-pieje ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tab oe gail kaam khodje aur oe des ke ek aadmie hia kaam paais. Oe aadmie oke aapan khet me pathaais aapan soewar ke rakhwaala kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tab aapan pet bhare khaatien oe soewar ke khaana maangat raha khaai, bakie ohoe na paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tab okar samadjh me aail oe kaun kharaab kaam karies hai. Bolies kie: ‘Dekh, hamaar baap ke kamkartan ke etana dher khaaik hai aur ham hia khaai biena mariela! ");
INSERT INTO hnsNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bestar hai kie ham aapan baap lage djaai aur ose bolab kie: Pieta djie, ham Parmeswar se aur aapse paap karlie hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ham tor betwa bolaawe laaik na baatie. Ham tor ekgo kamkarta hoi sakiela?’ ");
INSERT INTO hnsNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bas oe oethke aapan baap lage djaai lagal. Tab koetjh dien baad okar baap oke doerieje se dekh leis aur oke bahoet daaja lagal. Oe okar lage dhaurke oke khoesiaalie se aapan gale lagaais. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tab betwa bole lagal kie: ‘Pieta djie, ham Parmeswar se aur aap se paap karlie hai. Ham tor betwa bolaawe laaik na baatie....’ ");
INSERT INTO hnsNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bakie okar baap aapan goelaam se bolies: ‘Haalie se sab se barhia kapra, ekgo angoethie aur djoeta laaw okar khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aur sab se barhia khasie maar aur sab rakam ke khaaik banaaw. Tab tjalie khaai aur khoesiaalie manaawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ie betwa to hamare lieje mar gail raha aur ab djie gail hai, oe heraai gail raha aur ab hamaar godie me lautke aai gail hai!’ Tab sabhan soeroe karies khoesiaalie manaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Oe same par barka betwa khet me raha. Djab okar kaam don hoi gail, tab oe ghare djaai lagal. Aur djab nagietj pahoetjal, tab gaana-badjaana soenies. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tab ekgo goelaam ke bolaaike poetjhies kie: ‘Hia ka howe hai?’ ");
INSERT INTO hnsNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tab goelaam bolies: ‘Tor tjhota bhaai attjha se lautke ghare aai gail hai, ohie se tor baap sab se barhia khasie marwaais.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tab barka bhaai ie baat soenke goessaail aur na maangat raha bhiettar djaai. Tab okar baap bahare aaike oke phoeslaaike bolies: ‘Tjalie bhiettar.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tab oe aapan baap se bolies kie: ‘Pieta djie, etana dien ham tor khaat kaam karlie aur hardam tor hoekoem manlie. Bakie toe kabhie na hamke ekgo tjhota bakarie deile kie ham aapan sanghatian sanghe khaai aur khoesiaalie manaai sakie. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aur ab ie tor betwa aail! Oe tor dhan kharaab aurat se naksaan kar dhaaries aur okar khaat toe khasie marwaaike etana khoesiaalie manaawe hai!’ ");
INSERT INTO hnsNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tab baap bolies: ‘Beta, toe to hardam hamaar saath baate aur djaun tjiedj hamaar hai tor bhie hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Khoesiaalie manaawe ke tjaahie. Tor bhaai to hamlogke lieje mar gail raha aur ab djie gail hai, oe heraai gail raha aur ab hamlog oke phien se paai gailie hai!’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jiesoe aapan tjela log se ekgo auro matlab ke kaahaanie kahe lagal kie: „Ekgo dhanie aadmie raha. Oe aapan dhan ek sardaar ke oeppar saup deis raha. Tab ek dien koi ose bolies: ‘Oe sardaar tor dhan naksaan kare hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tab oe sardaar ke bolaaike poetjhies kie: ‘Ham tore biese me bahoet baat soeniela. Ohie se sab kaagadj-pattar hamme dekhaaw. Ab se toe hamaar kamkarta na rahiehe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tab sardaar sotjies kie: ‘Ab ham ka karie? Maaliek to hamaar kaam tjhiene hai. Khetie ke kaam ham na kar paabe aur bhiekhmaange ke ham sarmaaila.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Oe apane me bolies: ‘Attjha, ab ham djaan gailie kaun tjiedj kare ke tjaahie. Ham sanghatian khodjab, tab djab hamaar kaam tjhienaai djaai, tab oesab hamke aapan ghar me bhiettar lei leiga.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tab oe aapan maaliek ke kardja waalan ke bolwaais. Aur pahiela waala se poetjhies: ‘Ketana toke tjaahie maaliek ke bhare ke?’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tab oe bolies: ‘Ek sau baariel tel ke paisa.’ Tab ose bolies: ‘Le aapan kardja ke kaagadj aur dja haalie se patjaasgo (50) baariel liekh.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tab ekgo doesar se poetjhies: ‘Aur toke ketana tjaahie bhare ke?’ Tab oe bolies: ‘Ek sau basta tjaur ke paisa.’ Tab ose bolies: ‘Le aapan kardja ke kaagadj aur assiego (80) liekh.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tab maaliek djab soenies, tab bolies: ‘Hamaar ie sardaar aapan kaam sattjaai se na kare hai, bakie bahoet sotj-samadjhke aapan rasta safa karies hai.’ Ab dekha hai kie ie djoeg ke be-bieswaasie log bieswaasie log se djaada sotj-bietjaar karke rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ohie se ham boliela kie toelogke tjaahie aapan doenia ke dhan se sanghatian banaawe ke. Tab djab toke tjhore ke parie, tab toe khoesiaalie se bhiettar lewal djaihe djaaha toe sada ke lieje rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Oe bhie bolies: „Dje kamtie tjiedj me bharosaadaar hai, oe bhie dher tjiedj me rahiega. Bakie dje kamtie me sattjaai se na rahe hai, oe dher tjiedj me bhie na rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Djab toelog bharosaadaar na rahiehe ie doenia ke paisa-kaurie ke rakhwaala kare ke, tab Parmeswar kaise swarag ke dhan tor oeppar saup sakiega? ");
INSERT INTO hnsNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aur djab toelog doesar koi ke dhan-daulat par sattjaai se na rahiehe, tab Parmeswar kaise toke oe dhan dei sakiega djaun hardam khaatien tor rahiega? ");
INSERT INTO hnsNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ekgo goelaam doei maaliek na maan sake hai. Oe ekgo ke tjaahiega aur ekwa ke djariega. Oisahie toelog Parmeswar ke aadar kare aur doenia ke dhan batore sanghe bhie na kar paihe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tab Fariesie logan ie sab baat soenke Jiesoe ke tiebolie maare lagal. Oesab to paisa ke haahie raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tab oe oesabse bolies: „Toelog maange hai manai ke aage bahoet sattja khele, bakie Parmeswar toelogke diel djaane hai. Djaun tjiedj manai log biesaal maane hai, oe Parmeswar ke bahoet kharaab lage hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Parmeswar ke kaanoen aur okar sanesian ke baat hamlogke rasta dekhaawat raha djab talak Johaanas dopoe kare waala na aail. Oe tem se ie khoes khabar partjaar karal gail kie Parmeswar maange hai manai ke diel me raadj tjalaawe. Aur har ek ie khabar soenke bahoet kausies kare hai okar raadj me bhiettar djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dhartie aur aasmaan na sahadj se alop hoi djaai. Aur Parmeswar ke kaanoen me se koetjh mietaawe auro moeskiel hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Aur dje aapan aurat tjhorke doesar biaah karie, oe aapan biaah ke waada toeriega. Aur dje ekgo tjhoetal aurat se biaah karie, oe aisane kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jiesoe auro kahies kie: „Ekgo dhanie aadmie raha. Oe hardam bahoet mahanga kapra pahienke aur nauta deike maudj manaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ekgo bhiekhmanga bhie raha. Rodj koi oke dhanie aadmie ke dwaar ke aage laaike dhar dewat raha. Okar naam Laasaaras raha. Okar dehie bhar me ghaaw niekaral raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Oe maangat raha dhanie aadmie ke batjal khaaik se aapan pet bhare. Aur koetta aawat raha okar ghaaw tjaate. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ek dien bhiekhmanga mar gail aur Parmeswar ke parie log oke Aabraaham ke paas legail. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Koetjh dien baad dhanie aadmie bhie mar gail aur okar mattie paral. Tab djab oe maral manai ke djagaha me aapan aakhie kholies, tab doerie me bhiekhmanga Aabraaham ke saathe dekhies. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tab oe tjiellaaike Aabraaham se bolies: ‘Pieta djie, hamme daaja karo! Ham ie aagie me doekh kaatiela. Aap bhiekhmanga ke okar angoerie paanie me borke pathaawo hamaar djieb thandhwaawe khaatien.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tab Aabraaham bolies: ‘Beta, sotj kie toe kaise doenia par djiejat rahiele. Toke khaalie barhia tjiedj mielat raha aur Laasaaras khaalie doekh kaatat raha. Ab oe soekh me rahe hai aur toe doekh kaate hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aur hamlogke bietj me bahoet gahieraai hai. Dje hia se tor lage maangie djaai, oe na djaai paai. Aur djab koi oepaar se iepaar maangie aawe, tab oe bhie na aai paaiga.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tab oe bolies: ‘Tab ham aapse bienaai kariela kie aap bhiekhmanga ke hamaar baap ke ghare pathaaw. Hamke to paatj bhaai hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tab oe oesabhanke karaai se samdjhaai sakie djeme oesab ie doekh me na aawe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tab Aabraaham bolies: ‘Oesab Mosas ke aur Parmeswar ke doesar sanesian ke liekhal baat parh sake hai. Oesabke tjaahie okar baat soene ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tab oe bolies: ‘Na, Pieta djie, oesab na soeniega. Bakie djab ekgo maral aadmie hia se oesabke lage djaai, tab oesabhan aapan djiewan badal deiga.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tab Aabraaham bolies: ‘Djab sabhan Mosas ke aur doesar sanesian ke baat na maange hai soene, tab tjaahe ek maral aadmie djie oethie, tabbo oesab aapan djiewan na badalie.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jiesoe aapan tjela log se bolies kie: „Manai logan ek doesare ke djaroer bahakaaiga. Bakie dje aise karie, oe bahoet doekh kaatie. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ohie se djab koi hamaar ek tjela se paap karwaai, tab bestar rahie kie pahiele ekgo barka ieta okar gatai me baanhke oe samoendar me bahaai dewal djaai. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Batjaaike rahiehe. Djab tor bhaai paap karie, tab oke samdjhaawe ke tjaahie. Aur djab oe aapan paap pastaai, tab oke maaf kar deihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aur djab oe ek rodj me saat dafe paap karie aur saato dafe pastaaike bolie kie: ‘Hamke maafie kar de,’ tab toke tjaahie oke har ek dafe tjhama kar dewe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tab oesab poetjhies: „Prabhoe, hamlogke bieswaas barhaaw.” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tab oe bolies: „Djab toelogke bieswaas ekgo tjhota bia ghat rahat, tab toelog ie phal ke per se bolte: ‘Sor sanghe oekharke samoendar me djam dja,’ aur oe tor baat soen lewat.” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jiesoe bhie bolies: „Maan le kie toke ek goelaam hai. Oe tor khaatien khet djote hai, kie gaai-goroe tjaraawe hai. Djab oe kaam par se ghare aai, tab toe thoro ose boliehe: ‘Haalie se dja kha le’? ");
INSERT INTO hnsNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Na, toe pahiele ose boliehe: ‘Nahaaike hamaar khaatien khaaik pakaaw aur niekaarke hamme de. Tab djab ham khaai pieke don hoi djaabe, tab toe khaai pie sakiehe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aur djab oe aapan kaam se don hoi djaai, tab toe oke thoro dhanbaad deihe? ");
INSERT INTO hnsNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aisane bhie toelog dhanbaad na agoriehe sab kaam khaatien djaun toelogke dewal gail. Toelogke bole ke tjaahie: ‘Hamlog to nietja goelaam baatie aur khaalie aapan kaam karlie hai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tab djab Jiesoe aur aage Jeroesaalem djaat raha, tab oe rasta dharies djaun Saamaaria des aur Gaalielea diehaat ke bietj me paral. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ohie tem djab oe ekgo gaaw ke nagietj pahoetjal, tab das korhia ke bemarian aaike doerieje par thara bhail. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tab oelog tjiellaaike bole lagal kie: „Jiesoe djie, hamlogke daaja kar!” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tab Jiesoe oesabke taakke bolies: „Dja agwan ke paas aur apane ke dekhaaw.” Bas djaate ke bera oesab attjha aur safa hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tab ekgo djab djaan gail kie oe attjha hoi gail hai, tab Parmeswar ke goen gaaike Jiesoe ke paas lautke gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tab oe Jiesoe ke gore gierke oke dhanbaad dewe lagal. Aur oe ek Saamaaria des ke aadmie raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tab Jiesoe bolies: „Das djane to attjha bhail! Tab naugo kaaha hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Khaalie ehie pardesie aail hai Parmeswar ke aadar kare khaatien?” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aur oe ose bolies: „Oethke dja ghare. Tor bieswaas toke batjaais hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ek rodj Fariesie log Jiesoe se poetjhies kie: „Parmeswar kab soeroe kariega ie doenia me raadj tjalaawe ke?” Tab oe bolies: „Manai log Parmeswar ke raadj aapan aakhie se na aawat dekh sakiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Koi na bol sakiega: ‘Dekh hia, kie to hoewa hai.’ Ab to Parmeswar soeroe karies hai manai ke diel me raadj tjalaawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aur oe aapan tjela log se bolies kie: „Aisan tem aaiga djaun me toelog mangiehe iensaan ke Beta ke dekhe, tjaahe khaalie ek rodj, bakie na dekh paihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tab koi koi boliega: ‘Dja dekh, hoewa hai!’ Kie to: ‘Aaw, hia hai!’ Tab hoewa na djaihe aur okar paatjhe na tjaliehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Oe dien djab iensaan ke Beta lautke aaiga, tab oe djaise tjamkat biedjalie sagaro dekhaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bakie pahiele oke dher doekh oethaawe ke parie aur ab ke tem ke manai logan oke na maangiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Djaise Noah ke tem me raha, aisane iensaan ke Beta ke laute se pahiele bhie rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Abbe oe tem ke manai khaate-piete aur biaah karte raha oe dien talak djab Noah djahaadj me gail aur etana dher paanie aail kie sab bahare waalan doeb gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aur Lot ke tem me bhie aisane bhail. Sab koi abbe oisane khaat-piejat, kienat-betjat, bowat-banaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bakie oe dien par djab Lot Sodom sahar me se bhaag gail, tab aagie baroed sanghe barse lagal aur hoewa ke sab manai naas hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aur aisane bhie hoiga djab Parmeswar iensaan ke Beta ke dekhaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Oe dien par djab koi aapan ghar ke daak par rahie, tab oke na tjaahie nietje djaai ke aapan tjiedj ghar me se lewe khaatien. Aur dje aapan khet me rahie oke bhie na tjaahie lautke ghare djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sotj Lot ke aurat se ka bhail raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dje maangie aapan djiewan apane khaatien bietaawe, oe barbaad hoi djaai. Bakie dje aapan djiewan doesare khaatien bietaawe hai, oe Parmeswar ke sanghe djiewan paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Oe raat me doei djane ek bedie par soetal rahiega. Oman se ekgo lei lewal aur ekwa tjhor dewal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Sabere doei aurat sanghe piesat rahiega. Oman se bhie ekgo lei lewal aur ekwa tjhor dewal djaaiga.  ");
INSERT INTO hnsNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Doei aadmie sanghe khete me kaam karat rahiega. Ekgo oman se lei lewal aur ekwa tjhor dewal djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tab tjela log poetjhies kie: „Prabhoe, ie kaaha hoiga?” Tab Jiesoe bolies: „Djaaha moerda paral rahiega, hoewa par bhie giedh djoetal rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tab Jiesoe ekgo matlab ke kaahaanie kahies tjela log ke siekhaawe ke kie hardam praatna kare ke tjaahie biena hiemmat haare. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","„Ek sahar me ekgo djadj raha. Oe Parmeswar aur manai se be-gam raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aur oe sahar me bhie ekgo wiedhwa raha. Oe eksoer okar paas djaaike ose bolat raha kie: ‘Hamaar aur hamaar doesman ke bietj me faisala kar dewo.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Koetjh tem khaatien oe djadj na maangat raha soene. Bakie baad me oe sotjies kie: ‘Hamme Parmeswar se aur manai se koetjh ke gam na hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Bakie ie aurat hamme etana thaka deis hai kie ham aur aage na sahie paabe. Bestar hai kie ham okar khaatien faisala kar dei.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aur oe bolies: „Soenle kharaab djadj ka bolies? ");
INSERT INTO hnsNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Djab oe aise karie, tab Parmeswar kaise aapan tjoenal waalan khaatien na faisala kariega? Oesab to raat dien oke bolaawe hai! Oe djaroer na oesabke derie talak agorwaai! ");
INSERT INTO hnsNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ham toelogse satj boliela kie oe halieje se oesabke khaatien faisala kariega. Bakie djab iensaan ke Beta dhartie par lautke aaiga, tab oe aisan bieswaas paaiga djaise oe wiedhwa ke kie na?” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Oe phien ekgo matlab ke kaahaanie bataawe lagal. Oe maangat raha samdjhaawe kie koetjh manai aapan kasoer na dekhe hai aur oesab doesar koi ke khaalie niehaare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ohie se oe bolies: „Ek dien doeigo aadmie Jeroesaalem sahar gail Parmeswar ke mahal me praatna kare khaatien. Ekgo Fariesie raha aur ekwa baimaan djoetie ke paisa lewe waala raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tab Fariesie aaike hoewa khara hoike praatna kare lagal: ‘Parmeswar, ham toke dhanbaad deila kie ham na djaise doesar manai log baatie. Oesab to kharaab hai, koi ke samaan harap lewe hai aur aapan biaah ke waada toere hai. Aur ham khoesie baatie kie ham na djaise ie baimaan djoetie lewe waala baatie. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Hapta me ham doei dafe rodja kie to bhoekha rahiela, aur ham aapan kamaai me se daswa hiessa tore khaatien alag kariela.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Djoetie ke paisa lewe waala paatjhe me bhie thara raha. Oe aapan paap pastaat raha aur oke hiau na raha oeppar taake ke. Oe tjhaatie par piet-pietke bolies: ‘Parmeswar djie, ham paapie baatie. Hamke daaja karo.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aur Jiesoe bolies: „Soen, ie aadmie ghare djaaike Parmeswar ke aakhie me be-kasoer hoi gail raha. Oe paap ke tjhama paais raha, bakie Fariesie tjhama na paais raha. Dje apane ke barka maane hai, oe nietja karal djaaiga. Aur dje apane ke nietja samdjhe hai, oe barka karal djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ek dien koetjh manai log aapan tjhota larkan ke Jiesoe ke paas laais. Oesab maangat raha kie oe haath dharke larkan ke aasier-baat dewe. Bakie djab tjela log dekhies, tab maai-baap ke daate lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tab Jiesoe larkan ke aapan paas bolaais aur tjela log se bolies: „Tjhota larkan ke na rok bakie aawan de! Parmeswar ke raadj aisan tjhota larkan khaat hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Dhiaan se soen. Djab toelog Parmeswar ke baat na maange hai soene djaise ekgo tjhota larka, tab toelog okar raadj me kabhie na djaai sakiehe!” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ek dien ekgo oetja dardja waala aadmie Jiesoe se poetjhies kie: „Maastar djie, aap to bhala aadmie baato. Aap hamse bol sake hai ka kare ke tjaahie hardam khaatien Parmeswar ke saath rahe ke?” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tab oe bolies: „Toe kaahe ke bolle kie ham bhala baatie? Khaalie Parmeswar bhala hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Toe djaane hai kie Parmeswar ke kaanoen me liekhal hai kie toke na tjaahie aapan biaah toere ke, koi ke djaan maare ke, tjorie kare ke, koi ke abdjas lagaawe ke, aur toelogke tjaahie aapan maai-baap ke ieddjat kare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tab aadmie bolies: „Ie sab baat ham tjhotahie se karte aaila.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tab oe ie baat soenke bolies: „Toke khaalie ek tjiedj kamtie hai. Aapan sab tjiedj betjke aur paisa garieb log ke baat de, tab toke swarag ke dhan mielie. Aur hamaar paas aaw hamaar tjela bane khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bakie djab aadmie ie baat soenies, tab oke bahoet oedaas bhail. Oe to bahoet dhanie raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tab Jiesoe oke taakke bolies: „Dhanie waalan khaatien moeskiel hai Parmeswar ke raadj me bhiettar djaai khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ekgo oet khaatien auro sahadj hai ekgo soei ke hol me djaai ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tab hoewa ke manai log bolies: „Tab ke sadja me se batjke hardam khaatien Parmeswar ke saath rahie sakie?” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tab oe bolies: „Djaun iensaan na kar paai, oe tjiedj Parmeswar kar paaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tab Petras bolies: „Dekh, hamlog to aapan sab tjiedj tjhorke tor tjela ban gailie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tab oe bolies: „Ha, aur ham toelogse satj boliela kie har ek djaun aapan ghar-dwaar, aurat, bhaai-bahien, maai-baap, kie to larkan tjhor dei Parmeswar ke raadj ke khoes khabar soenaawe khaatien, ");
INSERT INTO hnsNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","oke ie tem me ese auro djaada mieliega. Aur aane waala djoeg me oe sada ke lieje Parmeswar ke saath rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ekare baad Jiesoe aapan baara tjela log ke alag karke bolies kie: „Soen, ab hamlog tjalie Jeroesaalem. Aur Parmeswar ke sanesian ke sab baat iensaan ke Beta ke biese me poera hoi djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hoewa par ham doesar djaat log ke haath me saup dewal djaab. Oesab hamme hasiega, bedjatie kariega aur hamaar oeppar thoekiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Oesab hamme tjamotie se pietiega aur maar dhaariega. Tab tiesara dien par ham djie oethab.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bakie tjela log na samadjh paais. Ie baat ke matlab to oesabke khaatien tjhiepal raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tab Jiesoe Jerieko sahar lage pahoetjal. Hoewa par ekgo andha daam lage baithke bhiekhmaangat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Djab oe soenies kie dher manai paas howe hai, tab poetjhies: „Hia ka howe hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tab koi bolies kie: „Naasaaret sahar ke Jiesoe paas howe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tab oe tjiellaaike bole lagal kie: „He Jiesoe, raadja Daawied ke aulaad, hamme daaja karo!” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bakie djaun aadmie log aage paas howat raha, oesab oke daatke bolies: „Tjoep! Aise na tjiella!” Bakie oe auro djor se bolaawe lagal: „Daawied ke aulaad, hamme daaja karo!” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tab Jiesoe khara hoike bolies: „Oke hia laaw.” Djab andha aail, tab Jiesoe poetjhies: ");
INSERT INTO hnsNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","„Ham tor khaat kaun tjiedj karie?” Tab aadmie bolies: „Prabhoe djie, ham maangiela dekhe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tab oe bolies: „Ab se dekhe lag! Tor bieswaas dwaara toe attjha hoi gaile hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aadmie toerant dekhe lagal aur Parmeswar ke goen gaaike Jiesoe ke saath tjale lagal. Tab manai log dekhke Parmeswar ke goen bhie gaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tab Jiesoe Jerieko sahar me pahoetjal aur auro tjalal. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hoewa par ek Sakeas naam ke aadmie rahat raha. Oe djoetie ke paisa lewe waalan ke barkwa raha aur dhanie raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Oe maangat raha Jiesoe ke dekhe, bakie hoewa dher manai raha aur oe naata raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tab dhaurke oe haalie se ekgo per par tjahar gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tab djab Jiesoe oe per lage pahoetjal, tab oeppar taakke bolies: „Sakeas, haalie se nietje oetar, aadj hamke tjaahie tor ghare rahe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeas haldie se nietje oetaral aur Jiesoe se bahoet khoesie se bhet karies aur oke aapan ghar me bhiettar laais. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tab sab bahare ke manai barbaraai lagal kie: „Oe aisan paapie ke ghare gail hai!” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tab Sakeas oethke bolies: „Prabhoe djie, soeno. Ham aapan dhan-daulat me se aadha garieb logan ke debe. Aur har ek tjiedj djaun ham thagalie hai, ham tjaar dafe lautaarke debe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tab oe bolies: „Attjha, ie bahoet barhia bietjaar hai. Aadj Parmeswar ie ghar-bhar ke batjaais hai. Ie ghar ke barkwa bhie Aabraaham ke aulaad hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Iensaan ke Beta to aail hai bhatkal waalan ke khodje aur batjaawe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jiesoe Jeroesaalem ke nagtjaail raha. Aur manai logan sotjies kie oe halieje raadja hoi djaat. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ohie se oe ek matlab ke kaahaanie kahe lagal kie: „Ek oetja dardja waala aadmie ek doer des gail raadja bane aur baad me oe aapan des lautke aai raadj tjalaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Djaai se pahiele oe aapan goelaam log me se dasgo ke bolaais aur oesabke ek ekgo mohar deike bolies: ‘Ese auro paisa kamaihe djab talak ham lautke na aabe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bakie okar des ke djaatie logan oke djarat raha aur ekaat sanesian okar paatjhe pathaais bataawe khaatien kie: ‘Hamlog na maangiela kie toe hamlogke oeppar raadj tjalaihe.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Koetjh dien baad oe raadja banke aapan des lautke aail. Tab oe goelaam log ke bolwaais djaun ke oe mohar deis raha. Oe maangat raha djaane kie oesabhan ketana paisa kamaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pahiela waala aaike bolies: ‘Raadja djie, ham aapke paisa se das dain auro kamailie.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tab oe bolies: ‘Ie barhia kaam hai! Toe ek bharosaadaar goelaam baate. Toe kamtie paisa se hiessaab se rahiele, ohie se ham toke das sahar debe raadj tjalaawe ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tab doesara aaike bolies: ‘Raadja djie, ham aapke paisa se paatj dain auro kamailie.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tab oe bolies: ‘Toke ham paatj sahar debe dekh-bhaal kare ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tab tiesara goelaam aaike bolies kie: ‘He raadja, hia hai aapke paisa. Ham kapra me khoeb thiek se loekwailie rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ham deraat rahielie. Aap to daajaaloe na baate. Aap lewe hai djaun na kamaile hai aur kaate hai djaaha na boile hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tab oe bolies: ‘Are, kharaab goelaam! Ham ie baat par tore oeppar faisala karab. Toe djaane hai kie ham daajaaloe na baatie. Ham to leila djaun ham na kamailie hai aur kaatiela djaaha na boilie hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tab toe kaahe ke hamaar paisa kardja dewe waalan lage na dharle? Tab laute ke baad ham aapan paisa aur biaadj lei leitie.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Oe ekwan se bolies: ‘Okar mohar leike oke dei de djaun aapan waala se dasgo kamaais hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tab oesab bolies: ‘Raadja djie, oke to dasgo hai!’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tab oe bolies: ‘Ha, ie satj hai. Dje ke koetjh hai, oke auro mieliega. Bakie dje ke thora se hai, okar ohoe lei lewal djaai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Oe bhie bolies: ‘Hamaar doesman logan ke hia laaw. Oesab na maangat raha kie ham oesabke oeppar raadj tjalaai. Ab oesabke hamaar aakhie ke saamne maar dhaar.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tab djab Jiesoe ie kaahaanie bataai tjoekal raha, tab oe aapan tjela log ke sanghe Jeroesaalem djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aur djab oe Betfaage aur Betaania ke gaaw Djaitoen pahaar lage pahoetjal, tab doeigo tjela se bolies: ");
INSERT INTO hnsNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","„Oe gaaw me dja, tab dekhiehe hoewa ek gadahie ke battja baanhal hai. Opar abbe koi na baithal hai. Oke kholke hamaar paas laaw. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aur djab koi poetjhie: ‘Toe kaahe ke khole hai?’ tab boliehe: ‘Eke Prabhoe ke djaroerie hai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ie doeno gail aur battja ke paais djaise oe bataais raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tab djab oelog kholat raha, tab ghar waalan poetjhies: „Toelog kaahe ke oke khole hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tab oesab bolies: „Eke Prabhoe djie ke djaroerie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tab oelog battja ke Jiesoe ke paas laais. Aur aapan kapra battja par rakhke oesab Jiesoe ke oeppar baithaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tab djab oe djaai lagal, tab sab manai log aapan kapra rasta par bietjhaai deis okar aadar kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tab oesab Djaitoen pahaar ke rasta par gail aur tjela ke djhoend Parmeswar ke goen gaawe lagal. Oesab Jiesoe ke sab atjambho kaam ke biese me bahoet khoesie raha ");
INSERT INTO hnsNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","aur djor se gaawe lagal kie: „Raadja par Prabhoe ke aasies howe! Oe okar naam se aawe hai! Swarag me sjaantie aur oeppar Waala ke aadar rahe!” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bakie djhoend me koetjh Fariesie raha aur oelog Jiesoe se bolies: „Maastar djie, aapan tjela log ke daat.” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tab oe bolies: „Djab oelog tjoeppaai djaai, tab hia ke patthar aapan aawaadj soenaai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tab djab Jiesoe Jeroesaalem sahar nagtjaail, tab ekar manai khaatien rowe lagal ");
INSERT INTO hnsNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aur bolies: „Ham bahoet maangiela kie toelogan aadj ke dien samadjh dja kaun tjiedj djaroerie hai sjaantie paawe khaatien. Bakie toelog abbe na dekh sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Toelog bahoet moesiebat me rahiehe. Doesman log toelogke sahar gherke ekdam se band kar deiga aur toelogke dher doekh katwaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Oesab toelogke aur toelogke baal-battjan ke gor se katjar dhaariega. Toelog na samadjhle hai kie Parmeswar ab toelogke ketana khiaal kare hai. Ohie se oesab sahar bhar ekdam naas kar deiga aur ie sab moesiebat toelogke oeppar aaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ekare baad Jiesoe Parmeswar ke mahal ke angana me gail aur hoewa ke betje waalan ke khadere lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Oe bolies: „Parmeswar ke poestak me liekhal hai kie: ‘Hamaar ghar praatna ke ghar rahiega, bakie toelog eke daakoe ke ghar bana deile.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Oe dien se oe Parmeswar ke mahal ke angana me siekhaawat-parhaawat raha. Barka agwan aur dharam ke parhal waalan aur bhie djaatie ke barkwan maangat raha oke maar dhaare. ");
INSERT INTO hnsNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bakie hardam ek djhoend manai okare lage kaan oethaile rahat raha har ek baat soene khaatien. Ohie se barkwan ke mauka na mielat raha oke pakare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ek rodj Jiesoe Parmeswar ke mahal ke angana me siekhaawat raha aur khoes khabar partjaar karat raha. Tab barka agwan, dharam ke parhal waalan aur Israel ke barkwan aaike okare paas thara bhail ");
INSERT INTO hnsNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aur ose poetjhies: „Hamlogse bataaw kie toke ke hoekoem deis hai ie sab kaam kare khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Tab oe bolies: „Ham maangiela toelogse bhie koetjh poetjhe. Hamse bataaw kie Johaanas ke Parmeswar hoekoem deis raha dopoe kare khaatien, kie manai logan?” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tab oesab apane me batiaai lagal kie: „Djab hamlog bolab: ‘Oke Parmeswar hoekoem deis raha,’ tab oe boliega: ‘Tab toelog kaahe ke okar baat na bieswaas karle?’ ");
INSERT INTO hnsNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aur djab hamlog bolab: ‘Oke manai log hoekoem deis raha,’ tab djhoend mielke hamlogke ieta bahaaike maar dhaariega. Oesabhan to sattje ke bieswaas kare hai kie Johaanas Parmeswar ke ek sanesia raha.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ohie se oelog Jiesoe se bolies: „Hamlog na djaaniela.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tab oe bolies: „Tab ham toelogse bhie na bataabe kie hamme ke hoekoem deis hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jiesoe djanta se ek matlab ke kaahaanie kahe lagal kie: „Ekgo aadmie djangal kaatke aur oe khet me agoer ke per bois. Tab oe khet ke bhaara karies aur koetjh tem khaatien par-des tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tab djab tem aail, tab oe ek goelaam ke pathaais sauda me se aapan hiessa lewe khaatien. Bakie khetiar log oke maarke aur djhoere haathe lautaar deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tab djamiendaar ek doesar goelaam ke pathaais, bakie oesab ohoeke maarke bedjatie karies aur bhie djhoere haathe lautaar deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tab aadmie ek tiesara waala ke pathaais. Bakie khetiar logan oke bhie tjotwaaike khet me se bahaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tab djamiendaar sotjies: ‘Ab ham ka karie? Laaw ham aapan pjaara beta ke pathaai. Oesab okar ieddjat karke tjhor deiga.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bakie djab khetiar log beta ke dekhies, tab apane me batiaai lagal kie: ‘Ie to ie khet ke hakdaar hai. Laaw hamlog eke maar dhaarie dja, tab ekar hak hamlogke hoi djaai.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bas oesab oke khet se baahar ledjaaike maar dhaaries.” Jiesoe manai log se poetjhies kie: „Toelog ka sotj hai kie khet ke djamiendaar khetiar log se ka karie? ");
INSERT INTO hnsNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Oe aaike oesabke naas kariega aur khet doesar koi ke oeppar saup deiga.” Tab oesab bolies: „Ie to kabhie na hoi sake hai!” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tab oe oesabke taakke bolies: „Parmeswar liekhwaais hai: ‘Djaun ieta ghar banaawe waalan be-kaamiel maanat raha, ohie sab se kaamiel waala hoi gail hai.’ Toelog ka sotje hai kie ie baat me kaun matlab hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Oe bolies: „Dje oe ieta par gieriega, oke bahoet tjot lagiega. Aur djekar oeppar oe ieta gier djaaiga, oe ekdam se pietjla hoi djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dharam ke parhal waalan aur barka agwan samadjh gail raha kie Jiesoe ie kaahaanie oesabke biese me bataawat raha. Ohie se oesab maangat raha toerant oke pakare, bakie oelog manai log ke deraat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Oe same oesab mauka khodjat raha Jiesoe ke pakare khaatien. Tab oesab ekaat dhokhaabaadj log ke okar paas bhedjaais oke koetjh baat par phasaaike Roma ke laat ke haath me saupe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Oelog ose bolies: „Maastar djie, hamlog dekhiela kie toe sattjaai se siekhaawe hai aur koi ke moeh na taake hai. Toe sab koi ke Parmeswar ke siedha rasta dekhaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ohie se hamlogse bataaw kie Mosas ke kaanoen me liekhal hai kie mienaahie hai Roma ke maahaaraadja ke djoetie bhare ke kie na.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bakie oe oesabke kharaab tjalaakie samadjh gail aur bolies: ");
INSERT INTO hnsNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","„Hamme ek tjaanie ke paisa dekhaaw. Epar kekar naam aur moerat hai?” Tab oelog bolies: „Maahaaraadja ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tab oe bolies: „Ohie se maahaaraadja ke de djaun okar hak hai, aur Parmeswar ke bhie okar de.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tab ie baat soenke oesab atjambho bhail aur moeh band karke rahie gail. Aur djhoend dekhies kie oesab oke ekko baat par na pakar paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tab ekaatgo Sadoesie log bhie Jiesoe ke paas aail. Oesab na bieswaas kare hai kie iensaan djie oethiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tab oelog bolies: „Maastar djie, Mosas ke kaanoen me liekhal hai kie djab ek aadmie mar djaai aur oke larkan na hai, tab okar bhaai ke tjaahie okar aurat se biaah kare ke. Aur djab aurat ke larkan paida hoi, tab sab se barka betwa pahiela aadmie ke naam aur hak paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Maan le kie saatgo bhaai raha. Ek dien pahiela waala begar larkan ke mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tab doesara aapan barka bhaai ke aurat se biaah karke bhie begar larkan ke mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aur tiesara se bhie ehie haal bhail. Aisane saato se hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tab ant me aurat bhie mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Djab manai logan djie oethiega, tab saato bhaai me se ie kekar aurat rahiega? Oe to saato ke aurat raha.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tab oe bolies: „Ie tem ke manai log biaah kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bakie dje djie oethiega aur aane waala djoeg me rahe laaik rahie, oe biaah na kariega. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Oesab djaise parie logan phier se na mar sakiega bakie Parmeswar ke djie oethal betwan aur bietian rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Soen, djab Prabhoe djarat djhalaasie me Mosas ke dekhaail, tab oe bolies kie: ‘Ham Aabraaham, Iesaak aur Jaakob ke Parmeswar baatie.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Oe tieno mar gail raha, bakie Prabhoe ke lieje oesab djieje hai. Oe maral logan ke Parmeswar thoro hai, bakie djienda waalan ke. Aisane Mosas dekhaais kie maral waalan djie oethiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tab ekaat dharam ke parhal waalan bolies: „Maastar djie, ie to bahoet barhia baat hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Oelogke hiemmat na raha koetjh auro poetjhe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tab Jiesoe poetjhies kie: „Kaahe ke soena hai kie Kriest raadja Daawied ke aulaad hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Daawied to Parmeswar ke poestak ke ek gaana me liekhies hai kie: Prabhoe hamaar Prabhoe se bolies: ‘Aaw hamaar dahiena bagal baith djab talak ham tor doesman ke tor gor ke tare na dharab.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daawied Kriest ke aapan Prabhoe bolaawe hai. Toelog thiek se sotj oe kaise okar aulaad bhie hoi sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tab djab sab manai soente raha, tab Jiesoe aapan tjela log se bolies: ");
INSERT INTO hnsNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","47","„Dharam ke parhal waalan se batjaaike rahiehe. Oesab lamba lamba kapra pahienke rasta par tjale hai aur oesabke attjha lage hai dher manai ke aage aadar paawe ke. Partjaar ke ghar aur nauta me oesab hardam aage baithe hai. Oelog bhaktie ghat hardam praatna kare hai. Aur ehie me oesab wiedhwa logan ke dhan-daulat me se kha hai. Iesabhanke doesar paapie log se auro kathien sadja mieliega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Djab Jiesoe aapan aas-paas me taakies tab dekhies kaise dhanie log aapan paisa Parmeswar ke mahal ke baakas me daare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Oe bhie dekhies kaise ek garieb wiedhwa aaike khaalie doei kopro ke paisa oman daare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tab oe aapan tjela log se bolies: „Ham toelogse satj boliela kie ie wiedhwa doesar waalan se auro dher deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Oesab to aapan dhan me se deis, bakie oe betjaarie aapan sab sauda ke paisa daan karies.” ");
INSERT INTO hnsNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ekaat djane Parmeswar ke mahal ke biese me bole lagal kie: „Dekh ketana biesaal ieta se banaawal hai aur barhia daan dewal waala tjiedj se sadjaawal hai.” Tab Jiesoe bolies: ");
INSERT INTO hnsNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","„Ek dien aai kie ie mahal ke sab dewaal toer dhaaral djaai, aur ekko ieta tarke oeppar na rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tab tjela log poetjhies kie: „Maastar djie, ie kab hoiga? Aur hamlog kaise djaan paabe kie tem aai gail hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tab oe bolies: „Batjaaike rahiehe kie toke koi na bahakaai lei. Dher log aaike boliega: ‘Ham Kriest baatie.’ Aur bhie: ‘Aane waala tem nagietj aail gail hai!’ Aisan manai ke pietjha na pakariehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aur djab toelog soeniehe kie manai logan laraai kare hai aur haltjal matjaawe hai, tab na ghabaraihe. Ie sab tjiedj pahiele howe ke tjaahie, bakie tabbo ie djoeg ke ant abbe na aai rahie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Oe bolies: „Ek djaatie doesar djaatie se aur ek des doesar des se laraai karie. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hia hoewa barka bhoeidol aai, akaal parie aur tjaaro bagal kharaab bemaarie phailie. Aur bhie bahoet ghabaraahat aur atjambho tjienha aasmaan me dekhaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ie sab tjiedj howe se pahiele manai toelogke pakarke partjaar ke ghar ke barkwan ke haath me saup deiga. Oesab toelogke djahal me band kar deiga, aur hamaar tjela bane ke biese me raadja aur laat log ke aage ledjaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tab toelog aapan bieswaas ke biese me gawaahie dei sakiehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bakie toelog agwe se sotj-phiekier na kariehe kaise apane ke batjaawe ke tjaahie. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ham to apane toelogke gjaan aur baat debe, tab doesman koetjh na bol paawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Toelog bhie aapan maai-baap, bhaai, palwaar aur sanghatian dwaara doesman ke haath me saup dewal djaihe aur oesab toelog me se koi koi ke maar dhaariega. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sab koi toelogke djaran kariega hamare me bieswaas kare ke khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tabbo koi tor koetjh na kar paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Aur djab toelog hiemmat na hariehe, tab toelog aapan djiewan batjaihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Djab toelog dekhiehe kie soerdjaatie ke djhoend Jeroesaalem ke ghere hai, tab djaan djaihe kie sahar ke barbaadie nagietj aai gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tab Joedea diehaat waalan ke pahaar ke or bhaage ke tjaahie. Aur dje sahar me hai, ohoeke hoewa se bhaage ke parie aur dje khet me hai, oke sahar me na djaaike tjaahie. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Oe dien Parmeswar sadja deiga djaise oe aapan sanesian se liekhwaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Djaun aurat log ke larka hoiga kie to doedh piaite rahiega, oesabke oeppar bahoet doekh pariega. Ie des ke oeppar barka moesiebat aaiga aur Parmeswar ie djaatie ke oeppar goessaail rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Oe dien dher manai talwaar se maar dhaaral djaaiga. Bhie doesar log pakaraaike aur har ek rakam des me ledjaawal djaaiga. Aur doesar des ke manai log Jeroesaalem me kara hoekoem se raadj tjalaaiga djab talak ohoesabke sadja na mieliega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jiesoe bolies: „Oe tem me soeroedj, tjaan aur tarai me har ek rakam tjienha dekhaaiga. Aur doenia bhar ke manai log samoendar ke halfa ke aawaadj soenke dar ke maare kaape lagie. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aasmaan ke sab saktie hieliega aur manai log ke bahoet dar samaaiga kie doenia par ka hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tab sab koi iensaan ke Beta ke baadar par barka saktie aur biesaal maahaanta me aawat dekhiega. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tab toelog halieje se tjhoetkaara paihe. Ohie se khara hoike oeppar takiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jiesoe ek matlab ke kaahaanie bataawe lagal kie: „Adjier ke per aur sab doesar per ke khoeb thiek se takiehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Djab phoel dewe lagie, tab toelog djaan djaihe kie phal ke tem aaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aisane djab toelog ie sab baat poera howat dekhiehe, tab samadjh djaihe kie dher dien na rahie gail hai kie Parmeswar raadj tjalaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Thiek se soen. Djaun manai ie sab tjiedj soeroe howat dekhiega, oesabke tem me hamaar sab baat poera hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dhartie aur aasmaan miet djaaiga, bakie hamaar baat hardam khaatien rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Oe bolies: „Batjaaike rahiehe kie toelog aapan dhiaan nauta, daaroe aur rodj ke kaar-baar me na lagaihe, nahie to oe dien toelogke khaat atjakke me aai. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Oe dien doenia bhar ke manai khaatien aaiga. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ohie khaatien agoriehe aur hardam praatna kariehe kie toelogke saktie miele batje ke aur iensaan ke Beta ke aage aawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jiesoe dien ke Parmeswar ke mahal ke angana me partjaar karat raha, aur raat ke oe sahar ke bahare Djaitoen pahaar par rahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aur sabere manai log phien mahal me djaat raha okar partjaar soene khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oe tem par Israel ke Paasan ke tiewhaar nagtjaail raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Barka agwan aur dharam ke parhal waalan mauka khodjat raha Jiesoe ke marwaai ke, bakie oesab djhoend ke deraat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tab saitaan Joedaas Eskaariot se ek hoi gail. Joedaas Jiesoe ke baaraago pathaawal waalan me se ekgo raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Oe barka agwan aur mahal ke siepaahie ke barkwan lage gail aur baat-tjiet karies kaise oe Jiesoe ke oesabke haath me saup dei sakie. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Oesab bahoet khoesie bhail aur ose ek hoike bolies: „Hamlog toke koetjh paisa debe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tab oe mauka khodje lagal Jiesoe ke pakarwaaike oesabke haath me saup dewe khaatien djab oe akele rahat. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tab tiewhaar ke pahiela dien aail aur har ek palwaar ke tjaahat raha ek bhera ke battja maare ke Paasan ke bhodjan manaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ohie se Jiesoe Petras aur Johaanas se bolies: „Toelog dja aur hamlogke khaatien bhodjan tajaar kar de.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tab oesab poetjhies: „Toe kaaha maange hai kie hamlog tajaar karie?” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tab oe bolies: „Soen, djab toelog sahar me pahoetjiehe, tab ek aadmie ke bhetaihe djaun ek gogliet paanie leike dja hai. Okar paatjhe tjaliehe aur okar sanghe ghar me bhiettar djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tab ghar ke maaliek se boliehe: ‘Maastar poetjhies hai: Ham kaaha par aapan tjela log ke sanghe Paasan ke bhodjan kar sakab?’ ");
INSERT INTO hnsNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tab oe toelogke ekgo barka oeppar waala kamra dekhaaiga. Oman sab tjiedj hai khaaik pakaawe khaatien. Hoewe par toelog bhodjan tajaar kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Oe doeno gail aur oisane paais djaise oe bolies raha aur bhodjan tajaar karies. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tab djab tem aai gail raha tab Jiesoe aapan baara pathaawal waalan sanghe gail bhodjan kare. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Khaite me oe bolies kie: „Ham bahoet maangat rahielie hamaar doekh howe se pahiele toelogke sanghe ie bhodjan kare. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ham ab se Paasan ke bhodjan na karab djab talak Parmeswar ke raadj me ie bhodjan ke matlab na poera hoiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tab ek gielaas wien leike oe Parmeswar ke dhanbaad deis. Tab tjela log se bolies kie: „Eke le aur paarie-paara pie. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ham toelogse boliela kie ab se ham tanko wien na piebe djab talak Parmeswar aapan raadj na dekhaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tab ek bret leike Parmeswar ke dhanbaad karke, toekkara toekkara toerke oe oesabke deis aur bolies kie: „Ie bret hamaar dehie hai djaun toelogke khaatien dewal djaaiga. Ab se eke hardam khaihe hamme jaad kare khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ekare baad oe oisane ek gielaas wien se karies. Oe bolies kie: „Ie wien ke matlab hai kie Parmeswar hamaar khoen bahaawe ke dwaara ek naawa baat-tjiet karies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Oe bhie bolies: „Soen, oe aadmie djaun hamme pakarwaaiga, oe hamare sanghe bhodjan kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iensaan ke Beta aisane mariega djaise Parmeswar aage se sallaah kar tjoekal raha. Bakie djekare dwaara oe pakarwaawal djaaiga, okar oeppar bahoet kathien moesiebat pariega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tab tjela log apane me moeh laraawe lagal kie: „Hamlog me se ke aisan kaam kariega?” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Oesab apane me bhie ek na raha kie barkwa ke hoi. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tab Jiesoe bolies: „Doenia ke raadja logan aapan djaatie ke oeppar barka khele hai aur mantrie logan apane ke sahaaita kare waalan bolwaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bakie toelog me aise na tjaahie rahe ke. Dje toelog me sab se barka waala rahiega, oke tjaahie tjhota banke rahe ke. Aur dje barkwa rahiega, oke tjaahie goelaam ghat rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ke sab se barka waala hai, dje bhodjan kare hai kie naukar? Tabbo ham toelogke bietj me ek naukar ghat baatie. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Toelog hardam sab moesiebat me hamaar paas rahiele. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Djaise hamaar Pieta Parmeswar hamke aapan raadj deis hai, oisane ham toelogke deila ");
INSERT INTO hnsNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","djeme toelog hamaar sanghe khaai pie sakiehe. Aur toelog raadja ke gaddie par baithiehe Israel ke baara koel ke oeppar faisala kare khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jiesoe Siemon Petras se bolies kie: „Siemon, Siemon, saitaan Parmeswar se maangies hai toelogke bieswaas dhaan ghat osaawe. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bakie ham tor khaatien praatna karlie kie tor bieswaas na ghate. Aur djab toe aapan paap pastaaike aapan djiewan badal tjoekiehe, tab aapan bhaai logan ke hiemmat deihe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tab Petras bolies: „Prabhoe djie, ham tajaar baatie tor saath djahal me djaai ke aur sanghe mare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Bakie oe bolies: „Na, Petras, ham djaaniela kie moerga bole se pahiele toe tien dafe boliehe kie toe hamme na djaane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jiesoe sab tjela log se bolies kie: „Djab ham toelogke pathailie rahielie partjaar kare khaatien biena paisa ke thailie aur biena djhorie se aur khaalie ek djora djoeta se, tab toelogke koetjh kamtie bhail raha kie na?” Tab oesab bolies: „Na, koetjh na.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tab oe bolies: „Bakie ab se dje ke paisa ke thailie hai, oke ledjaai ke tjaahie aur djhorie bhie. Aur dje ke talwaar na hai, oke tjaahie aapan koerta betjke ekgo kien lewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Thiek se soen. Parmeswar liekhwaais hai kie: ‘Oe daakoe me gientie rahie.’ Ie baat hamare biese me liekhal gail aur poera howe ke tjaahie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tab tjela log bolies: „Prabhoe djie, dekh, hia doei talwaar hai!” Tab oe bolies: „Attjha, thiek hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ekare baad Jiesoe sahar tjhorke Djaitoen pahaar par gail. Aur okar tjela log okar sanghe gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tab djab oelog hoewa pahoetjal, tab oe bolies: „Toelogke tjaahie praatna kare ke, nahie to toelog bahakaawal djaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tab oe auro doer gail aur gaathie par gierke praatna kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Oe bolies: „Pieta djie, djab hoi sakie, tab ie doekh hataai de. Tabbo hamaar man waala na kariehe, bakie aapan waala.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tab swarag me se ek parie aail oke taagat dewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ekare baad oke bahoet dar samaail aur oe auro praatna kare lagal. Okar pasiena khoen ghat hoi gail aur djamien par tjoewe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tab oe oethke tjela log ke paas gail aur dekhies kie oesabhan doekh ke maare soet gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Oe bolies: „Ka, toelog soete hai? Oeth aur praatna kar nahie to toelog bahakaawal djaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jiesoe aapan tjela log se abbe batiaite raha, tab etane me ek djhoend manai aail. Aur Joedaas aage tjalat raha. Oe baaraago pathaawal waalan me se ekgo raha. Tab oe Jiesoe ke paas gail ose tjoemma dewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tab Jiesoe bolies: „Joedaas, toe iensaan ke Beta se tjhaatie mielaaike doesman ke haath me saup deihe?” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tab djab doesar tjela log dekhies ka howe hai, tab poetjhies: „Prabhoe djie, ab hamlog aapan talwaar kaam me laai sakiela?” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aur ekgo tjela sab se barka agwa ke goelaam ke dahiena kaan kaat deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bakie Jiesoe bolies: „Na, oesabke aapan kaam karan de.” Aur oe aadmie ke kaan tjhoeike attjha kar deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tab oe barka agwan, Parmeswar ke mahal ke siepaahie aur Israel ke barkwan se poetjhies kie: „Ham thoro daakoe baatie kie toelog danda aur talwaar leike aile hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ham rodj toelogke sanghe Parmeswar ke mahal me rahielie aur toelog hamme na tjhoeile. Bakie ab toelogke mauka mielal hai saitaan ke saktie dwaara hoekoem tjalaawe khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tab oesab Jiesoe ke pakarke sab se barka agwa ke ghare legail. Aur Petras doerie me bhie aawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tab Jiesoe ke rakhwaalan angana me aagie baarke hoewa baith gail aur Petras aaike oesabke bietj me baithal. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tab djab ek goelaam aurat Petras ke aagie ke andjor me baithal dekhies, tab oe oke thiek se taakke bolies kie: „Ie aadmie Jiesoe ke sanghe raha.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tab Petras bolies: „Bahien, ham oke na djaaniela.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Thora der baad ek doesar djane oke taakke bolies kie: „Toe bhie oman ke baate.” Tab oe bolies: „Na, ham na baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lagbhag ek ghanta baad ek tiesara waala bolies kie: „Ham to djaaniela kie ie aadmie okare sanghe raha. Oe to bhie Gaalielea diehaat se aawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tab oe bolies: „Ham na samdjhiela kie toe ka bole hai.” Aur abbe oe batiaite raha, tab moerga bole lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ohie samai par Prabhoe ghoemke oke taakies. Aur atjakke me Prabhoe ke baat oke khiaal hoi gail kie: „Ham djaaniela kie moerga bole se pahiele toe tien dafe boliehe kie toe hamme na djaane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bas oe bahare djaaike khoeb rowe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tab Jiesoe ke rakh waalan okar hasie oeraaike oke maare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Aur okar aakhie kapra se baanhke ose poetjhies: „Ke toke maare hai? Toe to agam-djaanie baate!” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aur oesab okar auro bedjatie kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Djab saber bhail tab Israel ke barkwan, barka agwan aur dharam ke parhal waalan ekattha aaike Jiesoe ke aapan sabha me bolwaais aur bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","„Djab tohie Kriest baate, tab hamlogse bataai de.” Tab oe bolies: „Tjaahe ham bolab, tabbo toelog na bieswaas kariehe. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aur djab ham toelogse koetjh poetjhab, tab toelog na maange hai djabaab dewe. ");
INSERT INTO hnsNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bakie ab se iensaan ke Beta Pieta Parmeswar ke dahiena bagal baithal rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tab oesabhan bole lagal kie: „Tohie Parmeswar ke Beta baate?” Tab oe bolies: „Toelog to apane bolle hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bas oesab apane me sallaah karies: „Ab thiek hai, hamlogke doesar gawaahie ke djaroerie na hai. Hamlog to okar moeh se soen leilie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tab sabha waalan sanghe oethke Jiesoe ke Pielaatas ke aage legail. Oe Roma ke laat raha Jeroesaalem me. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hoewa oesab oke abdjas lagaaike bole lagal kie: „Hamlog djaan gailie kie ie manai des bhar me ghoem ghoemke sab djaatie ke kaan bhare hai. Oe bole hai kie Roma ke maahaaraadja ke djoetie ke paisa na bhare ke tjaahie aur bhie kie oe Kriest hai aur raadja hoiga.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tab laat Jiesoe se poetjhies: „Toe Israel ke raadja baate?” Tab oe bolies: „Toe apane bolle hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tab laat barka agwan aur djhoend se bolies: „Ham ie aadmie me ekko kasoer na pailie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bakie oesabhan ekke baat pakarle raha aur bolies: „Ie aapan siektjha se pahiele Gaalielea diehaat me, tab Joedea bhar me aur ab ie sahar me sab djaatie log se oeppaddar karwaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tab laat ie baat soenke poetjhies: „Ie aadmie Gaalielea diehaat ke hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aur djab oe djaan gail kie aise hai, tab oe oke Herodes lage pathaai deis. Herodes Gaalielea me raadj tjalaawat raha aur oe same par oe bhie Jeroesaalem me raha tiewhaar manaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Djab oe Jiesoe ke dekhies, tab bahoet khoesie bhail. Oe to okare biese me dher tjiedj soenies raha aur maangat raha oke dekhe. Oe sotjies kie saait Jiesoe ek atjambho kaam karie. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Oe dher sawaal poetjhe lagal, bakie Jiesoe ekko par djabaab na deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Barka agwan aur dharam ke parhal waalan bhie raadja ke paas aail raha aur oesab phien Jiesoe ke bahoet abdjas lagaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tab raadja aapan soerdjaatie ke sanghe Jiesoe ke nietjaai karke okar hasie oeraawe lagal. Tab oke ek biesaal kapra pahienaaike phien se laat ke paas pathaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Oe dien se raadja aur laat sanghatian hoi gail. Pahiele to oe doeno doesman raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tab laat barka agwan, djaatie ke barkwan aur djhoend ke phien se bolwaais. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Bolies kie: „Toelog ie aadmie ke hamaar aage liaile aur oke kasoer deile kie oe sab djaat se oeppaddar karwaawe hai. Tab ham toelogke aage khodj karke ose poetjhlie, bakie okare me ekko kasoer na pailie. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aur raadja Herodes okare me bhie koetjh na paais aur oke pathaai deis. Ie aadmie koetjh na karies hai maut ke sadja paawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ohie se ham oke pietwaaike khoenwaaike aur tjhor debe.”  ");
INSERT INTO hnsNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Paasan ke nauta me laat ke tjaahat raha djaatie khaatien koi ke tjhor dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bakie oesabhan ek moeh hoike tjiellaais: „Oke hataai de! Hamlogke khaatien Baaraabaas ke tjhor de!” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baaraabaas sahar me oeppaddar oethaais raha aur koi ke djaan maare ke kaaran djahal me raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bakie laat maangat raha Jiesoe ke tjhore, ohie se oe djor se poetjhies: „Tab ham Jiesoe se ka karie?” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tab djhoend tjiellaaike bolies: „Oke kroes par tjaharaai de! Oke kroes par tjaharaai de!” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tab laat tiesara dafe poetjhies kie: „Bataaw oe kaun kharaab kaam karies hai. Ham okare me ekko kasoer na pailie maut ke sadja dewe khaat. Ohie se ham oke pietwaaike tjhor debe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bakie oesabhan auro djor se tjiellaaike bole lagal kie: „Oke kroes par tjaharaai de!” Aur oesab auro haltjal matjaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bas oe faisala karies kie djhoend ke man waala poera howe ke tjaahie. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aur oe djaan marwa ke tjhorwaai deis aur Jiesoe ke oesabke haath me saup deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tab djab soerdjaatie log Jiesoe ke ledjaat raha kroes par tjaharaawe khaatien, tab ek Siemon naam ke aadmie oesabke bhetaail. Oe Sierene sahar ke raha aur Jeroesaalem djaat raha. Oesab okar kandha par kroes laad deis Jiesoe khaatien dhowe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ek barka djhoend manai Jiesoe ke paatjhe bhie tjalat raha. Oman aurat log raha aur oesab oedaasie ke maare tjhaatie piet-pietke okare khaatien rowat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tab oe ghoemke oesabse bolies kie: „Jeroesaalem ke aurat, hamaar khaat na row, bakie aapan aur aapan larkan khaat! ");
INSERT INTO hnsNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aisan moesiebat ke tem aaiga kie bolal djaai: ‘Soekh me hai djaun aurat ke tjhota larkan na hai. Oesabke bhaage ke tem par larkan na lewe aur doedh piaawe ke parie.’ ");
INSERT INTO hnsNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Oe tem me manai log pahaar se boliega: ‘He pahaar, hamlogke oeppar gierke aur hamlogke top le.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aur oe apane aur aapan bieswaasie log ke biese me bolies: „Djab oesab kattja lakarie se aise kare hai, tab djhoeraail waala se ka hoiga?” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Doei djane auro Jiesoe ke sanghe ledjaawal gail kroes par tjaharaawal djaai khaatien. Ie doeno daakoe raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","34","Tab djab oesab „‘Khoprie”’ naam ke djagaha par pahoetjal, tab soerdjaatie log Jiesoe ke kroes par thok deis. Tab oe praatna karke bolies: „Pieta djie, ie manai log ke tjhama kar de. Oesab to na djaane hai kaun tjiedj kare hai.” Oesab baadjie lagaaike Jiesoe ke kapra apane me baat leis. Tab oesab doeno daakoe ke okar baawa aur dahiena bagal ek ek kroes par thok deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Djhoend thara hoike taakat raha aur oesabke barkwan Jiesoe ke tiebolie maarke bolies: „Oe doesar koi ke batjaawat raha. Djab oe Parmeswar ke tjoenal waala Kriest hai, tab oke tjaahie apane ke batjaawe ke!” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Tab soerdjaatie log bhie oke tiebolie maare lagal. Oesab aaike oke khatta wien lapkaaike bolies kie: „Djab toe Israel ke raadja baate, tab apane ke batjaaw!” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jiesoe ke kroes par to liekhal raha: IE ISRAEL KE RAADJA HAI. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tab doeno daakoe me se ekgo Jiesoe ke bedjatie kare khaatien bolies kie: „Ka, toe Kriest baate? Tab apane ke batjaaw aur hamlogke bhie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bakie ekwa oke daatke bolies: „Toe Parmeswar ke na dera hai? Toe to apane bhie kroes ke sadja paile hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ham aur toe ie sadja paawe laaik baatie. Aur hamlog aapan karnie ke phal paaila. Bakie ie aadmie ekko kharaab kaam na karies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aur oe Jiesoe se bolies: „Jiesoe, djab toe aapan raadj me djaihe, tab hamke jaad kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tab oe bolies: „Ham tose satj boliela kie aadj se toe hamaar sanghe Paramdes me rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Oe dien baara badje se soeroedj na dekhaail. Aur tien badje talak sagaro andhiaar raha. Tab Parmeswar ke mahal me sab se pawietr djagaha ke parda phaatke doei toekkara me bat gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Bas Jiesoe djor se bolies: „Pieta djie, ham aapan praan tore haath me saup deila.” Aur ie baat bolke oe aapan praan tjhor deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tab soerdjaatie ke barkwa ie tjiedj dekhke Parmeswar ke aadar kare lagal kie: „Ie sattje ke be-kasoer aur Parmeswar se ek raha.” ");
INSERT INTO hnsNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tab djhoend ie sab dekhke oedaasie ke maare tjhaatie piet-pietke laut gail ghare. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aur sab Jiesoe ke tjienhaar aur bhie aurat log djaun okare sanghe Gaalielea diehaat se aail raha, oesabhan doerieje se thara hoike taakat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ek Josaf naam ke aadmie raha. Oe Aariematea sahar ke raha aur Israel ke barkwan me ke ekgo raha. Oe ek bhala aur iemaandaar aadmie raha aur Parmeswar ke raadj agorat raha. Aur djab sabha me barkwan Jiesoe ke biese me faisala karies raha, tab oe ek na raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tab oe laat ke paas gail aur Jiesoe ke lahaas maangies. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aur lahaas kroes par se oetaarke kapphan me lapet deis aur ekgo kabar me dharies. Oe kabar patthar me banaawal raha aur eman kabhie na koi ke mattie dewal gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Oe dien sabat ke dien soeroe howat aur des bhar me sab tjiedj tajaar karal gail sabat manaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Djaun aurat logan Jiesoe ke saath Gaalielea se aail raha, oesab bhie gail dekhe kaise lahaas kabar me dharal hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tab oesab Jeroesaalem lautke gail aur mahakauwa aur tel tajaar karies Jiesoe ke dehie me lagaawe khaatien. Tab sabat ke dien par oesab soestaat raha djaise Parmeswar ke kaanoen me liekhal hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tab hapta ke pahiela dien ke saberaha aurat log mahakauwa leike kabar lage gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tab djab oesab hoewa par pahoetjal tab dekhies kie barka patthar kabar ke aage se hataawal hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Aur djab bhiettar gail tab Prabhoe Jiesoe ke lahaas na dekhies. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Oesab na djaanies ka sotje ke. Tab atjakke me dekhies kie doei aadmie tjamkat kapra me oesabke lage khara hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aurat log bahoet deraai gail aur nietje taake lagal. Tab oe doeno bolies kie: „Toelog kaahe ke djienda Waala ke maral logan ke djagaha par khodje hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Oe hia na hai, oe djie oethal hai. Jaad kar kie oe ka bolies raha djab oe Gaalielea diehaat me raha. Oe bolies raha kie: ");
INSERT INTO hnsNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Iensaan ke Beta ke tjaahie kharaab manai ke haath me saup dewal djaai ke. Oesab oke kroes par maar dhaariega, aur tiesara dien Parmeswar oke djie oethaaiga.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aurat log ie baat jaad karies. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tab oesab lautke sahar gail ie sab tjiedj Jiesoe ke gjaara pathaawal waalan aur sab doesar tjela log se bataawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Oe aurat log Magdaala sahar ke Maria raha, Johaana, Johaanas aur Jaakobas ke maai djaun ke naam bhie Maria raha, aur ekaat doesar aurat bhie oelogke sanghe raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bakie pathaawal waalan oesabke baat na bieswaas karies. Oesab sotjies kie aurat log and-band baat batia hai.  ");
INSERT INTO hnsNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bakie Petras oethke haalie se kabar lage gail. Djab hoewa pahoetjal tab niehoerke bhiettar taakies aur dekhies kie khaalie kapphan paral hai. Atjambho hoike oe hoewa se tjal gail aur apane me sotje lagal kie ka bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ohie dien doeigo tjela Emaus gaaw djaat raha. Oe gaaw Jeroesaalem sahar se gjaara kilometer raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Oelog sab bietal tjiedj ke biese me batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bas batiaite me Jiesoe aail aur oesabke sanghe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Oelog oke dekhies, bakie na tjienh paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tab Jiesoe poetjhies: „Toelog kaun tjiedj ke biese me etana batia hai?” Tab oelog oedaasie me thara hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Doeno me se ekgo ke naam Kleopaas raha. Oe poetjhies: „Toe Jeroesaalem me ekahie pardesie baate? Toe na djaane hai hoewa par ka bhail hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tab oe poetjhies: „Ka bhail?” Tab oelog bolies: „Djaun tjiedj Naasaaret ke Jiesoe se bhail hai. Oe Parmeswar ke ekgo sanesia raha. Okar kaam aur baat Parmeswar ke aur sab djaatie ke aakhie me bahoet maahaan raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bakie hamlogke barka agwan aur doesar barkwan oke Roma ke laat ke haath me saup deis. Oesab oke maut ke sadja talak faisala karwaaike kroes par marwaai dhaaries. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Hamlogke aasa raha kie ohie Israel djaatie ke batjaawat. Bakie ie tiesara dien hai djab se ie sab tjiedj bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Aur hamlog me se ekaat aurat hamlogke bahoet sotj me daar deis. Oesab aadj sabere kabar lage gail aur Jiesoe ke lahaas na paais. Tab lautke aail aur bataais kie koetjh parie dekhaail aur bolies kie oe djieje hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bas hamlog me se ekaat djane bhie kabar lage gail aur aisane raha djaise aurat log bolies raha, aur oesab Jiesoe ke bhie na dekhies.” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tab oe bolies: „Toelog kaise etana be-samadjh baate aur kaahe ke sab Parmeswar ke pahiele ke sanesian ke baat na bieswaas kare hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aapan biesaal soekh me bhiettar djaai ke Kriest ke to tjaahat raha ie sab doekh oethaawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aur oe oelogke Mosas aur Parmeswar ke doesar sanesian ke baat samdjhaawe lagal. Ie sab baat to okare biese me liekhal raha. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tab djab oesab Emaus gaaw pahoetjal, tab dekhaat raha djaise Jiesoe maangat raha auro aage djaai. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bakie oe doeno oke na djaain deis aur bolies: „Bhaai djie, andhiaar howe hai, aadj raat ke hamlogke sanghe rahie dja.” Aur oe bhiettar gail oesabke sanghe rahe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tab djab oesab bhodjan kare lagal, tab Jiesoe bret leike Parmeswar ke dhanbaad deis aur bret toerke oesabke deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tab oesabke aakhie khoel gail aur oesab oke tjienh paais. Bas ohie samai se oe oesabke aage na dekhaail! ");
INSERT INTO hnsNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tab oelog apane me batiaai lagal kie: „Djab oe rasta par hamlogse batiaat raha aur hamlogke Parmeswar ke sanesian ke baat samdjhaawat raha, tab hamlogke diel me ketana khoesiaalie raha!” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tab oesab toerant oethke Jeroesaalem laut gail. Djab hoewa pahoetjal tab gjaara pathaawal waalan aur doesar tjela log ke ekattha paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tab oesab toerant bataais kie: „Prabhoe sattje ke djie oethal hai! Oe Siemon ke dekhaail!” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tab oe doeno bhie bataawe lagal kie rasta par ka bhail aur kaise oelog Jiesoe ke bret toerte me tjienh paais. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tab djab oesab abbe batiaite raha, tab atjakke me Jiesoe oesabke bietj me thara bhail. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Oesab bahoet ghabaraai gail aur sotjies kie ekgo bhoet dekhe hai. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tab oe poetjhies kie: „Kaahe ke toelogke dar lage hai aur toelog doebdha kare hai? ");
INSERT INTO hnsNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Dekh hamaar haath aur gor, ham ohie baatie. Hamme tjhoew aur dekh kie hamke maas aur haddie hai. Tab apane dekhiehe kie hamahie baatie. Ek bhoet ke dehie thoro hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aur oe aapan haath aur gor dekhaais. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bakie tjela log atjambho aur khoesie hoike na bieswaas kar paais. Ohie se oe poetjhies: „Toelogke paas koetjh khaaik hai?” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tab oesab oke ek toekkara bhoedjal matjharie deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Oe matjharie leike oesabke aage khaais. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Oe bolies: „Djab ham toelogke sanghe rahat rahielie, tab ham toelogse batailie kie sab tjiedj djaun Mosas aur Parmeswar ke doesar sanesian ke poestak aur gaana me hamaar biese me liekhal hai, oe poera howe ke tjaahie.” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aur oe oesabke akkiel safa kar deis djeme oesab Parmeswar ke baat samadjh sake. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Oe bhie bolies: „Parmeswar ke poestak me liekhal hai kie Kriest ke tjaahat raha doekh oethaawe ke aur tiesara dien djie oethe ke. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bhie liekhal hai kie toelogke tjaahie hamaar naam se doenia bhar ke bataawe ke kie paap ke tjhama paawe khaatien manai log ke pastaaike aapan kharaab tjalaawa tjhore ke parie. Ie partjaar Jeroesaalem se soeroe howe ke tjaahie. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Toelog ie sab tjiedj dekhle, ohie se toelog gawaahie deihe. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aur soen, ham halieje se aapan Baap ke waada poera karab. Ohie khaatien djab talak ie waada na poera hoiga aur toelogke oeppar se saktie na mieliega, tab talak toelog sahar me rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ekare baad Jiesoe aapan tjela log ke sahar me se legail Betaania gaaw lage. Hoewa par oe aapan haath oethaaike oesabke aasier-baat deis. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Etane me oe oesabke bietj me se oeppar lewal gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tab tjela log gaathie par gierke oke poedje lagal. Ekare baad oelog bahoet khoesiaalie me Jeroesaalem laut gail. ");
INSERT INTO hnsNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hoewa par oesab hardam Parmeswar ke mahal ke angana me djaat raha okar goen gaawe khaatien.");
INSERT INTO hnsNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sansaar howe se pahiele Koi raha. Okar naam Baat raha. Oe Parmeswar ke saath rahat raha aur oe Parmeswar raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Soeroe se oe Parmeswar ke sanghe raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Har ek tjiedj Baat dwaara oetpan bhail hai aur okare dwaara sab koetjh banaawal gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Okare me Parmeswar ke djiewan raha. Ie djiewan iensaan logan khaatien djaise andjor raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ie andjor andhiaar me aail, aur andhiaar oke na hataai paawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ek dien Parmeswar ekgo sanesia pathaais. Okar naam Johaanas raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Oe aail manai log se bataawe kie Parmeswar ke Andjor Ke hai, djeme sab koi okar sanesa soenke Andjor me bieswaas kare. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Johaanas Andjor na raha, bakie okar kaam raha manai logan se Andjor ke biese me bataawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ie sattja Andjor doenia me aaike sab iensaan logan ke samadjh me andjor dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Oe doenia me rahat raha. Aur tjaahe doenia okare dwaara banaawal gail raha, tabbo iensaan logan oke na pahietjaanies. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Oe aapan des me aur aapan djaatie ke paas aail, aur tabbo oesab oke na apanaais. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bakie dje bieswaas karke oke apana leis hai, oe ohielogke hak deis hai Parmeswar ke larkan howe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Oesab na paidaais dwaara Parmeswar ke larka howe hai, aur bhie na manai ke sotj-bietjaar se kie to mardaana dwaara, bakie Parmeswar oesabke Baap hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ek dien Baat iensaan hoi gail aur koetjh tem khaatien hamlogke saath rahat raha. Hamlog Parmeswar ke maahaanta okare me dekhlie. Oe Pieta Parmeswar ke ekahie Beta hai, aur okar diel bhalaai aur sattjaai se bharal hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Parmeswar ke sanesia Johaanas okar biese me hausiela se bolies kie: „Ham ehie Aadmie ke biese me batailie rahielie kie: ‘Oe hamare baad aaiga, aur oe hamse pahiele raha. Ohie se oe hamse barka hai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Okar poera bietjaar dwaara hamlogke doharaaike okar biesaal bhalaai mielal hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Parmeswar Mosas dwaara aapan kaanoen deis raha. Okar bhalaai aur sattjaai Jiesoe Kriest dwaara aail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Koi na Parmeswar ke dekhies hai. Bakie okar ekahie Beta ose ek hai, aur oe hamlogke djanaais hai kie oe kaisan hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Ek dien Israel ke dharam ke barkwan Jeroesaalem sahar se ekaat agwan aur Lewie log ke Johaanas dopoe kare waala ke paas pathaais. Oesab maangat raha djaane kie oe ke hai. Tab Johaanas oesabke djanaai deis kie: „Ham Kriest na baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tab oesab poetjhies: „Tab toe ke baate? Toe Elia baate?” Tab oe bolies: „Ham na baatie.” Tab oesab poetjhies: „Toe Parmeswar ke doesar sanesia baate djaun aawat?” Tab oe bolies: „Ham ohoe na baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tab oesab poetjhies: „Tab toe ke baate? Hamlogke tjaahie aapan barkwan se tor baare me koetjh bataawe ke. Toe apane ke biese me ka bole hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tab Johaanas Parmeswar ke sanesia Jasaaja ke baat se djabaab deis kie: „Hamaar aawaadj maidaan me soena hai aur ham bolaaila: ‘Prabhoe aaiga, aapan diel okar khaat tajaar kar.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hoewa par koetjh Fariesie log bhie raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Oesab Johaanas se poetjhies: „Djab toe Kriest, Elia aur oe doesar sanesia na baate, tab ke toke hoekoem deis dopoe kare ke?” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tab oe bolies: „Ham paanie se dopoe kariela. Bakie ie djhoend me ekgo aadmie thara hai aur toelog oke na djaane hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Oe hamare baad aapan kaam soeroe kariega. Aur oe hamse etana barka hai kie ham okar djoeta khole laaik na baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ie sab tjiedj bhail djab Johaanas Jordaan nadie me dopoe karat raha. Oe djagaha nadie ke habara Betaania gaaw ke nagietj hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Biehaan bhaile Johaanas Jiesoe ke aawat dekhies. Tab oe hoewa ke manai log se bolies kie: „Dekh, Parmeswar ke bhera ke Battja aawe hai. Oe doenia bhar ke manai log ke paap hataaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Okare biese me ham batailie rahielie kie: ‘Hamare baad ekgo aadmie aaiga djaun hamse pahiele raha aur oe hamse barka hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ham na djaanat rahielie kie oe Ke hai. Ham ailie paanie se dopoe kare djeme Israel ke djaatie djaane kie oe Ke hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Oe bhie bolies: „Parmeswar hamke pathaais raha dopoe kare ke aur oe hamse bataais: ‘Djab toe Pawietr Aatma ke ek aadmie ke oeppar baithat dekhiehe, tab djaan djaihe kie ohie manai log ke Pawietr Aatma se dopoe kariega.’ ");
INSERT INTO hnsNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ham ie sab dekhlie hai, ohie se ham gawaahie deila kie oe Parmeswar ke Beta hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Biehaan bhaile Johaanas phien ohie djagaha par raha, aur okar tjela me se doeigo okar sanghe raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tab djab oe Jiesoe ke aawat dekhies tab phien se bolies kie: „Dekh, oe Aadmie Parmeswar ke bhera ke Battja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tab oe doei tjela ie baat soenke Jiesoe ke paatjhe tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tab djab Jiesoe ghoemke taakies tab poetjhies: „Ham toelogke khaat kaun tjiedj karie?” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tab oesab poetjhies: „Rabie, aap kaaha rahe hai?” („‘Rabie”’ ke matlab „‘maastar”’ hai). ");
INSERT INTO hnsNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tab oe bolies: „Tjal dekh.” Oelog okare sanghe gail aur dekhies oe kaaha rahe hai. Lagbhag tjaar badje sandjha raha aur oesab oe dien Jiesoe ke sanghe rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Oe doeno me se ekgo ke naam Andreas raha. Oe Siemon Petras ke bhaai raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tab Andreas toerant aapan bhaai ke khodjies aur bolies: „Hamlog Masieh ke paai gailie hai.” (Masieh ke matlab bhie Kriest hai). ");
INSERT INTO hnsNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Aur oe aapan bhaai ke Jiesoe ke paas legail. Tab Jiesoe oke taakke bolies: „Toe Johaanas ke beta Siemon baate. Bakie tor naam Kefas rahiega.” Ie naam doesar bhaasa me „‘Petras”’ hai, aur ekar matlab „‘patthar”’ hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ek rodj baad Jiesoe maangies Gaalielea diehaat djaai. Tab djaai se pahiele oe Fielepas ke bhetaail aur bolies: „Aaw tjal hamare saath.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fielepas djaise Andreas aur Petras Betsaaida sahar me rahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tab Fielepas gail Naataanaajel ke laawe aur ose bolies: „Hamlog oe aadmie ke pailie hai djekar biese me Mosas aur doesar sanesian Parmeswar ke poestak me liekhies raha. Okar naam Jiesoe hai. Okar baap Josaf hai aur oesabhan Naasaaret sahar ke hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tab Naataanaajel bolies: „Ekko attjha tjiedj Naasaaret me thoro hai?” Tab Fielepas bolies: „Aaw tjalie dja dekhe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tab Jiesoe djab Naataanaajel ke aawat dekhies, tab bolies: „Dekh, oe ekgo sattja Israel ke aadmie hai, oe safa sotj-bietjaar waala hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tab Naataanaajel ie baat soenke poetjhies: „Toe hamme kaaha se djaane hai?” Tab Jiesoe bolies: „Fielepas ke bolaawe se pahiele ham djaanat rahielie kie toe aapan adjier ke per ke tare rahiele.” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tab Naataanaajel bolies: „Maastar djie, aap Parmeswar ke Beta baate! Aap Israel ke Raadja baate!” ");
INSERT INTO hnsNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tab oe bolies: „Hamaar baat dwaara toe hamare me bieswaas kare hai. Toe auro barka kaam dekhiehe. Soen, ham satj boliela kie toelog dekhiehe kaise swarag khoelie aur Parmeswar ke parie log nietje aai djaai iensaan ke Beta lage.” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Doei rodj baad Gaalielea diehaat Kaana sahar me ekgo biaah raha. Jiesoe ke maai hoewa raha, aur Jiesoe aur okar tjela log bhie nauta paais raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tab nauta karat me wien don hoi gail. Tab Jiesoe ke maai okare paas gail aur bolies: „Wien don hoi gail.” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tab oe bolies: „Maai, sab hamare maatha tjhor de. Ham aapan tem par karab.” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tab okar maai sab haath lagaawe waalan se bolies: „Soen, tjaahe djaun kaam Jiesoe toelogse bolie kare ke, sab kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Israel ke dharam ke nem raha ghar ke bhiettar djaai se pahiele haath gor dhowe ke. Ohie khaatien hoewa par tjhaugo barka gogliet dharal raha. Har ek gogliet me lagbhag sau liter paanie bharaai sakat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tab Jiesoe haath lagaawe waalan se bolies kie: „Sab gogliet paanie se bhar deihe.” Oelog moeh talak bharies. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tab oe bolies: „Ab toelog koetjh niekaarke aur bhandaara ke dei deihe tjiekhe khaatien.” Aur oesab oisane karies. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Oelog djaanat raha kaisan paanie hai, bakie bhandaara na djaanat raha. Tab djab oe paanie tjiekhies djaun wien hoi gail raha, tab oe doelaha ke bolaaike bolies: „Dekh, sab koi hardam pahiele attjha wien piaawe hai. Aur djab nautaharian khoeb pie tjoeke hai, tab na otana attjha wien dewe hai. Bakie toe to sab se attjha waala ab talak loekwaile rahiele.” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jiesoe ie kaam Gaalielea diehaat Kaana sahar me karies hai. Ie pahiela dafe raha kie Parmeswar ke maahaanta okare me dekhaail. Aur okar tjela log okare me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ekare baad Jiesoe aur okar maai, bhaai aur tjela log Kaapernaum sahar gail. Aur oesab hoewa par ekaat rodj rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Oe tem Israel ke Paasan ke tiewhaar nagtjaail raha. Ohie se Jiesoe Jeroesaalem sahar gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Djab oe hoewa par pahoetjal tab Parmeswar ke mahal lage gail. Tab dekhies kie manai logan angana me gaai, bhera aur kaboettar betje hai aur koetjh log baithke paisa toeraawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tab oe ghaas goethke tjhatkoen banaaike bhera aur gaai log ke mahal ke angana me se khadere lagal. Aur toeraawe waalan ke paisa djamien par phekke aur oesabke tafra oeloet deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aur oe kaboettar betje waalan se bolies kie: „Toelog aapan sab tjiedj hia se ledja! Hamaar Baap ke mahal ke badjaar na banaaw!” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aur okar tjela log sab dekhke jaad kare lagal kie Parmeswar ke poestak me liekhal hai kie: „Ham kamaasoet ghat kaam kariela tor mahal khaatien, aur ekare dwaara ham maar dhaaral djaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tab Israel ke dharam ke barkwan aaike Jiesoe se poetjhies: „Ke toke hoekoem deis hai? Toe kaise hamlogke dekhaihe kie toe ie kaam kar sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tab oe bolies: „Djab toelog ie mahal toer deihe tab tien rodj me ham eke phien se bana debe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tab oelog bolies: „Ka, tjhejaalies (46) baries lagal hai Parmeswar ke mahal banaawat, aur toe oke tien rodj me phien se banaihe?” ");
INSERT INTO hnsNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Oesab sotjies kie oe Parmeswar ke mahal ke biese me batiaat raha, bakie oe ie sab baat aapan dehie ke biese me bolies. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Baad me djab Jiesoe djie oethal raha, tab okar tjela log ie sab baat jaad karies. Aur oesab Parmeswar ke liekhal baat aur Jiesoe ke baat samadjhke bieswaas karies. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Oe tem djab Jiesoe Jeroesaalem me raha Paasan ke tiewhaar manaawe khaatien tab dher manai okar barka kaam dekhke okare me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Bakie oe djaanat raha kie oesabke diel kharaab hai. Koi ke djaroerie na raha oke samdjhaawe ke kie iensaan kaisan hai. Ohie se oe oesabke oeppar bharosa na karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ek aadmie raha, okar naam Niekodemas raha. Oe ekgo Fariesie aur Israel ke barkwan me ke raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ek raat oe gail Jiesoe se batiaai. Oe bolies: „Maastar djie, hamlog tor atjambho kaam dekhlie hai. Ek iensaan etana barka kaam na kar sake hai biena Parmeswar ke saktie se. Ohie se hamlog djaaniela kie Parmeswar toke pathaais hai manai logan ke siekhaawe khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tab Jiesoe bolies: „Soen, ham tose koetjh bataabe. Khaalie djab ek iensaan ek dafe auro paida hoi, tab oe Parmeswar ke raadj ke biese me samadjh sakie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tab Niekodemas bolies: „Djab ek iensaan barka hoi gail hai tab kaise oe phien se paida hoi sakiega? Oe thoro aapan maai ke pet me djaaike aur phien se djanam paai sakiega?” ");
INSERT INTO hnsNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tab oe bolies: „Khaalie djab ek iensaan paanie aur Pawietr Aatma me se paida howe hai, tab oe Parmeswar ke raadj me bhaag lei sakiega. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Iensaan khaalie iensaan ke djalmaai sake hai, bakie Pawietr Aatma ek iensaan ke aatma me naawa djiewan dei sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aur bolies: „Ka, toe thak hoi gaile djab ham bollie kie toelogke tjaahie ek dafe auro paida howe ke? ");
INSERT INTO hnsNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tjaahe toe hauwa ke aawaadj soene hai, tabbo toe na samadjh sake hai kaaha se aawe hai aur kaaha dja hai. Aisane toe bhie na samadjh sake hai ek iensaan kaise Pawietr Aatma dwaara naawa djiewan paawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tab Niekodemas poetjhies: „Ie kaise hoi sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tab oe bolies: „Toe to Israel ke djaatie log khaat ek dharam siekhaawe waala baate. Tab toe kaise ie sab baat na samdjhe hai? ");
INSERT INTO hnsNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ham tose satj bataaila kie ham djaaniela kaun tjiedj ke biese me batiaaila. Ham aapan aakhie se dekhlie hai. Bakie tabbo toelogan hamaar baat na maange hai bieswaas kare. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Djab ham doenia ke tjiedj kaam me leike toelogke koetjh samdjhaaila, tab toelog na bieswaas kare hai. Tab djab ham toelogse swarag ke tjiedj ke biese me bataabe, tab toelog kaise bieswaas kar sakiehe? ");
INSERT INTO hnsNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Koi na swarag me gail hai, khaalie iensaan ke Beta. Aur oe bhie hoewa se oetaral hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Maidaan me Mosas pietar ke saap banwaaike khambha par latkaais raha. Aisane iensaan ke Beta ke bhie oethaawal djaai ke parie. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ie rakam har ek djaun okare me bieswaas kare hai, oe hardam ke lieje Parmeswar ke sanghe rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Parmeswar doenia ke etana pjaar karies kie oe aapan ekahie Beta deis, djeme har ek djaun okare me bieswaas kare hai, oe Parmeswar se na alag karal djaai, bakie hardam khaatien okare sanghe rahe. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pieta Parmeswar aapan Beta doenia me na pathaais hai manai logan ke kasoer dewe ke, bakie oelogke paap me se batjaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Dje bieswaas kare hai kie Parmeswar ke Beta okar kasoer aapan oeppar leis hai, Parmeswar oke be-kasoerie maane hai. Bakie dje okare me na bieswaas kare hai, oe sadja laaik hai. Oe to Parmeswar ke ekahie Beta ke oeppar bharosa na karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Parmeswar ke andjor doenia me aail hai. Bakie iensaan logan ke auro attjha lagat raha andhiaar me rahe ke. Oelogan to paap-boeraai karat raha. Aisane dekha hai kie oesab sadja laaik hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Djab koi kharaabie kare hai tab oe andjor ke na tjaahe hai aur na khodje hai. Oe dera hai kie okar paap-boeraai andjor me dekhaai djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bakie dje aapan djiewan Parmeswar ke sattjaai se bietaawe hai, oe andjor khodje hai. Tab okar tjaal-tjalan se dekhaai djaai kie oe Parmeswar me bieswaas kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ekare baad Jiesoe aapan tjela log ke sanghe Joedea diehaat gail. Hoewa par oelog koetjh dien rahie gail aur manai log ke dopoe karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Oe tem par Johaanas dopoe kare waala bhie dopoe karat raha. Oe abbe djahal me na raha. Oe aapan kaam Saalem sahar ke nagietj Enon me karat raha. Hoewa dher paanie raha. Aur manai log okare paas bhie aawat raha dopoe karwaawe. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tab Johaanas ke tjela log ek doesar aadmie se diel ke safaai ke biese me moeh laraawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tab oesab Johaanas ke paas gail aur bolies: „Maastar djie, Jordaan nadie ke habara ek aadmie tore sanghe raha aur toe gawaahie deile rahiele kie oe Ke hai. Ab ohoe dopoe kare hai, aur sab koi okare paas dja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tab Johaanas bolies: „Ek manai khaalie oe kaam kar sake hai djaun Parmeswar oke deis hai kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Toelog jaad kare hai ham ka bollie rahielie. Ham aane waala Kriest na baatie. Bakie Parmeswar hamke ose pahiele pathaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Doelahien doelaha khaatien hai. Aur doelaha ke sanghatia ke okar aawaadj soenat bahoet attjha lage hai. Ohie se ham khoesie baatie djab sab koi okare paas dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Manai log ke tjaahie oke hardam auro barka maane ke aur hamke aur nietja. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Dje oeppar se aail hai, oe sab iensaan se barka hai. Dje dhartie me ke hai, oe khaalie doenia ke kaar-baar ke biese me batia hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Bakie dje swarag me se aail hai, oe bataawe hai djaun tjiedj oe hoewa dekhies aur soenies hai. Tabbo koi na okar baat bieswaas kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aur dje okar baat aapan diel me dhar lewe hai, oe gawaahie dewe hai kie Parmeswar satj hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Parmeswar oke pathaais hai aur okar diel Pawietr Aatma se djaada bharal hai. Oe Parmeswar ke baat bataawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pieta Parmeswar aapan Beta ke bahoet tjaahe hai, aur sab tjiedj okar haath me saupies hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ohie khaatien dje Parmeswar ke Beta me bieswaas kare hai, oe sada ke lieje Parmeswar ke saathe rahiega. Bakie dje okar Beta ke baat na soene hai, oe Parmeswar ke saath na rahiega. Parmeswar ke goessa hardam okare oeppar rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Fariesie logan soenies raha kie Jiesoe Johaanas se djaada manai logan ke tjela banaaike dopoe karat raha. Jiesoe na dopoe karat raha, bakie okar tjela logan. Djab oe djaan gail kie Fariesie log soen leis hai tab oe Joedea se Gaalielea diehaat me lautke djaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Aisane oke Saamaaria diehaat se djaai ke paral. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tab oe Saamaaria diehaat me Siekar sahar lage pahoetjal. Hoewa ekgo khet raha. Sauwan baries pahiele Jaakob aapan beta Josaf ke oe khet deis raha. Oe oman ekgo petie khodwaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Jiesoe thakal raha aur petie lage baith gail. Okar tjela log sahar gail raha khaaik kiene khaatien. Lagbhag baara badjal raha. Tab hoewa ke ekgo aurat aail paanie bhare. Tab Jiesoe bolies: „Toe hamme tanie se paanie dei sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Israel logan Saamaaria logan se na batia hai. Ohie se aurat bolies: „Toe to Israel ke baate, aur ham Saamaaria ke. Toe kaise hamse paanie maang sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tab oe bolies: „Djab toe djante Parmeswar ka maange hai dewe, aur ke tose bole hai: ‘Hamme thora se paanie de,’ tab toe bolte: ‘Toe hamme paanie de.’ Aur ham toke paanie piaitie. Oe paanie se toke naawa djiewan miel sakie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tab aurat bolies: „Ka, toke baltie na hai aur petie gahier hai. Toe hamme naawa djiewan ke paanie kaise dei sakiehe? ");
INSERT INTO hnsNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Toe hamlogke baap-daada Jaakob se thoro barka baate? Oe ie petie khodwaais raha. Oe aur okar betwan aur djanaawar log ie paanie pies raha.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tab oe bolies: „Dje ie paanie piega, oke phien se piaas lagiega. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bakie dje oe paanie piega djaun ham piaabe, oke kabhie piaas na lagiega. Aur oe paanie okare me djaise ek paanie ke dhaara rahiega djaun bahat rahiega oke amar djiewan dewe khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tab aurat bolies: „Bhaai djie, toe hamme ie paanie dei sakiehe? Tab hamme piaas na lagiega aur hamke bhie na hia aawe ke parie paanie bhare khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tab oe bolies: „Attjha, dja ghare aur aapan aadmie ke bola laaw.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tab aurat bolies: „Hamke aadmie na hai.” Tab oe bolies: „Ie satj baat hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Toke paatj aadmie raha, aur ie aadmie djaun ke sanghe ab toe baate, oe tor aadmie na hai. Eman toe sattja bolle.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tab aurat bolies: „Prabhoe djie, ham dekhlie kie toe Parmeswar ke ek sanesia baate. Aapse ham koetjh poetjh sakiela?” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bolies: „Hamlogke baap-daada logan hardam ie pahaar par Parmeswar ke poedjat raha. Bakie Israel logan bole hai kie sab koi ke tjaahie Jeroesaalem djaaike Parmeswar ke mahal me oke poedje ke. Tab kaun tjiedj kare ke tjaahie?” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tab oe bolies: „Betie, hamme bieswaas kar kie ek tem aaiga djaun me toelog tjaahe djaaha Pieta Parmeswar ke poedjiehe, ie koetjh baat na rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Toelog Parmeswar ke poedje hai tjaahe toelog oke na djaane hai. Bakie hamlog djaaniela kie hamlog ke ke poedjiela. Iensaan ke batjaawe Waala to hamlogke djaat me ke hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ek tem aaiga aur bhie aai gail hai kie manai logan Pawietr Aatma ke sahaara se aur sattjaai se Pieta Parmeswar ke poedjiega. Oe aisan manai log ke khodje hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Parmeswar Aatma hai, aur dje oke poedjiega, oke tjaahie Pawietr Aatma ke dwaara aur safa diel se kare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tab aurat bolies: „Ham djaaniela kie Masieh aaiga. Oe bhie Kriest bolaawal djaaiga. Aur djab oe aaiga tab oe hamlogke ie sab baat samdjhaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Bas oe bolies: „Ham ohie baatie aur toe ose batia hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Oe tem par tjela log aawat raha aur dekhke thak hoi gail kie Jiesoe ekgo aurat se batia hai. Bakie koi na poetjhies: „Ka bhail?” kie to: „Toe aurat se kaahe ke batia hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Aurat aapan gogliet tjhorke sahar tjal gail. Aur hoewa ke manai log se bolies: „Aaw dekh! Petie lage ek aadmie hai. Oe hamaar sab ghar ke haal hamse bataais hai. Hamare djaan me ohie Kriest hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tab manai logan niekarke Jiesoe ke paas djaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Etane me tjela log Jiesoe se poetjhies: „Maastar djie, toe koetjh khaihe?” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bakie oe bolies: „Hamke koetjh miel tjoekal hai, aur toelog na djaane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tab tjela log apane apane me batiaai lagal kie: „Saait oke koi khaaik laaike deis hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Bakie oe bolies: „Parmeswar hamme pathaais hai aur djab ham okar hiettjha poera kariela, tab oe kaam hamme bahoet barhia lage hai djaise attjha khaaik.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aur oe bolies: „Toelog bole hai katnie ke tem tjaar mahienna baad aai djaaiga. Bakie ham toelogse boliela kie djab toelog thiek se takiehe, tab dekhiehe kie manai logan phal ghat tajaar hai Parmeswar khaatien batoral djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Dje manai log ke ekattha laaike Parmeswar khaatien batore hai hardam okar sanghe rahe ke, oe madjoerie paaiga. Aur dje tjhiete waala ghat oesabke diel tajaar kare hai, oe batore waala sanghe khoesiaalie manaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Baat ke masla hai kie: ‘Koi tjhiete hai aur doesar kaate hai.’ Ie satj hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ham toelogke pathailie hai phal batore ke djaun toelog na boile hai. Doesar log partjaar karke manai log ke diel tajaar karies hai aur toelog oesabke kaam ke phal batore hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aur sahar me dher Saamaaria ke manai log soenies kie aurat bataawe hai Jiesoe okar biese me ka bolies raha. Tab oelog okare me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ohie se oesab okar paas gail aur poetjhies: „Aap na maange hai hamlogke saath rahe?” Tab oe hoewa doei rodj rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tab auro manai log okar partjaar soenke okare me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aur oesab aurat se bolies: „Ab hamlog na bieswaas kariela tor baat se, bakie hamlog okar partjaar soenke djaan gailie kie oe sattje ke doenia ke batjaawe Waala hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Doei rodj baad Jiesoe hoewa se Gaalielea diehaat me tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Oe pahiele bolies raha kie Parmeswar ke ek sanesia ke aadar aapan diehaat me na karal djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bakie Gaalielea ke manai log djab tiewhaar manaawe khaatien Jeroesaalem me raha, tab dekhies raha oe kaun atjambho kaam kare hai. Ohie se djab oe Gaalielea me pahoetjal tab oesab ose attjha se bhet karies. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tab oe phien Gaalielea diehaat Kaana sahar me gail djaaha oe paanie se wien banaais raha. Ekgo raadja ke kamkarta hoewa bhie aail raha. Oe Kaapernaum sahar me rahat raha, aur okar beta bahoet bemaar raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Djab oe soenies kie Jiesoe Joedea se Gaalielea diehaat me pahoetjal hai, tab oe okare lage gail aur poetjhies: „Toe na maange hai hamaar sanghe tjalke djaai hamaar beta ke attjha kare? Oe mare par lagal hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tab Jiesoe bolies: „Djab talak toelog tjienha aur barka kaam na dekhiehe, tab talak toelog bieswaas na mangiehe kare.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tab aadmie bolies: „Prabhoe djie, haalie se tjal, nahie to hamaar larka mar djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Bas oe bolies: „Dja ghare, tor beta attjha hoi gail hai.” Aur oe okar baat bieswaas karke ghare djaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Djab oe biehaan bhare djaat raha tab okar goelaam log oke aadha rasta par bhetaail aur bolies: „Tor beta attjha hoi gail hai!” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tab oe poetjhies: „Oe kai badje attjha bhail?” Tab oesabhan bolies: „Kaal ek badje okar bokhaar oetar gail.” ");
INSERT INTO hnsNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tab oe jaad karies kie ohie tem par Jiesoe ose bolies raha kie: „Tor beta attjha hoi gail hai.” Aadmie aur okar ghar bhar okare me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ie doesara dafe raha kie Jiesoe Gaalielea diehaat me barka kaam karies djab oe Joedea se lautke aail raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Koetjh dien baad Israel ke dharam ke ek tiewhaar raha. Ohie khaatien Jiesoe phien se Jeroesaalem sahar gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Oe sahar ke dewaal me ekgo phaatak Bhera ke phaatak bolaawal dja hai. Hoewa ek paanie ke djagaha hai. Okar aas-paas paatjgo tjhaawal rasta hai. Israel ke bhaasa me oe djagaha „‘Betesda”’ bolaawal dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Hoewa par dher andha, loendj aur langar logan raha. Oesab agorat raha kab paanie hielie. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kabhie kabhie Prabhoe ke ek parie paanie me oetarke aur hielaai dewat raha. Tab dje pahiele paanie me djaat raha, tjaahe djaun bemaarie oke raha, oe ekdam se attjha hoi djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hoewa par ek aadmie arties (38) baries se bemaar letal raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jiesoe djaanat raha kie oe dher dien se hoewa paral raha. Tab oke dekhke ose poetjhies: „Toe na maange hai attjha howe?” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tab aadmie bolies: „Bhaai, djab paanie hiele hai tab koi na hamke oman dhare hai. Aur djab ham kausies kariela paanie me djaai ke, tab koi haalie se hamse pahiele dja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Bas oe bolies: „Oeth, aapan bietjhauna oethaaike tjal.” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aadmie ohie laage attjha bhail aur aapan bietjhauna leike tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Oe rodj ek sabat ke dien raha. Ohie se ekaat Israel ke dharam ke barkwan aadmie se bolies: „Aadj to sabat ke dien hai, ohie se mienaahie hai bietjhauna kahoe ledjaai ke.” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bakie aadmie bolies: „Djaun aadmie hamme attjha karies hai, oe hamse bolies: ‘Aapan bietjhauna oethaaike tjal.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tab barkwan poetjhies: „Ke tose ie baat bolies hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bakie oe Jiesoe ke naam na djaanat raha. Hoewa bahoet bhier raha aur Jiesoe djhoend me tjal gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Thora der baad Jiesoe Parmeswar ke mahal ke angana me ose bhet karies aur bolies: „Soen, toe attjha hoi gaile hai. Ab se paap boeraai na kariehe nahie to tose auro kharaab tjiedj hoi djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tab aadmie dharam ke barkwan ke paas gail aur bolies: „Hamke Jiesoe attjha karies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Oesab Jiesoe ke oeppar goessaail kie oe aisan kaam ekgo sabat ke dien par karies hai. Ohie khaatien oelog maangat raha oke sataawe. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bakie Jiesoe oesabse bolies: „Hamaar Baap abbe talak kaam kare hai aur ham bhie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tab ie baat soenke oesab auro goessaai gail. Jiesoe to na khaalie sabat ke kaanoen toeries raha bakie oe bhie Parmeswar ke aapan Baap bolaaike apane ke Parmeswar se baraabar karies. Ohie se oesab auro kausies kare lagal oke marwaai dhaare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jiesoe oesabke auro aage samdjhaais: „Ham toelogse sattje ke bataaila kie Parmeswar ke Beta apane se koetjh na kar sake hai. Oe khaalie dekhke kare hai djaise okar Baap kare hai. Djaun kaam Baap kare hai Beta bhie kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Baap to Beta ke tjaahe hai. Oe aapan sab kaam oke dekhaawe hai. Ek aadmie attjha hoi gail hai, aur Baap auro barka kaam dekhaaiga djeme toelog atjambho hoi djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Djaise Baap maral aadmie ke oethaaike naawa djiewan dewe hai, oisane okar Beta ke bhie hoekoem hai naawa djiewan dewe ke dje ke oe maange hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baap koi ke oeppar faisala na kariega. Oe ie kaam aapan Beta ke oeppar saup deis hai, ");
INSERT INTO hnsNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","djeme sab koi Beta ke aadar kare lage djaise oesab Pieta Parmeswar ke aadar kare hai. Aur dje Beta ke aadar na kare hai, oe Baap ke aadar bhie na kare hai. Oe oke to pathaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ham toelogse satj boliela kie dje hamaar baat maanke aur hamaar pathaawal Waala me bieswaas kare hai, oe hardam khaatien sattja djiewan paais hai. Oe Parmeswar se na alag karal djaaiga. Oe maut ke rasta par se djiewan ke rasta par aai gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ham satj boliela kie ek tem aaiga kie maral logan Parmeswar ke Beta ke aawaadj soeniega. Oe tem ab aai gail hai. Aur dje soeniega, oe sattja djiewan paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Baap me se sab djiewan oetpan howe hai. Aur oe Beta ke ohie saktie deis hai djeme okare me se bhie naawa djiewan oetpan howe. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Oe bhie iensaan ke Beta hai. Ohie se Baap oke saktie deis hai iensaan logan ke oeppar faisala kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ie sab baat se atjambho na hoihe! Ek tem aaiga kie sab maral logan okar aawaadj soeniega. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aur dje aapan djiewan bietaais raha djaise Parmeswar maange hai, oe djie oethiega hardam okare saath rahe khaatien. Bakie dje aapan djiewan kharaab bietjaar se bietaais hai, oesabhan oethiega Parmeswar se alag karal djaai khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jiesoe bhie bolies: „Ham apane se koetjh na kar sakiela. Djaise hamaar Baap hamse bole hai, oisane ham faisala kariela. Aur ham sattjaai se faisala kariela. Ham na maangiela aapan man waala kare bakie hamaar pathaawe waala ke. Oe hamke pathaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Djab ham apane biese me gawaahie deila tab toe na djaan sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bakie ek doesar Koi hamaar biese me gawaahie dewe hai, aur ham djaaniela kie oe satj bole hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Toelog ekaat manai log ke Johaanas dopoe kare waala ke paas pathaile rahiele soene khaatien kie oe ka bole hai. Tab oe bhie bataais kie ham Ke baatie, aur okar baat satj hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Hamke manai ke gawaahie djaroerie na hai, bakie ham toelogke jaad karwaaila djeme toelog okar baat bieswaas karke okar sadja me se batj djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johaanas ek tjieraag ghat andjor dewat raha, aur thora dien khaatien toelogke attjha lagat raha okar andjor me tjale ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bakie hamaar gawaahie Johaanas ke baat se barka hai. Hamaar Baap hamke saktie deis hai atjambho kaam kare ke. Aur ie kaam se dekha hai kie oe hamke pathaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tjaahe toelog kabhie na oke dekhle kie to okar aawaadj soenle hai, tabbo oe hamare biese me gawaahie dewe hai kie ham Ke baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Aisane dekha hai kie toelog okar baat aapan diel me na maange hai lewe. Djaun ke Parmeswar pathaais hai, toelog okare me na bieswaas kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Toelog Parmeswar ke poestak me khodje hai djaane khaatien kaise ose ek hoike hardam khaatien okare sanghe rahe ke. Aur ehie poestak me hamare biese me liekhal hai kie ham Ke baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tjaahe hamare biese me djetana gawaahie hai, tabbo toelog na maange hai hamaar paas aawe sattja djiewan paawe khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Oe bolies: „Hamaar khaatien iensaan ke aadar koetjh na hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ham toelogke djaaniela. Parmeswar ke prem toelogke diel me na hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ham aapan Baap ke naam se ailie hai, aur toelog tabbo hamme na apanaile. Bakie djab koi aapan man se toelogke paas aaiga tab toelog oke apana leihe. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Toelog iensaan ke aadar maange hai paawe, bakie sattja Parmeswar ke aadar toelog khaatien koetjh na hai. Ohie khaat toelog hamare me bieswaas na kar sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Na sotj kie ham aapan Baap se toelogke biese me orhan debe. Djaane hai ke kariega? Mosas kariega, tjaahe toelog okar baat par aasa kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosas hamaar biese me dher baat liekhies raha. Ohie khaatien djab toelogan sattje ke okar baat bieswaas karte, tab toelog hamare me bhie bieswaas karte. ");
INSERT INTO hnsNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bakie djab toelog okar liekhal baat na bieswaas kare hai, tab kaise hamaar baat bieswaas kariehe?” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ekare baad Jiesoe Tieberias samoendar ke oepaar gail. Oe samoendar Gaalielea diehaat me hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Dher manai log dekhies raha oe kaise bemarian ke attjha karat raha, ohie khaatien oesab okare paatjhe tjalat djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tab oe aapan tjela log ke saath thora doer pahaar par gail baithe. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Israel logan ke Paasan ke tiewhaar ke tem nagtjaai raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Djab Jiesoe etana dher manai ke aawat dekhies tab oe Fielepas se poetjhies: „Hamlog ie sab manai khaatien kaaha se bret kien sakab?” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Oe Fielepas se poetjhies dekhe khaatien kie oke bieswaas hai kie na. Oe djaanat raha kie ka karie. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tab Fielepas bolies: „Doei sau tjaanie ke paisa etana dher manai log khaatien na atiega.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ek doesar tjela ie baat soen leis. Oe Siemon Petras ke bhaai Andreas raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Tab oe Jiesoe se bolies: „Ekgo larka hia hai aur oke paatj bret aur doei matjharie hai. Bakie ie sab manai khaatien na atiega.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tab oe bolies: „Manai logan se bol de baithe ke.” Oe djagaha par dher ghaas raha aur sab koi baith gail. Hoewa par aurat larkan tjhorke paatj hadjaar aadmie raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bas oe bret leike Parmeswar ke dhanbaad deis aur toekkara toekkara toerke tjela log ke deis baate khaatien. Tab matjharie leike oisane karies. Aur sab koi leis djetana maangat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tab djab sab koi pet bhar khaai tjoekal raha, tab Jiesoe aapan tjela log se bolies: „Sab batjal bret ekattha karke laaw. Koetjh na bahaawe ke tjaahie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tjela log aisane karies aur baara baskieta batories. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aur manai logan djab dekhies Jiesoe ketana barka kaam karies hai, tab bolies: „Sattje ke, ehie Parmeswar ke sanesia hai djaun doenia me aawat.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tab Jiesoe djab dekhies kie oesab oke djabar-djastie se ledjaaike maange hai raadja banaawe, tab oe hoewa se akele pahaar par tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Raat howe lagal aur tjela log samoendar ke kienaare djaaike ek bot leike ");
INSERT INTO hnsNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kaapernaum sahar djaai lagal. Andhiaar hoi gail raha bakie Jiesoe abbe na aail raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tab hauwa djor se aail aur samoendar me barka halfa tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tab djab oelog aadha rasta par pahoetjal tab dekhies kie koi paanie par tjalke bot lage aawe hai. Bas oesab deraai gail! ");
INSERT INTO hnsNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bakie Jiesoe bolies: „Na dera! Ham baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tab oelog bolies: „Aaw bot me,” aur oesab toerant kienaare pahoetj gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Sabere manai log samoendar ke oepaar raha, djaaha Prabhoe Jiesoe Parmeswar ke dhanbaad deike oesabke bret khawaais raha. Oesab dekhies raha kie khaalie ekgo bot raha, aur bhie kie Jiesoe aapan tjela log ke sanghe bot me na gail raha. Ohie tem par Tieberias sahar ke or se ekaatgo bot aaike pahoetjal. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tab djab oesab Jiesoe aur okar tjela log ke hoewa na paais, tab oesab bhie bot leike Kaapernaum sahar gail oke khodje khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aur djab oesab oke hoewa paais tab poetjhies: „Maastar djie, toe kab hia aile?” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tab oe bolies: „Toelog hamme na khodje hai hamaar barka kaam khaatien, bakie aapan pet bhare khaat. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aapan dhiaan na khaalie khaaik ke oeppar rakh. Oe halieje se basiaai dja hai. Bakie kausies kar oe khaaik paawe ke djaun kabhie na basiaai. Ekare dwaara toelog hardam khaatien Parmeswar ke sanghe djie sakiehe. Pieta Parmeswar aapan aasies iensaan ke Beta ke deis hai. Ohie toelogke aisan khaaik deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tab oesab poetjhies: „Parmeswar maange hai kie hamlog kaun kaam karie?” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tab oe bolies: „Parmeswar maange hai kie toelog bieswaas kar okare me djaun ke oe pathaais hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tab oelog bolies: „Toe hamlogke ka dekhaai sakiehe djeme hamlog dekhke tore me bieswaas karie? Toe kaun barka kaam kariehe?” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Oesab bolies: „Mosas maidaan me hamlogke baap-daada log ke maana khawaais raha. Parmeswar ke poestak me liekhal hai: ‘Oe oesabke swarag me se bret dewat raha khaai ke.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tab oe bolies: „Mosas oelogke na dewat raha, bakie hamaar Baap swarag me se sattja bret dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Parmeswar ke bret swarag me se oetaral hai aur doenia par sattja djiewan dewe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tab oelog bolies: „Maastar djie, ohie bretwa hamlogke dei deihe, aadj aur hardam khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tab oe bolies: „Hamahie djiewan ke bret baatie. Dje hamare paas aai, okar diel ke bhoekh miet djaai. Aur dje hamare me bieswaas karie, okar diel ke piaas hardam khaatien boedjh djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bakie ham toelogse bollie hai kie tjaahe toelog hamme dekhle hai, tabbo hamare me na bieswaas kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bakie djaun bieswaasie log ke hamaar Baap hamme deiga, oesab hamare oeppar bharosa kariega. Aur djab koi hamke apana leiga, tab ham oke kabhie na nahakaarab. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ham swarag me se na ailie aapan man waala kare ke bakie aapan pathaawe Waala ke. Oe hamme pathaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aur oe na maange hai kie hamaar bieswaasie me se koi ose alag karal djaai. Bakie oe maange hai kie djoeg ke antiem dien par ham oesabke maral manai me se djie oetha dei. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Hamaar Baap maange hai kie dje dekhe hai kie okar Beta Ke hai aur okare me bieswaas kare hai, oe sada ke lieje okare sanghe rahe. Aur antiem dien par ham oke maral manai me se djie oethaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Etane me djaatie ke barkwan okare oeppar goessaai gail. Oe to bolies raha kie: „Ham oe bret baatie djaun swarag me se aail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ohie khaatien oesab bhoen-bhoenaai lagal aur bolies: „Ehie na Josaf ke beta Jiesoe hai? Hamlog okar maai-baap ke djaaniela. Tab oe kaise bol sake hai kie oe swarag me se aail hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Bakie oe bolies: „Na bhoen-bhoena. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Pieta Parmeswar hamme pathaais hai aur koi na begar okar sahaara se hamare me bieswaas kar sake hai. Aur djoeg ke antiem dien par ham har ek bieswaasie ke djie oethaabe. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Parmeswar aapan sanesian se ie baat liekhwaais raha: ‘Oe apane oesabke siekhaaiga.’ Aur har ek djaun okar baat soene hai aur samdjhe hai, oe hamaar paas aaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Koi na Pieta Parmeswar ke dekhies hai. Khaalie oe djaun okare lage se aail hai, oe oke dekhies hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Dhiaan se soen. Dje hamare me bieswaas kare hai, oe hardam ke lieje Pieta Parmeswar ke sanghe rahiega. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ham djiewan ke bret baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Toelogke baap-daada logan maidaan me maana khaat raha, aur oesab mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bakie djiewan ke bret swarag me se aail hai. Dje khaaiga, oe na mariega. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ham djienda bret baatie djaun swarag me se aail hai. Djab koi khaaiga tab oe hardam khaatien hamare sanghe djiega. Aur djaun bret ham debe, oe hamaar dehie hai. Ham aapan dehie baliedaan karab djeme doenia bhar ke manai log Parmeswar sanghe djie sake.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bas Israel ke barkwan apane me djhagara kare lagal aur bolies: „Ie aadmie kaise hamlogke aapan dehie dei sake hai khaai ke?” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tab oe bolies: „Thiek se soen. Djab toelog iensaan ke Beta ke dehie aur khoen na khaihe aur piehe tab toelog Parmeswar ke aage djaise ek maral manai rahiehe. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bakie dje hamaar dehie aur khoen ke apanaaiga, oe hardam khaatien djiejat rahiega aur antiem dien par ham oke djie oethaabe. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Hamaar dehie toelogke diel ke bhoekh sattje ke mietaaiga, aur hamaar khoen diel ke piaas sattje ke boedjhaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dje hamaar dehie aur khoen apanaaiga, oe hamse aur ham ose ek rahab. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Djienda Baap hamme pathaais hai, aur ham okar dwaara djiela. Oisane dje hamme apanaaiga, oe hamare dwaara djiega. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hamlogke baap-daada log maana khaat raha aur mar gail. Bakie dje oe bret khaaiga djaun swarag me se aail hai, oe hardam khaatien Parmeswar ke sanghe rahiega.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jiesoe ie sab baat Kaapernaum ke partjaar ke ghar me siekhaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dher tjela log ie sab baat soenke bolies: „Ie kara baat hai. Ke sahie paai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jiesoe djaanat raha kie oesab bhoen-bhoenaat raha. Ohie khaatien oe poetjhies: „Ka, ie baat toelogke kharaab soena hai? ");
INSERT INTO hnsNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tab djab toelog iensaan ke Beta oeppar swarag me djaat dekhte djaaha oe pahiele raha, tab toelog ka bolte? ");
INSERT INTO hnsNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Khaalie djanam paawe me faida na hai. Bakie Pawietr Aatma sattja djiewan dewe hai. Djaun baat ham toelogse batailie hai, oe toelogke aatma djiejaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bakie tabbo toelog me se koetjh manai log na maange hai hamare me bieswaas kare.” Jiesoe to soeroe se djaanat raha ke okare me na bieswaas karie aur ke oke tjoegalie karie. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Oe bolies: „Ohie khaatien ham toelogse bol deilie rahielie kie: ‘Koi na begar Pieta Parmeswar ke sahaara se hamare me bieswaas kar sakie.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Oe dien se dher tjela log oke tjhorke tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Bas oe aapan baara tjoenal tjela se poetjhies: „Toelogan bhie djaihe?” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tab Petras bolies: „Maastar djie, hamlog kekar oeppar bharosa kartie? Khaalie tor baat dwaara hamlogke sattja djiewan miel sakiega sada ke lieje. ");
INSERT INTO hnsNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Hamlog bieswaas kariela aur djaaniela kie aap Parmeswar ke Pawietr Waala baate.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tab oe bolies: „Ha, ham baara djane ke tjoenlie rahielie, tabbo toelog me se ekgo saitaan me bhartie bhail.” ");
INSERT INTO hnsNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Oe Siemon Eskaariot ke beta Joedaas ke biese me batiaat raha. Oe baaraago me se ekgo raha aur ohie Jiesoe ke biese me tjoegalie karie. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ekare baad Jiesoe Gaalielea diehaat me ie djagaha se ekwa djagaha djaat raha. Joedea diehaat me Israel ke dharam ke barkwan maangat raha oke maar dhaare. Ohie khaatien oe hoewa na gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tab djab Israel logan ke Patta-ke-marai ke tiewhaar nagtjaail, ");
INSERT INTO hnsNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tab okar bhaai log ose bolies: „Barhia rahat kie toe Joedea djaite. Tab tor hoewa ke tjela log bhie tor kaam dekh sakie. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Djab koi maange hai manai logan ke aakhie me barka banke rahe tab oke na tjaahie tjhiepaaike kaam kare ke. Toe to etana barka kaam kare hai? Doenia ke dekhaaw!” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Okar bhaai log na bieswaas karat raha kie ohie Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tab oe bolies: „Hamaar tem abbe na aail hai hoewa djaai khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Manai log toelogke oeppar na goessa hai, ohie se toelog djaai sake hai djab toelogke attjha lage hai. Bakie ham oelogse bataaila oesab kaun kharaabie kare hai. Ohie khaatien oesab hamare oeppar goessa hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Toelog dja tiewhaar manaaw, hamaar tem abbe na aail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aur djaise oe bolies raha oisane oe Gaalielea me rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bakie djab okar bhaai log gail raha tiewhaar manaawe tab oe dhiere se hoewa bhie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jeroesaalem sahar me Israel ke dharam ke barkwan oke khodjat raha. Oesab apane apane me poetjhat raha kie: „Oe kaaha hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Djaatie logan tjoeppe se okare biese me batiaat raha. Koi koi bolies: „Oe attjha aadmie hai.” Bakie ekwan bolies: „Na, oe manai log ke bahakaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Oesab barkwan ke deraat raha. Ohie se koi na okare biese me kholke batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tab djab oesab abbe doei tien rodj nauta manaite raha tab Jiesoe Parmeswar ke mahal ke angana me aaike manai logan ke siekhaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tab dharam ke barkwan okar partjaar soenke atjambho hoi gail. Oesab apane apane me poetjhe lagal: „Ie aadmie parhal na hai. Oe aisan gjaan kaaha se paais?” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Bas Jiesoe oelogse bolies: „Ham aapan baat na siekhaaila, bakie aapan pathaawe Waala ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Djab koi maange hai Parmeswar ke baat maane tab oe djaan djaai kie ham aapan baat siekhaaila kie to Parmeswar ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dje aapan man ke partjaar kare hai oe maange hai kie okar aadar howe. Bakie dje maange hai kie okar pathaawe waala ke aadar miele, oe bharosaadaar hai, oe djhoeth na bole hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosas Parmeswar ke kaanoen deis raha. Bakie toelog me se koi na okar baat maane hai. Tab toelog kaahe ke maange hai hamke maar dhaare?” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tab manai logan bolies: „Toke bhoet pakaries hai. Ke maange hai toke maar dhaare?” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tab oe bolies: „Ham ekgo atjambho kaam karlie ek sabat ke dien par, tab toelog tjakkariaai gaile. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Bakie djab toelog Mosas ke baat maanke ekgo aath rodj ke larka ke hakiekat kare hai, tab toelog ie kaam bhie ek sabat ke dien par kare hai. Ie nem Mosas na soeroe karies hai, bakie hamlogke baap-daada logan. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Toelog sabat ke dien par koi ke hakiekat karke Mosas ke sabat ke kaanoen toere hai okar hakiekat ke kaanoen maane khaatien. Tab djab ham sabat ke dien par ek bemaar aadmie ke attjha kariela tab toelog kaahe ke goessa hai? ");
INSERT INTO hnsNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Toelog kaahe khaatien hamaar kaam kharaab maane hai? Roek dja aapan kharaab sotj-bietjaar se. Bestar toelog koi ke oeppar safa se aur sattjaai se faisala kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ie sab baat soenke koetjh Jeroesaalem ke manai log apane apane me bolies: „Oesab to ehie ke maange hai maar dhaare. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aur dekh, oe kholke partjaar kare hai aur koi na oke koetjh bole hai. Saait hamlogke barkwan djaan gail hoi kie ohie aane waala Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Djab Kriest aaiga tab koi na djaaniega kie oe kaaha se aail. Bakie hamlog djaaniela kie oe aadmie kaaha se aail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tab Jiesoe Parmeswar ke mahal ke angana me partjaar karte me djor se bolies: „Toelog hamme tjienhe hai aur djaane hai ham kaaha se ailie baatie. Tabbo ham apane se na ailie hai. Ekgo sattja Waala hamke pathaais hai, bakie toelog oke na djaane hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ham okare lage se ailie hai aur oe hamme pathaais hai. Ohie khaatien ham oke djaaniela.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ehie baat par oesab oke maangies pakare, bakie okar tem abbe na aail raha, ohie se koi oke na tjhoeis. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Djhoend me se dher manai log okare me bieswaas kare lagal. Oesab bolies: „Kriest ie aadmie se auro barka kaam to na kar paawat.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tab Fariesie logan djab ie baat soenies, tab barka agwan sanghe ekaatgo mahal ke siepaahie ke pathaais Jiesoe ke pakare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Etane me Jiesoe djanta se bolies: „Ham toelogke sanghe dher dien na rahabe, ham aapan pathaawe Waala ke paas laut djaab. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aur toelog hamme khodjiehe bakie na paihe. Djaaha ham djaabe toelog na djaai paihe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tab dharam ke barkwan apane apane me bolies: „Ie kaaha djaai kie hamlog oke na paai sakab? Oe thoro doesar des djaaike hoewa ke manai log ke siekhaaiga? ");
INSERT INTO hnsNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Djab oe bole hai kie: ‘Toelog hamme khodjiehe bakie na paihe?’ Aur bhie: ‘Djaaha ham rahab toelog na aai paihe,’ tab ekar matlab ka hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Djab tiewhaar ke antiem rodj aail djaun sab se barka dien raha, tab Jiesoe khara hoike djor se bolies: „Dje ke piaas lagal hai, hamare paas aaw pieje khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Parmeswar ke poestak me liekhal hai kie: ‘Dje hamare me bieswaas kare hai, okar andar me se ek nadie ghat djiewan dewe waala paanie bahiega.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Oe ie baat Pawietr Aatma ke biese me bolies. Okar biesaal maahaanta abbe na dekhaail, ohie se Pawietr Aatma okar bieswaasie logan khaatien na aail raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Djhoend me se koetjh manai log Jiesoe ke baat par bolies: „Ie aadmie sattje ke Parmeswar ke aane waala sanesia hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aur koi koi bolies: „Ie aadmie Kriest hai.” Bakie ekwan bolies: „Na. Kriest thoro Gaalielea diehaat se aaiga? ");
INSERT INTO hnsNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Parmeswar ke poestak me liekhal hai kie Kriest raadja Daawied ke aulaad me se aaiga, aur Betlehem sahar me paida hoiga djaaha Daawied rahat raha.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aisane manai log me Jiesoe ke biese me ekta na raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aur oelog me se koetjh log maangat raha oke pakare, bakie koi na karies. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tab Parmeswar ke mahal ke siepaahie logan Fariesie logan aur barka agwan ke paas lautke gail. Tab oesabhan poetjhies: „Toelog oke na pakarle?” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tab siepaahie log bolies: „Hamlog aisan biesaal baat kabhie na soenlie!” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tab Fariesie logan bolies: „Ka, oe toelogke moerie bhie biegaar deis hai? ");
INSERT INTO hnsNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Toelog djaane hai kie ekko dharam ke barkwa kie to Fariesie okare me na bieswaas kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Khaalie bhoettjar djhoend logan kare hai. Oesab Parmeswar ke kaanoen na djaane hai aur Parmeswar ke saraap oesabke oeppar hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Fariesie log me ek Niekodemas naam ke aadmie raha. Oe ek rodj Jiesoe ke paas gail raha ose batiaai khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ab oe bolies kie: „Parmeswar ke kaanoen me liekhal hai kie hamlogke na tjaahie begar khodj kare ek doesar ke kasoer dewe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tab ekwan bolies: „Ka, tohoe Gaalielea ke baate? Dja Parmeswar ke poestak me parh, tab dekhiehe kie oe diehaat se ekko Parmeswar ke sanesia na aawe hai.”  ");
INSERT INTO hnsNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ekare baad oesab ghare tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Bakie Jiesoe Djaitoen pahaar par gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Biehaan bhaile sabere sabere oe phien se Parmeswar ke mahal ke angana me gail. Tab sab manai okare paas aail, aur oe baithke oesabke siekhaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tab ekaat dharam ke parhal aur Fariesie log okare paas ekgo aurat laais. Oelog oke tjhatjhoendar kaam karte me pakar leis raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Oesab oke sab koi ke bietj me thara kar deis aur Jiesoe se bolies: „Maastar djie, hamlog ie aurat ke ek tjhatjhoendar kaam karte me pakarlie hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosas ke kaanoen me liekhal hai kie hamlogke tjaahie aisan aurat ke ieta bahaaike maar dhaare ke. Tor bietjaar ka hai? Ka howe ke tjaahie?” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Oesab ie baat poetjhies oke badjhaawe khaatien. Djab oe aurat ke kasoer na dewat, tab oe Mosas ke kaanoen toerat. Ie rakam se oesab mauka paawat oke kasoer dewe ke. Bakie Jiesoe niehoerke aapan angoerie se djamien par koetjh liekhe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Aur djab oesab doharaaike poetjhies, tab Jiesoe khara hoike oesabse bolies: „Dje kabhie paap-boeraai na karies hai, oe pahiela ieta okare oeppar bahaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tab ie baat bolke oe phien se niehoerke djamien par liekhe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tab ie baat par oesab hoewa se ek ekgo niekarke tjal gail. Sab se barkwan pahiele tjal gail. Khaalie Jiesoe aur aurat paatjhe rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tab oe khara hoike ose poetjhies: „Betie, oesab kaaha hai? Koi na ieta bahaais?” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tab aurat bolies: „Koi na.” Tab oe bolies: „Attjha, ham toke sadja bhie na debe. Dja ghare, aur ab se paap-boeraai na kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Oe auro aage manai logan se bolies: „Ham doenia ke djotie baatie. Dje hamaar rasta par tjale hai, oe kabhie na andhiaar me rahie, bakie sattja djiewan ke djotie me tjaliega.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tab Fariesie log bolies: „Toe apane baare me gawaahie dewe hai, ohie se tor baat be-kaamiel hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tab oe bolies: „Tjaahe ham apane biese me ie baat boliela, tabbo satj hai. Ham djaaniela kie ham kaaha se ailie hai aur kaaha djaabe. Bakie toelog na djaane hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Toelog aapan iensaan ke sotj-bietjaar se faisala kare hai. Bakie ham koi ke biese me faisala na kariela. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aur djab ham kartie, tab hamaar baat satj rahat. Na khaalie ham faisala kariela, bakie hamaar pathaawe Waala bhie kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aur toelogke kaanoen me liekhal hai: ‘Djab doei miela ekke baat bole hai tab satj hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ham pahiela gawaahia baatie aur hamaar Baap djaun hamke pathaais hai, oe doesara gawaahia hai. Ohie se hamlogke baat satj hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tab oesab poetjh baithal: „Tor Baap kaaha hai?” Tab oe bolies: „Toelog hamme na djaane hai aur hamaar Baap ke bhie na. Djab toelog hamme djante tab hamaar Baap ke bhie djante.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jiesoe ie sab baat bolies djab oe Parmeswar ke mahal ke angana me paisa ke kamra lage siekhaawat raha. Aur okar tem abbe na aail raha, ohie se koi na oke pakaries. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ekare baad Jiesoe phien se bolies: „Ham hia se tjal djaab aur toelog hamke khodjiehe bakie na paihe. Toelog aapan paap leike mar djaihe. Djaaha ham djaabe toelog na aai paihe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tab dharam ke barkwan apane apane me bole lagal: „Soenle? Oe bolies: ‘Djaaha ham djaab toelog na aai paihe.’ Saait oe aapan djaan lei.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tab oe bolies: „Toelog doenia ke baate, bakie ham oeppar ke baatie. Toelog iensaan ghat sotj-bietjaar kare hai, bakie ham na. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ham toelogse bollie kie toelog aapan paap leike mar djaihe. Djab toelog na bieswaas kariehe kie ham ohie baatie, tab toelog Parmeswar ke tjhama kabhie na paai sakiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tab oesab poetjhies: „Tab toe ke baate?” Tab oe bolies: „Oe to ham toelogse soeroe se bollie rahielie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Oe bolies: „Ham toelogke biese me faisala karke bahoet bol sakiela. Bakie ham na karab. Ham khaalie aapan pathaawe Waala ke baat bataabe. Aur okar baat satj hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bakie oesab na samdjhat raha kie oe Pieta Parmeswar ke biese me batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Oe bhie bolies: „Djab toelog iensaan ke Beta ke oethaai tjoekiehe, tab toelog djaan djaihe kie ham baatie. Ham apane se koetjh na kariela, bakie khaalie djaise Pieta Parmeswar hamme siekhaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Oe hamke pathaais hai aur hamare sanghe hai. Ham hardam okar hiettjha poera kariela, ohie se oe hamme kabhie na tjhories hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ie baat par dher manai log bieswaas kare lagal kie ohie Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tab oe aapan bieswaasie log se bolies kie: „Djab toelog hamaar baat soeniehe tab toelog sattje ke hamaar tjela rahiehe. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Toelog sattjaai pahietjaniehe, aur oe sattjaai ke dwaara toelogke tjhoetkaara mielie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tab oelog bolies: „Hamlog Aabraaham ke aulaad baatie aur kabhie na baanhal goelaam rahielie. Tab toe kaise bol sake hai kie hamlogke tjaahie tjhoetkaara miele ke?” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tab oe bolies: „Ham toelogse satj boliela kie dje paap karat rahe hai, oe paap ke goelaam hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ekgo ghar me ek goelaam ke hak na hai hardam rahe ke djaise ghar ke larka. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Djab Parmeswar ke Beta toelogke tjhoetkaara deiga, tab toelog sattje ke batj djaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Oe bolies: „Ham djaaniela kie toelog Aabraaham ke aulaad baate. Bakie toelog hamaar baat na maange hai apana lewe, ohie se toelog maange hai hamme maar dhaare. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ham bataaila djaun ham aapan Baap ke karat dekhlie hai. Aur toelog kare hai djaun toelog aapan baap ke bolat soenle hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tab oesab bolies: „Hamlogke baap-daada Aabraaham hai.” Tab oe bolies: „Djab toelog okar aulaad baate, tab okare ghat aapan djiewan bietaaw. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Parmeswar hamme aapan sattjaai soenaais hai. Ham toelogse ie sab baat bataaila, aur tabbo toelog hamme maange hai maar dhaare. Bakie Aabraaham aise kabhie na karies. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Toelog aapan baap ke dekhie dekha hai.” Tab oesab bolies: „Hamlog thoro tjhatjhoendarai dwaara paida bhailie hai? Hamlogke Baap Parmeswar hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tab oe bolies: „Djab oe toelogke Baap rahat tab toelog hamme pjaar karte. Ham to Parmeswar ke lage se ailie. Ham apane se na ailie, bakie oe hamke pathaais. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Toelog hamaar baat kaahe ke na samdjhe hai? Toelog na sahie paawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Toelog saitaan ke battja baate. Aur toelog khaalie maange hai okar hiettjha poera kare. Oe soeroe se djaanmarwa hai. Aur okare me tanko sattjaai na hai, ohie khaatien sattjaai oke kabhie na attjha lage hai. Djab oe djhoeth bole hai tab oe ekdam se dekhaawe hai kie oe kaise hai. Aur okare me se sab djhoeth oetpan howe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ham toelogse sattjaai boliela, ohie se toelog hamme bieswaas na kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Koi na hamme kasoer dei sake hai. Aur djab ham sattjaai boliela, tab toelog kaahe ke bieswaas na kare hai? ");
INSERT INTO hnsNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dje Parmeswar ke larka hai, oe okar baat soene hai. Bakie toelog okar larkan na baate, ohie se toelog okar baat na soene hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tab dharam ke barkwan ie baat soenke bolies: „Hamlog to bol tjoekalie kie toe ek Saamaaria waala aur bhoet se bharal baate.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tab oe bolies: „Ham bhoet se bharal na baatie. Ham aapan Baap ke aadar kariela, bakie toelog hamaar bedjatie kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na sotj kie ham maangiela aadar paawe. Bakie hamaar Baap maange hai kie ham aadar paai, aur oe sab koi ke oeppar faisala kariega. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ham toelogse satj boliela kie dje hamaar baat maanie, oe kabhie na mariega.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tab oesab bolies: „Ab hamlog djaan gailie kie toe sattje ke bhoet se bharal baate. Toe bole hai kie: ‘Dje hamaar baat maanie, oe kabhie na mariega,’ aur Aabraaham mar gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Aur Parmeswar ke sab sanesia logan bhie mar gail hai. Toe apane ke ka sotje hai? Toe oesabse thoro barka baate?” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tab oe bolies: „Djab ham apane ke barwargie kartie tab oe be-kaamiel rahat. Bakie hamaar Baap hamme barka maane hai. Toelog bole hai kie oe toelogke Parmeswar hai, ");
INSERT INTO hnsNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","bakie toelog oke na djaane hai. Ham oke djaaniela, aur djab ham boltie kie ham oke na djaaniela tab ham djhoeth boltie djaise toelogan. Ham oke djaaniela aur okar baat soeniela. ");
INSERT INTO hnsNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aabraaham khoesiaalie se agorat raha, aur djab oe hamme doenia me aawat dekhies, tab oe bahoet khoesie bhail.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tab oesab bolies: „Toe patjaas baries ke na baate, tab toe kaise Aabraaham ke dekhle?” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Bas Jiesoe bolies: „Ham toelogse satj boliela kie Aabraaham paida howe se pahiele ham baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tab oesab ieta oethaais oke maar dhaare ke, bakie oe Parmeswar ke mahal ke angana me se dhiere se niekarke tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ek dien Jiesoe paas hoite ek aadmie ke dekhies djaun paidaais se andha raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tab okar tjela log poetjhies: „Maastar djie, oe kaahe ke paidaais se andha hai? Ke paap karies hai, oe kie okar maai-baap?” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Bakie oe bolies: „Na, koi ke paap se na hai. Oe andha hai djeme ham dekhaai sakie kie Parmeswar ketana maahaan hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Djab talak dien hai tab talak hamlogke tjaahie hamaar pathaawe Waala ke bhala kaam karte rahe ke. Ek tem aaiga kie koi kaam na kar sakiega. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Djab talak ham hia baatie tab talak ham doenia ke djotie baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tab ie baat bolke oe djamien par thoekies aur aapan angoerie se mattie naram karke aadmie ke aakhie par laga deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tab ose bolies: „Dja aapan aakhie Sielowam naam ke paanie me dhoi le.” (Sielowam ke matlab hai: bhedjaawal). Aadmie gail aapan aakhie dhois aur ghare djaite me okar aakhie ekdam se attjha hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tab parosian aur doesarkwan apane apane me poetjhe lagal: „Ohie na andhwa hai djaun hardam baithke bhiekhmaangat raha?” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tab ekaat miela bolies: „Ha, ohie hai.” Bakie ekwan bolies: „Na, okar ghat hai.” Tab aadmie bolies: „Ham ohie baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tab oesabhan poetjhe lagal: „Kaise toe dekhe lagale?” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tab oe bolies: „Oe Jiesoe naam ke aadmie thora se mattie angoerie se hamaar aakhie par lagaais. Tab oe bolies: ‘Dja Sielowam ke paanie me dhoi le.’ Tab djab ham dhoi tjoekalie tab ham dekhe lagalie!” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tab oesab poetjhies: „Oe Jiesoe kaaha hai?” Tab oe bolies: „Ham na djaaniela.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Tab ekaat manai log adamia ke Fariesie logan ke paas legail. Jiesoe to mattie naram karke okar aakhie ke ekgo sabat ke dien par attjha karies raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tab ohoelogan poetjh baithal kie oe kaise attjha bhail. Tab oe phien se bataais kie: „Oe mattie hamaar aakhie par lagaais, tab ham gailie aapan aakhie dhowe, aur ab ham dekh sakiela.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tab koetjh Fariesie bolies: „Oe aadmie ie kaam karke sabat ke kaanoen toer deis hai. Ohie se hamlog djaaniela kie oe Parmeswar lage se na aail hai.” Bakie ekwan bolies: „Ka, ek paapie etana barka kaam kar sake hai?” Aisane oelog me ektaai na raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tab oesab aadmie se poetjhies: „Toe okare biese me ka sotje hai? Oe to tor aakhie attjha karies hai.” Tab oe bolies: „Hamare djaan me oe ekgo Parmeswar ke sanesia hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bakie oesab na bieswaas karat raha kie oe pahiele andha raha. Ohie se oelog okar maai-baap ke bolwaaike ");
INSERT INTO hnsNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","poetjhies: „Ie aadmie tor beta hai? Oe sattje ke paidaais se andha raha? Aur ab oe kaise dekh paawe hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tab maai-baap bolies: „Hamlog djaaniela kie ie hamlogke beta hai aur kie oe paidaais se andha raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bakie hamlog na djaaniela kaise oe ab dekh paawe hai aur ke oke attjha karies hai. Bestar toelog ohie se poetjh lo. Oe barka hai aur apane bataai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Dharam ke barkwan sallaah karies raha kie: „Dje bole hai kie Jiesoe aane waala Kriest hai, hamlog oke partjaar ke ghar me se niekaar debe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ohie se maai-baap dar ke maare ie djabaab deis raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tab Fariesie log aadmie ke phien se bolwaais aur bolies: „Khaalie Parmeswar ke aadar kar. Hamlog djaaniela kie ie aadmie paapie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tab oe bolies: „Ham na djaaniela kie oe paapie hai kie na. Ham khaalie ek tjiedj djaaniela kie pahiele ham andha rahielie aur ab ham dekh sakiela.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tab oesab phien se poetjhies: „Tab tose oe ka karies hai? Oe tor aakhie kaise attjha karies hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tab oe bolies: „Ham toelogse bataai tjoekalie, bakie toelog na soenle. Toelog kaahe ke phien se maange hai soene? Ka, toelog okar tjela bhie maange hai howe?” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tab oesab oke gaarie dewe lagal aur bolies: „Toe okar tjela baate, bakie hamlog Mosas ke tjela baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Hamlog djaaniela kie Parmeswar dher baat Mosas se bataais raha. Bakie hamlog na djaaniela kie ie aadmie kaaha se aail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tab oe bolies: „Ie kaise hoi sake hai? Oe hamaar aakhie attjha karies hai, bakie toelog na djaane hai oe kaaha se aail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sab koi djaane hai kie Parmeswar ek paapie ke praatna na soene hai, bakie djab koi okar baat maane hai aur okar hiettjha poera kare hai, tab oe okar praatna soene hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Aadj talak kabhie na bhail hai kie koi ek paidaais se andha ke aakhie attjha karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Djab oe aadmie Parmeswar ke lage se na aail rahat, tab oe hamaar khaat koetjh na kar sakat.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tab oesab bolies: „Toe ke baate hamlogke siekhaawe waala? Toe to paidaais se paapie baate.” Tab oesab oke partjaar ke ghar me se khader deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ekare baad Jiesoe soenies kie Fariesie logan ka karies hai. Tab oe ose bhet karies aur poetjhies: „Bhaai, toe iensaan ke Beta me bieswaas kare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tab aadmie bolies: „Maastar djie, oe ke hai? Ham bahoet maangiela okare me bieswaas kare.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tab oe bolies: „Toe oke dekhe hai. Toe ose batia hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bas aadmie aapan gaathie par gierke bolies: „Prabhoe djie, ham tore me bieswaas kariela!” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tab oe bolies: „Ham doenia me ailie baatie faisala kare khaatien djeme andha logan dekhe lage, aur dje sotje hai kie oe dekhe hai, oe andha hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Hoewa bhie ekaatgo Fariesie log raha, aur oesab ie baat par bolies: „Ka, hamlog andha baatie?” ");
INSERT INTO hnsNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tab oe bolies: „Toelog djab sattje andha rahiete, tab toelogke kasoer na rahat. Bakie toelog bole hai: ‘Hamlog dekhiela,’ ohie se ab talak toelog kasoerwaar baate.” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Oe bhie bolies: „Thiek se soen. Djab koi ek bhera ke pen me dwaar alang se na dja hai bakie tjaharke bhiettar dja hai, tab oe ekgo tjor kie to daakoe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bakie dje dwaar lage se bhiettar dja hai, ohie bhera tjaraawe waala hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Aur rakhwaala kamaarie okar khaatien khole hai. Tab bhera logan okar aawaadj pahietjaane hai aur oe aapan ek ek bhera ke naam bolaaike bahare ledja hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tab oe aage aage tjale hai, aur sab okar aawaadj soenke okar pietjhe aawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bakie oesab ek andjaan aadmie ke pietjhe kabhie na tjalie. Oelog okar aawaadj na tjienhe hai, ohie se oesab bhaag djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Aisahie Jiesoe manai log se ie matlab ke kaahaanie bataais, bakie oesab na samdjhies. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ohie se oe phor-phorke samdjhaawe lagal. Oe bolies: „Hamaar baat bieswaas kar, ham satj boliela. Ham bhera ke pen ke dwaar ghat baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Djaun log hamse aage aail partjaar kare, oesab djaise tjor aur daakoe raha. Bakie hamaar bhera oelogke baat na soenies. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ham bhera ke pen ke dwaar ghat baatie. Dje hamaar dwaara bhiettar djaai, oe batj djaai. Oe bhiettar aur bahare djaai sakiega tjare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tjor khaalie aawe hai tjorie kare, djaan maare aur naas kare khaatien. Bakie ham ailie hai aapan waalan ke soekhie djiewan se djaada dewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ham attjha tjaraawe Waala baatie. Aisan tjaraawe waala aapan djaan dei dewe hai aapan bhera log ke batjaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bakie ek kamkarta doesar rakam ke hai. Djab oe ser aawat dekhie tab oe bhera ke tjhorke bhaag djaai. Oesab to okar na hai. Tab ser aaike ekgo ke maarke aur ekwan ke bhagaai dei. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kamkarta khaalie paisa khaatien kaam kare hai aur oke bhera ke haat na lage hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ham attjha tjaraawe Waala baatie. Djaise ham aapan Baap ke djaaniela aur oe hamke djaane hai, aisane ham aur hamaar waalan apane apane ke djaane hai aur ham oelog khaatien aapan djaan debe. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hamke doesar bhera bhie hai aur oesab doesar pen me rahe hai. Hamke tjaahie ohoelogke tjaraawe ke. Oelog hamaar aawaadj pahietjaanke hamaar baat soeniega. Tab sab ek djhoend hoiga, aur ham oelogke ekahie tjaraawe Waala rahabe. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ham tajaar baatie aapan djaan dewe khaatien djeme ham phien se lei sakie. Ohie se Pieta Parmeswar hamme tjaahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Koi na hamaar djaan leiga, bakie ham apane debe. Hamme saktie hai aapan djaan dewe ke aur phien se lewe ke. Hamaar Baap aise bolies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tab ie sab baat soenke dharam ke barkwan me phien ektaai na raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Oesab me dher manai bolies kie: „Toelog kaahe ke okar partjaar soene hai? Oke to bhoet pakaries hai aur oe pagala hai!” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bakie doesar manai bolies: „Na, djekare oeppar bhoet hai, oe aise na batia hai. Ekgo bhoet andha ke aakhie thoro attjha kar sake hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jeroesaalem me Naawa-mahal ke tiewhaar manaawe ke tem aai gail raha. Thandha ke tem raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jiesoe Parmeswar ke mahal ke angana me Saalomo naam ke tjhaawal rasta par iedhar se oedhar aawat djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tab dharam ke barkwan oke gher leis aur poetjhe lagal: „Toe kab lek hamlogse kholke na bataihe kie toe ke baate? Hamlogse sattje bataaw kie toe Parmeswar ke Kriest baate kie na.” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tab oe bolies: „Ham toelogse bataai tjoekalie, bakie toelog na maange hai bieswaas kare. Ham aapan Baap ke naam se atjambho kaam kariela, aur aisane dekha hai kie ham Ke baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bakie toelog hamaar bhera ke djhoend me ke na baate, ohie se toelog na bieswaas kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Hamaar bhera hamaar aawaadj pahietjaane hai. Ham oelogke djaaniela aur oesab hamare paatjhe tjale hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Koi na oelogke hamare lage se hataai paai, bakie ham oelogke hardam khaatien amar djiewan debe Parmeswar lage djeme oelog ose alag na karal djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hamaar Baap oelogke hamme deis hai, aur oe sab se barka hai. Ohie se koi na hamaar waalan ke okar haath me se tjhien paai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ham aur hamaar Baap ek baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tab dharam ke barkwan phien se ieta laawe lagal oke maar dhaare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tab oe bolies: „Ham aapan Baap ke baat par dher bhala kaam karke dekhailie. Toelog kaun kaam khaatien maange hai hamme maar dhaare?” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tab oelog bolies: „Tor bhala kaam khaatien hamlog na maangiela toke maar dhaare. Bakie toe iensaan baate aur tabbo apane ke Parmeswar se baraabar karke oke bedjatie kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tab oe bolies: „Parmeswar ke poestak me liekhal hai kie: ");
INSERT INTO hnsNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","‘Ham boliela kie toelog ieswar baate.’ Oe aapan kamkartan ke aise bolaawe hai djaun se oe aapan baat bataais hai. Aur okar baat me to ab talak hoekoem hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aur djab ham boliela kie ham okar Beta baatie, tab toelog kaahe ke bole hai kie ham okar bedjatie kariela? Oe hamme alag karke doenia me pathaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Djab ham aapan Baap ke kaam na kariela tab hamare me na bieswaas kar. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bakie djab ham kariela aur toelog tabbo hamare me na bieswaas kare hai, tab bieswaas kar kie hamaar atjambho kaam Parmeswar ke saktie se karal dja hai. Tab toelog djaan djaihe kie Baap hamare me samaail hai aur ham okare me.” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tab ie baat par oesab phien se kausies karies oke pakare ke, bakie oe oesabke haath me se batj gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tab oe phien Jordaan nadie ke habara gail djaaha Johaanas pahiele dopoe karat raha, aur koetjh dien talak hoewa rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dher manai okare lage aail aur apane me bole lagal: „Johaanas ekko barka kaam na karies, bakie okar sab baat Jiesoe ke biese me satj hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aur hoewa par dher manai log Jiesoe me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betaania gaaw me ekgo Laasaaras naam ke aadmie rahat raha. Okar doei bahien hoewa bhie rahat raha. Oelogke naam Maarta aur Maria raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria ohie aurat raha djaun Jiesoe ke gor me mahakat tel lagaais aur aapan baar se potjhies raha. Ek dien Laasaaras bemaar paral. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tab doeno bahien Jiesoe ke sanesa pathaais kie okar pjaara sanghatia Laasaaras bemaar hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tab Jiesoe ie baat soenke bolies: „Ie bemaarie se ant me okar maut na hoiga. Bakie ekare dwaara Parmeswar ke aadar karal djaai aur okar Beta ke maahaanta dekhaai djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Oe ie tieno ke bahoet tjaahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tabbo ie sanesa soenke oe toerante oesabke paas na gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tab doei rodj baad oe aapan tjela log se bolies: „Ab tjalie Joedea.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tab oelog bolies: „Maastar djie, halieje to barkwan toke Joedea me maangat raha ieta se maar dhaare, aur ab toe maange hai phien se hoewa djaai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tab oe bolies: „Ek dien me baara ghanta hai. Dje andjor me tjale hai, oe na gierie. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bakie dje andhiaar me tjale hai, oe gier djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ekare baad oe bhie bolies: „Hamlogke sanghatia Laasaaras soet gail hai. Bakie ham djaabe oke djagaawe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tab tjela log bolies: „Maastar djie, djab oe soete hai tab oe attjha hoi djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Oesab sotjat raha kie Jiesoe bolies hai kie Laasaaras khaalie soete hai. Bakie okar matlab raha kie oe mar gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tab oe kholke bataais kie: „Laasaaras mar gail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Oe bolies: „Toelogke bieswaas barhaawe khaatien ham khoesie baatie kie ham hoewa na gailie. Bakie ab hamlog okar paas tjalie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tab Tomaas djaun bhie „‘djorwa”’ bolaawal djaat raha, oe bolies: „Attjha, aaw hamahoelog tjalie dja. Tab hamlog okar sanghe mare k'hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tab djab Jiesoe Betaania gaaw ke nagietj pahoetjal, tab oe soenies kie Laasaaras ke mattie parle tien rodj bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaania Jeroesaalem sahar se khaalie lagbhag tien kilometer doer raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Hoewa se dher dharam ke barkwan bhie marnie me aail raha Maarta aur Maria ke ghare baithe. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tab Maarta djab soenies kie Jiesoe aawe hai tab aadha rasta par gail ose bhet kare. Bakie Maria ghare rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tab Maarta Jiesoe se bolies: „He Prabhoe djie, djab toe hia rahiete tab hamaar bhaai na marat. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bakie ham djaaniela kie Parmeswar toke ab bhie deiga djaun toe ose mangiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tab oe bolies: „Maarta, tor bhaai phien djie oethiega.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tab aurat bolies: „Djie-ha, ham djaaniela kie doenia ke antiem dien par oe bhie djie oethaawal djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tab oe bolies: „Ham djie oethaawe Waala aur sattja djiewan baatie. Dje hamare me bieswaas kare hai, oe hardam khaatien aapan djiewan Parmeswar ke sanghe bietaaiga, tjaahe oe mar djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Oe kabhie na Parmeswar se alag karal djaaiga. Toe ie baat bieswaas kare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tab aurat bolies: „Djie-ha, Prabhoe, ham bieswaas kariela kie toe aane waala Kriest hai djaun doenia me aawat aur toe Parmeswar ke Beta baate.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tab baat-tjiet karke Maarta gail aapan bahien ke laawe. Oe ose dhiere se bolies: „Maastar djie aail hai aur toke bolaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tab Maria haalie se oethke okar paas gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","31","Tab dharam ke barkwan djaun oelogke ghare aail raha baithe, djab oesab dekhies kie Maria haalie se bahare dja hai, tab sotjies kie oe dja hai kabar lage rowe, aur oelog okare paatjhe gail. Jiesoe gaaw me abbe na pahoetjal raha. Oe hoewe thara raha djaaha Maarta ose bhet karies raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tab Maria djab Jiesoe ke lage aail, tab gaathie par gierke bolies: „He Prabhoe djie, djab toe hia rahiete tab hamaar bhaai na marat.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tab djab Jiesoe dekhies kie kaise oe aur sab doesarkwan rowe hai, tab oke bahoet sotj aur haat lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Oe poetjhies: „Toelog oke kaaha dharle hai?” Tab oesab bolies: „Prabhoe, tjalie dekhe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tab oe bhie rowe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Dharam ke barkwan apane me bolies kie: „Toe dekh sake hai kie oe Laasaaras ke ketana tjaahat raha.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bakie koi koi bolies: „Oe ekgo andha ke aakhie attjha karies hai. Ka, oe Laasaaras ke bhie maut se na batjaai sakat raha?” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tab kabar ke paas djaaike Jiesoe ke phien sotj aur haat lagal. Oe kabar djaise ekgo tjhota kamra pahaar me raha. Aur dwaar par ekgo barka ieta rakhal raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tab Jiesoe bolies: „Oe ieta hataaw.” Bakie Maarta bolies: „Prabhoe djie, okar marle to tien rodj bhail hai, oe mahakat hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tab oe bolies: „Ham tose bollie rahielie kie djab toe bieswaas kariehe tab toe Parmeswar ke maahaanta dekhiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tab oesab ieta hataais. Tab Jiesoe oeppar taakke bolies: „Pieta djie, ham toke bahoet dhanbaad kariela kie toe hamaar praatna soenle hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ham djaaniela kie toe hardam hamaar praatna soene hai. Aur aalam khaatien ham ab ie baat boliela djeme oesab bieswaas kare kie toe hamme pathaile hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tab praatna karke oe djor se bolaais: „E Laasaaras! Toe bahare aaw!” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Laasaaras bahare aail. Okar dehie bhar kapphan se aur moerie pattie se baanhal raha. Tab Jiesoe manai log se bolies: „Oke khol de aur djaain de.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Dher dharam ke barkwan aail raha Maria ke ghare baithe. Tab djab oelog ie sab dekhies, tab dher manai Jiesoe me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bakie ekaatgo djaaike Fariesie logan se bataais kie Jiesoe ka ka karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tab barka agwan aur Fariesie log barkwan ke ekattha bolaais baat-tjiet kare khaat. Oesab apane me bole lagal kie: „Oe aadmie dher barka kaam kare hai. Ab hamlog ka karie? ");
INSERT INTO hnsNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Djab hamlog oke sab tjiedj karan debe, tab sab djanta okare me bieswaas kare lagie. Tab Roma ke soerdjaatie log aaike hamlogke dardja aur hoekoem ie djaatie ke oeppar se tjhien lei.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Oe tem par sab se barka agwa Kaajaafas raha. Oe bolies: „Toelog koetjh na samdjhe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Aapan magadj kaam me laaw. Bestar rahie kie ek djane mare aur na sab djanta naas howe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Oe ie baat aapan sotj-bietjaar se na bolies, bakie oe sab se barka agwa ghat aagam se bataai paais kie Jiesoe djanta khaatien marat. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aur na khaalie Israel log khaatien, bakie Parmeswar ke doenia bhar ke larkan khaatien bhie. Ie rakam se oesab ek howat. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Oe rodj se Israel ke barkwan ekgo mauka khodje lagal oke marwaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ohie se Jiesoe oelogke bietj me se tjal gail aur Efraim sahar gail. Oe sahar maidaan ke nagietj raha. Hoewa par oe koetjh rodj aapan tjela log ke saath rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Djab Israel logan ke Paasan ke tiewhaar nagtjaail tab dher diehaat waalan Jeroesaalem sahar gail apane ke sar-safaai kare ke tiewhaar manaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Oesab tjaaro alang Jiesoe ke khodjat raha. Tab djab oelog Parmeswar ke mahal ke angana me ekattha bhail, tab apane me poetjhe lagal: „Toelog ka sotje hai, oe bhie aai tiewhaar manaawe?” ");
INSERT INTO hnsNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Barka agwan aur Fariesie logan hoekoem deis raha kie dje koi djaanie kie Jiesoe kaaha hai, oke tjaahie oelogse bataawe ke. Tab oesab oke pakar lewat. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paasan ke tiewhaar manaawe ke tjhau rodj rahie gail raha, tab Jiesoe phien se Betaania gaaw me aail. Hoewa par oe Laasaaras ke djie oethaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Oesab bhodjan tajaar karies okar ieddjat kare khaatien. Maarta parsat raha aur Jiesoe aur Laasaaras pahoena log ke saath bhodjan karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tab Maria ekgo botal mahake waala tel leike Jiesoe ke gor me lagaais aur aapan baar se potjhies. Aur tel ghar bhar me mahake lagal. Oe tel safa nardas se banaawal raha aur bahoet mahanga raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Baara tjela me se ekgo ke naam Joedaas Eskaariot raha. Ohie Jiesoe ke tjoegalie karat. Djab oe dekhies kie Maria ka kare hai, tab ose bolies: ");
INSERT INTO hnsNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","„Ie tel ek baries ke kamaai hai. Toe eke betjke aur garieb logan ke dei sakte.” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Joedaas garieb logan ke daaja na karat raha, bakie oe ekgo tjor raha. Jiesoe log ke paisa-kaurie okare lage rahat raha, aur oe oman se hardam koetjh tjoraai lewat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tab Jiesoe bolies: „Oke koetjh na bol. Oe aise karke hamaar mattie tajaar karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Garieb logan to sada rahie aur toe oesabke hardam koetjh dei sakiehe. Bakie ham toelogke saath bahoet dien na rahabe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Aise bhail kie dher manai log soen leis raha kie Jiesoe Betaania gaaw me hai. Aur ohoesab hoewa gail. Oelog na khaalie Jiesoe ke maangat raha dekhe bakie Laasaaras ke bhie. Jiesoe to oke djie oethaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Aur dharam ke barkwan me se bhie dher log aail oke dekhe aur Jiesoe me bieswaas kare lagal. Ohie se barka agwan sallaah karies Laasaaras ke bhie maar dhaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Biehaan bhaile Jeroesaalem me tiewhaar manaawe waalan soenies kie Jiesoe aawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tab oesab sahar me se niekarke gail ose aadha rasta par bhet kare. Oesab khoesiaalie ke maare narjar ke per ke daarhie hielaaike djor se bolies: „Parmeswar ke aadar kar! Israel ke Raadja Prabhoe ke naam se aawe hai! Prabhoe oke aasies dewe!” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tab Jiesoe ekgo madjhielka gadaha leike opar baith gail. Parmeswar to dher dien pahiele aapan poestak me liekhwaais raha kie: ");
INSERT INTO hnsNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","„He Sion sahar ke manai log, toelog na dera. Dekh, toelogke raadja ekgo gadaha par aawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Oe tem par Jiesoe ke tjela log na samdjhies ka howe hai. Bakie koetjh dien ke baad djab dekhaail raha kie okar maahaanta ketana biesaal hai, tab oesab samdjhe lagal kie aisahie Parmeswar ke liekhal baat poera bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Dher manai log dekhies raha kaise Jiesoe Laasaaras ke kabar me se bolaaike djie oethaais raha. Oelog sab koi se bataawat raha ka bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ohie se dher manai log gail oke dekhe. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tab Fariesie log apane me bole lagal: „Dekh, doenia bhar okar pietjhe tjale hai! Djab hamlog koetjh na karab tab bahoet aafat hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ekaat Griek ke manai Jeroesaalem sahar me aail raha Paasan ke tiewhaar manaawe aur Parmeswar ke poedje. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tab oesab Fielepas ke paas aaike poetjhies: „Bhaai djie, hamlog Jiesoe se bhet kar sakiela?” Fielepas Betsaaida sahar Gaalielea diehaat ke raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Oe gail Andreas se bataawe aur doeno djaaike Jiesoe se poetjhies. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tab oe bolies: „Ab tem aail hai kie iensaan ke Beta ke maahaanta dekhaawe ke tjaahie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Oe ek matlab ke baat kaam me leike samdjhaawe lagal: „Thiek se soen. Djab ekgo bia djamien par gierke na phoetiega, tab bia rahie djaai. Bakie djab oe djamke bia na rahiega, tab koetjh dien baad bahoet phal deiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aisane djab koi aapan djiewan khaalie apane khaat bietaaiga, tab okar djiewan be-kaamiel hoi djaaiga. Bakie dje aapan sab hiettjha tjhorke aur Parmeswar ke man waala kariega, oke hardam khaatien sattja djiewan mieliega. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Dje maange hai hamaar naukar bane, oke tjaahie hamaar rasta par tjale ke. Aur djaaha ham rahabe, ohoe rahiega. Dje hamare khaat kaam kare hai, oke hamaar Baap barka maanie. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ab ham bahoet ghabaraaila. Ham na maangiela praatna kare kie: ‘Pieta djie, hamme aane waala moesiebat me se batjaai le.’ Na, ham to doenia par ailie hai ie doekh aur maut sahe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ohie se ham praatna kariela kie: ‘Pieta djie, sab koi ke dekhaaw kie tor naam ketana maahaan hai.’ ” Tab etane me ekgo aawaadj oeppar se soenaail kie: „Ham dekhailie kie hamaar naam ketana maahaan hai aur ham phien se dekhaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hoewa ke manai logan bhie koetjh soenies. Tab ekaatgo bolies: „Baadar gardje hai.” Aur doesar log bolies: „Ekgo Parmeswar ke parie ose koetjh bolies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Bakie Jiesoe bolies: „Oe aawaadj hamaar khaat na raha, bakie toelog khaat. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ab tem aai gail hai kie Parmeswar iensaan log ke oeppar faisala kariega. Iesaait saitaan doenia par raadj kare hai, bakie ab oe khaderal djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Djab ham khambha par oethaawal djaabe, tab ham sab koi ke apane me bieswaas karwaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ie baat se oe bataais kie oe kaise marie. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tab manai log bolies: „Hamlogke dharam ke kaanoen me liekhal hai kie Kriest hardam rahiega. Tab toe kaise bol sake hai kie iensaan ke Beta khambha par maar dhaaral djaaiga? Oe aane waala Kriest hai kie na?” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tab oe bolies: „Andjor dher dien toelogke sanghe na rahiega. Djab talak hoi sakie andjor me tjal. Dje andhiaar me tjale hai, oe rasta na dekh paawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Djab talak Andjor toelogke sanghe hai, ekare me bieswaas kar. Tab toelog okare me bhaag leihe.” Tab ie baat bolke oe hoewa se ek djagaha tjal gail djaaha koi na djaanat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tjaahe Jiesoe djetana barka kaam oelogke aage karies raha, tabbo oesab na bieswaas karat raha kie ohie Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Aisahie Parmeswar ke sanesia Jasaaja ke baat poera bhail. Oe bolies raha: „Prabhoe djie, ke hamlogke baat ke bieswaas karies hai? Aur ke samdjhies hai kie ie sab atjambho kaam se torahie saktie dekhaat raha?” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jasaaja be-bieswaasie log ke biese me liekhies raha kie oesab na bieswaas kar paawe hai. Oe liekhies raha kie: ");
INSERT INTO hnsNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","„Parmeswar oelogke djaise andha kar deis aur oelogke diel djaise patthar ke banaai deis. Oe na maangat raha kie oelog koetjh djaane aur samdjhe, nahie to oelogke man badal djaat aur oesabke daaja mielat, tab oke oelogke diel attjha kare ke parat.” ");
INSERT INTO hnsNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Dher dien pahiele Jasaaja dekhies raha kie Jiesoe ke maahaanta ketana biesaal hai. Ohie se oe ie sab baat Jiesoe ke biese me bataais raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tabbo dher barkwan bieswaas karat raha kie oe aane waala Kriest hai. Bakie oesab koetjh na bolat raha. Oesab to deraat raha kie Fariesie logan oelogke aapan partjaar ke ghar me se niekaar dewat. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Oelogke khaat sab se barka tjiedj raha kie manai logan oesabke aadar karie, aur na kie Parmeswar ka sotjie. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ek dien Jiesoe djor se bolies: „Dje hamare me bieswaas kare hai, oe na khaalie hamare me bieswaas kare hai bakie bhie Parmeswar me. Oe to hamme pathaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aur dje hamke dekhe hai, oe hamaar pathaawe Waala ke dekhe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ham doenia me djaise andjor ailie baatie har ek bieswaasie ke andhiaar me se niekaare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Djab koi soenie kie ham ka boliela aur tabbo na maanie, tab ham oke kasoer na debe. Ham na ailie hai kasoer dewe bakie batjaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Djab koi hamaar baat na soene hai aur hamme na maange hai, tab doenia ke antiem dien par oke kasoer dewal djaai. Hamaar baat dwaara dekhaawal djaai kie oe kasoerwaar hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ham to aapan man se ie baat na bolat rahielie, bakie Pieta Parmeswar hamke hoekoem deis raha ka bole ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aur ham djaaniela kie okar hoekoem dwaara bieswaasie log ke okar lage amar djiewan mieliega. Ohie se ham khaalie oe baat bataaila djaun oe hamse bolies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paasan ke tiewhaar nagtjaail raha. Jiesoe djaanat raha kie okar tem aail hai doenia tjhorke Pieta Parmeswar ke paas djaai ke. Ohie tem me oe dekhaais kie oe ant talak aapan doenia par ke sanghatian ke ketana pjaar kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Oe aapan tjela logan sanghe bhodjan karat raha. Ohie tem par saitaan Siemon Eskaariot ke beta Joedaas ke aapan bietjaar dei tjoekal raha Jiesoe ke tjoegalie kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jiesoe thiek se djaanat raha kie okar Baap sab tjiedj okar haath me saup deis hai. Oe bhie djaanat raha kie oe Parmeswar lage se aail hai aur halieje phien se okare lage djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tab oe oethke aapan koerta oetaarke aur ekgo kapra aapan karhiaaw me baanh leis. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tab kobba me paanie bharke oe soeroe karies aapan tjela log ke ek ekgo ke gor dhowe aur kapra se potjhe ke djaun aapan karhiaaw me baanhies raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tab djab Siemon Petras ke paarie bhail tab oe bolies: „Prabhoe, ham tose aapan gor na dhowaai sakiela.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tab oe bolies: „Toe abbe na samdjhe hai kie ham ka kariela, bakie baad me toe samadjh djaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tab Petras bolies: „Na, ham tanko na maangiela kie toe hamaar gor dhow!” Tab oe bolies: „Djab ham tor gor na dhobe, tab toe hamaar koi na baate.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tab Siemon Petras bolies: „Prabhoe djie, djab aise baat hai tab na khaalie hamaar gor dhow, bakie hamaar haath aur moerie bhie!” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tab oe bolies: „Dje nahaai tjoeke hai, djab oe ekare baad kahie djaai tab oke tjaahie khaalie aapan gor phien se dhowaawe ke. Toelog ekdam safa baate, khaalie ek djane ke diel safa na hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Oe djaanat raha kie oke ke tjoegalie karat, ohie se oe aise bolies. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tab djab oe gor dhoi tjoekal, tab aapan koerta pahienke phien bhodjan kare lagal. Tab bolies: „Toelog samadjhle kie ham ka karlie hai? ");
INSERT INTO hnsNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Toelog hamme ‘Maastar djie’ aur ‘Prabhoe’ bolaawe hai, aur ie thiek hai. Ham ohie baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aur djaise ham toelogke gor dhoilie, oisahie tohoelogke tjaahie ek doesare ke gor dhowe ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ie kaam karke ham maangat rahielie toelogke dekhaawe kaise toelogke tjaahie apane me goelaam ghat rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sattje ke, ekgo goelaam aapan maaliek se thoro barka hai? Aur ekgo sanesia aapan pathaawe waala se bhie thoro barka hai? ");
INSERT INTO hnsNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ab toelog ie baat samadjhke aisahie kariehe. Tab toelog soekh me rahiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Oe bolies: „Djaun ham ab boliela sab koi khaat na hai. Ham djaaniela kie ham ke ke aapan tjela tjoenlie hai. Ie rakam se Parmeswar ke liekhal baat poera howe ke tjaahie. Oe liekhwaais raha: ‘Djaun aadmie hamare sanghe ek bartan me khaat raha, oe hamaar doesman hoi gail hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ham ie baat poera howe se pahiele toelogse bataaila. Aur djab aise hoi tab toelog auro bieswaas kariehe kie ham Kriest baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ham toelogse sattje ke bataabe kie dje oelogke bieswaas karie djaun ke ham pathaabe, oe hamke apana lei. Aur dje hamke apanaai, oe oke bieswaas karie djaun hamke pathaais hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ie baat bolke Jiesoe ke bahoet sotj aur doekh paral. Oe bhie bolies: „Ham toelogse satj boliela kie toelog me se ek djane hamme tjoegalie karie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tab tjela log tjauk gail aur apane me poetjhe lagal kie ke hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sab tjela me se Jiesoe ekgo ke bahoet tjaahat raha, aur oe okar lagwe raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tab Siemon Petras oke doerie se sankiaais kie: „Poetjh kie ke hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tab oe tjela Jiesoe lage satke poetjhies: „Prabhoe djie, ke hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tab Jiesoe ose dhiere se bolies: „Dje ke ham ie toekkara bret soerwa me borke debe, ohie hai.” Tab oe ek toekkara bret leike soerwa me borke aur Siemon Eskaariot ke beta Joedaas ke deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Joedaas bret lei leis. Tab Jiesoe ose bolies: „Haalie se kar le djaun toke kare ke hai.” Ekare baad saitaan Joedaas ke oeppar raadj tjalaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ekwan me se ie baat ke matlab koi na samdjhies. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Joedaas oesabke paisa-kaurie ke rakhwaala karat raha, ohie se koi koi sotjies kie oke tjaahie nauta khaatien koetjh kiene ke, kie to garieb log ke koetjh dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tab Joedaas bret leike bahare tjal gail. Oe same raat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Djab Joedaas tjal gail raha tab Jiesoe bolies: „Ab iensaan ke Beta ke maahaanta dekhaawal djaai, aur ekare dwaara bhie dekhaai kie Pieta Parmeswar ketana maahaan hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Djab aise bhail hoi, tab Parmeswar aapan maahaanta okar Beta me dekhaaiga aur ie halieje hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Pjaara bhaai log, ab ham dher dien toelogke saath na rahab. Toelog hamme khodjiehe. Aur djaun baat ham dharam ke barkwan se bollie hai, ab ham toelogse bhie bataaila kie djaaha ham djaabe toelog na djaai paihe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Oe bolies: „Ham toelogke ek naawa hoekoem deila kie toelogke tjaahie apane me prem kare ke. Djetana ham toelogke prem karlie hai, otane tohoelogke tjaahie apane me kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Toelogke prem dekhke sab koi djaan djaai kie toelog hamaar tjela baate.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tab Siemon Petras poetjhies: „Prabhoe djie, toe kaaha dja hai?” Tab Jiesoe bolies: „Djaaha ham djaabe toe abbe na djaai sake hai. Bakie baad me toe hoewa djaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tab Petras poetjhies: „Prabhoe, ham kaahe ke ab tore sanghe na djaai sakiela? Ham tor khaatien aapan djaan debe!” ");
INSERT INTO hnsNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tab oe bolies: „Ka, toe hamaar khaatien aapan djaan deihe? Ham djaaniela kie moerga bole se pahiele toe tien dafe dar ke maare boliehe kie toe hamme na djaane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Oe bolies: „Na ghabara. Toelog Pieta Parmeswar par bharosa kare hai, aur hamare me bhie bieswaas kar. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Hamaar Baap ke ghar me dher rahe ke djagaha hai. Djab aise na rahat tab ham toelogse bataitie. Ab ham hoewa djaaila toelog khaatien djagaha tajaar kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aur djab ham don hoi djaab tab ham lautke aab toelogke lewe, tab tohoelog rahiehe djaaha ham rahabe. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aur djaaha ham djaabe, toelog oe rasta djaane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tab Tomaas bolies: „Prabhoe djie, hamlog na djaaniela toe kaaha dja hai. Tab hamlog kaise rasta djaanab?” ");
INSERT INTO hnsNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tab oe bolies: „Hamahie rasta, sattjaai aur djiewan baatie. Koi na Pieta Parmeswar ke paas djaai sake hai hamare biena. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Djab toelog djaane hai kie ham Ke baatie, tab toelog bhie djaan djaihe kie hamaar Baap Ke hai. Ab se toelog oke djaniehe aur dekhiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tab Fielepas bolies: „Prabhoe, hamlog maangiela Pieta Parmeswar ke dekhe, otane thiek hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tab oe bolies: „Fielepas, etana dien se ham toelogke lage baatie, aur toelog hamke abbe na djaane hai? Dje hamke dekhies hai, oe Parmeswar ke dekhies hai. Tab toe kaise bol sake hai kie: ‘Hamlog maangiela Pieta Parmeswar ke dekhe’? ");
INSERT INTO hnsNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ka, toelog na bieswaas kare hai kie ham Pieta Parmeswar me saamiel baatie aur oe hamare me? Djaun baat ham toelogse bataaila ham apane se na boliela, bakie aapan Baap ke hoekoem se. Oe hamare me saamiel hai aur hamse aapan kaam poera karwaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bieswaas kar kie Pieta Parmeswar hamare me hai aur ham okare me baatie. Aur djab toelog ie na bieswaas kariehe, tab hamaar barka kaam dwaara bieswaas kar. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sattje ke, djab toelog hamare me bieswaas kare hai, tab toelog bhie aisan barka kaam kariehe. Aur djab ham aapan Baap ke paas djaab, tab toelog hamse auro barka kaam kariehe. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aur tjaahe djaun tjiedj toelog hamaar naam se mangiehe, ham debe djeme Pieta Parmeswar ke maahaanta okar Beta me dekhaai djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Aur djab toelog hamaar naam se koetjh mangiehe, tab ham poera karab.” ");
INSERT INTO hnsNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Oe bolies: „Djab toelog hamme pjaar kariehe tab toelog hamaar hoekoem par tjaliehe. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hamaar praatna par Pieta Parmeswar ek doesar tieha dewe Waala ke pathaai hardam toelogke sanghe rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Oe Parmeswar ke sattjaai ke Aatma hai. Be-bieswaasie log oke na apanaai sake hai. Oelog oke na dekh paawe hai aur na djaane hai. Bakie oe toelogke diel me aaike rahiega, ohie se toelog oke djaniehe. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ham toelogke anaat ghat tjhorke na djaab. Ham lautke aabe. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Halieje be-bieswaasie log hamke na dekhiega. Bakie toelog hamme dekhiehe. Ham djiebe aur toelogke aatma bhie djiega. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ohie tem par toelog djaan djaihe kie ham aapan Baap se aur toelog hamse aur ham toelogse ek baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Dje hamaar hoekoem par tjale hai, ohie hamme pjaar kare hai. Aur hamaar Baap oke prem kare hai. Ham oke bhie prem kariela aur oke dekhaabe kie ham Ke baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tab ekgo tjela djaun ke naam bhie Joedaas raha (bakie na Eskaariot ke beta), oe poetjhies: „Prabhoe djie, toe kaahe ke hamlogke dekhaihe kie toe Ke baate, bakie be-bieswaasie log ke na?” ");
INSERT INTO hnsNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tab oe bolies: „Khaalie djab koi hamme tjaahiega, tab oe hamaar baat soeniega aur hamaar Baap oke prem kariega. Aur hamlog doeno djane okar diel me aaike rahabe. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Bakie dje hamme na tjaahe hai, oe hamaar baat na soene hai. Aur djaun baat ham toelogse boliela, oe hamaar baat na hai bakie Pieta Parmeswar ke. Oe hamke pathaais hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Oe bhie bolies: „Ham abbe toelogke lage baatie, ohie se ham toelogse ie sab baat bataaila. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aur Pieta Parmeswar hamare naam se Pawietr Aatma ke pathaaiga. Oe toelogke tieha deiga, sab tjiedj siekhaaiga aur toelogke hamaar sab baat jaad karwaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ham toelogke sjaantie me tjhorke djaabe. Manai logan aisan sjaantie na dei sake hai, khaalie ham dei sakiela. Ohie se na ghabaraihe aur na deraihe. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Toelog soenle kie ham bollie: ‘Ham tjal djaabe aur phien se lautke aabe.’ Djab toelog hamme tjaahe hai, tab toelogke tjaahie khoesie rahe ke kie ham aapan Baap ke paas djaabe. Bietjaar kar kie oe hamse maahaan hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ham ie sab tjiedj howe se pahiele bataaila. Tab djab poera hoi tab toelogke bieswaas parie kie hamaar baat satj hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Saitaan aaiga, ohie se hamke bahoet tem na hai toelogse batiaai ke. Oe doenia ke raadj tjalaawe waala hai, bakie hamaar oeppar raadj na tjalaai paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Doenia ke tjaahie djaane ke kie ham aapan Baap ke pjaar kariela aur khaalie okar hoekoem par tjaliela.” Oe bolies: „Oeth, ab hia se tjalie dja.” ");
INSERT INTO hnsNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jiesoe auro aage kahies kie: „Ham sattja agoer ke per baatie, aur hamaar Baap djaise khetiar hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Djaun lattie me phal na hai, oe oke kaat dewe hai. Aur djab lattie me phal hai, tab oe oke tjhapak dewe hai djeme oe auro phal dewe. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Toelogke diel hamaar baat dwaara safa karal gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Hamare me saamiel rahoe, djaise ham toelog me saamiel baatie. Ek lattie khaalie phal dei sake hai djab oe per me rahie djaai. Aisahie tohoelogke karnie ke phal khaalie barhia rahiega djab toelog hamare me saamiel rahiehe. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ham djaise agoer ke per baatie aur toelog djaise lattie baate. Dje hamare me saamiel rahie aur ham okare me, okar karnie ke phal attjha rahiega. Bakie hamaar biena toelog ekko attjha kaam na kar paihe. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Dje hamare me saamiel na rahie, oe to djaise biegal lattie djhoeraai djaai. Aisan lattie batorke aagie me djaraawal djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bakie djab toelog hamare me saamiel rahiehe aur hamaar baat maanat rahiehe, tab tjaahe djaun tjiedj mangiehe toelog khaatien poera hoiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Djab toelogke karnie ke phal barhia rahie, tab hamaar Baap ke maahaanta toelog me dekhaaiga. Aur bhie dekhaaiga kie toelog hamaar tjela baate. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Djaise Pieta Parmeswar hamke tjaahe hai, aisahie ham toelogke tjaahiela. Hamaar prem me aapan djiewan bietaaw. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ham hardam aapan Baap ke hoekoem par tjaliela, ohie se oe hamme prem kare hai. Aisahie tohoelog djab hamaar baat soeniehe, tab bhie hamaar prem toelogke saath rahie. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ham toelogse ie sab baat bataaila djeme toelog hamaar khoesiaalie me bhaag leihe aur toelogke khoesiaalie poera hoi djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Hamaar hoekoem hai kie toelog apane apane me prem kar djaise ham toelogke kariela. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Dje aapan saathie khaat aapan djaan dewe hai, ohie sab se barka premie hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aur djab toelog hamaar baat soeniehe tab toelog hamaar saathie baate. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ekgo goelaam na djaane hai kie okar maaliek ka maange hai kare. Ohie se ham toelogke goelaam ghat na samdjhiela, bakie aapan saathie ghat. Ham toelogse to aapan Baap ke sab baat batailie hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Toelog hamke na tjoenle hai, bakie ham toelogke tjoenlie baatie. Toelogke tjaahie djaaike aur aapan djiewan khaalie Parmeswar khaatien bietaite rahe ke. Tab oe toelogke sab tjiedj deiga djaun toelog hamare naam se mangiehe. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ham phien se toelogse boliela kie toelog apane apane me prem kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Oe bolies: „Djab be-bieswaasie log toelogke oeppar goessa hai, tab jaad kariehe kie pahiele oelog hamare oeppar bhie goessaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Djab toelog oesabke ghat rahiete tab oesab toelogke tjaahat. Bakie ham toelogke oesab me se tjoenlie hai aur toelog ab oesabke saath na baate. Ohie se oesab ab toelogke oeppar goessa hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Jaad kar kie ham bollie rahielie: ‘Ekgo goelaam aapan maaliek se thoro barka hai?’ Ekar matlab hai kie djab oelog hamme sataawe hai, tab oesab tohoelogke sataaiga. Aur djab manai log hamaar baat apanaais hai, tab tohoelogke baat bhie apanaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bakie toelog hamare me bieswaas kare hai, ohie se oesab toelogke sataaiga. Oelog to hamaar pathaawe Waala ke na djaane hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Djab ham na aaike oesabse aapan Baap ke baat bataitie, tab oesab be-kasoer rahat. Bakie oelogke aapan boeraai khaatien ab ekko bahaana na hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Dje hamme djaran kare hai, oe hamaar Baap ke bhie djaran kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Djab ham etana atjambho kaam oelogke aage na kartie djaun koi na karies hai, tab oesabke kasoer na rahat. Bakie ab oesab hamaar kaam aapan aakhie se dekhies hai, aur tabbo hamke aur hamaar Baap ke djaran kare hai. Ohie se oesabke kasoer hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aisahie Parmeswar ke poestak ke baat poera howe ke tjaahie kie: ‘Oelog djhoetthe ke hamaar oeppar goessa hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Bakie ham toelog khaatien tieha dewe Waala ke pathaabe. Oe sattjaai ke Aatma hai aur Parmeswar lage se aaiga. Aur oe hamare biese me gawaahie deiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Toelog soeroe se hamare lage rahiele, ohie se tohoelogke tjaahie bhie hamare biese me gawaahie dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ham toelogse se ie sab baat bataaila nahie to toelog aapan bieswaas tjhor deihe. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dharam ke barkwan toelogke to na khaalie aapan partjaar ke ghar me se niekaswaai dei, bakie bhie ek dien toelogke marwaai dhaarie. Aise karke oesab sotjiega kie oelog Parmeswar khaatien barhia kaam kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iesab Parmeswar ke aur hamke na djaane hai, ohie se oesab aise kariega. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ham toelogse ie sab bataaila, tab djab tem aai tab toelogke hamaar baat jaad hoi. Ham toelogke lage rahielie, ohie se ham toelogse sataawe ke biese me koetjh na bataawat rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Bakie ab ham aapan pathaawe Waala ke paas lautke djaabe. Tabbo toelog me se koi na poetjhe hai kie: ‘Toe kaaha djaihe?’ ");
INSERT INTO hnsNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Toelogke ie baat se bahoet doekh hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bakie ham toelogse sattje ke bataaila kie toelog khaat bestar hai kie ham djaabe. Djab ham na djaabe tab tieha dewe Waala na aai sakie. Bakie djab ham djaabe tab ham oke toelogke lage pathaabe. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aur djab oe aaiga tab oe doenia ke dekhaaiga kie paap kaun tjiedj hai. Oe sab ke samdjhaaiga ekgo iensaan kaise be-kasoer ghat Parmeswar se ek hoi sake hai, aur bhie kie Parmeswar saitaan ke oeppar faisala kariega. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Oelog hamare me bieswaas na kare hai, ohie se oe dekhaaiga kie oesab paapie hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ham aapan Baap ke paas tjal djaabe aur toelog hamme na dekh paihe. Ese dekhal djaai kaise ek iensaan be-kasoer aur Parmeswar se ek hoi sakie. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aur bhie dekhaawal djaai kie Parmeswar saitaan ke oeppar faisala kar tjoekal hai, tjaahe oe ab talak doenia ke raadj tjalaawe waala hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Hamme bahoet koetjh hai bataawe ke, bakie toelog abbe na sahie paihe. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pawietr Aatma ‘sattjaai ke Aatma’ bolaawal dja hai. Aur djab oe aaiga, tab oe toelogke Parmeswar ke poera sattjaai siekhaaiga. Oe na apane se bataaiga, bakie khaalie djaun Parmeswar ose boliega. Aur oe toelogke aane waala tjiedj djanaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Oe toelogse hamaar baat bataaiga. Aisane oe dekhaaiga kie ham ketana maahaan baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pieta Parmeswar ke sab tjiedj hamaar bhie hai. Ohie se ham bollie kie oe toelogse hamaar baat bataaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Oe bolies: „Thora dien auro tab toelog hamme na dekhiehe. Tab koetjh dien baad toelog hamme phien dekhiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tab ekaatgo tjela log apane me poetjhe lagal: „Ekar matlab ka hai? Oe kaahe ke bole hai kie: ‘Thora dien auro tab toelog hamme na dekhiehe, tab koetjh dien baad toelog hamme phien dekhiehe’? Aur bhie: ‘Ham Pieta Parmeswar ke paas djaab’? ");
INSERT INTO hnsNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Thora dien’ ke matlab ka hai? Hamlog na samdjhiela kie oe kaun tjiedj ke biese me batia hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jiesoe djaan gail kie oelog koetjh maange hai poetjhe. Tab bolies: „Ka, toelog ie baat na samdjhe hai? ");
INSERT INTO hnsNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ham toelogse bataaila kie toelog tjhaatie piet-pietke roihe, bakie be-bieswaasie logan khoesie rahie. Toelogke doekh rahie, bakie oe doekh khoesiaalie me badal djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ekgo aurat ke djab larka paida howe hai, tab oke bahoet doekh aur piera oethe hai. Bakie djab larka paida hoi dja hai, tab oe piera bhoel dja hai aur bahoet khoesie hai kie oe ek naawa iensaan ke djanam deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Aisahie tohoelogse hoi. Abbe toelogke doekh hai, bakie djab ham toelogke phien dekhab tab toelog khoesiaalie me rahiehe. Aur ie khoesiaalie koi na tjhien paai. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tab toelogke djaroerie na rahie hamse koetjh maange ke. Ham toelogse sattje ke boliela kie toelog djab Pieta Parmeswar se koetjh mangiehe, tab oe hamaar naam se deiga. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ab talak toelog Parmeswar se koetjh na mangle hai hamaar naam se. Aise kariehe, tab mieliega aur toelogke khoesiaalie ekdam poera hoi djaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Oe bolies: „Ab talak ham baat topal-dhaapal bolat rahielie, bakie ek tem aaiga kie ham Pieta Parmeswar ke biese me toelogse kholke bataabe. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Oe same se toelog hamare naam se ose koetjh maang sakiehe, aur hamke djaroerie na rahie toelog khaatien maange ke. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Toelog hamme pjaar kare hai aur bieswaas kare hai kie ham Parmeswar lage se ailie hai. Ohie se oe toelogke bhie tjaahe hai aur toelog apane se ose koetjh maang sakiehe. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ham Pieta Parmeswar lage se doenia par ailie baatie. Aur ab ham doenia tjhorke phien Pieta Parmeswar ke paas djaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tab tjela log bolies: „Dekh, ab hamlog samdjhiela toe ka bole hai aur tor baat topal-dhaapal na hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ab hamlog djaaniela kie toe sab tjiedj djaane hai aur bhie kie hamlog ka maangiela poetjhe. Ohie se hamlog bieswaas kariela kie toe Parmeswar lage se aile baate.” ");
INSERT INTO hnsNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tab oe bolies: „Ka, toelog ab bieswaas kare hai? ");
INSERT INTO hnsNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Soen ham ka boliela. Ek tem aaiga aur ab aail hai kie toelog tjaaro alang bhaag djaihe. Toelog aapan aapan djagaha tjal djaihe aur hamme akel tjhor deihe. Tabbo ham akele na rahab, Pieta Parmeswar hamare saath hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Toelog hamare me saamiel baate. Aur ham maangiela kie ekare dwaara toelogke diel me sjaantie rahie. Ohie se ham toelogse ie sab baat aage se bataaila. Be-bieswaasie log toelogke bahoet moesiebat deiga. Bakie hiemmat na hariehe. Dje doenia par manai log se boeraai karwaawe hai, ham oke djiet tjoekalie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Djab Jiesoe batiaai tjoekal raha tab oeppar taakke praatna kare lagal. Oe bolies: „Pieta djie, ab tem aai gail hai dekhaawe khaatien kie tor Beta ketana maahaan hai djeme oe aapke maahaanta dekhaai sakie. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Aap oke sab manai ke oeppar hoekoem deile hai. Aur djaun log ke aap oke sauple hai, aap oke bhie saktie deile hai oesabke sattja djiewan dewe ke sada ke lieje. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sattja djiewan ke matlab hai kie manai logan aapke djaane hai aur bhie Jiesoe Kriest ke. Aap to ekahie sattja Parmeswar baate aur Jiesoe Kriest ke pathaawe Waala. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aap hamke ek kaam deile rahiele kare ke aur ham ekdam se poera karlie hai. Aise karke ham dhartie par dekhailie kie aap ketana maahaan baate. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pieta djie, doenia howe se pahiele ham aapke lage bahoet maahaan rahielie, aur ab hamme aap ke lage oe maahaanta phien se dei deiho. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Aap doenia par koetjh manai ke alag karke hamke saathie ghat deile rahiele, aur ham oelogke dekhailie kie aapke naam ketana barka hai. Oesab aapke raha, aur aap oesabke hamme saup deile. Oesab aapke baat apanaais hai, ");
INSERT INTO hnsNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","aur ab oesab djaane hai kie hamaar sab tjiedj aapke or se aawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Aap hamse aapan baat bataile hai aur ham oelogse batailie. Tab oesab aapke baat apanaais hai. Oelog bieswaas kare hai kie ham aapke lage se ailie hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ham ohielog khaat praatna kariela. Ham be-bieswaasie logan khaatien praatna na kariela, bakie oelog khaatien djaun ke aap hamke saup deile hai. Oelog to aapke hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Hamaar waalan aapke hai aur aapke waalan hamaar hai. Oelogke djiewan me dekha hai kie ham ketana maahaan baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ham doenia par na rahabe. Ham aapke paas aabe, bakie oesab doenia par rahie djaai. Pawietr Pieta djie, hamaar saupal waalan aapan naam ke saktie se rakhwaala karieho djeme oelog apane apane me ek rahe djaise hamlog bhie baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Djab lek ham oesabke saath rahielie, tab lek ham oesabke aapke naam ke saktie se rakhwaala karat rahielie aur ekgo tjhorke koi na barbaad bhail. Oe aadmie sada ke lieje barbaad hoi tjoekal raha. Aisahie tor liekhal baat poera bhail. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ab ham aapke paas aabe. Ham maangiela kie oesab hamaar khoesiaalie me poera taur se bhaag lewe. Ohie se ham ie baat boliela djab ham abbe doenia par baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ham oesabke aapke baat batailie hai, aur be-bieswaasie logan oelogke dekhke djare hai. Oelog to be-bieswaasie log me saamiel na hai djaise ham bhie na baatie. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ham na praatna kariela kie aap oesabke doenia par se hataai leihe, bakie kie aap oesabke rakhwaala kariehe djeme saitaan oelogke na bahakaawe. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Djaise ham be-bieswaasie log me saamiel na baatie, aise ohoelog oesab me saamiel na hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Aapke baat sattjaai hai aur aapan sattjaai dwaara oelogke apane khaatien alag kar deiho. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Aur djaise aap hamke doenia me pathaile rahiele, oisane ham oelogke bhie pathaabe. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ham oelogke khaatien aapan djaan debe djeme oesab sattjaai dwaara aapke khaatien alag karal djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ham na khaalie aapan hia ke tjela log khaatien praatna kariela. Bakie oelog khaat bhie djaun iesabke baat dwaara hamare me bieswaas kariega. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Pieta djie, oelogke ek kar de, djaise aap hamse aur ham aapse ek baatie. Aisan kariehe kie oelog hamlogse bhie ek rahe. Tab be-bieswaasie log ie dekhke bieswaas karie kie aap hamme pathaile baate. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Djaun maahaanta aap hamke deile hai, ohie ham oesabke deilie hai, djeme oelog bhie apane me ek rahe djaise ham aur aap. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tab ham oelogse ek rahabe aur aap hamse. Ie rakam se oesab poera taur se ek rahie. Tab doenia djaan djaai kie aap hamme pathaile rahiele aur kie aap oesabke otane tjaahe hai aap djetana hamke tjaahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Pieta djie, aap oesabke hamaar oeppar saup deile. Aur ham maangiela kie ohoesab hoewa rahe djaaha ham rahabe, tab oesab hamaar biesaal maahaanta dekh sakiega. Aap to doenia howe se pahiele hamme tjaahat rahiele, ohie se aap hamme etana biesaal maahaanta deile hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pieta djie, aap to sattja Waala baate. Doenia ke manai log aapke na djaane hai, bakie ham aapke djaaniela. Aur hamaar hia ke tjela log djaane hai kie aap hamme pathaile hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ham oelogse bata deilie kie aapke naam ketana barka hai, aur ham bataite rahabe djeme oelog etana pjaar kare djaise aap hamke pjaar kare hai. Aur ham oesabke diel me rahabe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Djab Jiesoe praatna kar tjoekal raha tab aapan tjela log ke saath bahare gail aur Kiedron nadie ke habara bhail. Hoewa dher phal ke per ke djagaha raha aur oesab hoewa gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jiesoe aur okar tjela log hoewa hardam djaat raha, ohie se tjoegalkhor Joedaas oe djagaha bhie djaanat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tab Joedaas ek djhoend soerdjaatie aur barka agwan ke siepaahie aur Fariesie log ke kamkartan ke leike hoewa bhie gail. Oelog apane saath tjieraag, loekaara aur hathiaar leis raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jiesoe djaanat raha kie okare saath ka hoi aur oelogke lage djaaike poetjhies: „Toelog ke ke khodje hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tab oelog bolies: „Naasaaret ke Jiesoe ke.” Tab oe bolies: „Ham baatie.” Tjoegalkhor Joedaas oelogke saath thara raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Djab Jiesoe bolies kie: „Ham baatie,” tab oesab tjaukke patjharke djamien par gier gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tab oe phien poetjhies: „Toelog ke ke khodje hai?” Tab oesab doesara dafe bolies: „Naasaaret ke Jiesoe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tab bolies: „Ham toelogse bollie kie ham baatie. Djab toelog maange hai hamme pakare, tab hamaar tjela log ke djaain de.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aisahie okar baat poera bhail. Oe to aapan Baap se bolies raha kie: „Dje ke aap hamme saup deile rahiele, ham oesabke rakhwaala karlie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Etane me Siemon Petras aapan talwaar oethaaike ek manai ke dahiena kaan kaatke niekaar leis. Oe aadmie sab se barka agwa ke goelaam raha aur okar naam Malkas raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Bakie Jiesoe Petras se bolies: „Na kar, oe talwaar dhar de. Toe sotje hai kie ham aane waala doekh tjhorke maangiela bhaage? Pieta Parmeswar to maange hai kie ham ie doekh sahie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tab soerdjaatie log aur oesabke barkwa aur Israel ke dharam ke barkwan ke rakhwaalan oke pakarke aur haath baanh deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tab oesab pahiele oke Aanaas naam ke barka agwa lage legail. Aanaas Kaajaafas ke sasoer raha. Aur oe tem par Kaajaafas sab se barka agwa raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ohie dharam waalan se pahiele bolies raha kie: „Bestar rahie kie ek djane mare aur na sab djanta naas howe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Siemon Petras aur ek doesar tjela Jiesoe ke paatjhe gail. Oe tjela sab se barka agwa ke djaanat raha. Ohie se oe agwa ke mahal ke angana me bhie gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bakie Petras bahare phaatak lage khara raha. Tab ekwa tjela bahare aaike phaatak ke rakhwaalie se batiaais. Tab aurat Petras ke bhiettar aawan deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tab ose poetjhies kie: „Toe to bhie ie aadmie ke tjela baate?” Bakie Petras bolies: „Na, ham na baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Oe same thandha raha, ohie se oesab koila se aagie baaries raha. Hoewa goelaam aur siepaahie log ekattha raha apane ke garam kare khaatien. Tab Petras oesabke lage bhie gail apane ke garam kare khaat. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bhiettar me sab se barka agwa Jiesoe se poetjhe lagal okar tjela aur partjaar ke biese me. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Bakie Jiesoe bolies: „Ham hardam sab koi se kholke partjaar karat rahielie. Partjaar ke ghar aur Parmeswar ke mahal ke angana me manai logan ekattha howe hai, aur hoewa ham hardam siekhaawat rahielie. Ham kabhie na tjoeppe se koetjh bollie. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tab toe kaahe ke hamse poetjhe hai? Sab koi se poetjh kie ham ka bataawat rahielie. Oesab djaane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tab hoewa ke ekgo rakhwaala okar moeh par maaries aur bolies: „Ehie kaida hai sab se barka agwa se batiaai ke?” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tab oe bolies: „Djab ham koetjh oelta se bollie tab hamse bataaw. Bakie djab ham satj baat boliela tab toe hamme kaahe ke maare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tab Aanaas oke baanhal haath se Kaajaafas ke lage pathaais. Oe sab se barka agwa raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Siemon Petras angana me apane ke aagie lage garmaawat raha. Tab etane me koi koi ose poetjhies kie: „Toe to bhie okar tjela baate?” Tab oe bolies: „Na, ham na baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Hoewa par bhie sab se barka agwa ke ekgo goelaam raha djekar palwaar ke kaan Petras kaat deis raha. Tab oe aadmie ose bolies kie: „Ham toke to hoewa par dekhlie djaaha oe pakaraail hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bakie oe phien se nahakaaries. Bas toerante moerga bole lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Sabere sabere oesab Jiesoe ke Kaajaafas ke mahal me se legail Roma laat ke mahal lage. Bakie oesab bhiettar na gail. Oelog djab ekgo Roma djaat ke ghar me djaat tab safa na rahat aur Paasan ke tiewhaar ke bhodjan na khaai sakat. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ohie se laat bahare aail. Okar naam Pielaatas raha. Tab oe poetjhies: „Ie aadmie ka karies hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tab oesab bolies: „Djab ie koetjh kharaabie na kare rahat tab hamlog oke tore paas na laitie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tab laat bolies: „Oke ledja. Toelogke to apane kaanoen hai. Oke toelog sadja dei de.” Tab dharam ke barkwan bolies: „Roma ke maahaaraadja hamlogke hoekoem na deis hai koi ke maar dhaare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Aisahie Jiesoe ke baat poera bhail. Oe to bolies raha kie oe kaun rakam se maar dhaaral djaai. ");
INSERT INTO hnsNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tab laat bhiettar gail aur Jiesoe ke apane lage bolwaaike poetjhies: „Tohie Israel ke djaatie ke raadja baate?” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tab Jiesoe poetjhies: „Toe sattje ke maange hai djaane, kie tose doesar log bolies hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tab oe bolies: „Ham Israel ke djaatie ke thoro baatie? Toke tor djaat ke barka agwan hamare paas laais hai.” Oe poetjhies: „Toe ka karle hai?” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tab Jiesoe bolies: „Hamaar raadj doenia waala ghat na hai. Djab aisan rahat tab hamaar rakhwaalan laraai karke hamme barkwan ke haath me se batjaai lewat. Bakie hamaar raadj doesar rakam hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tab oe poetjhies: „Toe tabbo ekgo raadja baate?” Tab Jiesoe bolies: „Tor baat satj hai. Hamaar kaam hai sattjaai ke biese me gawaahie dewe ke. Ohie khaatien ham paida bhailie hai, aur ie kaam poera kare khaat ham doenia me ailie hai. Djab koi sattjaai maange hai djaane, tab oe hamaar baat soene hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tab oe bolies: „Are, ke djaane hai kie sattjaai ka hai?” Ie baat bolke oe bahare gail aur Israel ke barkwan se bolies: „Hamare dekhe me oe be-kasoer hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Oe bolies: „Soen, toelog djaane hai kie Paasan ke tiewhaar me ham koi ke tjhoriela. Toelog ka maange hai, ham Israel ke raadja ke tjhor dei?” ");
INSERT INTO hnsNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tab oesab tjiellaai lagal aur bolies: „Na! Oke na! Baaraabaas ke tjhoriehe!” Baaraabaas ek daakoe raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tab laat Jiesoe ke tjamotie se piethie par khoeb pietwaais. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tab soerdjaatie log kaata waala lattie goethke okare moerie par raadja ke moekoet ghat rakh deis aur oke ekgo laal koerta raadja ghat pahienaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tab oesab tiebolie maarke bolies: „Israel ke raadja ke parnaam.” Tab bolke okar moeh par maaries. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tab laat phien bahare aaike dharam ke barkwan se bolies: „Ham oke toelogke aage laaila dekhaawe ke kie oe hamare dekhe me be-kasoer hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jiesoe bahare aail laal koerta pahienke, aur okar moerie par goethal waala kaata raha. Tab laat bolies: „Dekh to oke.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tab djab barka agwan aur oelogke rakhwaalan oke dekhies tab tjiellaaike bole lagal: „Oke kroes par tjaharaai de! Kroes par tjaharaai de!” Tab laat bolies: „Tab toelog apane dja oke latkaai de. Hamare dekhe me ie be-kasoer hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bakie barkwan bolies: „Hamlogke kaanoen me liekhal hai kie aisan aadmie ke tjaahie marwaai dhaare ke. Oe bolies hai kie oe Parmeswar ke Beta hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tab ie baat par laat auro deraai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Oe phien se aapan mahal me gail aur Jiesoe se poetjhies: „Toe kaaha se aile hai?” Bakie Jiesoe oke djabaab na deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tab laat bolies: „Toe hamse koetjh na maange hai bole? Toe na djaane hai kie hamke saktie hai toke tjhore ke aur bhie toke kroes par latkaawe ke?” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tab Jiesoe bolies: „Toe hamare par tanko hoekoem na tjalaai sakte djab oeppar Waala toke na dewat. Bakie djaun manai hamke tore haath me saup deis hai, oke auro kasoer hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Oe same se laat auro kausies kare lagal oke tjhore ke. Bakie dharam ke barkwan tjiellaaike bolies: „Ie aadmie apane ke raadja banaaike maahaaraadja ke to djabarai kare hai. Aur djab toe oke tjhor deihe tab dekhaai djaai kie toe maahaaraadja ke saathie na baate.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tab laat ie baat soenke Jiesoe ke bahare bolwaais. Tab oe djaaike aapan djadj ke koersie par baithal. Oe koersie ieta ke djamien par dharal raha. Oe djagaha ke naam Lietostrotos raha, aur Israel ke bhaasa me „‘Gabata”’ bolaawal djaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Oe dien sab Israel logan tajaar karies raat me Paasan ke tiewhaar manaawe ke. Oe tem par lagbhag baara badjal raha. Tab laat dharam ke barkwan se bolies kie: „Aapan raadja ke dekh.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tab oesab tjiellaaike bolies: „Maar dhaar! Maar dhaar! Oke kroes par tjaharaai de!” Tab oe poetjhies: „Ka, toelog maange hai kie ham toelogke raadja ke kroes par marwaai dei?” Tab barka agwan bolies: „Hamlogke raadja na hai, khaalie Roma ke maahaaraadja!” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tab laat Jiesoe ke oesabke hawaale kar deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tab soerdjaatie log Jiesoe ke legail. Oe apane kroes ke khambha kandha par ledjaat raha. Oesab „‘Khoprie”’ naam ke djagaha par gail. Israel ke bhaasa me „‘Golgota”’ bolaawal dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hoewa par oelog oke kroes par thokke taang deis. Oesab doeigo doesar aadmie ke okar agal-bagal ek ek kroes par bhie tjaharaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Laat Jiesoe ke kroes par liekhwaais raha: NAASAARET KE JIESOE, OE ISRAEL KE RAADJA HAI. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jiesoe sahar ke nagietj tjaharaawal raha, ohie se dher manai log ie baat parhat raha. Ie baat Israel ke bhaasa me aur bhie Latijn aur Griek ke bhaasa me liekhal raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Djab barka agwan parhies tab oesab djaaike laat se bolies: „Na tjaahie liekhal rahe ke: ‘Oe Israel ke raadja hai,’ bakie kie oe aise bolies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tab laat bolies: „Djaise hai, oisahie tjhor de.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tab djab soerdjaatie log Jiesoe ke thokke taang tjoekal raha, tab okar kapra leike tjaar hiessa me baat leis. Ek kapra biena sian ke raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tab oelog apane me bolies: „Oke na phaar, aisahie tjhor de. Laaw hamlog djoewa khel lei dja.” Aur aisahie oesab karies. Ie rakam se Parmeswar ke liekhal baat poera bhail. Okar poestak me liekhal hai kie: „Oesab hamaar kapra apane me baat leis, aur hamaar kapra khaatien djoewa khelies.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jiesoe ke kroes lage okar maai, mausie, Klopaas ke aurat Maria, aur bhie Magdaala ke Maria thara raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tab Jiesoe djab aapan maai ke dekhies aur aapan pjaara tjela ke bhie, tab aapan maai se bolies: „Ma, dekh, ab oe tor beta hai.” Aur aapan tjela se bolies: „Dekh, ab oe tor maai hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tab oe dien se oe tjela Jiesoe ke maai ke aapan maai ghat apane ghar me leis. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jiesoe djaanies kie ab doenia me okar sab kaam poera hoi gail hai. Ohie se oe Parmeswar ke liekhal baat poera karke bolies: „Hamme piaas lagal hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hoewa par ekgo gogliet me khatta wien rakhal raha. Tab koi koetjh leike aur wien me bhiedjaaike ek hiesop ke daarhie par badjhaaike oke piaais. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tab djab oe pie tjoekal raha tab bolies: „Ab sab poera hoi gail!” Tab moerie djhoekaaike oe aapan praan tjhor deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Oe raat me sabat howat aur sab Israel logan tajaarie karat raha Paasan ke tiewhaar manaawe ke. Dharam ke barkwan na maangat raha kie oe tieno sabat ke dien par taangal rahe. Oe sabat ek barka dien raha. Ohie se oesab laat se poetjhies oesabke gor toere ke djeme oesab auro haalie se mar djaai. Tab oelog sabat howe se pahiele lahaas ke kroes par se oetaar sakat. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tab soerdjaatie log ekwan ke lage gail aur maarke oesabke gor toer deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bakie djab Jiesoe ke lage aail tab oesab dekhies kie oe mar gail hai, aur oesab okar gor na toeries. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tab ekgo soerdjaatie dhanoes leike okar padjarie me bhokies. Aur toerante khoen aur paanie niekare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ham Johaanas baatie aur ham ie sab tjiedj dekhlie. Hamaar gawaahie ekdam satj hai aur ham djaaniela kie ham djhoeth na boliela. Ham to maangiela kie toelog bhie Jiesoe me bieswaas kar. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ie sab kaam ie rakam se bhail hai djeme Parmeswar ke liekhal baat poera howe. Oe liekhwaais raha kie: „Okar ekko haddie na toeral djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aur bhie: „Oesab oke taakie dje ke oesab bhokies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ekgo Josaf naam ke aadmie raha. Oe Aariematea sahar ke raha. Oe Jiesoe ke tjela raha, bakie oe koi se na bolies raha. Oe Israel ke barkwan ke deraat raha. Tab oe djaaike laat Pielaatas se poetjhies kie oe Jiesoe ke lahaas lei sake hai. Tab laat bolies: „Ha, ledja.” Josaf tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Aur Niekodemas sanghe bhie gail. Oe koetjh dien pahiele raat ke Jiesoe ke lage gail raha baat-tjiet kare khaatien. Ab oe Jiesoe ke mattie khaat lagbhag ties kilo mere aur aaloewe ke mahakauwa laais raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Oe doeno Jiesoe ke lahaas kroes par se oetaarke aur dawaai dharke kapphan me lapet deis. Israel log aise mattie dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Djaaha Jiesoe kroes par tjaharaawal raha, hoewa dher per ke djagaha raha. Aur hoewa ekgo naawa kabar pahaar me banaawal raha djaise ekgo tjhota kothrie. Oman abbe ekko moerda na dharaan raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ekaat ghanta auro tab sabat ke dien rahat aur kabar nagietj raha, ohie se oesab Jiesoe ke oman dhar deis. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tab hapta ke pahiela rodj sabere sabere Magdaala sahar ke Maria kabar lage gail. Abbe andhiaar raha. Aur djab oe pahoetjal tab dekhe hai kie kabar ke aage ke ieta hataawal hai! ");
INSERT INTO hnsNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tab haalie se dhaurke Siemon Petras aur Jiesoe ke pjaara tjela ke lage gail aur bolies: „Koi Prabhoe ke kabar me se niekaas leis! Aur hamlog na djaaniela oesab oke kaaha dharies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tab Petras aur ekwa tjela gail dekhe. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Doeno haalie haalie tjalat raha, bakie ekwa Petras se aur haalie dhaural. Oe sab se pahiele kabar lage pahoetjal. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tab djab oe niehoerke taakies tab khaalie kapphan dekhies. Bakie oe bhiettar na gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tab okare patjhwe Siemon Petras bhie aail aur kabar me gail. Ohoe khaalie kapphan dekhies, ");
INSERT INTO hnsNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","aur bhie dekhies kie moerie ke pattie doesar kapra lage na hai, bakie lapetke alag dharal hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tab ekwa bhie bhiettar gail. Tab sab tjiedj dekhke oe bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Aisane Parmeswar ke poestak me liekhal raha, bakie oelog ie baat na samdjhat raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tab oesab lautke ghare tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria kabar ke bahare thara hoike rowat raha. Tab roite niehoerke kabar me taakies ");
INSERT INTO hnsNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","aur dekhe hai doeigo swarag ke parie oeddjar kapra me baithal hai. Ekgo moerwaarie aur ekgo gorwaarie baithal raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tab oesab poetjhies: „Bahien, toe kaahe ke rowe hai?” Tab Maria bolies: „Koi hamaar Prabhoe ke legail aur ham na djaaniela oesab oke kaaha dharies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Etane me oe ghoemke dekhies kie koi hoewa thara hai. Bakie oe na djaanies kie Jiesoe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tab Jiesoe poetjhies: „Bahien, toe kaahe ke rowe hai? Toe ke ke khodje hai?” Maria sotjies kie oe djagaha ke dekh-bhaal kare waala hai aur bolies: „Bhaai, djab toe oke legaile hoihe, tab bataai de kie oke kaaha dharle. Tab ham oke liaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tab oe bolies: „Maria.” Tab Maria ghoemke aapan bhaasa me bolies: „Raboenie!” Ekar matlab hai: „‘Maastar djie!”’ ");
INSERT INTO hnsNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Tab oe bolies: „Hamaar gor na pakar. Ham aapan Baap ke paas abbe na gailie hai. Dja hamaar bieswaasie bhaai log ke paas aur oesabse bataai de kie ham halieje aapan Baap ke paas oeppar djaabe. Oe toelogke Baap bhie hai. Ham aapan Parmeswar ke paas oeppar djaab. Oe tohoelogke Parmeswar hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria gail tjela log se bataawe kie oe Prabhoe ke dekhies hai aur oe ka bolies hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ohie etwaar ke raat me tjela log ekattha baithal raha. Oelog dharam ke barkwan ke deraat raha, ohie se oesab kamaarie band kar deis raha. Tab Jiesoe aaike oesabke bietj me thara bhail! Oe bolies: „Sjaantie se rahoe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aur oe aapan haath aur padjarie dekhaais. Tab oelog oke dekhke etana khoesie bhail! ");
INSERT INTO hnsNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tab oe phien se bolies: „Sjaantie se rahoe. Djaise hamaar Baap hamme pathaais raha, oisahie ham toelogke bhie pathaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ie baat bolke oe oelogke oeppar phoekke bolies: „Pawietr Aatma ke apana le. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Djab toelog koi ke boeraai maaf kar deihe, tab oe be-kasoer hoi djaai. Aur djab toelog maaf na kariehe, tab oe kasoerwaar rahie djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jiesoe ke baara tjela me se ekgo ke naam Tomaas raha. Oe bhie „‘djorwa”’ bolaawal djaat raha. Djab Jiesoe apane ke dekhaais raha tab Tomaas oesabke sanghe na raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tab oesab ose bolies: „Hamlog Prabhoe ke dekhlie hai!” Bakie oe bolies: „Djab lek ham khiella ke tjienha okar haath par na dekhke tjhoebe, aur djab lek ham aapan haath se okar padjarie ke tjienha na tjhoei sakab, tab talak ham na bieswaas karab.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ek hapta baad tjela log phien ohie ghar me ekattha baithal raha. Tomaas bhie oelogke saath raha, aur sab kamaarie band raha. Tab Jiesoe phien aaike oelogke bietj me thara bhail aur bolies: „Sjaantie se rahoe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Aur Tomaas se bolies: „Hamaar haath taak aur aapan oengrie se tjhoew. Aapan haath lapkaaw aur hamaar padjarie par dhar. Aur ab se toe be-bieswaasie na rahoe bakie bieswaas kar.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tab Tomaas bolies: „Aap hamaar Prabhoe aur hamaar Parmeswar baato!” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tab oe bolies: „Hamme dekhke toke bieswaas paral. Aur ketana soekh me oelog rahie djaun biena hamme dekhe bieswaas karie.” ");
INSERT INTO hnsNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jiesoe aapan tjela ke aakhie ke saamne auro barka kaam karies hai, bakie ie poestak me sab na liekhal hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ie liekhaail hai djeme toelog bieswaas kariehe kie Jiesoe Parmeswar ke Kriest aur okar Beta hai. Aur ie baat bieswaas kare se toelog okar naam ke saktie dwaara sattja djiewan bietaai sakiehe. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ekare baad djab tjela log Tieberias samoendar ke lage raha tab Jiesoe apane ke phien se dekhaais. Ie sab aise bhail: ");
INSERT INTO hnsNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siemon Petras, djorwa Tomaas, Gaalielea sahar Kaana ke Naataanaajel aur Sebedeas ke doeigo betwan aur doeigo doesar tjela bhie hoewa raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tab Siemon Petras ekwan se bolies: „Ham djaaila matjharie maare.” Tab ekwan bolies: „Attjha, hamahoelog tjalab.” Oelog bot me tjal gail. Bakie oe raat me oesab koetjh na pakaries. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Djab andjor howe lagal tab Jiesoe samoendar ke kienaare thara raha, bakie tjela log oke na tjienhies. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tab oe djor se bolies: „E bhaai log, toelogke koetjh khaaik hai?” Tab oesab bolies: „Na, koetjh na.” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tab oe bolies: „Djaal dahiena bagal bieg, tab toelog koetjh matjharie paihe.” Oesab oisane karies aur etana matjharie djaal me aail kie oesab hietjke bot me na laai paais! ");
INSERT INTO hnsNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tab Jiesoe ke pjaara tjela Petras se bolies: „Oe to Prabhoe hai!” Djab Siemon Petras ie baat soenies tab haalie se kapra pahienke paanie me koed gail. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ekwa tjela log bot se kienaare gail aur matjharie ke djaal hietjat laail. Oesab lagbhag ek sau meter kienaare se raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Djab oesab bot me se niekaral tab dekhies kie hoewa matjharie aur bret koila ke aagie ke oeppar hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tab Jiesoe bolies: „Ekaat matjharie laaw.” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Siemon Petras bot me gail aur djaal kienaare ghaitjies. Oman ek sau tierpan (153) barka matjharie raha, aur tabbo djaal na phaatal raha. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tab Jiesoe bolies: „Aaw, toelog kha le.” Ekko tjela na poetjhies kie: „Toe ke baate?” Oesab djaanat raha kie oe Prabhoe hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tab oe bret aur matjharie leike sabke baaties. Aur oesabhan bhodjan karies. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ie tiesara dafe raha kie Jiesoe maral logan me se djie oethe ke baad apane ke aapan tjela log ke dekhaais. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tab djab oesab khaai tjoekal raha tab Jiesoe Siemon Petras se poetjhies: „Johaanas ke beta Siemon, toe hamme sattje ke tjaahe hai, ekwan se djaada?” Tab Petras bolies: „Prabhoe, toe djaane hai kie ham toke pjaar kariela.” Tab Jiesoe bolies: „Tab hamaar bhera ke battjan ke tjaraihe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aur oe phien se poetjhies: „Johaanas ke beta Siemon, toe hamme sattje ke tjaahe hai?” Tab Petras bolies: „Djie ha, Prabhoe, toe djaane hai kie ham toke pjaar kariela.” Tab oe bolies: „Tab hamaar bherwan ke dekh-bhaal kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ekare baad oe tiesara dafe poetjhies kie: „Johaanas ke beta Siemon, toe hamme pjaar kare hai?” Djab Jiesoe tiesara dafe ie baat poetjhies tab Petras ke doekh bhail aur bolies: „Prabhoe djie, toe sab tjiedj djaane hai. Toe djaane hai kie ham toke pjaar kariela.” Tab oe bolies: „Tab hamaar bherwan ke tjaraihe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Oe bhie bolies: „Soen, ham tose sattje ke boliela kie djab toe djawaan rahiele tab aapan gor par thara rahiele aur aapan rasta djaat rahiele. Bakie djab toe boerhwa hoi djaihe tab toke aapan man waala tjhore ke parie. Doesar koi toke kapra pahienaai aur aisan djagaha ledjaai djaaha toe na djaai mangiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ie baat se oe aagam se bataais Petras kaise maar dhaaral djaai dekhaawe khaatien kie Parmeswar ketana maahaan hai. Oe bhie bolies: „Hamaar rasta par tjalte rahoe.” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tab Petras ghoemke dekhies kie Jiesoe ke pjaara tjela bhie aawe hai. Ohie Paasan ke bhodjan ke same Jiesoe ke lage satke poetjhies raha: „Prabhoe djie, toke ke tjoegalie kariega?” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Djab Petras oke dekhies, tab Jiesoe se poetjhies: „Prabhoe djie, okare saath ka hoi?” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tab oe bolies: „Djab ham maangiela kie oe djieje djab talak ham na lautke aabe, tab oe hamaar kaam hai. Toe khaalie hamare saath tjal.” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ekare baad iesaai bhaai log apane me ie baat dwaara sotje lagal kie ie tjela na marie. Bakie Jiesoe aise na bolies raha. Oe khaalie bolies raha kie: „Djab ham maangiela kie oe djieje djab talak ham na lautke aabe, tab oe hamaar kaam hai.” ");
INSERT INTO hnsNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ehie tjela sab tjiedj dekhke ie poestak me liekhies hai. Aur hamlog djaaniela kie okar baat satj hai. ");
INSERT INTO hnsNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jiesoe bahoet auro kaam karies hai. Bakie djab har ek tjiedj liekhaat tab hamare djaan me doenia par djagaha na rahat ie sab poestak dhare khaatien.");
INSERT INTO hnsNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Bhaai Teofielas djie, Ham aapan pahiela poestak me Jiesoe ke sab kaam aur partjaar ke biese me liekhlie hai. Ham sab liekhlie hai okar kaam ke soeroe se oe dien talak djab oe swarag me lei lewal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Djaai se pahiele oe aapan pathaawal waalan ke Pawietr Aatma dwaara bolies raha kaise Parmeswar ke kaam kare ke tjaahat raha. Oe to oesabke tjoenies raha aur oe kaam oesabke oeppar saup deis raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Djab oe djie oethal raha, tab oe tjaalies rodj apane ke dekhaais aur bhie sab rakam tjienha se dekhaais kie oe sattje ke djieje hai. Aur oe bhie Parmeswar ke aane waala raadj ke biese me sab tjiedj bataais raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tab ek dien djab Jiesoe oesabke sanghe bhodjan karat raha, tab bolies: „Ham toelogse Pieta Parmeswar ke waada ke biese me batailie hai. Toelog Jeroesaalem sahar me agoriehe djab talak ie waada na poera hoi. Ohie se sahar tjhorke na djaihe. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ab dher dien na rahie gail hai kie toelog Pawietr Aatma se dopoe karal djaihe. Johaanas paanie se dopoe karat raha, bakie ham toelogke Pawietr Aatma se dopoe karab.” ");
INSERT INTO hnsNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ek dien djab Jiesoe phien aapan tjela log ke sanghe raha, tab oesab poetjhies: „Prabhoe djie, aap ab Israel ke raadja banieho?” ");
INSERT INTO hnsNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tab oe bolies: „Toelogke ie djaane ke kaam na hai. Ie Pieta Parmeswar ke haath me hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bakie djab Pawietr Aatma toelogke oeppar aai, tab toelogke saktie mieliega hamaar baare me gawaahie dewe ke. Tab toelog Jeroesaalem sahar me, Joedea aur Saamaaria diehaat bhar me, aur doenia ke tjaaro kona talak partjaar kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tab djab oe batiaai tjoekal raha, tab tjela log dekhies kie Jiesoe oeppar dja hai. Bas ek toekkara baadar oke aar kar leis aur oesab oke na dekh paais. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tab djab oesab oeppar takte raha, tab atjakke me doeigo aadmie oeddjar kapra pahienke oesabke paas thara hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Oesab bolies: „Gaalielea diehaat waalan, toelog kaahe ke oeppar taake hai? Jiesoe toelogke bietj me se swarag me lewal gail hai. Djaise toelog oke swarag ke or djaat dekhle, oisane oe phien lautke aaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tab tjela logan Djaitoen pahaar se Jeroesaalem sahar lautal. Oe pahaar sahar se doer na hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tab djab oesab sahar me pahoetjal, tab oeppar kamra me gail djaaha oelog rahat raha. Oesab Petras, Johaanas, Jaakobas, Andreas, Fielepas, Tomaas, Baartolomeas, Mateas, Alfeas ke beta Jaakobas, Siemon kamaasoet waala, aur Jaakobas ke beta Joedaas raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Oesab ekattha hoike hardam praatna karat raha. Oelogke sanghe koetjh aurat aur Jiesoe ke maai aur okar bhaai log bhie raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ek dien lagbhag ek sau bies bieswaasie log ekattha bhail raha. Tab Petras thara bhail aur ");
INSERT INTO hnsNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","bolies: „Bhaai aur bahien, pahiele Pawietr Aatma Daawied dwaara koetjh baat Joedaas ke biese me liekhwaais raha aur ab oe baat poera hoi gail hai. Oe pathaawal waalan me se ekgo raha. Parmeswar oke aur hamlogke ekahie kaam deis raha. Bakie oe Jiesoe ke doesman logan ke dekhaais oesab oke kaaha pakar sakat. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Oke ie kharaab kaam khaatien koetjh paisa mielal aur oe paisa se ek toekkara djamien kienaail raha. Aur oe phaasie lagaaike nietje gieral aur pet phaatke okar attrie niekas gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ie baat Jeroesaalem bhar ke pata miel gail. Tab oesab aapan bhaasa me oe djamien ke ‘Aakeldaama’ bolaais. Ekar matlab hai: ‘Khoen ke djamien.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Aisane to Parmeswar aapan gaana ke poestak me liekhwaais hai kie: ‘Okar ghar-dwaar ekdam se bielaai djaain deihe aur hoewa par koi na rahiega.’ Aur oe bhie liekhwaais hai kie: ‘Okar kaam ab doesar koi ke tjaahie kare ke.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ohie khaatien hamlog koi ke khodjab djaun hamlog me saamiel rahat raha oe dien se djab Jiesoe dopoe bhail djab talak oe swarag me na lewal gail. Tab oe hamlogke saath gawaahie dei sakie kie Jiesoe djie oethal hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tab oesab doei aadmie ke naam leis. Ekgo ke naam Josaf raha. Manai log oke bhie Baarsaabaas aur Jastas bolaawat raha. Ekwa Matiaas raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Tab oesab praatna karies kie: „Prabhoe djie, toe sab manai ke diel djaane hai. Aap hamlogke dekhaaw kaun waala ke tjoenle baate Joedaas ke darie par pathaawal waalan ke kaam kare khaatien. Oe to aapan kaam tjhorke ek djagaha gail sadja paawe khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tab oesab oe doeno ke naam se baadjie lagaais aur Matiaas tjoenal gail. Tab se oe gjaaraago pathaawal waalan me saamiel raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Djab Penkstar ke tiewhaar soeroe bhail, tab sab pathaawal waalan aur doesar tjela log saamiel raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bas atjakke me swarag me se koetjh djaise bahoet djabar hauwa ke aawaadj soenaail. Aur ghar aawaadj se bhar gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tab koetjh djaise toekkara toekkara aagie dekhaail. Oe batke har ek ke oeppar phail gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aur oesab Pawietr Aatma se bhar gail aur sab rakam ke bhaasa batiaai lagal djaise Aatma deis batiaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Oe same par dher bhaktie Israel logan doenia ke kona kona se Jeroesaalem me aail raha Penkstar ke tiewhaar manaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tab djab aawaadj soenaail, tab oesab oe ghar lage djoet gail. Aur djab soenies kie Jiesoe ke tjela log har ek bhaasa me batiaat raha, tab oesab bahoet tjakkariaai gail ");
INSERT INTO hnsNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","aur bole lagal kie: „Soen, oe manai to Gaalielea diehaat ke hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tab oesab kaise hamlogke har ek bhaasa batiaai paawe hai? ");
INSERT INTO hnsNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Hamlog tjaahe sab rakam des ke hai, tabbo oesabke baat samadjh paaila. Hamlog Partsia, Media, Elaam aur Mesopotaamia des se ailie baatie. Bhie Joedea, Kaapaadosia, Pontas, Aasia, ");
INSERT INTO hnsNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Friegia aur Pamfielia diehaat, Egypte aur Liebia des, Sierene sahar ke aas-paas, Kreta aur Aaraabia des se ailie hai, aur Roma sahar waalan hia bhie hai. Hamlogan Israel ke djaatie baatie aur doesar djaat me ke Parmeswar ke aadar kare waalan bhie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ie Gaalielea diehaat waalan har ek bhaasa me Parmeswar ke barka kaam ke biese me batia hai, aur sab koi oelogke baat samdjhe hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Manai log etana atjambho hoike na djaane kie ka sotje, aur bole lagal: „Ekar matlab ka hai?” ");
INSERT INTO hnsNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bakie koi koi tiebolie maarke bolies: „Oelog bahoet wien pies hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bas Petras gjaara pathaawal waalan sanghe oethke djor se batiaai lagal. Bolies: „Sab des ke aur Jeroesaalem ke Israel ke bhaai logan, dhiaan lagaaike soen. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ie manai log koetjh na pies hai, ab to sabere nau badjal hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Djaun hia bhail hai Parmeswar ke sanesia Jowel agwe se bolies raha kie: ");
INSERT INTO hnsNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Parmeswar bole hai: Ie djoeg ke ant me ham aapan Pawietr Aatma sab iensaan ke oeppar barsaai debe. Tab toelogke beta aur betie hamaar sanes bataaiga aur ham toelogke naudjawaan ke har ek rakam djaage ke sapana dekhaabe aur poeranian soetle me sapana dekhiega. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Oe tem me ham bhie aapan sab se nietja goelaam aur goelaam aurat ke oeppar aapan Pawietr Aatma barsaai debe. Tab oesab hamaar sanesian hoi djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ham aasmaan me atjambho kaam aur dhartie par tjienha dekhaabe djaise khoen, aagie aur djabar-djas waala dhoewa. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Prabhoe ke biesaal dien se pahiele ghaam andhiaar aur tjaan laal hoi djaai djaise khoen. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Bakie dje Prabhoe ke naam bolaaike sahaaita maangie, oe batj djaai.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Oe bolies: „Israel waalan, soen. Toelog thiek se djaane hai kie Parmeswar Naasaaret sahar ke Jiesoe ke pathaais raha. Oe okar dwaara dher maahaan atjambho kaam aur tjienha toelogke des me karwaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Oe agwe se djaanat raha aur okar bietjaar raha kie Jiesoe toelogke haath me saupal djaat aur kie toelog oke be-bieswaasie log ke dwaara kroes par marwaai dharte. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bakie Parmeswar oke djie oethaais hai. Oe to maut ke bandhan toeries hai. Na hoi sakat kie maut Jiesoe ke dher dien aapan bas me pakarat. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Daawied agwe se okar biese me bolies raha: ‘Ham raat aur dien Prabhoe ke jaad kariela. Oe hardam hamaar saath rahe hai djeme hamaar bieswaas tjhota na howe. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ohie se ham khoesiaalie se bharosa kariela kie tjaahe ham mar djaab, tabbo Parmeswar hamaar dehie barhia se rakhiega. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ham okar pawietr Waala baatie, ohie se oe hamme maral manai ke djagaha me na tjhoriega aur hamaar dehie na saran deiga. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Oe hamme rasta dekhaais sattja djiewan paawe khaatien, aur ham sada ke lieje bahoet khoesiaalie se okar sanghe rahab.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Oe bolies: „Bhaai logan, toelog to djaane hai kie hamlogke baap-daada Daawied mar gail aur okar mattie paral. Okar kabar abbe talak ie sahar me hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Oe Parmeswar ke ekgo sanesia raha aur oe djaanat raha kie Parmeswar oke kaun tjiedj kasam khaaike waada karies raha. Oe bolies raha kie: ‘Ham tor ek aulaad tor gaddie par baithaabe Israel ke djaat ke oeppar raadj tjalaawe khaatien.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daawied agahie se dekhat raha ka hoiga. Aur djab oe bolies ‘Parmeswar hamme maral manai ke djagaha me na tjhor deiga,’ aur bhie ‘Oe hamaar dehie na saran deiga,’ tab oe Kriest ke djie oethe ke biese me batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Oe baat Jiesoe ke biese me raha. Parmeswar oke djie oethaais hai aur hamlog ekare biese me gawaahie deila. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pieta Parmeswar oke sab se oetja dardja par aapan dahiena bagal baithaais hai. Tab oe aapan waada Pawietr Aatma ke biese me poera karies hai. Aur ab toelog dekh aur soen sake hai kie Jiesoe oe Aatma hamlogke oeppar barsaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daawied oeppar na gail hai. Bakie oe bolies kie: ‘Prabhoe Parmeswar hamaar Prabhoe se bataais hai: ");
INSERT INTO hnsNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Dja, toe hamaar dahiena bagal baith djab talak ham tor doesman log ke tore gor ke nietje na dharwaabe.’ Djab oe ie baat bolies, tab oe apane biese me na batiaat raha, bakie Jiesoe Kriest ke biese me. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ohie se ab sab Israel djaatie ke thiek se jaad kare ke tjaahie kie Parmeswar ie Jiesoe ke sab koi ke Prabhoe aur bhie aapan Kriest banaais hai. Aur toelog oke kroes par marwaai dharle hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bas djab oesab ie baat soenies, tab oesab diel bhar se djaan gail kie: „Ie baat satj hai aur hamlog ek kharaab kaam karlie hai!” Aur oesab Petras aur ekwan pathaawal waalan se poetjhies: „Bhaai logan, ab hamlog ka karie?” ");
INSERT INTO hnsNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tab Petras bolies: „Toelog aapan paap pastaaw aur ek naawa djiewan soeroe kar. Tab har ek apane ke Jiesoe Kriest ke naam me dopoe karwaai aur Parmeswar toelogke paap ke tjhama deiga. Tab oe aapan Pawietr Aatma toelogke oeppar barsaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ie okar waada hai, aur ie waada toelogke aur toelogke larkan khaatien hai, aur bhie sab doesar des ke djaatie log khaatien. Hamlogke Prabhoe Parmeswar to ohoesab me se bahoet manai log ke bolaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petras dher doesar baat se gawaahie dewat raha aur aapan soene waalan ke samdjhaawat raha. Oe bienaai karke oesabse bolies kie: „Apane ke ie tem ke manai ke kharaab tjaal-tjalan se batjaaw, nahie to toelog bhie sadja paihe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tab djetana djane oe dien Petras ke partjaar me bieswaas kare lagal, oesab apane ke dopoe karwaais. Lagbhag tien hadjaar manai raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Oesab pathaawal waalan ke siektjha par thiek se dhiaan lagaawat raha, oelog me bahoet soemmat raha, oesab hardam mielke bret toerat raha aur praatna karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sab Jeroesaalem ke manai djab pathaawal waalan ke dher atjambho kaam aur tjienha dekhies, tab oesabke diel me ieddjat barhal. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bieswaasie log me bahoet ekta raha aur oelog aapan sab tjiedj apane me baatke kaam me laawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Aur kabhie kabhie koi koetjh betjat raha aur dje ke djaroerat raha, oelogke oe paisa baat dewat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Oelog rodj ek bietjaar se Parmeswar ke mahal ke angana me ekattha howat raha. Aur aapan ghare mielke oesab bret toerat raha aur khoesiaalie se bhodjan karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Oesab rodj Parmeswar ke baraai karat raha aur sab Israel djaatie ke ieddjat bieswaasie log khaatien auro barhte gail. Aur rodj Prabhoe djaada manai ke paap me se batjaais. Aise auro manai log bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ek dien tien badje sandjha ke Petras aur Johaanas Parmeswar ke mahal me djaat raha. Oe same praatna ke djoen raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mahal ke ek dwaar lage ekgo aadmie baithal raha. Oe dwaar „‘Soendar Dwaar”’ bolaawal djaat raha. Aadmie paidaais se loendj raha, aur oke oethaaike rodj ledjaaike dhare ke parat raha. Dien bhar manai log mahal ke angana me aawat djaat raha, aur loendj oelogse bhiekhmaangat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aisane oe dien djab oe Petras aur Johaanas ke aawat dekhies, tab oelogse bhie koetjh maangies. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tab oesab oke khoeb thiek se taakke aur Petras bolies: „Hamlogke taak!” ");
INSERT INTO hnsNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Aadmie sotjies kie: „Abbe hamme koetjh mielie,” aur oesabke taakies. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tab Petras bolies: „Dekh, hamke sona tjaanie na hai, bakie djaun hamke hai, ham toke debe. Naasaaret sahar ke Jiesoe Kriest ke naam se toe oeth aur tjal.” ");
INSERT INTO hnsNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Tab okar dahiena haath pakarke oe oke sahaara karies thara howe khaatien. Bas toerante okar gor aur gaathie me aisan taagat aail kie oe koedke thara hoike tjale lagal. Tab oe Petras aur Johaanas ke sanghe mahal ke angana me gail aur khaalie koedat raha aur Parmeswar ke baraai karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Hoewa ke sab manai dekhies kie oe kaise tjale hai aur Parmeswar ke goen gaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Oesab oke tjienh gail kie oe hardam mahal ke „‘Soendar Dwaar”’ lage bhiekhmaangat raha, aur oesab bahoet tjakkariaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tab djab aadmie abbe Petras aur Johaanas ke sanghe raha, bas sab manai thak hoike oelogke gher leis. Oelog ekgo tjhaawal rasta par mahal ke angana me raha. Oe „‘raadja Saalomo ke rasta”’ bolaawal dja hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tab Petras bolies: „He Israel ke log, toelog kaahe ke etana atjambho hoi gaile hai? Aur kaahe ke hamlogke aise taake hai? Toelog thoro sotje hai kie hamlog eke aapan saktie aur bhaktie se attjha karlie hai? ");
INSERT INTO hnsNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Na, hamlogke baap-daada Aabraaham, Iesaak aur Jaakob ke Parmeswar aapan sewak Jiesoe ke bahoet barka ieddjat karies hai. Toelog oke aapan barkwan ke hawaale kar deile aur djab Roma ke laat Pielaatas oke maangat raha tjhore, tab toelog oke na mangle. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Toelog pawietr aur be-kasoer Waala ke darie par ekgo djaanmarwa ke tjhorwaile. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jiesoe sattja djiewan ke rasta dekhaawe hai, bakie toelog oke marwaai dharle. Tab Parmeswar oke djie oethaais. Aur hamlog gawaahie deila kie oe sattje ke djie oethal hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Okar naam ke saktie dwaara ie aadmie aapan taagat paais hai. Toelog djaane hai kie oe paidaais se loendj raha. Aur ab oe Jiesoe me bieswaas kare se ekdam se attjha hoi gail hai. Toelog to dekh sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Bhaai logan, ham djaaniela kie djab toelog aur toelogke barkwan Jiesoe ke kroes par tjaharwaai deile rahiele, tab na djaanat rahiele kie ka karat rahiele. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bakie ie rakam se Parmeswar aapan bietjaar poera karies hai. Oe agwe se aapan sab sanesian dwaara bataais raha kie okar Kriest bahoet doekh oethaawat. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ohie se toelog aapan paap pastaaike aur Parmeswar ke rasta par tjal. Tab oe toelogke paap ekdam se mietaai deiga aur toelogke okar sjaantie mieliega. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tab Parmeswar Jiesoe ke phien se pathaaiga. Oe okar Kriest hai, ohie Raadja djaun oe toelogke waada karies raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Oke swarag me rahe ke parie djab talak Parmeswar sab doenia ke kaar-baar phien barhia se na banaaiga, djaise oe dher dien pahiele aapan pawietr sanesian ke dwaara bataais raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosas bolies raha kie: ‘Djaise Prabhoe Parmeswar hamke pathaais hai, oisane oe toelogke djaatie ke bhaai me se hamaar ner ek sanesia toelogke lage pathaaiga. Toelogke tjaahie okar sab baat soene ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Aur dje okar baat na soeniega, oe Parmeswar ke djanta me na gientie rahie aur maar dhaaral djaaiga.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Saamoewel se Parmeswar ke har ek sanesia bhie ehie tem ke biese me agwe se bataais hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Oe sanesian toelogke baap-daada hai. Parmeswar ke baat-tjiet oelog aur toelog khaatien hai. Oe Aabraaham se baat-tjiet karies raha kie: ‘Tor aulaad dwaara sab doenia ke djaatie ke aasies mieliega.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Parmeswar pahiela darie par aapan sewak Jiesoe ke toelogke khaatien djie oethaais aur oke toelogke lage pathaais hai, har ek ke paap-boeraai me se batjaawe dwaara aasies dewe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petras aur Johaanas abbe batiaite raha, tab atjakke me ekaatgo Parmeswar ke mahal ke agwan, mahal ke siepaahie ke barkwa aur koetjh Sadoesie log aaike oelogke baat me laat maaries. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Oelog bahoet goessaail kie pathaawal waalan djanta se bataawat raha kie Jiesoe djie oethal hai aur siekhaawat raha kie dje Jiesoe me bieswaas karie, oe bhie djie oethiega. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sandjha hoi gail raha, ohie se oelog Petras aur Johaanas ke ek raat khaatien band karwaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bakie djanta me se dher log oelogke partjaar soenke Jiesoe me bieswaas kare lagal. Ohie rodj lagbhag paatj hadjaar manai bieswaasie hoi gail, aurat larkan tjhorke. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Biehaan bhaile Israel ke djanta ke barka agwan, barkwan aur Jeroesaalem ke dharam ke parhal waalan ekattha bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Oe sabha me sab se barka agwa Aanaas aur okar palwaar log Kaajaafas, Johaanas aur Aaleksaandar bhie raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tab oesab pathaawal waalan ke bolwaaike poetjhies: „Toelog kekar saktie kie to kekar naam se ie kaam karle?” ");
INSERT INTO hnsNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Oe same par Petras Pawietr Aatma se bhar gail aur oe bolies kie: „Israel ke djanta ke barkwan, soeno! ");
INSERT INTO hnsNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Hamlog ekgo bemaria ke bhalaai kare ke kaaran kaboelaawal djaaila kie oe kaise attjha bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Toelog aur sab Israel logan ke tjaahie djaane ke kie aadj ie aadmie tjangga hoike toelogke aage khara hai Naasaaret sahar ke Jiesoe Kriest ke naam se. Toelog ohie Jiesoe ke kroes par marwaai dharle rahiele, bakie Parmeswar oke djie oetha leis hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Oe djaise oe ieta hai djaun ke biese me Parmeswar ke poestak me liekhal hai kie: ‘Djaun ieta ghar banaawe waalan tjhor deis raha, oe baad me ghar ke thaame waala ieta bhail.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Dhartie par khaalie ek batjaawe Waala dewal gail hai aur oe hamlogke paap me se batjaai sake hai. Okar naam Jiesoe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sab koi dekh leis kie Petras aur Johaanas bhola-bhaala aur na bahoet parhal liekhal manai raha. Bakie djab oelog soenies kaise oesab biena dar se batia hai, tab bahoet atjambho bhail aur tjienh leis kie oe doeno Jiesoe ke saath raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aur djab oesab dekhies kie attjha karal aadmie Petras aur Johaanas lage khara hai, tab oesabke baat par djabaab na dei paais. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tab oesab oe doeno ke bolies bahare djaai ke aur apane me sotj-bietjaar kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bolies: „Hamlog ie aadmie log se ka kar sakiela? Jeroesaalem me sab koi djaane hai kie oelog ek atjambho kaam karies hai. Aur hamlog apane dekhlie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bakie ie baat phaile se pahiele hamlog ke tjaahie oesabke khoeb daate ke aur bole ke kie mienaahie hai koi se ie naam ke biese me batiaai ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tab sabha waalan oesabke bhiettar bolwaais aur mienaahie karies Jiesoe ke naam ke biese me batiaai ke aur okar naam me partjaar kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bakie Petras aur Johaanas bolies kie: „Toelog apane bietjaar kar kaise hamlog Parmeswar ke baat tjhorke toelogke baat soen sakiela. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Hamlog moeh na band kar sakiela sab tjiedj ke biese me djaun dekhlie aur soenlie hai djab hamlog Jiesoe ke sanghe rahielie.” ");
INSERT INTO hnsNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tab barkwan oesabke phien se auro derwaais bakie tabbo tjhor deis. Oesab na djaanies kaise tjaahie sadja dewe ke. Sab djanta to mielke Parmeswar ke aadar karat raha oe tjiedj ke biese me djaun abbe bhail raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Oe aadmie djaun attjha hoi gail raha, oe tjaalies baries se oeppar raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Djaise Petras aur Johaanas tjhoetal, taise oesab bieswaasie bhaai-bahien ke paas lautke gail aur bataais barka agwan aur barkwan ka bolies raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tab djab oelog soen tjoekal, tab ek moeh hoike Parmeswar se praatna kare lagal kie: „He Prabhoe, aap to dhartie aur eman ke sab tjiedj ke banaawe Waala baato. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Hamlogke baap-daada Daawied tor sewak raha aur oe tor Pawietr Aatma dwaara bolies raha kie: ‘Doenia ke djaatie kaahe khaatien hardam oeppaddar kare hai? Oesab khaalie kharaab bietjaar kare hai, tjaahe koetjh na kar paawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Doenia bhar ke raadja aur oesabke barkwan ek hoike Prabhoe Parmeswar aur okar Kriest se maange hai laraai kare.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Aisahie bhie Jeroesaalem sahar me bhail hai. Hia par to raadja Herodes, laat Pontias Pielaatas, doesar djaat log aur bhie Israel ke djaatie logan sab tajaar bhail tor pawietr sewak Jiesoe se laraai kare khaatien, tjaahe toe oke Kriest banaile baate. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Oesab karies hai djaise aap agahie se aapan barka gjaan aur bietjaar me dharle rahiele. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","He Prabhoe, ab hamlog praatna kariela kie aap oesabke kharaab bietjaar khiaal kar aur hamlogke sahaaita de tor baat be-dar se bataawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bemarian ke attjha karieho aur aapke pawietr sewak Jiesoe ke naam se atjambho aur barka kaam karwaaw.” ");
INSERT INTO hnsNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tab praatna karte me hoewa ke djamien hiele lagal aur ohie laage oesab Pawietr Aatma se bhar gail. Tab oelog Parmeswar ke khoes khabar be-dar se partjaar kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bieswaasie log me bahoet soemmat raha. Oesab mielke aapan sab tjiedj apane me kaam me laawat raha. Koi na bolies: „Ie hamaar hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pathaawal waalan bahoet saktie se Prabhoe Jiesoe ke djie oethe ke baare me gawaahie dewat raha. Aur Parmeswar sab bieswaasie log ke bhalaai karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Oelog me koi ke koetjh na kamtie raha. Aur dje ke khet kie to ghar raha, oe betjke paisa pathaawal waalan ke saup dewat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Tab dje ke koetjh djaroerie raha, oe otane paawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ekgo Josaf naam ke aadmie raha. Pathaawal waalan oke bhie Baarnaabaas bolaawat raha. Ie naam ke matlab hai: tieha dewe waala. Oe Lewie ke koel ke raha aur Siepras des me paida bhail raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ohoe aapan khet betjke paisa pathaawal waalan ke saup deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ekgo Aanaaniaas naam ke aadmie raha aur okar aurat ke naam Safiera raha. Ohoelog ek toekkara djamien betjies. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tab aadmie aapan aurat se sallaah karke aur oman se koetjh paisa niekaarke batjal paisa pathaawal waalan ke saup deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bakie Petras poetjhies: „Aanaaniaas, kaise saitaan tor diel me aaike aur tose koetjh paisa niekarwaai leis? Toe Pawietr Aatma ke dhokha deile! ");
INSERT INTO hnsNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Djab djamien na betjte, tab ie tor rahat. Aur biekaai ke baad paisa se kar sakte djaun toe mangte. Tor man me ka aail kie toe aisan kaam karle? Toe iensaan ke dhokha na deile bakie Parmeswar ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Bas ie baat soenke Aanaaniaas gieral aur aapan praan tjhor deis. Aur dje soenies, oesabke bahoet hadas samaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tab samaadj ke naudjawaan oethke okar lahaas kapra me lapetke aur ledjaaike okar mattie deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tab lagbhag tien ghanta baad okar aurat bhiettar aail. Oe na djaanat raha kie ka bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tab Petras ose poetjhies: „Etane me toelog djamien betjle?” Tab aurat bolies: „Ha, etanahie me.” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tab oe bolies: „Toelog kaahe ke sallaah karle rahiele Parmeswar ke Pawietr Aatma ke adjmaawe ke? Soen, oesabke gor ke aawaadj soena hai djaun tor aadmie ke mattie deike aawe hai. Aur oelog abbe tohoe ke ledjaaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bas toerante aurat okar gor ke aage gierke bhie aapan praan tjhor deis. Tab djab naudjawaan log bhiettar aail, tab oesab dekhies kie aurat bhie maral paral hai. Aur oesab ohoeke ledjaaike okar aadmie ke bagal me okar mattie deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Sab samaadj ke bieswaasie aur bhie doesar log soenke bahoet ghabaraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Djanta log ke bietj me pathaawal waalan dher barka kaam aur tjienha dekhaais. Aur sab bieswaasie log ek man hoike rodj ekattha howat raha Parmeswar ke mahal ke angana me Saalomo ke tjhaawal rasta par. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Doesar manai log ke hiemmat na raha oelogke saath dewe ke, bakie tabbo sab koi bahoet ieddjat se oelogke biese me sotjat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aur dher aadmie aur aurat Prabhoe me bieswaas kare lagal. Aisane iesaai ke samaadj barhat gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Etana talak bhail kie manai log bemarian ke oethaaike aur tjataai bietjhaaike rasta ke kienaare letaai dewat raha. Oesab aasa karat raha kie djab Petras paas hoi, tab okar partjhaai koi bemarian ke oeppar par djaai. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jeroesaalem ke aas-paas ke manai log bhie djoet gail. Ohoelog aapan bemarian aur djaun log ke bhoet pakaries raha, oesabke liaail. Aur sab attjha hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tab sab se barka agwa aur okar saathie log sallaah karies koetjh kare ke. Oesab Sadoesie ke dal ke raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Djaran ke maare oesab pathaawal waalan ke pakarwaaike djahal me band karwaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bakie ohie raat ke Prabhoe ke ek parie aaike djahal ke kamaarie khol deis. Tab oesabke bahare laaike bolies: ");
INSERT INTO hnsNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","„Dja toelog Parmeswar ke mahal ke angana me thara hoihe aur hoewa ke djanta log se sattja djiewan ke biese me partjaar kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tab pathaawal waalan okar baat soenke sabere sabere mahal ke angana me djaaike aur soeroe karies djanta log ke siekhaawe ke. Etane me sab se barka agwa aur okar saathie log Israel ke djaat ke barkwan ekattha karwaais. Oe sabha me Israel ke sab koel ke barkwan bhaag lewat raha. Tab oesab Parmeswar ke mahal ke siepaahie ke djahal pathaais pathaawal waalan ke laawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Bakie djab oelog djahal me pahoetjal, tab dekhies kie hoewa par koi na hai. Tab oesab lautke gail aur sabha waalan se bataais kie: „Dwaar par rakhwaala log khara raha, sab kamaarie taala raha, bakie djab hamlog kothrie ke kamaarie khollie, tab oman koi na raha.” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ie baat soenke mahal ke siepaahie ke barkwa aur barka agwan ghabaraai gail aur oesab apane me bolies: „Ab ka hoi? Oesabke saath ka bhail?” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Bas koi aaike oesabse bataais kie: „Soen, djaun manai ke toelog pakarwaile rahiele, oelog to Parmeswar ke mahal ke angana me djanta log ke siekhaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tab barkwa aapan siepaahie sanghe pathaawal waalan ke gail laawe, bakie bahoet sadhaaran se. Oe deraat raha kie djanta log oesabke ieta bahaaike maarat. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Oesab pathaawal waalan ke laaike aur barkwan ke aage khara karies. Tab sab se barka agwa bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","„Hamlog toelogke mienaahie karlie rahielie ie aadmie ke naam ke biese me partjaar kare ke. Aur dekh, ka bhail! Toelog Jeroesaalem bhar me ie siektjha partjaar karle aur bhie okar maut ke kasoer hamlog par dharle hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tab Petras aur doesar pathaawal waalan bolies: „Ha, tabbo hamlogke tjaahie Parmeswar ke baat iensaan ke baat se auro djaada soene ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Toelog Jiesoe ke kroes par tangwaaike marwaai dharle, bakie hamlogke baap-daada ke Parmeswar oke djie oethaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tab oe oke aapan dahiena bagal baithaaike hamlogke Barkwa aur batjaawe Waala banaais djeme Israel ke djaatie aapan boeraai pastaaike aur tjhama paaike ek naawa djiewan soeroe kare. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Hamlog ie sab tjiedj ke biese me partjaar kariela, aur Pawietr Aatma gawaahie dewe hai kie hamlogke baat satj hai. Parmeswar aapan Aatma dewe hai dje okar baat soene hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ie baat soenke sabha waalan etana goessaail kie maangat raha oelogke marwaai dhaare. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bas etane me sabha ke ekgo Fariesie khara bhail. Okar naam Gaamaaliejel raha. Oe ek dharam ke kaanoen ke parhal aadmie raha aur sab djanta oke bahoet barka maanat raha. Oe bolies kie pathaawal waalan ke tjaahie thora der khaatien bahare djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tab oe sabha me bolies: „Bhaai log, toelog thiek se sotj-bietjaar kar le kie ie aadmie log se ka kariehe. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Koetjh baries pahiele ek Toidaas naam ke aadmie raha. Oe bolat raha kie oe bahoet koetjh hai. Aur okare sanghe lagbhag tjaar sau aadmie saath deis. Bakie ose ka bhail? Oe maraai gail, okar sab saathie log iedhar oedhar hoi gail aur oelogke dal ekdam se miet gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Okare baad me, djab sab djanta log gienaat raha, tab ekgo Gaalielea diehaat ke aadmie raha. Okar naam Joedaas raha. Dher thethar waalan okar saath tjalal. Bakie ohoe maraai gail aur okar sab saathie log bhie iedhar oedhar hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ohie se ab ham toelogse boliela kie ie aadmie log ke koetjh na kar, bakie oelogke tjhor de. Djab iesabke kaam iensaan ke sotj-bietjaar hai, tab apane miet djaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bakie djab Parmeswar iesabke saath dewat hoi, tab koi koetjh na kar paai. Hoi sakat kie toelog Parmeswar ke kaam rokaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sabha log samdjhies kie ie baat satj hai. Tab oelog pathaawal waalan ke bhiettar bolwaaike khoeb pietwaais aur phien se mienaahie karies Jiesoe ke naam ke biese me batiaai ke. Tab oesabke tjhor deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pathaawal waalan sabha tjhorke tjal gail. Oesab khoesie raha Jiesoe ke naam khaatien etana bedjatie sahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aur oesab rodj Parmeswar ke mahal ke angana me aur ghare ghar siekhaawat raha aur khoes khabar partjaar karat raha kie Jiesoe Parmeswar ke Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Oe tem me djab Jiesoe ke tjela log auro dher howat raha, tab Griek des ke aur Israel des ke bhaasa batiaai waalan me djhandjhat bhail. Griek waalan bolies kie: „Hamlogke wiedhwan ke rodj ke sewa na thiek se howe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tab baara pathaawal waalan sab tjela log ke ekattha bolwaaike bolies kie: „Na thiek rahiega djab hamlog Parmeswar ke baat partjaar kare ke kaam tjhorke aur khaai pieje ke kaar-baar me lag djaabe. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","4","Bhaai log, ohie se toelog apane me se saatgo iemaandaar waala aadmie tjoen, djaun ke diel Pawietr Aatma aur gjaan se bharal hai. Oelog rodj ke kaar-baar dekh-bhaal kar sakie, tab hamlog khaalie partjaar aur praatna kar sakab.” ");
INSERT INTO hnsNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tab sab bieswaasie log bolies: „Attjha, ie bietjaar thiek hai.” Aur oelog pahiele Stefaanas ke tjoenies. Okar bieswaas bahoet djabar raha aur oe Pawietr Aatma se bharal raha. Oelog Fielepas, Prokoras, Niekaanor, Tiemon, Parmenaas aur Niekolaus bhie tjoenies. Niekolaus Antiokia sahar ke raha. Prabhoe Jiesoe me bieswaas kare se pahiele oe aapan dharam tjhorke Israel ke dharam apanaai leis raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tab oelog saato ke pathaawal waalan ke lage ledjaaike bolies kie: „Dekh, hamlog iesabke tjoenlie hai.” Tab pathaawal waalan praatna karke oesabke oeppar aapan haath rakhke aasies deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Aisane Parmeswar ke baat phailat gail aur Jiesoe ke tjela log djaada howat gail. Aur dher agwa log Prabhoe Jiesoe me bhie bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefaanas ke diel Parmeswar ke bhalaai aur saktie se bharal raha. Oe djanta ke bietj me ek se ek atjambho kaam karat raha aur tjienha dekhaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bakie koetjh Israel log oke na maangat raha. Oesab „‘Tjhoral waalan”’ ke partjaar ke ghar me ke raha. Sierene diehaat aur Aaleksaandria sahar ke Israel log bhie ie partjaar ke ghar me aail. Tab ielog aur koetjh Sieliesia aur Aasia des ke Israel log mielke Stefaanas se baate-baat me djhagara kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Bakie okar gjaan aur baat Pawietr Aatma ke raha. Ohie se oesab ose na djiet paais. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tab oelog ekaatgo aadmie ke siekhaais djhoeth bole ke kie: „Hamlog soenlie hai kaise Stefaanas Parmeswar aur Mosas ke bedjatie kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tab ie baat soenke sab Israel ke djanta log aur oesabke barkwan aur dharam ke parhal waalan bahoet haltjal matjaais. Aur oesab Stefaanas ke hietjke aapan barkwan ke aage legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tab ohoesab naklie gawaahia sabha me bolwaais. Oesab bolies kie: „Ie aadmie hardam Parmeswar ke pawietr djagaha aur Mosas ke kaanoen ke biese me kharaab baat bole hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Hamlog soenlie kie ie bolies hai: ‘Naasaaret sahar ke Jiesoe aaike Parmeswar ke mahal toer deiga aur sab rahan-tjalan badal deiga djaun Mosas hamlogke siekhaais raha.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tab djab sabha waalan Stefaanas ke thiek se taakies, tab dekhies kie okar soerat ekgo Parmeswar ke parie ghat tjamke hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tab sab se barka agwa Stefaanas se poetjhies: „Ie baat satj hai?” ");
INSERT INTO hnsNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tab oe bolies: „Bhaai log, soen. Djab hamlogke baap-daada Aabraaham Haaran sahar me rahe se pahiele Mesopotaamia des me rahat raha, tab ek dien maahaan Parmeswar oke dekhaail ");
INSERT INTO hnsNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","aur bolies kie: ‘Toe aapan des aur palwaar tjhorke oe des me dja djaun ham toke dekhaabe.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Aisane Aabraaham Kalde djaat ke des tjhorke Haaran sahar me gail rahe. Tab djab okar baap hoewa par mar gail raha, tab Parmeswar oke ie des me liaail djaaha toelog iesaait rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Bakie oe oke hia ek phoet djamien na deis. Oe khaalie waada karies kie: ‘Ie des ham toke aur tor baal-battjan ke debe.’ Oe same par Aabraaham ke ekko larka na raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Aur ohie mauka par Parmeswar ose bhie bolies kie: ‘Tor baal-battjan ek andjaan des me rahiega. Oe des ke manai log oelogke goelaamie karwaaike tjaar sau baries talak sataaiga. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bakie oe djaatie ke ham bahoet sadja debe. Tab tor aulaad oe des se tjal djaaiga aur lautke ie des me hamaar aadar kariega.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tab Parmeswar Aabraaham se baat-tjiet karies kie oke tjaahie apane ke aur aapan betwan aur goelaam log ke hakiekat karwaawe ke. Aisane djab Aabraaham ke beta Iesaak paida bhail, tab athwa rodj oe okar hakiekat karwaais. Tab Iesaak aapan beta Jaakob ke aur Jaakob hamlogke baara baap-daada ke djalmaaike oesabke hakiekat bhie karwaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Baad me ie baap-daada log djaran ke maare aapan tjhota bhaai Josaf ke goelaam ghat betj deis aur oe Egypte des me ledjaawal gail. Bakie Parmeswar okar saath raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Oe oke sab moesiebat me se batjaais, aur bhalaai karke oke aisan gjaan deis kie Egypte ke raadja Faaraao okar bahoet maan-djaan karies. Oe oke aapan des ke maahaamantrie banaai deis aur bhie aapan dhan-daulat dekh-bhaal kare ke deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Oe tem me aise bhail kie Egypte aur Kaanaan des me bahoet akaal aur bara moesiebat paral. Hamlogke baap-daada log ke koetjh khaaik na raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tab djab baap soenies kie Egypte des me khaaik miele hai, tab oe aapan betwan ke pahiela dafe hoewa pathaais koetjh kiene khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tab djab oesab doesara dafe aail tab Josaf aapan bhaai log se bataais kie: ‘Ham toelogke tjhota bhaai baatie.’ Aisane raadja Faaraao se aur okar bhaai se tjienh-pahietjaan bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tab Josaf aapan baap aur okar sab palwaar ke Egypte me bolwaai leis. Sab mielaaike patjhattar (75) djane raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aisane Jaakob aur okar betwan aail Egypte me rahe aur oelog hoewa mar gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tab oelogke lahaas Kaanaan des ledjaawal gail, aur hoewa Siekem sahar lage kabar me dharaail. Pahiele Aabraaham oe kabar Hemor djaat se kienies raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tab djab tem nagtjaail kie Parmeswar aapan waada Aabraaham khaatien poera karat, tab Israel ke djaat Egypte des me bahoet dher hoi gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Oe tem par ekgo doesar raadja raadj tjalaawat raha aur oe Josaf ke biese me na djaanat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Oe tjalaakie se Israel ke djaat ke bahoet doekh dewat raha. Oe bolies kie: ‘Israel log ke tjaahie aapan sab paida howal betwan ke tjhor dewe ke mar djaai khaatien.’ Ie rakam se oesab aur dher na howat. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Bas oe tem par Mosas paida bhail. Parmeswar ke aakhie me oe ek bahoet soendar larka raha. Okar maai-baap oke tien mahienna aapan ghar me posies, ");
INSERT INTO hnsNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","tab oke bhie tjhor deis. Tab raadja ke bietia oke paais aur aapan larka ghat posies. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Djetana Egypte djaatie ke gjaan raha, otana oe siekhies. Aisane oe ek barka boeddhiemaan hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tab djab oe tjaalies baries ke raha, tab oe maangies djaane kie okar Israel djaatie ke bhaai log ke haal-tjaal kaise hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tab ek rodj djab oe dekhies kie ekgo Egypte ke aadmie okar ek djaatie bhaai ke koetjh kharaabie kare hai, tab oe oke batjaaike Egypte waala ke maar dhaaries. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Oe sotjies kie okar djaatie ke bhaai log samadjh djaai kie Parmeswar okar dwaara oelogke maange hai batjaawe. Bakie oesab na samadjh paais. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Biehaan bhaile oe dekhies kie okar djaatie me ke doei aadmie apane me maar-piet kare hai. Tab oe ie djhagara tjhoraaike aur bolies: ‘Toelog bhaai-bhaai baate, tab kaahe ke laraai kare hai?’ ");
INSERT INTO hnsNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Bakie djaun ekwa ke maarat raha, oe Mosas ke dhakel deis aur bolies: ‘Toe ke baate hamlogke bietj me bole waala? Ka, toe hamlogke djadj kie to sardaar baate? ");
INSERT INTO hnsNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Toe hamme bhie maange hai maar dhaare djaise kalhia toe Egypte waala se karle?’ ");
INSERT INTO hnsNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Bas ie baat soenke Mosas Egypte des tjhorke Miedian des bhaag gail. Hoewa par okar biaah bhail aur doei betwa paida bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Tab tjaalies baries baad maidaan me Sienaai pahaar lage Parmeswar ke ekgo parie ek djarat djhalaasie me oke dekhaail. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Aur djab atjambho hoike oe maangies djaai dekhe, tab Prabhoe ke aawaadj soenaail kie: ");
INSERT INTO hnsNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ham tor baap-daada Aabraaham, Iesaak aur Jaakob ke Parmeswar baatie.’ Tab Mosas dar ke maare kaape lagal aur roek gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tab Prabhoe bolies: ‘Toe ek pawietr djagaha par thara baate, ohie se aapan djoeta oetaar de. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ham thiek se dekhlie hai kie Egypte me hamaar djaat ke ketana doekh hai. Ham oesabke tjiellaahat soenlie, aur ham maangiela oesabke ie moesiebat me se batjaawe. Ohie se ham oeppar se ailie aur toke Egypte des pathaabe.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Pahiele Egypte des me ie djaatie Mosas ke na maangat raha. Oelog ose bolies: ‘Ke toke sardaar aur djadj banaais hai?’ Tabbo Parmeswar ohieke djaatie ke sardaar aur batjaawe waala banaaike pathaais oe parie ke saktie se djaun djarat djhalaasie me oke dekhaail raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aisane Mosas oesabke Egypte des me se liaail. Oe Egypte me ek se ek atjambho kaam karies aur barka tjienha dekhaais, aur baad me ‘Laal’ naam ke samoendar lage aur tjaalies baries talak maidaan me bhie. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Aur ohie Israel log se bolies kie: ‘Ek rodj Parmeswar toelogke djaatie ke bhaai me se ekgo hamaar ner sanesia ke toelogke lage pathaaiga.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Oe bhie maidaan me hamlogke baap-daada ke samaadj Sienaai pahaar lage ekattha karke oelogse aur parie se baat-tjiet karat raha. Aur oe pahaar par Parmeswar oke djiewan dewe waala baat deis toelogse bataawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Bakie hamlogke baap-daada log okar baat na maangies soene aur oke nahakaar deis. Oesabke man karat raha Egypte lautke djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tab djab Mosas pahaar par raha, tab oesab okar bhaai Aaron se bolies: ‘Hamlog khaatien koetjh dewta ke moertie banaai de djaun hamlogke rasta dekhaai sakie. Hamlog na djaaniela kie Mosas se ka bhail hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tab oesab ekgo boel ke moertie banaais aur okar khaatien koetjh baliedaan karies. Aur oelog aapan banaawal tjiedj dekhke bahoet khoesiaalie manaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tab Parmeswar oesabke aapan man waala karan deis aur aisahie oelog aasmaan ke tarai ke aapan maaliek banaaike aadar kare lagal. Aur baad me Parmeswar aapan sanesia Aamos se liekhwaais kie: ‘Are, Israel ke log! Ka, toelog tjaalies baries maidaan me har ek rakam baliedaan hamaar khaatien tjaharaai deile rahiele? ");
INSERT INTO hnsNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na, toelog naklie maaliek Molok ke mandiel aur Romfa maaliek ke tarai ke moertie leike tjalat rahiele. Toelogan aisan tjiedj banaaike ohieke poedja karat rahiele. Ohie se ham toelogke Baabielon sahar se auro doer hataai debe.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Maidaan me hamlogke baap-daada log Parmeswar ke rahe ke djagaha ledjaat raha, djaise Parmeswar bolies raha. Aur oe Mosas se bhie bolies raha ie djagaha aisan rakam se banwaawe ke djaise oe oke pahaar par dekhaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aisane oelog Josoewa ke saathe Parmeswar ke sahaaita se ie des ke be-bieswaasie djaatie ke djiet leis aur oesabke des me aail rahe. Tab oelog Parmeswar ke rahe ke djagaha ie des me dhoite ledjaat raha aur raadja Daawied ke tem talak kaam me lewat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Parmeswar ke bhalaai Daawied ke oeppar raha. Tab Daawied praatna karke poetjhies kie: ‘He Jaakob ke Parmeswar, ham aapke khaatien ek mahal banaai sakab?’ ");
INSERT INTO hnsNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tab okar beta Saalomo ie kaam karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tabbo sab se maahaan Waala ek iensaan ke banaawal djagaha me na rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Oe aapan sanesia Jasaaja se bolies hai kie: ‘Swarag hamaar gaddie aur dhartie hamaar gor dhare ke pierha hai. Tab toelog kaisan ghar hamaar khaatien maange hai banwaawe? Aur ham kaaha par soestaabe? ");
INSERT INTO hnsNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ham to aapan haath se saara sansaar banailie hai!’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stefaanas sabha waalan se bhie bolies: „Are, gabbar logan, toelog kaahe ke Parmeswar ke baat na maange hai soene aur aapan diel etana kathor kar leile? Djaise toelogke baap-daada logan hardame Pawietr Aatma se djabarai karat raha, oisane toelog bhie kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Oesab to Parmeswar ke sab sanesian ke sataais hai. Oelog maar dhaaries djaun ke Parmeswar pathaais ailaan kare ke kie ekgo sattja Waala aaiga. Aur ab oe aail hai. Bakie toelog djhoeth bolke oke kroes par marwaai dharle. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Toelog tjaahe Parmeswar ke kaanoen parie log dwaara paile rahiele, tabbo okar baat na manle!” ");
INSERT INTO hnsNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tab sabha waalan ie baat soenke goessa ke maare daat piese lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bakie Stefaanas Pawietr Aatma se bharal raha aur oeppar taakke oe Parmeswar ke biesaal maahaanta dekhies aur bhie dekhies kie Jiesoe Parmeswar ke dahiena bagal khara hai. Tab oe bolies: ");
INSERT INTO hnsNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","„Ham dekhiela kie swarag khoelal hai aur iensaan ke Beta Parmeswar ke dahiena bagal khara hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bas sabha waalan aapan kaan band kar leis aur tjiellaaike okar lage dhaural. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tab oesab oke pakarke aur sahar ke bahare ghietjke legail aur oke patthar bieg biegke maare lagal. Gawaahian aapan koerta oetaarke aur ek Saulas naam ke naudjawaan ke deis rakhe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Etane me Stefaanas bolies: „Prabhoe Jiesoe, hamaar praan lei le.” ");
INSERT INTO hnsNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tab gaathie par gierke bolies: „Prabhoe, ie boeraai khaatien oelogke sadja na deihe.” Bas aise bolke oe aapan praan tjhor deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Aur Saulas sotjies kie: „Thiek hai kie ie aadmie maraai gail.” Oe rodj se Jeroesaalem ke samaadj log par bara moesiebat paral. Oesab bahoet sataawal gail aur iedhar oedhar Joedea aur Saamaaria diehaat me bhaag gail. Khaalie Prabhoe ke pathaawal waalan sahar me rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ekaatgo bieswaasie aadmie Stefaanas ke mattie deis. Oelogke bahoet doekh raha okar maut se. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Aur Saulas bahoet kausies kare lagal bieswaasie ke samaadj ke naas kare khaatien. Oe ghar ghar me ghoeske mardaana aur aurat ke pakarke band karwaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Djaun bieswaasie log Jeroesaalem me se khaderal gail raha, oelog des bhar me khoes khabar bataawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Dekh-bhaal kare waala Fielepas aisane Saamaaria sahar me ailaan kare lagal kie Jiesoe aane waala Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Dher Saamaaria log djab okar partjaar soenies aur dekhies kie oe kaun barka kaam kare hai, tab oesab ek hoike okar baat maane lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Dje ke bhoet sataawat raha, oelog me se bhoet tjiellaaike bhaag gail aur dher langar aur loendj log attjha bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ohie khaatien Saamaaria diehaat me bahoet khoesiaalie aail. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Bakie koetjh dien pahiele ek Siemon naam ke aadmie oe sahar me djaadoe karat raha aur Saamaaria log bahoet atjambho howat raha. Oe apane ke bahoet biesaal samdjhat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Sab nietja aur oetja manai log okare oeppar khoeb dhiaan lagaawat raha. Oesab bolies kie: „Dekh, ie aadmie ‘Parmeswar ke barka saktie’ bolaawal dja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Oe dien se dher log okare pietjhe tjalat raha. Oesab okar djaadoe se atjambho howat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bakie djab Fielepas khoes khabar Parmeswar ke raadj aur Jiesoe Kriest ke naam ke biese me partjaar karies, tab dher aurat aur mardaana log Prabhoe Jiesoe me bieswaas kare lagal, aur oesab apane ke dopoe karwaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tab Siemon bhie bieswaas kare lagal aur dopoe ke baad oe Fielepas lage se na gail. Ohoe Prabhoe ke biesaal tjienha aur saktie dekhke ghabaraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tab djab Prabhoe ke pathaawal waalan Jeroesaalem me soenies kie Saamaaria ke manai log Parmeswar ke baat apana leis hai, tab oesab Petras aur Johaanas ke hoewa pathaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Oelog djab pahoetjal tab praatna karke Saamaaria ke bieswaasie log khaatien Pawietr Aatma maangies. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Oe sahar me to Pawietr Aatma abbe koi ke na mielal raha. Oesab khaalie Prabhoe Jiesoe ke naam me dopoe bhail raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tab djab Petras aur Johaanas bieswaasie log par aapan haath rakhies, tab oelogke Pawietr Aatma mielal. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tab Siemon ie kaam dekhke maangies oesabke paisa dewe aur bolies kie: ");
INSERT INTO hnsNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","„Hamahoe ke ie saktie dewo kie ham koi ke oeppar haath rakhke Pawietr Aatma dei sakie.” ");
INSERT INTO hnsNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tab Petras bolies: „Toke aur tor paisa me aag lage! Ka, toe sotje hai kie toe Parmeswar ke saktie paisa se kien sake hai? ");
INSERT INTO hnsNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Parmeswar ke aakhie me tor diel safa na hai. Ohie se toe ie sab kaam me bhaag na lei paihe. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Aapan paap-boeraai tjhor de aur Parmeswar se praatna kar kie oe toke tor kharaab sotj-bietjaar khaatien tjhama kar dewe. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ham to dekhlie kie toe bahoet djarantoeha aur kharaab boeraai me ekdam se djhakaral baate.” ");
INSERT INTO hnsNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tab Siemon bolies: „Toelog hamaar khaatien Prabhoe se praatna kar aur ose poetjh kie tor saraap hamaar oeppar na pare.” ");
INSERT INTO hnsNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ekare baad djab Johaanas aur Petras Saamaaria sahar me Prabhoe ke baat ke biese me aapan gawaahie deike aur partjaar kar tjoekal raha, tab oesab phien Jeroesaalem laut gail. Aur djaite me oesab Parmeswar ke khoes khabar Saamaaria diehaat ke gaaw me bataawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tab Parmeswar ke ekgo parie Fielepas se bolies kie: „Sandjha ke apane ke tajaar karke oe rasta par djaihe djaun Jeroesaalem se Gaasa sahar dja hai. Oe rasta bahoet soen-saan hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Fielepas apane ke tajaar karke gail. Djaite me oke ekgo ghora-gaarie bhetaail. Oman ekgo raadj tjalaawe waala aadmie baithal raha. Oe Etiopia des ke Kandaake naam ke raanie ke mantrie raha aur okar paisa ke kaar-baar karat raha. Oe Jeroesaalem gail raha Parmeswar ke poedje khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Aur ab oe lautke djaat raha. Gaarie me baithke oe Parmeswar ke sanesia Jasaaja ke poestak parhat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tab Pawietr Aatma Fielepas se bolies: „Gaarie lage dja.” ");
INSERT INTO hnsNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Oe haalie se gaarie lage gail aur okar bagal tjale lagal. Tab otane me soenies kie mantrie ka parhe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tab ose poetjhies: „Sriemaan djie, aap samdjhe hai aap ka parhe hai?” Tab mantrie bolies: „Ham kaise samadjh sakab djab koi hamke na samdjhaai? Aaw hamare bagal baith.” Fielepas baithal. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tab mantrie ie baat parhies kie: „Djaise bhera ledjaawal dja hai maar dhaaral khaatien, oisane oe ledjaawal gail. Aur djaise bhera ke battja tjoep-tjaap rahe hai djab okar rowa tjhiela hai, oisane okar moeh me se ekko baat na niekaral. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Okar bahoet bedjatie karal gail aur kaanoen dwaara na faisala bhail. Ke okar aulaad ke biese me koetjh bataai sakie? Okar djiewan dhartie par se hataai dewal gail.” ");
INSERT INTO hnsNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Aur mantrie Fielepas se poetjhies kie: „Bataaw to, Jasaaja ie baat kekar biese me liekhies hai? Apane biese me kie doesar koi ke biese me?” ");
INSERT INTO hnsNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tab ie liekhal baat kaam me laaike oe soeroe karies Jiesoe ke biese me phor-phorke samdjhaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Aisane batiaite oesab paanie lage se paas bhail. Tab mantrie bolies: „Dekh, hoewa paanie hai! Ham dopoe hoi sakiela kie na? Koetjh hamke roke hai?”  ");
INSERT INTO hnsNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tab oe bolies: „Djab toe poera diel se Prabhoe Jiesoe me bieswaas kare hai, tab koetjh na toke roke hai.” Tab mantrie bolies: „Ha, ham bieswaas kariela kie Jiesoe Kriest Parmeswar ke Beta hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Oe gaarie rokwaais aur doeno paanie me gail. Aur Fielepas oke dopoe karies. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tab djab oesab paanie me se niekaral, tab Pawietr Aatma Fielepas ke hoewa se hataai legail. Mantrie oke phien na dekhies. Oe bahoet khoesiaalie me Etiopia des ke or gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Baad me Fielepas Aasdod sahar me dekhaail. Aur hoewa se oe ie sahar se oe sahar me khoes khabar partjaar karte Sesaarea sahar me pahoetjal. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Oe tem par Saulas Prabhoe ke tjela log ke bahoet sataawat raha aur marwaawe maangat raha. Oe sab se barka agwa lage gail ");
INSERT INTO hnsNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aur ose tjietthie maangies Daamaskas sahar ke partjaar ke ghar ke barkwan khaatien. Ie tjietthie se oke hoekoem raha Prabhoe ke rasta par tjale waalan aurat aur mardaana ke pakarke Jeroesaalem laawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tab djab oe Daamaskas sahar nagtjaail, tab atjakke me oeppar se oke djotie maaries. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Bas oe gier gail aur ek aawaadj soenaail. Koi bolies: „Saul, Saul, toe kaahe ke hamme sataawe hai?” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tab Saulas poetjhies: „Prabhoe, aap ke baato?” Tab oe bolies: „Ham Jiesoe baatie aur toe hamke sataawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Oeth aur Daamaskas sahar dja. Hoewa par tose bataawal djaai toke ka kare ke tjaahie.” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulas ke saathie log bhie roek gail raha. Oelog koi ke na dekhies, khaalie aawaadj soenies aur moeh baaike taakat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tab Saulas oethke khara bhail aur tjaahe okar aakhie khoelal raha, tabbo oe koetjh na dekh paawat raha. Koi okar haath pakarke oke Daamaskas sahar legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tien rodj talak oke koetjh na dekhaat raha, aur oe koetjh na khaat piejat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Daamaskas me ekgo Aanaaniaas naam ke tjela rahat raha. Bas tiesara rodj Prabhoe oke dekhaail aur bolies: „Aanaaniaas.” Tab aadmie bolies: „Djie, Prabhoe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tab oe bolies: „Toe apane ke tajaar karke toerante dja Joedaas ke ghare. Okar ghar oe rasta me hai djaun Sodjha rasta bolaawal dja hai. Hoewa par Taarsas sahar ke Saulas ke poetjhiehe. Oe praatna me bhieral hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ham oke dekhailie hai kie ekgo Aanaaniaas naam ke aadmie aaike okar oeppar haath rakhke okar aakhie attjha kar dei.” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tab Aanaaniaas bolies: „Prabhoe, dher manai hamse bataais hai kie ie aadmie Jeroesaalem me tor bieswaasie log ke ketana doekh deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aur ab oe hia barka agwan ke hoekoem se aail hai oelogke pakarke djahal me band kare khaatien djaun tor naam lewe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tab bolies: „Tabbo toe dja. Ham oke aapan partjaarie ghat tjoenlie hai sab djaatie aur oesabke raadja aur bhie Israel ke djaatie ke djanaawe khaatien kie ham ke baatie. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aur ham oke dekhaabe kie hamaar naam ke kaaran se oke ketana doekh sahe ke parie.” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Aisane Aanaaniaas gail, aur Saulas ke oeppar haath rakhke bolies: „Bhaai Saul, Prabhoe Jiesoe toke rasta par dekhaail raha aur ohie hamke pathaais hai. Oe maange hai tor aakhie attjha kare aur toke Pawietr Aatma se bhare.” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bas toerante Saulas ke aakhie par djaun paral raha, oe hat gail, aur oe phien dekhe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tab Saulas oethke khara bhail aur apane ke dopoe karwaais. Aur djab khaai pie tjoekal raha, tab oke phien taagat bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tab aise bhail djab Saulas ekaat rodj Daamaskas ke bieswaasie log ke saath raha, tab oe toerante soeroe karies partjaar ke ghar me hoewa ke Israel log ke ailaan kare ke kie Jiesoe Parmeswar ke Beta hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ie baat soenke sab koi atjambho hoike apane me poetjhe lagal kie: „Are, ehie na hai djaun Jeroesaalem me Jiesoe ke naam lewe waalan ke maar dhaarat raha? Oe to hia aail hai oesabke pakarke Jeroesaalem ke barka agwan ke aage ledjaai khaatien?” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Etane me Saulas darsaaike partjaar karat raha kie Jiesoe Parmeswar ke Kriest hai. Aur okar baat me etana saktie raha kie Daamaskas ke Israel log epar koetjh na bol paawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tab koetjh tem baad oelog sallaah karies oke marwaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Raat aur dien oesab sahar ke dewaal ke kamaarie kamaarie lage loekaaike oke agorat raha aur bolies: „Hamlog oke maar dhaare k'hoi.” Bakie ie baat Saulas ke soenaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tab ek raat ke okar tjela logan oke tjoeppe se ekgo barka baskieta me baithaaike sahar ke dewaal par se bahare oetaar deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tab djab oe Jeroesaalem me pahoetjal, tab maangies hoewa ke tjela log se miele. Bakie oelog na bieswaas kar sakat raha kie oe Jiesoe ke tjela hoi gail hai. Ohie se oelog ose doer rahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bakie Baarnaabaas okar sahaara karies aur pathaawal waalan ke lage legail. Oe bataais Saulas kaise Daamaskas djaat raha, tab Prabhoe oke dekhaail aur ose batiaais. Oe bhie bataais kie Daamaskas me oe Jiesoe ke naam ke biese me kholke partjaar karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tab pathaawal waalan okar baat maan gail aur Saulas oelogke saath rahe lagal aur oelogke sanghe Jeroesaalem me aawe djaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hoewa par oe bhie kholke Prabhoe ke naam ke biese me batiaat raha. Bas koetjh Israel log djaun Griek ke bhaasa batiaat raha, oelogse aur Saulas se baat-tjiet bhail, aur baate baat me oelog phas gail. Tab ohoelog maangies oke maar dhaare. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bakie bieswaasie bhaai log djab ie baat soenies, tab oesab oke Sesaarea sahar legail. Ekare baad oesab oke Taarsas sahar pathaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Oe tem Joedea, Gaalielea aur Saamaaria diehaat ke iesaai samaadj log bahoet soemmat se rahat raha aur koi na oelogke sataawat raha. Oelog Prabhoe khaatien bahoet ieddjat se aapan djiewan bietaawat raha aur aisane oelogke bieswaas aur djabar howat gail. Aur Pawietr Aatma ke sahaaita se auro dher manai bieswaasie hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Etane me Petras sagaro ghoemke gail bieswaasie log ke dekhe. Aisane oe Leda gaaw me pahoetjal. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Hoewa oe ek Eneas naam ke aadmie ke dekhies. Oe aadmie aath baries se loendj raha aur bietjhauna par paral rahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tab Petras ose bolies: „Eneas, Jiesoe Kriest toke maange hai attjha kare. Oeth aur aapan bietjhauna lapet le.” Bas toerante oe oethke khara hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aur sab Leda aur Saaron ke manai log oke dekhke Prabhoe me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa sahar Leda sahar ke nagietj raha. Hoewa ek Taabieta naam ke bieswaasie aurat rahat raha. Griek ke bhaasa me okar naam Dorkaas raha. Oe bahoet bhalaai karke garieb logan ke aapan tjiedj baat dewat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bas djab Petras abbe Leda me raha, tab Taabieta bemaar hoike mar gail. Oesab okar lahaas nahawaaike ek oeppar kamra me dhar deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tab djab Jopa ke bieswaasie log soenies kie Petras Leda me hai, tab oelog haalie se doeigo aadmie ke sanes deike pathaais ose bole ke kie: „Djetana haldie hoi sake hai, toe aawo!” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Djaise Petras sanes paais, oisahie oe haldie se Jopa sahar me pahoetjal. Tab oesab oke kamra me legail djaaha lahaas raha. Djetana garieb wiedhwa log raha, oesab roite aail aur Petras ke sab kapra dekhaais djaun Taabieta oelog khaatien banaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tab Petras oelogke kamra me se pathaais aur gaathie par gierke praatna kare lagal. Tab lahaas ke taakke bolies: „Taabieta, oeth dja.” Bas aurat aakhie khol deis aur djab Petras ke dekhies, tab oethke baith gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tab Petras okar haath pakarke oke khara karies. Tab oe sab bieswaasie aur wiedhwa log ke bolaaike bolies: „Dekh, oe djie gail!” ");
INSERT INTO hnsNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ie baat Jopa sahar bhar me soenaail aur dher manai log Prabhoe me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Aur Petras ekaat rodj Jopa me rahie gail ekgo Siemon naam ke aadmie ke ghare. Oe aadmie tjamra ke kaam karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sesaarea sahar me ekgo Roma ke soerdjaatie ke barkwa rahat raha. Okar naam Kornelias raha. Okar nietje ek sau Ietaalia des ke soerdjaatie kaam karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Oe ek bhaktie aadmie raha, aur okar ghar-bhar bhie Parmeswar ke aadar karat raha. Oe Israel ke garieb log ke bahoet daan dewat raha aur hardam Parmeswar se praatna karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tab aisahie ek rodj lagbhag tien badje sandjha ke ek Parmeswar ke parie oke dekhaail. Oe oke safa se aawat dekhies. Tab parie bolies: „Kornelias.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tab oe tjaukke oke taakke bolies: „Saheb djie, ka bhail?” Tab parie bolies: „Soen, Parmeswar tor praatna soen leis aur oke bahoet parsand howe hai kie toe garieb logan ke sahaaita kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ab toe ekaat djane ke Jopa sahar pathaai de ekgo Siemon naam aadmie ke bolwaawe khaatien. Okar naam bhie Petras hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Oe koetjh dien khaatien samoendar ke kienaare ek tjamaar Siemon ke ghare rahe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tab djab parie ie sab baat bolke tjal gail raha, tab Kornelias aapan naukar me se doeigo ke bolwaais aur bhie ekgo soerdjaatie ke djaun okar dekh-bhaal karat raha aur bhie Parmeswar ke aadar karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Oe sab baat bataaike oelogke Jopa sahar pathaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Biehaan bhaile lagbhag baara badje Jopa me Petras ghar ke oeppar baithe ke djagaha me gail praatna kare. Ohie same Kornelias ke aadmie log Jopa nagtjaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tab praatna kare ke baad Petras ke bhoekh lagal. Bas djaise khaaik banat raha Parmeswar oke djaise ek sapana me koetjh dekhaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Oe dekhies kie aasmaan khoele hai aur koi koetjh djaise ek barka tjaddar tjaaro kona pakarke nietje oetaare hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Oe tjaddar me sab rakam ke djanaawar raha, tjaargorwa, saap-godjar, aur tjierai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tab ekgo aawaadj soenaail. Koi bolies kie: „Le Petras, maarke kha.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tab oe bolies: „Nahie, Prabhoe! Ham kabhie koetjh na khailie hai djaun haraam kie to na safa hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tab aawaadj phien soenaail kie: „Djaun Parmeswar safa maane hai, oke toe na nahakariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tien dafe aisane bhail, tab djaun nietje oetaraan raha, oe phien oeppar oetha lewal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bas djaise Petras baithke sotjat raha kie ie sab tjiedj ke matlab ka hoi, tab Kornelias ke aadmie log aaike Siemon tjamaar ke dwaar par pahoetj gail. Oelog khodjat khodjat okar ghar paai gail raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tab djor se poetjhies kie: „Hia kauno Siemon Petras rahe hai?” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Bakie Petras etana sotj me raha, kie oe na soenies. Tab Pawietr Aatma ose bolies: „Dekh, toke doei djane khodje hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Toe dja nietje aur djaaha oelog bolie djaai ke toe djaihe. Na deraihe, ham oelogke pathailie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tab Petras nietje gail aur aadmie log se bolies: „Toelog hamme khodje hai. Ham toelogke khaatien ka kar sakiela?” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tab oelog bolies: „Hamlogke ekgo soerdjaatie ke barkwa pathaais hai. Okar naam Kornelias hai. Oe ek bahoet iemaandaar aadmie hai. Oe bhie sattja Parmeswar ke aadar kare hai aur Israel djaat me okar bahoet maan-djaan hai. Parmeswar oke aapan ekgo pawietr parie dwaara bataais hai toke aapan ghare bolaawe ke aur soene ke kie toke kaun baat hai bataawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tab Petras oelogke bhiettar lei leis. Biehaan bhaile oe ekaatgo Jopa ke bieswaasie bhaai log sanghe Kornelias ke aadmie log ke saath gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tab ek rodj baad oelog Sesaarea sahar me pahoetjal. Hoewa Kornelias aapan sab palwaar aur saathie log ke ekattha bolwaaike oelogke agorat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tab djaise Petras hoewa aail, oisane Kornelias bahare djaaike okar gore gierke aur oke poedje lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bakie Petras okar haath pakarke oke oethaais aur bolies: „Toe ka kare hai? Oeth! Ham to bhie tor ghat ek iensaan baatie!” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tab batiaite oesab bhiettar gail aur hoewa Petras dekhies kie ketana manai ekattha hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tab oesabse bolies kie: „Toelog djaane hai kie ek Israel manai ke mienaahie hai ek doesar djaat se miele ke aur okar ghare djaai ke. Bakie Parmeswar hamke dekhaais hai kie hamke na tjaahie koi ke haraam maane ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ohie se ham biena koetjh sotje toerante tor paas ailie. Aur ab ham maangiela djaane kie toe kaahe ke hamme bolwaile hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tab Kornelias bolies: „Tjaar rodj bhail hai kie ham tien badje sandjha ke aapan ghar me praatna karat rahielie. Bas ekgo aadmie oeddjar tjamkat kapra me hamaar aage khara hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Oe hamse bolies: ‘Kornelias, Parmeswar tor praatna soen leis hai. Aur oke bahoet parsand howe hai kie toe garieb log ke bhalaai kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Toe koi ke Jopa sahar pathaaike ekgo Siemon naam ke aadmie ke bolwaai le. Oe bhie Petras bolaawal dja hai. Oe iesaait samoendar ke kienaare ekgo tjamaar Siemon ke ghare rahe hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ohie khaatien ham toerante toke bolwailie. Bahoet barhia hai kie toe aile. Ab hamlog hia ekattha baatie aur Parmeswar hamlogke saath bhie hai. Hamlog maangiela soene kie oe tose ka bolies hai hamlogse bataawe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tab Petras bataawe lagal kie: „Ab ham dekhiela kie Parmeswar ke aakhie me sab koi sattje ke ekke hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Oe sabke apanaawe hai dje okar aadar kare hai aur okar hiettjha poera kare hai, tjaahe oe djaun djaat ke hoi. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Toelog djaane hai kie Parmeswar Israel ke djaat ke kaun khoes khabar djanaais hai. Oe to oesabke bataais hai kie oelog Jiesoe Kriest dwaara ose ek hoi sake hai. Aur ehie Jiesoe sab djaat ke Prabhoe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Toelog soenle rahiele kie djab se Johaanas dopoe aur partjaar kare lagal Gaalielea diehaat aur Israel des bhar me ka bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Oe tem me Parmeswar Naasaaret sahar ke Jiesoe par Pawietr Aatma barsaais aur oke saktie se bhar deis. Oe okare saath raha. Tab Jiesoe tjaaro alang bhalaai karat raha aur djekar oeppar saitaan raha, oe oesabke attjha kar dewat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Hamlog aapan aakhie se dekhlie kie oe Israel des aur Jeroesaalem sahar me kaun bhala kaam karies. Bas ekare baad oesab oke ek kroes par tangwaaike maar dhaaries. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Bakie tiesara rodj Parmeswar oke djie oethaais aur oe hamlogke dekhaail. Okar djie oethe ke baad hamlog okare saath khailie pielie. Sab djanta oke na dekhies, khaalie hamlog. Oe to pahiele hamlogke tjoenies raha okar gawaahian howe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aur ab oe hamlogke hoekoem deis hai Israel djanta khaatien okare biese me partjaar kare ke aur bataawe ke kie Parmeswar ohieke djadj ghat baithaais hai sab djienda aur maral logan ke oeppar faisala kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Parmeswar ke sab pahiele ke sanesian bhie bataais raha kie dje okare me bieswaas kare hai, oe okar naam se paap ke tjhama paaiga.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Djaise Petras batiaite raha, oisane Pawietr Aatma sab soene waalan ke oeppar aail. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Djaun Israel ke bieswaasie bhaai log Petras sanghe Jopa se aail raha, oelog bahoet atjambho hoi gail kie Pawietr Aatma doesar djaat par bhie aail. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Oelog soenies kie Kornelias ke ghar bhar Pawietr Aatma dwaara har ek bhaasa me Parmeswar ke baraai kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tab Petras bolies kie: „Dekh, djaise hamlogke oeppar Pawietr Aatma aail, aisahie ehoelog par aail hai. Ohie se ab hamlogke tjaahie ielogke bhie paanie se dopoe kare ke. Koetjh na oesabke roke hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tab oe hoekoem deis oelogke Jiesoe Kriest ke naam me dopoe kare ke. Aur djab sab kaam don hoi gail raha, tab oesab Petras aur okar saathie log se poetjhies ekaat rodj oelogke saath rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Joedea diehaat me pathaawal waalan aur bieswaasie bhaai log soenies kie koetjh doesar djaat log bhie Parmeswar ke baat apana leis hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Tab djab Petras Jeroesaalem me lautke aail, tab hoewa ke bieswaasie log oke bahoet baat bolies. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Oelog bolies kie: „Toe ek aadmie ke ghare gaile djaun ke hakiekat na bhail hai aur oelogke sanghe bhie khaile piele.” ");
INSERT INTO hnsNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Bakie Petras sab baat soeroe se samdjhaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Oe bolies: „Ham Jopa sahar me praatna karat rahielie. Tab hamme koetjh djaise barka tjaddar dekhaail. Koi oke tjaaro kona pakarke aasmaan me se oetaaries. Tab tjaddar aaike hamaar aage roekal. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Aur djab ham khoeb thiek se taklie, tab dekhlie tjaargorwa, djangalie djanaawar, saap-godjar aur tjierai oman hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tab ham ek aawaadj soenlie. Koi hamse bolies kie: ‘Petras oeth, eke toe maarke kha!’ ");
INSERT INTO hnsNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Tab ham bollie: ‘Djie na, Prabhoe, ham kabhie koetjh na khailie djaun haraam kie to na safa hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tab oeppar se aawaadj phien se soenaail kie: ‘Djaun Parmeswar safa maane hai, oke toe na nahakariehe!’ ");
INSERT INTO hnsNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Oisahie tien dafe bhail, tab sab oeppar oetha lewal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Bas thora der baad tien aadmie oe ghar lage pahoetjal djaaha hamlog rahat rahielie. Oelogke ekgo Kornelias naam ke aadmie Sesaarea sahar me se hamaar lage pathaais raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tab Pawietr Aatma hamse bolies kie: ‘Toe biena koetjh sotje oelogke saath dja.’ Ie tjhaugo Jopa sahar ke bhaai hamaar saath gail Sesaarea sahar aur hoewa par Kornelias aur hamlogse bhet bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tab Kornelias bataais oe kaise aapan ghar me ekgo parie ke dekhies raha. Aur parie bolies raha kie: ‘Koi ke Jopa pathaai de aur ekgo Siemon Petras naam ke aadmie ke bola laaw. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Oe bataaiga kaise toe, tor ghar bhar aur saathie log paap me se batj djaai sakiega.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tab djab ham thora der oesabse Prabhoe ke biese me batiailie rahielie, bas Pawietr Aatma Kornelias log par aail djaise soeroe me hamahoelog par. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tab hamme toerante Prabhoe ke baat jaad bhail kie: ‘Johaanas paanie se dopoe karat raha, bakie toelog Pawietr Aatma se dopoe hoihe.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Aur djab oelog Prabhoe Jiesoe Kriest me bieswaas kare lagal, tab Parmeswar ohoelogke ohie saktie deis djaun oe hamlogke deis raha. Tab ab toelog sotj kie ham ke baatie Parmeswar ke roke waala?” ");
INSERT INTO hnsNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ie sab baat soenke Jeroesaalem ke bieswaasie log soen hoi gail. Oesab Parmeswar ke aadar kare lagal aur bolies kie: „Bhaai log, Parmeswar doesar djaat log ke bhie mauka deis hai paap pastaaike sattja djiewan soeroe kare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Djaun tem par Stefaanas maraai gail raha, oe same se bieswaasie log bahoet sataawal gail. Oesab iedhar oedhar bhaagke, Feniesia aur Siepras des aur Antiokia sahar talak pahoetj gail. Hoewa par oesab khoes khabar partjaar kare lagal, bakie khaalie Israel djaatie khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Oelog me ekaatgo Siepras aur Sierene des ke raha. Djab oesab Antiokia sahar me aaike pahoetjal tab bhie Griek djaatie log se khoes khabar Prabhoe Jiesoe ke biese me bataais. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Parmeswar ke saktie oelog par raha, ohie se dher Griek log Prabhoe me bieswaas kare lagal aur aapan paap pastaaike okar rasta par tjale lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ie sab baat Jeroesaalem ke bieswaasie logan ke kaane talak pahoetj gail. Tab oelog Baarnaabaas ke Antiokia sahar pathaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Djab oe hoewa pahoetjal aur dekhies kie Parmeswar oesabke ketana bhalaai kare hai, tab oe bahoet khoesie bhail aur naawa bieswaasie log se bolies kie: „Aapan diel bhar se Parmeswar se ek rahoe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Oe ek bahoet barhia aadmie raha aur bieswaas aur Pawietr Aatma se bharal raha. Okar aawe ke baad auro manai log Prabhoe me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tab hoewa se oe Taarsas sahar gail Saulas ke khodje. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Aur djab oke paais, tab oe okare sanghe Antiokia lautke gail. Hoewa par bieswaasie log ek baries bhar oelogke barhia se sewa karat raha. Aur doeno mielke dher manai ke siekhaawat raha. Antiokia sahar me Jiesoe ke tjela log ke pahiela dafe „‘iesaai”’ bolaawal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Oe same ekaatgo Parmeswar ke sanesian Jeroesaalem se Antiokia me aail. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Oelog sanghe ekgo Aagaabas naam ke aadmie raha. Pawietr Aatma dwaara oe bataais kie: „Doenia par sagaro akaal pariega.” Tab koetjh tem baad, djab Klaudias naam ke maahaaraadja raadj tjalaawat raha, tab aisahie bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aagaabas ke sanesa soenke Antiokia ke bieswaasie log sallaah karies Joedea diehaat ke bhaai-bahien log ke madat kare ke. Dje ke djaun raha, oe dei sakat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Djaise oesab sallaah karies raha, aisane bhail. Tab sab paisa ekattha karke oelog Saulas aur Baarnaabaas ke deis Joedea diehaat ledjaai khaatien. Aur djab hoewa par pahoetjal, tab oe doeno paisa bieswaasie log ke barkwan ke dei deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Oe same par raadja Herodes hoekoem deis koetjh iesaai samaadj waalan ke sataawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Oe Johaanas ke bhaai Jaakobas ke moerie talwaar se katwaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Aur djab oe dekhies kie ie kaam Israel ke barkwan ke bahoet attjha lage hai, tab oe Petras ke bhie pakarwaai leis. Ie Paasan ke tiewhaar ke tem me bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Oe maangat raha tiewhaar ke baad Petras ke djanta ke aage laawe okare biese me faisala kare khaatien. Ohie se oe oke djahal me kar deis aur sora soerdjaatie okar rakhwaala karat raha. Ie sora tjaar bhaag me baatal raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Aisane Petras djahal me raha, aur iesaai samaadj logan okar khaat Parmeswar se praatna karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tab djaun rodj Petras raadja ke aage laawal djaat, okar ek raat pahiele oe doei soerdjaatie ke bietj me soetal raha. Oe ketie se oe doeno ke sanghe baanhal raha, aur dwaarie par bhie soerdjaatie rakhwaala karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bas Parmeswar ke ekgo parie djahal me aaike Petras lage khara bhail aur kothrie me djotie aail. Tab oe Petras ke padjarie me thelke bolies: „Petras, haalie se oeth!” Aur djab oe khara bhail, tab toerante ketie okar haath par se gier gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tab parie bolies: „Aapan tjamotie lagaaw aur djoeta pahien.” Ie sab djab hoi gail, tab bolies: „Aapan djhoel orh le aur hamaar saathe tjal.” ");
INSERT INTO hnsNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petras okar paatjhe tjalal aur etana bhie na djaanat raha kie satj hai kie na. Oe sotjat raha kie oe sapana dekhe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Oelog pahiela soerdjaatie log lage se paas bhail aur doesara waalan lage se bhie. Tab oesab djahal ke loha ke kamaarie lage pahoetjal. Bas kamaarie apane se khoel gail. Tab djab bahare aaike oesab koetjh doer tjalal, tab parie alop hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tab Petras ke jaad bhail aur oe apane me sotjies kie: „Ab ham djaan gailie kie Parmeswar aapan parie ke pathaais hai hamme raadja Herodes aur Israel ke barkwan ke haath me se batjaawe khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ie sab tjiedj thiek se sotj-bietjaar karke oe Johaanas ke maai ke ghare gail. Ie Johaanas ke doesara naam Markas raha. Hoewa dher iesaai ekattha raha bientie kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tab djab Petras kamaarie par khoet-khoetaais, tab ekgo Rode naam ke naukaraanie aail dekhe kie ke hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bas Petras ke aawaadj pahietjaanke oe khoesiaalie ke maare bhoelaai gail kamaarie khole aur dhaurke gail bataawe kie: „Petras dwaar par khara hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tab ekwan bolies: „Hat oedhar, tor moer na thiek hai.” Bakie Rode bolies: „Aaw tjal dekh, ie satj hai.” Tab ekwan bolies: „Saait okar aatma kie to parie hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Abbe Petras khoet-khoetaite raha. Tab djab oesab kamaarie kholies, tab dekhies kie sattje ke ohie hai. Aur sab koi ghabaraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tab oe sabke haath se sankiaais tjoep howe ke aur bataawe lagal Parmeswar kaise oke djahal me se niekarwaais hai. Djab oe bataai tjoekal, tab bolies kie: „Ie sab baat Jaakobas aur doesar bieswaasie bhaai log ke bhie djanaai deihe.” Tab oe hoewa se kahie ante gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Biehaan bhaile soerdjaatie ke bietj me bahoet haltjal bhail. Oesab khaalie sotjat raha kie Petras se ka bhail hoi. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes oke bhie khodjwaais, bakie djab na paais tab soerdjaatie log ke pakarwaais marwaai dhaare khaatien. Baad me Petras Joedea diehaat tjhorke Sesaarea sahar gail aur hoewa par koetjh dien talak rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes Tieras aur Siedon sahar ke manai log ke oeppar bahoet goessaail raha. Bakie oelogke raadja ke des ke daana-paanie bahoet djaroerat raha. Ohie se oesab ek man hoike okar paas gail. Oelog okar mantrie Blastas ke apane alang kar leis aur okar sahaaita se raadja se maafie maangies. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tab baithak lagaawe waala dien par raadja pausaal pahienke aur aapan gaddie par baithke bhaasjan deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tab okar aawaadj soenke djanta log khoesie se tjiellaaike bolies kie: „Ie na iensaan ke aawaadj hai, bakie ek bhagwaan ke!” ");
INSERT INTO hnsNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bas toerante Prabhoe ke ekgo parie raadja ke ek kharaab kierwa ke bemaarie deis, aur oe mar gail. Oe to Parmeswar ke aadar na karies raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Etane me Prabhoe ke baat sagaro phailat gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Oe same par Baarnaabaas aur Saulas aapan kaam poera karke Jeroesaalem se phien Antiokia sahar laut gail. Aur oesab Johaanas Markas ke legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokia sahar ke iesaai ke samaadj me ekaatgo bhaai Parmeswar ke sanesian raha aur ekaatgo partjaarie log. Baarnaabaas, Siemeon djaun bhie „‘Kariewa”’ bolaawal djaat raha, Sierene des ke Loesias, Manaain djaun raadja Herodes ke sanghe posaail raha, aur Saulas partjaar karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tab djaise oesab mielke ek rodj bhoekha raha aur Parmeswar ke poedjat raha, tab Pawietr Aatma oelogse bolies kie: „Baarnaabaas aur Saulas ke alag kar de djeme oesab hamaar khaatien kaam kar sake.” ");
INSERT INTO hnsNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tab oesab abbe bhoekha rahieke praatna karke oe doeno par haath rakhies aur oesabke djaain deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Aisane oesab Pawietr Aatma dwaara pathaawal gail. Pahiele Seloesia sahar gail, tab hoewa se djahaadj par Siepras des gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tab djab Salaames sahar me pahoetjal, tab hoewa ke Israel logan ke partjaar ke ghar me oelog Parmeswar ke baat soenaais. Aur oelogke saathe Johaanas Markas raha sab rakam kaam me haath lagaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Aisane des bhar me oelog partjaar karat Paafos sahar pahoetjal. Hoewa par oelogse ek djaadoegar se bhet bhail. Oe Israel ke aadmie raha Baarjiesoe naam ke. Oe apane ek Parmeswar ke sanesia ghat maanat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Oe Siepras des ke laat ke saathie log sanghe raha. Laat ek samadjhdaar aadmie raha. Okar naam Sergias Paulas raha. Oe Baarnaabaas aur Saulas ke apane lage bolwaais aur maangies Parmeswar ke sanesa soene. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Djaadoegar ke naam Griek ke bhaasa me Eliemaas raha. Oe na maangat raha kie laat Parmeswar ke baat soene aur bahoet kausies karies oke roke ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tab Saulas, djaun ke bhie Paulas naam raha, oe Pawietr Aatma ke saktie dwaara oke khoeb thiek se taakke bolies: ");
INSERT INTO hnsNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","„Are, saitaan ke battja! Toe djhoeth aur tjalaakie se bharal hai aur sab bhalaai ke doesman baate. Toe aapan kharaab tjaal na maange hai tjhore. Parmeswar ke bana-banaawal rasta kaahe ke biegaare hai? Dekhiehe tose ka hoi! ");
INSERT INTO hnsNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Parmeswar toke aisan sadja dei kie toe koetjh dien khaat andha hoi djaihe aur tanko na dekh paihe.” Bas toerante djaadoegar ke andhiaar aur dhoe-dhoer dekhaai lagal aur oe khaalie iedhar oedhar haath lapkaaike towe kie koi oke samhaar lewe. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tab laat djab dekhies, tab bieswaas kare lagal. Aur Prabhoe ke siektjha okar man me baith gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Tab Paulas aur okar saathie log djahaadj par Paafos se samoendar kaatke Perga sahar Pamfielia des me gail. Bakie hoewa se Johaanas Markas oelogke tjhorke Jeroesaalem lautke gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Aur Paulas log Perga se tjalte Antiokia sahar Piesiedia des me pahoetjal. Tab sabat ke dien oesab hoewa ke Israel log ke partjaar ke ghar me gail aur baithal. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tab djab barkwan Mosas ke kaanoen aur Parmeswar ke doesar sanesian ke poestak me se parh tjoekal, tab Paulas aur okar saathie se poetjhwaais kie: „Bhaai log, toelog djanta se koetjh hiemmat dewe waala baat bol sakieho?” ");
INSERT INTO hnsNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tab Paulas oethke aur haath se sankiaaike bolies: „Israel djaatie log aur sab doesar Parmeswar ke aadar kare waalan, soeno. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Parmeswar Israel djaat ke baap-daada ke aapan djaat ghat tjoenies raha. Tab djab oesabke aulaad pardesie ghat Egypte des me rahat raha, tab oe oesabke barhaais aur aapan barka saktie se hoewa se niekaar legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Aur lagbhag tjaalies baries lek maidaan me oe oelogke sab tjaal-tjalan sahies. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tab saatgo Kaanaan des ke djaat ke naas karke oe Israel djaatie ke oesabke des deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ekare baad tjaar sau patjaas baries bietal. Oe tem me Parmeswar djadj log ke baithaais oesabke tjalaawe khaatien. Aisane raha Parmeswar ke sanesia Saamoewel ke same talak. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tab oesab ek raadja maangies. Aur Parmeswar Benjaamen ke koel me se Kes ke betwa Saul ke tjaalies baries khaatien raadja banaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tab Saul ke hataaike oe Jesai ke betwa Daawied ke raadja banaais. Okare biese me oe bolies kie: ‘Daawied hamaar man laaik aadmie hai. Oe hamaar sab hoekoem poera kariega.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Aur ab Parmeswar Daawied ke aulaad me se ek batjaawe Waala pathaais, djaise oe Israel djaatie ke waada karies raha. Aur ie Jiesoe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Okar kaam soeroe howe se pahiele Johaanas dopoe kare waala sab Israel djaat se bolies raha kie: ‘Aapan kharaab tjalaawa tjhor de, ek naawa djiewan soeroe kar, aur bhie apane ke dopoe karwaaw.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aur djab Johaanas ke partjaar ke kaam poera hoi nagtjaail, tab oe bolies kie: ‘Soen, toelog sotje hai kie ham Kriest baatie, bakie aise na hai. Oe hamare baad aaiga. Oe etana maahaan hai kie ham okar djoeta oetaare laaik na baatie.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Bhaai log, toelog djaun Aabraaham ke aulaad hai, aur ekwan djaun bhie Parmeswar ke aadar kare hai, soeno! Ie batjaawe waala sanesa hamlog khaatien hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Parmeswar ke sanesian liekhies raha kie manai logan batjaawe Waala ke na apanaaiga. Ie baat har ek sabat ke dien par Israel ke partjaar ke ghar me parha hai. Aur djab Jeroesaalem ke manai log aur barkwan Jiesoe ke na maangat raha, tab oesab ie baat poera karies. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Aur tjaahe oelog okare me ekko kasoer na paais, tabbo oesab Pielaatas se poetjhies oke marwaai dhaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Aur djab oesab Parmeswar ke sanesian ke sab agwe ke liekhal baat poera karies raha, tab okar ekaat sanghatian oke kroes par se oetaar leis aur ek kabar me dhar deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bakie Parmeswar oke djie oethaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ekare baad oe apane ke tjaalies rodj dher dafe aapan saathie ke dekhaais, djaun okar sanghe Gaalielea diehaat se Jeroesaalem sahar gail raha. Aur ab ohielog Israel ke djaatie se okare biese me gawaahie dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Aur hamlog toelogke khoes khabar djanaaila kie Parmeswar aapan waada hamlogke baap-daada khaatien Jiesoe ke djie oethaawe dwaara hamlog khaat poera karies hai. Djaise okar gaana ke poestak ke doesara gaana me liekhal hai kie: ‘Toe hamaar Beta baate. Aadj ham sab koi ke djanaaila kie ham tor Baap baatie.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Parmeswar Jiesoe ke djie oethaais hai okar dehie ke kabhie na saran dewe khaatien. Oe bolies raha: ‘Djaun pawietr tjiedj ham Daawied ke waada karlie hai, oe ham djaroer toelogke debe.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Aur oe ek doesar gaana me liekhwaais hai kie: ‘Toe aapan pawietr Kamkarta ke dehie na saran deihe.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Daawied aapan tem me Parmeswar ke bietjaar poera karies. Tab oe mar gail aur okar mattie okar baap-daada lage paral. Okar dehie sar gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Bakie Parmeswar Jiesoe ke djie oethaais, aur okar dehie na saran deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bhaai log, toelogke tjaahie djaane ke kie hamlog okar dwaara paap ke tjhama ke biese me partjaar kariela. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosas ke kaanoen par tjale ke dwaara koi na paap me se batj sake hai. Bakie ab dje Jiesoe me bieswaas kariega, oe okar dwaara tjhoetkaara paaiga. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ohie se batjaaike rahiehe kie tose na howe djaise Parmeswar ke ek sanesia liekhies hai: ");
INSERT INTO hnsNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Are, Parmeswar ke nahakaare waalan, toelog tjakkariaaike bhaag djaihe! Djaun kaam Parmeswar toelogke tem me kariega, tjaahe koi toelogke djetana samdjhaai, tabbo toelog na mangiehe bieswaas kare.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tab djab Paulas aur Baarnaabaas partjaar ke ghar me se tjal gail, tab hoewa ke manai log oesabse poetjhies kie: „Aane waala sabat ke dien par toelog phien se lautke aihe auro baat bataawe khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Dher Israel djaatie log aur doesar djaat ke Parmeswar ke aadar kare waalan Paulas aur Baarnaabaas ke saath tjalat djaat raha. Djaite me oe doeno oelogse batiaais aur tieha deis Parmeswar ke bhalaai par bharosa karte rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tab ekwa sabat ke dien par sahar bhar aail Parmeswar ke sanesa soene khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bakie Israel ke djaatie djhoend dekhke Paulas aur Baarnaabaas ke djaran kare lagal aur abdjas lagaaike Paulas ke baat nahakaaries. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tab oe doeno bolies: „Hamlogke tjaahat raha pahiele Parmeswar ke baat Israel log se bataawe ke. Bakie toelog nahakaar deile aur dekhaile kie toelog sada khaatien Parmeswar sanghe rahe laaik ke na baate. Ohie khaatien ab hamlog doesar djaatie lage djaabe. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Prabhoe hamlogke hoekoem deis hai kie: ‘Ham toelogke tjoenlie hai sab djaatie ke djotie dewe ke, aur doenia ke kona talak iensaan ke batjaawe khaatien.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bas ie sab baat soenke doesar djaatie partjaar ke ghar me bahoet khoesie bhail aur bolies kie: „Prabhoe ke baat etana biesaal hai!” Aur djaun log ke diel Parmeswar tajaar karies raha sada ke lieje okar sanghe aapan djiewan bietaawe ke, oelog bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Aur Prabhoe ke baat oe diehaat me tjaaro alang phail gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bakie Antiokia sahar ke Israel log hoewa ke Parmeswar ke aadar kare waala bara ghar ke aurat logan aur doesar oetja dardja waalan ke Paulas aur Baarnaabaas ke biese me bahakaawe lagal. Tab oesab mielke oe doeno ke bahoet sataawe lagal aur aapan sahar ke aas-paas se bhagaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bas oe doeno aapan gor ke dhoer djhaarke hoewa se Iekoniam sahar gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aur Antiokia ke bieswaasie log khoesiaalie aur Pawietr Aatma se bhar gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Djab Paulas aur Baarnaabaas Iekoniam sahar pahoetjal, tab hoewa bhail djaise Antiokia sahar me bhail raha. Oelog partjaar ke ghar me djaaike aisan baat batiaais kie bahoet Israel djaat aur bhie dher Griek waalan Prabhoe me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bakie koetjh Israel log na maangat raha soene. Oelog doesar djaat ke bahakaaike bieswaasie bhaai ke biese me khaalie kharaab baat bolies. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tabbo Paulas aur Baarnaabaas koetjh same khaat hoewa rahat raha. Prabhoe par bharosa karke oelog be-dar se batiaat raha. Aur Prabhoe aapan bhalaai dekhaawe khaatien oesabse ek se ek barka kaam karwaais. Aisane dekhaail kie oelogke partjaar satj hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bakie sahar ke manai bat gail. Koi koi hoewa ke Israel log ke kait raha, aur koetjh Paulas log ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tab Israel djaat aur oelogke saamiel waalan aapan barkwan ke saath ekattha hoike sallaah karies pathaawal waalan par ieta bahaaike oesabke maar dhaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bakie Paulas log ke ie kharaab bietjaar ke sanes miel gail. Tab oesab Liekaonia des me se Liestra aur Derbe sahar aur hoewa ke aas-paas me bhaag gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aur hoewa par oelog Parmeswar ke khoes khabar bhie partjaar karies. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Liestra me ek aadmie paidaais se loendj raha. Okar gor me taagat na raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tab djab oe Paulas ke partjaar soenies, tab Paulas oke khoeb thiek se taakies aur dekhies kie oke bieswaas hai attjha howe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tab oe djor se bolies: „Toe oethke aapan gor par khara hoi dja.” ");
INSERT INTO hnsNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bas aadmie oethke khara bhail aur tjale lagal. Tab djab Liestra ke manai dekhies, tab oesab aapan bhaasa me bole lagal kie: „Dewta iensaan ke roep me hamlogke paas aail hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Aur oelog Baarnaabaas ke Sois dewta aur Paulas ke Hermes dewta ke naam deis. Paulas sab baat-tjiet karat raha, ohie se oesab oke Hermes dewta bolaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Sahar ke bahare Sois dewta ke mahal raha. Hoewa ke poedjaarie ekaatgo boel ke maala pahienaaike aur legail sahar. Oe maangat raha djanta ke saath pathaawal waalan khaatien baliedaan tjaharaawe. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bakie djab Baarnaabaas aur Paulas soenies, tab goessa ke maare aapan kapra tjier dhaaries. Aur manai ke djhoend lage dhaurke tjiellaaike bolies: „Are, bhaai log! Toelog ka dja hai kare? ");
INSERT INTO hnsNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Hamlog toelogke ner iensaan baatie, aur hamlogke otana saktie na hai. Hamlog ailie hai toelogse bataawe khaatien kie: ‘Aisan be-kaamiel tjalaawa tjhorke djienda Parmeswar ke baat soen. Oe aasmaan, dhartie, samoendar, aur eman sab tjiedj banaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bietal same oe doenia ke djaatie ke aapan man waala karan deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tabbo oe oesabke bhalaai karies. Oe paanie barsaaike aur barhia tem deike dher anaadj aur phal djamaais toelogke khoesie kare khaatien.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bakie Paulas tjaahe oelogke etana samdjhaais, tabbo djhoend maangat raha oelogke khaatien boel tjaharaawe. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bas etane me Antiokia aur Iekoniam sahar ke Israel log aail aur Liestra ke djanta se pathaawal waalan ke biese me kharaab baat bataais. Bas oesab Paulas ke ieta se bahaaike maarke sahar ke baahar hietj legail. Oelog sotjat raha kie oe mar gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bakie djab Liestra ke bieswaasie log djaaike oke gher leis, tab oe oethke khara bhail aur phien sahar me gail. Biehaan bhaile oe Baarnaabaas ke saath Derbe sahar gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbe sahar me oesab khoes khabar bataais, aur hoewa par dher manai Prabhoe ke tjela bhail. Tab oesab phien Liestra, Iekoniam aur Antiokia sahar lautke gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ie tieno sahar me oesab bieswaasie log ke hiemmat deis aapan bharosa Prabhoe par pakarle rahe ke. Oelogse bhie bataais kie: „Soen, Parmeswar ke raadj ke soekh miele se pahiele hamlogke bahoet moesiebat sahe ke parie.” ");
INSERT INTO hnsNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Aur har ek sahar ke iesaai samaadj me oelog barkwan ke baithaais. Tab baad me oelog bhoekha rahieke praatna karke oesabke Prabhoe ke oeppar saup deis. Oelog to okare me bieswaas karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tab oesab Piesiedia dharke Pamfielia des me pahoetjal. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Aur Perga sahar me bhie khoes khabar bataaike oesab aur aage gail Ataalia sahar. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Hoewa se oesab phien djahaadj par gail Antiokia sahar Sieria des me djaai ke. Ie sahar me oelog partjaar ke kaam khaatien Parmeswar ke bhalaai par saup dewal gail raha. Aur oelog ie kaam poera kar tjoekal raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ohie se oelog hoewa ke iesaai samaadj waalan ke ekattha bolaaike bataais kie Parmeswar oelogke dwaara kaun kaam karwaais hai. Aur kaise oe bhie doesar djaat khaatien rasta khol deis hai Jiesoe me bieswaas kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tab oelog auro dien khaatien Antiokia ke bieswaasie ke saathe rahat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tab ek dien ekaat Israel ke iesaai log Joedea diehaat se Antiokia sahar gail. Oelog Sieria des aur hoewa ke doesar djaat ke bieswaasie bhaai se partjaar kare lagal kie: „Djab toelogke hakiekat na hoi djaise Mosas ke kaanoen me liekhal hai, tab toelog na batj sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Bakie Paulas aur Baarnaabaas ek na raha aur oesab me djhagara bhail. Tab Antiokia ke iesaai log oe doeno ke aur ekaatgo doesar bieswaasie ke Jeroesaalem pathaais ie baat ke biese me hoewa ke pathaawal waalan aur iesaai ke barkwan se baat-tjiet kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tab Antiokia ke bhaai-bahien oesabke bieda kar deis. Jeroesaalem pahoetje se pahiele oesab Feniesia aur Saamaaria des ke bieswaasie log se bataais kie doesar djaat bhie aapan paap pastaaike Prabhoe me bieswaas kare lagal hai. Tab sab koi bahoet khoesie bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tab djab oesab Jeroesaalem pahoetjal, tab iesaai ke samaadj log aur oelogke barkwan aur bhie Prabhoe ke pathaawal waalan oesabke prem se bhiettar leis. Tab Paulas log bataawe lagal kie Parmeswar doesar des me oesabke dwaara kaun kaam karwaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bakie samaadj me ekaat bieswaasie log Fariesie raha. Aur oesab bole lagal kie: „Doesar djaatie ke iesaai ke tjaahie apane ke bhie hakiekat karwaawe ke aur Mosas ke kaanoen pakarle rahe ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tab pathaawal waalan aur barkwan ekattha hoike ie hoekoem ke biese me baat-tjiet kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tab djab oesab me ekta na raha, tab Petras khara bhail aur bolies: „Bhaai log, toelog djaane hai kie Parmeswar soeroe se hamme tjoenke sallaah karies kie doesar djaatie hamare dwaara khoes khabar soenke okare me bieswaas kare lagie. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","9","Oe har ek iensaan ke diel djaane hai. Okar aakhie ke saamne Israel aur doesar djaat ke bieswaasie ekahie hai. Ohie se oe aapan Pawietr Aatma ke ohoelogke deis hai aur oesabke diel bieswaas dwaara bhie safa karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tab toelog kaahe ke oke adjmaawe hai doesar djaat ke iesaai ke aisan bodjha oethwaawe ke dwaara? Hamlogke baap-daada aur hamlog to apane ie kaanoen ke bodjha na oethaai paawat rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Hamlog bieswaas kariela kie oelog aur hamlog khaalie Jiesoe Kriest ke bhalaai dwaara batj djaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bas barkwan tjoeppaai gail aur soene lagal kaise Baarnaabaas aur Paulas bataawe hai kie Parmeswar oelogke dwaara dher barka aur atjambho kaam doesar djaat ke bietj me karwaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tab djab oesab batiaai tjoekal, tab Jaakobas bolies ke: „Bhaai log, ab hamaar baat soeno. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Siemeon samdjhaais raha Parmeswar kaise soeroe se maangies sab doesar djaatie me se ek djaatie banaawe okar naam par tjale khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Aisane okar pahiele ke sanesian bhie liekhies raha: ");
INSERT INTO hnsNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Prabhoe bole hai kie: Ekare baad ham lautke aabe aur Daawied ke biegaral ghar phien se banaabe. Aur bhie djaun oman oekharke gieral hai, ham oke oethaaike thara karab, ");
INSERT INTO hnsNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","djeme sab doesar djaatie hamke khodje. Tab ham oesabke apanaaike aapan naam debe. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ham ie bietjaar soeroe se djaanat rahielie aur ham bhie poera karab.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ohie khaatien hamlogke na tjaahie doesar djaatie ke bieswaasie ke sotj me daar dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Bakie hamlogke tjaahie ek tjietthie liekhke oesabke djanaawe ke kaun tjiedj mienaahie hai. Naklie bhagwaan ke khaaik safa na hai, ohie se na khaai ke tjaahie. Oesabke na tjaahie tjhatjhoendar ke kaam kare ke. Auro khoen waala gos aur khoen bhie mienaahie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Dher dien se Israel ke djaatie har ek sahar me Mosas ke liekhal baat partjaar kare hai. Aapan partjaar ke ghar me sabat ke dien par oesab okar kaanoen parhaawe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tab pathaawal waalan aur Jeroesaalem ke iesaai samaadj ke barkwan hoewa ke bieswaasie bhaai log ke sanghe sallaah karies oesabke bietj me se koetjh aadmie log Paulas aur Baarnaabaas ke saathe Antiokia sahar Sieria des me pathaawe ke. Oesab Joedaas aur Sielaas ke tjoenies. Joedaas ke naam bhie Baarsaabaas raha. Oe doeno bieswaasie ke saamne barka naam ke aadmie raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Oesab ie tjaaro ke haathe ek tjietthie pathwaais. Eman liekhal raha: Hamlog Prabhoe ke pathaawal waalan aur Jeroesaalem ke iesaai ke barkwan baatie aur ie tjietthie liekhiela aapan doesar djaat me ke bhaai log khaatien djaun Antiokia sahar me, aur Sieria aur Sieliesia des me rahe hai. Pjaara bhaai log, toelog kaise baate? ");
INSERT INTO hnsNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Hamlog soenlie kie ie samaadj me se koetjh aadmie biena hamlogse koetjh bole toelogke paas aail. Oesab hakiekat ke hoekoem ke biese me toelogke tjienta me daar deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ohie se hamlog ek moeh hoike doei aadmie ke tjoenke pathailie aapan pjaara bhaai Paulas aur Baarnaabaas ke sanghe. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ie doeno hamlogke Prabhoe Jiesoe Kriest ke naam khaatien maangies aapan djaan dewe. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aur hamlog Joedaas aur Sielaas ke bhie pathaai deilie hai. Oesab tjietthie ke baat bhie samdjhaaiga. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Hamlog aur Pawietr Aatma sallaah karlie toelogke doesar hoekoem na dewe ke. Khaalie djaun djaroerie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Naklie bhagwaan khaatien tjaharaawal khaaik na khaihe. Khoen waala gos aur khoen bhie na. Aur tjhatjhoendar ke kaam na kariehe. Ie sab mienaahie hai aur thiek rahie djab toelog ie baat khiaal karte rahiehe. Attjha, barhia se rahiehe! ");
INSERT INTO hnsNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tab Jeroesaalem ke bieswaasie Paulas aur Baarnaabaas, Joedaas aur Sielaas ke bieda kar deis. Aur djab oe tjaaro Antiokia sahar pahoetjal, tab sab bieswaasie logan ke ekattha bolaaike aur tjietthie deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Aur djab oesab parhke soenaais, tab sab iesaai ie tieha dewe waala baat se bahoet khoesie bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Joedaas aur Sielaas Prabhoe ke sanesian bhie raha. Oe doeno Antiokia ke bhaai-bahien ke dher baat se hiemmat deike oesabke bieswaas barhaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tab djab oesab koetjh dien rahie gail raha, tab bieswaasie log oesabke lautaarke Jeroesaalem pathaai deis aur bolies: „Aapan pathaawe waalan se hamlogke naam se bol deihe kie: ‘Barhia se rahiehe.’ ”  ");
INSERT INTO hnsNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Bakie Sielaas Antiokia me rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulas aur Baarnaabaas bhie Antiokia sahar me rahie gail aur dher doesar log sanghe Prabhoe ke baat partjaar karies. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tab djab koetjh dien biet gail raha, tab Paulas Baarnaabaas se bolies: „Aaw, lautke tjalie aapan bhaai log ke paas har ek sahar me djaaha hamlog Prabhoe ke baat partjaar karlie rahielie. Tab hamlog dekh sakab kie oesab kaise hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Tab oe bolies: „Attjha, tjalie dja, aur Johaanas Markas ke bhie ledja.” ");
INSERT INTO hnsNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tab Paulas bolies: „Na, hamlog aisan aadmie ke na ledjaab. Pamfielia des me oe hamlogke tjhorke laut gail aur hamlogke sanghe aur aage kaam na karies hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bas oe doeno apane me takaraar karke etana doer hoi gail, kie Baarnaabaas Markas ke leike samoendar ke oepaar gail Siepras des. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bakie Paulas Sielaas ke tjoenies ledjaai khaatien. Tab Antiokia sahar ke bieswaasie bhaai log oke praatna me Parmeswar ke bhalaai par saup deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tab oe Sieria aur Sieliesia des gail hoewa ke iesaai samaadj log ke tieha dewe. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tab Paulas Derbe aur Liestra sahar me aail. Liestra me ek Tiemotias naam ke bieswaasie naudjawaan rahat raha. Okar maai ek Israel djaatie ke iesaai raha. Bakie okar baap Griek djaat ke raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tiemotias ke tjaal-tjalan Liestra aur Iekoniam sahar ke iesaai bhaai-bahien ke bahoet attjha lagat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulas maangat raha oke aapan sanghe ledjaai. Bakie hoewa ke Israel logan djaanat raha kie okar baap ek Griek ke aadmie raha. Ohie se oe pahiele okar hakiekat karwaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tab oesab ie sahar se oe sahar gail. Aur bieswaasie log se bataais kie Prabhoe ke pathaawal waalan Jeroesaalem ke iesaai ke barkwan sanghe sallaah karies raha kaun tjiedj doesar djaat ke iesaai khaatien mienaahie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Aisane sab iesaai ke bieswaas barhat djaat raha aur dien par dien auro manai bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tab Paulas aapan saathie sanghe Friegia aur Gaalaatsia diehaat me aur aage gail. Pawietr Aatma oesabke djanaai deis raha Aasia des me khoes khabar na partjaar kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tab djab oesab Miesia diehaat me pahoetjal, tab Bietienia diehaat maangat raha djaai. Bakie Jiesoe ke Aatma oesabke phien na djaain deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tab oesab Miesia diehaat dharke gail Troas sahar talak samoendar ke kienaare. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Oe raat me Prabhoe Paulas ke koetjh dekhaais. Oe ek Maasadonia diehaat ke aadmie thara dekhies. Aadmie ose bolies: „Ham tor gor gieriela, aaw samoendar ke oepaar Maasadonia me hamlogke sahaaita kare khaatien.” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Tab hamlog ohie laage kausies karlie Maasadonia diehaat djaai ke. Oe sapana dwaara hamlog samadjh gailie kie Parmeswar hamlogke bolwaais hoewa ke manai log se khoes khabar partjaar kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tab hamlog djahaadj se Troas sahar se samoendar ke oepaar gailie aur Saamotraaka diehaat se paas hoi gailie. Biehaan bhaile hamlog aur aage Niaapoles sahar ke or gailie. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tab djab hamlog oe sahar me pahoetjlie, tab paidar Fielepie gailie. Oe sahar Maasadonia diehaat ke ie bhaag ke sab se kaamiel waala sahar hai. Roma djaat log oe sahar banaais raha, aur Roma ke kaanoen thiek se maanal dja hai. Hoewa par hamlog koetjh dien khaatien rahat rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tab sabat ke dien hamlog sahar me se nadie lage gailie. Hamlog sotjlie kie hoewa par ek Israel djaat ke praatna ke djagaha hoi. Tab oe djagaha par hamlog ekaat saamiel aurat ke bhetailie aur baithke oesabse koetjh baat batailie. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Oman ek Liedia naam ke aurat raha. Oe Tiaatiera sahar me tjatak liela rang ke kapra betjat raha aur oe Israel ke Parmeswar ke barka maanat raha. Tab Prabhoe aisan karies kie oe aapan diel kholke Paulas ke partjaar par dhiaan kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Tab oe aapan ghar-paraanie sanghe dopoe bhail. Ekare baad oe hamlogse bolies: „Djab toelog dekhle kie ham sattje ke Prabhoe me bieswaas kariela, tab aaw hamaar ghar me rahoe.” Aur bahoet bole se hamlog gailie. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Bas ek dien djab hamlog praatna ke djagaha gailie, tab ek kienal goelaam aurat ke bhetailie. Okar oeppar bhoet raha. Aurat okar dwaara djanta se aagam ke baat bataawat raha aur aisane aapan barkwan khaatien bahoet paisa kamaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Oe hamlogke aur Paulas ke paatjhe tjale lagal aur tjiellaaike bolies: „Ie aadmie sab se maahaan Parmeswar ke kamkartan hai. Iesab djanaawe hai Parmeswar kaise maange hai iensaan ke aapan aane waala goessa me se batjaawe!” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Aisane oe dher dien talak hamlogke paatjhe tjiellaat bolat djaat raha. Tab djab Paulas na sahie paais, tab oe bhoet se bolies: „Ham toke Jiesoe Kriest ke naam se hoekoem deila kie aurat par se hat dja.” Bas toerante saitaan okar oeppar se bhaag gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tab djab goelaam aurat ke barkwan dekhies kie oesabke paisa ke rasta band hoi gail hai, tab oesab Paulas aur Sielaas ke ghietjke legail ekdam badjaar talak. Hoewa par sahar ke barkwan baithat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tab oesab barkwan ke aage doeno ke kasoer dewe lagal. Bolies: „Ie mardaana log hamlogke sahar me haltjal matjaawe hai. Oelogan Israel ke djaatie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Oesab aisan hoekoem siekhaawe hai djaun Roma ke djaatie khaatien mienaahie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tab hoewa ke djaatie djoetke bhie doeno ke oeppar goessaail. Bas barkwan Paulas log ke kapra tjier-phaarke oetarwaais aur tjhatkoen se oesabke khoeb marwaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tab oesabke djahal me daar deis. Aur bhie djahal ke rakhwaala ke hoekoem deis oesabke khoeb thiek se rakhaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ohie khaatien oe oesabke djahal ke sab se bhiettar kothrie me legail. Aur oesabke gor doei djabar lakarie ke bietj me taala kar deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tab bietj raat me Paulas aur Sielaas Parmeswar se praatna karies aur giet gaais okar aadar kare khaatien. Aur sab djahalian soenat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bas atjakke me bhoeidol aail. Oe etana djabar-djas waala raha kie djahal ekdam se hiele lagal. Bas ohie laage sab kamaarie aur bhie djahalian ke ketie khoel gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tab djahal ke rakhwaala djab tjaukke djaagal, tab dekhies kie djahal ke kamaarie khoelal hai. Bas dar ke maare oe aapan talwaar niekaaske maangat raha aapan djaan maare. Oe sotjies kie sab djahalian bhaag gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bakie Paulas tjiellaaike bolies: „Apane ke koetjh na kar! Hamlogan hia baatie!” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tab rakhwaala tjieraag maangies aur haalie se bhiettar gail. Hoewa par oe kaapat Paulas aur Sielaas ke aage gaathie par gieral. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tab oe doeno ke kothrie se bahare legail aur poetjhies: „Bhaija, Parmeswar ke goessa me se batj djaai khaatien ham ka kar sakab?” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tab oesab bolies: „Prabhoe Jiesoe me bieswaas kar, tab ghar-paraanie sanghe batj djaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Aur oesab Prabhoe ke khoes khabar oke aur okar ghar bhar ke samdjhaawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Oe raat me rakhwaala oesabke ghaaw dhois. Tab oe toerant aapan sab ghar-paraanie sanghe dopoe leis. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tab oe Paulas aur Sielaas ke leike aapan djahal ke oeppar ghar me gail aur oesabke baithaaike khaaik deis. Oe etana khoesie raha kie oe aapan ghar bhar sanghe Parmeswar me bieswaas kare lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Biehaan bhaile sahar ke barkwan ekaat siepaahie ke pathaais rakhwaala se bataawe ke kie: „Ie mardaana log djaai sake hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tab rakhwaala Paulas se bolies: „Barkwan sanesa pathaais kie aadj se toelog tjhoet gaile hai. Barhia se djaiho!” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bakie Paulas siepaahie log se bolies: „Hamlogke Roma ke djaatie ke hak hai, tabbo kalhia oesab hamlogke biena khodjie kare sab koi ke aage marwaais aur djahal me dharwaais. Aur ka, oelog maange hai hamlogke aadj tjoeppe se pathaai dewe? Oesabse bol de bhoelaai djaai! Oelogke tjaahie apane se aawe ke hamlogke niekaare.” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Siepaahie log gail ie sab baat sahar ke barkwan se bataawe. Tab barkwan djab soenies kie Paulas aur Sielaas ke Roma ke djaatie ke hak hai, tab oelogke dar lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tab oesab gail maafie maange aur doeno ke kaida se djahal me se legail. Bolies: „Barhia rahat kie ab se toelog ie sahar se tjal djaite.” ");
INSERT INTO hnsNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tab Paulas aur Sielaas djahal se Liedia ke ghare gail. Hoewa par oelog bieswaasie bhaai-bahien se bhet karies aur oelogke tieha deis. Tab oesab sahar se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tab oe doeno Amfiepoles aur Aapolonia sahar dharke Tesaalonieka sahar me gail. Hoewa Israel ke djaatie ke ek partjaar ke ghar raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Djaise Paulas ke nem raha djaai ke, aisahie oe pahiele hoewa gail aur tien sabat ke dien talak manai log ke Parmeswar ke liekhal baat parhaawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Oe safa se samdjhaawat raha kie Kriest ke doekh oethaawe ke tjaahat raha aur bhie djie oethe ke. Bolies: „Ie Jiesoe djaun ke biese me ham partjaar kariela, ohie Kriest hai, oe Parmeswar ke baithaawal waala Raadja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tab koetjh Israel ke djaatie oe baat me bieswaas kare lagal aur Paulas aur Sielaas me saamiel hoi gail. Aur ek barka djhoend Griek waalan aur dher barka naam ke aurat bhie bieswaasie hoi gail. Pahiele oesab Israel djaat ke sanghe Parmeswar ke aadar karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bakie doesar Israel log Paulas logan ke djaran kare lagal, aur koetjh daam par ke djahoewa ke leike sahar bhar me haltjal oethaais. Bas oesab ek Jaason aadmie ke ghare gail Paulas aur Sielaas ke khodje. Oesab maangat raha doeno ke djaatie aur sahar ke barkwan ke aage ledjaai. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Tab djab oelogke na paais, tab oesab Jaason ke aur koetjh doesar iesaai bhaai ke pakarke raadj tjalaawe waalan ke aage ghietjke legail. Aur tjiellaaike bole lagal kie: „Jaason koetjh manai log ke aapan ghar me lei leis hai aur oelog doenia bhar me haltjal matjaawe hai. Oesab Roma ke maahaaraadja ke hoekoem takaraar kare hai. Oelog bole hai kie ek Jiesoe naam ke doesar raadja hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Djab sahar ke barkwan aur djaatie logan soenies, tab ghabaraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bakie Jaason log koetjh paisa bharies, tab barkwan oesabke tjhor deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tab djab raat bhail, tab Tesaalonieka ke iesaai bhaai log toerante Paulas aur Sielaas ke Beria sahar pathaai deis. Aur oe doeno djab pahoetjal, tab phien Israel ke partjaar ke ghar me gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Hoewa ke Israel logan ke tjaal-soebhaaw Tesaalonieka waalan se auro barhia raha. Oesab khoeb dhiaan lagaaike Paulas ke partjaar soenies. Aur rodj oesab Parmeswar ke poestak me khodjke parhat raha djaane khaat kie oisahie hai kie na. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tab dher manai log Prabhoe Jiesoe me bieswaas kare lagal. Eman bhie dher barka Griek mardaana aur aurat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bakie Tesaalonieka me Israel djaat ke pata mielal kie Paulas Beria sahar me Parmeswar ke baat partjaar kare hai. Tab oelog toerant aaike hoewa par bhie hartaal matjaawe lagal aur aisane hoewa ke djaatie log ghabaraai gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bas Beria ke iesaai bhaai log Paulas ke haalie se samoendar ke or pathaai deis. Bakie Sielaas aur Tiemotias hoewe rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Koetjh Beria ke iesaai log Paulas ke Aatene sahar me pahoetjaais. Oesabke laute se pahiele Paulas bolies kie: „Sielaas aur Tiemotias ke haalie se hamaar paas pathaai deihe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Tab djab oe Aatene me Sielaas aur Tiemotias ke agorat raha, tab dekhies sahar bhar me khaalie naklie bhagwaan ke moertie dharal hai. Ie tjiedj oke bahoet kharaab lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Aur oe partjaar ke ghar me gail Israel log se aur doesar djaatie ke Parmeswar ke aadar kare waalan se baat-tjiet kare. Badjaar me oe bhie rodj manai se batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Hoewa ke parhal waalan me se koetjh Epiekoeros aur Stowa ke tjela log raha. Oesab Paulas ke barka baat bole lagal. Tab apane me poetjhies: „Ie djaun etana batia hai, oe hamlogke kaun tjiedj maange hai djanaawe?” Bakie doesarkwan bolies: „Hamare djaan me ie kauno bhagwaan ke biese me batia hai.” Oesab soenat raha kie Paulas khoes khabar Jiesoe ke aur okar djie oethe ke biese me partjaar kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tab oelog ose poetjhies: „Bhaai, tjalie hamlogke saath.” Oesab oke Aareopaagas pahaar par sahar ke parhal waalan ke aage legail. Hoewa par oesab ose poetjhies: „Toe kaun naawa partjaar soenaawe hai? ");
INSERT INTO hnsNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hamlog aisan baat kabhie na soenlie aur maangiela ekar matlab djaane.” ");
INSERT INTO hnsNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Sab Aatene ke manai aur bhie hoewa ke doesar djaatie log dien bhar khaalie maangat raha naawa bietjaar ke biese me koetjh bole kie to soene. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tab Paulas sabha ke aage thara hoike bolies: „Aatene ke manai log, ham toelogke sahar me dekh sakiela kie toelog dher maaliek ke ieddjat kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Djab ham sahar me ghoemat rahielie, tab ham toelogke pawietr djagaha dekhlie. Tab ham bhie ek baliedaan ke tafra ke dekhlie djaun par liekhal hai ‘Ekgo andjaan Eswar khaatien.’ Toelog na djaane hai kie oe ke hai, tabbo toelog okar aadar kare hai. Aur ab ham okar biese me partjaar karab. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Oe Parmeswar hai aur doenia banaais hai. Oe swarag aur dhartie ke Prabhoe hai. Oe manai ke banaawal mahal me na rahe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Oke iensaan ke sewa djaroerie na hai. Oe apane sab koi ke djiewan, saas aur har ek tjiedj dewe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Oe ek aadmie se sab djaatie ke banaais hai doenia bhar me rahe khaatien. Oe bhie sallaah karies raha oesab kaaha rahiega aur kab talak djiega. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Oe maangat raha kie oesab kausies karke khodjke oke paai djaai, tjaahe oe hamlogse doer na hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Oe hamlogke djiejaawe hai aur tjalaawe hai, aur hamlog abbe talak okare me baatie. Toelogke ekaatgo gaana banaawe waalan gaais hai kie: ‘Hamlog okare me se oetpan bhailie.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Djab hamlog okare me se oetpan bhailie hai, tab hamlog kaise sotj sakiela kie Parmeswar sona, tjaanie ja patthar ke moertie ghat lage hai? Iesab khaalie iensaan ke sotj-bietjaar hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Parmeswar oe tem tjhor deis hai djaun me manai log oke na djaanat raha. Bakie ab oe doenia bhar ke iensaan ke djanaawe hai kie oesabke tjaahie aapan kharaab tjalaawa tjhor dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Oe ek dien dharies hai djab oe doenia bhar ke oeppar sattjaai se faisala karwaaiga. Ie kaam kare khaatien oe ek aadmie tjoenies hai. Aur dekhaawe khaat kie ohie aadmie sab iensaan ke djadj rahiega, oe oke djie oethaais hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tab djab manai log soenies kie ekgo aadmie djie oethaawal gail hai, tab ekaatgo tiebolie maare lagal. Bakie doesarkwan bolies: „Hamlog ie baat ke biese me phien se maangiela soene.” ");
INSERT INTO hnsNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Aisane Paulas sabha me se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bakie koetjh log okare me saamiel hoi gail aur Prabhoe Jiesoe me bieswaas kare lagal. Oelog me se ek Dioniesias naam ke sabha ke barka aadmie raha, ek Daamaares naam ke aurat, aur bhie ekaat doesar hoewa ke manai log. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ekare baad Paulas Aatene sahar tjhorke Korente sahar gail. Hoewa par oe ek Israel ke aadmie ke bhetaail. Okar naam Aakwela raha. Oe aadmie Pontas diehaat ke raha aur Roma sahar se aail raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","3","Maahaaraadja Klaudias hoekoem deis raha kie sab Israel ke djaatie log ke tjaahie Roma sahar se tjal djaai ke. Ohie se Aakwela aapan aurat Presela saathe Ietaalia des tjhorke Korente me aail raha. Tab Paulas oesabke ghare gail aur Aakwela ke sanghe kaam kare lagal. Oe doeno to tjamra marai banaawe waalan raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Har ek sabat ke dien Paulas hoewa ke partjaar ke ghar me Israel aur Griek des ke manai log se baat-tjiet karat raha oesabke Prabhoe Jiesoe me bieswaas karwaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Tab djab Sielaas aur Tiemotias Maasadonia diehaat se Paulas lage pahoetjal raha, tab oe na khaalie sabat ke dien par Parmeswar ke khoes khabar partjaar karies, bakie rodj. Oe Korente ke Israel log ke barhia se samdjhaais kie Jiesoe Parmeswar ke Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bakie djab oelog djabarai karke Jiesoe ke bedjatie kare lagal, tab Paulas aapan kapra ke dhoer djhaarke bolies: „Aadj se hamse aur toelogse koetjh ke kaam na hai. Djab toelog Parmeswar ke goessa me se na batj djaihe, tab hamaar kasoer na hai. Ab se ham doesar djaat ke paas djaabe partjaar kare.” ");
INSERT INTO hnsNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Bas oe partjaar ke ghar tjhorke bagale ke ghar me gail. Hoewa ek Tietsias Jastas naam ke aadmie rahat raha. Oe sattja Parmeswar ke aadar karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tab partjaar ke ghar ke ek barkwa aur okar ghar bhar Prabhoe me bieswaas kare lagal. Okar naam Krespas raha. Aur bhie dher doesar Korente ke manai log Paulas ke partjaar soenke bieswaasie hoi gail aur apane ke dopoe karwaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Oe raat ke Prabhoe apane ke Paulas ke dekhaais aur bolies: „Paulas, na dera! Toe kholke partjaar karte rahiehe. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ham tore saathe baatie aur koi toke kharaabie na kar sakiega. Ie sahar me dher manai hamaar hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tab se Paulas der baries talak Korente me raha hoewa ke manai ke Parmeswar ke baat siekhaawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Bakie djab Galio Aakhaaja diehaat ke laat bhail, tab sab hoewa ke Israel log ek hoike Paulas ke okar aage legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Oesab bolies: „Ie aadmie siekhaawe hai kie hamlogke tjaahie Parmeswar ke aisan rakam se ieddjat kare ke djaun Israel ke kaanoen me mienaahie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Tab Paulas maangat raha koetjh batiaai. Bakie laat oke mauka na deis aur kasoer dewe waalan se bolies: „Are, Israel log, soen. Djab toelogke orhan ek kharaab ja djaanmarwa ke kaam ke biese me rahat, tab ham toelogke baat mantie. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Toelog khaalie koetjh baat koi ke naam aur toelogke kaanoen ke biese me djhagara kare hai. Ham aisan tjiedj ke biese me na maangiela faisala kare. Toelog apane se sallaah kariehe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Aur oe oesabke khaderwaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bas hoewa ke djoetal aadmie partjaar ke ghar ke barkwa Sostenes ke pakarke legail aur oke laat ke aage khoeb maaries. Bakie laat ke phiekier na raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Tab djab Paulas dher dien Korente sahar me raha, tab oe hoewa ke bhaai logan se biedaai leike Kenkrejen sahar me gail. Oe Parmeswar ke koetjh waada karies raha, ohie se oe hoewa par aapan baar katwaais. Tab oe djahaadj se Sieria des gail. Presela aur Aakwela okar sanghe bhie gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tab djab oesab Efese sahar me aaike pahoetjal, tab Paulas partjaar ke ghar me gail aur hoewa ke Israel log se batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bakie djab oesab ose poetjhies: „Ekaat dien auro na rahiehe?” tab oe bolies: „Na, ie tem par ham na rahie sakiela.” ");
INSERT INTO hnsNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Aur djab oe djaai lagal, tab bolies: „Djab Parmeswar maangie, tab ham toelogke lage phien se lautke aabe.” Tab oe djahaadj se Efese sahar se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tab djab oe Sesaarea sahar me pahoetjal, tab oe hoewa ke iesaai samaadj log se bhet karies. Tab oe Antiokia sahar Sieria des me gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Aur koetjh dien hoewa rahieke oe phieno tjal gail Gaalaatsia aur Friegia diehaat me hoewa ke sab bieswaasie ke hiemmat dewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tab oe same par Efese sahar me ek Aapolos naam ke aadmie aail. Oe ek Israel aadmie raha aur Aaleksaandria sahar ke raha. Oe Parmeswar ke sab liekhal baat me bahoet parhal raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Oe Prabhoe Jiesoe ke rasta ke biese me bhie siekhle raha aur phor-phorke okare biese me batiaat aur siekhaawat raha. Bakie oe khaalie Johaanas dopoe kare waala ke dopoe ke biese me djaanat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Oe aadmie Efese ke partjaar ke ghar me be-dar se partjaar kare lagal. Tab djab Presela aur Aakwela okar partjaar soenies, tab oesab oke bolaaike aapan ghare legail aur Parmeswar ke rasta ke biese me auro barhia se samdjhaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tab djab Aapolos sallaah karies Aakhaaja diehaat Griek des me djaai ke, tab Efese ke bieswaasie bhaai log maangat raha oke sahaaita kare. Ohie se oesab Aakhaaja ke bieswaasie log khaatien ekgo tjietthie pathaais kie oesabke tjaahie Aapolos ke barhia se sewa kare ke. Tab djab oe hoewa par pahoetjal, tab Parmeswar ke bhalaai dwaara oe sab bieswaasie khaat kaamiel raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Oe Parmeswar ke baat parhke kholke dekhaais kie Israel log ke sotj-bietjaar na thiek hai aur kie Jiesoe Parmeswar ke Kriest hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Djab Aapolos Korente sahar me raha, tab Paulas Aasia des ke habara djaaike Efese sahar me pahoetjal. Hoewa par oe ekaat bieswaasie log se bhet karies. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Tab baate baat me Paulas oesabse poetjhies: „Djab toelog bieswaas kare lagale, tab toelogke oeppar Pawietr Aatma aail hai kie na?” Tab oesab bolies: „Hamlog Pawietr Aatma ke biese me kabhie na soenlie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tab oe poetjhies: „Tab kaise dopoe bhaile hai?” Oesab bolies: „Johaanas dopoe kare waala ke rakam se.” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Tab oe bolies: „Johaanas manai log ke dopoe karat raha djab oesab aapan paap pastaaike maangat raha ek naawa djiewan soeroe kare. Oe djaatie se bolies kie: ‘Hamare baad koi aaiga aur toelogke tjaahie okare me bieswaas kare ke.’ Oe Jiesoe ke biese me batiaat raha.” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tab djab oesab ie baat soenies, tab apane ke Prabhoe Jiesoe ke naam me dopoe karwaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","7","Oesab lagbhag baara mardaana raha. Tab djab Paulas oelog par haath rakhies, tab Pawietr Aatma oesabke oeppar aail. Bas oesab okar dwaara doesar doesar bhaasa me Parmeswar ke sanesa bataawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulas tien mahienna talak Efese sahar ke Israel ke partjaar ke ghar me be-dar se samdjhaawat raha kie Parmeswar maange hai iensaan ke djiewan me raadj tjalaawe. Oe dher baat se kausies karies hoewa ke manai ke man badalwaawe ke aisan djiewan bietaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Bakie koetjh aadmie thethar raha. Oelog sab koi ke aage Prabhoe ke rasta ke biese me eksoer kharaab baat bolat raha. Bas Paulas aapan tjela leike partjaar ke ghar me se tjal gail. Ohie dien se oe rodj Tieranas ke skoel me khoes khabar ke biese me batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Oe doei baries aisane hoewa par partjaar karat raha. Ie rakam se sab Aasia des ke, Israel ke aur bhie Griek des ke manai log soenies kie Prabhoe kaun baat djanaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Aur Parmeswar Paulas dwaara bahoet atjambho kaam karwaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Manai log Paulas ke pattie aur dhotie bemarian ke paas ledjaaike oelogke oeppar rakhies. Tab oesab attjha hoi gail aur bhoet log tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Efese sahar me ek Israel djaat ke agwa ke barkwa raha. Okar naam Skewa raha. Oke saat betwan raha. Oesab sagaro ghoemke bhoet niekaarat raha. Tab ek rodj oesab hiemmat dharke gail aur bolies: „Ham tore me se bhoet niekaasiela Jiesoe ke naam se djaun ke biese me Paulas partjaar kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bakie bhoet bolies: „Ham Jiesoe ke djaaniela, aur Paulas ke bhie, bakie toelog ke baate?” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Bas aadmie djaun par bhoet raha, oe oesabke maarke aapan bas me lei leis. Oke etana taagat raha kie oelogke biena kapra se aur khoenaawal dehie se bhaage ke paral. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Aur sab hoewa ke Israel aur Griek manai log djaan gail kie ka bhail hai. Oesab ghabaraai gail aur apane me Jiesoe Kriest ke naam ke biese me batiaai lagal kie oe ketana maahaan hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tab bieswaasie logan me se dher djane aapan paap pastaaike aail bataawe oelog kaun kharaab kaam karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Koetjh manai odjhaai karies raha. Oelog aapan odjha ke poestak laaike sab koi ke aage djaraai deis. Djab oesab poestak ke daam djories, tab patjaas hadjaar tjaanie ke paisa bhail. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tab auro manai Prabhoe ke sanesa soenies aur oelogke bieswaas barhe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tab djab ie sab tjiedj biet gail, tab Paulas sallaah karies Maasadonia aur Aakhaaja diehaat dharke Jeroesaalem sahar djaai ke. Oe bolies: „Djab ham koetjh dien khaatien hoewa par gailie hai, tab ham maangiela Roma sahar dekhe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tab oe aapan saathie me se Tiemotias aur Eraastas ke Maasadonia pathaais. Bakie oe apane koetjh tem khaatien Aasia des me rahie gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tab ohie tem par Efese me Prabhoe Jiesoe ke rasta ke biese me ek barka haltjal-matj oethal. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Hoewa par ek Demetrias naam ke aadmie raha. Oe dher Artemes dewie ke mahal tjhota roep me banaaike betjat raha. Aur ie kaam dwaara oe aur okar saamiel waalan bahoet paisa kamaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ek dien oe sab barkwan aur kamkartan ke ekattha bolaaike bolies kie: „Bhaai logan, toelog djaane hai kie ie kaam se hamlog bahoet paisa kamaaila. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ab Paulas bole hai kie: ‘Manai ke haathe se banaawal bhagwaan sattja bhagwaan na hai.’ Toelog apane dekhle aur soenle hai kie ie rakam se oe na khaalie Efese me, bakie Aasia des bhar me dher manai ke sotj-bietjaar badale hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Djab oe aise partjaar karte rahie, tab na khaalie hamlogke kaam patjharie, bakie bhie Artemes dewie ke mahal ke koi na taakie. Aasia aur doenia bhar ke manai Artemes dewie ke ab talak ieddjat kare hai, bakie ab oesab oke bhoelaai djaai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tab djab djoetal manai log ie baat soenies, tab bahoet goessaail aur tjiellaai lagal kie: „Efese sahar ke Artemes dewie bahoet maahaan hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Bas sahar bhar ke manai oesabke tjiellaahat soenke ghabaraai gail aur sab ek djhoend hoike oe djagaha par phaat paral djaaha Efese ke manai log hardam sabha lagaawat raha. Oesab Paulas ke doei saathie Gaajas aur Aarestaarkas ke ghietjke legail. Oe doeno Maasadonia diehaat ke raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Tab djab Paulas maangat raha djhoend ke bietj me djaai, tab okar tjela log oke rokies. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ekaatgo Aasia des ke barkwan bhie Paulas ke sanghatian raha. Ohoelog oke mienaahie karies. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Etane me djhoend waalan bahoet halla kare lagal. Sab koi ohie me tjiellaai aur dher log na djaanat raha kie oesab kaahe ke djoetal hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Tab hoewa ke Israel log ek Aaleksaandar naam ke aadmie ke aapan gawaahia banaaike manai ke djhoend me se aage pathaais. Oe sankiaais kie oe maange hai koetjh bole. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bakie djab manai log tjienhies kie oe ek Israel ke aadmie hai, tab oelog ek moeh hoike doei ghanta talak ekke baat tjiellaaike bolies: „Efese sahar ke Artemes dewie bahoet maahaan hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tab sahar ke mantrie oesabke moeh band karwaai deis. Oe bolies: „Bhaai log, soen! Ke na djaane hai kie Efese ke djanta log ke oeppar Artemes ke mahal saupal hai, aur bhie okar moertie djaun baadar me se gieral hai. Hamlogke tjaahie oke dekh-bhaal kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ie baat koi na nahakaar sake hai! Ohie se toelogke na tjaahie etana tjiellaai ke aur biena sotj-bietjaar se koetjh kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Toelog ie mardaana log ke hia laile hai, bakie iesab mahal me se koetjh na tjorie karies aur hamlogke dewie ke bedjatie bhie na karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Djab Demetrias aur okar saathie log koi ke biese me maange hai orhan dewe, tab oesabke tjaahie djadj kie to laat ke paas djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Aur djab toelog aur koetjh maangat hoihe, tab djaatie ke sabha me kaanoen se faisala howe ke tjaahie. ");
INSERT INTO hnsNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Hoi sakie kie hamlogke aadj ke hartaal ke biese me kasoer mieliega. Hamlog aapan barkwan se na bataai sakab kaahe ke hamlog ekattha bhailie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ie sab baat se oe djaatie log ke ghare pathaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Hartaal ke baad Paulas sab Efese sahar ke bieswaasie ke bolwaais aur oesabke hiemmat deis. Tab oe oesabke tjhorke Maasadonia diehaat gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Oe djaite me hoewa ke bieswaasie log ke dher baat batiaaike tieha deis. Aisane oe Griek des me pahoetjal. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Hoewa par oe tien mahienna raha. Tab oe tajaar karies djahaadj se Sieria des djaai ke. Bakie djab oe soenies kie hoewa ke Israel log maange hai oke maar dhaare, tab oe sallaah karies Griek des se phieno Maasadonia diehaat dharke Aasia djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Beria sahar ke Sopaatar djaun Peras ke beta raha, Tesaalonieka sahar ke Aarestaarkas aur Sekandas, aur Derbe sahar ke Gaajas aur Tiemotias, aur Aasia des ke Tiekiekas aur Trofiemas Fielepie sahar talak okar sanghe gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Oelog hoewa se Troas sahar gail raha aur hoewa par hamlogke agorat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tab djab Paasan ke tiewhaar biet gail, tab hamlog Fielepie se djahaadj par bhie Troas gailie. Tab paatj rodj baad hamlog hoewa par pahoetjlie aur ek hapta talak oelogke sanghe rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Djab hamlog hapta ke pahiela dien par ekattha bhailie rahielie bret toere Jiesoe ke maut jaad kare khaatien, tab Paulas hoewa ke bieswaasie log khaatien partjaar kare lagal. Oe maangat raha ekwa dien hoewa se tjal djaai, ohie se oe bietj raat talak batiaat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Hamlog ek oeppar ke kamra me baithal rahielie aur hoewa par dher tel ke tjieraag barat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Khierkie ke lankie par ek Oitiekas naam ke naudjawaan baithal raha. Oke bahoet onghaai lagal raha. Tab djab Paulas eksoer batiaat raha, tab oe aapan onghaai na samhaar paais aur oeppar se nietje gier paral. Aur djab oesab oke oethaais tab dekhies kie oe maral hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Tab Paulas nietje gail aur oke dapkaais. Tab oe samaadj waalan se bolies: „Na row! Oe djieje hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tab oe phieno oeppar gail aur sabke sanghe bret toerke bhodjan karies, aur oe phien partjaar kare lagal djab lek andjor na bhail. Tab oe hoewa se tjal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bieswaasie log naudjawaan ke okar ghare legail aur bahoet tieha paais. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulas sallaah karies raha Troas se paidar Asas sahar djaai ke. Tab hoewa se oe hamlogke sanghe aur aage djaat. Ohie se hamlog oke tjhorke djahaadj se gailie. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Tab djaise oe Asas me pahoetjal, oisane oe hamlogke lage aail. Tab hamlog oke djahaadj me leike Mietielene sahar gailie. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Djab biehaan bhail tab hamlog gailie Kios des ke kienaare talak. Aur djab phien saber bhail, tab oepaar gailie Saamos des ke alang. Tab tiesara dien par hamlog Efese sahar paas hoi gailie aur Mielete sahar me pahoetjlie. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulas ke tem na raha Efese me oetare ke. Oe na maangat raha dher dien Aasia me rahe, bakie oe maangat raha Penkstar ke tiewhaar se pahiele Jeroesaalem me pahoetje. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ohie se oe Mielete sahar se kauno se Efese ke iesaai samaadj ke barkwan ke bolwaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Tab djab oesab pahoetjal, tab oe bolies: „Toelog djaane hai kie ham ie diehaat me aaike pahiela dien se khaalie Prabhoe khaatien aapan djiewan bietailie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ham tjhota banke aapan kaam karat rahielie. Israel log dher dafe maangat raha hamaar djaan lewe aur hamme bahoet doekh oethaawe ke paral. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tabbo ham toelogke aage aur bhie ghare ghar Prabhoe ke khoes khabar soenailie aur siekhailie. Ham koetjh na tjhiepailie djaun me toelogke faida mielat. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ham Israel ke aur Griek des ke manai se ketana bollie rahielie kie oelogke tjaahie aapan paap pastaaike hamlogke Prabhoe Jiesoe me bieswaas kare ke aur Parmeswar ke rasta par tjale ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Aur dekh, ab Pawietr Aatma maange hai kie ham djaroer se djaroer Jeroesaalem djaai. Ham na djaaniela kaun tjiedj hamme hoewa agore hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ham khaalie djaaniela kie oe hamke ie sahar se oe sahar djanaawe hai kie hamme djahal djaai ke aur doekh sahe ke parie. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bakie ham aapan djiewan ke tanko na sotjiela. Prabhoe Jiesoe hamme bolies hai sagaro khoes khabar soenaawe ke kie Parmeswar ke bhalaai ketana barka hai. Aur ham khaalie maangiela ie kaam poera kare. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ham toelogke bietj me bhie ghare ghar djaaike Parmeswar ke raadj ke biese me partjaar karlie hai. Bakie ab ham djaaniela kie toelog hamme phieno na dekhiehe. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ohie se ham toelogke djanaaila kie djab koi sada ke lieje Parmeswar se alag hoi djaai, tab hamaar kasoer na hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Har ek tjiedj djaun Parmeswar aapan barka gjaan aur bietjaar me sallaah karies hai iensaan khaatien kare ke, ham ie baat phor-phorke batailie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ohie se toelog apane ke aur iesaai samaadj ke khiaal kariehe. Pawietr Aatma oesabke toelogke oeppar saupies hai. Oesabke thiek se dekh-bhaal kariehe, djaise rakh waalan aapan bhera ke. Parmeswar oesabke apane khaatien aapan Beta ke khoen dwaara algiaais hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ham djaaniela kie djab ham hia se tjal djaab, tab kharaab aadmie log toelogke samaadj me bhiettar aaiga iesaai ke bieswaas biegaare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Aur toelogke bietj me se bhie koetjh aadmie djhoeth baat partjaar kariega bieswaasie log ke aapan alang lewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ohie se batjaaike rahiehe aur khiaal kariehe kie tien baries talak ham raat aur dien toelog me se har ek ke aasoe bahaaike samdjhailie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ab ham toelogke Prabhoe ke aur okar bhalaai ke oeppar saupiela. Toelog okar khaatien alag karal baate, aur oke saktie hai toelogke bieswaas barhaawe ke aur toelogke aapan biesaal tjiedj dewe ke djaun oe waada karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ham koi se tjaanie, sona, kie to kapra na manglie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Toelog djaane hai kie ham apane se kamaaike khailie aur bhie aapan saathie log ke baat deilie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Aisane toelog dekhle hai kie hamlogke tjaahie kaske kaam kare ke oelogke sahaaita kare khaatien dje ke kamtaai hai, aur bhie Prabhoe Jiesoe ke baat khiaal kare ke. Oe bolies hai kie: ‘Koetjh dewe se hamlogke auro soekh mielie koetjh paawe se.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Tab djab oe ie sab baat bol tjoekal, tab Paulas gaathie par gierke sab barkwan ke sanghe Parmeswar se praatna karies. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bas oelog bahoet rowe lagal aur Paulas ke gale lagaaike tjoemma deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Oe bolies raha kie: „Toelog ab hamme phien se na dekhiehe.” Ohie se oesabke bahoet sotj raha. Tab oesab okar sanghe djahaadj talak gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tab hamlog oedaasie se Efese ke iesaai samaadj ke barkwan se biedaai leike djahaadj se Kos des gailie. Tab biehaan hoike hamlog Rodos des pahoetjlie aur ekare baad Pataara sahar me. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tab hoewa par hamlog ekgo djahaadj pailie djaun Feniesia des djaat aur hamlog ohie me tjal gailie. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tab djab Siepras des dekhaai lagal, tab oke paas hoike hamlog gailie Sieria des. Tab hamlog Tieras sahar me pahoetjlie aur hoewa par djahaadj me se sauda oetaaral gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Hoewa par hamlog koetjh Jiesoe ke tjela log ke pailie, aur ek hapta oelogke hia rahielie. Oelog Paulas se bataais kie: „Paulas, soen. Pawietr Aatma hamlogke dekhaais hai kie Jeroesaalem me toke moesiebat hoiga. Ohie se hamlog sotjiela kie bestar rahat djab toe hoewa na djaite.” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Bakie tabbo djab hamlogke tem don hoi gail raha, tab hamlog Paulas sanghe djahaadj lage gail Jeroesaalem djaai ke. Aur sab bieswaasie bhaai log aapan aurat larkan sanghe hamlogke djahaadj talak pahoetjaais. Tab samoendar ke kienaare hamlog sab koi gaathie par gierlie praatna kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tab hamlog oesabse biedaai leike djahaadj se tjal gailie aur oelog laut gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tab hamlog Tieras sahar se Patolamais sahar me pahoetjlie aur hoewa ke bieswaasie bhaai-bahien log se bhet karlie aur ek rodj oesabke sanghe rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tab djab biehaan bhail, tab hamlog hoewa se Sesaarea sahar gailie aur khoes khabar soenaawe waala Fielepas ke ghare pahoetjlie. Okar hia hamlog rahielie. Oe saatgo dekh-bhaal kare waalan me se ekgo raha, aur oe pahiele Jeroesaalem ke iesaai samaadj me tjoenal gail raha garieb wiedhwa logan ke dekh-bhaal kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Oke tjaargo koewaare bietia raha aur oesab Pawietr Aatma dwaara Parmeswar ke sanes bataawat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tab djab hamlog Fielepas hia koetjh dien rahielie, tab Joedea diehaat se ekgo bieswaasie aadmie Aagaabas naam ke aail. Oe bhie ekgo Prabhoe ke sanesia raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Tab oe aaike Paulas ke tjamotie leike aapan haath gor baanh leis aur bolies: „Pawietr Aatma bole hai kie djekar ie tjamotie hai, oke Israel log Jeroesaalem me aisane baanhke doesar djaat log ke haath me saup deiga.” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tab djab hamlog ie baat soenlie, tab hamlog aur hoewa ke bieswaasie log Paulas se bienaai karlie Jeroesaalem na djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bakie oe bolies: „Toelog kaahe ke aas gieraaike hamaar diel oedaasie kare hai? Ham tajaar baatie Jeroesaalem me na khaalie baanhal djaai ke, bakie bhie Prabhoe Jiesoe khaatien mare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tab djab oe hamlogke baat na maanies, tab hamlog tjhor deilie aur bollie: „Djaun Prabhoe maangie, ohie hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Djab hamlogke tem biet gail, tab hamlog aur Paulas tajaar karlie Jeroesaalem djaai ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Aur ekaatgo Sesaarea ke bieswaasie log hamlogke sanghe gail. Jeroesaalem me oesab hamlogke ekgo Manaason naam ke iesaai ke ghare legail. Oe Siepras des ke raha aur oe Jiesoe ke pahiela tjela log me se ekgo raha. Okar hia hamlog koetjh dien khaatien rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Djab hamlog Jeroesaalem me pahoetjlie, tab hoewa ke bieswaasie log hamlogke bahoet prem se bhiettar leis. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Biehaan bhaile Paulas hamlogke sanghe Jaakobas ke ghare gail. Sab iesaai samaadj ke barkwan hoewa bhie raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Tab Paulas oesabse bhet karke phor-phorke bataawe lagal kie Parmeswar okar dwaara doesar djaatie log khaatien kaun kaam karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Tab oelog ie baat soenke Parmeswar ke aadar kare lagal. Aur oesab Paulas se bolies kie: „Bhaai, dekh. Israel ke djaatie me ke hadjaaran iesaai hoi gail hai. Oesab Prabhoe Jiesoe me bieswaas kare hai, aur oesab bhie Mosas ke kaanoen ke sab baat maane hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Oelog soenies hai kie toe sab par-des ke Israel log ke siekhaawe hai Mosas ke kaanoen tjhor dewe ke, aapan betwan ke hakiekat na kare ke, aur Israel ke nem kaam me na lewe ke. Hamlog djaaniela kie toe aisane na siekhaile hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ab hamlog ka karabe? Mosas ke kaanoen par tjale waalan djaan paai kie toe hia aile baate. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Soen, tjaargo bhaktie aadmie aail hai. Oesab waada karies hai koetjh tem khaatien Parmeswar ke aage bhaktie rahe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Oesabke ledja aur apane ke oelogke saath safa karwaihe, aur bhie paisa bharke oesabke baar katwaai deihe. Tab sab koi na khaalie djaan djaaiga kie oe baat tore biese me djhoeth baat hai, bakie oelog dekhiega kie toe Mosas ke kaanoen par tjale hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Oesab bhie bolies kie: „Hamlog sallaah karlie kie doesar djaat ke bieswaasie log ke djaroerie na hai Mosas ke kaanoen ke hoekoem se rahe ke. Aur hamlog ek tjietthie me liekh deilie hai kie oesabke na tjaahie khaana khaai ke djaun naklie bhagwaan ke tjaharaawal gail hai. Aur bhie na khoen aur gos djaun me khoen hai. Aur oesabke na tjaahie tjhatjhoendaraipan kare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Biehaan bhaile Paulas oesabke leike gail safa karwaawe. Tab ekare baad oesab Parmeswar ke mahal lage gail aur aapan naam liekhwaais djanaawe khaatien safa rahe ke aakhrie dien kab rahiega aur kaun taariek ke baliedaan karwaawe ke tjaahie. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Bakie djab satwa dien nagtjaail, tab koetjh Aasia des ke Israel log Paulas ke Parmeswar ke mahal ke angana me dekhies. Bas oesab haltjal matjaawe lagal aur oke pakarke tjiellaai lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","„Bhaai log, batjaaw! Ie aadmie sagaro sab koi ke aage aapan siektjha se hamlogke djaat, kaanoen aur Parmeswar ke mahal ke kharaab kare hai! Ab oe doesar djaat log ke ie pawietr djagaha me ledjaaike barbaad kar deis hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Oesab oke par-des Efese sahar ke Trofiemas ke sanghe Jeroesaalem me dekhies raha. Ohie se oelog sotjies kie oe oke Parmeswar ke mahal ke angana me legail hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tab sahar bhar oedhoem karies aur sab aalam ek lage djoet gail. Bas oesab Paulas ke pakarke bahare ghietjies aur toerante kamaarie band kar deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tab djab oesab maangat raha oke maar dhaare, tab Roma ke soerdjaatie ke barkwa soenies kie sahar bhar me haltjal matjal hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Bas oe aapan soerdjaatie aur oesabke barkwan ke leike toerante gail dekhe. Djaise djhoend log oesabke dekhies, taise roek gail Paulas ke maare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tab soerdjaatie ke barkwa Paulas lage gail aur oke doei ketie se banhwaais aur khodjie karies kie oe kaun aadmie hai aur kaun kharaabie karies hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bakie sab koi tjiellaai lagal, aur etana halla raha kie barkwa na djaan paais ka bhail hai. Ohie se oe hoekoem deis Paulas ke soerdjaatie ke thaana me ledjaaike. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bakie thaana ke sierhie lage manai log etana thelat raha kie soerdjaatie ke Paulas ke oethaawe ke paral. ");
INSERT INTO hnsNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Djhoend to okar paatjhe tjalal aur tjiellaaike bolies: „Oke maar dhaar!” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tab djab soerdjaatie oke thaana me ledjaat raha, tab oe barkwa se bolies: „Ham tose koetjh poetjh sakiela?” Tab barkwa poetjhies: „Toe Griek ke bhaasa batia hai? ");
INSERT INTO hnsNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ka, toe Egypte des ke aadmie na baate djaun koetjh dien pahiele haltjal matjaais raha aur tjaar hadjaar djaanmarwan sanghe maidaan me tjal gail raha?” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Tab oe bolies: „Na, ham Israel ke aadmie baatie. Ham Sieliesia des Taarsas me rahiela. Sab koi oe sahar ke biese me djaane hai.” Oe bolies: „Toe hamme hoekoem dei sake hai djhoend log se koetjh bataawe ke?” ");
INSERT INTO hnsNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tab djab barkwa oke hoekoem deis, tab Paulas sierhie par thara bhail aur djhoend ke haathe se sankiaaike saaniet karies. Sab djaatie tjoeppaai gail aur soene lagal. Tab Paulas Israel ke bhaasa me oesabse bataawe lagal. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Oe bolies: „Bhaai-bahien aur baap log, soeno ab ham apane ke kaise batjaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Tab djab oesab soenies kie oe Israel ke bhaasa me batia hai, tab oelog ekdam se tjoeppaai gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Tab oe bolies: „Ham ek Israel ke aadmie baatie. Ham Sieliesia des Taarsas sahar me paida bhailie aur ie sahar me posailie. Ham Gaamaaliejel ke ekgo tjela baatie. Oe hamme phor-phorke siekhaais hai kaise hamlogke baap-daada log ke kaanoen par tjale ke tjaahie. Ham apane djaan me Parmeswar khaatien bahoet kausies karat rahielie djaise toelogan bhie kare hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ham to aurat aur mardaana log ke maut talak satailie djaun Prabhoe Jiesoe ke rasta par tjalat raha. Ham oelogke baanhke djahal me dharwailie rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sab se barka agwa aur bhie Israel ke barkwan gawaahie dei sake hai kie ham oelogke hoekoem se ie kaam karat rahielie. Oesab to hamme tjietthie deis raha Daamaskas sahar ke Israel ke bhaai log khaatien. Ese ham hoewa ke iesaai log ke baanhke Jeroesaalem me ledjaai sakat rahielie oelogke sadja dewe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Bas ek biesaal tjiedj bhail. Djab ham Daamaskas sahar nagtjailie, tab dien doepahare etana djotie kaske oeppar se tjamke lagal kie bahoet andjor hoi gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Tab ham nietje gier gailie aur ek aawaadj soenlie. Koi hamse bolies kie: ‘Saul, Saul! Toe kaahe ke hamme sataawe hai?’ ");
INSERT INTO hnsNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Tab ham bollie: ‘Prabhoe, toe ke baate?’ Tab oe bolies: ‘Ham Naasaaret sahar ke Jiesoe baatie aur toe hamme sataawe hai.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Hamaar saathie log djotie dekhies, bakie aawaadj na soenies. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tab ham bollie: ‘Prabhoe, hamke ka kare ke tjaahie?’ Tab oe bolies kie: ‘Thara how aur Daamaskas me dja. Hoewa par koi tose bataaiga kie toke kaun tjiedj kare ke parie.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bakie oe tjatak tjamkal djotie se ham andha hoi gailie rahielie. Ohie se hamaar saathie log hamaar haath pakarke hamke Daamaskas me legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tab ekgo Aanaaniaas naam ke aadmie hamare lage aail. Oe Parmeswar ke kaanoen ke rasta par tjalat raha. Aur sab Daamaskas sahar ke Israel log okar bahoet maan djaan karat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Oe aaike bolies: ‘Saul bhaai, taak!’ Ham toerante dekhe lagalie aur oke taklie. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Oe bolies: ‘Hamlogke baap-daada log ke Parmeswar toke tjoenies raha djanaawe ke kie oe ka maange hai, aur bhie toke aapan sattja Waala Jiesoe ke dekhaawe ke aur okar aawaadj soene ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Toke tjaahie okare biese me gawaahie dewe ke aur sab koi se bataawe ke toe ka dekhle aur soenle hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ab kaahe ke agore hai? Oethke dja aur Jiesoe ke naam bolaaike apane ke dopoe karwaaw aur aapan kharaab tjalaawa niekaswaaw.’ Tab ham apane ke dopoe karwailie. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Tab djab ham koetjh dien baad Jeroesaalem me lautke gailie aur Parmeswar ke mahal ke angana me oke poedjat rahielie, tab ham djaise ek sapana me koetjh dekhlie. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Prabhoe phieno hamme dekhaail aur bolies: ‘Haalie se Jeroesaalem se tjal dja. Djab toe hia ke manai log se hamare biese me bataihe, tab oesab na maangie soene.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Bakie ham bollie: ‘Prabhoe, oesab to thiek se djaane hai kie ham tor bieswaasie log ke pakarwaaike aur partjaar ke ghar me ledjaaike pietwailie aur djahal me band kar dewat rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Aur djab tor gawaahia Stefaanas ke khoen bahaawal gail, tab ham hoewa bhie rahielie. Ie hamaar kahana raha aur ham okar djaanmarwan ke kapra ke rakhaawat rahielie. Oesab djaroer hamaar baat soeniega.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bakie Prabhoe bolies: ‘Dja, ham toke doer des ke be-bieswaasie logan lage pathaabe.’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bas djab manai log ie baat soenies, tab oesab na sahie paais aur tjiellaaike bolies: „Aisan aadmie ke dhartie par se hataai de! Oke tjaahie mare ke!” ");
INSERT INTO hnsNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Tab goessa me oelog ie baat gohoraaike aapan kapra oetaarke oeraawe lagal, aur bhie soeroe karies dhoer oeraawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tab thaana ke barkwa hoekoem deis kie: „Oke thaana me ledja, aur oke tjhatkoen se maarke poetjh kie kaahe khaatien manai log etana oedhoem kare hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tab djab oelog oke piete khaat baanh tjoekal raha, tab Paulas barkwa se djaun oke baanhies raha, ose bolies kie: „Bhaai, soen, hamke Roma ke djaatie ke hak hai. Toke hoekoem hai hamme maare ke biena dekhe ke kie hamke kasoer hai kie na?” ");
INSERT INTO hnsNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tab barkwa djab ie baat soenies, tab oe thaana ke barkwa lage gail aur bolies: „Ab toe ka kariehe? Ie aadmie ke to Roma djaat ke hak hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tab thaana ke barkwa Paulas lage gail aur poetjhies: „Toke Roma djaat ke hak hai?” Tab oe bolies: „Ha, hamke hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tab barkwa bolies: „Ham ie hak dher paisa bhare se pailie.” Tab oe bolies: „Aur ham paidaais se pailie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bas oesab oke toerante tjhor deis. Aur thaana ke barkwa djab sotjies kie oe aisan aadmie ke banhwaais raha, tab deraai lagal sadja paawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tabbo oe maangat raha thiek se djaane kie Israel ke aadmie log kaun kaaran se Paulas ke kasoer dewat raha. Ohie se biehaan bhaile oe Israel djaatie ke barka agwan aur oesabke barkwan ke ek lage bolwaais. Tab oe Paulas ke biena ketie se thaana me se oesabke aage legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Tab Paulas barkwan ke taakke bolies: „Bhaai log, ham Parmeswar ke aage safa sotj-bietjaar se aapan djiewan bietailie hai aur aadj talak bietaaila.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tab sab se barka agwa okar bagale ke aadmie log ke hoekoem deis okar moeh par maare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tab Paulas ose bolies: „Toke Parmeswar sadja deiga, toe bhaktie khele waala! Toe hia par baithke kaanoen se hamaar kasoer dekhaawe maange hai? Tab kaanoen toerke koi ke sahie dewe hai hamme maare ke!” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tab koetjh manai log bolies: „Ka, toe Parmeswar ke sab se barka agwa ke bedjatie kare hai?” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Tab oe bolies: „Bhaai log, ham na djaanat rahielie kie ie sab se barka agwa hai, nahie to ham na boltie. Kaanoen me to liekhal hai kie: ‘Toelogke djaatie ke barkwan ke biese me kharaabie na batiaihe!’ ” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Oe djaanat raha kie sabha me Sadoesie aur bhie Fariesie log raha. Ohie se oe djor se bolies kie: „Bhaai log, ham Fariesie ke palwaar me se hai aur bhie Fariesie baatie. Ham bieswaas kariela kie maral logan djie oethiega. Ohie se ham aadj toelogke aage thara baatie.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Tab djaise oe ie baat bol tjoekal raha, taise Fariesie aur Sadoesie log apane me takaraar kare lagal, aur sabha doei bhaag me bat gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadoesie log to bole hai kie maral logan na djie oeth sake hai aur bhie kie parie aur doesar aatma na hai. Bakie Fariesie log ie doeno tjiedj me bieswaas kare hai aur siekhaawe hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tab etane me sabha ke manai log bahoet djor se tjiellaai lagal aur koetjh Fariesie log ke dal me ke parhal waalan karaai se bolies: „Hamlogke djaan me oe aadmie koetjh kharaabie na karies hai! Saait ek Parmeswar ke parie kie to doesar swarag waala ose batiaais hai!” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Aur ie takaraar etana doer pahoetj gail kie doeno bagal se oelog oke ghietje lagal. Tab thaana ke barkwa deraai gail. Oe sotjies kie: „Oelog oke ab toekkara toekkara tjier dei.” Tab oe aapan soerdjaatie ke bolwaaike bolies kie: „Oke thaana me ledja.” Oelog aisane karies. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tab oe raat ke Prabhoe Paulas ke lage aail aur bolies: „Paulas, hiemmat baanhe rahiehe! Djaise toe Jeroesaalem me hamare biese me gawaahie deile hai, oisane toke Roma sahar me bhie dewe ke parie.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Tab djab saber bhail, tab koetjh Israel log ek lage aail aur sallaah karke kasam khaais kie: „Hamlog biena koetjh khaai pieje se pahiele Paulas ke maar dhaare k'hoi.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Tjaalies aadmie se djaada ie kharaab bietjaar karke kasam khaais. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Tab oelog gail agwan aur djaatie ke barkwan ke lage aur bolies kie: „Hamlog kasam khaaike sallaah karlie hai koetjh na khaai pieje ke djab talak hamlog Paulas ke na maar dhaarab.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Aur bhie bolies: „Toelog thaana ke barkwa se bienaai karke bol de kie oke Paulas ke phieno barkwan ke aage ledjaai. Toelog kariehe djaise okar kaar-baar auro thiek se maange hai khodj kare. Hamlog tajaar baatie oke hia pahoetje se pahiele maar dhaare ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Etane me Paulas ke bahien ke betwa oesabke kharaab bietjaar ke biese me soenies. Tab oe thaana me gail aur Paulas se bol deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tab Paulas soenke hoewa ke ek soerdjaatie ke barkwa ke bolaaike bolies: „Ie naudjawaan ke thaana ke barkwa lage ledja. Oe maange hai ose koetjh bataawe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Barkwa oke leike gail thaana ke barkwa lage aur bolies: „Paulas djahalia hamse bataais kie ie naudjawaan maange hai tose koetjh bataawe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tab thaana ke barkwa okar haath pakarke oke alag legail aur poetjhies: „Toe kaun tjiedj hamse maange hai bataawe?” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tab naudjawaan bolies: „Soeno, djie. Israel log apane me sallaah karies hai tose poetjhe ke Paulas ke barkwan ke aage phieno ledjaai ke. Oesab kariega djaise maange hai okare biese me auro thiek se khodj kare. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bakie oelogke na bieswaas kariehe. Tjaalies mardaana se djaada loekaaike agore hai oke maar dhaare ke. Oelog kasam khaais hai na khaai pieje ke djab talak oe djienda rahiega. Oesabhan tajaar hai aur aap ke hoekoem agore hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tab barkwa bolies: „Toe koi se na bataihe kie toe hamse ie sab baat bolle hai,” aur oke pathaai deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tab oe doeigo aapan soerdjaatie ke barkwa ke bolaaike bolies kie: „Aadj nau badje raat ke doei sau soerdjaatie ke tajaar kar Sesaarea djaai ke. Aur sattargo ghora tjalaawe waalan, aur doei saugo tjhoerie ke danda se laraai kare waalan bhie. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Aur Paulas khaatien ekaatgo ghora tajaar kariehe oke barhia se laat Feleks lage ledjaai ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Tab oe ek tjietthie liekhies. Oman liekhal raha kie: ");
INSERT INTO hnsNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Laat Feleks djie, ham Klaudias Liesias baatie. Aap kaise baato? ");
INSERT INTO hnsNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ham ie aadmie ke aapke khaatien pathaaila. Oe Jeroesaalem sahar me Israel log dwaara pakaraail raha. Bakie ham soenlie kie oke Roma djaat ke hak hai. Ohie se djab Israel logan maangat raha okar djaan lewe, tab ham aapan soerdjaatie leike gailie oke batjaawe. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Tab ham oke oesabke barkwan ke sabha ke aage legailie. Ham maangat rahielie djaane kie oelog oke kaahe khaatien kasoer dewat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Tab hoewa ham pata pailie kie oesab oke kasoer deis khaalie oesabke kaanoen ke kaaran se. Bakie oe koetjh na karies hai maut kie to djahal ke sadja paawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Tab djab ham soenlie kie koetjh Israel ke manai kasam khaaike sallaah karies hai oke maar dhaare ke, tab ham toerante faisala karlie oke tore lage pathaawe ke. Aur ham okar kasoer dewe waalan ke hoekoem deilie aapse bataawe ke kaun tjiedj ke biese me oelog oke naalies maange hai kare. Hia talak hamaar tjietthie hai. Aap barhia se rahieho! ");
INSERT INTO hnsNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tab oe raat ke soerdjaatie log Paulas ke Antiepaatres sahar legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Aur djab saber bhail, tab oelog ghora tjalaawe waalan ke okare sanghe Sesaarea pathaai deis aur apane log thaana me laut gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Tab djab ghora tjalaawe waalan Sesaarea me pahoetjal, tab oesab laat ke tjietthie deis aur Paulas ke okar aage legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Tab laat tjietthie parhies aur Paulas se poetjhies: „Toe kaaha ke baate?” Tab oe bolies: „Sieliesia des ke.” ");
INSERT INTO hnsNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Tab laat bolies: „Attjha, djab tor kasoer dewe waalan hia par aai djaai, tab ham tor biese me khodj karabe.” Aur oe hoekoem deis oke Herodes ke mahal me band kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Tab paatj rodj baad sab se barka agwa Aanaaniaas aur ekaatgo doesar barkwan ekgo Tertalas naam ke okiel ke leike aaike laat ke paas pahoetjal Paulas ke naalies kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Aur djab Paulas laat ke aage aail, tab Tertalas soeroe karies okar kasoer bataawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Oe bolies: „Laat Feleks djie, tor sahaaita se hamlogke djaatie soekh se rahe hai. Tor raadj tjalaawe ke dwaara to ie des me dher tjiedj auro barhia hoi gail hai. Ohie khaatien hamlog hardam aur sagaro toke dhanbaad deila. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Aur ab ham tose bienaai kariela thora der khaatien hamaar baat par dhiaan lagaawe ke. Djaise toe hardam hamlog par aapan dhiaan lagaile hai, oisane ab bhie kariehe. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Hamlog to djaan gailie hai kie ie aadmie ek khatarnaak aadmie hai. Oe doenia bhar ke Israel ke djaatie log ke tjienta me daarke haltjal matjaawe hai. Aur oe Naasaaret sahar ke Jiesoe ke dal me ke ekgo barkwa hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tab djab oe maangies Parmeswar ke mahal barbaad karwaawe, tab hamlog oke pakar leilie oke aapan kaanoen dwaara sadja dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Bakie Jeroesaalem ke thaana ke barkwa Liesias aapan soerdjaatie leike aail aur oke djabar-djastie se pakarke legail. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Aur oe hamlogse bolies aapke paas djaai ke ie aadmie ke kasoer dewe khaatien. Djab toe ose ie sab baat ke baare me poetjhiehe, tab toe apane djaan djaihe hamlog oke kaahe ke kasoer deila.” ");
INSERT INTO hnsNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tab Israel ke sab se barka agwa aur doesar barkwan Tertalas ke alang bhail aur bolies: „Ha, aisane hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Tab laat Paulas ke sankiaais batiaai khaatien aur Paulas bole lagal kie: „Laat djie, ham djaaniela kie toe dher baries se ie djaatie ke oeppar faisala kare hai. Ohie se ham hiemmat baanhke tore aage ailie. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Sab koi tose bataai sake hai kie hamme Jeroesaalem me aile aur Parmeswar ke poedje ke abbe baara rodj bhail hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Oesab hamme koi se moeh tjalaawat na dekhies hai. Ham Parmeswar ke mahal me aur partjaar ke ghar me aur bhie na kahie sahar me haltjal matjailie hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Oelog hamme kasoer dewe hai, bakie na darsaai sake hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ham toke djanaaila kie ham aapan baap-daada log ke Parmeswar ke aadar kariela. Ham Mosas ke kaanoen me aur Parmeswar ke pahiele ke sanesian ke sab liekhal baat me bhie bieswaas kariela. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Hamaar aasa Parmeswar par hai aur ham agoriela kie sab manai, tjaahe barhia ja kharaab, oesab djie oethiega. Aur hamaar kasoer dewe waalan ohie agore hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ohie se ham kausies kariela Parmeswar aur manai ke aage hardam safa sotj-bietjaar se rakhe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Dher baries bhail kie ham Jeroesaalem sahar me na rahielie, tab ham lautke gailie aapan djaatie log me ke koetjh garieb waalan ke paisa dewe aur bhie Parmeswar ke koetjh baliedaan kare. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tab djab ham ie kaam karat rahielie, tab oelog hamme Parmeswar ke mahal ke angana me dekhies. Ham safa karwaawal gailie rahielie aur ekko haltjal kie to hoerdoem na bhail raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bakie ekaatgo Aasia des ke Israel logan hamme hoewa par dekhke pakaries raha. Djab oelog hamare me koetjh kasoer paawat, tab ohielogke tjaahat raha aadj tore aage aawe ke hamaar oeppar naalies kare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Aur toe hia ke manai log se poetjh sake hai kie oelog hamare me kaun kasoer paais hai djab ham oesabke barkwan ke aage ledjaawal gailie rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ham oelogse bollie: ‘Ham bieswaas kariela kie maral logan djie oethiega, ohie khaatien ham aadj toelogke aage thara baatie.’ Hoi sake hai kie oelog hamme ie baat ke biese me kasoer dewe hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Laat Jiesoe ke rasta ke biese me thiek se djaanat raha. Tab oe sabha rok deis aur Paulas se bolies: „Djab barkwa Liesias aaiga, tab ham tor oeppar faisala karabe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Aur oe soerdjaatie ke barkwa ke hoekoem deis Paulas ke band kare ke aur attjha se dekh-bhaal kare ke aur okar saathie log ke mauka dewe ke oke sewa kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Koetjh dien baad laat aapan aurat Droesela leike hoewa gail. Okar aurat ekgo Israel ke aurat raha. Tab Feleks Paulas ke bolwaais aur soene lagal kie oe Kriest Jiesoe ke rasta ke biese me ka bolies. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bakie djab Paulas soeroe karies bole ke kie hamlogke tjaahie aapan djiewan safa se bietaawe ke aur apane ke samhaare ke, aur bhie kie Parmeswar hamlogke oeppar faisala kariega, tab oe deraai gail aur bolies: „Ab etana thiek hai. Toe djaai sake hai. Djab hamme tem rahie, tab ham toke phien se bolwaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Oe aasa karat raha kie Paulas oke paisa bharat tjhoetkaara paawe khaatien. Ohie se oe oke ber ber bolaawat raha koetjh baat-tjiet kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bakie djab doei baries biet gail, tab Feleks ke darie par Porsias Festas laat bhail. Aur Israel ke djaat ke man waala kare khaatien, Feleks Paulas ke band karle rahan deis. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Djab laat Festas Sesaarea sahar me aaike pahoetjal, tab tien rodj baad oe Jeroesaalem me gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tab barka agwan ke barkwan aur djaatie ke barkwan Paulas ke naalies karies. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Oesab bienaai karke laat se poetjhies Paulas ke Jeroesaalem pathaawe ke. Oesab sallaah karies raha oke rasta me maar dhaare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Bakie oe bolies: „Na, ie na hoi sake hai. Paulas Sesaarea me band rahie djaaiga, aur ham halieje hoewa lautke djaabe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Oe bolies: „Attjha, toelog me se ekaat djane hamare sanghe djaai sake hai. Aur djab oe koetjh kharaabie karle hoi, tab toelog oke hoewa par naalies kar sakiehe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Laat aath kie to das rodj Jeroesaalem sahar me raha, tab oe phien se Sesaarea me gail. Aur biehaan bhaile oe Paulas ke bolwaais okar oeppar faisala kare khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Djab oe aail, tab Israel ke barkwan oke gherke har ek rakam kasoer dewe lagal, bakie oesab na darsaai sakat raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Tab Paulas bolies: „Ham Israel ke dharam ke kaanoen na toerlie hai. Ham Parmeswar ke mahal me koetjh kharaabie na karlie hai aur maahaaraadja se djabarai bhie na karlie hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Bakie Festas maangat raha dekhaawe kie oe ketana attjha laat hai. Ohie se oe Israel ke barkwan ke man waala karies. Aur oe Paulas se bolies: „Toe na maange hai Jeroesaalem djaai faisala howe khaatien?” ");
INSERT INTO hnsNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Tab Paulas bolies: „Toe thiek se djaane hai kie ham Israel ke djaatie log ke koetjh kharaabie na karlie hai. Toe maahaaraadja ke hoekoem se faisala kare hai. Ohie se ham na maangiela hoewa djaai. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Djab ham kasoerie rahietie aur maut ke sadja laaik baatie, tab ham mare khaatien tajaar baatie. Bakie aise na hai aur koi na oesabke man waala kare khaatien hamme oesabke haath me saup dei sakiega. Ohie se ham maangiela maahaaraadja dwaara faisala howe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Tab laat aapan mantrie log se baat-tjiet karies. Ekare baad oe Paulas se bolies kie: „Toe maange hai maahaaraadja ke lage djaai? Attjha, ohie ke lage toe djaihe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Tab djab ekaat dien biet gail raha, tab ekgo raadja aapan bahien sanghe Sesaarea sahar me aail laat Festas se bhet kare. Okar naam Aagrepa aur okar bahien ke naam Berniesa raha. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Djab oesab hoewa par dher dien rahie gail, tab laat raadja se Paulas ke biese me bataawe lagal kie: „Feleks ek aadmie ke band karke tjal gail hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Aur djab ham Jeroesaalem me rahielie, tab hoewa ke barka agwan aur djaatie ke barkwan oke kasoer deis. Oelog hamse bienaai karke poetjhies oke faisala karke sadja dewe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Tab ham bollie kie: ‘Roma ke djaat ke nem na hai ek manai ke pakarke doesar log ke haath me saupe ke oesabke bhalaai kare khaatien. Bakie oke tjaahie pahiele mauka miele ke aapan naalies kare waalan ke aage apane ke batjaawe khaatien.’ ");
INSERT INTO hnsNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Aur djaise oelog hamare sanghe ie sahar me aail, taise ham biehaan bhare djadj ghat sahie deilie aadmie ke hamare aage laawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bakie okar naalies kare waalan oke gherke oke ekko kasoer na deis djaun kharaab kaam ke biese me ham sotjlie rahielie kie oe karies hoi. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Oesabhan khaalie aapan dharam ke biese me ose ek na raha, aur bhie ek Jiesoe naam ke aadmie ke biese me. Oe Jiesoe mar gail hai, bakie Paulas ekke baat pakarle hai kie oe djieje hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ham na djaanat rahielie kie aisan tjiedj ke biese me hamme kaise tjaahat raha khodj kare ke. Ohie se ham Paulas se poetjhlie kie: ‘Toe maange hai Jeroesaalem djaai hoewa par faisala howe khaatien?’ ");
INSERT INTO hnsNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bakie oe bolies kie: ‘Na, ham maangiela kie maahaaraadja hamaar oeppar faisala kare.’ Tab ham hoekoem deilie oke band kare ke djab talak ham oke hoewa na pathaai sakab.” ");
INSERT INTO hnsNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Tab raadja bolies kie: „Ham bhie maangiela oe aadmie ke soene.” Tab laat bolies: „Attjha, toe biehaan soeniehe.” ");
INSERT INTO hnsNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tab djab biehaan bhail, tab Aagrepa aur Berniesa khoeb barhia se sadjke mahal me gail. Oelogke saath oetja dardja ke soerdjaatie ke barkwan aur sahar ke barkwan bhie raha. Aur laat ke hoekoem par Paulas bhiettar ledjaawal gail. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Tab laat bolies: „Raadja Aagrepa aur saamiel waalan, aaplog hia par ek djane ke dekhe hai. Sab Israel ke djaatie log Jeroesaalem me aur ie sahar me bhie okar oeppar naalies karies hai. Oesab tjiellaaike bolies kie oke tjaahie mare ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Bakie ham djaan gailie kie oke ekko maut ke kasoer na hai. Aur djab oe maangies maahaaraadja dwaara faisala howe, tab ham sallaah karlie oke Roma sahar me pathaawe ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bakie ab ham na djaaniela kie maahaaraadja khaatien hamke okare biese me kaun tjiedj liekhe ke tjaahie. Raadja djie, ohie khaatien ham oke aapke aur sab koi ke aage lailie hai. Tab khodj karke ham koetjh liekh sakab. ");
INSERT INTO hnsNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Hamke to boedjha hai kie na thiek hai oke Roma pathaawe ke biena maahaaraadja ke djanaawe ke kie oke kaun kasoer hai.” ");
INSERT INTO hnsNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tab raadja Paulas se bolies: „Ab toke mauka hai apane ke batjaawe ke.” Bas Paulas ek haath oethaaike bolies: ");
INSERT INTO hnsNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","3","„Raadja djie, aap Israel ke djaat ke nem khoeb thiek se djaane hai aur bhie kaun tjiedj ke biese me oesab me ekta na hai. Ohie se ham khoesie baatie kie aadj ham aapke saamne apane ke batjaai sakiela. Aur ham aapse bienaai kariela hamaar baat dhieradj se soene ke. ");
INSERT INTO hnsNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Sab Israel ke djaatie log djaane hai kie ham tjhotahie se oesabke bietj me Taarsas aur Jeroesaalem me rahat rahielie. ");
INSERT INTO hnsNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Oesabhan dher dien se djaane hai aur djab maange tab gawaahie dei sake hai kie ham Fariesie baatie aur aapan djiewan ek Fariesie ghat bietaaila. Aur Fariesie logan hamlogke dharam ke sab se bhaktie waalan hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Parmeswar hamlogke baap-daada log ke koetjh waada karies hai, aur ham bieswaas kariela kie oe aapan baat poera kariega. Ohie se ham aadj djadj ke aage thara baatie. ");
INSERT INTO hnsNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Hamlogke djaat ke baara koel log bhie ohie waada par aasa kare hai aur oesab raat dien Parmeswar ke aadar kare hai djab talak oe aapan waada na poera kare hai. Raadja djie, ehie aasa ke kaaran se oelog hamme kasoer deis hai. ");
INSERT INTO hnsNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","He soene waalan, aaplog kaahe ke na bieswaas kare hai kie Parmeswar maral logan ke djie oethaaiga? Oe to waada karies hai kie aise hoiga! ");
INSERT INTO hnsNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Pahiele ham djaran ke maare bietjaar karat rahielie kie ham kausies karke Naasaaret ke Jiesoe ke naam badnaam karab. ");
INSERT INTO hnsNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ham ie kaam Jeroesaalem me soeroe karlie. Hoewa par to ham barka agwan ke hoekoem se dher iesaai log ke djahal me band kar deilie. Aur djab oelogke maut ke sadja mielal, tab ham bhie haamie bharlie. ");
INSERT INTO hnsNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Aur sab partjaar ke ghar me ham iesaai log ke ber ber djabarai se sadja deike kausies karat rahielie oesabke daatke Jiesoe ke bedjatie karwaawe ke. Ham oesabke oeppar etana goessaai rahielie kie ham doesar des ke sahar talak khodjat rahielie oesabke sataawe khaatien. ");
INSERT INTO hnsNT_vpl VALUES ("AC26_12","