﻿USE sofia;
DROP TABLE IF EXISTS sofia.hne_vpl;
CREATE TABLE hne_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hne_vpl WRITE;
INSERT INTO hne_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","सुरू म परमेसर ह अकास अऊ धरती ला रचिस। ");
INSERT INTO hne_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","अऊ धरती ह बेडौल अऊ सुनसान परे रिहिस, अऊ गहिरा पानी के ऊपर अंधियार रिहिस, अऊ परमेसर के आतमा पानी के ऊपर किंदरत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","अऊ परमेसर ह कहिस, “अंजोर हो,” त अंजोर हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","परमेसर ह अंजोर ला देखिस कि येह बने हे, अऊ ओह अंजोर ला अंधियार ले अलग करिस। ");
INSERT INTO hne_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","परमेसर ह अंजोर ला “दिन,” अऊ अंधियार ला “रात” कहिस। अऊ सांझ होईस, फेर बिहान पहा गीस—ये किसम ले पहिला दिन हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","फेर परमेसर ह कहिस, “पानी के बीच म एक अइसने अंतर होवय कि पानी ह पानी ले अलग हो जावय।” ");
INSERT INTO hne_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","तब परमेसर ह अकास-मंडल बनाईस अऊ अकास-मंडल के खाल्हे के पानी ला एकर ऊपर के पानी ले अलग कर दीस। अऊ वइसने हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमेसर ह ओ अकास-मंडल ला “अकास” कहिस। अऊ सांझ होईस, फेर बिहान पहा गीस—ये किसम ले दूसर दिन हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","फेर परमेसर ह कहिस, “अकास के खाल्हे के पानी ह एके जगह म माढ़ जावय, अऊ सूखा भुइयां दिखय।” अऊ वइसने हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेसर ह सूखा भुइयां ला “धरती” कहिस, अऊ जऊन पानी माढ़ गीस, ओला ओह “समुंदर” कहिस, अऊ परमेसर ह देखिस कि येह बढ़िया हे। ");
INSERT INTO hne_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","फेर परमेसर ह कहिस, “धरती म हरियर घांस, बीजावाले पऊधा अऊ फर देवइया रूख, अऊ रूख के फर म अपन-अपन किसम के मुताबिक बीजा होवय।” अऊ वइसने हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ये किसम ले धरती म हरियर घांस, अऊ पऊधा, जेमा ओमन के जाति के मुताबिक बीजा होथे, अऊ फरवाला रूख, जेमा ओमन के जाति के मुताबिक बीजा होथे, ये जम्मो हो गीन। अऊ परमेसर ह देखिस कि येह बढ़िया हे। ");
INSERT INTO hne_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","अऊ सांझ होईस, फेर बिहान पहा गीस—ये किसम ले तीसर दिन हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","फेर परमेसर ह कहिस, “दिन ला रात ले अलग करे बर अकास-मंडल म अंजोरमन होवंय, अऊ ओमन पबितर समय, अऊ दिन अऊ बछरमन ला जाने बर चिनहां के रूप म काम करंय, ");
INSERT INTO hne_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","अऊ धरती ऊपर अंजोर देय बर ओमन अकास-मंडल म अंजोर बन जावंय।” अऊ वइसने हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","परमेसर ह दू ठन बड़े अंजोर बनाईस—ओमा के बड़े अंजोर ला दिन ऊपर परभूता करे बर अऊ छोटे अंजोर ला रात ऊपर परभूता करे बर बनाईस। ओह तारामन ला घलो बनाईस। ");
INSERT INTO hne_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","परमेसर ह ओमन ला अकास-मंडल म एकर बर रखिस कि ओमन धरती ऊपर अंजोर देवंय, ");
INSERT INTO hne_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","दिन अऊ रात ऊपर परभूता करंय, अऊ अंजोर ला अंधियार ले अलग करंय। अऊ परमेसर ह देखिस कि येह बढ़िया हे। ");
INSERT INTO hne_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","अऊ सांझ होईस, फेर बिहान पहा गीस—ये किसम ले चौथा दिन हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","फेर परमेसर ह कहिस, “पानी ह जीयत जन्तुमन ले भर जावय, अऊ चिरईमन धरती के ऊपर अकास म उड़ंय।” ");
INSERT INTO hne_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","परमेसर ह समुंदर के बड़े-बड़े जीव-जन्तुमन ला बनाईस, अऊ जाति-जाति के ओ जम्मो जीयत चीजमन ला बनाईस जेमन ले पानी भर गीस अऊ ओमन पानी म चलंय-फिरंय, अऊ किसम-किसम के पंखवाले चिरईमन ला घलो बनाईस। अऊ परमेसर ह देखिस कि येह बढ़िया हे। ");
INSERT INTO hne_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमेसर ह ओमन ला आसीस दीस अऊ कहिस, “फूलव-फरव; गनती म बाढ़व अऊ समुंदर के पानी म भर जावव, अऊ चिरईमन धरती ऊपर बहुंत हो जावंय।” ");
INSERT INTO hne_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","अऊ सांझ होईस, फेर बिहान पहा गीस—ये किसम ले पांचवां दिन हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","फेर परमेसर ह कहिस, “धरती म किसम-किसम के जीयत परानी होवंय: याने कि घरेलू-पसु, अऊ भुइयां म रेंगइया जन्तु अऊ बन पसु, हर एक अपन जाति-जाति के मुताबिक होवंय।” अऊ वइसने ही हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","परमेसर ह किसम-किसम के बन पसु, किसम-किसम के घरेलू-पसु, अऊ भुइयां ऊपर रेंगइया किसम-किसम के जम्मो जन्तुमन ला बनाईस। अऊ परमेसर ह देखिस कि येह बढ़िया हे। ");
INSERT INTO hne_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","तब परमेसर ह कहिस, “हमन मनखे ला अपन सरूप, अपन समानता म बनावन, ताकि ओमन समुंदर के मछरी, अकास के चिरई अऊ घरेलू-पसु अऊ जम्मो बन पसु अऊ भुइयां म रेंगइया जम्मो जीव-जन्तु ऊपर अधिकार रखंय।” ");
INSERT INTO hne_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","तब परमेसर ह मनखे ला अपन खुद के सरूप म बनाईस, अपन ही सरूप म परमेसर ह ओमन ला बनाईस; नर अऊ नारी करके ओह ओमन ला बनाईस। ");
INSERT INTO hne_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","अऊ परमेसर ह ओमन ला आसीस दीस अऊ ओमन ला कहिस, “फूलव-फरव अऊ गनती म बढ़व; धरती म भर जावव, अऊ येला अपन बस म कर लेवव। समुंदर के मछरी अऊ अकास के चिरई अऊ भुइयां ऊपर रेंगइया जम्मो जीव-जन्तुमन ऊपर अधिकार रखव।” ");
INSERT INTO hne_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","तब परमेसर ह ओमन ला कहिस, “सुनव, धरती के जम्मो बीजावाले पऊधा अऊ जम्मो रूख, जऊन म बीजावाले फर होथें, ओ सबो ला मेंह तुमन ला देवत हंव। ओमन तुम्हर जेवन बर अंय। ");
INSERT INTO hne_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","अऊ धरती के जम्मो पसु अऊ अकास के जम्मो चिरई अऊ भुइयां ऊपर रेंगइया जम्मो जीव-जन्तु—जेमन म जिनगी के सांस हवय—मेंह जम्मो हरियर-हरियर पऊधा ला जेवन बर देवत हंव।” अऊ वइसने ही हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","तब परमेसर ह अपन बनाय जम्मो चीज ला देखिस, अऊ येह बहुंत बढ़िया रिहिस। अऊ सांझ होईस, फेर बिहान पहा गीस—ये किसम ले छठवां दिन हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ये किसम ले अकास अऊ धरती अऊ ओमा के जम्मो चीज के बनई पूरा हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","परमेसर ह अपन काम, जेला ओह करत रिहिस, सातवां दिन म पूरा करिस अऊ ओह अपन जम्मो काम ले सातवां दिन बिसराम करिस। ");
INSERT INTO hne_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","तब परमेसर ह सातवां दिन ला आसीस दीस अऊ येला पबितर ठहिराईस, काबरकि ओ दिन ओह अपन सिरिस्टी के जम्मो बुता ले बिसराम करिस। ");
INSERT INTO hne_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","अकास अऊ धरती के बिबरन ये अय जब ओमन रचे गीन, मतलब कि जब यहोवा परमेसर ह अकास अऊ धरती ला बनाईस। ");
INSERT INTO hne_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","तब धरती म न तो कोनो झाड़ी उगे रिहिन, अऊ न ही कोनो पऊधा निकले रिहिन, काबरकि यहोवा परमेसर ह धरती म पानी नइं बरसाय रिहिस, अऊ भुइयां म खेती करे बर कोनो नइं रिहिन, ");
INSERT INTO hne_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","पर कुहरा धरती ले उठत रिहिस, जेकर ले जम्मो भुइयां पानी ले पलत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","तब यहोवा परमेसर ह भुइयां के माटी ले एक मनखे ला रचिस, अऊ ओकर नाक म जिनगी के सांस फूंक दीस, अऊ मनखे ह जीयत परानी बन गीस। ");
INSERT INTO hne_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","अऊ यहोवा परमेसर ह पूरब कोति अदन म एक बगीचा लगाईस, अऊ उहां ओ मनखे जेला ओह रचे रिहिस, रख दीस। ");
INSERT INTO hne_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","अऊ यहोवा परमेसर ह भुइयां म जम्मो किसम के रूख, जो देखे म मनोहर अऊ जेकर फर खाय म बने लगथे, उगाईस, अऊ बगीचा के मांझा म जिनगी के रूख अऊ भला अऊ बुरा के गियान के रूख ला घलो लगाईस। ");
INSERT INTO hne_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ओ बगीचा ला पलोय बर, एक नदी अदन ले बहत रिहिस अऊ उहां ले आघू जाके ओह चार धारा म बंट गीस। ");
INSERT INTO hne_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहिली धारा के नांव पीसोन ए; येह हवीला नांव के पूरा देस ला, जिहां सोन मिलथे, घेरे हवय। ");
INSERT INTO hne_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(ओ देस के सोन चोखा होथे; उहां खुसबूदार धूप अऊ गोमेदक घलो मिलथे।) ");
INSERT INTO hne_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दूसर नदी के नांव गीहोन ए; येह कूस नांव के पूरा देस ला घेरे हवय। ");
INSERT INTO hne_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","अऊ तीसर नदी के नांव तिगरीस ए; येह अस्सूर के पूरब कोति बोहाथे। अऊ चौथा नदी के नांव फरात ए। ");
INSERT INTO hne_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","तब यहोवा परमेसर ह मनखे ला लेके अदन के बगीचा म रख दीस कि ओह ओमा काम करय अऊ ओकर देखभाल करय। ");
INSERT INTO hne_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","अऊ यहोवा परमेसर ह मनखे ला ये हुकूम दीस, “तें बगीचा के कोनो घलो रूख के फर बिगर रोक-टोक के खा सकत हस, ");
INSERT INTO hne_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","पर भला अऊ बुरा के गियान के जऊन रूख हवय, ओकर फर तें कभू झन खाबे, काबरकि जब तें ओकर फर ला खाबे, त निस्चित रूप से तेंह मर जाबे।” ");
INSERT INTO hne_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","फेर यहोवा परमेसर ह कहिस, “मनखे के अकेला रहई बने नो हय। में ओकर बर एक अइसन मददगार बनाहूं, जऊन ह ओकर ले मेल खावय।” ");
INSERT INTO hne_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","यहोवा परमेसर ह भुइयां ले जम्मो जाति के पसुमन ला अऊ अकास के जम्मो चिरईमन ला बनाय रिहिस अऊ ये देखे बर ओमन ला मनखे करा लानिस कि ओह ओमन के का-का नांव रखथे; अऊ जऊन-जऊन नांव लेके जीयत परानीमन ला मनखे ह बलाईस, ओह ओमन के नांव हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ये किसम ले मनखे ह जम्मो घरेलू-पसुमन के, अकास के चिरईमन के अऊ जम्मो बन पसुमन के नांव रखिस। पर आदम बर कोनो अइसने सहायक नइं मिलिस, जेकर संग ओकर मेल खावय। ");
INSERT INTO hne_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","एकरसेति यहोवा परमेसर ह आदम ला भारी नींद म डार दीस; अऊ जब ओह सुतत रिहिस, तब परमेसर ह आदम के एक पसली निकालके ओकर जगह म मांस भर दीस। ");
INSERT INTO hne_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","तब यहोवा परमेसर ह आदम ले निकाले ओ पसली म ले एक माईलोगन बनाईस, अऊ ओला आदम करा ले आईस। ");
INSERT INTO hne_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","तब आदम ह कहिस, “अब येह मोर हाड़ा म के हाड़ा अऊ मोर मांस म के मांस अय; एकरसेति येला ‘नारी’ कहे जाही, काबरकि येह नर म ले निकाले गे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","एकरे कारन आदमी ह अपन दाई-ददा ला छोंड़के अपन घरवाली संग मिले रहिही, अऊ ओ दूनों एक तन होहीं। ");
INSERT INTO hne_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","आदम अऊ ओकर घरवाली दूनों नंगरा रिहिन, पर ओमन लजात नइं रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","यहोवा परमेसर ह जतेक बन पसु बनाय रिहिस, ओ सब म सांप ह जादा धूर्त रिहिस। ओह माईलोगन ले पुछिस, “का परमेसर ह सही म कहे हवय, ‘तुमन ये बगीचा के कोनो रूख के फर ला झन खाहू’?” ");
INSERT INTO hne_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","माईलोगन ह सांप ला जबाब दीस, “हमन ये बगीचा के रूखमन के फर खा सकत हन, ");
INSERT INTO hne_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","पर जऊन रूख ह बगीचा के मांझा म हवय, ओकर फर के बारे म परमेसर ह कहे हवय कि न तो तुमन ओला खावव अऊ न ही ओला छुवव, नइं तो तुमन मर जाहू।” ");
INSERT INTO hne_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","तब सांप ह माईलोगन ला कहिस, “तुमन निस्चय नइं मरव। ");
INSERT INTO hne_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","बरन परमेसर खुद जानत हे कि जऊन दिन तुमन ये फर ला खाहू, ओहीच दिन तुम्हर आंखी ह उघर जाही, अऊ तुमन भला अऊ बुरा के गियान पाके परमेसर के सहीं हो जाहू।” ");
INSERT INTO hne_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","त जब माईलोगन ह देखिस कि रूख के फर ह खाय बर बढ़िया अऊ देखे म मनभाऊ, अऊ बुद्धि देय बर पसंद के लईक हे, त ओह ओमा ले कुछू ला टोरके खाईस, अऊ कुछू अपन घरवाला ला घलो दीस, जऊन ह ओकर संग रिहिस, अऊ ओह घलो खाईस। ");
INSERT INTO hne_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तब ओ दूनों के आंखी उघर गीस, अऊ ओमन ला महसूस होईस कि ओमन नंगरा हवंय; एकरे बर ओमन अंजीर के पानमन ला जोड़-जोड़के अपन बर ढपनी बना लीन। ");
INSERT INTO hne_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","तब यहोवा परमेसर, जऊन ह दिन के ठंडा समय बगीचा म घुमय, ओकर अवाज ओमन ला सुनई दीस। तब आदम अऊ ओकर घरवाली बगीचा के रूखमन के बीच म यहोवा परमेसर ले लुका गीन। ");
INSERT INTO hne_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","पर यहोवा परमेसर ह हांक पारके आदम ला पुछिस, “तें कहां हस?” ");
INSERT INTO hne_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ओह जबाब दीस, “में बारी म तोर अवाज ला सुनके डर गेंव, काबरकि में नंगरा रहेंव; एकरसेति में लुका गेंव।” ");
INSERT INTO hne_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","परमेसर ह कहिस, “तोला कोन कहिस कि तें नंगरा हस? जऊन रूख के फर खाय बर मेंह तोला मना करे रहेंव, का तेंह ओकर फर ला खाय हस?” ");
INSERT INTO hne_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदम ह कहिस, “जऊन माईलोगन ला तेंह मोर संग रहे बर देय हस—ओही ह ओ रूख के फर मोला खाय बर दीस अऊ मेंह ओला खांय।” ");
INSERT INTO hne_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","तब यहोवा परमेसर ह माईलोगन ले कहिस, “ये तें का करे हस?” माईलोगन ह जबाब दीस, “सांप ह मोला बहका दीस, त मेंह खांय।” ");
INSERT INTO hne_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","तब यहोवा परमेसर ह सांप ला कहिस, “काबरकि तेंह अइसने करे हस, “एकरसेति तें जम्मो घरेलू-पसु, अऊ जम्मो बन पसु ले जादा सरापित अस! तेंह पेट के बल म रेंगबे, अऊ तेंह जिनगी भर माटी खावत रहिबे। ");
INSERT INTO hne_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","अऊ मेंह तोर अऊ ये माईलोगन के बीच म, अऊ तोर बंस अऊ एकर बंस के बीच म, बईरता उपजाहूं, ओह तोर मुड़ ला कुचरही, अऊ तें ओकर एड़ी ला डसबे।” ");
INSERT INTO hne_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","फेर माईलोगन ला ओह कहिस, “में तोर गरभवती होय के समय के पीरा ला अब्बड़ बढ़ाहूं; अऊ छेवारी होय के समय, तेंह पीरा सहके लइका जनमाबे। तोर लालसा तोर घरवाला बर होही अऊ ओह तोर ऊपर परभूता करही।” ");
INSERT INTO hne_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","अऊ आदम ला ओह कहिस, “काबरकि तेंह अपन घरवाली के बात ला माने, अऊ जऊन रूख के बिसय म मेंह तोला हुकूम देय रहेंव कि तें ओकर फर ला झन खाबे, ओला तेंह खाय हस। “भुइयां ह तोर कारन सरापित हे; तें एकर ऊपज अपन जिनगी भर दुख के संग खाय पाबे। ");
INSERT INTO hne_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","अऊ येह तोर बर कांटा अऊ कंटिला पऊधा उपजाही, अऊ तें खेत के ऊपज ला खाबे। ");
INSERT INTO hne_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","अऊ अपन माथा के पसीना के कमई तेंह खाय पाबे, अऊ आखिर म माटी म मिल जाबे; काबरकि तोला ओही म ले लिये गे हवय, तें तो माटी ही अस, अऊ माटी म ही फेर मिल जाबे।” ");
INSERT INTO hne_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदम ह अपन घरवाली के नांव हवा रखिस, काबरकि जम्मो जीयत मनखेमन के ओही ह दाई होईस। ");
INSERT INTO hne_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","अऊ यहोवा परमेसर ह आदम अऊ ओकर घरवाली बर चमड़ा के पहिरावा बनाके ओमन ला पहिरा दीस। ");
INSERT INTO hne_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","फेर यहोवा परमेसर ह कहिस, “मनखे ह भला अऊ बुरा के गियान पाके अब हमर म के एक झन सहीं हो गे हवय। एकरसेति अब अइसने झन होवय कि ओह हांथ लमाके जिनगी के रूख के फर ला घलो टोरके खा लेवय अऊ सदाकाल तक जीयत रहय।” ");
INSERT INTO hne_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","एकरसेति यहोवा परमेसर ह ओला अदन के बगीचा ले निकाल दीस कि ओह ओ भुइयां म काम करय, जेमा ले ओह बनाय गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","आदम ला निकाले के बाद, ओह जिनगी के रूख के रसता के रखवारी करे बर, अदन के बगीचा के पूरब दिग म करूबमन ला अऊ चारों कोति किंदरनेवाला आगी के तलवार ला घलो रख दीस। ");
INSERT INTO hne_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","जब आदम ह अपन घरवाली हवा संग सुतिस, त ओह आसरा म होके कैन ला जनम दीस अऊ कहिस, “मेंह यहोवा के मदद ले एक झन पुरूस पाय हंव।” ");
INSERT INTO hne_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","बाद म ओह ओकर भाई हाबिल ला जनम दीस। हाबिल ह भेड़-बकरी के चरवाहा बन गीस, अऊ कैन ह खेती-बारी करत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","कुछू दिन के बाद, कैन ह यहोवा करा भुइयां के कुछू फर चढ़ावा के रूप म लानिस। ");
INSERT INTO hne_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","अऊ हाबिल घलो अपन भेड़-बकरी के कुछू पहिलांतमन ला लानिस अऊ ओमन के चरबी ला चढ़ावा के रूप म चघाईस। यहोवा ह हाबिल अऊ ओकर चढ़ावा ला तो गरहन करिस, ");
INSERT INTO hne_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","पर कैन अऊ ओकर भेंट ला गरहन नइं करिस। एकरसेति कैन ह अब्बड़ गुस्सा होईस अऊ ओकर चेहरा ह उतर गीस। ");
INSERT INTO hne_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","तब यहोवा ह कैन ले पुछिस, “तेंह काबर गुस्सा होवत हस? तोर मुहूं ह काबर उतरे हवय? ");
INSERT INTO hne_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","जऊन ह सही ए, यदि तेंह ओला करते, त का तोर भेंट ह गरहन नइं होतिस? पर जऊन ह सही ए, यदि तेंह ओला नइं करस, त पाप ह तोर दुवारी म ठाढ़े हवय; ओकर लालसा तोला पाय बर होही, पर तोला ओकर ऊपर जय पाना जरूरी ए।” ");
INSERT INTO hne_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","एक दिन कैन ह अपन भाई हाबिल ला कहिस, “चल हमन खेत डहार जाबो।” जब ओमन खेत म रिहिन, त कैन ह अपन भाई हाबिल ऊपर हमला करके ओला मार डारिस। ");
INSERT INTO hne_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","तब यहोवा ह कैन ले पुछिस, “तोर भाई हाबिल कहां हे?” त कैन जबाब दीस, “में नइं जानंव; का मेंह अपन भाई के रखवार अंव?” ");
INSERT INTO hne_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","यहोवा ह कहिस, “तेंह का करे हस? सुन! तोर भाई के लहू ह भुइयां ले मोला नरियावथे। ");
INSERT INTO hne_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","अब तेंह एक सराप के अधीन हस अऊ ओ भुइयां ले निकाले जावत हस, जऊन ह तोर भाई के लहू तोर हांथ ले पीये बर अपन मुहूं फारिस। ");
INSERT INTO hne_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","जब तेंह भुइयां म खेती करबे, त ओह अब तोला अपन फसल नइं देवय। तेंह धरती म बियाकुल होके इहां-उहां भटकत रहिबे।” ");
INSERT INTO hne_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","तब कैन ह यहोवा ला कहिस, “मोर सजा ह मोर सहे के बाहिर ए। ");
INSERT INTO hne_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","आज तेंह मोला ये भुइयां म ले निकालत हस, अऊ मेंह तोर नजर के आड़ म हो जाहूं; अऊ धरती म अस्थिर होके इहां-उहां भटकत रहिहूं, अऊ जऊन कोनो मोला पाही, ओह मोला मार डारही।” ");
INSERT INTO hne_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","पर यहोवा ह ओला कहिस, “अइसने नइं होवय; जऊन कोनो कैन ला मारही, ओकर ले सात गुना बदला लेय जाही।” तब यहोवा ह कैन बर एक चिनहां ठहिरा दीस ताकि कोनो मनखे कैन ला पाके ओकर हतिया झन कर देवय। ");
INSERT INTO hne_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","तब कैन ह यहोवा के आघू ले चल दीस अऊ नोद नांव के देस म, जेह अदन के पूरब कोति हवय, रहे लगिस। ");
INSERT INTO hne_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","जब कैन अपन घरवाली संग सुतिस, तब ओकर घरवाली ह आसरा म होईस अऊ ओह हनोक ला जनम दीस। कैन ह तब एक सहर बसावत रिहिस, अऊ ओह ओ सहर के नांव अपन बेटा के नांव म हनोक रखिस। ");
INSERT INTO hne_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोक ले ईराद जनमिस, अऊ ईराद ह महूयाएल के ददा रिहिस, अऊ महूयाएल ह मतूसाएल के ददा रिहिस, अऊ मतूसाएल ह लेमेक के ददा रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेक ह दू झन माईलोगन ले बिहाव करिस, जेमा के एक झन के नांव आदा, अऊ दूसर के सिल्ला रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदा ह याबाल ला जनमिस; याबाल ह ओमन के पुरखा रिहिस जऊन मन तम्बू म रहिथें अऊ पसु-पालन करथें। ");
INSERT INTO hne_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ओकर भाई के नांव यूबाल रिहिस; जऊन ह जम्मो किसम के सितार अऊ बंसी बजइयामन के पुरखा रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","सिल्ला घलो तूबल-कैन नांव के एक बेटा ला जनमिस; जऊन ह कांसा अऊ लोहा ढारके औजार बनइया होईस। तूबल-कैन के बहिनी के नांव नामा रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लेमेक ह अपन घरवालीमन ला कहिस, “हे आदा अऊ सिल्ला, मोर गोठ ला सुनव; हे लेमेक के घरवालीमन, मोर बात ऊपर कान लगावव। मेंह एक मनखे ला, जेह मोला चोट पहुंचाय रिहिस, मार डारेंव। एक जवान, जऊन ह मोला घायल करे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","यदि कैन के बदला सात गुना लेय जाथे, त लेमेक के सतहत्तर गुना लेय जाही।” ");
INSERT INTO hne_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदम फेर अपन घरवाली संग सुतिस, अऊ ओकर घरवाली ह एक बेटा ला जनम दीस अऊ ओकर नांव ये कहिके सेत रखिस, “परमेसर ह मोला हाबिल के बदला म, जेला कैन ह मार डारिस, एक अऊ बेटा दे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","बाद म, सेत के घलो एक बेटा होईस; ओह ओकर नांव एनोस रखिस। ओही बेरा ले मनखेमन यहोवा ले पराथना करे के सुरू करिन। ");
INSERT INTO hne_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","येह आदम के खानदान के लिखित बिबरन अय। जब परमेसर ह मनखे ला बनाईस, त ओह अपन ही सरूप म ओला बनाईस। ");
INSERT INTO hne_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ओह ओमन ला नर अऊ नारी करके बनाईस अऊ ओमन ला आसीस दीस, अऊ ओमन के बनाय के दिन ओकर नांव “मनखे-जात” रखिस। ");
INSERT INTO hne_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","जब आदम ह 130 बछर के होईस, त ओकर एक बेटा ओकर समानता अऊ ओकर सरूप म जनमिस। ओह ओकर नांव सेत रखिस। ");
INSERT INTO hne_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","सेत के जनमे के बाद, आदम ह 800 बछर जीयत रिहिस, अऊ ओकर अऊ घलो बेटा-बेटी होईन। ");
INSERT INTO hne_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ये किसम ले आदम के कुल उमर 930 बछर होईस, अऊ तब ओह मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","जब सेत 105 बछर के होईस, त ओह एनोस के ददा होईस। ");
INSERT INTO hne_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोस के जनम के बाद, सेत ह 807 बछर तक जीयत रिहिस, अऊ ओकर अऊ बेटा-बेटी होईन। ");
INSERT INTO hne_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ये किसम ले सेत के कुल उमर 912 बछर होईस, अऊ तब ओह मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","जब एनोस 90 बछर के होईस, तब ओकर ले केनान के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान के जनम के बाद, एनोस 815 बछर तक जीयत रिहिस, अऊ ओकर अऊ घलो बेटा-बेटी होईन। ");
INSERT INTO hne_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ये किसम ले एनोस के कुल उमर 905 बछर होईस, अऊ तब ओह मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","जब केनान 70 बछर के होईस, त ओकर ले महललेल के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महललेल के जनम के बाद, केनान 840 बछर तक जीयत रिहिस, अऊ ओकर अऊ घलो बेटा-बेटी होईन। ");
INSERT INTO hne_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ये किसम ले केनान के कुल उमर 910 बछर होईस, अऊ तब ओह मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","जब महललेल 65 बछर के होईस, त ओकर ले येरेद के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","येरेद के जनम के बाद, महललेल 830 बछर तक जीयत रिहिस, अऊ ओकर अऊ घलो बेटा-बेटी होईन। ");
INSERT INTO hne_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ये किसम ले महललेल के कुल उमर 895 बछर होईस, अऊ तब ओह मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","जब येरेद 162 बछर के होईस, त ओकर ले हनोक के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोक के जनम के बाद, येरेद 800 बछर तक जीयत रिहिस, अऊ ओकर अऊ भी बेटा-बेटी होईन। ");
INSERT INTO hne_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ये किसम ले येरेद के कुल उमर 962 बछर होईस, अऊ तब ओह मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","जब हनोक 65 बछर के होईस, त ओकर ले मतूसेलह के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मतूसेलह के जनम के बाद, हनोक 300 बछर तक परमेसर के संग-संग चलिस, अऊ ओकर अऊ भी बेटा-बेटी होईन। ");
INSERT INTO hne_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ये किसम ले हनोक के कुल उमर 365 बछर होईस। ");
INSERT INTO hne_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोक ह ईमानदारी से परमेसर के संग चलिस; तब ओह गायब हो गीस, काबरकि परमेसर ह ओला उठा लीस। ");
INSERT INTO hne_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","जब मतूसेलह 187 बछर के होईस, त ओकर ले लेमेक के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लेमेक के जनम के बाद, मतूसेलह 782 बछर जीयत रिहिस, अऊ ओकर अऊ भी बेटा-बेटी होईन। ");
INSERT INTO hne_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ये किसम ले मतूसेलह के कुल उमर 969 बछर होईस, अऊ तब ओह मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","जब लेमेक 182 बछर के होईस, त ओकर ले एक बेटा होईस। ");
INSERT INTO hne_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ओह ओकर नांव ए कहिके नूह रखिस, “यहोवा ह धरती ला जऊन सराप दे हे, ओकर बारे म, ये बाबू-पीला ह हमर काम म अऊ जऊन कठोर मेहनत हमन करथन, ओमा हमन ला सांति दीही।” ");
INSERT INTO hne_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नूह के जनम के बाद, लेमेक 595 बछर तक जीयत रिहिस, अऊ ओकर अऊ बेटा-बेटी जनमिन। ");
INSERT INTO hne_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ये किसम ले लेमेक के कुल उमर 777 बछर होईस, अऊ तब ओह मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","जब नूह 500 बछर के होईस, त ओकर ले सेम, हाम अऊ येपेत के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","जब मनखेमन धरती म गनती म बाढ़े लगिन अऊ ओमन के बेटीमन जनमिन, ");
INSERT INTO hne_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","त परमेसर के बेटामन देखिन कि मनखे के बेटीमन सुघर हें अऊ ओमन जे-जे ला पसंद करिन, तेमन ले बिहाव कर लीन। ");
INSERT INTO hne_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","तब यहोवा ह कहिस, “मोर आतमा ह मनखे संग सदाकाल बर नइं रहय, काबरकि मनखे ह अमर नो हय; ओमन के उमर एक सौ बीस बछर होही।” ");
INSERT INTO hne_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ओ समय धरती म नेफिलीम रहत रिहिन, अऊ एकर पाछू जब परमेसर के बेटामन मनखे के बेटीमन संग संबंध बनाईन, त ओमन के मेल से जऊन लइका जनमिन, ओमन ओ समय सूरबीर अऊ जाने-माने मनखे रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","यहोवा ह देखिस कि मनखेमन के बुरई धरती म बहुंत बढ़ गे हवय, अऊ ओमन के हिरदय के जम्मो बिचार ह हर समय सिरिप बुरई के ही होथे। ");
INSERT INTO hne_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","त यहोवा ह धरती म मनखे ला बनाके पछताईस, अऊ अपन मन म बहुंत दुखी होईस। ");
INSERT INTO hne_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","एकरसेति यहोवा ह कहिस, “मेंह मनखे ला, जेला मेंह बनाय हंव, धरती म ले नास कर दूहूं—अऊ ओमन के संग पसु, चिरई अऊ भुइयां म रेंगइया जन्तु, ओ जम्मो ला नास कर दूहूं—काबरकि मेंह ओमन ला बनाके पछतात हंव।” ");
INSERT INTO hne_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","पर यहोवा के दया-दिरिस्टी नूह ऊपर बने रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नूह अऊ ओकर परिवार के बिबरन ये अय। नूह एक धरमी अऊ अपन समय के मनखेमन म निरदोस रिहिस, अऊ ओह ईमानदारी से परमेसर के संग चलिस। ");
INSERT INTO hne_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नूह के तीन झन बेटा रिहिन: सेम, हाम अऊ येपेत। ");
INSERT INTO hne_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ओ समय धरती ह परमेसर के नजर म खराप हो गे रिहिस अऊ हिंसा ले भर गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","परमेसर ह देखिस कि धरती ह बहुंत खराप हो गे हे, काबरकि धरती के जम्मो मनखेमन अपन चालचलन ला बिगाड़ ले रहंय। ");
INSERT INTO hne_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","एकरसेति परमेसर ह नूह ला कहिस, “मेंह जम्मो मनखे के अन्त करइया हंव, काबरकि ओमन के कारन धरती ह हिंसा ले भर गे हवय। मेंह निस्चित रूप से ओमन ला धरती समेत नास करइया हंव। ");
INSERT INTO hne_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","एकरसेति तें गोपेर रूख के लकरी के एक पानी जहाज बना ले; ओकर भीतर म खोलीमन ला बनाबे, अऊ ओकर भीतर-बाहिर राल लगा देबे। ");
INSERT INTO hne_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","तें ओला अइसने बनाबे: जहाज ला तीन सौ क्यूबीट लम्बा, पचास क्यूबीट चाकर अऊ तीस क्यूबीट ऊंच बनाबे। ");
INSERT INTO hne_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","जहाज के एक छत बनाबे अऊ छत खाल्हे एक क्यूबीट ऊंच खिड़की जहाज के चारों कोति बनाबे। जहाज के बाजू म एक कपाट रखबे अऊ जहाज ला तीन तल्ला बनाबे। ");
INSERT INTO hne_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","काबरकि देख, में धरती म जल-परलय करके जम्मो चीज ला जेमन म जिनगी के सांस हवय, अकास के तरी ले नास करइया हंव। धरती ऊपर जऊन कुछू हवय, सबो चीज नास हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","पर मेंह तोर संग करार करहूं, अऊ तेंह जहाज के भीतर जाबे—तोर बेटामन अऊ तोर घरवाली अऊ तोर बेटामन के घरवालीमन घलो तोर संग जहाज के भीतर जाहीं। ");
INSERT INTO hne_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","अऊ जम्मो जीयत परानी म ले, तें हर एक जाति के दू-दू ठन याने कि एक नर अऊ एक मादा ला जहाज भीतर लानबे अऊ ओमन ला अपन संग जीयत रखबे। ");
INSERT INTO hne_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","हर किसम के चिरई, हर किसम के पसु अऊ भुइयां म रेंगइया हर किसम के जीव म के दू-दू ठन तोर करा जीयत रहे बर आहीं। ");
INSERT INTO hne_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","तें आनि-बानि के खाय के जिनिस जेला खाय जाथे, अपन करा जमा कर लेबे, जऊन ह तोर अऊ ओमन के जेवन बर होही।” ");
INSERT INTO hne_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","परमेसर के हुकूम के मुताबिक नूह हर चीज ला करिस। ");
INSERT INTO hne_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","तब यहोवा ह नूह ला कहिस, “तें अपन पूरा घराना समेत जहाज म जा, काबरकि मेंह ये पीढ़ी के मनखे म तोला अपन नजर म धरमी पाय हंव। ");
INSERT INTO hne_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","हर किसम के सुध पसु म ले, तें सात-सात जोड़ी याने कि नर अऊ मादा ले, पर हर किसम के असुध पसु म ले एक-एक जोड़ी याने कि नर अऊ मादा ले, ");
INSERT INTO hne_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","अऊ हर किसम के चिरई म ले घलो सात-सात जोड़ी याने कि नर अऊ मादा ले ताकि ओमन के बंस बांचके जम्मो धरती म बने रहंय। ");
INSERT INTO hne_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","सात दिन के बाद, मेंह धरती म चालीस दिन अऊ चालीस रात तक बरसा करहूं, अऊ मेंह जम्मो जीयत परानीमन ला धरती म ले नास कर दूहूं, जेमन ला मेंह बनाय हवंव।” ");
INSERT INTO hne_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","अऊ जइसे यहोवा ह हुकूम देय रिहिस, ओकरे मुताबिक नूह जम्मो चीज ला करिस। ");
INSERT INTO hne_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","नूह के उमर छै सौ साल रिहिस, जब धरती ऊपर जल-परलय आईस। ");
INSERT INTO hne_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नूह ह अपन बेटा, घरवाली अऊ बहुमन के संग जल-परलय ले बांचे बर जहाज भीतर गीस। ");
INSERT INTO hne_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","सुध अऊ असुध दूनों किसम के पसु, चिरई अऊ भुइयां म रेंगइया जम्मो जन्तु म ले एक-एक जोड़ी ");
INSERT INTO hne_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","याने कि नर अऊ मादा, नूह करा आईन अऊ जहाज भीतर गीन, जइसने कि परमेसर ह नूह ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","अऊ सात दिन के बाद, जल-परलय धरती म होय लगिस। ");
INSERT INTO hne_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नूह के जिनगी के छै सौवां साल के दूसरा महिना के सतरहवां दिन गहिरा समुंदर के सोतामन फूट गीन अऊ अकास के पानी के झरोखामन घलो खुल गीन। ");
INSERT INTO hne_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","अऊ चालीस दिन अऊ चालीस रात तक धरती म लगातार बरसा होते रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ठीक ओही दिन नूह अपन बेटा सेम, हाम, येपेत अऊ अपन घरवाली अऊ तीनों बहुमन संग जहाज भीतर गीस। ");
INSERT INTO hne_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ओमन के संग हर किसम के जंगली पसु, हर किसम के घरेलू-पसु, हर किसम के धरती ऊपर रेंगइया जन्तु, अऊ हर किसम के उड़इया चिरईमन के एक-एक जोड़ी जहाज म गीन। ");
INSERT INTO hne_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","जम्मो परानी जेमा जिनगी के सांस रिहिस, ओमा के एक-एक जोड़ी नूह करा आईन अऊ जहाज भीतर गीन। ");
INSERT INTO hne_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","जऊन पसुमन भीतर जावत रिहिन, ओमा हर किसम के जीव-जन्तु के नर अऊ मादा रिहिन जइसने कि परमेसर ह नूह ला हुकूम दे रिहिस। तब यहोवा ह नूह के भीतर जाय के बाद जहाज के कपाट ला बंद कर दीस। ");
INSERT INTO hne_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","धरती म चालीस दिन तक पानी के परलय होते रिहिस, अऊ जइसे-जइसे पानी बढ़त गीस, वइसे-वइसे जहाज ह धरती ले ऊपर उठत गीस। ");
INSERT INTO hne_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","पानी बढ़त-बढ़त धरती ऊपर बहुंत हो गे अऊ जहाज पानी ऊपर तउंरे लगिस। ");
INSERT INTO hne_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","पानी ह धरती ऊपर अतेक भर गीस कि धरती के जम्मो बड़े-बड़े पहाड़ घलो बुड़ गीन। ");
INSERT INTO hne_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","पानी ह अऊ बढ़के पहाड़मन के ऊपर पंदरह क्यूबीट ले घलो जादा भर गीस। ");
INSERT INTO hne_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","भुइयां म रहइया जम्मो जीव—चिरई, घरेलू-पसु, जंगली पसु, धरती के जम्मो उड़नेवाला जीव, अऊ जम्मो मनखे नास हो गीन। ");
INSERT INTO hne_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","सूखा भुइयां म रहइया हर ओ चीज जऊन म जिनगी के सांस रिहिस, ओ जम्मो के जम्मो मर गीन। ");
INSERT INTO hne_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","धरती के ऊपर जम्मो जीयत चीज के नास हो गीस; मनखे अऊ पसु अऊ भुइयां म रेंगइया जीव अऊ चिरई जम्मो के जम्मो धरती ले मर मिटिन। सिरिप नूह अऊ जतेक झन ओकर संग जहाज म रिहिन, ओमन बांचिन। ");
INSERT INTO hne_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","अऊ पानी धरती ऊपर एक सौ पचास दिन तक भरे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","अऊ परमेसर ह नूह अऊ जतेक जंगली पसु अऊ घरेलू-पसु ओकर संग जहाज म रिहिन, ओ जम्मो के सुधि लीस, अऊ परमेसर ह धरती ऊपर हवा बहाईस, अऊ पानी अंटाय लगिस। ");
INSERT INTO hne_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","अब गहिरा समुंदर के सोता अऊ अकास के पानी के झरोखामन बंद कर दिये गीन, अऊ अकास ले पानी गिरे के बंद हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","अऊ पानी ह धरती ले लगातार कम होवत गीस। एक सौ पचास दिन के बाद पानी ह कम होय लगिस; ");
INSERT INTO hne_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","अऊ साल के सातवां महिना के सतरहवां दिन जहाज ह अरारात नांव के पहाड़ म टेक गीस। ");
INSERT INTO hne_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","पानी ह दसवां महिना तक अंटात गीस, अऊ दसवां महिना के पहिला दिन पहाड़ के चोटीमन दिखे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ओकर चालीस दिन के बाद नूह ह अपन बनाय जहाज के एक खिड़की ला खोलिस ");
INSERT INTO hne_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","अऊ एक ठन कऊआ ला उड़ा दीस, अऊ जब तक पानी ह धरती ऊपर ले नइं सूखा गीस, ओ कऊआ ह धरती ऊपर एती-ओती उड़ते रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","तब ओह एक ठन पंड़की ला ये देखे बर उड़िया दीस कि पानी धरती ऊपर ले अंटाईस कि नइं। ");
INSERT INTO hne_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","पर ओ पंड़की ला बईठे बर कोनो ठिकाना नइं मिलिस, काबरकि जम्मो धरती ह पानी ले भरे रिहिस, एकरसेति ओह लहुंटके नूह करा जहाज म आ गीस। तब नूह ह हांथ लमाके ओला वापिस अपन करा जहाज म ले आईस। ");
INSERT INTO hne_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","तब ओह सात दिन तक ठहिरके ओ पंड़की ला जहाज ले फेर उड़िया दीस। ");
INSERT INTO hne_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","जब ओ पंड़की ह सांझकुन नूह करा लहुंटके आईस, त ओह देखिस कि पंड़की के चोंच म जैतून के एक नवां पान हवय! तब नूह ह जान डारिस कि पानी धरती ऊपर ले अंटा गे हे। ");
INSERT INTO hne_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ओह सात दिन अऊ ठहिरके ओ पंड़की ला फेर उड़िया दीस, पर ये समय ओह फेर लहुंटके नूह करा नइं आईस। ");
INSERT INTO hne_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नूह के उमर के छै सौ एक बछर के पहिला महिना के पहिला दिन, पानी ह धरती ऊपर ले सूखा गीस। नूह ह तब जहाज के छानी ला खोल दीस अऊ देखिस कि धरती ह सूखा गे हे। ");
INSERT INTO hne_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दूसर महिना के सत्ताईसवां दिन धरती ह पूरा सूखा गीस। ");
INSERT INTO hne_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","तब परमेसर ह नूह ला कहिस, ");
INSERT INTO hne_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“तें अपन घरवाली, बेटा, अऊ बहुमन के संग जहाज ले निकल आ। ");
INSERT INTO hne_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","चिरई, पसु, अऊ जम्मो किसम के धरती ऊपर रेंगइया जन्तुमन ला घलो अपन संग निकालके ले आ ताकि धरती ऊपर ओमन बहुंत फूलंय-फरंय अऊ धरती म ओमन के गनती बढ़य।” ");
INSERT INTO hne_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","तब नूह, अपन बेटा, घरवाली अऊ बहुमन संग निकल आईस। ");
INSERT INTO hne_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","जम्मो पसु अऊ भुइयां म रेंगइया जम्मो जन्तु, अऊ जम्मो चिरई अऊ जम्मो जीव-जन्तु, जऊन मन धरती म रेंगथें-बुलथें, अपन जाति-जाति के मुताबिक जहाज ले निकल आईन। ");
INSERT INTO hne_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","तब नूह ह यहोवा बर एक बेदी बनाईस, अऊ जम्मो सुध पसु अऊ जम्मो सुध चिरई म ले थोर-थोर लेके बेदी ऊपर होम-बलिदान करिस। ");
INSERT INTO hne_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","यहोवा ह सुख-देवइया सुगंध ला सुंघके अपन मन म कहिस: “मनखे के कारन, में फेर कभू भुइयां ला सराप नइं दंव, हालाकि मनखे के लइकापन ले जऊन भी बिचार ओकर मन म आथे, ओह खराप ही होथे। पर जइसने मेंह जम्मो जीवमन ला नास करे हंव, वइसने अऊ फेर कभू नइं करंव। ");
INSERT INTO hne_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“अब ले जब तक धरती ह रहिही, तब तक बीजा बोय अऊ लुये के समय, जाड़ा अऊ गरमी, धूपकाला अऊ जड़काला, दिन अऊ रात लगातार होवत रहिहीं।” ");
INSERT INTO hne_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","फेर परमेसर ह नूह अऊ ओकर बेटामन ला आसीस दीस अऊ ओमन ला कहिस, “फूलव-फरव अऊ गनती म बढ़व अऊ धरती म भर जावव। ");
INSERT INTO hne_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","तुम्हर डर अऊ भय धरती के जम्मो पसु, अऊ अकास के जम्मो चिरई, अऊ भुइयां म रेंगइया जम्मो जीव, अऊ समुंदर के जम्मो मछरीमन ऊपर बने रहय; ये जम्मो ला तुम्हर बस म करे जावथे। ");
INSERT INTO hne_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","जम्मो जीयत अऊ रेंगइया जन्तुमन तुम्हर खाय बर हवंय। जइसने मेंह तुमन ला हरियर पऊधा दे रहेंव, वइसने मेंह अब तुमन ला हर चीज देवत हंव। ");
INSERT INTO hne_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“पर मांस ला तुमन परान सहित याने कि लहू समेत झन खाहू। ");
INSERT INTO hne_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","अऊ मेंह तुम्हर लहू याने कि परान के जरूर बदला लूहूं। मेंह जम्मो पसुमन ले बदला लूहूं। अऊ हर एक मनखे ले घलो मेंह दूसर मनखे के परान के बदला लूहूं। ");
INSERT INTO hne_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“जऊन कोनो मनखे के लहू बहाही, ओकर लहू मनखे के दुवारा बहाय जाही; काबरकि परमेसर ह मनखे ला अपनेच सरूप म बनाय हवय। ");
INSERT INTO hne_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","अऊ तुमन फूलव-फरव अऊ गनती म बढ़व; धरती ऊपर बहुंत बढ़व अऊ येमा भर जावव।” ");
INSERT INTO hne_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","फेर परमेसर ह नूह अऊ ओकर बेटामन ला कहिस, ");
INSERT INTO hne_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“सुनव, में अब तुम्हर संग अऊ तुम्हर पाछू तुम्हर होवइया संतानमन संग करार करत हंव; ");
INSERT INTO hne_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","अऊ जम्मो जीयत परानी जेमन तुम्हर संग हवंय—चिरई, घरेलू-पसु अऊ जम्मो जंगली पसु, अऊ धरती ऊपर जम्मो जीयत परानी, जऊन मन तुम्हर संग जहाज ले निकले हवंय, ओमन संग घलो। ");
INSERT INTO hne_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","में तुम्हर संग अपन ये करार करत हंव: फेर कभू जम्मो परानी जल-परलय ले नास नइं होवंय; फेर कभू धरती ला नास करे बर जल-परलय नइं होवय।” ");
INSERT INTO hne_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","फेर परमेसर ह कहिस, “जऊन करार मेंह तुम्हर अऊ जतेक जीयत परानी तुम्हर संग हवंय, ओ सबो के संग करत हंव, येह अवइया तुम्हर जम्मो पीढ़ी बर होही अऊ ओकर ये चिनहां होही: ");
INSERT INTO hne_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","मेंह बादर म अपन मेघ-धनुस रखे हवंव, अऊ येह मोर अऊ धरती के बीच म करार के चिनहां होही। ");
INSERT INTO hne_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","जब भी में धरती ऊपर बादर लानंव अऊ बादर म मेघ-धनुस दिखय, ");
INSERT INTO hne_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","त मेंह जऊन करार तुम्हर अऊ जम्मो किसम के जीयत परानीमन संग करे हंव, ओला में सुरता करहूं। फेर कभू अइसन जल-परलय जम्मो परानी के बिनास बर नइं होवय। ");
INSERT INTO hne_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","जब भी बादर म मेघ-धनुस दिखही, त मेंह ओला देखके ओ सदाकाल के करार ला सुरता करहूं, जऊन ला परमेसर अऊ धरती के जम्मो किसम के जीयत परानीमन के बीच करे गे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","फेर परमेसर ह नूह ले कहिस, “जऊन करार मेंह धरती के जम्मो परानीमन संग करे हंव, ओकर ये चिनहां अय।” ");
INSERT INTO hne_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नूह के बेटा, जेमन जहाज ले निकलिन, ओमन के नांव सेम, हाम अऊ येपेत रिहिस। (हाम ह कनान के ददा रिहिस।) ");
INSERT INTO hne_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","येमन नूह के तीन बेटा रिहिन, अऊ येमन के संतानमन जम्मो धरती म बगर गीन। ");
INSERT INTO hne_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नूह ह भुइयां ले जुड़े मनखे रिहिस अऊ ओह अंगूर के एक बारी लगाईस। ");
INSERT INTO hne_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","एक दिन ओह अंगूर के मंद ला पीके मतवार हो गीस, अऊ अपन तम्बू के भीतर नंगरा पड़े रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","तब कनान के ददा, हाम ह अपन ददा ला नंगरा देखिस अऊ बाहिर आके अपन दूनों भाईमन ला बताईस। ");
INSERT INTO hne_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","तब सेम अऊ येपेत एक कपड़ा लेके अपन खांधा म रखिन अऊ उल्टा रेंगत अपन ददा के नंगरा देहें ला ढांप दीन। ओमन अपन मुहूं ला आने कोति करे रिहिन ताकि ओमन अपन ददा ला नंगरा झन देखंय। ");
INSERT INTO hne_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जब नूह के नसा उतरिस, त ओह जान डारिस कि ओकर सबले छोटे बेटा ह ओकर संग का करे हे। ");
INSERT INTO hne_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","एकरसेति ओह कहिस, “कनान ला सराप लगय! ओह अपन भाईमन के दास म सबले छोटे दास होवय।” ");
INSERT INTO hne_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ओह ये घलो कहिस, “सेम के परमेसर यहोवा के महिमा होवय! कनान ह सेम के दास होवय। ");
INSERT INTO hne_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेसर ह येपेत के इलाका ला बढ़ाय; येपेत ह सेम के तम्बू म रहय अऊ कनान ह येपेत के गुलाम बनय।” ");
INSERT INTO hne_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","जल-परलय के बाद नूह 350 बछर जीईस। ");
INSERT INTO hne_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ये किसम ले नूह के कुल उमर 950 बछर होईस, अऊ तब ओह मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","येह नूह के बेटा सेम, हाम अऊ येपेत के बंसावली अय। जल-परलय के बाद ओमन के ये बेटामन जनमिन। ");
INSERT INTO hne_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेत के बेटामन: गोमेर, मागोग, मादै, यावान, तूबल, मेसेक अऊ तीरास होईन। ");
INSERT INTO hne_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेर के बेटामन: असकनज, रीपत अऊ तोगरमा होईन। ");
INSERT INTO hne_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावान के बेटामन: एलीसाह, तरसीस, कित्ती अऊ रोदानीमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(येमन ले समुंदर तीर के मनखेमन अपन-अपन छेत्र म अपन गोत्र, अपन जाति अऊ अपन भासा के मुताबिक अलग-अलग हो गीन।) ");
INSERT INTO hne_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हाम के बेटामन: कूस, मिसर, पूत अऊ कनान होईन। ");
INSERT INTO hne_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूस के बेटामन: सबा, हवीला, सबता, रामा, अऊ सबतका होईन। रामा के बेटामन: सेबा अऊ ददान होईन। ");
INSERT INTO hne_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूस ह निमरोद के ददा रिहिस; निमरोद ह धरती म पहिला बड़े बीर होईस। ");
INSERT INTO hne_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ओह यहोवा के नजर म एक बड़े सिकारी रिहिस; एकर खातिर ये कहे जाथे, “निमरोद के सहीं, यहोवा के नजर म एक बड़े सिकारी।” ");
INSERT INTO hne_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ओकर राज के पहिली केन्द्रमन सिनार देस म बेबिलोन, ऊरूक, अक्कद अऊ कलने रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ओ देस ले, ओह निकलके अस्सूर देस म गीस, अऊ उहां नीनवे, रहोबोत-ईर अऊ कालह सहर बसाईस, ");
INSERT INTO hne_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","अऊ नीनवे अऊ कालह के बीच म रेसेन सहर बसाईस—जऊन ह बड़े सहर अय। ");
INSERT INTO hne_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिसर ह लूदी, अनामी, लहाबी, नपतूही, ");
INSERT INTO hne_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","अऊ पतरूसी, कसलूही (जेकर ले पलिस्तीमन आईन) अऊ कपतोरी मनखेमन के ददा रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान के बड़े बेटा सीदोन रिहिस, तेकर पाछू हित्ती, ");
INSERT INTO hne_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, अमोरी, गिरगासी, ");
INSERT INTO hne_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिब्बी, अरकी, सीनी, ");
INSERT INTO hne_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अरवदी, समारी अऊ हमातीमन घलो होईन। (बाद म कनानी कुल के मनखेमन बगर गीन ");
INSERT INTO hne_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","अऊ कनानीमन के सीमना ह सीदोन ले लेके गरार के तरफ गाजा तक, अऊ फेर सदोम, अमोरा, अदमा अऊ सबोईम के तरफ लासा तक होईस।) ");
INSERT INTO hne_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","येमन हाम के बंसज रिहिन, अऊ येमन अपन गोत्र अऊ भासा के मुताबिक अपन-अपन इलाका अऊ जाति म अलग हो गीन। ");
INSERT INTO hne_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","सेम जऊन ह येपेत के बड़े भाई रिहिस, ओकर घलो बेटामन होईन, अऊ सेम ह जम्मो एबेर बंस के पुरखा रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","सेम के बेटामन: एलाम, अस्सूर, अर्पछद, लूद अऊ अराम होईन। ");
INSERT INTO hne_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अराम के बेटामन: ऊस, हूल, गेतेर अऊ मेसेक होईन। ");
INSERT INTO hne_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पछद ह सेलह के ददा अऊ सेलह ह एबेर के ददा रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबेर के दू झन बेटा होईन: एक के नांव पेलेग रखे गीस, काबरकि ओकर समय म धरती ह बंट गीस; ओकर भाई के नांव योकतान रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","योकतान के बेटामन अलमोदाद, सेलेप, हसरमावेत, येरह ");
INSERT INTO hne_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोराम, ऊजाल, दिकला, ");
INSERT INTO hne_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, सेबा, ");
INSERT INTO hne_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला अऊ योबाब रिहिन। ये जम्मो योकतान के बेटा रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(ओ जगह जिहां येमन रहत रिहिन, ओह पूरब दिग के पहाड़ी देस म मेसा ले लेके सपारा तक फईले रिहिस।) ");
INSERT INTO hne_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","येमन सेम के बंसज रिहिन, अऊ येमन अपन गोत्र अऊ भासा के मुताबिक अपन-अपन छेत्र अऊ जाति म अलग हो गीन। ");
INSERT INTO hne_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","अपन-अपन संतान अऊ जाति के मुताबिक, येमन नूह के बेटामन के बंसज अंय। जल-परलय के बाद, जाति-जाति के मनखेमन येमन ले निकलके धरती म बगर गीन। ");
INSERT INTO hne_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","जम्मो धरती म एके ठन भासा अऊ एके किसम के बोली रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ओ समय जब मनखेमन पूरब दिग कोति जावत रिहिन, त ओमन ला सिनार देस म एक मैदान मिलिस अऊ उहां ओमन बस गीन। ");
INSERT INTO hne_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","तब ओमन एक-दूसर ला कहिन, “आवव, हमन ईंटा बना-बनाके ओला आगी म बने करके पकावन।” ओमन पथरा के बदला ईंटा अऊ चूना के गारा के बदला डामर के उपयोग करिन। ");
INSERT INTO hne_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","फेर ओमन कहिन, “आवव, हमन अपन बर एक सहर अऊ एक मीनार बनावन, जेकर चोटी अकास तक हबरे, ताकि हमर नांव होवय; नइं तो हमन ला जम्मो धरती ऊपर बगरे बर पड़ही।” ");
INSERT INTO hne_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","जब मनखेमन सहर अऊ मीनार बनाय लगिन, त यहोवा ह ओ सहर अऊ मीनार ला देखे बर खाल्हे उतर आईस। ");
INSERT INTO hne_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","अऊ यहोवा ह कहिस, “ये जम्मो झन एकेच दल अंय, अऊ येमन के भासा घलो एके ठन अय, अऊ येमन ये काम ला सुरू कर डारे हें; अब येमन जऊन कुछू भी बनाय के योजना करहीं, येमन बर कुछू भी असंभव नइं होही। ");
INSERT INTO hne_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","एकरसेति आवव, हमन उतरके येमन के भासा म गड़बड़ी कर देवन ताकि येमन एक-दूसर के बात ला झन समझंय।” ");
INSERT INTO hne_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","अइसने करके यहोवा ह ओमन ला उहां ले जम्मो धरती ऊपर बगरा दीस, अऊ ओमन ओ सहर ला बनाना छोंड़ दीन। ");
INSERT INTO hne_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","एकरे बर ओ सहर के नांव बेबिलोन पड़िस—काबरकि उहां यहोवा ह जम्मो धरती के भासा म गड़बड़ी करिस, अऊ उहां ले यहोवा ह मनखेमन ला धरती के जम्मो जगह बगरा दीस। ");
INSERT INTO hne_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","सेम के परिवार के बिबरन ये अय। जल-परलय के दू बछर के पाछू, जब सेम ह 100 बछर के होईस, त ओह अर्पछद के ददा होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अर्पछद के जनम के पाछू, सेम ह 500 बछर जीयत रिहिस अऊ ओकर अऊ भी बेटा-बेटीमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","जब अर्पछद 35 बछर के होईस, त ओकर ले सेलह के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","अऊ सेलह के जनम के पाछू, अर्पछद ह 403 बछर अऊ जीयत रिहिस अऊ ओकर अऊ भी बेटा-बेटीमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","जब सेलह 30 बछर के होईस, त ओकर ले एबेर के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","अऊ एबेर के जनम के पाछू, सेलह ह 403 बछर अऊ जीयत रिहिस अऊ ओकर अऊ भी बेटा-बेटीमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","जब एबेर 34 बछर के होईस, त ओकर ले पेलेग के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","अऊ पेलेग के जनम के पाछू, एबेर 430 बछर अऊ जीयत रिहिस अऊ ओकर अऊ भी बेटा-बेटीमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","जब पेलेग 30 बछर के होईस, त ओकर ले रू के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","अऊ रू के जनम के पाछू, पेलेग 209 बछर अऊ जीयत रिहिस अऊ ओकर अऊ बेटा-बेटीमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","जब रू 32 बछर के होईस, त ओकर ले सरूग के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","अऊ सरूग के जनम के पाछू, रू 207 बछर अऊ जीयत रिहिस अऊ ओकर अऊ बेटा-बेटीमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","जब सरूग 30 बछर के होईस, त ओकर ले नाहोर के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","अऊ नाहोर के जनम के पाछू, सरूग 200 बछर अऊ जीयत रिहिस अऊ ओकर अऊ बेटा-बेटीमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","जब नाहोर 29 बछर के होईस, त ओकर ले तेरह के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","अऊ तेरह के जनम के पाछू, नाहोर 119 बछर अऊ जीयत रिहिस अऊ ओकर अऊ बेटा-बेटीमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","जब तेरह 70 बछर के होईस, त ओकर ले अब्राम, नाहोर अऊ हारान के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरह के परिवार के बिबरन ये अय। तेरह ले अब्राम, नाहोर अऊ हारान के जनम होईस। अऊ हारान ले लूत के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान अपन ददा तेरह के जीते जी कसदीमन के ऊर नांव के नगर म, जऊन ह ओकर जनम भुइयां रिहिस, मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम अऊ नाहोर दूनों झन बिहाव कर लीन। अब्राम के घरवाली के नांव सारै, अऊ नाहोर के घरवाली के नांव मिलका रिहिस; ओह हारान के बेटी रिहिस, जऊन ह मिलका अऊ यिसका दूनों के ददा रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारै के कोनो बाल-बच्चा नइं रिहिन, काबरकि ओला कभू गरभ नइं ठहिरिस। ");
INSERT INTO hne_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेरह अपन बेटा अब्राम, अपन पोता लूत, जेह हारान के बेटा रिहिस, अऊ अपन बहू सारै, जेह ओकर बेटा अब्राम के घरवाली रिहिस, ये जम्मो झन ला लेके कसदीमन के ऊर नगर ले कनान देस जाय बर निकलिस। पर जब ओमन हारान नांव के देस म आईन, त उहेंच रहे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरह 205 बछर जीईस, अऊ ओह हारान देस म मर गीस। ");
INSERT INTO hne_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","यहोवा ह अब्राम ला कहिस, “अपन देस, अपन मनखे अऊ अपन ददा के परिवार ला छोंड़के ओ देस म चले जा, जेला मेंह तोला देखाहूं। ");
INSERT INTO hne_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“मेंह तोर ले एक बड़े जाति बनाहूं अऊ मेंह तोला आसीस दूहूं; मेंह तोर नांव ला बहुंत बड़े करहूं अऊ तेंह आसीस के कारन होबे। ");
INSERT INTO hne_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","जऊन मन तोला आसीस दीहीं, ओमन ला में आसीस दूहूं अऊ जऊन ह तोला सराप दीही, ओला मेंह सराप दूहूं; अऊ ये धरती के जम्मो मनखेमन तोर जरिये आसीस पाहीं।” ");
INSERT INTO hne_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","यहोवा के ये बचन के मुताबिक अब्राम ह चल पड़िस; अऊ ओकर संग लूत घलो गीस। अब्राम ह पचहत्तर बछर के रिहिस, जब ओह हारान देस ले निकलिस। ");
INSERT INTO hne_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्राम अपन घरवाली सारै, अपन भतीजा लूत, जऊन धन ओमन जमा करे रिहिन अऊ जऊन मनखेमन ला ओमन हारान म पाय रिहिन, ओ सबो ला लेके कनान देस जाय बर निकलिस अऊ ओमन कनान देस म आ गीन। ");
INSERT INTO hne_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ओ देस म ले होवत अब्राम ह सकेम म मोरे के बड़े रूख तक गीस। ओ समय ओ देस म कनानीमन रहत रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","तब यहोवा ह अब्राम ला दरसन देके कहिस, “तोर संतान ला में ये देस दूहूं।” एकरसेति ओह उहां यहोवा बर, जऊन ह ओला दरसन दे रिहिस, एक बेदी बनाईस। ");
INSERT INTO hne_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","फेर उहां ले चलके ओह ओ पहाड़ करा आईस, जऊन ह बेतेल के पूरब कोति हवय, अऊ उहां ओह अपन तम्बू गाड़िस, जेकर पछिम कोति बेतेल अऊ पूरब कोति अई नगर हवय। उहां घलो ओह यहोवा बर एक ठन बेदी बनाईस अऊ यहोवा के अराधना करिस। ");
INSERT INTO hne_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","तब अब्राम उहां ले निकलके नेगेव कोति चल दीस। ");
INSERT INTO hne_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","कनान देस म अकाल पड़िस, एकर कारन अब्राम ह खाल्हे कोति मिसर देस म चल दीस अऊ उहां कुछू समय तक रिहिस, काबरकि देस म भयंकर अकाल रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","जब ओह मिसर देस म हबरनेचवाला रिहिस, त ओह अपन घरवाली सारै ला कहिस, “सुन, मेंह जानत हंव कि तें एक सुघर नारी अस। ");
INSERT INTO hne_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","जब मिसर देस के मनखेमन तोला देखहीं, त कहिहीं, ‘येह ओकर घरवाली अय।’ तब ओमन मोला तो मार डारहीं, पर तोला छोंड़ दीहीं। ");
INSERT INTO hne_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","एकरसेति ये कहिबे कि तें मोर बहिनी अस, ताकि तोर कारन मोर संग बने बरताव होवय अऊ मोर परान ह तोर कारन बच जावय।” ");
INSERT INTO hne_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","जब अब्राम मिसर म आईस, त मिसर देस के मनखेमन देखिन कि सारै ह बहुंत सुघर हे। ");
INSERT INTO hne_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","अऊ जब फिरौन के अधिकारीमन ओला देखिन, त फिरौन के आघू म ओकर बड़ई करिन, एकरसेति सारै ला फिरौन के महल म लाय गीस। ");
INSERT INTO hne_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","फिरौन ह ओकर कारन से अब्राम के संग बने बरताव करिस, अऊ अब्राम ला भेड़-बकरी, गरूवा-बईला, गदहा-गदही अऊ दास-दासी, अऊ ऊंट मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","पर यहोवा ह फिरौन अऊ ओकर परिवार ऊपर अब्राम के घरवाली सारै के कारन बड़े-बड़े बेमारी लानिस। ");
INSERT INTO hne_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","तब फिरौन ह अब्राम ला बलाके कहिस, “तेंह मोर संग ये का करे हस? तें मोला काबर नइं बताय कि ओह तोर घरवाली ए? ");
INSERT INTO hne_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तेंह काबर कहे कि ओह तोर बहिनी ए? एकरसेति मेंह ओला अपन घरवाली बनाय बर ले गे रहेंव। पर अब अपन घरवाली ला ले अऊ इहां ले चले जा!” ");
INSERT INTO hne_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","तब फिरौन ह अपन मनखेमन ला अब्राम के बारे म हुकूम दीस, अऊ ओमन ओला अऊ ओकर घरवाली ला, ओकर जम्मो धन-संपत्ति सहित बिदा कर दीन। ");
INSERT INTO hne_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","तब अब्राम अपन घरवाली अऊ अपन जम्मो संपत्ति ला लेके मिसर देस ले नेगेव गीस, अऊ लूत घलो ओकर संग म गीस। ");
INSERT INTO hne_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम ह घरेलू-पसु अऊ सोन अऊ चांदी म अब्बड़ धनी हो गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","नेगेव ले चलके जगह-जगह होवत ओह बेतेल के लकठा म हबरिस, बेतेल अऊ अई नगर के बीच म, जिहां पहिली ओह अपन तम्बू ठाढ़ करे रिहिस ");
INSERT INTO hne_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","अऊ जिहां ओह पहिली बार बेदी बनाय रिहिस, उहां अब्राम ह यहोवा के अराधना करिस। ");
INSERT INTO hne_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","लूत, जऊन ह अब्राम संग चलत रिहिस, ओकर करा घलो भेड़-बकरी, गरूवा-बईला अऊ तम्बू रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","पर ओ जगह ह ओ दूनों ला नइं पूरत रिहिस। काबरकि ओमन के धन-संपत्ति अतकी जादा हो गे रिहिस कि ओमन एक संग रह नइं सकिन। ");
INSERT INTO hne_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","अब्राम अऊ लूत के चरवाहामन के बीच म झगरा होय लगिस। ओ समय कनानी अऊ परिज्जीमन घलो ओ देस म रहत रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","तब अब्राम ह लूत ला कहिस, “मोर अऊ तोर बीच, या मोर चरवाहा अऊ तोर चरवाहामन के बीच झगरा झन होवय, काबरकि हमन नजदीकी रिस्तेदार अन। ");
INSERT INTO hne_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","का पूरा देस तोर आघू म नइं ए? एकर खातिर मोर ले अलग हो जा। यदि तें डेरी कोति जाबे, त में जेवनी कोति जाहूं, अऊ यदि तें जेवनी कोति जाबे, त में डेरी कोति जाहूं।” ");
INSERT INTO hne_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","तब लूत ह चारों कोति देखिस कि सोअर कोति यरदन नदी के मैदान ह यहोवा के बगीचा अऊ मिसर देस सहीं पानी ले बने सिंचाय हवय। (येह ओ समय के बात ए, जब यहोवा ह सदोम अऊ अमोरा ला नास नइं करे रिहिस।) ");
INSERT INTO hne_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","एकरसेति लूत ह अपन बर यरदन के पूरा मैदान ला चुनके पूरब कोति गीस। अऊ ओ दूनों एक-दूसर ले अलग हो गीन: ");
INSERT INTO hne_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम ह कनान देस म रह गीस, जबकि लूत ह ओ मैदान के सहरमन म रहे लगिस अऊ अपन तम्बू सदोम के लकठा म ठाढ़ करिस। ");
INSERT INTO hne_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोम के मनखेमन दुस्ट रिहिन अऊ यहोवा के बिरूध बहुंत पाप करत रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","जब लूत ह अब्राम ले अलग हो गीस, तब यहोवा ह अब्राम ला कहिस, “जिहां तेंह ठाढ़े हस, उहां ले आंखी उठाके उत्तर, दक्खिन, पूरब अऊ पछिम चारों कोति देख। ");
INSERT INTO hne_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","काबरकि जतेक भुइयां तोला दिखत हे, ओ सब ला मेंह तोला अऊ तोर संतान ला सदाकाल बर दूहूं। ");
INSERT INTO hne_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","अऊ में तोर बंस के मनखेमन ला धरती के धुर्रा के कन सहीं बहुंत करहूं, ताकि यदि कोनो धरती के धुर्रा ला गने सकही, त फेर ओह तोर संतानमन ला घलो गने सकही। ");
INSERT INTO hne_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","उठ, अऊ ये देस के लम्बई अऊ चौड़ई म जतकी रेंग सकथस रेंग, काबरकि में येला तोला देवत हंव।” ");
INSERT INTO hne_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","एकरसेति अब्राम ह हेबरोन म ममरे के बड़े रूखमन के लकठा म रहे बर गीस अऊ उहां अपन तम्बू ठाढ़ करिस। अऊ उहां यहोवा बर एक ठन बेदी बनाईस। ");
INSERT INTO hne_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ओ समय जब सिनार के राजा अमरापेल, एल्लासार के राजा अरयोक, एलाम के राजा कदोरलाओमेर अऊ गोयीम के राजा तिदाल रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","त ये राजामन सदोम के राजा बेरा, अमोरा के राजा बिरसा, अदमा के राजा सिनाब, सबोईम के राजा सेमेबेर अऊ बेला के राजा (जऊन ला सोअर कहे जाथे) के बिरूध लड़ई करिन। ");
INSERT INTO hne_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ये पांचों राजामन सिद्दीम नांव के घाटी म (जऊन ला मिरतू सागर घाटी कहे जाथे) जूरिन। ");
INSERT INTO hne_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","काबरकि बारह बछर तक येमन कदोरलाओमेर के अधीन रिहिन, पर तेरहवां बछर म येमन ओकर बिरूध बिदरोह करिन। ");
INSERT INTO hne_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","चौदहवां बछर म कदोरलाओमेर अऊ ओकर संगी राजामन एक संग आईन अऊ असतरोत-करनेम म रपाईमन, हाम म जूजीमन, साबे-किरयातैम म एमीमन ");
INSERT INTO hne_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","अऊ सेईर के पहाड़ी म होरीमन ऊपर चढ़ई करिन अऊ ओमन ला हरावत-हरावत मरू-भुइयां के लकठा म एल-पारान तक हबर गीन। ");
INSERT INTO hne_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","तब उहां ले ओमन लहुंटके एन-मिसपात (जऊन ला कादेस कहे जाथे) म आईन, अऊ ओमन अमालेकीमन के जम्मो देस ला अऊ संग म ओ अमोरीमन ला घलो जीत लीन, जेमन हससोन-तामार म रहत रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","तब सदोम के राजा, अमोरा के राजा, अदमा के राजा, सबोईम के राजा अऊ बेला के राजा (जऊन ला सोअर कहे जाथे) निकलिन अऊ सिद्दीम नांव के घाटी म ");
INSERT INTO hne_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","एलाम के राजा कदोरलाओमेर, गोयीम के राजा तिदाल, सिनार के राजा अमरापेल अऊ एल्लासार के राजा अरयोक के बिरूध म लड़ई करे बर ठाढ़ होईन—चार राजामन पांच राजामन के बिरूध म रहंय। ");
INSERT INTO hne_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीम के घाटी ह डामर के खंचवामन ले भर गे रिहिस, अऊ जब सदोम अऊ अमोरा के राजामन भागिन, त कुछू मनखेमन ओ खंचवामन म गिरिन अऊ बांचे मनखेमन पहाड़ी ऊपर भाग गीन। ");
INSERT INTO hne_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","तब ओ चारों राजा सदोम अऊ अमोरा के जम्मो सामान अऊ खाय के चीजमन ला लूटके चल दीन। ");
INSERT INTO hne_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ओमन अब्राम के भतीजा लूत, जऊन ह सदोम म रहत रिहिस, ओला अऊ ओकर धन-संपत्ति ला घलो अपन संग ले गीन। ");
INSERT INTO hne_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","तब एक मनखे जऊन ह भागके बांच गे रिहिस, ओह जाके इबरी अब्राम ला ये बात बताईस। अब्राम तो अमोरी ममरे जऊन ह एसकोल अऊ आनेर के एक भाई रिहिस, ओकर बड़े रूखमन के लकठा म रहत रिहिस; येमन के संबंध अब्राम के संग संगवारी के सहीं रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जब अब्राम सुनिस कि ओकर भतीजा ला बंधुवई म ले गे हवंय, त ओह 318 लड़ई करे बर सिखोय मनखेमन ला, जेमन ओकर परिवार म जनमे रिहिन, लीस अऊ दान नगर तक ओमन के पीछा करिस। ");
INSERT INTO hne_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","रथिया के बेरा अब्राम ह ओमन ऊपर हमला करे बर अपन मनखेमन के अलग-अलग दल बनाईस अऊ दमिस्क सहर के उत्तर म होबा तक ओमन के पीछा करिस, अऊ ओमन ला हराईस। ");
INSERT INTO hne_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","अऊ ओह जम्मो सामान ला, अऊ अपन भतीजा लूत अऊ ओकर धन-संपत्ति ला, अऊ माईलोगन अऊ दूसर मनखेमन ला छोंड़ाके ले आईस। ");
INSERT INTO hne_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","जब अब्राम ह कदोरलाओमेर अऊ ओकर संगी राजामन ला हराके लहुंटत रिहिस, तब सदोम के राजा ह साबे नांव के घाटी म (जेला राजा के घाटी घलो कहे जाथे) अब्राम के संग भेंट करे बर आईस। ");
INSERT INTO hne_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","तब सालेम के राजा मलकिसिदक रोटी अऊ अंगूर के मंद लेके आईस। ओह सर्वोच्च परमेसर के पुरोहित रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","अऊ ओह ये कहिके अब्राम ला आसीस दीस, “सर्वोच्च परमेसर ले, जऊन ह अकास अऊ धरती के रचइता ए, तोला आसीस मिलय। ");
INSERT INTO hne_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","अऊ सर्वोच्च परमेसर के महिमा होवय, जऊन ह तोर बईरीमन ला तोर बस म कर दीस।” तब अब्राम ह ओला हर एक चीज के दसवां भाग दीस। ");
INSERT INTO hne_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","तब सदोम के राजा ह अब्राम ला कहिस, “मनखेमन ला तें मोला दे अऊ धन ला तें अपन बर रख।” ");
INSERT INTO hne_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","पर अब्राम ह सदोम के राजा ला कहिस, “यहोवा, सर्वोच्च परमेसर जऊन ह अकास अऊ धरती के रचइता ए, ओकर करा मेंह हांथ उठाके किरिया खाय हंव ");
INSERT INTO hne_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","कि जऊन चीज तोर अय, ओमा ले में कुछू नइं लेवंव, न एक ठन सूंत, न जूता के एक बंधना घलो, ताकि तें ये कभू झन कहे सकस, ‘मेंह अब्राम ला धनी बनांय।’ ");
INSERT INTO hne_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","पर जऊन कुछू मोर मनखेमन खा ले हवंय अऊ ओमन के बांटा, जऊन मन मोर संग गे रिहिन याने कि आनेर, एसकोल अऊ ममरे के बांटा, में तोला नइं लहुंटांव। ओमन ला अपन बांटा रखन दे।” ");
INSERT INTO hne_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","एकर पाछू, यहोवा के ये बचन दरसन के दुवारा अब्राम करा आईस: “हे अब्राम, झन डर। मेंह तोर ढाल अऊ तोर बड़े ईनाम अंव।” ");
INSERT INTO hne_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","पर अब्राम ह कहिस, “हे परमपरधान यहोवा, तें मोला का दे सकथस, जब में बिन लइका के हंव अऊ मोर घर के वारिस दमिस्क के एलिएजेर होही?” ");
INSERT INTO hne_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अऊ अब्राम ह कहिस, “मोला तो तें कोनो लइका नइं दे हस; एकरसेति मोर परिवार म एक दास ह मोर वारिस होही।” ");
INSERT INTO hne_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तब यहोवा के ये बचन ओकर करा आईस, “ये मनखे ह तोर वारिस नइं होवय, पर तोर खुद के मांस अऊ लहू ले जनमे बेटा ही तोर वारिस होही।” ");
INSERT INTO hne_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ओह ओला बाहिर ले जाके कहिस, “आंखी उठाके अकास कोति देख अऊ ये तारामन ला गन—का तें येमन ला गन सकथस?” फेर ओह ओला कहिस, “तोर संतान ह अइसने होही।” ");
INSERT INTO hne_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अब्राम ह यहोवा ऊपर बिसवास करिस, अऊ परमेसर ह येला अब्राम बर धरमीपन के बात मानिस। ");
INSERT INTO hne_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","परमेसर ह अब्राम ला ये घलो कहिस, “में ओही यहोवा अंव, जऊन ह तोला कसदीमन के ऊर नगर ले बाहिर लानेंव ताकि तोला ये देस ऊपर अधिकार देवंव।” ");
INSERT INTO hne_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","पर अब्राम ह कहिस, “हे परमपरधान यहोवा, में येला कइसे जानंव कि मेंह ये देस के ऊपर अधिकार रखहूं?” ");
INSERT INTO hne_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","त यहोवा ह ओला कहिस, “मोर बर तीन-तीन बछर के एक बछिया, एक बोकरा अऊ एक मेढ़ा लान अऊ संग म एक पंड़की अऊ एक परेवा के पीला लान।” ");
INSERT INTO hne_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","अब्राम ये जम्मो ला ओकर करा लानिस, अऊ ओमन के दू-दू कुटा करके ओ कुटामन ला एक-दूसर के आघू म मढ़ा दीस, पर चिरईमन ला ओह दू कुटा नइं करिस। ");
INSERT INTO hne_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","तब ओ मुरदामन ऊपर मांसाहारी चिरईमन झपटिन, पर अब्राम ओमन ला हंकाल दीस। ");
INSERT INTO hne_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","जब बेर ह बुड़त रिहिस, त अब्राम ह भारी नींद म सो गीस, अऊ भारी अऊ भयानक अंधियार ओकर ऊपर छा गीस। ");
INSERT INTO hne_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","तब यहोवा ह अब्राम ला कहिस, “ये बात ला निस्चय जान ले कि तोर संतानमन आने देस म चार सौ साल तक परदेसी होहीं अऊ उहां ओमन गुलाम बनाय जाहीं अऊ ओमन के ऊपर अतियाचार करे जाही। ");
INSERT INTO hne_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","पर जऊन देस के ओमन गुलाम के रूप म सेवा करहीं, ओ देस ला में दंड दूहूं, अऊ ओकर बाद ओमन उहां ले अब्बड़ धन लेके निकल आहीं। ");
INSERT INTO hne_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","पर, तें सांति से अपन पुरखामन संग मिल जाबे अऊ बने डोकरा होय के बाद तोला माटी मिलही। ");
INSERT INTO hne_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","पर चौथा पीढ़ी म, तोर संतानमन इहां फेर वापिस आहीं, काबरकि अमोरीमन के पाप के घड़ा ह अब तक नइं भरे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","जब बेर ह बुड़ गीस अऊ अंधियार छा गीस, तब एक अंगीठी म, जेमा ले धुआं उठत रहय, एक बरत मसाल दिखिस अऊ ओ मसाल मांस के कुटामन के बीच म ले निकल गीस। ");
INSERT INTO hne_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ओ दिन यहोवा ह अब्राम के संग एक करार करिस अऊ कहिस, “मिसर के नरवा ले लेके फरात नांव के बड़े नदी तक— ");
INSERT INTO hne_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","याने कि केनी, कनिज्जी, कदमोनी, ");
INSERT INTO hne_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परिज्जी, रपाई, ");
INSERT INTO hne_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","अमोरी, कनानी, गिरगासी अऊ यबूसीमन के देस ला में तोर संतानमन ला देवत हंव।” ");
INSERT INTO hne_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्राम के घरवाली सारै के कोनो संतान नइं रिहिस। पर ओकर हाजिरा नांव के एक झन मिसर देस के दासी रिहिस; ");
INSERT INTO hne_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","एकरसेति सारै ह अब्राम ला कहिस, “देख, यहोवा ह मोर कोख ला बंद कर दे हवय, एकरसेति तें मोर दासी के संग सुत; हो सकत हे कि ओकर दुवारा मोर परिवार आघू बढ़य।” सारै के ये बात ला अब्राम मान लीस। ");
INSERT INTO hne_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","अब्राम ला कनान देस म रहत दस साल होय के बाद ओकर घरवाली सारै ह अपन मिसर के दासी हाजिरा ला अपन घरवाला अब्राम के घरवाली होय बर दे दीस। ");
INSERT INTO hne_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ओह हाजिरा संग सुतिस, तब हाजिरा ह आसरा म हो गीस। जब ओह जानिस कि ओह आसरा म हवय, त ओह अपन मालकिन ला तुछ समझे लगिस। ");
INSERT INTO hne_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","तब सारै ह अब्राम ला कहिस, “मोर संग जऊन अनियाय होवथे, ओकर जिम्मेदार तें अस। में तो अपन दासी ला तोर हांथ म दे देंव, पर जब ओह ये जानिस कि ओह आसरा म हवय, त ओह मोला तुछ समझत हे। एकर बर यहोवा तोर अऊ मोर नियाय करय।” ");
INSERT INTO hne_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्राम ह सारै ला कहिस, “देख, तोर दासी ह तोर हांथ म हवय; जइसने तोला बने लगय, वइसने ओकर संग कर।” तब सारै ह हाजिरा ला दुख देय लगिस। एकरसेति ओह ओकर करा ले भाग गीस। ");
INSERT INTO hne_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","यहोवा के स्वरगदूत ह ओला सुनसान जगह म सूर के रसता म पानी के एक सोता करा पाईस। ");
INSERT INTO hne_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","अऊ ओह कहिस, “हे सारै के दासी, हाजिरा, तें कहां ले आवत हस, अऊ कहां जावत हस?” ओह जबाब दीस, “मेंह अपन मालकिन सारै करा ले भागके आय हंव।” ");
INSERT INTO hne_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","तब यहोवा के स्वरगदूत ह ओला कहिस, “अपन मालकिन करा लहुंट जा अऊ ओकर बस म रह।” ");
INSERT INTO hne_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","यहोवा के स्वरगदूत ह ओला ये घलो कहिस, “मेंह तोर संतान ला अब्बड़ बढ़ाहूं, इहां तक कि ओमन के गनती करई मुसकिल हो जाही।” ");
INSERT INTO hne_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","यहोवा के स्वरगदूत ह ओला ये घलो कहिस: “देख, तें आसरा म हस अऊ तें एक बेटा ला जनम देबे। तें ओकर नांव इसमायल रखबे, काबरकि यहोवा ह तोर दुख के बात ला सुन ले हवय। ");
INSERT INTO hne_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ओह एक जंगली गदहा के सुभाव के मनखे होही; ओकर हांथ जम्मो झन के बिरूध उठही अऊ जम्मो झन के हांथ ओकर बिरूध उठही, अऊ ओह अपन जम्मो भाई-बंधुमन संग बईरता के संग जिनगी जीही।” ");
INSERT INTO hne_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","तब हाजिरा ह यहोवा के ये नांव रखिस, जऊन ह ओकर ले बात करे रिहिस: “तेंह ओ परमेसर अस, जऊन ह मोला देखथस,” काबरकि ओह कहिस, “मेंह अब ओला देख डारे हंव जऊन ह मोला देखथे।” ");
INSERT INTO hne_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","एकरे कारन ओ कुआं के नांव बेर-लहाय-रोई परिस, येह अभी घलो कादेस अऊ बेरेद के बीच म हवय। ");
INSERT INTO hne_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हाजिरा ला अब्राम के दुवारा एक बेटा होईस, अऊ अब्राम ओ बेटा के नांव इसमायल रखिस, जेला हाजिरा जनम दीस। ");
INSERT INTO hne_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","जब हाजिरा ह अब्राम के दुवारा इसमायल ला जनम दीस, ओ समय अब्राम छियासी बछर के रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","जब अब्राम ह निनानबे बछर के होईस, त यहोवा ह ओला दरसन देके कहिस, “में सर्वसक्तिमान परमेसर अंव; बिसवासयोग्यता के साथ मोर संग चल अऊ निरदोस बने रह। ");
INSERT INTO hne_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","त में तोर अऊ मोर बीच म अपन करार करहूं अऊ तोर बंस ला अब्बड़ बढ़ाहूं।” ");
INSERT INTO hne_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","तब अब्राम ह मुहूं के बल गिरके ओला दंडवत करिस, अऊ परमेसर ह ओला कहिस, ");
INSERT INTO hne_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“देख, तोर संग मोर करार ये अय: तेंह बहुंते जाति के मनखेमन के ददा होबे। ");
INSERT INTO hne_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","एकर बर अब ले तोर नांव अब्राम नइं रहय, पर तोर नांव अब्राहम होही; काबरकि मेंह तोला बहुंते जाति के मनखेमन के ददा ठहिराय हंव। ");
INSERT INTO hne_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","मेंह तोला बहुंत फलवंत करहूं; मेंह तोर ले जाति-जाति के मनखे बनाहूं अऊ तोर बंस म राजामन जनमहीं। ");
INSERT INTO hne_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","में तोर संग अऊ तोर पाछू तोर अवइया पीढ़ी-पीढ़ी के संतान संग सदाकाल के ये करार करहूं कि में तोर अऊ तोर पाछू तोर संतानमन के घलो परमेसर होहूं। ");
INSERT INTO hne_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","मेंह तोर अऊ तोर पाछू तोर संतानमन के अधिकार म, ये जम्मो कनान देस, जिहां तेंह अभी परदेसी होके रहिथस, सदाकाल बर दे दूहूं; अऊ मेंह ओमन के परमेसर होहूं।” ");
INSERT INTO hne_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","फेर परमेसर ह अब्राहम ला कहिस, “ये जरूरी ए कि तहूं घलो मोर करार के पालन कर, तें अऊ तोर पाछू अवइया तोर पीढ़ी-पीढ़ी के संतानमन घलो ये करार के पालन करंय। ");
INSERT INTO hne_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","तोर संग बांधे गय करार, जेला तोला अऊ तोर पाछू तोर संतानमन ला माने बर पड़ही, ओ ये अय: तुम्हर बीच म हर पुरूस के खतना करे जावय। ");
INSERT INTO hne_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","तुमन अपन-अपन खतना करवा लव, अऊ येह मोर अऊ तुम्हर बीच म करे गय करार के चिनहां होही। ");
INSERT INTO hne_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","पीढ़ी-पीढ़ी तक सिरिप तोर बंस के मनखे ही नइं, पर जेमन तोर घर म जनमे हें या जेमन ला कोनो परदेसी करा ले बिसाय गे हवय—जेमन तोर संतान नो हंय, अइसन जम्मो पुरूस के ओमन के जनमे के आठवां दिन म खतना करे जावय। ");
INSERT INTO hne_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","जऊन मन तोर घर म जनमे हवंय या फेर रूपिया देके बिसाय गे हवंय, ओमन के जरूर खतना करे जावय। मोर करार, जेकर चिनहां तोर देहें म होही, येह एक सदाकाल के करार होही। ");
INSERT INTO hne_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","कोनो बिगर खतना के पुरूस, जेकर चमड़ी के खतना नइं करे गे हवय, ओह अपन मनखेमन के बीच म ले अलग करे जाही, काबरकि ओह मोर करार ला टोरे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","फेर परमेसर ह अब्राहम ला कहिस, “तोर जऊन घरवाली सारै हवय, तेला अब तें सारै झन कहिबे; ओकर नांव सारा होही। ");
INSERT INTO hne_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","में ओला आसीस दूहूं, अऊ तोला ओकर दुवारा एक बेटा दूहूं; अऊ मेंह ओला अइसन आसीस दूहूं कि ओह जाति-जाति के मनखेमन के मूल महतारी होही, अऊ ओकर ले मनखेमन के राजामन आहीं।” ");
INSERT INTO hne_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","तब अब्राहम ह मुहूं के बल भुइयां म गिरिस; ओह हंसिस अऊ अपन मन म कहिस, “का सौ बछर के मनखे के घलो संतान पईदा होही? का सारा, जऊन ह नब्बे बछर के अय, एक लइका ला जनमही?” ");
INSERT INTO hne_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","अऊ अब्राहम ह परमेसर ला कहिस, “सिरिप इसमायल ह तोर आसीस म बने रहय, येह मोर बर बहुंत अय।” ");
INSERT INTO hne_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","तब परमेसर ह कहिस, “सही म, तोर घरवाली सारा ले तोर दुवारा एक बेटा होही, अऊ तें ओकर नांव इसहाक रखबे। में ओकर संग अइसन करार करहूं, जऊन ह ओकर बाद ओकर बंस बर घलो सदाकाल बर होही। ");
INSERT INTO hne_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","इसमायल के बिसय म घलो, में तोर बिनती ला सुने हंव: में ओला घलो आसीस दूहूं; में ओला फलवंत करहूं अऊ ओकर संतान ला बहुंत बढ़ाहूं। ओकर ले बारह सासन करइया पईदा होहीं अऊ में ओकर ले एक बड़े जाति बनाहूं। ");
INSERT INTO hne_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","पर में अपन करार इसहाक संग करहूं, जऊन ह अगले साल इही समय म, सारा ले तोर दुवारा जनमही।” ");
INSERT INTO hne_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","जब परमेसर ह अब्राहम के संग गोठिया लीस, तब ओह ओकर करा ले चल दीस। ");
INSERT INTO hne_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","तब अब्राहम ओहीच दिन अपन बेटा इसमायल अऊ ओकर घर म जनमे जम्मो पुरूस या ओकर घर म रहइया बिसाय गे जम्मो पुरूस ला लीस अऊ परमेसर के कहे मुताबिक ओमन के खतना करिस। ");
INSERT INTO hne_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","जब अब्राहम के खतना होईस, तब ओह निनानबे बछर के रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","अऊ जब ओकर बेटा इसमायल के खतना होईस, तब ओह तेरह बछर के रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहम अऊ ओकर बेटा इसमायल दूनों के खतना एके दिन म होईस। ");
INSERT INTO hne_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","अऊ ओकर घर म जतेक पुरूस रिहिन, जेमन ओकर घर म जनमे रिहिन या जेमन परदेसीमन के हांथ ले बिसाय गे रिहिन, ओ जम्मो पुरूस के खतना ओकर संग होईस। ");
INSERT INTO hne_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","अब्राहम ह ममरे के बड़े रूखमन के लकठा म, घाम के बेरा अपन तम्बू के दुवारी म बईठे रिहिस, तब यहोवा ह ओकर करा परगट होईस। ");
INSERT INTO hne_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ओह आंखी उठाके देखिस, त तीन झन पुरूस लकठा म ठाढ़े रहंय। जब ओह ओमन ला देखिस, त ओह ओमन ले भेंट करे बर तम्बू के दुवारी ले दऊड़िस अऊ भुइयां म झुकके ओमन ला दंडवत करिस। ");
INSERT INTO hne_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ओह कहिस, “हे परभू, यदि मोर ऊपर तुम्हर दया-दिरिस्टी हवय, त अपन दास करा ले झन जावव। ");
INSERT INTO hne_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","मेंह थोरकन पानी लेके आवत हंव, अऊ तब तुमन अपन गोड़ ला धोके ये रूख खाल्हे म सुसतावव। ");
INSERT INTO hne_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","मेंह तुम्हर बर कुछू खाय बर लानत हंव ताकि ओला खाके तुमन तरो-ताजा होवव अऊ तब आघू अपन रसता म जावव—काबरकि तुमन अपन दास करा आय हवव।” त ओमन कहिन, “येह बने बात ए; तेंह जइसने कहय, वइसने कर।” ");
INSERT INTO hne_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","तब अब्राहम ह तुरते तम्बू म सारा करा गीस अऊ कहिस, “जल्दी कर, तीन सेआ बढ़िया पीसान ले अऊ ओला गुंथके कुछू रोटी बना।” ");
INSERT INTO hne_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","तब अब्राहम ह दऊड़के अपन गरूवा-बईला के झुंड म गीस अऊ एक बढ़िया, नरम बछवा ला छांटके अपन दास ला दीस, जऊन ह जाके जल्दी से ओला पकाईस। ");
INSERT INTO hne_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","अब्राहम ह तब कुछू दही अऊ दूध अऊ ओ रांधे गय बछवा के मांस ला ओमन के आघू म परोस दीस। जब ओमन खावत रिहिन, त ओह ओमन के लकठा म रूख खाल्हे म ठाढ़े रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ओमन ओला पुछिन, “तोर घरवाली सारा कहां हवय?” ओह कहिस, “ओह तो तम्बू भीतर हवय।” ");
INSERT INTO hne_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","त ओमा के एक झन ह कहिस, “में अगले साल इही समय म तोर करा फेर आहूं, अऊ तोर घरवाली सारा के एक बेटा होही।” सारा तम्बू के दुवारी म अब्राहम के पाछू कोति रहिके ये बात ला सुनत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहम अऊ सारा दूनों बहुंत डोकरा-डोकरी हो गे रिहिन, अऊ सारा के माहवारी भी बंद हो गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","एकरसेति सारा ह मन म हंसके कहे लगिस, “में तो डोकरी हो गे हंव अऊ मोर घरवाला घलो डोकरा हो गे हे, त का मोला ये सुख मिलही?” ");
INSERT INTO hne_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","तब यहोवा ह अब्राहम ला कहिस, “सारा अइसन कहिके काबर हंसिस, ‘में अब अतकी डोकरी हो गे हंव अऊ का सही म मोर एक बेटा होही?’ ");
INSERT INTO hne_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","का यहोवा बर कोनो काम कठिन ए? मेंह अगले साल ठहिराय समय म तोर करा फेर आहूं, अऊ सारा के एक बेटा होही।” ");
INSERT INTO hne_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","तब सारा डर के मारे ये कहिके अपन बात ले मुकर गीस, “में नइं हंसे रहंय।” पर ओह कहिस, “नइं, तें हंसे तो रहय।” ");
INSERT INTO hne_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","जब ओ मनखेमन उहां ले जाय बर उठिन, त ओमन खाल्हे सदोम नगर कोति देखिन, अऊ अब्राहम ह ओमन ला बिदा करे बर ओमन संग गीस। ");
INSERT INTO hne_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","तब यहोवा ह कहिस, “अभी में जो करइया हंव, का ओला मेंह अब्राहम ले छुपाके रखंव? ");
INSERT INTO hne_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहम ले सही म एक बड़े अऊ सक्तिसाली जाति पईदा होही, अऊ धरती के जम्मो जाति के मनखेमन ओकर जरिये आसीस पाहीं। ");
INSERT INTO hne_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","काबरकि मेंह ओला चुने हंव कि ओह अपन बाद अपन बेटा अऊ परिवार के मनखेमन ला हुकूम दीही कि ओमन सही अऊ नियाय के काम करे के दुवारा यहोवा के रसता म अटल बने रहंय, ताकि यहोवा ह जऊन परतिगियां अब्राहम ले करे हवय, ओला पूरा करय।” ");
INSERT INTO hne_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","फेर यहोवा ह कहिस, “सदोम अऊ अमोरा नगरमन के बिरूध नरियाई ह बहुंत बढ़ गे हवय अऊ ओमन के पाप ह बहुंत दुखदाई हो गे हवय, ");
INSERT INTO hne_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","एकरसेति में उतरके देखहूं कि ओमन के बिरूध जऊन नरियाई मोर कान म हबरे हे, ओकर मुताबिक ओमन के काम वइसने खराप हवय कि नइं। यदि नइं, त में ओला जान डारहूं।” ");
INSERT INTO hne_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","तब ओमा के दू झन उहां ले लहुंटके सदोम कोति जाय लगिन; पर अब्राहम ह यहोवा के आघू म ठाढ़े रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","तब अब्राहम ओकर करा जाके कहिस: “का तें दुस्टमन के संग म धरमीमन ला घलो नास करबे? ");
INSERT INTO hne_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","सायद ओ नगर म पचास धरमी मनखे होवंय, त का तें सही म ओ जगह ला नास कर देबे, अऊ ओ पचास धरमी जन के कारन ओला नइं छोंड़बे? ");
INSERT INTO hne_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","अइसन काम करई तोर ले दूरिहा रहय—कि दुस्ट के संग धरमी ला घलो मार डार अऊ धरमी अऊ दुस्ट दूनों के एके दसा होवय। अइसन काम तोर ले झन होवय! का जम्मो धरती के नियायी ह सही नियाय नइं करही?” ");
INSERT INTO hne_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","यहोवा ह कहिस, “यदि मोला सदोम सहर म पचास धरमी मिलहीं, त ओमन के कारन ओ जम्मो जगह ला छोंड़ दूहूं।” ");
INSERT INTO hne_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","तब अब्राहम ह फेर कहिस, “हे परभू, देख, में तो माटी अऊ राख सहीं अंव, तभो ले में हिम्मत करके तोर से गोठियावत हंव। ");
INSERT INTO hne_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","यदि ओ पचास धरमी म पांच कम रहंय, त का तें पांच धरमी के कम होय के कारन ओ पूरा सहर ला नास कर देबे?” ओह कहिस, “यदि उहां मोला पैंतालीस भी मिलहीं, त में ओला नास नइं करंव।” ");
INSERT INTO hne_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","एक बार फेर अब्राहम ह परमेसर ला कहिस, “यदि उहां सिरिप चालीस धरमी मिलंय त?” ओह कहिस, “में चालीस के कारन भी अइसने नइं करंव।” ");
INSERT INTO hne_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","तब अब्राहम ह कहिस, “हे परभू, नराज झन हो, पर मोला कुछू अऊ कहन दे। यदि उहां सिरिप तीस धरमी मिलंय त?” ओह ये जबाब दीस, “यदि मोला उहां तीस भी मिलंय, त में अइसने नइं करंव।” ");
INSERT INTO hne_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","फेर अब्राहम ह कहिस, “हे परभू, देख, में हिम्मत करके तोर ले गोठियावत हंव; यदि उहां सिरिप बीस धरमी मिलंय त?” ओह कहिस, “त फेर में बीस के कारन ओकर नास नइं करंव।” ");
INSERT INTO hne_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","तब अब्राहम ह कहिस, “हे परभू नराज झन हो, पर मोला सिरिप एक बार अऊ कहन दे। यदि उहां दस झन धरमी मिलंय त?” ओह जबाब दीस, “त फेर दस झन के कारन ओकर नास नइं करंव।” ");
INSERT INTO hne_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","जब यहोवा ह अब्राहम ले गोठिया लीस, तब ओह उहां ले चले गीस, अऊ अब्राहम अपन घर लहुंट गीस। ");
INSERT INTO hne_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","सांझकुन दू झन स्वरगदूतमन सदोम करा आईन, अऊ लूत ह सदोम के कपाट करा बईठे रिहिस। जब ओह ओमन ला देखिस, त ओह ओमन ले भेंट करे बर उठिस अऊ मुहूं के भार भुइयां म झुकके दंडवत करिस अऊ कहिस, ");
INSERT INTO hne_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“हे मोर परभूमन, अपन दास के घर म आवव, अऊ अपन गोड़ धोके रात भर अराम करव अऊ तब बड़े बिहनियां उठके अपन डहार म चले जावव।” ओमन कहिन, “नइं, हमन चऊक म ही रथिया बिताबो।” ");
INSERT INTO hne_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","पर ओह बहुंत बिनती करके ओमन ला मनाईस, एकरसेति ओमन ओकर संग ओकर घर म आईन। ओह ओमन बर जेवन तियार करिस, अऊ बिगर खमीर के रोटी बनाके ओमन ला खवाईस। ");
INSERT INTO hne_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ओमन के सुते के पहिली सदोम सहर के जम्मो पुरूसमन आके—जवान ले लेके सियान तक लूत के घर ला घेर लीन; ");
INSERT INTO hne_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","अऊ ओमन लूत ला चिचियाके कहिन, “जऊन मनखेमन आज रथिया तोर करा आय हें, ओमन कहां हवंय? ओमन ला हमर करा बाहिर ले आ कि हमन ओमन संग भोग करन।” ");
INSERT INTO hne_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","तब लूत ह ओमन ले मिले बर घर ले बाहिर निकलिस अऊ कपाट ला बंद करके ");
INSERT INTO hne_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ओमन ला कहिस, “हे मोर भाईमन, अइसने गंदा काम झन करव। ");
INSERT INTO hne_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","देखव, मोर दू झन बेटीमन हें, जेमन कभू कोनो पुरूस के संग नइं सुते हें। मेंह ओमन ला बाहिर तुम्हर करा ले आवत हंव, अऊ तुमन ला जइसने बने लगय, वइसने ओमन के संग करव। पर ये मनखेमन संग कुछू झन करव; काबरकि येमन मोर छानी के तरी म आय हवंय।” ");
INSERT INTO hne_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ओमन कहिन, “हमर रसता ले हट जा। ये मनखे ह एक परदेसी के रूप म इहां आय रिहिस, पर अब नियायी बनत हे! हमन तोर संग ओमन ले घलो जादा खराप बरताव करबो।” अऊ ओमन लूत ऊपर दबाव डारे लगिन अऊ कपाट ला टोरे बर आघू बढ़िन। ");
INSERT INTO hne_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","पर ओ पहुनामन हांथ लमाके लूत ला अपन करा घर के भीतर खींच लीन अऊ कपाट ला बंद कर दीन। ");
INSERT INTO hne_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","तब ओमन का छोटे का बड़े, जम्मो मनखे ला, जेमन घर के दुवारी म रिहिन, अंधरा कर दीन, एकरसेति ओमन कपाट ला खोजे नइं सकिन। ");
INSERT INTO hne_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","तब ओ दूनों पहुनामन लूत ले पुछिन, “इहां तोर अऊ कोनो हवंय—दामाद, बेटा-बेटीमन, या अऊ कोनो ये सहर म तोर हवंय? त ओ जम्मो झन ला लेके इहां ले निकल जा, ");
INSERT INTO hne_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","काबरकि हमन ये जगह ला नास करइया हन। यहोवा करा ये जगह के मनखेमन के बिरूध नरियाई अतेक जादा हो गय हे कि ओह हमन ला एकर सतियानास करे बर पठोय हे।” ");
INSERT INTO hne_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","एकरसेति, लूत ह निकलके अपन दामादमन ला, जेमन संग ओकर बेटीमन के मंगनी हो गे रहय, कहिस, “जल्दी करव अऊ ये जगह ले निकलव; काबरकि यहोवा ह ये सहर ला नास करइया हे!” पर ओकर दामादमन सोचिन कि ओह ठट्ठा करत हे। ");
INSERT INTO hne_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","जब बिहान पहात रिहिस, त स्वरगदूतमन लूत ला कहिन, “जल्दी कर! अपन घरवाली अऊ अपन दूनों बेटी ला, जेमन इहां हवंय, अपन संग ले जा, नइं तो तुमन घलो ये सहर के दंड म नास हो जाहू।” ");
INSERT INTO hne_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","पर ओह झिझकत रिहिस, एकरसेति ओ पहुनामन ओकर अऊ ओकर घरवाली अऊ ओकर दूनों बेटीमन के हांथ ला धरिन अऊ सही-सलामत ओमन ला सहर के बाहिर ले गीन, काबरकि यहोवा के दया ओमन के ऊपर रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","जब ओमन ला बाहिर निकाल लीन, त ओमन ले एक झन ह कहिस, “अपन परान लेके भागव! पाछू पलटके झन देखहू, अऊ मैदान म कहूं मेर झन रूकहू! ओ पहाड़ ऊपर भाग जावव, नइं तो तुमन घलो नास हो जाहू!” ");
INSERT INTO hne_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","पर लूत ह ओमन ला कहिस, “हे मोर परभू, अइसन झन करव। ");
INSERT INTO hne_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","देख, तोर दास ऊपर तोर दया-दिरिस्टी होय हवय, अऊ तेंह मोर जिनगी ला बचाके मोर ऊपर अब्बड़ दया करे हस। पर में ओ पहाड़ ऊपर नइं जा सकंव; ये बिपत्ति ह मोर ऊपर आ जाही, अऊ में मर जाहूं। ");
INSERT INTO hne_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","देख, ओ नगर ह बहुंत लकठा म हवय अऊ मेंह उहां भाग सकत हंव, अऊ ओह छोटे घलो हवय। मोला उहां भाग जावन दे—का ओह बहुंत छोटे नगर नो हय? तब मोर परान ह बच जाही।” ");
INSERT INTO hne_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ओह लूत ला कहिस, “ठीक हे, मेंह तोर ये बिनती ला घलो मानत हंव; जऊन नगर के बारे म तेंह कहत हस, ओला में नास नइं करंव। ");
INSERT INTO hne_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","पर जल्दी करके उहां भाग जा, काबरकि जब तक तेंह उहां नइं हबरबे, तब तक में कुछू नइं कर सकंव।” (एकरे बर ओ नगर ला सोअर कहे गीस।) ");
INSERT INTO hne_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","जब लूत ह सोअर नगर म हबरिस, त बेर ह धरती ऊपर उग गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","तब यहोवा ह अपन कोति ले सदोम अऊ अमोरा म अकास ले बरत गंधक बरसाईस। ");
INSERT INTO hne_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ये किसम ले, ओह ओ सहरमन ला अऊ ओ जम्मो मैदान ला अऊ सहर म रहइया जम्मो मनखेमन ला—अऊ भुइयां के घांस-पूस अऊ रूख-रई जम्मो ला नास कर दीस। ");
INSERT INTO hne_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","पर लूत के घरवाली ह पाछू कोति मुड़के देखिस, अऊ ओह नून के खंभा बन गीस। ");
INSERT INTO hne_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","दूसर दिन बड़े बिहनियां अब्राहम उठके ओ ठऊर म गीस, जिहां ओह यहोवा के आघू म ठाढ़े रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ओह खाल्हे सदोम अऊ अमोरा अऊ ओ मैदान के जम्मो भुइयां कोति देखिस, त ओह का देखिस कि ओ जम्मो जगह ले धधकत भट्ठी ले निकलत धुआं सहीं घना धुआं उठत रहय। ");
INSERT INTO hne_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","अऊ जब परमेसर ह ओ मैदान के सहरमन ला नास करिस, त ओह अब्राहम ला सुरता करिस, अऊ ओह उहां रहइया लूत ला ओ संकट ले बचा लीस, जऊन ह ओ सहरमन ला उलट-पलट दीस। ");
INSERT INTO hne_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लूत अऊ ओकर दूनों बेटीमन सोअर ला छोंड़ दीन अऊ पहाड़ ऊपर रहे लगिन, काबरकि लूत ह सोअर म रहे बर डरत रिहिस। ओह अऊ ओकर दूनों बेटी गुफा म रहत रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","एक दिन बड़की बेटी ह छोटकी ला कहिस, “हमर ददा त डोकरा हो गे हे, अऊ इहां आसपास म अइसन कोनो पुरूस नइं ए, जऊन ह संसार के रीति के मुताबिक हमन ला लइका दे सकय। ");
INSERT INTO hne_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","एकरसेति आ, हमन अपन ददा ला मंद पीयाके ओकर संग सुतन अऊ अपन ददा के दुवारा अपन परिवार के बंस ला बंचावन।” ");
INSERT INTO hne_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","त ओमन ओहीच दिन रथिया अपन ददा ला मंद पीयाईन, अऊ तब बड़की बेटी जाके अपन ददा संग सुतिस, पर ओकर ददा ह नइं जानिस कि ओह कब ओकर संग लेटिस अऊ कब ओह उठ गीस। ");
INSERT INTO hne_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ओकर दूसर दिन बड़की ह छोटकी बहिनी ला कहिस, “देख, कल रथिया मेंह अपन ददा संग सुतें। आ, आज रथिया हमन ओला फेर मंद पीयाबो, अऊ तब तें जाके ओकर संग सुतबे ताकि हमन अपन ददा के दुवारा अपन परिवार के बंस ला बचा सकन।” ");
INSERT INTO hne_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","एकरसेति ओमन ओ दिन घलो रथिया अपन ददा ला मंद पीयाईन अऊ छोटकी बेटी जाके अपन ददा संग सुतिस, अऊ फेर ओकर ददा ह नइं पता पाईस कि ओह कब ओकर संग लेटिस अऊ कब ओह उठ गीस। ");
INSERT INTO hne_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ये किसम ले लूत के दूनों बेटी अपन ददा कोति ले आसरा म हो गीन। ");
INSERT INTO hne_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","बड़की बेटी के एक बेटा होईस, अऊ ओह ओकर नांव मोआब रखिस; ओह आज तक के मोआबीमन के जनमदाता होईस। ");
INSERT INTO hne_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","अऊ छोटकी के घलो एक बेटा होईस, अऊ ओह ओकर नांव बेन-अम्मी रखिस; ओह आज तक के अमोनीमन के जनमदाता होईस। ");
INSERT INTO hne_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","फेर अब्राहम उहां ले निकलके नेगेव के छेत्र म आईस अऊ कादेस अऊ सूर के बीच म रहे लगिस। कुछू समय तक ओह गरार नगर म ठहिरिस, ");
INSERT INTO hne_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","अऊ उहां अब्राहम ह अपन घरवाली सारा के बारे म कहिस, “ओह मोर बहिनी अय।” एकरसेति गरार के राजा अबीमेलेक ह दूत पठोके सारा ला अपन करा बला लीस। ");
INSERT INTO hne_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","पर रथिया परमेसर ह सपना म अबीमेलेक करा आके कहिस, “सुन, तेंह मर जाबे, काबरकि जऊन माईलोगन ला तेंह रख ले हस; ओह एक बिहाता माईलोगन अय।” ");
INSERT INTO hne_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","पर अबीमेलेक ओकर करा नइं गे रिहिस, एकर बर ओह कहिस, “हे परभू, का तें एक निरदोस जाति ला मार डारबे? ");
INSERT INTO hne_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","का ओह खुद मोला नइं कहिस कि ओह मोर बहिनी अय? अऊ ओ नारी ह घलो खुद नइं कहिस कि ओह मोर भाई अय? में तो अपन सुध बिबेक अऊ निरदोस हांथ ले ये काम ला करे हंव।” ");
INSERT INTO hne_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","तब परमेसर ह ओला सपना म कहिस, “हव, में भी जानत हंव कि सुध बिबेक से तेंह ये काम ला करे हस, अऊ एकरसेति मेंह तोला मोर बिरूध म पाप करे बर रोकके रखे हंव। एकरे कारन मेंह तोला ओला छुए नइं देंव। ");
INSERT INTO hne_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","अब ओ मनखे के घरवाली ला लहुंटा दे, काबरकि ओह एक अगमजानी अय, अऊ ओह तोर बर पराथना करही अऊ तें जीयत रहिबे। पर यदि तें ओला नइं लहुंटाबे, त जान ले कि तें अऊ तोर जतेक मनखे हें, ओ सब के सब मर जाहीं।” ");
INSERT INTO hne_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","दूसर दिन बड़े बिहनियां अबीमेलेक अपन जम्मो करमचारीमन ला बलाईस, अऊ जब ओह ओमन ला ओ जम्मो बात बताईस, त ओमन बहुंत डरा गीन। ");
INSERT INTO hne_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","तब अबीमेलेक ह अब्राहम ला बलाके कहिस, तेंह हमर संग ये का करे हस? मेंह तोर का बिगाड़ेंव कि तें मोर अऊ मोर राज ऊपर अइसने बड़े दोस डाल दे हस। तेंह मोर संग ओ काम करे हस, जऊन ह उचित नो हय। ");
INSERT INTO hne_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","फेर अबीमेलेक ह अब्राहम ले पुछिस, “तेंह का समझके अइसन काम करय?” ");
INSERT INTO hne_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहम ह कहिस, “मेंह ये सोचेंव कि ये ठऊर म परमेसर के डर-भय नइं होही, अऊ मनखेमन मोर घरवाली के कारन मोला मार डारहीं। ");
INSERT INTO hne_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","एकर छोंड़, सही म ओह मोर बहिनी अय, मोर ददा के बेटी, हालाकि ओह मोर दाई के बेटी नो हय; अऊ फेर ओह मोर घरवाली बन गीस ");
INSERT INTO hne_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","अऊ जब परमेसर ह मोला मोर ददा के घर ला छोंड़के निकले के हुकूम दीस, त में ओला कहेंव, ‘तें ये किसम ले अपन मया मोर बर देखा सकथस: जिहां-जिहां हमन जाबो, उहां-उहां तें मोर बारे म कहिबे, “ये मोर भाई अय।” ’ ” ");
INSERT INTO hne_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","तब अबीमेलेक ह भेड़-बकरी, गरूवा-बईला ला, अऊ दास-दासीमन ला लेके अब्राहम ला दीस अऊ ओकर घरवाली सारा ला घलो ओला लहुंटा दीस। ");
INSERT INTO hne_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","अऊ अबीमेलेक ह कहिस, “देख, मोर देस तोर आघू म हवय; जिहां तोला बने लगय, उहां रह।” ");
INSERT INTO hne_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","सारा ला ओह कहिस, “देख, में तोर भाई ला एक हजार सेकेल चांदी देवत हंव। तोर बिरूध जऊन अपराध मेंह करे हंव, तोर संग के मनखेमन के आघू म, येह ओकर भरपई ए; तोर संग पूरा नियाय करे जावथे।” ");
INSERT INTO hne_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","तब अब्राहम ह परमेसर ले पराथना करिस, अऊ परमेसर ह अबीमेलेक, ओकर घरवाली अऊ ओकर दासीमन ला चंगा करिस कि ओमन फेर लइका जनमे लगंय, ");
INSERT INTO hne_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","काबरकि यहोवा ह अब्राहम के घरवाली सारा के कारन अबीमेलेक के घर के जम्मो माईलोगनमन के कोख ला बंद कर दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","यहोवा ह सारा के ऊपर अनुग्रह करिस जइसने कि ओह कहे रिहिस, अऊ ओह सारा बर वइसने करिस जइसने कि ओह परतिगियां करे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","सारा ह अब्राहम ले गरभ म होईस अऊ ओकर बुढ़ापा म, ओही ठहिराय समय म परमेसर के परतिगियां के मुताबिक ओह एक बेटा जनमिस। ");
INSERT INTO hne_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहम अपन ओ बेटा के नांव इसहाक रखिस, जेला सारा ह जनम दीस। ");
INSERT INTO hne_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","जब ओकर बेटा इसहाक ह आठ दिन के होईस, त अब्राहम ह परमेसर के हुकूम के मुताबिक ओकर खतना करिस। ");
INSERT INTO hne_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","अब्राहम ह एक सौ बछर के रिहिस, जब ओकर बेटा इसहाक के जनम होईस। ");
INSERT INTO hne_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","सारा ह कहिस, “परमेसर ह मोला खुसी दे हवय, अऊ जऊन कोनो भी एकर बारे म सुनही, ओह खुस होके हंसही।” ");
INSERT INTO hne_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","फेर ओह ये घलो कहिस, “का कोनो कभू अब्राहम ले ये कहे सकत रिहिन कि सारा ह लइकामन ला दूध पीयाही? पर देखव, मेंह ओकर बुढ़त काल म ओकर एक बेटा ला जनम दे हवंव।” ");
INSERT INTO hne_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ओ लइका ह बढ़त गीस अऊ ओकर दूध छोंड़ाय गीस, अऊ इसहाक के दूध छोंड़ाय के दिन अब्राहम ह एक बड़े भोज करिस। ");
INSERT INTO hne_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","पर बाद म सारा ह देखिस कि मिसरी हाजिरा के बेटा, जऊन ह अब्राहम दुवारा जनमे रिहिस, ओकर हंसी उड़ात रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","त ओह अब्राहम ला कहिस, “ये गुलाम माईलोगन अऊ ओकर बेटा ला निकाल दे, काबरकि ये माईलोगन के बेटा ह मोर बेटा इसहाक के संग कभू हिस्सा नइं पावय।” ");
INSERT INTO hne_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ये बात अब्राहम ला बहुंत खराप लगिस, काबरकि ये बात ओकर बेटा के बारे म रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","पर परमेसर ह अब्राहम ला कहिस, “ओ लइका अऊ अपन दासी के बारे म दुखी झन हो। जऊन बात सारा ह तोला कहत हे, ओला मान, काबरकि इसहाक के जरिये तोर बंस ह चलही। ");
INSERT INTO hne_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","मेंह दासी के बेटा ले घलो एक जाति बनाहूं, काबरकि ओह तोर संतान अय।” ");
INSERT INTO hne_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ओकर दूसर दिन बड़े बिहनियां अब्राहम ह उठके कुछू जेवन अऊ पानी ले भरे चमड़ा के थैली लीस अऊ हाजिरा ला दीस। ओह जेवन अऊ पानी के थैली ला हाजिरा के कंधा म रखिस अऊ ओला अऊ ओकर बेटा ला बिदा करिस। ओह अपन रसता म चल दीस अऊ बेरसेबा के सुन्ना जगह म भटकत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","जब चाम के थैली के पानी सिरा गीस, तब ओह अपन बेटा ला एक झाड़ी तरी म छोंड़ दीस। ");
INSERT INTO hne_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","अऊ तब अपन खुद तीर चलाय भर के दूरिहा म गीस अऊ ये सोचके बईठ गीस, “में अपन बेटा के मरना नइं देख सकंव।” अऊ ओह उहां बईठके रोवन लगिस। ");
INSERT INTO hne_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमेसर ह ओ छोकरा के रोये के अवाज ला सुनिस, अऊ परमेसर के स्वरगदूत ह स्वरग ले नरियाके हाजिरा ला कहिस, “हे हाजिरा, का बात ए? झन डर; जऊन करा तोर बेटा हवय, उहां ले ओकर रोये के अवाज ह परमेसर करा हबरे हवय। ");
INSERT INTO hne_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","उठ अऊ अपन बेटा ला अपन हांथ म उठा, काबरकि में ओकर दुवारा एक बड़े जाति बनाहूं।” ");
INSERT INTO hne_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","तब परमेसर ह ओकर आंखी ला उघार दीस अऊ ओला एक ठन पानी के कुआं दिखिस, तब ओह जाके थैली म पानी भरिस अऊ लइका ला पीयाईस। ");
INSERT INTO hne_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","परमेसर ह ओ लइका संग रिहिस, जब ओह बढ़े लगिस। ओह सुन्ना जगह म रहत एक धनुस चलइया बन गीस। ");
INSERT INTO hne_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","जब ओह पारान के सुन्ना जगह म रहत रिहिस, त ओकर दाई ह ओकर बर मिसर देस ले एक घरवाली लानिस। ");
INSERT INTO hne_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ओ समय म, अबीमेलेक अऊ ओकर सेनापति पीकोल अब्राहम ला कहिन, “जऊन कुछू तें करथस, ओमा परमेसर तोर संग रहिथे। ");
INSERT INTO hne_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","एकरसेति, अब मोर संग इहां परमेसर के आघू म किरिया खा कि तें न तो मोर संग, न मोर लइकामन संग अऊ न ही मोर अवइया संतान संग कोनो छल करबे। पर जइसन दया मेंह तोला देखाय हवंव, वइसन ही दया तें मोर अऊ ये देस ऊपर देखाबे, जिहां तेंह अभी एक परदेसी के रूप म रहत हस।” ");
INSERT INTO hne_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहम ह कहिस, “में किरिया खावत हंव।” ");
INSERT INTO hne_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","तब अब्राहम ह अबीमेलेक ले एक कुआं के बारे म सिकायत करिस, जेला अबीमेलेक के दासमन जबरन लेय ले रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","पर अबीमेलेक ह कहिस, “में नइं जानंव कि कोन ह ये काम ला करिस। तें मोला नइं बताय, अऊ आज मोला ये बात के पता चलत हे।” ");
INSERT INTO hne_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","तब अब्राहम ह भेड़-बकरी अऊ गरूवा-बईला लानिस अऊ अबीमेलेक ला दीस, अऊ ओ दूनों झन आपस म करार करिन। ");
INSERT INTO hne_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहम ह सात ठन मेढ़ा-पीला ला झुंड ले अलग रखिस, ");
INSERT INTO hne_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","त अबीमेलेक ह अब्राहम ले पुछिस, “ये सात ठन मेढ़ा-पीला, जेमन ला तें अलग रखे हस, तेकर का मतलब अय?” ");
INSERT INTO hne_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ओह कहिस, “ये सात ठन मेढ़ा-पीला ला ये बात के साखी जानके मोर हांथ ले लेय ले कि मेंह ये कुआं ला खने हंव।” ");
INSERT INTO hne_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ओ दूनों झन ओ ठऊर म आपस म किरिया खाईन, एकर कारन ओ जगह के नांव बेरसेबा परिस। ");
INSERT INTO hne_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","बेरसेबा म करार करे के बाद, अबीमेलेक अऊ ओकर सेना के सेनापति पीकोल पलिस्तीन देस ला लहुंट गीन। ");
INSERT INTO hne_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहम ह बेरसेबा म एक झाऊ के रूख लगाईस अऊ उहां यहोवा ले, जेह सनातन परमेसर अय, अराधना करिस। ");
INSERT INTO hne_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अब्राहम ह पलिस्तीन देस म बहुंत साल तक एक परदेसी के रूप म रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","कुछू समय बाद, परमेसर ह अब्राहम के परिछा लीस। ओह अब्राहम ला कहिस, “हे अब्राहम!” अब्राहम ह कहिस, “में इहां हंव।” ");
INSERT INTO hne_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","तब परमेसर ह कहिस, “अपन बेटा याने अपन एकलऊता बेटा इसहाक ला, जेला तें मया करथस, अपन संग लेके मोरियाह छेत्र म जा। उहां ओला एक पहाड़ ऊपर होम-बलिदान करके चघा, जेला में तोला देखाहूं।” ");
INSERT INTO hne_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","अब्राहम बड़े बिहनियां उठिस अऊ अपन गदहा ऊपर सामान लादिस। ओह अपन संग म दू झन सेवक अऊ अपन बेटा इसहाक ला लीस। जब ओह होम-बलिदान बर लकरी फोर लीस, त ओह ओ जगह बर रवाना होईस, जेकर बारे म परमेसर ह ओला बताय रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तीसर दिन अब्राहम ह आंखी उठाके ओ जगह ला दूरिहा ले देखिस, ");
INSERT INTO hne_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","अऊ ओह अपन सेवकमन ला कहिस, “गदहा के संग इहां ठाढ़े रहव; ये लड़का अऊ में उहां जावत हन। हमन अराधना करके तुम्हर करा लहुंट आबो।” ");
INSERT INTO hne_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","तब अब्राहम ह होम-बलिदान बर लकरी ला लीस अऊ अपन बेटा इसहाक के कंधा म रखिस, अऊ अपन खुद आगी अऊ छुरी ला धरिस। जब ओ दूनों एक संग जावत रिहिन, ");
INSERT INTO hne_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","त इसहाक ह अपन ददा अब्राहम ला कहिस, “हे ददा?” अब्राहम ह कहिस, “का बात ए, बेटा?” त इसहाक ह कहिस, “देख, आगी अऊ लकरी तो हमर करा हवय, पर होम-बलिदान बर मेढ़ा-पीला कहां हे?” ");
INSERT INTO hne_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहम ह कहिस, “होम-बलिदान बर मेढ़ा-पीला के उपाय परमेसर ह खुद करही, बेटा।” अऊ ओ दूनों संगे-संग आघू बढ़त गीन। ");
INSERT INTO hne_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","जब ओमन ओ जगह म हबरिन, जेकर बारे म परमेसर ह ओला बताय रिहिस, तब अब्राहम ह उहां एक बेदी बनाके ओकर ऊपर लकरी ला छांट-छांटके रखिस, अऊ अपन बेटा इसहाक ला बांधके बेदी के लकरी ऊपर लेटा दीस। ");
INSERT INTO hne_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","तब ओह अपन बेटा ला बलि करे बर अपन हांथ म छुरी ला धरिस। ");
INSERT INTO hne_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","पर यहोवा के स्वरगदूत ह स्वरग ले ओला नरियाके कहिस, “हे अब्राहम! हे अब्राहम!” ओह कहिस, “में इहां हंव।” ");
INSERT INTO hne_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","परमेसर के दूत ह कहिस, “ओ लड़का ऊपर हांथ झन बढ़ा; ओला कुछू झन कर। अब में जानत हंव कि तें परमेसर के भय मानथस, काबरकि तें मोर बर अपन बेटा याने अपन एकलऊता बेटा ला घलो नइं छोंड़े।” ");
INSERT INTO hne_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","तब अब्राहम ह आंखी उठाके देखिस, त ओकर पाछू म एक मेढ़ा रहय, जेकर सींग झाड़ी म फंसे रहय। अब्राहम ह जाके ओ मेढ़ा ला लानिस अऊ अपन बेटा के बदला म, ओला होम-बलिदान के रूप म चघाईस। ");
INSERT INTO hne_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","एकरसेति अब्राहम ओ जगह के नांव, “यहोवा ह दीही” रखिस। अऊ आज घलो ये कहे जाथे, “यहोवा के पहाड़ ऊपर परबंध होही।” ");
INSERT INTO hne_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","यहोवा के स्वरगदूत ह दूसर बेर स्वरग ले अब्राहम ला नरियाके कहिस, ");
INSERT INTO hne_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“यहोवा के ये बचन अय कि में अपनेच ही किरिया खावत हंव कि तें जो ये काम करे कि अपन बेटा याने अपन एकलऊता बेटा ला घलो नइं छोंड़य, ");
INSERT INTO hne_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","एकर कारन मेंह तोला जरूर आसीस दूहूं अऊ तोर संतानमन ला अकास के तारामन अऊ समुंदर तीर के बालू सहीं अनगिनत करहूं। तोर संतानमन अपन बईरीमन के सहरमन ला अपन अधिकार म ले लीहीं, ");
INSERT INTO hne_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","अऊ तोर संतान के जरिये धरती के जम्मो जाति के मनखेमन आसीस पाहीं, काबरकि तें मोर बात ला माने हस।” ");
INSERT INTO hne_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","तब अब्राहम अपन सेवकमन करा लहुंट आईस अऊ ओमन एक संग बेरसेबा गीन। अऊ अब्राहम ह बेरसेबा म रहत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","कुछू समय के बाद, अब्राहम ला ये संदेस मिलिस, “मिलका ह घलो दाई बने हे; ओह तोर भाई नाहोर कोति ले लइकामन ला जनमे हे। ");
INSERT INTO hne_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ओकर बड़खा बेटा ऊस अऊ ओकर भाई बूज, कमूएल (जऊन ह अराम के ददा होईस), ");
INSERT INTO hne_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","केसेद, हजो, पिलदास, यिदलाप अऊ बतूएल।” ");
INSERT INTO hne_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ये आठों बेटामन ला मिलका ह अब्राहम के भाई नाहोर कोति ले जनम दीस। ");
INSERT INTO hne_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नाहोर के रूमा नांव के एक रखैल रिहिस; जेकर ले तेबह, गहम, तहस अऊ माका पईदा होईन। ");
INSERT INTO hne_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा ह एक सौ सत्ताईस बछर के रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","तब ओह कनान देस के किरयत-अरबा (जेला हेबरोन कहे जाथे) म मर गीस। एकरसेति अब्राहम ह सारा बर सोक मनाय अऊ रोये बर गीस। ");
INSERT INTO hne_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","तब अब्राहम ह अपन घरवाली के लास के बाजू म ठाढ़ होके हित्तीमन ला कहिस, ");
INSERT INTO hne_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“मेंह तुम्हर बीच म एक परदेसी अऊ अजनबी अंव। मोला इहां मरघटी बर कुछू जमीन बिक्री म देवव ताकि में अपन मनखेमन के लास ला माटी दे सकंव।” ");
INSERT INTO hne_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","तब हित्तीमन अब्राहम ला कहिन, ");
INSERT INTO hne_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“हे महोदय, हमर बात ला सुन। तेंह हमर बीच म एक बड़े आदमी अस। हमर कबर म ले, जेह तोला बने लगय, ओमा अपन घरवाली के लास ला माटी दे। तोला अपन मनखे के लास ला माटी देय बर हमन म ले कोनो भी अपन कबर देय बर तोला मना नइं करय।” ");
INSERT INTO hne_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","तब अब्राहम उठके ठाढ़ होईस अऊ ओ देस के मनखे हित्तीमन के आघू म मुड़ नवाके कहिस, ");
INSERT INTO hne_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“यदि तुम्हर मन हवय कि इहां में अपन घरवाली ला माटी देवंव, त मोर बात ला सुनव अऊ मोर कोति ले सोहर के बेटा एपरोन ले बिनती करव ");
INSERT INTO hne_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","कि ओह अपन मकपेला के गुफा, जेह ओकर नांव म हे अऊ येह ओकर भुइयां के छोर म हवय, ओकर पूरा दाम लेके मोला बेच देवय कि ओह तुम्हर बीच म मोर अऊ मोर मनखेमन बर मरघटी होवय।” ");
INSERT INTO hne_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एपरोन हित्ती ह अपन मनखेमन के बीच म बईठे रिहिस अऊ ओ जम्मो हित्ती, जऊन मन ओकर नगर के कपाट करा आय रिहिन, ओमन के सुनत म ओह अब्राहम ला कहिस, ");
INSERT INTO hne_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“हे मोर परभू, अइसन नइं, मोर बात ला सुन; ओ भुइयां ला में तोला देवत हंव, अऊ ओमा जऊन गुफा हवय, ओला घलो तोला देवत हंव। मेंह येला अपन मनखेमन के आघू म तोला देवत हंव। तें अपन मनखे के लास ला उहां माटी दे।” ");
INSERT INTO hne_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","तब अब्राहम ह ओ देस के मनखेमन के आघू म फेर मुड़ नवाईस ");
INSERT INTO hne_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","अऊ ओमन के सुनत म एपरोन ला कहिस, “यदि तोर अइसन मन हे, त मोर बात ला सुन। ओ भुइयां के जऊन दाम हे, तेला मेंह दूहूं। ओला तें मोर करा ले लेय ले, ताकि में अपन मनखे के लास ला उहां माटी दे सकंव।” ");
INSERT INTO hne_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","एपरोन ह अब्राहम ला जबाब दीस, ");
INSERT INTO hne_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“हे मोर परभू, मोर बात ला सुन; ओ भुइयां के दाम तो चार सौ सेकेल हवय, पर तोर अऊ मोर बीच म येह कुछू नो हय। अपन मनखे के लास ला उहां माटी दे।” ");
INSERT INTO hne_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहम ह एपरोन के बात ला मानके ओला ओतकी चांदी तऊलके दे दीस, जतकी ओह हित्तीमन के सुनत म कहे रिहिस, याने कि चार सौ सेकेल, जऊन ह ओ समय बेपारीमन म चलत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ये किसम ले एपरोन के भुइयां, जऊन ह ममरे के लकठा म मकपेला म रिहिस—ओ भुइयां अऊ गुफा, अऊ ओ जम्मो रूख जऊन मन ओ भुइयां के सीमना म आवत रिहिन, ");
INSERT INTO hne_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ओ जम्मो संपत्ति, ओ सबो हित्ती, जऊन मन सहर के कपाट करा आय रिहिन, ओमन के आघू म अब्राहम के हक म पक्का हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ओकर बाद अब्राहम ह अपन घरवाली सारा के लास ला मकपेला के भुइयां के गुफा म माटी दीस, जऊन ह ममरे के, याने कि हेबरोन के लकठा म कनान देस म हवय। ");
INSERT INTO hne_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ये किसम ले ओ भुइयां ह गुफा समेत हित्तीमन कोति ले मरघटी बर अब्राहम के अधिकार म पक्का हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहम अब बहुंत डोकरा हो गे रिहिस, अऊ यहोवा ह ओला सब बात म आसीस दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहम ह अपन पुराना सेवक ला, जऊन ह ओकर जम्मो धन-दौलत ऊपर मुखिया रिहिस, कहिस, “अपन हांथ ला मोर जांघ के तरी म रख, ");
INSERT INTO hne_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","अऊ मोर ले यहोवा, जऊन ह अकास अऊ धरती के परमेसर ए, ओकर ये बात के किरिया खा कि तें कनानीमन के बेटीमन ले, जेमन के बीच म मेंह रहिथंव, कोनो ला मोर बेटा के घरवाली बनाके नइं लानबे, ");
INSERT INTO hne_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","पर तें मोर देस अऊ मोरेच रिस्तेदारमन करा जाके, मोर बेटा इसहाक बर एक घरवाली लानबे।” ");
INSERT INTO hne_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","तब दास ह ओकर ले पुछिस, “मान ले ओ नोनी के मन ह मोर संग ये देस म आय के नइं होही, त का मोला तोर बेटा ला ओ देस म ले जाय बर पड़ही, जिहां ले तें आय हस?” ");
INSERT INTO hne_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","अब्राहम ह ओला कहिस, “ये बात के धियान रहय कि मोर बेटा ला उहां कभू झन ले जाबे। ");
INSERT INTO hne_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","यहोवा, जऊन ह स्वरग के परमेसर ए, ओह मोला मोर ददा के घर ले अऊ मोर जनम भुइयां ले बाहिर लानिस अऊ मोर ले गोठियाईस अऊ कसम खाके मोर ले ये परतिगियां करिस, ‘में ये देस तोर संतान ला दूहूं,’ त ओहीच ह अपन स्वरगदूत ला तोर आघू-आघू पठोही कि तें मोर बेटा बर उहां ले एक घरवाली ले आन। ");
INSERT INTO hne_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","पर यदि ओ नोनी-पीला ह तोर संग नइं आय चाहही, तब तो तें मोर ये किरिया से छूट जाबे; पर मोर बेटा ला उहां झन ले जाबे।” ");
INSERT INTO hne_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","तब ओ दास ह अपन मालिक अब्राहम के जांघ के तरी म अपन हांथ रखके ये बिसय म ओकर ले किरिया खाईस। ");
INSERT INTO hne_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","तब ओ दास ह अपन मालिक के दस ठन ऊंट ला लीस अऊ ओमा अपन मालिक के जम्मो किसम के बने चीजमन ला जोरके अरम-नहरैम जाय बर निकलिस अऊ ओह नाहोर के नगर करा हबरिस। ");
INSERT INTO hne_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ओह ऊंटमन ला नगर के बाहिर कुआं के लकठा म बईठाईस। ओ सांझ के बेरा रहय, अऊ ओ समय म माईलोगनमन पानी भरे बर आवंय। ");
INSERT INTO hne_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","तब ओह ये पराथना करन लगिस, “हे यहोवा, मोर मालिक अब्राहम के परमेसर, आज तें मोर काम ला सफल कर अऊ मोर मालिक अब्राहम ऊपर दया कर। ");
INSERT INTO hne_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","देख, में पानी के ये सोता के बाजू म ठाढ़े हंव, अऊ नगर के मनखेमन के बेटीमन पानी भरे बर निकलके आवत हें। ");
INSERT INTO hne_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","एकरसेति अइसन होवन दे कि जऊन जवान नोनी ला में ये कहंव, ‘अपन घघरी ला मोर कोति नवा कि में पानी पी सकंव,’ अऊ ओह कहय, ‘ले पी ले, अऊ में तोर ऊंटमन ला घलो पानी पीयाहूं’—त ओही ह ओ जवान छोकरी होवय, जेला तेंह अपन दास इसहाक बर ठहिराय हस। एकर दुवारा, मेंह जान डारहूं कि तेंह मोर मालिक ऊपर दया करे हस।” ");
INSERT INTO hne_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","एकर पहिली कि ओकर पराथना खतम होतिस, रिबका ह अपन कंधा म घघरी बोहके आईस, जऊन ह अब्राहम के भाई नाहोर के घरवाली मिलका के बेटा बतूएल के बेटी रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ओह बहुंत सुन्दर अऊ कुंवारी रिहिस, अऊ कोनो पुरूस के संग नइं सुते रिहिस। ओह पानी के सोता करा उतरिस अऊ अपन घघरी ला भरके फेर ऊपर आईस। ");
INSERT INTO hne_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","तब ओ दास ह जल्दी करके ओकर ले भेंट करे बर गीस अऊ कहिस, “किरपा करके अपन घघरी म ले मोला थोरकन पानी पीया दे।” ");
INSERT INTO hne_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ओह कहिस, “हे मोर परभू, ले, पी ले,” अऊ ओह जल्दी से घघरी ला उतारके हांथ म धरे-धरे ओला पीया दीस। ");
INSERT INTO hne_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","जब ओह ओला पानी पीया डारिस, तब कहिस, “में तोर ऊंटमन बर घलो तब तक पानी भर-भरके लानहूं, जब तक ओमन पी नइं डारहीं।” ");
INSERT INTO hne_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","तब ओह तुरते अपन घघरी के पानी ला कोटना म ढारके फेर कुआं म पानी भरे बर दऊड़िस अऊ ओकर जम्मो ऊंटमन बर पानी भर दीस। ");
INSERT INTO hne_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ओ मनखे ह ओकर कोति चुपेचाप धियान से देखत, ये जाने के कोसिस करत रिहिस कि यहोवा ह ओकर काम ला सफल करिस हे कि नइं। ");
INSERT INTO hne_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","जब ऊंटमन पानी पी डारिन, तब ओ मनखे ह एक बेका सोन के नकफुली निकालके ओला दीस, अऊ दस सेकेल सोन के दू ठन कंगन ओकर हांथ म पहिरा दीस; ");
INSERT INTO hne_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","अऊ पुछिस, “तें काकर बेटी अस? मोला बता, का तोर ददा के घर म हमर बर रथिया ठहिरे बर जगह हवय?” ");
INSERT INTO hne_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ओह जबाब दीस, “में तो नाहोर के घरवाली मिलका के जनमाय बेटा बतूएल के बेटी अंव।” ");
INSERT INTO hne_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","फेर ओह ओला कहिस, “हमर घर म पैंरा अऊ चारा बहुंत हवय, अऊ रात बिताय बर जगह घलो हवय।” ");
INSERT INTO hne_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तब ओ मनखे ह मुड़ नवाके यहोवा के अराधना करिस ");
INSERT INTO hne_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","अऊ कहिस, “यहोवा, मोर मालिक अब्राहम के परमेसर के महिमा होवय, जऊन ह अपन दया अऊ सच्चई ला मोर मालिक ऊपर ले नइं हटाईस। यहोवा ह मोला सही रसता म लेके मोला मोर मालिक के भाई-बंधुमन के घर म पहुंचा दीस।” ");
INSERT INTO hne_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तब ओ जवान नोनी ह दऊड़के गीस अऊ अपन दाई के घर के मनखेमन ला ये बात बताईस। ");
INSERT INTO hne_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","रिबका के भाई लाबान ह तुरते दऊड़के ओ मनखे करा कुआं म गीस। ");
INSERT INTO hne_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","जब ओकर नजर अपन बहिनी के नकफुली अऊ हांथ म पहिरे कंगन म परिस, अऊ ओकर ये बात ला सुनिस कि ओ मनखे ह रिबका ला का कहे रिहिस, त ओह तुरते ओ मनखे करा गीस, जऊन ह कुआं के तीर म ऊंटमन करा ठाढ़े रहय। ");
INSERT INTO hne_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","लाबान ह कहिस, “हे यहोवा कोति ले आसीसित मनखे, मोर संग आ। तें काबर इहां बाहिर म ठाढ़े हस? मेंह तोर बर घर ला तियार करे हंव, अऊ ऊंटमन बर घलो जगह तियार करे हंव।” ");
INSERT INTO hne_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","त ओ मनखे ह घर म गीस, अऊ ऊंटमन के काठी खोलके ओमन ला चारा-पानी दिये गीस, अऊ ओकर अऊ ओकर संगीमन के गोड़ धोय बर पानी लाने गीस। ");
INSERT INTO hne_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","तब ओला खाना परोसे गीस, पर ओह कहिस, “में जब तक अपन आय के कारन नइं बता दंव, तब तक कुछू नइं खावंव।” लाबान ह कहिस, “त फेर बता।” ");
INSERT INTO hne_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","तब ओह कहिस, “में तो अब्राहम के दास अंव। ");
INSERT INTO hne_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","यहोवा ह मोर मालिक ला अब्बड़ आसीस दे हवय, अऊ ओह धनी मनखे हो गय हे। परमेसर ह ओला भेड़-बकरी, गाय-बईला, सोन-चांदी, दास-दासी, ऊंट अऊ गदहामन दे हवय। ");
INSERT INTO hne_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","मोर मालिक के घरवाली सारा ह अपन बुढ़त काल म ओकर बर एक बेटा जनमाय हे, अऊ ओ बेटा ला अब्राहम ह अपन सबो कुछू दे देय हवय। ");
INSERT INTO hne_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","अऊ मोर मालिक ह मोला किरिया खवाके ये कहिस, ‘तें कनानीमन के बेटीमन ले, जेमन के देस म मेंह रहिथंव, कोनो ला मोर बेटा के घरवाली बनाके झन लानबे, ");
INSERT INTO hne_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","पर मोर ददा के परिवार अऊ मोर अपन गोत्र म जा अऊ मोर बेटा बर एक घरवाली लान।’ ");
INSERT INTO hne_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“तब में अपन मालिक ले पुछेंव, ‘मान ले ओ नोनी ह मोर संग नइं आही त?’ ");
INSERT INTO hne_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“मोर मालिक ह मोला कहिस, ‘यहोवा जेकर पाछू में ईमानदारी से चलत आय हंव, ओह तोर संग अपन स्वरगदूत ला भेजके तोर यातरा ला सफल करही, अऊ तें मोर गोत्र अऊ मोर ददा के परिवार ले मोर बेटा बर एक घरवाली लाय सकबे। ");
INSERT INTO hne_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","तेंह मोर किरिया ले तभे छूटबे, जब तें मोर गोत्र के मनखेमन करा जाबे, अऊ ओमन यदि तोला अपन नोनी ला देय म इनकार करहीं, त तें मोर ये किरिया ले छूट जाबे।’ ");
INSERT INTO hne_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“जब में आज ओ पानी के सोता करा आयेंव त पराथना करेंव, ‘हे यहोवा, मोर मालिक अब्राहम के परमेसर, यदि तें मोर यातरा ला सफल करथस, ");
INSERT INTO hne_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","त देख, में पानी के ये सोता के बाजू म ठाढ़े हंव। यदि कोनो जवान छोकरी पानी भरे बर आवय, अऊ में ओला कहंव, “मोला अपन घघरी म ले थोरकन पानी पीया,” ");
INSERT INTO hne_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","अऊ यदि ओह मोला कहय, “ले, पी ले, अऊ में तोर ऊंटमन ला घलो पानी पीयाहूं,” त ओहीच ह ओ नोनी होवय, जेला यहोवा ह मोर मालिक के बेटा बर ठहिराय हवय।’ ");
INSERT INTO hne_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“एकर पहिली कि मेंह अपन मन म करत पराथना ला खतम करतेंव, रिबका ह अपन कंधा म घघरी बोहके आईस, अऊ ओह खाल्हे सोता करा जाके पानी भरे लगिस, त में ओला कहेंव, ‘मोला पानी पीया दे ओ।’ ");
INSERT INTO hne_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“अऊ ओह तुरते अपन घघरी ला कंधा ले उतारके कहिस, ‘ले, पी ले, अऊ में तोर ऊंटमन ला घलो पीयाहूं।’ त मेंह पानी पीयेंव, अऊ ओह ऊंटमन ला घलो पानी पीयाईस। ");
INSERT INTO hne_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“तब मेंह ओला पुछेंव, ‘तेंह काकर बेटी अस?’ “ओह कहिस, ‘में तो नाहोर के घरवाली मिलका के जनमाय बेटा बतूएल के बेटी अंव।’ “तब मेंह ओकर नाक म नकफुली अऊ ओकर हांथ म कंगन पहिरा देंव। ");
INSERT INTO hne_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","फेर में मुड़ नवाके यहोवा के दंडवत करेंव। मेंह यहोवा, मोर मालिक अब्राहम के परमेसर के महिमा करेंव, काबरकि ओह मोला सही रसता म लानिस कि में अपन मालिक के बेटा बर ओकर भाई के नतनीन ला लान सकंव। ");
INSERT INTO hne_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","एकरसेति अब, यदि तुमन मोर मालिक बर दया अऊ ईमानदारी देखाय चाहत हव, त मोला बतावव; अऊ यदि नइं चाहत हव, त ओला घलो बतावव, ताकि में जान सकंव कि मोला कोन कोति जाना हे।” ");
INSERT INTO hne_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","तब लाबान अऊ बतूएल जबाब दीन, “येह यहोवा कोति ले होईसे; एकरसेति हमन तोला न हां कहे सकन, न ना कहे सकन। ");
INSERT INTO hne_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","देख, रिबका इहां हवय; ओला ले जा अऊ ओह यहोवा के बचन के मुताबिक तोर मालिक के बेटा के घरवाली हो जावय।” ");
INSERT INTO hne_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ओमन के ये बात ला सुनके, अब्राहम के दास ह भुइयां म मुड़ नवाके यहोवा ला दंडवत करिस। ");
INSERT INTO hne_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","तब ओ दास ह सोन अऊ चांदी के जेवर अऊ कपड़ा निकालके रिबका ला दीस; अऊ ओकर भाई अऊ दाई ला घलो ओह मंहगा-मंहगा चीज भेंट म दीस। ");
INSERT INTO hne_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","तब ओ अऊ ओकर संग के मनखेमन खाईन-पीईन अऊ उहां रथिया अराम करिन। जब ओमन दूसर दिन बिहनियां सोके उठिन, त ओह कहिस, “मोला मोर मालिक करा जाय बर बिदा करव।” ");
INSERT INTO hne_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","पर रिबका के भाई अऊ दाई कहिन, “नोनी ला हमर करा कुछू दिन, याने कि कम से कम दस दिन अऊ रहन दे; तब तें ओला ले जाबे।” ");
INSERT INTO hne_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","पर ओह ओमन ला कहिस, “यहोवा ह मोर यातरा ला सफल करिस हे, एकरसेति मोला झन रोकव। अब मोला बिदा करव कि में अपन मालिक करा जावंव।” ");
INSERT INTO hne_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","तब ओमन कहिन, “हमन नोनी ला बलाके एकर बारे म पुछथन।” ");
INSERT INTO hne_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","तब ओमन रिबका ला बलाके पुछिन, “का तें ये मनखे संग जाबे?” ओह कहिस, “हव, में जाहूं।” ");
INSERT INTO hne_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","तब ओमन अपन बहिनी रिबका अऊ ओकर धाई अऊ अब्राहम के दास अऊ ओकर संग के मनखेमन ला बिदा करिन। ");
INSERT INTO hne_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","अऊ ओमन रिबका ला आसीरबाद देके कहिन, “हे हमर बहिनी, तोर संतानमन हजारों लाखों के संखिया म होवंय; तोर संतान के मनखेमन अपन बईरीमन के सहरमन ला अपन अधिकार म करंय।” ");
INSERT INTO hne_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","तब रिबका अऊ ओकर सेविकामन तियार होके ऊंट के ऊपर चघिन अऊ ओ मनखे के संग चल दीन। ये किसम ले ओ दास ह रिबका ला लेके चल दीस। ");
INSERT INTO hne_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","इसहाक ह बेर-लहाय-रोई ले लहुंटके आय रिहिस, अऊ नेगेव देस म रहत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","एक दिन सांझ के बेरा ओह मैदान म मनन-चिंतन करे बर निकले रिहिस, अऊ जब ओह आंखी उठाके देखिस, त का देखिस कि ऊंटमन आवत रहंय। ");
INSERT INTO hne_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबका ह घलो आंखी उठाके इसहाक ला देखिस, अऊ ओह अपन ऊंट ऊपर ले उतरिस, ");
INSERT INTO hne_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","अऊ दास ले पुछिस, “जऊन मनखे मैदान ले हमर करा भेंट करे बर आवथे, ओह कोन अय?” ओ दास ह जबाब दीस, “ओह तो मोर मालिक अय।” तब रिबका ह अपन घूंघट लेके अपनआप ला ढांप लीस। ");
INSERT INTO hne_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","दास ह इसहाक ला अपन यातरा के पूरा कहानी बताईस। ");
INSERT INTO hne_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","तब इसहाक ह रिबका ला अपन दाई सारा के तम्बू म ले आईस, अऊ ओकर संग बिहाव करिस। ये किसम ले रिबका ह ओकर घरवाली बनिस, अऊ इसहाक ह ओला मया करिस; अऊ इसहाक ला अपन दाई के मऊत के पाछू सांति मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहम ह एक झन अऊ माईलोगन ला अपन घरवाली बनाय रिहिस, जेकर नांव कतूरा रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ओकर ले जिमरान, योकसान, मदान, मिदयान, यिसबाक अऊ सूह जनमिन। ");
INSERT INTO hne_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योकसान ले सेबा अऊ ददान पईदा होईन; अऊ ददान के संतान अस्सूरी, लतूसी अऊ लुम्मीमन रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिदयान के एपा, एपेर, हनोक, अबीदा अऊ एलदा नांव के बेटामन होईन। ये जम्मो कतूरा के संतान रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","इसहाक ला अब्राहम ह अपन जम्मो कुछू ला दे दीस। ");
INSERT INTO hne_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","पर अपन रखैलीमन के बेटामन ला कुछू भेंट देके अपन जीते जी अपन बेटा इसहाक करा ले ओमन ला दूरिहा पूरब देस म पठो दीस। ");
INSERT INTO hne_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहम के कुल उमर एक सौ पचहत्तर बछर के होईस। ");
INSERT INTO hne_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","तब अब्राहम के पूरा बुढ़ापा म परान छूट गीस; ओह पूरा उमर के एक डोकरा रिहिस; अऊ ओह मरे के बाद अपन पुरखामन संग जा मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ओकर बेटा इसहाक अऊ इसमायल ओला हित्ती सोहर के बेटा एपरोन के भुइयां म, ममरे के लकठा म जऊन मकपेला के गुफा रिहिस, ओमा माटी दीन, ");
INSERT INTO hne_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","याने कि जऊन भुइयां ला अब्राहम ह हित्तीमन करा ले बिसाय रिहिस; ओही म अब्राहम ला ओकर घरवाली सारा के संग माटी दीन। ");
INSERT INTO hne_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहम के मरे के बाद, परमेसर ह ओकर बेटा इसहाक ला आसीस दीस, जऊन ह ओ बेरा बेर-लहाय-रोई के लकठा म रहत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","अब्राहम के बेटा इसमायल, जऊन ह सारा के दासी, हाजिरा मिसरी ले जनमे रिहिस, ओकर ये बंसावली अय। ");
INSERT INTO hne_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इसमायल के बेटामन के नांव ओमन के जनम के मुताबिक ये अय: इसमायल के बड़े बेटा नबायोत, तब केदार, अदबेल, मिबसाम, ");
INSERT INTO hne_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिस्मा, दूमा, मस्सा, ");
INSERT INTO hne_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीस अऊ केदमा। ");
INSERT INTO hne_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","इसमायल के बेटा येमन रिहिन, अऊ ओमन के बसावट अऊ छावनीमन के मुताबिक ये बारह जाति के परधानमन के नांव अय। ");
INSERT INTO hne_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इसमायल के कुल उमर एक सौ सैंतीस बछर होईस। तब ओह मर गीस अऊ अपन मनखेमन संग मिल गीस। ");
INSERT INTO hne_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ओकर संतानमन हवीला ले लेके सूर के छेत्र म बस गीन, जेह मिसर देस के पूरबी सीमना के लकठा म, अस्सूर के रसता म हवय। ओमन अपन जम्मो गोत्र के भाई-बंधुमन के बईरी के सहीं रहत रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहम के बेटा इसहाक के परिवार के बिबरन ये अय। अब्राहम ले इसहाक जनम लीस, ");
INSERT INTO hne_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","अऊ इसहाक चालीस बछर के रिहिस, जब ओह रिबका ले बिहाव करिस, जऊन ह पदन-अराम के निवासी, अरामी बतूएल के बेटी अऊ अरामी लाबान के बहिनी रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाक के घरवाली बांझ रिहिस, एकरसेति ओह अपन घरवाली बर यहोवा ले पराथना करिस अऊ यहोवा ह ओकर पराथना ला सुनिस, अऊ ओकर घरवाली रिबका ला गरभ ठहिरिस। ");
INSERT INTO hne_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","लइकामन ओकर गरभ म एक-दूसर ला धक्का देय लगिन, त ओह कहिस, “मोर संग अइसन काबर होवथे?” एकरसेति ओह यहोवा ले पुछे बर गीस। ");
INSERT INTO hne_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","तब यहोवा ह ओला कहिस, “तोर गरभ म दू ठन जाति हवंय, अऊ तोर म ले दू किसम के मनखेमन निकलके अलग-अलग होहीं; एक दल के मनखेमन दूसर मनखेमन ले जादा बलवान होहीं, अऊ बड़खा बेटा ह छोटे के सेवा करही।” ");
INSERT INTO hne_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","जब रिबका के छेवारी होय के समय आईस, त पता चलिस कि ओकर गरभ म जुड़वां लइका हवंय। ");
INSERT INTO hne_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","जऊन ह पहिली जनमिस, ओह लाल रिहिस, अऊ ओकर जम्मो देहें ह बाल से भरे रिहिस; एकरसेति ओकर नांव एसाव रखे गीस। ");
INSERT INTO hne_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","एकर बाद, ओकर भाई अपन हांथ ले एसाव के एड़ी धरके पईदा होईस; एकरसेति ओकर नांव याकूब रखे गीस। जब रिबका ह ये लइकामन ला जनमिस, तब इसहाक साठ साल के रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ओ लड़कामन बढ़त गीन, अऊ एसाव ह खुला भुइयां म रहइया, एक चतुर सिकारी हो गीस, पर याकूब ह तम्बू के बीच घर म रहिके संतुस्ट रहय। ");
INSERT INTO hne_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाक ह सिकार के मांस ला खाना पसंद करय, एकरसेति ओह एसाव ले मया करय, पर रिबका ह याकूब ला मया करय। ");
INSERT INTO hne_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एक दिन जब याकूब ह कुछू रांधत रिहिस, त एसाव ह खुला मैदान कोति ले आईस अऊ ओला बहुंत भूख लगत रहय। ");
INSERT INTO hne_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","त ओह याकूब ला कहिस, “जऊन लाल चीज ला तेंह रांधत हस, जल्दी करके ओमा के कुछू मोला दे, काबरकि मोला बहुंत भूख लगत हे!” (एकरसेति ओला एदोम घलो कहे जावय।) ");
INSERT INTO hne_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकूब ह कहिस, “पहिले तें अपन पहिलऊठा के अधिकार मोर करा बेच दे।” ");
INSERT INTO hne_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव ह कहिस, “देख, में तो मरइया हंव, त पहिलऊठा के अधिकार ले मोला का फायदा?” ");
INSERT INTO hne_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","पर याकूब ह कहिस, “पहिले तें मोर करा किरिया खा।” त ओह किरिया खाके याकूब करा अपन पहिलऊठा के अधिकार ला बेच दीस। ");
INSERT INTO hne_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तब याकूब ह एसाव ला कुछू रोटी अऊ रंधाय दाल दीस। ओह खाईस-पीईस अऊ उठके चल दीस। ये किसम ले, एसाव ह अपन पहिलऊठा के अधिकार ला तुछ जानिस। ");
INSERT INTO hne_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","कुछू समय के बाद, ओ देस म अकाल परिस, एकरे बर इसहाक ह पलिस्तीमन के राजा अबीमेलेक करा गरार म गीस। ये ओ अकाल ले अलग रिहिस, जऊन ह अब्राहम के समय म परे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","गरार म यहोवा ह इसहाक ला दरसन देके कहिस, “मिसर देस म झन जा; मेंह तोला जऊन देस म रहे बर कहथंव, ओही देस म रह। ");
INSERT INTO hne_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","तें ये देस म कुछू समय तक रह, अऊ में तोर संग रहिहूं अऊ तोला आसीस दूहूं। ये पूरा देस में तोला अऊ तोर संतानमन ला दूहूं; ये किसम ले जऊन किरिया में तोर ददा अब्राहम करा खाय रहेंव, ओला पूरा करहूं। ");
INSERT INTO hne_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","में तोर संतानमन ला अकास के तारामन सहीं अनगिनत करहूं अऊ ओमन ला ये जम्मो देस ला दूहूं, अऊ तोर संतान के जरिये धरती के जम्मो जाति के मनखेमन आसीस पाहीं, ");
INSERT INTO hne_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","काबरकि अब्राहम ह मोर बात मानिस, अऊ जऊन हुकूम, नियम अऊ निरदेस, में ओला दे रहेंव, ओ जम्मो के पालन करिस।” ");
INSERT INTO hne_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","एकरे बर इसहाक ह गरार म रह गीस। ");
INSERT INTO hne_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","जब ओ ठऊर के मनखेमन ओकर घरवाली के बारे म ओकर ले पुछिन, त ओह कहिस, “ओह मोर बहिनी अय।” काबरकि ओह ये सोचके डरत रिहिस कि यदि में ओला अपन घरवाली कहिहूं, त इहां के मनखेमन रिबका के कारन मोला मार डारहीं, काबरकि ओह सुन्दर हवय। ");
INSERT INTO hne_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","जब ओला उहां रहत बहुंत दिन बीत गीस, तब एक दिन पलिस्तीमन के राजा अबीमेलेक ह खिड़की ले झांकके देखिस कि इसहाक ह अपन घरवाली रिबका के संग प्रेमालाप करत हे। ");
INSERT INTO hne_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","तब अबीमेलेक ह इसहाक ला बलाके कहिस, “ओह सही म तोर घरवाली अय! फेर तें काबर ओला अपन बहिनी कहय?” इसहाक ह जबाब दीस, “मेंह सोचेंव कि ओकर कारन मोला अपन परान गंवाना पड़ सकत हे।” ");
INSERT INTO hne_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","तब अबीमेलेक ह कहिस, “तेंह हमर संग ये का करे हस? अइसन म तो कोनो भी मनखे तोर घरवाली संग आसानी से कुकरम कर सकत रिहिस, अऊ तें हमन ला पाप म फंसाते।” ");
INSERT INTO hne_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","एकर कारन अबीमेलेक ह जम्मो मनखेमन ला हुकूम दीस, “जऊन ह भी ओ मनखे अऊ ओकर घरवाली संग गलत बेवहार करही, ओह खचित मार डारे जाही।” ");
INSERT INTO hne_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","फेर इसहाक ह ओ देस म खेती करिस, अऊ ओही बछर म सौ गुना फर पाईस, काबरकि यहोवा ह ओला आसीस दीस। ");
INSERT INTO hne_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","अऊ ओह धनी हो गीस, अऊ ओकर धन लगातार बढ़त गीस अऊ ओह बहुंत धनी हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","जब ओकर बहुंत भेड़-बकरी, गरूवा-बईला, अऊ नौकर-चाकर हो गीन; तब पलिस्तीमन ओकर ले जलन करे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","एकर कारन जतेक कुआंमन ला ओकर ददा के सेवकमन ओकर ददा अब्राहम के जीते जी खने रिहिन, ओला पलिस्तीमन माटी पाटके बंद कर दीन। ");
INSERT INTO hne_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","तब अबीमेलेक ह इसहाक ला कहिस, “हमर पास ले चले जा, काबरकि तें हमन ले बहुंत बलवान हो गे हस।” ");
INSERT INTO hne_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","एकरे बर इसहाक उहां ले चल दीस अऊ गरार के घाटी म अपन तम्बू ठाढ़ करके उहां रहे लगिस। ");
INSERT INTO hne_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","तब जऊन कुआंमन ला ओकर ददा के समय खने गे रिहिस, अऊ अब्राहम के मरे के पाछू पलिस्तीमन पाट दे रिहिन, ओमन ला इसहाक ह फेर खनवाईस, अऊ ओमन के ओहीच नांव रखिस, जे नांव ओकर ददा ह रखे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","फेर इसहाक के दासमन घाटी म खोदई करिन अऊ उहां ओमन ला ताजा पानी के एक ठन कुआं मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","पर गरार के चरवाहामन इसहाक के चरवाहामन संग झगरा करिन अऊ ओमन कहिन, “ये पानी हमर अय।” एकरे बर ओह ओ कुआं के नांव एसेक रखिस; काबरकि ओमन ओकर संग झगरा करे रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","तब ओमन आने कुआं खनिन, पर ओमन ओकर बर घलो झगरा करिन; एकरे बर ओह ओकर नांव सितनाह रखिस। ");
INSERT INTO hne_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","तब ओह उहां ले निकलके एक अऊ कुआं खनवाईस, अऊ ओकर बर उहां कोनो झगरा नइं करिन। ओह ओकर नांव ये कहिके रहोबोत रखिस, “अब यहोवा ह हमन ला बहुंत जगह दे हवय अऊ हमन ये देस म फूलबो-फरबो।” ");
INSERT INTO hne_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","उहां ले इसहाक ह बेरसेबा चल दीस। ");
INSERT INTO hne_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ओ रथिया यहोवा ह ओला दरसन देके कहिस, “मेंह तोर ददा अब्राहम के परमेसर अंव। झन डर, काबरकि मेंह तोर संग हवंव; में अपन दास अब्राहम ले करे परतिगियां के कारन तोला आसीस दूहूं अऊ तोर संतानमन के गनती ला बढ़ाहूं।” ");
INSERT INTO hne_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","तब इसहाक ह उहां एक ठन बेदी बनाईस अऊ यहोवा के अराधना करिस। उहां ओह अपन तम्बू ठाढ़ करिस, अऊ उहां ओकर दासमन एक ठन कुआं खनिन। ");
INSERT INTO hne_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ये बीच म, अबीमेलेक ह अपन सलाहकार अहुज्जत अऊ अपन सेना के सेनापति पीकोल के संग गरार ले इसहाक करा आईस, ");
INSERT INTO hne_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","त इसहाक ह ओमन ले पुछिस, “तुमन मोर ले बईरता करके मोला अपन बीच ले निकाल दे रहेव, अब मोर करा काबर आय हवव?” ");
INSERT INTO hne_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ओमन जबाब दीन, “हमन सच म देख डारेंन कि यहोवा ह तोर संग रहिथे; एकरे बर हमन सोचेंन कि हमर बीच म किरिया खाके करार होना चाही—हमर अऊ तोर बीच म। आ, हमर संग करार कर ");
INSERT INTO hne_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","कि तेंह हमर कोनो हानि नइं करबे, जइसन कि हमन तोर कोनो हानि नइं करेंन, पर तोर संग हमेसा बने बरताव करेंन अऊ तोला सांति से बिदा करेंन। अऊ अब तें यहोवा के दुवारा आसीसित अस।” ");
INSERT INTO hne_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","तब इसहाक ह ओमन बर एक भोज करिस अऊ ओमन खाईन-पीईन। ");
INSERT INTO hne_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","दूसर दिन बड़े बिहनियां ओ मनखेमन एक-दूसर ले किरिया खाईन। तब इसहाक ह ओमन ला बिदा करिस, अऊ ओमन सांति से उहां ले चल दीन। ");
INSERT INTO hne_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ओही दिन इसहाक के दासमन आके ओ खने गय कुआं के बारे बताईन। ओमन कहिन, “हमन ला पानी मिल गे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","तब ओह ओकर नांव सिबा रखिस, अऊ आज तक ओ नगर के नांव बेरसेबा परे हे। ");
INSERT INTO hne_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","जब एसाव ह चालीस बछर के होईस, त ओह हित्ती बेरी के बेटी यूदीत, अऊ हित्ती एलोन के बेटी बासमत ले बिहाव कर लीस। ");
INSERT INTO hne_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ओमन इसहाक अऊ रिबका के दुख के कारन रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","जब इसहाक ह डोकरा हो गीस अऊ ओकर आंखी ह अतेक कमजोर हो गीस कि ओला दिखना ही बंद हो गीस, तब ओह अपन बड़खा बेटा एसाव ला बलाके कहिस, “हे बेटा।” ओह कहिस, “में इहां हंव।” ");
INSERT INTO hne_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","इसहाक ह कहिस, “सुन, में तो डोकरा हो गे हंव अऊ नइं जानंव कि कब मर जाहूं। ");
INSERT INTO hne_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","एकरसेति, अब तें अपन साज-सामान—तीर-धनुस लेके खुले मैदान म जा, अऊ मोर बर कोनो जंगली पसु सिकार करके लान, ");
INSERT INTO hne_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","अऊ मोर मन के लईक सुवादवाला जेवन बनाके मोर करा लान कि में ओला खाके मरे के पहिली तोला आसीस देवंव।” ");
INSERT INTO hne_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","जब इसहाक ह अपन बेटा एसाव ले गोठियावत रिहिस, त ओ बात ला रिबका ह सुनत रिहिस। जब एसाव ह सिकार करे बर खुला मैदान म चल दीस, ");
INSERT INTO hne_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","त रिबका ह अपन बेटा याकूब ला कहिस, “देख, मेंह तोर ददा ला तोर भईया एसाव ले ये कहत सुने हंव, ");
INSERT INTO hne_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘तें मोर बर सिकार करके लान अऊ सुवादवाला जेवन बना कि में मरे के पहिली ओला खाके तोला यहोवा के आघू म आसीस देवंव।’ ");
INSERT INTO hne_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","एकरसेति, हे मोर बेटा, धियान से सुन अऊ मोर बात ला मान: ");
INSERT INTO hne_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","पसुमन के झुंड म जाके दू ठन बने-बने बोकरा-पीला ले आन कि में तोर ददा बर ओकर मन के लईक सुवादवाला जेवन बनावंव। ");
INSERT INTO hne_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","तब तें ओला अपन ददा करा ले जाबे कि ओह ओला खाके मरे के पहिली तोला आसीस देवय।” ");
INSERT INTO hne_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकूब ह अपन दाई रिबका ला कहिस, “देख, मोर भईया एसाव तो रूआंवाला मनखे अय, पर में तो बिन रूआं के अंव। ");
INSERT INTO hne_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","कहूं मोर ददा मोला छूही, तब का होही? में तो ओकर नजर म धोखा देवइया हो जाहूं अऊ आसीस के बदला म मोला सराप मिलही।” ");
INSERT INTO hne_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ओकर दाई ह ओला कहिस, “हे मोर बेटा, सराप तोला नइं, मोला मिलय। में जऊन बात कहत हंव, ओला कर; जा अऊ बोकरामन ला मोर करा ले आन।” ");
INSERT INTO hne_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","तब याकूब ह जाके बोकरामन ला अपन दाई करा ले आईस, अऊ ओकर दाई ह ओकर ददा के मन के लईक सुवादवाला जेवन बना दीस। ");
INSERT INTO hne_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","तब रिबका ह अपन बड़खा बेटा एसाव के सबले सुन्दर कपड़ा ला लीस, जऊन ह कि ओकर करा घर म रिहिस अऊ ओला लेके अपन छोटे बेटा याकूब ला पहिरा दीस। ");
INSERT INTO hne_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","अऊ ओह बोकरा के खाल ला लेके याकूब के हांथमन म अऊ ओकर चिकना घेंच म लपेट दीस। ");
INSERT INTO hne_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","तब ओह सुवादवाला जेवन अऊ अपन बनाय रोटी ला अपन बेटा याकूब के हांथ म धरा दीस। ");
INSERT INTO hne_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","याकूब ह अपन ददा करा गीस अऊ कहिस, “हे मोर ददा।” ओकर ददा ह कहिस, “हव, मोर बेटा, तेंह कोन अस?” ");
INSERT INTO hne_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूब ह अपन ददा ला कहिस, “मेंह तोर बड़खा बेटा एसाव अंव। जइसे तेंह मोला कहे रहय, वइसे मेंह करे हंव। बईठ जा अऊ मोर दुवारा सिकार करके लाने गे मांस ला खा अऊ मोला आसीस दे।” ");
INSERT INTO hne_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाक ह अपन बेटा ले पुछिस, “येह तोला अतकी जल्दी कइसे मिल गीस, बेटा?” ओह जबाब दीस, “यहोवा तोर परमेसर ह मोला सफल करिस।” ");
INSERT INTO hne_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","तब इसहाक ह याकूब ला कहिस, “मोर लकठा म आ कि में तोला छुवंव, मोर बेटा, अऊ जानंव कि तें सही म मोर बेटा एसाव अस कि नइं।” ");
INSERT INTO hne_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","याकूब ह अपन ददा इसहाक के लकठा म गीस; तब इसहाक ह ओला छुईस अऊ कहिस, “अवाज तो याकूब के अवाज अय, पर हांथमन एसाव के हांथ अंय।” ");
INSERT INTO hne_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","इसहाक ह याकूब ला नइं चिन्हिस, काबरकि ओकर हांथमन ओकर भईया एसाव के सहीं रूआंदार रिहिन; एकर बर इसहाक ह ओला आसीस देय के सुरू करिस। ");
INSERT INTO hne_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","अऊ ओह पुछिस, “का सही म, तें मोर बेटा एसाव अस?” ओह कहिस, “हव, में अंव।” ");
INSERT INTO hne_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तब इसहाक ह कहिस, “हे मोर बेटा, सिकार के मांस ला मोर करा ले आ कि में ओला खावंव अऊ तोला अपन आसीस देवंव।” ओह मांस ला इसहाक करा ले आईस अऊ ओह खाईस; अऊ याकूब ह ओकर करा अंगूर के मंद घलो लानिस अऊ ओह खाईस-पीईस। ");
INSERT INTO hne_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","तब ओकर ददा इसहाक ह ओला कहिस, “हे मोर बेटा, इहां आ अऊ मोला चूम।” ");
INSERT INTO hne_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","याकूब ह ओकर करा गीस अऊ ओला चूमिस। जब इसहाक ह ओकर कपड़ा के गंध पाईस, त ओला आसीस दीस अऊ कहिस, “अहा, मोर बेटा के सुगंध ह अइसन खेत के सुगंध सहीं अय जऊन ला यहोवा ह आसीस दे हवय। ");
INSERT INTO hne_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेसर तोला अकास ले ओस अऊ धरती के उत्तम चीज— बहुंत अकन अनाज अऊ अंगूर के नवां मंद देवय। ");
INSERT INTO hne_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","जाति-जाति के मनखेमन तोर सेवा करंय अऊ मनखेमन तोला झुकके दंडवत करंय। तें अपन भाईमन के सुवामी हो जा, अऊ तोर दाई के बेटामन तोला दंडवत करंय। जऊन मन तोला सराप देवंय, ओमन खुद सराप पावंय अऊ जऊन मन तोला आसीस देवंय, ओमन आसीस पावंय।” ");
INSERT INTO hne_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","जब इसहाक ह याकूब ला आसीस दे चुकिस, अऊ याकूब ह अपन ददा इसहाक करा ले निकले ही रिहिस कि ओकर भाई एसाव ह सिकार करके घर आ गीस। ");
INSERT INTO hne_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ओह घलो सुवादवाला जेवन बनाके अपन ददा करा लानिस अऊ कहिस, “हे मोर ददा, बईठ जा अऊ मोर दुवारा सिकार करके लाने गे मांस ला खा अऊ मोला अपन आसीस दे।” ");
INSERT INTO hne_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ओकर ददा इसहाक ह ओकर ले पुछिस, “तें कोन अस?” ओह कहिस, “मेंह तोर बड़खा बेटा एसाव अंव।” ");
INSERT INTO hne_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","इसहाक ह बहुंत थरथरात कहिस, “फेर ओह कोन रिहिस, जेह सिकार करके मोर करा लानिस? अभी तोर आय के पहिली ही ओ सिकार के मांस ला में खायेंव अऊ ओला आसीस देंव—अऊ सही म ओला आसीस मिलही।” ");
INSERT INTO hne_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","अपन ददा के ये गोठ सुनके एसाव ह दुख के मारे नरियाके अऊ फूट-फूटके रोईस अऊ अपन ददा ला कहिस, “हे मोर ददा, मोला आसीस दे—मोला घलो आसीस दे!” ");
INSERT INTO hne_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","पर ओह कहिस, “तोर भाई धोखा से आईस अऊ तोर आसीस ला ले लीस।” ");
INSERT INTO hne_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसाव ह कहिस, “का ओकर नांव याकूब सही नइं रखे गे हे? येह दूसर बार ए, ओह मोर ले फायदा उठाय हवय: ओह मोर पहिलऊठा के अधिकार ला ले लीस, अऊ अब ओह मोर आसीस ला घलो ले गीस!” तब ओह अपन ददा ले पुछिस, “का तेंह मोर बर कोनो आसीस नइं रखे हस?” ");
INSERT INTO hne_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाक ह एसाव ला जबाब दीस, “मेंह ओला तोर ऊपर सुवामी ठहिराय हंव अऊ ओकर जम्मो रिस्तेदार ला ओकर सेवक बनाय हंव, अऊ मेंह ओला अनाज अऊ अंगूर के नवां मंद ले आसीसित करे हंव। अब हे मोर बेटा, में तोर बर का कर सकत हंव?” ");
INSERT INTO hne_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसाव ह अपन ददा ला कहिस, “हे मोर ददा, का तोर करा सिरिप एके ठन आसीस हवय? हे मोर ददा, मोला घलो आसीस दे!” तब एसाव चिचिया-चिचियाके रोईस। ");
INSERT INTO hne_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ओकर ददा इसहाक ह ओला जबाब दीस, “तोर निवास ह धरती के उपजाऊ भुइयां ले दूरिहा होही, ऊपर के अकास के ओस ओमा नइं पड़ही। ");
INSERT INTO hne_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तेंह तलवार के बल म जिनगी जीबे अऊ तेंह अपन भाई के सेवा करबे। पर जब तेंह बियाकुल हो जाबे, त तेंह ओकर सेवा करई छोंड़ देबे।” ");
INSERT INTO hne_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","एसाव ह ओ आसीस के कारन याकूब बर बईरता के भावना रखय, जऊन ला ओकर ददा ह याकूब ला देय रिहिस। ओह अपन मन म कहिस, “मोर ददा के मरे के दिन ह लकठा म हे; तब में अपन भाई याकूब ला मार डारहूं।” ");
INSERT INTO hne_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","जब रिबका ला ओकर बड़खा बेटा एसाव के ये बात बताय गीस, त ओह अपन छोटे बेटा याकूब ला बलाके कहिस, “सुन, तोर भईया एसाव ह बदला लेय बर तोला मार डारे के योजना बनावत हे। ");
INSERT INTO hne_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","एकरसेति हे मोर बेटा, मोर बात ला मान: तुरते मोर भाई लाबान करा हारान नगर म भाग जा। ");
INSERT INTO hne_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","अऊ कुछू समय तक ओकरे संग रह, जब तक कि तोर भईया के गुस्सा नइं उतर जावय। ");
INSERT INTO hne_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","जब तोर भईया के गुस्सा ह खतम हो जाही अऊ जऊन काम तेंह ओकर बिरूध करे हवस, ओला भुला जाही, तब में तोला खबर भिजवाके उहां ले बला लूहूं। अइसन झन हो कि एके दिन म, में तुमन दूनों झन ला गंवा दंव।” ");
INSERT INTO hne_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","तब रिबका ह इसहाक ला कहिस, “ये हित्ती माईलोगनमन के कारन, में अपन जिनगी ले असकटा गे हंव। यदि याकूब ह ये देस के कोनो माईलोगन ला याने कि ये हित्ती माईलोगनमन ले कोनो ला अपन घरवाली बना लेथे, त फेर मोर जीये के कोनो मतलब नइं होही।” ");
INSERT INTO hne_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","एकरसेति इसहाक ह याकूब ला बलाके आसीस दीस, अऊ ओला हुकूम दीस: “तें कोनो कनानी छोकरी ले बिहाव झन करबे। ");
INSERT INTO hne_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","तें तुरते पदन-अराम म, अपन नाना बतूएल के घर जा। उहां तोर ममा लाबान के कोनो बेटी ले बिहाव कर ले। ");
INSERT INTO hne_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वसक्तिमान परमेसर ह तोला आसीस देवय अऊ तोला फूलाय-फलाय अऊ तोर गनती ला बढ़ाय, जब तक कि तें मनखेमन के एक समाज नइं बन जावस। ");
INSERT INTO hne_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ओह अब्राहम ले करे गे परतिगियां के आसीस तोला अऊ तोर बंस ला देवय, ताकि तें ये देस के मालिक बन जा, जिहां अभी तें एक परदेसी के रूप म रहिथस, अऊ जेला परमेसर ह अब्राहम ला दे रिहिस।” ");
INSERT INTO hne_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","तब इसहाक ह याकूब ला बिदा करिस, अऊ ओह पदन-अराम म अरामी बतूएल के बेटा लाबान के घर गीस। लाबान ह याकूब अऊ एसाव के दाई रिबका के भाई रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","जब एसाव ला ये पता चलिस कि इसहाक ह याकूब ला आसीस दे हवय अऊ ओला पदन-अराम पठोय हवय कि ओह उहां बिहाव करय, अऊ ओला आसीस देके ये हुकूम दे हवय, “तें कोनो कनानी माईलोगन ले बिहाव झन करबे,” ");
INSERT INTO hne_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","अऊ याकूब ह अपन दाई-ददा के बात मानके पदन-अराम ला चल दे हवय। ");
INSERT INTO hne_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","तब एसाव महसूस करिस कि कनानी छोकरीमन ओकर ददा इसहाक ला कतेक नापसंद रिहिन; ");
INSERT INTO hne_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","एकरसेति ओह अब्राहम के बेटा इसमायल करा गीस, अऊ इसमायल के बेटी महलत ले बिहाव कर लीस, जऊन ह कि नबायोत के बहिनी रिहिस। एसाव के अऊ घलो घरवाली रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकूब ह बेरसेबा ला छोंड़के हारान जाय बर निकलिस। ");
INSERT INTO hne_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","जब ओह एक जगह म हबरिस, त उहां रात काटे बर रूकिस काबरकि बेर बुड़ गे रहय। उहां एक पथरा ला लेके अपन मुड़ खाल्हे तकिया के रूप म रखिस अऊ सुत गीस। ");
INSERT INTO hne_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ओह सपना म देखिस कि एक सीढ़ी धरती म ठाढ़े हे अऊ ओकर दूसर छोर ह स्वरग तक हबरत हे, अऊ परमेसर के स्वरगदूतमन ओमा चघत-उतरत हवंय। ");
INSERT INTO hne_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ओकर ऊपर म यहोवा ह ठाढ़ होके कहत हे: “में यहोवा, तोर दादा अब्राहम के परमेसर अऊ तोर ददा इसहाक के परमेसर अंव। जऊन भुइयां म तेंह सुते हस, ओला में तोला अऊ तोर बंस ला दूहूं। ");
INSERT INTO hne_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तोर संतानमन भुइयां के धुर्रा सहीं अनगिनत होहीं, अऊ ओमन पछिम, पूरब, उत्तर, दक्खिन, चारों कोति बगर जाहीं। धरती के जम्मो मनखेमन तोर अऊ तोर संतान के जरिये आसीस पाहीं। ");
INSERT INTO hne_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","सुन, में तोर संग हवंव अऊ जिहां कहूं तें जाबे, में तोर रकछा करहूं, अऊ मेंह तोला ये देस म लहुंटाके लानहूं। मेंह तोर ले जऊन परतिगियां करे हंव, जब तक ओला पूरा नइं कर लूहूं, तब तक में तोला नइं छोड़ंव।” ");
INSERT INTO hne_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","जब याकूब ह नींद ले जागिस, त ओह सोचिस, “सही म, ये ठऊर म यहोवा हवय, अऊ में ये बात ला नइं जानत रहेंव।” ");
INSERT INTO hne_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ओह डर के मारे कहिस, “ये ठऊर ह कतेक बढ़िया हवय! येह परमेसर के घर के छोंड़ अऊ कुछू नइं हो सकय; येह स्वरग के कपाट अय।” ");
INSERT INTO hne_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","बड़े बिहनियां याकूब ह ओ पथरा ला लीस, जऊन ला ओह अपन मुड़ के खाल्हे तकिया के रूप म रखे रिहिस अऊ ओला खंभा के रूप म ठाढ़ करिस अऊ ओकर टीप म तेल रितो दीस। ");
INSERT INTO hne_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ओह ओ ठऊर के नांव बेतेल रखिस, हालाकि ओ सहर के नांव लूज रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","तब याकूब ह ये मन्नत मानके कहिस, “यदि परमेसर ह मोर संग रहिही अऊ ये यातरा म मोर रकछा करही अऊ मोला खाय बर रोटी अऊ पहिरे बर कपड़ा दीही ");
INSERT INTO hne_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","अऊ में अपन ददा के घर म सही-सलामत लहुंटके आहूं, त यहोवा ह मोर परमेसर ठहिरही ");
INSERT INTO hne_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","अऊ ये पथरा जेला मेंह खंभा के रूप म ठाढ़ करे हवंव, परमेसर के घर होही, अऊ जऊन कुछू तें मोला देबे, ओ जम्मो के दसवां हिस्सा में तोला दूहूं।” ");
INSERT INTO hne_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","तब याकूब ह अपन यातरा म आघू बढ़िस अऊ पूरब दिग के मनखेमन के देस म आईस। ");
INSERT INTO hne_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","उहां ओह मैदान म एक कुआं देखिस, जेकर लकठा म भेड़-बकरीमन के तीन झुंड बईठे रहंय, काबरकि ओमन ला ओ कुआं ले पानी पीयाय जावय। कुआं के मुहूं के ऊपर के पथरा ह बहुंत बड़े रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","जब जम्मो झुंड ह उहां जमा होवय, त चरवाहामन कुआं के मुहूं ले पथरा ला हटाके भेड़-बकरीमन ला पानी पीयावंय, अऊ तब ओमन पथरा ला फेर कुआं के मुहूं ऊपर जइसन के तइसन मढ़ा दें। ");
INSERT INTO hne_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकूब ह चरवाहामन ला पुछिस, “हे भाईमन, तुमन कहां के अव?” ओमन जबाब दीन, “हमन हारान के अन।” ");
INSERT INTO hne_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","तब ओह ओमन ले पुछिस, “का तुमन नाहोर के पोता लाबान ला जानथव?” ओमन जबाब दीन, “हव, हमन ओला जानथन।” ");
INSERT INTO hne_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","तब याकूब ह ओमन ले पुछिस, “का ओह बने हवय?” ओमन कहिन, “हव, ओह बने हवय, अऊ देख, ओकर बेटी राहेल ह भेड़मन ला लेके आवत हे।” ");
INSERT INTO hne_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ओह कहिस, “देखव, अभी तो दिन बहुंत हे; अभी पसुमन के जूरे के बेरा नइं होय हे। भेड़मन ला पानी पीयावव अऊ फेर ले जाके चरावव।” ");
INSERT INTO hne_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ओमन कहिन, “हमन अइसन नइं कर सकन; जब जम्मो झुंड ह जूरही अऊ पथरा ह कुआं के मुहूं ले टारे जाही, तब हमन भेड़मन ला पानी पीयाबो।” ");
INSERT INTO hne_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","जब ओह ओमन ले गोठियावत रिहिस, तभे राहेल ह अपन ददा के भेड़मन ला लेके आईस, काबरकि ओह पसु चराय के बुता करय। ");
INSERT INTO hne_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","जब याकूब ह अपन ममा लाबान के बेटी राहेल, अऊ अपन ममा के भेड़मन ला देखिस, त ओह उहां जाके कुआं के मुहूं ले पथरा ला टार दीस अऊ अपन ममा के भेड़मन ला पानी पीयाईस। ");
INSERT INTO hne_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","तब याकूब ह राहेल ला चूमिस अऊ चिचिया-चिचियाके रोये लगिस। ");
INSERT INTO hne_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ओह राहेल ला बता दे रिहिस कि ओह ओकर फुफेरा भाई ए, याने कि ओकर फूफू रिबका के बेटा ए। एकरसेति राहेल ह दऊड़के गीस अऊ अपन ददा ला बताईस। ");
INSERT INTO hne_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","अपन भांचा याकूब के खबर पाते ही, लाबान तुरते ओकर संग भेंट करे बर गीस। ओह ओला पोटारके चूमिस अऊ ओला अपन घर ले आईस, अऊ उहां याकूब ओला अपन जम्मो बात बताईस। ");
INSERT INTO hne_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","तब लाबान ह ओला कहिस, “तें तो मोर खुद के मांस अऊ लहू अस।” याकूब के लाबान संग एक महिना रहे के बाद, ");
INSERT INTO hne_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","लाबान ह ओला कहिस, “रिस्तेदार अस तभो ले तोला सोझे म बुता कराना मोला बने नइं लगय, त मोला बता कि बुता करे के बदला म में तोला का देवंव?” ");
INSERT INTO hne_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबान के दू झन बेटी रिहिन; बड़की के नांव लिआ अऊ छोटकी के नांव राहेल रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लिआ के आंखीमन कमजोर रिहिन, पर राहेल ह रूपवती अऊ सुघर रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकूब ह राहेल ले मया करय, एकरसेति ओह कहिस, “में तोर छोटे बेटी राहेल बर सात बछर तोर काम करहूं।” ");
INSERT INTO hne_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबान ह कहिस, “ये बने बात अय कि ओला कोनो अऊ मनखे ला देय के बदले तोला देवंव। इहां मोर संग रह।” ");
INSERT INTO hne_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","याकूब सात बछर तक राहेल ला पाय बर सेवा करिस, पर ये सात बछर ह ओला सिरिप कुछू दिन सहीं लगिस काबरकि ओह राहेल ले मया करय। ");
INSERT INTO hne_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","तब याकूब ह लाबान ला कहिस, “मोर घरवाली ला मोला दे। मोर समय ह पूरा हो गीस, अऊ अब मेंह ओकर मेर जाय चाहत हंव।” ");
INSERT INTO hne_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","तब लाबान ह उहां के जम्मो मनखे ला इकट्ठा करिस अऊ ओमन ला एक भोज दीस। ");
INSERT INTO hne_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","पर जब सांझ होईस, त ओह अंधियार के बेरा अपन बेटी लिआ ला याकूब करा लानिस, अऊ याकूब ओकर संग संबंध बनाईस। ");
INSERT INTO hne_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबान ह अपन बेटी लिआ के दासी होय बर अपन दासी जिलपा ला दीस। ");
INSERT INTO hne_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","जब बिहान होईस, तब पता चलिस कि ये तो लिआ ए। एकरसेति याकूब ह लाबान ला कहिस, “तें मोर संग ये का करे हस? का में तोर सेवा राहेल बर नइं करेंव? तें मोला काबर धोखा दे हस?” ");
INSERT INTO hne_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबान ह जबाब दीस, “हमर इहां अइसन रीति नइं ए कि बड़की बेटी के रहत छोटकी बेटी के बिहाव करन। ");
INSERT INTO hne_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","बेटी के बिहाव उत्सव के ये हप्ता ला पूरा कर; फेर हमन छोटकी ला घलो तोला देबो, तेकर बर तोला अऊ सात साल मोर काम करना पड़ही।” ");
INSERT INTO hne_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","तब याकूब ह वइसनेच करिस। ओह लिआ के संग हप्ता पूरा करिस, अऊ तब लाबान ह ओला अपन बेटी राहेल ला घलो दीस कि ओह ओकर घरवाली होवय। ");
INSERT INTO hne_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबान ह अपन बेटी राहेल के दासी होय बर अपन दासी बिलहा ला दीस। ");
INSERT INTO hne_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","याकूब ह राहेल ले घलो संबंध बनाईस, अऊ ओकर मया लिआ ले जादा राहेल बर रहय। अऊ ओह लाबान बर अऊ सात बछर काम करिस। ");
INSERT INTO hne_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","जब यहोवा ह देखिस कि लिआ ह मया नइं पावत हे, त ओह ओला गरभ ठहिरे के आसीस दीस, पर राहेल बांझ रहय। ");
INSERT INTO hne_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लिआ ह आसरा म होईस अऊ एक बेटा ला जनमिस। ओह ये कहिके ओकर नांव रूबेन रखिस, “यहोवा ह मोर दुख कोति धियान दे हवय। अब मोर घरवाला ह खचित मोला मया करही।” ");
INSERT INTO hne_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ओह फेर आसरा म होईस, अऊ ओकर फेर एक बेटा होईस, त ओह कहिस, “काबरकि यहोवा ह सुनिस कि मोला मया नइं मिलत हे, तेकर खातिर ओह मोला ये बेटा घलो दीस।” अऊ ओह ओकर नांव सिमोन रखिस। ");
INSERT INTO hne_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ओह फेर आसरा म होईस, अऊ ओकर फेर एक बेटा होईस, त ओह कहिस, “अब मोर घरवाला ह मोला मिल जाही, काबरकि ओकर दुवारा मोर तीन बेटा होईन।” एकरसेति ओकर नांव लेवी रखे गीस। ");
INSERT INTO hne_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ओह फेर आसरा म होईस, अऊ ओकर एक अऊ बेटा होईस, त ओह कहिस, “अब के बार में यहोवा के परसंसा करहूं।” एकरसेति ओह ओकर नांव यहूदा रखिस। तब कुछू समय तक ओला लइका नइं होईस। ");
INSERT INTO hne_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","जब राहेल ह देखिस कि याकूब कोति ले ओला कोनो लइका नइं होवथे, त ओह अपन बहिनी ले जलन करे लगिस। ओह याकूब ला कहिस, “मोला लइका दे, नइं तो में मर जाहूं।” ");
INSERT INTO hne_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","याकूब ह राहेल ऊपर गुस्सा होके कहिस, “का में परमेसर अंव? तोर कोख ला तो ओही ह बंद रखे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","तब राहेल ह कहिस, “ये दे मोर दासी बिलहा इहां हवय। ओकर ले संबंध बना ताकि ओह मोर बर लइका जनमे अऊ में घलो ओकर जरिये एक परिवार बनावंव।” ");
INSERT INTO hne_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","त ओह अपन दासी बिलहा ला ओकर घरवाली होय बर दीस। याकूब ओकर करा गीस, ");
INSERT INTO hne_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","अऊ बिलहा ह आसरा म होईस अऊ याकूब ले ओला एक बेटा होईस। ");
INSERT INTO hne_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","तब राहेल ह कहिस, “परमेसर ह मोर नियाय करे हवय; ओह मोर बिनती ला सुनके मोला एक बेटा दे हवय।” एकर कारन ओह ओकर नांव दान रखिस। ");
INSERT INTO hne_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेल के दासी बिलहा फेर आसरा म होईस अऊ याकूब ले ओकर एक अऊ बेटा होईस। ");
INSERT INTO hne_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","तब राहेल ह कहिस, “मोर बहिनी के संग मोर बहुंत संघर्स होईस, अऊ में जीत गेंव।” त ओह ओकर नांव नपताली रखिस। ");
INSERT INTO hne_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जब लिआ देखिस कि अब ओकर लइका नइं होवथे, त ओह अपन दासी जिलपा ला याकूब के घरवाली होय बर दीस। ");
INSERT INTO hne_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","अऊ लिआ के दासी जिलपा ले याकूब के एक बेटा होईस। ");
INSERT INTO hne_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","तब लिआ ह कहिस, “कतेक बढ़िया किस्मत!” त ओह ओकर नांव गाद रखिस। ");
INSERT INTO hne_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","लिआ के दासी जिलपा के याकूब ले एक अऊ बेटा होईस। ");
INSERT INTO hne_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","तब लिआ ह कहिस, “में बहुंत खुस हंव! माईलोगनमन मोला धइन कहिहीं।” त ओह ओकर नांव आसेर रखिस। ");
INSERT INTO hne_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गहूं लुवई के समय, रूबेन ला मैदान म कुछू दूदा फर मिलिस, जेला ओह अपन दाई लिआ करा ले गीस। तब राहेल ह लिआ ला कहिस, “तोर बेटा के दूदा फर म ले कुछू महूं ला दे।” ");
INSERT INTO hne_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","पर लिआ ह ओला कहिस, “तेंह जो मोर घरवाला ला लेय ले हस; का येह छोटे बात अय? अऊ अब मोर बेटा के दूदा फर ला घलो लेय चाहत हस?” राहेल ह कहिस, “ठीक हे, तोर बेटा के दूदा फर के बदला म, आज रथिया हमर घरवाला ह तोर करा सुतही।” ");
INSERT INTO hne_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","सांझकुन जब याकूब ह खेत ले आईस, त लिआ ह ओकर ले भेंट करे बर गीस अऊ ओला कहिस, “तोला मोर करा आय बर पड़ही, काबरकि मेंह अपन बेटा के दूदा फर के बदला म तोला लेय ले हंव।” त याकूब ह ओ रथिया ओकर संग सुतिस। ");
INSERT INTO hne_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","परमेसर ह लिआ के सुनिस, अऊ ओह आसरा म होके याकूब बर पांचवां बेटा जनमिस। ");
INSERT INTO hne_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","तब लिआ ह कहिस, “में जो अपन दासी ला अपन घरवाला ला देंव, एकरे बर परमेसर ह मोला ईनाम दे हवय।” त ओह ओकर नांव इस्साकार रखिस। ");
INSERT INTO hne_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लिआ फेर आसरा म होईस अऊ याकूब ले ओकर छठवां बेटा जनमिस। ");
INSERT INTO hne_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","तब लिआ ह कहिस, “परमेसर ह मोला बढ़िया ईनाम दे हवय। अब के बार मोर आदमी मोर संग आदर के बरताव करही, काबरकि मेंह ओकर दुवारा छै बेटा जनमे हंव।” त ओह ओकर नांव जबूलून रखिस। ");
INSERT INTO hne_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","कुछू समय के बाद, ओकर एक झन बेटी घलो होईस अऊ ओह ओकर नांव दीना रखिस। ");
INSERT INTO hne_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","तब परमेसर ह राहेल के घलो सुधि लीस; ओह ओकर गरभ ठहिरे के आसीस दीस। ");
INSERT INTO hne_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ओह आसरा म होईस अऊ एक बेटा जनमिस अऊ कहिस, “परमेसर ह मोर बेजत्ती ला दूर करे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ओह ये कहिके अपन बेटा के नांव यूसुफ रखिस, “यहोवा मोला एक अऊ बेटा देवय।” ");
INSERT INTO hne_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","जब राहेल ह यूसुफ ला जनमिस, त याकूब ह लाबान ला कहिस, “मोला बिदा कर कि में अपन देस वापिस जा सकंव। ");
INSERT INTO hne_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मोर घरवाली अऊ मोर लइकामन ला मोला दे, जेमन बर में तोर सेवा करे हंव ताकि में इहां ले चले जावंव। तें तो जानत हस कि मेंह तोर कतेक सेवा करे हंव।” ");
INSERT INTO hne_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","पर लाबान ह ओला कहिस, “यदि तोर नजर म में दया पाय के लईक हंव, त रूक जा। काबरकि मेंह अनुभव ले जान डारे हंव कि यहोवा ह तोर कारन से मोला आसीस दे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","फेर ओह कहिस, “तें अपन बनी बता अऊ में तोला तोर बनी दूहूं।” ");
INSERT INTO hne_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकूब ह ओला कहिस, “तेंह जानत हस कि मेंह तोर कइसन सेवा करे हंव अऊ तोर पसुमन मोर देखरेख म कइसन बढ़िन हें। ");
INSERT INTO hne_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","मोर आय के पहिली ओमन थोरकन रिहिन, अऊ अब कतेक बढ़ गे हवंय, अऊ जिहां कहूं मेंह हांथ लगांय, यहोवा ह तोला अब्बड़ आसीस दीस। पर अब, में अपन परिवार बर कब कुछू करहूं?” ");
INSERT INTO hne_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ओह पुछिस, “में तोला का देवंव?” याकूब ह कहिस, “तें मोला कुछू झन दे; पर यदि तें मोर बर एक काम करबे, त में फेर तोर भेड़-बकरी ला चराहूं अऊ ओमन के देखरेख करहूं: ");
INSERT INTO hne_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","मोला आज तोर जम्मो भेड़-बकरी के बीच म ले होके जावन दे, अऊ जऊन भेड़मन धारीवाले या चितकबरी हवंय, अऊ जऊन मेढ़ामन करिया हवंय अऊ जऊन छेरीमन धारीवाले अऊ चितकबरी हवंय, ओमन ला अलग करन दे। ओमन मोर मजदूरी होहीं। ");
INSERT INTO hne_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","अऊ अवइया समय म मोर ईमानदारी के सबूत ये होही कि जऊन मजदूरी तेंह मोला दे हस; जब तें ओकर जांच करबे; त यदि कोनो बकरी धारीवाले या चितकबरी नइं होही या कोनो मेढ़ा-पीला करिया रंग के नइं होही, त ओह चोरी के समझे जाही।” ");
INSERT INTO hne_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबान ह कहिस, “में राजी हंव। तोर कहे के मुताबिक होवय।” ");
INSERT INTO hne_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ओहीच दिन ओह जम्मो धारीवाले अऊ धब्बावाले बोकरा, अऊ जम्मो धारीवाली अऊ धब्बावाली बकरी (सफेद धब्बावाली) अऊ जम्मो करिया मेढ़ा-पीलामन ला अलग करके अपन बेटामन के देखरेख म कर दीस। ");
INSERT INTO hne_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","तब ओह अपन अऊ याकूब के बीच म तीन दिन के यातरा के दूरी बना लीस, अऊ याकूब ह लाबान के बाकि भेड़-बकरीमन ला चराय लगिस। ");
INSERT INTO hne_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","तब याकूब ह चिनार, बादाम, अऊ अरमोन रूख के हरियर-हरियर छड़ी लेके ओकर छिलका ला जगह-जगह छिलके धारीदार बना दीस, जेकर से ओ छड़ीमन के सफेदी ह दिखे लगिस। ");
INSERT INTO hne_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","तब छिलाय छड़ीमन ला पानी पीये के जम्मो कोटना म अइसे रखिस कि जब भेड़-बकरीमन पानी पीये बर आवंय, त ओमन सीधा भेड़-बकरीमन के आघू म रहंय। जब भेड़-बकरीमन गाभिन होय के समय पानी पीये बर आईन, ");
INSERT INTO hne_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","त ओमन छड़ीमन के आघू म समागम करिन अऊ गाभिन होके भेड़-बकरीमन धारीवाला या चित्तीवाला या चितकबरा पीला जनमे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकूब ह मेढ़ा-पीलामन ला अलग-अलग करिस, पर बाकि बचे भेड़-बकरीमन के मुहूं ला लाबान के चित्तीवाले अऊ करिया भेड़-बकरीमन कोति कर दीस। ये किसम ले ओह अपन भेड़-बकरीमन के अलग झुंड बनाईस अऊ ओमन ला लाबान के भेड़-बकरीमन संग मिले नइं दीस। ");
INSERT INTO hne_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","जब भी मजबूत भेड़-बकरीमन के गाभिन होय के समय होवय, त याकूब ह ओ छड़ीमन ला कोटना म ओमन के आघू म ठाढ़ कर देवय, जेकर से ओमन छड़ीमन के लकठा म गाभिन होवंय, ");
INSERT INTO hne_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","पर जब कमजोर भेड़-बकरीमन गाभिन होवंय, त ओह ओमन ला छड़ीमन के आघू म नइं रखय। ये कारन से कमजोर पसुमन लाबान के होईन अऊ मजबूत पसुमन याकूब के हो गीन। ");
INSERT INTO hne_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","अइसन करके याकूब ह भारी धनवान हो गीस। ओकर खुद के अब्बड़ भेड़-बकरी, अऊ दास-दासी, अऊ ऊंट, अऊ गदहामन हो गीन। ");
INSERT INTO hne_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","लाबान के बेटामन के ये बात याकूब के सुने म आईस, “याकूब ह हमर ददा के जम्मो चीज ला लेय ले हे, अऊ हमर ददा के धन के कारन ओह ये जम्मो धन-संपत्ति कमाय हे।” ");
INSERT INTO hne_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","अऊ याकूब ह धियान दीस कि लाबान के बरताव ह ओकर बर पहिले सहीं नइं ए। ");
INSERT INTO hne_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","तब यहोवा ह याकूब ला कहिस, “तेंह अपन पुरखा अऊ अपन रिस्तेदारमन के देस म लहुंट जा, अऊ मेंह तोर संग रहिहूं।” ");
INSERT INTO hne_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","एकरसेति याकूब ह राहेल अऊ लिआ ला बाहिर मैदान म आय बर खबर भिजवाईस जिहां ओकर भेड़-बकरीमन रहंय। ");
INSERT INTO hne_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ओह ओमन ला कहिस, “में देखत हंव कि तुम्हर ददा के बरताव ह मोर बर पहिले सहीं नइं ए, पर मोर ददा के परमेसर ह मोर संग हवय। ");
INSERT INTO hne_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","तुमन जानत हव कि में तुम्हर ददा के सेवा पूरा मेहनत से करे हंव, ");
INSERT INTO hne_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","तभो ले तुम्हर ददा ह दस बार मोर बनी ला बदलके मोर ले छल-कपट करिस। पर परमेसर ह ओला मोर हानि करे बर नइं दीस। ");
INSERT INTO hne_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","जब ओह कहिस, ‘चित्तीवाला बोकरामन तोर मजदूरी होहीं,’ त जम्मो भेड़-बकरीमन चित्तीवाला जनमे लगिन; अऊ जब ओह कहिस, ‘धारीवालामन तोर मजदूरी होहीं,’ त जम्मो भेड़-बकरीमन धारीवाला जनमे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","अइसन करके परमेसर ह तोर ददा के पसुमन ला लेके मोला दे हवय। ");
INSERT INTO hne_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“भेड़-बकरी के गाभिन होय के समय म एक बार मेंह सपना म देखेंव कि जऊन बोकरामन बकरी ऊपर चघत हवंय, ओमन धारीवाला, चित्तीवाला या चितकबरा हवंय। ");
INSERT INTO hne_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","तब परमेसर के स्वरगदूत ह सपना म मोला कहिस, ‘हे याकूब।’ में कहेंव, ‘में इहां हंव।’ ");
INSERT INTO hne_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","अऊ ओह कहिस, ‘आंखी उठाके देख कि ओ जम्मो बोकरा, जेमन बकरीमन ऊपर चघत हवंय, ओमन धारीवाला, चित्तीवाला या चितकबरा हवंय, काबरकि में ओ जम्मो चीज ला देखे हवंव, जऊन ला लाबान तोर संग करत हवय। ");
INSERT INTO hne_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","में ओ बेतेल के परमेसर अंव, जिहां तें एक खंभा के अभिसेक करे रहय, अऊ मोर मन्नत माने रहय। अब तें ये देस ला तुरते छोंड़ अऊ अपन जनम भुइयां ला लहुंट जा।’ ” ");
INSERT INTO hne_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","तब राहेल अऊ लिआ कहिन, “का हमर ददा के संपत्ति म अब भी हमर कुछू बांटा या हिस्सा बांचे हवय? ");
INSERT INTO hne_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","का ओह हमन ला परदेसी नइं समझत हे? ओह सिरिप हमन ला बेचे ही नइं ए, पर हमर बदले दिये गय रूपिया ला खा डारिस हे। ");
INSERT INTO hne_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","सही म, ओ जम्मो धन जऊन ला परमेसर ह हमर ददा ले लेय लीस, ओ हमर अऊ हमर लइकामन के अय। एकरसेति जइसन परमेसर ह तोला कहे हवय, वइसने कर।” ");
INSERT INTO hne_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","तब याकूब ह अपन लइका अऊ घरवालीमन ला ऊंट म चघाईस, ");
INSERT INTO hne_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","अऊ जतेक पसु अऊ सामान ओह पदन-अराम म कमाय रिहिस, ओ जम्मो ला अपन आघू म रवाना करके, अपन ददा इसहाक करा कनान देस जाय बर निकलिस। ");
INSERT INTO hne_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","जब लाबान ह अपन भेड़मन के ऊन कतरे बर गे रिहिस, त राहेल ह अपन ददा के घर-देवतामन ला चोरा लीस। ");
INSERT INTO hne_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","याकूब ह लाबान अरामी करा ले चोरी से चले गीस; ओला नइं बताईस कि ओह भागके जावत हे। ");
INSERT INTO hne_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ओह अपन जम्मो कुछू ला लेके भागिस, अऊ फरात नदी ला पार करके गिलाद के पहाड़ी देस कोति गीस। ");
INSERT INTO hne_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीसर दिन लाबान ला खबर मिलिस कि याकूब ह भाग गे हवय। ");
INSERT INTO hne_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","अपन रिस्तेदारमन ला लेके, ओह सात दिन तक याकूब के पीछा करिस अऊ गिलाद के पहाड़ी देस म ओकर करा हबरिस। ");
INSERT INTO hne_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","पर परमेसर ह रथिया सपना म आके अरामी लाबान ला कहिस, “सावधान रह! तें याकूब ला न तो भला कहिबे, न बुरा।” ");
INSERT INTO hne_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","जब लाबान ह याकूब करा हबरिस, तब याकूब ह गिलाद के पहाड़ी देस म अपन तम्बू गाड़े रिहिस, अऊ लाबान ह घलो अपन रिस्तेदारमन संग उहां अपन तम्बू गाड़िस। ");
INSERT INTO hne_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","तब लाबान ह याकूब ला कहिस, “तेंह ये का करे हस? तेंह मोला धोखा दे हस, अऊ मोर बेटीमन ला अइसने लाने हस, जइसने लड़ई के समय दूसरमन ला बंदी बनाके लानथें। ");
INSERT INTO hne_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","तेंह काबर चुपेचाप भागके मोला धोखा देय? तेंह मोला काबर नइं बताय, नइं तो में तोला आनंद के संग गावत अऊ मिरदंग अऊ बीना बजावत बिदा करे रहितेंव? ");
INSERT INTO hne_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तेंह तो मोला अपन नाती-नतनीन अऊ बेटीमन ला चूमे तक नइं देय? तेंह गंवारी करे हस। ");
INSERT INTO hne_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","तोला नुकसान पहुंचाय के ताकत मोर करा हवय, पर बीते रथिया, तोर ददा के परमेसर ह मोला कहिसे, ‘सावधान रह! तें याकूब ला न तो भला कहिबे, न बुरा।’ ");
INSERT INTO hne_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","तें अपन ददा के घर के मोह के कारन चले आय। पर तें मोर देवतामन ला काबर चोराके ले आने हस?” ");
INSERT INTO hne_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकूब ह लाबान ला जबाब दीस, “में ये सोचके डरा गे रहेंव कि कहूं तें अपन बेटीमन ला मोर ले जबरदस्ती झन छीन ले। ");
INSERT INTO hne_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","पर जेकर मेर तें अपन देवतामन ला पाबे, ओ जीयत नइं बांचय। मोर रिस्तेदारमन के आघू म, तें खुद देख ले, कहूं तोर कोनो चीज मोर करा हवय त; यदि हवय, त ओला लेय ले।” याकूब ह नइं जानत रिहिस कि राहेल ह देवतामन ला चोराके ले आने हे। ");
INSERT INTO hne_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","एकरसेति लाबान ह याकूब के तम्बू अऊ लिआ के तम्बू अऊ दू झन दासीमन के तम्बूमन म गीस, पर ओला कुछू नइं मिलिस। लिआ के तम्बू म ले निकलके, ओह राहेल के तम्बू म गीस। ");
INSERT INTO hne_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल ह घर-देवतामन ला लेके अपन ऊंट के काठी के भीतर म रखे रिहिस अऊ ओकर ऊपर बईठ गे रिहिस। लाबान ह ओकर जम्मो तम्बू म खोजिस पर ओला कुछू नइं मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राहेल ह अपन ददा ला कहिस, “हे मोर परभू, गुस्सा झन कर कि में तोर आघू म ठाढ़ नइं हो सकेंव; काबरकि मोला माहवारी होवत हे।” ओह खोजिस पर ओला घर-देवतामन नइं मिलिन। ");
INSERT INTO hne_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तब याकूब ह गुस्सा होके लाबान ले बिबाद करे लगिस अऊ लाबान ले पुछिस, “मोर का दोस ए?” में तोर का गलत करे हंव कि तें मोर पीछा करत आय हस? ");
INSERT INTO hne_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","तें मोर जम्मो सामान ला खोजके देख डारे; इहां तोला अपन घर के सामान म ले का चीज मिलिस? कुछू पाय हस, त ओला तोर अऊ मोर रिस्तेदारमन के आघू म रख, अऊ ओमन ला हमन दूनों के नियाय करन दे। ");
INSERT INTO hne_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“मेंह तोर संग बीस बछर तक रहेंव; अऊ ये दौरान न तो तोर भेड़-बकरीमन के गरभ गिरिस, न कभू में तोर झुंड के मेढ़ा के मांस खायेंव। ");
INSERT INTO hne_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","तोर जऊन पसुमन ला हिंसक पसुमन मार डारिन, ओमन ला में तोर करा नइं लानेंव; ओकर हानि में खुद उठांय। कोनो चीज, चाहे दिन के चोरी जाय या रथिया, तें ओकर भरती मोर ले मांगे। ");
INSERT INTO hne_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मोर तो ये दसा रिहिस: दिन के समय घाम ले अऊ रथिया ठंड के मारे मरत रहेंव, अऊ नींद ह मोर आंखी ले कोसों दूर रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","मेंह ये दसा म तोर घर म बीस बछर तक रहेंव। में चौदह बछर तक तोर दूनों बेटी बर अऊ छै बछर तक तोर भेड़-बकरीमन बर सेवा करेंव, अऊ तें मोर मजदूरी ला दस बार बदले हस। ");
INSERT INTO hne_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","कहूं मोर ददा के परमेसर, याने कि अब्राहम के परमेसर, जेकर भय इसहाक घलो मानथे, कहूं ओह मोर संग नइं होतिस, त खचित तें मोला जुच्छा हांथ पठो दे रहितय। पर परमेसर ह मोर दुख अऊ मोर हांथ के मेहनत ला देखे हवय, अऊ बीते रथिया ओह तोला डांटिस।” ");
INSERT INTO hne_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबान ह याकूब ला कहिस, “ये माईलोगनमन तो मोर बेटी अंय, अऊ ये लइकामन मोर लइका अंय, अऊ ये भेड़-बकरीमन भी मोर अंय। जऊन कुछू तेंह देखत हस, ओ जम्मो मोर अंय। पर अब में मोर ये बेटीमन के का कर सकत हंव, या येमन के दुवारा जनमे लइकामन के का कर सकत हंव? ");
INSERT INTO hne_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","अब आ, हमन एक करार करन, तें अऊ में, अऊ येह हमर बीच म एक गवाही के काम करय।” ");
INSERT INTO hne_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","तब याकूब ह एक पथरा लीस अऊ ओला एक खंभा के रूप म ठाढ़ करिस। ");
INSERT INTO hne_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ओह अपन रिस्तेदारमन ला कहिस, “कुछू पथरा संकेलव।” त ओमन पथरा संकेलके कुढ़ो दीन, अऊ ओही कुढ़ा मेर जेवन करिन। ");
INSERT INTO hne_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ओ कुढ़ा के नांव लाबान ह यजर-सहादुथा, पर याकूब ह गलीद रखिस। ");
INSERT INTO hne_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान ह कहिस, “ये कुढ़ा ह आज तोर अऊ मोर बीच म एक गवाही ए।” एकरसेति ओला गलीद कहे गीस। ");
INSERT INTO hne_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","येला मिसपा घलो कहे गीस, काबरकि ओह कहिस, “जब हमन एक-दूसर ले अलग हो जाबो, त यहोवा के नजर तोर अऊ मोर ऊपर रहय। ");
INSERT INTO hne_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","यदि तें मोर बेटीमन ला दुख देबे या मोर बेटीमन के छोंड़ अऊ कोनो ला घरवाली बना लेबे, हालाकि हमर संग कोनो मनखे नइं ए, त सुरता रख कि परमेसर ह तोर अऊ मोर बीच म गवाह हे।” ");
INSERT INTO hne_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","लाबान ह याकूब ला ये घलो कहिस, “ये कुढ़ा ह इहां हवय, अऊ ये खंभा ला में तोर अऊ मोर बीच म ठाढ़ करे हंव। ");
INSERT INTO hne_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ये कुढ़ा अऊ ये खंभा दूनों ये बात के गवाह रहंय कि तोर नुकसान करे के बिचार ले, न तो में ये कुढ़ा ला नाहकके तोर तरफ आहूं, अऊ न ही मोर नुकसान करे के बिचार ले, तें ये कुढ़ा या खंभा ला नाहकके मोर तरफ आबे। ");
INSERT INTO hne_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहम अऊ नाहोर अऊ ओकर ददा के परमेसर ह हमन दूनों के बीच नियाय करय।” तब याकूब ह अपन ददा इसहाक के भय के नांव म किरिया खाईस। ");
INSERT INTO hne_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","अऊ ओह उहां पहाड़ ऊपर एक बलि चघाईस अऊ अपन रिस्तेदारमन ला जेवन करे बर बलाईस। जेवन करके ओमन उहां रात बिताईन। ");
INSERT INTO hne_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ओकर दूसर दिन बड़े बिहनियां लाबान ह उठके अपन नाती-नतनीन अऊ बेटीमन ला चूमिस अऊ ओमन ला आसीस दीस। तब ओह ओमन ला छोंड़के अपन घर लहुंट गीस। ");
INSERT INTO hne_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकूब ह घलो अपन डहार धरिस, अऊ परमेसर के स्वरगदूतमन ओकर ले मिलिन। ");
INSERT INTO hne_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","जब याकूब ह ओमन ला देखिस, त ओह कहिस, “येह तो परमेसर के डेरा अय!” एकरसेति ओह ओ जगह के नांव महनैम रखिस। ");
INSERT INTO hne_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकूब ह सेईर देस याने कि एदोम के देस म, अपन भईया एसाव करा अपन आघू दूतमन ला पठोईस। ");
INSERT INTO hne_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ओह ओमन ला ये हुकूम दीस, “मोर मालिक एसाव ला तुमन ये कहिहू: ‘तोर दास याकूब ह अइसन कहिथे, मेंह लाबान के संग रहत रहेंव अऊ अब तक उहां रहेंव। ");
INSERT INTO hne_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","मोर करा गरूवा-बईला अऊ गदहा, भेंड़-बकरी, अऊ दास-दासीमन हवंय। में अपन परभू करा एकर खातिर खबर पठोत हंव कि तोर दया-मया मोर ऊपर होवय।’ ” ");
INSERT INTO hne_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","जब ओ दूतमन याकूब करा लहुंटके आईन, त ओमन कहिन, “हमन तोर भईया एसाव करा गे रहेंन, अऊ ओह तोर करा भेंट करे बर आवत हे, अऊ चार सौ मनखे ओकर संग आवत हंय।” ");
INSERT INTO hne_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","याकूब ह अब्बड़ डरा गीस अऊ चिंतित होके ओह अपन मनखेमन ला दू ठन दल म बांट दीस, अऊ वइसने गरूवा-बईला, भेड़-बकरी अऊ ऊंटमन ला घलो दू ठन दल म बांट दीस। ");
INSERT INTO hne_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ओह सोचिस, “यदि एसाव ह आके एक दल ला मारही, त सायद दूसर दल ह बांच जाही।” ");
INSERT INTO hne_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","तब याकूब ह पराथना करिस, “हे मोर दादा अब्राहम के परमेसर, मोर ददा इसहाक के परमेसर, यहोवा, तेंह तो मोला कहे रहय, ‘अपन देस अऊ अपन रिस्तेदारमन करा लहुंट जा, अऊ मेंह तोला बढ़ाहूं,’ ");
INSERT INTO hne_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तेंह ओ जम्मो दया अऊ किरपा मोर ऊपर करे हस, में ओकर लईक नो हंव। जब में ये यरदन नदी ला पार करेंव, त मोर करा सिरिप मोर छड़ी रिहिस, पर अब मोर करा दू ठन दल हवय। ");
INSERT INTO hne_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","में बिनती करत हंव कि मोला मोर भईया एसाव के हांथ ले बंचा, काबरकि मोला डर हवय कि ओह आके मोर ऊपर, अऊ लइकामन सहित दाईमन ऊपर घलो हमला करही। ");
INSERT INTO hne_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","पर तेंह कहे रहय, ‘मेंह सही म तोला बढ़ाहूं अऊ तोर संतान ला समुंदर के बालू के सहीं करहूं, जऊन ला गने नइं जा सकय।’ ” ");
INSERT INTO hne_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ओह ओ रथिया उहां काटिस, अऊ जऊन कुछू ओकर करा रिहिस, ओमा ले ओह अपन भईया एसाव ला देय बर ये भेंट ला छांटके निकालिस: ");
INSERT INTO hne_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","याने कि दू सौ बकरी अऊ बीस ठन बोकरा, दू सौ भेड़ी अऊ बीस ठन मेढ़ा, ");
INSERT INTO hne_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","तीस ठन माई ऊंट ओमन के पीला सहित, चालीस ठन गाय अऊ दस ठन बईला, अऊ बीस ठन गदही अऊ दस ठन गदहा। ");
INSERT INTO hne_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ओह येमन ला दल-दल करके अपन दासमन ला सऊंप दीस अऊ ओमन ला कहिस, “मोर आघू-आघू चलव, अऊ हर एक दल के बीच म कुछू जगह रखव।” ");
INSERT INTO hne_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","जऊन ह सबले आघू के दल म रिहिस, ओला ओह ये हुकूम दीस: “जब मोर भईया एसाव तोर ले मिलही अऊ पुछही, ‘तें काकर दास अस, अऊ कहां जावत हस, अऊ तोर आघू म ये जो जम्मो जानवर जावत हंय, ओमन काकर अंय?’ ");
INSERT INTO hne_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तब तें ये कहिबे, ‘येमन तोर दास याकूब के अंय। हे मोर मालिक एसाव, येमन तोर बर एक भेंट के रूप म भेजे गे हवंय, अऊ ओह खुद हमर पाछू-पाछू आवत हवय।’ ” ");
INSERT INTO hne_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","याकूब ह दूसर, तीसर अऊ ओ जम्मो झन ला घलो ये हुकूम दीस, जेमन जानवर के दलमन के पाछू-पाछू चलत रिहिन: “जब तुमन एसाव ले मिलहू, त तुमन घलो अइसनेच कहिहू। ");
INSERT INTO hne_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","अऊ ये जरूर कहिहू, ‘तोर दास याकूब ह हमर पाछू-पाछू आवत हे।’ ” काबरकि ओह ये सोचिस, “ये भेंटमन ला आघू भेजके, मेंह ओकर गुस्सा ला सांत कर लूहूं; अऊ बाद म, जब में ओकर ले मिलहूं, त सायद ओह मोला स्वीकार कर ले।” ");
INSERT INTO hne_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","एकरसेति याकूब के मनखेमन भेंट ला आघू लेके गीन, पर ओह खुद डेरा म ओ रथिया काटिस। ");
INSERT INTO hne_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ओ रथिया याकूब उठिस अऊ अपन दूनों घरवाली, अपन दूनों दासी अऊ अपन गियारह बेटामन ला लीस अऊ यब्बोक नदी के घाट के ओ पार हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ओह ओमन ला नदी नहकाय के बाद, अपन जम्मो चीज ला घलो ओ पार भेजवा दीस। ");
INSERT INTO hne_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","याकूब ह एके झन उहां रह गीस, अऊ एक मनखे ह आके बिहान पहात तक ओकर संग कुस्ती लड़िस। ");
INSERT INTO hne_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","जब ओ मनखे ह देखिस कि ओह याकूब ला नइं जीत सकत हे, त ओह याकूब के जांघ के हाड़ा के जोड़ ला छुईस, तब कुस्ती लड़त याकूब के जांघ के हाड़ा ह चढ़ गीस। ");
INSERT INTO hne_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","तब ओ मनखे ह कहिस, “मोला जावन दे, काबरकि बिहान पहा गे हवय।” पर याकूब ह कहिस, “जब तक तें मोला आसीस नइं देबे, तब तक में तोला जावन नइं दंव।” ");
INSERT INTO hne_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ओ मनखे ह ओकर ले पुछिस, “तोर का नांव ए?” ओह जबाब दीस, “याकूब।” ");
INSERT INTO hne_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","तब ओ मनखे ह कहिस, “तोर नांव अब याकूब नइं, पर इसरायल होही, काबरकि तें परमेसर अऊ मनखेमन संग कुस्ती लड़े हस अऊ जीते हस।” ");
INSERT INTO hne_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","याकूब ह कहिस, “किरपा करके मोला अपन नांव बता।” पर ओह कहिस, “तेंह मोर नांव काबर पुछत हस?” तब ओह ओला उहां आसीरबाद दीस। ");
INSERT INTO hne_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","एकरसेति याकूब ह ये कहिके ओ जगह के नांव पनिएल रखिस, “परमेसर ला आमने-सामने देखके घलो मोर परान ह बांच गीस।” ");
INSERT INTO hne_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","जब ओह पनिएल ले जावत रिहिस, तब बेर निकल गे रिहिस, अऊ ओह जांघ के हाड़ा के कारन खोरवात रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","एकरसेति आज घलो इसरायलीमन जांघ के हाड़ा ला जोड़नेवाला नस ला नइं खावंय, काबरकि ओ मनखे ह याकूब के जांघ के जोड़ के नस के लकठा ला छुये रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकूब ह नजर उठाके देखिस कि एसाव चार सौ मनखेमन संग चले आवत हे; एकरसेति ओह लइकामन ला लिआ, राहेल अऊ दूनों दासीमन के बीच म बांट दीस। ");
INSERT INTO hne_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ओह सबले आघू म दूनों दासी अऊ ओमन के लइकामन ला, ओकर बाद लिआ अऊ ओकर लइकामन ला, अऊ सब के पाछू म राहेल अऊ यूसुफ ला रखिस। ");
INSERT INTO hne_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ओह खुद आघू-आघू चलिस अऊ जब ओह अपन भईया करा हबरिस, त सात बार भुइयां म गिरके दंडवत करिस। ");
INSERT INTO hne_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","पर एसाव ह याकूब संग भेंट करे बर दऊड़िस अऊ ओला छाती ले लगा लीस; ओह ओला बाहां म पोटारके चूमिस। अऊ ओ दूनों रोईन। ");
INSERT INTO hne_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","तब एसाव ह माईलोगन अऊ लइकामन ला देखिस अऊ पुछिस, “तोर संग येमन कोन अंय?” याकूब ह जबाब दीस, “येमन तोर सेवक के लइकामन अंय, जेमन ला परमेसर ह अनुग्रह करके दे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","तब दासी अऊ ओमन के लइकामन हबरिन अऊ आके दंडवत करिन। ");
INSERT INTO hne_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","फेर लिआ अऊ ओकर लइकामन आईन अऊ दंडवत करिन। सबले आखिरी म यूसुफ अऊ राहेल आईन, अऊ ओमन घलो दंडवत करिन। ");
INSERT INTO hne_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसाव ह पुछिस, “ये जो गाय-बईला अऊ भेड़-बकरी के दलमन रसता म मोला मिलिन, एकर का मतलब ए?” ओह कहिस, “हे मोर मालिक, ये जम्मो चीज एकरसेति अय कि तोर दया मोर ऊपर होवय।” ");
INSERT INTO hne_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","पर एसाव ह कहिस, “हे मोर भाई, मोर करा पहिले ही बहुंत हवय। जऊन कुछू तोर करा हवय, ओह तोरेच रहय।” ");
INSERT INTO hne_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकूब ह कहिस, “नइं, नइं! यदि तोर दया मोर ऊपर हवय, त मोर ये भेंट ला गरहन कर। काबरकि तोर चेहरा देखई ह परमेसर के चेहरा देखे सहीं अय, अऊ तेंह मोला खुसी से गरहन करे हस। ");
INSERT INTO hne_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","तोर करा जऊन भेंट लाय गे हे, ओला गरहन कर, काबरकि परमेसर ह मोर ऊपर अनुग्रह करे हवय अऊ मोर करा मोर जरूरत के जम्मो चीज हवय।” अऊ जब याकूब ह बहुंत बिनती करिस, त एसाव ह ओ भेंट ला गरहन कर लीस। ");
INSERT INTO hne_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","फेर एसाव ह कहिस, “आ, अब हमन चलन; में तोर संग चलहूं।” ");
INSERT INTO hne_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","पर याकूब ह ओला कहिस, “हे मोर मालिक, तेंह जानत हस कि मोर संग नान-नान लइकामन हवंय अऊ ओ भेड़ अऊ गायमन के देखभाल करना जरूरी ए, जऊन मन अपन लइकामन ला दूध पीयावत हें। यदि येमन एक दिन भी जादा खेदे जाहीं, त जम्मो के जम्मो पसु मर जाहीं। ");
INSERT INTO hne_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","एकरसेति मोर मालिक ह अपन सेवक के आघू चलय, अऊ मेंह ये पसु जऊन मन मोर आघू म रेंगत हवंय, ओमन के मुताबिक अऊ लइकामन के रेंगई के मुताबिक धीरे-धीरे चलहूं, अऊ सेईर म अपन मालिक करा हबरहूं।” ");
INSERT INTO hne_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","एसाव ह कहिस, “त मोर कुछू मनखेमन ला तोर संग छोंड़ देवत हंव।” याकूब ह कहिस, “पर अइसने काबर करबे? सिरिप मोर मालिक के दया मोर ऊपर बने रहय, अतकेच ह बहुंत ए।” ");
INSERT INTO hne_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","तब एसाव ह ओही दिन वापिस सेईर जाय बर निकलिस। ");
INSERT INTO hne_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","पर याकूब ह उहां ले सुक्कोत गीस, अऊ उहां अपन बर एक घर अऊ अपन पसुमन बर कोठा बनाईस। एकरसेति ओ जगह के नांव सुक्कोत परिस। ");
INSERT INTO hne_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","याकूब ह पदन-अराम ले आय के बाद, कनान के सकेम सहर म सही-सलामत हबरिस अऊ सहर के लकठा म अपन डेरा ठाढ़ करिस। ");
INSERT INTO hne_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","भुइयां के जऊन भाग म, ओह तम्बू गाड़े रिहिस, ओला ओह सकेम के ददा, हमोर के बेटामन के हांथ ले एक सौ चांदी के टुकड़ा म बिसाय रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","उहां ओह एक बेदी बनाईस अऊ ओकर नांव एल-एलोहे-इसरायल रखिस। ");
INSERT INTO hne_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","एक दिन लिआ के बेटी, दीना जेह याकूब ले जनमे रिहिस, ओ देस के छोकरीमन संग भेंट करे बर निकलिस। ");
INSERT INTO hne_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","जब ओ इलाका के हाकिम, हिब्बी हमोर के बेटा सकेम ह ओला देखिस, त ओह ओला ले जाके ओकर संग कुकरम करिस। ");
INSERT INTO hne_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ओकर दिल ह याकूब के बेटी दीना म लग गीस; ओह ओ जवान छोकरी ले मया करिस अऊ ओकर ले गुरतूर बात करिस। ");
INSERT INTO hne_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","अऊ सकेम ह अपन ददा हमोर ला कहिस, “ये छोकरी ला मोर घरवाली के रूप म लान दे।” ");
INSERT INTO hne_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","जब याकूब ह सुनिस कि ओकर बेटी दीना ह असुध हो गे हे; त ओ समय ओकर बेटामन ओकर पसुमन संग मैदान म रिहिन; एकरसेति ओह ओमन के घर आवत तक, एकर बारे म कुछू नइं करिस। ");
INSERT INTO hne_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","तब सकेम के ददा हमोर ह निकलके याकूब करा बातचीत करे बर आईस। ");
INSERT INTO hne_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","इही बीच म, जइसने ही याकूब के बेटामन ये बात ला सुनिन, त ओमन मैदान ले घर आ गीन। ओमन ला ये बात ला सुनके धक्का लगिस अऊ ओमन बहुंत गुस्सा हो गीन, काबरकि सकेम ह याकूब के बेटी संग कुकरम करके इसरायल के घराना ले गंवारी के काम करे रिहिस—एक अइसने काम, जेला नइं करना रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","पर हमोर ह ओमन ला कहिस, “मोर बेटा सकेम ह तोर बेटी ऊपर दिल लगा बईठे हे। किरपा करके अपन बेटी ला मोर बेटा के घरवाली के रूप म देय दे। ");
INSERT INTO hne_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","हमर संग सादी-बिहाव करव; अपन बेटीमन ला हमन ला दव अऊ हमर बेटीमन ला अपन बर लव। ");
INSERT INTO hne_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","तुमन हमर बीच म रह सकत हव; ये देस ह तुम्हर बर खुला हवय। इहां रहव; काम-धंधा करव, अऊ अपन बर इहां संपत्ति बनावव।” ");
INSERT INTO hne_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","तब सकेम ह दीना के ददा अऊ भाईमन ला कहिस, “मोर ऊपर तुमन दया करव, अऊ जऊन कुछू भी तुमन बोलहू, मेंह दूहूं। ");
INSERT INTO hne_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","दुलहिन के जो भी दाम बोलहू, मेंह दूहूं अऊ जतेक बड़े भेंट तुमन पसंद करव, मेंह लानहूं, अऊ जऊन कुछू घलो कहव, मेंह दूहूं। पर ओ जवान छोकरी ला मोर घरवाली होय बर मोला दव।” ");
INSERT INTO hne_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","काबरकि ओमन के बहिनी दीना ह असुध हो गे रिहिस, याकूब के बेटामन सकेम अऊ ओकर ददा हमोर ला छल करके जबाब दीन। ");
INSERT INTO hne_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ओमन कहिन, “हमन अइसन काम नइं कर सकन; हमन अइसने मनखे ला हमर बहिनी नइं दे सकन, जेकर खतना नइं होय हवय। येह हमर ऊपर एक कलंक होही। ");
INSERT INTO hne_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","हमन तुम्हर संग सिरिप एक सर्त म सहमत होबो अऊ ओ ये अय कि तुम्हर जम्मो पुरूसमन खतना करवाके हमर सहीं हो जावंय। ");
INSERT INTO hne_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","तब हमन अपन बेटीमन ला तुमन ला बिहाव म देबो अऊ तुम्हर बेटीमन ला अपन बर बिहाव म लेबो। हमन तुम्हर बीच म रहिबो अऊ तुम्हर संग एक जात के मनखे हो जाबो। ");
INSERT INTO hne_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","पर यदि तुमन अपन खतना करवाय बर राजी नइं होहू, त हमन अपन बहिनी ला लेके इहां ले चले जाबो।” ");
INSERT INTO hne_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ओमन के ये बात हमोर अऊ ओकर बेटा सकेम ला बने लगिस। ");
INSERT INTO hne_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","सकेम ह अपन ददा के जम्मो घराना म सबले जादा नामी रिहिस, अऊ ओमन के कहे काम ला करे बर ओह देरी नइं करिस, काबरकि ओह याकूब के बेटी ला अब्बड़ चाहत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","एकरसेति हमोर अऊ ओकर बेटा सकेम अपन सहर के कपाट करा जाके सहर के मनखेमन ला अइसने समझाय लगिन, ");
INSERT INTO hne_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ओ मनखेमन हमर संग संगवारी के रूप म रहे चाहथें; ओमन ला हमर देस म रहिके लेन-देन करन देवन; ये देस म ओमन बर बहुंत जगह हवय। हमन ओमन के बेटीमन ले बिहाव कर सकत हन अऊ ओमन हमर बेटीमन ले बिहाव कर सकथें। ");
INSERT INTO hne_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","पर ओमन सिरिप एक सर्त म हमर संग एक मनखे के रूप म रहे बर तियार हवंय, अऊ ओ ये अय कि ओमन के सहीं हमर जम्मो आदमीमन के खतना होवय। ");
INSERT INTO hne_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","का ओमन के भेड़-बकरी, गाय-बईला, ओमन के धन-संपत्ति अऊ ओमन के जम्मो आने पसुमन हमर नइं हो जाहीं? एकरसेति आवव, हमन ओमन के बात ला मान लेवन, त ओमन हमर संग रहिहीं।” ");
INSERT INTO hne_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ओ जम्मो मनखे, जऊन मन सहर के कपाट ले बाहिर निकले रिहिन, ओमन हमोर अऊ ओकर बेटा सकेम के बात ला मान लीन, अऊ सहर म हर आदमी के खतना करे गीस। ");
INSERT INTO hne_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीन दिन के बाद, जब ओ जम्मो झन पीरा म रिहिन, तब सिमोन अऊ लेवी, याकूब के दू झन बेटा, जेमन दीना के भाई रिहिन, अपन-अपन तलवार लेके सहर के मनखेमन के बिगर जानत हमला कर दीन अऊ जम्मो आदमीमन ला मार डारिन। ");
INSERT INTO hne_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ओमन हमोर अऊ ओकर बेटा सकेम ला तलवार ले मार डारिन अऊ दीना ला सकेम के घर ले, ले गीन। ");
INSERT INTO hne_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","याकूब के बेटामन लासमन के ऊपर होवत आईन अऊ ओ सहर ला लूट लीन, जिहां ओमन के बहिनी ला असुध करे गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ओमन भेड़-बकरी अऊ गाय-बईला अऊ गदहा अऊ सहर अऊ मैदान के ओमन के जम्मो चीज ला लूट लीन। ");
INSERT INTO hne_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ओमन उहां के जम्मो संपत्ति अऊ जम्मो माईलोगन अऊ लइकामन ला ले गीन, अऊ उहां के हर घर के सामान ला घलो लूटके ले गीन। ");
INSERT INTO hne_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","तब याकूब ह सिमोन अऊ लेवी ला कहिस, “तुमन ये देस के निवासी कनानी अऊ परिज्जीमन के मन म मोर बर घिन पईदा करे हव, अऊ मोला तुमन संकट म डार दे हव। हमन गनती म थोरकन मनखे हन, अऊ यदि ओमन एक संग आहीं अऊ मोर ऊपर चढ़ई कर दीहीं, त में अऊ मोर घराना नास हो जाही।” ");
INSERT INTO hne_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","पर ओमन कहिन, “का ओला हमर बहिनी संग एक बेस्या के सहीं बरताव करना सही रिहिस?” ");
INSERT INTO hne_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","तब परमेसर ह याकूब ला कहिस, “इहां ले निकलके बेतेल म जा अऊ उहां बस जा, अऊ उहां परमेसर बर एक बेदी बना, जऊन ह तोला ओ समय दरसन दीस, जब तें अपन भाई एसाव ले डरके भागत रहय।” ");
INSERT INTO hne_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","तब याकूब ह अपन घराना अऊ अपन संग के जम्मो झन ला कहिस, “तुमन जऊन पराय देवतामन ला अपन संग रखे हव, ओमन ला निकाल फेंकव, अऊ अपनआप ला सुध करव अऊ अपन कपड़ामन ला बदल डारव। ");
INSERT INTO hne_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","तब आवव, हमन इहां ले निकलके बेतेल जाबो; उहां में परमेसर बर एक ठन बेदी बनाहूं, जऊन ह संकट के दिन म मोर बात सुनिस अऊ जिहां घलो में गेंव, ओह मोर संग म रिहिस।” ");
INSERT INTO hne_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","एकरसेति ओमन अपन जम्मो पराय देवता अऊ अपन कान के कुंडलमन ला याकूब ला दे दीन, अऊ ओह ओ जम्मो ला सकेम म बलूत रूख के खाल्हे म गड़िया दीस। ");
INSERT INTO hne_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","तब ओमन आघू बढ़िन, अऊ ओमन के चारों कोति के नगरमन के निवासी के मन म परमेसर के डर हमा गीस, जेकर कारन कोनो ओमन के पीछा नइं करिन। ");
INSERT INTO hne_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","याकूब अऊ ओकर संग के जम्मो मनखेमन कनान देस के लूज नगर म आईन। लूज ला बेतेल घलो कहे जाथे। ");
INSERT INTO hne_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","उहां ओह एक ठन बेदी बनाईस, अऊ ओ जगह के नांव एल बेतेल रखिस, काबरकि येह ओ जगह रिहिस, जिहां परमेसर ह ओकर करा परगट होईस, जब ओह अपन भईया के डर ले भागत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","रिबका के धाई दबोरा ह मर गीस, अऊ ओला बेतेल के बाहिर बलूत रूख के खाल्हे म माटी दिये गीस। एकरसेति ओ रूख के नांव अल्लोन-बकूत रखे गीस। ");
INSERT INTO hne_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","याकूब के पदन-अराम ले लहुंटे के बाद, परमेसर ह ओला फेर दरसन देके आसीस दीस। ");
INSERT INTO hne_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","परमेसर ह ओला कहिस, “तोर नांव याकूब ए, पर अब ले तोला याकूब नइं कहे जाय; तोर नांव इसरायल होही।” अऊ परमेसर ह ओकर नांव इसरायल रखिस। ");
INSERT INTO hne_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","फेर परमेसर ह ओला कहिस, “में सर्वसक्तिमान परमेसर अंव; तें फूल-फर अऊ गनती म बढ़। तोर ले एक जाति अऊ जातिमन के एक समुदाय बनही, अऊ तोर बंस म राजामन पईदा होहीं। ");
INSERT INTO hne_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","जऊन देस मेंह अब्राहम अऊ इसहाक ला दे रहेंव, ओला में तोला घलो देवत हंव, अऊ तोर पाछू ये देस तोर बंसमन ला घलो दूहूं।” ");
INSERT INTO hne_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","तब परमेसर जिहां याकूब ले बात करत रिहिस, उहां ले ऊपर चल दीस। ");
INSERT INTO hne_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","जऊन जगह म परमेसर ह याकूब ले बात करे रिहिस, उहां याकूब ह पथरा के एक खंभा ठाढ़ करिस, अऊ ओह ओकर ऊपर पेय-बलिदान के चढ़ावा चघाके तेल घलो डारिस। ");
INSERT INTO hne_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","जऊन मेर परमेसर ह याकूब ले बात करिस, ओ जगह के नांव याकूब ह बेतेल रखिस। ");
INSERT INTO hne_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","तब ओमन बेतेल ले आघू बढ़िन। जब ओमन एपराता सहर ले थोरकन दूरिहा म रिहिन, तभे राहेल ला छेवारी होय के बहुंत पीरा होय लगिस। ");
INSERT INTO hne_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","अऊ जब ओला भारी पीरा होय लगिस, तब धाई ह ओला कहिस, “निरास झन हो, काबरकि तोर फेर एक बेटा होय हवय।” ");
INSERT INTO hne_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","राहेल के मरे के घरी आ गीस, पर परान छूटत-छूटत ओह अपन बेटा के नांव बेन-ओनी रखिस। पर ओकर ददा ह ओकर नांव बिनयामीन रखिस। ");
INSERT INTO hne_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ये किसम ले राहेल के मऊत हो गीस अऊ एपराता याने कि बैतलहम के डहार म ओला माटी देय गीस। ");
INSERT INTO hne_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","याकूब ह ओकर कबर ऊपर एक खंभा ठाढ़ करिस, अऊ आज तक ओ खंभा ह राहेल के कबर के चिनहां ए। ");
INSERT INTO hne_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","इसरायल ह फेर आघू बढ़िस अऊ मिग्दल-एदेर के बाहिर अपन तम्बू ठाढ़ करिस। ");
INSERT INTO hne_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","जब इसरायल ह ओ छेत्र म रहत रिहिस, तब एक दिन रूबेन ह जाके अपन ददा के रखैल बिलहा संग कुकरम करिस, अऊ ये बात इसरायल ला पता चल गीस। ");
INSERT INTO hne_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ओमा ले लिआ के बेटा येमन रिहिन: याकूब के बड़े बेटा रूबेन, फेर सिमोन, लेवी, यहूदा, इस्साकार अऊ जबूलून। ");
INSERT INTO hne_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","अऊ राहेल के बेटा येमन रिहिन: यूसुफ अऊ बिनयामीन। ");
INSERT INTO hne_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","अऊ राहेल के दासी बिलहा के बेटा येमन रिहिन: दान अऊ नपताली। ");
INSERT INTO hne_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","अऊ लिआ के दासी जिलपा के बेटा येमन रिहिन: गाद अऊ आसेर। ");
INSERT INTO hne_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","याकूब अपन ददा इसहाक के घर ममरे म आईस, जऊन ह किरयत-अरबा याने कि हेबरोन के लकठा म हवय; ममरे म अब्राहम अऊ इसहाक परदेसी होके रहे रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक के उमर एक सौ अस्सी बछर के होईस। ");
INSERT INTO hne_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","तब ओह आखिरी सांस लीस अऊ मर गीस अऊ डोकरा अऊ पूरा उमर के होके अपन पुरखामन संग जा मिलिस। अऊ ओकर बेटा एसाव अऊ याकूब ओला माटी दीन। ");
INSERT INTO hne_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव जेला एदोम घलो कहे जाथे, ओकर परिवार के बिबरन ये अय। ");
INSERT INTO hne_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसाव ह कनानी माईलोगनमन ले बिहाव करे रिहिस: याने कि हित्ती एलोन के बेटी आदा, अऊ अना के बेटी ओहोलीबामा, जऊन ह हिब्बी सिबोन के नतनीन रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","अऊ ओह इसमायल के बेटी बासमत ले घलो बिहाव करे रिहिस, जऊन ह नबायोत के बहिनी रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","एसाव के घरवाली आदा ह एलीपज ला, अऊ बासमत ह रूएल ला जनम दीस। ");
INSERT INTO hne_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","अऊ ओहोलीबामा ह यूस, यालाम अऊ कोरह ला जनम दीस। एसाव के ये बेटामन कनान देस म पईदा होईन। ");
INSERT INTO hne_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","एसाव ह अपन घरवाली अऊ बेटा-बेटी अऊ घर के जम्मो मनखेमन, अऊ अपन भेड़-बकरी अऊ गाय-बईला अऊ जम्मो दूसर पसुमन अऊ कनान देस म कमाय जम्मो संपत्ति ला लीस, अऊ अपन भाई याकूब करा ले एक-दूसर देस म चल दीस। ");
INSERT INTO hne_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","काबरकि ओमन के धन-संपत्ति अतेक हो गे रिहिस कि ओमन एक संग नइं रहे सकिन; ओमन करा अतेक पसु हो गे रिहिन कि जिहां ओमन रहत रिहिन, उहां ओमन के चारा-पानी के परबंध नइं हो सकत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","एकरसेति एसाव याने कि एदोम ह सेईर नांव के पहाड़ी देस म रहे लगिस। ");
INSERT INTO hne_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेईर नांव के पहाड़ी देस म रहइया एदोमीमन के पुरखा एसाव के बंसावली ये अय। ");
INSERT INTO hne_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसाव के बेटामन के नांव ये अय: एसाव के घरवाली आदा के बेटा एलीपज, अऊ एसाव के घरवाली बासमत के बेटा रूएल। ");
INSERT INTO hne_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलीपज के बेटामन: तेमान, ओमार, सपो, गाताम अऊ कनज। ");
INSERT INTO hne_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसाव के बेटा एलीपज के तिमना नांव के एक रखैल रिहिस, जेह एलीपज कोति ले अमालेक ला जनम दीस। एसाव के घरवाली आदा के नाती येमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रूएल के बेटामन: नहत, जेरह, सम्मा, अऊ मिज्जा। एसाव के घरवाली बासमत के नाती येमन होईन। ");
INSERT INTO hne_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","एसाव के घरवाली ओहोलीबामा, जऊन ह अना के बेटी अऊ सिबोन के नतनीन रिहिस, ओह एसाव कोति ले ये बेटामन ला जनम दीस: यूस, यालाम अऊ कोरह। ");
INSERT INTO hne_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसाव के बंस म येमन मुखिया होईन: एसाव के पहिलांत बेटा एलीपज के बेटामन: मुखियामन—तेमान, ओमार, सपो, कनज, ");
INSERT INTO hne_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम अऊ अमालेक। एलीपज के बंस म ले, एदोम देस म येमन मुखिया होईन अऊ येमन आदा के नाती रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसाव के बेटा रूएल के बेटामन: मुखियामन—नहत, जेरह, सम्मा, मिज्जा। रूएल के बंस म ले, एदोम देस म येमन मुखिया होईन अऊ येमन एसाव के घरवाली बासमत के नाती रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसाव के घरवाली ओहोलीबामा के बेटामन: मुखियामन—यूस, यालाम, कोरह। एसाव के घरवाली ओहोलीबामा, जेह अना के बेटी रिहिस, ओकर बंस म येमन मुखिया होईन। ");
INSERT INTO hne_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","एसाव याने कि एदोम के बेटामन येमन रिहिन, अऊ येमन ओमन के मुखिया रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","सेईर, जऊन ह होरी जाति के रिहिस, ओकर ये बेटामन ओ इलाका म रहत रिहिन: लोतान, सोबाल, सिबोन, अना, ");
INSERT INTO hne_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीसोन, एसेर अऊ दीसान। एदोम देस म, सेईर के येमन ही होरी जाति के मुखिया होईन। ");
INSERT INTO hne_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतान के बेटामन: होरी अऊ होमाम। तिमना ह लोतान के बहिनी रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","सोबाल के बेटामन: आलवान, मानहत, एबाल, सपो अऊ ओनाम। ");
INSERT INTO hne_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोन के बेटामन: अय्या अऊ अना। येह ओही अना अय, जेला सुन्ना जगह म अपन ददा सिबोन के गदहामन ला चरात बेरा गरम पानी के झरना मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अना के लइकामन: अना के दीसोन नांव के बेटा अऊ ओहोलीबामा नांव के बेटी होईस। ");
INSERT INTO hne_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीसोन के बेटामन: हेमदान, एसबान, यितरान अऊ करान। ");
INSERT INTO hne_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेर के बेटामन: बिलहान, जाबान अऊ अकान। ");
INSERT INTO hne_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीसान के बेटामन: ऊस अऊ अरान। ");
INSERT INTO hne_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरी जाति के मुखिया येमन होईन: लोतान, सोबाल, सिबोन, अना, ");
INSERT INTO hne_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीसोन, एसेर, दीसान। ");
INSERT INTO hne_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","कोनो इसरायली राजा के एदोम म राज करे के पहिली, येमन ओ राजा रिहिन, जेमन एदोम म राज करिन: ");
INSERT INTO hne_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बेओर के बेटा बेला ह एदोम के राजा बनिस। ओकर सहर के नांव दिनहाबा रखे गीस। ");
INSERT INTO hne_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला के मरे के बाद, बोसरा के रहइया जेरह के बेटा योबाब ओकर जगह म राजा बनिस। ");
INSERT INTO hne_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब के मरे के बाद, तेमानीमन के देस के हूसाम ओकर जगह म राजा होईस। ");
INSERT INTO hne_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","जब हूसाम ह मर गीस, त बदद के बेटा हदद ह ओकर जगह म राजा होईस: येह ओही अय, जऊन ह मोआब के देस म मिदयानीमन ला हराईस। ओकर सहर के नांव अबीत रखे गीस। ");
INSERT INTO hne_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदद के मरे के बाद, मसरेका नगर के रहइया समला ह ओकर जगह म राजा होईस। ");
INSERT INTO hne_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","जब समला ह मर गीस, त साऊल ह ओकर जगह म राजा होईस, जेह नदी के तीर म बसे रहोबोत नगर के रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","साऊल के मरे के बाद, अकबोर के बेटा बाल-हानान ओकर जगह म राजा होईस। ");
INSERT INTO hne_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अकबोर के बेटा बाल-हानान के मरे के बाद, ओकर जगह म हदद राजा होईस। ओकर सहर के नांव पाऊ रखे गीस, अऊ ओकर घरवाली के नांव महेतबेल रिहिस, जऊन ह मतरेद के बेटी अऊ मे-जाहब के नतनीन रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","अपन कुल अऊ इलाका के मुताबिक एसाव के बंस के मुखियामन के नांव ये रिहिस: तिमना, अलबा, यतेत, ");
INSERT INTO hne_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामा, एला, पीनोन, ");
INSERT INTO hne_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनज, तेमान, मिबसार, ");
INSERT INTO hne_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मगदीएल अऊ ईराम। ");
INSERT INTO hne_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब तो कनान देस म रहत रिहिस, जिहां ओकर ददा रहत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकूब के परिवार के बिबरन ये अय। यूसुफ सतरह बछर के एक जवान रिहिस अऊ अपन भाईमन संग भेड़-बकरी चरात रिहिस; ओकर ये भाईमन ओकर ददा के घरवाली बिलहा अऊ जिलपा के बेटामन रिहिन; अऊ यूसुफ ह अपन भाईमन के खराप काम के खबर अपन ददा ला बताय करय। ");
INSERT INTO hne_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","इसरायल ह यूसुफ ला अपन जम्मो दूसर बेटामन ले जादा मया करय, काबरकि ओह ओकर बुढ़त काल म जनमे रिहिस; अऊ इसरायल ह ओकर बर एक रंग-बिरंगा अंगरखा बनाय रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","जब ओकर भाईमन देखिन कि ओमन के ददा ह ओ जम्मो झन ले जादा यूसुफ ले मया करथे, त ओमन ओकर ले नफरत करे लगिन अऊ ओकर ले ठीक से बात घलो नइं करत रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","यूसुफ ह एक सपना देखिस, अऊ जब ओकर बारे म, ओह अपन भाईमन ला बताईस, त ओमन ओकर ले अऊ नफरत करे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ओह ओमन ला कहिस, “जऊन सपना मेंह देखे हंव, ओला सुनव: ");
INSERT INTO hne_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हमन खेत म अनाज के बीड़ा बांधत रहेंन, त मेंह देखेंव कि मोर बीड़ा ह उठके ठाढ़ हो गीस, जबकि तुम्हर बीड़ामन मोर बीड़ा के चारों कोति जूर गीन अऊ ओला दंडवत करिन।” ");
INSERT INTO hne_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ओकर भाईमन ओला कहिन, “का तेंह हमर ऊपर राज करे के इरादा करत हस? का तेंह सही म हमर ऊपर राज करबे?” यूसुफ के सपना अऊ ओह जऊन कुछू कहिस, ओकर कारन ओमन ओकर ले अऊ जादा नफरत करे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","तब ओह एक ठन अऊ सपना देखिस, अऊ अपन भाईमन ला ये सपना के बारे म घलो बताईस। ओह कहिस, “सुनव, मेंह एक अऊ सपना देखे हंव, अऊ ये बखत सूरज अऊ चंदा अऊ गियारह तारामन मोला दंडवत करत रिहिन।” ");
INSERT INTO hne_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","जब ओह अपन सपना के बारे म अपन भाईमन ला अऊ फेर अपन ददा ला बताईस, त ओकर ददा ह ओला घुड़कके कहिस, “ये का सपना तेंह देखे हस? का सच म, तोर दाई अऊ में अऊ तोर भाईमन आबो अऊ तोर आघू म भुइयां म गिरके तोला दंडवत करबो?” ");
INSERT INTO hne_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ओकर भाईमन ओकर ले जलन करे लगिन, पर ओकर ददा ह ये बात ला अपन मन म रखिस। ");
INSERT INTO hne_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","यूसुफ के भाईमन अपन ददा के भेड़-बकरीमन ला चराय बर सकेम के लकठा म गे रिहिन, ");
INSERT INTO hne_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","तब इसरायल ह यूसुफ ला कहिस, “जइसे कि तेंह जानथस, तोर भाईमन सकेम के लकठा म भेड़-बकरी चरावत हंय। एकरसेति आ, में तोला ओमन करा पठोहूं।” त ओह जबाब दीस, “बने बात ए।” ");
INSERT INTO hne_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","तब इसरायल ह ओला कहिस, “जा अऊ देख कि तोर भाई अऊ भेड़-बकरीमन कइसन हवंय, अऊ आके मोला ओमन के खबर बता।” तब ओह ओला हेबरोन के घाटी म ले पठोईस। जब यूसुफ ह सकेम हबरिस, ");
INSERT INTO hne_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","त एक मनखे ह ओला मैदान म एती-ओती भटकत देखके ओकर ले पुछिस, “तेंह का खोजत हस?” ");
INSERT INTO hne_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ओह कहिस, “मेंह अपन भाईमन ला खोजत हंव। का तें मोला बता सकत हस कि ओमन अपन भेड़-बकरीमन ला कहां चरात हवंय?” ");
INSERT INTO hne_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ओ मनखे ह जबाब दीस, “ओमन इहां ले चल दीन हंय, अऊ मेंह ओमन ला ये कहत सुने हंव, ‘आवव, हमन दोतान जाबो।’ ” एकरसेति यूसुफ अपन भाईमन के पाछू गीस, अऊ ओमन ला दोतान के लकठा म पाईस। ");
INSERT INTO hne_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","एकर पहिली कि ओह अपन भाईमन करा हबरतिस, ओकर भाईमन ओला दूरिहा ले आवत देख डारिन, अऊ ओला मार डारे के उपाय करिन। ");
INSERT INTO hne_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ओमन आपस म कहे लगिन, “देखव, ओ सपना देखइया आवत हे। ");
INSERT INTO hne_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","आवव, हमन ओला मारके कोनो खंचवा म फटिक दन अऊ ये कहन कि कोनो हिंसक पसु ओला मारके खा लीस। तब हमन देखबो कि ओकर सपना के का होथे।” ");
INSERT INTO hne_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","जब रूबेन ह ये बात ला सुनिस, त ओह ओला ओमन के हांथ ले बंचाय के बिचार करिस अऊ कहिस, “हमन ओकर परान नइं लेवन; ");
INSERT INTO hne_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","लहू झन बहावव। ओला इहां सुन्ना जगह के ये खंचवा म फटिक दव, पर ओकर ऊपर हांथ झन उठावव।” रूबेन ह ओला ओमन के हांथ ले बचाके अपन ददा करा वापिस लाने चाहत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","एकरसेति जब यूसुफ अपन भाईमन करा हबरिस, तब ओमन ओकर रंग-बिरंगा अंगरखा ला उतार लीन, जेला ओह पहिरे रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","अऊ ओमन ओला लेके खंचवा म फटिक दीन; ओ खंचवा ह खाली रिहिस अऊ ओमा पानी नइं रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","जब ओमन रोटी खाय बर बईठिन, त देखिन कि इसमायलीमन के एक दल ह गिलाद ले आवत रहय। ओमन के ऊंटमन ऊपर मसाला, मलहम अऊ गंधरस लदाय रहय, अऊ ओमन ओला लेके मिसर देस जावत रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","तब यहूदा ह अपन भाईमन ला कहिस, “अपन भाई ला मारके ओकर खून ला छुपाय ले हमन ला का फायदा होही? ");
INSERT INTO hne_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","आवव, हमन ओला इसमायलीमन के हांथ म बेच देवन अऊ अपन हांथ ओकर ऊपर झन उठावन; काबरकि ओह हमर भाई, हमर अपन मांस अऊ खून अय।” अऊ ओकर भाईमन ओकर बात ला मान लीन। ");
INSERT INTO hne_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","एकरसेति जब मिदयानी बेपारीमन ओमन के लकठा म हबरिन, त यूसुफ के भाईमन ओला खंचवा ले बाहिर निकालिन अऊ इसमायलीमन के हांथ म चांदी के बीस सेकेल म बेच दीन, अऊ ओमन यूसुफ ला मिसर देस ले गीन। ");
INSERT INTO hne_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","जब रूबेन ह खंचवा करा लहुंटिस अऊ देखिस कि यूसुफ ह उहां नइं ए, त दुखी होके ओह अपन ओनहा ला चीरिस, ");
INSERT INTO hne_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","अऊ अपन भाईमन करा वापिस जाके कहिस, “छोकरा तो उहां नइं ए! अब में कहां जावंव?” ");
INSERT INTO hne_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","तब ओमन यूसुफ के अंगरखा ला लीन, अऊ एक ठन बोकरा ला मारके ओकर लहू म ओला बोर दीन। ");
INSERT INTO hne_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ओमन ओ रंग-बिरंगा अंगरखा ला अपन ददा करा वापिस ले जाके कहिन, “येह हमन ला मिले हे। तेंह जांचके देख ले कि येह तोर बेटा के अय कि नइं।” ");
INSERT INTO hne_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ओह ओला चिन डारिस अऊ कहिस, “येह तो मोर बेटा के अंगरखा ए! कोनो हिंसक पसु ह ओला मारके खा डारिस। सही म, यूसुफ के कुटा-कुटा कर दे गे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","तब याकूब ह दुख म अपन ओनहा ला चीरिस, बोरा ला पहिरिस अऊ अपन बेटा बर अब्बड़ दिन ले दुख मनाईस। ");
INSERT INTO hne_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ओकर जम्मो बेटा-बेटीमन ओला सांति देय बर आईन, पर ओला सांति नइं मिलिस। ओह कहिस, “नइं, मेंह तब तक दुख मनात रहिहूं, जब तक में अपन बेटा करा कबर म माटी नइं पा जावंव।” ये किसम ले ओकर ददा ह ओकर बर रोते रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ये बीच म, मिदयानीमन यूसुफ ला मिसर देस ले जाके पोतीफर के हांथ म बेच दीन। पोतीफर ह फिरौन राजा के एक हाकिम याने कि राजा के अंगरछकमन के मुखिया रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ओ समय अइसन होईस कि यहूदा ह अपन भाईमन करा ले चल दीस अऊ हीरा नांव के अदुल्लाम गांव के रहइया मनखे करा रहे लगिस। ");
INSERT INTO hne_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","उहां यहूदा ह सूआ नांव के कनानी मनखे के बेटी ला देखिस; अऊ ओकर ले बिहाव करके ओकर संग सुतिस। ");
INSERT INTO hne_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ओह आसरा म होके एक बेटा ला जनम दीस, जेकर नांव एर रखे गीस। ");
INSERT INTO hne_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ओह फेर आसरा म होईस अऊ एक बेटा ला जनम दीस अऊ ओह ओकर नांव ओनान रखिस। ");
INSERT INTO hne_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ओह एक अऊ बेटा ला जनमिस, जेकर नांव सेलह रखे गीस। जऊन समय एकर जनम होईस, ओ समय यहूदा ह कजीब म रहत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदा ह तामार नांव के एक माईलोगन ले अपन बड़े बेटा एर के बिहाव कर दीस। ");
INSERT INTO hne_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","पर यहूदा के बड़े बेटा एर ह यहोवा के नजर म दुस्ट मनखे रिहिस; एकरसेति यहोवा ह ओला मार डारिस। ");
INSERT INTO hne_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","तब यहूदा ह ओनान ला कहिस, “अपन भौजी संग सुत अऊ ओकर संग देवर के धरम पूरा करके अपन भाई बर संतान पईदा कर।” ");
INSERT INTO hne_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","पर ओनान जानत रिहिस कि जऊन संतान जनमही, ओह ओकर नइं होवय; एकरसेति ओह जब भी अपन भौजी संग सुते, त अपन बीर्य ला ओह भुइयां म गिरा दे, ताकि ओकर भाई के नांव ले कोनो संतान झन होवय। ");
INSERT INTO hne_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","जऊन कुछू ओह करत रिहिस, ओह यहोवा के नजर म दुस्टता के काम रिहिस, एकरसेति यहोवा ह ओला घलो मार डारिस। ");
INSERT INTO hne_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","तब यहूदा ह ये सोचके कि कहूं सेलह ह घलो अपन भाईमन सहीं मर न जावय, अपन बहू तामार ले कहिस, “जब तक मोर बेटा सेलह जवान नइं हो जावय, तब तक तें अपन ददा के घर म बिधवा के रूप म रह।” एकरसेति तामार ह अपन ददा के घर म जाके रहे लगिस। ");
INSERT INTO hne_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","बहुंत समय के बाद, यहूदा के घरवाली याने कि सूआ के बेटी मर गीस। जब यहूदा ह दुख ला भुला गीस, त ओह अपन भेड़ के ऊन कतरइयामन करा तिमना नगर गीस, अऊ संग म अपन संगी अदुल्लाम के रहइया हीरा ला घलो ले गीस। ");
INSERT INTO hne_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","जब तामार ला ये खबर मिलिस, “तोर ससुर ह अपन भेड़मन के ऊन कतरे बर तिमना जावथे।” ");
INSERT INTO hne_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","त ओह अपन बिधवा के पहिरावा ला उतारिस अऊ घूंघट डारके अपन ला ढांप लीस, अऊ एनैम नगर के कपाट करा जाके बईठ गीस, जेह तिमना के डहार म हवय। काबरकि ओह देख डारे रिहिस कि सेलह ह जवान हो गे हवय, पर ओला ओकर घरवाला बने बर नइं दिये गे हवय। ");
INSERT INTO hne_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","जब यहूदा ह ओला देखिस, त ओह ओला बेस्या समझिस, काबरकि ओह अपन मुहूं ला ढांपे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ये बिगर जाने कि ओह ओकर बहू अय, यहूदा ह ओकर करा सड़क-तीर म गीस अऊ ओला कहिस, “आ, मोला तोर संग सुतन दे।” ओह पुछिस, “तोर संग सुते के बदले, तें मोला का देबे?” ");
INSERT INTO hne_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ओह कहिस, “में अपन छेरी के झुंड म ले एक ठन छेरी-पीला तोर मेर पठो दूहूं।” तब ओह पुछिस, “ओला भेजत तक, का तेंह मोला गिरवी के रूप म कुछू देबे?” ");
INSERT INTO hne_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","यहूदा ह कहिस, “गिरवी के रूप म, तोला में का दंव?” ओह जबाब दीस, “तोर मुहर अऊ एकर डोरी, अऊ अपन हांथ म धरे लउठी।” तब ओह ओ चीजमन ला ओला दे दीस अऊ ओकर संग सुतिस, अऊ ओह ओकर कोति ले आसरा म होईस। ");
INSERT INTO hne_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","उहां ले जाय के बाद, ओह अपन घूंघट ला उतार दीस अऊ फेर अपन बिधवा के ओनहा ला पहिर लीस। ");
INSERT INTO hne_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ये बीच म, यहूदा ह अदुल्लाम के रहइया, अपन संगी के हांथ म एक ठन छेरी-पीला पठो दीस, ताकि ओह ओ माईलोगन ले ओकर गिरवी रखे चीजमन ला ले आवय, पर ओला ओ माईलोगन नइं मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ओह उहां रहइया मनखेमन ले पुछिस, “ओ मंदिर के बेस्या कहां हवय, जऊन ह एनैम के सड़क-तीर म बईठे रिहिस?” ओमन कहिन, “इहां कोनो मंदिर के बेस्या नइं रिहिस।” ");
INSERT INTO hne_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","एकरसेति ओह यहूदा करा वापिस जाके कहिस, “मोला ओह नइं मिलिस; अऊ उहां रहइया मनखेमन कहिन, ‘इहां कोनो मंदिर के बेस्या नइं रिहिस।’ ” ");
INSERT INTO hne_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","तब यहूदा ह कहिस, “ओला ओ चीजमन ला रखन दे, नइं तो हमर हंसी उड़ाय जाही। मेंह तो ये छेरी-पीला ला ओकर करा पठोय रहेंव, पर ओह तोला नइं मिलिस।” ");
INSERT INTO hne_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","करीब तीन महिना के बाद, यहूदा ला ये बताय गीस, “तोर बहू तामार ह बेभिचार करे हवय, अऊ ओकर कारन से ओह आसरा म हवय।” यहूदा ह कहिस, “ओला बाहिर लानव अऊ जलाके ओला मार डारव!” ");
INSERT INTO hne_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","जब ओला बाहिर लाने जावत रिहिस, त ओह अपन ससुर करा ये खबर पठोईस, “जऊन मनखे के ये चीजमन अंय, ओकरे कोति ले मेंह आसरा म हंव,” ओह ये घलो कहे रिहिस, “देख अऊ चिन ले कि ये मुहर अऊ डोरी अऊ लउठी काकर अंय।” ");
INSERT INTO hne_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदा ह ओ चीजमन ला चिन डारिस अऊ कहिस, “ओह तो मोर ले कम दोसी अय, काबरकि मेंह ओकर बिहाव अपन बेटा सेलह के संग नइं करेंव।” अऊ ओह ओकर संग फेर कभू नइं सुतिस। ");
INSERT INTO hne_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","जब ओकर छेवारी होय के बेरा आईस, त पता चलिस कि ओकर कोख म जुड़वां लइकामन हवंय। ");
INSERT INTO hne_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","जब ओह छेवारी होवत रिहिस, त एक लइका के हांथ ह बाहिर आईस; एकरसेति धाय ह लाल सुत लेके ओ लइका के कलई म बांध दीस अऊ कहिस, “येह पहिली जनमिस।” ");
INSERT INTO hne_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","पर जब ओ लइका ह अपन हांथ ला भीतर तीर लीस, त ओकर भाई ह जनमिस, तब ओ धाय ह कहिस, “ये किसम ले, तेंह जबरदस्ती निकल आय!” अऊ ओकर नांव पेरेस रखे गीस। ");
INSERT INTO hne_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","तब ओकर भाई, जेकर कलई म सिन्दूरी सूंत बंधाय रिहिस, जनमिस। अऊ ओकर नांव जेरह रखे गीस। ");
INSERT INTO hne_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","जब यूसुफ ला मिसर देस म लाय गीस, त पोतीफर नांव के एक मिसरी, जेह फिरौन के एक हाकिम याने कि अंगरछकमन के मुखिया रिहिस, ओला ओ इसमायलीमन करा ले बिसा लीस, जेमन ओला उहां लाने रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","यूसुफ ह अपन मिसरी मालिक के घर म रहत रिहिस, अऊ यहोवा ह ओकर संग रिहिस, एकरसेति ओह उन्नति करत गीस। ");
INSERT INTO hne_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","जब यूसुफ के मालिक ह देखिस कि यहोवा ओकर संग रहिथे अऊ जऊन काम ओह करथे, यहोवा ह ओमा ओला सफल करथे, ");
INSERT INTO hne_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","त ओकर किरपा के नजर यूसुफ ऊपर होईस अऊ यूसुफ ला ओकर सेवा-टहल करे बर ठहिराय गीस। पोतीफर ह ओला अपन घर के जिम्मा देके अपन जम्मो चीज ला ओकर भरोसा म छोंड़ दीस। ");
INSERT INTO hne_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","जब ले ओह अपन घर के जिम्मा अऊ अपन सबो चीज ला ओकर भरोसा म कर दीस, तब ले यहोवा ह यूसुफ के कारन ओ मिसरी के घर म आसीस देय लगिस। पोतीफर के जम्मो चीज म, ओकर घर अऊ खेत दूनों म यहोवा के आसीस होय लगिस। ");
INSERT INTO hne_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","एकरसेति पोतीफर ह अपन जम्मो चीज ला यूसुफ के देखरेख म कर दीस, इहां तक कि यूसुफ के कारन अपन खाय के रोटी के छोंड़, ओह अपन कोनो चीज के फिकर नइं करत रिहिस। यूसुफ ह सुन्दर अऊ ओकर कद-काठी बहुंत बढ़िया रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","कुछू समय के बाद, ओकर मालिक के घरवाली ह यूसुफ ऊपर नजर लगाईस अऊ कहिस, “आ, मोर संग सुत!” ");
INSERT INTO hne_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","पर ओह इनकार करके अपन मालिक के घरवाली ला कहिस, “जम्मो चीज ला मोर जिम्मा म देके, मोर मालिक ह घर म कोनो चीज के फिकर नइं करय; जऊन कुछू ओकर हवय, ओ जम्मो ला मोर भरोसा म छोंड़ दे हवय। ");
INSERT INTO hne_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ये घर म मोर ले बड़े कोनो नइं ए। ओह तोला छोंड़, अपन करा अऊ कुछू नइं रखे हे, काबरकि तें ओकर घरवाली अस। तब में अइसन दुस्ट काम करके परमेसर के बिरूध म कइसे पाप कर सकथंव?” ");
INSERT INTO hne_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","अऊ हालाकि ओह रोज-रोज यूसुफ ले बात करय, पर यूसुफ ह ओकर संग सुते बर इनकार करय, अऊ त अऊ ओकर संग रहे बर घलो नइं चाहय। ");
INSERT INTO hne_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिन अइसन होईस कि यूसुफ ह अपन काम-धाम करे बर घर भीतर गीस, अऊ घर के कोनो सेवक भीतर म नइं रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","तब ओ माईलोगन ह ओकर ओनहा ला धरके कहिस, “मोर संग सुत!” पर ओह अपन ओनहा ला ओकर हांथ म छोंड़के घर के बाहिर भाग गीस। ");
INSERT INTO hne_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","जब ओ माईलोगन ह ये देखिस कि ओह अपन ओनहा ला ओकर हांथ म छोंड़के घर के बाहिर भाग गे हे, ");
INSERT INTO hne_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","त ओह अपन घर के सेवकमन ला बलाके कहिस, “देखव, ओ इबरी मनखे ला मसखरी करे बर इहां लाने गे हवय! ओह तो इहां मोर संग सुते के मतलब से भीतर आय रिहिस, पर में जोर से नरियांय। ");
INSERT INTO hne_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","मदद खातिर जब ओह मोर नरियाई ला सुनिस, त ओह अपन ओनहा ला मोर करा छोंड़के घर के बाहिर भाग गीस।” ");
INSERT INTO hne_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ओह ओकर ओनहा ला ओकर मालिक के घर आवत तक अपन करा रखे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","जब ओह आईस, त ओला ये कहानी बताईस, “ओ इबरी दास, जेला तें हमर करा लाने हस, ओह मोर करा मसखरी करे बर आय रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","पर जब में मदद खातिर नरियांय, त ओह अपन ओनहा मोर करा छोंड़के घर के बाहिर भाग गीस।” ");
INSERT INTO hne_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","जब ओकर मालिक ह अपन घरवाली के ये बातमन ला सुनिस, “तोर दास ह मोर संग अइसन बेवहार करे हवय।” त ओह गुस्सा के मारे भड़क गीस। ");
INSERT INTO hne_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","यूसुफ के मालिक ह ओला पकड़के जेलखाना म डार दीस, जिहां राजा के कैदीमन बंद रिहिन। पर जब यूसुफ ह जेलखाना म रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","त यहोवा ह ओकर संग रिहिस। ओह ओकर ऊपर दया करिस, जेकर कारन जेलखाना के दरोगा के किरपा यूसुफ ऊपर होईस। ");
INSERT INTO hne_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","एकरसेति जेलखाना के दरोगा ह यूसुफ ला उहां जम्मो कैदीमन के मुखिया बना दीस, अऊ जऊन काम-बुता उहां करे जावत रिहिस, ओकर जिम्मेदारी घलो यूसुफ ला दे दीस। ");
INSERT INTO hne_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","यूसुफ के देखरेख म जऊन कुछू रिहिस, ओमा के कोनो बात के फिकर दरोगा ला नइं रिहिस, काबरकि यहोवा ह यूसुफ के संग रिहिस अऊ जऊन कुछू यूसुफ ह करय, ओ जम्मो म ओला सफल करत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","कुछू समय बाद, अइसन होईस कि मिसर के राजा के पीयानेवाला अऊ जेवन पकानेवाला अपन मालिक, राजा के बिरूध म कुछू अपराध करिन। ");
INSERT INTO hne_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","फिरौन ह अपन ओ दूनों हाकिम याने कि पीयानेवालामन के मुखिया अऊ रंधइयामन के मुखिया ऊपर नराज होईस, ");
INSERT INTO hne_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","अऊ ओमन ला पकड़के अंगरछकमन के मुखिया के घर के ओही जेलखाना म डलवा दीस, जिहां यूसुफ कैदी रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","तब अंगरछकमन के मुखिया ह ओमन ला यूसुफ के हांथ म सऊंप दीस, अऊ ओह ओमन के देखरेख करे लगिस। ओमन के कुछू समय तक जेलखाना म रहे के बाद, ");
INSERT INTO hne_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ओमा के दूनों मनखे—मिसर के राजा के पीयानेवाला अऊ रंधइया, जेमन जेलखाना म बंद रिहिन—एके रात म सपना देखिन, अऊ हर सपना के अलग-अलग मतलब रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","बिहनियां जब यूसुफ ओमन करा आईस, त देखिस कि ओमन उदास हवंय। ");
INSERT INTO hne_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","एकरसेति फिरौन के ओ अधिकारीमन ला, जेमन ओकर संग ओकर मालिक के घर म बंद रिहिन, यूसुफ ह पुछिस, “आज तुम्हर मुहूं काबर उतरे हवय?” ");
INSERT INTO hne_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ओमन जबाब दीन, “हमन दूनों झन सपना देखे हन, अऊ ओकर अर्थ बतानेवाला कोनो नइं ए।” यूसुफ ह ओमन ला कहिस, “का सपना के अर्थ बतानेवाला परमेसर नो हय? मोला अपन-अपन सपना बतावव।” ");
INSERT INTO hne_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","तब पीयानेवालामन के मुखिया ह अपन सपना यूसुफ ला अइसन बताय लगिस, “मेंह सपना म देखेंव कि मोर आघू म एक अंगूर के नार हे, ");
INSERT INTO hne_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","अऊ ओ अंगूर के नार म तीन ठन डंगाली हवंय। जतकी जल्दी ओमा कली फूटिस, ओमा फूल लगिस, अऊ गुच्छामन म अंगूरमन पाक गीन। ");
INSERT INTO hne_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","फिरौन राजा के कटोरा ह मोर हांथ म रिहिस, अऊ मेंह ओ अंगूरमन ला लेके फिरौन राजा के कटोरा म निचोंय अऊ कटोरा ला ओकर हांथ म दे देंव।” ");
INSERT INTO hne_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","यूसुफ ह ओला कहिस, “एकर मतलब ये अय—तीन डंगालीमन के अर्थ तीन दिन अय। ");
INSERT INTO hne_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","अब ले तीन दिन के भीतर फिरौन राजा ह तोला जेलखाना ले निकलवाही अऊ तोला तोर पद मिल जाही, अऊ तें फिरौन राजा के कटोरा ओकर हांथ म देबे, जइसने कि पहिली तें करत रहय, जब तें ओकर पीयानेवाला रहय। ");
INSERT INTO hne_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","पर जब तोर संग सब ठीक हो जाही, त मोला सुरता करबे अऊ मोर ऊपर दया देखाबे; मोर बारे म फिरौन राजा ला बताबे अऊ ये जेलखाना ले मोला बाहिर निकालबे। ");
INSERT INTO hne_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","असल म, मोला इबरीमन के देस ले जबरदस्ती लाय गे हवय, अऊ इहां घलो मेंह अइसन कुछू काम नइं करे हंव कि मोला ये जेलखाना म डारे जावय।” ");
INSERT INTO hne_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","जब रंधइयामन के मुखिया ह देखिस कि यूसुफ ह सपना के बने अर्थ बताय हवय, त ओह यूसुफ ला कहिस, “मेंह घलो एक सपना देखे हंव: मेंह देखेंव कि मोर मुड़ ऊपर रोटी के तीन ठन टुकनी हवंय। ");
INSERT INTO hne_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","सबले ऊपर के टुकनी म फिरौन राजा बर जम्मो किसम के चुरे-पाके चीजमन हवंय, पर चिरईमन मोर मुड़ म के टुकनी म ले ओ चीजमन ला खावत हवंय।” ");
INSERT INTO hne_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","यूसुफ ह कहिस, “एकर मतलब ये अय: तीन ठन टुकनी के मतलब तीन दिन अय। ");
INSERT INTO hne_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","अब ले तीन दिन के भीतर फिरौन राजा ह तोर मुड़ ला कटवाके तोर देहें ला एक ठन खंभा ऊपर टंगवा दीही। अऊ चिरईमन तोर मांस ला खाहीं।” ");
INSERT INTO hne_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","तीसर दिन फिरौन राजा के जनम दिन रिहिस, अऊ ओह अपन जम्मो करमचारीमन ला एक जेवनार दीस। ओह अपन करमचारीमन के आघू म पीयानेवालामन के मुखिया अऊ रंधइयामन के मुखिया ला जेलखाना ले बाहिर निकलवाईस। ");
INSERT INTO hne_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ओह पीयानेवालामन के मुखिया ला फेर ओकर पद दे दीस, ताकि ओह फिरौन राजा के हांथ म कटोरा देवय— ");
INSERT INTO hne_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","पर रंधइयामन के मुखिया ला ओह सूली म टंगवा दीस, जइसने कि यूसुफ ह ओमन ला सपना के अर्थ बताय रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","तभो ले, पीयानेवालामन के मुखिया ह यूसुफ ला सुरता नइं करिस; ओह ओला भुला गीस। ");
INSERT INTO hne_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","जब पूरा दू बछर हो गीस, त फिरौन राजा एक सपना देखिस: ओह नील नदी के तीर म ठाढ़े रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","अऊ ओ नदी म ले सात ठन सुन्दर अऊ मोट-मोट गाय निकलके कछार के कांदी ला चरे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ओमन के बाद, सात ठन आने कुरूप अऊ कमजोर गाय नील नदी ले निकलिन अऊ नदी के तीर म ठाढ़े दूसर गायमन के बाजू म ठाढ़ हो गीन। ");
INSERT INTO hne_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","अऊ जऊन गायमन कुरूप अऊ कमजोर रिहिन, ओमन ओ सात ठन सुन्दर अऊ मोट-मोट गायमन ला खा डारिन। तब फिरौन ह नींद ले जाग गीस। ");
INSERT INTO hne_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ओह फेर सुत गीस अऊ एक आने सपना देखिस: एक ही डंठल म ले सात ठन मोट अऊ बने बीजा के पीकमन निकलिन। ");
INSERT INTO hne_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ओमन के बाद, सात ठन अऊ बीजा के पीकमन निकलिन, जेमन पातर अऊ पूरब दिग के हवा ले मुरझा गे रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ओ बीजा के पातर पीकमन ओ सातों मोट अऊ दाना ले भरे पीकमन ला लील डारिन। तब फिरौन ह जाग गीस; येह एक सपना रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","बिहनियां फिरौन के मन ह बियाकुल हो गीस, एकरसेति ओह मिसर के जम्मो जादूगर अऊ पंडितमन ला बुलवाईस, अऊ ओमन ला अपन दूनों सपना ला बताईस, पर कोनो घलो ओला ओ सपनामन के अर्थ नइं बता सकिन। ");
INSERT INTO hne_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","तब पीयानेवालामन के मुखिया ह फिरौन ला कहिस, “आज में अपन गलती ला सुरता करत हंव। ");
INSERT INTO hne_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","जब फिरौन ह अपन सेवकमन ले नराज रिहिस, अऊ ओह मोला अऊ रंधइयामन के मुखिया ला अंगरछकमन के मुखिया के घर म कैद करके रखे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","तब हमन दूनों झन एके रथिया एक-एक सपना देखेंन, अऊ हर सपना के अपन म अलग अर्थ रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","उहां हमर संग एक इबरी जवान रिहिस, जऊन ह अंगरछकमन के मुखिया के सेवक रिहिस। हमन ओला अपन-अपन सपना बतायेंन, अऊ ओह हमर सपनामन के अर्थ हमन ला बताईस; हमन के एक-एक के सपना के अर्थ ओह बता दीस। ");
INSERT INTO hne_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","अऊ जइसने-जइसने अर्थ ओह हमन ला बताय रिहिस, एकदम वइसनेच होईस घलो: मोला मोर पद फेर मिल गीस, पर रंधइयामन के मुखिया ला सूली ऊपर लटका दिये गीस।” ");
INSERT INTO hne_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","तब फिरौन ह यूसुफ ला बलाय बर पठोईस, अऊ ओला तुरते जेलखाना ले बाहिर निकाले गीस, अऊ ओह चुंदी कटवाके अऊ कपड़ा बदलके फिरौन के आघू म आईस। ");
INSERT INTO hne_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फिरौन ह यूसुफ ला कहिस, “मेंह एक सपना देखे हंव, अऊ कोनो ओकर अर्थ नइं बता सकत हें। पर मेंह तोर बारे म सुने हवंव कि तें सपना ला सुनके ओकर अर्थ बता देथस।” ");
INSERT INTO hne_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","यूसुफ ह फिरौन ला जबाब दीस, “में ये नइं कर सकंव, पर परमेसर ह फिरौन ला ओकर ईछा के जबाब दीही।” ");
INSERT INTO hne_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","तब फिरौन ह यूसुफ ला कहिस, “में अपन सपना म नील नदी के तीर म ठाढ़े रहेंव। ");
INSERT INTO hne_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","तब नदी म ले सात ठन मोट-मोट अऊ सुन्दर गाय निकलिन अऊ कछार के कांदी ला चरे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ओमन के बाद, सात ठन गाय अऊ निकलिन, जेमन दुरबल, बहुंत कुरूप अऊ पातर रिहिन। मेंह पूरा मिसर देस म अइसन कुरूप गाय कभू नइं देखे रहेंव। ");
INSERT INTO hne_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ये पातर अऊ कुरूप गायमन ओ पहिली के सात ठन मोट-मोट गायमन ला खा डारिन। ");
INSERT INTO hne_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","पर ओमन ला खाय के बाद घलो कोनो ये नइं कह सकत रिहिन कि ओमन अइसन करे हवंय, काबरकि ओमन पहिली के सहीं जस के तस कुरूप दिखत रिहिन। तब में जाग गेंव। ");
INSERT INTO hne_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“फेर में दूसर सपना म देखेंव कि एक ही डंठल म सात ठन बने-बने अऊ बीजा ले भरे पीकमन निकलिन। ");
INSERT INTO hne_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ओमन के बाद, अऊ सात ठन पीक निकलिन, जेमन कमजोर अऊ पातर अऊ पूरब के हवा ले मुरझा गे रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","बीजा के ये पातर पीकमन ओ बने सात ठन पीकमन ला लील डारिन। मेंह येला जादूगरमन ला बतांय, पर ओमा के कोनो मोला ओकर अर्थ नइं बता सकिन।” ");
INSERT INTO hne_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","तब यूसुफ ह फिरौन ला कहिस, “फिरौन के सपनामन एके ठन अऊ ओहीच अंय। परमेसर जऊन काम करे बर चाहत हवय, ओला ओह फिरौन ऊपर परगट करे हवय। ");
INSERT INTO hne_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ओ सात बने गायमन सात बछर अंय, अऊ ओ बीजा के सात ठन बने पीकमन घलो सात बछर अंय; येह एके ठन अऊ ओहीच सपना अय। ");
INSERT INTO hne_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","जऊन सात ठन पातर अऊ कुरूप गायमन निकलिन, अऊ जऊन सात ठन बेकार अऊ पूरब के हवा ले मुरझाय पीकमन निकलिन: ओमन अकाल के सात बछर अंय। ");
INSERT INTO hne_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“येह ओही बात अय, जेला में फिरौन ला बता डारे हंव: परमेसर जऊन काम करनेवाला हे, ओला ओह फिरौन ला देखाय हवय। ");
INSERT INTO hne_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","सुन, जम्मो मिसर देस म सात बछर तो अब्बड़ ऊपज होही। ");
INSERT INTO hne_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","पर ओकर पाछू, सात बछर अकाल पड़ही, अऊ मिसर देस के मनखेमन ओ जम्मो बने ऊपज ला भुला जाहीं, अऊ अकाल ले देस ह नास हो जाही। ");
INSERT INTO hne_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ओ अब्बड़ ऊपज ला कोनो सुरता नइं करही, काबरकि ओकर बाद जऊन अकाल पड़ही, ओह बहुंत भयंकर होही। ");
INSERT INTO hne_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","फिरौन ला ये जो सपना दू किसम ले देखाय गीस, एकर कारन ये अय कि ये बात परमेसर कोति ले ठहिराय जा चुके हवय अऊ परमेसर ह येला जल्दी पूरा करही। ");
INSERT INTO hne_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“एकरसेति अब फिरौन ह कोनो समझदार अऊ बुद्धिमान मनखे ला खोजके ओला मिसर देस ऊपर मुखिया ठहिराय। ");
INSERT INTO hne_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","फिरौन ह देस भर म अधिकारीमन ला ठहिराय, जेमन सुकाल के सात बछर रहत तक मिसर देस के मनखेमन ले ऊपज के पांचवां भाग ला लेवंय। ");
INSERT INTO hne_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ओमन अवइया बने समय म जम्मो खाय-पीये के चीज ला संकेलंय, अऊ फिरौन के अधिकार ले सहरमन म अनाज ला जमा करंय, ताकि खाय बर भोजन-बस्तु रहय। ");
INSERT INTO hne_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ये भोजन-बस्तु ला देस बर बचाके रखे जावय, ताकि मिसर देस ऊपर अवइया अकाल के ओ सात बछर के समय एकर उपयोग करे जा सकय, अऊ देस ह अकाल ले नास झन होवय।” ");
INSERT INTO hne_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ये बात फिरौन अऊ ओकर जम्मो करमचारीमन ला बने लगिस। ");
INSERT INTO hne_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","एकरसेति फिरौन ह अपन करमचारीमन ला कहिस, “का हमन ला ये मनखे सहीं कोनो मिल सकत हे, जेमा परमेसर के आतमा रहिथे?” ");
INSERT INTO hne_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","तब फिरौन ह यूसुफ ला कहिस, “जब परमेसर ह तोला ये जम्मो बात बताय हवय, त तोर सहीं समझदार अऊ बुद्धिमान मनखे अऊ कोनो नइं एं। ");
INSERT INTO hne_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","एकरसेति तेंह मोर महल के मुखिया होबे, अऊ मोर जम्मो मनखेमन तोर हुकूम ला मानहीं। सिरिप सिंघासन के आदर के कारन मेंह तोर ले बड़े रहिहूं।” ");
INSERT INTO hne_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","फेर फिरौन ह यूसुफ ले कहिस, “देख, में तोला पूरा मिसर देस ऊपर अधिकारी ठहिरात हंव।” ");
INSERT INTO hne_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","तब फिरौन ह अपन अंगरी ले मुहरवाला मुंदरी निकालके यूसुफ के अंगरी म पहिरा दीस। ओह ओला सुघर मलमल के ओनहा पहिराईस अऊ ओकर गला म सोन के माला पहिरा दीस। ");
INSERT INTO hne_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ओह ओला अपन बाद दूसर अधिकारी के रूप म रथ म चघाईस, अऊ मनखेमन ओकर आघू-आघू चिचियाके ये कहत रिहिन, “ओला दंडवत करव!” ये किसम ले, ओह ओला मिसर के जम्मो देस के ऊपर अधिकारी बना दीस। ");
INSERT INTO hne_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","तब फिरौन ह यूसुफ ला कहिस, “फिरौन तो में अंव, पर जम्मो मिसर देस म कोनो घलो तोर हुकूम के बिना कुछू नइं कर सकंय।” ");
INSERT INTO hne_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फिरौन ह यूसुफ के नांव सापनत-पानेह रखिस अऊ ओन नगर के पुरोहित पोतीपेरा के बेटी आसनत ले ओकर बिहाव करवा दीस। अऊ यूसुफ जम्मो मिसर देस म दउरा करिस। ");
INSERT INTO hne_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","जब यूसुफ ह मिसर के राजा फिरौन के सेवा म आईस, त ओह तीस बछर के रिहिस। अऊ यूसुफ ह फिरौन करा ले जाके जम्मो मिसर देस म दउरा करिस। ");
INSERT INTO hne_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सुकाल के सातों बछर अब्बड़ फसल होईस। ");
INSERT INTO hne_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","यूसुफ ह मिसर देस म सुकाल के ओ सातों बछर म जम्मो किसम के जेवन के चीज-वस्तु ला संकेलिस अऊ सहरमन म रखत गीस। हर सहर के चारों कोति के खेत म पईदा होय खाय-पीये के चीज ला ओह ओहीच सहर म जमा करत गीस। ");
INSERT INTO hne_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","अइसन करके यूसुफ ह अनाज ला समुंदर के बालू सहीं भारी तदाद म जमा कर लीस; अनाज अतकी जादा हो गीस कि ओह ओकर हिसाब रखे बर छोंड़ दीस, काबरकि येह गनती के बाहिर हो गीस। ");
INSERT INTO hne_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","अकाल परे के पहिली, यूसुफ के दू झन बेटा, ओन सहर के पुरोहित पोतीपेरा के बेटी आसनत ले होईन। ");
INSERT INTO hne_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","यूसुफ ह अपन बड़े बेटा के नांव ये कहिके मनस्से रखिस, “परमेसर ह मोर ले मोर जम्मो दुख अऊ मोर ददा के जम्मो घराना ला भुला दीस हे।” ");
INSERT INTO hne_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","दूसर बेटा के नांव ओह ये कहिके एपरैम रखिस, “मोर दुख भोगे के देस म परमेसर ह मोला फलवंत करे हे।” ");
INSERT INTO hne_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","मिसर देस म सुकाल के सात बछर सिरा गीस, ");
INSERT INTO hne_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","अऊ यूसुफ के कहे मुताबिक सात बछर के अकाल सुरू हो गीस। दूसर जम्मो देसमन म घलो अकाल परिस, पर पूरा मिसर देस म खाय के चीज-वस्तु रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","जब पूरा मिसर देस अकाल के चपेट म आईस, त मनखेमन फिरौन ले नरिया-नरियाके खाय बर मांगे लगिन। तब फिरौन ह जम्मो मिसरीमन ला कहिस, “यूसुफ करा जावव अऊ जऊन कुछू ओह तुमन ला कहिथे, वइसने करव।” ");
INSERT INTO hne_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","जब अकाल ह जम्मो देस म फईल गीस, त यूसुफ ह जम्मो गोदाममन ला खोल दीस अऊ मिसरीमन ला अनाज बेचे लगिस, काबरकि जम्मो मिसर देस म भयंकर अकाल परे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","अऊ जम्मो संसार के मनखेमन मिसर देस म यूसुफ करा अनाज बिसाय बर आय लगिन, काबरकि जम्मो जगह भयंकर अकाल परे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","जब याकूब ला पता चलिस कि मिसर देस म अनाज हवय, त ओह अपन बेटामन ला कहिस, “तुमन काबर सिरिप एक-दूसर ला देखत हवव?” ");
INSERT INTO hne_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","फेर ओह कहिस, “मेंह सुने हंव कि मिसर म अनाज हवय। तुमन उहां जावव अऊ हमर बर कुछू अनाज बिसाके लानव, ताकि हमन झन मरन, पर जीयत रहन।” ");
INSERT INTO hne_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","तब यूसुफ के दस भाईमन अनाज बिसाय बर मिसर गीन। ");
INSERT INTO hne_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","पर याकूब ह यूसुफ के भाई बिनयामीन ला ओमन के संग नइं पठोईस, काबरकि ओह डरात रिहिस कि बिनयामीन ऊपर बिपत्ति आ सकत हे। ");
INSERT INTO hne_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ये किसम ले जऊन मन अनाज बिसाय बर गीन, ओमन म इसरायल के बेटामन घलो गीन, काबरकि कनान देस म घलो अकाल परे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","यूसुफ ह मिसर देस के राजपाल रिहिस, अऊ ओह ओ देस के जम्मो झन ला अनाज बेचत रिहिस। एकरसेति जब यूसुफ के भाईमन आईन, त ओमन भुइयां म मुहूं के भार गिरके ओला दंडवत करिन। ");
INSERT INTO hne_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","यूसुफ ह अपन भाईमन ला देखत ही ओमन ला चिन डारिस, पर ओह अनजान बने रिहिस अऊ ओमन ले कड़ई से पुछिस, “तुमन कहां ले आय हव?” ओमन कहिन, “हमन कनान देस ले अनाज बिसाय बर आय हन।” ");
INSERT INTO hne_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","हालाकि यूसुफ अपन भाईमन ला चिन डारिस, पर ओमन ओला नइं चिन्हिन। ");
INSERT INTO hne_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","तब ओह ओमन के बारे म देखे अपन सपना ला सुरता करिस अऊ ओमन ला कहे लगिस, “तुमन भेदिया अव! तुमन ये देखे बर आय हव कि हमर देस म कते करा पहरेदारी नइं होवत हे।” ");
INSERT INTO hne_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ओमन जबाब दीन, “नइं, नइं, हे हमर मालिक, तोर सेवकमन भोजन-बस्तु बिसाय बर आय हवंय। ");
INSERT INTO hne_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हमन जम्मो झन एके मनखे के बेटा अन। तोर सेवकमन ईमानदार मनखे अंय, भेदिया नो हंय।” ");
INSERT INTO hne_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ओह ओमन ला कहिस, “नइं! तुमन ये देखे बर आय हव कि हमर देस म कते करा पहरेदारी नइं होवत हे।” ");
INSERT INTO hne_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","पर ओमन कहिन, “तोर सेवकमन बारह भाई रिहिन, अऊ जम्मो झन कनान देस म रहइया एके मनखे के बेटा अंय। सबले छोटे ह अभी हमर ददा करा हवय, अऊ एक झन ह काल कर डारिस।” ");
INSERT INTO hne_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","यूसुफ ह ओमन ला कहिस, “मेंह तुमन ला कह डारे हंव कि तुमन भेदिया अव! ");
INSERT INTO hne_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","अऊ तुम्हर ये किसम ले जांच होही: फिरौन के जिनगी के कसम, जब तक तुम्हर छोटे भाई ह इहां नइं आ जाही, तुमन इहां ले नइं जा सकव। ");
INSERT INTO hne_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","तुमन अपन म ले एक झन ला पठोवव कि ओह तुम्हर भाई ला लेके आवय; बाकि तुमन इहां कैद म रहिहू, ये किसम ले तुम्हर बात ह परखे जाही कि तुमन सच कहत हव कि नइं। यदि तुम्हर बात ह सच नइं होही, त फिरौन के जिनगी के कसम, तुमन सच म भेदिया अव!” ");
INSERT INTO hne_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","अऊ ओह ओमन ला तीन दिन तक कैद म रखिस। ");
INSERT INTO hne_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तीसर दिन यूसुफ ह ओमन ला कहिस, “एक काम करव, त जीयत रहिहू, काबरकि में परमेसर के भय मानथंव: ");
INSERT INTO hne_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","यदि तुमन ईमानदार मनखे अव, त तुम्हर भाईमन ले एक झन इहां जेलखाना म रूके, अऊ बाकि झन अपन परिवार के मनखेमन के भूख मिटाय बर अनाज ले जावव। ");
INSERT INTO hne_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","पर तुमन अपन सबले छोटे भाई ला मोर करा ले आवव, ताकि तुम्हर बात ला सच साबित करे जा सकय, अऊ तुमन झन मारे जावव।” तब ओमन वइसनेच करिन। ");
INSERT INTO hne_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ओमन एक-दूसर ला कहिन, “सच म, हमन अपन भाई के कारन दंड पावत हन। हमन देखे रहेंन कि ओह कतेक दुखी रिहिस, जब ओह हमर ले अपन जिनगी बर बिनती करत रिहिस, पर हमन नइं सुनेंन; एकरसेति ये बिपत ह हमर ऊपर परे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रूबेन ह कहिस, “का में तुमन ला नइं कहे रहेंव कि छोकरा के बिरूध म पाप झन करव? पर तुमन नइं सुनेव! अब हमन ला ओकर लहू के हिसाब देना पड़ही।” ");
INSERT INTO hne_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ओमन नइं जानत रिहिन कि यूसुफ ह ओमन के बात ला समझत हवय, काबरकि ओमन के संग गोठियाय बर यूसुफ ह एक दुभासिया के उपयोग करत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","तब ओह ओमन करा ले हट गीस अऊ रोये लगिस, पर ओह फेर वापिस आईस अऊ ओमन ले फेर बात करिस। ओह ओमन ले सिमोन ला लीस अऊ ओमन के आघू म ओला बांधके कैदी बना लीस। ");
INSERT INTO hne_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","तब यूसुफ ह हुकूम दीस कि ओमन के बोरामन ला अनाज ले भर देवव अऊ हर एक झन के बोरा म ओकर रूपिया ला घलो रख देवव, अऊ रसता बर ओमन ला भोजन-पानी दे देवव। ओमन बर अइसने ही करे गीस। ");
INSERT INTO hne_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","तब ओमन अपन गदहामन ऊपर अनाज लादके उहां ले चल दीन। ");
INSERT INTO hne_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","रसता म ओमन एक जगह रात बिताय बर रूकिन, त ओमन के एक झन ह अपन गदहा ला चारा देय बर अपन बोरा ला खोलिस, त ओह देखिस कि ओकर रूपिया ह अनाज के ऊपर म रहय। ");
INSERT INTO hne_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","तब ओह अपन भाईमन ला कहिस, “मोर रूपिया तो लहुंटा दे गे हवय; देखव, येह मोर बोरा म हवय।” तब ओमन के जी म जी नइं रिहिस अऊ ओमन डर के मारे एक-दूसर कोति देखके कांपे लगिन अऊ कहिन, “परमेसर ह हमर संग ये का करे हवय?” ");
INSERT INTO hne_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","जब ओमन कनान देस म अपन ददा याकूब करा आईन, त जऊन कुछू ओमन के संग होय रिहिस, ओ जम्मो बात ओला बताईन। ओमन कहिन, ");
INSERT INTO hne_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“जऊन मनखे ह ओ देस के हाकिम अय, ओह हमन ले बहुंत कड़ई से बात करिस अऊ हमर ले अइसन बरताव करिस, जइसन कि हमन ओकर देस के भेद लेवत रहेंन। ");
INSERT INTO hne_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","पर हमन ओला कहेंन, ‘हमन ईमानदार मनखे अन; हमन भेदिया नो हन। ");
INSERT INTO hne_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हमन बारह भाई, जम्मो एके ददा के बेटा अन। एक भाई ह काल कर डारिस, अऊ सबले छोटे ह अभी कनान देस म हमर ददा करा हवय।’ ");
INSERT INTO hne_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“तब ओ मनखे, जऊन ह ओ देस के हाकिम अय, हमन ला कहिस, ‘ये किसम ले मोला मालूम हो जाही कि तुमन ईमानदार मनखे अव कि नइं: तुमन अपन म ले एक भाई ला मोर करा छोंड़ जावव, अऊ अपन परिवार के मनखेमन के भूख मिटाय बर भोजन-बस्तु लेके जावव। ");
INSERT INTO hne_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","पर अपन छोटे भाई ला मोर करा लेके आवव, तब मेंह जानहूं कि तुमन भेदिया नइं, पर ईमानदार मनखे अव। तब में तुम्हर भाई तुमन ला सऊंप दूहूं, अऊ तुमन ये देस म लेन-देन कर सकहू।’ ” ");
INSERT INTO hne_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","जब ओमन अपन-अपन बोरा म ले अनाज निकाले लगिन, त देखिन कि हर एक के रूपिया के थैली ओकर बोरा म हवय! जब ओमन अऊ ओमन के ददा ह रूपिया के थैलीमन ला देखिन, त ओमन बहुंत डरा गीन। ");
INSERT INTO hne_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","तब ओमन के ददा याकूब ह ओमन ला कहिस, “तुमन मोर ले मोर लइकामन ला छीन ले हव। यूसुफ तो नइं ए अऊ सिमोन घलो नइं ए, अऊ अब तुमन बिनयामीन ला घलो ले जाय चाहत हव। ये जम्मो बिपत्ति मोर ऊपर आ गे हवय।” ");
INSERT INTO hne_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","तब रूबेन ह अपन ददा ला कहिस, “यदि में ओला तोर करा वापिस नइं लानहूं, त तें मोर दूनों बेटा ला मार डारबे। तें ओला मोर हांथ म सऊंप दे, अऊ में ओला वापिस लेके आहूं।” ");
INSERT INTO hne_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","पर याकूब ह कहिस, “मोर बेटा ह तोर संग उहां नइं जावय; ओकर भाई ह मर चुके हे अऊ ओह एके झन बांचे हवय। जिहां तुमन जावत हव, यदि डहार म ओकर ऊपर कोनो बिपत पड़थे, त तुमन के कारन, मेंह ये बुढ़ापा म दुख म मर जाहूं।” ");
INSERT INTO hne_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","कनान देस म अभी घलो अकाल ह बहुंत भयंकर रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","जब मिसर ले लाने जम्मो अनाज सिरा गीस, त याकूब ह अपन बेटामन ला कहिस, “मिसर देस वापिस जावव अऊ हमर बर थोरकून अऊ अनाज बिसाके लानव।” ");
INSERT INTO hne_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","तब यहूदा ह ओला कहिस, “ओ मनखे ह हमन ला चेताके कहे रिहिस, ‘यदि तुम्हर भाई तुम्हर संग नइं आही, त फेर तुमन मोर आघू म नइं आ सकव।’ ");
INSERT INTO hne_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","यदि तें हमर भाई ला हमर संग पठोबे, त हमन जाबो अऊ तोर बर अनाज बिसाबो। ");
INSERT INTO hne_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","पर यदि तें ओला नइं पठोबे, त हमन नइं जावन, काबरकि ओ मनखे ह हमन ला कहिसे, ‘यदि तुम्हर भाई तुम्हर संग नइं आही, त फेर तुमन मोर आघू म नइं आ सकव।’ ” ");
INSERT INTO hne_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","तब इसरायल ह पुछिस, “तुमन ओ मनखे ला ये बताके कि तुम्हर एक झन अऊ भाई हवय, काबर मोर ऊपर ये समस्या लानेव?” ");
INSERT INTO hne_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ओमन जबाब दीन, “ओ मनखे ह बड़े सावधानी से हमर अऊ परिवार के बारे म अइसने सवाल पुछिस, ‘का तुम्हर ददा ह अब तक जीयत हवय? का तुम्हर अऊ भाई हवय?’ तब हमन सधारन रूप म ओकर सवाल के जबाब देंन। हमन कइसे जान सकत रहेंन कि ओह ये कहिही, ‘अपन भाई ला इहां ले आवव’?” ");
INSERT INTO hne_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","तब यहूदा ह अपन ददा इसरायल ला कहिस, “ओ छोकरा ला मोर संग म पठो दे अऊ हमन तुरते चले जाबो, ताकि हमन अऊ तें अऊ हमर लइकामन जीयत रहंय अऊ मरंय झन। ");
INSERT INTO hne_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","में खुद ओकर सुरकछा के जमानत अंव; तेंह मोला ओकर बर जिम्मेदार ठहिरा सकथस। यदि में ओला तोर करा लानके इहां तोर आघू म ठाढ़ नइं कर देवंव, त मोर जिनगी भर, में तोर अपराधी ठहिरहूं। ");
INSERT INTO hne_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","यदि हमन देरी नइं करतेंन, त अभी तक दू बार जाके लहुंट आय रहितेंन।” ");
INSERT INTO hne_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","तब ओमन के ददा इसरायल ह ओमन ला कहिस, “यदि येह जरूरी अय, त अइसने करव: ये देस के सबले बने चीजमन ले थोर-थोर अपन बोरा म रखव अऊ ओ मनखे बर भेंट के रूप म ले जावव—जइसे कि थोरकन मलहम अऊ थोरकन मंधरस, कुछू मसाला अऊ गंधरस, कुछू पिसता अऊ बादाम। ");
INSERT INTO hne_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","अपन-अपन संग म दू गुना रूपिया ले जावव; काबरकि जऊन रूपिया तुम्हर बोरामन के मुहूं म रख दिये गे रिहिस, ओला लहुंटाना जरूरी अय। सायद गलती से अइसने होय होही। ");
INSERT INTO hne_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","अपन भाई ला घलो ले लव अऊ ओ मनखे करा तुरते वापिस जावव। ");
INSERT INTO hne_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","अऊ सर्वसक्तिमान परमेसर ह ओ मनखे ला तुम्हर ऊपर दयालु करय, ताकि ओह तुम्हर दूसर भाई अऊ बिनयामीन ला तुम्हर संग वापिस आवन दे। यदि में बिगर बंस के हो जावंव, त हो जावंव।” ");
INSERT INTO hne_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","तब ओ मनखेमन ओ भेंट अऊ दू गुना रूपिया, अऊ बिनयामीन ला संग म लेके चल दीन, अऊ मिसर म हबरके यूसुफ के आघू म ठाढ़ होईन। ");
INSERT INTO hne_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","जब यूसुफ ह बिनयामीन ला ओमन के संग देखिस, त ओह अपन घर के देखरेख करइया ला कहिस, “ये मनखेमन ला मोर घर म ले जा, अऊ एक पसु मारके जेवन तियार कर; काबरकि येमन मंझनियां मोर संग जेवन करहीं।” ");
INSERT INTO hne_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ओ मनखे ह यूसुफ के कहे मुताबिक करिस अऊ ओ मनखेमन ला यूसुफ के घर ले गीस। ");
INSERT INTO hne_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","जब ओमन ला यूसुफ के घर म लाने गीस, त ओमन डरा गीन। ओमन सोचिन, “जऊन रूपिया पहिली बखत हमर बोरामन म लहुंटा दिये गे रिहिस, ओकरे कारन हमन ला इहां लाने गे हवय। ओह हमर ऊपर हमला करके हमन ला अपन बस म करे चाहत हे अऊ हमन ला गुलाम के रूप म पकड़के हमर गदहामन ला लेय चाहत हे।” ");
INSERT INTO hne_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","एकरसेति ओमन यूसुफ के घर के देखरेख करइया करा गीन अऊ घर के कपाट करा ओकर ले ये कहे लगिन, ");
INSERT INTO hne_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“हे हमर मालिक, हमन ला छेमा कर; हमन पहिली बार इहां अनाज बिसाय बर आय रहेंन। ");
INSERT INTO hne_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","पर वापिस जावत बेरा, जब एक जगह रात बिताय बर रूकेंन अऊ अपन-अपन बोरा ला खोलेंन, त का देखेंन कि हर एक के पूरा-पूरा पईसा ओकर बोरा के मुहूं म धराय रहय। एकरसेति हमन ओला अपन संग लेके आय हन। ");
INSERT INTO hne_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","हमन अपन संग अऊ रूपिया अनाज बिसाय बर लाने हन। हमन नइं जानन कि हमर रूपिया ला हमर बोरा म कोन रखे रिहिस।” ");
INSERT INTO hne_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","घर के देखरेख करइया ह कहिस, “कोनो बात नइं ए; झन डरव। तुम्हर परमेसर, जऊन ह तुम्हर ददा के घलो परमेसर अय, ओही ह तुम्हर बोरा म तुमन ला धन दे हवय; तुम्हर रूपिया तो मोला मिल गे हवय।” तब ओह सिमोन ला निकालके ओमन करा ले आईस। ");
INSERT INTO hne_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","तब ओ सेवक ह ओ मनखेमन ला यूसुफ के घर भीतर ले आईस, अऊ गोड़ धोय बर ओमन ला पानी दीस अऊ ओमन के गदहामन बर चारा दीस। ");
INSERT INTO hne_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ये सुनके कि आज हमन ला इहां जेवन करना हे, ओमन यूसुफ के आय के समय, याने कि मंझनियां तक, अपन-अपन भेंट ला तियार करके रखिन। ");
INSERT INTO hne_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","जब यूसुफ ह घर म आईस, त ओमन घर के भीतर लाय अपन भेंट यूसुफ ला दीन, अऊ भुइयां म गिरके ओला दंडवत करिन। ");
INSERT INTO hne_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ओह ओमन के हालचाल पुछिस अऊ कहिस, “तुम्हर सियान ददा कइसने हवय, जेकर बारे म तुमन मोला बताय रहेव? का ओह अभी घलो जीयत हवय?” ");
INSERT INTO hne_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ओमन कहिन, “हव, तोर सेवक, हमर ददा ह अभी घलो जीयत हवय अऊ बने हवय।” अऊ ओमन मुड़ नवाके ओला दंडवत करिन। ");
INSERT INTO hne_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","जब ओह आंखी उठाके अपन भाई बिनयामीन ला देखिस, जऊन ह ओकर खुद के दाई के बेटा रिहिस, त ओह पुछिस, “का येह तुम्हर सबले छोटे भाई अय, जेकर बारे म तुमन मोला बताय रहेव?” अऊ ओह कहिस, “हे मोर बेटा, परमेसर तोर ऊपर अनुग्रह करय।” ");
INSERT INTO hne_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","अपन भाई ला देखके यूसुफ के आंखी भर आईस, अऊ रोये बर सुन्ना जगह देखे लगिस। ओह अपन निजी कमरा म गीस अऊ उहां रोये लगिस। ");
INSERT INTO hne_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","अपन मुहूं ला धोये के बाद, ओह बाहिर निकलिस अऊ अपनआप ला सांत करके कहिस, “जेवन परोसव।” ");
INSERT INTO hne_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","तब ओमन ओकर बर अलग, ओकर भाईमन बर अलग, अऊ जऊन मिसरी मनखेमन ओकर संग खावत रिहिन, ओमन बर घलो अलग जेवन परोसिन, काबरकि मिसरी मनखेमन इबरी मनखेमन संग जेवन नइं करंय; ओमन बर अइसन करई ह घिन के बात रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","यूसुफ के भाईमन ला ओकर आघू म ओमन के उमर के हिसाब से बईठाय गे रिहिस, पहिले बड़खा, फेर ओकर बाद वालामन अऊ आखिरी म सबले छोटे; अऊ ओमन चकित होके एक-दूसर ला देखे लगिन। ");
INSERT INTO hne_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","तब यूसुफ के मेज म ले ओमन ला भोजन-बस्तु परोसे गीस, पर बिनयामीन ला ओकर भाईमन ले पांच गुना जादा भोजन-बस्तु परोसे गीस। ओमन यूसुफ के संग खुलके खाईन-पीईन। ");
INSERT INTO hne_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","तब यूसुफ ह अपन घर के देखरेख करइया ला ये हुकूम दीस: “ये मनखेमन जतेक जादा भोजन-बस्तु अपन बोरा म ले जा सकथें, ओतेक जादा भरव, अऊ हर एक के रूपिया ला ओमन के बोरा के मुहूं म रख देवव। ");
INSERT INTO hne_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","तब मोर चांदी के कटोरा ला सबले छोटे के बोरा के मुहूं म ओकर अनाज के रूपिया के संग रख देवव।” अऊ ओह वइसने करिस, जइसने यूसुफ ह कहिस। ");
INSERT INTO hne_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","बिहनियां होते ही, ओ मनखेमन ला ओमन के गदहामन के सहित बिदा करे गीस। ");
INSERT INTO hne_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ओमन सहर ले जादा दूरिहा नइं गे होहीं जब यूसुफ ह अपन घर के देखरेख करइया ला कहिस, “तुरते ओ मनखेमन के पीछा कर, अऊ जब ओमन तुमन ला मिल जाहीं, त ओमन ला कह, ‘तुमन भलई के बदला म बुरई काबर करे हव? ");
INSERT INTO hne_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","का येह ओ कटोरा नो हय, जेमा मोर मालिक पीथे अऊ अगम के बात कहे बर घलो एकर उपयोग करथे? तुमन एक दुस्ट काम करे हव।’ ” ");
INSERT INTO hne_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","जब ओला ओमन मिल गीन, त ओह ओमन ले वइसनेच कहिस। ");
INSERT INTO hne_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","पर ओमन ओला कहिन, “हे हमर मालिक, तें अइसन बात काबर कहत हस? अइसने काम करई तोर सेवकमन ले दूरिहा रहय! ");
INSERT INTO hne_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","देख, इहां तक कि जऊन रूपिया हमन ला हमर बोरामन के मुहूं के भीतर म मिले रिहिस, ओला हमन कनान देस ले तोर करा वापिस ले आयेंन, त फेर तोर मालिक के घर ले चांदी या सोन, हमन काबर चोराबो? ");
INSERT INTO hne_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","यदि तोर दासमन ले जेकर करा घलो ओ चीज निकलही, ओह मार डारे जाही; अऊ बाकि हमन, हे हमर मालिक, तोर गुलाम हो जाबो।” ");
INSERT INTO hne_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ओह कहिस, “तब, ठीक हे। तुम्हर कहे मुताबिक होवय। जेकर करा ओ चीज निकलही, ओह मोर दास हो जाही; अऊ बाकि तुमन दोस मुक्त हो जाहू।” ");
INSERT INTO hne_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ओमन जल्दी-जल्दी अपन-अपन बोरा ला भुइयां म उतारके ओला खोले लगिन। ");
INSERT INTO hne_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","तब यूसुफ के घर के देखरेख करइया ह खोजे लगिस; ओह सबले बड़े के बोरा ले सुरू करके सबले छोटे के बोरा म खतम करिस। अऊ कटोरा ह बिनयामीन के बोरा म मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","येला देखके ओमन अपन-अपन ओनहा ला चीरिन। तब ओमन जम्मो झन अपन-अपन गदहा ऊपर बोरा लादके सहर म वापिस आईन। ");
INSERT INTO hne_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","जब यहूदा अऊ ओकर भाईमन आईन, त यूसुफ ह घरेच म रिहिस, अऊ ओमन ओकर आघू म भुइयां म गिरिन। ");
INSERT INTO hne_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","यूसुफ ह ओमन ला कहिस, “तुमन ये कइसन काम करे हव? का तुमन ये नइं जानत हव कि मोर सहीं मनखे ह अगम के बात कहे के दुवारा चीज के पता लगा सकथे?” ");
INSERT INTO hne_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","“हमन हमर मालिक ला का कह सकत हन?” यहूदा ह कहिस। “हमन का कह सकत हन? हमन कइसे अपनआप ला निरदोस साबित करन? परमेसर ह तोर सेवकमन के अपराध ला देखा दे हे। अब हमन हमर मालिक के गुलाम अन—हमन खुद अऊ ओह घलो, जेकर करा कटोरा मिले हवय।” ");
INSERT INTO hne_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","पर यूसुफ ह कहिस, “अइसन करई मोर ले दूरिहा रहय! जेकर करा कटोरा निकले हवय, सिरिप ओहीच ह मोर दास होही। बाकि के तुमन सांति से अपन ददा करा वापिस जावव।” ");
INSERT INTO hne_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","तब यहूदा ओकर करा जाके कहे लगिस, “हे मोर मालिक, अपन सेवक ला छेमा कर; मोला एक बात कहन दे। तोर गुस्सा तोर सेवक ऊपर झन भड़के, काबरकि तें तो फिरौन के बरोबर अस। ");
INSERT INTO hne_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","हे मोर परभू, तेंह अपन सेवकमन ले पुछे रहय, ‘का तुम्हर ददा या भाई हवय?’ ");
INSERT INTO hne_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","अऊ हमन जबाब देय रहेंन, ‘हव, हमर डोकरा ददा हवय, अऊ ओकर बुढ़त काल म जनमे एक बेटा हवय। ओकर भाई ह मर गीस, अऊ अब ओह अपन दाई के एके झन बेटा बांचे हवय, अऊ ओकर ददा ह ओकर ले मया करथे।’ ");
INSERT INTO hne_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“तब तें अपन सेवकमन ला कहे, ‘ओला मोर करा ले आवव ताकि मेंह खुदे ओला देख सकंव।’ ");
INSERT INTO hne_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","अऊ हे मोर मालिक, हमन कहेंन, ‘ओ लड़का ह अपन ददा ला नइं छोंड़ सकय; नइं तो ओकर ददा ह मर जाही।’ ");
INSERT INTO hne_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","पर तें अपन सेवकमन ला कहे, ‘यदि तुम्हर छोटे भाई तुम्हर संग नइं आही, त फेर तुमन मोर आघू म नइं आ सकव।’ ");
INSERT INTO hne_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","जब हमन तोर सेवक हमर ददा करा गेंन, त हे मोर परभू, जऊन कुछू तेंह कहे रहे, हमन ओला बतायेंन। ");
INSERT INTO hne_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“तब हमर ददा ह कहिस, ‘वापिस जावव अऊ थोरकून अऊ भोजन-बस्तु बिसाके लानव।’ ");
INSERT INTO hne_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","पर हमन कहेंन, ‘हमन नइं जा सकन। हां, यदि हमर छोटे भाई हमर संग होही; त हमन जाबो। यदि हमर छोटे भाई हमर संग नइं होही, त हमन ओ मनखे के आघू म नइं जा सकन।’ ");
INSERT INTO hne_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“तब तोर सेवक मोर ददा ह हमन ला कहिस, ‘तुमन तो जानत हव कि मोर घरवाली दू झन बेटा जनमे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ओमा ले एक झन तो मोर ले दूरिहा चले गीस, अऊ मेंह सोचेंव, “निस्चय ही ओला पसुमन चीर डारे होहीं।” अऊ तब ले ओला, में नइं देखे हंव। ");
INSERT INTO hne_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","यदि तुमन येला घलो मोर आंखी ले दूरिहा ले जाथव, अऊ कोनो बिपत एकर ऊपर पड़थे, त तुम्हर कारन, में ये बुढ़ापा के समय दुख म मर जाहूं।’ ");
INSERT INTO hne_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“एकरसेति, तोर सेवक मोर ददा करा जब में वापिस जाहूं, अऊ यदि ये लड़का हमर संग म नइं होही, अऊ जब मोर ददा, जेकर परान ये लड़का म लटके रहिथे, ");
INSERT INTO hne_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","देखही कि लड़का ह उहां नइं ए, त ओह मर जाही। तोर सेवकमन के कारन, हमर ददा ह बुढ़ापा म दुख म मर जाही। ");
INSERT INTO hne_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","तोर सेवक ह मोर ददा ला ये कहिके लड़का के सुरकछा के जमानत ले हवय, ‘यदि में येला तोर करा वापिस नइं लानहूं, त मोर जिनगी भर, में तोर अपराधी ठहिरहूं!’ ");
INSERT INTO hne_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“एकरसेति, हे मोर मालिक, किरपा करके तोर सेवक ला ये लड़का के बदला म तोर गुलाम के रूप म इहां रहन दे, अऊ ये लड़का ला अपन भाईमन संग वापिस जावन दे। ");
INSERT INTO hne_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","यदि ये लड़का ह मोर संग नइं जाही, त में कइसे अपन ददा करा वापिस जा सकथंव? नइं! मोला अपन ददा ऊपर अवइया दुख ला झन देखन दे।” ");
INSERT INTO hne_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","तब यूसुफ ह अपन जम्मो सेवकमन के आघू म अपनआप ला नइं रोक सकिस, अऊ चिचियाके कहिस, “इहां के जम्मो मनखे बाहिर चले जावव!” अपन भाईमन के आघू म अपनआप ला परगट करे के बेरा उहां यूसुफ के संग अऊ कोनो नइं रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","अऊ ओह चिचिया-चिचियाके रोय लगिस, जेला मिसरीमन सुनिन, अऊ फिरौन के घर के मन ला घलो एकर खबर मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","यूसुफ ह अपन भाईमन ला कहिस, “में यूसुफ अंव! का मोर ददा अभी तक ले जीयत हवय?” पर ओकर भाईमन ओला जबाब नइं दे सकिन, काबरकि ओमन ओकर आघू म घबरा गे रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","तब यूसुफ ह अपन भाईमन ला कहिस, “मोर लकठा म आवव।” जब ओमन ओकर लकठा म आईन, त ओह कहिस, “मेंह तुम्हर भाई यूसुफ अंव, जेला तुमन मिसर अवइयामन के हांथ म बेच दे रहेव। ");
INSERT INTO hne_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","अब तुमन दुखी झन होवव, अऊ मोला इहां बेच देय के कारन, अपनआप ले गुस्सा झन होवव, काबरकि परमेसर ह परान बचाय बर मोला तुम्हर आघू इहां पठो दीस। ");
INSERT INTO hne_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","दू बछर हो गे, ये देस म अकाल परे हवय, अऊ अवइया पांच साल तक अइसने ही होही—न तो नांगर चलही अऊ न ही फसल लुये जाही। ");
INSERT INTO hne_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","पर परमेसर ह मोला तुम्हर आघू ये खातिर पठोईस कि ओह तुम्हर बर तुम्हर एक भाग ला बंचाके रखय अऊ एक बड़े छुटकारा के दुवारा तुम्हर जिनगी ला बचावय। ");
INSERT INTO hne_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“एकरसेति, मोला इहां पठोइया तुमन नइं, पर परमेसर अय। ओही ह मोला फिरौन के ददा सहीं अऊ ओकर जम्मो घर के मालिक अऊ जम्मो मिसर देस ऊपर सासन करइया ठहिराय हवय। ");
INSERT INTO hne_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","अब तुमन जल्दी करके मोर ददा करा जावव अऊ ओला कहव, ‘तोर बेटा यूसुफ ह अइसन कहत हे: परमेसर ह मोला जम्मो मिसर देस के मालिक बनाय हे। तें बिगर देरी करे मोर करा चले आ। ");
INSERT INTO hne_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","तें गोसेन के इलाका म रहिबे—तें, तोर लइकामन अऊ नाती-पोतामन, तोर भेड़-बकरी अऊ गाय-बईला, अऊ जऊन कुछू तोर करा हवय, ओ जम्मो सहित मोर लकठा म रहिबे। ");
INSERT INTO hne_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","अकाल के जऊन पांच बछर अऊ होही, ओमा में उहां तोर पालन-पोसन करहूं। अइसन झन होवय कि तें अऊ तोर घराना अऊ तोर करा जऊन मन हवंय, ओमन भूखन मरंय।’ ");
INSERT INTO hne_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“तुमन खुद अपन आंखी ले देख सकत हव, अऊ मोर भाई बिनयामीन घलो देख सकत हे कि में जो तुम्हर ले गोठियावत हंव, सही म यूसुफ अंव। ");
INSERT INTO hne_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ओ जम्मो आदरमान, जऊन ह मोर करा मिसर देस म हवय अऊ जऊन कुछू तुमन देखे हव, ओ जम्मो बात मोर ददा ला बतावव। अऊ तुरते मोर ददा ला इहां ले आवव।” ");
INSERT INTO hne_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","तब ओह अपन भाई बिनयामीन ला पोटारके रोईस, अऊ बिनयामीन घलो रोवत ओला पोटार लीस। ");
INSERT INTO hne_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","अऊ यूसुफ ह अपन जम्मो भाईमन ला चूमके रोईस। एकर बाद ओकर भाईमन ओकर संग गोठियाय लगिन। ");
INSERT INTO hne_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","जब ये खबर फिरौन के महल म पहुंचिस कि यूसुफ के भाईमन आय हवंय, त फिरौन अऊ ओकर जम्मो करमचारीमन खुस होईन। ");
INSERT INTO hne_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","फिरौन ह यूसुफ ला कहिस, “अपन भाईमन ले कह कि ओमन अइसन करंय: ‘अपन पसुमन ऊपर सामान लादके कनान देस वापिस चले जावंय, ");
INSERT INTO hne_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","अऊ अपन ददा अऊ अपन घर के मनखेमन ला लेके मोर करा आवंय। मेंह मिसर देस के सबले बने भुइयां तुमन ला दूहूं अऊ तुमन ला देस के उत्तम से उत्तम चीज खाय बर मिलही।’ ");
INSERT INTO hne_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“तोला ये घलो हुकूम दिये जावत हे कि तें ओमन ला बता कि ओमन अइसन करंय: ‘मिसर देस ले कुछू गाड़ी अपन लइका अऊ घरवाली अऊ तोर ददा बर ले जावंय, अऊ ओमन ला लेके आवंय। ");
INSERT INTO hne_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","अपन सामान के चिंता झन करंय, काबरकि मिसर म सबले बने चीजमन तुम्हर होही।’ ” ");
INSERT INTO hne_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","इसरायल के बेटामन वइसने ही करिन। यूसुफ ह फिरौन के हुकूम के मुताबिक ओमन ला गाड़ी दीस, अऊ रसता बर ओमन ला भोजन-बस्तु घलो दीस। ");
INSERT INTO hne_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ओमा के हर एक झन ला ओह एक-एक जोड़ा ओनहा दीस, पर बिनयामीन ला ओह तीन सौ चांदी के सेकेल अऊ पांच जोड़ा ओनहा दीस। ");
INSERT INTO hne_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","अऊ अपन ददा बर ओह ये सामान पठोईस: मिसर देस के सबले बने चीजमन ले लदाय दस ठन गदहा, अऊ अनाज अऊ रोटी अऊ ओकर ददा के रसता बर आने भोजन-बस्तु ले लदाय दस ठन गदही। ");
INSERT INTO hne_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","तब ओह अपन भाईमन ला बिदा करिस, अऊ जब ओमन जावत रिहिन, त ओह ओमन ला कहिस, “डहार म झगरा झन करिहव!” ");
INSERT INTO hne_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","मिसर ले निकलके, ओमन कनान देस म अपन ददा याकूब करा आईन। ");
INSERT INTO hne_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ओमन ओला ये बताईन, “यूसुफ अभी तक ले जीयत हे! अऊ जम्मो मिसर देस म ओही ह राज करत हे।” ये सुनके, याकूब ह हक्का-बक्का हो गीस; ओह ओमन के बात ला बिसवास नइं करिस। ");
INSERT INTO hne_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","पर जब ओमन ओ जम्मो बात ओला बताईन, जेला यूसुफ ह ओमन ले कहे रिहिस, अऊ जब ओह ओ गाड़ीमन ला देखिस, जेला यूसुफ ह ओला लाने बर पठोय रिहिस, तब ओमन के ददा याकूब के मन ह सांत होईस। ");
INSERT INTO hne_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","अऊ इसरायल ह कहिस, “मोला बिसवास हो गे हे! मोर बेटा यूसुफ ह अभी तक जीयत हे। एकर पहिली कि में मर जावंव, मेंह जाके ओला देखहूं।” ");
INSERT INTO hne_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","तब इसरायल ह अपन जम्मो संपत्ति लेके निकलिस, अऊ जब ओह बेरसेबा म हबरिस, त उहां ओह अपन ददा इसहाक के परमेसर ला बलिदान चघाईस। ");
INSERT INTO hne_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","अऊ परमेसर ह रथिया इसरायल ला दरसन म कहिस, “हे याकूब! हे याकूब!” ओह कहिस, “में इहां हंव।” ");
INSERT INTO hne_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","परमेसर ह कहिस, “में परमेसर अंव, तोर ददा के परमेसर। तें मिसर देस जाय बर झन डरा, काबरकि में उहां तोर ले एक बड़े जाति बनाहूं। ");
INSERT INTO hne_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मेंह तोर संग म मिसर जाहूं, अऊ निस्चित रूप से, में उहां ले तोला फेर वापिस ले आनहूं। अऊ यूसुफ ह अपन हांथ ले तोर आंखीमन ला बंद करही।” ");
INSERT INTO hne_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","तब याकूब बेरसेबा ले चल दीस, अऊ इसरायल के बेटामन अपन ददा याकूब अऊ अपन लइकामन ला अऊ अपन घरवालीमन ला ओ गाड़ीमन म चघाके चल दीन, जेला फिरौन ह ओमन ला लाने बर पठोय रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ये किसम ले, याकूब अऊ ओकर संतानमन अपन भेड़-बकरी, गाय-बईला, अऊ कनान म कमाय अपन जम्मो धन-दौलत ला लेके मिसर देस गीन। ");
INSERT INTO hne_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","याकूब ह अपन संग अपन बेटा-बेटी, पोता-पोती, याने अपन जम्मो संतान ला मिसर म ले आईस। ");
INSERT INTO hne_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","इसरायल (याकूब अऊ ओकर संतान) के बेटामन के नांव ये अय, जऊन मन ओकर संग मिसर देस गीन: याकूब के बड़खा बेटा रूबेन। ");
INSERT INTO hne_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रूबेन के बेटामन: हनोक, पल्लू, हेसरोन अऊ करमी। ");
INSERT INTO hne_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","सिमोन के बेटामन: यमूएल, यामीन, ओहद, याकीन, सोहर अऊ कनानी माईलोगन ले जनमे साऊल। ");
INSERT INTO hne_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवी के बेटामन: गेरसोन, कहात अऊ मरारी। ");
INSERT INTO hne_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदा के बेटामन: एर, ओनान, सेलह, पेरेस अऊ जेरह (पर एर अऊ ओनान कनान देस म ही मर गे रिहिन)। पेरेस के बेटामन: हेसरोन अऊ हामूल। ");
INSERT INTO hne_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साकार के बेटामन: तोला, पुआ, यसूब अऊ सिमरोन। ");
INSERT INTO hne_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलून के बेटामन: सेरेद, एलोन अऊ यहलेल। ");
INSERT INTO hne_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","येमन याकूब के घरवाली लिआ ले पदन-अराम म जनमे बेटामन रिहिन। ओकर दीना नांव के एक बेटी घलो रिहिस। ओकर ये बेटा अऊ बेटीमन कुल तैंतीस झन रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गाद के बेटामन: सिफियोन, हाग्गी, सूनी, एसबोन, एरी, अरोदी अऊ अरेली। ");
INSERT INTO hne_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आसेर के बेटामन: यिमना, इसवा, इसवी, बरीया। ओमन के बहिनी के नांव सेरह रिहिस। बरीया के बेटामन: हेबेर अऊ मलकीएल। ");
INSERT INTO hne_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","येमन याकूब कोति ले जिलपा ले जनमे लइकामन रिहिन, जेला लाबान ह अपन बेटी लिआ ला दासी के रूप म देय रिहिस। येमन कुल सोलह झन रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकूब के घरवाली राहेल के बेटामन: यूसुफ अऊ बिनयामीन। ");
INSERT INTO hne_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","मिसर देस म, ओन के पुरोहित पोतीपेरा के बेटी आसनत ले यूसुफ के दू झन बेटा होईन—मनस्से अऊ एपरैम। ");
INSERT INTO hne_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बिनयामीन के बेटामन: बेला, बेकेर, असबेल, गेरा, नामान, एही, रोस, मुप्पीम, हुप्पीम अऊ अर्द। ");
INSERT INTO hne_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","येमन याकूब के घरवाली राहेल ले जनमे बेटामन रिहिन। येमन कुल चौदह झन रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दान के बेटा: हूसीम। ");
INSERT INTO hne_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नपताली के बेटामन: यहसेल, गूनी, येसेर अऊ सिल्लेम। ");
INSERT INTO hne_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","येमन याकूब कोति ले बिलहा ले जनमे बेटामन रिहिन, जेला लाबान ह अपन बेटी राहेल ला दासी के रूप म देय रिहिस। येमन कुल सात झन रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ओ जम्मो, जऊन मन याकूब के संग मिसर म गीन अऊ ओकर खुद के बंस रिहिन—ओमन कुल छियासठ झन रिहिन अऊ येमा ओकर बहुमन ला नइं गने गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","यूसुफ के दू झन बेटा मिसर म जनमिन; येमन अऊ याकूब के घराना के जऊन मनखेमन मिसर म गीन, ओ जम्मो मिलाके कुल सत्तर झन रिहिन। ");
INSERT INTO hne_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","याकूब ह यहूदा ला अपन आघू यूसुफ करा पठोईस कि ओह ओकर ले गोसेन के डहार के पता करय। जब ओमन गोसेन के इलाका म आईन, ");
INSERT INTO hne_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","तब यूसुफ ह अपन रथ फंदवाके अपन ददा इसरायल ले भेंट करे बर गोसेन गीस। जब ओह अपन ददा करा हबरिस, त ओला पोटारके बहुंत देर तक रोईस। ");
INSERT INTO hne_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","इसरायल ह यूसुफ ला कहिस, “में अब मरे बर तियार हंव, काबरकि में खुद देख चुकेंव कि तें जीयत हस।” ");
INSERT INTO hne_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","तब यूसुफ ह अपन भाईमन ला अऊ अपन ददा के घर के मनखेमन ला कहिस, “मेंह जाके फिरौन ले गोठियाहूं अऊ ओला बताहूं, ‘मोर भाईमन अऊ मोर ददा के घर के मनखे, जेमन कनान देस म रहत रिहिन, ओमन मोर करा आ गे हवंय। ");
INSERT INTO hne_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ओमन चरवाहा अंय; ओमन पसु-पालन करथें, अऊ ओमन अपन संग अपन भेड़-बकरी, गाय-बईला अऊ अपन जम्मो सामान लेके आय हवंय।’ ");
INSERT INTO hne_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","जब फिरौन ह तुमन ला बलाके पुछही, ‘तुमन का धंधा करथव?’ ");
INSERT INTO hne_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तब तुमन ये कहिहू, ‘तोर सेवकमन लइकापन ले लेके आज तक पसु-पालन करत आय हन, अऊ हमर पुरखामन घलो अइसने ही करत रिहिन।’ तब तुमन ला गोसेन के इलाका म रहे बर मिलही, काबरकि मिसरीमन जम्मो चरवाहामन ले घिन करथें।” ");
INSERT INTO hne_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","यूसुफ ह फिरौन करा जाके ये समाचार दीस, “मोर ददा अऊ भाईमन अपन भेड़-बकरी, गाय-बईला अऊ अपन जम्मो सामान सहित कनान देस ले आ गे हवंय अऊ अभी ओमन गोसेन म हवंय।” ");
INSERT INTO hne_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ओह अपन भाईमन ले पांच झन ला चुनिस अऊ ओमन ला फिरौन करा लानिस। ");
INSERT INTO hne_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फिरौन ह ओकर भाईमन ले पुछिस, “तुमन के का धंधा अय?” ओमन फिरौन ला कहिन, “तोर सेवकमन चरवाहा अंय, अऊ हमर पुरखामन घलो चरवाहा रिहिन।” ");
INSERT INTO hne_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ओमन ओला ये घलो कहिन, “हमन इहां कुछू समय तक रहे बर आय हन, काबरकि कनान म भारी अकाल परे हे अऊ तोर सेवकमन के पसु बर कुछू चारा नइं बचे हे। एकरसेति, किरपा करके अपन सेवकमन ला गोसेन म रहे के हुकूम दे।” ");
INSERT INTO hne_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","फिरौन ह यूसुफ ला कहिस, “तोर ददा अऊ तोर भाईमन तोर करा आय हवंय, ");
INSERT INTO hne_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","अऊ मिसर देस तोर आघू म हवय; ये देस के सबले बने भाग म अपन ददा अऊ अपन भाईमन ला बसा दे, याने कि ओमन ला गोसेन म ही रहन दे। अऊ यदि तें जानत हस कि ओमा के कोनो म बिसेस योग्यता हवय, त ओला मोर पसुमन के ऊपर मुखिया ठहिरा दे।” ");
INSERT INTO hne_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","तब यूसुफ ह अपन ददा याकूब ला फिरौन करा लेके आईस। जब याकूब ह फिरौन ला आसीस दे डारिस, ");
INSERT INTO hne_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","तब फिरौन ह याकूब ले पुछिस, “तोला कतेक साल होवथे?” ");
INSERT INTO hne_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकूब ह फिरौन ला कहिस, “मेंह एक सौ तीस बछर परदेसी होके अपन जिनगी जी डारे हंव। मोर जिनगी के उमर ह थोरकून रिहिस अऊ कठिन रिहिस अऊ मोर पुरखामन परदेसी होके जतेक बछर तक जीयत रिहिन, में ओतेक बछर के नइं होय हंव।” ");
INSERT INTO hne_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","तब याकूब ह फिरौन ला आसीस देके ओकर आघू ले चल दीस। ");
INSERT INTO hne_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","तब यूसुफ ह अपन ददा अऊ अपन भाईमन ला मिसर देस म बसा दीस, अऊ फिरौन के हुकूम के मुताबिक देस के सबले बने भाग, याने कि रामसेस नांव के जिला म ओमन ला जमीन दीस। ");
INSERT INTO hne_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","यूसुफ ह अपन ददा ला अऊ अपन भाईमन ला अऊ अपन ददा के घर के जम्मो मनखेमन ला ओमन के लइकामन के गनती के मुताबिक भोजन-बस्तु घलो दीस। ");
INSERT INTO hne_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ओ जम्मो देस म खाय बर कुछू नइं रिहिस, काबरकि बहुंत भारी अकाल परे रिहिस; मिसर अऊ कनान म बहुंत कठिन समय रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","मिसर अऊ कनान के मनखेमन जऊन रूपिया-पईसा देके अनाज बिसात रिहिन, ओ जम्मो रूपिया ला यूसुफ ह जमा करके फिरौन के महल म ले आवत रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","जब मिसर अऊ कनान देस के मनखेमन के रूपिया ह सिरा गीस, त मिसर के जम्मो मनखेमन यूसुफ करा आईन अऊ कहिन, “हमन ला भोजन-बस्तु दे। का तोर रहत ले हमन मर जाबो? हमर जम्मो पईसा सिरा गे।” ");
INSERT INTO hne_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","यूसुफ ह कहिस, “यदि रूपिया नइं ए, त अपन पसुमन ला लानव, अऊ में ओकर बदला म तुमन ला भोजन-बस्तु दूहूं, काबरकि तुम्हर पईसा ह सिरा गे हे।” ");
INSERT INTO hne_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","एकरसेति ओमन अपन पसुमन ला यूसुफ करा लाय लगिन, अऊ ओह ओमन ला ओमन के घोड़ा, भेड़-बकरी, गाय-बईला अऊ गदहामन के बदला म भोजन-बस्तु देय लगिस। ओ साल ओह ओमन के जम्मो पसुमन के बदला म भोजन-बस्तु देके ओमन के पालन-पोसन करिस। ");
INSERT INTO hne_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ओ बछर तो अइसने कट गीस, तब अगले साल ओमन ओकर करा आके कहिन, “हमन अपन मालिक ले ये बात ला छिपा नइं सकन कि हमर रूपिया-पईसा खतम हो गे अऊ हमर पसुमन तोर हो गे हंय; अब हमर मालिक के आघू म हमर करा हमर देहें अऊ जमीन के छोंड़ अऊ कुछू नइं बांचे हे। ");
INSERT INTO hne_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","हमन तोर देखत म काबर मर जावन, अऊ हमर जमीन ह काबर उजाड़ हो जावय? हमन ला अऊ हमर जमीन ला भोजन-बस्तु के बदला म बिसा ले, अऊ हमन अपन जमीन सहित फिरौन के गुलामी म रहिबो। हमन ला बीजा दे कि हमन जीयत रहन अऊ मरन झन, अऊ जमीन ह उजाड़ झन होवय।” ");
INSERT INTO hne_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","तब यूसुफ ह मिसर के जम्मो जमीन ला फिरौन बर बिसा लीस। मिसर के जम्मो मनखेमन अपन जमीन बेच दीन, काबरकि उहां भयंकर अकाल परे रिहिस। जम्मो जमीन ह फिरौन के हो गीस, ");
INSERT INTO hne_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","अऊ यूसुफ ह मनखेमन ला मिसर देस के एक छोर ले लेके दूसर छोर तक गुलाम बना दीस। ");
INSERT INTO hne_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","पर ओह पुरोहितमन के जमीन ला नइं बिसाईस, काबरकि ओमन ला फिरौन कोति ले नियम के मुताबिक बांटा मिलत रिहिस अऊ फिरौन के दुवारा दिये गय बांटा म ओमन बर परयाप्त भोजन के परबंध रिहिस। एकरसेति ओमन अपन जमीन नइं बेचिन। ");
INSERT INTO hne_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","यूसुफ ह मनखेमन ला कहिस, “सुनव, मेंह आज तुमन ला अऊ तुम्हर जमीन ला फिरौन बर बिसा ले हंव; देखव, तुमन बर इहां बीजा हवय; येला लेवव अऊ भुइयां म बोवव। ");
INSERT INTO hne_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","पर जब फसल होथे, त ओकर पांचवां हिस्सा फिरौन ला देवव। बाकि के चार हिस्सा तुम्हर होही, जेला तुमन खेत म बोये बर अऊ अपन अऊ अपन घर के मनखे अऊ लइकामन के खाय बर उपयोग करव।” ");
INSERT INTO hne_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ओमन कहिन, “तेंह हमर जिनगी ला बंचाय हस; हमर परभू के किरपा के नजर हमर ऊपर बने रहय; हमन फिरौन के गुलामी म रहिबो।” ");
INSERT INTO hne_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ये किसम ले, यूसुफ ह मिसर के जमीन के बारे म येला कानून के रूप म कर दीस, जऊन ह आज तक लागू हवय कि फसल के पांचवां हिस्सा फिरौन के अय। सिरिप पुरोहितमन के जमीन ह फिरौन के नइं होईस। ");
INSERT INTO hne_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इसरायलीमन मिसर देस के गोसेन के इलाका म बस गीन। ओमन उहां धन-संपत्ति कमाईन अऊ फूलिन-फरिन अऊ गनती म बहुंत बढ़ गीन। ");
INSERT INTO hne_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याकूब ह मिसर देस म सतरह बछर तक जीयत रिहिस, अऊ ओकर जिनगी के कुल उमर एक सौ सैंतालीस बछर होईस। ");
INSERT INTO hne_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","जब इसरायल के मरे के समय ह लकठा आईस, तब ओह अपन बेटा यूसुफ ला बुलवाईस अऊ ओला कहिस, “यदि तोर किरपा मोर ऊपर हवय, त अपन हांथ ला मोर जांघ के तरी म रख अऊ परतिगियां कर कि तें मोर ऊपर किरपा करके सच्चई से ये काम ला करबे। मोला मिसर म माटी झन देबे, ");
INSERT INTO hne_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","पर जब में अपन पुरखामन के सहीं मर जावंव, त मोला मिसर ले बाहिर ले जाबे अऊ उहां माटी देबे, जिहां मोर पुरखामन ला माटी दे गे हवय।” तब यूसुफ ह कहिस, “में तोर बचन के मुताबिक करहूं।” ");
INSERT INTO hne_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","फेर याकूब ह कहिस, “मोर ले किरिया खा।” तब यूसुफ ह ओकर ले किरिया खाईस, अऊ इसरायल ह अपन लउठी के मुठ के ऊपर निहरके परमेसर के अराधना करिस। ");
INSERT INTO hne_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","कुछू समय के बाद, यूसुफ ला ये बताय गीस, “तोर ददा ह बेमार हे।” तब ओह अपन दूनों बेटा मनस्से अऊ एपरैम ला अपन संग लेके ओकर करा गीस। ");
INSERT INTO hne_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","जब याकूब ला बताय गीस, “तोर बेटा यूसुफ ह तोर करा आय हवय,” त इसरायल ह अपनआप ला संभालके बिस्तर म बईठ गीस। ");
INSERT INTO hne_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","याकूब ह यूसुफ ला कहिस, “सर्वसक्तिमान परमेसर ह कनान देस के लूज नगर म मोला दरसन दीस, अऊ उहां ओह मोला आसीस दीस, ");
INSERT INTO hne_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","अऊ कहिस, ‘देख, में तोला फलवंत करहूं अऊ गनती म तोला बढ़ाहूं। मेंह तोला मनखेमन के एक समाज बनाहूं, अऊ तोर पाछू तोर संतानमन ला ये देस सदाकाल बर दे दूहूं।’ ");
INSERT INTO hne_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“अब, तोर दूनों बेटा, जऊन मन मिसर म मोर आय के पहिली जनमे हवंय, ओमन मोर गने जाहीं; जइसने कि रूबेन अऊ सिमोन मोर अंय, वइसने ही मनस्से अऊ एपरैम घलो मोर होहीं। ");
INSERT INTO hne_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ओमन के बाद, तोर कोनो लइका जनमथें, त ओमन तोर होहीं; पर अपन बंटवारा म, ओमन अपन भाईमन के नांव म गने जाहीं। ");
INSERT INTO hne_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","जब में पदन ले वापिस आवत रहेंव, त मोर बर दुख के बात ये होईस कि डहार म ही एपराता हबरे के थोरकून पहिले, राहेल ह कनान देस म मर गीस। एकरसेति मेंह ओला उहां एपराता (बैतलहम) जाय के डहार तीर म माटी दे देंव।” ");
INSERT INTO hne_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","जब इसरायल ह यूसुफ के बेटामन ला देखिस, त ओह पुछिस, “येमन कोन एं?” ");
INSERT INTO hne_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","यूसुफ ह अपन ददा ला कहिस, “ये मोर बेटामन अंय, जेमन ला परमेसर ह मोला इहां दे हवय।” तब इसरायल ह कहिस, “ओमन ला मोर करा लान कि में ओमन ला आसीस देवंव।” ");
INSERT INTO hne_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इसरायल के आंखीमन बुढ़ापा के कारन धुंधला गे रिहिन, अऊ ओला बहुंत कम दिखत रिहिस। एकरसेति यूसुफ अपन बेटामन ला ओकर लकठा म ले आईस, अऊ ओकर ददा ह ओमन ला चूमिस अऊ ओमन ला पोटार लीस। ");
INSERT INTO hne_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","तब इसरायल ह यूसुफ ला कहिस, “में कभू आसा नइं करे रहेंव कि में तोर चेहरा फेर देखहूं, पर देख, परमेसर ह मोला तोर लइकामन ला घलो देखाईस।” ");
INSERT INTO hne_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","तब यूसुफ ह अपन बेटामन ला इसरायल के माड़ीमन के बीच ले हटाईस अऊ अपन मुहूं के भार गिरके दंडवत करिस। ");
INSERT INTO hne_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","अऊ यूसुफ ह ओ दूनों ला लीस, अऊ एपरैम ला अपन जेवनी कोति, याने कि इसरायल के डेरी हांथ कोति अऊ मनस्से ला अपन डेरी कोति, याने कि इसरायल के जेवनी हांथ कोति रखिस, अऊ ओमन ला इसरायल के लकठा म लानिस। ");
INSERT INTO hne_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","पर इसरायल ह अपन जेवनी हांथ बढ़ाके एपरैम के मुड़ ऊपर रखिस, हालाकि ओह छोटे रिहिस, अऊ अपन डेरी हांथ बढ़ाके मनस्से के मुड़ ऊपर रख दीस, हालाकि मनस्से ह पहिले जनमे रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","तब ओह यूसुफ ला आसीस दीस अऊ कहिस, “परमेसर जेकर आघू म मोर बाप-ददा अब्राहम अऊ इसहाक सच्चई से चलिन, ओ परमेसर, जऊन ह मोर जनम ले लेके आज तक मोर चरवाहा बने हे, ");
INSERT INTO hne_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ओ स्वरगदूत, जऊन ह मोला जम्मो बुरई ले बचाय हे —ओही ह ये लड़कामन ला आसीस देवय। येमन मोर नांव अऊ मोर बाप-ददा अब्राहम अऊ इसहाक के नांव से जाने जावंय, अऊ येमन धरती ऊपर गनती म बहुंत बढ़ंय।” ");
INSERT INTO hne_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","जब यूसुफ ह देखिस कि ओकर ददा ह अपन जेवनी हांथ एपरैम के मुड़ ऊपर रखे हे, त ये बात ओला खराप लगिस; एकरसेति ओह अपन ददा के जेवनी हांथ ला ये बिचार से धरिस कि ओला एपरैम के मुड़ ले हटाके मनस्से के मुड़ ऊपर रखय। ");
INSERT INTO hne_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","अऊ यूसुफ ह अपन ददा ला कहिस, “नइं, हे ददा, येह पहिले जनमे हे; अपन जेवनी हांथ ला एकर मुड़ ऊपर रख।” ");
INSERT INTO hne_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","पर ओकर ददा ह मना करिस अऊ कहिस, “में जानत हंव, मोर बेटा, में जानत हंव। एकर दुवारा घलो मनखेमन के एक समाज बनही, अऊ येह घलो महान होही। तभो ले एकर छोटे भाई एकर ले जादा महान होही, अऊ ओकर बंस ह कतको जाति के मनखेमन के एक झुंड हो जाही।” ");
INSERT INTO hne_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ओ दिन, ओह ओमन ला आसीस दीस अऊ कहिस, “तोर नांव म इसरायल ह अइसन आसीस दीही: ‘परमेसर तोला एपरैम अऊ मनस्से के सहीं बनाय।’ ” ये किसम ले ओह एपरैम ला मनस्से के पहिले रखिस। ");
INSERT INTO hne_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","तब इसरायल ह यूसुफ ला कहिस, “देख, में तो मरनेवाला हंव, पर परमेसर ह तुमन के संग रहिही, अऊ तुमन ला तुम्हर पुरखामन के देस म वापिस ले जाही। ");
INSERT INTO hne_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","अऊ मेंह तोला तोर भाईमन ले एक ठन जादा पहाड़ी जमीन देवत हंव, जेला मेंह अमोरीमन ले अपन तलवार अऊ धनुस के बल म ले रहेंव।” ");
INSERT INTO hne_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","तब याकूब ह अपन बेटामन ला बलाके कहिस: “ये मेर जूरव ताकि में तुमन ला बता सकंव कि अवइया दिन म तुम्हर ऊपर का होवइया हे। ");
INSERT INTO hne_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“हे याकूब के बेटामन, ये मेर जूरव अऊ सुनव; अपन ददा इसरायल के बात ला सुनव। ");
INSERT INTO hne_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“रूबेन, तें मोर पहिले जनमे बेटा अस, तें मोर सक्ति अऊ मोर ताकत के पहिली फर अस, तें आदर के लईक, अऊ ताकत म उत्तम अस। ");
INSERT INTO hne_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","तें जो पानी के लहरा सहीं उफननेवाला अस, तें अब उत्तम नइं ठहिरबे, काबरकि तें अपन ददा के बिछौना ऊपर चघे, मोर खटिया ऊपर चघे अऊ ओला असुध करे। ");
INSERT INTO hne_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“सिमोन अऊ लेवी तो भाई-भाई अंय— ओमन के तलवारमन हिंसा करे के हथियार अंय। ");
INSERT INTO hne_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","मोला ओमन के सभा म झन जाना पड़य, मोला ओमन के संगत म झन रहना पड़य, काबरकि ओमन अपन कोप म मनखेमन ला मार डारे हवंय अऊ अपन खुसी बर बईलामन ला खोरवा कर दे हवंय। ");
INSERT INTO hne_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","धिक्कार ए ओमन के कोप ला, जेह भयंकर रिहिस, अऊ ओमन के कोरोध ला, जेह बहुंत निरदयी रिहिस! मेंह ओमन ला याकूब म फईला दूहूं अऊ इसरायल म तितिर-बितिर कर दूहूं। ");
INSERT INTO hne_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“हे यहूदा, तोर भाईमन तोर परसंसा करहीं; तोर हांथ ह तोर बईरी के घेंच म होही; तोर ददा के बेटामन तोला दंडवत करहीं। ");
INSERT INTO hne_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","हे यहूदा, तेंह सेर के पीला अस; हे मोर बेटा, तें सिकार करके लहुंटे हस। सेर के सहीं, ओह बरताव करके बईठ जाथे, सेरनी के सहीं—कोन ह ओला छेड़े के हिम्मत करथे। ");
INSERT INTO hne_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","राजदंड ह यहूदा करा ले नइं जावय, अऊ न ही सासन करइया के छड़ी ह ओकर बंस ले अलग होही, जब तक कि ओह नइं आ जाही, जेकर ये चीजमन अंय अऊ जाति-जाति के मनखेमन ओकर बस म नइं हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ओह अपन गदहा ला अंगूर के नार म, अऊ अपन गदहा के पीला ला उत्तम नार म बांधही; ओह अपन ओनहा ला अंगूर के मंद म, अऊ अपन पहिरावा ला अंगूर के रस म धोही। ");
INSERT INTO hne_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ओकर आंखीमन अंगूर के मंद ले जादा गहिरा रंग, अऊ ओकर दांतमन दूध ले जादा सफेद होहीं। ");
INSERT INTO hne_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“जबूलून ह समुंदर के तीर म निवास करही अऊ पानी जहाजमन बर बंदरगाह के काम करही; ओकर सीमना ह सीदोन कोति बढ़ही। ");
INSERT INTO hne_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साकार एक बलवान गदहा अय, जेह भेड़मन के भेड़साला म ढलंगे रहिथे। ");
INSERT INTO hne_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","जब ओह देखथे कि ओकर सुसताय के जगह ह कतेक बने हे अऊ ओकर जमीन ह कतेक मनोहर हे, त ओह बोझा ला लेय बर अपन कंधा ला नवाथे अऊ बंधुवा मजदूर बन जाथे। ");
INSERT INTO hne_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“दान ह इसरायल के एक गोत्र के रूप म अपन मनखेमन के नियाय करही। ");
INSERT INTO hne_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान ह सड़क के तीर म एक सांप, रसता के तीर म एक जहरिला सांप सहीं होही, जेह घोड़ा के एड़ी ला डसथे, जेकर ले ओकर सवार ह पाछू कोति गिरथे। ");
INSERT INTO hne_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“हे यहोवा, में तोर दुवारा छुटकारा पाय के बाट जोहत हंव। ");
INSERT INTO hne_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“गाद के ऊपर हमला करइयामन के एक दल ह चढ़ई तो करही, पर ओह ओमन के पाछू कोति ले ओमन ऊपर हमला करही। ");
INSERT INTO hne_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“आसेर के भोजन-बस्तु ह उत्तम होही; अऊ ओह एक राजा के पसंद के सुवादवाला भोजन देय करही। ");
INSERT INTO hne_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“नपताली ह खुले म घुमनेवाला एक हिरनी सहीं अय, जऊन ह सुघर पीला जनथे। ");
INSERT INTO hne_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“यूसुफ एक फलवंत अंगूर के नार सहीं ए, ओह एक झरना के लकठा म एक फलवंत अंगूर के नार सहीं ए, जेकर डालीमन भीथी ऊपर चघके बगर जाथें। ");
INSERT INTO hne_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","धनुसधारीमन दुखी होके ओकर ऊपर हमला करिन; अऊ बईरता करके ओकर ऊपर तीर चलाईन। ");
INSERT INTO hne_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","पर ओकर धनुस इस्थिर रिहिस, याकूब के सक्तिसाली परमेसर के हांथ के कारन, ओ चरवाहा, इसरायल के चट्टान के कारन, ओकर बाहांमन फुरतिला होईन, ");
INSERT INTO hne_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","काबरकि तोर ददा के परमेसर ह तोर मदद करथे, काबरकि सर्वसक्तिमान ह तोला आसीस देथे, ये आसीस ह अकास के ऊपर के अय, ये आसीस ह गहिरा झरना के खाल्हे के अय, अऊ ये आसीस ह छाती अऊ गरभ के आसीस अय। ");
INSERT INTO hne_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तोर ददा के आसीसमन पुराना पहाड़मन के आसीस ले, पुराना पहाड़ीमन के दान ले घलो बड़े अंय। ये जम्मो आसीस यूसुफ के मुड़ म आवय, जऊन ह अपन भाईमन ले अलग होके राजा बन गीस, ओकर ललाट म आवय। ");
INSERT INTO hne_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“बिनयामीन ह एक भूखा भेड़िया सहीं अय; बिहनियां ओह सिकार ला मन भरके खाथे, अऊ सांझ के लूट के सामान ला बांट लेथे।” ");
INSERT INTO hne_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ये जम्मो इसरायल के बारह गोत्र अंय, अऊ ये ओ बातमन अंय, जेला ओमन के ददा ह ओमन ले कहिस जब ओह ओमन ला आसीस दीस; जइसने हर एक बर उचित रिहिस, वइसने ओह ओमन ला आसीस दीस। ");
INSERT INTO hne_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","तब याकूब ह ओमन ला हुकूम दीस: “बहुंत जल्दी मेंह मरके अपन पुरखामन संग मिलनेचवाला हंव। मोला हित्ती एपरोन के खेत के गुफा म मोर पुरखामन संग माटी दूहू, ");
INSERT INTO hne_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","याने कि ओ गुफा म जेह कनान देस म ममरे के लकठा म मकपेला के खेत म हवय, जेला अब्राहम ह हित्ती एपरोन ले खेत सहित एकरसेति बिसाय रिहिस कि ओला मरघटी बनावय। ");
INSERT INTO hne_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","उहां अब्राहम अऊ ओकर घरवाली सारा ला माटी देय गे रिहिस; उहां इसहाक अऊ ओकर घरवाली रिबका ला माटी देय गे रिहिस; अऊ उहां लिआ ला घलो माटी दे हंव। ");
INSERT INTO hne_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ओ खेत अऊ ओमा के गुफा ला हित्तीमन ले बिसाय गे रिहिस।” ");
INSERT INTO hne_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","जब याकूब ह अपन बेटामन ला हुकूम दे डारिस, त ओह अपन गोड़ ला खटिया ऊपर करके अपन परान ला छोंड़ दीस अऊ अपन पुरखामन संग जा मिलिस। ");
INSERT INTO hne_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","यूसुफ अपन ददा ला पोटारके रोईस अऊ ओला चूमिस। ");
INSERT INTO hne_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","तब यूसुफ ह अपन अधीन सेवा करइया बईदमन ला हुकूम दीस कि ओमन ओकर ददा इसरायल के लास म सुगंधित लेपन लगांय। तब बईदमन ओकर लास म सुगंधित रसायन लगा दीन। ");
INSERT INTO hne_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ओमन पूरा चालीस दिन तक सुगंधित रसायन लगाईन, काबरकि कोनो लास म सुगंधित रसायन लगाय बर अतेक दिन के जरूरत परय। अऊ मिसरी मनखेमन ओकर बर सत्तर दिन तक बिलाप करिन। ");
INSERT INTO hne_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","जब बिलाप करे के दिन पूरा हो गीस, तब यूसुफ ह फिरौन के घर के मनखेमन ला कहिस, “यदि तुम्हर किरपा मोर ऊपर हवय, त मोर कोति ले फिरौन ले बात करव। ओला कहव, ");
INSERT INTO hne_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘मोर ददा ह मोर ले किरिया खवाके कहे रिहिस, “देख, में मरनेचवाला हंव; मोला ओ कबर म माटी देबे, जेला मेंह अपन बर कनान देस म खनवाय हंव।” एकरसेति अब मोला उहां जाके मोर ददा ला माटी देवन दे; ओकर बाद, में वापिस आ जाहूं।’ ” ");
INSERT INTO hne_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फिरौन ह कहिस, “जा अऊ अपन ददा के खवाय किरिया के मुताबिक ओला माटी दे।” ");
INSERT INTO hne_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","तब यूसुफ ह अपन ददा ला माटी दे बर गीस। फिरौन के जम्मो करमचारी याने कि ओकर घर के सम्मानित मनखे अऊ मिसर देस के जम्मो सम्मानित मनखेमन ओकर संग गीन, ");
INSERT INTO hne_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","संग म यूसुफ के घर के जम्मो झन अऊ ओकर भाईमन अऊ ओकर ददा के घर के जम्मो मनखेमन घलो गीन। सिरिप ओमन के लइका अऊ भेड़-बकरी अऊ गाय-बईलामन गोसेन के इलाका म छूट गीन। ");
INSERT INTO hne_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","रथ अऊ घुड़सवारमन घलो ओकर संग म गीन। येह मनखेमन के एक बड़े दल रिहिस। ");
INSERT INTO hne_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","जब ओमन यरदन नदी के लकठा म, आताद के कोठार करा हबरिन, त ओमन उहां दुख ले भरे भारी बिलाप करे लगिन; अऊ उहां यूसुफ ह अपन ददा बर सात दिन तक सोक मनाईस। ");
INSERT INTO hne_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","जब ओ कनानी, जऊन मन उहां रहत रिहिन, आताद के कोठार करा बिलाप करत देखिन, त ओमन कहिन, “येह मिसरीमन के दुख ले भरे गंभीर बिलाप ए।” ओकरे कारन यरदन नदी के लकठा म ओ जगह के नांव आबेल-मिसरैम परिस। ");
INSERT INTO hne_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","इसरायल के बेटामन ठीक वइसने करिन, जइसने ओह ओमन ला हुकूम दे रिहिस: ");
INSERT INTO hne_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","याने कि ओमन ओला कनान देस म ले गीन अऊ ममरे के लकठा म, मकपेला के खेत के ओ गुफा म ओला माटी दीन, जेला अब्राहम ह हित्ती एपरोन ले खेत समेत एकरसेति बिसाय रिहिस कि ओह ओमन के मरघटी होवय। ");
INSERT INTO hne_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","अपन ददा ला माटी देय के बाद, यूसुफ ह मिसर देस लहुंट गीस, अऊ ओकर संग ओकर भाई अऊ ओ जम्मो झन, जेमन ओकर ददा ला माटी देय बर गे रिहिन, ओ जम्मो मनखे घलो मिसर देस लहुंट गीन। ");
INSERT INTO hne_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","जब यूसुफ के भाईमन देखिन कि ओमन के ददा मर गे हे, तब ओमन कहे लगिन, “यदि यूसुफ के मन म हमर बर बईरता होही, अऊ जतेक खराप काम हमन ओकर संग करे रहेंन, ओह ओकर बदला लीही, त का करबो।” ");
INSERT INTO hne_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","एकरसेति ओमन यूसुफ करा ये खबर भेजिन, “तोर ददा ह मरे के पहिली हमन ला ये हुकूम दे रिहिस, ");
INSERT INTO hne_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘तुमन यूसुफ ला अइसने कहिहू: मेंह कहत हंव कि तोर संग गलत बरताव करके तोर भाईमन तोर बिरूध म जऊन पाप अऊ अपराध करे रिहिन, ओकर बर तें ओमन ला छेमा कर।’ अब किरपा करके अपन ददा के परमेसर के सेवकमन के पाप ला छेमा कर।” ओमन के ये बात ला सुनके यूसुफ रो डारिस। ");
INSERT INTO hne_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ओकर बाद, ओकर भाईमन आईन अऊ ओकर आघू म गिरके कहिन, “देख, हमन तोर गुलाम अन।” ");
INSERT INTO hne_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","पर यूसुफ ह ओमन ला कहिस, “झन डरावव। का में परमेसर के जगह म हंव? ");
INSERT INTO hne_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","तुम्हर इरादा मोर संग हानि करे के रिहिस, पर परमेसर ह एकर दुवारा भलई करे के बिचार करिस, जऊन ह अब बहुंते झन के जिनगी बचाय के दुवारा पूरा होवत हे। ");
INSERT INTO hne_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","एकरसेति, अब झन डरावव। मेंह तुम्हर अऊ तुम्हर लइकामन के पालन-पोसन करहूं।” अऊ ओह ओमन ला फेर बिसवास देवाईस अऊ ओमन के संग बने ढंग से गोठियाईस। ");
INSERT INTO hne_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","यूसुफ अपन ददा के जम्मो घराना समेत मिसर म रहत रिहिस। ओह एक सौ दस बछर जीईस ");
INSERT INTO hne_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","अऊ तीसर पीढ़ी तक एपरैम के लइकामन ला देखे पाईस। मनस्से के बेटा, माकीर के लइकामन घलो जनम के बाद यूसुफ के कोरा म रखे गीन। ");
INSERT INTO hne_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","तब यूसुफ ह अपन भाईमन ला कहिस, “में तो मरनेचवाला हंव। पर परमेसर जरूर तुम्हर मदद करही अऊ तुमन ला ये देस ले निकालके ओ देस म ले जाही, जेकर परतिगियां ओह किरिया खाके अब्राहम, इसहाक अऊ याकूब ले करे रिहिस।” ");
INSERT INTO hne_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","अऊ यूसुफ ह इसरायलीमन ला किरिया खवाईस अऊ कहिस, “परमेसर जरूर तुम्हर मदद करे बर आही, अऊ तब तुमन मोर हाड़ामन ला ये जगह ले ओ देस म जरूर ले जावव।” ");
INSERT INTO hne_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ये किसम ले यूसुफ ह एक सौ दस बछर के उमर म मर गीस। अऊ ओमन ओकर लास म सुगंधित लेपन लगाईन, अऊ ओला मिसर म मुरदा रखे के एक सन्दूक म रख दीन।");
INSERT INTO hne_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ये इसरायल के बेटामन के नांव अंय, जऊन मन याकूब के संग अपन-अपन परिवार ला लेके मिसर देस गे रिहिन: ");
INSERT INTO hne_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, सिमोन, लेवी अऊ यहूदा; ");
INSERT INTO hne_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साकार, जबूलून अऊ बिनयामीन; ");
INSERT INTO hne_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान अऊ नपताली; गाद अऊ आसेर। ");
INSERT INTO hne_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकूब के संतानमन सत्तर झन रिहिन; अऊ यूसुफ ह पहिलेच ले मिसर म रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","समय के बीतत यूसुफ अऊ ओकर जम्मो भाई अऊ ओ पीढ़ी के जम्मो झन मर गीन, ");
INSERT INTO hne_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","पर इसरायलीमन बहुंत फूलत-फरत, संखिया म बहुंत हो गीन, गनती म बढ़त ओमन अतेक जादा हो गीन कि देस ह ओमन ले भर गीस। ");
INSERT INTO hne_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","तब मिसर देस म एक नवां राजा ह राज करन लगिस, जऊन ह यूसुफ ला नइं जानत रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ओह अपन मनखेमन ले कहिस, “देखव, इसरायलीमन गनती म अऊ बल म हमर ले बहुंत जादा हो गे हवंय। ");
INSERT INTO hne_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","आवव, हमन ओमन संग चतुरई से बरताव करन, अइसन झन होवय कि ओमन अऊ बढ़ जावंय अऊ, कहूं लड़ई सुरू हो जावय, त ओमन हमर बईरीमन संग जाके मिल जावंय, अऊ हमन ले लड़ंय अऊ देस छोंड़के चले जावंय।” ");
INSERT INTO hne_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","एकरसेति ओमन इसरायलीमन ऊपर मेटमन ला रखिन ताकि ओमन इसरायलीमन ले बंधुवा मजदूरी करवाके ओमन ला दुख देवंय अऊ ओमन फिरौन बर पितोम अऊ रामसेस ला भंडारघर के सहर के रूप म बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","पर जतेक जादा ओमन इसरायलीमन ला दुख दीन, ओतेक जादा इसरायलीमन बढ़त अऊ बगरत गीन; एकरसेति मिसरीमन इसरायलीमन ले डरे लगिन ");
INSERT INTO hne_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","अऊ मिसरीमन इसरायलीमन ले निरदयता से बुता कराय लगिन। ");
INSERT INTO hne_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ओमन गारा अऊ ईंटा बनवा-बनवाके, अऊ खेती के जम्मो बुता करवाके ओमन के जिनगी ला दुख ले भर दीन। ओमन ले जऊन कुछू बुता करवात रिहिन, बहुंत कड़ई ले करवात रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","तब मिसर के राजा ह इबरी धाईमन ले, जेमा के एक झन के नांव सिपरा अऊ दूसर के नांव पुआ रिहिस, कहिस, ");
INSERT INTO hne_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“जब तुमन इबरी माईलोगनमन ला छेवारी होय के बेरा म मदद करथव, त कहूं बाबू-पीला होवय, त ओला मार डारव, पर कहूं नोनी होवय, त ओला जीयत छोंड़ देवव।” ");
INSERT INTO hne_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","पर ओ धाईमन परमेसर के भय मानंय, एकरसेति मिसर के राजा के हुकूम ला नइं मानके बाबू-पीला ला घलो छोंड़ देवत रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तब मिसर के राजा ह ओ धाईमन ला बलाके पुछिस, “तुमन अइसन काबर करथव कि बाबू-पीलामन ला घलो जीयत छोंड़ देथव?” ");
INSERT INTO hne_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ओ धाईमन फिरौन ला जबाब दीन, “इबरी माईलोगनमन मिसरी माईलोगनमन कस नो हंय; ओमन अतेक दमदार हवंय कि धाईमन के हबरे के पहिली लइका जनमा लेथंय।” ");
INSERT INTO hne_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","एकरसेति परमेसर ह धाईमन ऊपर दया करिस अऊ इसरायली मनखेमन बढ़त गीन अऊ गनती म अऊ जादा हो गीन। ");
INSERT INTO hne_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","अऊ काबरकि धाईमन परमेसर के भय मानंय, त ओह ओमन के घर बसाईस। ");
INSERT INTO hne_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","तब फिरौन ह अपन जम्मो मनखेमन ला ये हुकूम दीस, “इबरीमन के जतेक बाबू-पीला जनमहीं, ओ जम्मो ला नील नदी म फेंक देवव अऊ जम्मो नोनीमन ला जीयत छोंड़ देवव।” ");
INSERT INTO hne_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी के गोत्र के एक मनखे ह लेवी गोत्र के ही एक माईलोगन ले बिहाव करिस, ");
INSERT INTO hne_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","अऊ ओह देहें म होईस अऊ एक बेटा ला जनम दीस। जब ओह देखिस कि लइका ह सुघर हवय, त ओह ओला तीन महिना ले लुकाके रखिस। ");
INSERT INTO hne_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","जब ओह ओला अऊ जादा लुकाय नइं सकिस, त ओह ओकर बर सरकंडा के एक ठन टुकनी लीस, अऊ ओमा डामर अऊ राल के लेप लगाईस। फेर ओह लइका ला ओमा सुताके नील नदी के खंड़ म नरकट कांदीमन के मांझा म छोंड़के आ गीस। ");
INSERT INTO hne_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ओ लइका के दीदी ह दूरिहा म ठाढ़ होके देखत रहय कि ओकर का गती होही। ");
INSERT INTO hne_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","तब फिरौन के बेटी ह नहाय बर नील नदी म गीस, अऊ ओकर सेविकामन नदी के तीर म चलत रिहिन। तब ओह नरकटमन के मांझा म टुकनी ला देखिस अऊ अपन सेविका ला पठोके ओ टुकनी ला लाने बर कहिस। ");
INSERT INTO hne_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","तब ओह टुकनी ला उघारके देखिस, त लइका ह रोवत रहय, अऊ ओला ओ लइका ऊपर दया आईस। ओह कहिस, “येह कोनो इबरी के लइका अय।” ");
INSERT INTO hne_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","तब लइका के बहिनी ह फिरौन के बेटी ले कहिस, “का मेंह जाके इबरी माईलोगन म ले कोनो धाई ला ले आवंव कि ओह तोर बर लइका ला दूध पीयाय?” ");
INSERT INTO hne_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फिरौन के बेटी ह ओला कहिस, “जा।” त ओ छोकरी ह गीस अऊ ओ लइका के महतारी ला ले आईस। ");
INSERT INTO hne_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फिरौन के बेटी ह ओला कहिस, “तें ये लइका ला ले जा अऊ मोर बर येला पाल-पोस, अऊ मेंह तोला येकर बनी दूहूं।” तब ओ माईलोगन ह लइका ला ले गीस अऊ ओकर पालन-पोसन करिस। ");
INSERT INTO hne_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","जब लइका ह बड़े हो गीस, त ओह ओला फिरौन के बेटी करा ले गीस अऊ फिरौन के बेटी ह ओला अपन बेटा मान लीस। ओह ओकर नांव ये कहिके मूसा रखिस, “मेंह ओला पानी म ले निकाले हंव।” ");
INSERT INTO hne_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","जब मूसा ह जवान होईस, त एक दिन ओह उहां गीस, जिहां ओकर खुद के इबरी मनखेमन रिहिन अऊ ओह ओमन के कठोर मेहनत ला देखिस। तब ओह देखिस कि एक मिसरी मनखे ह एक इबरी मनखे ला याने कि ओकर मनखेमन के एक झन ला मारत रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","तब मूसा ह एती-ओती देखिस, अऊ जब कोनो नइं दिखिन, त ओह ओ मिसरी मनखे ला मार डारिस, अऊ ओकर लास ला बालू म तोप दीस। ");
INSERT INTO hne_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ओकर दूसर दिन, मूसा ह बाहिर निकलिस, त दू झन इबरीमन ला झगरा करत देखिस। ओ दूनों म के जेकर गलती रिहिस, ओकर ले मूसा ह पुछिस, “तेंह अपन इबरी संगी ला काबर मारत हस?” ");
INSERT INTO hne_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","त ओ मनखे ह कहिस, “तोला कोन ह हमर ऊपर हाकिम अऊ नियाय करइया ठहिराय हवय? जइसने तेंह ओ मिसरी मनखे ला मार डारे रहय, वइसने का तेंह मोला घलो मार डारे चाहत हस?” येला सुनके मूसा ह डर गीस अऊ सोचिस, “जऊन कुछू मेंह करे हंव, ओला जरूर मनखेमन जान डारे होहीं।” ");
INSERT INTO hne_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","जब फिरौन ह ये बात ला सुनिस, त ओह मूसा ला मार डारे के कोसिस करिस, पर मूसा ह फिरौन करा ले भाग गीस अऊ मिदयान देस म रहे बर गीस, उहां एक ठन कुआं के तीर म बईठ गीस। ");
INSERT INTO hne_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिदयान देस म एक पुरोहित के सात झन बेटी रिहिन, जऊन मन अपन ददा के भेड़-बकरीमन ला पानी पीयाय खातिर ओ कुआं करा कोटना म पानी भरे बर आईन। ");
INSERT INTO hne_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","तभे कुछू चरवाहामन आईन अऊ ओमन ला उहां ले भगा दीन, पर मूसा ह उठिस अऊ ओ छोकरीमन के बचाव करिस अऊ ओमन के भेड़-बकरीमन ला पानी पीयाईस। ");
INSERT INTO hne_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","जब ओ छोकरीमन अपन ददा रूएल करा लहुंटके आईन, त ओह अपन बेटीमन ले पुछिस, “आज तुमन अतेक जल्दी कइसे लहुंटके आ गेव?” ");
INSERT INTO hne_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ओमन जबाब दीन, “एक मिसरी मनखे ह हमन ला चरवाहामन ले बचाईस, अऊ त अऊ ओह हमर बर पानी भरके हमर भेड़-बकरीमन ला पानी घलो पीयाईस।” ");
INSERT INTO hne_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","रूएल ह अपन बेटीमन ले पुछिस, “ओह कहां हवय? तुमन ओला काबर छोंड़ देव? ओला बलाके कुछू खाय बर देवव।” ");
INSERT INTO hne_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मूसा ह ओकर संग रहे बर राजी हो गीस, अऊ ओह अपन बेटी सिप्पोरा के बिहाव मूसा के संग कर दीस। ");
INSERT INTO hne_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","सिप्पोरा ह एक बेटा ला जनम दीस, अऊ मूसा ह ये कहिके ओकर नांव गेरसोम रखिस, “मेंह परदेस म एक परदेसी अंव।” ");
INSERT INTO hne_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","बहुंत समय बीते के बाद, मिसर देस के राजा ह मर गीस। इसरायलीमन गुलामी म कलहरत रिहिन अऊ छोंड़ाय बर चिचियाके गोहारत रिहिन, अऊ ओमन के मदद के पुकार ह ओमन के गुलामी के कारन परमेसर करा हबरिस। ");
INSERT INTO hne_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","परमेसर ह ओमन के कलहरई ला सुनके अपन करार ला सुरता करिस, जेला ओह अब्राहम, इसहाक अऊ याकूब के संग करे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","अऊ परमेसर ह इसरायलीमन कोति देखिस अऊ ओमन ऊपर धियान दीस। ");
INSERT INTO hne_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मूसा ह अपन ससुर यितरो, मिदयान देस के पुरोहित, के भेड़-बकरीमन ला चरात रिहिस; ओह बहुंत दूरिहा तक सुन्ना प्रदेस म भेड़-बकरीमन ला चराय बर ले गीस, अऊ परमेसर के पहाड़ होरेब मेर आईस। ");
INSERT INTO hne_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","उहां झाड़ी के बरत आगी म यहोवा के स्वरगदूत ह परगट होईस। मूसा ह देखिस कि झाड़ी म आगी तो लगे रिहिस, पर ओह जलके भसम नइं होवत रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","एकरसेति मूसा ह सोचिस, “मेंह ओ पार जाके ये अद्भूत चीज ला देखहूं कि झाड़ी ह काबर जलके खतम नइं होवत हे।” ");
INSERT INTO hne_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जब यहोवा ह देखिस कि ओह देखे बर उहां आवत हे, त परमेसर ह झाड़ी म ले ओला बलाईस, “हे मूसा! हे मूसा!” अऊ मूसा ह कहिस, “मेंह इहां हंव।” ");
INSERT INTO hne_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","यहोवा ह कहिस, “लकठा म झन आ, अऊ अपन पांव के पनही ला उतार ले, काबरकि जऊन ठऊर म तेंह ठाढ़े हस, ओह पबितर भुइयां ए।” ");
INSERT INTO hne_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","फेर ओह कहिस, “मेंह तोर पुरखामन के परमेसर, अब्राहम के परमेसर, इसहाक के परमेसर अऊ याकूब के परमेसर अंव।” ये सुनके मूसा ह अपन मुहूं ला छुपा लीस, काबरकि ओह परमेसर कोति देखे बर डरात रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","यहोवा ह कहिस, “मेंह सही म अपन मनखेमन के दुरगति ला मिसर देस म देखे हंव। अऊ मेटमन के दुख देय के कारन ओमन के रोवई ला घलो सुने हंव, मेंह ओमन के पीरा ला घलो जानत हंव। ");
INSERT INTO hne_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","एकरसेति मेंह ओमन ला मिसरीमन के हांथ ले बचाय बर उतरके आ गे हंव, ताकि ओमन ला ओ देस ले निकालके एक बढ़िया अऊ बड़े देस म ले जावंव, जिहां दूध अऊ मंधरस के भरमार हवय—जऊन ह कनानीमन, हित्तीमन, अमोरीमन, परिज्जीमन, हिब्बीमन अऊ यबूसीमन के घर अय। ");
INSERT INTO hne_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","अऊ अब इसरायलीमन के चिचियाई ह मोर करा हबरिस हवय, अऊ मेंह देखे हंव कि मिसरीमन ओमन के ऊपर कइसे अतियाचार करत हवंय। ");
INSERT INTO hne_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","एकरसेति अब, मेंह तोला फिरौन करा पठोवत हंव, तेंह जा अऊ मोर मनखे इसरायलीमन ला मिसर देस ले निकालके ले आ।” ");
INSERT INTO hne_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","पर मूसा ह परमेसर ला कहिस, “मेंह कोन अंव कि फिरौन करा जावंव अऊ इसरायलीमन ला मिसर देस ले निकालके ले आवंव?” ");
INSERT INTO hne_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","तब परमेसर ह कहिस, “मेंह तोर संग म रहिहूं। अऊ येह तोर बर चिनहां होही कि येह में अंव, जऊन ह तोला पठोय हवंव: जब तें ओ मनखेमन ला मिसर देस ले निकालके ले आबे, त तुमन इही पहाड़ म परमेसर के अराधना करहू।” ");
INSERT INTO hne_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मूसा ह परमेसर ला कहिस, “कहूं मेंह इसरायलीमन करा जाके ओमन ला कहंव, ‘तुम्हर पुरखामन के परमेसर ह मोला तुम्हर करा पठोय हवय,’ अऊ ओमन मोर ले पुछंय, ‘ओकर का नांव अय?’ त मेंह ओमन ला का जबाब दूहूं?” ");
INSERT INTO hne_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","परमेसर ह मूसा ला कहिस, “मेंह जो अंव सो अंव। तें इसरायलीमन ले कहिबे: ‘जेकर नांव में अंव, अय, ओही ह मोला तुम्हर करा पठोय हवय।’ ” ");
INSERT INTO hne_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","परमेसर ह मूसा ला ये घलो कहिस, “तें इसरायलीमन ला कहिबे, ‘यहोवा, तुम्हर पुरखामन के परमेसर—अब्राहम के परमेसर, इसहाक के परमेसर अऊ याकूब के परमेसर ह मोला तुम्हर करा पठोय हवय।’ “सदाकाल बर मोर नांव ह इहीच अय, अऊ पीढ़ी-पीढ़ी तक ले तुमन मोला इही नांव ले पुकारहू। ");
INSERT INTO hne_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“जा, अऊ इसरायल के अगुवामन ला इकट्ठा करके ओमन ले कह, ‘यहोवा, तुम्हर पुरखामन के परमेसर—अब्राहम, इसहाक अऊ याकूब के परमेसर ह परगट होके मोला कहिस: मेंह तुम्हर ऊपर नजर करे हंव अऊ देखे हंव कि मिसर देस म तुम्हर संग का बरताव करे गे हवय। ");
INSERT INTO hne_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","अऊ मेंह वायदा करे हंव कि तुमन ला मिसर म होवत दुरगति ले बाहिर निकालके कनानी, हित्ती, अमोरी, परिज्जी, हिब्बी अऊ यबूसीमन के देस म ले जाहूं, जिहां दूध अऊ मंधरस के भरमार हवय।’ ");
INSERT INTO hne_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“इसरायलीमन के अगुवामन तोर बात ला सुनहीं। तब तें अऊ इसरायलीमन के अगुवामन मिसर देस के राजा करा जाके ओला कहव, ‘यहोवा, इबरीमन के परमेसर ह हमन ला दरसन दे हवय, एकरसेति हमन ला तीन दिन के यातरा के दूरी म एक सुन्ना जगह म जावन दे, ताकि हमन यहोवा हमर परमेसर बर बलि चघा सकन।’ ");
INSERT INTO hne_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","पर मेंह जानत हंव मिसर देस के राजा ह तुमन ला जावन नइं दीही, जब तक कि एक ताकतवर हांथ ह ओला बिबस नइं कर दीही। ");
INSERT INTO hne_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","एकरसेति मेंह अपन हांथ बढ़ाहूं अऊ मिसरीमन के बीच ओ जम्मो अद्भूत काम करके ओमन ला मारहूं, ओकर बाद, ओह तुमन ला जावन दीही। ");
INSERT INTO hne_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“अऊ मेंह मिसरीमन ला अइसे कर दूहूं कि ओमन मोर ये इसरायली मनखेमन संग नरम बरताव करहीं, ताकि जब तुमन उहां ले निकलव, त जुच्छा हांथ झन निकलव। ");
INSERT INTO hne_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","तुम्हर हर एक माईलोगन अपन मिसरी परोसिन अऊ ओकर घर म रहइया माईलोगन ले सोन अऊ चांदी के जेवर अऊ कपड़ामन ला मांग लीही, जेला तुमन अपन बेटा-बेटीमन ला पहिरा दूहू। अऊ ये किसम ले तुमन मिसरीमन ला लूट लूहू।” ");
INSERT INTO hne_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","मूसा ह जबाब दीस, “मेंह का करहूं यदि ओमन मोर ऊपर बिसवास नइं करहीं या मोर बात ला नइं सुनके ये कहिहीं, ‘यहोवा ह तोला दरसन नइं दे हवय’?” ");
INSERT INTO hne_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","तब यहोवा ह ओला कहिस, “तोर हांथ म का हवय?” ओह जबाब दीस, “एक ठन लउठी।” ");
INSERT INTO hne_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","यहोवा ह कहिस, “ओला भुइयां म फटिक दे।” मूसा ह ओला भुइयां म फटिक दीस अऊ ओह एक सांप बन गीस, अऊ मूसा ह भागे लगिस। ");
INSERT INTO hne_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","तब यहोवा ह ओला कहिस, “अपन हांथ बढ़ाके ओकर पुंछी ला धर ले।” तब मूसा ह हांथ बढ़ाके ओ सांप ला धर लीस अऊ ओ सांप ह फेर ओकर हांथ म लउठी बन गीस। ");
INSERT INTO hne_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","यहोवा ह कहिस, “येला देखके ओमन बिसवास करहीं कि यहोवा, ओमन के पुरखामन के परमेसर—अब्राहम के परमेसर, इसहाक के परमेसर अऊ याकूब के परमेसर ह तोला दरसन दे हवय।” ");
INSERT INTO hne_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","तब यहोवा ह कहिस, “अपन हांथ ला अपन कपड़ा के भीतर छाती म रख।” अऊ मूसा ह अपन हांथ ला अपन कपड़ा के भीतर रखिस, अऊ जब ओह अपन हांथ ला बाहिर निकालिस, त देखिस कि ओकर हांथ के चमड़ी ह कोढ़ ले बरफ कस सादा हो गे हवय। ");
INSERT INTO hne_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","यहोवा ह कहिस, “अब अपन हांथ ला फेर अपन कपड़ा के भीतर रख,” मूसा ह वापिस अपन हांथ ला कपड़ा के भीतर रखिस, अऊ जब ओह अपन हांथ निकालके देखिस, त ओह पहिली कस जस के तस बने हो गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","तब यहोवा ह कहिस, “कहूं ओमन तोर बिसवास नइं करहीं या पहिली चिनहां ऊपर धियान नइं दीहीं, त दूसर चिनहां ऊपर बिसवास करहीं। ");
INSERT INTO hne_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","पर कहूं ओमन ये दूनों चिनहां ऊपर बिसवास नइं करहीं या तोर बात ला नइं सुनहीं, त तें नील नदी ले थोरकन पानी लेके सूखा भुइयां म डाल देबे। जऊन पानी ला तेंह नील नदी ले लेबे, ओह भुइयां म पड़ते ही लहू बन जाही।” ");
INSERT INTO hne_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","तब मूसा ह यहोवा ले कहिस, “हे परभू, अपन सेवक ला छेमा कर। मेंह कभू बने गोठियाय बर नइं जानेंव, पहिली घलो नइं जानत रहेंव, अऊ जब ले तेंह अपन सेवक ले गोठियावत हस, तब ले घलो। मेंह गोठियाय म धीमा अऊ जीभ के भद्दा अंव।” ");
INSERT INTO hne_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","यहोवा ह ओला कहिस, “मनखेमन के मुहूं ला कोन बनाईस? कोन ह ओमन ला भैंरा या कोंदा बनाथे? कोन ह ओमन के आंखी म रोसनी देथे या ओमन ला अंधरा बनाथे? का ये में यहोवा, नो हंव? ");
INSERT INTO hne_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","अब तें जा; मेंह तोर गोठियाय म मदद करहूं अऊ मेंह तोला बताहूं कि तोला का कहना हे।” ");
INSERT INTO hne_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","पर मूसा ह कहिस, “हे परभू, अपन सेवक ला छेमा कर, अऊ किरपा करके कोनो आने मनखे ला पठो दे।” ");
INSERT INTO hne_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तब यहोवा के गुस्सा ह मूसा ऊपर भड़किस अऊ ओह कहिस, “अपन भाई हारून के बारे म का सोचथस, जऊन ह लेवी अय? मेंह जानत हंव कि ओह बने गोठियाथे। ओह तोर ले भेंट करे बर आवत हे अऊ रसता म हवय, अऊ ओह तोला देखके खुस होही। ");
INSERT INTO hne_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","तें ओकर ले गोठियाबे अऊ बातमन ला ओकर मुहूं म डालबे; मेंह तुम्हर दूनों झन के गोठियाय म मदद करहूं अऊ तुमन ला बताहूं कि का करना हे। ");
INSERT INTO hne_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ओह तोर कोति ले मनखेमन संग गोठियाही, अऊ येह अइसने होही कि मानो ओह तोर मुहूं होही अऊ तेंह ओकर बर परमेसर कस होबे। ");
INSERT INTO hne_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","पर ये लउठी ला अपन हांथ म लेय ले; येकर दुवारा तेंह चिनहांमन ला देखाबे।” ");
INSERT INTO hne_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","तब मूसा ह अपन ससुर यितरो करा वापिस गीस अऊ ओला कहिस, “मोला लहुंटके मिसर देस म रहइया मोर अपन मनखेमन करा जावन दे ताकि मेंह पता लगावंव कि ओमन ले कोनो अब तक उहां जीयत बांचे हवंय कि नइं।” यितरो ह कहिस, “तेंह जा, अऊ मेंह तोर खुसी के कामना करत हंव।” ");
INSERT INTO hne_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","यहोवा ह मिदयान देस म ही मूसा ला कहे रिहिस, “मिसर देस ला वापिस चले जा, काबरकि ओ जम्मो झन मर चुके हवंय, जऊन मन तोला मार डारे बर चाहत रिहिन।” ");
INSERT INTO hne_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","तब मूसा ह अपन घरवाली अऊ अपन बेटामन ला गदहा ऊपर बईठाईस अऊ वापिस मिसर देस जाय लगिस। अऊ ओह परमेसर के लउठी ला अपन हांथ म ले लीस। ");
INSERT INTO hne_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","यहोवा ह मूसा ला कहिस, “जब तेंह मिसर म हबरबे, त देख, फिरौन के आघू म ओ जम्मो अद्भूत काम ला देखाबे, जेला देखाय के सक्ति मेंह तोला दे हवंव। पर मेंह ओकर मन ला कठोर कर दूहूं, जेकर कारन ओह इसरायलीमन ला जावन नइं दीही। ");
INSERT INTO hne_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","तब तें फिरौन ले कहिबे, ‘यहोवा ह ये कहत हे: इसरायल ह मोर पहिलांत बेटा अय, ");
INSERT INTO hne_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","अऊ मेंह तोला कह चुकेंव, “मोर बेटा ला जावन दे, ताकि ओह मोर अराधना करय।” पर तेंह ओला जावन नइं देवत हस; एकरसेति मेंह तोर पहिलांत बेटा ला मार डारहूं।’ ” ");
INSERT INTO hne_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","डहार म, एक ठन धरमसाला म यहोवा ह मूसा ले मिलिस, अऊ ओला मार डालनेवाला रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","पर सिप्पोरा ह एक धारवाला पथरा लीस अऊ अपन बेटा के खलड़ी ला काटिस अऊ ओ खलड़ी ला मूसा के गोड़ म छुआ दीस अऊ कहिस, “सही म, तेंह लहू बहानेवाला मोर दूल्हा अस।” ");
INSERT INTO hne_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","एकरसेति यहोवा ह मूसा ला छोंड़ दीस। (ओतेक बेरा सिप्पोरा ह खतना के हवाला देवत कहिस, “लहू बहानेवाला दूल्हा।”) ");
INSERT INTO hne_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","तब यहोवा ह हारून ला कहिस, “मूसा ले मिले बर निरजन प्रदेस म जा।” एकरसेति हारून ह मूसा ले मिले बर परमेसर के पहाड़ म गीस अऊ ओला चूमिस। ");
INSERT INTO hne_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","तब मूसा ह हारून ला ओ जम्मो बात बताईस, जेला बताय बर यहोवा ह ओला पठोय रिहिस, अऊ ओ जम्मो चिनहांमन के बारे म घलो बताईस, जेमन ला देखाय के हुकूम ओला दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","तब मूसा अऊ हारून इसरायलीमन के जम्मो अगुवामन ला इकट्ठा करिन, ");
INSERT INTO hne_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","अऊ हारून ह ओमन ला ओ जम्मो बात बताईस, जेला यहोवा ह मूसा ला कहे रिहिस। ओह मनखेमन के आघू म ओ चिनहांमन ला घलो देखाईस, ");
INSERT INTO hne_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","अऊ ओमन बिसवास करिन। अऊ जब ओमन सुनिन कि यहोवा ह ओमन के बारे म चिंतित हवय अऊ ओमन के दुरगति ला देखे हवय, त ओमन मुड़ नवाके यहोवा के अराधना करिन। ");
INSERT INTO hne_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","एकर बाद मूसा अऊ हारून फिरौन करा जाके कहिन, “यहोवा, इसरायल के परमेसर ह ये कहत हे: ‘मोर मनखेमन ला जावन दे कि ओमन निरजन प्रदेस म मोर बर एक तिहार मनावंय।’ ” ");
INSERT INTO hne_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","त फिरौन ह कहिस, “यहोवा ह कोन अय कि मेंह ओकर हुकूम ला मानंव अऊ इसरायलीमन ला जावन दंव? मेंह यहोवा ला नइं जानंव अऊ मेंह इसरायलीमन ला नइं जावन दंव।” ");
INSERT INTO hne_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","तब मूसा अऊ हारून कहिन, “इबरीमन के परमेसर ह हमर ले मुलाकात करे हवय। अब हमन ला तीन दिन के यातरा के दूरी म एक निरजन प्रदेस म जावन दे कि हमन यहोवा हमर परमेसर बर बलिदान चघावन, अइसन झन होवय कि ओह हमन ला महामारी या तलवार ले नास करय।” ");
INSERT INTO hne_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","पर मिसर देस के राजा ह कहिस, “मूसा अऊ हारून, तुमन मनखेमन ला ओमन के बुता ले काबर दूरिहा करे चाहत हव? तुमन वापिस अपन काम म लग जावव!” ");
INSERT INTO hne_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","तब फिरौन ह ये घलो कहिस, “देखव, अब देस म मनखेमन बहुंत हो गे हवंय, अऊ तुमन ओमन ला बुता करे बर रोकत हव।” ");
INSERT INTO hne_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ओहीच दिन फिरौन ह बेगारी करानेवाला अऊ मनखेमन के ऊपर मेटमन ला ये हुकूम दीस: ");
INSERT INTO hne_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“तुमन अब मनखेमन ला ईंटा बनाय बर भूंसा झन देवव; ओमन जावंय अऊ खुद अपन बर भूंसा संकेलंय। ");
INSERT INTO hne_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","पर जतेक ईंटा ओमन पहिली बनात रिहिन, ओतकेच ईंटा अब भी बनवाव; ईंटा के ठहिराय गनती म कमी झन करव, ओमन आलसी अंय; एकरसेति ओमन चिचियाके कहत हवंय, ‘आवव, हमन जावन अऊ हमर परमेसर बर बलिदान चघावन।’ ");
INSERT INTO hne_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ओ मनखेमन के काम ला अऊ बढ़ा दव ताकि ओमन काम म ही लगे रहंय, अऊ लबारी गोठमन म धियान झन लगावंय।” ");
INSERT INTO hne_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","तब बेगारी करानेवाला अऊ मेटमन बाहिर निकलिन अऊ इसरायली मनखेमन ला कहिन, “फिरौन ह ये कहत हे: ‘मेंह तुमन ला अब भूंसा नइं देवंव। ");
INSERT INTO hne_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","जावव अऊ तुमन अपन खुद के भूंसा लानव, जिहां कहूं भी येह तुमन ला मिलथे, पर तुम्हर काम म कोनो भी किसम ले कमी नइं करे जावय।’ ” ");
INSERT INTO hne_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","एकरसेति इसरायलीमन फसल के खूंटी संकेले बर पूरा मिसर देस म बगर गीन ताकि भूंसा के जगह म ओकर उपयोग कर सकंय। ");
INSERT INTO hne_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","बेगारी करवइयामन ये कहिके ओमन ऊपर दबाव बनाय रखिन, “हर एक दिन बर ठहिराय गे काम ला अब भी वइसने ही पूरा करव, जइसने तुमन पहिली करत रहेव, जब तुम्हर करा भूंसा रिहिस।” ");
INSERT INTO hne_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","फिरौन के बेगारी करवइयामन अपन दुवारा ठहिराय इसरायली मेटमन ला मारंय-पीटंय अऊ पुछंय, “तुमन काबर ठहिराय गय ईंटा के संखिया के मुताबिक कल या आज ईंटा नइं बनाय हव, जइसे कि पहिले बनात रहेव?” ");
INSERT INTO hne_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","तब इसरायली मेटमन फिरौन करा जाके गोहारे लगिन, “तेंह अपन सेवकमन के संग अइसने बरताव काबर करत हस? ");
INSERT INTO hne_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","तोर सेवकमन ला भूंसा नइं दिये जावत हे, तभो ले हमन ला कहे जाथे, ‘ईंटा बनावव!’ तोर सेवकमन ला मारे-पीटे जावत हे, पर गलती तो तोर खुद के मनखेमन के अय।” ");
INSERT INTO hne_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फिरौन ह कहिस, “तुमन आलसी अव, आलसी! एकरसेति तुमन कहत रहिथव, ‘हमन ला जावन दे कि हमन यहोवा बर बलि चघावन।’ ");
INSERT INTO hne_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","अब जावव अऊ अपन काम करव। तुमन ला कोनो भूंसा नइं दिये जावय, तभो ले तुमन ला अपन निरधारित भाग के ईंटा बनाना जरूरी अय।” ");
INSERT INTO hne_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","इसरायली मेटमन समझ गीन कि ओमन परेसानी म पड़ गे हवंय, जब ओमन ला कहे गीस, “हर दिन बर ठहिराय गय तुम्हर ईंटा के गनती ला कम नइं करे जावय।” ");
INSERT INTO hne_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","जब ओमन फिरौन करा ले मिलके आईन, त मूसा अऊ हारून ओमन के डहार देखत रिहिन, ");
INSERT INTO hne_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","अऊ ओमन मूसा अऊ हारून ला कहिन, “यहोवा ह तुमन ला देखय अऊ तुम्हर नियाय करय! तुमन हमन ला फिरौन अऊ ओकर अधिकारीमन के नजर म घिन करे के चीज बना दे हव अऊ हमन ला मारे बर ओमन के हांथ म एक तलवार देय दे हव।” ");
INSERT INTO hne_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","मूसा ह यहोवा करा गीस अऊ कहिस, “काबर, हे परभू, तेंह काबर ये मनखेमन ऊपर ये समस्या लाने हस? का एकर खातिर तेंह मोला पठोय रहय? ");
INSERT INTO hne_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","जब ले मेंह तोर नांव म फिरौन करा गोठियाय बर गेंव, तब ले ओह ये मनखेमन ऊपर समस्या लाने हवय, अऊ तेंह अपन मनखेमन के कुछू बचाव नइं करे हस।” ");
INSERT INTO hne_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तब यहोवा ह मूसा ला कहिस, “अब तेंह देखबे कि मेंह फिरौन के का करहूं: मोर सक्तिसाली हांथ के कारन ओह इसरायलीमन ला जावन दीही अऊ ओह ओमन ला अपन देस ले भगा दीही।” ");
INSERT INTO hne_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","परमेसर ह मूसा ला ये घलो कहिस, “मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","मेंह सर्वसक्तिमान परमेसर के रूप म अब्राहम, इसहाक अऊ याकूब ला दरसन दे हंव, पर अपन नांव यहोवा के दुवारा मेंह अपनआप ला ओमन ऊपर पूरा परगट नइं करेंव। ");
INSERT INTO hne_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","मेंह ओमन संग करार घलो करेंव कि ओमन ला कनान देस ला दूहूं, जिहां ओमन परदेसी के रूप म रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","अऊ मेंह इसरायलीमन के कलहरई ला सुने हंव, जेमन ले मिसरीमन गुलामी करवात हें, अऊ मेंह अपन करार ला सुरता करे हवंव। ");
INSERT INTO hne_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“एकरसेति इसरायलीमन ले कह: ‘मेंह यहोवा अंव, अऊ मेंह तुमन ला मिसरीमन के गुलामी ले बाहिर निकालहूं। मेंह तुमन ला ओमन के गुलामी ले छोंड़ाहूं, अऊ मेंह अपन बढ़ाय भुजा अऊ बड़े नियाय के दुवारा तुमन ला छोंड़ा लूहूं। ");
INSERT INTO hne_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","मेंह तुमन ला अपन खुद के मनखे सहीं अपना लूहूं, अऊ मेंह तुम्हर परमेसर होहूं। तब तुमन जान लूहू कि मेंह यहोवा तुम्हर परमेसर अंव, जऊन ह तुमन ला मिसरीमन के गुलामी ले बाहिर निकालिस। ");
INSERT INTO hne_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","अऊ मेंह तुमन ला ओ देस म लानहूं, जऊन ला मेंह अब्राहम, इसहाक, अऊ याकूब ला देय बर हांथ उठाके किरिया खाय रहेंव। मेंह ओला तुम्हर अधिकार म कर दूहूं। मेंह यहोवा अंव।’ ” ");
INSERT INTO hne_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","मूसा ह इसरायलीमन ला ये बात बताईस, पर अपन निरासा अऊ कठोर मेहनत के कारन ओमन मूसा के बात ला नइं सुनिन। ");
INSERT INTO hne_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“जा अऊ मिसर के राजा फिरौन ला कह कि ओह इसरायलीमन ला ओकर देस ले बाहिर जावन दे।” ");
INSERT INTO hne_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","पर मूसा ह यहोवा ला कहिस, “यदि इसरायलीमन मोर बात ला नइं सुनिन, त फेर फिरौन ह मोर बात ला काबर सुनही, जबकि बात करे म, मेंह हकलाथंव घलो?” ");
INSERT INTO hne_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","तब यहोवा ह मूसा अऊ हारून ले इसरायली अऊ मिसर के राजा फिरौन के बारे म बात करिस, अऊ ओह ओमन ला हुकूम दीस कि ओमन इसरायलीमन ला मिसर देस ले निकालके ले जावंय। ");
INSERT INTO hne_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","येमन अपन परिवारमन के मुखिया रिहिन: इसरायल के पहिलांत बेटा रूबेन के बेटामन: हनोक, अऊ पल्लू, हेसरोन अऊ करमी। ");
INSERT INTO hne_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","सिमोन के बेटामन: यमूएल, यामीन, ओहद, याकीन, सोहर अऊ साऊल जऊन ह एक कनानी माईलोगन के बेटा रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ओमन के लिखाय बंसावली के मुताबिक येमन लेवी के बेटा रिहिन: गेरसोन, कहात अऊ मरारी। ");
INSERT INTO hne_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गोत्र के मुताबिक गेरसोन के बेटामन: लिबनी अऊ सिमी। ");
INSERT INTO hne_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहात के बेटामन: अमराम, ईसहार, हेबरोन अऊ उजीएल। (कहात ह 133 बछर तक जीईस।) ");
INSERT INTO hne_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारी के बेटामन: महली अऊ मूसी। ");
INSERT INTO hne_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अमराम ह अपन फूफू योकेबेद ले बिहाव करिस, जेकर ले मूसा अऊ हारून पईदा होईन। ");
INSERT INTO hne_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ईसहार के बेटामन: कोरह, नेपेग अऊ जिकरी। ");
INSERT INTO hne_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उजीएल के बेटामन: मिसाएल, एलसाफान अऊ सितरी। ");
INSERT INTO hne_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारून ह अमीनादाब के बेटी, नहसोन के बहिनी एलीसेबा ले बिहाव करिस, अऊ ओह नादाब, अबीहू, एलिआजर अऊ ईतामार ला जनम दीस। ");
INSERT INTO hne_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरह के बेटामन: अस्सीर, एलकाना अऊ अबीआसाप। ");
INSERT INTO hne_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारून के बेटा एलिआजर ह पूतीएल के एक बेटी ले बिहाव करिस, अऊ ओह पीनहास ला जनम दीस। ");
INSERT INTO hne_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ये हारून अऊ मूसा रिहिन, जेमन ला यहोवा ह हुकूम दे रिहिस, “इसरायलीमन ला ओमन के दल के मुताबिक मिसर देस ले बाहिर निकालके लानव।” ");
INSERT INTO hne_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ये मूसा अऊ हारून रिहिन, जेमन इसरायलीमन ला मिसर देस ले बाहिर लाने बर मिसर के राजा फिरौन ले बात करिन। ");
INSERT INTO hne_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","जब यहोवा ह मिसर देस म मूसा ले गोठियाईस, ");
INSERT INTO hne_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","त ओह मूसा ला कहिस, “मेंह यहोवा अंव। जऊन कुछू मेंह तोला कहत हंव, ओ जम्मो बात तेंह मिसर के राजा फिरौन ला बता।” ");
INSERT INTO hne_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","पर मूसा ह यहोवा ला कहिस, “देख, मेंह बात करे म हकलाथंव, त फिरौन ह मोर बात ला काबर सुनही?” ");
INSERT INTO hne_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","तब यहोवा ह मूसा ला कहिस, “देख, मेंह फिरौन बर तोला परमेसर के सहीं बना दे हंव, अऊ तोर भाई हारून ह तोर अगमबानी करइया होही। ");
INSERT INTO hne_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","तोला ओ हर बात हारून ला कहना हे, जेकर हुकूम मेंह तोला देवत हंव, अऊ तोर भाई हारून ह फिरौन ला कहिही कि ओह इसरायलीमन ला अपन देस ले जावन दे। ");
INSERT INTO hne_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","पर मेंह फिरौन के मन ला कठोर कर दूहूं, अऊ हालाकि मेंह मिसर देस म बहुंते चिनहां अऊ अद्भूत काम ला देखाहूं, ");
INSERT INTO hne_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","पर ओह तोर बात ला नइं सुनही। तब मेंह मिसर देस ऊपर अपन हांथ डालके दंड दूहूं अऊ नियाय के बड़े काम के संग मेंह अपन दल, मोर मनखे इसरायलीमन ला मिसर देस ले निकाल लानहूं। ");
INSERT INTO hne_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","अऊ जब मेंह मिसर देस के बिरूध अपन हांथ बढ़ाहूं अऊ इसरायलीमन ला उहां ले निकाल लानहूं, त मिसरीमन जान लीहीं कि मेंह यहोवा अंव।” ");
INSERT INTO hne_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","मूसा अऊ हारून वइसनेच करिन जइसने यहोवा ह ओमन ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","मूसा के उमर अस्सी साल अऊ हारून के उमर तिरासी साल रिहिस, जब ओमन फिरौन ले बात करिन। ");
INSERT INTO hne_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","यहोवा ह मूसा अऊ हारून ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“जब फिरौन ह तुमन ले कहिथे, ‘अपन कोनो चमतकार देखावव,’ तब हारून ला कह, ‘अपन लउठी ला ले अऊ फिरौन के आघू म फटिक दे,’ अऊ ओह एक सांप बन जाही।” ");
INSERT INTO hne_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","मूसा अऊ हारून फिरौन करा गीन, अऊ वइसने ही करिन, जइसने यहोवा ह ओमन ला हुकूम देय रिहिस। हारून ह अपन लउठी ला फिरौन अऊ ओकर अधिकारीमन के आघू म फटिक दीस, अऊ ओह सांप बन गीस। ");
INSERT INTO hne_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तब फिरौन ह मिसर के पंडित अऊ जादूगरमन ला बुलवाईस, अऊ मिसर के जादूगरमन घलो अपन जादूगरी ले वइसनेच करिन। ");
INSERT INTO hne_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","हर एक झन अपन लउठी ला खाल्हे म फटकिन अऊ ओह सांप बन गीस। पर हारून के लउठी ह ओमन के लउठीमन ला लील लीस। ");
INSERT INTO hne_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","तभो ले फिरौन के मन ह कठोर बने रिहिस, अऊ ओह ओमन के नइं सुनिस, जइसे कि यहोवा ह कहे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तब यहोवा ह मूसा ला कहिस, “फिरौन के मन ह कठोर हो गे हवय; ओह मनखेमन ला जावन नइं देवथे। ");
INSERT INTO hne_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","फिरौन ह बिहनियां जब नदी कोति जाथे, तब नील नदी के तीर म ओकर सामना कर, अऊ अपन हांथ म ओहीच लउठी ला धरे रहिबे, जऊन ह सांप बन गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","तब ओला कहिबे, ‘यहोवा, इबरीमन के परमेसर ह मोला तोर करा ये कहे बर पठोय हवय: मोर मनखेमन ला जावन दे, ताकि ओमन निरजन प्रदेस म मोर अराधना करंय। पर अब तक तेंह मोर बात नइं सुने। ");
INSERT INTO hne_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","यहोवा ह ये कहत हे: मेंह नील नदी के पानी ला अपन हांथ के लउठी ले मारहूं अऊ ओह लहू म बदल जाही। एकर दुवारा तेंह जान लेबे कि मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","अऊ नील नदी के मछरीमन मर जाहीं, अऊ नदी ले बदबू आय लगही; अऊ मिसरीमन येकर पानी ला पी नइं सकहीं।’ ” ");
INSERT INTO hne_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","यहोवा ह मूसा ला कहिस, “हारून ले कह, ‘अपन लउठी ला ले अऊ मिसर देस के पानी याने कि उहां के नदी, नरवा, तरिया, नहर, अऊ जम्मो बांधामन कोति अपन हांथ ला लमा, जेकर से जम्मो पानी ह लहू म बदल जाही।’ मिसर देस म जम्मो जगह खूने-खून हो जाही, अऊ त अऊ लकरी अऊ पथरा के बने बरतनमन म घलो।” ");
INSERT INTO hne_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","मूसा अऊ हारून वइसने ही करिन, जइसने कि यहोवा ह हुकूम दे रिहिस। ओह अपन लउठी ला फिरौन अऊ ओकर अधिकारीमन के आघू म उठाईस अऊ नील नदी के पानी ला मारिस, अऊ जम्मो पानी ह लहू बन गीस। ");
INSERT INTO hne_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नील नदी के जम्मो मछरीमन मर गीन, अऊ नदी ह अतेक बदबू मारिस कि मिसरीमन येकर पानी ला पी नइं सकिन। पूरा मिसर देस ह लहूच लहू हो गीस। ");
INSERT INTO hne_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","मिसर के जादूगरमन घलो अपन जादूगरी ले वइसनेच करिन, अऊ फिरौन के मन ह कठोर बने रिहिस; ओह मूसा अऊ हारून के नइं सुनिस, जइसे कि यहोवा ह कहे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ये जम्मो बात के फिरौन ऊपर कोनो असर नइं होईस अऊ ओह लहुंटके अपन महल म चल दीस। ");
INSERT INTO hne_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","अऊ जम्मो मिसरीमन पीये के पानी बर नील नदी म खंचवा खने लगिन, काबरकि ओमन नदी के पानी ला पी नइं सकिन। ");
INSERT INTO hne_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","यहोवा के दुवारा नील नदी के पानी ला लहू बनाय सात दिन हो गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","तब यहोवा ह मूसा ला कहिस, “फिरौन करा जा अऊ ओला कह, ‘यहोवा ह ये कहत हे: मोर मनखेमन ला जावन दे, ताकि ओमन मोर अराधना कर सकंय। ");
INSERT INTO hne_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","कहूं तेंह ओमन ला जावन नइं देबे, त मेंह तोर जम्मो देस म मेचकामन ले महामारी पठोहूं। ");
INSERT INTO hne_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नील नदी ह मेचकामन ले भर जाही। ओमन तोर महल अऊ तोर सुते के खोली म अऊ तोर दसना म, तोर करमचारीमन के घर म अऊ तोर मनखेमन ऊपर, अऊ तुम्हर चूल्हा अऊ तुम्हर पीसान गुंथे के बरतनमन म भर जाहीं। ");
INSERT INTO hne_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","मेचकामन तोर अऊ तोर मनखे अऊ तोर जम्मो करमचारीमन ऊपर चघ जाहीं।’ ” ");
INSERT INTO hne_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","तब यहोवा ह मूसा ला कहिस, “हारून ले कह, ‘हांथ म लउठी ला लेके अपन हांथ ला पानी के सोता अऊ नहर अऊ तरियामन ऊपर कर, अऊ मेचकामन ला मिसर देस म ले आन।’ ” ");
INSERT INTO hne_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","त हारून ह मिसर के पानी के जगहमन ऊपर अपन हांथ ला लमाईस, अऊ मेचकामन आके मिसर देस म भर गीन। ");
INSERT INTO hne_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","पर मिसर के जादूगरमन घलो अपन जादूगरी ले वइसने ही करिन; ओमन मिसर देस म मेचकामन ला ले आईन। ");
INSERT INTO hne_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","फिरौन ह मूसा अऊ हारून ला बलाके कहिस, “यहोवा ले पराथना करव कि ओह मेचकामन ला मोर ले अऊ मोर मनखेमन ले हटा ले, अऊ मेंह तुम्हर मनखेमन ला जावन दूहूं कि ओमन यहोवा बर बलि चघावंय।” ");
INSERT INTO hne_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मूसा ह फिरौन ला कहिस, “मेंह तोर ऊपर छोंड़त हंव; तेंह मोला बता कि कतेक बेरा तोर अऊ तोर करमचारी अऊ तोर मनखेमन बर पराथना करंव कि ये मेचकामन तुमन अऊ तुम्हर घर ला छोंड़के चले जावंय, अऊ ओहीच मेचकामन रहंय, जेमन नील नदी म हवंय।” ");
INSERT INTO hne_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फिरौन ह कहिस, “कल।” मूसा ह कहिस, “वइसने ही होही, जइसने तेंह कहत हस, ताकि तेंह जान लेबे कि यहोवा हमर परमेसर के सहीं अऊ कोनो नइं ए। ");
INSERT INTO hne_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","मेचकामन तुमन अऊ तुम्हर घरमन ला, तोर करमचारी अऊ तोर मनखेमन ला छोंड़के चले जाहीं; ओमन सिरिप नील नदी म ही रहिहीं।” ");
INSERT INTO hne_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","जब मूसा अऊ हारून फिरौन करा ले चल दीन, त मूसा ह ओ मेचकामन के बारे म यहोवा ले गोहारिस, जऊन ला ओह फिरौन के ऊपर लाने रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","अऊ यहोवा ह मूसा के पराथना के मुताबिक करिस। मेचकामन घर म, अंगना म अऊ खेत म मर गीन। ");
INSERT INTO hne_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ओमन ला कुढ़ोय गीस, अऊ ओमन ले देस म बदबू फईल गीस। ");
INSERT INTO hne_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","पर जब फिरौन ह देखिस कि अब अराम मिल गे हवय, त ओह अपन मन ला फेर कठोर कर लीस अऊ मूसा अऊ हारून के बात ला नइं सुनिस, जइसे कि यहोवा ह कहे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","तब यहोवा ह मूसा ले कहिस, “हारून ला कह, ‘अपन लउठी ला लमा अऊ भुइयां के धुर्रा ला मार,’ अऊ पूरा मिसर देस म धुर्रा ह कीरा बन जाही।” ");
INSERT INTO hne_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ओमन वइसने करिन, अऊ जब हारून ह लउठी लेके अपन हांथ ला बढ़ाईस अऊ भुइयां के धुर्रा ला मारिस, त मनखे अऊ पसुमन ऊपर कीरामन आ गीन। पूरा मिसर देस म धुर्रा ह कीरा बन गीस। ");
INSERT INTO hne_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","पर जब जादूगरमन अपन जादूगरी ले कीरा बनाय के कोसिस करिन, त ओमन नइं कर सकिन। कीरामन हर जगह मनखे अऊ पसुमन म बने रिहिन, ");
INSERT INTO hne_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","त जादूगरमन फिरौन ला कहिन, “येह परमेसर के काम अय।” पर फिरौन के मन ह कठोर बने रिहिस अऊ ओह नइं सुनिस, जइसे कि यहोवा ह कहे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","तब यहोवा ह मूसा ले कहिस, “बड़े बिहनियां उठ अऊ जब फिरौन ह नदी कोति जाथे, त ओकर आघू म जाके ओला कहिबे, ‘यहोवा ह ये कहत हे: मोर मनखेमन ला जावन दे, ताकि ओमन मोर अराधना करंय। ");
INSERT INTO hne_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","कहूं तेंह मोर मनखेमन ला जावन नइं देबे, त मेंह तोर अऊ तोर करमचारीमन ऊपर, तोर मनखेमन ऊपर अऊ तुम्हर घरमन म दल के दल कीट-पतंगामन ला पठोहूं। मिसरीमन के घरमन कीट-पतंगामन ले भर जाहीं; अऊ त अऊ भुइयां ह ओमन ले तोपा जाही। ");
INSERT INTO hne_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘पर ओ दिन मेंह गोसेन प्रदेस ले अलग बरताव करहूं, जिहां मोर मनखेमन रहिथें; उहां कीट-पतंगामन के कोनो दल नइं होही, ताकि तेंह जान लेबे कि में, यहोवा, ये देस म हवंव। ");
INSERT INTO hne_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","मेंह मोर मनखे अऊ तोर मनखेमन के बीच एक अंतर करहूं। ये चिनहां ह कल दिखही।’ ” ");
INSERT INTO hne_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","अऊ यहोवा ह वइसनेच करिस। फिरौन के महल म अऊ ओकर करमचारीमन के घरमन म कीट-पतंगामन भर गीन; पूरा मिसर देस ह कीट-पतंगामन के दुवारा नास हो गीस। ");
INSERT INTO hne_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","तब फिरौन ह मूसा अऊ हारून ला बलाके कहिस, “तुमन जावव अऊ अपन परमेसर बर इही देस म बलि चघावव।” ");
INSERT INTO hne_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","पर मूसा ह कहिस, “येह ठीक नइं होही। जऊन बलिदान हमन यहोवा हमर परमेसर ला चघाबो, ओह मिसरीमन बर घिन अय। अऊ कहूं हमन ओ बलिदान ला चघाबो, जऊन ह मिसरीमन के नजर म घिन अय, त का ओमन हमर ऊपर पथरवाह नइं करहीं? ");
INSERT INTO hne_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","हमन ला तीन दिन के यातरा के दूरी म एक सुन्ना जगह म जाना जरूरी अय, ताकि हमन यहोवा हमर परमेसर बर बलिदान चघा सकन, जइसे कि ओह हमन ला हुकूम दे हवय।” ");
INSERT INTO hne_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फिरौन ह कहिस, “मेंह तुमन ला जावन दूहूं ताकि तुमन सुन्ना जगह म जाके यहोवा अपन परमेसर बर बलिदान चघावव, पर जादा दूरिहा झन जावव। मोर बर पराथना करव।” ");
INSERT INTO hne_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मूसा ह जबाब दीस, “जइसे ही मेंह तोर इहां ले जाहूं, मेंह यहोवा ले पराथना करहूं, अऊ कल कीट-पतंगामन फिरौन अऊ ओकर करमचारी अऊ ओकर मनखेमन ला छोंड़के चल दीहीं। पर फिरौन ह ये बात के निस्चय करय कि ओह फेर धोखा देके मनखेमन ला नइं रोकही कि ओमन जाके यहोवा बर बलिदान चघावंय।” ");
INSERT INTO hne_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","तब मूसा ह फिरौन करा ले चल दीस अऊ यहोवा ले पराथना करिस, ");
INSERT INTO hne_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","अऊ यहोवा ह मूसा के पराथना के मुताबिक करिस। कीट-पतंगामन फिरौन अऊ ओकर करमचारी अऊ ओकर मनखेमन ला छोंड़के चल दीन; एको ठन घलो उहां नइं रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","पर ये बेरा घलो फिरौन ह अपन मन ला कठोर कर लीस अऊ इसरायली मनखेमन ला जावन नइं दीस। ");
INSERT INTO hne_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","तब यहोवा ह मूसा ला कहिस, “फिरौन करा जाके ओला कह, ‘यहोवा, इबरीमन के परमेसर ह ये कहत हे: “मोर मनखेमन ला जावन दे कि ओमन मोर अराधना कर सकंय।” ");
INSERT INTO hne_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","यदि तेंह ओमन ला जावन नइं देबे अऊ ओमन ला रोके रहिबे, ");
INSERT INTO hne_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","त यहोवा के हांथ ह मैदान म तोर पसुमन ऊपर भयंकर महामारी ले आही—याने कि तोर घोड़ा, गदहा अऊ ऊंट अऊ तोर गाय-बईला अऊ भेड़-बकरीमन ऊपर। ");
INSERT INTO hne_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","पर यहोवा ह इसरायलीमन के पसु अऊ मिसरीमन के पसु म एक अंतर बनाही, जेकर ले इसरायलीमन के कोनो भी पसु नइं मरहीं।’ ” ");
INSERT INTO hne_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","यहोवा ह ये कहिके एक समय ठहिरा दीस, “कल यहोवा ह ये काम ला ये देस म करही।” ");
INSERT INTO hne_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","अऊ दूसर दिन यहोवा ह येला करिस: मिसरीमन के जम्मो पसुमन मर गीन, पर इसरायलीमन के एको ठन पसु नइं मरिन। ");
INSERT INTO hne_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फिरौन ह खोजबीन करवाईस, त ओला पता चलिस कि इसरायलीमन के एको ठन पसु नइं मरे हवंय। तभो ले ओकर मन ह कठोर बने रिहिस अऊ ओह मनखेमन ला नइं जावन दीस। ");
INSERT INTO hne_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","तब यहोवा ह मूसा अऊ हारून ले कहिस, “एक ठन भट्ठी ले अपन हांथ म मुठा भरके राख ला लेवव अऊ मूसा ह फिरौन के आघू म ओ राख ला हवा म उड़िया दे। ");
INSERT INTO hne_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","येह पूरा मिसर देस म बारिक धुर्रा म बदल जाही, अऊ पूरा देस भर के मनखे अऊ पसुमन म फोड़ा निकल आही।” ");
INSERT INTO hne_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","एकरसेति ओमन एक ठन भट्ठी ले राख ला लीन अऊ फिरौन के आघू म जाके खड़े हो गीन। मूसा ह ओ राख ला हवा म उड़िया दीस, जेकर ले मनखे अऊ पसुमन म फोड़ा निकल आईस। ");
INSERT INTO hne_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","जादूगरमन ये फोड़ामन के कारन मूसा के आघू म ठाढ़ नइं हो सकिन, काबरकि ओ फोड़ामन न सिरिप जम्मो मिसरीमन के देहें म निकले रिहिन, पर जादूगरमन के देहेंमन घलो फोड़ा ले भर गे रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","पर यहोवा ह फिरौन के मन ला कठोर बना दीस, अऊ ओह मूसा अऊ हारून के बात ला नइं सुनिस, जइसे कि यहोवा ह मूसा ला कहे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","तब यहोवा ह मूसा ला कहिस, “बड़े बिहनियां उठके फिरौन करा जाबे अऊ ओला कहिबे, ‘यहोवा, इबरीमन के परमेसर ह ये कहत हे: मोर मनखेमन ला जावन दे ताकि ओमन मोर अराधना कर सकंय, ");
INSERT INTO hne_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","नइं तो ये बेरा, तोर बिरूध अऊ तोर करमचारी अऊ तोर मनखेमन के बिरूध मेंह पूरा सक्ति से महामारी पठोहूं, जेकर ले तेंह जान लेबे कि जम्मो धरती म मोर सहीं अऊ कोनो नइं ए। ");
INSERT INTO hne_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","काबरकि अब तक मेंह अपन हांथ लमाके तोर अऊ तोर मनखेमन ऊपर महामारी लानके तुमन ला धरती ले नास कर सकत रहेंव। ");
INSERT INTO hne_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","पर मेंह तोला एकरसेति राजा बनाके उठाय हवंव, ताकि मेंह तोला अपन सामर्थ देखा सकंव अऊ धरती भर म मोर नांव के परचार होवय। ");
INSERT INTO hne_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","पर तेंह अब भी अपनआप ला मोर मनखेमन के बिरोध म रखके ओमन ला जावन नइं देवत हस। ");
INSERT INTO hne_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","एकरसेति, कल इही बेरा म, मेंह करा के अइसन आंधी पठोहूं, जइसन कि मिसर के नीव डारे के दिन ले लेके अब तक कभू नइं आय हवय। ");
INSERT INTO hne_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","एकरसेति अब हुकूम देके अपन पसु अऊ जऊन कुछू खेतमन म हवय, ओ जम्मो ला सुरकछित जगह म करवा ले, काबरकि हर ओ मनखे अऊ पसु, जऊन मन नइं लाय जाहीं अऊ खेत म रहिहीं, ओमन ऊपर करा गिरही, अऊ ओमन मर जाहीं।’ ” ");
INSERT INTO hne_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","फिरौन के ओ करमचारी, जऊन मन यहोवा के बचन के भय मानिन, ओमन लकर-धकर अपन गुलाम अऊ पसुमन ला भीतर ले आईन। ");
INSERT INTO hne_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","पर जऊन मन यहोवा के बचन ऊपर धियान नइं दीन, ओमन अपन गुलाम अऊ पसुमन ला खेत म ही रहन दीन। ");
INSERT INTO hne_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","तब यहोवा ह मूसा ला कहिस, “अपन हांथ ला अकास कोति बढ़ा ताकि जम्मो मिसर देस म करा गिरय—मनखे अऊ पसुमन ऊपर अऊ मिसर के खेत म होवइया हर फसल के ऊपर करा गिरय।” ");
INSERT INTO hne_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","जब मूसा ह अपन लउठी ला अकास कोति उठाईस, त यहोवा ह बादर के गरजन अऊ करा, अऊ बिजली के कड़क भुइयां म पठोईस। ये किसम ले यहोवा ह मिसर देस म करा के बारिस करिस; ");
INSERT INTO hne_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","करा गिरत रिहिस अऊ बार-बार बिजली घलो चमकत रिहिस। जब ले मिसर देस ह बसे रिहिस, तब ले लेके आज तक अइसने आंधी पूरा देस म कभू नइं आय रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","पूरा मिसर देस के खेत म के हर एक चीज ऊपर करा गिरिस—मनखे अऊ पसु दूनों के ऊपर; येह खेत के जम्मो फसल ला नास कर दीस अऊ रूखमन टूट गीन। ");
INSERT INTO hne_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","सिरिप एक ठन जगह म करा नइं गिरिस अऊ ओह गोसेन प्रदेस रिहिस, जिहां इसरायलीमन रहत रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","तब फिरौन ह मूसा अऊ हारून ला बलाईस अऊ ओमन ला कहिस, “ये बेरा, मेंह पाप करे हंव। यहोवा ह सही अय, अऊ में अऊ मोर मनखेमन गलत अन। ");
INSERT INTO hne_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","यहोवा ले पराथना करव; काबरकि बादर के गरजई अऊ करा के गिरई बहुंत हो गीस। मेंह तुमन ला जावन दूहूं; तुमन ला अब रूकना नइं पड़य।” ");
INSERT INTO hne_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मूसा ह जबाब दीस, “जब मेंह सहर ले बाहिर निकलहूं, त मेंह अपन हांथ उठाके यहोवा ले पराथना करहूं। तब गरजन बंद हो जाही अऊ करा फेर नइं गिरही, तब तेंह जान लेबे कि धरती ह यहोवा के अय। ");
INSERT INTO hne_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","पर मेंह जानत हंव कि अभी घलो तें अऊ तोर करमचारीमन यहोवा परमेसर के भय नइं मानत हव।” ");
INSERT INTO hne_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(सन अऊ जौ के फसल ह नास हो गे रिहिस, काबरकि जौ ह छटक गे रिहिस अऊ सन म फूल धरत रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","पर गहूं अऊ कठिया गहूंमन नास नइं होईन, काबरकि ओमन के फसल ह बाद म पाकथे।) ");
INSERT INTO hne_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","तब मूसा ह फिरौन करा ले निकलके सहर ले बाहिर चल दीस। ओह यहोवा कोति अपन हांथ उठाईस; तब गरजन अऊ करा के गिरई ह बंद हो गीस, अऊ देस म बारिस घलो रूक गीस। ");
INSERT INTO hne_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","जब फिरौन ह देखिस कि पानी अऊ करा के गिरई अऊ गरजन ह बंद हो गे हवय, त ओह फेर पाप करिस: ओ अऊ ओकर करमचारीमन अपन मन ला कठोर कर लीन। ");
INSERT INTO hne_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","फिरौन के मन ह कठोर हो गीस अऊ ओह इसरायलीमन ला जावन नइं दीस, जइसे कि यहोवा ह मूसा के जरिये पहिले कहे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ओकर बाद यहोवा ह मूसा ले कहिस, “फिरौन करा जा, काबरकि मेंह ओकर अऊ ओकर करमचारीमन के मन ला एकरसेति कठोर कर दे हंव, ताकि मेंह अपन ये चिनहांमन ला ओमन के बीच म देखावंव ");
INSERT INTO hne_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","अऊ तुमन अपन लइका अऊ अपन नाती-पोतामन ला बतावव कि कइसे मेंह मिसरीमन के संग कठोर बरताव करेंव अऊ कइसे मेंह ओमन के बीच म चिनहांमन ला देखांय, अऊ ये कि तुमन जानव कि मेंह यहोवा अंव।” ");
INSERT INTO hne_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","तब मूसा अऊ हारून, फिरौन करा गीन अऊ ओला कहिन, “यहोवा, इबरीमन के परमेसर ह ये कहत हे: ‘तें कब तक मोर आघू म अपनआप ला नम्र नइं करबे? मोर मनखेमन ला जावन दे, ताकि ओमन मोर अराधना करंय। ");
INSERT INTO hne_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","कहूं तेंह ओमन ला जावन नइं देबे, त कल मेंह फांफामन ला तोर देस म ले आहूं। ");
INSERT INTO hne_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ओमन भुइयां ऊपर अइसे छा जाहीं कि ओह नइं दिखही। जऊन कुछू करा गिरे ले बांच गे हवय, ओला घलो ओमन खा जाहीं, अऊ खेतमन म बाढ़त जम्मो रूखमन ला घलो खा जाहीं। ");
INSERT INTO hne_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ओमन तोर अऊ तोर जम्मो करमचारी अऊ जम्मो मिसरीमन के घर म भर जाहीं—जब ले तोर दाई-ददा अऊ तोर पुरखामन ये देस म बसे हवंय, तब ले लेके अब तक ओमन अइसने चीज नइं देखे होहीं।’ ” ये कहिके मूसा ह मुड़िस अऊ फिरौन करा ले चल दीस। ");
INSERT INTO hne_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फिरौन के करमचारीमन ओला कहिन, “कब तक ये मनखे ह हमर बर फांदा बने रहिही? मनखेमन ला जावन दे, ताकि ओमन यहोवा अपन परमेसर के अराधना कर सकंय। का तेंह अभी घलो नइं समझत हस कि मिसर देस ह बरबाद हो गे हवय?” ");
INSERT INTO hne_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","तब मूसा अऊ हारून ला फेर फिरौन करा लाने गीस, अऊ ओह ओमन ला कहिस, “जावव, अऊ यहोवा अपन परमेसर के अराधना करव, पर मोला बतावव कि कोन-कोन तुम्हर संग जाहीं।” ");
INSERT INTO hne_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मूसा ह जबाब दीस, “हमर संग हमर लइका अऊ हमर सियानमन, हमर बेटा-बेटीमन, अऊ हमर पसु अऊ भेड़-बकरीमन जाहीं, काबरकि हमन यहोवा बर एक तिहार मनाबो।” ");
INSERT INTO hne_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फिरौन ह कहिस, “यहोवा ह तुम्हर संग रहय—कहूं मेंह तुमन ला तुम्हर माईलोगन अऊ लोग-लइकामन सहित जावन देथंव, त मोला लगत हे कि तुम्हर मन म बुरई हवय। ");
INSERT INTO hne_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","नइं! तुमन सिरिप मरदमन जावव अऊ यहोवा के अराधना करव, काबरकि इही बात के मांग तो तुमन करत रहेव।” तब मूसा अऊ हारून ला फिरौन के आघू ले बाहिर निकाल दिये गीस। ");
INSERT INTO hne_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","तब यहोवा ह मूसा ला कहिस, “मिसर देस ऊपर अपन हांथ लमा ताकि फांफामन आके मिसर देस म भर जावंय अऊ खेत म बाढ़त हर एक पऊधा ला खा जावंय, हर ओ चीज जऊन ह करा के गिरे के बाद बांच गे हवय, ओ जम्मो ला खा डारंय।” ");
INSERT INTO hne_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","तब मूसा ह अपन लउठी ला मिसर देस ऊपर बढ़ाईस, अऊ यहोवा ह जम्मो देस म ओ दिन अऊ रात भर पुरवई हवा चलाईस, अऊ बिहनियां ओ हवा ह फांफामन ला ले आईस; ");
INSERT INTO hne_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ओमन जम्मो मिसर देस म छा गीन, अऊ बड़े संखिया म देस के हर भाग म फईल गीन। येकर पहिली अइसे फांफामन के महामारी कभू नइं आय रिहिस, अऊ येकर बाद फेर कभू नइं आही। ");
INSERT INTO hne_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ओमन जम्मो भुइयां ऊपर अइसन छा गीन कि ओह करिया दिखे लगिस। करा गिरे के बाद जऊन कुछू बांच गे रिहिस, ओ जम्मो ला ओमन खा गीन—ओ जम्मो चीज जऊन ह खेतमन म बाढ़त रिहिस अऊ रूखमन के फर, ओ जम्मो ला खा लीन। पूरा मिसर देस म रूख अऊ पऊधा म कोनो किसम के हरियर चीज नइं बांचिस। ");
INSERT INTO hne_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","फिरौन ह तुरते मूसा अऊ हारून ला बलाके कहिस, “मेंह यहोवा तुम्हर परमेसर अऊ तुम्हर बिरूध पाप करे हवंव। ");
INSERT INTO hne_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","अब मोर पाप ला एक बार फेर छेमा करव अऊ यहोवा तुम्हर परमेसर ले पराथना करव कि ये मिरतू के महामारी ला मोर ले हटा ले।” ");
INSERT INTO hne_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","तब मूसा ह फिरौन करा ले चल दीस अऊ यहोवा ले पराथना करिस। ");
INSERT INTO hne_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","अऊ यहोवा ह हवा के दिग ला बदलके एक बड़े पछिमी हवा चलाईस, जऊन ह जम्मो फांफामन ला लाल-समुंदर म डार दीस। पूरा मिसर देस म एको ठन फांफा नइं बांचिन। ");
INSERT INTO hne_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","पर यहोवा ह फिरौन के मन ला कठोर कर दीस, अऊ ओह इसरायलीमन ला जावन नइं दीस। ");
INSERT INTO hne_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","तब यहोवा ह मूसा ला कहिस, “अपन हांथ ला अकास कोति लमा, ताकि मिसर देस म अंधियार छा जावय—अइसन अंधियार जेला महसूस करे जा सकय।” ");
INSERT INTO hne_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","तब मूसा ह अपन हांथ ला अकास कोति लमाईस, अऊ जम्मो मिसर देस म तीन दिन तक घोर अंधियार छा गीस। ");
INSERT INTO hne_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","तीन दिन तक न तो कोनो एक-दूसर ला देख सकिन, अऊ न ही कोनो कहीं आ जा सकिन। पर ओ जम्मो जगह म अंजोर रिहिस, जिहां इसरायलीमन रहत रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","तब फिरौन ह मूसा ला बलाके कहिस, “जावव, अऊ यहोवा के अराधना करव। तुमन अपन संग अपन लोग-लइकामन ला घलो ले जावव; सिरिप अपन पसुमन ला छोंड़ देवव।” ");
INSERT INTO hne_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","पर मूसा ह कहिस, “तें हमन ला बलिदान अऊ होम-बलिदान ले जाय के अनुमति दे ताकि हमन येमन ला यहोवा हमर परमेसर के आघू म भेंट चघा सकन। ");
INSERT INTO hne_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","एकरसेति संग म हमर पसुमन ला घलो ले जाना जरूरी अय; ओमन के एक ठन खुर तक घलो नइं छूटना चाही। हमन ओमा के कुछू चीजमन ला यहोवा हमर परमेसर के अराधना म उपयोग करबो, अऊ जब तक हमन उहां नइं हबर जावन, तब तक हमन नइं जानन कि यहोवा के अराधना म का चीज के उपयोग करबो।” ");
INSERT INTO hne_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","पर यहोवा ह फिरौन के मन ला कठोर कर दीस, अऊ ओह ओमन ला जावन नइं दीस। ");
INSERT INTO hne_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","फिरौन ह मूसा ला कहिस, “मोर नजर ले दूरिहा हट! अऊ धियान रख कि मोर आघू म फेर झन आबे! जऊन दिन तेंह मोर मुहूं ला देखबे, ओहीच दिन तेंह मार डारे जाबे।” ");
INSERT INTO hne_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मूसा ह जबाब दीस, “जइसे कि तेंह कहत हस, मेंह तोर आघू म फेर कभू नइं आवंव।” ");
INSERT INTO hne_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","यहोवा ह मूसा ला कहे रिहिस, “मेंह फिरौन अऊ मिसर देस ऊपर एक ठन अऊ महामारी लानहूं। ओकर बाद, ओह तुमन ला इहां ले जावन दीही, अऊ जब ओह अइसन करथे, त ओह तुमन ला पूरा-पूरी भगा दीही। ");
INSERT INTO hne_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","इसरायलीमन ला कह कि हर एक मरद अऊ माईलोगन अपन-अपन परोसी ले सोन अऊ चांदी के चीजमन ला मांग लेवंय।” ");
INSERT INTO hne_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(यहोवा ह अपन मनखेमन बर मिसरीमन के मन म दया के भाव उपजाईस, अऊ मूसा ला खुद मिसर देस म फिरौन के करमचारी अऊ मनखेमन बहुंत आदर के नजर ले देखंय।) ");
INSERT INTO hne_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मूसा ह फिरौन ला कहिस, “यहोवा ह ये कहत हे: ‘मेंह आधा रथिया पूरा मिसर देस के बीच ले होके जाहूं। ");
INSERT INTO hne_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","मिसर देस के हर पहिलांत बेटा ह मर जाही, सिंघासन ऊपर बईठइया फिरौन के पहिलांत बेटा ले लेके जांता चलइया गुलाम माईलोगन के पहिलांत बेटा तक, अऊ पसुमन के जनमे जम्मो पहिलांत पसु घलो मर जाहीं। ");
INSERT INTO hne_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","पूरा मिसर देस म बहुंत रोये के अवाज सुनई दीही—अतेक खराप बात न कभू होय रिहिस, अऊ न फेर कभू होही। ");
INSERT INTO hne_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","पर इसरायलीमन के बीच म कोनो मनखे या पसु ऊपर कोनो कुकुर घलो नइं भूंकही,’ तब तेंह जान लेबे कि यहोवा ह मिसरी अऊ इसरायलीमन के बीच म एक अंतर रखथे। ");
INSERT INTO hne_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","तोर ये जम्मो करमचारीमन मोर करा आहीं, अऊ मोर आघू म मुड़ नवाके कहिहीं, ‘जावव, तें अऊ तोर पाछू चलइया जम्मो मनखेमन जावंय!’ ओकर बाद मेंह चल दूहूं।” तब मूसा ह बहुंत गुस्सा होके फिरौन करा ले चल दीस। ");
INSERT INTO hne_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","यहोवा ह मूसा ला कहे रिहिस, “फिरौन ह तोर बात ला नइं सुनही—ताकि मिसर देस म मोर अचम्भो के काम बहुंत होवय।” ");
INSERT INTO hne_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मूसा अऊ हारून, फिरौन के आघू म ये जम्मो अचम्भो के काम करिन, पर यहोवा ह फिरौन के मन ला कठोर कर दे रिहिस, अऊ ओह इसरायलीमन ला अपन देस ले बाहिर नइं जावन देत रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","यहोवा ह मिसर देस म मूसा अऊ हारून ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ये महिना ह तुम्हर बर पहिला महिना होही, याने कि येह साल के पहिला महिना होही। ");
INSERT INTO hne_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इसरायल के पूरा समाज ला बता दव कि ये महिना के दसवां दिन तुमन म के हर एक झन अपन-अपन परिवार बर एक-एक ठन मेढ़ा-पीला लेवय। ");
INSERT INTO hne_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","यदि कोनो परिवार ह एक ठन मेढ़ा-पीला बर बहुंत छोटे हवय, त ओमन अपन सबले नजदीक के परोसी संग ओ मेढ़ा-पीला ला ओ घर के गनती के मुताबिक बांट लेवंय। हर मनखे ह कतेक खाही, ओकर मुताबिक ही ओ मेढ़ा-पीला के बांटा करे जावय। ");
INSERT INTO hne_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","जऊन पसु ला तुमन चुनथव, ओह एक साल के निरदोस नर पसु होवय, अऊ तुमन ओला भेड़मन ले या बकरीमन ले लेय सकत हव। ");
INSERT INTO hne_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","इही महिना के चौदहवां दिन तक ओकर खियाल रखव, तब इसरायली समाज के हर सदस्य गोधूलि के बेरा म ओला पूज देवय। ");
INSERT INTO hne_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","तब जऊन घर म ओ मेढ़ा-पीला ला खाहू, ओकर चौखट के दूनों कोति अऊ चौखट के ऊपरी भाग म ओकर थोरकन लहू ला लगा देवव। ");
INSERT INTO hne_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ओहीच रथिया ओकर मांस ला आगी म भुंजके करू साग अऊ अखमीरी रोटी के संग खावव। ");
INSERT INTO hne_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","कइंचा मांस या पानी म उसने मांस ला झन खावव, पर ओकर गोड़, मुड़, अऊ पेट के भीतर के भागमन ला आगी म भुंजके खावव। ");
INSERT INTO hne_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","अऊ ओमा के कुछू चीज ला बिहनियां बर झन बचावव; कहूं ओमा के कुछू चीज ह बिहनियां तक बच जाथे, त तुमन ओला आगी म जला देवव। ");
INSERT INTO hne_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","तुमन ओला अइसे खावव: तुम्हर ऊपर के पहिरावा ह कमरपट्टा म बंधाय रहय, अपन गोड़ म पनही पहिरे रहव, अपन लउठी ला हांथ म धरे रहव अऊ ओला जल्दी-जल्दी खावव; येह यहोवा के फसह अय। ");
INSERT INTO hne_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“ओही रथिया मेंह मिसर देस म ले होके निकलहूं अऊ मिसर देस के जम्मो पहिलांत ला मारहूं—चाहे ओह मनखे होवय या पसु, जम्मो पहिलांत ला मारहूं, अऊ मेंह मिसर के जम्मो देवतामन ला सजा दूहूं। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","जऊन घरमन म तुमन रहत हव, ओमा ओ लहू ह एक चिनहां होही, अऊ जब मेंह ओ लहू ला देखहूं, त ओला नाहकके आघू बढ़ जाहूं। जब मेंह मिसरीमन ला मारहूं, त तुम्हर ऊपर कोनो नास करइया महामारी नइं आही। ");
INSERT INTO hne_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ये दिन ह तुम्हर बर एक यादगार दिन होही; अऊ पीढ़ी-पीढ़ी तक तुमन येला यहोवा बर एक तिहार के रूप म मनाहू—ये नियम ह हमेसा बने रहय। ");
INSERT INTO hne_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","सात दिन तक बिगर खमीर के बने रोटी ला खावव। पहिलीच दिन अपन घर ले खमीर ला हटा दव, काबरकि कहूं कोनो पहिली दिन ले लेके सातवां दिन तक कोनो खमीर मिले हुए चीज ला खाथे, त ओला इसरायल ले अलग करे जावय। ");
INSERT INTO hne_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","पहिली दिन एक पबितर सभा करव, अऊ सातवां दिन घलो एक सभा करव। ये दूनों दिन कोनो काम-बुता झन करव, जम्मो झन के खाय बर सिरिप जेवन पकाय के काम करे जावय; ये दूनों दिन तुमन सिरिप येहीच काम करव। ");
INSERT INTO hne_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“तुमन अखमीरी रोटी के तिहार मनावव, काबरकि येह ओ दिन अय, जब मेंह तुमन ला दल के दल मिसर देस ले बाहिर निकालके लानेंव। हमेसा के नियम के रूप म ये दिन ला अवइया पीढ़ी-पीढ़ी तक मानव। ");
INSERT INTO hne_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पहिली महिना के चौदहवां दिन के सांझ ले इक्कीसवां दिन के सांझ तक तुमन अखमीरी रोटी खावव। ");
INSERT INTO hne_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दिन ले तुम्हर घर म कोनो खमीर झन रहय। यदि कोनो मनखे खमीर ले बने कुछू चीज ला खाथे, चाहे ओह देसी मनखे होवय या फेर परदेसी, ओला इसरायल के समाज ले अलग करे जावय। ");
INSERT INTO hne_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","खमीर ले बने कोनो भी चीज ला झन खावव; जिहां कहूं भी तुमन रहव, अखमीरी रोटी ही खावव।” ");
INSERT INTO hne_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","तब मूसा ह इसरायल के जम्मो अगुवामन ला बलाके कहिस, “तुरते जावव अऊ अपन-अपन परिवार बर एक-एक ठन पसु छांट लेवव अऊ फसह के मेढ़ा-पीला के बलि करव। ");
INSERT INTO hne_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","तुमन जूफा के एक ठन गुच्छा लेवव अऊ ओला तसला म रखे लहू म बोरव अऊ लहू ला चौखट के ऊपर अऊ चौखट के दूनों तरफ लगावव, अऊ बिहान के होवत तक तुमन म ले कोनो अपन घर के मुंहटा ले बाहिर झन निकलय। ");
INSERT INTO hne_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","काबरकि जब यहोवा ह देस म ले होके मिसरीमन ला मारत जाही, त ओह चौखट के ऊपर अऊ चौखट के दूनों तरफ लगे लहू ला देखही, अऊ ओ मुंहटा ले नाहकके आघू बढ़ जाही, अऊ ओह नास करइया ला तुम्हर घरमन म जाके मार डारे के अनुमति नइं दीही। ");
INSERT INTO hne_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“ये निरदेस ला तुमन अपन अऊ अपन लइकामन बर एक अटल हुकूम के रूप म मानव। ");
INSERT INTO hne_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","जब तुमन ओ देस म हबर जावव, जेला यहोवा ह अपन परतिगियां के मुताबिक तुमन ला दीही, त ये रीति-बिधिमन ला मानव। ");
INSERT INTO hne_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","अऊ जब तुम्हर लइकामन तुमन ले पुछंय, ‘तुमन ये बिधिमन ला काबर मानथव?’ ");
INSERT INTO hne_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तब ओमन ला बतावव, ‘येह यहोवा बर फसह के बलिदान अय; जऊन ह मिसर देस म इसरायलीमन के घर के आघू ले निकलिस अऊ हमर घरमन ला छोंड़के मिसरीमन ला नास करिस।’ ” तब मनखेमन मुड़ नवाके अराधना करिन। ");
INSERT INTO hne_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","इसरायलीमन वइसे ही करिन, जइसे यहोवा ह मूसा अऊ हारून ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","आधा रथिया यहोवा ह मिसर म जम्मो पहिलांतमन ला मार डारिस, सिंघासन म बईठे फिरौन के पहिलांत ले लेके जेल म रहइया कैदीमन के पहिलांतमन ला, अऊ संग म पसुमन के जम्मो पहिलांत ला घलो मार डारिस। ");
INSERT INTO hne_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","रथिया के बेरा ही फिरौन अऊ ओकर जम्मो करमचारी अऊ जम्मो मिसरीमन जाग उठिन, अऊ उहां मिसर म बहुंत हाहाकार होवत रिहिस, काबरकि उहां अइसन एको ठन घर नइं रिहिस, जिहां कोनो मरे नइं रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","रथिया के बेरा ही फिरौन ह मूसा अऊ हारून ला बलाके कहिस, “मोर मनखेमन ला छोड़के, तुमन इसरायलीमन के संग चले जावव! तुमन जावव, अऊ यहोवा के अराधना करव, जइसे कि तुमन बिनती करे हव। ");
INSERT INTO hne_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","अपन कहे मुताबिक अपन भेड़-बकरी अऊ गरूवा-बईला ला संग म ले जावव। अऊ मोला आसीरबाद देवत जावव।” ");
INSERT INTO hne_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","मिसरीमन इसरायलीमन ला देस छोंड़के जल्दी से जल्दी चले जाय बर बिनती करिन। ओमन कहिन, “नइं तो हमन जम्मो झन मर जाबो!” ");
INSERT INTO hne_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","तब इसरायलीमन बिगर खमीर डाले गूंधे पीसान ला बरतन म धरके कपड़ा म लपेटिन अऊ ओला कंधा म बोहके ले चलिन। ");
INSERT INTO hne_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इसरायलीमन मूसा के कहे मुताबिक मिसरीमन ले सोन अऊ चांदी के जेवर अऊ ओनहा ला मांग लीन। ");
INSERT INTO hne_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","यहोवा ह मिसरीमन ला इसरायलीमन बर दयालु कर दीस, अऊ ओमन जऊन कुछू मिसरीमन ले मांगिन, ओमन ला दिये गीस; ये किसम ले इसरायलीमन मिसरीमन ला लूट लीन। ");
INSERT INTO hne_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","तब इसरायलीमन रामसेस सहर ले चलके सुक्कोत सहर आईन। माईलोगन अऊ लइकामन के अलावा ओमन लगभग छै लाख पैदल चलइया आदमीमन रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","बहुंते आने मनखेमन घलो ओमन के संग गीन, ओमन के संग भेड़-बकरी अऊ गरूवा-बईला के बड़े दल घलो रहय। ");
INSERT INTO hne_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","जऊन साने गय पीसान, इसरायलीमन मिसर ले लाने रिहिन, ओकर ले ओमन बिगर खमीर के रोटी बनाईन। साने गय पीसान ह बिगर खमीर के रिहिस, काबरकि ओमन ला मिसर देस ले निकाल दिये गे रिहिस अऊ ओमन करा अपन बर खाना बनाय के समय नइं रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इसरायलीमन मिसर देस म 430 साल तक रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","430 साल के आखिरी म, ओहीच दिन, यहोवा के जम्मो मनखेमन मिसर देस ले निकल गीन। ");
INSERT INTO hne_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","काबरकि यहोवा ह इसरायलीमन ला मिसर देस ले निकाल लाने बर रतजगा रखिस, ये रथिया जम्मो इसरायलीमन यहोवा के आदर म रतजगा करंय अऊ येला अवइया पीढ़ी-पीढ़ी के मनखेमन मानंय। ");
INSERT INTO hne_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","यहोवा ह मूसा अऊ हारून ला कहिस, “फसह के भोज के बिधि ये अय: “कोनो भी परदेसी येला झन खावय। ");
INSERT INTO hne_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","कोनो गुलाम, जेला तुमन बिसाय हवव, अऊ ओकर खतना करवाय हवव, त ओह येला खा सकत हे। ");
INSERT INTO hne_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","पर कोनो अस्थायी रूप म रहइया मनखे या कोनो बनिहार येला झन खावय। ");
INSERT INTO hne_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“येला घर के भीतरेच म ही खाय जावय; मांस के एक टुकड़ा घलो घर के बाहिर झन ले जावव। कोनो हाड़ा ला झन टोरव। ");
INSERT INTO hne_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","जरूरी अय कि पूरा इसरायली समाज येला मनावय। ");
INSERT INTO hne_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“तुम्हर बीच म रहइया कोनो परदेसी यदि यहोवा के फसह ला मनाय चाहथे, त ओकर घर के जम्मो मरदमन के खतना कराना जरूरी अय, तब ओह ओ देस म जनमे मनखे के सहीं येमा भाग ले सकथे। कोनो भी बिगर खतनावाला मनखे येला झन खावय। ");
INSERT INTO hne_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","येहीच कानून देसी मनखे अऊ तुम्हर बीच म रहइया परदेसी मनखे, दूनों बर लागू होथे।” ");
INSERT INTO hne_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","जम्मो इसरायलीमन वइसे ही करिन, जइसे यहोवा ह मूसा अऊ हारून ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","अऊ ओहीच दिन यहोवा ह इसरायलीमन ला दल-दल करके मिसर देस ले निकाल लानिस। ");
INSERT INTO hne_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“हर पहिलांत मरद के मोर बर संस्कार करव। इसरायलीमन के बीच म हर गरभ के पहिली फर ह मोर अय, चाहे ओह मनखे होवय या पसु।” ");
INSERT INTO hne_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","तब मूसा ह मनखेमन ला कहिस, “सुरता करके ये दिन म उत्सव मनावव; येह ओ दिन ए, जब तुमन मिसर देस ले, गुलामी के देस ले बाहिर निकलेव, काबरकि यहोवा ह अपन सक्तिसाली हांथ के दुवारा तुमन ला उहां ले निकालके ले आईस। एकरसेति खमीर मिले हुए कोनो भी चीज ला झन खावव। ");
INSERT INTO hne_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आज, अबीब नांव के महिना म, तुमन निकलके जावत हव। ");
INSERT INTO hne_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","जब यहोवा ह तुमन ला कनानी, हित्ती, अमोरी, हिब्बी, अऊ यबूसीमन के देस म लानही—ओ देस जेला तुमन ला देय बर, ओह तुम्हर पुरखामन के संग सपथ खाय रिहिस, एक अइसन देस जिहां दूध अऊ मंधरस के भरमार हवय—त तुमन इही महिना म ये उत्सव के पालन करव: ");
INSERT INTO hne_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिन तक तुमन बिगर खमीर के बने रोटी खावव अऊ सातवां दिन यहोवा बर तिहार मनावव। ");
INSERT INTO hne_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ओ सात दिन तक अखमीरी रोटी ही खावव; तुम्हर बीच येमा कोनो भी किसम के खमीर झन दिखय, न ही तुम्हर सीमना के भीतर कहूं मेर कोनो किसम के खमीर दिखय। ");
INSERT INTO hne_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ओ दिन तुमन अपन बेटामन ला बतावव, ‘जब मेंह मिसर देस ले बाहिर निकलेंव, त यहोवा ह जऊन कुछू मोर बर करिस, ओकर सेति मेंह येला मनाथंव।’ ");
INSERT INTO hne_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","येकर पालन करई ह तुम्हर बर तुम्हर हांथ म एक चिनहां अऊ तुम्हर माथा म एक सुरता करइया के सहीं होवय कि यहोवा के ये कानून ह तुम्हर मुहूं म रहय। काबरकि यहोवा ह अपन सक्तिसाली हांथ के दुवारा तुमन ला मिसर देस ले बाहिर निकाल लानिस। ");
INSERT INTO hne_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","एकरसेति हर साल ठहिराय गे समय म ये बिधि के पालन करव। ");
INSERT INTO hne_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“जब यहोवा ह तुमन ला कनानीमन के देस म ले आथे अऊ ओला तुम्हर अधिकार म दे देथे, जइसे कि ओह तुम्हर अऊ तुम्हर पुरखामन ले सपथ खाके परतिगियां करे रिहिस, ");
INSERT INTO hne_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","त तुमन हर एक कोख के पहिली संतान यहोवा ला दे दव। तुम्हर पसुमन के पहिलांत नर बछरू ह घलो यहोवा के अय। ");
INSERT INTO hne_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","गदहा के हर एक पहिलांत ला एक ठन मेढ़ा-पीला देके छोंड़ा लेवव, पर यदि तुमन ओला नइं छोंड़ावव, त ओकर घेंच ला टोर देवव। अपन जम्मो पहिलांत बेटामन ला बलदा देके छोंड़ा लेवव। ");
INSERT INTO hne_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“अवइया दिन म जब तुम्हर बेटामन तुमन ले पुछहीं, ‘येकर का मतलब अय?’ त ओमन ले कहव, ‘यहोवा ह अपन सक्तिसाली हांथ के दुवारा हमन ला मिसर देस के गुलामी ले निकाल लानिस। ");
INSERT INTO hne_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","जब फिरौन ह जिद्द करके हमन ला नइं जावन देवत रिहिस, त यहोवा ह मिसर देस म मनखे अऊ पसु दूनों के पहिलांत ला मार डारिस। एकरसेति हमन हर एक के कोख के पहिली नर संतान ला यहोवा बर बलिदान करथन अऊ अपन पहिलांत बेटा ला बलदा देके छोंड़ा लेथन।’ ");
INSERT INTO hne_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","अऊ येह तुम्हर हांथ म एक चिनहां अऊ तुम्हर माथा म एक टीका सहीं होही कि यहोवा ह अपन सक्तिसाली हांथ के दुवारा हमन ला मिसर देस ले निकाल लानिस।” ");
INSERT INTO hne_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","जब फिरौन ह मनखेमन ला जावन दीस, त परमेसर ह ओमन ला पलिस्तीमन के देस के डहार म ले नइं ले गीस, हालाकि ओ डहार ह छोटे रिहिस। पर परमेसर ह अपन मन म कहिस, “अइसन झन होवय कि ओमन लड़ई होवत देखंय अऊ अपन मन ला बदलके मिसर देस लहुंट जावंय।” ");
INSERT INTO hne_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","एकरसेति परमेसर ह इसरायलीमन ला सुन्ना जगह के रसता म ले होके लाल-समुंदर कोति ले लेय गीस। मिसर देस ले निकलके इसरायलीमन लड़ई बर तियार होके आघू बढ़िन। ");
INSERT INTO hne_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मूसा ह अपन संग यूसुफ के हाड़ामन ला घलो ले गीस, काबरकि यूसुफ ह इसरायलीमन ले ये कहिके किरिया खवाय रिहिस, “परमेसर ह जरूर तुम्हर मदद करही, अऊ जब तुमन ये जगह ले जावव, त मोर हाड़ामन ला अपन संग जरूर ले जावव।” ");
INSERT INTO hne_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","सुक्कोत ले आघू बढ़े के बाद, ओमन एताम म डेरा डालिन, जऊन ह सुन्ना जगह के तीर म रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","यहोवा ह ओमन ला दिन म डहार देखाय बर बादर के खंभा अऊ रथिया अंजोर देय बर आगी के खंभा म होके ओमन के आघू-आघू चलय, ताकि ओमन रात अऊ दिन यातरा कर सकंय। ");
INSERT INTO hne_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","परमेसर ह न तो बादर के खंभा ला दिन म अऊ न ही आगी के खंभा ला रात म मनखेमन के आघू ले हटाईस। ");
INSERT INTO hne_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इसरायलीमन ला कह कि ओमन पाछू घुंचके मिगदोल अऊ समुंदर के बीच, पी-हाहीरोत के लकठा म डेरा डालंय। ओमन समुंदर तीर, बाल-सपोन के एकदम सामने म डेरा डालंय। ");
INSERT INTO hne_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","फिरौन ह सोचही, ‘इसरायलीमन घबराहट म आके देस म चारों कोति भटकत हवंय, सुन्ना जगह म फंस गे हवंय।’ ");
INSERT INTO hne_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","अऊ मेंह फिरौन के मन ला कठोर कर दूहूं, अऊ ओह ओमन के पीछा करही। पर मेंह फिरौन अऊ ओकर जम्मो सेनामन के दुवारा अपन महिमा कराहूं, अऊ मिसरीमन जान लीहीं कि मेंह यहोवा अंव।” अऊ इसरायलीमन वइसनेच करिन। ");
INSERT INTO hne_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","जब मिसर के राजा ला बताय गीस कि इसरायलीमन भाग गे हवंय, त फिरौन अऊ ओकर करमचारीमन के मन ह ओमन के बारे म बदल गीस अऊ ओमन कहिन, “हमन का कर डारेंन? हमन इसरायलीमन ला जावन देंन अऊ अब हमन ला ओमन के सेवा नइं मिलत हे!” ");
INSERT INTO hne_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","तब फिरौन ह अपन रथ ला तियार करवाईस अऊ सेना ला अपन संग लीस। ");
INSERT INTO hne_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ओह छै सौ बढ़िया-बढ़िया रथमन ला लीस, अऊ संग म मिसर देस के आने जम्मो रथमन ला घलो लीस अऊ ओ जम्मो रथ म अधिकारीमन रहंय। ");
INSERT INTO hne_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","यहोवा ह मिसर के राजा फिरौन के मन ला कठोर कर दीस, जेकर कारन ओह इसरायलीमन के पीछा करिस, जेमन बेधड़क आघू बढ़त रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","मिसरीमन—फिरौन के जम्मो घोड़ा अऊ रथ, घुड़सवार अऊ सैनिक दल इसरायलीमन के पीछा करत ओमन करा हबर गीन, जेमन समुंदर के तीर, पी-हाहीरोत के लकठा म, बाल-सपोन के सामने डेरा डाले रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","जब फिरौन ह लकठा म आईस, त इसरायलीमन देखिन कि मिसरीमन ओमन के पीछा करत आवत हंय। त ओमन अब्बड़ डरा गीन अऊ चिचियाके यहोवा ले गोहारे लगिन। ");
INSERT INTO hne_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ओमन मूसा ला कहिन, “का मिसर देस म कबर नइं रिहिस कि तेंह हमन ला इहां सुन्ना जगह म मरे बर ले आय? तेंह हमर संग काबर अइसे करय कि तेंह हमन ला मिसर देस ले निकाल लानय? ");
INSERT INTO hne_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","का हमन मिसर म तोला नइं कहे रहेंन, ‘हमन ला इहेंच रहन दे; हमन मिसरीमन के सेवा करबो?’ ये सुन्ना जगह म मरे के बदले बने होतिस कि हमन मिसरीमन के सेवा करत रहितेंन!” ");
INSERT INTO hne_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मूसा ह मनखेमन ला जबाब दीस, “झन डरव। खड़े रहव अऊ ओ छुटकारा के काम ला देखव, जेला यहोवा ह आज तुम्हर बर करही। जऊन मिसरीमन ला आज तुमन देखत हव, ओमन ला तुमन फेर कभू नइं देखहू। ");
INSERT INTO hne_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","यहोवा ह तुम्हर बर लड़ही; तुमन सिरिप चुपेचाप रहव।” ");
INSERT INTO hne_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","तब यहोवा ह मूसा ला कहिस, “तुमन काबर चिचियाके मोला गोहारत हव? इसरायलीमन ला कह कि ओमन आघू बढ़ंय। ");
INSERT INTO hne_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","पानी ला दू भाग करे बर लउठी ला उठाके अपन हांथ ला समुंदर कोति बढ़ा, ताकि इसरायलीमन समुंदर के सूखा भुइयां म ले होके जा सकंय। ");
INSERT INTO hne_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","मेंह मिसरीमन के मन ला कठोर कर दूहूं अऊ ओमन इसरायलीमन के पीछा करत आहीं। अऊ मेंह फिरौन अऊ ओकर जम्मो सेना के जरिये, अऊ ओकर जम्मो रथ अऊ ओकर घुड़सवारमन के जरिये महिमा पाहूं। ");
INSERT INTO hne_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","जब मेंह फिरौन, ओकर रथ अऊ ओकर घुड़सवारमन के जरिये महिमा पाहूं, त मिसरीमन जान लीहीं कि मेंह यहोवा अंव।” ");
INSERT INTO hne_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","तब परमेसर के स्वरगदूत, जऊन ह इसरायली सेना के आघू-आघू चलत रिहिस, घुंचके ओमन के पाछू म चल दीस। बादर के खंभा ह घलो आघू ले हटके ओमन के पाछू म आ गीस। ");
INSERT INTO hne_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ये किसम ले, स्वरगदूत अऊ बादर के खंभा ह मिसर के सेना अऊ इसरायलीमन के बीच म आ गीन। बादर के कारन रात भर एक तरफ अंधियार अऊ दूसर कोति अंजोर रिहिस; एकरसेति रात भर दूनों तरफ के कोनो भी एक-दूसर के तीर म नइं आ सकिन। ");
INSERT INTO hne_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","तब मूसा ह समुंदर कोति अपन हांथ ला बढ़ाईस, अऊ यहोवा ह ओ पूरा रथिया पूरब ले बहुंत हवा चलाईस, अऊ समुंदर के पानी ह हट गे, अऊ उहां सूखा भुइयां हो गीस; पानी ह दू भाग हो गीस, ");
INSERT INTO hne_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","अऊ इसरायलीमन सूखा भुइयां म समुंदर म ले होके चल दीन, अऊ पानी ह ओमन के डेरी अऊ जेवनी दूनों कोति दीवार सहीं हो गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","मिसरीमन ओमन के पीछा करिन, अऊ फिरौन के जम्मो घोड़ा, रथ अऊ घुड़सवारमन ओमन के पीछा करत समुंदर म आ गीन। ");
INSERT INTO hne_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","रथिया के आखिरी बेरा म यहोवा ह आगी अऊ बादर के खंभा ले खाल्हे मिसरी सेना के ऊपर नजर डालिस, अऊ ओमन म गड़बड़ी कर दीस। ");
INSERT INTO hne_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ओह ओमन के रथ के चक्कामन ला जाम कर दीस, जेकर कारन ओमन ला रथ चलाना मुसकिल हो गे, अऊ मिसरीमन कहे लगिन, “आवव, हमन इसरायलीमन के पीछा करई छोंड़के दूरिहा भाग जावन! यहोवा ह ओमन के खातिर मिसरीमन के बिरूध लड़त हवय।” ");
INSERT INTO hne_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","तब यहोवा ह मूसा ला कहिस, “अपन हांथ ला समुंदर कोति लमा ताकि पानी ह मिसरी अऊ ओमन के रथ अऊ घुड़सवारमन ऊपर फेर बोहावय।” ");
INSERT INTO hne_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मूसा ह अपन हांथ ला समुंदर कोति लमाईस, अऊ बिहनियां होवत समुंदर ह फेर पहिले के सहीं जस के तस हो गीस। मिसरीमन भागे लगिन, पर यहोवा ह ओमन ला समुंदर म बुड़ो दीस। ");
INSERT INTO hne_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","पानी ह वापिस बहे लगिस अऊ रथ अऊ घुड़सवार—फिरौन के ओ जम्मो सेना ला बुड़ो दीस, जेमन इसरायलीमन के समुंदर म पीछा करत रिहिन। ओमा के एको झन भी नइं बांचिन। ");
INSERT INTO hne_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","पर इसरायलीमन समुंदर म ले होके सूखा भुइयां म रेंगत निकल गीन, अऊ पानी ह दीवार के सहीं ओमन के जेवनी अऊ डेरी कोति ठाढ़े रहय। ");
INSERT INTO hne_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ओ दिन यहोवा ह इसरायलीमन ला मिसरीमन के हांथ ले बचाईस, अऊ इसरायलीमन मिसरीमन ला समुंदर के तीर म मरे पड़े देखिन। ");
INSERT INTO hne_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","अऊ जब इसरायलीमन यहोवा के सक्तिसाली हांथ ला मिसरीमन के बिरूध काम करत देखिन, त ओमन यहोवा के भय मानिन अऊ ओमन ओकर ऊपर अऊ ओकर सेवक मूसा ऊपर भरोसा करिन। ");
INSERT INTO hne_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तब मूसा अऊ इसरायलीमन यहोवा बर ये गीत गाईन: “मेंह यहोवा बर गीत गाहूं, काबरकि ओह महान परतापी अय। घोड़ा अऊ घुड़सवार दूनों ला ओह समुंदर म फटिक दे हवय। ");
INSERT INTO hne_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“यहोवा ह मोर बल अऊ मोर सुरकछा अय; ओही ह मोर उद्धार अय। ओह मोर परमेसर अय, अऊ मेंह ओकर परसंसा करहूं, ओह मोर ददा के परमेसर अय, अऊ मेंह ओकर महिमा करहूं। ");
INSERT INTO hne_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","यहोवा ह योद्धा अय; ओकर नांव यहोवा अय। ");
INSERT INTO hne_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","फिरौन के रथमन ला अऊ ओकर सेना ला ओह समुंदर म फटिक दे हवय। फिरौन के सबले बढ़िया अधिकारीमन लाल-समुंदर म बुड़ गे हवंय। ");
INSERT INTO hne_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गहिरा पानी ह ओमन ला ढांप ले हवय; ओमन गहरई म पथरा कस बुड़ गीन। ");
INSERT INTO hne_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे यहोवा, तोर जेवनी हांथ ह ताकत म सानदार रिहिस। हे यहोवा, तोर जेवनी हांथ ह बईरीमन ला चकनाचूर कर दीस। ");
INSERT INTO hne_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“अपन बड़े महानता म, तेंह अपन बिरोधीमन ला खाल्हे फटिक देय। तोर भयंकर गुस्सा ह भड़किस; येह भूंसा के सहीं ओमन ला भसम कर दीस। ");
INSERT INTO hne_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तोर नाक के फूंक ले पानी ह संकला गीस। पानी के लहरा ह दीवार के सहीं ठाढ़ हो गीस; गहिरा पानी ह समुंदर के मांझा म जम गीस। ");
INSERT INTO hne_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","बईरी ह ये कहिके डींग मारिस, ‘मेंह पीछा करहूं, मेंह ओमन ला धर लूहूं। मेंह लूट के सामान ला बांट लूहूं; मेंह ओमन ला अपन बर ठूंसके भर लूहूं। मेंह अपन तलवार ला खींचके निकालहूं अऊ मोर हांथ ह ओमन ला नास कर दीही।’ ");
INSERT INTO hne_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","पर तेंह अपन सांस फूंके, अऊ समुंदर ह ओमन ला ढांप लीस। ओमन अथाह पानी म सीसा के सहीं बुड़ गीन। ");
INSERT INTO hne_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे यहोवा, देवतामन म तोर कस कोन हवय? कोन हवय तोर कस— पबितरता म सानदार, महिमा म अद्भूत, अऊ अचम्भो के काम करइया? ");
INSERT INTO hne_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“तेंह अपन जेवनी हांथ ला बढ़ाथस, अऊ धरती ह तोर बईरीमन ला लील लेथे। ");
INSERT INTO hne_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","अपन बड़े मया म तेंह ओ मनखेमन के अगुवई करबे, जेमन ला तेंह छोंड़ाय हस। अपन ताकत ले तेंह ओमन ला अपन पबितर निवास म ले जाबे। ");
INSERT INTO hne_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","जाति-जाति के मनखेमन सुनके कांपे लगहीं; पलिस्ती के मनखेमन म डर हमा जाही। ");
INSERT INTO hne_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोम के मुखियामन भयभीत हो जाहीं, मोआब के अगुवामन कांपे लगहीं, कनान के मनखेमन के मन ह पिघल जाही; ");
INSERT INTO hne_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","आतंक अऊ भय ओमन म छा जाही। हे यहोवा, जब तक कि तोर मनखेमन निकल नइं जावंय, जब तक कि तोर बिसाय मनखेमन निकल नइं जावंय, तोर भुजबल के दुवारा ओमन पथरा के सहीं इस्थिर बने रहिहीं। ");
INSERT INTO hne_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","तेंह ओमन ला लानबे अऊ अपन निज भाग के पहाड़ म ओमन ला बसाबे— हे यहोवा, येह ओ जगह अय, जेला तेंह अपन निवास बर बनाय, हे परभू, येह ओ पबितर-स्थान अय, जेला तेंह अपन हांथ ले इस्थिर करे हस। ");
INSERT INTO hne_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“यहोवा ह सदाकाल बर राज करथे।” ");
INSERT INTO hne_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","जब फिरौन के घोड़ा, रथ अऊ घुड़सवारमन समुंदर म आ गीन, त यहोवा ह ओमन ऊपर समुंदर के पानी ला वापिस ले आईस, पर इसरायलीमन सूखा भुइयां म समुंदर ले होके रेंगत निकल गीन। ");
INSERT INTO hne_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तब हारून के बहिनी, मिरियम अगमजानी ह अपन हांथ म डफली धरिस, अऊ ओकर संग जम्मो माईलोगनमन डफली धरके नाचे लगिन। ");
INSERT INTO hne_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","मिरियम ह ओमन बर ये गीत गाईस: “यहोवा के गीत गावव, काबरकि ओह महान परतापी अय। घोड़ा अऊ घुड़सवार दूनों ला ओह समुंदर म फटिक दे हवय।” ");
INSERT INTO hne_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","तब मूसा ह इसरायलीमन ला लाल-समुंदर ले सूर के सुन्ना जगह म ले गीस। तीन दिन तक ओमन सुन्ना जगह म चलिन, पर ओमन ला पानी नइं मिलिस। ");
INSERT INTO hne_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","जब ओमन मारा नांव के ठऊर म आईन, त ओमन उहां के पानी ला नइं पी सकिन, काबरकि ओ पानी ह करू रिहिस। (एकर कारन ओ ठऊर ला मारा कहे जाथे।) ");
INSERT INTO hne_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","तब मनखेमन मूसा के बिरूध बड़बड़ाय लगिन अऊ कहिन, “हमन का ला पीबो?” ");
INSERT INTO hne_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","तब मूसा ह यहोवा करा गोहारिस, अऊ यहोवा ह ओला एक ठन लकड़ी के कुटा देखाईस। मूसा ह ओला पानी म फटिक दीस, अऊ ओ पानी ह पीये के लईक हो गीस। उहां यहोवा ह ओमन बर एक ठन नियम अऊ हुकूम बनाईस अऊ ओमन ला परखिस। ");
INSERT INTO hne_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ओह कहिस, “कहूं तुमन यहोवा अपन परमेसर के बात ला धियान देके सुनहू, अऊ जऊन कुछू ओकर नजर म सही अय, ओला करहू, कहूं तुमन ओकर हुकूम अऊ ओकर जम्मो नियममन ला मानहू, त जऊन महामारी मेंह मिसरीमन ऊपर लाने रहेंव, ओमा के एको ठन ला तुम्हर ऊपर नइं लानंव, काबरकि मेंह यहोवा अंव, जऊन ह तुमन ला चंगा करथे।” ");
INSERT INTO hne_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","तब ओमन एलीम नांव के जगह म आईन, जिहां पानी के बारह ठन सोता अऊ सत्तर ठन खजूर के रूख रहंय, अऊ ओमन ओ सोतामन के पानी के तीर म अपन डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","तब पूरा इसरायली समाज ह एलीम ले आघू बढ़िस अऊ ओमन सीन नांव के निरजन जगह म आईन, जऊन ह एलीम अऊ सीनय पहाड़ के बीच म हवय। मिसर देस ले निकले के दूसरा महिना के पंदरहवां दिन इसरायलीमन उहां हबरिन। ");
INSERT INTO hne_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ओ निरजन जगह म जम्मो इसरायली समाज ह मूसा अऊ हारून के बिरूध बड़बड़ाय लगिस। ");
INSERT INTO hne_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","इसरायलीमन ओमन ला कहिन, “बने होतिस यदि हमन यहोवा के हांथ ले मिसर म ही मर गे रहितेंन! उहां हमन मांस ले भरे कढ़ाही के तीर म बईठके अपन ईछा के मुताबिक जम्मो किसम के जेवन करत रहेंन, पर तुमन हमन ला ये निरजन जगह म एकरसेति लाने हवव कि ये पूरा समाज भूख के मारे मर जावय।” ");
INSERT INTO hne_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तब यहोवा ह मूसा ला कहिस, “मेंह तुम्हर बर स्वरग ले रोटी बरसाहूं। मनखेमन हर दिन बाहिर जाके अपन दिन भर के रोटी संकेल लेवंय। ये किसम ले मेंह ओमन ला परखहूं अऊ देखहूं कि ओमन मोर हुकूम ला मानथें कि नइं। ");
INSERT INTO hne_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","हप्ता के हर छठवां दिन ओमन आने दिन ले दू गुना जेवन संकेलंय, अऊ ओला रांधंय।” ");
INSERT INTO hne_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","मूसा अऊ हारून जम्मो इसरायलीमन ला कहिन, “सांझ के तुमन जान जाहू कि येह यहोवा अय, जऊन ह तुमन ला मिसर देस ले बाहिर निकाल लानिस, ");
INSERT INTO hne_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","अऊ बिहनियां तुमन यहोवा के महिमा ला देखहू, काबरकि ओह अपन बिरोध म तुम्हर बड़बड़ई ला सुने हवय। हमन कोन अन कि तुमन हमर बिरूध म बड़बड़ावव?” ");
INSERT INTO hne_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","मूसा ह ये घलो कहिस, “तुमन जान लूहू कि येह यहोवा अय, जऊन ह तुम्हर खाय बर सांझकुन मांस अऊ बिहनियां तुम्हर जरूरत के पूरा रोटी देथे, काबरकि ओह अपन बिरूध तुम्हर बड़बड़ई ला सुन ले हवय। हमन कोन अन? तुमन हमर बिरूध नइं बड़बड़ावत हव, पर यहोवा के बिरूध बड़बड़ावत हव।” ");
INSERT INTO hne_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","तब मूसा ह हारून ला कहिस, “जम्मो इसरायली समाज ले ये कहि दे, ‘यहोवा के आघू म आवव, काबरकि ओह तुम्हर बड़बड़ई ला सुने हवय।’ ” ");
INSERT INTO hne_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","जब हारून ह जम्मो इसरायली समाज ले गोठियावत रिहिस, त ओमन निरजन जगह कोति नजर करिन, अऊ उहां बादर म यहोवा के महिमा परगट होवत देखिन। ");
INSERT INTO hne_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मेंह इसरायलीमन के बड़बड़ई ला सुने हवंव। ओमन ला बता, ‘सांझकुन तुमन ला मांस अऊ बिहनियां के बेरा तुमन ला भरपेट रोटी खाय बर मिलही। तब तुमन जानहू कि मेंह यहोवा तुम्हर परमेसर अंव।’ ” ");
INSERT INTO hne_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ओ दिन संझा के बेरा बटेरमन आईन अऊ छावनी ह बटेरमन ले भर गीस, अऊ बिहनियां के बेरा छावनी म चारों कोति ओस के एक परत दिखिस। ");
INSERT INTO hne_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","जब ओस ह सूखा गीस, त पाला के सहीं एक पतला परत निरजन जगह के भुइयां म पड़े दिखिस। ");
INSERT INTO hne_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","जब इसरायलीमन येला देखिन, त ओमन आपस म कहे लगिन, “येह का ए?” काबरकि ओमन नइं जानत रिहिन कि ओह का रिहिस। मूसा ह ओमन ला कहिस, “येह ओ रोटी ए, जेला यहोवा ह तुमन ला खाय बर दे हवय। ");
INSERT INTO hne_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","येह यहोवा के हुकूम अय: ‘हर एक झन अपन जरूरत के मुताबिक खाय बर संकेल लेवय। अपन तम्बू म हर एक मनखे बर एक-एक ओमेर संकेलव।’ ” ");
INSERT INTO hne_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इसरायलीमन वइसनेच करिन, जइसे ओमन ला कहे गीस; कोनो मन थोरकन, त कोनो मन जादा संकेलिन। ");
INSERT INTO hne_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","अऊ जब ओमन येला ओमेर म नापिन, त जऊन ह जादा संकेले रिहिस, ओकर करा बहुंत जादा नइं रिहिस, अऊ जऊन ह थोरकन संकेले रिहिस, ओकर करा कम नइं होईस। पर हर एक झन अपन जरूरत के मुताबिक ही संकेले रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","तब मूसा ह ओमन ला कहिस, “कोनो भी मनखे बिहनियां होवत तक येमा के कुछू चीज ला बचाके झन रखय।” ");
INSERT INTO hne_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","पर ओमा के कुछू मनखेमन मूसा के गोठ ला धियान नइं दीन; अऊ येमा के कुछू भाग ला बिहनियां बर रख लीन, पर ओमा कीरा पर गे अऊ ओह बस्साय लगिस। एकरसेति मूसा ह ओमन ऊपर गुस्सा होईस। ");
INSERT INTO hne_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","रोज बिहनियां हर एक जन अपन जरूरत के मुताबिक ओला संकेलंय, अऊ जब घाम होवय, त ओह टघल जावय। ");
INSERT INTO hne_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","हप्ता के छठवां दिन, ओमन आने दिन के तुलना म दू गुना संकेलिन—हर एक मनखे बर दू ओमेर—अऊ समाज के अगुवामन आके मूसा ला ये बात के सूचना दीन। ");
INSERT INTO hne_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ओह ओमन ला कहिस, “यहोवा ह ये हुकूम दे हवय: ‘कल बिसराम दिन अय, यहोवा बर एक पबितर बिसराम दिन। एकरसेति, जऊन कुछू तुमन रांधे बर चाहत हव, ओला रांध लव अऊ जऊन कुछू तुमन उसने बर चाहत हव, ओला उसन लव। जतेक ह बांच जाही, ओला बिहनियां होवत तक रख लेवव।’ ” ");
INSERT INTO hne_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","तब ओमन मूसा के हुकूम के मुताबिक ओला बिहनियां होवत तक बंचाके रखिन, अऊ ओह बास नइं मारिस अऊ ओमा कीरा नइं लगिस। ");
INSERT INTO hne_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","मूसा ह कहिस, “आज तुमन इही ला खावव, काबरकि आज यहोवा बर बिसराम दिन अय। येमा के कुछू भी चीज आज तुमन ला मैदान म नइं मिलही। ");
INSERT INTO hne_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","हप्ता के छै दिन तुमन येला संकेलव, पर सातवां दिन बिसराम दिन अय, अऊ ओ दिन येह तुमन ला नइं मिलय।” ");
INSERT INTO hne_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","तभो ले, कुछू मनखेमन सातवां दिन घलो ओला संकेले बर गीन, पर ओमन ला कुछू नइं मिलिस। ");
INSERT INTO hne_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब यहोवा ह मूसा ला कहिस, “तुमन कब तक मोर हुकूम अऊ निरदेसमन ला नइं मानहू? ");
INSERT INTO hne_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","अपन मन म ये बात ला रख लव कि यहोवा ह तुमन ला बिसराम दिन दे हवय; एकरसेति ओह तुमन ला छठवां दिन दू दिन के पुरता जेवन देथे। सातवां दिन हर एक झन घर म रहंय; कोनो बाहिर झन निकलय।” ");
INSERT INTO hne_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","एकरसेति मनखेमन सातवां दिन बिसराम करिन। ");
INSERT INTO hne_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","मनखेमन ओ जेवन के नांव मन्ना रखिन। ओह सफेद धनियां के बीजा सहीं रिहिस, अऊ ओकर सुवाद ह मंधरस ले बने छोटे पातर मीठा पपड़ी सहीं रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मूसा ह इसरायलीमन ला कहिस, “यहोवा ह ये हुकूम दे हवय: ‘एक ओमेर मन्ना अवइया पीढ़ी के मनखेमन बर रख लेवव, ताकि ओमन ओ जेवन ला देखंय, जेला मेंह तुमन ला निरजन जगह म देय हवंव, जब मेंह तुमन ला मिसर देस ले निकालके लानेंव।’ ” ");
INSERT INTO hne_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","तब मूसा ह हारून ला कहिस, “एक ठन बरतन ले अऊ ओमा एक ओमेर मन्ना ले अऊ ओला यहोवा के आघू म मढ़ा दे ताकि ओह अवइया पीढ़ी के मनखेमन बर रहय।” ");
INSERT INTO hne_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","यहोवा के मूसा ला दिये हुकूम के मुताबिक, हारून ह मन्ना ला करार कानून के पटियामन के संग रख दीस, ताकि ओला बचाय जा सकय। ");
INSERT INTO hne_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इसरायलीमन चालीस साल तक मन्ना खाईन, जब तक कि ओमन ओ देस म नइं हबर गीन, जिहां ओमन ला बसना रिहिस; ओमन तब तक मन्ना ला खाईन, जब तक कि ओमन कनान देस के सीमना म नइं हबर गीन। ");
INSERT INTO hne_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(एक ओमेर ह एक एपा के दसवां हिस्सा होथे।) ");
INSERT INTO hne_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","पूरा इसरायली समाज ह सीन नांव के निरजन जगह ले आघू बढ़िस, ओमन जगह-जगह के यातरा करत गीन, जइसे कि यहोवा ह ओमन ला हुकूम दीस। ओमन रपीदीम नांव के जगह म डेरा डालिन, पर उहां मनखेमन के पीये बर पानी नइं रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","एकरसेति ओमन मूसा ले झगरा करे लगिन अऊ कहिन, “हमन ला पीये बर पानी दे।” मूसा ह जबाब दीस, “तुमन काबर मोर संग झगरा करत हव? तुमन काबर यहोवा के परिछा लेवत हव?” ");
INSERT INTO hne_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","पर मनखेमन पानी बर पीयासन रिहिन, अऊ ओमन मूसा के बिरूध बड़बड़ाय लगिन। ओमन कहिन, “तेंह काबर हमन ला मिसर देस ले बाहिर निकालके ले आय कि हमन अऊ हमर लइकामन अऊ पसुमन पीयास के मारे मर जावन?” ");
INSERT INTO hne_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","तब मूसा ह यहोवा ले चिचियाके गोहारिस, “मेंह ये मनखेमन के का करंव? ओमन मोर ऊपर पथरवाह करे बर लगभग तियार हवंय।” ");
INSERT INTO hne_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","यहोवा ह मूसा ला जबाब दीस, “मनखेमन के आघू म जा। अपन संग इसरायल के कुछू अगुवामन ला ले अऊ जऊन लउठी ले तेंह नील नदी ला मारे रहय, ओला अपन हांथ म ले अऊ जा। ");
INSERT INTO hne_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","मेंह उहां तोर आघू म होरेब पहाड़ ऊपर चट्टान के बाजू म ठाढ़े रहिहूं। तेंह लउठी ले ओ चट्टान ला मारबे, अऊ मनखेमन के पीये बर ओमा ले पानी निकलही।” अऊ मूसा ह इसरायल के अगुवामन के आघू म वइसनेच करिस। ");
INSERT INTO hne_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","अऊ ओह ओ ठऊर के नांव मस्सा अऊ मरीबा रखिस, काबरकि इसरायलीमन उहां झगरा करे रिहिन, ये कहिके यहोवा ला परखे रिहिन, “यहोवा ह हमर बीच हवय कि नइं?” ");
INSERT INTO hne_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","रपीदीम म अमालेकीमन आईन अऊ इसरायलीमन ऊपर हमला कर दीन। ");
INSERT INTO hne_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","मूसा ह यहोसू ला कहिस, “हमर म के कुछू मनखेमन ला छांट ले अऊ जाके अमालेकीमन ले लड़ई कर। कल मेंह परमेसर के लउठी ला अपन हांथ म धरके पहाड़ी के ऊपर म ठाढ़े रहिहूं।” ");
INSERT INTO hne_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","मूसा के हुकूम के मुताबिक यहोसू ह अमालेकीमन ले लड़िस, अऊ मूसा, हारून अऊ हूर, पहाड़ी के टीप म चघ गीन। ");
INSERT INTO hne_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","जब तक मूसा ह अपन हांथ ला ऊपर करे रहय, तब तक इसरायलीमन जीतंय, पर जब-जब ओह अपन हांथ ला खाल्हे कोति करय, त अमालेकीमन जीतंय। ");
INSERT INTO hne_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","जब मूसा के हांथ ह थक गीस, त ओमन एक ठन पथरा ला लेके ओकर बईठे बर मढ़ा दीन अऊ ओह ओकर ऊपर बईठ गीस। हारून अऊ हूर ओकर हांथमन ला उठाय रखिन—एक झन ह एक कोति अऊ एक झन ह दूसर कोति—जेकर ले ओकर हांथमन बेर बुड़त तक इस्थिर रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","अऊ यहोसू ह अमालेकी सेना ला तलवार के बल म हरा दीस। ");
INSERT INTO hne_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तब यहोवा ह मूसा ला कहिस, “ये बात ला एक ठन चामपट्टी म लिख ले ताकि येला सुरता करे जावय, अऊ येकर घलो धियान रख कि यहोसू ह ये बात ला सुनय, काबरकि मेंह धरती ले अमालेकीमन के नामोनिसान मिटा दूहूं।” ");
INSERT INTO hne_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","मूसा ह एक ठन बेदी बनाईस अऊ ओकर नांव रखिस—यहोवा ह मोर झंडा ए। ");
INSERT INTO hne_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","मूसा ह कहिस, “यहोवा ह पीढ़ी-पीढ़ी तक अमालेकीमन के बिरूध लड़ई करत रहिही, काबरकि ओमन यहोवा के सिंघासन के बिरूध हांथ उठाय हवंय।” ");
INSERT INTO hne_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","मूसा के ससुर, मिदयान देस के पुरोहित यितरो ह ओ जम्मो बात ला सुनिस, जऊन ला परमेसर ह मूसा अऊ अपन इसरायली मनखेमन बर करे रिहिस, अऊ ये कि यहोवा ह कइसे इसरायलीमन ला मिसर देस ले निकालके लानिस। ");
INSERT INTO hne_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","मूसा ह अपन घरवाली सिप्पोरा अऊ अपन दू झन बेटा ला अपन ससुर यितरो करा पठो दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","मूसा ह ओमा के एक झन बेटा के नांव ये कहिके गेरसोम रखिस, “मेंह परदेस म परदेसी हो गे हंव”; ");
INSERT INTO hne_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","अऊ ओह ये कहिके दूसर बेटा के नांव एलिएजेर रखिस, “मोर ददा के परमेसर ह मोर मददगार रिहिस; ओह मोला फिरौन के तलवार ले बचाईस।” ");
INSERT INTO hne_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मूसा के ससुर यितरो ह मूसा के घरवाली अऊ ओकर बेटामन ला लेके मूसा करा ओ निरजन जगह म आईस, जिहां ओह परमेसर के पहाड़ के लकठा म डेरा डाले रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","यितरो ह ओकर करा ये खबर पठोईस, “मेंह तोर ससुर यितरो, तोर घरवाली अऊ तोर दूनों बेटामन ला लेके तोर करा आवत हंव।” ");
INSERT INTO hne_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","तब मूसा ह अपन ससुर ले भेंट करे बर बाहिर निकलिस अऊ ओकर दंडवत करके ओला चूमिस। ओमन एक-दूसर के हालचाल पुछत तम्बू के भीतर गीन। ");
INSERT INTO hne_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","मूसा ह अपन ससुर ला ओ जम्मो बात बताईस, जऊन ला इसरायलीमन के हित म यहोवा ह फिरौन अऊ मिसरीमन के संग करे रिहिस, अऊ ओ जम्मो कठिनई के घलो बखान करिस, जऊन ह यातरा के बखत ओमन ऊपर परिस अऊ यहोवा ह कइसे ओमन ला बचाईस। ");
INSERT INTO hne_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","यितरो ह यहोवा के ओ जम्मो भलई के काम ला सुनके खुस होईस, जऊन ला ओह इसरायलीमन बर करे रिहिस याने कि ओह कइसे ओमन ला मिसरीमन के हांथ ले छोंड़ाय रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","यितरो ह कहिस, “यहोवा के परसंसा होवय, जऊन ह तुमन ला फिरौन अऊ मिसरीमन के हांथ ले छोंड़ाईस, अऊ जऊन ह मनखेमन ला मिसरीमन के हांथ ले छोंड़ाईस। ");
INSERT INTO hne_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब मेंह जान डारेंव कि यहोवा ह आने जम्मो देवतामन ले महान अय, काबरकि ओह येला ओमन के संग साबित कर दीस, जऊन मन घमंडी होके इसरायलीमन संग खराप बरताव करिन।” ");
INSERT INTO hne_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","तब मूसा के ससुर यितरो ह परमेसर बर होम-बलिदान अऊ आने बलिदान चघाईस, अऊ हारून ह इसरायलीमन के जम्मो अगुवामन संग मूसा के ससुर यितरो करा आईस, ताकि ओमन ओकर संग परमेसर के आघू म जेवन कर सकंय। ");
INSERT INTO hne_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","दूसर दिन मूसा ह मनखेमन के नियाय करे बर नियायधीस के आसन म बईठिस, अऊ बिहान ले लेके सांझ तक मनखेमन मूसा के चारों कोति ठाढ़े रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","जब मूसा के ससुर ह ओ जम्मो ला देखिस, जेला मूसा ह मनखेमन बर करत रिहिस, त ओह कहिस, “येह का अय, जऊन ला तेंह मनखेमन बर करत हस? नियाय करे बर तेंह एके झन काबर बईठथस, जबकि ये जम्मो मनखेमन बिहान ले सांझ तक तोर चारों कोति ठाढ़े रहिथें?” ");
INSERT INTO hne_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मूसा ह ओला जबाब दीस, “काबरकि मनखेमन मोर करा परमेसर के ईछा जाने बर आथें। ");
INSERT INTO hne_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","जब भी ओमन म कोनो झगरा होथे, त ओमन मोर करा आथें, अऊ मेंह ओमन के फैसला करथंव अऊ ओमन ला परमेसर के नियम अऊ बिधिमन ला बताथंव।” ");
INSERT INTO hne_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मूसा के ससुर ह जबाब दीस, “जऊन कुछू तेंह करत हस, ओह सही नो हय। ");
INSERT INTO hne_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","अइसन म तेंह अऊ ये मनखे, जेमन तोर करा आथें, तुमन जम्मो अपनआप ला बहुंत थका डारहू। ये काम ह तोर बर बहुंत जादा हे; तेंह एके झन येला नइं कर सकस। ");
INSERT INTO hne_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","एकरसेति मोर बात ला सुन; मेंह तोला कुछू सलाह देवत हंव, अऊ परमेसर ह तोर संग रहय। तेंह परमेसर के आघू म ये मनखेमन के परतिनिधि बन अऊ ओमन के झगरा ला परमेसर करा लान। ");
INSERT INTO hne_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ओमन ला ओकर नियम अऊ बिधिमन ला सिखोय कर, अऊ ओमन ला देखा कि ओमन कइसे जिनगी जीयंय अऊ ओमन कइसे बरताव करंय। ");
INSERT INTO hne_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","पर ये जम्मो मनखेमन ले योग्य मनखेमन ला छांट ले—अइसन मनखे, जऊन मन परमेसर के भय मानथें, ईमानदार मनखे, जऊन मन बेईमानी के कमई ले दूरिहा रहिथें—अऊ येमन ला हजार-हजार, सौ-सौ, पचास-पचास अऊ दस-दस मनखेमन के ऊपर अधिकारी ठहिरा दे। ");
INSERT INTO hne_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","येमन ही जम्मो बेरा मनखेमन बर नियायधीस के रूप म काम करंय, पर ओमन कठिन मामला ला तोर करा लानंय; सधारन मामला के फैसला ओमन खुद करंय। येह तोर बोझा ला हल्का करही, काबरकि ये बोझा ला ओमन तोर संग बांटहीं। ");
INSERT INTO hne_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","कहूं तेंह येला करथस अऊ परमेसर ह अइसने करे के हुकूम देथे, त तेंह बुता ला सही ढंग से करे के लईक रहिबे, अऊ जम्मो मनखेमन संतोस मन से अपन-अपन घर जाहीं।” ");
INSERT INTO hne_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","मूसा ह अपन ससुर के गोठ ला मानिस अऊ जऊन कुछू ओह कहिस, वइसने ही करिस। ");
INSERT INTO hne_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ओह जम्मो इसरायलीमन ले योग्य मनखेमन ला चुनिस अऊ ओमन ला मनखेमन के अगुवा, हजार-हजार, सौ-सौ, पचास-पचास अऊ दस-दस मनखे ऊपर अधिकारी ठहिराईस। ");
INSERT INTO hne_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ओमन जम्मो बेरा मनखेमन बर नियायधीस के रूप म काम करिन। कठिन मामला ला ओमन मूसा करा लानंय, पर सधारन मामला के फैसला ओमन खुद करंय। ");
INSERT INTO hne_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","तब मूसा ह अपन ससुर ला बिदा करिस अऊ यितरो ह अपन देस ला लहुंट गीस। ");
INSERT INTO hne_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इसरायलीमन के मिसर देस ले निकले के तीसरा महिना के ठीक पहिला दिन ओमन सीनय के सुन्ना जगह म आईन। ");
INSERT INTO hne_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","रपीदीम ले आघू बढ़े के बाद, ओमन सीनय के सुन्ना जगह म हबरिन अऊ इसरायलीमन उहां पहाड़ के आघू म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","तब मूसा ह ऊपर पहाड़ म परमेसर करा गीस, अऊ यहोवा ह पहाड़ ले ओला बलाके कहिस, “तें याकूब के संतान अऊ इसरायल के मनखेमन ला ये बात बता: ");
INSERT INTO hne_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘तुमन खुद देखे हवव कि मेंह मिसर देस के का हाल करेंव, अऊ कइसे तुमन ला गिधवा सहीं डेना म बईठाके अपन करा लानेंव। ");
INSERT INTO hne_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","अब यदि तुमन मोर गोठ ला पूरा मानहू, अऊ मोर करार ला बनाय रखहू, त जम्मो जाति के मनखेमन म तुमन मोर कीमती निज भाग होहू। हालाकि जम्मो धरती ह मोर अय, ");
INSERT INTO hne_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","तुमन मोर बर पुरोहितमन के एक राज अऊ एक पबितर जाति होहू।’ ये बात तेंह इसरायलीमन ले कह।” ");
INSERT INTO hne_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","तब मूसा ह वापिस गीस अऊ मनखेमन के अगुवामन ला बलाईस अऊ ओ जम्मो बात ओमन के आघू म रखिस, जेला कहे के हुकूम यहोवा ह ओला दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","तब जम्मो मनखेमन एके संग जबाब दीन, “हमन ओ जम्मो काम करबो, जेला यहोवा ह कहे हवय।” मूसा ह मनखेमन के ये बात वापिस जाके यहोवा ला बताईस। ");
INSERT INTO hne_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","यहोवा ह मूसा ला कहिस, “देख, मेंह एक ठन घिटके बादर म होके तोर करा आहूं अऊ तोर ले गोठियाहूं, अऊ मनखेमन मोला तोर ले बात करत सुनहीं अऊ हमेसा तोर ऊपर भरोसा करहीं।” तब मूसा ह मनखेमन के कहे बात यहोवा ला सुनाईस। ");
INSERT INTO hne_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","अऊ यहोवा ह मूसा ला कहिस, “मनखेमन करा जा अऊ ओमन ला आज अऊ कल पबितर कर। ओमन अपन-अपन कपड़ा ला धोवंय ");
INSERT INTO hne_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","अऊ तीसर दिन तियार रहंय, काबरकि ओ दिन यहोवा ह जम्मो मनखेमन के देखत म सीनय पहाड़ म उतरही। ");
INSERT INTO hne_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","तेंह मनखेमन बर पहाड़ के चारों कोति एक सीमना बना देबे अऊ ओमन ला कहिबे, ‘सावधान रहव अऊ कोनो पहाड़ करा झन जावय अऊ न ही कोनो ओकर सीमना ला छुवय। जऊन कोनो पहाड़ ला छुवय, ओह मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ओला पथरवाह करे जाही या तीर चलाके ओला मार डारे जाही; कोनो ओ मनखे ला झन छुवंय। चाहे ओह मनखे होवय या पसु, ओला जिंदा नइं छोंड़े जावय।’ जब तुरही फूंके के लम्बा अवाज सुनई दीही, तब मनखेमन पहाड़ के लकठा म आवंय।” ");
INSERT INTO hne_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","तब मूसा ह पहाड़ ले उतरके मनखेमन करा गीस अऊ ओमन ला पबितर करिस, अऊ ओमन अपन-अपन कपड़ा ला धोईन। ");
INSERT INTO hne_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","तब मूसा ह मनखेमन ला कहिस, “अपनआप ला तीसर दिन बर तियार करव; कोनो माईलोगन संग झन सुतहू।” ");
INSERT INTO hne_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तीसर दिन के बिहनियां बादर गरजिस अऊ बिजली चमकिस; पहाड़ ऊपर कारी घटा छा गीस, अऊ तुरही के तेज अवाज सुनई दीस। डेरा म जम्मो झन कांपे लगिन। ");
INSERT INTO hne_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","तब मूसा ह परमेसर ले भेंट कराय बर मनखेमन ला डेरा ले बाहिर ले आईस, अऊ ओमन पहाड़ के खाल्हे म ठाढ़ हो गीन। ");
INSERT INTO hne_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","सीनय पहाड़ ह धुआं ले भर गे रिहिस, काबरकि यहोवा ह आगी म होके उहां उतरे रिहिस। धुआं ह अइसे ऊपर उठत रिहिस, जइसे कोनो भट्ठी ले धुआं उठथे, अऊ पूरा पहाड़ ह बहुंत जोर से कांपे लगिस। ");
INSERT INTO hne_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","जब तुरही के अवाज ह तेज होवत गीस, त मूसा ह गोठियाईस अऊ परमेसर के अवाज ह ओकर जबाब दीस। ");
INSERT INTO hne_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","यहोवा ह सीनय पहाड़ के ऊपर म उतरिस अऊ मूसा ला पहाड़ के ऊपर म बलाईस, त मूसा ह ऊपर गीस ");
INSERT INTO hne_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","अऊ यहोवा ह ओला कहिस, “उतरके खाल्हे जा अऊ मनखेमन ला चेता दे ताकि ओमन यहोवा ला देखे बर अपन सीमना ला झन लांघंय, नइं तो बहुंते झन नास हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","अऊ त अऊ जऊन पुरोहितमन यहोवा करा आथें, ओमन घलो अपनआप ला जरूर पबितर करंय, नइं तो यहोवा के कोप ओमन ऊपर घलो भड़कही।” ");
INSERT INTO hne_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मूसा ह यहोवा ला कहिस, “मनखेमन सीनय पहाड़ ऊपर नइं आ सकंय, काबरकि तेंह खुद ये कहिके हमन ला चेताय हस, ‘पहाड़ के चारों कोति सीमना बांध दे अऊ पबितर रूप म येला अलग रख।’ ” ");
INSERT INTO hne_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","यहोवा ह जबाब दीस, “तेंह खाल्हे जा अऊ अपन संग हारून ला ऊपर लेके आ। पर पुरोहित अऊ मनखेमन यहोवा करा ऊपर आय बर सीमना ला झन लांघंय, नइं तो ओकर कोप ह ओमन ऊपर भड़कही।” ");
INSERT INTO hne_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","तब मूसा ह खाल्हे उतरके मनखेमन ला यहोवा के कहे जम्मो बात ला बताईस। ");
INSERT INTO hne_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","अऊ परमेसर ह ये जम्मो बात कहिस: ");
INSERT INTO hne_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“में यहोवा तुम्हर परमेसर अंव, जऊन ह तुमन ला मिसर देस ले, याने कि गुलामी के देस ले निकाल लानिस। ");
INSERT INTO hne_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“तुमन मोर छोंड़ अऊ कोनो ला ईस्वर करके झन मानहू। ");
INSERT INTO hne_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","तुमन अपन बर कोनो भी चीज के कोनो किसम के मूरती झन बनाहू, न तो ऊपर अकास के, न खाल्हे धरती के अऊ न ही पानी म के कोनो चीज के। ");
INSERT INTO hne_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","तुमन ओमन ला न तो दंडवत करहू अऊ न ही ओमन के अराधना करहू, काबरकि में यहोवा, तुम्हर परमेसर ह जलन रखइया परमेसर अंव; अऊ जऊन मन मोर ले घिन करथें, ओमन के पाप के दंड मेंह ओमन के लइकामन के तीसरा अऊ चौथा पीढ़ी तक देथंव, ");
INSERT INTO hne_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","पर जऊन मन मोर ले मया करथें अऊ मोर हुकूममन ला मानथें, ओमन के हजार पीढ़ी तक मेंह अपन मया देखाथंव। ");
INSERT INTO hne_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","तुमन यहोवा अपन परमेसर के नांव बेमतलब के झन लूहू, काबरकि जऊन ह यहोवा के नांव के दुरपयोग करही, ओला ओह दोसी ठहिराही। ");
INSERT INTO hne_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","बिसराम दिन ला पबितर मानके सुरता रखहू। ");
INSERT INTO hne_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","हप्ता के छै दिन तुमन मेहनत करव अऊ अपन जम्मो काम करव, ");
INSERT INTO hne_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","पर सातवां दिन यहोवा तुम्हर परमेसर बर बिसराम दिन ए। ओ दिन तुमन कोनो काम झन करहू, न तो तुमन, न तुम्हर बेटा या बेटीमन, न तुम्हर सेवक या सेविकामन, न तुम्हर पसुमन, अऊ न ही तुम्हर नगर म रहइया कोनो परदेसी। ");
INSERT INTO hne_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","काबरकि छै दिन म यहोवा ह अकास अऊ धरती, समुंदर, अऊ ओमा के जम्मो चीजमन ला बनाईस, पर सातवां दिन ओह अराम करिस। एकरसेति यहोवा ह बिसराम दिन ला आसीस दीस अऊ ओला पबितर ठहिराईस। ");
INSERT INTO hne_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","तुमन अपन दाई-ददा के आदरमान करव, ताकि ओ देस म तुमन बहुंत साल तक जीयव, जेला यहोवा तुम्हर परमेसर ह तुमन ला देवत हे। ");
INSERT INTO hne_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","तुमन कोनो मनखे के हतिया झन करहू। ");
INSERT INTO hne_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","तुमन बेभिचार झन करहू। ");
INSERT INTO hne_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","तुमन चोरी झन करहू। ");
INSERT INTO hne_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","तुमन अपन परोसी के बिरूध म लबारी गवाही झन दूहू। ");
INSERT INTO hne_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","तुमन अपन परोसी के घर के लालच झन करहू। तुमन अपन परोसी के घरवाली के लालच झन करहू, न ही ओकर सेवक या सेविका, न ओकर बईला या गदहा, अऊ न ही ओकर कोनो अऊ चीज के लालच करहू, जऊन ह तुम्हर परोसी के अय।” ");
INSERT INTO hne_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","जब मनखेमन बादर गरजत अऊ बिजली चमकत देखिन अऊ तुरही के अवाज सुनिन अऊ पहाड़ ले धुआं उठत देखिन, त ओमन डर के मारे कांपे लगिन, अऊ दूरिहा म ठाढ़े रिहिन ");
INSERT INTO hne_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","अऊ ओमन मूसा ला कहिन, “तेंह हमन ले गोठिया अऊ हमन सुनबो। पर परमेसर ह हमन ले झन गोठियावय, नइं तो हमन मर जाबो।” ");
INSERT INTO hne_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मूसा ह मनखेमन ला कहिस, “झन डरव। परमेसर ह तुमन ला परखे बर आय हवय, ताकि परमेसर के डर ह तुमन म बने रहय, अऊ तुमन पाप झन करव।” ");
INSERT INTO hne_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","मनखेमन दूरिहा म ही ठाढ़े रिहिन, जबकि मूसा ह घोर अंधियार के तीर म गीस, जिहां परमेसर ह रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तब यहोवा ह मूसा ला कहिस, “इसरायलीमन ले ये कह: ‘तुमन खुद देखे हव कि मेंह स्वरग ले तुम्हर से बात करे हंव: ");
INSERT INTO hne_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","तुमन मोर बाजू म कोनो आने देवता झन बनावव; तुमन अपन बर सोन या चांदी के कोनो देवता झन बनावव। ");
INSERT INTO hne_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘मोर बर तुमन माटी के एक बेदी बनावव अऊ ओमा अपन होम-बलिदान अऊ मेल-बलिदान, तुम्हर भेड़ अऊ बोकरा अऊ पसुमन ला चघावव। जिहां कहूं में अपन नांव के आदर कराथंव, उहां में तुम्हर करा आहूं अऊ तुमन ला आसीस दूहूं। ");
INSERT INTO hne_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","कहूं तुमन मोर बर पथरा के एक बेदी बनाथव, त ओला गढ़े गय पथरामन ले झन बनावव, काबरकि यदि तुमन ओमा औजार के उपयोग करहू, त ओह असुध हो जाही। ");
INSERT INTO hne_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","अऊ मोर बेदी करा निसेनी लगाके ऊपर झन आहू, नइं तो तुम्हर नंगरा देहें ह दिख जाही।’ ");
INSERT INTO hne_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“येमन ओ कानून अंय, जेमन ला तें ओमन के आघू म बता: ");
INSERT INTO hne_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“कहूं तुमन कोनो इबरी सेवक ला बिसाथव, त ओह छै साल तक तुम्हर सेवा करय, पर सातवां साल ओह बिगर कोनो दाम चुकाय सुतंतर होके चले जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","कहूं ओह एके झन आय हवय, त ओह अकेला सुतंतर होके चले जावय; पर कहूं ओकर आय के समय ओकर घरवाली ओकर संग म रहय, त ओकर घरवाली घलो ओकर संग चले जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","कहूं ओकर मालिक ह कोनो माईलोगन ला ओकर घरवाली के रूप म देथे अऊ ओह बेटा या बेटीमन ला जनमथे, त ओ माईलोगन अऊ लइकामन मालिक के हो जाहीं, अऊ सिरिप ओ मनखे ह एके झन सुतंतर होके जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“पर कहूं ओ सेवक ह ये कहय, ‘मेंह अपन मालिक, अपन घरवाली अऊ अपन लइकामन ले मया करथंव, अऊ सुतंतर होके जाय बर नइं चाहत हंव,’ ");
INSERT INTO hne_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","तब जरूरी अय कि ओकर मालिक ह ओला नियायीमन करा लानय। मालिक ह ओला कपाट या चौखट करा ले जावय अऊ एक ठन सूजा ले ओकर कान ला छेदय। तब ओह जिनगी भर ओ मालिक के सेवक हो जाही। ");
INSERT INTO hne_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“कहूं कोनो मनखे ह अपन बेटी ला सेविका के रूप म बेच देथे, त ओ सेविका ह एक सेवक के सहीं सुतंतर होके झन जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","कहूं ओकर मालिक ह ओकर ले खुस नइं ए, जऊन ह कि ओला अपन बर बिसाय रिहिस, त फेर जरूरी अय कि ओह ओ सेविका ला छोंड़ देवय। ओला अधिकार नइं ए कि ओह सेविका ला परदेसीमन करा बेच देवय, काबरकि ओह सेविका के संग बिसवास ला टोरे हवय। ");
INSERT INTO hne_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","कहूं ओह ओ सेविका ला अपन बेटा बर चुनथे, त फेर जरूरी अय कि ओह ओ सेविका ला एक बेटी के अधिकार देवय। ");
INSERT INTO hne_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","कहूं ओह आने माईलोगन ले बिहाव कर लेथे, तब येह जरूरी अय कि ओह ये सेविका के जेवन-पानी, कपड़ा अऊ ओकर बिहाव संबंधी अधिकार के खियाल रखय। ");
INSERT INTO hne_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","कहूं ओह ओ सेविका के ये तीनों चीजमन के पूरती नइं करय, त फेर ओ सेविका ह बिगर कुछू दाम चुकाय सुतंतर होके जा सकत हे। ");
INSERT INTO hne_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“यदि कोनो मनखे ह आने मनखे ला अइसन जोर से मारय कि ओ मनखे ह मर जावय, त ओ मनखे घलो मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","पर यदि जानबूझके ये हतिया नइं करे गे हवय, पर परमेसर ह येला होवन दीस, त ओह एक अइसन जगह ला भाग जावय, जेला मेंह ठहिराहूं। ");
INSERT INTO hne_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","पर यदि कोनो मनखे ह ताक धरके अऊ जानबूझके आने मनखे ला मार डारथे, त ओ मनखे ला मोर बेदी ले हटाय जावय अऊ मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“कहूं कोनो मनखे ह अपन दाई या ददा ला मारथे-पीटथे, त ओला मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“कोनो मनखे ह कोनो आने मनखे के अपहरन कर लेथे, त चाहे अपहरन करे गय मनखे ला बेच दिये गय हो या फेर ओह अपहरनकर्ता करा होवय, दूनों स्थिति म अपहरनकर्ता ला मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“जऊन ह अपन दाई या ददा ला सराप देथे, ओला घलो मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“कहूं दू झन म झगरा होथे अऊ एक झन ह दूसर ला पथरा म मारथे या मुटका मारथे, जेकर ले ओ दूसर मनखे ह मरय तो नइं, पर खटिया धर लेथे, ");
INSERT INTO hne_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","अऊ यदि ओह लउठी के सहारा म चले-फिरे लगथे, त फेर चोट पहुंचानेवाला मनखे ला जिम्मेदार झन ठहिराय जावय; पर ओह चोट खाय मनखे के नुकसान के भरपई करय अऊ ओकर पूरा ठीक होवत तक ईलाज के खरचा उठावय। ");
INSERT INTO hne_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“कहूं कोनो मनखे ह अपन नर या नारी गुलाम ला लउठी या छड़ ले मारथे, जेकर ले ओह मर जाथे, त फेर ओ मनखे ला जरूर सजा मिलय, ");
INSERT INTO hne_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","पर कहूं ओ गुलाम ह एक या दू दिन के बाद ठीक हो जाथे, त फेर ओ मनखे ला सजा झन दिये जावय, काबरकि ओ गुलाम ह ओकर संपत्ति अय। ");
INSERT INTO hne_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“कहूं मनखेमन झगरा करत रहिथें अऊ ये दौरान ओमा के कोनो के दुवारा कोनो देहें म रहे माईलोगन ला चोट लगथे अऊ समय के पहिली ओकर लइका ह जनमथे, पर कोनो गंभीर चोट नइं लगय, त ओ चोट पहुंचानेवाला मनखे ह माईलोगन के घरवाला के मांग अऊ अदालत के फैसला के मुताबिक जुरबाना भरय। ");
INSERT INTO hne_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","पर कहूं ओला गंभीर चोट लगथे, त फेर तुमन परान के बलदा परान, ");
INSERT INTO hne_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","आंखी के बलदा आंखी, दांत के बलदा दांत, हांथ के बलदा हांथ, गोड़ के बलदा गोड़, ");
INSERT INTO hne_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","जरे के बलदा जलाके, घाव के बलदा घाव देके अऊ चोट के बलदा चोट पहुंचाके लव। ");
INSERT INTO hne_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“कहूं कोनो मालिक ह अपन नर या नारी गुलाम ला ओकर आंखी म मारथे, जेकर ले ओकर आंखी ह फूट जाथे, त ओह ओ गुलाम के आंखी के भरपई के बलदा म ओला छोंड़ दे। ");
INSERT INTO hne_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","अऊ कोनो मालिक ह अपन नर अऊ नारी गुलाम ला अइसे मारथे कि ओकर दांत ह टूट जाथे, त ओह ओ गुलाम के दांत के भरपई के बलदा म ओला छोंड़ दे। ");
INSERT INTO hne_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“कहूं कोनो बईला ह कोनो आदमी या माईलोगन ला मारथे, जेकर ले ओह मर जाथे, त फेर ओ बईला ला पथरा फेंक-फेंकके मार डारे जावय, अऊ ओकर मांस ला झन खाय जावय। पर ओ बईला के मालिक ला जिम्मेदार झन ठहिराय जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","पर कहूं कोनो बईला ला सींग मारे के आदत हवय अऊ ओकर मालिक ला चेताय के बाद घलो ओह ओला बांधके नइं रखय अऊ ओ बईला कोनो आदमी या माईलोगन ला मार डारथे, त ओ बईला ला पथरा फेंक-फेंकके मार डारे जावय अऊ ओकर मालिक ला घलो मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","पर यदि बईला के मालिक ले छुड़ौती बर पईसा के मांग करे जावय, त मालिक ह मांगे गय रकम के भुगतान करके अपन परान ला बचा सकथे। ");
INSERT INTO hne_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","यदि बईला ह काकरो बेटा या बेटी ला मार डारथे, तब भी इही कानून लागू होथे। ");
INSERT INTO hne_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","कहूं बईला ह कोनो नर या नारी गुलाम ला मार डारथे, त बईला के मालिक ह ओ गुलाम के मालिक ला तीस सेकेल चांदी देवय, अऊ ओ बईला ला पथरा फेंक-फेंकके मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“कहूं कोनो खंचवा के ढकना ला खोलथे या खंचवा खनके ओला नइं तोपय अऊ ओमा कोनो बईला या गदहा ह गिर परय, ");
INSERT INTO hne_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","त जऊन ह खंचवा ला खोले या खने रिहिस, ओह ओ पसु के मालिक ला नुकसान के भुगतान करय अऊ बलदा म मरे पसु ला ले लेवय। ");
INSERT INTO hne_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“कहूं काकरो बईला ह कोनो दूसर के बईला ला चोट पहुंचाथे अऊ ओ बईला ह मर जावय, त ओ दूनों झन ओ जीयत बईला ला बेचंय अऊ ओकर दाम अऊ मरे पसु दूनों ला आधा-आधा बांट लेवंय। ");
INSERT INTO hne_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","पर कहूं पहिलीच ले ये पता रहय कि ओ बईला म आने ला मारे के आदत हवय, तभो ले ओकर मालिक ह ओला बांधके नइं रखय, त फेर मालिक ह ओ बईला के बलदा म बईला देवय अऊ बलदा म मरहा पसु ला ले लेवय। ");
INSERT INTO hne_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“कहूं कोनो मनखे बईला या भेड़ के चोरी करके ओला मार डारथे या ओला बेच देथे, त ओह ओ बईला के बलदा म पांच ठन बईला अऊ ओ भेड़ के बलदा म चार ठन भेड़ देवय। ");
INSERT INTO hne_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“कहूं चोर ह चोरी करत पकड़े जावय अऊ ओला मारत बखत ओह मर जावय, त चोर ला मारनेवाला ह खून के दोसी नो हय; ");
INSERT INTO hne_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","पर कहूं ये काम बेर निकले के बाद होथे, त चोर ला मारनेवाला ह खून के दोसी अय। “कोनो मनखे चोरी करथे, त जरूरी अय कि ओह नुकसान ला भर दे, पर यदि ओकर करा कुछू नइं ए, त फेर चोरी के भरपई करे बर ओला बेच दिये जावय। ");
INSERT INTO hne_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","कहूं चोराय पसु ह चोर करा जीयत पाय जावय—चाहे ओह बईला या गदहा या भेड़ होवय; त चोर ह ओकर दू गुना भुगतान भरय। ");
INSERT INTO hne_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“कहूं कोनो मनखे अपन पसु ला खेत या अंगूर के बारी म चराथे अऊ ओमन ला खुला छोंड़ देथे अऊ ओमन आने के खेत ला चर देथें, त ओह अपन खेत या अंगूर के बारी के सबले बने फसल ओला बलदा म देके नुकसान के भरपई करय। ");
INSERT INTO hne_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“कहूं कोनो मनखे आगी धराथे, अऊ ओ आगी ह झाड़ीमन म फईल जाथे, जेकर ले अनाज के बीड़ा या खड़े फसल या फेर जम्मो खेत ह जर जावय, त आगी धरइया ह ओकर नुकसान के भरपई जरूर करय। ");
INSERT INTO hne_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“कहूं कोनो मनखे ह अपन परोसी ला चांदी या आने चीज संभालके रखे बर देथे अऊ ओ चीज ह परोसी के घर ले चोरी हो जाथे, अऊ चोर ह यदि पकड़ म आ जावय, त ओह ओकर दू गुना भरय। ");
INSERT INTO hne_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","पर यदि चोर ह पकड़े नइं जावय, त जरूरी अय कि ओ घर के मालिक ला नियायीमन करा लाने जावय, अऊ ओ नियायीमन पता लगावंय कि कहीं घर के मालिक ह तो ओ आने मनखे के संपत्ति म हांथ नइं डारे हवय। ");
INSERT INTO hne_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","गैरकानूनी तरीका ले कब्जा करे गय जम्मो मामला म, चाहे ओह एक ठन बईला या एक ठन गदहा या एक ठन भेड़ या एक ठन कपड़ा या फेर कोनो आने गंवाय चीज हो, जेकर बारे म यदि कोनो मनखे ये कहिथे, ‘येह मोर अय,’ तब ओ दूनों झन अपन मामला ला नियायीमन करा लानंय। जऊन ला नियायीमन दोसी ठहिरावंय, ओह दूसर मनखे ला दू गुना भर देवय। ");
INSERT INTO hne_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“कहूं कोनो मनखे अपन परोसी ला बईला या गदहा या भेड़ या अऊ कोनो पसु संभालके रखे बर देथे अऊ ओकर बाद ओ पसु ह मर जाथे या ओला चोट लगथे या काकरो देखे बिगर कोनो ओला खेदके ले जाथे, ");
INSERT INTO hne_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","त ओ दूनों झन के बीच ये मामला के निपटारा यहोवा के आघू म ये सपथ खवाके करे जावय कि परोसी ह आने मनखे के संपत्ति म हांथ नइं लगाय हवय। संपत्ति के मालिक ह ये बात ला मान लेवय, अऊ नुकसान के भरपई करे के जरूरत नइं परय। ");
INSERT INTO hne_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","पर कहूं ओ परोसी ले पसु ला चोराय गे हवय, त फेर मालिक ला नुकसान के भरपई जरूर करे जावय। ");
INSERT INTO hne_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","कहूं ओ पसु ला कोनो जंगली पसु ह चीर-फार डारय, त परोसी ह ओ पसु के बांचे-खुचे चीज ला सबूत के रूप म लानय अऊ ओला ओ चीर-फार करे गे पसु बर कोनो भरपई करना नइं पड़य। ");
INSERT INTO hne_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“कहूं कोनो मनखे अपन परोसी ले मांगके कोनो पसु ला लानय अऊ मालिक के नइं रहे म ओ पसु ला चोट लगय या ओह मर जावय, त ओ मनखे ह नुकसान ला जरूर भरय। ");
INSERT INTO hne_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","पर कहूं मालिक ह पसु संग म रहय, त मांगके ले जानेवाला मनखे ला नुकसान भरना नइं पड़य। यदि पसु ला भाड़ा म लाने गे रिहिस, त नुकसान के भरपई ओकर दिये गय किराया म हो जाही। ");
INSERT INTO hne_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“कहूं कोनो मनखे ह कोनो कुंवारी कन्या ला भूलवार के ओकर संग कुकरम करथे, जेकर कि बिहाव के बात नइं लगे रिहिस, त ओकर बर ये जरूरी अय कि ओह दुलहिन के दाम चुकावय अऊ ओकर ले बिहाव करके ओला घरवाली बना ले। ");
INSERT INTO hne_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","पर कहूं ओकर ददा ह ओला देय बर मना करथे, तब भी ओला कुंवारी बर दुलहिन के दाम चुकाना जरूरी अय। ");
INSERT INTO hne_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“जादूगरनी ला जीयत झन रहन दव। ");
INSERT INTO hne_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“कहूं कोनो मनखे ह पसु संग कुकरम करथे, त ओला मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“जऊन कोनो यहोवा के छोंड़ अऊ कोनो आने देवता बर बलि चघाथे, ओला नास कर दिये जावय। ");
INSERT INTO hne_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“कोनो परदेसी के संग अतियाचार झन करव या ओला झन सतावव, काबरकि तुमन घलो मिसर देस म परदेसी रहेव। ");
INSERT INTO hne_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“कोनो बिधवा या अनाथ लइका ले फायदा झन उठावव। ");
INSERT INTO hne_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","कहूं तुमन अइसन करथव अऊ ओमन मोला गोहारथें, त मेंह ओमन के गोहार ला जरूर सुनहूं। ");
INSERT INTO hne_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","मोर कोरोध ह भड़कही अऊ मेंह तुमन ला तलवार ले मार डारहूं; अऊ तुम्हर घरवालीमन बिधवा अऊ तुम्हर लइकामन अनाथ हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“कहूं तुमन अपन बीच रहइया मोर कोनो मनखे ला उधार म पईसा देथव, जऊन ह कि जरूरत म हवय, त येला एक धंधा के रूप म झन लेवव; ओकर ले बियाज झन लेवव। ");
INSERT INTO hne_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","कहूं तुमन अपन परोसी के कपड़ा ला गिरवी के रूप म अपन करा रखथव, त ओला बेर बुड़त तक लहुंटा दव। ");
INSERT INTO hne_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","काबरकि तुम्हर परोसी करा ओढ़े बर सिरिप एके ठन कपड़ा हवय। ओह अऊ का ला ओढ़के सुतही? जब ओह मोला गोहारही, त मेंह ओकर सुनहूं, काबरकि मेंह दयालु अंव। ");
INSERT INTO hne_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“परमेसर के निन्दा झन करव या अपन मनखेमन के हाकिम ला सराप झन देवव। ");
INSERT INTO hne_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“अपन खेत के फसल या रसकुंड म ले भेंट ला रोकके झन रखव। “तुमन अपन बेटामन म के पहिलांत ला मोला देवव। ");
INSERT INTO hne_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","अइसने ही तुमन अपन पसु अऊ भेड़मन के संग घलो करव। सात दिन ले ओ पीलामन अपन दाई के संग रहंय, पर आठवां दिन तुमन ओमन ला मोला दे दव। ");
INSERT INTO hne_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“तुमन ला मोर पबितर मनखे बनना हे। एकरसेति ओ पसु के मांस ला झन खावव, जेला कोनो जंगली जानवर ह मार डारे हवय; ओला कुकुरमन के आघू म फटिक दव। ");
INSERT INTO hne_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“लबारी बात झन फईलाहू। लबारी गवाही देके दोसी मनखे के मदद झन करव। ");
INSERT INTO hne_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“गलत काम करे म भीड़ के साथ झन देवव। जब अदालत म तुमन गवाही देथव, त भीड़ के तरफ होके नियाय ला झन बिगाड़व, ");
INSERT INTO hne_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","अऊ मुकदमा म कोनो गरीब के तरफदारी झन करव। ");
INSERT INTO hne_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“कहूं तुम्हर बईरी के भटकत बईला या गदहा ह तुमन ला मिलय, त ओला ओकर मालिक करा जरूर अमरा दव। ");
INSERT INTO hne_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","कहूं तुमन कोनो गदहा ला बोझा ले दबे देखथव, जेकर मालिक ह तुम्हर ले घिन करथे, त ओला उहां वइसनेच झन छोंड़व, पर ओकर मालिक संग मिलके ओकर जरूर मदद करव। ");
INSERT INTO hne_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“अपन गरीब मनखेमन के मुकदमा म ओमन के नियाय ला झन बिगाड़व। ");
INSERT INTO hne_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","झूठा आरोप ले दूरिहा रहव अऊ निरदोस या ईमानदार मनखे के हतिया झन करव, काबरकि मेंह अपराधी ला निरदोस नइं छोड़ंव। ");
INSERT INTO hne_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“तुमन घूस झन लेवव, काबरकि घूस ह देखइया मनखे ला अंधरा कर देथे अऊ निरदोस मनखे के गोठ ला बिगाड़ देथे। ");
INSERT INTO hne_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“कोनो परदेसी के ऊपर अतियाचार झन करव; तुमन खुद जानत हव कि परदेसी होय के का मतलब होथे, काबरकि तुमन मिसर देस म परदेसी रहेव। ");
INSERT INTO hne_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“छै बछर ले तुमन अपन खेत ला बोवव अऊ फसल ला लुवव, ");
INSERT INTO hne_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","पर सातवां बछर ओला झन जोतव अऊ परिया रहन दव। तब तुम्हर मनखेमन के बीच के गरीबमन ओमा ले खाय बर पावंय, अऊ ओमा के बांचे-खुचे ला जंगली पसुमन खावंय। अपन अंगूर के बारी अऊ जैतून के बगीचामन ला घलो अइसनेच करव। ");
INSERT INTO hne_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“हप्ता के छै दिन तुमन अपन काम करव, पर सातवां दिन काम झन करव, ताकि तुम्हर बईला अऊ गदहामन अराम करंय, अऊ तुम्हर परिवार म जनमे गुलाम अऊ तुम्हर बीच रहइया परदेसीमन तरो-ताजा हो सकंय। ");
INSERT INTO hne_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“जऊन कुछू मेंह तुमन ला कहे हवंव, ओला धियान देके करव। आने देवतामन के नांव मदद बर झन लेवव; ओमन के नांव घलो तुम्हर मुहूं ले झन निकलय। ");
INSERT INTO hne_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“साल म तीन बार तुमन मोर बर तिहार मनावव। ");
INSERT INTO hne_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“अखमीरी रोटी के तिहार मनावव; जइसे कि मेंह हुकूम दे हवंव, सात दिन ले बिगर खमीर ले बने रोटी खावव। येला ठहिराय गे समय अबीब के महिना म करव, काबरकि इही महिना म तुमन मिसर देस ले निकलके आय रहेव। “कोनो भी मनखे जुच्छा हांथ मोर करा झन आवय। ");
INSERT INTO hne_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“जब तुमन खेत म फसल लगाथव, अऊ ओह तियार हो जाथे, त ओकर पहिली-फसल लुवई के तिहार मनावव। “बछर के आखिरी म फसल संकेलई के तिहार मनावव, जब तुमन खेत म ले फसल ला संकेलथव। ");
INSERT INTO hne_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“हर बछर तीन बार तुम्हर जम्मो मरद परमपरधान यहोवा करा आवंय। ");
INSERT INTO hne_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“कोनो बलिदान करे गय पसु के लहू ला कोनो खमीर मिले हुए चीज के संग झन चघावव। “मोर तिहार-बलिदान के चरबी ला बिहान होवत तक झन रखव। ");
INSERT INTO hne_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“अपन भुइयां के सबले बने पहिली-फसल ला यहोवा अपन परमेसर के घर म लानव। “कोनो छेरी-पीला ला ओकर मियारी के दूध म झन रांधहू। ");
INSERT INTO hne_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“देखव, मेंह एक स्वरगदूत ला तुम्हर आघू-आघू भेजत हंव, ताकि रसता म ओह तुम्हर पहरेदारी करय अऊ तुमन ला ओ जगह म लानय, जेला मेंह तियार करे हंव। ");
INSERT INTO hne_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ओकर ऊपर धियान दव अऊ ओकर बात ला मानव। ओकर बिरूध बिदरोह झन करव; ओह तुम्हर बिदरोह ला छेमा नइं करही, काबरकि ओमा मोर नांव हवय। ");
INSERT INTO hne_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","कहूं धियान लगाके तुमन ओकर बात ला सुनहू अऊ मोर कहे गय जम्मो चीज ला करहू, त मेंह तुम्हर बईरीमन के बईरी अऊ तुम्हर बिरोधीमन के बिरोधी बनहूं। ");
INSERT INTO hne_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","मोर स्वरगदूत ह तुम्हर आघू-आघू जाही अऊ तुमन ला अमोरी, हित्ती, परिज्जी, कनानी, हिब्बी अऊ यबूसीमन के देस म ले जाही, अऊ मेंह ओमन ला नास कर दूहूं। ");
INSERT INTO hne_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ओमन के देवतामन के दंडवत झन करहू या ओमन के अराधना झन करहू या ओमन के रीति-रिवाज म झन चलहू। तुमन ओमन के देवता ला गिरा दव अऊ ओमन के पबितर पथरामन ला फोरके कुटा-कुटा कर दव। ");
INSERT INTO hne_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","यहोवा अपन परमेसर के अराधना करव, अऊ ओह तुम्हर जेवन-पानी ला आसीस दीही। मेंह तुम्हर बीच म ले रोग-बेमारी ला दूरिहा कर दूहूं ");
INSERT INTO hne_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","अऊ तुम्हर देस म कोनो माईलोगन के गरभ ह नइं गिरही या कोनो बांझ नइं होही। मेंह तुमन ला पूरा जिनगी जीये बर दूहूं। ");
INSERT INTO hne_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“मेंह अपन आतंक ला तुम्हर आघू-आघू पठोहूं, अऊ जऊन जाति के भी तुमन सामना करहू, ओमन म घबराहट फईला दूहूं। मेंह अइसे कर दूहूं कि तुम्हर जम्मो बईरीमन पीठ देखाके भागहीं। ");
INSERT INTO hne_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","मेंह तुम्हर आघू-आघू बर्रामन ला पठोहूं, जेमन हिब्बी, कनानी अऊ हित्तीमन ला तुम्हर आघू ले भगा दीहीं। ");
INSERT INTO hne_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","पर मेंह ओमन ला एकेच बछर म नइं भगावंव, काबरकि ओ देस ह उजर जाही, अऊ जंगली पसु बहुंत होय के कारन तुमन परेसानी म पड़ जाहू। ");
INSERT INTO hne_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","धीरे-धीरे करके मेंह ओमन ला तुम्हर आघू ले भगाहूं, जब तक कि तुमन गनती म बढ़के ओ देस ऊपर अधिकार नइं कर लूहू। ");
INSERT INTO hne_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“मेंह लाल-समुंदर ले लेके भूमध्य सागर अऊ निरजन जगह ले लेके फरात नदी तक तुम्हर सीमना बनाहूं। ओ देस म रहइया मनखेमन ला मेंह तुम्हर हांथ म कर दूहूं, अऊ तुमन ओमन ला अपन आघू ले भगा दूहू। ");
INSERT INTO hne_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तुमन ओमन के संग या ओमन के देवतामन के संग कोनो करार झन करहू। ");
INSERT INTO hne_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","तुमन ओमन ला अपन देस म रहे बर झन दूहू, नइं तो ओमन तुमन ला मोर बिरूध पाप करवाहीं, काबरकि ओमन के देवतामन के अराधना करई ह जरूर तुम्हर बर एक फांदा बन जाही।” ");
INSERT INTO hne_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","तब यहोवा ह मूसा ला कहिस, “तें अऊ हारून, नादाब अऊ अबीहू, अऊ इसरायल के सत्तर अगुवामन यहोवा करा ऊपर आवव, अऊ दूरिहा ले अराधना करव, ");
INSERT INTO hne_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","पर सिरिप मूसा ह यहोवा करा आवय; आने मन लकठा म झन आवंय। अऊ मनखेमन ओकर संग ऊपर झन आवंय।” ");
INSERT INTO hne_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","जब मूसा ह मनखेमन करा जाके यहोवा के जम्मो बात अऊ नियम-कानून ला बताईस, तब ओमन एक संग कहिन, “हमन यहोवा के कहे गय हर काम ला करबो।” ");
INSERT INTO hne_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","मूसा ह तब यहोवा के कहे गय जम्मो बात ला लिख लीस। ओह दूसर दिन बड़े बिहनियां उठिस अऊ पहाड़ के खाल्हे एक ठन बेदी बनाईस अऊ इसरायल के बारह गोत्र के मुताबिक बारह ठन पथरा के खंभा घलो बनाईस। ");
INSERT INTO hne_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","तब ओह जवान इसरायली मनखेमन ला पठोईस, अऊ ओमन यहोवा बर होम-बलिदान चघाईन अऊ बछवामन ला मेल-बलिदान के रूप म चघाईन। ");
INSERT INTO hne_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मूसा ह आधा लहू ला कटोरामन म रखिस, अऊ आधा ला बेदी म छिंच दीस। ");
INSERT INTO hne_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","तब ओह करार के किताब अपन हांथ म लीस अऊ मनखेमन ला पढ़के सुनाईस। ओमन कहिन, “हमन यहोवा के कहे गय हर काम ला करबो; हमन ओकर कहना मानबो।” ");
INSERT INTO hne_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तब मूसा ह लहू ला लीस अऊ ओला मनखेमन ऊपर छिंचके कहिस, “येह ओ करार के लहू ए, जेला यहोवा ह ये जम्मो बातमन के मुताबिक तुम्हर संग करे हवय।” ");
INSERT INTO hne_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","तब मूसा अऊ हारून, नादाब अऊ अबीहू, अऊ इसरायल के सत्तर अगुवामन पहाड़ ऊपर गीन ");
INSERT INTO hne_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","अऊ इसरायल के परमेसर के दरसन करिन। ओकर गोड़ खाल्हे नीलमनि ले बने चौंरा के सहीं एक चीज रिहिस, जऊन ह अकास के सहीं एकदम नीला रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","पर परमेसर ह इसरायल के ये अगुवामन के बिरूध अपन हांथ नइं उठाईस; ओमन परमेसर के दरसन करिन अऊ खाईन-पीईन। ");
INSERT INTO hne_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","यहोवा ह मूसा ला कहिस, “पहाड़ ऊपर मोर करा आ अऊ इहां रूक, अऊ मेंह तोला ओ पथरा के पटियामन ला दूहूं, जेमा मेंह कानून अऊ हुकूममन ला लिख दे हंव ताकि तेंह येला ओमन ला सिखा।” ");
INSERT INTO hne_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","तब मूसा ह अपन सहायक यहोसू के संग चल दीस, अऊ मूसा ह परमेसर के पहाड़ ऊपर गीस। ");
INSERT INTO hne_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","जाय के पहिले ओह अगुवामन ला कहिस, “जब तक हमन तुम्हर करा लहुंटके नइं आवन, तब तक तुमन इहां रूके रहव। हारून अऊ हूर तुम्हर संग इहां हवंय, अऊ कहूं काकरो झगरा होथे, त ओह ओमन करा जा सकत हे।” ");
INSERT INTO hne_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","तब मूसा ह पहाड़ ऊपर गीस, त बादर ह पहाड़ ला ढांप लीस, ");
INSERT INTO hne_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","अऊ यहोवा के महिमा ह सीनय पहाड़ म छा गीस। छै दिन ले बादर ह पहाड़ ला ढांपे रिहिस, अऊ सातवां दिन यहोवा ह मूसा ला बादर म ले बलाईस। ");
INSERT INTO hne_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इसरायलीमन ला यहोवा के महिमा ह पहाड़ के ऊपर म एक भसम करइया आगी सहीं दिखिस। ");
INSERT INTO hne_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","जब मूसा ह पहाड़ ऊपर गीस, त ओह बादर भीतर हमा गीस। अऊ ओह चालीस दिन अऊ चालीस रात उहां रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इसरायलीमन ले कह कि ओमन मोर बर भेंट लानंय। तेंह मोर बर हर ओ मनखे ले भेंट लेबे, जऊन ह अपन ईछा ले देथे। ");
INSERT INTO hne_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“येमन ओ भेंट अंय, जेला तेंह ओमन ले लेबे: “सोन, चांदी अऊ कांसा; ");
INSERT INTO hne_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","नीला, बैंगनी, अऊ सिन्दूरी रंग के सूंत अऊ सुघर मलमल के कपड़ा; बोकरा के रूआं; ");
INSERT INTO hne_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","लाल रंग ले रंगाय मेढ़ा के खाल अऊ आने किसम के टिकाऊ खाल; बंबरी के लकड़ी; ");
INSERT INTO hne_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","अंजोर करे बर जैतून के तेल; अभिसेक के तेल अऊ कहरवाला धूप बर मसाला; ");
INSERT INTO hne_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","अऊ एपोद अऊ छातीबंध म जड़े बर गोमेदक के पथरा अऊ आने किसम के रत्न। ");
INSERT INTO hne_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“तब ओ सामान ले मोर बर एक ठन पबितर-स्थान बनवाबे, अऊ मेंह ओमन के बीच म निवास करहूं। ");
INSERT INTO hne_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ये पबितर-तम्बू अऊ येकर जम्मो चीजमन ला एकदम वइसे ही बनाबे, जइसे मेंह तोला बताहूं। ");
INSERT INTO hne_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“ओमन ले बंबरी लकड़ी के एक ठन सन्दूक बनवाबे—जऊन ह अढ़ई क्यूबीट लम्बा, डेड़ क्यूबीट चौड़ा, अऊ डेड़ क्यूबीट ऊंचा रहय। ");
INSERT INTO hne_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","अऊ ओ सन्दूक के भीतर-बाहिर दूनों कोति चोखा सोन लगवाबे, अऊ ओकर चारों कोति सोन के एक पट्टी लगवाबे। ");
INSERT INTO hne_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","सोन के चार ठन कड़ा बनवाके ओमन ला ओकर चारों खुरा म बांध देबे, एक तरफ दू ठन अऊ दूसर तरफ दू ठन। ");
INSERT INTO hne_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","तब डंडामन ला बंबरी लकड़ी के बनवाबे, अऊ ओमन ला घलो सोन ले मढ़बे। ");
INSERT INTO hne_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ओ डंडामन ला सन्दूक के दूनों कोति कड़ामन म लगाबे, ताकि सन्दूक ला उठाके ले जा सकंय। ");
INSERT INTO hne_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ओ बल्लीमन सन्दूक के कड़ामन म लगे रहंय; ओमन ला कड़ा ले झन निकाले जावय। ");
INSERT INTO hne_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","तब करार कानून के ओ पटियामन ला सन्दूक म रख देबे, जेमन ला मेंह तोला दूहूं। ");
INSERT INTO hne_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“चोखा सोन ले पछताप के एक ढकना बनवाबे—जऊन ह अढ़ई क्यूबीट लम्बा अऊ डेड़ क्यूबीट चौड़ा होवय। ");
INSERT INTO hne_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","अऊ ढकना के दूनों छोर बर हथौड़ा ले पीटके सोन के दू ठन करूब बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एक ठन करूब ला एक छोर म अऊ दूसर करूब ला दूसर छोर म बनवाबे; दूनों छोर म करूबमन अऊ ढकना ला सोन के एके कुटा ले बनाय जावय। ");
INSERT INTO hne_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ओ करूबमन के डेनामन ऊपर कोति अइसन फईले रहंय कि पछताप के ढकना ह ओमन ले ढंकाय रहय। करूबमन के मुहूं ह एक-दूसर के आमने-सामने रहय अऊ ओमन ढकना कोति देखत रहंय। ");
INSERT INTO hne_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ढकना ला सन्दूक के ऊपर लगाबे अऊ करार कानून के ओ पटियामन ला सन्दूक म रख देबे, जेमन ला मेंह तोला दूहूं। ");
INSERT INTO hne_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ढकना के ऊपर, ओ दूनों करूबमन के बीच, जेमन करार कानून के सन्दूक ऊपर होथें, उहां मेंह तोर ले मिलहूं अऊ तोला मोर जम्मो हुकूम इसरायलीमन बर दूहूं। ");
INSERT INTO hne_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“बंबरी लकड़ी के एक ठन मेज बनाबे—जऊन ह दू क्यूबीट लम्बा, एक क्यूबीट चौड़ा अऊ डेड़ क्यूबीट ऊंचा होवय। ");
INSERT INTO hne_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","मेज के ऊपर चोखा सोन लगाबे अऊ ओकर चारों मुड़ा सोन के एक पट्टी लगाबे। ");
INSERT INTO hne_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ओकर चारों कोति हथेली भर चौड़ा सोन के एक ठन चक्र लगाबे अऊ ओ चक्र म सोन के एक ठन पट्टी लगाबे। ");
INSERT INTO hne_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","मेज बर सोन के चार ठन कड़ा बनाबे अऊ ओमन ला ओ चारों कोना म बांध देबे, जिहां चारों खुरामन हवंय। ");
INSERT INTO hne_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ये कड़ामन पट्टी के लकठा म रहंय, ताकि ओमा ओ डंडामन ला फंसाय जा सकय, जेमन के उपयोग मेज ला उठाके ले जाय बर होथे। ");
INSERT INTO hne_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ओ डंडामन ला बंबरी लकड़ी के ही बनाबे, अऊ ओमन ला सोन ले मढ़बे अऊ ओकर दुवारा मेज ला उठाके ले जावव। ");
INSERT INTO hne_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","अऊ ओकर थाली अऊ बरतनमन ला चोखा सोन के बनाबे, संग म बलिदान ला रितोय बर ओकर घघरी अऊ कटोरामन ला घलो चोखा सोन के बनाबे। ");
INSERT INTO hne_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","मोर आघू म ये मेज ऊपर चघावा के रोटी हमेसा रखे जावय। ");
INSERT INTO hne_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“चोखा सोन के एक ठन दीवट बनाबे। ओकर आधार अऊ मुठिया ला हथौड़ा ले पीटके बनाबे, अऊ ओकर फूल असन कटोरा, कली अऊ पंखुड़ीमन ला एके ठन कुटा म बनाय जावय। ");
INSERT INTO hne_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","दीवट के किनारे ले छै ठन डारामन निकले रहंय—तीन ठन डारा एक कोति अऊ तीन ठन डारा दूसर कोति। ");
INSERT INTO hne_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","हर एक डारा म बादाम के फूल सहीं तीन ठन कटोरी, कली अऊ पंखुड़ीमन रहंय, तीन ओकर बाद वाले डारा म, अऊ अइसनेच दीवट ले निकले जम्मो छै ठन डारा म होवय। ");
INSERT INTO hne_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","दीवट म बादाम के फूल सहीं चार ठन कटोरी अऊ ओमा कली अऊ पंखुड़ीमन ला बनाय जावय। ");
INSERT INTO hne_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","दीवट ले निकले छै ठन डारा म ले एक-एक जोड़ी डारा के तरी म एक-एक ठन कली रहय—ये किसम ले कुल तीन ठन कली छै ठन डारा के तरी म रहंय। ");
INSERT INTO hne_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","कली अऊ डारामन ला दीवट के संग एके कुटा म बनाय जावय अऊ चोखा सोन ला पीटके येमन ला बनाय जावय। ");
INSERT INTO hne_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“तब ओकर बर सात ठन दीया बनवाबे अऊ ओमन ला दीवट ऊपर मढ़ाबे, ताकि ओमन दीवट के आघू कोति अंजोर करंय। ");
INSERT INTO hne_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ओकर बाती ला ठीक करे के चिमटा अऊ थालीमन घलो चोखा सोन के होवंय। ");
INSERT INTO hne_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","दीवट अऊ ये जम्मो चीजमन ला बनाय बर एक टेलेन्ट चोखा सोन के उपयोग करे जावय। ");
INSERT INTO hne_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","धियान रहय कि जऊन नमूना तोला ये पहाड़ ऊपर देखाय गीस, ओकरे मुताबिक ही तेंह येमन ला बनाबे। ");
INSERT INTO hne_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“पबितर-तम्बू ला दस ठन परदा ले बनाय जावय; ये परदामन सुघर बंटे मलमल अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत ले बनाय जावंय, अऊ कुसल कारीगरमन के दुवारा ये परदामन म कढ़ई करके करूबमन ला बनाय जावय। ");
INSERT INTO hne_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","जम्मो परदामन एकेच आकार के होवंय—अठाईस क्यूबीट लम्बा अऊ चार क्यूबीट चौड़ा। ");
INSERT INTO hne_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पांच ठन परदा ला एक संग जोड़ दिये जावय, अऊ बांचे पांच ठन परदा ला घलो अइसने ही करे जावय। ");
INSERT INTO hne_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","एक समूह के आखिरी के परदा के धरी म नीला रंग के चीज के फांस लगावव, अऊ वइसने ही दूसरा समूह के आखिरी के परदा म घलो करव। ");
INSERT INTO hne_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","एक समूह के आखिरी के परदा म पचास ठन फांस अऊ दूसर समूह के आखिरी के परदा म पचास ठन फांस लगावव, अऊ ये फांसमन एक-दूसर के आमने-सामने रहंय। ");
INSERT INTO hne_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","तब पचास ठन सोन के कड़ा बनवाव अऊ ओमन के उपयोग परदामन ला एक संग बांधके रखे बर करव, ताकि पबितर-तम्बू ह एक हो जावय। ");
INSERT INTO hne_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“पबितर-तम्बू के ऊपर बोकरा के रूआं के परदा बनवाव—कुल गियारह ठन परदा बनवाव। ");
INSERT INTO hne_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","जम्मो गियारह परदामन एके नाप के होवंय—तीस क्यूबीट लम्बा अऊ चार क्यूबीट चौड़ा। ");
INSERT INTO hne_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ओमा के पांच ठन परदा ला जोड़के एक ठन परदा बना लेबे अऊ आने छै ठन ला घलो जोड़के एक ठन अऊ परदा बना लेबे। छठवां परदा ला तम्बू के आघू म मोड़ के दू पुरूत कर देबे। ");
INSERT INTO hne_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","एक समूह के आखिरी परदा के धरी म पचास ठन फांस बनाबे अऊ वइसने ही पचास ठन फांस दूसर समूह के आखिरी परदा के धरी म घलो बनाबे। ");
INSERT INTO hne_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","तब पचास ठन कांसा के कड़ा बनवाबे अऊ तम्बू ला बांधे बर कड़ामन म गांठ लगाबे ताकि ओ पूरा तम्बू मिलके एके ठन हो जावय। ");
INSERT INTO hne_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","जिहां तक तम्बू के परदामन के अतकिहा लम्बई के बात हे, याने कि ओ आधा परदा जऊन ह बांच जाथे, ओह पबितर-तम्बू के पाछू कोति ओरमे रहय। ");
INSERT INTO hne_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","तम्बू के परदामन के लम्बई दूनों कोति एक क्यूबीट होही; जऊन ह बच जाथे, ओह पबितर-तम्बू के किनारे म ओरमत रहिही अऊ ये किसम ले ओह ढंपे रहिही। ");
INSERT INTO hne_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","तम्बू ला ढांपे बर लाल रंग ले रंगाय मेढ़ा के खाल के एक ठन ओढ़ना बनाबे, अऊ ओकर ऊपर लगाय बर आने टिकाऊ खाल के एक ठन ओढ़ना बनाबे। ");
INSERT INTO hne_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“पबितर-तम्बू बर बंबरी लकड़ी के खड़े ढांचामन ला बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","हर एक ढांचा दस क्यूबीट लम्बा अऊ डेड़ क्यूबीट चौड़ा होवय, ");
INSERT INTO hne_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","एक-दूसर के समानांतर दू-दू ठन खूंटी रहय। पबितर-तम्बू के जम्मो ढांचामन ला इही किसम ले बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","पबितर-तम्बू के दक्खिन कोति बर बीस ठन ढांचा बनवाबे ");
INSERT INTO hne_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","अऊ ये ढांचामन के खाल्हे म रखे बर चांदी के चालीस ठन आधार बनवाबे—हर एक ढांचा बर दू ठन आधार, हर एक खूंटी के खाल्हे म एक ठन आधार। ");
INSERT INTO hne_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","पबितर-तम्बू के दूसर कोति, याने कि उत्तर दिग बर, बीस ठन ढांचा ");
INSERT INTO hne_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","अऊ चालीस ठन चांदी के आधार बनवाबे—हर एक ढांचा के खाल्हे म दू ठन आधार रहय। ");
INSERT INTO hne_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","आखिरी छोर याने कि पबितर-तम्बू के पछिम छोर बर छै ठन ढांचा बनवाबे, ");
INSERT INTO hne_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","अऊ आखिरी छोर म, कोनटामन बर, दू ठन ढांचा बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ये दूनों कोनटा म ढांचामन खाल्हे ले लेके टीप तक दू परत के रहंय अऊ एके ठन कड़ा म जुड़े रहंय; दूनों वइसने रहंय। ");
INSERT INTO hne_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ये किसम ले आठ ठन ढांचा होहीं अऊ सोलह ठन चांदी के आधार—याने कि हर ढांचा के खाल्हे म दू ठन आधार। ");
INSERT INTO hne_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“बंबरी लकड़ी के मियारमन ला घलो बनवाबे: पबितर-तम्बू के एक तरफ के ढांचामन बर पांच ठन, ");
INSERT INTO hne_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","दूसर तरफ के ढांचामन बर पांच ठन, अऊ पबितर-तम्बू के आखिरी छोर म, पछिम तरफ के ढांचामन बर पांच ठन मियार बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","मांझा के मियार ह ढांचामन के बीच म तम्बू के एक छोर ले दूसर छोर तक रहय। ");
INSERT INTO hne_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ढांचामन ला सोन ले मढ़वाबे अऊ मियारमन ला पकड़े बर सोन के कड़ा बनवाबे। अऊ मियारमन ला घलो सोन ले मढ़वा देबे। ");
INSERT INTO hne_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“पबितर-तम्बू ला ओ योजना के मुताबिक बनाबे, जेला पहाड़ ऊपर तोला देखाय गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“फेर नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत अऊ सुघर बंटे मलमल ले एक ठन परदा बनवाबे, जऊन म एक कुसल कारीगर दुवारा करूबमन के कढ़ई करे गे होवय। ");
INSERT INTO hne_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","सोन ले मढ़े बंबरी लकड़ी के चार ठन खंभा म सोन के खीलामन ला ठोंक अऊ ये परदा ला ओमा टांग दे; बंबरी के खंभामन चांदी के चार ठन आधार म खड़े रहंय। ");
INSERT INTO hne_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","परदा ह खूंटीमन ले खाल्हे तक ओरमे रहय अऊ करार कानून के सन्दूक ला उहां परदा के ओधा म रखबे। ये परदा ह पबितर स्थान ला महा पबितर स्थान ले अलग करही। ");
INSERT INTO hne_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","पछताप के ढकना ला महा पबितर स्थान म करार कानून के सन्दूक ऊपर ढांप देबे। ");
INSERT INTO hne_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","परदा के बाहिर पबितर-तम्बू के उत्तर कोति मेज ला रखबे अऊ दक्खिन कोति मेज के आघू म दीवट ला रखबे। ");
INSERT INTO hne_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“तम्बू के प्रवेस दुवार बर नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत अऊ सुघर बंटे मलमल के ओनहा ले एक ठन परदा बनवाबे—येह एक कढ़ई करइया के काम होवय। ");
INSERT INTO hne_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ये परदा बर सोन के खूंटी अऊ सोन ले मढ़े बंबरी लकड़ी के पांच ठन खंभा बनवाबे। अऊ ओमन बर कांसा के पांच ठन आधार बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“बंबरी लकड़ी के एक बेदी बनवाबे, जेकर ऊंचई तीन क्यूबीट रहय; ओला वर्गाकार बनवाबे, पांच क्यूबीट लम्बा अऊ पांच क्यूबीट चौड़ा। ");
INSERT INTO hne_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ओकर चारों कोनटा म एक-एक ठन सींग बनवाबे; सींग अऊ बेदी एके कुटा म बनंय, अऊ बेदी ला कांसा ले मढ़वाबे। ");
INSERT INTO hne_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","बेदी के जम्मो बरतन याने कि ओकर राख उठाय के बरतन, अऊ ओकर बेलचा, छिंचे के कटोरा, मांस बर कांटा अऊ करछूल ला कांसा के बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ओकर बर कांसा के एक ठन जालीवाला छननी बनवाबे, अऊ छननी के चारों कोनटा म कांसा के चार ठन कड़ा लगवाबे। ");
INSERT INTO hne_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ओ छननी ला बेदी के निकले भाग के तरी म अइसन लगाबे कि ओह बेदी के आधा ऊंचई तक आवय। ");
INSERT INTO hne_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","बेदी बर बंबरी लकड़ी के डंडा बनवाबे, अऊ ओ डंडामन म कांसा मढ़वाबे। ");
INSERT INTO hne_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","डंडामन ला कड़ामन म अइसे लगाय जावय कि ओमन बेदी के दूनों कोति निकले रहंय, ताकि जब भी बेदी ला ले जावंय, त ये डंडा के निकले भाग ला पकड़के उठावंय। ");
INSERT INTO hne_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","बेदी के तखतामन ला अइसने बनवाबे कि ओमन भीतर ले खोखला रहंय। येमन ला वइसने ही बनवाबे, जइसने कि तोला पहाड़ ऊपर देखाय गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“फेर पबितर-तम्बू बर एक ठन अंगना बनवाबे। दक्खिन कोति अंगना ह एक सौ क्यूबीट लम्बा रहय अऊ ओमा सुघर बंटाय मलमल के परदा रहय, ");
INSERT INTO hne_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ओ परदा बर बीस ठन खंभा अऊ बीस ठन कांसा के आधारमन रहंय अऊ खंभामन म चांदी के कांटा अऊ पट्टीमन रहंय। ");
INSERT INTO hne_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","अइसने ही अंगना के उत्तर भाग ह एक सौ क्यूबीट लम्बा रहय अऊ ओमा परदा लगे रहय, अऊ ओकर बीस ठन खंभा अऊ कांसा के बीस ठन आधार होवय, खंभामन के कांटा अऊ पट्टीमन चांदी के होवंय। ");
INSERT INTO hne_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“अंगना के पछिमी छोर ह पचास क्यूबीट चौड़ा रहय अऊ ओमा परदा लगे रहय, अऊ ओकर दस ठन खंभा अऊ दस ठन आधार रहंय। ");
INSERT INTO hne_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","पूरबी छोर म, सूरज निकले कोति घलो अंगना के चौड़ई पचास क्यूबीट रहय। ");
INSERT INTO hne_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","प्रवेस दुवार के एक तरफ परदा के लम्बई पंदरह क्यूबीट रहय, अऊ ओकर बर तीन ठन खंभा अऊ तीन ठन आधार रहंय, ");
INSERT INTO hne_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","अऊ प्रवेस दुवार के दूसर तरफ घलो पंदरह क्यूबीट लम्बा परदा लगे रहय, ओकर तीन ठन खंभा अऊ तीन ठन आधार रहंय। ");
INSERT INTO hne_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“अंगना के प्रवेस दुवार बर बीस क्यूबीट लम्बई के परदा देबे, जऊन ला एक कढ़ई करनेवाला के दुवारा नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत अऊ सुघर बंटे मलमल के कपड़ा ले बनाय गे रहय—अऊ ओकर चार ठन खंभा अऊ चार ठन आधार रहंय। ");
INSERT INTO hne_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","अंगना के चारों मुड़ा के जम्मो खंभा म चांदी के पट्टी लगे रहंय अऊ ओकर कांटामन चांदी के, अऊ आधारमन कांसा के रहंय। ");
INSERT INTO hne_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","अंगना के लम्बई एक सौ क्यूबीट अऊ चौड़ई पचास क्यूबीट रहय, ओकर परदा के ऊंचई पांच क्यूबीट रहय, अऊ ओह सुघर बंटे मलमल कपड़ा के बने रहय, अऊ ओमा कांसा के आधारमन रहंय। ");
INSERT INTO hne_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","पबितर-तम्बू म बउरे के आने जम्मो बरतन, चाहे ओमन के कुछू भी उपयोग होवय, इहां तक कि तम्बू के जम्मो खूंटी अऊ अंगना के जम्मो खूंटीमन—ये सब कांसा के बने रहंय। ");
INSERT INTO hne_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“इसरायलीमन ला हुकूम दे कि ओमन अंजोर करे बर जैतून के पेरके निकाले सुध तेल लानंय, ताकि दीयामन हरदम बरत रहंय। ");
INSERT INTO hne_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","मिलापवाला तम्बू म, ओ परदा के बाहिर, जऊन ह करार कानून के सन्दूक ला ओधा करथे, हारून अऊ ओकर बेटामन दीयामन ला यहोवा के आघू म संझा ले बिहान होवत तक बरत रखंय। येह इसरायलीमन के बीच म पीढ़ी-पीढ़ी तक हमेसा के बिधि होवय। ");
INSERT INTO hne_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“तें इसरायलीमन के बीच ले अपन भाई हारून अऊ ओकर बेटा नादाब अऊ अबीहू, एलिआजर अऊ ईतामार ला अपन करा ले आ, ताकि ओमन पुरोहित के रूप म मोर सेवा करंय। ");
INSERT INTO hne_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","अपन भाई हारून के मान अऊ आदर के खातिर ओकर बर पबितर पहिरावा बनवा। ");
INSERT INTO hne_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ओ जम्मो कुसल कारीगरमन ला कह, जऊन मन ला मेंह ये काम करे बर बुद्धि दे हंव कि ओमन हारून बर पहिरावा बनावंय, ताकि ओकर संस्कार करे जावय अऊ ओह पुरोहित के रूप म मोर सेवा करय। ");
INSERT INTO hne_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","येमन ओ पहिरावा अंय, जऊन ला ओमन बनावंय: एक सीनाबंध, एक एपोद, एक चोगा, एक ठन बुने हुए कुरता, एक पागा अऊ एक गमछा। ओमन तोर भाई हारून अऊ ओकर बेटामन बर ये पबितर पहिरावा बनावंय, ताकि ओमन पुरोहित के रूप म मोर सेवा करंय। ");
INSERT INTO hne_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","कारीगरमन सोन, अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत, अऊ सुघर मलमल कपड़ा के उपयोग करंय। ");
INSERT INTO hne_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“एपोद ला सोन, अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत, अऊ सुघर बंटाय मलमल के कपड़ा के बनवाबे अऊ येह कुसल कारीगर के दुवारा बनाय जावय। ");
INSERT INTO hne_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","येकर दू ठन कंधा के टुकड़ामन येकर कोना म जुड़े रहंय, ताकि येला बांधे जा सकय। ");
INSERT INTO hne_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","कुसलता से बुने गय कमरबंध ह अइसने होवय—येह एपोद के संग एके टुकड़ा म बने रहय अऊ येह सोन, अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत, अऊ सुघर बंटाय मलमल के बने रहय। ");
INSERT INTO hne_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“दू ठन गोमेदक के रत्नमन ला लेके ओमा इसरायल के बेटामन के नांव ला खुदवा देबे, ");
INSERT INTO hne_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","अऊ ये नांवमन ला ओमन के जनम के मुताबिक खुदवाबे—छै झन के नांव एक ठन पथरा म अऊ बांचे छै झन के नांव दूसर पथरा म। ");
INSERT INTO hne_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","दूनों पथरा म इसरायल के बेटामन के नांवमन अइसने खुदवाबे, जइसने कोनो सुनार ह नक्कासी करके मुहर ला बनाथे। तब पथरामन ला सोन के जरी के काम सहीं मढ़ देबे ");
INSERT INTO hne_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","अऊ ओ दूनों पथरा ला इसरायल के बेटामन बर यादगार पथरा के रूप म एपोद के कंधावाले टुकड़ा म बांध देबे। हारून ह यहोवा के आघू म ओ नांवमन ला एक स्मारक के रूप म अपन दूनों कंधा म लगाय रहय। ");
INSERT INTO hne_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","सोन के जरीवाला काम के खाना बनवाबे ");
INSERT INTO hne_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","अऊ डोरी के सहीं चोखा सोन के दू ठन गुंथे हुए जंजीर बनवाबे, अऊ ये जंजीरमन ला ओ खानामन म लगवाबे। ");
INSERT INTO hne_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“फैसला करे बर छातीबंध बनवाबे—ओला कुसल कारीगर के हांथ ले बनाय जावय। ओला एपोद के सहीं सोन, अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत, अऊ सुघर बंटे मलमल के बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","छातीबंध ह चौकोर रहय—याने कि ओह एक स्पान लम्बा अऊ एक स्पान चौड़ा—अऊ दू बार मुड़े रहय। ");
INSERT INTO hne_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","तब येमा चार ठन कतार म कीमती पथरा लगवाबे। पहिली कतार म मानिक, पुखराज अऊ पन्ना रहय; ");
INSERT INTO hne_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दूसर कतार म मरकत, नीलमनि हीरा अऊ पन्ना रहय; ");
INSERT INTO hne_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तीसर कतार म नारंगी रंग के लसम, सूर्यकांत अऊ नीलम रहय; ");
INSERT INTO hne_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","चौथा कतार म फिरोजा, गोमेदक अऊ यसब होवय। येमन ला जरी के काम करे गे सोन म जड़े जावय। ");
INSERT INTO hne_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ये पथरामन बारह ठन होवंय, याने कि इसरायल के बेटामन के हर एक नांव बर एक-एक ठन पथरा होवय, अऊ हर एक म बारह गोत्र के एक-एक नांव ला मुहर सहीं खोदे जावय। ");
INSERT INTO hne_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“छातीबंध म डोरी के सहीं चोखा सोन के गुंथे गय जंजीर बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","येकर बर सोन के दू ठन छल्ला बनवाबे अऊ दूनों छल्लामन ला छातीबंध के दू ठन कोनटा म बांध देबे। ");
INSERT INTO hne_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","तब सोन के दूनों जंजीर ला छातीबंध के कोनटामन म ओ छल्लामन के संग बांध देबे, ");
INSERT INTO hne_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","अऊ जंजीरमन के दूसर छोरमन ला दूनों खानामन म बांधबे, अऊ येमन सामने म एपोद के कंधावाले टुकड़ा म जुड़े रहंय। ");
INSERT INTO hne_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","सोन के दू ठन अऊ छल्ला बनाके ओमन ला छातीबंध के आने दूनों कोनटा के भीतरी किनारा म एपोद ले संटके लगवाबे। ");
INSERT INTO hne_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","सोन के अऊ दू ठन छल्ला बनाबे, अऊ ओमन ला एपोद के सामने म कंधा के टुकड़ामन के खाल्हे म जोड़ देबे अऊ ये जोड़ ह एपोद के कमरबंध के ऊपर के जोड़ के लकठा म होवय। ");
INSERT INTO hne_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","छातीबंध के छल्लामन ला एपोद के छल्लामन ले बांधे जावय अऊ येला कमरबंध ले जोड़त नीला डोरी ले बांधे जावय, ताकि छातीबंध ह एपोद के बाहिर झन ओरमय। ");
INSERT INTO hne_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“जब भी हारून ह पबितर स्थान म जावय, त ओह फैसला करे के छातीबंध म अपन हिरदय के ऊपर इसरायल के बेटामन के नांवमन ला लगाय रहय, जेकर ले यहोवा के आघू म ओकर सुरता ह हमेसा बने रहय। ");
INSERT INTO hne_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","छातीबंध म ऊरीम अऊ तुम्मीम ला घलो रख, ताकि जब भी हारून ह यहोवा के आघू म जावय, त ओमन हारून के हिरदय ऊपर रहंय। ये किसम ले हारून ह इसरायलीमन बर फैसला करे के चीज ला अपन हिरदय ऊपर यहोवा के आघू म हमेसा धरे रहिही। ");
INSERT INTO hne_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“एपोद के खाल्हे के लबादा ला पूरा नीला रंग के कपड़ा ले बनवाबे; ");
INSERT INTO hne_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ओकर मांझा म मुड़ी खुसेरे बर एक जगह होवय। ओ जगह के चारों कोति पट्टी के सहीं बुने गय किनारा होवय, ताकि ओह झन चिरावय। ");
INSERT INTO hne_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","कपड़ा के खाल्हे के घेरा के चारों कोति नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत ले अनार बनवाबे, अऊ अनारमन के बीच-बीच म सोन के घंटी लगवाबे। ");
INSERT INTO hne_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","लबादा के खाल्हे के घेरा म अनार अऊ सोन के घंटीमन एक के बाद एक रहंय। ");
INSERT INTO hne_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","हारून ह सेवा-टहल करत बेरा येला जरूर पहिरे। जब ओह पबितर स्थान म यहोवा के आघू म जाही अऊ उहां ले निकलही, त घंटीमन के अवाज सुनई दीही, अऊ ओह नइं मरही। ");
INSERT INTO hne_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“चोखा सोन के एक ठन तस्तरी बनवाबे अऊ ओमा मुहर के सहीं ये सबदमन ला खुदवाबे: यहोवा बर पबितर। ");
INSERT INTO hne_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ओला पागा म जोड़े बर ओमा एक ठन नीला डोरी बांधबे; ओह पागा के आघू म रहय। ");
INSERT INTO hne_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","येह हारून के माथा म रहय, अऊ ओह इसरायलीमन के दुवारा चघाय गे पबितर भेंट के दोस ला अपन ऊपर उठाही, चाहे ओह कोनो भी किसम के भेंट होवय। ओह हमेसा हारून के माथा म रहय ताकि ओह यहोवा ला गरहनयोग्य होवय। ");
INSERT INTO hne_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“कुरता अऊ पागा ला सुघर मलमल के कपड़ा ले बनवाबे। कमरपट्टा ला कढ़ई करनेवाला ह बनावय। ");
INSERT INTO hne_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","हारून के बेटामन ला आदर देय बर कुरता, पटका अऊ टोपी बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","अपन भाई हारून अऊ ओकर बेटामन ला ये कपड़ा पहिराय के बाद, ओमन ला अभिसेक अऊ नियुक्त करबे। ओमन के संस्कार करबे ताकि ओमन पुरोहित के रूप म मोर सेवा करंय। ");
INSERT INTO hne_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“ओमन के उघरा देहें ला ढांपे बर मलमल के कच्छा बनवाबे, जऊन ह कनिहां ले लेके जांघ तक रहय। ");
INSERT INTO hne_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","जब भी हारून अऊ ओकर बेटामन मिलापवाला तम्बू म जावंय या पबितर स्थान म सेवा करे बर बेदी करा जावंय, त ओमन ओ कच्छामन ला जरूर पहिरंय, ताकि ओमन ऊपर दोस झन लगय अऊ ओमन झन मरंय। “येह हारून अऊ ओकर संतानमन बर हमेसा के आदेस होवय। ");
INSERT INTO hne_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“हारून अऊ ओकर बेटामन के संस्कार करे बर तोला ये करना हे, ताकि ओमन पुरोहित के रूप म मोर सेवा करंय: एक ठन निरदोस बछवा अऊ दू ठन निरदोस मेढ़ामन ला ले। ");
INSERT INTO hne_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","अऊ बिगर खमीर के गहूं के बढ़िया पीसान ले गोल रोटी बनवा, मोटा रोटीमन ला जैतून तेल मिलाके बिगर खमीर के बनवा, अऊ पातर रोटीमन ला बिगर खमीर के बनवा अऊ ओमा जैतून तेल ला चुपर दे। ");
INSERT INTO hne_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ये जम्मो ला एक ठन टुकनी म रखके बछवा अऊ दूनों मेढ़ा संग चघाबे। ");
INSERT INTO hne_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","तब हारून अऊ ओकर बेटामन ला मिलापवाला तम्बू के मुंहटा करा लानके ओमन ला पानी ले नहवाबे। ");
INSERT INTO hne_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","पहिरावा ला लेबे अऊ हारून ला अंगरखा, एपोद के बागा पहिरा देबे, एपोद अऊ छातीबंध घलो पहिरा देबे। एपोद ला सुघरता से बुने गय कमरबंध के दुवारा हारून म बांध देबे। ");
INSERT INTO hne_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ओकर मुड़ म पागा घलो रखबे अऊ पबितर मुकुट ला ओमा जोड़ देबे। ");
INSERT INTO hne_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","अभिसेक के तेल ला लेबे अऊ ओला ओकर मुड़ म रितोके ओकर अभिसेक करबे। ");
INSERT INTO hne_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","तब ओकर बेटामन ला घलो लानके ओमन ला अंगरखा पहिराबे ");
INSERT INTO hne_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","अऊ मुड़ म टोपी ला पहिराबे। तब हारून अऊ ओकर बेटामन के कनिहां म कमरबंध बांधबे। पुरोहित के पद ह ये आदेस के दुवारा हमेसा बर ओमन के अय। “तब हारून अऊ ओकर बेटामन के अभिसेक करबे। ");
INSERT INTO hne_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“बछवा ला मिलापवाला तम्बू के आघू म लानबे, अऊ हारून अऊ ओकर बेटामन ओ बछवा के मुड़ म अपन हांथ रखंय। ");
INSERT INTO hne_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","तब बछवा ला यहोवा के आघू म मिलापवाला तम्बू के प्रवेस दुवार करा बलि कर देबे। ");
INSERT INTO hne_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","बछवा के थोरकून लहू ला लेबे अऊ ओला बेदी के सींगमन म अपन अंगठी ले लगाबे, अऊ बांचे लहू ला बेदी के खाल्हे म रितो देबे। ");
INSERT INTO hne_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","तब भीतरी भाग के जम्मो चरबी, करेजा के लम्बा निकले भाग, अऊ चरबी सहित दूनों गुरदा ला घलो लेबे अऊ ओमन ला बेदी म जला देबे। ");
INSERT INTO hne_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","पर बछवा अऊ ओकर खाल अऊ मांस अऊ ओकर पोटा ला डेरा के बाहिर जला देबे। येह एक पाप-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“तब एक ठन मेढ़ा लेबे, अऊ हारून अऊ ओकर बेटामन ओ मेढ़ा के मुड़ म अपन हांथ रखंय। ");
INSERT INTO hne_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","तब ओ मेढ़ा ला बलि करबे अऊ ओकर लहू ला लेके बेदी के चारों मुड़ा म छिंच देबे। ");
INSERT INTO hne_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","तब ओ मेढ़ा ला कुटा-कुटा करके काटबे अऊ ओकर भीतरी भाग अऊ गोड़मन ला धोके ओमन ला मुड़ अऊ ओकर आने कुटामन संग रख देबे। ");
INSERT INTO hne_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","तब ओ पूरा मेढ़ा ला बेदी म जला देबे; येह यहोवा ला चघाय बर एक होम-बलिदान अय, अऊ यहोवा ला चघाय बर एक सुख-देवइया सुगंध, एक जेवन-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“आने मेढ़ा ला लेबे, अऊ हारून अऊ ओकर बेटामन ओ मेढ़ा के मुड़ म अपन हांथ रखंय। ");
INSERT INTO hne_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","तब ओ मेढ़ा ला बलि करबे, अऊ ओकर कुछू लहू ला लेके हारून अऊ ओकर बेटामन के जेवनी कान ऊपर, ओमन के जेवनी हांथ के अंगठा ऊपर, अऊ ओमन के जेवनी गोड़ के अंगठा म लगा देबे। तब बांचे लहू ला बेदी के चारों मुड़ा म छिंच देबे। ");
INSERT INTO hne_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","अऊ बेदी ले थोरकन लहू अऊ अभिसेक के थोरकन तेल लेके ओला हारून अऊ ओकर बेटामन के ऊपर अऊ ओमन के पहिरावा ऊपर छिंच देबे। तब ओ अऊ ओकर बेटा अऊ ओमन के पहिरावामन संस्कारित हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“ये मेढ़ा के चरबी, चरबीवाला पुंछी, पेट के भीतरी भाग के चरबी, करेजा के लम्बा निकले भाग, चरबी समेत दूनों गुरदा अऊ ओकर जेवनी जांघ ला लेबे। (येह अभिसेक के मेढ़ा अय।) ");
INSERT INTO hne_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","टुकनी के बिगर खमीर के बनाय गे रोटी, जऊन ह यहोवा के आघू म माढ़े हवय, ओमा के एक गोल रोटी, जैतून तेल म सनाय एक ठन मोटा रोटी, अऊ एक ठन पातर रोटी लेबे। ");
INSERT INTO hne_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ये जम्मो ला हारून अऊ ओकर बेटामन के हांथ म रख देबे अऊ ओमन येला यहोवा के आघू म एक हलाय-बलिदान के रूप म हलावंय। ");
INSERT INTO hne_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","तब ओमन के हांथ ले ओ चीजमन ला ले लेबे अऊ ओमन ला होम-बलिदान के संग यहोवा बर एक सुख-देवइया सुगंध के रूप म जला देबे। येह यहोवा बर चघाय गे एक जेवन-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","हारून के अभिसेक के मेढ़ा के छाती ला लेय के बाद, येला यहोवा के आघू म एक हलाय-बलिदान के रूप म हलाबे, अऊ येह तोर हिस्सा होही। ");
INSERT INTO hne_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“मेढ़ा के अभिसेक करे गय ओ भागमन के संस्कार करबे, जऊन ह हारून अऊ ओकर बेटामन के अय: याने कि हलाय गे छाती अऊ भेंट चघाय गय छाती ला संस्कारित करबे। ");
INSERT INTO hne_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","येह इसरायलीमन के दुवारा हारून अऊ ओकर बेटामन ला हमेसा दिये जानेवाला भाग होवय। येह इसरायलीमन के अंसदान अय, जेला ओमन अपन मेल-बलिदान म ले यहोवा बर देवंय। ");
INSERT INTO hne_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“हारून के पबितर पहिरावामन ओकर संतानमन के होहीं, ताकि ओ पहिरावा म ओमन के संस्कार अऊ अभिसेक करे जा सकय। ");
INSERT INTO hne_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ओकर बेटा, जऊन ह ओकर जगह म पुरोहित होही अऊ पबितर स्थान म सेवा करे बर मिलापवाला तम्बू म आही, त ओह सात दिन तक ओ पहिरावा ला पहिरय। ");
INSERT INTO hne_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“अभिसेक के मेढ़ा के मांस ला लेबे अऊ ओला एक पबितर स्थान म रांधबे। ");
INSERT INTO hne_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","हारून अऊ ओकर बेटामन मेढ़ा के ओ मांस अऊ टुकनी के रोटी ला मिलापवाला तम्बू के प्रवेस दुवार म खावंय। ");
INSERT INTO hne_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","हारून अऊ ओकर बेटामन भेंट के चीजमन ला खावंय, जेकर दुवारा ओमन के अभिसेक अऊ संस्कार बर पछताप करे गीस। पर कोनो आने मनखे ओ चीजमन ला झन खावंय, काबरकि ओमन पबितर चीज अंय। ");
INSERT INTO hne_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","अऊ बिहान तक कहूं अभिसेक वाला मेढ़ा के जऊन मांस अऊ रोटी बांच जाथे, त ओला जला देवंव। ओला झन खाय जावय, काबरकि ओह पबितर अय। ");
INSERT INTO hne_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“हारून अऊ ओकर बेटामन बर ओ जम्मो काम करव, जेकर हुकूम मेंह तुमन ला दे हंव, याने कि सात दिन तक ओमन के अभिसेक के ये बिधिमन ला पूरा करव। ");
INSERT INTO hne_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","प्रायस्चित करे बर हर दिन एक ठन बछवा पाप-बलिदान के रूप म चघावव। प्रायस्चित करे के बेरा बेदी ला सुध करव, अऊ ओला पबितर करे बर ओकर अभिसेक करव। ");
INSERT INTO hne_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात दिन ले बेदी बर पछताप करव अऊ ओला पबितर करव। तब बेदी ह महा पबितर ठहिरही, अऊ जऊन कुछू चीज बेदी ला छूथे, ओह पबितर हो जाही। ");
INSERT INTO hne_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“बेदी म जऊन चीज तोला रोज चघाना हे, ओह ये अय: एक-एक बछर के दू ठन निरदोस मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक ठन ला बिहनियां, अऊ दूसर ला सांझ के चघाबे। ");
INSERT INTO hne_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","पहिली मेढ़ा-पीला के संग एक एपा उत्तम पीसान के दसवां भाग ला पेरके निकाले गय एक हीन जैतून तेल के चौथा भाग म मिलाके चघाबे, अऊ एक हीन अंगूर के मंद के चौथा भाग ला एक पेय-बलिदान के रूप म चघाबे। ");
INSERT INTO hne_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","दूसर मेढ़ा-पीला ला सांझ के बेरा चघाबे, येला घलो बिहनियां के बेरा चघाय गे अन्न-बलिदान अऊ पेय-बलिदान के सहीं चघाबे—येह यहोवा बर चघाय एक सुखदाई सुगंध, एक जेवन-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“पीढ़ी-पीढ़ी तक यहोवा के आघू म, मिलापवाला तम्बू के मुंहटा करा ये होम-बलिदान ला नियमित चघाय जावय। उहां मेंह तोर ले मिलहूं अऊ तोर ले गोठियाहूं। ");
INSERT INTO hne_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","उहां मेंह इसरायलीमन ले घलो मिलहूं अऊ ओ जगह ह मोर महिमा ले पबितर करे जाही। ");
INSERT INTO hne_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“वइसने ही मेंह मिलापवाला तम्बू अऊ बेदी ला पबितर करहूं अऊ हारून अऊ ओकर बेटामन ला पुरोहित के रूप म मोर सेवा करे बर संस्कारित करहूं। ");
INSERT INTO hne_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","तब मेंह इसरायलीमन के बीच म निवास करहूं अऊ ओमन के परमेसर होहूं। ");
INSERT INTO hne_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ओमन जानहीं कि मेंह यहोवा ओमन के परमेसर अंव, जऊन ह ओमन ला मिसर देस ले निकाल लानिस, ताकि मेंह ओमन के बीच निवास करंव। मेंह यहोवा ओमन के परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“धूप जलाय बर बंबरी के लकड़ी ले एक ठन बेदी बनवाबे। ");
INSERT INTO hne_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ओह वर्गाकार होवय, एक क्यूबीट लम्बा अऊ एक क्यूबीट चौड़ा, अऊ दू क्यूबीट ऊंचा—अऊ ओकर सींगमन ला ओ बेदी संग एके कुटा ले बनाय जावंय। ");
INSERT INTO hne_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","बेदी के ऊपर अऊ जम्मो कोति अऊ सींगमन ला चोखा सोन ले मढ़बे, अऊ येकर चारों कोति सोन के एक किनारी लगाबे। ");
INSERT INTO hne_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","बेदी बर किनारी के खाल्हे म दू-दू ठन कड़ा बनवाबे—ये कड़ामन एक-दूसर के आमने-सामने होवंय, ताकि येमा डंडामन ला घुसावंय अऊ उठाके ले जा सकंय। ");
INSERT INTO hne_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","डंडामन ला बंबरी के लकड़ी ले बनवाबे अऊ ओमन ला सोन ले मढ़बे। ");
INSERT INTO hne_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","बेदी ला ओ परदा के आघू म रखबे, जऊन ह करार कानून के सन्दूक ला ओधा करथे—याने कि पछताप के ढकना के आघू म, जऊन ह करार कानून के पटियामन के ऊपर हवय—जिहां मेंह तोर ले मिलहूं। ");
INSERT INTO hne_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“हारून ह बिहनियां जब दीयामन ला ठीक करथे, त ओह रोज बिहनियां बेदी म सुगंधित धूप जलावय। ");
INSERT INTO hne_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","फेर जब हारून ह संझा के बेरा म दीयामन ला बारथे, त ओ बेरा घलो धूप जलावय, ताकि अवइया पीढ़ी-पीढ़ी तक यहोवा के आघू म हमेसा धूप ह जलत रहय। ");
INSERT INTO hne_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ये बेदी म अऊ कोनो आने किसम के धूप झन जलाबे या येमा कोनो होम-बलिदान या अन्न-बलिदान झन चघाबे, अऊ येमा कोनो पेय-बलिदान झन रितोबे। ");
INSERT INTO hne_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","हारून ह साल म एक बार ओकर सींगमन म प्रायस्चित करय। साल म एक बार करइया ये प्रायस्चित ला अवइया पीढ़ी-पीढ़ी तक प्रायस्चित के पाप-बलिदान के लहू के संग करे जावय। येह यहोवा बर महा पबितर अय।” ");
INSERT INTO hne_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“जब तेंह इसरायलीमन के संखिया ला जाने बर गनती करबे, त हर एक जन अपन गनती के बेरा यहोवा ला अपन जिनगी बर छुड़ौती के रकम देवय। तब ओमन ऊपर कोनो महामारी नइं आही, जब तेंह ओमन के गनती करबे। ");
INSERT INTO hne_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","हर एक मनखे, जब अपन गनती के बाद गने गय मनखेमन कोति जाथे, त ओह पबितर-स्थान के सेकेल के मुताबिक आधा सेकेल देवय, जेकर वजन बीस गेरा होथे। ये आधा सेकेल ह यहोवा बर एक भेंट अय। ");
INSERT INTO hne_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ओ जम्मो जेमन के गनती होथे अऊ बीस साल या ओकर ले जादा के रहिथें, ओमन यहोवा ला भेंट देवंय। ");
INSERT INTO hne_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","जब तुमन अपन जिनगी बर प्रायस्चित के भेंट यहोवा ला देवव, त चाहे ओह धनी होवय या गरीब, हर एक मनखे आधा सेकेल ही देवय; कोनो भी न तो आधा सेकेल ले जादा अऊ न आधा सेकेल ले कम देवय। ");
INSERT INTO hne_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","तेंह इसरायलीमन ले प्रायस्चित के रूपिया लेबे अऊ ओकर उपयोग मिलापवाला तम्बू के सेवा बर करबे। येह तुम्हर जिनगी के प्रायस्चित करे बर यहोवा के आघू म इसरायलीमन बर एक स्मारक होही।” ");
INSERT INTO hne_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“धोये बर तेंह कांसा के एक तसला बनाबे अऊ ओकर पाया ला घलो कांसा के बनाबे। ओला मिलापवाला तम्बू अऊ बेदी के मांझा म मढ़ाके ओमा पानी भर देबे। ");
INSERT INTO hne_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","हारून अऊ ओकर बेटामन ओमा के पानी ले अपन हांथ अऊ गोड़ धोवंय। ");
INSERT INTO hne_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","जब कभू ओमन मिलापवाला तम्बू म जावंय, त ओमन पानी ले हांथ-गोड़ धोवंय, ताकि ओमन झन मरंय। अऊ जब कभू ओमन यहोवा ला जेवन-बलिदान चघाय के दुवारा सेवा करे बर बेदी करा जावंय, ");
INSERT INTO hne_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","त ओमन अपन हांथ-गोड़ ला धोवंय, ताकि ओमन झन मरंय। येह हारून अऊ ओकर संतानमन बर अवइया पीढ़ी-पीढ़ी तक हमेसा के एक बिधि होवय।” ");
INSERT INTO hne_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ये बढ़िया मसालामन ला लेबे: 500 सेकेल तरल लोहबान, 250 सेकेल खुसबूवाला दालचीनी, 250 सेकेल खुसबूवाला तेजपान, ");
INSERT INTO hne_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","500 सेकेल दालचीनी—अऊ एक हीन जैतून तेल। ");
INSERT INTO hne_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","येमन ले तेंह एक पबितर अभिसेक के तेल बनाबे, येह एक सुगंधवाला मिलावट होवय अऊ येह एक अंतर तेल बनानेवाला के काम होवय। येह अभिसेक के पबितर तेल होही। ");
INSERT INTO hne_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","तब इही तेल ले तेंह मिलापवाला तम्बू, करार कानून के सन्दूक, ");
INSERT INTO hne_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","अऊ मेज अऊ येकर जम्मो सामान, दीवट अऊ येकर जम्मो सामान, धूप के बेदी, ");
INSERT INTO hne_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","होम-बलिदान के बेदी अऊ येकर जम्मो बरतन, अऊ तसला अऊ ओकर खुरा के अभिसेक करबे। ");
INSERT INTO hne_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","तेंह ये जम्मो के संस्कार करबे ताकि येमन महा पबितर हो जावंय, अऊ जऊन कुछू येमन ला छुही, ओह घलो पबितर हो जाही। ");
INSERT INTO hne_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“तेंह हारून अऊ ओकर बेटामन के अभिसेक करबे अऊ ओमन के संस्कार करबे, ताकि ओमन पुरोहित के रूप म मोर सेवा करंय। ");
INSERT INTO hne_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","तेंह इसरायलीमन ले ये कहिबे, ‘येह अवइया पीढ़ी-पीढ़ी तक मोर पबितर अभिसेक के तेल होवय। ");
INSERT INTO hne_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","येला कोनो आने मनखे के देहें म झन रितोहू अऊ इही नुसखा के उपयोग करत कोनो आने तेल झन बनाबे। येह पबितर अय, अऊ येला तुमन पबितर समझव। ");
INSERT INTO hne_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जऊन कोनो येकर सहीं अंतर तेल बनाथे अऊ ओला पुरोहित के छोंड़ कोनो आने मनखे ऊपर डारथे, त ओला अपन मनखेमन के बीच म ले अलग करे जावय।’ ” ");
INSERT INTO hne_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","फेर यहोवा ह मूसा ला कहिस, “ये सुगंधित मसालामन लेय ले—गंधरस, कस्तुरी गंधिका अऊ बिरोजा—अऊ सुध लोहबान; ये जम्मो ला बरोबर मात्रा म लेबे, ");
INSERT INTO hne_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","अऊ ये जम्मो ला मिलाके धूप के एक सुगंधित मिंझरा बनाबे; येह एक अंतर तेल बनानेवाला के काम होवय। येह नूनचूर अऊ सुध अऊ पबितर होवय। ");
INSERT INTO hne_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","येमा के थोरकन ला पीसके चूरन बना लेबे अऊ ओला मिलापवाला तम्बू म करार कानून के सन्दूक के आघू म रखबे, जिहां मेंह तोर ले मिलहूं। येह तुम्हर बर महा पबितर होही। ");
INSERT INTO hne_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","इही नुसखा के उपयोग करत अपन बर कोनो आने धूप झन बनाबे; येला यहोवा बर पबितर समझव। ");
INSERT INTO hne_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","जऊन कोनो ये किसम के धूप येकर खुसबू के आनंद उठाय बर बनाथे, ओला अपन मनखेमन के बीच ले अलग करे जावय।” ");
INSERT INTO hne_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“देखव, मेंह यहूदा के गोत्र ले हूर के नाती, ऊरी के बेटा बसलेल ला चुने हंव, ");
INSERT INTO hne_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","अऊ मेंह ओला परमेसर के आतमा, बुद्धि, समझ, गियान अऊ जम्मो किसम के हुनर ले भर दे हंव— ");
INSERT INTO hne_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ताकि ओह सोन, चांदी अऊ कांसा के कलात्मक नमूना बनावय, ");
INSERT INTO hne_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","पथरामन ला काटे अऊ मढ़ाय, लकड़ी के काम करय, अऊ जम्मो किसम के सिल्पकारी करय। ");
INSERT INTO hne_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","येकर अलावा, मेंह दान के गोत्र ले अहीसामाक के बेटा ओहोलीआब ला नियुक्त करे हंव कि ओह बसलेल के मदद करे। ");
INSERT INTO hne_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“मिलापवाला तम्बू, करार कानून के सन्दूक अऊ ओकर पछताप के ढकना, अऊ तम्बू के आने जम्मो चीज— ");
INSERT INTO hne_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","मेज अऊ ओकर जम्मो चीज, चोखा सोन के दीवट अऊ ओकर जम्मो चीज, धूप के बेदी, ");
INSERT INTO hne_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","होम-बलिदान के बेदी अऊ ओकर जम्मो बरतन, तसला अऊ ओकर खुरा— ");
INSERT INTO hne_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","अऊ बुने गय पहिरावामन घलो, हारून पुरोहित के पबितर पहिरावा अऊ ओकर बेटामन के ओ पहिरावा, जब ओमन पुरोहित के रूप म सेवा करत बेरा पहिरहीं, ");
INSERT INTO hne_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अऊ अभिसेक के तेल अऊ पबितर स्थान बर सुगंधित धूप। ");
INSERT INTO hne_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“तेंह इसरायलीमन ला ये कहिबे, ‘तुमन मोर बिसराम दिन ला जरूर मानव। येह अवइया पीढ़ी-पीढ़ी तक मोर अऊ तुम्हर बीच म एक ठन चिनहां होही, ताकि तुमन जानव कि मेंह यहोवा अंव, जऊन ह तुमन ला पबितर करथे। ");
INSERT INTO hne_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘बिसराम दिन ला मानव, काबरकि ये दिन ह तुम्हर बर पबितर अय। जऊन कोनो येला अपबितर करथे, ओह मार डारे जावय; जऊन कोनो ओ दिन कोनो बुता करय, ओह अपन मनखेमन के बीच ले अलग करे जावय। ");
INSERT INTO hne_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","काबरकि हर हप्ता छै दिन काम-बुता करे जावय, पर सातवां दिन बिसराम के दिन अऊ यहोवा बर पबितर अय। जऊन कोनो बिसराम दिन म कुछू बुता करय, ओह मार डारे जाय। ");
INSERT INTO hne_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इसरायलीमन बिसराम दिन ला मानंय; ओमन येला अवइया पीढ़ी-पीढ़ी तक हमेसा के एक करार के रूप म मानंय। ");
INSERT INTO hne_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","येह मोर अऊ इसरायलीमन के बीच म सदाकाल बर एक चिनहां ठहिरही, काबरकि छै दिन म यहोवा ह अकास अऊ धरती ला बनाईस, अऊ सातवां दिन ओह बिसराम करिस अऊ तरो-ताजा होईस।’ ” ");
INSERT INTO hne_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","जब यहोवा ह सीनय पहाड़ ऊपर मूसा ले बात कर चुकिस, त ओह मूसा ला करार कानून के दू ठन पटिया ला दीस, येमन पथरा के ओ पटियामन रिहिन, जेमा परमेसर ह अपन अंगठी ले लिखे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","जब मनखेमन देखिन कि मूसा ला पहाड़ ले उतरके आय म बहुंत समय लगत हे, त ओमन हारून के चारों मुड़ा जूरिन अऊ कहिन, “आ, हमर बर एक देवता बना, जऊन ह हमर आघू-आघू जाही, काबरकि ओ मनखे मूसा, जऊन ह हमन ला मिसर देस ले निकालके लाने रिहिस, ओला का होईस, हमन नइं जानत हन?” ");
INSERT INTO hne_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","त हारून ह ओमन ला जबाब दीस, “तुमन अपन-अपन घरवाली, अपन बेटा अऊ अपन बेटीमन के कान म पहिरे सोन के बालीमन ला हेरके मोर करा लानव।” ");
INSERT INTO hne_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","तब जम्मो मनखेमन अपन-अपन कान ले सोन के बालीमन ला हेरिन अऊ ओला हारून करा ले आईन। ");
INSERT INTO hne_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","हारून ह ओमन ले ओ सोन ला ले लीस, अऊ ओह ओला ढालके एक औजार के दुवारा बछवा के रूप म एक मूरती बनाईस। तब ओमन कहे लगिन, “हे इसरायलीमन, येह तुम्हर देवता ए, जऊन ह तुमन ला मिसर देस ले बाहिर निकालके लानिस।” ");
INSERT INTO hne_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","जब हारून ह येला देखिस, त ओह ओ बछवा के आघू म एक ठन बेदी बनाईस अऊ ये घोसना करिस, “कल यहोवा बर एक तिहार होही।” ");
INSERT INTO hne_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","एकरसेति दूसर दिन मनखेमन बड़े बिहनियां उठिन अऊ होम-बलिदान चघाईन, अऊ मेल-बलिदान लाईन। ओकर बाद ओमन खाय-पीये बर बईठिन अऊ उठके उछल-मंगल करे लगिन। ");
INSERT INTO hne_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","तब यहोवा ह मूसा ला कहिस, “खाल्हे उतर जा, काबरकि तोर मनखेमन, जऊन मन ला तेंह मिसर देस ले निकालके लाने हस, ओमन बिगड़ गे हवंय। ");
INSERT INTO hne_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","जऊन बात के हुकूम मेंह ओमन ला देय रहेंव, ओमन ओमा ले बहुंत जल्दी हट गे हवंय अऊ ओमन अपन बर बछवा के आकार म एक ठन मूरती बना ले हवंय। ओमन ओला दंडवत करिन अऊ ओकर बर बलिदान चघाईन अऊ ये कहिन, ‘हे इसरायलीमन, येह तुम्हर देवता अय, जऊन ह तुमन ला मिसर देस ले निकालके लाने हवय।’ ” ");
INSERT INTO hne_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","फेर यहोवा ह मूसा ला कहिस, “मेंह ये मनखेमन ला देखे हंव, येमन ढीठ मनखे अंय। ");
INSERT INTO hne_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","अब तेंह मोला अकेला छोंड़ दे ताकि मोर कोरोध ह ओमन ऊपर भड़के अऊ मेंह ओमन ला नास कर दंव। तब मेंह तोर ले एक ठन बड़े जाति बनाहूं।” ");
INSERT INTO hne_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","पर मूसा ह यहोवा अपन परमेसर ले दया के कामना करत ये कहिस, “हे यहोवा, तेंह काबर अपन मनखेमन ऊपर कोरोध करत हस, जेमन ला तेंह अपन बड़े सामर्थ अऊ सक्तिसाली हांथ ले मिसर देस ले निकालके लानय? ");
INSERT INTO hne_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मिसरीमन काबर ये कहंय, ‘ओह ओमन ला गलत उदेस्य ले निकाल लानिस ताकि ओह ओमन ला पहाड़ म मार डारय अऊ धरती ले ओमन के नामोनिसान मिटा दे?’ एकरसेति अपन कोरोध ला छोंड़; दया कर अऊ अपन मनखेमन ऊपर बिपत्ति झन लान। ");
INSERT INTO hne_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","अपन सेवक अब्राहम, इसहाक अऊ इसरायल ला सुरता कर, जेमन ले तेंह अपनेच कसम खाके कहे रहय: ‘मेंह तुम्हर संतानमन ला अकास के तारामन सहीं अनगिनत कर दूहूं अऊ मेंह तुम्हर संतानमन ला ये जम्मो देस दूहूं, जेकर वायदा मेंह ओमन ले करे हंव, अऊ येह सदाकाल बर ओमन के निज भाग होही।’ ” ");
INSERT INTO hne_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तब यहोवा ह दया करिस अऊ अपन मनखेमन ऊपर ओ बिपत्ति नइं लानिस, जेकर धमकी ओह दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","तब मूसा ह मुड़िस अऊ पहाड़ ले खाल्हे उतरिस; ओह अपन हांथ म करार कानून के दूनों पटिया ला धरे रिहिस। ओ पटियामन के आघू अऊ पाछू दूनों कोति लिखाय रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ओ पटियामन ला परमेसर ह बनाय रिहिस; अऊ ओ पटियामन म जऊन लिखावट रिहिस, ओला परमेसर ह खोदके लिखे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","जब यहोसू ह मनखेमन के चिचियाय के अवाज ला सुनिस, त ओह मूसा ला कहिस, “डेरा ले लड़ई के अवाज आवत हे।” ");
INSERT INTO hne_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मूसा ह जबाब दीस: “येह जीत के अवाज नो हय, येह हार के अवाज घलो नो हय; पर मोला तो गीत गाय के अवाज सुनई देवत हे।” ");
INSERT INTO hne_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","जब मूसा ह डेरा करा आईस अऊ बछवा ला देखिस अऊ मनखेमन ला नाचत देखिस, त ओकर गुस्सा भड़किस अऊ ओह अपन हांथ के पटियामन ला फटिक दीस अऊ पटियामन पहाड़ के खाल्हे म टूटके कुटा-कुटा हो गीन। ");
INSERT INTO hne_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","अऊ ओह मनखेमन के बनाय ओ बछवा ला लीस अऊ ओला आगी म जला दीस; तब ओला कुचरके चूर-चूर कर दीस अऊ चूरा ला पानी म छिंच दीस अऊ ओ चूरा मिले पानी इसरायलीमन ला पीयाईस। ");
INSERT INTO hne_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","तब मूसा ह हारून ला कहिस, “ये मनखेमन तोर संग का करिन कि तेंह येमन ले अतेक बड़े पाप करवाय?” ");
INSERT INTO hne_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारून ह जबाब दीस, “हे मोर मालिक, तें गुस्सा झन कर; तेंह तो जानत हस कि येमन बुरई के काम करे बर कतेक लालायित रहिथें। ");
INSERT INTO hne_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ओमन मोला कहिन, ‘हमर बर एक ठन देवता बना, जऊन ह हमर आघू-आघू जाही। जिहां तक ओ मनखे मूसा के सवाल हे, जऊन ह हमन ला मिसर देस ले निकालके लानिस, हमन नइं जानन कि ओकर का होईस?’ ");
INSERT INTO hne_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","एकरसेति मेंह ओमन ला कहेंव, ‘जेकर करा भी सोन के कोनो जेवर हवय, ओमन ओला हेरके ले आवंय।’ तब ओमन मोर करा सोन ले आईन, अऊ मेंह ओला आगी म डारेंव, अऊ ओमा ले ये बछवा निकलिस!” ");
INSERT INTO hne_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मूसा ह देखिस कि मनखेमन एती-ओती भागत हें अऊ हारून ह ओमन ला अपन काबू ले बाहिर कर दे रिहिस अऊ एकरसेति ओमन अपन बईरीमन के ठट्ठा के कारन हो गे रहंय। ");
INSERT INTO hne_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","त मूसा ह छावनी के मुंहटा म ठाढ़ होके कहिस, “जऊन कोनो यहोवा कोति हवव, ओह मोर करा आवव।” अऊ जम्मो लेवीमन ओकर करा जूर गीन। ");
INSERT INTO hne_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","तब मूसा ह ओमन ला कहिस, “यहोवा, इसरायल के परमेसर ह ये कहत हे: ‘तुमन म ले हर आदमी ह अपन बाजू म एक तलवार बांध लेवय। सिविर के एक छोर ले लेके दूसर छोर तक आती-जाती हर एक झन अपन भाई अऊ संगवारी अऊ परोसी ला मार डारव।’ ” ");
INSERT INTO hne_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","लेवीमन वइसे ही करिन, जइसे मूसा ह हुकूम दीस, अऊ ओ दिन लगभग तीन हजार मनखे मारे गीन। ");
INSERT INTO hne_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","तब मूसा ह कहिस, “आज तुमन ला यहोवा बर अलग करे गे हवय, काबरकि तुमन अपन खुद के बेटा अऊ भाईमन के बिरूध म रहेव, एकरसेति यहोवा ह तुमन ला आज आसीस दे हवय।” ");
INSERT INTO hne_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","दूसर दिन मूसा ह मनखेमन ला कहिस, “तुमन एक बहुंत बड़े पाप करे हव। पर अब मेंह पहाड़ ऊपर यहोवा करा जावत हंव; सायद मेंह तुम्हर पाप बर प्रायस्चित कर सकंव।” ");
INSERT INTO hne_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","तब मूसा ह यहोवा करा वापिस गीस अऊ कहिस, “हाय, हाय, ये मनखेमन बहुंत बड़े पाप करे हवंय! ओमन अपन बर सोन के देवता बना ले हवंय। ");
INSERT INTO hne_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","पर अब, तेंह किरपा करके ओमन के पाप ला छेमा कर दे—यदि नइं, त फेर मोर नांव ला ओ किताब म ले मिटा दे, जऊन ला तेंह लिखे हस।” ");
INSERT INTO hne_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","यहोवा ह मूसा ला जबाब दीस, “जऊन कोनो मोर बिरूध म पाप करे हवय, मेंह ओकरे नांव ला मोर किताब ले मिटा दूहूं। ");
INSERT INTO hne_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","अब तेंह जा, अऊ ये मनखेमन ला ओ ठऊर म ले जा, जेकर बारे म मेंह तोला बताय हंव, अऊ मोर स्वरगदूत ह तोर आघू-आघू जाही। तभो ले जब मोर सजा देय के समय आही, त मेंह ओमन ला ओमन के पाप के सजा दूहूं।” ");
INSERT INTO hne_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","अऊ यहोवा ह ओ मनखेमन के बीच एक महामारी लानिस काबरकि ओमन हारून के दुवारा बछवा बनवाय रिहिन अऊ ओकर अराधना करे रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","तब यहोवा ह मूसा ला कहिस, “तें अऊ जऊन मनखेमन ला मिसर देस ले निकालके लाने हस, तुमन जम्मो झन ये जगह ला छोंड़के ओ देस म चले जावव, जेकर वायदा मेंह अब्राहम, इसहाक अऊ याकूब ले सपथ खाके करे रहेंव, ‘मेंह ओला तुम्हर संतानमन ला दूहूं।’ ");
INSERT INTO hne_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","मेंह तुम्हर आघू एक स्वरगदूत ला पठोहूं अऊ कनानी, अमोरी, हित्ती, परिज्जी, हिब्बी, अऊ यबूसीमन ला भगा दूहूं। ");
INSERT INTO hne_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ओ देस म जावव, जिहां दूध अऊ मंधरस बहुंतायत म मिलथे, पर मेंह तुम्हर संग नइं जावंव, काबरकि तुमन ढीठ मनखे अव अऊ अइसने झन होवय कि मेंह तुमन ला डहार म ही नास कर दंव।” ");
INSERT INTO hne_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","जब मनखेमन ये दुख के समाचार ला सुनिन, त ओमन बिलाप करे लगिन अऊ कोनो भी अपन जेवर ला नइं पहिरिन। ");
INSERT INTO hne_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","काबरकि यहोवा ह मूसा ला कहे रिहिस, “इसरायलीमन ला ये कह, ‘तुमन ढीठ मनखे अव। कहूं मेंह तुम्हर संग एक घरी घलो चलंव, त हो सकथे मेंह तुमन ला नास कर दंव। एकरसेति अब तुमन अपन जेवरमन ला उतारव अऊ मेंह फैसला करहूं कि तुम्हर संग का करना हे।’ ” ");
INSERT INTO hne_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","एकरसेति इसरायलीमन होरेब पहाड़ म अपन जेवरमन ला उतार दीन। ");
INSERT INTO hne_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मूसा ह एक ठन तम्बू ला लेके छावनी के बाहिर थोरकन दूरिहा म खड़े करय, अऊ ओला मिलापवाला तम्बू कहय। जऊन कोनो ला यहोवा ले कोनो बात पुछना रहय, त ओह छावनी ले बाहिर ओ मिलापवाला तम्बू करा जावय। ");
INSERT INTO hne_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","अऊ जब भी मूसा ह मिलापवाला तम्बू करा जावय, त जम्मो मनखेमन उठके अपन-अपन तम्बू के मुंहटा म ठाढ़ हो जावंय, अऊ मूसा ला तब तक देखत रहंय, जब तक ओह तम्बू के भीतर नइं चले जावय। ");
INSERT INTO hne_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","मूसा के तम्बू म जावत ही बादर के खंभा उतरके तम्बू के मुंहटा म ठहर जावय, अऊ यहोवा ह मूसा ले गोठियावय। ");
INSERT INTO hne_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","जब भी मनखेमन बादर के खंभा ला तम्बू के मुंहटा म खड़े देखंय, त ओ जम्मो झन अपन-अपन तम्बू के मुंहटा म अराधना करंय। ");
INSERT INTO hne_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","यहोवा ह मूसा ले आमने-सामने गोठियावय, जइसन कोनो मनखे अपन संगवारी ले गोठियाथे। तब मूसा छावनी म लहुंटय, पर ओकर जवान सहायक नून के बेटा यहोसू ह तम्बू ला बिगर छोंड़े उहां बने रहय। ");
INSERT INTO hne_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मूसा ह यहोवा ला कहिस, “तेंह मोला कहत आय हस, ‘ये मनखेमन के अगुवई कर,’ पर तेंह मोला ये नइं बताय हस कि मोर संग तेंह कोन ला पठोबे। तेंह कहे हस, ‘मेंह तोला तोर नांव ले जानत हंव अऊ तोर ऊपर मोर किरपा हवय।’ ");
INSERT INTO hne_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","यदि तेंह मोर ले खुस हवस, त तेंह मोला अपन रसता के बारे म सिखा, ताकि मेंह तोला जानंव अऊ तोर किरपा मोर ऊपर हमेसा बने रहय। ये बात के सुरता रखबे कि ये जाति के मनखेमन तोरेच मनखे अंय।” ");
INSERT INTO hne_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","यहोवा ह जबाब दीस, “मोर उपस्थिति तोर संग बने रहिही, अऊ मेंह तोला बिसराम दूहूं।” ");
INSERT INTO hne_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","तब मूसा ह ओला कहिस, “कहूं तोर उपस्थिति हमर संग बने नइं रहय, त हमन ला इहां ले अऊ आघू झन भेज। ");
INSERT INTO hne_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","जब तेंह हमर संग नइं रहिबे, त कोनो मनखे ह ये कइसे जानही कि तेंह मोर ले अऊ अपन मनखेमन ले खुस हवस? का आने चीज अय, जऊन ह मोला अऊ तोर मनखेमन ला ये धरती के जम्मो मनखेमन ले अलग करही?” ");
INSERT INTO hne_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","अऊ यहोवा ह मूसा ला कहिस, “मेंह ओ हर काम ला करहूं, जेला तेंह कहे हस, काबरकि मेंह तोर ले खुस हंव अऊ मेंह तोला तोर नांव ले जानत हंव।” ");
INSERT INTO hne_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","तब मूसा ह कहिस, “मोर बिनती हवय कि तेंह मोला अपन महिमा देखा।” ");
INSERT INTO hne_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","अऊ यहोवा ह कहिस, “मेंह अपन जम्मो भलई तोर आघू म देखाहूं, अऊ मेंह अपन नांव यहोवा के घोसना तोर आघू म करहूं। जेकर ऊपर मेंह दया करे चाहंव, ओकर ऊपर दया करहूं, अऊ जेकर ऊपर मेंह तरस खाय चाहंव, ओकर ऊपर तरस खाहूं।” ");
INSERT INTO hne_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ओह आगे कहिस, “पर तेंह मोर चेहरा ला नइं देख सकस, काबरकि कोनो भी मनखे मोला देखे के बाद जीयत नइं रह सकय।” ");
INSERT INTO hne_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","फेर यहोवा ह कहिस, “मोर लकठा म एक जगह हवय, जिहां तेंह एक चट्टान ऊपर ठाढ़ हो सकत हस। ");
INSERT INTO hne_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","जब मोर महिमा ह उहां ले होके जाही, त मेंह तोला चट्टान के एक दरार म रख दूहूं अऊ तोला अपन हांथ ले तब तक ढांपे रहिहूं, जब तक कि मेंह उहां ले निकल नइं जावंव। ");
INSERT INTO hne_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","तब मेंह अपन हांथ ला टार दूहूं अऊ तेंह मोर पीठ ला देखे बर पाबे, पर मोर चेहरा ह नइं दिखय।” ");
INSERT INTO hne_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","यहोवा ह मूसा ला कहिस, “पहिली के पटियामन सहीं पथरा के दू ठन पटिया काटके बना ले, अऊ में ये पटियामन म ओ बचनमन ला फेर लिख दूहूं, जेमन पहिली के पटियामन म रिहिन, जेमन ला तें टोर देय। ");
INSERT INTO hne_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","बिहनियां तियार होके सीनय पहाड़ के टीप म चघके मोर करा ठाढ़ होबे। ");
INSERT INTO hne_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तोर संग कोनो अऊ चघके झन आवय, पहाड़ ऊपर कोनो कोति कोनो झन दिखय; इहां तक कि कोनो भेड़-बकरी अऊ गरूवा-बईला घलो ओ पहाड़ के आघू म झन चरत रहंय।” ");
INSERT INTO hne_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","मूसा ह काटके पथरामन के दू ठन पटिया पहिली सहीं बनाईस, फेर ओह यहोवा के हुकूम के मुताबिक बिहनियां उठिस अऊ पथरा के दूनों पटियामन ला अपन हांथ म धरके सीनय पहाड़ म चघिस। ");
INSERT INTO hne_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","तब यहोवा ह बादर म उतरिस अऊ ओकर संग ठाढ़ होके अपन नांव यहोवा के घोसना करिस। ");
INSERT INTO hne_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","अऊ यहोवा ह मूसा के सामने ले होके निकलिस अऊ ये कहत गीस, “यहोवा, यहोवा, दयालु अऊ किरपा करइया परमेसर, कोरोध करे म धीमा, मया ले भरपूर अऊ बिसवासयोग्य अय, ");
INSERT INTO hne_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हजारों झन ला सदा मया करइया, अधरम, अपराध अऊ पाप छेमा करइया; फेर दोसी ला ओह निरदोस नइं छोंड़य, ओह दाई-ददा के पाप बर ओमन के लइकामन ला तीसरा अऊ चौथा पीढ़ी तक दंड देथे।” ");
INSERT INTO hne_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","मूसा ह तुरते भुइयां कोति झुकिस अऊ अराधना करिस। ");
INSERT INTO hne_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","अऊ ओह कहिस, “हे परभू, कहूं तोर दया-मया ह मोर ऊपर हवय, त परभू ह हमर संग चलय। हालाकि ये मनखेमन ढीठ अंय, पर तें हमर पाप अऊ अधरम ला छेमा कर अऊ हमन ला अपन मानके गरहन कर।” ");
INSERT INTO hne_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","तब यहोवा ह कहिस: “सुन, मेंह एक ठन करार करत हंव। मेंह तोर जम्मो झन के आघू म अइसन अचम्भो बुता करहूं, जइसन जम्मो धरती म कोनो जातिमन के आघू म कभू नइं करे गे हवय, अऊ ओ जम्मो झन, जऊन मन के मांझा म तेंह रहत हस, ओमन यहोवा के बुता ला देखहीं, काबरकि जऊन कुछू मेंह करइया हंव, ओह अद्भूत बुता अय। ");
INSERT INTO hne_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","जऊन हुकूम आज मेंह तुमन ला दूहूं, ओला तुमन मानव। मेंह तुम्हर आघू ले अमोरी, कनानी, हित्ती, परिज्जी, हिब्बी अऊ यबूसी जाति के मनखेमन ला निकाल दूहूं। ");
INSERT INTO hne_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","एकरसेति धियान रहय कि ओ देस म रहइयामन के संग कोनो करार झन करव, जिहां तुमन जवइया हव, कहूं अइसन झन होवय कि ओमन तुम्हर बर फांदा बन जावंय। ");
INSERT INTO hne_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","पर तुमन ओमन के बेदीमन ला टोरके गिरा दव अऊ ओमन के पबितर पथरामन ला कुटा-कुटा कर दव, अऊ ओमन के असेरा के खंभामन ला काट डारव; ");
INSERT INTO hne_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","कोनो आने देवता के अराधना झन करव, काबरकि यहोवा जेकर नांव जलन रखइया अय, ओह जल उठइया परमेसर अय। ");
INSERT INTO hne_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“धियान रहय कि ओ देस म रहइयामन के संग कोनो करार झन करव; काबरकि जब ओमन अपन देवतामन के अराधना करके बेभिचार के सहीं काम करथें अऊ ओकर बर बलिदान चघाथें, त ओमन तुमन ला नेवता दीहीं अऊ तुमन ओमन के बलिदान करे गय चीज ला खाहू। ");
INSERT INTO hne_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","अऊ जब तुमन ओमन के बेटीमन ला अपन बेटामन के घरवाली होय बर लेथव अऊ ओ बेटीमन खुदे अपन देवतामन के पाछू चलके बेभिचार करथें, त ओमन तुम्हर बेटामन ला घलो वइसनेच करे बर ले जाहीं। ");
INSERT INTO hne_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“अपन बर कोनो देवता झन बनाहू। ");
INSERT INTO hne_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“अखमीरी रोटी के तिहार मनाहू, ओमा तुमन मोर हुकूम के मुताबिक अबीब महिना के नियत बेरा म सात दिन ले अखमीरी रोटी खाय करहू, काबरकि तुमन अबीब महिना म मिसर देस ले निकलके आय रहेव। ");
INSERT INTO hne_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“हर एक कोख के पहिली लइका ह मोर अय। चाहे ओह बछवा होवय चाहे भेड़; तुम्हर पसुमन म ले घलो पहिली नर पीला ह मोर अय। ");
INSERT INTO hne_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गदहा के पहिली पीला के बलदा मेढ़ा-पीला देके ओला छोंड़ाहू, फेर कहूं तेंह ओला छोंड़ाय बर नइं चाहस, त ओकर घेंच ला टोर दूहू। पर अपन जम्मो पहिलांत बेटामन ला बलदा देके छोंड़ाहू। “कोनो मोला जुच्छा हांथ अपन मुहूं झन देखावंय। ");
INSERT INTO hne_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“हर हप्ता छै दिन ले कमाहू, अऊ सातवां दिन अराम करहू; नांगर जोतई अऊ लुवई के बखत घलो अराम करहू। ");
INSERT INTO hne_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“तुमन हप्तामन के तिहार मनाहू, मतलब कि गहूं के ऊपज के पहिली-फसल के तिहार अऊ बछर के आखिरी म संकेलन तिहार घलो मनाहू। ");
INSERT INTO hne_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","साल म तीन बार तुम्हर जम्मो आदमीमन परमपरधान यहोवा, इसरायल के परमेसर के आघू म उपस्थित होवंय। ");
INSERT INTO hne_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","काबरकि मेंह आनजातमन ला तोर आघू ले निकालके तोर सिवाना ला बढ़ाहूं अऊ जब तुमन एक बछर म तीन बार अपन यहोवा के आघू म ठाढ़ होय बर जाहू, तब कोनो तोर भुइयां के लालच नइं करही। ");
INSERT INTO hne_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“कोनो बलिदान करे गय पसु के लहू ला कोनो खमीर मिले हुए चीज के संग झन चघावव अऊ फसह तिहार के बलिदान म ले बिहान तक ले कुछू ला झन बचाहू। ");
INSERT INTO hne_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“तुमन अपन भुइयां के सबले बने पहिली-फसल ला यहोवा अपन परमेसर के घर म लानव। “तुमन कोनो छेरी-पीला ला ओकर मियारी के दूध म झन रांधहू।” ");
INSERT INTO hne_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","फेर यहोवा ह मूसा ला कहिस, “ये बचनमन ला लिख ले, काबरकि मेंह इही बचन के मुताबिक तोर ले अऊ इसरायल ले करार करे हंव।” ");
INSERT INTO hne_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मूसा ह यहोवा संग उहां चालीस दिन अऊ चालीस रात रिहिस, ओह रोटी नइं खाईस अऊ पानी घलो नइं पीईस, अऊ ओह ओ पटियामन म करार के बचन याने कि दस हुकूममन ला लिखिस। ");
INSERT INTO hne_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","जब मूसा ह करार कानून के दूनों पटिया ला हांथ म धरे सीनय पहाड़ ले उतरत रिहिस, त यहोवा संग गोठियाय के कारन ओकर मुहूं ह चमकत रिहिस, पर ओह ये बात ला नइं जानत रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","जब हारून अऊ जम्मो इसरायलीमन मूसा ला देखिन, कि ओकर मुहूं ह चमकत हवय त ओमन ओकर करा आय बर डराईन। ");
INSERT INTO hne_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","पर मूसा ह ओमन ला बलाईस; अऊ हारून अऊ समाज के जम्मो अगुवामन ओकर करा आईन, अऊ मूसा ह ओमन ले गोठियाईस। ");
INSERT INTO hne_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ओकर बाद, जम्मो इसरायलीमन ला घलो तीर म बलाके मूसा ह ओमन ला ओ जम्मो हुकूम ला माने के हुकूम दीस, जऊन ला यहोवा ह सीनय पहाड़ म ओला कहे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","जब मूसा ह ओमन ले गोठिया लीस, त ओह अपन मुहूं म ओढ़ना ला डार लीस। ");
INSERT INTO hne_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","मूसा ह जब-जब यहोवा करा ओकर ले गोठियाय बर जावय, त ओह बाहिर निकलत ले ओढ़ना ला हटाय रहय; अऊ जब-जब ओह बाहिर म आके परमेसर के दिये गय हुकूम इसरायलीमन ला बतावय, ");
INSERT INTO hne_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","त इसरायलीमन मूसा के मुहूं ला देखंय कि ओकर मुहूं ह चमकत रहय, अऊ जब तक मूसा ह यहोवा ले गोठियाय बर भीतर नइं जावय तब तक ओह अपन मुहूं म ओढ़ना डारे रहय। ");
INSERT INTO hne_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मूसा ह जम्मो इसरायली समाज ला इकट्ठा करिस अऊ ओमन ला कहिस, “जऊन बुतामन ला यहोवा ह करे के हुकूम तुमन ला दे हवय, ओमन ये अंय: ");
INSERT INTO hne_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","हर हप्ता छै दिन बुता करहू अऊ सातवां दिन ह तुम्हर पबितर दिन, यहोवा बर एक बिसराम के दिन ठहिरय। ओ दिन जऊन कोनो कुछू बुता करय, ओला मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","बिसराम के दिन तुमन अपन-अपन निवास के ठऊर म आगी घलो झन बारव।” ");
INSERT INTO hne_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","फेर मूसा ह जम्मो इसरायली समाज ला कहिस, “जऊन हुकूम यहोवा ह दे हवय, ओह ये अय: ");
INSERT INTO hne_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","तुमन अपन करा ले यहोवा बर भेंट संकेलव; जऊन मन अपन ईछा ले देय बर चाहथंय, ओमन यहोवा बर ये चीजमन के भेंट लानंय: “सोन, चांदी अऊ कांसा; ");
INSERT INTO hne_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत अऊ सुघर मलमल के कपड़ा; बोकरा के रूआं; ");
INSERT INTO hne_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","लाल रंग ले रंगाय मेढ़ा के खाल अऊ आने किसम के टिकाऊ खाल; बंबरी के लकड़ी; ");
INSERT INTO hne_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","अंजोर करे बर जैतून तेल; अभिसेक के तेल अऊ कहरवाला धूप बर मसाला; ");
INSERT INTO hne_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","अऊ एपोद अऊ छातीबंध म जड़े बर गोमेदक के पथरा अऊ आने किसम के रत्न। ");
INSERT INTO hne_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“तुमन म जऊन मन कुसल कारीगर अंय, ओमन आवंय अऊ यहोवा के हुकूम के मुताबिक ये चीजमन ला बनावंय: ");
INSERT INTO hne_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“पबितर-तम्बू के संग ओकर तम्बू अऊ ओकर ओढ़ना, अऊ ओकर घुंडी, ढांचा, बल्ली, खंभा अऊ आधारमन; ");
INSERT INTO hne_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","सन्दूक अऊ ओकर डंडामन, पछताप के ढकना अऊ ओ परदा, जऊन ह ओला आड़ करथे; ");
INSERT INTO hne_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","मेज अऊ ओकर डंडा अऊ ओकर जम्मो सामान अऊ चघावा के रोटी; ");
INSERT INTO hne_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","अंजोर बर दीवट, अऊ ओकर जम्मो सामान, दीयामन अऊ अंजोर करे बर तेल; ");
INSERT INTO hne_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","डंडा समेत धूप के बेदी, अभिसेक के तेल, सुगंधित धूप, अऊ पबितर-तम्बू के प्रवेस दुवार बर परदा; ");
INSERT INTO hne_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होम-बलिदान के बेदी के संग ओकर कांसा के जाली, ओकर डंडा अऊ ओकर जम्मो बरतन, कांसा के तसला अऊ ओकर पाया; ");
INSERT INTO hne_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","अंगना के परदामन के संग ओकर खंभा अऊ आधारमन, अऊ अंगना के प्रवेस दुवार के परदा; ");
INSERT INTO hne_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","पबितर-तम्बू अऊ अंगना के खूंटीमन, अऊ ओमन के रस्सीमन; ");
INSERT INTO hne_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पबितर-स्थान म सेवा-टहल करे बर बुने गय पहिरावा—येमा हारून पुरोहित के पबितर पहिरावा अऊ ओकर बेटामन के पहिरावा रिहिस, जेला पुरोहित के रूप म सेवा करत बेरा ओमन पहिरंय।” ");
INSERT INTO hne_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","तब पूरा इसरायली समाज मूसा करा ले लहुंट गीस। ");
INSERT INTO hne_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","हर एक मनखे, जेमन के मन ह ओमन ला उत्साहित करिस अऊ हर एक मनखे जऊन मन के आतमा ह ओमन ला उभारिस, ओह मिलापवाला तम्बू के बुता अऊ ओकर जम्मो सेवा करे अऊ पबितर ओनहा ला बनाय बर अऊ यहोवा बर भेंट लेके आईन। ");
INSERT INTO hne_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","तब जम्मो मरद अऊ माईलोगनमन, जऊन मन के मन ह ओमन ला उत्साहित करे रिहिस, ओमन सोन के कान के बाली, नाक के नथनी, अंगठी के मुंदरी अऊ हांथ के कंगनी आदि जम्मो किसम के जेवर लानिन; ओ जम्मो झन हलाय-बलिदान के रूप म यहोवा ला अपन सोन के भेंट चघाईन। ");
INSERT INTO hne_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","अऊ हर ओ मनखे, जेकर करा नीला, बैंगनी अऊ सिन्दूरी रंग के ओनहा, सुघर मलमल अऊ छेरीमन के बाल अऊ लाल रंग ले रंगाय भेड़ के खाल अऊ आने टिकाऊ खाल रिहिस, ओह ओ चीजमन ला ले आईस। ");
INSERT INTO hne_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","जऊन मनखेमन चांदी या कांसा के भेंट लाने सकत रिहिन, ओमन यहोवा बर भेंट लानिन। अऊ जऊन मन करा सेवा करे के कोनो बुता बर बंबरी के लकड़ी रिहिस, ओमन ओला लानिन। ");
INSERT INTO hne_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","जतेक कुसल माईलोगनमन रिहिन, ओमन अपन हांथ ले रेसम के सूंत बनाईन अऊ ओमन नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत, अऊ महिन मलमल के बनाय गे सूंत ला लेके आईन। ");
INSERT INTO hne_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","अऊ जऊन माईलोगनमन के ईछा रिहिस अऊ सूंत कांते म कुसल रिहिन, ओमन छेरीमन के रूआं के घलो सूंत बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","अऊ मुखियामन एपोद अऊ सीनाबंध बर सुलेमानी मनि अऊ जड़े बर मनि लानिन। ");
INSERT INTO hne_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ओमन अंजोर करे बर अऊ अभिसेक के तेल बर अऊ सुगंधित धूप बर मसाला अऊ जैतून तेल लानिन। ");
INSERT INTO hne_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","जऊन बुतामन ला करे बर यहोवा ह मूसा ला हुकूम दे रिहिस, ओकर बर जम्मो इसरायली माईलोगन अऊ मरद, जेमन के हिरदय ह ओमन ला भेंट लाने बर उभारिस, यहोवा बर स्वेच्छा-बलिदान लेके आईन। ");
INSERT INTO hne_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","मूसा ह इसरायलीमन ला कहिस, “देखव, यहोवा ह यहूदा के गोत्र ले हूर के नाती, ऊरी के बेटा बसलेल ला चुने हवय, ");
INSERT INTO hne_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","अऊ ओह ओला परमेसर के आतमा, बुद्धि, समझ, गियान अऊ जम्मो किसम के हुनर ले भर दे हवय, ");
INSERT INTO hne_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ताकि ओह सोन, चांदी अऊ कांसा के कलात्मक काम, ");
INSERT INTO hne_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","पथरामन ला काटे अऊ मढ़ाय, लकड़ी के काम अऊ जम्मो किसम के कलात्मक सिल्पकारी के काम करय। ");
INSERT INTO hne_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","अऊ यहोवा ह ओकर संग दान के गोत्र ले अहीसामाक के बेटा ओहोलीआब ला घलो योग्यता दे हवय कि ओ दूनों झन आने मन ला सिखोवंय। ");
INSERT INTO hne_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ओमन के हिरदय ला यहोवा ह अइसन हुनर ले भरे हवय कि ओमन गढ़नेवाला अऊ कलात्मक नमूना बनानेवाला नीला, बैंगनी अऊ सिन्दूरी रंग के ओनहा म अऊ महिन मलमल के कढ़ई अऊ बुनई म जम्मो किसम के कलात्मक जिनिसमन के नमूना के काम अऊ कारीगरमन के जम्मो बुता करंय। ");
INSERT INTO hne_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","बसलेल, ओहोलीआब अऊ ओ जम्मो कुसल कारीगर, जेमन ला यहोवा ह हुनर अऊ योग्यता दे हवय कि ओ पबितर-स्थान ला बनाय के जम्मो काम ला कइसे करना हे, ओमन ये काम ला वइसने ही करंय, जइसने कि यहोवा ह हुकूम दे हवय।” ");
INSERT INTO hne_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","तब मूसा ह बसलेल, ओहोलीआब अऊ ओ जम्मो कुसल कारीगर, जेमन ला यहोवा ह योग्यता दे रिहिस अऊ जऊन मन अपन ईछा ले आके काम करे चाहत रिहिन, ओ जम्मो झन ला बुलवाईस। ");
INSERT INTO hne_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","अऊ मूसा ह ओमन ला ओ जम्मो भेंट के चीजमन ला दे दीस, जेला इसरायलीमन पबितर-स्थान ला बनाय के काम बर लाय रिहिन। अऊ मनखेमन रोज बिहनियां स्वेच्छा-बलिदान लाते रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","तब ओ जम्मो कारीगर, जेमन पबितर-स्थान ला बनाय के जम्मो काम ला करत रिहिन, ओमन अपन-अपन काम ला छोंड़ दीन, ");
INSERT INTO hne_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","अऊ आके मूसा ला कहिन, “मनखेमन जरूरत ले जादा चीज ओ काम ला करे बर लानत हें, जेला करे के हुकूम यहोवा ह दे हवय।” ");
INSERT INTO hne_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तब मूसा ह हुकूम दीस अऊ ये बात के घोसना पूरा सिविर म करे गीस: “कोनो भी मरद या माईलोगन अब पबितर-स्थान बर भेंट के रूप म कोनो चीज झन लानंय।” अऊ ये किसम ले मनखेमन ला अऊ भेंट लाने बर रोके गीस, ");
INSERT INTO hne_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","काबरकि जतेक चीज ओमन करा आय रिहिस, ओह जम्मो काम बर जरूरत ले घलो जादा रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","काम करइयामन के बीच म ले जम्मो कुसल कारीगरमन पबितर-तम्बू ला दस ठन परदा म ले बनाईन; ओमन ये परदामन ला सुघर बंटे मलमल अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत ले बनाईन अऊ कुसल कारीगरमन के दुवारा ये परदामन म कढ़ई करके करूबमन ला बनाय गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","जम्मो परदामन एकेच आकार के रिहिन—अठाईस क्यूबीट लम्बा अऊ चार क्यूबीट चौड़ा। ");
INSERT INTO hne_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ओमन पांच ठन परदा ला एक संग जोड़ दीन अऊ बांचे पांच ठन परदा ला घलो वइसने ही करिन। ");
INSERT INTO hne_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","तब ओमन पहिला समूह के आखिरी के परदा के धरी म नीला रंग के चीज के फांस लगाईन, अऊ वइसने ही दूसरा समूह के आखिरी के परदा म घलो करे गीस। ");
INSERT INTO hne_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ओमन एक समूह के आखिरी के परदा म पचास ठन फांस लगाईन अऊ दूसर समूह के आखिरी के परदा म घलो पचास ठन फांस लगाईन, अऊ ये फांसमन एक-दूसर के आमने-सामने रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","तब ओमन पचास ठन सोन के कड़ा बनाईन अऊ ओमन के उपयोग दूनों समूह के परदामन ला एक संग बांधके रखे बर करिन, जेकर ले पबितर-तम्बू ह एक ठन हो गीस। ");
INSERT INTO hne_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ओमन पबितर-तम्बू के ऊपर बोकरा के रूआं के परदा बनाईन—कुल गियारह ठन परदा बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","जम्मो गियारह परदामन एके नाप के रिहिन—तीस क्यूबीट लम्बा अऊ चार क्यूबीट चौड़ा। ");
INSERT INTO hne_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ओमन पांच ठन परदा ला जोड़के एक ठन बना दीन अऊ आने छै ठन परदा ला घलो जोड़के एक ठन कर दीन। ");
INSERT INTO hne_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","तब ओमन पहिली समूह के आखिरी परदा के धरी म पचास ठन फांस लगाईन अऊ वइसने ही दूसर समूह के आखिरी परदा म घलो पचास ठन फांस लगाईन। ");
INSERT INTO hne_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ओमन परदामन ला जोड़े बर कांसा के पचास ठन कड़ा बनाईन ताकि ओ पूरा तम्बू मिलके एके ठन हो जावय। ");
INSERT INTO hne_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","तब ओमन तम्बू बर लाल रंग ले रंगाय मेढ़ा के खाल के एक ठन ओढ़ना बनाईन अऊ ओकर ऊपर लगाय बर आने टिकाऊ खाल के एक ठन ओढ़ना बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ओमन पबितर-तम्बू बर बंबरी लकड़ी के खड़े ढांचामन ला बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","हर एक ढांचा दस क्यूबीट लम्बा अऊ डेड़ क्यूबीट चौड़ा रिहिस, ");
INSERT INTO hne_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","अऊ ओमा एक-दूसर के समानांतर दू-दू ठन खूंटी रिहिन। ओमन पबितर-तम्बू के जम्मो ढांचामन ला इही किसम ले बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ओमन पबितर-तम्बू के दक्खिन कोति बर बीस ठन ढांचा बनाईन ");
INSERT INTO hne_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","अऊ ओ ढांचामन के खाल्हे म रखे बर चांदी के चालीस ठन आधार बनाईन—हर एक ढांचा बर दू ठन आधार, हर एक खूंटी के खाल्हे म एक ठन आधार। ");
INSERT INTO hne_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","दूसर कोति याने कि पबितर-तम्बू के उत्तर दिग बर ओमन बीस ठन ढांचा ");
INSERT INTO hne_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","अऊ चालीस ठन चांदी के आधार बनाईन—हर एक ढांचा के खाल्हे म दू ठन आधार। ");
INSERT INTO hne_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ओमन आखिरी छोर याने कि पबितर-तम्बू के पछिम छोर बर छै ठन ढांचा बनाईन ");
INSERT INTO hne_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","अऊ पबितर-तम्बू के कोनटामन बर आखिरी छोर म दू ठन ढांचा बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ये दूनों कोनटा म ढांचामन खाल्हे ले लेके टीप तक दू परत म रिहिन अऊ एके ठन कड़ा म जुड़े रिहिन; दूनों एक जइसे बने रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ये किसम ले आठ ठन ढांचा अऊ चांदी के सोलह ठन आधार रिहिस याने कि हर ढांचा के खाल्हे म दू ठन आधार। ");
INSERT INTO hne_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ओमन बंबरी लकड़ी के मियारमन ला घलो बनाईन: पबितर-तम्बू के एक तरफ के ढांचामन बर पांच ठन मियार, ");
INSERT INTO hne_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","पबितर-तम्बू के दूसर तरफ बर पांच ठन मियार अऊ पबितर-तम्बू के आखिरी छोर म, पछिम तरफ के ढांचामन बर पांच ठन मियार बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ओमन मांझा के मियार ला अइसने बनाईन कि ओह ढांचामन के बीच म ले होके एक छोर ले दूसर छोर तक पहुंचय। ");
INSERT INTO hne_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ओमन ढांचामन ला सोन ले मढ़िन अऊ मियारमन ला पकड़े बर सोन के कड़ा बनाईन। ओमन मियारमन ला घलो सोन ले मढ़िन। ");
INSERT INTO hne_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ओमन नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत अऊ सुघर बंटे मलमल ले परदा बनाईन, जऊन म एक कुसल कारीगर के दुवारा करूबमन के कढ़ई करे गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ओमन येकर बर बंबरी लकड़ी के चार ठन खंभा बनाईन अऊ ओमन ला सोन ले मढ़िन। ओमन बर सोन के खूंटीमन ला बनाईन अऊ ओमन बर चांदी के चार ठन आधार ढालके बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","तम्बू के प्रवेस दुवार बर ओमन नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत अऊ सुघर बंटे मलमल के ओनहा ले एक ठन परदा बनाईन—येला एक कढ़ई करइया ह बनाईस; ");
INSERT INTO hne_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","अऊ ओमन पांच ठन खंभा बनाईन अऊ ओमन बर खूंटी घलो बनाईन। ओमन खंभामन के टीप अऊ ओमन के पट्टामन ला सोन ले मढ़िन अऊ ओमन के पांचों आधार ला कांसा के बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बसलेल ह बंबरी लकड़ी ले सन्दूक ला बनाईस—जऊन ह अढ़ई क्यूबीट लम्बा अऊ डेड़ क्यूबीट चौड़ा, अऊ डेड़ क्यूबीट ऊंचा रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ओह ओला भीतर-बाहिर दूनों कोति चोखा सोन ले मढ़िस, अऊ ओकर चारों कोति सोन के एक पट्टी लगाईस। ");
INSERT INTO hne_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ओह सन्दूक बर चार ठन सोन के कड़ा बनवाके ओमन ला ओकर चारों खुरा म बांध दीस—एक तरफ दू ठन अऊ दूसर तरफ दू ठन। ");
INSERT INTO hne_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","तब ओह डंडामन ला बंबरी लकड़ी के बनाईस अऊ ओमन ला सोन ले मढ़िस। ");
INSERT INTO hne_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","अऊ ओह करार के सन्दूक ला उठाके ले जाय बर डंडामन ला सन्दूक के दूनों कोति कड़ामन म डालिस। ");
INSERT INTO hne_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","फेर बसलेल ह चोखा सोन ले पछताप के ढकना ला बनाईस—जऊन ह अढ़ई क्यूबीट लम्बा अऊ डेड़ क्यूबीट चौड़ा रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","तब ओह ढकना के दूनों छोर बर हथौड़ा ले पीटके सोन के दू ठन करूब बनाईस। ");
INSERT INTO hne_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ओह एक ठन करूब ला एक छोर म अऊ दूसरा करूब ला दूसर छोर म बनाईस; दूनों छोर म करूबमन अऊ ढकना ला सोन के एके कुटा ले बनाईस। ");
INSERT INTO hne_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","करूबमन के डेनामन ऊपर कोति फईले रहंय, अऊ पछताप के ढकना ह ओमन ले ढंकाय रहय। करूबमन के मुहूं ह एक-दूसर के आमने-सामने रहय अऊ ओमन ढकना कोति देखत रहंय। ");
INSERT INTO hne_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ओमन बंबरी लकड़ी के एक ठन मेज बनाईन—जऊन ह दू क्यूबीट लम्बा, एक क्यूबीट चौड़ा अऊ डेड़ क्यूबीट ऊंचा रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","तब ओमन ओला चोखा सोन ले मढ़िन अऊ ओकर चारों मुड़ा सोन के एक पट्टी लगाईन। ");
INSERT INTO hne_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ओमन ओकर चारों कोति हथेली भर चौड़ा एक ठन चक्र बनाईन अऊ ओ चक्र म सोन के एक ठन पट्टी लगाईन। ");
INSERT INTO hne_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ओमन मेज बर सोन के चार ठन कड़ा बनाईन अऊ ओमन ला ओ चारों कोना म बांध दीन, जिहां चारों खुरामन रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ये कड़ामन पट्टी के लकठा म लगाय गे रिहिन, ताकि ओमा ओ डंडामन ला फंसाय जा सकय, जेमन के उपयोग मेज ला उठाके ले जाय बर होथे। ");
INSERT INTO hne_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","मेज ला उठाके ले जाय के डंडामन बंबरी लकड़ी के बने रिहिन अऊ ओमन ला सोन ले मढ़े गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","मेज ऊपर रखे जाय के सामान ला ओमन चोखा सोन के बनाईन—याने कि येकर थाली, बरतन, कटोरा अऊ पेय-बलिदान ला रितोय बर येकर घघरीमन ला। ");
INSERT INTO hne_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ओमन चोखा सोन के दीवट बनाईन। ओमन ओकर आधार अऊ मुठिया ला हथौड़ा ले पीटके बनाईन, अऊ ओकर फूल सहीं दिखइया कटोरा, कली अऊ पंखुड़ीमन ला एके ठन कुटा म बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","दीवट के किनारे ले छै ठन डारामन निकले रहंय—तीन ठन डारा एक कोति अऊ तीन ठन दूसर कोति। ");
INSERT INTO hne_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","हर एक डारा म बादाम के फूल सहीं तीन ठन कटोरी, कली अऊ पंखुड़ीमन रिहिन, तीन ठन ओकर बाद वाले डारा म, अऊ अइसनेच दीवट ले निकले जम्मो छै ठन डारा रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","अऊ दीवट म बादाम के फूल सहीं चार ठन कटोरी बने रिहिन अऊ ओमा कली अऊ पंखुड़ीमन रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","दीवट ले निकले छै ठन डारा म ले एक-एक जोड़ी डारा के तरी म एक-एक ठन कली रिहिस—ये किसम ले कुल तीन ठन कली छै ठन डारा के तरी म रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","कली अऊ डारामन ला दीवट के संग एके कुटा म बनाय गे रिहिस, अऊ चोखा सोन ला पीटके येमन ला बनाय गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ओमन येकर सात ठन दीया अऊ संग म ओकर बाती के कतरनी अऊ थालीमन ला चोखा सोन के बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ओमन दीवट अऊ येकर जम्मो चीजमन ला एक टेलेन्ट चोखा सोन ले बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ओमन बंबरी लकड़ी ले धूप के बेदी बनाईन। येह वर्गाकार रिहिस, एक क्यूबीट लम्बा, एक क्यूबीट चौड़ा अऊ दू क्यूबीट ऊंचा—अऊ ओकर सींगमन ओ बेदी संग एके कुटा ले बने रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ओमन बेदी के ऊपर अऊ जम्मो किनारा अऊ सींगमन ला चोखा सोन ले मढ़िन, अऊ येकर चारों कोति सोन के एक किनारी बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ओमन किनारी के खाल्हे म दू ठन कड़ा बनाईन—दू-दू ठन एक-दूसर के आमने-सामने, ताकि येमा डंडामन ला घुसावंय अऊ उठाके ले जा सकंय। ");
INSERT INTO hne_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ओमन डंडामन ला बंबरी लकड़ी ले बनाईन अऊ ओमन ला सोन ले मढ़िन। ");
INSERT INTO hne_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ओमन पबितर अभिसेक के तेल अऊ सुध, खुसबूवाला धूप घलो बनाईन। येह अंतर तेल बनानेवाला के काम रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","फेर ओमन बंबरी लकड़ी ले होम-बलिदान के बेदी ला बनाईन, जेकर ऊंचई तीन क्यूबीट रिहिस; अऊ येह वर्गाकार रिहिस—पांच क्यूबीट लम्बा अऊ पांच क्यूबीट चौड़ा। ");
INSERT INTO hne_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ओमन चारों कोनटा म एक-एक ठन सींग बनाईन, अऊ ये सींग अऊ बेदी एके कुटा म बने रिहिन, अऊ ओमन बेदी ला कांसा ले मढ़िन। ");
INSERT INTO hne_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ओमन येकर जम्मो बरतन ला कांसा के बनाईन—बरतन, बेलचा, छिंचे के कटोरा, मांस बर कांटा अऊ आगी हेरे बर करछूल। ");
INSERT INTO hne_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","बेदी बर, ओकर चारों कोति के कंगनी के खाल्हे, ओमन कांसा के जाली के एक छननी बनाईन, जऊन ह बेदी के आधा ऊंचई तक लगे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ओमन कांसा के छननी के चारों कोना म चार ठन कड़ा लगाईन, ताकि येमा डंडामन ला फंसाय जा सकय। ");
INSERT INTO hne_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ओमन बंबरी लकड़ी के डंडा बनाईन अऊ ओ डंडामन म कांसा मढ़िन। ");
INSERT INTO hne_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ओमन डंडामन ला कड़ा म घुसाईन, ताकि बेदी ला उठाके ले जाय बर येमन बाजू ले निकले रहंय। बेदी ह भीतर ले खोखला रिहिस अऊ येह तखतामन ले बने रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ओमन तसला अऊ ओकर पाया ला कांसा के बनाईन अऊ येमन ला ओ माईलोगन के दरपनमन ले बनाय गीस, जऊन मन मिलापवाला तम्बू के प्रवेस दुवार करा सेवा करंय। ");
INSERT INTO hne_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ओकर बाद ओमन अंगना ला बनाईन। दक्खिन कोति अंगना ह एक सौ क्यूबीट लम्बा रिहिस अऊ ओमा सुघर बंटाय मलमल के परदा रिहिस, ");
INSERT INTO hne_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","येकर बीस ठन खंभा अऊ बीस ठन कांसा के आधारमन रिहिन, अऊ खंभामन म चांदी के कांटा अऊ पट्टीमन लगे रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","उत्तर कोति घलो अंगना ह एक सौ क्यूबीट लम्बा रिहिस अऊ येकर बर बीस ठन खंभा अऊ बीस ठन कांसा के आधारमन रिहिन; खंभामन के हुक अऊ पट्टीमन चांदी के रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","अंगना के पछिमी छोर ह पचास क्यूबीट चौड़ा रिहिस अऊ ओती के परदा म दस ठन खंभा अऊ दस ठन आधार रिहिन अऊ खंभामन म फंसाय के चांदी के कांटा अऊ पट्टी लगे रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","पूरबी छोर म, सूरज निकले कोति घलो अंगना ह पचास क्यूबीट चौड़ा रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","प्रवेस दुवार के एक तरफ परदा के लम्बई पंदरह क्यूबीट रिहिस अऊ ओकर बर तीन ठन खंभा अऊ तीन ठन आधार बनाय गे रिहिस, ");
INSERT INTO hne_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","अऊ अंगना के प्रवेस दुवार के दूसर तरफ घलो पंदरह क्यूबीट लम्बा परदा रिहिस, जेकर बर तीन ठन खंभा अऊ तीन ठन आधार बनाय गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","अंगना के चारों कोति के परदामन सुघर बंटाय मलमल के बने रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","खंभामन के आधारमन कांसा के रिहिन। खंभा म फंसाय के कांटा अऊ पट्टीमन चांदी के रिहिन, अऊ ओमन के ऊपर के भाग ला चांदी ले मढ़े गे रिहिस; ये किसम ले अंगना के जम्मो खंभा म चांदी के पट्टी रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","अंगना के प्रवेस दुवार के परदा ह नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत अऊ सुघर बंटे मलमल के कपड़ा ले बने रिहिस—येह कढ़ई करनेवाला के काम रिहिस। येह बीस क्यूबीट लम्बा अऊ अंगना के परदामन सहीं पांच क्यूबीट ऊंच रिहिस; ");
INSERT INTO hne_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","येमा चार ठन खंभा अऊ कांसा के चार ठन आधार रिहिन। ओमन के फंसाय के कांटा अऊ पट्टामन चांदी के रिहिन, अऊ ओमन के ऊपर के भागमन चांदी ले मढ़े रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","पबितर-तम्बू के जम्मो खूंटी अऊ अंगना के चारों कोति के खूंटीमन कांसा के रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","मूसा के हुकूम ले पबितर-तम्बू, करार के कानून के पबितर-तम्बू बर उपयोग म लाय गय सामान के मात्रा ला लिखे गीस अऊ येला हारून पुरोहित के बेटा ईतामार के निरदेस म लेवीमन लिखिन। ");
INSERT INTO hne_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(जऊन चीजमन ला बनाय के हुकूम यहोवा ह मूसा ला देय रिहिस, ओ जम्मो चीज ला यहूदा के बंस के बसलेल ह बनाईस, जऊन ह ऊरी के बेटा अऊ हूर के पोता रिहिस; ");
INSERT INTO hne_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","अऊ ओकर संग दान के बंस के अहीसामाक के बेटा ओहोलीआब रिहिस, जऊन ह एक नक्कासी करनेवाला, सिल्पकार अऊ नीला, बैंगनी अऊ सिन्दूरी सूंत अऊ उत्तम मलमल के कपड़ा म कढ़ई के काम करे म माहिर रिहिस।) ");
INSERT INTO hne_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पबितर-स्थान म जम्मो काम म उपयोग करे बर जऊन सोन हलाय-बलिदान म चघाय गे रिहिस, ओकर मात्रा पबितर-स्थान के सेकेल के मुताबिक 29 टेलेन्ट अऊ 730 सेकेल रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","समाज के मनखेमन ले जऊन चांदी मिले रिहिस, ओकर गनती पबितर-स्थान के सेकेल के मुताबिक 100 टेलेन्ट अऊ 1,775 सेकेल रिहिस— ");
INSERT INTO hne_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","जऊन इसरायलीमन बीस साल ले जादा उमर के रिहिन, ओमन के संखिया 6,03,550 रिहिस, अऊ ओमा के हर एक जन पबितर-स्थान के सेकेल के मुताबिक आधा सेकेल याने कि एक बेका दीन। ");
INSERT INTO hne_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","पबितर-स्थान के आधार अऊ परदा बर चांदी के 100 टेलेन्ट उपयोग होय रिहिस—100 ठन आधार 100 टेलेन्ट ले बनिस, एक ठन आधार बर एक टेलेन्ट लगिस। ");
INSERT INTO hne_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","जऊन 1,775 सेकेल चांदी बच गीस, ओकर ले खंभामन बर फंसाय के कांटा बनाईन अऊ खंभामन के ऊपरी भाग ला मढ़िन अऊ ओमन के पट्टी घलो बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","हलाय-बलिदान म चघाय गे कांसा लगभग 70 टेलेन्ट अऊ 2,400 सेकेल रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ओमन ओकर ले मिलापवाला तम्बू के प्रवेस दुवार बर आधार, कांसा के बेदी अऊ ओकर कांसा के जाली अऊ बेदी के जम्मो बरतन, ");
INSERT INTO hne_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","अंगना के चारों कोति के आधार अऊ ओकर प्रवेस दुवार के आधार अऊ पबितर-तम्बू के जम्मो खीला अऊ अंगना के चारों कोति के खीलामन ला बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ओमन पबितर-स्थान म सेवा करइयामन बर नीला, बैंगनी, अऊ सिन्दूरी रंग के सूंत ले बुने पहिरावा बनाईन। जइसे यहोवा ह मूसा ला हुकूम दे रिहिस, ओकर मुताबिक ओमन हारून बर घलो पबितर पहिरावा बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ओमन सोन अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत, अऊ सुघर बंटाय मलमल के कपड़ा ले एपोद बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ओमन सोन के पातर चद्दर ला पीटके काटिन अऊ ओकर तार बनाईन, ताकि येला नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत अऊ सुघर मलमल के कपड़ा म बुने जा सकय—येह कुसल कारीगर के दुवारा बनाय गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ओमन एपोद बर कंधा के टुकड़ामन ला बनाईन, जेमन येकर दू ठन कोना म जुड़े रहंय, ताकि येला बांधे जा सकय। ");
INSERT INTO hne_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","येकर कुसलता से बुने गय कमरबंध ला एपोद के संग एके टुकड़ा म बनाय गे रिहिस अऊ येह सोन, अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत, अऊ सुघर बंटाय मलमल के सूंत ले बने रिहिस, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ओमन गोमेदक के रत्नमन ला सोन के जरी म जड़िन अऊ ओमा इसरायल के बेटामन के नांव मुहर सहीं खोदके लगा दीन। ");
INSERT INTO hne_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","तब ओमन, ओमन ला इसरायल के बेटामन बर यादगार पथरा के रूप म एपोद के कंधावाले टुकड़ा म बांध दीन, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ओमन छातीबंध ला बनाईन—येह एक कुसल कारीगर के काम रिहिस। ओमन येला एपोद के सहीं सोन, अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत, अऊ सुघर बंटे मलमल के बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","येह चौकोर रिहिस—एक स्पान लम्बा अऊ एक स्पान चौड़ा—अऊ दू बार मुड़े रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","तब ओमन येमा चार ठन कतार म कीमती पथरा लगाईन। पहिली कतार म मानिक, पुखराज अऊ पन्ना लगाईन; ");
INSERT INTO hne_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दूसर कतार म मरकत, नीलमनि हीरा अऊ पन्ना लगाईन; ");
INSERT INTO hne_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तीसर कतार म नारंगी रंग के लसम, सूर्यकांत अऊ नीलम; ");
INSERT INTO hne_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","अऊ चौथा कतार म फिरोजा, गोमेदक अऊ यसब लगाईन; येमन ला जरी के काम करे गे सोन म जड़िन। ");
INSERT INTO hne_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","उहां बारह ठन पथरा रिहिन; याने कि इसरायल के बेटामन के हर एक नांव बर एक-एक ठन पथरा रिहिस; हर एक म इसरायल के बारह गोत्र के एक-एक नांव ला मुहर के सहीं खोदे गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","छातीबंध म, ओमन डोरी के सहीं चोखा सोन के गुंथे गय जंजीर बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ओमन सोन के काम करे दू ठन जाली अऊ दू ठन सोन के छल्ला बनाईन, अऊ ओ छल्लामन ला छातीबंध के दूनों कोनटा म बांध दीन। ");
INSERT INTO hne_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ओमन सोन के दूनों जंजीर ला छातीबंध के कोनटामन म ओ छल्लामन के संग बांध दीन, ");
INSERT INTO hne_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","अऊ जंजीरमन के दूसर छोरमन ला दूनों खानामन म बांध दीन, अऊ येमन सामने म एपोद के कंधावाले टुकड़ा म जुड़े रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ओमन सोन के दू ठन छल्ला बनाके ओमन ला छातीबंध के आने दूनों कोनटा के भीतरी किनारा म एपोद ले संटके लगाईन। ");
INSERT INTO hne_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","तब ओमन सोन के अऊ दू ठन छल्ला बनाईन अऊ ओमन ला एपोद के सामने म कंधा के टुकड़ामन के खाल्हे म जोड़िन; येमन एपोद के कमरबंध के ऊपर जोड़ के लकठा म रिहिन। ");
INSERT INTO hne_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ओमन छातीबंध के छल्लामन ला एपोद के छल्लामन ले बांध दीन अऊ येला कमरबंध ले जोड़त नीला डोरी ले बांधे गीस, ताकि छातीबंध ह एपोद के बाहिर झन ओरमय। ये जम्मो काम यहोवा के दुवारा मूसा ला दिये गय हुकूम के मुताबिक करे गीस। ");
INSERT INTO hne_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ओमन एपोद के खाल्हे के लबादा ला पूरा नीला रंग के कपड़ा ले बनाईन—येह एक बुनकर के काम रिहिस— ");
INSERT INTO hne_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","गला के पट्टी के छेदा सहीं, ये कपड़ा के बीच म एक छेदा रहय, अऊ ये छेदा के चारों कोति एक पट्टी लगे रहय, ताकि येह झन चिरावय। ");
INSERT INTO hne_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ओमन ये कपड़ा के खाल्हे के घेरा के चारों कोति नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत अऊ सुघर बंटाय मलमल के सूंत ले अनार बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","अऊ ओमन चोखा सोन के घंटीमन ला बनाईन अऊ ओमन ला खाल्हे के घेरा के चारों कोति अनारमन के बीच म जोड़ दीन। ");
INSERT INTO hne_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","लबादा के खाल्हे के घेरा के चारों कोति घंटी अऊ अनारमन ला एक के बाद एक बनाय गे रिहिस ताकि येला पहिरके सेवा के काम करंय, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","हारून अऊ ओकर बेटामन बर, ओमन सुघर मलमल के कुरता बनाईन; येह एक बुनकर के काम रिहिस— ");
INSERT INTO hne_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","अऊ सुघर मलमल के पागा, मलमल के टोपी अऊ महिन बराय मलमल के कच्छा बनाईन। ");
INSERT INTO hne_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","पटका ह महिन बराय मलमल अऊ नीला, बैंगनी अऊ सिन्दूरी रंग के सूंत ले बने रिहिस—येह एक कढ़ई करनेवाला के काम रिहिस—जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ओमन तस्तरी, पबितर प्रतीक ला चोखा सोन के बनाईन अऊ मुहर म खोदे लिखावट सहीं येमा खोदके ये लिखिन: यहोवा बर पबितर। ");
INSERT INTO hne_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","तब ओमन पागा म जोड़े बर ओमा एक ठन नीला डोरी बांधिन, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ये किसम ले पबितर-तम्बू, मिलापवाला तम्बू के जम्मो काम पूरा होईस। इसरायलीमन ओ जम्मो काम करिन, जेला करे बर यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","तब ओमन पबितर-तम्बू ला मूसा करा लानिन: तम्बू अऊ येकर सामान, येला जकड़के रखइया सामान, ढांचा, बल्ली, खंभा अऊ आधारमन; ");
INSERT INTO hne_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","लाल रंग ले रंगाय मेढ़ा के खाल के ओढ़ना अऊ आने टिकाऊ खाल के ओढ़ना अऊ आड़ करइया परदा; ");
INSERT INTO hne_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","करार कानून के सन्दूक के संग येकर डंडामन अऊ पछताप के ढकना; ");
INSERT INTO hne_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","मेज के संग येकर जम्मो सामान अऊ चघावा के रोटी; ");
INSERT INTO hne_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","चोखा सोन के दीवट के संग येकर दीयामन के कतार अऊ येकर जम्मो सामान, अऊ अंजोर करे बर जैतून तेल; ");
INSERT INTO hne_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सोन के बेदी, अभिसेक के तेल, सुगंधित धूप, अऊ तम्बू के प्रवेस दुवार बर परदा; ");
INSERT INTO hne_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","कांसा के बेदी के संग येकर कांसा के जाली, येकर डंडा अऊ येकर जम्मो बरतन; तसला अऊ येकर पाया; ");
INSERT INTO hne_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","अंगना के परदामन के संग ओकर खंभा अऊ आधारमन, अऊ अंगना के प्रवेस दुवार के परदा; रस्सी अऊ अंगना बर तम्बू के खूंटीमन; पबितर-तम्बू, मिलापवाला तम्बू बर जम्मो सामान; ");
INSERT INTO hne_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","अऊ पबितर-स्थान म सेवा-टहल करे बर बुने गय पहिरावा, येमा हारून पुरोहित के पबितर पहिरावा अऊ ओकर बेटामन के पहिरावा रिहिस, जेला पुरोहित के रूप म सेवा करत बेरा ओमन ला पहिरना रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","यहोवा ह जइसे हुकूम मूसा ला दे रिहिस, ओकर मुताबिक ही इसरायलीमन जम्मो काम ला करिन। ");
INSERT INTO hne_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मूसा ह ओ जम्मो काम के जांच करिस अऊ देखिस कि ओमन बिलकुल वइसे ही करे रिहिन, जइसे यहोवा ह हुकूम दे रिहिस। तब मूसा ह ओमन ला आसीस दीस। ");
INSERT INTO hne_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","तब यहोवा ह मूसा ला कहिस: ");
INSERT INTO hne_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पहिला महिना के पहिला दिन पबितर-तम्बू याने कि मिलापवाला तम्बू ला ठाढ़ कर। ");
INSERT INTO hne_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ओमा करार कानून के सन्दूक ला रख दे अऊ सन्दूक ला परदा के ओधा म कर दे। ");
INSERT INTO hne_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","मेज ला भीतर ले आ अऊ ओकर सामान ला सजा दे। तब दीवट ला लान अऊ येकर दीयामन ला बार दे। ");
INSERT INTO hne_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","धूपवाला सोन के बेदी ला करार कानून के सन्दूक के आघू म रख अऊ पबितर-तम्बू के प्रवेस दुवार करा परदा ला लगा दे। ");
INSERT INTO hne_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“पबितर-तम्बू, मिलापवाला तम्बू के प्रवेस दुवार के आघू म होम-बलिदान के बेदी ला रख; ");
INSERT INTO hne_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","मिलापवाला तम्बू अऊ बेदी के बीच म तसला ला रख अऊ ओमा पानी भर दे। ");
INSERT INTO hne_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","येकर चारों कोति अंगना ला स्थापित कर अऊ अंगना के प्रवेस दुवार म परदा लगा दे। ");
INSERT INTO hne_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“फेर अभिसेक करे के तेल ला लेके पबितर-तम्बू अऊ येमा के हर एक चीज ला अभिसेक कर; पबितर कर अऊ येकर जम्मो सामान अऊ येह पबितर हो जाही। ");
INSERT INTO hne_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","तब होम-बलिदान के बेदी अऊ येकर जम्मो बरतन ला अभिसेक कर; बेदी ला पबितर कर, अऊ येह महा पबितर हो जाही। ");
INSERT INTO hne_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","तसला अऊ येकर पाया ला अभिसेक कर अऊ ओमन ला पबितर कर। ");
INSERT INTO hne_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“हारून अऊ ओकर बेटामन ला मिलापवाला तम्बू के प्रवेस दुवार म लान अऊ ओमन ला पानी ले नहवा। ");
INSERT INTO hne_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","तब हारून ला पबितर पहिरावा ला पहिरा, ओकर अभिसेक कर अऊ ओला पबितर कर, ताकि ओह पुरोहित के रूप म मोर सेवा करे। ");
INSERT INTO hne_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","फेर ओकर बेटामन ला लानके ओमन ला कुरता पहिरा। ");
INSERT INTO hne_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","अऊ ओमन के अभिसेक घलो वइसे ही कर, जइसे ओमन के ददा के करे रहय, ताकि ओमन पुरोहित के रूप म मोर सेवा करंय। ओमन के अभिसेक ह एक पुरोहित के पद बर होही, जऊन ह ओमन के पीढ़ी-पीढ़ी तक चलही।” ");
INSERT INTO hne_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मूसा ह ओ जम्मो काम वइसने ही करिस, जइसने यहोवा ह ओला करे के हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ये किसम ले, मिसर ला छोंड़े के दूसरा साल के पहिला महिना के पहिला दिन पबितर-तम्बू ला स्थापित करे गीस। ");
INSERT INTO hne_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","जब मूसा ह पबितर-तम्बू ला स्थापित करिस, त ओह आधारमन ला जगह म रखिस, ढांचामन ला खड़े करिस, छड़मन ला बईठाईस अऊ खंभामन ला खड़े करिस। ");
INSERT INTO hne_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","तब ओह पबितर-तम्बू के ऊपर तम्बू ला फईलाईस अऊ तम्बू के ऊपर ओढ़ना ला लगाईस, जइसे कि यहोवा ह ओला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ओह करार कानून के पटियामन ला लीस अऊ ओमन ला सन्दूक म रखिस, अऊ सन्दूक म डंडामन ला लगाके ओकर ऊपर पछताप के ढकना ला धर दीस। ");
INSERT INTO hne_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","तब ओह पबितर-तम्बू म सन्दूक ला लानिस अऊ ओधा करइया परदा ला टांग दीस अऊ करार कानून के सन्दूक ला आड़ करिस, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","मूसा ह मेज ला मिलापवाला तम्बू म परदा के बाहिर पबितर-तम्बू के उत्तर दिग म रखिस ");
INSERT INTO hne_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","अऊ रोटी ला ओकर ऊपर यहोवा के आघू म सजाके रखिस, जइसे कि यहोवा ह ओला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ओह दीवट ला मिलापवाला तम्बू म मेज के सामने पबितर-तम्बू के दक्खिन कोति रखिस ");
INSERT INTO hne_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","अऊ यहोवा के आघू म दीयामन ला बार दीस, जइसे कि यहोवा ह ओला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","मूसा ह सोन के बेदी ला मिलापवाला तम्बू म परदा के सामने म रखिस ");
INSERT INTO hne_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","अऊ खुसबूवाला धूप ला ओमा जलाईस, जइसे कि यहोवा ह ओला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","तब ओह परदा ला पबितर-तम्बू के प्रवेस दुवार म लगाईस। ");
INSERT INTO hne_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ओह होम-बलिदान के बेदी ला पबितर-तम्बू, मिलापवाला तम्बू के प्रवेस दुवार के लकठा म रखिस, अऊ ओमा होम-बलिदान अऊ अन्न-बलिदान चघाईस, जइसे कि यहोवा ह ओला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ओह तसला ला मिलापवाला तम्बू अऊ बेदी के बीच म रखिस अऊ धोये बर ओमा पानी भर दीस, ");
INSERT INTO hne_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","अऊ मूसा अऊ हारून अऊ ओकर बेटामन अपन हांथ अऊ गोड़ ला धोये बर ओकर उपयोग करंय। ");
INSERT INTO hne_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","जब भी ओमन मिलापवाला तम्बू म या बेदी करा जावंय, तब ओमन अपन हांथ-गोड़ ला धोके जावंय, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","तब मूसा ह पबितर-तम्बू अऊ बेदी के चारों कोति अंगना ला लगाईस अऊ अंगना के प्रवेस दुवार करा परदा लगाईस। अऊ ये किसम ले मूसा ह काम ला पूरा करिस। ");
INSERT INTO hne_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","तब बादर ह मिलापवाला तम्बू ला ढंक लीस, अऊ यहोवा के महिमा ह पबितर-तम्बू म भर गीस। ");
INSERT INTO hne_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","मूसा ह मिलापवाला तम्बू के भीतर जा नइं सकिस काबरकि बादर ह येकर ऊपर छाय रिहिस, अऊ यहोवा के महिमा ले पबितर-तम्बू ह भर गीस। ");
INSERT INTO hne_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","इसरायलीमन के पूरा यातरा म जब भी बादर ह पबितर-तम्बू के ऊपर ले उठ जावय, तब ओमन आघू बढ़ंय; ");
INSERT INTO hne_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","पर यदि बादर ह पबितर-तम्बू के ऊपर ले नइं उठय, त ओमन ओ जगह ला तब तक नइं छोंड़ंय, जब तक कि बादर ह उठ नइं जावय। ");
INSERT INTO hne_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ये किसम ले इसरायलीमन के पूरा यातरा के बेरा ओ जम्मो के नजर म यहोवा के बादर ह दिन के बेरा पबितर-तम्बू के ऊपर, अऊ रथिया के बेरा ओ बादर म आगी दिखय।");
INSERT INTO hne_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","यहोवा ह मूसा ला बलाईस अऊ मिलापवाला तम्बू ले ओला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“इसरायलीमन ले गोठिया अऊ ओमन ला ये कह: ‘जब तुमन म ले कोनो मनखे यहोवा बर कोनो बलिदान चघाय बर लानथे, त ओह बलिदान के रूप म कोनो पसु ला, गाय-बईला या भेड़-बकरी के झुंड म ले लेके आवय। ");
INSERT INTO hne_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘कहूं बलिदान ह गाय-बईला के झुंड म ले होम-बलिदान ए, त तें निरदोस नर पसु ला बलिदान करबे। ये बलिदान ह मिलापवाला तम्बू के प्रवेस दुवार म चघाय जावय, ताकि यहोवा ह येला गरहन करय। ");
INSERT INTO hne_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","तें अपन हांथ ओ होम-बलिदान के पसु के मुड़ ऊपर रखबे, त ये बलिदान ह तोर कोति ले तोर पछतावा के रूप म गरहन करे जाही। ");
INSERT INTO hne_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","तेंह यहोवा के आघू म बछवा ला बलि करबे, अऊ तब हारून के बेटामन, जऊन मन पुरोहित अंय, ओकर लहू ला लानहीं अऊ ओ बेदी के चारों कोति छिंचहीं, जऊन ह मिलापवाला तम्बू के प्रवेस दुवार म हवय। ");
INSERT INTO hne_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","तब तें होम-बलिदान करे गे ओ पसु के चमड़ी ला निकाल देबे अऊ ओ पसु के कुटा-कुटा कर देबे। ");
INSERT INTO hne_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","हारून पुरोहित के बेटामन बेदी म आगी जलाहीं अऊ आगी ऊपर लकरी ला रचहीं। ");
INSERT INTO hne_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","तब हारून के ओ बेटामन, जऊन मन पुरोहित अंय, ओ पसु के कुटामन ला मुड़ अऊ चरबी समेत बेदी ऊपर बरत लकरी म रखहीं। ");
INSERT INTO hne_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","तेंह ओ पसु के पेट भीतर के चीजमन ला अऊ गोड़मन ला पानी म धो डारबे, अऊ पुरोहित ह ये जम्मो ला बेदी म जला देवय। येह यहोवा बर एक महकत सुख-देवइया, एक होम-बलिदान, अऊ एक जेवन-बलिदान होही। ");
INSERT INTO hne_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘कहूं बलिदान ह भेड़-बकरी के झुंड म ले एक होम-बलिदान अय, त तें भेड़ या बोकरा म ले बिगर दोसवाला नर ला बलिदान करबे। ");
INSERT INTO hne_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","तेंह येला बेदी के उत्तर कोति यहोवा के आघू म बलि करबे, अऊ हारून के बेटामन, जऊन मन पुरोहित अंय, ओकर लहू ला बेदी के चारों कोति छिंचहीं। ");
INSERT INTO hne_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","तब तें ओ पसु के कुटा-कुटा कर देबे, अऊ पुरोहित ह ओ पसु के कुटामन ला मुड़ अऊ चरबी समेत बेदी ऊपर बरत लकरी म रखय। ");
INSERT INTO hne_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","तेंह ओ पसु के पेट भीतर के अंगमन ला अऊ गोड़मन ला पानी म धो डारबे, अऊ पुरोहित ह ओ जम्मो ला लानके बेदी म जला देवय। येह यहोवा बर एक महकत सुख-देवइया, एक होम-बलिदान, अऊ एक जेवन-बलिदान होही। ");
INSERT INTO hne_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘कहूं यहोवा बर बलिदान ह चिरई के होम-बलिदान अय, त तें पंड़की या परेवा पीला के बलिदान चघाबे। ");
INSERT INTO hne_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","पुरोहित ह ओला बेदी म लानय अऊ ओकर घेंच ला मुरकेट के मुड़ ला अलग करय अऊ ओला बेदी म जलावय; ओकर लहू ला बेदी के बाजू म गिरावय। ");
INSERT INTO hne_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ओह घेंच के थैली अऊ पांखी ला निकालय अऊ ओमन ला बेदी के पूरब कोति राख डारे के जगह म फटिक देवय। ");
INSERT INTO hne_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","तब ओह दूनों डेना ला धरके चीरय, पर पूरा अलग झन करय, अऊ तब पुरोहित ह ओला बेदी म रखके बरत लकरी म जलावय। येह यहोवा बर एक महकत सुख-देवइया, एक होम-बलिदान अऊ एक जेवन-बलिदान होही। ");
INSERT INTO hne_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘जब कोनो मनखे यहोवा करा अन्न-बलिदान लानथे, त ओकर बलिदान ह बहुंत चिक्कन पीसान के होना चाही। ओह ओकर ऊपर जैतून तेल डारके ओमा धूप घलो रखय, ");
INSERT INTO hne_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","अऊ ओला हारून के ओ बेटामन करा ले जावय, जऊन मन पुरोहित अंय। पुरोहित ह ओ तेल अऊ धूप मिले मैदा ला एक मुठा भरके निकालय, अऊ ओला एक सुरता-देवइया हिस्सा के रूप म बेदी म जलावय कि येह यहोवा बर एक महकत सुख-देवइया, अन्न-बलिदान ठहिरय। ");
INSERT INTO hne_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","बाकि बांचे अन्न-बलिदान ह हारून अऊ ओकर बेटामन के अय; येह जेवन-बलिदान के सबले पबितर भाग अय, जेला यहोवा ला चघाय जाथे। ");
INSERT INTO hne_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘यदि तें भट्ठी म पके अन्न-बलिदान लानथस, त येह बहुंत चिक्कन पीसान के होना चाही: येह जैतून तेल म सनाय अखमीरी मोटा रोटी होवय या फेर जैतून तेल म चुपराय अखमीरी पातर रोटी होवय। ");
INSERT INTO hne_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","यदि तुम्हर अन्न-बलिदान ह तवा म पके हवय, त येह तेल म सनाय बहुंत चिक्कन पीसान के बने अखमीरी रोटी होवय। ");
INSERT INTO hne_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","तुमन ओला कुटा-कुटा करके ओकर ऊपर तेल डारव; येह एक अन्न-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","कहूं तुम्हर अन्न-बलिदान ह कढ़ई म चुरे हवय, त ओला बहुंत चिक्कन पीसान अऊ थोरकन तेल म बनाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ये चीजमन ले बने अन्न-बलिदान ला यहोवा करा लानव; ओला पुरोहित ला सऊंप देवव अऊ पुरोहित ह ओला बेदी मेर ले जावय। ");
INSERT INTO hne_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","पुरोहित ह अन्न-बलिदान म ले सुरता-देवइया हिस्सा ला निकालय अऊ ओला बेदी म जला देवय कि ओह यहोवा बर एक महकत सुख-देवइया, जेवन-बलिदान ठहिरय। ");
INSERT INTO hne_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","बाकि बांचे अन्न-बलिदान ह हारून अऊ ओकर बेटामन के अय; येह जेवन-बलिदान के सबले पबितर भाग अय, जेला यहोवा ला चघाय जाथे। ");
INSERT INTO hne_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘यहोवा करा लाने गय हर एक अन्न-बलिदान बिगर खमीर के बनाय जावय, काबरकि यहोवा ला चघाय जेवन-बलिदान म, तुमन ला कोनो खमीर या मंधरस जलाना नइं ए। ");
INSERT INTO hne_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तुमन येमन ला पहिली फर के बलिदान के रूप म यहोवा करा लान सकत हव, पर ओमन ला एक महकत सुख-देवइया बलिदान के रूप म बेदी ऊपर झन चघाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","अपन जम्मो अन्न-बलिदान ला नूनचूर करव। अपन परमेसर के संग बांधे करार के नून ला अपन अन्न-बलिदान ले अलग झन करव; अपन जम्मो बलिदान म नून मिलावव। ");
INSERT INTO hne_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘कहूं तुमन पहिली-फसल के अन्न-बलिदान यहोवा करा लानथव, त आगी म भूंजे नवां अनाज के कुचरे बालीमन ला अन्न-बलिदान करव। ");
INSERT INTO hne_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","तुमन येमा तेल अऊ धूप डारव; येह एक अन्न-बलिदान ए। ");
INSERT INTO hne_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","तब पुरोहित ह तेल अऊ जम्मो धूप के संग कुचरे अनाज के सुरता-देवइया हिस्सा ला जला देवय कि येह यहोवा बर जेवन-बलिदान ठहिरय। ");
INSERT INTO hne_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘कहूं तुम्हर चढ़ावा ह मेल-बलिदान ए, अऊ ओला बरदी म ले चघावव, चाहे ओह नर या मादा होवय, त यहोवा के आघू म निरदोस पसु ला ही चघावव। ");
INSERT INTO hne_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ओह अपन हांथ ला चढ़ावा पसु के मुड़ म मढ़ावय अऊ ओला मिलापवाला तम्बू के प्रवेस दुवार म पूजय; फेर हारून के बेटा, जऊन मन पुरोहित अंय, ओकर लहू ला बेदी के ऊपर जम्मो कोति छिंच देवंय। ");
INSERT INTO hne_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","अऊ ओह मेल-बलिदान के चढ़ावा म ले यहोवा बर होम-बलिदान करय याने ओ चरबी जेकर ले पोटामन ढंकाय रहिथे अऊ ओ जम्मो चरबी जेकर ले पोटामन लपटाय रहिथें, ");
INSERT INTO hne_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","अऊ दूनों गुरदा अऊ ओमन के ऊपर के चरबी जऊन ह कनिहां के तीर म रहिथे, अऊ गुरदा समेत करेजा के सबले बने भाग, ये जम्मो ला ओह अलग करय। ");
INSERT INTO hne_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","हारून के बेटामन ये जम्मो ला बेदी म ओ होम-बलिदान के ऊपर जला देवंय, जऊन ह आगी के ऊपर के लकरी म हवय। येह यहोवा बर महकत सुख-देवइया एक जेवन-बलिदान ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘कहूं तेंह यहोवा बर कोनो पसु म ले मेल-बलिदान चघाथस, त ओ चढ़ावा ह बिगर दोसवाला नर या मादा पसु हो। ");
INSERT INTO hne_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","कहूं तेंह मेढ़ा-पीला चघावत हस, त ओ चढ़ावा ला यहोवा के आघू म चघा। ");
INSERT INTO hne_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","मिलापवाला तम्बू के आघू म अपन हांथ ला चढ़ावा पसु के मुड़ ऊपर मढ़ाके ओला पूज दे। फेर हारून के बेटामन ओकर लहू ला बेदी म चारों कोति छिंचंय। ");
INSERT INTO hne_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","तें मेल-बलिदान म ले यहोवा बर एक जेवन-बलिदान लान: येह चरबी अय, याने कि मंझरेटा हाड़ा के तीर ले अलग करे गय चरबी भरे पुंछी, अऊ ओ चरबी जेकर ले पोटामन तोपाय रहिथें, अऊ ओ जम्मो चरबी जऊन ह पोटामन म लपटाय रहिथे। ");
INSERT INTO hne_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","अऊ दूनों गुरदा अऊ ओकर ऊपर के चरबी जऊन ह कनिहां के तीर म रहिथे अऊ गुरदा समेत करेजा के सबले बने भाग, ये जम्मो ला तेंह अलग करबे। ");
INSERT INTO hne_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","अऊ पुरोहित ह येमन ला लेके बेदी म जलावय; येह यहोवा बर एक जेवन-बलिदान ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘कहूं तोर चढ़ावा ह बोकरा होवय, त ओला यहोवा के आघू म चघा। ");
INSERT INTO hne_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","तेंह मिलापवाला तम्बू के आघू म चढ़ावा पसु के मुड़ म अपन हांथ ला मढ़ाके ओला पूज दे, अऊ हारून के बेटामन ओकर लहू ला बेदी म जम्मो कोति छिंच देवंय। ");
INSERT INTO hne_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","तें ओमा ले अपन चढ़ावा ला यहोवा बर जेवन-बलिदान करके चघा, याने ओ चरबी जेकर ले पोटामन तोपाय रहिथें, अऊ ओ जम्मो चरबी जऊन ह पोटामन म लपटाय रहिथे, ");
INSERT INTO hne_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","अऊ दूनों गुरदा अऊ ओकर ऊपर के चरबी जऊन ह कनिहां के तीर म रहिथे, अऊ गुरदा समेत करेजा के सबले बने भाग, ये जम्मो ला तेंह अलग करबे। ");
INSERT INTO hne_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","तब पुरोहित ह ओमन ला बेदी म जेवन-बलिदान के रूप म जलावय; येह सुख-देवइया सुगंध ठहिरय। जम्मो चरबी ह यहोवा के ही अय। ");
INSERT INTO hne_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘जिहां कहूं भी तुमन रहव, येह अवइया पीढ़ी-पीढ़ी बर हमेसा के एक बिधि ठहिरय। तुमन चरबी अऊ लहू ला कभू झन खाहू।’ ” ");
INSERT INTO hne_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इसरायलीमन ला ये कह: ‘जब कोनो अनजाने म कोनो पाप करथे अऊ ओ काम करथे, जऊन ह यहोवा के कोनो हुकूम के बिरूध अय— ");
INSERT INTO hne_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘कहूं अभिसिक्त पुरोहित ह अइसने पाप करय, जेकर ले मनखेमन दोसी ठहिरंय, त अपन पाप के खातिर, ओह यहोवा करा एक निरदोस बछवा पाप-बलिदान के रूप म लानय। ");
INSERT INTO hne_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ओह ओ बछवा ला मिलापवाला तम्बू के प्रवेस दुवार म यहोवा के आघू म लानय अऊ ओकर मुड़ म अपन हांथ रखय अऊ बछवा ला यहोवा के आघू म बलि करय। ");
INSERT INTO hne_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","तब अभिसिक्त पुरोहित ह बछवा के थोरकून लहू ला लेके मिलापवाला तम्बू म जावय। ");
INSERT INTO hne_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ओह अपन अंगठी ला लहू म बुड़ोके पबितर-स्थान के परदा के सामने यहोवा के आघू म सात बार छिंचय। ");
INSERT INTO hne_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","तब पुरोहित ह ओ लहू म ले थोरकून ला लेके कहरत धूप के बेदी के ओ सींगमन म लगावय, जऊन ह मिलापवाला तम्बू म यहोवा के आघू म हवय। बछवा के बांचे जम्मो लहू ला, ओह होम-बलिदान के बेदी के खाल्हे म रितो देवय, जऊन ह मिलापवाला तम्बू के प्रवेस दुवार म हवय। ");
INSERT INTO hne_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ओह पाप-बलिदान के बछवा के जम्मो चरबी ला निकाल देवय—याने कि पेट भीतर के अंगमन के जम्मो चरबी, ");
INSERT INTO hne_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","अऊ दूनों गुरदा अऊ ओकर ऊपर के चरबी जऊन ह कनिहां के तीर म रहिथे, अऊ करेजा के सबले बने भाग, जऊन ला ओह गुरदा संग अलग करही— ");
INSERT INTO hne_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","जइसने कि मेल-बलिदान के बलि के बईला ले चरबी ला अलग करे जाथे। तब पुरोहित ह येमन ला होम-बलिदान के बेदी म जला देवय। ");
INSERT INTO hne_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","पर बछवा के खाल अऊ ओकर जम्मो मांस, अऊ मुड़, गोड़मन ला, पेट भीतर के अंग अऊ पोटा ला— ");
INSERT INTO hne_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","याने कि बछवा के जम्मो बांचे भाग ला ओह डेरा के बाहिर ओ जगह म ले जावय, जेला बिधि-बिधान ले सुध करे गे हवय अऊ जिहां राख ला डारे जाथे, अऊ उहां राख ऊपर लकरी रखके ओमा येला जला देवय। ");
INSERT INTO hne_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘कहूं जम्मो इसरायली समाज अनजाने म कोनो पाप करथे अऊ अइसने काम करथे, जऊन ह यहोवा के हुकूम के बिरूध अय, हालाकि पूरा समाज ये बात ले अनजान रहिथे, पर जब ओमन अपन अपराध ला जानथें ");
INSERT INTO hne_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","अऊ ओमन ला अपन करे गे पाप के पता चलथे, त जम्मो समाज ह एक ठन बछवा ला पाप-बलिदान के रूप म मिलापवाला तम्बू के आघू म लेके जावय, ");
INSERT INTO hne_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","अऊ समाज के अगुवामन यहोवा के आघू म ओ बछवा के मुड़ म अपन हांथ रखंय अऊ यहोवा के आघू म ओ बछवा के बलि करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","तब अभिसिक्त पुरोहित ह बछवा के लहू म ले थोरकून ला मिलापवाला तम्बू म ले जावय। ");
INSERT INTO hne_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ओह अपन अंगठी ला लहू म बुड़ोके परदा के सामने म सात बार यहोवा के आघू म छिंचय। ");
INSERT INTO hne_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ओह ओ लहू म ले थोरकून लेके बेदी के ओ सींगमन म लगावय, जऊन ह यहोवा के आघू म मिलापवाला तम्बू म हवय। बाकि बांचे जम्मो लहू ला ओह होम-बलिदान के बेदी के खाल्हे म रितो देवय, जऊन ह मिलापवाला तम्बू के मुंहटा म हवय। ");
INSERT INTO hne_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ओह बछवा के जम्मो चरबी ला निकाल लेवय अऊ ओ चरबी ला बेदी म जला देवय, ");
INSERT INTO hne_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","अऊ ओह ये बछवा के संग ठीक वइसनेच करय, जइसने पाप-बलिदान के बछवा ला करे रिहिस। ये किसम ले पुरोहित ह इसरायली समाज बर प्रायस्चित करय, अऊ समाज के पाप छेमा करे जाही। ");
INSERT INTO hne_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","तब ओह बछवा ला डेरा के बाहिर ले जावय अऊ ओला वइसने ही जलावय, जइसने ओह पहिली बछवा ला जलाय रिहिस। येह समाज बर पाप-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘जब कोनो अगुवा ह अनजाने म पाप करथे अऊ ओ काम करथे, जऊन ह यहोवा, ओकर परमेसर के हुकूम के बिरूध अय, पर जब ओह अपन अपराध ला महसूस करथे ");
INSERT INTO hne_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","अऊ ओला अपन करे गे पाप के पता चलथे, त ओह एक ठन निरदोस बोकरा ला बलिदान के रूप म लानय। ");
INSERT INTO hne_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ओह बोकरा के मुड़ म अपन हांथ ला रखय अऊ ओला यहोवा के आघू म ओ जगह म बलि करय, जिहां होम-बलिदान के पसु ला बलि करे जाथे। येह एक पाप-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","तब पुरोहित ह अपन अंगठी म पाप-बलिदान के पसु के थोरकून लहू ला लेवय अऊ ओला होम-बलिदान के बेदी के सींगमन म लगावय अऊ बाकि बांचे लहू ला बेदी के खाल्हे म रितो देवय। ");
INSERT INTO hne_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ओह जम्मो चरबी ला बेदी म वइसने जलावय, जइसने ओह मेल-बलिदान के चरबी ला जलाय रिहिस। ये किसम ले पुरोहित ह ओ अगुवा के पाप बर प्रायस्चित के बिधि ला पूरा करही, अऊ परमेसर ह ओकर पाप ला छेमा करही। ");
INSERT INTO hne_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘यदि समाज के कोनो मनखे अनजाने म कोनो पाप करथे अऊ ओ काम करथे, जऊन ह यहोवा के हुकूम के बिरूध अय, पर जब ओह अपन अपराध ला महसूस करथे ");
INSERT INTO hne_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","अऊ ओला अपन करे गे पाप के पता चलथे, त ओह अपन करे गे पाप के खातिर एक ठन निरदोस छेरी बलिदान के रूप म लानय। ");
INSERT INTO hne_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ओह अपन हांथ ला ओ पाप-बलिदान के पसु के मुड़ म रखय अऊ येला होम-बलिदान करे के जगह म बलि करय। ");
INSERT INTO hne_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","तब पुरोहित ह अपन अंगठी म ओकर थोरकून लहू ला लेवय अऊ ओला होम-बलिदान के बेदी के सींगमन म लगावय अऊ बाकि बांचे लहू ला बेदी के खाल्हे म रितो देवय। ");
INSERT INTO hne_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ओ मनखे ह जम्मो चरबी ला अलग करय, जइसने कि मेल-बलिदान के पसु के चरबी ला अलग करे जाथे, अऊ पुरोहित ह ओला बेदी म जला देवय ताकि ओह यहोवा बर सुख-देवइया एक सुगंध होवय। ये किसम ले पुरोहित ह ओ मनखे के पाप बर प्रायस्चित के बिधि ला पूरा करही, अऊ परमेसर ह ओकर पाप ला छेमा करही। ");
INSERT INTO hne_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘कहूं कोनो अपन पाप-बलिदान बर मेढ़ा-पीला के झुंड म ले कोनो पसु ला लानथे, त ओह एक निरदोस भेड़ी-पीला ला लानय। ");
INSERT INTO hne_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ओह ओ भेड़ी-पीला के मुड़ म अपन हांथ ला रखय अऊ ओला पाप-बलिदान बर ओ जगह म बलि करय, जिहां होम-बलिदान के पसु ला बलि करे जाथे। ");
INSERT INTO hne_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","तब पुरोहित ह अपन अंगठी म पाप-बलिदान के पसु के थोरकून लहू ला लेवय अऊ ओला होम-बलिदान के बेदी के सींगमन म लगावय अऊ बाकि बांचे लहू ला बेदी के खाल्हे म रितो देवय। ");
INSERT INTO hne_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","तब ओ मनखे ह जम्मो चरबी ला अलग करय, जइसने कि मेल-बलिदान के मेढ़ा-पीला के चरबी ला अलग करे जाथे, अऊ पुरोहित ह ओला बेदी म यहोवा ला चघाय जेवन-बलिदान के ऊपर जलावय। ये किसम ले पुरोहित ह ओ मनखे दुवारा करे गे पाप ले प्रायस्चित के बिधि ला पूरा करय, अऊ परमेसर ह ओकर पाप ला छेमा करही। ");
INSERT INTO hne_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘कहूं कोनो मनखे ह कोनो घटना ला देखे रहिथे या ओ घटना ला जानत रहिथे, पर जब गवाह के रूप म ओकर ले ओ घटना के बारे म पुछे जाथे, अऊ यदि ओह कुछू नइं बतावय, त ओह पाप करथे, अऊ ओला जिम्मेदार ठहिराय जाही। ");
INSERT INTO hne_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘कहूं कोनो मनखे ला पता चलथे कि ओमन दोसी अंय—यदि ओमन असुध चीज ला अनजाने म छू लेथें (चाहे असुध जंगली पसु के लास या घरेलू-पसु के लास होवय, या भुइयां म रेंगइया कोनो असुध जीव-जन्तु के लास होवय) अऊ ओ मनखेमन नइं जानंय कि ओमन संस्कारिक रूप ले असुध हो गे हवंय, पर जब ओमन अपन दोस ला जानथें; ");
INSERT INTO hne_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","या कहूं ओमन मनखे के कोनो असुध चीज ला अनजाने म छूथें (कोनो घलो चीज, जऊन ह ओला असुध करथे), पर जब ओमन ला ये बात के पता चलथे अऊ अपन गलती ला महसूस करथें; ");
INSERT INTO hne_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","या कहूं कोनो मन बिगर सोचे-बिचारे अनजाने म कोनो काम ला करे के किरिया खाथें, चाहे ओ भलई के काम हो या बुरई के (दूनों बात म लापरवाही से किरिया खाथें), पर जब ओमन ला ये बात के पता चलथे अऊ ओमन अपन गलती ला महसूस करथें। ");
INSERT INTO hne_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","जब कोनो मनखे ला पता चलथे कि ये बातमन के कोनो एक ठन म घलो ओह दोसी अय, त ओह जऊन गलती करके पाप करे हवय, ओला मान लेवय। ");
INSERT INTO hne_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","जऊन पाप ओह करे हवय, ओकर दंड के रूप म, ओह बरदी म ले एक ठन मेढ़ी-पीला या छेरी, यहोवा करा पाप-बलिदान के रूप म लानय; अऊ पुरोहित ह ओकर पाप के खातिर पछताप के बिधि ला पूरा करय। ");
INSERT INTO hne_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘पर कहूं कोनो भेड़ी-पीला नइं चढ़ा सकय, त अपन पाप के दंड के रूप म, ओह यहोवा करा दू ठन पंड़की या दू ठन परेवा पीला ले आवय—एक ठन ला पाप-बलिदान बर अऊ दूसर ला होम-बलिदान करे बर। ");
INSERT INTO hne_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ओह ओमन ला पुरोहित करा ले आवय अऊ पुरोहित ह पहिले एक ठन ला पाप-बलिदान बर चघावय। ओह ओ चिरई के घेंच ले ओकर मुड़ ला मुरकेट देवय, पर ओला पूरा अलग झन करय, ");
INSERT INTO hne_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","अऊ ओह ओ पाप-बलिदान के लहू म ले थोरकून लेके बेदी के बगल म छिंचय; बाकि बांचे लहू ला बेदी के खाल्हे म रितो देवय। येह एक पाप-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","पुरोहित ह तब दूसर चिरई ला बताय गे बिधि के मुताबिक होम-बलिदान के रूप म चघावय अऊ पुरोहित ह ओकर करे गे पाप बर प्रायस्चित के बिधि ला पूरा करय, अऊ परमेसर ह ओकर पाप ला छेमा करही। ");
INSERT INTO hne_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘पर कहूं ओह दू ठन पंड़की या परेवा के दू ठन पीला घलो नइं दे सकय, त ओह अपन पाप के खातिर चघाय बर एपा के दसवां भाग बहुंत चिक्कन पीसान पाप-बलिदान के रूप म ले आवय। ओह ओमा जैतून तेल या धूप झन डालय, काबरकि ओह एक पाप-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ओह ओला पुरोहित करा लानय अऊ पुरोहित ह ओमा ले अपन मुठा भरके सुरता-देवइया हिस्सा के रूप म लेवय अऊ ओला बेदी म यहोवा ला चघाय अन्न-बलिदान के ऊपर जलावय। येह एक पाप-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ये किसम ले, पुरोहित ह ओकर खातिर, ओकर दुवारा करे गय येमा के कोनो पाप बर प्रायस्चित के बिधि ला पूरा करही, अऊ परमेसर ह ओकर पाप ला छेमा करही। बाकि बांचे बलिदान ह पुरोहित के होही, जइसने कि अन्न-बलिदान के बिधि म होथे।’ ” ");
INSERT INTO hne_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","फेर यहोवा ह मूसा ला कहिस: ");
INSERT INTO hne_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“कहूं कोनो यहोवा के कोनो पबितर चीज के संबंध म अनजाने म पाप करथे, अऊ यहोवा के नजर म बेईमान ठहिरथे, त ओमन भेड़-बकरी के झुंड ले, दंड के रूप म एक ठन निरदोस मेढ़ा यहोवा करा लानंय अऊ पबितर-स्थान के सेकेल के मुताबिक, ओह चांदी म उचित दाम के होवय। येह एक दोस-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","जऊन पबितर चीज के बिसय म ओमन पाप करे हवंय, ओमन ओकर भरपई जरूर करंय; दंड के रूप म, ओ चीज के दाम म पांचवां भाग अऊ बढ़ाके ओमन ओ जम्मो ला पुरोहित ला देवंय। पुरोहित ह ओमन बर मेढ़ा ला दोस-बलिदान के रूप म चघाके प्रायस्चित के बिधि ला पूरा करही, अऊ परमेसर ह ओमन के पाप ला छेमा करही। ");
INSERT INTO hne_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“कहूं कोनो पाप करथे अऊ ओ काम करथे, जऊन ह यहोवा के हुकूम के बिरूध अय, चाहे ओह ओ काम ला अनजाने म करय, तभो ले ओह दोसी अय अऊ ओह ओ काम बर जिम्मेदार ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","एकरसेति ओह दोस-बलिदान के रूप म बरदी म ले एक ठन निरदोस मेढ़ा पुरोहित करा लानय अऊ ओह उचित दाम के होवय। ये किसम ले, पुरोहित ह ओकर बर, ओकर दुवारा अनजाने म करे गय गलती खातिर प्रायस्चित के बिधि ला पूरा करही, अऊ परमेसर ह ओकर पाप ला छेमा करही। ");
INSERT INTO hne_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","येह एक दोस-बलिदान अय; ओह यहोवा के बिरूध म गलत करके दोसी ठहिरे हवय।” ");
INSERT INTO hne_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","फेर यहोवा ह मूसा ला कहिस: ");
INSERT INTO hne_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“कहूं कोनो मनखे ह पाप करथे अऊ यहोवा के नजर म बेईमान ठहिरथे, याने कि अपन परोसी ला धोखा देथे या ओकर सामान के गलत उपयोग करथे या ओकर सामान के चोरी करथे, या अपन परोसी ला ठगथे, ");
INSERT INTO hne_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","या ओह कोनो गंवाय चीज ला पाके ओकर बिसय म लबारी मारथे, या मनखेमन के करे गे कोनो पाप के बारे म झूठ-मूठ के किरिया खाथे— ");
INSERT INTO hne_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","जब ओह येमा के कोनो घलो पाप करथे अऊ अपन दोस ला महसूस करथे, त जरूरी अय कि जऊन चीज ला ओह चोराय रिहिस या लूटे रिहिस, या ओकर भरोसा म रखे चीज ला ले लेय रिहिस, या ओ गंवाय चीज जऊन ला ओह पाय रिहिस, ");
INSERT INTO hne_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","या कोनो चीज जेकर बारे म झूठ-मूठ के किरिया खाय रिहिस, ओ जम्मो चीज के पूरा भरपई करय, अऊ ओ चीज के जऊन कीमत होही, ओकर पांचवां भाग ओमा जोड़के ओकर मालिक ला ओ जम्मो चीज ओ दिन दे देवय, जऊन दिन ओह अपन दोस-बलिदान चघावय। ");
INSERT INTO hne_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","अऊ दंड के रूप म, यहोवा ला चघाय बर ओह अपन दोस-बलिदान पुरोहित करा लानय, अऊ ये दोस-बलिदान बरदी म ले एक ठन निरदोस मेढ़ा होवय अऊ ओह उचित दाम के होवय। ");
INSERT INTO hne_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ये किसम ले, पुरोहित ह ओकर बर यहोवा के आघू म प्रायस्चित के बिधि ला पूरा करही, अऊ जऊन घलो काम ला करके ओह दोसी ठहिरे होही, परमेसर ह ओला ओकर बर छेमा करही।” ");
INSERT INTO hne_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","फेर यहोवा ह मूसा ला कहिस: ");
INSERT INTO hne_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून अऊ ओकर बेटामन ला ये हुकूम दे: ‘होम-बलिदान करे बर ये नियम अय: होम-बलिदान ह बेदी के चूल्हा म रात भर, बिहनियां होवत तक रहय, अऊ बेदी म के आगी ह बरत रहय। ");
INSERT INTO hne_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","पुरोहित ह तब अपन मलमल के ओनहा ला पहिरय अऊ अपन देहें म मलमल के कच्छा घलो पहिरय अऊ बेदी म जलाय होम-बलिदान के राख ला उठाके बेदी के बाजू म रखय। ");
INSERT INTO hne_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","तब ओह अपन ओनहा ला उतारके आने ओनहा पहिरय, अऊ राख ला डेरा के बाहिर अइसन जगह म ले जावय, जऊन ह बिधि के मुताबिक साफ हवय। ");
INSERT INTO hne_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","बेदी के आगी ह बरत रहय; येह झन बुतावय। पुरोहित ह रोज बिहनियां ओमा लकरी डालय अऊ होम-बलिदान ला आगी म सही ढंग ले रखय अऊ ओकर ऊपर मेल-बलिदान के चरबी ला जलावय। ");
INSERT INTO hne_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","बेदी म हमेसा आगी बरतेच रहय; येह कभू झन बुतावय। ");
INSERT INTO hne_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘अन्न-बलिदान करे बर ये नियम अय: हारून के बेटामन ओ बलिदान ला बेदी के आघू म यहोवा करा लानंय। ");
INSERT INTO hne_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","पुरोहित ह ओ अन्न-बलिदान म ले अपन मुठा भरके बहुंत चिक्कन पीसान अऊ थोरकून जैतून तेल अऊ संग म जम्मो धूप ला लेवय, अऊ सुरता-देवइया हिस्सा ला बेदी ऊपर जलावय, जेह यहोवा बर सुख-देवइया एक सुगंध होही। ");
INSERT INTO hne_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ओमा के बाकि बांचे चीज ला हारून अऊ ओकर बेटामन खावंय। पर येला ओमन पबितर-स्थान के छेत्र म बिगर खमीर के खावंय; ओमन येला मिलापवाला तम्बू के अंगना म खावंय। ");
INSERT INTO hne_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","येला खमीर के संग झन पकाय जावय; मोला चघाय गे जेवन-बलिदान के ओमन के बांटा के रूप म, मेंह येला दे हवंव। येह पाप-बलिदान अऊ दोस-बलिदान सहीं महा पबितर अय। ");
INSERT INTO hne_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","हारून के बंस म के कोनो घलो पुरूस येला खा सकत हें, तुम्हर अवइया जम्मो पीढ़ी बर, यहोवा ला चघाय गे जेवन-बलिदान म ले, येह हमेसा ओमन के बांटा होही। जऊन कुछू घलो ओ बलिदान के चीजमन ला छू लेथे, ओह पबितर हो जाही।’ ” ");
INSERT INTO hne_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","यहोवा ह मूसा ला ये घलो कहिस, ");
INSERT INTO hne_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“जऊन दिन हारून अऊ ओकर बेटामन म ले काकरो अभिसेक करे जावय, ओ दिन ओह अपन बेटामन के संग यहोवा करा ये बलिदान लेके आवय: एपा के दसवां हिस्सा के बरोबर बहुंत चिक्कन पीसान नियमित अन्न-बलिदान के रूप म, आधा बिहनियां अऊ आधा संझा के बेरा चघावय। ");
INSERT INTO hne_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","येला तेल के संग तवा म चुरोय जावय; येला बने करके मिलाय जावय अऊ ये अन्न-बलिदान ला कुटा-कुटा करके चघावय; येह यहोवा बर सुख-देवइया एक सुगंध होही। ");
INSERT INTO hne_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ओकर जऊन बेटा ह अभिसिक्त पुरोहित के रूप म ओकर जगह ला लीही, ओही ह ओ बलिदान ला तियार करय। येह यहोवा के हमेसा के बांटा अय अऊ येला पूरा जलाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","पुरोहित के हर एक अन्न-बलिदान ला पूरा जलाय जावय; येला झन खाय जावय।” ");
INSERT INTO hne_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून अऊ ओकर बेटामन ला कह: ‘पाप-बलिदान करे के नियम ये अय: पाप-बलिदान के पसु ला यहोवा के आघू म ओही जगह म बलि करे जावय, जऊन जगह म होम-बलिदान के पसु ला बलि करे जाथे। येह महा पबितर अय। ");
INSERT INTO hne_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जऊन पुरोहित ह पाप-बलिदान ला चघाथे, ओही ह ओला खावय। ओला पबितर-स्थान के छेत्र म याने कि मिलापवाला तम्बू के अंगना म खाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जऊन कुछू घलो ओकर मांस ला छू लेथे, ओह पबितर हो जाही, अऊ यदि लहू के कोनो छींटा ह ओनहा म लग जावय, त ओला पबितर-स्थान के छेत्र म धोय जावय। ");
INSERT INTO hne_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","जऊन माटी के बरतन म ओ मांस ला रांधे जाथे, ओला टोर दिये जावय; पर कहूं ओ मांस ला कांस के बरतन म रांधे जाथे, त बरतन ला मांजके पानी म धोय जावय। ");
INSERT INTO hne_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","पुरोहित परिवार के कोनो घलो मरद ओला खा सकत हें; येह महा पबितर अय। ");
INSERT INTO hne_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","पर जऊन पाप-बलिदान के पसु के लहू ला मिलापवाला तम्बू के भीतर पबितर स्थान म प्रायस्चित करे बर लाय जाथे, ओकर मांस ला झन खाय जावय; ओला आगी म जला दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘दोस-बलिदान करे के ये नियम अय, अऊ ये बलिदान ह महा पबितर अय: ");
INSERT INTO hne_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","जऊन जगह म होम-बलिदान के पसु ला बलि करे जाथे, ओही जगह म दोस-बलिदान के पसु ला घलो बलि करे जावय अऊ ओकर लहू ला बेदी के चारों कोति छिंचे जावय। ");
INSERT INTO hne_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ओमा के जम्मो चरबी ला चघाय जावय: याने कि चरबीवाला पुंछी अऊ ओ चरबी, जऊन ह पेट के अंगमन ला तोपे रहिथे, ");
INSERT INTO hne_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","दूनों गुरदा अऊ ओमन के ऊपर के चरबी, जऊन ह कनिहां के तीर म रहिथे अऊ करेजा के निकले भाग, जऊन ला गुरदामन समेत अलग करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","पुरोहित ह ओमन ला बेदी म यहोवा ला चघाय जेवन-बलिदान के रूप म जला देवय। येह एक दोस-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","पुरोहित के परिवार के कोनो घलो मरद येला खा सकत हे, पर येला पबितर-स्थान म खाय जावय। येह महा पबितर अय। ");
INSERT INTO hne_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘पाप-बलिदान अऊ दोस-बलिदान दूनों म ओहीच कानून लागू होथे: येमन ओ पुरोहित के होथें, जऊन ह ओमन के संग प्रायस्चित के बिधि ला पूरा करथे। ");
INSERT INTO hne_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","जऊन पुरोहित ह काकरो बर होम-बलिदान चघाथे, ओ पुरोहित ह बलिदान के पसु के खाल ला अपन बर रख सकत हे। ");
INSERT INTO hne_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","हर अन्न-बलिदान, जऊन ह चूल्हा के आंच म सेंके जाथे या कढ़ई या तवा म पकाय जाथे, ओह ओहीच पुरोहित के होही, जऊन ह ओला चघाथे, ");
INSERT INTO hne_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","अऊ हर एक अन्न-बलिदान, चाहे ओह जैतून तेल म सनाय होवय या सूखा होवय, ओह हारून के जम्मो बेटामन ला बरोबर-बरोबर बांटा म मिलय। ");
INSERT INTO hne_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘जब कोनो मनखे यहोवा ला मेल-बलिदान चघाथे, त ओकर नियम ये अय: ");
INSERT INTO hne_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘कहूं ओह येला धनबाद देय बर चघाथे, त ये धनबाद-बलिदान के संग, ओह जैतून तेल म सनाय बिगर खमीर के बने मोटा-मोटा रोटी, बिगर खमीर के बने तेल म चुपरे पातर-पातर रोटी, अऊ बने ढंग से गुंथाय अऊ तेल म सनाय बहुंत चिक्कन पीसान के बने मोटा-मोटा रोटी चघावय। ");
INSERT INTO hne_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","धनबाद के मेल-बलिदान के संग, ओह खमीर मिले मोटा-मोटा रोटी के चढ़ावा चघावय। ");
INSERT INTO hne_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ओह हर किसम के रोटी म ले एक-एक ठन रोटी बलिदान के रूप म लानय; येह यहोवा के हिस्सा होही; येह ओ पुरोहित के अय, जऊन ह मेल-बलिदान के लहू ला बेदी के चारों कोति छिंचथे। ");
INSERT INTO hne_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","धनबाद के मेल-बलिदान के मांस ला ओहीच दिन खाय जावय, जऊन दिन ओला चघाय जाथे; बिहनियां होवत तक ओमा ले कुछू झन बांचय। ");
INSERT INTO hne_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘पर, कहूं, ओकर बलिदान ह बदना के कारन या स्वेच्छा-बलिदान होवय, त जऊन दिन बलिदान चघाय जावय, ओहीच दिन ओला खाय जावय, पर कुछू बांच जावय, त ओला ओकर दूसर दिन खाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","यदि बलिदान के कुछू मांस ह तीसर दिन तक बांचे रहिथे, त ओला आगी म जला दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","कहूं मेल-बलिदान म के कोनो मांस ला तीसर दिन खाय जाथे, त ओ बलिदान चघोइया ला गरहन नइं करे जावय। येला ओकर हित म नइं गने जावय, काबरकि येह असुध हो गे हवय; जऊन मनखे ह येमा के कुछू चीज ला खाथे, ओला ओकर बर जिम्मेदार ठहिराय जाही। ");
INSERT INTO hne_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘यदि मांस ह कोनो अइसने चीज ले छू जाथे, जऊन ह बिधि के मुताबिक असुध अय, त ओ मांस ला झन खाय जावय; ओला आगी म जला दिये जावय। दूसर मांस ला बिधि के मुताबिक सुध मनखे ह खा सकथे। ");
INSERT INTO hne_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","पर कहूं कोनो मनखे असुध होके यहोवा ला चघाय गे मेल-बलिदान के मांस ला खाथे, त ओह अपन मनखेमन के समाज ले अलग करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","अऊ कहूं कोनो असुध चीज ला छूथे—चाहे मनखे के असुधता होवय या असुध पसु होवय या भुइयां म रेंगइया कोनो असुध जीव होवय—अऊ तब यहोवा ला चघाय गे मेल-बलिदान के मांस म ले खाथे, त ओ मनखे घलो अपन मनखेमन के समाज ले अलग करे जावय।’ ” ");
INSERT INTO hne_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इसरायलीमन ला कह: ‘तुमन कोनो पसु के चरबी ला झन खावव, भेड़ होवय या बोकरा। ");
INSERT INTO hne_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","जऊन पसु ह अपनआप मर गे हे या जऊन पसु ला कोनो जंगली पसु चीर-फार दे हे, ओकर चरबी ला कोनो आने काम म लाय जा सकत हे, पर तुमन ओला झन खाहू। ");
INSERT INTO hne_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","जऊन मनखे ह ओ पसु के चरबी ला खाथे, जेकर ले यहोवा बर जेवन-बलिदान चघाय जा सकथे, त ओ मनखे ह अपन मनखेमन ले अलग करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","अऊ तुमन जिहां कहूं घलो रहव, कोनो चिरई या पसु के लहू ला झन खावव। ");
INSERT INTO hne_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ओ मनखे, जऊन ह लहू ला खाथे, ओह अपन मनखेमन ले अलग करे जावय।’ ” ");
INSERT INTO hne_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इसरायलीमन ला कह: ‘ओ मनखे, जऊन ह यहोवा बर मेल-बलिदान लानथे, ओह मेल-बलिदान के एक भाग ला यहोवा बर अपन बलिदान के रूप म लानय। ");
INSERT INTO hne_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ओह अपनेच हांथ ले यहोवा बर जेवन-बलिदान चघावय; ओह चरबी ला छाती के समेत लानय, अऊ छाती ला हलाय-बलिदान के रूप म यहोवा के आघू म हलावय। ");
INSERT INTO hne_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","पुरोहित ह चरबी ला बेदी म जलावय, पर छाती ह हारून अऊ ओकर बेटामन के अय। ");
INSERT INTO hne_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","तुमन अपन मेल-बलिदान के जेवनी जांघ ला पुरोहित ला ओकर हिस्सा के रूप म देवव। ");
INSERT INTO hne_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारून के जऊन बेटा ह मेल-बलिदान के लहू अऊ चरबी ला चघाथे, ओह जेवनी जांघ ला अपन बांटा के रूप म रखय। ");
INSERT INTO hne_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","इसरायलीमन के मेल-बलिदान म ले, हलाय गय छाती अऊ चघाय गय जांघ ला, मेंह लेय हंव अऊ येमन ला हारून पुरोहित अऊ ओकर बेटामन ला देय हंव कि इसरायलीमन कोति ले, येह हमेसा ओमन के बांटा होवय।’ ” ");
INSERT INTO hne_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","येह यहोवा ला चघाय गे जेवन-बलिदान के ओ बांटा अय, जऊन ला हारून अऊ ओकर बेटामन ला ओ दिन दिये गीस, जऊन दिन ओमन पुरोहित के रूप म यहोवा के सेवा करे बर लाने गीन। ");
INSERT INTO hne_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","जऊन दिन ओमन के अभिसेक करे गीस, ओहीच दिन यहोवा ह हुकूम दीस कि इसरायलीमन येला पीढ़ी दर पीढ़ी ओमन ला ओमन के बांटा के रूप म हमेसा देवंय। ");
INSERT INTO hne_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","येमन होम-बलिदान, अन्न-बलिदान, पाप-बलिदान, दोस-बलिदान, अभिसेक-बलिदान अऊ मेल-बलिदान के नियम अंय, ");
INSERT INTO hne_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","जेला यहोवा ह मूसा ला सीनय के सुन्ना जगह म सीनय के पहाड़ ऊपर ओ दिन दीस, जऊन दिन ओह इसरायलीमन ला यहोवा करा ओमन के बलिदान लाने के हुकूम दीस। ");
INSERT INTO hne_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“हारून अऊ ओकर बेटामन ला, ओमन के ओनहा ला, अभिसेक के तेल ला, पाप-बलिदान बर एक ठन निरदोस बछवा ला, दू ठन निरदोस मेढ़ा अऊ ओ टुकनी, जऊन म बिगर खमीर के बने रोटी हवय, ये जम्मो ला ले आन, ");
INSERT INTO hne_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","अऊ इसरायल के पूरा सभा ला मिलापवाला तम्बू के मुंहटा म बला ले।” ");
INSERT INTO hne_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","मूसा ह यहोवा के हुकूम के मुताबिक करिस, अऊ सभा ह मिलापवाला तम्बू के मुंहटा म जूर गीस। ");
INSERT INTO hne_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","मूसा ह सभा के मनखेमन ला कहिस, “जऊन काम करे के हुकूम यहोवा ह देय हवय, ओह ये अय।” ");
INSERT INTO hne_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","तब मूसा ह हारून अऊ ओकर बेटामन ला सामने लानके ओमन ला पानी ले नहवाईस। ");
INSERT INTO hne_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ओह हारून ला अंगरखा पहिराईस, अऊ ओकर कनिहां म कमरबंध लपेटिस, ओला बागा पहिराके ओकर ऊपर एपोद पहिराईस। ओह सुघरता से बुने गय कमरबंध ले एपोद ला कसके बांध दीस। ");
INSERT INTO hne_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","तब ओह छातीबंध ला ओकर ऊपर लगाके छातीबंध म ऊरीम अऊ तुम्मीम लगा दीस। ");
INSERT INTO hne_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","फेर ओह ओकर मुड़ म पागा घलो पहिराईस अऊ पागा के आघू म सोन के पट्टी याने कि पबितर मुकुट ला लगाईस, जइसने कि यहोवा ह मूसा ला हुकूम देय रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","तब मूसा ह अभिसेक के तेल ला लीस, अऊ पबितर-तम्बू अऊ जऊन कुछू ओमा रिहिस, ओ जम्मो ला अभिसेक करके ओमन के संस्कार करिस। ");
INSERT INTO hne_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ओह थोरकून तेल लेके बेदी के ऊपर सात बार छिंचिस, बेदी अऊ ओकर जम्मो सामान ला अऊ तसला अऊ ओकर खुरामन ला घलो पबितर करे बर ओमन के अभिसेक करिस। ");
INSERT INTO hne_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ओह अभिसेक के कुछू तेल ला हारून के मुड़ म रितोईस अऊ ओला पबितर करे बर ओकर अभिसेक करिस। ");
INSERT INTO hne_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","तब ओह हारून के बेटामन ला आघू म लानके ओमन ला अंगरखा पहिराईस, कनिहां म कमरबंध बांधिस अऊ मुड़ म टोपी पहिराईस जइसने कि यहोवा ह मूसा ला हुकूम देय रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ओह तब पाप-बलिदान बर बछवा ला लानिस, अऊ हारून अऊ ओकर बेटामन पाप-बलिदान के बछवा के मुड़ म अपन हांथ रखिन। ");
INSERT INTO hne_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","मूसा ह ओ बछवा ला बलि करिस, अऊ अपन अंगठी म बछवा के थोरकून लहू लेके बेदी के जम्मो सींगमन म लगाईस, अऊ बेदी ला सुध करिस। बाकि बांचे लहू ला ओह बेदी के खाल्हे म रितो दीस। ये किसम ले ओह प्रायस्चित करे बर बेदी ला पबितर करिस। ");
INSERT INTO hne_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मूसा ह पेट के भीतरी भाग के जम्मो चरबी ला लीस अऊ करेजा के लम्बा निकले भाग, अऊ चरबी सहित दूनों गुरदा ला घलो लीस, अऊ ओमन ला बेदी म जला दीस। ");
INSERT INTO hne_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","पर बछवा अऊ ओकर खाल अऊ ओकर मांस अऊ ओकर पोटा ला डेरा के बाहिर जला दीस, जइसने कि यहोवा ह मूसा ला हुकूम देय रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ओह तब होम-बलिदान बर मेढ़ा ला लानिस, अऊ हारून अऊ ओकर बेटामन ओ मेढ़ा के मुड़ म अपन हांथ रखिन। ");
INSERT INTO hne_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","तब मूसा ह मेढ़ा ला बलि करिस अऊ ओकर लहू ला लेके बेदी के चारों मुड़ा छिंचिस। ");
INSERT INTO hne_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ओह मेढ़ा ला कुटा-कुटा करिस अऊ ओकर मुड़ अऊ कुटामन ला अऊ चरबी ला जला दीस। ");
INSERT INTO hne_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ओह पेट भीतर के चीजमन ला अऊ गोड़मन ला पानी म धोईस अऊ पूरा मेढ़ा ला बेदी म जला दीस। येह यहोवा ला चघाय बर एक होम-बलिदान, एक सुख-देवइया सुगंध, एक जेवन-बलिदान होईस, जइसने कि यहोवा ह मूसा ला हुकूम देय रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ओह तब दूसर मेढ़ा ला याने कि अभिसेक करे के मेढ़ा ला लानिस अऊ हारून अऊ ओकर बेटामन ओ मेढ़ा के मुड़ म अपन हांथ रखिन। ");
INSERT INTO hne_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","मूसा ह ओ मेढ़ा ला बलि करिस अऊ ओकर कुछू लहू ला लेके हारून के जेवनी कान ऊपर, जेवनी हांथ के अंगठा ऊपर अऊ जेवनी गोड़ के अंगठा ऊपर लगाईस। ");
INSERT INTO hne_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","मूसा ह हारून के बेटामन ला घलो आघू म लानिस अऊ कुछू लहू ला ओमन के जेवनी कान ऊपर, ओमन के जेवनी हांथ के अंगठा ऊपर अऊ ओमन के जेवनी गोड़ के अंगठा ऊपर लगाईस। तब मूसा ह बांचे लहू ला बेदी के चारों मुड़ा म छिंच दीस। ");
INSERT INTO hne_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ओकर बाद, ओह चरबी, चरबीवाला पुंछी, पेट के भीतरी भाग के चरबी, करेजा के लम्बा निकले भाग, चरबी समेत दूनों गुरदा अऊ ओकर जेवनी जांघ ला लीस। ");
INSERT INTO hne_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","अऊ यहोवा के आघू म माढ़े बिगर खमीर के बनाय गे टुकनी के रोटी म ले ओमा के एक गोल रोटी, जैतून तेल म सनाय एक ठन मोटा रोटी, अऊ एक ठन पातर रोटी लीस, अऊ ओह येमन ला चरबीवाले भाग अऊ जेवनी जांघ ऊपर रख दीस। ");
INSERT INTO hne_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","तब ओह ये जम्मो ला हारून अऊ ओकर बेटामन के हांथ म रखिस अऊ ओमन येला यहोवा के आघू म एक हलाय-बलिदान के रूप म हलाईन। ");
INSERT INTO hne_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","तब मूसा ह येला ओमन के हांथ ले लेय लीस अऊ येला होम-बलिदान के ऊपर बेदी म यहोवा बर एक सुख-देवइया सुगंध के रूप म, अभिसेक-बलिदान, एक जेवन-बलिदान करके जला दीस। ");
INSERT INTO hne_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","मूसा ह छाती ला घलो लीस, जऊन ह अभिसेक मेढ़ा के ओकर बांटा रिहिस, अऊ ओला यहोवा के आघू म एक हलाय-बलिदान के रूप म हलाईस, जइसने कि यहोवा ह मूसा ला हुकूम देय रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","तब मूसा ह बेदी म ले कुछू अभिसेक के तेल अऊ कुछू लहू लीस अऊ ओला हारून अऊ ओकर ओनहामन म अऊ ओकर बेटामन अऊ ओमन के ओनहामन म छिंचिस। ये किसम ले ओह हारून अऊ ओकर ओनहामन के, अऊ ओकर बेटामन अऊ ओमन के ओनहामन के संस्कार करिस। ");
INSERT INTO hne_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","मूसा ह तब हारून अऊ ओकर बेटामन ला कहिस, “मिलापवाला तम्बू के प्रवेस दुवार म ओ मांस ला रांधव अऊ ओला अभिसेक-बलिदान के टुकनी के रोटी संग उहां खावव, जइसने कि परमेसर ह हुकूम देय रिहिस: ‘हारून अऊ ओकर बेटामन भेंट के चीजमन ला खावंय।’ ");
INSERT INTO hne_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","तब जऊन मांस अऊ रोटी बांच जाथे, ओला जला देवंव। ");
INSERT INTO hne_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","तुमन सात दिन तक मिलापवाला तम्बू के मुंहटा के बाहिर झन जावव, जब तक कि तुम्हर अभिसेक के दिन ह पूरा नइं हो जावय, काबरकि तुम्हर अभिसेक ह सात दिन तक चलही। ");
INSERT INTO hne_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","आज जऊन कुछू करे गीस, येला करे के हुकूम यहोवा ह देय रिहिस, ताकि तुम्हर प्रायस्चित के बिधि पूरा होवय। ");
INSERT INTO hne_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","तुम्हर बर ये जरूरी ए कि तुमन मिलापवाला तम्बू के मुंहटा म रात अऊ दिन सात दिन तक ठहिरव अऊ यहोवा जइसने कहे हवय, वइसने करव, ताकि तुमन झन मरव; काबरकि मोला अइसने ही हुकूम दिये गे हवय।” ");
INSERT INTO hne_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","हारून अऊ ओकर बेटामन ओ जम्मो चीज करिन, जेकर हुकूम यहोवा ह मूसा के दुवारा देय रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठवां दिन मूसा ह हारून अऊ ओकर बेटामन ला अऊ इसरायल के अगुवामन ला बलाईस। ");
INSERT INTO hne_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","अऊ ओह हारून ला कहिस, “पाप-बलिदान बर एक ठन बिगर दोस के बछवा अऊ होम-बलिदान करे बर एक ठन बिगर दोस के मेढ़ा ला लेके यहोवा के आघू म चघा। ");
INSERT INTO hne_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","तब इसरायलीमन ला ये कह: ‘तुमन पाप-बलिदान करे बर एक ठन बोकरा अऊ होम-बलिदान बर एक ठन बछवा अऊ एक ठन बिगर दोस के मेढ़ा-पीला ला ले आवव। ");
INSERT INTO hne_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","अऊ यहोवा के आघू म चघाय बर मेल-बलिदान के खातिर एक ठन बछवा अऊ एक ठन मेढ़ा अऊ जैतून तेल म सनाय अन्न-बलिदान ले आवव, काबरकि यहोवा ह आज तुमन करा परगट होही।’ ” ");
INSERT INTO hne_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","मूसा ह जऊन कुछू लाने के हुकूम देय रिहिस, ओमन ओला मिलापवाला तम्बू के आघू म ले आईन, अऊ पूरा सभा ह लकठा म आके यहोवा के आघू म ठाढ़ हो गीस। ");
INSERT INTO hne_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","तब मूसा ह कहिस, “येह ओ काम ए, जऊन ला करे के हुकूम यहोवा ह तुमन ला देय हवय, जेकर ले यहोवा के महिमा तुमन म परगट होवय।” ");
INSERT INTO hne_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","तब मूसा ह हारून ला कहिस, “यहोवा के हुकूम के मुताबिक बेदी करा आ अऊ अपन पाप-बलिदान अऊ अपन होम-बलिदान ला चघा अऊ अपन अऊ मनखेमन बर प्रायस्चित कर; मनखेमन बर चढ़ावा ला चघा अऊ ओमन बर प्रायस्चित कर।” ");
INSERT INTO hne_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","अऊ हारून ह बेदी करा आके ओ बछवा ला जऊन ह ओकर पाप-बलिदान के खातिर रिहिस, बलि करिस। ");
INSERT INTO hne_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","हारून के बेटामन ओकर करा लहू ला ले गीन अऊ ओह ओ लहू म अपन अंगठी ला बुड़ोके बेदी के सींगमन म चुपरिस अऊ बांचे लहू ला बेदी के खाल्हे म रितो दीस। ");
INSERT INTO hne_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","पाप-बलिदान के चरबी, गुरदामन ला अऊ करेजा के सबले बने भाग ला ओह बेदी म जला दीस, जइसे कि यहोवा ह मूसा ला हुकूम देय रिहिस, ");
INSERT INTO hne_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","पर ओह मांस अऊ खाल ला डेरा के बाहिर म जलाईस। ");
INSERT INTO hne_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","तब ओह होम-बलिदान के पसु के बलि चघाईस अऊ हारून के बेटामन लहू ला ओकर हांथ म दीन अऊ ओह ओला बेदी के ऊपर जम्मो कोति छिंच दीस। ");
INSERT INTO hne_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","तब ओमन होम-बलिदान के पसु ला कुटा-कुटा करके मुड़ समेत ओकर हांथ म दे दीन अऊ ओह ओमन ला बेदी म जला दीस। ");
INSERT INTO hne_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ओह पेट के भीतरी भागमन ला अऊ गोड़मन ला धोके ओमन ला होम-बलिदान के ऊपर बेदी म जला दीस। ");
INSERT INTO hne_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","तब हारून ह मनखेमन के बलिदान ला लानके अऊ पाप-बलिदान के बोकरा ला, जऊन ह मनखेमन के खातिर रिहिस, लेके ओला बलि करिस अऊ पहिली बलि असन ओला पाप-बलिदान खातिर चघाईस। ");
INSERT INTO hne_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","तब होम-बलिदान के पसु ला घलो लकठा म लानके बिधि-बिधान के मुताबिक बलिदान चघाईस। ");
INSERT INTO hne_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","फेर ओह बिहनियां के होम-बलिदान के अलावा अन्न-बलिदान ला लकठा म लानके ओमा ले मुठा भर बलिदान ला बेदी म जला दीस। ");
INSERT INTO hne_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ओकर बाद ओह बछवा अऊ मेढ़ा ला, जऊन ह मनखेमन कोति ले मेल-बलिदान रिहिस, बलि करिस अऊ हारून के बेटामन लहू ला ओकर हांथ म दीन अऊ ओह ओला बेदी म जम्मो कोति छिंच दीस। ");
INSERT INTO hne_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","पर ओमन बछवा अऊ मेढ़ा के चरबी, मोटहा पुंछी, अऊ चरबी के परत, गुरदा अऊ करेजा के सबले बने भाग— ");
INSERT INTO hne_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","येमन ला छाती म मढ़ा दीन, अऊ तब हारून ह ओमन ला बेदी म जला दीस। ");
INSERT INTO hne_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","छाती अऊ जेवनी जांघ ला हारून ह मूसा के हुकूम के मुताबिक हलाय-बलिदान के रूप म यहोवा के आघू म हलाईस। ");
INSERT INTO hne_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","तब हारून ह ओमन कोति हांथमन ला लमाके ओमन ला आसीस दीस, अऊ पाप-बलिदान, होम-बलिदान, अऊ मेल-बलिदान ला चघाके बेदी करा ले खाल्हे उतर आईस। ");
INSERT INTO hne_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","फेर मूसा अऊ हारून मिलापवाला तम्बू म गीन। जब ओमन उहां ले निकलिन, त ओमन मनखेमन ला आसीस दीन; अऊ यहोवा के महिमा जम्मो मनखेमन ऊपर परगट होईस। ");
INSERT INTO hne_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","तब यहोवा के आघू ले आगी निकलके चरबी समेत होम-बलिदान ला बेदी म भसम कर दीस। जब मनखेमन ये देखिन, त ओमन जय-जयकार के नारा लगाईन अऊ मुहूं के भार गिरके यहोवा ला दंडवत करिन। ");
INSERT INTO hne_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","तब नादाब अऊ अबीहू नांव के हारून के बेटामन अपन-अपन धूपदान ला लेके ओमन म आगी भरिन अऊ धूप डारिन; अऊ ओ आगी ला यहोवा ला चघाईन, जेकर हुकूम यहोवा ह नइं देय रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","एकरसेति यहोवा करा ले आगी निकलिस अऊ ओमन ला जला दीस अऊ ओमन यहोवा के आघू म मर गीन। ");
INSERT INTO hne_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","मूसा ह तब हारून ला कहिस, “येह ओ बात ए, जऊन ला यहोवा ह कहिस: “ ‘जऊन मन मोर लकठा म आथें ओमन के आघू म में पबितर साबित होहूं; जम्मो मनखेमन के आघू म मोर आदर होही।’ ” हारून ह तब चुपेचाप रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मूसा ह हारून के कका उजीएल के बेटा मिसाएल अऊ एलसाफान ला बलाईस, अऊ ओमन ला कहिस, “इहां आवव, अऊ अपन चचेरा-भाईमन के देहें ला पबितर-स्थान के आघू ले उठाके डेरा के बाहिर ले जावव।” ");
INSERT INTO hne_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","तब मूसा के हुकूम के मुताबिक ओमन आईन अऊ ओमन ला ओमन के अंगरखा समेत डेरा के बाहिर ले गीन। ");
INSERT INTO hne_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","तब मूसा ह हारून अऊ ओकर आने बेटा एलिआजर अऊ ईतामार ला कहिस, “तुमन अपन मुड़ के चुंदी ला खुला झन छोंड़व अऊ अपन ओनहा ला झन चीरव; नइं तो तुमन घलो मर जाहू अऊ जम्मो मनखेमन के ऊपर यहोवा के गुस्सा भड़कही। पर तुम्हर रिस्तेदार, याने कि जम्मो इसरायलीमन ओमन बर सोक मनावंय, जऊन मन ला यहोवा ह आगी म नास कर दे हवय। ");
INSERT INTO hne_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","तुमन मिलापवाला तम्बू के मुंहटा के बाहिर झन जावव, नइं तो तुमन घलो मर जाहू, काबरकि यहोवा के अभिसेक के तेल तुमन ऊपर लगे हवय।” ओमन मूसा के कहे मुताबिक करिन। ");
INSERT INTO hne_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","तब यहोवा ह हारून ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“जब कभू तें अऊ तोर बेटामन मिलापवाला तम्बू म जाथव, त तुमन अंगूर के मंद या कोनो अऊ किसम के मंद पीके झन जावव, नइं तो तुमन मर जाहू। येह तुम्हर अवइया पीढ़ी के मनखेमन बर हमेसा के बिधि-बिधान अय, ");
INSERT INTO hne_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ताकि तुमन पबितर अऊ सधारन म, सुध अऊ असुध म फरक कर सकव, ");
INSERT INTO hne_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","अऊ इसरायलीमन ला ओ जम्मो बिधिमन ला सिखो सकव, जेमन ला यहोवा ह मूसा के दुवारा ओमन ला देय हवय।” ");
INSERT INTO hne_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","मूसा ह हारून अऊ ओकर बांचे बेटा एलिआजर अऊ ईतामार ला कहिस, “बिगर खमीर ले बने जऊन जेवन-बलिदान यहोवा ला चघाय गे रिहिस, ओमा के बांचे अन्न-बलिदान ला लेवव अऊ ओला बेदी के बाजू म खावव, काबरकि ओह महा पबितर अय। ");
INSERT INTO hne_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","येला तुमन पबितर-स्थान के छेत्र म खावव, काबरकि येह यहोवा ला चघाय जेवन-बलिदान म ले तोर अऊ तोर बेटामन के बांटा ए, अऊ मोला अइसने हुकूम मिले हवय। ");
INSERT INTO hne_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","पर हलाय गे छाती अऊ अरपन करे गे जांघ ला तुमन अऊ तुम्हर बेटा-बेटीमन खा सकत हें। ओमन ला बिधि के मुताबिक साफ करे गे जगह म खावव; काबरकि ओ चीजमन इसरायलीमन के मेल-बलिदान के तुम्हर बांटा के रूप म, तुमन अऊ तुम्हर लइकामन ला दिये गे हवय। ");
INSERT INTO hne_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","चघाय गे जांघ अऊ हलाय गे छाती ला जेवन-बलिदान के चरबीवाले भागमन के संग लाय जावय, अऊ येमन ला हलाय-बलिदान के रूप म यहोवा के आघू म हलाय जावय। येह तुम्हर अऊ तुम्हर लइकामन के हमेसा के बांटा होही, जइसने कि यहोवा ह हुकूम दे हवय।” ");
INSERT INTO hne_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","जब मूसा ह पाप-बलिदान के बोकरा के बारे म पुछताछ करिस, त पता चलिस कि ओला तो जला देय गे हवय; येकरे कारन ओह हारून के बांचे बेटामन एलिआजर अऊ ईतामार ऊपर गुस्सा होईस, अऊ ओमन ले पुछिस, ");
INSERT INTO hne_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“तुमन पाप-बलिदान के मांस ला पबितर-स्थान के छेत्र म काबर नइं खायेव? येह महा पबितर अय; येह एकर खातिर देय गे रिहिस कि यहोवा के आघू म सभा बर प्रायस्चित करके ओमन के दोस ला दूर करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","जब एकर लहू ला पबितर स्थान के भीतर म लाने ही नइं गीस, त तुमन ला बोकरा के मांस ला पबितर-स्थान के छेत्र म खाना रिहिस, जइसने कि मेंह तुमन ला हुकूम देय रहेंव।” ");
INSERT INTO hne_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","हारून ह मूसा ला जबाब दीस, “आज ही ओमन अपन पाप-बलिदान अऊ होम-बलिदान यहोवा के आघू म चघाय हवंय, पर अइसने बात मोर संग होईस। कहूं में आज पाप-बलिदान के मांस ला खाय रहितंय, त का यहोवा के आघू म ये बने बात होतिस?” ");
INSERT INTO hne_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जब मूसा ह ये सुनिस, त ये बात ओला बने लगिस। ");
INSERT INTO hne_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","यहोवा ह मूसा अऊ हारून ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इसरायलीमन ला कहव: ‘भुइयां के ऊपर जतेक जीयत पसुमन हवंय, ओमा ले तुमन येमन ला खा सकत हव: ");
INSERT INTO hne_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","तुमन कोनो भी अइसने पसु ला खा सकत हव, जेकर फटे खुर हवय अऊ ओह पागुर करथे। ");
INSERT INTO hne_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘कुछू पसुमन होथें, जऊन मन या तो सिरिप पागुर करथें या फेर सिरिप फटे खुर के होथें; ओमन ला तुमन झन खाहू। ऊंट—हालाकि येह पागुर करथे, पर येकर खुर फटे नइं रहय; येह तुम्हर बर बिधि के मुताबिक असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","कबर-बिज्जू—हालाकि येह पागुर करथे, पर येकर खुर फटे नइं रहय; येह तुम्हर बर असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","खरगोस—हालाकि येह पागुर करथे, पर येकर खुर फटे नइं रहय; येह तुम्हर बर असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","अऊ सूरा घलो—हालाकि येकर खुर ह फटे रहिथे, पर येह पागुर नइं करय; येह तुम्हर बर असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","तुमन ये पसुमन के मांस झन खावव या ओमन के लास ला झन छुवव; ओमन तुम्हर बर असुध अंय। ");
INSERT INTO hne_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘समुंदर अऊ नदी के पानी म जतेक जीयत जीव-जन्तु हवंय, ओमा के जेकर पंख अऊ बिस्सर छिलका होथे, ओमन ला तुमन खा सकत हव। ");
INSERT INTO hne_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","पर समुंदर अऊ नदी के ओ जम्मो जीव-जन्तु, जेकर पंख अऊ बिस्सर छिलका नइं होवय—चाहे उड़नेवाला जीव होवंय या पानी के दूसर जीयत जीव-जन्तु होवंय—तुमन ओमन ला असुध समझव। ");
INSERT INTO hne_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","अऊ जब तुमन ओमन ला असुध समझथव, त तुमन ओमन के मांस ला झन खावव; तुमन ओमन के लास ला घलो असुध समझव। ");
INSERT INTO hne_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","पानी के कोनो घलो जीयत जन्तु, जेकर पंख अऊ बिस्सर छिलका नइं होवय, ओह तुम्हर दुवारा असुध समझे जावय। ");
INSERT INTO hne_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘येमन ओ चिरई अंय, जेमन ला तुमन असुध समझव अऊ झन खावव, काबरकि ओमन असुध अंय: चील, गिधवा, करिया गिधवा, ");
INSERT INTO hne_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","लाल चील, कोनो भी किसम के करिया चील, ");
INSERT INTO hne_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","कोनो भी किसम के कऊआ ");
INSERT INTO hne_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","सींगवाला उल्लू, चिचियानेवाला उल्लू, समुंदरी चिरई, कोनो भी किसम के बाज, ");
INSERT INTO hne_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","छोटे घुघवा, हाड़गील, बड़े घुघवा, ");
INSERT INTO hne_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","सफेद घुघवा, सुनसान जगह के घुघवा, समुंदरी बाज, ");
INSERT INTO hne_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","सारस, कोनो भी किसम के कोकड़ा, टिटहरी अऊ चमगीदड़। ");
INSERT INTO hne_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘जम्मो उड़नेवाला कीरामन, जऊन मन चारों गोड़ म रेंगथें, ओमन तुम्हर बर असुध अंय। ");
INSERT INTO hne_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","पर कुछू उड़नेवाला कीरा, जेमन चारों गोड़ म रेंगथें, ओमन ला खा सकत हव: जेमन के गोड़मन भुइयां म कूदे-फांदे बर जूरे होथे। ");
INSERT INTO hne_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","येमन ला खा सकत हव—कोनो घलो किसम के टिड्डी, फनगे, झिंगुर अऊ फांफा। ");
INSERT INTO hne_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","पर आने जम्मो किसम के उड़नेवाला कीरा, जेमन के चार गोड़ हवय, ओमन ला तुमन असुध समझव। ");
INSERT INTO hne_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘तुमन ये काम करे के दुवारा अपनआप ला असुध ठहिराहू; जऊन कोनो ओमन के लास ला छूथे, ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","जऊन कोनो ओमन के कोनो लास ला उठाथे, त ओह अपन ओनहा ला धोवय, अऊ संझा के होवत ले असुध ठहिरय। ");
INSERT INTO hne_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘हर ओ पसु, जेकर खुर फटे नइं ए या जेह पागुर नइं करय, ओह तुम्हर बर असुध अय; जऊन कोनो ओमन के कोनो घलो लास ला छूथे, ओह असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","चारों गोड़ म रेंगइया जम्मो पसु, जेमन अपन पंजा म रेंगथें, ओमन तुम्हर बर असुध अंय। जऊन कोनो ओमन के लास ला छूथे, ओह संझा के होवत ले असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","जऊन कोनो ओमन के लास ला उठाथे, ओह अपन ओनहा ला धोवय, अऊ संझा के होवत ले असुध ठहिरय। ये पसुमन तुम्हर बर असुध अंय। ");
INSERT INTO hne_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘भुइयां म रेंगइया पसु म ले, येमन तुम्हर बर असुध अंय: नेवला, मुसवा, कोनो घलो किसम के बड़े टेटका, ");
INSERT INTO hne_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","छिपकली, गोइहा, भीथी के टेटका, सांडा अऊ छोटे टेटका ");
INSERT INTO hne_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","भुइयां म रेंगइया जम्मो पसुमन ले, येमन तुम्हर बर असुध अंय। जऊन कोनो येमन के लास ला छूथे, ओह संझा के होवत ले असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","जब येमन म के कोनो ह मर जाथे, अऊ ओह कोनो चीज के ऊपर गिरथे, त ओ चीज ह असुध ठहिरही, ओह कोनो घलो चीज होवय, चाहे ओह कठवा के बने होवय, या ओनहा, या खाल, या बोरा के बने होवय। ओला पानी म डारे जावय अऊ संझा के होवत ले ओह असुध ठहिरही, अऊ तब ओह सुध हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","यदि ये पसु म के कोनो ह माटी के कोनो बरतन म गिरथे, त ओ बरतन के जम्मो चीज ह असुध ठहिरही; तुमन ओ बरतन ला टोर देवव। ");
INSERT INTO hne_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","कोनो किसम के जेवन, जेला तुमन खा सकत हव, पर यदि ओह अइसने बरतन के पानी म छू जाथे, त ओ जेवन ह असुध अय, अऊ कहूं अइसने बरतन म कोनो पीये के चीज हवय, त ओह घलो असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ओमन के लास म के कोनो भाग ह येमा के कोनो चीज म गिर जावय, चाहे ओह चूल्हा होवय या रांधे के बरतन, ओला टोर दिये जावय। ओमन असुध अंय, अऊ तुमन ओमन ला असुध समझव। ");
INSERT INTO hne_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","पर सोता या तरिया, जेमा पानी ह संकलाथे, यदि कोनो मरे पसु ओमा मिलथे, त ओ पानी ह सुध रहिथे, फेर जऊन कोनो येमन के लास ला छूथे, ओह असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","कहूं कोनो लास ह कोनो किसम के बीजा ऊपर गिरथे, जेला बोये बर रखे गे हवय, त ओ बीजा ह सुध बने रहिही। ");
INSERT INTO hne_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","फेर कहूं बीजा ऊपर पानी डारे गे हवय अऊ कोनो लास ह ओमा गिर जाथे, त ओ बीजा ह तुम्हर बर असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘कोनो पसु, जेला खाय के अनुमति तुमन ला हवय, यदि ओह मर जाथे, अऊ जऊन कोनो ओकर लास ला छूथे, ओह संझा के होवत ले असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","जऊन कोनो ओकर लास म ले कुछू खाथे, ओह अपन ओनहा ला धोवय, अऊ ओह संझा के होवत ले असुध ठहिरही। जऊन कोनो ओकर लास ला उठावय, ओह घलो अपन ओनहा ला धोवय, अऊ ओह संझा के होवत ले असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘भुइयां म रेंगइया जम्मो जीव ला असुध समझे जावय; ओमन ला झन खाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","तुमन भुइयां म रेंगइया कोनो जीव या परानी ला झन खावव, चाहे ओह पेट के भार रेंगथे या चारों गोड़ म या अब्बड़ अकन गोड़ म रेंगथे; येह असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","येमा के कोनो घलो जीव के दुवारा अपनआप ला असुध झन करव। तुमन कोनो घलो हालत म अपनआप ला ओमन के दुवारा असुध झन करव या ओमन के दुवारा असुध झन होवव। ");
INSERT INTO hne_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","मेंह यहोवा तुम्हर परमेसर अंव; अपनआप ला सुध करव अऊ पबितर बनव, काबरकि मेंह पबितर अंव। भुइयां म रेंगइया कोनो घलो जीव के दुवारा अपनआप ला असुध झन करव। ");
INSERT INTO hne_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","मेंह यहोवा अंव, जऊन ह तुमन ला मिसर देस ले निकालके लाने हंव कि मेंह तुम्हर परमेसर होवंव; एकरसेति तुमन पबितर बनव, काबरकि मेंह पबितर अंव। ");
INSERT INTO hne_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘पसु, चिरई, पानी म रेंगइया-बुलइया जम्मो जीव अऊ भुइयां म रेंगइया जम्मो परानी के बिसय म इही ह नियम अय। ");
INSERT INTO hne_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","येह जरूरी अय कि तुमन सुध अऊ असुध म भेद करव, अऊ खाय जानेवाला जीयत परानी अऊ नइं खाय जानेवाला परानीमन ला जानव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इसरायलीमन ला कह: ‘ओ माईलोगन, जऊन ह देहें म होके बेटा ला जनम देथे, ओह सात दिन तक बिधि के मुताबिक असुध रहिही, जइसने कि ओह माहवारी के समय म असुध रहिथे। ");
INSERT INTO hne_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","जनमे बेटा के आठवां दिन म खतना करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ओकर बाद ओ छेवारीन ह अपन बहत लहू ले सुध होय बर तैंतीस दिन तक अगोरय। जब तक ओकर सुध होय के दिन ह पूरा नइं हो जावय, तब तक ओह न तो कोनो पबितर चीज ला छुवय अऊ न ही पबितर-स्थान म जावय। ");
INSERT INTO hne_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","कहूं ओ माईलोगन ह बेटी ला जनम देथे, तब ओह दू हप्ता तक असुध रहिही, जइसने कि माहवारी के समय म रहिथे। तब ओह अपन बहत लहू ले सुध होय बर छैंसठ दिन तक अगोरय। ");
INSERT INTO hne_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘जब ओ छेवारीन के सुध होय के दिन ह पूरा हो जावय, चाहे ओला बेटा होय रहय या बेटी, ओह होम-बलिदान बर एक बछर के मेढ़ा-पीला अऊ पाप-बलिदान बर एक ठन परेवा पीला या एक ठन पंड़की मिलापवाला तम्बू म पुरोहित करा लानय। ");
INSERT INTO hne_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","तब पुरोहित ह ओ माईलोगन बर प्रायस्चित के नियम ला पूरा करे बर ओमन ला यहोवा के आघू म चघावय, अऊ तब ओह अपन बहत लहू ले बिधि के मुताबिक सुध हो जाही। “ ‘येमन छेवारीन बर बिधि अंय, जऊन ह कोनो बेटा या बेटी ला जनम देथे। ");
INSERT INTO hne_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","पर कहूं ओ छेवारीन ह मेढ़ा-पीला नइं दे सकय, त ओह पंड़की के एक जोड़ा या दू ठन परेवा पीला लेके आवय, जेमा के एक ठन ह होम-बलिदान अऊ दूसर ह पाप-बलिदान के रूप म चघाय जावय। ये किसम ले, पुरोहित ह ओकर बर प्रायस्चित के बिधि ला पूरा करही, अऊ ओह सुध हो जाही।’ ” ");
INSERT INTO hne_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","यहोवा ह मूसा अऊ हारून ला फेर कहिस, ");
INSERT INTO hne_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“जब कोनो मनखे के चमड़ी म सूजन या चकत्ता या चमकत कोनो दाग होवय, जऊन ह चमड़ी के कोनो असुध करइया बेमारी हो सकत हे, त ओला हारून पुरोहित या ओकर पुरोहित बेटामन म ले एक झन करा लाने जावय। ");
INSERT INTO hne_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","पुरोहित ह ओकर चमड़ी के बेमारी के जांच करय, अऊ यदि बेमारी के जगह के रूआंमन सफेद हो गे हवंय अऊ बेमारी ह ओकर देहें के चमड़ी ले गहरा दिखय, त येह एक चमड़ी के असुध करइया बेमारी अय। जब पुरोहित ह ओ मनखे के जांच कर लेवय, तब ओह ओला बिधि मुताबिक असुध ठहिरावय। ");
INSERT INTO hne_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","कहूं ओ चमकत दाग ह सफेद हवय, पर चमड़ी ले गहरा नइं दिखथे अऊ उहां के रूआंमन सफेद नइं होय हवंय, त पुरोहित ह ओ बेमारीवाला मनखे ला सात दिन तक अलग रखय। ");
INSERT INTO hne_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","सातवां दिन, पुरोहित ह ओला फेर जांचय, अऊ यदि ओह देखय कि दाग म कोनो बदलाव नइं ए अऊ बेमारी ह चमड़ी म नइं बगरे हे, त पुरोहित ह ओला अऊ सात दिन तक अलग रखय। ");
INSERT INTO hne_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","सातवां दिन, पुरोहित ह ओला फेर जांचय, अऊ कहूं दाग के चमकई ह कम हो गे हवय अऊ चमड़ी म नइं बगरे हवय, तब पुरोहित ह ओला सुध ठहिरावय; येह सिरिप एक चकत्ता अय। ओह अपन ओनहा ला धोवय, अऊ ओह सुध हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","पर पुरोहित ला देखाय अऊ सुध ठहिराय के बाद, यदि ओकर चमड़ी म चकत्ता ह बगर जाथे, त ओ मनखे ह फेर पुरोहित करा जावय। ");
INSERT INTO hne_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","पुरोहित ह ओ मनखे के जांच करय, अऊ कहूं चकत्ता ह चमड़ी म बगर गे हवय, तब पुरोहित ह ओला असुध ठहिरावय; येह चमड़ी के एक असुध करइया बेमारी अय। ");
INSERT INTO hne_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“जब कोनो मनखे ला चमड़ी के असुध करइया बेमारी हवय, त ओला पुरोहित करा लाने जावय। ");
INSERT INTO hne_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","पुरोहित ह ओला जांचय, अऊ कहूं चमड़ी के सूजनवाले जगह ह सफेद हो गे हवय अऊ उहां के रूआंमन घलो सफेद हो गे हवंय, अऊ ओ सूजन के जगह म मांस दिखथे, ");
INSERT INTO hne_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","त येह एक पुराना चमड़ी के रोग अय, अऊ पुरोहित ह ओला असुध ठहिरावय। ओह ओला अलग झन रखय, काबरकि ओ मनखे ह पहिले से ही असुध हवय। ");
INSERT INTO hne_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“कहूं बेमारी ह मनखे के जम्मो चमड़ी म बगर गे हवय, अऊ पुरोहित ह देखथे कि ओ मनखे के मुड़ ले लेके गोड़ तक जम्मो चमड़ी म बेमारी हो गे हवय, ");
INSERT INTO hne_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","त पुरोहित ह ओला धियान से जांचय, अऊ यदि बेमारी ह ओकर जम्मो देहें म हो गे हवय, त ओह ओ मनखे ला सुध ठहिरावय। जब ओकर पूरा देहें ह सफेद हो गे हवय, त ओह सुध अय। ");
INSERT INTO hne_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","पर जब कभू ओकर चमड़ी म मांस दिखे लगय, तब ओह असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","जब पुरोहित ह ओमा मांस देखथे, त ओह ओ मनखे ला असुध ठहिरावय। खुला मांस ह असुध अय; ओला एक असुध करइया बेमारी हवय। ");
INSERT INTO hne_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","कहूं ओ खुला मांस ह ठीक होके सफेद हो जाथे, त ओ मनखे ह पुरोहित करा जावय। ");
INSERT INTO hne_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","पुरोहित ह ओकर जांच करय, अऊ कहूं घाव ह सफेद हो गे हवय, त पुरोहित ह ओ बिमरहा मनखे ला सुध ठहिरावय; तब ओह सुध हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“जब काकरो चमड़ी म फोड़ा हवय अऊ ओह बने हो जाथे, ");
INSERT INTO hne_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","अऊ ओ फोड़ा के जगह म सफेद सूजन या लाल-सफेद दाग दिखथे, त ओह अपनआप ला पुरोहित ला देखावय। ");
INSERT INTO hne_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","पुरोहित ह येकर जांच करय, अऊ कहूं ओ दाग ह चमड़ी ले जादा गहिरा दिखय अऊ येमा के रूआंमन सफेद हो गे हवंय, त पुरोहित ह ओ मनखे ला असुध ठहिरावय। येह चमड़ी के असुध करइया बेमारी अय, जऊन ह फोड़ा म ले फूटके निकले हवय। ");
INSERT INTO hne_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","पर यदि, जब पुरोहित ह येकर जांच करथे, अऊ ओला येमा सफेद रूआं नइं दिखय अऊ येह चमड़ी ले गहिरा नइं ए अऊ ओकर चमक ह कम हो गे हवय, त पुरोहित ह ओला सात दिन तक अलग रखय। ");
INSERT INTO hne_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","पर कहूं येह चमड़ी म बगरत हवय, तब पुरोहित ह ओला असुध ठहिरावय; येह एक असुध करइया बेमारी अय। ");
INSERT INTO hne_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","पर कहूं दाग ह नइं बदले हवय अऊ येह नइं बगरे हवय, त येह सिरिप फोड़ा के एक दाग अय, अऊ पुरोहित ह ओ मनखे ला सुध ठहिरावय। ");
INSERT INTO hne_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“जब कोनो मनखे के चमड़ी ह जर जाथे अऊ ओ जरे जगह के मांस म लाल-सफेद या सफेद दाग दिखथे, ");
INSERT INTO hne_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","तब पुरोहित ह ओ दाग के जांच करय। अऊ कहूं दाग म के रूआंमन सफेद हो गे हवंय अऊ येह चमड़ी ले गहिरा हो गे हवय, त येह एक असुध करइया बेमारी अय, जऊन ह ओ जरे के जगह म फूटके निकले हवय। पुरोहित ह ओ मनखे ला असुध ठहिरावय; येह एक चमड़ी के असुध करइया रोग अय। ");
INSERT INTO hne_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","पर कहूं पुरोहित ह येकर जांच करथे अऊ ओ दाग म कोनो सफेद रूआं नइं दिखय अऊ यदि येह चमड़ी ले गहिरा नइं हवय अऊ येकर चमक ह कम हो गे हवय, त पुरोहित ह ओ मनखे ला सात दिन तक अलग रखय। ");
INSERT INTO hne_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","सातवां दिन पुरोहित ह ओ मनखे के जांच करय, अऊ कहूं बेमारी ह चमड़ी म बगरत हवय, त पुरोहित ह ओ मनखे ला असुध ठहिरावय; येह चमड़ी के एक असुध करइया बेमारी अय। ");
INSERT INTO hne_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","फेर कहूं ओ दाग ह नइं बदले हवय अऊ चमड़ी म नइं बगरे हवय अऊ ओकर चमक ह कम हो गे हवय, त येह जरे के कारन एक सूजन अय, अऊ पुरोहित ह ओ मनखे ला सुध ठहिरावय; येह जरे के सिरिप एक दाग अय। ");
INSERT INTO hne_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“कहूं कोनो आदमी या माईलोगन के मुड़ या थोथना म कोनो घाव हवय, ");
INSERT INTO hne_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","त पुरोहित ह ओ घाव के जांच करय अऊ कहूं येह चमड़ी ले गहिरा दिखय, अऊ येमा के रूआं ह पीला रंग के अऊ पातर दिखय, त पुरोहित ह ओला असुध ठहिरावय; येह मुड़ या थोथना म चमड़ी के एक असुध करइया बेमारी अय। ");
INSERT INTO hne_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","पर यदि, जब पुरोहित ह घाव ला जांच करथे, अऊ येह चमड़ी ले गहिरा नइं दिखय अऊ उहां करिया रूआं नइं ए, त पुरोहित ह ओ मनखे ला सात दिन तक अलग रखय। ");
INSERT INTO hne_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातवां दिन, पुरोहित ह ओकर घाव के जांच करय, अऊ कहूं येह नइं बगरे हवय, अऊ येमा कोनो पीला रंग के रूआं नइं ए अऊ येह चमड़ी ले गहिरा नइं दिखय, ");
INSERT INTO hne_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","त ओ आदमी या माईलोगन ह ओ घाव के जगह ला छोंड़के अपन बाल मुड़ा लेवय, अऊ पुरोहित ह ओला अऊ सात दिन तक अलग रखय। ");
INSERT INTO hne_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","फेर सातवां दिन, पुरोहित ह ओ घाव के जांच करय अऊ कहूं येह चमड़ी म नइं बगरे हवय अऊ चमड़ी ले गहिरा नइं दिखय, त पुरोहित ह ओ मनखे या माईलोगन ला सुध ठहिरावय। ओह अपन ओनहा ला धोवय, अऊ ओह सुध हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","पर सुध ठहिराय जाय के बाद, कहूं घाव ह चमड़ी म बगरथे, ");
INSERT INTO hne_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","त पुरोहित ह ओकर जांच करय, अऊ कहूं ओह देखथे कि घाव ह चमड़ी म बगर गे हवय, त ओला घाव के जगह म पीला रूआं देखे के जरूरत नइं ए; ओह असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","पर कहूं पुरोहित ह देखथे कि घाव ह नइं बदले हे, अऊ यदि येमा करिया रूआं जाम गे हे, त फेर ओ आदमी या माईलोगन ह बने हो गे हवय। ओह सुध अय, अऊ पुरोहित ह ओला सुध ठहिरावय। ");
INSERT INTO hne_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“जब कोनो आदमी या माईलोगन के चमड़ी म सफेद दाग हवय, ");
INSERT INTO hne_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","त पुरोहित ह ओकर जांच करय, अऊ कहूं ओकर दागमन हल्का सफेद हवंय, त येह नुकसान नइं करइया दाग अय, जऊन ह चमड़ी म निकले हवय; ओ मनखे ह सुध अय। ");
INSERT INTO hne_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“कोनो मनखे के मुड़ के चुंदी ह झर गे हवय अऊ ओह चंदुआ अय, त अइसने मनखे ह सुध अय। ");
INSERT INTO hne_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","कहूं कोनो मनखे के मुड़ के आघू के चुंदी झर गे हवय, त ओह माथा के चंदुआ अय; ओह सुध अय। ");
INSERT INTO hne_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","पर कहूं ओकर चंदुआ मुड़ या चंदुआ माथा म लाल-सफेद रंग के घाव हवय, त येह ओकर मुड़ या माथा म निकले एक असुध करइया बेमारी अय। ");
INSERT INTO hne_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","पुरोहित ह ओ मनखे के जांच करय अऊ कहूं ओकर मुड़ या माथा के फूले घाव ह लाल-सफेद रंग के चमड़ी के एक असुध करइया बेमारी सहीं अय, ");
INSERT INTO hne_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","त ओ मनखे ला बेमारी हो गे हे अऊ ओह असुध अय। ओकर मुड़ या माथा म घाव के कारन, पुरोहित ह ओला असुध ठहिरावय। ");
INSERT INTO hne_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“जऊन मनखे म अइसने असुध बेमारी हवय, ओह चिरहा-फटहा ओनहा पहिरय; ओकर चुंदी ह छरियाय रहय अऊ अपन चेहरा के खाल्हे भाग ला तोप के ओह चिचियावय, ‘असुध! असुध!’ ");
INSERT INTO hne_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जब तक ओ मनखे म बेमारी हवय, तब तक ओह असुध रहिथे। ओह अकेला रहय; ओह डेरा के बाहिर म रहय। ");
INSERT INTO hne_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“जब कोनो ओनहा ह असुध करइया बेमारी ले खराप हो जावय—चाहे ओ ओनहा ह ऊन के होवय या मलमल के होवय, ");
INSERT INTO hne_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","मलमल या ऊन के बिनाय या गंथाय कोनो चीज होवय, चाम या चाम के बने कोनो चीज होवय— ");
INSERT INTO hne_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","कहूं ओ ओनहा, चाम, बिनाय या गंथाय चीज, या कोनो चाम ले बने चीज के ओ बेमारीवाला भाग ह हरियर या लाली रंग के दिखय, त येह असुध करइया फफूंदी अय अऊ येला पुरोहित ला देखाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","पुरोहित ह बेमारी लगे भाग ला जांचय अऊ ओ चीज ला सात दिन तक अलग रखय। ");
INSERT INTO hne_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","सातवां दिन पुरोहित ह येकर फेर जांच करय, अऊ कहूं ओ बेमारी ह ओनहा, बिनाय या गंथाय चीज म, या चाम म बगर गे हवय, चाहे ओकर कोनो घलो उपयोग होथे, येह लगातार बने रहइया एक असुध बेमारी अय; ओ चीज ह असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ओह ओ ओनहा, ऊन या मलमल के बिनाय या गंथाय चीज, या कोनो चाम के बने चीज, जऊन ह खराप हो गे हवय, ओला जला देवय; काबरकि ओ असुध करइया फफूंदी ह लगातार बने रहिथे; ओ चीज ला जला दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“पर कहूं पुरोहित ह येला जांच करय, अऊ फफूंदी ह ओ ओनहा म, बिनाय या गंथाय चीज म, या चाम के चीज म नइं बगरे हवय, ");
INSERT INTO hne_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","त पुरोहित ह हुकूम देवय कि जऊन चीज ह खराप होय हवय, ओला धोय जावय। तब ओह ओ चीज ला सात दिन तक अलग रखय। ");
INSERT INTO hne_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ओ चीज ला धोय के बाद, पुरोहित ह ओला फेर जांच करय, अऊ कहूं फफूंदी म कोनो बदलाव नइं दिखय, अऊ हालाकि येह नइं बगरे हवय, तभो ले येह असुध अय। येला जला देवय, चाहे ओ चीज के कोनो घलो भाग खराप होय हवय। ");
INSERT INTO hne_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","पर यदि पुरोहित ह येला जांच करथे, अऊ ओ चीज ला धोय के बाद, फफूंदी के चमक ह कम हो गे हवय, त ओह ओ ओनहा, चाम, या बिनाय या गंथाय चीज के ओ खराप हिस्सा ला चीरके अलग कर देवय। ");
INSERT INTO hne_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","पर कहूं ओ बेमारी ओनहा म, बुने या गंथाय चीज म, या चाम के बने चीज म फेर दिखथे, त येह एक बगरनेवाला फफूंदी अय; अऊ ओ फफूंदीवाले चीज ला जला दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","कहूं कोनो ओनहा, बिनाय या गंथाय चीज, या चाम के कोनो चीज ला धोय गे हवय, अऊ ओमा के फफूंदी ह खतम हो गे हवय, त ओ चीज ला फेर धोय जावय। तब येह सुध होही।” ");
INSERT INTO hne_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ऊन या मलमल के ओनहा, बिनाय या गंथाय चीज, या चाम ले बने कोनो चीज म लगे फफूंद ला सुध या असुध ठहिराय के नियम येमन अंय। ");
INSERT INTO hne_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“जब कोनो बिमरहा मनखे ला पुरोहित करा लाय जाथे, त ओकर बिधि के मुताबिक सुध होय के नियम ये अंय: ");
INSERT INTO hne_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","पुरोहित ह डेरा के बाहिर जावय अऊ ओकर जांच करय। यदि ओह असुध करइया चमड़ी के बेमारी ले बने हो गे हवय, ");
INSERT INTO hne_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","त पुरोहित ह हुकूम देवय कि ओ मनखे ला सुध ठहिराय बर दू ठन जीयत अऊ सुध चिरई, देवदार के लकरी, लाल रंग के सूंत अऊ जूफा लाने जावय। ");
INSERT INTO hne_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","तब पुरोहित ह हुकूम देवय कि माटी के बरतन म ताजा पानी के ऊपर एक ठन चिरई ला बलि करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ओह तब ओ जीयत चिरई ला लेवय अऊ ओला देवदार के लकरी, लाल सूंत अऊ जूफा के संग ताजा पानी के ऊपर बलि करे गय चिरई के लहू म बुड़ोवय। ");
INSERT INTO hne_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","तब ओह ओ मनखे ला असुध करइया बेमारी ले सुध ठहिराय बर ओकर ऊपर सात बार छिंचय, अऊ तब ओला सुध ठहिरावय। ओकर बाद, ओ जीयत चिरई ला खुला जगह म छोंड़ देवय। ");
INSERT INTO hne_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“तब ओ मनखे जऊन ला सुध ठहिराय जाथे, ओह अपन ओनहा ला धोवय, अपन जम्मो चुंदी ला कतरावय अऊ पानी म नहावय; तब ओह बिधि के मुताबिक सुध होही। एकर बाद, ओह डेरा के भीतर आ सकत हे, पर सात दिन तक, ओह अपन तम्बू ले बाहिर रहय। ");
INSERT INTO hne_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातवां दिन ओह अपन जम्मो चुंदी ला मुड़वावय; ओह अपन मुड़, अपन दाढ़ी अऊ अपन भौंह के चुंदी अऊ बाकि चुंदी ला कतरावय। तब ओह अपन ओनहा ला धोवय अऊ पानी म नहावय, अऊ तब ओह सुध होही। ");
INSERT INTO hne_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“आठवां दिन, ओह एक-एक बछर के दू ठन निरदोस मेढ़ा-पीला अऊ एक बछर के एक ठन निरदोस भेड़ी-पीला लेके आवय अऊ अन्न-बलिदान बर संग म जैतून तेल म सनाय एक एपा के तीन-दसवां भाग बढ़िया पीसान लानय अऊ लोज भर तेल घलो लानय। ");
INSERT INTO hne_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ओ पुरोहित जऊन ह सुध ठहिराथे, ओह ओ मनखे ला अऊ ओकर बलिदानमन ला यहोवा के आघू म मिलापवाला तम्बू के मुंहटा करा लानय। ");
INSERT INTO hne_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“तब पुरोहित ह एक ठन मेढ़ा-पीला ला लेवय अऊ ओला दोस-बलिदान के रूप म, आधा लीटर तेल के संग यहोवा ला चघावय; ओह हलाय-बलिदान के रूप म ओमन ला यहोवा के आघू म हलाय। ");
INSERT INTO hne_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ओह मेढ़ा-पीला ला पबितर-स्थान के छेत्र म बलि करय, जिहां पाप-बलिदान अऊ होम-बलिदान के पसु ला बलि करे जाथे। पाप-बलिदान सहीं, दोस-बलिदान ह घलो पुरोहित के बांटा अय; येह महा पबितर अय। ");
INSERT INTO hne_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","पुरोहित ह दोस-बलिदान के कुछू लहू ला लेवय अऊ सुध होवइया मनखे के जेवनी कान के टीप म, ओकर जेवनी हांथ के अंगठा म अऊ ओकर जेवनी गोड़ के अंगठा म लगावय। ");
INSERT INTO hne_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","पुरोहित ह तब ओ आधा लीटर तेल म ले थोरकून लेवय अऊ अपन डेरी हांथ के हथेली म ढारय, ");
INSERT INTO hne_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","अऊ ओह अपन जेवनी हांथ के अंगठा के बाद वाले अंगठी ला डेरी हांथ के हथेली के तेल म बुड़ोवय, अऊ अपन अंगठी ले ओमा के कुछू तेल यहोवा के आघू म सात बार छिंचय। ");
INSERT INTO hne_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","अपन हथेली म बांचे कुछू तेल ला पुरोहित ह ओ सुध होवइया मनखे के जेवनी कान के टीप म, ओकर जेवनी हांथ के अंगठा म अऊ जेवनी गोड़ के अंगठा म, अऊ दोस-बलिदान के लहू के ऊपर म लगावय। ");
INSERT INTO hne_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","अपन हथेली म बांचे तेल ला, पुरोहित ह सुध होवइया मनखे के मुड़ म डार देवय अऊ यहोवा के आघू म ओ मनखे बर प्रायस्चित के बिधि ला पूरा करय। ");
INSERT INTO hne_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“तब पुरोहित ह पाप-बलिदान चघावय अऊ ओ मनखे ला ओकर असुधता ले सुध करे बर प्रायस्चित के बिधि ला पूरा करय। ओकर बाद, पुरोहित ह होम-बलिदान के पसु ला बलि करय ");
INSERT INTO hne_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","अऊ येला अन्न-बलिदान के संग बेदी म चघावय, अऊ ओ मनखे बर प्रायस्चित के बिधि ला पूरा करय, अऊ ओह सुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“पर, कहूं, ओह गरीब अय अऊ अतेक नइं दे सकय, त ओह अपन प्रायस्चित करे बर एक ठन मेढ़ा-पीला दोस-बलिदान के रूप म हलाय बर लेवय, अऊ संग म अन्न-बलिदान बर तेल म सनाय एपा के दसवां भाग बहुंत बढ़िया पीसान अऊ आधा लीटर तेल लेवय, ");
INSERT INTO hne_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","अऊ अपन हैसियत के मुताबिक, ओह दू ठन पंड़की या दू ठन परेवा पीला लानय; येमा के एक ठन ह पाप-बलिदान अऊ दूसर ह होम-बलिदान बर होही। ");
INSERT INTO hne_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“आठवां दिन ओह ये जम्मो ला अपन सुध होय बर मिलापवाला तम्बू के मुंहटा म यहोवा के आघू म पुरोहित करा लानय। ");
INSERT INTO hne_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","पुरोहित ह दोस-बलिदान के रूप म मेढ़ा-पीला ला आधा लीटर तेल के संग लेवय, अऊ ओमन ला हलाय-बलिदान के रूप म यहोवा के आघू म हलावय। ");
INSERT INTO hne_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ओह दोस-बलिदान बर मेढ़ा-पीला ला बलि करय अऊ येमा के कुछू लहू ला लेवय अऊ सुध होवइया मनखे के जेवनी कान के टीप म, ओकर जेवनी हांथ के अंगठा म अऊ जेवनी गोड़ के अंगठा म लगावय। ");
INSERT INTO hne_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","पुरोहित ह कुछू तेल ला अपन डेरी हांथ के हथेली म ढारय, ");
INSERT INTO hne_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","अऊ अपन जेवनी हांथ के अंगठा के बाजू वाले अंगठी म हथेली के कुछू तेल ला लेके यहोवा के आघू म सात बार छिंचय। ");
INSERT INTO hne_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","तब पुरोहित ह अपन हथेली के कुछू तेल ला लेके ओ जगह म लगावय, जऊन जगह म ओह दोस-बलिदान के लहू ला लगाथे—याने कि सुध होवइया मनखे के जेवनी कान के टीप म, ओकर जेवनी हांथ के अंगठा म अऊ जेवनी गोड़ के अंगठा म लगावय। ");
INSERT INTO hne_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","अपन हथेली म बांचे तेल ला पुरोहित ह ओ सुध होवइया मनखे के मुड़ म ढारय, ताकि यहोवा के आघू म ओ मनखे के प्रायस्चित के बिधि ह पूरा होवय। ");
INSERT INTO hne_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","तब ओह अपन हैसियत के मुताबिक पंड़कीमन या परेवा-पीलामन ला चघावय, ");
INSERT INTO hne_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","एक ठन ला पाप-बलिदान अऊ दूसर ला होम-बलिदान के रूप म, अन्न-बलिदान के संग चघावय। ये किसम ले, सुध होवइया मनखे के तरफ ले, पुरोहित ह यहोवा के आघू म प्रायस्चित के बिधि ला पूरा करही।” ");
INSERT INTO hne_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","येमन ओ मनखे बर सुध होय के नियम अंय, जऊन ला असुध करइया चमड़ी के बेमारी हवय अऊ ओमन गरीब अंय। ");
INSERT INTO hne_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","यहोवा ह मूसा अऊ हारून ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जब तुमन कनान देस म हबरहू, जेला मेंह तुमन ला तुम्हर अधिकार म देवत हंव, अऊ कहूं मेंह ओ देस म कोनो घर म बगरनेवाला बेमारी भेजंव, ");
INSERT INTO hne_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","त ओ घर के मालिक ह जाके पुरोहित ला बतावय, ‘मेंह अपन घर म अइसन चीज देखे हंव, जऊन ह असुध करइया फफूंदी सहीं लगथे।’ ");
INSERT INTO hne_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","एकर पहिली कि पुरोहित ह ओ घर म जाके बेमारी के जांच करय, ओह घर के सामान ला खाली करे के हुकूम देवय, ताकि घर के कोनो चीज असुध झन ठहिरय। एकर बाद, पुरोहित ह घर भीतर जाके जांच करय। ");
INSERT INTO hne_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ओह भीथीमन म बेमारी के जांच करय, अऊ यदि येह हरियर या लाल रंग के हवय अऊ भीथी के सतह ले धंसे सहीं दिखय, ");
INSERT INTO hne_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","त पुरोहित ह घर ले बाहिर मुंहटा म जाके, ओ घर ला सात दिन बर बंद कर देवय। ");
INSERT INTO hne_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","सातवां दिन, पुरोहित ह आके ओ घर के जांच करय। कहूं बेमारी ह घर के भीथीमन म बगर गे हवय, ");
INSERT INTO hne_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","त पुरोहित ह हुकूम देवय कि जऊन पथरामन दूसित हो गे हवंय, ओमन ला निकालके सहर के बाहिर कोनो असुध जगह म फटिक दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ओह घर के भीतर के चारों कोति के भीथी ला खुरचय अऊ खुरचे माटी ला सहर के बाहिर, कोनो असुध जगह म डार देवय। ");
INSERT INTO hne_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","तब ओह निकाले गे पथरामन के जगह म आने पथरा लगावय अऊ ताजा गारा लेके घर ला छाबय। ");
INSERT INTO hne_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“घर के पथरामन ला बदले, घर ला खुरचे अऊ छाबे के बाद, कहूं असुध करइया फफूंदी ह फेर दिखथे, ");
INSERT INTO hne_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","त पुरोहित ह घर भीतरी जाके जांच करय। अऊ, कहूं फफूंदी ह घर म बगर गे हवय, त येह लगातार बने रहइया असुध करइया फफूंदी अय; ओ घर ह असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ओ घर ला गिरा दिये जावय—ओकर पथरा, लकरी अऊ घर के जम्मो मलमा ला सहर के बाहिर कोनो असुध जगह म ले जावय। ");
INSERT INTO hne_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“जब घर ह बंद रहिथे, ओ समय यदि कोनो घर के भीतर जाथे, त ओह संझा के होवत तक असुध ठहिरय। ");
INSERT INTO hne_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ओ मनखे जऊन ह ओ घर म सुतथे या खाथे, ओह अपन ओनहा ला जरूर धोवय। ");
INSERT INTO hne_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“पर कहूं पुरोहित ह भीतर म आके जांच करथे अऊ देखथे कि घर ला फेर से छाबे के बाद, फफूंदी ह नइं बगरे हवय, त ओह ओ घर ला सुध ठहिरावय, काबरकि असुध करइया फफूंदी ह खतम हो गे हवय। ");
INSERT INTO hne_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","अऊ ओ घर ला सुध करे बर, ओह दू ठन चिरई, देवदार के लकरी, लाल सूंत अऊ जूफा लेवय। ");
INSERT INTO hne_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ओह एक ठन माटी के बरतन म ताजा पानी के ऊपर एक ठन चिरई ला बलि करय। ");
INSERT INTO hne_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","तब ओह ओ जीयत चिरई के संग देवदार के लकरी, जूफा, लाल सूंत ला लेवय अऊ येमन ला बलि करे गे चिरई के लहू म अऊ ताजा पानी म बुड़ोवय अऊ घर म सात बार छिंचय। ");
INSERT INTO hne_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ओह ओ घर ला चिरई के लहू, ताजा पानी, जीयत चिरई, देवदार के लकरी, जूफा अऊ लाल सूंत के दुवारा सुध करय। ");
INSERT INTO hne_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","तब ओह जीयत चिरई ला सहर के बाहिर खुला जगह म छोंड़ देवय। ये किसम ले ओह घर बर प्रायस्चित के बिधि ला पूरा करही, अऊ ओ घर ह सुध हो जाही।” ");
INSERT INTO hne_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","कोनो असुध करइया चमड़ी के बेमारी, घाव, ");
INSERT INTO hne_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ओनहा या घर म असुध करइया फफूंदी, ");
INSERT INTO hne_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","सूजन, चकत्ता, या चमकत दाग के बिसय म ये नियम अंय। ");
INSERT INTO hne_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ये बिधिमन के दुवारा पता चलथे कि कोनो चीज ह सुध हवय या असुध। असुध करइया चमड़ी के बेमारी अऊ असुध करइया फफूंदी के बिसय म ये नियम अंय। ");
INSERT INTO hne_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","यहोवा ह मूसा अऊ हारून ला फेर कहिस, ");
INSERT INTO hne_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इसरायलीमन ले गोठियावव अऊ ओमन ला कहव: ‘जब कोनो मनखे के देहें ले असामान्‍य रूप म कुछू चीज निकलथे, त ओ चीज ह असुध अय। ");
INSERT INTO hne_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","चाहे ओ चीज ह ओकर देहें ले लगातार निकलत रहय या बंद हो जावय, येह ओला असुध करही। ये किसम ले, ओकर देहें ले निकले चीज ह ओला असुध करही: ");
INSERT INTO hne_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘जऊन बिस्तर म धातवाले ह सुतथे, ओह असुध हो जाही, अऊ जऊन कोनो चीज म ओह बईठथे, ओह घलो असुध हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","जऊन कोनो ओकर बिस्तर ला छूथे, ओह अपन ओनहा ला धोवय अऊ पानी ले नहावय, अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","जऊन कोनो ओ चीज म बईठथे, जेमा धातवाले ह बईठे रिहिस, त ओह अपन ओनहा ला धोवय अऊ पानी ले नहावय, अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘जऊन कोनो धातवाले ला छू लेथे, ओह अपन ओनहा ला धोवय अऊ पानी ले नहावय, अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘कहूं कोनो धातवाले ह कोनो सुध मनखे ऊपर थूक देथे, त ओह अपन ओनहा ला धोवय अऊ पानी ले नहावय, अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘धातवाले ह जऊन चीज म बईठके सवारी करथे, ओ आसन ह असुध ठहिरय, ");
INSERT INTO hne_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","अऊ जऊन ह कोनो चीज ला, जेह ओकर खाल्हे म रिहिस, छू लेथे, त ओह संझा के होवत तक असुध ठहिरही; जऊन कोनो ओ चीजमन ला उठाथे, ओह अपन ओनहा ला धोवय अऊ पानी ले नहावय, अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘जऊन कोनो मनखे ला धातवाले ह पानी म हांथ धोये बिगर छू लेथे, त ओह अपन ओनहा ला धोवय अऊ पानी ले नहावय, अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘धातवाले ह माटी के कोनो बरतन ला छू लेथे, त ओ बरतन ला फोर दिये जावय, अऊ कठवा के बने जम्मो चीज ला पानी म धोय जावय। ");
INSERT INTO hne_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘जब धातवाले ह अपन तकलीफ ले बने हो जाथे, तब ओह बिधि मुताबिक अपन सुध होय के सात दिन गन लेवय; तब ओह अपन ओनहा ला धोवय अऊ ताजा पानी म नहावय, अऊ ओह सुध हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठवां दिन ओह दू ठन पंड़की या दू ठन परेवा पीला लेवय अऊ मिलापवाला तम्बू के मुंहटा म यहोवा के आघू म जाके ओमन ला पुरोहित ला देवय। ");
INSERT INTO hne_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","पुरोहित ह ओमा ले एक ठन ला पाप-बलिदान बर अऊ दूसर ला होम-बलिदान बर चघावय। ये किसम ले, पुरोहित ह ओ मनखे बर ओकर धात के रोग के कारन यहोवा के आघू म प्रायस्चित के बिधि ला पूरा करही। ");
INSERT INTO hne_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘जब कोनो आदमी के बीर्य ह निकल जावय, त ओह पानी म पूरा नहावय, अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","कोनो ओनहा या चाम के चीज, जऊन म बीर्य लगे हवय, ओला पानी म धोय जावय, अऊ येह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","जब कोनो आदमी के सारीरिक संबंध कोनो माईलोगन के संग होथे अऊ बीर्य निकलथे, त ओ दूनों झन पानी म नहावंय, अऊ ओमन संझा के होवत तक असुध ठहिरहीं। ");
INSERT INTO hne_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘जब कोनो माईलोगन ला मासिक धरम होवय, त ओ समय म ओह सात दिन तक असुध ठहिरही, अऊ जऊन कोनो ओला छूथे, ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘अपन मासिक धरम के समय, ओह जऊन चीज म सुतथे, ओ चीज ह असुध ठहिरही, अऊ जऊन चीज म ओह बईठथे, ओह घलो असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","जऊन कोनो ओ माईलोगन के बिस्तर ला छूथे, ओह असुध ठहिरही; ओह अपन ओनहा ला धोवय अऊ पानी म नहावय अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","जऊन कोनो अइसने कोनो चीज ला छू लेथे, जेमा ओ माईलोगन ह बईठे रिहिस, त ओह असुध ठहिरही; ओह अपन ओनहा ला धोवय अऊ पानी म नहावय, अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","चाहे येह बिस्तर होवय या कोनो अऊ चीज, जेमा ओ माईलोगन ह बईठे रिहिस, जब कोनो येला छू लेथे, त ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘कहूं कोनो आदमी ह ओकर संग सारीरिक संबंध बनाथे अऊ ओ माईलोगन के मासिक धरम के लहू ह ओला लग जाथे, त ओ आदमी ह सात दिन तक असुध हो जाही; अऊ जऊन बिस्तर म ओह सुतथे, ओह घलो असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘जब कोनो माईलोगन ला ओकर मासिक धरम के समय ले जादा दिन तक लहू बोहावत रहिथे या ओकर मासिक धरम के समय के बाद घलो ओकर लहू बोहावत रहिथे, त जब तक ओकर लहू बोहावत रहिही, तब तक ओह वइसने ही असुध ठहिरही, जइसने कि अपन मासिक धरम के दिन म ठहिरथे। ");
INSERT INTO hne_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","जऊन बिस्तर म ओह अइसने लहू बोहाय के दिन म सुतथे, त ओ बिस्तर घलो असुध ठहिरही, जइसने कि ओकर मासिक धरम के समय म असुध ठहिरथे, अऊ ओ माईलोगन जऊन चीज म बईठथे, ओ चीज ह घलो असुध ठहिरही, जइसने कि ओकर मासिक धरम के दिन म ठहिरथे। ");
INSERT INTO hne_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","जऊन कोनो ओ चीजमन ला छूथे, ओह असुध ठहिरही; ओह अपन ओनहा ला धोवय अऊ पानी म नहावय, अऊ ओह संझा के होवत तक असुध ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘जब ओ माईलोगन ह अपन लहू बोहाय ले सुध हो जाथे, त ओह सात दिन गनय, अऊ ओकर बाद बिधि के मुताबिक ओह सुध हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","आठवां दिन ओह दू ठन पंड़की या दू ठन परेवा पीला लेवय अऊ ओमन ला मिलापवाला तम्बू के मुंहटा म पुरोहित करा लानय। ");
INSERT INTO hne_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","पुरोहित ह एक ठन चिरई ला पाप-बलिदान अऊ दूसर ला होम-बलिदान के रूप म चघावय। ये किसम ले, पुरोहित ह ओकर लहू बोहाय के असुधता के सेति यहोवा के आघू म ओकर बर प्रायस्चित के बिधि ला पूरा करही। ");
INSERT INTO hne_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘तुमन इसरायलीमन ला ओ चीजमन ले अलग रखव, जऊन चीजमन ओमन ला असुध करथें, नइं तो ओमन मोर निवास के जगह, जऊन ह ओमन के बीच हवय, ओला असुध करहीं अऊ ओकरे कारन अपन असुधता म मर जाहीं।’ ” ");
INSERT INTO hne_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","धात के बिमरहा, अऊ जऊन आदमी के बीर्य ह निकल जाथे, जेकर ले ओह असुध ठहिरथे, ");
INSERT INTO hne_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ओ माईलोगन जऊन ह मासिक धरम के कारन असुध हवय, कोनो आदमी के बीर्य निकलय या माईलोगन के लहू बोहावय, या कोनो आदमी, जऊन ह असुध माईलोगन संग सारीरिक संबंध बनाथे, ये जम्मो बर ये बिधिमन अंय। ");
INSERT INTO hne_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","जब हारून के दू झन बेटामन यहोवा के आघू म जाके मर गीन, त एकर बाद यहोवा ह मूसा ले गोठियाईस। ");
INSERT INTO hne_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","यहोवा ह मूसा ला कहिस, “अपन भाई हारून ला कह कि ओह सन्दूक के ऊपर बने प्रायस्चित के ढकना के आघू, परदा के भीतर महा पबितर स्थान म, घेरी-बेरी झन आवय, नइं तो ओह मर जाही, काबरकि मेंह प्रायस्चित के ढकना के ऊपर बादर म परगट होहूं। ");
INSERT INTO hne_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“हारून ह महा पबितर स्थान म ये किसम ले आवय: जरूरी अय कि ओह पहिले पाप-बलिदान के खातिर एक ठन जवान बछवा अऊ होम-बलिदान के खातिर एक ठन मेढ़ा ला लेके आवय। ");
INSERT INTO hne_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ओह मलमल के पबितर अंगरखा अऊ अपन देहें म मलमल के कच्छा पहिरय अऊ मलमल के कमरबंध कसके मलमल के पागा बांधय। येमन पबितर ओनहा अंय। ओह पानी म नहाके ही येमन ला पहिरय। ");
INSERT INTO hne_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","फेर ओह इसरायली समाज ले पाप-बलिदान के खातिर दू ठन बोकरा अऊ होम-बलिदान के चढ़ावा खातिर एक ठन मेढ़ा लेवय। ");
INSERT INTO hne_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“तब हारून ह ओ पाप-बलिदान के बछवा ला जऊन ह ओकरे खातिर अय, चघाके अपन अऊ अपन परिवार बर प्रायस्चित करय। ");
INSERT INTO hne_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","तब ओह ओ दूनों बोकरामन ला लेके मिलापवाला तम्बू के मुंहटा म यहोवा के आघू म ठाढ़ करय। ");
INSERT INTO hne_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","हारून ह दूनों बोकरामन बर चिट्ठी डालय, याने कि एक चिट्ठी यहोवा बर अऊ दूसर चिट्ठी अजाजेल बर। ");
INSERT INTO hne_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","जऊन बोकरा बर यहोवा के नांव के चिट्ठी निकलय, ओला हारून ह पाप-बलिदान बनाके चघावय। ");
INSERT INTO hne_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","पर जऊन बोकरा बर अजाजेल के नांव के चिट्ठी निकलय, ओला यहोवा के आघू म जीयत ठाढ़ करे जावय ताकि ओकर दुवारा प्रायस्चित करे बर ओला सुन्ना जगह म अजाजेल के रूप म भेजे जावय। ");
INSERT INTO hne_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“तब हारून ह पाप-बलिदान के ओ बछवा ला, जऊन ह ओकरेच बर अय, लानके अपन घराना बर प्रायस्चित करय। ओह ओ पाप-बलिदान के बछवा ला, जऊन ह ओकरेच बर अय, बलि करय। ");
INSERT INTO hne_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","अऊ ओह यहोवा के आघू बेदी म के बरत कोइला ले भरे धूपदान अऊ दू मुठा चिक्कन पिसे खुसबूवाला धूप ला लेके परदा के भीतर जावय। ");
INSERT INTO hne_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ओह ओ धूप ला यहोवा के आघू म आगी के ऊपर डारय, जेकर ले धूप के कुहरा ह करार कानून के पटियामन ऊपर प्रायस्चित के ढकना ला भर लेवय, ताकि ओह झन मरय। ");
INSERT INTO hne_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","फेर ओह बछवा के लहू म ले थोरकून ला लेके अंगठी ले प्रायस्चित के ढकना के ऊपर सामने म छिंचय अऊ ओ लहू म ले थोरकून ला प्रायस्चित के ढकना के आघू म घलो अंगठी ले सात बार छिंचय। ");
INSERT INTO hne_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“तब ओह पाप-बलिदान के ओ बोकरा ला, जऊन ह मनखेमन बर अय, बलि करय अऊ ओकर लहू ला परदा के भीतर लावय अऊ ये लहू के संग वइसनेच करय, जइसे बछवा के लहू के संग करे रिहिस। ओह येला प्रायस्चित के ढकना के ऊपर अऊ ओकर आघू म छिंचय। ");
INSERT INTO hne_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","इसरायलीमन के असुधता अऊ बिदरोह के कारन, अऊ जऊन कुछू पाप ओमन करे हवंय, ओकर कारन, ओह ये किसम ले महा पबितर स्थान बर प्रायस्चित करय। ओह मिलापवाला तम्बू बर घलो, जऊन ह ओमन के असुधता म ओमन के बीच म रहिथे, अइसने ही करय। ");
INSERT INTO hne_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","जब हारून ह प्रायस्चित करे बर महा पबितर स्थान म जावय, त जब तक ओह अपन, अपन घराना अऊ इसरायल के जम्मो समाज बर प्रायस्चित करके बाहिर नइं निकलय, तब तक कोनो मनखे मिलापवाला तम्बू म झन रहय। ");
INSERT INTO hne_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“तब ओह बाहिर निकलके ओ बेदी के तीर म जावय, जऊन ह यहोवा के आघू म हवय अऊ ओकरे बर प्रायस्चित करय, याने बछवा अऊ बोकरा दूनों के लहू म ले थोरकून ला लेके बेदी के सींगमन म जम्मो कोति लगावय। ");
INSERT INTO hne_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","अऊ अपन अंगठी ले ओ लहू म ले थोरकून लेके बेदी ऊपर सात बार छिंचके, ओला इसरायलीमन के असुधता ले सुध अऊ पबितर करय। ");
INSERT INTO hne_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“जब हारून ह महा पबितर स्थान, मिलापवाला तम्बू, अऊ बेदी बर प्रायस्चित कर डारय, तब ओ जीयत बोकरा ला तीर म लावय। ");
INSERT INTO hne_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","तब हारून ह जीयत बोकरा के मुड़ के ऊपर अपन दूनों हांथ ला मढ़ावय अऊ ओकर ऊपर इसरायलीमन के जम्मो अधरम अऊ ओमन के जम्मो अपराध अऊ पाप ला मान लेवय। ओह ओमन ला ओ बोकरा के मुड़ म डारके ओला एक झन मनखे के हांथ ले, जऊन ला इही काम बर रखे गय हवय, सुन्ना जगह म भेज देवय। ");
INSERT INTO hne_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ओ बोकरा ह ओमन के जम्मो अधरम ला अपन ऊपर बोहके कोनो सुन्ना जगह म चल दीही। ओ मनखे ह ओ बोकरा ला सुन्ना जगह म छोंड़ देवय। ");
INSERT INTO hne_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“तब हारून ह मिलापवाला तम्बू म आके मलमल के ओ जम्मो ओनहा, जऊन ला ओह महा पबितर स्थान म जाय के बेरा पहिरे रिहिस, ओमन ला ओही मेर छोंड़ देवय। ");
INSERT INTO hne_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","फेर ओह पबितर-स्थान के छेत्र म पानी ले नहाके अपनेच ओनहा ला पहिर लेवय अऊ बाहिर म आके अपन बर अऊ मनखेमन बर घलो होम-बलिदान चघाके अपन बर अऊ मनखेमन बर प्रायस्चित करय। ");
INSERT INTO hne_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","अऊ पाप-बलिदान के चरबी ला ओह बेदी म जलावय। ");
INSERT INTO hne_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“जऊन मनखे ह बोकरा ला अजाजेल के रूप म छोंड़े हवय, ओह अपन ओनहा ला धोवय, पानी ले नहावय, तभे डेरा के भीतर आवय। ");
INSERT INTO hne_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","पर पाप-बलिदान के बछवा अऊ पाप-बलिदान के बोकरा, जेकर लहू ला महा पबितर स्थान म प्रायस्चित करे बर लाने गे रिहिस, ओमन ला डेरा के बाहिर म ले जाके ओकर खाल, मांस, अऊ गोबर ला आगी म जलाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","तब ओमन ला जरोइया ह अपन ओनहा ला धोवय अऊ पानी ले नहावय। एकर बाद ही ओह डेरा के भीतर आवय। ");
INSERT INTO hne_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“येह तुम्हर बर एक ठन सदा के बिधि ठहिरय: हर साल सातवां महिना के दसवां दिन तुमन अपनआप के इनकार करव। ओ दिन कोनो मनखे, कहूं ओह देस म जनमे मनखे होवय या तुम्हर बीच म रहइया परदेसी, कोनो काम-बुता झन करहू। ");
INSERT INTO hne_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","काबरकि इही दिन तुमन ला सुध करे के खातिर तुम्हर बर प्रायस्चित करे जाही, अऊ तुमन अपन जम्मो पापमन ले यहोवा के आघू म सुध ठहिरहू। ");
INSERT INTO hne_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ये दिन ह बिसराम के दिन अय, अऊ जरूरी अय कि तुमन अपनआप के इनकार करव। येह सदा के एक बिधि अय। ");
INSERT INTO hne_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","अऊ जऊन पुरोहित ला अपन ददा के जगह म महा पुरोहित के रूप म काम करे बर अभिसेक अऊ संस्कार करे गे हवय, ओही ह प्रायस्चित करय। ओह मलमल के ओनहा याने पबितर ओनहा ला पहिरके ");
INSERT INTO hne_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","जम्मो महा पबितर स्थान, मिलापवाला तम्बू, अऊ बेदी बर प्रायस्चित करय। ओह पुरोहित अऊ समाज के जम्मो सदस्य बर घलो प्रायस्चित करय। ");
INSERT INTO hne_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“येह तुम्हर बर सदा के बिधि ठहिरय कि इसरायलीमन बर एक बछर म एक बार ओमन के जम्मो पाप बर प्रायस्चित करे जावय।” अऊ जइसे यहोवा ह मूसा ला हुकूम देय रिहिस, वइसनेच करे गीस। ");
INSERT INTO hne_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून अऊ ओकर बेटामन ला अऊ जम्मो इसरायलीमन ला कह: ‘यहोवा ह ये हुकूम दे हवय: ");
INSERT INTO hne_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","यदि कोनो इसरायली मनखे कोनो बछवा, मेढ़ा-पीला या बोकरा ला डेरा के भीतर या डेरा के बाहिर बलि चघाथे, ");
INSERT INTO hne_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","पर ओला मिलापवाला तम्बू के मुंहटा करा यहोवा के पबितर-तम्बू के आघू म यहोवा ला बलि चघाय बर नइं लानय, त ओ मनखे ह लहू बहाय के दोसी समझे जाही; ओ मनखे ह लहू बहाय हवय; ओला अपन मनखेमन के समाज ले अलग करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ये बिधि के कारन ये अय ताकि इसरायलीमन अपन बलिदान यहोवा करा लानंय, पर खुला जगह म बलिदान झन करंय। ओमन अपन बलिदान ला मिलापवाला तम्बू के मुंहटा म पुरोहित करा लानके मेल-बलिदान के रूप म यहोवा ला चघावंय। ");
INSERT INTO hne_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","पुरोहित ह लहू ला मिलापवाला तम्बू के मुंहटा म यहोवा के बेदी के चारों कोति छिंचय अऊ चरबी ला यहोवा बर सुख-देवइया सुगंध के रूप म जलावय। ");
INSERT INTO hne_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ओमन बोकरा के मूरतीमन ला कोनो बलिदान झन चघावंय, काबरकि अइसने करके ओमन बेभिचारी के सहीं ठहिरथें। येह पीढ़ी दर पीढ़ी ओमन के हमेसा के बिधि ठहिरय।’ ");
INSERT INTO hne_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ओमन ला कह: ‘कोनो इसरायली या ओमन के बीच म रहइया कोनो परदेसी ह होम-बलिदान या बलि चघाथे, ");
INSERT INTO hne_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","अऊ ओला मिलापवाला तम्बू के मुंहटा म यहोवा करा लानके नइं चघावय, त ओ मनखे ला इसरायली मनखेमन के समाज ले अलग करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘कोनो इसरायली या ओमन के बीच म रहइया कोनो परदेसी, जऊन ह लहू ला खाथे, त मेंह ओला मनखेमन के बीच ले अलग कर दूहूं। ");
INSERT INTO hne_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","काबरकि परानी के परान ह लहू म रहिथे, अऊ येला मेंह तुमन ला एकरसेति दे हंव कि तुमन बेदी म अपन बर प्रायस्चित के बिधि ला पूरा करव; काबरकि ये लहू ही मनखे के जिनगी के प्रायस्चित ला पूरा करथे। ");
INSERT INTO hne_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","एकरसेति मेंह इसरायलीमन ला कहिथंव, “न तो तुमन, अऊ न ही तुम्हर बीच म रहइया कोनो परदेसी लहू ला खावय।” ");
INSERT INTO hne_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘कोनो इसरायली या तुम्हर बीच म रहइया कोनो परदेसी कोनो अइसने पसु या चिरई के सिकार करथे, जऊन ला खाय जा सकत हे, त पहिले ओकर लहू ला बहाके माटी म ढांप दिये जावय, ");
INSERT INTO hne_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","काबरकि हर एक जीव के परान ह ओकर लहू म होथे। एकरसेति मेंह इसरायलीमन ला कहे हंव, “तुमन कोनो जीव के लहू ला झन खावव, काबरकि हर एक जीव के परान ह ओकर लहू म होथे; जऊन कोनो ओला खाथे, ओला समाज ले अलग करे जावय।” ");
INSERT INTO hne_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘कोनो मनखे, चाहे ओह देस म जनमे होवय या परदेसी, यदि ओह पहिले से मरे पसु या कोनो जंगली पसु के दुवारा चिरे-फारे पसु के मांस ला खाथे, त ओला अपन ओनहा ला धोना अऊ पानी म नहाना चाही, अऊ ओह संझा के होवत तक बिधि मुताबिक असुध रहिही; तब ओह सुध होही। ");
INSERT INTO hne_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","पर कहूं ओह अपन ओनहा ला नइं धोही अऊ नइं नहाही, त ओह दोसी ठहिरही।’ ” ");
INSERT INTO hne_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इसरायलीमन ले बात कर अऊ ओमन ला कह: ‘मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तुमन वइसने झन करव, जइसने ओमन मिसर देस म करथें, जिहां तुमन रहत रहेव, अऊ तुमन वइसने झन करव, जइसने ओमन कनान देस म करथें, जिहां मेंह तुमन ला लावत हंव। ओमन के रीति-रिवाज म झन चलव। ");
INSERT INTO hne_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","तुमन मोर कानून ला मानव अऊ धियान से मोर बिधि-बिधान म चलव। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","मोर बिधि-बिधान अऊ कानून म चलव, काबरकि जऊन मनखे ह ओमन के पालन करही, ओह ओमन के दुवारा जीयत रहिही। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘तुमन म ले कोनो अपन नजदीकी रिस्तेदार के संग सारीरिक संबंध झन बनावय। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘अपन दाई के संग सारीरिक संबंध बनाय के दुवारा अपन ददा के अनादर झन करव। ओह तो तुम्हर दाई ए; ओकर संग सारीरिक संबंध झन बनावव। ");
INSERT INTO hne_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘अपन सौतेली दाई के संग घलो सारीरिक संबंध झन बनावव; येह तुम्हर ददा के अनादर होही। ");
INSERT INTO hne_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘तुमन अपन बहिनी के संग सारीरिक संबंध झन बनावव, चाहे ओह तुम्हर ददा के बेटी होवय या तुम्हर दाई के बेटी, चाहे ओह ओही घर म जनमे होवय या कहूं मेर अऊ। ");
INSERT INTO hne_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘अपन बेटा के बेटी या अपन बेटी के बेटी संग सारीरिक संबंध झन बनावव; एकर दुवारा तुम्हर अनादर होही। ");
INSERT INTO hne_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘यदि तुम्हर ददा ह आने घरवाली लानथे अऊ ओह बेटी जनमथे, त ओ बेटी संग घलो सारीरिक संबंध झन बनावव; ओह तुम्हर बहिनी अय। ");
INSERT INTO hne_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘अपन फूफू के संग सारीरिक संबंध झन बनावव, काबरकि ओह तुम्हर ददा के नजदीकी रिस्तेदार अय। ");
INSERT INTO hne_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘अपन मौसी के संग सारीरिक संबंध झन बनावव, काबरकि ओह तुम्हर दाई के नजदीकी रिस्तेदार अय। ");
INSERT INTO hne_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘अपन कका के घरवाली संग सारीरिक संबंध बनाय के दुवारा अपन कका के अनादर झन करव, काबरकि ओकर घरवाली ह तो तुम्हर काकी अय। ");
INSERT INTO hne_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘अपन बेटा के घरवाली संग सारीरिक संबंध झन बनावव, ओह तो तुम्हर बेटा के घरवाली अय। ओकर संग सारीरिक संबंध झन बनावव। ");
INSERT INTO hne_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘अपन भऊजी या भाई-बहू के संग सारीरिक संबंध झन बनावव, एकर दुवारा भाई के अनादर होही। ");
INSERT INTO hne_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘कोनो माईलोगन अऊ ओकर बेटी दूनों के संग सारीरिक संबंध झन बनावव। न तो ओ माईलोगन के बेटा के बेटी, अऊ न ही ओ माईलोगन के बेटी के बेटी संग सारीरिक संबंध बनावव; काबरकि ओमन ओकर नजदीकी रिस्तेदार अंय। अइसने करई ह दुस्टता अय। ");
INSERT INTO hne_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘अपन घरवाली के जीते-जीयत अपन साली ला घलो घरवाली बनाके ओकर संग सारीरिक संबंध झन बनावव। ");
INSERT INTO hne_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘कोनो माईलोगन के मासिक धरम के असुधता के समय, ओकर संग सारीरिक संबंध झन बनावव। ");
INSERT INTO hne_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘अपन परोसी के घरवाली के संग सारीरिक संबंध बनाके अपनआप ला अऊ ओला असुध झन करव। ");
INSERT INTO hne_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘अपन लइकामन ले कोनो ला भी मोलेक देवता बर बलि झन चघावव, काबरकि एकर ले तुम्हर परमेसर के नांव अपबितर होही। में यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘तुमन कोनो आदमी के संग सारीरिक संबंध झन बनावव, जइसने कि तुमन कोनो माईलोगन के संग बनाथव। येह घिनौना काम अय। ");
INSERT INTO hne_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘कोनो पसु के संग पसुगमन करके अपनआप ला असुध झन करव। कोनो माईलोगन ह कोनो पसु के संग सारीरिक संबंध बनाय बर अपनआप ला झन देवय; येह अपनआप ला अपबितर करई अय। ");
INSERT INTO hne_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘अइसने कोनो घलो काम करके अपनआप ला असुध झन करव, काबरकि अइसने काम करके जऊन जाति के मनखेमन अपनआप ला असुध करे हवंय, ओ जम्मो जातिमन ला मेंह तुम्हर आघू ले निकालनेवाला हंव। ");
INSERT INTO hne_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","इहां तक कि देस ह असुध हो गीस; एकरसेति मेंह ओला ओकर पाप के सेति दंड दे हंव, जेकर ले ओ देस ह उहां के रहइयामन ला स्वीकार नइं करिस। ");
INSERT INTO hne_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","पर तुमन मोर बिधि अऊ कानूनमन ला मानव। तुमन म ले कोनो घलो, चाहे ओह कोनो देस म जनमे मनखे होवय या तुम्हर बीच म रहइया कोनो परदेसी, ये घिनौना काम झन करय, ");
INSERT INTO hne_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","काबरकि जऊन मनखेमन तुम्हर पहिली ये देस म रहत रिहिन, ओमन ये काम करत रिहिन, जेकर ले देस ह असुध हो गीस। ");
INSERT INTO hne_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","अऊ यदि तुमन देस ला असुध करथव, त येह तुमन ला घलो स्वीकार नइं करही, जइसने येह ओमन ला स्वीकार नइं करिस, जऊन मन तुम्हर पहिली इहां रिहिन। ");
INSERT INTO hne_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘जऊन मनखे ह येमा के कोनो घलो घिनौना काम करथे, ओला अपन मनखेमन के समाज ले निकाल दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","एकरसेति मोर हुकूममन ला मानव अऊ कोनो ओ घिनौना रीति-रिवाज ला झन मानव, जऊन ला मनखेमन तुम्हर आय के पहिली मानत रिहिन अऊ ओमन के संग अपनआप ला असुध झन करव। मेंह यहोवा तुम्हर परमेसर अंव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“इसरायलीमन के जम्मो सभा ले गोठिया अऊ ओमन ला कह: ‘पबितर बनव, काबरकि में, यहोवा तुम्हर परमेसर ह पबितर अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘तुमन म ले हर एक झन अपन दाई अऊ ददा के आदर करव, अऊ तुमन मोर बिसराम दिनमन ला मानव। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘तुमन मूरतीमन कोति झन लहुंटव अऊ अपन बर धातु के देवता झन बनावव। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘जब तुमन यहोवा ला मेल-बलिदान चघावव, त अइसने चघावव कि येह तुम्हर खातिर गरहन करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","जऊन दिन तुमन ओला चघावव, ओही दिन या ओकर दूसर दिन ओला खाय जावय; कोनो चीज तीसर दिन तक बांच जावय, त ओला आगी म जला दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","यदि ओमा के कुछू ला तीसर दिन खाय जाथे, त ओह असुध अय अऊ ओला नइं गरहन करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","जऊन कोनो ओला खाथे, ओह दोसी ठहिरही, काबरकि ओह यहोवा के पबितर चीज ला अपबितर करे हवय; ओला अपन मनखेमन के समाज ले निकाल दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘अपन देस म रहे के बाद, जब तुमन अपन भुइयां के फसल ला लुवव, त अपन खेत के कोना-कोना तक जम्मो ला झन लुवव या लुवाय फसल के गिरे-परे बालमन ला झन संकेलव। ");
INSERT INTO hne_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","तुमन अपन अंगूर के बारी म दूसर बार अंगूर टोरे बर झन जावव या अंगूर के बारी म झरे अंगूरमन ला झन संकेलव। ओमन ला गरीब अऊ परदेसीमन बर छोंड़ दव। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘तुमन चोरी झन करव। “ ‘लबारी झन मारव। “ ‘एक-दूसर ला धोखा झन देवव। ");
INSERT INTO hne_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘मोर नांव म लबारी किरिया झन खावव अऊ ये किसम ले अपन परमेसर के नांव ला अपबितर झन करव। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘अपन परोसी ला झन ठगव या ओला झन लूटव। “ ‘बनिहार के बनी रात भर याने कि बिहनियां तक अपन करा रोकके झन रखव। ");
INSERT INTO hne_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘भैंरा मनखे ला सराप झन देवव या अंधरा के आघू म हपटे बर कुछू झन मढ़ावव, पर अपन परमेसर के भय मानव। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘नियाय ला झन बिगाड़व। गरीब के संग पखियपात या बड़े मनखे के मुहूं-देखी नियाय झन करव, पर अपन परोसी के सही-सही नियाय करव। ");
INSERT INTO hne_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘अपन मनखेमन के बीच म लबारी बात झन फईलावव। “ ‘अपन परोसी के हतिया करे के उपाय झन करव। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘अपन मन म अपन संगी इसरायली ले घिन झन करव। अपन परोसी ला खुले मन से डांटव, ताकि तुमन ओमन के अपराध म भागी झन होवव। ");
INSERT INTO hne_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘काकरो ले बदला झन लेवव या अपन मनखेमन के बीच म कोनो बर बईरता झन रखव, पर अपन परोसी ले अपन सहीं मया करव। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘मोर बिधिमन ला मानव। “ ‘आने-आने जाति के पसुमन म संबंध झन करावव। “ ‘अपन खेत म दू किसम के बीजा एक संग झन बोवव। “ ‘दू किसम के चीज ले बने ओनहा ला झन पहिरव। ");
INSERT INTO hne_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘कोनो गुलाम माईलोगन, जेकर मंगनी कोनो मनखे के संग हो गे हवय, पर ओ कुंवारी ला दाम देके नइं छोंड़ाय गे हवय या ओला सुतंतर नइं करे गे हवय; ओकर संग यदि कोनो मनखे ह सारीरिक संबंध बनाथे, त ओमन ला दंड तो दिये जावय, पर ओमन झन मार डारे जावंय, काबरकि ओ कुंवारी ला सुतंतर नइं करे गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ओ आदमी ह मिलापवाला तम्बू के मुंहटा म यहोवा करा दोस-बलिदान बर एक ठन मेढ़ा लेके आवय। ");
INSERT INTO hne_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","पुरोहित ह ओ दोस-बलिदान के मेढ़ा ला यहोवा के आघू म चघाके ओ मनखे के पाप के प्रायस्चित के बिधि ला पूरा करय, तब ओह जऊन पाप करे हवय, ओह छेमा करे जाही। ");
INSERT INTO hne_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘जब तुमन कनान देस म आवव अऊ उहां कोनो किसम के फर के रूख लगावव, त ओकर फर ला बरजे कस समझव। तीन बछर ले ओ फर ला तुमन बरजीत समझव; ओला झन खावव। ");
INSERT INTO hne_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","चौथा साल ओकर जम्मो फर यहोवा के इस्तुति के बलिदान बर पबितर ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","तब पांचवां साल तुमन ओकर फर ला खा सकत हव। ये किसम ले तुम्हर फसल म बढ़ोतरी होही। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘तुमन कोनो घलो मांस ला लहू के संग झन खावव। “ ‘जादू-टोना झन करव या सुभ-असुभ घरी ला झन मानव। ");
INSERT INTO hne_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘अपन मुड़ के किनारे के चुंदी ला झन कटावव या अपन दाढ़ी के तीर के बाल ला झन कतरावव। ");
INSERT INTO hne_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘कोनो मरे मनखे बर अपन देहें ला झन काटव या अपन देहें म गोदना झन गोदावव। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘अपन बेटी ला बेस्या बनाय के दुवारा ओकर अपमान झन करव, नइं तो देस ह बेस्या के काम के कारन बुरई ले भर जाही। ");
INSERT INTO hne_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘मोर बिसराम दिनमन ला मानव अऊ मोर पबितर-स्थान के आदर करव। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘बईगामन अऊ भूत-परेत साधोइयामन करा झन जावव, काबरकि तुमन ओमन के दुवारा असुध हो जाहू। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘डोकरामन के आघू म उठके ठाढ़ हो जावव; सियानमन के आदर करव अऊ अपन परमेसर के भय मानव। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘जब कोनो परदेसी तुम्हर देस म तुम्हर संग रहिथे, त ओकर संग गलत बरताव झन करव। ");
INSERT INTO hne_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","जब कोनो परदेसी तुम्हर बीच म रहत हवय, त ओकर संग वइसने बरताव करव, जइसने कि तुमन देसी मनखे के संग करथव। ओकर ले अपन सहीं मया करव, काबरकि तुमन घलो मिसर देस म परदेसी होके रहेव। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘जब तुमन कोनो चीज ला नापथव, तऊलथव या गनथव, त ये काम ला ईमानदारी से करव। ");
INSERT INTO hne_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","लम्बई नापे के सही पैमाना, भार तऊले बर सही तराजू, मात्रा जाने बर सही एपा अऊ सही हीन के उपयोग करव। मेंह यहोवा तुम्हर परमेसर अंव, जऊन ह तुमन ला मिसर देस ले निकालके लानिस। ");
INSERT INTO hne_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘मोर जम्मो बिधि-बिधान अऊ मोर जम्मो कानून ला मानव अऊ ओमन के पालन करव। मेंह यहोवा अंव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इसरायलीमन ला कह: ‘इसरायल म रहइया कोनो इसरायली या कोनो परदेसी, जऊन ह अपन कोनो लइका ला, मोलेक देवता ला बलिदान चघाथे, त ओह मार डारे जावय। समाज के मनखेमन ओला पथरवाह करके मार डारंय। ");
INSERT INTO hne_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मेंह खुद ओ मनखे के बिरोध म होके ओला ओकर मनखेमन ले मिटा दूहूं; काबरकि मोलेक ला अपन लइका बलिदान करके, ओह मोर पबितर-स्थान ला असुध अऊ मोर पबितर नांव ला अपबितर करे हवय। ");
INSERT INTO hne_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","कहूं समाज के मनखेमन अपन आंखी मुंद लेथें, जब ओ मनखे ह अपन कोनो लइका मोलेक ला बलिदान करथे अऊ यदि ओला मार नइं डारंय, ");
INSERT INTO hne_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","त मेंह खुद ओ मनखे अऊ ओकर परिवार के बिरोध म होके ओमन ला ओमन के मनखेमन ले अलग कर दूहूं अऊ संग म ओ जम्मो झन ला घलो, जऊन मन ओकर संग देके मोलेक के पाछू चले के दुवारा बेस्या सहीं काम करथें। ");
INSERT INTO hne_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘जऊन मनखे ह बईगा अऊ भूत-परेत साधोइयामन के पाछू चलके बेस्या सहीं काम करथे, ओकर बिरोध म होके, मेंह ओला ओकर मनखेमन ले अलग कर दूहूं। ");
INSERT INTO hne_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘एकरसेति अपनआप ला पबितर काम बर अलग करव अऊ पबितर बनव, काबरकि मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","मोर बिधि-बिधान ला मानव अऊ ओमन के पालन करव। मेंह यहोवा अंव, जऊन ह तुमन ला पबितर करथे। ");
INSERT INTO hne_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘जऊन मनखे अपन ददा या दाई ला सराप देथे, ओह मार डारे जावय। ओह अपन ददा या दाई ला सराप देय हवय, एकरसेति ओकर लहू के दोस ओकरेच मुड़ म पड़ही। ");
INSERT INTO hne_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘कहूं कोनो मनखे कोनो आने मनखे के घरवाली संग—अपन परोसी के घरवाली संग बेभिचार करथे, त ओ बेभिचारी अऊ बेभिचारिन दूनों झन मार डारे जावंय। ");
INSERT INTO hne_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘कहूं कोनो मनखे ह अपन ददा के घरवाली के संग सारीरिक संबंध बनाथे, त ओह अपन ददा के अनादर करे हवय। ओ मनखे अऊ ओ माईलोगन दूनों झन मार डारे जावंय; ओमन के लहू के दोस ओमन के मुड़ म ही पड़ही। ");
INSERT INTO hne_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘कहूं कोनो मनखे अपन बहुरिया संग सारीरिक संबंध बनाथे, त ओ दूनों झन मार डारे जावंय। ओमन असुध काम करे हवंय; ओमन के लहू के दोस ओमन के मुड़ म ही पड़ही। ");
INSERT INTO hne_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘कहूं कोनो आदमी ह कोनो आदमी संग सारीरिक संबंध बनाथे, जइसने कि कोनो माईलोगन संग बनाय जाथे, त ओ दूनों झन घिन काम करे हवंय। ओमन मार डारे जावंय; ओमन के लहू के दोस ओमन के मुड़ म ही पड़ही। ");
INSERT INTO hne_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘कहूं कोनो मनखे ह कोनो माईलोगन अऊ ओकर दाई दूनों ले बिहाव करथे, त येह दुस्ट काम अय। ओ मनखे अऊ ओ दूनों माईलोगन ला आगी म जला दिये जावय, ताकि तुम्हर बीच म दुस्ट काम झन होवय। ");
INSERT INTO hne_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘कहूं कोनो मनखे ह पसु के संग सारीरिक संबंध बनाथे, त ओ मनखे ह मार डारे जावय, अऊ ओ पसु ला घलो मार डारव। ");
INSERT INTO hne_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘कहूं कोनो माईलोगन ह कोनो पसु करा जाके ओकर संग कुकरम करथे, त ओ माईलोगन अऊ ओ पसु दूनों ला मार डारव। ओमन मार डारे जावंय; ओमन के लहू ह ओमन के मुड़ म ही पड़ही। ");
INSERT INTO hne_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘कहूं कोनो मनखे ह अपन बहिनी ले बिहाव करथे—चाहे ओह ओकर ददा के बेटी होवय या ओकर दाई के बेटी, अऊ ओकर संग सारीरिक संबंध बनाथे, त येह एक कलंक ए। ओ दूनों झन ला खुलेआम ओमन के मनखेमन ले अलग करे जावय। ओह अपन बहिनी के अनादर करे हवय अऊ ओह दोसी ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘कहूं कोनो मनखे ह कोनो माईलोगन के मासिक धरम के समय ओकर संग सारीरिक संबंध बनाथे, त ओह ओ माईलोगन के लहू बहई ला उघारे हवय, अऊ ओ माईलोगन घलो अपन लहू बहई ला उघारे हवय। एकरसेति ओ दूनों झन अपन मनखेमन ले अलग करे जावंय। ");
INSERT INTO hne_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘अपन मौसी या फूफू के संग सारीरिक संबंध झन बनावव, काबरकि ओह एक नजदीकी रिस्तेदार के अनादर होही; अऊ ओ दूनों दोसी ठहिरहीं। ");
INSERT INTO hne_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘कहूं कोनो मनखे अपन काकी के संग सारीरिक संबंध बनाथे, त ओह अपन कका के अनादर करथे। ओमन दोसी ठहिरहीं; ओमन बिगर संतान के मर जाहीं। ");
INSERT INTO hne_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘कहूं कोनो मनखे अपन भाई के घरवाली ले बिहाव करथे, त येह एक असुधता के काम अय; ओह अपन भाई के अनादर करे हवय। ओमन के कोनो संतान नइं होवय। ");
INSERT INTO hne_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘मोर जम्मो बिधि अऊ हुकूममन ला मानव अऊ ओमन के पालन करव, ताकि जऊन देस म मेंह तुमन ला रहे बर लावत हंव, उहां ले तुमन अलग झन करे जावव। ");
INSERT INTO hne_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","तुमन ओ जाति के मनखेमन के रीति-रिवाज के मुताबिक झन चलहू, जेला मेंह तुम्हर आघू ले निकालनेवाला हंव। काबरकि ओमन ये जम्मो काम करे हवंय, एकरसेति मेंह ओमन ले घिन करथंव। ");
INSERT INTO hne_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","पर मेंह तुमन ला कहे हंव, “ओमन के देस ह तुम्हर अधिकार म होही; मेंह ये देस, जेमा दूध अऊ मंधरस बहुंतायत म हवय, तुम्हर अधिकार म दे दूहूं।” मेंह यहोवा तुम्हर परमेसर अंव, जऊन ह तुमन ला आने देस के मनखेमन ले अलग करे हवय। ");
INSERT INTO hne_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘एकरसेति तुमन सुध अऊ असुध पसु म, अऊ सुध अऊ असुध चिरईमन म भेद करव। तुमन कोनो अइसने पसु या चिरई या भुइयां म रेंगइया जीव के दुवारा अपनआप ला असुध झन करव, जऊन मन ला मेंह तुम्हर बर असुध ठहिराके अलग करे हंव। ");
INSERT INTO hne_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तुमन मोर बर पबितर बने रहव, काबरकि में यहोवा ह पबितर अंव, अऊ मेंह तुमन ला आने देस के मनखेमन ले अलग करे हंव कि तुमन मोर बने रहव। ");
INSERT INTO hne_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘कोनो आदमी या माईलोगन, जऊन ह तुम्हर बीच म बईगा या भूत-परेत साधे के काम करथे, ओह मार डारे जावय। तुमन ओला पथरवाह करके मार डारव; ओकर लहू के दोस ओकरेच मुड़ म ही पड़ही।’ ” ");
INSERT INTO hne_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","फेर यहोवा ह मूसा ला कहिस, “हारून के बेटा, जऊन मन पुरोहित अंय, ओमन ला कह: ‘कहूं तुम्हर मनखेमन ले कोनो मर जावय, त ओकर कारन पुरोहित ह अपनआप ला असुध झन करय; ");
INSERT INTO hne_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","सिरिप अपन नजदीकी रिस्तेदार, याने कि अपन दाई या ददा, अपन बेटा या बेटी, अपन भाई, ");
INSERT INTO hne_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","या अपन कुंवारी बहिनी, जऊन ह ओकर भरोसा म हवय काबरकि ओकर घरवाला नइं ए—येमन के मरे म ओह अपनआप ला असुध कर सकत हे। ");
INSERT INTO hne_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","जऊन मनखेमन बिहाव के कारन ओकर रिस्तेदार अंय, ओमन बर ओह अपनआप ला असुध झन करय अऊ ये किसम ले अपबितर झन होवय। ");
INSERT INTO hne_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘पुरोहितमन अपन मुड़ झन मुड़ावंय या दाढ़ी के तीर ला झन कतरावंय या अपन देहें ला झन चिरंय-फारंय। ");
INSERT INTO hne_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ओमन अपन परमेसर बर पबितर बने रहंय अऊ अपन परमेसर के नांव ला अपबितर झन करंय। काबरकि ओमन यहोवा बर जेवन-बलिदान याने कि अपन परमेसर बर जेवन चघाथें; एकरसेति ओमन पबितर बने रहंय। ");
INSERT INTO hne_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘ओमन अइसने माईलोगन से बिहाव झन करंय, जऊन ह बेस्या के काम करके असुध हो गे हवय या ओमन अइसने कोनो माईलोगन ले बिहाव झन करंय, जऊन ला ओकर घरवाला ह तलाक दे देय हवय, काबरकि पुरोहितमन अपन परमेसर बर पबितर अंय। ");
INSERT INTO hne_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ओमन ला पबितर जानव, काबरकि ओमन तुम्हर परमेसर ला जेवन चघाथें। ओमन ला पबितर समझव, काबरकि में यहोवा ह पबितर अंव—में जऊन ह तुमन ला पबितर करथंव। ");
INSERT INTO hne_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘कहूं कोनो पुरोहित के बेटी ह बेस्या बनके अपनआप ला अपबितर करथे, त ओह अपन ददा ऊपर कलंक लगाथे; ओला आगी म जलाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘अपन भाईमन म जऊन ह महा पुरोहित होवय, जेकर मुड़ म अभिसेक के तेल रितोय गे हवय अऊ जऊन ला पुरोहित के ओनहा पहिरे बर अभिसेक करे गे हवय, ओह अपन मुड़ के चुंदी ला झन छरियावय या ओह अपन ओनहा ला झन चीरय। ");
INSERT INTO hne_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ओह ओ जगह म झन जावय, जिहां लास रखे हवय। इहां तक कि ओह अपन ददा या दाई बर घलो अपनआप ला असुध झन करय; ");
INSERT INTO hne_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ओह अपन परमेसर के पबितर-स्थान ला झन छोंड़य या येला अपबितर झन करय, काबरकि ओह अपन परमेसर के अभिसेक के तेल दुवारा अलग करे गे हवय। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘ओह कुंवारी ले ही बिहाव करय। ");
INSERT INTO hne_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ओह कोनो बिधवा, कोनो तलाकसुदा माईलोगन, या बेस्या काम ले अपबितर होय माईलोगन ले बिहाव झन करय, पर अपन मनखेमन ले सिरिप कोनो कुंवारी ले बिहाव करय, ");
INSERT INTO hne_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ताकि ओकर लइका ह ओकर मनखेमन के बीच म असुध झन होवय। में यहोवा अंव, जऊन ह ओला पबितर बनाथंव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारून ला ये कह: ‘तोर बंस के पीढ़ी-पीढ़ी म कहूं कोनो मनखे म कोनो सारीरिक दोस होवय, त ओह अपन परमेसर ला बलिदान चघाय बर लकठा म झन आवय। ");
INSERT INTO hne_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","कोनो घलो मनखे, जेमा दोस हवय, ओह लकठा म झन आवय: चाहे ओह अंधरा या खोरवा, बिगड़े चेहरा, या खराप अंग वाला होवय, ");
INSERT INTO hne_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","या ओह गोड़ या हांथ ले लूलवा होवय, ");
INSERT INTO hne_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","या कुबड़ा या बवना, या जेकर आंखी म कोनो दोस होवय, या जेकर घाव ह पक गे हवय या घाव ले पीब निकलत हवय या जेकर अंडकोस ह पिचके होवय। ");
INSERT INTO hne_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","हारून पुरोहित के बंस म ले कोनो घलो, जेकर म कोनो सारीरिक दोस हवय, ओह यहोवा ला जेवन-बलिदान चघाय बर लकठा म झन आवय; काबरकि ओमा दोस हवय, ओह अपन परमेसर के जेवन चघाय बर लकठा म झन आवय। ");
INSERT INTO hne_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ओह अपन परमेसर के महा पबितर जेवन अऊ संग म पबितर जेवन ला खा सकत हे। ");
INSERT INTO hne_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","पर ओमा सारीरिक दोस होय के कारन, ओह परदा के लकठा म या बेदी करा झन जावय, नइं तो मोर पबितर-स्थान ह अपबितर हो जाही। में यहोवा अंव, जऊन ह ओमन ला पबितर बनाथंव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ये किसम ले मूसा ह ये बात हारून अऊ ओकर बेटामन ला अऊ जम्मो इसरायलीमन ला बताईस। ");
INSERT INTO hne_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून अऊ ओकर बेटामन ला कह कि ओमन ओ पबितर बलिदानमन के संग आदर के बरताव करंय, जऊन ला इसरायलीमन मोला अरपन करथें, ताकि ओमन मोर पबितर नांव ला अपबितर झन करंय। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“ओमन ला कह: ‘तुम्हर अवइया पीढ़ीमन म, कहूं तुम्हर बंस के कोनो मनखे असुध हवय अऊ तभो ले ओह ओ पबितर बलिदान के लकठा म आथे, जऊन ला इसरायलीमन यहोवा बर अरपन करथें, त ओ मनखे ला मोर आघू ले अलग करे जावय। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘यदि हारून के बंस म ले कोनो ला असुध चमड़ी के बेमारी या धात के रोग हवय, त ओह जब तक सुध नइं हो जावय, तब तक ओह पबितर बलिदान के चीजमन ला झन खावय। ओह तब घलो असुध होही यदि ओह कोनो अइसने चीज ला छूथे, जऊन ह लास के दुवारा या बीर्य निकले मनखे के दुवारा असुध हो गे हवय, ");
INSERT INTO hne_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","या कहूं ओह कोनो रेंगइया जीव ला छूथे, जऊन ह ओला असुध करथे, या कोनो मनखे जऊन ह ओला असुध करथे, चाहे ओह कोनो घलो किसम के असुधता होवय। ");
INSERT INTO hne_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","जऊन मनखे अइसने कोनो चीज ला छूथे, ओह संझा के होवत तक असुध रहिही। ओह तब तक पबितर बलिदान के कोनो चीज ला झन खावय, जब तक ओह पानी ले नइं नहा लेवय। ");
INSERT INTO hne_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","बेर बुड़े के बाद, ओह सुध हो जाही, अऊ एकर बाद ओह पबितर बलिदान म ले खा सकत हे, काबरकि येह ओकर जेवन अय। ");
INSERT INTO hne_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ओह अपनआप मरे या जंगली पसु के दुवारा चिरे-फारे कोनो पसु ला झन खावय, नइं तो ओह असुध हो जाही। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘पुरोहितमन मोर ये किसम ले सेवा करंय कि ओमन दोसी झन ठहिरंय, नइं तो अनादर करे के कारन मर जाहीं। मेंह यहोवा अंव, जऊन ह ओमन ला पबितर करथंव। ");
INSERT INTO hne_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘पुरोहित के परिवार के छोंड़ कोनो आने मनखे पबितर बलिदान ला झन खावय, चाहे ओह पुरोहित के पहुना होवय या ओकर बनिहार, ओह कोनो पबितर चीज ला झन खावय। ");
INSERT INTO hne_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","पर कोनो पुरोहित ह कोनो गुलाम ला पईसा देके बिसा लेथे या कोनो गुलाम ह पुरोहित के घर म जनमे हवय, त ओ गुलाम ह ओमा ले खा सकत हे। ");
INSERT INTO hne_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","कहूं कोनो पुरोहित के बेटी ह अइसने मनखे ले बिहाव करथे, जऊन ह पुरोहित नो हय, त पुरोहित के ओ बेटी ह पबितर बलिदान के कोनो चीज ला झन खावय। ");
INSERT INTO hne_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","पर कहूं कोनो पुरोहित के बेटी ह बिधवा हो जाथे या ओला ओकर घरवाला छोंड़ देथे अऊ ओकर लोग-लइका नइं रहंय अऊ ओह अपन जवानी के दिन म अपन ददा के घर म फेर आके रहिथे, त ओह अपन ददा के जेवन ला खा सकत हे, पर कोनो आने मनखे ओमा ले झन खावय। ");
INSERT INTO hne_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘कहूं कोनो मनखे अनजाने म पबितर बलिदान के चीज ला खा लेथे, त ओह ओ बलिदान के कीमत संग ओकर पांचवां भाग बढ़ाके पुरोहित ला भरपई कर देवय। ");
INSERT INTO hne_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","इसरायलीमन जऊन पबितर बलिदान यहोवा ला चघाथें, ओला पुरोहितमन इसरायलीमन ला खाय के अनुमति देके अपबितर झन करंय, ");
INSERT INTO hne_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","नइं तो ओमन दोसी ठहिरहीं अऊ ओमन ला दाम चुकाना पड़ही। मेंह यहोवा अंव, जऊन ह ओमन ला पबितर करथंव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून अऊ ओकर बेटामन ला अऊ जम्मो इसरायलीमन ले गोठिया अऊ ओमन ला कह: ‘तुमन म ले कोनो—चाहे इसरायली होवय या इसरायल म रहइया कोनो परदेसी—यदि ओह यहोवा ला होम-बलिदान के भेंट चघाथे, चाहे ओह बदना के होवय या स्वेच्छा-बलिदान के होवय, ");
INSERT INTO hne_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","त ओह पसु, भेड़ या बोकरा म ले निरदोस नर पसु होवय, ताकि येह तुम्हर कोति ले गरहन करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","जऊन पसु म कोनो दोस होवय, ओला झन लानव, काबरकि ओह तुम्हर कोति ले गरहन नइं करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","जब कोनो अपन बिसेस बदना या स्वेच्छा-बलिदान ला पूरा करे बर गाय-बईला या भेड़-बकरी म ले कोनो पसु ला यहोवा करा मेल-बलिदान चघाय बर लानथे, त गरहन करे बर जरूरी अय कि ओ पसु ह बिगर दोस के होवय। ");
INSERT INTO hne_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","जऊन पसु ह अंधरा या चोट खाय या अपंग होवय, या जेमा गांठ, या पके या बहत घाव होवय, अइसने पसु ला यहोवा बर बलि झन चघावव। अइसने कोनो पसु ला यहोवा बर जेवन-बलिदान के रूप म बेदी ऊपर झन रखव। ");
INSERT INTO hne_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","तुमन कोनो कुरूप बईला या भेड़ ला अपन स्वेच्छा-बलिदान के रूप म चघा सकत हव, पर येह बदना पूरा होय के बलिदान के रूप म गरहन नइं होवय। ");
INSERT INTO hne_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","जऊन पसु के अंडकोस ह चोट खाय, कुचराय, फटे या कटे हवय, ओला तुमन यहोवा बर झन चघावव। तुमन अपन देस म अइसन बलिदान के काम झन करव, ");
INSERT INTO hne_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","अऊ तुमन न तो अइसने पसु ला कोनो परदेसी के हांथ ले लेवव अऊ न ही ओला अपन परमेसर के जेवन के रूप म चघावव। ओह तुम्हर बर गरहन नइं होवय, काबरकि ओह कुरूप हे अऊ ओमा दोस हवय।’ ” ");
INSERT INTO hne_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“जब कोनो बछवा, मेढ़ा-पीला या छेरी-पीला के जनम होवय, त ओह सात दिन तक अपन दाई के संग म रहय। आठवां दिन ले, ओह यहोवा बर जेवन-बलिदान के रूप म गरहन करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","चाहे गाय होवय या भेड़, ओला अऊ ओकर पीला ला एक ही दिन म झन मारव। ");
INSERT INTO hne_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“जब तुमन यहोवा ला धनबाद-बलिदान चघाथव, त ये किसम ले चघावव कि ओह तुम्हर कोति ले गरहन करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ओला ओहीच दिन खाय जावय; ओमा के कोनो चीज बिहान होवत तक झन बांचय। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“मोर हुकूममन ला मानव अऊ ओमन के पालन करव। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","मोर पबितर नांव ला अपबितर झन करहू, काबरकि जरूरी अय कि मेंह इसरायलीमन के दुवारा पबितर माने जावंव। मेंह यहोवा अंव, जऊन ह तुमन ला पबितर करिस, ");
INSERT INTO hne_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","अऊ जऊन ह तुमन ला मिसर देस ले निकालके लानिस ताकि तुम्हर परमेसर होवय। मेंह यहोवा अंव।” ");
INSERT INTO hne_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इसरायलीमन ले गोठिया अऊ ओमन ला कह: ‘येमन मोर ठहिराय तिहार, यहोवा के ठहिराय तिहार अंय, जेकर तुमन पबितर सभा के रूप म घोसना करव। ");
INSERT INTO hne_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘हर हप्ता छै दिन बुता करे जावय, पर सातवां दिन एक बिसराम के दिन, एक पबितर सभा के दिन अय। जिहां घलो रहव, तुमन ओ दिन कोनो घलो किसम के बुता-काम झन करव; येह यहोवा बर बिसराम के दिन अय। ");
INSERT INTO hne_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘येमन यहोवा के ठहिराय तिहार, पबितर सभा अंय, जेकर तुमन ओमन के ठहिराय समय म घोसना करव: ");
INSERT INTO hne_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","हर साल पहिली महिना के चौदहवां दिन के बेर बुड़े के बाद यहोवा के फसह तिहार सुरू होथे। ");
INSERT INTO hne_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ओहीच महिना के पंदरहवां दिन यहोवा के अखमीरी रोटी के तिहार सुरू होथे; सात दिन तक तुमन बिगर खमीर के बने रोटी खावव। ");
INSERT INTO hne_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ये तिहार के पहिली दिन तुमन एक पबितर सभा करव, अऊ ओ दिन तुमन रोजमर्रा के काम झन करव। ");
INSERT INTO hne_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","पर सातों दिन तुमन यहोवा ला जेवन-बलिदान चघावव। अऊ सातवां दिन एक पबितर सभा करव अऊ ओ दिन रोजमर्रा के काम झन करव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इसरायलीमन ले गोठिया अऊ ओमन ला कह: ‘जब तुमन ओ देस म जावव, जऊन ला मेंह तुमन ला देवइया हंव अऊ उहां जब फसल काटव, त लुए गय पहिली-फसल के एक करपा तुमन पुरोहित करा लानव। ");
INSERT INTO hne_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","पुरोहित ह ओ करपा ला यहोवा के आघू म हलावय कि ओह तुम्हर बर गरहन करे जावय; पुरोहित ह ओला बिसराम दिन के दूसर दिन हलावय। ");
INSERT INTO hne_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","जऊन दिन तुमन ओ करपा ला हलावव, ओ दिन एक बछर के निरदोस मेढ़ा-पीला ला तुमन यहोवा ला होम-बलिदान के रूप म चघावव, ");
INSERT INTO hne_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","अऊ ओकर संग म जैतून तेल म सनाय बहुंत बढ़िया पीसान के एक एपा के दू-दसवां भाग अन्न-बलिदान के रूप म यहोवा ला चघावव; येह यहोवा बर सुख-देवइया सुगंधवाला एक जेवन-बलिदान होही, अऊ एकर संग म एक हीन के चौथा भाग अंगूर के मंद पेय-बलिदान के रूप म चघावव। ");
INSERT INTO hne_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","जब तक तुमन अपन परमेसर करा ये बलिदान नइं ले जावव, ओ दिन तक तुमन कोनो रोटी, या भुने या नवां अन्न झन खावव। तुमन जिहां घलो रहव, येह तुम्हर पीढ़ी-पीढ़ी तक हमेसा के बिधि ठहिरय। ");
INSERT INTO hne_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘बिसराम दिन के दूसर दिन, याने कि जऊन दिन तुमन हलाय-बलिदान के करपा ला लानेव, ओ दिन ले लेके पूरा सात हप्ता गन लेवव। ");
INSERT INTO hne_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातवां बिसराम दिन के दूसर दिन तक याने पचास दिन गनव, अऊ ओ पचासवां दिन यहोवा ला नवां अन्न के बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तुमन जिहां घलो रहव, बहुंत बढ़िया पीसान के एपा के दू-दसवां भाग ले बने दू ठन रोटी लानव, जऊन म खमीर मिले रहय अऊ येला पहिली-फसल के हलाय-बलिदान के रूप म यहोवा ला चघावव। ");
INSERT INTO hne_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","अऊ ओ रोटी के संग एक-एक बछर के सात ठन निरदोस मेढ़ा-पीला, एक ठन जवान बछवा अऊ दू ठन मेढ़ा चघावव। येमन यहोवा बर ओमन के अन्न-बलिदान अऊ पेय-बलिदान के संग एक होम-बलिदान होहीं अऊ येह यहोवा बर महकत सुख-देवइया एक जेवन-बलिदान होही। ");
INSERT INTO hne_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","तब तुमन पाप-बलिदान बर एक ठन बोकरा अऊ मेल-बलिदान बर एक-एक बछर के दू ठन मेढ़ा-पीला चघावव। ");
INSERT INTO hne_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","पुरोहित ह पहिली-फसल के रोटी संग, ओ दूनों मेढ़ा-पीला ला हलाय-बलिदान के रूप म यहोवा के आघू म हलावय। ओमन यहोवा बर पबितर बलिदान अऊ पुरोहित के बांटा अंय। ");
INSERT INTO hne_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ओहीच दिन तुमन एक पबितर सभा के हांका परवाव अऊ कोनो रोजमर्रा के काम झन करव। तुमन जिहां घलो रहव, येह तुम्हर पीढ़ी-पीढ़ी तक हमेसा के बिधि ठहिरय। ");
INSERT INTO hne_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘जब तुमन अपन भुइयां के फसल लुवव, त अपन खेत के एकदम तीर के फसल ला झन लुवव अऊ गिरे बालमन ला झन संकेलव। ओमन ला गरीब अऊ तुम्हर बीच म रहइया परदेसीमन बर छोंड़ दव। मेंह यहोवा तुम्हर परमेसर अंव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इसरायलीमन ला कह: ‘हर साल सातवां महिना के पहिली दिन तुम्हर बर बिसराम दिन होवय, अऊ ओ दिन पबितर सभा जूरय अऊ तुरही बजाके आनंद मनावय। ");
INSERT INTO hne_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ओ दिन रोजमर्रा के काम झन करव, पर यहोवा बर एक जेवन-बलिदान चघावव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ओ सातवां महिना के दसवां दिन ह प्रायस्चित के दिन अय। ओ दिन पबितर सभा करे जावय अऊ अपनआप के इनकार करव अऊ यहोवा ला जेवन-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ओ दिन तुमन कोनो काम-बुता झन करव, काबरकि ओह प्रायस्चित के दिन अय, अऊ यहोवा तुम्हर परमेसर के आघू म तुम्हर बर प्रायस्चित करे जाही। ");
INSERT INTO hne_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ओ दिन जऊन मन अपनआप के इनकार नइं करंय, ओमन अपन मनखेमन के समाज ले अलग करे जावंय। ");
INSERT INTO hne_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","जऊन मनखे ह ओ दिन कोनो किसम के काम-बुता करथे, ओला मेंह ओकर मनखेमन के बीच ले नास कर दूहूं। ");
INSERT INTO hne_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तुमन कोनो घलो किसम के काम झन करहू। तुमन जिहां घलो रहव, येह पीढ़ी-पीढ़ी तक तुम्हर बर हमेसा के बिधि होवय। ");
INSERT INTO hne_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","येह तुम्हर बर बिसराम दिन अय, अऊ तुमन अपनआप के इनकार करव। ओ महिना के नौवां दिन के संझा ले लेके दूसर दिन के संझा तक तुमन अपन बिसराम दिन माने करव।” ");
INSERT INTO hne_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इसरायलीमन ला कह: ‘सातवां महिना के पंदरहवां दिन यहोवा के पबितर-तम्बूमन के तिहार सुरू होथे अऊ येह सात दिन तक चलथे। ");
INSERT INTO hne_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहिली दिन पबितर सभा होवय; ओ दिन कोनो काम झन करव। ");
INSERT INTO hne_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ये सातों दिन यहोवा ला जेवन-बलिदान चघावव, अऊ आठवां दिन तुमन पबितर सभा करव अऊ यहोवा ला जेवन-बलिदान चघावव। येह तिहार खतम करे के बिसेस सभा अय; ओ दिन रोजमर्रा के काम झन करव। ");
INSERT INTO hne_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘येमन यहोवा के ठहिराय तिहारमन अंय, जेमन ला तुमन पबितर सभा के रूप म घोसना करव ताकि यहोवा बर जेवन-बलिदान—याने कि होम-बलिदान अऊ अन्न-बलिदान, चढ़ावा अऊ पेय-बलिदान हर दिन के जरूरत के मुताबिक लाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ये बलिदानमन ओ बलिदानमन के अलावा होहीं, जऊन ला तुमन यहोवा के बिसराम दिन अऊ तुम्हर भेंट अऊ तुम्हर बदना अऊ स्वेच्छा-बलिदान के रूप म यहोवा ला चघाहू।) ");
INSERT INTO hne_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘जब तुमन भुइयां के ऊपज ला संकेल डारव, तब सातवां महिना के पंदरहवां दिन ले सुरू करके सात दिन तक यहोवा के तिहार मनावव; पहिला दिन ह बिसराम दिन अय, अऊ आठवां दिन घलो बिसराम दिन अय। ");
INSERT INTO hne_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पहिला दिन तुमन घना रूख के डारामन ला याने कि खजूर, सरई अऊ आने पानवाला रूख के डारामन ला लेके यहोवा तुम्हर परमेसर के आघू म सात दिन तक आनंद मनावव। ");
INSERT INTO hne_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","तुमन येला हर साल सात दिन तक यहोवा बर तिहार के रूप म मनाय करव। येह तुम्हर पीढ़ी-पीढ़ी तक हमेसा के बिधि होवय; हर साल सातवां महिना म ये तिहार ला मनावव। ");
INSERT INTO hne_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","सात दिन तक तुमन कुंदरा म रहव: जम्मो देस म जनमे इसरायलीमन अइसने कुंदरा म रहंय, ");
INSERT INTO hne_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ताकि तुम्हर बंस के मनखेमन जान सकंय कि जब मेंह इसरायलीमन ला मिसर देस ले निकालके लानत रहेंव, त ओमन ला मेंह कुंदरामन म रखे रहेंव। मेंह यहोवा तुम्हर परमेसर अंव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ये किसम ले, मूसा ह इसरायलीमन ला यहोवा के ठहिराय तिहारमन ला बताईस। ");
INSERT INTO hne_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इसरायलीमन ला हुकूम दे कि ओमन अंजोर करे बर जैतून के पेरके निकाले सुध तेल लानंय ताकि दीयामन हरदम बरत रहंय। ");
INSERT INTO hne_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","परदा के बाहिर जऊन ह मिलापवाला तम्बू म करार कानून के सन्दूक ला ओधा करथे, उहां हारून ह यहोवा के आघू म संझा ले बिहान होवत तक लगातार दीयामन के देखरेख करय। येह पीढ़ी-पीढ़ी तक हमेसा के बिधि होवय। ");
INSERT INTO hne_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ओ दीया जऊन मन सुध सोन के दीवट म यहोवा के आघू म हवंय, ओमन के लगातार देखरेख करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“बहुंत बढ़िया पीसान के बारह ठन रोटी सेंकके बनावव अऊ हर एक रोटी ह एपा के दू-दसवां भाग म बनाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","तुमन ओमन ला सुध सोन के मेज ऊपर दू जगह म, याने एक-एक जगह म छै-छै ठन करके यहोवा के आघू म रख देवव। ");
INSERT INTO hne_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","दूनों जगह म सुध धूप रखव, कि ओह रोटी के सेति सुरता-देवइया हिस्सा अऊ यहोवा बर जेवन-बलिदान होवय। ");
INSERT INTO hne_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ये रोटी ला हमेसा के करार के रूप म इसरायलीमन कोति ले हर बिसराम के दिन लगातार यहोवा के आघू म रखे जावय। ");
INSERT INTO hne_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ये रोटी ह हारून अऊ ओकर बेटामन के अय अऊ ओमन येला पबितर-स्थान के छेत्र म खावंय, काबरकि येह यहोवा ला चघाय जेवन-बलिदान के ओमन के हमेसा के महा पबितर भाग अय।” ");
INSERT INTO hne_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","एक इसरायली माईलोगन के बेटा, जेकर ददा ह मिसरी रिहिस, इसरायली मनखेमन के बीच म चल दीस, अऊ डेरा म इसरायली माईलोगन के ओ बेटा अऊ एक इसरायली के बीच झगरा हो गीस। ");
INSERT INTO hne_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ओ इसरायली माईलोगन के बेटा ह सराप देके यहोवा के नांव के निन्दा करे लगिस। एकरसेति ओला मनखेमन मूसा करा ले गीन। (ओकर दाई के नांव सलोमीत रिहिस, जऊन ह दान के गोत्र के दिबरी के बेटी रिहिस।) ");
INSERT INTO hne_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","मनखेमन ओकर बारे म यहोवा के ईछा के पता चलत तक ओला हवालात म रखिन। ");
INSERT INTO hne_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ओ निन्दा करइया ला डेरा के बाहिर ले जा। अऊ जतेक झन ओला सराप देवत सुने हवंय, ओमन अपन हांथ ओकर मुड़ म रखंय, अऊ जम्मो सभा के मनखेमन ओला पथरवाह करंय। ");
INSERT INTO hne_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","तेंह इसरायलीमन ला कह: ‘जऊन कोनो अपन परमेसर ला सराप देथे, ओह दोसी ठहिराय जाही; ");
INSERT INTO hne_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","जऊन कोनो यहोवा के नांव के निन्दा करथे, ओह मार डारे जावय। जम्मो सभा के मनखेमन ओला पथरा फेंक-फेंकके मारंय। चाहे कोनो परदेसी होवय या देसी मनखे होवय, जब कोनो घलो मनखे परमेसर के नांव के निन्दा करथे, त ओह मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘जऊन मनखे कोनो आने मनखे के परान ले लेथे, त ओह मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","जऊन मनखे कोनो आने मनखे के पसु के परान ले लेथे, त ओह ओकर भरपई दूसर पसु देके करय। ");
INSERT INTO hne_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","जब कोनो मनखे ह अपन परोसी के देहें ला चोट पहुंचाथे, त ओला घलो ओही किसम ले चोट पहुंचाय जावय: ");
INSERT INTO hne_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","हाड़ा टोरई के बलदा हाड़ा टोरई, आंखी के बलदा आंखी, दांत के बलदा दांत। जऊन मनखे ह जइसने चोट कोनो आने मनखे ला देय हवय, ओला घलो वइसनेच चोट पहुंचाय जावय। ");
INSERT INTO hne_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","कोनो मनखे ह कोनो पसु ला मार डारथे, त ओ मनखे ह ओकर भरपई जरूर करय, पर जऊन मनखे ह कोनो आने मनखे ला मार डारथे, त ओला घलो मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","चाहे परदेसी होवय या देसी मनखे, जम्मो बर तुम्हर ओहीच कानून होवय। मेंह यहोवा तुम्हर परमेसर अंव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","तब मूसा ह इसरायलीमन ले बात करिस, अऊ ओमन ओ निन्दा करइया ला डेरा के बाहिर ले गीन अऊ ओला पथरवाह करिन। इसरायलीमन वइसनेच करिन, जइसने यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","यहोवा ह सीनय परबत ऊपर मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इसरायलीमन ले गोठिया अऊ ओमन ला कह: ‘जब तुमन ओ देस म जावव, जऊन ला मेंह तुमन ला देवइया हंव, त ओ देस ह खुद यहोवा बर एक बिसराम बछर ला मानय। ");
INSERT INTO hne_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","तुमन छै बछर ले अपन खेत ला बोवव, अऊ छै बछर ले अपन अंगूर के बारी के नारमन ला छांटव अऊ ओमन के फर ला संकेलव, ");
INSERT INTO hne_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","पर सातवां बछर ह भुइयां बर बिसराम के बछर होवय; येह यहोवा के नांव म बिसराम के बछर अय। ये साल न तो अपन खेत ला बोवव, अऊ न ही अपन अंगूर के बारी के नारमन ला छांटव। ");
INSERT INTO hne_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","खेत म जऊन कुछू अपनआप बाढ़थे, ओला झन लुवव या परिया छोंड़े गे अंगूर के नारमन के फर ला झन संकेलव। भुइयां ला एक बछर के बिसराम मिलय। ");
INSERT INTO hne_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","बिसराम बछर के समय भुइयां म जऊन घलो ऊपज अपनआप होथे, ओह तुम्हर बर जेवन होही—तुम्हर, तुम्हर सेवक या सेविका, बनिहार अऊ तुम्हर बीच म कुछू समय तक रहइया मनखेमन बर जेवन होही, ");
INSERT INTO hne_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","अऊ ओह तुम्हर पसु अऊ तुम्हर देस के जंगली पसुमन के घलो जेवन होही। भुइयां म जऊन घलो ऊपज अपनआप होथे, ओला खाय जा सकत हे। ");
INSERT INTO hne_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘तुमन सात बिसराम बछर गनव—सात बछर के सात गुना—ताकि उनचास बछर म सात बिसराम बछर होवय। ");
INSERT INTO hne_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","तब तुमन पचासवां साल के सातवां महिना के दसवां दिन याने प्रायस्चित के दिन अपन पूरा देस म तुरही फुंकवाव। ");
INSERT INTO hne_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ओ पचासवां बछर ला पबितर मानव अऊ देस म रहइया जम्मो झन के छुटकारा के घोसना करव। येह तुम्हर बर जुबली बछर होही; तुमन म ले हर एक झन अपन परिवारिक संपत्ति अऊ अपन खुद के कुल म लहुंटय। ");
INSERT INTO hne_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","तुम्हर बर ये पचासवां बछर ह जुबली बछर होवय; तुमन न तो बोवव, अऊ न ही अपनआप जामे फसल ला लुवव, अऊ न ही बिगर छांटे अंगूर के नार म फरे फर ला टोरव। ");
INSERT INTO hne_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","काबरकि येह जुबली बछर अय अऊ येह तुम्हर बर पबितर होवय। जऊन ऊपज तुम्हर करा सीधा खेत ले लाय जाथे, सिरिप ओला खावव। ");
INSERT INTO hne_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘ये जुबली बछर म हर एक मनखे अपन खुद के भुइयां म लहुंटय। ");
INSERT INTO hne_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘कहूं तुमन अपन कोनो मनखे ला भुइयां बेचथव या ओकर ले भुइयां बिसाथव, त एक-दूसर ले फायदा झन लेवव। ");
INSERT INTO hne_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","जुबली बछर के बाद, जतका बछर बीत गे होवय, ओकर गनती के आधार म तुमन अपन मनखेमन ले भुइयां बिसावव। अऊ ओमन फसल लुए बर बांचे बछर के गनती के आधार म अपन भुइयां ला तुम्हर करा बेचंय। ");
INSERT INTO hne_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","जतका जादा बछर बांचे रहय, ओतका जादा दाम बढ़ावव, अऊ जतका कम बछर बांचे रहय, ओतका ही दाम घटावव, काबरकि सही म जऊन चीज ह बेचे जावत हे, ओह बछर के हिसाब से ओकर फसल अय। ");
INSERT INTO hne_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","एक-दूसर ले फायदा झन लेवव, पर अपन परमेसर के भय मानव। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘मोर बिधिमन ला मानव अऊ धियान देके मोर कानूनमन के पालन करव, त तुमन निडर होके देस म बसे रहिहू। ");
INSERT INTO hne_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","तब भुइयां ह अपन फसल उपजाही, अऊ तुमन पेट भर खाहू अऊ उहां निडर बसे रहिहू। ");
INSERT INTO hne_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","तुमन पुछ सकत हव, “यदि सातवां बछर म, हमन नइं बोवन या अपन फसल ला नइं लुवन, त ओ बछर म, हमन का ला खाबो?” ");
INSERT INTO hne_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","मेंह छठवां बछर म अइसने आसीस दूहूं कि भुइयां ह ओ साल तीन बछर के बरोबर फसल दीही। ");
INSERT INTO hne_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","जब तुमन आठवां बछर म बोवई करव, त जुन्ना फसल म ले तब तक खावत रहव, जब तक कि नौवां बछर के फसल के लुवई नइं हो जावय। ");
INSERT INTO hne_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘भुइयां ला सब दिन बर झन बेचव, काबरकि भुइयां ह मोर अय अऊ तुमन मोर भुइयां म परदेसी अऊ अजनबी के सहीं रहिथव। ");
INSERT INTO hne_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ओ जम्मो भुइयां, जऊन ह तुम्हर अधिकार म हवय, ओकर छुटकारा के परबंध जरूर करव। ");
INSERT INTO hne_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘कहूं तुम्हर कोनो संगी इसरायली गरीब हो जावय अऊ अपन कुछू संपत्ति ला बेचय, त ओकर सबले नजदीकी रिस्तेदार ह आवय अऊ ओ बेचे गय चीज ला छोंड़ावय। ");
INSERT INTO hne_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","कहूं ओकर बर छुड़ानेवाला कोनो नइं ए, पर बाद म, जब ओह खुद धनवान हो जाथे अऊ ओकर करा ओला छोंड़ाय बर धन हो जाथे, ");
INSERT INTO hne_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","त ओह ओ संपत्ति के बेचे जाय के पाछू के बछर के हिसाब से दाम तय करय अऊ ओ दाम बेचे गय मनखे ला वापिस कर देवय; ओह तब फेर अपन संपत्ति म काबिज हो सकथे। ");
INSERT INTO hne_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","पर कहूं ओकर करा अतका पूंजी नइं ए कि ओह फेर अपन संपत्ति ला बिसा सकय, त फेर ओ संपत्ति ह बिसइया के ही अधिकार म जुबली बछर तक रहिही। ओ संपत्ति ला जुबली बछर म वापिस करे जाही, अऊ तब ओह अपन संपत्ति म अधिकार कर सकत हे। ");
INSERT INTO hne_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘कोनो मनखे दीवारवाले सहर म घर बेचथे, त बेचे जाय के पाछू एक बछर तक ओकर करा छोंड़ाय के अधिकार रहिथे। ओ एक साल म बेचइया ह अपन घर ला छोंड़ा सकत हे। ");
INSERT INTO hne_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","कहूं ओ एक बछर के पूरा होवत तक ओ घर ला छोंड़ाय नइं जावय, त दीवारवाले सहर के ओ घर ह सब दिन बर बिसइया अऊ ओकर संतानमन के हो जाही। येला जुबली बछर म झन वापिस करे जावय। ");
INSERT INTO hne_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","पर बिगर दीवार के गांवमन के घरमन ला देस के खेत सहीं समझे जावय। ओमन ला छोंड़ाय जा सकत हे, अऊ ओमन ला जुबली बछर म वापिस कर दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘लेवीमन ला अपन अधिकार के लेवी सहरमन म हमेसा अपन घर ला छोंड़ाय के अधिकार हवय। ");
INSERT INTO hne_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","एकरसेति लेवीमन के संपत्ति ह छोंड़ाय जा सकत हे—याने कि ओमन के अधिकार के सहर म बेचे गय कोनो घर—अऊ ये घर ह जुबली बछर म वापिस करे जावय, काबरकि इसरायलीमन के बीच, लेवीमन के सहर के घरमन लेवीमन के संपत्ति अंय। ");
INSERT INTO hne_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","पर ओमन के नगर के चरागन ह झन बेचे जावय; काबरकि येमा ओमन के हमेसा के अधिकार हवय। ");
INSERT INTO hne_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘कहूं तुम्हर कोनो संगी इसरायली गरीब हो जाथे, अऊ तुम्हर बीच म ओकर दुरदसा होवय, त तुमन ओकर मदद करव, जइसने कि तुमन कोनो परदेसी अऊ अजनबी ला करथव, ताकि ओह तुम्हर बीच म रह सकय। ");
INSERT INTO hne_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","तुमन ओकर ले बियाज झन लेवव या ओकर ले कोनो फायदा झन लेवव, पर अपन परमेसर के भय मानव, ताकि ओह तुम्हर बीच म रह सकय। ");
INSERT INTO hne_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तुमन ओला न तो बियाज म पईसा उधार देवव अऊ न ही फायदा लेके ओला जेवन के कोनो चीज बेचव। ");
INSERT INTO hne_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","मेंह यहोवा तुम्हर परमेसर अंव, जऊन ह तुमन ला मिसर देस ले निकालके लानेंव, ताकि तुमन ला कनान देस देवंव अऊ तुम्हर परमेसर होवंव। ");
INSERT INTO hne_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘कहूं तुम्हर कोनो संगी इसरायली गरीब हो जाथे अऊ अपनआप ला तुम्हर हांथ म बेच देथे, त तुमन ओकर ले गुलाम सहीं काम झन करावव। ");
INSERT INTO hne_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ओकर संग बनिहार या तुम्हर बीच म कुछू समय तक रहइया मनखे सहीं बरताव करव; ओह तुम्हर बर जुबली बछर तक काम करय। ");
INSERT INTO hne_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","तब ओह अऊ ओकर लइकामन छोंड़ दिये जावंय, ताकि ओमन अपन गोत्र अऊ अपन पुरखामन के संपत्ति करा वापिस जा सकंय। ");
INSERT INTO hne_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","काबरकि इसरायलीमन मोर सेवक अंय, जऊन मन ला मेंह मिसर देस ले निकालके लानेंव; ओमन ला गुलाम के रूप म झन बेचे जावय। ");
INSERT INTO hne_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ओमन ऊपर कठोरता से सासन झन करव, पर अपन परमेसर के भय मानव। ");
INSERT INTO hne_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘तुम्हर पुरूस अऊ महिला गुलाममन तुम्हर चारों कोति के आनजात के होवंय, जेमन ला तुमन गुलाम के रूप म बिसावव। ");
INSERT INTO hne_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","जऊन मन तुम्हर बीच म कुछू समय बर रहत हवंय अऊ ओमन के कुल के सदस्य, जऊन मन तुम्हर देस म जनमे हवंय, येमा के कुछू झन ला घलो तुमन बीसा सकत हव, अऊ ओमन तुम्हर संपत्ति हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुमन ओमन ला अपन लइकामन बर उत्तराधिकार म मिले संपत्ति के रूप म वसीयत कर सकत हव अऊ ओमन ला जिनगी भर गुलाम बना सकत हव, पर तुमन अपन संगी इसरायलीमन ऊपर कठोरता से सासन झन करव। ");
INSERT INTO hne_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘कहूं तुम्हर बीच म रहइया कोनो परदेसी धनी हो जाथे अऊ तुम्हर कोनो संगी इसरायली गरीब हो जाथे अऊ अपनआप ला ओ परदेसी या परदेसी के गोत्र के कोनो सदस्य करा बेच देथे, ");
INSERT INTO hne_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","त अपनआप ला बेचे के बाद, ओकर करा छुटकारा के अधिकार रहिथे। ओकर कोनो रिस्तेदार ओला छोंड़ा सकत हे: ");
INSERT INTO hne_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ओकर कोनो कका या चचेरा-भाई या ओकर गोत्र म ओकर कोनो खून के रिस्तेदार ओला छोंड़ा सकत हे। या कहूं ओह धनी हो जाथे, त ओह अपनआप ला छोंड़ा सकत हे। ");
INSERT INTO hne_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ओह अपन बिसइया के संग अपन बेचे जाय के बछर ले जुबली बछर तक गनय। ओ गने गय बछर म एक बनिहार के कतेक बनी होथे, ओकर मुताबिक ओकर छोंड़ाय जाय के दाम होवय। ");
INSERT INTO hne_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","कहूं जादा बछर बांचे हवय, त ओकर बर दिये गय दाम के एक बड़े भाग ला अपन छुटकारा बर लहुंटा देवय। ");
INSERT INTO hne_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","कहूं जुबली बछर बर सिरिप थोरकून बछर बांचे हवय, त ओमन ओकर हिसाब लगावंय अऊ ओकर मुताबिक ओकर छुटकारा के दाम चुकावंय। ");
INSERT INTO hne_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ओला साल दर साल बनिहार के सहीं समझे जावय; तुमन ये बात के धियान रखव कि ओकर मालिक ह ओकर ऊपर कठोरता से सासन झन करय। ");
INSERT INTO hne_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘कहूं कोनो इसरायली येमा के कोनो घलो किसम ले छोंड़ाय नइं जावय, त ओला अऊ ओकर लइकामन ला जुबली बछर म छोंड़ दिये जावय, ");
INSERT INTO hne_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","काबरकि इसरायलीमन सेवक के रूप म मोर अंय। ओमन मोर सेवक अंय, जऊन मन ला मेंह मिसर देस ले निकालके लानेंव। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘तुमन अपन बर मूरती झन बनावव या अपन बर कोनो फोटू या कोनो पबितर पथरा झन ठाढ़ करव, अऊ अपन देस म दंडवत करे बर तुमन तरासके बनाय गय कोनो पथरा झन रखव। मेंह यहोवा तुम्हर परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘मोर बिसराम दिनमन ला मानव अऊ मोर पबितर-स्थान के आदर करव। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘कहूं तुमन मोर बिधिमन म चलहू अऊ मोर हुकूममन के धियान से पालन करहू, ");
INSERT INTO hne_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","त मेंह तुम्हर बर सही रितु म बरसा भेजहूं, अऊ भुइयां ह अपन फसल उपजाही अऊ रूखमन अपन फर दीहीं। ");
INSERT INTO hne_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","तुम्हर मिंजई के काम ह चलते रहिही, जब तक कि अंगूर टोरे के समय नइं आ जावय अऊ अंगूर टोरई ह लगातार चलते रहिही, जब तक कि बोये के समय ह नइं आ जावय, अऊ तुमन भरपेट भोजन करहू अऊ अपन देस म सुरकछित बसे रहिहू। ");
INSERT INTO hne_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘मेंह देस म सुख-सांति दूहूं, अऊ तुमन अराम से सुतहू अऊ तुमन ला कोनो डरवइया नइं होहीं। मेंह देस म ले हिंसक जंगली पसुमन ला निकाल दूहूं, अऊ तुम्हर देस म कोनो तलवार ले नइं मारे जाही। ");
INSERT INTO hne_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","तुमन अपन बईरीमन के पीछा करहू अऊ ओमन तुम्हर आघू म तलवार ले मारे जाहीं। ");
INSERT INTO hne_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुमन के पांच झन ह सौ झन ला अऊ तुमन के सौ झन ह दस हजार ला भगाहीं, अऊ तुम्हर बईरीमन तुम्हर आघू म तलवार ले मारे जाहीं। ");
INSERT INTO hne_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘मेंह तुम्हर ऊपर दया करहूं अऊ तुमन ला फलवंत करहूं अऊ तुमन ला गनती म बढ़ाहूं, अऊ मेंह अपन करार ला तुम्हर संग पूरा करहूं। ");
INSERT INTO hne_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","नवां फसल ला रखे बर जब तुमन बीते बछर के फसल ला हटाहू, तब भी तुमन जुन्ना फसल ला खावत रहिहू। ");
INSERT INTO hne_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","मेंह तुम्हर बीच म अपन निवास के जगह बनाहूं, अऊ मेंह तुमन ले घिन नइं करहूं। ");
INSERT INTO hne_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","मेंह तुम्हर बीच म चले-फिरे करहूं अऊ तुम्हर परमेसर होहूं, अऊ तुमन मोर मनखे होहू। ");
INSERT INTO hne_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","मेंह यहोवा तुम्हर परमेसर अंव, जऊन ह तुमन ला मिसर देस ले निकालके लानेंव, ताकि तुमन मिसरी मनखेमन के गुलाम झन बने रहव; मेंह तुम्हर जुड़ा के डांड़ी ला टोर दे हंव अऊ तुमन ला अइसने कर दे हंव कि तुमन मुड़ उठाके चल सकव। ");
INSERT INTO hne_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘पर कहूं तुमन मोर नइं सुनहू अऊ ये जम्मो हुकूममन के पालन नइं करहू, ");
INSERT INTO hne_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","अऊ कहूं तुमन मोर बिधिमन ला गरहन नइं करहू अऊ मोर कानून ले घिन करहू अऊ मोर जम्मो हुकूममन ला नइं मानहू अऊ ये किसम ले मोर करार ला टोर दूहू, ");
INSERT INTO hne_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","त फेर मेंह तुम्हर संग अइसन करहूं: मेंह तुम्हर ऊपर अचानक आतंक, नास करइया बेमारी अऊ जर लानहूं, जेकर ले तुम्हर आंखी ह नइं दिखही अऊ तुमन अब्बड़ दुख पाहू। तुम्हर बीज बोवई ह घलो बेकार होही, काबरकि ओला तुम्हर बईरीमन खा डारहीं। ");
INSERT INTO hne_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","मेंह तुम्हर बिरोध म हो जाहूं, जेकर ले तुमन अपन बईरीमन ले हार जाहू; जऊन मन तुम्हर ले घिन करथें, ओमन तुम्हर ऊपर सासन करहीं, अऊ जब तुम्हर कोनो पीछा नइं करत होही, तभो ले तुमन भागहू। ");
INSERT INTO hne_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘ये जम्मो बात होय के बाद घलो, कहूं तुमन मोर नइं सुनहू, त मेंह तुम्हर पाप बर तुमन ला सात गुना दंड दूहूं। ");
INSERT INTO hne_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","मेंह तुम्हर जिद्द ले भरे घमंड ला टोर दूहूं अऊ तुम्हर ऊपर अकास ला लोहा सहीं अऊ तुम्हर खाल्हे के भुइयां ला कांसा सहीं कर दूहूं। ");
INSERT INTO hne_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तुम्हर मेहनत ह बेकार जाही, काबरकि न तो तुम्हर भुइयां म फसल होही अऊ न ही तुम्हर देस के रूखमन म फर लगही। ");
INSERT INTO hne_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘कहूं तुमन मोर बिरोध म चलतेच रहिहू अऊ मोर बात ला नइं सुनहू, त मेंह तुम्हर पापमन के मुताबिक तुम्हर दुख ला सात गुना बढ़ाहूं। ");
INSERT INTO hne_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","मेंह तुम्हर बीच म जंगली जानवर भेजहूं, अऊ ओमन तुम्हर लइकामन ला धरके ले जाहीं, तुम्हर पसुमन ला मार डारहीं अऊ तुम्हर गनती ला अतका कम कर दीहीं कि तुम्हर सड़कमन सुन्ना हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘एकर बाद घलो, यदि तुमन मोर ताड़ना ले नइं सुधरहू अऊ मोर बिरोध म चलते रहिहू, ");
INSERT INTO hne_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","त मेंह घलो तुम्हर बिरोध म हो जाहूं अऊ तुम्हर पाप के सेति तुम्हर ऊपर सात गुना दुख-तकलीफ लानहूं। ");
INSERT INTO hne_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","अऊ करार ला टोरे के बदला म, मेंह तुम्हर ऊपर तलवार चलवाहूं। जब तुमन अपन-अपन सहर म वापिस जाहू, त मेंह तुम्हर बीच म महामारी लानहूं, अऊ तुमन ला बईरी के हांथ म कर दिये जाही। ");
INSERT INTO hne_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","जब में तुम्हर रोटी आय के जरिया ला बंद कर देवंव, तब दस माईलोगनमन एक ठन चूल्हा म रोटी बनाहीं, अऊ ओमन तुमन ला तऊलके थोर-थोर रोटी दीहीं। तुमन खाहू, पर तुम्हर पेट नइं भरही। ");
INSERT INTO hne_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘ये जम्मो होय के बाद घलो, कहूं तुमन मोर नइं सुनहू अऊ मोर बिरोध म चलते रहिहू, ");
INSERT INTO hne_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","त गुस्सा होके मेंह तुम्हर बिरोध म होहूं, अऊ में खुद तुम्हर पाप बर तुमन ला सात गुना दंड दूहूं। ");
INSERT INTO hne_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तुमन अपन बेटा-बेटीमन के मांस खाहू। ");
INSERT INTO hne_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","मेंह तुम्हर ऊंच जगहमन ला गिरा दूहूं, तुम्हर धूप के बेदीमन ला नास कर दूहूं अऊ तुम्हर लासमन ला तुम्हर निरजीव मूरतीमन ऊपर कुढ़ो दूहूं, अऊ मेंह तुम्हर ले घिन करहूं। ");
INSERT INTO hne_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","मेंह तुम्हर सहरमन ला खंडहर बना दूहूं अऊ तुम्हर पबितर-स्थानमन ला उजार दूहूं अऊ तुम्हर बलिदान के सुख-देवइया सुगंध ले मोला कोनो खुसी नइं होही। ");
INSERT INTO hne_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","मेंह खुद तुम्हर देस ला उजार दूहूं, ताकि उहां बसे तुम्हर बईरीमन डरा जाहीं। ");
INSERT INTO hne_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","मेंह तुमन ला जाति-जाति के मनखेमन के बीच तितिर-बितिर कर दूहूं अऊ अपन तलवार खींचके निकालहूं अऊ तुम्हर पीछा करहूं। तुम्हर देस ह सुन्ना हो जाही अऊ तुम्हर सहरमन नास हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","तब, जब ये देस ह उजरे रहिही अऊ तुमन अपन बईरीमन के देस म रहिहू, तब ये देस ह अपन बिसराम बछरमन के आनंद मनाही; देस ह अराम करही अऊ अपन बिसराम बछर के आनंद उठाही। ");
INSERT INTO hne_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","जतेक समय तक येह बीरान रहिही, ओह येकर सुसताय के समय होही, काबरकि जब तुमन येमा रहत रहेव, त बिसराम बछर म येला सुसताय बर नइं मिलिस। ");
INSERT INTO hne_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘तुमन म के जऊन मन बांच गे हवंय, ओमन ला अपन बईरीमन के देस म अइसने डरपोक बना दूहूं कि हवा चले के कारन पान के खड़खड़ाय के अवाज सुनके ओमन भागहीं। ओमन अइसने भागहीं, मानो कोनो तलवार लेके ओमन के पीछा करत हे, अऊ ओमन गिर पड़हीं, हालाकि कोनो ओमन के पीछा नइं करत होही। ");
INSERT INTO hne_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ओमन एक-दूसर के ऊपर गिरहीं, मानो कोनो तलवार ले बांचे बर भागत हवय, हालाकि कोनो घलो ओमन के पीछा नइं करत होही। एकरसेति तुमन अपन बईरीमन के सामना नइं कर सकहू। ");
INSERT INTO hne_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तुमन आने जाति के मनखेमन के बीच म नास हो जाहू; तुम्हर बईरीमन के भुइयां ह तुमन ला खा जाही। ");
INSERT INTO hne_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","तुमन म जऊन मन बांचे हवंय, ओमन अपन पाप के कारन अपन बईरीमन के देस म नास हो जाहीं; ओमन अपन पुरखामन के पाप के कारन घलो नास हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘पर कहूं ओमन अपन अऊ अपन पुरखामन के पाप ला मान लीहीं—याने कि मोर बर ओमन के बिसवासघात अऊ ओमन के बईरता ला, ");
INSERT INTO hne_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","जेकर कारन मेंह ओमन के बिरोध म हो गेंव अऊ मेंह ओमन ला ओमन के बईरीमन के देस म भेज देंव—तब जब ओमन के कठोर हिरदय ह नरम हो जावय अऊ ओमन अपन पाप के दाम चुकावंय, ");
INSERT INTO hne_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","त मेंह याकूब के संग मोर करार अऊ इसहाक के संग मोर करार अऊ अब्राहम के संग मोर करार ला सुरता करहूं, अऊ मेंह ये देस ला घलो सुरता करहूं। ");
INSERT INTO hne_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","काबरकि ओमन के दुवारा ओ देस ह छोंड़ दिये गे होही अऊ ओमन के छोंड़ दिये गय समय म देस ह अपन बिसराम के आनंद उठाही। ओमन अपन पाप के दाम चुकाहीं, काबरकि ओमन मोर कानूनमन ला नइं मानिन अऊ मोर बिधिमन ले घिन करिन। ");
INSERT INTO hne_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","तभो ले, ये जम्मो होय के बाद, जब ओमन अपन बईरीमन के देस म होवंय, त मेंह ओमन ला नइं छोंड़ देवंव अऊ न ही ओमन ले अइसने घिन करंव कि ओमन के संग मोर करार ला टोरके ओमन ला पूरा नास कर देवंव। मेंह यहोवा, ओमन के परमेसर अंव। ");
INSERT INTO hne_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","पर ओमन के भलई बर, मेंह ओमन के पुरखामन के संग मोर करार ला सुरता करहूं, जेमन ला मेंह जाति-जाति के मनखेमन के देखत म मिसर देस ले बाहिर निकाल लानेंव, ताकि मेंह ओमन के परमेसर होवंव। मेंह यहोवा अंव।’ ” ");
INSERT INTO hne_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","येमन बिधि, कानून अऊ नियम अंय, जऊन ला यहोवा ह सीनय पहाड़ म अपन अऊ इसरायलीमन के बीच म मूसा के दुवारा ठहिराईस। ");
INSERT INTO hne_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इसरायलीमन ले गोठिया अऊ ओमन ला कह: ‘यदि कोनो मनखे ह कोनो मनखे ला यहोवा ला अरपन करे के बिसेस मन्नत मानथे अऊ यदि ये मन्नत ह ओ मनखे के बरोबर कीमत देय के दुवारा होवय, ");
INSERT INTO hne_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","त बीस ले साठ बछर के आदमी के कीमत पबितर-स्थान के सेकेल के मुताबिक चांदी के पचास सेकेल ठहिरावव; ");
INSERT INTO hne_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","अऊ माईलोगन के कीमत तीस सेकेल ठहिरावव; ");
INSERT INTO hne_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","पांच ले बीस बछर के मनखे के कीमत—यदि ओह बाबू-पीला अय, त ओकर कीमत बीस सेकेल अऊ यदि ओह नोनी-पीला अय, त ओकर कीमत दस सेकेल ठहिरावव; ");
INSERT INTO hne_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","एक महिना ले लेके पांच बछर तक के मनखे के कीमत—यदि ओह बाबू-पीला अय, त ओकर कीमत चांदी के पांच सेकेल अऊ यदि नोनी-पीला अय, त ओकर कीमत चांदी के तीन सेकेल ठहिरावव; ");
INSERT INTO hne_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","साठ बछर या ओकर ले जादा उमर के मनखे के कीमत—यदि आदमी अय, त ओकर कीमत पंदरह सेकेल अऊ माईलोगन अय, त ओकर कीमत दस सेकेल ठहिरावव। ");
INSERT INTO hne_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","कहूं कोनो मनखे ह अतका गरीब अय कि ओह ठहिराय गय कीमत ला नइं पटा सकय, त अरपन करे गय मनखे ला पुरोहित करा लाने जावय अऊ पुरोहित ह ओकर कीमत मन्नत मनइया के हैसियत के मुताबिक ठहिराही। ");
INSERT INTO hne_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘कहूं कोनो मनखे के मन्नत ह कोनो पसु अय, जऊन ला यहोवा बर बलिदान के रूप म दिये जा सकत हे, त यहोवा ला दिये गय अइसने पसु ह पबितर हो जाथे। ");
INSERT INTO hne_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ओ मनखे ह ओला फेर कोनो किसम ले झन बदलय; खराप के बदले बढ़िया ला या बढ़िया के बदले खराप ला झन देवय; कहूं ओह एक पसु के बदला म आने पसु देवय, त पहिली अऊ बदला म दिये गय पसु, दूनों पबितर हो जाथें। ");
INSERT INTO hne_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","कहूं ओह बिधि के मुताबिक कोनो असुध पसु के मन्नत माने हवय, जऊन ला यहोवा बर बलिदान के रूप म नइं दिये जा सकय, त ओ पसु ला पुरोहित करा लाने जावय, ");
INSERT INTO hne_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","अऊ पुरोहित ह ओ पसु ला जांचके बढ़िया या खराप ठहिराही। ओकर बाद, जऊन घलो कीमत पुरोहित ह ठहिरावय, ओकर ओतकेच कीमत होही। ");
INSERT INTO hne_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","कहूं ओकर मालिक ह ओ पसु ला छोंड़ाय चाहथे, त ओह पुरोहित के दुवारा ठहिराय गे कीमत म पांचवां भाग अऊ देके ओला छोंड़ा सकत हे। ");
INSERT INTO hne_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘कहूं कोनो मनखे अपन घर ला पबितर चीज के रूप म यहोवा ला अरपन करय, त पुरोहित ह ओ घर के जांच करके ओला बढ़िया या खराप बतावय। ओकर बाद, जऊन घलो कीमत पुरोहित ह ठहिरावय, ओकर ओतकेच कीमत होही। ");
INSERT INTO hne_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","कहूं अरपन करइया ह अपन घर ला छोंड़ाय चाहथे, त ओह ठहिराय गे कीमत म पांचवां भाग अऊ देवय, त ओ घर ह फेर ओकर हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘कहूं कोनो मनखे ह अपन परिवारिक भुइयां के कुछू भाग ला यहोवा बर अरपन करथे, त ओमा बोये बर जतका बीजा के जरूरत होथे, ओकर मुताबिक ओ भाग के कीमत तय करे जावय—एक होमेर जौ बीजा के चांदी के पचास सेकेल। ");
INSERT INTO hne_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","कहूं ओह जुबली बछर म अपन कोनो खेत अरपन करय, त ओकर ठहिराय गे कीमत ह ओहीच रहय। ");
INSERT INTO hne_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","पर कहूं ओह जुबली बछर के पाछू अपन कोनो खेत ला अरपन करथे, त अवइया जुबली बछर बर जतका बछर बांचे हवय, ओकर मुताबिक पुरोहित ह ओ खेत के कीमत ठहिरावय, अऊ येकर ठहिराय गे कीमत ह कम हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","कहूं खेत ला अरपन करइया ह ओ खेत ला छोंड़ाय बर चाहथे, त ओह ठहिराय गे कीमत म पांचवां भाग अऊ देवय, त ओ खेत ह फेर ओकरेच हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","पर कहूं ओह ओ खेत ला नइं छोंड़ावय, या यदि ओह ओला कोनो आने मनखे ला बेच देवय, त ओ खेत ह फेर कभू छोंड़ाय नइं जा सकय। ");
INSERT INTO hne_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","जब ओ खेत ह जुबली बछर म छूट जावय, त ओह यहोवा ला अरपित खेत सहीं पबितर हो जाही; अऊ ओह पुरोहित के संपत्ति हो जाही। ");
INSERT INTO hne_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘कहूं कोनो मनखे ह कोनो बिसाय खेत ला यहोवा ला अरपन करथे, जऊन ह कि ओकर पुरखा के खेत नो हय, ");
INSERT INTO hne_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","त अवइया जुबली बछर के मुताबिक पुरोहित ह ओकर कीमत ठहिरावय, अऊ मालिक ह ओहीच दिन यहोवा ला चघाय गे पबितर चीज के रूप म ओ कीमत ला दे देवय। ");
INSERT INTO hne_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","जुबली बछर म ओ खेत ला ओ मनखे ला लहुंटा दिये जावय, जेकर ले ओला बिसाय गे रिहिस, ओ मनखे ला जेकर ओ खेत रिहिस। ");
INSERT INTO hne_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","जब कोनो चीज के कीमत ठहिराय जाथे, ओ कीमत ह पबितर-स्थान के सेकेल मुताबिक ठहिराय जावय, सेकेल ह बीस गेराह के ठहिरय। ");
INSERT INTO hne_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘कोनो मनखे कोनो पसु के पहिलांत पीला ला अरपन झन करय, काबरकि पहिली जनमे के कारन ओ पीला ह पहिले ही यहोवा के हो जाथे; चाहे ओह कोनो बईला होवय या कोनो भेड़, येह यहोवा के अय। ");
INSERT INTO hne_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","यदि ओह कोनो असुध पसु अय, त ओकर ठहिराय गे कीमत म पांचवां भाग अऊ देके ओला फेर वापिस बिसाय जा सकथे। कहूं ओ पसु ह छोंड़ाय नइं जावय, त ओकर ठहिराय गे कीमत के मुताबिक ओला बेच दिये जावय। ");
INSERT INTO hne_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘पर जब कोनो मनखे अपन कोनो चीज ला यहोवा ला अरपित करथे—चाहे ओह मनखे होवय या पसु या पुरखा के खेत—ओह न तो बेचे जावय अऊ न ही छोंड़ाय जावय; अइसने अरपन करे गय हर एक चीज यहोवा बर महा पबितर अय। ");
INSERT INTO hne_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘जऊन मनखे ला नास करे बर अरपित करे गे हवय, ओला छोंड़ाय झन जावय; ओह मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘भुइयां के हर एक चीज के दसमांस, चाहे माटी ले उपजाय बीजा होवय या रूख के फर, ओह यहोवा के अय; ओह यहोवा बर पबितर अय। ");
INSERT INTO hne_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","जऊन कोनो अपन दसमांस म ले कुछू भाग ला छोंड़ाय चाहथे, त ओकर कीमत म पांचवां भाग जादा देके ओला छोंड़ा सकथे। ");
INSERT INTO hne_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","गाय-बईला या भेड़-बकरी के झुंड के दसमांस—हर एक झुंड के दसवां पसु, जऊन ह चरवाहा के गने जाय के बेरा ओकर लउठी के तरी ले निकलथे, ओह यहोवा बर पबितर ठहिरही। ");
INSERT INTO hne_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","कोनो घलो मनखे बढ़िया या खराप होय के चिंता झन करय अऊ न ही ओमा कोनो अदला-बदली करय। कहूं कोनो मनखे अदला-बदली करथे, त ओ पसु अऊ ओकर बदले म दिये गय पसु, दूनों पबितर हो जाथें अऊ ओमन ला छोंड़ाय नइं जा सकय।’ ” ");
INSERT INTO hne_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","येमन ओ हुकूम अंय, जऊन ला यहोवा ह सीनय पहाड़ म मूसा ला इसरायलीमन बर दीस।");
INSERT INTO hne_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","इसरायलीमन के मिसर देस ले निकल जाय के दूसर बछर के दूसर महिना के पहिली दिन, यहोवा ह सीनय के निरजन जगह म, मिलापवाला तम्बू म मूसा ला कहिस: ");
INSERT INTO hne_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“इसरायलीमन के जम्मो समाज ओमन के गोत्र अऊ परिवार के मुताबिक, हर एक पुरूस के गनती नांव लिख-लिखके कर। ");
INSERT INTO hne_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","जतेक इसरायली बीस साल या ओकर ले जादा उमर के हवंय अऊ ओमन सेना म सेवा देय के लईक हवंय, ओ जम्मो के गनती तें अऊ हारून ओमन के दल के मुताबिक करव। ");
INSERT INTO hne_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","हर एक गोत्र के एक-एक पुरूस, जऊन मन अपन परिवार के मुखिया अंय, ओमन तुम्हर मदद करंय। ");
INSERT INTO hne_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“ये ओ पुरूसमन के नांव अय, जऊन मन तुम्हर मदद करहीं: “रूबेन के गोत्र ले सदेऊर के बेटा एलीसूर; ");
INSERT INTO hne_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","सिमोन के गोत्र ले सूरीसद्दाय के बेटा सलूमीएल; ");
INSERT INTO hne_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदा के गोत्र ले अमीनादाब के बेटा नहसोन; ");
INSERT INTO hne_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्साकार के गोत्र ले सूआर के बेटा नतनेल; ");
INSERT INTO hne_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जबूलून के गोत्र ले हेलोन के बेटा एलीआब; ");
INSERT INTO hne_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","यूसुफ के बेटामन ले: एपरैम के गोत्र ले अमीहूद के बेटा एलीसामा; मनस्से के गोत्र ले पदासूर के बेटा गमलीएल; ");
INSERT INTO hne_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बिनयामीन के गोत्र ले गिदोनी के बेटा अबीदान; ");
INSERT INTO hne_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान के गोत्र ले अम्मीसद्दाय के बेटा अहीएजेर; ");
INSERT INTO hne_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आसेर के गोत्र ले ओकरान के बेटा पगीएल; ");
INSERT INTO hne_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गाद के गोत्र ले दूएल के बेटा एलियासाप; ");
INSERT INTO hne_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नपताली के गोत्र ले एनान के बेटा अहीरा।” ");
INSERT INTO hne_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","येमन समाज के ओ मनखे रिहिन, जेमन ला अपन पुरखा के गोत्रमन ले अगुवा ठहिराय गीस। येमन इसरायल के गोत्रमन के मुखिया रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","जऊन मनखेमन के नांव ऊपर लिखे गे हवय, ओमन ला मूसा अऊ हारून अपन संग लीन, ");
INSERT INTO hne_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","अऊ ओमन ओ साल के दूसरा महिना के पहिला दिन पूरा समाज ला इकट्ठा करिन। मनखेमन अपन गोत्र अऊ परिवार के मुताबिक अपन बंसावली लिखवाईन, अऊ जतेक झन बीस साल या बीस साल ले जादा उमर के रिहिन, ओमन के नांव एक-एक करके लिखे गीस, ");
INSERT INTO hne_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ये किसम ले ओह सीनय के सुनसान जगह म ओमन के गनती करिस: ");
INSERT INTO hne_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","इसरायल के बेटा रूबेन के बंस ले: जतेक पुरूस बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा दे सकत रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक एक-एक करके लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","रूबेन के गोत्र के गनती 46,500 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","सिमोन के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के गनती करे गीस अऊ ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक एक-एक करके लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","सिमोन के गोत्र के गनती 59,300 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गाद के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","गाद के गोत्र के गनती 45,650 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदा के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","यहूदा के गोत्र के गनती 74,600 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्साकार के बंस ले: ओ जम्मो मनखे, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इस्साकार के गोत्र के गनती 54,400 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","जबूलून के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","जबूलून के गोत्र के गनती 57,400 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","यूसुफ के बेटामन ले: एपरैम के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","एपरैम के गोत्र के गनती 40,500 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","मनस्से के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मनस्से के गोत्र के गनती 32,200 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बिनयामीन के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","बिनयामीन के गोत्र के गनती 35,400 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दान के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","दान के गोत्र के गनती 62,700 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आसेर के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","आसेर के गोत्र के गनती 41,500 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नपताली के बंस ले: ओ जम्मो पुरूस, जऊन मन बीस साल या बीस साल ले जादा उमर के रिहिन अऊ सेना म सेवा देय के लईक रिहिन, ओमन के नांव ओमन के गोत्र अऊ परिवार के मुताबिक लिखे गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","नपताली के गोत्र के गनती 53,400 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मूसा अऊ हारून अऊ इसरायल के बारह अगुवा, जेमन अपन-अपन परिवार के मुखिया घलो रिहिन, येमन के गनती करिन। ");
INSERT INTO hne_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","जम्मो इसरायली, जऊन मन बीस साल ले जादा उमर के रिहिन अऊ इसरायली सेना म सेवा देय के लईक रिहिन, ओमन के गनती परिवार के मुताबिक होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","कुल गनती 6,03,550 होईस। ");
INSERT INTO hne_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","पर लेवीमन के पुरखा के गोत्र ला आने मन के संग नइं गने गीस। ");
INSERT INTO hne_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","यहोवा ह मूसा ला कहे रिहिस: ");
INSERT INTO hne_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“लेवी गोत्र ला झन गनबे या ओमन ला आने इसरायलीमन संग गनती म सामिल झन करबे। ");
INSERT INTO hne_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","पर लेवीमन ला करार के कानून के पबितर-तम्बू म अधिकारी ठहिराबे—ओकर जम्मो सजावट अऊ ओमा के जम्मो चीज ऊपर अधिकारी ठहिराबे। ओमन पबितर-तम्बू अऊ ओमा के जम्मो चीज ला उठावंय; ओमन ओकर देखभाल करंय अऊ ओकर चारों कोति डेरा डाले रहंय। ");
INSERT INTO hne_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","जब भी पबितर-तम्बू ला आने जगह ले जाय के समय होवय, त लेवीमन ओला उसालंय, अऊ जब भी पबितर-तम्बू ला गाड़े के समय होवय, त लेवीमन ही ओला गाड़ंय। यदि कोनो आने मनखे येकर लकठा म आवय, त ओह मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","इसरायलीमन दल के मुताबिक अपन तम्बूमन ला गाड़ंय, हर एक जन अपन झंडा के अधीन अपन सिविर म तम्बू गाड़ंय। ");
INSERT INTO hne_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","पर लेवीमन करार के कानून के पबितर-तम्बू के चारों कोति अपन तम्बू गाड़ंय ताकि मोर कोप ह इसरायली समाज ऊपर झन भड़कय। लेवीमन करार के कानून के पबितर-तम्बू के देखभाल बर जिम्मेदार अंय।” ");
INSERT INTO hne_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","इसरायलीमन जम्मो चीज वइसने ही करिन, जइसने यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","यहोवा ह मूसा अऊ हारून ला कहिस: ");
INSERT INTO hne_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“इसरायलीमन मिलापवाला तम्बू के थोरकन दूरिहा म ओकर चारों कोति डेरा डालंय, हर एक जन अपन दल के अधीन अऊ अपन परिवार के झंडा धरे डेरा डालंय।” ");
INSERT INTO hne_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","पूरब तरफ, सूरज निकले कोति: यहूदा के सिविर के दलमन अपन झंडा के अधीन डेरा डालंय। यहूदा के मनखेमन के अगुवा अमीनादाब के बेटा नहसोन होवय। ");
INSERT INTO hne_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ओकर दल के गनती 74,600 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ओमन के बाद इस्साकार गोत्र के परधान सूआर के बेटा नतनेल ह डेरा डालही। ");
INSERT INTO hne_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ओकर दल के गनती 54,400 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ओकर बाद जबूलून के गोत्र डेरा डालही। जबूलून के मनखेमन के अगुवा हेलोन के बेटा एलीआब होही। ");
INSERT INTO hne_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ओकर दल के गनती 57,400 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","यहूदा के सिविर बर जतेक आदमी सऊंपे गे रिहिन, ओमन के गनती ओमन के दल के मुताबिक 1,86,400 रिहिस। येमन पहिले निकलहीं। ");
INSERT INTO hne_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","दक्खिन कोति: रूबेन के सिविर के दलमन अपन झंडा के अधीन डेरा डालंय। रूबेन के मनखेमन के अगुवा सदेऊर के बेटा एलीसूर होही। ");
INSERT INTO hne_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ओकर दल के गनती 46,500 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ओमन के बाद सिमोन के गोत्र ह डेरा डालही। सिमोन के मनखेमन के अगुवा सूरीसद्दाय के बेटा सलूमीएल होही। ");
INSERT INTO hne_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ओकर दल के गनती 59,300 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ओकर बाद गाद के गोत्र डेरा डालही। गाद के मनखेमन के अगुवा दूएल के बेटा एलियासाप होही। ");
INSERT INTO hne_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ओकर दल के गनती 45,650 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","रूबेन के सिविर के जतेक आदमी रिहिन, ओमन के गनती दल के मुताबिक 1,51,450 रिहिस। दूसर बार म येमन बाहिर निकलहीं। ");
INSERT INTO hne_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","तब मिलापवाला तम्बू अऊ लेवीमन के सिविर ह ले जाय के बेरा सिविरमन के बीच म रहय। ओमन ला ओहीच किसम ले लेय जावंय, जऊन किसम ले ओमन गाड़े जावंय, हर एक अपन झंडा के अधीन अपन-अपन जगह म रहिके चलंय। ");
INSERT INTO hne_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","पछिम कोति: एपरैम के सिविर के दलमन अपन झंडा के अधीन डेरा डालंय। एपरैम के मनखेमन के अगुवा अमीहूद के बेटा एलीसामा होही। ");
INSERT INTO hne_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ओकर दल के गनती 40,500 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ओकर बाद मनस्से के गोत्र डेरा डालही। मनस्से के मनखेमन के अगुवा पदासूर के बेटा गमलीएल होही। ");
INSERT INTO hne_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ओकर दल के गनती 32,200 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ओकर बाद बिनयामीन के गोत्र डेरा डालही। बिनयामीन के मनखेमन के अगुवा गिदोनी के बेटा अबीदान होही। ");
INSERT INTO hne_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ओकर दल के गनती 35,400 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","एपरैम के सिविर म जतेक आदमी रिहिन, ओमन अपन दल के मुताबिक 1,08,100 रिहिन। येमन तीसरा नम्बर म निकलहीं। ");
INSERT INTO hne_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","उत्तर कोति: दान के सिविर के दलमन अपन झंडा के अधीन डेरा डालंय। दान के मनखेमन के अगुवा अम्मीसद्दाय के बेटा अहीएजेर होही। ");
INSERT INTO hne_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ओकर दल के गनती 62,700 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ओमन के बाद आसेर के गोत्र डेरा डालही। आसेर के मनखेमन के अगुवा ओकरान के बेटा पगीएल होही। ");
INSERT INTO hne_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ओकर दल के गनती 41,500 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ओकर बाद नपताली के गोत्र डेरा डालही। नपताली के मनखेमन के अगुवा एनान के बेटा अहीरा होही। ");
INSERT INTO hne_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ओकर दल के गनती 53,400 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","दान के सिविर के जतेक आदमी रिहिन, ओमन के गनती 1,57,600 रिहिस। आखिरी म येमन अपन झंडा के अधीन निकलहीं। ");
INSERT INTO hne_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","येमन ओ इसरायली रिहिन, जेमन ला ओमन के परिवार के मुताबिक गने गीस। सिविरमन म जम्मो पुरूस के गनती ओमन के दल के मुताबिक 6,03,550 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","पर लेवीमन ला आने इसरायलीमन संग नइं गने गीस, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","इसरायलीमन ओ हर काम करिन, जेकर हुकूम यहोवा ह मूसा ला दे रिहिस; ओ हुकूम के मुताबिक ओमन अपन-अपन झंडा के अधीन डेरा डालंय अऊ हुकूम के मुताबिक ही ओमा के हर एक जन अपन-अपन गोत्र अऊ परिवार के संग निकलंय। ");
INSERT INTO hne_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","जब यहोवा ह सीनय पहाड़ ऊपर मूसा ले गोठियाईस, ओ समय हारून अऊ मूसा के परिवार के लेखा-जोखा अइसने रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","हारून के बेटामन के नांव: पहिलऊठा नादाब ओकर बाद अबीहू, एलिआजर अऊ ईतामार। ");
INSERT INTO hne_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","हारून के बेटामन के ये नांव अय, जेमन अभिसिक्त पुरोहित रिहिन अऊ जेमन ला पुरोहिती सेवा बर अभिसेक करे गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","पर नादाब अऊ अबीहू यहोवा के आघू म मर गीन, जब ओमन ओकर आघू म सीनय के सुन्ना जगह म बरजे गय आगी के संग बलिदान चघाईन। ओमन के कोनो बेटा नइं रिहिस, एकरसेति एलिआजर अऊ ईतामार अपन ददा हारून के समय म पुरोहित के रूप म सेवा करिन। ");
INSERT INTO hne_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवी गोत्र के मनखेमन ला बलाके हारून पुरोहित करा लान कि ओमन ओकर मदद करंय। ");
INSERT INTO hne_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ओमन पबितर-तम्बू के काम करे के दुवारा मिलापवाला तम्बू म हारून बर अऊ पूरा समाज बर जिम्मेदारी पूरा करंय। ");
INSERT INTO hne_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ओमन मिलापवाला तम्बू के जम्मो सामान के देखरेख करंय अऊ पबितर-तम्बू के काम करे के दुवारा इसरायलीमन के काम ला पूरा करंय। ");
INSERT INTO hne_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","लेवीमन ला लानके हारून अऊ ओकर बेटामन के हांथ म सऊंप दे; येमन ओ इसरायली अंय, जेमन ओला पूरा दे दिये जावंय। ");
INSERT INTO hne_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","हारून अऊ ओकर बेटामन ला पुरोहित के पद म सेवा करे बर ठहिरा; यदि आने मनखे पबितर-स्थान म जावय, त ओह मार डारे जावय।” ");
INSERT INTO hne_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","यहोवा ह मूसा ला ये घलो कहिस, ");
INSERT INTO hne_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“हर एक इसरायली माईलोगन के पहिलांत बेटा के बदला म मेंह इसरायलीमन के बीच ले लेवीमन ला लेय ले हंव। लेवीमन मोर अंय, ");
INSERT INTO hne_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","काबरकि जम्मो पहिलांतमन मोर अंय। जब मेंह मिसर देस म जम्मो पहिलांतमन ला मार डारेंव, त मेंह इसरायल म हर एक पहिलांत ला अपन बर पबितर कर ले रहेंव, चाहे ओह मनखे होवय या पसु। ओमन मोर होहीं। मेंह यहोवा अंव।” ");
INSERT INTO hne_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","यहोवा ह सीनय के सुनसान जगह म मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“लेवीमन ला परिवार अऊ गोत्र के मुताबिक गनती कर। एक महिना अऊ जादा उमर के, पुरूसमन ला गन।” ");
INSERT INTO hne_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","एकरसेति मूसा ह ओमन ला वइसने गनिस, जइसने यहोवा ह ओला हुकूम देय रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लेवी के बेटामन के नांव ये अंय: गेरसोन, कहात अऊ मरारी। ");
INSERT INTO hne_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","गेरसोन बंस के नांवमन ये रिहिन: लिबनी अऊ सिमी। ");
INSERT INTO hne_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कहात बंस के येमन रिहिन: अमराम, ईसहार, हेबरोन अऊ उजीएल। ");
INSERT INTO hne_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मरारी बंस के येमन रिहिन: महली अऊ मूसी। ");
INSERT INTO hne_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","गेरसोन के बंस म लिबनी अऊ सिमीमन रिहिन; येमन गेरसोनी बंस रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","एक महिना या जादा उमर के जम्मो पुरूसमन के गनती 7,500 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेरसोनीमन के बंस ला पछिम कोति, पबितर-तम्बू के पाछू म डेरा डालना रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","गेरसोनीमन के परिवारमन के अगुवा लाएल के बेटा एलियासाप रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","मिलापवाला तम्बू म गेरसोन बंस के ऊपर पबितर-तम्बू अऊ तम्बू, ओकर ढपना, मिलापवाला तम्बू के प्रवेस दुवार के परदा, ");
INSERT INTO hne_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","अंगना के परदा, पबितर-तम्बू अऊ बेदी के चारों कोति अंगना के प्रवेस दुवार के परदा, अऊ रस्सी—अऊ ओमन के उपयोग ले संबंधित हर एक चीज के जिम्मेदारी रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","कहात ले अमरामी, ईसहारी, हेबरोनी अऊ उजीएलीमन के बंस चलिस; येमन कहातीमन के बंस रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ओ जम्मो पुरूस, जऊन मन एक महिना या जादा उमर के रिहिन, ओमन के गनती 8,600 रिहिस। कहातीमन पबितर-स्थान के देखरेख करंय। ");
INSERT INTO hne_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कहात के बंस ला पबितर-तम्बू के दक्खिन कोति डेरा डालना रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","कहाती बंस के परिवारमन के अगुवा उजीएल के बेटा एलीसापान रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ओमन के ऊपर सन्दूक, मेज, दीवट, बेदी, सेवा म उपयोग अवइया पबितर-स्थान के बरतन, परदा, अऊ ओमन के उपयोग ले संबंधित हर एक चीज के जिम्मेदारी रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","लेवीमन के परधान अगुवा एलिआजर ह हारून पुरोहित के बेटा रिहिस। ओला ओमन के ऊपर ठहिराय गे रिहिस, जऊन मन के ऊपर पबितर-स्थान के देखरेख के जिम्मेदारी रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","मरारी ले महली अऊ मूसी गोत्र के बंस चलिस; येमन मरारी के बंस रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","एक महिना या जादा उमर के पुरूसमन गने गीन, ओमन 6,200 रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","मरारी बंस के परिवारमन के अगुवा अबीहैल के बेटा सूरीएल रिहिस। ओमन ला पबितर-तम्बू के उत्तर कोति डेरा डालना रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","मरारी बंस के ऊपर पबितर-तम्बू के ढांचा, येकर बल्ली, खंभा, आधार, येकर जम्मो सामान, ओमन के उपयोग ले संबंधित हर एक चीज के जिम्मेदारी रिहिस; ");
INSERT INTO hne_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","अंगना के संग ओमन के आधार के चारों कोति के खंभा, तम्बू के खूंटी अऊ डोरीमन के जिम्मेदारी घलो रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","मूसा अऊ हारून अऊ ओकर बेटामन ला पबितर-तम्बू के पूरब दिसा म, सूरज निकले कोति, मिलापवाला तम्बू के आघू म डेरा डालना रिहिस। ओमन के ऊपर इसरायलीमन कोति ले पबितर-स्थान के देखरेख के जिम्मेदारी रिहिस। यदि कोनो आने मनखे पबितर-स्थान करा जावय, त ओह मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","मूसा अऊ हारून यहोवा के हुकूम ले लेवीमन के ओमन के बंस के मुताबिक गनती करिन, अऊ एक महिना या ओकर ले जादा उमर के पुरूसमन के संखिया 22,000 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ओकर बाद यहोवा ह मूसा ला कहिस, “इसरायलीमन के पहिलांत पुरूसमन ला गन, जऊन मन एक महिना या जादा उमर के हवंय ओमन के नांव के एक सूची बना। ");
INSERT INTO hne_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","मोर बर इसरायलीमन के जम्मो पहिलांत के बदले लेवीमन ला, अऊ इसरायलीमन के पसुमन के जम्मो पहिलांत के बदले लेवीमन के पसुमन ला लेय ले। मेंह यहोवा अंव।” ");
INSERT INTO hne_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","एकरसेति मूसा ह इसरायलीमन के जम्मो पहिलांतमन के गनती, यहोवा के हुकूम के मुताबिक करिस। ");
INSERT INTO hne_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","जऊन पहिलांत पुरूसमन, एक महिना या ओकर ले जादा उमर के रिहिन, ओमन के लिखे गय नांव के मुताबिक ओमन गनती म 22,273 रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","यहोवा ह मूसा ला ये घलो कहिस, ");
INSERT INTO hne_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“इसरायल के जम्मो पहिलांत के बदले लेवीमन, अऊ ओमन के पसुमन के बदले लेवीमन के पसुमन ला लेय ले। लेवीमन मोर अंय। मेंह यहोवा अंव। ");
INSERT INTO hne_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","इसरायलीमन के ओ 273 पहिलांत, जेमन गनती म लेवीमन ले जादा हवंय, ओमन के छुड़ौती बर, ");
INSERT INTO hne_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","तें ओ हर एक पुरूस बर पांच सेकेल जमा कर, येह पबितर-स्थान के सेकेल के मुताबिक होवय, जेकर वजन बीस गेरा होथे। ");
INSERT INTO hne_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ये रकम ला उपरहा इसरायलीमन के छुड़ौती बर हारून अऊ ओकर बेटामन ला दे देबे।” ");
INSERT INTO hne_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","एकरसेति मूसा ह ओ मनखेमन ले छोंड़ाय के दाम जमा करिस, जेमन लेवीमन के दुवारा छोंड़ाय गे मनखेमन ले जादा रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","इसरायलीमन के पहिलांतमन ले ओह पबितर-स्थान के सेकेल के मुताबिक दाम जमा करिस, जेकर वजन 1,365 सेकेल होईस। ");
INSERT INTO hne_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","मूसा ह हारून अऊ ओकर बेटामन ला छुड़ौती के दाम दीस, जइसे कि ओला यहोवा ह हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","यहोवा ह मूसा अऊ हारून ला कहिस: ");
INSERT INTO hne_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“लेवीमन के बीच म ले कहातीमन के ओमन के बंस अऊ परिवार के मुताबिक गनती कर। ");
INSERT INTO hne_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","तीस साल ले लेके पचास साल के उमर के ओ जम्मो आदमीमन के गनती कर, जेमन मिलापवाला तम्बू के काम म सेवा करे बर आथें। ");
INSERT INTO hne_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“मिलापवाला तम्बू म कहातीमन के काम ये होही: महा पबितर चीजमन के देखरेख। ");
INSERT INTO hne_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","जब डेरा ह आघू बढ़थे तब हारून अऊ ओकर बेटामन भीतर जाके आड़ करइया परदा ला उतार लेवंय अऊ ओला करार कानून के सन्दूक ऊपर ढांप देवंय। ");
INSERT INTO hne_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","तब ओमन परदा ला एक टिकाऊ खाल ले ढांप देवंय, अऊ ओकर ऊपर पूरा नीला रंग के कपड़ा ओढ़ा देवंय अऊ डंडामन ला ओमन के जगह म लगावंय। ");
INSERT INTO hne_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“उपस्थिति के मेज के ऊपर ओमन एक नीला कपड़ा ला फईला देवंय अऊ येकर ऊपर थाली, बरतन अऊ कटोरा, अऊ पेय-बलिदान के सुराहीमन ला रखंय; ओ रोटी, जऊन ह उहां हमेसा रहिथे, ओह उहां रखे रहय। ");
INSERT INTO hne_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ओमन एक सिन्दूरी रंग के कपड़ा येमन के ऊपर फईलाके, टिकाऊ खाल ले ढांप देवंय अऊ डंडामन ला ओमन के जगह म लगावंय। ");
INSERT INTO hne_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“फेर ओमन एक नीला कपड़ा लेके अंजोर करे बर रखे दीवट, ओकर दीया, ओकर बाती ला काटे के कतरनी अऊ बड़े थाली, अऊ जैतून तेल डारे म उपयोग अवइया ओकर जम्मो सुराहीमन ला ढांप देवंय। ");
INSERT INTO hne_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","तब ओमन येला अऊ ओकर जम्मो सामान ला एक टिकाऊ खाल के ढकना म लपेट देवंय अऊ येला ले जवइया ढांचा म डार देवंय। ");
INSERT INTO hne_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“सोन के बेदी ऊपर ओमन एक नीला कपड़ा फईला देवंय अऊ ओला टिकाऊ खाल ले ढांप देवंय अऊ डंडामन ला ओकर जगह म लगा देवंय। ");
INSERT INTO hne_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“ओमन पबितर-स्थान म सेवा बर उपयोग होवइया जम्मो सामान ला लेवंय अऊ ओमन ला एक नीला कपड़ा म लपेटंय, अऊ ओकर ऊपर टिकाऊ खाल ला ढांप देवंय अऊ ओमन ला ले जवइया ढांचा म रख देवंय। ");
INSERT INTO hne_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“ओमन कांसा के बेदी ले राख ला हटाके ओकर ऊपर एक बैंगनी कपड़ा फईला देवंय। ");
INSERT INTO hne_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","तब ओमन ओमा बेदी करा सेवा म उपयोग होवइया जम्मो बरतन ला रख देवंय, जेमा करछूल, मांस म उपयोग होवइया कांटा, बेलचा अऊ छिंचे के कटोरामन घलो रहंय। येला ओमन एक टिकाऊ खाल ले ढांप देवंय अऊ डंडामन ला ओकर जगह म लगा देवंय। ");
INSERT INTO hne_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“जब हारून अऊ ओकर बेटामन पबितर-स्थान अऊ ओकर जम्मो पबितर सामान अऊ पबितर बरतनमन ला ढांप लीहीं, अऊ जब सिविर ह चले बर तियार हो जाही, तब ही कहातीमन आवंय अऊ ओला उठाके ले जावंय। पर जरूरी अय कि ओमन पबितर चीजमन ला झन छुवंय, नइं तो ओमन मर जाहीं। मिलापवाला तम्बू म जऊन सामान रहिथे, कहातीमन ओमन ला उठाके ले जावंय। ");
INSERT INTO hne_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“हारून पुरोहित के बेटा एलिआजर के देखरेख म ये चीजमन रहंय: दीया जलाय के तेल, खुसबूवाला धूप, नियमित अन्न-बलिदान अऊ अभिसेक के तेल। ओकर ऊपर पूरा पबितर-तम्बू अऊ ओमा के हर एक चीज के जिम्मेदारी रहय, ओमा के पबितर सामान अऊ बरतनमन के घलो जिम्मेदारी।” ");
INSERT INTO hne_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","फेर यहोवा ह मूसा अऊ हारून ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“धियान रहय कि कहाती बंस ह लेवीमन के बीच ले नास झन होवय, ");
INSERT INTO hne_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ताकि जब ओमन सबले पबितर चीजमन के लकठा म आवंय, त ओमन जीयत रहंय अऊ झन मरंय, ओमन बर ये करव: हारून अऊ ओकर बेटामन पबितर-स्थान म जावंय अऊ हर एक झन ला ओकर काम के जिम्मेदारी सऊंपंय अऊ बतावंय कि कोन ह का उठाके ले जाही। ");
INSERT INTO hne_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","पर कहातीमन पबितर चीजमन ला देखे बर बिलकुल ही भीतर झन जावंय, थोरकन देर बर घलो नइं, नइं तो ओमन मर जाहीं।” ");
INSERT INTO hne_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“गेरसोनीमन के घलो ओमन के परिवार अऊ बंस के मुताबिक गनती कर। ");
INSERT INTO hne_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","तीस ले लेके पचास साल के ओ जम्मो पुरूसमन के गनती कर, जऊन मन मिलापवाला तम्बू म सेवा करे बर आथें। ");
INSERT INTO hne_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“सामान ले जवई अऊ ओमन के आने काम म गेरसोनी बंस के मनखेमन के ये सेवा होही: ");
INSERT INTO hne_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ओमन पबितर-तम्बू के परदा ला उठाके ले जावंय, येमा मिलापवाला तम्बू, कपड़ा के तोपनी अऊ टिकाऊ खाल के येकर बाहिरी तोपनी, मिलापवाला तम्बू के प्रवेस दुवार म लगे परदामन, ");
INSERT INTO hne_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","पबितर-तम्बू अऊ बेदी के चारों कोति के अंगना के परदामन, अंगना के प्रवेस दुवार म लगे परदा, तम्बू के सेवा म उपयोग होवइया रस्सी अऊ जम्मो सामानमन होहीं। गेरसोनीमन ये चीजमन ले संबंधित जम्मो काम ला करहीं। ");
INSERT INTO hne_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","गेरसोनीमन के जम्मो काम, चाहे ओह सामान उठाके ले जवई या आने काम; ये सब हारून अऊ ओकर बेटामन के निरदेसन म करे जावय। ओमन जऊन काम करहीं, येला एक जिम्मेदारी के रूप म तेंह ओमन ला सऊंपबे। ");
INSERT INTO hne_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","येह मिलापवाला तम्बू म गेरसोनी बंस के सेवा अय। ओमन अपन काम हारून पुरोहित के बेटा ईतामार के निरदेसन म करंय। ");
INSERT INTO hne_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“मरारीमन ला ओमन के बंस अऊ परिवार के मुताबिक गन। ");
INSERT INTO hne_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","तीस ले लेके पचास साल के ओ जम्मो आदमीमन के गनती कर, जऊन मन मिलापवाला तम्बू म सेवा करे बर आथें। ");
INSERT INTO hne_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","तम्बू म अपन जम्मो सेवा के भाग के रूप म, ओमन पबितर-तम्बू के ढांचा, येकर डंडा, खंभा अऊ आधारमन ला उठाके ले जावंय, ");
INSERT INTO hne_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","संगे-संग ओमन अंगना के चारों कोति के खंभामन ला ओमन के आधार सहित, तम्बू के खूंटी, रस्सी, ओमन के जम्मो सामान अऊ ओमन के उपयोग के हर एक चीज ला ले जावंय। हर एक आदमी ला बता कि ओह का चीज ला ले जाही। ");
INSERT INTO hne_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","हारून पुरोहित के बेटा ईतामार के निरदेसन म मिलापवाला तम्बू म मरारी गोत्र के ये सेवा होही।” ");
INSERT INTO hne_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","तब मूसा, हारून अऊ समाज के अगुवामन कहातीमन ला ओमन के बंस अऊ परिवारमन के मुताबिक गनती करिन। ");
INSERT INTO hne_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","तीस ले लेके पचास साल के ओ जम्मो पुरूस, जऊन मन मिलापवाला तम्बू म सेवा करे बर आईन, ");
INSERT INTO hne_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","बंस के मुताबिक 2,750 रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","येह कहाती बंस म ओ जम्मो झन के संखिया रिहिस, जऊन मन मिलापवाला तम्बू म सेवा करिन। यहोवा के दुवारा मूसा ला दिये गय हुकूम के मुताबिक मूसा अऊ हारून ओमन के गनती करिन। ");
INSERT INTO hne_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","गेरसोनीमन ओमन के कुल अऊ परिवारमन के मुताबिक गने गीन। ");
INSERT INTO hne_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","तीस ले लेके पचास साल के ओ जम्मो पुरूस, जऊन मन मिलापवाला तम्बू म सेवा करे बर आईन, ");
INSERT INTO hne_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ओमन के कुल अऊ परिवारमन के मुताबिक ओमन के संखिया 2,630 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","येह गेरसोनी कुल म ओ जम्मो झन के संखिया रिहिस, जऊन मन मिलापवाला तम्बू म सेवा करिन। यहोवा के हुकूम के मुताबिक मूसा अऊ हारून ओमन के गनती करिन। ");
INSERT INTO hne_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","मरारीमन ला ओमन के कुल अऊ परिवार के मुताबिक गने गीस। ");
INSERT INTO hne_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","तीस ले लेके पचास साल के ओ जम्मो पुरूस, जऊन मन मिलापवाला तम्बू म सेवा करे बर आईन, ");
INSERT INTO hne_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ओमन के कुल के मुताबिक ओमन के संखिया 3,200 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","येह मरारी बंस के कुल संखिया रिहिस। यहोवा के दुवारा मूसा ला दिये गय हुकूम के मुताबिक मूसा अऊ हारून ओमन के गनती करिन। ");
INSERT INTO hne_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","मूसा, हारून अऊ इसरायल के अगुवामन जम्मो लेवीमन के ओमन के बंस अऊ परिवार के मुताबिक गनती करिन। ");
INSERT INTO hne_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","तीस ले लेके पचास साल के ओ जम्मो पुरूस, जऊन मन सेवा के काम करे बर अऊ मिलापवाला तम्बू ला उठाके ले जाय बर आईन, ");
INSERT INTO hne_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ओमन के संखिया 8,580 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","मूसा ला दिये गय यहोवा के हुकूम के मुताबिक हर एक जन ला ओकर काम सऊंपे गीस, अऊ बताय गीस कि कोन ह का चीज ला उठाके ले जाही। ये किसम ले यहोवा के दुवारा मूसा ला दिये गय हुकूम के मुताबिक ओमन के गनती होईस। ");
INSERT INTO hne_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“इसरायलीमन ला हुकूम दे कि यदि कोनो ला असुध चाम के बेमारी या देहें ले कोनो चीज निकले, या लास ला छुए से असुध हो गे हवय, ओला सिविर ले बाहिर निकाल दिये जावय। ");
INSERT INTO hne_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","चाहे पुरूस हो या माईलोगन, ओला निकाल दव; ओमन ला सिविर के बाहिर निकाल दव ताकि ओमन सिविर ला असुध झन करंय, जिहां मेंह ओमन के बीच म रहिथंव।” ");
INSERT INTO hne_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","इसरायलीमन अइसने ही करिन; ओमन मनखेमन ला सिविर के बाहिर कर दीन। ओमन वइसने ही करिन, जइसने यहोवा ह मूसा ला निरदेस दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“इसरायलीमन ला कह: ‘जब कोनो पुरूस या माईलोगन कोनो मनखे के संग गलत बरताव करथे अऊ ये किसम ले यहोवा के संग बिसवासघात करके दोसी ठहिरथे, ");
INSERT INTO hne_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","त ओह अपन करे गे पाप ला जरूर मान लेवय। ओह अपन करे गे दोस के पूरा भरपई करय; नुकसान करे गे चीज के दाम म ओकर पांचवां भाग जोड़के ओह ओ मनखे ला दे देवय, जेकर ओह नुकसान करे हवय। ");
INSERT INTO hne_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","पर कहूं ओ मनखे के कोनो नजदीकी रिस्तेदार नइं ए, जेला गलत काम के भरपई करे जा सकय, त फेर भरपई ह यहोवा के हो जाही अऊ येला पुरोहित ला ओ मेढ़ा के संग दे दिये जावय, जेकर संग बिसवासघात करइया मनखे ह पछताप करथे। ");
INSERT INTO hne_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ओ जम्मो पबितर चीज के बांटा, जेला इसरायलीमन पुरोहित करा लानथें, ओ सब पुरोहित के होही। ");
INSERT INTO hne_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","पबितर चीजमन ओमन के मालिक के अंय, पर जऊन चीज ओमन पुरोहित ला देथें, ओह पुरोहित के हो जाही।’ ” ");
INSERT INTO hne_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“इसरायलीमन ले बात कर अऊ ओमन ला कह: ‘कहूं कोनो मनखे के घरवाली बदचलन होके ओकर संग बिसवासघात करथे ");
INSERT INTO hne_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","याने कि कोनो आने मनखे ह ओकर घरवाली संग सुतथे, अऊ ये बात ओकर घरवाला ला मालूम नइं ए अऊ ओकर असुध होय के पता नइं चले हे (काबरकि ओकर बिरूध कोनो सबूत नइं ए अऊ ओह ओ काम म पकड़े नइं गे हवय), ");
INSERT INTO hne_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","अऊ कहूं ओकर घरवाला के मन म जलन होथे अऊ ओह अपन घरवाली ऊपर संका करथे कि ओह असुध हवय—या फेर ओकर घरवाली के असुध नइं होवत घलो, कहूं ओ मनखे ह ओकर ऊपर जलन अऊ संका करथे— ");
INSERT INTO hne_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","तब ओह अपन घरवाली ला पुरोहित करा ले जावय। ओह अपन घरवाली कोति ले एक एपा के दसवां भाग जौ के पीसान घलो चढ़ावा के रूप म ले जावय। ओह ओकर ऊपर जैतून के तेल झन डालय या ओकर ऊपर धूप झन रखय, काबरकि येह जलन बर एक अन्न-बलिदान अय, पाप कोति धियान देय बर एक सुरता-बलिदान ए। ");
INSERT INTO hne_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘पुरोहित ह ओ माईलोगन ला लानय अऊ यहोवा के आघू म ओला ठाढ़ करय। ");
INSERT INTO hne_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","तब पुरोहित ह माटी के सुराही म थोरकन पबितर पानी लेवय अऊ पबितर-तम्बू के फर्स ले कुछू धुर्रा लेके ओ पानी म डाल देवय। ");
INSERT INTO hne_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","पुरोहित ह ओ माईलोगन ला यहोवा के आघू म ठाढ़ करे के बाद, ओकर बाल ला खोल देवय अऊ ओकर हांथ म जलन के सुरता-बलिदान, अन्न-बलिदान ला रखय, जबकि पुरोहित ह खुद ओ करू पानी ला धरय, जऊन ह सराप लानथे। ");
INSERT INTO hne_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","तब पुरोहित ह ओ माईलोगन ला कसम खवाके कहय, “अपन घरवाला के संग बिहाव के जिनगी जीयत, यदि कोनो आने पुरूस ह तोला असुध नइं करे हवय अऊ तेंह निरदोस हस, त ये सराप लानेवाला करू पानी ले तोला कोनो हानि नइं होवय। ");
INSERT INTO hne_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","पर यदि अपन घरवाला के संग बिहाव के जिनगी जीयत, तेंह बदचलनी करे हस अऊ अपन घरवाला के छोंड़ आने पुरूस के संग सुतके अपनआप ला असुध करे हस”— ");
INSERT INTO hne_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","इहां पुरोहित ह ओ माईलोगन ला ये सराप के अधीन रखय—“त यहोवा ह मनखेमन के बीच म तोला सरापित करय, ओह तोर गरभपात करवा देवय अऊ तोर पेट ह फूल जावय। ");
INSERT INTO hne_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ये सराप लानेवाला करू पानी ह तोर देहें भीतर जावय, ताकि तोर पेट ह फूल जावय या तोर गरभ गिर जावय।” “ ‘तब ओ माईलोगन ह कहय, “आमीन। अइसने ही होवय।” ");
INSERT INTO hne_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘पुरोहित ह ये सराप ला एक ठन चामपट्टी म लिख लेवय अऊ तब ओला ओ करू पानी म धो लेवय। ");
INSERT INTO hne_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ओकर बाद ओ सराप लानेवाला करू पानी ला ओह ओ माईलोगन ला पीये बर देवय, तब ये सराप लानेवाला पानी ओकर भीतर जाही, जेकर ले करू पीरा होथे। ");
INSERT INTO hne_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","तब पुरोहित ह जलन के अन्न-बलिदान ला ओ माईलोगन के हांथ ले लेय लेवय, अऊ येला यहोवा के आघू म हलावय अऊ येला बेदी करा लानय। ");
INSERT INTO hne_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","तब पुरोहित ह यादगार-बलिदान के रूप म ओ अन्न-बलिदान म ले एक मुठा ले लेवय अऊ येला बेदी ऊपर जला देवय; ओकर बाद, ओह ओ माईलोगन ला पानी पीयावय। ");
INSERT INTO hne_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","यदि ओह अपनआप ला असुध करे होही अऊ अपन घरवाला के संग बिसवासघात करे होही, त फेर ओकर ये हाल होही: जब ओला ओ सराप देवइया अऊ बहुंत पीरा देवइया पानी पीयाय जाही, त येह ओकर देहें भीतर जाके ओकर पेट ला फूला दीही अऊ ओकर गरभ गिर जाही, अऊ ओह अपन मनखेमन के बीच सरापित हो जाही। ");
INSERT INTO hne_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","पर यदि ओ माईलोगन ह अपनआप ला असुध नइं करे होही, पर साफ होही, त ओह निरदोस ठहिरही अऊ ओकर गरभ धरे म समस्या नइं होही। ");
INSERT INTO hne_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘जलन के संबंध म इही ह सही नियम ए, जब कोनो माईलोगन ह अपन घरवाला के संग बिहाव के जिनगी जीयत बदचलनी करथे अऊ अपनआप ला असुध करथे, ");
INSERT INTO hne_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","या जब कोनो मनखे ऊपर अपन घरवाली बर संका के भावना आथे, त येह जलन के कानून अय। पुरोहित ह ओ माईलोगन ला यहोवा के आघू म ठाढ़ करय अऊ ओकर ऊपर ये जम्मो बिधि पूरा करय। ");
INSERT INTO hne_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ओ घरवाला ह गलत काम बर निरदोस ठहिरही, पर ओ माईलोगन ला ओकर पाप के दंड मिलही।’ ” ");
INSERT INTO hne_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“इसरायलीमन ले गोठिया अऊ ओमन ला कह: ‘यदि कोनो माईलोगन या पुरूस कोनो बिसेस मन्नत माने के दुवारा अपनआप ला एक नाजीर के रूप म यहोवा ला सऊंप देथे, ");
INSERT INTO hne_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","त जरूरी अय कि ओह अंगूर के मंद अऊ कोनो आने किसम के मंद अऊ अंगूर के मंद ले बने सिरका या आने किसम के मंद ले अलग रहय। जरूरी अय कि ओह अंगूर के रस झन पीयय या अंगूर या किसमिस झन खावय। ");
INSERT INTO hne_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","जब तक नाजीर ह मन्नत बर अलग रहिथे, तब तक जरूरी अय कि ओह अंगूर के नार के कोनो चीज ला झन खावय, इहां तक कि अंगूर के छिलका या बीजा ला घलो झन खावय। ");
INSERT INTO hne_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘नाजीर के मन्नत माने के पूरा समय ओह अपन मुड़ म उस्तरा झन चलवाय। ओह तब तक अलग रहय। जब तक कि यहोवा ला दिये समय ह खतम नइं हो जावय, तब तक ओह पबितर बने रहय; ओह अपन चुंदी ला लम्बा बाढ़न देवय। ");
INSERT INTO hne_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘यहोवा ला अपन दिये गय समय के बीच म नाजीर ह कोनो लास के लकठा म झन जावय। ");
INSERT INTO hne_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","अऊ त अऊ यदि ओकर खुद के दाई या ददा या भाई या बहिनी घलो मर जावय, तभो ले ओह अपनआप ला ओमन के कारन संस्कार म असुध झन करय, काबरकि अपनआप ला यहोवा ले मन्नत बर सऊंपे के चिनहां ह ओकर मुड़ म हवय। ");
INSERT INTO hne_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","अपन मन्नत बर ओ पूरा समय म, ओह यहोवा बर पबितर ठहिरथे। ");
INSERT INTO hne_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘यदि नाजीर के उहां रहत कोनो मनखे ह अचानक मर जावय, त फेर ओकर बाल ह असुध हो जाथे, जऊन ह कि ओकर मन्नत बर चिनहां अय, ये स्थिति म सातवां दिन याने कि सुध होय के दिन, ओह अपन मुड़ मुड़ा ले। ");
INSERT INTO hne_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","तब आठवां दिन, ओह मिलापवाला तम्बू के मुंहटा म पुरोहित करा दू ठन पंड़की या दू ठन परेवा पीला लानय। ");
INSERT INTO hne_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","पुरोहित ह नाजीर बर पछताप करे के खातिर एक ठन ला पाप-बलिदान अऊ आने ला होम-बलिदान के रूप म चघावय, काबरकि ओह लास करा रहे के दुवारा पाप करे हवय। ओहीच दिन ओह अपन मुड़ ला फेर पबितर करय। ");
INSERT INTO hne_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ओह फेर अपनआप ला मन्नत बर यहोवा ला सऊंपे अऊ ओह दोस-बलिदान के रूप म एक साल के मेढ़ा-पीला लानय। पहिले के दिनमन ला झन गने जावय, काबरकि ओह अपन मन्नत के दौरान असुध हो गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘जब नाजीर के मन्नत बर ठहिराय समय ह पूरा हो जाथे, त येह ओकर कानून अय। ओला मिलापवाला तम्बू के मुंहटा करा लाने जावय। ");
INSERT INTO hne_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","उहां ओह यहोवा बर अपन बलिदान चघावय: होम-बलिदान बर एक साल के निरदोस मेढ़ा-पीला, पाप-बलिदान बर एक साल के निरदोस भेड़ी-पीला, अऊ मेल-बलिदान बर एक ठन निरदोस मेढ़ा, ");
INSERT INTO hne_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","संग म अपन अन्न-बलिदान अऊ पेय-बलिदान, अऊ एक टुकना अखमीरी रोटी, जऊन ह बढ़िया किसम के पीसान ले बने होवय—मोटहा रोटीमन म जैतून तेल मिले होवय, अऊ पातर रोटीमन के ऊपर जैतून तेल चुपरे होवय। ");
INSERT INTO hne_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘पुरोहित ह ये जम्मो चीज ला यहोवा के आघू म लानय अऊ पाप-बलिदान अऊ होम-बलिदान चघावय। ");
INSERT INTO hne_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","पुरोहित ह अखमीरी रोटी के टोकरी ला लानय अऊ मेढ़ा ला मेल-बलिदान के रूप म यहोवा ला चढ़ावा चघावय, संग म अन्न-बलिदान अऊ पेय-बलिदान ला घलो चघावय। ");
INSERT INTO hne_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘तब मिलापवाला तम्बू के मुंहटा म, नाजीर ह अपन ओ बाल ला मुड़ावय, जऊन ह कि ओकर मन्नत बर चिनहां अय। तब ओह ओ बाल ला ले जाके ओ आगी म डार देवय, जऊन ह मेल-बलिदान के चढ़ावा के खाल्हे म होथे। ");
INSERT INTO hne_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘जब नाजीर ह बाल ला मुड़वा लेवय, जऊन ह ओकर मन्नत बर चिनहां अय, तब पुरोहित ह ओकर हांथ म मेढ़ा के एक ठन उबले कंधा, अऊ टुकना के एक ठन मोटहा अखमीरी रोटी अऊ एक ठन पातर अखमीरी रोटी रख देवय। ");
INSERT INTO hne_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","तब पुरोहित ह येमन ला हलाय-बलिदान के रूप म यहोवा के आघू म हलावय; येमन पबितर अंय अऊ पुरोहित के अंय, संग म ओ छाती, जेला हलाय गीस अऊ ओ जांघ जेला चघाय गीस, ओमन घलो पुरोहित के अंय। ओकर बाद, नाजीर ह अंगूर के मंद पी सकथे। ");
INSERT INTO hne_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘येह नाजीर के कानून ए, जऊन ह अपन मन्नत के मुताबिक यहोवा ला मन्नत के चढ़ावा चघाथे, येकर अलावा अऊ जऊन कुछू ओह दे सकथे, ओह देवय। येह जरूरी अय कि ओह अपन माने गय मन्नत ला नाजीर के कानून के मुताबिक पूरा करय।’ ” ");
INSERT INTO hne_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“हारून अऊ ओकर बेटामन ला कह, ‘ये किसम ले तुमन इसरायलीमन ला आसीस देवव। ओमन ला कहव: ");
INSERT INTO hne_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “यहोवा तुमन ला आसीस देवय अऊ तुम्हर रकछा करय; ");
INSERT INTO hne_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","यहोवा ह अपन चेहरा के अंजोर तुम्हर ऊपर चमकाय अऊ अनुग्रह करय; ");
INSERT INTO hne_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","यहोवा ह अपन चेहरा तुम्हर कोति करय अऊ तुमन ला सांति देवय।” ’ ");
INSERT INTO hne_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“ये किसम ले ओमन मोर नांव ला इसरायलीमन म रखंय अऊ मेंह ओमन ला आसीस दूहूं।” ");
INSERT INTO hne_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","जब मूसा ह पबितर-तम्बू ला खड़े कर लीस, त ओह ओला ओकर जम्मो सामान सहित अभिसेक करिस अऊ ओला पबितर करिस। ओह बेदी अऊ ओकर जम्मो बरतनमन ला घलो अभिसेक करिस अऊ पबितर करिस, ");
INSERT INTO hne_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","तब इसरायल के अगुवामन, परिवारमन के ओ मुखियामन बलिदान चघाईन, जऊन मन ओमन के गोत्र के मुखिया रिहिन, जेमन ला गने गीस। ");
INSERT INTO hne_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ओमन यहोवा के आघू म अपन चढ़ावा के रूप म छै ठन ढंपे बईला गाड़ी अऊ बारह ठन बईला लानिन—एक बईला एक अगुवा ले अऊ एक गाड़ी हर दू झन अगुवा ले। येमन ला ओमन पबितर-तम्बू के आघू म भेंट कर दीन। ");
INSERT INTO hne_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ये चीजमन ला ओमन ले लेय ले, ताकि येमन के उपयोग मिलापवाला तम्बू के काम म करे जा सकय। लेवीमन ला ओमन के काम के मुताबिक येमन ला देय दे।” ");
INSERT INTO hne_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","तब मूसा ह गाड़ी अऊ बईलामन ला लेके लेवीमन ला दे दीस। ");
INSERT INTO hne_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ओह गेरसोन के परिवार ला ओमन के काम के मुताबिक दू ठन गाड़ी अऊ चार ठन बईला दीस, ");
INSERT INTO hne_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","अऊ मरारीमन ला ओमन के काम के मुताबिक चार ठन गाड़ी अऊ आठ ठन बईला दीस। ओमन जम्मो हारून पुरोहित के बेटा ईतामार के अधीन काम करंय। ");
INSERT INTO hne_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","पर मूसा ह कहातीमन ला कुछू नइं दीस, काबरकि ओमन पबितर चीजमन ला अपन कंधा म उठाके ले जावंय, अऊ येह ओमन के जिम्मेदारी रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","जब बेदी के अभिसेक करे गीस, तब अगुवामन येकर समरपन बर अपन चढ़ावा ला लानके बेदी के आघू म रखिन। ");
INSERT INTO hne_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","काबरकि यहोवा ह मूसा ला कहे रिहिस, “बेदी के समरपन बर हर दिन एक अगुवा अपन चढ़ावा ला लानय।” ");
INSERT INTO hne_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","जऊन ह पहिले दिन चढ़ावा लानिस, ओह यहूदा के गोत्र के अमीनादाब के बेटा नहसोन रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल वजन के एक ठन चांदी के थाली अऊ सत्तर सेकेल वजन के छिंचनेवाला एक ठन चांदी के कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","धूप ले भरे दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","अऊ मेल-बलिदान के रूप म चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","दूसर दिन इस्साकार गोत्र के अगुवा सूआर के बेटा नतनेल अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के एक ठन चांदी के थाली अऊ सत्तर सेकेल के एक ठन छिंचनेवाला चांदी के कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","धूप ले भरे दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","अऊ मेल-बलिदान के रूप म चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","तीसर दिन, जबूलून के मनखेमन के अगुवा हेलोन के बेटा एलीआब अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के एक ठन चांदी के थाली अऊ सत्तर सेकेल के एक ठन छिंचनेवाला चांदी के कटोरा, अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","धूप ले भरे दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","अऊ मेल-बलिदान के रूप म चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","चौथा दिन, रूबेन के मनखेमन के अगुवा सदेऊर के बेटा एलीसूर अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के एक ठन चांदी के थाली अऊ सत्तर सेकेल के छिंचनेवाला एक ठन चांदी के कटोरा, अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","धूप ले भरे दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","अऊ मेल-बलिदान चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","पांचवां दिन सिमोन के मनखेमन के अगुवा सूरीसद्दाय के बेटा सलूमीएल अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के एक ठन चांदी के थाली अऊ सत्तर सेकेल के छिंचनेवाला एक ठन चांदी के कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","धूप ले भरे, दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","अऊ मेल-बलिदान चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","छठवां दिन गाद के मनखेमन के अगुवा दूएल के बेटा एलियासाप अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के एक ठन चांदी के थाली अऊ सत्तर सेकेल के छिंचनेवाला एक ठन चांदी के कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","धूप ले भरे, दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","अऊ मेल-बलिदान चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","सातवां दिन एपरैम के मनखेमन के अगुवा अमीहूद के बेटा एलीसामा अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के एक ठन चांदी के थाली अऊ सत्तर सेकेल के छिंचनेवाला एक ठन चांदी के कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","धूप ले भरे, दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","अऊ मेल-बलिदान चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","आठवां दिन मनस्से के मनखेमन के अगुवा पदासूर के बेटा गमलीएल ह अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के एक ठन चांदी के थाली अऊ सत्तर सेकेल के छिंचनेवाला एक ठन चांदी के कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","धूप ले भरे दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","अऊ मेल-बलिदान चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","नौवां दिन बिनयामीन के मनखेमन के अगुवा गिदोनी के बेटा अबीदान ह अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के एक ठन चांदी के थाली अऊ सत्तर सेकेल के एक ठन छिंचनेवाला चांदी के कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","धूप ले भरे दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","अऊ मेल-बलिदान चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","दसवां दिन दान के मनखेमन के अगुवा अम्मीसद्दाय के बेटा अहीएजेर ह अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के एक ठन चांदी के थाली अऊ सत्तर सेकेल के छिंचनेवाला एक ठन चांदी के कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","धूप ले भरे, दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","अऊ मेल-बलिदान चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","गियारहवां दिन आसेर के मनखेमन के अगुवा ओकरान के बेटा पगीएल अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के चांदी के एक ठन थाली अऊ सत्तर सेकेल के छिंचनेवाला एक ठन चांदी के कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","धूप ले भरे, दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","अऊ मेल-बलिदान चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","बारहवां दिन नपताली के मनखेमन के अगुवा एनान के बेटा अहीरा अपन चढ़ावा लानिस। ");
INSERT INTO hne_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ओकर चढ़ावा ये रिहिस: पबितर-स्थान के सेकेल के मुताबिक एक सौ तीस सेकेल के चांदी के एक ठन थाली अऊ सत्तर सेकेल के छिंचनेवाला चांदी के एक ठन कटोरा; अन्न-बलिदान के रूप म ये दूनों चीज जैतून तेल ले सने उत्तम पीसान ले भरे रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","धूप ले भरे, दस सेकेल के एक ठन सोन के धूपदान; ");
INSERT INTO hne_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","होम-बलिदान बर एक ठन बछवा, एक ठन मेढ़ा अऊ एक साल के एक ठन मेढ़ा-पीला; ");
INSERT INTO hne_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","पाप-बलिदान बर एक ठन बोकरा; ");
INSERT INTO hne_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","अऊ मेल-बलिदान चघाय बर दू ठन बईला, पांच ठन मेढ़ा, पांच ठन बोकरा अऊ एक-एक साल के पांच ठन मेढ़ा-पीला। ");
INSERT INTO hne_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","जब बेदी के अभिसेक करे गीस, त ओकर समरपन बर इसरायली अगुवामन के ये चढ़ावा रिहिन: चांदी के बारह थाली, छिंचे बर चांदी के बारह कटोरा अऊ सोन के बारह धूपदान। ");
INSERT INTO hne_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","हर चांदी के थाली के वजन एक सौ तीस सेकेल, अऊ हर छिंचनेवाला कटोरा के वजन सत्तर सेकेल रिहिस। पबितर-स्थान के सेकेल के मुताबिक, जम्मो चांदी के बरतन के वजन दू हजार चार सौ सेकेल रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","पबितर-स्थान के सेकेल के मुताबिक, धूप ले भरे बारह सोन के धूपदान म ले हर एक के वजन दस सेकेल रिहिस। जम्मो धूपदान के वजन एक सौ बीस सेकेल रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","होम-बलिदान बर पसुमन के कुल संखिया ओमन के अन्न-बलिदान के संग बारह ठन बछवा, बारह ठन मेढ़ा अऊ एक-एक साल के बारह ठन मेढ़ा-पीला रिहिस। पाप-बलिदान बर बारह ठन बोकरा के उपयोग करे गीस। ");
INSERT INTO hne_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","मेल-बलिदान चघाय बर पसुमन के कुल संखिया चौबीस ठन बईला, साठ ठन मेढ़ा, साठ ठन बोकरा अऊ एक-एक साल के साठ ठन मेढ़ा-पीला रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","जब मूसा ह यहोवा ले गोठियाय बर मिलापवाला तम्बू के भीतर गीस, त करार कानून के सन्दूक ला ढंके पछताप ढकना के ऊपर दूनों करूबमन के बीच ले ओला गोठियाय के अवाज सुनाई दीस। ये किसम ले यहोवा ह मूसा ले गोठियाईस। ");
INSERT INTO hne_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“हारून ले बात कर अऊ ओला कह, ‘जब भी तेंह दीयामन ला मढ़ाथस, त धियान रख कि जम्मो सातों दीया दीवट के सामने कोति अंजोर देवंय।’ ” ");
INSERT INTO hne_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","हारून ह वइसने करिस; ओह दीयामन ला मढ़ाईस कि ओमन दीवट के सामने अंजोर देवंय, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ये दीवट ला ये किसम ले बनाय गे रिहिस: येकर आधार ले लेके येकर फूल तक येह हथौड़ी ले पीटे गय सोन के बने रिहिस। दीवट ह बिलकुल ओहीच नमूना म बने रिहिस, जइसे कि यहोवा ह मूसा ला देखाय रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","फेर यहोवा ह मूसा ला कहिस: ");
INSERT INTO hne_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“जम्मो इसरायलीमन के बीच ले लेवीमन ला अलग कर अऊ ओमन ला बिधि के मुताबिक सुध कर। ");
INSERT INTO hne_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ओमन ला सुध करे बर तेंह अइसने कर: सुध करइया पानी के छिड़काव ओमन ऊपर कर; तब ओमन अपन पूरा देहें म उस्तरा चलवांय अऊ अपन कपड़ा ला धोवंय। अऊ अइसने ओमन अपनआप ला सुध करंय। ");
INSERT INTO hne_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","तब ओमन जैतून तेल ले सने उत्तम पीसान के अन्न-बलिदान के संग एक ठन बछवा लेवंय, अऊ पाप-बलिदान बर तें एक ठन दूसर बछवा ले। ");
INSERT INTO hne_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ओकर बाद लेवीमन ला मिलापवाला तम्बू के आघू म लान अऊ जम्मो इसरायली समाज ला इकट्ठा कर। ");
INSERT INTO hne_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","तेंह लेवीमन ला यहोवा के आघू म लानबे, अऊ इसरायलीमन ओमन ऊपर अपन हांथ रखंय। ");
INSERT INTO hne_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","तब हारून ह इसरायलीमन कोति ले लेवीमन ला यहोवा के आघू म एक हलाय-बलिदान के रूप म लानय, ताकि ओमन यहोवा के काम करे बर तियार होवंय। ");
INSERT INTO hne_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“तब लेवीमन अपन हांथ बछवामन के मुड़ ऊपर रखंय; येमा के एक ठन बछवा के उपयोग यहोवा ला पाप-बलिदान बर अऊ दूसर बछवा के उपयोग लेवीमन के पछताप करे बर होम-बलिदान के रूप म करे जावय। ");
INSERT INTO hne_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ओकर बाद लेवीमन ला हारून अऊ ओकर बेटामन के आघू म ठाढ़ कर अऊ तब ओमन ला एक हलाय-बलिदान के रूप म यहोवा ला अरपन कर। ");
INSERT INTO hne_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ये किसम ले तेंह लेवीमन ला आने इसरायलीमन ले अलग करबे, अऊ लेवीमन मोर होहीं। ");
INSERT INTO hne_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“जब तेंह लेवीमन ला सुध करके ओमन ला एक हलाय-बलिदान के रूप म अरपन कर लेबे, तब ओमन मिलापवाला तम्बू म अपन काम करे बर आवंय। ");
INSERT INTO hne_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","येमन ओ इसरायली अंय, जेमन ला पूरा मोला दिये जावय। मेंह ओमन ला अपन जानके के पहिलांतमन के जगह म याने कि हर एक इसरायली माईलोगनमन के पहिला जनमे लड़का के रूप म लेय ले हंव। ");
INSERT INTO hne_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इसरायल म हर पहिला जनमे नर, चाहे ओह मनखे होवय या पसु, ओह मोर अय। मेंह ओमन ला अपन बर पबितर करे हंव, जब मेंह मिसर देस म जम्मो पहिलांतमन ला मार डारेंव। ");
INSERT INTO hne_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","अऊ मेंह इसरायल म जम्मो पहिलांत बेटामन के जगह म लेवीमन ला लेय ले हंव। ");
INSERT INTO hne_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","जम्मो इसरायलीमन के बीच ले, मेंह लेवीमन ला एक भेंट के रूप म हारून अऊ ओकर बेटामन ला देय दे हंव कि ओमन इसरायलीमन कोति ले मिलापवाला तम्बू म काम करंय अऊ ओमन बर प्रायस्चित करंय, ताकि जब इसरायलीमन पबितर-स्थान के लकठा म जावंय त ओमन ऊपर कोनो महामारी झन आवय।” ");
INSERT INTO hne_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","मूसा, हारून अऊ पूरा इसरायली समाज ह लेवीमन के संग वइसे ही करिन, जइसे यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लेवीमन अपनआप ला सुध करिन अऊ अपन ओनहा ला धोईन। तब हारून ह ओमन ला यहोवा के आघू म हलाय-बलिदान के रूप म अरपन करिस अऊ ओमन ला सुध करे बर ओमन बर प्रायस्चित करिस। ");
INSERT INTO hne_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ओकर बाद, लेवीमन हारून अऊ ओकर बेटामन के देखरेख म मिलापवाला तम्बू म अपन काम करे बर आईन। ओमन लेवीमन के संग वइसने ही करिन, जइसे यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ये नियम लेवीमन ऊपर लागू होथे: पच्चीस साल या ओकर ले जादा उमर के मनखेमन मिलापवाला तम्बू म काम करे बर आवंय, ");
INSERT INTO hne_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","पर पचास साल के उमर म, ओमन अपन नियमित सेवा ले हट जावंय अऊ फेर काम झन करंय। ");
INSERT INTO hne_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","येकर बाद ओमन मिलापवाला तम्बू म अपन भाईमन के काम म मदद कर सकत हें, पर ओमन खुद होके कोनो काम झन करंय। ये किसम ले तेंह लेवीमन ला ओमन के जिम्मेदारी सऊंपबे।” ");
INSERT INTO hne_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","इसरायलीमन के मिसर देस ले निकल आय के दूसरा साल के पहिला महिना म यहोवा ह सीनय के सुन्ना जगह म मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“इसरायलीमन ठहिराय गे समय म फसह के तिहार मनावंय। ");
INSERT INTO hne_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ठहिराय गे समय म, इही महिना के चौदहवां दिन सूरज बुड़े के पाछू, तुमन येला येकर जम्मो नियम अऊ बिधि के मुताबिक मनावव।” ");
INSERT INTO hne_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","तब मूसा ह इसरायलीमन ला फसह के तिहार मनाय बर कहिस, ");
INSERT INTO hne_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","अऊ ओमन सीनय के सुन्ना जगह म, पहिला महिना के चौदहवां दिन, सूरज बुड़े के पाछू फसह ला मनाईन। इसरायलीमन हर चीज वइसने ही करिन, जइसने कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","पर ओमा के कुछू झन ओ दिन फसह नइं मना सकिन, काबरकि एक लास के कारन ओमन बिधि के मुताबिक असुध रिहिन। एकरसेति ओहीच दिन ओमन मूसा अऊ हारून करा आईन ");
INSERT INTO hne_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","अऊ मूसा ला कहिन, “हमन एक लास के कारन असुध हो गे हन, पर ठहिराय गे समय म, यहोवा ला चढ़ावा चघाय बर, आने इसरायलीमन ले हमन ला काबर अलग करे जावथे?” ");
INSERT INTO hne_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मूसा ह ओमन ला जबाब दीस, “मेंह पता लगात हंव कि तुम्हर बारे म यहोवा के का हुकूम अय, तब तक तुमन ठहिरे रहव।” ");
INSERT INTO hne_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इसरायलीमन ला बता: ‘जब तुमन म ले कोनो या तुम्हर संतान म के कोनो मनखे कोनो लास के कारन असुध हवय या कोनो काम ले बाहिर गे हवय, तब भी ओह यहोवा के फसह ला मना सकत हे, ");
INSERT INTO hne_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","पर ओह दूसरा महिना के चौदहवां दिन बेर बुड़े के बाद येला मनावय। ओह मेढ़ा के मांस ला अखमीरी रोटी अऊ करू साग के संग खावय। ");
INSERT INTO hne_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ओह बिहनियां होवत तक कुछू ला झन छोंड़य या येकर कोनो हाड़ा ला झन टोरय। जब ओह फसह तिहार ला मनावय, त ओह जम्मो बिधि के पालन करय। ");
INSERT INTO hne_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","पर यदि बिधि के मुताबिक सुध हवय अऊ यातरा म नइं ए, पर फसह के तिहार ला नइं मनाथे, त ओला अपन मनखेमन ले अलग करे जाय, काबरकि ओह ठहिराय गे समय म यहोवा ला चढ़ावा के अरपन नइं करिस। ओह अपन पाप के दुख भोगही। ");
INSERT INTO hne_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘यदि कोनो परदेसी तुम्हर बीच म रहत हवय, त ओह घलो नियम अऊ बिधि के मुताबिक यहोवा के फसह ला मनावय। देस म जनमे मनखे अऊ परदेसी दूनों बर फसह माने के तुम्हर ओहीच बिधि होवय।’ ” ");
INSERT INTO hne_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","जऊन दिन पबितर-तम्बू, करार कानून के तम्बू ला खड़े करे गीस, ओ दिन बादर ह येला ढांप लीस। सांझ ले लेके बिहनियां तक बादर ह पबितर-तम्बू ऊपर आगी सहीं दिखिस। ");
INSERT INTO hne_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","अऊ हर दिन अइसने ही होईस; बादर ह येला ढांपय, अऊ रथिया के बेरा येह आगी सहीं दिखय। ");
INSERT INTO hne_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","जब भी बादर ह तम्बू के ऊपर ले उठय, त इसरायलीमन आघू बढ़ंय, अऊ जिहां भी बादर ह ठहर जावय, उहां इसरायलीमन डेरा डालंय। ");
INSERT INTO hne_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","यहोवा के हुकूम ले इसरायलीमन आघू बढ़िन, अऊ ओकर हुकूम ले ही ओमन डेरा डालिन। जब तक बादर ह पबितर-तम्बू के ऊपर रहय, ओमन डेरा डाले रहंय। ");
INSERT INTO hne_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","जब बादर ह पबितर-तम्बू के ऊपर बहुंत दिन तक बने रहय, त इसरायलीमन यहोवा के हुकूम ला मानंय अऊ आघू नइं बढ़ंय। ");
INSERT INTO hne_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","कभू-कभू बादर ह पबितर-तम्बू ऊपर सिरिप कुछू दिन बर रहय; यहोवा के हुकूम ले ओमन डेरा डालंय, अऊ तब ओकर हुकूम ले ही ओमन आघू बढ़ंय। ");
INSERT INTO hne_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","कभू-कभू बादर ह सिरिप सांझ ले बिहनियां तक रहय, अऊ जब येह बिहनियां उठय, त ओमन आघू बढ़ जावंय। चाहे दिन हो या रथिया, जब भी बादर ह उठ जावय, ओमन आघू बढ़ जावंय। ");
INSERT INTO hne_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","जब भी बादर ह पबितर-तम्बू ऊपर दू दिन या एक महिना या एक साल बर ठहिरय, त इसरायलीमन डेरा म रहंय अऊ आघू नइं बढ़ंय; पर जब येह उठ जावय, त ओमन आघू बढ़ंय। ");
INSERT INTO hne_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","यहोवा के हुकूम ले ओमन डेरा डालंय, अऊ यहोवा के हुकूम ले ही ओमन आघू बढ़ंय। ओमन यहोवा के हुकूम मानंय, जेला ओह मूसा के जरिये ओमन ला देवय। ");
INSERT INTO hne_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","फेर यहोवा ह मूसा ला कहिस: ");
INSERT INTO hne_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“चांदी ला पीटके दू ठन तुरही बना, अऊ ओमन के उपयोग समाज ला एक संग जूरे बर अऊ सिविर के आघू बढ़े बर कर। ");
INSERT INTO hne_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","जब दूनों तुरही बजाय जावंय, त पूरा समाज मिलापवाला तम्बू के दुवार म तोर आघू म जूर जावय। ");
INSERT INTO hne_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","अऊ यदि सिरिप एक ठन ला बजाय जावय, त अगुवामन—इसरायल के गोत्र के मुखियामन तोर आघू म जूर जावंय। ");
INSERT INTO hne_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","जब तुरही ला एक बार जोर से फूंके जावय, त पूरब दिसा म डेरा डाले गोत्र के मन आघू बढ़ंय। ");
INSERT INTO hne_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","तुरही ला दूसर बार जोर से फूंके जावय, त दक्खिन कोति डेरा डाले मनखेमन आघू बढ़ंय। तुरही ला जोर से फूंकई ह आघू बढ़े के संकेत होही। ");
INSERT INTO hne_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","समाज ला इकट्ठा करे बर तुरहीमन ला फूंके जावय, पर येमा आघू बढ़े के संकेत झन होवय। ");
INSERT INTO hne_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“हारून के बेटा, पुरोहितमन तुरही ला फूंकंय। येह हमेसा के बिधि होवय अऊ अवइया पीढ़ीमन म घलो येकर पालन करे जावय। ");
INSERT INTO hne_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","जब तुमन अपन ही देस म कोनो बईरी के बिरूध लड़े बर निकलव, जऊन ह तुम्हर ऊपर अतियाचार करत हे, त तुरहीमन ला एक बार जोर से बजावव। तब यहोवा तुम्हर परमेसर ह तुमन ला सुरता करही अऊ तुम्हर बईरीमन ले बचाही। ");
INSERT INTO hne_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","अपन आनंद मनाय के बेरा—तुम्हर ठहिराय गय तिहार अऊ नवां चंदा के जेवनार के बेरा, तुमन होम-बलिदान अऊ मेल-बलिदान चढ़ावा के समय तुरहीमन ला फूंकव, अऊ ओह तुम्हर बर परमेसर के आघू म एक सुरता करइया होही। मेंह यहोवा तुम्हर परमेसर अंव।” ");
INSERT INTO hne_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","इसरायलीमन के मिसर देस ले निकले के दूसरा साल के दूसरा महिना के बीसवां दिन बादर ह करार के कानून के पबितर-तम्बू के ऊपर ले उठ गीस। ");
INSERT INTO hne_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","तब इसरायलीमन सीनय के सुन्ना जगह ले आघू बढ़िन अऊ जगह-जगह होवत ओमन आघू बढ़त गीन जब तक कि बादर ह पारान के सुन्ना जगह म ठहर नइं गीस। ");
INSERT INTO hne_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ओमन पहिली बार, मूसा के जरिये यहोवा के हुकूम के मुताबिक आघू बढ़िन। ");
INSERT INTO hne_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","पहिले यहूदा के सिविर के दलमन अपन झंडा के अधीन आघू बढ़िन। अमीनादाब के बेटा नहसोन ओमन के अगुवा रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","इस्साकार गोत्र के दल के अगुवा सूआर के बेटा नतनेल, ");
INSERT INTO hne_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","अऊ जबूलून के गोत्र के दल के अगुवा हेलोन के बेटा एलीआब रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","तब पबितर-तम्बू ला उसाले गीस, अऊ गेरसोनी अऊ मरारीमन येला उठाके आघू बढ़िन। ");
INSERT INTO hne_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ओकर बाद, रूबेन के सिविर के दलमन अपन झंडा के अधीन आघू बढ़िन। सदेऊर के बेटा एलीसूर ओमन के अगुवा रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","सिमोन के गोत्र के दल के अगुवा सूरीसद्दाय के बेटा सलूमीएल, ");
INSERT INTO hne_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","अऊ गाद के गोत्र के दल के अगुवा दूएल के बेटा एलियासाप रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","तब कहातीमन पबितर चीजमन ला उठाके आघू बढ़िन। ओमन के हबरे के पहिले पबितर-तम्बू ला गाड़े जावय। ");
INSERT INTO hne_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ओकर बाद एपरैम के सिविर के दलमन अपन झंडा के अधीन बढ़िन। अमीहूद के बेटा एलीसामा ह ओमन के अगुवा रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","मनस्से के गोत्र के दल के अगुवा पदासूर के बेटा गमलीएल, ");
INSERT INTO hne_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","अऊ बिनयामीन के गोत्र के दल के अगुवा गिदोनी के बेटा अबीदान रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","आखिरी म, जम्मो दल बर पाछू के पहरेदार के रूप म, दान के सिविर के दलमन अपन झंडा के अधीन आघू बढ़िन। अम्मीसद्दाय के बेटा अहीएजेर ओमन के अगुवा रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","आसेर के गोत्र के दल के अगुवा ओकरान के बेटा पगीएल, ");
INSERT INTO hne_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","अऊ नपताली के गोत्र के दल के अगुवा एनान के बेटा अहीरा रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","इसरायलीमन जब भी आघू बढ़ंय, त ओमन के दलमन के क्रम अइसने ही रहय। ");
INSERT INTO hne_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","मूसा ह अपन ससुर रूएल, जऊन ह मिदयानी रिहिस, ओकर बेटा होबाब ला कहिस, “हमन ओ जगह म जावत हन, जेकर बारे म यहोवा ह कहे हवय, ‘मेंह ओ जगह तुमन ला दूहूं।’ तें घलो हमर संग आ अऊ हमन तोर बने धियान रखबो, काबरकि यहोवा ह इसरायल बर बने चीजमन के वायदा करे हे।” ");
INSERT INTO hne_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","होबाब ह जबाब दीस, “नइं, में नइं जावंव; मेंह अपन देस अऊ अपन मनखेमन करा वापिस जावत हंव।” ");
INSERT INTO hne_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","पर मूसा ह कहिस, “हमन ला झन छोंड़। तेंह जानथस कि सुन्ना जगह म हमन ला कहां डेरा डालना चाही, अऊ तें हमर बर आंखी सहीं अस। ");
INSERT INTO hne_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","यदि तेंह हमर संग आबे, त जऊन भी बने चीज यहोवा ह हमन ला दीही, ओला हमन तोर संग बांटबो।” ");
INSERT INTO hne_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","तब इसरायलीमन यहोवा के पहाड़ ले आघू बढ़िन अऊ तीन दिन तक चलते रिहिन। ओ तीन दिन के दौरान, यहोवा के करार के सन्दूक ह ओमन बर एक ठन अराम के जगह के खोज म ओमन के आघू-आघू बढ़ते रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","जब ओमन डेरा ले आघू बढ़ंय, त दिन के बेरा यहोवा के बादर ह ओमन के ऊपर बने रहय। ");
INSERT INTO hne_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","जब भी सन्दूक ह आघू बढ़य, त मूसा ह कहय, “हे यहोवा, उठ! तोर बईरीमन तितिर-बितिर हो जावंय; तोर बईरीमन तोर आघू ले भाग जावंय।” ");
INSERT INTO hne_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","जब भी सन्दूक ह ठहर जावय, त मूसा ह कहय, “हे यहोवा, इसरायल के हजारों-हजार मनखेमन करा लहुंट आ।” ");
INSERT INTO hne_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","अब इसरायलीमन यहोवा के सुनत म अपन तकलीफ के सिकायत करे लगिन, अऊ जब ओह ओमन के बात ला सुनिस, त ओकर गुस्सा भड़क उठिस। तब ओमन के बीच यहोवा के आगी बरिस अऊ सिविर के कुछू बाहिरी भाग ला जलाके भसम कर दीस। ");
INSERT INTO hne_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","जब मनखेमन मूसा करा आके गोहार पारिन, त ओह यहोवा ले पराथना करिस अऊ आगी ह बुता गीस। ");
INSERT INTO hne_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","एकरसेति ओ जगह ला तबेरा कहे गीस, काबरकि यहोवा के आगी ह ओमन के बीच बरे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ओकर बाद ओमन के संग के हल्ला मचानेवालामन आने जेवन खाय के लालसा करे लगिन, अऊ फेर इसरायलीमन बिलाप करत कहिन, “कास हमर करा खाय बर मांस होतिस! ");
INSERT INTO hne_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","हमन ला मिसर के मछरी के सुरता आवत हे, जेला मुफत म खावत रहेंन—खीरा, कलिंदर, कांदा, गोंदली, अऊ लहसुन घलो। ");
INSERT INTO hne_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","पर अब हमर भूख ह खतम हो गे हवय; हमन ला ये मन्ना के छोंड़ अऊ कुछू नइं दिखय!” ");
INSERT INTO hne_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","मन्ना ह धनियां के बीजा सहीं रिहिस अऊ रंग ह मोती सहीं दिखय। ");
INSERT INTO hne_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","मनखेमन आसपास जाके ओला संकेलंय, अऊ तब ओला जांता म पीसंय या ओखली म कुटंय। ओमन ओला एक बरतन म रांधंय या ओकर रोटी बनांय। अऊ येकर सुवाद ह जैतून तेल ले बने कुछू चीज सहीं लगय। ");
INSERT INTO hne_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","जब रथिया सिविर म ओस पड़य, त संग म मन्ना घलो गिरय। ");
INSERT INTO hne_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","मूसा ह हर परिवार के मनखेमन ला अपन-अपन तम्बू के दुवार म रोवत सुनिस। यहोवा ह बहुंत गुस्सा करिस, अऊ मूसा ह परेसान हो गीस। ");
INSERT INTO hne_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","तब मूसा ह यहोवा ले पुछिस, “तेंह अपन सेवक ऊपर ये समस्या काबर लाने हस? मेंह अइसने का काम करके तोला दुखी करेंव कि ये जम्मो मनखेमन के बोझ मोर ऊपर डाल दे हस? ");
INSERT INTO hne_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","का ये जम्मो मनखेमन मोर गरभ म रिहिन? का येमन ला में जनमांय? तेंह मोला काबर कहिथस कि जइसने एक धाई ह छोटे लइका ला अपन कोरा म पाके चलथे, वइसने येमन ला ओ देस म लेके जा, जेला देय के वायदा तेंह येमन के पुरखामन ले कसम खाके करे रहय? ");
INSERT INTO hne_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","मेंह ये जम्मो झन बर मांस कहां ले लानंव? येमन लगातार रो-रोके मांगत रहिथें, ‘हमन ला खाय बर मांस दे!’ ");
INSERT INTO hne_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","मेंह एके झन ये जम्मो मनखेमन के भार नइं उठा सकंव; येह मोर बर भारी हे। ");
INSERT INTO hne_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","यदि ये किसम ले तोला मोर संग बरताव करना हे, त आघू बढ़ अऊ मोला मार डार—यदि तोर दया के नजर मोर ऊपर हवय, त मोला अपन खुद के दुरदसा ला झन देखा।” ");
INSERT INTO hne_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","यहोवा ह मूसा ला कहिस: “मोर करा इसरायल के सत्तर अइसने अगुवामन ला लान, जेमन ला तेंह मनखेमन के अगुवा अऊ अधिकारी के रूप म जानथस। ओमन ला मिलापवाला तम्बू करा ले आ कि ओमन उहां तोर संग ठाढ़ होवंय। ");
INSERT INTO hne_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","तब मेंह खाल्हे उतरके उहां तोर ले गोठियाहूं, अऊ जऊन आतमा के सक्ति तोर म हवय, ओमा ले कुछू सक्ति लेके मेंह ओमन म डार दूहूं। ओमन तोर संग मिलके मनखेमन के ये बोझा ला उठाहीं, ताकि तोला एके झन येला उठाना झन पड़य। ");
INSERT INTO hne_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“मनखेमन ला कह: ‘कल के तियारी म अपनआप ला पबितर करव, कल तुमन ला मांस खाय बर मिलही। काबरकि यहोवा ह तुम्हर ओ बात ला सुन ले हवय, जब तुमन बिलाप करके कहेव, “कास हमन ला मांस खाय बर मिलतिस! मिसर देस म ही हमर दसा बने रिहिस!” अब यहोवा ह तुमन ला मांस दीही, अऊ तुमन ओला खाहू। ");
INSERT INTO hne_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","तुमन ओला सिरिप एक दिन, या दू दिन, या पांच, दस या बीस दिन नइं, ");
INSERT INTO hne_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","पर पूरा एक महिना तक खाहू—जब तक कि येह तुम्हर नाक ले निकले नइं लगे अऊ येकर ले तुमन ला घिन नइं हो जावय—काबरकि तुमन यहोवा ला तुछ जाने हव, जऊन ह तुम्हर बीच म हवय, अऊ तुमन ओकर आघू म ये कहिके बिलाप करे हव, “हमन काबर मिसर देस ला छोंड़के आ गेंन?” ’ ” ");
INSERT INTO hne_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","पर मूसा ह कहिस, “इहां मेंह छै लाख पैदल चलइया मनखेमन के बीच हवंव, अऊ तेंह कहिथस, ‘मेंह पूरा एक महिना येमन ला खाय बर मांस दूहूं!’ ");
INSERT INTO hne_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","यदि पसु अऊ चिरईमन के झुंड घलो काटे जाय, त का येमन ला पूरही? यदि समुंदर के जम्मो मछरी ला घलो येमन बर पकड़े जावय, त का येमन ला पूरही?” ");
INSERT INTO hne_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","यहोवा ह मूसा ला जबाब दीस, “का यहोवा के हांथ अतेक छोटे हवय? अब तेंह देखबे कि जऊन बात मेंह तोला कहे हंव, ओह सच होथे कि नइं।” ");
INSERT INTO hne_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","तब मूसा ह बाहिर निकलिस अऊ मनखेमन ला यहोवा के कहे बात ला बताईस। ओह ओमन के सत्तर अगुवामन ला इकट्ठा करिस अऊ ओमन ला तम्बू के लकठा म ठाढ़ करिस। ");
INSERT INTO hne_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","तब यहोवा ह बादर म होके खाल्हे उतरिस अऊ मूसा ले गोठियाईस, अऊ जऊन आतमा के सक्ति मूसा म रिहिस, ओमा ले कुछू सक्ति लेके, ओह ओ सत्तर अगुवामन म डार दीस। जब ओ आतमा ओमन म आईस, त ओमन अगमबानी करे लगिन—पर एकर बाद ओमन फेर दूबारा नइं करिन। ");
INSERT INTO hne_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","पर दू झन मनखे सिविर म रह गीन, जेमा के एक झन के नांव एलदाद अऊ दूसर के नांव मेदाद रिहिस। ओमन के नांव अगुवामन के सूची म रिहिस, पर ओमन बाहिर तम्बू करा नइं गीन। तभो ले आतमा ह ओमन म आईस, अऊ ओमन घलो सिविर म अगमबानी करे लगिन। ");
INSERT INTO hne_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","एक जवान ह दऊड़के गीस अऊ मूसा ला बताईस, “एलदाद अऊ मेदाद सिविर म अगमबानी करत हें।” ");
INSERT INTO hne_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","नून के बेटा यहोसू, जऊन ह अपन जवानी के समय ले मूसा के सहायक रिहिस; ओह मूसा ला कहिस, “हे मोर मालिक, मूसा, ओमन ला मना कर!” ");
INSERT INTO hne_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","पर मूसा ह जबाब दीस, “का मोर कारन तोला जलन होवत हे? बने होतिस कि यहोवा के जम्मो मनखेमन अगमजानी होतिन अऊ यहोवा ह अपन आतमा ओमन म डार देतिस!” ");
INSERT INTO hne_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","तब मूसा अऊ इसरायल के ओ अगुवामन डेरा म वापिस चल दीन। ");
INSERT INTO hne_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","यहोवा कोति ले एक गरेर चलिस अऊ ये गरेर ह समुंदर ले बटेर चिरईमन ला ले आईस। येह बटेरमन ला दू क्यूबीट ऊंचई तक डेरा के चारों कोति, हर दिसा म एक दिन के रसता तक बगरा दीस। ");
INSERT INTO hne_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ओ पूरा दिन अऊ रथिया अऊ दूसर दिन घलो मनखेमन बाहिर जाके बटेरमन ला संकेलिन। कम से कम बटोरनेवाला घलो दस होमेर ले कम नइं बटोरिस। तब ओमन ओ बटेरमन ला सिविर के चारों कोति बगरा दीन। ");
INSERT INTO hne_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","पर खाय के बेरा जब मांस ह ओमन के मुहूं म ही रिहिस अऊ येकर पहिले कि ओमन ओला चबाके लीलतिन, यहोवा के कोरोध ह ओमन ऊपर भड़क उठिस अऊ ओह ओमन के बीच बड़े महामारी फईला दीस। ");
INSERT INTO hne_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","एकरसेति ओ जगह के नांव किबरोत-हतावा पड़िस, काबरकि उहां ओमन ओ मनखेमन ला माटी दे रिहिन, जेमन आने जेवन के लालसा करे रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ओकर बाद किबरोत-हतावा ले मनखेमन हसेरोत गीन अऊ उहां रूक गीन। ");
INSERT INTO hne_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मूसा ह एक कूसी माईलोगन ले बिहाव कर ले रिहिस, त मिरियम अऊ हारून ओकर कूसी घरवाली के कारन ओकर बिरूध गोठियाय लगिन। ");
INSERT INTO hne_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ओमन कहिन, “का यहोवा ह सिरिप मूसा के दुवारा ही बात करे हवय? का ओह हमर दुवारा घलो बात नइं करे हवय?” अऊ यहोवा ह ये बात ला सुनिस। ");
INSERT INTO hne_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(मूसा ह एक बहुंत नम्र सुभाव के मनखे रिहिस, धरती म ओकर ले जादा अऊ कोनो नम्र मनखे नइं रिहिन।) ");
INSERT INTO hne_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","तुरते यहोवा ह मूसा, हारून अऊ मिरियम ला कहिस, “तुमन तीनों झन बाहिर मिलापवाला तम्बू करा आवव।” त ओ तीनों झन बाहिर आ गीन। ");
INSERT INTO hne_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","तब यहोवा ह बादर के एक खंभा म खाल्हे आईस; ओह तम्बू के दुवार करा ठाढ़ हो गीस अऊ हारून अऊ मिरियम ला बलाईस। जब ओ दूनों झन आघू आईन, ");
INSERT INTO hne_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","त यहोवा ह कहिस, “मोर बात ला सुनव: “जब तुम्हर बीच म कोनो अगमजानी होथे, त में, यहोवा अपनआप ला ओकर करा दरसन म परगट करथंव, मेंह ओकर ले सपना म गोठियाथंव। ");
INSERT INTO hne_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","पर ये बात मोर सेवक मूसा बर लागू नइं होवय; ओह मोर जम्मो घर म बिसवासयोग्य ए। ");
INSERT INTO hne_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ओकर संग मेंह आमने-सामने, अऊ साफ-साफ गोठियाथंव, पहेलीमन म नइं गोठियावंव; ओह यहोवा के स्वरूप ला देखथे। तब तुमन काबर मोर सेवक मूसा के बिरूध गोठियाय बर नइं डरेव?” ");
INSERT INTO hne_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","तब यहोवा के कोरोध ओमन ऊपर भड़किस, अऊ ओह ओमन ला छोंड़के चल दीस। ");
INSERT INTO hne_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","जब बादर ह तम्बू के ऊपर ले उठ गीस, त मिरियम ला कोढ़ के बेमारी हो गीस अऊ ओह बरफ सहीं सफेद हो गीस। हारून ह ओकर कोति मुड़िस अऊ देखिस कि ओला असुध करइया चाम-रोग हो गे हे, ");
INSERT INTO hne_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","अऊ ओह मूसा ला कहिस, “हे मोर मालिक, मेंह बिनती करत हंव कि हमर ओ पाप ला झन धर, जेला हमन बहुंत मुरूख होके करे हवन। ");
INSERT INTO hne_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ओला दाई के गरभ ले निकलत आधा गले देहेंवाले लइका सहीं झन रहन दे।” ");
INSERT INTO hne_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","तब मूसा ह यहोवा ले गोहारिस, “हे परमेसर, किरपा करके ओला बने कर दे!” ");
INSERT INTO hne_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","यहोवा ह मूसा ला जबाब दीस, “यदि ओकर ददा ह ओकर चेहरा म थूक दे होतिस, त का ओह सात दिन तक कलंक म नइं रहितिस; ओला सात दिन तक सिविर के बाहिर रखव; ओकर बाद ओला वापिस लाने जावय।” ");
INSERT INTO hne_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","तब मिरियम ला सात दिन तक सिविर के बाहिर रखे गीस, अऊ मनखेमन आघू नइं बढ़िन जब तक कि ओला वापिस नइं लाने गीस। ");
INSERT INTO hne_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ओकर बाद, मनखेमन हसेरोत ले आघू बढ़िन अऊ पारान के सुन्ना जगह म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“कुछू मनखेमन ला कनान देस के खोजबीन करे बर भेज, जेला मेंह इसरायलीमन ला देनेवाला हंव। हर पुरखा के गोत्र म ले एक-एक झन अगुवा ला भेज।” ");
INSERT INTO hne_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","तब यहोवा के हुकूम पाके मूसा ह ओमन ला पारान के सुन्ना जगह ले पठो दीस। ओ जम्मो झन इसरायलीमन के अगुवा रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ओमन के नांव ये अंय: रूबेन के गोत्र ले जक्कूर के बेटा सम्मू; ");
INSERT INTO hne_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","सिमोन के गोत्र ले होरी के बेटा सापात; ");
INSERT INTO hne_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदा के गोत्र ले यपुन्ने के बेटा कालेब; ");
INSERT INTO hne_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्साकार के गोत्र ले यूसुफ के बेटा इगाल; ");
INSERT INTO hne_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एपरैम के गोत्र ले नून के बेटा होसे; ");
INSERT INTO hne_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बिनयामीन के गोत्र ले राफू के बेटा पलती; ");
INSERT INTO hne_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","जबूलून के गोत्र ले सोदी के बेटा गदीएल; ");
INSERT INTO hne_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","मनस्से के गोत्र ले (यूसुफ के एक गोत्र) सूसी के बेटा गद्दी; ");
INSERT INTO hne_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दान के गोत्र ले गमली के बेटा अमीएल; ");
INSERT INTO hne_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आसेर के गोत्र ले मिकाएल के बेटा सतूर; ");
INSERT INTO hne_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नपताली के गोत्र ले वोपसी के बेटा नहबी; ");
INSERT INTO hne_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","गाद के गोत्र ले माकी के बेटा गूएल। ");
INSERT INTO hne_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ये ओ मनखेमन के नांव ए, जेमन ला मूसा ह देस के खोजबीन करे बर पठोईस। (मूसा ह नून के बेटा होसे के नांव यहोसू रखिस।) ");
INSERT INTO hne_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","जब मूसा ह ओमन ला कनान देस के खोजबीन करे बर पठोईस, त ओह कहिस, “तुमन नेगेव राज म होवत पहाड़ी देस म जावव। ");
INSERT INTO hne_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","देखव कि ओ देस ह कइसे हवय अऊ जऊन मनखेमन उहां रहिथें, ओमन बलवान हें कि कमजोर, संखिया म कम हवंय कि जादा। ");
INSERT INTO hne_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","कइसे हवय ओ देस, जेमा ओमन रहिथें? बने कि खराप? रहे के नगरमन कइसे हवंय? ओ नगरमन खुला हवंय कि चारों कोति दीवार बने हवय? ");
INSERT INTO hne_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","उहां के माटी कइसे हवय? उपजाऊ हे या बंजर? उहां रूखमन हवंय कि नइं? ओ देस म ले कुछू फर लाने के पूरा कोसिस करव।” (येह पाके अंगूर के पहिली-फसल के मौसम रिहिस।) ");
INSERT INTO hne_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","त ओमन गीन अऊ सीन के सुन्ना जगह ले लेके लेबो-हमात कोति रहोब नगर तक ओ देस के खोजबीन करिन। ");
INSERT INTO hne_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ओमन नेगेव कोति ले होवत हेबरोन आ गीन, जिहां अनाक के बंसज अहीमन, सेसै अऊ तलमै रहत रिहिन। (हेबरोन सहर ह मिसर के सोअन ले सात साल पहिले बन गे रिहिस।) ");
INSERT INTO hne_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","जब ओमन एसकोल के घाटी म हबरिन, त ओमन अंगूर के एक नार ला काट लीन, जेमा अंगूर के सिरिप एके ठन गुच्छा रिहिस। ओमा के दू झन येला कुछू अनार अऊ अंजीर के संग एक ठन लउठी म लटकात बोहके ले चलिन। ");
INSERT INTO hne_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ओ जगह ला एसकोल के घाटी कहे गीस काबरकि उहां इसरायलीमन अंगूर के एक गुच्छा ला काटे रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","चालीस दिन के बाद ओमन ओ देस के खोजबीन करके लहुंट आईन। ");
INSERT INTO hne_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ओमन पारान के सुन्ना जगह के कादेस नगर म मूसा अऊ हारून अऊ जम्मो इसरायली समाज करा वापिस आईन। ओमन उहां ओमन ला अऊ जम्मो इसरायली सभा ला लेखा-जोखा दीन अऊ ओ देस के फर ओमन ला देखाईन। ");
INSERT INTO hne_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ओमन मूसा ला बताईन: “हमन ओ देस म गेंन, जिहां तेंह हमन ला पठोय रहय, ओ देस म दूध अऊ मंधरस बहुंत हवय! हमन उहां ले ये कुछू फर लेके आय हन। ");
INSERT INTO hne_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","पर उहां के मनखेमन बलवान अंय, सहरमन के चारों कोति किला हे अऊ सहरमन बहुंत बड़े हवंय। अऊ त अऊ हमन उहां अनाक के संतानमन ला घलो देखेंन। ");
INSERT INTO hne_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","अमालेकीमन नेगेव म रहिथें; हित्ती, यबूसी अऊ अमोरी पहाड़ी इलाका म रहिथें; अऊ कनानीमन समुंदर के लकठा म, यरदन नदी के तीरे-तीर रहिथें।” ");
INSERT INTO hne_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","तब कालेब ह मूसा के आघू म मनखेमन ला चुप कराईस अऊ कहिस, “हमन ला जाके ओ देस ऊपर अधिकार कर लेना चाही, काबरकि हमन खचित अइसने कर सकत हन।” ");
INSERT INTO hne_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","पर जऊन मनखेमन ओकर संग गे रिहिन, ओमन कहिन, “हमन ओमन ऊपर हमला नइं कर सकन; काबरकि ओमन हमर ले जादा बलवान हें।” ");
INSERT INTO hne_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","अऊ ओमन इसरायलीमन के बीच म ओ देस के बारे म एक खराप बात फईला दीन, जिहां ओमन गे रिहिन। ओमन कहिन, “जऊन देस के हमन भेद लेके आय हन, ओ देस ह उहां के निवासीमन ला खा जाथे। उहां जम्मो मनखेमन बड़े डीलडौल के हवंय। ");
INSERT INTO hne_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","हमन उहां नेफिलीम देखेंन (अनाक के संतानमन नेफिलीम के बंस ले आथें)। हमन अपन नजर म ओमन के आघू म फांफा सहीं लगत रहेंन, अऊ अइसने ही हमन ओमन ला दिखत रहेंन।” ");
INSERT INTO hne_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ओ रथिया समाज के जम्मो झन अपन अवाज ऊंचहा करिन अऊ जोर-जोर से रोईन। ");
INSERT INTO hne_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","जम्मो इसरायलीमन मूसा अऊ हारून के बिरूध बड़बड़ाय लगिन, अऊ पूरा सभा ह ओमन ला कहिस, “बने होतिस कि हमन मिसर म मर गे होतेंन! या ये सुन्ना जगह म मर जातेंन! ");
INSERT INTO hne_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","तलवार ले मारे जाय बर ही यहोवा ह हमन ला ये देस म काबर लानत हे? हमर घरवाली अऊ लइकामन ला लूट के सामान सहीं ले लिये जाही। का येह बने नइं होही कि हमन मिसर देस वापिस चले जावन?” ");
INSERT INTO hne_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","अऊ ओमन एक-दूसर ला कहिन, “आवव, हमन अपन बर एक अगुवा चुनके वापिस मिसर देस चल देवन।” ");
INSERT INTO hne_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","तब उहां जूरे सबो इसरायली समाज के आघू म मूसा अऊ हारून मुहूं के बल गिरिन। ");
INSERT INTO hne_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","नून के बेटा यहोसू अऊ यपुन्ने के बेटा कालेब दुखी होके अपन कपड़ा चीरिन; ये दूनों ओ दल म रिहिन, जेमन ओ देस के पता लगाय गे रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ये दूनों इसरायलीमन के पूरा सभा ला कहिन, “जऊन देस म हमन गे रहेंन अऊ खोजबीन करके आय हन, ओह बहुंत ही बने देस अय। ");
INSERT INTO hne_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","यदि यहोवा ह हमन ले खुस हवय, त ओह हमन ला ओ देस म ले जाही, जिहां दूध अऊ मंधरस के भरमार हे, अऊ ओह ओ देस हमन ला दीही। ");
INSERT INTO hne_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","यहोवा के बिरूध बिदरोह झन करव। अऊ ओ देस के मनखेमन ले झन डरव, काबरकि हमन ओमन ला नास कर देबो। ओमन के सुरकछा ह हट गे हवय, पर यहोवा ह हमर संग हवय। ओमन ले झन डरावव।” ");
INSERT INTO hne_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","पर पूरा सभा के मनखेमन ओमन ला पथरवाह करे के बात करत रिहिन। तब मिलापवाला तम्बू करा जम्मो इसरायलीमन ऊपर यहोवा के महिमा परगट होईस। ");
INSERT INTO hne_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","यहोवा ह मूसा ला कहिस, “कब तक ये मनखेमन मोर संग अपमान के बरताव करत रहिहीं? मोर दुवारा येमन के बीच म ये जम्मो चिनहां देखाय के बाद भी, येमन कब तक मोर ऊपर बिसवास नइं करहीं? ");
INSERT INTO hne_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","मेंह महामारी लानके ओमन ला नास कर दूहूं, पर मेंह तोर दुवारा एक बड़े जाति बनाहूं, जऊन ह येमन ले घलो बड़े अऊ सक्तिसाली होही।” ");
INSERT INTO hne_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","मूसा ह यहोवा ला कहिस, “तब तो मिसर देस के मनखेमन येकर बारे म सुनहीं! तेंह अपन सामर्थ ले ये इसरायलीमन ला ओमन के बीच ले निकाल लाने हस। ");
INSERT INTO hne_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","अऊ ओमन ये देस के निवासीमन ला येकर बारे म बताहीं। ओमन ये बात ला सुने हवंय कि तें यहोवा ये मनखेमन के संग रहिथस अऊ ये कि तें यहोवा आमने-सामने दिखथस, कि तोर बादर ह येमन के ऊपर ठहिरे रहिथे, अऊ ये घलो कि तेंह दिन के बेरा बादर के एक खंभा के रूप म अऊ रथिया आगी के एक खंभा के रूप म येमन के आघू-आघू रेंगथस। ");
INSERT INTO hne_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","यदि तेंह ये जम्मो मनखेमन ला मार डारबे, कोनो ला नइं छोंड़बे, त ओ जाति के मनखेमन, जऊन मन येला सुने हवंय, ओमन कहिहीं, ");
INSERT INTO hne_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘यहोवा ह ये इसरायलीमन ला ओ देस म नइं लाने सकिस, जेकर वायदा ओह येमन ले कसम खाके करे रिहिस, एकरसेति ओह येमन ला सुन्ना जगह म मार डारिस।’ ");
INSERT INTO hne_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“पर अब परभू के सक्ति ह परगट होवय, जइसे कि तेंह घोसना करे हस: ");
INSERT INTO hne_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘यहोवा ह कोरोध करे म धीमा, मया ले भरपूर अऊ पाप अऊ बिदरोह ला छेमा करइया ए। फेर दोसी ला ओह निरदोस नइं छोंड़य; ओह दाई-ददा के पाप बर ओमन के लइकामन ला तीसरा अऊ चौथा पीढ़ी तक दंड देथे।’ ");
INSERT INTO hne_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","तोर महान मया के मुताबिक, ये मनखेमन के पाप ला छेमा कर, जइसे कि तेंह येमन ला मिसर देस ले निकल आय के समय ले लेके अब तक छेमा करत आय हस।” ");
INSERT INTO hne_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","यहोवा ह जबाब दीस, “तोर बिनती के मुताबिक मेंह येमन ला छेमा कर दे हंव। ");
INSERT INTO hne_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","तभो ले, मोर जिनगी के कसम अऊ जब तक पूरा धरती ह यहोवा के महिमा ले भरे हवय, ");
INSERT INTO hne_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ओ जम्मो झन, जऊन मन मोर महिमा अऊ चिनहांमन ला मिसर अऊ सुन्ना जगह म देखिन, ओमा के जऊन मन भी मोर बात ला नइं मानिन अऊ दस बार मोला जांचिन-परखिन— ");
INSERT INTO hne_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ओमन कोनो भी ओ देस ला देखे नइं पाहीं, जेकर वायदा मेंह ओमन के पुरखामन ले कसम खाके करे रहेंव। मोर अपमान करइयामन कभू ओ देस ला देखे नइं पाहीं। ");
INSERT INTO hne_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","पर काबरकि मोर सेवक कालेब करा एक अलग आतमा हवय अऊ ओह पूरा मन से मोर पाछू चलथे, एकरसेति मेंह ओला उहां ले जाहूं, जिहां ओह गे रिहिस, अऊ ओकर संतानमन ओ देस ऊपर अधिकार करहीं। ");
INSERT INTO hne_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","काबरकि अमालेकीमन अऊ कनानीमन ओ घाटीमन म रहत हें, एकरसेति कल तुमन वापिस लहुंटव अऊ लाल-समुंदर के तीरे-तीर रसता ले सुन्ना जगह कोति आघू बढ़व।” ");
INSERT INTO hne_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","तब यहोवा ह मूसा अऊ हारून ला कहिस: ");
INSERT INTO hne_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ये दुस्ट समाज के मनखेमन कब तक मोर बिरूध बड़बड़ावत रहिहीं? मेंह ये बड़बड़ानेवाले इसरायलीमन के सिकायत ला सुने हंव। ");
INSERT INTO hne_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","एकरसेति ओमन ले कह, ‘यहोवा अपन जिनगी के कसम खाके घोसना करत हे, जऊन बात तुमन मोर सुनत म कहे हव, में तुम्हर संग वइसने ही करहूं। ");
INSERT INTO hne_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ये सुन्ना जगह म ही तुम्हर लास पड़े रहिही—ओ जम्मो, जऊन मन बीस साल या जादा उमर के हवंय, जेमन के गनती हो चुके हवय अऊ जेमन मोर बिरूध बड़बड़ाय हवंय। ");
INSERT INTO hne_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","यपुन्ने के बेटा कालेब अऊ नून के बेटा यहोसू के छोंड़, तुमन म ले कोनो ओ देस म जाय नइं सकहू, जेला तुम्हर घर बनाय बर मेंह हांथ उठाके कसम खाय रहेंव। ");
INSERT INTO hne_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","जहां तक तुम्हर लइकामन के बात ए, जेमन के लूट म जाय के बारे म तुमन कहे रहेव, मेंह ओमन ला ओ देस म आनंद करे बर लानहूं, जेला तुमन ठुकरा दे हव। ");
INSERT INTO hne_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","पर जहां तक तुम्हर बात अय, तुमन ये सुन्ना जगह म मर जाहू। ");
INSERT INTO hne_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","तुम्हर बिसवासघात के कारन, तुम्हर लइकामन चालीस बछर तक दुख भोगत इहां चरवाहा होके रहिहीं, जब तक कि तुम्हर आखिरी जन ये सुन्ना जगह म मर नइं जाही। ");
INSERT INTO hne_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","तुमन चालीस दिन तक ओ देस के खोजबीन करे रहेव—एक दिन के पाछू एक साल याने कि चालीस साल तक तुमन अपन पाप के दुख भोगहू, तब तुमन जानहू कि मोर बिरूध होय के मतलब का होथे।’ ");
INSERT INTO hne_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","में, यहोवा ये बात ला कहे हवंव, अऊ मेंह खचित ये पूरा दुस्ट समाज के संग अइसने ही करहूं, जेमन मोर बिरूध म एक जुट हो गे हवंय। ये सुन्ना जगह म येमन के आखिरी समय बीतही; इहां ओमन मर जाहीं।” ");
INSERT INTO hne_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ओ मनखे जेमन ला मूसा ह ओ देस के खोजबीन करे बर पठोय रिहिस, ओमन लहुंटके ओ देस के बारे म गलत बात कहिके मूसा के बिरूध जम्मो समाज ला बड़बड़ाय बर उभारे रिहिन— ");
INSERT INTO hne_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ये मनखे जेमन ओ देस के बारे म गलत बात फईलाय बर जिम्मेदार रिहिन, ओ जम्मो के जम्मो मार डारे गीन अऊ यहोवा के आघू म एक महामारी ले मर गीन। ");
INSERT INTO hne_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","जऊन मनखेमन ओ देस के खोजबीन करे बर गे रिहिन, ओमा ले सिरिप नून के बेटा यहोसू अऊ यपुन्ने के बेटा कालेब बांचिन। ");
INSERT INTO hne_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","जब मूसा ह जम्मो इसरायलीमन ला ये बात बताईस, त ओमन बहुंत सोक मनाईन। ");
INSERT INTO hne_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","दूसर दिन बड़े बिहनियां ये कहिके ओमन पहाड़ी देस के चोटी कोति आघू बढ़िन, “खचित हमन पाप करे हन! पर अब हमन ओ देस म जाय बर तियार हन, जेकर वायदा यहोवा ह करे हवय।” ");
INSERT INTO hne_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","पर मूसा ह कहिस, “तुमन काबर यहोवा के हुकूम ला नइं मानत हव? तुम्हर ये काम सफल नइं होवय! ");
INSERT INTO hne_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","तुमन ऊपर झन जावव, काबरकि यहोवा ह तुम्हर संग नइं ए। तुमन अपन बईरीमन ले हार जाहू, ");
INSERT INTO hne_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","अमालेकीमन अऊ कनानीमन उहां तुम्हर सामना करहीं। काबरकि तुमन यहोवा के रसता ले हट गे हव, एकरसेति ओह तुम्हर संग नइं रहय अऊ तुमन तलवार ले मार डारे जाहू।” ");
INSERT INTO hne_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","तभो ले, ओमन अपन ढिठई म पहाड़ी देस के चोटी कोति आघू बढ़िन, पर न तो मूसा अऊ न ही यहोवा के करार के सन्दूक ह सिविर ले आघू बढ़िस। ");
INSERT INTO hne_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","तब अमालेकीमन अऊ कनानीमन, जेमन ओ पहाड़ी देस म रहत रिहिन, ओमन खाल्हे उतरके इसरायलीमन ऊपर हमला कर दीन अऊ ओमन ला होरमा सहर तक मारत चले गीन। ");
INSERT INTO hne_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इसरायलीमन ले बात कर अऊ ओमन ला कह: ‘जब तुमन ओ देस म हबरव, जेला मेंह तुम्हर घर के रूप म देवत हंव ");
INSERT INTO hne_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","अऊ तुमन यहोवा ला सुख-देवइया खुसबू के रूप म भेड़-बकरी या गाय-बईला के झुंड ले जेवन-बलिदान चघावव—चाहे होम-बलिदान या चढ़ावा होवय, बिसेस मन्नत या स्वेच्छा-बलिदान या तिहार-बलिदान होवय— ");
INSERT INTO hne_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","त जऊन मनखे ह चढ़ावा लानथे, ओह यहोवा ला जैतून तेल के एक हीन के चौथा भाग म सनाय उत्तम पीसान के एक एपा के दसवां भाग के एक अन्न-बलिदान चघावय। ");
INSERT INTO hne_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","होम-बलिदान या चढ़ावा बर हर एक मेढ़ा-पीला के संग पेय-बलिदान के रूप म अंगूर के मंद के एक हीन के चौथा भाग तियार करव। ");
INSERT INTO hne_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘एक मेढ़ा-पीला के संग जैतून तेल के एक हीन के तीसरा भाग म सनाय उत्तम पीसान के एक एपा के दू-दसवां भाग के एक अन्न-बलिदान, ");
INSERT INTO hne_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","अऊ पेय-बलिदान बर अंगूर के मंद के एक हीन के तीसरा भाग ला, यहोवा ला सुख-देवइया सुगंध के रूप म चघावव। ");
INSERT INTO hne_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘जब तुमन यहोवा बर एक होम-बलिदान या चढ़ावा, एक बिसेस मन्नत या मेल-बलिदान के चढ़ावा बर एक बछवा तियार करथव, ");
INSERT INTO hne_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","त बछवा के संग जैतून तेल के आधा हीन ले सनाय उत्तम पीसान के एक एपा के तीन-दसवां भाग के एक अन्न-बलिदान लानव, ");
INSERT INTO hne_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","अऊ पेय-बलिदान के रूप म आधा हीन अंगूर के मंद घलो लानव। येह यहोवा ला महकत सुख-देवइया एक जेवन-बलिदान होही। ");
INSERT INTO hne_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","हर बछवा या मेढ़ा, हर मेढ़ा-पीला या छेरी-पीला ला इही तरीका ले तियार करे जावय। ");
INSERT INTO hne_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","हर एक बलिदान के तियारी बर, तुमन इही तरीका अपनावव। ");
INSERT INTO hne_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘हर एक मनखे, जऊन ह उहां देस म जनमे हवय, ओह ये चीजमन ला ये किसम ले करय, जब ओह यहोवा ला महकत सुख-देवइया एक जेवन-बलिदान चघाथे। ");
INSERT INTO hne_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","अवइया पीढ़ी-पीढ़ी तक, जब कोनो परदेसी या कोनो अऊ मनखे, जऊन ह तुम्हर बीच म रहत हे, यदि ओह यहोवा ला महकत सुख-देवइया जेवन-बलिदान चघाथे, त ओह वइसने ही करय जइसने तुमन करथव। ");
INSERT INTO hne_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","तुम्हर बर अऊ तुम्हर बीच रहइया परदेसी बर समाज के ओहीच नियम होवय; येह अवइया पीढ़ी-पीढ़ी तक हमेसा के बिधि ठहिरय। तुमन अऊ परदेसीमन यहोवा के आघू म एक समान होहू: ");
INSERT INTO hne_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ओहीच कानून अऊ बिधि तुम्हर अऊ तुम्हर बीच रहइया परदेसी दूनों बर लागू होही।’ ” ");
INSERT INTO hne_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इसरायलीमन ले बात कर अऊ ओमन ला कह: ‘जऊन देस म मेंह तुमन ला ले जावत हंव, जब तुमन उहां हबरव ");
INSERT INTO hne_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","अऊ ओ देस के जेवन ला खावव, त ओकर एक भाग यहोवा ला बलिदान के रूप म चघावव। ");
INSERT INTO hne_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","अपन भुइयां के ऊपज के पहिली भाग के रूप म एक रोटी चघावव अऊ येला कोठार के बलिदान के रूप म चघावव। ");
INSERT INTO hne_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","अवइया पीढ़ी-पीढ़ी तक तुमन ला अपन भुइयां के पहिली ऊपज ले यहोवा ला ये बलिदान चघाना हे। ");
INSERT INTO hne_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘यदि समाज के रूप म तुमन अनजाने म, यहोवा के मूसा ला दिये कोनो हुकूम के पालन करे म असफल होथव— ");
INSERT INTO hne_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","यहोवा दुवारा मूसा के जरिये तुमन ला दिये कोनो हुकूम, जेह पीढ़ी-पीढ़ी ले चले आवत हे— ");
INSERT INTO hne_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","अऊ यदि येह अनजाने म समाज के बिगर जानकारी म होथे, तब पूरा समाज ह यहोवा ला एक महकत सुख-देवइया होम-बलिदान बर एक बछवा चघावय, अऊ संग म येकर बताय गे अन्न-बलिदान अऊ पेय-बलिदान, अऊ एक ठन बोकरा पाप-बलिदान बर चघावय। ");
INSERT INTO hne_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","पुरोहित ह पूरा इसरायली समाज बर प्रायस्चित करय, अऊ ओमन के पाप छेमा हो जाही, काबरकि ये पाप ह जानबूझके नइं करे गे रिहिस अऊ ओमन यहोवा ला अपन गलती बर जेवन-बलिदान अऊ पाप-बलिदान चघाय हवंय। ");
INSERT INTO hne_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","पूरा इसरायली समाज अऊ ओमन के बीच रहइया परदेसीमन के पाप छेमा हो जाही, काबरकि ओ जम्मो झन अनजाने म करे गे गलती म सामिल रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘पर यदि एक मनखे ह अनजाने म पाप करथे, त ओ मनखे ह पाप-बलिदान बर एक साल के बकरी लानय। ");
INSERT INTO hne_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","पुरोहित ह यहोवा के आघू म ओ मनखे बर प्रायस्चित करय, जऊन ह अनजाने म पाप करे हवय, अऊ जब प्रायस्चित कर लिये जाथे, त ओ मनखे के पाप छेमा हो जाही। ");
INSERT INTO hne_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ओहीच कानून हर ओ मनखे ऊपर लागू होथे, जऊन ह अनजाने म पाप करथे, चाहे ओह देस म जनमे कोनो इसरायली हो या फेर तुम्हर बीच म रहइया कोनो परदेसी। ");
INSERT INTO hne_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘पर ओ मनखे, जऊन ह जानबूझके पाप करथे, अऊ यहोवा के निन्दा करथे, चाहे जनमजात देसी हो या परदेसी, ओला इसरायलीमन ले जरूर अलग करे जावय। ");
INSERT INTO hne_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","काबरकि ओह यहोवा के बचन ला तुछ समझिस अऊ ओकर हुकूम ला टोरे हवय, ओला खचित अलग कर दिये जावय; ओकर दोस ओकर ऊपर बने रहिथे।’ ” ");
INSERT INTO hne_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","जब इसरायलीमन सुन्ना जगह म रिहिन, त एक मनखे मिलिस, जऊन ह बिसराम दिन म लकड़ी बीनत रहय। ");
INSERT INTO hne_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","जेमन ला ओह लकड़ी बीनत मिलिस, ओमन ओला मूसा अऊ हारून अऊ जम्मो सभा के आघू म लानिन, ");
INSERT INTO hne_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","अऊ ओमन ओला हिरासत म रखिन, काबरकि अइसे मनखे के संग का करे जावय, ये बात ह साफ नइं रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","तब यहोवा ह मूसा ला कहिस, “ओ मनखे के मरना जरूरी ए। सिविर के बाहिर पूरा सभा ह ओला पथरवाह करय।” ");
INSERT INTO hne_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","तब सभा ह ओला सिविर के बाहिर ले गीस अऊ पथरवाह करके मार डारिस, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“इसरायलीमन ले बात कर अऊ ओमन ला कह: ‘अवइया पीढ़ी-पीढ़ी तक तुमन अपन कपड़ा के छोर म झालर लगाय करव, अऊ हर झालर ह नीला रंग के डोरी ले बने रहय। ");
INSERT INTO hne_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ये झालरमन ला जब भी तुमन देखहू, त येह तुमन ला यहोवा के ओ जम्मो हुकूम ला सुरता कराही, जेकर पालन तुमन ला करना हे अऊ तुमन अपन मन अऊ आंखी के लालसा म पड़के अपनआप से बेभिचार नइं करहू। ");
INSERT INTO hne_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","तब तुमन मोर जम्मो हुकूम ला पालन करे बर सुरता करहू अऊ अपनआप ला अपन परमेसर बर पबितर करहू। ");
INSERT INTO hne_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","मेंह यहोवा तुम्हर परमेसर अंव, जऊन ह तुम्हर परमेसर होय बर तुमन ला मिसर देस ले निकाल लानिस। मेंह यहोवा तुम्हर परमेसर अंव।’ ” ");
INSERT INTO hne_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","कोरह, जेह लेवी के परपोता, कहात के पोता अऊ ईसहार के बेटा रिहिस, अऊ कुछू रूबेनी—जेमा एलीआब के बेटा दातान अऊ अबीराम, अऊ पेलेत के बेटा ओन—उदंड हो गीन ");
INSERT INTO hne_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","अऊ येमन आके मूसा के बिरूध हो गीन। ओमन के संग 250 इसरायली मनखे घलो सामिल हो गीन, जेमन समाज के नामी अगुवा अऊ समिति के सदस्य घलो चुने गे रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ओमन मूसा अऊ हारून के बिरोध करे बर एक दल के रूप म आईन अऊ ओमन ला कहिन, “तुमन अति कर दे हवव! पूरा समाज ह पबितर हे; येमा के हर एक जन पबितर हे, अऊ यहोवा ह ओमन के संग हवय। तब तुमन अपनआप ला यहोवा के सभा के ऊपर काबर ठहिराथव?” ");
INSERT INTO hne_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","मूसा ह येला सुनके, दुख म मुहूं-भरसा गिरिस। ");
INSERT INTO hne_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","तब ओह कोरह अऊ ओकर जम्मो दल ला कहिस: “कल बिहनियां यहोवा ह देखाही कि कोन ह ओकर अय अऊ कोन ह पबितर हवय, अऊ ओह ओ मनखे ला अपन लकठा म आवन दीही। जऊन मनखे ला ओह चुनही, ओला ओह अपन लकठा म लानही। ");
INSERT INTO hne_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","हे कोरह, तें अऊ तोर पाछू चलइया मनखेमन ये काम करव: धूपदानमन ला लेवव ");
INSERT INTO hne_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","अऊ कल यहोवा के आघू म ओमा कोइला के अंगरा अऊ धूप डालव। जऊन मनखे ला यहोवा ह चुनही, ओह पबितर अय। तुम लेवीमन अति कर दे हवव!” ");
INSERT INTO hne_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","मूसा ह कोरह ला ये घलो कहिस, “हे लेवीमन, तुमन सुनव! ");
INSERT INTO hne_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","का येह तुम्हर बर परयाप्त नो हय कि इसरायल के परमेसर ह तुमन ला बाकि इसरायली समाज ले अलग करे हवय अऊ तुमन ला अपन लकठा म लाने हवय कि तुमन यहोवा के पबितर-तम्बू म सेवा करव अऊ समाज के आघू म ठाढ़ होके ओमन के सेवा करव? ");
INSERT INTO hne_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ओह तोला अऊ तोर जम्मो संगी लेवीमन ला अपन लकठा म लाने हवय, पर अब तेंह पुरोहित के पद ला घलो पाय के कोसिस करत हस। ");
INSERT INTO hne_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ये काम ह यहोवा के बिरूध अय कि तें अऊ तोर जम्मो मंडली एक संग जूरे हव। हारून ह कोन ए कि तेंह ओकर बिरूध म बड़बड़ावत हस?” ");
INSERT INTO hne_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","तब मूसा ह एलीआब के बेटा दातान अऊ अबीराम ला बुलवाईस, पर ओमन कहिन, “हमन नइं आवन! ");
INSERT INTO hne_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","का येह परयाप्त नो हय कि तेंह दूध अऊ मंधरस के भरमार वाले देस ले हमन ला ये सुन्ना जगह म मारे बर ले आय हस? अऊ अब हमर ऊपर मालिक बने चाहत हस! ");
INSERT INTO hne_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","येकर छोंड़, तेंह हमन ला अइसन देस म नइं लाने, जिहां दूध अऊ मंधरस के भरमार हे अऊ न ही हमन ला खेत अऊ अंगूर के बारीमन के उत्तराधिकार दे हस। का ये मनखेमन संग गुलाम सहीं बरताव करे चाहथस? नइं, हमन नइं आवन!” ");
INSERT INTO hne_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","तब मूसा ह बहुंत गुस्सा होईस अऊ यहोवा ला कहिस, “ओमन के भेंट ला गरहन झन कर। मेंह ओमन ले एक गदहा तक नइं ले हंव, अऊ न ही ओमन के कुछू हानि करे हंव।” ");
INSERT INTO hne_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","मूसा ह कोरह ले कहिस, “तें अऊ तोर जम्मो मंडली ला कल यहोवा के आघू म आना हे—तें अऊ तोर संगीमन अऊ हारून। ");
INSERT INTO hne_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","हर मनखे अपन धूपदान ला लेवय अऊ ओमा धूप डालय—कुल मिलाके 250 धूपदान—येला यहोवा के आघू म अरपन करव। तें अऊ हारून घलो अपन धूपदान ला अरपन करव।” ");
INSERT INTO hne_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","तब ओमन के हर एक जन अपन-अपन धूपदान ला लीन, ओमा कोइला के अंगरा अऊ धूप डालिन, अऊ मिलापवाला तम्बू के मुंहटा म मूसा अऊ हारून के संग ठाढ़ हो गीन। ");
INSERT INTO hne_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","जब कोरह ह अपन जम्मो पाछू चलइयामन ला मिलापवाला तम्बू के मुंहटा म ओमन के बिरोध म इकट्ठा कर लीस, त यहोवा के महिमा ह जम्मो सभा ऊपर परगट होईस। ");
INSERT INTO hne_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","यहोवा ह मूसा अऊ हारून ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“अपनआप ला ये सभा ले अलग करव, ताकि मेंह तुरते येमन ला खतम कर दंव।” ");
INSERT INTO hne_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","पर मूसा अऊ हारून दुख म मुहूं-भरसा गिरिन अऊ गोहार पारके कहिन, “हे परमेसर, तेंह जम्मो जीयत परानीमन ला सांस देथस, त का सिरिप एक आदमी के पाप करे के कारन पूरा सभा ऊपर गुस्सा करबे?” ");
INSERT INTO hne_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“इसरायली सभा ला कह, ‘कोरह, दातान अऊ अबीराम के तम्बू ले हट जावव।’ ” ");
INSERT INTO hne_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","मूसा ह उठिस अऊ दातान अऊ अबीराम करा गीस, अऊ इसरायल के अगुवामन ओकर पाछू-पाछू गीन। ");
INSERT INTO hne_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ओह इसरायली सभा ला चेताईस, “ये दुस्ट मनखेमन के तम्बू ले दूरिहा हट जावव! ओमन के कुछू भी चीज ला झन छुवव, नइं तो ओमन के जम्मो पाप के कारन तुमन खतम हो जाहू।” ");
INSERT INTO hne_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","तब ओमन कोरह, दातान अऊ अबीराम के तम्बू ले दूरिहा हट गीन। दातान अऊ अबीराम बाहिर निकलके अपन-अपन घरवाली, लइका अऊ छोटे लइकामन संग अपन-अपन तम्बू के दुवार म खड़े रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","तब मूसा ह कहिस, “ये किसम ले तुमन जान लूहू कि यहोवा ह ये जम्मो काम करे बर मोला पठोय हवय अऊ येह मोर उपाय नो हय। ");
INSERT INTO hne_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","यदि ये मनखेमन सुभाविक मऊत मरके जम्मो मानव-जाति सहीं दुख भोगथें, तब यहोवा ह मोला नइं पठोय हे। ");
INSERT INTO hne_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","पर यदि यहोवा ह कुछू एकदम नवां चीज करथे, अऊ धरती ह अपन मुहूं फारथे अऊ येमन ला येमन के जम्मो चीज के संग लील लेथे, अऊ येमन जीयत खाल्हे अधोलोक म चले जावंय, तब तुमन जान लूहू कि ये मनखेमन यहोवा के अपमान करे हवंय।” ");
INSERT INTO hne_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","मूसा के ये बात खतम होते ही, ओमन के खाल्हे भुइयां ह दू भाग म फट गीस ");
INSERT INTO hne_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","अऊ धरती ह अपन मुहूं ला फारिस अऊ ओमन ला अऊ ओमन के घर के सामान अऊ कोरह के संग के जम्मो मनखे अऊ ओमन के सामान ला लील लीस। ");
INSERT INTO hne_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ओमन जीते जी खाल्हे अधोलोक म अपन सामान सहित हमा गीन; ओमन के हमाय के बाद, धरती फेर जस के तस हो गीस, अऊ ओमन नास होके समाज के बीच ले मिटा गीन। ");
INSERT INTO hne_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ओमन के चिल्लई सुनके, ओमन के आसपास के जम्मो इसरायलीमन ये चिचियावत भागिन, “धरती ह हमन ला घलो लीलनेवाला हे!” ");
INSERT INTO hne_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","तब यहोवा ले आगी निकलिस अऊ ओ 250 आदमी ला भसम कर दीस, जऊन मन धूप चढ़ात रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","तब यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“हारून पुरोहित के बेटा एलिआजर ला कह कि ओह आगी म ले धूपदानमन ला हटा ले अऊ बरत कोइला ला कुछू दूरिहा म बगरा दे, काबरकि ओ धूपदानमन पबितर अंय— ");
INSERT INTO hne_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ओ मनखेमन के धूपदान, जऊन मन पाप के बदले अपन परान गंवाय हें। ओ धूपदानमन ला पीटके चद्दर बना दव, ताकि ओह बेदी म मढ़े जावय, काबरकि ओमन यहोवा ला चढ़ाय गे रिहिन अऊ पबितर हो गे हवंय। येमन इसरायलीमन बर एक चिनहां ठहिरंय।” ");
INSERT INTO hne_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","तब एलिआजर पुरोहित ह ओ कांसा के धूपदानमन ला संकेलिस, जेला ओमन लाने रिहिन, जेमन जलके मर गीन, अऊ ओह ओमन ला बेदी ऊपर मढ़े बर पीट-पीटके चद्दर बना दीस, ");
INSERT INTO hne_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","जइसे कि यहोवा ह ओला मूसा के दुवारा निरदेस देय रिहिस। अइसने इसरायली सभा ला सुरता कराय बर करे गीस, ताकि हारून के संतानमन ला छोंड़ अऊ कोनो आने मनखे आके यहोवा के आघू म धूप झन जलावय, नइं तो ओह कोरह अऊ ओकर संगवारीमन सहीं हो जाही। ");
INSERT INTO hne_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ओकर दूसर दिन पूरा इसरायली समाज ह मूसा अऊ हारून के बिरूध ये कहिके बड़बड़ाय लगिस, “तुमन यहोवा के मनखेमन ला मार डारेव।” ");
INSERT INTO hne_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","पर जब ओ सभा ह मूसा अऊ हारून के बिरोध म जूरिस अऊ मिलापवाला तम्बू कोति मुड़िस, त अचानक बादर ह तम्बू ला ढांप लीस अऊ यहोवा के महिमा परगट होईस। ");
INSERT INTO hne_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","तब मूसा अऊ हारून मिलापवाला तम्बू के सामने गीन, ");
INSERT INTO hne_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","अऊ यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ये सभा ले दूरिहा चल दे ताकि मेंह अभीच येमन ला खतम कर दंव।” अऊ मूसा अऊ हारून दुख म मुहूं-भरसा गिरिन। ");
INSERT INTO hne_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","तब मूसा ह हारून ला कहिस, “अपन धूपदान ला ले अऊ ओमा बेदी के बरत कोइला लेके ओमा धूप डाल, अऊ बिगर देरी करे सभा के मनखेमन करा जा अऊ ओमन बर पछताप कर। यहोवा के कोप ह भड़के हवय; अऊ महामारी ह सुरू हो गे हवय।” ");
INSERT INTO hne_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","हारून ह वइसने ही करिस, जइसने मूसा ह कहिस, अऊ ओह सभा के बीच म दऊड़के गीस। महामारी ह मनखेमन के बीच सुरू हो गे रिहिस, पर हारून ह धूप चढ़ाईस अऊ ओमन बर पछताप करिस। ");
INSERT INTO hne_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ओह मरे अऊ जीयत मनखेमन के बीच ठाढ़ होईस, अऊ महामारी ह रूक गीस। ");
INSERT INTO hne_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","पर 14,700 मनखे महामारी ले मर गीन; येह ओमन ला छोंड़के आय, जेमन कोरह के कारन मरे रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","तब हारून ह मिलापवाला तम्बू के दुवार म मूसा करा लहुंट आईस, काबरकि महामारी ह खतम हो गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इसरायलीमन ले गोठिया अऊ ओमन ले बारह ठन लउठी ले, ओमन के पुरखा के गोत्र के हर अगुवा ले एक ठन लउठी। हर एक अगुवा के नांव ओकर लउठी म लिख। ");
INSERT INTO hne_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","लेवी के लउठी म हारून के नांव लिख, काबरकि हर गोत्र के मुखिया के नांव म एक लउठी होना चाही। ");
INSERT INTO hne_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ओ लउठीमन ला मिलापवाला तम्बू म करार कानून के सन्दूक के आघू म रख, जिहां मेंह तुम्हर ले मिलथंव। ");
INSERT INTO hne_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","तब ओ मनखे जेला मेंह चुनहूं, ओकर लउठी म पीका निकलही, अऊ इसरायलीमन तोर बिरूध म जऊन लगातार बड़बड़ावत हें, ओकर ले मेंह अपनआप ला अलग कर लूहूं।” ");
INSERT INTO hne_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","त मूसा ह इसरायलीमन ले बात करिस, अऊ ओमन के अगुवामन ओला बारह ठन लउठी दीन, ओमन के पुरखा के गोत्र के हर अगुवा बर एक ठन लउठी, अऊ हारून के लउठी घलो ओमा रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मूसा ह लउठीमन ला करार कानून के तम्बू म यहोवा के आघू म रखिस। ");
INSERT INTO hne_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ओकर दूसर दिन मूसा ह तम्बू के भीतर गीस, त ओह देखिस कि लेवी गोत्र के हारून के लउठी म सिरिप पीका ही नइं निकले रिहिस, पर ओमा कली निकलके, फूल फूटके ओमा बादाम फर भी लगे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","तब मूसा ह जम्मो लउठी ला यहोवा के आघू ले निकालके इसरायलीमन करा ले आईस। ओमन लउठीमन ला देखिन, अऊ हर एक अगुवा ह अपन-अपन लउठी ला ले लीस। ");
INSERT INTO hne_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","तब यहोवा ह मूसा ला कहिस, “हारून के लउठी ला करार कानून के सन्दूक के आघू म वापिस रख दे, ताकि येह बिदरोहीमन बर एक चिनहां के रूप म रहय। येह मोर बिरूध ओमन के बड़बड़ई ला खतम कर दीही, अऊ ओमन नइं मरहीं।” ");
INSERT INTO hne_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","मूसा ह वइसे ही करिस, जइसे यहोवा ह ओला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","इसरायलीमन मूसा ले कहिन, “हमन मर जाबो! हमन भटक गे हन, हमन जम्मो झन भटक गे हन! ");
INSERT INTO hne_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","जऊन ह यहोवा के पबितर-तम्बू के लकठा म भी आही, ओह मर जाही। का हमन जम्मो के जम्मो मर जाबो?” ");
INSERT INTO hne_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","यहोवा ह हारून ला कहिस, “तें, तोर बेटामन अऊ तोर परिवार, पबितर-स्थान ले संबंधित अपराध के काम के जिम्मेदारी लेवंय, अऊ तें अऊ तोर बेटामन पुरोहित के पद ले संबंधित अपराध के जिम्मेदारी लेवंय। ");
INSERT INTO hne_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","तोर पुरखा के गोत्र के तोर लेवी संगीमन ला अपन संग लेय ले, ताकि जब तें अऊ तोर बेटामन करार कानून के तम्बू के आघू म सेवा करव, त ओमन तुम्हर मदद करंय। ");
INSERT INTO hne_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ओमन तोर बर जिम्मेदार होवंय अऊ तम्बू के जम्मो काम करंय, पर ओमन पबितर-स्थान के चीजमन के लकठा म या बेदी करा झन जावंय। नइं तो ओमन अऊ तें दूनों मर जाहू। ");
INSERT INTO hne_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ओमन तोर संग काम करहीं अऊ मिलापवाला तम्बू के देखरेख बर जिम्मेदार होहीं—तम्बू के जम्मो काम बर—पर कोनो आने मनखे तोर लकठा म झन आवय। ");
INSERT INTO hne_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“पबितर-स्थान अऊ बेदी के देखरेख बर तें जिम्मेदार होबे, ताकि मोर कोप ह इसरायलीमन ऊपर फेर झन भड़के। ");
INSERT INTO hne_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","मेंह इसरायलीमन के बीच ले तोर संगी लेवीमन ला चुने हवंव; येमन मिलापवाला तम्बू म काम करे बर यहोवा ला समरपित तोर बर एक भेंट के सहीं अंय। ");
INSERT INTO hne_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","पर सिरिप तें अऊ तोर बेटामन ही पुरोहित के रूप म बेदी ले संबंधित हर काम अऊ परदा के भीतर के काम करहू। मेंह तोला पुरोहित के पद ला एक भेंट के रूप म देवत हंव। यदि कोनो आने मनखे पबितर-स्थान के लकठा म आथे, त ओह मार डारे जावय।” ");
INSERT INTO hne_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","तब यहोवा ह हारून ला कहिस, “मोला चघाय गे बलिदानमन के जिम्मेदारी मेंह खुद तोला देवत हंव; ओ जम्मो पबितर बलिदान, जेला इसरायलीमन मोला देथें, ओमन ला मेंह तोला अऊ तोर बेटामन ला तुम्हर भाग, तुम्हर हमेसा के भाग के रूप म देवत हंव। ");
INSERT INTO hne_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","सबले पबितर बलिदानमन, जेला आगी ले अलग रखे जाथे, ओमन तोर होहीं। ओ जम्मो भेंट म ले, जेला ओमन मोर करा सबले पबितर बलिदान के रूप म लानथें, चाहे ओह अन्न या पाप या दोस-बलिदान होवय, ओ भाग ह तोर अऊ तोर बेटामन के होही। ");
INSERT INTO hne_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","येला सबले पबितर चीज समझके खाय करव; हर एक पुरूस येला खावय। येला तेंह पबितर समझबे। ");
INSERT INTO hne_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“येह घलो तोर अय: कोनो भी चीज, जेला इसरायलीमन के जम्मो हलाय-बलिदान के भेंट म ले अलग रखे जाथे। मेंह ये चीज तोला अऊ तोर बेटा अऊ बेटीमन ला तोर हमेसा के भाग के रूप म देवत हंव। तोर घर-परिवार के हर ओ मनखे जऊन ह रीति-बिधि से सुध हे, ओह येला खा सकथे। ");
INSERT INTO hne_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“मेंह तोला ओ जम्मो बढ़िया जैतून तेल अऊ बढ़िया नवां अंगूर के मंद अऊ अनाज देवत हंव, जेला ओमन यहोवा ला अपन फसल के पहिली फर के रूप म देथें। ");
INSERT INTO hne_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","देस के ओ जम्मो पहिली-फसल, जेला ओमन यहोवा करा लानथें, ओह तोर होही। तोर घर-परिवार के हर ओ मनखे जऊन ह रीति-बिधि से सुध हे, ओह येला खा सकथे। ");
INSERT INTO hne_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“इसरायल म कोनो भी चीज यहोवा ला अरपित करे जाथे, ओह तोर अय। ");
INSERT INTO hne_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","हर परानी के पहिलांत, चाहे ओह मनखे हो या पसु, जेला यहोवा ला अरपन करे जाथे, ओह तोर अय। पर जरूरी अय कि हर पहिलांत बेटा अऊ असुध पसु के हर पहिलांत नर ला दाम लेके छोंड़ देबे। ");
INSERT INTO hne_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","जब ओमन एक महिना के हो जाथें, त तेंह पबितर-स्थान के सेकेल के मुताबिक ठहिराय गे छुटकारा के दाम चांदी के पांच सेकेल लेके ओमन ला छोंड़ देबे, येह वजन म बीस गेरा होथे। ");
INSERT INTO hne_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“पर तेंह कोनो गाय, भेड़ या बकरी के पहिलांत ला दाम लेके झन छोंड़बे; येमन पबितर पसु अंय। ओमन के खून ला बेदी ऊपर छिड़कबे अऊ ओमन के चरबी ला यहोवा ला महकत सुख-देवइया एक जेवन-बलिदान के रूप म जलाबे। ");
INSERT INTO hne_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ओमन के मांस ह तोर होवय, जइसे कि हलाय-बलिदान के छाती अऊ जेवनी जांघ ह तोर होथे। ");
INSERT INTO hne_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","जऊन पबितर बलिदान इसरायलीमन यहोवा ला चघाथें, ओमा ले अलग रखे गे कोनो भी चीज मेंह तोला अऊ तोर बेटा अऊ बेटीमन ला तोर हमेसा के भाग के रूप म देवत हंव। येह तोर अऊ तोर संतानमन बर यहोवा के आघू म हमेसा बर नून के करार ए।” ");
INSERT INTO hne_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","फेर यहोवा ह हारून ला कहिस, “ओमन के देस म तोर कोनो उत्तराधिकार नइं होही, अऊ न ही ओमन के बीच तोर कोनो भाग होही; इसरायलीमन के बीच म, मेंह तोर भाग अऊ उत्तराधिकार अंव। ");
INSERT INTO hne_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“मिलापवाला तम्बू म लेवीमन सेवा के जऊन काम करथें, ओकर बदले म, मेंह इसरायल म ओमन ला उत्तराधिकार के रूप म जम्मो दसमांस देवत हंव। ");
INSERT INTO hne_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","अब के बाद, इसरायलीमन मिलापवाला तम्बू के लकठा म झन जावंय, नइं तो ओमन अपन पाप के परतिफल भोगहीं अऊ मर जाहीं। ");
INSERT INTO hne_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","येमन लेवी अंय, जेमन मिलापवाला तम्बू म काम करहीं अऊ येकर बिरूध करे गे कोनो अपराध के जिम्मेदारी ओमन ऊपर होही। येह अवइया पीढ़ी-पीढ़ी तक एक बिधि ठहिरय। इसरायलीमन के बीच म, ओमन के कोनो उत्तराधिकार नइं होही। ");
INSERT INTO hne_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","बदले म, मेंह लेवीमन ला ओमन के उत्तराधिकार के रूप म ओ दसमांस ला देवत हंव, जेला इसरायलीमन यहोवा करा एक बलिदान के रूप म चघाथें। एकरे कारन मेंह ओमन के बारे म कहेंव: ‘इसरायलीमन के बीच म ओमन के कोनो उत्तराधिकार नइं होही।’ ” ");
INSERT INTO hne_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“लेवीमन ले बात कर अऊ ओमन ला कह: ‘जब तुमन ला इसरायलीमन ले दसमांस मिलथे, जेला मेंह तुमन ला तुम्हर उत्तराधिकार के रूप म देथंव, त तुमन ओ दसमांस के दसवां भाग यहोवा ला भेंट के रूप म चघावव। ");
INSERT INTO hne_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","तुम्हर भेंट के हिसाब तुम्हर बर कोठार के अनाज के रूप म या अंगूर के रसकुंड के रस के रूप म करे जाही। ");
INSERT INTO hne_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ये किसम ले तुमन घलो ओ जम्मो दसमांस म ले यहोवा ला एक भेंट चघाहू, जेह तुमन ला इसरायलीमन ले मिलथे। अऊ येह जरूरी अय कि ये दसमांस म ले यहोवा के भाग ला तुमन हारून पुरोहित ला देवव। ");
INSERT INTO hne_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","तुमन ला जऊन चीज भी दिये जाथे, ओ हर चीज के सबले बने अऊ पबितर भाग ला यहोवा के भाग मानके भेंट चघावव।’ ");
INSERT INTO hne_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“लेवीमन ला कह: ‘जब तुमन सबले बने भाग ला चघाथव, त येला तुम्हर बर कोठार के अनाज या अंगूर के रसकुंड के रस सहीं हिसाब करे जाही। ");
INSERT INTO hne_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","तुमन अपन परिवार सहित बांचे चीज ला कहूं मेर खा सकत हव, काबरकि येह तुम्हर मिलापवाला तम्बू म काम करे के मजदूरी अय। ");
INSERT INTO hne_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","येकर सबले बने भाग ला चघाय के दुवारा तुमन ये बात म दोसी नइं ठहिरहू; तब तुमन इसरायलीमन के पबितर बलिदानमन ला असुध नइं करहू, अऊ तुमन नइं मरहू।’ ” ");
INSERT INTO hne_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","यहोवा ह मूसा अऊ हारून ला कहिस: ");
INSERT INTO hne_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“येह कानून के एक जरूरत अय, जेकर हुकूम यहोवा ह दे हवय: इसरायलीमन ला कह कि ओमन एक लाल रंग के बछिया बिगर दोस के लानंय, जेकर ऊपर जुड़ा कभू नइं रखे गे हवय। ");
INSERT INTO hne_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","येला एलिआजर पुरोहित ला दे दव; येला सिविर के बाहिर लाने जावय अऊ ओकर आघू म मारे जावय। ");
INSERT INTO hne_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","तब एलिआजर पुरोहित ह एकर कुछू खून ला अपन अंगठी म लेवय अऊ येला मिलापवाला तम्बू के सामने कोति सात बार छिंचय। ");
INSERT INTO hne_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ओकर बाद ओकर देखत म, ओ बछिया ला जला दिये जावय—ओकर चाम, मांस, लहू अऊ पोटा ला। ");
INSERT INTO hne_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","पुरोहित ह कुछू देवदार लकड़ी, जूफा अऊ सिन्दूरी रंग के ऊन लेवय अऊ ये चीजमन ला ओ बरत बछिया के ऊपर फटिक देवय। ");
INSERT INTO hne_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ओकर बाद, जरूरी अय कि पुरोहित ह अपन ओनहा ला धोवय अऊ खुद नहावय। तब ओह सिविर म आवय, पर ओह बिधि के रूप म सांझ तक असुध रहिही। ");
INSERT INTO hne_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","जऊन मनखे ह येला जलाथे, ओह घलो अपन ओनहा ला जरूर धोवय अऊ नहावय, अऊ ओह घलो सांझ तक असुध रहिही। ");
INSERT INTO hne_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ओ मनखे जऊन ह सुध हे, ओह ओ बछिया के राख ला इकट्ठा करय अऊ ओला सिविर के बाहिर बिधि के रूप म सुध करे गे एक जगह म रख देवय। इसरायली समाज ह पानी ला सुध करे म येकर उपयोग करय; येह पाप ले सुध होय बर अय। ");
INSERT INTO hne_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","जऊन मनखे ह बछिया के राख ला इकट्ठा करथे, ओह घलो अपन ओनहा ला जरूर धोवय, अऊ ओह घलो सांझ तक असुध रहिही। येह इसरायली अऊ ओमन के बीच रहइया परदेसी दूनों बर हमेसा-हमेसा के एक बिधि ठहिरही। ");
INSERT INTO hne_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“जऊन मनखे कोनो मनखे के लास ला छूही, त ओह सात दिन तक असुध रहिही। ");
INSERT INTO hne_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","जरूरी अय कि ओह तीसरा दिन अऊ सातवां दिन अपनआप ला पानी ले सुध करय; तब ओह सुध होही। पर यदि ओह तीसरा अऊ सातवां दिन अपनआप ला सुध नइं करय, त ओह सुध नइं होही। ");
INSERT INTO hne_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","यदि ओह कोनो मनखे के लास ला छूए के बाद अपनआप ला सुध नइं करय, त ओह यहोवा के पबितर-तम्बू ला असुध करथे। अइसे मनखे ला इसरायल ले अलग कर दिये जावय। ओह असुध हवय, काबरकि ओकर ऊपर सुध करइया पानी छिंचे नइं गे हवय; ओकर असुधता ओकर ऊपर बने रहिथे। ");
INSERT INTO hne_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ये कानून ह तब लागू होथे, जब कोनो मनखे कोनो तम्बू म मर जाथे: कोनो मनखे ओ तम्बू के भीतर जाथे या जऊन ह ओ तम्बू म हवय, ओह सात दिन तक असुध रहिही, ");
INSERT INTO hne_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","अऊ ओ तम्बू म हर एक खुला बरतन, जेला ढकना ले ढांपे नइं गे हवय, ओह असुध होही। ");
INSERT INTO hne_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“जऊन मनखे ह बाहिर खुला मैदान म तलवार ले मारे गे मनखे या सुभाविक मिरतू ले मरे मनखे या मनखे के हाड़ा या कोनो कबर ला छू लेथे, त ओह सात दिन तक असुध रहिही। ");
INSERT INTO hne_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“असुध मनखे बर, ओ जलाय गे सुध करइया पाप-बलिदान म ले कुछू राख लेके एक बरतन म रखव अऊ ओकर ऊपर ताजा पानी डारव। ");
INSERT INTO hne_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","तब बिधि के मुताबिक कोनो सुध मनखे ह कुछू जूफा लेवय अऊ येला पानी म बोरके तम्बू अऊ जम्मो सामान अऊ ओ मनखेमन ऊपर छिंचय, जेमन उहां हवंय। ओह ओ मनखे के ऊपर घलो छिंचय, जऊन ह कोनो मनखे के हाड़ा या कोनो कबर या कोनो मारे गे मनखे या कोनो सुभाविक मिरतू ले मरे मनखे ला छू ले हवय। ");
INSERT INTO hne_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ओ मनखे जऊन ह सुध हे, ओह असुध मनखे ऊपर तीसरा अऊ सातवां दिन छिंचय, अऊ सातवां दिन ओह ओला सुध करय। जेमन ला सुध करे जाथे, ओमन अपन कपड़ा ला जरूर धोवंय अऊ नहावंय, अऊ ओ सांझ के बेरा ओमन सुध हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","पर जऊन मनखेमन असुध हवंय अऊ यदि अपनआप ला सुध नइं करंय, त ओमन ला समाज ले अलग कर दिये जावय, काबरकि ओमन यहोवा के पबितर-स्थान ला असुध करे हवंय। सुध करइया पानी ह ओमन ऊपर छिंचे नइं गे हवय, अऊ ओमन असुध हवंय। ");
INSERT INTO hne_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","येह ओमन बर हमेसा के बिधि ठहिरय। “जऊन मनखे ह सुध करइया पानी ला छिंचथे, ओह घलो अपन ओनहा ला जरूर धोवय, अऊ जऊन ह सुध करइया पानी ला छूथे, ओह सांझ तक असुध रहिही। ");
INSERT INTO hne_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","जऊन भी चीज ला ओ असुध मनखे छूथे, ओह असुध हो जाथे, अऊ जऊन मनखे ओ चीज ला छूथे, ओह सांझ तक असुध हो जाथे।” ");
INSERT INTO hne_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","पहिला महिना म, जम्मो इसरायली समाज के मनखेमन सीन के सुन्ना जगह म हबरिन, अऊ ओमन कादेस नगर म डेरा डालिन। उहां मिरियम ह मर गीस अऊ ओला उहां माटी दिये गीस। ");
INSERT INTO hne_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","उहां समाज के मनखेमन बर पानी नइं रिहिस, अऊ मनखेमन मूसा अऊ हारून के बिरोध म जूर गीन। ");
INSERT INTO hne_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ओमन मूसा ले झगरा करे लगिन अऊ कहिन, “बने होतिस कि हमन घलो अपन संगी इसरायलीमन संग, यहोवा के आघू म मर गे रहितेंन! ");
INSERT INTO hne_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","तेंह काबर यहोवा के समाज ला ये सुन्ना जगह म लाने कि हमन अऊ हमर पसुमन इहां मर जावन? ");
INSERT INTO hne_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","तेंह काबर हमन ला मिसर देस ले बाहिर निकालके ये भयानक जगह म ले आय? इहां न तो अनाज या अंजीर, अऊ न ही अंगूर के नार या अनार हवय। अऊ इहां पीये बर पानी घलो नइं ए!” ");
INSERT INTO hne_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","मूसा अऊ हारून सभा ले निकलके मिलापवाला तम्बू के दुवार करा गीन अऊ निरासा म मुहूं-भरसा गिरिन, अऊ यहोवा के महिमा ओमन ऊपर परगट होईस। ");
INSERT INTO hne_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ओ लउठी ला ले अऊ तें अऊ तोर भाई हारून इसरायली सभा ला एक जगह इकट्ठा करव। अऊ ओमन के देखत म ओ चट्टान ले बात कर अऊ येह अपन म ले पानी निकालही। तेंह समाज बर ये चट्टान म ले पानी निकालबे ताकि ओमन अऊ ओमन के पसु पानी पी सकंय।” ");
INSERT INTO hne_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","तब मूसा ह यहोवा के हुकूम के मुताबिक ओकर आघू म ओ लउठी ला ले लीस। ");
INSERT INTO hne_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","अऊ मूसा अऊ हारून चट्टान के आघू म समाज ला इकट्ठा करिन अऊ मूसा ह ओमन ला कहिस, “हे बिदरोह करइयामन, सुनव! का हमन ला ये चट्टान म ले तुम्हर बर पानी निकाले बर पड़ही?” ");
INSERT INTO hne_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","तब मूसा ह अपन हांथ उठाईस अऊ अपन लउठी ले ओ चट्टान ला दू बार मारिस। तब ओमा ले पानी बहे लगिस, अऊ पूरा समाज अऊ ओमन के पसुमन ओ पानी ला पीईन। ");
INSERT INTO hne_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","पर यहोवा ह मूसा अऊ हारून ला कहिस, “काबरकि तुमन इसरायलीमन के नजर म मोर ऊपर न तो परयाप्त भरोसा रखेव, न ही पबितर मानके आदर देव, एकरसेति तुमन ये समाज ला ओ देस म नइं ले जा सकहू, जेला मेंह ओमन ला दे हंव।” ");
INSERT INTO hne_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","येमन मरीबा पानी के सोतामन रिहिन, जिहां इसरायलीमन यहोवा ले झगरा करिन अऊ जिहां ओह ओमन के बीच म पबितर ठहिराय गीस। ");
INSERT INTO hne_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","मूसा ह एदोम के राजा करा कादेस ले संदेसियामन ला ये कहिके पठोईस: “तोर भाई इसरायल ह ये कहत हे: तेंह हमर ऊपर आय ओ जम्मो मुसीबत ला जानत हस। ");
INSERT INTO hne_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","हमर पुरखामन मिसर देस ला गीन, अऊ हमन उहां बहुंत साल रहेंन। मिसर के मनखेमन हमर अऊ हमर पुरखामन संग बुरा बरताव करिन, ");
INSERT INTO hne_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","पर जब हमन यहोवा ले गोहारेंन, त ओह हमर गोहार ला सुनिस अऊ एक स्वरगदूत पठोके हमन ला मिसर देस ले बाहिर निकालिस। “अब हमन इहां कादेस नगर म हन, जऊन ह तोर राज के तीर म हवय। ");
INSERT INTO hne_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","किरपा करके तोर देस म ले होके हमन ला जावन दे। हमन कोनो खेत या अंगूर के बारी म ले होके नइं जावन, अऊ न ही कोनो कुआं के पानी पीयन। हमन राजा के राजमार्ग म ही जाबो अऊ जब तक तोर राज ले निकल नइं जाबो तब तक न तो जेवनी मुड़बो अऊ न ही डेरी।” ");
INSERT INTO hne_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","पर एदोम ह जबाब दीस: “तुमन इहां ले होके नइं जा सकव; यदि कोसिस करहू, त हमन बाहिर निकलके तलवार से तुम्हर ऊपर हमला करबो।” ");
INSERT INTO hne_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","तब इसरायलीमन ये जबाब दीन: “हमन सिरिप मुख्य सड़क म जाबो, अऊ यदि हमन या हमर पसुमन तुम्हर कोनो पानी ला पीहीं, त हमन ओकर दाम चुकाबो। हमन सिरिप पैदल जाय चाहथन—अऊ कुछू नइं।” ");
INSERT INTO hne_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","फेर ओह ये जबाब दीस: “तुमन इहां ले होके नइं जा सकव।” तब एदोम ह ओमन के बिरूध एक बड़े अऊ सक्तिसाली सेना लेके निकलिस। ");
INSERT INTO hne_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","एदोम ह ओमन ला अपन राज म ले होके जाय बर मना करिस, त इसरायल ह उहां ले मुड़के चल दीस। ");
INSERT INTO hne_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","पूरा इसरायली समाज ह कादेस ले चलके होर पहाड़ करा आईस। ");
INSERT INTO hne_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","एदोम के सीमना के लकठा म, होर पहाड़ म, यहोवा ह मूसा अऊ हारून ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“हारून ह अपन पुरखा संग हमेसा बर सुत जाही। ओह ओ देस म नइं जा सकही, जेला मेंह इसरायलीमन ला दे हंव, काबरकि तुमन दूनों मरीबा के सोता करा मोर हुकूम के बिरूध बिदरोह करे रहेव। ");
INSERT INTO hne_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","हारून अऊ ओकर बेटा एलिआजर ला लेके होर पहाड़ के ऊपर जा। ");
INSERT INTO hne_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","हारून के पुरोहिती कपड़ा ला उतारके ओला ओकर बेटा एलिआजर ला पहिरा, काबरकि हारून ह अपन मनखेमन संग मिल जाही; ओह उहां मर जाही।” ");
INSERT INTO hne_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","मूसा ह यहोवा के हुकूम के मुताबिक करिस: ओमन जम्मो समाज के देखत म होर पहाड़ ऊपर गीन। ");
INSERT INTO hne_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मूसा ह हारून के पुरोहिती कपड़ामन ला उतारिस अऊ ओ कपड़ा ला हारून के बेटा एलिआजर ला पहिरा दीस। अऊ हारून ह उहां पहाड़ के टीप म मर गीस। तब मूसा अऊ एलिआजर पहाड़ ले खाल्हे उतरिन, ");
INSERT INTO hne_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","अऊ जब पूरा समाज ला पता चलिस कि हारून ह मर गे हवय, त जम्मो इसरायलीमन ओकर बर तीस दिन तक बिलाप करिन। ");
INSERT INTO hne_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","जब नेगेव म रहइया अराद के कनानी राजा ये सुनिस कि इसरायल ह अतारीम के सड़क के रसता ले आवत हे, त ओह इसरायलीमन ऊपर हमला करिस अऊ ओमा के कुछू झन ला बंदी बना लीस। ");
INSERT INTO hne_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","तब इसरायल ह यहोवा ले ये मन्नत मानिस: “यदि तेंह ये मनखेमन ला हमर हांथ म कर देबे, त हमन ओमन के सहरमन ला पूरा नास कर देबो।” ");
INSERT INTO hne_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","यहोवा ह इसरायल के बिनती ला सुनिस अऊ कनानीमन ला ओमन के अधीन कर दीस। इसरायलीमन ओमन ला अऊ ओमन के नगरमन ला पूरा नास कर दीन, एकरसेति ओ जगह के नांव होरमा पड़िस। ");
INSERT INTO hne_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ओमन होर पहाड़ ले आघू बढ़िन अऊ एदोम देस के बाहिर-बाहिर लाल-समुंदर के रसता ला धरिन। पर रसता म मनखेमन के धीरज खतम होय लगिस; ");
INSERT INTO hne_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ओमन परमेसर अऊ मूसा के बिरूध गोठियाय लगिन, अऊ कहिन, “तेंह काबर हमन ला मिसर देस ले निकालके ये सुन्ना जगह म मरे बर ले आय? इहां न तो रोटी हवय न पानी! अऊ हमन ला ये बेकार के जेवन ले घिन हो गे हवय!” ");
INSERT INTO hne_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","तब यहोवा ह ओमन के बीच जहरिला सांप पठोईस; ओमन मनखेमन ला चाबिन अऊ कतको इसरायलीमन मर गीन। ");
INSERT INTO hne_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","तब मनखेमन मूसा करा आके कहिन, “हमन यहोवा अऊ तोर बिरूध बात करके पाप करे हन। पराथना कर कि यहोवा ह ये सांपमन ला हमर करा ले हटा ले।” तब मूसा ह मनखेमन बर पराथना करिस। ");
INSERT INTO hne_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","यहोवा ह मूसा ला कहिस, “सांप के एक मूरती बनाके खंभा के ऊपर टांग दे; सांप के चाबे मनखे ह ओला देखके जीयत रहिही।” ");
INSERT INTO hne_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","त मूसा ह कांसा के एक ठन सांप के मूरती बनाईस अऊ ओला एक खंभा के ऊपर रख दीस। तब सांप के चाबे जऊन भी मनखे ओ कांसा के सांप ला देखय, त ओह बच जावय। ");
INSERT INTO hne_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","इसरायलीमन आघू बढ़िन अऊ ओबोत नांव के जगह म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","तब ओमन ओबोत ले कूच करके इये-अबारीम के सुन्ना जगह म डेरा डालिन, जऊन ह मोआब के सामने पूरब कोति हवय। ");
INSERT INTO hne_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","उहां ले ओमन आघू बढ़िन अऊ जेरेद के घाटी म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ओमन उहां ले बढ़त गीन अऊ अरनोन के तीर म डेरा डालिन, जऊन ह सुन्ना जगह म हवय अऊ अमोरी राज के सीमना तक फईले हवय। अरनोन ह मोआब के सीमना अय, मोआब अऊ अमोरीमन के बीच म। ");
INSERT INTO hne_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","एकरसेति यहोवा के लड़ई नांव के किताब म ये लिखे हवय: “सूपा म जाहब अऊ घाटीमन, अरनोन ");
INSERT INTO hne_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","अऊ घाटीमन के ढलान जऊन ह आर के इलाका तक जाथे अऊ मोआब के सीमना तक फईले हवय।” ");
INSERT INTO hne_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","उहां ले ओमन आघू बढ़िन अऊ बीर नांव कुआं करा हबरिन, जिहां यहोवा ह मूसा ला कहे रिहिस, “मनखेमन ला एक जगह म इकट्ठा कर अऊ मेंह ओमन ला पानी दूहूं।” ");
INSERT INTO hne_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","तब इसरायल ह ये गीत गाईस: “हे कुआं, पानी ले भर जा! ये गीत गावव, ");
INSERT INTO hne_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ओ कुआं के बारे म जेला हाकिममन कोड़िन, जेला परभावसाली मनखेमन कोड़िन— परभावसाली मनखेमन राजदंड अऊ लउठी ले कोड़िन।” तब ओमन सुन्ना जगह ले मत्ताना करा गीन, ");
INSERT INTO hne_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","मत्ताना ले नहलीएल, नहलीएल ले बामोत, ");
INSERT INTO hne_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","अऊ बामोत ले मोआब के घाटी करा, जिहां पिसगा पहाड़ के टीप ह बीरान भुइयां ले ऊंच हवय। ");
INSERT INTO hne_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","इसरायल ह अमोरीमन के राजा सीहोन करा संदेसियामन ला ये कहे बर पठोईस: ");
INSERT INTO hne_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“हमन ला तोर देस म ले होके जावन दे। हमन कोनो खेत या अंगूर के बारी कोति नइं जावन, न ही कोनो कुआं के पानी पीयन। जब तक तोर राज ले निकल नइं जाबो, तब तक हमन राजा के राजमार्ग म ही जाबो।” ");
INSERT INTO hne_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","पर सीहोन ह इसरायल ला अपन देस म ले होके जावन नइं दीस। ओह अपन पूरा सेना ला इकट्ठा करिस अऊ इसरायल के बिरूध सुन्ना जगह करा गीस। जब ओह यहस नगर करा हबरिस, त उहां ओह इसरायल के संग लड़िस। ");
INSERT INTO hne_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","पर इसरायल ह ओला तलवार ले मार डारिस अऊ अरनोन नदी ले लेके यब्बोक नदी तक ओकर देस म अधिकार कर लीस, पर सिरिप उहां तक, जिहां अमोनीमन रिहिन, काबरकि ओमन के सीमना ला किलाबंदी करे गे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","इसरायल ह अमोरीमन के जम्मो सहर ऊपर कब्जा करके ओमन ऊपर अधिकार कर लीस, जेमा हेसबोन सहर अऊ ओकर आसपास के नगर अऊ बस्तीमन घलो रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेसबोन ह अमोरीमन के राजा सीहोन के सहर रिहिस, जऊन ह मोआब के पहिले के राजा के बिरूध लड़े रिहिस अऊ ओकर ले अरनोन तक ओकर जम्मो देस ला लेय ले रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","एकरे कारन कबिमन कहिथें: “हेसबोन म आवव अऊ येला फेर बनावव; सीहोन के सहर ह फेर पहिले सहीं हो जावय। ");
INSERT INTO hne_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“हेसबोन ले आगी, अऊ सीहोन के सहर ले जुवाला निकलिस। येह मोआब के आर नगर ला, अरनोन के ऊंच जगह के मनखेमन ला भसम कर दीस। ");
INSERT INTO hne_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","हे मोआब, तोर ऊपर हाय! हे कमोस देवता के मनखेमन, तुमन नास हो गेव! ओह अपन बेटामन ला सरनार्थी के रूप म अऊ अपन बेटीमन ला कैदी के रूप म अमोरीमन के राजा सीहोन ला दे दीस। ");
INSERT INTO hne_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“पर हमन ओमन ला गिरा दे हन; हेसबोन सहर के राज ह दीबोन नगर तक नास हो गे हवय। हमन ओमन ला नोपह नगर तक उजाड़ दे हन जऊन ह मेदबा नगर तक फईले हवय।” ");
INSERT INTO hne_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ये किसम ले इसरायल ह अमोरीमन के देस म बस गीस। ");
INSERT INTO hne_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","मूसा के याजेर सहर म भेदियामन ला पठोय के बाद, इसरायलीमन ओकर आसपास के इलाका म कब्जा कर लीन अऊ जऊन अमोरीमन उहां रिहिन, ओमन ला भगा दीन। ");
INSERT INTO hne_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","तब ओमन मुड़के सड़क म होवत बासान कोति गीन, अऊ बासान के राजा ओग अऊ ओकर पूरा सेना ओमन के संग लड़ई करे बर निकलके एदरेई नगर करा आईन। ");
INSERT INTO hne_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","यहोवा ह मूसा ला कहिस, “ओकर ले झन डर, काबरकि मेंह ओला ओकर पूरा सेना अऊ ओकर देस सहित तोर हांथ म कर देवत हंव। ओकर संग वइसने ही कर, जइसने तेंह अमोरीमन के राजा सीहोन के संग करय, जऊन ह हेसबोन म राज करत रिहिस।” ");
INSERT INTO hne_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","तब इसरायलीमन राजा ओग अऊ ओकर बेटामन ला पूरा सेना सहित मार डारिन; ओमा के एको झन घलो नइं बचिन। अऊ इसरायलीमन ओकर देस ऊपर अधिकार कर लीन। ");
INSERT INTO hne_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","तब इसरायलीमन मोआब के मैदान म हबरिन अऊ यरीहो के सामने यरदन नदी के तीर म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","सिप्पोर के बेटा बालाक ह ओ जम्मो ला देखिस, जेला इसरायल ह अमोरीमन संग करे रिहिस, ");
INSERT INTO hne_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","अऊ मोआब ह डरा गीस, काबरकि इसरायलीमन बहुंत बड़े संखिया म रिहिन। वास्तव म, मोआब ह इसरायलीमन के कारन भयंकर डरा गीस। ");
INSERT INTO hne_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मोआबीमन मिदयानीमन के अगुवामन ला कहिन, “ये उपदरवी दल ह हमर चारों कोति के जम्मो चीज ला चट कर डारही, जइसे बईला ह खेत के घांस ला चट कर जाथे।” ओ समय सिप्पोर के बेटा बालाक ह मोआब के राजा रिहिस; ");
INSERT INTO hne_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ओह बेओर के बेटा बिलाम ला बलाय बर संदेसियामन ला भेजिस, जऊन ह फरात नदी के लकठा म अपन जनम भुइयां पतोर सहर म रिहिस। बालाक ह कहिस: “मिसर ले अब्बड़ मनखेमन आय हवंय; अऊ मोर बाजू म बस गे हवंय ओमन ले पूरा भुइयां ह ढंक गे हवय। ");
INSERT INTO hne_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","त तेंह आ अऊ ये मनखेमन ला सराप दे, काबरकि येमन मोर ले बहुंत सक्तिसाली हें। तब सायद में येमन ला हराय सकहूं अऊ देस ले बाहिर भगाय सकहूं। काबरकि मेंह जानत हंव कि जेला तें आसीस देथस, ओह आसीस पाथे, अऊ जेला तें सराप देथस, ओह सरापित हो जाथे।” ");
INSERT INTO hne_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","तब मोआब अऊ मिदयान के अगुवामन अगम बिचारे के दाम लेके चल दीन। जब ओमन बिलाम करा हबरिन, त ओला बालाक के कहे बात ला बताईन। ");
INSERT INTO hne_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","बिलाम ह ओमन ला कहिस, “आज रथिया इहां रूक जावव, अऊ जऊन बात यहोवा ह मोला कहिही, ओकर मुताबिक मेंह तुमन ला जबाब दूहूं।” त मोआब के अधिकारीमन ओकर संग रूक गीन। ");
INSERT INTO hne_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","परमेसर ह बिलाम करा आईस अऊ पुछिस, “तोर संग ये मनखेमन कोन अंय?” ");
INSERT INTO hne_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बिलाम ह परमेसर ला कहिस, “सिप्पोर के बेटा, मोआब के राजा बालाक ह मोला ये संदेस भेजे हवय: ");
INSERT INTO hne_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘मिसर देस ले निकलके आय मनखेमन के एक दल ले भुइयां ह ढंक गे हवय। अब तें आ अऊ मोर बर ओमन ला सराप दे। तब सायद में ओमन संग लड़ सकहूं अऊ ओमन ला भगाय सकहूं।’ ” ");
INSERT INTO hne_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","पर परमेसर ह बिलाम ला कहिस, “ओमन के संग झन जा। तें ओ मनखेमन ला सराप झन दे, काबरकि ओमन मोर आसीसित मनखे अंय।” ");
INSERT INTO hne_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ओकर दूसर दिन बिहनियां बिलाम ह उठके बालाक के अधिकारीमन ला कहिस, “तुमन अपन देस वापिस जावव, काबरकि यहोवा ह मोला तुम्हर संग जाय बर मना करे हवय।” ");
INSERT INTO hne_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","तब मोआब के अधिकारीमन बालाक करा लहुंटके कहिन, “बिलाम ह हमर संग आय बर मना कर दीस।” ");
INSERT INTO hne_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","तब बालाक ह आने अधिकारीमन ला पठोईस, जऊन मन संखिया म पहिले से अधिक अऊ जादा आदर योग्य रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ओमन बिलाम करा आईन अऊ कहिन: “सिप्पोर के बेटा बालाक ह ये कहिथे: तोला मोर करा आय ले कोनो चीज झन रोकय, ");
INSERT INTO hne_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","काबरकि में तोला बहुंत बढ़िया ईनाम दूहूं अऊ जऊन कुछू तें कहिबे, ओला करहूं। आ मोर बर ये मनखेमन ला सराप दे।” ");
INSERT INTO hne_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","पर बिलाम ह ओमन ला जबाब दीस, “अऊ त अऊ यदि बालाक ह अपन महल के जम्मो सोन अऊ चांदी मोला देय दे, तभो ले मेंह यहोवा मोर परमेसर के हुकूम के बाहिर जाके छोटे या बड़े कुछू काम नइं कर सकंव। ");
INSERT INTO hne_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","पर तुमन आज रथिया इहां रूकव, ताकि मेंह पता लगा सकंव कि यहोवा ह मोला का कहत हे।” ");
INSERT INTO hne_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","रथिया परमेसर ह बिलाम करा आके कहिस, “जब ये मनखेमन तोला ले जाय बर आय हवंय, त ओमन के संग जा, पर सिरिप वइसने ही करबे, जइसने मेंह तोला कहिहूं।” ");
INSERT INTO hne_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","बिलाम ह बिहनियां उठिस, अपन गदही म काठी बांधिस अऊ मोआब के अधिकारीमन संग चल दीस। ");
INSERT INTO hne_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","पर परमेसर ह बहुंत गुस्सा होईस, जब बिलाम ह ओमन के संग गीस, अऊ यहोवा के स्वरगदूत ह ओकर बिरोध करे बर सड़क म ठाढ़ हो गीस। बिलाम ह अपन गदही म चघके जावत रिहिस, अऊ दू झन सेवकमन ओकर संग रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","जब ओ गदही ह यहोवा के स्वरगदूत ला अपन हांथ म तलवार लिये देखिस, त ओह सड़क ला छोंड़के खेत कोति उतर गीस। तब बिलाम ह गदही ला फेर सड़क म लाने बर ओला मारिस। ");
INSERT INTO hne_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","तब यहोवा के स्वरगदूत ह अंगूर के बारीमन के संकरा रसता म ठाढ़ हो गीस, जेकर दूनों कोति दीवार रहय। ");
INSERT INTO hne_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","जब गदही ह यहोवा के स्वरगदूत ला देखिस, त ओह दीवार ले संट गीस, जेकर ले बिलाम के गोड़ ह दीवार ले रगड़ा गीस। त ओह फेर गदही ला मारिस। ");
INSERT INTO hne_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","तब यहोवा के स्वरगदूत ह आघू बढ़िस अऊ संकरा जगह म ठाढ़ हो गीस, जिहां न तो जेवनी अऊ न ही डेरी कोति हटे के जगह रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","जब गदही ह यहोवा के स्वरगदूत ला देखिस, त ओह बिलाम ला लेके बईठ गीस; तब बिलाम ह गुस्सा होईस अऊ गदही ला अपन लउठी ले मारे लगिस। ");
INSERT INTO hne_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","तब यहोवा ह गदही के मुहूं ला खोल दीस अऊ गदही ह बिलाम ला कहिस, “मेंह तोर का करे हंव कि तीन बार हो गीस, तेंह मोला मारत हस?” ");
INSERT INTO hne_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","त बिलाम ह गदही ला जबाब दीस, “तेंह मोला मुरूख बना दे हस! कहूं मोर हांथ म तलवार होतिस, त अभीच मेंह तोला मार डारतेंव।” ");
INSERT INTO hne_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ओ गदही ह बिलाम ला कहिस, “का मेंह तोर खुद के गदही नो हंव, जेमा तेंह हमेसा आज तक सवारी करत आय हस? का मेंह तोर संग कभू अइसने करे रहंय?” ओह कहिस, “नइं।” ");
INSERT INTO hne_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","तब यहोवा ह बिलाम के आंखी ला खोल दीस, अऊ ओह यहोवा के स्वरगदूत ला तलवार लेके सड़क म खड़े देखिस। तब ओह झुकिस अऊ मुहूं के भार गिरके दंडवत करिस। ");
INSERT INTO hne_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","यहोवा के स्वरगदूत ह ओकर ले पुछिस, “तेंह अपन गदही ला ये तीन बार ले काबर मारय? मेंह इहां तोर बिरोध करे बर आय हंव, काबरकि जऊन काम तेंह करत हस, ओह मोर आघू म सही नो हय। ");
INSERT INTO hne_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","गदही ह मोला देखिस अऊ तीन बार मोर ले दूरिहा घुंचिस। यदि ओह नइं घुंचे रहितिस, त खचित मेंह अब तक तो तोला मार डारे रहितेंव, पर गदही ला छोंड़ देतेंव।” ");
INSERT INTO hne_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","बिलाम ह यहोवा के स्वरगदूत ला कहिस, “मेंह पाप करे हंव। मोला पता नइं रिहिस कि तेंह मोर सामना करे बर सड़क म खड़े हस। यदि तेंह ये बात ले नाखुस हस, त मेंह वापिस चल दूहूं।” ");
INSERT INTO hne_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","यहोवा के स्वरगदूत ह बिलाम ला कहिस, “ओ मनखेमन संग जा, पर जऊन बात में बताहूं, ओही बात ला कहिबे।” तब बिलाम ह बालाक के अधिकारीमन संग चल दीस। ");
INSERT INTO hne_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","जब बालाक ह सुनिस कि बिलाम ह आवत हे, त ओह बिलाम ले मिले बर अरनोन के सीमना म मोआबी नगर करा गीस, जऊन ह ओकर इलाका के तीर म हवय। ");
INSERT INTO hne_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","बालाक ह बिलाम ला कहिस, “का मेंह तोला जरूरी बात बर नइं बलाय रहेंव? तेंह मोर करा काबर नइं आवत रहय? का मेंह तोला आदर देय के लईक नो हंव?” ");
INSERT INTO hne_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","बिलाम ह बालाक ला जबाब दीस, “देख, अब तो में तोर करा आ गे हंव, पर मेंह अपन मन से कुछू नइं कहंव। जेला परमेसर मोर मुहूं म डारही, सिरिप ओहीच बात कहिहूं।” ");
INSERT INTO hne_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","तब बिलाम ह बालाक के संग किरयत-हुसोत नगर म गीस। ");
INSERT INTO hne_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","उहां बालाक ह पसु अऊ भेड़मन के बलि चघाईस, अऊ कुछू भाग बिलाम अऊ अधिकारीमन ला दीस, जेमन ओकर संग रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ओकर दूसर दिन बिहनियां बालाक ह बिलाम ला ऊपर बामोत-बाल करा ले गीस, अऊ उहां ले ओह इसरायलीमन के डेरा के बाहिरी भाग ला देखिस। ");
INSERT INTO hne_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","बिलाम ह बालाक ला कहिस, “इहां मोर बर सात ठन बेदी बनवा, अऊ सात-सात ठन बछवा अऊ मेढ़ा बलिदान करे बर तियार कर।” ");
INSERT INTO hne_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बालाक ह बिलाम के कहे मुताबिक करिस, अऊ दूनों झन हर एक बेदी म एक-एक ठन बछवा अऊ मेढ़ा चघाईन। ");
INSERT INTO hne_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","तब बिलाम ह बालाक ला कहिस, “तेंह इहां अपन बलि करा ठाढ़े रह; मेंह थोरकन दूरिहा जावत हंव। हो सकथे यहोवा ह मोर ले मिले बर आवय। जऊन कुछू ओह मोर ऊपर परगट करही, मेंह तोला बताहूं।” तब ओह एक उजाड़ पहाड़ी ऊपर गीस। ");
INSERT INTO hne_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","परमेसर ह ओकर ले मिलिस, त बिलाम ह कहिस, “में सात ठन बेदी तियार करे हंव, अऊ हर बेदी म एक ठन बछवा अऊ एक ठन मेढ़ा चघाय हंव।” ");
INSERT INTO hne_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","यहोवा ह बिलाम के मुहूं म एक ठन बात डालिस अऊ कहिस, “तें बालाक करा वापिस जा अऊ ओला ये बात कह।” ");
INSERT INTO hne_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","तब बिलाम ह बालाक करा वापिस गीस अऊ ओला जम्मो मोआब के अधिकारीमन के संग अपन चढ़ावा के बाजू म खड़े पाईस। ");
INSERT INTO hne_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","तब बिलाम ह अपन संदेस दीस: “बालाक ह मोला अराम देस ले लानिस, मोआब के राजा, पूरब के पहाड़ीमन ले। ओह कहिस, ‘आ अऊ मोर बर याकूब ला सराप दे; आ अऊ इसरायल के निन्दा कर।’ ");
INSERT INTO hne_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ओमन ला मेंह कइसे सराप दंव जेमन ला परमेसर ह सराप नइं दीस? ओमन के निन्दा कइसे करंव जेमन के निन्दा यहोवा ह नइं करिस? ");
INSERT INTO hne_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","चट्टानमन के ऊपर ले मेंह ओमन ला देखत हंव, ऊंचई ले ओमन मोला दिखत हें। मेंह अइसे मनखेमन ला देखत हंव, जेमन अलग रहिथें अऊ अपनआप ला आने जातमन सहीं नइं समझंय। ");
INSERT INTO hne_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","कोन ह याकूब के धुर्रा सहीं संतानमन ला या इसरायल के एक चौथाई ला घलो गन सकथे? बने होही कि मेंह एक धरमी के सहीं मरंव, अऊ मोर अन्त ह ओमन सहीं होवय!” ");
INSERT INTO hne_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","बालाक ह बिलाम ला कहिस, “तेंह मोर संग का करय? मेंह तोला मोर बईरीमन ला सराप दे बर लानेंव, पर तेंह ओमन ला सिरिप आसीस देय के अलावा कुछू नइं करे हस!” ");
INSERT INTO hne_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ओह जबाब दीस, “जऊन बात यहोवा ह मोला कहे हवय, का ओही ला नइं बतावंव?” ");
INSERT INTO hne_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","तब बालाक ह ओला कहिस, “तेंह मोर संग आने जगह म आ, जिहां ले तें ओमन ला देख सकबे; तेंह जम्मो झन ला नइं, सिरिप ओमन के सिविर के बाहिर ला देख सकबे। अऊ उहां ले, तें मोर बर ओमन ला सराप दे।” ");
INSERT INTO hne_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","त ओह बिलाम ला पिसगा पहाड़ के ऊपर सोपीम के खेत म ले गीस, अऊ उहां ओह सात ठन बेदी बनवाईस अऊ हर बेदी म एक बछवा अऊ एक मेढ़ा चघाईस। ");
INSERT INTO hne_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","बिलाम ह बालाक ला कहिस, “तें इहां अपन चढ़ावा के बाजू म रूक अऊ मेंह जाके उहां यहोवा ले मिलत हंव।” ");
INSERT INTO hne_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","यहोवा ह बिलाम ले मिलिस अऊ ओकर मुहूं म अपन बात डालके कहिस, “बालाक करा वापिस जा अऊ ओला ये बात कह।” ");
INSERT INTO hne_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","तब बिलाम ह बालाक करा गीस अऊ ओला मोआब के अधिकारीमन के संग अपन चढ़ावा के बाजू म खड़े पाईस। बालाक ह ओकर ले पुछिस, “यहोवा ह का कहिस?” ");
INSERT INTO hne_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","तब बिलाम ह अपन संदेस दीस: “हे बालाक, सिप्पोर के बेटा उठ अऊ सुन; मोर बात ला सुन। ");
INSERT INTO hne_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमेसर ह मनखे नो हय, कि ओह लबारी मारय, ओह मनखे नो हय, कि ओह अपन मन ला बदलय। का ओह बोलथे अऊ वइसने नइं करय? का ओह वायदा करथे अऊ ओला पूरा नइं करय? ");
INSERT INTO hne_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","मोला आसीस देय के हुकूम मिले हवय; ओह आसीस दे हवय, अऊ येला मेंह नइं बदल सकंव। ");
INSERT INTO hne_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“याकूब म कोनो अनर्थ, अऊ इसरायल म कोनो दुरगति नइं दिखत हे। यहोवा ओमन के परमेसर ह ओमन के संग हवय; ओमन के बीच म राजा के जय-जयकार होथे। ");
INSERT INTO hne_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","परमेसर ह ओमन ला मिसर ले लेय आईस; ओमन करा जंगली बईला के ताकत हवय। ");
INSERT INTO hne_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","याकूब के बिरूध म न कोनो अपसकुन हवय, न इसरायल के बिरूध म कोनो खराप सकुन-बिचार। अब याकूब अऊ इसरायल के बारे म कहे जाही, ‘देखव, परमेसर ह का अद्भूत काम करे हवय!’ ");
INSERT INTO hne_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ये मनखेमन सेरनी सहीं निकलथें; ओमन एक सिंह सहीं ठाढ़ होथें ओमन तब तक अराम नइं करंय, जब तक कि अपन सिकार ला खा नइं लेवंय अऊ ओकर खून ला पी नइं लेवंय।” ");
INSERT INTO hne_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","तब बालाक ह बिलाम ला कहिस, “तें ओमन ला न तो कोनो सराप दे अऊ न ही कोनो आसीस!” ");
INSERT INTO hne_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बिलाम ह बालाक ला जबाब दीस, “का मेंह तोला नइं कहे रहेंव कि यहोवा जइसने कहिही, वइसने करहूं?” ");
INSERT INTO hne_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","तब बालाक ह बिलाम ला कहिस, “आ, तोला एक आने जगह म ले चलत हंव। सायद येह परमेसर ला बने लगय कि उहां ले ओह तोला मोर बर इसरायलीमन ला सराप देवन दे।” ");
INSERT INTO hne_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","अऊ बालाक ह बिलाम ला पेओर पहाड़ के चोटी ऊपर ले, उजाड़ जगह ला देखा दीस। ");
INSERT INTO hne_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","बिलाम ह बालाक ला कहिस, “इहां मोर बर सात ठन बेदी बनवा, अऊ सात ठन बछवा अऊ सात ठन मेढ़ा तियार कर।” ");
INSERT INTO hne_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बिलाम के कहे मुताबिक बालाक ह करिस, अऊ हर बेदी म एक बछवा अऊ एक मेढ़ा चघाईस। ");
INSERT INTO hne_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","जब बिलाम ह देखिस कि इसरायल ला आसीस देवई ह यहोवा ला बने लगथे, त ओह पहिले के सहीं सकुन-बिचार करे म मन नइं लगाईस, पर अपन चेहरा ला सुन्ना जगह कोति करिस। ");
INSERT INTO hne_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","जब बिलाम ह देखिस कि इसरायल ह गोत्र-गोत्र के मुताबिक डेरा डाले हवय, त परमेसर के आतमा ओकर ऊपर आईस ");
INSERT INTO hne_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","अऊ बिलाम ह अपन संदेस दीस: “बेओर के बेटा बिलाम के अगमबानी, ओ मनखे के अगमबानी, जेकर आंखी ह साफ-साफ देखथे, ");
INSERT INTO hne_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ओ मनखे के अगमबानी, जऊन ह परमेसर के बचन ला सुनथे, जऊन ह सर्वसक्तिमान परमेसर ले एक दरसन पाथे, जऊन ह सास्टांग दंडवत करथे, अऊ जेकर आंखीमन खुला हवंय: ");
INSERT INTO hne_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“हे याकूब, का ही सुघर हवंय तोर तम्बूमन, हे इसरायल, तोर निवासमन! ");
INSERT INTO hne_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“ओमन घाटीमन सहीं फईले हवंय, नदी के तीर म बगीचा सहीं, यहोवा दुवारा लगाय मुसब्बर, अऊ पानी तीर म लगे देवदार रूखमन सहीं हवंय। ");
INSERT INTO hne_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ओमन के बाल्टीमन ले पानी ह बहते रहिही; ओमन के बीजा ला बहुंत पानी मिलही। “ओमन के राजा ह अमालेकी राजा अगाग ले घलो महान होही; ओमन के राज ह बढ़ते ही रहिही। ");
INSERT INTO hne_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“परमेसर ह ओमन ला मिसर देस ले निकाल लानिस; ओमन करा जंगली बईला के ताकत हवय। जेमन बिरोधी देसमन ला नास करके ओमन के हाड़ा ला कुटा-कुटा कर देथें; अऊ अपन तीरमन ले बिरोधीमन ला छेद डारथें। ");
INSERT INTO hne_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","सिंह सहीं ओमन लेटके अराम करथें, सिंहनी सहीं—ओमन ला छेड़े के हिम्मत कोन करय? “जऊन मन तोला आसीस देथें, ओमन आसीस पावंय अऊ जऊन मन तोला सराप देथें, ओमन सरापित होवंय!” ");
INSERT INTO hne_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","तब बालाक के कोप बिलाम ऊपर भड़किस। ओह अपन दूनों हांथ ला ठोंकके बिलाम ला कहिस, “मेंह अपन बईरीमन ला सराप दे बर तोला बुलवाय हंव, पर तेंह तीन बार ओमन ला आसीस दे हस। ");
INSERT INTO hne_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","अब तें तुरते इहां ले भाग अऊ अपन घर जा! मेंह कहे रहेंव कि मेंह तोला बने ईनाम दूहू, पर यहोवा ह तोला ओ ईनाम ले दूरिहा रखे हवय।” ");
INSERT INTO hne_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बिलाम ह बालाक ला कहिस, “का मेंह तोर संदेसियामन ला ये नइं कहे रहेंव, ");
INSERT INTO hne_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘यदि बालाक ह मोला अपन महल के जम्मो सोन अऊ चांदी ला घलो दे दीही, तभो ले मेंह अपन ईछा ले यहोवा के हुकूम के बाहिर बने या खराप कुछू नइं कर सकंव—अऊ सिरिप ओहीच बात कहिहूं, जऊन बात यहोवा ह कहिही?’ ");
INSERT INTO hne_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","अब सुन, मेंह अपन मनखेमन करा वापिस जावत हंव, पर मेंह तोला चेतात हंव कि अवइया समय म ये इसरायली मनखेमन तोर मनखेमन संग का करहीं।” ");
INSERT INTO hne_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","तब ओह अपन संदेस दीस: “बेओर के बेटा बिलाम के अगमबानी, ओ मनखे के अगमबानी, जेकर आंखी ह साफ-साफ देखथे, ");
INSERT INTO hne_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ओ मनखे के अगमबानी, जऊन ह परमेसर के बचन ला सुनथे, जेला सर्वोच्च परमेसर ले गियान मिले हवय, जऊन ह सर्वसक्तिमान परमेसर के दरसन देखथे, जऊन ह सास्टांग दंडवत करथे, अऊ जेकर आंखीमन खुला हवंय: ");
INSERT INTO hne_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“मेंह ओला देखथंव, पर अभी नइं; मेंह ओला देखथंव, पर लकठा ले नइं। याकूब ले एक तारा निकलके आही; इसरायल ले एक राजदंड के उदय होही। ओह मोआब के माथा ला कुचरही, सेत के जम्मो मनखेमन के खोपड़ी ला कुचरही। ");
INSERT INTO hne_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","एदोम के ऊपर जय मिलही; ओकर बईरी सेईर के ऊपर जीत मिलही, पर इसरायल ह ताकतवर होवत जाही। ");
INSERT INTO hne_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","याकूब ले एक सासन करइया निकलही अऊ सहर के बांचे मनखेमन ला नास कर दीही।” ");
INSERT INTO hne_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","तब बिलाम ह अमालेक ला देखिस अऊ अपन संदेस दीस: “अमालेक ह जातिमन म पहिले रिहिस, पर ओमन के अन्त ह बहुंत बिनासकारी होही।” ");
INSERT INTO hne_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","तब बिलाम ह केनीमन ला देखिस अऊ अपन संदेस दीस: “तुम्हर निवास स्थान ह सुरकछित हवय, तुम्हर बसेरा ह चट्टान म हवय; ");
INSERT INTO hne_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","तभो ले केनी मनखेमन, तुमन नास हो जाहू जब अस्सूर ह तुमन ला बंधुवई म ले जाही।” ");
INSERT INTO hne_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","तब बिलाम ह अपन ये संदेस दीस: “हाय! जब परमेसर ह अइसने करही, त कोन ह बचही? ");
INSERT INTO hne_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","कित्ती के समुंदर तीर ले पानी जहाजमन आहीं; ओमन अस्सूर अऊ एबेर ला अपन अधीन कर लीहीं, पर आखिर म ओमन घलो नास हो जाहीं।” ");
INSERT INTO hne_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","तब बिलाम ह उठिस अऊ अपन घर वापिस चल दीस, अऊ बालाक घलो अपन रसता म चल दीस। ");
INSERT INTO hne_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","जब इसरायल ह सित्तीम म रूके रिहिस, तब कुछू इसरायली मनखेमन मोआब के माईलोगनमन संग कुकरम करे लगिन। ");
INSERT INTO hne_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","अऊ ये माईलोगनमन अपन देवता ला बलिदान चघाय के बेरा म ओमन ला नेवता देय लगिन। ये मनखेमन ओ बलि चघाय जेवन खाके ये देवतामन ला दंडवत करे लगिन। ");
INSERT INTO hne_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ये किसम ले इसरायलीमन बाल-पेओर देवता के संग जुड़ गीन। अऊ यहोवा के कोप ओमन के बिरूध भड़किस। ");
INSERT INTO hne_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","यहोवा ह मूसा ला कहिस, “ये मनखेमन के जम्मो अगुवामन ला ले, अऊ ओमन ला मारके दिन-दुपहरी म यहोवा के आघू म खुला रख दे, ताकि यहोवा के भयंकर कोरोध ह इसरायल ले हट जावय।” ");
INSERT INTO hne_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","तब मूसा ह इसरायल के नियायीमन ला कहिस, “तुमन ले हर एक जन अपन ओ मनखेमन ला मार डारव, जेमन अपनआप ला बाल-पेओर के अधीन कर दे हवंय।” ");
INSERT INTO hne_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","जब इसरायलीमन मिलापवाला तम्बू के प्रवेस दुवार म रोवत रिहिन, तब एक इसरायली मनखे ह मूसा अऊ जम्मो सभा के देखत म एक मिदयानी माईलोगन ला सिविर म ले आईस। ");
INSERT INTO hne_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","जब हारून पुरोहित के पोता, एलिआजर के बेटा पीनहास ह येला देखिस, त ओह सभा ले उठके गीस अऊ अपन हांथ म एक ठन बरछी लीस ");
INSERT INTO hne_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","अऊ ओ इसरायली मनखे के पाछू-पाछू तम्बू म गीस। ओह ओ इसरायली मनखे अऊ मिदयानी माईलोगन के पेट ला बरछी ले बेध दीस। तब इसरायलीमन के बिरूध फईले महामारी ह रूक गीस; ");
INSERT INTO hne_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","पर जेमन महामारी ले मरिन, ओमन 24,000 रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“हारून पुरोहित के पोता, एलिआजर के बेटा पीनहास ह इसरायलीमन के बिरूध मोर कोरोध ला सांत कर दे हवय। ओह ओमन के बीच मोर आदरमान बर अइसने जलन रखिस, जइसने मेंह रखथंव, एकर कारन मेंह अपन उत्साह म ओमन के अन्त नइं करेंव। ");
INSERT INTO hne_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","अब ओला बतावव कि मेंह ओकर संग अपन सांति के करार करत हंव। ");
INSERT INTO hne_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ओह अऊ ओकर संतानमन बर हमेसा के पुरोहित के पद के एक करार होही, काबरकि ओला अपन परमेसर के आदरमान बर जलन होईस अऊ ओह इसरायलीमन बर पछताप करिस।” ");
INSERT INTO hne_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","जऊन इसरायली ह मिदयानी माईलोगन के संग मारे गीस, ओह सिमोनी गोत्र के एक अगुवा सालू के बेटा जिमरी रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","अऊ जऊन मिदयानी माईलोगन ह मारे गीस, ओकर नांव कोजबी रिहिस, जऊन ह एक मिदयानी परिवार के गोत्र के एक मुखिया सूर के बेटी रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिदयानीमन के संग बईरी के सहीं बरताव करत ओमन ला मार डार। ");
INSERT INTO hne_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","काबरकि ओमन तुम्हर संग बईरी के सहीं बरताव करिन, जब ओमन अपन बहिनी, एक मिदयानी अगुवा के बेटी कोजबी ला सामिल करके पेओर के मामला म तुमन ला धोखा दीन, ओ माईलोगन ह मारे गीस, जब ओ घटना के कारन महामारी आईस।” ");
INSERT INTO hne_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","महामारी के बाद यहोवा ह मूसा अऊ हारून पुरोहित के बेटा एलिआजर ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“जम्मो इसरायली समाज के गनती परिवार के मुताबिक करव—जेमन बीस साल या जादा उमर के हवंय अऊ इसरायल के सेना म सेवा दे सकत हें।” ");
INSERT INTO hne_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","तब मूसा अऊ एलिआजर पुरोहित, यरीहो के ओ पार यरदन नदी के तीर, मोआब के मैदान म इसरायलीमन ले बात करिन अऊ कहिन, ");
INSERT INTO hne_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“बीस साल या ओकर ले जादा उमर के मनखेमन के गनती करव, जइसने यहोवा ह मूसा ला हुकूम दे हवय।” ");
INSERT INTO hne_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","इसरायल के पहिलांत बेटा रूबेन के संतान: हनोक के जरिये हनोकी गोत्र; पल्लू के जरिये पल्लूयी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेसरोन के जरिये हेसरोनी गोत्र; करमी के जरिये करमी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","येमन रूबेनी गोत्र के रिहिन; जेमन के गनती, 43,730 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","पल्लू के बेटा एलीआब रिहिस, ");
INSERT INTO hne_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","अऊ एलीआब के बेटामन नमूएल, दातान अऊ अबीराम रिहिन। इही दातान अऊ अबीराम समाज के करमचारी रिहिन अऊ येमन मूसा अऊ हारून के बिरूध बिदरोह करिन अऊ येमन कोरह के ओ अनुयायीमन के संग रिहिन, जब ओमन यहोवा के बिरूध बिदरोह करिन। ");
INSERT INTO hne_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","धरती ह अपन मुहूं फारिस अऊ ओमन ला कोरह के संग लील लीस; ओकर पाछू चलइयामन मर गीन, जब आगी ह 250 मनखे ला भसम कर दीस। अऊ ओमन चेतउनी के एक चिनहां होईन। ");
INSERT INTO hne_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","तभो ले कोरह के बंस ह खतम नइं होईस। ");
INSERT INTO hne_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","सिमोन के संतान ओमन के गोत्र के मुताबिक: नमूएल के जरिये नमूएली गोत्र; यामीन के जरिये यामीनी गोत्र; याकीन के जरिये याकीनी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","जेरह के जरिये जेरही गोत्र; साऊल के जरिये साऊली गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","येमन सिमोन गोत्र के रिहिन; जेमन के गनती, 22,200 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","गाद के संतान ओमन के गोत्र के मुताबिक: सपोन के जरिये सपोनी गोत्र; हाग्गी के जरिये हाग्गी गोत्र; सूनी के जरिये सूनी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ओजनी के जरिये ओजनी गोत्र; एरी के जरिये एरी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोद के जरिये अरोदी गोत्र; अरेली के जरिये अरेली गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","येमन गाद गोत्र के रिहिन; जेमन के गनती 40,500 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","यहूदा के बेटा एर अऊ ओनान रिहिन, पर ओमन कनान देस म मर गीन। ");
INSERT INTO hne_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","यहूदा के संतान ओमन के गोत्र के मुताबिक: सेलह के जरिये सेलानी गोत्र; पेरेस के जरिये पेरेसी गोत्र; जेरह के जरिये जेरही गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","पेरेस के संतान येमन रिहिन: हेसरोन के जरिये हेसरोनी गोत्र; हामूल के जरिये हामूली गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","येमन यहूदा गोत्र के रिहिन; जेमन के गनती 76,500 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","इस्साकार के संतान ओमन के गोत्र के मुताबिक: तोला के जरिये तोलायी गोत्र; पुआ के जरिये पुवी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","यासूब के जरिये यासूबी गोत्र; सिमरोन के जरिये सिमरोनी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","येमन इस्साकार गोत्र के रिहिन; जेमन के गनती 64,300 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","जबूलून के संतान ओमन के गोत्र के मुताबिक: सेरेद के जरिये सेरेदी गोत्र; एलोन के जरिये एलोनी गोत्र; यहलेल के जरिये यहलेली गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","येमन जबूलूनी गोत्र के रिहिन; जेमन के गनती, 60,500 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","यूसुफ के संतान, जेमन गोत्र के मुताबिक मनस्से अऊ एपरैम के जरिये होईन: ");
INSERT INTO hne_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनस्से के संतान: माकीर के जरिये माकीरी गोत्र (माकीर ह गिलाद के ददा रिहिस); गिलाद के जरिये गिलादी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलाद के संतान येमन रिहिन: ईएजेर के जरिये ईएजेरी गोत्र; हेलेक के जरिये हेलेकी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","असरीएल के जरिये असरीएली गोत्र; सकेम के जरिये सकेमी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","समीदा के जरिये समीदायी गोत्र; हेपेर के जरिये हेपेरी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(हेपेर के बेटा सलोफाद के कोनो बेटा नइं रिहिन; ओकर सिरिप बेटीमन रिहिन, जेमन के नांव महला, नोआ, होगला, मिलका अऊ तिरसा रिहिस।) ");
INSERT INTO hne_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","येमन मनस्से के गोत्र रिहिन; जेमन के गनती 52,700 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एपरैम के संतान ओमन के गोत्र के मुताबिक येमन रिहिन: सूतेलह के जरिये सूतेलही गोत्र; बेकेर के जरिये बेकेरी गोत्र; तहान के जरिये तहानी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","सूतेलह के संतान येमन रिहिन: एरान के जरिये एरानी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","येमन एपरैम के संतान रिहिन; जेमन के गनती, 32,500 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","बिनयामीन के संतान ओमन के गोत्र के मुताबिक: बेला के जरिये बेलायी गोत्र; असबेल के जरिये असबेली गोत्र; अहीराम के जरिये अहीरामी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","सूपाम के जरिये सूपामी गोत्र; हूपाम के जरिये हूपामी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","बेला के संतान अर्द अऊ नामान के जरिये: अर्द के जरिये अर्दी गोत्र; नामान के जरिये नामानी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","येमन बिनयामीन के गोत्र रिहिन; जेमन के संखिया 45,600 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दान के संतान ओमन के गोत्र के मुताबिक येमन रिहिन: सूहाम के जरिये सूहामी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","येमा के जम्मो झन सूहामी गोत्र के रिहिन; जेमन के संखिया 64,400 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आसेर के संतान ओमन के गोत्र के मुताबिक: यिमना के जरिये यिमनी गोत्र; इसवी के जरिये इसवी गोत्र; बरीया के जरिये बरीयी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","अऊ बरीया के संतान के जरिये: हेबेर के जरिये हेबेरी गोत्र; मलकीएल के जरिये मलकीएली गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","आसेर के सेरह नांव के एक बेटी रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","येमन आसेर के गोत्र रिहिन; जेमन के गनती 53,400 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","नपताली के संतान ओमन के गोत्र के मुताबिक: यहसेल के जरिये यहसेली गोत्र; गूनी के जरिये गूनी गोत्र; ");
INSERT INTO hne_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेर के जरिये येसेरी गोत्र; सिल्लेम के जरिये सिल्लेमी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","येमन नपताली गोत्र के रिहिन; जेमन के गनती 45,400 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","इसरायल के पुरूसमन के कुल संखिया 6,01,730 रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“नांव के गनती के आधार म ओमन के बीच म भुइयां ला ओमन के उत्तराधिकार के रूप म बांटना हे। ");
INSERT INTO hne_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","बड़े दल ला बड़े भाग दे, अऊ छोटे दल ला छोटे भाग; सूची म ओमन के गनती के मुताबिक हर एक ला ओकर उत्तराधिकार मिलय। ");
INSERT INTO hne_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","येकर धियान रखबे कि भुइयां ला चिट्ठी के जरिये बांटे जावय। हर एक दल ला जऊन भाग मिलथे, ओह ओकर पुरखा के गोत्र के नांव के मुताबिक होवय। ");
INSERT INTO hne_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","हर उत्तराधिकार ला चिट्ठी के दुवारा बड़े अऊ छोटे दलमन के बीच बांटे जावय।” ");
INSERT INTO hne_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ये लेवीमन रिहिन, जेमन के गनती ओमन के गोत्र के मुताबिक होईस: गेरसोन के जरिये गेरसोनी गोत्र; कहात के जरिये कहाती गोत्र; मरारी के जरिये मरारी गोत्र। ");
INSERT INTO hne_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","लेवी गोत्र के येमन घलो रिहिन: लिबनी गोत्र, हेबरोनी गोत्र, महली गोत्र, मूसी गोत्र, कोरही गोत्र। (कहात ह अमराम के पुरखा रिहिस; ");
INSERT INTO hne_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अमराम के घरवाली के नांव योकेबेद रिहिस, जऊन ह लेवी के एक संतान रिहिस, अऊ मिसर म लेवी बंस म जनमे रिहिस। अमराम कोति ले ओह हारून, मूसा अऊ ओमन के बहिनी मिरियम ला जनम दीस। ");
INSERT INTO hne_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","हारून ह नादाब, अबीहू, एलिआजर अऊ ईतामार के ददा रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","पर नादाब अऊ अबीहू मर गीन, जब ओमन यहोवा के आघू म बिगर अधिकार वाले आगी ले एक बलिदान चघाईन।) ");
INSERT INTO hne_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","जम्मो लेवी पुरूस, जेमन एक महिना अऊ जादा उमर के रिहिन, गनती म 23,000 रिहिन। येमन ला आने इसरायलीमन संग नइं गने गीस, काबरकि येमन ला ओमन के बीच उत्तराधिकार नइं मिले रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मूसा अऊ एलिआजर पुरोहित के दुवारा येमन ला गने गीस, जब ओमन यरीहो के ओ पार यरदन नदी के तीर मोआब के मैदान म इसरायलीमन के गनती करिन। ");
INSERT INTO hne_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","जऊन इसरायलीमन ला मूसा अऊ हारून पुरोहित, सीनय के सुन्ना जगह म गने रिहिन, ओमा के एको झन घलो अभी गने गय मनखेमन के बीच नइं रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","काबरकि यहोवा ह ओ इसरायलीमन ला कहे रिहिस कि ओमन खचित सुन्ना जगह म मर जाहीं, अऊ सिरिप यपुन्ने के बेटा कालेब अऊ नून के बेटा यहोसू ला छोंड़ ओमा के एको झन घलो नइं बांचिन। ");
INSERT INTO hne_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","मनस्से के बेटा माकीर, माकीर के बेटा गिलाद, गिलाद के बेटा हेपेर, हेपेर के बेटा सलोफाद, सलोफाद ले ओकर बेटीमन रिहिन; येमन यूसुफ के बेटा मनस्से के गोत्र के रिहिन। सलोफाद के बेटीमन के नांव महला, नोआ, होगला, मिलका अऊ तिरसा रिहिस। एक दिन ओमन आईन ");
INSERT INTO hne_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","अऊ मिलापवाला तम्बू के प्रवेस दुवार करा मूसा, एलिआजर पुरोहित, अगुवामन अऊ जम्मो सभा के आघू म ठाढ़ होके कहिन, ");
INSERT INTO hne_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“हमर ददा ह सुन्ना जगह म मर गीस। ओह कोरह के मनखेमन के संग नइं रिहिस, जेमन मिलके यहोवा के बिरोध करिन, पर हमर ददा ह अपन खुद के पाप के कारन मर गीस अऊ ओकर कोनो बेटा नइं ए। ");
INSERT INTO hne_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ओकर कोनो बेटा नइं होय के कारन ओकर नांव ह गोत्र ले काबर खतम हो जावय? एकरसेति हमर ददा के रिस्तेदारमन के बीच म हमन ला घलो संपत्ति देवव।” ");
INSERT INTO hne_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","तब मूसा ह ओमन के ये बात ला यहोवा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","अऊ यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सलोफाद के बेटीमन जऊन बात कहत हें, ओह सही अय। जरूरी ए कि तें ओमन ला ओमन के ददा के रिस्तेदारमन के बीच उत्तराधिकार के रूप म संपत्ति दे अऊ ओमन के ददा के उत्तराधिकार ओमन ला दे। ");
INSERT INTO hne_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“इसरायलीमन ला कह, ‘यदि कोनो मनखे बिगर बेटा के मर जाथे, त ओकर उत्तराधिकार ओकर बेटी ला दिये जावय। ");
INSERT INTO hne_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","यदि ओकर कोनो बेटी नइं ए, त ओकर भाईमन ला उत्तराधिकार दिये जावय। ");
INSERT INTO hne_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","यदि ओकर कोनो भाई नइं ए, त ओकर उत्तराधिकार ओकर ददा के भाईमन ला दिये जावय। ");
INSERT INTO hne_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","यदि ओकर ददा के भाई नइं ए, त उत्तराधिकार ओकर गोत्र के सबले नजदीकी रिस्तेदार ला मिलय, संपत्ति ला ओह ले लेवय। ये कानून ला इसरायलीमन के बीच म कड़ई से माने जावय, जइसने कि यहोवा ह मूसा ला हुकूम दे हवय।’ ” ");
INSERT INTO hne_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","तब यहोवा ह मूसा ला कहिस, “ये पहाड़ के अबारीम छेत्र म ऊपर जा अऊ ओ देस ला देख, जेला मेंह इसरायलीमन ला दे हंव। ");
INSERT INTO hne_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","येला देखे के बाद, तेंह घलो अपन भाई हारून सहीं अपन मनखेमन के संग हमेसा बर सुत जाबे, ");
INSERT INTO hne_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","काबरकि जब समाज ह सीन के सुन्ना जगह म पानी के सोता करा बिदरोह करिस, त तुमन दूनों मोर हुकूम ला नइं मानके ओमन के नजर म मोर पबितरता के अनादर करेव।” (येमन सीन के सुन्ना जगह म मरीबा-कादेस के पानी के सोतामन रिहिन।) ");
INSERT INTO hne_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मूसा ह यहोवा ले बिनती करिस, ");
INSERT INTO hne_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“यहोवा, परमेसर जऊन ह जम्मो जीयत चीजमन ला सांस देथे, ओह ये समाज के ऊपर कोनो ला ठहिरावय ");
INSERT INTO hne_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","जऊन ह ओमन के आघू म आवय-जावय, जऊन ह ओमन के अवई अऊ जवई म अगुवई करय, ताकि यहोवा के समाज बिगर चरवाहा के भेड़मन सहीं झन होवय।” ");
INSERT INTO hne_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","तब यहोवा ह मूसा ला कहिस, “नून के बेटा यहोसू ला ले अऊ ओकर ऊपर अपन हांथ रख; ओह एक अइसे मनखे अय, जेमा अगुवई करे के आतमा हवय। ");
INSERT INTO hne_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ओला एलिआजर पुरोहित अऊ जम्मो सभा के आघू म ठाढ़ कर अऊ ओमन के आघू म ओला अधिकार दे। ");
INSERT INTO hne_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ओला तोर कुछू अधिकार दे ताकि पूरा इसरायली समाज ओकर बात मानय। ");
INSERT INTO hne_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ओह एलिआजर पुरोहित के आघू म ठाढ़ होवय, जऊन ह यहोवा के आघू म ऊरीम के पुछताछ के दुवारा ओकर बर परमेसर के ईछा मालूम करय। ओकर हुकूम ले ओह अऊ पूरा इसरायली समाज जावंय अऊ ओकर हुकूम ले ओमन आवंय।” ");
INSERT INTO hne_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","मूसा ह वइसने ही करिस, जइसने यहोवा ह ओला हुकूम दे रिहिस। ओह यहोसू ला लीस अऊ ओला एलिआजर पुरोहित अऊ जम्मो सभा के आघू म ठाढ़ करिस। ");
INSERT INTO hne_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","तब मूसा ह यहोसू के ऊपर अपन हांथ रखके ओला अधिकार दीस, जइसे यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“इसरायलीमन ला ये हुकूम देके कह: ‘धियान रहय कि ठहिराय गे समय म मोला महकत सुख-देवइया जेवन-बलिदान चघावव।’ ");
INSERT INTO hne_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ओमन ला कह: ‘तुमन यहोवा ला ये जेवन-बलिदान चघावव: हर दिन होम-बलिदान के रूप म एक-एक बछर के दू ठन निरदोस मेढ़ा-पीला चघाय जावय। ");
INSERT INTO hne_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","एक ठन मेढ़ा-पीला ला बिहनियां अऊ एक ठन ला सांझ के चघावव, ");
INSERT INTO hne_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","संग म एक एपा उत्तम पीसान के दसवां भाग ला चढ़ावा चघावव, जेमा पेरके निकाले गय एक हीन जैतून तेल के चौथा भाग मिले रहय। ");
INSERT INTO hne_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","येह यहोवा ला चघाय जानेवाला महकत सुख-देवइया एक जेवन-बलिदान सीनय पहाड़ म ठहिराय गे नियमित होम-बलिदान ए। ");
INSERT INTO hne_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","संग म हर मेढ़ा-पीला के संग एक हीन के एक चौथाई मंद के पेय-बलिदान रहय। पेय-बलिदान ला पबितर-स्थान म यहोवा बर ढार दव। ");
INSERT INTO hne_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","दूसर मेढ़ा-पीला ला सांझ के बेरा चघावव; संग म ओहीच किसम के अन्न-बलिदान अऊ पेय-बलिदान के चढ़ावा घलो चघाय जावय, जइसे कि तुमन बिहनियां के बेरा चघाथव। येह यहोवा ला एक महकत सुख-देवइया जेवन-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘बिसराम दिन म, एक-एक साल के दू ठन निरदोस मेढ़ा-पीला के चढ़ावा चघावव; संग म येकर पेय-बलिदान अऊ एक एपा के दू-दसवां भाग जैतून तेल म सने उत्तम पीसान के एक अन्न-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","नियमित रूप से चघाय जानेवाला होम-बलिदान अऊ येकर पेय-बलिदान के अलावा येह हर बिसराम दिन बर होम-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘हर महिना के सुरू म, दू ठन बछवा, एक ठन मेढ़ा अऊ एक-एक साल के सात ठन निरदोस मेढ़ा-पीला यहोवा ला एक होम-बलिदान के रूप म चघाय करव। ");
INSERT INTO hne_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","हर बछवा के संग तेल ले सने उत्तम पीसान के एक एपा के तीन-दसवां भाग अन्न-बलिदान के रूप म चघावव; मेढ़ा-पीला के संग तेल ले सने उत्तम पीसान के एक एपा के दू-दसवां भाग अन्न-बलिदान के रूप म चघावव; ");
INSERT INTO hne_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","अऊ हर एक मेढ़ा-पीला के संग तेल ले सने उत्तम पीसान के एक एपा के दसवां भाग अन्न-बलिदान के रूप म चघावव। येह यहोवा बर चघाय जानेवाला एक होम-बलिदान, एक महकत सुख-देवइया जेवन-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","हर एक बछवा के संग आधा हीन अंगूर के मंद; मेढ़ा के संग एक हीन के तीसरा भाग; अऊ हर एक मेढ़ा-पीला संग एक हीन के चौथा भाग पेय-बलिदान के रूप म चघाय जावय। येह साल भर हर नवां चंदा के दिन चघाय जानेवाला मासिक होम-बलिदान अय। ");
INSERT INTO hne_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","नियमित होम-बलिदान के संग येकर पेय-बलिदान के अलावा एक ठन बोकरा पाप-बलिदान के रूप म यहोवा ला चघाय जावय। ");
INSERT INTO hne_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘हर साल पहिला महिना के चौदहवां दिन यहोवा के फसह माने जावय। ");
INSERT INTO hne_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ये महिना के पंदरहवां दिन एक तिहार होवय; काबरकि सात दिन बिगर खमीर के बने रोटी खावव। ");
INSERT INTO hne_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","पहिली दिन एक पबितर सभा करव अऊ ओ दिन तुमन रोजमर्रा के काम झन करव। ");
INSERT INTO hne_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","यहोवा ला एक जेवन-बलिदान चघावव, जेह दू ठन बछवा, एक ठन मेढ़ा-पीला अऊ एक-एक साल के सात ठन निरदोस मेढ़ा-पीला के होम-बलिदान ले बने होवय। ");
INSERT INTO hne_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","हर एक बछवा के चढ़ावा के संग तेल ले सने उत्तम पीसान के एक एपा के तीन-दसवां भाग; मेढ़ा के संग दू-दसवां भाग एक अन्न-बलिदान के रूप म चघावव; ");
INSERT INTO hne_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","अऊ सात मेढ़ा-पीला के हर एक के संग एक-दसवां भाग। ");
INSERT INTO hne_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","अपन पछताप करे बर एक ठन बोकरा पाप-बलिदान के रूप म मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","हर बिहनियां के होम-बलिदान के अलावा येमन ला चघावव। ");
INSERT INTO hne_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ये किसम ले हर एक दिन सात दिन तक यहोवा ला एक महकत सुख-देवइया जेवन-बलिदान चघावव; नियमित होम-बलिदान अऊ येकर पेय-बलिदान के अलावा ये बलिदान चघाय जावव। ");
INSERT INTO hne_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","सातवां दिन एक पबितर सभा करव अऊ ओ दिन रोजमर्रा के काम झन करव। ");
INSERT INTO hne_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘पहिली-फसल के दिन, जब तुमन हप्तामन के तिहार के समय नवां अनाज के बलिदान यहोवा ला चघावव, त एक पबितर सभा करव अऊ कोनो रोजमर्रा के काम झन करव। ");
INSERT INTO hne_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","दू ठन बछवा, एक ठन मेढ़ा अऊ एक-एक बछर के सात ठन निरदोस मेढ़ा-पीला के एक होम-बलिदान यहोवा बर महकत सुख-देवइया चढ़ावा के रूप म चघावव। ");
INSERT INTO hne_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","हर एक बछवा के चढ़ावा संग तेल ले सने उत्तम पीसान के एक एपा के तीन-दसवां भाग; मेढ़ा के संग दू-दसवां भाग; ");
INSERT INTO hne_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","अऊ हर सात मेढ़ा-पीला के संग एक-दसवां भाग। ");
INSERT INTO hne_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","अपन पछताप करे बर एक ठन बोकरा मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","नियमित होम-बलिदान अऊ येकर अन्न-बलिदान के अलावा येमन ला एक संग ओमन के पेय-बलिदान के संग चघावव। ये बात के धियान रहय कि पसुमन निरदोस होवंय। ");
INSERT INTO hne_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘हर साल सातवां महिना के पहिला दिन एक पबितर सभा करव अऊ ओ दिन नियमित काम झन करव। येह तुम्हर बर तुरही बजाय के दिन अय। ");
INSERT INTO hne_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","यहोवा ला एक महकत सुख-देवइया चढ़ावा के रूप म एक ठन बछवा, एक ठन मेढ़ा अऊ एक-एक साल के सात ठन निरदोस मेढ़ा-पीला के होम-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","बछवा के चढ़ावा के संग जैतून तेल ले सने उत्तम पीसान के एक एपा के तीन-दसवां भाग; मेढ़ा के संग दू-दसवां भाग; ");
INSERT INTO hne_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","अऊ हर सातों मेढ़ा-पीला संग एक-दसवां भाग चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","अपन पछताप करे बर ओमा पाप-बलिदान बर एक ठन बोकरा घलो मिला लेवव। ");
INSERT INTO hne_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","बताय गे मासिक अऊ हर दिन के होम-बलिदान के संग ओमन के अन्न-बलिदान अऊ पेय-बलिदान के अलावा ये बलिदानमन ला चघाय जावय। येमन यहोवा ला एक महकत सुख-देवइया चघाय गे जेवन-बलिदान अंय। ");
INSERT INTO hne_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘ये सातवां महिना के दसवां दिन एक पबितर सभा करव। तुमन अपनआप के इनकार करव अऊ काम झन करव। ");
INSERT INTO hne_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","यहोवा ला एक महकत सुख-देवइया चढ़ावा के रूप म एक ठन बछवा, एक ठन मेढ़ा अऊ एक-एक साल के सात ठन निरदोस मेढ़ा-पीला के होम-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","बछवा के चढ़ावा संग तेल ले सने उत्तम पीसान के एक एपा के तीन-दसवां भाग; मेढ़ा के संग दू-दसवां भाग; ");
INSERT INTO hne_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","अऊ सातों मेढ़ा-पीलामन के हर एक के संग एक-दसवां भाग चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","पछताप करे बर पाप-बलिदान अऊ नियमित होम-बलिदान के संग येकर अन्न-बलिदान, अऊ ओमन के पेय-बलिदान के अलावा, पाप-बलिदान के रूप म एक ठन बोकरा मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘सातवां महिना के पंदरहवां दिन एक पबितर सभा करव अऊ ओ दिन नियमित काम झन करव। सात दिन तक यहोवा बर तिहार मनावव। ");
INSERT INTO hne_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","यहोवा ला एक महकत सुख-देवइया चढ़ावा के रूप म एक जेवन-बलिदान चघावव, जेमा तेरह ठन बछवा, दू ठन मेढ़ा अऊ एक-एक साल के चौदह ठन निरदोस मेढ़ा-पीला होम-बलिदान के होवंय। ");
INSERT INTO hne_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","तेरह बछवा म ले हर एक बछवा के चढ़ावा संग तेल ले सने उत्तम पीसान के एक एपा के तीन-दसवां भाग; दूनों मेढ़ा म ले हर एक के संग दू-दसवां भाग; ");
INSERT INTO hne_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","अऊ चौदह मेढ़ा-पीलामन के हर एक के संग म एक-दसवां भाग चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","नियमित होम-बलिदान के संग येकर अन्न-बलिदान अऊ पेय-बलिदान के अलावा, एक ठन बोकरा पाप-बलिदान के रूप म मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘दूसरा दिन बारह ठन बछवा, दू ठन मेढ़ा अऊ एक-एक साल के चौदह ठन निरदोस मेढ़ा-पीला चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","बछवा, मेढ़ा अऊ मेढ़ा-पीला के संग बताय गे संखिया के मुताबिक ओमन के अन्न-बलिदान अऊ पेय-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","नियमित होम-बलिदान के संग येकर अन्न-बलिदान, अऊ ओमन के पेय-बलिदान के अलावा, एक ठन बोकरा पाप-बलिदान के रूप म मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘तीसरा दिन गियारह ठन बछवा, दू ठन मेढ़ा अऊ एक-एक साल के चौदह ठन निरदोस मेढ़ा-पीला चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","बछवा, मेढ़ा अऊ मेढ़ा-पीला के संग बताय गे संखिया के मुताबिक ओमन के अन्न-बलिदान अऊ पेय-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","नियमित होम-बलिदान के संग येकर अन्न-बलिदान अऊ पेय-बलिदान के अलावा, एक ठन बोकरा पाप-बलिदान के रूप म मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘चौथा दिन दस ठन बछवा, दू ठन मेढ़ा अऊ एक-एक साल के चौदह ठन निरदोस मेढ़ा-पीला चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","बछवा, मेढ़ा अऊ मेढ़ा-पीला के संग बताय गे संखिया के मुताबिक ओमन के अन्न-बलिदान अऊ पेय-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","नियमित होम-बलिदान के संग येकर अन्न-बलिदान अऊ पेय-बलिदान के अलावा, एक ठन बोकरा पाप-बलिदान के रूप म मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘पांचवां दिन नौ ठन बछवा, दू ठन मेढ़ा अऊ एक-एक साल के चौदह ठन निरदोस मेढ़ा-पीला चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","बछवा, मेढ़ा अऊ मेढ़ा-पीला के संग बताय गे संखिया के मुताबिक ओमन के अन्न-बलिदान अऊ पेय-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","नियमित होम-बलिदान के संग येकर अन्न-बलिदान अऊ पेय-बलिदान के अलावा, एक ठन बोकरा पाप-बलिदान के रूप म मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘छठवां दिन आठ ठन बछवा, दू ठन मेढ़ा अऊ एक-एक साल के चौदह ठन निरदोस मेढ़ा-पीला चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","बछवा, मेढ़ा अऊ मेढ़ा-पीला के संग बताय गे संखिया के मुताबिक ओमन के अन्न-बलिदान अऊ पेय-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","नियमित होम-बलिदान के संग येकर अन्न-बलिदान अऊ पेय-बलिदान के अलावा, एक ठन बोकरा पाप-बलिदान के रूप म मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘सातवां दिन सात ठन बछवा, दू ठन मेढ़ा अऊ एक-एक साल के चौदह ठन निरदोस मेढ़ा-पीला चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","बछवा, मेढ़ा अऊ मेढ़ा-पीला के संग बताय गे संखिया के मुताबिक ओमन के अन्न-बलिदान अऊ पेय-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","नियमित होम-बलिदान के संग येकर अन्न-बलिदान अऊ पेय-बलिदान के अलावा, एक ठन बोकरा पाप-बलिदान के रूप म मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘आठवां दिन एक बिसेस समापन सभा करव अऊ ओ दिन नियमित काम झन करव। ");
INSERT INTO hne_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","यहोवा ला एक महकत सुख-देवइया चढ़ावा के रूप म एक जेवन-बलिदान चघावव, जेमा एक ठन बछवा, एक ठन मेढ़ा अऊ एक-एक साल के सात ठन निरदोस मेढ़ा-पीला के एक होम-बलिदान होवय। ");
INSERT INTO hne_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","बछवा, मेढ़ा अऊ मेढ़ा-पीला के संग बताय गे संखिया के मुताबिक ओमन के अन्न-बलिदान अऊ पेय-बलिदान चघावव। ");
INSERT INTO hne_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","नियमित होम-बलिदान के संग येकर अन्न-बलिदान अऊ पेय-बलिदान के अलावा, एक ठन बोकरा पाप-बलिदान के रूप म मिलावव। ");
INSERT INTO hne_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘अपन मन्नत अऊ अपन स्वेच्छा-बलिदान के चढ़ावा के अलावा, तुम्हर ठहिराय गे तिहार म यहोवा ला ये घलो चघावव: तुम्हर होम-बलिदान, अन्न-बलिदान, पेय-बलिदान अऊ मेल-बलिदान।’ ” ");
INSERT INTO hne_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","यहोवा के जम्मो हुकूम ला मूसा ह इसरायलीमन ला बता दीस। ");
INSERT INTO hne_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","मूसा ह इसरायल के गोत्रमन के मुखियामन ला कहिस: “यहोवा के ये हुकूम अय: ");
INSERT INTO hne_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","जब कोनो मनखे यहोवा के मन्नत मानथे या अपनआप परन करके सपथ खावय, त ओह अपन बचन ले झन मुकरय, पर अपन कहे हर बात ला पूरा करय। ");
INSERT INTO hne_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“जब कोनो जवान नोनी अपन ददा के घर म रहत यहोवा के मन्नत मानथे या अपनआप कोनो परन करथे ");
INSERT INTO hne_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","अऊ ओकर ददा ओकर मन्नत या परन ला सुनथे, पर ओला कुछू नइं कहय, त ओ जवान नोनी के जम्मो मन्नत अऊ ओकर करे गे हर परन ह लागू होथे। ");
INSERT INTO hne_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","पर यदि ओकर ददा ह ओकर मन्नत या ओकर बचन देवई ला सुनके ओला मना कर देथे, त ओकर दुवारा माने गय कोनो मन्नत या परन ह लागू नइं होवय; यहोवा ह ओला छोंड़ दीही, काबरकि ओकर ददा ह ओला मना कर दे हवय। ");
INSERT INTO hne_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“यदि ओह कोनो परन करे के बाद या अपनआप बिगर सोचे-बिचारे कोनो मन्नत के बाद बिहाव कर लेथे ");
INSERT INTO hne_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","अऊ जब ओकर घरवाला ह येकर बारे म सुनथे, पर ओला कुछू नइं कहय, त फेर ओकर मन्नत या अपनआप करे गे परन करई ह लागू होथे। ");
INSERT INTO hne_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","पर यदि ओकर घरवाला ह मन्नत के बारे म सुनके ओला मना कर देथे, त ओह ओकर घरवाली के परन या बिगर सोचे-बिचारे अपनआप करे गे मन्नत ला खतम कर देथे, अऊ यहोवा ह ओला छेमा कर दीही। ");
INSERT INTO hne_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“यदि बिधवा या तलाकसुदा माईलोगन कोनो मन्नत मानथे या बचन देथे, त ओह ओकर ले बंधे रहिथे। ");
INSERT INTO hne_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“यदि कोनो माईलोगन अपन घरवाला के संग रहत कोनो मन्नत मानथे या सपथ खाके कोनो परन करथे ");
INSERT INTO hne_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","अऊ ओकर घरवाला येला सुनके ओला कुछू नइं कहय अऊ ओला मना नइं करय, त ओकर माने गे जम्मो मन्नत या ओकर दुवारा करे गे जम्मो परन लागू होथे। ");
INSERT INTO hne_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","पर यदि ओकर घरवाला ह ओ मन्नत या बचन ला सुनके खतम कर देथे, तब ओ माईलोगन के दुवारा माने गे मन्नत या बचन लागू नइं होवय। ओकर घरवाला ह ओमन ला रद्द कर दे हवय, एकरसेति यहोवा ह ओला छेमा कर दीही। ");
INSERT INTO hne_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ओकर घरवाला ह ओकर दुवारा माने गे कोनो मन्नत या करे गय सपथ ला लागू कर सकथे या ओला खतम घलो कर सकथे। ");
INSERT INTO hne_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","पर यदि ओकर घरवाला दिन-प्रतिदिन ओकर बारे म ओला कुछू नइं कहय, त येकर मतलब ये अय कि ओह ओकर दुवारा करे गय जम्मो मन्नत या परन ला सहमती देथे। ओह सुनके ओला कुछू नइं कहे के दुवारा ओकर मन्नत या बचन बर सहमती देथे। ");
INSERT INTO hne_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","पर यदि ओह ओ मन्नत या बचन ला सुनके कुछू समय बाद ओमन ला खतम कर देथे, तब ओह अपन घरवाली के दोस के भार उठाही।” ");
INSERT INTO hne_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","एक मनखे अऊ ओकर घरवाली के बीच, अऊ एक ददा अऊ ओकर कुंवारी बेटी के बीच जऊन ह अभी भी घर म रहिथे, ओमन के संबंध के बारे म येमन बिधि अंय, जेला यहोवा ह मूसा ला दीस। ");
INSERT INTO hne_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“इसरायलीमन बर मिदयानीमन ले बदला ले। ओकर बाद, तेंह मरके अपन पुरखामन संग हमेसा बर मिल जाबे।” ");
INSERT INTO hne_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","तब मूसा ह मनखेमन ला कहिस, “मिदयानीमन के बिरूध लड़ई करे बर अपन कुछू मनखेमन ला तियार होय बर कहव, ताकि ओमन मिदयानीमन ले यहोवा के बदला लेवंय। ");
INSERT INTO hne_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","इसरायल के हर गोत्र म ले एक-एक हजार पुरूसमन ला लड़ई म भेजव।” ");
INSERT INTO hne_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","हर गोत्र म ले एक-एक हजार, कुल बारह हजार हथियारबंद पुरूस लड़ई बर इसरायल के बंस ले तियार होईन। ");
INSERT INTO hne_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","मूसा ह हर गोत्र म ले एक-एक हजार पुरूस लड़ई म भेजिस; संग म एलिआजर पुरोहित के बेटा पीनहास ला पठोईस, जऊन ह अपन संग पबितर-स्थान के चीज अऊ फूंकके इसारा करे बर तुरहीमन ला धरे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","यहोवा के मूसा ला दिये हुकूम के मुताबिक ओमन मिदयानीमन के बिरूध लड़के जम्मो मिदयानी पुरूस ला मार डारिन। ");
INSERT INTO hne_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","मारे गे मनखेमन के बीच मिदयानीमन के पांच राजा—एवी, रेकेम, सूर, हूर अऊ रेबा रिहिन। ओमन बेओर के बेटा बिलाम ला घलो तलवार ले मार डारिन। ");
INSERT INTO hne_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इसरायलीमन मिदयानी माईलोगन अऊ लइकामन ला बंदी बना लीन अऊ मिदयानीमन के जम्मो गरूवा-बईला, भेड़-बकरी के झुंड अऊ सामान ला लूट लीन। ");
INSERT INTO hne_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ओमन मिदयानीमन के बसे जम्मो नगर अऊ ओमन के जम्मो सिविरमन ला नास कर दीन। ");
INSERT INTO hne_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ओमन जम्मो लूट के सामान, मनखे अऊ पसुमन ला ले लीन, ");
INSERT INTO hne_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","अऊ बंदीमन ला अऊ लूट के सामान ला मूसा अऊ एलिआजर पुरोहित अऊ इसरायली सभा करा मोआब के मैदान म डारे ओमन के डेरा म ले आईन, जऊन ह यरीहो के ओ पार यरदन नदी के तीर म रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","मूसा, एलिआजर पुरोहित अऊ समाज के जम्मो अगुवामन ओमन ले मिले बर सिविर के बाहिर गीन। ");
INSERT INTO hne_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","मूसा ह लड़ई ले लहुंटे सेना के ओ अधिकारीमन ले नराज होईस, जेमन हजारों अऊ सैकड़ों सैनिक के ऊपर सेनापति ठहिराय गे रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","मूसा ह ओमन ले पुछिस, “का तुमन जम्मो माईलोगन ला जीयत छोंड़ दे हव?” ");
INSERT INTO hne_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","येमन ओ माईलोगन रिहिन, जेमन पेओर के घटना म बिलाम के सलाह मानिन अऊ यहोवा के संग बिसवासघात करे बर इसरायली समाज ला बहकाईन, जेकर ले यहोवा के मनखेमन ऊपर एक महामारी फईलिस। ");
INSERT INTO hne_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","अब जम्मो लड़कामन ला मार डारव। अऊ हर ओ माईलोगन ला मार डारव, जऊन ह पुरूस के संग सुते हवय, ");
INSERT INTO hne_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","पर हर ओ लड़की ला अपन बर बचाके रखव, जेह पुरूस के संग कभू नइं सुते हे। ");
INSERT INTO hne_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“जऊन मनखे ह कोनो मनखे ला मार डारे हे या कोनो मारे गे मनखे ला छुए हे, त ओ मनखे ह सात दिन तक डेरा ले बाहिर रहय। तीसरा अऊ सातवां दिन तुमन अपनआप ला अऊ अपन बंदीमन ला सुध करव। ");
INSERT INTO hne_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","हर एक कपड़ा अऊ संग म चाम के बने हर चीज ला सुध करव, बोकरा के रूआं हो या लकड़ी।” ");
INSERT INTO hne_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","तब एलिआजर पुरोहित ह ओ सैनिकमन ला कहिस, जऊन मन लड़ई म गे रिहिन, “यहोवा के दुवारा मूसा ला दिये गे कानून के मुताबिक ये काम करे के जरूरत हे: ");
INSERT INTO hne_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","सोन, चांदी, कांसा, लोहा, टीन, सीसा ");
INSERT INTO hne_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","अऊ जऊन कुछू चीज आगी म नइं जलय, ओमन ला आगी म डालके निकालव, अऊ तब ये चीजमन सुध हो जाहीं। पर येमन ला सुध करइया पानी ले घलो सुध करना जरूरी ए। अऊ जऊन कुछू चीज आगी म ठहर नइं सकय, ओला ओ पानी म डालके निकालव। ");
INSERT INTO hne_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","सातवां दिन अपन कपड़ामन ला धोवव अऊ तुमन सुध हो जाहू। तब तुमन डेरा म आ सकत हव।” ");
INSERT INTO hne_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“तें अऊ एलिआजर पुरोहित अऊ समाज के परिवार के मुखियामन बंदी बनाय गे जम्मो मनखे अऊ पसुमन के गनती करव। ");
INSERT INTO hne_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","लूट के सामान ला लड़ई म गय सैनिक अऊ समाज के बाकि मनखेमन के बीच बरोबर-बरोबर बांट दव। ");
INSERT INTO hne_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","जऊन सैनिकमन लड़ई म गे रिहिन, ओमा ले हर पांच सौ के पाछू एक झन ला यहोवा बर राजकर के रूप म अलग रखव; चाहे ओमन मनखे, पसु, गदहा या भेड़मन होवंय। ");
INSERT INTO hne_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ओमन के आधा भाग म ले ये राजकर ला लेय ले अऊ येला यहोवा बर एलिआजर पुरोहित ला भेंट देय दे। ");
INSERT INTO hne_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","इसरायलीमन के आधा भाग म ले, हर पचास के पाछू एक झन ला अलग रख; चाहे ओमन मनखे, पसु, गदहा, भेड़ या आने पसुमन होवंय। ये भाग ला ओ लेवीमन ला देय दे, जेमन के ऊपर यहोवा के पबितर-तम्बू के देखरेख के जिम्मेदारी हवय।” ");
INSERT INTO hne_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","मूसा अऊ एलिआजर पुरोहित मूसा ला दिये गय यहोवा के हुकूम के मुताबिक करिन। ");
INSERT INTO hne_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","सैनिकमन के दुवारा लूटे गय सामान म ले ये बचे रिहिस 6,75,000 भेड़, ");
INSERT INTO hne_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 पसु ");
INSERT INTO hne_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 गदहा ");
INSERT INTO hne_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","32,000 माईलोगन जेमन कभू कोनो पुरूस संग नइं सुते रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","जेमन लड़ई म गे रिहिन, ओमन के आधा भाग ये रिहिस: 3,37,500 भेड़, ");
INSERT INTO hne_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","जेमा ले यहोवा के राजकर 675 ठन भेड़ रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000 पसु, जेमा ले यहोवा के राजकर 72 ठन पसु रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500 गदहा, जेमा ले यहोवा के राजकर 61 ठन गदहा रिहिन; ");
INSERT INTO hne_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 मनखे, जेमा यहोवा बर ठहिराय राजकर के रूप म 32 झन मनखे रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","मूसा ह एलिआजर पुरोहित ला यहोवा के बांटा के रूप म राजकर दीस, जइसे कि यहोवा ह मूसा ला हुकूम दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","मूसा ह सैनिकमन ले लूट के आधा सामान ला इसरायलीमन बर अलग रखिस; ");
INSERT INTO hne_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","समाज के आधा भाग 3,37,500 भेड़, ");
INSERT INTO hne_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 पसु, ");
INSERT INTO hne_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 गदहा, ");
INSERT INTO hne_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","अऊ 16,000 मनखे। ");
INSERT INTO hne_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","इसरायलीमन के आधा भाग म ले, मूसा ह हर पचास मनखे अऊ पचास पसु के पाछू एक-एक मनखे अऊ पसु ला अलग करिस, जइसे कि यहोवा ह ओला हुकूम दे रिहिस, अऊ ओला लेवीमन ला दे दीस, जेमन यहोवा के पबितर-तम्बू के देखरेख करत रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","तब सेना के हर दल के ऊपर ठहिराय गय अधिकारीमन—हजारों सैनिकमन अऊ सैकड़ों सैनिकमन ऊपर ठहिराय गय सेनापतिमन मूसा करा गीन ");
INSERT INTO hne_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","अऊ मूसा ला कहिन, “तोर सेवकमन हमर अधीन रहे सैनिकमन के गनती करे हवंय, अऊ ओमा ले एको झन भी नइं छूटे हवंय। ");
INSERT INTO hne_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","हमन म ले हर एक जन सोन के जऊन चीजमन ला अपन अधिकार म ले हन—बाजूबंद, कंगन, मुंदरी, कान के बाली अऊ माला—येला हमन यहोवा बर चढ़ावा के रूप म लाने हन, ताकि यहोवा के आघू म हमन पछताप कर सकन।” ");
INSERT INTO hne_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","तब मूसा अऊ एलिआजर पुरोहित ओमन ले तरासके बनाय गे सोन के जम्मो चीजमन ला ले लीन। ");
INSERT INTO hne_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","हजारों सैनिक अऊ सैकड़ों सैनिक के सेनापति दुवारा दिये गय जम्मो सोन ला, मूसा अऊ एलिआजर यहोवा ला भेंट म चघाईन, ओकर वजन 16,750 सेकेल रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","हर एक सैनिक अपन बर लूट के सामान लेय ले रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","मूसा अऊ एलिआजर पुरोहित हजारों अऊ सैकड़ों सैनिकमन के सेनापति ले ओ सोन ला स्वीकार कर लीन अऊ ओ सोन ला मिलापवाला तम्बू म ले आईन, ताकि ओह यहोवा के आघू म इसरायलीमन बर एक सुरता करइया चीज ठहिरे। ");
INSERT INTO hne_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","रूबेनी अऊ गादीमन करा गरूवा-बईला अऊ भेड़-बकरी के बड़े-बड़े झुंड रिहिन। जब ओमन देखिन कि याजेर अऊ गिलाद पसु-धन बर उचित छेत्र अंय, ");
INSERT INTO hne_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","त ओमन मूसा अऊ एलिआजर पुरोहित अऊ समाज के अगुवामन करा आईन अऊ कहिन, ");
INSERT INTO hne_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“अतारोत, दीबोन, याजेर, निमराह, हेसबोन, एलाले, सबाम, नबो अऊ बोन नगरमन ला ");
INSERT INTO hne_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","यहोवा ह इसरायली समाज के मनखेमन के आघू म जीत लीस; ये नगरमन पसु-धन बर सही अंय, अऊ तुम्हर सेवकमन करा पसु-धन हवय। ");
INSERT INTO hne_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","यदि तुम्हर किरपा के नजर हमर ऊपर हवय, त ये देस ला तुम्हर सेवकमन के अधिकार म दिये जावय। हमन ला यरदन नदी के ओ पार झन जावन दव।” ");
INSERT INTO hne_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","तब मूसा ह गादी अऊ रूबेनीमन ला कहिस, “का तुम्हर संगी इसरायलीमन लड़ई करे बर जावंय, जब तुमन इहां बईठे रहव? ");
INSERT INTO hne_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","तुमन काबर इसरायलीमन ला यरदन के ओ पार के देस म जाय बर हतास करत हव, जेला कि यहोवा ह ओमन ला दे हवय? ");
INSERT INTO hne_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","तुम्हर पुरखामन घलो अइसने ही करिन, जब मेंह ओमन ला कादेस-बरने ले ओ देस ला देखे बर पठोंय। ");
INSERT INTO hne_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","जब ओमन एसकोल के घाटी म हबरिन अऊ उहां ले ओ देस ला देखिन, त ओमन इसरायलीमन ला ओ देस म जाय बर हतास करिन, जेला यहोवा ह ओमन ला दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","तब ओ दिन यहोवा के कोप ह भड़किस अऊ ओह ये सपथ खाईस: ");
INSERT INTO hne_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘काबरकि ओमन पूरा मन से मोर पाछू नइं चलिन, एकरसेति मिसर ले निकले के बेरा जतेक झन बीस साल या ओकर ले जादा उमर के रिहिन, ओमा के कोनो भी ओ देस ला देखे नइं सकहीं, जेला देय के परतिगियां मेंह अब्राहम, इसहाक अऊ याकूब ले सपथ खाके करे रहेंव— ");
INSERT INTO hne_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","सिरिप कनजी यपुन्ने के बेटा कालेब अऊ नून के बेटा यहोसू ही ओ देस ला देखे सकहीं, काबरकि ओमन पूरा मन से यहोवा के पाछू चले हवंय।’ ");
INSERT INTO hne_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","त यहोवा के कोप इसरायल ऊपर भड़किस अऊ ओह ओमन ला सुन्ना जगह म चालीस साल तक भटकाईस, जब तक कि ओ पूरा पीढ़ी खतम नइं हो गीस, जेमन ओकर नजर म दुस्ट काम करे रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“अऊ तुमन इहां, पापीमन के संतान, अपन पुरखामन के जगह म खड़े हव अऊ इसरायल बर यहोवा ला अऊ गुस्सा देवात हव। ");
INSERT INTO hne_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","यदि तुमन ओकर पाछू चलई बंद कर दूहू, त ओह फेर ये जम्मो मनखेमन ला सुन्ना जगह म छोंड़ दीही, अऊ तुमन ओमन के बिनास के कारन होहू।” ");
INSERT INTO hne_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","तब गादी अऊ रूबेनीमन मूसा करा आके कहिन, “हमन इहां अपन पसुमन बर थान अऊ हमर माईलोगन अऊ लइकामन बर सहर बसाय चाहत हन। ");
INSERT INTO hne_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","पर हमन खुद लड़ई बर हथियार धरबो अऊ इसरायलीमन के आघू-आघू जाबो, जब तक कि हमन ओमन ला ओमन के जगह म अमरा नइं देबो। इही दौरान हमर माईलोगन अऊ लइकामन ये देस के निवासीमन ले बचे बर गढ़वाले सहर म रहिहीं। ");
INSERT INTO hne_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","हमन तब तक अपन घर नइं लहुंटन, जब तक कि हर एक इसरायली अपन उत्तराधिकार ला नइं पा लीही। ");
INSERT INTO hne_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","हमन यरदन के ओ पार ओमन के संग कोनो उत्तराधिकार नइं लेवन, काबरकि हमर उत्तराधिकार हमन ला यरदन के पूरब कोति मिल गे हवय।” ");
INSERT INTO hne_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","तब मूसा ह ओमन ला कहिस, “यदि तुमन ये करहू—यदि तुमन खुद यहोवा कोति ले लड़ई बर हथियार धरहू ");
INSERT INTO hne_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","अऊ यदि तुमन जम्मो, जऊन मन हथियार धरहू अऊ परभू के आघू यरदन के ओ पार जाहू अऊ यहोवा ह अपन आघू ले अपन बईरीमन ला निकाल दीही— ");
INSERT INTO hne_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","तब जब देस ह यहोवा के आघू म जीत लिये जाही, त तुमन लहुंट सकत हव अऊ यहोवा बर अऊ अपन संगी इसरायलीमन बर अपन जिम्मेदारी ले छूट सकत हव। अऊ ये देस ह यहोवा के आघू म तुम्हर अधिकार म हो जाही। ");
INSERT INTO hne_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“पर यदि तुमन ये काम करे म असफल होहू, त तुमन यहोवा के बिरूध पाप करहू, अऊ तुमन ये बात ला खचित जान लव कि तुमन ला तुम्हर पाप लगही। ");
INSERT INTO hne_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","अपन माईलोगन अऊ लइकामन बर सहर अऊ अपन पसुमन बर थान बनावव, अऊ अपन करे गे परतिगियां ला पूरा करव।” ");
INSERT INTO hne_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","गादी अऊ रूबेनीमन मूसा ला कहिन, “हमन तोर सेवकमन, जइसे हमर मालिक ह हुकूम देवत हे, वइसे करबो। ");
INSERT INTO hne_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","हमर लइका अऊ घरवाली, हमर गरूवा-बईला अऊ भेड़-बकरी के झुंड इहां गिलाद के सहरमन म रहिहीं। ");
INSERT INTO hne_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","पर तोर सेवकमन, हर ओ मनखे जऊन ह लड़ई बर हथियार धरे हवय, यहोवा के आघू म लड़ई करे बर ओ पार जाही, जइसे कि हमर मालिक ह कहत हे।” ");
INSERT INTO hne_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","तब मूसा ह ओमन के बारे म एलिआजर पुरोहित अऊ नून के बेटा यहोसू अऊ इसरायली गोत्र के परिवार के मुखियामन ला हुकूम दीस। ");
INSERT INTO hne_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","मूसा ह ओमन ला कहिस, “यदि गादी अऊ रूबेनीमन के लड़ई बर हथियार धरे हर एक पुरूस यहोवा के आघू म तुम्हर संग यरदन के ओ पार जाथें, अऊ तब जब ओ देस ह तुम्हर अधिकार म आ जाथे, त तुमन गिलाद के देस ला ओमन के अधिकार म दे दूहू। ");
INSERT INTO hne_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","पर यदि ओमन हथियार धरके तुम्हर संग ओ पार नइं जाहीं, त ओमन ला कनान म ही अपन भाग स्वीकार करना पड़ही।” ");
INSERT INTO hne_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","गादी अऊ रूबेनीमन जबाब दीन, “तोर सेवकमन वइसने ही करहीं, जइसने यहोवा ह कहे हवय। ");
INSERT INTO hne_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","हमन हथियार धरके यहोवा के आघू म ओ पार कनान देस म जाबो, पर उत्तराधिकार के रूप म हमर संपत्ति यरदन के इही पार रहय।” ");
INSERT INTO hne_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","तब मूसा ह गाद, रूबेन अऊ यूसुफ के बेटा मनस्से के आधा गोत्र ला अमोरीमन के राजा सीहोन के राज अऊ बासान के राजा ओग के राज ला दे दीस—पूरा देस, येकर सहरमन अऊ ओमन के चारों कोति के इलाका ला दे दीस। ");
INSERT INTO hne_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","गादीमन दीबोन, अतारोत, अरोएर, ");
INSERT INTO hne_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अतरोत-सोपान, याजेर, योगबहा, ");
INSERT INTO hne_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बेत-निमरा अऊ बेत-हारान ला गढ़वाले नगर बना दीन, अऊ अपन पसुमन बर थान बनाईन। ");
INSERT INTO hne_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","अऊ रूबेनीमन हेसबोन, एलाले, अऊ किरयातैम, ");
INSERT INTO hne_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","अऊ संग म नबो अऊ बाल-मेओन (ये नांवमन ला बदल दिये गीस) अऊ सिबमा ला फेर बनाईन। ओमन फेर बनाय गे सहरमन के नांव रखिन। ");
INSERT INTO hne_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","मनस्से के बेटा माकीर के संतानमन गिलाद जाके ओला अपन कब्जा म कर लीन अऊ जऊन अमोरीमन उहां रहत रिहिन, ओमन ला भगा दीन। ");
INSERT INTO hne_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","तब मूसा ह मनस्से के संतान माकीर ला गिलाद के इलाका दे दीस, अऊ ओमन उहां बस गीन। ");
INSERT INTO hne_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","मनस्से के एक संतान याईर ह गिलाद के नगरमन ऊपर कब्जा कर लीस अऊ ओमन के नांव हव्वोत-याईर रखिस। ");
INSERT INTO hne_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","अऊ नोबह ह कनात अऊ ओकर आसपास के बस्तीमन ऊपर कब्जा कर लीस अऊ ओला अपन ही नांव नोबह दीस। ");
INSERT INTO hne_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","जब इसरायलीमन मूसा अऊ हारून के अगुवई म दल बना-बनाके मिसर देस ले बाहिर निकलिन, त येमन ओमन के यातरा के पड़ाव रिहिन। ");
INSERT INTO hne_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","यहोवा के हुकूम ले मूसा ह ओमन के यातरा के पड़ावमन के लेखा रखिस। पड़ावमन के मुताबिक येह ओमन के यातरा रिहिस: ");
INSERT INTO hne_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","पहिला महिना के पंदरहवां दिन, याने कि फसह तिहार के बाद दूसर दिन इसरायलीमन रामसेस सहर ले आघू बढ़िन। ओमन जम्मो मिसरीमन के देखत म बड़े निडरता से निकलिन; ");
INSERT INTO hne_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ओ समय मिसरीमन अपन पहिलांतमन ला माटी देवत रिहिन, जेमन ला यहोवा ह मार डारे रिहिस; काबरकि यहोवा ह ओमन के देवतामन ला दंड देय रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","इसरायलीमन रामसेस ले चलके सुक्कोत नांव के जगह म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","फेर सुक्कोत ले आघू बढ़के एताम म डेरा डालिन, जऊन ह सुन्ना जगह के तीर म हवय। ");
INSERT INTO hne_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ओमन एताम ले पाछू लहुंटके पी-हाहीरोत गीन, जऊन ह बाल-सपोन के पूरब म हवय, अऊ उहां मिगदोल के लकठा म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","तब ओमन पी-हाहीरोत ले चलके समुंदर ले होवत सुन्ना जगह म आईन, अऊ एताम के सुन्ना जगह म तीन दिन के रसता तय करिन, अऊ मारा नांव के जगह म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ओमन मारा ले चलके एलीम म आईन, जिहां बारह ठन पानी के सोता अऊ सत्तर ठन खजूर के रूख रिहिन, अऊ ओमन उहां डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ओमन एलीम ले चलके लाल-समुंदर के तीर म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ओमन लाल-समुंदर ले चलके सीन के सुन्ना जगह म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","फेर ओमन सीन के सुन्ना जगह ले दोपका म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ओमन दोपका ले चलके आलूस म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","फेर ओमन आलूस ले चलके रपीदीम म डेरा डालिन, जिहां मनखेमन के पीये बर पानी नइं रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","तब ओमन रपीदीम ले चलके सीनय के सुन्ना जगह म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","फेर ओमन सीनय के सुन्ना जगह ले चलके किबरोत-हतावा म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","तब ओमन किबरोत-हतावा ले चलके हसेरोत म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","फेर ओमन हसेरोत ले चलके रितमा म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ओमन रितमा ले चलके रिम्मोन-पेरेस म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ओमन रिम्मोन-पेरेस ले चलके लिबना म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ओमन लिबना ले चलके रिस्सा म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ओमन रिस्सा ले चलके कहेलाता म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","तब ओमन कहेलाता ले चलके सेपेर पहाड़ करा डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","फेर ओमन सेपेर पहाड़ ले चलके हरादा म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","तब ओमन हरादा ले चलके मखेलोत म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","फेर ओमन मखेलोत ले चलके तहत म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","तब ओमन तहत ले चलके तेरह म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","फेर ओमन तेरह ले चलके मितका म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","तब ओमन मितका ले चलके हसमोना म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","फेर ओमन हसमोना ले चलके मोसेरोत म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","तब ओमन मोसेरोत ले चलके बेने-जाकन म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","फेर ओमन बेने-जाकन ले चलके होर-हग्गीदगाद म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","तब ओमन होर-हग्गीदगाद ले चलके योतबाता म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","फेर ओमन योतबाता ले चलके अबरोना म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ओमन अबरोना ले चलके एसियोन-गेबेर म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","फेर ओमन एसियोन-गेबेर ले चलके सीन के सुन्ना जगह कादेस म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","तब ओमन कादेस ले चलके एदोम के सीमना म होर पहाड़ करा डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","यहोवा के हुकूम ले हारून पुरोहित ह होर पहाड़ ऊपर गीस, जिहां ओह मर गीस; ओकर मिरतू इसरायलीमन के मिसर देस ले निकले के चालीसवां साल के पांचवां महिना के पहिला दिन होईस। ");
INSERT INTO hne_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","जब हारून के मिरतू होर पहाड़ म होईस, त ओकर उमर एक सौ तेईस साल रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","इही समय कनान के नेगेव म रहइया अराद के कनानी राजा ला पता चलिस कि इसरायलीमन आवत हें। ");
INSERT INTO hne_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","इसरायलीमन होर पहाड़ ले चलके सलमोना म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ओमन सलमोना ले चलके पुनोन म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ओमन पुनोन ले चलके ओबोत म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","फेर ओमन ओबोत ले चलके मोआब के सीमना म इये-अबारीम करा डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","फेर इये-अबारीम ले चलके दीबोन-गाद म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","फेर ओमन दीबोन-गाद ले चलके अलमोन-दिबलातैम म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","तब ओमन अलमोन-दिबलातैम ले चलके नबो के लकठा म अबारीम के पहाड़मन म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","फेर ओमन अबारीम के पहाड़मन ले चलके यरीहो के ओ पार यरदन नदी के तीर मोआब के मैदान म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","उहां ओमन यरदन नदी के तीर बेत-यसीमोत ले लेके आबेल-सित्तीम तक मोआब के मैदान म डेरा डालिन। ");
INSERT INTO hne_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","यरीहो के ओ पार यरदन नदी के तीर मोआब के मैदान म यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“इसरायलीमन ले बात कर अऊ ओमन ला कह: ‘जब तुमन यरदन नदी ला पार करके कनान देस म जावव, ");
INSERT INTO hne_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","त अपन आघू ले ओ देस के जम्मो निवासी ला भगा दव। ओमन के गढ़े, अऊ ढालके बनाय गय जम्मो मूरती ला नास कर दव, अऊ ओमन के जम्मो ऊंचहा जगहमन ला गिरा दव। ");
INSERT INTO hne_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ओ देस ला अपन अधिकार म ले लव अऊ उहां बस जावव, काबरकि मेंह ओ देस तुमन ला अधिकार करे बर दे हवंव। ");
INSERT INTO hne_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","अपन गोत्र के मुताबिक चिट्ठी निकालके ओ देस ला बांट लेवव। बड़े दल ला बड़े भाग अऊ छोटे दल ला छोटे भाग देवव। चिट्ठी के मुताबिक जऊन भाग ओमन ला मिलथे, ओह ओमन के होही। अपन पुरखा के गोत्रमन के मुताबिक येला बांटव। ");
INSERT INTO hne_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘पर यदि तुमन ओ देस के निवासीमन ला निकाल नइं सकव, त ओमन म ले जेमन ला तुमन रहे बर दूहू, ओमन तुम्हर आंखीमन म कचरा अऊ तुम्हर पंजरामन म कांटा सहीं हो जाहीं। ओमन तुम्हर बर ओ देस म समस्या खड़े करहीं, जिहां तुमन रहिहू। ");
INSERT INTO hne_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","अऊ मेंह तुम्हर संग वइसने करहूं, जइसने ओमन बर करे के ठाने हंव।’ ” ");
INSERT INTO hne_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“इसरायलीमन ला हुकूम देके कह: ‘जब तुमन कनान देस म जावव, त जऊन भुइयां तुमन ला उत्तराधिकार के रूप म दिये जाही, ओकर ये सीमना होवय: ");
INSERT INTO hne_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘तुम्हर दक्खिन कोति सीन के सुन्ना जगह के कुछू भाग घलो होही, जऊन ह एदोम के सीमना ए। तुम्हर दक्खिनी सीमना ह पूरब म मिरतू सागर के दक्खिनी छोर ले सुरू होही, ");
INSERT INTO hne_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","अऊ अकरबीम चढ़ई के दक्खिन के पार सीन कोति आही अऊ कादेस-बरने नगर के दक्खिन तक जाही। तब येह हाजार-अद्दार तक जाके असमोन तक जाही, ");
INSERT INTO hne_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","असमोन ले मुड़के मिसर के नरवा म जुड़ जाही अऊ भूमध्य सागर म खतम होही। ");
INSERT INTO hne_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","तुम्हर पछिमी सीमना ह भूमध्य सागर के किनारा होही। येह पछिम म तुम्हर सीमना होही। ");
INSERT INTO hne_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","अपन उत्तरी सीमना बर, भूमध्य सागर ले होर पहाड़ तक एक लकीर खींचव ");
INSERT INTO hne_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","अऊ होर पहाड़ ले लेबो-हमात सहर तक ये लकीर जाही। तब सीमना ह सेदाद नगर तक जाही, ");
INSERT INTO hne_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","अऊ जिपरोन तक बढ़के हसर-एनान करा खतम होही। येह उत्तर म तुम्हर सीमना होही। ");
INSERT INTO hne_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","अपन पूरब के सीमना बर, हसर-एनान ले सपाम तक एक लकीर खींचव। ");
INSERT INTO hne_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","सीमना ह सपाम ले खाल्हे ऐन के पूरब कोति रिबला तक जाही अऊ ढलान म बढ़त गलील समुंदर के पूरब तक जाही। ");
INSERT INTO hne_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","तब सीमना ह खाल्हे यरदन के तीरे-तीर जाही अऊ मिरतू सागर करा खतम होही। ");
INSERT INTO hne_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","मूसा ह इसरायलीमन ला हुकूम दीस: “चिट्ठी डारके ये देस ला बांटव, अऊ ओमन ला उत्तराधिकार के रूप म दे दव। यहोवा के हुकूम अय कि ये देस साढ़े नौ गोत्रमन ला दिये जावय, ");
INSERT INTO hne_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","काबरकि रूबेन के गोत्र, गाद के गोत्र अऊ मनस्से के आधा गोत्र के परिवारमन अपन उत्तराधिकार पा गे हवंय। ");
INSERT INTO hne_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ये ढाई गोत्र के मनखेमन सूरज निकले के दिसा म, यरीहो के ओ पार, यरदन के पूरब म अपन उत्तराधिकार पा गे हवंय।” ");
INSERT INTO hne_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","फेर यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“एलिआजर पुरोहित अऊ नून के बेटा यहोसू ओ मनखेमन के नांव अय, जेमन के ऊपर ये देस ला बांटके तुमन ला उत्तराधिकार म देय के जिम्मेदारी हवय। ");
INSERT INTO hne_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","अऊ हर एक गोत्र ले एक अगुवा ठहिरा, जेमन ये देस ला बांटे म मदद करहीं। ");
INSERT INTO hne_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“ओमन के नांव ये अय: “यहूदा के गोत्र ले, यपुन्ने के बेटा कालेब; ");
INSERT INTO hne_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","सिमोन के गोत्र ले, अमीहूद के बेटा समूएल; ");
INSERT INTO hne_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","बिनयामीन के गोत्र ले, किसलोन के बेटा एलीदाद; ");
INSERT INTO hne_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","दान के गोत्र ले, योगली के बेटा बुक्की ह अगुवा रिहिस; ");
INSERT INTO hne_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","यूसुफ के बेटा मनस्से के गोत्र ले, एपोद के बेटा हन्नीएल ह अगुवा रिहिस; ");
INSERT INTO hne_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","यूसुफ के बेटा एपरैम के गोत्र ले, सिपतान के बेटा कमूएल ह अगुवा रिहिस; ");
INSERT INTO hne_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","जबूलून के गोत्र ले, परनाक के बेटा एलीसापान ह अगुवा रिहिस; ");
INSERT INTO hne_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इस्साकार के गोत्र ले, अज्जान के बेटा पलतीएल ह अगुवा रिहिस; ");
INSERT INTO hne_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आसेर के गोत्र ले, सलोमी के बेटा अहीहूद ह अगुवा रिहिस; ");
INSERT INTO hne_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","अऊ नपताली के गोत्र ले, अमीहूद के बेटा पदहेल ह अगुवा रिहिस।” ");
INSERT INTO hne_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","येमन ओ मनखे अंय, जेमन ला यहोवा ह कनान देस म इसरायलीमन ला उत्तराधिकार बांटे के हुकूम दीस। ");
INSERT INTO hne_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","यरीहो के ओ पार, यरदन नदी के तीर, मोआब के मैदान म यहोवा ह मूसा ला कहिस, ");
INSERT INTO hne_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“इसरायलीमन ला हुकूम दे कि ओमन अपन उत्तराधिकार म पाय नगरमन ले कुछू नगर लेवीमन ला देवंय। अऊ ओमन ला नगर के चारों कोति के चरागन घलो देवंय। ");
INSERT INTO hne_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","तब ओमन करा रहे बर नगर अऊ गाय-बईला, भेड़-बकरी अऊ ओमन के आने जम्मो पसु बर चरागन होही। ");
INSERT INTO hne_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“नगरमन के चारों कोति जऊन चरागन तेंह लेवीमन ला देबे, ओ चरागनमन के फईलाव नगर के दीवार ले एक हजार क्यूबीट तक होवय। ");
INSERT INTO hne_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","नगर के बाहिर, पूरब कोति दू हजार क्यूबीट, दक्खिन कोति दू हजार क्यूबीट, पछिम कोति दू हजार क्यूबीट अऊ उत्तर कोति दू हजार क्यूबीट नापव अऊ नगर ह मांझा म रहय। ओमन करा ये जगह नगर म चरागन के रूप म होही। ");
INSERT INTO hne_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“लेवीमन ला तेंह जऊन सहरमन ला देबे, ओमा के छै ठन सहरमन सरन लेय के सहर होहीं, अऊ येमा ओ मनखे ह भागके जा सकथे, जऊन ह कोनो ला मार डारे हवय। येकर छोंड़, ओमन ला अऊ बियालीस सहर देबे। ");
INSERT INTO hne_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","तेंह लेवीमन ला कुल मिलाके अड़तालीस ठन नगर ओमन के चरागन सहित देबे। ");
INSERT INTO hne_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","इसरायलीमन के अधिकार के देस म ले जऊन नगर तेंह लेवीमन ला देबे, ओ नगरमन गोत्र के मुताबिक उत्तराधिकार के अनुपात म दिये जावंय: जऊन गोत्र के जादा नगर हवंय, ओकर ले जादा, पर जऊन गोत्र के कम नगर हवंय, ओकर ले कम नगर लेबे।” ");
INSERT INTO hne_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","तब यहोवा ह मूसा ला कहिस: ");
INSERT INTO hne_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“इसरायलीमन ले बात कर अऊ ओमन ला कह: ‘जब तुमन यरदन पार करके कनान देस म जावव, ");
INSERT INTO hne_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","तब कुछू नगरमन ला अपन सरन लेय के नगर के रूप म चुनव, जिहां ओ मनखे ह भागके जा सकथे, जऊन ह कोनो ला अनजाने म मार डारे हवय। ");
INSERT INTO hne_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ओ नगरमन बदला लेवइया मनखे ले सरन के जगह होहीं, ताकि सभा के आघू म जांच होय के पहिली ओला झन मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ये छै ठन नगर जेला तुमन दूहू, येमन तुम्हर सरन लेय के सहर होहीं। ");
INSERT INTO hne_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","तीन सहर यरदन के ये पार अऊ तीन सहर कनान देस म सरन लेय के सहर के रूप म दव। ");
INSERT INTO hne_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ये छै नगर इसरायली अऊ ओमन के बीच रहइया परदेसीमन बर सरन लेय के जगह होहीं, ताकि कोनो मनखे अनजाने म कोनो आने मनखे ला मार डारथे, त ओह उहां भागके जा सकय। ");
INSERT INTO hne_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘यदि कोनो मनखे आने मनखे ला लोहा के चीज ले अइसे मारथे कि ओह मर जाथे, त ओ मनखे ह हतियारा अय; अऊ ओ हतियारा ला मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","या यदि कोनो मनखे पथरा लेके कोनो आने मनखे ला अइसे चोट पहुंचाथे कि ओह मर जाथे, त ओ मनखे ह हतियारा अय; ओला मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","या कोनो मनखे ह लकड़ी के कोनो चीज धरे हवय अऊ ओकर ले कोनो आने मनखे ला अइसे मारथे कि ओह मर जाथे, त ओ मनखे ह हतियारा अय; ओला मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","खून के बदला लेवइया ह ओ हतियारा ला मार डारय; जब भी बदला लेवइया ह हतियारा ला देखथे, त ओ बदला लेवइया ह हतियारा ला मार डारय। ");
INSERT INTO hne_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","यदि कोनो मनखे जलन के कारन कोनो आने मनखे ला ढकेल देथे या जानबूझके ओकर ऊपर कोनो चीज फेंकथे, जेकर से ओह मर जाथे ");
INSERT INTO hne_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","या यदि बईरता के कारन एक मनखे ह कोनो आने मनखे ला मुक्का मारथे, जेकर से ओह मर जाथे, त ओ मुक्का मारनेवाला मनखे ह मार डारे जावय; ओ मनखे ह एक हतियारा अय। जब भी खून के बदला लेवइया ह हतियारा ले मिलय, त ओ बदला लेवइया ह ओला मार डारय। ");
INSERT INTO hne_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘पर यदि बिगर बईरता के कोनो मनखे कोनो ला धक्का देथे या अनजाने म ओकर ऊपर कुछू चीज ला फेंकथे ");
INSERT INTO hne_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","या ओला बिगर देखे ओकर ऊपर कोनो भारी पथरा गिरा देथे, जेकर से आने मनखे ह मर जाथे, त जब ओ आने मनखे ह कोनो बईरी नइं रिहिस अऊ चोट पहुंचाय के कोनो इरादा नइं रिहिस, ");
INSERT INTO hne_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","तब सभा ह ये मामला म मारइया अऊ खून के पलटा लेवइया के बीच ये नियम के मुताबिक नियाय करय। ");
INSERT INTO hne_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","सभा ह हतिया के दोसी मनखे ला खून के पलटा लेवइया मनखे ले बचावय अऊ दोसी मनखे ला सरन लेय के सहर म वापिस पठो दे, जिहां ओह भागके गे रिहिस। दोसी मनखे ह उहां तब तक रहय, जब तक कि पबितर तेल ले अभिसेक करे गय ओ समय के महा पुरोहित के मिरतू न हो जाय। ");
INSERT INTO hne_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘पर यदि दोसी मनखे ह ओ सरन लेय के सहर के सीमना ले बाहिर जाथे, जिहां ओह भागके गे हवय ");
INSERT INTO hne_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","अऊ खून के बदला लेवइया ह ओला नगर के बाहिर पाथे, त खून के बदला लेवइया ह दोसी मनखे ला मार सकथे अऊ हतिया के दोसी नइं होवय। ");
INSERT INTO hne_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","जरूरी अय कि दोसी मनखे ह महा पुरोहित के मिरतू तक सरन लेय के सहर म रहय; सिरिप महा पुरोहित के मिरतू के बाद ही ओह अपन खुद के संपत्ति म लहुंट सकथे। ");
INSERT INTO hne_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘जिहां कहूं भी तुमन रहव, येह तुम्हर पीढ़ी-पीढ़ी तक कानून बने रहय। ");
INSERT INTO hne_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘जऊन मनखे ह कोनो आने मनखे ला मार डारथे, त ओह सिरिप गवाहमन के गवाही के आधार म ही हतियारा के रूप म मार डारे जावय। पर कोनो भी मनखे एक गवाह के गवाही के आधार म झन मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘कोनो हतियारा, जऊन ह मिरतू के दोसी हवय, ओकर जिनगी के बदले कोनो किसम के धन झन लेवव। ओह मार डारे जावय। ");
INSERT INTO hne_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘जऊन ह सरन लेय के सहर म भाग गे हवय, ओकर बर कोनो किसम के छुड़ौती के धन स्वीकार झन करव कि ओह महा पुरोहित के मिरतू के पहिले वापिस जाके अपन देस म रह सकय। ");
INSERT INTO hne_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘ओ देस ला असुध झन करव, जिहां तुमन रहत हव। खून करई ह देस ला असुध कर देथे, अऊ ओ देस बर पछताप नइं करे जा सकय, जिहां खून बहाय गे हवय; पछताप सिरिप ओ मनखे के खून के दुवारा होथे, जऊन ह खून बहाय हवय। ");
INSERT INTO hne_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ओ देस ला असुध झन करव, जिहां तुमन रहिथव अऊ जिहां मेंह रहिथंव, काबरकि में यहोवा ह इसरायलीमन के बीच रहिथंव।’ ” ");
INSERT INTO hne_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","तब गिलाद, जऊन ह माकीर के बेटा अऊ मनस्से के पोता रिहिस, ओकर गोत्र के परिवार के मुखियामन यूसुफ के संतानमन के गोत्र म ले रिहिन; ये मुखियामन आईन अऊ मूसा अऊ अगुवामन के आघू म याने कि इसरायली परिवार के मुखियामन के आघू म कहे लगिन, ");
INSERT INTO hne_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“जब यहोवा ह हमर मालिक ला चिट्ठी के दुवारा इसरायलीमन ला देस म उत्तराधिकार देय के हुकूम दीस, त ओह ये हुकूम देय रिहिस कि हमर भाई सलोफाद के उत्तराधिकार ओकर बेटीमन ला दिये जावय। ");
INSERT INTO hne_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","यदि ओमन कोनो आने इसरायली गोत्र के मनखे ले बिहाव करथें, त फेर ओमन के उत्तराधिकार ह हमर पुरखामन के भाग ले, ले लिये जाही अऊ ओ गोत्र म मिला दिये जाही, जेमा ओमन के बिहाव होही। अऊ ये किसम ले हमन ला मिले उत्तराधिकार के एक भाग ह ले लिये जाही। ");
INSERT INTO hne_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","जब इसरायलीमन के जुबली बछर ह आही, त ओमन के उत्तराधिकार ह ओ गोत्र म मिला दिये जाही, जेमा ओमन के बिहाव होथे, अऊ ओमन के संपत्ति ह हमर पुरखामन के गोत्र के उत्तराधिकार ले लेय लिये जाही।” ");
INSERT INTO hne_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","तब यहोवा ले हुकूम पाके मूसा ह इसरायलीमन ला ये हुकूम दीस: “यूसुफ के संतान के गोत्र के मनखेमन जऊन बात कहत हें, ओह सही ए। ");
INSERT INTO hne_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","सलोफाद के बेटीमन के बारे म यहोवा ह ये हुकूम दे हवय: ओमन अपन ईछा ले अपन ददा के गोत्र म ले ही कोनो पुरूस ले बिहाव कर सकथें। ");
INSERT INTO hne_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","इसरायल म कोनो भी उत्तराधिकार एक गोत्र ले आने गोत्र म झन जावय, काबरकि हर एक इसरायली ह अपन पुरखा के गोत्र के उत्तराधिकार ला बनाय रखही। ");
INSERT INTO hne_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","हर ओ बेटी, जऊन ह कोनो इसरायली जाति म उत्तराधिकार पाथे, त ओकर बर जरूरी अय कि ओह अपन ददा के जाति के गोत्र के कोनो पुरूस ले ही बिहाव करय, ताकि हर एक इसरायली ह अपन पुरखामन के उत्तराधिकार बनाय रखय। ");
INSERT INTO hne_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","कोनो भी उत्तराधिकार एक गोत्र ले आने गोत्र म झन जावय, काबरकि हर एक इसरायली ह उत्तराधिकार म मिले भाग ला बनाय रखय।” ");
INSERT INTO hne_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","सलोफाद के बेटीमन मूसा ला दिये गय यहोवा के हुकूम मुताबिक ही करिन। ");
INSERT INTO hne_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","सलोफाद के बेटीमन के नांव महला, तिरसा, होगला, मिलका अऊ नोआ रिहिस अऊ येमन अपन चचेरा-भाईमन ले बिहाव कर लीन। ");
INSERT INTO hne_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ओमन यूसुफ के बेटा मनस्से के संतान के गोत्र म बिहाव करिन, अऊ ओमन के उत्तराधिकार ह ओमन के ददा के जाति अऊ गोत्र म बने रिहिस। ");
INSERT INTO hne_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","येमन ओ हुकूम अऊ नियम अंय, जेला यहोवा ह मूसा के जरिये इसरायलीमन ला यरीहो के ओ पार यरदन नदी के तीर मोआब के मैदान म दीस।");
INSERT INTO hne_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ये बात मूसा ह जम्मो इसरायल ला यरदन नदी के पूरब कोति सुन्ना जगह म कहिस—ये जगह ह पारान अऊ तोपेल, लाबान, हसेरोत अऊ दीजाहाब के बीच, सूप के सामने अराबा म हवय। ");
INSERT INTO hne_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(सेईर पहाड़ के सड़क ले होवत होरेब पहाड़ ले कादेस-बरने जाय म गियारह दिन लगथे।) ");
INSERT INTO hne_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","मिसर देस छोंड़े के चालीसवां साल के गियारहवां महिना के पहिले दिन, मूसा ह इसरायलीमन ला ओ जम्मो बात कहिस, जेकर हुकूम यहोवा ह ओला इसरायलीमन के बारे म दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ये बात ओ समय के अय, जब मूसा ह हेसबोन नगर म राज-करइया अमोरीमन के राजा सीहोन ला हराईस, अऊ असतारोत नगर म राज-करइया बासान के राजा ओग ला एदरेई नगर म हराईस। ");
INSERT INTO hne_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","यरदन के पूरब कोति मोआब के इलाका म, मूसा ह ये कानून ला बताय के सुरू करिस: ");
INSERT INTO hne_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","यहोवा हमर परमेसर ह होरेब पहाड़ म हमन ला कहिस, “ये पहाड़ करा रहत तुमन ला बहुंत दिन हो गे हवय। ");
INSERT INTO hne_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","एकरसेति अब डेरा ला उसालव अऊ अमोरीमन के पहाड़ी इलाका म जावव; अराबा के पास-पड़ोस के जम्मो मनखे करा, पहाड़मन म, पछिम के खाल्हे भाग म, नेगेव अऊ समुंदर के तीरे-तीर, कनानीमन के देस अऊ लबानोन म फरात महानदी तक जावव। ");
INSERT INTO hne_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","देखव, मेंह तुमन ला ये देस दे हवंव। जावव अऊ ये देस ऊपर अधिकार कर लव, जेकर बारे म यहोवा ह सपथ खाके कहे रिहिस कि ओह ये देस तुम्हर पुरखा—अब्राहम, इसहाक अऊ याकूब—अऊ ओमन के बाद ओमन के संतानमन ला दीही।” ");
INSERT INTO hne_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ओ समय मेंह तुमन ला कहेंव, “मेंह एके झन तुम्हर भार नइं उठा सकंव। ");
INSERT INTO hne_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","यहोवा तुम्हर परमेसर ह तुम्हर संखिया ला बढ़ाय हवय कि आज तुमन अकास के तारामन सहीं अनगिनत हो गे हवव। ");
INSERT INTO hne_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","यहोवा, तुम्हर पुरखामन के परमेसर ह तुमन ला हजारों गुना अऊ बढ़ावय अऊ अपन वायदा के मुताबिक तुमन ला आसीस देवय! ");
INSERT INTO hne_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","पर मेंह एके झन तुम्हर समस्या अऊ तुम्हर भार अऊ तुम्हर झगरा के बोझ ला कइसे उठा सकत हंव? ");
INSERT INTO hne_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","एकरसेति तुमन अपन गोत्रमन ले कुछू बुद्धिमान, समझदार अऊ आदरनीय मनखेमन ला चुनव, अऊ मेंह ओमन ला तुम्हर ऊपर मुखिया ठहिराहूं।” ");
INSERT INTO hne_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","त तुमन के ये जबाब रिहिस, “तेंह जऊन काम करे के सलाह देवत हस, ओह बढ़िया ए।” ");
INSERT INTO hne_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","एकरसेति मेंह तुम्हर गोत्रमन के ओ अगुवा मनखेमन ला लेंय, जेमन बुद्धिमान अऊ आदरनीय रिहिन, अऊ ओमन ला तुम्हर ऊपर अधिकारी ठहिरांय—ओमन ला हजार-हजार, सौ-सौ, पचास-पचास अऊ दस-दस के ऊपर सेनापति अऊ गोत्रमन के अधिकारी ठहिरांय। ");
INSERT INTO hne_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","अऊ ओ समय मेंह तुम्हर नियायधीसमन ला ये अधिकार देंय, “अपन मनखेमन के बीच के झगरा ला सुनव अऊ सही-सही नियाय करव, चाहे मामला ह दू इसरायलीमन के बीच होवय या मामला ह एक इसरायली अऊ तुम्हर बीच रहइया कोनो परदेसी के बीच होवय। ");
INSERT INTO hne_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","नियाय करे म पखियपात झन करव; छोटे या बड़े दूनों मनखे के बात ला एक समान सुनव। कोनो मनखे ले झन डरव, काबरकि नियाय ह परमेसर के काम ए। यदि कोनो मामला ह तुम्हर बर बहुंत कठिन ए, त ओला मोर करा लानव, अऊ मेंह ओला सुनहूं।” ");
INSERT INTO hne_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","अऊ ओ समय मेंह तुमन ला तुम्हर जम्मो काम बता दे रहेंव। ");
INSERT INTO hne_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","तब, जइसे कि यहोवा हमर परमेसर ह हमन ला हुकूम दीस, हमन होरेब ले आघू बढ़ेंन अऊ ओ जम्मो बड़े अऊ भयानक सुन्ना जगह, जेला तुमन देखे हव, ओमा ले होवत अमोरीमन के पहाड़ी देस कोति गेंन, अऊ हमन कादेस-बरने पहुंचेंन। ");
INSERT INTO hne_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","तब मेंह तुमन ला कहेंव, “तुमन अमोरीमन के ओ पहाड़ी देस म हबर गे हव, जेला यहोवा हमर परमेसर ह हमन ला देवत हे। ");
INSERT INTO hne_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","देखव, यहोवा तुम्हर परमेसर ह ओ देस तुमन ला दे हवय। जावव अऊ ओ देस ऊपर अधिकार कर लव, जइसे कि यहोवा, तुम्हर पुरखामन के परमेसर ह तुमन ला कहे हवय। झन डरव; अऊ निरास झन होवव।” ");
INSERT INTO hne_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","तब तुमन जम्मो झन मोर करा आके कहेव, “आवव हमन हमर आघू कुछू मनखेमन ला पठोवन कि ओमन ओ देस म जाके गुपत रूप से पता लगावंय अऊ वापिस आके हमन ला बतावंय कि हमन ला कोन रसता म जाना हे अऊ हमन ला कोन-कोन नगर म होके जाना पड़ही।” ");
INSERT INTO hne_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ये सलाह मोला बने लगिस; एकरसेति मेंह तुमन म ले बारह झन ला चुनेंव याने कि हर गोत्र म ले एक झन ला चुनेंव। ");
INSERT INTO hne_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ओ बारह मनखे ऊपर पहाड़ी देस म गीन, अऊ एसकोल के घाटी म आके ओकर भेद लीन। ");
INSERT INTO hne_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","अपन संग ओ देस के कुछू फर लेके ओमन हमर करा आईन अऊ उहां के ये बात बताईन, “येह एक बने देस ए, जेला यहोवा हमर परमेसर ह हमन ला देवत हे।” ");
INSERT INTO hne_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","पर तुमन के जाय के ईछा नइं रिहिस; तुमन यहोवा अपन परमेसर के हुकूम के बिरूध बिदरोह करेव। ");
INSERT INTO hne_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","अपन तम्बूमन म तुमन बड़बड़ावत कहेव, “यहोवा ह हमन ले घिन करथे; एकरसेति ओह हमन ला मिसर देस ले निकाल लानिस कि हमन ला अमोरीमन के हांथ म सऊंपके नास कर दे। ");
INSERT INTO hne_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","हमन कहां जावन? हमर भाईमन ये कहिके हमन ला बहुंत डरा दे हवंय, ‘उहां के मनखेमन हमर ले बलवान अऊ हमर ले ऊंच हवंय; उहां के सहरमन बड़े-बड़े अऊ ओमन के दीवारमन अकास तक ऊंचहा हवंय। अऊ त अऊ हमन उहां अनाकीमन ला घलो देखेंन।’ ” ");
INSERT INTO hne_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","तब मेंह तुमन ला कहेंव, “भयभीत झन होवव; ओमन ले झन डरव। ");
INSERT INTO hne_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","यहोवा तुम्हर परमेसर, जऊन ह तुम्हर आघू जावत हे, ओह तुम्हर बर लड़ही, जइसे कि तुम्हर देखत म मिसर देस म तुम्हर बर करिस, ");
INSERT INTO hne_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","अऊ सुन्ना जगह म घलो करिस। उहां तुमन देखेव कि कइसे यहोवा तुम्हर परमेसर ह तुमन ला लेके चलिस, जइसे कोनो ददा ह अपन बेटा ला लेके चलथे, वइसे ओह तुमन ला पूरा रसता म लेके चलिस अऊ ये जगह म तुमन ला पहुंचाईस।” ");
INSERT INTO hne_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","येकर बावजूद, तुमन यहोवा अपन परमेसर ऊपर भरोसा नइं करेव, ");
INSERT INTO hne_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","जऊन ह तुम्हर यातरा म रथिया आगी म अऊ दिनमान बादर म होके तुम्हर आघू-आघू चलिस, ताकि ओह तुम्हर डेरा डाले बर जगह खोजय अऊ तुमन ला ओ रसता देखावय, जेमा तुमन ला जाना चाही। ");
INSERT INTO hne_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","जब यहोवा ह तुम्हर बात ला सुनिस, त ओह गुस्सा होईस अऊ सपथ खाके कहिस: ");
INSERT INTO hne_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“ये दुस्ट पीढ़ी के कोनो भी मनखे ओ बने देस ला देख नइं सकहीं, जेला मेंह येमन के पुरखामन ला देय के सपथ खाय रहेंव; ");
INSERT INTO hne_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","यपुन्ने के बेटा कालेब ओ देस ला देखही, अऊ मेंह ओला अऊ ओकर संतानमन ला ओ देस दूहूं, जेमा ओकर पांव पड़े रिहिस, काबरकि ओह पूरा मन से यहोवा के पाछू चलिस।” ");
INSERT INTO hne_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","तुम्हर कारन यहोवा ह मोर ऊपर घलो गुस्सा होईस अऊ कहिस, “तेंह घलो ओ देस म नइं जा सकबे। ");
INSERT INTO hne_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","पर तोर सहायक नून के बेटा यहोसू ह ओ देस म जाही। तें ओला उत्साहित कर, काबरकि ओह ओ देस ऊपर अधिकार करे बर इसरायल के अगुवई करही। ");
INSERT INTO hne_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","अऊ छोटे लइकामन जेमन के बारे म तुमन कहे हव कि ओमन बंधुवई म चले जाहीं, तुम्हर लइकामन, जेमन ला अभी सही-गलत के गियान नइं ए—ओमन ओ देस म जाहीं। मेंह ओ देस ओमन ला दूहूं अऊ ओमन ओकर ऊपर अधिकार करहीं। ");
INSERT INTO hne_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","पर जहां तक तुम्हर सवाल ए, तुमन मुड़के लाल-समुंदर के रसता ले सुन्ना जगह कोति जावव।” ");
INSERT INTO hne_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","तब तुम्हर ये जबाब रिहिस, “हमन यहोवा के बिरूध म पाप करे हन। हमन जाबो अऊ लड़बो, जइसे कि यहोवा हमर परमेसर ह हमन ला हुकूम दे हवय।” तब तुमन म ले हर एक जन अपन-अपन हथियार ला धरेव, ये सोचके कि ओ पहाड़ी देस म जवई ह सरल ए। ");
INSERT INTO hne_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","पर यहोवा ह मोला कहिस, “ओमन ला कह, ‘तुमन ऊपर कोति जाके झन लड़व, काबरकि मेंह तुम्हर संग नइं रहंव। तुमन अपन बईरीमन ले हार जाहू।’ ” ");
INSERT INTO hne_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","मेंह ये बात तुमन ला कहेंव, पर तुमन नइं मानेव। तुमन यहोवा के हुकूम के बिरूध चलेव अऊ अपन घमंड म आके ओ पहाड़ी देस के ऊपर कोति आघू बढ़ेव। ");
INSERT INTO hne_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ओ अमोरी, जेमन ओ पहाड़ी देस म रहत रिहिन, ओमन तुम्हर सामना करिन; अऊ तुमन ला मधुमक्खीमन के झुंड सहीं भगाईन अऊ तुमन ला सेईर ले लेके होरमा सहर तक मारत चले गीन। ");
INSERT INTO hne_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","तब तुमन वापिस आके यहोवा के आघू म रोये लगेव; पर ओह तुम्हर रोवई कोति धियान नइं दीस अऊ तुम्हर बात ला नइं सुनिस। ");
INSERT INTO hne_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","अऊ ये किसम ले तुमन कादेस म बहुंत दिन तक पड़े रहेव—उहां तुम्हर पूरा समय अइसने ही बीतिस। ");
INSERT INTO hne_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","तब यहोवा ह जइसे मोला कहे रिहिस, ओकरे मुताबिक हमन वापिस मुड़ेंन अऊ लाल-समुंदर के रसता ले होवत सुन्ना जगह कोति गेंन। हमन बहुंत समय तक सेईर के पहाड़ी देस के आसपास चलते रहेंन। ");
INSERT INTO hne_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","तब यहोवा ह मोला कहिस, ");
INSERT INTO hne_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“तुमन ला ये पहाड़ी देस के आसपास चलत बहुंत समय हो गे हे; अब मुड़के उत्तर कोति चलव। ");
INSERT INTO hne_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","अऊ तें मनखेमन ला ये हुकूम दे: ‘तुमन सेईर म रहइया अपन रिस्तेदार, एसाव के संतानमन के इलाका म ले होके जानेवाला हव। ओमन तुमन ले डरहीं, पर तुमन बहुंत सावधान रहव। ");
INSERT INTO hne_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ओमन ला लड़ई बर झन उकसावव, काबरकि मेंह तुमन ला ओमन के कोनो भुइयां नइं दंव, अऊ त अऊ तुमन ला अपन पांव धरे के जगह तक नइं दंव। मेंह एसाव ला सेईर के पहाड़ी देस ओकर खुद के संपत्ति के रूप म दे हवंव। ");
INSERT INTO hne_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","तुमन जऊन खाना खाहू अऊ पानी पीहू, ओकर बर तुमन ओमन ला चांदी देके ओ जेवन अऊ पानी के दाम चुकावव।’ ” ");
INSERT INTO hne_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","यहोवा तुम्हर परमेसर ह तुम्हर जम्मो काम म आसीस दे हवय। ओह ये बड़े सुन्ना जगह म तुम्हर यातरा के दौरान तुम्हर देखरेख करे हवय। ये चालीस साल तक यहोवा तुम्हर परमेसर ह तुम्हर संगे-संग रहे हवय, अऊ तुमन ला कोनो चीज के कमी नइं होईस। ");
INSERT INTO hne_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","अऊ हमन सेईर म रहइया हमर रिस्तेदार, एसाव के संतानमन के इलाका ले हटके गेंन। हमन अराबा के सड़क ले मुड़ेंन, जऊन ह एलात अऊ एसियोन-गेबेर म ले आथे, अऊ हमन मोआब के सुन्ना जगह के सड़क म ले होके गेंन। ");
INSERT INTO hne_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","तब यहोवा ह मोला कहिस, “मोआबीमन ला तंग झन करव या ओमन ला लड़ई बर झन उकसावव, काबरकि मेंह ओमन के देस म के कोनो भाग तुमन ला नइं दंव। मेंह लूत के संतानमन ला आर के इलाका ओमन के अधिकार म देय दे हंव।” ");
INSERT INTO hne_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(एमीमन उहां रहे के आदि रिहिन—ये मनखेमन बलवान अऊ संखिया म बहुंत रिहिन, अऊ येमन अनाकीमन सहीं ऊंच घलो रिहिन। ");
INSERT INTO hne_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","अनाकीमन सहीं, ओमन ला घलो रपाई माने जावत रिहिस, पर मोआबीमन ओमन ला एमी कहंय। ");
INSERT INTO hne_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","सेईर म होरीमन रहे के आदि रिहिन, पर एसाव के संतानमन ओमन ला भगा दीन। ओमन होरीमन ला अपन आघू ले खतम कर दीन अऊ ओमन के जगह म बस गीन, जइसे कि इसरायलीमन ओ देस म बस गीन, जेला यहोवा ह ओमन के अधिकार म दे दीस।) ");
INSERT INTO hne_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","अऊ यहोवा ह कहिस, “अब तुमन उठव अऊ जेरेद घाटी के ओ पार जावव।” तब हमन घाटी के ओ पार गेंन। ");
INSERT INTO hne_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","कादेस-बरने ला छोंड़के आय के बेरा ले लेके जेरेद घाटी ला पार करत तक अड़तीस साल हो गे रिहिस। ये बीच म ओ पीढ़ी के जम्मो योद्धामन सिविर म नास हो गीन, जइसे कि यहोवा ह ओमन ले सपथ खाय रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","जब तक यहोवा ह ओमन ला सिविर ले पूरा खतम नइं कर दीस, तब तक ओकर हांथ ह ओमन के बिरूध रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","जब आखिरी म मनखेमन के बीच म ले जम्मो योद्धामन मर गीन, ");
INSERT INTO hne_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","तब यहोवा ह मोला कहिस, ");
INSERT INTO hne_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“आज तेंह आर नगर म मोआब के इलाका ले होके जाबे। ");
INSERT INTO hne_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","जब तेंह अमोनीमन करा आबे, त ओमन ला तंग झन करबे या ओमन ला लड़ई करे बर झन उकसाबे, काबरकि मेंह ओमन के देस के कोनो भाग ला तोर अधिकार म नइं दंव। मेंह ओला लूत के संतानमन के अधिकार म कर दे हंव।” ");
INSERT INTO hne_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(ओला घलो रपाईमन के एक देस समझे जावत रिहिस, जऊन मन उहां रहत रिहिन; पर अमोनीमन ओमन ला जमजुम्मी कहंय। ");
INSERT INTO hne_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ओमन बलवान अऊ संखिया म बहुंत, अऊ अनाकीमन सहीं ऊंच रिहिन। यहोवा ह अमोनीमन के आघू ले ओमन ला नास कर दीस; अमोनीमन ओमन ला भगा दीन अऊ ओमन के जगह म बस गीन। ");
INSERT INTO hne_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","यहोवा ह वइसने ही एसाव के संतानमन बर करिस, जऊन मन सेईर म रहत रिहिन; ओह होरीमन ला ओमन के आघू ले नास कर दीस। एसाव के संतानमन ओमन ला भगा दीन अऊ ओमन आज तक होरीमन के जगह म रहत हवंय। ");
INSERT INTO hne_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","जहां तक अव्वीमन के बात ए, जऊन मन गाजा सहर तक के गांवमन म रहत रिहिन, ओमन ला कपतोरीमन कपतोर ले आके नास कर दीन अऊ ओमन के जगह म बस गीन।) ");
INSERT INTO hne_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“अब आघू बढ़व अऊ अरनोन घाटी के ओ पार चलव। देख, मेंह हेसबोन के राजा, अमोरी सीहोन अऊ ओकर देस ला तोर हांथ म कर दे हंव। ओला अधिकार म लेय के सुरू कर दव अऊ ओला लड़ई म लगाय रखव। ");
INSERT INTO hne_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","आज के दिन ले ही मेंह धरती के जम्मो देस म तोर आतंक अऊ डर पईदा कर दूहूं। ओमन तोर बारे म सुनहीं अऊ तोर कारन ओमन कांपहीं अऊ ओमन ला तकलीफ होही।” ");
INSERT INTO hne_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","कदेमोत के सुन्ना जगह ले मेंह हेसबोन नगर के राजा सीहोन करा संदेसियामन के दुवारा ये कहिके सांति संदेस पठोंय, ");
INSERT INTO hne_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“हमन ला तोर देस म ले होके जावन दे। हमन मुख्य सड़क म ही रहिबो; हमन न तो जेवनी अंग मुड़बो, न ही डेरी। ");
INSERT INTO hne_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","चांदी के रूप म हमन ले दाम लेके हमन ला खाय बर जेवन अऊ पीये बर पानी दे। हमन ला सिरिप इहां ले रेंगत जावन दे— ");
INSERT INTO hne_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","जइसे कि सेईर म रहइया एसाव के संतान, अऊ आर म रहइया मोआबीमन हमर बर करिन, जब तक कि हमन यरदन ला पार करके ओ देस म नइं हबर जावन, जेला यहोवा हमर परमेसर ह हमन ला देवत हे।” ");
INSERT INTO hne_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","पर हेसबोन के राजा सीहोन ह इसरायल ला अपन देस म ले होके जावन नइं दीस। काबरकि यहोवा तुम्हर परमेसर ह ओकर मन ला कठोर अऊ ओला जिद्दी बना दे रिहिस, ताकि ओह ओला तुम्हर हांथ म कर दे, जइसे कि अब ओह करे हवय। ");
INSERT INTO hne_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","यहोवा ह मोला कहिस, “देख, मेंह सीहोन अऊ ओकर देस ला तोर अधीन करे के सुरू कर दे हंव। अब तेंह ओकर देस ऊपर अधिकार अऊ ओला अपन अधीन करे के सुरू कर दे।” ");
INSERT INTO hne_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","जब सीहोन अऊ ओकर जम्मो सेना लड़ई म हमर सामना करे बर यहस नांव के नगर म आईन, ");
INSERT INTO hne_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","त यहोवा ह ओला हमर अधीन कर दीस अऊ हमन ओला ओकर बेटामन अऊ ओकर पूरा सेना सहित मार डारेंन। ");
INSERT INTO hne_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ओ समय हमन ओकर जम्मो नगरमन ला ले लेंन अऊ ओमन ला पूरा नास कर देंन—जम्मो पुरूस, माईलोगन अऊ लइकामन ला। हमन एको झन ला घलो जीयत नइं छोड़ेंन। ");
INSERT INTO hne_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","पर पसु अऊ नगरमन ले लूटे सामान ला हमन अपन बर ले लेंन। ");
INSERT INTO hne_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","अरनोन घाटी के तीर म अरोएर ले, अऊ घाटी म नगर ले लेके गिलाद के इलाका तक कोनो भी नगर हमर आघू म टिक नइं सकिन। यहोवा हमर परमेसर ह ओ जम्मो ला हमन ला दे दीस। ");
INSERT INTO hne_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","पर यहोवा हमर परमेसर के दिये हुकूम के मुताबिक, तुमन न तो अमोनीमन के देस, अऊ न ही यब्बोक नदी के तीरे-तीर के देस अऊ पहाड़ी कोति के नगरमन के आसपास के इलाका म गेव। ");
INSERT INTO hne_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ओकर बाद हमन मुड़के सड़क म होवत बासान कोति गेंन, अऊ बासान के राजा ओग अपन पूरा सेना के संग हमर ले लड़ई करे बर एदरेई नगर करा आईस। ");
INSERT INTO hne_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","यहोवा ह मोला कहिस, “ओकर ले झन डर, काबरकि मेंह ओला अऊ ओकर पूरा सेना के संग ओकर देस ला तोर हांथ म कर देवत हंव। ओकर संग वइसने ही करबे, जइसने तेंह अमोरीमन के राजा सीहोन के संग करे रहय, जऊन ह हेसबोन म राज करत रिहिस।” ");
INSERT INTO hne_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ये किसम ले यहोवा हमर परमेसर ह बासान के राजा ओग अऊ ओकर जम्मो सेना ला हमर हांथ म कर दीस। हमन ओमन ला मार डारेंन अऊ एको झन ला घलो नइं छोड़ेंन। ");
INSERT INTO hne_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ओ समय हमन ओकर जम्मो सहरमन ला ले लेंन। हमन ओमन के साठ ठन सहरमन ले जम्मो सहरमन ला ले लेंन—याने कि अरगोब के पूरा इलाका, जऊन ह बासान म ओग के राज म रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ये जम्मो सहरमन ऊंच-ऊंच दीवार के संग गढ़वाले रिहिन, जेमा कपाट अऊ बाड़ामन लगे रिहिन, अऊ उहां बिगर दीवार के कतको बड़े-बड़े गांवमन घलो रिहिन। ");
INSERT INTO hne_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","हमन ओमन ला पूरा नास कर देंन, जइसे कि हमन हेसबोन के राजा सीहोन के संग करे रहेंन याने कि हर एक सहर के पुरूस, माईलोगन अऊ लइकामन ला नास कर देंन। ");
INSERT INTO hne_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","पर ओमन के सहर के जम्मो पसु अऊ लूट के सामान ला हमन अपन बर ले लेंन। ");
INSERT INTO hne_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ये किसम ले ओ समय हमन अमोरीमन के ये दूनों राजामन ले यरदन के पूरब के इलाका अरनोन घाटी ले लेके हेरमोन पहाड़ तक ले लेंन। ");
INSERT INTO hne_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(हेरमोन ला सीदोनीमन सिरयोन, अऊ अमोरीमन सनीर कहिथें।) ");
INSERT INTO hne_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","हमन पठार के जम्मो नगर, अऊ पूरा गिलाद के इलाका अऊ बासान म ओग राज के नगर सलका अऊ एदरेई तक पूरा बासान ला ले लेंन। ");
INSERT INTO hne_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(रपाईमन म बासान के राजा ओग ह सबले आखिरी रिहिस। ओकर पलंग ह लोहा ले सजे रिहिस अऊ येह नौ क्यूबीट लम्बा अऊ चार क्यूबीट चौड़ा रिहिस। येह अमोनीमन के रब्बा नगर म अभी तक हवय।) ");
INSERT INTO hne_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","ओ देस, जेला हमन ओ समय अपन अधिकार म लेंन, ओमा के अरनोन घाटी के तीरे-तीर अरोएर के उत्तर के इलाका, गिलाद के आधा पहाड़ी इलाका अऊ येकर नगरमन ला मेंह रूबेनी अऊ गादीमन ला दे देंव। ");
INSERT INTO hne_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","गिलाद के बचे भाग अऊ पूरा बासान याने कि ओग के राज ला मेंह मनस्से के आधा गोत्र के मनखेमन ला दे देंव। (बासान म अरगोब के पूरा इलाका ह रपाईमन के देस के रूप म जाने जाथे। ");
INSERT INTO hne_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","मनस्से के एक संतान याईर ह गसूरी अऊ माकातीमन के सीमना तक पूरा अरगोब के इलाका ला लीस; येला ओकर नांव दिये गीस, एकरसेति आज तक बासान ला हव्वोत-याईर कहे जाथे।) ");
INSERT INTO hne_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","अऊ मेंह माकीर ला गिलाद दे देंव। ");
INSERT INTO hne_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","पर मेंह रूबेनी अऊ गादीमन ला ओ इलाका देंव, जऊन ह गिलाद ले लेके खाल्हे अरनोन घाटी (घाटी के मांझा भाग ह सीमना अय) अऊ यब्बोक नदी के बाहिर तक फईले हवय, जऊन ह कि अमोनीमन के सीमना अय। ");
INSERT INTO hne_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","येकर पछिमी सीमना ह अराबा म यरदन रिहिस, जऊन ह किन्नेरेत ले लेके पिसगा के ढलान के खाल्हे अराबा के समुंदर (याने कि मिरतू सागर) तक रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ओ समय मेंह तुमन ला हुकूम देंव: “यहोवा तुम्हर परमेसर ह तुमन ला ये देस अपन अधिकार म करे बर दे हवय। पर तुम्हर जम्मो योग्य मनखेमन लड़ई बर हथियार धरके आने इसरायलीमन ले आघू ओ पार जावंय। ");
INSERT INTO hne_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","पर तुम्हर घरवाली, तुम्हर लइका अऊ तुम्हर पसुमन (मेंह जानत हंव कि तुम्हर करा बहुंत पसु हवंय) मोर दुवारा दिये गय नगरमन म तब तक रूके रहंय, ");
INSERT INTO hne_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","जब तक कि यहोवा ह तुम्हर संगी इसरायलीमन ला अराम नइं देय दे, जइसे कि ओह तुमन ला देय हवय, अऊ ओमन घलो ओ देस ऊपर अधिकार नइं कर लेवंय, जेला यहोवा तुम्हर परमेसर ह ओमन ला यरदन के ओ पार देवत हे। ओकर बाद, तुमन म ले हर एक जन अपन अधिकार म लिये गय ओ जगह म जावव, जेला मेंह तुमन ला दे हवंव।” ");
INSERT INTO hne_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ओ समय मेंह यहोसू ला हुकूम देंव: “तेंह अपन आंखी ले ओ जम्मो चीज ला देखे हस कि यहोवा तोर परमेसर ह ये दूनों राजामन के संग का करिस। यहोवा ह उहां के जम्मो राजमन के संग वइसने ही करही, जिहां तेंह जावत हस। ");
INSERT INTO hne_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ओमन ले झन डरबे; यहोवा तोर परमेसर ह खुद तोर बर लड़ही।” ");
INSERT INTO hne_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ओ समय मेंह यहोवा ले बिनती करेंव: ");
INSERT INTO hne_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“हे परमपरधान यहोवा, तेंह अपन सेवक ला अपन महानता अऊ अपन बलवान हांथ देखाय सुरू करे हस। स्वरग अऊ धरती म अइसे कोन देवता हे, जेह तोर सहीं काम अऊ सक्तिसाली काम कर सकथे? ");
INSERT INTO hne_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","मोला यरदन के ओ पार जाके ओ सुघर पहाड़ी देस अऊ लबानोन ला देखन दे।” ");
INSERT INTO hne_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","पर तुम्हर कारन यहोवा ह मोर ऊपर गुस्सा होईस अऊ मोर बात ला नइं सुनिस। यहोवा ह कहिस, “बहुंत हो गीस, येकर बारे म तेंह मोर ले अऊ झन गोठिया। ");
INSERT INTO hne_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","पिसगा पहाड़ के चोटी म जा अऊ पूरब, पछिम, उत्तर, दक्खिन चारों कोति देख। ओ देस ला अपन आंखी ले देख ले, काबरकि तेंह ये यरदन के ओ पार नइं जावत हस। ");
INSERT INTO hne_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","पर यहोसू ला अधिकार दे, अऊ ओला उत्साहित अऊ मजबूत कर, काबरकि ओ पार जाय म, ओह ये मनखेमन के अगुवई करही अऊ जऊन देस ला तेंह देखबे, ओकर ऊपर ओह ये मनखेमन ला अधिकार देवाही।” ");
INSERT INTO hne_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","तब हमन ओ घाटी म रूक गेंन, जऊन ह बेत-पोर के लकठा म रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","अब हे इसरायल, ओ बिधि अऊ कानूनमन ला सुनव, जेला मेंह तुमन ला सिखानेवाला हंव। ओमन के पालन करव ताकि तुमन जीयत रहव अऊ ओ देस म जाके ओकर ऊपर अधिकार कर सकव, जेला यहोवा, तुम्हर पुरखामन के परमेसर ह तुमन ला देवत हे। ");
INSERT INTO hne_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","जऊन हुकूम मेंह तुमन ला देवत हंव, ओमा न कुछू जोड़व अऊ न कुछू घटावव, पर यहोवा तुम्हर परमेसर के ओ हुकूम ला मानव, जेला मेंह तुमन ला देवत हंव। ");
INSERT INTO hne_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","तुमन अपन आंखी ले देखे हव कि यहोवा ह बाल-पेओर करा का करिस। यहोवा तुम्हर परमेसर ह तुम्हर बीच ले ओ जम्मो मनखेमन ला नास कर दीस, जऊन मन बाल-पेओर देवता के पाछू चलत रिहिन, ");
INSERT INTO hne_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","पर तुमन जम्मो, जऊन मन यहोवा अपन परमेसर के संग मजबूती से बने रहेव, ओ जम्मो आज भी जीयत हव। ");
INSERT INTO hne_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","देखव, यहोवा मोर परमेसर के दिये हुकूम के मुताबिक मेंह तुमन ला बिधि अऊ कानून सिखाय हंव, ताकि तुमन ओ देस म येमन के पालन करव, जिहां तुमन ओकर ऊपर अधिकार करे बर जावत हव। ");
INSERT INTO hne_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","धियान लगाके येमन के पालन करव, काबरकि येह ओ आने जाति के मनखेमन ला तुम्हर बुद्धि अऊ समझ देखाही, जऊन मन ये जम्मो बिधिमन के बारे म सुनहीं अऊ ओमन कहिहीं, “सही म ये महान जाति के मनखेमन एक बुद्धिमान अऊ समझवाले मनखे अंय।” ");
INSERT INTO hne_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","कोन अइसने बड़े जाति ए, जेकर देवता ओकर अइसे लकठा म रहिथे, जइसे यहोवा हमर परमेसर हमर लकठा म रहिथे, जब भी हमन ओकर ले पराथना करथन? ");
INSERT INTO hne_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","अऊ कोन अइसने बड़े जाति ए, जेकर करा अइसे धरमी बिधि अऊ कानून हवंय, जइसे कि ये कानूनमन, जेला मेंह आज तुम्हर आघू म रखत हंव? ");
INSERT INTO hne_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","सिरिप तुमन सावधान रहव, अऊ अपन म बहुंत सचेत रहव, ताकि तुम्हर आंखीमन जऊन चीजमन ला देखे हवंय, ओला तुमन झन भूलव या ओ चीजमन तुम्हर मन ले झन हटंय, जब तक कि तुमन जीयत हव। ये बातमन ला अपन लइका अऊ नाती-पोतामन ला सिखावव। ");
INSERT INTO hne_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ओ दिन ला सुरता करव, जब तुमन होरेब म यहोवा अपन परमेसर के आघू म खड़े रहेव, अऊ ओह मोला कहिस, “मनखेमन ला मोर बात सुने बर मोर आघू म इकट्ठा कर, ताकि जब तक ओमन देस म जीयत रहंय, ओमन मोर आदर करई सीखंय अऊ ये बारे म अपन लइकामन ला घलो सिखावंय।” ");
INSERT INTO hne_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","तुमन लकठा म आके पहाड़ के खाल्हे म ठाढ़ हो गेव अऊ ओ पहाड़ ह आगी ले धधकत रहय; आगी के जुवाला ह करिया बादर अऊ घोर अंधियार के संग अकास तक हबरत रहय। ");
INSERT INTO hne_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","तब यहोवा ह आगी म ले तुम्हर ले गोठियाईस। तुमन सबद के अवाज तो सुनेव, पर तुमन ला कोनो दिखाई नइं दीस; उहां सिरिप एक अवाज रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ओह तुमन ला अपन करार, दस ठन हुकूम ला बताईस अऊ ओह तुमन ला ये हुकूममन के पालन करे बर कहिस अऊ ओमन ला पथरा के दू ठन पटिया म लिख दीस। ");
INSERT INTO hne_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","अऊ यहोवा ह ओ समय मोला निरदेस दीस कि मेंह तुमन ला ओ बिधि अऊ कानूनमन ला सिखावंव, जेकर पालन तुमन ओ देस म करव, जेला अपन अधिकार म करे बर तुमन यरदन के ओ पार जावत हव। ");
INSERT INTO hne_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","तुमन ला ओ दिन कोनो किसम के सरूप दिखाई नइं दीस, जऊन दिन यहोवा ह तुमन ले होरेब पहाड़ करा आगी म ले गोठियाईस। एकरसेति तुमन बहुंत सचेत रहव, ");
INSERT INTO hne_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ताकि तुमन भ्रस्ट होके अपन बर कोनो भी किसम के मूरती या कोनो चीज के नमूना झन बनावव, चाहे ओह कोनो पुरूस या माईलोगन के सहीं रूप होवय, ");
INSERT INTO hne_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","या धरती म कोनो पसु या अकास म उड़इया कोनो चिरई सहीं होवय, ");
INSERT INTO hne_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","या भुइयां म रेंगइया कोनो जीव सहीं या पानी के भीतर कोनो मछरी सहीं होवय। ");
INSERT INTO hne_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","अऊ जब तुमन अकास कोति नजर उठाके सूरज, चंदा अऊ तारा याने कि जम्मो अकास के चीजमन ला देखव, त बहकके तुमन ओमन के दंडवत अऊ अराधना झन करव; ये चीजमन ला यहोवा तुम्हर परमेसर ह धरती के जम्मो जाति के मनखेमन ला ओमन के भाग के रूप म दे हवय। ");
INSERT INTO hne_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","पर जहां तक तुम्हर सवाल ए, यहोवा ह तुमन ला लेके लोहा पिघलइया भट्ठी ले निकाले सहीं मिसर देस ले बाहिर निकालिस, ताकि तुमन ओकर उत्तराधिकार के मनखे हो जावव, जइसे कि अब तुमन अव घलो। ");
INSERT INTO hne_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","यहोवा ह तुम्हर कारन मोर ऊपर गुस्सा होईस अऊ सपथ खाके कहिस कि मेंह यरदन नदी के पार ओ बने देस म नइं जा सकंव, जेला यहोवा तुम्हर परमेसर ह तुमन ला तुम्हर उत्तराधिकार के रूप म देवत हे। ");
INSERT INTO hne_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","मेंह इही देस म मर जाहूं; मेंह यरदन के ओ पार नइं जा सकंव; पर तुमन ओ पार जाके ओ बने देस ऊपर अधिकार करहू। ");
INSERT INTO hne_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","एकरसेति धियान रहय कि तुमन यहोवा तुम्हर परमेसर के ओ करार ला झन भूलव, जेला ओह तुम्हर संग करे हवय; अपन बर कोनो भी चीज के कोनो मूरती झन बनावव, जेला यहोवा तुम्हर परमेसर ह मना करे हवय। ");
INSERT INTO hne_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","काबरकि यहोवा तुम्हर परमेसर ह एक भसम करइया आगी, एक जलन रखइया परमेसर अय। ");
INSERT INTO hne_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","जब तुम्हर लोग-लइका अऊ नाती-पोता हो जाहीं अऊ तुम्हर उहां लम्बा समय तक रहे के बाद—यदि तुमन भ्रस्ट होके कोनो किसम के मूरती बनाथव अऊ ये किसम ले यहोवा तुम्हर परमेसर के नजर म खराप काम करके ओकर गुस्सा ला भड़काथव, ");
INSERT INTO hne_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","त आज मेंह अकास अऊ धरती ला तुम्हर बिरूध गवाह रखके कहत हंव कि तुमन ओ देस ले जल्दी नास हो जाहू, जेला तुमन अपन अधिकार म लेय बर यरदन के ओ पार जावत हव। तुमन उहां लम्बा समय तक जिंदा नइं रहे पाहू, पर खचित तुमन नास हो जाहू। ");
INSERT INTO hne_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","यहोवा ह तुमन ला मनखेमन के बीच म तितिर-बितिर कर दीही, अऊ यहोवा ह तुमन ला जऊन जातिमन के बीच म भगा दीही, उहां तुमन थोरकन ही बचे रहिहू। ");
INSERT INTO hne_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","उहां तुमन मनखे के बनाय ओ लकड़ी अऊ पथरा के देवतामन के अराधना करहू, जेमन न तो देख सकंय, न सुन सकंय, न खा सकंय अऊ न ही सुंघ सकंय। ");
INSERT INTO hne_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","पर यदि उहां तुमन यहोवा अपन परमेसर के खोज करहू, त ओह तुमन ला मिलही, यदि तुमन ओला अपन पूरा मन अऊ अपन पूरा आतमा ले खोजहू। ");
INSERT INTO hne_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","जब तुमन बिपत्ति म पड़व अऊ ये जम्मो चीज तुम्हर जिनगी म होथे, तब बाद म, तुमन यहोवा अपन परमेसर करा लहुंटके आहू अऊ ओकर बात मानहू। ");
INSERT INTO hne_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","काबरकि यहोवा तुम्हर परमेसर ह दयालु परमेसर अय; ओह तुमन ला नइं छोंड़ही अऊ न ही नास करही अऊ न ही तुम्हर पुरखामन के संग करे गे ओ करार ला भूलही, जेला ओह सपथ खाके ओमन के संग मजबूत करे रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","अब पहिले के समय के बारे म पुछव, अपन बहुंत पहिले के समय, जब परमेसर ह धरती म मानव-जाति ला बनाईस; अकास के एक छोर ले लेके दूसर छोर तक पुछव। का अइसने बड़े बात कभू होईस, या कभू अइसने बात सुनई म आईस? ");
INSERT INTO hne_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","का कभू आने मनखेमन परमेसर के अवाज ला आगी ले गोठियावत सुनके घलो जीयत रिहिन, जइसे कि तुमन सुनके जीयत हव? ");
INSERT INTO hne_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","का कभू कोनो देवता एक जाति ला आने जाति के बीच ले अपन करे बर, परखे के दुवारा, चिनहां अऊ अद्भूत काम के दुवारा, लड़ई के दुवारा, सक्तिसाली हांथ अऊ बढ़ाय हुए भुजा के दुवारा, या बड़े अऊ अद्भूत काम के दुवारा निकाल लाने के कोसिस करिस, जइसे कि यहोवा तुम्हर परमेसर ह तुम्हर आंखी के आघू म तुम्हर बर मिसर देस म जम्मो काम करिस? ");
INSERT INTO hne_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","तुमन ला ये जम्मो चीज देखाय गीस ताकि तुमन जानव कि यहोवा ह परमेसर ए; ओला छोंड़ अऊ कोनो परमेसर नइं ए। ");
INSERT INTO hne_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","अकास ले ओह तुमन ला अपन अवाज सुनाईस, ताकि तुमन अनुसासन म रहव। धरती म ओह तुमन ला अपन बड़े आगी ला देखाईस, अऊ तुमन आगी ले ओकर बात सुनेव। ");
INSERT INTO hne_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","काबरकि ओह तुम्हर पुरखामन ले मया करिस अऊ ओमन के बाद ओह ओमन के संतान ला चुनिस, एकरसेति ओह तुमन ला खुद होके अपन बड़े सामर्थ से मिसर देस ले बाहिर निकाल लानिस, ");
INSERT INTO hne_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ताकि तुम्हर आघू ले तुम्हर ले बड़े अऊ बलवान जाति के मनखेमन ला भगाके तुमन ला ओमन के देस म लानय अऊ ओ देस तुमन ला तुम्हर उत्तराधिकार के रूप म देवय, जइसे कि आज तुमन देखत हव। ");
INSERT INTO hne_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","एकरसेति आज तुमन मान लव अऊ अपन मन म जान लव कि यहोवा ही ऊपर अकास म अऊ खाल्हे धरती म परमेसर ए। आने अऊ कोनो परमेसर नइं ए। ");
INSERT INTO hne_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","ओकर बिधि अऊ कानूनमन ला मानव, जेला आज में तुमन ला देवत हंव, ताकि तुम्हर अऊ तुम्हर बाद तुम्हर लइकामन के संग भलई होवय अऊ तुमन ओ देस म बहुंत समय तक रहव, जेला यहोवा तुम्हर परमेसर ह तुमन ला हमेसा बर देवत हे। ");
INSERT INTO hne_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","तब मूसा ह यरदन के पूरब कोति तीन ठन सहर ला अलग करिस, ");
INSERT INTO hne_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ताकि यदि कोनो मनखे के दुवारा अनजाने म बिगर कोनो बईरता के कोनो परोसी के हतिया हो जावय, त ओह येमा के कोनो सहर म भागके जा सकय अऊ अपन जिनगी ला बचावय। ");
INSERT INTO hne_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ओ सहरमन ये रिहिन: रूबेनीमन बर सुन्ना जगह के पठार म बेसेर; गादीमन बर गिलाद म रामोत; अऊ मनस्सेयीमन बर बासान म गोलान। ");
INSERT INTO hne_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","येह ओ कानून ए, जेला मूसा ह इसरायलीमन के आघू म रखिस। ");
INSERT INTO hne_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","येमन ओ सर्त, बिधि अऊ कानून अंय, जेला मूसा ह ओमन ला दीस, जब ओमन मिसर देस ले निकलके आईन ");
INSERT INTO hne_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","अऊ यरदन के पूरब कोति बेत-पोर नगर के लकठा के घाटी म रिहिन; ये जगह ह अमोरीमन के राजा सीहोन के देस म रिहिस; ओह हेसबोन नगर म राज करत रिहिस अऊ ओला मूसा अऊ इसरायलीमन लड़ई म हराईन, जब ओमन मिसर देस ले निकलके आईन। ");
INSERT INTO hne_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","ओमन ओकर देस ऊपर अऊ बासान के राजा ओग के देस ऊपर अधिकार कर लीन याने कि यरदन के पूरब कोति ये दूनों अमोरी राजामन के देस ऊपर अधिकार कर लीन। ");
INSERT INTO hne_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ये देस ह अरनोन घाटी के तीर म अरोएर ले लेके सीरिओन (याने कि हेरमोन) पहाड़ तक फईले रिहिस, ");
INSERT INTO hne_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","अऊ येमा यरदन के पूरब कोति जम्मो अराबा अऊ पिसगा पहाड़ के ढलान के खाल्हे मिरतू सागर तक के इलाका सामिल रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","मूसा ह जम्मो इसरायल ला बलाके कहिस: हे इसरायल, जऊन बिधि अऊ कानून मेंह आज तुम्हर आघू म बतात हंव, ओमन ला सुनव। ओमन ला सीखव अऊ धियान से ओमन के पालन करव। ");
INSERT INTO hne_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","यहोवा हमर परमेसर ह होरेब पहाड़ म हमर ले एक करार करिस। ");
INSERT INTO hne_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","येह ओ करार नो हय, जेला यहोवा ह हमर पुरखामन संग करिस, पर ये करार हमर संग, हमर ओ जम्मो झन संग करिस, जेमन आज इहां हवंय। ");
INSERT INTO hne_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","यहोवा ह पहाड़ ऊपर आगी म ले तुम्हर संग आमने-सामने गोठियाईस। ");
INSERT INTO hne_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(ओ समय, मेंह यहोवा के बचन ला बताय बर यहोवा अऊ तुम्हर बीच ठाढ़ होंय, काबरकि तुमन ओ आगी ले डरके पहाड़ ऊपर नइं गेव।) अऊ यहोवा ह कहिस: ");
INSERT INTO hne_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“में यहोवा तुम्हर परमेसर अंव, जऊन ह तुमन ला मिसर देस याने कि गुलामी के देस ले निकाल लानिस। ");
INSERT INTO hne_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“तुमन मोर छोंड़ अऊ कोनो ला ईस्वर करके झन मानहू। ");
INSERT INTO hne_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","तुमन अपन बर कोनो भी चीज के कोनो किसम के मूरती झन बनाहू, न तो ऊपर अकास के, न खाल्हे धरती के अऊ न ही पानी म के कोनो चीज के। ");
INSERT INTO hne_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","तुमन ओमन ला न तो दंडवत करहू अऊ न ही ओमन के अराधना करहू; काबरकि में यहोवा तुम्हर परमेसर ह जलन रखइया परमेसर अंव अऊ जऊन मन मोर ले घिन करथें, ओमन के पाप के दंड मेंह ओमन के लइकामन के तीसरा अऊ चौथा पीढ़ी तक देथंव, ");
INSERT INTO hne_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","पर जऊन मन मोर ले मया करथें अऊ मोर हुकूममन ला मानथें, ओमन के हजार पीढ़ी तक मेंह अपन मया देखाथंव। ");
INSERT INTO hne_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","तुमन यहोवा अपन परमेसर के नांव बेमतलब के झन लूहू, काबरकि जऊन ह यहोवा के नांव के दुरपयोग करही, ओला ओह दोसी ठहिराही। ");
INSERT INTO hne_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","तुमन बिसराम दिन ला पबितर मानव, जइसे कि यहोवा तुम्हर परमेसर ह तुमन ला हुकूम दे हवय। ");
INSERT INTO hne_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","हप्ता के छै दिन तुमन मेहनत करव अऊ अपन जम्मो काम करव, ");
INSERT INTO hne_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","पर सातवां दिन यहोवा तुम्हर परमेसर बर बिसराम दिन ए। ओ दिन तुमन कोनो काम झन करहू, न तो तुमन, न तुम्हर बेटा या बेटीमन, न तुम्हर सेवक या सेविकामन, न तुम्हर बईला, तुम्हर गदहा या तुम्हर पसुमन, अऊ न ही तुम्हर नगर म रहइया कोनो परदेसी, ताकि तुम्हर सहीं तुम्हर सेवक अऊ सेविकामन घलो बिसराम करंय। ");
INSERT INTO hne_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","ये बात ला सुरता रखव कि तुमन मिसर देस म गुलाम रहेव अऊ यहोवा तुम्हर परमेसर ह तुमन ला उहां ले अपन सक्तिसाली हांथ अऊ बढ़ाय भुजा के दुवारा निकाल लानिस। एकरसेति यहोवा तुम्हर परमेसर ह तुमन ला बिसराम दिन ला माने के हुकूम दे हवय। ");
INSERT INTO hne_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","अपन दाई-ददा के आदरमान करव, जइसे कि यहोवा तुम्हर परमेसर ह तुमन ला हुकूम दे हवय, ताकि तुमन बहुंत साल तक जीयव अऊ ओ देस म तुम्हर भलई होवय, जेला यहोवा तुम्हर परमेसर ह तुमन ला देवत हे। ");
INSERT INTO hne_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","तुमन कोनो मनखे के हतिया झन करहू। ");
INSERT INTO hne_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","तुमन बेभिचार झन करहू। ");
INSERT INTO hne_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","तुमन चोरी झन करहू। ");
INSERT INTO hne_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","तुमन अपन परोसी के बिरूध लबारी गवाही झन दूहू। ");
INSERT INTO hne_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","तुमन अपन परोसी के घरवाली के लालच झन करहू। तुमन अपन परोसी के घर या भुइयां के लालच झन करहू, न ही ओकर सेवक या सेविका, ओकर बईला, या गदहा, या ओकर कोनो अऊ चीज के लालच करहू।” ");
INSERT INTO hne_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","येमन ओ हुकूम अंय, जेला यहोवा ह ऊंच अवाज म आगी, बादर अऊ घोर अंधियार म ले उहां पहाड़ ऊपर तुम्हर जम्मो सभा ला सुनाईस; अऊ ओह येमा अऊ कुछू नइं जोड़िस। तब ओह येमन ला दू ठन पथरा के पटिया म लिखके मोला दे दीस। ");
INSERT INTO hne_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","जब तुमन ओ अंधियार म ले अवाज ला सुनेव अऊ पहाड़ ह आगी ले बरत रिहिस, त तुम्हर गोत्रमन के जम्मो अगुवा अऊ तुम्हर मुखियामन मोर करा आईन। ");
INSERT INTO hne_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","अऊ तुमन कहेव, “यहोवा हमर परमेसर ह हमन ला अपन महिमा अऊ गौरव देखाय हवय, अऊ हमन आगी म ले ओकर अवाज सुने हन। आज हमन देखेंन कि यदि परमेसर ह मनखे ले गोठियाथे, तभो ले मनखे ह जीयत रह सकथे। ");
INSERT INTO hne_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","पर अब, हमन काबर मरन? ये भयंकर आगी ह हमन ला भसम कर दीही, अऊ यदि हमन यहोवा हमर परमेसर के अवाज फेर सुनबो, त हमन मर जाबो। ");
INSERT INTO hne_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","काबरकि कभू कोनो मरनहार मनखे ह परमेसर ला आगी म ले गोठियावत ओकर अवाज ला सुनके जीयत हवय, जइसे कि हमन जीयत हन? ");
INSERT INTO hne_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","एकरसेति तें लकठा म जा अऊ ओ जम्मो बात ला सुन, जेला यहोवा हमर परमेसर ह कहत हे। तब जऊन बात यहोवा हमर परमेसर ह तोला बताथे, ओ बात हमन ला बता। हमन सुनबो अऊ ओकर पालन करबो।” ");
INSERT INTO hne_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","यहोवा ह तुम्हर बात ला सुनिस, जब तुमन मोर ले गोठियावत रहेव, अऊ तब यहोवा ह मोला कहिस, “ये मनखेमन जऊन बात तोर ले कहिन, मेंह ओला सुनेंव। जऊन बात ओमन कहिन, ओह बने बात ए। ");
INSERT INTO hne_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","बने होही कि ओमन के मन ह अइसने ही रहय अऊ ओमन गंभीरता से मोर भय मानंय अऊ हमेसा मोर जम्मो हुकूम ला मानंय, ताकि ओमन अऊ ओमन के लइकामन संग हमेसा भलई होवय! ");
INSERT INTO hne_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“जा, अऊ ओमन ला कह कि ओमन अपन तम्बू म लहुंट जावंय। ");
INSERT INTO hne_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","पर तें इहां मोर संग रूक, ताकि मेंह तोला ओ जम्मो हुकूम, बिधि अऊ कानून बता सकंव, जेला तेंह ओमन ला सिखाबे कि ओमन ओ देस म येकर पालन करंय, जेला मेंह ओमन के अधिकार म देवत हंव।” ");
INSERT INTO hne_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","एकरसेति सचेत होके ओ काममन ला करव, जेकर हुकूम यहोवा तुम्हर परमेसर ह तुमन ला दे हवय; येकर ले न तो जेवनी मुड़व अऊ न ही डेरी। ");
INSERT INTO hne_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ओ जम्मो बात के पालन करत चलव, जेकर हुकूम यहोवा तुम्हर परमेसर ह तुमन ला दे हवय, ताकि तुमन जीयत रहव अऊ तुम्हर उन्नति होवय अऊ तुमन ओ देस म बहुंत समय तक बने रहव, जेला तुमन अपन अधिकार म करहू। ");
INSERT INTO hne_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","येमन ओ हुकूम, बिधि अऊ कानून अंय, जेमन ला सिखाय के निरदेस यहोवा तुम्हर परमेसर ह मोला देय हवय कि तुमन ओ देस म येमन के पालन करव, जिहां अधिकार करे बर तुमन यरदन के ओ पार जावत हव, ");
INSERT INTO hne_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ताकि तुमन, तुम्हर लइकामन अऊ ओमन के बाद ओमन के लइकामन यहोवा अपन परमेसर के भय मानंय। जब तक तुमन मोर दिये जम्मो बिधि अऊ कानूनमन ला मानत रहिहू, तुमन लम्बा जिनगी के आनंद उठाहू। ");
INSERT INTO hne_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","हे इसरायलीमन, सुनव अऊ धियान से हुकूममन के पालन करव, ताकि तुम्हर भलई होवय अऊ तुम्हर संखिया ह ओ देस म बहुंत बढ़य, जिहां दूध अऊ मंधरस के भरमार हे, जइसे कि यहोवा, तुम्हर पुरखामन के परमेसर ह तुम्हर ले वायदा करे हवय। ");
INSERT INTO hne_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","हे इसरायलीमन, सुनव: यहोवा हमर परमेसर अय, यहोवा ह एके झन परभू अय। ");
INSERT INTO hne_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","यहोवा अपन परमेसर ले अपन पूरा हिरदय अऊ अपन पूरा परान अऊ अपन पूरा सक्ति ले मया करव। ");
INSERT INTO hne_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","ये हुकूम, जेमन ला आज मेंह तुमन ला देवत हंव, येमन तुम्हर हिरदय म रहंय। ");
INSERT INTO hne_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","येमन ला अपन लइकामन ला सिखावव। जब तुमन घर म बईठथव अऊ डहार म रेंगथव, जब तुमन लेटथव अऊ उठथव, त येमन ला सिखाय करव। ");
INSERT INTO hne_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","चिनहां के रूप म येमन ला अपन हांथ म बांध लव अऊ येमन ला अपन माथा म बांध लव। ");
INSERT INTO hne_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","येमन ला अपन घर के चौखटमन म अऊ अपन दुवारमन म लिखव। ");
INSERT INTO hne_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","जब यहोवा तुम्हर परमेसर ह तुमन ला ओ देस म लानथे, जेला ओह तुम्हर पुरखा, अब्राहम, इसहाक अऊ याकूब ला देय के सपथ खाय हवय—एक अइसने देस, जेमा बड़े-बड़े अऊ उन्नत सहरमन हवंय, जेला तुमन नइं बनाय हव, ");
INSERT INTO hne_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","अइसने घरमन, जेमा जम्मो किसम के बने चीजमन भरे हवंय, जेला तुमन नइं दे हव, कुआंमन जेला तुमन नइं कोड़े हव, अऊ अंगूर के बारी अऊ जैतून के छोटे जंगलमन, जेला तुमन नइं लगाय हव—तब जब तुमन येमन ला खाथव अऊ तुम्हर पेट ह भर जाथे, ");
INSERT INTO hne_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","त सचेत रहव कि तुमन यहोवा ला झन भूलव, जऊन ह तुमन ला मिसर देस याने कि गुलामी के देस ले निकाल लानिस। ");
INSERT INTO hne_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","यहोवा अपन परमेसर के भय मानव, सिरिप ओकरेच सेवा करव अऊ ओकर नांव म सपथ लेवव। ");
INSERT INTO hne_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","आने देवतामन के पाछू झन जावव याने कि ओ मनखेमन के देवता, जेमन तुम्हर चारों कोति हवंय; ");
INSERT INTO hne_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","काबरकि यहोवा तुम्हर परमेसर, जऊन ह तुम्हर बीच म हवय, ओह जलन रखनेवाला परमेसर ए अऊ ओकर कोप ह तुम्हर बिरूध भड़कही, अऊ ओह तुमन ला धरती ऊपर ले नास कर दीही। ");
INSERT INTO hne_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","तुमन यहोवा अपन परमेसर के परिछा झन करव, जइसे कि तुमन मस्सा म करे रहेव। ");
INSERT INTO hne_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","धियान देके ओ हुकूम, निरदेस अऊ बिधिमन ला मानव, जेला यहोवा तुम्हर परमेसर ह तुमन ला दे हवय। ");
INSERT INTO hne_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","यहोवा के नजर म ओ काम करव, जऊन ह सही अऊ बने अय, ताकि तुम्हर भलई होवय अऊ तुमन जाके ओ उत्तम देस के ऊपर अधिकार कर सकव, जेकर सपथ यहोवा ह तुम्हर पुरखामन ले खाय हवय, ");
INSERT INTO hne_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","तुम्हर जम्मो बईरीमन तुम्हर आघू ले भगा दिये जाहीं, जइसे कि यहोवा ह कहिसे। ");
INSERT INTO hne_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","भविस्य म, जब तुम्हर लइकामन तुम्हर ले पुछहीं, “ओ निरदेस, बिधि अऊ कानूनमन के का मतलब ए, जेला माने के हुकूम यहोवा हमर परमेसर ह तुमन ला दे हवय?” ");
INSERT INTO hne_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","त ओमन ला बतावव: “हमन मिसर देस म फिरौन के गुलाम रहेंन, पर यहोवा ह अपन सक्तिसाली हांथ ले हमन ला मिसर देस ले बाहिर निकाल लानिस। ");
INSERT INTO hne_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","हमर आंखी के आघू म यहोवा ह मिसर म फिरौन अऊ ओकर जम्मो परिवार ला बड़े-बड़े अऊ भयंकर चिनहां अऊ चमतकार देखाईस। ");
INSERT INTO hne_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ओह हमन ला उहां ले निकालके ओ देस म लानिस, जेला हमन ला देय के सपथ ओह हमर पुरखामन ले खाय रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","यहोवा ह हमन ला ये जम्मो बिधिमन ला पालन करे के अऊ यहोवा हमर परमेसर के भय माने के हुकूम दीस, ताकि हमन हमेसा उन्नति करन अऊ जीयत रहन, जइसे कि आज के दिन म दिखत हे। ");
INSERT INTO hne_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","अऊ यदि हमन धियान देके ये जम्मो कानून ला यहोवा हमर परमेसर के आघू म मानथन, जइसे कि ओह हमन ला हुकूम दे हवय, त ओह हमर धरमीपन होही।” ");
INSERT INTO hne_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","जब यहोवा तुम्हर परमेसर ह तुमन ला ओ देस म ले आथे, जेला तुमन अधिकार करइया हव अऊ यहोवा ह तुम्हर आघू ले कतको जाति—याने कि हित्ती, गिरगासी, अमोरी, कनानी, परिज्जी, हिब्बी अऊ यबूसी जाति के मनखेमन ला भगा देथे; ये सात जाति के मनखे जेमन तुम्हर ले गनती म जादा अऊ बलवान हवंय— ");
INSERT INTO hne_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","अऊ जब यहोवा तुम्हर परमेसर ह ओमन ला तुम्हर हांथ म कर देथे अऊ तुमन ओमन ला हरा दव, तब ये जरूरी अय कि तुमन ओमन ला पूरा नास कर दव। ओमन के संग कोनो करार झन करव, अऊ ओमन ऊपर दया झन करव। ");
INSERT INTO hne_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ओमन के संग सादी-बिहाव घलो झन करव। न अपन बेटीमन ला ओमन के बेटामन बर दव अऊ न ही ओमन के बेटीमन ला अपन बेटामन बर लानव, ");
INSERT INTO hne_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","काबरकि ओमन तुम्हर लइकामन ला मोर पाछू चले से भटका दीहीं अऊ आने देवता के सेवा करे बर कहिहीं, अऊ तब यहोवा के कोरोध ह तुम्हर ऊपर भड़कही अऊ तुमन ला तुरते नास कर दीही। ");
INSERT INTO hne_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","तुमन ला ओमन के संग ये करना हे: ओमन के बेदीमन ला टोरके गिरा दव, ओमन के पबितर पथरामन ला कुटा-कुटा कर दव, ओमन के असेरा के खंभामन ला काट डारव अऊ ओमन के मूरतीमन ला आगी म जला दव। ");
INSERT INTO hne_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","काबरकि तुमन यहोवा तुम्हर परमेसर बर एक पबितर जाति के मनखे अव। यहोवा तुम्हर परमेसर ह धरती के जम्मो जाति ले तुम्हर जाति ला चुने हवय ताकि तुमन ओकर मनखे, ओकर निज भाग ठहिरव। ");
INSERT INTO hne_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","यहोवा ह तुम्हर ऊपर अपन मया देखाके तुमन ला एकरसेति नइं चुनिस कि तुमन आने जातिमन के मनखेमन ले गनती म जादा रहेव; वास्तव म तुमन जम्मो जातिमन ले गनती म बहुंत कम रहेव। ");
INSERT INTO hne_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","पर येह एकरसेति होईस काबरकि यहोवा ह तुमन ले मया करिस अऊ ओ सपथ ला पूरा करिस, जेला ओह तुम्हर पुरखामन ले खाय रिहिस कि ओह तुमन ला अपन सक्तिसाली हांथ के दुवारा बंधुवई के देस ले याने कि मिसर देस के राजा फिरौन के सक्ति ले छोंड़ाईस। ");
INSERT INTO hne_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","एकरसेति तुमन जानव कि यहोवा तुम्हर परमेसर ह परमेसर ए; ओह बिसवासयोग्य परमेसर ए, जऊन ह अपन मया के करार ला ओमन के संग हजार पीढ़ी तक बनाय रखथे, जेमन ओकर ले मया करथें अऊ ओकर हुकूममन ला मानथें। ");
INSERT INTO hne_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","पर जऊन मन ओकर ले घिन करथें, ओह ओमन ला नास करके ओमन के आघू म ही ओमन ले बदला लीही; ओह ओमन ले बदला लेय म देरी नइं करही, जेमन ओकर ले घिन करथें। ");
INSERT INTO hne_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","एकरसेति, ओ हुकूम, बिधि अऊ कानूनमन ला माने बर धियान लगावव, जेला मेंह आज तुमन ला देवत हंव। ");
INSERT INTO hne_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","यदि तुमन ये कानूनमन ऊपर धियान देथव अऊ मन लगाके ओमन के पालन करथव, त यहोवा तुम्हर परमेसर ह अपन मया के करार ला तुम्हर संग बनाय रखही, जइसे कि ओह तुम्हर पुरखामन संग सपथ खाय रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","ओह तुमन ला मया करही अऊ तुमन ला आसीस दीही अऊ तुम्हर संखिया ला बढ़ाही। ओह तुम्हर गरभ के फर, तुम्हर भुइयां के ऊपज—तुम्हर अनाज, नवां अंगूर के मंद अऊ जैतून तेल अऊ तुम्हर बरदी के बछवा अऊ मेढ़ा-पीलामन ला ओ देस म आसीस दीही, जेला देय के परतिगियां ओह तुम्हर पुरखामन ले करे रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","तुमन कोनो आने जाति के मनखेमन ले जादा आसीसित होहू; तुम्हर कोनो भी आदमी या माईलोगन बांझ नइं होही, अऊ न ही तुम्हर पसु-धन म पीलामन के कमी होही। ");
INSERT INTO hne_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","यहोवा ह तुमन ला हर एक बेमारी ले दूरिहा रखही। ओह तुम्हर ऊपर ओ भयंकर बेमारीमन ला नइं लानही, जेला तुमन मिसर देस म देखे रहेव, पर ओह ये बेमारीमन ला ओ जम्मो झन ऊपर लानही, जेमन तुम्हर ले घिन करथें। ");
INSERT INTO hne_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","जरूरी ए कि तुमन ओ जम्मो जाति के मनखेमन ला नास कर दव, जेमन ला यहोवा तुम्हर परमेसर ह तुमन ला दे देथे। ओमन ऊपर दया झन करव अऊ ओमन के देवतामन के सेवा झन करव, काबरकि ओह तुम्हर बर एक फांदा होही। ");
INSERT INTO hne_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","तुमन अपनआप ले कह सकत हव, “ये जातिमन तो हमर ले बलवान हवंय। हमन येमन ला कइसे भगा सकत हन?” ");
INSERT INTO hne_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","पर ओमन ले झन डरव; बने करके सुरता करव कि यहोवा तुम्हर परमेसर ह फिरौन अऊ जम्मो मिसर देस के संग का करिस। ");
INSERT INTO hne_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","तुमन अपन आंखी ले ओ बड़े-बड़े बिपत्ति, चिनहां अऊ अद्भूत काम, सक्तिसाली हांथ अऊ बढ़ाय हुए बाहां ला देखे हव, जेकर दुवारा यहोवा तुम्हर परमेसर ह तुमन ला बाहिर निकालिस। यहोवा तुम्हर परमेसर ह ओ जम्मो मनखेमन के संग वइसने ही करही, जेमन ले तुमन अब डरत हव। ");
INSERT INTO hne_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","येकर अलावा, यहोवा तुम्हर परमेसर ह ओमन के बीच म तब तक दतैया पठोही, जब तक कि ओ बांचे मनखेमन नास नइं हो जाहीं, जेमन कि तुम्हर ले छिपे होहीं। ");
INSERT INTO hne_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","ओमन ले भयभीत झन होवव, काबरकि यहोवा तुम्हर परमेसर, जऊन ह तुम्हर बीच म हवय, ओह महान अऊ अद्भूत परमेसर अय। ");
INSERT INTO hne_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","यहोवा तुम्हर परमेसर ह ओ जाति-जाति के मनखेमन ला धीरे-धीरे करके तुम्हर आघू ले भगा दीही। ओमन ला तुरते भगाय के अनुमति तुमन ला नइं होही, नइं तो तुम्हर चारों कोति जंगली पसुमन बहुंत बढ़ जाहीं। ");
INSERT INTO hne_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","पर यहोवा तुम्हर परमेसर ह ओमन ला तुम्हर हांथ म सऊंप दीही अऊ ओमन के बीच म अइसने गड़बड़ी कर दीही कि ओमन नास हो जाहीं। ");
INSERT INTO hne_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ओह ओमन के राजामन ला तुम्हर हांथ म कर दीही, अऊ तुमन धरती म ओमन के नांव मिटा दूहू। अइसने कोनो नइं होही, जऊन ह तुम्हर सामना कर सकय; तुमन ओमन ला नास कर दूहू। ");
INSERT INTO hne_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","तुमन ला ओमन के देवतामन के मूरती ला आगी म जला देना हे। ओमन के सोन अऊ चांदी के लालच झन करहू, अऊ ओला अपन बर झन लूहू, नइं तो तुमन ओकर दुवारा फंस जाहू, काबरकि येह यहोवा तुम्हर परमेसर बर घिनौना चीज अय। ");
INSERT INTO hne_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","अपन घर म कोनो घिनौना चीज ला झन लानव, नइं तो तुमन ला घलो ओकर सहीं बिनास बर अलग रखे जाही। येला नीच या खराप चीज समझव अऊ येकर ले बहुंत घिन करव, काबरकि येला बिनास बर अलग करे जाथे। ");
INSERT INTO hne_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","आज मेंह तुमन ला जऊन हुकूम देवत हंव, धियान देके तुमन ओमन के पालन करव, ताकि तुमन जीयत रहव अऊ संखिया म बढ़व अऊ ओ देस म जाके ओकर ऊपर अधिकार कर लेवव, जेकर परतिगियां यहोवा ह सपथ खाके तुम्हर पुरखामन ले करे रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","सुरता रखव कि कइसे यहोवा तुम्हर परमेसर ह पूरा रसता म ये चालीस साल तक सुन्ना जगह म तुम्हर अगुवई करिस अऊ ओह ये जाने बर तुमन ला नम्र करिस अऊ परखिस कि तुम्हर मन म का हवय, तुमन ओकर हुकूममन ला मानहू या नइं। ");
INSERT INTO hne_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","ओह तुमन ला भूखा रखके नम्र करिस अऊ फेर तुमन ला मन्ना खवाईस, जेकर बारे म न तो तुमन अऊ न ही तुम्हर पुरखामन जानत रिहिन; ओह तुमन ला ये सिखाय बर घलो नम्र करिस कि मनखे ह सिरिप रोटी ले ही जीयत नइं रहय, फेर हर ओ बचन जऊन ह यहोवा के मुहूं ले निकलथे जीयत रहिही। ");
INSERT INTO hne_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","ये चालीस साल के दौरान तुम्हर कपड़ामन न तो फटिन अऊ न ही तुम्हर गोड़मन थकके फूलिन। ");
INSERT INTO hne_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","तब अपन मन म जान लेवव कि जइसे एक मनखे ह अपन बेटा ला अनुसासित करथे, वइसे ही यहोवा तुम्हर परमेसर ह तुमन ला अनुसासित करथे। ");
INSERT INTO hne_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","यहोवा अपन परमेसर के हुकूम ला मानव, ओकर हुकूम के मुताबिक चलव अऊ ओकर आदर करव। ");
INSERT INTO hne_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","काबरकि यहोवा तुम्हर परमेसर ह तुमन ला एक उत्तम देस म ले जावत हे—एक अइसने देस जिहां घाटी अऊ पहाड़ीमन ले पानी के नाला, नरवा अऊ गहिरा सोतामन निकलत हें; ");
INSERT INTO hne_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","एक अइसने देस जिहां गहूं, जौ, अंगूर के नार, अंजीर के रूख, अनार, जैतून तेल अऊ मंधरस हवय; ");
INSERT INTO hne_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","एक अइसने देस जिहां जेवन के कमी नइं होही अऊ तुमन ला कोनो चीज के घटी नइं होही; एक अइसने देस जिहां चट्टान म लोहा हवय अऊ तुमन पहाड़ीमन ला खनके तांबा निकाल सकत हव। ");
INSERT INTO hne_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","जब तुमन जी भरके खा लेवव, त यहोवा अपन परमेसर के ओ उत्तम देस बर परसंसा करव, जेला ओह तुमन ला देय हवय। ");
INSERT INTO hne_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","ये बात के खियाल रखव कि मेंह तुमन ला आज ओकर जऊन हुकूम, कानून अऊ बिधिमन ला देवत हंव, ओमन ला नइं मानके यहोवा अपन परमेसर ला झन भूलव। ");
INSERT INTO hne_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","नइं तो, जब तुमन जी भरके खाथव, जब तुमन सुघर घर बनाथव अऊ रहे लगथव, ");
INSERT INTO hne_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","अऊ जब तुम्हर गाय-बईला अऊ भेड़-बकरी के झुंड ह बहुंत बढ़थे अऊ तुम्हर सोन अऊ चांदी ह बढ़थे अऊ तुम्हर जम्मो चीज म बढ़ोतरी होथे, ");
INSERT INTO hne_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","त तुम्हर मन ह घमंडी हो जाही अऊ तुमन यहोवा अपन परमेसर ला भुला जाहू, जऊन ह तुमन ला मिसर देस ले, याने कि बंधुवई के देस ले बाहिर निकाल लानिस। ");
INSERT INTO hne_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","ओह तुमन ला ओ बड़े अऊ भयानक निरजन प्रदेस म ले आईस, जिहां पानी के कमी अऊ सूखा भुइयां रिहिस, जिहां जहरिला सांप अऊ बिच्छूमन रिहिन। ओह तुम्हर बर कठोर चट्टान म ले पानी निकालिस। ");
INSERT INTO hne_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ओह निरजन प्रदेस म तुमन ला खाय बर मन्ना दीस, जेकर बारे म तुम्हर पुरखामन नइं जानत रिहिन; ओह ये सब तुमन ला नम्र करे बर अऊ तुमन ला परखे बर करिस ताकि आखिरी म ये सब के दुवारा तुम्हर भलई होवय। ");
INSERT INTO hne_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","तुमन अपनआप ले कह सकत हव, “मोर सक्ति अऊ मोर हांथ के ताकत ले मेंह मोर बर ये संपत्ति बनाय हवंव।” ");
INSERT INTO hne_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","पर यहोवा अपन परमेसर ला सुरता रखव, काबरकि येह ओहीच अय, जऊन ह तुमन ला संपत्ति बनाय के योग्यता देथे, अऊ ये किसम ले ओह अपन करार ला मजबूत करथे, जेला ओह तुम्हर पुरखामन संग सपथ खाके करे रिहिस, जइसे कि येह आज दिखत हे। ");
INSERT INTO hne_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","कहूं तुमन कभू यहोवा अपन परमेसर ला भुला जावव अऊ आने देवतामन के पाछू चलव अऊ ओमन के अराधना अऊ दंडवत करव, त मेंह आज तुमन ला चेताके कहत हंव कि खचित तुमन नास हो जाहू। ");
INSERT INTO hne_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","जइसे कि यहोवा ह जाति-जाति के ओ मनखेमन ला तुम्हर आघू ले नास कर दे रिहिस, वइसे ही तुमन घलो यहोवा अपन परमेसर के हुकूम नइं माने के कारन नास हो जाहू। ");
INSERT INTO hne_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","हे इसरायलीमन, सुनव: तुमन अब यरदन नदी के ओ पार जाके ओ जाति-जाति के मनखेमन ला बेदखल करनेचवाला हव, जेमन तुम्हर ले बड़े अऊ बलवान हें, जेमन के बड़े-बड़े सहर हवंय अऊ ओ सहर म ऊंचहा-ऊंचहा दीवार हवंय। ");
INSERT INTO hne_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","उहां मनखेमन बलवान अऊ ऊंचहा-ऊंचहा हवंय—ओमन अनाकी अंय। तुमन ओमन के बारे म जानत हव अऊ ओमन के बारे म ये बात सुने हव: “कोन ह अनाकीमन के सामना कर सकथे?” ");
INSERT INTO hne_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","पर तुमन आज ये बात ला जान लेवव कि यहोवा तुम्हर परमेसर ही ओ अय, जऊन ह एक भसम करइया आगी सहीं तुम्हर आघू ओ पार जाही। ओह ओमन ला नास कर दीही; ओह ओमन ला तुम्हर आघू म दबा दीही। अऊ तुमन ओमन ला भगा दूहू अऊ तुरते ओमन के बिनास कर दूहू, जइसे कि यहोवा ह तुम्हर ले वायदा करे हवय। ");
INSERT INTO hne_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","जब यहोवा तुम्हर परमेसर ह ओमन ला तुम्हर आघू ले भगा दीही, त तुमन अपनआप ले ये झन कहव, “मोर धरमीपन के कारन यहोवा ह मोला इहां ये देस ऊपर अधिकार करे बर लाने हवय।” काबरकि सच तो ये अय कि ये जातिमन के दुस्टता के कारन यहोवा ह येमन ला तुम्हर आघू ले भगानेवाला हे। ");
INSERT INTO hne_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","तुमन अपन धरमीपन अऊ ईमानदारी के कारन ओमन के देस ऊपर अधिकार करे बर नइं जावत हव; पर ये जातिमन के दुस्टता के कारन यहोवा तुम्हर परमेसर ओमन ला तुम्हर आघू ले भगाही ताकि ओ बात पूरा होवय, जेकर सपथ ओह तुम्हर पुरखा अब्राहम, इसहाक अऊ याकूब ले खाय रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","एकरसेति ये बात ला समझ लव कि तुम्हर धरमीपन के कारन यहोवा तुम्हर परमेसर ह तुमन ला ये देस तुम्हर अधिकार म नइं देवत हे, काबरकि तुमन एक ढीठ जाति के मनखे अव। ");
INSERT INTO hne_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","ये बात ला सुरता रखव अऊ कभू झन भूलव कि सुन्ना जगह म तुमन कइसे यहोवा तुम्हर परमेसर के कोरोध ला भड़कावत रहेव। मिसर देस ला छोंड़े के दिन ले लेके इहां हबरे के दिन तक, तुमन यहोवा के बिरूध बिदरोह करत आय हवव। ");
INSERT INTO hne_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","होरेब करा घलो तुमन यहोवा के कोरोध ला भड़कायेव; ओह अतेक गुस्सा होईस कि तुमन ला नास कर देतिस। ");
INSERT INTO hne_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","जब मेंह पथरा के पटिया, ओ करार के पटियामन ला लेय बर पहाड़ ऊपर गेंव, जेला यहोवा ह तुम्हर संग करे रिहिस, त मेंह पहाड़ ऊपर चालीस दिन अऊ चालीस रात तक रहेंव; मेंह न तो जेवन करेंव अऊ न ही पानी पीयेंव। ");
INSERT INTO hne_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","यहोवा ह मोला दू ठन पथरा के पटिया दीस, जेमा परमेसर ह अपन अंगरी ले लिखे रिहिस। ओमा ओ जम्मो हुकूममन लिखाय रिहिन, जेला यहोवा ह पहाड़ ऊपर आगी म होके सभा के दिन तुमन ला बताय रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","चालीस दिन अऊ चालीस रात के आखिरी म यहोवा ह मोला ओ दू ठन पथरा के पटियामन ला दीस, जेमन करार के पटिया रिहिन। ");
INSERT INTO hne_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","तब यहोवा ह मोला कहिस, “तें इहां ले तुरते खाल्हे उतर, काबरकि तोर मनखेमन बिगड़ गे हवंय, जेमन ला तें मिसर देस ले निकालके लाने हस। ओमन ओ रसता ला बहुंत जल्दी छोंड़ दे हवंय, जेकर हुकूम मेंह ओमन ला दे रहेंव अऊ ओमन अपन बर एक मूरती बना ले हवंय।” ");
INSERT INTO hne_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","फेर यहोवा ह मोला ये घलो कहिस, “मेंह ये मनखेमन ला देखे हंव, अऊ येमन असल म एक हठीला जाति के मनखे अंय! ");
INSERT INTO hne_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","मोला अकेला छोंड़ दे, ताकि मेंह ओमन ला नास कर देवंव अऊ धरती ऊपर ले ओमन के नांव ला मिटा देवंव। अऊ मेंह तोर ले एक जाति बनाहूं, जऊन ह ओमन ले जादा सक्तिसाली अऊ संखिया म ओमन ले जादा होही।” ");
INSERT INTO hne_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","तब मेंह मुड़ें अऊ पहाड़ ले खाल्हे उतरेंव जबकि पहाड़ ह आगी ले धधकत रिहिस। अऊ करार के ओ दूनों पटिया मोर हांथ म रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","तब मेंह देखेंव कि तुमन यहोवा अपन परमेसर के बिरूध पाप करे रहेव; तुमन बछवा के आकार म एक ठन मूरती बना ले रहेव। तुमन ओ रसता ला बहुंत जल्दी छोंड़ दे रहेव, जेकर हुकूम यहोवा ह तुमन ला दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","एकरसेति मेंह ओ दूनों पटिया ला मोर हांथ ले फटिक देंव, अऊ ओमन ला तुम्हर आंखी के आघू म टोरके कुटा-कुटा कर देंव। ");
INSERT INTO hne_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","तब तुम्हर करे गय ओ जम्मो पाप के कारन, जऊन ह यहोवा के नजर म बुरई रिहिस अऊ जेकर ले ओकर गुस्सा ह भड़किस, मेंह फेर एक बार यहोवा के आघू म चालीस दिन अऊ चालीस रात सीधा पड़े रहेंव; मेंह न तो जेवन करेंव अऊ न ही पानी पीयेंव। ");
INSERT INTO hne_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","मेंह यहोवा के कोरोध अऊ कोप ले डरत रहेंव, काबरकि ओह अतेक गुस्सा म रिहिस कि तुमन ला नास करे चाहत रिहिस। पर एक बार फेर यहोवा ह मोर बात ला सुनिस। ");
INSERT INTO hne_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","अऊ यहोवा ह हारून ऊपर अतेक गुस्सा होईस कि ओला नास करे चाहत रिहिस, पर ओ समय मेंह हारून बर घलो पराथना करेंव। ");
INSERT INTO hne_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","मेंह तुम्हर ओ पापमय चीज—ओ बछवा ला लेंव, जेला तुमन बनाय रहेव, अऊ ओला आगी म जला देंव। तब मेंह ओला कुचर देंव अऊ ओला चूर-चूर करके धुर्रा सहीं कर देंव अऊ ओ धुर्रा ला एक ठन नरवा म फटिक देंव, जऊन ह पहाड़ ले खाल्हे बहत रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","तुमन यहोवा ला तबेरा, मस्सा अऊ किबरोत-हतावा म घलो गुस्सा दिलाय रहेव। ");
INSERT INTO hne_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","अऊ जब यहोवा ह तुमन ला कादेस-बरने ले भेजिस, त ओह कहिस, “जावव अऊ ओ देस ऊपर अधिकार कर लेवव, जेला में तुमन ला दे हवंव।” पर तुमन यहोवा तुम्हर परमेसर के बिरूध बिदरोह करेव। तुमन न तो ओकर ऊपर भरोसा करेव अऊ न ही ओकर बात मानेव। ");
INSERT INTO hne_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","जब ले में तुमन ला जानत हंव, तब ले तुमन यहोवा के बिरूध बिदरोह ही करत आय हवव। ");
INSERT INTO hne_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","मेंह ओ चालीस दिन अऊ चालीस रात यहोवा के आघू म मुहूं-भरसा पड़े रहेंव काबरकि यहोवा ह कहे रिहिस कि ओह तुमन ला नास कर दीही। ");
INSERT INTO hne_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","में यहोवा ले पराथना करके कहेंव, “हे परमपरधान यहोवा, अपन मनखेमन ला नास झन कर; येमन तोर निज भाग अंय, जेमन ला तेंह अपन बड़े सामर्थ से छोंड़ाय हस अऊ अपन सक्तिसाली हांथ से येमन ला मिसर देस ले निकाल लाने हस। ");
INSERT INTO hne_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","अपन सेवक अब्राहम, इसहाक अऊ याकूब ला सुरता कर। ये मनखेमन के हठीलापन, ओमन के दुस्टता अऊ ओमन के पाप ला अनदेखी कर। ");
INSERT INTO hne_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","नइं तो, जऊन देस ले तेंह हमन ला निकालके लाने हस, उहां के मनखेमन कहिहीं, ‘काबरकि यहोवा ह ओमन ला ओ देस म नइं ले जा सकिस, जेकर परतिगियां ओह ओमन ले करे रिहिस, अऊ काबरकि ओह ओमन ले घिन करिस, एकरसेति ओह ओमन ला बाहिर निकालिस ताकि निरजन प्रदेस म ओमन ला मार डारय।’ ");
INSERT INTO hne_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","पर ओमन तोर मनखे अंय, तोर निज भाग, जेमन ला तें अपन बड़े सामर्थ अऊ अपन बढ़ाय भुजा के दुवारा निकालके ले आय।” ");
INSERT INTO hne_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","ओ बेरा यहोवा ह मोला कहिस, “पहिली के पटियामन सहीं दू ठन पथरा के पटिया काटके बना ले अऊ मोर करा पहाड़ ऊपर आ। अऊ लकड़ी के एक ठन सन्दूक घलो बना। ");
INSERT INTO hne_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","में ये पटियामन म ओ बचनमन ला फेर लिख दूहूं, जेमन पहिली के पटियामन म रिहिन, जेमन ला तें टोर देय। तब तें ओ पटियामन ला सन्दूक म रख देबे।” ");
INSERT INTO hne_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","तब में बंबरी लकड़ी के एक सन्दूक बनांय अऊ पहिली सहीं काटके पथरामन के दू ठन पटिया बनांय, अऊ दूनों पटियामन ला हांथ म धरके में पहाड़ ऊपर गेंव। ");
INSERT INTO hne_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","यहोवा ह ओ पटियामन म ओ बातमन ला लिख दीस, जेला ओह पहिली के पटियामन म लिखे रिहिस—ओ दस हुकूम, जेला ओह सभा के दिन पहाड़ ऊपर आगी म ले कहे रिहिस। अऊ यहोवा ह ओ पटियामन ला मोला दे दीस। ");
INSERT INTO hne_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","तब में पहाड़ ले खाल्हे उतरेंव अऊ ओ पटियामन ला मेंह ओ सन्दूक म रख देंव, जेला में बनाय रहेंव, जइसे कि यहोवा ह मोला हुकूम देय रिहिस, अऊ ओमन अब उहां हवंय। ");
INSERT INTO hne_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(तब इसरायलीमन बेने-जाकन के कुआंमन ले आघू बढ़के मोसेरा करा आईन। उहां हारून मर गीस अऊ ओला उहां माटी दिये गीस, अऊ ओकर जगह म ओकर बेटा एलिआजर ह पुरोहित के रूप म सेवा करे लगिस। ");
INSERT INTO hne_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","उहां ले ओमन गुदगोदा अऊ गुदगोदा ले योतबाता आईन, जऊन ह पानी के सोतामन के एक देस रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","ओ समय यहोवा ह लेवी के गोत्र ला अलग करिस ताकि ओमन यहोवा के करार के सन्दूक ला उठाके ले जावंय; यहोवा के सेवा करे बर ओकर आघू म ठाढ़ रहंय अऊ ओकर नांव म आसीस देवंय, जइसे कि ओमन आज घलो करथें। ");
INSERT INTO hne_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","एकरे कारन लेवीमन ला ओमन के संगी इसरायलीमन के संग कोनो बांटा या भाग नइं मिलिस; यहोवा ह ओमन के निज भाग ए, जइसे कि यहोवा तुम्हर परमेसर ह ओमन ला कहिस।) ");
INSERT INTO hne_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","मेंह पहिले सहीं पहाड़ ऊपर चालीस दिन अऊ चालीस रात रूके रहेंव, अऊ यहोवा ह ये समय घलो मोर बात ला सुनिस। तुमन ला नास करे के अपन ईछा ला छोंड़ दे रिहिस। ");
INSERT INTO hne_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","तब यहोवा ह मोला कहिस, “जा अऊ मनखेमन ला ओमन के रसता म अगुवई कर, ताकि ओमन ओ देस म जाके ओकर ऊपर अधिकार करंय, जेला देय के सपथ मेंह ओमन के पुरखामन ले खाय रहेंव।” ");
INSERT INTO hne_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","अऊ अब, हे इसरायलीमन, यहोवा तुम्हर परमेसर ह तुमन ले का चाहथे, ये कि सिरिप तुमन यहोवा अपन परमेसर के भय मानव, ओकर हुकूम म चलव, ओकर ले मया करव, यहोवा अपन परमेसर के सेवा अपन पूरा मन अऊ अपन पूरा आतमा ले करव, ");
INSERT INTO hne_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","अऊ यहोवा के हुकूम अऊ बिधिमन के पालन करव, जेला मेंह आज तुमन ला तुम्हर खुद के भलई बर देवत हंव? ");
INSERT INTO hne_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","अकास, अऊ त अऊ सबले ऊंच स्वरग, धरती अऊ येमा के हर एक चीज यहोवा तुम्हर परमेसर के अय। ");
INSERT INTO hne_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","तभो ले यहोवा ह तुम्हर पुरखामन ऊपर अपन लगाव बनाय रखिस अऊ ओमन ले मया करिस, अऊ ओह ओमन के संतान—तुमन ला जम्मो जाति के मनखेमन के बीच म ले चुनिस, जइसे कि येह आज हवय। ");
INSERT INTO hne_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","एकरसेति, अपन हिरदय के खतना करव, अऊ अब हठीला झन बने रहव। ");
INSERT INTO hne_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","काबरकि यहोवा तुम्हर परमेसर ह देवतामन के परमेसर अऊ परभूमन के परभू, महान परमेसर, सक्तिसाली अऊ अद्भूत परमेसर अय, जऊन ह कोनो भेदभाव नइं करय अऊ न ही घूस लेवय। ");
INSERT INTO hne_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","ओह अनाथ अऊ बिधवामन के बचाव करथे, अऊ तुम्हर बीच रहइया परदेसीमन ले ओह मया करथे, अऊ ओमन ला जेवन अऊ कपड़ा देथे। ");
INSERT INTO hne_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","अऊ तुमन घलो ओमन ले मया करव, जेमन परदेसी अंय, काबरकि तुमन खुद मिसर देस म परदेसी रहेव। ");
INSERT INTO hne_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","यहोवा अपन परमेसर के भय मानव अऊ ओकर सेवा करव। ओला कसके पकड़े रहव अऊ ओकर ही नांव म सपथ खावव। ");
INSERT INTO hne_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","येह ओ अय, जेकर तुमन परसंसा करथव; ओह तुम्हर परमेसर ए, जऊन ह तुम्हर बर ओ बड़े अऊ अद्भूत काममन ला करिस, जेला तुमन खुद अपन आंखी ले देखे हव। ");
INSERT INTO hne_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","जब तुम्हर पुरखामन मिसर देस म गीन, त ओमन सिरिप सत्तर मनखे ही रिहिन, पर अब यहोवा तुम्हर परमेसर ह तुमन ला अकास के तारामन सहीं बहुंत अकन कर दे हवय। ");
INSERT INTO hne_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","यहोवा अपन परमेसर ले मया करव अऊ ओकर मांग, ओकर बिधि, ओकर कानून अऊ ओकर हुकूममन ला हमेसा मानव। ");
INSERT INTO hne_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","आज सुरता रखव कि तुम्हर लइकामन ओ चीजमन ला न तो देखे हवंय न ही ओकर अनुभव करे हवंय—याने कि यहोवा तुम्हर परमेसर के अनुसासन, ओकर वैभव, ओकर सक्तिसाली हांथ, ओकर बढ़ाय गय भुजा ला; ");
INSERT INTO hne_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ओकर देखाय गय अद्भूत चिनहां अऊ मिसर देस के बीच म करे गय ओकर काम, जेला मिसर देस के राजा फिरौन अऊ ओकर जम्मो देस के संग करिस; ");
INSERT INTO hne_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","यहोवा ह मिसर देस के सेना, ओमन के घोड़ा अऊ रथमन के संग का करिस, जब ओमन तुम्हर पीछा करत रिहिन, त ओह लाल-समुंदर के पानी ले ओमन ला कइसे घबरा दीस अऊ कइसे यहोवा ह ओमन के सर्वनास कर दीस। ");
INSE