﻿USE sofia;
DROP TABLE IF EXISTS sofia.hmo_vpl;
CREATE TABLE hmo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hmo_vpl WRITE;
INSERT INTO hmo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Matamaia neganai Dirava ese guba bona tanobada ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tanobada be toana lasi bona anina lasi, bona dibura ese davara badana ia koua. Vadaeni Dirava ena Lauma be davara ena kopina latanai ia marere noho. ");
INSERT INTO hmo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Dirava ia gwau, “Diari ia vara namo.” Vadaeni, diari be ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dirava ese diari ia itaia, ia namo vadaeni, bona Dirava ese diari bona dibura ia hapararaia. ");
INSERT INTO hmo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Dirava ese diari ena ladana ia atoa Dina, bona dibura ena ladana ia atoa Hanuaboi. Adorahi ia ore, bona daba ia mai, be dina namba 1. ");
INSERT INTO hmo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ma Dirava ia gwau, “Gau ta ese davara badana ena ataiai do ia noho, henunai ranu bona ataiai ranu be gabu rua do idia noho totona.” ");
INSERT INTO hmo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bona Dirava ese gau ta ia karaia, henunai ia noho ranu bona ataiai ia noho ranu ia hapararaia totona. Vadaeni unai bamona ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dirava ese unai gau ena ladana ia atoa Guba. Adorahi ia ore, bona daba ia mai, be dina namba 2. ");
INSERT INTO hmo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ma Dirava ia gwau, “Guba henunai ia noho ranu be gabu tamona dekenai ia haboua be namo, bona tano kaukau do ia hedinarai.” Vadaeni unai bamona ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Dirava ese tano kaukau ena ladana ia atoa Tanobada, bona ia haboua gabu tamona ranu edia ladana ia atoa, Davara. Bona Dirava ese ia itaia, ia be namo vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ma Dirava ia gwau, “Tanobada dekenai rei ia vara be namo, bona ava idauidau mai edia uhe, bona anina idia atoa audia, edia huahua be mai uhe, ta ta edia orea, edia orea hegeregerena, tanobada ena latanai.” Vadaeni unai bamona ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Rei ia vara tanobada ena latanai, bona ava idauidau mai edia uhe edia orea hegeregerena, bona anina idia atoa audia, edia huahua be mai uhe, edia orea hegeregerena. Bona Dirava ese ia karaia gaudia ia itaia, be idia namo vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Adorahi ia ore, bona daba ia mai, be dina namba 3. ");
INSERT INTO hmo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ma Dirava ia gwau, “Diari do idia vara guba dekenai namo, dina bona hanuaboi do idia hapararaia totona. Bona do idia be toa, lahara bona laurabada ena toana, dina bona lagani edia toana. ");
INSERT INTO hmo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Guba dekenai do idia diari be namo, tanobada do idia hadiaria totona.” Vadaeni, inai bamona ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Bona Dirava ese diari badadia rua ia karaia, badana be dina do ia biagua, bona maragina be hanuaboi do ia naria. Hisiu danu ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dirava ese guba lalonai ia atodia, tanobada do idia hadiaria totona, ");
INSERT INTO hmo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","dina bona hanuaboi do idia biagua, bona diari bona dibura do idia hapararaia totona. Bona Dirava ese ia karaia gaudia ia itaia, be idia namo vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Adorahi ia ore, bona daba ia mai, be dina namba 4. ");
INSERT INTO hmo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ma Dirava ia gwau, “Davara ese mauri gaudia momo do idia havaraia namo, bona manu be tanobada ena ataiai kahana, guba ena henuna dekenai do idia roho.” ");
INSERT INTO hmo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Vadaeni, Dirava ese davara dekenai idia mauri gau badadia ia karaia, bona mauri gaudia ibounai ranu lalonai idia marere gaudia, ta ta edia orea, edia orea hegeregerena, ia karaia. Bona ataiai manudia ibounai danu, ta ta edia orea, edia orea hegeregerena. Bona Dirava ese ia karaia gaudia ia itaia, be idia namo vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bona Dirava ia hanamodia, ia gwau, “Emui bese umui havaraia, do umui momo herea, davara ibounai do idia honu momokani, manu danu do idia vara rohoroho tanobada ena latanai.” ");
INSERT INTO hmo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Adorahi ia ore, bona daba ia mai, be dina namba 5. ");
INSERT INTO hmo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ma Dirava ia gwau, “Tanobada ese mauri gaudia do ia havaraia namo, ta ta edia orea, edia orea hegeregerena, boromakau, bona tano dekenai idia rau gaudia, bona tanobada boroma idauidau, ta ta edia orea, edia orea hegeregerena.” Vadaeni unai bamona ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Dirava ese tanobada ena boroma bona dagedage gaudia idauidau ia karaia, ta ta edia orea, edia orea hegeregerena, bona boromakau, bona ubua gaudia, ta ta edia orea, edia orea hegeregerena, bona tanobada dekenai idia rau gaudia ibounai, ta ta edia orea, edia orea hegeregerena. Dirava ese ia karaia gaudia ia itaia, be idia namo vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Bona Dirava ma ia gwau, “Taunimanima ita karaia namo, iseda toana bona iseda laulau hegeregerena. Davara gwarume bona ataiai manudia bona boromakau, bona tano dekenai idia rau gaudia ibounai, ia ese do ia biagua.” ");
INSERT INTO hmo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Vadaeni Dirava ese taunimanima ia karaia, ia sibona ena laulau bamona, Dirava ena toana hegeregerena ia karaia. Tau bona hahine ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Bona Dirava ese ia hanamodia, idia dekenai ia gwau, “Emui bese do umui havaraia, do umui momo herea. Tanobada ena gabu ibounai dekenai do umui noho, bona unai tano do umui biagua. Davara ena gwarume bona ataiai manudia, bona mauri gaudia, tanobada dekenai idia marere gaudia ibounai do umui biagua.” ");
INSERT INTO hmo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ma Dirava ia gwau, “Umui itaia, tanobada ibounai edia latanai uhe idia atoa ava ibounai, bona huahua idia atoa au ibounai, umui dekenai lau henia vadaeni, inai be emui aniani. ");
INSERT INTO hmo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","To tanobada ena boroma idauidau ibounai, bona ataiai manudia ibounai, bona tanobada dekenai idia rau mauri gaudia ibounai dekenai, ava ena rauraudia lau henia vadaeni. Inai be edia aniani.” Vadaeni unai bamona ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Bona Dirava ese ia karaia vadaeni gaudia ibounai ia itaia, bona momokani idia be namo herea. Adorahi ia ore, bona daba ia mai, be dina namba 6. ");
INSERT INTO hmo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Vadaeni, guba bona tanobada mai edia anina ibounai be Dirava ese ia karaia haorea. ");
INSERT INTO hmo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Dina namba 7 dekenai, Dirava ia itaia, iena gaukara ibounai be idia ore, vadaeni unai dina namba 7 lalonai ia laga-ani sibona, iena gaukara ia rakatania. ");
INSERT INTO hmo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Bona Dirava ese dina namba 7 ia hanamoa, bona dina helaga ia halaoa, badina be unai dina dekenai Dirava ese iena gau ibounai karaia gaukara ia rakatania, ia laga-ani. ");
INSERT INTO hmo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Guba bona tanobada bona noho gaudia ibounai karaia dalana be inai bamona: ");
INSERT INTO hmo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Lohiabada Dirava ese tanobada bona guba ia karaia neganai, uda dekenai au ta tanobada dekenai ia noho lasi, bona ava aniani ta do ia vara lasi. Badina be Lohiabada Dirava ese medu tanobada dekenai be ia do hadihoa lasi, bona tau ta ia noho lasi tano naria totona. ");
INSERT INTO hmo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","To varahu be tanobada dekena amo ia daekau, tano ena kopina ia hapariparia. ");
INSERT INTO hmo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Bona Lohiabada Dirava ese tano ena kahu dekena amo tau ta ia karaia, bona Dirava ese mauri ena lagana be unai tau ena udu baubau lalonai ia hiriria vareai, vadaeni unai tau ese mauri ia davaria vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Lohiabada Dirava ese uma ta dina ia daekau kahana dekenai ia karaia, ladana Eden, bona unai gabu dekenai, ia karaia vadaeni tauna ia atoa, unuseni ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Lohiabada Dirava ese tano dekena amo toana namo au ibounai ia havaraia, bona aniani idia atoa audia danu. Ma Dirava ese uma ena huana dekenai mauri ena au, bona kara namo bona kara dika hadibaia auna danu ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Eden dekena amo sinavai ta ia heau lao, uma ia hapariparia totona. Unai uma dekena amo sinavai ia parara, sinavai hani idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Sinavai ginigunana ena ladana be Pisona, ia be Havila tano ia heau hagegea, unai gabu dekenai golo korikori ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Unuseni noho golo be namo herea, bedolaka bona onuku nadi danu idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sinavai iharuana ena ladana be Gihona, ia be Kusu tano ia heau hagegea. ");
INSERT INTO hmo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sinavai ihatoina ena ladana be Taigarisi, ia be Asuria tano ena dina ia daekau kahana dekenai ia heau lao. Sinavai namba 4 be Euperate. ");
INSERT INTO hmo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Lohiabada Dirava ese unai tau ia abia, Eden ena uma gabu lalonai ia atoa, do ia geia bona naria totona. ");
INSERT INTO hmo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Lohiabada Dirava ese unai tau dekenai taravatu ia atoa, ia gwau, “Uma gabu dekenai gini au ibounai edia huahua oi ania diba, idia be taravatu lasi, ");
INSERT INTO hmo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","to kara namo bona kara dika hadibaia au ena huahua oi ania lasi, badina be inai huahua oi ania dina dekenai do oi mase momokani.” ");
INSERT INTO hmo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Lohiabada Dirava ma ia gwau, “Unai tau sibona ia noho be ia namo lasi, lau ese durua tauna ia bamona do lau karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Bona Dirava ese tano dekena amo tanobada ena boromakau ibounai ia karaia, bona ataiai manudia ibounai danu. Vadaeni, ia ese unai tau ena vairana dekenai ia hakaudia lao, do ia diba dahaka bona dahaka ladana idia dekenai ia atoa totona. Bona dahaka ladana unai tau ese inai mauri gaudia dekenai ia atoa, be edia ladana. ");
INSERT INTO hmo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Vadaeni, unai tau ese boromakau ibounai dekenai ladana ia atoa, bona ataiai manudia bona tanobada boroma ibounai danu, to idia edia huanai unai tau dekenai durua tauna ta ia davaria lasi. ");
INSERT INTO hmo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Vadaeni Lohiabada Dirava ese unai tau ia hamahutaia mase. Bona ia mahuta neganai, iena ruduna turia ta ia kokia, bona turia gabuna ia koua hidio dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Bona Lohiabada Dirava ese unai tau ena ruduna turia dekena amo hahine ta ia karaia, vadaeni tau dekenai hahine ia abia lao. ");
INSERT INTO hmo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Vadaeni unai tau ia gwau, “Inai harihari lau bamona tauna ia noho. Ia be lauegu turia ena turia, bona lauegu hidio ena hidio. Iena ladana do idia atoa, Hahine, badina be tau dekena amo be ia kokia.” ");
INSERT INTO hmo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Unai dainai tau ese tamana sinana do ia rakatania, iena adavana dekenai do ia noho, ruaosi be tauanina tamona do idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Idia ruaosi, tau mai ena adavana danu be kopina kavakava, to idia be hemarai lasi. ");
INSERT INTO hmo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Gaigai be kerere ena aonega dekenai ia honu momokani. Lohiabada Dirava ia karaia mauri gaudia ibounai edia aonega be gaigai ese ia hanaia. Ia ese hahine dekenai ia henanadaia, ia gwau, “Momokani, uma gabu ena au huahua ta ania lasi taravatu Dirava ese ia atoa o lasi?” ");
INSERT INTO hmo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Hahine ese gaigai dekenai ia haere, ia gwau, “Uma gabu dekenai idia gini au edia huahua ibounai ai ania be ia namo, ");
INSERT INTO hmo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","to uma gabu ena huana dekenai au ta ia gini, ena huahua dekenai Dirava ia gwau, ‘Unai au ena huahua umui ania lasi, bona dogoatao lasi, umui mase garina.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","To gaigai ese hahine dekenai ia gwau, “Inai be momokani lasi, dohore umui mase lasi. ");
INSERT INTO hmo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Dirava be inai bamona ia hereva badina ia diba, umui ania neganai aonega do umui davaria, bona Dirava hegeregere do umui noho, kara namona bona kara dikana do umui diba.” ");
INSERT INTO hmo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Hahine ese ia itaia, unai au ena toana be namo herea, bona ena au huahua ia itaia be aniani gauna namona, bona au ena aonega ia ura abia. Vadaeni, unai au ena huahua ia abia, bona ia ania. Ma iena tau dekenai ia henia danu, bona ia danu ia ania. ");
INSERT INTO hmo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Vadaeni idia ruaosi ese aonega idia davaria, bona idia diba idia be kopina kavakava. Unai dainai fig au ena rau idia turia hebou, bona rami idia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Adorahi kahanai, idia ese Lohiabada Dirava idia kamonai, ia be uma gabu lalonai ia loaloa noho, bona Lohiabada Dirava dekena amo idia hunia, uma gabu ena au edia huanai. ");
INSERT INTO hmo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","To Lohiabada Dirava ese tau dekenai ia boiboi, ia gwau, “Oi be edeseni?” ");
INSERT INTO hmo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tau ia haere, ia gwau, “Oi lau kamonai uma gabu lalonai, bona lau gari, badina be lau be kopina kavakava, vadaeni lau hunia.” ");
INSERT INTO hmo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Dirava ia gwau, “Daika ese oi ia hadibaia oi be kopina kavakava? Lau taravatua au huahua oi ania vadaeni, a?” ");
INSERT INTO hmo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tau ia haere, ia gwau, “Oi ese oi karaia lau dekenai hahine ese unai au huahua lau dekenai ia henia, bona lau ania.” ");
INSERT INTO hmo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Lohiabada Dirava ese hahine dekenai ia gwau, “Inai be dahaka oi karaia vadaeni?” Hahine ia gwau, “Gaigai ese lau dekenai ia koikoi, bona lau ania.” ");
INSERT INTO hmo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Vadaeni Lohiabada Dirava ese gaigai dekenai ia gwau henia, ia gwau, “Unai bamona oi karaia dainai oiemu kerere davana do oi abia. Oi sibona inai kerere davana do oi karaia. Hari ia lao bona hanaihanai, oiemu bogana dekenai do oi rau, bona tano ena kahu do oi ania. ");
INSERT INTO hmo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Lau ese tuari do lau havaraia oi bona hahine emui huana dekenai. Taunimanima bona gaigai dohore idia tuari. Taunimanima ese oiemu kwarana do idia botaia, bona oi ese edia aena do oi koria.” ");
INSERT INTO hmo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Lohiabada Dirava ese hahine dekenai ma ia hereva, ia gwau, “Oiemu rogorogo ena hekwarahi, do lau habadaia, bona oiemu hisihisi mara neganai. To oiemu adavana do oi ura henia noho, bona ia ese oi do ia biagua.” ");
INSERT INTO hmo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Bona Adamu danu dekenai ia gwau henia, ia gwau, “Oiemu adavana dekenai oi kamonai henia, bona lau taravatua au huahua oi ania vadaeni. Unai bamona oi karaia dainai, tano do ia dika oi dekenai. Gaukara auka do oi karaia oiemu mauri dinadia ibounai, aniani hegeregere do oi davaria totona. ");
INSERT INTO hmo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Au ginigini bona ava ginigini danu, be tano dekenai do idia vara oi dekenai, bona ava edia anina do oi ania. ");
INSERT INTO hmo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Do oi varahu, bona do oi gaukara auka, tano ena anina abia totona, ia lao bona tano dekenai do oi giroa lou, badina be tano dekena amo oi mai. Oi be tano dekena amo karaia gauna, bona tano dekenai do oi giroa lou.” ");
INSERT INTO hmo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tau ese iena adavana ena ladana ia atoa Heva, badina ia be mauri taudia ibounai edia sinana. ");
INSERT INTO hmo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Bona Lohiabada Dirava ese boromakau edia kopina dekena amo dabua ia karaia, Adamu bona Heva dekenai, bona idia dekenai dabua ia atoa. ");
INSERT INTO hmo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Lohiabada Dirava ia gwau, “Hari inai tau be ita hegeregere ia lao vadaeni, badina be kara namo bona kara dika ia diba. mauri auna ena huahua do ia ania noho be ia dika, mauri hanaihanai ia abia garina.” ");
INSERT INTO hmo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Unai dainai Lohiabada Dirava ese Eden uma gabu dekena amo tau ia lulua, bona ia vara dekena amo tano dekenai ia siaia, unai tano do ia geia noho totona. ");
INSERT INTO hmo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Dirava ese tau bona hahine ia lulua lao, bona Eden uma gabu ena dina ia daekau kahana dekenai kerubi aneru ia haginidia, uma gabu gimaia totona. Bona lahi kaia danu ia atoa. Unai kaia be ia giroagiroa kahana ibounai dekenai. Inai aneru bona kaia ese mauri auna dekenai lao dalana ia koua momokani. ");
INSERT INTO hmo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu bona Heva idia mahuta hebou, bona Heva ia rogorogo. Ia mara, mero ia abia. Ia gwau, “Lohiabada ena durua dekenai mero ta lau abia vadaeni.” Iena ladana ia atoa Kaino. ");
INSERT INTO hmo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Inai murinai ia mara lou, Kaino ena tadina Abela ia abia. Abela be mamoe naria tauna, to Kaino be uma naria tauna. ");
INSERT INTO hmo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Dina ta Kaino ese uma ena anina haida ia mailaia, Lohiabada dekenai ia henia, boubou gauna totona. ");
INSERT INTO hmo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Inai murinai Abela danu ese iena mamoe, vara guna gaudia, digara gaudia ia mailaidia. Ia aladia, bona vamu namona gaudia ia henia, boubou gauna totona. Lohiabada ese Abela ena harihari gauna dekenai ia moale, ");
INSERT INTO hmo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","to Kaino, mai ena boubou gauna ia abia dae lasi. Kaino be ia badu maragi lasi, bona badu dainai iena vairana ia metau. ");
INSERT INTO hmo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Lohiabada ese Kaino dekenai ia gwau, “Badina be dahaka oi badu noho? Badina dahaka oiemu vairana ia metau noho? ");
INSERT INTO hmo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Bema kara namo oi karaia vadaeni, be oiemu boubou do lau abia dae. To dika oi karaia vadaeni dainai, kara dika be oiemu iduara dekenai ia naria noho, oi do ia hadikaia totona. Kara dika be ia ura biagua oi, to oi ese do oi halusia be namo.” ");
INSERT INTO hmo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Bona Kaino ese iena tadina Abela dekenai ia hereva, ia gwau, “Uma gabu dekenai ita raka namo.” Ruaosi idia noho uma gabu neganai, Kaino ese iena tadina Abela dekenai ia heatu, ia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Lohiabada ese Kaino ia nanadaia, ia gwau, “Oiemu tadina Abela be edeseni?” Ia haere, “Lau diba lasi. Be, lau be egu tadina ena naria tauna, a?” ");
INSERT INTO hmo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Vadaeni Lohiabada ia gwau, “Dahaka kara dika oi karaia vadaeni? Oiemu tadina ena rarana be tano dekena amo ia boiboi noho lau dekenai, iena mase davana do lau karaia totona. ");
INSERT INTO hmo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Harihari dika ia mai oi dekenai, bona inai tano do oi rakatania momokani. Badina inai tano ese oiemu tadina ena rarana ia ania, oi ese oiemu tadina oi alaia neganai. ");
INSERT INTO hmo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bema uma gabu lalonai hadoa gaukara oi karaia, tano ese iena anina do ia henia lasi oi dekenai, bona dohore oi be ruma lasi, bona loa kava tauna tanobada dekenai do oi lao.” ");
INSERT INTO hmo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Bona Kaino ese Lohiabada dekenai ia hereva, ia gwau, “Lauegu dika davana be metau herea. ");
INSERT INTO hmo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Inai tano bona oiemu vairana dekena amo lau oi lulua noho. Lau be ruma lasi bona loa kava tauna do lau lao tanobada dekenai, bona sedira lau idia davaria taudia ese lau do idia alaia mase.” ");
INSERT INTO hmo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","To Lohiabada ese Kaino dekenai ia haere, ia gwau, “Lasi momokani. Kaino ia alaia tauna dekenai be davana do lau henia nega tamona lasi, to nega 7.” Vadaeni, Lohiabada ese Kaino dekenai maka ta ia atoa, tau ta ese ia davaria neganai, do ia alaia lasi totona. ");
INSERT INTO hmo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Bona Kaino ese Lohiabada dekena amo ia raka siri, bona tano ta ladana Loa Kava, Eden ena dina ia daekau kahana dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaino bona iena adavana idia mahuta hebou, bona hahine ia rogorogo. Ia mara, mero ia abia, ena ladana be Enoka. Kaino ese hanua ta ia haginia, inai hanua ena ladana ia atoa Enoka, iena natuna ena ladana hegeregere. ");
INSERT INTO hmo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoka ese natuna ta ia abia, iena ladana be Irada. Irada be Mehuiaela ena tamana, bona Mehuiaela be Metusaela ena tamana, bona Metusaela be Lameka ena tamana. ");
INSERT INTO hmo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameka ese hahine rua dekenai ia headava. Ta ena ladana be Ada, ma ta ena ladana be Sila. ");
INSERT INTO hmo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ia mara, Iabala ia abia. Iabala be palai ruma dekenai idia noho, bona boromakau idia naria taudia edia tubuna. ");
INSERT INTO hmo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Iena tadina ena ladana be Iubala. Ia be gita bona ivilikou idia gadaralaia taudia edia tubuna. ");
INSERT INTO hmo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Bona Sila ia mara, Tubala Kaino ia abia. Ia be kapa bona auri dekenai gaukara taudia ibounai edia tubuna. Inai Tubala Kaino ena taihuna ena ladana be Namaha. ");
INSERT INTO hmo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameka ese iena adavana ruaosi dekenai ia hereva, ia gwau, “Ada bona Sila, adavagu ruaosi e, lau dekenai umui kamonai! Tau ta ese lau ia haberoa, lau alaia vadaeni. Mero ta ese lau ia botaia, lau alaia mase vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kaino ia botaia tauna be davana do ia abia nega 7. To lau ia botaia tauna be davana do ia abia nega 77.” ");
INSERT INTO hmo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu bona iena adavana idia mahuta hebou lou, bona hahine ia rogorogo. Ia mara, mero ta ia abia, bona ia gwau, “Dirava ese natuna ta lau dekenai ia henia vadaeni, Abela, Kaino ese ia alaia tauna ena gabu do ia abia totona.” Unai dainai iena ladana ia atoa, Seta. ");
INSERT INTO hmo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seta ese natuna ta ia havaraia, iena ladana ia atoa Enosi. Unai nega dekenai taunimanima ese Lohiabada ena ladana helagana dekenai guriguri idia hamatamaia. ");
INSERT INTO hmo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adamu ena bese taudia edia ladadia be inai: Dirava ese taunimanima ia karaia neganai, ia ese Dirava ena toana hegeregerena ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Tau ta bona hahine ta ia karaia neganai, Dirava ese ia hanamodia, bona edia ladana ia gwauraia, Taunimanima. ");
INSERT INTO hmo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu ena mauri lagani be 130 neganai, iena natuna ta ia havaraia, iena toana bamona bona ia hegeregerena vadaeni, iena ladana ia atoa Seta. ");
INSERT INTO hmo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seta ia vara murinai, Adamu be lagani 800 ma ia mauri noho, iena natuna tatau bona hahine ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu ena mauri lagani ibounai be 930, vadaeni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seta ena mauri lagani be 105 neganai, ia ese Enosi ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Vadaeni Enosi ia vara murinai, Seta be lagani 807 ma ia mauri noho, iena natuna tatau bona hahine ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seta ena mauri lagani ibounai be 912, vadaeni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi ena mauri lagani be 90 neganai, ia ese Kenana ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Vadaeni Kenana ia vara murinai, Enosi be lagani 815 ma ia mauri noho, iena natuna tatau bona hahine ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosi ena mauri lagani ibounai be 905, vadaeni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenana ena mauri lagani be 70 neganai, ia ese Mahalalela ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Vadaeni Mahalalela ia vara murinai, Kenana be lagani 840 ma ia mauri noho, iena natuna tatau bona hahine ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenana ena mauri lagani ibounai be 910, vadaeni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalela ena mauri lagani be 65 neganai, ia ese Iareda ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Vadaeni Iareda ia vara murinai, Mahalalela be lagani 830 ma ia mauri noho, iena natuna tatau bona hahine ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalela ena mauri lagani ibounai be 895, vadaeni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Iareda ena mauri lagani be 162 neganai, ia ese Enoka ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Vadaeni Enoka ia vara murinai, Iareda be lagani 800 ma ia mauri noho, iena natuna tatau bona hahine ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Iareda ena mauri lagani ibounai be 962, vadaeni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoka ena mauri lagani be 65 neganai, ia ese Metusela ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusela ia vara murinai, Enoka be Dirava danu idia turana karaia noho, ia lao bona lagani 300 ia ore. Iena natuna tatau bona hahine ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoka ena mauri lagani be 365, ");
INSERT INTO hmo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ia be Dirava danu idia turana karaia noho, vadaeni inai murinai, tau ta ese ia itaia lou lasi, badina be Dirava ese ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela ena mauri lagani be 187 neganai, ia ese Lameka ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Vadaeni Lameka ia vara murinai, Metusela be lagani 782 ma ia mauri noho, iena natuna tatau bona hahine ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela ena lagani ibounai be 969, vadaeni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameka ena mauri lagani be 182 neganai, ia ese iena natuna ta ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Iena ladana ia atoa Noa, ena anina be “laga-ani”. Ia gwau, “Lohiabada ese tano ia hadikaia vadaeni kara dekena amo inai mero ese ita do ia hamauria, iseda imana edia gaukara, bona iseda hekwarahi dekena amo do ita laga-ani totona.” ");
INSERT INTO hmo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noa ia vara murinai, Lameka be lagani 595 ma ia mauri noho, iena natuna tatau bona hahine ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameka ena mauri lagani ibounai be 777, vadaeni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa ena mauri lagani be 500 neganai, ia ese Sema, bona Hamo, bona Iapeta ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nega ia mai vadaeni, taunimanima be momo tanobada dekenai, bona natuna kekeni idia vara noho. ");
INSERT INTO hmo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Bona Dirava ena natuna haida ese idia itaia, inai kekeni be mai edia hairai. Vadaeni, idia ura henia kekenidia idia abia, idia adavaia. ");
INSERT INTO hmo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Bona Lohiabada ia gwau, “Egu lauma be nega ibounai taunimanima edia lalonai do ia noho lasi, badina idia be hidio sibona. Hari ia lao, edia mauri lagani be dohore lagani 120 sibona.” ");
INSERT INTO hmo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Unai Dirava ena natuna taudia ese taunimanima edia natuna kekeni idia adavaia bona natuna idia havaraia neganai, tatau badadia badadia idia noho tanobada dekenai. Idia be gunaguna, bona gabeai danu, goada taudia mai ladana, edia sivarai danu be bada. ");
INSERT INTO hmo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Lohiabada ese taunimanima ia itaia, edia kara dika be bada herea gabu ibounai dekenai, bona edia laloa be nega ibounai ia dika sibona mo. ");
INSERT INTO hmo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Lohiabada ena lalona be ia hisihisi, taunimanima tanobada dekenai ia havaraia dainai, bona iena lalohisihisi be ia bada momokani. ");
INSERT INTO hmo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Vadaeni ia gwau, “Lau karaia gaudia, taunimanima ibounai do lau hamasea haorea, tanobada gabu ibounai dekena amo. Lau ese boroma ibounai bona ataiai manudia ibounai danu do lau hamasea, badina idia lau havaraia dainai, egu lalona ia hisihisi noho.” ");
INSERT INTO hmo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","To Noa dekenai Lohiabada ia moale. Noa ena natuna be inai: ");
INSERT INTO hmo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Iena natuna memero be toi, Sema bona Hamo bona Iapeta. ");
INSERT INTO hmo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa be kara namo tauna, ia tamona sibona dekenai Dirava ia moale. Ia be Dirava danu ia noho, turana hegeregere. ");
INSERT INTO hmo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","To taunimanima ibounai be dika momokani Dirava ena vairana dekenai, bona edia dika be gabu ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dirava ese tanobada ia itaia, ia dika rohoroho vadaeni, badina taunimanima ibounai edia kara be dika momokani. ");
INSERT INTO hmo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Dirava ese Noa dekenai ia hereva, ia gwau, “Mauri gaudia ibounai do lau haorea. Ibounai do lau hamasea haorea, badina tanobada be edia kara dika dekenai ia honu momokani. ");
INSERT INTO hmo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Lagatoi namona ta, au namodia dekenai do oi haginia. Ia lalonai daiutu do oi karaia, bona lalonai bona murimurinai pisi dekenai oi koua. ");
INSERT INTO hmo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Inai bamona do oi karaia: Iena lata be 133 mita, iena lababana be 22 mita, bona iena ataiai be 13 mita. ");
INSERT INTO hmo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Lagatoi ena guhi do oi karaia, bona uindo, ena dobu 44 sentamita do oi karaia, guhi bona haba edia huanai. Sitori toi danu do oi karaia, bona iduara do oi karaia haba dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Lau be abata bada herea tanobada dekenai do lau siaia, mauri gaudia ibounai do lau haorea. Gau ibounai tanobada dekenai do idia mase ore, ");
INSERT INTO hmo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","to gwauhamata oi dekenai do lau karaia, bona do lau hamomokania. Lagatoi lalonai do oi guia, oi bona oiemu adavana, oiemu natuna memero, bona edia adavadia. ");
INSERT INTO hmo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Mauri gaudia ibounai idauidau rua rua dekenai do oi udaia lao, idia be do idia mauri noho totona, tau ta, hahine ta, inai bamona do oi udaia lao. ");
INSERT INTO hmo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Manu idauidau ibounai, bona boroma gaudia idauidau ibounai, badadia bona maragidia, rua rua dekenai lagatoi dekenai do idia vareai lao, do idia mauri noho totona. ");
INSERT INTO hmo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Aniani gaudia idauidau ibounai danu do oi haboua, bona do oi abia lao, oiemu aniani, bona mauri gaudia edia aniani.” ");
INSERT INTO hmo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Bona Noa ese unai bamona ia karaia, Dirava ena hereva ibounai hegeregere. ");
INSERT INTO hmo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Lohiabada ese Noa dekenai ia hereva, ia gwau, “Lagatoi lalonai oi guia, oi bona oiemu ruma taudia ibounai, badina be lau itaia, oi sibona be kara maoromaoro tauna inai taunimanima edia huanai. ");
INSERT INTO hmo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Mauri gaudia goevagoeva ibounai 7-7 dekenai oi abia lao, tau 7, hahine 7, to goevagoeva lasi gaudia rua rua dekenai oi abia lao, tau ta, hahine ta. ");
INSERT INTO hmo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ataiai manudia idauidau danu do oi abia lao, 7-7 dekenai, hahine 7, tau 7. Inai bamona oi karaia, boroma gaudia idauidau bona manu idauidau do idia mauri noho, bona tanobada dekenai do idia vara lou totona. ");
INSERT INTO hmo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Badina be dina 7 do idia ore murinai lau be medu do lau siaia tanobada dekenai. Dina 40 bona hanuaboi 40 medu do ia diho tanobada dekenai, lau karaia mauri gaudia ibounai do lau haorea totona.” ");
INSERT INTO hmo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Bona Noa ese Lohiabada ena hereva gauna ibounai ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tanobada dekenai abata ia daekau neganai, Noa ena mauri lagani be 600. ");
INSERT INTO hmo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa bona iena adavana bona ena natuna memero bona edia adavadia be lagatoi lalonai idia guia, abata ena ranu dainai. ");
INSERT INTO hmo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Mauri gaudia idauidau ibounai, goevagoeva bona goevagoeva lasi, rua rua, tau bona hahine, be lagatoi lalonai idia guia Noa danu, Dirava ena oda hegeregere. Manu bona tano dekenai idia rau gaudia danu, rua rua dekenai, tau bona hahine, idia guia. ");
INSERT INTO hmo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Dina 7 ia ore murinai, abata ia daekau tanobada ena latanai. ");
INSERT INTO hmo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa ena mauri lagani be 600 neganai, hua iharuana ena dina 17, tanobada henunai ena ranu ia makohia bona ia daekau mai, bona guba ena matuna ibounai be idia kehoa. ");
INSERT INTO hmo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Bona medu be tanobada ena latanai ia diho, dina 40 bona hanuaboi 40. ");
INSERT INTO hmo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Unai dina dekenai Noa mai ena adavana danu, bona edia natudia memero Sema bona Hamo bona Iapeta mai edia adavadia danu, be lagatoi dekenai idia guia. ");
INSERT INTO hmo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Boroma gaudia idauidau edia orea edia orea hegeregerena, bona boromakau edia orea edia orea hegeregerena, bona tanobada dekenai idia rau gaudia edia orea edia orea hegeregerena, bona manu idauidau edia orea edia orea hegeregerena, idia danu idia guia lao. ");
INSERT INTO hmo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Mauri gaudia ibounai rua rua dekenai, tau bona hahine, Noa danu lagatoi dekenai idia guia, ");
INSERT INTO hmo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Dirava ena oda hegeregere. Vadaeni Lohiabada ese lagatoi ena iduara ia koua. ");
INSERT INTO hmo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Abata ia daekau noho dina 40, ela bona ranu ena dobu be hegeregere lagatoi do ia abia isi. ");
INSERT INTO hmo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Abata ena dobu ia bada daekau noho, bona lagatoi ia hure noho ranu ena kopina dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Abata ia bada daekau noho ela bona ororo badadia ibounai ia koua. ");
INSERT INTO hmo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ma ia daekau ela bona ororo edia atai dekenai ranu ena dobu be 7 mita. ");
INSERT INTO hmo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Mauri gaudia ibounai tanobada dekenai idia mase, manu bona boromakau, bona boroma idauidau, bona tano dekenai idia rau gaudia, bona taunimanima. ");
INSERT INTO hmo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tanobada dekenai noho mauri gaudia ibounai idia mase ore. ");
INSERT INTO hmo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Lohiabada ese tanobada dekenai noho mauri gaudia ibounai ia haorea, taunimanima bona boromakau, bona tano dekenai rau gaudia, bona ataiai manu danu. Noa sibona, bona ia danu lagatoi dekenai noho taudia bona gaudia sibona idia mauri noho. ");
INSERT INTO hmo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ranu ena dobu ia bada daekau noho dina 150 lalonai. ");
INSERT INTO hmo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","To Dirava ese Noa ia laloa noho, ia bona mauri gaudia ibounai, bona boromakau, ia danu lagatoi dekenai idia guia. Vadaeni Dirava ese lai ta ia siaia mai tanobada dekenai, bona ranu ia diho hamatamaia. ");
INSERT INTO hmo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tanobada henunai ia makohia bona ia daekau mai ranu gabudia be idia koua, guba ena matuna danu be idia koua. Guba dekenai ia diho medu danu be ia doko. ");
INSERT INTO hmo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ranu be ia diho lao noho. Dina 150 ia ore murinai be sisina ia diho. ");
INSERT INTO hmo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ela bona hua 7 ena dina 17 dekenai lagatoi ia kamokau Ararata Ororo dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ranu be ia diho lao noho, bona hua 10 ena dina ginigunana dekenai, ororo edia ataiai kahana be idia hedinarai. ");
INSERT INTO hmo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Dina 40 murinai Noa ese lagatoi ena uindo ia kehoa, ");
INSERT INTO hmo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","bona galo manu ta ia siaia lao. Manu be ia roho lao, bona Noa dekenai ia giroa mai lasi. Lasi, to ia roho lao noho, kahana bona kakana dekenai, ela bona tanobada dekenai ranu be ia kaukau vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Vadaeni Noa ese pune manu ta ia siaia lao, ranu do ia itaia, ia diho momokani o lasi, ");
INSERT INTO hmo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","to ranu ese tano ibounai ia do koua dainai, pune manu be helai gabu ta ia davaria lasi. Unai dainai Noa ese murimuri dekenai iena imana ia atoa lao, bona pune manu ia abia lou lagatoi lalonai. ");
INSERT INTO hmo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Dina 7 ia naria, ma lagatoi dekena amo unai pune manu ia siaia lou. ");
INSERT INTO hmo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Adorahi kahanai, pune ia giroa lou Noa dekenai, bona iena uduna dekenai be olive ena rauna matamata ta. Vadaeni, Noa ia diba ranu be ia diho vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Dina 7 ma ia naria, vadaeni pune manu ia siaia lou. Inai neganai pune manu ia giroa mai lasi. ");
INSERT INTO hmo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa ena mauri lagani be 601 neganai, hua ginigunana ena dina ginigunana dekenai, ranu be ia kaukau momokani tanobada dekenai. Vadaeni Noa ese lagatoi ena koua gauna ia kokia, tanobada kopina ia itaia, be ia kaukau. ");
INSERT INTO hmo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Hua iharuana ena dina 27 dekenai tanobada be ia kaukau vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Dirava ese Noa dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Lagatoi dekena amo oi diho, oi bona oiemu adavana, bona oiemu natuna memero, mai edia adavadia danu. ");
INSERT INTO hmo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mauri gaudia ibounai oi danu murimuri dekenai do oi hakaua, manu bona boromakau, bona tanobada dekenai idia rau gaudia ibounai. Do idia vara rohoroho, do idia mara momo, bona do idia momo herea tanobada kahana ibounai dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Vadaeni Noa ese lagatoi dekena amo ia diho, ia bona iena adavana, bona iena natuna memero mai edia adavadia. ");
INSERT INTO hmo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Boroma ibounai danu, boromakau, manu, bona tano dekenai rau gaudia danu, ibounai be lagatoi dekena amo idia diho, ta ta edia orea, edia orea hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa ese boubou patana Dirava dekenai ia haginia. Vadaeni boroma goevagoeva gaudia bona manu goevagoeva gaudia ta ta dekena amo tamona ia abia, boubou patana dekenai ia alaia, bona lahi dekenai idia ia gabua ore, boubou gauna totona. ");
INSERT INTO hmo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Lohiabada ese bonana namona ia kamonai neganai, ia gwau, “Tanobada do lau hadikaia lou lasi taunimanima dainai, badina be lau diba, idia be maragi negana dekena amo, edia laloa be dika. Lau be mauri gaudia do lau alaia ore lou lasi, vanegai lau alaia ore bamona. ");
INSERT INTO hmo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Tanobada ia noho neganai, hadoa nega bona geia nega do ia noho. Keru nega bona siahu nega, kaukau nega, medu nega, dina bona hanuaboi, inai be do idia doko lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dirava ese Noa mai ena natuna danu ia hanamoa, ia gwau, “Natuna momo do umui havaraia, vadaeni emui bese be tanobada gabu ibounai dekenai do idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tanobada ena boroma gaudia idauidau ibounai, bona ataiai manu ibounai, bona tano dekenai idia rau gaudia ibounai, bona gwarume be umui dekenai do idia gari. Umui emui imana dekenai ibounai do lau atoa. ");
INSERT INTO hmo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Hari inai mauri gaudia ibounai umui ania diba, ava aniani umui ania vadaeni hegeregerena. Lau ese lau henia umui dekenai, aniani totona. ");
INSERT INTO hmo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","To aniani tamona umui ania diba lasi. Vamu mai rarana danu be mai taravatu, badina be rara be mauri ena badina. ");
INSERT INTO hmo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Bema tau ta ese emui mauri rarana ia habubua, lau be davana do lau henia, do ia mase. Bema boroma ta ese umui ia alaia, lau ese do lau hamasea. Bona bema tau ta ese taunimanima ta ia alaia neganai, lau ese davana do lau henia. ");
INSERT INTO hmo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Daika ese taunimanima ta ia alaia, be taunimanima ese do idia alaia. Badina be Dirava ese taunimanima ia karaia, iena toana bamona. ");
INSERT INTO hmo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Hari ia lao, natuna momo do umui havaraia, vadaeni emui bese be bada herea tanobada dekenai, bona tanobada gabu ibounai dekenai do idia noho.” ");
INSERT INTO hmo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bona Dirava ese Noa bona iena natuna dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Lau ese hari lauegu gwauhamata taravatuna lau henia umui dekenai, bona emui bese dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Umui danu idia noho mauri gaudia ibounai dekenai danu inai gwauhamata lau henia, manu bona boromakau bona tanobada ena boroma ibounai dekenai lau henia, lagatoi dekena amo idia diho gaudia ibounai. ");
INSERT INTO hmo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Lau ese lauegu gwauhamata taravatuna lau hamomokania inai: Lau ese abata dekena amo mauri gaudia ibounai do lau alaia lou lasi. Abata ese tanobada do ia hadikaia ore lou lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Dirava ma ia gwau, “Inai noho hanaihanai gwauhamata taravatuna lau henia umui dekenai bona mauri gaudia ibounai dekenai, ena toana be inai: ");
INSERT INTO hmo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Lauegu kevau be ori lalonai lau atoa inai. Ia be egu gwauhamata taravatuna tanobada dekenai ena toana. ");
INSERT INTO hmo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ori lau havaraia tanobada ena ataiai, guba dekenai neganai, bona kevau ia hedinarai ori lalonai neganai, ");
INSERT INTO hmo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","lau ese egu gwauhamata umui dekenai bona mauri gaudia ibounai dekenai do lau laloa noho, abata ese mauri gaudia do ia hadikaia ore lou lasi. ");
INSERT INTO hmo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kevau be ori lalonai ia hedinarai neganai, lau be do lau itaia, bona noho hanaihanai gwauhamata taravatuna, lau bona tanobada ena mauri gaudia ibounai iseda huanai, do lau laloa noho.” ");
INSERT INTO hmo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Dirava ese Noa dekenai ia hereva, ia gwau, “Inai kevau be egu gwauhamata mauri gaudia ibounai dekenai ena toana momokani.” ");
INSERT INTO hmo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa ena natuna memero, lagatoi dekena amo idia diho taudia, edia ladana be Sema, bona Hamo bona Iapeta. Hamo be Kanana ena tamana. ");
INSERT INTO hmo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noa ena natuna toi be inai, idia be tanobada ibounai edia tubudia. ");
INSERT INTO hmo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa be biru tauna. Ia ese uaina havaraia uma gabu ginigunana ia hadoa. ");
INSERT INTO hmo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Dina ta uaina haida ia inua murinai, iena kwarana ia giroagiroa, bona iena dabua ibounai ia kokia, bona kopina kavakava ia hekure iena palai ruma lalonai. ");
INSERT INTO hmo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamo, Kanana ena tamana ese iena tamana ia itaia, ia be kopina kavakava. Vadaeni, ia lao, iena tadikakana ruaosi dekenai ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Vadaeni Sema bona Iapeta ese dabua badana ta idia abia, edia pagana dekenai idia huaia. Palai ruma dekenai idia raka vareai, to edia murina kahana dekena amo idia raka lao. Edia tamana idia koua dabua dekenai, to edia vairana idia giroa lasi, edia tamana ena kopina kavakava idia itaia garina. ");
INSERT INTO hmo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noa ena inua kekero dekena amo ia noga neganai, ia kamonai dahaka kara dikana iena natuna Hamo ese ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Vadaeni ia gwau, “Dika do ia mai Kanana ena latana dekenai! Iena tadikakana dekenai hesiai gaukara momokani do ia karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ma ia gwau, “Lohiabada, Sema ena Dirava, ita hanamoa, Kanana ese hesiai gaukara do ia karaia Sema dekenai, ");
INSERT INTO hmo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Dirava ese Iapeta ena bese do ia habadaia be namo. Iena bese be dohore Sema ena bese taudia danu do idia noho. Kanana be dohore Iapeta ena hesiai gaukara do ia karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Abata murinai Noa ese lagani 350 ia mauri noho. ");
INSERT INTO hmo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Iena mauri lagani ibounai be 950, vadaeni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa ena natuna toi, Sema bona Hamo bona Iapeta, edia natuna bona edia tubuna be inai, abata ia daekau murinai idia havaraia: ");
INSERT INTO hmo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iapeta ena natuna be inai: Gomere bona Magoga bona Madai bona Iavana bona Tubala bona Meseka bona Tirasi. ");
INSERT INTO hmo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomere ena natuna be inai: Asakena bona Ripata bona Togarama. ");
INSERT INTO hmo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Iavana ena natuna be inai: Elisa bona Tarasisi, bona Kitima ena bese bona Dodana ena bese danu ia ese ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Idia dekena amo kone noho taudia bona motumotu noho taudia ibounai idia vara, edia bese idauidau dekenai, edia tano idauidau dekenai, bona edia gado idauidau dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamo ena natuna be inai: Kusu bona Aigupito bona Putu bona Kanana. ");
INSERT INTO hmo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusu ena natuna be inai: Seba bona Havila bona Sabata bona Rama bona Sabateka. Rama ena natuna be inai: Sieba bona Dedana. ");
INSERT INTO hmo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusu ese Nimiroda ia havaraia danu, ia be lohia tauna badana ginigunana tanobada dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ia danu be labana tauna mai goada danu Lohiabada ena vairana dekenai, unai dainai taunimanima edia hereva ta ia gwau, “Labana tauna mai goada danu Lohiabada ena vairanai, Nimiroda bamona.” ");
INSERT INTO hmo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimiroda ena basileia ginigunana ena hanua badadia be Babela, bona Ereke, bona Akada, bona Kalena, idia ibounai be Sinara tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Unai tano dekena amo Nimiroda ia raka siri, Asuria tano dekenai ia lao. Unuseni Nineva hanua bona Rehoboto Ira hanua bona Kala hanua ia haginidia, ");
INSERT INTO hmo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","bona Resene hanua, Nineva bona Kala edia huanai. Kala be hanua bada herea. ");
INSERT INTO hmo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Aigupito ese ia havaraia besena be inai: Ludima bona Anamima bona Lehabima bona Napatuhima, ");
INSERT INTO hmo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","bona Patarusima bona Kasaluhima bona Kapatorima. Pilistia taudia be Kasaluhima ena bese dekena amo idia vara. ");
INSERT INTO hmo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanana ena natuna be inai: Sidono, ia vara guna tauna, bona Heta, ");
INSERT INTO hmo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","bona Iebusu taudia bona Amoro taudia bona Girigasa taudia, ");
INSERT INTO hmo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","bona Hivi taudia bona Araka taudia bona Sini taudia, ");
INSERT INTO hmo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","bona Aravada taudia bona Semara taudia bona Hamata taudia. Gabeai Kanana taudia edia iduhu ia makohia, idia lao gabu idauidau dekenai idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanana taudia edia tano be Sidono dekena amo ia lao bona Gasa, Gerara ena kahana dekenai, bona ia lao bona Lasa, Sodoma, bona Gomora bona Adima bona Seboimi edia kahana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Inai ibounai be Hamo ena bese taudia, edia iduhu idauidau bona edia tano idauidau dekenai idia noho, edia orea ta ta be mai edia gado idauidau. ");
INSERT INTO hmo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sema danu, Iapeta ena kakana, ese iena natuna tatau haida ma ia havaraia. Sema be Ebere ena natuna ibounai edia tubuna. ");
INSERT INTO hmo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sema ena natuna be inai: Elama bona Asuru bona Apakasada bona Luda bona Arama. ");
INSERT INTO hmo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arama ena natuna be inai: Usu bona Hulu bona Getere bona Masa. ");
INSERT INTO hmo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apakasada ese Sela ia havaraia, bona Sela ese Ebere ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebere ena natuna tatau be rua. Ta ena ladana be Pelega, ena anina be “Parara”, badina be iena nega dekenai, tanobada ena bese idia makohia parara. Iena tadina ena ladana be Iokatana. ");
INSERT INTO hmo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Iokatana ena natuna be inai: Alamodada bona Selepe bona Hasaramavete bona Iera, ");
INSERT INTO hmo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","bona Hadorama bona Usala bona Dikila, ");
INSERT INTO hmo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","bona Obala bona Abimaela bona Sieba, ");
INSERT INTO hmo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","bona Opiri bona Havila bona Iobaba. Inai ibounai be Iokatana ena natuna. ");
INSERT INTO hmo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Edia tano be Mesa dekena amo ia lao bona dina ia daekau kahana ena ororo ladana Separa ena kahana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Inai ibounai be Sema ena bese taudia, edia iduhu idauidau, bona edia tano idauidau dekenai idia noho, edia orea ta ta be mai edia gado idauidau. ");
INSERT INTO hmo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Noa ena natuna edia tubuna be inai, edia uru dekenai bona edia bese dekenai. Idia dekena amo tanobada ena bese ibounai idia vara, abata ia daekau murinai. ");
INSERT INTO hmo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Gunaguna neganai tanobada ibounai ena taunimanima ibounai edia gado be tamona, edia hereva danu be hegeregere. ");
INSERT INTO hmo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Dina ia daekau kahana dekenai idia laolao noho neganai, tano palaka ta idia davaria, Sinara tano dekenai. Vadaeni unuseni idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Vadaeni idia sibona dekenai idia herevahereva, idia gwau, “Namo, raro nadi momo ita karaia namo, lahi dekenai ita gabua namonamo.” Vadaeni, raro nadi idia abia hegaegae, haginia gaukara totona, bona pisi danu idia abia, raro nadi ena kamokamo gauna. ");
INSERT INTO hmo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Vadaeni, ma idia gwau, “Hari, hanua badana ta ita karaia be namo, iena kohoro be guba dekenai do ia kamokau. Unai dekena amo iseda ladana do ia bada, tanobada kahana kahana ibounai dekenai do ita loaloa kava noho garina.” ");
INSERT INTO hmo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Vadaeni Lohiabada ia diho, hanua bona kohoro, inai taudia idia karaia gauna do ia itaia totona. ");
INSERT INTO hmo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Bona ia gwau. “Hari inai taudia be bese tamona, bona gado tamona idia veria noho. Idia karaia hamatamaia gauna be inai. Gabeai, bema gau ta idia ura karaia, daika ese edia dala do ia koua? ");
INSERT INTO hmo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ita diho namo, bona edia gado do ita haidaua, vadaeni ta ta idia edia hereva be do idia kamonai diba lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Vadaeni, Lohiabada ese ia luludia tanobada kahana kahana ibounai dekenai, bona edia hanua badana haginia gaukara idia hadokoa. ");
INSERT INTO hmo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Unai hanua ena ladana be Babela, badina be unuseni dekenai Lohiabada ese taunimanima edia gado ia haidaua, bona unai gabu dekena amo ia luludia, tanobada kahana kahana ibounai dekenai idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sema ena natuna bona iena tubuna be inai: Sema ena mauri lagani be 100 neganai, ia ese Apakasada ia havaraia, abata ia diho vadaeni lagani rua murinai. ");
INSERT INTO hmo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Apakasada ia vara murinai, Sema be lagani 500 ia mauri noho, bona ia ese iena natuna tatau bona hahine ma haida ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apakasada ena mauri lagani be 35 neganai, ia ese Sela ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela ia vara murinai, Apakasada be lagani 403 ia mauri noho, bona ia ese iena natuna tatau bona hahine ma haida ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela ena mauri lagani be 30 neganai, ia ese Ebere ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebere ia vara murinai, Sela be lagani 403 ia mauri noho, bona ia ese iena natuna tatau bona hahine ma haida ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebere ena mauri lagani be 34 neganai, ia ese Pelega ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelega ia vara murinai, Ebere be lagani 430 ia mauri noho, bona ia ese iena natuna tatau bona hahine ma haida ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelega ena mauri lagani be 30 neganai, ia ese Reu ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu ia vara murinai, Pelega be lagani 209 ia mauri noho, bona ia ese iena natuna tatau bona hahine ma haida ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu ena mauri lagani be 32 neganai, ia ese Seruga ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruga ia vara murinai, Reu be lagani 207 ia mauri noho, bona ia ese iena natuna tatau bona hahine ma haida ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruga ena mauri lagani be 30 neganai, ia ese Nahoro ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahoro ia vara murinai, Seruga be lagani 200 ia mauri noho, bona ia ese iena natuna tatau bona hahine ma haida ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahoro ena mauri lagani be 29 neganai ia ese Tera ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tera ia vara murinai, Nahoro be lagani 119 ia mauri noho, bona ia ese iena natuna tatau bona hahine ma haida ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera ena mauri lagani be 70 murinai, ia ese Aberamo bona Nahoro bona Harana ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera ena natuna bona iena tubuna be inai: Tera ese Aberamo bona Nahoro bona Harana ia havaraia. Harana ese Lota ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Aberamo ena tamana Tera ia do mase lasi neganai, Harana ia mase guna, ia vara gabuna dekenai, Uru, Kaledea taudia edia hanua ta, unuseni ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aberamo ia headava, Nahoro danu ia headava. Aberamo ena adavana ena ladana be Sarai. Nahoro ena adavana ena ladana be Milika, Harana ena natuna. Unai Harana ena natuna be Milika, bona Isika. ");
INSERT INTO hmo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai be hegeregere lasi natuna ta do ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera ese iena bese taudia haida ia hakaudia, Uru hanua, Kaledea tano idia rakatania, Kanana tano dekenai idia lao totona. Iena bese taudia edia ladana be inai: Iena natuna, Aberamo, ena tubuna Lota, Harana ena natuna, bona iena ravana Sarai, Aberamo ena adavana. Gabu ta dekenai idia ginidae, ena ladana be Harana. Unuseni idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera ena mauri lagani ibounai be 205, vadaeni Harana hanua dekenai ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Lohiabada ese Aberamo dekenai ia hereva, ia gwau, “Oiemu tano bona oiemu varavara bona oiemu tamana ena ruma oi rakatania, bona oi dohore lau hadibaia tano dekenai do oi lao. ");
INSERT INTO hmo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Lau be oi dekenai tubuna momo do lau henia, dohore idia be bese bada herea. Oi do lau hanamoa, bona oiemu ladana do lau habadaia, vadaeni taunimanima ese namo bada do idia davaria oi dekena amo. ");
INSERT INTO hmo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Oi idia hanamoa taudia be lauegu hanamoa do idia davaria, to oi idia hadikaia taudia be dohore lau hadikaia. Tanobada ena bese ibounai, be oi dainai namo bada do idia davaria.” ");
INSERT INTO hmo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Vadaeni Aberamo ia lao, Dirava ena oda hegeregere. Lota be Aberamo danu idia lao. Aberamo be Harana hanua ia rakatania neganai iena mauri lagani be 75. ");
INSERT INTO hmo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Aberamo ese iena adavana Sarai bona iena vavana Lota ia hakaua lao. Harana hanua dekenai idia davaria kohu bona gaukara memero danu idia abia lao. Idia toreisi, Kanana dekenai idia lao gwauraia. ");
INSERT INTO hmo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Kanana dekenai idia ginidae neganai, Aberamo ese tano ia raka hanaia, ia lao bona Sekema hanua ena helaga gabuna dekenai ia ginidae, ma ia raka lao, ela bona au helagana ladana More dekenai. Unai neganai Kanana taudia be unai tano dekenai idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Lohiabada ese Aberamo dekenai ia hedinarai, ia hereva, ia gwau, “Inai tano be oiemu tubuna dekenai do lau henia.” Vadaeni unuseni Aberamo ese boubou patana ia karaia Lohiabada dekenai, badina be Lohiabada ese ia dekenai ia hedinarai unai gabu dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Unai murinai Aberahamo ese unai gabu ia rakatania, ia lao diho kahanai. Ororo ta, Betele hanua ena dina ia daekau kahana dekenai iena palai ruma ia haginia. Betele be dina ia diho kahanai, Ai hanua be dina ia daekau kahanai. Unuseni boubou patana ia karaia, bona Lohiabada dekenai ia tomadiho. ");
INSERT INTO hmo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Vadaeni ma ia toreisi, ia lao diho kahanai, Negebe tano kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","To aniani be lasi unai tano dekenai. Unai dainai ia lao diho kahana Aigupito dekenai, unuseni do ia noho nega sisina, badina aniani be lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Aigupito ena hetoa gabuna be kahirakahira neganai, iena adavana Sarai dekenai ia hereva, ia gwau, “Kamonai, oi be hairai dikadika hahine ta. ");
INSERT INTO hmo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Aigupito taudia ese oi idia itaia neganai do idia gwau, ‘Ia be Aberamo ena adavana.’ Vadaeni, lau do idia alaia, oi idia abia totona. ");
INSERT INTO hmo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Mani idia dekenai oi hamaoroa, oi be lauegu taihuna, vadaeni oi dainai dohore lau noho namonamo mai mauri danu.” ");
INSERT INTO hmo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Aberamo ese Aigupito ena tano dekenai ia ginidae neganai, Aigupito taudia ese iena adavana idia itaia, ia be hairai dikadika. ");
INSERT INTO hmo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Farao ena lohia taudia idia itaia, vadaeni Sarai ena hairai be Farao dekenai idia hamaoroa. Vadaeni, idia hakaua lao Farao ena ruma badana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Hahine dainai Farao ese Aberamo ia naria namonamo, bona mamoe, nanigosi, boromakau, kamelo, hesiai taudia bona hesiai hahine ia dekenai ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","To Lohiabada ese gorere dikadia dekenai Farao mai ena ruma taudia danu ia hisihisi henidia, Sarai, Aberamo ena adavana dainai. ");
INSERT INTO hmo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Vadaeni Farao ese Aberamo ia boiria mai, ia gwau henia, ia gwau, “Dahaka oi karaia lau dekenai? Badina dahaka lau oi hamaoroa lasi ia be oiemu adavana? ");
INSERT INTO hmo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Badina dahaka oi gwau ia be oiemu taihuna, vadaeni lau adavaia? Oiemu adavana be inai, oi abia, umui lao.” ");
INSERT INTO hmo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Vadaeni Farao ese iena gaukara taudia dekenai ia oda, do idia hakaua lao. Vadaeni idia ese Aberamo mai ena adavana, mai ena kohu ibounai, be edia tanobada ena murimurina dekenai idia atoa. ");
INSERT INTO hmo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Aberamo ese Aigupito ena tano ia rakatania, ia bona iena adavana danu. Iena kohu ibounai ia abia lao. Idia lao mirigini kahanai, Negebe ena tano dekenai. Lota danu idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Aberamo be kohu momo tauna, iena mamoe, nanigosi, boromakau, siliva bona golo be momo herea. ");
INSERT INTO hmo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Negebe dekena amo ia laolao, ia lao Betele hanua dekenai, vadaeni iena palai ruma ia haginia lou, ena gabu gunana dekenai, Betele hanua bona Ai hanua edia huanai. ");
INSERT INTO hmo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Unai gabu be guna boubou patana ia karaia gabuna. Unuseni Aberamo be Lohiabada dekenai ma ia tomadiho. ");
INSERT INTO hmo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lota danu, Aberamo danu ia lao tauna, be mai ena mamoe, nanigosi bona boromakau, bona ia danu idia noho palai ruma taudia danu. ");
INSERT INTO hmo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tano be hegeregere lasi idia ruaosi gabu tamona dekenai do idia noho hebou, badina be edia boromakau be momo herea. ");
INSERT INTO hmo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Unai dainai Aberamo ena boromakau naria taudia be Lota ena boromakau naria taudia danu idia heai. Unai neganai Kanana taudia bona Perisi taudia be unai tano dekenai idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Vadaeni Aberamo ese Lota dekenai ia gwau, “Ita be varavara, oiemu taudia bona lauegu taudia idia heai be dika. ");
INSERT INTO hmo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ita parara be namo. Oiemu ura tano mani oi abia hidi, vadaeni oi ese lau oi rakatania. Oi be kahana oi lao, lau be kahana do lau lao.” ");
INSERT INTO hmo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Vadaeni Lota ese iena matana ia negea, Ioridane Sinavai ena koura ia itaia, ibounai be mai edia ranu. Ia be Lohiabada ena uma gabu bamona, bona Aigupito ena tano bamona danu, ia lao bona Soara. (Inai be Lohiabada ese Sodoma hanua bona Gomora hanua ia hadikaia ore lasi neganai.) ");
INSERT INTO hmo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Vadaeni Lota ese Ioridane koura ibounai ia abia hidi, bona dina ia daekau kahana dekenai ia lao. Idia ruaosi idia parara unai bamona. ");
INSERT INTO hmo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aberamo be Kanana ena tano dekenai ia noho, bona Lota be koura ena hanuadia dekenai ia lao, bona Sodoma kahirakahira dekenai ia ese iena palai ruma ia haginia. ");
INSERT INTO hmo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodoma taudia be dika bada, Lohiabada ena vairana dekenai kara dika bada idia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lota ia rakatania murinai, Lohiabada ese Aberamo dekenai ia hereva, ia gwau, “Inai gabu dekena amo oiemu matana oi negea kahana ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Hari oi itaia noho tano ibounai oi dekenai, bona oiemu tubuna dekenai do lau henia, ia lao bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Oi dekenai tubuna momo herea do lau henia, bona tau ta ese idia do ia duahia diba lasi, tanobada ena tano kahu ibounai ena momo ia duahia diba lasi bamona. ");
INSERT INTO hmo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Oi toreisi, inai tano ibounai do oi hanaia lao, badina be ibounai oi dekenai do lau henia.” ");
INSERT INTO hmo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Vadaeni Aberamo ese iena palai ruma ia lokua, ia toreisi, ia lao Heberona dekenai. Unuseni ia noho, Mamare ena au helagadia kahirakahira. Unuseni boubou patana ta ia karaia, Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Amarapela, Sinara tano ena king, Arioka, Elasara tano ena king, Kedoralaomere, Elama tano ena king, bona Tidala, Goimi tano ena king, ");
INSERT INTO hmo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","be idia lao tuari king 5 danu, Bera, Sodoma ena, Birisa, Gomora ena, Sinaba, Adima ena, Semebere, Seboimi ena, bona Bela ena king. Bela ena ladana ta be Soara. ");
INSERT INTO hmo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Inai king 5 be idia haboua tamona Sidima Koura dekenai. Inai gabu, hari ena ladana be Mase Davara. ");
INSERT INTO hmo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Lagani 12 lalonai idia be king Kedoralaomere dekenai hesiai gaukara idia karaia, to lagani namba 13 dekenai idia toreisi, idia tuari henia. ");
INSERT INTO hmo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Lagani namba 14 dekenai Kedoralaomere, mai ena durua taudia danu, ese ia toreisi, Repaima taudia, Asataroto Karanaimi dekenai ia halusidia, bona Susima taudia, Hamo dekenai ia halusidia, bona Emima taudia, Save Kiriataimi dekenai ia halusidia. ");
INSERT INTO hmo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hori taudia danu, edia ororo, ladana Seiri dekenai ia halusidia, bona ia luludia ia lao bona El Parana, taunimanima noho lasi tano ena hetoa badinai. ");
INSERT INTO hmo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Vadaeni Kedoralaomere ia giroa mai Kadesi dekenai, (ena ladana ta be “Kota Hereva ena Ranu Gabuna”), bona ia ese Amaleka taudia ibounai idia halusidia. Ma ia ese Amoro taudia, Hasasono Tamara dekenai idia noho, danu ia halusidia. ");
INSERT INTO hmo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Vadaeni Sodoma ena king bona Gomora ena king bona Adima ena king bona Seboimi ena king bona Bela (ladana ta be Soara) ena king, be edia tuari taudia idia haboua Sidima Koura dekenai, tuari totona. ");
INSERT INTO hmo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Inai king 5 ese king 4, Kedoralaomere, Elama ena king, bona Tidala, Goimi ena king, bona Amarapela, Sinara ena king, bona Arioka, Elasara ena king dekenai idia tuari henia. ");
INSERT INTO hmo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Unai Sidima Koura be mai ena pisi guri momo herea. Vadaeni Sodoma ena king bona Gomora ena king be tuari dekena amo idia ura heau neganai, pisi guri lalonai idia moru. To taunimanima oredia be ororo dekenai idia heau mauri. ");
INSERT INTO hmo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Unai king 4 ese kohu ibounai bona aniani ibounai Sodoma bona Gomora dekenai idia dadia, bona hanua idia rakatania lao. ");
INSERT INTO hmo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lota, Aberamo ena vavana, Sodoma dekenai ia noho. Vadaeni idia ese ia danu idia dogoatao, idia abia lao, mai ena kohu ibounai. ");
INSERT INTO hmo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","To heau mauri tauna ta ia lao, Aberamo, Heberu tauna dekenai ia hamaoroa. Aberamo be Mamare, Amoro tauna, Esakolo bona Anere edia kakana ena au helagadia kahirakahira ia noho. Inai tau toi be Aberamo danu idia turana karaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Aberamo ia kamonai iena varavara be idia abia mauri. Vadaeni, ia ese iena palai ruma noho tuari taudia ia haboua. Idia ibounai be tatau 318. Bona idia ese unai king taudia murinai idia raka, ia lao bona Dano hanua. ");
INSERT INTO hmo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Unuseni Aberamo bona ena tatau idia parara, orea rua idia lao, hanuaboi lalonai unai king taudia idia tuari henidia, idia halusidia. Bona Aberamo ia luludia, ia lao bona Hoba, Damaseko ena mirigini kahana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kohu ibounai idia abia lou. Aberamo ena varavara Lota mai ena kohu danu, bona hahine bona taudia momo danu ia abia lou. ");
INSERT INTO hmo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Aberamo ese Kedoralaomere bona king haida ia halusidia murinai, ia giroa mai, bona Sodoma ena king ese ia danu ia hedavari Save Koura dekenai, ena ladana ta be, King ena Koura. ");
INSERT INTO hmo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Vadaeni Melekisedeka, Salema ena king, ia be Ataiai Momokani Dirava ena helaga tauna, ese paraoa bona uaina ia mailaia Aberamo dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ia ese Aberamo ia hanamoa, ia gwau, “Ataiai Momokani Dirava, guba bona tanobada karaia Dirava ese, Aberamo ia hanamoa be namo, ");
INSERT INTO hmo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ataiai Momokani Dirava lau hanamoa inai. Ia ese kwalimu oi dekenai ia henia, oi dekenai idia tuari taudia dekena amo.” Bona Aberamo ese ia abia kohu ibounai ia haria kahana 10, bona kahana ta Melekisedeka dekenai ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Bona Sodoma ena king ese Aberamo dekenai ia hereva, ia gwau, “Oi abia kohu ibounai oi dogoatao noho, to lauegu taunimanima sibona lau dekenai oi henia. ");
INSERT INTO hmo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","To Aberamo ese ia haere, ia gwau, “Lau ese Lohiabada, Ataiai Momokani Dirava, guba bona tanobada ia karaia Diravana ena vairanai hari lau gwauhamata metau henia, ");
INSERT INTO hmo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","lau gwau, oiemu kohu ta do lau abia lasi, tamaka varo danu do lau abia lasi. Gabeai do oi gwau, ‘Aberamo ena kohu momo be lau dekena amo ia abia’ garina. ");
INSERT INTO hmo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Lau sibona be gau ta do lau abia lasi. Lauegu taudia idia ania vadaeni aniani sibona lau dekenai oi henia. Bona lauegu turana Anere bona Esakolo bona Mamare edia kohu kahana do idia abia, inai sibona.” ");
INSERT INTO hmo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Inai murinai, Lohiabada ena hereva Aberamo ia kamonai, mata hanai lalonai. Lohiabada ia gwau, “Aberamo e, oi gari lasi. Lau be oiemu kesi. Oi dekenai hanamoa do lau habadaia.” ");
INSERT INTO hmo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","To Aberamo ia gwau, “Egu Lohiabada Dirava e, lau be natuna lasi. Edena bamona lau dekenai hanamoa do oi habadaia? Lauegu kohu do ia abia tauna be tamona, Eliesere, Damaseko tauna. ");
INSERT INTO hmo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Oi be natuna ta lau dekenai oi henia lasi, bona egu hesiai tauna ese lauegu kohu do ia abia.” ");
INSERT INTO hmo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Vadaeni, Lohiabada ena hereva Aberamo ese ia kamonai lou. Lohiabada ia gwau, “Inai hesiai tauna be oiemu kohu do ia abia lasi, oiemu natuna korikori ese oiemu kohu do ia abia.” ");
INSERT INTO hmo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Lohiabada ese ia hakaua murimuri dekenai, ia gwau, “Guba oi itaia, hisiu oi duahia diba o lasi? Oiemu tubuna edia momo be dohore unai bamona.” ");
INSERT INTO hmo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Vadaeni, Aberamo ese Lohiabada dekenai ia abidadama henia, unai dainai Lohiabada ia gwauraia, Aberamo be maoro. ");
INSERT INTO hmo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Lohiabada ma ia dekenai ia hereva lou, ia gwau, “Lau Lohiabada ese Uru, Kaledea ena hanua dekena amo oi lau hakaua vadaeni, inai tano oi dekenai do lau henia, oiemu tano korikori totona.” ");
INSERT INTO hmo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","To Aberamo ia gwau, “Lohiabada Dirava e, edena bamona do lau diba inai be lauegu tano korikori?” ");
INSERT INTO hmo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Lohiabada ia gwau, “Boromakau hahine ta, lagani toi gauna, bona nani ta, lagani toi gauna, bona mamoe tau, lagani toi gauna, bona manu ena ladana kerea ta, bona pune manu natuna ta, oi mailaia lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Aberamo ese inai ibounai ia abia mai, ia utudia parara, kahana rua idia lao, bona kahana rua rua dekenai ia haboua, to manu ia utudia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Galo manudia idia diho vamu dekenai, to Aberamo ese ia luludia. ");
INSERT INTO hmo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Dina ia diho neganai, Aberamo ia mahuta mase, bona gari bada ese ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Lohiabada ese ia dekenai ia hereva, ia gwau, “Momokani, oiemu tubuna be idau tano dekenai dohore idia noho, idau taudia bamona. Unuseni hesiai gaukara davana lasi do idia karaia, bona hisihisi do idia abia lagani 400 dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","To idia dekenai hesiai gaukara do idia henia besena be do lau panisia, bona unai tano oiemu bese taudia ese do idia rakatania neganai, kohu momo do idia abia lao. ");
INSERT INTO hmo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","To oiemu mauri lagani be do momo herea, bona mai maino danu do oi mase, bona oi buruka momokani neganai, do idia guria oi. ");
INSERT INTO hmo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Oiemu tubuna be inai tano dekenai do idia giroa mai lasi, ia lao bona uru 4 do idia ore vadaeni. Badina be inai Amoro taudia do lau luludia diba lasi, ia lao bona edia dika be bada, davana do lau henia dikana hegeregerena.” ");
INSERT INTO hmo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Dina ia diho, bona dibura ia mai neganai, lahi gauna mai ena kwalahu, bona kede idia hedinarai. Idia be vamu gaudia huanai idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Unai dina dekenai Lohiabada ese Aberamo dekenai ia gwauhamata, bona gwauhamata taravatuna ia karaia, ia gwau, “Lau ese oiemu tubuna taudia dekenai inai tano ibounai do lau henia: Aigupito ena sinavai dekena amo ia lao bona sinavai badana ladana Euperate. ");
INSERT INTO hmo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kene taudia edia tano, Kenise taudia edia tano, Kadamono taudia edia tano. ");
INSERT INTO hmo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hiti taudia edia tano, Perisi taudia edia tano, Repaima taudia edia tano, ");
INSERT INTO hmo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoro taudia edia tano, Kanana taudia edia tano, Girigasa taudia edia tano, bona Iebusu taudia edia tano.” ");
INSERT INTO hmo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Aberamo ena adavana, Sarai, be gabani, natuna ta ia abia lasi Aberamo dekenai. To ia be mai ena hesiai hahine ta, Aigupito hahine, iena ladana be Hagara. ");
INSERT INTO hmo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai ese Aberamo dekenai ia hereva, ia gwau, “Oi diba, Lohiabada ese natuna ta lau dekenai ia henia lasi. Oi dekenai lau noinoi, lauegu hesiai hahine oi abia, sedira natuna ta ia dekenai do lau abia.” Vadaeni Aberamo ese Sarai ena hereva dekenai ia kamonai henia. ");
INSERT INTO hmo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Unai dainai Sarai ese iena hesiai hahine Hagara, Aigupito hahine, ia abia, iena adavana Aberamo dekenai ia henia, do ia adavaia. Aberamo be lagani 10 Kanana dekenai ia noho murinai inai kara ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Aberamo be Hagara danu idia mahuta hebou murinai hahine be ia rogorogo. Hagara ia diba ia be rogorogo vadaeni dainai, iena biaguna hahine dekenai ia matauraia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Vadaeni Sarai ese Aberamo dekenai ia hereva, ia gwau, “Hagara ese lau ia matauraia lasi, be oiemu kerere dainai. Lauegu hesiai hahine lau henia oi dekenai, to ia diba ia be rogorogo neganai ia mai bona hari, ia ese lau ia matauraia lasi, Lohiabada ese ita ruaosi iseda huanai do ia gwauraia daika be maoro, bona daika be kerere.” ");
INSERT INTO hmo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","To Aberamo ese Sarai dekenai ia haere, ia gwau, “Vadaeni, hahine be oiemu imana dekenai, oiemu ura hegeregere oi karaia ia dekenai.” Vadaeni Sarai ese ia dagedage henia, ia lao bona Hagara be ia heau. ");
INSERT INTO hmo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Lohiabada ena aneru ese taunimanima lasi gabuna ena ranu guri ta dekenai Hagara ia davaria. Unai ranu guri be Suru dala ena badibadinai. ");
INSERT INTO hmo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Aneru ia gwau, “Hagara e, Sarai ena hesiai hahine, edeseni oi mai, bona edeseni do oi lao?” Ia haere, “Lau be Sarai dekena amo lau heau noho.” ");
INSERT INTO hmo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ia gwau, “Oi giroa lou, bona iena hereva oi kamonai henia.” ");
INSERT INTO hmo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Aneru ma ia gwau, “Lau ese tubuna momo oi dekenai do lau henia, duahia diba lasi. ");
INSERT INTO hmo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Oi be nega sisina lalonai, mero ta do oi abia. Iena ladana do oi atoa, Isamaela. Badina be Lohiabada ese oiemu hisihisi, bona emu tai ia kamonai vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","To oiemu natuna ese, uda doniki bamona do ia noho. Ia ese taunimanima ibounai dekenai, do ia dagedage henia, bona taunimanima ibounai ese, ia dekenai do idia dagedage henia. Ia be iena varavara danu do ia noho lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagara ese sibona dekenai ia henanadai, ia gwau, “Momokani, inai gabu dekenai Dirava lau itaia, to lau mauri noho?” Unai dainai Hagara ese Lohiabada ena ladana ia atoa, “Oi be lau oi itaia noho Diravana”. ");
INSERT INTO hmo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Unai dainai unai ranu guri Kadesi bona Beredi huanai, ena ladana idia atoa, “Lau ia itaia Mauri Tauna ena ranu guri”. ");
INSERT INTO hmo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Vadaeni, Hagara ia mara, mero ta ia abia, Aberamo ena. Bona Aberamo ese iena ladana ia atoa Isamaela, ena anina be, “Dirava ia kamonai noho.” ");
INSERT INTO hmo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Unai neganai Aberamo ena mauri lagani be 86. ");
INSERT INTO hmo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Aberamo ena mauri lagani be 99 neganai, Lohiabada ese ia dekenai ia hedinarai, ia gwau, “Lau be Siahu Ibounai Dirava, lau dekenai do oi kamonai oiemu mauri dinadia ibounai, bona kara maoromaoro do oi karaia. ");
INSERT INTO hmo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Lauegu gwauhamata taravatuna, oi bona lau iseda huanai lau karaia inai, bona tubudia momo do lau henia oi dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Vadaeni Aberamo ia tui diho, bona iena vairana ia atoa diho, tano dekenai. Dirava ia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Oi danu do lau badinaia gwauhamata taravatuna be inai: Oi be dohore bese momo edia tubuna. ");
INSERT INTO hmo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Oiemu ladana be do idia atoa lou lasi Aberamo, to do idia atoa Aberahamo, badina be bese momo havaraia tauna oi lau halaoa inai. ");
INSERT INTO hmo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Tubudia momo oi dekenai do lau henia, bona idia haida be dohore king taudia. Oiemu tubuna be momo dainai, bese momo dohore idia vara oi dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Lauegu gwauhamata taravatuna oi bona oiemu tubuna dekenai do lau badinaia vairai negadia dekenai. Ia be noho hanaihanai gwauhamata taravatuna. Lau be dohore oiemu Dirava, bona oiemu tubuna edia Dirava. ");
INSERT INTO hmo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Inai hari oi noho idau tauna bamona tano do lau henia oi dekenai, bona oiemu tubuna dekenai. Inai Kanana tano ibounai be oiemu, bona oiemu tubuna edia, ela bona hanaihanai, bona lau be edia Dirava do lau noho.” ");
INSERT INTO hmo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dirava ese Aberahamo dekenai ma ia hereva, ia gwau, “Oi danu ese inai gwauhamata taravatuna lau bona oi, iseda huanai do oi badinaia, oi bona oiemu tubuna taudia, vairai negadia lalonai. ");
INSERT INTO hmo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Inai gwauhamata taravatuna ena toana, be oi bona oiemu tubuna taudia ese do umui karaia momokani: Emui tatau ibounai be kopina utua kara do idia abia. ");
INSERT INTO hmo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Emui kopina do umui utua, inai be gwauhamata taravatuna oi bona lau iseda huanai ena toana. ");
INSERT INTO hmo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Emui memero ibounai ta ta dina 8 idia abia neganai, edia kopina do umui utua. Emui ruma dekenai vara hesiai taudia danu edia kopina do umui utua. Bona idau taudia dekena amo umui hoia hesiai taudia danu edia kopina do umui utua. ");
INSERT INTO hmo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Inai ibounai ta ta kopina utua kara do idia abia, bona inai be emui tauanina dekenai ena toa ta, lauegu hanaihanai noho gwauhamata taravatuna umui dekenai ena toana. ");
INSERT INTO hmo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Bema emui tau ta be kopina utua kara ia abia lasi, ia be iena bese taudia dekena amo do umui atoa siri, badina be lau dekenai gwauhamata taravatuna ia badinaia lasi dainai.” ");
INSERT INTO hmo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dirava ese Aberahamo dekenai ia hereva, ia gwau, “Oiemu adavana ena ladana oi atoa lou lasi Sarai, iena ladana hari be Sara. ");
INSERT INTO hmo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Lau ese do lau hanamoa, bona ia dekena amo natuna mero oi dekenai do lau henia. Lau ese Sara do lau hanamoa, bona ia be dohore bese idauidau edia sinana, bona iena tubuna haida be dohore king taudia.” ");
INSERT INTO hmo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Aberahamo ia tui diho, iena vairana ia atoa diho tano dekenai, to inai bamona ia laloa neganai, ia kiri, ia gwau, “Iena mauri lagani be 100 tauna, natuna ta do ia havaraia diba? Sara danu ena mauri lagani be 90, be dohore ia mara, a?” ");
INSERT INTO hmo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Dirava dekenai ia hereva, ia gwau, “Oi dekenai lau noinoi, Isamaela ena mauri do oi naria namonamo.” ");
INSERT INTO hmo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","To Dirava ia gwau, “Lasi, oiemu adavana Sara be natuna mero do ia havaraia, bona iena ladana do oi atoa Isako. Lauegu gwauhamata taravatuna Isako dekenai, bona iena tubuna dekenai do lau badinaia. Ia be noho hanaihanai gwauhamata taravatuna. ");
INSERT INTO hmo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Oi ese oi noinoi, lau ese Isamaela do lau naria, bona lau be inai bamona do lau karaia. Ia be dohore king natuna 12 edia tamana, bona iena tubudia dekenai bese badana ta do lau karaia. ");
INSERT INTO hmo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","To lauegu gwauhamata taravatuna oiemu natuna Isako dekenai be do lau badinaia. Ia be Sara dekenai do ia vara, vaira lagani inai bamona nega dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Dirava ese iena hereva ia hadokoa, vadaeni ia daekau, Aberahamo ia rakatania. ");
INSERT INTO hmo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Unai dina dekenai, Aberahamo ese iena natuna Isamaela bona iena hesiai memero ibounai edia kopina ia utua, iena ruma dekenai idia vara taudia, bona ia hoia taudia danu, iena ruma noho tatau ibounai, Dirava ena oda hegeregere. ");
INSERT INTO hmo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Aberahamo ena mauri lagani be 99 neganai kopina utua ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Iena natuna Isamaela ena mauri lagani be 13. ");
INSERT INTO hmo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Idia ruaosi be kopina utua idia abia dina tamona dekenai, ");
INSERT INTO hmo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","iena hesiai memero ibounai danu. ");
INSERT INTO hmo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Lohiabada ese Aberahamo dekenai ma ia hedinarai lou, Mamare ena au helagadia gabu dekenai. Dina tubu neganai Aberahamo ese iena palai ruma ena iduara dekenai ia helai noho. ");
INSERT INTO hmo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Vadaeni iena matana ia negea, tatau toi ia itaia unuseni idia gini. Ia itaia neganai, iena palai ruma iduara dekena amo ia heau lao, ia tui diho tano dekenai, ");
INSERT INTO hmo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ia gwau, “Lauegu Lohiabada e, lau ura oiemu ura lau karaia, mani emu kara lauegu ruma oi hanaia lasi, oi noho iniseni. Lau be oiemu hesiai tauna. ");
INSERT INTO hmo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Lau ura ranu totona do lau boiboi, idia mailaia, emui aena huria totona. Bona inai au henunai umui laga-ani. ");
INSERT INTO hmo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Aniani sisina do lau mailaia, goada do umui abia, gabeai emui dala dekenai ma do umui raka lao. Lauegu ruma dekenai umui mai vadaeni, unai dainai emui ura lau ura karaia.” Idia gwau, “Vadaeni, oiemu hereva hegeregere oi karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Aberahamo ese palai ruma lalonai karaharaga ia raka vareai, bona Sara dekenai ia gwau, “Karaharaga, paraoa namona ena metau 14 kilogram oi abia, oi karaia hegaegae, bona beredi oi gabua.” ");
INSERT INTO hmo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Vadaeni ia heau lao iena boromakau dekenai, boromakau natuna ta ia abia, ena hidiona be manokamanoka bona mai digara danu, iena hesiai tauna dekenai ia henia, vadaeni karaharaga ia lao, ia nadua. ");
INSERT INTO hmo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Bata bona rata ia abia, bona hari idia nadua vamu, bona inai tatau toi edia vairanai ia atoa. Idia aniani neganai, Aberahamo be idia kahirakahira au henunai ia gini. ");
INSERT INTO hmo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Gabeai ia dekenai idia henanadaia, idia gwau, “Oiemu adavana Sara be edeseni?” Ia gwau, “Ia be palai ruma lalonai.” ");
INSERT INTO hmo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Vadivadi tauna ta ia gwau, “Oi dekenai lau gwauhamata, hua 9 lalonai oiemu adavana Sara be natuna mero do ia abia. Unai neganai do lau giroa mai.” Sara be palai ruma iduara murinai ia gini, bona unai hereva ia kamonai noho. ");
INSERT INTO hmo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Aberahamo bona Sara be buruka momokani, bona Sara ena hua gorere ena nega be ia ore vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Unai dainai Sara be sibona lalona dekenai ia kiri, ia gwau, “Lau be buruka vadaeni, bona natuna abia nega be ia ore vadaeni, headava ena moale do lau abia noho? Bona lauegu adavana be ia buruka danu.” ");
INSERT INTO hmo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Bona Lohiabada ese Aberahamo dekenai ia henanadaia, ia gwau, “Sara be badina dahaka ia kiri, bona ia gwau, ‘Lau buruka neganai, edena bamona natuna ta lau abia, a?’ ");
INSERT INTO hmo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Be, hoa kara ia noho, Lohiabada ia karaia diba lasi, a? Hua 9 lalonai, nega korikori dekenai, do lau giroa mai, bona Sara be natuna mero do ia abia.” ");
INSERT INTO hmo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara be ia gari dainai, ia koikoi, ia gwau, “Lau kiri lasi.” To ia gwau, “Lasi, momokani, oi kiri.” ");
INSERT INTO hmo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Vadaeni inai tatau idia toreisi, Sodoma dala dekenai idia raka lao, Sodoma idia itaia totona, gabu ta dekenai idia gini, bona Aberahamo be idia danu ia lao, dala ia hadibaia totona. ");
INSERT INTO hmo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Bona Lohiabada be sibona lalona dekenai ia gwau, “Dohore lau karaia kara lau hunia diba lasi Aberahamo dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Badina be iena tubudia be dohore bese badana bona goadana, bona tanobada ena bese ibounai be dohore idia noinoi, idia do lau hanamoa, ia lau hanamoa bamona. ");
INSERT INTO hmo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Lau ese ia lau abia hidi, ia ese iena natudia bona iena tubudia dekenai lauegu taravatu do ia hadibaia namonamo totona. Vadaeni idia ese lauegu taravatu do idia kamonai henia, kara maoromaoro bona kara namona dekenai. Inai murinai lauegu gwauhamata ibounai do lau hamomokania ia dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Bona Lohiabada ia gwau, “Sodoma bona Gomora be dika rohoroho, bona edia kara dika be bada herea. ");
INSERT INTO hmo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Harihari do lau diho, lau itaia, lau kamonai sivarai be ia momokani o lasi. Do lau diba namonamo.” ");
INSERT INTO hmo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Vadaeni unai tatau ese unai gabu idia rakatania, idia lao Sodoma kahana, to Lohiabada be Aberahamo danu ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Aberahamo ese Lohiabada kahirakahira dekenai ia lao, ia henanadaia, ia gwau, “Momokani, oi ese kara maoromaoro bona kara dika taudia danu nega tamona do oi alaia ore? ");
INSERT INTO hmo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Bema kara maoromaoro taudia 50 hanua dekenai idia noho, be hanua ibounai do oi hadikaia ore, a? Hanua dekenai do oi bogahisihisi diba, unai 50 hamauria totona? ");
INSERT INTO hmo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kara maoromaoro taudia bona kara dika taudia nega tamona do oi alaia lasi, a? Kara maoromaoro taudia bona kara dika taudia, bema edia davana be tamona, be hegeregere lasi. Unai bamona be oiemu kara lasi. Tanobada ibounai ena kota biaguna be kara maoromaoro do ia karaia lasi, a?” ");
INSERT INTO hmo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Bona Lohiabada ia gwau, “Bema Sodoma dekenai kara maoromaoro taudia 50 lau davaria, hanua ibounai dekenai do lau bogahisihisi idia dainai.” ");
INSERT INTO hmo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Bona Aberahamo ma ia hereva, ia gwau, “Lohiabada e, lau be hegeregere lasi oi dekenai do lau hereva, badina lau be taunimanima sibona. Lauegu hereva dikana mani oi gwauatao. ");
INSERT INTO hmo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","To sedira kara maoromaoro taudia be 50 lasi, 45 sibona. Bema 5 sibona be lasi, hanua ibounai do oi hadikaia ore, a?” Lohiabada ia gwau, “Bema kara maoromaoro taudia 45 lau davaria, hanua do lau hadikaia ore lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Aberahamo ma ia hereva lou, ia gwau, “Sedira 40 sibona idia noho?” Ia haere, “Bema 40 idia noho, lau be do lau hadikaia ore lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Aberahamo ia gwau, “Lohiabada e, lau ura noinoi lou, mani oi badu lasi. Bema 30 sibona, be edena bamona?” Lohiabada ia gwau, “Bema 30 lau davaria, do lau hadikaia ore lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Aberahamo ia gwau, “Lohiabada e, lau hereva noho, hereva noho, ena dika mani oi gwauatao. Bema 20 sibona idia noho, be edena bamona?” Ia gwau, “Bema 20 lau davaria, hanua do lau hadikaia ore lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Aberahamo ia gwau, “Lohiabada e, mani oi badu lasi, inai nega tamona sibona ma do lau hereva, bema 10 sibona oi davaria, be edena bamona?” Ia gwau, “Bema 10 sibona idia noho do lau hadikaia ore lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Lohiabada ena hereva Aberahamo danu ia ore neganai, ia rakatania, bona Aberahamo be ia giroa lou ena noho gabuna dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Adorahi kahana neganai, aneru ruaosi ese Sodoma dekenai idia mai. Unuseni Lota be hanua ena iduara badana dekenai ia helai noho, taunimanima edia hebou gabunai. Lota ese ia itadia neganai, ia toreisi, idia dekenai ia lao, hedavari totona. Idia edia vairana dekenai ia tui diho, bona iena vairana tano dekenai ia atoa diho. ");
INSERT INTO hmo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ia gwau, “Lauegu biagudia e, lau be emui hesiai tauna, mani emui kara egu ruma dekenai umui daekau mai. Emui aena umui huria, bona hari hanuaboi iniseni umui mahuta. Dabai do umui toreisi bona emui dala dekenai do umui raka lou.” To idia gwau, “Lasi, hanua ena huana dekenai do ai noho ia lao bona dabai.” ");
INSERT INTO hmo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","To ia noinoi goada noho, ia lao bona idia be ia danu iena ruma dekenai idia raka vareai. Lota ese paraoa kavakava ia gabua, bona aniani namona ia nadua, vadaeni idia ania. ");
INSERT INTO hmo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Idia do hekure lasi neganai, Sodoma ena tatau ese ruma idia gini hagegea. Hanua ena tatau ibounai unuseni idia mai, uhau bona buruka. ");
INSERT INTO hmo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Lota dekenai idia boiboi, idia henanadaia, “Hari hanuaboi oiemu ruma dekenai noho tatau be edeseni? Murimuri dekenai oi hakaudia, bona do ai sihari henidia.” ");
INSERT INTO hmo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lota ese murimuri dekenai ia raka, bona iduara ia koua ia murinai. ");
INSERT INTO hmo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Idia dekenai ia hereva, ia gwau, “Lauegu turadia e, umui dekenai lau noinoi, inai kara dika umui karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Umui itaia, lauegu natuna kekeni rua idia noho, idia be sihari do diba lasi. Mani, umui dekenai do lau hakaudia, bona idia dekenai umui karaia, emui ura hegeregerena. To inai tatau rua be do umui hadikaia lasi, badina idia be lauegu ruma ena vadivadi taudia bona lau naridia be gau badana.” ");
INSERT INTO hmo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","To idia gwau, “Oi gini siri, oi be idau tauna! Oi be daika oi hadibaia ai dekenai? Oi gini siri, ai ese idia do ai hadikaia maragi, to oi do ai hadikaia bada garina.” Vadaeni, idia ese Lota idia doria siri, iduara hamakohia gwauraia. ");
INSERT INTO hmo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","To unai tatau ruaosi be ruma lalona dekena amo imadia idia atoa, Lota idia veria vareai, bona iduara idia koua. ");
INSERT INTO hmo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Bona idia ese murimurinai gini tatau ibounai edia matadia idia hakepuludia, vadaeni iduara idia davaria diba lasi. ");
INSERT INTO hmo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Vadaeni, inai tatau ruaosi ese Lota dekenai idia henanadaia, idia gwau, “Oiemu varavara haida ma idia noho iniseni, o lasi? Bema oiemu ravana, o oiemu natudia memero o oiemu varavara ta ia noho inai hanua dekenai, oi abidia, bona inai gabu umui rakatania. ");
INSERT INTO hmo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Badina be inai gabu do ai hadikaia ore. Lohiabada ese inai taunimanima edia kara dika bada ena sivarai ia kamonai vadaeni, bona ia ese ai ia siaia, Sodoma do ai hadikaia ore totona.” ");
INSERT INTO hmo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Vadaeni, Lota ese iena natuna kekeni edia maoheni tatau dekenai ia lao, ia gwau, “Karaharaga, umui toreisi, inai gabu ita rakatania, badina be Lohiabada ese inai hanua do ia hadikaia ore.” To idia laloa ia be hevaseha sibona. ");
INSERT INTO hmo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Daba rere dekenai, inai aneru ese Lota dekenai idia hereva goada, idia gwau, “Karaharaga! Oiemu adavana bona oiemu natudia kekeni ruaosi oi abidia, inai gabu rakatania, do ia hadikaia ore neganai umui danu mase garina.” ");
INSERT INTO hmo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","To Lota be ia haraga lasi, unai dainai inai tatau ruaosi ese ia bona ena adavana bona ena natudia kekeni edia imadia idia abia, bona hanua ena murimuri kahana dekenai idia hakaua, badina be Lohiabada ese idia dekenai ia bogahisihisi. ");
INSERT INTO hmo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Hanua ena murimuri kahana dekenai idia hakaudia murinai, aneru ta ia gwau, “Umui heau mauri. Umui emui vairana umui giroa murina dekenai lasi, bona tano palaka gubuna dekenai umui naria lasi. Ororo dekenai do umui heau, umui mase garina.” ");
INSERT INTO hmo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","To Lota ese idia dekenai ia noinoi, “Lohia e, mani emui kara, inai bamona lasi. ");
INSERT INTO hmo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Oi ese kara namona lau dekenai oi karaia vadaeni, lau dekenai oi bogahisihisi, bona lau oi hamauria vadaeni. To ororo be daudau, bona lau be goada lasi dekenai inai dika gauna ese lau dekenai do ia moru, vadaeni, do lau mase. ");
INSERT INTO hmo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Unai hanua maragina oi itaia, a? Ia be kahirakahira, bona ia dekenai lau heau diba. Mani emui kara unuseni do lau lao. Ia be gabu maragina sibona, bona unuseni mauri do lau davaria.” ");
INSERT INTO hmo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Aneru ia haere, “Oiemu noinoi dekenai lau kamonai, unai hanua do lau hadikaia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Karaharaga! Heau! Lau be kara lau karaia diba lasi ela bona oi be unuseni oi ginidae.” Lota ese ia gwauraia maragi dainai, unai hanua ena ladana idia atoa Soara, iena anina be “Maragi”. ");
INSERT INTO hmo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Dina ia daekau neganai, Lota be Soara dekenai ia ginidae. ");
INSERT INTO hmo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Vadaeni, Lohiabada ese salipa nadi mai lahi bada danu guba dekena amo ia negea diho, Sodoma bona Gomora edia latanai. ");
INSERT INTO hmo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Unai hanua badadia, bona tano palaka ibounai, bona hanua taudia, bona unai tano dekenai vara gaudia ibounai Lohiabada ese ia hadikaia ore. ");
INSERT INTO hmo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","To Lota ena adavana ese iena vairana ia giroa murina kahana dekenai, vadaeni Lohiabada ese damena nadi dekenai ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Daba maragi dekenai Aberahamo ia toreisi, guna Lohiabada ena vairanai ia gini gabuna dekenai ia raka lao haraga. ");
INSERT INTO hmo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Iena matana ia negea diho, Sodoma bona Gomora, bona tano palaka ibounai ia itaia, unai tano ibounai dekena amo kwalahu ia daekau noho, amu badana ena kwalahu bamona. ");
INSERT INTO hmo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","To tano palaka ena hanua badadia ia hadikaia ore neganai, Dirava ese Aberahamo ia laloa, bona Lota ena mauri dala ia kehoa. ");
INSERT INTO hmo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lota ese Soara ia rakatania, ororo dekenai ia daekau lao, unuseni ia noho, ia bona iena natuna kekeni danu, badina be Soara dekenai ia noho be ia gari. Unai ororo ena nadi kohua ta lalonai idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Vara guna kekeni ese iena tadina dekenai ia hereva, ia gwau, “Iseda tamana ia buruka, bona inai tanobada kahana dekenai ita do idia headava tatau be lasi, vadaeni natudia do ita abia ena dala be lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Oi mai, iseda tamana do ita hakekeroa, vadaeni ia dekenai do ita sihari, bona natudia do ita abia iseda tamana dekena amo.” ");
INSERT INTO hmo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Unai hanuaboi, ia dekenai uaina idia henia, ia inua. Vadaeni vara guna kekeni be iena tamana danu idia sihari, to ia be kekero dainai ia diba lasi dahaka ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kerukeru, vara guna kekeni ese iena tadina dekenai ia hamaoroa, ia gwau, “Varani hanuaboi iseda tamana danu lau sihari. Hari hanuaboi ita hakekeroa lou be namo, bona oi danu ese lau karaia bamona do oi karaia. Unai dekena amo ita ruaosi natudia do ita abia iseda tamana dekena amo.” ");
INSERT INTO hmo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Vadaeni, unai hanuaboi idia hakekeroa, bona tadina kekeni be iena tamana danu idia sihari. Ia be kekero dainai ia diba lasi dahaka ia vara. ");
INSERT INTO hmo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Inai dala dekenai, Lota ena natuna kekeni ruaosi be edia tamana ese ia harogorogodia. ");
INSERT INTO hmo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Vara guna kekeni be mero ia abia, ladana ia atoa Moaba. Ia be hari idia noho Moaba bese taudia edia tubuna. ");
INSERT INTO hmo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Tadina kekeni danu mero ia abia, iena ladana ia atoa Benami. Ia be hari idia noho Amono bese taudia edia tubuna. ");
INSERT INTO hmo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Unai neganai Aberahamo ia toreisi, ia laolao, diho kahana dekenai ia lao, Gerara dekenai ia noho, Kadesi bona Suru edia huanai. ");
INSERT INTO hmo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Vadaeni Aberahamo ese Sara totona ia hereva, ia gwau, “Ia be lauegu taihuna.” Vadaeni Abimeleka, Gerara ena king ese ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Unai hanuaboi Dirava ese Abimeleka ia hedinarai henia nihi dekenai, ia gwau, “Oi kamonai, oi be mase tauna, inai hahine oi abia dainai, badina ia be tau ta ena adavana.” ");
INSERT INTO hmo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","To Abimeleka be inai hahine dekenai be ia do sihari henia lasi. Vadaeni ia gwau “Lohiabada e, kara maoromaoro tauna do oi alaia mase, a? ");
INSERT INTO hmo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Inai tau ese ia hamaoroa lau dekenai, ia gwau, ‘Inai be lauegu taihuna, ani?’ Hahine danu ia hamaoroa lau dekenai, ia gwau, ‘Ia be lauegu taihuna.’ Inai kara lau karaia neganai, lauegu laloa be mai maoromaoro danu, bona lauegu imana be miro lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Vadaeni Dirava ese nihi dekenai ia haere henia, ia gwau, “Lau diba oiemu laloa be kerere lasi inai kara oi karaia neganai. Unai dekenai lauegu vairana dekenai do oi kerere garina lau koua oi, do oi sihari henia lasi totona. ");
INSERT INTO hmo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Unai dainai unai tau dekenai iena adavana do oi henia lou, badina ia be peroveta tauna, vadaeni ia ese oi totona do ia guriguri, vadaeni do oi mauri. To bema oi henia lou lasi, oi diba momokani, dohore oi mase, oi bona oiemu ruma taudia ibounai.” ");
INSERT INTO hmo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Unai dainai Abimeleka ia toreisi, iena hesiai taudia ibounai dekenai ia boiboi, unai kara ia hamaoroa idia dekenai, vadaeni idia gari maragi lasi. ");
INSERT INTO hmo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Vadaeni Abimeleka ese Aberahamo dekenai ia boiboi, ia gwau, “Edena bamona oi karaia vadaeni ai dekenai? Edena kerere oi dekenai lau karaia dainai lau bona lauegu basileia dekenai inai bamona oi karaia do ai kerere totona? Mai taravatu ena kara ta oi karaia vadaeni lau dekenai?” ");
INSERT INTO hmo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleka ese Aberahamo dekenai ma ia nanadaia, ia gwau, “Dahaka totona inai kara oi karaia vadaeni?” ");
INSERT INTO hmo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Vadaeni Aberahamo ia haere, ia gwau, “Badina be lau laloa inai gabu dekenai Dirava dekenai matauraia kara be lasi, vadaeni lau laloa be, lauegu adavana totona dohore idia alaia mase lau. ");
INSERT INTO hmo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Bona inai danu, ia be momokani lauegu taihuna, aiemai tamana be tamona, to aiemai sinana be idau, vadaeni ai ruaosi ai headava. ");
INSERT INTO hmo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","To Dirava ese lau ia siaia, lauegu tamana ena ruma lau rakatania neganai, Sara dekenai lau hamaoroa, lau gwau, “Inai bamona do oi bogahisihisi lau dekenai, do ita lao gabu ibounai dekenai do oi hereva lau totona, oi gwau, ‘Ia be lauegu taihuna.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Vadaeni Abimeleka ese mamoe bona boromakau bona hesiai taudia bona hesiai hahine be Aberahamo dekenai ia henia, bona iena adavana Sara ia henia lou. ");
INSERT INTO hmo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleka danu ia gwau, “Oi itaia, lauegu tano ibounai be oiemu vairana dekenai, oiemu ura gabuna dekenai do oi noho.” ");
INSERT INTO hmo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ia ese Sara dekenai danu ia hamaoroa, ia gwau, “Oi itaia, siliva moni 1,000 oiemu taihuna dekenai lau henia vadaeni, oiemu hemarai kokia totona taunimanima ibounai edia vairana dekenai. Ibounai do idia diba oi be kerere oi karaia lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Inai kara Sara dekenai ia vara dainai, Lohiabada ese Abimeleka ena hahine ibounai edia natuna havaraia dalana ia koua. Unai dainai Aberahamo ese Dirava dekenai ia guriguri, vadaeni Dirava ese Abimeleka ia hanamoa lou, bona iena adavana bona iena hesiai hahine danu ia hanamoa lou, vadaeni edia natuna idia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Lohiabada ese Sara ia durua, iena gwauhamata hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Vadaeni ia be rogorogo, bona mero ta ia abia Aberahamo dekenai, ia be buruka neganai. Mero ena vara nega be Dirava ia gwauraia guna hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Aberahamo ese iena natuna mero ena ladana ia atoa Isako. ");
INSERT INTO hmo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Mero ena mauri dinadia be 8 neganai, Aberahamo ese iena kopina ia utua, Dirava ena oda hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aberahamo ena mauri lagani be 100, Isako ia vara neganai. ");
INSERT INTO hmo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara ia gwau, “Dirava ese lau dekenai moale bona kiri ia henia vadaeni. Lauegu sivarai idia kamonai taudia ibounai be do idia kiri lau danu.” ");
INSERT INTO hmo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ma ia gwau, “Daika ese Aberahamo dekenai ia hamaoroa diba, Sara ese iena natuna dekenai rata do ia henia? To momokani, lau buruka neganai, natuna mero lau havaraia vadaeni ia dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mero be ia tubu, bona rata ia negea dina dekenai, Aberahamo ese aria badana ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Dina ta Hagara, Aigupito hahine ena natuna Isamaela, Aberahamo ese ia havaraia merona, be Isako danu idia gadara noho. ");
INSERT INTO hmo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara ia itaia, bona Aberahamo dekenai ia gwau, “Unai hesiai hahine mai ena natuna oi lulua lao. Badina be namo lasi unai hesiai hahine ena natuna ese oiemu kohu kahana do ia abia. Lauegu natuna Isako sibona ese inai kohu do ia abia.” ");
INSERT INTO hmo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Aberahamo ena lalona be hisihisi bada, badina Isamaela danu be iena natuna. ");
INSERT INTO hmo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","To Dirava ese Aberahamo dekenai ia hereva, ia gwau, “Unai mero bona oiemu hesiai hahine Hagara dekenai oi laloa momo lasi. Sara ena ura do oi karaia, badina be Isako dekena amo, lau gwauhamata vadaeni bese, be do oi abia. ");
INSERT INTO hmo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Lau be natuna momo danu hesiai hahine ena mero dekenai do lau henia, bona idia be dohore bese ta. Ia danu be oiemu natuna.” ");
INSERT INTO hmo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kerukeru, daba maragi neganai, Aberahamo ese Hagara dekenai aniani bona ranu danu be nani kopina lalonai ia henia. Idia be Hagara ena doruna dekenai ia atoa, bona ia siaia lao, mero danu. Vadaeni, hahine ia lao, bona Bere Sieba ena taunimanima lasi gabuna dekenai ia loaloa. ");
INSERT INTO hmo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ranu ia ore vadaeni neganai, ia ese mero ia atoa au maragina henunai. ");
INSERT INTO hmo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Vadaeni, sisina ia raka lao, diba pidia ena daudau hegeregerena, bona ia helai diho. Sibona dekenai ia hereva, ia gwau, “Mero ena mase lau ura lasi lau itaia.” Unuseni ia helai noho neganai, natuna ia tai hamatamaia. ");
INSERT INTO hmo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dirava ese mero ena tai ia kamonai, bona Dirava ena aneru guba dekena amo Hagara dekenai ia hereva, ia gwau, “Hagara e, dahaka dekenai oi laloa momo? Oi gari lasi. Dirava ese mero ena tai ia kamonai vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Oi toreisi, mero oi abia isi, bona oiemu imana dekenai oi dogoatao. Iena natudia dekena amo bese badana do lau havaraia.” ");
INSERT INTO hmo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Dirava ese hahine ena matana ia kehoa, bona ranu guri ta ia itaia, vadaeni nani ena kopina ia hahonua, mero dekenai ranu ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ia tubu daekau noho neganai, Dirava ese unai mero Isamaela dekenai ia noho. Ia be Parana tano ena taunimanima lasi gabuna dekenai ia noho, bona ia be labana diba momo tauna. ");
INSERT INTO hmo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Iena sinana ese hahine ta Aigupito dekena amo ia abia, Isamaela ese ia adavaia. ");
INSERT INTO hmo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Unai neganai Abimeleka bona Pikola, iena tuari orea ena biaguna, ese Aberahamo dekenai idia lao, idia gwau, “Dirava ese oi danu ia noho oiemu kara ibounai lalonai. ");
INSERT INTO hmo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Unai dainai, Dirava ena vairana dekenai gwauhamata oi henia, lau o lauegu natuna o lauegu tubuna do oi koia lasi. Lau be oi dekenai nega ta lau koikoi lasi, unai dainai lau dekenai oi gwauhamata, kara namo sibona do oi karaia lau dekenai, bona inai hari oi noho tano dekenai danu.” ");
INSERT INTO hmo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Aberahamo ia gwau, “Vadaeni, lau gwauhamata inai.” ");
INSERT INTO hmo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","To Aberahamo ese Abimeleka dekenai ia maumau, ia gwau, “Oiemu hesiai taudia ese lauegu ranu guri ta idia abia kava.” ");
INSERT INTO hmo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleka ia gwau, “Lau diba lasi inai kara, lau oi hamaoroa lasi guna, bona inai hereva be hari sibona lau kamonai.” ");
INSERT INTO hmo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Vadaeni Aberahamo ese mamoe bona boromakau haida Abimeleka dekenai ia henia, bona idia ruaosi maino idia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Aberahamo ese iena mamoe orea dekena amo mamoe natudia 7 ia abia siri. ");
INSERT INTO hmo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleka ese Aberahamo dekenai ia henanadaia, ia gwau, “Badina dahaka inai bamona oi karaia?” ");
INSERT INTO hmo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Aberahamo ia haere, ia gwau, “Inai mamoe natudia 7 oi abia dae be namo. Inai oi karaia neganai, oi gwauraia hedinarai lau ese inai ranu guri lau geia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Vadaeni unai gabu ena ladana idia atoa Bere Sieba, badina be idia ruaosi idia gwauhamata hebou. ");
INSERT INTO hmo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Vadaeni Bere Sieba dekenai maino idia karaia, inai murinai Abimeleka bona Pikola, iena tuari orea ena biaguna, idia giroa lou Pilistia, edia tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Bona Aberahamo ese au ta ia hadoa Bere Sieba dekenai, bona Lohiabada, Noho Hanaihanai Dirava dekenai ia tomadiho henia. ");
INSERT INTO hmo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Aberahamo be Pilistia edia tano dekenai nega daudau ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Inai murinai, Dirava ese ia ura Aberahamo do ia tohoa, vadaeni ia dekenai ia gwau, “Aberahamo e!” Aberahamo ia gwau, “Lau inai.” ");
INSERT INTO hmo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Dirava ia gwau, “Oiemu natuna oi abia, oi sibona oiemu natuna korikori, Isako, oi lalokau henia merona. Moraia tano dekenai do umui lao. Unuseni oi do lau hamaoroa, ororo ta ena ataiai, mero be lahi boubou gauna do oi halaoa.” ");
INSERT INTO hmo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kerukeru daba maragina dekenai, Aberahamo ese iena doniki ia abia hegaegae, iena natuna Isako bona iena hesiai taudia rua ia danu ia abia. Lahi boubou ena au ia siria, bona ia toreisi, Dirava ia hamaoroa gabuna dekenai ia raka hamatamaia. ");
INSERT INTO hmo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Dina namba 3 dekenai Aberahamo ese gabuna ia itaia, daudau dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Vadaeni, iena hesiai taudia dekenai ia gwau, “Umui ruaosi doniki danu iniseni umui noho. Lau be inai mero danu do ai lao unuseni, tomadiho totona, gabeai do ai giroa mai umui dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Aberahamo ese lahi boubou ena au ia henia iena natuna Isako dekenai, do ia huaia lao totona. To Aberahamo sibona ese lahi bona kaia iena imana dekenai ia abia lao. Idia ruaosi idia raka hamatamaia hebou. ");
INSERT INTO hmo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Nega sisina Isako ese iena tamana Aberahamo dekenai ia hereva, ia gwau, “Tamagu e.” Ia haere, ia gwau, “Natugu e, lau inai.” Isako ia gwau, “Lau itaia, oi dekenai lahi bona au idia noho, to lahi boubou gauna ena mamoe be edeseni?” ");
INSERT INTO hmo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Aberahamo ia haere, ia gwau, “Natugu e, Dirava sibona ese mamoe do ia henia, lahi boubou gauna totona.” Vadaeni, ruaosi ma idia raka lao. ");
INSERT INTO hmo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ia dekenai Dirava ese ia hamaoroa gabuna dekenai idia ginidae neganai, Aberahamo ese boubou patana ia haginia, bona patana ena latanai au ia atoa hegaegae. Vadaeni iena natuna be varo dekenai ia kwatua, bona boubou patana dekenai ia atoa, au latanai. ");
INSERT INTO hmo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Vadaeni Aberahamo ese iena imana dekenai kaia ia abia, iena natuna alaia mase totona. ");
INSERT INTO hmo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","To Lohiabada ena aneru ese guba dekena amo ia dekenai ia boiboi, ia gwau, “Aberahamo e, Aberahamo e!” Ia haere, ia gwau, “Lau inai.” ");
INSERT INTO hmo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ia gwau, “Oiemu imana mero dekenai oi atoa lasi, kara ta danu oi karaia lasi ia dekenai. Harihari lau diba vadaeni, oi be Dirava oi gari henia momokani, badina be oiemu natuna korikori lau ura abia neganai, oi dogoatao lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Aberahamo ese iena matana ia negea, bona ia murinai mamoe tau ta ia itaia, au ta ese ia dogoatao noho, iena doana dekenai. Ia lao, mamoe ia abia, bona ia henia, lahi boubou gauna totona, vadaeni unai mamoe ese iena natuna ena gabuna ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Aberahamo ese unai gabu ena ladana ia atoa, “Lohiabada ia Henia”. Inai bamona idia gwauraia, ia mai bona hari, idia gwau, “Lohiabada ese ia henia, iena ororo dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Lohiabada ena aneru ese Aberahamo dekenai ma ia boiboi lou nega iharuana, guba dekena amo. ");
INSERT INTO hmo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ia gwau, “Lohiabada ese inai bamona ia hereva: Lau sibona egu ladana dekenai gwauhamata metauna lau gwauraia inai: Oiemu natuna mero tamona sibona, lau abia gwauraia neganai oi dogoatao lasi. Inai kara oi karaia dainai, lau ese oi do lau hanamoa bada herea. ");
INSERT INTO hmo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Lau gwauhamata inai, tubudia momo oi dekenai do lau henia, edia momo be guba dekenai noho hisiu, bona kone dekenai noho miri bamona. Oiemu tubuna taudia ese idia dekenai idia tuari taudia edia hanua ibounai do idia abia. ");
INSERT INTO hmo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Tanobada besedia ibounai ese lau dekenai do idia noinoi, idia do lau hanamoa, oiemu tubuna lau hanamodia vadaeni hegeregerena. Inai bamona do idia noinoi, badina be oi ese lauegu oda oi kamonai henia dainai.” ");
INSERT INTO hmo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Aberahamo ese iena hesiai taudia ruaosi dekenai ia giroa lou, vadaeni ibounai idia giroa lou Bere Sieba dekenai, Aberahamo ena noho gabuna. ");
INSERT INTO hmo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Gabeai Aberahamo ese hereva ta ia kamonai, iena tadina Nahoro ena adavana Milika ese natudia ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Tau guna ena ladana be Usu, iena tadina be Busu bona Kemuela, Arama ena tamana, ");
INSERT INTO hmo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keseda bona Haso bona Pilidasa bona Idilapa bona Betuela. ");
INSERT INTO hmo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Inai Betuela be Rebeka ena tamana. Inai natuna memero 8 be Milika ese ia havaraia Aberahamo ena tadina Nahoro dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahoro ena adavana iharuana Reuma ese danu natudia ia havaraia, edia ladana be Teba, bona Gahama bona Tahasa, bona Maka. ");
INSERT INTO hmo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara ena mauri lagani ibounai be 127. ");
INSERT INTO hmo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara be Kiriata Araba dekenai ia mase, unai hanua be Kanana tano dekenai, ma ena ladana ta be Heberona. Aberahamo be ruma dekenai ia raka vareai, Sara totona ia taitai. ");
INSERT INTO hmo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Vadaeni Aberahamo be mase rumana dekena amo ia diho, Hiti taudia dekenai ia hamaorodia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Lau be umui emui huana dekenai idau tauna bamona lau noho, tano ta mani umui henia lau dekenai, lauegu guria gabuna dekenai do lau halaoa, unuseni lauegu hahine do lau guria.” ");
INSERT INTO hmo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Vadaeni, Hiti taudia ese idia haere, idia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tau badana e, oi be lohia badana ta aiemai huana dekenai. Aiemai guria gabudia edia huana dekenai, gabu namo herea ta do oi abia hidi, oiemu hahine do oi guria, ai ta ta aiemai guria gabuna do ai koua diba lasi oi dekena amo.” ");
INSERT INTO hmo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Vadaeni Aberahamo ia toreisi, Hiti taudia edia vairana dekenai iena kwarana ia atoa diho, ");
INSERT INTO hmo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ia hamaoroa idia dekenai, ia gwau, “Bema umui emui lalona ia hegeregere, lauegu hahine iniseni bema lau guria, Eparona Sohara dekenai mani umui noia lau totona, ");
INSERT INTO hmo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ia ese Makapela nadi ena matuna, iena tano ena hetoa lalonai gauna bema ia henia lau dekenai, lau ese tano ena davana korikori do lau henia ia dekenai, lauegu guria gabuna do lau halaoa.” ");
INSERT INTO hmo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Inai Eparona be Hiti taudia edia huanai ia helai noho. Vadaeni Eparona, Hiti tauna, ese Aberahamo dekenai ia haere, Hiti taudia edia vairana dekenai, bona iena hanua taudia ibounai edia vairana dekenai, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Tau badana e, lasi, unai tano mai ena nadi kohua danu do lau henia oi dekenai, lauegu bese taudia ibounai edia vairana dekenai dohore lau henia oi dekenai, oiemu hahine guria gabuna do oi halaoa.” ");
INSERT INTO hmo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Vadaeni Aberahamo ese unai gabu taudia, Hiti taudia edia vairana dekenai iena kwarana ia atoa diho. ");
INSERT INTO hmo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Vadaeni Aberahamo ese Eparona dekenai ia hereva, unai gabu taudia edia vairana dekenai, ia gwau, “Mani oi kamonai henia lau dekenai, unai tano ena davana mani lau henia oi dekenai, oi abia, vadaeni lauegu hahine unuseni do lau guria.” ");
INSERT INTO hmo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Vadaeni Eparona ese Aberahamo dekenai ia haere, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Tau badana e, oi kamonai, unai tano ena davana be siliva moni 400, ita ruaosi iseda huanai unai be gau ta, a? Oiemu hahine be unuseni do oi guria.” ");
INSERT INTO hmo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Aberahamo ese Eparona ena hereva ia kamonai, Hiti taudia edia vairana dekenai tano ena davana unai bamona ia gwauraia, vadaeni siliva moni 400 ia duahia, bona ia henia. Inai siliva moni ena metau be hoihoi taudia idia gaukaralaia noho moni ena metau hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Unai dainai Eparona ena tano Makapela dekenai, Mamare ena badibadinai, mai ena kohua bona au danu ibounai be, ");
INSERT INTO hmo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Aberahamo ese iena tano korikori dekenai ia halaoa, Hiti taudia edia vairana dekenai, bona unai hanua lalonai idia haboua taudia ibounai edia vairana dekenai ia hoia. ");
INSERT INTO hmo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Vadaeni Aberahamo ese iena adavana Sara ia guria, Makapela nadi ena matuna lalonai, Mamare ena badibadinai. Unai gabu be Heberona, Kanana tano dekenai, ");
INSERT INTO hmo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","unai tano bona unai nadi matuna be Aberahamo ia abia momokani, iena guria gabuna, Hiti taudia dekena amo. ");
INSERT INTO hmo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Aberahamo be buruka vadaeni, iena mauri lagani be momo. Bona Lohiabada ese, Aberahamo ena kara ibounai lalonai, ia hanamoa vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ia ese iena hesiai tauna badana, iena kohu ibounai ia naria tauna, dekenai ia oda, ia gwau, “Oiemu imana lauegu mamuna henunai oi atoa, bona gwauhamata oi henia. ");
INSERT INTO hmo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Lohiabada, guba bona tanobada edia Dirava ena ladana dekenai, lau ura oi gwauhamata, bona lau dekenai oi hamaoroa, oi be lauegu natuna Isako ena adavana do oi davaria lasi Kanana taudia dekena amo, edia gabu lau noho inai. ");
INSERT INTO hmo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Oi giroa lou lauegu tano korikori dekenai, bona unuseni, lauegu varavara dekena amo lauegu natuna Isako ena adavana oi abia.” ");
INSERT INTO hmo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","To hesiai tauna ese ia nanadaia, ia gwau, “To edena bamona do lau karaia, bema inai kekeni ia ura lasi lau danu ia mai inai tano dekenai? Oiemu natuna do lau hakaua lao oiemu mai gabuna dekenai, be ia namo?” ");
INSERT INTO hmo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aberahamo ia haere, ia gwau, “Lasi momokani. Lauegu natuna oi abia lao lasi unai gabu dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Lohiabada, Guba ena Dirava ese tamagu ena ruma dekena amo, bona egu varavara edia tano dekena amo, lau ia mailaia iniseni, bona lau dekenai ia gwauhamata, inai tano be lauegu tubudia dekenai do ia henia. Ia ese iena aneru oiemu vairana dekenai do ia siaia, vadaeni unuseni adavana ta do oi davaria egu natuna dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","To bema inai kekeni ia ura lasi oi danu ia mai, vadaeni oiemu gwauhamata lau dekenai be ia ore. To gau tamona, lauegu natuna oi abia lao lasi unai gabu dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Vadaeni hesiai tauna ese iena biaguna Aberahamo ena mamuna henunai iena imana ia atoa, ia gwauhamata, iena biaguna ena ura hegeregere. ");
INSERT INTO hmo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hesiai tauna ese iena biaguna ena kamelo ibounai 10 ia abia, davana bada harihari gaudia momo danu. Vadaeni, ia toreisi, ia lao Mesopotamia kahanai, hanua ta ladana Nahoro dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ia ginidae neganai, ia ese hanua ena murimuri kahana dekenai kamelo ia hatuidia diho ranu guri badinai. Unai be adorahi kahana dekenai, bona hahine be ranu utua totona idia mai. ");
INSERT INTO hmo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Bona ia guriguri, ia gwau, “Lohiabada e, lauegu biaguna Aberahamo ena Dirava e, oi dekenai lau noinoi, hari dina lauegu gaukara mani oi hanamoa, bona oiemu gwauhamata lauegu biaguna Aberahamo dekenai mani oi hamomokania. ");
INSERT INTO hmo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Lau be iniseni, ranu guri dekenai lau noho, bona hanua kekeni be do idia mai, ranu utua totona. ");
INSERT INTO hmo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Lau be kekeni ta dekenai do lau hereva, do lau gwau, ‘Mani emu kara oiemu hodu oi atoa diho lao, bona ranu sisina lau dekenai do oi henia, do lau inua.’ Bema ia gwau, ‘Namo, oi inua, bona oiemu kamelo dekenai danu ranu do lau henia.’ Lau ura unai kekeni be oiemu abia hidi kekeni oiemu hesiai tauna Isako dekenai. Bema inai bamona ia vara neganai, do lau diba oiemu gwauhamata lauegu biaguna dekenai be oi hamomokania vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Iena guriguri be ia ore lasi neganai, Rebeka ia ginidae. Iena pagana dekenai hodu ia huaia noho. Ia be Betuela ena natuna. Betuela be Milika ena natuna. Milika be Aberahamo ena tadina Nahoro ena adavana. ");
INSERT INTO hmo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ia be tau ta ia do sihari lasi kekeni, bona hairai dikadika. Ranu guri dekenai ia diho lao, iena hodu ia hahonua, bona ma ia giroa mai noho. ");
INSERT INTO hmo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Vadaeni inai hesiai tauna ese ia dekenai ia heau lao, ia gwau, “Mani emu kara, oiemu hodu dekena amo ranu sisina lau dekenai oi henia, do lau inua.” ");
INSERT INTO hmo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kekeni ia gwau, “Tau badana e, oi inua.” Iena hodu be iena pagana dekena amo ia atoa diho, ranu ia bubua, vadaeni ia inua. ");
INSERT INTO hmo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ia inua, vadaeni kekeni ia gwau, “Ranu ma haida do lau utua, oiemu kamelo dekenai do lau henia, edia ura hegeregerena.” ");
INSERT INTO hmo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Vadaeni karaharaga iena hodu ena ranu orena daramu lalonai ia bubua, bona ranu guri dekenai ia giroa lou, giroa lou, ia lao bona hesiai tauna ena kamelo ibounai idia inua vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Inai hesiai tauna ese ia itaia noho, ia hereva lasi. Ia ura diba Lohiabada ese iena laolao ena anina ia henia vadaeni o lasi. ");
INSERT INTO hmo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kekeni ese kamelo dekenai ranu ia henia vadaeni murinai, hesiai tauna ese davana bada golo rini ta ia abia, kekeni ena udu baubauna dekenai ia atoa. Bona golo gana badadia rua, imana gaudia, be kekeni ena imana dekenai ia atoa. ");
INSERT INTO hmo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ia nanadaia, ia gwau, “Oiemu tamana be daika, mani lau do oi hamaoroa? Oiemu tamana ena ruma lalonai be mai ena gabu, hari hanuaboi lau bona egu tatau do ai noho diba o lasi?” ");
INSERT INTO hmo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ia haere, ia gwau, “Lau be Betuela ena natuna, lauegu tubuna hahine ena ladana be Milika, Nahoro ena adavana. ");
INSERT INTO hmo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Rei kakoro bona aniani momo aiemai ruma dekenai ia noho, bona oiemu mahuta gabuna ta danu ia noho.” ");
INSERT INTO hmo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Vadaeni, inai tau ese ia tui diho, bona Lohiabada dekenai ia tomadiho henia. ");
INSERT INTO hmo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ia gwau, “Lohiabada, lauegu biaguna Aberahamo ena Dirava e, oi lau hanamoa, badina be oiemu gwauhamata lauegu biaguna dekenai oi hamomokania vadaeni. Oi Lohiabada ese maoromaoro lau oi hakaua, lauegu biaguna ena tadina ena ruma dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kekeni ese iena sinana ena ruma dekenai ia heau lao, sivarai ibounai ia hadibaia. ");
INSERT INTO hmo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka ena taihuna ladana Labana ese ruma ena murimuri dekenai ia heau lao, ranu guri dekenai ia lao, unai tau ia davaria totona. ");
INSERT INTO hmo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Ia ese golo rini bona gana iena taihuna imana dekenai ia itaia, bona unai tau ena hereva kekeni dekenai ia kamonai. Vadaeni, ia raka lao, unai ranu guri dekenai iena kamelo ia naria noho tauna dekenai, Aberahamo ena hesiai tauna be unai. ");
INSERT INTO hmo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Bona ia gwau, “Oi be Lohiabada ese ia hanamoa tauna ta, mani egu ruma dekenai oi raka vareai. Badina dahaka murimuri dekenai oi naria noho? Badina be lauegu ruma lalonai gabu ta lau karaia vadaeni oi dekenai, bona oiemu kamelo edia gabu ia noho danu.” ");
INSERT INTO hmo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Vadaeni inai tau ese ruma lalonai ia raka vareai, bona Labana ese kamelo edia maduna ia kokia, rei kakoro bona aniani idia dekenai ia henia. Bona Aberahamo ena hesiai tauna bona iena memero dekenai ranu ia henia, idia edia aena idia huria totona. ");
INSERT INTO hmo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Aniani idia atoa iena vairanai, to Aberahamo ena hesiai tauna ia gwau, “Lau be do lau ania lasi, ia lao bona lauegu laolao ena badina lau gwauraia guna.” Labana ia gwau, “Oi hereva.” ");
INSERT INTO hmo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Vadaeni, ia gwau, “Lau be Aberahamo ena hesiai tauna. ");
INSERT INTO hmo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Lohiabada ese lauegu biaguna ia hanamoa bada vadaeni, lohia badana ta ia halaoa vadaeni. Mamoe bona nanigosi momo, boromakau, siliva, golo, hesiai taudia, hesiai hahine, kamelo bona doniki ia dekenai ia henia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Lauegu biaguna ena adavana Sara ia buruka neganai, ia ese natuna mero ta ia havaraia. Lauegu biaguna ese inai mero dekenai iena kohu ibounai ia henia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Bona lauegu biaguna ese ia hamaoroa lau dekenai do lau gwauhamata, ia gwau, ‘Lauegu natuna ena adavana oi abia hidi lasi inai hari lau noho gabuna Kanana taudia edia tano dekena amo. Edia kekeni ta do oi abia hidi lasi, ");
INSERT INTO hmo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","to lauegu badu oiemu latanai do ia noho bema oi lao lasi lauegu tamana ena taudia, lauegu varavara edia huanai lauegu natuna ena adavana oi abia lasi neganai.’ ");
INSERT INTO hmo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Vadaeni lauegu biaguna dekenai lau gwau, ‘To sedira bema kekeni ia mai lasi lau danu, edena bamona do lau karaia?’ ");
INSERT INTO hmo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ia haere, ‘Lohiabada, hanaihanai lau kamonai henia Dirava ese iena aneru do ia siaia oi danu, bona oiemu dala do ia kehoa, vadaeni lauegu varavara bona lauegu tamana ena ruma taudia edia huanai lauegu natuna ena adavana do oi davaria. ");
INSERT INTO hmo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Unai bamona oi karaia neganai, lauegu badu ia noho lasi oi dekenai. Bema lauegu varavara dekenai oi lao, to kekeni ta idia ura lasi henia oi dekenai, unai neganai danu lauegu badu do lau kokia oi dekena amo.’ ");
INSERT INTO hmo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Bona hari dina, ranu guri dekenai lau mai neganai, lau guriguri, lau gwau, ‘Lohiabada e, lauegu biaguna Aberahamo ena Dirava, mani emu kara oi durua lau, lauegu laolao ena anina do oi havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Hari lau be ranu guri dekenai, bema kekeni ta ranu utua totona ia mai neganai, do lau hereva henia, lau gwau, “Mani emu kara ranu sisina oi henia oiemu hodu dekena amo, do lau inua.” ");
INSERT INTO hmo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Bema ia haere, ia gwau, “Oi inua, bona oiemu kamelo edia ranu danu do lau henia.” Vadaeni, unai dekena amo do lau diba inai kekeni be Lohiabada ese ia abia hidi vadaeni, lauegu biaguna ena natuna ena adavana.’ ");
INSERT INTO hmo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Unai bamona lau guriguri noho lalonai, Rebeka ia mai, hodu danu ia huaia ena pagana dekenai. Ia diho lao, ranu guri dekenai ranu utua totona. Ia dekenai lau gwau, ‘Mani emu kara, ranu sisina oi henia, lau inua.’ ");
INSERT INTO hmo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Vadaeni, iena hodu ia atoa diho haraga, ia gwau, ‘Oi inua, bona oiemu kamelo edia ranu danu do lau utua.’ Vadaeni, lau inua, bona lauegu kamelo dekenai ranu ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Lau henanadaia, lau gwau, ‘Oiemu tamana be daika?’ Ia haere, ia gwau, ‘Lau be Betuela ena natuna, lauegu tubuna be Nahoro bona Milika.’ Vadaeni, rini be iena udu baubauna dekenai lau atoa, bona gana iena imana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Vadaeni, lau tui diho, Lohiabada, lauegu biaguna Aberahamo ena Dirava dekenai lau hanamoa, badina ia ese lau ia hakaua namonamo. Vadaeni lauegu biaguna ena tadina dekenai lau mai, iena natuna lau davaria, lauegu biaguna ena natuna do ia adavaia totona. ");
INSERT INTO hmo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Unai dainai mani oi hereva, lauegu biaguna dekenai do oi bogahisihisi, bona hanamoa kara ia dekenai do oi karaia. Bema lasi, mani oi hamaoroa lau, vadaeni do lau diba edena bamona do lau karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Vadaeni, Labana bona Betuela idia haere, idia gwau, “Inai kara be Lohiabada dekena amo ia mai. Ai be do ai haere diba lasi, ‘Oibe’ o ‘Lasi’. ");
INSERT INTO hmo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka be inai, oi abia, oi hakaua lao, oiemu biaguna ena natuna do ia adavaia, Lohiabada ena hereva hegeregere.” ");
INSERT INTO hmo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Aberahamo ena hesiai tauna ese unai hereva ia kamonai, vadaeni tano dekenai iena kwarana ia atoa diho, Lohiabada ia hanamoa. ");
INSERT INTO hmo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Bona ia ese siliva gaudia, golo gaudia, bona dabua Rebeka dekenai ia henia, iena taihuna bona iena sinana dekenai danu davana bada harihari gaudia ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Gabeai, Aberahamo ena hesiai tauna mai ena bamona taudia be idia aniani bona idia inuinu, vadaeni idia mahuta unuseni. Dabai idia toreisi, vadaeni hesiai tauna ia gwau, “Mani lau oi siaia, lau giroa lou lauegu biaguna dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","To kekeni ena taihuna bona ena sinana idia gwau, “Mani emu kara kekeni be ai dekenai do ia noho pura ta o dina 10, vadaeni, gabeai ia lao.” ");
INSERT INTO hmo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","To ia gwau, “Umui dogoatao lasi lau, Lohiabada ese lauegu laolao ena anina ia havaraia vadaeni, mani lau oi siaia, lau giroa lou lauegu biaguna dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Vadaeni, idia gwau, “Namo ita boiboi kekeni dekenai, iena hereva do ita kamonai.” ");
INSERT INTO hmo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Unai dainai, Rebeka dekenai idia boiboi, idia nanadaia, idia gwau, “Oi ura inai tau danu umui lao?” Ia haere, ia gwau, “Lau ura lau lao.” ");
INSERT INTO hmo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Unai dainai, edia taihuna Rebeka, mai ena hesiai kekeni danu idia siaia lao, Aberahamo ena hesiai tauna mai ena bamona taudia danu. ");
INSERT INTO hmo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Idia ese Rebeka idia hanamoa, idia gwau: “Aiemai taihuna e, oi be dohore taunimanima momo herea edia sinana. Oiemu natudia ese do idia kwalimu, tuari taudia ese edia hanua idia tuari henia neganai.” ");
INSERT INTO hmo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka mai iena hesiai kekenidia idia toreisi, bona kamelo idia guia, hesiai tauna danu idia lao. Inai bamona dala dekenai hesiai tauna ese Rebeka ia hakaua lao. ");
INSERT INTO hmo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Unai neganai Isako be diho kahana ladana Negebe dekenai ia noho. Ia be taunimanima noho lasi gabuna dekenai ia laolao, bona ranu guri ta ladana “Lau ia itaia noho Mauri Tauna ena ranu guri” dekenai ia lao. ");
INSERT INTO hmo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Adorahi ta, dina ia diho kahirakahira neganai, Isako be tano palaka dekenai ia loaloa, bona ia itaia be kamelo idia mai. ");
INSERT INTO hmo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka ese danu Isako ia itaia, bona iena kamelo dekena amo ia diho, ");
INSERT INTO hmo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","hesiai tauna dekenai ia nanadaia, ia gwau, “Unai hari tano palaka dekena amo ia mai tauna be daika?” Hesiai tauna ia gwau, “Ia be lauegu biaguna.” Vadaeni Rebeka ese dabua ta ia abia, iena vairana ia koua. ");
INSERT INTO hmo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hesiai tauna ese ena kara ibounai Isako dekenai ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Vadaeni Isako ese Rebeka ia hakaua lao, iena sinana Sara ena palai ruma dekenai ia hakaua vareai, bona ia adavaia. Isako ese Rebeka ia ura henia bada. Unai dainai inai lalokau ese iena lalona ia hanamoa, sinana ena mase dekenai ia taitai neganai. ");
INSERT INTO hmo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aberahamo ese hahine ta ma ia adavaia, iena ladana be Ketura. ");
INSERT INTO hmo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Edia natudia iena bogana dekena amo idia vara edia ladana be inai: Simurana bona Iokosana bona Medana bona Midiana bona Isabaka bona Sua. ");
INSERT INTO hmo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Iokosana ese Sieba bona Dedana ia havaraia. Dedana ese Asurima bona Letusima bona Leumima edia bese ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiana ese Epa bona Epere bona Hanoka bona Abida bona Eledaha ia havaraia. Inai ibounai be Ketura ena bese. ");
INSERT INTO hmo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aberahamo ese iena kohu ibounai Isako dekenai ia rakatania. ");
INSERT INTO hmo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","To ia do mase lasi neganai, iena adavana haida edia natudia dekenai ia ese harihari gaudia ia henia, vadaeni dina ia daekau kahana dekenai ia siaidia lao, Isako danu idia noho hebou lasi. ");
INSERT INTO hmo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aberahamo ena mauri lagani ibounai be 175. ");
INSERT INTO hmo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Vadaeni ia mase, ia buruka momokani neganai, bona iena varavara mase taudia danu ia haboua. ");
INSERT INTO hmo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Iena natuna ruaosi Isako bona Isamaela ese ia idia abia, Makapela ena nadi matuna dekenai idia guria, unai nadi matuna be Mamare ena dina daekau kahana dekenai, Eparona Sohara, Hiti tauna ena tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Unai tano be Aberahamo ese Hiti taudia dekena amo ia abia. Unuseni Isako bona Isamaela ese Aberahamo idia guria, iena adavana Sara danu. ");
INSERT INTO hmo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Aberahamo ia mase murinai, Dirava ese iena natuna Isako ia hanamoa. Isako be “Lau ia itaia Mauri Tauna ena ranu guri” ena gabu kahirakahira ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Isamaela ena natuna bona iena tubuna be inai: Ia be Aberahamo ena natuna, Sara ena hesiai hahine Hagara ena bogana dekena amo ia vara. Hagara be Aigupito hahine. ");
INSERT INTO hmo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isamaela ena natuna bona iena tubuna edia ladana be inai: Iena natuna ia vara guna be Nebaioto, iena murinai idia vara taudia be Kedara bona Adabela bona Mibisama. ");
INSERT INTO hmo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Bona Misima bona Duma bona Masa, ");
INSERT INTO hmo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","bona Hadada bona Tema bona Ieturu bona Napisi bona Kedema. ");
INSERT INTO hmo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isamaela ena natuna be unai, edia ladana unai, edia hanua bona edia kamepa dekenai be unai edia ladana idia atoa, idia ibounai 12 be hanua ta ta ena lohia taudia idia halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isamaela ena mauri lagani be 137. Ia mase, iena varavara taudia dekenai ia danu idia haboua. ");
INSERT INTO hmo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isamaela ena bese edia tano be Havila ia lao bona Suru, Aigupito ena dina ia daekau kahana dekenai, Asuria dekenai ia lao dala badinai. Idia be edia varavara taudia Aberahamo ena natuna dekena amo idia noho siri. ");
INSERT INTO hmo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aberahamo ena natuna Isako ena sivarai be inai: ");
INSERT INTO hmo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isako ena mauri lagani be 40 neganai, ia ese Rebeka ia adavaia. Rebeka be Betuela, Aramea tauna ta ena natuna, bona Labana, Aramea tauna ta ena taihuna. Betuela be Mesopotamia tano dekena amo. ");
INSERT INTO hmo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isako ese Lohiabada ia noinoi henia, iena adavana dainai, badina ia be natuna lasi. Lohiabada ese iena noinoi ia kamonai, vadaeni Rebeka ia rogorogo. ");
INSERT INTO hmo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Natuna be mero rua iena bogana lalonai, bona idia edia marere be heatu bamona dainai, Rebeka ia gwau, “Inai bamona idia karaia be, edena bamona do lau mauri noho?” Unai dainai Lohiabada dekenai ia noinoi. ");
INSERT INTO hmo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Lohiabada ia haere, ia gwau, “Bese rua be oiemu bogana lalonai, bese rua be oi dekena amo do idia vara. Ta ese ma ta do ia hamorua. Vara guna tauna ese, vara gabeai tauna ena hesiai tauna, do ia lao.” ");
INSERT INTO hmo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Iena natuna havaraia nega be kahirakahira neganai, iena bogana lalonai be memero rua idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Guna ia vara mero be kakakaka. Iena ladana idia atoa Esau, badina be iena tauanina ibounai be dabua mai huihui bamona. ");
INSERT INTO hmo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Gabeai iena tadina ia vara, bona iena imana dekena amo Esau ena aena ia dogoatao. Iena ladana idia atoa Iakobo, ena anina be “gabu abia tauna.” Idia ruaosi idia vara neganai, Isako ena mauri lagani be 60. ");
INSERT INTO hmo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Memero ruaosi idia tubu ia lao bona idia bada. Esau be labana ia diba momo tauna, bona uda dekenai loaloa tauna, to Iakobo ena kara be manada, bona ia be ruma dekenai noho tauna. ");
INSERT INTO hmo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isako ese Esau ia lalokau henia, badina be labana dekenai ia alaia vamu ia ura ania, to Rebeka ese Iakobo ia lalokau henia. ");
INSERT INTO hmo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Dina ta Iakobo ese aniani ia nadua noho, vadaeni Esau be gunika dekena amo ia mai. ");
INSERT INTO hmo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ia be hitolo bada herea dainai, Esau ese Iakobo dekenai ia noinoi, ia gwau, “Unai aniani kakakaka oi henia, lau ania, badina lau be hitolo mase.” (Unai dainai iena ladana ta idia atoa Edoma, ena anina be, kakakaka.) ");
INSERT INTO hmo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","To Iakobo ia haere, ia gwau, “Bema oiemu vara guna ena hanamoa oi henia lau dekenai, aniani do lau henia oi.” ");
INSERT INTO hmo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau ia gwau, “Be, lau kahirakahira lau mase, lauegu vara guna ena hanamoa be edena bamona do ia hanamoa lau?” ");
INSERT INTO hmo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Iakobo ia gwau, “Oi gwauhamata guna, oiemu vara guna ena hanamoa do oi henia lau dekenai.” Vadaeni Esau ese ia gwauhamata, iena vara guna ena hanamoa be Iakobo dekenai do ia henia, aniani ena davana. ");
INSERT INTO hmo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Bona Iakobo ese paraoa bona vasiahu ia henia. Vadaeni ia aniani, ia inuinu, gabeai ia toreisi, ia rakatania. Esau ese iena vara guna ena hanamoa, be unai bamona dala dekenai ia negea. ");
INSERT INTO hmo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Hitolo bada ia vara unai tano dekenai, Aberahamo ia noho neganai bamona. Vadaeni, Isako ia toreisi, Gerara dekenai ia lao, Abimeleka, Pilistia ena king dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Vadaeni Lohiabada ese Iakobo dekenai ia hedinarai, ia gwau, “Aigupito dekenai oi lao lasi, dohore lau hadibaia oi tanona dekenai oi noho. ");
INSERT INTO hmo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Inai tano dekenai oi noho, vadaeni dohore lau durua oi, bona do lau hanamoa oi, badina be inai tano ibounai do lau henia oi, bona oiemu natuna bona oiemu tubuna dekenai do lau henidia, oiemu tamana Aberahamo dekenai gwauhamata lau henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Oiemu natuna bona oiemu tubuna danu dohore idia momo herea, guba ena hisiu bamona dohore idia momo herea, bona oiemu natuna bona oiemu tubuna dainai tanobada ena bese ibounai namo bada dohore idia davaria. ");
INSERT INTO hmo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Badina be Aberahamo ese lauegu gadona ia kamonai, bona lauegu hereva, lauegu sisiba, lauegu taravatu, ibounai ia badinaia.” ");
INSERT INTO hmo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Unai dainai Isako be Gerara dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Unai gabu taudia ese iena adavana totona idia nanadaia ia dekenai, vadaeni ia gwau, “Ia be lauegu taihuna.” “Ia be lauegu adavana,” dohore ia gwau be ia gari, badina be ia gwau: “Inai gabu taudia ese do idia alaia mase lau, Rebeka totona, badina ia be hahine namo herea.” ");
INSERT INTO hmo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nega daudau unai bamona idia noho, vadaeni dina ta Abimeleka, Pilistia ena king, uindo dekena amo iena matana ia negea lao, Isako ena adavana Rebeka danu ia itadia, idia ruaosi gadara dekenai idia rosia. ");
INSERT INTO hmo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Vadaeni ia ese Isako dekenai ia gwau henia, ia gwau, “Lauegu lalona ia kehoa vadaeni, hahine be oiemu adavana. Dahaka totona oi gwau, ‘Inai be lauegu taihuna.’ ” Isako ia haere ia dekenai, ia gwau, “Badina be lau gari, haida ese ia totona lau do idia alaia mase garina.” ");
INSERT INTO hmo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Vadaeni Abimeleka ia gwau, “Oi be edena bamona oi karaia vadaeni ai dekenai? Bema tau ta oiemu adavana danu idia mahuta gabu tamona dekenai, ai ibounai be do ai kerere oi totona.” ");
INSERT INTO hmo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Vadaeni Abimeleka ese iena hanua taudia dekenai taravatu ia atoa, ia gwau, “Isako o iena adavana ia hadikaia tauna be, dohore ia mase.” ");
INSERT INTO hmo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isako ese aniani ia hadoa unai tano dekenai, vadaeni unai lagani tamona lalonai ia hadoa gaudia edia anina be momo herea ia abia, badina be Lohiabada ese ia hanamoa. ");
INSERT INTO hmo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ia be kohu momo tauna, bona aniani momo tauna Dirava ese ia halaoa, badina iena kohu bona iena aniani be idia momo herea noho. ");
INSERT INTO hmo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Iena mamoe bona iena boromakau be momo herea, iena hesiai taudia danu idia momo. Vadaeni Pilistia taudia idia badu ia dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Vadaeni ranu guri, iena tamana Aberahamo ena nega dekenai iena hesiai taudia idia geia gaudia be, Pilistia taudia ese tano dekenai idia koua. ");
INSERT INTO hmo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Vadaeni Abimeleka ese Isako dekenai ia hamaoroa, ia gwau, “Ai dekena amo oi raka siri, badina be oiemu goada ese aiemai goada ia hanaia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Vadaeni Isako ia raka siri, Gerara ena koura dekenai ia kamepa, unuseni ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Vadaeni ranu guri ibounai, iena tamana Aberahamo ena nega dekenai idia geia, bona Pilistia taudia ese tano dekenai idia koua, be ia ese ma ia geia lou, bona edia ladana iena tamana ese ia atoa hegeregerena, ia ese ma ia atoa lou. ");
INSERT INTO hmo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isako ena hesiai taudia danu ese koura dekenai guri idia geia, bona ranu ia lohilohi gabuna ta idia davaria. ");
INSERT INTO hmo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerara bese taudia edia mamoe bona boromakau naria taudia be Isako ena mamoe bona boromakau naria taudia danu idia heatu, idia gwau, “Inai be aiemai ranu.” Unai dainai Isako ese unai ranu guri ena ladana ia atoa Eseka, ena anina be, Heai, badina be idia heai inai ranu totona. ");
INSERT INTO hmo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Vadaeni guri ta ma idia geia, to unai totona danu idia heatu, unai dainai iena ladana ia atoa Sitina, ena anina be, Heatu. ");
INSERT INTO hmo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Unai gabu dekena amo idia be ma idia raka siri, vadaeni guri ta ma idia geia. Unai totona be idia heatu lasi, unai dainai iena ladana ia atoa Rehoboto, anina be, Gabu, badina be ia gwau, “Lohiabada ese gabu ta ia kehoa vadaeni ita dekenai, iniseni do ita noho namonamo.” ");
INSERT INTO hmo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Unai gabu dekena amo Isako be Bere Sieba dekenai ia lao. ");
INSERT INTO hmo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Vadaeni unai hanuaboi Lohiabada be ia dekenai ia hedinaraia, ia gwau, “Lau be oiemu tamana Aberahamo ena Dirava, vadaeni oi gari lasi, badina be lau ese lau durua noho oi, do lau hanamoa oi dekenai bona oiemu natuna bona oiemu tubuna dohore idia momo herea, lauegu hesiai tauna Aberahamo dainai.” ");
INSERT INTO hmo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Vadaeni Isako ese boubou patana unuseni ia karaia, bona Lohiabada ena ladana ia hanamoa. Unuseni danu ia kamepa, bona iena hesiai taudia ese ranu guri idia geia. ");
INSERT INTO hmo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleka be Gerara dekena amo ia mai, ia bona iena turana ta Ahusata, bona iena tuari oreana ena biaguna, Pikola idia toiosi Isako dekenai idia mai. ");
INSERT INTO hmo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Vadaeni Isako ia hereva idia dekenai, ia gwau, “Umui badu henia lau dekenai, bona umui lulua lau, harihari lau dekenai umui mai vadaeni, badina be dahaka?” ");
INSERT INTO hmo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Idia gwau, “Aiemai lalona ia kehoa vadaeni, Lohiabada ese ia durua vadaeni oi dekenai, unai dainai ai gwau be, maino ita karaia, bona gwauhamata ita karaia, oi dekenai bona ai dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ai dekenai oi hadikaia lasi, oi dekenai ai hadikaia lasi bamona. Kara namodia sibona ai karaia vadaeni oi dekenai, mai maino danu ai siaia oi, bona harihari Lohiabada ia hanamoa oi dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Vadaeni Isako ese aria ia karaia, ibounai idia aniani hebou, bona idia inuinu hebou. ");
INSERT INTO hmo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Dabai idia toreisi, idia ta ta dekenai idia gwauhamata, vadaeni Isako ese ia siaidia lao, mai maino danu idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Unai dina dekenai Isako ena hesiai taudia be ia dekenai idia lao, guri idia geia herevana idia hamaoroa ia dekenai, idia gwau, “Ranu ai davaria vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Vadaeni unai ranu guri ena ladana ia atoa Sieba, unai dainai unai hanua ena ladana be Bere Sieba ia mai bona harihari. ");
INSERT INTO hmo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau ena mauri lagani be 40, vadaeni ia headava, hahine rua ia abia. Iuditi, Beri, Hiti tauna ena natuna, bona Basemata, Elona, Hiti tauna ena natuna. ");
INSERT INTO hmo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","To Isako bona Rebeka edia lalona idia hekwarahi momo unai hahine ruaosi dainai. ");
INSERT INTO hmo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isako be ia buruka vadaeni, iena matana danu ia diburadibura, gau ta ia itaia namonamo lasi. Vadaeni iena vara guna natuna Esau ia boiria, ia gwau, “Natugu e.” Esau ia gwau, “Lau inai.” ");
INSERT INTO hmo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isako ma ia gwau, “Oi mai itaia lau. Lau buruka vadaeni, lauegu mase dinana be lau diba lasi. ");
INSERT INTO hmo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Unai dainai lau noinoi oi dekenai, oiemu diba bona oiemu peva oi abia, oi lao labana, dia ta oi alaia lauegu. ");
INSERT INTO hmo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Vadaeni vamu namona, lauegu lalona ese ia ura henia hegeregerena do oi nadua, lau dekenai oi mailaia, lau ania, vadaeni do lau mase lasi neganai, lau ese oi do lau hanamoa guna.” ");
INSERT INTO hmo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Inai hereva Isako ese iena natuna Esau dekenai ia hamaoroa, be Rebeka danu ia kamonai. Vadaeni Esau be ia lao labana, dia ta do ia alaia, ia mailaia gwauraia. ");
INSERT INTO hmo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Vadaeni Rebeka ese iena natuna Iakobo dekenai ia hereva henia, ia gwau, “Oiemu tamana ese oiemu kakana Esau dekenai ia hamaoroa herevana lau kamonai, ");
INSERT INTO hmo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ia gwau, ‘Dia ta oi mailaia, vamu namona oi nadua lauegu, lau ania, vadaeni do lau mase lasi neganai, Lohiabada ena vairana dekenai oi do lau hanamoa guna.’ ");
INSERT INTO hmo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Unai dainai, natugu e, lauegu hereva oi kamonai, oi dekenai lau hamaoroa hegeregerena sibona do oi karaia. ");
INSERT INTO hmo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Oi lao, nani edia natuna namodia rua oi abia, lau dekenai oi mailaia, vadaeni, lau ese vamu namona do lau halaoa oiemu tamana ena, ia ura henia gauna hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Vadaeni oi abia lao oiemu tamana dekenai, ia ania, vadaeni do ia mase lasi neganai do ia hanamoa oi.” ");
INSERT INTO hmo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Vadaeni Iakobo ese iena sinana Rebeka dekenai ia haere, ia gwau, “Lauegu kakana Esau ena kopina be mai huihui danu, to lauegu kopina be manadamanada. ");
INSERT INTO hmo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Sedira lauegu tamana ese lauegu kopina do ia dogoatao, do ia diba lau be koikoi tauna, vadaeni hadikaia herevana do ia gwauraia lau dekenai, do ia hanamoa lasi lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Iena sinana ia gwau, “Hadikaia herevana be lauegu latanai do ia noho, lauegu hereva oi kamonai, oi lao, nani natuna rua oi abia, lau dekenai oi mailaia.” ");
INSERT INTO hmo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Vadaeni ia lao, ia abia, iena sinana dekenai ia mailaia. Vadaeni iena sinana ese vamu namona ia nadua, iena tamana ese ia ura henia gauna hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Vadaeni Rebeka ese iena vara guna natuna Esau ena dabua namona ta ruma dekenai ia abia, iena natuna Iakobo dekenai ia atoa. ");
INSERT INTO hmo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Nani edia natuna kopidia danu iena imana ruaosi bona aiona dekenai ia atoa. ");
INSERT INTO hmo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Vadaeni inai vamu namona bona paraoa ia karaia hegaegae, iena natuna Iakobo dekenai ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Iakobo be iena tamana dekenai ia lao, ia gwau, “Tamagu e.” Isako ia haere, ia gwau, “Lau inai. Natugu e, oi be daika?” ");
INSERT INTO hmo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Iakobo ese iena tamana dekenai ia haere henia, ia gwau, “Lau inai, Esau, oiemu vara guna natuna, oiemu hereva lau badinaia vadaeni, oi toreisi, dia ta lau alaia vadaeni do oi ania, vadaeni oi hanamoa lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Vadaeni Isako ese iena natuna dekenai ia nanadaia, ia gwau, “Natugu e, edena bamona oi davaria haragaharaga?” Ia haere, ia gwau, “Badina be Lohiabada, oiemu Dirava ese ia durua lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Vadaeni Isako ese Iakobo dekenai ia hamaoroa, ia gwau, “Natugu e, mani oi mai kahirakahira, oiemu kopina do lau dogoatao, oi be momokani lauegu natuna Esau o lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Vadaeni Iakobo be iena tamana Isako dekenai ia lao kahirakahira, iena kopina ia dogoatao, vadaeni ia gwau, “Gadona be Iakobo ena gadona, to imana be Esau ena imana.” ");
INSERT INTO hmo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ia diba lasi unai be Iakobo, badina iena imana be mai huihui danu, iena kakana Esau ena imana bamona, unai dainai Isako ese ia hanamoa hamatamaia. ");
INSERT INTO hmo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Vadaeni Isako ia gwau, “Momokani, oi be lauegu natuna korikori Esau, ani?” Ia gwau, “Oibe.” ");
INSERT INTO hmo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Vadaeni Isako ia gwau, “Oiemu vamu mani oi mailaia, do lau ania. Unai murinai lauegu hanamoa do lau henia oi dekenai.” Unai dainai, Iakobo ese ia mailaia, vadaeni ia ania, uaina danu ia mailaia, vadaeni ia inua. ");
INSERT INTO hmo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Vadaeni, iena tamana Isako ese ia hamaoroa, ia gwau, “Natugu e, oi mai kahirakahira, oi kisi henia lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Vadaeni ia lao kahirakahira, ia kisi henia. Isako ese iena dabua ena bonana ia kamonai, vadaeni ia hanamoa, ia gwau, “Namo, egu natuna ena bonana be, Lohiabada ese uma namona ia hanamoa ena bonana bamona. ");
INSERT INTO hmo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Unai dainai guba ena medu Dirava ese oi do ia henia, bona oiemu uma tano do ia hanamoa. Uiti momo bona uaina momo danu do ia henia oi dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Idau bese taudia ese, oiemu hesiai gaukara do idia karaia. Bese idauidau ese, oiemu vairana dekenai do idia tui diho. Oiemu tadikakana edia biaguna, be do idia halaoa oi. Oiemu sinana ena natuna be oiemu vairana dekenai, edia kwarana do idia atoa diho. Oi dekenai idia hadikaia taudia, be do idia hadikaia. Oi dekenai idia hanamoa taudia, be do idia hanamoa.” ");
INSERT INTO hmo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isako ese Iakobo dekenai hanamoa ia haorea, bona Iakobo danu Isako ena vairana dekena amo ia raka siri. Vadaeni nega sisina sibona murinai, iena kakana Esau be labana dekena amo ia ginidae. ");
INSERT INTO hmo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ia danu vamu namona ia nadua, iena tamana dekenai ia abia lao, iena tamana ia hamaoroa, ia gwau, “Tamagu e, oi toreisi, oiemu natuna lauegu vamu oi ania, vadaeni oi hanamoa lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Iena tamana Isako ese ia nanadaia, ia gwau, “Oi be daika?” Esau ia haere, ia gwau, “Lau inai, oiemu vara guna natuna Esau.” ");
INSERT INTO hmo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Vadaeni Isako be iena kudouna dekenai ia hoa mai gari danu, ia gwau, “Inai tau be daika, vamu ia alaia, ia mailaia lau dekenai, oi do mai lasi neganai lau ania ore, vadaeni lau hanamoa ia dekenai? Momokani, ia ese hanamoa ena anina dohore ia abia.” ");
INSERT INTO hmo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau ese iena tamana ena hereva ia kamonai neganai ia tai, ia tai mai boiboi danu, iena tamana dekenai ia taitai, ia gwau, “Lau danu, tamagu e, oi hanamoa lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Iena tamana ia gwau, “Oiemu tadina ia mai vadaeni, mai ena koikoi danu, oi dekenai hanamoa totona gauna be ia dadia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau ia gwau, “Iena ladana be Iakobo, mai ena anina, ani? Badina be nega rua ia ese lau dekenai ia koikoi vadaeni. Lauegu vara guna ena hanamoa ia abia guna, harihari danu, lau dekenai hanamoa gauna ia abia vadaeni. Lau dekenai hanamoa ta ia noho lasi, a?” ");
INSERT INTO hmo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isako ese Esau dekenai ia haere henia, ia gwau, “Inai, Iakobo be oiemu biaguna lau halaoa vadaeni, bona iena varavara taudia ibounai lau henia vadaeni, iena hesiai taudia do idia lao, uiti bona uaina danu lau gwauraia vadaeni iena. Natugu e, dahaka do lau karaia oi dekenai?” ");
INSERT INTO hmo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Vadaeni Esau ese iena tamana dekenai ia hamaoroa, ia gwau, “Tamagu e, oiemu hanamoa be tamona sibona, a? Tamagu e, lau danu oi hanamoa.” Vadaeni Esau ia tai dikadika. ");
INSERT INTO hmo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Vadaeni iena tamana Isako ia haere henia, ia gwau, “Tano namona gabuna dekenai do oi noho lasi, guba ena medu ese, oiemu uma tano do ia hanamoa lasi. ");
INSERT INTO hmo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","To oiemu kaia ena goada dekenai dohore oi mauri. Oiemu tadina ena hesiai gaukara do oi karaia, to negana be do ia ginidae, oiemu siahu dohore ia bada. Unai neganai iena siahu, oiemu mauri dogoatao siahuna do oi negea.” ");
INSERT INTO hmo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau ese Iakobo ia badu henia, iena tamana ena hanamoa dainai, vadaeni iena lalona dekenai ia gwau, “Lauegu tamana ena mase dinana ia kahirakahira, unai murinai lauegu tadina Iakobo do lau alaia mase.” ");
INSERT INTO hmo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Haida ese Esau ena hereva Rebeka dekenai idia hamaoroa, vadaeni Rebeka ese iena natuna Iakobo ia boiria, ia hamaoroa, ia gwau, “Oi kamonai, oiemu kakana Esau ena laloa be, oi do ia alaia mase gwauraia. ");
INSERT INTO hmo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Unai dainai, natugu e, lauegu hereva oi kamonai, oi toreisi haraga, Harana hanua dekenai oi lao, lauegu taihuna Labana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nega sisina ia dekenai do oi noho, ia lao bona oiemu kakana ena lalona do ia keruma. ");
INSERT INTO hmo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ia be do ia laloaboio edena bamona oi karaia ia dekenai, vadaeni iena badu do ia ore, unai neganai hereva do lau siaia, vadaeni do oi giroa mai. Umui ruaosi dina tamona lau dekena amo dohore umui boio ena anina be dahaka?” ");
INSERT INTO hmo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Vadaeni Rebeka ese Isako dekenai ia hereva henia, ia gwau, “Lau hesiku vadaeni inai Hiti hahine taudia totona. Bema Iakobo ese inai Hiti taudia edia natuna, inai tano dekenai idia noho ta do ia adavaia, lauegu noho be dohore edena bamona?” ");
INSERT INTO hmo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Vadaeni Isako ese Iakobo ia boiria, ia hanamoa, ia hamaoroa, ia gwau, “Kanana taudia edia natuna ta do oi adavaia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mesopotamia dekenai do oi lao, oiemu tubuna Betuela ena ruma dekenai do oi daekau, oiemu vavana Labana ena natuna kekeni ta do oi adavaia. ");
INSERT INTO hmo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Vadaeni Siahu Ibounai Dirava ese oi do ia hanamoa, oiemu bese do ia havaraia, bona do ia habadaia, bese bada herea umui do ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Dirava ese Aberahamo dekenai hanamoa ia henia, be oi dekenai do ia henia danu, oiemu natuna bona tubuna dekenai do ia henia danu. Ma inai idau gabu dekenai oi noho tanona, Dirava ese Aberahamo dekenai ia henia tanona do oi abia, oiemu tano korikori dekenai do oi halaoa.” ");
INSERT INTO hmo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Vadaeni Isako ese Iakobo ia siaia lao. Ia be Mesopotamia dekenai ia lao, Labana Betuela, Aramea tauna, dekenai. Unai Labana be Rebeka ena taihuna, Rebeka be Iakobo bona Esau edia sinana. ");
INSERT INTO hmo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau ia diba vadaeni, Isako ese Iakobo ia hanamoa vadaeni bona ia siaia lao vadaeni, Mesopotamia dekenai do ia headava. Esau danu ia diba vadaeni, ia hanamoa neganai, Isako ese Iakobo ia hamaoroa, ia gwau, “Kanana taudia edia natuna ta do oi adavaia lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ia diba danu Iakobo be iena tamana bona iena sinana edia gadona ia kamonai henia vadaeni, Mesopotamia dekenai ia lao. ");
INSERT INTO hmo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Vadaeni Esau ena lalona ia kehoa, iena tamana Isako ese Kanana hahine taudia dekenai ia ura henia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Unai dainai, Esau be Isamaela dekenai ia lao, Isamaela, Aberahamo ena natuna ena kekeni Mahalata, Nebaioto ena taihuna, ia adavaia, to iena adavana gunadia ruaosi be idia do noho. ");
INSERT INTO hmo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Iakobo ese Bere Sieba ia rakatania, Harana dala dekenai ia raka. ");
INSERT INTO hmo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Vadaeni gabu ta dekenai ia ginidae, unuseni ia noho ela bona dabai gwauraia, badina be dina ia diho vadaeni. Vadaeni unai gabu ena nadi ta ia abia, iena kwarana atoa totona, vadaeni ia hekure diho, ia mahuta. ");
INSERT INTO hmo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Vadaeni ia nihi, iena nihi dekenai vadavada ta ia itaia, tano dekena amo ia daekau ia lao bona guba, bona Dirava ena aneru unai dekena amo idia daekau, idia diho noho. ");
INSERT INTO hmo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Lohiabada be vadavada ena dokona ataiai ia gini, ia gwau, “Lau be Lohiabada, oiemu tubuna Aberahamo ena Dirava, oiemu tamana Isako ena Dirava danu, lau ese inai oi mahuta noho tanona do lau henia oi dekenai, oiemu natuna bona tubuna danu dekenai do lau henia. ");
INSERT INTO hmo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Oiemu natuna bona oiemu tubuna danu dohore idia momo herea, tano ena kahu bamona, dina ia diho kahana dekenai bona dina ia daekau kahana dekenai, bona mirigini kahana dekenai, bona diho kahana dekenai, dohore idia momo herea. Oi dainai bona oiemu natuna, oiemu tubuna dainai, tanobada ena bese ibounai ese hanamoa do idia davaria. ");
INSERT INTO hmo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Dohore lau durua oi, oi lau henia gabudia ibounai dekenai do lau naria oi, bona oi be do lau hakaua mai lou inai tano dekenai. Lau ese oi do lau rakatania lasi, ela bona oi dekenai lau hereva henia kara ibounai do lau karaia haorea.” ");
INSERT INTO hmo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Iakobo be mahuta dekena amo ia noga, ia gwau, “Momokani, Lohiabada be inai gabu dekenai, to lau diba lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Vadaeni iena kudouna dekenai ia hoa mai gari danu, ia gwau, “Inai gabu be mai gari danu. Dirava ena ruma be inai, guba ena iduara be inai.” ");
INSERT INTO hmo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Daba maragi neganai Iakobo ia toreisi, iena kwarana ia atoa nadina ia haginia, laloatao nadina ia halaoa. Bona unai nadi ena latanai dehoro ia bubua, nadi be Dirava dekenai ia henia totona. ");
INSERT INTO hmo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Vadaeni unai gabu ena ladana ia atoa Betele, ena anina be “Dirava ena Ruma”, to unai gabu ena ladana gunana be Lusu. ");
INSERT INTO hmo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Vadaeni Iakobo ia gwauhamata, ia gwau, “Lohiabada Dirava e, bema oi durua lau dekenai, inai lau raka ena dala dekenai lau do oi naria, aniani do oi henia lau dekenai, bona dabua danu, ");
INSERT INTO hmo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ela bona lauegu tamana ena ruma dekenai do lau giroa mai lou, mai maino danu, unai neganai, oi Lohiabada be lauegu Dirava do lau halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Inai laloatao nadina danu hari lau haginia be Dirava ena ruma dekenai do lau halaoa. Gau ibounai lau dekenai do oi henia be dohore lau haria karaia, kahana ibounai 10, bona kahana ta do lau henia oi dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Iakobo be ia raka lao, bona dina ia daekau ena kahana taudia edia tano dekenai ia ginidae. ");
INSERT INTO hmo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Vadaeni ranu guri ta ia itaia, tano palaka dekenai, mamoe edia orea toi be ranu guri badibadinai idia hekure noho, badina unai ranu be mamoe edia orea dekenai idia henia, inua totona. Nadi badana ta dekena amo guri ena iduara idia koua. ");
INSERT INTO hmo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mamoe edia orea naria taudia edia kara be, ibounai idia haboua unuseni, vadaeni idia ese unai nadi be guri ena iduara dekena amo idia kokia, mamoe dekenai ranu idia henia, vadaeni unai nadi dekenai guri ena iduara idia koua lou. ");
INSERT INTO hmo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Vadaeni Iakobo ese mamoe naria taudia dekenai ia nanadaia, ia gwau, “Lauegu varavara taudia, edeseni umui mai?” Idia gwau, “Ai be Harana taudia.” ");
INSERT INTO hmo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ma ia nanadaia lou idia dekenai, ia gwau, “Umui be Labana, Nahoro ena natuna, umui diba?” Idia gwau, “Ai diba.” ");
INSERT INTO hmo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ma ia nanadaia lou idia dekenai, ia gwau, “Ia be namo, a?” Idia gwau, “Io, ia namo, iena natuna kekeni Rahela mani oi itaia, iena mamoe ia hakaudia mai inai.” ");
INSERT INTO hmo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Iakobo ia gwau, “Hari be dina tubua, mamoe haboua negana be dohore, mamoe dekenai ranu do umui henia, do umui lao, edia aniani do umui henia.” ");
INSERT INTO hmo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Idia haere, idia gwau, “Lasi, mamoe edia orea ibounai do idia haboua guna, vadaeni guri ena iduara koua nadina do ai kokia, bona mamoe ibounai dekenai ranu do ai henia.” ");
INSERT INTO hmo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ia danu do idia herevahereva noho neganai Rahela ia ginidae, iena tamana ena mamoe ia hakaudia, badina be ia ese ia naridia. ");
INSERT INTO hmo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Iakobo ese iena vavana Labana ena natuna kekeni Rahela ia itaia, iena tamana ena mamoe ia hakaudia mai, vadaeni Iakobo ia lao kahirakahira, unai nadi, guri ena iduara dekena amo ia kokia, iena vavana Labana ena mamoe dekenai ranu ia henidia. ");
INSERT INTO hmo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Vadaeni Iakobo ese Rahela dekenai ia kisi henia, bona ia tai mai boiboi danu. ");
INSERT INTO hmo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Iakobo ese Rahela dekenai ia hamaoroa ia be iena tamana Labana ena taihuna Rebeka ena natuna, vadaeni Rahela ia heau, ia lao, iena tamana ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labana ese iena vavana Iakobo ena sivarai ia kamonai, vadaeni ia heau lao, ia rosia, ia kisi henia, vadaeni iena ruma dekenai ia hakaua lao. Vadaeni Iakobo ese sivarai ibounai Labana dekenai ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Vadaeni Labana ese ia hamaoroa, ia gwau, “Momokani, oi be lauegu turiana ena turiana, bona lauegu hidiona ena hidiona.” Unai dainai, Iakobo be ia danu idia noho hua tamona. ");
INSERT INTO hmo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Vadaeni Labana ese Iakobo dekenai ia hereva henia, ia gwau, “Oi be lauegu varavara dainai, lauegu hesiai gaukara do oi karaia, mai emu davana lasi, a? Oi hamaoroa lau dekenai, oiemu davana be dahaka?” ");
INSERT INTO hmo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Inai Labana be mai ena natuna kekeni rua. Ia vara guna ena ladana be Lea, iena tadina ena ladana be Rahela. ");
INSERT INTO hmo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea be hairai lasi, to Rahela be kekeni namona, mai hairai danu. ");
INSERT INTO hmo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Iakobo ese Rahela ia ura henia, unai dainai ia gwau, “Lagani 7 oiemu hesiai gaukara do lau karaia, oiemu natuna kekeni gabeai ia vara, Rahela lau abia totona.” ");
INSERT INTO hmo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labana ia gwau, “Oi dekenai do lau henia be ia namo, idau tauna ta dekenai do lau henia be ia dika, vadaeni lau dekenai oi noho.” ");
INSERT INTO hmo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Unai dainai, Iakobo ese Labana ena hesiai gaukara ia karaia lagani 7, Rahela ia abia totona, to ia laloa be dina momo lasi bamona, badina be ia ese Rahela ia ura henia dikadika. ");
INSERT INTO hmo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Vadaeni Iakobo ese Labana dekenai ia hamaoroa, ia gwau, “Lauegu adavana lau dekenai oi henia, badina be lauegu nega ia ore vadaeni, unai dainai do lau adavaia gwauraia.” ");
INSERT INTO hmo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Vadaeni Labana ese unai gabu taudia ibounai ia haboua, aria ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Hanuaboi neganai, Labana ese iena natuna Lea ia hakaua vareai Iakobo dekenai, vadaeni Iakobo ese ia adavaia. ");
INSERT INTO hmo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labana danu ese iena hesiai hahine Silipa be Lea dekenai ia henia, iena hesiai hahine do ia lao totona. ");
INSERT INTO hmo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Daba ia rere, vadaeni Iakobo ese hahine ia itaia be, Lea sibona. Vadaeni ia ese Labana dekenai ia gwau henia, ia gwau, “Edena bamona oi karaia vadaeni lau dekenai? Oiemu hesiai gaukara lau karaia lasi Rahela abia totona, a? Dahaka totona oi koia lau dekenai?” ");
INSERT INTO hmo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labana ia haere, ia gwau, “Aiemai kara iniseni, ai be kekeni gabeai ia vara, ia headava guna lasi, to vara guna kekeni be do ia headava guna. ");
INSERT INTO hmo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Inai hahine ena aria purana do ia ore, murinai iena tadina danu do ai henia oi dekenai, iena davana be lagani 7 ma lauegu hesiai gaukara do oi karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Iakobo be inai bamona ia karaia, dina 7 idia ore, vadaeni Labana ese iena natuna Rahela ia henia, ia adavaia totona. ");
INSERT INTO hmo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labana danu ese iena hesiai hahine Bileha be Rahela dekenai ia henia, iena hesiai hahine do ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Vadaeni Iakobo ese Rahela danu ia adavaia, ia ese Rahela ia ura henia bada, to Lea ia ura henia maragi. Ia ese Labana ena hesiai gaukara ma ia karaia, lagani 7. ");
INSERT INTO hmo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Iakobo ese Lea ia ura henia lasi dainai, Lohiabada ese Lea ia bogahisihisi henia, ia dekenai natuna ia henia, to Rahela be natuna lasi. ");
INSERT INTO hmo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Vadaeni Lea be ia rogorogo, ia mara, mero ta ia abia, iena ladana ia atoa Rubena, ena anina be “Mero be oi itaia”, badina be ia gwau, “Lohiabada ese lauegu lalohisihisi ia itaia vadaeni, harihari lauegu adavana do ia ura henia lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ma ia rogorogo lou, ia mara, mero ta ia abia, vadaeni ia gwau, “Lohiabada ia kamonai vadaeni lauegu adavana ia ura henia lasi lau dekenai, unai dainai inai mero danu ia henia vadaeni lau dekenai.” Vadaeni iena ladana ia atoa Simeona, ena anina be “Kamonai”. ");
INSERT INTO hmo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ma ia rogorogo, ia mara, mero ta ia abia, vadaeni ia gwau, “Harihari lauegu adavana danu ai haboua, badina be mero toi lau henia vadaeni.” Vadaeni iena ladana ia atoa Levi, ena anina be “Haboua”. ");
INSERT INTO hmo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ma ia rogorogo, ia mara, mero ta ia abia, vadaeni ia gwau, “Harihari Lohiabada lau hanamoa.” Vadaeni iena ladana ia atoa Iuda, ena anina be “Hanamoa”. Unai murinai ia rogorogo lou lasi. ");
INSERT INTO hmo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahela be natuna lasi, unai dainai ia ese iena kakana dekenai ia mama henia. Bona Rahela ese Iakobo dekenai ia gwau henia, ia gwau, “Natuna lau dekenai do oi henia, bema lasi neganai do lau mase.” ");
INSERT INTO hmo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Vadaeni Iakobo ese Rahela dekenai ia badu henia, ia gwau, “Lau be Dirava, a? Ia ese mero oi dekenai ia henia lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Hahine ia gwau, “Lauegu hesiai hahine Bileha ia noho, ia danu oi mahuta hebou, vadaeni lauegu tuina dekenai dohore ia mara, ia dekena amo lauegu natuna do lau abia.” ");
INSERT INTO hmo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Unai dainai, iena hesiai hahine Bileha be Iakobo dekenai ia henia, iena adavana ta, bona Iakobo ese ia sihari henia. ");
INSERT INTO hmo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Vadaeni Bileha ia rogorogo, ia mara, mero ta ia abia, Iakobo ena. ");
INSERT INTO hmo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Vadaeni Rahela ia gwau, “Dirava ese lau dekenai kota ia karaia vadaeni, lauegu noinoi ia abia dae vadaeni, lauegu natuna ia henia lau dekenai.” Vadaeni, iena ladana ia atoa Dano, anina be “Kota Hereva”. ");
INSERT INTO hmo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahela ena hesiai hahine Bileha ma ia rogorogo, ia mara, mero iharuana ia abia, Iakobo ena. ");
INSERT INTO hmo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Vadaeni Rahela ia gwau, “Lauegu kakana danu ai goada helulu, lau kwalimu vadaeni.” Vadaeni mero ena ladana ia atoa Napatali, ena anina be “Goada Helulu”. ");
INSERT INTO hmo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea ia diba vadaeni do ia rogorogo lou lasi, vadaeni iena hesiai hahine Silipa ia abia, Iakobo dekenai ia henia, iena adavana ta. ");
INSERT INTO hmo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Vadaeni Lea ena hesiai hahine Silipa ia rogorogo, ia mara, mero ta ia abia, Iakobo ena. ");
INSERT INTO hmo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Vadaeni, Lea ia gwau, “Lauegu laki ena nega be inai.” Vadaeni mero ena ladana ia atoa Gado, anina be “Laki Nega Namona”. ");
INSERT INTO hmo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Vadaeni Lea ena hesiai hahine Silipa ma ia rogorogo, ia mara, mero iharuana ia abia, Iakobo ena. ");
INSERT INTO hmo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Vadaeni Lea ia gwau, “Lau moale, hahine ibounai danu do idia hanamoa lau dekenai.” Vadaeni mero ena ladana ia atoa Asere, ena anina be “Moale.” ");
INSERT INTO hmo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Uiti utua ena nega dekenai Rubena be ia lao, au huahua ena ladana dudai haida ia davaria, vadaeni ia abia, iena sinana Lea dekenai ia abia lao. Vadaeni Rahela ese Lea dekenai ia noia, ia gwau, “Oiemu natuna ena dudai haida oi henia lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","To Lea ese ia gwau henia, ia gwau, “Lauegu adavana oi henaoa be oi laloa lasi, a? To edena bamona lauegu natuna ena dudai oi dadia gwauraia.” Vadaeni Rahela ia gwau, “Oiemu natuna ena dudai oi henia lau dekenai, vadaeni hari hanuaboi iseda adavana danu umui mahuta gabu tamona dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Adorahi neganai, Iakobo be uma dekena amo ia giroa mai, vadaeni Lea be iena vairana dekenai ia lao, ia gwau, “Hari hanuaboi ita ruaosi gabu tamona dekenai do ita mahuta, lauegu natuna ena dudai Rahela dekenai lau henia ena davana.” Vadaeni unai hanuaboi idia ruaosi gabu tamona dekenai idia mahuta. ");
INSERT INTO hmo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Vadaeni Dirava ese Lea ena guriguri dekenai ia kamonai, unai dainai ia rogorogo, ia mara, mero ta namba 5 ia abia, Iakobo ena. ");
INSERT INTO hmo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Vadaeni Lea ia gwau, “Lauegu hesiai hahine be lauegu adavana dekenai lau henia ena davana be inai, Dirava ese lau dekenai mero ia henia vadaeni.” Vadaeni mero ena ladana ia atoa Isakara, ena anina be “Davana”. ");
INSERT INTO hmo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea ma ia rogorogo lou, ia mara, mero namba 6 ia abia, Iakobo ena. ");
INSERT INTO hmo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Vadaeni ia gwau, “Dirava ese harihari gauna namona lau dekenai ia henia vadaeni, harihari lauegu adavana be lau dekenai do ia noho momokani, badina be iena natuna memero 6 lau henia vadaeni.” Vadaeni mero ena ladana ia atoa Sebuluno, ena anina be “Noho”. ");
INSERT INTO hmo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Unai murinai, ia be ena natuna kekeni ta ia abia, vadaeni kekeni ena ladana ia atoa, Daina. ");
INSERT INTO hmo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Unai neganai Dirava ese Rahela dekenai ia laloa, iena noinoi ia abia dae, vadaeni ia danu ia rogorogo. ");
INSERT INTO hmo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ia mara, mero ta ia abia, vadaeni ia gwau, “Dirava ese lauegu hemarai ia kokia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Vadaeni mero ena ladana ia atoa Iosepa, ena anina be “Ma ta”, ia gwau, “Dirava ese natuna mero ma ta bema ia henia lau dekenai be namo.” ");
INSERT INTO hmo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Iosepa ia vara murinai, Iakobo ese Labana dekenai ia hamaoroa, ia gwau, “Mani emu kara oiemu imana dekena amo oi siaia lau, lauegu gabu korikori dekenai do lau lao, egu tano korikori dekenai do lau giroa lou. ");
INSERT INTO hmo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Lauegu adavana bona lauegu natuna lau dekenai oi henia, badina be idia totona oiemu hesiai gaukara lau karaia vadaeni. Oiemu imana dekena amo oi negea lau, lauegu hekwarahi oiemu hesiai gaukara dekenai lau karaia be oi diba vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labana ia gwau, “Lau noia oi dekenai, mani emu kara oi raka siri lasi, badina be lauegu lalona ia kehoa vadaeni, Lohiabada ese lau ia hanamoa oi dainai. ");
INSERT INTO hmo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Oiemu davana do oi gwauraia, vadaeni do lau henia oi dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Iakobo ese ia haere henia, ia gwau, “Lauegu hekwarahi bada oiemu hesiai gaukara dekenai, be oi itaia vadaeni, oi diba danu oiemu mamoe be idia momo herea vadaeni lauegu imana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Lau be lau do mai lasi neganai, oi be oi ogogami vadaeni, harihari oi be kohu momo tauna, lau mai negana ia mai bona hari Lohiabada ese oi ia hanamoa vadaeni. To hari be nega ia ginidae vadaeni, egu adavana bona natuna kohu momo do idia davaria totona do lau gaukara hamatamaia.” ");
INSERT INTO hmo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Vadaeni Labana ia gwau, “Dahaka oi dekenai do lau henia?” Iakobo ia gwau, “Moni davana lau dekenai do oi henia lasi, to bema lauegu ura oi abia dae neganai, oiemu mamoe bona nani do lau naridia noho. ");
INSERT INTO hmo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Mani emu kara, hari dina oiemu mamoe bona nani do lau haria karaia. Mamoe mai toutou danu, o mai revareva danu, bona mamoe korema, bona nani mai toutou danu, o mai revareva danu, ibounai do lau hakaua siri, lauegu davana be unai. ");
INSERT INTO hmo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nega gabeai do oi diba, lau be maoro o kerere, bema lauegu mamoe bona nani edia huanai toutou lasi gaudia, revareva lasi gaudia, o kurokuro gaudia oi itaia neganai, lau be henaoa tauna momokani.” ");
INSERT INTO hmo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Vadaeni Labana ia gwau, “Oiemu hereva hegeregerena do ita karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","To unai dina dekenai Labana ese nani tatau bona nani hahine mai toutou gaudia, bona mai revareva gaudia, bona mamoe korema, ibounai ia hakaua siri, iena natuna dekenai ia henidia, idia naridia totona. ");
INSERT INTO hmo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ma Labana ese inai mamoe bona nani orea ibounai ia hakaua lao sisina daudau, dina toi ena raka hegeregerena. To Iakobo ese Labana ena mamoe bona nani, ia rakatania gaudia, ia naridia. ");
INSERT INTO hmo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Vadaeni Iakobo ese au idaudia toi edia rigi matamatadia ia utua, edia kopina kahana ia kokia, kahana ia noho, itaia neganai be revareva bamona. ");
INSERT INTO hmo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Vadaeni unai rigi mai revareva gaudia be ranu gabudia dekenai ia haginia, mamoe bona nani ranu inua totona idia mai neganai. Rigi be unuseni ia atodia, badina be mamoe bona nani hahine be idia rogorogo unai inua gabuna dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Unai rigi edia vairana dekenai idia rogorogo neganai, edia natuna idia vara be mai revareva danu. ");
INSERT INTO hmo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Inai bamona nani bona mamoe natudia be Iakobo ese ia abia siri, idia be iena mamoe bona nani orea gaudia danu ia haboua. To Labana ena mamoe bona nani orea danu ia haboua lasi. ");
INSERT INTO hmo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Vadaeni nani bona mamoe hahine, mai goada gaudia idia sihari neganai, Iakobo ese inai rigi idia edia vairana dekenai ia haginidia, ranu gabudia dekenai, rigi idia itaia nega lalonai do idia rogorogo totona. ");
INSERT INTO hmo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","To goada lasi gaudia idia sihari neganai, inai rigi ia haginidia lasi edia vairana dekenai. Unai dekenai goada lasi gaudia be Labana ena, bona mai edia goada gaudia be Iakobo ena. ");
INSERT INTO hmo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Unai dala dekenai Iakobo be kohu momo tauna momokani ia lao. Iena mamoe bona nani be momo herea, iena hesiai tatau bona hahine, kamelo bona doniki danu idia momo herea. ");
INSERT INTO hmo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Vadaeni Iakobo ese Labana ena natuna tatau edia hereva ia kamonai, idia gwau, “Iakobo ese iseda tamana ena kohu ibounai ia abia vadaeni. Iena kohu momo be iseda tamana dekena amo ia abia.” ");
INSERT INTO hmo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Iakobo danu ia itaia, ia dekenai Labana ena vairana toana be ia badu bamona. ");
INSERT INTO hmo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Unai neganai Lohiabada ese Iakobo dekenai ia hamaoroa, ia gwau, “Oi giroa lou oiemu tubuna bona oiemu tamana edia tano dekenai, oiemu varavara taudia dekenai oi lao. Lau ese do lau bamoa oi.” ");
INSERT INTO hmo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Vadaeni Iakobo ese Rahela bona Lea dekenai ia boiboi, idia mai ia dekenai, tano palaka dekenai mamoe bona nani idia naria gabuna dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Idia dekenai ia hereva, ia gwau, “Lau itaia vadaeni, umui emui tamana ena laloa be idau lau dekenai, guna bamona lasi, to lauegu tamana ena Dirava ese lau ia durua vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Umui danu umui diba vadaeni lau be emui tamana dekenai lau gaukara vadaeni, mai egu goada ibounai. ");
INSERT INTO hmo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Emui tamana ese lau ia koia, nega 10 egu davana ia haidaua, to Dirava ese ia koua dainai, lau ia hadikaia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Labana ia gwau, ‘Mai toutou gaudia be oiemu’, vadaeni nani ibounai toutou gaudia sibona idia vara. Ma ia gwau, ‘Mai revareva gaudia be oiemu’, vadaeni nani ibounai revareva gaudia sibona idia vara. ");
INSERT INTO hmo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Unai dekena amo Dirava ese emui tamana ena mamoe bona nani be ia dekena amo ia kokia, lau dekenai ia henia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Mamoe bona nani hahine edia sihari neganai, lau be lau nihi, egu nihi dekenai lau itaia, mamoe bona nani tatau mai toutou, mai revareva, bona korema gaudia sibona be hahine danu idia sihari. ");
INSERT INTO hmo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Vadaeni egu nihi dekenai, Dirava ena aneru ese ia hereva lau dekenai, ia gwau, ‘Iakobo e.’ Lau haere, lau gwau, ‘Lau inai.’ ");
INSERT INTO hmo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ma ia gwau, ‘Oi itaia, mamoe bona nani tatau, hahine dekenai idia sihari henia gaudia be toutou gaudia, revareva gaudia bona korema gaudia sibona. Lau be inai kara lau havaraia noho, badina be Labana ena kara ibounai oi dekenai lau itaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Lau inai, Betele dekenai oi dekenai lau hedinarai Diravana. Unuseni oi ese boubou nadi ta ena latanai olive dehoro oi bubua, bona oi gwauhamata lau dekenai. Hari oi toreisi, inai tano oi rakatania, oiemu vara gabuna dekenai do oi giroa lou.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahela bona Lea be Iakobo dekenai idia haere, idia gwau, “Dahaka do ai abia aiemai tamana dekena amo? Gau ta ia noho lasi ai dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ai be idau taudia bamona ia dekenai, ani? Badina be aiemai davana ia abia vadaeni, bona ia negea haorea vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kohu ibounai Dirava ese aiemai tamana dekena amo ia abia be aiemai, bona aiemai natuna edia, unai dainai, Dirava ese oi dekenai ia hamaoroa vadaeni, unai bamona do oi karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Vadaeni Iakobo ena adavana ruaosi, bona iena natuna ibounai be kamelo dekenai idia guia. ");
INSERT INTO hmo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Iena mamoe ibounai bona iena kohu ibounai Mesopotamia dekenai ia davaria gaudia be Iakobo ese ia siaia guna, vadaeni ia hegaegae, Kanana tanona dekenai do ia lao, iena tamana Isako dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Unai neganai Labana be iena mamoe edia huina utua totona ia lao. Vadaeni Rahela ese iena tamana ena dirava edia laulauna ia henaoa, ");
INSERT INTO hmo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","bona Iakobo be hunia dekenai ia heau, Labana, Aramea tauna ia hadibaia guna lasi. ");
INSERT INTO hmo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ia be ia lao, iena orea taudia bona iena kohu ibounai ia abia lao, Euperate Sinavai idia hanaia, Gileada ena ororo dala dekenai idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Dina rua idia ore, bona dina ihatoina neganai, Labana ese Iakobo ia heau ena sivarai ia kamonai. ");
INSERT INTO hmo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Vadaeni ia ese iena varavara taudia ia haboua, bona dina 7 Iakobo ena murina dekenai idia lulua lao haragaharaga, ia lao bona Gileada ena ororo dekenai idia davaria. ");
INSERT INTO hmo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","To Dirava ese Labana, Aramea tauna dekenai ia hedinarai henia nihi dekena amo, ia gwau, “Iakobo dekenai oi hereva henia lasi, hereva namona o hereva dikana.” ");
INSERT INTO hmo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Vadaeni Labana ese Iakobo ia davaria. Iakobo be ororo dekenai ia kamepa vadaeni, Labana mai ena varavara taudia danu Gileada ororo dekenai idia kamepa. ");
INSERT INTO hmo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Vadaeni Labana ese Iakobo dekenai ia gwau henia, ia gwau, “Badina be dahaka oi heau hunia dala dekenai, lauegu natuna hahine danu henaoa dala bamona oi danu idia heau? ");
INSERT INTO hmo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Dahaka totona oi heau hunia dala dekenai, oi hadibaia lasi lau dekenai? Bema oi hadibaia lau dekenai, vadaeni lauegu imana dekena amo oi do lau siaia, mai moale karaia, bona mai moale ane danu, io, mai gaba ena regena bona mai gita ena regena danu. ");
INSERT INTO hmo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","To oi ese lauegu dala oi koua, lauegu natuna danu lau kisi henia lasi. Oi karaia kava vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Harihari lau be mai siahu lau hadikaia diba oi, to oiemu tamana ena Dirava ese hari hanuaboi ia hedinaraia lau dekenai, ia gwau, ‘Iakobo dekenai oi hereva lasi, hereva namona o hereva dikana.’ ");
INSERT INTO hmo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Harihari oiemu tamana ena ruma, oi ura henia bada gabuna dekenai dohore oi lao, to dahaka totona lauegu dirava edia laulauna oi henaoa?” ");
INSERT INTO hmo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Vadaeni Iakobo ese Labana dekenai ia haere henia, ia gwau, “Lau gari, lau gwau oiemu natuna be lau dekena amo do oi abia lou sedira. ");
INSERT INTO hmo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","To oiemu dirava edia laulauna be daika dekenai do oi davaria, ia be do ia mase, iseda varavara edia vairana dekenai oiemu oi tahua, do oi abia.” Badina Iakobo be ia diba lasi Rahela ese ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Vadaeni Labana be Iakobo ena palai ruma dekenai ia tahua, bona Lea ena palai ruma dekenai, bona hesiai hahine ruaosi edia palai ruma dekenai, to gau ta ia davaria lasi. Vadaeni Rahela ena palai ruma dekenai ia raka vareai. ");
INSERT INTO hmo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahela be inai dirava edia laulauna ia abia vadaeni, bona kamelo ese idia huaia pusepuse ena lalonai ia hunia vadaeni. Rahela be unai pusepuse ena latanai ia helai. Labana be palai ruma dekenai ia tahua, mai hekwarahi danu, to iena dirava laulauna ia davaria lasi. ");
INSERT INTO hmo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Vadaeni Rahela ese iena tamana dekenai ia hereva henia, ia gwau, “Tau badana e, oi badu lasi lau dekenai, oiemu vairana dekenai lau toreisi lasi, badina be hahine aiemai hua gorere lau abia dainai.” Unai dainai ia tahua mai hekwarahi danu, iena dirava edia laulauna ia davaria lasi. ");
INSERT INTO hmo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Vadaeni Iakobo ese Labana dekenai ia badu henia, ia gwau henia, ia gwau, “Lauegu kerere be dahaka, lauegu dika be dahaka, vadaeni oi ese unai dainai lauegu murina dekenai oi lulua, mai badu danu? ");
INSERT INTO hmo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Lauegu kohu ibounai oi tahua haorea vadaeni, oiemu ruma ena gau ta oi davaria be edeseni? Lauegu orea taudia bona oiemu orea taudia edia vairana dekenai unai kohu do oi atoa hedinarai, vadaeni ita ruaosi dekenai kota do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Oi dekenai lagani 20 lau noho vadaeni, oiemu mamoe bona oiemu nani hahine idia mara dika lasi, oiemu nani tatau danu ta lau abia lasi, lau ania lasi. ");
INSERT INTO hmo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Uda boroma ese bero idia henia gaudia lau mailaia lasi oi dekenai, lau sibona bero lasi gauna lau henia, edia gabu abia totona. Henaoa taudia ese dina dekenai idia henaoa, o hanuaboi dekenai idia henaoa, gaudia danu edia davana be lau dekenai oi tahua. ");
INSERT INTO hmo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Lau noho unai bamona, dina neganai be dina ena siahu ia hadikaia lau dekenai, hanuaboi keru ia hadikaia lau dekenai, lauegu matana danu idia mahuta lasi. ");
INSERT INTO hmo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Lagani 20 oiemu ruma dekenai lau noho, lagani 14 oiemu hesiai gaukara lau karaia, oiemu natuna ruaosi edia davana, ma lagani 6 oiemu mamoe edia davana. Nega 10 lauegu davana oi haidaua. ");
INSERT INTO hmo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Lauegu tamana ena Dirava, Aberahamo ena Dirava, bona Isako ia gari henia Diravana, bema ia durua lasi lau dekenai, harihari lau be mai kohu lasi lau do oi lulua. To Dirava ese lauegu hekwarahi bona lauegu imana ena gaukara ia itaia vadaeni, vadaeni hanuaboi ia hereva henia oi dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Vadaeni Labana ese ia haere henia, ia gwau, “Inai hahine be lauegu natuna, inai memero be lauegu tubuna, inai mamoe be lauegu mamoe, oi itaia gaudia ibounai be lauegu. Ma hari dina dahaka do lau karaia, inai lauegu natuna bona tubuna dekenai hanamoa totona? ");
INSERT INTO hmo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Oi mai, maino ita karaia, bona laloatao nadina do ita karaia, iseda maino toana do ia lao totona.” ");
INSERT INTO hmo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Vadaeni Iakobo ese laloatao nadina ta ia haginia. ");
INSERT INTO hmo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Iakobo danu ese iena orea taudia dekenai ia hamaoroa, ia gwau, “Nadi umui gogoa.” Unai bamona idia karaia, vadaeni unai nadi idia haboua gaudia edia badibadinai idia aniani hebou. ");
INSERT INTO hmo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Vadaeni Labana ese unai gabu ena ladana ia atoa, Iegara Sahaduta, bona Iakobo ese unai gabu ena ladana ia atoa Galeda, ladana ruaosi edia anina be “Hereva hedinaraia nadi”. ");
INSERT INTO hmo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Vadaeni Labana ia gwau, “Hari dina dekenai inai nadi haboua ese, be maino laloatao toana oi bona lau iseda huanai.” Unai dainai unai laloatao nadina ena ladana be Galeda. ");
INSERT INTO hmo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ma iena ladana ta be Misipa, badina Labana be ia gwau, “Ita ta ta be idau gabu idau gabu ita noho neganai Lohiabada ese do ia naria namonamo ita. ");
INSERT INTO hmo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Bema lauegu natuna do oi dagedage henidia, o hahine haida ma do oi abia, lau be do lau itaia lasi oi, to Dirava ese do ia itaia oi bona lau, laloaboio lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labana ese Iakobo dekenai ma ia hereva henia, ia gwau, “Inai nadi haboua gaudia bona inai laloatao nadina be ita ruaosi iseda huana dekenai lau haginia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Inai nadi haboua gaudia bona inai laloatao nadina edia anina be inai, lau ese inai nadi do lau raka hanaia lasi, oi dekenai hadikaia totona, bona oi ese inai nadi do oi raka hanaia lasi, lau dekenai hadikaia totona. ");
INSERT INTO hmo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Aberahamo ena Dirava, Nahoro ena Dirava, idia edia tamana ena Dirava danu, ia ese kota do ia karaia oi bona lau ita huanai.” Vadaeni Iakobo be iena tamana Isako ese ia gari henia Diravana ena ladana dekenai ia gwauhamata. ");
INSERT INTO hmo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Vadaeni Iakobo ese boromakau ia alaia, Dirava ena boubou ia karaia unai ororo dekenai, bona iena orea taudia dekenai ia boiridia hebou, idia aniani totona. Unai dainai, idia aniani, bona unai ororo dekenai idia noho ela bona dabai. ");
INSERT INTO hmo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Dabai Labana ia toreisi, iena tubuna mai edia sinadia danu ia kisi henidia bona ia hanamodia. Vadaeni ia rakatanidia, iena hanua dekenai ia giroa lou. ");
INSERT INTO hmo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Iakobo be iena laolao ma ia raka lao, vadaeni Dirava ena aneru momo danu ia hedavari. ");
INSERT INTO hmo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Iakobo ese ia itadia, vadaeni ia gwau, “Inai be Dirava ena tuari orea.” Unai dainai unai gabu ena ladana ia atoa, “Tuari orea rua.” ");
INSERT INTO hmo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Iakobo ese iena hesiai taudia ia siaia guna, iena kakana Esau dekenai do idia lao, Seiri ena tano lalonai. Unai be Edoma ena tano. ");
INSERT INTO hmo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Idia dekenai ia hadibaia, ia gwau, “Lauegu lohia Esau dekenai umui hamaoroa, umui gwau, ‘Lau, oiemu hesiai tauna Iakobo, lau gwau lau be Labana danu lau noho ia mai bona hari. ");
INSERT INTO hmo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Lau be mai egu boromakau, bona doniki, bona mamoe bona nani, bona hesiai taudia bona hesiai hahine. Lohia e, hereva lau siaia oi dekenai, sedira oiemu laloa do ia namo lau dekenai totona.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Hereva abia lao taudia Iakobo dekenai idia giroa lou neganai idia gwau, “Ai be oiemu kakana Esau danu ai hedavari, ia be hari ia mai noho, oi danu ia hedavari totona, iena orea taudia 400 danu.” ");
INSERT INTO hmo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Iakobo be ia gari dikadika, iena kudouna danu ia hekwarahi bada. Vadaeni iena orea taudia bona iena mamoe bona nani, iena boromakau, iena kamelo danu, be orea rua dekenai ia haria. ");
INSERT INTO hmo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ia laloa, “Bema Esau ese orea ta ia tuari henia, sedira ta be do ia heau mauri.” ");
INSERT INTO hmo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Vadaeni Iakobo ia guriguri, ia gwau, “Lauegu tubuna Aberahamo ena Dirava e, lauegu tamana Isako ena Dirava e, mani oi kamonai! Guna oi hereva lau dekenai, oi gwau, ‘Oiemu tano bona oiemu varavara taudia dekenai do oi giroa lou, vadaeni do lau hanamoa oi.’ ");
INSERT INTO hmo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Oiemu bogahisihisi bona oiemu gwauhamata hamomokania kara ibounai, lau oiemu hesiai tauna dekenai oi henia, be lauegu namo ia hegeregere lasi. Lau be Ioridane Sinavai lau hanaia lao neganai, lauegu imana dekenai be itotohi sibona mo. To hari be mai orea rua danu lau giroa mai vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Oi dekenai lau noinoi inai, mani lauegu kakana Esau ena siahu dekena amo do oi hamauria lau. Badina be lau gari, ia be do ia mai, do ia tuari henia ai dekenai, lauegu natuna bona edia sinadia do ia aladia mase. ");
INSERT INTO hmo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Oiemu gwauhamata mani oi laloa, oi gwau, ‘Momokani, lau ese do lau hanamoa oi, bona oiemu natuna bona tubuna momo herea oi dekenai do lau henia, kone miri bamona, duahia diba lasi.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Unai hanuaboi Iakobo be unuseni ia kamepa, vadaeni iena kohu dekena amo harihari gaudia ia abia, iena kakana Esau ena. ");
INSERT INTO hmo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Gaudia be inai: Nani hahine 200 bona nani tatau 20, mamoe hahine 200 bona mamoe tatau 20, ");
INSERT INTO hmo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamelo 30 mai edia natuna danu, boromakau hahine 40, boromakau tatau 10, doniki hahine 20, bona doniki tatau 10. ");
INSERT INTO hmo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Inai ibounai be iena hesiai taudia dekenai ia henia, ta ta edia orea, edia orea dekenai, bona ia gwau, “Umui raka guna, orea ta ta umui hakaua lao, mai pada ta ta.” ");
INSERT INTO hmo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Do ia raka guna tauna dekenai ia hamaoroa, ia gwau, “Lauegu kakana Esau danu do umui hedavari neganai, do ia nanadaia oi dekenai, do ia gwau, ‘Oiemu biaguna be daika? Edeseni do umui lao? Inai ubua gaudia umui emui vairanai be daika ena?’ ");
INSERT INTO hmo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Vadaeni, do oi haere henia, oi gwau, ‘Inai be oiemu hesiai tauna Iakobo ena. Iena harihari gaudia ia siaia, lauegu biaguna Esau ena. Iakobo danu aiemai murina dekenai ia mai noho.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Orea namba 2 hakaua tauna dekenai danu inai bamona do ia hereva, orea namba 3 hakaua tauna danu, bona idia edia murina dekenai orea ta ta hakaua taudia ibounai dekenai inai hereva tamona ia henia, ia gwau, “Esau danu umui hedavari neganai, inai bamona do umui hereva henia. ");
INSERT INTO hmo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Do umui gwau, ‘Oiemu hesiai tauna Iakobo be aiemai murina dekenai ia mai noho.’ ” Iakobo be inai bamona ia laloa, “Lauegu harihari gaudia dekena amo, Esau ena badu do lau koua, bona gabeai lau hedinaraia iena vairana dekenai neganai, sedira do ia abia dae lau.” ");
INSERT INTO hmo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Unai dainai, harihari gaudia be hesiai taudia ese idia abia lao guna, to Iakobo be unai hanuaboi kamepa dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Hanuaboi momokani neganai Iakobo ia toreisi, iena adavana ruaosi bona iena hesiai hahine ruaosi, bona iena natuna tatau 11 ia abidia, sinavai maragina ena ladana Iaboka idia hanaia gwauraia. ");
INSERT INTO hmo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ia ese ibounai ia abidia lao, sinavai unai kahana dekenai idia hanaia lao. Vadaeni ia sibona ia giroa lou, iena hesiai taudia ia siaidia lao, iena kohu ibounai idia abia hanaia. ");
INSERT INTO hmo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","To Iakobo be sibona ia noho, vadaeni Tau ta ia danu idia rosia helulu, daika do ia kwalimu totona, ia lao bona daba kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Inai Tau ia diba ia be do ia kwalimu diba lasi, vadaeni ia ese Iakobo ena mamuna varovaro dekenai ia dogoatao, unai dainai Iakobo ena mamuna ataiai dagira turia komukomu gabuna ia kokia, idia rosia helulu lalonai. ");
INSERT INTO hmo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Vadaeni inai Tau ia gwau, “Lau oi dogoatao noho lasi, badina be daba rere ia kahirakahira vadaeni.” To Iakobo ia gwau, “Lau be oi do lau dogoatao noho, ela bona oi ese do oi hanamoa lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Vadaeni inai Tau ia gwau, “Oiemu ladana be daika?” Ia haere, ia gwau, “Lauegu ladana be Iakobo.” ");
INSERT INTO hmo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Inai Tau ma ia gwau, “Harihari ia lao bona hanaihanai oiemu ladana be Iakobo lasi, oiemu ladana be Israela, badina be Dirava danu bona taunimanima danu oi rosia helulu, daika do ia kwalimu totona, bona oi ese oi kwalimu vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Vadaeni Iakobo ese inai Tau dekenai ia nanadaia, ia gwau, “Mani emu kara oiemu ladana oi hadibaia lau dekenai.” Inai Tau ia gwau, “Badina be dahaka lauegu ladana oi nanadaia?” Vadaeni ia ese Iakobo ia hanamoa. ");
INSERT INTO hmo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Vadaeni Iakobo ese unai gabu ena ladana ia atoa Peniela, ena anina be “Dirava ena vairana”. Ia gwau, “Badina be Dirava danu ai ruaosi ai ta ta emai vairana ta ta dekenai ai henia, to lau do mauri noho vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Vadaeni daba ia rere neganai, Iakobo ese Peniela ia rakatania, to ia raka namonamo lasi, badina iena mamuna be ia dika. ");
INSERT INTO hmo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Unai dainai Israela ena bese taudia be mamuna ena ataiai dagira turia ena varovaro idia ania lasi ia mai bona harihari, badina inai varovaro be Iakobo dekenai, Dirava ese ia dogoatao vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Iakobo ese iena matana ia negea, Esau ia itaia, mai ena tatau 400 idia mai noho. Unai dainai ia ese iena natuna orea ta ta dekenai ia haria karaia. Lea ese haida, Rahela ese haida, bona hesiai hahine rua ese haida idia hakaua. ");
INSERT INTO hmo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Hesiai hahine mai edia natudia idia lao guna, Lea mai ena natudia be idia murinai idia raka, gabeai Rahela mai ena natuna Iosepa danu idia raka. ");
INSERT INTO hmo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Iakobo ese idia edia vairana dekenai ia raka guna, bona nega 7 iena kwarana ia atoa diho tano dekenai, ia lao bona iena kakana kahirakahira dekenai ia ginidae. ");
INSERT INTO hmo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Vadaeni Esau ese ia dekenai ia heau lao, ia rosia, bona ia kisi henia. Ruaosi idia taitai noho. ");
INSERT INTO hmo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau ese hahine mai edia natudia ia itadia neganai, ia gwau, “Inai taudia be daika?” Iakobo ia haere, ia gwau, “Lohia e, inai be lauegu natuna, Dirava ese iena lalokau dekena amo lau dekenai ia henia taudia.” ");
INSERT INTO hmo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Unai murinai hesiai hahine mai edia natudia danu idia mai, vadaeni edia kwarana idia atoa diho tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Unai murinai Lea mai ena natuna idia mai, gabeai Iosepa bona Rahela idia mai, edia kwarana idia atoa diho tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau ia nanadaia, ia gwau, “Unai guna lau itaia orea be edena bamona?” Iakobo ia haere, ia gwau, “Unai be lauegu harihari gaudia, oiemu lalona hamoalea totona, vadaeni do lau mauri gwauraia.” ");
INSERT INTO hmo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","To Esau ia gwau, “Lauegu tadina e, lauegu kohu be idia hegeregere, inai be oiemu, oi dogoatao.” ");
INSERT INTO hmo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Iakobo ia gwau, “Lasi, bema oiemu lalona be ia namo lau dekenai lauegu harihari gauna mani oi abia. Oiemu vairana lau itaia be, Dirava ena vairana bema lau itaia hegeregere, badina be oiemu lalona ia namo lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mani emu kara lauegu harihari gaudia oi abia dae, badina be Dirava ese iena bogahisihisi dekena amo kohu lau ura hegeregerena ia henia vadaeni lau dekenai.” Ia noia goada dainai ia abia dae. ");
INSERT INTO hmo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau ia gwau, “Namo ita lao nega tamona. Lau be umui danu do ita raka hebou.” ");
INSERT INTO hmo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Iakobo ia haere, ia gwau, “Lohia e, oi diba lauegu natuna be idia manoka vadaeni, bona mamoe bona boromakau mai natudia gaudia dekenai lau laloa momo. Bema dina tamona lalonai naria taudia ese unai mamoe bona nanigosi idia luludia haraga neganai, ibounai do idia mase ore. ");
INSERT INTO hmo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Egu lohia e, mani emu kara, lauegu vairana dekenai oi raka guna, to lau be metairametaira do lau raka oiemu murina dekenai, egu boromakau, mamoe, bona egu natuna edia goada hegeregerena, ia lao bona Seiri dekenai ai ginidae neganai oi danu do ita hedavari.” ");
INSERT INTO hmo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau ia gwau, “Sedira egu tatau haida be oi danu do idia raka lao.” To Iakobo ia haere, ia gwau, “Egu lohia e, oiemu hereva be ia namo, to mani oi laloa lasi ai dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Vadaeni unai dina dekenai Esau ese Seiri dalana dekenai ia raka lao, Seiri dekenai ia giroa lou. ");
INSERT INTO hmo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","To Iakobo be Sukoto dekenai ia lao. Unuseni iena ruma ta ia haginia, bona boromakau bona mamoe edia au raurau mai rigi danu ruma ia karaia. Unai dainai unai gabu ena ladana ia atoa Sukoto, ena anina be “au raurau rumadia.” ");
INSERT INTO hmo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Iakobo be Mesopotamia dekena amo ia giroa mai neganai, ia ginidae Sekema hanua, Kanana tanona dekenai, mai mauri danu. Vadaeni hanua kahirakahira dekenai palai rumadia ia haginia, unuseni ia kamepa. ");
INSERT INTO hmo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Unai palai rumadia ia haginia tano kahana be ia hoia Hamoro ena natuna dekena amo. Davana be siliva moni 100. Hamoro be Sekema ena tamana. ");
INSERT INTO hmo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Unuseni boubou patana ta ia haginia, bona ena ladana ia atoa “El, Israela ena Dirava”. ");
INSERT INTO hmo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Iakobo bona Lea edia natuna hahine ladana Daina be ia loaloa, unai tano dekenai noho hahine haida ia vadivadi henidia totona. ");
INSERT INTO hmo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Vadaeni, unai tano ena lohia tauna ena ladana Hamoro, Hivi tauna, ena natuna Sekema ese Daina ia itaia, ia rosia, vadaeni ia kara dika henia. ");
INSERT INTO hmo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","To Sekema ese unai kekeni ia ura henia dikadika, bona ia lalokau henia dainai, Daina ena lalona hanamoa totona bogahisihisi hereva ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Unai murinai iena tamana Hamoro dekenai ia noinoi, ia gwau, “Unai kekeni mani oi abia, lau ura lau adavaia.” ");
INSERT INTO hmo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Iakobo be hereva ia kamonai, iena natuna kekeni, tau ta ese ia hadikaia vadaeni. To iena natuna be gabu ta dekenai boromakau idia naria dainai, kara ta ia karaia lasi ela bona idia giroa mai. ");
INSERT INTO hmo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Vadaeni Hamoro, Sekema ena tamana be Iakobo dekenai ia lao, do idia herevahereva totona. ");
INSERT INTO hmo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Unai neganai Iakobo ena natuna be boromakau naria gaukara dekena amo idia giroa mai vadaeni. Unai hereva idia kamonai neganai, idia hoa, bona idia badu dikadika, badina be unai tau ese Israela taudia dekenai kara dikana ia karaia, Iakobo ena natuna kekeni ia hadikaia dainai. Badina be kara unai bamona be taravatu bada herea. ");
INSERT INTO hmo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","To Hamoro ese ia hereva idia dekenai, ia gwau, “Lauegu natuna Sekema be oiemu natuna kekeni ia ura henia dikadika, mani emu kara do oi henia, do ia adavaia. ");
INSERT INTO hmo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Iseda bese ruaosi ita hakapua be namo, umui ese emui kekeni umui henia ai dekenai, idia headava, ai danu aiemai kekeni do ai henia umui dekenai, idia headava. ");
INSERT INTO hmo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Unai neganai aiemai huana dekenai do umui noho, aiemai tano be umui emui tano do umui halaoa, iniseni uma gabudia do umui karaia, do umui hoihoi, bona hanua do umui karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekema ese danu Daina ena tamana bona taihuna dekenai ia hereva, ia gwau, “Bema lauegu noinoi umui abia dae neganai, dahaka umui gwauraia lau dekenai be do lau henia umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Bema umui ura davana umui habadaia momokani, be do lau henia umui dekenai, to gau tamona unai kekeni umui henia lau dekenai, lau adavaia totona.” ");
INSERT INTO hmo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Iakobo ena natuna ese Sekema bona iena tamana Hamoro dekenai koikoi dala dekenai idia haere henia, badina edia taihuna Sekema ese ia hadikaia dainai. ");
INSERT INTO hmo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Idia gwau, “Aiemai taihuna be usina ena kopina ia utua lasi tauna do ia adavaia diba lasi, unai be aiemai taravatu. ");
INSERT INTO hmo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Unai bamona kara ita karaia ena dala be tamona mo, umui emui tatau ibounai ese usina ena kopina utua taravatu do umui abia. ");
INSERT INTO hmo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Unai murinai aiemai kekeni do ai henia umui dekenai, idia headava, bona umui emui kekeni do umui henia ai dekenai, idia headava. Umui emui huanai do ai noho, bona bese tamona do ita halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","To bema aiemai hereva umui abia dae lasi, kopina utua taravatu umui abia lasi neganai, kekeni do ai abia, bona do ai rakatania umui.” ");
INSERT INTO hmo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamoro bona Sekema ese inai hereva idia kamonai neganai idia moale. ");
INSERT INTO hmo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekema ese edia hereva gauna ia ura karaia haraga, badina be ia ese Iakobo ena natuna kekeni ia ura henia dikadika dainai. Iena tamana ena bese edia huanai ia be tau badana momokani. ");
INSERT INTO hmo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Vadaeni Hamoro bona iena natuna Sekema idia lao hanua ena magu iduara dekenai, hanua taudia idia haboua, bona idia hereva henidia, idia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Inai taunimanima be turana karaia idia ura, inai dainai iseda tano dekenai idia noho ita danu be ia namo. Uma gabudia idia karaia, bona idia hoihoi be ia namo, badina be tano ia bada. Edia natuna kekeni do ita adavaia, bona iseda natuna kekeni do ita henia, idia adavaia. ");
INSERT INTO hmo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","To dala tamona mo dekena amo edia laloa be do ia tamona ita danu. Ita ese kopina utua kara do ita abia, idia edia kara hegeregerena. Unai murinai ita huana dekenai do idia noho, bona bese tamona do ita halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Idia edia boromakau, edia kohu, bona edia ubua gaudia be do ita abia, ani? Unai dainai ita huanai idia noho ena laloa do ita abia dae.” ");
INSERT INTO hmo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hanua taudia ibounai ese Hamoro bona Sekema edia hereva idia abia dae, bona tatau ibounai ese kopina utua kara idia abia. ");
INSERT INTO hmo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Dina toi murinai, tatau be idia hisihisi noho, kopina utua kara dainai. Unai neganai Iakobo ena natuna rua, Simeona bona Levi, Daina ena taihuna ese edia kaia idia abia, hanua dekenai idia vareai lao hunia dala dekenai, bona tatau ibounai idia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamoro bona iena natuna Sekema danu kaia dekena amo idia alaia mase. Daina danu Sekema ena ruma dekena amo idia hakaua diho, vadaeni idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Vadaeni Iakobo ena natuna tatau ma haida be idia lao, Sekema taudia idia davaria, idia mase vadaeni. Vadaeni idia ese mai bero taudia idia alaia, bona hanua ena kohu idia henaoa ore, badina be edia taihuna dekenai hemarai kara idia karaia dainai. ");
INSERT INTO hmo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Edia mamoe bona edia boromakau bona edia doniki bona edia ruma kohu bona edia aniani, uma gabudia dekenai noho gaudia bona hanua dekenai noho gaudia danu idia abia lao. ");
INSERT INTO hmo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Edia hahine mai natudia mai mauri danu idia abia. Edia kohu ibounai, bona ruma lalonai noho gau ibounai idia abia lao. ");
INSERT INTO hmo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Vadaeni Iakobo ese Simeona bona Levi dekenai ia gwau henia, ia gwau, “Lau dekenai kerere umui havaraia vadaeni, bona lauegu ladana umui hadikaia vadaeni inai tano noho taudia edia huanai. Kanana taudia bona Perisi taudia be hari lau dekenai do idia badu henia. Ita be momo lasi dainai idia be do idia haboua, do idia tuari ita dekenai, vadaeni, lau bona lauegu bese ibounai be do ita mase ore.” ");
INSERT INTO hmo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","To idia haere, idia gwau, “Be! Aiemai taihuna be sihari henia kava hahine idia halaoa be ia namo o lasi?” ");
INSERT INTO hmo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Dirava ese Iakobo dekenai ia hereva, ia gwau, “Oi toreisi, Betele dekenai oi lao, unuseni oi noho. Unuseni boubou patana ta oi karaia lau Dirava egu. Badina be oiemu kakana Esau dekena amo oi heau neganai, lau Dirava be oi dekenai lau hedinarai.” ");
INSERT INTO hmo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Unai dainai, Iakobo ese iena orea taudia ibounai dekenai ia hereva, ia gwau, “Idau dirava umui dekenai idia noho gaudia umui negea, umui sibona umui hagoevaia, dabua miro lasi umui karaia. ");
INSERT INTO hmo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ita lao Betele, unuseni lauegu kerere lalonai lau ia durua bona egu dala ibounai lau ia bamoa Diravana ena boubou patana do lau karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Vadaeni idia ese edia idau dirava bona edia taiana rini be Iakobo dekenai idia henia. Iakobo ia abidia, vadaeni Sekema kahirakahira dekenai ouki auna ta henunai ibounai ia guria. ");
INSERT INTO hmo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Iakobo mai ena natuna ese unai gabu idia rakatania neganai, unuseni noho hanua ta ta taudia ibounai idia gari bada Dirava dekenai, vadaeni idia ese Iakobo dekenai idia tuari henia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Vadaeni Iakobo mai ena orea taudia ibounai be Lusu hanua, Kanana tano dekenai idia ginidae. Lusu be Betele ena ladana ta. ");
INSERT INTO hmo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Unuseni Iakobo ese boubou patana ta ia karaia, bona gabu ena ladana ia atoa El Betele, ena anina be “Betele ena Dirava.” Badina be unai gabu dekenai Dirava ese Iakobo dekenai ia hedinarai, iena kakana dekena amo ia heau neganai. ");
INSERT INTO hmo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Unai neganai Rebeka ena hesiai hahine, ena ladana Debora, ia mase. Vadaeni Betele ena henuna kahana dekenai idia guria, ouki auna ta henunai. Unai gabu ena ladana idia atoa Alono Bakutu, ena anina be “taitai ena auna.” ");
INSERT INTO hmo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Iakobo ese Mesopotamia dekena amo ia giroa mai neganai, Dirava ese ia dekenai ia hedinarai, ia hanamoa. ");
INSERT INTO hmo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ia hamaoroa, ia gwau, “Oiemu ladana be Iakobo, to oiemu ladana do idia gwauraia lou lasi Iakobo. Harihari ia lao hanaihanai, oiemu ladana do idia gwauraia, Israela.” Unai dainai Dirava ese Iakobo ena ladana ia gwauraia Israela, ena anina be “Dirava danu ia goada helulu.” ");
INSERT INTO hmo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Vadaeni Dirava ese ia hamaoroa, ia gwau, “Lau be Siahu Ibounai Dirava. Natuna momo do oi havaraia, oiemu natuna bona tubuna be do idia momo herea. Bese momo be oi dekena amo do idia vara. Bona haida danu king dagi do idia abia. ");
INSERT INTO hmo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Aberahamo bona Isako dekenai lau henia tanona be oi danu dekenai do lau henia, bona oiemu bese oiemu murinai idia vara danu, be inai tano do lau henidia.” ");
INSERT INTO hmo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Vadaeni Dirava ese ia rakatania, bona ia hereva henia gabuna danu ia rakatania. ");
INSERT INTO hmo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Vadaeni Iakobo ese laloatao nadi ta ia haginia unai gabu dekenai. Uaina be nadi ena latanai ia bubua, iena harihari gauna Dirava dekenai, bona dehoro danu unai nadi latanai ia bubua. ");
INSERT INTO hmo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Dirava ese ia hereva henia unai gabu dekenai, vadaeni Iakobo ese gabu ena ladana ia gwauraia Betele, ena anina be “Dirava ena ruma.” ");
INSERT INTO hmo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Iakobo mai ena famili, bona iena orea taudia be Betele dekena amo idia raka lao lou, ela bona Eparata hanua ia kahirakahira. Unai neganai, Rahela be mara ena hisihisi mamina ia abia, bona iena mara be ia auka. ");
INSERT INTO hmo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Iena mara ena hisihisi ia bada herea neganai, durua henia hahine ese ia hamaoroa, ia gwau, “Oi gari lasi, mero ta do oi abia.” ");
INSERT INTO hmo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","To unai neganai ia mase, ia mase noho neganai, iena hereva dokona dekenai mero ena ladana ia atoa Benoni, anina be “Egu lalohisihisi merona.” To gabeai tamana ese mero ena ladana ia atoa Beniamina, ena anina be “Lauegu imana idibana merona.” ");
INSERT INTO hmo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Unai bamona Rahela ia mase, vadaeni Eparata ena dala badinai idia guria. Unai Eparata ena ladana ta be Betelehema. ");
INSERT INTO hmo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Iakobo ese laloatao nadi ia haginia Rahela ena guria gabu dekenai. Inai nadi, ladana be “Rahela ena laloatao nadi” be do ia noho unuseni, ia mai bona harihari danu. ");
INSERT INTO hmo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israela ma ia raka lao, kohoro ena ladana Mamoe edia Kohoro unai kahana dekenai ia kamepa. ");
INSERT INTO hmo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israela ese unai tano dekenai ia noho neganai, Rubena ese iena tamana ena adavana ta Bileha danu idia mahuta hebou. Israela ese inai sivarai ia kamonai neganai ia badu momokani. Iakobo ena natuna tatau be 12. ");
INSERT INTO hmo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea ena natuna tatau be inai: Rubena, Iakobo ena vara guna natuna, bona Simeona, Levi, Iuda, Isakara bona Sebuluno. ");
INSERT INTO hmo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahela ena natuna tatau be inai: Iosepa bona Beniamina. ");
INSERT INTO hmo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahela ena hesiai hahine Bileha ena natuna tatau be inai: Dano bona Napatali. ");
INSERT INTO hmo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea ena hesiai hahine Silipa ena natuna tatau be inai: Gado bona Asere. Inai natuna tatau be Iakobo ese ia abia Mesopotamia dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Iakobo be iena tamana Isako dekenai ia lao, Mamare dekenai. Unai gabu ena ladana ta be Kiriata Araba, ma ena ladana ta be Heberona, Aberahamo bona Isako edia noho gabuna be unai. ");
INSERT INTO hmo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isako ena mauri lagani be 180. ");
INSERT INTO hmo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Vadaeni ia mase, iena tubuna bona tamana dekenai ia haboua lao. Ia be tau buruka, iena mauri be ia daudau herea vadaeni. Iena natuna Esau bona Iakobo ese idia guria. ");
INSERT INTO hmo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esau ena natuna bona iena tubuna be inai: ");
INSERT INTO hmo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ena adavana be Kanana hahine, Ada, Hiti tauna ena ladana Elona ena natuna, bona Oholibama, Ana ena natuna, Hivi tauna ena ladana Sibeona ena tubuna, ");
INSERT INTO hmo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","bona Basemata, Isamaela ena natuna, Nebaioto ena taihuna. ");
INSERT INTO hmo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada ese mero ta ia abia, iena ladana be Elipasa, bona Basemata ese mero ta ia abia, iena ladana be Reuele, ");
INSERT INTO hmo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","bona Oholibama ese memero toi ia abia, edia ladana be Ieusu bona Ialama bona Kora. Esau ena natuna be unai, Kanana tano dekenai idia vara. ");
INSERT INTO hmo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau ese iena adavana toi, bona iena natuna tatau bona hahine, bona iena orea taudia ibounai, bona iena boromakau bona iena mamoe orea ibounai, bona Kanana dekenai ia davaria kohu ibounai, ia haboua, vadaeni iena tadina Iakobo ia rakatania, ia lao Seiri tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ia lao badina be ia bona iena tadina Iakobo ruaosi edia kohu be bada herea dainai tano be hegeregere lasi idia ruaosi bona edia boromakau bona mamoe ibounai do idia noho unai gabu tamona dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Unai dainai Esau ese ororo edia ladana Seiri dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esau ena natuna bona iena tubuna be inai: Esau be Edoma besena, Seiri ena ororo tano dekenai idia noho taudia edia tamana. ");
INSERT INTO hmo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau ena natuna tatau edia ladana be inai: Elipasa, Esau ena adavana Ada ena natuna, bona Reuele, Esau ena adavana Basemata ena natuna. ");
INSERT INTO hmo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elipasa ena natuna tatau be Temana bona Omara bona Sepo bona Gatama bona Kenasa. ");
INSERT INTO hmo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elipasa, Esau ena natuna ese hahine ma ta ena ladana Timuna ia adavaia, inai Timuna be mero ta ladana Amaleka ia abia. Inai ibounai be Esau ena adavana Ada ena tubuna. ");
INSERT INTO hmo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuele ena natuna be inai: Nahata bona Sera bona Sama bona Misa. Idia be Esau ena adavana Basemata ena tubuna. ");
INSERT INTO hmo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau ena adavana Oholibama be Ana ena natuna, Sibeona ena tubuna. Iena natuna be inai: Ieusu bona Ialama bona Kora. ");
INSERT INTO hmo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Lohia taudia Esau dekena amo idia vara edia ladana be inai: Elipasa, Esau ena vara guna natuna ese Temana bona Omara bona Sepo bona Kenasa, ");
INSERT INTO hmo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","bona Kora bona Gatama bona Amaleka ia havaraia. Inai ibounai be Edoma tano ena lohia taudia, Elipasa, Ada ena natuna ese ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau ena natuna Reuele ena natuna be inai: Nahata bona Sera bona Sama bona Misa. Idia be lohia taudia Reuele ena orea dekenai, Edoma ena tano dekenai. Idia danu be Esau ena adavana Basemata ena tubuna. ");
INSERT INTO hmo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau ena adavana Oholibama ena natuna be inai: Ieusu bona Ialama bona Kora. Inai be lohia taudia, Esau ena adavana Oholibama, Ana ena natuna ese ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Esau ena natuna be unai, idia be Edoma ena lohia taudia. ");
INSERT INTO hmo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Unai tano dekenai ia noho Hori tauna ena ladana Seiri ena natuna be inai: Lotana bona Sobala bona Sibeona bona Ana, ");
INSERT INTO hmo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","bona Disona bona Esere bona Disana. Hori lohia taudia be inai, Seiri ese ia havaradia Edoma tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotana ena natuna be Hori bona Hemana, bona Lotana ena taihuna be Timuna. ");
INSERT INTO hmo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobala ena natuna be Alavana bona Manahata bona Ebala bona Sepo bona Onama. ");
INSERT INTO hmo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeona ena natuna be Aia bona Ana. Inai Ana be ranu ia lohilohi gabudia ia davaria taunimanima idia noho lasi gabuna dekenai, iena tamana Sibeona ena doniki ia naridia neganai. ");
INSERT INTO hmo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana ena natuna be inai: Mero ta ena ladana be Disona bona kekeni ta ena ladana be Oholibama. ");
INSERT INTO hmo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disona ena natuna be Hemudana bona Esebana bona Itirana bona Kerana. ");
INSERT INTO hmo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esere ena natuna be Bilehana bona Savana bona Akana. ");
INSERT INTO hmo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disana ena natuna be Usu bona Arana. ");
INSERT INTO hmo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hori ena lohia taudia be inai: Lotana bona Sobala bona Sibeona, bona Ana, ");
INSERT INTO hmo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","bona Disona bona Esere bona Disana. Hori ena lohia taudia be unai, idia ese Seiri tanona idia naria. ");
INSERT INTO hmo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Inai king taudia ese Edoma tano idia naria, Israela taudia be king ese ia naridia lasi neganai. King edia ladana be inai: ");
INSERT INTO hmo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela Beoro be Edoma ena king, iena hanua badana ena ladana be Dinihaba. ");
INSERT INTO hmo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela ia mase neganai, Bosera tauna Sera ena natuna Iobaba ese iena gabu ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Iobaba ia mase neganai be Temana tano dekena amo ia mai tauna ena ladana Husama ese iena gabu ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husama ia mase neganai be Hadada Bedada ese iena gabu ia abia. Guna inai Hadada Bedada ese Moaba tano palaka dekenai Midiana taudia tuari dekenai ia halusidia vadaeni. Iena hanua badana ena ladana be Aviti. ");
INSERT INTO hmo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadada ia mase, vadaeni Masareka dekena amo ia mai tauna ena ladana Samula ese iena gabu ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula ia mase, vadaeni Euperate Sinavai ena hanua ta ladana Rehoboto dekena amo tauna ena ladana Saulo ese iena gabu ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saulo ia mase, vadaeni Bala Hanana, Akaboro ena natuna ese iena gabu ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bala Hanana Akaboro ia mase, vadaeni Hadada ese iena gabu ia abia. Iena hanua ena ladana be Pau, bona iena adavana ena ladana be Mehetabela. Ia be Matareda ena natuna, bona iena tubuna be Mesahaba. ");
INSERT INTO hmo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esau ena bese ena lohia taudia, ta ta ese edia iduhu idia naria, edia ladana, bona edia noho gabudia edia ladana be inai: Timuna, Alava, Ietete, ");
INSERT INTO hmo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinona, ");
INSERT INTO hmo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenasa, Temana, Mibisara, ");
INSERT INTO hmo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidiela bona Irama. Edoma ena lohia taudia be unai, ta ta ese ena hanua ena hanua dekenai idia lohia. To Edoma ia havaraia tauna be Esau. ");
INSERT INTO hmo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Iakobo ese guna iena tamana ia noho gabuna dekenai ma ia noho, Kanana tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iakobo ena natuna edia sivarai be inai: Iosepa ena mauri lagani be 17 neganai, ia bona iena kakana taudia ese mamoe bona nani idia naria. Inai kakana taudia be iena tamana ena adavana Bileha bona Silipa edia natudia. Vadaeni Iosepa ia lao iena tamana dekenai, iena kakana taudia totona ia samania karaia, badina idia ese kara dika haida idia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israela ese inai Iosepa dekenai ia lalokau henia bada, badina ia be tau buruka neganai ia havaraia, to iena natuna haida dekenai ia lalokau henia maragi, vadaeni Israela ese kouti dabua latana, namona momokani, mai ena imana lata danu ia karaia, Iosepa dekenai ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Iena kakana taudia idia itaia, edia tamana be Iosepa dekenai ia lalokau henia bada, idia dekenai ia lalokau henia maragi. Vadaeni, idia badu henia Iosepa dekenai, hereva namona ta idia gwauraia lasi ia dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Inai Iosepa be ia nihi, iena nihi be iena kakana taudia dekenai ia hamaoroa. Unai dainai idia badu dikadika ia dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ia hamaoroa idia dekenai, ia gwau, “Lauegu nihi mani lau hamaoroa umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Lauegu nihi be inai bamona: Ita be uma dekenai uiti ita guia. Vadaeni lauegu uiti be ia toreisi, to umui emui uiti be idia gini hagegea lauegu uiti dekenai. Vadaeni emui uiti idia tomadiho henia lauegu uiti dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Vadaeni iena kakana taudia ese idia gwau henia ia dekenai, idia gwau, “Oi be aiemai king do oi lao, a? Oi ese do oi lohia ai dekenai, a?” Vadaeni iena nihi bona iena hereva dekenai idia edia badu idia habadaia noho ia dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ma ia nihi lou, iena nihi be iena kakana taudia dekenai ia hamaoroa, ia gwau, “Lau nihi lou vadaeni. Lauegu nihi dekenai be dina bona hua, bona hisiu 11 idia toma diho henia lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Iosepa ese unai nihi be iena tamana bona iena tadikakana taudia dekenai danu ia hamaoroa. Vadaeni iena tamana ese Iosepa dekenai ia hereva mai badu danu, ia gwau, “Oiemu nihi ena anina be dahaka? Lau bona oiemu sinana bona oiemu tadikakana do ai tomadiho henia oi dekenai, a?” ");
INSERT INTO hmo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Vadaeni iena kakana taudia be idia badu dikadika mai mama danu, to iena tamana ese Iosepa ena nihi ia laloa noho. ");
INSERT INTO hmo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Dina ta Iosepa ena kakana taudia be Sekema dekenai idia lao, edia tamana ena mamoe naria totona. ");
INSERT INTO hmo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Vadaeni iena tamana Israela ia hereva Iosepa dekenai, ia gwau, “Oiemu kakana taudia be Sekema dekenai mamoe idia naria, ani? Oi mai, oi do lau siaia idia dekenai.” Iosepa ia haere, ia gwau, “Lau hegaegae inai.” ");
INSERT INTO hmo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Iena tamana ese ma ia hamaoroa, ia gwau, “Vadaeni oi lao. Oi itadia, oiemu kakana taudia be idia namo o lasi, bona mamoe danu be edena bamona. Unai murinai oi giroa mai, oi hadibaia lau.” Vadaeni ia siaia, Heberona ena koura dekena amo ia lao, Sekema dekenai ia ginidae. ");
INSERT INTO hmo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Vadaeni tau ta ese Iosepa ia itaia, tano palaka dekenai ia loaloa noho, vadaeni ia nanadaia, ia gwau, “Dahaka oi tahua?” ");
INSERT INTO hmo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iosepa ia haere, ia gwau, “Lauegu kakana taudia lau tahua. Mani emu kara, oi hadibaia lau, idia be edeseni mamoe idia naria noho.” ");
INSERT INTO hmo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Unai tau ia gwau, “Inai gabu idia rakatania vadaeni. Badina idia hereva lau kamonai, idia gwau, ‘Ita lao Dotana dekenai.’ ” Unai dainai Iosepa be idia edia murina dekenai ia lao, Dotana dekenai idia ia davaria. ");
INSERT INTO hmo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","To ia be sisina daudau dekenai idia itaia, ia do mai kahirakahira lasi neganai, idia herevahereva, idia gwau, “Dohore ita alaia mase.” ");
INSERT INTO hmo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Idia sibona idia herevahereva, idia gwau, “Itaia, unai nihi tauna ia mai inai. ");
INSERT INTO hmo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ita alaia mase, inai guri ta, ranu ia noho lasi gauna dekenai do ita negea diho. Vadaeni, dohore ita gwau, ‘Dagedage gauna ta ese ia alaia mase.’ Unai dekena amo dohore ita itaia, iena nihi ena anina be dahaka.” ");
INSERT INTO hmo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","To Rubena ese unai hereva ia kamonai, vadaeni ia ese idia edia imana dekena amo Iosepa ia hamauria gwauraia, ia gwau, “Lasi. Iena mauri ita kokia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ita alaia mase lasi. Inai guri dekenai, taunimanima lasi gabuna dekenai do ita negea diho, to do ita hisihisi henia lasi.” Unai bamona ia hereva, badina iena laloa be idia edia imana dekena amo do ia hamauria, iena tamana dekenai do ia henia lou gwauraia. ");
INSERT INTO hmo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Vadaeni, Iosepa be iena kakana taudia dekenai ia ginidae neganai, idia dogoatao, iena kouti dabua latana mai imana lata danu idia kokia. ");
INSERT INTO hmo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Idia ese Iosepa idia abia lao, guri ta dekenai idia negea diho, unai guri dekenai be ranu ia noho lasi. ");
INSERT INTO hmo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Vadaeni idia helai diho, idia aniani. Edia matana idia negea, laolao taudia haida idia itaia, idia be Isamaela taudia Gileada dekena amo idia mai, Aigupito dekenai idia lao gwauraia, edia kamelo be aniani edia muramura, bona muramura mai bonana namo idia huaia. ");
INSERT INTO hmo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Vadaeni Iuda ese iena tadikakana taudia ia hamaorodia, ia gwau, “Iseda tadina do ita alaia, bona iena mase do ita hunia, ena anina be dahaka? ");
INSERT INTO hmo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Namo inai Isamaela taudia dekenai do ita hoia, iseda imana dekenai ita hadikaia lasi, badina ia be iseda tadina momokani, iseda hidiona bona iseda rarana.” Vadaeni iena tadikaka taudia ese, iena hereva idia abia dae. ");
INSERT INTO hmo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Inai hoihoi taudia be Midiana dekena amo idia raka hanaia, vadaeni Iosepa be iena kakana taudia ese guri dekena amo idia veria daekau. Isamaela taudia dekenai idia hoia, iena davana be siliva moni 20. Vadaeni Isamaela taudia ese Iosepa idia abia lao Aigupito dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubena ia giroa lou guri dekenai, to Iosepa be ia noho lasi. Vadaeni iena dabua ia darea, iena lalohisihisi toana unai. ");
INSERT INTO hmo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Iena tadina taudia dekenai ia giroa lou, ia gwau, “Mero be ia noho lasi! Edena bamona dohore lau karaia?” ");
INSERT INTO hmo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Vadaeni idia ese Iosepa ena kouti dabua latana idia abia, nani ena natuna ta idia alaia, nani ena rarana dekena amo kouti dabua idia hamiroa. ");
INSERT INTO hmo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Vadaeni inai kouti dabua idia abia lao edia tamana dekenai, idia gwau, “Inai be ai ese ai davaria. Oi itaia inai be oiemu natuna ena kouti dabua, a?” ");
INSERT INTO hmo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ia itaia neganai ia gwau, “Inai be lauegu natuna ena kouti dabua. Uda boroma ta ese ia koria mase vadaeni. Momokani, Iosepa ia mase vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Vadaeni Iakobo ese iena dabua ia darea, dabua korema ia kwatua, iena lalohisihisi toana unai. Iena natuna totona dina bona hanuaboi ia taitai ia lao dina momo. ");
INSERT INTO hmo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Vadaeni iena natuna tatau bona hahine ibounai idia lao ia dekenai, iena lalona idia hanamoa totona. To ia ura lasi iena lalona do idia hanamoa, vadaeni ia tai mai boiboi danu, ia gwau, “Lasi. Lauegu natuna dekenai mase gabuna dekenai dohore lau lao, mai tai danu.” Ia taitai noho unai bamona, iena natuna totona. ");
INSERT INTO hmo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Inai Midiana taudia ese Iosepa idia hoia Aigupito dekenai, tau ta ladana Potifara dekenai. Potifara be Aigupito ena king Farao, ena tuari oreana ena biaguna ta. ");
INSERT INTO hmo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Unai neganai Iuda ese iena tadikaka taudia ia rakatania, ia lao, Adulama tauna ta ena ladana Hira danu ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Unuseni Iuda ese Kanana tauna ta ladana Sua ena natuna kekeni ia itaia, ia adavaia, vadaeni idia mahuta hebou. ");
INSERT INTO hmo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Unai hahine ia rogorogo, ia mara, mero ta ia abia, iena ladana ia atoa Ere. ");
INSERT INTO hmo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ma ia rogorogo lou, natuna ta ia abia, iena ladana ia atoa Onana. ");
INSERT INTO hmo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ma mero ta ia abia, iena ladana ia atoa Sela. Unai mero ia vara neganai, Iuda be Kesiba dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Iuda ese iena vara guna natuna Ere dekenai adavana ta ia henia, iena ladana be Tamara. ");
INSERT INTO hmo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","To inai Ere be Lohiabada ena vairana dekenai kara dika momokani ia karaia, vadaeni Lohiabada ese ia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Vadaeni Iuda ese Onana dekenai ia hamaoroa, ia gwau, “Oi be iena nakimi dainai, iseda kara hegeregerena, vabu dekenai oi sihari henia, natuna ta oi havaraia, oiemu kakana mase tauna ena.” ");
INSERT INTO hmo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","To Onana be ia diba mero do ia havaraia neganai, be iena natuna momokani lasi. Unai dainai ia sihari henia neganai, iena vesina be tano dekenai ia habubua kava, kakana ena natuna do ia havaraia lasi totona. ");
INSERT INTO hmo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Unai kara dikana dainai Lohiabada ia badu, vadaeni Onana danu ia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Vadaeni Iuda ese iena ravana Tamara dekenai ia hamaoroa, ia gwau, “Do oi giroa lou oiemu tamana ena ruma dekenai, do oi noho kava, adavana lasi, ia lao bona lauegu natuna Sela ia bada.” To iena laloa korikori be Sela danu do ia mase garina, iena kakana ruaosi hegeregere. Unai dainai Tamara be ia giroa lou, iena tamana ena ruma dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Nega sisina murinai Iuda ena adavana, Sua ena natuna, ia mase. Vadaeni Iuda ena lalohisihisi ia ore murinai ia toreisi, ia lao Timuna dekenai, iena mamoe edia huina ia utua gabuna unai. Iena turana ena ladana Hira, Adulama tauna, be ia danu idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamara ia kamonai iena ravana be Timuna dekenai ia lao, iena mamoe edia huina utua totona. ");
INSERT INTO hmo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Vadaeni ia ese iena vabu dabua ia kokia, ma dabua ta dekena amo iena vairana ia koua, Timuna dala badibadinai ia helai, Enaimi hanua ena ranu guri rua ena vareai gabuna dekenai. Badina be ia diba Sela be ia bada vadaeni, to iena ravana ese iena headava dalana ia kehoa lasi. ");
INSERT INTO hmo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Vadaeni Iuda ese ia itaia neganai, ia laloa inai hahine be ariara hahine, badina iena vairana ia koua dainai. ");
INSERT INTO hmo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Vadaeni ia ese hahine dekenai ia hereva, ia gwau, “Mani ita mahuta gabu tamona dekenai.” Ia diba lasi hahine be iena ravana. Hahine ia gwau, “Davana be dahaka do oi henia lau dekenai?” ");
INSERT INTO hmo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ia gwau, “Nani ena natuna ta oi do lau henia.” Hahine ia gwau, “Ia namo, to ena toana be dahaka harihari do oi henia ia lao bona nani do oi siaia mai?” ");
INSERT INTO hmo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ma Iuda ese ia nanadaia, ia gwau, “Toana be dahaka gau oi dekenai do lau henia?” Ia haere, “Oiemu ageva, ladana torea gauna, mai varo danu, bona oiemu itotohi.” Ia henia, vadaeni ruaosi idia mahuta gabu tamona dekenai, vadaeni hahine ia rogorogo. ");
INSERT INTO hmo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Vadaeni Tamara ia toreisi, ia lao. Iena vairana koua dabua ia kokia, iena vabu dabua ma ia karaia lou. ");
INSERT INTO hmo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Iuda ese iena turana Adulama tauna ia siaia, nani natuna be unai hahine dekenai do ia henia, bona toa gaudia do ia abia lou totona. To hahine be ia davaria lasi. ");
INSERT INTO hmo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Vadaeni ia ese unai gabu taudia dekenai ia nanadaia, ia gwau, “Inai ariara hahine, Enaimi hanua vareai gabuna ena dala badibadina dekenai ia helai be edeseni?” Idia gwau, “Ariara hahine ta be lasi iniseni.” ");
INSERT INTO hmo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Unai dainai Adulama tauna be Iuda dekenai ia giroa lou, ia gwau, “Lau davaria lasi, bona unai gabu taudia idia gwau ariara hahine ta be lasi unai gabu dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Vadaeni Iuda ia gwau, “Lauegu gau ia dekenai do idia noho, do ita hemarai garina. Lau be nani natuna lau siaia, to hahine be oi davaria lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Hua toi ia ore murinai, vadaeni Iuda ese hereva ia kamonai iena ravana be mai bogana. Vadaeni ia gwau, “Murimuri dekenai umui hakaua, vadaeni umui alaia mase.” ");
INSERT INTO hmo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Idia hakaua murimuri dekenai, vadaeni Tamara ese hereva ia siaia Iuda dekenai, ia gwau, “Inai gau edia biaguna dekena amo lau rogorogo, mani oi hereva, inai ageva, ladana torea gauna, mai varo danu, bona inai itotohi be daika ena?” ");
INSERT INTO hmo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Vadaeni Iuda ena lalona ia kehoa, ia gwau, “Ia be maoro, lau be kerere lau karaia vadaeni, badina be lauegu natuna Sela lau henia lasi, ia adavaia totona.” Vadaeni Iuda bona Tamara idia mahuta hebou lou lasi. ");
INSERT INTO hmo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamara ena mara negana be kahirakahira neganai, ia diba vadaeni iena bogana lalonai be natuna rua idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Vadaeni ia mara neganai, mero ta ese iena imana ia atoa murimuri dekenai, vadaeni durua henia hahine ese varo kakakaka ta mero ena imana dekenai ia kwatua, ia gwau, “Vara guna be inai.” ");
INSERT INTO hmo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","To mero be iena imana ia veria vareai, vadaeni iena tadina ia vara guna. Durua henia hahine be ia gwau, “Oi be inai bamona oiemu dala oi kehoa?” Vadaeni iena ladana ia atoa Perese, anina be “dala kehoa.” ");
INSERT INTO hmo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Gabeai iena kakana ia vara, mai varo kakakaka danu iena imana dekenai, iena ladana idia atoa Sera, ena anina be “daekau.” ");
INSERT INTO hmo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Iosepa be Aigupito dekenai idia abia lao. Unuseni Aigupito ena lohia tauna ta, ena ladana Potifara ese Iosepa ia hoia Isamaela taudia dekena amo. Potifara be king Farao ena ruma gimaia taudia edia kapena. ");
INSERT INTO hmo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Lohiabada ese Iosepa ia naria noho, unai dainai Iosepa dekenai idia vara gaudia ibounai be namo. Ia ese iena biaguna Aigupito tauna ena ruma dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Vadaeni iena biaguna ese ia itaia, Lohiabada ese durua ia henia noho Iosepa dekenai, bona iena kara ibounai dekenai anina danu ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifara ese iena hesiai gaukara ibounai danu ia itaia, ia namo herea. Vadaeni ia ese Iosepa iena ruma naria tauna ia halaoa, iena kohu ibounai naria totona. ");
INSERT INTO hmo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Vadaeni ruma bona kohu ibounai naria tauna ia halaoa ena dina dekena amo, Lohiabada ese unai Aigupito tauna ia hanamoa Iosepa dainai. Lohiabada ena hanamoa be iena ruma latanai, bona iena uma latanai ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifara ese iena kohu ibounai Iosepa ena imana dekenai ia atodia, gau ta dekenai ia laloa lasi, iena aniani iena vairana dekenai idia atoa, unai sibona mo. Iosepa ena tauanina ia goada, bona iena vairana ena toana, be mero namo herea momokani. ");
INSERT INTO hmo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Nega ta iena biaguna ena adavana ese ia ura henia dikadika, vadaeni ia hamaoroa, ia gwau, “Ita mahuta gabu tamona dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","To Iosepa be ia ura lasi, ia haere henia, ia gwau, “Oi itaia vadaeni, egu biaguna be egu gaukara inai ruma dekenai ia naria noho lasi, iena kohu ibounai lauegu imana dekenai ia atoa vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Tau ta ese lau ia hereaia lasi inai ruma dekenai, lau dekenai gau ta ia dogoatao lasi, oi sibona mo ia dogoatao, badina oi be iena adavana. Inai kerere badana do lau karaia, bona Dirava ena vairana dekenai inai bamona do lau kara dika be edena bamona?” ");
INSERT INTO hmo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","To hahine be dina ta ta dekena amo Iosepa ena lalona ia ania, gabu tamona dekenai idia mahuta totona, to Iosepa be ia kamonai henia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","To dina ta hahine ia raka vareai ruma lalona dekenai, ruma lalonai be tau ta ia noho lasi. ");
INSERT INTO hmo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Vadaeni hahine ese Iosepa ena dabua dekenai ia dogoatao, ia veria, ia gwau, “Oi mai, gabu tamona dekenai ita mahuta.” To Iosepa ese dabua ia rakatania hahine ena imana dekenai, ruma dekena amo ia heau murimuri dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Hahine ese ia itaia be Iosepa ena dabua ia rakatania iena imana dekenai, vadaeni ia heau ruma murimuri dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Ia ese ruma taudia ia boiridia, ia hamaorodia, ia gwau, “Umui itaia, lauegu adavana ese inai Heberu tauna ia abia dae vadaeni, ita dekenai kavakava henia totona. Ia raka vareai lau dekenai, ia ura ai mahuta gabu tamona dekenai, vadaeni lau boiboi bada herea. ");
INSERT INTO hmo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Lauegu boiboi ia kamonai neganai, iena dabua be lauegu imana dekenai ia rakatania, ia heau murimuri dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Hahine ese inai dabua ia dogoatao noho, ela bona Iosepa ena biaguna ia mai. ");
INSERT INTO hmo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Vadaeni inai sivarai ia hamaoroa, ia gwau, “Inai Heberu tauna oi abia dae iseda ruma dekenai iseda gaukara ibounai durua henia totona, to ia raka vareai, lau dekenai kavakava henia gwauraia. ");
INSERT INTO hmo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Vadaeni lau boiboi bada herea neganai, iena dabua ia rakatania lau dekenai, ia heau murimuri dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Iosepa ena biaguna tauna ese iena adavana ena hereva ia kamonai, “Unai Heberu hesiai tauna be inai bamona lau dekenai ia karaia.” Vadaeni ia badu dikadika. ");
INSERT INTO hmo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Unai neganai Iosepa ena biaguna ese Iosepa ia dogoatao, dibura ruma dekenai ia koua, king ena dibura taudia idia koua gabuna dekenai. Vadaeni unuseni ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Lohiabada ese Iosepa dekenai ia itaia noho, ia bogahisihisi henia, unai dainai dibura ruma naria tauna be Iosepa dekenai ia moale. ");
INSERT INTO hmo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Vadaeni dibura ruma naria tauna ese dibura taudia ibounai Iosepa ena henuna dekenai ia atodia, dibura gaukara ibounai Iosepa ese ia naria. ");
INSERT INTO hmo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Dibura ruma naria tauna be gau ta ia laloa lasi, Iosepa ena gaukara dekenai. Badina be Lohiabada ese Iosepa ia itaia noho, bona iena gaukara ibounai dekenai anina ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Unai murinai, uaina idia bubua memero ia naridia tauna, bona paraoa idia gabua memero ia naridia tauna, idia ruaosi ese Farao idia habadua. ");
INSERT INTO hmo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Vadaeni Farao ese inai uaina bubua memero bona paraoa gabua memero idia naria taudia ruaosi ia badu henidia. ");
INSERT INTO hmo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Dibura ruma dekenai ia koudia, gima taudia edia kapena ena ruma dekenai, Iosepa ia noho gabunai. ");
INSERT INTO hmo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Vadaeni, dibura gimaia taudia edia kapena ese Iosepa ia hamaoroa, do ia naridia. Iosepa ese idia ruaosi ia naridia, idia be nega sisina daudau dibura ruma dekenai idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Unai tatau ruaosi be hanuaboi tamona dekenai idia nihi, unai dibura ruma lalonai. Farao ena uaina bubua memero ia naridia tauna, bona iena paraoa gabua memero ia naridia tauna be idia nihi, nihi ta ta be mai ena anina ta ta. ");
INSERT INTO hmo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Daba ia rere, Iosepa ia raka vareai idia ruaosi dekenai, vadaeni edia toana ia itaia be idia lalohisihisi. ");
INSERT INTO hmo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Unai dainai ia ese idia dekenai ia henanadaia, ia gwau, “Badina dahaka hari dina umui emui lalona ia hisihisi?” ");
INSERT INTO hmo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Idia gwau, “Ai be ai nihi vadaeni, to tau ta lasi ese aiemai nihi edia anina do ia hedinaraia.” Vadaeni Iosepa ia gwau, “Nihi ena anina hedinaraia be Dirava mo sibona. Umui emui nihi mani umui gwauraia lau dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Vadaeni uaina bubua memero ia naridia tauna ese iena nihi Iosepa dekenai ia hedinaraia, ia gwau, “Egu nihi dekenai be vain au ta lau itaia. ");
INSERT INTO hmo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ena rigi be toi, inai rigi dekenai rau idia tubu, herahera ia vara, vadaeni vain ena huahua ia atoa, idia mage. ");
INSERT INTO hmo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Farao ena kapusi be lauegu imana dekenai, vadaeni vain ena huahua lau abidia, lau gigia, ranuna be Farao ena kapusi dekenai ia diho, vadaeni kapusi be Farao ena imana dekenai lau atoa.” ");
INSERT INTO hmo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Bona Iosepa ia gwau, “Oiemu nihi ena anina be inai: Vain ena rigi toi be dina toi. ");
INSERT INTO hmo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dina toi do idia ore, vadaeni Farao ese do ia abia dae oi, oiemu dagi do ia henia lou oi dekenai, vadaeni Farao ena kapusi be iena imana dekenai do oi atoa, guna iena uaina bubua memero oi naridia neganai bamona. ");
INSERT INTO hmo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Oiemu dala do ia namo neganai do oi laloa lau dekenai, ani? Oi bogahisihisi lau dekenai. Mani emu kara Farao dekenai do oi hereva lau totona, bona inai dibura ruma dekena amo lau do oi hakaua murimuri dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Badina be momokani lau be Heberu taudia edia tano dekena amo lau idia henaoa lao, iniseni dekenai danu kerere ta lau karaia lasi, to dibura ruma dekenai lau idia koua kava.” ");
INSERT INTO hmo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Paraoa gabua memero ia naridia tauna ia diba vadaeni inai nihi ena anina be ia namo. Vadaeni Iosepa ia hamaoroa, ia gwau, “Lau danu lau nihi, lauegu nihi dekenai be paraoa bosea toi egu kwarana dekenai lau atodia, lau huaia loaloa. ");
INSERT INTO hmo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Vadaeni bosea ataiai ena lalonai be paraoa idia gabua gaudia idauidau idia noho, Farao ena. To manu haida idia roho mai, idia ania.” ");
INSERT INTO hmo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Bona Iosepa ia gwau, “Oiemu nihi ena anina be inai: Bosea toi be dina toi. ");
INSERT INTO hmo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dina toi do idia ore, vadaeni Farao ena dibura ruma dekena amo oi do ia abia lao, oiemu kwarana do idia utua oho, bona au ta dekenai oiemu tauanina do idia taua dae. Vadaeni manu do idia roho mai, oiemu hidiona do idia ania.” ");
INSERT INTO hmo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Dina toi murinai be Farao ia vara dinana. Vadaeni ia ese aria ta ia karaia, ia dekenai durua henia taudia ibounai ia boiridia, inai uaina bubua memero ia naridia tauna bona paraoa gabua memero ia naridia tauna danu ia boiridia. ");
INSERT INTO hmo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Vadaeni uaina bubua memero ia naridia tauna ena dagi ia henia lou, ia ese kapusi Farao ena imana dekenai ma ia atoa. ");
INSERT INTO hmo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","To paraoa idia gabua memero ia naridia tauna be au dekenai iena tauanina ia taua dae ela bona ia mase, Iosepa ese nihi anina ia gwauraia hegeregere. ");
INSERT INTO hmo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","To inai uaina bubua memero ia naridia tauna ese Iosepa ia laloatao lasi, ia laloaboio. ");
INSERT INTO hmo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Lagani rua idia ore, vadaeni Farao ia nihi. Iena nihi dekenai ia ese Naila Sinavai ena badibadinai ia gini. ");
INSERT INTO hmo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Vadaeni boromakau 7 sinavai dekena amo idia daekau, edia tauanina be namo, bona mai digara danu, sinavai badibadina dekenai rei idia aniani noho. ");
INSERT INTO hmo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Unai murinai idau boromakau 7 sinavai dekena amo ma idia daekau, edia tauanina be dika bona mai digara lasi. Inai boromakau mai digara danu edia badibadina dekenai idia gini. ");
INSERT INTO hmo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Vadaeni inai boromakau 7 mai digara lasi ese boromakau 7 mai digara danu idia anidia ore. Vadaeni Farao ia noga. ");
INSERT INTO hmo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ia mahuta lou, ia nihi. Iena nihi iharuana dekenai be uiti tamona ia tubu daekau dekena amo, iena anidia be 7 idia tubu, ia itaia inai uiti ena anidia be idia namo, bona idia bada. ");
INSERT INTO hmo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Idia edia murinai uiti ma ta ia tubu daekau dekena amo, iena anidia ma 7 idia tubu. Inai uiti ena anidia be idia dika, bona idia maragi. Dina ia daekau ena kahana dekena amo lai ia mai neganai, idia kakoro. ");
INSERT INTO hmo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Vadaeni inai uiti ena anidia dikadia ese uiti ena anidia namodia idia anidia ore. Bona Farao ia noga, ia diba inai be nihi sibona. ");
INSERT INTO hmo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Daba ia rere, iena kudouna ia gari dikadika. Vadaeni iena hereva ia siaia lao, Aigupito dekenai puripuri taudia ibounai bona aonega taudia ibounai ia boiridia. Vadaeni Farao ese iena nihi idia dekenai ia hamaoroa, to idia ibounai be nihi edia anina idia gwauraia diba lasi. ");
INSERT INTO hmo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Vadaeni uaina idia bubua memero ia naridia tauna ese Farao ia hamaoroa, ia gwau, “Lauegu kerere harihari lau laloa. ");
INSERT INTO hmo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Oi ese oiemu hesiai taudia oi badu henidia neganai be lau, bona paraoa idia gabua memero naridia tauna, ai ruaosi dibura ruma lalonai oi atoa, gima taudia edia kapena ena imana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Vadaeni hanuaboi neganai, ai ruaosi ai nihi, aiemai nihi be ta ta mai edia anina. ");
INSERT INTO hmo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Uhau tauna ta ia noho ai dekenai, ia be Heberu tauna, gima taudia edia kapena ena durua merona. Vadaeni ai ruaosi aiemai nihi ia dekenai ai hamaoroa, vadaeni ia ese aiemai nihi edia anina ai ta ta dekenai ia hadibaia. ");
INSERT INTO hmo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Nihi edia anina ia ese ia gwauraia, idia momokani vadaeni. Lau be oi ese oi atoa lou lauegu dagi dekenai, to lauegu turana be au dekenai idia taua dae, ela bona ia mase.” ");
INSERT INTO hmo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Vadaeni Farao ese mero ta ia siaia, Iosepa ia boiria, dibura ruma dekena amo idia hakaua haragaharaga murimuri dekenai, iena aukina huina ia utua, bona dabua ia senisia, vadaeni Farao dekenai ia raka vareai. ");
INSERT INTO hmo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Vadaeni Farao ia hereva Iosepa dekenai, ia gwau, “Lau nihi vadaeni, to nihi ena anina hedinaraia tauna be lasi, to oiemu sivarai lau kamonai vadaeni, nihi edia anina hedinaraia be oi diba.” ");
INSERT INTO hmo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Iosepa ese Farao dekenai ia haere henia, ia gwau, “Lau be lasi, to Dirava ese Farao dekenai do ia haere henia, maino herevana dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Vadaeni Farao ese Iosepa ia hamaoroa, ia gwau, “Lauegu nihi dekenai Naila Sinavai ena badibadinai lau gini. ");
INSERT INTO hmo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Vadaeni boromakau 7 be sinavai dekena amo idia daekau, edia tauanina be namo, bona mai digara danu. Vadaeni sinavai ena badibadina dekenai rei idia aniani noho. ");
INSERT INTO hmo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Gabeai idau boromakau 7 ma idia daekau, edia tauanina be dika, bona mai digara lasi, Aigupito ena tano ibounai dekenai boromakau dikadia inai bamona nega ta lau itaia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Vadaeni boromakau dikadia, tauanina maragi gaudia ese boromakau namodia mai digara danu, idia ania ore. ");
INSERT INTO hmo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","To idia anidia ore murinai, tau ta do ia diba lasi idia anidia vadaeni. Badina be idia edia tauanina do idia digara lasi noho. Vadaeni lau noga. ");
INSERT INTO hmo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ma lauegu nihi ta dekenai lau itaia, uiti tamona ia tubu daekau mai ena anina 7, idia bada bona idia namo. ");
INSERT INTO hmo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Gabeai ta ma ia tubu daekau mai ena anina 7, idia dika bona idia maragi, bona dina ia daekau ena kahana dekena amo lai ia mai neganai idia kakoro. ");
INSERT INTO hmo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Vadaeni uiti dikadia ese uiti namodia idia anidia ore. Puripuri taudia dekenai lau hamaoroa, to nihi edia anina hedinaraia dekenai be tau ta ia diba lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Iosepa ese Farao ia hamaoroa, ia gwau, “Inai nihi ruaosi edia anina be tamona sibona, Dirava ia ura iena kara ta do ia karaia gwauraia. Vadaeni guna oi dekenai ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Boromakau namodia 7 be lagani 7, bona uiti ena anidia namodia 7 be lagani 7. Nihi edia anina be tamona sibona. ");
INSERT INTO hmo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Boromakau dikadia mai digara lasi 7, gabeai idia daekau gaudia, be lagani 7, bona uiti ena anidia dikadia 7 lai ese ia hakakoroa gaudia be lagani 7. Inai be hitolo do ia vara laganidia. ");
INSERT INTO hmo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Farao e, hari oi dekenai lau hamaoroa hegeregerena, Dirava ia ura iena kara ta do ia karaia gwauraia. Vadaeni oi dekenai ia hamaoroa guna. ");
INSERT INTO hmo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Lagani 7 do idia mai, Aigupito ena tano ibounai dekenai aniani momo do idia vara. ");
INSERT INTO hmo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Gabeai hitolo ena lagani 7 do idia mai, Aigupito ena tano dekenai aniani momo ena nega do idia laloaboio, badina be hitolo do ia bada herea, bona tano be do ia hadikaia momokani. ");
INSERT INTO hmo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Taunimanima edia laloa dekenai, aniani momo ena nega do idia laloaboio momokani, badina be hitolo bada negana ia mai neganai, be do ia dika momokani. ");
INSERT INTO hmo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Oi be nega rua oi nihi, badina be Dirava ese inai kara do ia karaia momokani, bona nega do ia daudau lasi, Dirava ese do ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Namona be inai, oi ese diba momo bona aonega tauna ta do oi tahua, vadaeni Aigupito ena tano ibounai ena biaguna do oi halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ma oi ese inai bamona do oi karaia: Tano naria opesa taudia danu do oi abia hidi. Idia ese aniani momo ena lagani 7 lalonai, aniani ibounai inai Aigupito tano dekenai do idia haria karaia, kahana be 5. Vadaeni kahana ta be gavamani ese do ia abia, takisi hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Inai aniani momo ena lagani lalonai, oi ese inai opesa taudia do oi oda henidia, aniani ibounai do idia haboua, bona idia be oiemu siahu henunai do idia gaukara. Hanua badadia ibounai dekenai inai aniani do idia haboua namonamo, bona naria namonamo. ");
INSERT INTO hmo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Unai aniani be sitoa dekenai do ia noho, ia lao bona hitolo ena lagani 7 Aigupito dekenai do idia mai. Vadaeni inai tano dekenai taunimanima ibounai be do idia mase lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farao mai ena durua taudia ese unai hereva idia abia dae. ");
INSERT INTO hmo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Vadaeni Farao ese iena durua taudia dekenai ia hereva, ia gwau, “Edeseni tau ta dohore ita davaria inai tau bamona. Dirava ena Lauma be iena lalona dekenai, ani?” ");
INSERT INTO hmo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Vadaeni Farao ese Iosepa dekenai ia hereva, ia gwau, “Dirava ese inai dala ibounai oi dekenai ia hedinaraia vadaeni, bona tau ta lasi mai ena diba bona mai ena aonega oi hegeregere. ");
INSERT INTO hmo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Unai dainai oi be lauegu tanobada dekenai dohore oi lohia, lauegu basileia ena taunimanima ibounai ese dohore idia kamonai henia oiemu hereva dekenai, lau sibona mo, inai tanobada ena king, ese do lau hereaia oi.” ");
INSERT INTO hmo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Farao ia hereva lou Iosepa dekenai, ia gwau, “Oi kamonai, oi be Aigupito ena tano ibounai ena lohia harihari lau atoa vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Farao be mai ena rini, king ena dagi toana gauna. Ia ese iena imana kwakikwakina dekena amo inai rini ia kokia, Iosepa ena imana kwakikwakina dekenai ia atoa, bona dabua namo herea danu ia dekenai ia atoa. Golo dekena amo karaia ageva danu Iosepa ena aiona dekenai ia atoa. ");
INSERT INTO hmo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Oda ia gwauraia danu, kariota iharuana Farao ena kariota murina dekenai ia heau gauna, ena latanai Iosepa do ia guia. Haida be iena vairana dekenai idia heau, vadaeni idia boiboi, idia gwau, “Dala umui kehoa.” Inai bamona dekenai Iosepa ese Aigupito tano ibounai ena lohia dagi ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farao ese Iosepa ia hamaoroa, ia gwau, “Lau inai Farao, bema oi hereva lasi neganai, tau ta ese gaukara ta do ia karaia diba lasi inai Aigupito ena tano ibounai dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao ese Iosepa ena ladana ia gwauraia, Sepenata Panea. Asenate danu ia henia, ia adavaia totona. Unai Asenate be Onu ena dubu helaga tauna, iena ladana Potifera, ena natuna. Vadaeni Iosepa be Aigupito ena tano ibounai dekenai ia itaia loaloa. ");
INSERT INTO hmo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Iosepa ena mauri lagani ibounai be 30, Farao, Aigupito ena king ena hesiai gaukara ia hamatamaia neganai. Vadaeni Iosepa ese Farao ia rakatania, Aigupito ena tano ibounai dekenai ia itaia loaloa. ");
INSERT INTO hmo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Aniani momo ena lagani 7 lalonai uma dekenai aniani be ia bada herea momokani. ");
INSERT INTO hmo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Unai aniani momo Aigupito tano dekenai ia vara lagani 7 lalonai, Iosepa ese aniani ibounai ia haboua. Hanua ta ta edia uma dekenai aniani ibounai be unai hanua ta ta edia sitoa dekenai ia haboudia. ");
INSERT INTO hmo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Iosepa ese uiti momo herea ia haboua, kone miri bamona, laloa bona duahia ena dala idia hadokoa, badina duahia ena dala be lasi. ");
INSERT INTO hmo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Hitolo ena nega do ia mai lasi neganai, Iosepa ena natuna memero rua idia vara, Asenate, Onu ena dubu helaga tauna Potifera ena natuna ena bogana dekena amo. ");
INSERT INTO hmo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ia vara guna mero be Iosepa ese iena ladana ia atoa Manase, ena anina be “Laloaboio”. Ia gwau, “Dirava ese lauegu hekwarahi bona lauegu tamana, bona lauegu varavara laloa be ia kokia vadaeni lau dekena amo.” ");
INSERT INTO hmo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Gabeai ia vara mero ena ladana ia atoa Eparaima, ena anina be “Natuna Henia”. Ia gwau, “Hisihisi lau abia tanona dekenai Dirava ese lauegu natuna ia henia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Aniani momo ena lagani 7 idia ore vadaeni Aigupito dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Hitolo nega ena lagani ginigunana ia ginidae vadaeni, Iosepa ia hereva bamona. Vadaeni tano idauidau ibounai dekenai taunimanima be idia hitolo noho, to Aigupito dekenai be aniani ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Vadaeni Aigupito ena tano ibounai dekenai taunimanima be idia hitolo noho neganai, idia taitai Farao dekenai, aniani ia henidia totona. Vadaeni Farao ese ia hamaorodia, ia gwau, “Umui lao Iosepa dekenai. Edena bamona ia hereva umui dekenai, vadaeni umui karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Tanobada ibounai dekenai hitolo nega ia bada, vadaeni Iosepa ese sitoa ibounai ia kehoa. Aigupito taudia ese aniani idia hoia, moni davana, badina be hitolo ena nega ia bada herea momokani, Aigupito ena tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Vadaeni tano idauidau ibounai dekena amo, taunimanima idia lao Aigupito dekenai, aniani idia hoia, Iosepa dekenai. Badina be hitolo ena nega ia bada herea momokani, tanobada ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Iakobo ese sivarai ia kamonai, Aigupito dekenai be uiti ia noho. Vadaeni, iena natuna dekenai ia hereva, ia gwau, “Badina dahaka umui ta ta umui gini kava, gini kava?” ");
INSERT INTO hmo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ia gwau lou, “Lau kamonai vadaeni Aigupito dekenai be uiti ia noho. Do umui lao unuseni, iseda uiti umui hoia, ita mauri totona, vadaeni ita mase lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Vadaeni Iosepa ena kakana 10 be Aigupito dekenai idia lao, uiti hoia totona. ");
INSERT INTO hmo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","To Beniamina, Iosepa ena tadina, be Iakobo ese ia dogoatao, do ia lao lasi iena kakana danu. Badina be Iakobo ia gwau, “Dika ta Beniamina dekenai do ia vara garina.” ");
INSERT INTO hmo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Unai dainai Israela ena natuna be taunimanima momo danu idia lao, uiti hoia totona, badina be hitolo ena nega ia bada Kanana tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Iosepa be Aigupito tano ibounai ena lohia, unai dainai taunimanima ibounai idia lao Iosepa dekenai uiti idia hoia. Iosepa ena kakana danu idia lao ia dekenai, vadaeni idia edia kwarana idia atoa diho tano dekenai Iosepa ena vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Iosepa ese iena kakana ia itadia neganai, iena lalona ia kehoa vadaeni idia be daika, to ia hereva henidia idau tauna bamona, ia gwau henidia, ia gwau, “Umui be edena gabu dekena amo umui mai?” Idia gwau, “Kanana tano dekena amo ai mai, aniani hoia totona.” ");
INSERT INTO hmo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iosepa ia diba, inai be iena kakana, to idia diba lasi ia be Iosepa. ");
INSERT INTO hmo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Vadaeni Iosepa ena nihi, idia dekenai ia nihi gauna hari ia laloa, vadaeni ia gwau henidia, ia gwau, “Umui be koikoi taudia, tuari orea ta ese umui ia siaia mai, inai tano ena manoka itaia totona.” ");
INSERT INTO hmo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Idia haere ia dekenai, idia gwau, “Lohia e, unai bamona lasi. Ai be oiemu hesiai taudia, uiti hoia totona ai mai. ");
INSERT INTO hmo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ai be tau tamona ena natuna, hereva momokani taudia, tuari taudia ese ai idia siaia lasi, tano itaia totona.” ");
INSERT INTO hmo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","To Iosepa ia gwau henidia lou, ia gwau, “Lasi. Umui be tano ena manoka itaia totona umui mai.” ");
INSERT INTO hmo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Idia hereva lou, idia gwau, “Ai be oiemu hesiai taudia. Ai be tadikakana ibounai 12, tau tamona ena natuna, Kanana tano dekenai. To gabeai ia vara mero be harihari aiemai tamana dekenai, bona emai tadina ta be ia mase vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Iosepa ia gwau, “Lau hereva vadaeni, ani? Umui be tuari taudia ese idia siaia, tano itaia totona. ");
INSERT INTO hmo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Lau ura diba umui be momokani o lasi. Unai dekenai, Farao ena ladana dainai lau gwauhamata, inai gabu do umui rakatania lasi ela bona umui emui tadina do ia mai iniseni. ");
INSERT INTO hmo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Umui dekena amo tau ta do umui siaia, umui emui tadina do ia hakaua mai iniseni, to umui orena be dibura ruma dekenai do umui noho, vadaeni do lau diba emui hereva be momokani o lasi. Bema lasi, inai be momokani, tuari taudia ese umui idia siaia, tano itaia totona.” ");
INSERT INTO hmo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Vadaeni, dibura ruma dekenai ia atodia dina toi. ");
INSERT INTO hmo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Dina ihatoina dekenai Iosepa ese ia hereva henidia, ia gwau, “Inai bamona umui karaia, vadaeni dohore umui mauri, badina be lau danu Dirava dekenai lau gari. ");
INSERT INTO hmo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Bema umui be hereva momokani taudia, vadaeni umui ta dibura ruma dekenai do ia noho, to umui orena be uiti umui laohaia emui varavara taudia idia hitolo dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Vadaeni do umui giroa mai, emui tadina do umui hakaua mai lau dekenai, vadaeni dohore lau diba umui emui hereva be ia momokani, vadaeni dohore umui mase lasi.” Vadaeni inai hereva idia abia dae. ");
INSERT INTO hmo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Unai neganai idia sibona idia herevahereva, idia gwau, “Momokani, ita kerere vadaeni iseda tadina dainai. Badina be iena lalohisihisi bada ita itaia, to iena noinoi ita abia dae lasi, unai dainai hari kerere ia mai ita dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubena ia gwau, “Umui lau hamaoroa vadaeni, ani? Lau gwau, mero be do umui hadikaia lasi, to umui kamonai lasi. Vadaeni harihari iena mase ena davana be, iseda latanai ia noho.” ");
INSERT INTO hmo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Idia diba lasi Iosepa be idia edia hereva anina ia diba, badina Iosepa ia hereva henidia, gado hanaia tauna ena uduna dekena amo. ");
INSERT INTO hmo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Vadaeni ia raka siri, ia tai. Gabeai ia giroa mai, idia dekenai ia hereva lou. Vadaeni iena hesiai taudia ia oda henia, Simeona idia dogoatao, bona varo dekenai idia guia, idia edia vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Vadaeni, Iosepa ia hamaoroa iena hesiai taudia dekenai, ia gwau, “Idia edia puse dekenai uiti umui udaia, idia honu. Idia ta ta edia moni edia puse dekenai do umui udaia lou, dala dekenai dohore idia ania uiti danu do umui henidia.” Vadaeni inai bamona idia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Vadaeni Iosepa ena kakana ese edia puse be edia doniki edia doruna dekenai idia atoa kau, idia raka lao. ");
INSERT INTO hmo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Adorahi neganai idia kamepa. Vadaeni ta ese iena puse ia kehoa, iena doniki dekenai aniani henia gwauraia, vadaeni iena moni ia itaia, puse ena uduna dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Vadaeni ia ese iena tadikakana ia hamaorodia, ia gwau, “Lauegu moni be idia udaia lou lauegu puse dekenai.” Vadaeni idia hoa maragi lasi, idia gari dikadika. Idia sibona idia herevahereva, idia gwau, “Dirava be edena bamona ia karaia vadaeni ita dekenai?” ");
INSERT INTO hmo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kanana tano dekenai idia ginidae edia tamana Iakobo dekenai, vadaeni idia edia laolao sivaraina idia gwauraia ia dekenai, idia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Unai tano ena lohia tauna be ia dagedage henia ai dekenai, dibura ruma dekenai ia koua ai, ia gwau ai be tuari taudia ese ai idia siaia, tano itaia totona. ");
INSERT INTO hmo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","To ai hamaoroa ia dekenai, ai gwau, ‘Ai be hereva momokani taudia, tano itaia totona ai mai lasi. ");
INSERT INTO hmo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ai be mai tadina bona kakana 12, tau tamona ena natuna. Ta be ia mase vadaeni, bona gabeai ia vara merona be aiemai tamana dekenai, Kanana tano dekenai.’ ");
INSERT INTO hmo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Unai tano ena lohia tauna ia gwau, ‘Inai dekena amo dohore lau diba umui be hereva momokani taudia o lasi. Umui ta do lau dogoatao iniseni ai, to umui orena be uiti do umui abia lao, umui emui varavara taudia idia hitolo dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Umui emui tadina, gabeai ia vara tauna do umui hakaua mai lau dekenai, vadaeni dohore lau diba umui be hereva momokani taudia. Vadaeni, umui emui tadikakana dohore lau henia lou umui dekenai, bona inai tano dekenai danu dohore umui hoihoi.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Vadaeni edia puse dekena amo uiti idia bubua neganai, idia ta ta edia moni idia davaria edia puse dekenai, vadaeni idia bona edia tamana inai moni idia itaia neganai, idia gari dikadika. ");
INSERT INTO hmo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Vadaeni edia tamana Iakobo ese ia gwau henidia, ia gwau, “Lauegu natuna be lau dekena amo umui kokia vadaeni. Iosepa ia boio, Simeona ia boio, harihari Beniamina danu umui kokia gwauraia, inai hisihisi ibounai be lau sibona egu latanai ia noho.” ");
INSERT INTO hmo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Vadaeni Rubena ese iena tamana ia hamaoroa, ia gwau, “Beniamina bema lau mailaia lasi oi dekenai, lauegu natuna ruaosi dohore oi alaia mase. Lauegu imana dekenai oi siaia, vadaeni dohore lau mailaia lou mai mauri danu.” ");
INSERT INTO hmo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","To Iakobo ia gwau, “Lauegu natuna be umui danu do ia lao lasi, badina be iena kakana korikori ia mase vadaeni, bona ia sibona ia noho. Dala dekenai bema dika ta ia dekenai ia vara, lau be dohore lau mase. Badina lau buruka dainai, lalohisihisi inai bamona be do ia hamasea lau.” ");
INSERT INTO hmo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kanana tano dekenai hitolo be ia bada herea. ");
INSERT INTO hmo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Aigupito dekena amo idia mailaia uiti be idia ania ore, vadaeni edia tamana ia hamaoroa idia dekenai, ia gwau, “Ma umui giroa lao aniani sisina umui hoia, ita totona.” ");
INSERT INTO hmo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Vadaeni Iuda ia haere henia ia dekenai, ia gwau, “Unai tau ena hereva be ia auka, ia gwau, ‘Bema umui emui tadina umui hakaua mai lasi neganai, lauegu vairana dohore umui itaia lasi.’ ");
INSERT INTO hmo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Bema aiemai tadina oi siaia ai danu, ai be dohore ai lao oiemu aniani do ai hoia. ");
INSERT INTO hmo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","To bema oi siaia lasi, dohore ai lao lasi. Badina unai tau ia gwau, ‘Bema umui emui tadina umui hakaua mai lasi, dohore lauegu vairana umui itaia lasi.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Vadaeni Israela ia gwau, “Badina dahaka unai tau dekenai umui emui tadina ena sivarai umui hedinaraia? Unai dekena amo lau umui hadikaia.” ");
INSERT INTO hmo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Idia gwau, “Unai tau ese ai dekenai ia henanadaia goadagoada, iseda iduhu dekenai ia henanadaia, ia gwau, ‘Umui emui tamana do ia mauri noho? Bona umui emui tadina ta ia noho?’ Unai dainai ai haere henia ia dekenai. Edena bamona do ai diba dohore ia gwau, ‘Umui emui tadina umui hakaua mai, a?’ ” ");
INSERT INTO hmo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Vadaeni Iuda ese iena tamana Israela dekenai ia noinoi, ia gwau, “Lau danu mero oi siaia, ai toreisi, ai lao. Unai dekena amo do ita mauri, ita mase lasi. Oi bona aiemai natuna maragidia danu. ");
INSERT INTO hmo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Lauegu mauri do lau atoa diho inai, ia totona, lau ese dohore lau naria. Lau dekenai do oi tahua, bema lau mailaia lasi oi dekenai. Oiemu vairana dekenai bema lau hakaua lasi, kerere be lauegu latanai do ia noho hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Bema oi ese ai oi koua lasi neganai, inai laolao iharuana be momokani idaunegai ia ore vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Vadaeni edia tamana Israela ese ia haere henidia, ia gwau, “Bema dala idauna ta lasi, inai bamona umui karaia. Iseda tano ena anina namo herea gaudia umui abia lao, umui emui maduna dekenai. Muramura mai ena bonana namo, hani, aniani dekenai hanamoa muramura, niuniu bona okari umui abia lao, unai tau ena. ");
INSERT INTO hmo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Umui ta ta dekenai moni pusepuse rua rua umui abia lao. Umui emui puse dekenai idia udaia lou moni danu umui loulaia, badina idia udaia taudia be sedira idia kerere. ");
INSERT INTO hmo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Emui tadina danu umui hakaua lao, vadaeni unai tau dekenai umui giroa lou. ");
INSERT INTO hmo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Siahu Ibounai Dirava do ia bogahisihisi henia umui dekenai, vadaeni ia ese unai tau ena vairana dekenai umui do ia durua, vadaeni umui emui tadikakana ta do ia henia lou umui dekenai, bona Beniamina danu do ia siaia lou, to lauegu natuna lau dekena amo bema idia boio, vadaeni do idia boio.” ");
INSERT INTO hmo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Unai dainai idia ese harihari gaudia idia abia lao, edia tamana ia hereva hegeregerena, bona moni pusepuse rua rua, ta ta idia abia, bona Beniamina danu idia hakaua, vadaeni idia toreisi, Aigupito tano dekenai idia lao, Iosepa ena vairanai idia gini. ");
INSERT INTO hmo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Iosepa ese Beniamina ia itaia, vadaeni iena hesiai tauna badana dekenai ia hereva, ia gwau, “Inai taudia oi hakaua lao lauegu ruma dekenai, ubua gauna ta oi alaia, bona nadua hegaegae, badina be dina tubua neganai, inai taudia be lau danu do ai aniani gabu tamona dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Vadaeni hesiai tauna be Iosepa ena hereva hegeregere ia hakaudia lao, Iosepa ena ruma dekenai ia hakaudia. ");
INSERT INTO hmo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Vadaeni inai taudia idia gari dikadika, badina Iosepa ena ruma dekenai idia hakaudia vareai dainai, idia sibona idia herevahereva, idia gwau, “Nega ginigunana dekenai moni idia udaia lou iseda puse dekenai. Unai dainai ia be kerere davaria totona dala ia tahua ita dekenai, dohore ia guia ita, iena hesiai taudia ita do ia halaoa, iseda doniki do ia abidia ia sibona ena.” ");
INSERT INTO hmo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Vadaeni idia be Iosepa ena hesiai tauna badana dekenai idia lao, ruma ena iduara dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Idia hamaoroa ia dekenai, idia gwau, “Tau badana e, nega ginigunana ai mai be aniani sibona mo hoia totona ai mai. ");
INSERT INTO hmo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","To aiemai kamepa gabuna dekenai ai ginidae, aiemai puse ai kehoa, vadaeni aiemai moni ai itaia. Ai ta ta aiemai puse dekenai guna ai henia moni ibounai ai davaria. Moni ena metau be idau lasi. Harihari aiemai moni ibounai ai mailaia lou vadaeni, ai henia lou totona. ");
INSERT INTO hmo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Bona moni haida ma ai mailaia vadaeni, aniani ma do ai hoia totona. To ai diba lasi daika ese aiemai moni idia udaia lou aiemai puse dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Vadaeni inai hesiai tauna badana ia gwau, “Umui laloa lasi, umui gari lasi. Lau laloa, umui emui Dirava, bona umui emui tamana danu ena Dirava, ese unai moni be emui puse ta ta lalonai ia udaia. Badina be, umui emui uiti hoia moni be lau ese lau abia vadaeni.” Vadaeni ia ese Simeona ia hakaua mai idia dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Vadaeni unai hesiai tauna badana ese Iosepa ena ruma lalona dekenai ia hakaudia vareai, edia aena huria totona ranu ia henidia, edia doniki dekenai danu aniani ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Vadaeni edia harihari gaudia idia abia hegaegae noho, dina tubua ia mai neganai, Iosepa dekenai dohore idia henia totona, badina be idia kamonai vadaeni unuseni dekenai do idia aniani. ");
INSERT INTO hmo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Iosepa ia raka vareai neganai, harihari gaudia idia henia ia dekenai. Vadaeni edia kwarana idia atoa diho tano dekenai, Iosepa ena vairanai. ");
INSERT INTO hmo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Vadaeni Iosepa ese ia nanadaia idia dekenai, ia gwau, “Umui be edena bamona? Umui emui tamana danu ia namo? Inai tau buruka, vanegai ena sivarai umui gwauraia, do ia mauri noho, a?” ");
INSERT INTO hmo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Idia haere, idia gwau, “Oiemu hesiai tauna, aiemai tamana be ia namo, do ia mauri noho.” Vadaeni idia edia kwarana idia atoa diho, idia hanamoa ia dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Vadaeni Iosepa ese iena matana ia negea, iena tadina Beniamina ia itaia, iena tadina korikori. Vadaeni ia gwau, “Umui emui tadina, gabeai ia vara tauna be unai, a, vanegai ena sivarai umui gwauraia tauna?” Ma Beniamina dekenai ia gwau, “Natugu e, Dirava do ia bogahisihisi henia oi dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","To Iosepa ena lalona ia manoka, iena tadina dekenai ia bogahisihisi bada dainai, vadaeni karaharaga ia rakatanidia, iena daiutu ta dekenai ia lao, unuseni ia tai. ");
INSERT INTO hmo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Vadaeni iena vairana ia huria, ia giroa idia dekenai, iena lalona ia ha-aukaia, hesiai taudia dekenai ia gwau, “Aniani umui atoa hegaegae.” ");
INSERT INTO hmo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Vadaeni aniani idia atoa, pata ta dekenai be Iosepa ena, pata ta dekenai be idia edia, ma pata ta dekenai be Aigupito taudia edia, badina Aigupito taudia edia kara be Heberu taudia danu idia aniani lasi gabu tamona dekenai, Aigupito taudia dekenai unai be hemarai gauna. ");
INSERT INTO hmo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Vadaeni hesiai taudia ese tadikaka edia helai gabuna idia henidia, Iosepa ena vairanai, edia vara hegeregerena. Guna ia vara tauna ia lao bona gabeai ia vara tauna. Unai dainai idia sibona ta ta edia matana dekenai idia itaia, bona idia hoa bada danu. ");
INSERT INTO hmo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Vadaeni aniani idia henidia Iosepa ena pata dekena amo, to Beniamina ena, be nega 5 idia henia. Bona Iosepa danu uaina idia inua, vadaeni idia moale hebou. ");
INSERT INTO hmo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Vadaeni Iosepa ese iena hesiai tauna badana dekenai ia hamaoroa, ia gwau, “Inai tatau edia puse dekenai aniani oi udaia, idia honu momokani, bona edia moni danu edia puse ena uduna dekenai do oi udaia. ");
INSERT INTO hmo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Bona lauegu kapusi, inai siliva gauna, gabeai ia vara tauna ena puse uduna dekenai do oi udaia, bona iena uiti hoia totona moni danu.” Vadaeni ia ese Iosepa ena hereva hegeregerena ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Daba ia rere, inai tatau mai edia doniki danu idia siaia lao. ");
INSERT INTO hmo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Hanua idia rakatania, to idia raka daudau lasi neganai, Iosepa ese iena hesiai tauna badana dekenai ia hamaoroa, ia gwau, “Oi toreisi, idia edia murina dekenai oi lao, idia oi davaria neganai, do oi gwau henia idia dekenai, oi gwau, ‘Badina dahaka namo be dika dekena amo davana umui karaia? ");
INSERT INTO hmo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Lauegu kapusi, siliva gauna, badina dahaka umui henaoa? Lauegu biaguna be inai dekena amo ia inua, bona inai dekena amo dahaka dahaka do idia vara ena dala ibounai ia diba. Umui kerere dikadika.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Unai dainai hesiai tauna badana ese idia ia davaria neganai, unai bamona ia gwau henia idia dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Idia haere henia ia dekenai, idia gwau, “Lohia e, dahaka dainai inai bamona oi hereva? Ai be unai bamona ai karaia lasi, lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Oi itaia, oiemu puse dekenai ai davaria monina be ai henia lou vadaeni oi dekenai, Kanana dekena amo ai giroa mai neganai. Unai dainai dahaka totona oiemu biaguna ena ruma dekenai siliva o golo do ai henaoa? ");
INSERT INTO hmo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tau namona e, bema oi davaria, ai ta dekenai unai bamona ia karaia, ia be do ia mase, bona ai be oiemu biaguna ese iena hesiai taudia do ia halaoa ai.” ");
INSERT INTO hmo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Vadaeni ia gwau, “Ia namo, unai bamona do ita karaia. Iena puse dekenai dohore lau davaria tauna be, lauegu hesiai tauna do lau halaoa, to umui orena be do umui kerere lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Vadaeni idia ta ta edia puse idia abia diho karaharaga, idia kehoa. ");
INSERT INTO hmo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Vadaeni inai tau ese ia tahua. Guna ia vara tauna dekenai ia tahua hamatamaia, ia lao bona gabeai ia vara tauna dekenai ia hadokoa. Kapusi be Beniamina ena puse dekenai ia davaria. ");
INSERT INTO hmo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Vadaeni lalohisihisi dainai edia dabua idia darea, edia puse be doniki edia doruna dekenai idia atoa kau, idia giroa lou hanua badana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Vadaeni Iuda mai ena tadikakana be Iosepa ena ruma dekenai idia ginidae neganai, Iosepa be do ruma dekenai. Unai neganai idia ese Iosepa ena vairana dekenai edia vairana idia atoa diho tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Vadaeni Iosepa ese ia gwau henia idia dekenai, ia gwau, “Edena bamona umui karaia vadaeni? Umui diba lasi lau be dahaka dahaka do idia vara ena dala ibounai lau diba tauna, a?” ");
INSERT INTO hmo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Iuda ia gwau, “Lauegu lohia e! Edena bamona do ai hereva, dahaka do ai gwau oi dekenai, edena bamona do ai maoro oiemu vairana dekenai? Lohia e, Dirava ese aiemai kerere ia hedinaraia vadaeni. Harihari ai ibounai be oiemu hesiai taudia davana lasi, iena puse lalonai oiemu kapusi ia davaria tauna sibona lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","To Iosepa ia gwau, “Lasi. Unai bamona do lau karaia lasi umui dekenai. Lauegu kapusi ia abia tauna sibona mo be lauegu hesiai tauna davana lasi do lau halaoa, to umui orena be umui emui tamana dekenai do umui giroa lou mai maino danu.” ");
INSERT INTO hmo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Vadaeni Iuda ese ia raka Iosepa kahirakahira dekenai, ia gwau, “Lohia e, mani emu kara, lau ura noinoi oi dekenai. Mani emu kara oiemu badu do ia keruma lau dekenai, badina oi be Farao hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Lauegu lohia e, ai dekenai oi nanadaia, oi gwau, ‘Umui emui tamana, o umui emui tadina idia noho, a?’ ");
INSERT INTO hmo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Vadaeni ai haere henia oi dekenai, ai gwau, ‘Aiemai tamana tau buruka ia noho, bona mero ta, tau buruka neganai ia abia merona. Unai mero ena kakana be ia mase vadaeni, sinana ena natuna tamona sibona ia, unai dainai aiemai tamana ese ia lalokau bada ia dekenai.’ ");
INSERT INTO hmo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Lohia e, oi ese oi hamaoroa ai dekenai, oi gwau, ‘Umui hakaua mai, lau itaia.’ ");
INSERT INTO hmo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Vadaeni ai haere henia oi dekenai, ai gwau, ‘Unai mero ese iena tamana do ia rakatania lasi, badina bema ia lao gabu ta dekenai, iena tamana be dohore ia mase.’ ");
INSERT INTO hmo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Lohia e, unai neganai oi ese oi hamaoroa ai dekenai, oi gwau, ‘Umui emui tadina gabeai ia vara merona, bema umui hakaua mai lasi neganai, lauegu vairana do umui itaia lou lasi.’ ");
INSERT INTO hmo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Vadaeni, oiemu hesiai tauna, aiemai tamana dekenai ai giroa lou neganai, oiemu hereva ai hamaoroa ia dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Vadaeni aiemai tamana ia gwau, ‘Umui giroa lou, iseda aniani sisina ma umui abia.’ ");
INSERT INTO hmo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Vadaeni ai gwau, ‘Ai lao diba lasi, badina be bema aiemai tadina ai danu do ai lao lasi, unai tau ena vairana dohore ai itaia lou lasi. Aiemai lao dalana be tamona sibona, mero danu do ai lao be unai.’ ");
INSERT INTO hmo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Vadaeni aiemai tamana ia gwau, ‘Umui diba lauegu adavana be memero rua ia abia. ");
INSERT INTO hmo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ta ese lau ia rakatania, vadaeni lau laloa dagedage gauna ta ese ia darea mase, vadaeni lau itaia lou lasi ia mai bona hari. ");
INSERT INTO hmo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","To harihari inai ta danu do umui kokia lau dekena amo, vadaeni bema dika ta ia dekenai dohore ia vara, lau be dohore lau mase. Badina lau buruka dainai, lalohisihisi inai bamona ese do ia hamasea lau.’ ");
INSERT INTO hmo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Unai dainai, lohia e, aiemai tamana dekenai bema lau giroa lao, to mero bema lau hakaua lao lasi, do ia itaia ai dekenai, mero be lasi neganai dohore ia mase. ");
INSERT INTO hmo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Iena mauri bona unai mero ena mauri be hakapua tamona. Lohia e, aiemai tamana ia buruka momokani tauna dainai, ai ese iena mase do ai havaraia, mai lalohisihisi danu. ");
INSERT INTO hmo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Badina be lauegu tamana dekenai gwauhamata lau henia vadaeni, inai mero totona lau gwau, ‘Bema lau hakaua lou lasi oi dekenai mai mauri danu, kerere be lauegu latanai do ia noho, ia lao bona hanaihanai.’ ");
INSERT INTO hmo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Unai dainai lohia e, lau noinoi oi dekenai, lau be oiemu hesiai tauna davana lasi do oi halaoa, inai mero ena gabuna lau abia. To ia be iena kakana danu do idia giroa lou. ");
INSERT INTO hmo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Badina be edena bamona lauegu tamana dekenai do lau giroa lou, bema mero lau danu be lasi? Lau ura lasi inai dika badana lauegu tamana dekenai ia vara be lau itaia.” ");
INSERT INTO hmo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Iosepa be iena hesiai taudia ibounai edia vairana dekenai iena lalona ia hagoadaia diba lasi, vadaeni ia boiboi, ia gwau, “Hesiai taudia ibounai, lau umui rakatania, umui lao murimuri dekenai.” Vadaeni tau ta lasi idia dekenai noho neganai, Iosepa ese iena tadikakana taudia dekenai ia hamaoroa, ia gwau, “Lau be Iosepa. Lau be emui tadikakana.” ");
INSERT INTO hmo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Bona Iosepa ia tai mai boiboi danu. Unai neganai, Aigupito taudia bona Farao ena ruma taudia ibounai ese Iosepa ena taitai idia kamonai. ");
INSERT INTO hmo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Vadaeni Iosepa ese iena tadikaka taudia dekenai ia hereva, ia gwau, “Lau inai Iosepa. Lauegu tamana be do ia mauri noho, a?” To idia ese idia haere henia diba lasi ia dekenai, badina idia edia kudouna dekenai idia gari dikadika. ");
INSERT INTO hmo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Vadaeni Iosepa ese iena tadikakana ma ia hamaorodia, ia gwau, “Umui mai kahirakahira lau dekenai.” Vadaeni idia lao iena badibadinai. Ma ia gwau, “Lau inai, umui emui tadina Iosepa, lau umui hoia, vadaeni lau mai Aigupito dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Umui emui lalona do idia hisihisi lasi, umui sibona ta ta dekenai badu henia lasi, lau umui hoia vadaeni, lau mai iniseni dainai. Badina be Dirava ese lau ia siaia guna, umui emui vairana dekenai, umui do lau hamauria totona. ");
INSERT INTO hmo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Badina inai lagani rua be hitolo nega ena lagani. To hitolo nega ena lagani 5 do idia noho, vadaeni unai lagani edia lalonai uiti do idia hadoa lasi, bona anina do idia abia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dirava ese lau ia siaia guna, umui emui vairana dekenai, gabeai natudia do umui havaraia totona. Umui bona umui emui bese momo ese mauri do umui abia totona, Dirava ese lau ia siaia. ");
INSERT INTO hmo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Unai dainai umui be lasi, to Dirava ese lau ia siaia iniseni. Ia ese ia karaia. Dirava ese Farao ena tamana bamona lau ia halaoa. Farao ena ruma ibounai ena biaguna, bona Aigupito tano ibounai ena lohia be Dirava ese lau ia halaoa vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Unai dainai karaharaga umui lao egu tamana dekenai, do umui hamaoroa ia dekenai, umui gwau, ‘Oiemu natuna Iosepa ia gwau: Dirava ese Aigupito ena tano ibounai ena lohia lau ia halaoa vadaeni. Vadaeni, umui mai lau dekenai, umui karaharaga. ");
INSERT INTO hmo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Gosena tano dekenai do umui noho, lauegu badibadinai, oi bona oiemu natuna bona oiemu tubuna bona oiemu mamoe ibounai, bona oiemu boromakau ibounai, bona oiemu gau ibounai. ");
INSERT INTO hmo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Bema Gosena dekenai umui noho, do lau naria diba umui. Hitolo nega ena lagani 5 ma do idia noho, lau ura lasi umui bona emui orea taudia ibounai do umui hitolo.’ ");
INSERT INTO hmo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Umui emui matana dekenai umui itaia vadaeni, bona lauegu tadina Beniamina danu ena matana dekenai ia itaia vadaeni, inai hereva ibounai be lauegu uduna dekenai lau gwauraia. ");
INSERT INTO hmo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Unai dainai lauegu siahu ibounai Aigupito dekenai, bona umui itaia gaudia ibounai danu lauegu tamana dekenai do umui hamaoroa, vadaeni egu tamana do umui hakaua mai karaharaga.” ");
INSERT INTO hmo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Vadaeni Iosepa ese iena tadina Beniamina ia rosia, mai tai danu. Beniamina danu ia rosia, vadaeni ruaosi idia taitai. ");
INSERT INTO hmo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Vadaeni Iosepa ese iena kakana ibounai dekenai ia kisi henia, bona ia rosia idia dekenai mai tai danu. Gabeai iena tadikakana danu ese ia danu idia herevahereva, idia gari lasi. ");
INSERT INTO hmo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Inai gaudia edia sivarai be Farao ena ruma taudia dekenai idia gwauraia. Idia kamonai, Iosepa ena tadikakana be idia mai, vadaeni Farao mai ena hesiai taudia idia moale. ");
INSERT INTO hmo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Vadaeni Farao ese Iosepa dekenai ia hamaoroa, ia gwau, “Oiemu tadikakana oi hamaorodia, oi gwau, ‘Umui emui kohu, umui emui doniki edia doruna dekenai do umui atoa kau, Kanana tano dekenai do umui giroa lou. ");
INSERT INTO hmo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Umui emui tamana, bona umui emui varavara taudia do umui abidia, umui hakaudia mai lau dekenai. Lau ese Aigupito ena tano namo herea momokani umui dekenai do lau henia, bona inai tano ena aniani namodia do umui ania.’ ");
INSERT INTO hmo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Oi hamaoroa lou idia dekenai, oi gwau, ‘Inai bamona do umui karaia. Inai Aigupito tano ena treila, taunimanima idia guia gaudia, do umui abidia lao. Vadaeni umui emui natuna, bona umui emui adavana do umui udaia, umui mailaia, bona umui emui tamana danu. ");
INSERT INTO hmo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","To umui emui kohu umui rakatania dekenai do umui laloa lasi, badina be inai Aigupito tano dekenai kohu namodia dohore umui abia, umui emui.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Vadaeni Israela ena natuna ese iena hereva idia badinaia, bona Iosepa ese treila ia henidia, Farao ia hereva bamona. Aniani danu ia henidia, dala dekenai idia aniani totona. ");
INSERT INTO hmo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Iosepa ese idia ta ta dekenai dabua namo herea ia henia, to Beniamina dekenai siliva moni 300 ia henia, bona dabua namo herea 5. ");
INSERT INTO hmo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Harihari gaudia danu ia siaia iena tamana dekenai, doniki 10 Aigupito dekena amo ese kohu namodia idia huaia, bona doniki hahine 10 ese uiti bona paraoa bona aniani haida danu idia huaia, bona iena tamana ena aniani danu dala dekenai ania totona. ");
INSERT INTO hmo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Vadaeni Iosepa ese iena tadikakana ia siaia lao, ia gwau, “Dala dekenai umui lao neganai, umui ta ta umui laloa hekwarahi lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Aigupito idia rakatania, Kanana tano dekenai idia lao, idia edia tamana Iakobo dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Idia hamaoroa Iakobo dekenai, idia gwau, “Iosepa be ia mauri noho, Aigupito tano ibounai dekenai ia lohia.” Vadaeni Iakobo ena kudouna dekenai ia mase bamona, idia edia hereva ia hamomokania diba lasi. ");
INSERT INTO hmo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","To Iosepa ena hereva ibounai idia hamaoroa ia dekenai, bona Iakobo ese taunimanima guia treila gaudia ia itaia, Iosepa ese ia siaia gaudia ibounai danu, vadaeni iena kudouna dekenai ia mauri lou. ");
INSERT INTO hmo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Unai neganai Israela ia gwau, “Vadaeni, lauegu natuna Iosepa do ia mauri noho momokani. Dohore lau mase lasi neganai, do lau lao itaia.” ");
INSERT INTO hmo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israela ese iena kohu ibounai ia haboua, vadaeni ia lao Bere Sieba dekenai. Unuseni iena tamana Isako ena Dirava dekenai boubou gaudia ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Hanuaboi lalonai Dirava ese mata hanai dekena amo Israela dekenai ia hereva, ia gwau, “Iakobo e, Iakobo e.” Vadaeni Iakobo ia haere, ia gwau, “Lau inai.” ");
INSERT INTO hmo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ma ia gwau, “Lau be Dirava, oiemu tamana ena Dirava, oi gari lasi Aigupito dekenai oi lao, badina be unuseni oiemu natuna edia natudia be bese badana do lau halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Lau be oi danu do ita lao Aigupito, bona oiemu natuna ibounai do lau mailaia lou iniseni. Bona do oi mase neganai, Iosepa be oi danu do ia noho.” ");
INSERT INTO hmo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Vadaeni Iakobo ese Bere Sieba ia rakatania. Israela ena natudia ese edia tamana Iakobo, edia natuna maragidia, bona edia adavana idia udaia treila dekenai. Treila be taunimanima idia guia gaudia, Farao ese ia henidia gaudia. ");
INSERT INTO hmo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Idia edia boromakau ibounai, bona Kanana dekenai idia davaria kohu ibounai idia abia lao. Vadaeni Aigupito dekenai idia ginidae. Iakobo ese iena bese ibounai ia abia lao, ");
INSERT INTO hmo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","iena natuna tatau, iena tubuna tatau, iena natuna hahine, bona iena tubuna hahine. ");
INSERT INTO hmo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israela ena bese Aigupito idia lao taudia edia ladana be inai: Idia be Iakobo mai ena natuna ibounai. ");
INSERT INTO hmo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubena be Iakobo ena vara guna natuna. Rubena ena natuna tatau be Hanoka, Palu, Hesarona bona Karami. ");
INSERT INTO hmo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeona ena natuna tatau be Iemuela, Iamina, Ohada, Iakini, Sohara bona Saulo. Saulo be Kanana hahine ena natuna. ");
INSERT INTO hmo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi ena natuna tatau be Geresone, Kohata bona Merari. ");
INSERT INTO hmo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Iuda ena natuna tatau be Ere, Onana, Sela, Perese bona Sera. To Ere bona Onana be Kanana tanona dekenai idia mase. Perese ena natuna tatau be Hesarona bona Hamulu. ");
INSERT INTO hmo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakara ena natuna tatau be Tola, Puva, Iobo bona Simarona. ");
INSERT INTO hmo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebuluno ena natuna tatau be Sereda, Elona bona Ialela. ");
INSERT INTO hmo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Rubena, Simeona, Levi, Iuda, Isakara, bona Sebuluno be Lea ena natuna tau, Iakobo ese Lea dekena amo ia abidia Mesopotamia dekenai. Lea ese danu natuna hahine, ladana Daina ia havaraia. Vadaeni Lea ena natuna bona iena tubuna ibounai be 33. ");
INSERT INTO hmo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gado ena natuna tatau be Sipiona, Hagi, Suni, Esabona, Eri, Arodi bona Areli. ");
INSERT INTO hmo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asere ena natuna tatau be Imuna, Isiva, Isivi bona Beria, edia taihuna Sera danu. Beria ena natuna tatau be Hebere bona Malekiela. ");
INSERT INTO hmo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Inai be hesiai hahine Silipa ena natuna, Labana ese iena natuna Lea dekenai ia henia hahine be unai. Iakobo ese iena natuna bona iena tubuna 16 Silipa dekena amo ia abidia. ");
INSERT INTO hmo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Iakobo ena adavana Rahela ena natuna tatau be inai, Iosepa bona Beniamina. ");
INSERT INTO hmo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Iosepa ena natuna rua, Manase bona Eparaima be Aigupito tano dekenai ia abidia, Onu ena dubu helaga tauna Potifera ena natuna Asenate ena bogana dekena amo. ");
INSERT INTO hmo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Beniamina ena natuna tatau be inai: Bela, Bekere, Asabela, Gera, Namana, Ehi, Rosa, Mupima, Hupima, bona Arada. ");
INSERT INTO hmo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Inai ibounai be Rahela ena natuna bona ena tubuna, Iakobo ese ia dekena amo ia abidia. Idia ibounai be 14. ");
INSERT INTO hmo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dano ena natuna tatau be Husima. ");
INSERT INTO hmo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napatali ena natuna tatau be Iasela, Guni, Iesere bona Silema. ");
INSERT INTO hmo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Inai natuna bona tubuna tatau be hesiai hahine Bileha ena, Labana ese iena natuna Rahela dekenai ia henia hahine be unai. Idia ibounai be 7. Idia danu be Iakobo ena. ");
INSERT INTO hmo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Iakobo danu idia lao Aigupito dekenai, taunimanima ibounai ia ese ia havaraia taudia be 66, to iena natuna edia adavana be idia duahia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Bona Iosepa ese Aigupito dekenai iena natuna be rua ia abidia, unai dainai Iakobo ena iduhu taudia ibounai Aigupito dekenai be 70. ");
INSERT INTO hmo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Iakobo ese Iuda ia siaia guna Iosepa dekenai, Iosepa ese Gosena vareai dalana do ia hadibaia totona. Vadaeni Gosena dekenai idia ginidae. ");
INSERT INTO hmo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Iosepa ese iena kariota ia abia hegaegae, Gosena dekenai ia lao, iena tamana Israela danu do idia hedavari totona. Ia dekenai ia ginidae, vadaeni iena aiona dekenai ia rosia, ia tai nega daudau. ");
INSERT INTO hmo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israela ese Iosepa dekenai ia hamaoroa, ia gwau, “Harihari lau mase be, ia namo. Badina be oi mauri noho lau davaria vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Vadaeni Iosepa ese iena tadikakana bona iena tamana ena orea taudia ibounai dekenai ia hamaoroa, ia gwau, “Do lau lao Farao dekenai, bona do lau hamaoroa, lau gwau, ‘Lauegu tadikakana bona lauegu tamana ena orea taudia ibounai Kanana tano dekena amo idia mai vadaeni, lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Idia be mamoe bona boromakau naria taudia. Edia mamoe ibounai, bona edia boromakau ibounai, bona edia kohu ibounai idia mailaia vadaeni.’ ");
INSERT INTO hmo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Vadaeni Farao ese dohore ia boiria umui dekenai, bona do ia nanadaia, ia gwau, ‘Umui emui gaukara be dahaka?’ ");
INSERT INTO hmo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Unai neganai do umui haere, umui gwau, ‘Oiemu hesiai taudia ai be mero negana boromakau bona mamoe ai naria ia mai bona harihari, aiemai tamadia bamona.’ Vadaeni Gosena tano do umui noho diba. Badina be Aigupito taudia idia ura henia lasi mamoe naria taudia dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Vadaeni Iosepa ia lao Farao dekenai, ia gwau, “Lauegu tamana bona tadikakana taudia Kanana tano dekena amo idia mai vadaeni. Mai edia mamoe bona edia boromakau bona edia kohu ibounai, harihari idia be Gosena tano dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Vadaeni iena kakana taudia 5 ia abidia hidi, ia hakaudia vareai, Farao ena vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Vadaeni Farao ia nanadaia idia dekenai, ia gwau, “Umui emui gaukara be dahaka?” Idia gwau, “Lohia e, ai be mamoe naria taudia, aiemai sene taudia bamona.” ");
INSERT INTO hmo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Vadaeni idia noinoi Farao dekenai, idia gwau, “Ai mai vadaeni, inai tano dekenai ai noho gwauraia. Badina be Kanana tano dekenai rei sisina ia noho lasi, aiemai mamoe bona boromakau idia ania totona. Lohia e, mani emu kara oi hereva, ai be Gosena tano dekenai do ai noho.” ");
INSERT INTO hmo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Vadaeni Farao ese Iosepa ia hamaoroa, ia gwau, “Oiemu tamana bona oiemu tadikakana taudia oi dekenai idia mai vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Aigupito ena tano ibounai be oiemu vairana dekenai. Gabu namo herea ta do oi henidia, idia noho totona. Gosena tano dekenai do idia noho, bona goada taudia bema haida idia noho, idia edia huanai, lauegu boromakau naria taudia do oi halaoa.” ");
INSERT INTO hmo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Iosepa ese iena tamana Iakobo ia hakaua vareai, Farao ena vairana dekenai. Vadaeni Iakobo ese ia hanamoa Farao dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Vadaeni Farao ese ia nanadaia Iakobo dekenai, ia gwau, “Oiemu mauri lagani be hida?” ");
INSERT INTO hmo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Iakobo ia haere, ia gwau, “Lauegu mauri lagani, egu laolao inai tanobada dekenai be 130. To idia be momo lasi, bona mai hisihisi danu, lauegu tamana bona lauegu tubuna edia mauri lagani bamona lasi. Idia edia mauri lagani tanobada dekenai be momo.” ");
INSERT INTO hmo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Unai neganai Iakobo ese ia hanamoa lou Farao dekenai, vadaeni ia rakatania. ");
INSERT INTO hmo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Vadaeni Iosepa ese iena tamana bona iena tadikakana taudia edia gabu ia karaia hegaegae, bona edia tano ia henidia, Aigupito ena tano namo herea ta dekenai, iena ladana be Ramese, Farao ia hereva bamona. ");
INSERT INTO hmo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Vadaeni Iosepa ese iena tamana bona iena tadikakana taudia bona iena tamana ena orea taudia ibounai dekenai aniani ia henia, edia ruma ta ta dekenai, taunimanima idia momo hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Hitolo nega ia bada herea dainai, tano ibounai be aniani lasi momokani. Unai dainai Aigupito bona Kanana taudia be hitolo dainai idia manoka. ");
INSERT INTO hmo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Moni ibounai Aigupito dekenai bona Kanana dekenai be uiti hoia dekenai ia ore. Unai moni ibounai be Iosepa ena imana dekenai, vadaeni ia ese Farao ena ruma dekenai ia haboua. ");
INSERT INTO hmo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Aigupito dekenai bona Kanana dekenai moni ia ore momokani murinai, Aigupito taudia idia lao Iosepa dekenai, idia gwau, “Aniani ai dekenai oi henia. Oi ura ai be oiemu vairana dekenai ai mase, a? Ai be moni lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Iosepa ia haere, ia gwau, “Umui emui boromakau umui henia lau dekenai, vadaeni uiti do lau henia umui dekenai, umui emui boromakau edia davana. Badina umui dekenai moni ia noho lasi dainai.” ");
INSERT INTO hmo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Unai dainai idia edia boromakau idia abia lao Iosepa dekenai. Vadaeni ia ese aniani ia henia idia dekenai, edia hosi bona mamoe bona boromakau bona doniki edia davana. ");
INSERT INTO hmo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Unai lagani ia ore, vadaeni ma lagani gabeai idia giroa mai Iosepa dekenai, idia gwau, “Lohia tauna e, ai koikoi lasi oi dekenai, aiemai moni ia ore vadaeni. Aiemai boromakau ibounai oi abia vadaeni, gau ta ia noho lasi do ai henia oi dekenai. Aiemai tauanina bona aiemai tano sibona mo ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ai be oiemu vairana dekenai do ai mase, a? Aiemai uma tano be do ia dika momokani, a? Ai bona aiemai tano do oi abia, bona aniani do oi henia ai dekenai, vadaeni ai be Farao ena hesiai taudia davana lasi do ai lao, bona aiemai tano do ia abia, do ia biagua. Ma uhe do oi henia ai dekenai, vadaeni do ai mase lasi, bona aiemai tano do ia dika lasi.” ");
INSERT INTO hmo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Vadaeni Iosepa ese Aigupito ena tano ibounai ia abia Farao ena. Badina be Aigupito taudia ibounai ta ta edia uma tano idia hoia, aniani ena davana, edia hitolo ia bada dainai. Unai bamona dala dekenai tano ibounai be Farao ena tano dekenai idia halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Iosepa ese Aigupito taudia ibounai, hesiai taudia davana lasi ia halaoa, Aigupito dokona kahana ela bona dokona. ");
INSERT INTO hmo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","To Iosepa ese hahelagaia taudia edia tano be ia hoia lasi. Edia tano idia dogoatao noho, badina hahelagaia taudia be Farao ese ia ubudia. ");
INSERT INTO hmo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Vadaeni Iosepa ese taunimanima dekenai ia hamaoroa, ia gwau, “Hari dina umui bona umui emui tano lau hoia vadaeni Farao ena. Uhe be inai, vadaeni umui hadoa. ");
INSERT INTO hmo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Vadaeni uiti umui utua neganai, umui haria kahana 5 dekenai. Kahana ta Farao dekenai do umui henia. Orena kahana 4 be umui emui hadoa bona ania gaudia, umui emui ruma taudia bona umui emui natuna maragidia do umui ubua totona.” ");
INSERT INTO hmo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Vadaeni idia haere henia Iosepa dekenai, idia gwau, “Lohia e, oi ese mauri oi henia vadaeni ai dekenai, kara namo oi karaia vadaeni ai dekenai, bona Farao ena hesiai taudia davana lasi do ai lao.” ");
INSERT INTO hmo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Vadaeni unai bamona taravatu Iosepa ia atoa Aigupito tano dekenai. Unai taravatu be do ia noho ia mai bona harihari, kahana 5 edia lalonai kahana ta be Farao ena, to Farao ese hahelagaia taudia edia tano ia abia lasi. ");
INSERT INTO hmo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israela taudia be Aigupito taudia edia huanai idia noho Gosena dekenai. Unuseni kohu momo idia haboua, bona natuna momo idia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iakobo be lagani 17 Aigupito dekenai ia noho, iena mauri lagani ibounai be 147. ");
INSERT INTO hmo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Iena mase ia kahirakahira neganai, iena natuna Iosepa dekenai ia boiria. Ia gwau, “Mani emu kara, oiemu imana lauegu mamuna henunai do oi atoa. Vadaeni mai momokani danu do oi gwauhamata inai kara namona do oi karaia, lau oi lalokau henia toana: Aigupito dekenai lau do oi guria lasi. ");
INSERT INTO hmo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","To lauegu tubuna bona lauegu tamana idia noho gabuna dekenai do oi guria lau. Aigupito dekena amo lau oi abia lao, bona tubugu bona tamagu edia guria gabuna dekenai do oi guria lau.” Vadaeni Iosepa ia gwau, “Oiemu ura hegeregere dohore lau karaia.” ");
INSERT INTO hmo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Vadaeni Iakobo ia gwau, “Oi gwauhamata.” Vadaeni Iosepa ia gwauhamata henia ia dekenai, bona unai neganai Israela ese iena mahuta pata dekenai iena kwarana ia atoa diho. ");
INSERT INTO hmo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Inai murinai Iosepa ese hereva ia kamonai iena tamana ia gorere, vadaeni ia ese iena natuna ruaosi Manase bona Eparaima ia hakaudia lao Iakobo dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Vadaeni haida ese Iakobo dekenai idia hamaoroa, idia gwau, “Oiemu natuna Iosepa be oi itaia totona ia mai inai.” Vadaeni Israela ese iena lalona ia hagoadaia, iena mahuta pata dekenai ia helai. ");
INSERT INTO hmo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Vadaeni Iakobo ese Iosepa dekenai ia hereva henia, ia gwau, “Siahu Ibounai Dirava ese Lusu dekenai Kanana tano dekenai ia sibona ia hedinaraia lau dekenai, bona ia hanamoa lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ia gwau, ‘Momokani lau ese natuna bona tubuna momo do lau henia oi dekenai, idia be bese momo do lau halaoa. Inai tano danu do lau henia idia dekenai, idia edia tano do ia lao, ela bona hanaihanai.’ ");
INSERT INTO hmo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Oiemu natuna ruaosi, oi dekenai do lau mai lasi neganai inai Aigupito dekenai idia vara memero be lauegu. Manase bona Eparaima be lauegu natuna, Rubena bona Simeona hegeregere. ");
INSERT INTO hmo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","To idia edia murinai oi dekenai do idia vara memero be oiemu natuna korikori. Vadaeni gabeai Israela ena tano idia haria neganai, inai oiemu natuna ese edia kahana be Manase bona Eparaima dekena amo edia ahuna do idia abia. ");
INSERT INTO hmo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Lau ura inai bamona, badina lau be Mesopotamia dekena amo lau mai neganai, oiemu sinana Rahela be dala dekenai ia mase, Kanana tano dekenai, Eparata do ai ginidae lasi neganai, vadaeni Eparata dala ena badinai lau guria. Egu lalona ia hisihisi bada herea.” Eparata ena ladana ta be Betelehema. ");
INSERT INTO hmo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Vadaeni Israela ese Iosepa ena natuna ia itadia, ia gwau, “Inai be daika?” ");
INSERT INTO hmo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Iosepa ese iena tamana dekenai ia haere, ia gwau, “Idia be lauegu natuna, Dirava ese lau dekenai ia henia vadaeni, inai Aigupito tano dekenai.” Israela ia gwau, “Oi mailaidia kahirakahira. Vadaeni do lau hanamoa idia dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israela ia buruka vadaeni, unai dainai iena matana idia diburadibura, gau ia itaia namonamo lasi. Iosepa ese memero ruaosi ia abia lao kahirakahira ia dekenai. Vadaeni Iakobo ia kisi henia idia dekenai, bona idia ia rosia. ");
INSERT INTO hmo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Vadaeni Israela ese Iosepa dekenai ia hamaoroa, ia gwau, “Guna lau laloa be oiemu vairana do lau itaia lou lasi. To Dirava ia bogahisihisi lau dekenai, unai dainai oi bona oiemu natudia lau itaia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Vadaeni Iosepa ese memero ruaosi edia tubuna ena tuina dekena amo ia abidia. Vadaeni Iosepa be iena vairana ia atoa diho tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Vadaeni Iosepa ese ruaosi ia abidia edia imana dekenai. Eparaima be iena idiba kahana dekenai, Israela ena lauri kahana dekenai do ia noho totona, bona Manase be iena lauri kahana dekenai, Israela ena idiba kahana dekenai do ia noho totona. Israela kahirakahira dekenai ia abidia lao. ");
INSERT INTO hmo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","To Israela ese iena imana idibana ia atoa gabeai ia vara mero ladana Eparaima ena kwarana dekenai, bona iena imana laurina ia atoa Manase, guna ia vara mero ena kwarana dekenai. Israela be mai ena laloa ta dainai inai bamona ia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Vadaeni Israela ese ia hanamodia, ia gwau: “Lauegu tubuna Aberahamo, bona lauegu tamana Isako idia tomadiho henia Diravana, ia ese inai memero do ia hanamodia. Egu mauri dina ibounai ia mai bona harihari lau ia naria Diravana, ia ese do ia hanamodia. ");
INSERT INTO hmo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Dika ibounai dekena amo lau ia hamauria vadaeni aneru, ia ese inai memero dekenai hanamoa dohore ia henia. Vadaeni lauegu ladana, bona egu tubuna Aberahamo ena ladana, bona egu tamana Isako ena ladana, do idia abia noho, nega ibounai. Natuna momo do idia abia, bona bese badana do idia lao.” ");
INSERT INTO hmo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","To Iosepa ia itaia, iena tamana ena imana idibana be Eparaima ena kwarana dekenai ia atoa, vadaeni iena lalona ia hisihisi. Bona Iosepa ese iena tamana ena imana ia abia, Manase ena kwarana dekenai ia atoa gwauraia. ");
INSERT INTO hmo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Iosepa ia gwau, “Tamagu e, unai bamona lasi. Badina Manase be guna ia vara merona, oiemu imana idibana be iena kwarana dekenai do oi atoa.” ");
INSERT INTO hmo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","To iena tamana be ia ura lasi, ia gwau, “Natugu e, lau diba dekenai lau karaia. Momokani ia be bese ta do ia havaraia. To iena tadina ese dohore ia hereaia, bese badadia momo dohore ia havaraia.” ");
INSERT INTO hmo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Unai dainai unai dina dekenai Iakobo ese hanamoa ia henia idia dekenai, ia gwau: “Israela taudia ese Dirava dekenai do idia noinoi, ia ese idia do ia hanamoa, umui ia hanamoa hegeregere. Dohore idia gwau, ‘Dirava ese Eparaima bona Manase bamona, umui do ia halaoa namo.’ ” Inai bamona dala dekenai Eparaima ia atoa guna, Manase ia atoa gabeai. ");
INSERT INTO hmo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Vadaeni Israela ese Iosepa dekenai ia hamaoroa, ia gwau, “Lauegu mase be ia kahirakahira vadaeni, to Dirava ese do ia hanamoa umui, bona do ia hakaua umui, vadaeni emui tubuna tamana edia tano dekenai do umui ginidae. ");
INSERT INTO hmo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Harihari gauna ta danu do lau henia oi, Sekema tano unai, to oiemu tadikakana ibounai be lasi. Amoro taudia dekena amo lau abia, lauegu tuari kaia bona peva ena goada dekena amo.” ");
INSERT INTO hmo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Vadaeni Iakobo ese iena natuna ia boiridia, ia gwau, “Ibounai do umui haboua. Umui dekenai dahaka dahaka do ia vara nega gabeai do lau hamaoroa umui dekenai: ");
INSERT INTO hmo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Iakobo ena natuna e, umui mai kahirakahira. Umui emui tamana Israela ena hereva umui kamonai. ");
INSERT INTO hmo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubena, oi be lauegu natuna ginigunana, lauegu goada ena anina ginigunana. Lauegu natuna ibounai edia huanai, oiemu hekokoroku bona siahu be ia bada momokani. ");
INSERT INTO hmo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","To oiemu kara be ranu ia boila bamona, unai dainai dohore oi be bada lasi, badina be oiemu tamana ena adavana ta oi sihari henia. Lauegu headava geda oi hamiroa, egu geda dekenai oi lao. ");
INSERT INTO hmo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeona bona Levi be boga tamona dekena amo idia vara, bona idia edia kaia dekenai taunimanima idia hadikaia. ");
INSERT INTO hmo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Idia edia herevahereva, hunia dala dekenai idia karaia gauna, be do lau gwauraia maoro lasi. Idia edia hebou dekena amo do lau raka siri, badina be idia badu neganai taunimanima idia alaia mase. Bona idia edia ura kava dekenai, boromakau edia aena idia haberoa, idia raka diba lasi. ");
INSERT INTO hmo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Simeona bona Levi edia badu lau hadikaia inai, badina edia badu be auka momokani, bona edia dagedage danu lau hadikaia inai, badina be ia dika momokani. Iakobo ena tano ibounai dekenai, edia bese dohore lau makohia maragimaragi. Israela taudia edia huanai dekena amo, dohore lau siaidia kava, gabu idauidau dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Iuda e, oiemu tadikakana taudia ese, oiemu ladana do idia hanamoa. Oiemu imana dekena amo oi dekenai idia dagedage taudia, be oi ese edia aiona dohore oi dogoatao. Oiemu tamana ena natuna ese, dohore idia tomadiho henia oi dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iuda be laiona ena natuna hegeregerena. Iena vamu ia alaia murinai, ia giroa lou iena hunia gabu dekenai. Iuda be laiona bamona, ia hekure diho, to alaia totona ia hegaegae noho. Tau ta ese do ia hamarerea lasi, do ia badu garina. ");
INSERT INTO hmo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kepata, lohia ena toana, be Iuda ese do ia dogoatao, bona haida ese do idia kokia lasi. Iena king siahu do ia dogoatao noho, ela bona siahu momokani ena biaguna, Silo, do ia mai. Vadaeni ia dekenai bese ibounai ese, dohore idia kamonai henia. ");
INSERT INTO hmo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Iena doniki be vain ena auna dekenai, dohore ia kwatua, vain ena auna namo herea dekenai dohore ia kwatua. Iena dabua be uaina dekenai dohore ia huria, uaina kakakaka momokani dekenai dohore ia huria. ");
INSERT INTO hmo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Iena matana dohore idia kakakaka, uaina ia inua dainai. Iena isena dohore idia kurokuro, rata ia inua dainai. ");
INSERT INTO hmo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebuluno be kone dekenai dohore ia noho. Lagatoi idia kamokau gabuna namona do idia halaoa. Iena tano ena hetoa gabudia, be do idia lao Sidono ena tano badibadinai. ");
INSERT INTO hmo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakara be doniki mai goada danu, to iena maduna huanai ia hekure noho. ");
INSERT INTO hmo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ia itaia, iena laga-ani gabuna be ia namo, unai tano ena toana be ia namo herea. Vadaeni ia be kohu huaia tauna do ia lao, bona hesiai tauna davana lasi, gaukara auka tauna, be haida ese do idia halaoa. ");
INSERT INTO hmo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dano ese iena iduhu taudia dekenai, kota do ia henia, bona Israela ena iduhu haida hegeregere do idia noho. ");
INSERT INTO hmo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dano be gaigai, dala badinai ia noho, gaigai, mase gauna, dala badinai do ia noho. Hosi ena aena be do ia koria, vadaeni hosi dekenai guia tauna, be ia moru murina kahana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Lohiabada e, oiemu hamauria dekenai lau naria noho. ");
INSERT INTO hmo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gado be dadia taudia orea ta ese, do idia tuari henia, to ia ese do ia heatu henidia bona luludia. ");
INSERT INTO hmo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asere ena tano dekenai, aniani namodia do idia vara. Aniani hegeregere king do ia ania, be Asere do ia henia. ");
INSERT INTO hmo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Napatali be dia hahine bamona, iena ura gabuna dekenai ia heau noho, vadaeni iena natuna namodia momokani ia havaraia. ");
INSERT INTO hmo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Iosepa be doniki mai dagedage danu bamona, doniki mai dagedage danu, ranu gabuna badinai ia noho. Ia ese ororo ohena dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Labana taudia idia heatu henia mai dagedage danu. Edia diba bona peva dekena amo idia lulua lao. ");
INSERT INTO hmo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","“To Iosepa idia tuari henia taudia edia peva, be Dirava ese ia makohia. Edia imana varovaro Dirava ese ia darea. Iakobo ena Siahu Ibounai Diravana ese idia ia darea, Mamoe Naria Tauna, Israela ena Nadi ena siahu dekena amo. ");
INSERT INTO hmo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Oiemu tamana ena Dirava ese oi ia durua noho. Siahu Ibounai ena Dirava, ia ese oi ia hanamoa noho. Inai bamona hanamoa be Iosepa do ia davaria: Medu ena namo guba dekena amo, ma tano henunai dekena amo ranu dobu ena namo. Rata ena namo, bona bogana ese natuna ia havaraia ena namo danu. ");
INSERT INTO hmo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Oiemu tamana ena hanamoa be bada. Iena hanamoa ese, oiemu sene taudia edia hanamoa ia hereaia. Noho hanaihanai ororo edia daudau be bada, to oiemu tamana ena hanamoa be bada herea, bona Iosepa ena kwarana dekenai, do idia kamokau. Iena tadikakana edia huanai, Dirava ese ia abia hidi tauna Iosepa, be ia hanamoa bada herea noho. ");
INSERT INTO hmo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Beniamina be uda sisia, vamu ia alaia bamona. Dabai iena vamu ia alaia gauna ia ania, ma adorahi neganai ia alaia gaudia ia haria karaia noho.” ");
INSERT INTO hmo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Israela ena iduhu 12 be inai. Idia edia tamana ena hanamoa herevadia be inai. Idia ta ta dekenai hanamoa ia henia, edia kara hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Vadaeni Iakobo ese ia hamaorodia, ia gwau, “Do lau mase, lauegu bese ena mase taudia dekenai do lau haboua. Lauegu tamana bona lauegu tubuna edia badibadinai do umui guria lau, nadi matuna lalonai, Eparona, Hiti tauna ena tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Unai nadi matuna ia noho Makapela dekenai. Inai gabu be Mamare ena dina ia daekau ena kahana dekenai, Kanana tano dekenai. Aberahamo ese Eparona, Hiti tauna dekena amo ia hoia, iena guria gabu dekenai do ia halaoa totona. ");
INSERT INTO hmo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Unuseni Aberahamo mai ena adavana Sara danu idia guria, bona Isako mai ena adavana Rebeka danu idia guria, bona unai guria gabuna dekenai Lea danu lau guria. ");
INSERT INTO hmo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nadi matuna be unai, mai ena tano danu, Hiti tauna dekena amo Aberahamo ese ia hoia.” ");
INSERT INTO hmo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Iakobo ena hereva ia hadokoa, vadaeni iena mahuta pata dekenai ia hekure diho, iena laumana ia henia daekau, bona iena tubuna tamana dekenai ia haboua lao. ");
INSERT INTO hmo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Iosepa ese iena tamana ena vairana dekenai iena kwarana ia atoa diho, ia tai, bona ia kisi henia. ");
INSERT INTO hmo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Vadaeni Iosepa ese iena hesiai taudia haida, muramura gaukara idia diba taudia ia hamaorodia, iena tamana ena tauanina do idia hagoevaia. Muramura mai bonana namo dekena amo do idia dahua, ia bodaga haraga lasi totona, bona dabua aukana dekenai do idia kumia, vadaeni unai bamona idia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dina 40 ia ore, muramura taudia edia gaukara edia nega be unai, vadaeni Aigupito taudia ese dina 70 idia taitai Iakobo dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Taitai dinana idia ore, vadaeni Iosepa ese Farao ena ruma taudia dekenai ia noinoi, ia gwau, “Bema umui ura henia lau dekenai, vadaeni Farao dekenai do umui hereva, umui gwau, ");
INSERT INTO hmo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Lauegu tamana be kahirakahira ia mase neganai, ia hereva henia lau dekenai dainai, lau gwauhamata henia ia dekenai. Ia gwau: “Dohore lau mase neganai, guria gabuna, lau hegaegae guna vadaeni gauna, unuseni dohore umui guria lau, Kanana tano dekenai.” Unai dainai, mani emu kara, lau ura lau lao, lauegu tamana do lau guria, vadaeni dohore lau giroa mai.’ ” ");
INSERT INTO hmo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Vadaeni Farao ia gwau, “Oi lao. Oiemu tamana do oi guria, oiemu gwauhamata bamona.” ");
INSERT INTO hmo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Vadaeni Iosepa ia toreisi, iena tamana guria totona ia lao, Farao ena hesiai taudia, bona iena ruma badana ena tau badadia, bona Aigupito ena lohia taudia ibounai ia danu idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Bona Iosepa ena varavara taudia ibounai, bona iena tadikaka taudia, bona iena tamana ena bese taudia danu idia lao. Edia natuna marigidia, bona edia mamoe ibounai bona edia boromakau ibounai, unai sibona idia rakatania Gosena tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Haida be kariota dekenai idia guia, haida be hosi dekenai, taunimanima momo herea be Iosepa danu idia lao. ");
INSERT INTO hmo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Gabu ta, ena ladana Atada dekenai idia ginidae, Ioridane Sinavai ena dina ia daekau kahanai. Unai Atada be uiti dekena amo momoru kokia gabuna. Unuseni Iakobo totona taitai gaukara ibounai idia karaia, mai lalohisihisi bada. Iosepa ese dina 7 ia taitai iena tamana totona. ");
INSERT INTO hmo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Unai tano taudia, Kanana taudia, ese idia edia lalohisihisi idia itaia Atada dekenai. Vadaeni idia gwau, “Aigupito taudia edia taitai be ia bada herea.” Unai dainai unai gabu ena ladana idia atoa, Abela Miseraimi, ena anina be, “Aigupito taudia edia taitai gabuna.” Inai gabu be Ioridane Sinavai ena dina ia daekau kahanai. ");
INSERT INTO hmo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Vadaeni Iakobo ena natuna ese guna ia ese idia ia hamaoroa hegeregerena idia karaia. ");
INSERT INTO hmo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kanana tano dekenai idia huaia lao, nadi matuna lalonai idia guria, Makapela ena tano dekenai. Unai nadi matuna bona tano be Aberahamo ese Eparona, Hiti tauna dekena amo guna ia hoia vadaeni, iena guria gabuna totona, Mamare ena dina ia daekau ena kahana dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Vadaeni iena tamana ia guria murinai, Iosepa mai ena tadikakana taudia bona ia danu idia lao taudia idia giroa lou Aigupito dekenai. ");
INSERT INTO hmo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Edia tamana ia mase murinai, Iosepa ena kakana be idia sibona idia herevahereva, idia gwau, “Sedira Iosepa be ia badu noho ita dekenai. Vadaeni ia dekenai kara dika ita karaia ena davana sedira do ia henia ita dekenai.” ");
INSERT INTO hmo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Unai dainai idia ese hereva ta idia siaia lao Iosepa dekenai, idia gwau, “Oiemu tamana do ia mase lasi neganai, ia hamoroa ai dekenai, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Iosepa dohore umui hamaoroa, umui gwau: Oiemu kakana taudia edia kerere bona kara dika oi dekenai do oi laloaboio.’ Unai dainai ai noinoi oi dekenai, mani emu kara, oiemu tamana ena Dirava ena hesiai taudia aiemai dika do oi laloa noho lasi.” Inai hereva ia kamonai neganai Iosepa ia tai. ");
INSERT INTO hmo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Vadaeni iena kakana taudia idia lao Iosepa ena vairana dekenai, edia vairana idia atoa diho tano kahirakahira dekenai, idia gwau, “Ai be oiemu hesiai taudia, davana lasi, be namo.” ");
INSERT INTO hmo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","To Iosepa ia gwau, “Umui gari lasi. Lau be Dirava, emui kerere davana do lau henia, a? ");
INSERT INTO hmo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Momokani, guna umui laloa karaia, lau do umui hadikaia gwauraia, to Dirava ese emui kara ena anina be, mai namo danu ia havaraia. Unai kara ena anina be hari dina umui itaia inai, taunimanima momo herea edia mauri dekenai durua lau henia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Unai dainai, umui gari lasi. Dohore lau naria umui, bona umui emui natuna danu dohore lau naridia.” Vadaeni hereva namo dekenai edia gari ia kokia, bona edia lalodia be maino idia abia. ");
INSERT INTO hmo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Iosepa bona ena tamana ena iduhu taudia ibounai be Aigupito dekenai idia noho, bona Iosepa ia mase neganai iena mauri lagani ibounai be 110. ");
INSERT INTO hmo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Iosepa ese Eparaima ena tubuna ena natuna ia itadia, bona Makiri Manase ena natuna idia vara neganai, be Iosepa ese iena bese lalonai ia haboudia. ");
INSERT INTO hmo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Vadaeni Iosepa ese iena kakana taudia ia hamaorodia, ia gwau, “Lauegu mase neganai ia ginidae vadaeni. To Dirava ese do ia laloa umui, bona inai tano dekena amo do ia hakaua umui, ia lao bona iena gwauhamata tano dekenai do umui ginidae. Unai tano be Dirava ese ia gwauhamata Aberahamo, bona Isako bona Iakobo dekenai do ia henia.” ");
INSERT INTO hmo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Vadaeni Iosepa ese Israela ena natuna ia hamaorodia, ia gwau, “Lau dekenai do umui gwauhamata, Dirava ese umui do ia durua neganai, lauegu turiana be inai gabu dekena amo do umui kokia, bona umui danu, lauegu turiana be unai gwauhamata tano dekenai do umui abia lao.” ");
INSERT INTO hmo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Vadaeni Iosepa be ia mase, iena mauri lagani ibounai be 110, vadaeni idia ese iena tauanina idia hagoevaia, muramura dekena amo idia dahua, ia bodaga haraga lasi totona, vadaeni maua dekenai idia udaia Aigupito dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Iakobo ena natuna Aigupito dekenai idia lao taudia be inai, idia be ta ta mai edia ruma taudia Iakobo danu idia lao. ");
INSERT INTO hmo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Edia ladana be inai: Rubena, Simeona, Levi, Iuda, ");
INSERT INTO hmo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakara, Sebuluno, Beniamina, ");
INSERT INTO hmo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dano, Napatali, Gado, Asere. ");
INSERT INTO hmo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Iakobo ena bese ibounai, taunimanima be 70. Iosepa ese Aigupito dekenai ia noho guna, gabeai idia mai ia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Gabeai Iosepa ia mase, iena tadikakana taudia bona iena nega taudia ibounai danu idia mase. ");
INSERT INTO hmo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","To Israela taudia ese idia edia natuna momo herea idia havaraia. Idia edia bese ia bada ia lao, bona mai goada danu, Gosena tano idia hahonua momokani. ");
INSERT INTO hmo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","King matamata tauna ese Aigupito dekenai ia lohia karaia. Ia be Iosepa ena sivarai ia diba lasi. ");
INSERT INTO hmo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Iena orea taudia dekenai ia hamaoroa, ia gwau, “Umui kamonai, Israela taudia be momo herea, bona mai goada danu. Ita naria namonamo, ita be goada lasi idia dekenai garina. ");
INSERT INTO hmo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Do ita itadia namonamo, bona dohore idia momo herea garina, edia dala ita koua be namo. Badina be tuari ia mai neganai, sedira do idia toreisi. Ita dekenai tuari henia taudia dohore idia durua, bona dohore idia tuari henia ita dekenai, bona iseda tano dohore idia rakatania garina.” ");
INSERT INTO hmo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Unai dainai ia ese gaukara biaguna taudia ia atodia, idia ese unai Israela gaukara karaia taudia naria totona, mai dagedage danu. Vadaeni gaukara momo dekena amo hisihisi idia henia Israela taudia dekenai. Vadaeni Israela taudia ese hanua rua idia haginia, Farao ena aniani haboua gabudia, edia ladana be Pitoma bona Ramese. ");
INSERT INTO hmo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Israela taudia dekenai gaukara momo Aigupito taudia ese idia henia nega ibounai, to idia edia besena be ia habadaia noho, ia lao bona Gosena tano ibounai ia honu momokani. Vadaeni Aigupito taudia be idia gari noho Israela taudia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Unai dainai Aigupito taudia ese Israela taudia be hesiai taudia davana lasi idia halaoa, mai dagedage danu. ");
INSERT INTO hmo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Israela taudia edia noho be ia dika. Gaukara metau herea idia karaia, bona raro dekena amo biriki nadi idia karaia, ma inai nadi ena semenisi bamona gauna danu idia karaia. Gaukara idauidau ibounai idia karaia, ruma haginia, bona uma gaukara ibounai danu. Aigupito taudia ese Israela taudia idia dagedage henidia dainai, hesiai gaukara idauidau ibounai karaia dekena amo idia hekwarahi momo. ");
INSERT INTO hmo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Vadaeni Aigupito ena king ese Heberu edia natuna havaraia neganai durua henia hahine taudia, edia ladana be Sipora bona Pua, dekenai ia hereva. ");
INSERT INTO hmo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Ia gwau, “Umui ruaosi Heberu hahine taudia umui itaia, idia natuna matamata havaraia neganai, bema mero ia vara, umui alaia. Bema kekeni ia vara, umui alaia lasi, do ia mauri.” ");
INSERT INTO hmo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","To inai durua henia hahine taudia ese Dirava dekenai idia gari, inai dainai Aigupito ena king ena hereva idia badinaia lasi, edia natuna memero idia vara neganai, idia hamauria. ");
INSERT INTO hmo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Unai dainai Aigupito ena king ese ia boiboi unai durua henia hahine taudia dekenai, ia henanadaia, ia gwau, “Dahaka totona inai bamona umui karaia? Dahaka totona edia natuna memero umui hamauria vadaeni?” ");
INSERT INTO hmo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Inai durua henia hahine ese idia haere henia Farao dekenai, idia gwau, “Badina be Heberu hahine taudia be Aigupito hahine taudia bamona lasi. Idia be mai goada, vadaeni durua henia hahine taudia do idia ginidae lasi neganai, idia sibona edia natuna idia havaraia guna.” ");
INSERT INTO hmo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Unai dainai Dirava ia hanamoa inai durua henia hahine taudia dekenai, bona Heberu ena bese ia momo herea noho, bona ia goada noho. ");
INSERT INTO hmo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Inai durua henia hahine taudia ese idia matauraia Dirava dekenai, unai dainai Dirava ese edia natuna ia henidia. ");
INSERT INTO hmo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Vadaeni Farao ese iena orea taudia dekenai ia hereva henia mai goada danu. Ia gwau, “Heberu edia natuna mero matamata ibounai be sinavai dekenai do umui negea. To kekeni be do idia mauri.” ");
INSERT INTO hmo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Tau ta, Levi iduhu ena tauna, ese Levi iduhu kekeni ta ia adavaia. ");
INSERT INTO hmo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Inai hahine ia rogorogo, mero ta ia vara. Ia itaia ia be mero namo herea momokani. Vadaeni ia hunia hua toi. ");
INSERT INTO hmo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ia hunia dala be lasi neganai, bosea ta ia abia, inai mero ena, vadaeni pisi dekena amo bosea ia koua namo herea. Vadaeni mero ia udaia bosea ena lalona dekenai, sinavai dekenai ia atoa, siriho edia huanai. ");
INSERT INTO hmo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mero ena taihuna be sisina daudau ia gini noho, iena taihuna maragina dekenai dahaka do ia vara itaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Farao ena natuna hahine ia lao, sinavai dekenai ia digu gwauraia. Iena hesiai kekeni be sinavai badibadina dekenai idia loaloa noho. Ia ese bosea ia itaia, siriho edia huana dekenai. Iena kekeni ta ia siaia, bosea do ia mailaia. ");
INSERT INTO hmo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Bosea ia kehoa, mero ia itaia, ia hoa. Mero maragi madi ia tai noho. Vadaeni ia bogahisihisi henia, ia gwau, “Inai be Heberu hahine ta ena natuna.” ");
INSERT INTO hmo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Vadaeni inai natuna ena taihuna ese Farao ena natuna hahine dekenai ia raka, ia hereva, ia gwau, “Lau lao, ani? Heberu hahine ta dohore lau davaria, ia ese mero do ia ubua.” ");
INSERT INTO hmo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Farao ena natuna hahine ese ia haere henia kekeni dekenai, ia gwau, “Oi lao.” Vadaeni kekeni ia lao, mero ena sinana ia boiria. ");
INSERT INTO hmo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Vadaeni Farao ena natuna hahine ese ia hereva henia mero ena sinana dekenai, ia gwau, “Inai mero oi abia lao, do oi ubua lauegu. Lau ese iena davana do lau henia oi dekenai.” Vadaeni iena sinana ese mero ia abia lao, ia ubua. ");
INSERT INTO hmo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mero ia tubu daekau noho, vadaeni inai hahine ese ia abia lao Farao ena natuna hahine dekenai. Vadaeni king Farao ena natuna hahine ese mero be iena natuna ia halaoa, ia ese iena ladana ia atoa Mose, ia gwau, “Badina be ranu dekena amo lau abia isi.” ");
INSERT INTO hmo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Dina ta, Mose ia tau neganai, ia raka lao iena varavara taudia dekenai, idia edia hekwarahi ia itaia. Vadaeni ia ese Aigupito tauna ta ia itaia, Heberu tauna, iena varavara tauna ta ia botaia noho. ");
INSERT INTO hmo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mose ese kahana kahana ibounai ia itaia, tau ta ia itaia lasi, vadaeni ia ese Aigupito tauna ia alaia mase, miri dekenai ia hunia. ");
INSERT INTO hmo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kerukeru ma ia giroa lao, Heberu taudia rua ia itaia, idia heatu. Vadaeni, ia ese heatu hamatamaia tauna dekenai ia gwau henia, ia gwau, “Badina be dahaka, oiemu bese tamona tauna oi botaia noho?” ");
INSERT INTO hmo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ia ese ia haere, ia gwau, “Daika ese aiemai lohia, bona aiemai kota karaia tauna dekenai ia halaoa oi? Oiemu ura be, oi alaia mase lau, Aigupito tauna oi alaia mase bamona a?” Vadaeni Mose ia gari, ia gwau, “Lau karaia gauna be taunimanima idia diba vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Farao ese inai kara ena sivarai ia kamonai neganai, ia ura be Mose ia alaia mase gwauraia, to Mose ese Farao dekena amo ia heau, ia lao, Midiana tano dekenai ia noho gwauraia. Ia ginidae neganai be ranu guri ta ena badibadinai ia helai noho. ");
INSERT INTO hmo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midiana ena dubu helaga tauna be mai ena natuna hahine 7. Vadaeni idia mai, ranu idia utua, edia tamana ena mamoe bona nani ibounai dekenai ranu idia henia gwauraia. ");
INSERT INTO hmo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","To mamoe naria taudia haida idia mai, inai hahine taudia idia lulua idau gabu dekenai. Mose ese ia itaia, vadaeni ia toreisi, ia durua hahine taudia dekenai. Edia mamoe dekenai ranu ia henidia. ");
INSERT INTO hmo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Vadaeni edia tamana Ietero dekenai idia giroa lou neganai, ia henanadaia idia dekenai, ia gwau, “Edena bamona hari dina umui giroa mai haraga vadaeni?” ");
INSERT INTO hmo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Idia haere, idia gwau, “Aigupito tauna ta ese ia durua ai dekenai, mamoe naria taudia ia koua, ranu ia utua, ia henia ai dekenai, bona aiemai mamoe dekenai danu ranu ia henia.” ");
INSERT INTO hmo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ietero ese iena natuna hahine taudia dekenai ia gwau henia, ia gwau, “Inai tau be edeseni? Dahaka totona umui rakatania? Umui lao, umui boiria, ia mai aniani ita danu.” ");
INSERT INTO hmo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Vadaeni Mose be unai tau Ietero dekenai ia noho, mai moale danu. Ietero ese iena natuna kekeni ta, ena ladana be Sipora, be Mose dekenai ia henia, ia adavaia. ");
INSERT INTO hmo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Inai hahine ese iena natuna ta ia havaraia, vadaeni Mose ese mero ena ladana ia atoa Geresome, ena anina be “idau tano dekenai noho,” badina be Mose ia gwau, “Lau be tano idau dekenai, bona taunimanima idau danu lau noho.” ");
INSERT INTO hmo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Lagani momo murinai, Aigupito ena king, Farao, ia mase. To Israela taudia idia taitai noho, mai lalohisihisi danu, gaukara metau momokani idia karaia noho dainai. Idia taitai Dirava dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Idia edia taitai Dirava ese ia kamonai, bona iena gwauhamata, Aberahamo bona Isako bona Iakobo dekenai ia gwauhamata henia gauna ia laloa. ");
INSERT INTO hmo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Vadaeni Dirava ese Israela taudia dekenai ia itaia, bona edia hisihisi ia laloa noho. ");
INSERT INTO hmo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose ese iena ravana Ietero, Midiana ena hahelagaia tauna ena mamoe bona nani ia naria. Ia ese mamoe ia hakaudia lao taunimanima idia noho lasi gabuna, dina ia diho kahana dekenai. Dirava ena ororo ena ladana Sinai dekenai ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Vadaeni Lohiabada ena aneru ese Mose dekenai ia hedinaraia, lahi ia araia dekena amo. Lahi be au ginigini dekenai, Mose ese ia itaia. Au dekenai lahi ia noho, to lahi ese au ia gabua ore lasi. ");
INSERT INTO hmo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Vadaeni Mose ia gwau, “Do lau raka siri, inai kara be ia idau, dohore lau itaia, au ginigini be edena bamona lahi ese ia gabua ore lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Dirava ese Mose ia itaia, ia mai kahirakahira. Vadaeni Dirava ese au ginigini dekena amo ia boiboi Mose dekenai, ia gwau, “Mose e, Mose e.” Ia haere, ia gwau, “Lau inai.” ");
INSERT INTO hmo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Dirava ia gwau, “Oi mai kahirakahira lasi. Oiemu tamaka danu oiemu aena dekena amo oi kokia, badina be oi gini noho gabuna, inai tano be ia helaga.” ");
INSERT INTO hmo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ma ia gwau, “Lau be oiemu tamana ena Dirava, Aberahamo ena Dirava, Isako ena Dirava, Iakobo ena Dirava.” Vadaeni Mose ese iena vairana ia koua, Dirava do ia itaia garina. ");
INSERT INTO hmo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Lohiabada ma ia gwau, “Momokani, lauegu bese taudia edia hisihisi Aigupito dekenai lau itaia vadaeni. Edia biagudia ese hekwarahi idia henidia noho dainai idia taitai, be lau kamonai vadaeni, badina be edia hisihisi lau diba vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Lau diho mai inai, Aigupito taudia edia imana dekena amo do lau hamauridia totona. Unai tano dekena amo dohore lau hakaudia, ia lao bona tano namo herea dekenai. Tano badana dekenai dohore idia ginidae. Unai tano be aniani namodia gabuna, Kanana taudia edia tano unai, Hiti taudia edia, bona Amoro taudia edia, bona Perisi taudia edia, bona Hivi taudia edia, bona Iebusu taudia edia. ");
INSERT INTO hmo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","“Momokani, Israela taudia edia taitai be lau dekenai ia mai vadaeni. Bona Aigupito taudia ese hisihisi kara ibounai idia henia, lau itaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Oi mai, dohore lau siaia oi Farao dekenai, lauegu bese taudia Israela be Aigupito dekena amo dohore oi hakaudia siri totona.” ");
INSERT INTO hmo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Vadaeni Mose ia haere Dirava dekenai, ia gwau, “Lau be daika, dohore Farao dekenai lau lao, bona Israela taudia Aigupito dekena amo do lau hakaua siri?” ");
INSERT INTO hmo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Dirava ma ia gwau, “Momokani, dohore lau durua oi, bona lau siaia oi ena toana be inai: Oi ese Israela taudia Aigupito tano dekena amo do oi hakaua siri murinai, inai ororo Sinai dekenai Dirava do umui tomadiho henia.” ");
INSERT INTO hmo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Vadaeni Mose ma ia hereva lou Dirava dekenai, ia gwau, “Lau be dohore lau lao Israela taudia dekenai. Do lau hamaoroa idia dekenai, lau gwau, ‘Umui emui tamadia ena Dirava ese lau ia siaia umui dekenai,’ vadaeni dohore idia henanadaia lau dekenai, idia gwau, ‘Iena ladana be daika?’ Lau be edena bamona dohore lau haere idia dekenai?” ");
INSERT INTO hmo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Vadaeni Dirava ese Mose dekenai ia hamaoroa, ia gwau, “LAU INAI LAU NOHO.” Ma ia gwau, “Israela taudia dekenai inai bamona do oi haere henia, oi gwau, ‘LAU NOHO ese ia siaia lau umui dekenai.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Dirava ia hereva lou Mose dekenai, ia gwau, “Israela taudia dekenai dohore oi hamaoroa, oi gwau, ‘Lohiabada, umui emui sene taudia edia Dirava, Aberahamo ena Dirava, Isako ena Dirava, Iakobo ena Dirava ese ia siaia lau umui dekenai.’ Lauegu ladana be inai, ia lao hanaihanai, gabeai ia mai nega ibounai lalonai inai bamona lauegu ladana dohore umui gwauraia. ");
INSERT INTO hmo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Oi lao, Israela tau badadia dohore oi haboua. Dohore oi hereva idia dekenai, oi gwau, ‘Lohiabada, umui emui sene taudia edia Dirava, Aberahamo ena Dirava, Isako ena Dirava, Iakobo ena Dirava ia hedinarai henia vadaeni lau dekenai, ia gwau: Momokani, lau ese umui lau itaia vadaeni, Aigupito dekenai kara ibounai idia karaia noho umui dekenai, be lau itaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Lau gwauhamata vadaeni, Aigupito ena hisihisi dekena amo umui do lau hakaua siri, Kanana taudia bona Hiti taudia, bona Amoro taudia, bona Perisi taudia, bona Hivi taudia, bona Iebusu taudia edia tano dekenai umui dohore lau hakaua vareai. Inai tano be aniani namodia gabuna.’ ");
INSERT INTO hmo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Vadaeni Israela taudia be oiemu hereva do idia kamonai. Vadaeni oi bona Israela ena tau badadia danu Aigupito ena king dekenai dohore umui lao, do umui gwau, ‘Lohiabada, Heberu taudia aiemai Dirava ia hedinarai vadaeni ai dekenai. Unai dainai ai ura, dina toi dohore ai laolao taunimanima idia noho lasi tanona dekenai, mani emu kara aiemai dala do oi kehoa. Badina be unuseni, ai ese Lohiabada aiemai Dirava dohore ai hanamoa, boubou gaudia do ai henia ia dekenai.’ ");
INSERT INTO hmo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“To lau diba, Aigupito ena king be umui emui dala do ia kehoa diba lasi, ia lao bona lauegu imana ena metau ena mamina do ia abia. ");
INSERT INTO hmo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Unai dainai, lauegu siahu do lau gaukaralaia, bona lauegu hoa kara dekena amo, Aigupito taudia edia kerere davana do lau henia. Unai murinai, vadaeni umui emui dala do ia kehoa. ");
INSERT INTO hmo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“To lauegu bese taudia dohore lau hanamodia Aigupito taudia edia vairana dekenai, vadaeni umui raka siri neganai ima kavakava danu do umui lao lasi. ");
INSERT INTO hmo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Badina be hahine taudia ta ta ese edia badibadina dekenai Aigupito hahine taudia bona edia ruma dekenai noho Aigupito hahine dekenai do idia noinoi karaia. Siliva herahera bona golo herahera bona dabua dohore idia noinoi. Vadaeni unai gaudia be umui emui natudia hahine bona tatau dekenai do umui atoa. Inai dala dekenai Aigupito taudia edia kohu namodia momo dohore umui kokia idia dekena amo.” ");
INSERT INTO hmo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Vadaeni Mose ia haere, ia gwau, “Mani oi laloa, Israela taudia be dohore idia kamonai henia lasi lau dekenai. Lauegu hereva do idia abia dae lasi, do idia gwau, ‘Lohiabada be ia hedinarai henia lasi oi dekenai.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Vadaeni Lohiabada ia gwau, “Unai be dahaka oiemu imana dekenai?” Ia haere, ia gwau, “Itotohi.” ");
INSERT INTO hmo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Lohiabada ia gwau, “Tano dekenai oi negea diho.” Tano dekenai ia negea diho, vadaeni itotohi be Lohiabada ese gaigai ia halaoa. Vadaeni Mose ia heau, ia rakatania. ");
INSERT INTO hmo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","To Lohiabada ia hereva Mose dekenai ia gwau, “Oiemu imana oi atoa lao, iena iuna dekenai oi dogoatao.” Unai dainai iena imana ia atoa lao, ia dogoatao. Vadaeni Lohiabada ese itotohi ma ia halaoa iena imana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Lohiabada ia gwau, “Inai bamona oi karaia, vadaeni dohore idia diba Lohiabada, edia sene taudia edia Dirava, Aberahamo ena Dirava, Isako ena Dirava, Iakobo ena Dirava ese ia hedinarai henia vadaeni oi dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Lohiabada ese ma ia hereva henia, ia gwau, “Oiemu imana, oiemu kouti dabua ena lalona dekenai oi atoa vareai.” Iena imana, iena kouti dabua dekenai ia atoa vareai. Vadaeni ia veria murimuri dekenai neganai, iena imana ia kurokuro herea, lepera tauna ena imana bamona. ");
INSERT INTO hmo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Dirava ma ia gwau, “Oiemu imana, oiemu kouti dabua ena lalona dekenai oi atoa vareai lou.” Vadaeni iena imana be iena kouti dabua dekenai ia atoa vareai lou. Vadaeni iena imana ia veria murimuri dekenai neganai, ia itaia, ia namo vadaeni, iena kopina gunana bamona. ");
INSERT INTO hmo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Vadaeni Dirava ma ia gwau, “Bema idia kamonai henia lasi oi dekenai, bona toana ginigunana bema idia abia dae lasi, sedira toana iharuana dohore idia abia dae. ");
INSERT INTO hmo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","To inai toana ruaosi bema idia abia dae lasi, bona oiemu hereva dekenai bema idia kamonai lasi, Naila Sinavai ena ranuna do oi abia, tano dekenai do oi bubua. Vadaeni sinavai dekena amo ranu oi abia, be rara dekenai dohore ia lao tano dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mose ese Lohiabada dekenai ia hereva lou, ia gwau, “Lauegu Lohiabada e, lau be hereva dekenai egu malana be ia haraga lasi, guna ia mai bona harihari lau dekenai oi hereva neganai danu. Badina lau be hereva goada lasi tauna, egu malana danu ia haraga lasi, hereva dekenai danu lau daradara.” ");
INSERT INTO hmo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Vadaeni Lohiabada ese ia haere Mose dekenai, ia gwau, “Taunimanima edia uduna daika ese ia karaia? Daika ese tau ta ena uduna ia hakapua, o iena taiana ia koua? Daika ese matana ia kehoa? Daika ese iena matana ia hakepulua? Lau inai Lohiabada, ani? ");
INSERT INTO hmo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Unai dainai oi lao. Lau be oiemu hereva do lau durua. Do oi gwauraia herevadia dohore lau henia oi dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","To Mose ia gwau, “Egu Lohiabada e, mani emu kara idau tauna ta do oi siaia.” ");
INSERT INTO hmo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Vadaeni Lohiabada ia badu Mose dekenai, ia gwau, “Oiemu kakana Arona, Levi iduhu tauna ia noho lasi, a? Lau diba ia be haroro ia diba. Inai harihari ia raka mai inai oi dekenai, oi danu hedavari totona. Ia ese oi ia itaia neganai, do ia moale. ");
INSERT INTO hmo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Oi ese ia dekenai do oi hereva henia, bona dahaka dahaka do ia gwauraia be do oi hamaoroa ia dekenai. To lau ese umui ruaosi emui hereva do lau durua. Umui ruaosi dekenai dohore lau hadibaia dahaka do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ia ese oiemu hereva taunimanima dekenai do ia hamaoroa, ia be oiemu uduna do ia lao. Oi be Dirava bamona, do oi hamaoroa dahaka hereva do ia gwauraia. ");
INSERT INTO hmo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Inai itotohi oiemu imana dekenai oi abia, ia dekena amo hoa kara do oi karaia.” ");
INSERT INTO hmo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Vadaeni Mose ia lao, iena ravana Ietero dekenai ia giroa lou, ia hamaroa, ia gwau, “Mani oiemu imana dekena amo oi negea lau, lauegu varavara taudia Aigupito dekenai do lau giroa lou. Vadaeni dohore lau diba, idia be do idia mauri noho o lasi.” Ietero ia haere Mose dekenai, ia gwau, “Mai maino danu oi lao.” ");
INSERT INTO hmo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Vadaeni Lohiabada ese Midiana ena tano dekenai Mose dekenai ia hereva henia, ia gwau, “Aigupito dekenai oi giroa. Badina be oi do idia alaia gwauraia taudia be ibounai idia mase vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Vadaeni Mose ese iena adavana bona iena natuna memero ia abidia, doniki dekenai idia helai kau, Aigupito tano dekenai idia raka lao. Dirava ena itotohi danu iena imana dekenai ia abia. ");
INSERT INTO hmo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Vadaeni Lohiabada ese ia hereva Mose dekenai, ia gwau, “Aigupito dekenai oi ginidae neganai, hoa kara ibounai Farao ena vairana dekenai do oi karaia, lau ese siahu lau henia oi dekenai hegeregerena. To lau ese iena lalona dohore lau ha-aukaia, vadaeni ia ese Heberu taudia iena imana dekena amo dohore ia negea lasi. ");
INSERT INTO hmo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Vadaeni Farao dekenai dohore oi hamaoroa, oi gwau, ‘Lohiabada be inai bamona ia gwau: Israela be egu vara guna natuna tau. ");
INSERT INTO hmo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Unai dainai lau hereva oi dekenai, lauegu natuna oiemu imana dekena amo oi negea, lau do ia tomadiho henia totona. To bema oi dogoatao noho, oiemu vara guna natuna tau dohore lau alaia mase.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Dina ta dala dekenai idia kamepa gabuna dekenai Lohiabada be Mose ena vairana dekenai ia gini, ia ese Mose do ia alaia gwauraia. ");
INSERT INTO hmo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Vadaeni Sipora ese nadi mai matana ia abia, iena natuna ena usina duduna kopina ia utua oho, bona inai dekena amo Mose ena aena ia dahua, ia gwau, “Momokani, oi be rara tauna, lau adavaia.” ");
INSERT INTO hmo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Vadaeni unai dainai Lohiabada ese Mose ia alaia lasi. Unai neganai hahine ia gwau, “Rara tauna lau adavaia,” kopina utua kara dainai. ");
INSERT INTO hmo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Unai neganai Lohiabada ese Arona dekenai ia hereva, ia gwau, “Taunimanima noho lasi gabuna dekenai oi lao. Unuseni Mose danu do umui hedavari.” Vadaeni Arona be Dirava ena ororo dekenai ia lao, Mose do ia hedavari totona. Idia hedavari neganai, Arona ese Mose ia rosia, ia kisi henia. ");
INSERT INTO hmo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Vadaeni Lohiabada ese Mose dekenai ia hamaoroa hereva ibounai, bona hoa karadia do ia karaia, be Mose ese Arona dekenai ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mose bona Arona ese idia lao, Israela tau badadia ibounai idia haboua. ");
INSERT INTO hmo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Lohiabada ese Mose dekenai ia hamaoroa hereva ibounai be Arona ese ia gwauraia idia dekenai. Bona hoa karadia be Mose ese taunimanima edia vairana dekenai ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Idia kamonai bona hamomokania, vadaeni idia diba Lohiabada ese Israela ena bese taudia dekenai ia vadivadi, bona edia hisihisi ibounai ia itaia vadaeni, unai dainai idia edia kwarana idia atoa diho, Lohiabada dekenai idia tomadiho. ");
INSERT INTO hmo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Unai murinai Mose bona Arona idia lao Farao dekenai, idia hereva henia, idia gwau, “Lohiabada, Israela aiemai Dirava, inai bamona ia gwau, ‘Egu bese taudia oiemu imana dekena amo oi negea, idia ese lauegu aria dohore idia karaia, taunimanima idia noho lasi gabuna dekenai.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","To Farao ia gwau, “Lohiabada be daika? Badina be dahaka iena hereva dohore lau kamonai? Israela taudia lauegu imana dekena amo dohore lau negea, badina be dahaka? Lohiabada be lau diba lasi, Israela taudia danu lauegu imana dekena amo dohore lau negea lasi momokani.” ");
INSERT INTO hmo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ruaosi idia gwau, “Ai Heberu taudia aiemai Dirava ia mai vadaeni ai dekenai. Mani emu kara, dina toi dohore ai raka lao, taunimanima idia noho lasi gabuna dekenai, aiemai Dirava, Lohiabada ena boubou gauna dohore ai karaia. Badina be bema inai bamona ai karaia lasi, gorere o tuari dekena amo ai do ia alaia mase garina.” ");
INSERT INTO hmo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Vadaeni Aigupito ena king ese ia haere idia dekenai, ia gwau, “Mose, bona Arona, badina dahaka umui ese emui orea edia gaukara dekena amo umui abia siri gwauraia? Umui lao, emui gaukara dekenai do umui giroa lou.” ");
INSERT INTO hmo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Farao ma ia gwau, “Momokani, emui bese taudia idia momo herea vadaeni, to umui ese edia gaukara dalana umui koua gwauraia, ani?” ");
INSERT INTO hmo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Unai dina Farao ese Israela gaukara biaguna taudia, bona gaukara naria taudia dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Biriki nadi karaia taudia dekenai be uiti ena momoru, raro danu idia mikisi gauna do umui henia lou lasi, dina ibounai umui henia bamona. Inai murinai Israela taudia sibona do idia lao gogoa. ");
INSERT INTO hmo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","“Bona lau oda inai, raro dekena amo biriki nadi idia karaia be edia momo dohore idia karaia, guna idia karaia bamona. Gaukara anina hegeregere do idia karaia, badina be idia lahedo momo, unai dainai idia taitai lau dekenai, idia gwau, ‘Mani oiemu imana dekena amo oi negea ai, aiemai Dirava ena boubou gauna dohore ai karaia.’ ");
INSERT INTO hmo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Edia gaukara dekenai metau umui henia, dohore idia gaukara goada noho, vadaeni Mose bona Arona edia hereva koikoi dekenai dohore idia kamonai lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Unai dainai gaukara biaguna taudia bona gaukara naria taudia be idia lao, Heberu taudia dekenai idia hamaoroa, idia gwau, “Farao ia gwau, uiti ena momoru dohore ia henia lou lasi umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Vadaeni, umui lao, umui sibona uiti ena momoru do umui tahua. Ma Farao ia gwau, emui gaukara anina be do ia maragi lasi, unai raro dekenai umui karaia biriki nadi edia momo be do ia diho lasi, to guna umui karaia hegeregerena.” ");
INSERT INTO hmo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Unai dainai ibounai idia lao idau gabu idau gabu dekenai, Aigupito tano ibounai dekenai, uiti ena momoru idia gogoa. ");
INSERT INTO hmo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","To gaukara dekenai idia biagua taudia idia gwaugwau, idia gwau, “Dina ta ta umui emui gaukara ena anina dohore umui haorea momokani, gunaguna uiti ena momoru umui dekenai idia henia neganai umui karaia bamona.” ");
INSERT INTO hmo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Vadaeni Farao ena gaukara idia biagua taudia ese Israela gaukara naria taudia idia botaia, idia gwau henia, idia gwau, “Dahaka dainai hari dina umui emui gaukara ena anina momokani umui haorea momokani lasi, guna umui karaia raro dekena amo biriki nadi edia momo hegeregerena umui karaia lasi?” ");
INSERT INTO hmo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Vadaeni Israela gaukara naria taudia idia lao Farao dekenai, idia tai ia dekenai, idia gwau, “Dahaka totona ai dekenai inai bamona oi karaia? ");
INSERT INTO hmo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Uiti ena momoru idia henia lasi ai dekenai, to idia hamaoroa noho ai dekenai, idia gwau, ‘Raro dekena amo idia karaia biriki nadi umui karaia noho,’ danu idia botaia ai, to kerere be oiemu orea taudia edia kerere.” ");
INSERT INTO hmo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","To Farao ia haere, ia gwau, “Umui be lahedo taudia, lahedo momo taudia. Unai dainai umui gwau, ‘Oiemu imana dekena amo oi negea ai, Lohiabada ena boubou dohore ai karaia.’ ");
INSERT INTO hmo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Vadaeni, umui lao, emui gaukara dekenai umui giroa lou. Uiti ena momoru be dohore idia henia lasi umui dekenai. To raro biriki nadi edia momo hegeregerena umui karaia noho.” ");
INSERT INTO hmo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Inai bamona Farao ia hereva dainai, Israela gaukara naria taudia idia diba vadaeni, kerere bada be dohore ia vara. ");
INSERT INTO hmo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Vadaeni Farao dekena amo idia raka murimuri dekenai neganai, Mose bona Arona danu idia hedavari, badina idia ruaosi be idia naria noho idia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Vadaeni idia ese Mose bona Arona dekenai idia gwau henia, idia gwau, “Lohiabada ese emui kara do ia itaia, bona emui kerere davana do ia henia umui dekenai, badina be Farao bona iena hesiai taudia edia vairana dekenai aiemai ladana umui hadikaia vadaeni. Hegeregere idia edia imana dekenai kaia umui atoa bamona, vadaeni dohore idia alaia ai.” ");
INSERT INTO hmo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Vadaeni Mose ia noinoi lou Lohiabada dekenai, ia gwau, “Lohiabada e, dahaka dainai oiemu bese taudia oi hadikaia noho inai bamona? Dahaka totona oi siaia lau? ");
INSERT INTO hmo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Badina be Farao dekenai lau mai, oiemu hereva lau hamaoroa ia dekenai, unai neganai ia mai harihari, ia ese inai bese taudia ia hadikaia mai dagedage danu, bona oi ese oi durudia lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Lohiabada ese Mose dekenai ia hereva, ia gwau, “Harihari Farao dekenai edena bamona dohore lau karaia be do oi itaia. Lau ese do lau hisihisi henia dikadika dainai, ia ese Israela taudia iena imana dekena amo do ia negea. Oibe, gari bada dainai, ia ese iena tano dekena amo Israela taudia do ia luludia murimuri dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Dirava ese Mose dekenai ma ia hamaoroa, ia gwau, “Lau inai Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Aberahamo bona Isako bona Iakobo edia vairana dekenai lau hedinarai, Siahu Ibounai Dirava, to lauegu ladana korikori, Iehova, lau hadibaia lasi idia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Lau ese Israela taudia danu gwauhamata taravatuna lau karaia, bona lau gwauhamata, lau ese idia dekenai Kanana tano do lau henia. Guna unai tano dekenai idia noho, idau taudia bamona. ");
INSERT INTO hmo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Israela taudia dekenai Aigupito taudia ese hisihisi idia henia noho, edia taitai lau kamonai vadaeni, bona lauegu gwauhamata lau laloa. ");
INSERT INTO hmo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Unai dainai Israela taudia dekenai oi hamaoroa, lau inai Lohiabada, bona Aigupito taudia ese umui emui latanai gaukara metau idia atoa, be be inai hisihisi dohore lau kokia. Idia guia umui, to lau ese umui do lau ruhaia, lauegu imana ena goada dekena amo, bona hoa karadia badadia dekena amo dohore lau hamauria umui. ");
INSERT INTO hmo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Lauegu bese do lau halaoa umui, bona lau be umui emui Dirava do lau lao, vadaeni dohore umui diba, lau be Lohiabada, umui emui Dirava, Aigupito taudia edia gaukara metau dekena amo lau hamauria umui, ena Dirava. ");
INSERT INTO hmo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Aberahamo bona Isako bona Iakobo dekenai lau gwauhamata tanona ena lalonai dohore lau hakaua vareai umui, dohore lau henia umui dekenai, umui emui tano momokani. Lau inai Lohiabada.” ");
INSERT INTO hmo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mose ese inai hereva Israela taudia dekenai ia hamaoroa, to idia kamonai lasi ia dekenai, edia laloa ibounai ia ore, edia gaukara ia metau momo dainai. ");
INSERT INTO hmo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Vadaeni Lohiabada ese Mose dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Oi raka vareai, Farao, Aigupito ena king do oi hamaoroa, Israela taudia be iena imana dekena amo do ia negea, iena tano do idia rakatania.” ");
INSERT INTO hmo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","To Mose ese Lohiabada dekenai ia haere, ia gwau, “Mani oi laloa, lauegu uduna be ia metau dainai, Israela taudia be idia kamonai lasi lau dekenai, be edena bamona inai Farao do ia kamonai henia lau dekenai?” ");
INSERT INTO hmo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","To Lohiabada ese Mose bona Arona dekenai ia hereva, ia gwau, “Israela taudia dekenai umui hereva henia, bona Farao, Aigupito ena king dekenai do umui hereva henia, Israela taudia be Aigupito tano dekena amo do idia raka murimuri dekenai, bona umui ese do umui hakaudia.” ");
INSERT INTO hmo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Mose bona Arona edia iduhu edia kwarana taudia edia ladana be inai: Rubena, Israela ena natuna, guna ia vara tauna, ena natuna be inai: Hanoka, bona Palu, bona Hesarona bona Karami, Rubena ena iduhu be unai. ");
INSERT INTO hmo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Rubena ena tadina Simeona ena natuna be inai: Iemuela, Iamina, Ohada, Iakini, Sohara bona Kanana hahine ena natuna Saulo. Simeona ena iduhu be unai. ");
INSERT INTO hmo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi ena natuna edia ladadia be inai, edia uru ta ta dekenai: Geresone bona Kohata bona Merari. Levi ena mauri lagani ibounai be 137. ");
INSERT INTO hmo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Geresone ena natuna be inai: Libini bona Simei, edia iduhu taudia danu. ");
INSERT INTO hmo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohata ena natuna be inai: Amarama bona Isahara bona Heberona bona Usiele. Kohata ena mauri lagani ibounai be 133. ");
INSERT INTO hmo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari ena natuna be inai: Mali bona Musi. Levi ena iduhu be unai, uru ta ta dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amarama ese iena lalana Iokebeda ia adavaia. Edia natuna be Arona bona Mose. Amarama ena mauri lagani ibounai be 137. ");
INSERT INTO hmo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isahara ena natuna be inai: Kora bona Nepega bona Sikori. ");
INSERT INTO hmo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usiele ena natuna be inai: Misaela bona Elisapana bona Sitiri. ");
INSERT INTO hmo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arona ese Iliseba ia adavaia. Iliseba be Aminadaba ena natuna, Nasona ena taihuna. Ia ese ia havaraia memero be Nadaba bona Abihu bona Eleasara bona Itamara. ");
INSERT INTO hmo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora ena natuna be inai: Asiri bona Elikana bona Abiasapa. Kora ena iduhu be unai. ");
INSERT INTO hmo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasara, Arona ena natuna, ese Putiele ena natuna kekeni ta ia adavaia, ia ese Pineha ia havaraia. Levi ena iduhu dekenai ruma edia kwarana taudia be unai. ");
INSERT INTO hmo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Lohiabada ese Arona bona Mose ia hamaoroa, ia gwau, “Israela taudia be iduhu ta ta dekena amo do umui hakaudia, Aigupito tano do idia rakatania neganai.” ");
INSERT INTO hmo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Vadaeni Mose bona Arona ese Farao, Aigupito ena king idia hamaoroa, Israela taudia be Aigupito dekena amo do idia hakaudia siri. ");
INSERT INTO hmo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Lohiabada ese Mose Aigupito tano dekenai ia hereva henia neganai, ");
INSERT INTO hmo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ia ese Mose ia hamaoroa, ia gwau, “Lau inai Lohiabada, hereva ibounai oi dekenai lau hamaoroa vadaeni, be Farao, Aigupito ena king, dekenai do oi hamaoroa.” ");
INSERT INTO hmo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","To Mose ia haere Lohiabada dekenai, ia gwau, “Lauegu uduna be ia metau, Farao be edena bamona dohore ia kamonai lau dekenai?” ");
INSERT INTO hmo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Lohiabada ese Mose dekenai ia haere, ia gwau, “Oi kamonai, lau ese Dirava hegeregerena oi do lau halaoa Farao ena vairana dekenai, bona oiemu kakana Arona ese do ia hereva henia, oiemu peroveta tauna hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Oi dekenai do lau hamaoroa hereva ibounai dohore oi gwauraia, be oiemu kakana ese Farao dekenai do ia hamaoroa, ia ese Israela taudia iena imana dekena amo dohore ia negea, iena tano dekena amo dohore idia raka siri. ");
INSERT INTO hmo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Lau ese Farao ena lalona do lau ha-aukaia, bona lau ese toa bona hoa kara momo dohore lau karaia Aigupito tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","To Farao be do ia kamonai lasi umui dekenai. Unai dainai lauegu imana Aigupito taudia edia latanai dohore lau atoa, vadaeni lauegu orea, lauegu bese, Israela taudia, Aigupito tano dekena amo dohore lau hakaudia siri. ");
INSERT INTO hmo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","“Vadaeni lauegu imana Aigupito ena latanai dohore lau atoa, bona Israela taudia be idia edia tano dekena amo do lau hakaua siri neganai, Aigupito taudia do idia diba lau inai Lohiabada.” ");
INSERT INTO hmo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Vadaeni Mose bona Arona ese unai bamona idia karaia, Lohiabada ese ia hamaorodia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Lohiabada ena hereva Farao dekenai idia hamaoroa neganai, Mose ena mauri lagani be 80, to Arona ena lagani be 83. ");
INSERT INTO hmo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Vadaeni Lohiabada ese Mose bona Arona dekenai ma ia hereva, ");
INSERT INTO hmo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","ia gwau, “Farao ese dohore ia hamaoroa umui dekenai, dohore ia gwau, ‘Hoa kara ta do umui karaia, vadaeni dohore lau diba umui be Dirava ia siaia umui.’ Unai neganai oiemu kakana Arona dekenai do oi hereva, ‘Oiemu itotohi oi abia, Farao ena vairana dekenai oi negea diho tano dekenai, vadaeni itotohi be gaigai do ia lao.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Vadaeni, Mose bona Arona be Farao dekenai idia lao, Lohiabada ena hereva hegeregerena idia karaia. Arona ese iena itotohi ia negea diho, Farao bona iena hesiai taudia edia vairana dekenai, vadaeni gaigai dekenai ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Vadaeni Farao ese aonega taudia bona meamea taudia dekenai ia boiboi. Vadaeni inai Aigupito meamea taudia danu ese unai kara bamona idia karaia, idia edia meamea dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Idia ta ta ese edia itotohi idia negea diho, vadaeni gaigai dekenai idia halaoa. To Arona ena gaigai ese idia edia gaigai ibounai ia ania. ");
INSERT INTO hmo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","To Farao ena lalona do ia auka noho, ia kamonai lasi idia dekenai, Lohiabada ia hereva hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Vadaeni Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Farao ena lalona ia auka noho vadaeni, taunimanima be iena imana dekena amo dohore ia negea lasi. ");
INSERT INTO hmo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Dabai, Farao dekenai do oi lao, Naila Sinavai dekenai do ia lao neganai. Sinavai ena badibadinai do oi naria, itotohi danu, gaigai dekenai ia halaoa gauna, do oi abia lao. ");
INSERT INTO hmo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Vadaeni oi hamaoroa ia dekenai, oi gwau, ‘Lohiabada, ai Heberu taudia aiemai Dirava, ese lau ia siaia vadaeni oi dekenai, ia gwau: Lauegu orea taudia oiemu imana dekena amo do oi negea taunimanima idia noho lasi gabuna dekenai, dohore idia tomadiho lau dekenai.’ To oi be oi kamonai lasi ia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Unai dainai Lohiabada ese inai iena kara dekena amo oi dekenai do ia hadibaia, ia be Lohiabada. Oi itaia, Naila Sinavai be lauegu imana dekenai ia noho itotohi dekena amo do lau botaia, vadaeni itotohi ese ranu be rara dekenai do ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Vadaeni Naila Sinavai ena gwarume ibounai do idia mase ore, bona ranu do ia bodaga, vadaeni Aigupito taudia ese Naila Sinavai ena ranu do idia ura henia lasi, do idia inua lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Lohiabada ese Mose dekenai ma ia hereva, ia gwau, “Arona dekenai do oi hereva, oi gwau, ‘Oiemu itotohi oiemu imana dekenai oi abia, oi atoa maoromaoro Aigupito taudia edia ranu ena ataiai, edia sinavai badadia edia ataiai, bona edia sinavai maragidia edia ataiai, edia gohu edia ataiai, bona edia koupa ibounai edia ataiai, vadaeni rara dekenai do idia halaoa, Aigupito tano ibounai dekenai rara sibona do ia noho, baubau dekenai bona hodu dekenai.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Vadaeni Mose bona Arona ese Lohiabada ia hereva hegeregerena idia karaia. Farao ena vairana dekenai, bona iena hesiai taudia edia vairana dekenai, Arona ese iena itotohi ia abia, Naila Sinavai ena ranu ia botaia. Vadaeni Naila Sinavai ena ranu ibounai rara dekenai ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Vadaeni Naila Sinavai ena gwarume ibounai idia mase ore, ranu danu ia bodaga, Aigupito taudia Naila Sinavai ena ranu do idia inua, be edia lalona ia hegeregere lasi. Aigupito tano ibounai dekenai rara sibona ia noho. ");
INSERT INTO hmo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Aigupito meamea taudia danu ese unai kara bamona idia karaia, edia meamea dekenai. Vadaeni Farao ena lalona ma ia auka, ia kamonai lasi Mose bona Arona dekenai, Lohiabada ia hereva bamona. ");
INSERT INTO hmo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Farao be ia giroa lou, iena ruma dekenai ia lao, ia laloa momo lasi. ");
INSERT INTO hmo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Vadaeni Aigupito taudia ibounai ese guri idia geia, sinavai ena badibadinai, inua ranuna idia tahua, badina be sinavai ena ranu be hegeregere lasi inua totona. ");
INSERT INTO hmo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Lohiabada ese inai bamona ia karaia sinavai dekenai murinai, dina 7 inai rara ia noho. ");
INSERT INTO hmo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Vadaeni Lohiabada ese Mose dekenai ma ia hereva, ia gwau, “Farao dekenai oi lao, do oi hamaoroa, oi gwau, ‘Lohiabada be inai bamona ia hereva, ia gwau: Egu orea taudia oiemu imana dekena amo oi negea, do idia lao, dohore idia tomadiho lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","To bema oiemu imana dekena amo oi negea lasi idia, lau ese paroparo do lau siaia, oiemu tano ibounai do idia hadikaia. ");
INSERT INTO hmo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Sinavai be paroparo dekenai dohore idia honu, vadaeni dohore idia daekau oiemu ruma dekenai, bona oiemu mahuta daiutu dekenai, bona oiemu mahuta pata dekenai, bona oiemu hesiai taudia edia ruma dekenai, bona oiemu orea taudia edia ruma dekenai, bona oiemu aniani nadua gaudia bona aniani gabua amu dekenai, bona oiemu disi dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Harihari paroparo be oiemu latanai do idia daekau, bona oiemu orea taudia edia latanai, bona oiemu hesiai taudia ibounai edia latanai.’ ” Mose ese Farao unai bamona ia hamaoroa, to Farao ia kamonai henia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Lohiabada ese Mose dekenai ma ia hamaoroa, ia gwau, “Arona dekenai oi hereva, oi gwau, ‘Oiemu itotohi oiemu imana dekenai oi abia, oi atoa maoromaoro sinavai badadia bona sinavai maragidia edia ataiai, bona koupa bona gohu edia ataiai, vadaeni paroparo do idia daekau Aigupito tano ibounai dekenai.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Vadaeni, Arona ese iena itotohi ia atoa maoromaoro Aigupito ena ranu edia ataiai, vadaeni paroparo be ranu dekena amo idia daekau, Aigupito ena tano be paroparo dekenai ia honu. ");
INSERT INTO hmo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","To meamea taudia ese danu unai bamona idia karaia, edia meamea dekenai, vadaeni paroparo ma idia momo herea Aigupito tano ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Vadaeni Farao ese Mose bona Arona ia boiridia, ia gwau, “Lohiabada dekenai umui noinoi, paroparo be lau dekena amo, bona lauegu orea taudia dekena amo dohore ia kokia, vadaeni umui emui orea taudia lauegu imana dekena amo dohore lau negea, do idia lao, Lohiabada ena boubou dohore idia karaia.” ");
INSERT INTO hmo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Vadaeni Mose ese ia haere Farao dekenai, ia gwau, “Mani oi hereva edena negai do lau noinoi oi totona, bona oiemu hesiai taudia totona, bona oiemu orea taudia totona, vadaeni paroparo be umui dekena amo, bona emui ruma dekena amo do idia kokia, sinavai dekenai sibona do idia noho.” ");
INSERT INTO hmo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ia gwau, “Kerukeru.” Vadaeni Mose ia gwau, “Oiemu hereva hegeregerena do lau karaia, vadaeni dohore oi diba, Lohiabada, aiemai Dirava, be dirava ta danu ia hegeregere lasi. ");
INSERT INTO hmo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Paroparo ese oi do idia rakatania, oiemu ruma bona oiemu hesiai taudia, bona oiemu orea taudia, danu dohore idia rakatania, sinavai dekenai sibona dohore idia noho.” ");
INSERT INTO hmo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Vadaeni Mose bona Arona ese Farao idia rakatania, murimuri dekenai idia raka. Vadaeni Mose ese Lohiabada dekenai ia noinoi, inai paroparo, Farao idia hadikaia gaudia, do ia kokia totona. ");
INSERT INTO hmo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Lohiabada ese Mose dekenai ia kamonai henia, vadaeni ruma dekenai bona hanua ena huana dekenai, bona uma dekenai, paroparo idia mase ore. ");
INSERT INTO hmo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Aigupito taudia ese paroparo idia haboua, vadaeni idia bodaga, edia bonana be tano ibounai dekenai ia daekau. ");
INSERT INTO hmo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","To Farao ese ia itaia gau ibounai ia namo, vadaeni iena lalona ma ia auka, ia kamonai henia lasi Mose bona Arona dekenai, Lohiabada ese ia gwauraia vadaeni bamona. ");
INSERT INTO hmo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Vadaeni Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Arona dekenai do oi hereva, oi gwau, ‘Oiemu itotohi dekena amo tano kahuna do oi botaia, nemo dekenai do ia halaoa, Aigupito tano ibounai dekenai.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Vadaeni unai bamona idia karaia, Arona ese iena itotohi ia abia, tano kahuna ia botaia, vadaeni nemo idia ginidae, taunimanima bona ubua gaudia idia koria. Tano kahuna ibounai, Aigupito tano ibounai dekenai, nemo dekenai ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Vadaeni meamea taudia ese edia meamea dekena amo nemo idia havaraia gwauraia, to havaraia ena dala idia diba lasi. To nemo ese taunimanima bona ubua gaudia idia koria noho. ");
INSERT INTO hmo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Vadaeni inai meamea taudia ese Farao dekenai idia hamaoroa, idia gwau, “Inai kara be Dirava ena imana kwakikwakina korikori ese ia karaia.” To Farao ena lalona be ia auka, ia kamonai lasi Mose bona Arona dekenai, Lohiabada ese ia gwauraia vadaeni bamona. ");
INSERT INTO hmo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Vadaeni Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Daba ia rere hamatamaia neganai, oi toreisi, Farao do oi naria, sinavai dekenai digu totona ia lao neganai, vadaeni oi hereva ia dekenai, oi gwau, ‘Lohiabada be inai bamona ia hereva: Lauegu orea taudia oiemu imana dekena amo oi negea, dohore idia tomadiho lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Badina be oiemu imana dekena amo bema oi negea lasi idia, lau ese lao momo herea do lau siaia, oiemu latanai, bona oiemu hesiai taudia, bona oiemu orea taudia, bona umui emui ruma edia latanai dohore idia ginidae. Aigupito taudia edia ruma bona edia tano be lao dekena amo dohore idia honu. ");
INSERT INTO hmo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Unai neganai oiemu tano bona Gosena tano, lauegu orea taudia edia tano, do lau hapararaia, bona Gosena dekenai lao dohore idia ginidae lasi. Unai dekena amo dohore oi diba lau be Lohiabada, tanobada ibounai ena Dirava. ");
INSERT INTO hmo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Lauegu orea taudia bona oiemu orea taudia do lau hapararaia, bona kerukeru inai toa kara do oi itaia.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Vadaeni Lohiabada ese unai bamona ia karaia. Lao momo herea idia ginidae, Farao ena ruma dekenai, bona iena hesiai taudia edia ruma dekenai, bona Aigupito tano ibounai ia dika momokani vadaeni, lao dainai. ");
INSERT INTO hmo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Vadaeni Farao ese Mose bona Arona dekenai ia boiboi, ia gwau, “Umui lao, inai Aigupito tano sibona dekenai umui emui Dirava ena boubou do umui karaia.” ");
INSERT INTO hmo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","To Mose ia gwau, “Unai bamona dohore ai karaia be ia maoro lasi, badina be Lohiabada aiemai Dirava ena boubou karaia totona do ai alaia gaudia be Aigupito taudia ese idia ura henia lasi gaudia. Bema idia edia vairana dekenai unai bamona do ai karaia neganai, idia ese nadi dekenai dohore idia hamasea ai. ");
INSERT INTO hmo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","“To do ai laolao taunimanima idia noho lasi gabuna dekenai, dina toi dohore ai raka, Lohiabada, aiemai Dirava ena boubou gauna do ai karaia, ai dekenai ia hereva henia hegeregerena.” ");
INSERT INTO hmo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Vadaeni Farao ese ia gwau, “Lauegu imana dekena amo do lau negea umui, Lohiabada, umui emui Dirava ena boubou dohore umui karaia, taunimanima idia noho lasi gabuna dekenai, to daudau gabuna dekenai do umui lao lasi, bona lau totona do umui guriguri.” ");
INSERT INTO hmo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Vadaeni Mose ia gwau, “Oiemu vairana dekena amo do lau raka murimuri dekenai, Lohiabada dekenai do lau noinoi, inai lao momo be Farao dekena amo, bona iena hesiai taudia dekena amo, bona iena orea taudia dekena amo, kerukeru do ia kokia, to namona be, Farao, do oi koikoi lou lasi, aiemai taunimanima be Lohiabada ena boubou karaia totona do idia lao, do oi dogoatao lasi idia.” ");
INSERT INTO hmo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Vadaeni Mose be Farao ena vairana dekena amo ia raka murimuri dekenai, Lohiabada dekenai ia guriguri. ");
INSERT INTO hmo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Vadaeni Lohiabada ese Mose ena noinoi hegeregerena ia karaia, lao momo be Farao dekena amo, bona iena hesiai taudia dekena amo, bona iena orea taudia dekena amo ia kokia, ta ia noho lasi. ");
INSERT INTO hmo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","To Farao ena lalona ma ia auka lou, Heberu taudia be iena imana dekena amo ia negea lasi. ");
INSERT INTO hmo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Vadaeni Lohiabada ese Mose dekenai ia hereva, ia gwau, “Farao dekenai do oi raka vareai, do oi hamaoroa, oi gwau, ‘Lohiabada, ai Heberu taudia aiemai Dirava, inai bamona ia hereva, ia gwau: Lauegu orea taudia oiemu imana dekena amo do oi negea, do idia tomadiho lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Badina be bema oi dogoatao idia, oiemu imana dekena amo bema oi negea lasi idia, ");
INSERT INTO hmo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","lau Lohiabada ese davana do lau henia umui dekenai, emui ubua gaudia dekenai gorere dikana do lau siaia. Hosi edia latanai bona doniki edia latanai bona kamelo edia latanai bona boromakau edia latanai bona mamoe bona nani edia latanai, gorere dikana idia dekenai dohore ia ginidae. ");
INSERT INTO hmo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Lau Lohiabada ese Israela edia ubua gaudia bona Aigupito taudia edia ubua gaudia do lau hapararaia, Israela taudia edia ubua gaudia ta do ia mase lasi. ");
INSERT INTO hmo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Lohiabada ese unai kara ena dina ia gwauraia vadaeni, ia gwau, kerukeru lau Lohiabada ese unai bamona dohore lau karaia inai tano dekenai.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Vadaeni Lohiabada ese kerukeru unai bamona ia karaia, vadaeni Aigupito taudia edia ubua gaudia ibounai idia mase, to Israela taudia edia ubua gauna ta ia mase lasi. ");
INSERT INTO hmo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Vadaeni Farao ese iena hesiai taudia ia siaia, do ia diba inai hereva ia momokani o lasi. Vadaeni hereva idia mailaia, Israela taudia edia ubua gauna ta ia mase lasi. To Farao ena lalona ma ia auka, Heberu taudia iena imana dekena amo ia negea lasi. ");
INSERT INTO hmo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Vadaeni Lohiabada ese Mose bona Arona dekenai ia hamaoroa, ia gwau, “Lahi ena momoru do umui abia, bona Mose ese do ia negea daekau ataiai Farao ena vairanai. ");
INSERT INTO hmo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Inai lahi momoru be kahu do ia lao, Aigupito tano kahana kahana ibounai dekenai. Vadaeni iohururu do idia vara, bona do idia toto, taunimanima edia kopina dekenai, bona mauri gaudia idauidau ibounai edia kopina dekenai, Aigupito tano ibounai dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Vadaeni idia ese lahi ena momoru idia abia, Farao ena vairana dekenai idia gini, Mose ese ia negea daekau, vadaeni iohururu idia vara bona idia toto, taunimanima edia kopina dekenai, bona mauri gaudia ibounai edia kopina dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Vadaeni meamea taudia be Mose ena vairana dekenai idia gini hegeregere lasi, badina be idia danu be mai iohururu, Aigupito taudia ibounai bamona. ");
INSERT INTO hmo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","To Lohiabada ese Farao ena lalona ma ia ha-aukaia, vadaeni ia kamonai lasi idia dekenai, Lohiabada ese Mose dekenai ia hamaoroa guna hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Vadaeni Lohiabada ese Mose dekenai ia hereva, ia gwau, “Dabai do oi toreisi, Farao ena vairana dekenai do oi gini, do oi hamaoroa, oi gwau, ‘Lohiabada, ai Heberu taudia aiemai Dirava, inai bamona ia hereva, ia gwau: Lauegu orea taudia oiemu imana dekena amo dohore oi negea, dohore idia tomadiho lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Badina be inai nega dekenai, lauegu hisihisi henia ibounai be oiemu latanai, bona oiemu hesiai taudia edia latanai, bona oiemu orea taudia edia latanai do lau siaia, vadaeni dohore oi diba, lau be tau ta o dirava ta danu hegeregere lasi tanobada ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Badina be lauegu imana ena siahu momokani dekena amo gorere bema lau henia umui dekenai, dohore umui mase ore diba. ");
INSERT INTO hmo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","To inai totona oi dekenai mauri lau henia vadaeni: Lauegu siahu dohore oi itaia, vadaeni tanobada taudia ibounai ese lauegu ladana dohore idia matauraia totona. ");
INSERT INTO hmo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","To do oi hekokoroku noho lauegu orea taudia edia vairana dekenai, bona do oi ura lasi oiemu imana dekena amo oi negea idia. ");
INSERT INTO hmo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Oi kamonai, kerukeru, nega inai bamona dekenai, medu, aisi nadi bamona dika herea dohore lau siaia diho, Aigupito dekenai nega ta ia diho lasi, Aigupito ena bese ia vara hamatamaia, dekena amo ia mai bona harihari. ");
INSERT INTO hmo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","“ ‘Unai dainai, hari dina oiemu boromakau bona oiemu gau ibounai, tano palaka dekenai idia noho, dohore oi abidia vareai, badina be taunimanima bona mauri gaudia bema oi abia vareai lasi, to tano palaka dekenai bema idia noho, be medu, aisi nadi bamona ese dohore ia aladia momokani, ibounai do idia mase ore.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Vadaeni Farao ena hesiai taudia haida sibona Lohiabada ena gadona dekenai idia gari, vadaeni idia ese edia hesiai taudia bona idia edia ubua gaudia idia hakaua vareai ruma dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","To Lohiabada ena hereva idia laloa lasi taudia ese edia hesiai taudia bona edia ubua gaudia edia rakatania tano palaka dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Vadaeni Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Oiemu imana oi duduia guba dekenai, vadaeni medu, aisi nadi bamona dohore ia diho Aigupito tano ibounai dekenai, taunimanima edia latanai, bona mauri gaudia idauidau edia latanai, bona au idauidau, ava idauidau ibounai edia latanai danu.” ");
INSERT INTO hmo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Vadaeni Mose ese iena itotohi ia duduia guba dekenai, bona Lohiabada ese guba mai boiboi, bona medu, aisi nadi bamona ia hadihoa tanobada dekenai, kevaru danu tanobada dekenai ia hadihoa. Lohiabada ese unai medu, aisi nadi bamona ia hadihoa Aigupito tano ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Medu, aisi nadi bamona bona kevaru nega tamona idia diho, vadaeni ia bada herea, Aigupito tano ibounai dekenai nega ta unai bamona ia diho lasi, Aigupito ena bese ia vara hamatamaia, dekena amo ia mai bona harihari. ");
INSERT INTO hmo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Medu, aisi nadi bamona ese tano palaka dekenai idia noho gau ibounai idia alaia, Aigupito tano ibounai dekenai, taunimanima bona mauri gaudia idauidau, bona unai medu aisi nadi ese tano palaka dekenai ava ibounai idia hadikaia, bona au ibounai idia hamorua. ");
INSERT INTO hmo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosena tano dekenai sibona, Israela taudia ese idia noho tano dekenai, unai medu aisi nadi be idia diho lasi. ");
INSERT INTO hmo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Vadaeni Farao ese Mose bona Arona dekenai ia boiboi, ia gwau, “Lau be inai nega dekenai kerere lau karaia vadaeni, Lohiabada be ia maoromaoro, lau bona egu orea taudia, ai be kara dika taudia. ");
INSERT INTO hmo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Lohiabada dekenai do umui noinoi, badina be inai guba mai boiboi bona medu, aisi nadi bamona badadia edia mamina be ai abia vadaeni. Vadaeni lauegu imana dekena amo do lau negea umui, inai murinai do lau dogoatao lasi umui.” ");
INSERT INTO hmo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Vadaeni Mose ese ia haere ia dekenai, ia gwau, “Hanua dekena amo do lau raka murimuri dekenai, bona lauegu imana do lau abia isi Lohiabada dekenai, vadaeni guba mai boiboi do ia doko, medu, aisi nadi bamona danu do ia doko, unai dekena amo do oi diba tanobada be Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","To lau diba, oi bona oiemu hesiai taudia ese Lohiabada Dirava dekenai umui do gari lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Inai nega dekenai flax bona bali be idia dika vadaeni, badina be bali ena anina ia atoa vadaeni, bona flax ava ia tubu vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","To uiti bona sipeleta ava be idia dika lasi, badina be idia do tubu lasi. ");
INSERT INTO hmo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Vadaeni Mose ese Farao ia rakatania, hanua dekena amo ia raka murimuri dekenai, iena imana ia abia isi, Lohiabada dekenai ia noinoi, vadaeni guba mai boiboi, bona medu, aisi nadi bamona idia doko, bona medu be ia diho lasi tanobada dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","To Farao ese ia itaia, medu, bona medu aisi nadi bamona, bona guba mai boiboi idia doko vadaeni. Unai neganai iena kara dika ma ia habadaia, iena lalona ma ia auka lou, ia bona iena hesiai taudia danu. ");
INSERT INTO hmo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Farao ena lalona ia auka vadaeni, bona Israela taudia be iena imana dekena amo ia negea lasi, Lohiabada ese Mose dekenai ia hamaoroa guna hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Vadaeni Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Farao dekenai do oi raka vareai, badina be iena lalona bona iena hesiai taudia edia lalona danu lau ha-aukaia vadaeni. Inai bamona lau karaia badina be, idia huana dekenai lauegu siahu do lau hedinaraia totona. ");
INSERT INTO hmo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Vadaeni umui emui natudia bona emui tubudia dohore umui hadibaia diba, dahaka hoa kara badadia lau karaia Aigupito dekenai, bona edena bamona Aigupito taudia lau hakavakavadia lauegu toa karadia dekena amo, vadaeni umui ibounai do umui diba lau inai Lohiabada.” ");
INSERT INTO hmo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Vadaeni Mose bona Arona be Farao dekenai idia raka vareai, idia hereva ia dekenai, idia gwau, “Lohiabada, ai Heberu taudia aiemai Dirava, be inai bamona ia hereva, ‘Lauegu vairana dekenai do oi hekokoroku noho ia lao bona edena negai? Lauegu orea taudia oiemu imana dekena amo oi negea, dohore idia tomadiho lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","To bema lasi, bema oi dogoatao idia, lau ese kerukeru kwadi do lau siaia oiemu tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Idia ese tano ena kopina do idia koua momokani, tano be do oi itaia diba lasi. Vadaeni, emui aniani sisina do ia noho, medu, aisi nadi bamona ese ia hadikaia lasi gauna be, idia ese do idia ania ore, bona au ibounai be do idia ania ore. ");
INSERT INTO hmo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Oiemu ruma danu, bona oiemu hesiai taudia ibounai edia ruma, bona Aigupito taudia ibounai edia ruma, be kwadi dekenai do idia honu momokani, umui emui tamadia bona tubudia unai bamona idia itaia lasi, idia vara dinana ia mai bona harihari.’ ” Vadaeni Mose ese Farao ena vairana dekena amo ia raka siri. ");
INSERT INTO hmo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Vadaeni Farao dekenai, iena hesiai taudia ese idia hereva, idia gwau, “Inai tau ese dika momo ita dekenai do ia henia noho ia lao bona edena negai? Inai taudia oiemu imana dekena amo oi negea, do idia lao, Lohiabada, idia edia Dirava dekenai do idia tomadiho lao, ia namo. Aigupito ia dika momokani vadaeni, oi diba lasi, a?” ");
INSERT INTO hmo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Vadaeni idia ese Mose bona Arona ma idia hakaua vareai lou Farao dekenai. Ia hereva idia dekenai, ia gwau, “Umui lao, Lohiabada umui emui Dirava dekenai do umui tomadiho, to umui danu do idia lao taudia be daika?” ");
INSERT INTO hmo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose ia gwau, “Aiemai memero bona aiemai buruka taudia, aiemai natudia tatau, bona aiemai natudia hahine, aiemai mamoe bona aiemai boromakau, ibounai do ai abia lao, badina be guriguri aria ta do ai karaia, Lohiabada ena.” ");
INSERT INTO hmo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao ese mai badu danu ia hereva idia dekenai, ia gwau, “Be, Dirava ena ladana dekenai, umui emui hahine bona edia natudia do lau negea lasi umui danu. Lau diba umui be kerere ta do umui ura karaia lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Unai bamona lasi! Umui tatau sibona do umui lao, Lohiabada dekenai do umui tomadiho, badina umui emui ura be unai.” Vadaeni Farao ese iena vairana dekena amo ia luludia. ");
INSERT INTO hmo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Vadaeni Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Oiemu imana oi abia isi Aigupito tano ena ataiai, kwadi do idia mai totona. Tubu noho gaudia, bona ava ibounai, bona medu, aisi nadi bamona ese ia hadikaia lasi gaudia ibounai do idia ania ore.” ");
INSERT INTO hmo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Vadaeni Mose ese iena itotohi ia abia isi Aigupito tano ena ataiai. Unai neganai Lohiabada ese lai ta ia siaia dina ia daekau kahana dekena amo, unai tano dekenai lai ia toa, unai dina tamona, bona unai hanuaboi ena hora ibounai. Bona daba ia rere neganai, inai lai ese kwadi ia mailaia. ");
INSERT INTO hmo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Vadaeni kwadi ese Aigupito tano ibounai idia koua, ia lao bona Aigupito tano ena kahana ibounai dekenai. Idia be dika momokani. Kwadi idia momo herea, unai bamona be nega ta ia hedinarai lasi, bona dohore ia hedinarai lou lasi. ");
INSERT INTO hmo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tano ena kopina ibounai idia ese idia koua momokani, tano ia korema vadaeni. Ava ibounai bona au ena huahua ibounai idia ania ore, medu, aisi nadi bamona ia hadikaia lasi gaudia ibounai idia ania ore. Ia tubu noho gauna ta, au o tano ena avana, idia noho lasi, Aigupito tano ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Vadaeni Farao ese Mose bona Arona dekenai ia boiboi haragaharaga, ia hamaorodia, ia gwau, “Lau ese Lohiabada, umui emui Dirava ena vairana dekenai, bona umui emui vairana dekenai, kerere momo lau karaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Inai dainai, lau noinoi umui dekenai, inai nega tamona sibona lauegu dika do umui laloaboio, Lohiabada umui emui Dirava dekenai do umui noinoi, ia ese unai dika gauna lau dekena amo do ia kokia.” ");
INSERT INTO hmo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Vadaeni Mose be Farao ena vairana dekena amo ia raka siri, Lohiabada dekenai ia noinoi. ");
INSERT INTO hmo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Vadaeni Lohiabada ese lai badana ta, dina ia diho kahana dekena amo ia siaia, unai lai ese kwadi ia abia isi. Davara Kakakaka lalonai ia abidia lao, Aigupito tano ibounai dekenai kwadi ta ia noho lasi. ");
INSERT INTO hmo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","To Lohiabada ese Farao ena lalona ma ia ha-aukaia, vadaeni Israela taudia iena imana dekena amo ia negea lasi. ");
INSERT INTO hmo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Vadaeni Lohiabada ese Mose dekenai ma ia hamaoroa, ia gwau, “Oiemu imana guba dekenai do oi duduia, vadaeni Aigupito taudia edia tano ibounai dibura ese do ia koua, bona idia ese dibura ena mamina do idia abia.” ");
INSERT INTO hmo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Vadaeni Mose ese guba dekenai iena imana ia duduia, vadaeni Aigupito tano ibounai ia dibura masemase, ia lao dina toi idia ore vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Aigupito taudia be ta ta dekenai idia itaia lasi, bona idia edia ruma idia rakatania lasi, dina toi edia lalonai. To Israela taudia ibounai edia noho gabudia ibounai be diari. ");
INSERT INTO hmo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Vadaeni Farao ese Mose ia boiria, ia gwau, “Vadaeni umui lao, Lohiabada dekenai do umui tomadiho, umui emui natudia do umui abidia lao, to umui emui mamoe bona nani bona boromakau ibounai iniseni do umui rakatania.” ");
INSERT INTO hmo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","To Mose ia gwau, “Lasi. Aiemai boubou gaudia, bona lahi ese do ia araia ore gaudia be ai dekenai do oi henia, Lohiabada aiemai Dirava ena boubou do ai karaia. ");
INSERT INTO hmo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Aiemai boromakau ibounai do ai abia lao, ta do ia noho lasi, badina be unai dekena amo Lohiabada aiemai Dirava ena boubou do ai karaia. Ai diba lasi dahaka gau dahaka gau dekena amo Lohiabada ena boubou do ai karaia, ia lao bona boubou karaia ena gabu dekenai dohore ai ginidae.” ");
INSERT INTO hmo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","To Lohiabada ese Farao ena lalona ma ia ha-aukaia, vadaeni iena imana dekena amo ia negea lasi idia. ");
INSERT INTO hmo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Vadaeni Farao ese Mose ia hamaoroa, ia gwau, “Oi siri, oi naria namonamo danu, lauegu vairana dohore oi itaia lou lasi, badina be oi itaia dinana dekenai, do oi mase.” ");
INSERT INTO hmo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Vadaeni Mose ia gwau, “Oiemu hereva hegeregere, oiemu vairana dohore lau itaia lou lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Vadaeni Lohiabada ese Mose ia hamaoroa, ia gwau, “Hisihisi henia ma ta Farao bona Aigupito taudia edia latanai do lau siaia. Inai hisihisi murinai, Farao ese iena imana dekena amo dohore ia negea umui. Momokani iena imana dekena amo do ia negea umui neganai, do ia lulua umui. ");
INSERT INTO hmo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Harihari Israela taudia dekenai oi hereva, tau bona hahine ta ta edia Aigupito badibadinai taudia dekenai do idia noinoi, herahera gaudia, siliva bona golo dekena amo idia karaia gaudia totona do idia noinoi.” ");
INSERT INTO hmo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Vadaeni Lohiabada ese Aigupito taudia edia lalona ia haidaua, bona idia matauraia Israela taudia dekenai. Farao ena hesiai taudia dekenai, bona hanua taudia dekenai, Mose ena ladana be ia bada. ");
INSERT INTO hmo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Vadaeni Mose ese Farao dekenai ia hereva, ia gwau, “Lohiabada be inai bamona ia hereva, ia gwau, ‘Hanuaboi ena huanai momokani, Aigupito tano do lau hanaia lao. ");
INSERT INTO hmo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Vadaeni Aigupito taudia edia vara guna natuna tau ibounai do idia mase, Farao ena vara guna natuna tau, Farao ena terona latanai do ia helai tauna, ia lao bona hesiai hahine, uiti ia moia nadi uili ia giroa hahinena, ena vara guna natuna tau. Boromakau ibounai edia vara guna natuna danu, do idia mase. ");
INSERT INTO hmo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Aigupito tano ibounai dekenai taitai badana do ia vara, nega ta unai bamona idia taitai lasi ia mai bona harihari, bona inai murinai danu, unai bamona dohore idia taitai lasi. ");
INSERT INTO hmo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","To Israela taudia mai edia ubua gaudia danu be sisia ta do ia boiboi lasi edia huana dekenai. Inai bamona do umui diba lau Lohiabada ese Aigupito taudia bona Israela taudia lau hapararaia vadaeni.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ma Mose ia gwau, “Farao e, oiemu hesiai taudia ibounai do idia mai lau dekenai, lauegu vairana dekenai do idia tomadiho, do idia gwau, ‘Oi raka siri, oiemu orea taudia ibounai danu!’ Unai murinai dohore lau raka siri.” Vadaeni Mose be Farao ena vairana dekena amo ia raka siri, mai badu siahuna danu. ");
INSERT INTO hmo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Vadaeni Lohiabada ese Mose ia hamaoroa, ia gwau, “Farao be do ia kamonai lasi noho oi dekenai, lauegu hoa kara Aigupito tano dekenai ma haida do lau karaia totona.” ");
INSERT INTO hmo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mose bona Arona ese unai hoa kara ibounai Farao ena vairana dekenai idia karaia, to Lohiabada ese Farao ena lalona ia ha-aukaia. Inai dainai Farao ese Israela taudia be iena tano dekena amo ia negea lasi. ");
INSERT INTO hmo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Vadaeni Lohiabada ese Mose bona Arona ia hereva henidia, Aigupito tano dekenai, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Inai hua be hua ginigunana Lohiabada ese do ia halaoa umui emui, umui emui lagani ia hamatamaia ena hua do ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Israela taudia ibounai do umui haboua, bona idia do umui hamaoroa, inai hua ena dina 10 lalonai, tau ta ta edia famili ta ta totona, mamoe ena natuna, o nani ena natuna do idia abia, ruma ta mamoe natuna ta, unai bamona do idia abia. ");
INSERT INTO hmo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","To ruma ta taudia bema idia momo lasi, unai ruma taudia bona badinai ia gini ruma taudia be mamoe ena natuna tamona do idia abia, inai taunimanima hida bamona be vamu ania haorea totona do idia davana hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Emui mamoe be do ia bero lasi gauna, mara namonamo gauna, lagani tamona ia abia gauna, mamoe o nani do umui abia. ");
INSERT INTO hmo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Unai ubua gaudia do umui naridia ia lao bona hua ena dina 14, vadaeni dina ia diho kahirakahira neganai, Israela ena taudia ibounai ese edia mamoe natudia do idia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Vadaeni mamoe ena rara haida do umui abia, iduara ena au kahana kahana bona ataiai au dekenai rara do umui dahua, inai ubua gauna umui ania rumadia ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Unai hanuaboi dekenai, mamoe natuna ena vamu do umui gabua lahi dekenai. Unai vamu, mai paraoa kavakava, hatubua muramura ia noho lasi gauna, bona aniani gaudia, ava mamina dika gaudia danu do umui ania. ");
INSERT INTO hmo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Vamu kasiri do umui ania lasi, bona do umui nadua lasi, to iena anina ibounai lahi dekenai do umui gabua, mai ena kwarana, mai ena imana, mai ena aena, mai ena bogana danu. ");
INSERT INTO hmo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Sisina do umui rakatania lasi ia lao bona daba ia mai, rakatania gauna be lahi dekenai do umui gabua haorea. ");
INSERT INTO hmo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Inai bamona do umui ania, emui rami do umui kwatua, emui tamaka emui aena dekenai, emui itotohi emui imana dekenai. Do umui ania haraga. Inai be Lohiabada ena Pasova aria. ");
INSERT INTO hmo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Badina be unai hanuaboi dekenai, Aigupito tano do lau hanaia lao, edia vara guna natudia tau ibounai do lau alaia mase, taunimanima bona boromakau danu. Aigupito edia dirava ibounai danu do lau panisia momokani, badina be lau inai Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Inai rara umui emui noho rumadia dekenai be toana ta, toana be, umui be lau umui kamonai henia taudia. Rara do lau itaia neganai, do lau raka hanaia umui, lauegu badu ese do ia hadikaia lasi umui, Aigupito tano do lau botaia neganai. ");
INSERT INTO hmo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Inai dina danu do umui laloa noho hanaihanai, iena aria danu do umui karaia Lohiabada ena. Uru ibounai taudia danu ese do idia karaia, bona aria ena taravatu do idia badinaia hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Dina 7 lalonai paraoa gabua gaudia, hatubua lasi gaudia, do umui ania. Dina ginigunana dekenai hatubua muramura ibounai be emui ruma dekena amo do umui atoa siri murimuri dekenai, badina be dina 1 ia lao bona dina 7 lalonai hatubua paraoa do ia ania tauna be Israela ena bese dekena amo do umui negea momokani. ");
INSERT INTO hmo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","“Dina ginigunana dekenai hebou helagana do umui abia, dina namba 7 dekenai danu hebou helagana ma do umui abia. Unai dina ruaosi edia lalonai, gaukara ta do umui karaia lasi, to hebou taudia edia aniani sibona mo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Inai dina 7 edia dina ginigunana dekenai, Hatubua Lasi Paraoa ena aria do umui karaia, badina unai dina dekenai lau ese emui orea taudia Aigupito tano dekena amo lau hakaua siri. Inai dina dekenai, vairai lagani ibounai dekenai, emui bese taudia ese inai aria do idia karaia, ia lao bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Hatubua lasi paraoa do umui ania, hua ginigunana ena dina 14 adorahi, ia lao bona dina 21 adorahi. ");
INSERT INTO hmo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Dina 7 lalonai, paraoa hatubua ena muramura do ia noho lasi umui emui ruma dekenai, badina be hatubua paraoa do ia ania tauna, bema ia idau tauna, o Israela tauna momokani, be Israela ena hebou dekena amo do umui negea momokani. ");
INSERT INTO hmo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Hatubua paraoa umui ania lasi, umui emui noho gabuna ibounai dekenai, hatubua lasi paraoa sibona do umui ania.” ");
INSERT INTO hmo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Vadaeni Mose ese Israela tau badadia ibounai dekenai ia boiboi, ia hereva idia dekenai, ia gwau, “Mamoe o nani edia natuna umui abia hidi, famili ta ta edia, Pasova gauna do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mamoe ena rarana do umui bubua disi dekenai, vadaeni ava ta ladana husopo ena rigi haida do umui guia hebou. Inai husopo umui atoa rara lalonai, vadaeni ia dekena amo iduara ena au kahana kahana, bona iduara ena ataiai au dekenai rara dekena amo do umui dahua. Vadaeni umui Israela taudia ibounai be unai emui ruma lalonai do umui noho, tau ta ese iena ruma dekena amo do ia lao lasi murimuri dekenai, ela bona dabai. ");
INSERT INTO hmo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","“Badina be Lohiabada ese inai tano do ia raka hanaia, Aigupito taudia do ia alaia mase, to rara be iduara ena ataiai au bona iduara ena kahana kahana au dekenai do ia itaia neganai, Lohiabada ese unai iduara do ia raka hanaia sibona, Alaia Aneruna ena dala do ia koua, do ia vareai lasi umui emui ruma dekenai, do ia alaia lasi umui. ");
INSERT INTO hmo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Inai kara do umui badinaia, bona ena taravatu do umui atoa, umui bona emui natuna edia, lagani ibounai ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Bona Lohiabada ese umui do ia henia tano dekenai umui ginidae neganai, iena gwauhamata hegeregere, inai tomadiho karana do umui badinaia. ");
INSERT INTO hmo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Vadaeni umui emui natudia do idia nanadaia umui dekenai, do idia gwau, ‘Inai tomadiho karana ena anina be dahaka?’ ");
INSERT INTO hmo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Do umui haere, umui gwau, ‘Inai be Lohiabada ena Pasova boubou ena kara, Aigupito dekenai ia ese Israela taudia edia ruma ia raka hanaia lao, Aigupito taudia sibona mo ia alaia mase, bona iseda taudia ibounai ia hamauria.’ ” Inai hereva dainai taunimanima ibounai idia tui diho, Dirava dekenai idia toma diho. ");
INSERT INTO hmo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Vadaeni Israela taudia idia kamonai henia, idia lao, Lohiabada ese Mose bona Arona dekenai ia hadibaia hegeregerena, unai bamona sibona mo idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Vadaeni unai hanuaboi huana dekenai, Lohiabada ese vara guna memero ibounai Aigupito tano ibounai dekenai ia alaia mase, Farao, ena vara guna merona ia lao bona dibura ruma dekenai idia koua tauna ena vara guna merona, bona boromakau edia vara guna natudia danu. ");
INSERT INTO hmo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Vadaeni Farao bona iena hesiai taudia ibounai bona Aigupito taudia ibounai be hanuaboi idia toreisi, vadaeni taitai badana ia vara Aigupito dekenai, badina be mase ia vara ruma ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Vadaeni unai hanuaboi, Farao ese Mose bona Arona dekenai ia boiboi, ia gwau, “Umui toreisi, lauegu orea taudia edia huanai dekena amo umui raka siri, umui bona Israela taudia ibounai. Umui lao, Lohiabada dekenai do umui tomadiho, umui emui noinoi hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Umui emui mamoe ibounai, bona umui emui boromakau ibounai danu umui abia lao, umui emui noinoi hegeregerena. Vadaeni, umui lao. Bona emui hanamoa lau dekenai umui henia.” ");
INSERT INTO hmo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Aigupito taudia danu idia hereva goadagoada Israela taudia dekenai, idia noinoi, idia edia tano do idia rakatania haragaharaga, badina be idia gwau, “Ai ibounai do ai mase garina.” ");
INSERT INTO hmo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Vadaeni Israela taudia edia hatubua lasi paraoa, ranu dekenai idia kuia gaudia, idia abia, paraoa idia kuia ena disi danu idia abia, edia dabua dekenai idia kumia. Edia pagana dekenai idia atoa, idia huaia lao. ");
INSERT INTO hmo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israela taudia ese Mose ena hereva idia badinaia, Aigupito taudia edia herahera gaudia, golo bona siliva dekena amo idia karaia gaudia, bona dabua danu idia noia. ");
INSERT INTO hmo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Vadaeni Lohiabada ese Aigupito taudia edia lalona ia haidaua, Israela taudia dekenai idia matauraia, bona edia noinoi gaudia be idia henidia. Inai dala dekenai Aigupito taudia edia kohu idia kokia lao. ");
INSERT INTO hmo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Vadaeni Israela taudia be Ramese dekena amo idia laolao, Sukoto dekenai idia lao gwauraia. Aena dekenai idia raka tatau be 600,000 bamona, bona hahine mai natudia danu. ");
INSERT INTO hmo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Orea idauidau taudia momo herea danu ese idia bamoa lao, mai mamoe bona nani bona boromakau momo herea danu. ");
INSERT INTO hmo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Vadaeni inai hatubua lasi paraoa, ranu dekenai idia kuia, Aigupito tano dekena amo idia raka siri neganai idia abia gauna, be idia gabua. Paraoa idia hatubua lasi, badina be Aigupito tano dekena amo idia luludia murimuri haraga herea dainai, idia be nega hegeregere lasi aniani idia nadua totona. ");
INSERT INTO hmo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Inai Israela ena bese be Aigupito tano dekenai idia noho lagani ibounai be 430. ");
INSERT INTO hmo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Lagani 430 ia ore dinana momokani neganai, Lohiabada ena orea ibounai be Aigupito tano dekena amo idia raka siri. ");
INSERT INTO hmo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Unai hanuaboi dekenai Lohiabada ese Israela taudia ia naridia momokani, ia ese Aigupito dekena amo do ia hakaudia siri totona. Unai hanuaboi be Lohiabada ena, unai dainai Israela taudia ibounai ese unai hanuaboi do idia naria, bona laloatao, vairai lagani ibounai dekenai, ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Lohiabada ese Mose bona Arona ia hereva henidia, ia gwau, “Pasova aria ena taravatu be inai: Idau tauna ta do ia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","To emui hesiai taudia, moni dekena amo hoia taudia be, bema kopina utua kara do umui henidia guna, vadaeni unai murinai do idia ania diba. ");
INSERT INTO hmo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","To idau bese tauna, bema ia vadivadi, o bema moni davana totona ia gaukara, be Pasova do ia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ruma tamona lalonai mamoe natuna do umui ania, murimuri dekenai do umui abia lao lasi, bona iena turia ta do umui makohia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israela ena bese taudia ibounai be dohore idia ania. ");
INSERT INTO hmo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","To idau bese tauna, umui huana dekenai ia noho, bema ia ura Lohiabada ena Pasova do ia ania, iena ruma varavara taudia tatau bona memero ibounai dekenai kopina utua kara do umui henia guna, unai murinai do ia ania diba. Ia dekenai do umui laloa ia be Israela tauna hegeregere, to kopina utua kara ia abia lasi tauna be do ia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Taravatu be tamona, Israela tauna momokani iena, bona idau bese tauna umui huanai ia noho iena.” ");
INSERT INTO hmo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Israela taudia ibounai ese unai bamona idia karaia, Mose bona Arona dekenai Lohiabada ese ia hereva henidia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Unai dina dekenai, Lohiabada ese Israela taudia edia orea ta ta ibounai, Aigupito tano dekena amo ia hakaudia siri. ");
INSERT INTO hmo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Guna idia vara mero ibounai lau dekenai do umui hahelagaia. Israela edia vara guna mero, ia tau o ubua gauna, vadaeni ia be lauegu.” ");
INSERT INTO hmo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mose ese Israela taudia dekenai ia hamaoroa, ia gwau, “Hari dina, Aigupito umui rakatania ena dina, do umui laloatao noho nega ibounai. Badina be Aigupito tano, umui emui gaukara ia metau gabuna dekena amo, Lohiabada ese iena goada bada herea dekena amo umui ia hakaua siri. Hatubua paraoa do umui ania lasi. ");
INSERT INTO hmo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Inai dina dekenai, hua ladana Abiba ena lalonai, umui ese Aigupito tano umui rakatania. ");
INSERT INTO hmo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Lohiabada ese emui tubuna dekenai ia gwauhamata vadaeni Kanana taudia bona Hiti taudia bona Amoro taudia bona Hivi taudia bona Iebusu taudia edia tano do ia henia umui dekenai. Unai tano ia namo herea, mai aniani momo herea. Unai tano dekenai umui do ia hakaua vareai neganai, inai aria do umui karaia lagani ibounai ena hua ginigunana lalonai. ");
INSERT INTO hmo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Dina ibounai 7 edia lalonai, paraoa gabua gaudia, idia hatubua lasi gaudia, do umui ania. Vadaeni dina namba 7 dekenai, Lohiabada ena aria do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Unai dina 7 edia lalonai, idia hatubua lasi paraoa sibona do umui ania, idia hatubua paraoa do idia hedinaraia lasi umui dekenai, bona hatubua muramura danu do ia noho lasi umui emui noho gabuna ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Unai dina dekenai, emui natudia do umui hamaoroa, umui gwau, ‘Inai aria ena badina be, Lohiabada ese lau ia durua, Aigupito dekena amo lau ia hakaua siri neganai.’ ");
INSERT INTO hmo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Inai kara be toana ta, emui imana dekenai, o laloatao gauna ta emui baguna dekenai bamona. Inai be laloatao gauna dainai, emui uduna dekenai Lohiabada ena taravatu do umui herevalaia noho. Badina be Lohiabada ese mai iena siahu bada danu, Aigupito dekena amo ia hakaua siri umui. ");
INSERT INTO hmo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Unai dainai inai kara do umui badinaia, ena nega korikori dekenai, lagani ibounai lalonai.” ");
INSERT INTO hmo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ma Mose ia hereva, ia gwau, “Lohiabada ese Kanana taudia edia tano dekenai umui do ia hakaua vareai, umui dekenai ia gwauhamata, bona emui sene taudia dekenai ia gwauhamata hegeregerena, bona inai tano do ia henia umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Unai neganai umui emui vara guna memero ibounai Lohiabada dekenai do umui henia. Emui ubua gaudia danu, vara guna tau ibounai be Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Doniki vara guna tau ena davana do umui henia Lohiabada dekenai. Inai davana be mamoe ena natuna. Bema umui ura lasi iena davana do umui henia neganai, doniki ena aiona do umui makohia. To umui emui natuna tau, guna idia vara ibounai, be edia davana do umui karaia Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Vaira neganai, sedira emui natudia tau ese do idia nanadaia umui dekenai, do idia gwau, ‘Inai kara ena anina be dahaka?’ Do umui haere, umui gwau, ‘Lohiabada ese mai ena siahu bada, Aigupito, gaukara idia metau gabuna, dekena amo ai ia hakaua siri. ");
INSERT INTO hmo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","“ ‘Vadaeni Farao ese ia auka, bona ai ia dogoatao gwauraia neganai, Lohiabada ese guna idia vara memero ibounai Aigupito tano dekenai ia alaia mase, taunimanima bona ubua gaudia danu. Vadaeni guna idia vara ubua gaudia ibounai be Lohiabada ena boubou gauna dekenai ai halaoa, to aiemai natuna tau, guna idia vara, be ai hoia lou, edia davana ai karaia Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Inai kara be laloatao ena toana ta, oiemu imana dekenai, o toa ta oiemu baguna dekenai bamona, badina be Lohiabada ese mai siahu bada danu Aigupito dekena amo ai ia hakaua siri.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Farao ese Israela taudia iena imana dekena amo ia negea murinai, Dirava ese dala kwadogi, Pilistia taudia edia tano dekenai ia hakaudia lasi, badina be Dirava ia gwau, “Idia be tuari ena mamina do idia abia neganai, edia lalona do idia giroa, Aigupito dekenai do idia giroa lou sedira.” ");
INSERT INTO hmo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Vadaeni Dirava ese taunimanima idia noho lasi gabuna dekenai ia hakaudia lao, Davara Kakakaka dekenai do idia lao gwauraia. Israela taudia be mai edia tuari gaudia ibounai edia imana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose ese Iosepa ena turiana be ia dekenai ia abia lao, badina be Iosepa ese guna Israela taudia dekenai taravatu ia atoa, ia gwau, “Dirava be momokani do ia durua umui dekenai, unai neganai lauegu turiana do umui abia lao inai tano dekena amo.” ");
INSERT INTO hmo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Vadaeni idia laolao, Sukoto dekena amo idia raka lao, bona Etama, taunimanima idia noho lasi tano ena badibadinai idia kamepa. ");
INSERT INTO hmo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Dina neganai Lohiabada be ori lalonai ia noho, bona idia edia vairana dekenai ia lao, edia dala ia hedinaraia totona. Hanuaboi neganai Lohiabada be lahi lalonai ia noho, bona idia edia vairanai ia lao, edia dala hadiaria totona. Unai dainai, dina neganai, bona hanuaboi neganai danu, idia laolao diba. ");
INSERT INTO hmo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Inai ori be dina negana ibounai idia edia vairanai ia noho, bona unai lahi be hanuaboi negana ibounai idia edia vairanai ia noho. ");
INSERT INTO hmo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Vadaeni Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Israela taudia dekenai oi hamaoroa, idia giroa lou, Pi Hahiroto ena vairana dekenai do idia kamepa karaia, davara ena badibadinai. Inai gabu be Migidola bona davara edia huana dekenai, Bala Sepona kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Badina Farao be inai bamona do ia laloa, ‘Israela taudia be taunimanima idia noho lasi gabuna dekenai idia raka kava, raka kava noho, bona unuseni be do idia boio bamona.’ ");
INSERT INTO hmo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Vadaeni lau ese Farao ena lalona do lau ha-aukaia, bona umui emui murina dekenai do ia mai haragaharaga. To lau ese Farao bona ena tuari taudia ibounai do lau halusia, do lau kwalimu, vadaeni lauegu ladana do ia bada. Unai neganai Aigupito taudia do idia diba lau be Lohiabada.” Vadaeni Israela taudia ese Lohiabada ena hereva hegeregerena idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Unai neganai haida ese Aigupito ena king dekenai idia hamaoroa, idia gwau, “Israela taudia be idia heau vadaeni.” Vadaeni Farao bona iena hesiai taudia ese edia lalona ma idia haidaua, Israela taudia dekenai. Idia gwau, “Israela taudia ita dekena amo ita negea, ita dekenai hesiai gaukara dekena amo idia doko, ena anina be dahaka?” ");
INSERT INTO hmo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Vadaeni Farao ese iena kariota ia karaia hegaegae, bona iena orea taudia ia hakaudia lao. ");
INSERT INTO hmo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Kariota namodia 600 idia abia hidi, bona kariota haida ma danu idia abia lao. Inai Aigupito kariota ta ta ibounai, be mai edia kapena. ");
INSERT INTO hmo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Unai neganai Lohiabada ese Farao, Aigupito ena king, ena lalona ia ha-aukaia, vadaeni ia ese Israela taudia edia murina dekenai ia heau lao haragaharaga, badina be Israela taudia idia raka siri, idia gari lasi bamona. ");
INSERT INTO hmo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Inai Aigupito ena tuari orea be mai edia kariota, mai edia hosi momo, mai edia guia taudia, bona aena dekenai idia raka tuari taudia momo danu. Vadaeni idia ese Israela taudia dekenai idia ginidae, edia kamepa dekenai, Davara Kakakaka ena badibadinai, Pi Hahiroto ena vairanai, Bala Sepona kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Farao, mai ena tuari orea idia raka mai kahirakahira, vadaeni Israela taudia ese edia matana idia negea, idia itaia, Aigupito taudia be idia ginidae vadaeni idia dekenai. Vadaeni idia gari dikadika, bona Lohiabada dekenai idia taitai. ");
INSERT INTO hmo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Vadaeni idia gwau henia Mose dekenai, idia gwau, “Aigupito dekenai guria gabuna idia noho lasi, a? Unai dainai oi ese oi hakaua siri ai, taunimanima idia noho lasi tano dekenai, ai mase totona, a? Badina be dahaka Aigupito dekena amo ai oi hakaua siri? ");
INSERT INTO hmo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ai be Aigupito dekenai ai hereva lasi oi dekenai, a, ai gwau, ‘Lasi, ai dekena amo oi raka siri, ai be Aigupito taudia edia hesiai do ai lao henia noho,’ a? Badina be Aigupito taudia edia hesiai ai lao henia noho be ia namo, to taunimanima idia noho lasi tano dekenai ai mase be ia dika.” ");
INSERT INTO hmo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","To Mose ia gwau, “Umui gari lasi, umui gini auka masemase, Lohiabada ena hamauria kara do umui itaia, hari dina umui dekenai do ia hamauria, badina be Aigupito taudia harihari umui itaia, be do umui itaia lou lasi, lasi bona lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Lohiabada be umui totona do ia tuari karaia, umui be do umui noho kava sibona.” ");
INSERT INTO hmo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Lohiabada ese Mose dekenai ma ia hamaoroa, ia gwau, “Dahaka totona umui taitai lau dekenai? Israela taudia dekenai oi hereva henia, do idia raka lao. ");
INSERT INTO hmo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Oiemu itotohi oi abia isi, bona oiemu imana davara ena ataiai oi atoa lao maoromaoro, ranu oi hapararaia, vadaeni Israela taudia be tano kaukau dekenai do idia raka hanaia. ");
INSERT INTO hmo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","To lau be Aigupito taudia edia lalona do lau ha-aukaia, vadaeni umui emui murina dekenai do idia mai haragaharaga, vadaeni Farao bona iena tuari orea ibounai, iena kariota bona iena hosi dekenai guia taudia, do lau halusia. ");
INSERT INTO hmo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Lau ese idia do lau halusia, kwalimu do lau abia, vadaeni Aigupito taudia be do idia diba lau be Lohiabada.” ");
INSERT INTO hmo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Vadaeni Dirava ena aneru, Israela ena kamepa ena vairana dekenai ia noho aneruna, be edia murina kahana dekenai ia lao, bona unai ori danu, be idia edia vairana dekena amo ia abia isi, idia edia murina kahana dekenai ia lao, vadaeni unuseni ia noho. ");
INSERT INTO hmo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Unai ori be Aigupito taudia edia kamepa bona Israela taudia edia kamepa edia huanai ia gini. Vadaeni ori ese Aigupito taudia dekenai dibura ia havaraia, to Israela taudia dekenai diari ia havaraia, ela bona hanuaboi ta ia ore. Bona unai hanuaboi ena hora ibounai orea ta ese orea ta dekenai ia raka kahirakahira lasi. ");
INSERT INTO hmo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mose ese iena imana ia atoa maoromaoro davara ena ataiai, vadaeni Lohiabada ese lai, dina ia daekau kahana dekena amo ia siaia, davara ia haloua, vadaeni davara ia hapararaia. Hanuaboi ena hora ibounai be lai ia toa, bona davara be tano kaukau Lohiabada ese ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Vadaeni Israela taudia ese tano kaukauna dekenai davara idia raka hanaia, davara ena ranu be haba bamona edia imana idiba kahana dekenai, bona edia imana lauri kahana dekenai danu. ");
INSERT INTO hmo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Vadaeni Aigupito taudia ese davara ena huanai dekena amo idia luludia haragaharaga, Farao ena hosi bona iena kariota bona iena hosi guia taudia ibounai ese. ");
INSERT INTO hmo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","To daba rere ia kahirakahira neganai, Lohiabada ese unai lahi bona ori edia ataiai dekena amo, Aigupito taudia edia tuari oreana dekenai ia itaia noho, bona ia ese daradara bada herea ia havaraia idia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Edia kariota edia uili be idia diho miri dekenai, vadaeni kariota idia heau namonamo lasi. Unai dainai Aigupito taudia sibona dekenai idia hereva henia, idia gwau, “Israela taudia edia vairana dekena amo do ita heau, badina be Lohiabada ese durua ia henia idia dekenai, to ia tuari henia ita dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Vadaeni Lohiabada ese Mose dekenai ia hereva, ia gwau, “Oiemu imana be davara ena ataiai ma oi atoa maoromaoro, ranu do ia giroa lou Aigupito taudia edia latanai, bona kariota edia latanai, bona hosi guia taudia edia latanai.” ");
INSERT INTO hmo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Vadaeni Mose ese iena imana ia atoa maoromaoro davara ena ataiai. Vadaeni daba ia rere neganai, davara ma ia giroa lou ena gabu korikori dekenai, vadaeni Aigupito taudia be davara ena vairana dekenai idia heau gwauraia. Unai bamona dekena amo Lohiabada ese Aigupito taudia ia negedia davara lalonai. ");
INSERT INTO hmo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ranu ia giroa lou, kariota bona hosi guia taudia bona Farao ena tuari orea ibounai, davara ena huana dekenai Israela taudia edia murina dekenai idia mai taudia ibounai, be ranu ese ia koua, ta ia mauri lasi. ");
INSERT INTO hmo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","To Israela taudia be tano kaukau dekenai idia raka hanaia, davara ena huana dekenai, ranu be haba bamona, edia imana idiba kahana dekenai, bona edia imana lauri kahana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Unai dina dekenai Lohiabada ese Israela taudia be Aigupito taudia edia imana dekena amo ia hamauria, vadaeni Israela taudia ese Aigupito taudia idia itaia mai mase danu, idia hekure noho kone dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Aigupito taudia dekenai Lohiabada ese edena bamona ia karaia, be Israela taudia ese idia itaia, vadaeni idia gari Lohiabada dekenai, idia abidadama henia Lohiabada dekenai, iena hesiai tauna Mose danu idia abidadama henia. ");
INSERT INTO hmo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Vadaeni Mose bona Israela taudia ese inai ane idia abia, Lohiabada ena, idia gwau: Lau be ane do lau abia, Lohiabada ena, badina be ia kwalimu herea vadaeni. Hosi bona idia guia taudia, be davara dekenai ia negea diho vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Lohiabada ese iena goada, bona iena siahu, be lau dekenai ia henia. Ia sibona ese lau ia hamauria vadaeni. Lauegu Dirava inai, iena ladana do lau hanamoa. Ia be egu tamana ena Dirava, bona iena ladana do lau habadaia egu ane dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Lohiabada be tuari tauna, iena ladana be Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Farao ena kariota bona iena tuari oreana, be davara dekenai ia negea diho vadaeni. Iena tuari biagudia namo herea taudia, be Davara Kakakaka dekenai idia mase vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Davara ese ia koudia momokani. Dobu gabuna dekenai idia diho, nadi bamona. ");
INSERT INTO hmo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Lohiabada e, oiemu imana idiba kahana, ena siahu be namo herea momokani. Lohiabada e, oiemu imana idiba kahana ese, ai dekenai idia tuari henia taudia ia alaia mase vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Oiemu siahu bada herea momokani ese, oi dekenai idia tuari henia taudia ia halusia. Oiemu badu ese lahi bamona Aigupito taudia ia gabua ore, rei kakoro ia gabua ore bamona. ");
INSERT INTO hmo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Hurehure dekenai, oiemu uduna ena hodahoda oi henia, vadaeni hurehure idia haboua. Idia lao gabu tamona dekenai haboua, idia gini haba bamona. Davara ena dobu gabuna dekenai, be iena tano ia auka momokani. ");
INSERT INTO hmo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Tuari henia tauna ia gwau, “Idia do lau lulua, bona idia do lau dogoatao. Edia kohu be do lau haria karaia, bona lauegu ura idia dekenai do lau karaia. Lauegu tuari kaia do lau abia isi, bona egu goada dekena amo edia kohu ibounai do lau abia.” ");
INSERT INTO hmo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","To oiemu lai tamona oi siaia, vadaeni davara ese inai tuari taudia ia koua. Idia be davara dekenai idia diho, auri ia metau bamona. ");
INSERT INTO hmo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Lohiabada e, dirava ibounai edia huanai, oi bamona ta be daika? Oi hegeregere be daika? Helaga dekenai oi be herea momokani. Daika be oi bamona? Hoa karadia oi karaia, bona kara badadia mai gari danu oi karaia noho. ");
INSERT INTO hmo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Oiemu imana idiba kahana oi atoa maoromaoro, vadaeni tano ese ai dekenai idia tuari taudia ia ania ore. ");
INSERT INTO hmo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Oi hamauria vadaeni besena oi ese oi gunalaia, oiemu gwauhamata hegeregerena. Oiemu goada dekenai oi hakaudia vadaeni, ia mai bona oiemu gabu helagana. ");
INSERT INTO hmo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Bese idauidau oiemu kara ena sivarai idia kamonai, vadaeni idia gari, idia heudeheude. Pilistia taudia edia gari, be mara ena hisihisi bamona. ");
INSERT INTO hmo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edoma lohia taudia danu idia gari dikadika noho. Moaba edia siahu taudia danu idia gari momo. Kanana noho taudia ibounai edia lalona goada ia ore vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Edia kudouna dekenai idia hoa mai gari danu. Oiemu goada ia bada herea dainai, idia be nadi hegeregerena idia gini, idia marere lasi, ia lao bona oiemu taunimanima korikori ese idia hanaia vadaeni. Lohiabada e, ela bona oi ese oi ruhaia taudia ese, idia raka hanaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Oi ese idia do oi hakaua vareai, bona oiemu ororo korikori ena latanai do oi atodia. Oi Lohiabada ese oiemu noho gabuna dekenai oi halaoa vadaeni gabuna inai. Oi Lohiabada oiemu imana ese inai Dubu Helaga oi haginia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Lohiabada e, oi be do oi King ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Momokani Israela taudia be tano kaukau dekenai idia raka, davara ena huana dekenai. To Farao ena hosi bona ena kariota bona iena hosi guia taudia be davara ena lalona dekena amo idia heau lao, vadaeni Lohiabada ese davara ia abia lou, bona iena hurehure dekena amo idia ia koua. ");
INSERT INTO hmo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Vadaeni Miriama, peroveta hahine, Arona ena taihuna, ese tareko ia abia iena imana dekenai, bona hahine ibounai ese edia tareko idia abia, Miriama ena murina dekenai idia lao, mai mavaru danu. ");
INSERT INTO hmo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Vadaeni Miriama ese tatau edia ane ena davana ia karaia, ane ia abia, ia gwau: Ane do umui abia, Lohiabada ena, badina be ia kwalimu herea vadaeni, ia ese hosi bona guia taudia, be davara dekenai ia negea diho. ");
INSERT INTO hmo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Vadaeni Mose ese Israela taudia Davara Kakakaka dekena amo ia hakaudia lao. Taunimanima noho lasi gabuna ena ladana Suru dekena amo ia hakaudia hanai, bona dina toi taunimanima noho lasi gabuna dekenai idia laolao, ranu idia davaria lasi. ");
INSERT INTO hmo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Vadaeni Dika Ranuna Gabuna dekenai idia ginidae, to inai gabu ena ranu idia inua diba lasi, badina ena mamina be ia dika. Unai dainai ena ladana idia atoa Dika Ranuna Gabuna. ");
INSERT INTO hmo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Vadaeni laolao taudia ese Mose dekenai idia hereva badubadu, idia gwau, “Ai be dahaka dohore ai inua?” ");
INSERT INTO hmo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Vadaeni Mose ia noinoi goada Lohiabada dekenai, vadaeni Lohiabada ese au ta ia hedinaraia Mose dekenai, Mose ese inai au ia atoa diho ranu dekenai, vadaeni ranu ese mamina namo ia davaria. Unai gabu dekenai Lohiabada ese taravatu ia henia idia dekenai, idia edia goada do ia tohoa totona. ");
INSERT INTO hmo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ia gwau, “Bema umui ese Lohiabada emui Dirava ena gadona umui kamonai henia, bona bema lauegu vairana dekenai emui kara ia maoromaoro, bona bema lauegu hagoadaia hereva umui badinaia, bona bema lauegu taravatu umui naria namonamo, lau ese gorere idauidau do lau henia lasi umui dekenai, Aigupito taudia dekenai gorere lau henia hegeregerena, badina lau be Lohiabada, umui lau hamauria Diravana.” ");
INSERT INTO hmo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Vadaeni idia be Elima dekenai idia ginidae, unuseni ranu guri be 12, bona pama audia be 70. Vadaeni inai ranu guri ena badibadinai idia kamepa. ");
INSERT INTO hmo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Israela bese taudia ibounai be Elima dekena amo idia lao, bona taunimanima idia noho lasi gabuna ena ladana Sini dekenai idia ginidae, Elima bona Sinai edia huanai. Hua iharuana ena dina 15, Aigupito idia rakatania murinai, unai Sini dekenai idia ginidae. ");
INSERT INTO hmo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Vadaeni Israela taudia ibounai ese Mose bona Arona dekenai idia maumau, taunimanima idia noho lasi gabuna dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israela taudia ese idia ruaosi dekenai idia gwau henia, idia gwau, “Aigupito tano dekenai Lohiabada ese ai bema ia alaia mase be namo. Unuseni uro mai vamu danu edia badibadinai ai helai noho, bona paraoa ai ania noho, aiemai ura hegeregerena. To umui ruaosi ese inai taunimanima idia noho lasi gabuna dekenai ai umui hakaua vareai vadaeni, hitolo ese ai ibounai do ia alaia mase totona.” ");
INSERT INTO hmo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Vadaeni Lohiabada ese Mose ia hamaoroa, ia gwau, “Oi kamonai, lau ese emui aniani guba dekena amo do lau atoa diho, medu bamona, taunimanima be dina ta ta do idia raka lao, dina tamona ena aniani do idia haboua. Unai dekena amo do lau diba be, lauegu taravatu do idia badinaia o lasi. ");
INSERT INTO hmo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Dina namba 6 idia be dina rua ena aniani do idia karaia hegaegae.” ");
INSERT INTO hmo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Vadaeni Mose bona Arona ese Israela taudia dekenai idia hereva, idia gwau, “Hari adorahi do umui diba Lohiabada ese Aigupito tano dekena amo ia hakaua siri umui. ");
INSERT INTO hmo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Bona dabai Lohiabada ena hairaina do umui itaia. Badina be umui emui maumau, Lohiabada dekenai umui maumau, herevana ia kamonai vadaeni. To ai be daika, umui maumau ai dekenai?” ");
INSERT INTO hmo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mose ma ia gwau, “Lohiabada ese vamu do ia henia adorahi, bona aniani do ia henia dabai, umui emui boga ia kunu totona, badina be umui emui maumau, Lohiabada dekenai umui maumau, herevana ibounai ia kamonai vadaeni. To ai be daika? Umui emui maumau be ai dekenai umui maumau lasi, to Lohiabada dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Vadaeni Mose ese Arona dekenai ia hamaoroa, ia gwau, “Israela taudia ibounai dekenai do oi hereva, oi gwau, ‘Umui mai, Lohiabada ena vairana dekenai do umui gini. Badina be ia ese umui emui maumau herevana ia kamonaia vadaeni.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Vadaeni Arona ese Israela taudia ibounai dekenai ia hereva henia neganai, idia ese taunimanima noho lasi gabuna idia itaia noho, vadaeni Lohiabada ena hairaina be ori lalonai ia diaridiari, idia itaia. ");
INSERT INTO hmo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Lohiabada ese Mose dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Israela taudia edia maumau lau kamonai vadaeni. Inai bamona do oi hamorodia, ‘Adorahi neganai vamu do umui ania, bona dabai aniani do umui ania emui ura hegeregerena. Vadaeni do umui diba lau be Lohiabada, emui Dirava.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Adorahi neganai, manu momo, edia ladana kibi idia roho mai, kamepa ena gabu ibounai idia noho. Daba neganai hanuaboi ena ranu be kamepa ena tano ibounai dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Unai hanuaboi ena ranu ia kaukau neganai, gau maragidia idia noho tano dekenai, edia toana be kurokuro, aisi medu ranu ia auka bamona. ");
INSERT INTO hmo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israela taudia ese unai gauna idia itaia neganai, idia sibona dekenai idia nanadaia, idia gwau, “Inai be dahaka?” Mose ese idia dekenai ia hamaoroa, ia gwau, “Inai be aniani, Lohiabada ese ia henia gauna, umui ania totona. ");
INSERT INTO hmo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Lohiabada be inai bamona ia oda: Umui ta ta umui haboua, umui hitolo hegeregerena, taunimanima ta disi ta, ena bada kapusi badadia 4 bamona. Ruma biagudia ese edia ruma taudia edia aniani unai bamona do idia haboua.” ");
INSERT INTO hmo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Vadaeni Israela taudia be inai bamona idia karaia. Haida idia abia momo, haida idia abia momo lasi. ");
INSERT INTO hmo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","To idia hahetoho karaia neganai, idia abia momo taudia be aniani ena momoru ia noho lasi, bona idia abia momo lasi taudia be idia ania, bona bogadia idia kunu. Idia ta ta idia gogoa gauna be momokani edia hitolo hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose ese idia dekenai ia hamaoraoa, ia gwau, “Aniani momoru do ia noho lasi ia lao bona dabai.” ");
INSERT INTO hmo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","To Mose ena hereva dekenai haida idia kamonai lasi, idia be aniani momoru idia dogoatao ia lao bona dabai. Vadaeni gaigai maragimaragi idia hadikaia, bona bonana ia dika herea. Mose be ia badu idia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Daba ibounai idia haboua, ta ta edia hitolo hegeregerena. To dina ia siahu neganai, tano dekenai do noho gauna ia veve haorea. ");
INSERT INTO hmo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Dina namba 6 dekenai, idia ese dina rua ena aniani idia haboua, taunimanima ta ta disi rua, ena bada kapusi badadia 8 bamona. Israela edia gunalaia tau badadia ibounai Mose dekenai idia lao, edia haboua kara idia hamaorolaia. ");
INSERT INTO hmo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Vadaeni ia ese idia dekenai ia hamaoroa, ia gwau, “Lohiabada ese inai oda ia gwauraia, ia gwau: Kerukeru be laga-ani dinana, Lohiabada ena Sabati Dina. Umui ura gabua gaudia umui gabua, nadua gaudia umui nadua, bona aniani momoru do idia noho ia lao dabai.” ");
INSERT INTO hmo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Vadaeni Mose ia oda hegeregerena, aniani momoru idia dogoatao ia lao bona dabai. Ia be ia bodaga lasi, bona gaigai maragidia idia noho lasi. ");
INSERT INTO hmo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose ia gwau, “Hari dina lalonai aniani momoru sibona umui ania, badina hari be Lohiabada ena Sabati Dina dainai aniani gauna ta do umui davaria lasi tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Dina 6 lalonai do umui haboua, to dina namba 7, aniani be do umui davaria lasi, badina ia be laga-ani dinana.” ");
INSERT INTO hmo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Dina namba 7 be taunimanima haida idia lao, aniani haboua totona, to gau ta idia davaria lasi. ");
INSERT INTO hmo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Vadaeni Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Lauegu oda bona lauegu taravatu be umui negea, ia lao bona edena negai? ");
INSERT INTO hmo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Umui laloa, lau Lohiabada ese laga-ani dinana umui dekenai lau henia vadaeni. Unai dainai dina namba 6 lalonai dina rua ena aniani lau henia. Dina namba 7 lalonai emui noho gabuna dekenai do umui noho, emui ruma do umui rakatania lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Unai dainai taunimanima be dina namba 7 lalonai gaukara ta idia karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israela taudia ese unai aniani ena ladana idia atoa be mana, ena anina be “Dahaka gau?” Ia be uhe nadinadi kurokurona bamona, bona ena mamina be hani bona paraoa dekena amo keke palaka idia karaia bamona. ");
INSERT INTO hmo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose ia gwau, “Lohiabada ese inai oda ia henia, ia gwau: Uro ta mai koua gauna be inai mana dekenai do umui hahonua. Inai be do ia noho, gabeai idia vara emui bese taudia ese do idia itaia totona. Vadaeni do idia diba inai mana dekena amo umui lau ubua, Aigupito dekena amo umui lau hakaua, bona taunimanima idia noho lasi tano dekenai umui noho neganai.” ");
INSERT INTO hmo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Vadaeni Mose ese Arona dekenai ia hamaoroa, ia gwau, “Uro ta oi abia, mana hegeregere kapusi badadia 4 oi udaia. Lohiabada ena vairana dekenai do oi atoa, vadaeni ia noho, oiemu bese, gabeai idia vara taudia do idia itaia, bona laloa totona.” ");
INSERT INTO hmo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Unai dainai, Arona ese uro be gabu helagana ta Lohiabada ena vairana dekenai ia atoa, unuseni do ia noho totona, Lohiabada ena oda Mose dekenai hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Lagani 40 lalonai, Israela taudia ese mana idia ania, ia lao bona Kanana tano ena hetoa gabuna dekenai idia ginidae. ");
INSERT INTO hmo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Uro ta ena anina be kapusi badadia 4 edia anina hegeregerena, bona uro 10 edia anina be Heberu edia hahetoho gauna epa ta ena anina hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israela taudia ibounai ese taunimanima noho lasi gabuna ladana Sini idia rakatania, vadaeni idia laolao, gabu ta ta dekenai idia kamepa, Lohiabada ese oda ia henia hegeregerena. Repidima dekenai kamepa ta idia karaia, to inuinu ranu be lasi. ");
INSERT INTO hmo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Mose dekenai idia maumau, idia gwau, “Inuinu ranu ai dekenai oi henia.” Mose ia haere, ia gwau, “Badina be dahaka lau dekenai umui maumau? Badina dahaka Lohiabada dekenai umui dibagania?” ");
INSERT INTO hmo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","To taunimanima be idia ranu mase, bona Mose dekenai idia maumau noho. Idia gwau, “Badina dahaka Aigupito dekena amo oi hakaua ai? Aiemai natuna alaia, bona aiemai ubua gaudia alaia totona oi karaia sedira, ranu mase dekena amo.” ");
INSERT INTO hmo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mose ese Lohiabada dekenai ia noinoi goada, ia gwau, “Inai taunimanima dekenai dahaka do lau karaia? Idia be lau do idia hodoa mase gwauraia.” ");
INSERT INTO hmo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Israela ena gunalaia taudia haida oi danu umui lao, taunimanima edia vairana dekenai do umui raka guna. Oiemu itotohi, Naila Sinavai oi botaia gauna, oi abia lao. ");
INSERT INTO hmo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Lau be oiemu vairana dekenai do lau gini Sinai Ororo ena nadi badana dekenai. Vadaeni nadi badana do oi botaia, bona ranu be nadi dekena amo do ia mai, taunimanima do idia inua totona.” Mose be inai bamona ia karaia Israela ena gunalaia taudia edia vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Unai gabu ena ladana idia atoa Masa, ena anina be “Dibagani”, bona Meriba, ena anina be “Maumau”, badina be Israela taudia ese idia maumau, bona Lohiabada idia dibagania dainai. Badina unai neganai edia hereva be, “Lohiabada be ita dekenai ia noho o lasi?” ");
INSERT INTO hmo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Repidima dekenai idia noho neganai, Amaleka taudia idia mai, idia tuari henidia. ");
INSERT INTO hmo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mose ese Iosua dekenai ia hereva, ia gwau, “Tau haida oi abia hidi, vadaeni kerukeru Amaleka taudia do umui tuari henidia. Ororo ena ataiai do lau gini, Lohiabada ese lau dekenai ia henia itotohi be egu imana dekenai do lau dogoatao.” ");
INSERT INTO hmo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Vadaeni Iosua ese Mose ena oda hegeregerena ia karaia, Amaleka taudia dekenai ia tuari henia. Unai ia karaia neganai, Mose, Arona bona Huru be idia daekau ororo ena ataiai dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mose ese iena imana ruaosi ia abia isi neganai, Israela taudia idia kwalimu noho, to iena imana ia atoa diho neganai, Amaleka taudia idia kwalimu noho. ");
INSERT INTO hmo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mose ena imana idia mase neganai, Arona bona Huru ese nadi ta idia abia, iena murina dekenai idia atoa, nadi latanai ia helai. Vadaeni idia ruaosi kahana kahana idia gini, iena imana ruaosi idia abia isi. Arona bona Huru ese Mose ena imana idia abia isi, ia lao bona dina ia diho. ");
INSERT INTO hmo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Vadaeni Iosua ese Amaleka taudia ia halusia momokani. ");
INSERT INTO hmo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Buka ta lalonai inai tuari kwalimu sivaraina do oi torea, taunimanima do idia laloatao totona. Bona Iosua do oi hamaoroa, lau be Amaleka taudia edia sivarai do lau haorea momokani.” ");
INSERT INTO hmo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Vadaeni Mose ese boubou patana ta ia haginia, bona iena ladana ia atoa, “Lohiabada be lauegu pepe.” ");
INSERT INTO hmo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Vadaeni Mose ia gwau, “Lohiabada ese ia gwauhamata vadaeni inai: Lohiabada ese Amaleka taudia do ia tuari henia noho, ia lao hanaihanai.” ");
INSERT INTO hmo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ietero be Midiana ena hahelagaia tauna, bona ia be Mose ena ravana. Ietero ese Mose bona Israela taudia Dirava ese ia durua ena sivarai ibounai ia kamonai. Bona Lohiabada ese Israela taudia Aigupito dekena amo ia hakaudia lao noho ena sivarai danu be Ietero ia kamonai. ");
INSERT INTO hmo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mose be guna iena adavana Sipora ia siaia lou iena tamana dekenai. Vadaeni hari Ietero ese Sipora ia mailaia lou Mose dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Ietero ese Sipora ena natuna memero rua Geresome bona Eliesere danu ia mailaia. Mose be guna ia gwau, “Lau be idau tano dekenai lau noho vadaeni.” Unai dainai iena natuna ta ena ladana ia atoa Geresome, ena anina Heberu gado dekenai be “idau tano noho.” ");
INSERT INTO hmo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Inai bamona ia gwau danu, “Egu tamana ena Dirava be egu durua tauna, bona Farao ena kaia dekena amo lau ia hamauria vadaeni.” Unai dainai iena natuna ta ena ladana ia atoa Eliesere, ena anina Heberu gado dekenai be “Dirava be egu durua tauna.” ");
INSERT INTO hmo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ietero, Mose ena ravana, be Mose ena adavana bona natuna danu idia mai, taunimanima noho lasi gabuna dekenai, bona Dirava ena ororo kahirakahira dekenai idia ginidae. Unuseni Mose ia kamepa noho. ");
INSERT INTO hmo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Ietero ese hereva ia siaia guna Mose dekenai, ia gwau, “Lau, Ietero, oiemu ravana, be oi dekenai lau mai, oiemu adavana bona natuna memero rua danu.” ");
INSERT INTO hmo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Vadaeni Mose ese ia dekenai ia lao, hedavari totona. Mose ese iena ravana ena vairana dekenai iena kwarana ia atoa diho, ia kisi henia. Edia mauri be edena bamona, be idia sibona ta ta dekenai idia henanadaia, vadaeni palai ruma dekenai idia raka vareai. ");
INSERT INTO hmo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose ese Lohiabada ena kara ibounai ena sivarai iena ravana dekenai ia hamaoroa. Ia hamaoroa Lohiabada ese edena bamona Farao bona Aigupito taudia dekenai ia karaia, Israela taudia dainai. Danu ia hamaoroa edena bamona idia hekwarahi bada, dala dekenai, bona edena bamona Lohiabada ese idia ia hamauria. ");
INSERT INTO hmo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ietero ia moale bada, Lohiabada ena bogahisihisi ese Israela taudia ia hamauria Aigupito taudia dekena amo dainai. ");
INSERT INTO hmo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ietero ia gwau, “Lohiabada ita hanamoa, ia ese Aigupito taudia edia imana dekena amo, bona Farao ena imana dekena amo umui ia hamauria vadaeni. Danu ita hanamoa, badina be Aigupito taudia edia guia dekena amo Lohiabada ese iena bese taudia ia ruhaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Harihari lau diba Lohiabada ese dirava ibounai ia hereaia noho. Badina be Aigupito taudia be mai hekokoroku danu Israela idia hadikaia neganai, Lohiabada ese Aigupito ia halusia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Vadaeni Ietero ese lahi ia gabua ore boubou gauna ia henia Dirava dekenai. Boubou gaudia haida ma danu Dirava dekenai ia henia. Unai neganai Arona bona Israela tau badadia ibounai idia haboua, Mose ena ravana danu idia aniani hebou, Dirava ena vairanai. ");
INSERT INTO hmo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kerukeru dabai, Mose ese taunimanima ia kota henidia, iena vairana dekenai taunimanima idia gini, daba ia lao bona hanuaboi. ");
INSERT INTO hmo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ietero, Mose ena ravana ese inai kara ibounai ia itaia neganai ia nanadaia, ia gwau, “Inai oi karaia taunimanima dekenai ena anina be dahaka? Badina dahaka oi sibona oi helai, bona taunimanima ibounai oiemu vairana dekenai idia gini noho daba ia lao bona hanuaboi?” ");
INSERT INTO hmo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose ia haere, ia gwau, “Lau be inai bamona lau karaia badina be taunimanima be lau dekenai idia mai, Dirava ena ura do idia diba totona. ");
INSERT INTO hmo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Bema tau rua idia heai neganai, lau kota henidia, bona Dirava ena oda bona ena taravatu lau hadibaia idia dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Vadaeni Ietero ese ia hamaoroa, ia gwau, “Oiemu kara be ia namo lasi. ");
INSERT INTO hmo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Oiemu goada be do ia ore, inai taunimanima danu edia goada be do ia ore. Badina be inai gaukara ia metau bada. Oi sibona do oi karaia diba lasi. ");
INSERT INTO hmo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Lauegu hereva oi kamonai, sisiba namona oi dekenai do lau henia, bona Dirava ese oi do ia hanamoa. Oi be taunimanima durua totona, Dirava ena vairanai do oi gini, edia heai be ia dekenai do oi gwauraia hedinarai totona. ");
INSERT INTO hmo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Oi ese danu Dirava ena oda bona iena taravatu idia dekenai do oi hadibaia. Edia mauri dalana bona edena bamona do idia noho, do oi hedinaraia. To inai danu do oi karaia: ");
INSERT INTO hmo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tau haida, mai edia aonega danu do oi abia hidi, Dirava dekenai idia gari taudia, bona moni abia hunia dala karana idia ura lasi taudia. Taunimanima gunalaia taudia do oi halaodia, 1000 ta ta edia gunalaia taudia, 100 ta ta edia gunalaia taudia, 50 ta ta edia gunalaia taudia, 10 ta ta edia gunalaia taudia. ");
INSERT INTO hmo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Idia ese kota biaguna gaukara do idia karaia noho dina ibounai. Hereva badadia be oi dekenai do idia mailaia, to hereva maragidia be idia sibona do idia tahua. Inai dala dekenai oiemu gaukara be do ia metau bada lasi, badina gaukara umui haria dainai. ");
INSERT INTO hmo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","“Bema inai bamona oi karaia, Dirava ena oda hegeregerena, oiemu goada be do ia ore lasi, bona inai taunimanima be do idia giroa edia rumadia dekenai, mai edia maino danu.” ");
INSERT INTO hmo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose ese Ietero dekenai ia kamonai henia, bona iena sisiba hegeregerena ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Israela taudia ibounai dekena amo aonega taudia ia abia hidi, bona taunimanima edia gunalaia taudia ia halaodia, 1000 ta ta, 100 ta ta, 50 ta ta, bona 10 ta ta edia gunalaia taudia. ");
INSERT INTO hmo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Idia ese kota biaguna gaukara idia karaia dina ibounai. Hereva badadia be Mose dekenai idia mailaia, to hereva maragidia be idia sibona idia tahua. ");
INSERT INTO hmo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Vadaeni Mose ese iena ravana ia bamahuta henia, bona Ietero ia giroa lou iena tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Aigupito idia rakatania murinai hua rua idia ore, hua toi ena dina ginigunana dekenai, Israela taudia be taunimanima idia noho lasi gabuna, Sinai tano dekenai idia ginidae. ");
INSERT INTO hmo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Unai gabu Repidima idia rakatania murinai, Sinai tano, dekenai idia raka vareai, bona unuseni Israela taudia idia kamepa, Sinai Ororo ena vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose ese ororo dekenai ia daekau, Dirava danu hedavari totona. Lohiabada ese ororo dekena amo Mose dekenai ia boiboi, ia gwau, “Iakobo ena bese taudia, Israela taudia, dekenai inai bamona do oi hereva, do oi gwau, ");
INSERT INTO hmo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Aigupito taudia dekenai edena bamona lau karaia gaudia umui itaia vadaeni. Umui diba danu edena bamona lau abia mai umui, ugava manu ese iena hanina latanai iena natuna maragi ia abia mai bamona. Vadaeni umui lau hakaua mai inai gabu dekenai, bona lau dekenai umui noho inai. ");
INSERT INTO hmo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Harihari bema lauegu hereva do umui kamonai henia, bona lauegu taravatu do umui badinaia neganai, umui be lauegu bese korikori do umui lao. Tanobada besedia ibounai be lauegu, to bese ibounai edia huanai umui be lauegu abia hidi besena. ");
INSERT INTO hmo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Lauegu helaga taudia do lau halaoa umui, bese helagana do umui lao. Lau sibona dekenai do umui helaga.’ Inai bamona do oi hamaoroa Israela taudia dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Vadaeni Mose ese taunimanima dekenai ia mai, edia gunalaia taudia ia boiridia mai, Lohiabada ese ia oda henia gaudia ibounai idia dekenai ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Vadaeni, taunimanima ibounai idia haere nega tamona, idia gwau, “Ai be Lohiabada ena hereva ibounai do ai karaia.” Vadaeni Mose ese taunimanima edia hereva Lohiabada dekenai ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Lohiabada ese Mose dekenai ia hereva, ia gwau, “Lau be ori badana lalonai do lau mai oi dekenai, vadaeni lau hereva oi dekenai neganai, taunimanima be lauegu gadona do idia kamonaia, vadaeni oi dekenai do idia abidadama henia nega ibounai.” Mose ese taunimanima edia haere hereva Lohiabada dekenai ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Vadaeni Lohiabada ese Mose dekenai ia hereva, ia gwau, “Israela taudia dekenai oi lao, oi hamaorodia hari dina bona kerukeru be edia lalona do idia karaia hegaegae, tomadiho totona. Edia dabua danu do idia huria. ");
INSERT INTO hmo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Bona dina ihatoina neganai danu do idia noho hegaegae. Badina unai dina dekenai lau Lohiabada be Sinai Ororo dekenai do lau diho mai, taunimanima ibounai edia vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ororo do oi hagegea hetoa maka dekena amo, bona taunimanima dekenai oi hamaoroa, oi gwau: Umui naria namonamo, unai maka do umui hanaia lasi, bona ororo dekenai do umui daekau lasi, ma danu ororo ena kahana ta do umui dogoatao lasi. Bema ta ese unai maka ia hanaia, o ororo ia dogoatao neganai, vadaeni do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Umui be nadi dekena amo do umui hodoa mase, o diba dekena amo do umui pidia mase, to alaia totona emui imana dekenai do umui dogoatao lasi. Bema ia be taunimanima o ubua gauna, to do umui hamasea. To kibi ena regena nega daudau do umui kamonai neganai, ororo kahirakahira dekenai do umui mai.” ");
INSERT INTO hmo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Unai dainai Mose be ororo dekena amo ia diho mai taunimanima dekenai, vadaeni ia hamaoroa idia dekenai, edia lalona do idia karaia hegaegae, do idia helaga, tomadiho totona. Edia dabua danu do idia huria. ");
INSERT INTO hmo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ma Mose ia hereva henia idia dekenai, ia gwau, “Do umui noho helaga ia lao bona dina ihatoina, bona sihari kara do umui karaia lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Dina ihatoina, daba neganai, guba ia boiboi, bona kevaru ese ororo ia hadiaria. Unai neganai danu ori badana ta ororo dorina dekenai ia diho. Vadaeni kibi ta ena regena bada herea idia kamonai. Kamepa taudia ibounai idia gari dikadika, mai heudeheude danu. ");
INSERT INTO hmo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose ese taunimanima be edia kamepa dekena amo idia ia hakaua murimuri dekenai, Dirava danu do idia hedavari totona. Idia be ororo henuna kahana dekenai idia gini. ");
INSERT INTO hmo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Unai neganai Sinai Ororo be kwalahu ese ia koua, badina Lohiabada be lahi lalonai ia diho vadaeni ororo ena latanai. Unai dainai unai kwalahu be ia daekau momokani, amu badana ena kwalahu hegeregerena, ororo ena tano ibounai danu ia mareremarere bada. ");
INSERT INTO hmo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kibi ena regena ia bada daekau. Vadaeni Mose be ia hereva, bona Dirava ese guba ena boiboi dekena amo ia haere henia. ");
INSERT INTO hmo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Vadaeni Lohiabada be ia diho, Sinai Ororo ena dorina dekenai. Lohiabada ese Mose dekenai ia boiboi, ororo dorina dekenai do ia daekau mai totona. Vadaeni Mose ia daekau. ");
INSERT INTO hmo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Lohiabada ese Mose ia hamaoroa, ia gwau, “Oi diho, taunimanima dekenai oi hadibaia, hetoa maka do idia hanaia lasi, lau do idia itaia, vadaeni momo do idia mase garina. ");
INSERT INTO hmo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Dubu ena hahelagaia taudia danu, lau kahirakahira idia mai noho taudia, be idia sibona do idia hagoevaia, mai helaga danu, do lau aladia mase garina.” ");
INSERT INTO hmo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose ese Lohiabada dekenai ia haere, ia gwau, “Taunimanima ese Sinai Ororo do idia daekau diba lasi, badina be oi ese oda oi henia ai dekenai, oi gwau, ‘Hetoa maka do umui karaia, ia ese ororo do ia hagegea, ororo do ia helaga totona.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Lohiabada ma ia gwau, “Oi diho lao, vadaeni Arona danu do umui daekau mai. To hahelagaia taudia bona taunimanima be hetoa maka do idia hanaia lasi, lau dekenai do idia mai totona, do lau aladia mase garina.” ");
INSERT INTO hmo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Unai dainai Mose ia diho taunimanima dekenai, unai hereva ia hadibaia idia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Dirava ese inai bamona ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Lau inai Lohiabada, umui emui Dirava, Aigupito taudia edia tano bona edia hesiai gaukara dekena amo umui lau hakaua vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Idau dirava ta do umui abia lasi lauegu vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Laulau ta do umui karaia lasi, guriguri henia totona kaivakuku gauna ta, o gau ta ena laulau, guba gauna ta, o tanobada gauna ta, o ranu lalonai gauna ta. ");
INSERT INTO hmo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Laulau o kaivakuku ta dekenai do umui tomadiho henia lasi, bona iena hesiai gaukara do umui karaia lasi. Badina be lau Lohiabada emui Dirava be lau ura umui be lau sibona egu. Idia ura henia lasi lau dekenai taudia edia kara dika ena davana, be do lau henia edia natuna bona tubuna dekenai, ia lao bona uru toi o hani. ");
INSERT INTO hmo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","To lau dekenai idia lalokau henia taudia bona egu taravatu idia badinaia taudia do lau lalokau henia. Bona edia tubuna taudia momo momo herea danu do lau lalokau henia. ");
INSERT INTO hmo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Lohiabada emui Dirava ena ladana be do umui gwauraia kava, gwauraia kava lasi, badina be egu ladana do ia gwauraia kava tauna ena davana do lau henia. ");
INSERT INTO hmo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Sabati Dina do umui laloatao, bona do umui hahelagaia. ");
INSERT INTO hmo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Dina 6 edia lalonai emui gaukara ibounai do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","To dina namba 7 be laga-ani ena dina, Lohiabada emui Dirava ena. Unai dina dekenai do umui gaukara lasi, umui o emui natudia, o emui hesiai tauna, o emui hesiai hahine, o emui boromakau, o idau tauna emui hanua dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Badina be dina 6 edia lalonai Lohiabada ese guba bona tanobada bona davara bona edia lalonai gaudia ibounai ia karaia, vadaeni dina namba 7 ia laga-ani. Unai dainai Lohiabada ese dina namba 7 ia hanamoa vadaeni, bona ia hahelagaia. ");
INSERT INTO hmo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Oiemu tamana bona sinana dekenai do oi matauraia. Unai dekena amo oiemu mauri nega do ia daudau, Lohiabada oiemu Dirava ese oi dekenai ia henia tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Taunimanima oi alaia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Oi heudahanai lasi. ");
INSERT INTO hmo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Oi henaoa lasi. ");
INSERT INTO hmo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Taunimanima ta dekenai oi samania koikoi lasi. ");
INSERT INTO hmo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Taunimanima ta ena ruma dainai oi mama henia lasi. Iena adavana totona do oi mama henia lasi, o iena hesiai tauna, o iena hesiai hahine, o iena boromakau, o iena doniki, o iena kohu ta totona do oi mama henia lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Taunimanima ese guba ena boiboi bona kibi ena regena idia kamonai, bona kevaru bona ororo ena kwalahu idia itaia neganai, idia gari mai heudeheude danu, bona daudau dekenai idia gini. ");
INSERT INTO hmo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Mose dekenai idia hereva, idia gwau, “Oi ese do oi hereva ai dekenai, vadaeni do ai kamonai henia. To Dirava be do ia hereva lasi ai dekenai, do ai mase garina.” ");
INSERT INTO hmo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Vadaeni Mose ese idia dekenai ia hamaoroa, ia gwau, “Umui gari lasi, badina Dirava ia mai, be umui do ia tohoa totona. Vadaeni, inai gaudia umui itaia dainai, do umui gari henia noho, vadaeni do umui kara dika lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","To taunimanima be daudau dekenai idia gini noho, bona Mose sibona be Dirava ia noho gabuna, ori koremakorema dekenai ia raka kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Lohiabada ese Mose dekenai ia hamaoroa, ia gwau, “Israela taudia dekenai inai bamona oi hamaoroa, oi gwau: Umui diba vadaeni lauegu gadona be guba dekena amo ia mai. ");
INSERT INTO hmo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Siliva dirava o golo dirava do umui karaia lasi, lau danu nega tamona umui tomadiho henidia totona. ");
INSERT INTO hmo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Boubou patana tano dekena amo do umui haginia. Inai pata latanai emui boubou, lahi ese do ia gabua gaudia, maino karaia gaudia, mamoe bona boromakau, lau dekenai do umui henia. Bema lau ese lau abia hidi tomadiho gabudia dekenai umui ese lau umui tomadiho henia neganai, lau ese umui do lau hanamoa. ");
INSERT INTO hmo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Bema boubou patana be nadi dekena amo umui haginia neganai, idia utua nadidia dekena amo do umui haginia lasi, badina be nadi utua auri umui gaukaralaia neganai, nadi be namo lasi lau dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Inai danu, lauegu boubou patana be vadavada dekena amo do umui daekau lasi, emui kopina kavakava be haida ese do idia itaia garina.” ");
INSERT INTO hmo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ma Dirava ese Mose dekenai ia hamaoroa, ia gwau, “Inai bamona taravatu Israela taudia dekenai do oi henia: ");
INSERT INTO hmo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Bema Heberu tauna ta oi hoia, oiemu hesiai gaukara karaia totona neganai, ia be lagani 6 do ia gaukara oi dekenai. Vadaeni lagani namba 7 lalonai hesiai tauna ese iena biaguna dekenai moni do ia henia lasi biaguna do ia rakatania totona, ia be do ia rakatania kava. ");
INSERT INTO hmo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Sibona oi dekenai ia mai gaukara neganai, sibona oi dekena amo do ia rakatania. To mai adavana danu oi dekenai ia mai gaukara neganai, mai ena adavana danu oi dekena amo do idia rakatania. ");
INSERT INTO hmo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","To bema adavana lasi ia mai gaukara, vadaeni biaguna ese hahine ta ia henia, unai hahine be biaguna do ia rakatania diba lasi. Unai tau be iena biaguna ia rakatania neganai, unai hahine mai ena natuna danu be biaguna ese do ia dogoatao. ");
INSERT INTO hmo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Sedira hesiai tauna do ia gwau, ‘Lau be egu biaguna, bona egu adavana, bona egu natuna dekenai lau ura henia, lau ura lasi lau rakatania kava.’ ");
INSERT INTO hmo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Unai neganai unai tau be, iena biaguna ese do ia mailaia Dirava ena vairana dekenai. Iduara dekenai o iduara ena auna dekenai, biaguna ese unai hesiai tauna ena taiana dekenai nila amo matuna do ia karaia. Vadaeni unai tau ese iena biaguna dekenai do ia gaukara noho, ia lao bona ia mase. ");
INSERT INTO hmo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Bema tau ta ese iena natuna kekeni ta ia hoia lao hesiai gaukara davana lasi karaia totona, ia ese iena biaguna do ia rakatania lasi, tau ese ia karaia bamona. ");
INSERT INTO hmo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Bema iena biaguna ese ia hoia badina be do ia adavaia gwauraia, to gabeai ia moale lasi unai kekeni dekenai, vadaeni kekeni ena varavara ese do idia hoia lou. Iena biaguna ia hoia lao diba lasi idau taudia dekenai. Unai be maoro lasi, badina be ia ese iena ura henia inai kekeni dekenai ia makohia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Bema ia ura inai kekeni be iena natuna mero dekenai do ia henia, ia ese kekeni iena ravana korikori do ia halaoa. ");
INSERT INTO hmo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Bema hahine ta ma do ia abia neganai, ia ese iena hahine gunana dekenai ia henia aniani bona dabua do ia hamaragia lasi, bona do idia mahuta hebou noho, guna idia karaia bamona. ");
INSERT INTO hmo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","To bema inai kara ibounai ia karaia lasi iena hahine gunana dekenai, unai hahine ese do ia rakatania diba, bona biaguna dekenai moni do ia henia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Bema tau ta ese tau ta ia botaia, vadaeni ia alaia mase, unai tau danu do idia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","To bema alaia mase totona ia laloa guna lasi, to inai kerere ia vara kava, lau ese gabu ta do lau hadibaia oi dekenai, vadaeni unai tau do ia heau lao unuseni, mauri davaria totona. ");
INSERT INTO hmo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","To bema tau ta ese iena badu ia toreisi guna, vadaeni tau ta ia alaia mase, unai ala-ala tauna do umui alaia mase. Bema unai ala-ala tauna ese egu boubou patana dekenai ia heau lao, mauri davaria totona, umui ese boubou patana dekena amo do umui kokia lao, bona do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Tamana o sinana do ia botaia tauna be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Bema tau ta ese taunimanima ta ia abia mauri dagedage dala dekenai, do ia hoia totona, o iena hesiai gaukara davana lasi do ia karaia totona, unai tauna do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Bema tau ta ese iena tamana o sinana dekenai ia hereva dika henia neganai, unai tau do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Bema taunimanima idia heatu, vadaeni tau ta ese ia dekenai ia heatu tauna ia hodoa nadi dekenai, o imana dekenai ia botaia, to ia mase lasi, ia be davana do umui henia lasi. Bema bero ia abia tauna be iena mahuta geda dekenai ia hekure, ");
INSERT INTO hmo_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","to gabeai ia toreisi, sedira raka auna dekenai ia loaloa, inai ia botaia tauna ese iena gorere davana do ia henia, bona iena hanamoa davana do ia henia, ia lao bona ia namo momokani. ");
INSERT INTO hmo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Bema tau ta ese iena hesiai gaukara davana lasi ia karaia tauna o hahine ia botaia au dekenai, vadaeni nega tamona ia mase, unai biaguna dekenai iena kerere davana do umui henia. ");
INSERT INTO hmo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","To bema unai hesiai tauna o hesiai hahine nega tamona ia mase lasi, to dina ta o rua murinai ia mase, unai biaguna dekenai davana do umui henia lasi. Badina be iena moni dekenai unai hesiai tauna ia hoia. ");
INSERT INTO hmo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Bema tatau idia heatu, vadaeni rogorogo hahine ta idia haberoa, ia mara dika, bona iena natuna ia mase, to hahine ia mase lasi. Vadaeni iena adavana be moni davana hida do ia gwauraia, bona hahine ia botaia tauna ese inai davana do ia henia, kota biaguna ena kota hereva hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","To bema hahine ia mase, vadaeni ia alaia tauna ena mauri do umui utua. ");
INSERT INTO hmo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Mata ena davana be mata, ise ena davana be ise, ima ena davana be ima, ae ena davana be ae. ");
INSERT INTO hmo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Araia ena davana be araia, bero ena davana be bero, bona toto ena davana be toto. ");
INSERT INTO hmo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Bema tau ta ese iena hesiai gaukara davana lasi tauna o hahine ena matana ia haberoa, vadaeni ia hakepulua, unai hesiai tauna ese iena biaguna do ia rakatania kava diba, matana ena davana be unai. ");
INSERT INTO hmo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Bema isena ta ia botaia, vadaeni isena ia moru, unai hesiai tauna ese iena biaguna do ia rakatania kava, isena ena davana be unai. ");
INSERT INTO hmo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Bema boromakau ta ese iena doana dekenai tau ta o hahine ta ia alaia mase, unai boromakau be nadi dekenai do umui hodoa mase, bona iena vamuna be do umui ania lasi. To iena biaguna be ia kerere lasi. ");
INSERT INTO hmo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","To sedira unai boromakau ese nega haida taunimanima ia hadikaia, bona biaguna dekenai guna idia sisiba henia vadaeni. To gabeai ia koua namonamo lasi dainai tau ta o hahine ta ia alaia mase, vadaeni unai boromakau be nadi dekenai do umui hodoa mase, bona biaguna danu do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","To unai biaguna be iena mauri ia davaria diba bema davana bada ta, kota taudia ese idia gwauraia gauna, ia henia neganai. ");
INSERT INTO hmo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Bema mero ta o kekeni ta danu boromakau ese ia alaia neganai, taravatu ena dala be do ia idau lasi. ");
INSERT INTO hmo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Bema hesiai gaukara davana lasi tau ta o hahine ta be boromakau ese ia alaia neganai, boromakau ena biaguna be unai hesiai tauna o hahine ena biaguna dekenai siliva moni 30 do ia henia. Bona boromakau be nadi dekenai do umui hodoa mase. ");
INSERT INTO hmo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Bema tau ta ese guri ta, kehoa gauna ia rakatania, o guri ta ia geia, vadaeni ia koua lasi, gabeai boromakau ta o doniki ta be guri lalonai ia moru, ");
INSERT INTO hmo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ia ese unai boromakau o doniki ena biaguna dekenai davana do ia henia, bona unai boromakau o doniki, mase gauna be iena. ");
INSERT INTO hmo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Bema tau ta ena boromakau ese tau ta ena boromakau ia alaia, unai tatau ruaosi be unai boromakau mauri gauna do idia hoia, bona moni do idia haria. Bona mase gauna ena vamu do idia haria danu. ");
INSERT INTO hmo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","To bema biaguna ia diba vadaeni unai boromakau be dagedage inai bamona, bona ia koua lasi, ia ese davana do ia henia. Boromakau ta, mauri gauna, do ia henia, mase gauna ena gabu dekenai, bona mase gauna be iena.” ");
INSERT INTO hmo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Bema tau ta ese boromakau o mamoe ta ia henaoa, vadaeni ia alaia o ia hoia lao, ia be davana do ia henia neganai, boromakau ta ena davana be boromakau 5 do ia henia. Mamoe ta ena davana be mamoe 4 do ia henia. ");
INSERT INTO hmo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Davana do ia henia momokani. Bema ia be moni lasi, unai tau do umui hoia lao, iena davana be ia henaoa gauna ena davana karaia totona. Bema ia henaoa gauna, boromakau o doniki, o mamoe do ia mauri noho neganai umui davaria neganai, iena davana be ubua gaudia rua do ia henia. “Bema henaoa tauna be ruma ia makohia noho hanuaboi nega lalonai umui davaria, vadaeni umui alaia mase, ia alaia tauna be kerere lasi. To bema daba ia rere murinai inai kara ia vara, ia alaia tauna be do ia kerere. ");
INSERT INTO hmo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Bema tau ta ese iena boromakau ia hakaua vareai idau tauna ena uma gabu o iena uaina huahua hatubua gabuna, vadaeni uma idia hadikaia kava, ia be davana do ia henia. Ia ese sibona ena uma gabu o iena vain huahua hatubua gabuna dekena amo edia anina namodia do ia henia, unai davana karaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Bema lahi ese ava ginigini dekena amo ia hanaia lao uiti idia utua gauna dekenai, o uiti ia tubu vadaeni gauna dekenai, o idia tubu noho uma gabu ma ta dekenai ia araia, vadaeni lahi ia araia hamatamaia tauna ese davana do ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Bema tau ta ese iena moni o iena kohu be iena badibadinai noho tauna dekenai ia henia, ia naria totona, ma tau ta ese do ia henaoa, vadaeni inai henaoa tauna ese davana do ia henia nega rua, bema idia davaria neganai. ");
INSERT INTO hmo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","To bema henaoa tauna idia davaria lasi, unai kohu ia naria tauna be Dirava tomadiho henia gabuna dekenai do umui abia lao. Bona ia ese Dirava ena vairana dekenai do ia gwauhamata, do ia gwau, ‘Lau hereva momokani, lau ese unai gau lau henaoa lasi.’ ");
INSERT INTO hmo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Bema boromakau o doniki o mamoe o dabua o ia boio gauna ta totona umui hepapahuahu, sedira tau ta do ia gwau, ‘Inai be lauegu.’ Unai neganai kahana rua taudia be tomadiho gabuna lalonai Dirava ena vairanai do idia kota. Dirava ese ia gwauraia kerere tauna be davana nega rua do ia henia kahana tauna dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Bema tau ta ese iena doniki, boromakau, mamoe, o ubua gaudia ta, ma tau ta dekenai ia henia, ia naria totona, sedira unai ubua gaudia ta do ia mase, o bero do ia davaria, o henaoa taudia ese idia abia lao kava. Bema unai kara be tau ta ia itaia lasi, ");
INSERT INTO hmo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","vadaeni naria tauna ese gwauhamata do ia gwauraia Dirava ena vairanai, ia ese unai ubua gauna ia abia kava lasi. Unai neganai naria tauna be davana do ia henia lasi, bona biaguna be do ia gwau, ‘Ia namo.’ ");
INSERT INTO hmo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","To bema unai ubua gauna be ma tau ta ese naria tauna dekena amo ia henaoa momokani, unai naria tauna ese davana do ia henia. ");
INSERT INTO hmo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Bema dagedage gaudia ese unai ubua gauna idia alaia neganai, naria tauna ese iena tauanina do ia hedinaraia, vadaeni davana do ia henia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Bema tau ta ese ma tau ta ena ubua gauna ta ia abiatorehai, sedira iena biaguna ia noho lasi neganai do ia mase, o bero ta do ia davaria. Unai neganai abiatorehai tauna ese unai ubua gauna ena davana do ia henia biaguna dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","To bema biaguna be ubua gauna danu ia noho, abiatorehai tauna be davana do ia henia lasi. Bema tau ta ese ubua gauna gaukaralaia totona davana kahana ia henia vadaeni, bona pura ta ta moni sisina ia henia noho, vadaeni unai ubua gauna ia mase neganai, unai tau ese iena davana do ia henia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Bema tau ta ese do ia sihari lasi bona maoheni lasi kekeni ta ia veria, vadaeni idia mahuta gabu tamona dekenai, ia be unai kekeni do ia adavaia bona iena davana do ia henia. ");
INSERT INTO hmo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","To bema kekeni ena tamana ia ura lasi unai tau be iena kekeni do ia adavaia, unai tau ese davana bada do ia henia, badina be unai kekeni, be guna tau ta danu ia sihari lasi dainai. ");
INSERT INTO hmo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Meamea hahine be do ia mauri lasi, do umui hamasea. ");
INSERT INTO hmo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Taunimanima lasi, to ubua gauna ta ia sihari henia tau o hahine be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Daika tauna ese boubou gauna ta ia karaia, Lohiabada totona lasi, to ma dirava ta dekenai, be do umui kota henia, ia mase totona. ");
INSERT INTO hmo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Idau tauna ta, umui huanai ia noho tauna, do umui hadikaia o hisihisi henia lasi. Badina be guna, Aigupito dekenai umui noho neganai, umui be idau taudia. ");
INSERT INTO hmo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Vabu, o tamana sinana lasi maragina ta dekenai hisihisi do umui henia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Bema hisihisi umui henidia, vadaeni lau dekenai idia tai, be momokani edia tai do lau kamonai. ");
INSERT INTO hmo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Vadaeni lauegu badu be do ia siahu umui dekenai, bona tuari lalonai do lau alaia mase umui. Emui adavana be do idia vabu. Emui natuna danu tamana lasi do idia noho. ");
INSERT INTO hmo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Bema lauegu bese tauna ogogamina ta, emui huanai ia noho tauna, dekenai umui heniatorehai neganai, henia lou neganai, davana hegeregerena sibona umui dekenai do ia henia. Atoa kau moni do umui tahua lasi. ");
INSERT INTO hmo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Sedira tau ta ia abiatorehai oi dekenai, bona ia henia lou lasi garina, iena dabua oi abia lao. Dina do ia diho lasi neganai, iena dabua do umui henia lou. ");
INSERT INTO hmo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Badina unai dabua sibona dekenai siahu do ia abia, hanuaboi mahuta neganai. Edena bamona do ia mahuta? Lau dekenai do ia tai neganai do lau kamonai, badina lau be bogahisihisi bada Diravana. ");
INSERT INTO hmo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Dirava dekenai do umui hereva dika lasi, bona emui bese ena lohia tauna ta dekenai do umui hereva dika lasi. ");
INSERT INTO hmo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Emui uma dekenai hadoa gaudia edia anina dekena amo boubou gauna lau dekenai do umui henia, dogoatao noho lasi. “Umui emui vara guna natuna merona lau dekenai do umui henia. ");
INSERT INTO hmo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Emui boromakau bona emui mamoe danu edia vara guna tau gaudia danu lau dekenai do umui henia. Dina 7 inai natuna vara guna tau gauna be iena sinana danu do ia noho. Dina namba 8 dekenai, be lau dekenai do umui henia boubou gauna totona. ");
INSERT INTO hmo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Umui be lau dekenai umui helaga. Unai dainai uda dekenai noho dagedage gaudia ese idia alaia gauna be do umui ania lasi, sisia dekenai do umui henia. ");
INSERT INTO hmo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Sivarai momokani lasi do umui gwauraia lasi. Hereva koikoi dekena amo kara dika tauna do oi durua lasi. ");
INSERT INTO hmo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Bema taunimanima momo idia kerere, edia laloa do umui abia dae lasi. Kota lalonai taunimanima momo hamoalea totona hereva koikoi do umui gwauraia lasi. Badina be unai dekena amo kara maoromaoro do umui hadikaia garina. ");
INSERT INTO hmo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kota lalonai tau ta ia ogogami dainai, iena kerere davana do umui hamaragia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Bema oi dekenai ia badu tauna ena boromakau o doniki ia boio, vadaeni oi davaria neganai, ia dekenai do oi hakaua lou. ");
INSERT INTO hmo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Bema oi dekenai ia badu tauna ena doniki be ia moru diho kohu metau ia huaia dainai, do oi durua. Oi rakatania kava be ia dika. ");
INSERT INTO hmo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Bema umui emui ogogami tauna ta ia kota neganai, dala maoromaoro dekenai do umui kota henia. Ia be ogogami dainai iena kota do umui ha-aukaia kava lasi, to iena mauri do umui laloa, taunimanima ibounai edia mauri umui laloa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Tau ta do umui samania koikoi lasi. Kerere lasi tauna ta do umui hamasea lasi. Badina be inai bamona ia karaia tauna be iena kerere davana do lau henia. ");
INSERT INTO hmo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Kara kerere do umui karaia totona umui dekenai moni idia henia gwauraia neganai, do umui abia dae lasi. Badina be inai bamona moni ese taunimanima edia matana ia kepulua, vadaeni kara maoromaoro do idia laloa lasi. Bona inai dekena amo, kara maoromaoro idia karaia taudia do umui hadikaia. ");
INSERT INTO hmo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Bema idau tauna umui emui huana dekenai ia noho, do umui hisihisi henia lasi. Umui be idau tauna ena mamina umui abia, badina be guna Aigupito dekenai umui noho, idau taudia bamona. ");
INSERT INTO hmo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Lagani 6 uma gaudia do umui hadoa emui tano lalonai, bona anina do umui haboua. ");
INSERT INTO hmo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","To lagani namba 7 lalonai, be tano do umui gaukaralaia lasi, ia noho kava, bona ia dekenai ia tubu anina do umui haboua lasi. Umui dekenai idia noho ogogami taudia ese unai anina do idia ania, bona orena be dagedage gaudia do idia ania diba. Inai bamona kara danu do umui karaia emui vain uma gabudia dekenai bona emui olive hatubua gabudia dekenai danu. ");
INSERT INTO hmo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Dina 6 do umui gaukara, to dina namba 7 ena lalonai do umui gaukara lasi. Inai dekena amo emui boromakau bona emui doniki danu do idia laga-ani, bona emui hesiai taudia davana lasi, bona emui huana dekenai noho idau tauna be idia laga-ani dainai, edia goada do idia abia lou. ");
INSERT INTO hmo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Lau Lohiabada egu hereva ibounai umui kamonai namonamo. Idau dirava ta dekenai umui guriguri henia lasi. Edia ladana danu do umui gwauraia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Lagani ta lalonai, nega toi aria do umui karaia, lau totona. ");
INSERT INTO hmo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Hatubua Lasi Paraoa ena aria do umui karaia, bona dina 7 lalonai do umui ania, gunaguna umui dekenai lau oda hegeregerena. Inai aria do umui karaia ena nega korikori dekenai, hua ladana Abiba lalonai. Badina be unai hua lalonai Aigupito tano umui rakatania. Lauegu vairana dekenai tau ta be imana kavakava do ia mai lasi. ");
INSERT INTO hmo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Uma ena anina, hegeregere koni haboua negana, ena aria danu do umui karaia, umui haboua hamatamaia neganai. Lagani dokona dekenai danu aria ta do umui karaia, au huahua ena anina umui haboua neganai. Inai huahua be do umui haboua vain uma gabudia, bona olive hatubua gabudia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Lagani ta ena lalonai, emui tatau ibounai be lauegu vairana dekenai do idia hedinarai nega toi. Lau be Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Boubou gauna hegeregere boromakau ta lau dekenai umui henia neganai, mai hatubua gauna paraoa ia danu nega tamona do umui atoa lasi. Boromakau ena digarana be do ia noho lasi ia lao bona dabai. ");
INSERT INTO hmo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Emui uma dekenai hadoa gaudia edia anina ginigunana umui utua neganai, be namo hereadia do umui mailaia Lohiabada emui Dirava ena dubu dekenai. “Nani ena natuna be iena sinana ena rata lalonai do umui nadua lasi. ");
INSERT INTO hmo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Umui itaia, aneru ta emui vairana dekenai lau siaia noho. Ia ese dala dekenai do ia naria namonamo umui, ia lao bona lau abia hegaegae gabuna dekenai umui do ia hakaua vareai. ");
INSERT INTO hmo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ia dekenai do umui kamonai namonamo, iena gadona do umui kamonai henia, bona iena hereva do umui utua lasi. Badina be ia ese emui kara dika do ia gwauatao lasi, ia ese lauegu siahu ia abia dainai. ");
INSERT INTO hmo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","To bema iena gadona umui kamonai henia, bona lauegu hereva ibounai do umui karaia, vadaeni umui dekenai idia dagedage henia taudia be lau ese do lau dagedage henia, bona umui dekenai tuari henia taudia, be lau ese danu do lau tuari henidia. ");
INSERT INTO hmo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“Lauegu aneru be emui vairana dekenai do ia lao, Amoro taudia bona Hiti taudia bona Kanana taudia bona Hivi taudia bona Iebusu taudia edia tano dekenai umui do ia hakaua. Vadaeni inai taunimanima do lau hadikadia ore. ");
INSERT INTO hmo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Unai neganai idia edia dirava dekenai do umui tomadiho lasi, bona edia hesiai gaukara do umui karaia lasi, bona edia kara do umui karaia lasi, to idia do umui halusia momokani, bona edia kaivakuku ibounai do umui makohia ore. ");
INSERT INTO hmo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Lau Lohiabada, emui Dirava, do umui tomadiho henia, vadaeni aniani bona ranu hegeregere do lau henia umui dekenai, bona emui gorere ibounai do lau abia siri. ");
INSERT INTO hmo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Emui tano dekenai hahine ta do ia mara dika lasi, bona hahine ibounai ese natuna do idia abia. Emui mauri dinadia be do idia momo. ");
INSERT INTO hmo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Umui dekenai idia dagedage henia taudia be do lau hagaridia, bona umui dekenai idia tuari henia taudia dekenai daradara do lau havaraia, vadaeni idia ibounai umui dekena amo do idia heau. ");
INSERT INTO hmo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Umui emui vairana dekenai nanigo do lau siaia, idia ese Hivi taudia bona Kanana taudia bona Hiti taudia do idia lulua emui vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Lagani tamona lalonai do lau luludia lao lasi, badina be lau ura lasi tano ena dagedage gaudia do idia momo herea, vadaeni emui noho do idia hadikaia. ");
INSERT INTO hmo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Metairametaira do lau luludia, ia lao bona natuna momo ma do umui abia, vadaeni umui be momo herea. Unai neganai tano ibounai be do umui abia. ");
INSERT INTO hmo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Emui tano ena hetoa gabudia do lau karaia, idia be Davara Kakakaka dekena amo ia lao bona Pilistia taudia edia davara, bona taunimanima idia noho lasi gabuna dekena amo ia lao bona Euperate Sinavai. Inai gabu dekenai idia noho taunimanima danu do umui tuari, bona do umui kwalimu, umui ese idia do umui lulua murimuri gabudia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Idia danu do umui laloa tamona lasi, bona edia dirava danu do umui laloa tamona lasi. ");
INSERT INTO hmo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","“Idia be emui tano dekenai do idia noho lasi, idia ese umui do idia hakaua kerere, vadaeni do umui kara dika lauegu vairana dekenai garina. Bema umui ese edia dirava dekenai umui tomadiho, umui be dika momokani do umui davaria.” ");
INSERT INTO hmo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Lohiabada ese Mose dekenai ia hereva, ia gwau, “Ororo dekenai oi daekau mai lau dekenai, oi bona Arona, Nadaba, bona Abihu, bona Israela tau badadia 70, sisina daudau lau dekena amo do umui tomadiho. ");
INSERT INTO hmo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mose sibona be lau kahirakahira do ia mai, haida be lau kahirakahira dekenai do idia mai lasi, bona taunimanima ta ese Mose danu do idia daekau lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Vadaeni Mose ese Lohiabada ena hereva bona iena taravatu ibounai ia hadibaia taunimanima dekenai. Israela ena taunimanima ibounai be nega tamona idia haere, idia gwau, “Ai be Lohiabada ena hereva ibounai do ai karaia.” ");
INSERT INTO hmo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mose ese Lohiabada ena hereva ibounai ia torea. Daba maragi ia toreisi, ororo ena henuna kahana dekenai boubou patana ia karaia, bona laloatao nadi 12 ia haginia, Israela ena iduhu 12 edia. ");
INSERT INTO hmo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Vadaeni Mose ese Israela tatau matamata haida ia siaidia, idia ese boromakau tau idia mailaia, boubou gaudia dekenai idia halaoa, boubou be rua, ta be lahi ese ia gabua ore momokani ena boubou, ta be maino karaia boubou Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Vadaeni Mose ese rara kahana ia bubua disi lalonai, to rara kahana ia negea lao boubou patana ena latanai. ");
INSERT INTO hmo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Unai murinai gwauhamata taravatuna ena buka ia abia, Lohiabada ena oda hereva unai, bona Israela taudia edia vairana dekenai ia duahia hedinarai. Vadaeni idia gwau, “Lohiabada ena oda hereva ibounai do ai karaia, bona do ai kamonai henia.” ");
INSERT INTO hmo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Gabeai Mose ese rara, disi lalonai gauna ia abia, Israela taudia edia latanai ia negea lao, ia gwau, “Inai rara ese Lohiabada ena gwauhamata taravatuna, umui danu ia karaia gauna ia hamomokania, inai buka ena hereva ibounai hegeregerena.” ");
INSERT INTO hmo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Vadaeni Mose, Arona, Nadaba bona Abihu bona Israela tau badadia 70 danu, ororo dekenai idia daekau. ");
INSERT INTO hmo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Israela ena Dirava idia itaia. Iena aena henunai be nadi namo herea, mai edia diaridiari idia noho, edia toana be bulu, guba bamona, ori ese idia koua lasi neganai. ");
INSERT INTO hmo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Inai Israela tau badadia ese Dirava idia itaia, to ia ese ia hadikadia ore lasi. Vadaeni Lohiabada ena vairana dekenai idia aniani hebou. ");
INSERT INTO hmo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Lohiabada ese Mose dekenai ia hereva, ia gwau, “Lau dekenai oi daekau mai ororo dekenai, lau dekenai oi naria. Lau be nadi palaka rua oi dekenai do lau henia. Inai nadi edia latanai taravatu bona oda lau torea vadaeni, taunimanima dekenai do oi hadibaia totona.” ");
INSERT INTO hmo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Vadaeni Mose mai ena hesiai tauna Iosua danu idia toreisi, idia daekau Dirava ena ororo dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mose ese Israela tau badadia dekenai ia hamaoroa, ia gwau, “Iniseni do umui naria noho, ela bona ai giroa mai umui dekenai. Arona bona Huru be umui dekenai idia noho, bema kerere o hepapahuahu ia vara neganai, idia ese kota do idia karaia.” ");
INSERT INTO hmo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mose ese ororo dekenai ia daekau, vadaeni ori ta ese ia koua. ");
INSERT INTO hmo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Lohiabada ena hairaina be Sinai Ororo ena latanai ia diho, bona ori ese ororo ia koua ela bona dina 6 ia ore. Dina namba 7 neganai Lohiabada ese Mose dekenai ia boiboi ori dekena amo. ");
INSERT INTO hmo_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Lohiabada ena hairaina be Israela taudia ibounai ese idia itaia, be lahi bada herea bamona, ororo ena ataiai dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mose ese ororo dekenai ia daekau, ori lalonai, bona dina 40 bona hanuaboi 40 edia lalonai unuseni ia noho. ");
INSERT INTO hmo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Israela taudia do oi hamaoroa, idia ese edia harihari gaudia lau dekenai do idia henia. Mai edia laloa namo lau dekenai taudia ese edia harihari gaudia do oi abia mai, lauegu. ");
INSERT INTO hmo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Idia dekena amo do oi abia gaudia be inai: Golo bona siliva bona auri laboralabora, ");
INSERT INTO hmo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","dabua namo herea, bulu bona kakakaka sisina, bona mamoe huina dabua, kakakaka momokani gauna, bona nani ena huina, ");
INSERT INTO hmo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","mamoe edia kopina, idia hakakakaka gaudia, bona nani edia kopina, bona akasia audia, ");
INSERT INTO hmo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lamepa ena oela, mai bonana namona muramura, dehoro helaga totona, bona idia gabua muramura ena pauda danu. ");
INSERT INTO hmo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Onuku nadi, bona Hahelagaia Tauna Badana ena dabua herahera totona davana bada nadidia danu do umui abia mai, iena kemena dabua dekenai atoa nadi namodia danu. ");
INSERT INTO hmo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Israela taudia danu do oi hamaoroa, lauegu Palai Dubu Helagana do idia karaia, idia edia huana dekenai do lau noho totona. ");
INSERT INTO hmo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Inai Palai Dubu, bona ena lalonai noho gaudia, be lau ese do lau hadibaia bamona do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Maua ta danu do umui karaia, akasia au dekena amo. Iena lata be 110 sentamita, iena lababa be 66 sentamita, bona iena ataiai be 66 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Maua ena lalona bona ena murimuri kahana ibounai be golo namo herea dekena amo do umui koua, bona maua ena hetoana be golo dekena amo do umui hagegea, herahera ena toana bamona. ");
INSERT INTO hmo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","“Rini ibounai 4 be golo dekena amo do umui karaia, maua do umui huaia totona. Inai rini 4 be maua ena aena maragidia 4 dekenai do umui kwatua auka. Rini rua be maua kahana do umui kwatua, ma rini rua be maua kahana do umui kwatua. ");
INSERT INTO hmo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Maua huaia audia rua danu akasia au dekena amo do umui karaia, bona au ruaosi be golo dekenai do umui koua. ");
INSERT INTO hmo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Inai au ruaosi be nega ibounai rini lalonai do idia noho. ");
INSERT INTO hmo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Rini dekena amo au do umui kokia lasi, lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“Gabeai lau ese Nadi Palaka rua umui dekenai do lau henia, inai nadi edia latanai Taravatu do lau torea. Umui ese inai Nadi Palaka ruaosi be Maua ena lalonai do umui udaia. ");
INSERT INTO hmo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Maua ena koua gauna danu be golo namo herea momokani dekena amo do umui karaia. Iena lata be 110 sentamita, bona iena lababa be 66 sentamita. Inai koua gauna be taunimanima edia kara dika gwauatao gabuna. ");
INSERT INTO hmo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ma golo, hama dekenai umui botaia gauna dekena amo kerubi aneru rua danu do umui karaia. Inai kerubi rua be Maua ena koua gauna ena duduna duduna dekenai do umui koroa kau. ");
INSERT INTO hmo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Koua gauna ena duduna ta dekenai be kerubi aneru ta do umui atoa, ma duduna ta dekenai kerubi aneru ma ta do umui atoa. Koua gauna bona kerubi ruaosi be golo tamona dekena amo do umui karaia, do idia gau tamona, parara lasi. ");
INSERT INTO hmo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","“Inai kerubi aneru ruaosi, kara dika gwauatao gabuna duduna duduna dekenai idia noho, ese idia hanina dekena amo koua gauna idia hunia bamona, bona inai kerubi ruaosi ese ta ta dekenai edia vairana idia itaia noho. ");
INSERT INTO hmo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Unai Nadi Palaka rua be Maua lalonai do umui udaia, bona koua gauna be Maua ena latanai do umui atoa, umui koua. ");
INSERT INTO hmo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Unuseni, Maua ena koua gauna, kara dika gwauatao gabuna ena ataiai, kerubi aneru edia huanai, lau ese unai gabu dekenai oi danu do ita hedavari, bona oi dekenai lauegu Taravatu do lau hadibaia. Bona oi ese inai Taravatu ibounai Israela taudia dekenai do oi henia. ");
INSERT INTO hmo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Pata ta danu do umui karaia, akasia au dekena amo do umui karaia. Iena lata be 88 sentamita, bona iena lababa be 44 sentamita, iena ataiai be 66 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Golo namo momokani dekena amo do umui koua, bona pata ena hetoana be golo dekena amo do umui hagegea, herahera bamona. ");
INSERT INTO hmo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","“Pata ena isena do umui habadaia 8 sentamita dekenai, bona inai isena be golo dekena amo do umui koua. ");
INSERT INTO hmo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Pata do umui huaia totona rini ibounai 4 do umui karaia, bona pata ena kona 4, aena gabudia dekenai rini do umui kwatua auka. ");
INSERT INTO hmo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Inai rini be pata ena isena kahirakahira do umui kwatua auka, bona inai rini edia lalonai be pata huaia audia do idia toia vareai. ");
INSERT INTO hmo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Inai pata huaia audia be akasia au dekena amo do umui karaia, bona golo dekena amo do umui koudia. ");
INSERT INTO hmo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","“Pata dekenai atoa gaudia danu, mereki, kapusi, disi, bona uro, uaina boubou totona gaudia, be golo namo momokani dekena amo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Pata be Taravatu Maua ena vairana dekenai do umui atoa. Bona nega ibounai pata ena latanai, paraoa helagana do umui atoa hegaegae, lauegu vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Lamepa dogoatao gauna ta danu golo namo herea dekena amo do umui karaia. Iena badina bona iena du be golo, hama dekenai idia botaia gauna, dekena amo do umui karaia. Iena lamepa udaia kapusi, mai edia herahera toana gaudia, ibounai be golo tamona dekena amo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Iena rigi be ibounai 6, kahana toi, kahana toi. ");
INSERT INTO hmo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Inai rigi ta ta ibounai be mai edia herahera toi, edia toana be alamono au huahua bamona. ");
INSERT INTO hmo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Lamepa ena du danu be mai ena herahera, herahera 4, edia toana be alamono au huahua bamona danu. ");
INSERT INTO hmo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Rigi rua rua dekenai danu be rau maragidia ta ta do umui koroa, rigi rua, rau ta, rigi rua, rau ta, bona rigi rua, rau ta, rigi edia henuna kahadia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Inai rigi ibounai bona herahera raudia ibounai be lamepa dogoatao gauna danu golo tamona dekena amo do umui koroa karaia. ");
INSERT INTO hmo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Bona lamepa ibounai 7 do umui karaia, du bona rigi edia duduna ta ta dekenai do umui udaia. Edia diari be vairana kahanai do umui poinia, Dubu ena lalona do idia hadiaria. ");
INSERT INTO hmo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Lamepa hagoevaia gaudia bona momoru udaia mereki ibounai danu be golo namo herea dekena amo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Inai lamepa dogoatao gauna, mai ena kohu ibounai totona umui gaukaralaia golo ena metau be ibounai 35 kilogaram. ");
INSERT INTO hmo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Do umui itaia namonamo, inai gau ibounai be lauegu palani hegeregerena momokani do umui karaia. Inai egu palani be ororo dekenai lau hedinaraia vadaeni oi dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Lohiabada ese ma Mose ia hamaoroa ia gwau, “Palai Dubu ta do umui karaia lau totona. Dabua auka, bona namo herea ibounai 10 dekena amo do umui karaia, edia kala be bulu, bona kakakaka, bona kakakaka sisina. Herahera dalana diba tauna ta ese inai dabua ibounai edia latanai kerubi aneru edia laulau do ia turia namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Inai dabua 10 ibounai edia bada be hegeregere. Edia lata be 12 mita, bona edia lababa be mita rua. ");
INSERT INTO hmo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","“Dabua ibounai 5 do umui turia hebou, vadaeni dabua tamona, latana, do ia lao. Ma dabua 5 do umui turia hebou, vadaeni dabua tamona, latana, gunana hegeregerena, ma do ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Dabua, iena kala bulu dekena amo be rini momo do umui karaia, inai dabua latadia rua do umui haboua tamona totona. Rini ibounai be inai dabua latadia edia isena dekenai do umui kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Inai rini 50 be dabua ginigunana ena isena dekenai do umui kwatua, ma inai bamona danu rini 50 be dabua iharuana ena isena dekenai do umui kwatua. ");
INSERT INTO hmo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ma umui ese kimai 50 be golo dekena amo do umui karaia. Unai kimai 50 be inai dabua badadia ruaosi edia rini do idia vareai. Unai dekena amo unai dabua badadia ruaosi be do umui hakapua tamona, vadaeni dubu tamona do ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Inai murinai dabua badana ta do umui karaia, lauegu Palai Dubu do umui koua totona. Inai dabua badana be nanigosi huina dekena amo karaia dabua ibounai 11 dekena amo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Inai dabua 11 edia bada be tamona, edia lata be 13 mita, bona edia lababa be mita rua. ");
INSERT INTO hmo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Inai dabua 5 do umui turia hebou, dabua latana ta do ia lao. Ma dabua 6 danu be do umui turia hebou, dabua latana ta do ia lao. Dabua namba 6 be do umui lokua, ia ese Palai Dubu ena vairana do ia koua totona. ");
INSERT INTO hmo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Inai dabua latana ginigunana ena isena dekenai dabua rini ibounai 50 do umui kwatua, bona dabua latana iharuana ena isena dekenai danu unai bamona rini 50 do umui kwatua. ");
INSERT INTO hmo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kimai ibounai 50, be auri laboralabora dekena amo do umui karaia, bona unai dabua latadia ruaosi be kimai 50 dekena amo do umui hakapua, vadaeni dabua tamona do ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Vadaeni inai dabua latana ena noho kava dabua mita tamona be lauegu Palai Dubu ena murina kahana dekenai do ia taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Inai Palai Dubu koua dabua ena lata ese Palai Dubu ena lata do ia hanaia 50 sentamita dekenai kahana bona kahana dekenai. Unai dainai koua dabua ese Palai Dubu do ia koua momokani. ");
INSERT INTO hmo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Bona umui ese Palai Dubu ena guhi rua do umui karaia, ta be mamoe tau ena kopina, ena kala kakakaka, bona ta be davara ena boromakau, rui, ena kopina dekena amo. Inai be ataiai momokani ena guhi. ");
INSERT INTO hmo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Palai Dubu ena haba turia ta ta be akasia audia stadi rua dekena amo do umui karaia, mai edia padana audia, vadavada ena toana bamona. ");
INSERT INTO hmo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Inai akasia audia stadi edia lata be 4 mita, bona haba turia edia padadia dekenai idia noho audia edia lata be 66 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Inai akasia au stadi ta ta ibounai be do idia lata sisina, vadaeni idia ta ta be siliva maua ta ta lalonai do idia gini, haba turia hagoadaia totona. Inai akasia au stadi ibounai do umui utua neganai, ibounai edia lata be tamona. ");
INSERT INTO hmo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","“Inai haba turia, vadavada bamona gaudia, ibounai 20 be Palai Dubu ena diho kahana habana dekenai do umui haginia. ");
INSERT INTO hmo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Siliva dekena amo maua 40, mai edia matudia do umui karaia. Inai matudia ta ta lalonai stadi ta ta do idia gini. Inai maua rua be haba turia ta ta henunai do idia noho, stadi hagoadaia, bona stadi do idia marere lasi totona. ");
INSERT INTO hmo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","“Palai Dubu ena mirigini kahana habana dekenai danu be haba turia ibounai 20 do umui haginia. ");
INSERT INTO hmo_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Inai haba turia ta ta ibounai edia henunai be siliva maua rua do umui atoa. ");
INSERT INTO hmo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","“Palai Dubu ena dina diho kahana habana dekenai haba turia ibounai 6 do umui haginia. ");
INSERT INTO hmo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Bona iena kona ruaosi dekenai haba turia rua do umui haginia. ");
INSERT INTO hmo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Inai kona haba turia ruaosi be henuna kahanai do umui kwatua auka. Bona atai kahanai be rini dekena amo do umui kwatua hebou auka. Kona ruaosi be unai bamona do umui haginia. ");
INSERT INTO hmo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Unai dainai Palai Dubu ena murina kahanai habana ena haba turia ibounai be 8, bona siliva maua ibounai be 16, maua rua be haba turia ta ta edia henunai do idia noho. ");
INSERT INTO hmo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Reirei latadia danu be akasia audia dekena amo do umui karaia, ibounai 5 be Palai Dubu ena mirigini kahana habana dekenai, ");
INSERT INTO hmo_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ma ibounai 5 be Palai Dubu ena diho kahana habana dekenai, bona ibounai 5 be Palai Dubu ena dina diho kahana habana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","“Inai reirei latadia, haba ena huanai ia kwatua gaudia, be do idia lata, edia lata be haba ena lata hegeregere momokani. ");
INSERT INTO hmo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Haba turia ibounai be golo dekenai do umui koua, bona golo rini do umui kwatua, inai reirei latadia do idia dogoatao totona. Unai reirei latadia danu be golo dekena amo do umui koua. ");
INSERT INTO hmo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Palai Dubu be do umui haginia namonamo, iena toana be lau ese ororo dekenai oi dekenai lau hedinaraia laulau ena toana hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Koua dabua helagana ta danu do umui karaia Palai Dubu ena lalonai do ia noho totona. Inai dabua be mamoe huina dekenai do umui karaia, iena kala be bulu, kakakaka, bona kakakaka sisina. Bona kerubi aneru edia laulau be dabua latanai do umui turia namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Koua dabua helagana be du 4 dekenai do umui taua dae. Du ibounai 4 be akasia audia dekena amo do umui karaia. Inai du be golo dekena amo do umui koua. Bona unai du be siliva maua 4 edia matudia lalonai do umui haginia. Kimai haida golo dekenai do umui karaia, bona du edia latanai kimai do umui kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","“Vadaeni koua dabua helagana be golo kimai dekenai do umui taua dae. Taravatu Maua be koua dabua helagana ena murinai do umui atoa, Helaga Herea Gabuna lalonai. Inai koua dabua helagana ese Helaga Gabuna, bona Helaga Herea Gabuna do ia hapararaia. ");
INSERT INTO hmo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“Taravatu Maua ena latanai, iena koua gauna, kara dika ena gwauatao gabuna, do umui atoa, Helaga Herea Gabuna ena lalona dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“To pata be Helaga Gabuna lalonai do umui atoa, Palai Dubu ena mirigini kahana dekenai. Lamepa dogoatao gauna be Palai Dubu ena diho kahana dekenai do umui atoa. ");
INSERT INTO hmo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Palai Dubu ena iduara dekenai koua dabua do umui karaia. Koua dabua ena latanai toana namona herahera do umui turia namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Koua dabua dogoatao totona, be akasia audia du ibounai 5 do umui haginia, mai edia golo kimai. Inai du be golo dekena amo do umui koua. Inai du be edia lalonai do idia gini totona, maua 5 do umui karaia, auri laboralabora dekena amo.” ");
INSERT INTO hmo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Lohiabada ese Mose dekenai ma ia hereva, ia gwau, “Umui ese akasia audia dekena amo boubou patana ta, boubou gabua totona gauna, do umui karaia. Iena lata be mita rua, 20 sentamita, ma iena lababa danu be mita rua, 20 sentamita, bona iena ataiai be mita ta, 30 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Boubou patana ena latanai doa 4 do umui koroa, iena kona 4 dekenai. Inai doa be pata danu au tamona dekena amo do umui karaia. Boubou patana ena kopina ibounai be auri laboralabora dekena amo do umui koua momokani. ");
INSERT INTO hmo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Lahi kahu udaia uro bona sipeidi maragidia bona disi bona foka bona lahi huaia kapusi be auri laboralabora dekena amo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","“Auri laboralabora dekena amo lahi au rakuraku gabua patana ta, mai ena matuna momo, reke bamona gauna, do umui karaia. Inai reke bamona patana ena kona 4 dekenai auri laboralabora rini 4 do umui kwatua auka. ");
INSERT INTO hmo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","“Inai reke bamona patana be henuna kahanai, boubou patana ena aena 4 dekenai do umui kwatua auka, aena edia huana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Akasia audia dekena amo boubou patana huaia audia do umui karaia, bona auri laboralabora dekena amo do umui koua. ");
INSERT INTO hmo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Bona inai audia be rini, pata ena kahana kahana dekenai idia kwatua noho gaudia, edia lalonai do umui toia vareai, pata be do umui huaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","“Inai boubou patana be maua bamona do umui karaia, reirei palakadia dekena amo do umui koua, to iena lalona kahanai au o reirei be lasi. Gau ibounai be do umui karaia, ororo dekenai laulau oi dekenai lau hedinaraia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Palai dubu koua hagegea totona, koua dabua badana do umui karaia, dabua namodia dekena amo. Diho kahana dekenai koua dabua ena lata be 44 mita. ");
INSERT INTO hmo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Auri laboralabora du ibounai 20 ese inai diho kahana koua dabua do idia dogoatao. Inai du be auri laboralabora maua 20 edia lalonai do idia gini. Du edia latanai siliva dekenai umui karaia ba be do umui kwatua kau, bona inai siliva ba dekenai koua dabua taua dae totona siliva kimai momo do umui kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","“Mirigini kahana koua dabua danu be diho kahana koua dabua hegeregerena do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Dina ia diho kahana ena koua dabua, ena lata 22 mita do umui karaia. Du ibounai 10, mai edia auri laboralabora maua 10 danu do umui karaia. Inai maua be mai edia matudia, du idia gini gabudia. ");
INSERT INTO hmo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Palai Dubu ena dina daekau kahanai danu ena koua dabua ena lata be 22 mita. Inai kahana koua dabua lalonai be raka vareai iduara ia noho. ");
INSERT INTO hmo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","“Iduara ena kahana ta dekenai du toi, mai lalonai idia gini maua, do umui atoa, bona inai du dekenai koua dabua, iena lata 6 mita, 60 sentamita do umui taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ma iduara ena kahana dekenai du ma toi mai edia maua do umui atoa, bona idia dekenai koua dabua, iena lata 6 mita 60 sentamita do umui taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Ma iduara danu be sibona mai ena koua dabua, dabua namo herea, ena lata be 9 mita. Iena dabua be mamoe huina, namo herea gauna, ena kala be bulu, kakakaka sisina, bona kakakaka. Herahera danu be inai koua dabua ena latanai do umui turia namonamo. Inai koua dabua be du 4, mai edia maua 4, edia latanai do umui taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","“Palai Dubu ia koua hagegea koua dabua maguna ena du ibounai be mai edia siliva ba, siliva kimai, bona lalonai idia gini maua danu, auri laboralabora dekena amo karaia gaudia. ");
INSERT INTO hmo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Inai koua dabua badana ena lata be 44 mita, iena lababa be 22 mita, bona iena ataiai be mita rua, 20 sentamita. Koua dabua be dabua namo herea dekena amo do umui karaia, bona du idia gini lalonai maua be auri laboralabora gaudia. ");
INSERT INTO hmo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","“Palai Dubu lalonai kohu ibounai be auri laboralabora dekena amo do umui karaia. Palai Dubu ena varo edia ikoko, bona Palai Dubu ia hagegea koua dabua ena varo edia ikoko ibounai danu be auri laboralabora dekena amo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Israela taudia do oi hamaoroa, olive huahua ena oela namo herea momokani lamepa totona do idia mailaia, lamepa be nega ibounai do idia gabua totona. ");
INSERT INTO hmo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Lauegu Palai Dubu lalonai be Arona mai ena natuna tau danu ese lamepa do idia atoa, Taravatu Maua ia hunia noho koua dabua helagana ena vairana kahana dekenai. Bona Arona, mai ena natuna tau ese dina ibounai lamepa dekenai oela do idia bubua, vadaeni lamepa be adorahi ela bona dabai do ia diari. Inai taravatu be umui Israela taudia ese do umui naria ela bona hanaihanai, doko lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Lohiabada ese Mose ma ia hamaoroa, ia gwau, “Oiemu kakana Arona, mai iena natuna tau, Nadaba, bona Abihu, bona Eleasara, bona Itamara, be Israela taudia edia huanai do oi hakaua siri, egu hahelagaia taudia oi ese do oi halaodia totona. ");
INSERT INTO hmo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Oiemu kakana Arona ena dabua helagadia danu do oi karaia namonamo, ia ese mai mataurai toana, bona mai hairaina danu do ia noho totona. ");
INSERT INTO hmo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Diba momo taudia, lau ese aonega lau henidia vadaeni taudia, do oi oda henia, idia ese Arona totona dabua do idia karaia. Vadaeni ia be do ia helaga, bona lauegu hahelagaia tauna do ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","“Inai bamona dabua do idia karaia: Kemena dekenai atoa dabua maragina, dabua helagana ta, ladana epodi, dabua latana ta, epodi ena henunai atoa gauna, sioti ta, mai ena herahera gauna, kwara kumia gauna, bona gaba gauna. Inai dabua helagadia be oiemu kakana Arona mai ena natuna tau totona do umui karaia, idia ese lauegu hahelagaia taudia edia gaukara do idia karaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Inai dabua do idia turia taudia ese golo, bona dabua namodia idauidau, edia kala be bulu, kakakaka sisina, bona kakakaka momokani, do idia hatua, bona mogea, bona do idia karaia namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Inai dabua helagana, epodi, be dabua turia diba momo taudia ese do idia karaia. Golo varo, bona dabua namodia, dabua aukadia, edia kala bulu, kakakaka sisina, bona kakakaka momokani dekena amo do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Epodi ena ataiai kona ruaosi dekenai be varo rua do idia turia kau. Inai varo rua be tau ena pagana gabuna dekenai idia lao, epodi do ia kwatua namonamo totona. ");
INSERT INTO hmo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Gaba gauna danu be epodi idia karaia gaudia hegeregerena dekena amo do idia karaia, golo bona dabua namona, ena kala bulu, kakakaka sisina, bona kakakaka momokani. Gaba be epodi ena kahana ta, dabua tamona. ");
INSERT INTO hmo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Onuku nadidia rua do umui abia, bona edia latanai Iakobo ena natuna ibounai 12 edia ladana do umui torea. ");
INSERT INTO hmo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ladana 6 be nadi ta dekenai do umui torea, ma ladana 6 be nadi ma ta dekenai do umui torea. Vara guna natuna ena ladana do umui torea guna, ela bona gabeai ia vara natuna, namba 12, be dokona dekenai do umui torea. ");
INSERT INTO hmo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Inai gaukara be nadi dekenai revareva ia utua diba momo tauna dekenai do umui henia. Ia ese inai nadi ruaosi dekenai Iakobo ena natuna ibounai edia ladana do ia torea. Bona golo dekena amo nadi do idia dogoatao gabudia rua do ia karaia, mai herahera toana danu do ia koroa. ");
INSERT INTO hmo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Inai nadi ruaosi be epodi ena varo ruaosi, paga gaudia, dekenai do umui kwatua kau, vadaeni inai nadi ese Israela ena iduhu 12 edia toana do idia lao. Inai dala dekenai Arona ese iena pagana dekenai edia ladana do ia huaia, bona Lohiabada ese iena bese taudia do ia laloatao noho nega ibounai. ");
INSERT INTO hmo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Nadi edia isena be golo dekenai do umui hagegea, golo be mai herahera toana do umui koroa. ");
INSERT INTO hmo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Bona golo namo herea danu do umui mogea, vadaeni golo varo rua do umui karaia, Unai golo varo ruaosi be inai nadi edia isena golo danu do umui kwatua tamona. ");
INSERT INTO hmo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Hahelagaia Tauna Badana ena kemena dabua maragina do umui karaia. Inai dabua be Dirava ena ura davaria totona gauna. Epodi umui karaia dabua hegeregerena dekena amo, inai kemena dabua danu do umui karaia, epodi ena turia herahera hegeregerena danu do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kemena dabua ena lata be 44 sentamita, bona iena lababa be 22 sentamita. Dabua ena huana momokani dekenai do umui lokua, vadaeni ia be poketi badana ta hegeregerena, iena lata be 22 sentamita, iena lababa danu 22 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Dabua ena latanai davana bada herea nadi ibounai 12, laini 4 dekenai do umui turia kau. Laini ginigunana dekenai be sadio, topasio, bona barekete nadi do umui turia kau. ");
INSERT INTO hmo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Laini iharuana dekenai be samaragi, sapairo, bona vasiga nadi do umui turia kau. ");
INSERT INTO hmo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Laini ihatoina dekenai be huakinto, akate bona ametuso nadi do umui turia kau. ");
INSERT INTO hmo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","“Laini namba 4 dekenai be berulio, onuku bona iasipa nadi do umui turia kau. Inai nadi ibounai be golo, mai herahera toana danu dekena amo do idia hagegea namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","“Inai nadi 12 ta ta ibounai dekenai Iakobo ena natuna ta ta edia ladana do umui torea, Israela ena iduhu ta ta ibounai edia toana be unai. ");
INSERT INTO hmo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Kemena dabua totona, golo namo herea do umui mogea namonamo, bona seini rua varo bamona, do umui karaia, idia ese dabua be kemena dekenai do idia kwatua totona. ");
INSERT INTO hmo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Golo rini rua do umui karaia, bona kemena dabua ena ataiai kona ruaosi dekenai do umui kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Inai golo seini ruaosi be inai golo rini ruaosi dekenai do umui kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Inai golo seini edia duduna be epodi ena rini dogoatao golo herahera gaudia ruaosi dekenai do umui kwatua. Inai dekena amo kemena dabua be epodi ena paga varo ruaosi dekenai do umui kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","“Ma rini rua golo dekena amo do umui karaia, bona kemena dabua ena henuna kona ruaosi dekenai do umui kwatua, kemena dabua ena murina kahanai, bona epodi kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Bona rini rua golo dekena amo ma do umui karaia, bona epodi vairanai, ena paga dogoatao gaudia dekenai do umui turia kau, gaba gauna kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Vadaeni kemena dabua ena rini ruaosi, bona epodi ena rini ruaosi do umui kwatua hebou, bulu varona dekena amo. Inai dala dekenai kemena dabua be epodi ena gaba gauna do ia kamokau, do idia marere kava lasi. ");
INSERT INTO hmo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Arona be Helaga Herea Gabuna ia raka vareai neganai, inai kemena dabua, Israela ena iduhu edia ladana ia torea gauna, do ia kwatua. Vadaeni inai dekena amo lau Lohiabada ese egu bese do lau laloatao hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Bona inai nadi ruaosi, Dirava ena ura davaria gaudia be kemena dabua lalonai do oi udaia. Vadaeni Arona be Helaga Herea Gabuna, lau noho gabuna, do ia raka vareai neganai, ia ese inai nadi ruaosi do ia abia lao. Inai negadia ibounai inai kemena dabua do ia kwatua, vadaeni lauegu ura Israela taudia totona be do ia davaria diba. ");
INSERT INTO hmo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Epodi ena henunai atoa dabua latana be dabua ena kala bulu dekena amo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Dabua ena huanai be matuna do umui karaia, kwarana atoa gabuna be unai. Bona matuna ena isena danu do umui turia namonamo, do ia darea garina. ");
INSERT INTO hmo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Inai dabua latana ena henuna isena dekenai herahera namodia do umui turia, edia toana be apolo huahua bona edia kala be bulu, kakakaka sisina, bona kakakaka momokani. Inai apolo edia huanai be golo gaba maragidia do umui turia kau. ");
INSERT INTO hmo_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Golo gaba ta, apolo huahua ta, golo gaba ta, apolo huahua ta, unai bamona do idia turia karaia, ela bona dabua latana ena isena herahera idia karaia haorea. ");
INSERT INTO hmo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Arona ese iena gaukara helaga ia karaia negadia ibounai,inai dabua latana do ia kwatua. Vadaeni ia be lau kahirakahira, Helaga Herea Gabuna dekenai ia mai, o bema inai Gabu ia rakatania neganai, taunimanima ese golo gaba edia regena do idia kamonai. Bema Arona be inai bamona ia karaia lasi neganai ia be do ia mase. ");
INSERT INTO hmo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Bona umui ese golo namo herea dekena amo medolo ta do umui karaia. Medolo ena latanai inai bamona hereva do umui torea, ‘Helaga, Lohiabada Ena.’ ");
INSERT INTO hmo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Vadaeni varo, ena kala bulu do umui abia, bona medolo be kwara gauna ena vairana dekenai do umui kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Inai kwara gauna mai ena medolo be Arona ena kwarana dekenai do ia noho. Badina inai dekena amo Israela taudia edia boubou gaudia be lau Lohiabada ese do lau abia dae. Bona bema Israela taudia ese edia boubou idia henia kerere neganai, Arona ese edia kerere ena davana do ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Arona ena sioti be dabua namo herea dekena amo do umui hatua karaia. Bona iena kwara kumia gauna danu be dabua namona momokani dekena amo do umui karaia. Iena gaba gauna mai herahera namodia danu do umui turia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Arona ena natuna tau edia sioti, gaba gaudia, bona kwara gaudia danu do umui karaia, taunimanima edia vairanai edia toana be mai hairaina totona. ");
INSERT INTO hmo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Bona Mose e, oi ese inai dabua ibounai be oiemu kakana Arona bona iena natuna tau dekenai do oi atoa. Bona olive dehoro be idia edia latanai do oi bubua, dagi helagana do idia abia, bona lauegu hahelagaia taudia edia gaukara do idia abia totona. ");
INSERT INTO hmo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Idia edia piripou danu, be dabua auka gaudia, gabana dekena amo ela bona mamuna dekenai, edia hemarai do ia hedinarai lasi totona. ");
INSERT INTO hmo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Arona bona iena natuna tau ibounai ese Palai Dubu idia raka vareai, o Helaga Gabuna lalonai pata helagana kahirakahira idia lao neganai, inai bamona piripou do idia karaia noho. Bema inai bamona idia karaia lasi neganai, idia be kerere, bona idia be do idia mase. Nega ibounai hanaihanai Arona bona iena tubuna taudia ese inai taravatu do idia badinaia.” ");
INSERT INTO hmo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Lohiabada ma ia hereva, ia gwau, “Arona bona iena natuna tau do oi hahelagaia egu hahelagaia taudia edia gaukara totona, bona inai bamona do oi karaia: Boromakau tau ta bona mamoe tau rua, edia tauanina namo herea sibona gaudia, do oi abia. ");
INSERT INTO hmo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Bona uiti ena paraoa namo herea momokani do oi abia. Paraoa dekenai hatubua gauna do oi atoa lasi. Inai paraoa haida dekena amo beredi do oi karaia, bona inai paraoa haida be olive dehoro danu do oi mikisi. Inai dekena amo beredi ma do oi karaia. Bona paraoa haida dekena amo bisikesi haida do oi karaia, bona olive dehoro dekena amo bisikesi do oi dahua. ");
INSERT INTO hmo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Inai beredi bona bisikesi be bosea ta dekenai do oi udaia, bona unai boromakau bona mamoe be boubou totona oi henia neganai, beredi bona bisikesi danu be lau dekenai do oi henia. ");
INSERT INTO hmo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Vadaeni Arona bona iena natuna tau be Palai Dubu ena iduara dekenai do oi hakaua mai. Iduara ena badinai oi ese idia do oi hadigua. ");
INSERT INTO hmo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Unai murinai dabua helagadia be Arona dekenai do oi atoa. Sioti, epodi, dabua latana, epodi ena henunai atoa gauna, kemena dabua, bona gaba gauna, ibounai be Arona dekenai do oi atoa. ");
INSERT INTO hmo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kwara gauna danu ia dekenai do oi atoa, bona medolo helagana danu be kwara gauna dekenai do oi kwatua kau. ‘Helaga, Lohiabada ena’ be unai medolo dekenai idia torea vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","“Vadaeni hahelagaia taudia hahelagaia totona ena dehoro, be Arona ena kwarana dekenai do oi bubua, do ia helaga. ");
INSERT INTO hmo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Arona ena natuna tau danu do oi hakaua mai, bona edia sioti dabua idia dekenai do oi atoa. ");
INSERT INTO hmo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Edia gabana dekenai gaba gaudia do oi kwatua, bona kwara gaudia edia kwarana dekenai do oi atoa. Inai bamona be Arona bona iena natuna tau do oi hahelagaia. Idia bona edia tubuna taudia ese lauegu hahelagaia taudia edia gaukara do idia karaia ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Vadaeni, boromakau tau do oi hakaua lao, Palai Dubu ena vairana dekenai. Arona bona iena natuna tau ese edia imadia be boromakau ena kwarana dekenai do idia atoa. ");
INSERT INTO hmo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Unai neganai Lohiabada ena vairanai, boromakau do oi alaia, Palai Dubu ena iduara badibadinai. ");
INSERT INTO hmo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Vadaeni boromakau ena rarana sisina oiemu ima kwakikwakina dekenai do oi abia, bona rara be boubou patana ena doadia dekenai do oi dahua. To rara ena orena be pata ena badina dekenai do oi bubua. ");
INSERT INTO hmo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Unai neganai oi ese bogarauna ena digara, asena ena kahana badana, bona nadinadina mai ena digara danu, be boubou patana dekenai do oi gabua, lauegu boubou totona. ");
INSERT INTO hmo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","To boromakau ena vamuna, bona ena kopina, bona ena kukuri be kamepa ena murimurinai do oi gabua. Inai be kara dika kokia totona ena boubou. ");
INSERT INTO hmo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Unai murinai mamoe tau ta do oi abia, bona Arona, mai iena natuna tau danu ese edia imana be mamoe ena kwarana dekenai do idia atoa. ");
INSERT INTO hmo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Vadaeni mamoe do oi alaia, iena rarana do oi abia, bona boubou patana ena kahana 4 dekenai inai rara do oi negea lao. ");
INSERT INTO hmo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Mamoe do oi utua kahana ta ta. Iena bogarau bona iena imana bona aena do oi huria, ma idia danu be iena vamuna bona kwarana danu do oi haboua. ");
INSERT INTO hmo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Idia ibounai be boubou patana ena latanai do oi gabua. Inai be Lohiabada dekenai boubou ia gabua gauna. Lau Lohiabada ese inai boubou ia gabua ena bonana namona lau kamonai neganai, be lau moale. ");
INSERT INTO hmo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Mamoe tau ma ta do oi abia, bona Arona, mai iena natuna tau danu ese edia imana be mamoe ena kwarana dekenai do idia atoa. ");
INSERT INTO hmo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Vadaeni mamoe do oi alaia, iena rarara sisina do oi abia, bona Arona mai ena natuna tau edia taiana idibana edia rini atoa gabuna dekenai inai rara do oi dahua. Ma edia imana kwakikwaki badana, bona aena kwakikwaki badana danu inai rara dekenai do oi dahua. Rara ena orena be boubou patana ena kahana 4 dekenai do oi negea lao. ");
INSERT INTO hmo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Vadaeni boubou patana dekenai ia noho rara sisina bona dehoro helagana haida do oi abia, Arona, mai ena dabua danu, bona iena natuna mai edia dabua danu dekenai inai rara bona dehoro do oi negea lao. Inai bamona oi karaia neganai, Arona, mai ena natuna tau, bona edia dabua danu be lau totona do idia helaga momokani. ");
INSERT INTO hmo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Inai mamoe tau ena digarana do oi utua bona abia, badina inai be hahelagaia taudia do oi hahelagaia ena boubou. Iuna ena digara, bogarau ena digara, asena ena kahana badana, bona nadinadi mai ena digara danu, bona ena idiba mamuna ena vamu danu. ");
INSERT INTO hmo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Unai bosea mai ena beredi idauidau, mai hatubua gaudia lasi, lau Lohiabada dekenai idia henia gaudia dekena amo beredi ta ta do oi abia. Mai olive dehoro danu idia gabua gauna ta, bona mai olive dehoro lasi idia gabua gauna ta, bona bisikesi ta. ");
INSERT INTO hmo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Vadaeni inai vamu bona paraoa gaudia be Arona bona iena natuna tau dekenai do oi henia, edia imadia dekenai do idia dogoatao, lau Lohiabada egu vairanai inai boubou gaudia do idia davea. ");
INSERT INTO hmo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","“Unai murinai, idia dekena amo inai aniani gaudia do oi abia, bona boubou patana dekenai do oi gabua, unai idia gabua vadaeni vamu boubou gauna danu. Inai ibounai be do umui gabua hebou, bona bonana namo herea lau Lohiabada egu vairana dekenai do ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Vadaeni oi ese Arona ia hahelagaia mamoe ena kemena do oi abia, bona lau Lohiabada egu vairana dekenai do oi davea, lau dekenai oi henia ena toana. Oi ese inai kemena vamuna do oi ania diba. ");
INSERT INTO hmo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Hahelagaia taudia do oi hahelagaia neganai, oi ese mamoe ena kemena bona mamuna ena vamu do oi abia, boubou do oi halaoa, bona lau Lohiabada egu vairanai do oi davea. Bona inai murinai inai vamu be hahelagaia taudia dekenai do oi henia, do idia ania. ");
INSERT INTO hmo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Vadaeni lau Lohiabada lau gwau, ‘Israela taudia ese edia laloa namona boubou lau dekenai idia henia negadia ibounai, inai kemena bona mamuna ena vamu be hahelagaia taudia ese do idia ania.’ ");
INSERT INTO hmo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Arona be do ia mase neganai, iena dabua helagadia be iena natuna tau dekenai do idia henia. Bona Arona murinai, iena tubuna taudia be hahelagaia taudia edia gaukara totona idia hahelagaia neganai, inai Arona ena dabua do idia atoa. ");
INSERT INTO hmo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Arona ena natuna, Arona ena hahelagaia gaukara ena gabu ia abia tauna ese inai dabua be dina 7 lalonai do ia atodia. Bona inai dina 7 lalonai, ia ese egu Palai Dubu lalonai do ia raka vareai, bona gaukara helaga be Helaga Herea Gabuna dekenai do ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Arona mai ena natuna tau oi hahelagaia neganai, unai mamoe, boubou gauna, be helaga gabuna ta dekenai do oi nadua. ");
INSERT INTO hmo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Vadaeni Arona, mai ena natuna tau ese unai vamu bona bosea lalonai idia noho paraoa gaudia danu do idia ania, Palai Dubu ena iduara badibadinai. ");
INSERT INTO hmo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","“Inai hahelagaia taudia oi hahelagaia neganai, boubou oi henia aniani gaudia, kara dika kokia totona gaudia, be do idia ania. Hahelagaia taudia sibona ese inai aniani idia ania diba, badina idia helaga. Taunimanima kavakava do idia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Bema inai vamu bona beredi be idia ania ore lasi ela bona dabai, inai be do idia ania lasi. Inai vamu be ia helaga. Unai dainai lahi dekenai do idia gabua ore momokani. ");
INSERT INTO hmo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Dina 7 lalonai, inai Arona mai ena natuna tau oi hahelagaia gaukara do oi karaia, lauegu oda hegeregerena momokani. ");
INSERT INTO hmo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Dina ta ta ibounai oi ese boromakau boubouna do oi henia, kara dika kokia totona. Vadaeni inai boubou ese boubou patana do ia hagoevaia lauegu vairana dekenai. Unai murinai boubou patana dekenai olive dehoro do oi bubua, do ia helaga totona. ");
INSERT INTO hmo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Oi ese boubou patana dekenai inai bamona do oi karaia dina 7 lalonai. Vadaeni boubou patana be lauegu momokani, bona taunimanima dekenai do ia helaga momokani, vadaeni bema tau ta o hahine ta, o gau ta be ia dekenai ia kamokau neganai, inai helaga ena siahu ese do ia hadikaia. ");
INSERT INTO hmo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Dina ibounai umui ese mamoe natuna rua, lagani ta hanaia lasi gaudia, be boubou patana dekenai do umui gabua, boubou totona. ");
INSERT INTO hmo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ta be dabai do umui gabua, ta be adorahi neganai do umui gabua. ");
INSERT INTO hmo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Mamoe ginigunana danu be uiti ena paraoa namona, ena metau kilogaram ta, olive dehoro lita ta danu ia mikisi gauna do umui gabua, boubou totona. Uaina lita ta danu do umui bubua, boubou totona. ");
INSERT INTO hmo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","“Adorahi neganai mamoe iharuana be do umui gabua, bona dabai umui gabua mamoe danu umui henia paraoa, dehoro bona uaina edia bada hegeregerena ma do umui henia unai adorahi boubou totona. Inai aniani boubouna, lau Lohiabada dekenai umui henia gauna ena bonana namona lau kamonai neganai, be do lau moale. ");
INSERT INTO hmo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Inai lahi dekenai idia gabua boubou be vaira neganai ibounai doko lasi do umui karaia Palai Ruma ena iduara badibadinai, lau Lohiabada egu vairana dekenai. Inai gabu dekenai lau ese umui, lauegu bese danu do lau hedavari, bona umui dekenai do lau hereva. ");
INSERT INTO hmo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Unuseni lau ese Israela taudia dekenai do lau hedinarai, bona lauegu hairaina ese inai gabu do ia hahelagaia. ");
INSERT INTO hmo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Vadaeni lau ese Palai Dubu bona boubou patana do lau hahelagaia, bona Arona mai ena natuna tau danu be do lau hahelagaia, hahelagaia taudia edia gaukara totona, ");
INSERT INTO hmo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Lau be Israela taudia edia huanai do lau noho, bona lau be edia Dirava do lau lao. ");
INSERT INTO hmo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Idia be do idia diba lau be Lohiabada, edia Dirava. Aigupito dekena amo be lau ese idia lau hakaua, idia edia huanai do lau noho totona. Lau inai Lohiabada, idia edia Dirava. ");
INSERT INTO hmo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Pata helagana ta do umui karaia, muramura mai bonana namona gabua totona gauna. Akasia audia dekena amo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Pata ena lata be 45 sentamita bona iena lababa danu be 45 sentamita, bona ena ataiai be 90 sentamita. Pata ena kona 4 dekenai be doa 4 do idia noho. Inai doa be pata danu au tamona dekena amo do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Pata ena kopina be golo namo herea dekena amo do umui koua, ena ataiai, ena kahana 4, bona ena doa 4 danu. Pata ena isena be golo herahera dekena amo do umui koua hagegea. ");
INSERT INTO hmo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Rini rua be golo dekena amo do umui karaia, pata ena isena henunai inai rini do umui kwatua, ta pata ena kahana dekenai, ma ta pata ena kahana dekenai. Pata huaia totona au rua be inai rini rua lalonai do umui toia vareai. ");
INSERT INTO hmo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Pata huaia audia rua be akasia audia dekena amo do umui karaia, bona golo dekena amo do umui koua. ");
INSERT INTO hmo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","“Helaga Herea Gabuna lalonai lasi, to koua dabua helagana kahirakahira, bona Taravatu Maua kahirakahira, inai muramura patana do umui atoa. Inai Maua ena koua gauna, kara dika gwauatao gabuna dekenai, be lau ese oi dekenai do ita hedavari. ");
INSERT INTO hmo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Dabai ibounai, lamepa do ia hagoevaia neganai, Arona ese mai bonana namona muramura unai pata ena latanai do ia gabua. ");
INSERT INTO hmo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Adorahi neganai danu, lamepa do ia hadiaria neganai, Arona ese mai bonana namona muramura ma do ia gabua unai pata dekenai. Umui ese inai muramura gabua ena boubou be do umui karaia noho, doko lasi, ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Inai muramura patana ena latanai muramura idauna ta, gwaumaoro lau henia lasi gauna, do umui gabua lasi. Vamu gabua boubouna, paraoa o uaina boubouna do umui karaia lasi inai pata ena latanai. ");
INSERT INTO hmo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“Lagani ta ta lalonai dina tamona dekenai, Arona ese muramura patana hagoevaia gaukara do ia karaia. Inai bamona karaia totona Arona ese kara dika kokia vamuna ena rara dekenai muramura patana ena doa 4 do ia dahua. Umui ese lagani ta ta ibounai hanaihanai inai muramura patana hagoevaia kara do umui karaia. Vadaeni inai muramura patana be do ia helaga momokani, lau Lohiabada dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Oi ese buka dekenai Israela taudia edia ladana do oi torea neganai, idia ta ta ibounai ese moni haida lau dekenai do idia henia. Bema idia henia lasi, unai ladana torea neganai, gorere dikana ese idia do ia hadikaia. ");
INSERT INTO hmo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","“Buka dekenai edia ladana idia torea vadaeni taudia ibounai ese moni hegeregere 5 kina be lau dekenai do idia henia, boubou totona. ");
INSERT INTO hmo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Buka dekenai edia ladana idia torea taudia be mauri lagani 20 idia abia, bona lagani 20 idia hanaia taudia ibounai. Bona inai taudia ese inai moni lau dekenai do idia henia. ");
INSERT INTO hmo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Kohu momo taudia ese unai moni do idia hanaia lasi, bona ogogami taudia ese unai moni do idia hamaragia lasi. Idia ibounai ese 5 kina lau dekenai do idia henia, edia kara dika davana totona, idia be do idia mase lasi totona. ");
INSERT INTO hmo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Inai takisi moni Israela taudia dekena amo do oi gogoa, lauegu Palai Dubu do umui naria namonamo totona. Inai takisi moni be edia mauri naria totona ena davana, bona lau ese idia do lau laloa bona naria.” ");
INSERT INTO hmo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ma Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Disi ta, auri laboralabora dekena amo do umui karaia, ma pata ta, disi be ia latanai atoa gauna, be auri laboralabora dekena amo danu do umui karaia. Inai disi be Palai Dubu bona boubou patana edia huanai do umui atoa. Ranu be disi lalonai do umui bubua. ");
INSERT INTO hmo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","“Arona bona iena natuna tau ese inai ranu dekenai edia imadia bona aedia do idia huria. ");
INSERT INTO hmo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Idia ese Palai Dubu do idia raka vareai neganai, o boubou patana dekenai aniani boubou gauna henia totona idia lao neganai, edia imadia bona aedia do idia huria, do idia mase garina. ");
INSERT INTO hmo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Momokani idia ese edia imadia bona aedia do idia huria, do idia mase garina. Inai taravatu be idia bona edia tubuna taudia do idia naria ela bona hanaihanai.” ");
INSERT INTO hmo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Muramura namo herea do umui abia, muro ena ranu, iena metau be 6 kilogram. Bona kinamono pauda, mai bonana namona, ena metau 3 kilogram, bona kane, mai bonana namona, ena metau 3 kilogram. ");
INSERT INTO hmo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Bona kasia auna ena pauda ena metau 6 kilogram do umui abia, ibounai edia metau be Helaga Gabuna ena sikele hegeregerena. Olive dehoro, ibounai 4 lita ma do umui bubua vareai. ");
INSERT INTO hmo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Inai muramura ibounai do umui mikisi, vadaeni dehoro helagana do ia lao. Do umui mikisi namonamo, muramura ia karaia tauna korikori ese ia karaia bamona, vadaeni dehoro helagana do umui halaoa. ");
INSERT INTO hmo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","“Inai dehoro helagana be Palai Dubu dekenai do umui bubua sisina sisina, Taravatu Maua dekenai danu do umui bubua, ");
INSERT INTO hmo_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","pata dekenai danu, pata ena latanai gaudia danu, lamepa dogoatao gauna, mai ena kohu, bona muramura patana danu. ");
INSERT INTO hmo_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Boubou patana danu, boubou idia gabua gauna, mai ena kohu ibounai, bona ranu ena disi, mai ena patana. ");
INSERT INTO hmo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Inai dala dekenai, inai gaudia ibounai do umui hahelagaia. Idia be lauegu momokani, bona taunimanima dekenai idia helaga momokani. Bema tau ta o hahine ta, o gau ta idia dekenai kamokau neganai, edia helaga ena siahu ese do ia hadikadia. ");
INSERT INTO hmo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Inai dehoro helagana be Arona mai ena natuna tau edia latanai do oi bubua, vadaeni hahelagaia taudia do oi halaodia, bona egu hesiai gaukara do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Vadaeni Israela taudia do oi hamaorodia, do oi gwau, ‘Inai be Lohiabada ena dehoro helagana, egu hesiai gaukara totona do umui gaukaralaia, vaira negadia ibounai. ");
INSERT INTO hmo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Taunimanima, helaga dagi lasi taudia dekenai do umui bubua lasi, bona dehoro ta ia hegeregerena ta do umui karaia lasi. Ia be helaga, Dirava sibona ena, bona do umui gaukaralaia kava lasi. ");
INSERT INTO hmo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Bema tau ta ese dehoro ia hegeregerena do ia karaia, o bema hahelagaia tauna lasi tauna ta dekenai ia gaukaralaia, unai tau be egu bese dekena amo do idia negea murimuri dekenai.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Lohiabada ese Mose ia hamaoroa, ia gwau, “Inai muramura mai edia bonana namodia edia pauda do umui abia, edia metau be tamona: Natapa, sekelete, kelebena bona libano. ");
INSERT INTO hmo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Inai muramura ibounai do umui haboua, bona do umui mikisi namonamo. Damena danu do umui atoa vareai, umui mikisi nega tamona, do ia goevagoeva, bona do ia helaga. ");
INSERT INTO hmo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Vadaeni umui mikisi gauna sisina do umui abia, bona do umui botaia ela bona ia be pauda momokani. Palai Dubu lalonai unai pauda sisina do umui abia vareai, bona Taravatu Maua ena vairana dekenai, lau noho gabuna dekenai, do umui atoa. Inai bonana namona kwalahu ena muramura pauda be helaga herea umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","“Umui sibona gaukaralaia totona muramura pauda ta inai hegeregerena do umui karaia lasi. Ia be helaga momokani, lau Lohiabada sibona egu. ");
INSERT INTO hmo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Bema tau ta ese muramura pauda inai bamona do ia karaia ia sibona ena, unai tau be egu bese dekena amo do idia negea murimuri dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Lau ese Besalele, Uri ena natuna, Huru ena tubuna, Iuda ena iduhu tauna lau abia hidi vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Lau ese Besalele dekenai egu Lauma ena siahu lau henia, vadaeni aonega bona diba bada bona laloa goada danu lau henia vadaeni, ");
INSERT INTO hmo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","golo, bona siliva bona auri labora do ia gaukaralaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ma nadi namo herea, davana bada gaudia do ia utua ena aonega, bona au koroa ena aonega Basalele dekenai lau henia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","“Lau ese danu Oholiaba danu lau abia hidi vadaeni. Ia be Ahisamaka ena natuna, Dano ena iduhu tauna. Oholiaba ese Besalele danu do idia gaukara hebou. Bona inai bamona gaukara diba taudia ibounai dekenai aonega lau henia vadaeni. Unai dainai umui lau hamaoroa vadaeni gaudia ibounai be idia ese do idia karaia diba, gaudia inai: ");
INSERT INTO hmo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Palai Dubu, lau noho gabuna, Taravatu Maua, mai ena koua gauna, bona Palai Dubu lalonai idia noho gaudia ibounai, ");
INSERT INTO hmo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","pata helagana, mai ena kohu, bona lamepa dogoatao gauna, golo namo herea gauna, mai ena kohu ibounai, bona muramura patana, ");
INSERT INTO hmo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","boubou patana, vamu bouboudia idia gabua patana mai ena kohu ibounai, bona huria totona ranu ena disi, mai ena patana. ");
INSERT INTO hmo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","“Ma Arona mai ena natuna tau edia dabua namo herea, hahelagaia taudia edia gaukara idia karaia neganai idia atoa dabua, inai danu be inai aonega taudia ese do idia turia. ");
INSERT INTO hmo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ma dehoro helagana, bona mai bonana namona muramura ena pauda, Helaga Gabuna dekenai gaukaralaia gaudia danu be do idia karaia. Inai gaudia idia karaia neganai, oi dekenai lau oda vadaeni hegeregerena momokani do idia karaia.” ");
INSERT INTO hmo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Lohiabada ese Mose ia oda henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Israela taudia do oi hamaoroa, ‘Sabati Dina, egu laga-ani dinana do umui matauraia nega ibounai. Badina ia be toa ta, lau bona umui iseda huanai, ela bona hanaihanai. Sabati Dina ese umui dekenai ia hedinaraia, lau Lohiabada ese umui lau abia hidi, bona umui be lauegu bese korikori umui lao vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Umui ese inai laga-ani Dinana do umui matauraia, badina ia be helaga. Bema tau ta be inai Dina dekenai ia gaukara neganai, unai tau be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Pura ibounai lalonai dina 6 umui gaukara diba, to dina namba 7 be lau sibona egu Dina helaga. Bema tau ta be inai Dina dekenai ia gaukara neganai, unai tau be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israela taudia ese inai Sabati Dina do idia matauraia ela bona hanaihanai, badina ia be umui ese lau danu gwauhamata taravatuna umui karaia ena toana. ");
INSERT INTO hmo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Inai Dina be umui Israela taudia bona lau, iseda gwauhamata taravatuna ena toana. Bona inai gwauhamata taravatuna be do ia noho ela bona hanaihanai. Badina be lau Lohiabada ese dina 6 lalonai guba bona tanobada lau karaia, bona dina namba 7 dekenai lau gaukara lasi, to lau laga-ani.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Dirava ese Sinai Ororo dekenai Mose ia hereva henia ore neganai, Taravatu nadi ruaosi Mose dekenai ia henia. Unai nadi palaka ruaosi be Dirava ese iena imana kwakikwakina dekena amo Taravatu ia torea nadidia. ");
INSERT INTO hmo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Israela taudia idia itaia, Mose be ororo dekenai ia noho daudau herea, bona ia giroa mai haraga lasi. Vadaeni Arona dekenai idia haboua, idia hamaoroa, idia gwau, “Mose, Aigupito dekena amo ai ia hakaua tauna dekenai, be dahaka ia vara ai diba lasi. Unai dainai kaivakuku do oi karaia, ia ese ai do ia hakaua totona.” ");
INSERT INTO hmo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Vadaeni Arona ese idia ia hamaoroa, ia gwau, “Taiana dekenai umui atoa golo herahera gaudia, emui adavana, emui natudia, memero bona kekeni idia karaia gaudia do umui kokia, lau dekenai do umui henia.” ");
INSERT INTO hmo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Vadaeni taunimanima ibounai ese edia golo herahera gaudia edia taiana dekena amo idia kokia, Arona dekena idia henia. ");
INSERT INTO hmo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Arona ese unai golo gaudia ia abia, bona ibounai ia havevea hebou. Vadaeni iena imana dekenai unai golo ia koroa, bona boromakau tau ena laulauna ia karaia. Vadaeni unai taunimanima idia gwau, “Israela taudia e, iseda dirava be inai, Aigupito dekena amo ita ia hakaua vadaeni!” ");
INSERT INTO hmo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Arona ese unai golo boromakau tau ena vairanai boubou patana ta ia haginia. Vadaeni hereva ia gwauraia, ia gwau, “Kerukeru be aria ta do ita karaia, Lohiabada do ita hanamoa totona.” ");
INSERT INTO hmo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Unai dainai, daba maragi neganai, boubou gaudia, hegeregere boromakau bona mamoe gaudia idia henia, haida be idia gabua ore boubou gaudia, haida be idia ania hebou boubou gaudia. Vadaeni idia helai helai diho, idia aniani, bona uaina idia inua. Vadaeni idia toreisi, idia gadara mai lebulebu danu. ");
INSERT INTO hmo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Lohiabada ese Mose ia hereva henia, ia gwau, “Oi diho lao haraga, badina be oiemu bese taudia, Aigupito dekena amo oi hakaudia taudia, be idia kara dika vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Lau oda henidia dalana be idia rakatania haraga vadaeni. Idia be boromakau tau ena laulauna idia karaia vadaeni, golo idia havevea gauna, bona idia tomadiho henia, bona ia dekenai boubou gaudia idia henia vadaeni. Bona idia hereva noho, idia gwau, ‘Israela taudia e, inai be iseda dirava, Aigupito dekena amo ita ia hakaua vadaeni.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ma Lohiabada ese Mose ia hereva henia, ia gwau, “Lau diba inai orea be kudouna auka bona kamonai lasi taudia. ");
INSERT INTO hmo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Vadaeni oi siri, badina lauegu badu ia siahu momokani idia dainai, bona idia do lao hadikaia ore momokani. Unai murinai oi bona oiemu bese taudia be bese badana ta do lau halaoa.” ");
INSERT INTO hmo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","To Mose ese Lohiabada, iena Dirava, ia noia, ia gwau, “Lohiabada e, dahaka dainai oiemu badu ia siahu dikadika oiemu bese taudia dekenai? Aigupito dekena amo unai taudia oi hakaudia, mai oiemu siahu badana, bona mai oiemu goada badana, ani? ");
INSERT INTO hmo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Dahaka namo do oi abia bema Aigupito taudia ese inai bamona do idia hereva, ‘Lohiabada ese dala dikana dekena amo iena bese taudia Aigupito dekena amo ia hakaudia. Ororo dekenai ia ese ia aladia, bona ia ura be idia do ia hadikaia ore momokani?’ Oiemu badu mani oi rakatania, bona oiemu orea taudia hadikaia ore laloa dekena amo mani do oi giroa. ");
INSERT INTO hmo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","“Oiemu hesiai taudia Aberahamo bona Isako bona Iakobo mani oi laloa, oi sibona mai gwauhamata metauna oi hamaorodia, oi gwau, ‘Umui emui tubudia do lau hanamodia, vadaeni do idia momo herea, guba ena hisiu be momo herea bamona. Bona unai tano ibounai, lau gwauhamata henia do lau henidia tano, be umui emui tubudia dekenai do lau henia. Unai tano be idia edia tano ela bona hanaihanai.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Vadaeni Lohiabada ese iena bese taudia aladia ore laloa dekena amo ia giroa. ");
INSERT INTO hmo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mose be ororo ena ataiai dekena amo ia diho lao. Bona taravatu nadi ruaosi iena imana dekenai ia abidia lao. Unai nadi palaka ruaosi be kahana ruaosi dekenai, vairana kahanai, bona murina kahanai, taravatu edia revareva idia torea vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Unai nadi be Dirava sibona ese ia karadia, bona unai revareva be Dirava sibona ese ia torea gaudia. ");
INSERT INTO hmo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Iosua ese regena bada ia kamonai, Israela taudia idia boiboi momo regena. Vadaeni ia ese Mose ia hamaoroa, ia gwau, “Tuari ena regena be kamepa dekenai lau kamonai.” ");
INSERT INTO hmo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mose ia gwau, “Lasi, lau kamonai noho gauna be kwalimu dainai idia moale regena lasi, bona idia lusi dainai idia tai regena lasi, to ane idia abia noho.” ");
INSERT INTO hmo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Kamepa kahirakahira ia raka neganai, Mose ese boromakau tau ena laulau ia itaia, bona taunimanima idia mavaru noho ia itaia. Vadaeni Mose ia badu dikadika, ia ese taravatu nadi ruaosi iena imana dekena amo ia negea diho, bona ororo badina dekenai idia makohia maragimaragi. ");
INSERT INTO hmo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Mose ese unai boromakau tau ena laulau, idia ese idia karaia gauna ia abia, lahi dekenai ia gabua, ia havevea, bona pauda bamona ia makohia maragimaragi. Vadaeni ranu lalonai ia udaia, ia mikisi, bona ia ese Israela taudia ia oda henidia, vadaeni idia inua. ");
INSERT INTO hmo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Bona Mose ese Arona ia gwau henia, ia gwau, “Inai taunimanima ese oi dekenai dahaka idia karaia, oi ese inai bamona kara dika bada herea dekenai oi hakaudia?” ");
INSERT INTO hmo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Arona ia haere, ia gwau, “Lohia e, mani oi badu lasi lau dekenai, oi diba inai taunimanima be kara dika idia ura dikadika. ");
INSERT INTO hmo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Lau dekenai idia hamaoroa, idia gwau, ‘Kaivakuku do oi karaia, ai do ia hakaua totona, badina be unai Mose, Aigupito dekena amo ai ia hakaua tauna dekenai dahaka ia vara ai diba lasi.’ ");
INSERT INTO hmo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Vadaeni lau gwau, ‘Mai edia golo herahera taudia ese golo do idia kokia, lau dekenai do idia henia.’ Vadaeni golo idia henia murinai, lau ese lahi dekenai lau negea, bona unai boromakau tau be lahi dekena amo ia mai.” ");
INSERT INTO hmo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose ese taunimanima ia itaia, Arona ese ia koudia lasi dainai, lebulebu karadia idia karaia, vadaeni idau bese taudia, idia tuari henidia taudia, ese edia hemarai sivaraina do idia kamonai. ");
INSERT INTO hmo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Unai dainai Mose be kamepa ena ikoukou dekenai ia gini, ia boiboi, ia gwau, “Lohiabada ena kahana taudia be lau dekenai do umui haboua mai.” Vadaeni Levi ena natuna taudia ibounai be Mose dekenai idia haboua. ");
INSERT INTO hmo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Vadaeni Mose ese ia hamaorodia, ia gwau, “Lohiabada, Israela taudia edia Dirava ena oda be inai: Umui ta ta ibounai emui tuari kaia do umui abia, kamepa do umui raka hanaia, emui tadikakadia, emui turadia, bona emui badibadinai taudia do umui alaia mase.” ");
INSERT INTO hmo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Vadaeni Levi ena natuna taudia ese Mose ena oda hereva idia kamonai henia. Bona unai dina dekenai taunimanima 3000 bamona idia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mose ese Levi taudia ia hamaoroa, ia gwau, “Hari dina umui ese sibona umui hahelagaia vadaeni, umui be Lohiabada ena hesiai taudia. Badina be umui ta ta ese sibona ena natuna, bona sibona ena tadikakana ia alaia vadaeni. Unai dainai Lohiabada ese hanamoa umui dekenai ia henia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kerukeru, Mose ese Israela taudia ia hamaoroa, ia gwau, “Umui emui kara dika be bada herea. To harihari lau be ororo do lau daekau, Lohiabada dekenai do lau lao, emui dika gwauatao dalana do lau tahua.” ");
INSERT INTO hmo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Vadaeni Mose ese Lohiabada dekenai ia giroa lou, ia gwau, “Inai taunimanima ese kara dika badana ta idia karaia vadaeni, dirava ta golo dekena amo idia karaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mani emu kara edia kara dika do oi gwauatao. To bema lasi, lauegu ladana, oi ese oi torea bukana dekena amo do oi kokia.” ");
INSERT INTO hmo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","To Lohiabada ese Mose ia haere henia, ia gwau, “Lau dekenai idia kara dika taudia, edia ladana sibona lauegu buka dekena amo do lau kokia. ");
INSERT INTO hmo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","To harihari oi lao, taunimanima do oi hakaua, oi dekenai lau hamaorolaia tanona dekenai do oi hakaudia vareai. Momokani lauegu aneru ese umui do ia gunalaia. To nega be do ia ginidae, lau ese inai taunimanima dekenai edia kara dika davana do lau henia.” ");
INSERT INTO hmo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Vadaeni Lohiabada ese Israela taudia gorere ta dekena amo ia hisihisi henidia, badina be boromakau tau, Arona ese ia karaia gauna, be idia tomadiho henia dainai. ");
INSERT INTO hmo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, “Inai gabu dekena amo do oi raka lao, oi bona Aigupito dekena amo oi hakaudia taudia. Bona umui dekenai lau gwauhamata henia tano dekenai do umui lao. Aberahamo bona Isako bona Iakobo dekenai lau gwauhamata henidia tanona be unai. Lau hamaorodia, lau gwau, ‘Unai tano be emui tubudia dekenai do lau henia.’ ");
INSERT INTO hmo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Aneru ta umui emui vairana dekenai do lau siaia, bona Kanana taudia, bona Amoro taudia, bona Hiti taudia bona Perisi taudia bona Hivi taudia bona Iebusu taudia do lau lulua, bona kokia. ");
INSERT INTO hmo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Umui be tano namo herea ta dekenai do umui lao, unai tano ese kohu bona aniani namodia momo do ia havaraia. To umui be hekokoroku taudia dainai, lau ese umui do lau bamoa lasi, dala dekenai umui do lau hadikaia ore garina.” ");
INSERT INTO hmo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Inai Dirava ena hereva be Mose ese ia hadibadia neganai, Israela taudia be edia lalona idia hisihisi. Edia herahera gaudia be edia kopina dekenai idia atoa lou lasi. ");
INSERT INTO hmo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Badina be Lohiabada ese Mose ia hamaoroa vadaeni, ia gwau, “Israela taudia do oi hamaorodia, do oi gwau, ‘Umui be hekokoroku taudia. Bema nega sisina sibona umui do lau bamoa neganai, lau ese umui do lau hadikaia ore. Unai dainai emui herahera gaudia do umui kokia, vadaeni lauegu kara, umui dekenai do lau karaia gauna, be do lau laloa.’ ” ");
INSERT INTO hmo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Unai dainai Israela taudia ese Sinai Ororo idia rakatania neganai, herahera gaudia edia kopina dekenai idia atoa lou lasi. ");
INSERT INTO hmo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mose ena kara be inai bamona: Israela taudia ese kamepa idia haginia negadia ibounai, Mose ese Palai Ruma be kamepa ena murimurina dekenai ia haginia. Bona unai Palai Ruma ena ladana be, Lohiabada ia noho Palai Rumana. Vadaeni tau ta bema Lohiabada ena ura ia ura diba neganai, ia ese unai Palai Ruma dekenai ia lao diba. ");
INSERT INTO hmo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","To Mose be unai Lohiabada ena Palai Ruma dekenai ia lao negadia ibounai, taunimanima ibounai idia toreisi, edia palai rumadia ta ta edia iduara dekenai idia gini, Mose idia itaia noho, ia raka vareai. ");
INSERT INTO hmo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Badina be Mose be unai Palai Ruma ia raka vareai negadia ibounai, ori ta ia diho, Palai Ruma ena iduara dekenai ia gini, bona Lohiabada ese unai ori ena lalona dekena amo Mose dekenai ia hereva henia. ");
INSERT INTO hmo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kamepa taudia ese unai ori be Palai Ruma ena iduara dekenai idia itaia neganai, idia ta ta edia palai ruma iduara ta ta dekenai idia gini, edia kwarana idia atoa diho. ");
INSERT INTO hmo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Lohiabada ese Mose ia hereva henia, tau ta ese iena turana ia hereva henia bamona. Ruaosi edia hereva ia ore neganai, Mose be kamepa dekenai ia giroa lou. To Mose ena durua tauna, ena ladana Iosua Nunu, eregabe tauna ta, be unai Palai Ruma ia rakatania lasi. ");
INSERT INTO hmo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mose ese Lohiabada dekenai ia hereva, ia gwau, “Mani oi laloa, lau oi hamaoroa vadaeni, oi gwau, ‘Inai taunimanima do oi hakaua lao.’ To daika tauna do oi siaia, ia ese lau do ia bamoa, be lau do oi hamaoroa lasi. Ma lau oi hamaoroa vadaeni, oi gwau, ‘Oiemu kara lau diba namonamo, bona oi lau ura henia.’ ");
INSERT INTO hmo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Vadaeni bema oi ura henia lau, lau ura oiemu palani be lau dekenai mani do oi hadibaia. Unai neganai oi do lau diba, bona oiemu ura be nega ibounai do lau karaia. Bona mani emu kara, lau ura oi laloa noho, inai bese be oi abia hidi vadaeni, oiemu bese korikori.” ");
INSERT INTO hmo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Lohiabada ia gwau, “Lau ese oi do lau bamoa, bona kwalimu oi dekenai do lau henia.” ");
INSERT INTO hmo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mose ia haere, ia gwau, “Bema oi ese ai do oi bamoa lasi, mani emu kara inai gabu dekena amo ai do oi siaia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Bema oi ese ai do oi bamoa lasi neganai, edena bamona idau bese taudia do idia diba oi ese lau bona oiemu orea taudia oi ura henia? To bema oi be ai danu ita lao neganai, idau bese taudia do idia diba namonamo, ai be bese idauna momokani, tanobada besedia ibounai edia huanai.” ");
INSERT INTO hmo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Vadaeni Lohiabada ese Mose dekenai ia haere, ia gwau, “Oiemu noinoi hegeregerena do lau karaia, badina be oiemu kara lau diba namonamo, bona oi lau ura henia.” ");
INSERT INTO hmo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mose ese Lohiabada ma ia noia, ia gwau, “Mani emu kara oiemu hairaina ena diaridiari lau dekenai do oi hedinaraia.” ");
INSERT INTO hmo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Lohiabada ia haere, ia gwau, “Lauegu kara namona ibounai be oi dekenai do lau hedinaraia, bona lauegu ladana helagana, Lohiabada, be oiemu vairana dekenai do lau gwauraia. Kamonai, bema lau ura tau ta do lau bogahisihisi henia neganai, unai tau do lau bogahisihisi henia. ");
INSERT INTO hmo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","“To lauegu vairana be oi dekenai do lau hedinaraia lasi, badina be bema tau ta ese lauegu vairana ia itaia neganai, unai tau be do ia mase.” ");
INSERT INTO hmo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Lohiabada ma ia gwau, “Oi itaia, nadi badana ta lauegu badinai ia noho. Unai nadi ena latanai do oi gini. ");
INSERT INTO hmo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Vadaeni lauegu hairaina ena diaridiari oi kahirakahira do ia raka hanaia neganai, lau ese nadi ena matuna ta lalonai oi do lau atoa vareai, bona egu imana dekenai inai matuna do lau koua, ela bona lau raka hanaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Unai murinai lauegu imana do lau kokia, bona lauegu doruna sibona do oi itaia, to egu vairana do oi itaia lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, “Nadi palaka rua ma do oi abia, nadi gunadia hegeregerena, oi hamakohia gaudia. Bona lau ese revareva ma do lau torea lou, guna lau torea hereva hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kerukeru dabai unai nadi ruaosi do oi abia hegaegae, bona Sinai Ororo do oi daekau mai, lauegu vairana dekenai do oi gini, ororo ena ataiai momokani gabunai. ");
INSERT INTO hmo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tau ta ese oi do ia bamoa lasi, bona tau ta lasi ese inai ororo dekenai do ia gini. Bona mamoe bona boromakau be inai ororo kahirakahira rei do idia tahua lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Vadaeni Mose ese nadi palaka rua ma ia utua, unai gunadia hegeregerena. Daba rere neganai Mose ia toreisi, Sinai Ororo dekenai ia daekau lou. Lohiabada ese ia oda henia hegeregerena, Mose ese unai nadi palaka ruaosi ia abia daekau. ");
INSERT INTO hmo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Lohiabada be ori lalonai ia diho, bona Mose ena badibadinai ia gini, ororo ena ataiai dekenai. Lohiabada ese sibona ena ladana helagana ia gwauraia, Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Vadaeni Lohiabada ese Mose kahirakahira ia raka hanaia, bona ia boiboi inai bamona, ia gwau, “Lau be Lohiabada. Lau Lohiabada be bogahisihisi bona hariharibada Diravana. Lau be badu dekenai lau haraga lasi, to bogahisihisi bona lalokau dekenai lau be haraga. ");
INSERT INTO hmo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Taunimanima momo herea dekenai lau bogahisihisi henia noho, bona kara dika, bona kara kerere idauidau lau gwauatao noho. To kerere momokani taudia do lau panisia. Bona tamadia edia kara dika davana be edia natudia dekenai do lau henia, bona edia tubudia dekenai do lau henia, ia lao bona uru toi o uru hani idia ore.” ");
INSERT INTO hmo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Vadaeni Mose be tano dekenai ia tui diho haraga, ia tomadiho henia. ");
INSERT INTO hmo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ia gwau, “Lohiabada e, bema lau dekenai oi ura henia, mani emu kara ai danu do ita lao. Momokani inai taunimanima be laloa hekokoroku taudia, to lau ura aiemai kerere bona kara dika do oi gwauatao, bona oiemu bese taudia korikori mani do oi halaoa ai.” ");
INSERT INTO hmo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Lohiabada ese Mose ia hamaoroa, ia gwau, “Harihari lau ura Israela taudia danu gwauhamata taravatuna mai laloa tamona do ita karaia. Oiemu orea taudia edia vairana dekenai hoa karadia do lau karaia. Inai bamona hoa karadia be guna lau hedinaraia lasi bese idauidau taudia dekenai. Unai dainai unai hoa karadia, lau Lohiabada ese do lau karaia gaudia idia itaia neganai, inai bese idauidau taudia do idia gari bada. Momokani, umui durua totona do lau karaia gaudia, be gari gaudia. ");
INSERT INTO hmo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hari dina umui dekenai do lau henia taravatu ibounai do umui badinaia. Lau be umui emui vairana dekenai do lau lao, Amoro taudia, bona Kanana taudia, bona Hiti taudia, bona Perisi taudia, bona Hivi taudia, bona Iebusu taudia do lau lulua momokani. ");
INSERT INTO hmo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Do umui naria namonamo, do umui lao gabudia edia noho taudia danu do umui gwauhamata karaia lasi, hekwakwanai dekenai do umui moru garina. ");
INSERT INTO hmo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Lasi momokani, to edia boubou patadia do umui hadikaia ore, edia kaivakuku do umui makohia, bona edia hahine dirava Asera ena laulau gaudia do umui utua diho. ");
INSERT INTO hmo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Umui ese lau sibona do umui tomadiho henia, idau dirava ta do umui tomadiho henia lasi. Badina lau be Lohiabada, bona lau ura lasi idau dirava ta ese lau do ia hereaia. ");
INSERT INTO hmo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Unai dainai umui naria namonamo, unai tano noho taudia danu do umui gwauhamata lasi, o laloa tamona lasi. Badina be edia dirava koikoi idia tomadiho henia bona boubou henia neganai umui danu do idia boiria garina. Bona idia dekena amo do umui siri, umui danu ese edia dirava dekenai idia henia boubou edia vamu do umui ania garina. ");
INSERT INTO hmo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Bona Israela taudia edia natudia tau ese unai bese idauidau hahine do idia adavaia lasi. Badina unai hahine ese edia dirava idia tomadiho henia neganai, unai Israela taudia ese lau do idia rakatania, vadaeni edia adavana edia dirava do idia tomadiho henia garina. ");
INSERT INTO hmo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Dirava koikoi ena laulauna, auri dekenai idia karaia gaudia, be do umui karaia lasi. Bona do umui tomadiho henidia lasi. ");
INSERT INTO hmo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Hatubua Gauna Lasi Paraoa ena aria do umui badinaia noho. Dina 7 lalonai hatubua lasi paraoa sibona do umui ania, umui lau hadibaia vadaeni hegeregerena. Do umui ania negana korikori be hua ladana Abiba neganai, badina be hua Abiba neganai umui be Aigupito umui rakatania. ");
INSERT INTO hmo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Vara guna memero ibounai be lauegu. Boromakau natudia tau vara guna gaudia bona mamoe natudia tau vara guna gaudia danu be lauegu. ");
INSERT INTO hmo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","To bema umui ura emui doniki, vara guna gauna do umui hoia lou, iena davana do umui henia, mamoe ena natuna ta. To bema iena davana umui karaia lasi, unai doniki ena aiona do umui makohia. Bona umui emui vara guna natuna memero ibounai edia davana do umui karaia. “Bema tau ta be mai ena harihari gauna lasi, ia be lauegu vairana dekenai do ia hedinarai lasi. ");
INSERT INTO hmo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Dina 6 do umui gaukara, to dina namba 7 be do umui laga-ani. Uma karaia totona tano makohia neganai, bona anina haboua neganai danu, be dina namba 7 dekenai do umui laga-ani. ");
INSERT INTO hmo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Anina utua ena aria do umui karaia, uiti umui utua hamatamaia neganai. Bona lagani dokona ena aria do umui karaia, uma ena anina umui haboua haorea neganai. ");
INSERT INTO hmo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Lagani ta ta ibounai lalonai umui emui tatau ibounai be nega toi lau, Lohiabada, Israela ena Dirava egu vairanai do idia hedinarai. ");
INSERT INTO hmo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Badina be lau ese bese idauidau do lau lulua momokani umui emui vairana dekena amo, bona emui tano be do lau habadaia. Bema lagani ta ta ibounai lalonai nega toi Lohiabada emui Dirava ena vairanai umui hedinarai neganai, tau ta ese emui tano do ia abia kava lasi. ");
INSERT INTO hmo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Boromakau o mamoe lau dekenai umui henia boubou totona neganai, paraoa mai hatubua muramurana danu do umui henia lasi. Pasova ena aria totona idia alaia ubua gauna ta ena vamu kahana ta be do umui dogoatao lasi ia lao bona kerukeru. ");
INSERT INTO hmo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Lagani ta ta ibounai emui uma anina ia mage guna gauna be Lohiabada ena ruma dekenai do umui mailaia. Nani ena natuna be iena sinana ena rata lalonai do umui nadua lasi.” ");
INSERT INTO hmo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Lohiabada ese Mose ia hamaoroa, ia gwau, “Inai hereva be do oi torea, badina be inai hereva dekena amo lau be oi bona Israela taudia danu gwauhamata taravatuna do ita karaia.” ");
INSERT INTO hmo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Dina 40 bona hanuaboi 40 Mose be ororo dekenai Lohiabada danu ia noho. Aniani ia ania lasi, ranu danu ia inua lasi. Unai neganai Dirava ese gwauhamata taravatuna ena hereva nadi palakadia rua dekenai ia torea, Taravatu 10 be unai. ");
INSERT INTO hmo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mose be Sinai Ororo dekena amo ia diho mai neganai, ia ese nadi rua ia abia mai, idia latanai Taravatu 10 idia torea gaudia. Ia be Dirava danu ia herevahereva dainai, Mose ena vairana ia diaridiari noho. To Mose ia diba lasi iena vairana be unai bamona. ");
INSERT INTO hmo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Arona bona Israela taudia ibounai ese Mose idia itaia, iena vairana ia diaridiari, vadaeni ia kahirakahira idia raka lasi, idia gari dainai. ");
INSERT INTO hmo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","To Mose be idia dekenai ia boiboi, vadaeni Arona bona Israela gunalaia taudia ibounai be ia dekenai idia haboua. Bona Mose ese idia dekenai ia hereva henia. ");
INSERT INTO hmo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Gabeai Israela taudia ibounai ese Mose kahirakahira idia haboua lao. Vadaeni Lohiabada ese Sinai Ororo ena latanai ia dekenai ia henia Taravatu ibounai be Mose ese ia gwauraia hedinarai idia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Iena hereva ia hadokoa murinai, Mose ese iena vairana be dabua dekenai ia koua. ");
INSERT INTO hmo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","To Dirava ena Palai Ruma dekenai ia raka vareai, Lohiabada dekenai do ia hereva henia totona neganai, Mose be unai dabua iena vairana dekena amo ia kokia. Ia raka murimuri neganai, Mose ese Lohiabada ia hadibaia vadaeni taravatudia be Israela taudia dekenai ia gwauraia hedinarai. ");
INSERT INTO hmo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","To Israela taudia ese Mose ena vairana idia itaia, ia diaridiari. Vadaeni Mose be dabua dekenai iena vairana ia koua lou, ela bona Lohiabada ena hereva kamonai totona Palai Ruma dekenai ia raka vareai lou. ");
INSERT INTO hmo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mose ese Israela taudia ibounai ia boiridia hebou, vadaeni inai bamona ia hamaoroa, ia gwau, “Lohiabada ena taravatu umui dekenai be inai: ");
INSERT INTO hmo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Pura ibounai lalonai dina 6 do umui gaukara, to dina namba 7 be do ia helaga. Ia be Dina Helagana bona laga-ani ena dina, lau Lohiabada egu dina. Bema tau ta be unai dina dekenai ia gaukara neganai ia be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Lahi be do umui karaia lasi emui ruma dekenai Sabati Dina dekenai.” ");
INSERT INTO hmo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mose ese Israela taudia ibounai ia hamaoroa, ia gwau, “Lohiabada ena oda ita dekenai be inai: ");
INSERT INTO hmo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Lau Lohiabada dekenai harihari gauna do umui henia. Harihari gaudia idia ura idia henia taudia ibounai ese golo bona siliva bona auri laboralabora do idia mailaia. ");
INSERT INTO hmo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Ma inai gaudia danu do umui henia: Dabua, edia kala bulu, bona kakakaka sisina, bona kakakaka bona kurokuro, nani edia huina, ");
INSERT INTO hmo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","mamoe edia kopina, edia kala kakakaka, bona nani edia kopina, akasia audia, ");
INSERT INTO hmo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lamepa ena oela, bona Dirava ena dehoro helagana totona muramura, bona muramura mai edia bonana namona, do idia gabua gaudia, ");
INSERT INTO hmo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onuku nadi namodia, bona hahelagaia taudia edia epodi dabua, bona edia kemena dabua herahera totona nadi namodia. ");
INSERT INTO hmo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Gaukara diba momo taudia, emui huanai idia noho diba bada taudia ese do idia haboua, bona lau Lohiabada ese lau oda hegeregerena, inai gau ibounai do umui karaia: ");
INSERT INTO hmo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Palai Dubu, bona iena guhi bona koua dabua, iena kimai, iena haba turia, iena reirei latadia, iena du bona du do idia gini dekenai maua gaudia. ");
INSERT INTO hmo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Taravatu Maua, Maua huaia audia, Maua ena koua gauna, bona koua dabua helagana, Taravatu Maua ia hunia gauna. ");
INSERT INTO hmo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Pata helagana, bona huaia totona audia, bona pata dekenai atoa gaudia, bona lau Dirava dekenai henia beredi helagana. ");
INSERT INTO hmo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","“Lamepa dogoatao gauna, diari totona gauna, mai ena kohu, lamepa mai edia oela. ");
INSERT INTO hmo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Muramura patana, bona huaia totona audia, Dirava ena dehoro helaga, mai bonana namona muramura pauda, Palai Dubu ena iduara dekenai koua dabua. ");
INSERT INTO hmo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Boubou patana, vamu boubou gaudia gabua totona patana, mai ena auri laboralabora dekena amo idia karaia reke bamona gauna, au rakuraku gabua patana unai, be do umui karaia. Boubou patana huaia totona audia, bona boubou patana dekenai ia noho kohu danu do umui karaia. Huria totona ranu ena disi, mai ena patana danu do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Koua dabua, Palai Dubu ia hagegea gauna, bona ena iduara ia koua dabua, bona inai koua dabua ena du, mai du idia gini lalonai maua danu do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Palai Dubu bona koua dabua edia varo bona varo edia ikoko danu do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Hahelagaia taudia edia dabua namo herea, Helaga Gabuna dekenai idia gaukara neganai idia atoa dabua danu do umui karaia. Inai be dabua helagadia, Arona bona iena natuna tau edia.” ");
INSERT INTO hmo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Vadaeni Israela taudia ese Mose idia rakatania. ");
INSERT INTO hmo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Bona harihari gaudia idia ura idia henia taudia ibounai ese edia harihari gaudia be Lohiabada dekenai idia mailaia, Palai Dubu do idia haginia totona. Idia ese ma Palai Dubu lalonai do idia noho gaudia bona kohu, bona dabua helagadia karaia gaudia danu idia mailaia. ");
INSERT INTO hmo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Idia ura harihari gaudia idia henia taudia, tatau bona hahine ese golo gaudia idauidau idia mailaia, pini bona taiana herahera, bona ageva, bona rini. Idia ibounai ese sibona edia harihari gaudia Lohiabada dekenai idia henia. ");
INSERT INTO hmo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Bona mai edia dabua taudia, edia dabua kala bulu, kakakaka sisina, o kakakaka momokani, o kurokuro, Lohiabada henia totona idia mailaia. Haida danu ese nani huina, bona mamoe edia kopina, idia kakakaka karaia gaudia, bona nani edia kopina idia mailaia. ");
INSERT INTO hmo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Mai edia siliva bona mai edia auri laboralabora taudia ibounai ese danu edia siliva bona auri laboralabora Lohiabada dekenai idia henia. Bona mai edia akasia audia, idia gaukaralaia diba audia, taudia danu ese unai audia idia henia. ");
INSERT INTO hmo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Dabua gaukara idia diba hahine ibounai ese danu dabua idia hatua, bona idia karaia vadaeni gaudia idia mailaia, dabua namo herea edia kala bulu, kakakaka sisina, bona kakakaka momokani, bona kurokuro. ");
INSERT INTO hmo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Bona idia ese nani edia huina idia mogea bona idia hatua. ");
INSERT INTO hmo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Iduhu edia lohia ese onuku nadi, bona hahelagaia taudia edia dabua helagadia herahera totona nadi namodia idia mailaia. Unai dabua helagadia be epodi bona kemena dabua. ");
INSERT INTO hmo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Unai lohia taudia ese danu bonana namona muramura, bona lamepa ena oela, bona dehoro helagana ena olive dehoro, bona bonana namona muramura pauda idia mailaia. ");
INSERT INTO hmo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Israela taudia, harihari gaudia idia ura mailaia taudia ibounai, ese unai gau idia mailaia, Lohiabada ese Mose ia oda henia do ia karaia gaukara totona. ");
INSERT INTO hmo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mose ese Israela taudia ia hamaoroa, ia gwau, “Umui itaia, Lohiabada ese Besalele, Uri ena natuna, Huru ena tubuna, Iuda iduhu tauna, ia abia hidi vadaeni. ");
INSERT INTO hmo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Dirava ese iena Lauma ena siahu be Besalele dekenai ia henia vadaeni, laloa goada bona aonega danu. Gaukara namodia, herahera karaia gaukara idauidau ena diba danu Lohiabada ese ia henia. ");
INSERT INTO hmo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Unai dainai ia be toana namodia idauidau herahera, golo, siliva bona auri laboralabora gaudia karaia totona, ena diba be bada. ");
INSERT INTO hmo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Nadi namodia, herahera gaudia, au koroa, bona herahera karaia gaukara idauidau danu be Besalele ia diba momo. ");
INSERT INTO hmo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Bona Lohiabada ese Besalele bona Oholiaba, Ahisamaka ena natuna, Dano ena iduhu tauna ruaosi, dekenai ma hadibaia gaukara diba ia henia. Vadaeni idia ruaosi ese edia gaukara namona ena diba be taunimanima haida dekenai idia hadibaia. ");
INSERT INTO hmo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Lohiabada ese inai tau ruaosi dekenai diba bada ia henidia, bona idia ese gaukara taudia idia hadibaia. Vadaeni unai gaukara taudia ese nadi utua, revareva bona herahera karaia gaukara, mamoe huina dabua hatua, bona dabua turia, dabua namodia edia kala bulu, kakakaka sisina, bona kakakaka momokani idia karaia. Idia ibounai ese diba bona aonega idia davaria, inai gaukara idauidau ibounai do idia karaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Lohiabada ese Besalele bona Oholiaba bona taunimanima momo dekenai aonega ia henidia, gaukara idauidau do idia karaia totona, bona idia ese Dirava ena Palai Dubu ena gaukara ibounai idia karaia diba. Unai dainai inai taudia sibodia ese Lohiabada ia oda, bona ia hadibaia hegeregerena, unai gaukara do idia karaia.” ");
INSERT INTO hmo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mose ese Besalele, Aholiaba, bona Lohiabada ese aonega ia henidia taudia ibounai ia boiria mai. Vadaeni unai taudia, unai gaukara idia ura karaia taudia, be Mose dekenai idia haboua mai, Dirava ena Palai Dubu karaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Unai neganai Israela taudia ese Dirava ena Palai Dubu karaia totona idia henia gaudia ibounai be Mose ese unai gaukara taudia dekenai ia henia. To daba ibounai Israela taudia ese edia harihari gaudia ma idia mailaia, bona idia henia noho. ");
INSERT INTO hmo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Vadaeni unai gaukara diba momo taudia ese inai kara idia itaia neganai, edia gaukara idia rakatania. ");
INSERT INTO hmo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Bona Mose dekenai idia lao, idia gwau, “Taunimanima ese edia harihari gaudia momo herea idia mailaia noho. Idia mailaia gaudia be momo herea, hegeregere momokani, bona idia hanaia danu.” ");
INSERT INTO hmo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Vadaeni Mose ese hereva ia siaia lao kamepa ena kahana ibounai dekenai, inai bamona, “Tau ta o hahine ta ese harihari gauna ta do idia mailaia lou lasi Palai Dubu totona.” Unai hereva dainai taunimanima ese harihari gaudia idia hadokoa. ");
INSERT INTO hmo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Badina be idia henia gaudia be hegeregere momokani, unai gaukara ibounai karaia totona, bona gau haida idia noho kava. ");
INSERT INTO hmo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Vadaeni gaukara taudia edia huanai, gaukara diba herea taudia ese Dirava ena Palai Dubu idia karaia. Palai Dubu be dabua badadia 10, dabua namo herea bona goada dekena amo idia karaia. Dabua idia hatua, bona edia kala be bulu bona kakakaka sisina, bona kakakaka momokani. Bona turia diba momo taudia ese unai dabua dekenai kerubi aneru edia laulau idia turia kau. ");
INSERT INTO hmo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Inai dabua ta ta edia lata be 12 mita bona edia lababa be mita rua, bona dabua ibounai edia lata be hegeregere, bona edia lababa danu hegeregere. ");
INSERT INTO hmo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Dabua ibounai 5 idia turia hebou, vadaeni dabua tamona, latana, ia lao. Ma dabua 5 idia turia hebou, vadaeni dabua tamona, gunana hegeregere, ma ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Dabua, edia kala bulu dekena amo rini momo idia karaia, inai dabua latadia ruaosi idia hakapua totona. Rini ibounai be inai dabua latadia edia isena dekenai idia kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Inai dabua rini 50 be dabua ginigunana ena isena dekenai idia kwatua, ma inai bamona danu dabua rini 50 be dabua iharuana ena isena dekenai idia kwatua. ");
INSERT INTO hmo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ma kimai 50 be golo dekena amo idia karaia. Unai kimai 50 be inai dabua badadia ruaosi edia dabua rini idia vareai. Unai dekena amo unai dabua badadia ruaosi be idia hakapua tamona, vadaeni Dubu tamona ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Unai murinai dabua badana ta idia karaia, Palai Dubu do idia koua totona. Inai dabua badana be nanigosi edia huina dekena amo karaia dabua ibounai 11 dekena amo idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Inai dabua 11 edia bada be tamona, edia lata be 13 mita, bona edia lababa be mita rua. ");
INSERT INTO hmo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Inai dabua 5 idia turia hebou, dabua latana ta ia lao. Ma dabua 6 danu idia turia hebou, dabua latana ta ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Inai dabua latana ginigunana ena isena dekenai dabua rini ibounai 50 idia kwatua, bona dabua latana iharuana ena isena dekenai danu unai bamona rini 50 idia kwatua. ");
INSERT INTO hmo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Kimai ibounai 50, be auri laboralabora dekena amo idia karaia, bona unai dabua latadia ruaosi be kimai 50 dekena amo idia hakapua, vadaeni dabua tamona ia lao. ");
INSERT INTO hmo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Bona idia ese Palai Dubu ena guhi rua idia karaia, ta be mamoe tau edia kopina, edia kala kakakaka, bona ta be davara edia boromakau, rui, edia kopina dekena amo. Inai be ataiai momokani ena guhi. ");
INSERT INTO hmo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Palai Dubu ena haba turia ta ta be akasia audia stadi rua dekena amo idia karaia, mai edia padana audia, vadavada ena toana bamona. ");
INSERT INTO hmo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Inai akasia audia stadi edia lata be 4 mita, bona inai stadi edia padadia dekenai idia noho audia edia lata be 66 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Inai akasia au stadi ta ta ibounai be idia lata sisina, vadaeni idia ta ta be siliva maua lalonai idia gini, haba turia hagoadaia, bona do idia marere lasi totona. Inai akasia au stadi idia utua neganai, ibounai edia lata be hegeregere. ");
INSERT INTO hmo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Inai haba turia, vadavada bamona gaudia, ibounai 20 be Palai Dubu ena diho kahana habana dekenai idia haginia. ");
INSERT INTO hmo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Siliva dekena amo maua 40, mai edia matudia idia karaia. Inai matudia ta ta lalonai stadi ta ta idia haginia. Inai maua rua be haba turia ta ta henunai idia atoa, stadi hagoadaia bona dogoatao totona, do idia marere lasi totona. ");
INSERT INTO hmo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Palai Dubu ena mirigini kahana haba dekenai danu be haba turia ibounai 20 idia haginia. ");
INSERT INTO hmo_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Inai haba turia ta ta ibounai henunai be siliva maua rua idia atoa. ");
INSERT INTO hmo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Palai Dubu ena dina diho kahana habana dekenai haba turia ibounai 6 idia karaia, ");
INSERT INTO hmo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","bona kona ruaosi dekenai haba turia rua idia haginia. ");
INSERT INTO hmo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Inai kona haba turia ruaosi be henuna kahanai idia kwatua auka. Bona ataiai momokani kahanai be rini dekena amo idia kwatua hebou auka. Kona ruaosi be unai bamona idia haginia. ");
INSERT INTO hmo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Unai dainai Palai Dubu ena murina kahanai haba turia ibounai be 8, bona siliva maua ibounai be 16, maua rua be haba turia ta ta henunai idia noho. ");
INSERT INTO hmo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Reirei latadia danu akasia audia dekena amo idia karaia, ibounai 5 be Palai Dubu habana ena mirigini kahana dekenai, ");
INSERT INTO hmo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Ma ibounai 5 be Dubu habana ena diho kahana dekenai, bona ibounai 5 be Dubu habana ena dina diho kahana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Inai reirei latadia, haba ena huanai idia kwatua gaudia, be idia lata, edia lata be haba ena lata hegeregere momokani. ");
INSERT INTO hmo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Haba turia ibounai be golo dekenai idia koua, bona golo rini idia kwatua kau, inai reirei latadia do idia dogoatao totona. Unai reirei latadia danu be golo dekenai idia koua. ");
INSERT INTO hmo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Koua dabua helagana danu idia karaia, Palai Dubu ena lalonai gauna. Inai dabua be mamoe huina dekenai idia karaia, iena kala be bulu, kakakaka momokani, bona kakakaka sisina. Bona kerubi aneru edia laulau be dabua ena latanai idia turia namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Du ibounai 4 be akasia audia dekena amo idia karaia, koua dabua taua dae totona. Inai du be golo dekenai idia koua. Siliva maua 4 edia matudia lalonai du idia haginia. Kimai haida be golo dekenai idia karaia, bona du edia latanai kimai idia kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Palai Dubu ena iduara dekenai koua dabua idia karaia. Inai koua dabua ena latanai, toana namona herahera idia turia namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Koua dabua dogoatao totona idia ese akasia au du ibounai 5 idia haginia, mai edia golo kimai. Du edia kwarana be golo dekenai idia koua, du idia dogoatao ba danu be golo dekenai idia koua. Bona idia lalonai du do idia gini totona maua 5, be auri laboralabora dekena amo idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalele ese akasia au dekena amo Taravatu Maua ia karaia. Maua ena lata be 110 sentamita, ena lababa be 66 sentamita, bona ena ataiai be 66 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Maua ena lalona bona ena murimuri kahana ibounai be golo namona momokani dekenai ia koua, bona Maua ena hetoana be golo dekenai ia hagegea, herahera toana bamona. ");
INSERT INTO hmo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Bona Besalele ese rini ibounai 4, golo dekena amo ia karaia, Maua do idia huaia totona. Inai rini 4 be Maua ena aena maragidia 4 dekenai ia kwatua auka. Rini rua be Maua kahana dekenai ia kwatua, ma rini rua be Maua kahana dekenai ia kwatua. ");
INSERT INTO hmo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Maua huaia audia rua danu akasia au dekenai danu ia karaia, bona inai au ruaosi be golo dekenai ia koua. ");
INSERT INTO hmo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Inai au ruaosi be rini lalonai ia toia vareai, Maua kahana kahana dekenai, Maua do idia huaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Maua ena koua gauna, kara dika gwauatao gabuna, danu golo namo herea momokani dekena amo ia karaia. Iena lata be 110 sentamita, bona iena lababa be 66 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ma golo, hama dekenai ia botaia golo dekena amo kerubi aneru rua danu ia karaia. Inai kerubi be Maua ena koua gauna ena duduna duduna dekenai do umui koroa kau. ");
INSERT INTO hmo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Koua gauna ena duduna ta dekenai be kerubi aneru ta ia atoa, ma duduna ta dekenai be kerubi aneru ma ta ia atoa. Koua gauna bona kerubi ruaosi be golo tamona dekena amo ia karaia, idia be gau tamona, parara lasi. ");
INSERT INTO hmo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Inai kerubi aneru ese edia hanina dekena amo koua gauna idia hunia bamona, bona inai kerubi aneru ruaosi ese ta ta dekenai edia vairana idia itaia noho. ");
INSERT INTO hmo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Pata ta danu Besalele ese ia karaia, akasia au dekena amo ia karaia. Pata ena lata be 88 sentamita, bona iena lababa be 44 sentamita. Iena ataiai be 66 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Golo namo momokani dekena amo ia koua, bona pata ena hetoana be golo dekenai ia hagegea, herahera toana bamona. ");
INSERT INTO hmo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Pata ena isena be ia ese ia habadaia 8 sentamita dekenai, bona inai isena be golo dekenai ia koua. ");
INSERT INTO hmo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Pata huaia totona rini ibounai 4 ia karaia, bona pata ena kona 4, aena gabudia dekenai ia kwatua auka. ");
INSERT INTO hmo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Inai rini be pata ena isena kahirakahira ia kwatua auka. Inai rini lalonai pata huaia audia idia toia vareai. ");
INSERT INTO hmo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Pata huaia audia be akasia au dekenai ia karaia, bona golo dekenai ia koua. ");
INSERT INTO hmo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Pata dekenai atoa gaudia danu, mereki, kapusi, disi bona uro, uaina boubou totona gaudia be golo namo momokani dekena amo ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Lamepa dogoatao gauna ta danu be golo namo herea dekena amo ia karaia. Iena badina bona iena du be golo, hama dekenai idia botaia gauna, dekena amo ia karaia. Iena rigi mai edia herahera ibounai danu be golo tamona dekena amo ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Iena rigi be ibounai 6, kahana toi, kahana toi. ");
INSERT INTO hmo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Inai rigi ta ta ibounai be mai edia herahera toi, edia toana be alamono au huahua bamona. ");
INSERT INTO hmo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Lamepa ena du danu be mai ena herahera, herahera 4, edia toana be alamono au huahua bamona. ");
INSERT INTO hmo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Rigi rua rua dekenai danu be herahera matamata ta ta ia koroa, rigi rua, herahera ta, rigi rua, herahera ta, bona rigi rua, herahera ta, rigi edia henuna kahadia dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Inai rigi ibounai, bona edia herahera gaudia ibounai, be lamepa patana danu golo tamona dekena amo ia koroa. ");
INSERT INTO hmo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Lamepa ibounai 7 ia karaia, bona edia gabudia dekenai ia atoa. Lamepa hagoevaia gaudia bona momoru udaia mereki ibounai danu be golo namo herea dekena amo ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Inai lamepa dogoatao gauna, mai ena kohu ibounai totona ia gaukaralaia golo ena metau be ibounai 35 kilogaram. ");
INSERT INTO hmo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Pata helagana ta ia karaia, muramura mai bonana namona gabua gauna. Akasia audia dekena amo ia karaia. Pata ena lata be 45 sentamita, bona iena lababa danu be 45 sentamita, bona iena ataiai be 90 sentamita. Pata ena kona 4 dekenai be doa 4 ia koroa karaia. Inai doa be pata danu au tamona dekena amo ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Pata ena kopina be golo namo herea dekena amo ia koua, iena ataiai, iena kahana 4, bona iena doa 4 danu. Pata ena isena be golo herahera dekena amo ia ese ia koua hagegea. ");
INSERT INTO hmo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Rini rua be golo dekena amo ia karaia, bona pata ena isena henunai ia kwatua, ta pata ena kahana dekenai, ma ta pata ena kahana dekenai. Pata huaia totona au rua be inai rini rua lalonai ia toia vareai. ");
INSERT INTO hmo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Pata huaia audia rua be akasia audia dekena amo ia karaia, bona golo dekena amo inai au ia koua. ");
INSERT INTO hmo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Bona ia ese dehoro helagana ia karaia, Dirava dekenai idia helaga taudia edia kwarana dekenai idia bubua dehoro be unai. Ma ia ese mai bonana namona muramura pauda, idia gabua gauna, ia mikisi namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Besalele, mai ena gaukara taudia ese akasia audia dekena amo boubou patana ta, boubou gabua totona gauna idia karaia. Iena lata be mita rua, 20 sentamita, iena lababa be mita rua, 20 sentamita, bona iena ataiai be mita ta 30 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Boubou patana ena latanai doa 4 idia koroa karaia, ena kona 4 dekenai. Inai doa be pata danu au tamona dekena amo idia karaia. Boubou patana ena kopina ibounai be auri laboralabora dekena amo idia koua momokani. ");
INSERT INTO hmo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Idia ese boubou patana ena kohu ibounai, lahi ena kahu udaia uro, bona sipeidi maragidia, bona disi, bona foka bona lahi huaia auri kapusi idia karaia. Inai kohu ibounai be auri laboralabora dekena amo idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Auri laboralabora dekena amo lahi au rakuraku gabua patana ta, mai ena matuna momo, reke bamona gauna idia karaia. Inai reke bamona patana be henuna kahana, boubou patana ena aena 4 dekenai idia kwatua auka, aena edia huana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Inai reke bamona patana ena kona 4 dekenai auri laboralabora rini 4 idia kwatua auka. ");
INSERT INTO hmo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Akasia audia dekena amo boubou patana huaia audia idia karaia, bona auri laboralabora dekena amo idia koua. ");
INSERT INTO hmo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Bona inai audia be rini, pata ena kahana kahana idia noho gaudia, lalonai idia toia vareai, pata do idia huaia totona. Inai boubou patana be maua bamona idia karaia, reirei dekena amo idia koua, to ena lalona kahanai reirei o au be lasi. ");
INSERT INTO hmo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Vadaeni Palai Dubu ena iduara dekenai hesiai gaukara idia karaia hahine taudia ese auri laboralabora be Besalele dekenai idia henia. Inai auri laboralabora be edia vairana itaia totona hevarivari gaudia. Gaukara taudia ese inai auri laboralabora idia abia, bona disi badana ta, huria totona gauna, idia karaia. Ma pata ta, disi ia latanai atoa gauna, be auri laboralabora dekena amo danu idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Palai Dubu koua hagegea totona dabua badana, be dabua namodia dekena amo idia karaia. Diho kahana dekenai koua dabua edia lata be 44 mita. ");
INSERT INTO hmo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Auri laboralabora du ibounai 20 ese inai diho kahana koua dabua idia dogoatao. Inai du be auri laboralabora maua 20 lalonai idia haginia. Du edia latanai siliva dekenai karaia ba be idia kwatua kau, bona inai siliva ba dekenai koua dabua taua dae totona siliva kimai idia kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Mirigini kahana koua dabua danu be diho kahana gauna hegeregerena idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Dina ia diho kahana ena koua dabua, ena lata 22 mita idia karaia. Du ibounai 10, mai edia auri laboralabora maua 10 danu idia karaia. Du edia latanai siliva ba idia kwatua kau, bona inai siliva ba dekenai siliva kimai idia kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Dina ia daekau kahanai danu koua dabua ena lata be 22 mita. Inai kahana koua dabua lalonai be iduara ia noho. ");
INSERT INTO hmo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Iduara ena kahana ta dekenai du toi mai lalonai idia gini maua idia atoa, bona inai du dekenai koua dabua, ena lata 6 mita 60 sentamita idia taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ma iduara ena kahana dekenai du ma toi mai edia maua idia atoa, bona idia dekenai koua dabua, ena lata 6 mita 60 sentamita idia taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Inai koua dabua ibounai be dabua goadadia bona namodia sibona dekena amo idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Koua hagegea koua dabua badana ena du ibounai idia gini lalonai maua be auri laboralabora dekena amo karaia gaudia, bona kimai, ba, bona du edia kwarana, be siliva dekena amo idia koua. Palai Dubu ia koua hagegea koua dabua badana ena du ibounai, be siliva ba, toadia namo gaudia dekena amo idia kapaia hagegea. ");
INSERT INTO hmo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Iduara dekenai ia noho koua dabua be dabua namo herea dekena namo idia karaia. Inai dabua danu be mamoe huina amo idia hatua, bona ena kala be bulu, kakakaka sisina, bona kakakaka momokani. Herahera danu ia latanai idia turia namonamo. Inai iduara ena koua dabua ena lata be 9 mita, bona iena ataiai be mita rua, Palai Dubu idia hagegea koua dabua hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Inai iduara ena koua dabua be du 4, mai edia maua 4, edia latanai idia taua dae. Inai du edia kwarana, edia kimai, bona edia ba be siliva dekena amo idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Palai Dubu ena varo edia ikoko, Palai Dubu ia hagegea koua dabua ena varo ikoko ibounai danu, be auri laboralabora dekena amo idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Gaukara taudia ese Lohiabada ena Palai Dubu karaia totona golo, bona siliva, bona auri laboralabora edia metau idia duahia. Inai Palai Dubu lalonai be nadi palaka rua, bona idia edia latanai, Dirava ena Taravatu 10, torea vadaeni gaudia, idia noho. Unai golo, siliva bona auri laboralabora edia bada bona metau be Mose ese ia oda dainai, Levi taudia ese buka dekenai idia torea. Inai Levi taudia be Itamara ena henunai idia gaukara. Itamara be Arona, hahelagaia tauna ena natuna. ");
INSERT INTO hmo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besalele be Uri ena natuna bona Huru ena tubuna, bona ia be Iuda iduhu tauna. Mose dekenai Lohiabada ia oda gaudia ibounai, be inai Besalele ese ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Besalele ena durua tauna, Oholiaba, Ahisamaka ena natuna, Dano iduhu tauna, be nadi bona auri dekenai revareva torea diba tauna. Ia be gaukara ena palani ia laloa diba tauna, bona ia ese dabua namodia bona edia herahera ia hatua diba. Ia ese danu mamoe huina ena kala bulu, kakakaka sisina, bona kakakaka momokani ia hatua diba. ");
INSERT INTO hmo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Golo ibounai, taunimanima ese Lohiabada dekenai idia henia, Palai Dubu totona gaudia edia metau be 1000 kilogaram, Helaga Gabuna ena sikele hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Siliva ibounai, Israela taudia edia ladana idia torea, idia henia, ena siliva ibounai edia metau be 3430 kilogram, Helaga Gabuna ena sikele hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Israela edia tatau, lagani 20 bona lagani 20 idia hanaia tatau ibounai edia momo be 603,550. Inai tatau ibounai ese siliva, ena davana 5 kina bamona, idia henia. ");
INSERT INTO hmo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Unai siliva ena metau 3400 kilogaram, be siliva maua ibounai 100 idia karaia totona. Unai siliva maua ibounai be Palai Dubu ena haba turia edia stadi henunai idia noho, bona Helaga Herea Gabuna ena koua dabua helagana ena du edia henunai danu. Inai maua ta ta edia siliva ena metau be 34 kilogaram. ");
INSERT INTO hmo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Idia do gaukaralaia lasi siliva ena metau be 30 kilogaram. Inai siliva 30 kilogaram dekena amo Besalele ese siliva ba, kimai bona du edia kwarana ia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Auri laboralabora, Lohiabada dekenai idia henia gaudia edia metau be 2425 kilogaram. ");
INSERT INTO hmo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Inai auri laboralabora dekena amo Besalele ese Lohiabada ena Palai Dubu ena iduara ena du idia haginia lalonai maua ia karaia totona, bona boubou patana, mai ena reke bamona patana, bona boubou patana ena kohu totona. ");
INSERT INTO hmo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Ma inai auri laboralabora danu be koua hagegea dabua badana ena du edia henuna maua, bona edia varo edia ikoko, bona Palai Dubu ena varo edia ikoko karaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Idia ese dabua namodia momokani, edia kala bulu, kakakaka sisina, bona kakakaka momokani idia karaia. Inai dabua namodia be hahelagaia taudia edia, bona Helaga Gabuna dekenai idia gaukara neganai, inai dabua idia atoa. Arona ena dabua helagadia danu idia karaia. Edia gaukara be Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Epodi dabua danu be dabua namo herea dekena amo idia karaia, ena kala be bulu, kakakaka sisina, bona kakakaka momokani. Golo varona danu be dabua danu idia hatua hebou. ");
INSERT INTO hmo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Idia ese golo be hama dekenai idia botaia palaka, pepa bamona. Vadaeni idia utua maragi, varo maragina bamona. Bona unai dabua bulu, kakakaka sisina, bona kakakaka momokani, danu be inai golo varo dekenai idia turia hebou. ");
INSERT INTO hmo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Epodi ena ataiai kona ruaosi dekenai be varo rua idia turia kau, tau ena pagana dekenai do idia kwatua totona. ");
INSERT INTO hmo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Gaba gauna danu be epodi idia karaia gaudia hegeregerena idia karaia, golo varo, bona dabua namona, ena kala bulu, kakakaka sisina, bona kakakaka momokani. Inai idia hatua karaia, be Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Onuku nadi rua idia abia hegaegae, bona golo dekena amo inai nadi dogoatao gabudia idia karaia. Inai nadi ruaosi dekenai be Iakobo ena natuna tau 12 edia ladana idia torea namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Inai nadi be epodi ena varo ruaosi, pagana gaudia dekenai idia kwatua kau. Vadaeni inai nadi ese Israela ena iduhu 12 edia toana idia lao, Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Kemena dabua maragina be epodi idia karaia dabua hegeregerena dekena amo idia karaia, bona ena herahera be epodi ena turia herahera hegeregerena danu. ");
INSERT INTO hmo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kemena dabua ena lata be 44 sentamita bona iena lababa be 22 sentamita. Dabua ena huana momokani dekenai idia lokua, vadaeni ia be poketi badana ta hegeregerena, iena lata be 22 sentamita, iena lababa danu be 22 sentamita. ");
INSERT INTO hmo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Dabua ena latanai davana bada herea nadi ibounai 12, laini 4 dekenai idia turia kau. Laini ginigunana dekenai be sadio, topasio bona barekete nadi idia turia kau. ");
INSERT INTO hmo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Laini iharuana dekenai be samaragi, sapairo bona vasiga nadi idia turia kau. ");
INSERT INTO hmo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Laini ihatoina dekenai be huakinto, akate, bona ametuso nadi idia turia kau. ");
INSERT INTO hmo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Laini namba 4 dekenai be berulio, onuku, bona iasipa nadi idia turia kau. Inai nadi ibounai be golo, mai herahera toana danu dekena amo idia hagegea namonamo. ");
INSERT INTO hmo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Inai nadi 12 ta ta ibounai dekenai Iakobo ena natuna tau ta ta edia ladana idia torea, Israela ena iduhu ta ta ibounai edia toana be unai. ");
INSERT INTO hmo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kemena dabua totona golo namo herea idia mogea namonamo, bona seini rua, varo bamona, idia karaia, dabua be kemena dekenai do idia kwatua totona. ");
INSERT INTO hmo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Golo herahera, rini dogoatao totona gaudia rua, bona golo rini rua idia karaia, bona kemena dabua ena ataiai kona ruaosi dekenai idia kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Inai golo seini ruaosi be inai golo rini ruaosi dekenai idia kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Inai golo seini edia duduna be epodi ena rini dogoatao golo herahera gaudia ruaosi dekenai idia kwatua. Inai dekena amo kemena dabua be epodi ena paga varo ruaosi dekenai idia kwatua. ");
INSERT INTO hmo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ma rini rua golo dekena amo idia karaia, bona kemena dabua ena henuna kona ruaosi dekenai idia kwatua, kemena dabua ena murina kahanai, bona epodi kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Bona rini rua golo dekena amo ma idia karaia, bona epodi vairanai, ena paga dogoatao gaudia dekenai idia turia kau, gaba gauna kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Vadaeni Lohiabada ese Mose ia hamaoroa hegeregerena, kemena dabua ena rini ruaosi, bona epodi ena rini ruaosi idia kwatua hebou, bulu varona dekena amo. Inai dala dekenai kemena dabua be epodi ena gaba gauna dekenai ia kamokau, idia marere kava lasi. ");
INSERT INTO hmo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Epodi ena henunai atoa dabua latana ta, be dabua ena kala bulu dekena amo idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Dabua ena huanai be matuna idia karaia, kwarana atoa gabuna be unai. Bona matuna ena isena danu idia turia namonamo, do ia darea garina. ");
INSERT INTO hmo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Inai dabua latana ena henuna isena dekenai herahera namodia idia turia, edia toana be apolo huahua bona edia kala be bulu, kakakaka sisina, bona kakakaka momokani. Inai apolo edia huanai be golo gaba maragidia idia turia kau. ");
INSERT INTO hmo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Golo gaba ta, apolo huahua ta, golo gaba ta, apolo huahua ta, unai bamona idia turia karaia, ela bona dabua latana ena isena herahera idia karaia haorea. ");
INSERT INTO hmo_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Arona ese iena gaukara helagana ia karaia negadia ibounai inai dabua latana do ia kwatua. Inai dabua latana idia karaia be Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ma Arona mai ena natuna tau totona sioti idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Edia kwara kumia gaudia, bona kwara gaudia, bona edia piripou danu be dabua auka namo herea dekena amo idia karaia. ");
INSERT INTO hmo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Edia gaba gaudia danu be dabua auka namo herea, ena kala bulu, kakakaka sisina, bona kakakaka momokani, mai edia herahera, idia karaia, Lohiabada ese Mose ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Vadaeni medolo, helaga momokani ena toana gauna, be golo namo herea momokani dekena amo idia karaia, bona medolo dekenai hereva inai bamona idia torea: “Helaga, Lohiabada ena”. ");
INSERT INTO hmo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Varo, ena kala bulu idia abia, bona kwarana kumia dabua ena vairana dekenai unai medalo idia kwatua kau, Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Palai Dubu, Lohiabada ia noho ena toana gabuna haginia gaukara be ia ore momokani. Israela taudia ese gaukara ibounai idia karaia vadaeni, Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Israela taudia ese Palai Dubu, mai ena kohu ibounai idia mailaia, gaudia be inai: Iena kimai, iena haba turia, iena reirei latadia, iena du, bona du do idia gini lalonai maua gaudia. ");
INSERT INTO hmo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Palai Dubu ena guhi rua, ta be mamoe tau ena kopina, ena kala be kakakaka, bona ta be davara ena boromakau, rui, ena kopina dekena amo. Inai be ataiai momokani ena guhi. Ma Taravatu Maua ia hunia koua dabua helagana, bona inai gaudia danu idia mailaia: ");
INSERT INTO hmo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Taravatu Maua, nadi palaka rua ia koua Maua. Maua idia huaia totona audia ruaosi, bona Maua ena koua gauna. ");
INSERT INTO hmo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Pata helagana, bona pata dekenai atoa gaudia, bona Dirava dekenai henia beredi helagana. ");
INSERT INTO hmo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Lamepa dogoatao gauna, golo namo herea momokani dekena amo karaia gauna, iena lamepa, bona iena kohu ibounai, bona lamepa edia oela. ");
INSERT INTO hmo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Muramura patana, golo gauna, bona taunimanima hahelagaia totona dehoro helagana, bona bonana namona muramura ena pauda, bona Palai Dubu ena iduara ena koua dabua. ");
INSERT INTO hmo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Boubou patana, auri laboralabora gauna, mai ena reke bamona patana, auri laboralabora dekenai karaia gauna, mai ena huaia totona audia, bona mai ena kohu ibounai. Huria totona disi badana, mai ena patana. ");
INSERT INTO hmo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Koua dabua, Palai Dubu ia hagegea gauna, bona inai koua dabua ena du, mai du idia gini lalonai maua danu. Inai koua dabua ena iduara ena koua dabua, mai ena varo danu, Palai Dubu ena varo edia ikoko, bona Palai Dubu lalonai idia gaukaralaia kohu ibounai. ");
INSERT INTO hmo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Bona hahelagaia taudia edia dabua namo herea, Helaga Gabuna dekenai idia gaukara neganai idia atoa dabua danu, idia mailaia. Inai be dabua helagadia, Arona bona iena natuna tau edia. ");
INSERT INTO hmo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Israela taudia ese gaukara ibounai idia karaia vadaeni, Lohiabada ese Mose ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mose ese inai gaudia ibounai ia itaia namonamo, bona ia diba gau ibounai idia karaia vadaeni namo herea, Lohiabada ese Mose ia oda henia hegeregerena. Vadaeni Mose ese unai Israela taudia ia hanamodia. ");
INSERT INTO hmo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Kamonai, hua ginigunana ena dina ginigunana dekenai Palai Dubu, Lohiabada ia noho ena toana, do umui haginia. ");
INSERT INTO hmo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Palai Dubu lalonai be Taravatu Maua, bona Maua ena lalonai be Dirava ena Taravatu 10 idia noho. Maua hunia totona koua dabua helagana be Maua ena vairanai do umui taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","“Pata helagana be Palai Dubu lalonai do umui atoa. Pata ena latanai be iena kohu do umui atoa. Lamepa dogoatao gauna danu do umui mailaia vareai, bona lamepa be ena latanai do umui atodia. ");
INSERT INTO hmo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Muramura patana, golo gauna, mai bonana namona muramura pauda gabua ena patana be Taravatu Maua kahirakahira do umui atoa, to koua dabua helagana ena murimurinai. Bona Palai Dubu ena iduara dekenai koua dabua do umui taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Palai Dubu ena vairana dekenai be boubou patana do umui atoa, idia gabua boubou gaudia totona patana be unai. ");
INSERT INTO hmo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Huria totona disi be Palai Dubu bona boubou patana edia huanai do umui atoa, bona disi be ranu dekenai do umui hahonua. ");
INSERT INTO hmo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","“Palai Dubu ia hagegea koua dabua do umui taua dae, bona iena iduara dekenai koua dabua ta danu do umui taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ Unai neganai Palai Dubu, mai ena kohu ibounai be dehoro helagana dekenai do umui dahua, do idia helaga totona. ");
INSERT INTO hmo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Inai murinai boubou patana be dehoro helagana dekena amo do umui dahua, vadaeni ia be helaga momokani. ");
INSERT INTO hmo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Inai dala dekenai danu be huria totona disi, mai ena patana do umui hahelagaia. ");
INSERT INTO hmo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Arona bona iena natuna tau be Palai Dubu ena iduara dekenai do oi hakaudia mai, bona oi ese idia do oi hadigua. ");
INSERT INTO hmo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Hahelagaia tauna ena dabua be Arona dekenai do oi atoa, bona dehoro helagana be iena kwarana dekenai do oi bubua. Inai bamona do oi hahelagaia, ia ese lauegu hahelagaia tauna ena gaukara do ia karaia totona. ");
INSERT INTO hmo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","“Arona ena natuna tau danu do oi hakaua mai, bona idia dekenai sioti do oi atoa. ");
INSERT INTO hmo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Unai murinai, dehoro helagana edia kwarana dekenai do oi bubua, edia tamana dekenai oi bubua bamona. Inai kara dainai idia ese egu hahelagaia taudia edia gaukara do idia karaia diba. Inai dehoro bubua kara ese do ia hahelagadia, vadaeni hahelagaia taudia edia gaukara be idia, bona edia tubudia taudia do idia karaia noho ela bona hanaihanai.” ");
INSERT INTO hmo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mose ese gau ibounai ia karaia namonamo, Lohiabada ese ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Lagani iharuana, hua ginigunana, dina ginigunana, Aigupito idia rakatania murinai be Palai Dubu, Lohiabada ia noho gabuna ena toana, idia haginia. ");
INSERT INTO hmo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mose ese unai Palai Dubu ia haginia neganai, maua ta ta be tano dekenai ia atodia. Maua ibounai lalonai, haba turia ia haginidia, bona koua dabua edia du ibounai danu ia haginidia. Ma haba hagoadaia reirei danu ia kwatua kau. ");
INSERT INTO hmo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Vadaeni Dubu be palai dekena amo ia koua hagegea, bona guhi koua dabua toi dekena amo, ia ese guhi ia koua, Lohiabada ese ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Bona Taravatu nadidia ruaosi be Taravatu Maua dekenai ia udaia. Ma Taravatu Maua huaia totona au ruaosi be edia rini dekenai ia toia vareai, bona koua gauna dekena amo Taravatu Maua ia koua. Unai Maua ena koua gauna be kara dika gwauatao gabuna. ");
INSERT INTO hmo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Unai murinai Taravatu Maua be Palai Dubu lalonai ia atoa, bona koua dabua helagana ia taua dae, Taravatu Maua ia hunia totona, Lohiabada ese ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Pata helagana be Palai Dubu lalonai ia atoa, Dubu ena mirigini kahana dekenai, koua dabua helagana ena murimurina dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Bona paraoa ia abia, pata helagana ena latanai ia atoa namonamo, Lohiabada ena vairana dekenai, Lohiabada ese ia hadibaia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Vadaeni lamepa dogoatao gauna be Palai Dubu lalonai ia atoa, pata helagana ena vairana kahana dekenai, Dubu ena diho kahana dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Bona Mose ese lamepa ia gabua Lohiabada ena vairana dekenai, Lohiabada ese ia hadibaia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Vadaeni muramura patana, golo gauna, be Palai Dubu lalonai ia atoa, Taravatu Maua kahirakahira, to koua dabua helagana ena murimurina dekenai. ");
INSERT INTO hmo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Bona unai pata ena latanai be muramura mai bonana namona ia gabua, Lohiabada ese ia hadibaia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Unai murinai Palai Dubu ena iduara dekenai, koua dabua ia taua dae. ");
INSERT INTO hmo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Vadaeni Mose ese Palai Dubu ena iduara ena vairana dekenai boubou patana ia atoa. Unai boubou patana ena latanai Mose ese boubou gaudia, lahi ese ia araia ore gaudia, bona paraoa gaudia ia atoa, Lohiabada ese ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Palai Dubu bona boubou patana edia huanai Mose ese hurihuri disi ia atoa, bona ranu dekenai ia hahonua. ");
INSERT INTO hmo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Unai ranu be Mose bona Arona, bona Arona ena natuna ese edia imana bona aena idia huria ranuna. ");
INSERT INTO hmo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Nega ibounai Palai Dubu dekenai idia raka vareai, o boubou patana dekenai idia raka lao neganai, unai bamona idia digu guna, Lohiabada ese Mose ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Vadaeni Mose ese Dubu ia hagegea koua dabua badana ia taua dae, vadaeni unai koua dabua badana dekena amo, Palai Dubu bona boubou patana danu ia hagegea. Bona koua dabua badana ena iduara dekenai koua dabua ta ia taua dae. Mose ena gaukara ibounai be unai bamona ia ese ia karaia haorea. ");
INSERT INTO hmo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Vadaeni ori ese Palai Dubu ia koua hagegea, bona Lohiabada ena diaridiari ese Dubu ia hahonua. ");
INSERT INTO hmo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Unai dainai Mose be dala lasi Palai Dubu do ia raka vareai, badina be ori ese ia koua, bona Lohiabada ena diaridiari ese Dubu ia hahonua. ");
INSERT INTO hmo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Edia laolao ibounai lalonai Israela taudia edia kara be inai bamona: Bema ori ese Dubu ia rakatania neganai be idia toreisi, edia laolao ma idia raka lao. ");
INSERT INTO hmo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","To bema unai ori ese Dubu ia koua neganai, unai gabu idia rakatania lasi, ela bona ori ese Dubu ia rakatania. ");
INSERT INTO hmo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Badina be Israela taudia edia laolao ibounai lalonai, Lohiabada ena ori be dina lalonai Dubu ena ataiai dekenai ia noho. Bona hanuaboi ibounai lalonai, unai ori be mai ena lahi, Dubu ena ataiai dekenai ia noho. Dina lalonai, ori idia itaia, bona hanuaboi lalonai, lahi be ori dekenai idia itaia, Dubu ena ataiai dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Palai Dubu, Lohiabada ia noho ena toana dekena amo Lohiabada ese Mose ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Israela taudia do oi hamaoroa, oi gwau: Bema umui ta ese Lohiabada dekenai boubou vamu gauna ia mailaia neganai, ia ese iena boromakau orea edia huanai, o iena mamoe orea edia huanai dekena amo do ia abia.” ");
INSERT INTO hmo_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ma Mose ese Dirava ena hereva taunimanima ia hamaoroa, ia gwau, “Bema tau ta ena boubou, gabua ore gauna, be iena boromakau orea dekena amo do ia abia neganai, ia ese boromakau tau namona momokani, toto o bero lasi gauna do ia abia. Inai boromakau be Palai Dubu ena iduara dekenai do ia atoa, Lohiabada ese ia do ia abia dae totona. ");
INSERT INTO hmo_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","“Unai tau ese iena imana be boromakau ena kwarana dekenai do ia atoa, bona Lohiabada ese inai boubou do ia abia dae, unai tau ena kara dika gwauatao totona. ");
INSERT INTO hmo_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Unai tau ese unai gabu dekenai boromakau do ia alaia mase, bona Arona ena natuna tau ese boromakau ena rarana be Lohiabada dekenai do idia henia, bona boubou patana ena kahana 4 dekenai unai rara do idia negea. Unai boubou patana be Palai Dubu ena iduara kahirakahira. ");
INSERT INTO hmo_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Unai tau ese boromakau ena kopina do ia kokia, bona ena kahana ibounai do ia ivaia. ");
INSERT INTO hmo_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","“Hahelagaia taudia ese au rakuraku be boubou patana dekenai do idia atoa hegaegae, boubou do idia gabua totona. ");
INSERT INTO hmo_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Idia ese boromakau idia ivaia kahana ibounai, kwarana bona digara ibounai danu be au rakuraku edia latanai do idia atoa, boubou patana ena latanai. ");
INSERT INTO hmo_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Unai tau ese boromakau ena bogarau kahadia, bona boubou ena aena be ranu dekenai do ia huria, bona hahelagaia tauna ese inai boubou vamu ena kahana ibounai boubou patana dekenai do ia gabua ore. Inai vamu boubouna be mai ena bonana namona Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Bema tau ta ese iena mamoe ta o nanigosi ta boubou totona ia ura ia henia neganai, inai mamoe o nanigosi be do ia namo herea, toto o bero gauna lasi. ");
INSERT INTO hmo_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Unai tau ese unai boubou be boubou patana ena mirigini kahana dekenai do ia alaia mase. Bona hahelagaia taudia ese unai boubou ena rarana be boubou patana ena kahana 4 dekenai do idia negea. ");
INSERT INTO hmo_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","“Tau ese unai mamoe o nanigosi ia utua utua murinai, hahelagaia tauna ese ena kahana ibounai ia ivaia gaudia be lahi ena latanai do ia atoa, kwarana bona digara danu. ");
INSERT INTO hmo_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Tau ese boubou ena bogarau kahadia, bona boubou ena aena be ranu dekenai do ia huria. Vadaeni hahelagaia tauna ese boubou Lohiabada dekenai do ia henia, bona boubou ena kahana ibounai boubou patana dekenai do ia gabua ore. Inai vamu boubouna be mai ena bonana namona Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Bema tau ta ese manu ta gabua boubou totona ia ura ia henia neganai, pune o manu ta ladana kerea do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Hahelagaia tauna ese boubou patana dekenai manu do ia mailaia, iena aiona do ia mogea, bona manu ena kwarana be boubou patana dekenai do ia gabua. Manu ena rarana be boubou patana ena kahana dekenai do ia bubua. ");
INSERT INTO hmo_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Manu ena bogarauna, mai ena momoru do ia kokia, bona boubou patana ena dina daekau kahanai, lahi kahu atoa gabuna dekenai do ia negea. ");
INSERT INTO hmo_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Hahelagaia tauna ese manu ena hanina be iena imana dekenai do ia darea parara, do ia ivaia lasi. Vadaeni manu ena tauanina mai hanina danu boubou patana latanai do ia gabua ore. Inai vamu boubouna be mai ena bonana namona Lohiabada dekenai.” ");
INSERT INTO hmo_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ma Dirava ese Mose ia oda henia, Israela taudia dekenai do ia gwau: “Bema tau ta ese paraoa boubouna Lohiabada dekenai ia henia gwauraia neganai, ia be paraoa namo herea momokani do ia mailaia. Ia ese paraoa ena latanai olive dehoro do ia bubua, bonana namona muramura ena pauda danu paraoa dekenai do ia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Vadaeni Arona ena natuna tau dekenai do ia mailaia. Unai neganai unai hahelagaia tauna ta ese iena imana dekenai paraoa mai ena olive dehoro sisina, bona bonana namona muramura ena pauda ibounai do ia abia, bona unai gau toi be boubou patana ena latanai do ia gabua ore. Unai be Lohiabada dekenai henia ena toana. Unai boubou idia gabua ena bonana be namo herea Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","“To paraoa ena orena, idia gabua lasi gaudia be Arona mai ena natuna tau edia, do idia ania. Ia be helaga momokani, badina be Lohiabada dekenai henia boubou dekena amo idia abia. ");
INSERT INTO hmo_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Bema boubou gauna be beredi, amu dekenai gabua gauna, mai hatubua gauna lasi dekenai do umui gabua. Keke, paraoa bona olive dehoro idia mikisi dekena amo karaia gauna, o bisikesi, olive dehoro dekena amo idia dahua gaudia umui henia diba. ");
INSERT INTO hmo_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“Bema emui paraoa boubouna be auri palaka ena latanai gabua gauna neganai, ia be paraoa namona bona olive dehoro umui mikisi dekena amo umui karaia gauna. To mai hatubua muramura gauna be lasi. ");
INSERT INTO hmo_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Do umui makohia maragimaragi, bona ena latanai olive dehoro do umui bubua. Inai be paraoa ena boubou ta. ");
INSERT INTO hmo_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“Bema emui paraoa boubouna be paraipani dekenai gabua gauna neganai, paraoa namona bona olive dehoro umui mikisi dekena amo do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Inai paraoa bouboudia, Lohiabada dekenai umui henia gaudia be hahelagaia tauna dekenai do umui mailaia. Ia ese boubou patana dekenai do ia abia lao. ");
INSERT INTO hmo_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Hahelagaia tauna ese inai boubou ena kahana do ia abia, Lohiabada dekenai henia boubou ena toana, bona boubou patana dekenai do ia gabua. Inai aniani ia gabua ena bonana be namo herea Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Unai boubou ena orena, idia gabua lasi gauna, be hahelagaia taudia edia. Ia be helaga momokani, badina be Lohiabada dekenai henia boubou dekena amo idia abia. ");
INSERT INTO hmo_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Paraoa boubou mai hatubua muramura danu be Lohiabada dekenai do umui mailaia lasi. Hatubua muramura o hani be boubou gauna danu do umui atoa lasi. Lohiabada ena boubou patana dekenai inai bamona gaudia do umui gabua lasi. ");
INSERT INTO hmo_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Lagani ta ta boubouna, emui uma dekenai umui hatubua aniani ena boubou danu, be hatubua muramura bona hani Lohiabada dekenai umui mailaia diba. To unai bamona boubou be boubou patana dekenai umui gabua diba lasi. ");
INSERT INTO hmo_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","“Emui paraoa bouboudia ibounai edia latanai damena do umui atoa, badina damena be umui bona Dirava huanai emui gwauhamata taravatuna ena toana. Emui boubou gaudia ibounai edia latanai damena do umui atoa. ");
INSERT INTO hmo_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Bema emui uma dekenai umui hatubua uiti, umui utua ginigunana gauna Lohiabada dekenai umui henia gwauraia neganai, uiti edia kwarana anina namona momokani be amu dekenai do umui gabua guna, bona nadi uili dekenai do umui moia, vadaeni ia makohia maragi-maragi. ");
INSERT INTO hmo_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Inai paraoa ena latanai olive dehoro bona bonana namona muramura ena pauda do umui atoa. Inai be paraoa ena boubou. ");
INSERT INTO hmo_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Hahelagaia tauna ese unai paraoa bona olive dehoro ena kahana, Lohiabada dekenai henia ena toana, be do ia gabua, bonana namona muramura pauda ibounai danu do ia gabua. Lahi dekenai gabua boubou, Lohiabada ena, be unai.” ");
INSERT INTO hmo_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ma Dirava ese Mose ia oda henia, Israela taudia dekenai do ia gwau: “Bema tau ta ia ura iena boromakau ta do ia henia, Lohiabada danu maino do ia karaia totona, ia ese boromakau tau o boromakau hahine, bero o toto lasi gauna sibona do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Unai tau ese iena imana be boromakau ena kwarana dekenai do ia atoa, bona do ia alaia mase. Ia alaia mase gabuna be Palai Dubu ena iduara badibadinai. Vadaeni Arona ena natuna tau ese boromakau ena rarana be boubou patana ena kahana 4 dekenai do idia negea. ");
INSERT INTO hmo_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Bona idia ese boromakau ena tauanina kahadia be maino karaia boubouna Lohiabada dekenai do idia henia. Unai tauanina ena kahadia be inai: Boga bona bogarau ena digara ibounai, ");
INSERT INTO hmo_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","nadinadi, mai edia digara ibounai, bona asena ena vamu namona. ");
INSERT INTO hmo_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Inai vamu ibounai be hahelagaia taudia ese boubou patana ena lahi dekenai do idia gabua, idia gabua ore boubouna edia latanai. Inai vamu idia gabua neganai, ena bonana be namo herea Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Bema tau ta ia ura iena mamoe o nanigosi do ia henia, Lohiabada danu maino do ia karaia totona, ia ese mamoe o nanigosi tau o hahine, bero o toto lasi gauna sibona do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Bema tau ta ese mamoe ia henia gwauraia, inai boubou be Lohiabada ena vairanai do ia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Unai tau ese iena imana be mamoe ena kwarana latanai do ia atoa, bona do ia alaia mase Palai Dubu ena vairanai. Hahelagaia taudia ese mamoe ena rarana be boubou patana ena kahana 4 dekenai do idia negea. ");
INSERT INTO hmo_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Bona idia ese mamoe ena tauanina kahana haida Lohiabada dekenai aniani boubouna totona do idia henia, kahadia be inai: Mamoe ena digara, iena iuna badana ela bona doruna ena turia, bona bogarauna ena digara ibounai, ");
INSERT INTO hmo_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","nadinadi ibounai, mai edia digara danu, bona asena ena kahana badana danu. ");
INSERT INTO hmo_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Hahelagaia tauna ese inai vamu ibounai do ia gabua ore. Inai be aniani boubouna, Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Bema tau ta ia ura nanigosi do ia henia, inai boubou be Lohiabada ena vairanai do ia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Unai tau ese iena imana be nanigosi ena kwarana latanai do ia atoa, bona do ia alaia mase Palai Dubu ena vairanai. Hahelagaia taudia ese nanigosi ena rarana be boubou patana ena kahana ibounai dekenai do idia negea. ");
INSERT INTO hmo_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Bona idia ese nanigosi ena tauanina kahana haida Lohiabada dekenai aniani boubouna totona do idia henia, kahadia be inai: Bogana bona bogarauna ena digara ibounai, ");
INSERT INTO hmo_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","nadinadi ibounai mai edia digara, bona asena ena kahana badana danu. ");
INSERT INTO hmo_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Hahelagaia tauna ese inai vamu ibounai do ia gabua ore. Inai be aniani boubouna, bona ena bonana be namo herea Lohiabada dekenai. Digara ibounai be Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Israela taudia ese digara o rara do idia ania lasi momokani. Inai be noho hanaihanai taravatu, bona Israela taudia ese do idia badinaia edia noho gabudia ibounai dekenai.” ");
INSERT INTO hmo_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Israela taudia inai bamona do oi hamaoroa: Bema tau ta ia diba lasi dainai, ia kara dika kava, o Lohiabada ena taravatu ta ia utua kava, ia diba lasi dainai, inai bamona do ia karaia: ");
INSERT INTO hmo_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Bema Hahelagaia Tauna Badana ese ia kara dika, bona iena dika ese iena orea taudia edia latanai kerere ia atoa neganai, ia ese boromakau natuna tau, bero o toto lasi gauna be Lohiabada dekenai do ia henia. Iena kara dika gwauatao totona boubouna be unai. ");
INSERT INTO hmo_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Iena boromakau tau be Palai Dubu, Lohiabada ena vairana dekenai do ia mailaia, iena imana be boromakau ena kwarana dekenai do ia atoa, bona Palai Dubu ena iduara ena badibadinai do ia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Unai neganai Hahelagaia Tauna Badana ese boromakau ena rarana haida be Palai Dubu lalonai do ia abia vareai. ");
INSERT INTO hmo_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Iena imana kwakikwakina ta be rara lalonai do ia atoa, bona nega 7, ia ese Helaga Herea Gabuna ia hunia koua dabua helagana ena vairanai, unai rara do ia negea. Bona Lohiabada ese inai kara do ia itaia. ");
INSERT INTO hmo_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","“Vadaeni Hahelagaia Tauna Badana ese unai rara haida be muramura patana ena doana 4 dekenai do ia dahua, Lohiabada ena Palai Dubu lalonai. Rara orena, ia iusilaia lasi gauna be Hahelagaia Tauna Badana ese boubou patana ena badinai do ia bubua, Palai Dubu ena iduara ena badibadinai. ");
INSERT INTO hmo_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Boromakau dekena amo digara ibounai do ia abia, bogana lalonai ia noho digarana ibounai. ");
INSERT INTO hmo_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Nadinadi, mai edia digara ibounai, bona asena ena kahana badana danu do ia abia. ");
INSERT INTO hmo_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","“Vadaeni Hahelagaia Tauna Badana ese inai digara ibounai do ia abia, bona boubou patana ena lahi dekenai do ia gabua ore, maino karaia boubouna ena digara idia gabua ore hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","“To boromakau ena kopina, ena hidiona, ena kwarana, ena aena, bona iena bogana, bona iena bogarauna mai ena kukuri be do ia haboua. ");
INSERT INTO hmo_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Bona kamepa ena murimurinai do ia huaia lao, goeva gabuna, boubou edia kahu idia negea gabuna dekenai. Unuseni au rakuraku ena lahi dekenai do ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Bema Israela orea ibounai idia kara dika, bona Lohiabada ena taravatu ta idia utua kava, idia diba lasi dainai, ");
INSERT INTO hmo_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","unai edia kerere ia hedinarai neganai, Israela taudia ese boromakau natuna tau be boubou gauna totona do idia mailaia. Lohiabada ena Palai Dubu dekenai do idia mailaia. ");
INSERT INTO hmo_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Orea ena gunalaia taudia ese edia imadia be boromakau ena kwarana dekenai do idia atoa, bona unai gabu dekenai boromakau do idia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Hahelagaia Tauna Badana ese boromakau ena rarana haida Palai Dubu lalonai do ia abia vareai. ");
INSERT INTO hmo_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Iena imana kwakikwakina be rara lalonai do ia atoa, bona nega 7, Helaga Herea Gabuna ia hunia koua dabua helagana ena vairanai, unai rara do ia negea. Lohiabada ese unai kara do ia itaia. ");
INSERT INTO hmo_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","“Unai rara haida danu be Palai Dubu ena muramura patana ena doana 4 dekenai do ia dahua, bona rara orena be boubou patana, boubou idia gabua gabuna, ena badinai do ia bubua. Unai gabu be Palai Dubu ena iduara ena badibadinai. ");
INSERT INTO hmo_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Unai murinai boromakau ena digarana ibounai be boubou patana ena latanai do ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Unai kara dika gwauatao boubouna totona ena boromakau dekenai ia karaia kara hegeregerena, ia ese inai hari boromakau danu do ia karaia. Inai bamona dala dekenai Israela orea taudia edia kara dika dainai, boubou do ia karaia, bona edia kara dika be Lohiabada ese do ia gwauatao. ");
INSERT INTO hmo_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","“Unai murinai Hahelagaia Tauna Badana ese boromakau do ia abia lao kamepa ena murimurinai, bona do ia gabua ore, ia sibona ena kara dika dainai ia henia boromakauna ia gabua hegeregerena. Israela taudia edia kara dika gwauatao totona ena boubou be unai.” ");
INSERT INTO hmo_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ma Lohiabada ese Mose ia hamaoroa, ia gwau, “Israela taudia dekenai do oi hadibaia, oi gwau: Bema gunalaia tauna ta ese ia kara dika, bona Lohiabada ena taravatu ta ia utua kava, ia diba lasi dainai, ");
INSERT INTO hmo_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","unai iena kerere be ia dekenai idia hedinarai henia neganai, ia ese nanigosi tau do ia mailaia, bero o toto lasi gauna. ");
INSERT INTO hmo_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Gunalaia tauna ese iena imana be nanigosi ena kwarana dekenai do ia atoa, bona boubou patana ena mirigini kahanai nanigosi do ia alaia mase. Unai gabu dekenai idia gabua ore gwauraia vamudia idia alaia mase noho. Gunalaia tauna ena kara dika gwauatao totona boubouna be unai. ");
INSERT INTO hmo_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","“Hahelagaia tauna ese iena imana kwakikwakina be nanigosi ena rarana lalonai do ia atoa, bona boubou patana ena doana 4 dekenai inai rara do ia dahua. Rara orena, ia iusilaia lasi gauna, be boubou patana ena badinai do ia bubua. ");
INSERT INTO hmo_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Unai neganai nanigosi ena digarana ibounai boubou patana ena latanai do ia gabua ore, maino karaia boubouna totona boromakau ena digarana ia gabua ore hegeregerena. Inai bamona dala dekenai hahelagaia tauna ese gunalaia tauna ena kara dika davana do ia karaia, bona unai tau ena kara dika be Lohiabada ese do ia gwauatao. ");
INSERT INTO hmo_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Bema Israela ena orea tauna ta ese ia kara dika, bona Lohiabada ena taravatu ta ia utua kava, ia diba lasi dainai, ");
INSERT INTO hmo_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","unai iena kerere idia hedinaraia neganai, unai tau ese nani ta do ia mailaia, bero o toto lasi gauna. ");
INSERT INTO hmo_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Tau ese nani ena kwarana dekenai iena imana do ia atoa, bona do ia alaia mase, boubou patana ena mirigini kahana dekenai. Unai gabu dekenai idia gabua ore totona vamudia idia alaia mase noho. ");
INSERT INTO hmo_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Hahelagaia tauna ese iena imana kwakikwakina be nani ena rarana lalonai do ia atoa, bona boubou patana ena doana 4 dekenai inai rara do ia dahua. Rara orena, ia iusilaia lasi gauna, be boubou patana ena badinai do ia bubua. ");
INSERT INTO hmo_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","“Unai neganai nani ena digara ibounai do ia kokia, maino karaia boubouna totona boromakau ena digara idia kokia hegeregerena. Bona boubou patana ena latanai unai digara do ia gabua ore, ena bonana be Lohiabada dekenai do ia namo herea totona. Inai dala dekenai hahelagaia tauna ese unai tau ena kara dika davana do ia karaia, bona Lohiabada ese unai tau ena kara dika do ia gwauatao. ");
INSERT INTO hmo_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Bema tau ta ese mamoe ta kara dika boubouna totona ia mailaia neganai, mamoe hahine, bero o toto lasi gauna sibona do ia mailaia. ");
INSERT INTO hmo_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Tau ese iena imana be mamoe ena kwarana dekenai do ia atoa, bona do ia alaia mase, boubou patana ena mirigini kahana dekenai. Unai gabu dekenai idia gabua ore totona vamudia idia alaia mase noho. ");
INSERT INTO hmo_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","“Hahelagaia tauna ese iena imana kwakikwakina be mamoe ena rarana lalonai do ia atoa, bona boubou patana ena doana 4 dekenai inai rara do ia dahua. Rara orena, ia iusilaia lasi gauna be boubou patana ena badinai do ia bubua. ");
INSERT INTO hmo_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Unai murinai mamoe ena digarana ibounai do ia kokia, maino karaia boubouna totona mamoe ena digarana idia kokia hegeregerena. Bona boubou patana ena latanai unai digara do ia gabua ore, Lohiabada dekenai idia henia aniani bouboudia danu. “Inai dala dekenai hahelagaia tauna ese unai tau ena kara dika ena davana do ia karaia, bona Lohiabada ese unai tau ena kara dika do ia gwauatao.” ");
INSERT INTO hmo_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Ma Lohiabada ese Mose dekenai inai taravatu ia henia: Inai kara dika edia davana karaia totona taunimanima ese inai boubou gaudia do idia henia: Bema tau ta ese ia itaia gauna o ia diba gauna ta ia herevalaia diba kota gabuna dekenai, to ia herevalaia lasi, unai tau be ia kerere. ");
INSERT INTO hmo_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Bema Dubu ena taravatu ia gwau gau ta be miro, hegeregere mase gauna ena tauanina, uda boroma, o ubua gauna, o tano dekenai ia rau gauna, be tau ta ese ia dogoatao kava, ia itaia haraga lasi dainai, unai tau be ia kerere. ");
INSERT INTO hmo_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","O bema tau ta ese taunimanima edia miro gauna ta do ia dogoatao kava, ia diba lasi dainai, to gabeai ia diba, unai neganai ia be ia kerere. ");
INSERT INTO hmo_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Bema tau ta ese ia gwauhamata kava, do ia gwau, kara dikana ta, o kara namona ta do ia karaia, ia laloa namonamo lasi dainai, gabeai ia diba ia karaia diba lasi neganai, ia be ia kerere. ");
INSERT INTO hmo_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Unai bamona karadia dainai idia kerere taudia ese edia kara dika do idia gwauraia hedinarai. ");
INSERT INTO hmo_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Bona edia kara dika edia davana karaia totona, Lohiabada dekenai mamoe hahine o nani boubouna do idia mailaia. Hahelagaia tauna ese inai taudia edia kara dika dainai, edia boubou be Lohiabada dekenai do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Bema tau ta be moni lasi dainai mamoe o nanigosi ia hoia diba lasi neganai, ia ese Lohiabada dekenai manu edia ladana kerea rua, o pune rua do ia mailaia. Ta be kara dika totona boubouna, ma ta be gabua ore boubouna. ");
INSERT INTO hmo_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Unai tau ese inai manu be hahelagaia tauna dekenai do ia mailaia. Vadaeni hahelagaia tauna ese kara dika boubouna do ia henia guna. Manu ena aiona do ia mogea, to do ia utua parara lasi. ");
INSERT INTO hmo_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Manu ena rarana haida be boubou patana ena badinai do ia bubua. Inai be kara dika gwauatao totona ena boubouna. ");
INSERT INTO hmo_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Unai murinai manu iharuana be gabua ore ena boubou totona do ia henia, Dubu ena taravatu hegeregerena. Inai bamona dekenai hahelagaia tauna ese unai tau ena kara dika dainai boubou do ia henia, bona Lohiabada ese unai tau ena kara dika do ia gwauatao. ");
INSERT INTO hmo_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Bema tau ta be moni lasi dainai kerea rua o pune rua ia hoia diba lasi, ia ese paraoa ena metau kilogaram ta do ia mailaia, ena kara dika totona. Ia ese olive dehoro o bonana namona muramura do ia atoa lasi, badina inai be kara dika totona ena boubou. ");
INSERT INTO hmo_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Unai paraoa be hahelagaia tauna dekenai do ia mailaia. Hahelagaia tauna ese iena imana dekena amo paraoa haida do ia abia. Unai haida be Lohiabada dekenai henia ena toana. Unai neganai boubou patana ena latanai unai paraoa do ia gabua ore, aniani boubouna. Inai boubou be kara dika gwauatao totona. ");
INSERT INTO hmo_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Unai dala dekenai hahelagaia tauna ese unai tau ena kara dika ena davana do ia karaia, bona Lohiabada ese unai tau ena kara dika do ia gwauatao. Unai paraoa orena, ia gabua lasi gauna, be hahelagaia tauna ena, paraoa bouboudia haida hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Lohiabada ese Mose ia hamaoroa lou, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Bema tau ta do ia kerere, Lohiabada ena helaga gauna henia kara ta ia karaia maoro lasi, ia diba namonamo lasi dainai, ia ese inai dika ena davana karaia totona mamoe tau o nanigosi tau Lohiabada dekenai do ia mailaia. Unai mamoe o nanigosi be bero o toto lasi gauna, bona iena moni davana be hahelagaia tauna ese do ia gwauraia, Helaga Gabuna ena sikele hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Unai tau ese unai gaukara helagana ia hakererea ena davana momokani danu do ia henia, bona unai davana ena latanai atoa kau moni ma do ia henia. Unai atoa kau moni be inai: Davana korikori be karoa 5 neganai karoa ta be atoa kau moni, bona henia lou neganai karoa 6 do ia henia. Unai moni be unai tau ese hahelagaia tauna dekenai do ia henia. Unai neganai hahelagaia tauna ese unai tau ena kerere davana do ia karaia, kara dika totona ena mamoe dekena amo. Bona Lohiabada ese unai tau ena kara dika do ia gwauatao. ");
INSERT INTO hmo_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Bema tau ta ese Lohiabada ena Taravatu do ia utua kava, ia diba lasi dainai, ia be ia kerere, bona iena kerere davana do ia karaia. ");
INSERT INTO hmo_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ia ese iena dika ena davana karaia totona mamoe tau o nanigosi tau be hahelagaia tauna dekenai do ia mailaia. Unai mamoe o nanigosi be bero o toto lasi gauna, bona iena moni davana ena bada be unai tau ena kara dika ena bada hegeregerena. Hahelagaia tauna ese unai moni davana do ia gwauraia. Vadaeni hahelagaia tauna ese unai tau ena kerere, ia diba lasi gauna ena davana do ia karaia, mamoe boubouna dekena amo. Bona Lohiabada ese unai tau ena kara dika do ia gwauatao. ");
INSERT INTO hmo_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","“Inai be unai tau ena kara dika ena davana karaia totona ena boubou, badina ia ese Lohiabada ena vairanai ia kara dika dainai.” ");
INSERT INTO hmo_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Lohiabada ese Mose dekenai inai taravatu ia henia: ");
INSERT INTO hmo_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Bema tau ta ia koikoi Lohiabada dekenai, bona iena badibadinai noho tauna ena kohu ia naria neganai ia koikoi, o abiatorehai ia henia lou dekenai ia koikoi, o bema iena badibadinai noho tauna dekena amo ia henaoa, o ia dagedage henia neganai, unai tau be ia kerere. ");
INSERT INTO hmo_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","O sedira tau ta ese ma tau ta ena boio gauna do ia davaria, bona do ia herevalaia koikoi, o sedira do ia gwauhamata koikoi, do ia gwau, “Unai boio gauna lau davaria lasi.” ");
INSERT INTO hmo_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Bema tau ta be unai bamona ia kara dika, ia be mai ena kerere. Ia ese ia henaoa gauna, o dagedage dekena amo ia abia gauna, o idia henia do ia naria totona gauna, o ia davaria gauna, ");
INSERT INTO hmo_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","o ia gwauhamata koikoi totona gauna, be unai gau ena biaguna dekenai do ia henia lou, mai atoa kau moni danu. Atoa kau moni ena bada be hegeregere bema davana korikori ena karoa be 5, karoa ta be atoa kau moni, bona henia lou neganai karoa 6 do ia henia. Vadaeni unai tau ese iena kerere totona boubou do ia henia dinana dekenai, unai ia henaoa gauna ena davana, mai atoa kau moni danu, be unai gau ena biaguna dekenai do ia henia lou. ");
INSERT INTO hmo_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Unai kerere tauna ese iena kara koikoi boubouna be Lohiabada dekenai do ia mailaia. Mamoe tau o nanigosi tau, mai bero o toto lasi gauna, do ia mailaia, iena moni davana ena bada be unai tau ena kara dika ena bada hegeregerena. Hahelagaia tauna ese unai moni davana do ia gwauraia. ");
INSERT INTO hmo_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Hahelagaia tauna ese unai boubou do ia henia, unai tau ena kara dika ena davana karaia totona, bona lau Lohiabada ese unai tau ena kara dika do lau gwauatao. ");
INSERT INTO hmo_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ma Lohiabada ese Mose ia hamaoroa, ");
INSERT INTO hmo_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","idia gabua ore bouboudia totona Arona bona iena natuna tau dekenai inai taravatu do ia henia: Boubou gauna be boubou patana ena latanai do ia noho ela bona dabai, lahi danu do ia gabua noho ela bona dabai. ");
INSERT INTO hmo_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Unai neganai hahelagaia tauna ese iena dabua latana bona iena piripou, dabua namodia dekenai karaia gaudia do ia atoa, bona idia gabua ore boubouna ena kahu be boubou patana dekena amo do ia abia, bona boubou patana ena badinai do ia bubua. ");
INSERT INTO hmo_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Vadaeni iena dabua namodia do ia kokia, dabua idaudia do ia kwatua, bona unai kahu be kamepa ena murimurinai do ia abia lao, goeva gabuna ta dekenai unai kahu do ia bubua. ");
INSERT INTO hmo_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Boubou patana ena lahi be do ia gabua hanaihanai, do idia habodoa lasi. Daba ibounai hahelagaia tauna ese au rakuraku matamata do ia atoa, boubou gauna, gabua totona gauna be lahi ena latanai do ia atoa, bona maino karaia boubouna totona danu, be digara ia danu do ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Lahi be boubou patana ena latanai do ia gabua hanaihanai, do ia bodo lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Paraoa boubouna ena taravatu be inai: Arona ena natuna tau ta ese Lohiabada ena vairanai do ia mailaia, boubou patana ena vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Vadaeni unai hahelagaia tauna ese iena imana dekenai paraoa mai ena olive dehoro sisina, bona bonana namona muramura ena pauda do ia abia, bona unai gau toi be boubou patana ena latanai do ia gabua ore. Unai be Lohiabada dekenai henia ena toana. Unai boubou idia gabua ena bonana be namo herea Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","To paraoa ena orena, idia gabua lasi gaudia, be Arona mai ena natuna tau edia, do idia ania. Unai paraoa mai hatubua muramura lasi dekenai, beredi do idia gabua, bona do idia ania, gabu helagana ta dekenai, Lohiabada ena Palai Dubu ia koua hagegea koua dabua ena lalonai. ");
INSERT INTO hmo_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Hatubua muramura danu do umui mikisi lasi. Lau Lohiabada ese hahelagaia taudia dekenai unai paraoa lau henia, ia be idia edia davana, aniani bouboudia dekena amo. Unai boubou be helaga herea, kara dika boubouna bona kerere totona boubouna hegeregere. ");
INSERT INTO hmo_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Arona ena natuna bona tubuna taudia ibounai ese inai paraoa idia ania diba. Unai be idia edia davana ela bona hanaihanai, Lohiabada dekenai henia aniani bouboudia dekena amo. To bema tau idauna ta ese inai paraoa ia dogoatao neganai, inai helaga ena siahu ese do ia hadikaia. ");
INSERT INTO hmo_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Lohiabada ese ma “Mose dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Arona o iena natuna tau ese iena dagi helagana ia abia dinana dekenai, ia ese paraoa ena metau kilogaram ta Lohiabada dekenai do ia mailaia. Inai paraoa ena metau, be paraoa boubouna, nega ibounai idia henia gauna ena metau hegeregerena. Inai paraoa kahana be dabai do idia henia, bona kahana be adorahi neganai do idia henia. ");
INSERT INTO hmo_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Paraoa be olive dehoro danu do idia mikisi, bona auri ena latanai do idia gabua. Unai murinai unai keke do idia makohia maragimaragi, bona boubou gauna do idia halaoa, bonana namo herea Lohiabada ena vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","“Nega ibounai hanaihanai inai bamona boubou be Arona ena natuna o tubuna, iena dagi, Hahelagaia Tauna Badana, ia abia tauna ese inai boubou do ia karaia, taravatu badana be inai. Ia ese inai boubou ibounai do ia gabua ore, Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","“Hahelagaia tauna ese ia sibona totona ia henia paraoa bouboudia ibounai be do ia gabua ore momokani, inai paraoa ena kahana ta do ia ania diba lasi.” ");
INSERT INTO hmo_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Lohiabada ese Mose ia hamaoroa, ");
INSERT INTO hmo_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","kara dika bouboudia totona, Arona bona iena natuna tau dekenai inai taravatu do ia henia: Kara dika boubouna gauna be Lohiabada ena vairanai do idia alaia mase, idia gabua ore bouboudia idia alaia mase gabuna dekenai. Inai boubou be helaga herea momokani. ");
INSERT INTO hmo_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Unai boubou helaga ia karaia hahelagaia tauna be gabu helagana ta dekenai boubou ena vamu do ia ania, Lohiabada ena Palai Dubu ia koua hagegea koua dabua ena lalonai. ");
INSERT INTO hmo_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Bema hahelagaia tauna lasi, to tau ta, o gau ta be inai boubou vamuna dekenai ia kamokau neganai, boubou ena helaga ena siahu ese do ia hadikadia. Bema boubou ena rara haida be dabua ta dekenai ia bubua neganai, unai dabua be gabu helagana ta dekenai do idia huria. ");
INSERT INTO hmo_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Bema unai boubou be uro ta dekenai idia nadua, unai uro be do idia hamakohia, o bema auri urona dekenai, unai uro be do idia kakasia, bona ranu dekenai do idia huria. ");
INSERT INTO hmo_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Hahelagaia taudia edia bese ena natuna tau ibounai ese inai boubou vamuna idia ania diba. Inai boubou ena vamu be helaga herea momokani. ");
INSERT INTO hmo_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","To bema inai kara dika kokia totona boubouna ena rarana be Palai Dubu dekenai idia mailaia vareai neganai, unai boubou vamuna be do idia ania lasi momokani, bona unai vamu be do idia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ma Mose ese Dirava ena hadibaia hereva ia gwauraia: Kerere totona bouboudia edia taravatu be inai, idia be helaga herea bouboudia: ");
INSERT INTO hmo_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Inai kerere kokia totona boubou gauna be boubou patana ena mirigini kahana dekenai do idia alaia. Inai gabu dekenai danu idia gabua ore boubou gaudia idia alaia ore. Inai boubou gauna ena rara be boubou patana ena kahana 4 dekenai do idia negea. ");
INSERT INTO hmo_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Unai boubou gauna ena digara ibounai be do idia kokia, bona boubou patana dekenai do idia atoa: Iuna, mai digarana ibounai, bogana ena digara ibounai, ");
INSERT INTO hmo_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","nadinadi mai edia digara, bona asena ena kahana badana. ");
INSERT INTO hmo_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Hahelagaia tauna ese inai digara ibounai be boubou patana dekenai do ia gabua ore. Inai be kerere totona aniani boubouna, Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Hahelagaia taudia edia bese natuna tau ibounai ese inai boubou vamuna idia ania diba. To gabu helagana ta dekenai do idia ania, badina be inai boubou vamuna be helaga herea momokani. ");
INSERT INTO hmo_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Kara dika totona boubouna bona kerere totona boubouna edia taravatu be tamona: Boubou ena vamuna be unai boubou helaga ia karaia hahelagaia tauna ena, do ia ania diba. ");
INSERT INTO hmo_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Gabua ore boubou gauna ena kopina danu, be unai boubou helaga ia karaia hahelagaia tauna ese do ia abia, iena. ");
INSERT INTO hmo_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Paraoa bouboudia ibounai, amu dekenai, paraipani dekenai, o auri palaka dekenai ia gabua gaudia ibounai, be Lohiabada dekenai ia henia hahelagaia tauna ena, do ia ania diba. ");
INSERT INTO hmo_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","To idia gabua lasi paraoa bouboudia ibounai, mai olive dehoro danu mikisi gaudia, o paraoa kaukau sibona gaudia, be Arona ena natuna tau edia, do idia haria, ta ta ese hegeregere do idia abia. ");
INSERT INTO hmo_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Dirava danu maino karaia boubouna, Lohiabada dekenai henia gauna, ena taravatu be inai: ");
INSERT INTO hmo_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Bema tau ta ese Dirava tanikiu henia totona, maino karaia boubouna ia mailaia neganai, ia alaia boubouna danu be beredi, mai hatubua muramura lasi gauna do ia mailaia. Inai beredi be sisina metau bamona, paraoa bona olive dehoro idia mikisi dekena amo idia karaia gauna, o bisikesi, olive dehoro dekena amo idia dahua gaudia, o keke, paraoa bona olive dehoro idia mikisi dekena amo karaia gaudia. ");
INSERT INTO hmo_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ma danu ia ese mai hatubua muramura danu beredi haida do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Inai paraoa idauidau dekena amo, beredi sisina metauna ta, bisikesi ta, o keke ta, bona mai hatubua muramura beredi ta Lohiabada dekenai do ia henia. Inai boubou be hahelagaia tauna, boubou patana dekenai boubou gauna ena rara ia negea tauna, ena. Do ia ania diba. ");
INSERT INTO hmo_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Inai maino karaia boubou gauna ena vamuna be ia henia dinana dekenai do ia ania, haida do ia noho kava lasi ela bona dabai. ");
INSERT INTO hmo_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","To bema tau ta ena boubou be iena gwauhamata ia hamomokania dainai, o sibona ena harihari gauna neganai, hahelagaia tauna ese, Lohiabada dekenai ia henia dinana dekenai, be unai boubou vamuna haida ia ania diba, bona dina iharuana danu haida ia ania diba. ");
INSERT INTO hmo_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","To dina ihatoina dekenai bema unai vamu haida ia noho neganai, do idia gabua ore momokani. ");
INSERT INTO hmo_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Bema dina ihatoina dekenai unai vamu idia ania neganai, Dirava ese unai tau ena boubou gauna do ia abia dae lasi. Bona unai boubou ia henia tauna be Lohiabada ese do ia hanamoa lasi. Ia be do ia miro, bona ia ania tauna danu be do ia kerere. ");
INSERT INTO hmo_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Bema Dirava danu maino karaia vamu be gau mirona dekenai ia kamokau neganai, idia ese unai vamu do idia ania lasi, to lahi dekenai do idia gabua ore. Dirava ena Taravatu hegeregerena idia goeva taudia ibounai ese unai maino karaia boubou ena vamu idia ania diba. ");
INSERT INTO hmo_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","To bema ia goeva lasi tauna ta ese Dirava danu maino karaia boubouna ia ania neganai, ia be Dirava ena bese dekena amo do idia atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Bona sedira tau ta ese taunimanima edia gau mirona ta, o mauri gauna ta ena gau mirona ta, o Dirava ena taravatu hegeregerena miro gauna ta, o bodaga gauna ta do ia dogoatao. Bema gabeai unai tau ese Dirava danu maino karaia boubou vamuna do ia ania neganai, ia be Dirava ena bese dekena amo do idia atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ma Lohiabada ese inai taravatu Mose dekenai ia henia: ");
INSERT INTO hmo_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Israela taudia ese digara do idia ania lasi, boromakau ena digara, o mamoe ena digara, o nanigosi ena digara. ");
INSERT INTO hmo_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Do ia mase kava gauna, o dagedage gauna ta ese ia alaia gauna ta ena digara be edia gaukara idauidau totona idia gaukaralaia diba, to do idia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Badina be bema tau ta ese digara do ia ania, Lohiabada dekenai gabua ore boubou totona ia henia diba gauna ta ena digara, unai tau be Dirava ena bese dekena amo do idia atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Rara danu do idia ania lasi, manu ta, o mauri gauna ta ena rara. Inai taravatu be do idia badinaia momokani, edia noho gabudia ibounai dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Rara do ia ania tauna be Dirava ena bese dekena amo do idia atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ma Lohiabada ese Mose dekenai inai hadibaia hereva ia henia: ");
INSERT INTO hmo_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Israela taudia ese inai boubou taravatu do idia badinaia: Dirava danu maino karaia boubouna ia mailaia tauna ese iena boubou kahana be Dirava dekenai do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Sibona ena imana dekenai unai aniani boubouna Lohiabada dekenai do ia mailaia. Ia ese unai vamu ena digara bona ena kemena Lohiabada dekenai do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Hahelagaia tauna ese boubou patana dekenai unai digara do ia gabua ore, to kemena be hahelagaia taudia, Arona ena bese taudia ese do idia ania. ");
INSERT INTO hmo_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Inai boubou ia mailaia tauna ese boubou gauna ena aena, idiba kahana gauna, be hahelagaia tauna dekenai do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Arona ena natuna, boubou vamuna ena rara bona digara boubou patana dekenai ia atoa tauna, ese unai aena idibana do ia ania. ");
INSERT INTO hmo_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Boubou gauna ena kemena be harihari gauna ta, aena idibana danu be henia gauna ta. Idia be Israela taudia edia maino karaia bouboudia dekena amo lau Dirava ese lau abia gaudia. Bona Israela taudia ese inai kemena bona aena be Arona bona iena tubuna taudia dekenai do idia henia ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Hahelagaia taudia edia gaukara davana be inai. Edia hahelagaia dinana dekenai, Lohiabada dekenai idia gabua ore vamuna kahana dekena amo idia ania diba aniani gaudia be unai. ");
INSERT INTO hmo_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Edia hahelagaia dinana dekenai, Lohiabada ese oda ia gwauraia, ia gwau Israela taudia ese unai kemena bona aena idibana be hahelagaia taudia dekenai do idia henia, edia aniani. Inai be edia gaukara davana, gabua bouboudia ibounai dekena amo, ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Gabua ore bouboudia, bona paraoa bouboudia, bona kara dika totona bouboudia, bona kerere totona bouboudia, bona hahelagaia totona bouboudia, bona Dirava danu maino karaia bouboudia edia taravatu be unai. ");
INSERT INTO hmo_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Unuseni, Sinai Ororo dekenai Lohiabada ese inai boubou edia taravatu be Mose dekenai ia henia. Dinana be unai, Lohiabada ese Israela taudia ia oda henidia edia boubou gaudia ia dekenai do idia mailaia, Sinai, taunimanima idia noho lasi gabuna dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Arona bona iena natuna tau taudia be egu Palai Dubu ena iduara dekenai do oi hakaudia mai. Edia dabua helagadia, dehoro helagana, boromakau tau bona mamoe tau ruaosi, bona bosea ta, mai ena hatubua lasi beredi danu do oi mailaia. ");
INSERT INTO hmo_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Unai neganai Israela taudia ibounai be unai gabu dekenai do oi boiria idia haboua.” ");
INSERT INTO hmo_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mose ese Lohiabada ena oda ia karaia, ia ese taunimanima ibounai Palai Dubu ena iduara kahirakahira ia haboudia. ");
INSERT INTO hmo_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Idia dekenai Mose ia hereva, ia gwau, “Lohiabada ese lau dekenai ia oda henia gauna be inai.” ");
INSERT INTO hmo_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Vadaeni Mose ese Arona bona iena natuna tau taudia ia abia mai, ranu dekena amo ia hadigudia. ");
INSERT INTO hmo_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Mose ese Arona dekenai sioti bona dabua latana ia atoa, bona gaba gauna Arona dekenai ia kwatua. Ma epodi danu Arona dekenai ia kwatua, epodi ena gaba gauna, idia hatua namonamo gauna dekena amo. ");
INSERT INTO hmo_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Mose ese danu kemena dabua Arona dekenai ia atoa, bona Urima bona Tumima be kemena dabua lalonai ia udaia. ");
INSERT INTO hmo_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Unai murinai Mose ese kwara kumia gauna be Arona ena kwarana dekenai ia atoa, bona inai kwara gauna ena vairanai be medolo namo herea, helaga momokani ena toana gauna ia kwatua kau, Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Vadaeni Mose ese dehoro helagana ia abia, Lohiabada ena Palai Dubu, bona Dubu lalonai noho gaudia ibounai dekenai ia atoa, ia hahelagaia. ");
INSERT INTO hmo_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Boubou patana, bona iena kohu ibounai, bona digu totona ranu ena disi, disi ena patana danu be nega 7 unai dehoro dekenai ia dahua, do idia helaga totona. ");
INSERT INTO hmo_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Arona ena kwarana dekenai danu be dehoro helagana ia bubua, ia hahelagaia. ");
INSERT INTO hmo_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Unai murinai Mose ese Arona ena natuna tau ia hakaudia mai, sioti bona gaba gaudia bona kwara gaudia danu idia dekenai ia atoa, Lohiabada ese ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Vadaeni Mose ese boromakau tau ia mailaia, kara dika gwauatao boubouna totona gauna. Arona bona iena natuna tau danu ese edia imadia be boromakau ena kwarana dekenai idia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Vadaeni Mose ese boromakau ia alaia mase, boromakau ena rarana haida ia abia, bona iena imana kwakikwakina dekena amo boubou patana ena doa 4 be rara dekenai ia dahua, vadaeni boubou patana ena miro ia hagoevaia. Bona boromakau ena rara orena, be boubou patana ena badinai ia bubua. Inai kara dekenai Mose ese boubou patana ia hahelagaia. ");
INSERT INTO hmo_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Unai murinai Mose ese boromakau ena bogana ena digara ibounai, bona asena ena kahana badana, bona nadinadi ruaosi, mai edia digara danu ia abia, bona boubou patana dekenai ia gabudia ore. ");
INSERT INTO hmo_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Boromakau ena tauanina, ena kopina, ena hidiona, bona ena bogarau mai kukuri danu be Mose ese kamepa ena murimurinai ia gabua ore, Lohiabada ese ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ma inai murinai Mose ese mamoe tau, gabua ore boubouna totona gauna, ia hakaua mai. Arona bona iena natuna tau ese edia imadia be mamoe ena kwarana dekenai idia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Vadaeni Mose ese mamoe ia alaia mase, bona mamoe ena rarana be boubou patana ena kahana 4 dekenai ia negea. ");
INSERT INTO hmo_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Mose ese mamoe ia ivaia parara, mamoe ena kwarana bona tauanina bona digarana be boubou patana ena latanai ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ma mamoe ena bogana bona bogarauna bona imana bona aena be ranu dekenai ia huria guna, vadaeni mamoe ena kahana ibounai be Mose ese boubou patana dekenai ia gabua ore. Inai lahi dekenai ia gabua ore boubouna, Lohiabada ena, be mai bonana namo herea Lohiabada dekenai. Mose ese Lohiabada ena hadibaia hereva hegeregerena ia karaia. ");
INSERT INTO hmo_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Unai murinai Mose ese mamoe tau iharuana, hahelagaia taudia hahelagaia totona gauna, ia hakaua mai. Vadaeni Arona mai ena natuna tau ese edia imadia be mamoe ena kwarana dekenai idia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mose ese mamoe ia alaia mase, bona mamoe ena rarana haida ia abia, Arona ena taiana idibana ena rini atoa gabuna, bona iena ima kwakikwaki badana, idiba kahana gauna, bona ae kwakikwaki badana, idiba kahana gauna dekenai unai rara ia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Arona ena natuna tau danu edia taiana idibana rini atoa gabuna, bona edia ima kwakikwaki badana, idiba kahana gauna, bona edia ae kwakikwaki badana, idiba kahana gauna, dekenai be Mose ese unai mamoe ena rarana haida ia atoa. Vadaeni rara orena, ia iusilaia lasi gauna, be Mose ese boubou patana ena kahana 4 dekenai ia negea. ");
INSERT INTO hmo_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Mamoe ena digara, bona ena iuna, mai ena digara danu, bogana dekenai ia noho digara ibounai, asena ena kahana badana, nadinadi ruaosi, mai edia digara, bona aena idibana, be Mose ese ia abia. ");
INSERT INTO hmo_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Vadaeni idia hatubua lasi beredi edia bosea, Lohiabada ena vairanai ia noho gauna, dekena amo, beredi ta, bona beredi ta, paraoa bona olive dehoro danu dekena amo karaia gauna, bona bisikesi ta be Mose ese ia abia, digara bona aena idibana edia latanai ia atodia. ");
INSERT INTO hmo_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Mose ese inai aniani ibounai Arona bona ena natuna tau edia imadia dekenai ia atoa, bona idia ese Lohiabada ena vairanai idia davea, ia dekenai idia henia ena toana. ");
INSERT INTO hmo_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Vadaeni Mose ese edia imadia dekena amo inai aniani ma ia abia lou, bona boubou patana ena lahi dekenai ia gabua, idia gabua ore boubouna ena latanai. Inai boubou be hahelagaia taudia do ia hahelagaia totona, bona boubou ena bonana be namo herea Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Vadaeni Mose ese mamoe ena kemena ia abia, bona ia davea, Lohiabada dekenai ia henia ena toana. Unai kemena be Mose ena gaukara davana, hahelagaia boubou dekena amo ia abia. Mose ese gau ibounai ia karaia, Lohiabada ese ia dekenai ia hadibaia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mose ese dehoro helagana sisina ia abia, bona boubou patana ena latanai ia noho rara sisina danu. Inai dehoro bona rara be Arona bona iena natuna tau edia latanai, bona edia dabua latanai ia negea. Inai dala dekenai Mose ese Arona, bona iena natuna tau, bona edia dabua danu, ia hahelagaia, Lohiabada ena vairanai. ");
INSERT INTO hmo_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mose ese Arona, mai ena natuna tau danu ia hamaoroa, ia gwau, “Inai vamu be ranu dekenai do umui nadua, Lohiabada ena Palai Dubu ena iduara badinai, bona unuseni do umui ania. Bosea helagana lalonai ia noho beredi danu do umui ania, Lohiabada ese lau ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Umui ania lasi vamuna o beredi be do umui gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Palai Dubu ena iduara dekena amo do umui raka siri lasi dina 7 lalonai, ela bona emui hahelagaia dinadia idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Hari dina ita karaia karadia be Lohiabada ese ia oda vadaeni, emui kara dika ena davana karaia totona. ");
INSERT INTO hmo_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","“Dina 7 bona hanuaboi 7 be Palai Dubu ena iduara dekenai do umui noho, bona Lohiabada ia gwauraia oda do umui karaia, do umui mase garina. Unai bamona be Lohiabada ese lau ia oda henia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Vadaeni Lohiabada ese Mose ia oda henia karadia ibounai, be Arona bona iena natuna tau ese idia karaia haorea. ");
INSERT INTO hmo_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Dina namba 8 dekenai Mose ese Arona, mai iena natuna tau danu, bona Israela gunalaia taudia ia boiria hebou. ");
INSERT INTO hmo_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Mose ese Arona ia oda henia, ia gwau, “Boromakau ena natuna tau bona mamoe tau, bero o toto lasi gaudia do oi abia, bona Lohiabada ena vairanai ruaosi do oi alaia mase, oiemu boubou totona. Boromakau be kara dika ena boubou totona, bona mamoe be gabua ore boubou totona. ");
INSERT INTO hmo_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Israela taudia danu do oi oda henia, idia ese nanigosi tau do idia abia, kara dika ena boubou totona. Boromakau natuna ta bona mamoe natuna ta, ruaosi lagani tamona gaudia, bero o toto lasi gaudia danu do idia abia, gabua ore boubouna totona. ");
INSERT INTO hmo_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Boromakau tau ta bona mamoe tau ta danu do idia abia, Dirava danu maino karaia totona boubouna totona. Inai boubou gaudia ibounai be Lohiabada ena vairanai do ita alaia mase. Paraoa boubouna danu, olive dehoro danu mikisi gauna, be Lohiabada dekenai do umui henia. Inai bamona do umui karaia, badina be hari dina Lohiabada be umui dekenai do ia hedinarai.” ");
INSERT INTO hmo_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Vadaeni Mose ese ia gwauraia gaudia idia ese Palai Dubu ena vairana dekenai idia mailaia, bona taunimanima ibounai idia raka mai kahirakahira, Lohiabada ena vairanai idia gini. ");
INSERT INTO hmo_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mose ia gwau, “Lohiabada ese ia oda henia, inai kara ibounai do umui karaia, iena diaridiari namo herea be umui dekenai do ia hedinaraia totona.” ");
INSERT INTO hmo_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mose ese danu Arona ia hamaoroa, ia gwau, “Boubou patana dekenai oi lao, oiemu kara dika boubouna, bona oiemu gabua ore boubouna do oi alaia mase. Inai bouboudia be oiemu kara dika bona oiemu bese taudia edia kara dika edia davana karaia totona. Israela taudia edia kara dika davana karaia totona boubouna danu do oi karaia, Lohiabada ese ia oda henia hegeregerena.” ");
INSERT INTO hmo_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Vadaeni Arona be boubou patana dekenai ia lao, boromakau ena natuna tau ia alaia mase. Inai boubou be Arona sibona ena kara dika totona. ");
INSERT INTO hmo_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Arona ena natuna tau ese boubou ena rarana idia abia, edia tamana dekenai idia henia, bona Arona ese rara dekenai iena ima kwakikwakina ia atoa, bona rara be boubou patana ena doa 4 dekenai ia atoa. Rara orena be boubou patana ena badinai ia bubua. ");
INSERT INTO hmo_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Unai murinai Arona ese boromakau ena digara, nadinadi ruaosi, bona asena ena kahana badana ia gabua ore, Lohiabada ese Mose ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","To boromakau ena vamuna bona kopina be kamepa ena murimurinai ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Vadaeni Arona ese sibona ena gabua ore mamoe boubouna ia alaia mase. Arona ena natuna tau ese boubou ena rarana idia mailaia, bona Arona ese unai rara be boubou patana ena kahana 4 dekenai ia negea. ");
INSERT INTO hmo_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Iena natuna tau ese boubou ena kwarana bona tauanina kahana haida Arona dekenai idia henia, bona ia ese boubou patana dekenai ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Unai murinai Arona ese boubou ena bogana ibounai bona ena aena ruaosi be ranu dekenai ia huria, bona idia gabua ore boubou gaudia oredia edia latanai ia atodia, idia ibounai ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Vadaeni Arona ese Israela taudia edia boubou gaudia ia mailaia. Nanigosi tau, taunimanima edia kara dika totona gauna ia alaia mase. Ia gabua ore, edia dika do idia gwauatao totona, sibona ena dika totona boubou gauna hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Arona ese danu do ia gabua ore boubouna ia mailaia, ia alaia mase, ia gabua ore, Lohiabada ena oda hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Arona ese danu paraoa boubouna ia mailaia, iena imana dekena amo paraoa haida ia abia, boubou patana ena latanai ia gabua ore. Daba ena boubouna be ma ta. ");
INSERT INTO hmo_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Boromakau tau bona mamoe tau danu be Arona ese ia alaia mase, Israela taudia be Lohiabada danu do idia maino karaia totona gauna be unai. Iena natuna tau ese boubou ena rarana haida idia mailaia, bona Arona ese boubou patana ena kahana 4 dekenai unai rara ia negea. ");
INSERT INTO hmo_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Arona ese boromakau tau bona mamoe tau edia digara kahadia, ");
INSERT INTO hmo_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","be boubou gaudia edia kemedia edia latanai ia atoa, bona unai vamu ibounai boubou patana dekenai ia atoa. Ia ese digara ibounai boubou patana dekenai ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Arona ese boubou edia kemedia bona aena idibadia ia abia, Lohiabada ena vairanai ia davea. Inai be hahelagaia taudia edia, Mose ena oda hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Arona ese inai boubou ibounai ia haorea murinai iena imana ia abia isi, bona taunimanina ia hanamoa. Vadaeni kara dika boubouna, gabua ore boubouna, bona maino karaia boubouna ia karaia gabuna dekena amo Arona ese ia diho mai. ");
INSERT INTO hmo_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Unai neganai Mose bona Arona be Lohiabada ena Palai Dubu dekenai idia raka vareai. Palai Dubu idia rakatania neganai, idia gini, bona idia ese taunimanima idia hanamoa. Unai neganai Lohiabada ena diaridiari namo herea be taunimanima ibounai dekenai ia hedinarai. ");
INSERT INTO hmo_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Bona lahi be Lohiabada ese iena gabu dekena amo ia siaia haraga. Inai lahi ese boubou gaudia bona digara, boubou patana dekenai noho gaudia, ia gabua ore. Israela taudia ese unai kara idia itaia, vadaeni mai moale danu idia boiboi, bona edia vairadia be tano dekenai idia atoa diho. ");
INSERT INTO hmo_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Arona ena natuna tau, Nadaba bona Abihu ese edia gida dogoatao auridia idia abia, gida haida idia udaia, bona muramura mai bonana namona danu. Inai lahi idauna be Lohiabada ena vairanai idia atoa, boubou gauna bamona, to inai lahi be Lohiabada ena oda gauna hegeregerena lasi. ");
INSERT INTO hmo_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Vadaeni lahi be Lohiabada ese ia siaia haraga, unai tau ruaosi ia alaia mase, Lohiabada ena vairana dekenai idia mase. ");
INSERT INTO hmo_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Unai neganai Mose ese Arona ia hamaoroa, ia gwau, “Lohiabada be inai bamona ia hereva vadaeni, ani? Ia gwau, ‘Egu orea taudia dekenai lau be helaga, bona lauegu gaukara idia karaia taudia ese egu helaga do idia matauraia. Taunimanima ibounai ese lauegu hairaina do idia itaia, bona lau do idia hanamoa.’ ” To Arona be hereva ta ia gwauraia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Vadaeni Mose ese Misaela bona Elisapana ia boiria. Idia be Usiele, Arona ena tamana maragi, ena natuna. Mose ese Misaela bona Elisapana ia hamaoroa, ia gwau, “Umui mai, emui varavara taudia, idia mase vadaeni taudia be inai. Edia tauanina be Palai Dubu helagana dekena amo do umui huaia lao, kamepa ena murimurinai do umui atodia.” ");
INSERT INTO hmo_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Vadaeni idia raka mai, mai dabua danu, tauanina ruaosi idia abia isi, kamepa ena murimurinai idia abia lao, Mose ese ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mose ese Arona, mai ena natuna tau Eleasara bona Itamara danu ia hamaoroa, ia gwau, “Emui huina do umui naria, do umui duaria bona kwatua namonamo. Bema inai mase taudia dainai emui lalona idia hisihisi neganai, emui dabua do umui darea lasi. Bema unai bamona umui karaia neganai do umui mase, bona Lohiabada be Israela taudia ibounai dekenai do ia badu. To emui bese, Israela taudia ese inai mase taudia, Lohiabada ena lahi ese ia alaia taudia, totona idia taitai diba. ");
INSERT INTO hmo_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","“Palai Dubu ena iduara do umui rakatania lasi, do umui mase garina, badina be Lohiabada ena dehoro helagana ese umui ia hahelagaia vadaeni.” Vadaeni Mose ia hamaorodia hegeregerena idia karaia. ");
INSERT INTO hmo_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Lohiabada ese Arona ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Oi bona oiemu natuna tau ese lauegu Palai Dubu umui raka vareai neganai, uaina o bia do umui inua lasi. Bema inai bamona umui karaia neganai do umui mase. Inai be taravatu badana, bona umui emui natuna, tubuna taudia ese do idia badinaia ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Gau helagadia be idau, gau kavakava danu be idau. Edia idau do umui laloa namonamo, bona gau helagadia do umui matauraia. Goeva gaudia bona miro gaudia edia idau danu do umui diba namonamo. ");
INSERT INTO hmo_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Bona Mose dekena amo umui lau henia taravatu ibounai be Israela taudia dekenai do oi hadibaia.” ");
INSERT INTO hmo_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mose ese Arona mai ena natuna ruaosi, do mauri taudia, Eleasara bona Itamara ia hamaoroa, ia gwau, “Paraoa boubouna ena orena, Lohiabada ena gabua ore boubouna dekena amo paraoa do umui abia, bona ena beredi be boubou patana kahirakahira do umui ania, paraoa kavakava sibona, mai hatubua muramura lasi gauna. Badina be inai paraoa boubouna be helaga herea. ");
INSERT INTO hmo_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Gabu helagana ta dekenai do umui ania, Palai Dubu ese ia koua hagegea koua dabua ena lalonai, badina inai be umui bona emui natuna emui gaukara davana, Lohiabada ena gabua ore boubouna dekena amo. ");
INSERT INTO hmo_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“Bona boubou gauna ena kemena bona aena, idia davea, bona Lohiabada dekenai idia henia gaudia be umui bona emui natuna ibounai ese goeva gabuna ta dekenai umui ania diba. Badina be Lohiabada ese inai aniani be umui hahelagaia taudia dekenai ia henia, emui davana, Israela taudia edia maino karaia boubouna dekena amo. ");
INSERT INTO hmo_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Israela taudia ese edia boubou ena digara Lohiabada dekenai idia henia neganai, unai kemena bona aena nega tamona do idia henia. Inai kemena bona aena be umui bona emui natuna, tubuna taudia, emui aniani nega ibounai ela bona hanaihanai, Lohiabada ena oda hegeregerena.” ");
INSERT INTO hmo_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Vadaeni Mose ese kara dika totona nanigosi ia tahua, to ia davaria idia gabua ore vadaeni. Unai neganai Mose be Arona bona Eleasara bona Itamara dekenai ia badu, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Badina dahaka gabu helagana ta dekenai inai kara dika totona boubouna umui ania lasi? Ia be boubou helaga herea, bona Lohiabada ese umui dekenai ia henia vadaeni, Israela taudia edia kara dika do ia gwauatao totona. ");
INSERT INTO hmo_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Umui itaia, boubou ena rarana be Helaga Gabuna dekenai idia abia vareai lasi. Unai dainai badina dahaka unai boubou nanigosi be gabu helagana ta dekenai umui ania lasi? Lauegu oda hereva inai boubou totona be umui kamonai henia lasi.” ");
INSERT INTO hmo_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Arona ese Mose ia haere henia, ia gwau, “Oi itaia, hari dina be taunimanima ese edia kara dika boubouna bona gabua ore boubouna idia mailaia, Lohiabada dekenai idia henia. To inai dika bada herea kara, egu natuna ruaosi edia mase, be lau dekenai idia vara. Bema unai kara dika boubouna be hari dina lau ania neganai, Lohiabada ese lau dekenai do ia laloa namo, a?” ");
INSERT INTO hmo_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mose ese inai hereva ia kamonai, vadaeni iena badu ia keru. ");
INSERT INTO hmo_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Lohiabada ese Mose bona Arona ia oda henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Israela taudia do umui hamaoroa inai bamona: Mauri gaudia tanobada dekenai idia noho, be ibounai do umui ania lasi, to inai sibona do umui ania: ");
INSERT INTO hmo_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Edia imana bona aena palapala idia auka bona parara, bona aniani idia ania murinai, uduna dekenai ma idia mumuta lou, vadaeni ma idia ania lou, unai bamona mauri gaudia umui ania diba. ");
INSERT INTO hmo_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“To unai bamona haida be do umui ania lasi. Kamelo do umui ania lasi, badina be iena aniani ia ania lou, to iena imana bona aena idia parara lasi. Ia be taravatu umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","“Nadi dekenai ia noho rabito bona mada danu do umui ania lasi, badina be ena aniani ia ania lou, to iena imana bona aena palapala idia parara lasi. Ia be taravatu umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","“Hea danu do umui ania lasi, badina be iena aniani ia ania lou, to iena imana bona aena palapala idia parara lasi. Ia be taravatu umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","“Ma boroma danu do umui ania lasi. Iena imana bona aena idia parara vadaeni, to iena aniani ia ania lou lasi. Ia be miro umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","“Inai mauri gaudia do umui ania lasi. Edia mase tauanina do umui dogoatao lasi, idia be miro umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Ranu dekenai idia noho gaudia, do umui ania diba gaudia be inai: Davara o sinavai dekenai gwarume gaudia mai edia taiana bona mai edia unana. ");
INSERT INTO hmo_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","To ranu dekenai idia noho mauri gaudia, mai edia taiana lasi, bona unana lasi, be do umui ania lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Unai bamona mauri gaudia be miro umui dekenai. Idia be do umui ania lasi, bona edia mase tauanina do umui dogoatao lasi. ");
INSERT INTO hmo_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ranu dekenai idia noho gaudia mai edia taiana lasi bona unana lasi do umui ania lasi, umui dekenai idia taravatu. ");
INSERT INTO hmo_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Inai bamona manu be do umui ania lasi. Idia be miro umui dekenai: Ugava badana, davara ugava bona ugava maragina. ");
INSERT INTO hmo_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Bona bogibada kakakakana bona bogibada koremana. ");
INSERT INTO hmo_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Bona galo, bona ia bamona manu ibounai danu. ");
INSERT INTO hmo_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Bona kokokoko, bona hanuaboi bogibada bona davara bogibada, bona bogibada idauidau ibounai. ");
INSERT INTO hmo_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Baimumu maragina, davara galo, bona baimumu badana. ");
INSERT INTO hmo_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Bona kanage, baimumu kurokurona, bona taunimanima noho lasi tano ena baimumu. ");
INSERT INTO hmo_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Bona noko, bona noko bamona manudia, bona mariboi, bona mariboi bamona manudia. ");
INSERT INTO hmo_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Manumanu ibounai, idia roho gaudia, edia imana bona aena dekena amo tano dekenai raka gaudia do umui ania lasi, idia be miro umui dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","To mai edia hanina bona imana bona aena gaudia haida, edia aena be lata, bona aena dekena amo idia roho lao noho, ");
INSERT INTO hmo_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","unai gaudia be umui ania diba. Unai dainai kwadi idauidau umui ania diba. ");
INSERT INTO hmo_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","To mai edia hanina bona imana bona aena gaudia orena ibounai do umui negea. ");
INSERT INTO hmo_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Inai bamona gaudia ese umui do idia hamiroa. Daika ese edia mase tauanina ia dogoatao, be do ia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Bona edia tauanina do ia abia loaloa tauna be iena dabua do ia huria, bona ia sibona do ia miro ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Mauri gaudia, bema edia aena be auka, to idia parara lasi, o bema edia aniani idia ania lou lasi, be umui dekenai idia miro. Edia mase tauanina ia dogoatao tauna be do ia miro ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Bona edia imana bona aena palapala idia manoka, to imana bona aena dekena amo idia raka gaudia danu be umui dekenai idia miro. Edia mase tauanina ia dogoatao tauna be do ia miro ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Edia tauanina do ia abia loaloa tauna be iena dabua do ia huria, bona ia sibona do ia miro ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Inai bamona mauri gaudia, tano dekenai idia rau gaudia, be umui dekenai idia miro, gaudia be inai: Uda ena pusi, bita badana, bita maragina, ariha, ");
INSERT INTO hmo_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","vaboha, siha, haba dekenai noho ariha. ");
INSERT INTO hmo_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Inai gaudia mai mauri danu, bona mase gaudia danu ia dogoatao tauna be do ia miro ela bona dina ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Bona bema inai rau gaudia idia mase neganai, edia tauanina be gau ta dekenai idia moru neganai, unai gau be ia miro. Sedira unai gau be au, o dabua, o mauri gauna ta ena kopina, o puse dabua, o gaukara totona gauna ta, to unai gau be ranu dekenai do umui udaia, bona ia be miro noho, ela bona dina ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","“Bona bema inai mauri gaudia mirona ta ena mase tauanina be uro ta o hodu ta dekenai ia moru, unai uro o hodu ena anina gaudia danu be do idia miro. Bona umui ese unai uro o hodu do umui hamakohia. ");
INSERT INTO hmo_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","“Unai uro ena aniani o hodu ena ranu, o unai uro ena ranu dekena amo idia nadua aniani be do idia miro. ");
INSERT INTO hmo_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Unai idia mase vadaeni gaudia edia tauanina dekenai idia moru gaudia ibounai be idia miro vadaeni. Bema amu o uro dekenai idia kamokau neganai, unai amu o uro do umui hamakohia. ");
INSERT INTO hmo_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“To bema ranu ia lohilohi gabuna o ranu guri dekenai idia kamokau neganai, unai ranu lohilohi gabuna o ranu guri be ia goeva noho. To tau ta o gau ma ta be unai gaudia edia mase tauanina dekenai idia kamokau neganai idia be miro. ");
INSERT INTO hmo_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","“Bema unai mase gauna ta be do umui hadoa uhena ena latanai ia moru, unai uhe be ia goeva noho. ");
INSERT INTO hmo_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","To bema unai uhe be ranu dekenai umui hapariparia murinai unai mase gauna ta be ia dekenai ia kamokau neganai, unai uhe be ia miro. ");
INSERT INTO hmo_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Sedira mauri gauna ta, umui ania diba gauna ta ia mase, vadaeni bema tau ta ia dogoatao neganai, unai tau be ia miro noho ela bona dina ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Bona bema tau ta ese unai mase gauna ena kahana ta ia ania neganai, ia ese iena dabua do ia huria, bona ia be do ia miro noho ela bona dina ia diho. Unai mase gauna ena tauanina ia huaia tauna danu ese iena dabua be do ia huria, bona ia be do ia miro noho ela bona dina ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Tano dekenai idia rau noho mauri gaudia maragidia do umui negea, do umui ania lasi. ");
INSERT INTO hmo_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Bogana dekenai idia rau, bona imana rua, aena rua dekena amo idia rau gaudia, bona aena momo gaudia, inai bamona tano dekenai idia rau noho gaudia ibounai do umui ania lasi, idia be dika. ");
INSERT INTO hmo_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Tano dekenai idia rau noho gaudia edia dika dekena amo do umui dika lasi, bona edia miro dekena amo do umui miro lasi. ");
INSERT INTO hmo_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","“Badina lau be Lohiabada, umui emui Dirava, unai dainai do umui helaga, badina lau be helaga. Tano dekenai idia rau gaudia edia miro dekenai do umui miro lasi. ");
INSERT INTO hmo_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Lau be Lohiabada, Aigupito tano dekena amo umui lau hakaua mai, emui Dirava do lau lao totona. Unai dainai do umui helaga, badina lau be helaga. ");
INSERT INTO hmo_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Mauri gaudia edia taravatu be unai, tanobada dekenai idia raka loaloa gaudia, bona ataiai idia roho manu, bona davara dekenai idia noho gaudia, bona tano dekenai idia rau gaudia danu. ");
INSERT INTO hmo_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","“Miro gaudia be idau, goeva gaudia danu be idau. Edia idau do umui laloa namonamo. Do umui ania diba gaudia bona do umui ania diba lasi gaudia ena taravatu do umui kamonai henia namonamo.” ");
INSERT INTO hmo_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Israela taudia do oi hamaoroa inai bamona: Hahine ta ia rogorogo, bona mero ta ia abia neganai, ia be dina 7 do ia miro, hua ta ta rara ia karaia neganai bamona. ");
INSERT INTO hmo_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","“Dina namba 8 dekenai, mero ena usina ia koua kopina be do idia utua. ");
INSERT INTO hmo_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Bona do ia goeva totona hahine be dina 33 ma do ia naria, iena rara ia diho noho dainai. Inai dina 33 lalonai hahine ese helaga gaudia do ia dogoatao lasi, bona Palai Dubu do ia raka vareai lasi, vadaeni do ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Bema hahine ese kekeni ta ia havaraia neganai, ia be pura rua do ia miro, hua ta ta rara ia karaia neganai bamona. Bona do ia goeva totona hahine be dina 66 ma do ia naria, iena rara ia diho noho dainai. ");
INSERT INTO hmo_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Iena mero o kekeni dainai do ia goeva totona ia naria dinadia idia ore neganai, hahine be hahelagaia tauna dekenai do ia lao. Hahine ese Lohiabada ena Palai Dubu ena iduara dekenai mamoe natuna, lagani tamona gauna, iena gabua ore boubouna, bona pune ta o manu ta ladana kerea ta, iena kara dika boubouna, do ia mailaia. Unai gau ruaosi be hahelagaia tauna ese do ia abia. ");
INSERT INTO hmo_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","“Vadaeni hahelagaia tauna ese unai boubou gaudia be Lohiabada ena vairanai do ia atoa, unai hahine ena kara dika davana karaia totona, bona iena rara diho ena miro hagoevaia totona. Natuna matamata idia havaraia hahine edia taravatu be unai, mero ia abia, o kekeni ia abia hahine ibounai. ");
INSERT INTO hmo_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Bema hahine ena moni be hegeregere lasi mamoe do ia hoia, ia ese kerea manu rua o pune natuna rua do ia abia, ta gabua ore boubouna, ma ta kara dika boubouna. Vadaeni hahelagaia tauna ese hahine ena kara dika davana do ia karaia, bona ia be do ia goeva momokani.” ");
INSERT INTO hmo_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Lohiabada ese Mose bona Arona ia oda henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Bema tau ta ena kopina do ia gudu, o iohururu, mai toutou kurokuro, lepera ena toana bamona ia abia, unai tau be hahelagaia tauna Arona, o Arona ena natuna tau ta dekenai do idia hakaua vareai. ");
INSERT INTO hmo_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Vadaeni hahelagaia tauna ese unai kopina do ia itaia, bema unai gabu ena huina be kurokuro ia lao, bona bema unai toutou be kopina sibona dekenai lasi to sisina dobu, unai be lepera gorere. Vadaeni unai neganai hahelagaia tauna ese unai tau do ia gwauraia miro. ");
INSERT INTO hmo_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“To bema toutou be kurokuro, to kopina sibona dekenai, bona iena huina be kurokuro lasi, hahelagaia tauna ese taunimanima lasi gabuna dekenai unai tau do ia koua, ela bona dina 7 idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Vadaeni dina namba 7 dekenai, hahelagaia tauna ese unai tau do ia itaia lou. Bema toutou be gabuna dekenai sibona ia noho, ia dika lasi, bona ia bada lasi, hahelagaia tauna ese unai tau do ia koua lou, ela bona dina 7 ma do idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","“Ma dina namba 7 dekenai, hahelagaia tauna ese do ia itaia lou. Bema toutou ia maragi bona dobu lasi, hahelagaia tauna ese unai tau do ia gwauraia goeva, badina unai be toto sibona. Unai tau ese iena dabua do ia huria, vadaeni do ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","To, hahelagaia tauna ese unai tau ia ruhaia murinai, bema unai toutou be ma ia bada lou, ia be hahelagaia tauna dekenai ma do ia giroa lou. ");
INSERT INTO hmo_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Vadaeni hahelagaia tauna ese do ia itaia, toutou be momokani ia bada lou, bona ia ese unai tau do ia gwauraia miro, ia be lepera tauna. ");
INSERT INTO hmo_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Bema lepera ena toana be tau ta ena kopina dekenai ia hedinarai neganai, unai tau be hahelagaia tauna dekenai do idia hakaua vareai. ");
INSERT INTO hmo_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Vadaeni hahelagaia tauna ese unai kopina dekenai toto kurokurona do ia itaia, bona do ia itaia danu, unai toto be mai ena hura, bona toto dekenai noho huina be kurokuro. ");
INSERT INTO hmo_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Unai be lepera ena toto unai tau ena kopina dekenai. Hahelagaia tauna ese unai tau do ia gwauraia miro. Hahelagaia tauna ese unai tau itaia totona do ia koua lou lasi, badina ia be miro momokani. ");
INSERT INTO hmo_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“To bema hahelagaia tauna ia itaia, lepera be kopina ibounai dekenai ia koua, kwarana dekena amo ela bona aena dekenai, ");
INSERT INTO hmo_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ia ese do ia itaia namonamo lou, bona bema momokani kopina ibounai be lepera ese ia koua, ia ese unai tau do ia gwauraia, ia goeva vadaeni. Iena kopina ibounai ia kurokuro dainai, ia be ia goeva vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","“To bema hidio ena bero be tau ta dekenai ia hedinarai, ia be miro. ");
INSERT INTO hmo_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Hahelagaia tauna ese bero do ia itaia lou, vadaeni do ia gwau unai bero be miro. Unai bero be miro ena toana, bona unai tau be lepera tauna. ");
INSERT INTO hmo_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“To inai hidio ena bero bema ia namo lou, bona ia kurokuro lou, unai tau be hahelagaia tauna dekenai ma do ia lao. ");
INSERT INTO hmo_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Hahelagaia tauna ese do ia itaia, bema hidio ena bero ia kurokuro, vadaeni ia ese unai tau do ia gwauraia ia goeva vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Bema tau ta ena kopina dekenai iohururu ia noho, to ia namo lou, ");
INSERT INTO hmo_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","bona bema gabeai unai gabuna dekenai gudu kurokurona toutou o sisina kakakakana do ia hedinarai, unai tau be hahelagaia tauna dekenai do ia hedinaraia. ");
INSERT INTO hmo_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","“Hahelagaia tauna ese unai tau do ia itaia namonamo, bona bema unai toutou be dobu bona unai gabu ena huina be kurokuro, ia ese unai tau do ia gwauraia miro. Inai be lepera gorere, iohururu gabuna dekena amo ia vara. ");
INSERT INTO hmo_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","To bema ia itaia, unai toutou ena huina be kurokuro lasi, bona toutou be kopina sibona dekenai, dobu lasi, bona iena kala be kurokuro lasi, bona kakakaka lasi, hahelagaia tauna ese unai tau do ia koua, ela bona dina 7 idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","“Unai toutou bema ia bada lao, hahelagaia tauna ese unai tau do ia gwauraia miro, unai be lepera gorere. ");
INSERT INTO hmo_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","To bema toutou be idau lasi, bona ia bada lao lasi, unai be iohururu ena kipara sibona, bona hahelagaia tauna ese unai tau do ia gwauraia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Bema tau ta be lahi ese ia gabua, bona bema iena kopina be sisina kakakaka o kurokuro neganai, ");
INSERT INTO hmo_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","hahelagaia tauna ese unai tau do ia itaia namonamo. Bema ia gabua gabuna ena huina be idia kurokuro, bona toutou be dobu sisina, unai be lepera gorere. Lahi ese ia gabua gabuna dekena amo lepera ia vara vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","“To bema ia itaia, unai huina be kurokuro lasi, bona unai toutou be kopina dekenai sibona, bona bema toutou be kurokuro momokani lasi, bona kakakaka momokani lasi neganai, hahelagaia tauna ese unai tau do ia koua, ela bona dina 7 idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Dina namba 7 dekenai, hahelagaia tauna ese do ia itaia lou, bona bema unai toutou ia bada, ia ese unai tau do ia gwauraia miro, unai be lepera gorere. ");
INSERT INTO hmo_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","To bema toutou be idau lasi, bona ia bada lao lasi, bona ia be kurokuro momokani lasi, kakakaka momokani lasi neganai, unai be lahi ena kipara sibona. Hahelagaia tauna ese unai tau do ia gwauraia ia goeva, badina unai be ia gabua gabuna ena kipara sibona. ");
INSERT INTO hmo_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Bema tau ta o hahine ta be mai edia toto edia kwarana o auki huina dekenai, ");
INSERT INTO hmo_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","hahelagaia tauna ese do ia itaia namonamo. Bema unai toto be sisina dobu, bona iena huina be labora, bona sisina kebere neganai, ia ese unai tau o hahine do ia gwauraia miro. Unai be toto dikana, lepera ena toana. ");
INSERT INTO hmo_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","“Bema hahelagaia tauna ia davaria unai toto be ia dobu lasi, to kopina dekenai sibona, to ia itaia danu, huina namodia do noho lasi unai gabu dekenai. Unai neganai ia ese unai tau do ia koua, ela bona dina 7 idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Dina namba 7 dekenai, hahelagaia tauna ese sedira unai toto do ia itaia lou neganai, ia be ia bada lao lasi, bona huina be labora lasi, bona toto be dobu lasi, kopina dekenai sibona. ");
INSERT INTO hmo_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Unai neganai unai tau ese toto ia hagegea huina do ia kakasia ore. Vadaeni hahelagaia tauna ese unai tau ma do ia koua, ela bona dina ma 7 idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","“Dina namba 7 dekenai, hahelagaia tauna ese toto do ia itaia lou. Bema ia davaria toto be ia bada lao lasi, bona ia dobu lasi, to kopina dekenai sibona, ia ese unai tau do ia gwauraia goeva. Unai tau ese iena dabua do ia huria, vadaeni ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","To bema hahelagaia tauna ia gwauraia goeva murinai unai toto ia bada lao neganai, ");
INSERT INTO hmo_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","hahelagaia tauna ese do ia itaia lou. Bema ia itaia, momokani toto ia bada lao vadaeni, ia ese hui labora do ia tahua lasi, badina unai tau be momokani ia miro. ");
INSERT INTO hmo_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","“To bema hahelagaia tauna ia laloa toto ia bada lao lasi, bona hui namodia be toto lalonai idia tubu noho, unai anina be toto ia namo vadaeni. Unai neganai hahelagaia tauna ese unai tau do ia gwauraia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Bema tau ta o hahine ta ena kopina dekenai toutou kurokurodia idia hedinarai neganai, ");
INSERT INTO hmo_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","hahelagaia tauna ese unai tau o hahine do ia itaia. Bema toutou be kurokuro momokani lasi, unai be kopina ena latanai gorere sibona. Unai tau o hahine be ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Bema tau ta ena huina ia boio, ia kebere, ia be ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Bema iena baguna dekenai o iena kwarana murina kahana dekenai iena huina ia boio, unai be kebere sibona, ia be ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","“To bema unai kebere gabuna dekenai toutou sisina kakakakana ta ia hedinarai, unai be lepera, unai tau ena baguna, o iena kwarana murina kahanai ia vara. ");
INSERT INTO hmo_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Hahelagaia tauna ese unai tau do ia itaia, bona bema toto sisina kakakakana ia davaria, ");
INSERT INTO hmo_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ia ese unai tau do ia gwauraia miro, lepera gorere be iena kwarana dekenai dainai. ");
INSERT INTO hmo_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Lepera tauna be dabua gunadia, darea gaudia do ia karaia, bona iena huina do ia duaria lasi, bona iena vairana ena henuna kahana be dabua dekenai do ia koua, do ia boiboi, do ia gwau, ‘Miro, miro!’ ");
INSERT INTO hmo_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Lepera tauna ena gorere dinadia ibounai lalonai be do ia miro noho. Ia be sibona do ia noho. Taunimanima dekena amo do ia noho siri, kamepa ena murimurina dekenai.” ");
INSERT INTO hmo_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Dabua manokana, mamoe huina gauna, o dabua aukana dekenai lepera gorere ena miro ia noho, ");
INSERT INTO hmo_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","o dabua hatua totona varo dekenai, kotoni o mamoe huina o boromakau kopina dekenai, o boromakau dekena amo karaia gauna ta dekenai, ");
INSERT INTO hmo_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","bema gorere ena toana gadokagadoka o kakakaka be dabua dekenai, o dabua ena varo dekenai, o boromakau kopina, o boromakau kopina dekena amo karaia gauna dekenai do ia hedinarai, unai be lepera gorere, bona hahelagaia tauna dekenai do umui hedinaraia. ");
INSERT INTO hmo_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","“Hahelagaia tauna ese dabua o kopina do ia itaia, bona unai dabua o kopina be gabu ta dekenai do ia atoa siri, ela bona dina 7 idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Dina namba 7 dekenai, ia ese unai dabua o kopina do ia itaia lou, bona bema unai gorere toana ia bada lao, unai be lepera momokani, bona unai dabua o kopina be miro. ");
INSERT INTO hmo_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Hahelagaia tauna ese unai dabua o kopina do ia gabua ore, badina unai be lepera korikori, unai dainai lahi dekenai do idia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“To bema hahelagaia tauna ese unai gauna ia itaia neganai unai gorere toana ia bada lao lasi, ");
INSERT INTO hmo_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ia ese oda do ia gwauraia unai gauna do idia huria, bona dina 7 ma gabu ta dekenai do idia atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","“Vadaeni hahelagaia tauna ese idia huria gauna ma do ia itaia lou, bona bema gorere toana ena kala be idau lasi, bona ia be ia bada lao lasi, to unai gauna be ia do miro. Lahi dekenai do umui gabua ore. Sedira unai gorere toana be dabua ena murina kahana dekenai, o dabua ena lalona kahana dekenai, to do umui gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“To bema hahelagaia tauna ese ia itaia, idia huria murinai gorere toana ena kala ia ore lao, ia ese unai gorere toana gabuna be dabua o kopina dekena amo do ia darea oho, do ia kokia. ");
INSERT INTO hmo_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Unai murinai bema unai dabua o kopina dekenai unai gorere toana ia hedinarai lou, unai be lepera ma ia vara lou ena toana. Vadaeni unai gau be iena biaguna ese do ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Bema unai gau ia huria, bona unai gorere toana ia hedinarai lou lasi, ia ese do ia huria lou, vadaeni unai gauna be do ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Dabua manokana, mamoe huina gauna, o dabua aukana, o dabua hatua totona varona, o boromakau kopina dekena amo karaia gauna ta, lepera gorere ese do ia hamiroa taravatu be unai. Unai bamona do umui diba, idia be goeva o miro.” ");
INSERT INTO hmo_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Lohiabada ese Mose ia oda henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Lepera tauna hagoevaia dinana ena taravatu be inai: Hahelagaia tauna dekenai do idia hakaua lao. ");
INSERT INTO hmo_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Vadaeni hahelagaia tauna ese lepera tauna kamepa ena murimurina dekenai do ia abia lao, do ia itaia, iena lepera gorere ia ore vadaeni, o lasi. ");
INSERT INTO hmo_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","“Bema gorere ia ore, hahelagaia tauna ese do ia oda henia, lepera tauna hagoevaia totona manu rua, goeva momokani gaudia, bona mauri gaudia do idia mailaia, sida au maragina ta, bona varo kakakakana ta, bona husopo rigina ta danu do idia mailaia. ");
INSERT INTO hmo_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Vadaeni hahelagaia tauna do ia oda, manu ta be uro ena ataiai do idia alaia mase. Uro lalonai be ranu goeva ia noho. ");
INSERT INTO hmo_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Hahelagaia tauna ese do mauri manuna do ia abia, sida auna bona varo kakakaka bona husopo rigina danu do ia abia. Inai gau ibounai be ranu goeva ena ataiai ia hamasea vadaeni manu ena rara lalonai do ia atodia diho. ");
INSERT INTO hmo_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","“Unai rara do ia abia, bona lepera dekena amo do ia hagoevaia tauna dekenai unai rara do ia negea, nega 7, vadaeni ia ese unai tau do ia gwauraia goeva. Bona hahelagaia tauna ese unai do mauri manuna do ia ruhaia, do ia roho lao hanua ena murimurinai, uda dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Vadaeni ia goeva vadaeni tauna ese iena dabua do ia huria, bona iena huina ibounai do ia kakasia ore, bona do ia digu. Unai neganai do ia goeva. Unai murinai ia be kamepa lalonai do ia raka vareai diba, to iena palai ruma ena murimurinai do ia noho ela bona dina 7 idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","“Dina namba 7 dekenai, ia ese iena huina ibounai, kwarana huina, bona aukina huina bona matana ena ataiai huina do ia kakasia ore lou. Iena dabua do ia huria lou, bona do ia digu. Unai murinai ia be goeva momokani. ");
INSERT INTO hmo_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Dina namba 8 dekenai, mamoe natuna tau rua, toto lasi bona bero lasi gaudia, bona mamoe natuna hahine ta, lagani tamona gauna, toto lasi bona bero lasi gauna do ia mailaia. Bona paraoa namo herea, ena metau kilogaram toi, olive dehoro danu mikisi gauna, bona olive dehoro, ena bada kapusi tamona danu do ia mailaia. ");
INSERT INTO hmo_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Hahelagaia tauna ese unai do ia hagoevaia tauna be do ia hakaua lao, mai ena boubou gaudia danu, Lohiabada ena Palai Dubu ena iduara dekenai do ia haginia, Lohiabada ena vairanai. ");
INSERT INTO hmo_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Vadaeni hahelagaia tauna ese mamoe natudia tau ta do ia abia, ia be kara dika boubouna do ia lao, olive dehoro kapusi ta danu. Unai gaudia ruaosi Lohiabada ena vairanai do ia davea. Unai be kerere totona boubouna Lohiabada dekenai ia henia ena toana. ");
INSERT INTO hmo_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Hahelagaia tauna ese unai mamoe natuna tau do ia alaia mase gabu helagana ta dekenai, kara dika boubouna bona gabua ore boubouna idia alaia mase gabuna be unai. Unai bamona do ia karaia, badina be kerere totona boubouna be kara dika totona boubouna bamona. Inai boubou ruaosi be hahelagaia tauna ena. Unai dainai inai boubou be helaga herea. ");
INSERT INTO hmo_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“Vadaeni hahelagaia tauna ese unai mamoe natuna ena rara haida do ia abia, bona unai do ia hagoevaia tauna ena taia idibana rini atoa gabuna, iena ima kwakikwaki badana idibana, bona iena ae kwakikwaki badana idibana dekenai unai rara do ia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","“Hahelagaia tauna ese olive dehoro sisina sibona iena imana laurina dekenai do ia bubua. ");
INSERT INTO hmo_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Iena ima kwakikwakina idibana be olive dehoro lalonai do ia atoa, bona nega 7 unai olive dehoro haida do ia negea lao, bona lau, Lohiabada ese do lau itaia. ");
INSERT INTO hmo_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","“Hahelagaia tauna ese iena imana idibana dekenai olive dehoro bona mamoe ena rarana sisina unai do ia hagoevaia tauna ena taia idibana rini atoa gabuna, bona ima kwakikwaki badana idibana, bona ae kwakikwakina badana idibana dekenai do ia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Olive dehoro orena, iena imana dekenai do noho gauna, be unai tau ena kwarana dekenai do ia atoa. Inai dala dekenai hahelagaia tauna ese unai tau ena kara dika davana do ia karaia, Lohiabada ena vairanai. ");
INSERT INTO hmo_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Hahelagaia tauna ese kara dika totona boubou gauna do ia alaia mase, unai do ia hagoevaia tauna ena kara dika davana karaia totona, bona iena miro hagoevaia totona. Unai murinai, ia gabua ore totona mamoe boubou gauna do ia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Hahelagaia tauna ese unai gabua ore gauna bona paraoa boubouna do ia gabua, boubou patana ena latanai, lahi ese do ia gabudia ore. Unai dala dekenai hahelagaia tauna ese unai tau ena kara dika davana do ia karaia, bona unai tau be ia goeva vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Bema tau ta ia ogogami dainai, unai gaudia ibounai ia hoia diba lasi neganai, ia ese mamoe natuna tau tamona sibona do ia abia, do ia goeva totona. Unai mamoe be iena kerere gwauatao totona boubou gauna. Unai be hahelagaia tauna ese Lohiabada ena vairanai do ia davea, bona unai tau ena kerere davana do ia karaia. Paraoa ena metau kilogaram tamona, bona olive dehoro kapusi tamona danu unai tau do ia mailaia. ");
INSERT INTO hmo_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","“Manu ta ladana kerea rua o pune natuna rua, iena moni hegeregerena gaudia, danu do ia mailaia, ta be kara dika boubouna, bona ta be gabua ore boubouna. ");
INSERT INTO hmo_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Ia goeva dinadia namba 8 dekenai, unai tau ese inai manu ruaosi Palai Dubu ena iduara dekenai do ia mailaia, hahelagaia tauna ese do ia hagoevaia totona. ");
INSERT INTO hmo_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Hahelagaia tauna ese kerere totona mamoe bona olive dehoro do ia abia, bona Lohiabada ena vairanai do ia davea, do ia henia ena toana. ");
INSERT INTO hmo_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","“Ia ese mamoe do ia alaia mase, bona mamoe ena rarana sisina do ia abia, unai tau ena taiana idibana ena rini atoa gabuna dekenai, iena ima kwakikwaki badana idibana dekenai, bona iena ae kwakikwaki badana idibana dekenai unai rara do ia atoa. ");
INSERT INTO hmo_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Hahelagaia tauna ese dehoro haida iena imana laurina dekenai do ia bubua, ");
INSERT INTO hmo_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","bona iena ima kwakikwakina idibana ta dekena amo unai olive dehoro do ia negea lao, nega 7, bona lau Lohiabada ese do lau itaia. ");
INSERT INTO hmo_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","“Vadaeni hahelagaia tauna ese olive dehoro, iena imana dekenai do noho gauna do ia abia, unai ia hagoevaia tauna ena taia idibana ena rini atoa gabuna, bona ima kwakikwaki badana idibana, bona ae kwakikwaki badana idibana dekenai unai olive dehoro dekenai do ia dahua, kerere totona mamoe ena rarana ia atoa gabudia. ");
INSERT INTO hmo_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","To olive dehoro orena, hahelagaia tauna ena imana dekenai do noho gauna, be unai tau ena kwarana dekenai do ia atoa. Inai dala dekenai hahelagaia tauna ese unai tau ena kara dika davana do ia karaia, Lohiabada ena vairanai. ");
INSERT INTO hmo_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“Unai neganai hahelagaia tauna ese unai kerea manu rua o pune natuna rua, unai tau ena moni hegeregerena gaudia, do ia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ta be kara dika boubouna totona, ma ta be gabua ore boubouna totona, paraoa boubouna danu. Inai bamona dala dekenai hahelagaia tauna ese unai do ia hagoevaia tauna ena kara dika davana do ia karaia, Lohiabada ena vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Lepera tauna, bema iena moni be hegeregere lasi, ia ese hagoevaia totona gaudia korikori ia hoia diba lasi. Unai bamona tauna durua totona taravatu be inai.” ");
INSERT INTO hmo_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Lohiabada ese Mose bona Arona ma ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Lau ese umui lau henia, emui tano korikori, ladana Kanana dekenai umui ginidae neganai, sedira ruma ta dekenai lepera gorere do lau atoa. ");
INSERT INTO hmo_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","“Unai bamona neganai, ruma ena biaguna be hahelagaia tauna dekenai do ia lao, do ia gwau, ‘Lau laloa lepera bamona gorere be egu ruma dekenai ia noho.’ ");
INSERT INTO hmo_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Vadaeni hahelagaia tauna ese do ia oda henia, ruma gaudia ibounai be ruma dekena amo do idia huaia murimuri dekenai. Bema lasi, sedira hahelagaia tauna do ia raka vareai neganai, ia ese ruma gaudia ibounai do ia gwauraia miro. Vadaeni hahelagaia tauna be ruma do ia raka vareai, ruma do ia itaia. ");
INSERT INTO hmo_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","“Ia ese gorere toana do ia itaia, bema ruma ena haba be mai ena toutou gadokagadoka o kakakaka, bona bema toutou be haba kopina dekenai sibona lasi, to sisina dobu, ");
INSERT INTO hmo_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","hahelagaia tauna be ruma ena iduara dekena amo do ia raka murimurinai, bona ruma do ia loka, ela bona dina 7 idia ore. ");
INSERT INTO hmo_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","“Dina namba 7 dekenai, hahelagaia tauna ese ma do ia lao, do ia itaia, ruma ena haba dekenai toutou ia bada lao o lasi. Bema unai toutou be ia bada lao vadaeni, ");
INSERT INTO hmo_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","hahelagaia tauna ese oda do ia gwauraia, unai haba ena nadi mai edia toutou do idia kokia, hanua ena murimurinai do idia negea, momoru gabuna dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ruma ena lalona kahana ibounai danu do idia kakasia, bona do idia kakasia lao momoru danu be hanua ena murimurinai do idia negea, miro gaudia idia negea gabuna dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","“Vadaeni nadi matamatadia do idia abia, idia kokia gaudia edia gabu dekenai do idia atoa. Unai murinai ruma ena lalona kahana ibounai be peni aukana dekena amo do idia penia bona koua. ");
INSERT INTO hmo_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Bema unai nadi idia kokia, bona ruma ena lalona do idia kakasia, bona peni aukana dekena amo idia penia bona koua namonamo murinai unai gorere ena toana ma ia hedinarai lou, ");
INSERT INTO hmo_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","hahelagaia tauna ese do ia itaia lou. Bema unai gorere toana be ia bada lao, ruma ena lalona dekenai, unai be lepera korikori, ia ese ruma ia hadikaia noho, bona unai ruma be ia miro. ");
INSERT INTO hmo_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","“Inai ruma be do idia veria diho, bona iena nadi, iena au, bona iena haba koua peni, be hanua ena murimurinai do idia huaia lao, momoru gabuna dekenai do idia negea. ");
INSERT INTO hmo_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Daika ese ruma lalonai ia raka vareai, hahelagaia tauna ia loka murinai, ia be do ia miro ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Unai ruma dekenai ia hekure, o ia aniani tauna ese iena dabua do ia huria. ");
INSERT INTO hmo_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“To sedira hahelagaia tauna do ia raka vareai neganai ia itaia, peni auka matamata dekena amo haba idia penia bona koua murinai gorere toana ia hedinarai lou lasi. Unai neganai hahelagaia tauna ese ruma do ia gwauraia goeva, badina gorere be ia ore vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Bona unai ruma do ia hagoevaia totona, ia ese manu rua bona sida au maragina ta, varo kakakakana, bona husopo rigina ta do ia abia. ");
INSERT INTO hmo_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Vadaeni hahelagaia tauna ese manu ta uro ta ena ataiai do ia alaia mase. Uro lalonai be ranu goeva ia noho. ");
INSERT INTO hmo_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ia ese do mauri manuna do ia abia, sida auna bona varo kakakaka bona husopo rigina danu do ia abia. Inai gau ibounai be ranu goeva ena ataiai ia hamasea vadaeni manu ena rara lalonai do ia atodia diho. Bona unai rara be ruma dekenai do ia negea, nega 7. ");
INSERT INTO hmo_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","“Inai dala dekenai ia ese ruma do ia hagoevaia, manu ena rarana dekena amo, bona ranu goeva dekena amo, bona ia mauri manuna dekena amo, bona sida auna dekena amo, bona husopo rigina dekena amo, bona varo kakakakana dekena amo. ");
INSERT INTO hmo_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","“Vadaeni ia mauri manuna be do ia ruhaia, hanua ena murimurinai do ia roho lao, uda dekenai. Unai dala dekenai ia ese unai ruma dekena amo kara dika do ia kokia, vadaeni ruma be ia goeva vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“Lepera bona taunimanima edia kopina dekenai idia vara gorere idauidau edia taravatu be inai. ");
INSERT INTO hmo_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Bona dabua bona ruma dekenai idia noho lepera ena miro ese ia hadikadia taravatu danu. ");
INSERT INTO hmo_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Bona kopina ia gudu, bona toto, bona kopina toutou, ena kala be idau, ena taravatu danu. ");
INSERT INTO hmo_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Inai taravatu dekena amo do umui diba, miro gauna be edena bamona, bona goeva gauna be edena bamona. Lepera gorere ena taravatu be unai.” ");
INSERT INTO hmo_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Lohiabada ese Mose bona Arona dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Israela taudia do umui hamaoroa, inai taravatu do idia badinaia: Bema tau ta ena usina dekena amo hura bamona ia bubua diho neganai, inai gauna ese unai tau ia hamiroa. ");
INSERT INTO hmo_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Sedira unai hura bamona ia bubua noho, o hura ese usina ia koua, to unai tau ia miro noho. ");
INSERT INTO hmo_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“Iena mahuta patana o geda be idia miro, bona ia ese idia edia latanai ia helai gaudia ibounai danu idia miro. ");
INSERT INTO hmo_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Unai tau ena mahuta patana o geda ia dogoatao tauna ese iena dabua do ia huria, bona ranu dekenai do ia digu, bona do ia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","“Gorere tauna ena helai gaudia dekenai do ia helai tauna danu ese iena dabua do ia huria, bona do ia digu, bona do ia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Gorere tauna ena kopina do ia dogoatao tauna danu ese iena dabua do ia huria, bona do ia digu, bona do ia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“Gorere tauna ese bema goeva tauna dekenai do ia kanudi, unai goeva tauna ese iena dabua do ia huria, bona do ia digu, bona do ia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Hosi ena doruna dekenai helai gauna ena latanai bema gorere tauna ia helai neganai, unai helai gauna be ia miro. ");
INSERT INTO hmo_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","“Gorere tauna ena henunai ia noho gauna ta, bema tau ta ese do ia dogoatao, ia be do ia miro noho ela bona dina do ia diho. Oibe, bona unai gauna ia abia loaloa tauna ese iena dabua do ia huria, bona sibona do ia digu, bona do ia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Gorere tauna bema iena imana be ranu dekenai ia huria lasi, to ia ese tau ta do ia dogoatao neganai, unai tau ese iena dabua do ia huria, bona do ia digu, bona do ia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Gorere tauna ese do ia dogoatao urona be do idia hamakohia, bona do ia dogoatao disi be ranu dekenai do idia huria. ");
INSERT INTO hmo_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Tau ena usina gorere ia ore neganai, ia be dina ibounai 7 do ia naria ela bona ia goeva. Ia ese iena dabua do ia huria, bona ia sibona do ia digu, vadaeni unai murinai do ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","“Dina namba 8 dekenai ia ese kerea manu rua o pune natuna rua do ia abia, Lohiabada ena vairanai do ia mailaia, Palai Dubu ena iduara dekenai, bona hahelagaia tauna dekenai do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Vadaeni hahelagaia tauna ese manu ta be kara dika boubouna totona do ia alaia mase, bona manu ta be gabua ore boubouna totona do ia alaia mase. Unai dala dekenai, hahelagaia tauna ese unai tau ena kara dika davana do ia karaia, Lohiabada ena vairana dekenai, ena hura bubua dainai. ");
INSERT INTO hmo_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Bema tau ta dekena amo vesi ia bubua neganai, ia be ranu dekenai do ia digu, iena tauanina ibounai do ia huria, bona do ia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Vesi be dabua dekenai o kopina dabua dekenai bema ia bubua neganai, unai dabua o kopina ibounai do idia huria, bona idia be miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","“Bema tau ta ese hahine ta danu do idia mahuta hebou, vadaeni vesi do ia bubua, idia ruaosi do idia digu, bona do idia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Bema hahine ta rara ia karaia, iena hua rara, ia be dina 7 lalonai do ia miro. Bona bema taunimanima ta ese unai hahine dekenai ia kamokau neganai, unai taunimanima be do ia miro noho ela bona dina ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Unai hahine ena rara neganai, ia helai o ia hekure latanai gaudia be idia miro noho. ");
INSERT INTO hmo_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Hahine ena mahuta patana o geda ia dogoatao tauna ese iena dabua do ia huria, bona sibona do ia digu, bona do ia miro noho ela bona dina ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Hahine ena helai gauna ia dogoatao tauna ese iena dabua do ia huria, bona ranu dekenai do ia digu, bona do ia miro noho ela bona dina ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","“Hahine ena mahuta dabua gauna ta o iena helai gauna ta be tau ta ese ia dogoatao neganai, unai tau be do ia miro ela bona dina ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Tau ta bema unai rara ia karaia noho hahine danu idia sihari neganai, bona hahine ena rara be tau dekenai ia kamokau, unai tau be do ia miro ela bona dina 7 idia ore. Bona edia latanai ia mahuta pata o geda danu be idia miro. ");
INSERT INTO hmo_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Bema hahine ta ena rara kara dinadia be momo, bona ena rara kara negana korikori lasi, o bema ena nega korikori dekenai, to daudau herea, unai hahine be do ia miro noho, ela bona unai rara kara do ia doko. Ia be do ia miro noho, iena hua rara ena nega dekenai ia miro noho hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","“Unai dainai iena mahuta pata bona geda ibounai be miro, iena hua rara nega korikori negana hegeregere, bona do ia helai latanai gaudia do idia miro, iena hua rara nega korikori negana hegeregere. ");
INSERT INTO hmo_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","“Unai gaudia do ia dogoatao tauna danu be do ia miro, bona iena dabua do ia huria, bona do ia digu, bona do ia miro noho ela bona dina do ia diho. ");
INSERT INTO hmo_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","To bema hahine ena rara kara do ia doko neganai, ia ese dina 7 do ia naria, vadaeni do ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","“Dina namba 8 dekenai, hahine ese kerea manu rua o pune natuna rua do ia abia, hahelagaia tauna dekenai do ia mailaia, Palai Dubu ena iduara dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Hahelagaia tauna ese manu ta be kara dika boubouna totona do ia alaia mase, bona manu ta be gabua ore boubouna totona do ia alaia mase. Unai dala dekenai hahelagaia tauna ese unai hahine ena kara dika davana do ia karaia, Lohiabada ena vairana dekenai, iena rara kara dainai.” ");
INSERT INTO hmo_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Inai dala dekenai Lohiabada ese Mose ia hamaoroa, ia ese Israela taudia do ia sisiba henidia edia miro do idia naria namonamo, vadaeni Lohiabada ena Palai Dubu do idia hamiroa lasi. Palai Dubu be edia kamepa ena huanai ia noho, bona bema idia hamiroa neganai, do idia mase. ");
INSERT INTO hmo_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Inai taravatu be tau ta ena usina dekena amo hura bamona ia bubua noho, bona tau ta ena vesi bema ia bubua neganai hagoevaia dalana. ");
INSERT INTO hmo_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Ma inai taravatu be hahine ta ena rara kara totona, bona tau ta totona, bema hahine mai mirona danu do idia mahuta hebou neganai. ");
INSERT INTO hmo_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Dina ta Arona ena natuna ruaosi ese boubou, helaga lasi gauna Lohiabada ena vairanai dekenai idia atoa. Unai dainai ruaosi idia mase. Unai murinai Lohiabada ese Mose dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Oiemu kakana Arona do oi hamaoroa, ia be nega ibounai Helaga Herea Gabuna, koua dabua helagana murinai gabuna do ia vareai lasi. To lau ese lau gwauraia negana sibona do ia vareai. Badina lau be ori lalonai lau hedinarai noho, Taravatu Maua ena koua gauna ena atai dekenai. Bema unai Gabu ia vareai kava neganai do lau alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“To Arona be Helaga Herea Gabuna ia raka vareai neganai, ia be inai bamona do ia karaia: Boromakau ena natuna tau ta do ia mailaia, kara dika kokia boubouna totona. Bona mamoe tau ta do ia mailaia, ia gabua boubouna totona.” ");
INSERT INTO hmo_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ma Lohiabada ia hadibaia, ia gwau, “Arona be Helaga Herea Gabuna do ia raka vareai gwauraia neganai, do ia digu namonamo, bona hahelagaia tauna ena dabua korikori do ia karaia. Gaudia be inai: Kouti helagana, piripou, gaba gauna, bona kwara gauna, ibounai dabua namo herea gaudia. ");
INSERT INTO hmo_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Bona Israela taudia ese boubou gaudia Arona dekenai do idia henia, boubou helaga do ia karaia totona, gaudia be inai: Nani tau rua, kara dika kokia boubouna totona. Bona mamoe tau tamona, ia gabua boubouna totona. ");
INSERT INTO hmo_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Arona ese sibona ena kara dika totona bona iena famili totona boromakau ta do ia alaia, do ia bouboulaia. ");
INSERT INTO hmo_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Unai murinai ia ese unai nani tau ruaosi do ia abia, Lohiabada ena vairana dekenai do ia atodia, Palai Dubu ena iduara dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Vadaeni Arona ese nadi rua do ia abia, ta do ia makaia, Lohiabada ena, ta do ia makaia, Asasele ena, bona idia ta do ia abia hidi laki dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Vadaeni nani tau ta, laki dekenai ia davaria gauna, be Lohiabada ena, Arona ese do ia alaia mase, kara dika kokia boubouna totona. ");
INSERT INTO hmo_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","To nani tau iharuana, laki dekenai ia davaria, be Asasele ena, Arona ese do ia alaia lasi. Arona be unai nani mai mauri danu do ia hakaua Lohiabada ena vairana dekenai. Unai murinai Asasele ena nani be taunimanima noho lasi gabuna dekenai do ia siaia lao, taunimanima edia kara dika do ia kokia totona. Asasele ena nani be taunimanima noho lasi gabuna dekenai do ia noho. ");
INSERT INTO hmo_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Arona be inai bamona do ia karaia danu: Boromakau tau be boubou totona do ia alaia mase, ia sibona ena kara dika dainai, bona iena famili taudia edia kara dika dainai. ");
INSERT INTO hmo_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Unai murinai Arona ese boubou patana ena lahi dekena amo gida do ia abia, auri kapusi dekenai do ia udaia, ela bona unai auri kapusi ia honu. Bona muramura mai bonana, ia hamakohia maragimaragi gauna, be iena imana dekenai do ia abia, Helaga Herea Gabuna lalonai do ia abia vareai. ");
INSERT INTO hmo_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Vadaeni unai muramura mai bonana be gida latanai do ia bubua, Lohiabada ena vairanai, ela bona muramura mai bonana ena kwalahuna ese Taravatu Maua ena koua gauna do ia koua momokani, Arona ese do ia itaia bona mase garina. (Unai Maua lalonai be Taravatu Nadidia idia noho.) ");
INSERT INTO hmo_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Unai neganai Arona ese boromakau ena rarana sisina do ia abia, bona iena imana kwakikwakina dekena amo unai rara be Taravatu Maua ena koua gauna ena latanai, dina daekau ena kahanai do ia negea. Maua ena vairana kahanai danu do ia negea, nega 7. ");
INSERT INTO hmo_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Unai murinai Arona ese taunimanima edia kara dika kokia boubouna ena nani do ia alaia mase. Unai nani ena rarana be Helaga Herea Gabuna lalonai do ia abia vareai. Bona unai rara be Taravatu Maua ena koua gauna ena latanai bona ena vairanai do ia negea, boromakau ena rarana ia negea hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Inai dala dekenai Arona ese Helaga Herea Gabuna do ia hagoevaia, Israela taudia edia miro bona edia kara dika dainai. “Oibe, unai bamona be Palai Dubu do ia hagoevaia, badina be Palai Dubu be kamepa ena huanai momokani ia noho, miro taudia edia noho gabuna. ");
INSERT INTO hmo_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Unai hagoevaia kara neganai, tau ta ese Palai Dubu do ia raka vareai lasi, Arona sibona. Arona ese Helaga Herea Gabuna hagoevaia totona do ia raka vareai, bona ia sibona, iena famili, bona Israela taudia ibounai hagoevaia totona gaukara do ia karaia haorea. Unai murinai sibona, be taunimanima ma do idia raka vareai diba. ");
INSERT INTO hmo_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Helaga Herea Gabuna ia rakatania murinai, Arona ese boubou patana do ia hagoevaia, Lohiabada ena vairanai. Arona ese boromakau ena rarana sisina bona nani ena rarana sisina do ia abia, boubou patana ena doana ibounai rara dekena amo do ia dahua. ");
INSERT INTO hmo_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Bona iena imana kwakikwakina dekenai unai rara be boubou patana dekenai do ia negea, nega 7. Inai dala dekenai Arona ese boubou patana do ia hagoevaia, Israela taudia edia kara dika dekena amo, bona do ia hahelagaia danu. ");
INSERT INTO hmo_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Helaga Herea Gabuna bona Palai Dubu bona boubou patana ia hagoevaia murinai Arona ese nani, mauri gauna, Asasele dekenai ia abia hidi gauna, be Lohiabada dekenai do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Arona ese iena imana ruaosi nani ena kwarana dekenai do ia atoa, bona Israela edia kara dika ibounai, bona edia kara kerere ibounai do ia gwauraia hedinarai. Unai dika ibounai be nani ena kwarana latanai do ia atoa. Vadaeni taunimanima idia noho lasi gabuna dekenai unai nani do ia siaia lao. Tau ta unai gaukara totona idia abia hidi tauna ese unai nani do ia hakaua lao, bona taunimanima lasi gabuna dekenai do ia ruhaia. ");
INSERT INTO hmo_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","“Inai nani ese Israela taudia edia kara dika ibounai taunimanima lasi gabuna dekenai do ia huaia lao, ia boio. ");
INSERT INTO hmo_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Unai murinai Arona be Palai Dubu lalonai ma do ia raka vareai, dabua namo herea, Helaga Herea Gabunai ia raka vareai neganai ia karaia gaudia, do ia kokia, Palai Dubu lalonai do ia rakatania. ");
INSERT INTO hmo_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Vadaeni gabu helagana ta dekenai do ia digu. Unai murinai sibona ena dabua ma do ia karaia lou, vadaeni murimurina dekenai do ia mai. Unai neganai ia sibona ena dika kokia totona ia gabua boubouna do ia henia, bona Israela taudia edia dika kokia totona ia gabua boubouna do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Kara dika kokia totona boubouna ia karaia neganai, ia gabua boromakau ena digarana be boubou patana ena latanai do ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Unai Asasele ena nani ia hakaua lao tauna ese iena dabua do ia huria, bona ia be do ia digu. Unai murinai ia be kamepa dekenai ma do ia raka vareai diba. ");
INSERT INTO hmo_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Unai kara dika kokia totona boromakau bona nani, edia rarana be Helaga Herea Gabuna ia abia vareai gaudia. Idia be kamepa ena murimuri dekenai do idia abia lao. Unuseni edia kopina bona edia hidiona bona edia kukuri be lahi dekenai do idia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ia gabudia ore tauna ese iena dabua do ia huria, bona ia be do ia digu. Unai murinai ia be kamepa dekenai ma do ia raka vareai diba. ");
INSERT INTO hmo_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Inai taravatu be umui emui latanai lagani ibounai hanaihanai do ia noho: Hua namba 7 ena dina namba 10 dekenai Israela taudia bona idia dekenai idia noho idau taudia ese aniani do idia ania lasi, bona gaukara do idia karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Badina be unai dina dekenai be hahelagaia tauna ta ese idia edia kara dika ibounai edia davana do ia karaia, Lohiabada ena vairanai do idia goeva totona. ");
INSERT INTO hmo_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Unai dina be helaga herea umui dekenai, unai dainai do umui aniani lasi bona gaukara lasi. Inai taravatu be lagani ibounai hanaihanai do umui badinaia. ");
INSERT INTO hmo_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Hahelagaia Tauna Badana, iena tamana ena gabuna dekenai idia hasiahua bona hahelagaia tauna ese inai kara dika dekena amo hagoevaia karana do ia karaia. Ia ese hahelagaia kara ena dabuadia do ia karaia. ");
INSERT INTO hmo_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ia ese Helaga Herea Gabuna bona Palai Dubu bona boubou patana do ia hagoevaia. Bona ia ese hahelagaia taudia, bona oiemu orea taudia ibounai edia kara dika davana do ia karaia. ");
INSERT INTO hmo_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Inai taravatu be umui dekenai do ia noho hanaihanai. Inai kara dika davana karaia karana, be lagani ta ta ibounai Hahelagaia Tauna Badana ese do ia karaia, Israela taudia edia kara dika ibounai dekena amo, idia do ia hagoevaia totona.” Vadaeni Mose ese Lohiabada ena oda gauna hegeregerena ia karaia. ");
INSERT INTO hmo_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Arona mai ena natuna tau bona Israela taudia ibounai do oi hamaoroa Lohiabada ena oda be inai: ");
INSERT INTO hmo_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Bema Israela tauna ta ese Lohiabada henia totona boromakau tau, o mamoe natuna o nanigosi do ia alaia mase kamepa ena murimurinai, ");
INSERT INTO hmo_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","to Palai Dubu ena iduara dekenai ia mailaia lasi, bona Lohiabada ena vairana dekenai unai boubou ia henia lasi, unai tau ese taravatu ia utua vadaeni. Ia ese rara ia habubua kava dainai, iena bese taudia dekena amo unai tau do lau atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","“Inai taravatu ena anina be inai: Guna Israela taudia ese edia boubou gaudia be kamepa ena murimurinai idia alaia mase. To hari lau oda inai, idia ese unai boubou gaudia mai mauri danu Lohiabada henia totona, hahelagaia tauna dekenai do idia mailaia, Palai Dubu ena iduara dekenai. Unuseni edia boubou gaudia, Lohiabada danu maino karaia bouboudia do idia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Hahelagaia tauna ese boubou gauna ena rarana do ia abia, Lohiabada ena boubou patana dekenai unai rara do ia negea, Palai Dubu ena iduara kahirakahira, bona boubou ena digara do ia gabua ore, bona unai bonana do ia namo herea lau Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","“Unai dainai Israela taudia ese dirava koikoi gaudia dekenai boubou do idia henia lou lasi. Idia ese unai bamona lau do idia rakatania lou lasi. Inai taravatu be noho hanaihanai taravatuna, idia, bona idia edia natuna, tubuna taudia ibounai edia latanai. ");
INSERT INTO hmo_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Do oi hamaorodia danu: Israela tauna ta, o idau bese tauna ta, bema gabua ore boubouna o idau boubouna ta be idau gabuna dekenai do ia alaia mase, ");
INSERT INTO hmo_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","to Palai Dubu ena iduara dekenai ia mailaia lasi, Lohiabada ena boubou gauna totona, unai tau be iena bese dekena amo do lau atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Bema Israela tauna ta o idau bese tauna, Israela dekenai ia noho, ese vamu mai ena rara danu do ia ania, lau ese unai tau do lau badu henia, ia be iena bese dekena amo do lau atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Badina be mauri gaudia ibounai edia mauri be rara dainai. Unai dainai lau Lohiabada ese lau oda henia vadaeni rara ibounai be boubou patana dekenai do idia bubua, taunimanima edia kara dika davana do ia karaia totona. Rara be mauri, bona rara ese kara dika ia kokia noho. ");
INSERT INTO hmo_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","“Unai dainai lau Lohiabada ese taravatu badana lau gwauraia inai: Israela taudia, bona edia huanai idia noho idau bese taudia danu ese vamu mai rarana danu do idia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Bema Israela tauna ta o Israela taudia edia huanai ia noho idau bese tauna ta do ia labana, vadaeni uda gauna ta o roho manuna ta, aniani gauna do ia alaia mase, ia ese rarana do ia habubua tano dekenai, bona tano kahu dekena amo unai rara do ia koua. ");
INSERT INTO hmo_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Badina be mauri gaudia ibounai edia mauri be rara dainai. Unai dainai lau Lohiabada ese lau oda henia vadaeni, vamu mai rarana danu do umui ania lasi. Bona bema umui ta ese unai bamona ia karaia, ia be iena bese dekena amo do lau atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Tau ta, Israela tauna o Israela taudia edia huanai ia noho idau bese tauna, bema ia ese mase kava gauna ta o uda ena dagedage gauna ese ia alaia gauna ta do ia ania neganai, unai tau ese iena dabua do ia huria, bona do ia digu, bona do ia miro noho ela bona dina do ia diho. Unai murinai unai tau do ia goeva. ");
INSERT INTO hmo_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","To bema ia ese iena dabua do ia huria lasi, o do ia digu lasi, ia be do ia kerere.” ");
INSERT INTO hmo_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Lohiabada ese Mose dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Israela taudia do oi hamaoroa: Lau inai Lohiabada, umui emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Umui be guna Aigupito tano dekenai umui noho, to Aigupito taudia edia kara bamona do umui karaia lasi. Bona umui do lau hakaua vareai Kanana tano ena taudia edia kara bamona do umui karaia lasi. Edia taravatu danu do umui badinaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","To lauegu taravatu do umui kamonai henia, bona lauegu oda do umui badinaia. Lau inai Lohiabada, umui emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Unai dainai, lauegu taravatu bona lauegu oda do umui badinaia, unai bamona ia karaia tauna be do ia mauri. Lau inai Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Oiemu varavara ta dekenai oi do sihari henia lasi. Lau inai Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Oiemu sinana, oiemu tamana ena adavana, dekenai do oi sihari henia lasi. Ia be oiemu sinana, unai bamona hemarai kara do oi karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Oiemu tamana ena adavana ma ta dekenai oi sihari henia lasi, badina ia be oiemu tamana ena. ");
INSERT INTO hmo_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Oiemu taihuna dekenai oi sihari henia lasi. Oiemu tamana ena natuna kekeni ta, o oiemu sinana ena natuna kekeni ta do oi abia lasi. Ia be oiemu ruma dekenai, o idau ruma ta dekenai ia vara kekeni ta, to do oi abia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Oiemu tubuna kekeni dekenai oi sihari henia lasi, oiemu natuna tau, o oiemu natuna hahine edia kekeni ta do oi abia lasi. Badina edia hemarai be oiemu hemarai danu. ");
INSERT INTO hmo_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Oiemu tamana ena adavana ta ena natuna kekeni ta do oi sihari henia lasi, bona oiemu sinana ena adavana ta ena natuna kekeni ta danu do oi abia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Oiemu tamana ena taihuna dekenai oi sihari henia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Oiemu sinana ena tadikaka hahine dekenai oi sihari henia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Oiemu tamana o sinana edia tadikaka edia adavana dekenai oi sihari henia lasi, ia danu be oiemu varavara. ");
INSERT INTO hmo_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Oiemu ravana hahine danu do umui sihari lasi, badina ia be oiemu natuna ta ena adavana. ");
INSERT INTO hmo_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Oiemu tadikaka ena adavana do oi sihari henia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Sedira hahine ta dekenai oi headava, bona hahine be mai ena natuna kekeni o tubuna kekeni, tau ta ena. Vadaeni oi ese unai natuna kekeni o tubuna kekeni do oi adavaia lasi. Unai be hemarai karana. ");
INSERT INTO hmo_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Oiemu adavana ena tadikaka hahine danu umui sihari lasi, bema oiemu adavana ia mauri noho neganai. ");
INSERT INTO hmo_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Hahine ta, hua gorere ia davaria neganai, do oi sihari henia lasi, badina ia be mai miro danu. ");
INSERT INTO hmo_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Oiemu badibadina dekenai tauna ena adavana danu do umui sihari lasi. Unai be miro karana ta. ");
INSERT INTO hmo_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Oiemu natuna ta dirava ta ena ladana Moleka dekenai do oi henia lasi, idia gabua boubou gauna totona. Unai bamona kara ese lau Dirava, Lohiabada, egu ladana ia hadikaia. ");
INSERT INTO hmo_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Umui emui tau ta ese ma tau ta do ia sihari henia lasi, tau bona hahine idia karaia bamona. Inai bamona kara be dika momokani, bona inai kara dekenai, lau Dirava lau badu momokani. ");
INSERT INTO hmo_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ubua gauna ta dekenai do umui sihari henia lasi. Hahine danu be unai bamona do ia karaia lasi. Unai kara be dika momokani. ");
INSERT INTO hmo_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Inai miro karadia ibounai be do umui karaia lasi, badina be umui emui vairana dekenai do lau lulua besedia be unai kara ibounai idia karaia dainai idia miro. ");
INSERT INTO hmo_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Idia edia kara ese edia tano idia hamiroa. Unai dainai dika davana be unai tano dekenai lau henia noho. Vadaeni unai tano ese, ia dekenai noho taudia ia luludia, bona idia rakatania noho. ");
INSERT INTO hmo_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","To umui ese lauegu taravatu bona lauegu oda do umui badinaia, bona unai kara mirodia do umui karaia lasi, umui Israela taudia, bona umui emui huanai idia noho idau taudia danu. ");
INSERT INTO hmo_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Badina be inai tano dekenai idia noho guna taudia ese unai miro karadia idia karaia, ia mai bona tano ia miro vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Bema umui ese unai tano unai bamona do umui hamiroa neganai, unai tano ese umui danu do ia lulua, guna idia noho taudia ia lulua bamona. ");
INSERT INTO hmo_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Badina umui diba, unai bamona miro karadia ta, bema umui ta ese ia karaia neganai, ia be do umui gwauraia ia be Dirava ena bese tauna lasi. ");
INSERT INTO hmo_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Unai dainai, lauegu taravatu do umui kamonai henia, bona unai miro karadia, inai tano dekenai idia noho guna taudia edia kara, be do umui karaia lasi. Vadaeni unai kara dekena amo do umui miro lasi. Lau inai Lohiabada, emui Dirava.” ");
INSERT INTO hmo_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Lohiabada ese Mose ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Israela taudia ibounai do oi hamaoroa, do oi gwau: Do umui helaga, badina be lau Lohiabada, emui Dirava, lau be helaga vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Umui ibounai emui sinana bona emui tamana do umui matauraia. Bona lauegu Sabati Dinadia do umui badinaia. Lau inai Lohiabada, umui emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Dirava koikoidia do umui tomadiho henia lasi, bona dirava edia laulaudia auri dekena amo do umui karaia lasi. Lau inai Lohiabada, umui emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Maino karaia bouboudia Lohiabada dekenai umui henidia neganai, kara ibounai taravatu hegeregerena do umui karaia, vadaeni unai boubou do lau abia dae. ");
INSERT INTO hmo_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Boubou gauna ena vamuna be umui alaia dinana o dina iharuana dekenai do umui ania. Dina ihatoina dekenai umui ania lasi gaudia be lahi dekenai do umui gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Bema dina ihatoina dekenai umui ania, unai be kara mirona, bona Lohiabada ese emui boubou karana do ia abia dae lasi. ");
INSERT INTO hmo_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Tau ta ia ania neganai do ia kerere, badina ia ese Lohiabada ena gau helagana ia hamiroa vadaeni. Unai dainai unai tau be iena bese dekena amo do umui atoa siri. ");
INSERT INTO hmo_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Umui emui uma ena anina umui utua neganai, do umui utua lao lasi ela bona uma ena hetoa korikori dekenai. Bona tano dekenai idia moru kava uma anina gaudia do umui gogoa lasi. ");
INSERT INTO hmo_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Umui emui vain ena anina danu do umui gogoa ore momokani lasi. Kaia ia misi gaudia, bona tano dekenai idia moru gaudia do umui gogoa lasi. Umui rakatania, badina idia be ogogami taudia, bona idau bese taudia edia. Lau inai Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Gau ta do umui henaoa lasi. Do umui koikoi karaia lasi. Do umui hereva koikoi lasi. ");
INSERT INTO hmo_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Lauegu ladana dainai do umui gwauhamata koikoi lasi, badina inai kara ese lauegu ladana ia hahemaraia. Lau inai Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Tau ta do umui dagedage henia lasi, bona iena gau ta do umui henaoa lasi. Umui dekenai ia gaukara tauna ena gaukara davana do umui dogoatao lasi ela bona dabai. ");
INSERT INTO hmo_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Taia kudima tauna ta do umui hereva dika henia lasi. Bona matakepulu tauna ta ena dala dekenai gau ta do umui atoa lasi, do ia moru totona. Emui Dirava garina do umui gari. Lau inai Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Mai maoromaoro danu, bona mai maka tamona danu do umui kota henia. Ogogami taudia do umui bogahisihisi henia lasi, vadaeni idia uini kava. Bona kohu momo taudia do umui gari henia lasi, vadaeni idia uini kava. To laloa maoromaoro dekenai do umui kota henia. ");
INSERT INTO hmo_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Tau ta hadikaia totona sivarai koikoi ta do umui gwauraia loaloa lasi. Bona bema idia kota henia do ia mase totona tauna, be emui hereva dekenai umui durua diba neganai, do umui durua. Badina lau Lohiabada inai, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Emui tadikakana do oi badu henia noho lasi, oiemu lalona dekenai. Bema tau ta oi dekenai ia kara dika, do oi sisiba henia, bona maino do umui karaia, iena kerere dainai oi danu ese kara dika do oi karaia garina. ");
INSERT INTO hmo_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Kara dika ena davana do umui haloua lasi, bona unai tau do umui badu henia noho lasi. To emui badibadinai tauna do umui lalokau henia, umui sibona umui lalokau henia hegeregerena. Lau inai Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Lauegu oda herevadia do umui kamonai henia. Emui ubua gaudia do umui naridia namonamo, orea bona toana ta ubua gauna ese orea bona toana idauna ubua gauna do ia sihari henia lasi. Ubua gaudia edia bese idauidau do idia mikisi lasi. Aniani uhe idauidau be uma tamona lalonai do umui hadoa lasi. Dabua idauidau dekena amo idia karaia dabuana be do umui karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Sedira tau ta ia gwauhamata iena hesiai kekeni ta be tau ta dekenai do ia hoia lao, to unai tau ese kekeni ruhaia davana ia henia lasi. Unai neganai bema kekeni ena biaguna bona unai kekeni idia sihari neganai, edia kerere davana be mase lasi, badina unai kekeni be do idia ruhaia lasi dainai. To kota ese edia kerere do ia tahua. ");
INSERT INTO hmo_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Unai kerere tauna ese iena kara dika ena boubou do ia mailaia, bona Palai Dubu ena iduara dekenai Lohiabada dekenai do ia henia. Iena boubou gauna be mamoe tau tamona. ");
INSERT INTO hmo_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Unai neganai hahelagaia tauna ese unai tau ena kara dika boubouna do ia abia, Lohiabada ena vairanai. Bona unai boubou gauna dekena amo unai kerere tauna ena kara dika davana be hahelagaia tauna ese do ia karaia. Vadaeni unai neganai Dirava ese unai tau ena kerere do ia gwauatao. ");
INSERT INTO hmo_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Kanana tano dekenai do umui ginidae neganai, bona emui au huahua idauidau unuseni do umui hadoa neganai, unai au ena anina do umui gwauraia helaga lagani toi lalonai. Unai lagani toi lalonai unai au huahua do umui ania lasi. ");
INSERT INTO hmo_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Lagani namba 4 dekenai unai huahua be do umui hahelagaia, bona lau Lohiabada dekenai, boubou bamona do umui henia. Inai kara dekenai, umui ese emui tanikiu lau Lohiabada dekenai do umui hedinaraia. ");
INSERT INTO hmo_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","To lagani namba 5 dekenai unai au huahua do umui ania diba. Bema lauegu hereva umui badinaia neganai, emui au huahua edia anina do idia momo herea. Kamonai! Lau inai Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Vamu mai rarana danu do umui ania lasi. Meamea karadia idauidau ibounai do umui karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Umui emui kwarana edia huina be emui taiana kahirakahira do umui utua lasi. Bona emui auki huina do umui utua lasi. ");
INSERT INTO hmo_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Mase taudia dainai emui kopina do umui ivaia lasi, bona emui kopina dekenai revareva do umui atoa lasi. Lau Lohiabada inai. ");
INSERT INTO hmo_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Umui ese emui natuna kekeni do umui hahemaraia lasi, ariara hahinena do umui halaoa lasi. Bema inai bamona umui karaia neganai, umui ese lau do umui rakatania, idau dirava dekenai do umui lao. Bona emui tano ibounai be lebulebu bona kara mirodia dekena amo do ia moru. ");
INSERT INTO hmo_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Lauegu Sabati Dinadia do umui badinaia, bona lau dekenai idia tomadiho gabuna do umui matauraia. Lau inai Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Mase taudia edia lauma danu idia herevahereva taudia do umui tahua lasi, edia sisiba abia totona. Bema unai bamona umui karaia, umui be miro lauegu vairana dekenai. Lau inai Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Tau buruka edia vairanai do umui toreisi, bona buruka taudia ibounai do umui matauraia. Umui emui Dirava garina do umui gari. Lau inai Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Umui huanai idia noho idau taudia do umui dagedage henia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Idau taudia be emui bese korikori hegeregerena umui emui huanai do idia noho. Do umui lalokau henidia, umui sibona umui lalokau henia hegeregerena. Do umui laloaboio lasi, umui danu be Aigupito tano dekenai idau taudia bamona umui noho guna. Lau inai Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Tau ta danu umui hoihoi neganai, hoihoi gaudia edia metau, edia lata bona edia momo do umui duahia karaia mai maoromaoro danu. Do umui koikoi lasi. ");
INSERT INTO hmo_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Emui sikele bona edia metau gaudia bona emui hahetoho gauna be do idia maoromaoro momokani. Lau inai Lohiabada, emui Dirava, bona Aigupito tano dekena amo umui lau hakaua mai. ");
INSERT INTO hmo_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Lauegu taravatu ibounai bona lauegu oda herevadia ibounai do umui badinaia, bona edia kara do umui karaia. Lau inai Lohiabada.” ");
INSERT INTO hmo_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Lohiabada ese Mose ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Israela taudia ma do oi hamaoroa, inai bamona: Bema Israela tauna ta o Israela taudia edia huanai idau bese tauna ta ese iena natuna, be Moleka dirava dekenai do ia henia, gabua ore boubouna totona, unai tau be momokani do ia mase. Hanua taudia ese nadi dekena amo ia do idia hodoa mase. ");
INSERT INTO hmo_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Lau danu ese unai tau do lau badu henia, bona egu bese dekena amo do lau negea momokani. Badina be iena natuna be Moleka dekenai ia henia, bona unai kara dekena amo ia ese lauegu Palai Dubu ia hamiroa, bona egu ladana helagana ia hahemaraia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","“To bema hanua taudia ese inai Moleka dekenai iena natuna ia henia tauna idia bogahisihisi henia, nadi dekenai idia hamasea lasi neganai, ");
INSERT INTO hmo_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","lau sibona ese unai tau bona iena bese taudia do lau badu henia, bona idia, bona Moleka dekenai tomadiho taudia ibounai, be egu bese dekena amo do lau negea momokani. ");
INSERT INTO hmo_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Mase taudia edia lauma danu idia herevahereva taudia do umui tahua lasi, edia sisiba abia totona. Bema umui ta ese unai bamona ia karaia neganai, lau be ia dekenai do lau badu, bona egu bese dekena amo do lau negea momokani. ");
INSERT INTO hmo_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Unai dainai umui ese sibona do umui hahelagaia, bona do umui helaga noho, badina lau be Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Lauegu taravatu do umui kamonai henia, badina lau be Lohiabada, bona lau ese umui lau hahelagaia noho.” ");
INSERT INTO hmo_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Lohiabada ese inai taravatu ma ia gwauraia inai: “Tamana o sinana dekenai tau ta ese do ia hereva dika henia neganai, unai tau be do umui alaia mase. Iena mase be ia sibona ena kerere dainai. ");
INSERT INTO hmo_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Bema tau ta ese iena badibadina dekenai tauna ena adavana ia sihari henia neganai, unai tau bona hahine ruaosi be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Bema tau ta ese iena tamana ena adavana ta do ia sihari henia neganai, ia ese iena tamana ia hahemaraia vadaeni. Unai dainai unai tau bona hahine ruaosi be do idia alaia mase, bona edia mase be idia sibona edia kerere dainai. ");
INSERT INTO hmo_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“Bema tau ta ese iena ravana hahine, iena natuna tau ena adavana, do ia sihari henia neganai, idia ruaosi be do umui alaia mase. Idia ese kara mirona momokani idia karaia vadaeni, bona idia edia mase be idia sibona edia kerere dainai. ");
INSERT INTO hmo_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Bema tau ta ese ma tau ta dekenai do ia sihari henia, tau bona hahine idia karaia bamona, unai be kara mirona momokani. Unai tau ruaosi be do umui hamasea, bona edia mase be idia sibona edia kerere dainai. ");
INSERT INTO hmo_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Bema tau ta ese hahine ta, bona unai hahine ena sinana danu ia adavaia nega tamona neganai, idia toiosi be do umui gabua mase. Badina unai be kara dika herea. Unai bamona kara umui emui huana dekena amo do umui hadokoa. ");
INSERT INTO hmo_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“Bema tau ta ese ubua gauna ta ia sihari henia neganai, unai tau bona ubua gauna be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“Bema hahine ta ese ubua gauna ta danu idia hekure, do idia sihari totona, unai hahine bona ubua gauna be do umui alaia mase. Idia sibona edia kerere dainai do idia mase. ");
INSERT INTO hmo_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Bema tau ta ese iena taihuna ta, iena tamana ena natuna, o iena sinana ena natuna do ia abia, ia dekenai ia sihari henia neganai, unai be hemarai kara. Edia bese dekena amo ruaosi do umui lulua lao, badina unai tau ese iena taihuna ia hahemaraia vadaeni, bona unai dainai ia ese unai kerere ena davana do ia davaria. ");
INSERT INTO hmo_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“Bema tau ta ese hahine ta hua rara gorere ia davaria neganai unai hahine do ia sihari henia, idia ruaosi be egu bese dekena amo do umui negea siri. Badina be idia ese kara mirodia hagoevaia totona taravatu idia utua vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Bema tau ta ese iena tamana ena taihuna dekenai o iena sinana ena tadikaka hahine dekenai ia sihari henia, idia ruaosi be varavara korikori dainai, edia kerere davana do idia davaria. ");
INSERT INTO hmo_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“Bema tau ta ese iena tamana o sinana edia tadikaka edia adavana dekenai ia sihari henia, ia ese iena tamana maragi o iena vavana ia matauraia lasi unai. Bona unai dainai unai tau bona unai hahine ese edia kerere davana do idia abia, idia ruaosi ese natuna ta do idia abia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Bema tau ta ese iena tadikaka ena adavana do ia sihari henia, unai be kara mirona, bona ia ese iena tadikakana ia hahemaraia vadaeni. Unai tau bona hahine ese natuna ta do idia abia lasi.” ");
INSERT INTO hmo_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Lohiabada ese ma ia gwau, “Lauegu taravatu bona oda ibounai do umui kamonai henia, vadaeni umui dekenai do lau henia tano dekenai noho Kanana taudia ese umui do idia lulua lao lasi. ");
INSERT INTO hmo_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kanana dekenai idia noho taudia edia kara bamona do umui karaia lasi. Lau ese inai bese taudia umui emui vairana dekenai lau luludia noho, umui ese edia tano do umui raka vareai totona. Idia edia kerere bona edia kara lau ura lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","“To lau ese umui dekenai lau gwauhamata vadaeni, unai taudia edia tano be umui dekenai do lau henia, emui tano korikori. Inai tano be namo herea, rata bona hani dekenai ia honu tanona. Lau be Lohiabada, emui Dirava, bona lau ese bese idauidau edia huanai umui lau abia hidi vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Unai dainai umui ese mauri gaudia goevadia bona mirodia edia idau do umui laloa namonamo. Mauri gaudia mirodia bona manu mirodia do umui ania lasi. Lau ese lau gwauraidia miro vadaeni. Bema idia umui ania neganai, umui danu be miro. ");
INSERT INTO hmo_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","“Do umui helaga, bona lau sibona egu bese taudia do umui lao. Badina be, lau be Lohiabada, bona lau be helaga. Lau ese bese idauidau edia huanai dekena amo umui lau abia hidi vadaeni, egu bese korikori do umui lao totona. ");
INSERT INTO hmo_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Bema tau ta o hahine ta ese mase taudia edia lauma dekenai ia hereva henia, umui ese ia do umui alaia mase. Nadi dekenai do umui hodoa mase, bona iena mase be ia sibona ena kerere.” ");
INSERT INTO hmo_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Bona Lohiabada ese Mose ia hamaoroa, ia gwau, “Hahelagaia taudia, Arona ena natuna tau taudia do oi oda henia, idia ta ese iena hanua mase tauna hahelagaia totona gaukara ia karaia neganai, unai mase tauna do ia dogoatao lasi. Ia ese sibona do ia hamiroa lasi, mase tauna ena miro dekenai garina. ");
INSERT INTO hmo_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","To iena varavara korikori taudia ta ia mase neganai, hegeregere iena sinana, tamana, natuna tau, natuna hahine, tadikakana, ");
INSERT INTO hmo_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o iena taihuna, ia naria noho, badina ia do headava lasi kekeni, unai varavara korikori taudia sibona ia dogoatao diba. ");
INSERT INTO hmo_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Hahelagaia tauna danu ese iena adavana ena varavara taudia idia mase neganai, edia tauanina dekenai do ia kamokau lasi, do ia miro garina. ");
INSERT INTO hmo_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Hahelagaia tauna ese iena kwarana huina o iena aukina huina do ia utua lasi, bona iena kopina be do ia utua o ivaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","“Ia ese Dirava ena vairana dekenai do ia helaga, bona Dirava ena ladana do ia hahemaraia lasi. Ia ese gabua ore bouboudia bona Dirava ena paraoa bouboudia ia karaia noho dainai, ia be do ia helaga. ");
INSERT INTO hmo_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“Hahelagaia tauna ese ariara hahine, o lebulebu hahine, o iena tau ese ia negea hahine ta do ia adavaia lasi. Badina ia be helaga Dirava ena vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","“Hahelagaia taudia be helaga dainai, idia do umui matauraia, badina be idia ese lau Dirava egu paraoa bouboudia idia karaia noho. Lau inai Lohiabada, lau be helaga, bona egu bese taudia lau hahelagaia noho. ");
INSERT INTO hmo_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Bema hahelagaia tauna ena natuna kekeni ese sibona be lebulebu o ariara hahine ia halaoa neganai, ia ese iena tamana ia hahemaraia vadaeni. Ia be lahi dekenai do umui gabua mase. ");
INSERT INTO hmo_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Hahelagaia Tauna Badana be iena kwarana dekenai dehoro helagana idia bubua vadaeni, bona idia hahelagaia vadaeni, dabua helagadia do ia karaia totona, vadaeni ia ese iena huina do ia duaria noho namonamo, bona ia ese iena dabua do ia darea lasi, mase taudia totona idia taitai neganai. ");
INSERT INTO hmo_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ia ese mase tauna kahirakahira do ia lao lasi, iena tamana o sinana danu, idia kahirakahira do ia lao lasi, do ia miro garina. ");
INSERT INTO hmo_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ia ese Helaga Gabuna do ia rakatania lasi, Dirava ena Palai Dubu do ia matauraia lasi garina. Badina be Dirava ena dehoro helagana be iena latanai idia bubua vadaeni, ia be helaga. Lau Lohiabada inai. ");
INSERT INTO hmo_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Ia ese sihari do ia diba lasi, rami hebou kekeni sibona do ia adavaia. ");
INSERT INTO hmo_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ia ese vabu, o negea hahine, o lebulebu hahine ta do ia adavaia lasi, to sihari ia do diba lasi kekeni, iena bese dekena amo, sibona do ia adavaia. ");
INSERT INTO hmo_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Unai dekena amo iena natuna be do idia hemarai lasi edia bese taudia edia huanai. Badina be lau Lohiabada ese lau hahelagaia vadaeni, Hahelagaia Tauna Badana.” ");
INSERT INTO hmo_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Lohiabada ese Mose ma ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Arona do oi hamaoroa, ‘Oiemu natuna o tubuna ta, bema iena tauanina be mai ena dika ta, o gorere ta, ia ese Dirava ena paraoa boubouna be lau Lohiabada dekenai do ia henia lasi. Inai be noho hanaihanai taravatuna.’ ");
INSERT INTO hmo_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","“Badina be tau ta mai ena tauanina dika ta be egu boubou do ia karaia lasi, iena matana ia kepulu, o bema iena aena ia dika, o bema iena udubaubauna ia makohia, o bema iena ima kwakikwakina o ae kwakikwakina be momo, 5 sibona lasi, ");
INSERT INTO hmo_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","o bema iena aena o imana ia makohia, ");
INSERT INTO hmo_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","o bema iena doruna ia gageva, o kwadogi herea tauna, o matana ta ia dika tauna, o iena kopina dekenai toto idia noho tauna, o iena abona idia dika tauna. ");
INSERT INTO hmo_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“Arona ena natuna o tubuna tauna ta, bema iena tauanina be mai ena dika ta, ia ese lau kahirakahira do ia raka mai lasi, Lohiabada ena gabua ore bouboudia karaia totona. Iena tauanina be mai ena dika dainai, Dirava ena paraoa do ia henia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Unai tau ese Dirava dekenai henia paraoa ia ania diba, helaga gauna, bona helaga herea gauna danu. ");
INSERT INTO hmo_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","To iena tauanina be mai ena dika ta dainai, ia ese Helaga Herea Gabuna ena koua dabua helagana kahirakahira, o boubou patana kahirakahira do ia raka mai lasi. Ia ese inai lauegu helaga gaudia do ia hamiroa lasi, badina lau Lohiabada ese unai gaudia lau hahelagaia vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Inai hereva ibounai be Mose ese Arona bona iena natuna tau danu, bona Israela taudia ibounai dekenai ia hamaoroa. ");
INSERT INTO hmo_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Lohiabada ese Mose ia oda henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Arona bona iena natuna tau do oi hamaoroa, do oi gwau: ‘Umui ese egu ladana helagana do umui hahemaraia lasi. Unai dainai Israela taudia ese lau dekenai idia mailaia boubou helaga gaudia be do umui matauraia. Lau inai Lohiabada.’ ");
INSERT INTO hmo_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Arona bona iena natuna tau do oi hamaorodia, do oi gwau: ‘Bema emui natudia o, tubudia ta be egu taravatu dekenai ia miro neganai, Israela taudia edia boubou helagadia, lau dekenai idia mailaia gaudia, be ia ese ia dogoatao, o ia alaia mase, ia be lauegu vairana dekena amo do umui negea, bona iena dagi dekena amo do ia doko. Inai be noho hanaihanai taravatuna. Lau Lohiabada inai.’ ");
INSERT INTO hmo_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Arona ena natuna bona tubudia ta bema mai ena lepera gorere, o mai ena toto, bona hura be ena toto dekena amo ia bubua neganai, ia ese boubou helagadia do ia ania diba lasi ela bona ia goeva. Hahelagaia tauna bema mase tauna ta ena gau o dabua ia dogoatao neganai, ia be miro. Ma hahelagaia tauna, bema iena vesina ia bubua neganai, ia be miro. ");
INSERT INTO hmo_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Ma bema ia ese mauri gauna mirona ta, o tau mirona ta ia dogoatao neganai, inai danu dainai ia be miro. ");
INSERT INTO hmo_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","“Hahelagaia tauna be inai bamona ia miro neganai, ia be do miro noho ela bona dina ia diho. Bona ia ese unai boubou helagadia do ia ania diba lasi, ela bona ranu dekenai ia digu. ");
INSERT INTO hmo_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","“Dina ia diho murinai ia be goeva, bona unai neganai unai boubou helagadia ia ania diba, badina be iena aniani be unai. ");
INSERT INTO hmo_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","To idia mase kava gaudia o uda boromadia ese idia alaia gaudia be do ia ania lasi, do ia miro garina. Lau inai Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Hahelagaia taudia ibounai ese lauegu oda do idia kamonai henia. Bema inai oda idia utua neganai, idia be kerere, bona edia kerere lalonai do idia mase, badina taravatu helagadia idia badinaia lasi dainai. Lau be Lohiabada, bona lau ese idia lau hahelagaia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Hahelagaia tauna ena famili taudia sibona ese boubou helagadia idia ania diba. Idau tauna ta ese boubou helagadia ia ania diba lasi, bona hahelagaia tauna ena vadivadi tauna do ia ania lasi. Iena hesiai tauna mai davana ese danu do ia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","To hahelagaia tauna ese moni dekena amo ia hoia tauna ese do ia ania. Bona hahelagaia tauna ena ruma lalonai ia vara hesiai tauna danu do ia ania diba. ");
INSERT INTO hmo_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","“Hahelagaia tauna ena natuna hahine ese, bema hahelagaia tauna lasi, to tau ma ta ia adavaia neganai, unai hahine ese boubou helagadia do ia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","To hahelagaia tauna ena natuna hahine bema ia vabu, o bema adavana ese ia negea, iena natuna be lasi, bona ia ese iena tamana ena ruma dekenai ia giroa lou, unuseni do ia noho, ia kekeni negana hegeregere, ia ese iena tamana ena aniani do ia ania. To hahelagaia tauna ena famili lasi taudia do idia ania diba lasi. ");
INSERT INTO hmo_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Bema tau ta ese unai aniani helagana ia ania kava, ia diba lasi unai be helaga dainai, ia ese unai aniani ena davana be hahelagaia tauna dekenai do ia henia, mai atoa kau moni danu. Atoa kau moni be ia ania gauna ena davana bema karoa 5, ma karoa ta. Unai karoa ta be ma do idia atoa kau, ibounai karoa 6 do ia henia. ");
INSERT INTO hmo_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“Israela taudia edia boubou gaudia helagadia Lohiabada dekenai idia henia, be hahelagaia taudia ese do idia gaukaralaia kava lasi. Unai aniani helagana be aniani helaga lasi hegeregerena do idia gaukaralaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Hahelagaia taudia ese unai aniani do idia naria namonamo, vadaeni helaga lasi taudia ese do idia ania lasi. Bema helaga lasi taudia idia ania neganai, idia ese edia kerere davana do idia karaia. Lau be Lohiabada, bona lau ese inai boubou gaudia lau hahelagaia noho.” ");
INSERT INTO hmo_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Lohiabada ese Mose ia oda henia, ");
INSERT INTO hmo_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","ia ese Arona bona iena natuna tau dekenai inai taravatu do idia henia Israela taudia dekenai: “Bema Israela tauna ta o Israela dekenai ia noho idau bese tauna ta ese do idia gabua ore boubou gauna do ia mailaia, gwauhamata ena davana totona, o laloa namo totona, unai boubou gauna be bero lasi bona toto lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Lohiabada ese do ia abia dae totona ia be boromakau tau o mamoe tau o nanigosi tau bero lasi bona toto lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","“Bema tauanina mai ena dika mauri gauna ta boubou totona umui henia neganai, Lohiabada ese do ia abia dae lasi. ");
INSERT INTO hmo_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Bona bema tau ta ese Lohiabada dekenai maino karaia boubouna ia henia, gwauhamata dainai o laloa namo dainai, unai boubou gauna be bero ta lasi bona toto ta lasi. Bema lasi neganai, Lohiabada ese do ia abia dae lasi. ");
INSERT INTO hmo_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Matakepulu gauna, o aena ia dika, o mai ena bero, o toto mai hurana, o mai ena kopina gorere, o mai kipara dikadia mauri gaudia do umui mailaia lasi. Inai bamona gaudia be aniani bouboudia totona boubou patana dekenai do umui mailaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“Boromakau ta, o mamoe ena natuna bema edia imana ta o aena ta do ia kwadogi, o do ia lata neganai, umui henia diba laloa namo boubouna totona, to do umui mailaia lasi gwauhamata ena davana totona. ");
INSERT INTO hmo_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","To gau ta bema iena abona ena nadi ruaosi be mai toto, o bema idia makohia, o idia darea, o idia utua neganai, umui ese Lohiabada dekenai do umui mailaia lasi. Emui tano dekenai inai bamona boubouna be taravatu. ");
INSERT INTO hmo_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“Bona unai bamona mai berodia mauri gaudia be idau bese taudia dekena amo do umui abia lasi, Dirava dekenai do umui henia, boubou totona. Lohiabada ese unai gaudia do ia abia dae lasi, edia tauanina be mai edia dika dainai.” ");
INSERT INTO hmo_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Boromakau, mamoe, o nanigosi do ia vara neganai, dina 7 lalonai iena sinana dekenai do ia noho. Dina namba 8 murinai ia be hegeregere gabua ore boubouna totona, Lohiabada dekenai do idia henia, bona Lohiabada ese do ia abia dae. ");
INSERT INTO hmo_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","“To boromakau hahine o mamoe hahine mai ena natuna be dina tamona dekenai do umui alaia mase lasi. ");
INSERT INTO hmo_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Bema Lohiabada hanamoa totona boubouna umui henia neganai, boubou henia taravatuna do umui badinaia namonamo, Lohiabada ese umui do ia abia dae totona. ");
INSERT INTO hmo_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Boubou ena vamuna umui alaia dinana dekenai be do umui ania, bona aniani haida do umui rakatania lasi ela bona dabai. Lau Lohiabada inai.” ");
INSERT INTO hmo_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Lohiabada ma ia gwau, “Lauegu oda do umui kamonai henia, lau Lohiabada inai. ");
INSERT INTO hmo_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Lauegu ladana helagana do umui hahemaraia lasi. Israela taudia ibounai ese egu helaga badana do idia matauraia, badina lau ese umui lau hahelagaia noho. ");
INSERT INTO hmo_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","“Lau ese Aigupito dekena amo umui lau hakaua mai, emui Dirava do lau lao totona. Lau Lohiabada inai.” ");
INSERT INTO hmo_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Lohiabada ese Mose ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Israela taudia do oi hamaorodia, guriguri dina badadia haida lau gwauraia inai, lau dekenai do idia tomadiho henia dinadia: ");
INSERT INTO hmo_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Dina 6 lalonai emui gaukara do umui karaia, to dina namba 7 be Sabati Dinana, ia be laga-ani dinana, hebou helagana dinana. Unai dina lalonai do umui gaukara lasi, ia be lau Lohiabada egu Sabati Dinana. Umui noho gabudia ibounai dekenai inai dina do umui naria. ");
INSERT INTO hmo_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Ma lau Lohiabada egu dina badadia be inai, bona inai guriguri hebou helagadia be edia nega korikori do umui karaia: ");
INSERT INTO hmo_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Aigupito dekenai Dirava ese umui ia hamauria dinana (Pasova) be do umui laloa bada. Lohiabada ena Pasova dinana hamatamaia negana be dina ia diho neganai, hua ginigunana ena dina namba 14. Pasova dinana be dina tamona sibona. ");
INSERT INTO hmo_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Dina namba 15 neganai Hatubua Lasi Paraoa ena aria, Lohiabada ena, do umui karaia. Dina 7 lalonai mai hatubua gauna lasi paraoa sibona do umui ania. ");
INSERT INTO hmo_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Inai dina 7 ena dina ginigunana be do umui hebou guriguri totona, bona emui gaukara ta do umui karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Unai dina 7 lalonai boubou gaudia hegeregere aniani bona vamu be lau Lohiabada dekenai do umui henia. Dina namba 7 dekenai do umui hebou lou guriguri totona, bona unai dina lalonai emui gaukara ta do umui karaia lasi.” ");
INSERT INTO hmo_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Lohiabada ese Mose ma ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Israela taudia do oi hamaoroa, do oi gwau: Umui dekenai do lau henia tano dekenai do umui ginidae neganai, umui emui uma edia koni anina umui utua neganai, emui koni guia gauna ginigunana be hahelagaia tauna dekenai do umui henia. ");
INSERT INTO hmo_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Vadaeni ia ese unai aniani gauna do ia abia, bona Lohiabada ena vairanai do ia davea, Lohiabada ese umui do ia hanamoa totona. Sabati Dina ena murinai dinana dekenai hahelagaia tauna ese unai guia gauna do ia davea. ");
INSERT INTO hmo_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Bona unai aniani davea dinana dekenai mamoe natuna tau, dika ta lasi gauna, lagani tamona gauna, do umui henia, gabua ore boubouna totona. ");
INSERT INTO hmo_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Paraoa boubouna danu unai mamoe danu do umui henia, paraoa namo herea ena metau kilogaram rua be olive dehoro danu do umui mikisi. Inai boubou be lahi dekenai do umui gabua, bona ena bonana be do ia namo herea Lohiabada ena vairanai. Bona inai boubou danu be inuinu boubouna do umui henia, uaina, ena bada be lita ta. ");
INSERT INTO hmo_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Unai aniani matamata, koni, o uiti, ia kaukau gauna, o beredi matamatana, do umui ania lasi, ela bona emui boubou gauna be Dirava dekenai umui henia haorea. Inai taravatu do ia noho hanaihanai umui dekenai, bona emui tubudia dekenai, emui noho gabudia ibounai dekenai.” ");
INSERT INTO hmo_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Ma Lohiabada ia hereva, ia gwau, “Unai dina dekena amo, unai Sabati murinai dinana, emui uma anina ginigunana hahelagaia tauna dekenai umui henia dinana, be pura 7 do umui duahia. ");
INSERT INTO hmo_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Inai Sabati 7 murinai dinana be dina namba 50. Unai dina namba 50 dekenai paraoa matamata ena boubou be lau Lohiabada dekenai do umui henia. ");
INSERT INTO hmo_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Famili ta ta ibounai ese beredi rua do umui mailaia, bona lau Lohiabada dekenai do umui henia, emui harihari gauna idauna ta. Beredi ta ta be paraoa kilogaram rua dekena amo idia karaia gaudia. Mai hatubua gauna danu do umui gabua, bona Lohiabada dekenai do umui henia, ia be koni matamata ena boubou gauna. ");
INSERT INTO hmo_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Bona inai beredi danu, gau haida ma danu do umui henia: Mamoe natuna 7, lagani tamona gaudia, bona boromakau natuna tau ta, bona nani rua do umui henia. Idia ibounai be dika ta lasi gaudia. Idia ibounai be idia gabua ore boubouna lau Lohiabada dekenai do umui henia. Beredi boubouna bona uaina boubouna danu be inai idia gabua ore boubouna danu nega tamona do umui henia. Inai ibounai be bonana namona boubouna lau Lohiabada egu vairana dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Bona umui ese nani tau ta boubouna do umui henia, kara dika kokia totona, ma mamoe tau rua boubouna, lagani tamona gaudia do umui henia. Idia be maino karaia boubouna totona. ");
INSERT INTO hmo_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Hahelagaia tauna ese beredi bona mamoe natuna rua be iena imana dekenai do ia davea, idia be lau Lohiabada dekenai boubou gauna. Idia be lau Lohiabada egu gau helagadia, hahelagaia taudia edia aniani gaudia. ");
INSERT INTO hmo_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Unai dina dekenai danu taunimanima do oi boiria, vadaeni hebou helagana do umui karaia. Unai dina lalonai emui gaukara ta do umui karaia lasi. Emui tubuna ibounai ese inai taravatu be lagani ibounai hanaihanai do idia badinaia, edia noho gabudia ibounai lalonai. ");
INSERT INTO hmo_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Umui emui uma ena anina umui utua neganai, do umui utua lao lasi ela bona uma ena hetoa korikori dekenai. Bona tano dekenai idia moru kava uma anina gaudia do umui gogoa lasi. Umui rakatanidia, badina idia be ogogami taudia bona idau bese taudia edia. Lau inai Lohiabada, emui Dirava.” ");
INSERT INTO hmo_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Lohiabada ese Mose dekenai ma ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Israela taudia do oi hamaoroa, oi gwau: Hua namba 7 ena dina ginigunana be laga-ani dinana helagana ta umui dekenai. Inai dina be laloatao dinana, bona umui ese kibi do umui hiriria, unai dina ena hebou helagana dekenai do umui haboua mai totona. ");
INSERT INTO hmo_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Unai dina lalonai emui gaukara ta do umui karaia lasi, to aniani idia gabua bouboudia lau Lohiabada dekenai do umui henia.” ");
INSERT INTO hmo_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Hua namba 7 ena dina namba 10 dekenai be taunimanima edia Kara Dika ena Davana Karaia Dinana. Inai dina dekenai hebou helagana do umui karaia. Umui ese emui lalona do umui giroa, bona aniani idia gabua bouboudia Lohiabada dekenai do umui henia. ");
INSERT INTO hmo_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Unai dina dekenai gaukara ta do umui karaia lasi, badina ia be boubou karaia dinana, kara dika ena davana kokia totona. ");
INSERT INTO hmo_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Tau ta bema aniani ia ania unai dina dekenai, ia be Dirava ena bese dekena amo do lau negea. ");
INSERT INTO hmo_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Bona bema tau ta ese unai dina dekenai do ia gaukara neganai, lau Lohiabada sibona ese do lau alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Kamonai! Gaukara ta do umui karaia lasi unai dina dekenai. Inai taravatu be emui tubudia edia latanai danu, lagani ibounai hanaihanai, edia noho gabudia ibounai lalonai. ");
INSERT INTO hmo_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Inai dina be umui emui Sabati laga-ani dinana ta. Inai hua namba 7 ena dina namba 9, dina ia diho negana, ela bona dina namba 10 dina ia diho negana, inai Sabati do umui badinaia. Inai dina lalonai aniani ta do umui ania lasi.” ");
INSERT INTO hmo_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Lohiabada ese Mose ma ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Israela taudia do oi hamaoroa, hua namba 7 ena dina namba 15 be Au Raurau Ruma Maragidia Aria do idia karaia dinana. Dina 7 lalonai inai au raurau ruma maragidia dekenai do idia noho, bona lau do idia laloa. ");
INSERT INTO hmo_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Inai dina 7 ena dina ginigunana be hebou helagana totona do umui haboua, bona gaukara ta do umui karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Inai dina 7 lalonai dina ta ta ibounai lau Lohiabada dekenai boubou, gabua gaudia do umui henia. Bona dina namba 8 dekenai emui hebou helagana do umui karaia, bona boubou, gabua gaudia ma do umui henia lou. Inai dina namba 8 be guriguri dinana sibona, unai dainai emui gaukara ta do umui karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Lau Lohiabada egu dina badadia be unai. Inai dina badadia do umui badinaia. Idia be dina helagadia bona hebou helagadia dinadia lau Lohiabada hanamoa totona, emui aniani bouboudia, emui gabua bouboudia, paraoa bouboudia, boromakau bona mamoe bouboudia, bona uaina bouboudia, ta ta edia dina, edia dina dekenai do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Inai dina badadia be idau, bona pura ta ta Sabati Dinadia danu be idau. Bona inai dina badadia edia boubou gaudia ibounai be idau, emui harihari gaudia, emui gwauhamata bouboudia, bona emui tanikiu henia bouboudia, lau Lohiabada dekenai umui henia noho gaudia be ma idau. ");
INSERT INTO hmo_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Hua namba 7 ena dina namba 15 dekenai, emui uma anina ibounai umui haboua murinai, lau Lohiabada egu Au Raurau Ruma Maragidia aria be dina 7 lalonai do umui karaia, bona lau dekenai do umui laloa noho. Unai aria ena dina ginigunana be laga-ani helaga dinana, ma dina namba 8 danu. ");
INSERT INTO hmo_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Dina ginigunana dekenai emui huahua audia dekena amo huahua namodia do umui abia, bona pama raudia, bona au idauidau mai rau momo edia rigi do umui abia, bona Lohiabada emui Dirava hanamoa totona do umui moale hebou. ");
INSERT INTO hmo_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Dina 7 lalonai inai guriguri kara ena aria do umui karaia. Inai taravatu be emui tubudia do idia badinaia lagani ta ta ibounai, hanaihanai. Inai aria be hua namba 7 lalonai do umui karaia. ");
INSERT INTO hmo_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Unai dina 7 lalonai Israela taudia ibounai be au raurau ruma maragidia dekenai do idia noho. ");
INSERT INTO hmo_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Unai kara dekena amo emui tubudia do idia diba lau Lohiabada ese Israela taudia Aigupito dekena amo lau hakaudia neganai, au raurau ruma maragidia dekenai lau atodia, idia noho. Lau inai Lohiabada, emui Dirava.” ");
INSERT INTO hmo_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mose ese inai hereva ia kamonai dainai, Israela taudia ia haboua, bona Lohiabada hanamoa totona, inai dina badadia bona aria helagadia edia taravatu ia henidia. ");
INSERT INTO hmo_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Israela taudia do oi oda henia, olive au huahua ena dehoro, goevagoeva momokani, lamepa ena oela gauna, oi dekenai do idia henia, Palai Dubu ena lamepa be do idia gabua hanaihanai totona. ");
INSERT INTO hmo_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Palai Dubu lalonai, Maua Helaga ena koua dabua ena murimurinai, Arona ese inai lamepa do ia gabua. Adorahi ibounai neganai ia ese lamepa do ia gabua hamatamaia, bona hanuaboi ibounai do ia gabua noho ela bona dabai, Lohiabada ena vairana dekenai. Inai taravatu be Israela taudia edia latanai do ia noho ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Arona ese lamepa do ia naridia, lamepa dogoatao gauna dekenai, golo namo herea dekena amo karaia gauna, ena latanai unai lamepa ibounai do ia gabua hanaihanai, Lohiabada ena vairanai. ");
INSERT INTO hmo_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Paraoa namo herea, iena metau 12 kilogaram do oi abia, beredi ibounai 12 do oi gabua. ");
INSERT INTO hmo_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Inai beredi be Lohiabada ena vairanai do oi atodia, laini rua dekenai, golo namo herea patana ena latanai, laini ta be beredi 6, ma laini ta be beredi 6. ");
INSERT INTO hmo_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Inai laini ruaosi edia badinai muramura mai bonana pauda namona momokani do oi atoa. Inai bonana namona muramura be Lohiabada dekenai henia aniani boubouna ena toana, beredi ena gabu ia abia, bona Lohiabada dekenai inai pauda do oi gabua ore. ");
INSERT INTO hmo_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","“Inai beredi be Sabati Dina ibounai Lohiabada ena vairanai do idia atoa ela bona hanaihanai. Inai be Israela taudia edia harihari gauna, edia gwauhamata ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Bona inai beredi be Arona bona iena natuna taudia edia, inai beredi be gabu helagana ta dekenai do idia ania. Lohiabada ena lahi dekenai gabua bouboudia ibounai edia huanai, inai boubou sibona be helaga herea. Noho hanaihanai taravatuna be inai.” ");
INSERT INTO hmo_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Tau ta, iena sinana be Israela hahine ladana Selomiti Dibiri, Dano iduhu hahine, bona iena tamana be Aigupito tauna, be kamepa lalonai Israela korikori tauna ta danu idia heai. ");
INSERT INTO hmo_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Idia heatu noho neganai, unai Israela hahine, Selomiti, ena natuna ese Dirava ena ladana ia hereva dika henia. Unai dainai tau haida ese Mose dekenai idia hakaua lao. ");
INSERT INTO hmo_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Vadaeni unai tau idia kwatua, bona gabu ta dekenai idia koua, ela bona Lohiabada ese iena ura idia dekenai do ia hedinaraia. ");
INSERT INTO hmo_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Vadaeni Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Unai lau ia hereva dika henia tauna, be kamepa ena murimurinai do umui abia lao. Iena hereva dika idia kamonai taudia ibounai ese unai tau ena kwarana latanai edia imadia do idia atoa. Unai murimuri kamepa taudia ibounai ese nadi dekena amo do idia hodoa mase. ");
INSERT INTO hmo_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","“Israela taudia dekenai do oi hadibaia danu, Dirava do ia hereva dika henia tauna ese iena kerere davana do ia davaria. ");
INSERT INTO hmo_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Lohiabada ena ladana do ia hereva dika henia tauna be do ia mase. Israela tauna ta o Israela dekenai ia noho idau bese tauna ta bema Lohiabada ena ladana ia hereva dika henia neganai, Israela taudia ese nadi dekenai do idia hodoa mase. ");
INSERT INTO hmo_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Tau ta ia alaia tauna be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Bema tau ta ena mauri gauna be tau ma ta ese ia alaia mase, unai mauri gauna ena davana be iena biaguna dekenai do ia henia. Mauri gauna ena davana be mauri gauna. ");
INSERT INTO hmo_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Bema tau ta ese ma tau ta ia haberoa, ia haberoa hegeregerena dekena amo, danu do idia haberoa. ");
INSERT INTO hmo_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Bero ena davana be bero, matana ena davana be matana, isena ena davana be isena. Ia ese tau ta ia hadikaia hegeregerena, umui ese ia danu do umui hadikaia. ");
INSERT INTO hmo_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","“Ubua gauna ia alaia mase tauna ese davana, ubua gauna hegeregerena ta do ia henia, to taunimanima do ia alaia mase tauna be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“Israela dekenai idia noho idau bese taudia bona Israela taudia korikori dekenai inai taravatu be tamona. Lau Lohiabada be umui emui Dirava.” ");
INSERT INTO hmo_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mose ese Israela taudia dekenai unai hereva ia hamaorodia murinai, idia ese unai tau idia abia, kamepa ena murimurinai idia hakaua lao. Unuseni nadi dekena amo idia hodoa mase. Inai dala dekenai Israela taudia ese Lohiabada ena oda Mose dekenai idia badinaia. ");
INSERT INTO hmo_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Lohiabada ese Sinai Ororo dekenai Mose dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Israela taudia do oi hamaoroa, do oi gwau: Umui dekenai lau henia tano dekenai do umui ginidae neganai, umui ese Lohiabada hanamoa totona lagani namba 7 ibounai emui uhe do umui hadoa lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Lagani 6 lalonai emui uhe do umui hadoa, bona lagani 6 lalonai emui vain audia do umui utua, ena huahua do idia momo totona, huahua danu do umui haboua. ");
INSERT INTO hmo_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","“To lagani namba 7 be tano ena lagani-ani negana, lagani-ani helagana Lohiabada ena. Emui tano dekenai uhe do umui hadoa lasi, bona emui vain audia do umui utua lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Unai lagani namba 7 lalonai danu emui uiti o koni, sibona idia tubu kava gaudia do umui utua bona haboua lasi, bona emui vain audia umui utua lasi gaudia edia huahua danu do umui haboua lasi, badina tano ena lagani-ani helagana be unai. ");
INSERT INTO hmo_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","“Uhe do umui hadoa lasi, to unai lagani namba 7 lalonai, sibona ia vara aniani do umui ania diba, emui hesiai taudia, emui gaukara taudia, bona umui danu idia noho idau taudia ese danu do idia ania. ");
INSERT INTO hmo_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Emui boromakau bona ubua gaudia, bona emui tano dekenai noho dagedage gaudia ese danu unai tano ena anina idia ania diba.” ");
INSERT INTO hmo_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Ma Lohiabada ia hereva, ia gwau, “Lagani 7 be nega 7 do oi duahia. Inai be ibounai lagani 49. ");
INSERT INTO hmo_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Vadaeni unai murinai, lagani namba 50 ena hua namba 7 bona dina namba 10, Kara Dika Ena Davana Karaia Dinana dekenai kibi do umui hiriria. Io, tau ta do oi siaia loaloa, emui tano ibounai dekenai kibi do ia hiriria. ");
INSERT INTO hmo_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","“Inai dala dekenai umui ese lagani namba 50 do umui hahelagaia. Unai lagani lalonai, emui tano lalonai noho guia taudia ibounai, be do umui ruhaia. Inai lagani ena lalonai danu taunimanima ibounai ese edia tano korikori, bona edia iduhu korikori dekenai do idia giroa lou. Inai lagani ena ladana be Iubili. ");
INSERT INTO hmo_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","“Lagani namba 50 lalonai emui tano do umui hadoa lasi, bona sibona do ia tubu gauna do umui utua lasi. Emui vain edia rigi danu do umui utua lasi, bona vain huahua do umui haboua lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Badina be Iubili Lagani be helaga umui dekenai. Tano ena anina be dina ta ta do umui abia, do umui ania, to utua haboua lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Iubili Lagani lalonai, umui hoia lao vadaeni tano be do umui abia lou. ");
INSERT INTO hmo_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Unai dainai oiemu tano oiemu badibadina dekenai ia noho Israela tauna dekenai oi hoia lao, o oi hoia mai neganai, do oi koia lasi, ia ese danu oi do ia koia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","“Oiemu badibadinai tauna ena tano oi hoia neganai, do oi laloa, Iubili ena murinai lagani hida idia lao vadaeni, bona ia ese danu do ia laloa tano ena anina utua negadia hida idia noho ela bona Iubili. ");
INSERT INTO hmo_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Bema lagani momo idia noho ela bona Iubili, tano ena davana be do ia bada, to bema lagani momo lasi idia noho, tano ena davana be maragi. Badina oi hoia gauna korikori be tano ena anina utua negadia sibona. ");
INSERT INTO hmo_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","“Umui ruaosi ta ta dekenai do umui koia lasi, to emui Dirava dekenai do umui gari, badina lau be Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Unai dainai, lau Lohiabada egu taravatu bona egu oda ibounai do umui kamonai henia, unai neganai emui noho be do ia namo emui tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","“Tano ese iena anina do ia havaraia. Bona umui ese tano ena aniani do umui ania, do umui boga kunu, bona do umui noho namonamo. ");
INSERT INTO hmo_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“To sedira do umui nanadaia, do umui gwau, ‘Lagani namba 7 lalonai dahaka do ita ania, badina tano do ita hadoa lasi, bona anina do ita utua lasi?’ ");
INSERT INTO hmo_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","“Lau Lohiabada ese lagani namba 6 lalonai tano do lau hanamoa. Vadaeni lagani namba 6 lalonai, tano be anina bada do ia havaraia, bona unai do umui utua haboua aniani be lagani rua edia aniani hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","“Vadaeni lagani namba 8 lalonai, emui uhe ma umui hadoa neganai, umui ese lagani namba 6 ena aniani do umui ania noho, bona emui aniani be do ia hegeregere ela bona lagani namba 8 ena anina do umui utua negana. ");
INSERT INTO hmo_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Emui tano umui hoia lao, ia ore vadaeni, be umui karaia diba lasi, badina umui ese umui biagua momokani lasi, ia be Dirava ena. Umui ese tano dekenai umui noho, be vadivadi taudia bamona umui noho sibona, badina tano be Dirava ena. ");
INSERT INTO hmo_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","“Umui hoia mai tanodia ibounai be edia biagudia gunadia ese idia hoia lou diba, bema idia ura neganai. ");
INSERT INTO hmo_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Bema umui ta ia ogogami, bona unai dainai iena tano ia hoia lao neganai, unai ogogami tauna ena varavara korikori tauna ta ese unai tano davana do ia karaia, vadaeni do ia hoia lou. ");
INSERT INTO hmo_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Bema unai ogogami tauna be mai ena varavara lasi, do ia hoia lou totona, sedira gabeai ia sibona be mai ena moni hegeregerena do ia hoia. ");
INSERT INTO hmo_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Unai neganai ia ese do ia duahia, lagani hida idia lao vadaeni ia ese ia hoia, bona tano anina utua negadia hida idia do noho ela bona Iubili, vadaeni unai taboro edia davana hegeregerena do ia henia lou, bona iena tano ma do ia abia lou. ");
INSERT INTO hmo_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","“To bema iena moni be hegeregere lasi, bona ia abia lou diba lasi, ia hoia tauna ese tano do ia birulaia noho ela bona Iubili Lagani. Unai neganai tano ena biaguna korikori ese iena tano do ia abia lou, davana lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Hanua mai ena magu lalonai bema tau ta ese iena ruma do ia hoia lao, moni davana, ia ese davana do ia henia lou, bona iena ruma ia abia lou diba, ela bona lagani ta do ia ore. Lagani ta lalonai ia hoia lou diba. ");
INSERT INTO hmo_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","“To bema lagani ta lalonai ia abia lou lasi, unai ruma be ia dekena amo ia hoia tauna ena ruma korikori do ia lao, iena natuna bona tubuna taudia danu edia. Bona unai ruma be Iubili Lagani dekenai biaguna gunana ese ia abia lou diba lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","“To hanua maragidia, mai edia magu lasi hanua lalonai ruma idia hoia, be tano idia hoia hegeregerena, ruma edia biaguna korikori taudia ese edia ruma idia hoia lou diba, bona Iubili Lagani lalonai unai ruma be edia biagudia korikori ese do idia abia lou. ");
INSERT INTO hmo_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“To Levi taudia edia hanua dekenai, Levi taudia ese edia ruma idia hoia lou diba, lagani ibounai lalonai. ");
INSERT INTO hmo_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Bona Levi tauna ta, bema iena ruma ia hoia lou lasi, ia be Iubili Lagani dekenai do ia abia lou. Badina be Levi taudia edia hanua rumadia be edia ruma korikori, Israela taudia edia huanai. ");
INSERT INTO hmo_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","“To Levi hanuadia idia hagegea tano ibounai be haida ese do idia hoia diba lasi. Unai be Levi taudia edia tano korikori ela bona hanaihanai. ");
INSERT INTO hmo_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Bema oiemu bese tamona Israela tauna ta umui emui huanai ia noho, be ia ogogami, iena aniani abia dalana be lasi, oi ese do oi ubua, laolao tauna o vadivadi tauna bamona. ");
INSERT INTO hmo_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","“Moni o kohu be ia dekena amo do oi abia lasi, to oiemu Dirava do oi gari henia, bona oiemu varavara Israela tauna do oi hamauria, emui huana dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","“Bema moni oi heniatorehai neganai, mai atoa kau moni danu do oi abia lou lasi, bona aniani be ia dekenai oi hoia neganai, profit moni do oi abia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","“Lau inai Lohiabada, emui Dirava, Aigupito tano dekena amo umui lau hakaua mai. Inai bamona lau karaia, Kanana tano umui dekenai do lau henia totona, bona emui Dirava do lau lao totona. ");
INSERT INTO hmo_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Bema oiemu bese tamona Israela tauna ta, umui emui huanai ia noho, be ia ogogami, bona oi dekenai sibona ia hoia neganai, hesiai mai guia danu tauna dekenai oi karaia bamona, be ia dekenai do oi karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ia be oi dekenai do ia noho, oiemu gaukara tauna mai davana, bona oi dekenai do ia gaukara noho, ela bona Iubili Lagani ia ginidae negana. ");
INSERT INTO hmo_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Unai neganai ia bona iena natuna ibounai be do oi ruhaia, bona iena iduhu dekenai do idia giroa lou, iena iduhu taudia edia tano dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","“Israela taudia be Lohiabada ena hesiai taudia mai guia danu, bona ia ese Aigupito dekena amo ia hakaudia mai. Idia be hesiai mai guia danu gaukara totona do umui hoidia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Do umui dagedage henidia lasi, to emui Dirava do umui gari henia. ");
INSERT INTO hmo_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Bema hesiai taudia mai guia danu umui ura hoia neganai, idau bese taudia dekena amo do umui hoidia. ");
INSERT INTO hmo_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","“Umui emui huanai idia noho idau bese taudia do umui hoia diba. Inai bamona maragidia, emui tano dekenai idia vara taudia be do umui biagua diba. ");
INSERT INTO hmo_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Umui emui murinai, emui natudia tau, ese unai hesiai taudia do idia abia, bona unai hesiai taudia ese edia hesiai gaukara do idia karaia, edia mauri dinadia ibounai lalonai. To umui ese emui bese tamona Israela taudia be do umui dagedage henidia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Sedira umui emui huanai ia noho idau bese tauna ta be mai ena kohu momo, to emui bese tamona Israela tauna be ogogami dainai sibona ia hoia unai kohu momo tauna o iena bese ta dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Unai neganai unai Israela ogogami tauna ena tadikakana ese ia hoia lou diba, ");
INSERT INTO hmo_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","o iena tamana maragi ese, o iena varavara tauna ta ese, o ia sibona moni do ia davaria neganai, be ia sibona ena mauri do ia hoia lou diba. ");
INSERT INTO hmo_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“Ia bona ia hoia tauna ese lagani do idia duahia, sibona ia hoia lagani ela bona Iubili Lagani be lagani hida. Vadaeni sibona do ia hoia lou ena davana be unai lagani ena namba hegeregerena, bona gaukara davana be hesiai tauna mai davana ta ena davana hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","“Bema lagani momo idia do noho ela bona Iubili Lagani, sibona do ia ruhaia iena biaguna dekena amo ena davana be bada. ");
INSERT INTO hmo_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","To bema lagani momo lasi idia do noho ela bona Iubili Lagani, sibona do ia ruhaia ena davana be maragi. ");
INSERT INTO hmo_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Unai idau bese biaguna ese iena Israela hesiai tauna do ia dagedage henia lasi, bona iena gaukara davana be lagani ta ta do ia henia namonamo. ");
INSERT INTO hmo_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Bema inai Israela hesiai tauna, sibona ia hoia tauna, be idia ruhaia guna lasi, ia be Iubili Lagani lalonai do idia ruhaia, ia bona iena natuna ibounai danu. ");
INSERT INTO hmo_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","“Israela taudia be hesiai gaukara mai guia danu do idia karaia daudau lasi, badina be Israela taudia be Lohiabada ena hesiai mai guia taudia. Lohiabada ese Aigupito tano dekena amo ia mailaidia. Lau Lohiabada be umui Israela taudia emui Dirava.” ");
INSERT INTO hmo_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Lohiabada ia gwau, “Kaivakuku do umui karaia lasi. Dirava ena laulauna nadi dekena amo do umui karaia lasi, tomadiho totona do umui haginia lasi. Du helagana, o nadi, ena toana namo dekenai do umui tomadiho henia lasi, emui tano ibounai lalonai. Lau be Lohiabada, emui Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Lauegu Sabati Dina ibounai do umui badinaia, bona egu tomadiho gabuna do umui matauraia. Lau inai Lohiabada. ");
INSERT INTO hmo_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Bema lauegu taravatu umui badinaia bona lauegu oda umui kamonai henia, ");
INSERT INTO hmo_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","lau ese medu namona umui dekenai do lau henia, ena nega korikori neganai, vadaeni tano ese ena anina do ia havaraia, bona uma audia do idia huahua. ");
INSERT INTO hmo_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","“Emui uiti umui do utua haorea lasi neganai, emui vain huahua utua neganai do ia hamatamaia. Bona vain huahua utua negana ia do ore lasi neganai, hadohado negana do ia ginidae. Do umui aniani boga kunu, bona emui tano dekenai do umui noho namonamo, gari ta lasi. ");
INSERT INTO hmo_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Lau ese maino umui dekenai do lau henia, emui tano lalonai. Do umui laga-ani, bona tau ta ese umui do ia hagaria lasi. Uda boroma, dagedage gaudia do lau haorea emui tano dekenai, bona tuari be emui tano dekenai do ia vara lasi. ");
INSERT INTO hmo_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","“Umui dekenai idia tuari henia taudia dekena amo do umui kwalimu, do umui luludia, bona emui tuari kaia dekena amo do umui aladia mase. ");
INSERT INTO hmo_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Umui 5 ese 100 do umui lulua lao, do umui halusidia, bona umui emui taudia 100 ese 10,000 do umui halusia. Badina umui dekenai idia tuari taudia ibounai be umui ese do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Lau ese umui do lau hanamoa, bona natuna momo umui dekenai do lau henia. Lauegu gwauhamata taravatuna umui dekenai do lau hamomokania. ");
INSERT INTO hmo_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Emui uiti anina haboua sitoa rumadia be do mai edia uiti neganai, inai orena do umui negea, uiti ena anina matamata edia gabu do umui karaia totona. ");
INSERT INTO hmo_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","“Lau ese umui emui huanai do lau noho, egu Palai Dubu lalonai, bona egu Lauma ese umui dekena amo do ia giroa lasi. ");
INSERT INTO hmo_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Umui emui huanai do lau raka, bona emui Dirava do lau lao, umui danu egu bese taudia do umui lao. ");
INSERT INTO hmo_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","“Lau inai Lohiabada, emui Dirava, Aigupito tano dekena amo umui lau hakaua mai, Aigupito taudia edia hesiai gaukara do umui karaia lou lasi totona. Umui ia hadikaia siahuna lau hamakohia, bona umui lau haginia maoromaoro.” ");
INSERT INTO hmo_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Lohiabada ia gwau, “Bema egu oda hereva umui kamonai henia lasi, lau ese emui kerere davana do lau henia. ");
INSERT INTO hmo_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Bema egu taravatu bona oda umui badinaia lasi, bona iseda gwauhamata taravatuna umui hamakohia neganai, ");
INSERT INTO hmo_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","lau ese umui do lau panisia. Lau ese karaharaga gari dika herea umui dekenai do lau siaia, hanamoa diba lasi gorere, tauanina hamaragia bona hasiahua gorere, matakepulu idia havaraia gorere danu umui emui latanai do lau atoa, vadaeni emui mauri be metairametaira do idia ore. Emui uhe do umui hadoa, to anina do umui davaria lasi, badina umui dekenai idia tuari taudia ese do idia ania. ");
INSERT INTO hmo_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","“Lauegu vairana be umui dekena amo do lau giroa, bona unai dainai umui dekenai idia tuari henia taudia ese umui do idia halusia. Bona umui dekenai idia badu henia taudia ese umui do idia biagua. Tau ta ese umui ia lulua lasi neganai umui be do umui heau. ");
INSERT INTO hmo_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Inai gau dikadia murinai, bema umui ese ma lau dekenai umui kamonai henia lasi, lau ese emui kara dika ena davana do lau habadaia nega 7. ");
INSERT INTO hmo_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Umui emui goada ena hekokoroku do lau hamakohia, medu be do lau siaia diho lasi, bona emui tano be do ia auka, auri bamona. ");
INSERT INTO hmo_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","“Do umui gaukara auka, to anina do umui davaria lasi, badina emui tano ese anina do ia havaraia lasi, bona au ese huahua do idia atoa lasi. ");
INSERT INTO hmo_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Bema umui ese ma lau dekenai umui laloa auka henia, bona lau dekenai umui do kamonai henia lasi, lau ese emui kara dika ena davana ma do lau habadaia lou nega 7. ");
INSERT INTO hmo_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Lau ese uda dekenai noho dagedage gaudia umui emui huanai do lau siaidia. Idia ese emui natudia do idia alaia mase, bona emui boromakau bona mamoe do idia hadikaia ore. Unai dainai umui emui bese do ia maragi lao. Vadaeni emui raka daladia edia latanai ava kavakava do idia tubu. ");
INSERT INTO hmo_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Bema inai gau dikadia murinai umui ese lau dekenai umui kamonai henia lasi noho, bona lau dekenai umui dagedage noho, ");
INSERT INTO hmo_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","lau ese umui do lau dagedage henia, bona emui kara dika ena davana ma do lau habadaia nega 7. ");
INSERT INTO hmo_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Lau ese tuari umui dekenai do lau siaia, umui ese iseda gwauhamata taravatuna umui hamakohia dainai. Bona bema emui hanua badadia dekenai umui haboua neganai, lau ese hanamoa diba lasi gorere umui dekenai do lau siaia, vadaeni umui idia tuari henia taudia edia siahu henunai do umui moru. ");
INSERT INTO hmo_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","“Lau ese emui aniani davaria dalana do lau koua, vadaeni hahine 10 ese emui paraoa do idia gabua diba amu tamona lalonai. Umui dekenai inai beredi do idia haria, to umui ania murinai, do umui hitolo noho. ");
INSERT INTO hmo_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Unai kara ibounai murinai bema lau dekenai umui kamonai henia lasi, bona lau umui dagedage henia noho neganai, ");
INSERT INTO hmo_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","mai badu danu umui dekenai do lau dagedage, bona emui kerere davana be ma do lau habadaia nega 7. ");
INSERT INTO hmo_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Emui hitolo be do ia bada herea dainai, umui sibona emui natudia do umui anidia. ");
INSERT INTO hmo_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","“Emui tomadiho gabudia, ororo dekenai idia noho gaudia, be do lau hadikaia ore, emui bonana namo muramura patadia do lau veria diho, bona emui mase tauanidia be emui kaivakuku edia latanai do lau negedia. Unai kaivakuku be mauri diba lasi gaudia. ");
INSERT INTO hmo_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","“Emui hanua do lau hadikadia ore, emui dubu do lau hamakohia maragimaragi, bona emui boubou be do lau abia dae lasi momokani. ");
INSERT INTO hmo_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","“Emui tano do lau hadikaia ore momokani, vadaeni umui dekenai idia tuari taudia idia itaia neganai, do idia hoa bada. ");
INSERT INTO hmo_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","“Lau ese tuari umui emui latanai do lau siaia, vadaeni umui be idau bese taudia edia tano idauidau dekenai umui do lau lulua lao. Emui biru totona tano, be do ia noho kava, badina taunimanima be lasi, bona emui hanua be dika momokani do idia noho. ");
INSERT INTO hmo_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“Unai neganai tano ese iena laga-ani lalonai do ia moale, iena noho kava dinadia ibounai, umui ibounai be umui idia tuari henia taudia edia tano dekenai umui noho neganai. Tano ese iena Sabati laga-ani dekenai do ia moale. ");
INSERT INTO hmo_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Io, do ia noho kava negana ibounai, tano ese laga-ani namona do ia abia, laga-ani korikori, umui ese umui noholaia neganai bamona lasi, badina umui ese tano dekenai Sabati ena laga-ani umui henia lasi. ");
INSERT INTO hmo_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Bona umui do mauri noho taudia, idau bese taudia edia tano dekenai umui noho, be do lau hagaria dikadika, vadaeni lai ese au raurau do ia hamarerea regena umui kamonai neganai, umui be do umui heau. Io, do umui heau, tuari taudia ese umui idia lulua bamona. Bona ta ese umui ia tuari henia lasi neganai do umui moru. ");
INSERT INTO hmo_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Tau ta ese umui ia lulua lasi neganai, umui ta ta dekenai do umui bamepa, bona do umui moru kava, bona emui goada be hegeregere lasi tuari taudia do umui tuari henia. ");
INSERT INTO hmo_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","“Umui be idau bese taudia edia tano dekenai do umui mase, umui idia tuari henia taudia edia tano ese umui do ia ania ore. ");
INSERT INTO hmo_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Umui tamona tamona unai tano idauna dekenai do mauri noho taudia, be metairametaira do umui manoka lao, ela bona umui mase, emui kara dika dainai, bona emui tamadia, tubudia edia kara dika dainai. ");
INSERT INTO hmo_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“To umui emui natudia bona tubudia ese edia kara dika do idia gwauraia hedinarai, edia tamadia edia kara dika danu, bona edia dagedage bona kamonai henia lasi lau dekenai karadia danu do idia gwauraia hedinarai. ");
INSERT INTO hmo_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Unai kara dikadia dainai lau badu henidia, bona idia dekenai idia tuari taudia edia tano dekenai lau siaidia. To gabeai idia edia hekokoroku do idia negea, bona edia kamonai lasi bona edia kara dika ena davana do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","“Unai neganai lau ese egu gwauhamata taravatuna, Iakobo bona Isako bona Aberahamo dekenai lau henia gauna do lau laloa, bona tano danu do lau laloa. ");
INSERT INTO hmo_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","To guna, tano dekena amo taunimanina do lau lulua, tano ese laga-ani do ia abia totona. Bona unai taunimanima ese egu taravatu bona oda idia negea dainai, edia kerere davana do idia karaia momokani. ");
INSERT INTO hmo_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“To idia tuari henidia taudia edia tano dekenai idia do noho neganai, lau ese idia do lau rakatania momokani lasi, do lau hadikadia momokani lasi. Badina unai be egu gwauhamata taravatuna idia dekenai makohia kara. Unai bamona do lau karaia lasi, badina lau be Lohiabada, edia Dirava. ");
INSERT INTO hmo_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","“Unai gwauhamata taravatuna, edia sene taudia danu ai karaia gauna be do lau hamatamaia lou. Badina lau ese Aigupito dekena amo idia lau mailaia, lau be edia Dirava do lau lao totona. Unai kara dekena amo lau ese idau bese taudia ibounai edia vairana dekenai lauegu siahu lau hedinaraia. Lau inai Lohiabada.” ");
INSERT INTO hmo_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Taravatu bona oda be inai, Lohiabada ese Mose dekenai ia henia, Sinai Ororo ena latanai, Lohiabada bona Israela taudia edia huanai gaudia. ");
INSERT INTO hmo_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Lohiabada ese Mose ma ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Israela taudia do oi hamaoroa, bema tau ta ese ia gwauhamata, sibona o taunimanima ta Lohiabada dekenai do ia henia neganai, hoia lou davadia be inai: ");
INSERT INTO hmo_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Tau ta, ena mauri lagani 20 ela bona 60 be siliva moni 50, Helaga Gabuna ena sikele hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Hahine be siliva moni 30. ");
INSERT INTO hmo_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Mero ta, ena mauri lagani be 5 ela bona 20, be siliva moni 20. Kekeni ta be siliva moni 10. ");
INSERT INTO hmo_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Mero maragina ta, ela bona mauri lagani 5, be siliva moni 5. Kekeni maragina ta, ela bona mauri lagani 5, be siliva moni 3. ");
INSERT INTO hmo_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Tau buruka ta, ena mauri lagani be 60 mai kahana, be siliva moni 15. Hahine buruka ta, ena mauri lagani be 60 mai kahana, be siliva moni 10. ");
INSERT INTO hmo_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Bema gwauhamata ia gwauraia tauna be ogogami dainai davana korikori ia henia diba lasi, ia ese gwauhamata ia henia dekenai tauna do ia mailaia, hahelagaia tauna ena vairana dekenai do idia gini hebou. Vadaeni hahelagaia tauna ese davana do ia hamaragia, unai gwauhamata tauna ese ia henia diba hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Bema tau ta ia gwauhamata, mauri gauna ta lau Lohiabada dekenai do ia henia, ia ese do lau abia dae diba gauna do ia mailaia. Bona unai bamona boubou be lau dekenai do ia helaga. ");
INSERT INTO hmo_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Unai mauri gauna totona ia gwauhamata tauna ese mauri gauna ma ta unai gunana ena gabu dekenai ia henia diba lasi. Namona ta be dikana ena gabu ia abia diba lasi. Dikana ta be namona ena gabu ia abia diba lasi. To bema ta ma ia henia neganai, ruaosi be helaga, Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“To bema gwauhamata be mauri gauna mirona ta totona, Lohiabada ese boubou totona do ia abia dae lasi gauna, gwauhamata tauna ese unai mauri gauna be hahelagaia tauna ena vairana dekenai do ia abia lao. ");
INSERT INTO hmo_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Hahelagaia tauna ese unai mauri gauna ena davana do ia gwauraia, mauri gauna ena namo o dika hegeregerena, bona davana korikori be unai. ");
INSERT INTO hmo_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","“Bema unai tau ia ura unai mauri gauna do ia hoia lou neganai, ia be atoa kau moni danu do ia henia. Atoa kau moni be, bema davana korikori be karoa 5 neganai, karoa ta be atoa kau moni ena bada, vadaeni davana be karoa 6. ");
INSERT INTO hmo_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Bema tau ta ese iena ruma be Lohiabada dekenai ia henia, helaga gauna, hahelagaia tauna ese unai ruma ena davana do ia gwauraia, ruma ena namo o dika hegeregerena, bona ena davana korikori be unai. ");
INSERT INTO hmo_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","“Bema ruma ia henia tauna ia ura hoia lou neganai, ia ese davana korikori do ia henia, mai atoa kau moni danu. Atoa kau moni be, bema davana korikori be karoa 5, karoa ta be atoa kau moni ena bada, vadaeni davana be karoa 6. ");
INSERT INTO hmo_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Bema tau ta ese iena tano ena kahana ta Lohiabada dekenai ia hahelagaia neganai, unai tano ena davana be, idia hadoa neganai uhe hida tano lalonai do idia atoa hegeregerena. Bali ena metau 20 kilogaram ena davana be siliva moni 10. ");
INSERT INTO hmo_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","“Bema unai tano be Iubili Lagani dekenai ia hahelagaia, tano ena davana be bada. ");
INSERT INTO hmo_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","To bema Iubili Lagani murinai unai tano Lohiabada dekenai ia hahelagaia, hahelagaia tauna ese davana do ia hamaragia, lagani hida do idia noho ela bona Iubili Lagani hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","“Bema unai tano ia hahelagaia vadaeni tauna ese ia ura tano do ia hoia lou, tano ena davana do ia henia, mai atoa kau moni danu. Atoa kau moni be, bema davana korikori be karoa 5, karoa ta be atoa kau moni ena bada, vadaeni davana be karoa 6. ");
INSERT INTO hmo_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","“Bema tano ia hahelagaia vadaeni tauna ese unai tano be tau ta dekenai ia hoia lao, to Lohiabada dekena amo ia hoia lou guna lasi, unai tau ese unai tano do ia hoia lou diba lasi, ");
INSERT INTO hmo_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","bona Iubili Lagani do ia ginidae neganai, unai tano be Lohiabada ena tano helagana korikori do ia lao. Hahelagaia taudia ese do idia abia, edia tano. ");
INSERT INTO hmo_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Bema tau ta ese iena tano ta, iena sene taudia dekena amo ia abia lasi, to moni dekena amo ia hoia gauna ia hahelagaia Lohiabada ena, ");
INSERT INTO hmo_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","hahelagaia tauna ese do ia duahia lagani hida do ia noho ela bona Iubili Lagani, bona unai lagani edia momo hegeregerena, tano ena davana do ia gwauraia. Bona unai dina dekenai unai tau ese unai tano ena davana Lohiabada dekenai do ia henia. Unai moni be helaga, Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","“To Iubili Lagani dekenai unai tano be iena biaguna korikori, iena sene taudia dekena amo ia abia tauna, ese do ia abia lou. ");
INSERT INTO hmo_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“Davana ibounai be Helaga Gabuna ena dala maorona, bona ena sikele dekena amo do idia duahia namonamo. ");
INSERT INTO hmo_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Mauri gaudia edia vara guna natudia be Lohiabada ena. Unai dainai tau ta ese unai bamona ta Lohiabada dekenai ia hahelagaia diba lasi. Boromakau natuna vara guna, bona mamoe natuna vara guna ibounai be Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","“To mauri gauna mirona ena natuna vara guna be biaguna ese moni dekena amo ia hoia lou diba, Helaga Gabuna ese ia gwauraia davana dekenai, mai atoa kau moni danu. Atoa kau moni be, bema davana korikori be karoa 5, karoa ta be atoa kau moni ena bada, vadaeni davana be karoa 6. To bema biaguna ese ia hoia lou lasi, hahelagaia tauna ese do ia hoia lao diba, ena davana korikori dekenai. ");
INSERT INTO hmo_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Bema tau ta ese taunimanima ta, o mauri gauna ta, o tano ta be Lohiabada dekenai ia henia ore momokani, ia ese ia hoia lao, o hoia lou diba lasi. Unai bamona taudia bona gaudia be helaga momokani, Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“Taunimanima ta, bema ia dika rohoroho, bona iena kerere davana be mase, bona bema kota ese Lohiabada dekenai ia henia ore neganai, unai tau o hahine be idia hoia lou diba lasi. Ia be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Tano ena anina ibounai, uiti, bali, koni, o au huahua ibounai, be edia karoa 10 dekena amo, karoa ta do umui hahelagaia, Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Bema tau ta ia ura unai karoa helagana ta ia hoia lou, ia ese davana korikori mai atoa kau moni danu do ia henia. Atoa kau moni be, bema davana korikori be karoa 5, karoa ta be atoa kau moni ena bada, vadaeni davana be karoa 6. ");
INSERT INTO hmo_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“Boromakau orea bona mamoe orea danu edia karoa namba 10 do umui atoa siri, Lohiabada ena. Edia biaguna ese 10, 10 dekena amo do ia duahia, bona namba 10 gaudia be helaga, Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","“Biaguna ese do ia itaia lasi, edena be namona, o edena be dikana, bona dikadia do ia abia hidi lasi, namodia edia gabu do idia abia totona. Bema biaguna ese mauri gauna ta unai bamona ia senisia gwauraia neganai, gau ruaosi, namona bona dikana danu, be do idia helaga, Lohiabada ena. Bona biaguna ese do ia hoia lou diba lasi.” ");
INSERT INTO hmo_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Inai taravatu be Lohiabada ese Mose dekenai ia henia, Sinai Ororo dekenai, Israela taudia totona. ");
INSERT INTO hmo_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Israela taudia ese Aigupito idia rakatania murinai lagani iharuana, ena hua iharuana, bona hua ena dina ginigunana dekenai Lohiabada ese Mose dekenai ia hereva, Sinai ena taunimanima noho lasi gabuna dekenai, Palai Dubu lalonai. Lohiabada ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Oi bona Arona ese Israela besena ibounai do umui duahia, edia iduhu ta ta, bona ta ta edia tamana edia ruma edia lalonai. Tau ibounai edia ladana do umui torea, ");
INSERT INTO hmo_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","edia mauri lagani 20, bona 20 idia hanaia tatau ibounai, Israela tuari taudia totona idia lao diba taudia ibounai. ");
INSERT INTO hmo_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","“Iduhu gunalaia taudia do umui abia hidi, iduhu ta ta dekena amo tau ta ta do umui abia hidi, idia ese inai duahia gaukara do idia durua.” ");
INSERT INTO hmo_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Inai duahia gaukara totona Mose bona Arona do idia durua taudia be inai: Rubena iduhu: Elisuru Sedeuru ");
INSERT INTO hmo_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeona iduhu: Selumiele Surisadai ");
INSERT INTO hmo_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Iuda iduhu: Nasona Aminadaba ");
INSERT INTO hmo_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isakara iduhu: Netanele Suara ");
INSERT INTO hmo_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Sebuluno iduhu: Eliaba Helona ");
INSERT INTO hmo_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Eparaima, Iosepa ena iduhu: Elisama Amihuda Manase, Iosepa ena iduhu: Gamaliela Pedasuru ");
INSERT INTO hmo_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Beniamina iduhu: Abidana Gideoni ");
INSERT INTO hmo_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dano iduhu: Ahiesere Amisadai ");
INSERT INTO hmo_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asere iduhu: Pagiele Okarana ");
INSERT INTO hmo_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gado iduhu: Eliasapa Reuele ");
INSERT INTO hmo_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Napatali iduhu: Ahira Enana ");
INSERT INTO hmo_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Inai taudia be edia iduhu huana dekenai idia abia hidi vadaeni, edia tamadia edia iduhu gunalaia taudia. Idia be Israela edia iduhu kwarana taudia. ");
INSERT INTO hmo_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Unai taudia be Mose bona Arona ese idia abidia, ");
INSERT INTO hmo_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","bona hua iharuana ena dina ginigunana dekenai idia ese Israela oreana ibounai idia haboua. Unai neganai taunimanima ibounai edia ladana, edia iduhu bona edia bese ladana idia torea. Tatau ibounai, edia mauri lagani be 20 idia hanaia taudia edia ladana idia torea, bona idia duahia, ");
INSERT INTO hmo_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Lohiabada ese ia oda hegeregerena. Sinai tano, taunimanima idia noho lasi gabuna dekenai Mose ese taunimanima edia ladana ia torea. ");
INSERT INTO hmo_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","45","Tatau ibounai, edia mauri lagani 20 idia hanaia, edia ladana, edia iduhu, bona edia goada be hegeregere tuari taudia do idia lao taudia edia bese be Mose ese ia torea. Iakobo ena natuna vara guna, Rubena ena iduhu dekenai be inai duahia gaukara idia hamatamaia. Iduhu ibounai bona edia tatau edia momo be inai: Rubena iduhu: 46,500 Simeona iduhu: 59,300 Gado iduhu: 45,650 Iuda iduhu: 74,600 Isakara iduhu: 54,400 Sebuluno iduhu: 57,400 Eparaima iduhu: 40,500 Manase iduhu: 32,200 Beniamina iduhu: 35,400 Dano iduhu: 62,700 Asere iduhu: 41,500 Napatali iduhu: 53,400 ");
INSERT INTO hmo_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Tuari dekenai idia lao diba tatau ibounai be 603,550 ");
INSERT INTO hmo_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","To idia ese Levi iduhu taudia be iduhu haida danu idia duahia lasi. ");
INSERT INTO hmo_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Badina be Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Levi iduhu taudia be Israela taudia danu do oi duahia hebou lasi, bona edia ladana do oi torea hebou lasi. ");
INSERT INTO hmo_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","“Levi taudia do oi abia hidi, idia ese lau noho ena toana, Palai Dubu, mai ena kohu ibounai do idia naria. Idia ese Palai Dubu mai ena kohu ibounai do idia huaia, bona idia sibona ese Dubu lalonai do idia gaukara, bona idia kamepa neganai, Palai Dubu, be edia palai ruma dekena amo do idia hagegea. ");
INSERT INTO hmo_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Palai Dubu be gabu ta dekenai do umui abia lao neganai, Levi taudia ese do idia atoa diho, bona gabu matamata dekenai umui ginidae neganai, Levi taudia ese do idia haginia lou. Bema idau iduhu tauna be Palai Dubu kahirakahira ia raka mai neganai, do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","“Israela taudia be edia iduhu ta ta dekena amo do idia kamepa, iduhu ta ta edia kamepa, edia kamepa gabudia dekenai, bona iduhu ta ta be mai edia pepe danu. ");
INSERT INTO hmo_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","“To Levi taudia ese edia palai rumadia be Palai Dubu kahirakahira do idia haginia hagegea, Palai Dubu do idia gimaia totona. Badina be bema tau ta be egu Palai Dubu kahirakahira do ia raka, egu badu ese Israela taudia do ia hadikaia diba.” ");
INSERT INTO hmo_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israela taudia ese unai bamona idia karaia, Lohiabada ese Mose dekenai ia hadibaia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Lohiabada ese Mose bona Arona ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Israela taudia idia kamepa neganai, iduhu ta ta dekena amo edia palai ruma do idia haginia, edia iduhu ena pepe edia henunai, bona Israela taudia edia palai rumadia ese Palai Dubu do idia hagegea.” ");
INSERT INTO hmo_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","9","Kamepa ena dina ia daekau kahana dekenai, Iuda orea ena pepe henunai be inai iduhu toi do idia kamepa hebou, to ta ta edia iduhu dekena amo, bona edia gunalaia taudia ta ta henunai, edia momo be inai bamona: Iuda: Nasona Aminadaba 74,600 Isakara: Netanele Suara 54,400 Sebuluno: Eliaba Helona 57,400 Ibounai: 186,400 Israela taudia ese edia kamepa dekena amo idia toreisi, gabu matamata idia lao neganai, Iuda orea be do ia raka guna. ");
INSERT INTO hmo_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","Kamepa ena diho kahana dekenai, Rubena orea ena pepe henunai be inai iduhu toi do idia kamepa hebou, to ta ta edia iduhu dekena amo, bona edia gunalaia taudia ta ta henunai, edia momo be inai bamona: Rubena: Elisuru Sedeuru 46,500 Simeona: Selumiele Surisadai 59,300 Gado: Eliasapa Reuele 45,650 Ibounai: 151,450 Israela taudia ese edia kamepa dekena amo idia toreisi, gabu matamata idia lao neganai, Rubena orea be raka lao oreana iharuana. ");
INSERT INTO hmo_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Idia edia murinai Levi taudia ese Palai Dubu do idia huaia lao, edia palai rumadia danu. Levi taudia be tuari taudia edia huanai momokani do idia raka lao. Orea ta ta idia raka lao gabudia be edia kamepa gabudia hegeregerena. Orea ta ta be edia pepe ta ta henunai. ");
INSERT INTO hmo_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","Kamepa ena dina diho kahana dekenai, Eparaima orea ena pepe henunai be inai iduhu toi do idia kamepa hebou, to ta ta edia iduhu dekena amo, bona edia gunalaia taudia ta ta henunai, edia momo be inai bamona: Eparaima: Elisama Amihuda 40,500 Manase: Gamaliela Pedasuru 32,200 Beniamina: Abidana Gideoni 35,400 Ibounai: 108,100 Israela taudia ese edia kamepa dekena amo idia toreisi, gabu matamata idia lao neganai, Eparaima orea be raka lao oreana ihatoina. ");
INSERT INTO hmo_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","Kamepa ena mirigini kahana dekenai, Dano orea ena pepe henunai be inai iduhu toi do idia kamepa hebou, to ta ta edia iduhu dekena amo, bona edia gunalaia taudia ta ta henunai, edia momo be inai bamona: Dano: Ahiesere Amisadai 62,700 Asere: Pagiele Okarana 41,500 Napatali: Ahira Enana 53,400 Ibounai: 157,600 Israela taudia ese edia kamepa dekena amo idia toreisi, gabu matamata idia lao neganai, Dano orea taudia be murina kahanai do idia raka. ");
INSERT INTO hmo_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Israela taudia edia iduhu ta ta dekenai idia duahia be inai. Tuari taudia, edia iduhu ta ta dekena amo idia duahia ibounai be 603,550. ");
INSERT INTO hmo_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","To Lohiabada ese Mose ia oda henia hegeregerena, Levi taudia be Israela taudia danu idia duahia hebou lasi. ");
INSERT INTO hmo_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israela taudia be unai bamona idia karaia. Lohiabada ese Mose ia oda henia hegeregerena, idia ese edia pepe ta ta edia henunai idia kamepa. Bona edia orea ta ta bona edia iduhu ta ta dekenai edia kamepa dekena amo idia raka lao. ");
INSERT INTO hmo_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Lohiabada ese Sinai Ororo dekenai Mose ia hereva henia neganai, Arona bona Mose edia bese taudia be inai: ");
INSERT INTO hmo_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Arona be mai ena natuna tau 4, Nadaba, vara guna tauna, Abihu, Eleasara, bona Itamara. ");
INSERT INTO hmo_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Arona ena natuna tau be unai, bona idia be hahelagaia taudia edia dagi totona Mose ese idia ia hahelagaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","To Nadaba bona Abihu be Lohiabada ena vairanai idia mase, badina helaga lasi lahi Lohiabada ena vairanai idia mailaia dainai, Sinai ena taunimanima lasi tano dekenai. Idia be natuna lasi. Unai dainai Eleasara bona Itamara ese hahelagaia taudia edia dagi idia karaia edia tamana Arona ena mauri lagani lalonai. ");
INSERT INTO hmo_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Levi taudia do oi hakaua mai, hahelagaia tauna Arona ena vairana dekenai do idia gini, bona iena hesiai gaukara do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Idia ese Arona totona bona Israela taudia ibounai totona, Lohiabada ena Palai Dubu ena gaukara do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Idia ese Palai Dubu lalonai noho kohu ibounai do idia naria, bona Israela taudia durua totona, Palai Dubu naria gaukara do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“Levi taudia be Arona, mai ena natuna tau dekenai do oi henia. Israela taudia ibounai edia huana dekena amo, Levi taudia sibona ese Arona ena hesiai gaukara do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Oi ese Arona bona iena natuna tau do oi abia hidi, hahelagaia taudia dagi do idia karaia totona. Bona bema idau tauna ese inai gaukara helagana do ia karaia toho neganai, unai tau do umui alaia mase.” ");
INSERT INTO hmo_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Kamonai, lau ese Israela taudia edia huana dekena amo Levi taudia lau abia hidi vadaeni. Hari idia be lauegu. Lau ese Levi taudia lau abia, idia ese Israela taudia edia vara guna natudia edia gabu do idia abia. ");
INSERT INTO hmo_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Badina be Aigupito taudia edia vara guna natudia ibounai lau alaia mase dinana dekenai lau ese Israela taudia edia vara guna natudia lau abia siri, lauegu, taunimanima edia vara guna ibounai, bona mauri gaudia edia vara guna ibounai danu. Idia be helaga, lauegu. To hari inai Israela taudia edia vara guna natudia edia gabu, lau sibona egu, be Levi taudia ese idia abia vadaeni. Lau ese Levi taudia lau abia hidi, idia be lauegu. Lau inai Lohiabada.” ");
INSERT INTO hmo_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Sinai taunimanima noho lasi tano dekenai Lohiabada ese Mose ia oda henia, ");
INSERT INTO hmo_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Levi taudia edia ladana do ia torea, edia bese ta ta bona iduhu ta ta dekena amo. Hua ta idia abia o idia hanaia memero ibounai bona tau ibounai edia ladana do ia torea. ");
INSERT INTO hmo_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Bona Mose ese unai bamona ia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi ena natuna tau be inai: Geresone bona Kohata bona Merari, bona idia ta ta be iduhu ta ena sene tauna. ");
INSERT INTO hmo_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Geresone ena natuna tau be inai: Libini bona Simei. ");
INSERT INTO hmo_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohata ena natuna tau be inai: Amarama bona Isahara bona Heberona bona Usiele. ");
INSERT INTO hmo_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari ena natuna tau be inai: Mali bona Musi. Idia ta ta be iduhu ta ena sene tauna, bona edia iduhu ena ladana be idia edia ladana hegeregerena. Levi ese ia havaraia iduhu be unai. ");
INSERT INTO hmo_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Geresone ena iduhu be Libini besena bona Simei besena taudia. ");
INSERT INTO hmo_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Inai Geresone iduhu lalonai noho memero idia duahia, hua ta idia hanaia memero bona tatau be ibounai 7500. ");
INSERT INTO hmo_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Inai Geresone iduhu edia kamepa gabuna be dina ia diho kahanai, Palai Dubu ena murinai. ");
INSERT INTO hmo_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Inai iduhu ena lohia tauna be Eliasapa Laele. ");
INSERT INTO hmo_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Geresone iduhu taudia edia gaukara be inai: Palai Dubu, bona ena koua guhi ruaosi, bona Palai Dubu ena iduara dekenai ia noho koua dabua do idia naria. ");
INSERT INTO hmo_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Ma danu Palai Dubu ia hagegea koua dabua badana, bona inai koua dabua ena iduara dekenai ia noho koua dabua, bona boubou patana bona varo ibounai do idia naria. Inai gaudia naria totona gaukara ibounai be Geresone iduhu taudia ese do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohata ena iduhu be Amarama besena, bona Isahara besena, bona Heberona besena, bona Usiele besena taudia. ");
INSERT INTO hmo_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Inai Kohata iduhu lalonai noho memero idia duahia, hua ta idia hanaia memero bona tatau be ibounai 8600. Idia edia gaukara be helaga gaudia do idia naria. ");
INSERT INTO hmo_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Inai Kohata iduhu edia kamepa gabuna be Palai Dubu ena diho kahanai. ");
INSERT INTO hmo_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Inai iduhu ena lohia tauna be Elisapana Usiele. ");
INSERT INTO hmo_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Kohata iduhu taudia edia gaukara be inai: Taravatu Maua, pata helagana, lamepa dogoatao gauna, boubou patadia, bona Helaga Gabuna ena kohu ibounai, bona Helaga Herea Gabuna ena iduara dekenai ia noho koua dabua helagana danu do idia naria. Inai gaudia naria totona gaukara ibounai be Kohata iduhu taudia ese do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleasara, hahelagaia tauna, Arona, ena natuna, be Levi taudia ibounai edia gunalaia tauna, bona ia ese Helaga Gabuna dekenai idia gaukara taudia edia gaukara ia naria. ");
INSERT INTO hmo_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari ena iduhu be Mali besena, bona Musi besena taudia. ");
INSERT INTO hmo_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Inai Merari iduhu lalonai idia noho memero idia duahia, hua ta idia hanaia memero bona tatau be ibounai 6200. ");
INSERT INTO hmo_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Inai Merari iduhu ena kamepa gabuna be Palai Dubu ena mirigini kahanai, bona inai iduhu ena lohia tauna be Suriele Abihaili. ");
INSERT INTO hmo_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merari iduhu taudia edia gaukara be inai: Palai Dubu ena haba turia, reirei latadia, du, du edia henunai idia atoa maua ibounai, bona unai gau edia kohu ibounai do idia naria. Inai gaudia naria totona gaukara ibounai be Merari iduhu taudia ese do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Idia ese danu Palai Dubu ia hagegea koua dabua maguna ena du, du henunai idia atoa maua, ikoko bona varo idia naria bona gaukaralaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mose bona Arona mai iena natuna tau be Palai Dubu ena dina daekau kahana dekenai, Palai Dubu ena vairanai idia kamepa. Idia ese Helaga Gabuna ena gaukara helagana do idia karaia Israela taudia ibounai dainai. Mose bona Arona edia bese lasi tauna ese inai gaukara helagana do ia karaia toho neganai, unai tau be Israela taudia ese do idia alaia mase. ");
INSERT INTO hmo_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Levi taudia, Mose bona Arona ese iduhu ta ta dekena amo idia duahia, hua ta ia hanaia memero bona tatau, be ibounai 22,000. Lohiabada ena oda dainai inai duahia gaukara idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Lohiabada ese Mose ia hamaoroa, ia gwau, “Israela taudia edia vara guna natudia ibounai be lauegu. Unai dainai Israela edia vara guna memero bona tatau ibounai, hua ta idia hanaia taudia ibounai edia ladana do oi torea. ");
INSERT INTO hmo_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","To edia gabu dekenai lau ese Levi taudia ibounai lau abia inai, lauegu! Lau be Lohiabada! Lau ese danu Levi taudia edia boromakau bona mamoe lau abia inai! Idia ese Israela taudia edia boromakau bona mamoe, vara guna gaudia, edia gabu do idia abia!” ");
INSERT INTO hmo_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mose ese Israela taudia edia vara guna natudia memero bona tatau ibounai, ");
INSERT INTO hmo_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","hua ta idia hanaia taudia, ia torea bona duahia. Idia ibounai be 22,273. ");
INSERT INTO hmo_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Levi taudia do oi abia, idia be lauegu do idia lao, idia ese Israela ena vara guna natudia edia gabu do idia abia. Ma danu Levi taudia edia boromakau bona mamoe do oi abia, idia ese Israela taudia edia vara guna boromakau bona mamoe edia gabu do idia abia. ");
INSERT INTO hmo_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","“To Israela taudia edia vara guna natudia edia momo ese Levi taudia edia momo be 273 dekenai idia hanaia. Unai dainai inai natuna ibounai 273 do umui hoia lou. ");
INSERT INTO hmo_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Idia ta ta edia davana be siliva moni 5, Helaga Gabuna ese ia sikelia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Bona inai hoia lou moni be Arona bona iena natuna tau dekenai do oi henia.” ");
INSERT INTO hmo_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Vadaeni inai Levi taudia ese edia gabu idia abia diba lasi vara guna taudia ibounai 273 edia davana be Mose ese ia gogoa. ");
INSERT INTO hmo_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Israela taudia vara guna memero bona tatau dekena amo siliva moni 1365 ia gogoa. Unai moni be Helaga Gabuna ese ia sikelia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Vadaeni Mose ese unai moni be Arona bona iena natuna tau dekenai ia henia, Lohiabada ese ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Lohiabada ese Mose bona Arona ia oda henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Levi taudia dekena amo Kohata iduhu bona edia bese taudia edia ladana do umui torea, bona duahia. ");
INSERT INTO hmo_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Tau ibounai, edia mauri lagani be 30 ela bona 50, Lohiabada ena Palai Dubu lalonai idia gaukara diba taudia ibounai do umui duahia. ");
INSERT INTO hmo_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Kohata iduhu taudia edia gaukara be, helaga bada gaudia do idia naria.” ");
INSERT INTO hmo_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Palai Dubu do idia naria namonamo totona, Lohiabada ese Mose ia hadibaia inai bamona: “Kamepa do umui kokia gwauraia neganai, Arona mai ena natuna tau ese Palai Dubu do idia raka vareai, Taravatu Maua vairanai ia noho koua dabua helagana do idia abia diho, bona ia dekena amo Taravatu Maua do idia koua. ");
INSERT INTO hmo_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ma inai koua dabua ena latanai davara boromakau edia kopina do idia atoa. Ma inai kopina ena latanai, dabua, ena kala bulu do idia atoa, Taravatu Maua do idia koua momokani. Unai murinai Taravatu Maua ena huaia audia be edia gabu dekenai do idia toia vareai. ");
INSERT INTO hmo_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Vadaeni Lohiabada dekenai henia beredi ena patana ena latanai, dabua, ena kala bulu do idia atoa, do idia koua. Inai bulu dabua ena latanai disi, bonana namo muramura urodia, kapusi, bona uaina henia totona urodia do idia atoa. Ma Lohiabada dekenai henia beredi danu be pata dekenai do ia noho. ");
INSERT INTO hmo_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Inai gau ibounai edia latanai dabua ena kala kakakaka do idia atoa, vadaeni pata ena huaia audia be edia gabu dekenai do idia toia vareai. ");
INSERT INTO hmo_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ma dabua ta, ena kala bulu dekena amo, lamepa dogoatao gauna, mai ena lamepa, lamepa hagoevaia auri gaudia, momoru udaia mereki, bona oela ena kavabu ibounai do ia koua. ");
INSERT INTO hmo_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Unai gaudia ibounai be davara boromakau, rui, edia kopina dekenai do idia kumia, bona huaia totona gauna ena latanai do idia atoa. ");
INSERT INTO hmo_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Golo patana be bulu dabua dekena amo do idia koua, vadaeni davara boromakau edia kopina dekenai do idia kumia, bona huaia audia be pata huaia totona rini dekenai do idia toia vareai. ");
INSERT INTO hmo_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Unai murinai Helaga Gabuna ena kohu ibounai be bulu dabua dekenai do idia kumia, ma inai ibounai be davara boromakau, rui, edia kopina dekena amo do idia koua, bona huaia totona gauna ena latanai do idia atoa. ");
INSERT INTO hmo_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Unai murinai boubou patana ena kahu do idia negea, bona boubou patana be dabua, ena kala sisina kakakaka dekena amo do idia koua. ");
INSERT INTO hmo_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Vadaeni unai dabua edia latanai boubou patana ena kohu ibounai do idia atoa, gaudia inai: Lahi huaia auri gaudia, foka, sipeidi, rara udaia urodia, kahu udaia urodia. Unai gaudia ibounai be davara boromakau, rui, edia kopina dekenai do idia koua, bona huaia audia be boubou patana ena rini dekenai do idia toia vareai. ");
INSERT INTO hmo_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Arona mai ena natuna danu be inai Helaga Gabuna mai ena kohu helagadia ibounai idia koua namonamo murinai, bona Israela taudia ese edia palai ruma do idia huaia gwauraia neganai, Kohata iduhu taudia ese unai helaga gaudia huaia totona do idia raka mai. To idia ese unai helaga gaudia ta do idia dogoatao lasi, do idia mase garina. “Inai gaudia ibounai be Kohata iduhu taudia ese do idia huaia lao, Palai Dubu idia kokia negadia ibounai. ");
INSERT INTO hmo_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Hahelagaia tauna Arona ena natuna Eleasara ese do ia naria gaudia be inai: Lamepa ena oela, bona bonana namona muramura, bona boubou edia paraoa, bona dehoro helagana. Ia ese danu Palai Dubu mai ena kohu helagadia ibounai, bona Helaga Gabuna mai ena kohu helagadia ibounai do ia itaia namonamo.” ");
INSERT INTO hmo_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Vadaeni Lohiabada ese Mose bona Arona ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Kohata taudia do umui naria namonamo, idia ese sibodia do idia hamasea, bona Levi orea dekena amo idia boio garina. ");
INSERT INTO hmo_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Badina be bema Kohata taudia ese inai helaga gaudia dekenai idia raka kahirakahira kava neganai do idia mase. “Inai bamona do ia vara garina Arona mai ena natuna tau be do idia raka vareai guna, bona Kohata taudia ta ta edia gaukara, edia gaukara do idia henia, bona ta ta edia maduna, edia maduna danu do idia henia. ");
INSERT INTO hmo_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","To bema idia raka vareai kava, bona helaga gaudia do idia itaia, idia do koua lasi neganai, idia be do idia mase momokani.” ");
INSERT INTO hmo_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Levi taudia dekena amo, Geresone iduhu bona edia bese taudia edia ladana do umui torea, bona duahia. ");
INSERT INTO hmo_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Tau ibounai, edia mauri lagani be 30 ela bona 50, Lohiabada ena Palai Dubu lalonai idia gaukara diba taudia ibounai do umui duahia. ");
INSERT INTO hmo_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Geresone iduhu taudia edia gaukara be inai gaudia do idia huaia: ");
INSERT INTO hmo_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","“Palai Dubu, Palai Dubu ena guhi ruaosi, lalona gauna, bona murimurinai gauna, bona davara boromakau, rui, edia kopina guhina danu, Palai Dubu ena iduara dekenai ia noho koua dabua, ");
INSERT INTO hmo_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Palai Dubu ia hagegea koua dabua badana, bona boubou patana ena koua dabua, mai edia varo ibounai, bona inai gaudia haginia gaukara karaia totona gaudia ibounai danu. “Geresone iduhu taudia ese unai kohu huaia totona gaukara idauidau ibounai do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","“Geresone taudia edia gaukara bona edia kohu huaia kara ibounai be Arona mai ena natuna danu ese do idia hadibadia. Bona oi Mose ese danu inai Geresone taudia edia kohu huaia gaukara ta ta ibounai do oi hadibaia bona gwauraia. ");
INSERT INTO hmo_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","“Inai gaukara ibounai be Geresone iduhu taudia ese do idia karaia, Palai Dubu do idia naria namonamo totona. Idia edia gaukara be hahelagaia tauna Arona ena natuna Itamara ese do ia naria bona hadibaia.” ");
INSERT INTO hmo_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Lohiabada ese Mose ia hamaoroa, ia gwau, “Levi taudia dekena amo, Merari iduhu bona edia bese taudia edia ladana do umui torea, bona duahia. ");
INSERT INTO hmo_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Tau ibounai, edia mauri lagani be 30 ela bona 50, Lohiabada ena Palai Dubu lalonai idia gaukara diba taudia ibounai do umui duahia. ");
INSERT INTO hmo_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Merari iduhu taudia edia gaukara be, inai gaudia do idia huaia: Palai Dubu ena haba turia, reirei latadia, du, du edia henunai maua ibounai, ");
INSERT INTO hmo_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Palai Dubu ia hagegea koua dabua badana ena du, du edia maua, ikoko bona varo, bona inai gaudia haginia gaukara karaia totona gaudia ibounai danu. Merari iduhu taudia ta ta dekenai dahaka bona dahaka do idia huaia do oi hadibaia, vadaeni inai be Merari iduhu sibona ena gaukara. ");
INSERT INTO hmo_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","“Inai gaukara ibounai be Merari iduhu taudia ese do idia karaia, Palai Dubu naria namonamo totona. Idia edia gaukara be hahelagaia tauna Arona ena natuna Itamara ese do ia naria bona hadibaia.” ");
INSERT INTO hmo_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Vadaeni Mose bona Arona ese Lohiabada ena oda idia kamonai, bona Israela gunalaia taudia ese Levi iduhu toi, Kohata, Geresone bona Merari idia duahia, edia iduhu bona edia bese ta ta dekena amo. Tatau ibounai edia mauri lagani 30 ela bona 50, Lohiabada ena Palai Dubu lalonai idia gaukara diba taudia edia ladana idia torea bona idia duahia. Edia momo be inai: Kohata Iduhu 2,750 Geresone Iduhu 2,630 Merari Iduhu 3,200 Ibounai: 8,580 ");
INSERT INTO hmo_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Lohiabada ese Mose ia oda henia hegeregerena, inai tatau ta ta ibounai dekenai gaukara ta ta ia henia, bona maduna ta ta ia henia. Bona unai tatau ibounai be Mose ese edia ladana ia torea, bona ia duahia, Lohiabada ese ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Israela taudia do oi hamaoroa, lepera gorere taudia ibounai, bona hura ia bubua noho gorere taudia, bona mase taudia edia tauanina idia dogoatao taudia dainai idia miro taudia ibounai be kamepa ena murimurinai do idia siaia lao. ");
INSERT INTO hmo_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Inai miro taudia ibounai, tau bona hahine, be kamepa ena murimurinai do umui atodia, idia ese emui kamepa, lau noho gabuna, do idia hamiroa garina.” ");
INSERT INTO hmo_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Vadaeni Israela taudia ese unai bamona idia karaia, kamepa ena murimurinai unai miro taudia ibounai idia siaia lao, Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Israela taudia do oi hadibaia, bema tau ta o hahine ta ese kara dika ia karaia neganai, ia be Lohiabada ena vairanai ia kerere. ");
INSERT INTO hmo_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ia ese iena kara dika do ia gwauraia hedinarai, bona iena kara dika dekena amo ia hadikaia tauna dekenai davana do ia henia, mai atoa kau moni danu. Atoa kau moni ena bada be davana korikori bema karoa 5, ena karoa ta. Unai karoa ta be ma do idia atoa kau, vadaeni davana be karoa 6. ");
INSERT INTO hmo_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","“To bema ia hadikaia vadaeni tauna ia mase vadaeni, bona unai tau be mai ena varavara ta lasi, unai moni do ia abia totona, unai moni be Lohiabada dekenai do ia henia, hahelagaia tauna ena. Kerere tauna ese inai davana, bona iena kerere ena davana karaia totona mamoe tau ta danu be hahelagaia tauna dekenai do ia henia. ");
INSERT INTO hmo_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“Israela taudia edia harihari gaudia, helaga gaudia Lohiabada dekenai henia gwauraia gaudia, be hahelagaia tauna ese do ia abia, iena. ");
INSERT INTO hmo_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Bema tau ta ese harihari gauna helagana be hahelagaia tauna dekenai ia henia neganai, unai hahelagaia tauna ese do ia abia, iena.” ");
INSERT INTO hmo_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Lohiabada ese Mose ma ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Israela taudia do oi hamaoroa, bema hahine ta ia kerere, ");
INSERT INTO hmo_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","bema ia ese tau ta danu idia heudahanai, bona ia hunia, iena adavana ia diba lasi, bona tau ta ia diba lasi, tau ta danu ese do ia davaria diba lasi. ");
INSERT INTO hmo_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Bona sedira inai hahine ena adavana ese mama ena mamina ia abia, to ia diba namonamo lasi unai hahine be ia kerere momokani o lasi. O sedira tau ta ese iena hahine dekenai ia mama henia noho, to mai badina lasi. ");
INSERT INTO hmo_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","“Unai bamona daradara ia noho neganai, tau ese iena hahine be hahelagaia tauna dekenai do ia hakaua lao. Ia ese danu bali paraoa ena metau kilogaram ta do ia abia lao. To olive dehoro o bonana namona muramura do ia abia lao lasi. Badina inai be paraoa boubou gauna, mama totona gauna, bona inai boubou ena badina, be momokani bona maoromaoro do ia hedinarai totona. ");
INSERT INTO hmo_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Vadaeni hahelagaia tauna ese hahine do ia boiria, bona boubou patana ena vairanai do ia haginia. ");
INSERT INTO hmo_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Hahelagaia tauna ese raro disi dekenai ranu helaga do ia bubua, bona tano kahuna sisina Palai Dubu lalona dekena amo be ranu dekenai do ia udaia. ");
INSERT INTO hmo_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","“Unai neganai hahelagaia tauna ese hahine ena huina do ia ruhaia, bona unai paraoa, mama totona boubouna, bona kerere laloa gauna, be hahine ena imana dekenai do ia atoa. To hahelagaia tauna ese inai mamina dika ranu, dika ia havaraia gauna, be ia sibona ena imana dekenai do ia dogoatao noho. ");
INSERT INTO hmo_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“Vadaeni hahelagaia tauna ese hahine do ia oda henia inai gwauhamata do ia abia dae, hahelagaia tauna ena gwauhamata be inai: Bema oiemu adavana oi koia lasi, tau ta danu oi heudahanai lasi, inai mamina dika ranu, dika ia havaraia gauna, be oi dekenai dika ta do ia havaraia lasi, ");
INSERT INTO hmo_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","to bema oi ese oiemu adavana oi koia, bona tau ta danu oi heudahanai neganai, ");
INSERT INTO hmo_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Lohiabada ese oiemu ladana do ia hadikaia momokani oiemu bese edia huanai. Lohiabada ese oiemu mamuna ruaosi do ia hamasea bona oiemu bogana do ia hagudua. ");
INSERT INTO hmo_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Momokani, inai ranu be oiemu bogana dekenai ia diho neganai, oiemu bogana do ia gudu bona oiemu mamuna ruaosi do idia mase. “Hahine ese inai gwauhamata dekenai do ia haere henia, do ia gwau, ‘Inai gwauhamata be lau abia dae, Lohiabada ese unai bamona do ia karaia be namo.’ ");
INSERT INTO hmo_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Unai neganai hahelagaia tauna ese unai gwauhamata ena hereva dikana be pepa dekenai do ia torea, bona inai toretore be unai mamina dika ranu dekenai do ia huria oho. ");
INSERT INTO hmo_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Bona gabeai ia ese unai mamina dika ranu be hahine dekenai do ia henia, vadaeni unai dika ia havaraia ranuna be hahine do ia inua, iena bogana dekenai do ia diho. ");
INSERT INTO hmo_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“To guna, unai hahelagaia tauna ese paraoa boubouna be hahine ena imana dekena amo do ia abia. Ia ese Lohiabada ena vairanai paraoa do ia davea, vadaeni boubou patana dekenai do ia abia lao. ");
INSERT INTO hmo_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Vadaeni ia ese imana dekena amo paraoa haida do ia abia, Lohiabada dekenai henia ena toana, bona boubou patana ena lahi dekenai do ia gabua ore. Unai murinai ia ese hahine do ia hamaoroa unai mamina dika ranu do ia inua. ");
INSERT INTO hmo_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","“Bema unai hahine ese heudahanai ia karaia neganai, unai ranu ese hisihisi bada do ia havaraia. Iena bogana be do ia gudu, bona iena mamuna ruaosi do idia mase, bona iena bese edia huanai unai hahine ena ladana be do ia dika momokani. ");
INSERT INTO hmo_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","To bema unai hahine ia heudahanai lasi neganai, ia ese dika ta do ia davaria lasi, bona ia ese natuna do ia havaraia diba. ");
INSERT INTO hmo_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Mama ena taravatu be unai, hahine ta ese iena adavana bema ia koia, tau ta danu ia heudahanai, ");
INSERT INTO hmo_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","o bema tau ta ese iena adavana ia mama henia neganai. Unai tau ese unai hahine Lohiabada ena vairana dekenai do ia haginia, bona hahelagaia tauna ese hari idia torea taravatu karana do ia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Bona unai tau be mai ena kerere ta lasi, to unai hahine, bema ia kerere neganai, ia ese iena kerere davana do ia abia.” ");
INSERT INTO hmo_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Lohiabada ese Mose ia hereva henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Israela taudia dekenai inai taravatu do oi henia: Bema tau ta o hahine ta ese do ia gwauhamata, Nasiri taudia edia mauri dalana do ia badinaia bona Lohiabada dekenai do ia helaga neganai, ");
INSERT INTO hmo_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ia ese uaina o kekero muramura do ia inua lasi. Ia be vain huahua ena ranu danu do ia inua lasi, bona vain huahua matamatadia o kaukaudia danu do ia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Nasiri tauna ese, iena helaga dinadia ibounai lalonai vain edia anina, edia nadinadina ela bona edia kopina, be do ia ania lasi. ");
INSERT INTO hmo_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Nasiri tauna danu ese iena helaga dinadia ibounai lalonai iena huina, iena kwarana dekenai, o iena vairana dekenai, do ia utua lasi. Lohiabada dekenai ia gwauhamata dinadia ibounai be Nasiri tauna ena huina be do ia lata noho. Inai be Lohiabada dekenai ia helaga ena toana. ");
INSERT INTO hmo_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“Iena helaga dinadia ibounai lalonai danu Nasiri tauna ese mase tauna ta dekenai do ia raka kahirakahira lasi. ");
INSERT INTO hmo_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Sedira Nasiri tauna ena tamana o sinana o taihuna o tadikakana do ia mase, to ia ese idia kahirakahira do ia lao lasi, do ia miro garina. Badina be ia gwauhamata vadaeni, do ia helaga, Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Unai dainai Nasiri tauna ena gwauhamata dinadia ibounai lalonai ia be do ia helaga, Lohiabada ena. ");
INSERT INTO hmo_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Bema tau ta be iena badibadinai ia mase haragaharaga, bona unai tau dekenai ia kamokau dainai Nasiri tauna ia miro neganai, ia be dina 7 do ia naria, bona dina namba 7 dekenai iena kwarana huina bona auki huina do ia kakasia ore. ");
INSERT INTO hmo_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Dina namba 8 dekenai ia ese manu ta ladana kerea rua, o pune manu ena natuna rua do ia abia, hahelagaia tauna dekenai do ia mailaia, Palai Dubu ena iduara dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","“Vadaeni hahelagaia tauna ese Lohiabada dekenai manu ta do ia henia, Nasiri tauna ena kara dika totona, ma manu ta do ia gabua ore, iena kara dika ena davana karaia totona. Badina be unai mase tauna dainai ia be kerere vadaeni. Unai dina dekenai Nasiri tauna ese iena kwarana ena huina do ia hahelagaia lou. ");
INSERT INTO hmo_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Do ia helaga, Lohiabada ena, iena gwauhamata dinadia ibounai. Mamoe tau ta, lagani tamona gauna, danu do ia mailaia, iena kerere ena davana karaia boubouna totona. To unai dina gunadia, mase tauna dekenai do ia kerere lasi dinadia, be do ia duahia lasi, badina unai kerere dainai iena gwauhamata ia dika, bona iena gwauhamata do ia hamatamaia lou. ");
INSERT INTO hmo_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Nasiri tauna ese iena gwauhamata dinadia do ia haorea ena taravatu be inai: Ia ese Palai Dubu ena iduara dekenai do ia lao. ");
INSERT INTO hmo_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ia ese Lohiabada dekenai mauri gaudia toi do ia mailaia, bero o toto lasi gaudia, mamoe natuna tau ta, lagani tamona gauna, gabua boubouna totona, mamoe natuna hahine ta, lagani tamona gauna, kara dika gwauatao totona gauna, bona mamoe tau ta, Dirava danu maino do ia karaia totona. ");
INSERT INTO hmo_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Inai danu do ia henia: Paraoa beredi, idia hatubua lasi gauna ena bosea ta, lalonai danu be paraoa bona olive dehoro ia mikisi dekenai ia karaia ataga, bona bisikesi, idia dekenai olive dehoro ia bubua gaudia. Ma danu ia ese paraoa boubouna bona uaina boubouna do ia mailaia. ");
INSERT INTO hmo_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Vadaeni hahelagaia tauna ese Lohiabada ena vairanai inai boubou ibounai do ia atoa. Ia ese kara dika boubouna bona gabua boubouna Lohiabada dekenai do ia henidia. ");
INSERT INTO hmo_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Maino karaia boubouna, mamoe, danu Lohiabada dekenai do ia henia, bona ia hatubua lasi paraoa, bosea lalonai gaudia, bona paraoa boubouna, bona uaina boubouna, ibounai be Lohiabada dekenai do ia henia, idia helaga vadaeni. ");
INSERT INTO hmo_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Unai murinai Palai Dubu ena iduara dekenai Nasiri tauna ese iena kwarana huina do ia kakasia ore, bona iena huina, iena gwauhamata toana, be Lohiabada danu maino karaia boubouna ena lahi dekenai do ia gabua ore. ");
INSERT INTO hmo_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Vadaeni unai huina ia kakasia ore murinai hahelagaia tauna ese mamoe tau ena pagana do ia nadua neganai, uro dekena amo do ia abia, bona paraoa, olive dehoro danu ia mikisi ataga gauna ta, bona iena latanai olive dehoro ia bubua bisikesi danu do ia abia, Nasiri tauna ena imana ruaosi dekenai do ia atoa. ");
INSERT INTO hmo_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","“Vadaeni hahelagaia tauna ese unai aniani gaudia do ia abia lou, bona idia be Lohiabada ena vairanai do ia davea, ia henia ena toana. Unai kara murinai idia be helaga, bona idia be hahelagaia tauna ena aniani. Mamoe ena kemena, ia davea gauna, bona mamoe ena aena, ia abia isi gauna danu do ia abia, badina be Lohiabada ena taravatu dekenai, idia be hahelagaia tauna ena aniani. Unai kara murinai, Nasiri tauna ese uaina do ia inua lou diba. ");
INSERT INTO hmo_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Tau o hahine ese sibona Lohiabada dekenai ia henia gwauhamata ia karaia neganai, ia ese inai Nasiri taravatu ibounai do ia karaia bona badinaia. Ma bema ia ese ma gau ta Lohiabada dekenai do ia henia ena gwauhamata ia karaia neganai, inai gwauhamata ena anina danu do ia karaia haorea momokani.” ");
INSERT INTO hmo_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Lohiabada ese Mose dekenai ma ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Arona mai ena natuna taudia do oi hamaoroa, Israela taudia dekenai idia hanamoa neganai, inai bamona hereva do idia gwauraia: ");
INSERT INTO hmo_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Lohiabada ese umui do ia hanamoa, bona umui do ia naria namonamo. ");
INSERT INTO hmo_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Lohiabada ese iena vairana ena diari, be umui dekenai do ia henia, bona iena hariharibada danu umui dekenai do ia henia. ");
INSERT INTO hmo_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Lohiabada ese umui do ia bogahisihisi henia, bona maino umui dekenai do ia henia.” ");
INSERT INTO hmo_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Bona Lohiabada ia gwau, “Bema unai bamona lauegu ladana be Israela taudia edia latanai idia gwauraia neganai, lau ese idia do lau hanamoa.” ");
INSERT INTO hmo_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mose ese Lohiabada ena Palai Dubu ia haginia vadaeni dinana dekenai, ia ese Dubu mai ena kohu ibounai dekenai dehoro helagana ia atoa, ia hahelagaia. Boubou patana danu, mai ena kohu, be dehoro helagana dekena amo Mose ia hahelagaia. ");
INSERT INTO hmo_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Unai dina dekenai danu, Israela gunalaia taudia, iduhu edia lohia taudia, duahia gaukara dekenai gaukara taudia ibounai edia biagudia, ese ");
INSERT INTO hmo_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","edia harihari gaudia idia mailaia, Lohiabada ena vairana dekenai idia atoa. Gaudia be treila ibounai 6, bona boromakau tau ibounai 12, lohia rua rua dekena amo treila ta, bona lohia ta ta dekena amo boromakau tau ta ta. Lohia taudia ese inai gaudia idia henia murinai, ");
INSERT INTO hmo_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Inai harihari gaudia do oi abia dae, idia be Palai Dubu totona gaukara do idia karaia. Levi taudia dekenai do oi henidia, ta ta edia gaukara, edia gaukara totona.” ");
INSERT INTO hmo_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Unai dainai Mose ese treila bona boromakau ia abia, Levi taudia dekenai ia henia. ");
INSERT INTO hmo_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Treila rua bona boromakau tau 4 be Geresone iduhu taudia dekenai ia henia. ");
INSERT INTO hmo_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ma treila 4 bona boromakau 8 be Merari iduhu taudia dekenai ia henia. Unai taudia edia gaukara ibounai be hahelagaia tauna Arona ena natuna Itamara ese ia biagua. ");
INSERT INTO hmo_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","To Kohata iduhu taudia dekenai Mose ese gau ta ia henia lasi, badina be edia gaukara be idia ese idia naria gau helagadia, be edia pagana dekenai do idia huaia gaudia. ");
INSERT INTO hmo_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Boubou patana be dehoro helagana dekenai Mose ese ia hahelagaia neganai danu, unai Israela iduhu lohia taudia ese edia harihari gaudia idia mailaia. Edia harihari gaudia be boubou patana ena vairanai idia atoa diho. ");
INSERT INTO hmo_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Vadaeni Lohiabada ese Mose ia hamaoroa, ia gwau, “Dina ta ta ibounai ela bona dina 12 idia ore, lohia ta ta edia harihari gauna, edia harihari gauna, be lau dekenai do idia henia. Unai dekena amo egu boubou patana be do ia helaga.” ");
INSERT INTO hmo_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Inai iduhu ta ta, bona Lohiabada dekenai harihari gaudia idia henia lohia taudia edia ladana, bona idia henia dinadia, be inai bamona: 1 Iuda Nasona Aminadaba 2 Isakara Netanele Suara 3 Sebuluno Eliaba Helona 4 Rubena Elisuru Sedeuru 5 Simeona Selumiele Surisadai 6 Gado Eliasapa Reuele 7 Eparaima Elisama Amihuda 8 Manase Gamaliela Pedasuru 9 Beniamina Abidana Gideoni 10 Dano Ahiesere Amisadai 11 Asere Pagiele Okarana 12 Napatali Ahira Enana Inai lohia ta ta ese idia mailaia harihari gaudia be hegeregere, gaudia be inai: Siliva mereki ta, ena metau be 1 kilogaram 500 garam, siliva disi ta, ena metau be 800 garam, Helaga Gabuna ena sikele hegeregerena. Inai mereki bona disi be paraoa bona olive dehoro idia mikisi vadaeni paraoa boubouna dekenai idia honu. Ma golo disi ta, iena metau be 110 garam, bonana namo muramura dekenai ia honu, boromakau natuna tau ta, mamoe tau ta, mamoe natuna ta, gabua boubouna totona gauna, nanigosi ta, kara dika boubouna totona gauna. Bona boromakau tau rua, mamoe tau 5, nanigosi 5, bona mamoe natuna 5, lagani tamona gaudia, Lohiabada danu maino karaia boubouna totona. ");
INSERT INTO hmo_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","Inai lohia taudia 12 ese idia mailaia harihari gaudia, boubou patana hahelagaia totona, be inai: — siliva mereki 12, bona siliva disi 12, edia metau be 27 kilogaram bona 600 garam. — golo disi 12, edia metau be 1 kilogaram 32 garam, idia ibounai be bonana namo muramura dekenai idia honu. — boromakau natuna tau 12, mamoe tau 12, mamoe natuna 12, lagani tamona gaudia, ma danu edia paraoa bouboudia, idia gabua ore gaudia. — nanigosi 12, kara dika boubouna totona. — boromakau tau 24, mamoe tau 60, nanigosi 60, mamoe natuna 60, lagani tamona gaudia, Lohiabada danu maino karaia bouboudia totona. ");
INSERT INTO hmo_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mose ese Palai Dubu dekenai ia raka vareai, Lohiabada dekenai do idia herevahereva totona. Ia ese Lohiabada ena gadona ia kamonai. Taravatu Maua ena koua gauna, kara dika gwauatao gabuna, ena ataiai dekena amo, Lohiabada ese Mose dekenai ia hereva henia. Unai be kerubi aneru ruaosi edia huana dekenai gabuna. ");
INSERT INTO hmo_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Arona do oi hadibaia, lamepa be edia gabudia dekenai ia atodia neganai, lamepa ibounai 7 be lamepa dogoatao gauna ena vairana kahana do idia hadiaria.” ");
INSERT INTO hmo_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Vadaeni Arona ese unai bamona ia karaia, lamepa be edia gabudia dekenai ia atoa, bona lamepa dogoatao gauna ena vairana kahana idia hadiaria, Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Inai lamepa dogoatao gauna be golo, hama dekenai idia botaia gauna, dekena amo idia karaia, ena aena dekena amo ela bona ena ataiai. Lohiabada ena palani, ia ese Mose ia hamaoroa hegeregerena, be unai lamepa dogoatao gauna idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Levi taudia be Israela besena edia huana dekena amo do oi abia siri, bona idia do oi hagoevaia. ");
INSERT INTO hmo_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Inai dala dekenai idia do oi hagoevaia: Ranu helagana be idia dekenai do oi negea lao, bona idia do oi hamaoroa, edia tauanina ena huina ibounai do idia kakasia ore, bona edia dabua do idia huria namonamo. Unai dekena amo do idia goeva. ");
INSERT INTO hmo_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Unai neganai idia ese boromakau natuna tau ta do idia abia, mai ena paraoa boubouna, paraoa namo herea, olive dehoro dekenai mikisi gauna. Boromakau natuna tau ma ta danu do oi abia, kara dika boubouna totona. ");
INSERT INTO hmo_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","“Vadaeni Levi taudia be Palai Dubu ena vairanai do oi hakaua mai, bona Israela taudia ibounai do oi haboua. ");
INSERT INTO hmo_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Vadaeni Levi taudia be Lohiabada ena vairanai do oi haginia. Israela taudia ese edia imana be Levi taudia edia latanai do idia atoa. ");
INSERT INTO hmo_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Arona ese Levi taudia Lohiabada dekenai do ia henia. Idia be Israela taudia edia harihari gauna lau dekenai, lauegu gaukara do idia karaia totona. ");
INSERT INTO hmo_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Levi taudia ese edia imana be boromakau tau ruaosi edia kwarana latanai do idia atoa. Boromakau ta be kara dika boubouna totona, bona boromakau ta be gabua ore boubouna totona, Levi taudia edia kara dika davana karaia totona. ");
INSERT INTO hmo_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Levi taudia be lau Lohiabada dekenai do oi henidia, harihari gauna idauna ta totona. Vadaeni Arona bona iena natuna tau ese unai Levi taudia do idia biagua. ");
INSERT INTO hmo_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","“Levi taudia be Israela besena edia huana dekena amo unai bamona do oi abidia siri, idia be lauegu. ");
INSERT INTO hmo_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Oi ese Levi taudia oi hagoevaia, bona oi hahelagaia murinai, idia ese Palai Dubu lalonai do idia gaukara diba. ");
INSERT INTO hmo_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Badina be Israela taudia edia huana dekena amo oi ese lau dekenai oi henidia, lauegu. Lau ese idia lau abia, idia ese Israela taudia edia vara guna natudia edia gabu idia abia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","“Israela taudia edia vara guna natudia ibounai be lauegu, taunimanima edia natudia vara guna, bona ubua gaudia edia vara guna danu. Badina be Aigupito tano dekenai, Aigupito taudia edia vara guna natudia lau alaia mase neganai, be emui vara guna natudia ibounai lau hahelagaia, lauegu. ");
INSERT INTO hmo_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","“To Israela taudia edia vara guna natudia edia gabu dekenai lau ese Levi taudia lau abia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Bona Arona mai iena natuna tau dekenai Levi taudia lau henia vadaeni, idia be Israela taudia edia harihari gaudia, Palai Dubu lalonai do idia gaukara totona. Bona Palai Dubu lalonai do idia gaukara noho dainai, Israela taudia ese dika do idia davaria lasi Palai Dubu kahirakahira do idia lao neganai.” ");
INSERT INTO hmo_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Inai kara dekena amo Mose bona Arona bona Israela taudia ibounai ese Levi taudia idia hahelagaia, Lohiabada ese Mose ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levi taudia ese sibodia idia hagoevaia, bona edia dabua idia huria. Bona Arona ese idia ia hahelagaia, vadaeni Levi taudia be harihari gauna idauna ta Lohiabada dekenai. Arona ese danu Levi taudia hagoevaia totona, edia kara dika davana ia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Unai murinai Levi taudia be Palai Dubu idia raka vareai, bona idia ese Arona mai iena natuna tau durua gaukara idia karaia. Israela taudia ese Levi taudia dekenai gau ibounai idia karaia, Lohiabada ese Mose ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Levi taudia edia taravatu be inai: Edia mauri lagani be 25 neganai, egu Palai Dubu lalonai idia gaukara hamatamaia diba. ");
INSERT INTO hmo_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","To lagani 50 idia abia neganai, inai gaukara do idia rakatania, bona do idia karaia lou lasi. ");
INSERT INTO hmo_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","“Unai murinai, idia ese edia varavara taudia idia durua diba Palai Dubu ena gaukara dekenai, to idia sibodia ese Palai Dubu gaukara ta do idia karaia lasi. Levi taudia edia gaukara be unai bamona taravatu dekenai do umui naria.” ");
INSERT INTO hmo_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Israela taudia ese Aigupito idia rakatania murinai, lagani iharuana ena hua ginigunana dekenai, Sinai tano, taunimanima noho lasi gabuna dekenai Lohiabada ese Mose dekenai ia hereva, ");
INSERT INTO hmo_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","ia gwau, “Israela taudia ese Pasova ena aria do idia karaia, ena nega korikori dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","“Inai hua ena dina namba 14 dekenai, adorahi neganai Pasova do umui karaia, ena nega korikori dekenai, Pasova ena taravatu hegeregerena.” ");
INSERT INTO hmo_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Unai dainai, Mose ese Israela taudia ia oda henia, Pasova do idia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Vadaeni hua ginigunana ena dina namba 14 adorahi neganai, Pasova aria idia karaia, Sinai tano kaukau dekenai. Israela taudia ese gau ibounai idia karaia, Lohiabada ese Mose ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","To tau haida be idia miro vadaeni, mase tauna dekenai idia kamokau dainai. Unai dainai Pasova idia ania diba lasi unai dina dekenai. Vadaeni idia be Mose bona Arona dekenai idia lao unai dina dekenai, idia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“Ai be miro, badina mase tauna ta ai dogoatao vadaeni. Badina be dahaka ai ese Lohiabada ena boubou do ai karaia lasi, nega korikori dekenai, Israela taudia ibounai danu?” ");
INSERT INTO hmo_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose ese idia dekenai ia haere, ia gwau, “Do umui naria ela bona do lau kamonai, Lohiabada be edena bamona lau dekenai do ia hereva umui dainai.” ");
INSERT INTO hmo_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Vadaeni Lohiabada ese Mose ia oda henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Israela taudia do oi hamaoroa, do oi gwau: Sedira umui ta o emui natudia ta o tubudia ta be miro, mase tauna umui dogoatao dainai, o sedira umui ta be daudau herea do ia laolao, to ia do ura Pasova do ia ania. ");
INSERT INTO hmo_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Unai bamona neganai, hua ta murinai idia ania diba, hua iharuana ena dina 14, adorahi neganai Pasova do idia ania, mai paraoa, idia hatubua lasi gauna, bona mai aniani avadia mamina dika gaudia danu do idia ania. ");
INSERT INTO hmo_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","“To ania lasi gaudia do umui rakatania lasi ela bona dabai, bona mamoe ena turiana ta do umui makohia lasi. Pasova do umui badinaia namonamo, Pasova ena taravatu ibounai hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","To bema tau ta ia miro lasi, o ia laolao lasi, to Pasova aria ia karaia lasi, unai tau be iena bese dekena amo do umui negea, badina be ia ese Lohiabada ena boubou ia henia lasi, henia ena nega korikori dekenai. Unai tau ese iena kerere ena davana be ia sibona do ia karaia. ");
INSERT INTO hmo_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Bema idau bese tauna ta, iena tano dekena amo ia mai, umui emui huanai ia noho, bona ia ura Lohiabada ena Pasova aria do ia ania neganai, ia ese Pasova ena taravatu ibounai do ia badinaia guna. Pasova ena taravatu be tamona, idau bese taudia bona Israela taudia dekenai, taravatu be tamona, idau lasi.” ");
INSERT INTO hmo_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Palai Dubu idia haginia dinana dekenai, ori ese unai Dubu, Taravatu Maua ena Dubu ia koua. Hanuaboi neganai unai ori ena toana be lahi bamona. ");
INSERT INTO hmo_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Nega ibounai iena toana be unai bamona, dina neganai ori ese Dubu ia koua, hanuaboi neganai be lahi ena toana ese ia koua. ");
INSERT INTO hmo_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Bema ori ese Dubu dekena amo ia daekau neganai, Israela taudia be idia toreisi, edia kamepa idia rakatania, edia laolao ma idia raka lao lou. To ori ia diho mai lou gabuna dekenai, Israela taudia be unuseni idia kamepa lou. ");
INSERT INTO hmo_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Inai bamona dala dekenai Lohiabada ena oda hegeregerena Israela taudia idia karaia. Iena oda dekenai idia toreisi, bona iena oda dekenai idia kamepa. Ori ese Dubu ia koua negana ibounai lalonai, idia be kamepa dekenai idia noho. ");
INSERT INTO hmo_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Nega haida ori ese nega daudau Dubu ia koua, to Israela taudia ese Lohiabada ena oda idia laloa, idia toreisi lasi kamepa dekena amo. ");
INSERT INTO hmo_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Nega haida ori ese dina momo lasi Dubu ia koua. Vadaeni nega ibounai, Israela taudia idia noho o idia toreisi, Lohiabada ena oda hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Nega haida ori be adorahi neganai ia diho, hanuaboi neganai ia noho. To dabai be ma ia daekau lou, vadaeni Israela taudia be idia toreisi. Dina o hanuaboi, bema ori ia daekau negana ibounai, idia be kamepa dekena amo idia toreisi. ");
INSERT INTO hmo_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ori ese Dubu ia koua negadia ibounai, bema dina rua, o hua ta, o lagani ta, o nega daudau, to Israela taudia kamepa dekenai idia noho, idia toreisi lasi. To ori ia daekau neganai idia toreisi. ");
INSERT INTO hmo_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Lohiabada ena oda dainai idia kamepa, ma Lohiabada ena oda dainai idia toreisi. Idia ese Lohiabada ena oda idia badinaia, Lohiabada ese Mose ia hamaoroa hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Lohiabada ese Mose ia oda henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Kibi rua do oi karaia, hama dekenai idia botaia siliva dekena amo. Idia be do umui hiriria, taunimanima do oi haboudia gwauraia neganai, bona kamepa do umui kokia neganai. ");
INSERT INTO hmo_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Bema kibi ruaosi idia hiriria lata neganai, Israela taudia ibounai be oi dekenai do idia haboua, Palai Dubu ena iduara dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","To kibi tamona do ia hiriria lata neganai, Israela gunalaia taudia, iduhu edia lohia taudia sibona do idia haboua oi dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“Bema kibi idia hiriria kwadogi bona regena bada neganai, kamepa ena dina daekau kahana dekenai idia noho iduhu taudia ese edia palai ruma bona kohu do idia kokia, do idia huaia lao. ");
INSERT INTO hmo_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Bema kibi idia hiriria kwadogi bona regena bada nega rua neganai, kamepa ena diho kahana iduhu taudia ese edia palai ruma bona kohu do idia kokia, do idia huaia lao. Kibi idia hiriria kwadogi, regena bada gaudia, be kamepa toreisi ena toana. ");
INSERT INTO hmo_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","To taunimanima haboua totona, kibi do idia hiriria lata. ");
INSERT INTO hmo_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Kibi be Arona ena natuna tau ese do idia hiriria. Emui kibi taravatuna be inai, hari ia lao bona nega ibounai. ");
INSERT INTO hmo_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Bema umui dekenai idia tuari henia taudia ese emui tano dekenai umui idia hadikaia, bona umui idia tuari henia neganai, kibi do umui hiriria kwadogi, to mai regena bada. Unai neganai lau, Lohiabada, emui Dirava, ese umui do lau laloa, bona umui do lau hamauria, umui idia hadikaia taudia dekena amo. ");
INSERT INTO hmo_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","“Emui moale dinadia neganai danu, emui hua matamatana guriguri aria, bona emui guriguri aria haida dekenai danu, umui ese kibi do umui hiriria. Emui gabua ore bouboudia bona maino karaia bouboudia umui henia neganai danu kibi do umui hiriria. Unai neganai lau ese umui do lau laloa bona durua. Lau be Lohiabada, emui Dirava.” ");
INSERT INTO hmo_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Lagani iharuana, hua iharuana ena dina namba 20 dekenai, ori ese Palai Dubu, Lohiabada ia noho ena toana, ia rakatania, ia daekau lao. ");
INSERT INTO hmo_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Israela taudia ese Sinai ena taunimanima noho lasi tano idia rakatania hamatamaia. Ori be ia lao, ela bona Parana ena taunimanima noho lasi tano dekenai ia ginidae. ");
INSERT INTO hmo_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Israela taudia ese edia kamepa gabuna idia rakatania nega ginigunana be unai, bona Lohiabada ese Mose ia hamaoroa dalana dekena amo idia raka lao. ");
INSERT INTO hmo_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Iuda iduhu taudia be idia raka guna edia pepe henunai, mai edia iduhu tuari orea toi: Iuda iduhu tuari orea, edia gunalaia tauna be Nasona Aminadaba. ");
INSERT INTO hmo_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Isakara iduhu tuari orea, edia gunalaia tauna be Netanele Suara. ");
INSERT INTO hmo_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Sebuluno iduhu tuari orea, edia gunalaia tauna be Eliaba Helona. ");
INSERT INTO hmo_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Vadaeni Palai Dubu idia kokia, bona Geresone bona Merari iduhu taudia ese idia huaia lao. ");
INSERT INTO hmo_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Idia edia murinai, Rubena iduhu taudia, edia pepe henunai idia raka lao, mai edia tuari orea toi: Rubena iduhu tuari orea, edia gunalaia tauna be Elisuru Sedeuru. ");
INSERT INTO hmo_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeona iduhu tuari orea, edia gunalaia tauna be Selumiele Surisadai. ");
INSERT INTO hmo_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gado iduhu tuari orea, edia gunalaia tauna be Eliasapa Reuele. ");
INSERT INTO hmo_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Vadaeni Kohata taudia ese kohu helagadia idia huaia. Kamepa matamata do idia ginidae lasi neganai, Palai Dubu be Levi taudia haida ese gabu matamata dekenai idia haginia lou guna vadaeni. ");
INSERT INTO hmo_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Idia edia murinai, Eparaima iduhu taudia, edia pepe henunai, idia raka lao, mai edia tuari orea toi: Eparaima iduhu tuari orea, edia gunalaia tauna be Elisama Amihuda. ");
INSERT INTO hmo_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manase iduhu tuari orea, edia gunalaia tauna be Gamaliela Pedasuru. ");
INSERT INTO hmo_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Beniamina iduhu tuari orea, edia gunalaia tauna be Abidana Gideoni. ");
INSERT INTO hmo_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Vadaeni murina dekenai idia mai iduhu idia raka lao, Dano iduhu taudia ese idia gunalaia, mai edia tuari orea toi: Dano iduhu tuari orea, ena gunalaia tauna be Ahiesere Amisadai. ");
INSERT INTO hmo_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Asere iduhu tuari orea, edia gunalaia tauna be Pagiele Okarana. ");
INSERT INTO hmo_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Bona Napatali iduhu tuari orea, edia gunalaia tauna be Ahira Enana. ");
INSERT INTO hmo_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Israela taudia idia toreisi negadia ibounai edia laolao dalana be unai bamona, orea ta ta dekena amo idia raka lao. ");
INSERT INTO hmo_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mose ese iena nakimi Hobaba Reuele, Midiana tauna dekenai ia hereva, ia gwau, “Ai ese laolao ai hamatamaia inai, Lohiabada ese ai dekenai ia gwauhamata vadaeni ai dekenai do ia henia tano dekenai do ai lao. Unai dainai oi danu do oi mai, bona namo do oi davaria, badina be Lohiabada ese ia gwauhamata vadaeni, gau namodia momokani dekena amo Israela do ia hanamoa bada.” ");
INSERT INTO hmo_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobaba ia haere, ia gwau, “Lasi, lau be umui danu do lau lao lasi, egu tano korikori dekenai do lau giroa lou, egu varavara dekenai do lau lao.” ");
INSERT INTO hmo_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mose ma ia gwau, “Mani emu kara ai do oi rakatania lasi, badina oi be taunimanima noho lasi tano ena kamepa gabudia namodia oi diba, bona oi ese ai oi hakaua diba. ");
INSERT INTO hmo_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Bema ai danu oi mai neganai, Lohiabada ese ai dekenai do ia henia gau namodia, be oi danu do ita haria.” ");
INSERT INTO hmo_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Unai neganai Sinai, Lohiabada ena ororo idia rakatania, bona dina toi idia raka lao. Lohiabada ena Taravatu Maua danu be dina toi lalonai idia edia vairana dekenai idia huaia lao, edia laga-ani gabuna ia tahua. ");
INSERT INTO hmo_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Dina neganai, kamepa dekena amo idia toreisi nega ibounai, Lohiabada ena ori ese edia ataiai dekenai ia noho. ");
INSERT INTO hmo_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Taravatu Maua idia huaia lao hamatamaia negadia ibounai, be Mose ia hereva, ia gwau: “Lohiabada e, oi toreisi, oi dekenai idia dagedage taudia do oi hadikaia. Oi dekenai idia badu henia taudia do oi lulua lao.” ");
INSERT INTO hmo_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Bona Taravatu Maua idia atoa diho neganai, ma Mose ia gwau, “Lohiabada e, Israela bese taudia momo momo herea, dekenai mani do oi giroa mai.” ");
INSERT INTO hmo_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Israela taudia be idia hekwarahi dainai, Lohiabada dekenai idia maumau. Lohiabada be ia kamonai, vadaeni ia badu, bona lahi be idia edia latanai ia siaia diho. Unai lahi ese kamepa ena kahana ia gabua noho. ");
INSERT INTO hmo_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Unai neganai Israela taudia ese Mose dekenai idia taitai bada. Vadaeni Mose ese Lohiabada ia noia, bona lahi be ia bodo. ");
INSERT INTO hmo_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Unai dainai unai gabu ena ladana idia atoa Tabera, badina be Lohiabada ena lahi be idia edia huanai ia araia dainai. ");
INSERT INTO hmo_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Bona idau taudia, idau bese taudia haida, be Israela taudia danu idia laolao hebou. Inai taudia be vamu idia ura henia dikadika dainai idia maumau. Unai dainai Israela taudia danu idia taitai hamatamaia lou, idia gwau, “Vamu be edeseni do ita abia? ");
INSERT INTO hmo_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Aigupito ita noho neganai, gwarume ita ania be davana lasi, ani? Bona kiukamba, bona meloni bona liki bona oniani bona galiki be momo herea, ani? ");
INSERT INTO hmo_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","To harihari iseda goada ia ore, aniani gauna ta be lasi, inai mana sibona mo ita itaia noho.” ");
INSERT INTO hmo_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana be nadinadi kurokurona bamona, boroko auna ena todena bamona. ");
INSERT INTO hmo_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Taunimanima ese dabai inai mana idia gogoa. Idia be gwada-gwada auna lalonai idia gwadaia ela bona paraoa bamona idia halaoa, o nadi uili, metau gauna, dekena amo idia moia maragimaragi, vadaeni uro dekenai idia nadua, bona keke idia karaia. Iena mamina be paraoa bona olive huahua ena digara danu idia mikisi hebou bamona. ");
INSERT INTO hmo_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Hanuaboi neganai paripari ena ranu be kamepa dekenai ia diho neganai, inai mana danu nega tamona ia diho. ");
INSERT INTO hmo_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Israela taudia ibounai idia taitai, idia ta ta edia palai rumadia iduara dekenai. Vadaeni Mose ese edia taitai ia kamonai, bona iena lalona ia hisihisi bada, badina Lohiabada be ia badu dikadika. ");
INSERT INTO hmo_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mose ese Lohiabada dekenai ia hereva, ia gwau, “Badina dahaka inai bamona lau oi hadikaia? Badina dahaka oiemu lalona ia namo lasi lau dekenai? Edena bamona inai bese ibounai naria gaukara be lau dekenai oi henia? ");
INSERT INTO hmo_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Inai bese badana be lauegu natuna, a? Lau ese lau havaradia, a? Badina dahaka oi be oi gwau, ‘Oiemu imana dekenai do oi rosidia, rata ia inua memero bamona, ela bona edia sene taudia edia tano, lau gwauhamata do lau henidia tanona dekenai, a?’ ");
INSERT INTO hmo_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Vamu be edeseni do lau abia, inai taunimanima momo herea ubua totona? Badina idia be egu vairana dekenai idia taitai noho, idia gwau, ‘Vamu ai dekenai henia, do ai ania.’ ");
INSERT INTO hmo_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Lau sibona inai taunimanima lau naria be lau hegeregere lasi, maduna ia metau herea, huaia be lau goada lasi. ");
INSERT INTO hmo_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Bema oi ese inai bamona lau dekenai do oi karaia noho, mani do oi bogahisihisi lau dekenai, lau do oi alaia mase, vadaeni oiemu badu be do lau mamia lou lasi.” ");
INSERT INTO hmo_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Vadaeni Lohiabada ese Mose ia hereva henia, ia gwau, “Israela tau badadia 70 do oi abia hidi, oi diba idia be tau badadia korikori, bona mai edia siahu taunimanima edia huanai. Idia do oi haboua Palai Dubu ena vairana dekenai, oi danu do idia gini. ");
INSERT INTO hmo_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Vadaeni lau be do lau diho, umui dekenai do lau hereva unuseni. Bona oi dekenai lau henia siahuna ena kahana do lau abia lou, idia dekenai do lau henia. Vadaeni Israela besena naria gaukara be oi danu do idia karaia, maduna do umui huaia hebou, oi sibona do oi huaia lasi. ");
INSERT INTO hmo_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Israela taudia danu do oi hamaoroa, do oi gwau: Umui sibona ta ta do umui helaga, badina be kerukeru vamu do umui ania. Badina be Lohiabada ese emui taitai ia kamonai vadaeni. Bona umui gwau Aigupito dekenai umui noho neganai umui boga kunu, bona vamu umui ura, be Lohiabada ia kamonai vadaeni. Unai dainai Lohiabada ese vamu do ia henia, do umui ania. ");
INSERT INTO hmo_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Dina tamona sibona lasi, dina rua, o dina ima, o dina 10, o dina 20 sibona lasi. ");
INSERT INTO hmo_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","To hua ta ena dina ibounai be vamu do umui ania, ela bona do umui hesiku, do umui negea. Badina be Lohiabada, umui huanai ia noho Diravana, be umui gwau henia vadaeni. Ia dekenai umui maumau vadaeni, umui gwau: ‘Badina dahaka Aigupito ai rakatania?’ ” ");
INSERT INTO hmo_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","To Mose be Lohiabada dekenai ia hereva, ia gwau, “Be, lauegu bese taudia be 600,000, edia aena dekenai idia raka taudia. To oi gwau, ‘Vamu do lau henidia, do idia ania, ela bona hua ta do ia ore.’ ");
INSERT INTO hmo_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Mamoe momo herea bona nani momo herea do idia alaia ore, edia aniani totona, a? O davara gwarume ibounai do idia abia ore, edia bogana do idia hakunua totona, a?” ");
INSERT INTO hmo_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Lohiabada ese Mose dekenai ia haere, ia gwau, “Lohiabada ena siahu be mai ena dokona, a? Iena imana ia kwadogi, a? Nega sisina do oi itaia, lauegu hereva do ia momokani o lasi.” ");
INSERT INTO hmo_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Unai dainai Mose ese Palai Dubu ia rakatania, Lohiabada ena hereva Israela taudia dekenai ia hamaoroa. Vadaeni gunalaia tau badadia 70 ia abia hidi, Palai Dubu ena murimurina dekenai ia atodia, idia gini hagegea. ");
INSERT INTO hmo_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Vadaeni unai neganai Lohiabada be ori lalonai ia diho, Mose dekenai ia hereva. Bona Mose dekenai ia henia vadaeni siahuna ena kahana be Lohiabada ese ia abia lou, unai gunalaia taudia 70 dekenai ia henia. Vadaeni inai siahu be idia edia latanai ia diho neganai, idia ese peroveta taudia bamona idia boiboi, to unai nega sisina sibona. ");
INSERT INTO hmo_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Unai gunalaia taudia edia orea taudia rua, edia ladana Eledada bona Medada, be kamepa dekenai idia noho, Palai Dubu dekenai idia lao lasi. Vadaeni, unuseni, kamepa lalonai siahu be idia edia latanai ia diho, bona peroveta taudia bamona idia boiboi. ");
INSERT INTO hmo_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Eregabe tauna ta ese Mose dekenai ia heau lao, ia gwau, “Eledada bona Medada be kamepa lalonai idia peroveta noho.” ");
INSERT INTO hmo_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Vadaeni Iosua Nunu, ia be mero negana ela bona ia bada ia be Mose ena hesiai tauna, ese Mose ia hamaoroa, ia gwau, “Mose, tau badana e, do oi hadokodia.” ");
INSERT INTO hmo_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mose ia haere, ia gwau, “Lau dainai oi mama, a? Lohiabada ena orea taudia ibounai do idia peroveta, bona Lohiabada ese iena Lauma be ibounai edia latanai bema ia atoa be namo, ani?” ");
INSERT INTO hmo_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Vadaeni Mose bona unai Israela gunalaia taudia danu kamepa dekenai idia giroa lou. ");
INSERT INTO hmo_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Unai neganai Lohiabada ese lai ia siaia, vadaeni unai lai ese kibi manu momo davara kahana dekena amo ia harohodia. Idia roho lao, ela bona Israela taudia edia kamepa dekenai. Ataiai momokani dekenai idia roho lasi, to tano ena ataiai dekenai mita ta bamona idia roho. Kamepa ena tano kahana ibounai dekenai inai kibi manu idia diho. Idia diho gabuna ena bada be kilomita momo hegeregerena kahana ta dekenai, bona ma kahana ta dekenai danu kilomita momo hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Vadaeni unai dina dekenai, unai hanuaboi, bona kerukeru danu kamepa taudia ese unai kibi manu idia haboua. Ia haboua maragi tauna ese kilogaram 1000 ia haboua. Kamepa ena tano kahana ibounai dekenai taunimanima ese kibi manu idia hakaukaua. ");
INSERT INTO hmo_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","To unai taudia ese edia uduna dekenai vamu idia atoa, idia do hadonoa lasi neganai, Lohiabada ena badu idia dekenai ia siahu, vadaeni ia ese roho hanai mase gorere dikana ta idia dekenai ia siaia. ");
INSERT INTO hmo_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Unai dainai unai gabu ena ladana idia atoa “Mataganigani ena Guria Gabuna,” badina be unuseni vamu idia ura dikadika taudia idia guridia. ");
INSERT INTO hmo_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Unai gabu dekena amo ma idia laolao, ela bona Haseroto dekenai idia ginidae, unuseni idia kamepa. ");
INSERT INTO hmo_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mose ese Kusu hahine ta ia adavaia, bona unai dainai Miriama bona Arona be ia dekenai idia maumau. ");
INSERT INTO hmo_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Idia gwau, “Lohiabada be Mose sibona mo ena uduna dekena amo ia hereva, a? Sedira ai danu aiemai hereva dekena amo Lohiabada ia hereva vadaeni.” Lohiabada ese edia hereva ia kamonai. ");
INSERT INTO hmo_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mose be tanobada taudia ibounai edia huanai ia sibona be manau herea. ");
INSERT INTO hmo_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","To karaharaga Lohiabada ese Mose bona Arona bona Miriama dekenai ia hereva henia, ia gwau, “Umui toiosi umui raka mai, Palai Dubu dekenai umui mai.” Vadaeni toiosi idia lao. ");
INSERT INTO hmo_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Vadaeni Lohiabada be ori lalonai ia diho, Palai Dubu ena vairanai ia gini, Arona bona Miriama ia boiridia, bona ia dekenai idia raka lao. ");
INSERT INTO hmo_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Lohiabada ia gwau, “Lauegu hereva umui kamonai: Umui Israela bese emui huanai, bema peroveta taudia idia noho neganai, mata hanai bona nihi dekena amo idia dekenai lau hedinarai. ");
INSERT INTO hmo_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","To lauegu hesiai tauna Mose dekenai be inai bamona lau hedinarai lasi. Ia be lauegu bese Israela taudia edia naria tauna. ");
INSERT INTO hmo_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Unai dainai ia danu ai herevahereva neganai, lauegu uduna dekenai lau hereva, iena uduna dekenai ia hereva, ai hereva hunia lasi. Lau Lohiabada egu laulau toana korikori be Mose ese iena matana dekena amo ia itaia vadaeni. Umui ruaosi be edena bamona lauegu hesiai tauna Mose dekenai umui maumau? Umui gari lasi, a?” ");
INSERT INTO hmo_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Idia ruaosi dekenai Lohiabada ese ia badu herea, vadaeni ia ese idia ia rakatania. ");
INSERT INTO hmo_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ori be Palai Dubu dekena amo ia daekau neganai, Miriama be lepera gorere ia abia. Iena kopina be kurokuro, sinou bamona. Arona ese Miriama ia itaia ia be lepera gorere ia abia vadaeni. ");
INSERT INTO hmo_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Vadaeni Arona ese Mose dekenai ia hereva, ia gwau, “Lohia e, ai be kara kava ai karaia vadaeni, ai kara dika vadaeni. Mani emu kara aiemai dika davana do oi henia lasi. ");
INSERT INTO hmo_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Inai hahine mani oi durua, ia be mase gauna, sinana bogana dekena amo ia vara dika kekeni, iena kopina kahana ia darea oho bamona garina.” ");
INSERT INTO hmo_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Vadaeni Mose ese Lohiabada dekenai ia noinoi, ia gwau, “Dirava e, mani oi hanamoa.” ");
INSERT INTO hmo_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","To Lohiabada ese Mose ia haere henia, ia gwau, “Bema Miriama ena tamana ese Miriama ena vairana dekenai bema ia kanudia, Miriama be mai hemarai danu do ia noho dina 7, ani? Unai dainai Miriama be dina 7 kamepa ena murimuri dekenai do ia noho, unai murinai do idia hakaua vareai lou.” ");
INSERT INTO hmo_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Unai dainai Miriama be kamepa murimuri dekenai ia noho ela bona dina 7 idia ore. Bona Israela taudia be edia laolao idia matamaia lou lasi ela bona Miriama be kamepa lalonai ma idia hakaua vareai lou. ");
INSERT INTO hmo_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Unai murinai Israela taudia ese Haseroto idia rakatania, Parana tano, taunimanima idia noho lasi tanona dekenai idia kamepa lou. ");
INSERT INTO hmo_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Hasinadoa taudia do oi siaidia, Kanana dekenai do idia lao, unai tano taudia edia goada do idia itaia totona. Unai tano be Israela taudia dekenai do lau henia. Iduhu ta ta ibounai dekena amo lohia taudia do oi siaidia.” ");
INSERT INTO hmo_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Vadaeni Mose ese Parana tano, taunimanima noho lasi gabuna dekena amo ia siaidia. Idia ibounai be Israela lohia taudia. ");
INSERT INTO hmo_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Edia ladana be inai: Rubena iduhu dekena amo, Samua Sakuru. ");
INSERT INTO hmo_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeona iduhu dekena amo, Sapata Hori. ");
INSERT INTO hmo_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Iuda iduhu dekena amo, Kaleba Iepune. ");
INSERT INTO hmo_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isakara iduhu dekena amo, Igala Iosepa. ");
INSERT INTO hmo_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Eparaima iduhu dekena amo, Hosea Nunu. ");
INSERT INTO hmo_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Beniamina iduhu dekena amo, Paliti Rapu. ");
INSERT INTO hmo_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sebuluno iduhu dekena amo, Gadiela Sodi. ");
INSERT INTO hmo_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Manase Iosepa iduhu dekena amo, Gadi Susi. ");
INSERT INTO hmo_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dano iduhu dekena amo, Amiele Gemali. ");
INSERT INTO hmo_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asere iduhu dekena amo, Seturu Mikaela. ");
INSERT INTO hmo_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Napatali iduhu dekena amo, Nabi Vopisi. ");
INSERT INTO hmo_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gado iduhu dekena amo, Gevele Maki. ");
INSERT INTO hmo_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Hasinadoa taudia edia ladana be unai, Mose ese ia siaia, Kanana dekenai idia lao. To Mose ese Hosea Nunu dekenai ladana matamata ia henia, Iosua. ");
INSERT INTO hmo_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Vadaeni Mose ese ia siaidia, Kanana do idia itaia. Ia gwau, “Mirigini kahana do umui lao, Kanana ena diho kahana do umui vareai. Unai gabu dekena amo Kanana ena ororo gabudia dekenai do umui lao. ");
INSERT INTO hmo_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Tano ena toana do umui itaia, bona unai tano ena taudia edia toana do umui itaia, idia goada o manoka, idia be momo o momo lasi. ");
INSERT INTO hmo_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Edia tano be edena bamona do umui itaia, ia namo o dika. Bona unai taudia edia hanua do umui itaia, kamepa dekenai, o hanua mai magu danu lalonai idia noho. ");
INSERT INTO hmo_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Edia uma gabudia danu do umui itaia, idia be namo o dika, bona au idia noho o lasi. Bona do umui goada, tano ena au huahua haida do umui abia mai lou.” Badina be unai negana be vain huahua idia mage hamatamaia negana. ");
INSERT INTO hmo_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Vadaeni unai tatau be mirigini kahana idia lao, Kanana tanona idia itaia, Sini taunimanima idia noho lasi tanona ela bona Rehoba, Hamata dalana dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Kanana ena diho kahana idia itaia guna, bona Heberona dekenai idia ginidae. Unuseni Ahimana bona Sesai bona Talamai, Anaki besena taudia idia noho. Unai Anaki taudia edia tauanina idia bada herea. Unai Heberona hanua idia haginia murinai, ma lagani 7 idia lao murinai, Aigupito taudia ese Soana hanua idia haginia Aigupito dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Unai murinai Esakolo Koura dekenai idia ginidae. Unuseni vain auna ena rigi ta idia utua. Unai rigi tamona dekenai be vain huahua idia noho, edia metau be bada herea, tau rua idia huaia hegeregerena gaudia. Apolo bona fig au huahua haida danu idia gogoa, idia huaia mai. ");
INSERT INTO hmo_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Unai gabu ena ladana idia atoa Esakolo Kourana, badina be Israela taudia ese vain huahua unuseni idia utua dainai. ");
INSERT INTO hmo_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Dina 40 murinai hasinadoa taudia be idia giroa lou. Mose, Arona bona Israela taudia ibounai Kadesi dekenai, Parana tano, taunimanima noho lasi gabuna dekenai idia ginidae lou. ");
INSERT INTO hmo_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Vadaeni unai Kanana tano ena sivarai idia hamaoroa, bona unai au huahua gaudia idia dekenai idia hedinaraia. ");
INSERT INTO hmo_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Mose dekenai idia hereva, idia gwau, “Oi ese ai oi siaia tanona ai itaia vadaeni, bona momokani ia be rata bona hani dekenai ia honu tanona. Tano ena au huahua haida be inai. ");
INSERT INTO hmo_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","To unai tano ena taudia be goada herea, edia hanua danu be bada herea, bona mai edia magu. Tauanina bada taudia, Anaki ena besena danu unuseni ai itaia. ");
INSERT INTO hmo_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Diho kahana dekenai Amaleka taudia idia noho. Ororo gabudia dekenai Hiti taudia, Iebusu taudia bona Amoro taudia idia noho. To kone dekenai bona Ioridane Sinavai dekenai be Kanana taudia idia noho.” ");
INSERT INTO hmo_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Vadaeni Kaleba ese Mose idia hagegea taudia edia maumau hereva ia hadokoa, ia gwau, “Harihari unai tano ita tuari henia be namo, badina ita be mai goada, unai tano ita abia diba.” ");
INSERT INTO hmo_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","To ia danu idia lao taudia idia gwau, “Unai tano taudia ita tuari henia diba lasi, badina idia be goada, ita be manoka.” ");
INSERT INTO hmo_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Unai dainai idia ese sivarai koikoi Israela taudia dekenai idia hadibaia, idia gwau, “Unai ai itaia tanona ena uma anina be hegeregere lasi, bona unuseni idia noho taudia edia aniani be hegeregere lasi. Unai gabu dekenai be tauanina lata herea taudia sibona idia noho. ");
INSERT INTO hmo_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Bona tauanina bada herea taudia danu unuseni ai itaia, Anaki ena besena taudia, Nepili dekena amo idia mai taudia. Ai ese ai laloa ai be maragi, kwadi bamona, idia edia vairana dekenai. Bona idia ese danu ai idia itaia, idia laloa ai be kwadi bamona.” ");
INSERT INTO hmo_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Unai hanuaboi be Israela taudia ibounai idia taitai bada ela bona dabai. ");
INSERT INTO hmo_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israela taudia ibounai ese Mose bona Arona dekenai idia maumau. Idia gwau, “Aigupito dekenai o inai taunimanima noho lasi tanona dekenai ai mase be namo. ");
INSERT INTO hmo_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Badina dahaka Lohiabada ese unai tano dekenai ai ia hakaua noho gwauraia? Unuseni tuari dekenai do ai mase, bona aiemai adavana bona natuna do idia abia mauri. Aigupito dekenai do ai giroa lou be namo, ani?” ");
INSERT INTO hmo_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Vadaeni idia sibona ta ta dekenai idia hereva henia, idia gwau, “Iseda biaguna ta do ita abia hidi, Aigupito dekenai do ita giroa lou.” ");
INSERT INTO hmo_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Vadaeni Mose bona Arona ese Israela taudia ibounai edia vairanai idia tui diho, bona edia kwarana idia atoa diho. ");
INSERT INTO hmo_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Bona Iosua Nunu bona Kaleba Iepune, hasinadoa taudia rua ese lalohisihisi dainai edia dabua idia darea. ");
INSERT INTO hmo_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Idia ese Israela taudia idia hamaoroa, idia gwau, “Unai ai itaia tanona be namo herea. ");
INSERT INTO hmo_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Bema Lohiabada ese ita dekenai ia laloa namo neganai, ia ese unai tano dekenai ita do ia hakaua. Oibe, ia ese unai tano, rata bona hani dekenai ia honu tanona ita dekenai do ia henia. ");
INSERT INTO hmo_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","To Lohiabada do umui tuari henia lasi, bona unai tano taudia do umui gari henia lasi, do ita halusidia haraga. Lohiabada be ita dekenai ia noho, to idia be durua diravana ta lasi. Unai dainai do umui gari lasi.” ");
INSERT INTO hmo_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","To Israela taudia ibounai ese nadi dekenai idia do idia alaia gwauraia. Vadaeni nega tamona Lohiabada ena diaridiari be unai taunimanima edia vairanai, Palai Dubu dekenai ia hedinarai. ");
INSERT INTO hmo_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Lohiabada ese Mose dekenai ia hereva henia, ia gwau, “Inai taunimanima be lau dekenai do idia kamonai henia lasi ela bona edena negai? Toa kara momo herea idia dekenai lau karaia vadaeni. Edena negai lau dekenai do idia abidadama henia? ");
INSERT INTO hmo_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Lau be gorere dikana, hanaia gorerena idia dekenai do lau siaia, idia do lau hadikaia ore. To oi dekenai goada do lau henia, vadaeni oi dekena amo bese ta, inai bese do idia hereaia besena do lau havaraia.” ");
INSERT INTO hmo_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mose ese Lohiabada dekenai ia haere henia, ia gwau, “Oi ese oiemu siahu dekena amo, inai bese Aigupito dekena amo oi hakaua mai vadaeni. ");
INSERT INTO hmo_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Bema ai oi hadikaia neganai, Aigupito taudia ese Kanana taudia do idia hamaorolaia. Kanana taudia be idia kamonai vadaeni oi Lohiabada ese, be ai dekenai oi noho. Bona idia diba vadaeni, ori be aiemai ataiai neganai, oi sibona oiemu toana oi hedinaraia momokani. Bona idia diba oi be aiemai vairana dekenai oi lao noho, dina dekenai oi be ori lalonai, bona hanuaboi dekenai oi be lahi dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Bema oiemu bese ibounai oi alaia ore neganai, oiemu sivarai idia kamonai besedia do idia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Lohiabada be mai siahu lasi inai bese ia gwauhamata henidia tano dekenai do ia hakaudia vareai. Unai dainai ia ese taunimanima noho lasi tano dekenai iena bese ia aladia ore.’ ");
INSERT INTO hmo_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Unai dainai Lohiabada e, oi dekenai lau noinoi, oiemu siahu mani do oi hedinaraia, bona oiemu hereva gauna do oi badinaia, hereva be inai: ");
INSERT INTO hmo_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Lau Lohiabada, be badu haraga lasi, lauegu lalokau bona bogahisihisi be bada, bona kara dika bona kamonai henia lasi karadia lau gwauatao. To kara dika taudia edia dika do lau laloaboio lasi, badina edia natudia do lau panisia ela bona uru toi bona uru 4 do idia ore.’ ");
INSERT INTO hmo_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Lau be oi dekenai lau noinoi, oiemu bogahisihisi ia bada herea dainai, inai bese edia kara dika do oi gwauatao. Mani edia dika do oi gwauatao, Aigupito idia rakatania ia mai bona hari edia dika oi gwauatao hegeregerena.” ");
INSERT INTO hmo_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Lohiabada ia haere, ia gwau, “Oiemu noinoi hegeregerena, edia dika lau gwauatao vadaeni. ");
INSERT INTO hmo_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","To momokani, lau be lau mauri noho hegeregerena, bona lau Lohiabada, egu hairaina ese tanobada ibounai ia hahonua hegeregerena, ");
INSERT INTO hmo_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","idia ta lasi ese unai tano do idia itaia. Idia ese lauegu diaridiari idia itaia vadaeni, bona Aigupito dekenai, bona taunimanima lasi gabuna dekenai danu lau karaia hoa karadia idia itaia vadaeni. To lauegu hereva idia kamonai henia lasi, bona nega 10 lau dekenai idia dibagania. ");
INSERT INTO hmo_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Idia ta lasi ese edia sene taudia dekenai lau gwauhamata tanona do idia itaia. Momokani lau idia negea taudia ta ese unai tano do ia itaia lasi. ");
INSERT INTO hmo_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","To lauegu hesiai tauna Kaleba ena laumana be idau, bona ia ese lau ia badinaia. Unai dainai ia itaia tanona dekenai be lau ese do lau hakaua vareai. Bona iena natuna taudia ese unai tano do idia abia, idia edia tano. ");
INSERT INTO hmo_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","To harihari, Amaleka taudia bona Kanana taudia be koura dekenai idia noho dainai, kerukeru be do umui toreisi, taunimanima noho lasi tanona dekenai do umui giroa lou, Davara Kakakaka kahana dekenai.” ");
INSERT INTO hmo_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Lohiabada ese Mose bona Arona dekenai ia hereva, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Inai orea dikana lau dekenai do idia maumau ela bona edena negai? Israela taudia edia maumau hereva lau kamonai, be lau hesiku. ");
INSERT INTO hmo_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Do umui hamaorodia, do umui gwau, Lohiabada be ia gwau: ‘Lau mauri noho dainai, lau gwauhamata inai: Umui emui noinoi hereva dikana hegeregerena, be umui dekenai do lau karaia. Lau Lohiabada lau hereva inai: ");
INSERT INTO hmo_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Inai taunimanima noho lasi tano dekenai do umui mase. Umui ibounai, lau dekenai umui maumau taudia, lagani 20 umui abia vadaeni taudia, be unai gwauhamata tano do umui vareai lasi. ");
INSERT INTO hmo_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Guna lau gwauhamata henia vadaeni, umui be unai tano dekenai do umui noho. To umui ta lasi do ia noho, Kaleba bona Iosua sibona be unai tano dekenai do idia noho. ");
INSERT INTO hmo_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","To umui emui natudia maragidia, umui gwau Kanana taudia ese do idia abidia mauri, be do lau hakaudia. Vadaeni idia be umui ese umui negea vadaeni tanona do idia abia. ");
INSERT INTO hmo_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","To umui be inai taunimanima noho lasi tano dekenai do umui mase. ");
INSERT INTO hmo_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Umui emui natudia be lagani 40 lalonai inai taunimanima noho lasi tano dekenai edia mamoe do idia naria. Inai edia hisihisi be emui kara dika dainai do idia abia, ela bona umui ibounai inai taunimanima lasi tano dekenai do umui mase ore. ");
INSERT INTO hmo_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Lagani 40 lalonai, emui kara dika dainai, hisihisi do umui abia. Inai lagani 40 ena badina be, umui hasinadoa dinadia be 40 dainai. Oibe, umui dekenai do lau tuari henia, bona inai lauegu tuari ena mamina do umui abia momokani. ");
INSERT INTO hmo_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Lau Lohiabada lau hereva momokani inai: Momokani, umui orea dikana, lau dekenai dagedage henia totona umui haboua taudia e, umui ta ta ibounai be inai taunimanima lasi tano dekenai do umui mase ore.’ ” ");
INSERT INTO hmo_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Unai hasinadoa taudia, Mose ia siaidia unai tano itaia totona, bona idia giroa lou neganai, sivarai dikana idia gwauraia. Bona unai sivarai dainai Israela taudia ese Lohiabada dekenai idia maumau. ");
INSERT INTO hmo_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Unai dainai Lohiabada ese gorere dikana ia henidia, vadaeni idia mase ore. ");
INSERT INTO hmo_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","To Iosua Nunu bona Kaleba Iepune be idia mauri, hasinadoa taudia ibounai 12 edia huanai, idia ruaosi sibona idia mauri. ");
INSERT INTO hmo_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mose ese Israela taudia dekenai Lohiabada ena hereva ia hamaorodia neganai, idia lalohisihisi bada herea. ");
INSERT INTO hmo_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Kerukeru dabai idia toreisi, ororo kahana dekenai idia daekau, idia gwau, “Harihari ai be Lohiabada ia gwauhamata henia tano dekenai do ai lao, badina ai diba ai kara dika vadaeni.” ");
INSERT INTO hmo_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","To Mose ia gwau, “Dahaka dainai Lohiabada ena oda umui kamonai henia lasi? Do umui kwalimu diba lasi. ");
INSERT INTO hmo_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Do umui lao lasi, umui dekenai idia tuari henia taudia ese umui do idia halusia garina, badina Lohiabada be umui dekenai ia noho lasi. ");
INSERT INTO hmo_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Badina be Amaleka taudia bona Kanana taudia be umui emui vairana dekenai idia noho. Idia ese umui do idia alaia mase tuari dekenai. Lohiabada ena dala umui rakatania dainai, ia be umui dekenai do ia noho lasi.” ");
INSERT INTO hmo_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","To idia hekokoroku noho dainai, idia daekau lao ororo dekenai. To Mose bona Lohiabada ena Taravatu Maua be kamepa dekenai idia noho. ");
INSERT INTO hmo_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Vadaeni Amaleka taudia bona Kanana taudia, unai ororo dekenai idia noho taudia ese Israela taudia idia tuari henidia, idia halusidia. Bona idia ese Israela taudia idia lulua lao ela bona Horoma. ");
INSERT INTO hmo_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Lohiabada ese Mose ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Israela taudia do oi hereva henia, do oi gwau, ‘Lohiabada ese umui dekenai do ia henia tano dekenai do umui ginidae neganai, ");
INSERT INTO hmo_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","boromakau tau ta, mamoe tau ta, mamoe ta, o nanigosi ta be Lohiabada dekenai gabua ore boubouna totona, o gwauhamata boubouna totona, o laloa namo boubouna, o emui aria ta boubouna totona do umui henia. Inai aniani bouboudia edia bonana be namo herea Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","“ ‘Unai neganai danu boubou do ia henia tauna ese paraoa namo herea ena metau kilogaram ta, olive dehoro, ena bada lita ta dekenai ia mikisi gauna ma do ia henia. ");
INSERT INTO hmo_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Gabua ore boubouna, o boubou ta totona, mamoe natuna ta ta danu be uaina lita ta, ma do ia henia. ");
INSERT INTO hmo_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Bema mamoe tau idia henia neganai, paraoa ena metau kilogaram rua, olive dehoro, 1 lita 500 garam danu mikisi gauna, be paraoa boubouna totona do idia henia, ");
INSERT INTO hmo_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ma uaina ena bada 1 lita 500 garam danu do idia henia. Inai bouboudia be Lohiabada dekenai edia bonana be namo herea. ");
INSERT INTO hmo_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Bema boromakau tau be gabua ore boubouna, o gwauhamata boubouna, o maino karaia boubouna totona Lohiabada dekenai umui henia neganai, ");
INSERT INTO hmo_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","paraoa boubouna, paraoa ena metau kilogaram toi, olive dehoro ena bada lita rua dekenai idia mikisi gauna danu do umui henia, ");
INSERT INTO hmo_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","mai uaina ena bada lita rua danu. Inai boubou ena bonana be Lohiabada dekenai ia namo herea. ");
INSERT INTO hmo_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“ ‘Boromakau tau ta ta danu, mamoe tau ta ta danu, mamoe natuna ta ta danu, bona nanigosi natuna ta ta danu henia gaudia Lohiabada dekenai be unai bamona. ");
INSERT INTO hmo_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Bema boubou totona mauri gaudia be tamona sibona lasi neganai, paraoa bona uaina boubouna danu be tamona sibona lasi. Mauri gaudia hida do umui henia gwauraia, unai namba hegeregerena danu paraoa bona uaina bouboudia do umui henia. ");
INSERT INTO hmo_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Israela korikori taudia ibounai ese aniani gabua boubouna idia henia neganai, inai bamona taravatu do idia badinaia, bona Lohiabada dekenai unai boubou ena bonana be namo herea. ");
INSERT INTO hmo_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","“ ‘Sedira idau bese tauna ta, nega sisina o nega daudau umui emui huanai ia noho tauna ese aniani gabua boubouna, Lohiabada dekenai ena bonana be namo gauna, ia ura do ia henia. Bema ia henia neganai, ia ese boubou henia taravatu, umui ese umui badinaia gauna hegeregerena do ia badinaia. ");
INSERT INTO hmo_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Umui bona umui emui huanai idia noho idau bese, umui ibounai dekenai taravatu be tamona, hari ela bona nega ibounai. Lohiabada ena vairana dekenai umui bona idia be tamona. ");
INSERT INTO hmo_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Taravatu bona oda ibounai be tamona, umui, bona umui dekenai noho idau bese taudia emui latanai.’ ” ");
INSERT INTO hmo_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Lohiabada ese ma Mose dekenai ia hereva lou, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Israela taudia do oi hamaoroa, inai bamona: Lau Lohiabada ese umui do lau henia tano dekenai umui ginidae neganai, inai taravatu do umui badinaia: ");
INSERT INTO hmo_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Unai tano dekenai anina do umui ania hamatamaia neganai, aniani haida be harihari gauna Lohiabada dekenai do umui henia. ");
INSERT INTO hmo_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","“Bema paraoa umui gabua neganai, beredi ginigunana, uiti anina ginigunana dekena amo be Lohiabada ena vairanai do umui atoa, ia be harihari gauna, Lohiabada ena. Inai be do umui henia, uiti kwadia gabuna dekena amo umui henia harihari gauna umui henia dalana hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","“Hari ela bona hanaihanai, inai harihari gauna be Lohiabada dekenai do umui henia, umui gabua beredi ibounai dekena amo. ");
INSERT INTO hmo_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“To bema tau ta ia diba lasi dainai inai taravatu, Lohiabada ese Mose ia henia gauna, ia badinaia lasi neganai, ");
INSERT INTO hmo_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","o bema vaira neganai Israela taudia ese Lohiabada ena oda ibounai, Mose ia henia gaudia do idia badinaia lasi, ");
INSERT INTO hmo_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","bona bema unai kerere idia karaia, badina be taravatu idia diba lasi dainai, idia ese boromakau tau do idia henia, gabua ore boubouna totona, mai bonana namona Lohiabada dekenai gauna. Paraoa bona uaina bouboudia danu nega tamona do idia henia, bona nanigosi tau, kara dika totona boubouna danu do idia henia unai neganai. ");
INSERT INTO hmo_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“Vadaeni hahelagaia tauna ese Israela orea ibounai edia kara dika davana do ia karaia, bona Lohiabada ese edia kara dika do ia gwauatao, badina edia kerere be idia karaia kava, idia diba lasi dainai, bona edia kerere totona aniani boubouna idia henia vadaeni Lohiabada dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Unai neganai Israela taudia bona edia huanai noho idau bese taudia danu edia kara dika be Lohiabada ese do ia gwauatao. Badina be unai kara dika kava ese taunimanima ibounai ia hakererea vadaeni. ");
INSERT INTO hmo_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“To bema tau ta sibona ese kara kerere ia karaia kava neganai, ia ese nanigosi hahine do ia henia, kara dika totona boubouna. ");
INSERT INTO hmo_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Hahelagaia tauna ese Lohiabada ena vairana dekenai unai tau ena kara dika ena davana do ia karaia, bona Lohiabada ese iena kara dika do ia gwauatao. ");
INSERT INTO hmo_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Inai kara kerere ia karaia kava taravatuna be tamona sibona, bese ibounai taudia edia latanai. Bema Israela tauna o Israela dekenai ia noho idau tauna ese unai bamona ia kerere neganai, taravatu be tamona sibona. ");
INSERT INTO hmo_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“To bema Israela tauna o Israela dekenai ia noho idau tauna ese mai hekokoroku bona mai laloa dika danu kara kerere ia karaia, inai be ia ese Lohiabada ia matauraia lasi. Vadaeni unai bamona tauna be do umui alaia mase. ");
INSERT INTO hmo_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Badina be ia ese Lohiabada ena hereva ia negea vadaeni, bona ia ese mai hekokoroku danu, Lohiabada ena taravatu ta ia makohia vadaeni. Iena mase be ia sibona ena kerere dainai.” ");
INSERT INTO hmo_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israela taudia be taunimanima idia noho lasi tano dekenai idia noho neganai, idia ese tau ta idia itaia, Sabati Dina dekenai lahi totona au ia gogoa noho. ");
INSERT INTO hmo_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Vadaeni unai kara ia karaia tauna idia davaria taudia ese unai tau idia abia, Mose bona Arona, bona Israela taudia ibounai dekenai idia hakaua lao. ");
INSERT INTO hmo_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Vadaeni idia guia, bona gabu ta dekenai idia koua, ela bona Lohiabada ese iena ura idia dekenai do ia hedinaraia. ");
INSERT INTO hmo_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Vadaeni Lohiabada ese Mose ia hamaoroa, ia gwau, “Inai tau be do umui alaia mase. Kamepa ena murimurina dekenai be kamepa taudia ibounai ese nadi dekena amo unai tau do idia hodoa mase.” ");
INSERT INTO hmo_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Vadaeni Israela taudia ibounai ese unai tau idia abia lao kamepa ena murimurinai, bona unuseni nadi dekenai idia hodoa mase, Lohiabada ese Mose ia oda henia hegeregerena. ");
INSERT INTO hmo_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Lohiabada ese Mose ia oda henia, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Israela taudia do oi hamaoroa edia dabua edia kona dekenai varo do idia hatua namonamo, herahera edia toana bamona. Bona inai herahera gaudia ta ta edia latanai varo ta, ena kala bulu do umui kwatua. Inai bamona do umui karaia noho, ela bona nega ibounai. ");
INSERT INTO hmo_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Inai herahera gaudia umui itaia neganai, be lau Lohiabada egu taravatu ibounai do umui laloa, bona kamonai henia. Unai bamona neganai, umui ese lau dekena amo do umui raka siri lasi, bona umui emui laloa bona ura sibona do umui karaia lasi. ");
INSERT INTO hmo_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","“Inai herahera gaudia dekena amo umui ese egu taravatu ibounai do umui laloaboio lasi, bona umui be lau, emui Dirava dekenai, do umui noho helaga momokani. ");
INSERT INTO hmo_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","“Lau be Lohiabada, emui Dirava. Aigupito dekena amo lau ese umui lau hakaua mai, emui Dirava do lau lao totona. Lau inai Lohiabada.” ");
INSERT INTO hmo_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora Isahara, Kohata Levi ena natuna, bona Rubena iduhu taudia, Datana Eliaba, bona Abirama Eliaba, bona Onu Pelete ese idia ura lasi Mose ena siahu henunai idia noho. ");
INSERT INTO hmo_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Idia ese tatau 250, lohia taudia, mai edia ladana bada taudia idia haboua, bona Mose dekenai idia lao. ");
INSERT INTO hmo_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Idia be Mose bona Arona edia vairanai idia haboua, bona idia dekenai idia heai henia, idia gwau, “Umui ruaosi ese mai hekokoroku danu ai umui gunalaia noho! Ai Israela taudia ibounai be Lohiabada ena bese, bona Lohiabada be aiemai huanai ia noho! Badina dahaka umui ruaosi ese mai siahu bada danu Lohiabada ena orea taudia umui biagua noho?” ");
INSERT INTO hmo_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mose ese unai hereva ia kamonai neganai, ia be tano dekenai ia moru diho, bona ia guriguri. ");
INSERT INTO hmo_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Vadaeni ia ese Kora bona iena orea taudia ia hamaoroa, ia gwau, “Kerukeru dabai Lohiabada ese do ia hedinaraia, daika be iena tau, daika be helaga, bona daika be ia ese ia abia hidi vadaeni, ia dekenai do ia raka kahirakahira lao, iena boubou patana dekenai. ");
INSERT INTO hmo_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","“Kora e, oi bona oiemu orea taudia be kerukeru dabai inai bamona do umui karaia: ");
INSERT INTO hmo_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Lahi huaia auri kapusi do umui abia, edia latanai lahi, bona bonana namo muramura do umui udaia, Lohiabada ena vairanai, boubou patana dekenai, do umui atodia. Kerukeru, Lohiabada ese ia abia hidi tauna, iena helaga tauna, be do ia hedinaraia. Umui Levi taudia e, umui be hari umui hekokoroku noho!” ");
INSERT INTO hmo_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mose ese Kora ma ia hereva henia, ia gwau, “Umui Levi taudia ese egu hereva do umui kamonai! ");
INSERT INTO hmo_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Israela ena Dirava ese umui ia abia hidi vadaeni, Israela taudia edia huana dekena amo, Lohiabada kahirakahira do umui raka, bona Lohiabada ena Palai Dubu gaukara do umui karaia. Bona Israela taudia edia vairanai do umui gini, idia edia hesiai gaukara do umui karaia totona. ");
INSERT INTO hmo_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","“Lohiabada ese umui, bona Levi taudia ibounai dekenai inai dagi badana ia henia vadaeni, to hari umui ura hahelagaia taudia edia dagi danu do umui abia, a? ");
INSERT INTO hmo_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","“Bema umui ese Arona dekenai umui maumau neganai, unai anina korikori be umui ese Lohiabada dekenai umui heai henia noho!” ");
INSERT INTO hmo_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Vadaeni Mose ese Datana Eliaba bona Abirama Eliaba ia boiria mai. To idia gwau, “Do ai mai lasi, ");
INSERT INTO hmo_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","oi ese Aigupito tano, aniani namo herea gabuna dekena amo ai oi hakaua mai, inai tano kaukau dekenai ai do oi alaia mase totona, a? Bona hari oi ura be aiemai lohia, a? ");
INSERT INTO hmo_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Oi ese tano namona ta, rata bona hani dekenai ia honu tano dekenai ai oi hakaua lasi momokani. Oi ese tano namona, mai ena vain audia be ai dekenai oi henia lasi. Oi laloa aiemai orea taudia oi koia diba, a? Ai be oi dekenai do ai mai lasi.” ");
INSERT INTO hmo_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mose ia badu dikadika, bona ia ese Lohiabada ia noia, ia gwau, “Inai taudia edia boubou ta do oi abia dae lasi. Lau ese idia ta lau hadikaia lasi, edia doniki ta danu be nega ta lau abia lasi.” ");
INSERT INTO hmo_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mose ese Kora ia hamaoroa, ia gwau, “Kerukeru oi bona oiemu orea taudia 250 be Palai Dubu dekenai do umui mai, Lohiabada ena vairanai do umui gini. Arona danu be unuseni do ia noho. ");
INSERT INTO hmo_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","“Umui ta ta ese emui lahi huaia auri kapusi, bona edia latanai bonana namo muramura danu do umui abia mai, bona boubou patana dekenai, Lohiabada ena vairanai do umui atoa.” ");
INSERT INTO hmo_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Vadaeni inai taudia ta ta ibounai ese edia lahi huaia auri kapusi idia abia, gida, bona mai bonana namo muramura be auri kapusi edia latanai idia atoa, bona Palai Dubu ena iduara dekenai idia gini, Mose bona Arona danu. ");
INSERT INTO hmo_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Unai neganai Kora ese Israela taudia ibounai ia haboua, bona idia be idia gini noho, Mose bona Arona edia vairanai, Palai Dubu ena iduara dekenai. Vadaeni karaharaga, nega tamona, Lohiabada ena diaridiari ia hedinarai, bona hebou taudia ibounai ese idia itaia. ");
INSERT INTO hmo_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Vadaeni Lohiabada ese Mose bona Arona ia hamaoroa, ia gwau, ");
INSERT INTO hmo_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Inai hebou taudia dekena amo do umui raka siri, bona lau ese idia do lau hadikaia ore.” ");
INSERT INTO hmo_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","To Mose bona Arona be tano dekenai edia vairana idia atoa diho, idia boiboi, idia gwau, “Dirava e, Dirava e, oi be taunimanima ibounai edia laumadia edia Dirava, tau tamona do ia kara dika neganai, inai hebou taudia ibounai do oi badu henia, a?” ");
INSERT INTO hmo_vpl VALUES